-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_149
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_149`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_149` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_149`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3215 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2604,20010,'',0,'22','1','149','PURCHASES','','2020-08-10 20:57:16',5,0.00,0.00,'','479','2020-08-10 20:57:16','479',0,1),(2605,400092,'',0,'24','1','149','PURCHASES','','2020-08-10 21:02:00',5,0.00,0.00,'','479','2020-08-10 21:02:00','479',0,1),(2606,20018,'',0,'20','1','149','SALES','','2020-08-10 22:00:04',5,0.00,0.00,'','479','2020-08-10 22:00:04','479',0,1),(2607,40017,'',0,'6.1','1','149','CASH','','2020-08-10 22:00:26',5,0.00,0.00,'','479','2020-08-10 22:00:26','479',0,1),(2608,400093,'',0,'24','1','149','SALARIES & WAGES','','2020-08-10 22:00:45',5,0.00,0.00,'','479','2020-08-10 22:00:45','479',0,1),(2609,400225,'',0,'2','1','149','ZBN(POS):1015965368','','2020-08-10 22:01:04',5,0.00,0.00,'','479','2020-08-10 22:01:04','479',0,1),(2610,400226,'',0,'2','1','149','ZB(E-BILL)1015372548','','2020-08-10 22:01:58',5,0.00,0.00,'','479','2020-08-10 22:01:58','479',0,1),(2660,400111,'',0,'24','1','149','OPERATIONAL LOSS','ALL LOSSES DURING SALES/RECEPTION','2020-08-13 14:05:41',5,0.00,0.00,'','479','2020-08-13 14:05:41','479',0,1),(2908,400325,'',0,'2','1','149','DANKANO-EBILLS(ZNB:1014717618)','','2020-10-29 14:00:43',5,0.00,0.00,'','489','2020-10-29 14:00:43','489',0,1),(3212,400491,'',0,'2','1','149','FID POS COLLECTION-5620141491','','2021-02-26 16:04:34',5,0.00,0.00,'','489','2021-02-26 16:04:34','489',0,1),(3213,400492,'',0,'2','1','149','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:19:42',5,0.00,0.00,'','792','2023-02-20 14:19:42','792',0,0),(3214,400493,'',0,'2','1','149','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:28:52',5,0.00,0.00,'2023-03-15','792','2023-03-17 12:34:14','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1611 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1609,'','1','149','OPERATIONAL LOSS','HAFIZ NURA GAYA','08069129774','hgaya@aaranonigeria.com','KANO','KANO','AA RANO HOUSE HOTORO KANO.','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 14:04:44',5,'479','2020-08-13 14:04:44','479'),(1610,'','1','149','OPERATIONAL LOST','BULK SALES','07055673456','@gmail.com','keffi','nasarawa','audueruvhfi','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-14 12:33:47',5,'506','2022-08-14 12:33:47','506');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16362 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','149',16361,'770',3974.78,1016.00,'2021-09-08','new dipping','2021-09-08 18:24:01','483','483',2021,'483','2021-09-08 18:24:01',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2143 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','149','770',2141,'5','LPG NOZZLE ',1064695.23,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','149','770',2142,'5','LPG NOZZLE 2',82834.32,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258089 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','149',146987,'DAILY SHIFT','2020-08-01','2020-08-01 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-12 13:00:26','506','2020-08-12 13:25:34',10,0),('1','149',147009,'DAILY SHIFT','2020-08-02','2020-08-02 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-12 13:38:58','506','2020-08-12 13:39:47',10,0),('1','149',147018,'DAILY SHIFT','2020-08-03','2020-08-03 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-12 14:05:10','506','2020-08-12 14:06:15',10,0),('1','149',147034,'DAILY SHIFT','2020-08-04','2020-08-04 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-12 14:09:51','506','2020-08-12 14:16:32',10,0),('1','149',147042,'DAILY SHIFT','2020-08-04','2020-08-04 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-12 15:40:17','506','2020-08-12 15:40:47',10,0),('1','149',147069,'DAILY SHIFT','2020-08-05','2020-08-05 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-12 15:51:15','506','2020-08-12 16:04:07',10,0),('1','149',147076,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-12 16:11:47','506','2020-08-12 16:13:45',10,0),('1','149',147095,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-12 17:08:49','506','2020-08-12 17:09:30',10,0),('1','149',147097,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-12 17:21:10','506','2020-08-12 17:21:51',10,0),('1','149',147101,'DAILY SHIFT','2020-08-07','2020-08-07 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-12 17:24:34','506','2020-08-12 17:26:34',10,0),('1','149',147104,'DAILY SHIFT','2020-08-07','2020-08-07 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-12 17:41:28','506','2020-08-12 17:41:45',10,0),('1','149',147155,'DAILY SHIFT','2020-08-08','2020-08-08 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-13 09:29:31','506','2020-08-13 09:30:01',10,0),('1','149',147158,'DAILY SHIFT','2020-08-09','2020-08-09 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-13 09:45:15','506','2020-08-13 09:45:47',10,0),('1','149',147162,'DAILY SHIFT','2020-08-11','2020-08-11 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-13 10:05:56','506','2020-08-13 10:26:26',10,0),('1','149',147178,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-13 10:37:19','506','2020-08-13 10:37:47',10,0),('1','149',147310,'DAILY SHIFT','2020-08-13','2020-08-13 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-13 21:01:36','506','2020-08-13 21:03:32',10,0),('1','149',147432,'DAILY SHIFT','2020-08-14','2020-08-14 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-14 20:57:11','506','2020-08-14 20:57:41',10,0),('1','149',147567,'DAILY SHIFT','2020-08-15','2020-08-15 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-15 21:42:58','506','2020-08-15 21:43:32',10,0),('1','149',147691,'DAILY SHIFT','2020-08-16','2020-08-16 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-16 20:59:50','506','2020-08-16 21:00:26',10,0),('1','149',147872,'DAILY SHIFT','2020-08-17','2020-08-17 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-17 20:58:49','506','2020-08-17 20:59:24',10,0),('1','149',147994,'DAILY SHIFT','2020-08-18','2020-08-18 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-18 20:53:18','506','2020-08-18 20:54:03',10,0),('1','149',148134,'DAILY SHIFT','2020-08-19','2020-08-19 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-19 20:58:43','506','2020-08-19 20:59:38',10,0),('1','149',148136,'DAILY SHIFT','2020-08-19','2020-08-19 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-19 21:17:38','506','2020-08-19 21:17:59',10,0),('1','149',148283,'DAILY SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-20 20:04:28','506','2020-08-20 20:04:57',10,0),('1','149',148434,'DAILY SHIFT','2020-08-21','2020-08-21 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-21 20:21:45','506','2020-08-21 20:22:06',10,0),('1','149',148564,'DAILY SHIFT','2020-08-22','2020-08-22 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-22 21:34:59','506','2020-08-22 21:37:51',10,0),('1','149',148705,'DAILY SHIFT','2020-08-23','2020-08-23 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-24 09:52:05','506','2020-08-24 09:52:39',10,0),('1','149',148813,'DAILY SHIFT','2020-08-24','2020-08-24 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-24 20:29:06','506','2020-08-24 20:29:46',10,0),('1','149',148969,'DAILY SHIFT','2020-08-25','2020-08-25 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-25 19:29:26','506','2020-08-25 19:29:46',10,0),('1','149',149150,'DAILY SHIFT','2020-08-26','2020-08-26 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-26 20:23:07','506','2020-08-26 20:23:48',10,0),('1','149',149309,'DAILY SHIFT','2020-08-27','2020-08-27 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-27 20:33:24','506','2020-08-27 20:33:48',10,0),('1','149',149464,'DAILY SHIFT','2020-08-28','2020-08-28 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-28 20:02:21','506','2020-08-28 20:02:51',10,0),('1','149',149602,'DAILY SHIFT','2020-08-29','2020-08-29 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-29 21:34:06','506','2020-08-29 21:34:27',10,0),('1','149',149694,'DAILY SHIFT','2020-08-30','2020-08-30 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-30 20:00:40','506','2020-08-30 20:01:11',10,0),('1','149',149860,'DAILY SHIFT','2020-08-31','2020-08-31 00:00:00',NULL,'506',0.00,0.00,'506','2020-08-31 21:14:13','506','2020-08-31 21:14:45',10,0),('1','149',150013,'DAILY SHIFT','2020-09-01','2020-09-01 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-01 20:53:36','506','2020-09-01 20:54:02',10,0),('1','149',150014,'DAILY SHIFT','2020-09-01','2020-09-01 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-01 21:08:30','506','2020-09-01 21:08:54',10,0),('1','149',150165,'DAILY SHIFT','2020-09-02','2020-09-02 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-02 21:59:38','506','2020-09-02 22:00:04',10,0),('1','149',150389,'DAILY SHIFT','2020-09-03','2020-09-03 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-03 20:41:03','506','2020-09-03 20:41:38',10,0),('1','149',150541,'DAILY SHIFT','2020-09-04','2020-09-04 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-04 18:19:35','506','2020-09-04 18:20:02',10,0),('1','149',150887,'DAILY SHIFT','2020-09-06','2020-09-06 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-07 10:46:40','506','2020-09-07 10:47:01',10,0),('1','149',150981,'DAILY SHIFT','2020-09-07','2020-09-07 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-07 18:14:30','506','2020-09-07 18:14:59',10,0),('1','149',151152,'DAILY SHIFT','2020-09-08','2020-09-08 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-08 20:14:14','506','2020-09-08 20:14:37',10,0),('1','149',151284,'DAILY SHIFT','2020-09-09','2020-09-09 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-09 20:05:01','506','2020-09-09 20:05:21',10,0),('1','149',151433,'DAILY SHIFT','2020-09-10','2020-09-10 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-10 20:02:53','506','2020-09-10 20:03:21',10,0),('1','149',151592,'DAILY SHIFT','2020-09-11','2020-09-11 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-11 21:28:39','506','2020-09-11 21:29:02',10,0),('1','149',151702,'DAILY SHIFT','2020-09-12','2020-09-12 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-12 20:32:17','506','2020-09-12 20:32:48',10,0),('1','149',152022,'DAILY SHIFT','2020-09-14','2020-09-14 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-14 21:07:16','506','2020-09-14 21:07:46',10,0),('1','149',152166,'DAILY SHIFT','2020-09-15','2020-09-15 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-15 22:18:40','506','2020-09-15 22:19:00',10,0),('1','149',152317,'DAILY SHIFT','2020-09-16','2020-09-16 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-16 18:27:54','506','2020-09-16 18:28:20',10,0),('1','149',152528,'DAILY','2020-09-18','2020-09-18 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-18 11:42:11','506','2020-09-18 11:42:40',10,0),('1','149',152765,'DAILY','2020-09-19','2020-09-19 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-19 20:42:07','506','2020-09-19 20:43:41',10,0),('1','149',152879,'DAILY','2020-09-20','2020-09-20 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-20 17:41:09','506','2020-09-20 17:45:43',10,0),('1','149',152880,'DAILY','2020-09-20','2020-09-20 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-20 17:49:36','506','2020-09-20 17:50:03',10,0),('1','149',153102,'DAILY','2020-09-22','2020-09-22 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-22 07:24:08','506','2020-09-22 07:24:35',10,0),('1','149',153263,'DAILY','2020-09-22','2020-09-22 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-22 19:20:21','506','2020-09-22 19:20:45',10,0),('1','149',153464,'DAILY','2020-09-23','2020-09-23 00:00:00',NULL,'506',0.00,0.00,'506','2020-09-23 18:10:40','506','2020-09-23 18:11:01',10,0),('1','149',155132,'DAILY','2020-10-04','2020-10-04 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-04 19:48:07','506','2020-10-04 19:49:48',10,0),('1','149',155296,'DAILY','2020-10-05','2020-10-05 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-05 18:30:15','506','2020-10-05 18:30:56',10,0),('1','149',155478,'DAILY','2020-10-06','2020-10-06 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-07 08:43:38','506','2020-10-07 08:44:16',10,0),('1','149',155761,'Daily','2020-10-08','2020-10-08 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-08 17:19:29','506','2020-10-08 17:20:00',10,0),('1','149',155917,'DAILY','2020-10-09','2020-10-09 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-09 18:14:39','506','2020-10-09 18:15:19',10,0),('1','149',156070,'DAILY','2020-10-10','2020-10-10 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-10 18:02:18','506','2020-10-10 18:03:06',10,0),('1','149',156292,'DAILY','2020-10-12','2020-10-12 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-12 11:33:32','506','2020-10-12 11:34:06',10,0),('1','149',156553,'DAILY','2020-10-13','2020-10-13 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-13 17:42:09','506','2020-10-13 17:42:39',10,0),('1','149',156725,'DAILY','2020-10-14','2020-10-14 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-14 17:54:39','506','2020-10-14 17:55:10',10,0),('1','149',156892,'DAILY','2020-10-15','2020-10-15 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-15 18:19:19','506','2020-10-15 18:20:02',10,0),('1','149',157070,'DAILY','2020-10-16','2020-10-16 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-16 18:08:46','506','2020-10-16 18:09:33',10,0),('1','149',157271,'DAILY','2020-10-17','2020-10-17 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-17 19:30:55','506','2020-10-17 19:31:32',10,0),('1','149',157438,'DAILY','2020-10-18','2020-10-18 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-18 17:57:01','506','2020-10-18 17:57:47',10,0),('1','149',157639,'DAILY','2020-10-19','2020-10-19 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-19 18:13:20','506','2020-10-19 18:14:03',10,0),('1','149',157781,'DAILY','2020-10-20','2020-10-20 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-20 15:53:44','506','2020-10-20 15:54:14',10,0),('1','149',158020,'Daily','2020-10-22','2020-10-22 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-22 12:22:51','506','2020-10-22 12:23:13',10,0),('1','149',158083,'DAILY','2020-10-22','2020-10-22 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-22 18:54:50','506','2020-10-22 18:55:21',10,0),('1','149',158249,'DAILY','2020-10-23','2020-10-23 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-23 17:56:54','506','2020-10-23 17:57:29',10,0),('1','149',158415,'DAILY','2020-10-24','2020-10-24 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-24 18:18:22','506','2020-10-24 18:19:07',10,0),('1','149',158567,'DAILY','2020-10-25','2020-10-25 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-25 18:09:28','506','2020-10-25 18:10:32',10,0),('1','149',158569,'DAILY','2020-10-25','2020-10-25 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-25 18:21:49','506','2020-10-25 18:22:26',10,0),('1','149',158741,'DAILY','2020-10-26','2020-10-26 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-26 18:01:07','506','2020-10-26 18:01:34',10,0),('1','149',158930,'DAILY','2020-10-27','2020-10-27 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-27 18:07:01','506','2020-10-27 18:07:30',10,0),('1','149',158931,'DAILY','2020-10-27','2020-10-27 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-27 18:11:01','506','2020-10-27 18:11:32',10,0),('1','149',159056,'DAILY','2020-10-28','2020-10-28 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-28 14:18:15','506','2020-10-28 14:18:43',10,0),('1','149',159449,'DAILY','2020-10-30','2020-10-30 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-30 18:25:44','506','2020-10-30 18:26:08',10,0),('1','149',159632,'DAILY','2020-10-31','2020-10-31 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-31 19:29:15','506','2020-10-31 19:29:52',10,0),('1','149',159633,'DAILY','2020-10-31','2020-10-31 00:00:00',NULL,'506',0.00,0.00,'506','2020-10-31 19:37:01','506','2020-10-31 19:38:32',10,0),('1','149',159733,'DAILY','2020-11-01','2020-11-01 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-01 18:56:43','506','2020-11-01 18:57:12',10,0),('1','149',159941,'DAILY','2020-11-02','2020-11-02 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-02 18:51:37','506','2020-11-02 18:52:36',10,0),('1','149',160111,'DAILY','2020-11-03','2020-11-03 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-03 17:27:04','506','2020-11-03 17:27:28',10,0),('1','149',160305,'Daily','2020-11-04','2020-11-04 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-04 18:11:37','506','2020-11-04 18:12:19',10,0),('1','149',160477,'Daily','2020-11-06','2020-11-06 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-06 08:32:39','506','2020-11-06 08:33:09',10,0),('1','149',160478,'Daily','2020-11-06','2020-11-06 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-07 14:45:38','506','2020-11-07 14:45:59',10,0),('1','149',160720,'Daily','2020-11-06','2020-11-06 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-07 15:21:28','506','2020-11-07 15:22:01',10,0),('1','149',160740,'Daily','2020-11-07','2020-11-07 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-07 18:14:59','506','2020-11-07 18:15:38',10,0),('1','149',160883,'Daily','2020-11-08','2020-11-08 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-08 17:53:01','506','2020-11-08 17:53:29',10,0),('1','149',161098,'Daily','2020-11-09','2020-11-09 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-09 19:42:27','506','2020-11-09 19:43:01',10,0),('1','149',161291,'DAILY','2020-11-11','2020-11-11 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-11 05:11:06','506','2020-11-11 05:11:39',10,0),('1','149',161445,'DAILY','2020-11-11','2020-11-11 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-11 17:52:56','506','2020-11-11 17:53:55',10,0),('1','149',161647,'DAILY','2020-11-12','2020-11-12 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-12 17:20:15','506','2020-11-12 17:20:44',10,0),('1','149',161846,'DAILY','2020-11-13','2020-11-13 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-13 17:16:46','506','2020-11-13 17:17:46',10,0),('1','149',162031,'DAILY','2020-11-14','2020-11-14 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-14 17:14:41','506','2020-11-14 17:15:10',10,0),('1','149',162131,'DAILY','2020-11-15','2020-11-15 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-15 12:50:23','506','2020-11-15 12:50:57',10,0),('1','149',162448,'DAILY','2020-11-16','2020-11-16 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-16 18:13:13','506','2020-11-16 18:13:47',10,0),('1','149',162634,'DAILY','2020-11-17','2020-11-17 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-17 17:22:56','506','2020-11-17 17:23:26',10,0),('1','149',162792,'DAILY','2020-11-18','2020-11-18 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-18 17:25:05','506','2020-11-18 17:25:32',10,0),('1','149',162993,'DAILY','2020-11-19','2020-11-19 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-19 17:13:01','506','2020-11-19 17:13:25',10,0),('1','149',163278,'DAILY','2020-11-20','2020-11-20 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-21 11:01:33','506','2020-11-21 11:02:00',10,0),('1','149',163281,'DAILY','2020-11-20','2020-11-20 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-21 11:19:34','506','2020-11-21 11:20:11',10,0),('1','149',163361,'Daily','2020-11-21','2020-11-21 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-21 17:23:21','506','2020-11-21 17:23:42',10,0),('1','149',163534,'Daily','2020-11-22','2020-11-22 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-22 17:18:07','506','2020-11-22 17:18:29',10,0),('1','149',163734,'DAILY','2020-11-23','2020-11-23 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-23 17:58:50','506','2020-11-23 17:59:17',10,0),('1','149',163883,'Daily','2020-11-24','2020-11-24 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-24 16:22:41','506','2020-11-24 16:23:10',10,0),('1','149',164074,'Daily','2020-11-25','2020-11-25 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-25 17:18:15','506','2020-11-25 17:18:43',10,0),('1','149',164245,'Daily','2020-11-26','2020-11-26 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-26 17:23:53','506','2020-11-26 17:24:40',10,0),('1','149',164426,'Daily','2020-11-27','2020-11-27 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-27 17:11:34','506','2020-11-27 17:11:55',10,0),('1','149',164586,'Daily','2020-11-28','2020-11-28 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-28 17:42:49','506','2020-11-28 17:43:14',10,0),('1','149',164728,'DAILY','2020-11-29','2020-11-29 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-29 16:42:53','506','2020-11-29 16:43:59',10,0),('1','149',164954,'Daily','2020-11-30','2020-11-30 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-30 17:28:06','506','2020-11-30 17:29:04',10,0),('1','149',164955,'Daily','2020-11-30','2020-11-30 00:00:00',NULL,'506',0.00,0.00,'506','2020-11-30 17:32:36','506','2020-11-30 17:33:02',10,0),('1','149',165120,'Daily','2020-12-01','2020-12-01 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-01 17:58:37','506','2020-12-01 17:58:58',10,0),('1','149',165287,'Daily','2020-12-02','2020-12-02 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-02 17:32:45','506','2020-12-02 17:33:10',10,0),('1','149',165427,'DAILY','2020-12-03','2020-12-03 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-03 16:06:53','506','2020-12-03 16:07:48',10,0),('1','149',165596,'Daily','2020-12-04','2020-12-04 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-04 17:22:10','506','2020-12-04 17:22:40',10,0),('1','149',165790,'DAILY','2020-12-05','2020-12-05 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-05 18:08:44','506','2020-12-05 18:09:11',10,0),('1','149',165919,'DAILY','2020-12-06','2020-12-06 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-06 17:49:10','506','2020-12-06 17:49:49',10,0),('1','149',166130,'DAILY','2020-12-07','2020-12-07 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-07 17:38:03','506','2020-12-07 17:38:35',10,0),('1','149',166306,'DAILY','2020-12-08','2020-12-08 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-08 17:29:20','506','2020-12-08 17:29:52',10,0),('1','149',166466,'DAILY','2020-12-09','2020-12-09 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-09 17:16:52','506','2020-12-09 17:17:33',10,0),('1','149',166684,'DAILY','2020-12-10','2020-12-10 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-10 17:26:18','506','2020-12-10 17:26:40',10,0),('1','149',166872,'DAILY','2020-12-11','2020-12-11 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-11 17:20:36','506','2020-12-11 17:24:55',10,0),('1','149',167022,'DAILY','2020-12-12','2020-12-12 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-12 17:26:16','506','2020-12-12 17:26:49',10,0),('1','149',167024,'DAILY','2020-12-12','2020-12-12 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-12 17:36:40','506','2020-12-12 17:37:10',10,0),('1','149',167169,'DAILY','2020-12-13','2020-12-13 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-13 17:17:52','506','2020-12-13 17:18:21',10,0),('1','149',167352,'DAILY','2020-12-14','2020-12-14 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-14 17:15:32','506','2020-12-14 17:15:57',10,0),('1','149',167557,'DAILY','2020-12-15','2020-12-15 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-15 17:19:54','506','2020-12-15 17:20:32',10,0),('1','149',167727,'DAILY','2020-12-16','2020-12-16 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-16 18:02:51','506','2020-12-16 18:03:12',10,0),('1','149',167910,'Daily','2020-12-17','2020-12-17 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-17 18:24:17','506','2020-12-17 18:24:49',10,0),('1','149',168102,'Daily','2020-12-18','2020-12-18 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-18 18:02:02','506','2020-12-18 18:02:51',10,0),('1','149',168280,'DAILY','2020-12-19','2020-12-19 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-19 18:10:16','506','2020-12-19 18:10:47',10,0),('1','149',168399,'Daily','2020-12-20','2020-12-20 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-20 17:10:06','506','2020-12-20 17:10:27',10,0),('1','149',168600,'Daily','2020-12-21','2020-12-21 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-21 18:05:13','506','2020-12-21 18:05:39',10,0),('1','149',168760,'DAILY','2020-12-22','2020-12-22 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-22 17:37:56','506','2020-12-22 17:38:18',10,0),('1','149',168932,'Daily','2020-12-23','2020-12-23 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-23 18:42:45','506','2020-12-23 18:43:15',10,0),('1','149',169090,'Daily','2020-12-24','2020-12-24 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-24 18:21:17','506','2020-12-24 18:21:48',10,0),('1','149',169243,'Daily','2020-12-25','2020-12-25 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-25 16:33:05','506','2020-12-25 16:33:27',10,0),('1','149',169253,'Daily','2020-12-25','2020-12-25 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-25 17:24:13','506','2020-12-25 17:24:44',10,0),('1','149',169426,'Daily','2020-12-26','2020-12-26 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-26 17:27:50','506','2020-12-26 17:28:09',10,0),('1','149',169558,'Daily','2020-12-27','2020-12-27 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-27 17:24:25','506','2020-12-27 17:24:48',10,0),('1','149',169747,'Daily','2020-12-28','2020-12-28 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-28 16:06:47','506','2020-12-28 16:07:12',10,0),('1','149',169908,'Daily','2020-12-29','2020-12-29 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-29 17:14:28','506','2020-12-29 17:16:24',10,0),('1','149',170109,'Daily','2020-12-30','2020-12-30 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-30 17:12:51','506','2020-12-30 17:13:10',10,0),('1','149',170316,'Daily','2020-12-31','2020-12-31 00:00:00',NULL,'506',0.00,0.00,'506','2020-12-31 17:35:20','506','2020-12-31 17:35:40',10,0),('1','149',170458,'Daily','2021-01-01','2021-01-01 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-01 15:47:28','506','2021-01-01 15:47:52',10,0),('1','149',170641,'Daily','2021-01-02','2021-01-02 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-02 17:35:49','506','2021-01-02 17:36:11',10,0),('1','149',170804,'DAILY','2021-01-03','2021-01-03 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-03 17:26:08','506','2021-01-03 17:26:36',10,0),('1','149',170909,'Daily','2021-01-04','2021-01-04 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-04 12:59:47','506','2021-01-04 13:00:24',10,0),('1','149',170980,'Daily','2021-01-04','2021-01-04 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-04 18:42:40','506','2021-01-04 18:43:04',10,0),('1','149',171198,'Daily','2021-01-05','2021-01-05 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-05 17:55:30','506','2021-01-05 17:55:51',10,0),('1','149',171352,'Daily','2021-01-06','2021-01-06 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-06 17:22:35','506','2021-01-06 17:23:04',10,0),('1','149',171570,'Daily','2021-01-07','2021-01-07 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-07 17:14:27','506','2021-01-07 17:15:24',10,0),('1','149',171751,'Daily','2021-01-08','2021-01-08 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-08 17:14:32','506','2021-01-08 17:14:52',10,0),('1','149',171982,'Daily','2021-01-09','2021-01-09 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-10 09:16:53','506','2021-01-10 09:17:24',10,0),('1','149',172078,'Daily','2021-01-10','2021-01-10 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-10 18:44:01','506','2021-01-10 18:44:35',10,0),('1','149',172268,'Daily','2021-01-11','2021-01-11 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-11 18:21:14','506','2021-01-11 18:21:35',10,0),('1','149',172484,'Daily','2021-01-12','2021-01-12 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-12 18:22:39','506','2021-01-12 18:23:15',10,0),('1','149',172694,'Daily','2021-01-13','2021-01-13 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-13 18:29:38','506','2021-01-13 18:30:03',10,0),('1','149',172861,'Daily','2021-01-14','2021-01-14 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-14 18:10:58','506','2021-01-14 18:11:40',10,0),('1','149',173036,'Daily','2021-01-15','2021-01-15 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-15 17:20:22','506','2021-01-15 17:20:53',10,0),('1','149',173200,'Daily','2021-01-16','2021-01-16 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-16 18:14:05','506','2021-01-16 18:14:29',10,0),('1','149',173362,'Daily','2021-01-17','2021-01-17 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-17 18:13:01','506','2021-01-17 18:13:20',10,0),('1','149',173661,'Daily','2021-01-18','2021-01-18 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-19 11:03:13','506','2021-01-19 11:03:45',10,0),('1','149',173752,'Daily','2021-01-19','2021-01-19 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-19 18:29:29','506','2021-01-19 18:29:51',10,0),('1','149',173894,'Daily','2021-01-20','2021-01-20 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-20 14:31:57','506','2021-01-20 14:32:21',10,0),('1','149',174117,'Daily','2021-01-21','2021-01-21 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-21 18:21:48','506','2021-01-21 18:22:12',10,0),('1','149',174303,'Daily','2021-01-22','2021-01-22 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-22 18:14:43','506','2021-01-22 18:15:04',10,0),('1','149',174392,'Daily','2021-01-23','2021-01-23 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-23 11:09:39','506','2021-01-23 11:23:17',10,0),('1','149',174399,'Daily','2021-01-23','2021-01-23 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-23 11:26:55','506','2021-01-23 11:27:25',10,0),('1','149',174481,'Daily','2021-01-23','2021-01-23 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-23 19:05:33','506','2021-01-23 19:05:56',10,0),('1','149',174633,'Daily','2021-01-24','2021-01-24 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-24 19:01:10','506','2021-01-24 19:01:32',10,0),('1','149',174814,'Daily','2021-01-25','2021-01-25 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-25 16:28:50','506','2021-01-25 16:29:18',10,0),('1','149',174839,'Daily','2021-01-25','2021-01-25 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-25 19:05:20','506','2021-01-25 19:05:42',10,0),('1','149',175030,'Daily','2021-01-26','2021-01-26 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-26 18:40:44','506','2021-01-26 18:41:01',10,0),('1','149',175144,'Daily','2021-01-27','2021-01-27 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-27 12:42:12','506','2021-01-27 12:42:30',10,0),('1','149',175231,'Daily','2021-01-27','2021-01-27 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-27 19:09:16','506','2021-01-27 19:09:38',10,0),('1','149',175405,'Daily','2021-01-28','2021-01-28 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-28 19:01:09','506','2021-01-28 19:01:56',10,0),('1','149',175633,'Daily','2021-01-29','2021-01-29 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-30 10:18:45','506','2021-01-30 10:19:06',10,0),('1','149',175843,'Daily','2021-01-30','2021-01-30 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-31 13:07:03','506','2021-01-31 13:07:53',10,0),('1','149',175911,'Daily','2021-01-31','2021-01-31 00:00:00',NULL,'506',0.00,0.00,'506','2021-01-31 19:22:42','506','2021-01-31 19:22:59',10,0),('1','149',176059,'Daily','2021-02-01','2021-02-01 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-01 13:57:31','506','2021-02-01 13:58:32',10,0),('1','149',176319,'Daily','2021-02-02','2021-02-02 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-02 19:30:57','506','2021-02-02 19:31:26',10,0),('1','149',176508,'Daily','2021-02-03','2021-02-03 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-03 16:39:25','506','2021-02-03 16:40:13',10,0),('1','149',176761,'Daily','2021-02-04','2021-02-04 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-04 19:40:21','506','2021-02-04 19:41:04',10,0),('1','149',176762,'Daily','2021-02-04','2021-02-04 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-04 19:46:13','506','2021-02-04 19:46:38',10,0),('1','149',176970,'Daily','2021-02-05','2021-02-05 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-05 19:36:30','506','2021-02-05 19:36:48',10,0),('1','149',177210,'Daily','2021-02-06','2021-02-06 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-06 19:02:01','506','2021-02-06 19:02:37',10,0),('1','149',177411,'Daily','2021-02-07','2021-02-07 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-07 19:02:19','506','2021-02-07 19:02:41',10,0),('1','149',177614,'DAILY','2021-02-08','2021-02-08 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-08 19:31:02','506','2021-02-08 19:31:32',10,0),('1','149',177864,'DAILY','2021-02-09','2021-02-09 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-09 18:39:40','506','2021-02-09 18:40:17',10,0),('1','149',178053,'Daily','2021-02-10','2021-02-10 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-10 18:34:04','506','2021-02-10 18:34:22',10,0),('1','149',178270,'Daily','2021-02-11','2021-02-11 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-11 18:34:24','506','2021-02-11 18:34:50',10,0),('1','149',178334,'DAILY','2021-02-12','2021-02-12 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-12 09:35:21','506','2021-02-12 09:35:43',10,0),('1','149',178463,'Daily','2021-02-12','2021-02-12 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-12 18:09:48','506','2021-02-12 18:10:09',10,0),('1','149',178695,'DAILY','2021-02-13','2021-02-13 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-13 18:23:33','506','2021-02-13 18:24:05',10,0),('1','149',178871,'Daily','2021-02-14','2021-02-14 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-14 18:28:02','506','2021-02-14 18:28:29',10,0),('1','149',178987,'DAILY','2021-02-15','2021-02-15 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-15 10:27:01','506','2021-02-15 10:27:38',10,0),('1','149',179079,'DAILY shift','2021-02-15','2021-02-15 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-15 18:37:10','506','2021-02-15 18:37:44',10,0),('1','149',179158,'DAILY','2021-02-16','2021-02-16 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-16 18:35:58','506','2021-02-16 18:36:24',10,0),('1','149',179375,'DAILY','2021-02-17','2021-02-17 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-17 18:34:00','506','2021-02-17 18:34:36',10,0),('1','149',179580,'DAILY shift','2021-02-18','2021-02-18 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-18 16:55:47','506','2021-02-18 16:56:18',10,0),('1','149',179815,'Daily','2021-02-19','2021-02-19 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-19 17:53:48','506','2021-02-19 17:54:17',10,0),('1','149',180010,'DAILY','2021-02-20','2021-02-20 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-20 18:27:05','506','2021-02-20 18:27:36',10,0),('1','149',180182,'DAILY','2021-02-21','2021-02-21 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-21 14:58:53','506','2021-02-21 14:59:28',10,0),('1','149',180277,'DAILY','2021-02-21','2021-02-21 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-21 17:42:35','506','2021-02-21 17:43:08',10,0),('1','149',180348,'DAILY','2021-02-22','2021-02-22 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-23 06:15:45','506','2021-02-23 06:16:15',10,0),('1','149',180553,'Daily ','2021-02-23','2021-02-23 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-23 17:35:47','506','2021-02-23 17:36:20',10,0),('1','149',180749,'DAILY','2021-02-24','2021-02-24 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-24 18:19:30','506','2021-02-24 18:19:57',10,0),('1','149',180983,'DAILY','2021-02-25','2021-02-25 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-25 09:25:32','506','2021-02-25 09:26:12',10,0),('1','149',180999,'DAILY','2021-02-25','2021-02-25 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-25 17:52:25','506','2021-02-25 17:53:03',10,0),('1','149',181145,'DAILY shift','2021-02-26','2021-02-26 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-26 17:49:08','506','2021-02-26 17:49:39',10,0),('1','149',181348,'DAILY','2021-02-27','2021-02-27 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-27 18:08:01','506','2021-02-27 18:08:34',10,0),('1','149',181535,'DAILY','2021-02-28','2021-02-28 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-28 10:00:01','506','2021-02-28 10:00:36',10,0),('1','149',181584,'DAILY','2021-02-28','2021-02-28 00:00:00',NULL,'506',0.00,0.00,'506','2021-02-28 17:49:45','506','2021-02-28 17:50:38',10,0),('1','149',181727,'DAILY','2021-03-01','2021-03-01 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-01 18:08:53','506','2021-03-01 18:09:45',10,0),('1','149',181946,'DAILY','2021-03-02','2021-03-02 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-02 18:33:32','506','2021-03-02 18:34:00',10,0),('1','149',182122,'DAILY','2021-03-03','2021-03-03 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-03 08:27:33','506','2021-03-03 08:28:04',10,0),('1','149',182153,'DAILY','2021-03-03','2021-03-03 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-03 18:55:50','506','2021-03-03 18:56:22',10,0),('1','149',182322,'DAILY','2021-03-04','2021-03-04 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-04 18:11:08','506','2021-03-04 18:12:47',10,0),('1','149',182511,'DAILY','2021-03-05','2021-03-05 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-05 14:26:27','506','2021-03-05 14:26:57',10,0),('1','149',182616,'DAILY','2021-03-05','2021-03-05 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-05 15:29:32','506','2021-03-05 15:29:52',10,0),('1','149',182627,'Daily','2021-03-05','2021-03-05 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-08 12:46:29','506','2021-03-08 12:47:02',10,0),('1','149',183104,'DAILY','2021-03-08','2021-03-08 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-08 13:10:41','506','2021-03-08 13:11:19',10,0),('1','149',183113,'DAILY','2021-03-08','2021-03-08 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-08 13:16:39','506','2021-03-08 13:17:11',10,0),('1','149',183117,'DAILY','2021-03-08','2021-03-08 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-08 19:28:09','506','2021-03-08 19:29:30',10,0),('1','149',183238,'DAILY','2021-03-09','2021-03-09 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-09 09:30:39','506','2021-03-09 09:31:05',10,0),('1','149',183289,'DAILY','2021-03-09','2021-03-09 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-09 18:24:12','506','2021-03-09 18:24:42',10,0),('1','149',183465,'DAILY','2021-03-10','2021-03-10 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-10 17:40:29','506','2021-03-10 17:40:57',10,0),('1','149',183679,'DAILY','2021-03-11','2021-03-11 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-11 17:48:06','506','2021-03-11 17:48:35',10,0),('1','149',183918,'DAILY','2021-03-12','2021-03-12 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-13 09:04:19','506','2021-03-13 09:27:55',10,0),('1','149',184076,'DAILY','2021-03-13','2021-03-13 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-13 09:35:46','506','2021-03-13 09:36:09',10,0),('1','149',184132,'DAILY','2021-03-13','2021-03-13 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-13 18:11:30','506','2021-03-13 18:12:00',10,0),('1','149',184298,'DAILY','2021-03-14','2021-03-14 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-14 17:53:57','506','2021-03-14 17:54:36',10,0),('1','149',184472,'DAILY','2021-03-15','2021-03-15 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-15 17:52:11','506','2021-03-15 17:52:51',10,0),('1','149',184700,'Daily ','2021-03-16','2021-03-16 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-16 14:48:04','506','2021-03-16 14:48:35',10,0),('1','149',185221,'Daily','2021-03-18','2021-03-18 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-18 17:45:29','506','2021-03-18 17:45:58',10,0),('1','149',185267,'Daily','2021-03-19','2021-03-19 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-19 17:46:03','506','2021-03-19 17:46:28',10,0),('1','149',185493,'Daily','2021-03-20','2021-03-20 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-20 18:02:36','506','2021-03-20 18:03:14',10,0),('1','149',185691,'Daily','2021-03-21','2021-03-21 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-21 18:01:56','506','2021-03-21 18:02:30',10,0),('1','149',185918,'DAILY','2021-03-22','2021-03-22 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-22 09:35:06','506','2021-03-22 09:35:37',10,0),('1','149',185946,'DAILY','2021-03-22','2021-03-22 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-22 18:10:25','506','2021-03-22 18:10:49',10,0),('1','149',186097,'Daily ','2021-03-23','2021-03-23 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-23 18:06:33','506','2021-03-23 18:07:56',10,0),('1','149',186331,'Daily','2021-03-24','2021-03-24 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-24 18:10:31','506','2021-03-24 18:11:06',10,0),('1','149',186547,'Daily','2021-03-25','2021-03-25 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-25 12:03:35','506','2021-03-25 12:04:20',10,0),('1','149',186639,'DAILY','2021-03-25','2021-03-25 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-25 17:47:38','506','2021-03-25 17:48:10',10,0),('1','149',186776,'Daily','2021-03-26','2021-03-26 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-26 17:47:25','506','2021-03-26 17:48:03',10,0),('1','149',187003,'DAILY','2021-03-27','2021-03-27 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-27 17:53:57','506','2021-03-27 17:54:25',10,0),('1','149',187164,'Daily','2021-03-28','2021-03-28 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-28 17:46:49','506','2021-03-28 17:47:41',10,0),('1','149',187470,'Daily','2021-03-29','2021-03-29 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-29 17:47:23','506','2021-03-29 17:47:59',10,0),('1','149',187673,'DAILY','2021-03-30','2021-03-30 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-30 17:39:00','506','2021-03-30 17:39:31',10,0),('1','149',187873,'Daily','2021-03-31','2021-03-31 00:00:00',NULL,'506',0.00,0.00,'506','2021-03-31 17:30:04','506','2021-03-31 17:30:48',10,0),('1','149',188052,'DAILY','2021-04-01','2021-04-01 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-01 17:43:11','506','2021-04-01 17:43:40',10,0),('1','149',188284,'Daily ','2021-04-02','2021-04-02 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-02 18:11:30','506','2021-04-02 18:11:59',10,0),('1','149',188432,'Daily','2021-04-03','2021-04-03 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-03 10:14:39','506','2021-04-03 10:15:06',10,0),('1','149',188662,'DAILY','2021-04-04','2021-04-04 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-04 17:51:31','506','2021-04-04 17:52:02',10,0),('1','149',188842,'Daily','2021-04-05','2021-04-05 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-05 18:06:08','506','2021-04-05 18:06:43',10,0),('1','149',189066,'DAILY','2021-04-06','2021-04-06 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-06 18:09:37','506','2021-04-06 18:11:05',10,0),('1','149',189213,'DAILY','2021-04-07','2021-04-07 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-07 18:11:02','506','2021-04-07 18:11:33',10,0),('1','149',189458,'DAILY','2021-04-08','2021-04-08 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-08 17:46:40','506','2021-04-08 17:48:11',10,0),('1','149',189692,'DAILY','2021-04-09','2021-04-09 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-09 17:45:51','506','2021-04-09 17:46:25',10,0),('1','149',189873,'DAILY','2021-04-10','2021-04-10 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-10 10:03:26','506','2021-04-10 10:04:37',10,0),('1','149',189881,'DAILY','2021-04-10','2021-04-10 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-10 18:00:23','506','2021-04-10 18:00:51',10,0),('1','149',190079,'DAILY','2021-04-11','2021-04-11 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-11 17:26:00','506','2021-04-11 17:26:48',10,0),('1','149',190254,'DAILY','2021-04-12','2021-04-12 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-12 18:51:40','506','2021-04-12 18:52:53',10,0),('1','149',190504,'DAILY','2021-04-13','2021-04-13 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-13 10:22:10','506','2021-04-13 10:22:38',10,0),('1','149',190536,'DAILY','2021-04-13','2021-04-13 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-13 18:28:52','506','2021-04-13 18:29:38',10,0),('1','149',190683,'DAILY','2021-04-14','2021-04-14 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-14 18:37:36','506','2021-04-14 18:38:42',10,0),('1','149',190908,'DAILY','2021-04-15','2021-04-15 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-15 17:07:51','506','2021-04-15 17:08:26',10,0),('1','149',191179,'DAILY','2021-04-16','2021-04-16 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-16 18:04:27','506','2021-04-16 18:05:24',10,0),('1','149',191284,'DAILY','2021-04-17','2021-04-17 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-17 21:30:31','506','2021-04-17 21:31:13',10,0),('1','149',191491,'DAILY shift','2021-04-18','2021-04-18 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-18 18:16:39','506','2021-04-18 18:17:34',10,0),('1','149',191701,'DAILY shift','2021-04-19','2021-04-19 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-19 12:30:41','506','2021-04-19 12:31:09',10,0),('1','149',191877,'DAILY','2021-04-19','2021-04-19 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-20 08:03:28','506','2021-04-20 08:04:08',10,0),('1','149',191960,'DAILY shift','2021-04-20','2021-04-20 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-20 18:17:36','506','2021-04-20 18:19:04',10,0),('1','149',192202,'DAILY','2021-04-21','2021-04-21 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-21 18:23:17','506','2021-04-21 18:24:02',10,0),('1','149',192348,'DAILY','2021-04-22','2021-04-22 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-22 18:28:56','506','2021-04-22 18:29:29',10,0),('1','149',192568,'DAILY shift','2021-04-23','2021-04-23 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-23 10:23:16','506','2021-04-23 10:23:51',10,0),('1','149',192671,'DAILY','2021-04-23','2021-04-23 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-24 06:05:02','506','2021-04-24 06:05:35',10,0),('1','149',192750,'DAILY shift','2021-04-24','2021-04-24 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-24 21:00:44','506','2021-04-24 21:01:20',10,0),('1','149',193006,'DAILY','2021-04-25','2021-04-25 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-25 20:56:01','506','2021-04-25 20:56:42',10,0),('1','149',193274,'DAILY','2021-04-26','2021-04-26 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-27 08:42:56','506','2021-04-27 08:43:24',10,0),('1','149',193447,'DAILY','2021-04-27','2021-04-27 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-27 17:47:34','506','2021-04-27 17:48:14',10,0),('1','149',193615,'DAILY shift','2021-04-28','2021-04-28 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-29 06:00:56','506','2021-04-29 06:02:05',10,0),('1','149',193853,'DAILY shift','2021-04-29','2021-04-29 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-30 08:30:20','506','2021-04-30 08:30:46',10,0),('1','149',194200,'DAILY','2021-04-30','2021-04-30 00:00:00',NULL,'506',0.00,0.00,'506','2021-04-30 14:04:41','506','2021-04-30 14:05:02',10,0),('1','149',194610,'DAILY','2021-05-02','2021-05-02 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-02 16:02:51','506','2021-05-02 16:03:19',10,0),('1','149',194619,'DAILY','2021-05-02','2021-05-02 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-02 16:09:42','506','2021-05-02 16:10:15',10,0),('1','149',194684,'DAILY','2021-05-02','2021-05-02 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-03 10:01:42','506','2021-05-03 10:02:05',10,0),('1','149',194754,'DAILY','2021-05-03','2021-05-03 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-03 10:18:26','506','2021-05-03 10:18:47',10,0),('1','149',194865,'Daily shift','2021-05-03','2021-05-03 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-03 21:15:11','506','2021-05-03 21:15:38',10,0),('1','149',194912,'DAILY','2021-05-04','2021-05-04 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-05 10:38:27','506','2021-05-05 10:38:51',10,0),('1','149',195173,'Daily shift','2021-05-05','2021-05-05 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-06 12:52:48','506','2021-05-06 12:53:17',10,0),('1','149',195428,'DAILY','2021-05-06','2021-05-06 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-06 13:13:05','506','2021-05-06 13:13:31',10,0),('1','149',195439,'DAILY','2021-05-06','2021-05-06 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-06 18:09:33','506','2021-05-06 18:10:02',10,0),('1','149',195526,'DAILY','2021-05-07','2021-05-07 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-07 18:30:04','506','2021-05-07 18:30:40',10,0),('1','149',195845,'DAILY','2021-05-08','2021-05-08 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-09 08:15:39','506','2021-05-09 08:16:09',10,0),('1','149',196040,'DAILY','2021-05-09','2021-05-09 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-09 20:28:16','506','2021-05-09 20:29:08',10,0),('1','149',196227,'DAILY','2021-05-10','2021-05-10 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-10 16:17:29','506','2021-05-10 16:19:59',10,0),('1','149',196395,'DAILY','2021-05-10','2021-05-10 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-10 18:18:14','506','2021-05-10 18:18:43',10,0),('1','149',196486,'Daily shift','2021-05-11','2021-05-11 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-11 21:34:49','506','2021-05-11 21:35:18',10,0),('1','149',196766,'DAILY','2021-05-12','2021-05-12 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-12 19:24:56','506','2021-05-12 19:25:28',10,0),('1','149',196900,'DAILY','2021-05-13','2021-05-13 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-14 07:02:02','506','2021-05-14 07:02:31',10,0),('1','149',197127,'DAILY','2021-05-14','2021-05-14 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-16 12:47:21','506','2021-05-16 12:47:41',10,0),('1','149',197400,'Daily shift','2021-05-16','2021-05-16 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-16 13:12:52','506','2021-05-16 13:13:10',10,0),('1','149',197403,'Daily shift','2021-05-16','2021-05-16 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-16 13:16:44','506','2021-05-16 13:17:09',10,0),('1','149',197407,'Daily shift','2021-05-16','2021-05-16 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-16 21:11:05','506','2021-05-16 21:11:39',10,0),('1','149',198026,'DAILY','2021-05-18','2021-05-18 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-18 13:58:47','506','2021-05-18 13:59:07',10,0),('1','149',198028,'DAILY','2021-05-18','2021-05-18 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-18 14:22:15','506','2021-05-18 14:22:40',10,0),('1','149',198102,'Daily shift','2021-05-18','2021-05-18 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-19 09:53:16','506','2021-05-19 09:59:09',10,0),('1','149',198193,'DAILY','2021-05-19','2021-05-19 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-19 19:23:37','506','2021-05-19 19:24:00',10,0),('1','149',198396,'DAILY','2021-05-20','2021-05-20 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-20 20:20:00','506','2021-05-20 20:20:29',10,0),('1','149',198809,'DAILY','2021-05-22','2021-05-22 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-22 13:01:11','506','2021-05-22 13:01:41',10,0),('1','149',198896,'DAILY','2021-05-22','2021-05-22 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-22 18:15:12','506','2021-05-22 18:15:37',10,0),('1','149',199007,'DAILY','2021-05-23','2021-05-23 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-24 11:04:39','506','2021-05-24 11:05:09',10,0),('1','149',199326,'DAILY','2021-05-24','2021-05-24 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-24 18:12:33','506','2021-05-24 18:13:00',10,0),('1','149',199609,'DAILY','2021-05-25','2021-05-25 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-26 11:52:39','506','2021-05-26 11:53:11',10,0),('1','149',199780,'DAILY','2021-05-26','2021-05-26 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-26 12:04:05','506','2021-05-26 12:04:36',10,0),('1','149',199794,'DAILY','2021-05-26','2021-05-26 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-27 06:56:19','506','2021-05-27 06:57:06',10,0),('1','149',199881,'DAILY shift','2021-05-27','2021-05-27 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-28 16:03:08','506','2021-05-28 16:03:37',10,0),('1','149',200247,'DAILY','2021-05-28','2021-05-28 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-29 13:11:06','506','2021-05-29 13:12:48',10,0),('1','149',200456,'DAILY','2021-05-29','2021-05-29 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-29 17:54:04','506','2021-05-29 17:54:33',10,0),('1','149',200577,'DAILY','2021-05-30','2021-05-30 00:00:00',NULL,'506',0.00,0.00,'506','2021-05-31 10:35:24','506','2021-05-31 10:36:20',10,0),('1','149',200780,'Daily shift','2021-05-31','2021-05-31 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-01 07:49:05','506','2021-06-01 07:49:29',10,0),('1','149',200954,'DAILY','2021-06-01','2021-06-01 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-02 11:41:50','506','2021-06-02 11:42:17',10,0),('1','149',201232,'DAILY','2021-06-02','2021-06-02 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-02 18:12:24','506','2021-06-02 18:12:50',10,0),('1','149',201407,'DAILY','2021-06-03','2021-06-03 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-03 17:50:41','506','2021-06-03 17:51:07',10,0),('1','149',201549,'DAILY','2021-06-04','2021-06-04 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-04 18:19:15','506','2021-06-04 18:19:42',10,0),('1','149',201786,'DAILY','2021-06-05','2021-06-05 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-05 12:09:01','506','2021-06-05 12:09:27',10,0),('1','149',201944,'DAILY','2021-06-05','2021-06-05 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-05 18:01:38','506','2021-06-05 18:02:47',10,0),('1','149',202050,'DAILY','2021-06-06','2021-06-06 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-07 08:34:17','506','2021-06-07 08:34:49',10,0),('1','149',202275,'DAILY','2021-06-07','2021-06-07 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-08 11:49:03','506','2021-06-08 11:49:30',10,0),('1','149',202533,'DAILY','2021-06-08','2021-06-08 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-09 07:06:22','506','2021-06-09 07:06:58',10,0),('1','149',202664,'Daily shift','2021-06-09','2021-06-09 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-10 07:22:20','506','2021-06-10 07:22:45',10,0),('1','149',202881,'DAILY shift','2021-06-10','2021-06-10 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-10 18:16:36','506','2021-06-10 18:17:05',10,0),('1','149',203146,'DAILY','2021-06-11','2021-06-11 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-12 08:43:48','506','2021-06-12 08:44:25',10,0),('1','149',203412,'DAILY','2021-06-12','2021-06-12 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-13 08:21:50','506','2021-06-13 08:22:23',10,0),('1','149',203561,'DAILY','2021-06-13','2021-06-13 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-13 18:01:04','506','2021-06-13 18:04:03',10,0),('1','149',203736,'DAILY','2021-06-14','2021-06-14 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-15 15:18:01','506','2021-06-15 15:18:41',10,0),('1','149',204129,'DAILY','2021-06-15','2021-06-15 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-16 10:09:40','506','2021-06-16 10:10:05',10,0),('1','149',204277,'DAILY','2021-06-16','2021-06-16 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-17 10:17:14','506','2021-06-17 10:17:40',10,0),('1','149',204583,'Daily shift','2021-06-17','2021-06-17 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-17 18:35:52','506','2021-06-17 18:36:16',10,0),('1','149',204778,'Daily shift','2021-06-18','2021-06-18 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-19 15:58:37','506','2021-06-19 15:59:03',10,0),('1','149',205018,'Daily shift','2021-06-19','2021-06-19 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-19 18:59:02','506','2021-06-19 18:59:26',10,0),('1','149',205207,'Daily shift','2021-06-20','2021-06-20 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-21 08:28:58','506','2021-06-21 08:29:22',10,0),('1','149',205448,'Daily shift','2021-06-21','2021-06-21 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-21 20:03:32','506','2021-06-21 20:04:26',10,0),('1','149',205675,'Daily shift','2021-06-22','2021-06-22 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-23 18:05:01','506','2021-06-23 18:05:21',10,0),('1','149',205926,'Daily shift','2021-06-23','2021-06-23 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-23 21:53:38','506','2021-06-23 21:54:04',10,0),('1','149',206124,'Daily shift','2021-06-24','2021-06-24 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-25 07:19:47','506','2021-06-25 07:20:09',10,0),('1','149',206173,'Daily shift','2021-06-25','2021-06-25 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-25 19:04:12','506','2021-06-25 19:04:32',10,0),('1','149',206552,'Daily shift','2021-06-26','2021-06-26 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-26 22:16:51','506','2021-06-26 22:17:12',10,0),('1','149',206667,'Daily shift','2021-06-27','2021-06-27 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-27 13:21:24','506','2021-06-27 13:21:52',10,0),('1','149',206693,'DAILY','2021-06-27','2021-06-27 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-27 18:08:10','506','2021-06-27 18:08:39',10,0),('1','149',206830,'DAILY shift','2021-06-28','2021-06-28 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-28 18:43:58','506','2021-06-28 18:44:44',10,0),('1','149',207043,'DAILY','2021-06-29','2021-06-29 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-29 18:14:45','506','2021-06-29 18:15:33',10,0),('1','149',207303,'DAILY','2021-06-30','2021-06-30 00:00:00',NULL,'506',0.00,0.00,'506','2021-06-30 18:26:45','506','2021-06-30 18:27:32',10,0),('1','149',207518,'DAILY','2021-07-01','2021-07-01 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-01 18:30:34','506','2021-07-01 18:31:02',10,0),('1','149',207678,'Daily shift','2021-07-01','2021-07-01 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-01 20:13:08','506','2021-07-01 20:13:30',10,0),('1','149',207779,'DAILY','2021-07-02','2021-07-02 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-03 07:22:19','506','2021-07-03 07:22:46',10,0),('1','149',207931,'DAILY','2021-07-03','2021-07-03 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-04 08:07:09','506','2021-07-04 08:07:41',10,0),('1','149',208142,'DAILY','2021-07-04','2021-07-04 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-05 18:31:08','506','2021-07-05 18:31:56',10,0),('1','149',208522,'Daily shift','2021-07-05','2021-07-05 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-06 08:32:28','506','2021-07-06 08:32:58',10,0),('1','149',208594,'DAILY','2021-07-06','2021-07-06 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-07 10:36:00','506','2021-07-07 10:36:37',10,0),('1','149',208861,'DAILY','2021-07-07','2021-07-07 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-08 09:02:28','506','2021-07-08 09:03:08',10,0),('1','149',209052,'DAILY','2021-07-08','2021-07-08 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-08 17:55:28','506','2021-07-08 17:55:57',10,0),('1','149',209283,'DAILY','2021-07-09','2021-07-09 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-09 17:58:39','506','2021-07-09 17:59:30',10,0),('1','149',209487,'DAILY','2021-07-10','2021-07-10 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-11 08:34:59','506','2021-07-11 08:35:27',10,0),('1','149',209680,'DAILY','2021-07-11','2021-07-11 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-12 12:08:16','506','2021-07-12 12:09:36',10,0),('1','149',209984,'DAILY','2021-07-12','2021-07-12 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-13 06:31:59','506','2021-07-13 06:32:25',10,0),('1','149',210105,'DAILY','2021-07-13','2021-07-13 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-14 07:41:10','506','2021-07-14 07:41:47',10,0),('1','149',210337,'DAILY','2021-07-14','2021-07-14 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-15 07:10:33','506','2021-07-15 07:12:27',10,0),('1','149',210528,'DAILY','2021-07-15','2021-07-15 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-16 09:27:06','506','2021-07-16 09:27:34',10,0),('1','149',210797,'DAILY','2021-07-15','2021-07-15 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-16 09:30:37','506','2021-07-16 09:31:03',10,0),('1','149',210801,'DAILY','2021-07-16','2021-07-16 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-17 09:00:26','506','2021-07-17 09:00:57',10,0),('1','149',211005,'DAILY','2021-07-17','2021-07-17 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-18 17:49:22','506','2021-07-18 17:50:03',10,0),('1','149',211334,'DAILY','2021-07-18','2021-07-18 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-20 13:16:03','506','2021-07-20 13:17:13',10,0),('1','149',211681,'DAILY','2021-07-19','2021-07-19 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-21 17:12:34','506','2021-07-21 17:13:59',10,0),('1','149',211939,'DAILY','2021-07-20','2021-07-20 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-21 17:21:43','506','2021-07-21 17:22:15',10,0),('1','149',211943,'DAILY','2021-07-21','2021-07-21 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-22 16:35:10','506','2021-07-22 16:35:43',10,0),('1','149',212179,'DAILY','2021-07-22','2021-07-22 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-22 18:18:26','506','2021-07-22 18:18:47',10,0),('1','149',212377,'Daily shift','2021-07-23','2021-07-23 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-24 08:45:00','506','2021-07-24 08:45:23',10,0),('1','149',212492,'DAILY','2021-07-24','2021-07-24 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-25 17:23:39','506','2021-07-25 17:24:12',10,0),('1','149',212816,'DAILY','2021-07-25','2021-07-25 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-25 18:13:32','506','2021-07-25 18:13:57',10,0),('1','149',212909,'DAILY','2021-07-26','2021-07-26 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-27 12:40:50','506','2021-07-27 12:41:27',10,0),('1','149',213280,'DAILY','2021-07-27','2021-07-27 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-28 08:41:23','506','2021-07-28 08:41:50',10,0),('1','149',213510,'DAILY','2021-07-28','2021-07-28 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-29 08:51:46','506','2021-07-29 08:52:36',10,0),('1','149',213841,'DAILY','2021-07-29','2021-07-29 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-29 18:30:47','506','2021-07-29 18:31:12',10,0),('1','149',213964,'DAILY','2021-07-30','2021-07-30 00:00:00',NULL,'506',0.00,0.00,'506','2021-07-31 18:24:53','506','2021-07-31 18:27:23',10,0),('1','149',214431,'Daily shift','2021-07-31','2021-07-31 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-01 12:44:30','506','2021-08-01 14:12:21',10,0),('1','149',214472,'Daily shift','2021-08-01','2021-08-01 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-02 06:38:25','506','2021-08-02 06:39:04',10,0),('1','149',214745,'DAILY','2021-08-02','2021-08-02 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-02 18:33:42','506','2021-08-02 18:34:02',10,0),('1','149',215072,'DAILY','2021-08-03','2021-08-03 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-04 09:55:11','506','2021-08-04 09:55:35',10,0),('1','149',215179,'DAILY','2021-08-04','2021-08-04 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-04 18:30:03','506','2021-08-04 18:30:27',10,0),('1','149',215271,'DAILY','2021-08-05','2021-08-05 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-06 07:02:46','506','2021-08-06 07:05:36',10,0),('1','149',215460,'DAILY','2021-08-06','2021-08-06 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-06 18:09:14','506','2021-08-06 18:09:39',10,0),('1','149',216020,'DAILY','2021-08-07','2021-08-07 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-08 14:35:16','506','2021-08-08 14:35:46',10,0),('1','149',216024,'DAILY','2021-08-08','2021-08-08 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-09 07:59:13','506','2021-08-09 08:00:50',10,0),('1','149',216133,'DAILY','2021-08-09','2021-08-09 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-10 07:08:48','506','2021-08-10 07:11:04',10,0),('1','149',216345,'DAILY','2021-08-10','2021-08-10 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-11 08:42:50','506','2021-08-11 08:45:37',10,0),('1','149',216604,'DAILY shift','2021-08-11','2021-08-11 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-12 18:46:54','506','2021-08-12 18:48:20',10,0),('1','149',217034,'DAILY','2021-08-12','2021-08-12 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-13 07:15:17','506','2021-08-13 07:15:40',10,0),('1','149',217037,'DAILY','2021-08-13','2021-08-13 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-14 07:10:33','506','2021-08-14 07:12:01',10,0),('1','149',217299,'DAILY','2021-08-14','2021-08-14 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-15 06:59:00','506','2021-08-15 07:07:37',10,0),('1','149',217519,'DAILY','2021-08-15','2021-08-15 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-16 13:23:24','506','2021-08-16 13:27:36',10,0),('1','149',217882,'DAILY','2021-08-16','2021-08-16 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-17 07:44:53','506','2021-08-17 07:47:25',10,0),('1','149',218013,'DAILY shift','2021-08-17','2021-08-17 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-18 07:51:41','506','2021-08-18 07:52:30',10,0),('1','149',218254,'DAILY shift','2021-08-18','2021-08-18 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-19 06:54:04','506','2021-08-19 06:55:03',10,0),('1','149',218456,'DAILY','2021-08-19','2021-08-19 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-20 06:40:46','506','2021-08-20 06:41:51',10,0),('1','149',218688,'DAILY','2021-08-20','2021-08-20 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-21 10:30:11','506','2021-08-21 10:30:55',10,0),('1','149',218969,'DAILY','2021-08-21','2021-08-21 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-21 18:32:53','506','2021-08-21 18:34:32',10,0),('1','149',219210,'DAILY','2021-08-22','2021-08-22 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-22 20:49:43','506','2021-08-22 20:50:40',10,0),('1','149',219362,'DAILY','2021-08-23','2021-08-23 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-23 19:01:51','506','2021-08-23 19:02:30',10,0),('1','149',219690,'DAILY','2021-08-24','2021-08-24 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-24 20:55:28','506','2021-08-24 20:56:28',10,0),('1','149',219847,'DAILY','2021-08-25','2021-08-25 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-26 18:29:09','506','2021-08-26 18:29:57',10,0),('1','149',220209,'DAILY','2021-08-26','2021-08-26 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-26 18:40:54','506','2021-08-26 18:41:22',10,0),('1','149',220249,'DAILY shift','2021-08-27','2021-08-27 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-27 18:46:39','506','2021-08-27 18:48:16',10,0),('1','149',220502,'DAILY','2021-08-28','2021-08-28 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-29 06:41:28','506','2021-08-29 06:46:47',10,0),('1','149',220764,'DAILY','2021-08-29','2021-08-29 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-29 18:23:40','506','2021-08-29 18:24:48',10,0),('1','149',220917,'DAILY','2021-08-30','2021-08-30 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-30 18:47:02','506','2021-08-30 18:48:37',10,0),('1','149',221143,'DAILY','2021-08-31','2021-08-31 00:00:00',NULL,'506',0.00,0.00,'506','2021-08-31 18:29:09','506','2021-08-31 18:31:21',10,0),('1','149',221388,'DAILY','2021-09-01','2021-09-01 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-01 14:06:12','506','2021-09-01 14:07:06',10,0),('1','149',221532,'DAILY','2021-09-01','2021-09-01 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-01 18:28:05','506','2021-09-01 18:28:34',10,0),('1','149',221630,'DAILY','2021-09-02','2021-09-02 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-02 18:58:48','506','2021-09-02 18:59:56',10,0),('1','149',221844,'DAILY','2021-09-03','2021-09-03 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-03 19:03:03','506','2021-09-03 19:09:34',10,0),('1','149',222137,'DAILY','2021-09-04','2021-09-04 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-04 18:05:07','506','2021-09-04 18:06:48',10,0),('1','149',222318,'DAILY','2021-09-05','2021-09-05 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-05 13:04:51','506','2021-09-05 13:06:57',10,0),('1','149',222407,'DAILY','2021-09-05','2021-09-05 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-05 18:35:44','506','2021-09-05 18:36:41',10,0),('1','149',222499,'DAILY','2021-09-06','2021-09-06 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-06 19:08:54','506','2021-09-06 19:10:52',10,0),('1','149',222757,'DAILY','2021-09-07','2021-09-07 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-07 18:37:21','506','2021-09-07 18:38:17',10,0),('1','149',222969,'DAILY','2021-09-08','2021-09-08 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-08 18:33:32','506','2021-09-08 18:34:06',10,0),('1','149',223274,'DAILY','2021-09-09','2021-09-09 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-09 17:46:31','506','2021-09-09 17:47:37',10,0),('1','149',223427,'DAILY','2021-09-10','2021-09-10 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-10 18:40:04','506','2021-09-10 18:41:11',10,0),('1','149',223662,'DAILY','2021-09-11','2021-09-11 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-11 18:56:41','506','2021-09-11 18:57:32',10,0),('1','149',223909,'DAILY','2021-09-12','2021-09-12 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-13 08:07:20','506','2021-09-13 08:09:50',10,0),('1','149',224144,'DAILY','2021-09-13','2021-09-13 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-13 18:31:52','506','2021-09-13 18:32:53',10,0),('1','149',224308,'DAILY','2021-09-14','2021-09-14 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-14 18:16:15','506','2021-09-14 18:17:43',10,0),('1','149',224529,'DAILY','2021-09-15','2021-09-15 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-15 18:31:21','506','2021-09-15 18:33:15',10,0),('1','149',224784,'DAILY','2021-09-16','2021-09-16 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-16 19:13:56','506','2021-09-16 19:17:09',10,0),('1','149',225085,'DAILY','2021-09-17','2021-09-17 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-17 10:35:47','506','2021-09-17 10:36:31',10,0),('1','149',225220,'DAILY','2021-09-17','2021-09-17 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-18 08:57:25','506','2021-09-18 08:59:22',10,0),('1','149',225319,'DAILY','2021-09-18','2021-09-18 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-18 18:17:05','506','2021-09-18 18:17:30',10,0),('1','149',225658,'DAILY','2021-09-19','2021-09-19 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-19 18:39:00','506','2021-09-19 18:40:11',10,0),('1','149',225934,'DAILY','2021-09-20','2021-09-20 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-20 18:25:13','506','2021-09-20 18:25:49',10,0),('1','149',226187,'DAILY','2021-09-21','2021-09-21 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-21 17:44:20','506','2021-09-21 17:44:45',10,0),('1','149',226357,'DAILY','2021-09-22','2021-09-22 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-22 19:14:37','506','2021-09-22 19:15:08',10,0),('1','149',226692,'DAILY','2021-09-23','2021-09-23 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-24 10:49:04','506','2021-09-24 10:50:25',10,0),('1','149',226923,'DAILY','2021-09-24','2021-09-24 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-24 18:17:06','506','2021-09-24 18:18:57',10,0),('1','149',227151,'DAILY','2021-09-25','2021-09-25 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-26 08:50:36','506','2021-09-26 08:51:06',10,0),('1','149',227425,'DAILY','2021-09-26','2021-09-26 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-27 10:26:31','506','2021-09-27 10:27:00',10,0),('1','149',227472,'DAILY','2021-09-27','2021-09-27 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-28 09:36:05','506','2021-09-28 09:37:32',10,0),('1','149',227669,'DAILY','2021-09-28','2021-09-28 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-28 18:39:46','506','2021-09-28 18:40:22',10,0),('1','149',227905,'DAILY','2021-09-29','2021-09-29 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-29 17:42:22','506','2021-09-29 17:42:52',10,0),('1','149',228283,'DAILY','2021-09-30','2021-09-30 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-30 16:33:11','506','2021-09-30 16:33:32',10,0),('1','149',228288,'DAILY shift','2021-09-30','2021-09-30 00:00:00',NULL,'506',0.00,0.00,'506','2021-09-30 18:16:15','506','2021-09-30 18:16:43',10,0),('1','149',228411,'DAILY','2021-10-01','2021-10-01 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-01 18:22:50','506','2021-10-01 18:23:39',10,0),('1','149',228604,'DAILY','2021-10-02','2021-10-02 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-02 18:22:13','506','2021-10-02 18:22:38',10,0),('1','149',228787,'DAILY','2021-10-03','2021-10-03 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-03 11:28:11','506','2021-10-03 11:28:52',10,0),('1','149',228888,'DAILY','2021-10-03','2021-10-03 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-03 19:07:52','506','2021-10-03 19:08:21',10,0),('1','149',229211,'DAILY','2021-10-04','2021-10-04 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-05 08:36:23','506','2021-10-05 08:37:07',10,0),('1','149',229377,'DAILY','2021-10-05','2021-10-05 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-05 18:41:44','506','2021-10-05 18:42:29',10,0),('1','149',229383,'DAILY','2021-10-05','2021-10-05 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-05 19:02:33','506','2021-10-05 19:03:15',10,0),('1','149',229476,'DAILY','2021-10-06','2021-10-06 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-06 18:48:24','506','2021-10-06 18:49:53',10,0),('1','149',229722,'DAILY','2021-10-07','2021-10-07 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-07 16:40:33','506','2021-10-07 16:42:11',10,0),('1','149',229928,'DAILY','2021-10-08','2021-10-08 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-08 18:48:58','506','2021-10-08 18:52:15',10,0),('1','149',230138,'DAILY','2021-10-09','2021-10-09 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-10 08:17:22','506','2021-10-10 08:19:29',10,0),('1','149',230324,'DAILY','2021-10-10','2021-10-10 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-10 13:42:15','506','2021-10-10 13:43:16',10,0),('1','149',230424,'DAILY','2021-10-10','2021-10-10 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-10 19:01:48','506','2021-10-10 19:02:54',10,0),('1','149',230554,'DAILY','2021-10-11','2021-10-11 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-11 19:01:17','506','2021-10-11 19:08:11',10,0),('1','149',230789,'DAILY','2021-10-12','2021-10-12 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-12 18:56:37','506','2021-10-12 18:59:40',10,0),('1','149',231077,'DAILY','2021-10-13','2021-10-13 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-13 19:10:52','506','2021-10-13 19:12:49',10,0),('1','149',231343,'DAILY','2021-10-13','2021-10-13 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-13 19:25:22','506','2021-10-13 19:25:48',10,0),('1','149',231386,'DAILY','2021-10-14','2021-10-14 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-14 18:23:27','506','2021-10-14 18:25:45',10,0),('1','149',231641,'DAILY','2021-10-15','2021-10-15 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-15 18:19:37','506','2021-10-15 18:21:02',10,0),('1','149',231901,'Daily shift','2021-10-16','2021-10-16 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-16 18:21:24','506','2021-10-16 18:23:34',10,0),('1','149',232103,'DAILY','2021-10-17','2021-10-17 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-17 17:52:30','506','2021-10-17 17:55:43',10,0),('1','149',232336,'DAILY','2021-10-18','2021-10-18 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-18 18:23:50','506','2021-10-18 18:27:45',10,0),('1','149',232586,'DAILY','2021-10-19','2021-10-19 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-19 18:09:49','506','2021-10-19 18:12:47',10,0),('1','149',232861,'DAILY','2021-10-20','2021-10-20 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-20 19:18:10','506','2021-10-20 19:20:35',10,0),('1','149',233124,'DAILY','2021-10-21','2021-10-21 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-22 08:20:19','506','2021-10-22 08:22:11',10,0),('1','149',233490,'Daily shift','2021-10-22','2021-10-22 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-23 07:28:44','506','2021-10-23 07:30:15',10,0),('1','149',233639,'DAILY','2021-10-23','2021-10-23 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-23 22:18:26','506','2021-10-23 22:21:07',10,0),('1','149',233849,'DAILY','2021-10-24','2021-10-24 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-24 22:52:31','506','2021-10-24 22:54:10',10,0),('1','149',234056,'DAILY','2021-10-25','2021-10-25 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-26 06:41:43','506','2021-10-26 06:47:12',10,0),('1','149',234482,'DAILY','2021-10-26','2021-10-26 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-26 20:39:48','506','2021-10-26 20:40:24',10,0),('1','149',234646,'DAILY','2021-10-27','2021-10-27 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-27 22:11:39','506','2021-10-27 22:14:10',10,0),('1','149',234834,'DAILY','2021-10-28','2021-10-28 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-29 07:34:53','506','2021-10-29 07:37:45',10,0),('1','149',235126,'DAILY','2021-10-29','2021-10-29 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-30 09:08:06','506','2021-10-30 09:09:40',10,0),('1','149',235371,'DAILY','2021-10-30','2021-10-30 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-31 13:11:29','506','2021-10-31 13:14:37',10,0),('1','149',235645,'DAILY','2021-10-31','2021-10-31 00:00:00',NULL,'506',0.00,0.00,'506','2021-10-31 18:34:57','506','2021-10-31 18:36:10',10,0),('1','149',235780,'DAILY','2021-11-01','2021-11-01 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-01 19:04:27','506','2021-11-01 19:06:29',10,0),('1','149',236023,'DAILY','2021-11-02','2021-11-02 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-02 18:59:22','506','2021-11-02 19:01:38',10,0),('1','149',236243,'DAILY','2021-11-03','2021-11-03 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-04 08:02:11','506','2021-11-04 08:03:16',10,0),('1','149',236673,'DAILY','2021-11-04','2021-11-04 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-04 18:19:46','506','2021-11-04 18:20:10',10,0),('1','149',236742,'DAILY','2021-11-05','2021-11-05 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-05 17:52:47','506','2021-11-05 17:53:13',10,0),('1','149',236968,'DAILY','2021-11-06','2021-11-06 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-06 17:52:27','506','2021-11-06 17:52:53',10,0),('1','149',237185,'DAILY','2021-11-07','2021-11-07 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-07 17:38:19','506','2021-11-07 17:38:45',10,0),('1','149',237387,'DAILY','2021-11-08','2021-11-08 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-09 08:23:19','506','2021-11-09 08:23:59',10,0),('1','149',237666,'DAILY','2021-11-09','2021-11-09 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-09 17:37:34','506','2021-11-09 17:37:54',10,0),('1','149',237870,'DAILY','2021-11-10','2021-11-10 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-10 18:08:24','506','2021-11-10 18:09:10',10,0),('1','149',238125,'DAILY','2021-11-11','2021-11-11 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-11 18:15:08','506','2021-11-11 18:15:51',10,0),('1','149',238365,'DAILY','2021-11-12','2021-11-12 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-12 17:05:02','506','2021-11-12 17:05:37',10,0),('1','149',238546,'DAILY','2021-11-12','2021-11-12 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-12 18:14:32','506','2021-11-12 18:16:39',10,0),('1','149',238608,'DAILY','2021-11-13','2021-11-13 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-13 18:19:12','506','2021-11-13 18:20:03',10,0),('1','149',238856,'DAILY','2021-11-14','2021-11-14 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-14 17:54:45','506','2021-11-14 17:55:09',10,0),('1','149',239068,'DAILY','2021-11-15','2021-11-15 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-15 17:58:40','506','2021-11-15 17:59:05',10,0),('1','149',239291,'DAILY','2021-11-16','2021-11-16 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-16 14:10:33','506','2021-11-16 14:10:54',10,0),('1','149',239439,'DAILY','2021-11-16','2021-11-16 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-16 18:22:24','506','2021-11-16 18:22:45',10,0),('1','149',239534,'DAILY','2021-11-17','2021-11-17 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-17 18:08:09','506','2021-11-17 18:08:36',10,0),('1','149',239781,'DAILY','2021-11-18','2021-11-18 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-18 18:13:31','506','2021-11-18 18:14:10',10,0),('1','149',239997,'DAILY','2021-11-19','2021-11-19 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-19 18:16:58','506','2021-11-19 18:17:21',10,0),('1','149',240219,'DAILY','2021-11-20','2021-11-20 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-20 17:40:12','506','2021-11-20 17:40:47',10,0),('1','149',240456,'DAILY','2021-11-21','2021-11-21 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-21 15:24:17','506','2021-11-21 15:25:03',10,0),('1','149',240596,'DAILY','2021-11-21','2021-11-21 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-21 18:14:51','506','2021-11-21 18:15:19',10,0),('1','149',240712,'DAILY','2021-11-22','2021-11-22 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-22 18:30:29','506','2021-11-22 18:30:56',10,0),('1','149',240975,'DAILY','2021-11-23','2021-11-23 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-23 18:13:44','506','2021-11-23 18:14:19',10,0),('1','149',241228,'DAILY','2021-11-24','2021-11-24 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-24 18:40:28','506','2021-11-24 18:40:57',10,0),('1','149',241488,'DAILY','2021-11-25','2021-11-25 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-25 18:16:39','506','2021-11-25 18:17:25',10,0),('1','149',241736,'DAILY','2021-11-26','2021-11-26 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-26 15:13:54','506','2021-11-26 15:15:53',10,0),('1','149',241897,'DAILY','2021-11-26','2021-11-26 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-26 18:15:06','506','2021-11-26 18:15:29',10,0),('1','149',242033,'DAILY','2021-11-27','2021-11-27 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-27 18:05:00','506','2021-11-27 18:05:27',10,0),('1','149',242210,'DAILY','2021-11-28','2021-11-28 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-28 18:11:06','506','2021-11-28 18:11:31',10,0),('1','149',242435,'DAILY','2021-11-29','2021-11-29 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-29 18:04:42','506','2021-11-29 18:05:27',10,0),('1','149',242682,'DAILY','2021-11-30','2021-11-30 00:00:00',NULL,'506',0.00,0.00,'506','2021-11-30 17:18:33','506','2021-11-30 17:19:21',10,0),('1','149',242964,'DAILY','2021-12-01','2021-12-01 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-01 17:46:29','506','2021-12-01 17:47:48',10,0),('1','149',243139,'DAILY','2021-12-02','2021-12-02 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-02 17:42:24','506','2021-12-02 17:43:57',10,0),('1','149',243369,'DAILY','2021-12-03','2021-12-03 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-03 18:13:04','506','2021-12-03 18:13:55',10,0),('1','149',243603,'DAILY','2021-12-04','2021-12-04 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-04 17:54:04','506','2021-12-04 17:59:05',10,0),('1','149',243851,'DAILY','2021-12-05','2021-12-05 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-05 17:47:44','506','2021-12-05 17:48:43',10,0),('1','149',244054,'DAILY','2021-12-06','2021-12-06 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-06 18:15:17','506','2021-12-06 18:16:10',10,0),('1','149',244291,'DAILY shift','2021-12-07','2021-12-07 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-07 15:26:57','506','2021-12-07 15:30:01',10,0),('1','149',244522,'DAILY','2021-12-08','2021-12-08 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-08 17:59:16','506','2021-12-08 18:01:22',10,0),('1','149',244774,'DAILY shift','2021-12-09','2021-12-09 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-09 18:08:12','506','2021-12-09 18:08:59',10,0),('1','149',244978,'DAILY','2021-12-10','2021-12-10 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-10 17:50:32','506','2021-12-10 17:51:20',10,0),('1','149',245305,'Daily shift','2021-12-11','2021-12-11 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-11 16:43:20','506','2021-12-11 16:44:24',10,0),('1','149',245362,'DAILY','2021-12-11','2021-12-11 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-11 17:42:50','506','2021-12-11 17:43:16',10,0),('1','149',245436,'DAILY','2021-12-12','2021-12-12 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-12 17:56:26','506','2021-12-12 17:57:33',10,0),('1','149',245728,'DAILY','2021-12-13','2021-12-13 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-13 18:09:29','506','2021-12-13 18:10:10',10,0),('1','149',245956,'DAILY','2021-12-14','2021-12-14 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-14 18:18:41','506','2021-12-14 18:19:47',10,0),('1','149',246233,'DAILY','2021-12-15','2021-12-15 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-16 08:44:27','506','2021-12-16 08:44:47',10,0),('1','149',246526,'DAILY shift','2021-12-16','2021-12-16 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-16 17:39:52','506','2021-12-16 17:40:13',10,0),('1','149',246706,'DAILY','2021-12-17','2021-12-17 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-17 17:59:02','506','2021-12-17 18:01:00',10,0),('1','149',246939,'DAILY','2021-12-18','2021-12-18 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-18 17:55:13','506','2021-12-18 17:55:39',10,0),('1','149',247184,'DAILY','2021-12-19','2021-12-19 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-20 09:55:21','506','2021-12-20 09:56:32',10,0),('1','149',247485,'DAILY','2021-12-20','2021-12-20 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-20 17:40:23','506','2021-12-20 17:40:46',10,0),('1','149',247678,'DAILY','2021-12-21','2021-12-21 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-21 17:58:12','506','2021-12-21 17:59:09',10,0),('1','149',247911,'DAILY','2021-12-22','2021-12-22 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-22 18:08:45','506','2021-12-22 18:09:19',10,0),('1','149',248169,'DAILY','2021-12-23','2021-12-23 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-23 17:57:24','506','2021-12-23 17:58:03',10,0),('1','149',248408,'DAILY','2021-12-24','2021-12-24 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-24 18:08:12','506','2021-12-24 18:09:01',10,0),('1','149',248579,'DAILY','2021-12-24','2021-12-24 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-24 18:41:16','506','2021-12-24 18:41:36',10,0),('1','149',248642,'DAILY','2021-12-25','2021-12-25 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-25 17:55:06','506','2021-12-25 17:55:27',10,0),('1','149',248922,'DAILY','2021-12-26','2021-12-26 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-26 17:47:54','506','2021-12-26 17:48:26',10,0),('1','149',249133,'DAILY','2021-12-27','2021-12-27 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-27 17:39:03','506','2021-12-27 17:39:24',10,0),('1','149',249376,'DAILY','2021-12-28','2021-12-28 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-29 09:09:20','506','2021-12-29 09:10:36',10,0),('1','149',249701,'DAILY','2021-12-29','2021-12-29 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-29 17:59:04','506','2021-12-29 17:59:23',10,0),('1','149',249863,'DAILY','2021-12-30','2021-12-30 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-30 18:42:08','506','2021-12-30 18:43:11',10,0),('1','149',250120,'DAILY','2021-12-31','2021-12-31 00:00:00',NULL,'506',0.00,0.00,'506','2021-12-31 17:48:57','506','2021-12-31 17:49:45',10,0),('1','149',250352,'DAILY','2022-01-01','2022-01-01 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-01 11:32:35','506','2022-01-01 11:33:21',10,0),('1','149',250428,'DAILY shift','2022-01-01','2022-01-01 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-01 18:04:10','506','2022-01-01 18:04:41',10,0),('1','149',250580,'DAILY','2022-01-02','2022-01-02 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-02 18:30:15','506','2022-01-02 18:30:59',10,0),('1','149',250800,'DAILY','2022-01-03','2022-01-03 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-03 18:10:18','506','2022-01-03 18:10:41',10,0),('1','149',251028,'DAILY','2022-01-04','2022-01-04 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-04 11:42:25','506','2022-01-04 11:42:45',10,0),('1','149',251129,'DAILY','2022-01-04','2022-01-04 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-04 18:25:59','506','2022-01-04 18:27:35',10,0),('1','149',251280,'DAILY','2022-01-05','2022-01-05 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-05 19:00:09','506','2022-01-05 19:00:42',10,0),('1','149',251530,'DAILY','2022-01-06','2022-01-06 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-06 19:03:26','506','2022-01-06 19:04:23',10,0),('1','149',251773,'DAILY','2022-01-07','2022-01-07 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-07 19:04:10','506','2022-01-07 19:05:41',10,0),('1','149',252003,'DAILY','2022-01-08','2022-01-08 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-08 19:16:46','506','2022-01-08 19:17:37',10,0),('1','149',252253,'DAILY','2022-01-09','2022-01-09 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-09 18:56:21','506','2022-01-09 18:57:07',10,0),('1','149',252476,'DAILY','2022-01-10','2022-01-10 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-10 18:54:17','506','2022-01-10 18:56:08',10,0),('1','149',252730,'DAILY','2022-01-11','2022-01-11 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-11 19:11:07','506','2022-01-11 19:12:18',10,0),('1','149',252969,'DAILY','2022-01-12','2022-01-12 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-12 19:06:12','506','2022-01-12 19:07:18',10,0),('1','149',253229,'DAILY','2022-01-13','2022-01-13 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-13 18:36:49','506','2022-01-13 18:37:29',10,0),('1','149',253522,'DAILY','2022-01-14','2022-01-14 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-14 18:53:22','506','2022-01-14 18:54:09',10,0),('1','149',253722,'DAILY','2022-01-15','2022-01-15 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-15 17:31:25','506','2022-01-15 17:34:14',10,0),('1','149',254145,'Daily shift','2022-01-16','2022-01-16 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-16 20:23:34','506','2022-01-16 20:24:13',10,0),('1','149',254205,'DAILY','2022-01-17','2022-01-17 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-17 18:52:50','506','2022-01-17 18:53:16',10,0),('1','149',254455,'DAILY','2022-01-18','2022-01-18 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-18 18:43:44','506','2022-01-18 18:44:13',10,0),('1','149',254711,'DAILY','2022-01-19','2022-01-19 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-19 18:58:31','506','2022-01-19 18:59:16',10,0),('1','149',254960,'DAILY','2022-01-20','2022-01-20 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-21 10:24:40','506','2022-01-21 10:25:28',10,0),('1','149',255289,'DAILY shift','2022-01-21','2022-01-21 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-21 18:52:44','506','2022-01-21 18:53:47',10,0),('1','149',255463,'DAILY','2022-01-22','2022-01-22 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-22 19:20:00','506','2022-01-22 19:21:17',10,0),('1','149',255726,'DAILY','2022-01-23','2022-01-23 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-23 19:00:51','506','2022-01-23 19:01:57',10,0),('1','149',255958,'DAILY','2022-01-24','2022-01-24 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-24 19:17:53','506','2022-01-24 19:19:04',10,0),('1','149',256219,'DAILY','2022-01-25','2022-01-25 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-26 07:28:36','506','2022-01-26 08:09:39',10,0),('1','149',256521,'DAILY shift','2022-01-26','2022-01-26 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-26 19:52:55','506','2022-01-26 19:55:48',10,0),('1','149',256734,'DAILY shift','2022-01-27','2022-01-27 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-27 19:22:50','506','2022-01-27 19:24:01',10,0),('1','149',256971,'DAILY','2022-01-28','2022-01-28 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-28 19:08:16','506','2022-01-28 19:09:05',10,0),('1','149',257299,'DAILY','2022-01-29','2022-01-29 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-29 19:04:29','506','2022-01-29 19:05:35',10,0),('1','149',257497,'DAILY','2022-01-30','2022-01-30 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-30 14:35:30','506','2022-01-30 14:36:55',10,0),('1','149',257631,'DAILY shift','2022-01-30','2022-01-30 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-30 19:22:58','506','2022-01-30 19:24:28',10,0),('1','149',257632,'DAILY shift','2022-01-31','2022-01-31 00:00:00',NULL,'506',0.00,0.00,'506','2022-01-31 19:34:04','506','2022-01-31 19:34:34',10,0),('1','149',257633,'DAILY shift','2022-02-01','2022-02-01 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-01 19:22:59','506','2022-02-01 19:23:20',10,0),('1','149',257634,'DAILY','2022-02-02','2022-02-02 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-02 19:13:51','506','2022-02-02 19:14:11',10,0),('1','149',257635,'DAILY shift','2022-02-03','2022-02-03 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-03 19:23:42','506','2022-02-03 19:24:03',10,0),('1','149',257636,'DAILY shift','2022-02-04','2022-02-04 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-04 19:58:39','506','2022-02-04 19:58:57',10,0),('1','149',257637,'DAILY shift','2022-02-05','2022-02-05 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-05 19:47:39','506','2022-02-05 19:48:02',10,0),('1','149',257638,'DAILY shift','2022-02-06','2022-02-06 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-07 08:22:24','506','2022-02-07 08:22:44',10,0),('1','149',257639,'DAILY shift','2022-02-07','2022-02-07 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-07 18:51:57','506','2022-02-07 18:52:19',10,0),('1','149',257640,'DAILY shift','2022-02-07','2022-02-07 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-07 19:48:27','506','2022-02-07 19:48:45',10,0),('1','149',257641,'DAILY','2022-02-08','2022-02-08 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-08 20:18:12','506','2022-02-08 20:18:29',10,0),('1','149',257642,'DAILY','2022-02-09','2022-02-09 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-09 19:37:37','506','2022-02-09 19:44:30',10,0),('1','149',257643,'DAILY','2022-02-10','2022-02-10 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-10 18:37:28','506','2022-02-10 18:37:45',10,0),('1','149',257644,'DAILY shift','2022-02-11','2022-02-11 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-11 19:23:07','506','2022-02-11 19:28:01',10,0),('1','149',257645,'DAILY','2022-02-12','2022-02-12 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-12 19:09:27','506','2022-02-12 19:09:45',10,0),('1','149',257646,'DAILY','2022-02-13','2022-02-13 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-13 19:01:16','506','2022-02-13 19:03:20',10,0),('1','149',257647,'DAILY','2022-02-14','2022-02-14 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-14 19:08:37','506','2022-02-14 19:08:58',10,0),('1','149',257648,'DAILY','2022-02-15','2022-02-15 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-15 16:34:43','506','2022-02-15 16:34:59',10,0),('1','149',257649,'DAILY shift','2022-02-16','2022-02-16 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-16 19:00:32','506','2022-02-16 19:00:56',10,0),('1','149',257650,'DAILY','2022-02-17','2022-02-17 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-17 19:06:54','506','2022-02-17 19:07:17',10,0),('1','149',257651,'DAILY','2022-02-18','2022-02-18 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-19 10:33:33','506','2022-02-19 10:33:58',10,0),('1','149',257652,'DAILY','2022-02-19','2022-02-19 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-19 19:27:13','506','2022-02-19 19:27:31',10,0),('1','149',257653,'DAILY','2022-02-20','2022-02-20 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-20 19:00:26','506','2022-02-20 19:01:39',10,0),('1','149',257654,'DAILY shift','2022-02-21','2022-02-21 00:00:00',NULL,'506',0.00,0.00,'506','2022-02-21 19:35:39','506','2022-02-21 19:35:56',10,0),('1','149',257655,'DAILY','2022-02-22','2022-02-22 07:05:07','2022-02-23 07:05:07','506',0.00,0.00,'506','2022-02-22 13:41:06','506','2022-02-22 13:41:30',10,0),('1','149',257656,'DAILY shift','2022-02-22','2022-02-22 18:12:07','2022-02-23 18:12:07','506',0.00,0.00,'506','2022-02-22 19:12:05','506','2022-02-22 19:12:22',10,0),('1','149',257657,'DAILY shift','2022-02-23','2022-02-23 07:20:44','2022-02-24 07:20:44','506',0.00,0.00,'506','2022-02-23 18:29:32','506','2022-02-23 18:29:50',10,0),('1','149',257658,'DAILY shift','2022-02-24','2022-02-24 07:07:31','2022-02-25 07:07:31','506',0.00,0.00,'506','2022-02-24 19:05:30','506','2022-02-24 19:05:46',10,0),('1','149',257659,'DAILY shift','2022-02-25','2022-02-25 07:12:47','2022-02-26 07:12:47','506',0.00,0.00,'506','2022-02-25 18:57:25','506','2022-02-25 18:57:40',10,0),('1','149',257660,'DAILY shift','2022-02-26','2022-02-26 10:00:52','2022-02-27 10:00:52','506',0.00,0.00,'506','2022-02-26 19:30:30','506','2022-02-26 19:30:53',10,0),('1','149',257661,'DAILY shift','2022-02-27','2022-02-27 08:14:29','2022-02-28 08:14:29','506',0.00,0.00,'506','2022-02-28 08:24:59','506','2022-02-28 08:25:27',10,0),('1','149',257662,'DAILY shift','2022-02-28','2022-02-28 08:29:01','2022-03-01 08:29:01','506',0.00,0.00,'506','2022-03-01 11:02:26','506','2022-03-01 11:02:43',10,0),('1','149',257663,'DAILY shift','2022-03-01','2022-03-01 11:13:20','2022-03-02 11:13:20','506',0.00,0.00,'506','2022-03-01 19:08:17','506','2022-03-01 19:08:34',10,0),('1','149',257664,'DAILY','2022-03-02','2022-03-02 07:16:46','2022-03-03 07:16:46','506',0.00,0.00,'506','2022-03-02 19:09:39','506','2022-03-02 19:10:00',10,0),('1','149',257665,'DAILY shift','2022-03-03','2022-03-03 07:45:58','2022-03-04 07:45:58','506',0.00,0.00,'506','2022-03-03 19:31:20','506','2022-03-03 19:31:40',10,0),('1','149',257666,'DAILY shift','2022-03-04','2022-03-04 08:37:14','2022-03-05 08:37:14','506',0.00,0.00,'506','2022-03-04 19:24:55','506','2022-03-04 19:25:16',10,0),('1','149',257667,'DAILY shift','2022-03-05','2022-03-05 09:04:25','2022-03-06 09:04:25','506',0.00,0.00,'506','2022-03-05 19:30:49','506','2022-03-05 19:31:14',10,0),('1','149',257668,'DAILY shift','2022-03-06','2022-03-06 07:52:02','2022-03-07 07:52:02','506',0.00,0.00,'506','2022-03-06 20:45:50','506','2022-03-06 20:46:08',10,0),('1','149',257669,'DAILY shift','2022-03-06','2022-03-06 20:58:42','2022-03-07 20:58:42','506',0.00,0.00,'506','2022-03-06 20:59:46','506','2022-03-06 21:00:00',10,0),('1','149',257670,'DAILY shift','2022-03-07','2022-03-07 07:06:26','2022-03-08 07:06:26','506',0.00,0.00,'506','2022-03-07 19:04:09','506','2022-03-07 19:04:28',10,0),('1','149',257671,'DAILY shift','2022-03-08','2022-03-08 07:08:54','2022-03-09 07:08:54','506',0.00,0.00,'506','2022-03-08 19:01:04','506','2022-03-08 19:01:21',10,0),('1','149',257672,'DAILY shift','2022-03-09','2022-03-09 07:27:44','2022-03-10 07:27:44','506',0.00,0.00,'506','2022-03-09 19:19:52','506','2022-03-09 19:20:11',10,0),('1','149',257673,'DAILY shift','2022-03-10','2022-03-10 08:12:22','2022-03-11 08:12:22','506',0.00,0.00,'506','2022-03-10 19:12:03','506','2022-03-10 19:12:22',10,0),('1','149',257674,'DAILY shift','2022-03-11','2022-03-11 07:29:05','2022-03-12 07:29:05','506',0.00,0.00,'506','2022-03-11 19:06:34','506','2022-03-11 19:06:51',10,0),('1','149',257675,'DAILY shift','2022-03-12','2022-03-12 07:26:08','2022-03-13 07:26:08','506',0.00,0.00,'506','2022-03-12 17:51:00','506','2022-03-12 17:51:18',10,0),('1','149',257676,'DAILY','2022-03-12','2022-03-12 17:58:25','2022-03-13 17:58:25','506',0.00,0.00,'506','2022-03-13 08:12:17','506','2022-03-13 08:12:35',10,0),('1','149',257677,'DAILY shift','2022-03-13','2022-03-13 08:23:00','2022-03-14 08:23:00','506',0.00,0.00,'506','2022-03-13 19:20:36','506','2022-03-13 19:21:12',10,0),('1','149',257678,'DAILY shift','2022-03-14','2022-03-14 08:33:55','2022-03-15 08:33:55','506',0.00,0.00,'506','2022-03-14 19:14:22','506','2022-03-14 19:14:40',10,0),('1','149',257679,'DAILY shift','2022-03-15','2022-03-15 07:15:44','2022-03-16 07:15:44','506',0.00,0.00,'506','2022-03-15 19:12:43','506','2022-03-15 19:13:05',10,0),('1','149',257680,'DAILY','2022-03-16','2022-03-16 07:19:19','2022-03-17 07:19:19','506',0.00,0.00,'506','2022-03-17 10:39:27','506','2022-03-17 10:39:51',10,0),('1','149',257681,'DAILY shift','2022-03-17','2022-03-17 10:40:24','2022-03-18 10:40:24','506',0.00,0.00,'506','2022-03-17 19:36:08','506','2022-03-17 19:36:29',10,0),('1','149',257682,'DAILY shift','2022-03-17','2022-03-17 19:37:06','2022-03-18 19:37:06','506',0.00,0.00,'506','2022-03-17 19:39:06','506','2022-03-17 19:39:28',10,0),('1','149',257683,'DAILY','2022-03-18','2022-03-18 07:43:04','2022-03-19 07:43:04','506',0.00,0.00,'506','2022-03-18 18:54:12','506','2022-03-18 18:54:37',10,0),('1','149',257684,'DAILY shift','2022-03-19','2022-03-19 07:38:15','2022-03-20 07:38:15','506',0.00,0.00,'506','2022-03-20 07:01:15','506','2022-03-20 07:01:37',10,0),('1','149',257685,'DAILY','2022-03-20','2022-03-20 07:01:59','2022-03-21 07:01:59','506',0.00,0.00,'506','2022-03-21 07:02:05','506','2022-03-21 07:02:32',10,0),('1','149',257686,'DAILY shift','2022-03-21','2022-03-21 07:03:22','2022-03-22 07:03:22','506',0.00,0.00,'506','2022-03-21 19:20:36','506','2022-03-21 19:20:53',10,0),('1','149',257687,'DAILY shift','2022-03-22','2022-03-22 07:09:24','2022-03-23 07:09:24','506',0.00,0.00,'506','2022-03-23 07:51:53','506','2022-03-23 07:52:18',10,0),('1','149',257688,'DAILY shift','2022-03-23','2022-03-23 07:58:37','2022-03-24 07:58:37','506',0.00,0.00,'506','2022-03-23 16:01:26','506','2022-03-23 16:02:01',10,0),('1','149',257689,'DAILY shift','2022-03-23','2022-03-23 16:02:44','2022-03-24 16:02:44','506',0.00,0.00,'506','2022-03-23 19:26:25','506','2022-03-23 19:26:49',10,0),('1','149',257690,'DAILY','2022-03-24','2022-03-24 09:24:40','2022-03-25 09:24:40','506',0.00,0.00,'506','2022-03-24 18:57:17','506','2022-03-24 18:57:37',10,0),('1','149',257691,'DAILY shift','2022-03-25','2022-03-25 07:11:02','2022-03-26 07:11:02','506',0.00,0.00,'506','2022-03-25 19:10:12','506','2022-03-25 19:10:30',10,0),('1','149',257692,'DAILY shift','2022-03-26','2022-03-26 10:21:47','2022-03-27 10:21:47','506',0.00,0.00,'506','2022-03-26 19:31:49','506','2022-03-26 19:32:32',10,0),('1','149',257693,'DAILY','2022-03-27','2022-03-27 07:34:03','2022-03-28 07:34:03','506',0.00,0.00,'506','2022-03-27 09:20:47','506','2022-03-27 09:21:16',10,0),('1','149',257694,'DAILY shift','2022-03-27','2022-03-27 09:28:53','2022-03-28 09:28:53','506',0.00,0.00,'506','2022-03-27 19:19:41','506','2022-03-27 19:20:00',10,0),('1','149',257695,'DAILY shift','2022-03-28','2022-03-28 07:11:44','2022-03-29 07:11:44','506',0.00,0.00,'506','2022-03-29 07:37:11','506','2022-03-29 07:37:31',10,0),('1','149',257696,'DAILY shift','2022-03-29','2022-03-29 09:09:57','2022-03-30 09:09:57','506',0.00,0.00,'506','2022-03-29 19:02:37','506','2022-03-29 19:02:53',10,0),('1','149',257697,'DAILY','2022-03-30','2022-03-30 07:26:04','2022-03-31 07:26:04','506',0.00,0.00,'506','2022-03-30 19:11:58','506','2022-03-30 19:12:14',10,0),('1','149',257698,'DAILY','2022-03-31','2022-03-31 08:08:12','2022-04-01 08:08:12','506',0.00,0.00,'506','2022-03-31 19:14:45','506','2022-03-31 19:15:04',10,0),('1','149',257699,'DAILY','2022-04-01','2022-04-01 07:20:50','2022-04-02 07:20:50','506',0.00,0.00,'506','2022-04-01 19:35:47','506','2022-04-01 19:38:14',10,0),('1','149',257700,'DAILY','2022-04-02','2022-04-02 07:24:45','2022-04-03 07:24:45','506',0.00,0.00,'506','2022-04-02 14:46:55','506','2022-04-02 14:47:10',10,0),('1','149',257701,'DAILY','2022-04-02','2022-04-02 15:23:01','2022-04-03 15:23:01','506',0.00,0.00,'506','2022-04-02 20:03:04','506','2022-04-02 20:03:23',10,0),('1','149',257702,'DAILY','2022-04-03','2022-04-03 07:45:06','2022-04-04 07:45:06','506',0.00,0.00,'506','2022-04-03 19:17:42','506','2022-04-03 19:18:13',10,0),('1','149',257703,'DAILY shift','2022-04-04','2022-04-04 07:04:55','2022-04-05 07:04:55','506',0.00,0.00,'506','2022-04-04 19:21:31','506','2022-04-04 19:21:51',10,0),('1','149',257704,'DAILY shift','2022-04-05','2022-04-05 08:58:16','2022-04-06 08:58:16','506',0.00,0.00,'506','2022-04-05 18:44:49','506','2022-04-05 18:45:07',10,0),('1','149',257705,'DAILY shift','2022-04-06','2022-04-06 07:22:43','2022-04-07 07:22:43','506',0.00,0.00,'506','2022-04-06 19:07:27','506','2022-04-06 19:07:49',10,0),('1','149',257706,'DAILY','2022-04-07','2022-04-07 06:58:33','2022-04-08 06:58:33','506',0.00,0.00,'506','2022-04-07 18:59:05','506','2022-04-07 18:59:29',10,0),('1','149',257707,'DAILY shift','2022-04-08','2022-04-08 06:57:35','2022-04-09 06:57:35','506',0.00,0.00,'506','2022-04-08 18:49:40','506','2022-04-08 18:50:08',10,0),('1','149',257708,'DAILY shift','2022-04-09','2022-04-09 08:11:50','2022-04-10 08:11:50','506',0.00,0.00,'506','2022-04-09 18:41:26','506','2022-04-09 18:41:44',10,0),('1','149',257709,'DAILY shift','2022-04-10','2022-04-10 07:25:56','2022-04-11 07:25:56','506',0.00,0.00,'506','2022-04-10 13:16:46','506','2022-04-10 13:17:06',10,0),('1','149',257710,'DAILY shift','2022-04-10','2022-04-10 13:21:30','2022-04-11 13:21:30','506',0.00,0.00,'506','2022-04-10 18:42:30','506','2022-04-10 18:42:48',10,0),('1','149',257711,'DAILY','2022-04-11','2022-04-11 07:11:51','2022-04-12 07:11:51','506',0.00,0.00,'506','2022-04-11 18:52:17','506','2022-04-11 18:52:43',10,0),('1','149',257712,'DAILY','2022-04-12','2022-04-12 07:21:12','2022-04-13 07:21:12','506',0.00,0.00,'506','2022-04-12 18:53:24','506','2022-04-12 18:53:42',10,0),('1','149',257713,'DAILY','2022-04-13','2022-04-13 07:25:02','2022-04-14 07:25:02','506',0.00,0.00,'506','2022-04-13 18:59:41','506','2022-04-13 18:59:58',10,0),('1','149',257714,'DAILY shift','2022-04-14','2022-04-14 07:15:29','2022-04-15 07:15:29','506',0.00,0.00,'506','2022-04-14 19:13:53','506','2022-04-14 19:14:11',10,0),('1','149',257715,'DAILY','2022-04-15','2022-04-15 08:05:15','2022-04-16 08:05:15','506',0.00,0.00,'506','2022-04-15 16:38:35','506','2022-04-15 16:39:12',10,0),('1','149',257716,'DAILY','2022-04-16','2022-04-16 10:00:27','2022-04-17 10:00:27','506',0.00,0.00,'506','2022-04-16 19:08:46','506','2022-04-16 19:09:03',10,0),('1','149',257717,'DAILY','2022-04-17','2022-04-17 07:00:06','2022-04-18 07:00:06','506',0.00,0.00,'506','2022-04-17 18:59:23','506','2022-04-17 18:59:44',10,0),('1','149',257718,'DAILY shift','2022-04-18','2022-04-18 07:11:06','2022-04-19 07:11:06','506',0.00,0.00,'506','2022-04-18 18:58:34','506','2022-04-18 18:58:54',10,0),('1','149',257719,'DAILY','2022-04-19','2022-04-19 07:08:26','2022-04-20 07:08:26','506',0.00,0.00,'506','2022-04-19 19:11:11','506','2022-04-19 19:11:28',10,0),('1','149',257720,'DAILY shift','2022-04-20','2022-04-20 07:05:42','2022-04-21 07:05:42','506',0.00,0.00,'506','2022-04-20 18:49:39','506','2022-04-20 18:50:07',10,0),('1','149',257721,'DAILY','2022-04-21','2022-04-21 07:09:04','2022-04-22 07:09:04','506',0.00,0.00,'506','2022-04-21 17:05:30','506','2022-04-21 17:05:48',10,0),('1','149',257722,'DAILY shift','2022-04-22','2022-04-22 16:00:02','2022-04-23 16:00:02','506',0.00,0.00,'506','2022-04-22 19:15:11','506','2022-04-22 19:15:28',10,0),('1','149',257723,'DAILY shift','2022-04-23','2022-04-23 08:00:52','2022-04-24 08:00:52','506',0.00,0.00,'506','2022-04-23 19:07:10','506','2022-04-23 19:07:30',10,0),('1','149',257724,'DAILY shift','2022-04-24','2022-04-24 07:31:07','2022-04-25 07:31:07','506',0.00,0.00,'506','2022-04-24 18:44:16','506','2022-04-24 18:44:32',10,0),('1','149',257725,'DAILY','2022-04-25','2022-04-25 07:02:17','2022-04-26 07:02:17','506',0.00,0.00,'506','2022-04-25 18:54:49','506','2022-04-25 18:55:14',10,0),('1','149',257726,'DAILY shift','2022-04-26','2022-04-26 07:26:12','2022-04-27 07:26:12','506',0.00,0.00,'506','2022-04-26 18:53:29','506','2022-04-26 18:53:49',10,0),('1','149',257727,'DAILY','2022-04-27','2022-04-27 07:07:46','2022-04-28 07:07:46','506',0.00,0.00,'506','2022-04-27 18:12:01','506','2022-04-27 18:12:36',10,0),('1','149',257728,'DAILY shift','2022-04-28','2022-04-28 07:36:05','2022-04-29 07:36:05','506',0.00,0.00,'506','2022-04-28 19:43:24','506','2022-04-28 19:43:47',10,0),('1','149',257729,'DAILY','2022-04-29','2022-04-29 12:11:11','2022-04-30 12:11:11','506',0.00,0.00,'506','2022-04-29 19:10:47','506','2022-04-29 19:11:10',10,0),('1','149',257730,'DAILY shift','2022-04-30','2022-04-30 06:55:40','2022-05-01 06:55:40','506',0.00,0.00,'506','2022-04-30 19:34:36','506','2022-04-30 19:34:55',10,0),('1','149',257731,'DAILY shift','2022-05-01','2022-05-01 07:41:13','2022-05-02 07:41:13','506',0.00,0.00,'506','2022-05-01 16:14:44','506','2022-05-01 16:15:02',10,0),('1','149',257732,'DAILY shift','2022-05-02','2022-05-02 11:04:36','2022-05-03 11:04:36','506',0.00,0.00,'506','2022-05-02 17:59:17','506','2022-05-02 17:59:48',10,0),('1','149',257733,'DAILY shift','2022-05-03','2022-05-03 07:21:53','2022-05-04 07:21:53','506',0.00,0.00,'506','2022-05-03 19:04:28','506','2022-05-03 19:04:48',10,0),('1','149',257734,'DAILY','2022-05-04','2022-05-04 08:45:09','2022-05-05 08:45:09','506',0.00,0.00,'506','2022-05-04 19:18:52','506','2022-05-04 19:19:13',10,0),('1','149',257735,'DAILY shift','2022-05-05','2022-05-05 07:04:35','2022-05-06 07:04:35','506',0.00,0.00,'506','2022-05-05 19:21:30','506','2022-05-05 19:21:50',10,0),('1','149',257736,'DAILY','2022-05-06','2022-05-06 11:32:28','2022-05-07 11:32:28','506',0.00,0.00,'506','2022-05-07 12:55:54','506','2022-05-07 12:56:17',10,0),('1','149',257737,'DAILY','2022-05-19','2022-05-19 15:34:08','2022-05-20 15:34:08','506',0.00,0.00,'506','2022-05-19 18:50:06','506','2022-05-19 18:50:24',10,0),('1','149',257738,'DAILY shift','2022-05-20','2022-05-20 08:12:58','2022-05-21 08:12:58','506',0.00,0.00,'506','2022-05-20 18:56:34','506','2022-05-20 18:56:53',10,0),('1','149',257739,'DAILY shift','2022-05-21','2022-05-21 07:40:24','2022-05-22 07:40:24','506',0.00,0.00,'506','2022-05-21 19:03:20','506','2022-05-21 19:04:50',10,0),('1','149',257740,'DAILY shift','2022-05-22','2022-05-22 06:50:38','2022-05-23 06:50:38','506',0.00,0.00,'506','2022-05-22 18:47:05','506','2022-05-22 18:47:27',10,0),('1','149',257741,'DAILY','2022-05-23','2022-05-23 06:42:48','2022-05-24 06:42:48','506',0.00,0.00,'506','2022-05-23 18:42:25','506','2022-05-23 18:42:41',10,0),('1','149',257742,'DAILY','2022-05-24','2022-05-24 06:58:40','2022-05-25 06:58:40','506',0.00,0.00,'506','2022-05-24 11:06:51','506','2022-05-24 11:07:16',10,0),('1','149',257743,'DAILY','2022-05-24','2022-05-24 11:52:39','2022-05-25 11:52:39','506',0.00,0.00,'506','2022-05-24 18:52:31','506','2022-05-24 18:52:49',10,0),('1','149',257744,'DAILY','2022-05-25','2022-05-25 07:02:14','2022-05-26 07:02:14','506',0.00,0.00,'506','2022-05-25 10:32:24','506','2022-05-25 10:32:46',10,0),('1','149',257745,'DAILY','2022-05-25','2022-05-25 10:33:07','2022-05-26 10:33:07','506',0.00,0.00,'506','2022-05-25 18:27:08','506','2022-05-25 18:27:26',10,0),('1','149',257746,'DAILY','2022-05-26','2022-05-26 07:02:36','2022-05-27 07:02:36','506',0.00,0.00,'506','2022-05-26 18:54:33','506','2022-05-26 18:54:53',10,0),('1','149',257747,'DAILY','2022-05-27','2022-05-27 07:12:33','2022-05-28 07:12:33','506',0.00,0.00,'506','2022-05-28 09:29:25','506','2022-05-28 09:29:45',10,0),('1','149',257748,'DAILY','2022-05-27','2022-05-28 09:35:19','2022-05-29 09:35:19','506',0.00,0.00,'506','2022-05-28 09:37:33','506','2022-05-28 09:37:51',10,0),('1','149',257749,'DAILY','2022-05-28','2022-05-28 11:12:37','2022-05-29 11:12:37','506',0.00,0.00,'506','2022-05-28 18:53:29','506','2022-05-28 18:53:48',10,0),('1','149',257750,'DAILY','2022-05-29','2022-05-29 06:47:46','2022-05-30 06:47:46','506',0.00,0.00,'506','2022-05-29 18:45:00','506','2022-05-29 18:45:19',10,0),('1','149',257751,'DAILY shift','2022-05-30','2022-05-30 06:56:18','2022-05-31 06:56:18','506',0.00,0.00,'506','2022-05-30 18:42:50','506','2022-05-30 18:43:08',10,0),('1','149',257752,'DAILY shift','2022-05-31','2022-05-31 06:51:27','2022-06-01 06:51:27','506',0.00,0.00,'506','2022-05-31 18:52:13','506','2022-05-31 18:52:41',10,0),('1','149',257753,'DAILY shift','2022-06-01','2022-06-01 07:31:46','2022-06-02 07:31:46','506',0.00,0.00,'506','2022-06-01 18:56:15','506','2022-06-01 18:56:35',10,0),('1','149',257754,'DAILY','2022-06-02','2022-06-02 06:58:06','2022-06-03 06:58:06','506',0.00,0.00,'506','2022-06-02 17:55:56','506','2022-06-02 17:56:16',10,0),('1','149',257755,'DAILY shift','2022-06-04','2022-06-04 11:12:46','2022-06-05 11:12:46','506',0.00,0.00,'506','2022-06-04 19:10:03','506','2022-06-04 19:10:34',10,0),('1','149',257756,'New shift','2022-06-05','2022-06-05 07:15:49','2022-06-06 07:15:49','506',0.00,0.00,'506','2022-06-05 19:08:21','506','2022-06-05 19:08:40',10,0),('1','149',257757,'DAILY','2022-06-06','2022-06-06 06:42:52','2022-06-07 06:42:52','506',0.00,0.00,'506','2022-06-06 19:26:57','506','2022-06-06 19:27:13',10,0),('1','149',257758,'DAILY shift','2022-06-07','2022-06-07 07:10:35','2022-06-08 07:10:35','506',0.00,0.00,'506','2022-06-07 19:35:57','506','2022-06-07 19:36:17',10,0),('1','149',257759,'DAILY','2022-06-08','2022-06-08 06:25:07','2022-06-09 06:25:07','506',0.00,0.00,'506','2022-06-08 19:02:03','506','2022-06-08 19:02:24',10,0),('1','149',257760,'DAILY shift','2022-06-09','2022-06-09 07:11:16','2022-06-10 07:11:16','506',0.00,0.00,'506','2022-06-10 10:34:18','506','2022-06-10 10:34:42',10,0),('1','149',257761,'Daily shift','2022-06-10','2022-06-11 09:47:33','2022-06-12 09:47:33','506',0.00,0.00,'506','2022-06-11 09:52:44','506','2022-06-11 09:53:26',10,0),('1','149',257762,'DAILY SHIFT','2022-06-11','2022-06-11 09:55:52','2022-06-12 09:55:52','506',0.00,0.00,'506','2022-06-11 19:00:05','506','2022-06-11 19:00:27',10,0),('1','149',257763,'DAILY','2022-06-12','2022-06-12 06:50:13','2022-06-13 06:50:13','506',0.00,0.00,'506','2022-06-12 18:57:11','506','2022-06-12 18:57:29',10,0),('1','149',257764,'DAILY shift','2022-06-13','2022-06-13 06:48:10','2022-06-14 06:48:10','506',0.00,0.00,'506','2022-06-13 19:04:52','506','2022-06-13 19:05:15',10,0),('1','149',257765,'DAILY','2022-06-14','2022-06-14 06:28:52','2022-06-15 06:28:52','506',0.00,0.00,'506','2022-06-14 18:57:50','506','2022-06-14 18:58:07',10,0),('1','149',257766,'DAILY shift','2022-06-15','2022-06-15 06:54:22','2022-06-16 06:54:22','506',0.00,0.00,'506','2022-06-15 19:14:51','506','2022-06-15 19:15:10',10,0),('1','149',257767,'DAILY shift','2022-06-16','2022-06-16 06:49:26','2022-06-17 06:49:26','506',0.00,0.00,'506','2022-06-16 19:49:53','506','2022-06-16 19:50:19',10,0),('1','149',257768,'DAILY shift','2022-06-17','2022-06-17 10:13:00','2022-06-18 10:13:00','506',0.00,0.00,'506','2022-06-17 10:15:06','506','2022-06-17 10:15:26',10,0),('1','149',257769,'DAILY shift','2022-06-18','2022-06-18 09:29:36','2022-06-19 09:29:36','506',0.00,0.00,'506','2022-06-18 19:13:17','506','2022-06-18 19:13:39',10,0),('1','149',257770,'DAILY shift','2022-06-19','2022-06-19 07:07:13','2022-06-20 07:07:13','506',0.00,0.00,'506','2022-06-19 19:06:10','506','2022-06-19 19:06:31',10,0),('1','149',257771,'DAILY','2022-06-20','2022-06-20 07:26:23','2022-06-21 07:26:23','506',0.00,0.00,'506','2022-06-20 19:20:23','506','2022-06-20 19:21:46',10,0),('1','149',257772,'DAILY shift','2022-06-21','2022-06-21 07:07:01','2022-06-22 07:07:01','506',0.00,0.00,'506','2022-06-21 19:06:45','506','2022-06-21 19:07:04',10,0),('1','149',257773,'DAILY','2022-06-22','2022-06-22 07:26:45','2022-06-23 07:26:45','506',0.00,0.00,'506','2022-06-22 19:16:16','506','2022-06-22 19:16:37',10,0),('1','149',257774,'DAILY shift','2022-06-23','2022-06-23 07:29:10','2022-06-24 07:29:10','506',0.00,0.00,'506','2022-06-23 19:24:06','506','2022-06-23 19:24:27',10,0),('1','149',257775,'DAILY','2022-06-24','2022-06-24 10:58:08','2022-06-25 10:58:08','506',0.00,0.00,'506','2022-06-24 18:20:12','506','2022-06-24 18:20:34',10,0),('1','149',257776,'DAILY','2022-06-25','2022-06-25 10:19:09','2022-06-26 10:19:09','506',0.00,0.00,'506','2022-06-25 11:02:39','506','2022-06-25 11:02:56',10,0),('1','149',257777,'DAILY shift','2022-06-25','2022-06-25 11:15:47','2022-06-26 11:15:47','506',0.00,0.00,'506','2022-06-25 19:15:27','506','2022-06-25 19:15:46',10,0),('1','149',257778,'DAILY','2022-06-26','2022-06-26 07:09:29','2022-06-27 07:09:29','506',0.00,0.00,'506','2022-06-26 19:42:04','506','2022-06-26 19:42:23',10,0),('1','149',257779,'DAILY shift','2022-06-27','2022-06-27 07:35:24','2022-06-28 07:35:24','506',0.00,0.00,'506','2022-06-27 19:17:23','506','2022-06-27 19:17:42',10,0),('1','149',257780,'DAILY','2022-06-28','2022-06-28 07:01:19','2022-06-29 07:01:19','506',0.00,0.00,'506','2022-06-28 19:09:20','506','2022-06-28 19:09:40',10,0),('1','149',257781,'Daily shift','2022-06-29','2022-06-29 07:03:18','2022-06-30 07:03:18','506',0.00,0.00,'506','2022-06-29 19:15:41','506','2022-06-29 19:16:16',10,0),('1','149',257782,'DAILY SHIFT','2022-06-30','2022-06-30 07:09:04','2022-07-01 07:09:04','506',0.00,0.00,'506','2022-06-30 19:03:39','506','2022-06-30 19:04:00',10,0),('1','149',257783,'DAILY','2022-07-01','2022-07-01 06:30:27','2022-07-02 06:30:27','506',0.00,0.00,'506','2022-07-01 16:46:16','506','2022-07-01 16:46:36',10,0),('1','149',257784,'DAILY shift','2022-07-02','2022-07-02 10:37:59','2022-07-03 10:37:59','506',0.00,0.00,'506','2022-07-02 19:31:46','506','2022-07-02 19:32:08',10,0),('1','149',257785,'DAILY shift','2022-07-03','2022-07-03 06:55:55','2022-07-04 06:55:55','506',0.00,0.00,'506','2022-07-03 19:03:56','506','2022-07-03 19:04:14',10,0),('1','149',257786,'Daily shift','2022-07-04','2022-07-04 06:36:59','2022-07-05 06:36:59','506',0.00,0.00,'506','2022-07-04 19:11:11','506','2022-07-04 19:11:30',10,0),('1','149',257787,'DAILY shift','2022-07-05','2022-07-05 07:11:51','2022-07-06 07:11:51','506',0.00,0.00,'506','2022-07-05 19:38:26','506','2022-07-05 19:38:47',10,0),('1','149',257788,'DAILY','2022-07-06','2022-07-06 07:26:16','2022-07-07 07:26:16','506',0.00,0.00,'506','2022-07-06 15:29:33','506','2022-07-06 15:29:53',10,0),('1','149',257789,'DAILY','2022-07-06','2022-07-06 15:45:31','2022-07-07 15:45:31','506',0.00,0.00,'506','2022-07-06 19:15:34','506','2022-07-06 19:15:57',10,0),('1','149',257790,'Daily shift','2022-07-07','2022-07-07 06:49:08','2022-07-08 06:49:08','506',0.00,0.00,'506','2022-07-07 19:07:04','506','2022-07-07 19:07:27',10,0),('1','149',257791,'DAILY','2022-07-08','2022-07-08 07:37:41','2022-07-09 07:37:41','506',0.00,0.00,'506','2022-07-08 19:21:58','506','2022-07-08 19:22:15',10,0),('1','149',257792,'DAILY shift','2022-07-09','2022-07-09 10:36:46','2022-07-10 10:36:46','506',0.00,0.00,'506','2022-07-09 18:08:25','506','2022-07-09 18:08:44',10,0),('1','149',257793,'DAILY','2022-07-10','2022-07-10 07:40:25','2022-07-11 07:40:25','506',0.00,0.00,'506','2022-07-10 18:19:46','506','2022-07-10 18:20:06',10,0),('1','149',257794,'DAILY shift','2022-07-11','2022-07-11 06:52:12','2022-07-12 06:52:12','506',0.00,0.00,'506','2022-07-11 19:17:03','506','2022-07-11 19:19:10',10,0),('1','149',257795,'Daily shift','2022-07-12','2022-07-12 06:57:29','2022-07-13 06:57:29','506',0.00,0.00,'506','2022-07-12 18:58:45','506','2022-07-12 18:59:07',10,0),('1','149',257796,'Daily shift','2022-07-13','2022-07-13 06:59:07','2022-07-14 06:59:07','506',0.00,0.00,'506','2022-07-13 13:45:07','506','2022-07-13 13:45:26',10,0),('1','149',257797,'DAILY','2022-07-14','2022-07-14 13:19:42','2022-07-15 13:19:42','506',0.00,0.00,'506','2022-07-14 19:20:55','506','2022-07-14 19:21:13',10,0),('1','149',257798,'DAILY shift','2022-07-15','2022-07-15 06:58:40','2022-07-16 06:58:40','506',0.00,0.00,'506','2022-07-15 19:14:55','506','2022-07-15 19:15:44',10,0),('1','149',257799,'Daily shift','2022-07-16','2022-07-16 07:09:01','2022-07-17 07:09:01','506',0.00,0.00,'506','2022-07-16 19:15:14','506','2022-07-16 19:15:55',10,0),('1','149',257800,'DAILY shift','2022-07-17','2022-07-17 07:06:20','2022-07-18 07:06:20','506',0.00,0.00,'506','2022-07-17 19:18:28','506','2022-07-17 19:18:55',10,0),('1','149',257801,'DAILY','2022-07-18','2022-07-18 06:59:56','2022-07-19 06:59:56','506',0.00,0.00,'506','2022-07-18 19:10:21','506','2022-07-18 19:10:42',10,0),('1','149',257802,'DAILY shift','2022-07-19','2022-07-19 07:12:23','2022-07-20 07:12:23','506',0.00,0.00,'506','2022-07-19 17:20:50','506','2022-07-19 17:23:13',10,0),('1','149',257803,'DAILY','2022-07-20','2022-07-20 08:16:45','2022-07-21 08:16:45','506',0.00,0.00,'506','2022-07-20 18:58:59','506','2022-07-20 18:59:36',10,0),('1','149',257804,'DAILY shift','2022-07-21','2022-07-21 06:37:02','2022-07-22 06:37:02','506',0.00,0.00,'506','2022-07-21 19:23:11','506','2022-07-21 19:23:56',10,0),('1','149',257805,'Daily shift','2022-07-22','2022-07-22 07:16:15','2022-07-23 07:16:15','506',0.00,0.00,'506','2022-07-22 19:25:48','506','2022-07-22 19:26:13',10,0),('1','149',257806,'DAILY','2022-07-23','2022-07-23 07:33:13','2022-07-24 07:33:13','506',0.00,0.00,'506','2022-07-23 19:09:13','506','2022-07-23 19:09:35',10,0),('1','149',257807,'DAILY','2022-07-24','2022-07-24 07:13:01','2022-07-25 07:13:01','506',0.00,0.00,'506','2022-07-24 10:34:51','506','2022-07-24 10:35:09',10,0),('1','149',257808,'DAILY','2022-07-24','2022-07-24 11:03:55','2022-07-25 11:03:55','506',0.00,0.00,'506','2022-07-24 18:53:43','506','2022-07-24 18:54:02',10,0),('1','149',257809,'DAILY shift','2022-07-25','2022-07-25 07:20:47','2022-07-26 07:20:47','506',0.00,0.00,'506','2022-07-25 19:05:39','506','2022-07-25 19:06:23',10,0),('1','149',257810,'DAILY shift','2022-07-26','2022-07-26 07:21:30','2022-07-27 07:21:30','506',0.00,0.00,'506','2022-07-26 19:23:51','506','2022-07-26 19:24:46',10,0),('1','149',257811,'DAILY shift','2022-07-27','2022-07-27 07:40:29','2022-07-28 07:40:29','506',0.00,0.00,'506','2022-07-27 19:12:38','506','2022-07-27 19:13:24',10,0),('1','149',257812,'DAILY shift','2022-07-28','2022-07-28 07:49:24','2022-07-29 07:49:24','506',0.00,0.00,'506','2022-07-28 19:17:56','506','2022-07-28 19:18:44',10,0),('1','149',257813,'DAILY shift','2022-07-29','2022-07-29 07:25:19','2022-07-30 07:25:19','506',0.00,0.00,'506','2022-07-29 11:44:30','506','2022-07-29 11:45:08',10,0),('1','149',257814,'DAILY shift','2022-07-29','2022-07-29 12:06:48','2022-07-30 12:06:48','506',0.00,0.00,'506','2022-07-29 19:22:57','506','2022-07-29 19:23:36',10,0),('1','149',257815,'DAILY shift','2022-07-30','2022-07-30 09:28:28','2022-07-31 09:28:28','506',0.00,0.00,'506','2022-07-30 19:17:56','506','2022-07-30 19:19:12',10,0),('1','149',257816,'DAILY shift','2022-07-31','2022-07-31 07:31:59','2022-08-01 07:31:59','506',0.00,0.00,'506','2022-08-01 07:51:33','506','2022-08-01 07:53:28',10,0),('1','149',257817,'DAILY shift','2022-08-01','2022-08-01 07:53:56','2022-08-02 07:53:56','506',0.00,0.00,'506','2022-08-01 10:53:13','506','2022-08-01 10:53:59',10,0),('1','149',257818,'DAILY shift','2022-08-01','2022-08-01 11:19:27','2022-08-02 11:19:27','506',0.00,0.00,'506','2022-08-01 18:54:35','506','2022-08-01 18:55:49',10,0),('1','149',257819,'DAILY shift','2022-08-02','2022-08-02 07:40:02','2022-08-03 07:40:02','506',0.00,0.00,'506','2022-08-02 19:11:02','506','2022-08-02 19:11:40',10,0),('1','149',257820,'DAILY shift','2022-08-03','2022-08-03 08:08:21','2022-08-04 08:08:21','506',0.00,0.00,'506','2022-08-03 18:45:12','506','2022-08-03 18:46:00',10,0),('1','149',257821,'DAILY shift','2022-08-04','2022-08-04 07:54:09','2022-08-05 07:54:09','506',0.00,0.00,'506','2022-08-04 17:03:59','506','2022-08-04 17:04:43',10,0),('1','149',257822,'DAILY shift','2022-08-05','2022-08-05 07:21:55','2022-08-06 07:21:55','506',0.00,0.00,'506','2022-08-05 07:56:44','506','2022-08-05 07:57:11',10,0),('1','149',257823,'DAILY shift','2022-08-05','2022-08-05 09:13:35','2022-08-06 09:13:35','506',0.00,0.00,'506','2022-08-05 19:14:46','506','2022-08-05 19:15:17',10,0),('1','149',257824,'DAILY SHIFT','2022-08-06','2022-08-06 07:20:07','2022-08-07 07:20:07','506',0.00,0.00,'506','2022-08-06 19:19:46','506','2022-08-06 19:20:08',10,0),('1','149',257825,'DAILY SHIFT','2022-08-07','2022-08-07 07:33:11','2022-08-08 07:33:11','506',0.00,0.00,'506','2022-08-07 19:18:45','506','2022-08-07 19:19:04',10,0),('1','149',257826,'DAILY shift','2022-08-08','2022-08-08 07:24:44','2022-08-09 07:24:44','506',0.00,0.00,'506','2022-08-08 14:05:53','506','2022-08-08 14:06:16',10,0),('1','149',257827,'DAILY shift','2022-08-08','2022-08-08 14:09:17','2022-08-09 14:09:17','506',0.00,0.00,'506','2022-08-08 19:06:25','506','2022-08-08 19:07:48',10,0),('1','149',257828,'DAILY SHIFT','2022-08-09','2022-08-09 06:59:48','2022-08-10 06:59:48','506',0.00,0.00,'506','2022-08-09 17:01:58','506','2022-08-09 17:02:17',10,0),('1','149',257829,'DAILY shift','2022-08-10','2022-08-10 08:31:34','2022-08-11 08:31:34','506',0.00,0.00,'506','2022-08-10 08:34:47','506','2022-08-10 08:36:32',10,0),('1','149',257830,'DAILY shift','2022-08-10','2022-08-10 11:47:31','2022-08-11 11:47:31','506',0.00,0.00,'506','2022-08-10 19:18:11','506','2022-08-10 19:18:53',10,0),('1','149',257831,'DAILY SHIFT','2022-08-11','2022-08-11 07:03:20','2022-08-12 07:03:20','506',0.00,0.00,'506','2022-08-11 19:16:00','506','2022-08-11 19:16:29',10,0),('1','149',257832,'DAILY shift','2022-08-12','2022-08-12 07:57:11','2022-08-13 07:57:11','506',0.00,0.00,'506','2022-08-12 19:18:35','506','2022-08-12 19:20:08',10,0),('1','149',257833,'DAILY shift','2022-08-13','2022-08-13 09:20:35','2022-08-14 09:20:35','506',0.00,0.00,'506','2022-08-13 18:36:23','506','2022-08-13 18:37:03',10,0),('1','149',257834,'DAILY shift','2022-08-14','2022-08-14 10:10:06','2022-08-15 10:10:06','506',0.00,0.00,'506','2022-08-14 13:46:56','506','2022-08-14 13:47:14',10,0),('1','149',257835,'DAILY','2022-08-14','2022-08-14 13:47:51','2022-08-15 13:47:51','506',0.00,0.00,'506','2022-08-14 18:40:20','506','2022-08-14 18:40:38',10,0),('1','149',257836,'DAILY SHIFT','2022-08-15','2022-08-15 09:42:00','2022-08-16 09:42:00','506',0.00,0.00,'506','2022-08-15 15:49:49','506','2022-08-15 15:50:10',10,0),('1','149',257837,'DAILY shift','2022-08-15','2022-08-15 16:02:26','2022-08-16 16:02:26','506',0.00,0.00,'506','2022-08-15 19:00:50','506','2022-08-15 19:01:10',10,0),('1','149',257838,'DAILY shift','2022-08-16','2022-08-16 07:18:46','2022-08-17 07:18:46','506',0.00,0.00,'506','2022-08-16 19:12:25','506','2022-08-16 19:13:28',10,0),('1','149',257839,'DAILY SHIFT','2022-08-17','2022-08-17 07:22:28','2022-08-18 07:22:28','506',0.00,0.00,'506','2022-08-17 19:12:33','506','2022-08-17 19:13:10',10,0),('1','149',257840,'DAILY shift','2022-08-18','2022-08-18 07:25:57','2022-08-19 07:25:57','506',0.00,0.00,'506','2022-08-18 19:00:02','506','2022-08-18 19:01:02',10,0),('1','149',257841,'DAILY SHIFT','2022-08-19','2022-08-19 07:29:19','2022-08-20 07:29:19','506',0.00,0.00,'506','2022-08-19 19:22:45','506','2022-08-19 19:23:33',10,0),('1','149',257842,'DAILY SHIFT','2022-08-20','2022-08-20 07:16:43','2022-08-21 07:16:43','506',0.00,0.00,'506','2022-08-20 11:51:14','506','2022-08-20 11:51:34',10,0),('1','149',257843,'DAILY shift','2022-08-20','2022-08-20 12:45:04','2022-08-21 12:45:04','506',0.00,0.00,'506','2022-08-20 19:17:57','506','2022-08-20 19:18:16',10,0),('1','149',257844,'DAILY SHIFT','2022-08-21','2022-08-21 07:08:13','2022-08-22 07:08:13','506',0.00,0.00,'506','2022-08-21 19:04:23','506','2022-08-21 19:04:41',10,0),('1','149',257845,'DAILY SHIFT','2022-08-22','2022-08-22 06:28:11','2022-08-23 06:28:11','506',0.00,0.00,'506','2022-08-22 19:33:27','506','2022-08-22 19:33:45',10,0),('1','149',257846,'DAILY SHIFT','2022-08-23','2022-08-23 07:20:07','2022-08-24 07:20:07','506',0.00,0.00,'506','2022-08-23 18:42:07','506','2022-08-23 18:42:28',10,0),('1','149',257847,'DAILY SHIFT','2022-08-24','2022-08-24 07:03:42','2022-08-25 07:03:42','506',0.00,0.00,'506','2022-08-24 18:40:46','506','2022-08-24 18:41:12',10,0),('1','149',257848,'DAILY SHIFT','2022-08-25','2022-08-25 07:18:39','2022-08-26 07:18:39','506',0.00,0.00,'506','2022-08-25 18:49:43','506','2022-08-25 18:50:03',10,0),('1','149',257849,'DAILY SHIFT ','2022-08-26','2022-08-26 08:32:05','2022-08-27 08:32:05','506',0.00,0.00,'506','2022-08-26 12:54:37','506','2022-08-26 12:55:00',10,0),('1','149',257850,'DAILY SHIFT','2022-08-28','2022-08-28 08:01:35','2022-08-29 08:01:35','506',0.00,0.00,'506','2022-08-28 20:17:23','506','2022-08-28 20:17:46',10,0),('1','149',257851,'DAILY SHIFT','2022-08-29','2022-08-29 07:13:43','2022-08-30 07:13:43','506',0.00,0.00,'506','2022-08-29 18:41:44','506','2022-08-29 18:42:04',10,0),('1','149',257852,'DAILY SHIFT','2022-08-30','2022-08-30 07:19:13','2022-08-31 07:19:13','506',0.00,0.00,'506','2022-08-30 19:02:31','506','2022-08-30 19:02:48',10,0),('1','149',257853,'DAILY SHIFT','2022-08-31','2022-08-31 07:18:52','2022-09-01 07:18:52','506',0.00,0.00,'506','2022-08-31 15:42:15','506','2022-08-31 15:42:46',10,0),('1','149',257854,'DAILY SHIFT','2022-08-31','2022-08-31 17:08:15','2022-09-01 17:08:15','506',0.00,0.00,'506','2022-09-01 07:45:06','506','2022-09-01 07:45:28',10,0),('1','149',257855,'DAILY SHIFT','2022-09-01','2022-09-01 07:45:54','2022-09-02 07:45:54','506',0.00,0.00,'506','2022-09-01 18:52:15','506','2022-09-01 18:52:37',10,0),('1','149',257856,'DAILY SHIFT','2022-09-02','2022-09-02 07:00:58','2022-09-03 07:00:58','506',0.00,0.00,'506','2022-09-02 18:33:57','506','2022-09-02 18:34:31',10,0),('1','149',257857,'DAILY SHIFT','2022-09-03','2022-09-03 07:22:37','2022-09-04 07:22:37','506',0.00,0.00,'506','2022-09-03 18:45:05','506','2022-09-03 18:45:29',10,0),('1','149',257858,'DAILY SHIFT','2022-09-04','2022-09-04 07:02:33','2022-09-05 07:02:33','506',0.00,0.00,'506','2022-09-04 18:46:17','506','2022-09-04 18:46:42',10,0),('1','149',257859,'DAILY SHIFT','2022-09-05','2022-09-05 07:12:05','2022-09-06 07:12:05','506',0.00,0.00,'506','2022-09-05 08:57:24','506','2022-09-05 08:57:42',10,0),('1','149',257860,'DAILY SHIFT','2022-09-05','2022-09-05 13:23:17','2022-09-06 13:23:17','506',0.00,0.00,'506','2022-09-05 18:59:04','506','2022-09-05 18:59:24',10,0),('1','149',257861,'DAILY SHIFT','2022-09-06','2022-09-06 07:11:13','2022-09-07 07:11:13','506',0.00,0.00,'506','2022-09-06 18:36:16','506','2022-09-06 18:37:35',10,0),('1','149',257862,'DAILY SHIFT','2022-09-07','2022-09-07 06:48:36','2022-09-08 06:48:36','506',0.00,0.00,'506','2022-09-07 18:48:09','506','2022-09-07 18:48:29',10,0),('1','149',257863,'DAILY SHIFT','2022-09-08','2022-09-08 06:56:49','2022-09-09 06:56:49','506',0.00,0.00,'506','2022-09-08 16:37:17','506','2022-09-08 16:37:42',10,0),('1','149',257864,'DAILY SHIFT','2022-09-09','2022-09-09 08:55:49','2022-09-10 08:55:49','506',0.00,0.00,'506','2022-09-09 18:38:00','506','2022-09-09 18:38:24',10,0),('1','149',257865,'DAILY SHIFT','2022-09-10','2022-09-10 07:03:07','2022-09-11 07:03:07','506',0.00,0.00,'506','2022-09-10 18:21:30','506','2022-09-10 18:21:53',10,0),('1','149',257866,'DAILY SHIFT','2022-09-11','2022-09-11 06:58:14','2022-09-12 06:58:14','506',0.00,0.00,'506','2022-09-11 18:31:08','506','2022-09-11 18:31:30',10,0),('1','149',257867,'DAILY SHIFT','2022-09-12','2022-09-12 07:05:27','2022-09-13 07:05:27','506',0.00,0.00,'506','2022-09-12 18:26:52','506','2022-09-12 18:27:21',10,0),('1','149',257868,'DAILY SHIFT','2022-09-13','2022-09-13 06:43:15','2022-09-14 06:43:15','506',0.00,0.00,'506','2022-09-13 18:32:20','506','2022-09-13 18:32:46',10,0),('1','149',257869,'DAILY SHIFT','2022-09-14','2022-09-14 07:09:02','2022-09-15 07:09:02','506',0.00,0.00,'506','2022-09-14 13:11:34','506','2022-09-14 13:11:59',10,0),('1','149',257870,'DAILY SHIFT','2022-09-14','2022-09-14 17:43:36','2022-09-15 17:43:36','506',0.00,0.00,'506','2022-09-14 18:29:18','506','2022-09-14 18:29:38',10,0),('1','149',257871,'DAILY SHIFT','2022-09-15','2022-09-15 06:51:43','2022-09-16 06:51:43','506',0.00,0.00,'506','2022-09-15 18:40:17','506','2022-09-15 18:40:49',10,0),('1','149',257872,'DAILY SHIFT','2022-09-16','2022-09-16 07:28:40','2022-09-17 07:28:40','506',0.00,0.00,'506','2022-09-16 18:32:56','506','2022-09-16 18:33:17',10,0),('1','149',257873,'DAILY SHIFT','2022-09-17','2022-09-17 06:57:23','2022-09-18 06:57:23','506',0.00,0.00,'506','2022-09-17 18:39:31','506','2022-09-17 18:39:49',10,0),('1','149',257874,'DAILY SHIFT','2022-09-18','2022-09-18 07:10:17','2022-09-19 07:10:17','506',0.00,0.00,'506','2022-09-18 13:18:17','506','2022-09-18 13:18:37',10,0),('1','149',257875,'Operational loss','2022-09-19','2022-09-19 17:06:05','2022-09-20 17:06:05','506',0.00,0.00,'506','2022-09-19 17:33:25','506','2022-09-19 17:33:46',10,0),('1','149',257876,'DAILY SHIFT','2022-09-20','2022-09-20 11:15:30','2022-09-21 11:15:30','506',0.00,0.00,'506','2022-09-20 18:32:47','506','2022-09-20 18:33:09',10,0),('1','149',257877,'DAILY SHIFT','2022-09-21','2022-09-21 06:57:08','2022-09-22 06:57:08','506',0.00,0.00,'506','2022-09-21 19:05:36','506','2022-09-21 19:06:03',10,0),('1','149',257878,'DAILY SHIFT','2022-09-22','2022-09-22 06:43:56','2022-09-23 06:43:56','506',0.00,0.00,'506','2022-09-22 18:50:36','506','2022-09-22 18:51:06',10,0),('1','149',257879,'DAILY SHIFT','2022-09-23','2022-09-23 07:13:35','2022-09-24 07:13:35','506',0.00,0.00,'506','2022-09-23 18:34:52','506','2022-09-23 18:35:10',10,0),('1','149',257880,'DAILY SHIFT','2022-09-24','2022-09-24 06:54:56','2022-09-25 06:54:56','506',0.00,0.00,'506','2022-09-24 18:02:44','506','2022-09-24 18:03:07',10,0),('1','149',257881,'Operational loss','2022-09-25','2022-09-25 06:26:13','2022-09-26 06:26:13','506',0.00,0.00,'506','2022-09-25 14:43:22','506','2022-09-25 14:43:42',10,0),('1','149',257882,'DAILY SHIFT','2022-09-25','2022-09-25 14:44:06','2022-09-26 14:44:06','506',0.00,0.00,'506','2022-09-25 14:45:43','506','2022-09-25 14:46:07',10,0),('1','149',257883,'DAILY SHIFT','2022-09-25','2022-09-25 16:54:18','2022-09-26 16:54:18','506',0.00,0.00,'506','2022-09-25 19:07:03','506','2022-09-25 19:07:20',10,0),('1','149',257884,'DAILY SHIFT','2022-09-26','2022-09-26 07:23:45','2022-09-27 07:23:45','506',0.00,0.00,'506','2022-09-26 18:22:24','506','2022-09-26 18:23:25',10,0),('1','149',257885,'DAILY SHIFT','2022-09-27','2022-09-27 06:45:44','2022-09-28 06:45:44','506',0.00,0.00,'506','2022-09-27 18:53:13','506','2022-09-27 18:53:33',10,0),('1','149',257886,'DAILY SHIFT','2022-09-28','2022-09-28 06:51:40','2022-09-29 06:51:40','506',0.00,0.00,'506','2022-09-28 18:28:57','506','2022-09-28 18:29:16',10,0),('1','149',257887,'DAILY SHIFT','2022-09-29','2022-09-29 07:13:42','2022-09-30 07:13:42','506',0.00,0.00,'506','2022-09-29 14:14:41','506','2022-09-29 14:14:59',10,0),('1','149',257888,'operational loss','2022-09-29','2022-09-29 14:38:41','2022-09-30 14:38:41','506',0.00,0.00,'506','2022-09-29 14:42:13','506','2022-09-29 14:42:31',10,0),('1','149',257889,'DAILY SHIFT','2022-09-29','2022-09-29 14:55:51','2022-09-30 14:55:51','506',0.00,0.00,'506','2022-09-29 18:24:13','506','2022-09-29 18:24:36',10,0),('1','149',257890,'DAILY SHIFT','2022-09-30','2022-09-30 07:12:27','2022-10-01 07:12:27','506',0.00,0.00,'506','2022-09-30 18:39:01','506','2022-09-30 18:40:13',10,0),('1','149',257891,'DAILY SHIFT','2022-10-01','2022-10-01 07:43:37','2022-10-02 07:43:37','506',0.00,0.00,'506','2022-10-01 18:48:10','506','2022-10-01 18:48:31',10,0),('1','149',257892,'DAILY SHIFT','2022-10-02','2022-10-02 07:40:32','2022-10-03 07:40:32','506',0.00,0.00,'506','2022-10-02 18:28:15','506','2022-10-02 18:28:33',10,0),('1','149',257893,'DAILY SHIFT','2022-10-03','2022-10-03 07:18:12','2022-10-04 07:18:12','506',0.00,0.00,'506','2022-10-03 12:17:09','506','2022-10-03 12:17:51',10,0),('1','149',257894,'DAILY SHIFT','2022-10-04','2022-10-04 07:18:13','2022-10-05 07:18:13','506',0.00,0.00,'506','2022-10-04 08:22:19','506','2022-10-04 08:22:37',10,0),('1','149',257895,'Operational loss','2022-10-07','2022-10-07 06:15:28','2022-10-08 06:15:28','506',0.00,0.00,'506','2022-10-07 10:44:54','506','2022-10-07 10:45:26',10,0),('1','149',257896,'DAILY SHIFT','2022-10-07','2022-10-07 10:46:01','2022-10-08 10:46:01','506',0.00,0.00,'506','2022-10-07 19:24:08','506','2022-10-07 19:24:35',10,0),('1','149',257897,'DAILY SHIFT','2022-10-08','2022-10-08 06:57:02','2022-10-09 06:57:02','506',0.00,0.00,'506','2022-10-08 13:12:33','506','2022-10-08 13:13:00',10,0),('1','149',257898,'DAILY SHIFT','2022-10-09','2022-10-09 12:59:29','2022-10-10 12:59:29','506',0.00,0.00,'506','2022-10-09 13:00:42','506','2022-10-09 13:00:59',10,0),('1','149',257899,'operational loss','2022-10-11','2022-10-11 14:33:03','2022-10-12 14:33:03','506',0.00,0.00,'506','2022-10-11 14:38:26','506','2022-10-11 14:38:46',10,0),('1','149',257900,'DAILY SHIFT','2022-10-11','2022-10-11 15:29:23','2022-10-12 15:29:23','506',0.00,0.00,'506','2022-10-11 18:26:12','506','2022-10-11 18:26:40',10,0),('1','149',257901,'DAILY SHIFT','2022-10-12','2022-10-12 07:06:23','2022-10-13 07:06:23','506',0.00,0.00,'506','2022-10-12 18:28:27','506','2022-10-12 18:28:56',10,0),('1','149',257902,'DAILY SHIFT','2022-10-13','2022-10-13 07:02:47','2022-10-14 07:02:47','506',0.00,0.00,'506','2022-10-13 18:30:35','506','2022-10-13 18:30:53',10,0),('1','149',257903,'DAILY SHIFT','2022-10-14','2022-10-14 06:50:39','2022-10-15 06:50:39','506',0.00,0.00,'506','2022-10-14 15:26:45','506','2022-10-14 15:28:17',10,0),('1','149',257904,'DAILY SHIFT','2022-10-15','2022-10-15 07:12:18','2022-10-16 07:12:18','506',0.00,0.00,'506','2022-10-15 08:37:21','506','2022-10-15 08:37:44',10,0),('1','149',257905,'operational loss','2022-10-15','2022-10-15 12:04:12','2022-10-16 12:04:12','506',0.00,0.00,'506','2022-10-15 12:07:51','506','2022-10-15 12:08:10',10,0),('1','149',257906,'DAILY SHIFT','2022-10-15','2022-10-15 12:49:25','2022-10-16 12:49:25','506',0.00,0.00,'506','2022-10-15 18:50:38','506','2022-10-15 18:51:11',10,0),('1','149',257907,'DAILY SHIFT','2022-10-16','2022-10-16 06:45:56','2022-10-17 06:45:56','506',0.00,0.00,'506','2022-10-16 19:06:19','506','2022-10-16 19:06:37',10,0),('1','149',257908,'DAILY SHIFT','2022-10-17','2022-10-17 07:05:24','2022-10-18 07:05:24','506',0.00,0.00,'506','2022-10-17 16:54:43','506','2022-10-17 16:55:23',10,0),('1','149',257909,'DAILY SHIFT','2022-10-17','2022-10-17 16:55:41','2022-10-18 16:55:41','506',0.00,0.00,'506','2022-10-17 19:05:24','506','2022-10-17 19:05:41',10,0),('1','149',257910,'DAILY SHIFT','2022-10-18','2022-10-18 06:31:32','2022-10-19 06:31:32','506',0.00,0.00,'506','2022-10-18 18:41:01','506','2022-10-18 18:41:37',10,0),('1','149',257911,'DAILY SHIFT','2022-10-19','2022-10-19 06:44:00','2022-10-20 06:44:00','506',0.00,0.00,'506','2022-10-19 18:47:57','506','2022-10-19 18:48:18',10,0),('1','149',257912,'DAILY SHIFT','2022-10-20','2022-10-20 06:55:00','2022-10-21 06:55:00','506',0.00,0.00,'506','2022-10-20 10:21:38','506','2022-10-20 10:22:15',10,0),('1','149',257913,'DAILY SHIFT','2022-10-21','2022-10-21 08:16:22','2022-10-22 08:16:22','506',0.00,0.00,'506','2022-10-21 08:17:20','506','2022-10-21 08:17:42',10,0),('1','149',257914,'DAILY SHIFT','2022-10-21','2022-10-21 13:29:39','2022-10-22 13:29:39','506',0.00,0.00,'506','2022-10-21 18:32:22','506','2022-10-21 18:32:51',10,0),('1','149',257915,'DAILY SHIFT','2022-10-22','2022-10-22 07:06:33','2022-10-23 07:06:33','506',0.00,0.00,'506','2022-10-22 18:21:40','506','2022-10-22 18:22:04',10,0),('1','149',257916,'DAILY SHIFT','2022-10-23','2022-10-23 06:47:15','2022-10-24 06:47:15','506',0.00,0.00,'506','2022-10-23 18:19:16','506','2022-10-23 18:19:46',10,0),('1','149',257917,'DAILY SHIFT','2022-10-24','2022-10-24 07:13:37','2022-10-25 07:13:37','506',0.00,0.00,'506','2022-10-24 18:26:58','506','2022-10-24 18:27:18',10,0),('1','149',257918,'DAILY SHIFT','2022-10-25','2022-10-25 07:02:51','2022-10-26 07:02:51','506',0.00,0.00,'506','2022-10-25 16:38:51','506','2022-10-25 16:39:10',10,0),('1','149',257919,'DAILY SHIFT','2022-10-26','2022-10-26 06:36:10','2022-10-27 06:36:10','506',0.00,0.00,'506','2022-10-26 08:11:30','506','2022-10-26 08:11:47',10,0),('1','149',257920,'DAILY SHIFT','2022-10-26','2022-10-26 08:20:00','2022-10-27 08:20:00','506',0.00,0.00,'506','2022-10-26 18:28:07','506','2022-10-26 18:28:31',10,0),('1','149',257921,'DAILY SHIFT','2022-10-27','2022-10-27 07:08:48','2022-10-28 07:08:48','506',0.00,0.00,'506','2022-10-27 18:46:21','506','2022-10-27 18:46:43',10,0),('1','149',257922,'DAILY SHIFT','2022-10-28','2022-10-28 06:56:07','2022-10-29 06:56:07','506',0.00,0.00,'506','2022-10-28 18:43:03','506','2022-10-28 18:43:21',10,0),('1','149',257923,'DAILY SHIFT','2022-10-29','2022-10-29 10:07:36','2022-10-30 10:07:36','506',0.00,0.00,'506','2022-10-29 18:40:34','506','2022-10-29 18:40:53',10,0),('1','149',257924,'DAILY SHIFT','2022-10-30','2022-10-30 06:58:57','2022-10-31 06:58:57','506',0.00,0.00,'506','2022-10-30 08:30:04','506','2022-10-30 08:30:20',10,0),('1','149',257925,'DAILY SHIFT','2022-10-30','2022-10-30 09:14:20','2022-10-31 09:14:20','506',0.00,0.00,'506','2022-10-30 18:43:45','506','2022-10-30 18:45:00',10,0),('1','149',257926,'DAILY SHIFT','2022-10-31','2022-10-31 07:01:02','2022-11-01 07:01:02','506',0.00,0.00,'506','2022-10-31 18:35:31','506','2022-10-31 18:36:44',10,0),('1','149',257927,'DAILY SHIFT','2022-11-01','2022-11-01 06:56:56','2022-11-02 06:56:56','506',0.00,0.00,'506','2022-11-01 18:28:10','506','2022-11-01 18:28:30',10,0),('1','149',257928,'DAILY SHIFT','2022-11-02','2022-11-02 07:20:25','2022-11-03 07:20:25','506',0.00,0.00,'506','2022-11-02 18:12:41','506','2022-11-02 18:13:06',10,0),('1','149',257929,'DAILY SHIFT','2022-11-03','2022-11-03 06:59:41','2022-11-04 06:59:41','506',0.00,0.00,'506','2022-11-03 09:10:33','506','2022-11-03 09:11:04',10,0),('1','149',257930,'DAILY SHIFT','2022-11-04','2022-11-04 07:33:19','2022-11-05 07:33:19','506',0.00,0.00,'506','2022-11-04 07:36:07','506','2022-11-04 07:36:32',10,0),('1','149',257931,'DAILY SALES','2022-11-05','2022-11-05 11:22:36','2022-11-06 11:22:36','506',0.00,0.00,'506','2022-11-05 19:39:32','506','2022-11-05 19:39:57',10,0),('1','149',257932,'DAILY SHIFT','2022-11-06','2022-11-06 13:04:56','2022-11-07 13:04:56','506',0.00,0.00,'506','2022-11-06 18:18:23','506','2022-11-06 18:18:54',10,0),('1','149',257933,'DAILY SALES','2022-11-07','2022-11-07 06:27:56','2022-11-08 06:27:56','506',0.00,0.00,'506','2022-11-07 18:33:04','506','2022-11-07 18:33:27',10,0),('1','149',257934,'DAILY SHIFT','2022-11-08','2022-11-08 06:50:24','2022-11-09 06:50:24','506',0.00,0.00,'506','2022-11-08 18:39:24','506','2022-11-08 18:39:55',10,0),('1','149',257935,'DAILY SALES','2022-11-09','2022-11-09 06:46:52','2022-11-10 06:46:52','506',0.00,0.00,'506','2022-11-09 14:53:32','506','2022-11-09 14:53:51',10,0),('1','149',257936,'Operational loss','2022-11-09','2022-11-09 15:08:07','2022-11-10 15:08:07','506',0.00,0.00,'506','2022-11-09 15:11:58','506','2022-11-09 15:12:23',10,0),('1','149',257937,'DAILY SHIFT','2022-11-10','2022-11-10 09:07:05','2022-11-11 09:07:05','506',0.00,0.00,'506','2022-11-10 18:18:06','506','2022-11-10 18:18:26',10,0),('1','149',257938,'DAILY SALES','2022-11-11','2022-11-11 06:59:59','2022-11-12 06:59:59','506',0.00,0.00,'506','2022-11-11 18:10:38','506','2022-11-11 18:11:21',10,0),('1','149',257939,'DAILY SHIFT','2022-11-12','2022-11-12 07:07:31','2022-11-13 07:07:31','506',0.00,0.00,'506','2022-11-12 18:19:57','506','2022-11-12 18:20:16',10,0),('1','149',257940,'DAILY SALES','2022-11-13','2022-11-13 07:04:08','2022-11-14 07:04:08','506',0.00,0.00,'506','2022-11-13 18:00:38','506','2022-11-13 18:01:01',10,0),('1','149',257941,'DAILY SALES','2022-11-14','2022-11-14 06:59:28','2022-11-15 06:59:28','506',0.00,0.00,'506','2022-11-14 18:37:27','506','2022-11-14 18:37:48',10,0),('1','149',257942,'DAILY SALES','2022-11-15','2022-11-15 06:34:58','2022-11-16 06:34:58','506',0.00,0.00,'506','2022-11-15 17:55:50','506','2022-11-15 17:56:16',10,0),('1','149',257943,'DAILY SALES','2022-11-16','2022-11-16 07:15:07','2022-11-17 07:15:07','506',0.00,0.00,'506','2022-11-16 08:07:32','506','2022-11-16 08:07:51',10,0),('1','149',257944,'OPERATIONAL LOSS','2022-11-16','2022-11-16 09:31:24','2022-11-17 09:31:24','506',0.00,0.00,'506','2022-11-16 09:34:08','506','2022-11-16 09:34:25',10,0),('1','149',257945,'DAILY SALES','2022-11-16','2022-11-16 09:34:44','2022-11-17 09:34:44','506',0.00,0.00,'506','2022-11-16 18:17:52','506','2022-11-16 18:18:12',10,0),('1','149',257946,'DAILY SALES','2022-11-17','2022-11-17 06:54:49','2022-11-18 06:54:49','506',0.00,0.00,'506','2022-11-17 18:06:16','506','2022-11-17 18:10:50',10,0),('1','149',257947,'DAILY SALES','2022-11-18','2022-11-18 07:05:09','2022-11-19 07:05:09','506',0.00,0.00,'506','2022-11-18 18:20:56','506','2022-11-18 18:21:23',10,0),('1','149',257948,'DAILY SALES','2022-11-19','2022-11-19 06:54:35','2022-11-20 06:54:35','506',0.00,0.00,'506','2022-11-19 18:26:15','506','2022-11-19 18:26:41',10,0),('1','149',257949,'DAILY SALES','2022-11-20','2022-11-20 07:12:58','2022-11-21 07:12:58','506',0.00,0.00,'506','2022-11-20 18:40:28','506','2022-11-20 18:40:59',10,0),('1','149',257950,'DAILY SALES','2022-11-21','2022-11-21 07:03:16','2022-11-22 07:03:16','506',0.00,0.00,'506','2022-11-21 15:19:05','506','2022-11-21 15:19:56',10,0),('1','149',257951,'OPERATIONAL LOSS','2022-11-21','2022-11-21 17:19:47','2022-11-22 17:19:47','506',0.00,0.00,'506','2022-11-21 17:23:53','506','2022-11-21 17:24:23',10,0),('1','149',257952,'DAILY SALES','2022-11-22','2022-11-22 08:29:43','2022-11-23 08:29:43','506',0.00,0.00,'506','2022-11-22 18:19:51','506','2022-11-22 18:20:11',10,0),('1','149',257953,'DAILY SALES','2022-11-23','2022-11-23 07:01:30','2022-11-24 07:01:30','506',0.00,0.00,'506','2022-11-23 18:09:34','506','2022-11-23 18:10:20',10,0),('1','149',257954,'DAILY SHIFT','2022-11-24','2022-11-24 07:05:47','2022-11-25 07:05:47','506',0.00,0.00,'506','2022-11-24 18:06:08','506','2022-11-24 18:08:32',10,0),('1','149',257955,'DAILY SALES','2022-11-25','2022-11-25 07:11:05','2022-11-26 07:11:05','506',0.00,0.00,'506','2022-11-25 18:07:17','506','2022-11-25 18:08:01',10,0),('1','149',257956,'DAILY SALES','2022-11-26','2022-11-26 10:06:10','2022-11-27 10:06:10','506',0.00,0.00,'506','2022-11-26 18:12:07','506','2022-11-26 18:12:30',10,0),('1','149',257957,'DAILY SALES','2022-11-27','2022-11-27 07:21:16','2022-11-28 07:21:16','506',0.00,0.00,'506','2022-11-27 18:33:15','506','2022-11-27 18:34:05',10,0),('1','149',257958,'operational loss','2022-11-27','2022-11-27 18:35:44','2022-11-28 18:35:44','506',0.00,0.00,'506','2022-11-27 18:38:15','506','2022-11-27 18:38:32',10,0),('1','149',257959,'DAILY SALES','2022-11-28','2022-11-28 06:59:28','2022-11-29 06:59:28','506',0.00,0.00,'506','2022-11-28 18:16:36','506','2022-11-28 18:16:53',10,0),('1','149',257960,'DAILY SALES','2022-11-29','2022-11-29 07:15:16','2022-11-30 07:15:16','506',0.00,0.00,'506','2022-11-29 18:23:34','506','2022-11-29 18:23:59',10,0),('1','149',257961,'DAILY SHIFT','2022-11-30','2022-11-30 07:20:16','2022-12-01 07:20:16','506',0.00,0.00,'506','2022-11-30 18:05:28','506','2022-11-30 18:05:49',10,0),('1','149',257962,'DAILY SALES','2022-12-01','2022-12-01 07:03:01','2022-12-02 07:03:01','506',0.00,0.00,'506','2022-12-01 18:17:57','506','2022-12-01 18:19:01',10,0),('1','149',257963,'DAILY SHIFT','2022-12-02','2022-12-02 07:26:42','2022-12-03 07:26:42','506',0.00,0.00,'506','2022-12-02 18:23:28','506','2022-12-02 18:24:06',10,0),('1','149',257964,'DAILY SALES','2022-12-03','2022-12-03 08:37:27','2022-12-04 08:37:27','506',0.00,0.00,'506','2022-12-03 17:10:38','506','2022-12-03 17:11:00',10,0),('1','149',257965,'DAILY SHIFT','2022-12-04','2022-12-04 08:37:21','2022-12-05 08:37:21','506',0.00,0.00,'506','2022-12-04 08:38:24','506','2022-12-04 08:38:40',10,0),('1','149',257966,'operational loss','2022-12-04','2022-12-04 08:43:43','2022-12-05 08:43:43','506',0.00,0.00,'506','2022-12-04 08:49:11','506','2022-12-04 08:49:36',10,0),('1','149',257967,'DAILY SHIFT','2022-12-04','2022-12-04 08:49:58','2022-12-05 08:49:58','506',0.00,0.00,'506','2022-12-04 18:07:58','506','2022-12-04 18:08:16',10,0),('1','149',257968,'DAILY SALES','2022-12-05','2022-12-05 06:55:09','2022-12-06 06:55:09','506',0.00,0.00,'506','2022-12-05 18:07:13','506','2022-12-05 18:07:33',10,0),('1','149',257969,'DAILY SHIFT','2022-12-06','2022-12-06 07:04:06','2022-12-07 07:04:06','506',0.00,0.00,'506','2022-12-06 18:29:27','506','2022-12-06 18:29:50',10,0),('1','149',257970,'DAILY SALES','2022-12-07','2022-12-07 07:19:45','2022-12-08 07:19:45','506',0.00,0.00,'506','2022-12-07 18:18:24','506','2022-12-07 18:18:46',10,0),('1','149',257971,'DAILY SHIFT','2022-12-08','2022-12-08 07:09:00','2022-12-09 07:09:00','506',0.00,0.00,'506','2022-12-08 18:21:44','506','2022-12-08 18:22:01',10,0),('1','149',257972,'DAILY SHIFT','2022-12-09','2022-12-09 08:49:11','2022-12-10 08:49:11','506',0.00,0.00,'506','2022-12-09 10:57:59','506','2022-12-09 10:58:54',10,0),('1','149',257973,'DAILY SHIFT','2022-12-09','2022-12-09 11:00:47','2022-12-10 11:00:47','506',0.00,0.00,'506','2022-12-09 17:54:45','506','2022-12-09 17:55:08',10,0),('1','149',257974,'operational loss','2022-12-10','2022-12-10 08:12:45','2022-12-11 08:12:45','506',0.00,0.00,'506','2022-12-10 08:15:45','506','2022-12-10 08:16:05',10,0),('1','149',257975,'DAILY SHIFT','2022-12-10','2022-12-10 08:18:37','2022-12-11 08:18:37','506',0.00,0.00,'506','2022-12-10 18:25:17','506','2022-12-10 18:25:35',10,0),('1','149',257976,'DAILY SHIFT','2022-12-11','2022-12-11 08:20:55','2022-12-12 08:20:55','506',0.00,0.00,'506','2022-12-11 18:00:25','506','2022-12-11 18:00:44',10,0),('1','149',257977,'DAILY SHIFT','2022-12-12','2022-12-12 07:15:59','2022-12-13 07:15:59','506',0.00,0.00,'506','2022-12-12 18:11:31','506','2022-12-12 18:11:53',10,0),('1','149',257978,'DAILY SHIFT','2022-12-13','2022-12-13 06:59:39','2022-12-14 06:59:39','506',0.00,0.00,'506','2022-12-13 18:05:11','506','2022-12-13 18:05:28',10,0),('1','149',257979,'DAILY SHIFT','2022-12-14','2022-12-14 07:02:32','2022-12-15 07:02:32','506',0.00,0.00,'506','2022-12-14 18:09:37','506','2022-12-14 18:10:00',10,0),('1','149',257980,'DAILY SHIFT','2022-12-15','2022-12-15 07:11:05','2022-12-16 07:11:05','506',0.00,0.00,'506','2022-12-15 18:31:50','506','2022-12-15 18:32:06',10,0),('1','149',257981,'DAILY SHIFT','2022-12-16','2022-12-16 07:06:32','2022-12-17 07:06:32','506',0.00,0.00,'506','2022-12-16 14:08:00','506','2022-12-16 14:08:19',10,0),('1','149',257982,'DAILY SHIFT','2022-12-16','2022-12-16 14:08:55','2022-12-17 14:08:55','506',0.00,0.00,'506','2022-12-16 14:26:38','506','2022-12-16 14:26:56',10,0),('1','149',257983,'DAILY SALES','2022-12-16','2022-12-16 14:27:15','2022-12-17 14:27:15','506',0.00,0.00,'506','2022-12-16 18:21:29','506','2022-12-16 18:21:46',10,0),('1','149',257984,'DAILY SALES','2022-12-17','2022-12-17 07:24:35','2022-12-18 07:24:35','506',0.00,0.00,'506','2022-12-17 18:00:11','506','2022-12-17 18:00:34',10,0),('1','149',257985,'DAILY SHIFT','2022-12-18','2022-12-18 08:04:05','2022-12-19 08:04:05','506',0.00,0.00,'506','2022-12-18 18:15:11','506','2022-12-18 18:15:32',10,0),('1','149',257986,'DAILY SALES','2022-12-19','2022-12-19 06:58:20','2022-12-20 06:58:20','506',0.00,0.00,'506','2022-12-19 18:24:33','506','2022-12-19 18:24:53',10,0),('1','149',257987,'DAILY SHIFT','2022-12-20','2022-12-20 07:03:08','2022-12-21 07:03:08','506',0.00,0.00,'506','2022-12-20 18:06:29','506','2022-12-20 18:06:50',10,0),('1','149',257988,'DAILY SALES','2022-12-21','2022-12-21 07:11:22','2022-12-22 07:11:22','506',0.00,0.00,'506','2022-12-21 18:12:19','506','2022-12-21 18:12:38',10,0),('1','149',257989,'DAILY SHIFT','2022-12-22','2022-12-22 07:18:03','2022-12-23 07:18:03','506',0.00,0.00,'506','2022-12-22 09:22:09','506','2022-12-22 09:22:46',10,0),('1','149',257990,'operational loss','2022-12-22','2022-12-22 09:24:04','2022-12-23 09:24:04','506',0.00,0.00,'506','2022-12-22 09:30:14','506','2022-12-22 09:30:32',10,0),('1','149',257991,'DAILY SHIFT','2022-12-22','2022-12-22 12:22:05','2022-12-23 12:22:05','506',0.00,0.00,'506','2022-12-22 18:10:25','506','2022-12-22 18:10:41',10,0),('1','149',257992,'DAILY SALES','2022-12-23','2022-12-23 07:11:16','2022-12-24 07:11:16','506',0.00,0.00,'506','2022-12-23 18:00:10','506','2022-12-23 18:00:35',10,0),('1','149',257993,'DAILY SHIFT','2022-12-24','2022-12-24 07:19:39','2022-12-25 07:19:39','506',0.00,0.00,'506','2022-12-24 18:05:21','506','2022-12-24 18:05:38',10,0),('1','149',257994,'DAILY SALES','2022-12-25','2022-12-25 07:12:42','2022-12-26 07:12:42','506',0.00,0.00,'506','2022-12-25 18:06:24','506','2022-12-25 18:06:48',10,0),('1','149',257995,'DAILY SHIFT','2022-12-26','2022-12-26 07:09:10','2022-12-27 07:09:10','506',0.00,0.00,'506','2022-12-26 18:26:46','506','2022-12-26 18:27:06',10,0),('1','149',257996,'DAILY SALES','2022-12-27','2022-12-27 07:20:23','2022-12-28 07:20:23','506',0.00,0.00,'506','2022-12-27 10:35:20','506','2022-12-27 10:35:43',10,0),('1','149',257997,'operational loss','2022-12-27','2022-12-27 10:36:00','2022-12-28 10:36:00','506',0.00,0.00,'506','2022-12-27 10:38:33','506','2022-12-27 10:39:32',10,0),('1','149',257998,'DAILY SALES','2022-12-27','2022-12-27 12:47:47','2022-12-28 12:47:47','506',0.00,0.00,'506','2022-12-27 18:31:51','506','2022-12-27 18:32:16',10,0),('1','149',257999,'DAILY SHIFT','2022-12-28','2022-12-28 07:04:53','2022-12-29 07:04:53','506',0.00,0.00,'506','2022-12-28 18:39:08','506','2022-12-28 18:39:25',10,0),('1','149',258000,'DAILY SHIFT','2022-12-29','2022-12-29 07:44:55','2022-12-30 07:44:55','506',0.00,0.00,'506','2022-12-29 18:30:05','506','2022-12-29 18:30:24',10,0),('1','149',258001,'DAILY SALES','2022-12-30','2022-12-30 07:13:58','2022-12-31 07:13:58','506',0.00,0.00,'506','2022-12-30 18:32:38','506','2022-12-30 18:32:58',10,0),('1','149',258002,'DAILY SHIFT','2022-12-31','2022-12-31 09:01:50','2023-01-01 09:01:50','506',0.00,0.00,'506','2022-12-31 18:32:22','506','2022-12-31 18:32:39',10,0),('1','149',258003,'DAILY SALES','2023-01-01','2023-01-01 07:07:32','2023-01-02 07:07:32','506',0.00,0.00,'506','2023-01-01 18:22:46','506','2023-01-01 18:23:06',10,0),('1','149',258004,'DAILY SHIFT','2023-01-02','2023-01-02 12:01:47','2023-01-03 12:01:47','506',0.00,0.00,'506','2023-01-02 16:19:03','506','2023-01-02 16:19:22',10,0),('1','149',258005,'operational loss','2023-01-02','2023-01-02 16:24:56','2023-01-03 16:24:56','506',0.00,0.00,'506','2023-01-02 16:27:53','506','2023-01-02 16:28:09',10,0),('1','149',258006,'DAILY SHIFT','2023-01-02','2023-01-02 16:54:41','2023-01-03 16:54:41','506',0.00,0.00,'506','2023-01-02 18:31:11','506','2023-01-02 18:31:39',10,0),('1','149',258007,'DAILY SALES','2023-01-03','2023-01-03 07:01:43','2023-01-04 07:01:43','506',0.00,0.00,'506','2023-01-03 19:00:05','506','2023-01-03 19:00:26',10,0),('1','149',258008,'DAILY SHIFT','2023-01-04','2023-01-04 08:02:00','2023-01-05 08:02:00','506',0.00,0.00,'506','2023-01-04 18:39:19','506','2023-01-04 18:39:38',10,0),('1','149',258009,'DAILY SALES','2023-01-05','2023-01-05 07:01:50','2023-01-06 07:01:50','506',0.00,0.00,'506','2023-01-05 18:37:01','506','2023-01-05 18:38:25',10,0),('1','149',258010,'DAILY SHIFT','2023-01-06','2023-01-06 07:14:13','2023-01-07 07:14:13','506',0.00,0.00,'506','2023-01-06 15:04:34','506','2023-01-06 15:04:54',10,0),('1','149',258011,'operational loss','2023-01-06','2023-01-06 15:39:14','2023-01-07 15:39:14','506',0.00,0.00,'506','2023-01-06 15:44:04','506','2023-01-06 15:44:22',10,0),('1','149',258012,'DAILY SALES','2023-01-07','2023-01-07 07:20:04','2023-01-08 07:20:04','506',0.00,0.00,'506','2023-01-07 18:50:37','506','2023-01-07 18:50:57',10,0),('1','149',258013,'DAILY SALES','2023-01-08','2023-01-08 07:21:08','2023-01-09 07:21:08','506',0.00,0.00,'506','2023-01-08 18:49:21','506','2023-01-08 18:50:02',10,0),('1','149',258014,'DAILY SALES','2023-01-09','2023-01-09 07:03:59','2023-01-10 07:03:59','506',0.00,0.00,'506','2023-01-09 18:53:15','506','2023-01-09 18:54:28',10,0),('1','149',258015,'DAILY SALES','2023-01-10','2023-01-10 07:16:16','2023-01-11 07:16:16','506',0.00,0.00,'506','2023-01-10 18:44:07','506','2023-01-10 18:44:26',10,0),('1','149',258016,'DAILY SALES','2023-01-11','2023-01-11 07:05:12','2023-01-12 07:05:12','506',0.00,0.00,'506','2023-01-11 11:44:48','506','2023-01-11 11:45:14',10,0),('1','149',258017,'operational loss','2023-01-11','2023-01-11 11:45:37','2023-01-12 11:45:37','506',0.00,0.00,'506','2023-01-11 11:48:07','506','2023-01-11 11:48:42',10,0),('1','149',258018,'DAILY SALES','2023-01-11','2023-01-11 15:11:14','2023-01-12 15:11:14','506',0.00,0.00,'506','2023-01-11 18:34:31','506','2023-01-11 18:34:53',10,0),('1','149',258019,'DAILY SALES','2023-01-12','2023-01-12 07:05:09','2023-01-13 07:05:09','506',0.00,0.00,'506','2023-01-12 18:39:10','506','2023-01-12 18:39:51',10,0),('1','149',258020,'DAILY SALES','2023-01-13','2023-01-13 07:22:14','2023-01-14 07:22:14','506',0.00,0.00,'506','2023-01-13 18:37:23','506','2023-01-13 18:38:02',10,0),('1','149',258021,'DAILY SALES','2023-01-14','2023-01-14 07:25:36','2023-01-15 07:25:36','506',0.00,0.00,'506','2023-01-14 18:44:43','506','2023-01-14 18:45:06',10,0),('1','149',258022,'DAILY SALES','2023-01-15','2023-01-15 07:29:14','2023-01-16 07:29:14','506',0.00,0.00,'506','2023-01-15 18:47:27','506','2023-01-15 18:48:04',10,0),('1','149',258023,'DAILY SALES','2023-01-16','2023-01-16 07:30:29','2023-01-17 07:30:29','506',0.00,0.00,'506','2023-01-16 15:22:55','506','2023-01-16 15:23:14',10,0),('1','149',258024,'operational loss','2023-01-16','2023-01-16 15:32:21','2023-01-17 15:32:21','506',0.00,0.00,'506','2023-01-16 15:34:36','506','2023-01-16 15:34:55',10,0),('1','149',258025,'DAILY SHIFT','2023-01-16','2023-01-16 16:04:25','2023-01-17 16:04:25','506',0.00,0.00,'506','2023-01-16 18:51:51','506','2023-01-16 18:52:12',10,0),('1','149',258026,'DAILY SALES','2023-01-17','2023-01-17 07:12:57','2023-01-18 07:12:57','506',0.00,0.00,'506','2023-01-17 18:45:49','506','2023-01-17 18:46:11',10,0),('1','149',258027,'DAILY SALES','2023-01-18','2023-01-18 07:18:04','2023-01-19 07:18:04','506',0.00,0.00,'506','2023-01-18 18:18:49','506','2023-01-18 18:19:12',10,0),('1','149',258028,'DAILY SALES','2023-01-19','2023-01-19 07:24:53','2023-01-20 07:24:53','506',0.00,0.00,'506','2023-01-19 18:42:11','506','2023-01-19 18:42:36',10,0),('1','149',258029,'DAILY SALES','2023-01-20','2023-01-20 07:12:28','2023-01-21 07:12:28','506',0.00,0.00,'506','2023-01-20 18:36:45','506','2023-01-20 18:37:10',10,0),('1','149',258030,'DAILY SALES','2023-01-21','2023-01-21 07:05:21','2023-01-22 07:05:21','506',0.00,0.00,'506','2023-01-21 12:34:37','506','2023-01-21 12:34:57',10,0),('1','149',258031,'operational loss','2023-01-21','2023-01-21 12:35:15','2023-01-22 12:35:15','506',0.00,0.00,'506','2023-01-21 12:37:29','506','2023-01-21 12:37:48',10,0),('1','149',258032,'DAILY SHIFT','2023-01-21','2023-01-21 14:45:07','2023-01-22 14:45:07','506',0.00,0.00,'506','2023-01-21 18:49:52','506','2023-01-21 18:50:14',10,0),('1','149',258033,'DAILY SALES','2023-01-22','2023-01-22 07:05:17','2023-01-23 07:05:17','506',0.00,0.00,'506','2023-01-22 18:35:42','506','2023-01-22 18:36:07',10,0),('1','149',258034,'DAILY SALES','2023-01-23','2023-01-23 07:31:12','2023-01-24 07:31:12','506',0.00,0.00,'506','2023-01-23 18:49:02','506','2023-01-23 18:49:28',10,0),('1','149',258035,'DAILY SALES','2023-01-24','2023-01-24 07:24:43','2023-01-25 07:24:43','506',0.00,0.00,'506','2023-01-24 18:41:56','506','2023-01-24 18:42:23',10,0),('1','149',258036,'DAILY SALES','2023-01-25','2023-01-25 07:22:26','2023-01-26 07:22:26','506',0.00,0.00,'506','2023-01-25 19:02:56','506','2023-01-25 19:03:22',10,0),('1','149',258037,'DAILY SALES','2023-01-26','2023-01-26 06:52:17','2023-01-27 06:52:17','506',0.00,0.00,'506','2023-01-26 17:35:22','506','2023-01-26 17:35:56',10,0),('1','149',258038,'operational loss','2023-01-26','2023-01-26 17:40:03','2023-01-27 17:40:03','506',0.00,0.00,'506','2023-01-26 17:42:48','506','2023-01-26 17:43:10',10,0),('1','149',258039,'DAILY SHIFT','2023-01-26','2023-01-26 17:43:34','2023-01-27 17:43:34','506',0.00,0.00,'506','2023-01-26 18:51:03','506','2023-01-26 18:51:27',10,0),('1','149',258040,'DAILY SALES','2023-01-27','2023-01-27 07:41:42','2023-01-28 07:41:42','506',0.00,0.00,'506','2023-01-27 18:49:59','506','2023-01-27 18:50:29',10,0),('1','149',258041,'DAILY SALES','2023-01-28','2023-01-28 07:18:02','2023-01-29 07:18:02','506',0.00,0.00,'506','2023-01-28 18:39:38','506','2023-01-28 18:40:15',10,0),('1','149',258042,'DAILY SALES','2023-01-29','2023-01-29 07:26:50','2023-01-30 07:26:50','506',0.00,0.00,'506','2023-01-29 18:40:14','506','2023-01-29 18:40:36',10,0),('1','149',258043,'DAILY SALES','2023-01-30','2023-01-30 07:16:21','2023-01-31 07:16:21','506',0.00,0.00,'506','2023-01-30 18:58:00','506','2023-01-30 18:58:32',10,0),('1','149',258044,'DAILY SALES','2023-01-31','2023-01-31 07:09:18','2023-02-01 07:09:18','506',0.00,0.00,'506','2023-01-31 18:47:57','506','2023-01-31 18:48:49',10,0),('1','149',258045,'DAILY SALES','2023-02-01','2023-02-01 07:18:09','2023-02-02 07:18:09','506',0.00,0.00,'506','2023-02-01 13:06:55','506','2023-02-01 13:07:25',10,0),('1','149',258046,'operational loss','2023-02-01','2023-02-01 13:08:00','2023-02-02 13:08:00','506',0.00,0.00,'506','2023-02-01 13:52:11','506','2023-02-01 13:52:32',10,0),('1','149',258047,'OPERATIONAL LOSS','2023-02-01','2023-02-01 13:58:49','2023-02-02 13:58:49','506',0.00,0.00,'506','2023-02-01 14:01:27','506','2023-02-01 14:01:47',10,0),('1','149',258048,'DAILY SALES','2023-02-01','2023-02-01 16:10:19','2023-02-02 16:10:19','506',0.00,0.00,'506','2023-02-01 19:08:06','506','2023-02-01 19:08:45',10,0),('1','149',258049,'DAILY SALES','2023-02-02','2023-02-02 07:54:15','2023-02-03 07:54:15','506',0.00,0.00,'506','2023-02-02 19:01:47','506','2023-02-02 19:07:59',10,0),('1','149',258050,'DAILY SALES','2023-02-03','2023-02-03 07:20:02','2023-02-04 07:20:02','506',0.00,0.00,'506','2023-02-03 19:00:59','506','2023-02-03 19:01:22',10,0),('1','149',258051,'DAILY SALES','2023-02-04','2023-02-04 07:24:51','2023-02-05 07:24:51','506',0.00,0.00,'506','2023-02-04 19:18:37','506','2023-02-04 19:19:04',10,0),('1','149',258052,'DAILY SALES','2023-02-05','2023-02-05 07:21:25','2023-02-06 07:21:25','506',0.00,0.00,'506','2023-02-05 17:44:14','506','2023-02-05 17:44:49',10,0),('1','149',258053,'DAILY SALES','2023-02-14','2023-02-14 07:41:10','2023-02-15 07:41:10','506',0.00,0.00,'506','2023-02-14 18:50:19','506','2023-02-14 18:50:39',10,0),('1','149',258054,'DAILY SALES','2023-02-15','2023-02-15 07:54:12','2023-02-16 07:54:12','506',0.00,0.00,'506','2023-02-15 19:08:07','506','2023-02-15 19:08:34',10,0),('1','149',258055,'OPERATIONAL LOSS','2023-02-16','2023-02-16 07:21:12','2023-02-17 07:21:12','506',0.00,0.00,'506','2023-02-16 07:24:00','506','2023-02-16 07:24:18',10,0),('1','149',258056,'DAILY SALES','2023-02-16','2023-02-16 08:25:01','2023-02-17 08:25:01','506',0.00,0.00,'506','2023-02-16 18:51:13','506','2023-02-16 18:51:47',10,0),('1','149',258057,'DAILY SALES','2023-02-17','2023-02-17 07:06:38','2023-02-18 07:06:38','506',0.00,0.00,'506','2023-02-17 18:57:27','506','2023-02-17 18:57:54',10,0),('1','149',258058,'DAILY SALES','2023-02-18','2023-02-18 07:27:53','2023-02-19 07:27:53','506',0.00,0.00,'506','2023-02-18 19:12:50','506','2023-02-18 19:13:25',10,0),('1','149',258059,'DAILY SALES','2023-02-19','2023-02-19 07:02:57','2023-02-20 07:02:57','506',0.00,0.00,'506','2023-02-19 19:06:17','506','2023-02-19 19:06:38',10,0),('1','149',258060,'DAILY SALES','2023-02-20','2023-02-20 07:22:03','2023-02-21 07:22:03','506',0.00,0.00,'506','2023-02-20 19:02:46','506','2023-02-20 19:03:13',10,0),('1','149',258061,'DAILY SALES','2023-02-21','2023-02-21 07:06:07','2023-02-22 07:06:07','506',0.00,0.00,'506','2023-02-21 19:28:24','506','2023-02-21 19:28:57',10,0),('1','149',258062,'DAILY SALES','2023-02-22','2023-02-22 07:09:00','2023-02-23 07:09:00','506',0.00,0.00,'506','2023-02-22 19:14:55','506','2023-02-22 19:15:27',10,0),('1','149',258063,'DAILY SALES','2023-02-23','2023-02-23 07:02:05','2023-02-24 07:02:05','506',0.00,0.00,'506','2023-02-23 15:56:32','506','2023-02-23 15:56:50',10,0),('1','149',258064,'DAILY SALES','2023-02-23','2023-02-23 15:57:13','2023-02-24 15:57:13','506',0.00,0.00,'506','2023-02-23 18:59:25','506','2023-02-23 18:59:50',10,0),('1','149',258065,'DAILY SALES','2023-02-24','2023-02-24 07:27:33','2023-02-25 07:27:33','506',0.00,0.00,'506','2023-02-24 19:26:21','506','2023-02-24 19:26:52',10,0),('1','149',258066,'DAILY SALES','2023-02-26','2023-02-26 07:10:17','2023-02-27 07:10:17','506',0.00,0.00,'506','2023-02-26 19:04:35','506','2023-02-26 19:05:15',10,0),('1','149',258067,'DAILY SALES','2023-02-27','2023-02-27 08:01:28','2023-02-28 08:01:28','506',0.00,0.00,'506','2023-02-27 19:10:12','506','2023-02-27 19:10:40',10,0),('1','149',258068,'DAILY SALES','2023-02-28','2023-02-28 07:18:05','2023-03-01 07:18:05','506',0.00,0.00,'506','2023-02-28 18:45:34','506','2023-02-28 18:45:59',10,0),('1','149',258069,'DAILY SALES','2023-03-01','2023-03-01 07:11:54','2023-03-02 07:11:54','506',0.00,0.00,'506','2023-03-01 17:25:22','506','2023-03-01 17:25:43',10,0),('1','149',258070,'DAILY SHIFT','2023-03-02','2023-03-02 10:49:22','2023-03-03 10:49:22','506',0.00,0.00,'506','2023-03-02 19:06:15','506','2023-03-02 19:06:36',10,0),('1','149',258071,'DAILY SALES','2023-03-03','2023-03-03 07:11:14','2023-03-04 07:11:14','506',0.00,0.00,'506','2023-03-03 18:49:35','506','2023-03-03 18:49:58',10,0),('1','149',258072,'DAILY SALES','2023-03-04','2023-03-04 07:11:25','2023-03-05 07:11:25','506',0.00,0.00,'506','2023-03-04 19:00:43','506','2023-03-04 19:01:06',10,0),('1','149',258073,'DAILY SALES','2023-03-05','2023-03-05 07:07:14','2023-03-06 07:07:14','506',0.00,0.00,'506','2023-03-05 19:01:16','506','2023-03-05 19:01:39',10,0),('1','149',258074,'DAILY SALES','2023-03-06','2023-03-06 07:21:27','2023-03-07 07:21:27','506',0.00,0.00,'506','2023-03-06 18:35:32','506','2023-03-06 18:36:03',10,0),('1','149',258075,'DAILY SALES','2023-03-07','2023-03-07 07:11:05','2023-03-08 07:11:05','506',0.00,0.00,'506','2023-03-07 19:00:42','506','2023-03-07 19:01:22',10,0),('1','149',258076,'DAILY SALES','2023-03-08','2023-03-08 07:17:13','2023-03-09 07:17:13','506',0.00,0.00,'506','2023-03-08 09:36:00','506','2023-03-08 09:36:18',10,0),('1','149',258077,'DAILY SHIFT','2023-03-08','2023-03-08 11:05:32','2023-03-09 11:05:32','506',0.00,0.00,'506','2023-03-08 19:00:43','506','2023-03-08 19:01:01',10,0),('1','149',258078,'DAILY SALES','2023-03-09','2023-03-09 06:58:27','2023-03-10 06:58:27','506',0.00,0.00,'506','2023-03-09 18:45:19','506','2023-03-09 18:45:44',10,0),('1','149',258079,'DAILY SALES','2023-03-10','2023-03-10 07:44:41','2023-03-11 07:44:41','506',0.00,0.00,'506','2023-03-10 19:00:17','506','2023-03-10 19:00:42',10,0),('1','149',258080,'DAILY SALES','2023-03-11','2023-03-11 07:25:00','2023-03-12 07:25:00','506',0.00,0.00,'506','2023-03-11 19:02:11','506','2023-03-11 19:02:40',10,0),('1','149',258081,'DAILY SALES','2023-03-12','2023-03-12 07:07:41','2023-03-13 07:07:41','506',0.00,0.00,'506','2023-03-12 19:06:26','506','2023-03-12 19:06:51',10,0),('1','149',258082,'DAILY SALES','2023-03-13','2023-03-13 07:14:24','2023-03-14 07:14:24','506',0.00,0.00,'506','2023-03-13 19:06:25','506','2023-03-13 19:06:47',10,0),('1','149',258083,'DAILY SALES','2023-03-14','2023-03-14 07:02:35','2023-03-15 07:02:35','506',0.00,0.00,'506','2023-03-14 17:43:22','506','2023-03-14 17:43:47',10,0),('1','149',258084,'DAILY SALES','2023-03-15','2023-03-15 08:37:23','2023-03-16 08:37:23','506',0.00,0.00,'506','2023-03-15 20:02:35','506','2023-03-15 20:03:22',10,0),('1','149',258085,'DAILY SALES','2023-03-16','2023-03-16 07:12:58','2023-03-17 07:12:58','506',0.00,0.00,'506','2023-03-16 18:51:06','506','2023-03-16 18:51:43',10,0),('1','149',258086,'DAILY SALES','2023-03-17','2023-03-17 07:20:49','2023-03-18 07:20:49','506',0.00,0.00,'506','2023-03-17 19:04:11','506','2023-03-17 19:05:16',10,0),('1','149',258087,'DAILY SALES','2023-03-19','2023-03-19 07:08:01','2023-03-20 07:08:01','506',0.00,0.00,'506','2023-03-19 18:30:45','506','2023-03-19 18:31:07',10,0),('1','149',258088,'DAILY SALES','2023-03-20','2023-03-20 07:04:25','2023-03-21 07:04:25','506',0.00,0.00,'506','2023-03-20 19:20:00','506','2023-03-20 19:20:22',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4907005 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','149','770','146987',2940275,'2141','328',0.00,691.07,0.00,0.00,691.07,193499.60,0.00,0.00,0.00),('1','149','770','147009',2940524,'2141','328',691.07,2037.49,0.00,0.00,1346.42,376997.60,0.00,0.00,0.00),('1','149','770','147018',2940650,'2141','328',2037.49,3608.91,0.00,0.00,1571.42,439997.60,0.00,0.00,0.00),('1','149','770','147034',2940833,'2141','328',3608.91,3608.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','147042',2940919,'2141','328',3608.91,4682.48,0.00,0.00,1073.57,300599.60,0.00,0.00,0.00),('1','149','770','147069',2941474,'2141','328',4682.48,4682.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','147076',2941522,'2141','328',4682.48,5440.48,0.00,0.00,758.00,212240.00,0.00,0.00,0.00),('1','149','770','147095',2941613,'2141','328',5440.48,5440.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','147097',2941615,'2141','328',5440.48,6567.26,0.00,0.00,1126.78,315498.40,0.00,0.00,0.00),('1','149','770','147101',2941631,'2141','328',6567.26,6567.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','147104',2941634,'2141','328',6567.26,7819.76,0.00,0.00,1252.50,350700.00,0.00,0.00,0.00),('1','149','770','147155',2942367,'2141','328',7819.76,9339.40,0.00,0.00,1519.64,425499.20,0.00,0.00,0.00),('1','149','770','147158',2942371,'2141','328',9339.40,11013.40,0.00,0.00,1674.00,468720.00,0.00,0.00,0.00),('1','149','770','147162',2942376,'2141','328',11013.40,12565.18,0.00,0.00,1551.78,434498.40,0.00,0.00,0.00),('1','149','770','147178',2942554,'2141','328',12565.18,14639.10,0.00,0.00,2073.92,580697.60,0.00,0.00,0.00),('1','149','770','147310',2944299,'2141','328',14639.10,15660.52,0.00,0.00,1021.42,285997.60,0.00,0.00,0.00),('1','149','770','147432',2946623,'2141','328',15660.52,16694.09,0.00,0.00,1033.57,289399.60,0.00,0.00,0.00),('1','149','770','147567',2949025,'2141','328',16694.09,17785.16,0.00,0.00,1091.07,305499.60,0.00,0.00,0.00),('1','149','770','147691',2951118,'2141','328',17785.16,19249.44,0.00,0.00,1464.28,409998.40,0.00,0.00,0.00),('1','149','770','147872',2954479,'2141','328',19249.44,20242.29,0.00,0.00,992.85,277998.00,0.00,0.00,0.00),('1','149','770','147994',2956341,'2141','328',20242.29,21422.64,0.00,0.00,1180.35,330498.00,0.00,0.00,0.00),('1','149','770','148134',2958819,'2141','328',21422.64,22041.03,0.00,0.00,618.39,173149.20,0.00,0.00,0.00),('1','149','770','148136',2958843,'2141','328',22041.03,22328.53,0.00,0.00,287.50,80500.00,0.00,0.00,0.00),('1','149','770','148283',2961388,'2141','328',22328.53,23492.81,0.00,0.00,1164.28,325998.40,0.00,0.00,0.00),('1','149','770','148434',2964010,'2141','328',23492.81,24689.23,0.00,0.00,1196.42,334997.60,0.00,0.00,0.00),('1','149','770','148564',2966246,'2141','328',24689.23,26451.73,0.00,0.00,1762.50,493500.00,0.00,0.00,0.00),('1','149','770','148705',2968713,'2141','328',26451.73,27300.33,0.00,0.00,848.60,237608.00,0.00,0.00,0.00),('1','149','770','148813',2970295,'2141','328',27300.33,27664.61,0.00,0.00,364.28,101998.40,0.00,0.00,0.00),('1','149','770','148969',2973378,'2141','328',27664.61,28891.39,0.00,0.00,1226.78,343498.40,0.00,0.00,0.00),('1','149','770','149150',2976920,'2141','328',28891.39,29852.10,0.00,0.00,960.71,268998.80,0.00,0.00,0.00),('1','149','770','149309',2979659,'2141','328',29852.10,31253.88,0.00,0.00,1401.78,392498.40,0.00,0.00,0.00),('1','149','770','149464',2982230,'2141','328',31253.88,32528.88,0.00,0.00,1275.00,357000.00,0.00,0.00,0.00),('1','149','770','149602',2984598,'2141','328',32528.88,33427.09,0.00,0.00,898.21,251498.80,0.00,0.00,0.00),('1','149','770','149694',2986023,'2141','328',33427.09,35478.87,0.00,0.00,2051.78,574498.40,0.00,0.00,0.00),('1','149','770','149860',2989080,'2141','328',35478.87,37125.29,0.00,0.00,1646.42,460997.60,0.00,0.00,0.00),('1','149','770','150013',2991929,'2141','328',37125.29,37762.79,0.00,0.00,637.50,178500.00,0.00,0.00,0.00),('1','149','770','150014',2991930,'2141','328',37762.79,39168.14,0.00,0.00,1405.35,393498.00,0.00,0.00,0.00),('1','149','770','150165',2994991,'2141','328',39168.14,40607.42,0.00,0.00,1439.28,402998.40,0.00,0.00,0.00),('1','149','770','150389',2998673,'2141','328',40607.42,42061.81,0.00,0.00,1454.39,407229.20,0.00,0.00,0.00),('1','149','770','150541',3001726,'2141','328',42061.81,43118.95,0.00,0.00,1057.14,295999.20,0.00,0.00,0.00),('1','149','770','150887',3008233,'2141','328',43118.95,45158.95,0.00,0.00,2040.00,571200.00,0.00,0.00,0.00),('1','149','770','150981',3010064,'2141','328',45158.95,46494.66,0.00,0.00,1335.71,373998.80,0.00,0.00,0.00),('1','149','770','151152',3013086,'2141','328',46494.66,48350.91,0.00,0.00,1856.25,519750.00,0.00,0.00,0.00),('1','149','770','151284',3015763,'2141','328',48350.91,50258.05,0.00,0.00,1907.14,533999.20,0.00,0.00,0.00),('1','149','770','151433',3018532,'2141','328',50258.05,51652.69,0.00,0.00,1394.64,390499.20,0.00,0.00,0.00),('1','149','770','151592',3021328,'2141','328',51652.69,52872.33,0.00,0.00,1219.64,341499.20,0.00,0.00,0.00),('1','149','770','151702',3023316,'2141','328',52872.33,53969.65,0.00,0.00,1097.32,307249.60,0.00,0.00,0.00),('1','149','770','152022',3029438,'2141','328',53969.65,55253.07,0.00,0.00,1283.42,359357.60,0.00,0.00,0.00),('1','149','770','152166',3031934,'2141','328',55253.07,56779.85,0.00,0.00,1526.78,427498.40,0.00,0.00,0.00),('1','149','770','152317',3034994,'2141','328',56779.85,58492.85,0.00,0.00,1713.00,479640.00,0.00,0.00,0.00),('1','149','770','152528',3038709,'2141','328',58492.85,59839.85,0.00,0.00,1347.00,377160.00,0.00,0.00,0.00),('1','149','770','152765',3042943,'2141','328',59839.85,60571.56,0.00,0.00,731.71,204878.80,0.00,0.00,0.00),('1','149','770','152879',3045177,'2141','328',60571.56,60724.34,0.00,0.00,152.78,42778.40,0.00,0.00,0.00),('1','149','770','152880',3045178,'2141','328',60724.34,62098.34,0.00,0.00,1374.00,384720.00,0.00,0.00,0.00),('1','149','770','153102',3048881,'2141','328',62098.34,63147.09,0.00,0.00,1048.75,293650.00,0.00,0.00,0.00),('1','149','770','153263',3051782,'2141','328',63147.09,64280.92,0.00,0.00,1133.83,317472.40,0.00,0.00,0.00),('1','149','770','153464',3055645,'2141','328',64280.92,65382.92,0.00,0.00,1102.00,308560.00,0.00,0.00,0.00),('1','149','770','155132',3086165,'2141','328',65382.92,67443.70,0.00,0.00,2060.78,577018.40,0.00,0.00,0.00),('1','149','770','155296',3089281,'2141','328',67443.70,69374.77,0.00,0.00,1931.07,540699.60,0.00,0.00,0.00),('1','149','770','155478',3092568,'2141','328',69374.77,71479.52,0.00,0.00,2104.75,589330.00,0.00,0.00,0.00),('1','149','770','155761',3097730,'2141','328',71479.52,72522.94,0.00,0.00,1043.42,292157.60,0.00,0.00,0.00),('1','149','770','155917',3100457,'2141','328',72522.94,74523.36,0.00,0.00,2000.42,560117.60,0.00,0.00,0.00),('1','149','770','156070',3103312,'2141','328',74523.36,75620.50,0.00,0.00,1097.14,307199.20,0.00,0.00,0.00),('1','149','770','156292',3107155,'2141','328',75620.50,77550.50,0.00,0.00,1930.00,540400.00,0.00,0.00,0.00),('1','149','770','156553',3112188,'2141','328',77550.50,79300.64,0.00,0.00,1750.14,490039.20,0.00,0.00,0.00),('1','149','770','156725',3115373,'2141','328',79300.64,80460.64,0.00,0.00,1160.00,324800.00,0.00,0.00,0.00),('1','149','770','156892',3118329,'2141','328',80460.64,81507.64,0.00,0.00,1047.00,293160.00,0.00,0.00,0.00),('1','149','770','157070',3121665,'2141','328',81507.64,82007.10,0.00,0.00,499.46,139848.80,0.00,0.00,0.00),('1','149','770','157271',3125168,'2141','328',82007.10,83237.27,0.00,0.00,1230.17,344447.60,0.00,0.00,0.00),('1','149','770','157438',3127932,'2141','328',83237.27,84669.19,0.00,0.00,1431.92,400937.60,0.00,0.00,0.00),('1','149','770','157639',3131528,'2141','328',84669.19,85693.83,0.00,0.00,1024.64,286899.20,0.00,0.00,0.00),('1','149','770','157781',3134107,'2141','328',85693.83,87401.83,0.00,0.00,1708.00,478240.00,0.00,0.00,0.00),('1','149','770','158020',3138597,'2141','328',87401.83,87834.26,0.00,0.00,432.43,121080.40,0.00,0.00,0.00),('1','149','770','158083',3139693,'2141','328',87834.26,89128.54,0.00,0.00,1294.28,362398.40,0.00,0.00,0.00),('1','149','770','158249',3142878,'2141','328',89128.54,91159.25,0.00,0.00,2030.71,568598.80,0.00,0.00,0.00),('1','149','770','158415',3146071,'2141','328',91159.25,92730.39,0.00,0.00,1571.14,439919.20,0.00,0.00,0.00),('1','149','770','158567',3148656,'2141','328',92730.39,93157.39,0.00,0.00,427.00,119560.00,0.00,0.00,0.00),('1','149','770','158569',3148658,'2141','328',93157.39,94217.39,0.00,0.00,1060.00,296800.00,0.00,0.00,0.00),('1','149','770','158741',3151862,'2141','328',94217.39,95247.96,0.00,0.00,1030.57,288559.60,0.00,0.00,0.00),('1','149','770','158930',3155073,'2141','328',95247.96,95778.24,0.00,0.00,530.28,148478.40,0.00,0.00,0.00),('1','149','770','158931',3155074,'2141','328',95778.24,96559.55,0.00,0.00,781.31,231267.76,0.00,0.00,0.00),('1','149','770','159056',3157378,'2141','328',96559.55,97145.52,0.00,0.00,585.97,173447.12,0.00,0.00,0.00),('1','149','770','159449',3164063,'2141','328',97145.52,98666.19,0.00,0.00,1520.67,450118.32,0.00,0.00,0.00),('1','149','770','159632',3167405,'2141','328',98666.19,99304.02,0.00,0.00,637.83,188797.68,0.00,0.00,0.00),('1','149','770','159633',3167406,'2141','328',99304.02,100556.28,0.00,0.00,1252.26,380687.04,0.00,0.00,0.00),('1','149','770','159733',3169041,'2141','328',100556.28,102665.28,0.00,0.00,2109.00,641136.00,0.00,0.00,0.00),('1','149','770','159941',3172761,'2141','328',102665.28,103786.46,0.00,0.00,1121.18,340838.72,0.00,0.00,0.00),('1','149','770','160111',3176018,'2141','328',103786.46,104864.65,0.00,0.00,1078.19,327769.76,0.00,0.00,0.00),('1','149','770','160305',3179364,'2141','328',104864.65,106529.33,0.00,0.00,1664.68,506062.72,0.00,0.00,0.00),('1','149','770','160477',3182438,'2141','328',106529.33,108173.70,0.00,0.00,1644.37,526198.40,0.00,0.00,0.00),('1','149','770','160478',3182439,'2141','328',108173.70,108173.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','160720',3186756,'2141','328',108173.70,108887.91,0.00,0.00,714.21,228547.20,0.00,0.00,0.00),('1','149','770','160740',3187004,'2141','328',108887.91,110350.41,0.00,0.00,1462.50,409500.00,0.00,0.00,0.00),('1','149','770','160883',3189440,'2141','328',110350.41,112103.26,0.00,0.00,1752.85,490798.00,0.00,0.00,0.00),('1','149','770','161098',3193376,'2141','328',112103.26,113133.26,0.00,0.00,1030.00,288400.00,0.00,0.00,0.00),('1','149','770','161291',3196733,'2141','328',113133.26,113941.86,0.00,0.00,808.60,226408.00,0.00,0.00,0.00),('1','149','770','161445',3199428,'2141','328',113941.86,114835.00,0.00,0.00,893.14,250079.20,0.00,0.00,0.00),('1','149','770','161647',3202822,'2141','328',114835.00,115643.57,0.00,0.00,808.57,226399.60,0.00,0.00,0.00),('1','149','770','161846',3206192,'2141','328',115643.57,116476.17,0.00,0.00,832.60,233128.00,0.00,0.00,0.00),('1','149','770','162031',3209588,'2141','328',116476.17,117728.27,0.00,0.00,1252.10,350588.00,0.00,0.00,0.00),('1','149','770','162131',3211164,'2141','328',117728.27,118423.09,0.00,0.00,694.82,194549.60,0.00,0.00,0.00),('1','149','770','162448',3216605,'2141','328',118423.09,119496.91,0.00,0.00,1073.82,300669.60,0.00,0.00,0.00),('1','149','770','162634',3219622,'2141','328',119496.91,120660.37,0.00,0.00,1163.46,325768.80,0.00,0.00,0.00),('1','149','770','162792',3222524,'2141','328',120660.37,121546.15,0.00,0.00,885.78,248018.40,0.00,0.00,0.00),('1','149','770','162993',3226106,'2141','328',121546.15,122626.57,0.00,0.00,1080.42,302517.60,0.00,0.00,0.00),('1','149','770','163278',3231029,'2141','328',122626.57,123233.57,0.00,0.00,607.00,169960.00,0.00,0.00,0.00),('1','149','770','163281',3231074,'2141','328',123233.57,123604.89,0.00,0.00,371.32,103969.60,0.00,0.00,0.00),('1','149','770','163361',3232609,'2141','328',123604.89,124656.60,0.00,0.00,1051.71,294478.80,0.00,0.00,0.00),('1','149','770','163534',3235806,'2141','328',124656.60,126136.42,0.00,0.00,1479.82,414349.60,0.00,0.00,0.00),('1','149','770','163734',3239338,'2141','328',126136.42,127628.13,0.00,0.00,1491.71,417678.80,0.00,0.00,0.00),('1','149','770','163883',3241971,'2141','328',127628.13,128593.13,0.00,0.00,965.00,270200.00,0.00,0.00,0.00),('1','149','770','164074',3245517,'2141','328',128593.13,129025.63,0.00,0.00,432.50,121100.00,0.00,0.00,0.00),('1','149','770','164245',3248549,'2141','328',129025.63,130071.34,0.00,0.00,1045.71,292798.80,0.00,0.00,0.00),('1','149','770','164426',3252069,'2141','328',130071.34,131044.59,0.00,0.00,973.25,272510.00,0.00,0.00,0.00),('1','149','770','164586',3254836,'2141','328',131044.59,132558.55,0.00,0.00,1513.96,423908.80,0.00,0.00,0.00),('1','149','770','164728',3257532,'2141','328',132558.55,134113.37,0.00,0.00,1554.82,435349.60,0.00,0.00,0.00),('1','149','770','164954',3261428,'2141','328',134113.37,134504.44,0.00,0.00,391.07,109499.60,0.00,0.00,0.00),('1','149','770','164955',3261429,'2141','328',134504.44,134840.72,0.00,0.00,336.28,107609.60,0.00,0.00,0.00),('1','149','770','165120',3264322,'2141','328',134840.72,136644.81,0.00,0.00,1804.09,577308.80,0.00,0.00,0.00),('1','149','770','165287',3267197,'2141','328',136644.81,138202.73,0.00,0.00,1557.92,436217.60,0.00,0.00,0.00),('1','149','770','165427',3269688,'2141','328',138202.73,138724.15,0.00,0.00,521.42,145997.60,0.00,0.00,0.00),('1','149','770','165596',3272586,'2141','328',138724.15,138874.15,0.00,0.00,150.00,42000.00,0.00,0.00,0.00),('1','149','770','165790',3276285,'2141','328',138874.15,140667.72,0.00,0.00,1793.57,502199.60,0.00,0.00,0.00),('1','149','770','165919',3278601,'2141','328',140667.72,142460.93,0.00,0.00,1793.21,502098.80,0.00,0.00,0.00),('1','149','770','166130',3282311,'2141','328',142460.93,143782.71,0.00,0.00,1321.78,370098.40,0.00,0.00,0.00),('1','149','770','166306',3285447,'2141','328',143782.71,144768.17,0.00,0.00,985.46,275928.80,0.00,0.00,0.00),('1','149','770','166466',3288460,'2141','328',144768.17,145808.17,0.00,0.00,1040.00,291200.00,0.00,0.00,0.00),('1','149','770','166684',3292210,'2141','328',145808.17,147088.99,0.00,0.00,1280.82,358629.60,0.00,0.00,0.00),('1','149','770','166872',3295394,'2141','328',147088.99,148410.74,0.00,0.00,1321.75,370090.00,0.00,0.00,0.00),('1','149','770','167022',3298064,'2141','328',148410.74,148707.88,0.00,0.00,297.14,83199.20,0.00,0.00,0.00),('1','149','770','167024',3298089,'2141','328',148707.88,149322.30,0.00,0.00,614.42,172037.60,0.00,0.00,0.00),('1','149','770','167169',3300749,'2141','328',149322.30,150782.30,0.00,0.00,1460.00,408800.00,0.00,0.00,0.00),('1','149','770','167352',3304059,'2141','328',150782.30,151955.33,0.00,0.00,1173.03,328448.40,0.00,0.00,0.00),('1','149','770','167557',3307784,'2141','328',151955.33,153261.54,0.00,0.00,1306.21,365738.80,0.00,0.00,0.00),('1','149','770','167727',3310652,'2141','328',153261.54,154599.21,0.00,0.00,1337.67,374547.60,0.00,0.00,0.00),('1','149','770','167910',3313816,'2141','328',154599.21,155670.24,0.00,0.00,1071.03,299888.40,0.00,0.00,0.00),('1','149','770','168102',3317579,'2141','328',155670.24,157760.07,0.00,0.00,2089.83,585152.40,0.00,0.00,0.00),('1','149','770','168280',3320854,'2141','328',157760.07,159878.99,0.00,0.00,2118.92,593297.60,0.00,0.00,0.00),('1','149','770','168399',3323015,'2141','328',159878.99,160827.88,0.00,0.00,948.89,265689.20,0.00,0.00,0.00),('1','149','770','168600',3326480,'2141','328',160827.88,163212.27,0.00,0.00,2384.39,667629.20,0.00,0.00,0.00),('1','149','770','168760',3329547,'2141','328',163212.27,165189.05,0.00,0.00,1976.78,553498.40,0.00,0.00,0.00),('1','149','770','168932',3332360,'2141','328',165189.05,167020.47,0.00,0.00,1831.42,512797.60,0.00,0.00,0.00),('1','149','770','169090',3335193,'2141','328',167020.47,169941.89,0.00,0.00,2921.42,817997.60,0.00,0.00,0.00),('1','149','770','169243',3338131,'2141','328',169941.89,170231.17,0.00,0.00,289.28,80998.40,0.00,0.00,0.00),('1','149','770','169253',3338279,'2141','328',170231.17,171351.88,0.00,0.00,1120.71,313798.80,0.00,0.00,0.00),('1','149','770','169426',3341734,'2141','328',171351.88,172467.05,0.00,0.00,1115.17,312247.60,0.00,0.00,0.00),('1','149','770','169558',3344246,'2141','328',172467.05,173865.83,0.00,0.00,1398.78,391658.40,0.00,0.00,0.00),('1','149','770','169747',3347855,'2141','328',173865.83,175241.18,0.00,0.00,1375.35,385098.00,0.00,0.00,0.00),('1','149','770','169908',3350950,'2141','328',175241.18,176371.35,0.00,0.00,1130.17,316447.60,0.00,0.00,0.00),('1','149','770','170109',3354427,'2141','328',176371.35,177624.67,0.00,0.00,1253.32,350929.60,0.00,0.00,0.00),('1','149','770','170316',3357927,'2141','328',177624.67,179358.77,0.00,0.00,1734.10,485548.00,0.00,0.00,0.00),('1','149','770','170458',3360407,'2141','328',179358.77,180341.77,0.00,0.00,983.00,275240.00,0.00,0.00,0.00),('1','149','770','170641',3363815,'2141','328',180341.77,183083.77,0.00,0.00,2742.00,767760.00,0.00,0.00,0.00),('1','149','770','170804',3366714,'2141','328',183083.77,184684.62,0.00,0.00,1600.85,448238.00,0.00,0.00,0.00),('1','149','770','170909',3368320,'2141','328',184684.62,185537.62,0.00,0.00,853.00,238840.00,0.00,0.00,0.00),('1','149','770','170980',3369621,'2141','328',185537.62,186232.97,0.00,0.00,695.35,194698.00,0.00,0.00,0.00),('1','149','770','171198',3373881,'2141','328',186232.97,188669.50,0.00,0.00,2436.53,682228.40,0.00,0.00,0.00),('1','149','770','171352',3376725,'2141','328',188669.50,190456.82,0.00,0.00,1787.32,500449.60,0.00,0.00,0.00),('1','149','770','171570',3380651,'2141','328',190456.82,191743.64,0.00,0.00,1286.82,360309.60,0.00,0.00,0.00),('1','149','770','171751',3383873,'2141','328',191743.64,193687.42,0.00,0.00,1943.78,544258.40,0.00,0.00,0.00),('1','149','770','171982',3387893,'2141','328',193687.42,195906.42,0.00,0.00,2219.00,621320.00,0.00,0.00,0.00),('1','149','770','172078',3389737,'2141','328',195906.42,196990.12,0.00,0.00,1083.70,303436.00,0.00,0.00,0.00),('1','149','770','172268',3393167,'2141','328',196990.12,198875.83,0.00,0.00,1885.71,527998.80,0.00,0.00,0.00),('1','149','770','172484',3397086,'2141','328',198875.83,201021.04,0.00,0.00,2145.21,600658.80,0.00,0.00,0.00),('1','149','770','172694',3400960,'2141','328',201021.04,202661.14,0.00,0.00,1640.10,459228.00,0.00,0.00,0.00),('1','149','770','172861',3403994,'2141','328',202661.14,205132.21,0.00,0.00,2471.07,691899.60,0.00,0.00,0.00),('1','149','770','173036',3407313,'2141','328',205132.21,206399.71,0.00,0.00,1267.50,354900.00,0.00,0.00,0.00),('1','149','770','173200',3410668,'2141','328',206399.71,209169.06,0.00,0.00,2769.35,775418.00,0.00,0.00,0.00),('1','149','770','173362',3413554,'2141','328',209169.06,211480.13,0.00,0.00,2311.07,647099.60,0.00,0.00,0.00),('1','149','770','173661',3418850,'2141','328',211480.13,213072.45,0.00,0.00,1592.32,445849.60,0.00,0.00,0.00),('1','149','770','173752',3420680,'2141','328',213072.45,216018.23,0.00,0.00,2945.78,824818.40,0.00,0.00,0.00),('1','149','770','173894',3423266,'2141','328',216018.23,217298.62,0.00,0.00,1280.39,358509.20,0.00,0.00,0.00),('1','149','770','174117',3427228,'2141','328',217298.62,220450.47,0.00,0.00,3151.85,882518.00,0.00,0.00,0.00),('1','149','770','174303',3430599,'2141','328',220450.47,222279.39,0.00,0.00,1828.92,512097.60,0.00,0.00,0.00),('1','149','770','174392',3431903,'2141','328',222279.39,222279.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','174399',3432046,'2141','328',222279.39,222834.42,0.00,0.00,555.03,155408.40,0.00,0.00,0.00),('1','149','770','174481',3433545,'2141','328',222834.42,224268.71,0.00,0.00,1434.29,401601.20,0.00,0.00,0.00),('1','149','770','174633',3436296,'2141','328',224268.71,227063.60,0.00,0.00,2794.89,782569.20,0.00,0.00,0.00),('1','149','770','174814',3439624,'2141','328',227063.60,228207.52,0.00,0.00,1143.92,320297.60,0.00,0.00,0.00),('1','149','770','174839',3440062,'2141','328',228207.52,229228.77,0.00,0.00,1021.25,285950.00,0.00,0.00,0.00),('1','149','770','175030',3443868,'2141','328',229228.77,232301.27,0.00,0.00,3072.50,860300.00,0.00,0.00,0.00),('1','149','770','175144',3445735,'2141','328',232301.27,233265.27,0.00,0.00,964.00,269920.00,0.00,0.00,0.00),('1','149','770','175231',3447407,'2141','328',233265.27,234218.14,0.00,0.00,952.87,304918.40,0.00,0.00,0.00),('1','149','770','175405',3450590,'2141','328',234218.14,236443.82,0.00,0.00,2225.68,712217.60,0.00,0.00,0.00),('1','149','770','175633',3454617,'2141','328',236443.82,238584.66,0.00,0.00,2140.84,685068.80,0.00,0.00,0.00),('1','149','770','175843',3458478,'2141','328',238584.66,239811.12,0.00,0.00,1226.46,392467.20,0.00,0.00,0.00),('1','149','770','175911',3459655,'2141','328',239811.12,242373.58,0.00,0.00,2562.46,819987.20,0.00,0.00,0.00),('1','149','770','176059',3462283,'2141','328',242373.58,244376.45,0.00,0.00,2002.87,640918.40,0.00,0.00,0.00),('1','149','770','176319',3467227,'2141','328',244376.45,248356.91,0.00,0.00,3980.46,1273747.20,0.00,0.00,0.00),('1','149','770','176508',3470696,'2141','328',248356.91,250264.91,0.00,0.00,1908.00,610560.00,0.00,0.00,0.00),('1','149','770','176761',3475412,'2141','328',250264.91,251925.22,0.00,0.00,1660.31,531299.20,0.00,0.00,0.00),('1','149','770','176762',3475413,'2141','328',251925.22,253656.61,0.00,0.00,1731.39,581747.04,0.00,0.00,0.00),('1','149','770','176970',3479189,'2141','328',253656.61,255539.61,0.00,0.00,1883.00,632688.00,0.00,0.00,0.00),('1','149','770','177210',3484028,'2141','328',255539.61,257453.18,0.00,0.00,1913.57,642959.52,0.00,0.00,0.00),('1','149','770','177411',3488004,'2141','328',257453.18,259490.62,0.00,0.00,2037.44,684579.84,0.00,0.00,0.00),('1','149','770','177614',3492163,'2141','328',259490.62,261160.62,0.00,0.00,1670.00,561120.00,0.00,0.00,0.00),('1','149','770','177864',3496609,'2141','328',261160.62,262598.62,0.00,0.00,1438.00,483168.00,0.00,0.00,0.00),('1','149','770','178053',3500376,'2141','328',262598.62,264146.41,0.00,0.00,1547.79,520057.44,0.00,0.00,0.00),('1','149','770','178270',3504328,'2141','328',264146.41,265844.47,0.00,0.00,1698.06,570548.16,0.00,0.00,0.00),('1','149','770','178334',3505356,'2141','328',265844.47,266060.47,0.00,0.00,216.00,72576.00,0.00,0.00,0.00),('1','149','770','178463',3507911,'2141','328',266060.47,267274.19,0.00,0.00,1213.72,407809.92,0.00,0.00,0.00),('1','149','770','178695',3512218,'2141','328',267274.19,269037.85,0.00,0.00,1763.66,592589.76,0.00,0.00,0.00),('1','149','770','178871',3515349,'2141','328',269037.85,270978.14,0.00,0.00,1940.29,651937.44,0.00,0.00,0.00),('1','149','770','178987',3517357,'2141','328',270978.14,271168.91,0.00,0.00,190.77,64098.72,0.00,0.00,0.00),('1','149','770','179079',3519106,'2141','328',271168.91,272098.91,0.00,0.00,930.00,312480.00,0.00,0.00,0.00),('1','149','770','179158',3520471,'2141','328',272098.91,273589.09,0.00,0.00,1490.18,500564.80,0.00,0.00,0.00),('1','149','770','179375',3524732,'2141','328',273589.09,275301.20,0.00,0.00,1712.11,570331.84,0.00,0.00,0.00),('1','149','770','179580',3528525,'2141','328',275301.20,276641.61,0.00,0.00,1340.41,450377.76,0.00,0.00,0.00),('1','149','770','179815',3533054,'2141','328',276641.61,278175.00,0.00,0.00,1533.39,518771.04,0.00,0.00,0.00),('1','149','770','180010',3536638,'2141','328',278175.00,280785.45,0.00,0.00,2610.45,875951.20,0.00,0.00,0.00),('1','149','770','180182',3540008,'2141','328',280785.45,281999.88,0.00,0.00,1214.43,402992.48,0.00,0.00,0.00),('1','149','770','180277',3541736,'2141','328',281999.88,282572.43,0.00,0.00,572.55,193740.80,0.00,0.00,0.00),('1','149','770','180348',3542888,'2141','328',282572.43,284438.17,0.00,0.00,1865.74,618488.64,0.00,0.00,0.00),('1','149','770','180553',3546702,'2141','328',284438.17,285921.18,0.00,0.00,1483.01,499255.36,0.00,0.00,0.00),('1','149','770','180749',3550141,'2141','328',285921.18,287432.11,0.00,0.00,1510.93,507672.48,0.00,0.00,0.00),('1','149','770','180983',3554768,'2141','328',287432.11,287736.47,0.00,0.00,304.36,102264.96,0.00,0.00,0.00),('1','149','770','180999',3555000,'2141','328',287736.47,288865.64,0.00,0.00,1129.17,380065.12,0.00,0.00,0.00),('1','149','770','181145',3557758,'2141','328',288865.64,290648.79,0.00,0.00,1783.15,594098.40,0.00,0.00,0.00),('1','149','770','181348',3561832,'2141','328',290648.79,292543.49,0.00,0.00,1894.70,638011.52,0.00,0.00,0.00),('1','149','770','181535',3565177,'2141','328',292543.49,293060.76,0.00,0.00,517.27,173802.72,0.00,0.00,0.00),('1','149','770','181584',3565932,'2141','328',293060.76,294093.79,0.00,0.00,1033.03,347098.08,0.00,0.00,0.00),('1','149','770','181727',3568385,'2141','328',294093.79,295750.27,0.00,0.00,1656.48,556551.96,0.00,0.00,0.00),('1','149','770','181946',3572270,'2141','328',295750.27,297807.93,0.00,0.00,2057.66,691373.76,0.00,0.00,0.00),('1','149','770','182122',3575630,'2141','328',297807.93,298174.29,0.00,0.00,366.36,123096.96,0.00,0.00,0.00),('1','149','770','182153',3576164,'2141','328',298174.29,300024.96,0.00,0.00,1850.67,623189.12,0.00,0.00,0.00),('1','149','770','182322',3579003,'2141','328',300024.96,302353.78,0.00,0.00,2328.82,784147.52,0.00,0.00,0.00),('1','149','770','182511',3582438,'2141','328',302353.78,303366.56,0.00,0.00,1012.78,340294.08,0.00,0.00,0.00),('1','149','770','182616',3584590,'2141','328',303366.56,303366.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','182627',3584778,'2141','328',303366.56,303850.07,0.00,0.00,483.51,162459.36,0.00,0.00,0.00),('1','149','770','183104',3593570,'2141','328',303850.07,305974.87,0.00,0.00,2124.80,713932.80,0.00,0.00,0.00),('1','149','770','183113',3593688,'2141','328',305974.87,307387.42,0.00,0.00,1412.55,474616.80,0.00,0.00,0.00),('1','149','770','183117',3593736,'2141','328',307387.42,308623.11,0.00,0.00,1235.69,415191.84,0.00,0.00,0.00),('1','149','770','183238',3595867,'2141','328',308623.11,308732.11,0.00,0.00,109.00,36624.00,0.00,0.00,0.00),('1','149','770','183289',3596714,'2141','328',308732.11,309870.87,0.00,0.00,1138.76,382623.36,0.00,0.00,0.00),('1','149','770','183465',3599863,'2141','328',309870.87,311354.55,0.00,0.00,1483.68,498516.48,0.00,0.00,0.00),('1','149','770','183679',3603829,'2141','328',311354.55,312783.43,0.00,0.00,1428.88,480103.68,0.00,0.00,0.00),('1','149','770','183918',3608341,'2141','328',312783.43,313760.74,0.00,0.00,977.31,328376.16,0.00,0.00,0.00),('1','149','770','184076',3611232,'2141','328',313760.74,313998.82,0.00,0.00,238.08,79994.88,0.00,0.00,0.00),('1','149','770','184132',3612148,'2141','328',313998.82,314828.38,0.00,0.00,829.56,278732.16,0.00,0.00,0.00),('1','149','770','184298',3614988,'2141','328',314828.38,316629.43,0.00,0.00,1801.05,605152.80,0.00,0.00,0.00),('1','149','770','184472',3618127,'2141','328',316629.43,318637.28,0.00,0.00,2007.85,674637.60,0.00,0.00,0.00),('1','149','770','184700',3622301,'2141','328',318637.28,319528.84,0.00,0.00,891.56,299564.16,0.00,0.00,0.00),('1','149','770','185221',3631399,'2141','328',319528.84,320113.55,0.00,0.00,584.71,196462.56,0.00,0.00,0.00),('1','149','770','185267',3631972,'2141','328',320113.55,321757.87,0.00,0.00,1644.32,552491.52,0.00,0.00,0.00),('1','149','770','185493',3636211,'2141','328',321757.87,323649.71,0.00,0.00,1891.84,635658.24,0.00,0.00,0.00),('1','149','770','185691',3639722,'2141','328',323649.71,325240.00,0.00,0.00,1590.29,534337.44,0.00,0.00,0.00),('1','149','770','185918',3643891,'2141','328',325240.00,325449.38,0.00,0.00,209.38,70351.68,0.00,0.00,0.00),('1','149','770','185946',3644394,'2141','328',325449.38,326513.90,0.00,0.00,1064.52,357678.72,0.00,0.00,0.00),('1','149','770','186097',3647110,'2141','328',326513.90,328148.38,0.00,0.00,1634.48,549185.28,0.00,0.00,0.00),('1','149','770','186331',3650890,'2141','328',328148.38,330385.32,0.00,0.00,2236.94,751611.84,0.00,0.00,0.00),('1','149','770','186547',3654590,'2141','328',330385.32,330918.47,0.00,0.00,533.15,179138.40,0.00,0.00,0.00),('1','149','770','186639',3656301,'2141','328',330918.47,331912.35,0.00,0.00,993.88,333943.68,0.00,0.00,0.00),('1','149','770','186776',3658468,'2141','328',331912.35,333540.50,0.00,0.00,1628.15,547058.40,0.00,0.00,0.00),('1','149','770','187003',3662239,'2141','328',333540.50,334992.37,0.00,0.00,1451.87,487828.32,0.00,0.00,0.00),('1','149','770','187164',3665046,'2141','328',334992.37,336547.37,0.00,0.00,1555.00,522480.00,0.00,0.00,0.00),('1','149','770','187470',3670692,'2141','328',336547.37,338114.51,0.00,0.00,1567.14,526559.04,0.00,0.00,0.00),('1','149','770','187673',3674186,'2141','328',338114.51,339988.94,0.00,0.00,1874.43,629808.48,0.00,0.00,0.00),('1','149','770','187873',3677600,'2141','328',339988.94,341968.18,0.00,0.00,1979.24,665024.64,0.00,0.00,0.00),('1','149','770','188052',3680697,'2141','328',341968.18,343490.78,0.00,0.00,1522.60,511593.60,0.00,0.00,0.00),('1','149','770','188284',3684766,'2141','328',343490.78,346119.60,0.00,0.00,2628.82,883283.52,0.00,0.00,0.00),('1','149','770','188432',3687280,'2141','328',346119.60,346982.96,0.00,0.00,863.36,290088.96,0.00,0.00,0.00),('1','149','770','188662',3691297,'2141','328',346982.96,349029.86,0.00,0.00,2046.90,687758.40,0.00,0.00,0.00),('1','149','770','188842',3694429,'2141','328',349029.86,350824.00,0.00,0.00,1794.14,602831.04,0.00,0.00,0.00),('1','149','770','189066',3698514,'2141','328',350824.00,352340.59,0.00,0.00,1516.59,545972.40,0.00,0.00,0.00),('1','149','770','189213',3701139,'2141','328',352340.59,354200.19,0.00,0.00,1859.60,669456.00,0.00,0.00,0.00),('1','149','770','189458',3705609,'2141','328',354200.19,355575.80,0.00,0.00,1375.61,495219.60,0.00,0.00,0.00),('1','149','770','189692',3709648,'2141','328',355575.80,356963.66,0.00,0.00,1387.86,499629.60,0.00,0.00,0.00),('1','149','770','189873',3712768,'2141','328',356963.66,357464.27,0.00,0.00,500.61,180219.60,0.00,0.00,0.00),('1','149','770','189881',3712846,'2141','328',357464.27,358412.53,0.00,0.00,948.26,341373.60,0.00,0.00,0.00),('1','149','770','190079',3717039,'2141','328',358412.53,360145.73,0.00,0.00,1733.20,623952.00,0.00,0.00,0.00),('1','149','770','190254',3720270,'2141','328',360145.73,362506.91,0.00,0.00,2361.18,850024.80,0.00,0.00,0.00),('1','149','770','190504',3724855,'2141','328',362506.91,362922.49,0.00,0.00,415.58,149608.80,0.00,0.00,0.00),('1','149','770','190536',3725484,'2141','328',362922.49,364435.66,0.00,0.00,1513.17,544741.20,0.00,0.00,0.00),('1','149','770','190683',3728296,'2141','328',364435.66,366300.20,0.00,0.00,1864.54,671234.40,0.00,0.00,0.00),('1','149','770','190908',3732386,'2141','328',366300.20,367623.24,0.00,0.00,1323.04,476294.40,0.00,0.00,0.00),('1','149','770','191179',3737177,'2141','328',367623.24,368748.48,0.00,0.00,1125.24,405086.40,0.00,0.00,0.00),('1','149','770','191284',3739199,'2141','328',368748.48,370416.91,0.00,0.00,1668.43,600634.80,0.00,0.00,0.00),('1','149','770','191491',3742917,'2141','328',370416.91,372251.99,0.00,0.00,1835.08,660628.80,0.00,0.00,0.00),('1','149','770','191701',3747096,'2141','328',372251.99,372801.62,0.00,0.00,549.63,197866.80,0.00,0.00,0.00),('1','149','770','191877',3750490,'2141','328',372801.62,373316.56,0.00,0.00,514.94,185378.40,0.00,0.00,0.00),('1','149','770','191960',3751814,'2141','328',373316.56,374589.14,0.00,0.00,1272.58,458128.80,0.00,0.00,0.00),('1','149','770','192202',3756130,'2141','328',374589.14,375970.54,0.00,0.00,1381.40,497304.00,0.00,0.00,0.00),('1','149','770','192348',3758926,'2141','328',375970.54,377471.80,0.00,0.00,1501.26,540453.60,0.00,0.00,0.00),('1','149','770','192568',3762880,'2141','328',377471.80,377918.39,0.00,0.00,446.59,160772.40,0.00,0.00,0.00),('1','149','770','192671',3764692,'2141','328',377918.39,379029.84,0.00,0.00,1111.45,400122.00,0.00,0.00,0.00),('1','149','770','192750',3766225,'2141','328',379029.84,380297.08,0.00,0.00,1267.24,456206.40,0.00,0.00,0.00),('1','149','770','193006',3770766,'2141','328',380297.08,381790.66,0.00,0.00,1493.58,537688.80,0.00,0.00,0.00),('1','149','770','193274',3775918,'2141','328',381790.66,383152.23,0.00,0.00,1361.57,490165.20,0.00,0.00,0.00),('1','149','770','193447',3779402,'2141','328',383152.23,384278.34,0.00,0.00,1126.11,405399.60,0.00,0.00,0.00),('1','149','770','193615',3782790,'2141','328',384278.34,386049.17,0.00,0.00,1770.83,637498.80,0.00,0.00,0.00),('1','149','770','193853',3786853,'2141','328',386049.17,387509.64,0.00,0.00,1460.47,525769.20,0.00,0.00,0.00),('1','149','770','194200',3793077,'2141','328',387509.64,388316.64,0.00,0.00,807.00,290520.00,0.00,0.00,0.00),('1','149','770','194610',3800373,'2141','328',388316.64,388972.42,0.00,0.00,655.78,236080.80,0.00,0.00,0.00),('1','149','770','194619',3800643,'2141','328',388972.42,391427.77,0.00,0.00,2455.35,883926.00,0.00,0.00,0.00),('1','149','770','194684',3801761,'2141','328',391427.77,393140.29,0.00,0.00,1712.52,616507.20,0.00,0.00,0.00),('1','149','770','194754',3803169,'2141','328',393140.29,393503.29,0.00,0.00,363.00,130680.00,0.00,0.00,0.00),('1','149','770','194865',3805656,'2141','328',393503.29,394706.93,0.00,0.00,1203.64,433310.40,0.00,0.00,0.00),('1','149','770','194912',3806414,'2141','328',394706.93,396256.99,0.00,0.00,1550.06,558021.60,0.00,0.00,0.00),('1','149','770','195173',3811070,'2141','328',396256.99,397766.98,0.00,0.00,1509.99,543596.40,0.00,0.00,0.00),('1','149','770','195428',3815403,'2141','328',397766.98,398539.98,0.00,0.00,773.00,278280.00,0.00,0.00,0.00),('1','149','770','195439',3815632,'2141','328',398539.98,399209.34,0.00,0.00,669.36,240969.60,0.00,0.00,0.00),('1','149','770','195526',3817243,'2141','328',399209.34,400484.82,0.00,0.00,1275.48,459172.80,0.00,0.00,0.00),('1','149','770','195845',3822515,'2141','328',400484.82,402126.65,0.00,0.00,1641.83,591058.80,0.00,0.00,0.00),('1','149','770','196040',3826173,'2141','328',402126.65,403502.31,0.00,0.00,1375.66,495237.60,0.00,0.00,0.00),('1','149','770','196227',3829869,'2141','328',403502.31,404082.88,0.00,0.00,580.57,209005.20,0.00,0.00,0.00),('1','149','770','196395',3832961,'2141','328',404082.88,405203.58,0.00,0.00,1120.70,403452.00,0.00,0.00,0.00),('1','149','770','196486',3834342,'2141','328',405203.58,406786.83,0.00,0.00,1583.25,569970.00,0.00,0.00,0.00),('1','149','770','196766',3839396,'2141','328',406786.83,408673.42,0.00,0.00,1886.59,679172.40,0.00,0.00,0.00),('1','149','770','196900',3841763,'2141','328',408673.42,409171.29,0.00,0.00,497.87,179233.20,0.00,0.00,0.00),('1','149','770','197127',3845917,'2141','328',409171.29,409987.26,0.00,0.00,815.97,293749.20,0.00,0.00,0.00),('1','149','770','197400',3850392,'2141','328',409987.26,410282.12,0.00,0.00,294.86,106149.60,0.00,0.00,0.00),('1','149','770','197403',3850424,'2141','328',410282.12,410951.12,0.00,0.00,669.00,240840.00,0.00,0.00,0.00),('1','149','770','197407',3850451,'2141','328',410951.12,412524.84,0.00,0.00,1573.72,566539.20,0.00,0.00,0.00),('1','149','770','198026',3861630,'2141','328',412524.84,414405.40,0.00,0.00,1880.56,677001.60,0.00,0.00,0.00),('1','149','770','198028',3861649,'2141','328',414405.40,415146.88,0.00,0.00,741.48,266932.80,0.00,0.00,0.00),('1','149','770','198102',3862942,'2141','328',415146.88,416521.76,0.00,0.00,1374.88,494956.80,0.00,0.00,0.00),('1','149','770','198193',3864332,'2141','328',416521.76,417712.82,0.00,0.00,1191.06,428781.60,0.00,0.00,0.00),('1','149','770','198396',3867723,'2141','328',417712.82,419072.26,0.00,0.00,1359.44,489398.40,0.00,0.00,0.00),('1','149','770','198809',3874716,'2141','328',419072.26,420415.42,0.00,0.00,1343.16,483537.60,0.00,0.00,0.00),('1','149','770','198896',3876305,'2141','328',420415.42,421726.50,0.00,0.00,1311.08,471988.80,0.00,0.00,0.00),('1','149','770','199007',3878186,'2141','328',421726.50,423328.04,0.00,0.00,1601.54,576554.40,0.00,0.00,0.00),('1','149','770','199326',3883602,'2141','328',423328.04,424734.37,0.00,0.00,1406.33,506278.80,0.00,0.00,0.00),('1','149','770','199609',3888704,'2141','328',424734.37,425994.84,0.00,0.00,1260.47,453769.20,0.00,0.00,0.00),('1','149','770','199780',3891041,'2141','328',425994.84,426339.84,0.00,0.00,345.00,124200.00,0.00,0.00,0.00),('1','149','770','199794',3891247,'2141','328',426339.84,427735.44,0.00,0.00,1395.60,502416.00,0.00,0.00,0.00),('1','149','770','199881',3892673,'2141','328',427735.44,429944.28,0.00,0.00,2208.84,795182.40,0.00,0.00,0.00),('1','149','770','200247',3899563,'2141','328',429944.28,431490.32,0.00,0.00,1546.04,556574.40,0.00,0.00,0.00),('1','149','770','200456',3903320,'2141','328',431490.32,432339.93,0.00,0.00,849.61,305859.60,0.00,0.00,0.00),('1','149','770','200577',3905318,'2141','328',432339.93,434189.97,0.00,0.00,1850.04,666014.40,0.00,0.00,0.00),('1','149','770','200780',3908935,'2141','328',434189.97,435586.14,0.00,0.00,1396.17,502621.20,0.00,0.00,0.00),('1','149','770','200954',3911842,'2141','328',435586.14,437411.88,0.00,0.00,1825.74,657266.40,0.00,0.00,0.00),('1','149','770','201232',3916610,'2141','328',437411.88,438956.99,0.00,0.00,1545.11,556239.60,0.00,0.00,0.00),('1','149','770','201407',3919692,'2141','328',438956.99,440614.90,0.00,0.00,1657.91,596847.60,0.00,0.00,0.00),('1','149','770','201549',3922216,'2141','328',440614.90,442214.41,0.00,0.00,1599.51,575823.60,0.00,0.00,0.00),('1','149','770','201786',3926888,'2141','328',442214.41,443314.64,0.00,0.00,1100.23,396082.80,0.00,0.00,0.00),('1','149','770','201944',3930004,'2141','328',443314.64,444216.51,0.00,0.00,901.87,324673.20,0.00,0.00,0.00),('1','149','770','202050',3931814,'2141','328',444216.51,446325.38,0.00,0.00,2108.87,759193.20,0.00,0.00,0.00),('1','149','770','202275',3935603,'2141','328',446325.38,448493.41,0.00,0.00,2168.03,780490.80,0.00,0.00,0.00),('1','149','770','202533',3940253,'2141','328',448493.41,450012.66,0.00,0.00,1519.25,546930.00,0.00,0.00,0.00),('1','149','770','202664',3942410,'2141','328',450012.66,451453.51,0.00,0.00,1440.85,518706.00,0.00,0.00,0.00),('1','149','770','202881',3946240,'2141','328',451453.51,452867.45,0.00,0.00,1413.94,509018.40,0.00,0.00,0.00),('1','149','770','203146',3951359,'2141','328',452867.45,454256.81,0.00,0.00,1389.36,500169.60,0.00,0.00,0.00),('1','149','770','203412',3956356,'2141','328',454256.81,455370.49,0.00,0.00,1113.68,400924.80,0.00,0.00,0.00),('1','149','770','203561',3958872,'2141','328',455370.49,457020.68,0.00,0.00,1650.19,594068.40,0.00,0.00,0.00),('1','149','770','203736',3962115,'2141','328',457020.68,458587.01,0.00,0.00,1566.33,588940.08,0.00,0.00,0.00),('1','149','770','204129',3969239,'2141','328',458587.01,459466.56,0.00,0.00,879.55,330710.80,0.00,0.00,0.00),('1','149','770','204277',3971846,'2141','328',459466.56,462283.24,0.00,0.00,2816.68,1059071.68,0.00,0.00,0.00),('1','149','770','204583',3977566,'2141','328',462283.24,464085.74,0.00,0.00,1802.50,677740.00,0.00,0.00,0.00),('1','149','770','204778',3981014,'2141','328',464085.74,465335.08,0.00,0.00,1249.34,469751.84,0.00,0.00,0.00),('1','149','770','205018',3984909,'2141','328',465335.08,466400.37,0.00,0.00,1065.29,400549.04,0.00,0.00,0.00),('1','149','770','205207',3988414,'2141','328',466400.37,467851.97,0.00,0.00,1451.60,545801.60,0.00,0.00,0.00),('1','149','770','205448',3992810,'2141','328',467851.97,469212.87,0.00,0.00,1360.90,511698.40,0.00,0.00,0.00),('1','149','770','205675',3996979,'2141','328',469212.87,470277.63,0.00,0.00,1064.76,400349.76,0.00,0.00,0.00),('1','149','770','205926',4001377,'2141','328',470277.63,471122.79,0.00,0.00,845.16,317780.16,0.00,0.00,0.00),('1','149','770','206124',4004858,'2141','328',471122.79,472577.36,0.00,0.00,1454.57,546918.32,0.00,0.00,0.00),('1','149','770','206173',4005583,'2141','328',472577.36,473896.77,0.00,0.00,1319.41,496098.16,0.00,0.00,0.00),('1','149','770','206552',4012328,'2141','328',473896.77,475431.18,0.00,0.00,1534.41,576938.16,0.00,0.00,0.00),('1','149','770','206667',4014269,'2141','328',475431.18,476128.52,0.00,0.00,697.34,262199.84,0.00,0.00,0.00),('1','149','770','206693',4014791,'2141','328',476128.52,476695.37,0.00,0.00,566.85,213135.60,0.00,0.00,0.00),('1','149','770','206830',4016987,'2141','328',476695.37,478135.11,0.00,0.00,1439.74,541342.24,0.00,0.00,0.00),('1','149','770','207043',4020877,'2141','328',478135.11,479268.32,0.00,0.00,1133.21,426086.96,0.00,0.00,0.00),('1','149','770','207303',4025526,'2141','328',479268.32,480836.65,0.00,0.00,1568.33,589692.08,0.00,0.00,0.00),('1','149','770','207518',4029413,'2141','328',480836.65,481999.51,0.00,0.00,1162.86,437235.36,0.00,0.00,0.00),('1','149','770','207678',4032229,'2141','328',481999.51,482533.42,0.00,0.00,533.91,200750.16,0.00,0.00,0.00),('1','149','770','207779',4033753,'2141','328',482533.42,484115.89,0.00,0.00,1582.47,607668.48,0.00,0.00,0.00),('1','149','770','207931',4036368,'2141','328',484115.89,486017.54,0.00,0.00,1901.65,730233.60,0.00,0.00,0.00),('1','149','770','208142',4040048,'2141','328',486017.54,487880.65,0.00,0.00,1863.11,715434.24,0.00,0.00,0.00),('1','149','770','208522',4047010,'2141','328',487880.65,488892.97,0.00,0.00,1012.32,388730.88,0.00,0.00,0.00),('1','149','770','208594',4048034,'2141','328',488892.97,490487.18,0.00,0.00,1594.21,612176.64,0.00,0.00,0.00),('1','149','770','208861',4052630,'2141','328',490487.18,493142.59,0.00,0.00,2655.41,1019677.44,0.00,0.00,0.00),('1','149','770','209052',4055955,'2141','328',493142.59,494092.00,0.00,0.00,949.41,364573.44,0.00,0.00,0.00),('1','149','770','209283',4060092,'2141','328',494092.00,495615.49,0.00,0.00,1523.49,585020.16,0.00,0.00,0.00),('1','149','770','209487',4063767,'2141','328',495615.49,497166.62,0.00,0.00,1551.13,595633.92,0.00,0.00,0.00),('1','149','770','209680',4067147,'2141','328',497166.62,498252.81,0.00,0.00,1086.19,417096.96,0.00,0.00,0.00),('1','149','770','209984',4072631,'2141','328',498252.81,499788.88,0.00,0.00,1536.07,589850.88,0.00,0.00,0.00),('1','149','770','210105',4074796,'2141','328',499788.88,501228.62,0.00,0.00,1439.74,552860.16,0.00,0.00,0.00),('1','149','770','210337',4078776,'2141','328',501228.62,502505.22,0.00,0.00,1276.60,490214.40,0.00,0.00,0.00),('1','149','770','210528',4082327,'2141','328',502505.22,503080.22,0.00,0.00,575.00,220800.00,0.00,0.00,0.00),('1','149','770','210797',4087056,'2141','328',503080.22,503671.22,0.00,0.00,591.00,236400.00,0.00,0.00,0.00),('1','149','770','210801',4087159,'2141','328',503671.22,505073.92,0.00,0.00,1402.70,561080.00,0.00,0.00,0.00),('1','149','770','211005',4090436,'2141','328',505073.92,508320.15,0.00,0.00,3246.23,1298492.00,0.00,0.00,0.00),('1','149','770','211334',4096603,'2141','328',508320.15,509902.78,0.00,0.00,1582.63,633052.00,0.00,0.00,0.00),('1','149','770','211681',4102495,'2141','328',509902.78,511656.78,0.00,0.00,1754.00,701600.00,0.00,0.00,0.00),('1','149','770','211939',4106995,'2141','328',511656.78,512361.91,0.00,0.00,705.13,282052.00,0.00,0.00,0.00),('1','149','770','211943',4107051,'2141','328',512361.91,513572.29,0.00,0.00,1210.38,484152.00,0.00,0.00,0.00),('1','149','770','212179',4111248,'2141','328',513572.29,514773.04,0.00,0.00,1200.75,480300.00,0.00,0.00,0.00),('1','149','770','212377',4114807,'2141','328',514773.04,517105.69,0.00,0.00,2332.65,933060.00,0.00,0.00,0.00),('1','149','770','212492',4116829,'2141','328',517105.69,518697.69,0.00,0.00,1592.00,636800.00,0.00,0.00,0.00),('1','149','770','212816',4122763,'2141','328',518697.69,519767.19,0.00,0.00,1069.50,427800.00,0.00,0.00,0.00),('1','149','770','212909',4124189,'2141','328',519767.19,522296.04,0.00,0.00,2528.85,1011540.00,0.00,0.00,0.00),('1','149','770','213280',4130482,'2141','328',522296.04,523996.92,0.00,0.00,1700.88,680352.00,0.00,0.00,0.00),('1','149','770','213510',4134351,'2141','328',523996.92,526421.97,0.00,0.00,2425.05,1008820.80,0.00,0.00,0.00),('1','149','770','213841',4139927,'2141','328',526421.97,527559.49,0.00,0.00,1137.52,473208.32,0.00,0.00,0.00),('1','149','770','213964',4141862,'2141','328',527559.49,529110.77,0.00,0.00,1551.28,645332.48,0.00,0.00,0.00),('1','149','770','214431',4149858,'2141','328',529110.77,530223.56,0.00,0.00,1112.79,462920.64,0.00,0.00,0.00),('1','149','770','214472',4150694,'2141','328',530223.56,532122.31,0.00,0.00,1898.75,789880.00,0.00,0.00,0.00),('1','149','770','214745',4155464,'2141','328',532122.31,533747.36,0.00,0.00,1625.05,676020.80,0.00,0.00,0.00),('1','149','770','215072',4160706,'2141','328',533747.36,534872.00,0.00,0.00,1124.64,467850.24,0.00,0.00,0.00),('1','149','770','215179',4162706,'2141','328',534872.00,535826.01,0.00,0.00,954.01,396868.16,0.00,0.00,0.00),('1','149','770','215271',4164141,'2141','328',535826.01,537171.76,0.00,0.00,1345.75,570598.00,0.00,0.00,0.00),('1','149','770','215460',4167214,'2141','328',537171.76,538143.67,0.00,0.00,971.91,412089.84,0.00,0.00,0.00),('1','149','770','216020',4177008,'2141','328',538143.67,539812.21,0.00,0.00,1668.54,707460.96,0.00,0.00,0.00),('1','149','770','216024',4177074,'2141','328',539812.21,540678.37,0.00,0.00,866.16,367251.84,0.00,0.00,0.00),('1','149','770','216133',4178853,'2141','328',540678.37,542600.55,0.00,0.00,1922.18,815004.32,0.00,0.00,0.00),('1','149','770','216345',4182549,'2141','328',542600.55,543949.52,0.00,0.00,1348.97,577359.16,0.00,0.00,0.00),('1','149','770','216604',4186926,'2141','328',543949.52,544765.91,0.00,0.00,816.39,349414.92,0.00,0.00,0.00),('1','149','770','217034',4194607,'2141','328',544765.91,545341.74,0.00,0.00,575.83,246455.24,0.00,0.00,0.00),('1','149','770','217037',4194640,'2141','328',545341.74,547002.46,0.00,0.00,1660.72,783859.84,0.00,0.00,0.00),('1','149','770','217299',4199611,'2141','328',547002.46,548396.22,0.00,0.00,1393.76,657854.72,0.00,0.00,0.00),('1','149','770','217519',4203408,'2141','328',548396.22,549901.56,0.00,0.00,1505.34,710520.48,0.00,0.00,0.00),('1','149','770','217882',4209964,'2141','328',549901.56,550747.08,0.00,0.00,845.52,399085.44,0.00,0.00,0.00),('1','149','770','218013',4212144,'2141','328',550747.08,552052.77,0.00,0.00,1305.69,616285.68,0.00,0.00,0.00),('1','149','770','218254',4216257,'2141','328',552052.77,553541.99,0.00,0.00,1489.22,702911.84,0.00,0.00,0.00),('1','149','770','218456',4219867,'2141','328',553541.99,554450.14,0.00,0.00,908.15,428646.80,0.00,0.00,0.00),('1','149','770','218688',4224073,'2141','328',554450.14,555306.47,0.00,0.00,856.33,404187.76,0.00,0.00,0.00),('1','149','770','218969',4228826,'2141','328',555306.47,556578.45,0.00,0.00,1271.98,600374.56,0.00,0.00,0.00),('1','149','770','219210',4232995,'2141','328',556578.45,557641.92,0.00,0.00,1063.47,501957.84,0.00,0.00,0.00),('1','149','770','219362',4235661,'2141','328',557641.92,558380.20,0.00,0.00,738.28,348468.16,0.00,0.00,0.00),('1','149','770','219690',4241412,'2141','328',558380.20,559605.46,0.00,0.00,1225.26,578322.72,0.00,0.00,0.00),('1','149','770','219847',4244229,'2141','328',559605.46,560522.93,0.00,0.00,917.47,433045.84,0.00,0.00,0.00),('1','149','770','220209',4250966,'2141','328',560522.93,561983.68,0.00,0.00,1460.75,642730.00,0.00,0.00,0.00),('1','149','770','220249',4251491,'2141','328',561983.68,564177.22,0.00,0.00,2193.54,965157.60,0.00,0.00,0.00),('1','149','770','220502',4255943,'2141','328',564177.22,565979.10,0.00,0.00,1801.88,792827.20,0.00,0.00,0.00),('1','149','770','220764',4260431,'2141','328',565979.10,567124.59,0.00,0.00,1145.49,504015.60,0.00,0.00,0.00),('1','149','770','220917',4263345,'2141','328',567124.59,569374.92,0.00,0.00,2250.33,990145.20,0.00,0.00,0.00),('1','149','770','221143',4267375,'2141','328',569374.92,570904.23,0.00,0.00,1529.31,672896.40,0.00,0.00,0.00),('1','149','770','221388',4271792,'2141','328',570904.23,571525.84,0.00,0.00,621.61,273508.40,0.00,0.00,0.00),('1','149','770','221532',4274510,'2141','328',571525.84,572265.95,0.00,0.00,740.11,325648.40,0.00,0.00,0.00),('1','149','770','221630',4276178,'2141','328',572265.95,573653.16,0.00,0.00,1387.21,610372.40,0.00,0.00,0.00),('1','149','770','221844',4279889,'2141','328',573653.16,575100.60,0.00,0.00,1447.44,636873.60,0.00,0.00,0.00),('1','149','770','222137',4285187,'2141','328',575100.60,576438.31,0.00,0.00,1337.71,588592.40,0.00,0.00,0.00),('1','149','770','222318',4288073,'2141','328',576438.31,577228.62,0.00,0.00,790.31,347736.40,0.00,0.00,0.00),('1','149','770','222407',4289728,'2141','328',577228.62,577950.84,0.00,0.00,722.22,317776.80,0.00,0.00,0.00),('1','149','770','222499',4291373,'2141','328',577950.84,580051.64,0.00,0.00,2100.80,924352.00,0.00,0.00,0.00),('1','149','770','222757',4296099,'2141','328',580051.64,581552.63,0.00,0.00,1500.99,660435.60,0.00,0.00,0.00),('1','149','770','222969',4300184,'2141','328',581552.63,582568.63,0.00,0.00,1016.00,447040.00,0.00,0.00,0.00),('1','149','770','223274',4305050,'2141','328',582568.63,583396.39,0.00,0.00,827.76,364214.40,0.00,0.00,0.00),('1','149','770','223427',4308016,'2141','328',583396.39,584523.28,0.00,0.00,1126.89,540907.20,0.00,0.00,0.00),('1','149','770','223662',4312323,'2141','328',584523.28,585972.35,0.00,0.00,1449.07,707146.16,0.00,0.00,0.00),('1','149','770','223909',4316812,'2141','328',585972.35,587555.22,0.00,0.00,1582.87,772440.56,0.00,0.00,0.00),('1','149','770','224144',4320876,'2141','328',587555.22,588541.77,0.00,0.00,986.55,481436.40,0.00,0.00,0.00),('1','149','770','224308',4324106,'2141','328',588541.77,589422.39,0.00,0.00,880.62,447354.96,0.00,0.00,0.00),('1','149','770','224529',4327910,'2141','328',589422.39,590734.65,0.00,0.00,1312.26,666628.08,0.00,0.00,0.00),('1','149','770','224784',4332260,'2141','328',590734.65,592785.47,0.00,0.00,2050.82,1041816.56,0.00,0.00,0.00),('1','149','770','225085',4337580,'2141','328',592785.47,593146.51,0.00,0.00,361.04,183408.32,0.00,0.00,0.00),('1','149','770','225220',4340209,'2141','328',593146.51,594073.64,0.00,0.00,927.13,470982.04,0.00,0.00,0.00),('1','149','770','225319',4341777,'2141','328',594073.64,595235.18,0.00,0.00,1161.54,590062.32,0.00,0.00,0.00),('1','149','770','225658',4348276,'2141','328',595235.18,596209.13,0.00,0.00,973.95,494766.60,0.00,0.00,0.00),('1','149','770','225934',4352860,'2141','328',596209.13,597424.21,0.00,0.00,1215.08,617260.64,0.00,0.00,0.00),('1','149','770','226187',4357498,'2141','328',597424.21,599037.88,0.00,0.00,1613.67,839108.40,0.00,0.00,0.00),('1','149','770','226357',4360437,'2141','328',599037.88,600920.07,0.00,0.00,1882.19,978738.80,0.00,0.00,0.00),('1','149','770','226692',4366638,'2141','328',600920.07,602241.57,0.00,0.00,1321.50,687180.00,0.00,0.00,0.00),('1','149','770','226923',4370869,'2141','328',602241.57,603302.42,0.00,0.00,1060.85,551642.00,0.00,0.00,0.00),('1','149','770','227151',4374810,'2141','328',603302.42,604203.42,0.00,0.00,901.00,468520.00,0.00,0.00,0.00),('1','149','770','227425',4379415,'2141','328',604203.42,604923.02,0.00,0.00,719.60,374192.00,0.00,0.00,0.00),('1','149','770','227472',4380224,'2141','328',604923.02,606012.12,0.00,0.00,1089.10,566332.00,0.00,0.00,0.00),('1','149','770','227669',4383630,'2141','328',606012.12,607642.79,0.00,0.00,1630.67,847948.40,0.00,0.00,0.00),('1','149','770','227905',4387822,'2141','328',607642.79,609403.81,0.00,0.00,1761.02,915730.40,0.00,0.00,0.00),('1','149','770','228283',4395592,'2141','328',609403.81,609646.08,0.00,0.00,242.27,125980.40,0.00,0.00,0.00),('1','149','770','228288',4395667,'2141','328',609646.08,611199.98,0.00,0.00,1553.90,808028.00,0.00,0.00,0.00),('1','149','770','228411',4397590,'2141','328',611199.98,612594.84,0.00,0.00,1394.86,781121.60,0.00,0.00,0.00),('1','149','770','228604',4401048,'2141','328',612594.84,614150.65,0.00,0.00,1555.81,871253.60,0.00,0.00,0.00),('1','149','770','228787',4404486,'2141','328',614150.65,614672.63,0.00,0.00,521.98,292308.80,0.00,0.00,0.00),('1','149','770','228888',4406509,'2141','328',614672.63,616112.84,0.00,0.00,1440.21,806517.60,0.00,0.00,0.00),('1','149','770','229211',4412581,'2141','328',616112.84,618862.64,0.00,0.00,2749.80,1539888.00,0.00,0.00,0.00),('1','149','770','229377',4415787,'2141','328',618862.64,619349.68,0.00,0.00,487.04,272742.40,0.00,0.00,0.00),('1','149','770','229383',4415887,'2141','328',619349.68,620954.09,0.00,0.00,1604.41,898469.60,0.00,0.00,0.00),('1','149','770','229476',4417284,'2141','328',620954.09,623585.54,0.00,0.00,2631.45,1536766.80,0.00,0.00,0.00),('1','149','770','229722',4422207,'2141','328',623585.54,624839.43,0.00,0.00,1253.89,732271.76,0.00,0.00,0.00),('1','149','770','229928',4426222,'2141','328',624839.43,627114.79,0.00,0.00,2275.36,1328810.24,0.00,0.00,0.00),('1','149','770','230138',4430045,'2141','328',627114.79,629419.07,0.00,0.00,2304.28,1345699.52,0.00,0.00,0.00),('1','149','770','230324',4433586,'2141','328',629419.07,630351.81,0.00,0.00,932.74,544720.16,0.00,0.00,0.00),('1','149','770','230424',4435850,'2141','328',630351.81,631319.50,0.00,0.00,967.69,565130.96,0.00,0.00,0.00),('1','149','770','230554',4437935,'2141','328',631319.50,633478.48,0.00,0.00,2158.98,1260844.32,0.00,0.00,0.00),('1','149','770','230789',4442152,'2141','328',633478.48,635037.88,0.00,0.00,1559.40,910689.60,0.00,0.00,0.00),('1','149','770','231077',4447069,'2141','328',635037.88,635469.96,0.00,0.00,432.08,252334.72,0.00,0.00,0.00),('1','149','770','231343',4451509,'2141','328',635469.96,635642.15,0.00,0.00,172.19,100558.96,0.00,0.00,0.00),('1','149','770','231386',4451936,'2141','328',635642.15,637115.78,0.00,0.00,1473.63,860599.92,0.00,0.00,0.00),('1','149','770','231641',4456441,'2141','328',637115.78,638263.82,0.00,0.00,1148.04,670455.36,0.00,0.00,0.00),('1','149','770','231901',4461177,'2141','328',638263.82,639531.49,0.00,0.00,1267.67,740319.28,0.00,0.00,0.00),('1','149','770','232103',4464912,'2141','328',639531.49,640545.91,0.00,0.00,1014.42,592421.28,0.00,0.00,0.00),('1','149','770','232336',4468951,'2141','328',640545.91,641703.20,0.00,0.00,1157.29,675857.36,0.00,0.00,0.00),('1','149','770','232586',4473607,'2141','328',641703.20,643022.31,0.00,0.00,1319.11,791466.00,0.00,0.00,0.00),('1','149','770','232861',4478369,'2141','328',643022.31,644908.16,0.00,0.00,1885.85,1131510.00,0.00,0.00,0.00),('1','149','770','233124',4483121,'2141','328',644908.16,646501.52,0.00,0.00,1593.36,956016.00,0.00,0.00,0.00),('1','149','770','233490',4489783,'2141','328',646501.52,648229.57,0.00,0.00,1728.05,1078303.20,0.00,0.00,0.00),('1','149','770','233639',4492405,'2141','328',648229.57,649724.59,0.00,0.00,1495.02,932892.48,0.00,0.00,0.00),('1','149','770','233849',4496292,'2141','328',649724.59,650991.64,0.00,0.00,1267.05,790639.20,0.00,0.00,0.00),('1','149','770','234056',4499956,'2141','328',650991.64,651978.90,0.00,0.00,987.26,616050.24,0.00,0.00,0.00),('1','149','770','234482',4507744,'2141','328',651978.90,652978.03,0.00,0.00,999.13,623457.12,0.00,0.00,0.00),('1','149','770','234646',4510696,'2141','328',652978.03,653945.79,0.00,0.00,967.76,603882.24,0.00,0.00,0.00),('1','149','770','234834',4513910,'2141','328',653945.79,655355.01,0.00,0.00,1409.22,879353.28,0.00,0.00,0.00),('1','149','770','235126',4519085,'2141','328',655355.01,656399.72,0.00,0.00,1044.71,651899.04,0.00,0.00,0.00),('1','149','770','235371',4523342,'2141','328',656399.72,657018.23,0.00,0.00,618.51,385950.24,0.00,0.00,0.00),('1','149','770','235645',4528110,'2141','328',657018.23,658093.68,0.00,0.00,1075.45,671080.80,0.00,0.00,0.00),('1','149','770','235780',4530519,'2141','328',658093.68,659578.31,0.00,0.00,1484.63,949623.84,0.00,0.00,0.00),('1','149','770','236023',4534736,'2141','328',659578.31,661114.51,0.00,0.00,1536.20,983168.00,0.00,0.00,0.00),('1','149','770','236243',4538760,'2141','328',661114.51,662359.28,0.00,0.00,1244.77,796652.80,0.00,0.00,0.00),('1','149','770','236673',4546207,'2141','328',662359.28,662807.38,0.00,0.00,448.10,286784.00,0.00,0.00,0.00),('1','149','770','236742',4547272,'2141','328',662807.38,663951.13,0.00,0.00,1143.75,732000.00,0.00,0.00,0.00),('1','149','770','236968',4551350,'2141','328',663951.13,665477.87,0.00,0.00,1526.74,977113.60,0.00,0.00,0.00),('1','149','770','237185',4555087,'2141','328',665477.87,666615.04,0.00,0.00,1137.17,727788.80,0.00,0.00,0.00),('1','149','770','237387',4558894,'2141','328',666615.04,667754.41,0.00,0.00,1139.37,729196.80,0.00,0.00,0.00),('1','149','770','237666',4563706,'2141','328',667754.41,668724.26,0.00,0.00,969.85,636221.60,0.00,0.00,0.00),('1','149','770','237870',4567130,'2141','328',668724.26,670062.03,0.00,0.00,1337.77,857063.04,0.00,0.00,0.00),('1','149','770','238125',4571160,'2141','328',670062.03,672223.69,0.00,0.00,2161.66,1383462.40,0.00,0.00,0.00),('1','149','770','238365',4575400,'2141','328',672223.69,673411.94,0.00,0.00,1188.25,760480.00,0.00,0.00,0.00),('1','149','770','238546',4578505,'2141','328',673411.94,673677.98,0.00,0.00,266.04,170265.60,0.00,0.00,0.00),('1','149','770','238608',4579402,'2141','328',673677.98,675194.42,0.00,0.00,1516.44,970521.60,0.00,0.00,0.00),('1','149','770','238856',4583763,'2141','328',675194.42,676717.18,0.00,0.00,1522.76,974566.40,0.00,0.00,0.00),('1','149','770','239068',4587623,'2141','328',676717.18,678113.01,0.00,0.00,1395.83,893331.20,0.00,0.00,0.00),('1','149','770','239291',4591509,'2141','328',678113.01,678549.66,0.00,0.00,436.65,279456.00,0.00,0.00,0.00),('1','149','770','239439',4594054,'2141','328',678549.66,678856.17,0.00,0.00,306.51,196166.40,0.00,0.00,0.00),('1','149','770','239534',4595590,'2141','328',678856.17,679998.25,0.00,0.00,1142.08,730931.20,0.00,0.00,0.00),('1','149','770','239781',4599899,'2141','328',679998.25,680982.74,0.00,0.00,984.49,630073.60,0.00,0.00,0.00),('1','149','770','239997',4603615,'2141','328',680982.74,681950.43,0.00,0.00,967.69,619321.60,0.00,0.00,0.00),('1','149','770','240219',4607521,'2141','328',681950.43,683171.75,0.00,0.00,1221.32,781644.80,0.00,0.00,0.00),('1','149','770','240456',4611345,'2141','328',683171.75,683960.23,0.00,0.00,788.48,504627.20,0.00,0.00,0.00),('1','149','770','240596',4613721,'2141','328',683960.23,684094.61,0.00,0.00,134.38,86003.20,0.00,0.00,0.00),('1','149','770','240712',4615230,'2141','328',684094.61,685298.46,0.00,0.00,1203.85,770464.00,0.00,0.00,0.00),('1','149','770','240975',4620003,'2141','328',685298.46,686633.76,0.00,0.00,1335.30,854592.00,0.00,0.00,0.00),('1','149','770','241228',4624578,'2141','328',686633.76,687772.68,0.00,0.00,1138.92,728908.80,0.00,0.00,0.00),('1','149','770','241488',4628998,'2141','328',687772.68,688756.28,0.00,0.00,983.60,629504.00,0.00,0.00,0.00),('1','149','770','241736',4633349,'2141','328',688756.28,689213.08,0.00,0.00,456.80,292352.00,0.00,0.00,0.00),('1','149','770','241897',4636011,'2141','328',689213.08,689791.79,0.00,0.00,578.71,370374.40,0.00,0.00,0.00),('1','149','770','242033',4638381,'2141','328',689791.79,690808.88,0.00,0.00,1017.09,650937.60,0.00,0.00,0.00),('1','149','770','242210',4641582,'2141','328',690808.88,691793.30,0.00,0.00,984.42,630028.80,0.00,0.00,0.00),('1','149','770','242435',4645484,'2141','328',691793.30,692941.80,0.00,0.00,1148.50,735040.00,0.00,0.00,0.00),('1','149','770','242682',4649846,'2141','328',692941.80,694298.19,0.00,0.00,1356.39,868089.60,0.00,0.00,0.00),('1','149','770','242964',4654591,'2141','328',694298.19,695463.38,0.00,0.00,1165.19,745721.60,0.00,0.00,0.00),('1','149','770','243139',4657712,'2141','328',695463.38,696902.05,0.00,0.00,1438.67,920748.80,0.00,0.00,0.00),('1','149','770','243369',4661885,'2141','328',696902.05,698046.71,0.00,0.00,1144.66,732582.40,0.00,0.00,0.00),('1','149','770','243603',4665817,'2141','328',698046.71,699618.61,0.00,0.00,1571.90,1006016.00,0.00,0.00,0.00),('1','149','770','243851',4670152,'2141','328',699618.61,701291.39,0.00,0.00,1672.78,1070579.20,0.00,0.00,0.00),('1','149','770','244054',4673701,'2141','328',701291.39,703175.39,0.00,0.00,1884.00,1205760.00,0.00,0.00,0.00),('1','149','770','244291',4677720,'2141','328',703175.39,704906.61,0.00,0.00,1731.22,1107980.80,0.00,0.00,0.00),('1','149','770','244522',4681741,'2141','328',704906.61,706269.76,0.00,0.00,1363.15,872416.00,0.00,0.00,0.00),('1','149','770','244774',4685857,'2141','328',706269.76,707395.63,0.00,0.00,1125.87,720556.80,0.00,0.00,0.00),('1','149','770','244978',4689621,'2141','328',707395.63,708468.99,0.00,0.00,1073.36,678363.52,0.00,0.00,0.00),('1','149','770','245305',4695335,'2141','328',708468.99,708866.42,0.00,0.00,397.43,251175.76,0.00,0.00,0.00),('1','149','770','245362',4696539,'2141','328',708866.42,709204.08,0.00,0.00,337.66,213401.12,0.00,0.00,0.00),('1','149','770','245436',4697705,'2141','328',709204.08,710596.71,0.00,0.00,1392.63,880142.16,0.00,0.00,0.00),('1','149','770','245728',4702733,'2141','328',710596.71,711619.82,0.00,0.00,1023.11,646605.52,0.00,0.00,0.00),('1','149','770','245956',4706008,'2141','328',711619.82,712978.31,0.00,0.00,1358.49,836829.84,0.00,0.00,0.00),('1','149','770','246233',4710709,'2141','328',712978.31,714507.11,0.00,0.00,1528.80,941740.80,0.00,0.00,0.00),('1','149','770','246526',4715773,'2141','328',714507.11,715365.06,0.00,0.00,857.95,528497.20,0.00,0.00,0.00),('1','149','770','246706',4718829,'2141','328',715365.06,716470.21,0.00,0.00,1105.15,680772.40,0.00,0.00,0.00),('1','149','770','246939',4723055,'2141','328',716470.21,717994.87,0.00,0.00,1524.66,939190.56,0.00,0.00,0.00),('1','149','770','247184',4727045,'2141','328',717994.87,719777.47,0.00,0.00,1782.60,1098081.60,0.00,0.00,0.00),('1','149','770','247485',4732545,'2141','328',719777.47,720438.52,0.00,0.00,661.05,407206.80,0.00,0.00,0.00),('1','149','770','247678',4735607,'2141','328',720438.52,721670.02,0.00,0.00,1231.50,735975.36,0.00,0.00,0.00),('1','149','770','247911',4739628,'2141','328',721670.02,722836.47,0.00,0.00,1166.45,690538.40,0.00,0.00,0.00),('1','149','770','248169',4743949,'2141','328',722836.47,724256.96,0.00,0.00,1420.49,840930.08,0.00,0.00,0.00),('1','149','770','248408',4748067,'2141','328',724256.96,724939.62,0.00,0.00,682.66,404134.72,0.00,0.00,0.00),('1','149','770','248579',4750985,'2141','328',724939.62,725409.30,0.00,0.00,469.68,278050.56,0.00,0.00,0.00),('1','149','770','248642',4752000,'2141','328',725409.30,726327.05,0.00,0.00,917.75,543308.00,0.00,0.00,0.00),('1','149','770','248922',4756602,'2141','328',726327.05,727160.37,0.00,0.00,833.32,493325.44,0.00,0.00,0.00),('1','149','770','249133',4760099,'2141','328',727160.37,728108.27,0.00,0.00,947.90,561156.80,0.00,0.00,0.00),('1','149','770','249376',4764311,'2141','328',728108.27,729359.46,0.00,0.00,1251.19,740704.48,0.00,0.00,0.00),('1','149','770','249701',4769736,'2141','328',729359.46,730127.38,0.00,0.00,767.92,454608.64,0.00,0.00,0.00),('1','149','770','249863',4772601,'2141','328',730127.38,731136.01,0.00,0.00,1008.63,597108.96,0.00,0.00,0.00),('1','149','770','250120',4776798,'2141','328',731136.01,732762.66,0.00,0.00,1626.65,962976.80,0.00,0.00,0.00),('1','149','770','250352',4780829,'2141','328',732762.66,733523.76,0.00,0.00,761.10,450571.20,0.00,0.00,0.00),('1','149','770','250428',4781947,'2141','328',733523.76,734107.21,0.00,0.00,583.45,345402.40,0.00,0.00,0.00),('1','149','770','250580',4784501,'2141','328',734107.21,736118.70,0.00,0.00,2011.49,1190802.08,0.00,0.00,0.00),('1','149','770','250800',4788489,'2141','328',736118.70,738102.82,0.00,0.00,1984.12,1174599.04,0.00,0.00,0.00),('1','149','770','251028',4792594,'2141','328',738102.82,738763.75,0.00,0.00,660.93,391270.56,0.00,0.00,0.00),('1','149','770','251129',4794291,'2141','328',738763.75,739631.05,0.00,0.00,867.30,513441.60,0.00,0.00,0.00),('1','149','770','251280',4796837,'2141','328',739631.05,741607.57,0.00,0.00,1976.52,1170099.84,0.00,0.00,0.00),('1','149','770','251530',4801067,'2141','328',741607.57,743097.60,0.00,0.00,1490.03,882097.76,0.00,0.00,0.00),('1','149','770','251773',4805463,'2141','328',743097.60,743938.56,0.00,0.00,840.96,497848.32,0.00,0.00,0.00),('1','149','770','252003',4809399,'2141','328',743938.56,745572.17,0.00,0.00,1633.61,967097.12,0.00,0.00,0.00),('1','149','770','252253',4813714,'2141','328',745572.17,747028.09,0.00,0.00,1455.92,861904.64,0.00,0.00,0.00),('1','149','770','252476',4817937,'2141','328',747028.09,748168.28,0.00,0.00,1140.19,674992.48,0.00,0.00,0.00),('1','149','770','252730',4822227,'2141','328',748168.28,749311.99,0.00,0.00,1143.71,677076.32,0.00,0.00,0.00),('1','149','770','252969',4826117,'2141','328',749311.99,750833.38,0.00,0.00,1521.39,900662.88,0.00,0.00,0.00),('1','149','770','253229',4830402,'2141','328',750833.38,752029.02,0.00,0.00,1195.64,707818.88,0.00,0.00,0.00),('1','149','770','253522',4835353,'2141','328',752029.02,753305.54,0.00,0.00,1276.52,755699.84,0.00,0.00,0.00),('1','149','770','253722',4838836,'2141','328',753305.54,754247.91,0.00,0.00,942.37,557883.04,0.00,0.00,0.00),('1','149','770','254145',4846667,'2141','328',754247.91,754710.75,0.00,0.00,462.84,274001.28,0.00,0.00,0.00),('1','149','770','254205',4847484,'2141','328',754710.75,755980.95,0.00,0.00,1270.20,751958.40,0.00,0.00,0.00),('1','149','770','254455',4851775,'2141','328',755980.95,757237.63,0.00,0.00,1256.68,743954.56,0.00,0.00,0.00),('1','149','770','254711',4856208,'2141','328',757237.63,758353.68,0.00,0.00,1116.05,660701.60,0.00,0.00,0.00),('1','149','770','254960',4860449,'2141','328',758353.68,759632.80,0.00,0.00,1279.12,757239.04,0.00,0.00,0.00),('1','149','770','255289',4866388,'2141','328',759632.80,760345.47,0.00,0.00,712.67,421900.64,0.00,0.00,0.00),('1','149','770','255463',4869143,'2141','328',760345.47,761452.31,0.00,0.00,1106.84,655249.28,0.00,0.00,0.00),('1','149','770','255726',4873403,'2141','328',761452.31,762414.45,0.00,0.00,962.14,569586.88,0.00,0.00,0.00),('1','149','770','255958',4877132,'2141','328',762414.45,763517.34,0.00,0.00,1102.89,652910.88,0.00,0.00,0.00),('1','149','770','256219',4881279,'2141','328',763517.34,764576.06,0.00,0.00,1058.72,618458.72,0.00,0.00,0.00),('1','149','770','256521',4886516,'2141','328',764576.06,765495.36,0.00,0.00,919.30,536871.20,0.00,0.00,0.00),('1','149','770','256734',4890023,'2141','328',765495.36,766479.94,0.00,0.00,984.58,574994.72,0.00,0.00,0.00),('1','149','770','256971',4894165,'2141','328',766479.94,767921.70,0.00,0.00,1441.76,841987.84,0.00,0.00,0.00),('1','149','770','257299',4900145,'2141','328',767921.70,769214.55,0.00,0.00,1292.85,755024.40,0.00,0.00,0.00),('1','149','770','257497',4903590,'2141','328',769214.55,769680.54,0.00,0.00,465.99,264682.32,0.00,0.00,0.00),('1','149','770','257631',4906096,'2141','328',769680.54,770179.73,0.00,0.00,499.19,283539.92,0.00,0.00,0.00),('1','149','770','257632',4906097,'2141','328',770179.73,771148.65,0.00,0.00,968.92,550346.56,0.00,0.00,0.00),('1','149','770','257633',4906098,'2141','328',771148.65,772719.73,0.00,0.00,1571.08,892373.44,0.00,0.00,0.00),('1','149','770','257634',4906099,'2141','328',772719.73,773983.82,0.00,0.00,1264.09,718003.12,0.00,0.00,0.00),('1','149','770','257635',4906100,'2141','328',773983.82,774906.62,0.00,0.00,922.80,524150.40,0.00,0.00,0.00),('1','149','770','257636',4906101,'2141','328',774906.62,776148.69,0.00,0.00,1242.07,705495.76,0.00,0.00,0.00),('1','149','770','257637',4906102,'2141','328',776148.69,777793.87,0.00,0.00,1645.18,934462.24,0.00,0.00,0.00),('1','149','770','257638',4906103,'2141','328',777793.87,778753.96,0.00,0.00,960.09,545331.12,0.00,0.00,0.00),('1','149','770','257638',4906104,'2142','328',0.00,778.61,0.00,0.00,778.61,442250.48,0.00,0.00,0.00),('1','149','770','257639',4906105,'2141','328',778753.96,779725.93,0.00,0.00,971.97,552078.96,0.00,0.00,0.00),('1','149','770','257639',4906106,'2142','328',778.61,913.62,0.00,0.00,135.01,76685.68,0.00,0.00,0.00),('1','149','770','257640',4906107,'2141','328',779725.93,780113.47,0.00,0.00,387.54,220122.72,0.00,0.00,0.00),('1','149','770','257640',4906108,'2142','328',913.62,913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257641',4906109,'2141','328',780113.47,781939.86,0.00,0.00,1826.39,1037389.52,0.00,0.00,0.00),('1','149','770','257641',4906110,'2142','328',913.62,1276.94,0.00,0.00,363.32,206365.76,0.00,0.00,0.00),('1','149','770','257642',4906111,'2141','328',781939.86,782776.26,0.00,0.00,836.40,475075.20,0.00,0.00,0.00),('1','149','770','257642',4906112,'2142','328',1276.94,1529.73,0.00,0.00,252.79,143584.72,0.00,0.00,0.00),('1','149','770','257643',4906113,'2141','328',782776.26,783789.57,0.00,0.00,1013.31,575560.08,0.00,0.00,0.00),('1','149','770','257643',4906114,'2142','328',1529.73,1626.72,0.00,0.00,96.99,55090.32,0.00,0.00,0.00),('1','149','770','257644',4906115,'2141','328',783789.57,784745.32,0.00,0.00,955.75,542866.00,0.00,0.00,0.00),('1','149','770','257644',4906116,'2142','328',1626.72,1772.47,0.00,0.00,145.75,82786.00,0.00,0.00,0.00),('1','149','770','257645',4906117,'2141','328',784745.32,785848.99,0.00,0.00,1103.67,626884.56,0.00,0.00,0.00),('1','149','770','257645',4906118,'2142','328',1772.47,1879.50,0.00,0.00,107.03,60793.04,0.00,0.00,0.00),('1','149','770','257646',4906119,'2141','328',785848.99,786741.54,0.00,0.00,892.55,506968.40,0.00,0.00,0.00),('1','149','770','257646',4906120,'2142','328',1879.50,2060.64,0.00,0.00,181.14,102887.52,0.00,0.00,0.00),('1','149','770','257647',4906121,'2141','328',786741.54,787616.27,0.00,0.00,874.73,496846.64,0.00,0.00,0.00),('1','149','770','257647',4906122,'2142','328',2060.64,2221.01,0.00,0.00,160.37,91090.16,0.00,0.00,0.00),('1','149','770','257648',4906123,'2141','328',787616.27,788040.31,0.00,0.00,424.04,240854.72,0.00,0.00,0.00),('1','149','770','257648',4906124,'2142','328',2221.01,2328.23,0.00,0.00,107.22,60900.96,0.00,0.00,0.00),('1','149','770','257649',4906125,'2141','328',788040.31,788511.66,0.00,0.00,471.35,267726.80,0.00,0.00,0.00),('1','149','770','257649',4906126,'2142','328',2328.23,2356.22,0.00,0.00,27.99,15898.32,0.00,0.00,0.00),('1','149','770','257650',4906127,'2141','328',788511.66,789156.55,0.00,0.00,644.89,366297.52,0.00,0.00,0.00),('1','149','770','257650',4906128,'2142','328',2356.22,2484.57,0.00,0.00,128.35,72902.80,0.00,0.00,0.00),('1','149','770','257651',4906129,'2141','328',789156.55,789790.10,0.00,0.00,633.55,359856.40,0.00,0.00,0.00),('1','149','770','257651',4906130,'2142','328',2484.57,2639.02,0.00,0.00,154.45,87727.60,0.00,0.00,0.00),('1','149','770','257652',4906131,'2141','328',789790.10,790647.84,0.00,0.00,857.74,487196.32,0.00,0.00,0.00),('1','149','770','257652',4906132,'2142','328',2639.02,2722.30,0.00,0.00,83.28,47303.04,0.00,0.00,0.00),('1','149','770','257653',4906133,'2141','328',790647.84,791515.16,0.00,0.00,867.32,492637.76,0.00,0.00,0.00),('1','149','770','257653',4906134,'2142','328',2722.30,2788.20,0.00,0.00,65.90,37431.20,0.00,0.00,0.00),('1','149','770','257654',4906135,'2141','328',791515.16,792188.29,0.00,0.00,673.13,382337.84,0.00,0.00,0.00),('1','149','770','257654',4906136,'2142','328',2788.20,2919.88,0.00,0.00,131.68,74794.24,0.00,0.00,0.00),('1','149','770','257655',4906137,'2141','328',792188.29,792206.71,0.00,0.00,18.42,10462.56,0.00,0.00,0.00),('1','149','770','257655',4906138,'2142','328',2919.88,3235.84,0.00,0.00,315.96,179465.28,0.00,0.00,0.00),('1','149','770','257656',4906139,'2141','328',792206.71,792206.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257656',4906140,'2142','328',3235.84,3429.04,0.00,0.00,193.20,109737.60,0.00,0.00,0.00),('1','149','770','257657',4906141,'2141','328',792206.71,792552.26,0.00,0.00,345.55,196272.40,0.00,0.00,0.00),('1','149','770','257657',4906142,'2142','328',3429.04,3961.79,0.00,0.00,532.75,302602.00,0.00,0.00,0.00),('1','149','770','257658',4906143,'2141','328',792552.26,792552.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257658',4906144,'2142','328',3961.79,4750.48,0.00,0.00,788.69,447975.92,0.00,0.00,0.00),('1','149','770','257659',4906145,'2141','328',792552.26,792553.32,0.00,0.00,1.06,602.08,0.00,0.00,0.00),('1','149','770','257659',4906146,'2142','328',4750.48,5636.96,0.00,0.00,886.48,503520.64,0.00,0.00,0.00),('1','149','770','257660',4906147,'2141','328',792553.32,792553.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257660',4906148,'2142','328',5636.96,6570.41,0.00,0.00,933.45,530199.60,0.00,0.00,0.00),('1','149','770','257661',4906149,'2141','328',792553.32,792553.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257661',4906150,'2142','328',6570.41,7721.85,0.00,0.00,1151.44,654017.92,0.00,0.00,0.00),('1','149','770','257662',4906151,'2141','328',792553.32,792555.96,0.00,0.00,2.64,1499.52,0.00,0.00,0.00),('1','149','770','257662',4906152,'2142','328',7721.85,8598.41,0.00,0.00,876.56,497886.08,0.00,0.00,0.00),('1','149','770','257663',4906153,'2141','328',792555.96,792555.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257663',4906154,'2142','328',8598.41,9110.86,0.00,0.00,512.45,291071.60,0.00,0.00,0.00),('1','149','770','257664',4906155,'2141','328',792555.96,792555.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257664',4906156,'2142','328',9110.86,9821.88,0.00,0.00,711.02,403859.36,0.00,0.00,0.00),('1','149','770','257665',4906157,'2141','328',792555.96,792555.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257665',4906158,'2142','328',9821.88,10689.88,0.00,0.00,868.00,502793.80,0.00,0.00,0.00),('1','149','770','257666',4906159,'2141','328',792555.96,792555.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257666',4906160,'2142','328',10689.88,11438.25,0.00,0.00,748.37,434054.60,0.00,0.00,0.00),('1','149','770','257667',4906161,'2141','328',792555.96,792556.74,0.00,0.00,0.78,452.40,0.00,0.00,0.00),('1','149','770','257667',4906162,'2142','328',11438.25,12296.32,0.00,0.00,858.07,497680.60,0.00,0.00,0.00),('1','149','770','257668',4906163,'2141','328',792556.74,792756.62,0.00,0.00,199.88,115930.40,0.00,0.00,0.00),('1','149','770','257668',4906164,'2142','328',12296.32,12507.26,0.00,0.00,210.94,122765.20,0.00,0.00,0.00),('1','149','770','257669',4906165,'2141','328',792756.62,793295.65,0.00,0.00,539.03,312637.40,0.00,0.00,0.00),('1','149','770','257669',4906166,'2142','328',12507.26,12507.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257670',4906167,'2141','328',793295.65,793321.51,0.00,0.00,25.86,14998.80,0.00,0.00,0.00),('1','149','770','257670',4906168,'2142','328',12507.26,13962.24,0.00,0.00,1454.98,843888.40,0.00,0.00,0.00),('1','149','770','257671',4906169,'2141','328',793321.51,793397.78,0.00,0.00,76.27,44236.60,0.00,0.00,0.00),('1','149','770','257671',4906170,'2142','328',13962.24,15068.69,0.00,0.00,1106.45,641741.00,0.00,0.00,0.00),('1','149','770','257672',4906171,'2141','328',793397.78,793479.68,0.00,0.00,81.90,52416.00,0.00,0.00,0.00),('1','149','770','257672',4906172,'2142','328',15068.69,15659.59,0.00,0.00,590.90,378176.00,0.00,0.00,0.00),('1','149','770','257673',4906173,'2141','328',793479.68,793616.21,0.00,0.00,136.53,87379.20,0.00,0.00,0.00),('1','149','770','257673',4906174,'2142','328',15659.59,16252.67,0.00,0.00,593.08,379571.20,0.00,0.00,0.00),('1','149','770','257674',4906175,'2141','328',793616.21,793706.50,0.00,0.00,90.29,57785.60,0.00,0.00,0.00),('1','149','770','257674',4906176,'2142','328',16252.67,17003.98,0.00,0.00,751.31,480838.40,0.00,0.00,0.00),('1','149','770','257675',4906177,'2141','328',793706.50,793945.31,0.00,0.00,238.81,152838.40,0.00,0.00,0.00),('1','149','770','257675',4906178,'2142','328',17003.98,17341.69,0.00,0.00,337.71,216134.40,0.00,0.00,0.00),('1','149','770','257676',4906179,'2141','328',793945.31,794040.29,0.00,0.00,94.98,60787.20,0.00,0.00,0.00),('1','149','770','257676',4906180,'2142','328',17341.69,17341.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257677',4906181,'2141','328',794040.29,794442.32,0.00,0.00,402.03,257299.20,0.00,0.00,0.00),('1','149','770','257677',4906182,'2142','328',17341.69,17757.40,0.00,0.00,415.71,266054.40,0.00,0.00,0.00),('1','149','770','257678',4906183,'2141','328',794442.32,794980.26,0.00,0.00,537.94,344281.60,0.00,0.00,0.00),('1','149','770','257678',4906184,'2142','328',17757.40,18542.81,0.00,0.00,785.41,502662.40,0.00,0.00,0.00),('1','149','770','257679',4906185,'2141','328',794980.26,795848.39,0.00,0.00,868.13,590328.40,0.00,0.00,0.00),('1','149','770','257679',4906186,'2142','328',18542.81,19054.78,0.00,0.00,511.97,348139.60,0.00,0.00,0.00),('1','149','770','257680',4906187,'2141','328',795848.39,796675.60,0.00,0.00,827.21,562502.80,0.00,0.00,0.00),('1','149','770','257680',4906188,'2142','328',19054.78,19358.92,0.00,0.00,304.14,206815.20,0.00,0.00,0.00),('1','149','770','257681',4906189,'2141','328',796675.60,797425.30,0.00,0.00,749.70,509796.00,0.00,0.00,0.00),('1','149','770','257681',4906190,'2142','328',19358.92,19609.34,0.00,0.00,250.42,170285.60,0.00,0.00,0.00),('1','149','770','257682',4906191,'2141','328',797425.30,797478.96,0.00,0.00,53.66,36488.80,0.00,0.00,0.00),('1','149','770','257682',4906192,'2142','328',19609.34,19609.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257683',4906193,'2141','328',797478.96,798101.81,0.00,0.00,622.85,423538.00,0.00,0.00,0.00),('1','149','770','257683',4906194,'2142','328',19609.34,19646.39,0.00,0.00,37.05,25194.00,0.00,0.00,0.00),('1','149','770','257684',4906195,'2141','328',798101.81,798662.14,0.00,0.00,560.33,381024.40,0.00,0.00,0.00),('1','149','770','257684',4906196,'2142','328',19646.39,19830.19,0.00,0.00,183.80,124984.00,0.00,0.00,0.00),('1','149','770','257685',4906197,'2141','328',798662.14,799437.46,0.00,0.00,775.32,527217.60,0.00,0.00,0.00),('1','149','770','257685',4906198,'2142','328',19830.19,19937.01,0.00,0.00,106.82,72637.60,0.00,0.00,0.00),('1','149','770','257686',4906199,'2141','328',799437.46,799807.00,0.00,0.00,369.54,251287.20,0.00,0.00,0.00),('1','149','770','257686',4906200,'2142','328',19937.01,20276.13,0.00,0.00,339.12,230601.60,0.00,0.00,0.00),('1','149','770','257687',4906201,'2141','328',799807.00,800370.72,0.00,0.00,563.72,383329.60,0.00,0.00,0.00),('1','149','770','257687',4906202,'2142','328',20276.13,20313.19,0.00,0.00,37.06,25200.80,0.00,0.00,0.00),('1','149','770','257688',4906203,'2141','328',800370.72,800373.37,0.00,0.00,2.65,1802.00,0.00,0.00,0.00),('1','149','770','257688',4906204,'2142','328',20313.19,20553.91,0.00,0.00,240.72,163689.60,0.00,0.00,0.00),('1','149','770','257689',4906205,'2141','328',800373.37,800727.39,0.00,0.00,354.02,240733.60,0.00,0.00,0.00),('1','149','770','257689',4906206,'2142','328',20553.91,20559.94,0.00,0.00,6.03,4100.40,0.00,0.00,0.00),('1','149','770','257690',4906207,'2141','328',800727.39,801546.48,0.00,0.00,819.09,556981.20,0.00,0.00,0.00),('1','149','770','257690',4906208,'2142','328',20559.94,20647.50,0.00,0.00,87.56,59540.80,0.00,0.00,0.00),('1','149','770','257691',4906209,'2141','328',801546.48,801949.53,0.00,0.00,403.05,274074.00,0.00,0.00,0.00),('1','149','770','257691',4906210,'2142','328',20647.50,20944.73,0.00,0.00,297.23,202116.40,0.00,0.00,0.00),('1','149','770','257692',4906211,'2141','328',801949.53,802842.30,0.00,0.00,892.77,607083.60,0.00,0.00,0.00),('1','149','770','257692',4906212,'2142','328',20944.73,20944.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257693',4906213,'2141','328',802842.30,802921.88,0.00,0.00,79.58,54114.40,0.00,0.00,0.00),('1','149','770','257693',4906214,'2142','328',20944.73,20944.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257694',4906215,'2141','328',802921.88,803671.01,0.00,0.00,749.13,515401.44,0.00,0.00,0.00),('1','149','770','257694',4906216,'2142','328',20944.73,20944.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257695',4906217,'2141','328',803671.01,804369.12,0.00,0.00,698.11,480299.68,0.00,0.00,0.00),('1','149','770','257695',4906218,'2142','328',20944.73,21134.17,0.00,0.00,189.44,130334.72,0.00,0.00,0.00),('1','149','770','257696',4906219,'2141','328',804369.12,805094.97,0.00,0.00,725.85,499384.80,0.00,0.00,0.00),('1','149','770','257696',4906220,'2142','328',21134.17,21225.35,0.00,0.00,91.18,62731.84,0.00,0.00,0.00),('1','149','770','257697',4906221,'2141','328',805094.97,806138.81,0.00,0.00,1043.84,718161.92,0.00,0.00,0.00),('1','149','770','257697',4906222,'2142','328',21225.35,21329.54,0.00,0.00,104.19,71682.72,0.00,0.00,0.00),('1','149','770','257698',4906223,'2141','328',806138.81,806922.35,0.00,0.00,783.54,520270.56,0.00,0.00,0.00),('1','149','770','257698',4906224,'2142','328',21329.54,21329.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257699',4906225,'2141','328',806922.35,808149.65,0.00,0.00,1227.30,814927.20,0.00,0.00,0.00),('1','149','770','257699',4906226,'2142','328',21329.54,21670.68,0.00,0.00,341.14,226516.96,0.00,0.00,0.00),('1','149','770','257700',4906227,'2141','328',808149.65,808735.43,0.00,0.00,585.78,388957.92,0.00,0.00,0.00),('1','149','770','257700',4906228,'2142','328',21670.68,21823.68,0.00,0.00,153.00,101592.00,0.00,0.00,0.00),('1','149','770','257701',4906229,'2141','328',808735.43,809323.66,0.00,0.00,588.23,390584.72,0.00,0.00,0.00),('1','149','770','257701',4906230,'2142','328',21823.68,21957.99,0.00,0.00,134.31,89181.84,0.00,0.00,0.00),('1','149','770','257702',4906231,'2141','328',809323.66,810636.90,0.00,0.00,1313.24,871991.36,0.00,0.00,0.00),('1','149','770','257702',4906232,'2142','328',21957.99,22289.92,0.00,0.00,331.93,220401.52,0.00,0.00,0.00),('1','149','770','257703',4906233,'2141','328',810636.90,812107.04,0.00,0.00,1470.14,969802.96,0.00,0.00,0.00),('1','149','770','257703',4906234,'2142','328',22289.92,22569.92,0.00,0.00,280.00,171360.00,0.00,0.00,0.00),('1','149','770','257704',4906235,'2141','328',812107.04,812982.76,0.00,0.00,875.72,575578.08,0.00,0.00,0.00),('1','149','770','257704',4906236,'2142','328',22569.92,22957.41,0.00,0.00,387.49,254579.36,0.00,0.00,0.00),('1','149','770','257705',4906237,'2141','328',812982.76,813810.54,0.00,0.00,827.78,549645.92,0.00,0.00,0.00),('1','149','770','257705',4906238,'2142','328',22957.41,23166.43,0.00,0.00,209.02,127920.24,0.00,0.00,0.00),('1','149','770','257706',4906239,'2141','328',813810.54,814773.37,0.00,0.00,962.83,632239.12,0.00,0.00,0.00),('1','149','770','257706',4906240,'2142','328',23166.43,23365.66,0.00,0.00,199.23,132288.72,0.00,0.00,0.00),('1','149','770','257707',4906241,'2141','328',814773.37,815704.19,0.00,0.00,930.82,618064.48,0.00,0.00,0.00),('1','149','770','257707',4906242,'2142','328',23365.66,23365.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257708',4906243,'2141','328',815704.19,816978.09,0.00,0.00,1273.90,845869.60,0.00,0.00,0.00),('1','149','770','257708',4906244,'2142','328',23365.66,23450.16,0.00,0.00,84.50,51122.50,0.00,0.00,0.00),('1','149','770','257709',4906245,'2141','328',816978.09,817232.42,0.00,0.00,254.33,168875.12,0.00,0.00,0.00),('1','149','770','257709',4906246,'2142','328',23450.16,23450.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257710',4906247,'2141','328',817232.42,817950.52,0.00,0.00,718.10,476818.40,0.00,0.00,0.00),('1','149','770','257710',4906248,'2142','328',23450.16,23454.68,0.00,0.00,4.52,3001.28,0.00,0.00,0.00),('1','149','770','257711',4906249,'2141','328',817950.52,818559.91,0.00,0.00,609.39,404634.96,0.00,0.00,0.00),('1','149','770','257711',4906250,'2142','328',23454.68,23576.21,0.00,0.00,121.53,80695.92,0.00,0.00,0.00),('1','149','770','257712',4906251,'2141','328',818559.91,819742.54,0.00,0.00,1182.63,785266.32,0.00,0.00,0.00),('1','149','770','257712',4906252,'2142','328',23576.21,23576.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257713',4906253,'2141','328',819742.54,820690.81,0.00,0.00,948.27,629651.28,0.00,0.00,0.00),('1','149','770','257713',4906254,'2142','328',23576.21,23772.30,0.00,0.00,196.09,130203.76,0.00,0.00,0.00),('1','149','770','257714',4906255,'2141','328',820690.81,821634.00,0.00,0.00,943.19,626278.16,0.00,0.00,0.00),('1','149','770','257714',4906256,'2142','328',23772.30,23772.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257715',4906257,'2141','328',821634.00,821936.86,0.00,0.00,302.86,201099.04,0.00,0.00,0.00),('1','149','770','257715',4906258,'2142','328',23772.30,23787.51,0.00,0.00,15.21,10099.44,0.00,0.00,0.00),('1','149','770','257716',4906259,'2141','328',821936.86,822710.71,0.00,0.00,773.85,513836.40,0.00,0.00,0.00),('1','149','770','257716',4906260,'2142','328',23787.51,23911.61,0.00,0.00,124.10,82402.40,0.00,0.00,0.00),('1','149','770','257717',4906261,'2141','328',822710.71,823389.56,0.00,0.00,678.85,450756.40,0.00,0.00,0.00),('1','149','770','257717',4906262,'2142','328',23911.61,24018.26,0.00,0.00,106.65,70815.60,0.00,0.00,0.00),('1','149','770','257718',4906263,'2141','328',823389.56,824280.67,0.00,0.00,891.11,591697.04,0.00,0.00,0.00),('1','149','770','257718',4906264,'2142','328',24018.26,24018.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257719',4906265,'2141','328',824280.67,825154.89,0.00,0.00,874.22,580482.08,0.00,0.00,0.00),('1','149','770','257719',4906266,'2142','328',24018.26,24144.29,0.00,0.00,126.03,83683.92,0.00,0.00,0.00),('1','149','770','257720',4906267,'2141','328',825154.89,825905.11,0.00,0.00,750.22,498146.08,0.00,0.00,0.00),('1','149','770','257720',4906268,'2142','328',24144.29,24144.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257721',4906269,'2141','328',825905.11,826539.27,0.00,0.00,634.16,421082.24,0.00,0.00,0.00),('1','149','770','257721',4906270,'2142','328',24144.29,24200.31,0.00,0.00,56.02,37197.28,0.00,0.00,0.00),('1','149','770','257722',4906271,'2141','328',826539.27,826936.36,0.00,0.00,397.09,263667.76,0.00,0.00,0.00),('1','149','770','257722',4906272,'2142','328',24200.31,24400.31,0.00,0.00,200.00,120000.00,0.00,0.00,0.00),('1','149','770','257723',4906273,'2141','328',826936.36,828280.62,0.00,0.00,1344.26,882688.64,0.00,0.00,0.00),('1','149','770','257723',4906274,'2142','328',24400.31,24400.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257724',4906275,'2141','328',828280.62,829091.39,0.00,0.00,810.77,538351.28,0.00,0.00,0.00),('1','149','770','257724',4906276,'2142','328',24400.31,24400.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257725',4906277,'2141','328',829091.39,829816.14,0.00,0.00,724.75,481234.00,0.00,0.00,0.00),('1','149','770','257725',4906278,'2142','328',24400.31,24502.13,0.00,0.00,101.82,67608.48,0.00,0.00,0.00),('1','149','770','257726',4906279,'2141','328',829816.14,830598.32,0.00,0.00,782.18,519367.52,0.00,0.00,0.00),('1','149','770','257726',4906280,'2142','328',24502.13,24522.46,0.00,0.00,20.33,13499.12,0.00,0.00,0.00),('1','149','770','257727',4906281,'2141','328',830598.32,831036.21,0.00,0.00,437.89,290758.96,0.00,0.00,0.00),('1','149','770','257727',4906282,'2142','328',24522.46,24599.41,0.00,0.00,76.95,51094.80,0.00,0.00,0.00),('1','149','770','257728',4906283,'2141','328',831036.21,832238.59,0.00,0.00,1202.38,798380.32,0.00,0.00,0.00),('1','149','770','257728',4906284,'2142','328',24599.41,24599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257729',4906285,'2141','328',832238.59,833388.09,0.00,0.00,1149.50,763268.00,0.00,0.00,0.00),('1','149','770','257729',4906286,'2142','328',24599.41,24785.69,0.00,0.00,186.28,123689.92,0.00,0.00,0.00),('1','149','770','257730',4906287,'2141','328',833388.09,835537.10,0.00,0.00,2149.01,1426942.64,0.00,0.00,0.00),('1','149','770','257730',4906288,'2142','328',24785.69,24918.69,0.00,0.00,133.00,79534.00,0.00,0.00,0.00),('1','149','770','257731',4906289,'2141','328',835537.10,836592.40,0.00,0.00,1055.30,700719.20,0.00,0.00,0.00),('1','149','770','257731',4906290,'2142','328',24918.69,24918.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257732',4906291,'2141','328',836592.40,837411.30,0.00,0.00,818.90,543749.60,0.00,0.00,0.00),('1','149','770','257732',4906292,'2142','328',24918.69,24918.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257733',4906293,'2141','328',837411.30,838733.54,0.00,0.00,1322.24,868067.36,0.00,0.00,0.00),('1','149','770','257733',4906294,'2142','328',24918.69,25074.71,0.00,0.00,156.02,93697.28,0.00,0.00,0.00),('1','149','770','257734',4906295,'2141','328',838733.54,839886.80,0.00,0.00,1153.26,765764.64,0.00,0.00,0.00),('1','149','770','257734',4906296,'2142','328',25074.71,25074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257735',4906297,'2141','328',839886.80,841355.76,0.00,0.00,1468.96,965489.44,0.00,0.00,0.00),('1','149','770','257735',4906298,'2142','328',25074.71,25074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257736',4906299,'2141','328',841355.76,841604.71,0.00,0.00,248.95,165302.80,0.00,0.00,0.00),('1','149','770','257736',4906300,'2142','328',25074.71,25074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257737',4906301,'2141','328',841604.71,842219.12,0.00,0.00,614.41,417798.80,0.00,0.00,0.00),('1','149','770','257737',4906302,'2142','328',25074.71,25074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257738',4906303,'2141','328',842219.12,842991.66,0.00,0.00,772.54,525327.20,0.00,0.00,0.00),('1','149','770','257738',4906304,'2142','328',25074.71,25074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257739',4906305,'2141','328',842991.66,844139.75,0.00,0.00,1148.09,780701.20,0.00,0.00,0.00),('1','149','770','257739',4906306,'2142','328',25074.71,25074.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257740',4906307,'2141','328',844139.75,845118.02,0.00,0.00,978.27,665223.60,0.00,0.00,0.00),('1','149','770','257740',4906308,'2142','328',25074.71,25076.18,0.00,0.00,1.47,999.60,0.00,0.00,0.00),('1','149','770','257741',4906309,'2141','328',845118.02,845861.47,0.00,0.00,743.45,505546.00,0.00,0.00,0.00),('1','149','770','257741',4906310,'2142','328',25076.18,25186.79,0.00,0.00,110.61,75214.80,0.00,0.00,0.00),('1','149','770','257742',4906311,'2141','328',845861.47,845950.85,0.00,0.00,89.38,60778.40,0.00,0.00,0.00),('1','149','770','257742',4906312,'2142','328',25186.79,25213.33,0.00,0.00,26.54,18047.20,0.00,0.00,0.00),('1','149','770','257743',4906313,'2141','328',845950.85,846569.64,0.00,0.00,618.79,420777.20,0.00,0.00,0.00),('1','149','770','257743',4906314,'2142','328',25213.33,25336.24,0.00,0.00,122.91,83578.80,0.00,0.00,0.00),('1','149','770','257744',4906315,'2141','328',846569.64,846849.57,0.00,0.00,279.93,191260.80,0.00,0.00,0.00),('1','149','770','257744',4906316,'2142','328',25336.24,25389.26,0.00,0.00,53.02,36053.60,0.00,0.00,0.00),('1','149','770','257745',4906317,'2141','328',846849.57,847634.26,0.00,0.00,784.69,564976.80,0.00,0.00,0.00),('1','149','770','257745',4906318,'2142','328',25389.26,25512.14,0.00,0.00,122.88,88473.60,0.00,0.00,0.00),('1','149','770','257746',4906319,'2141','328',847634.26,848913.76,0.00,0.00,1279.50,921240.00,0.00,0.00,0.00),('1','149','770','257746',4906320,'2142','328',25512.14,25772.36,0.00,0.00,260.22,187358.40,0.00,0.00,0.00),('1','149','770','257747',4906321,'2141','328',848913.76,848933.49,0.00,0.00,19.73,14205.60,0.00,0.00,0.00),('1','149','770','257747',4906322,'2142','328',25772.36,25777.22,0.00,0.00,4.86,3499.20,0.00,0.00,0.00),('1','149','770','257748',4906323,'2141','328',848933.49,849125.35,0.00,0.00,191.86,138139.20,0.00,0.00,0.00),('1','149','770','257748',4906324,'2142','328',25777.22,25777.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257749',4906325,'2141','328',849125.35,849607.07,0.00,0.00,481.72,346838.40,0.00,0.00,0.00),('1','149','770','257749',4906326,'2142','328',25777.22,25840.98,0.00,0.00,63.76,45907.20,0.00,0.00,0.00),('1','149','770','257750',4906327,'2141','328',849607.07,850525.81,0.00,0.00,918.74,661492.80,0.00,0.00,0.00),('1','149','770','257750',4906328,'2142','328',25840.98,25940.73,0.00,0.00,99.75,71820.00,0.00,0.00,0.00),('1','149','770','257751',4906329,'2141','328',850525.81,851661.80,0.00,0.00,1135.99,817912.80,0.00,0.00,0.00),('1','149','770','257751',4906330,'2142','328',25940.73,25940.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257752',4906331,'2141','328',851661.80,852671.84,0.00,0.00,1010.04,762830.40,0.00,0.00,0.00),('1','149','770','257752',4906332,'2142','328',25940.73,26109.79,0.00,0.00,169.06,128485.60,0.00,0.00,0.00),('1','149','770','257753',4906333,'2141','328',852671.84,853755.91,0.00,0.00,1084.07,823893.20,0.00,0.00,0.00),('1','149','770','257753',4906334,'2142','328',26109.79,26109.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257754',4906335,'2141','328',853755.91,853946.98,0.00,0.00,191.07,145213.20,0.00,0.00,0.00),('1','149','770','257754',4906336,'2142','328',26109.79,26156.69,0.00,0.00,46.90,35644.00,0.00,0.00,0.00),('1','149','770','257755',4906337,'2141','328',853946.98,854901.88,0.00,0.00,954.90,725724.00,0.00,0.00,0.00),('1','149','770','257755',4906338,'2142','328',26156.69,26156.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257756',4906339,'2141','328',854901.88,856186.74,0.00,0.00,1284.86,976493.60,0.00,0.00,0.00),('1','149','770','257756',4906340,'2142','328',26156.69,26156.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257757',4906341,'2141','328',856186.74,857000.37,0.00,0.00,813.63,618358.80,0.00,0.00,0.00),('1','149','770','257757',4906342,'2142','328',26156.69,26230.94,0.00,0.00,74.25,56430.00,0.00,0.00,0.00),('1','149','770','257758',4906343,'2141','328',857000.37,857801.34,0.00,0.00,800.97,608737.20,0.00,0.00,0.00),('1','149','770','257758',4906344,'2142','328',26230.94,26266.85,0.00,0.00,35.91,27291.60,0.00,0.00,0.00),('1','149','770','257759',4906345,'2141','328',857801.34,858262.58,0.00,0.00,461.24,350542.40,0.00,0.00,0.00),('1','149','770','257759',4906346,'2142','328',26266.85,26342.16,0.00,0.00,75.31,57235.60,0.00,0.00,0.00),('1','149','770','257760',4906347,'2141','328',858262.58,859112.69,0.00,0.00,850.11,646083.60,0.00,0.00,0.00),('1','149','770','257760',4906348,'2142','328',26342.16,26357.29,0.00,0.00,15.13,11498.80,0.00,0.00,0.00),('1','149','770','257761',4906349,'2141','328',859112.69,859112.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257761',4906350,'2142','328',26357.29,26441.15,0.00,0.00,83.86,63733.60,0.00,0.00,0.00),('1','149','770','257762',4906351,'2141','328',859112.69,859632.69,0.00,0.00,520.00,395200.00,0.00,0.00,0.00),('1','149','770','257762',4906352,'2142','328',26441.15,26591.95,0.00,0.00,150.80,114608.00,0.00,0.00,0.00),('1','149','770','257763',4906353,'2141','328',859632.69,860231.00,0.00,0.00,598.31,454715.60,0.00,0.00,0.00),('1','149','770','257763',4906354,'2142','328',26591.95,26665.55,0.00,0.00,73.60,55936.00,0.00,0.00,0.00),('1','149','770','257764',4906355,'2141','328',860231.00,860984.69,0.00,0.00,753.69,572804.40,0.00,0.00,0.00),('1','149','770','257764',4906356,'2142','328',26665.55,26678.05,0.00,0.00,12.50,9500.00,0.00,0.00,0.00),('1','149','770','257765',4906357,'2141','328',860984.69,861686.78,0.00,0.00,702.09,533588.40,0.00,0.00,0.00),('1','149','770','257765',4906358,'2142','328',26678.05,26749.10,0.00,0.00,71.05,53998.00,0.00,0.00,0.00),('1','149','770','257766',4906359,'2141','328',861686.78,862644.84,0.00,0.00,958.06,728125.60,0.00,0.00,0.00),('1','149','770','257766',4906360,'2142','328',26749.10,26749.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257767',4906361,'2141','328',862644.84,863444.10,0.00,0.00,799.26,607437.60,0.00,0.00,0.00),('1','149','770','257767',4906362,'2142','328',26749.10,26836.51,0.00,0.00,87.41,66431.60,0.00,0.00,0.00),('1','149','770','257768',4906363,'2141','328',863444.10,863444.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257768',4906364,'2142','328',26836.51,26856.98,0.00,0.00,20.47,15557.20,0.00,0.00,0.00),('1','149','770','257769',4906365,'2141','328',863444.10,864195.95,0.00,0.00,751.85,571406.00,0.00,0.00,0.00),('1','149','770','257769',4906366,'2142','328',26856.98,26856.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257770',4906367,'2141','328',864195.95,865101.65,0.00,0.00,905.70,688332.00,0.00,0.00,0.00),('1','149','770','257770',4906368,'2142','328',26856.98,26856.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257771',4906369,'2141','328',865101.65,865750.99,0.00,0.00,649.34,493498.40,0.00,0.00,0.00),('1','149','770','257771',4906370,'2142','328',26856.98,26940.57,0.00,0.00,83.59,63528.40,0.00,0.00,0.00),('1','149','770','257772',4906371,'2141','328',865750.99,866552.63,0.00,0.00,801.64,609246.40,0.00,0.00,0.00),('1','149','770','257772',4906372,'2142','328',26940.57,26946.62,0.00,0.00,6.05,4598.00,0.00,0.00,0.00),('1','149','770','257773',4906373,'2141','328',866552.63,867653.61,0.00,0.00,1100.98,836744.80,0.00,0.00,0.00),('1','149','770','257773',4906374,'2142','328',26946.62,27041.95,0.00,0.00,95.33,72450.80,0.00,0.00,0.00),('1','149','770','257774',4906375,'2141','328',867653.61,868321.69,0.00,0.00,668.08,507740.80,0.00,0.00,0.00),('1','149','770','257774',4906376,'2142','328',27041.95,27041.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257775',4906377,'2141','328',868321.69,868960.05,0.00,0.00,638.36,485153.60,0.00,0.00,0.00),('1','149','770','257775',4906378,'2142','328',27041.95,27085.51,0.00,0.00,43.56,33105.60,0.00,0.00,0.00),('1','149','770','257776',4906379,'2141','328',868960.05,868989.66,0.00,0.00,29.61,22503.60,0.00,0.00,0.00),('1','149','770','257776',4906380,'2142','328',27085.51,27085.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257777',4906381,'2141','328',868989.66,869661.58,0.00,0.00,671.92,510659.20,0.00,0.00,0.00),('1','149','770','257777',4906382,'2142','328',27085.51,27183.94,0.00,0.00,98.43,74806.80,0.00,0.00,0.00),('1','149','770','257778',4906383,'2141','328',869661.58,870332.34,0.00,0.00,670.76,509777.60,0.00,0.00,0.00),('1','149','770','257778',4906384,'2142','328',27183.94,27335.25,0.00,0.00,151.31,114995.60,0.00,0.00,0.00),('1','149','770','257779',4906385,'2141','328',870332.34,871243.50,0.00,0.00,911.16,692481.60,0.00,0.00,0.00),('1','149','770','257779',4906386,'2142','328',27335.25,27335.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257780',4906387,'2141','328',871243.50,872000.89,0.00,0.00,757.39,575616.40,0.00,0.00,0.00),('1','149','770','257780',4906388,'2142','328',27335.25,27377.23,0.00,0.00,41.98,31904.80,0.00,0.00,0.00),('1','149','770','257781',4906389,'2141','328',872000.89,872568.27,0.00,0.00,567.38,431208.80,0.00,0.00,0.00),('1','149','770','257781',4906390,'2142','328',27377.23,27532.96,0.00,0.00,155.73,118354.80,0.00,0.00,0.00),('1','149','770','257782',4906391,'2141','328',872568.27,873343.43,0.00,0.00,775.16,589121.60,0.00,0.00,0.00),('1','149','770','257782',4906392,'2142','328',27532.96,27628.28,0.00,0.00,95.32,72443.20,0.00,0.00,0.00),('1','149','770','257783',4906393,'2141','328',873343.43,873488.34,0.00,0.00,144.91,110131.60,0.00,0.00,0.00),('1','149','770','257783',4906394,'2142','328',27628.28,27662.09,0.00,0.00,33.81,25695.60,0.00,0.00,0.00),('1','149','770','257784',4906395,'2141','328',873488.34,874501.05,0.00,0.00,1012.71,769659.60,0.00,0.00,0.00),('1','149','770','257784',4906396,'2142','328',27662.09,27662.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257785',4906397,'2141','328',874501.05,875591.98,0.00,0.00,1090.93,829106.80,0.00,0.00,0.00),('1','149','770','257785',4906398,'2142','328',27662.09,27662.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257786',4906399,'2141','328',875591.98,877043.34,0.00,0.00,1451.36,1103033.60,0.00,0.00,0.00),('1','149','770','257786',4906400,'2142','328',27662.09,27771.81,0.00,0.00,109.72,83387.20,0.00,0.00,0.00),('1','149','770','257787',4906401,'2141','328',877043.34,878106.58,0.00,0.00,1063.24,808062.40,0.00,0.00,0.00),('1','149','770','257787',4906402,'2142','328',27771.81,27777.86,0.00,0.00,6.05,4598.00,0.00,0.00,0.00),('1','149','770','257788',4906403,'2141','328',878106.58,878596.71,0.00,0.00,490.13,372498.80,0.00,0.00,0.00),('1','149','770','257788',4906404,'2142','328',27777.86,27810.75,0.00,0.00,32.89,24996.40,0.00,0.00,0.00),('1','149','770','257789',4906405,'2141','328',878596.71,878919.58,0.00,0.00,322.87,245381.20,0.00,0.00,0.00),('1','149','770','257789',4906406,'2142','328',27810.75,27856.95,0.00,0.00,46.20,35112.00,0.00,0.00,0.00),('1','149','770','257790',4906407,'2141','328',878919.58,879974.93,0.00,0.00,1055.35,802066.00,0.00,0.00,0.00),('1','149','770','257790',4906408,'2142','328',27856.95,27856.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257791',4906409,'2141','328',879974.93,881215.50,0.00,0.00,1240.57,942833.20,0.00,0.00,0.00),('1','149','770','257791',4906410,'2142','328',27856.95,28003.53,0.00,0.00,146.58,111400.80,0.00,0.00,0.00),('1','149','770','257792',4906411,'2141','328',881215.50,881872.79,0.00,0.00,657.29,499540.40,0.00,0.00,0.00),('1','149','770','257792',4906412,'2142','328',28003.53,28100.05,0.00,0.00,96.52,73355.20,0.00,0.00,0.00),('1','149','770','257793',4906413,'2141','328',881872.79,882402.88,0.00,0.00,530.09,402868.40,0.00,0.00,0.00),('1','149','770','257793',4906414,'2142','328',28100.05,28182.44,0.00,0.00,82.39,62616.40,0.00,0.00,0.00),('1','149','770','257794',4906415,'2141','328',882402.88,883268.94,0.00,0.00,866.06,658205.60,0.00,0.00,0.00),('1','149','770','257794',4906416,'2142','328',28182.44,28182.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257795',4906417,'2141','328',883268.94,884095.51,0.00,0.00,826.57,628193.20,0.00,0.00,0.00),('1','149','770','257795',4906418,'2142','328',28182.44,28303.43,0.00,0.00,120.99,91952.40,0.00,0.00,0.00),('1','149','770','257796',4906419,'2141','328',884095.51,884484.62,0.00,0.00,389.11,295723.60,0.00,0.00,0.00),('1','149','770','257796',4906420,'2142','328',28303.43,28303.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257797',4906421,'2141','328',884484.62,884796.13,0.00,0.00,311.51,236747.60,0.00,0.00,0.00),('1','149','770','257797',4906422,'2142','328',28303.43,28369.36,0.00,0.00,65.93,50106.80,0.00,0.00,0.00),('1','149','770','257798',4906423,'2141','328',884796.13,886146.33,0.00,0.00,1350.20,1026152.00,0.00,0.00,0.00),('1','149','770','257798',4906424,'2142','328',28369.36,28371.33,0.00,0.00,1.97,1497.20,0.00,0.00,0.00),('1','149','770','257799',4906425,'2141','328',886146.33,887480.32,0.00,0.00,1333.99,1013832.40,0.00,0.00,0.00),('1','149','770','257799',4906426,'2142','328',28371.33,28371.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257800',4906427,'2141','328',887480.32,888200.81,0.00,0.00,720.49,547572.40,0.00,0.00,0.00),('1','149','770','257800',4906428,'2142','328',28371.33,28371.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257801',4906429,'2141','328',888200.81,888814.07,0.00,0.00,613.26,466077.60,0.00,0.00,0.00),('1','149','770','257801',4906430,'2142','328',28371.33,28465.70,0.00,0.00,94.37,71721.20,0.00,0.00,0.00),('1','149','770','257802',4906431,'2141','328',888814.07,889482.47,0.00,0.00,668.40,507984.00,0.00,0.00,0.00),('1','149','770','257802',4906432,'2142','328',28465.70,28465.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257803',4906433,'2141','328',889482.47,890260.80,0.00,0.00,778.33,591530.80,0.00,0.00,0.00),('1','149','770','257803',4906434,'2142','328',28465.70,28562.68,0.00,0.00,96.98,73704.80,0.00,0.00,0.00),('1','149','770','257804',4906435,'2141','328',890260.80,891941.32,0.00,0.00,1680.52,1266923.20,0.00,0.00,0.00),('1','149','770','257804',4906436,'2142','328',28562.68,28562.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257805',4906437,'2141','328',891941.32,892706.89,0.00,0.00,765.57,577033.20,0.00,0.00,0.00),('1','149','770','257805',4906438,'2142','328',28562.68,29331.47,0.00,0.00,768.79,550920.40,0.00,0.00,0.00),('1','149','770','257806',4906439,'2141','328',892706.89,893920.28,0.00,0.00,1213.39,880712.16,0.00,0.00,0.00),('1','149','770','257806',4906440,'2142','328',29331.47,29385.31,0.00,0.00,53.84,40056.96,0.00,0.00,0.00),('1','149','770','257807',4906441,'2141','328',893920.28,894133.03,0.00,0.00,212.75,158286.00,0.00,0.00,0.00),('1','149','770','257807',4906442,'2142','328',29385.31,29553.85,0.00,0.00,168.54,117875.69,0.00,0.00,0.00),('1','149','770','257808',4906443,'2141','328',894133.03,894830.73,0.00,0.00,697.70,519088.80,0.00,0.00,0.00),('1','149','770','257808',4906444,'2142','328',29553.85,30005.27,0.00,0.00,451.42,318265.48,0.00,0.00,0.00),('1','149','770','257809',4906445,'2141','328',894830.73,895966.64,0.00,0.00,1135.91,836787.04,0.00,0.00,0.00),('1','149','770','257809',4906446,'2142','328',30005.27,30005.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257810',4906447,'2141','328',895966.64,896894.34,0.00,0.00,927.70,687758.80,0.00,0.00,0.00),('1','149','770','257810',4906448,'2142','328',30005.27,30005.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257811',4906449,'2141','328',896894.34,897629.19,0.00,0.00,734.85,544278.40,0.00,0.00,0.00),('1','149','770','257811',4906450,'2142','328',30005.27,30005.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257812',4906451,'2141','328',897629.19,898539.16,0.00,0.00,909.97,672607.68,0.00,0.00,0.00),('1','149','770','257812',4906452,'2142','328',30005.27,30005.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257813',4906453,'2141','328',898539.16,898835.74,0.00,0.00,296.58,220655.52,0.00,0.00,0.00),('1','149','770','257813',4906454,'2142','328',30005.27,30005.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257814',4906455,'2141','328',898835.74,899236.84,0.00,0.00,401.10,298418.40,0.00,0.00,0.00),('1','149','770','257814',4906456,'2142','328',30005.27,30005.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257815',4906457,'2141','328',899236.84,900834.28,0.00,0.00,1597.44,1186045.36,0.00,0.00,0.00),('1','149','770','257815',4906458,'2142','328',30005.27,30005.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257816',4906459,'2141','328',900834.28,903347.38,0.00,0.00,2513.10,1828194.40,0.00,0.00,0.00),('1','149','770','257816',4906460,'2142','328',30005.27,30011.32,0.00,0.00,6.05,4501.20,0.00,0.00,0.00),('1','149','770','257817',4906461,'2141','328',903347.38,903798.21,0.00,0.00,450.83,329047.52,0.00,0.00,0.00),('1','149','770','257817',4906462,'2142','328',30011.32,30015.64,0.00,0.00,4.32,3002.40,0.00,0.00,0.00),('1','149','770','257818',4906463,'2141','328',903798.21,905808.96,0.00,0.00,2010.75,1448713.00,0.00,0.00,0.00),('1','149','770','257818',4906464,'2142','328',30015.64,30015.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257819',4906465,'2141','328',905808.96,907048.81,0.00,0.00,1239.85,922448.40,0.00,0.00,0.00),('1','149','770','257819',4906466,'2142','328',30015.64,30020.00,0.00,0.00,4.36,3243.84,0.00,0.00,0.00),('1','149','770','257820',4906467,'2141','328',907048.81,908286.33,0.00,0.00,1237.52,920714.88,0.00,0.00,0.00),('1','149','770','257820',4906468,'2142','328',30020.00,30024.03,0.00,0.00,4.03,2998.32,0.00,0.00,0.00),('1','149','770','257821',4906469,'2141','328',908286.33,909428.93,0.00,0.00,1142.60,850094.40,0.00,0.00,0.00),('1','149','770','257821',4906470,'2142','328',30024.03,30024.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257822',4906471,'2141','328',909428.93,909459.98,0.00,0.00,31.05,23101.20,0.00,0.00,0.00),('1','149','770','257822',4906472,'2142','328',30024.03,30024.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257823',4906473,'2141','328',909459.98,910265.25,0.00,0.00,805.27,594220.88,0.00,0.00,0.00),('1','149','770','257823',4906474,'2142','328',30024.03,30223.33,0.00,0.00,199.30,145829.20,0.00,0.00,0.00),('1','149','770','257824',4906475,'2141','328',910265.25,911223.51,0.00,0.00,958.26,706575.44,0.00,0.00,0.00),('1','149','770','257824',4906476,'2142','328',30223.33,30396.38,0.00,0.00,173.05,128749.20,0.00,0.00,0.00),('1','149','770','257825',4906477,'2141','328',911223.51,912375.06,0.00,0.00,1151.55,834703.20,0.00,0.00,0.00),('1','149','770','257825',4906478,'2142','328',30396.38,31168.71,0.00,0.00,772.33,544723.52,0.00,0.00,0.00),('1','149','770','257826',4906479,'2141','328',912375.06,912791.10,0.00,0.00,416.04,309533.76,0.00,0.00,0.00),('1','149','770','257826',4906480,'2142','328',31168.71,31168.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257827',4906481,'2141','328',912791.10,913255.53,0.00,0.00,464.43,352687.12,0.00,0.00,0.00),('1','149','770','257827',4906482,'2142','328',31168.71,31168.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257828',4906483,'2141','328',913255.53,913641.93,0.00,0.00,386.40,291159.52,0.00,0.00,0.00),('1','149','770','257828',4906484,'2142','328',31168.71,31278.45,0.00,0.00,109.74,83019.52,0.00,0.00,0.00),('1','149','770','257829',4906485,'2141','328',913641.93,913677.98,0.00,0.00,36.05,27398.00,0.00,0.00,0.00),('1','149','770','257829',4906486,'2142','328',31278.45,31278.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257830',4906487,'2141','328',913677.98,914462.35,0.00,0.00,784.37,596121.20,0.00,0.00,0.00),('1','149','770','257830',4906488,'2142','328',31278.45,31279.50,0.00,0.00,1.05,798.00,0.00,0.00,0.00),('1','149','770','257831',4906489,'2141','328',914462.35,915259.99,0.00,0.00,797.64,606206.40,0.00,0.00,0.00),('1','149','770','257831',4906490,'2142','328',31279.50,31361.77,0.00,0.00,82.27,62525.20,0.00,0.00,0.00),('1','149','770','257832',4906491,'2141','328',915259.99,916232.35,0.00,0.00,972.36,738993.60,0.00,0.00,0.00),('1','149','770','257832',4906492,'2142','328',31361.77,31361.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257833',4906493,'2141','328',916232.35,917276.45,0.00,0.00,1044.10,793516.00,0.00,0.00,0.00),('1','149','770','257833',4906494,'2142','328',31361.77,31361.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257834',4906495,'2141','328',917276.45,917276.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257834',4906496,'2142','328',31361.77,31361.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257835',4906497,'2141','328',917276.45,918581.55,0.00,0.00,1305.10,991876.00,0.00,0.00,0.00),('1','149','770','257835',4906498,'2142','328',31361.77,31361.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257836',4906499,'2141','328',918581.55,918647.38,0.00,0.00,65.83,50030.80,0.00,0.00,0.00),('1','149','770','257836',4906500,'2142','328',31361.77,31361.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257837',4906501,'2141','328',918647.38,919072.96,0.00,0.00,425.58,323440.80,0.00,0.00,0.00),('1','149','770','257837',4906502,'2142','328',31361.77,31705.37,0.00,0.00,343.60,261136.00,0.00,0.00,0.00),('1','149','770','257838',4906503,'2141','328',919072.96,920064.41,0.00,0.00,991.45,737527.90,0.00,0.00,0.00),('1','149','770','257838',4906504,'2142','328',31705.37,31751.14,0.00,0.00,45.77,34052.88,0.00,0.00,0.00),('1','149','770','257839',4906505,'2141','328',920064.41,920982.75,0.00,0.00,918.34,681544.96,0.00,0.00,0.00),('1','149','770','257839',4906506,'2142','328',31751.14,31837.50,0.00,0.00,86.36,64251.84,0.00,0.00,0.00),('1','149','770','257840',4906507,'2141','328',920982.75,921979.17,0.00,0.00,996.42,734536.48,0.00,0.00,0.00),('1','149','770','257840',4906508,'2142','328',31837.50,31921.78,0.00,0.00,84.28,62704.32,0.00,0.00,0.00),('1','149','770','257841',4906509,'2141','328',921979.17,922940.19,0.00,0.00,961.02,714998.88,0.00,0.00,0.00),('1','149','770','257841',4906510,'2142','328',31921.78,31990.74,0.00,0.00,68.96,51306.24,0.00,0.00,0.00),('1','149','770','257842',4906511,'2141','328',922940.19,923256.21,0.00,0.00,316.02,235118.88,0.00,0.00,0.00),('1','149','770','257842',4906512,'2142','328',31990.74,32068.70,0.00,0.00,77.96,56302.24,0.00,0.00,0.00),('1','149','770','257843',4906513,'2141','328',923256.21,923894.81,0.00,0.00,638.60,470018.40,0.00,0.00,0.00),('1','149','770','257843',4906514,'2142','328',32068.70,32162.52,0.00,0.00,93.82,69802.08,0.00,0.00,0.00),('1','149','770','257844',4906515,'2141','328',923894.81,925119.42,0.00,0.00,1224.61,892075.96,0.00,0.00,0.00),('1','149','770','257844',4906516,'2142','328',32162.52,32295.88,0.00,0.00,133.36,99219.84,0.00,0.00,0.00),('1','149','770','257845',4906517,'2141','328',925119.42,925730.31,0.00,0.00,610.89,454502.16,0.00,0.00,0.00),('1','149','770','257845',4906518,'2142','328',32295.88,32369.86,0.00,0.00,73.98,55041.12,0.00,0.00,0.00),('1','149','770','257846',4906519,'2141','328',925730.31,926741.12,0.00,0.00,1010.81,744222.64,0.00,0.00,0.00),('1','149','770','257846',4906520,'2142','328',32369.86,32734.35,0.00,0.00,364.49,264380.56,0.00,0.00,0.00),('1','149','770','257847',4906521,'2141','328',926741.12,927261.89,0.00,0.00,520.77,384052.88,0.00,0.00,0.00),('1','149','770','257847',4906522,'2142','328',32734.35,32856.19,0.00,0.00,121.84,90648.96,0.00,0.00,0.00),('1','149','770','257848',4906523,'2141','328',927261.89,927658.00,0.00,0.00,396.11,294705.84,0.00,0.00,0.00),('1','149','770','257848',4906524,'2142','328',32856.19,32992.82,0.00,0.00,136.63,101652.72,0.00,0.00,0.00),('1','149','770','257849',4906525,'2141','328',927658.00,927942.92,0.00,0.00,284.92,211980.48,0.00,0.00,0.00),('1','149','770','257849',4906526,'2142','328',32992.82,33020.44,0.00,0.00,27.62,20549.28,0.00,0.00,0.00),('1','149','770','257850',4906527,'2141','328',927942.92,929025.34,0.00,0.00,1082.42,790073.18,0.00,0.00,0.00),('1','149','770','257850',4906528,'2142','328',33020.44,33287.47,0.00,0.00,267.03,195270.32,0.00,0.00,0.00),('1','149','770','257851',4906529,'2141','328',929025.34,930330.74,0.00,0.00,1305.40,947587.60,0.00,0.00,0.00),('1','149','770','257851',4906530,'2142','328',33287.47,33468.44,0.00,0.00,180.97,134641.68,0.00,0.00,0.00),('1','149','770','257852',4906531,'2141','328',930330.74,931005.94,0.00,0.00,675.20,502348.80,0.00,0.00,0.00),('1','149','770','257852',4906532,'2142','328',33468.44,33932.88,0.00,0.00,464.44,337043.36,0.00,0.00,0.00),('1','149','770','257853',4906533,'2141','328',931005.94,932054.05,0.00,0.00,1048.11,756163.84,0.00,0.00,0.00),('1','149','770','257853',4906534,'2142','328',33932.88,34076.21,0.00,0.00,143.33,106637.52,0.00,0.00,0.00),('1','149','770','257854',4906535,'2141','328',932054.05,932346.57,0.00,0.00,292.52,217634.88,0.00,0.00,0.00),('1','149','770','257854',4906536,'2142','328',34076.21,34232.11,0.00,0.00,155.90,115989.60,0.00,0.00,0.00),('1','149','770','257855',4906537,'2141','328',932346.57,932954.62,0.00,0.00,608.05,452389.20,0.00,0.00,0.00),('1','149','770','257855',4906538,'2142','328',34232.11,34593.28,0.00,0.00,361.17,268710.48,0.00,0.00,0.00),('1','149','770','257856',4906539,'2141','328',932954.62,934184.17,0.00,0.00,1229.55,889251.20,0.00,0.00,0.00),('1','149','770','257856',4906540,'2142','328',34593.28,35056.82,0.00,0.00,463.54,343173.76,0.00,0.00,0.00),('1','149','770','257857',4906541,'2141','328',934184.17,935131.64,0.00,0.00,947.47,703217.68,0.00,0.00,0.00),('1','149','770','257857',4906542,'2142','328',35056.82,35528.64,0.00,0.00,471.82,351034.08,0.00,0.00,0.00),('1','149','770','257858',4906543,'2141','328',935131.64,936281.16,0.00,0.00,1149.52,839941.52,0.00,0.00,0.00),('1','149','770','257858',4906544,'2142','328',35528.64,35823.56,0.00,0.00,294.92,219420.48,0.00,0.00,0.00),('1','149','770','257859',4906545,'2141','328',936281.16,936392.91,0.00,0.00,111.75,82326.00,0.00,0.00,0.00),('1','149','770','257859',4906546,'2142','328',35823.56,35823.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257860',4906547,'2141','328',936392.91,936889.65,0.00,0.00,496.74,367874.56,0.00,0.00,0.00),('1','149','770','257860',4906548,'2142','328',35823.56,36281.56,0.00,0.00,458.00,332252.00,0.00,0.00,0.00),('1','149','770','257861',4906549,'2141','328',936889.65,937902.59,0.00,0.00,1012.94,736687.36,0.00,0.00,0.00),('1','149','770','257861',4906550,'2142','328',36281.56,36697.47,0.00,0.00,415.91,305917.04,0.00,0.00,0.00),('1','149','770','257862',4906551,'2141','328',937902.59,938849.45,0.00,0.00,946.86,685763.84,0.00,0.00,0.00),('1','149','770','257862',4906552,'2142','328',36697.47,37757.48,0.00,0.00,1060.01,758067.44,0.00,0.00,0.00),('1','149','770','257863',4906553,'2141','328',938849.45,939608.68,0.00,0.00,759.23,552195.56,0.00,0.00,0.00),('1','149','770','257863',4906554,'2142','328',37757.48,37908.57,0.00,0.00,151.09,112410.96,0.00,0.00,0.00),('1','149','770','257864',4906555,'2141','328',939608.68,940777.03,0.00,0.00,1168.35,838672.40,0.00,0.00,0.00),('1','149','770','257864',4906556,'2142','328',37908.57,38146.91,0.00,0.00,238.34,177324.96,0.00,0.00,0.00),('1','149','770','257865',4906557,'2141','328',940777.03,941279.76,0.00,0.00,502.73,374031.12,0.00,0.00,0.00),('1','149','770','257865',4906558,'2142','328',38146.91,38344.59,0.00,0.00,197.68,147073.92,0.00,0.00,0.00),('1','149','770','257866',4906559,'2141','328',941279.76,941854.55,0.00,0.00,574.79,427643.76,0.00,0.00,0.00),('1','149','770','257866',4906560,'2142','328',38344.59,38740.82,0.00,0.00,396.23,294795.12,0.00,0.00,0.00),('1','149','770','257867',4906561,'2141','328',941854.55,942434.02,0.00,0.00,579.47,431125.68,0.00,0.00,0.00),('1','149','770','257867',4906562,'2142','328',38740.82,39127.44,0.00,0.00,386.62,287645.28,0.00,0.00,0.00),('1','149','770','257868',4906563,'2141','328',942434.02,942697.68,0.00,0.00,263.66,196163.04,0.00,0.00,0.00),('1','149','770','257868',4906564,'2142','328',39127.44,39540.08,0.00,0.00,412.64,307004.16,0.00,0.00,0.00),('1','149','770','257869',4906565,'2141','328',942697.68,942937.68,0.00,0.00,240.00,178560.00,0.00,0.00,0.00),('1','149','770','257869',4906566,'2142','328',39540.08,39637.07,0.00,0.00,96.99,72160.56,0.00,0.00,0.00),('1','149','770','257870',4906567,'2141','328',942937.68,943023.68,0.00,0.00,86.00,63984.00,0.00,0.00,0.00),('1','149','770','257870',4906568,'2142','328',39637.07,39652.92,0.00,0.00,15.85,11792.40,0.00,0.00,0.00),('1','149','770','257871',4906569,'2141','328',943023.68,943849.62,0.00,0.00,825.94,614499.36,0.00,0.00,0.00),('1','149','770','257871',4906570,'2142','328',39652.92,40341.47,0.00,0.00,688.55,512281.20,0.00,0.00,0.00),('1','149','770','257872',4906571,'2141','328',943849.62,944846.13,0.00,0.00,996.51,741403.44,0.00,0.00,0.00),('1','149','770','257872',4906572,'2142','328',40341.47,40800.68,0.00,0.00,459.21,341652.24,0.00,0.00,0.00),('1','149','770','257873',4906573,'2141','328',944846.13,945693.01,0.00,0.00,846.88,623303.68,0.00,0.00,0.00),('1','149','770','257873',4906574,'2142','328',40800.68,40990.92,0.00,0.00,190.24,140016.64,0.00,0.00,0.00),('1','149','770','257874',4906575,'2141','328',945693.01,946052.99,0.00,0.00,359.98,264945.28,0.00,0.00,0.00),('1','149','770','257874',4906576,'2142','328',40990.92,41053.30,0.00,0.00,62.38,45911.68,0.00,0.00,0.00),('1','149','770','257875',4906577,'2141','328',946052.99,946052.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257875',4906578,'2142','328',41053.30,41053.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257876',4906579,'2141','328',946052.99,946374.48,0.00,0.00,321.49,236616.64,0.00,0.00,0.00),('1','149','770','257876',4906580,'2142','328',41053.30,41406.26,0.00,0.00,352.96,259778.56,0.00,0.00,0.00),('1','149','770','257877',4906581,'2141','328',946374.48,946791.80,0.00,0.00,417.32,307147.52,0.00,0.00,0.00),('1','149','770','257877',4906582,'2142','328',41406.26,42608.78,0.00,0.00,1202.52,885054.72,0.00,0.00,0.00),('1','149','770','257878',4906583,'2141','328',946791.80,947455.27,0.00,0.00,663.47,488313.92,0.00,0.00,0.00),('1','149','770','257878',4906584,'2142','328',42608.78,42906.30,0.00,0.00,297.52,218974.72,0.00,0.00,0.00),('1','149','770','257879',4906585,'2141','328',947455.27,948255.33,0.00,0.00,800.06,588844.16,0.00,0.00,0.00),('1','149','770','257879',4906586,'2142','328',42906.30,43289.19,0.00,0.00,382.89,281807.04,0.00,0.00,0.00),('1','149','770','257880',4906587,'2141','328',948255.33,948716.58,0.00,0.00,461.25,339480.00,0.00,0.00,0.00),('1','149','770','257880',4906588,'2142','328',43289.19,43469.33,0.00,0.00,180.14,132583.04,0.00,0.00,0.00),('1','149','770','257881',4906589,'2141','328',948716.58,948716.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257881',4906590,'2142','328',43469.33,43469.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257882',4906591,'2141','328',948716.58,948716.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257882',4906592,'2142','328',43469.33,43491.53,0.00,0.00,22.20,16339.20,0.00,0.00,0.00),('1','149','770','257883',4906593,'2141','328',948716.58,949010.24,0.00,0.00,293.66,216133.76,0.00,0.00,0.00),('1','149','770','257883',4906594,'2142','328',43491.53,43516.68,0.00,0.00,25.15,18510.40,0.00,0.00,0.00),('1','149','770','257884',4906595,'2141','328',949010.24,949695.30,0.00,0.00,685.06,504204.16,0.00,0.00,0.00),('1','149','770','257884',4906596,'2142','328',43516.68,43871.99,0.00,0.00,355.31,261508.16,0.00,0.00,0.00),('1','149','770','257885',4906597,'2141','328',949695.30,951120.49,0.00,0.00,1425.19,1022839.84,0.00,0.00,0.00),('1','149','770','257885',4906598,'2142','328',43871.99,44252.28,0.00,0.00,380.29,279893.44,0.00,0.00,0.00),('1','149','770','257886',4906599,'2141','328',951120.49,951866.67,0.00,0.00,746.18,546668.48,0.00,0.00,0.00),('1','149','770','257886',4906600,'2142','328',44252.28,44988.94,0.00,0.00,736.66,542181.76,0.00,0.00,0.00),('1','149','770','257887',4906601,'2141','328',951866.67,951905.35,0.00,0.00,38.68,28468.48,0.00,0.00,0.00),('1','149','770','257887',4906602,'2142','328',44988.94,45361.29,0.00,0.00,372.35,266849.60,0.00,0.00,0.00),('1','149','770','257888',4906603,'2141','328',951905.35,951905.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257888',4906604,'2142','328',45361.29,45361.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257889',4906605,'2141','328',951905.35,952212.51,0.00,0.00,307.16,226069.76,0.00,0.00,0.00),('1','149','770','257889',4906606,'2142','328',45361.29,45431.96,0.00,0.00,70.67,52013.12,0.00,0.00,0.00),('1','149','770','257890',4906607,'2141','328',952212.51,952542.78,0.00,0.00,330.27,243078.72,0.00,0.00,0.00),('1','149','770','257890',4906608,'2142','328',45431.96,45929.11,0.00,0.00,497.15,365902.40,0.00,0.00,0.00),('1','149','770','257891',4906609,'2141','328',952542.78,953998.86,0.00,0.00,1456.08,1044854.88,0.00,0.00,0.00),('1','149','770','257891',4906610,'2142','328',45929.11,46929.68,0.00,0.00,1000.57,720422.20,0.00,0.00,0.00),('1','149','770','257892',4906611,'2141','328',953998.86,954637.11,0.00,0.00,638.25,469752.00,0.00,0.00,0.00),('1','149','770','257892',4906612,'2142','328',46929.68,47224.97,0.00,0.00,295.29,217333.44,0.00,0.00,0.00),('1','149','770','257893',4906613,'2141','328',954637.11,954876.06,0.00,0.00,238.95,175867.20,0.00,0.00,0.00),('1','149','770','257893',4906614,'2142','328',47224.97,47373.43,0.00,0.00,148.46,109266.56,0.00,0.00,0.00),('1','149','770','257894',4906615,'2141','328',954876.06,954901.83,0.00,0.00,25.77,18966.72,0.00,0.00,0.00),('1','149','770','257894',4906616,'2142','328',47373.43,47379.54,0.00,0.00,6.11,4496.96,0.00,0.00,0.00),('1','149','770','257895',4906617,'2141','328',954901.83,954901.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257895',4906618,'2142','328',47379.54,47379.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257896',4906619,'2141','328',954901.83,955674.69,0.00,0.00,772.86,568824.96,0.00,0.00,0.00),('1','149','770','257896',4906620,'2142','328',47379.54,48442.17,0.00,0.00,1062.63,782095.68,0.00,0.00,0.00),('1','149','770','257897',4906621,'2141','328',955674.69,957088.76,0.00,0.00,1414.07,1040755.52,0.00,0.00,0.00),('1','149','770','257897',4906622,'2142','328',48442.17,48491.45,0.00,0.00,49.28,36270.08,0.00,0.00,0.00),('1','149','770','257898',4906623,'2141','328',957088.76,957088.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257898',4906624,'2142','328',48491.45,48497.07,0.00,0.00,5.62,4136.32,0.00,0.00,0.00),('1','149','770','257899',4906625,'2141','328',957088.76,957088.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257899',4906626,'2142','328',48497.07,48497.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257900',4906627,'2141','328',957088.76,957462.35,0.00,0.00,373.59,285422.76,0.00,0.00,0.00),('1','149','770','257900',4906628,'2142','328',48497.07,48534.50,0.00,0.00,37.43,28596.52,0.00,0.00,0.00),('1','149','770','257901',4906629,'2141','328',957462.35,958832.69,0.00,0.00,1370.34,1025014.32,0.00,0.00,0.00),('1','149','770','257901',4906630,'2142','328',48534.50,48742.33,0.00,0.00,207.83,155456.84,0.00,0.00,0.00),('1','149','770','257902',4906631,'2141','328',958832.69,959330.78,0.00,0.00,498.09,372571.32,0.00,0.00,0.00),('1','149','770','257902',4906632,'2142','328',48742.33,49716.01,0.00,0.00,973.68,728312.64,0.00,0.00,0.00),('1','149','770','257903',4906633,'2141','328',959330.78,960627.31,0.00,0.00,1296.53,969804.44,0.00,0.00,0.00),('1','149','770','257903',4906634,'2142','328',49716.01,49747.22,0.00,0.00,31.21,23345.08,0.00,0.00,0.00),('1','149','770','257904',4906635,'2141','328',960627.31,960645.52,0.00,0.00,18.21,13621.08,0.00,0.00,0.00),('1','149','770','257904',4906636,'2142','328',49747.22,49747.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257905',4906637,'2141','328',960645.52,960645.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257905',4906638,'2142','328',49747.22,49747.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257906',4906639,'2141','328',960645.52,962505.52,0.00,0.00,1860.00,1391280.00,0.00,0.00,0.00),('1','149','770','257906',4906640,'2142','328',49747.22,49830.96,0.00,0.00,83.74,62637.52,0.00,0.00,0.00),('1','149','770','257907',4906641,'2141','328',962505.52,965150.71,0.00,0.00,2645.19,1978602.12,0.00,0.00,0.00),('1','149','770','257907',4906642,'2142','328',49830.96,50200.30,0.00,0.00,369.34,276266.32,0.00,0.00,0.00),('1','149','770','257908',4906643,'2141','328',965150.71,965212.40,0.00,0.00,61.69,46144.12,0.00,0.00,0.00),('1','149','770','257908',4906644,'2142','328',50200.30,50826.67,0.00,0.00,626.37,468524.76,0.00,0.00,0.00),('1','149','770','257909',4906645,'2141','328',965212.40,965873.47,0.00,0.00,661.07,494480.36,0.00,0.00,0.00),('1','149','770','257909',4906646,'2142','328',50826.67,50856.28,0.00,0.00,29.61,22148.28,0.00,0.00,0.00),('1','149','770','257910',4906647,'2141','328',965873.47,967925.33,0.00,0.00,2051.86,1534791.28,0.00,0.00,0.00),('1','149','770','257910',4906648,'2142','328',50856.28,51321.41,0.00,0.00,465.13,347917.24,0.00,0.00,0.00),('1','149','770','257911',4906649,'2141','328',967925.33,969141.83,0.00,0.00,1216.50,924540.00,0.00,0.00,0.00),('1','149','770','257911',4906650,'2142','328',51321.41,51772.46,0.00,0.00,451.05,342798.00,0.00,0.00,0.00),('1','149','770','257912',4906651,'2141','328',969141.83,969544.34,0.00,0.00,402.51,305907.60,0.00,0.00,0.00),('1','149','770','257912',4906652,'2142','328',51772.46,51818.01,0.00,0.00,45.55,34618.00,0.00,0.00,0.00),('1','149','770','257913',4906653,'2141','328',969544.34,969544.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257913',4906654,'2142','328',51818.01,51834.81,0.00,0.00,16.80,12768.00,0.00,0.00,0.00),('1','149','770','257914',4906655,'2141','328',969544.34,970159.49,0.00,0.00,615.15,467514.00,0.00,0.00,0.00),('1','149','770','257914',4906656,'2142','328',51834.81,51960.96,0.00,0.00,126.15,95874.00,0.00,0.00,0.00),('1','149','770','257915',4906657,'2141','328',970159.49,970648.06,0.00,0.00,488.57,371313.20,0.00,0.00,0.00),('1','149','770','257915',4906658,'2142','328',51960.96,53195.70,0.00,0.00,1234.74,938402.40,0.00,0.00,0.00),('1','149','770','257916',4906659,'2141','328',970648.06,971340.62,0.00,0.00,692.56,526345.60,0.00,0.00,0.00),('1','149','770','257916',4906660,'2142','328',53195.70,53492.18,0.00,0.00,296.48,225324.80,0.00,0.00,0.00),('1','149','770','257917',4906661,'2141','328',971340.62,971936.46,0.00,0.00,595.84,452838.40,0.00,0.00,0.00),('1','149','770','257917',4906662,'2142','328',53492.18,53744.56,0.00,0.00,252.38,191808.80,0.00,0.00,0.00),('1','149','770','257918',4906663,'2141','328',971936.46,972369.88,0.00,0.00,433.42,329399.20,0.00,0.00,0.00),('1','149','770','257918',4906664,'2142','328',53744.56,54061.26,0.00,0.00,316.70,240692.00,0.00,0.00,0.00),('1','149','770','257919',4906665,'2141','328',972369.88,972369.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257919',4906666,'2142','328',54061.26,54067.20,0.00,0.00,5.94,4514.40,0.00,0.00,0.00),('1','149','770','257920',4906667,'2141','328',972369.88,973099.93,0.00,0.00,730.05,583208.00,0.00,0.00,0.00),('1','149','770','257920',4906668,'2142','328',54067.20,54235.26,0.00,0.00,168.06,134448.00,0.00,0.00,0.00),('1','149','770','257921',4906669,'2141','328',973099.93,973847.77,0.00,0.00,747.84,598272.00,0.00,0.00,0.00),('1','149','770','257921',4906670,'2142','328',54235.26,54521.18,0.00,0.00,285.92,228736.00,0.00,0.00,0.00),('1','149','770','257922',4906671,'2141','328',973847.77,974372.03,0.00,0.00,524.26,419408.00,0.00,0.00,0.00),('1','149','770','257922',4906672,'2142','328',54521.18,55862.61,0.00,0.00,1341.43,1073144.00,0.00,0.00,0.00),('1','149','770','257923',4906673,'2141','328',974372.03,975866.74,0.00,0.00,1494.71,1135979.60,0.00,0.00,0.00),('1','149','770','257923',4906674,'2142','328',55862.61,56231.18,0.00,0.00,368.57,280113.20,0.00,0.00,0.00),('1','149','770','257924',4906675,'2141','328',975866.74,975887.53,0.00,0.00,20.79,15800.40,0.00,0.00,0.00),('1','149','770','257924',4906676,'2142','328',56231.18,56231.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257925',4906677,'2141','328',975887.53,976547.41,0.00,0.00,659.88,501508.80,0.00,0.00,0.00),('1','149','770','257925',4906678,'2142','328',56231.18,57443.91,0.00,0.00,1212.73,921674.80,0.00,0.00,0.00),('1','149','770','257926',4906679,'2141','328',976547.41,977040.73,0.00,0.00,493.32,374923.20,0.00,0.00,0.00),('1','149','770','257926',4906680,'2142','328',57443.91,57965.52,0.00,0.00,521.61,396423.60,0.00,0.00,0.00),('1','149','770','257927',4906681,'2141','328',977040.73,977715.00,0.00,0.00,674.27,512445.20,0.00,0.00,0.00),('1','149','770','257927',4906682,'2142','328',57965.52,57979.86,0.00,0.00,14.34,10898.40,0.00,0.00,0.00),('1','149','770','257928',4906683,'2141','328',977715.00,978637.88,0.00,0.00,922.88,701388.80,0.00,0.00,0.00),('1','149','770','257928',4906684,'2142','328',57979.86,58001.32,0.00,0.00,21.46,16309.60,0.00,0.00,0.00),('1','149','770','257929',4906685,'2141','328',978637.88,978790.10,0.00,0.00,152.22,115687.20,0.00,0.00,0.00),('1','149','770','257929',4906686,'2142','328',58001.32,58001.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257930',4906687,'2141','328',978790.10,978793.72,0.00,0.00,3.62,2751.20,0.00,0.00,0.00),('1','149','770','257930',4906688,'2142','328',58001.32,58001.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257931',4906689,'2141','328',978793.72,979985.42,0.00,0.00,1191.70,905692.00,0.00,0.00,0.00),('1','149','770','257931',4906690,'2142','328',58001.32,58013.82,0.00,0.00,12.50,9500.00,0.00,0.00,0.00),('1','149','770','257932',4906691,'2141','328',979985.42,980883.00,0.00,0.00,897.58,682160.80,0.00,0.00,0.00),('1','149','770','257932',4906692,'2142','328',58013.82,58013.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257933',4906693,'2141','328',980883.00,981816.64,0.00,0.00,933.64,709566.40,0.00,0.00,0.00),('1','149','770','257933',4906694,'2142','328',58013.82,58013.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257934',4906695,'2141','328',981816.64,982706.49,0.00,0.00,889.85,676286.00,0.00,0.00,0.00),('1','149','770','257934',4906696,'2142','328',58013.82,58085.14,0.00,0.00,71.32,54203.20,0.00,0.00,0.00),('1','149','770','257935',4906697,'2141','328',982706.49,983555.52,0.00,0.00,849.03,645262.80,0.00,0.00,0.00),('1','149','770','257935',4906698,'2142','328',58085.14,58085.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257936',4906699,'2141','328',983555.52,983555.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257936',4906700,'2142','328',58085.14,58085.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257937',4906701,'2141','328',983555.52,984075.57,0.00,0.00,520.05,395238.00,0.00,0.00,0.00),('1','149','770','257937',4906702,'2142','328',58085.14,58183.63,0.00,0.00,98.49,74852.40,0.00,0.00,0.00),('1','149','770','257938',4906703,'2141','328',984075.57,984825.00,0.00,0.00,749.43,569566.80,0.00,0.00,0.00),('1','149','770','257938',4906704,'2142','328',58183.63,58183.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257939',4906705,'2141','328',984825.00,985498.98,0.00,0.00,673.98,512224.80,0.00,0.00,0.00),('1','149','770','257939',4906706,'2142','328',58183.63,58311.03,0.00,0.00,127.40,96824.00,0.00,0.00,0.00),('1','149','770','257940',4906707,'2141','328',985498.98,986336.55,0.00,0.00,837.57,636553.20,0.00,0.00,0.00),('1','149','770','257940',4906708,'2142','328',58311.03,58311.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257941',4906709,'2141','328',986336.55,987278.15,0.00,0.00,941.60,715616.00,0.00,0.00,0.00),('1','149','770','257941',4906710,'2142','328',58311.03,58317.87,0.00,0.00,6.84,5198.40,0.00,0.00,0.00),('1','149','770','257942',4906711,'2141','328',987278.15,987981.26,0.00,0.00,703.11,534363.60,0.00,0.00,0.00),('1','149','770','257942',4906712,'2142','328',58317.87,58317.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257943',4906713,'2141','328',987981.26,988018.76,0.00,0.00,37.50,28500.00,0.00,0.00,0.00),('1','149','770','257943',4906714,'2142','328',58317.87,58317.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257944',4906715,'2141','328',988018.76,988018.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257944',4906716,'2142','328',58317.87,58317.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257945',4906717,'2141','328',988018.76,988770.53,0.00,0.00,751.77,571345.20,0.00,0.00,0.00),('1','149','770','257945',4906718,'2142','328',58317.87,58438.12,0.00,0.00,120.25,91390.00,0.00,0.00,0.00),('1','149','770','257946',4906719,'2141','328',988770.53,989357.79,0.00,0.00,587.26,446317.60,0.00,0.00,0.00),('1','149','770','257946',4906720,'2142','328',58438.12,58534.71,0.00,0.00,96.59,73408.40,0.00,0.00,0.00),('1','149','770','257947',4906721,'2141','328',989357.79,989995.35,0.00,0.00,637.56,484545.60,0.00,0.00,0.00),('1','149','770','257947',4906722,'2142','328',58534.71,58626.11,0.00,0.00,91.40,69464.00,0.00,0.00,0.00),('1','149','770','257948',4906723,'2141','328',989995.35,991045.76,0.00,0.00,1050.41,798311.60,0.00,0.00,0.00),('1','149','770','257948',4906724,'2142','328',58626.11,58699.95,0.00,0.00,73.84,56118.40,0.00,0.00,0.00),('1','149','770','257949',4906725,'2141','328',991045.76,991190.70,0.00,0.00,144.94,110154.40,0.00,0.00,0.00),('1','149','770','257949',4906726,'2142','328',58699.95,59655.30,0.00,0.00,955.35,726066.00,0.00,0.00,0.00),('1','149','770','257950',4906727,'2141','328',991190.70,991778.87,0.00,0.00,588.17,447009.20,0.00,0.00,0.00),('1','149','770','257950',4906728,'2142','328',59655.30,59655.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257951',4906729,'2141','328',991778.87,991778.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257951',4906730,'2142','328',59655.30,59655.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257952',4906731,'2141','328',991778.87,992424.32,0.00,0.00,645.45,490542.00,0.00,0.00,0.00),('1','149','770','257952',4906732,'2142','328',59655.30,59804.42,0.00,0.00,149.12,113331.20,0.00,0.00,0.00),('1','149','770','257953',4906733,'2141','328',992424.32,993599.26,0.00,0.00,1174.94,892954.40,0.00,0.00,0.00),('1','149','770','257953',4906734,'2142','328',59804.42,59804.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257954',4906735,'2141','328',993599.26,994457.55,0.00,0.00,858.29,652300.40,0.00,0.00,0.00),('1','149','770','257954',4906736,'2142','328',59804.42,59913.17,0.00,0.00,108.75,82650.00,0.00,0.00,0.00),('1','149','770','257955',4906737,'2141','328',994457.55,995319.48,0.00,0.00,861.93,655066.80,0.00,0.00,0.00),('1','149','770','257955',4906738,'2142','328',59913.17,59928.30,0.00,0.00,15.13,11498.80,0.00,0.00,0.00),('1','149','770','257956',4906739,'2141','328',995319.48,996077.61,0.00,0.00,758.13,576178.80,0.00,0.00,0.00),('1','149','770','257956',4906740,'2142','328',59928.30,59982.53,0.00,0.00,54.23,41214.80,0.00,0.00,0.00),('1','149','770','257957',4906741,'2141','328',996077.61,996569.61,0.00,0.00,492.00,373920.00,0.00,0.00,0.00),('1','149','770','257957',4906742,'2142','328',59982.53,59982.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257958',4906743,'2141','328',996569.61,996569.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257958',4906744,'2142','328',59982.53,59982.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257959',4906745,'2141','328',996569.61,997282.20,0.00,0.00,712.59,541568.40,0.00,0.00,0.00),('1','149','770','257959',4906746,'2142','328',59982.53,60012.00,0.00,0.00,29.47,22397.20,0.00,0.00,0.00),('1','149','770','257960',4906747,'2141','328',997282.20,998070.73,0.00,0.00,788.53,599282.80,0.00,0.00,0.00),('1','149','770','257960',4906748,'2142','328',60012.00,60012.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257961',4906749,'2141','328',998070.73,999122.63,0.00,0.00,1051.90,799444.00,0.00,0.00,0.00),('1','149','770','257961',4906750,'2142','328',60012.00,60106.69,0.00,0.00,94.69,71964.40,0.00,0.00,0.00),('1','149','770','257962',4906751,'2141','328',999122.63,999786.54,0.00,0.00,663.91,504571.60,0.00,0.00,0.00),('1','149','770','257962',4906752,'2142','328',60106.69,60262.57,0.00,0.00,155.88,118468.80,0.00,0.00,0.00),('1','149','770','257963',4906753,'2141','328',999786.54,1000756.60,0.00,0.00,970.06,737245.60,0.00,0.00,0.00),('1','149','770','257963',4906754,'2142','328',60262.57,60366.66,0.00,0.00,104.09,79108.40,0.00,0.00,0.00),('1','149','770','257964',4906755,'2141','328',1000756.60,1001467.44,0.00,0.00,710.84,540238.40,0.00,0.00,0.00),('1','149','770','257964',4906756,'2142','328',60366.66,60384.29,0.00,0.00,17.63,13398.80,0.00,0.00,0.00),('1','149','770','257965',4906757,'2141','328',1001467.44,1001467.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257965',4906758,'2142','328',60384.29,60413.99,0.00,0.00,29.70,22572.00,0.00,0.00,0.00),('1','149','770','257966',4906759,'2141','328',1001467.44,1001467.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257966',4906760,'2142','328',60413.99,60413.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257967',4906761,'2141','328',1001467.44,1001652.11,0.00,0.00,184.67,140349.20,0.00,0.00,0.00),('1','149','770','257967',4906762,'2142','328',60413.99,61102.04,0.00,0.00,688.05,522918.00,0.00,0.00,0.00),('1','149','770','257968',4906763,'2141','328',1001652.11,1002612.94,0.00,0.00,960.83,730230.80,0.00,0.00,0.00),('1','149','770','257968',4906764,'2142','328',61102.04,61102.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257969',4906765,'2141','328',1002612.94,1003099.60,0.00,0.00,486.66,369861.60,0.00,0.00,0.00),('1','149','770','257969',4906766,'2142','328',61102.04,61600.88,0.00,0.00,498.84,379118.40,0.00,0.00,0.00),('1','149','770','257970',4906767,'2141','328',1003099.60,1003790.33,0.00,0.00,690.73,524954.80,0.00,0.00,0.00),('1','149','770','257970',4906768,'2142','328',61600.88,61674.73,0.00,0.00,73.85,56126.00,0.00,0.00,0.00),('1','149','770','257971',4906769,'2141','328',1003790.33,1004335.09,0.00,0.00,544.76,414017.60,0.00,0.00,0.00),('1','149','770','257971',4906770,'2142','328',61674.73,61965.12,0.00,0.00,290.39,220696.40,0.00,0.00,0.00),('1','149','770','257972',4906771,'2141','328',1004335.09,1004352.07,0.00,0.00,16.98,12904.80,0.00,0.00,0.00),('1','149','770','257972',4906772,'2142','328',61965.12,62121.43,0.00,0.00,156.31,117002.08,0.00,0.00,0.00),('1','149','770','257973',4906773,'2141','328',1004352.07,1004433.27,0.00,0.00,81.20,59763.20,0.00,0.00,0.00),('1','149','770','257973',4906774,'2142','328',62121.43,62616.36,0.00,0.00,494.93,364268.48,0.00,0.00,0.00),('1','149','770','257974',4906775,'2141','328',1004433.27,1004433.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257974',4906776,'2142','328',62616.36,62616.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257975',4906777,'2141','328',1004433.27,1005314.47,0.00,0.00,881.20,648563.20,0.00,0.00,0.00),('1','149','770','257975',4906778,'2142','328',62616.36,62900.15,0.00,0.00,283.79,208869.44,0.00,0.00,0.00),('1','149','770','257976',4906779,'2141','328',1005314.47,1005882.60,0.00,0.00,568.13,418143.68,0.00,0.00,0.00),('1','149','770','257976',4906780,'2142','328',62900.15,63048.22,0.00,0.00,148.07,108979.52,0.00,0.00,0.00),('1','149','770','257977',4906781,'2141','328',1005882.60,1005948.22,0.00,0.00,65.62,48296.32,0.00,0.00,0.00),('1','149','770','257977',4906782,'2142','328',63048.22,63615.64,0.00,0.00,567.42,417621.12,0.00,0.00,0.00),('1','149','770','257978',4906783,'2141','328',1005948.22,1006501.25,0.00,0.00,553.03,407030.08,0.00,0.00,0.00),('1','149','770','257978',4906784,'2142','328',63615.64,63823.73,0.00,0.00,208.09,153154.24,0.00,0.00,0.00),('1','149','770','257979',4906785,'2141','328',1006501.25,1006661.59,0.00,0.00,160.34,118010.24,0.00,0.00,0.00),('1','149','770','257979',4906786,'2142','328',63823.73,64331.31,0.00,0.00,507.58,373578.88,0.00,0.00,0.00),('1','149','770','257980',4906787,'2141','328',1006661.59,1007135.85,0.00,0.00,474.26,349055.36,0.00,0.00,0.00),('1','149','770','257980',4906788,'2142','328',64331.31,64709.27,0.00,0.00,377.96,278178.56,0.00,0.00,0.00),('1','149','770','257981',4906789,'2141','328',1007135.85,1007257.82,0.00,0.00,121.97,89769.92,0.00,0.00,0.00),('1','149','770','257981',4906790,'2142','328',64709.27,64763.89,0.00,0.00,54.62,40200.32,0.00,0.00,0.00),('1','149','770','257982',4906791,'2141','328',1007257.82,1007257.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257982',4906792,'2142','328',64763.89,64763.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257983',4906793,'2141','328',1007257.82,1007590.98,0.00,0.00,333.16,245205.76,0.00,0.00,0.00),('1','149','770','257983',4906794,'2142','328',64763.89,64769.32,0.00,0.00,5.43,3996.48,0.00,0.00,0.00),('1','149','770','257984',4906795,'2141','328',1007590.98,1008249.05,0.00,0.00,658.07,484339.52,0.00,0.00,0.00),('1','149','770','257984',4906796,'2142','328',64769.32,64769.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257985',4906797,'2141','328',1008249.05,1008959.25,0.00,0.00,710.20,522707.20,0.00,0.00,0.00),('1','149','770','257985',4906798,'2142','328',64769.32,64829.52,0.00,0.00,60.20,44307.20,0.00,0.00,0.00),('1','149','770','257986',4906799,'2141','328',1008959.25,1010069.42,0.00,0.00,1110.17,817085.12,0.00,0.00,0.00),('1','149','770','257986',4906800,'2142','328',64829.52,64886.82,0.00,0.00,57.30,42172.80,0.00,0.00,0.00),('1','149','770','257987',4906801,'2141','328',1010069.42,1010658.51,0.00,0.00,589.09,433570.24,0.00,0.00,0.00),('1','149','770','257987',4906802,'2142','328',64886.82,65379.35,0.00,0.00,492.53,362502.08,0.00,0.00,0.00),('1','149','770','257988',4906803,'2141','328',1010658.51,1011662.51,0.00,0.00,1004.00,738944.00,0.00,0.00,0.00),('1','149','770','257988',4906804,'2142','328',65379.35,65379.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257989',4906805,'2141','328',1011662.51,1011662.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257989',4906806,'2142','328',65379.35,65409.81,0.00,0.00,30.46,22418.56,0.00,0.00,0.00),('1','149','770','257990',4906807,'2141','328',1011662.51,1011662.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257990',4906808,'2142','328',65409.81,65409.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257991',4906809,'2141','328',1011662.51,1012137.41,0.00,0.00,474.90,349526.40,0.00,0.00,0.00),('1','149','770','257991',4906810,'2142','328',65409.81,65461.44,0.00,0.00,51.63,37999.68,0.00,0.00,0.00),('1','149','770','257992',4906811,'2141','328',1012137.41,1013117.69,0.00,0.00,980.28,721486.08,0.00,0.00,0.00),('1','149','770','257992',4906812,'2142','328',65461.44,65461.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257993',4906813,'2141','328',1013117.69,1014194.13,0.00,0.00,1076.44,792259.84,0.00,0.00,0.00),('1','149','770','257993',4906814,'2142','328',65461.44,65699.18,0.00,0.00,237.74,174976.64,0.00,0.00,0.00),('1','149','770','257994',4906815,'2141','328',1014194.13,1015032.36,0.00,0.00,838.23,616937.28,0.00,0.00,0.00),('1','149','770','257994',4906816,'2142','328',65699.18,65699.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257995',4906817,'2141','328',1015032.36,1015173.54,0.00,0.00,141.18,103908.48,0.00,0.00,0.00),('1','149','770','257995',4906818,'2142','328',65699.18,66291.37,0.00,0.00,592.19,435851.84,0.00,0.00,0.00),('1','149','770','257996',4906819,'2141','328',1015173.54,1015399.86,0.00,0.00,226.32,166571.52,0.00,0.00,0.00),('1','149','770','257996',4906820,'2142','328',66291.37,66291.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257997',4906821,'2141','328',1015399.86,1015399.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257997',4906822,'2142','328',66291.37,66291.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','257998',4906823,'2141','328',1015399.86,1015838.73,0.00,0.00,438.87,323008.32,0.00,0.00,0.00),('1','149','770','257998',4906824,'2142','328',66291.37,66293.41,0.00,0.00,2.04,1501.44,0.00,0.00,0.00),('1','149','770','257999',4906825,'2141','328',1015838.73,1016383.26,0.00,0.00,544.53,400774.08,0.00,0.00,0.00),('1','149','770','257999',4906826,'2142','328',66293.41,66378.33,0.00,0.00,84.92,62501.12,0.00,0.00,0.00),('1','149','770','258000',4906827,'2141','328',1016383.26,1016789.74,0.00,0.00,406.48,299169.28,0.00,0.00,0.00),('1','149','770','258000',4906828,'2142','328',66378.33,66581.44,0.00,0.00,203.11,149488.96,0.00,0.00,0.00),('1','149','770','258001',4906829,'2141','328',1016789.74,1017702.34,0.00,0.00,912.60,671673.60,0.00,0.00,0.00),('1','149','770','258001',4906830,'2142','328',66581.44,66583.02,0.00,0.00,1.58,1162.88,0.00,0.00,0.00),('1','149','770','258002',4906831,'2141','328',1017702.34,1018324.28,0.00,0.00,621.94,457747.84,0.00,0.00,0.00),('1','149','770','258002',4906832,'2142','328',66583.02,66776.32,0.00,0.00,193.30,142268.80,0.00,0.00,0.00),('1','149','770','258003',4906833,'2141','328',1018324.28,1019160.18,0.00,0.00,835.90,615222.40,0.00,0.00,0.00),('1','149','770','258003',4906834,'2142','328',66776.32,66813.30,0.00,0.00,36.98,27217.28,0.00,0.00,0.00),('1','149','770','258004',4906835,'2141','328',1019160.18,1019519.94,0.00,0.00,359.76,264783.36,0.00,0.00,0.00),('1','149','770','258004',4906836,'2142','328',66813.30,66881.95,0.00,0.00,68.65,50526.40,0.00,0.00,0.00),('1','149','770','258005',4906837,'2141','328',1019519.94,1019519.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258005',4906838,'2142','328',66881.95,66881.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258006',4906839,'2141','328',1019519.94,1019566.31,0.00,0.00,46.37,34128.32,0.00,0.00,0.00),('1','149','770','258006',4906840,'2142','328',66881.95,67045.44,0.00,0.00,163.49,120328.64,0.00,0.00,0.00),('1','149','770','258007',4906841,'2141','328',1019566.31,1020510.25,0.00,0.00,943.94,694739.84,0.00,0.00,0.00),('1','149','770','258007',4906842,'2142','328',67045.44,67280.26,0.00,0.00,234.82,172827.52,0.00,0.00,0.00),('1','149','770','258008',4906843,'2141','328',1020510.25,1021509.98,0.00,0.00,999.73,735801.28,0.00,0.00,0.00),('1','149','770','258008',4906844,'2142','328',67280.26,67682.61,0.00,0.00,402.35,296129.60,0.00,0.00,0.00),('1','149','770','258009',4906845,'2141','328',1021509.98,1022669.32,0.00,0.00,1159.34,853274.24,0.00,0.00,0.00),('1','149','770','258009',4906846,'2142','328',67682.61,68017.77,0.00,0.00,335.16,246677.76,0.00,0.00,0.00),('1','149','770','258010',4906847,'2141','328',1022669.32,1023085.00,0.00,0.00,415.68,305940.48,0.00,0.00,0.00),('1','149','770','258010',4906848,'2142','328',68017.77,68132.02,0.00,0.00,114.25,84088.00,0.00,0.00,0.00),('1','149','770','258011',4906849,'2141','328',1023085.00,1023085.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258011',4906850,'2142','328',68132.02,68132.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258012',4906851,'2141','328',1023085.00,1024175.87,0.00,0.00,1090.87,802880.32,0.00,0.00,0.00),('1','149','770','258012',4906852,'2142','328',68132.02,68450.64,0.00,0.00,318.62,234504.32,0.00,0.00,0.00),('1','149','770','258013',4906853,'2141','328',1024175.87,1024899.17,0.00,0.00,723.30,532348.80,0.00,0.00,0.00),('1','149','770','258013',4906854,'2142','328',68450.64,68798.45,0.00,0.00,347.81,255988.16,0.00,0.00,0.00),('1','149','770','258014',4906855,'2141','328',1024899.17,1025713.42,0.00,0.00,814.25,599288.00,0.00,0.00,0.00),('1','149','770','258014',4906856,'2142','328',68798.45,69256.50,0.00,0.00,458.05,337124.80,0.00,0.00,0.00),('1','149','770','258015',4906857,'2141','328',1025713.42,1026719.58,0.00,0.00,1006.16,740533.76,0.00,0.00,0.00),('1','149','770','258015',4906858,'2142','328',69256.50,69628.25,0.00,0.00,371.75,273608.00,0.00,0.00,0.00),('1','149','770','258016',4906859,'2141','328',1026719.58,1027047.69,0.00,0.00,328.11,241488.96,0.00,0.00,0.00),('1','149','770','258016',4906860,'2142','328',69628.25,69628.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258017',4906861,'2141','328',1027047.69,1027047.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258017',4906862,'2142','328',69628.25,69628.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258018',4906863,'2141','328',1027047.69,1027420.66,0.00,0.00,372.97,274505.92,0.00,0.00,0.00),('1','149','770','258018',4906864,'2142','328',69628.25,69757.26,0.00,0.00,129.01,94951.36,0.00,0.00,0.00),('1','149','770','258019',4906865,'2141','328',1027420.66,1028272.17,0.00,0.00,851.51,626711.36,0.00,0.00,0.00),('1','149','770','258019',4906866,'2142','328',69757.26,70022.37,0.00,0.00,265.11,195120.96,0.00,0.00,0.00),('1','149','770','258020',4906867,'2141','328',1028272.17,1028930.45,0.00,0.00,658.28,484494.08,0.00,0.00,0.00),('1','149','770','258020',4906868,'2142','328',70022.37,70256.94,0.00,0.00,234.57,172643.52,0.00,0.00,0.00),('1','149','770','258021',4906869,'2141','328',1028930.45,1029631.56,0.00,0.00,701.11,516016.96,0.00,0.00,0.00),('1','149','770','258021',4906870,'2142','328',70256.94,70466.20,0.00,0.00,209.26,154015.36,0.00,0.00,0.00),('1','149','770','258022',4906871,'2141','328',1029631.56,1030283.62,0.00,0.00,652.06,479916.16,0.00,0.00,0.00),('1','149','770','258022',4906872,'2142','328',70466.20,70909.03,0.00,0.00,442.83,325922.88,0.00,0.00,0.00),('1','149','770','258023',4906873,'2141','328',1030283.62,1030740.14,0.00,0.00,456.52,335998.72,0.00,0.00,0.00),('1','149','770','258023',4906874,'2142','328',70909.03,70995.64,0.00,0.00,86.61,63744.96,0.00,0.00,0.00),('1','149','770','258024',4906875,'2141','328',1030740.14,1030740.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258024',4906876,'2142','328',70995.64,70995.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258025',4906877,'2141','328',1030740.14,1031062.03,0.00,0.00,321.89,236911.04,0.00,0.00,0.00),('1','149','770','258025',4906878,'2142','328',70995.64,71155.27,0.00,0.00,159.63,117487.68,0.00,0.00,0.00),('1','149','770','258026',4906879,'2141','328',1031062.03,1031975.60,0.00,0.00,913.57,672387.52,0.00,0.00,0.00),('1','149','770','258026',4906880,'2142','328',71155.27,71401.74,0.00,0.00,246.47,181401.92,0.00,0.00,0.00),('1','149','770','258027',4906881,'2141','328',1031975.60,1032823.50,0.00,0.00,847.90,624054.40,0.00,0.00,0.00),('1','149','770','258027',4906882,'2142','328',71401.74,72047.33,0.00,0.00,645.59,475154.24,0.00,0.00,0.00),('1','149','770','258028',4906883,'2141','328',1032823.50,1033308.82,0.00,0.00,485.32,357195.52,0.00,0.00,0.00),('1','149','770','258028',4906884,'2142','328',72047.33,72251.92,0.00,0.00,204.59,150578.24,0.00,0.00,0.00),('1','149','770','258029',4906885,'2141','328',1033308.82,1034053.18,0.00,0.00,744.36,547848.96,0.00,0.00,0.00),('1','149','770','258029',4906886,'2142','328',72251.92,72487.08,0.00,0.00,235.16,173077.76,0.00,0.00,0.00),('1','149','770','258030',4906887,'2141','328',1034053.18,1034453.05,0.00,0.00,399.87,294304.32,0.00,0.00,0.00),('1','149','770','258030',4906888,'2142','328',72487.08,72487.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258031',4906889,'2141','328',1034453.05,1034453.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258031',4906890,'2142','328',72487.08,72487.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258032',4906891,'2141','328',1034453.05,1034563.06,0.00,0.00,110.01,80967.36,0.00,0.00,0.00),('1','149','770','258032',4906892,'2142','328',72487.08,72734.40,0.00,0.00,247.32,182027.52,0.00,0.00,0.00),('1','149','770','258033',4906893,'2141','328',1034563.06,1035490.84,0.00,0.00,927.78,682846.08,0.00,0.00,0.00),('1','149','770','258033',4906894,'2142','328',72734.40,72820.70,0.00,0.00,86.30,63516.80,0.00,0.00,0.00),('1','149','770','258034',4906895,'2141','328',1035490.84,1036504.64,0.00,0.00,1013.80,746156.80,0.00,0.00,0.00),('1','149','770','258034',4906896,'2142','328',72820.70,72923.62,0.00,0.00,102.92,75749.12,0.00,0.00,0.00),('1','149','770','258035',4906897,'2141','328',1036504.64,1037399.59,0.00,0.00,894.95,658683.20,0.00,0.00,0.00),('1','149','770','258035',4906898,'2142','328',72923.62,73188.32,0.00,0.00,264.70,194819.20,0.00,0.00,0.00),('1','149','770','258036',4906899,'2141','328',1037399.59,1038212.51,0.00,0.00,812.92,598309.12,0.00,0.00,0.00),('1','149','770','258036',4906900,'2142','328',73188.32,73299.31,0.00,0.00,110.99,81688.64,0.00,0.00,0.00),('1','149','770','258037',4906901,'2141','328',1038212.51,1038612.64,0.00,0.00,400.13,294495.68,0.00,0.00,0.00),('1','149','770','258037',4906902,'2142','328',73299.31,73479.97,0.00,0.00,180.66,132965.76,0.00,0.00,0.00),('1','149','770','258038',4906903,'2141','328',1038612.64,1038612.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258038',4906904,'2142','328',73479.97,73479.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258039',4906905,'2141','328',1038612.64,1038668.18,0.00,0.00,55.54,40877.44,0.00,0.00,0.00),('1','149','770','258039',4906906,'2142','328',73479.97,73567.81,0.00,0.00,87.84,64650.24,0.00,0.00,0.00),('1','149','770','258040',4906907,'2141','328',1038668.18,1039257.29,0.00,0.00,589.11,433584.96,0.00,0.00,0.00),('1','149','770','258040',4906908,'2142','328',73567.81,73761.27,0.00,0.00,193.46,142386.56,0.00,0.00,0.00),('1','149','770','258041',4906909,'2141','328',1039257.29,1039653.01,0.00,0.00,395.72,291249.92,0.00,0.00,0.00),('1','149','770','258041',4906910,'2142','328',73761.27,73923.88,0.00,0.00,162.61,119680.96,0.00,0.00,0.00),('1','149','770','258042',4906911,'2141','328',1039653.01,1040481.92,0.00,0.00,828.91,610077.76,0.00,0.00,0.00),('1','149','770','258042',4906912,'2142','328',73923.88,74212.13,0.00,0.00,288.25,212152.00,0.00,0.00,0.00),('1','149','770','258043',4906913,'2141','328',1040481.92,1040948.07,0.00,0.00,466.15,343086.40,0.00,0.00,0.00),('1','149','770','258043',4906914,'2142','328',74212.13,74454.51,0.00,0.00,242.38,178391.68,0.00,0.00,0.00),('1','149','770','258044',4906915,'2141','328',1040948.07,1041655.11,0.00,0.00,707.04,520381.44,0.00,0.00,0.00),('1','149','770','258044',4906916,'2142','328',74454.51,74765.16,0.00,0.00,310.65,228638.40,0.00,0.00,0.00),('1','149','770','258045',4906917,'2141','328',1041655.11,1042167.42,0.00,0.00,512.31,377060.16,0.00,0.00,0.00),('1','149','770','258045',4906918,'2142','328',74765.16,74825.57,0.00,0.00,60.41,44461.76,0.00,0.00,0.00),('1','149','770','258046',4906919,'2141','328',1042167.42,1042188.48,0.00,0.00,21.06,15500.16,0.00,0.00,0.00),('1','149','770','258046',4906920,'2142','328',74825.57,74825.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258047',4906921,'2141','328',1042188.48,1042188.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258047',4906922,'2142','328',74825.57,74825.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258048',4906923,'2141','328',1042188.48,1042384.95,0.00,0.00,196.47,144601.92,0.00,0.00,0.00),('1','149','770','258048',4906924,'2142','328',74825.57,74881.21,0.00,0.00,55.64,40951.04,0.00,0.00,0.00),('1','149','770','258049',4906925,'2141','328',1042384.95,1043154.22,0.00,0.00,769.27,566182.72,0.00,0.00,0.00),('1','149','770','258049',4906926,'2142','328',74881.21,74999.02,0.00,0.00,117.81,86708.16,0.00,0.00,0.00),('1','149','770','258050',4906927,'2141','328',1043154.22,1043822.92,0.00,0.00,668.70,492163.20,0.00,0.00,0.00),('1','149','770','258050',4906928,'2142','328',74999.02,75122.62,0.00,0.00,123.60,90969.60,0.00,0.00,0.00),('1','149','770','258051',4906929,'2141','328',1043822.92,1044681.50,0.00,0.00,858.58,631914.88,0.00,0.00,0.00),('1','149','770','258051',4906930,'2142','328',75122.62,75224.40,0.00,0.00,101.78,74910.08,0.00,0.00,0.00),('1','149','770','258052',4906931,'2141','328',1044681.50,1045310.08,0.00,0.00,628.58,462634.88,0.00,0.00,0.00),('1','149','770','258052',4906932,'2142','328',75224.40,75224.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258053',4906933,'2141','328',1045310.08,1045888.47,0.00,0.00,578.39,425695.04,0.00,0.00,0.00),('1','149','770','258053',4906934,'2142','328',75224.40,75307.71,0.00,0.00,83.31,61316.16,0.00,0.00,0.00),('1','149','770','258054',4906935,'2141','328',1045888.47,1046370.46,0.00,0.00,481.99,354744.64,0.00,0.00,0.00),('1','149','770','258054',4906936,'2142','328',75307.71,75496.73,0.00,0.00,189.02,139118.72,0.00,0.00,0.00),('1','149','770','258055',4906937,'2141','328',1046370.46,1046370.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258055',4906938,'2142','328',75496.73,75496.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258056',4906939,'2141','328',1046370.46,1046721.19,0.00,0.00,350.73,258137.28,0.00,0.00,0.00),('1','149','770','258056',4906940,'2142','328',75496.73,75793.96,0.00,0.00,297.23,218761.28,0.00,0.00,0.00),('1','149','770','258057',4906941,'2141','328',1046721.19,1047243.81,0.00,0.00,522.62,384648.32,0.00,0.00,0.00),('1','149','770','258057',4906942,'2142','328',75793.96,76000.75,0.00,0.00,206.79,152197.44,0.00,0.00,0.00),('1','149','770','258058',4906943,'2141','328',1047243.81,1047624.07,0.00,0.00,380.26,279871.36,0.00,0.00,0.00),('1','149','770','258058',4906944,'2142','328',76000.75,76385.12,0.00,0.00,384.37,282896.32,0.00,0.00,0.00),('1','149','770','258059',4906945,'2141','328',1047624.07,1048171.66,0.00,0.00,547.59,403026.24,0.00,0.00,0.00),('1','149','770','258059',4906946,'2142','328',76385.12,76636.45,0.00,0.00,251.33,184978.88,0.00,0.00,0.00),('1','149','770','258060',4906947,'2141','328',1048171.66,1048833.25,0.00,0.00,661.59,486930.24,0.00,0.00,0.00),('1','149','770','258060',4906948,'2142','328',76636.45,76756.24,0.00,0.00,119.79,88165.44,0.00,0.00,0.00),('1','149','770','258061',4906949,'2141','328',1048833.25,1049386.35,0.00,0.00,553.10,407081.60,0.00,0.00,0.00),('1','149','770','258061',4906950,'2142','328',76756.24,77015.05,0.00,0.00,258.81,190484.16,0.00,0.00,0.00),('1','149','770','258062',4906951,'2141','328',1049386.35,1050094.07,0.00,0.00,707.72,520881.92,0.00,0.00,0.00),('1','149','770','258062',4906952,'2142','328',77015.05,77131.11,0.00,0.00,116.06,85420.16,0.00,0.00,0.00),('1','149','770','258063',4906953,'2141','328',1050094.07,1050263.20,0.00,0.00,169.13,124479.68,0.00,0.00,0.00),('1','149','770','258063',4906954,'2142','328',77131.11,77191.11,0.00,0.00,60.00,44160.00,0.00,0.00,0.00),('1','149','770','258064',4906955,'2141','328',1050263.20,1050325.49,0.00,0.00,62.29,45845.44,0.00,0.00,0.00),('1','149','770','258064',4906956,'2142','328',77191.11,77366.91,0.00,0.00,175.80,129388.80,0.00,0.00,0.00),('1','149','770','258065',4906957,'2141','328',1050325.49,1050973.16,0.00,0.00,647.67,476685.12,0.00,0.00,0.00),('1','149','770','258065',4906958,'2142','328',77366.91,77644.28,0.00,0.00,277.37,204144.32,0.00,0.00,0.00),('1','149','770','258066',4906959,'2141','328',1050973.16,1051918.34,0.00,0.00,945.18,695652.48,0.00,0.00,0.00),('1','149','770','258066',4906960,'2142','328',77644.28,77961.27,0.00,0.00,316.99,233304.64,0.00,0.00,0.00),('1','149','770','258067',4906961,'2141','328',1051918.34,1052525.40,0.00,0.00,607.06,446796.16,0.00,0.00,0.00),('1','149','770','258067',4906962,'2142','328',77961.27,78251.36,0.00,0.00,290.09,213506.24,0.00,0.00,0.00),('1','149','770','258068',4906963,'2141','328',1052525.40,1053240.54,0.00,0.00,715.14,526343.04,0.00,0.00,0.00),('1','149','770','258068',4906964,'2142','328',78251.36,78380.17,0.00,0.00,128.81,94804.16,0.00,0.00,0.00),('1','149','770','258069',4906965,'2141','328',1053240.54,1053689.62,0.00,0.00,449.08,330522.88,0.00,0.00,0.00),('1','149','770','258069',4906966,'2142','328',78380.17,78748.86,0.00,0.00,368.69,271355.84,0.00,0.00,0.00),('1','149','770','258070',4906967,'2141','328',1053689.62,1054185.10,0.00,0.00,495.48,364673.28,0.00,0.00,0.00),('1','149','770','258070',4906968,'2142','328',78748.86,79257.87,0.00,0.00,509.01,374631.36,0.00,0.00,0.00),('1','149','770','258071',4906969,'2141','328',1054185.10,1054708.35,0.00,0.00,523.25,385112.00,0.00,0.00,0.00),('1','149','770','258071',4906970,'2142','328',79257.87,79540.11,0.00,0.00,282.24,207728.64,0.00,0.00,0.00),('1','149','770','258072',4906971,'2141','328',1054708.35,1055586.97,0.00,0.00,878.62,646664.32,0.00,0.00,0.00),('1','149','770','258072',4906972,'2142','328',79540.11,79736.66,0.00,0.00,196.55,144660.80,0.00,0.00,0.00),('1','149','770','258073',4906973,'2141','328',1055586.97,1056205.21,0.00,0.00,618.24,455024.64,0.00,0.00,0.00),('1','149','770','258073',4906974,'2142','328',79736.66,80017.57,0.00,0.00,280.91,206749.76,0.00,0.00,0.00),('1','149','770','258074',4906975,'2141','328',1056205.21,1056644.93,0.00,0.00,439.72,323633.92,0.00,0.00,0.00),('1','149','770','258074',4906976,'2142','328',80017.57,80243.87,0.00,0.00,226.30,166556.80,0.00,0.00,0.00),('1','149','770','258075',4906977,'2141','328',1056644.93,1057169.74,0.00,0.00,524.81,386260.16,0.00,0.00,0.00),('1','149','770','258075',4906978,'2142','328',80243.87,80469.94,0.00,0.00,226.07,166387.52,0.00,0.00,0.00),('1','149','770','258076',4906979,'2141','328',1057169.74,1057304.50,0.00,0.00,134.76,99183.36,0.00,0.00,0.00),('1','149','770','258076',4906980,'2142','328',80469.94,80469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','149','770','258077',4906981,'2141','328',1057304.50,1057577.67,0.00,0.00,273.17,191219.00,0.00,0.00,0.00),('1','149','770','258077',4906982,'2142','328',80469.94,80746.08,0.00,0.00,276.14,193298.00,0.00,0.00,0.00),('1','149','770','258078',4906983,'2141','328',1057577.67,1058218.05,0.00,0.00,640.38,448266.00,0.00,0.00,0.00),('1','149','770','258078',4906984,'2142','328',80746.08,80952.90,0.00,0.00,206.82,144774.00,0.00,0.00,0.00),('1','149','770','258079',4906985,'2141','328',1058218.05,1058711.88,0.00,0.00,493.83,345681.00,0.00,0.00,0.00),('1','149','770','258079',4906986,'2142','328',80952.90,81178.87,0.00,0.00,225.97,158179.00,0.00,0.00,0.00),('1','149','770','258080',4906987,'2141','328',1058711.88,1059312.08,0.00,0.00,600.20,420140.00,0.00,0.00,0.00),('1','149','770','258080',4906988,'2142','328',81178.87,81453.09,0.00,0.00,274.22,191954.00,0.00,0.00,0.00),('1','149','770','258081',4906989,'2141','328',1059312.08,1060107.18,0.00,0.00,795.10,556570.00,0.00,0.00,0.00),('1','149','770','258081',4906990,'2142','328',81453.09,81586.86,0.00,0.00,133.77,93639.00,0.00,0.00,0.00),('1','149','770','258082',4906991,'2141','328',1060107.18,1060626.48,0.00,0.00,519.30,363510.00,0.00,0.00,0.00),('1','149','770','258082',4906992,'2142','328',81586.86,81861.58,0.00,0.00,274.72,192304.00,0.00,0.00,0.00),('1','149','770','258083',4906993,'2141','328',1060626.48,1061196.96,0.00,0.00,570.48,399336.00,0.00,0.00,0.00),('1','149','770','258083',4906994,'2142','328',81861.58,81889.73,0.00,0.00,28.15,19705.00,0.00,0.00,0.00),('1','149','770','258084',4906995,'2141','328',1061196.96,1061604.53,0.00,0.00,407.57,285299.00,0.00,0.00,0.00),('1','149','770','258084',4906996,'2142','328',81889.73,82051.31,0.00,0.00,161.58,113106.00,0.00,0.00,0.00),('1','149','770','258085',4906997,'2141','328',1061604.53,1062196.20,0.00,0.00,591.67,414169.00,0.00,0.00,0.00),('1','149','770','258085',4906998,'2142','328',82051.31,82176.68,0.00,0.00,125.37,87759.00,0.00,0.00,0.00),('1','149','770','258086',4906999,'2141','328',1062196.20,1062854.91,0.00,0.00,658.71,461097.00,0.00,0.00,0.00),('1','149','770','258086',4907000,'2142','328',82176.68,82541.18,0.00,0.00,364.50,255150.00,0.00,0.00,0.00),('1','149','770','258087',4907001,'2141','328',1062854.91,1063881.78,0.00,0.00,1026.87,718809.00,0.00,0.00,0.00),('1','149','770','258087',4907002,'2142','328',82541.18,82728.06,0.00,0.00,186.88,130816.00,0.00,0.00,0.00),('1','149','770','258088',4907003,'2141','328',1063881.78,1064695.23,0.00,0.00,813.45,569415.00,0.00,0.00,0.00),('1','149','770','258088',4907004,'2142','328',82728.06,82834.32,0.00,0.00,106.26,74382.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730446 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','149','146987','328',210.00,280.00,0.00,691.07,145124.70,193499.60,48374.90,441524),('1','149','147009','328',210.00,280.00,0.00,1346.42,282748.20,376997.60,94249.40,441569),('1','149','147018','328',210.00,280.00,0.00,1571.42,329998.20,439997.60,109999.40,441586),('1','149','147034','328',210.00,280.00,0.00,0.00,0.00,0.00,0.00,441619),('1','149','147042','328',210.00,280.00,0.00,1073.57,225449.70,300599.60,75149.90,441636),('1','149','147069','328',210.00,280.00,0.00,0.00,0.00,0.00,0.00,441713),('1','149','147076','328',210.00,280.00,0.00,758.00,159180.00,212240.00,53060.00,441722),('1','149','147095','328',210.00,280.00,0.00,0.00,0.00,0.00,0.00,441749),('1','149','147097','328',210.00,280.00,0.00,1126.78,236623.80,315498.40,78874.60,441751),('1','149','147101','328',210.00,280.00,0.00,0.00,0.00,0.00,0.00,441757),('1','149','147104','328',210.00,280.00,0.00,1252.50,263025.00,350700.00,87675.00,441760),('1','149','147155','328',210.00,280.00,0.00,1519.64,319124.40,425499.20,106374.80,441879),('1','149','147158','328',210.00,280.00,0.00,1674.00,351540.00,468720.00,117180.00,441882),('1','149','147162','328',210.00,280.00,0.00,1551.78,325873.80,434498.40,108624.60,441886),('1','149','147178','328',210.00,280.00,0.00,2073.92,435523.20,580697.60,145174.40,441918),('1','149','147310','328',210.00,280.00,0.00,1021.42,214498.20,285997.60,71499.40,442205),('1','149','147432','328',210.00,280.00,0.00,1033.57,217049.70,289399.60,72349.90,442539),('1','149','147567','328',210.00,280.00,0.00,1091.07,229124.70,305499.60,76374.90,442914),('1','149','147691','328',210.00,280.00,0.00,1464.28,307498.80,409998.40,102499.60,443234),('1','149','147872','328',210.00,280.00,0.00,992.85,208498.50,277998.00,69499.50,443737),('1','149','147994','328',210.00,280.00,0.00,1180.35,247873.50,330498.00,82624.50,444049),('1','149','148134','328',210.00,280.00,0.00,618.39,129861.90,173149.20,43287.30,444423),('1','149','148136','328',222.00,280.00,0.00,287.50,63825.00,80500.00,16675.00,444427),('1','149','148283','328',222.00,280.00,0.00,1164.28,258470.16,325998.40,67528.24,444802),('1','149','148434','328',222.00,280.00,0.00,1196.42,265605.24,334997.60,69392.36,445206),('1','149','148564','328',222.00,280.00,0.00,1762.50,391275.00,493500.00,102225.00,445546),('1','149','148705','328',222.00,280.00,0.00,848.60,188389.20,237608.00,49218.80,445908),('1','149','148813','328',222.00,280.00,0.00,364.28,80870.16,101998.40,21128.24,446179),('1','149','148969','328',222.00,280.00,0.00,1226.78,272345.16,343498.40,71153.24,446593),('1','149','149150','328',222.00,280.00,0.00,960.71,213277.62,268998.80,55721.18,447080),('1','149','149309','328',222.00,280.00,0.00,1401.78,311195.16,392498.40,81303.24,447490),('1','149','149464','328',222.00,280.00,0.00,1275.00,283050.00,357000.00,73950.00,447913),('1','149','149602','328',225.00,280.00,0.00,898.21,202097.25,251498.80,49401.55,448288),('1','149','149694','328',225.00,280.00,0.00,2051.78,461650.50,574498.40,112847.90,448533),('1','149','149860','328',225.00,280.00,0.00,1646.42,370444.50,460997.60,90553.10,448964),('1','149','150013','328',225.00,280.00,0.00,637.50,143437.50,178500.00,35062.50,449380),('1','149','150014','328',225.00,280.00,0.00,1405.35,316203.75,393498.00,77294.25,449381),('1','149','150165','328',225.00,280.00,0.00,1439.28,323838.00,402998.40,79160.40,449785),('1','149','150389','328',225.00,280.00,0.00,1454.39,327237.75,407229.20,79991.45,450353),('1','149','150541','328',225.00,280.00,0.00,1057.14,237856.50,295999.20,58142.70,450781),('1','149','150887','328',225.00,280.00,0.00,2040.00,459000.00,571200.00,112200.00,451671),('1','149','150981','328',225.00,280.00,0.00,1335.71,300534.75,373998.80,73464.05,451932),('1','149','151152','328',225.00,280.00,0.00,1856.25,417656.25,519750.00,102093.75,452396),('1','149','151284','328',225.00,280.00,0.00,1907.14,429106.50,533999.20,104892.70,452755),('1','149','151433','328',225.00,280.00,0.00,1394.64,313794.00,390499.20,76705.20,453158),('1','149','151592','328',225.00,280.00,0.00,1219.64,274419.00,341499.20,67080.20,453594),('1','149','151702','328',225.00,280.00,0.00,1097.32,246897.00,307249.60,60352.60,453897),('1','149','152022','328',225.00,280.00,0.00,1283.42,288769.50,359357.60,70588.10,454746),('1','149','152166','328',225.00,280.00,0.00,1526.78,343525.50,427498.40,83972.90,455120),('1','149','152317','328',225.00,280.00,0.00,1713.00,385425.00,479640.00,94215.00,455530),('1','149','152528','328',225.00,280.00,0.00,1347.00,303075.00,377160.00,74085.00,456100),('1','149','152765','328',225.00,280.00,0.00,731.71,164634.75,204878.80,40244.05,456728),('1','149','152879','328',225.00,280.00,0.00,152.78,34375.50,42778.40,8402.90,457044),('1','149','152880','328',225.00,280.00,0.00,1374.00,309150.00,384720.00,75570.00,457045),('1','149','153102','328',225.00,280.00,0.00,1048.75,235968.75,293650.00,57681.25,457629),('1','149','153263','328',225.00,280.00,0.00,1133.83,255111.75,317472.40,62360.65,458086),('1','149','153464','328',225.00,280.00,0.00,1102.00,247950.00,308560.00,60610.00,458644),('1','149','155132','328',231.00,280.00,0.00,2060.78,476040.18,577018.40,100978.22,463115),('1','149','155296','328',231.00,280.00,0.00,1931.07,446077.17,540699.60,94622.43,463560),('1','149','155478','328',231.00,280.00,0.00,2104.75,486197.25,589330.00,103132.75,464032),('1','149','155761','328',231.00,280.00,0.00,1043.42,241030.02,292157.60,51127.58,464817),('1','149','155917','328',231.00,280.00,0.00,2000.42,462097.02,560117.60,98020.58,465217),('1','149','156070','328',231.00,280.00,0.00,1097.14,253439.34,307199.20,53759.86,465626),('1','149','156292','328',231.00,280.00,0.00,1930.00,445830.00,540400.00,94570.00,466207),('1','149','156553','328',231.00,280.00,0.00,1750.14,404282.34,490039.20,85756.86,466910),('1','149','156725','328',231.00,280.00,0.00,1160.00,267960.00,324800.00,56840.00,467383),('1','149','156892','328',231.00,280.00,0.00,1047.00,241857.00,293160.00,51303.00,467834),('1','149','157070','328',211.00,280.00,0.00,499.46,105386.06,139848.80,34462.74,468309),('1','149','157271','328',211.00,280.00,0.00,1230.17,259565.87,344447.60,84881.73,468818),('1','149','157438','328',211.00,280.00,0.00,1431.92,302135.12,400937.60,98802.48,469248),('1','149','157639','328',211.00,280.00,0.00,1024.64,216199.04,286899.20,70700.16,469772),('1','149','157781','328',211.00,280.00,0.00,1708.00,360388.00,478240.00,117852.00,470152),('1','149','158020','328',231.00,280.00,0.00,432.43,99891.33,121080.40,21189.07,470787),('1','149','158083','328',231.00,280.00,0.00,1294.28,298978.68,362398.40,63419.72,470946),('1','149','158249','328',231.00,280.00,0.00,2030.71,469094.01,568598.80,99504.79,471390),('1','149','158415','328',231.00,280.00,0.00,1571.14,362933.34,439919.20,76985.86,471829),('1','149','158567','328',231.00,280.00,0.00,427.00,98637.00,119560.00,20923.00,472216),('1','149','158569','328',211.00,280.00,0.00,1060.00,223660.00,296800.00,73140.00,472218),('1','149','158741','328',211.00,280.00,0.00,1030.57,217450.27,288559.60,71109.33,472680),('1','149','158930','328',211.00,280.00,0.00,530.28,111889.08,148478.40,36589.32,473166),('1','149','158931','328',211.00,296.00,0.00,781.31,164856.41,231267.76,66411.35,473167),('1','149','159056','328',211.00,296.00,0.00,585.97,123639.67,173447.12,49807.45,473517),('1','149','159449','328',221.00,296.00,0.00,1520.67,336068.07,450118.32,114050.25,474527),('1','149','159632','328',221.00,296.00,0.00,637.83,140960.43,188797.68,47837.25,475017),('1','149','159633','328',221.00,304.00,0.00,1252.26,276749.46,380687.04,103937.58,475018),('1','149','159733','328',221.00,304.00,0.00,2109.00,466089.00,641136.00,175047.00,475258),('1','149','159941','328',221.00,304.00,0.00,1121.18,247780.78,340838.72,93057.94,475802),('1','149','160111','328',221.00,304.00,0.00,1078.19,238279.99,327769.76,89489.77,476243),('1','149','160305','328',221.00,304.00,0.00,1664.68,367894.28,506062.72,138168.44,476746),('1','149','160477','328',221.00,320.00,0.00,1644.37,363405.77,526198.40,162792.63,477192),('1','149','160478','328',221.00,320.00,0.00,0.00,0.00,0.00,0.00,477193),('1','149','160720','328',211.00,320.00,0.00,714.21,150698.31,228547.20,77848.89,477835),('1','149','160740','328',211.00,280.00,0.00,1462.50,308587.50,409500.00,100912.50,477879),('1','149','160883','328',211.00,280.00,0.00,1752.85,369851.35,490798.00,120946.65,478225),('1','149','161098','328',211.00,280.00,0.00,1030.00,217330.00,288400.00,71070.00,478796),('1','149','161291','328',235.00,280.00,0.00,808.60,190021.00,226408.00,36387.00,479281),('1','149','161445','328',235.00,280.00,0.00,893.14,209887.90,250079.20,40191.30,479693),('1','149','161647','328',235.00,280.00,0.00,808.57,190013.95,226399.60,36385.65,480213),('1','149','161846','328',235.00,280.00,0.00,832.60,195661.00,233128.00,37467.00,480704),('1','149','162031','328',235.00,280.00,0.00,1252.10,294243.50,350588.00,56344.50,481203),('1','149','162131','328',235.00,280.00,0.00,694.82,163282.70,194549.60,31266.90,481457),('1','149','162448','328',211.00,0.00,0.00,1073.82,226576.02,300669.60,74093.58,482263),('1','149','162634','328',211.00,280.00,0.00,1163.46,245490.06,325768.80,80278.74,482727),('1','149','162792','328',211.00,280.00,0.00,885.78,186899.58,248018.40,61118.82,483148),('1','149','162993','328',211.00,280.00,0.00,1080.42,227968.62,302517.60,74548.98,483678),('1','149','163278','328',211.00,280.00,0.00,607.00,128077.00,169960.00,41883.00,484396),('1','149','163281','328',211.00,280.00,0.00,371.32,78348.52,103969.60,25621.08,484403),('1','149','163361','328',211.00,280.00,0.00,1051.71,221910.81,294478.80,72567.99,484618),('1','149','163534','328',211.00,280.00,0.00,1479.82,312242.02,414349.60,102107.58,485079),('1','149','163734','328',211.00,280.00,0.00,1491.71,314750.81,417678.80,102927.99,485596),('1','149','163883','328',211.00,280.00,0.00,965.00,203615.00,270200.00,66585.00,485981),('1','149','164074','328',211.00,280.00,0.00,432.50,91257.50,121100.00,29842.50,486483),('1','149','164245','328',211.00,280.00,0.00,1045.71,220644.81,292798.80,72153.99,486936),('1','149','164426','328',211.00,280.00,0.00,973.25,205355.75,272510.00,67154.25,487422),('1','149','164586','328',211.00,280.00,0.00,1513.96,319445.56,423908.80,104463.24,487850),('1','149','164728','328',211.00,280.00,0.00,1554.82,328067.02,435349.60,107282.58,488237),('1','149','164954','328',211.00,280.00,0.00,391.07,82515.77,109499.60,26983.83,488814),('1','149','164955','328',211.00,320.00,0.00,336.28,70955.08,107609.60,36654.52,488815),('1','149','165120','328',211.00,320.00,0.00,1804.09,380662.99,577308.80,196645.81,489233),('1','149','165287','328',211.00,280.00,0.00,1557.92,328721.12,436217.60,107496.48,489669),('1','149','165427','328',211.00,280.00,0.00,521.42,110019.62,145997.60,35977.98,490038),('1','149','165596','328',211.00,280.00,0.00,150.00,31650.00,42000.00,10350.00,490482),('1','149','165790','328',211.00,280.00,0.00,1793.57,378443.27,502199.60,123756.33,491004),('1','149','165919','328',211.00,280.00,0.00,1793.21,378367.31,502098.80,123731.49,491348),('1','149','166130','328',211.00,280.00,0.00,1321.78,278895.58,370098.40,91202.82,491900),('1','149','166306','328',211.00,280.00,0.00,985.46,207932.06,275928.80,67996.74,492366),('1','149','166466','328',211.00,280.00,0.00,1040.00,219440.00,291200.00,71760.00,492806),('1','149','166684','328',211.00,280.00,0.00,1280.82,270253.02,358629.60,88376.58,493388),('1','149','166872','328',211.00,280.00,0.00,1321.75,278889.25,370090.00,91200.75,493898),('1','149','167022','328',211.00,280.00,0.00,297.14,62696.54,83199.20,20502.66,494305),('1','149','167024','328',211.00,280.00,0.00,614.42,129642.62,172037.60,42394.98,494308),('1','149','167169','328',211.00,280.00,0.00,1460.00,308060.00,408800.00,100740.00,494692),('1','149','167352','328',211.00,280.00,0.00,1173.03,247509.33,328448.40,80939.07,495186),('1','149','167557','328',211.00,280.00,0.00,1306.21,275610.31,365738.80,90128.49,495724),('1','149','167727','328',211.00,280.00,0.00,1337.67,282248.37,374547.60,92299.23,496162),('1','149','167910','328',211.00,280.00,0.00,1071.03,225987.33,299888.40,73901.07,496646),('1','149','168102','328',211.00,280.00,0.00,2089.83,440954.13,585152.40,144198.27,497164),('1','149','168280','328',211.00,280.00,0.00,2118.92,447092.12,593297.60,146205.48,497637),('1','149','168399','328',211.00,280.00,0.00,948.89,200215.79,265689.20,65473.41,497956),('1','149','168600','328',211.00,280.00,0.00,2384.39,503106.29,667629.20,164522.91,498479),('1','149','168760','328',211.00,280.00,0.00,1976.78,417100.58,553498.40,136397.82,498917),('1','149','168932','328',211.00,280.00,0.00,1831.42,386429.62,512797.60,126367.98,499360),('1','149','169090','328',211.00,280.00,0.00,2921.42,616419.62,817997.60,201577.98,499771),('1','149','169243','328',211.00,280.00,0.00,289.28,61038.08,80998.40,19960.32,500159),('1','149','169253','328',211.00,280.00,0.00,1120.71,236469.81,313798.80,77328.99,500177),('1','149','169426','328',211.00,280.00,0.00,1115.17,235300.87,312247.60,76946.73,500623),('1','149','169558','328',211.00,280.00,0.00,1398.78,295142.58,391658.40,96515.82,500968),('1','149','169747','328',211.00,280.00,0.00,1375.35,290198.85,385098.00,94899.15,501477),('1','149','169908','328',211.00,280.00,0.00,1130.17,238465.87,316447.60,77981.73,501923),('1','149','170109','328',211.00,280.00,0.00,1253.32,264450.52,350929.60,86479.08,502420),('1','149','170316','328',211.00,280.00,0.00,1734.10,365895.10,485548.00,119652.90,502963),('1','149','170458','328',211.00,280.00,0.00,983.00,207413.00,275240.00,67827.00,503343),('1','149','170641','328',276.00,280.00,0.00,2742.00,756792.00,767760.00,10968.00,503812),('1','149','170804','328',276.00,280.00,0.00,1600.85,441834.60,448238.00,6403.40,504243),('1','149','170909','328',276.00,280.00,0.00,853.00,235428.00,238840.00,3412.00,504519),('1','149','170980','328',276.00,280.00,0.00,695.35,191916.60,194698.00,2781.40,504701),('1','149','171198','328',276.00,280.00,0.00,2436.53,672482.28,682228.40,9746.12,505299),('1','149','171352','328',276.00,280.00,0.00,1787.32,493300.32,500449.60,7149.28,505702),('1','149','171570','328',285.00,280.00,0.00,1286.82,366743.70,360309.60,-6434.10,506290),('1','149','171751','328',285.00,280.00,0.00,1943.78,553977.30,544258.40,-9718.90,506769),('1','149','171982','328',285.00,280.00,0.00,2219.00,632415.00,621320.00,-11095.00,507367),('1','149','172078','328',285.00,280.00,0.00,1083.70,308854.50,303436.00,-5418.50,507621),('1','149','172268','328',285.00,280.00,0.00,1885.71,537427.35,527998.80,-9428.55,508134),('1','149','172484','328',285.00,280.00,0.00,2145.21,611384.85,600658.80,-10726.05,508705),('1','149','172694','328',293.00,280.00,0.00,1640.10,480549.30,459228.00,-21321.30,509256),('1','149','172861','328',293.00,280.00,0.00,2471.07,724023.51,691899.60,-32123.91,509702),('1','149','173036','328',293.00,280.00,0.00,1267.50,371377.50,354900.00,-16477.50,510170),('1','149','173200','328',293.00,280.00,0.00,2769.35,811419.55,775418.00,-36001.55,510600),('1','149','173362','328',293.00,280.00,0.00,2311.07,677143.51,647099.60,-30043.91,511022),('1','149','173661','328',293.00,280.00,0.00,1592.32,466549.76,445849.60,-20700.16,511818),('1','149','173752','328',293.00,280.00,0.00,2945.78,863113.54,824818.40,-38295.14,512064),('1','149','173894','328',293.00,280.00,0.00,1280.39,375154.27,358509.20,-16645.07,512441),('1','149','174117','328',296.00,280.00,0.00,3151.85,932947.60,882518.00,-50429.60,513031),('1','149','174303','328',296.00,280.00,0.00,1828.92,541360.32,512097.60,-29262.72,513512),('1','149','174392','328',296.00,280.00,0.00,0.00,0.00,0.00,0.00,513729),('1','149','174399','328',296.00,280.00,0.00,555.03,164288.88,155408.40,-8880.48,513748),('1','149','174481','328',293.00,280.00,0.00,1434.29,420246.97,401601.20,-18645.77,513965),('1','149','174633','328',293.00,280.00,0.00,2794.89,818902.77,782569.20,-36333.57,514346),('1','149','174814','328',293.00,280.00,0.00,1143.92,335168.56,320297.60,-14870.96,514837),('1','149','174839','328',293.00,280.00,0.00,1021.25,299226.25,285950.00,-13276.25,514896),('1','149','175030','328',293.00,280.00,0.00,3072.50,900242.50,860300.00,-39942.50,515407),('1','149','175144','328',293.00,280.00,0.00,964.00,282452.00,269920.00,-12532.00,515709),('1','149','175231','328',300.00,320.00,0.00,952.87,285861.00,304918.40,19057.40,515938),('1','149','175405','328',300.00,320.00,0.00,2225.68,667704.00,712217.60,44513.60,516389),('1','149','175633','328',300.00,320.00,0.00,2140.84,642252.00,685068.80,42816.80,516977),('1','149','175843','328',300.00,320.00,0.00,1226.46,367938.00,392467.20,24529.20,517540),('1','149','175911','328',300.00,320.00,0.00,2562.46,768738.00,819987.20,51249.20,517717),('1','149','176059','328',300.00,320.00,0.00,2002.87,600861.00,640918.40,40057.40,518081),('1','149','176319','328',290.00,320.00,0.00,3980.46,1154333.40,1273747.20,119413.80,518752),('1','149','176508','328',290.00,320.00,0.00,1908.00,553320.00,610560.00,57240.00,519259),('1','149','176761','328',303.00,320.00,0.00,1660.31,503073.93,531299.20,28225.27,519929),('1','149','176762','328',303.00,336.00,0.00,1731.39,524611.17,581747.04,57135.87,519930),('1','149','176970','328',303.00,336.00,0.00,1883.00,570549.00,632688.00,62139.00,520484),('1','149','177210','328',303.00,336.00,0.00,1913.57,579811.71,642959.52,63147.81,521111),('1','149','177411','328',303.00,336.00,0.00,2037.44,617344.32,684579.84,67235.52,521629),('1','149','177614','328',303.00,336.00,0.00,1670.00,506010.00,561120.00,55110.00,522180),('1','149','177864','328',303.00,336.00,0.00,1438.00,435714.00,483168.00,47454.00,522855),('1','149','178053','328',303.00,336.00,0.00,1547.79,468980.37,520057.44,51077.07,523360),('1','149','178270','328',303.00,336.00,0.00,1698.06,514512.18,570548.16,56035.98,523919),('1','149','178334','328',303.00,336.00,0.00,216.00,65448.00,72576.00,7128.00,524070),('1','149','178463','328',303.00,336.00,0.00,1213.72,367757.16,407809.92,40052.76,524425),('1','149','178695','328',303.00,336.00,0.00,1763.66,534388.98,592589.76,58200.78,525034),('1','149','178871','328',303.00,336.00,0.00,1940.29,587907.87,651937.44,64029.57,525491),('1','149','178987','328',303.00,336.00,0.00,190.77,57803.31,64098.72,6295.41,525776),('1','149','179079','328',308.00,360.00,0.00,930.00,286440.00,312480.00,26040.00,526024),('1','149','179158','328',308.00,336.00,0.00,1490.18,458975.44,500564.80,41589.36,526226),('1','149','179375','328',308.00,336.00,0.00,1712.11,527329.88,570331.84,43001.96,526812),('1','149','179580','328',308.00,336.00,0.00,1340.41,412846.28,450377.76,37531.48,527351),('1','149','179815','328',303.00,336.00,0.00,1533.39,464617.17,518771.04,54153.87,527981),('1','149','180010','328',303.00,336.00,0.00,2610.45,790966.35,875951.20,84984.85,528483),('1','149','180182','328',303.00,33671.00,0.00,1214.43,367972.29,402992.48,35020.19,528942),('1','149','180277','328',303.00,336.00,0.00,572.55,173482.65,193740.80,20258.15,529188),('1','149','180348','328',303.00,336.00,0.00,1865.74,565319.22,618488.64,53169.42,529361),('1','149','180553','328',303.00,336.00,0.00,1483.01,449352.03,499255.36,49903.33,529911),('1','149','180749','328',303.00,336.00,0.00,1510.93,457811.79,507672.48,49860.69,530415),('1','149','180983','328',303.00,336.00,0.00,304.36,92221.08,102264.96,10043.88,531050),('1','149','180999','328',233.00,336.00,0.00,1129.17,263096.61,380065.12,116968.51,531088),('1','149','181145','328',233.00,336.00,0.00,1783.15,415473.95,594098.40,178624.45,531466),('1','149','181348','328',233.00,336.00,0.00,1894.70,441465.10,638011.52,196546.42,532022),('1','149','181535','328',233.00,336.00,0.00,517.27,120523.91,173802.72,53278.81,532505),('1','149','181584','328',303.00,336.00,0.00,1033.03,313008.09,347098.08,34089.99,532636),('1','149','181727','328',328.00,336.00,0.00,1656.48,543325.44,556551.96,13226.52,533004),('1','149','181946','328',328.00,336.00,0.00,2057.66,674912.48,691373.76,16461.28,533614),('1','149','182122','328',328.00,336.00,0.00,366.36,120166.08,123096.96,2930.88,534072),('1','149','182153','328',233.00,336.00,0.00,1850.67,431206.11,623189.12,191983.01,534162),('1','149','182322','328',233.00,336.00,0.00,2328.82,542615.06,784147.52,241532.46,534581),('1','149','182511','328',233.00,336.00,0.00,1012.78,235977.74,340294.08,104316.34,535092),('1','149','182616','328',323.00,336.00,0.00,0.00,0.00,0.00,0.00,535384),('1','149','182627','328',323.00,336.00,0.00,483.51,107822.73,162459.36,54636.63,535414),('1','149','183104','328',223.00,336.00,0.00,2124.80,473830.40,713932.80,240102.40,536691),('1','149','183113','328',223.00,336.00,0.00,1412.55,314998.65,474616.80,159618.15,536710),('1','149','183117','328',223.00,336.00,0.00,1235.69,275558.87,415191.84,139632.97,536719),('1','149','183238','328',223.00,336.00,0.00,109.00,24307.00,36624.00,12317.00,537023),('1','149','183289','328',328.00,336.00,0.00,1138.76,373513.28,382623.36,9110.08,537153),('1','149','183465','328',328.00,336.00,0.00,1483.68,486647.04,498516.48,11869.44,537609),('1','149','183679','328',328.00,336.00,0.00,1428.88,468672.64,480103.68,11431.04,538180),('1','149','183918','328',328.00,336.00,0.00,977.31,320557.68,328376.16,7818.48,538821),('1','149','184076','328',328.00,336.00,0.00,238.08,78090.24,79994.88,1904.64,539244),('1','149','184132','328',328.00,336.00,0.00,829.56,272095.68,278732.16,6636.48,539388),('1','149','184298','328',328.00,336.00,0.00,1801.05,590744.40,605152.80,14408.40,539826),('1','149','184472','328',328.00,336.00,0.00,2007.85,658574.80,674637.60,16062.80,540270),('1','149','184700','328',328.00,336.00,0.00,891.56,292431.68,299564.16,7132.48,540891),('1','149','185221','328',313.00,336.00,0.00,584.71,183014.23,196462.56,13448.33,542253),('1','149','185267','328',313.00,336.00,0.00,1644.32,514672.16,552491.52,37819.36,542350),('1','149','185493','328',313.00,336.00,0.00,1891.84,592145.92,635658.24,43512.32,542949),('1','149','185691','328',313.00,336.00,0.00,1590.29,497760.77,534337.44,36576.67,543479),('1','149','185918','328',313.00,336.00,0.00,209.38,65535.94,70351.68,4815.74,544088),('1','149','185946','328',313.00,336.00,0.00,1064.52,342358.86,357678.72,15319.86,544164),('1','149','186097','328',323.00,336.00,0.00,1634.48,527937.04,549185.28,21248.24,544560),('1','149','186331','328',323.00,336.00,0.00,2236.94,722531.62,751611.84,29080.22,545170),('1','149','186547','328',323.00,336.00,0.00,533.15,172207.45,179138.40,6930.95,545741),('1','149','186639','328',323.00,336.00,0.00,993.88,321023.24,333943.68,12920.44,545997),('1','149','186776','328',323.00,336.00,0.00,1628.15,525892.45,547058.40,21165.95,546330),('1','149','187003','328',323.00,336.00,0.00,1451.87,468954.01,487828.32,18874.31,546900),('1','149','187164','328',323.00,336.00,0.00,1555.00,502265.00,522480.00,20215.00,547338),('1','149','187470','328',323.00,336.00,0.00,1567.14,504770.28,526559.04,21788.76,548150),('1','149','187673','328',322.00,336.00,0.00,1874.43,603566.46,629808.48,26242.02,548686),('1','149','187873','328',322.00,336.00,0.00,1979.24,637315.28,665024.64,27709.36,549206),('1','149','188052','328',322.00,336.00,0.00,1522.60,491717.05,511593.60,19876.55,549664),('1','149','188284','328',323.00,336.00,0.00,2628.82,849108.86,883283.52,34174.66,550277),('1','149','188432','328',323.00,336.00,0.00,863.36,278865.28,290088.96,11223.68,550656),('1','149','188662','328',323.00,336.00,0.00,2046.90,661148.70,687758.40,26609.70,551240),('1','149','188842','328',323.00,336.00,0.00,1794.14,579507.22,602831.04,23323.82,551717),('1','149','189066','328',223.00,360.00,0.00,1516.59,338199.57,545972.40,207772.83,552313),('1','149','189213','328',223.00,360.00,0.00,1859.60,573653.80,669456.00,95802.20,552691),('1','149','189458','328',323.00,360.00,0.00,1375.61,444322.03,495219.60,50897.57,553334),('1','149','189692','328',323.00,360.00,0.00,1387.86,448278.78,499629.60,51350.82,553937),('1','149','189873','328',323.00,360.00,0.00,500.61,161697.03,180219.60,18522.57,554404),('1','149','189881','328',323.00,360.00,0.00,948.26,306287.98,341373.60,35085.62,554421),('1','149','190079','328',323.00,360.00,0.00,1733.20,559823.60,623952.00,64128.40,554947),('1','149','190254','328',323.00,360.00,0.00,2361.18,762661.14,850024.80,87363.66,555400),('1','149','190504','328',323.00,360.00,0.00,415.58,134232.34,149608.80,15376.46,556061),('1','149','190536','328',323.00,360.00,0.00,1513.17,488753.91,544741.20,55987.29,556153),('1','149','190683','328',323.00,360.00,0.00,1864.54,602246.42,671234.40,68987.98,556530),('1','149','190908','328',323.00,360.00,0.00,1323.04,427341.92,476294.40,48952.48,557124),('1','149','191179','328',323.00,360.00,0.00,1125.24,363452.52,405086.40,41633.88,557846),('1','149','191284','328',323.00,360.00,0.00,1668.43,538902.89,600634.80,61731.91,558124),('1','149','191491','328',323.00,360.00,0.00,1835.08,592730.84,660628.80,67897.96,558672),('1','149','191701','328',323.00,360.00,0.00,549.63,177530.49,197866.80,20336.31,559232),('1','149','191877','328',323.00,360.00,0.00,514.94,166325.62,185378.40,19052.78,559707),('1','149','191960','328',323.00,360.00,0.00,1272.58,411043.34,458128.80,47085.46,559908),('1','149','192202','328',323.00,360.00,0.00,1381.40,446192.20,497304.00,51111.80,560555),('1','149','192348','328',323.00,360.00,0.00,1501.26,484906.98,540453.60,55546.62,560931),('1','149','192568','328',323.00,360.00,0.00,446.59,144248.57,160772.40,16523.83,561507),('1','149','192671','328',323.00,360.00,0.00,1111.45,358998.35,400122.00,41123.65,561779),('1','149','192750','328',323.00,360.00,0.00,1267.24,409318.52,456206.40,46887.88,561993),('1','149','193006','328',323.00,360.00,0.00,1493.58,482426.34,537688.80,55262.46,562648),('1','149','193274','328',323.00,360.00,0.00,1361.57,439787.11,490165.20,50378.09,563375),('1','149','193447','328',323.00,360.00,0.00,1126.11,363733.53,405399.60,41666.07,563813),('1','149','193615','328',323.00,360.00,0.00,1770.83,571978.09,637498.80,65520.71,564270),('1','149','193853','328',323.00,360.00,0.00,1460.47,471731.81,525769.20,54037.39,564847),('1','149','194200','328',323.00,360.00,0.00,807.00,260661.00,290520.00,29859.00,565734),('1','149','194610','328',323.00,360.00,0.00,655.78,211816.94,236080.80,24263.86,566782),('1','149','194619','328',323.00,360.00,0.00,2455.35,793078.05,883926.00,90847.95,566806),('1','149','194684','328',323.00,360.00,0.00,1712.52,553143.96,616507.20,63363.24,566957),('1','149','194754','328',323.00,360.00,0.00,363.00,117249.00,130680.00,13431.00,567149),('1','149','194865','328',323.00,360.00,0.00,1203.64,388775.72,433310.40,44534.68,567454),('1','149','194912','328',323.00,360.00,0.00,1550.06,500669.38,558021.60,57352.22,567570),('1','149','195173','328',323.00,360.00,0.00,1509.99,487726.77,543596.40,55869.63,568252),('1','149','195428','328',323.00,360.00,0.00,773.00,249679.00,278280.00,28601.00,568899),('1','149','195439','328',323.00,360.00,0.00,669.36,216203.28,240969.60,24766.32,568929),('1','149','195526','328',323.00,360.00,0.00,1275.48,411980.04,459172.80,47192.76,569155),('1','149','195845','328',323.00,360.00,0.00,1641.83,530311.09,591058.80,60747.71,569934),('1','149','196040','328',323.00,360.00,0.00,1375.66,444338.18,495237.60,50899.42,570448),('1','149','196227','328',323.00,360.00,0.00,580.57,187514.13,209005.20,21491.07,570913),('1','149','196395','328',321.00,360.00,0.00,1120.70,359744.70,403452.00,43707.30,571355),('1','149','196486','328',321.00,360.00,0.00,1583.25,508223.25,569970.00,61746.75,571577),('1','149','196766','328',321.00,360.00,0.00,1886.59,605595.39,679172.40,73577.01,572309),('1','149','196900','328',321.00,360.00,0.00,497.87,159816.27,179233.20,19416.93,572657),('1','149','197127','328',321.00,360.00,0.00,815.97,261926.37,293749.20,31822.83,573246),('1','149','197400','328',323.00,360.00,0.00,294.86,95239.78,106149.60,10909.82,573891),('1','149','197403','328',323.00,360.00,0.00,669.00,216087.00,240840.00,24753.00,573898),('1','149','197407','328',323.00,360.00,0.00,1573.72,508311.56,566539.20,58227.64,573906),('1','149','198026','328',323.00,360.00,0.00,1880.56,607420.88,677001.60,69580.72,575523),('1','149','198028','328',323.00,360.00,0.00,741.48,239498.04,266932.80,27434.76,575527),('1','149','198102','328',323.00,360.00,0.00,1374.88,444086.24,494956.80,50870.56,575721),('1','149','198193','328',323.00,360.00,0.00,1191.06,384712.38,428781.60,44069.22,575943),('1','149','198396','328',323.00,360.00,0.00,1359.44,439099.12,489398.40,50299.28,576463),('1','149','198809','328',323.00,360.00,0.00,1343.16,420229.16,483537.60,63308.44,577505),('1','149','198896','328',307.00,360.00,0.00,1311.08,402501.56,471988.80,69487.24,577746),('1','149','199007','328',307.00,360.00,0.00,1601.54,491672.78,576554.40,84881.62,578029),('1','149','199326','328',307.00,360.00,0.00,1406.33,431743.31,506278.80,74535.49,578811),('1','149','199609','328',307.00,360.00,0.00,1260.47,386964.29,453769.20,66804.91,579547),('1','149','199780','328',307.00,360.00,0.00,345.00,105915.00,124200.00,18285.00,579933),('1','149','199794','328',323.00,360.00,0.00,1395.60,450778.80,502416.00,51637.20,579972),('1','149','199881','328',323.00,360.00,0.00,2208.84,713455.32,795182.40,81727.08,580188),('1','149','200247','328',323.00,360.00,0.00,1546.04,500369.92,556574.40,56204.48,581163),('1','149','200456','328',307.00,360.00,0.00,849.61,260830.27,305859.60,45029.33,581704),('1','149','200577','328',307.00,360.00,0.00,1850.04,567962.28,666014.40,98052.12,582010),('1','149','200780','328',307.00,360.00,0.00,1396.17,428624.19,502621.20,73997.01,582539),('1','149','200954','328',307.00,360.00,0.00,1825.74,560502.18,657266.40,96764.22,582962),('1','149','201232','328',307.00,360.00,0.00,1545.11,474348.77,556239.60,81890.83,583691),('1','149','201407','328',307.00,360.00,0.00,1657.91,508978.37,596847.60,87869.23,584145),('1','149','201549','328',307.00,360.00,0.00,1599.51,491049.57,575823.60,84774.03,584503),('1','149','201786','328',307.00,360.00,0.00,1100.23,337770.61,396082.80,58312.19,585137),('1','149','201944','328',323.00,360.00,0.00,901.87,291304.01,324673.20,33369.19,585572),('1','149','202050','328',323.00,360.00,0.00,2108.87,681165.01,759193.20,78028.19,585835),('1','149','202275','328',323.00,360.00,0.00,2168.03,700273.69,780490.80,80217.11,586409),('1','149','202533','328',323.00,360.00,0.00,1519.25,490717.75,546930.00,56212.25,587083),('1','149','202664','328',323.00,360.00,0.00,1440.85,465394.55,518706.00,53311.45,587405),('1','149','202881','328',323.00,360.00,0.00,1413.94,456702.62,509018.40,52315.78,587958),('1','149','203146','328',323.00,360.00,0.00,1389.36,448763.28,500169.60,51406.32,588652),('1','149','203412','328',323.00,360.00,0.00,1113.68,359718.64,400924.80,41206.16,589355),('1','149','203561','328',323.00,360.00,0.00,1650.19,533011.37,594068.40,61057.03,589723),('1','149','203736','328',0.00,376.00,0.00,1566.33,505924.59,588940.08,83015.49,590182),('1','149','204129','328',323.00,376.00,0.00,879.55,284094.65,330710.80,46616.15,591212),('1','149','204277','328',314.00,376.00,0.00,2816.68,884437.52,1059071.68,174634.16,591579),('1','149','204583','328',314.00,376.00,0.00,1802.50,565985.00,677740.00,111755.00,592383),('1','149','204778','328',314.00,376.00,0.00,1249.34,392292.76,469751.84,77459.08,592883),('1','149','205018','328',322.00,376.00,0.00,1065.29,343023.38,400549.04,57525.66,593462),('1','149','205207','328',322.00,376.00,0.00,1451.60,467415.20,545801.60,78386.40,593960),('1','149','205448','328',322.00,376.00,0.00,1360.90,438209.80,511698.40,73488.60,594573),('1','149','205675','328',322.00,376.00,0.00,1064.76,342852.72,400349.76,57497.04,595166),('1','149','205926','328',312.00,376.00,0.00,845.16,263689.92,317780.16,54090.24,595816),('1','149','206124','328',312.00,376.00,0.00,1454.57,453825.84,546918.32,93092.48,596319),('1','149','206173','328',312.00,376.00,0.00,1319.41,411655.92,496098.16,84442.24,596428),('1','149','206552','328',312.00,376.00,0.00,1534.41,478735.92,576938.16,98202.24,597412),('1','149','206667','328',312.00,376.00,0.00,697.34,217570.08,262199.84,44629.76,597694),('1','149','206693','328',318.00,376.00,0.00,566.85,180258.30,213135.60,32877.30,597768),('1','149','206830','328',318.00,376.00,0.00,1439.74,457837.32,541342.24,83504.92,598109),('1','149','207043','328',318.00,376.00,0.00,1133.21,360360.78,426086.96,65726.18,598661),('1','149','207303','328',318.00,376.00,0.00,1568.33,498728.94,589692.08,90963.14,599339),('1','149','207518','328',318.00,376.00,0.00,1162.86,369789.48,437235.36,67445.88,599892),('1','149','207678','328',318.00,376.00,0.00,533.91,169783.38,200750.16,30966.78,600304),('1','149','207779','328',318.00,384.00,0.00,1582.47,503225.46,607668.48,104443.02,600548),('1','149','207931','328',318.00,384.00,0.00,1901.65,604724.70,730233.60,125508.90,600940),('1','149','208142','328',318.00,384.00,0.00,1863.11,592468.98,715434.24,122965.26,601480),('1','149','208522','328',322.00,384.00,0.00,1012.32,325967.04,388730.88,62763.84,602467),('1','149','208594','328',322.00,384.00,0.00,1594.21,513335.62,612176.64,98841.02,602638),('1','149','208861','328',322.00,384.00,0.00,2655.41,855042.02,1019677.44,164635.42,603313),('1','149','209052','328',322.00,384.00,0.00,949.41,305710.02,364573.44,58863.42,603800),('1','149','209283','328',322.00,384.00,0.00,1523.49,490563.78,585020.16,94456.38,604398),('1','149','209487','328',322.00,384.00,0.00,1551.13,499463.86,595633.92,96170.06,604918),('1','149','209680','328',322.00,384.00,0.00,1086.19,349753.18,417096.96,67343.78,605412),('1','149','209984','328',322.00,384.00,0.00,1536.07,494614.54,589850.88,95236.34,606201),('1','149','210105','328',322.00,384.00,0.00,1439.74,463596.28,552860.16,89263.88,606522),('1','149','210337','328',322.00,384.00,0.00,1276.60,411065.20,490214.40,79149.20,607112),('1','149','210528','328',322.00,384.00,0.00,575.00,185150.00,220800.00,35650.00,607619),('1','149','210797','328',345.00,400.00,0.00,591.00,203895.00,236400.00,32505.00,608329),('1','149','210801','328',345.00,400.00,0.00,1402.70,483931.50,561080.00,77148.50,608338),('1','149','211005','328',345.00,400.00,0.00,3246.23,1119949.35,1298492.00,178542.65,608850),('1','149','211334','328',345.00,400.00,0.00,1582.63,546007.35,633052.00,87044.65,609720),('1','149','211681','328',345.00,400.00,0.00,1754.00,605130.00,701600.00,96470.00,610602),('1','149','211939','328',345.00,400.00,0.00,705.13,243269.85,282052.00,38782.15,611278),('1','149','211943','328',345.00,400.00,0.00,1210.38,417581.10,484152.00,66570.90,611288),('1','149','212179','328',345.00,400.00,0.00,1200.75,414258.75,480300.00,66041.25,611914),('1','149','212377','328',345.00,400.00,0.00,2332.65,804764.25,933060.00,128295.75,612420),('1','149','212492','328',345.00,400.00,0.00,1592.00,549240.00,636800.00,87560.00,612720),('1','149','212816','328',345.00,400.00,0.00,1069.50,368977.50,427800.00,58822.50,613588),('1','149','212909','328',345.00,400.00,0.00,2528.85,872453.25,1011540.00,139086.75,613811),('1','149','213280','328',345.00,400.00,0.00,1700.88,586803.60,680352.00,93548.40,614779),('1','149','213510','328',345.00,400.00,0.00,2425.05,836642.25,1008820.80,172178.55,615383),('1','149','213841','328',345.00,416.00,0.00,1137.52,392444.40,473208.32,80763.92,616265),('1','149','213964','328',345.00,416.00,0.00,1551.28,535191.60,645332.48,110140.88,616579),('1','149','214431','328',386.00,416.00,0.00,1112.79,429536.94,462920.64,33383.70,617790),('1','149','214472','328',386.00,416.00,0.00,1898.75,732917.50,789880.00,56962.50,617904),('1','149','214745','328',386.00,416.00,0.00,1625.05,627269.30,676020.80,48751.50,618614),('1','149','215072','328',386.00,416.00,0.00,1124.64,434111.04,467850.24,33739.20,619462),('1','149','215179','328',386.00,416.00,0.00,954.01,368247.86,396868.16,28620.30,619737),('1','149','215271','328',386.00,424.00,0.00,1345.75,519459.50,570598.00,51138.50,619962),('1','149','215460','328',386.00,424.00,0.00,971.91,375157.26,412089.84,36932.58,620436),('1','149','216020','328',386.00,424.00,0.00,1668.54,644056.44,707460.96,63404.52,621900),('1','149','216024','328',396.00,424.00,0.00,866.16,342999.36,367251.84,24252.48,621910),('1','149','216133','328',396.00,424.00,0.00,1922.18,761183.28,815004.32,53821.04,622178),('1','149','216345','328',396.00,428.00,0.00,1348.97,534192.12,577359.16,43167.04,622729),('1','149','216604','328',396.00,428.00,0.00,816.39,323290.44,349414.92,26124.48,623418),('1','149','217034','328',396.00,428.00,0.00,575.83,233786.98,246455.24,12668.26,624545),('1','149','217037','328',406.00,472.00,0.00,1660.72,674844.07,783859.84,109015.77,624552),('1','149','217299','328',431.00,472.00,0.00,1393.76,600710.56,657854.72,57144.16,625242),('1','149','217519','328',431.00,472.00,0.00,1505.34,648801.54,710520.48,61718.94,625818),('1','149','217882','328',431.00,472.00,0.00,845.52,364419.12,399085.44,34666.32,626778),('1','149','218013','328',431.00,472.00,0.00,1305.69,562752.39,616285.68,53533.29,627111),('1','149','218254','328',431.00,472.00,0.00,1489.22,641853.82,702911.84,61058.02,627745),('1','149','218456','328',431.00,472.00,0.00,908.15,391412.65,428646.80,37234.15,628277),('1','149','218688','328',431.00,472.00,0.00,856.33,369078.23,404187.76,35109.53,628881),('1','149','218969','328',431.00,472.00,0.00,1271.98,548223.38,600374.56,52151.18,629614),('1','149','219210','328',431.00,472.00,0.00,1063.47,458355.57,501957.84,43602.27,630253),('1','149','219362','328',431.00,472.00,0.00,738.28,318198.68,348468.16,30269.48,630639),('1','149','219690','328',431.00,472.00,0.00,1225.26,528087.06,578322.72,50235.66,631508),('1','149','219847','328',431.00,472.00,0.00,917.47,395429.57,433045.84,37616.27,631912),('1','149','220209','328',431.00,472.00,0.00,1460.75,629583.25,642730.00,13146.75,632897),('1','149','220249','328',431.00,440.00,0.00,2193.54,945415.74,965157.60,19741.86,632986),('1','149','220502','328',431.00,440.00,0.00,1801.88,776610.28,792827.20,16216.92,633647),('1','149','220764','328',431.00,440.00,0.00,1145.49,493706.19,504015.60,10309.41,634326),('1','149','220917','328',431.00,440.00,0.00,2250.33,969892.23,990145.20,20252.97,634727),('1','149','221143','328',431.00,440.00,0.00,1529.31,659132.61,672896.40,13763.79,635313),('1','149','221388','328',431.00,440.00,0.00,621.61,267913.91,273508.40,5594.49,635958),('1','149','221532','328',431.00,440.00,0.00,740.11,318987.41,325648.40,6660.99,636335),('1','149','221630','328',431.00,440.00,0.00,1387.21,597887.51,610372.40,12484.89,636583),('1','149','221844','328',431.00,440.00,0.00,1447.44,623846.64,636873.60,13026.96,637137),('1','149','222137','328',431.00,440.00,0.00,1337.71,576553.01,588592.40,12039.39,637899),('1','149','222318','328',431.00,440.00,0.00,790.31,340623.61,347736.40,7112.79,638361),('1','149','222407','328',436.00,440.00,0.00,722.22,314887.92,317776.80,2888.88,638597),('1','149','222499','328',436.00,440.00,0.00,2100.80,915948.80,924352.00,8403.20,638824),('1','149','222757','328',436.00,440.00,0.00,1500.99,654431.64,660435.60,6003.96,639507),('1','149','222969','328',436.00,440.00,0.00,1016.00,442976.00,447040.00,4064.00,640086),('1','149','223274','328',436.00,440.00,0.00,827.76,360903.36,364214.40,3311.04,640839),('1','149','223427','328',436.00,440.00,0.00,1126.89,491324.04,540907.20,49583.16,641228),('1','149','223662','328',436.00,488.00,0.00,1449.07,631794.52,707146.16,75351.64,641824),('1','149','223909','328',436.00,488.00,0.00,1582.87,690131.32,772440.56,82309.24,642460),('1','149','224144','328',459.00,488.00,0.00,986.55,452826.45,481436.40,28609.95,643074),('1','149','224308','328',459.00,508.00,0.00,880.62,404204.58,447354.96,43150.38,643505),('1','149','224529','328',459.00,508.00,0.00,1312.26,602327.34,666628.08,64300.74,644093),('1','149','224784','328',459.00,508.00,0.00,2050.82,941326.38,1041816.56,100490.18,644733),('1','149','225085','328',459.00,508.00,0.00,361.04,165717.36,183408.32,17690.96,645512),('1','149','225220','328',459.00,508.00,0.00,927.13,425552.67,470982.04,45429.37,645877),('1','149','225319','328',459.00,508.00,0.00,1161.54,533146.86,590062.32,56915.46,646104),('1','149','225658','328',459.00,508.00,0.00,973.95,447043.05,494766.60,47723.55,647004),('1','149','225934','328',459.00,508.00,0.00,1215.08,557721.72,617260.64,59538.92,647739),('1','149','226187','328',459.00,508.00,0.00,1613.67,740674.53,839108.40,98433.87,648384),('1','149','226357','328',475.00,520.00,0.00,1882.19,894040.25,978738.80,84698.55,648820),('1','149','226692','328',475.00,520.00,0.00,1321.50,627712.50,687180.00,59467.50,649688),('1','149','226923','328',475.00,520.00,0.00,1060.85,503903.75,551642.00,47738.25,650290),('1','149','227151','328',475.00,520.00,0.00,901.00,427975.00,468520.00,40545.00,650879),('1','149','227425','328',486.00,520.00,0.00,719.60,349725.60,374192.00,24466.40,651569),('1','149','227472','328',486.00,520.00,0.00,1089.10,529302.60,566332.00,37029.40,651691),('1','149','227669','328',486.00,520.00,0.00,1630.67,792505.62,847948.40,55442.78,652197),('1','149','227905','328',486.00,520.00,0.00,1761.02,855855.72,915730.40,59874.68,652810),('1','149','228283','328',486.00,520.00,0.00,242.27,117743.22,125980.40,8237.18,653829),('1','149','228288','328',486.00,520.00,0.00,1553.90,755195.40,808028.00,52832.60,653842),('1','149','228411','328',486.00,560.00,0.00,1394.86,677901.96,781121.60,103219.64,654131),('1','149','228604','328',486.00,560.00,0.00,1555.81,756123.66,871253.60,115129.94,654618),('1','149','228787','328',486.00,560.00,0.00,521.98,253682.28,292308.80,38626.52,655087),('1','149','228888','328',486.00,560.00,0.00,1440.21,699942.06,806517.60,106575.54,655354),('1','149','229211','328',486.00,560.00,0.00,2749.80,1336402.80,1539888.00,203485.20,656187),('1','149','229377','328',486.00,560.00,0.00,487.04,236701.44,272742.40,36040.96,656637),('1','149','229383','328',486.00,560.00,0.00,1604.41,779743.26,898469.60,118726.34,656651),('1','149','229476','328',486.00,586.00,0.00,2631.45,1278884.70,1536766.80,257882.10,656874),('1','149','229722','328',486.00,584.00,0.00,1253.89,609390.54,732271.76,122881.22,657505),('1','149','229928','328',526.00,584.00,0.00,2275.36,1196839.36,1328810.24,131970.88,658033),('1','149','230138','328',526.00,584.00,0.00,2304.28,1212051.28,1345699.52,133648.24,658573),('1','149','230324','328',526.00,584.00,0.00,932.74,493066.52,544720.16,51653.64,659054),('1','149','230424','328',526.00,584.00,0.00,967.69,509004.94,565130.96,56126.02,659330),('1','149','230554','328',526.00,584.00,0.00,2158.98,1135623.48,1260844.32,125220.84,659646),('1','149','230789','328',526.00,584.00,0.00,1559.40,820244.40,910689.60,90445.20,660260),('1','149','231077','328',526.00,584.00,0.00,432.08,227274.08,252334.72,25060.64,661023),('1','149','231343','328',526.00,584.00,0.00,172.19,90571.94,100558.96,9987.02,661759),('1','149','231386','328',526.00,584.00,0.00,1473.63,775129.38,860599.92,85470.54,661852),('1','149','231641','328',526.00,584.00,0.00,1148.04,603869.04,670455.36,66586.32,662520),('1','149','231901','328',526.00,584.00,0.00,1267.67,666794.42,740319.28,73524.86,663231),('1','149','232103','328',526.00,584.00,0.00,1014.42,533584.92,592421.28,58836.36,663766),('1','149','232336','328',526.00,584.00,0.00,1157.29,608734.54,675857.36,67122.82,664361),('1','149','232586','328',223.00,600.00,0.00,1319.11,294161.53,791466.00,497304.47,665033),('1','149','232861','328',223.00,600.00,0.00,1885.85,420544.55,1131510.00,710965.45,665753),('1','149','233124','328',223.00,600.00,0.00,1593.36,437914.05,956016.00,518101.95,666431),('1','149','233490','328',570.00,624.00,0.00,1728.05,984988.50,1078303.20,93314.70,667408),('1','149','233639','328',570.00,624.00,0.00,1495.02,852161.40,932892.48,80731.08,667777),('1','149','233849','328',570.00,624.00,0.00,1267.05,722218.50,790639.20,68420.70,668339),('1','149','234056','328',570.00,624.00,0.00,987.26,562738.20,616050.24,53312.04,668889),('1','149','234482','328',570.00,624.00,0.00,999.13,569504.10,623457.12,53953.02,670030),('1','149','234646','328',570.00,624.00,0.00,967.76,551623.20,603882.24,52259.04,670448),('1','149','234834','328',570.00,624.00,0.00,1409.22,803255.40,879353.28,76097.88,670946),('1','149','235126','328',570.00,624.00,0.00,1044.71,639510.36,651899.04,12388.68,671731),('1','149','235371','328',624.00,624.00,0.00,618.51,385950.24,385950.24,0.00,672366),('1','149','235645','328',570.00,624.00,0.00,1075.45,613006.50,671080.80,58074.30,673074),('1','149','235780','328',570.00,624.00,0.00,1484.63,846239.10,949623.84,103384.74,673416),('1','149','236023','328',570.00,640.00,0.00,1536.20,875634.00,983168.00,107534.00,674065),('1','149','236243','328',570.00,640.00,0.00,1244.77,709518.90,796652.80,87133.90,674646),('1','149','236673','328',592.00,640.00,0.00,448.10,265275.20,286784.00,21508.80,675782),('1','149','236742','328',592.00,640.00,0.00,1143.75,677100.00,732000.00,54900.00,675947),('1','149','236968','328',592.00,640.00,0.00,1526.74,903830.08,977113.60,73283.52,676535),('1','149','237185','328',592.00,640.00,0.00,1137.17,673204.64,727788.80,54584.16,677081),('1','149','237387','328',592.00,640.00,0.00,1139.37,674507.04,729196.80,54689.76,677606),('1','149','237666','328',592.00,656.00,0.00,969.85,574151.20,636221.60,62070.40,678329),('1','149','237870','328',592.00,656.00,0.00,1337.77,791959.84,857063.04,65103.20,678875),('1','149','238125','328',592.00,640.00,0.00,2161.66,1279702.72,1383462.40,103759.68,679532),('1','149','238365','328',592.00,640.00,0.00,1188.25,703444.00,760480.00,57036.00,680138),('1','149','238546','328',602.00,640.00,0.00,266.04,160156.08,170265.60,10109.52,680636),('1','149','238608','328',602.00,640.00,0.00,1516.44,912896.88,970521.60,57624.72,680783),('1','149','238856','328',602.00,640.00,0.00,1522.76,916701.52,974566.40,57864.88,681419),('1','149','239068','328',602.00,640.00,0.00,1395.83,840289.66,893331.20,53041.54,681967),('1','149','239291','328',602.00,640.00,0.00,436.65,262863.30,279456.00,16592.70,682558),('1','149','239439','328',602.00,640.00,0.00,306.51,184519.02,196166.40,11647.38,682949),('1','149','239534','328',602.00,640.00,0.00,1142.08,687532.16,730931.20,43399.04,683188),('1','149','239781','328',602.00,640.00,0.00,984.49,592662.98,630073.60,37410.62,683828),('1','149','239997','328',602.00,640.00,0.00,967.69,582549.38,619321.60,36772.22,684388),('1','149','240219','328',602.00,640.00,0.00,1221.32,735234.64,781644.80,46410.16,684955),('1','149','240456','328',602.00,640.00,0.00,788.48,474664.96,504627.20,29962.24,685584),('1','149','240596','328',602.00,640.00,0.00,134.38,80896.76,86003.20,5106.44,685952),('1','149','240712','328',602.00,640.00,0.00,1203.85,724717.70,770464.00,45746.30,686198),('1','149','240975','328',602.00,640.00,0.00,1335.30,803850.60,854592.00,50741.40,686913),('1','149','241228','328',602.00,640.00,0.00,1138.92,685629.84,728908.80,43278.96,687572),('1','149','241488','328',602.00,640.00,0.00,983.60,592127.20,629504.00,37376.80,688269),('1','149','241736','328',602.00,640.00,0.00,456.80,274993.60,292352.00,17358.40,688921),('1','149','241897','328',602.00,640.00,0.00,578.71,348383.42,370374.40,21990.98,689348),('1','149','242033','328',602.00,640.00,0.00,1017.09,612288.18,650937.60,38649.42,689688),('1','149','242210','328',602.00,640.00,0.00,984.42,592620.84,630028.80,37407.96,690156),('1','149','242435','328',602.00,640.00,0.00,1148.50,691397.00,735040.00,43643.00,690726),('1','149','242682','328',602.00,640.00,0.00,1356.39,816546.78,868089.60,51542.82,691371),('1','149','242964','328',602.00,640.00,0.00,1165.19,701444.38,745721.60,44277.22,692102),('1','149','243139','328',602.00,640.00,0.00,1438.67,866079.34,920748.80,54669.46,692573),('1','149','243369','328',602.00,640.00,0.00,1144.66,689085.32,732582.40,43497.08,693184),('1','149','243603','328',602.00,640.00,0.00,1571.90,946283.80,1006016.00,59732.20,693779),('1','149','243851','328',592.00,640.00,0.00,1672.78,990285.76,1070579.20,80293.44,694418),('1','149','244054','328',592.00,640.00,0.00,1884.00,1115328.00,1205760.00,90432.00,694935),('1','149','244291','328',592.00,640.00,0.00,1731.22,1024882.24,1107980.80,83098.56,695568),('1','149','244522','328',592.00,640.00,0.00,1363.15,806984.80,872416.00,65431.20,696157),('1','149','244774','328',592.00,640.00,0.00,1125.87,666515.04,720556.80,54041.76,696814),('1','149','244978','328',592.00,632.00,0.00,1073.36,635429.12,678363.52,42934.40,697353),('1','149','245305','328',592.00,632.00,0.00,397.43,235278.56,251175.76,15897.20,698182),('1','149','245362','328',592.00,632.00,0.00,337.66,199894.72,213401.12,13506.40,698339),('1','149','245436','328',592.00,632.00,0.00,1392.63,824436.96,880142.16,55705.20,698530),('1','149','245728','328',592.00,632.00,0.00,1023.11,605681.12,646605.52,40924.40,699268),('1','149','245956','328',592.00,616.00,0.00,1358.49,804226.08,836829.84,32603.76,699879),('1','149','246233','328',592.00,616.00,0.00,1528.80,905049.60,941740.80,36691.20,700581),('1','149','246526','328',558.00,616.00,0.00,857.95,478736.10,528497.20,49761.10,701360),('1','149','246706','328',558.00,616.00,0.00,1105.15,616673.70,680772.40,64098.70,701841),('1','149','246939','328',558.00,616.00,0.00,1524.66,850760.28,939190.56,88430.28,702436),('1','149','247184','328',558.00,616.00,0.00,1782.60,994690.80,1098081.60,103390.80,703067),('1','149','247485','328',558.00,616.00,0.00,661.05,368865.90,407206.80,38340.90,703829),('1','149','247678','328',558.00,616.00,0.00,1231.50,687177.00,735975.36,48798.36,704345),('1','149','247911','328',558.00,592.00,0.00,1166.45,650879.10,690538.40,39659.30,704951),('1','149','248169','328',558.00,592.00,0.00,1420.49,792633.42,840930.08,48296.66,705610),('1','149','248408','328',558.00,592.00,0.00,682.66,380924.28,404134.72,23210.44,706235),('1','149','248579','328',558.00,592.00,0.00,469.68,262081.44,278050.56,15969.12,706676),('1','149','248642','328',558.00,592.00,0.00,917.75,512104.50,543308.00,31203.50,706833),('1','149','248922','328',558.00,592.00,0.00,833.32,464992.56,493325.44,28332.88,707542),('1','149','249133','328',558.00,592.00,0.00,947.90,528928.20,561156.80,32228.60,708080),('1','149','249376','328',558.00,592.00,0.00,1251.19,698164.02,740704.48,42540.46,708695),('1','149','249701','328',510.00,592.00,0.00,767.92,391639.20,454608.64,62969.44,709544),('1','149','249863','328',510.00,592.00,0.00,1008.63,514401.30,597108.96,82707.66,709956),('1','149','250120','328',510.00,592.00,0.00,1626.65,829591.50,962976.80,133385.30,710608),('1','149','250352','328',510.00,592.00,0.00,761.10,388161.00,450571.20,62410.20,711203),('1','149','250428','328',510.00,592.00,0.00,583.45,297559.50,345402.40,47842.90,711382),('1','149','250580','328',510.00,592.00,0.00,2011.49,1025859.90,1190802.08,164942.18,711775),('1','149','250800','328',510.00,592.00,0.00,1984.12,1011901.20,1174599.04,162697.84,712366),('1','149','251028','328',510.00,592.00,0.00,660.93,337074.30,391270.56,54196.26,712949),('1','149','251129','328',510.00,592.00,0.00,867.30,442323.00,513441.60,71118.60,713202),('1','149','251280','328',510.00,592.00,0.00,1976.52,1008025.20,1170099.84,162074.64,713600),('1','149','251530','328',510.00,592.00,0.00,1490.03,759915.30,882097.76,122182.46,714255),('1','149','251773','328',510.00,592.00,0.00,840.96,428889.60,497848.32,68958.72,714892),('1','149','252003','328',510.00,592.00,0.00,1633.61,833141.10,967097.12,133956.02,715498),('1','149','252253','328',510.00,592.00,0.00,1455.92,742519.20,861904.64,119385.44,716149),('1','149','252476','328',510.00,592.00,0.00,1140.19,581496.90,674992.48,93495.58,716734),('1','149','252730','328',510.00,592.00,0.00,1143.71,583292.10,677076.32,93784.22,717386),('1','149','252969','328',510.00,592.00,0.00,1521.39,775908.90,900662.88,124753.98,718012),('1','149','253229','328',510.00,592.00,0.00,1195.64,609776.40,707818.88,98042.48,718681),('1','149','253522','328',510.00,592.00,0.00,1276.52,651025.20,755699.84,104674.64,719435),('1','149','253722','328',510.00,592.00,0.00,942.37,480608.70,557883.04,77274.34,719960),('1','149','254145','328',510.00,592.00,0.00,462.84,236048.40,274001.28,37952.88,721082),('1','149','254205','328',510.00,592.00,0.00,1270.20,647802.00,751958.40,104156.40,721218),('1','149','254455','328',510.00,592.00,0.00,1256.68,640906.80,743954.56,103047.76,721870),('1','149','254711','328',510.00,592.00,0.00,1116.05,569185.50,660701.60,91516.10,722512),('1','149','254960','328',510.00,592.00,0.00,1279.12,652351.20,757239.04,104887.84,723148),('1','149','255289','328',510.00,592.00,0.00,712.67,363461.70,421900.64,58438.94,723987),('1','149','255463','328',510.00,592.00,0.00,1106.84,564488.40,655249.28,90760.88,724428),('1','149','255726','328',510.00,592.00,0.00,962.14,490691.40,569586.88,78895.48,725075),('1','149','255958','328',510.00,592.00,0.00,1102.89,562473.90,652910.88,90436.98,725662),('1','149','256219','328',510.00,592.00,0.00,1058.72,539947.20,618458.72,78511.52,726300),('1','149','256521','328',510.00,584.00,0.00,919.30,468843.00,536871.20,68028.20,727084),('1','149','256734','328',510.00,584.00,0.00,984.58,502135.80,574994.72,72858.92,727638),('1','149','256971','328',510.00,584.00,0.00,1441.76,735297.60,841987.84,106690.24,728264),('1','149','257299','328',510.00,584.00,0.00,1292.85,659353.50,755024.40,95670.90,729110),('1','149','257497','328',510.00,584.00,0.00,465.99,237654.90,264682.32,27027.42,729641),('1','149','257631','328',510.00,568.00,0.00,499.19,254586.90,283539.92,28953.02,729988),('1','149','257632','328',510.00,568.00,0.00,968.92,494149.20,550346.56,56197.36,729989),('1','149','257633','328',510.00,568.00,0.00,1571.08,801250.80,892373.44,91122.64,729990),('1','149','257634','328',510.00,568.00,0.00,1264.09,644685.90,718003.12,73317.22,729991),('1','149','257635','328',510.00,568.00,0.00,922.80,470628.00,524150.40,53522.40,729992),('1','149','257636','328',500.00,568.00,0.00,1242.07,621035.00,705495.76,84460.76,729993),('1','149','257637','328',500.00,568.00,0.00,1690.60,845300.00,960260.80,114960.80,729994),('1','149','257638','328',500.00,568.00,0.00,1738.70,869350.00,987581.60,118231.60,729995),('1','149','257639','328',500.00,568.00,0.00,1106.98,553490.00,628764.64,75274.64,729996),('1','149','257640','328',500.00,568.00,0.00,387.54,193770.00,220122.72,26352.72,729997),('1','149','257641','328',500.00,568.00,0.00,2189.71,1094855.00,1243755.28,148900.28,729998),('1','149','257642','328',500.00,568.00,0.00,1089.19,544595.00,618659.92,74064.92,729999),('1','149','257643','328',500.00,568.00,0.00,1110.30,555150.00,630650.40,75500.40,730000),('1','149','257644','328',500.00,568.00,0.00,1101.50,550750.00,625652.00,74902.00,730001),('1','149','257645','328',500.00,568.00,0.00,1210.70,605350.00,687677.60,82327.60,730002),('1','149','257646','328',500.00,568.00,0.00,1073.69,536845.00,609855.92,73010.92,730003),('1','149','257647','328',500.00,568.00,0.00,1035.10,517550.00,587936.80,70386.80,730004),('1','149','257648','328',500.00,568.00,0.00,531.26,265630.00,301755.68,36125.68,730005),('1','149','257649','328',500.00,568.00,0.00,499.34,249670.00,283625.12,33955.12,730006),('1','149','257650','328',500.00,568.00,0.00,773.24,386620.00,439200.32,52580.32,730007),('1','149','257651','328',500.00,568.00,0.00,788.00,394000.00,447584.00,53584.00,730008),('1','149','257652','328',500.00,568.00,0.00,941.02,470510.00,534499.36,63989.36,730009),('1','149','257653','328',500.00,568.00,0.00,933.22,466610.00,530068.96,63458.96,730010),('1','149','257654','328',500.00,568.00,0.00,804.81,402405.00,457132.08,54727.08,730011),('1','149','257655','328',500.00,568.00,0.00,334.38,167190.00,189927.84,22737.84,730012),('1','149','257656','328',500.00,568.00,0.00,193.20,96600.00,109737.60,13137.60,730013),('1','149','257657','328',500.00,568.00,0.00,878.30,439150.00,498874.40,59724.40,730014),('1','149','257658','328',500.00,568.00,0.00,788.69,394345.00,447975.92,53630.92,730015),('1','149','257659','328',500.00,568.00,0.00,887.54,443770.00,504122.72,60352.72,730016),('1','149','257660','328',500.00,568.00,0.00,933.45,466725.00,530199.60,63474.60,730017),('1','149','257661','328',500.00,568.00,0.00,1151.44,575720.00,654017.92,78297.92,730018),('1','149','257662','328',500.00,568.00,0.00,879.20,439600.00,499385.60,59785.60,730019),('1','149','257663','328',500.00,568.00,0.00,512.45,256225.00,291071.60,34846.60,730020),('1','149','257664','328',500.00,568.00,0.00,711.02,355510.00,403859.36,48349.36,730021),('1','149','257665','328',500.00,568.00,0.00,868.00,442141.50,502793.80,60652.30,730022),('1','149','257666','328',510.00,580.00,0.00,748.37,381668.70,434054.60,52385.90,730023),('1','149','257667','328',510.00,580.00,0.00,858.85,438013.50,498133.00,60119.50,730024),('1','149','257668','328',510.00,580.00,0.00,410.82,209518.20,238695.60,29177.40,730025),('1','149','257669','328',532.00,580.00,0.00,539.03,286763.96,312637.40,25873.44,730026),('1','149','257670','328',532.00,580.00,0.00,1480.84,787806.88,858887.20,71080.32,730027),('1','149','257671','328',532.00,580.00,0.00,1182.72,629207.04,685977.60,56770.56,730028),('1','149','257672','328',532.00,640.00,0.00,672.80,357929.60,430592.00,72662.40,730029),('1','149','257673','328',532.00,640.00,0.00,729.61,388152.52,466950.40,78797.88,730030),('1','149','257674','328',532.00,640.00,0.00,841.60,447731.20,538624.00,90892.80,730031),('1','149','257675','328',532.00,640.00,0.00,576.52,306708.64,368972.80,62264.16,730032),('1','149','257676','328',532.00,640.00,0.00,94.98,50529.36,60787.20,10257.84,730033),('1','149','257677','328',532.00,640.00,0.00,817.74,435037.68,523353.60,88315.92,730034),('1','149','257678','328',532.00,640.00,0.00,1323.35,704022.20,846944.00,142921.80,730035),('1','149','257679','328',532.00,680.00,0.00,1380.10,734213.20,938468.00,204254.80,730036),('1','149','257680','328',532.00,680.00,0.00,1131.35,601878.20,769318.00,167439.80,730037),('1','149','257681','328',532.00,680.00,0.00,1000.12,532063.84,680081.60,148017.76,730038),('1','149','257682','328',532.00,680.00,0.00,53.66,28547.12,36488.80,7941.68,730039),('1','149','257683','328',532.00,680.00,0.00,659.90,382317.00,448732.00,66415.00,730040),('1','149','257684','328',606.00,680.00,0.00,744.13,450942.78,506008.40,55065.62,730041),('1','149','257685','328',606.00,680.00,0.00,882.14,534576.84,599855.20,65278.36,730042),('1','149','257686','328',606.00,680.00,0.00,708.66,429447.96,481888.80,52440.84,730043),('1','149','257687','328',606.00,680.00,0.00,600.78,364072.68,408530.40,44457.72,730044),('1','149','257688','328',606.00,680.00,0.00,243.37,147482.22,165491.60,18009.38,730045),('1','149','257689','328',606.00,680.00,0.00,360.05,218190.30,244834.00,26643.70,730046),('1','149','257690','328',606.00,680.00,0.00,906.65,544809.42,616522.00,71712.58,730047),('1','149','257691','328',598.00,680.00,0.00,700.28,418767.44,476190.40,57422.96,730048),('1','149','257692','328',598.00,680.00,0.00,892.77,533876.46,607083.60,73207.14,730049),('1','149','257693','328',598.00,680.00,0.00,79.58,47588.84,54114.40,6525.56,730050),('1','149','257694','328',598.00,688.00,0.00,749.13,447979.74,515401.44,67421.70,730051),('1','149','257695','328',598.00,688.00,0.00,887.55,530754.90,610634.40,79879.50,730052),('1','149','257696','328',598.00,688.00,0.00,817.03,488583.94,562116.64,73532.70,730053),('1','149','257697','328',598.00,688.00,0.00,1148.03,686521.94,789844.64,103322.70,730054),('1','149','257698','328',617.00,664.00,0.00,783.54,483444.18,520270.56,36826.38,730055),('1','149','257699','328',617.00,664.00,0.00,1568.44,967727.48,1041444.16,73716.68,730056),('1','149','257700','328',617.00,664.00,0.00,738.78,455827.26,490549.92,34722.66,730057),('1','149','257701','328',617.00,664.00,0.00,722.54,445807.18,479766.56,33959.38,730058),('1','149','257702','328',617.00,664.00,0.00,1645.17,1010709.39,1092392.88,81683.49,730059),('1','149','257703','328',602.00,664.00,0.00,1750.14,1053584.28,1141162.96,87578.68,730060),('1','149','257704','328',602.00,664.00,0.00,1263.21,779400.57,830157.44,50756.87,730061),('1','149','257705','328',617.00,664.00,0.00,1036.80,639705.60,677566.16,37860.56,730062),('1','149','257706','328',617.00,664.00,0.00,1162.06,716131.07,764527.84,48396.77,730063),('1','149','257707','328',602.00,664.00,0.00,930.82,560353.64,618064.48,57710.84,730064),('1','149','257708','328',602.00,664.00,0.00,1358.40,817756.80,896992.10,79235.30,730065),('1','149','257709','328',602.00,664.00,0.00,254.33,153106.66,168875.12,15768.46,730066),('1','149','257710','328',602.00,664.00,0.00,722.62,435017.24,479819.68,44802.44,730067),('1','149','257711','328',602.00,664.00,0.00,730.92,440013.84,485330.88,45317.04,730068),('1','149','257712','328',602.00,664.00,0.00,1182.63,711943.26,785266.32,73323.06,730069),('1','149','257713','328',602.00,664.00,0.00,1144.36,688904.72,759855.04,70950.32,730070),('1','149','257714','328',602.00,664.00,0.00,943.19,567800.38,626278.16,58477.78,730071),('1','149','257715','328',602.00,664.00,0.00,318.07,191478.14,211198.48,19720.34,730072),('1','149','257716','328',602.00,664.00,0.00,897.95,540565.90,596238.80,55672.90,730073),('1','149','257717','328',602.00,664.00,0.00,785.50,472871.00,521572.00,48701.00,730074),('1','149','257718','328',602.00,664.00,0.00,891.11,536448.22,591697.04,55248.82,730075),('1','149','257719','328',602.00,664.00,0.00,1000.25,602150.50,664166.00,62015.50,730076),('1','149','257720','328',602.00,664.00,0.00,750.22,451632.44,498146.08,46513.64,730077),('1','149','257721','328',602.00,664.00,0.00,690.18,415488.36,458279.52,42791.16,730078),('1','149','257722','328',602.00,664.00,0.00,597.09,359448.18,383667.76,24219.58,730079),('1','149','257723','328',602.00,664.00,0.00,1344.26,809244.52,882688.64,73444.12,730080),('1','149','257724','328',602.00,664.00,0.00,810.77,481525.54,538351.28,56825.74,730081),('1','149','257725','328',592.00,664.00,0.00,826.57,489329.44,548842.48,59513.04,730082),('1','149','257726','328',592.00,664.00,0.00,802.51,475085.92,532866.64,57780.72,730083),('1','149','257727','328',592.00,664.00,0.00,514.84,304785.28,341853.76,37068.48,730084),('1','149','257728','328',592.00,664.00,0.00,1202.38,711808.96,798380.32,86571.36,730085),('1','149','257729','328',592.00,664.00,0.00,1335.78,790781.76,886957.92,96176.16,730086),('1','149','257730','328',592.00,664.00,0.00,2282.01,1350949.92,1506476.64,155526.72,730087),('1','149','257731','328',592.00,664.00,0.00,1055.30,624737.60,700719.20,75981.60,730088),('1','149','257732','328',592.00,664.00,0.00,818.90,484788.80,543749.60,58960.80,730089),('1','149','257733','328',592.00,664.00,0.00,1478.26,875129.92,961764.64,86634.72,730090),('1','149','257734','328',592.00,664.00,0.00,1153.26,682729.92,765764.64,83034.72,730091),('1','149','257735','328',592.00,664.00,0.00,1468.96,869624.32,965489.44,95865.12,730092),('1','149','257736','328',592.00,664.00,0.00,248.95,147378.40,165302.80,17924.40,730093),('1','149','257737','328',592.00,680.00,0.00,614.41,363730.72,417798.80,54068.08,730094),('1','149','257738','328',592.00,680.00,0.00,772.54,457343.68,525327.20,67983.52,730095),('1','149','257739','328',592.00,680.00,0.00,1148.09,679669.28,780701.20,101031.92,730096),('1','149','257740','328',592.00,680.00,0.00,979.74,580006.08,666223.20,86217.12,730097),('1','149','257741','328',592.00,680.00,0.00,854.06,505603.52,580760.80,75157.28,730098),('1','149','257742','328',592.00,680.00,0.00,115.92,68624.64,78825.60,10200.96,730099),('1','149','257743','328',592.00,680.00,0.00,741.70,439086.40,504356.00,65269.60,730100),('1','149','257744','328',592.00,680.00,0.00,332.95,197106.40,227314.40,30208.00,730101),('1','149','257745','328',592.00,720.00,0.00,907.57,537281.44,653450.40,116168.96,730102),('1','149','257746','328',662.00,720.00,0.00,1539.72,1019294.64,1108598.40,89303.76,730103),('1','149','257747','328',662.00,720.00,0.00,24.59,16278.58,17704.80,1426.22,730104),('1','149','257748','328',662.00,720.00,0.00,191.86,127011.32,138139.20,11127.88,730105),('1','149','257749','328',662.00,720.00,0.00,545.48,361107.76,392745.60,31637.84,730106),('1','149','257750','328',662.00,720.00,0.00,1018.49,674240.38,733312.80,59072.42,730107),('1','149','257751','328',662.00,720.00,0.00,1135.99,752025.38,817912.80,65887.42,730108),('1','149','257752','328',662.00,720.00,0.00,1179.10,780564.20,891316.00,110751.80,730109),('1','149','257753','328',662.00,760.00,0.00,1084.07,717654.34,823893.20,106238.86,730110),('1','149','257754','328',662.00,760.00,0.00,237.97,157536.14,180857.20,23321.06,730111),('1','149','257755','328',662.00,760.00,0.00,954.90,632143.80,725724.00,93580.20,730112),('1','149','257756','328',662.00,760.00,0.00,1284.86,850577.32,976493.60,125916.28,730113),('1','149','257757','328',662.00,760.00,0.00,887.88,587776.56,674788.80,87012.24,730114),('1','149','257758','328',682.00,760.00,0.00,836.88,570752.16,636028.80,65276.64,730115),('1','149','257759','328',682.00,760.00,0.00,536.55,365927.10,407778.00,41850.90,730116),('1','149','257760','328',682.00,760.00,0.00,865.24,590093.68,657582.40,67488.72,730117),('1','149','257761','328',682.00,760.00,0.00,83.86,57192.52,63733.60,6541.08,730118),('1','149','257762','328',682.00,760.00,0.00,670.80,457485.60,509808.00,52322.40,730119),('1','149','257763','328',682.00,760.00,0.00,671.91,458242.62,510651.60,52408.98,730120),('1','149','257764','328',682.00,760.00,0.00,766.19,522541.58,582304.40,59762.82,730121),('1','149','257765','328',682.00,760.00,0.00,773.14,527281.48,587586.40,60304.92,730122),('1','149','257766','328',682.00,760.00,0.00,958.06,653396.92,728125.60,74728.68,730123),('1','149','257767','328',682.00,760.00,0.00,886.67,604708.94,673869.20,69160.26,730124),('1','149','257768','328',682.00,760.00,0.00,20.47,13960.54,15557.20,1596.66,730125),('1','149','257769','328',682.00,760.00,0.00,751.85,512761.70,571406.00,58644.30,730126),('1','149','257770','328',682.00,760.00,0.00,905.70,617687.40,688332.00,70644.60,730127),('1','149','257771','328',682.00,760.00,0.00,732.93,499858.26,557026.80,57168.54,730128),('1','149','257772','328',682.00,760.00,0.00,807.69,550844.58,613844.40,62999.82,730129),('1','149','257773','328',682.00,760.00,0.00,1196.31,815883.42,909195.60,93312.18,730130),('1','149','257774','328',682.00,760.00,0.00,668.08,455630.56,507740.80,52110.24,730131),('1','149','257775','328',682.00,760.00,0.00,681.92,465069.44,518259.20,53189.76,730132),('1','149','257776','328',682.00,760.00,0.00,29.61,20194.02,22503.60,2309.58,730133),('1','149','257777','328',682.00,760.00,0.00,770.35,525378.70,585466.00,60087.30,730134),('1','149','257778','328',682.00,760.00,0.00,822.07,560651.74,624773.20,64121.46,730135),('1','149','257779','328',682.00,760.00,0.00,911.16,621411.12,692481.60,71070.48,730136),('1','149','257780','328',682.00,760.00,0.00,799.37,545170.34,607521.20,62350.86,730137),('1','149','257781','328',682.00,760.00,0.00,723.11,493161.02,549563.60,56402.58,730138),('1','149','257782','328',682.00,760.00,0.00,870.48,593667.36,661564.80,67897.44,730139),('1','149','257783','328',682.00,760.00,0.00,178.72,121887.04,135827.20,13940.16,730140),('1','149','257784','328',682.00,760.00,0.00,1012.71,690668.22,769659.60,78991.38,730141),('1','149','257785','328',682.00,760.00,0.00,1090.93,744014.26,829106.80,85092.54,730142),('1','149','257786','328',682.00,760.00,0.00,1561.08,1064656.56,1186420.80,121764.24,730143),('1','149','257787','328',682.00,760.00,0.00,1069.29,729255.78,812660.40,83404.62,730144),('1','149','257788','328',682.00,760.00,0.00,523.02,356699.64,397495.20,40795.56,730145),('1','149','257789','328',682.00,760.00,0.00,369.07,251705.74,280493.20,28787.46,730146),('1','149','257790','328',682.00,760.00,0.00,1055.35,719748.70,802066.00,82317.30,730147),('1','149','257791','328',682.00,760.00,0.00,1387.15,946036.30,1054234.00,108197.70,730148),('1','149','257792','328',682.00,760.00,0.00,753.81,514098.42,572895.60,58797.18,730149),('1','149','257793','328',682.00,760.00,0.00,612.48,417711.36,465484.80,47773.44,730150),('1','149','257794','328',682.00,760.00,0.00,866.06,590652.92,658205.60,67552.68,730151),('1','149','257795','328',682.00,760.00,0.00,947.56,646235.92,720145.60,73909.68,730152),('1','149','257796','328',682.00,760.00,0.00,389.11,265373.02,295723.60,30350.58,730153),('1','149','257797','328',682.00,760.00,0.00,377.44,257414.08,286854.40,29440.32,730154),('1','149','257798','328',682.00,760.00,0.00,1352.17,922179.94,1027649.20,105469.26,730155),('1','149','257799','328',682.00,760.00,0.00,1333.99,909781.18,1013832.40,104051.22,730156),('1','149','257800','328',682.00,760.00,0.00,720.49,491374.18,547572.40,56198.22,730157),('1','149','257801','328',682.00,760.00,0.00,707.63,482603.66,537798.80,55195.14,730158),('1','149','257802','328',682.00,760.00,0.00,668.40,455848.80,507984.00,52135.20,730159),('1','149','257803','328',682.00,760.00,0.00,875.31,596961.42,665235.60,68274.18,730160),('1','149','257804','328',682.00,760.00,0.00,1680.52,1146114.64,1266923.20,120808.56,730161),('1','149','257805','328',682.00,760.00,0.00,1534.36,1046433.52,1127953.60,81520.08,730162),('1','149','257806','328',682.00,760.00,0.00,1267.23,864250.86,920769.12,56518.26,730163),('1','149','257807','328',682.00,744.00,0.00,381.29,260039.78,276161.69,16121.91,730164),('1','149','257808','328',682.00,744.00,0.00,1149.12,783699.84,837354.28,53654.44,730165),('1','149','257809','328',682.00,744.00,0.00,1135.91,774690.62,836787.04,62096.42,730166),('1','149','257810','328',682.00,744.00,0.00,927.70,632691.40,687758.80,55067.40,730167),('1','149','257811','328',682.00,744.00,0.00,734.85,501167.70,544278.40,43110.70,730168),('1','149','257812','328',682.00,744.00,0.00,909.97,620599.54,672607.68,52008.14,730169),('1','149','257813','328',682.00,744.00,0.00,296.58,202267.56,220655.52,18387.96,730170),('1','149','257814','328',682.00,744.00,0.00,401.10,273550.20,298418.40,24868.20,730171),('1','149','257815','328',665.00,744.00,0.00,1597.44,1062297.60,1186045.36,123747.76,730172),('1','149','257816','328',665.00,744.00,0.00,2519.15,1675234.75,1832695.60,157460.85,730173),('1','149','257817','328',665.00,744.00,0.00,455.15,302674.75,332049.92,29375.17,730174),('1','149','257818','328',665.00,744.00,0.00,2010.75,1337148.75,1448713.00,111564.25,730175),('1','149','257819','328',665.00,744.00,0.00,1244.21,827399.65,925692.24,98292.59,730176),('1','149','257820','328',665.00,744.00,0.00,1241.55,825630.75,923713.20,98082.45,730177),('1','149','257821','328',665.00,744.00,0.00,1142.60,759829.00,850094.40,90265.40,730178),('1','149','257822','328',665.00,744.00,0.00,31.05,20648.25,23101.20,2452.95,730179),('1','149','257823','328',665.00,744.00,0.00,1004.57,668039.05,740050.08,72011.03,730180),('1','149','257824','328',665.00,744.00,0.00,1131.31,752321.15,835324.64,83003.49,730181),('1','149','257825','328',665.00,744.00,0.00,1923.88,1279380.20,1379426.72,100046.52,730182),('1','149','257826','328',665.00,744.00,0.00,416.04,276666.60,309533.76,32867.16,730183),('1','149','257827','328',665.00,760.00,0.00,464.43,308845.95,352687.12,43841.17,730184),('1','149','257828','328',665.00,744.00,0.00,496.14,329933.10,374179.04,44245.94,730185),('1','149','257829','328',665.00,760.00,0.00,36.05,23973.25,27398.00,3424.75,730186),('1','149','257830','328',665.00,760.00,0.00,785.42,522304.30,596919.20,74614.90,730187),('1','149','257831','328',665.00,760.00,0.00,879.91,585140.15,668731.60,83591.45,730188),('1','149','257832','328',665.00,760.00,0.00,972.36,646619.40,738993.60,92374.20,730189),('1','149','257833','328',665.00,760.00,0.00,1044.10,694326.50,793516.00,99189.50,730190),('1','149','257834','328',665.00,760.00,0.00,0.00,0.00,0.00,0.00,730191),('1','149','257835','328',665.00,760.00,0.00,1305.10,867891.50,991876.00,123984.50,730192),('1','149','257836','328',665.00,760.00,0.00,65.83,43776.95,50030.80,6253.85,730193),('1','149','257837','328',665.00,760.00,0.00,769.18,511504.70,584576.80,73072.10,730194),('1','149','257838','328',665.00,760.00,0.00,1037.22,689751.30,771580.78,81829.48,730195),('1','149','257839','328',665.00,744.00,0.00,1004.70,668125.50,745796.80,77671.30,730196),('1','149','257840','328',665.00,744.00,0.00,1080.70,718665.50,797240.80,78575.30,730197),('1','149','257841','328',665.00,744.00,0.00,1029.98,684936.70,766305.12,81368.42,730198),('1','149','257842','328',665.00,744.00,0.00,393.98,261996.70,291421.12,29424.42,730199),('1','149','257843','328',665.00,744.00,0.00,732.42,487059.30,539820.48,52761.18,730200),('1','149','257844','328',665.00,744.00,0.00,1357.97,903050.05,991295.80,88245.75,730201),('1','149','257845','328',665.00,744.00,0.00,684.87,455438.55,509543.28,54104.73,730202),('1','149','257846','328',665.00,744.00,0.00,1375.30,914574.50,1008603.20,94028.70,730203),('1','149','257847','328',665.00,744.00,0.00,642.61,427335.65,474701.84,47366.19,730204),('1','149','257848','328',665.00,744.00,0.00,532.74,354272.10,396358.56,42086.46,730205),('1','149','257849','328',665.00,744.00,0.00,312.54,207839.10,232529.76,24690.66,730206),('1','149','257850','328',665.00,744.00,0.00,1349.45,897384.25,985343.50,87959.25,730207),('1','149','257851','328',665.00,744.00,0.00,1486.37,988436.05,1082229.28,93793.23,730208),('1','149','257852','328',665.00,744.00,0.00,1139.64,757860.60,839392.16,81531.56,730209),('1','149','257853','328',665.00,744.00,0.00,1191.44,792307.60,862801.36,70493.76,730210),('1','149','257854','328',665.00,744.00,0.00,448.42,298199.30,333624.48,35425.18,730211),('1','149','257855','328',665.00,744.00,0.00,969.22,644531.30,721099.68,76568.38,730212),('1','149','257856','328',665.00,744.00,0.00,1693.09,1125904.85,1232424.96,106520.11,730213),('1','149','257857','328',665.00,744.00,0.00,1419.29,943827.85,1054251.76,110423.91,730214),('1','149','257858','328',665.00,744.00,0.00,1444.44,960552.60,1059362.00,98809.40,730215),('1','149','257859','328',665.00,744.00,0.00,111.75,74313.75,82326.00,8012.25,730216),('1','149','257860','328',665.00,744.00,0.00,954.74,634902.10,700126.56,65224.46,730217),('1','149','257861','328',665.00,744.00,0.00,1428.85,950185.25,1042604.40,92419.15,730218),('1','149','257862','328',665.00,744.00,0.00,2006.87,1334568.55,1443831.28,109262.73,730219),('1','149','257863','328',665.00,744.00,0.00,910.32,605362.80,664606.52,59243.72,730220),('1','149','257864','328',665.00,744.00,0.00,1406.69,935448.85,1015997.36,80548.51,730221),('1','149','257865','328',665.00,744.00,0.00,700.41,465772.65,521105.04,55332.39,730222),('1','149','257866','328',665.00,744.00,0.00,971.02,645728.30,722438.88,76710.58,730223),('1','149','257867','328',665.00,744.00,0.00,966.09,642449.85,718770.96,76321.11,730224),('1','149','257868','328',665.00,744.00,0.00,676.30,449739.50,503167.20,53427.70,730225),('1','149','257869','328',665.00,744.00,0.00,336.99,224098.35,250720.56,26622.21,730226),('1','149','257870','328',665.00,744.00,0.00,101.85,67730.25,75776.40,8046.15,730227),('1','149','257871','328',665.00,744.00,0.00,1514.49,1007135.85,1126780.56,119644.71,730228),('1','149','257872','328',665.00,744.00,0.00,1455.72,968053.80,1083055.68,115001.88,730229),('1','149','257873','328',665.00,744.00,0.00,1037.12,689684.80,763320.32,73635.52,730230),('1','149','257874','328',665.00,736.00,0.00,422.36,280869.40,310856.96,29987.56,730231),('1','149','257875','328',665.00,736.00,0.00,0.00,0.00,0.00,0.00,730232),('1','149','257876','328',665.00,736.00,0.00,674.45,446895.25,496395.20,49499.95,730233),('1','149','257877','328',660.00,736.00,0.00,1619.84,1069094.40,1192202.24,123107.84,730234),('1','149','257878','328',660.00,736.00,0.00,960.99,634253.40,707288.64,73035.24,730235),('1','149','257879','328',660.00,736.00,0.00,1182.95,780747.00,870651.20,89904.20,730236),('1','149','257880','328',660.00,736.00,0.00,641.39,423317.40,472063.04,48745.64,730237),('1','149','257881','328',660.00,736.00,0.00,0.00,0.00,0.00,0.00,730238),('1','149','257882','328',660.00,736.00,0.00,22.20,14652.00,16339.20,1687.20,730239),('1','149','257883','328',660.00,736.00,0.00,318.81,210414.60,234644.16,24229.56,730240),('1','149','257884','328',660.00,736.00,0.00,1040.37,686644.20,765712.32,79068.12,730241),('1','149','257885','328',660.00,736.00,0.00,1805.48,1191616.80,1302733.28,111116.48,730242),('1','149','257886','328',660.00,736.00,0.00,1482.84,978674.40,1088850.24,110175.84,730243),('1','149','257887','328',660.00,736.00,0.00,411.03,271279.80,295318.08,24038.28,730244),('1','149','257888','328',660.00,736.00,0.00,0.00,0.00,0.00,0.00,730245),('1','149','257889','328',660.00,736.00,0.00,377.83,249367.80,278082.88,28715.08,730246),('1','149','257890','328',660.00,736.00,0.00,827.42,546097.20,608981.12,62883.92,730247),('1','149','257891','328',660.00,736.00,0.00,2456.65,1621389.00,1765277.08,143888.08,730248),('1','149','257892','328',660.00,736.00,0.00,933.54,616136.40,687085.44,70949.04,730249),('1','149','257893','328',660.00,736.00,0.00,387.41,255690.60,285133.76,29443.16,730250),('1','149','257894','328',660.00,736.00,0.00,31.88,21040.80,23463.68,2422.88,730251),('1','149','257895','328',660.00,736.00,0.00,0.00,0.00,0.00,0.00,730252),('1','149','257896','328',660.00,736.00,0.00,1835.49,1211423.40,1350920.64,139497.24,730253),('1','149','257897','328',660.00,736.00,0.00,1463.35,965811.00,1077025.60,111214.60,730254),('1','149','257898','328',660.00,736.00,0.00,5.62,3709.20,4136.32,427.12,730255),('1','149','257899','328',660.00,764.00,0.00,0.00,0.00,0.00,0.00,730256),('1','149','257900','328',660.00,764.00,0.00,411.02,271273.20,314019.28,42746.08,730257),('1','149','257901','328',660.00,748.00,0.00,1578.17,1041592.20,1180471.16,138878.96,730258),('1','149','257902','328',660.00,748.00,0.00,1471.77,971368.20,1100883.96,129515.76,730259),('1','149','257903','328',660.00,748.00,0.00,1327.74,876308.40,993149.52,116841.12,730260),('1','149','257904','328',660.00,748.00,0.00,18.21,12018.60,13621.08,1602.48,730261),('1','149','257905','328',660.00,748.00,0.00,0.00,0.00,0.00,0.00,730262),('1','149','257906','328',660.00,748.00,0.00,1943.74,1282868.40,1453917.52,171049.12,730263),('1','149','257907','328',660.00,748.00,0.00,3014.53,1989589.80,2254868.44,265278.64,730264),('1','149','257908','328',660.00,748.00,0.00,688.06,454119.60,514668.88,60549.28,730265),('1','149','257909','328',660.00,748.00,0.00,690.68,455848.80,516628.64,60779.84,730266),('1','149','257910','328',660.00,748.00,0.00,2516.99,1661213.40,1882708.52,221495.12,730267),('1','149','257911','328',660.00,748.00,0.00,1667.55,1100583.00,1267338.00,166755.00,730268),('1','149','257912','328',660.00,760.00,0.00,448.06,295719.60,340525.60,44806.00,730269),('1','149','257913','328',660.00,760.00,0.00,16.80,11088.00,12768.00,1680.00,730270),('1','149','257914','328',660.00,760.00,0.00,741.30,489258.00,563388.00,74130.00,730271),('1','149','257915','328',660.00,760.00,0.00,1723.31,1137384.60,1309715.60,172331.00,730272),('1','149','257916','328',660.00,760.00,0.00,989.04,652766.40,751670.40,98904.00,730273),('1','149','257917','328',660.00,760.00,0.00,848.22,559825.20,644647.20,84822.00,730274),('1','149','257918','328',660.00,760.00,0.00,750.12,495079.20,570091.20,75012.00,730275),('1','149','257919','328',660.00,760.00,0.00,5.94,3920.40,4514.40,594.00,730276),('1','149','257920','328',660.00,760.00,0.00,898.11,592752.60,717656.00,124903.40,730277),('1','149','257921','328',660.00,800.00,0.00,1033.76,682281.60,827008.00,144726.40,730278),('1','149','257922','328',660.00,800.00,0.00,1865.69,1231355.40,1492552.00,261196.60,730279),('1','149','257923','328',660.00,760.00,0.00,1863.28,1229764.80,1416092.80,186328.00,730280),('1','149','257924','328',660.00,760.00,0.00,20.79,13721.40,15800.40,2079.00,730281),('1','149','257925','328',660.00,760.00,0.00,1872.61,1235922.60,1423183.60,187261.00,730282),('1','149','257926','328',660.00,760.00,0.00,1014.93,669853.80,771346.80,101493.00,730283),('1','149','257927','328',660.00,760.00,0.00,688.61,454482.60,523343.60,68861.00,730284),('1','149','257928','328',660.00,760.00,0.00,944.34,623264.40,717698.40,94434.00,730285),('1','149','257929','328',660.00,760.00,0.00,152.22,100465.20,115687.20,15222.00,730286),('1','149','257930','328',660.00,760.00,0.00,3.62,2389.20,2751.20,362.00,730287),('1','149','257931','328',660.00,760.00,0.00,1204.20,794772.00,915192.00,120420.00,730288),('1','149','257932','328',660.00,760.00,0.00,897.58,592402.80,682160.80,89758.00,730289),('1','149','257933','328',660.00,760.00,0.00,933.64,616202.40,709566.40,93364.00,730290),('1','149','257934','328',660.00,760.00,0.00,961.17,634372.20,730489.20,96117.00,730291),('1','149','257935','328',660.00,760.00,0.00,849.03,560359.80,645262.80,84903.00,730292),('1','149','257936','328',660.00,760.00,0.00,0.00,0.00,0.00,0.00,730293),('1','149','257937','328',660.00,760.00,0.00,618.54,421754.90,470090.40,48335.50,730294),('1','149','257938','328',685.00,760.00,0.00,749.43,513359.55,569566.80,56207.25,730295),('1','149','257939','328',685.00,760.00,0.00,801.38,548945.30,609048.80,60103.50,730296),('1','149','257940','328',685.00,760.00,0.00,837.57,573735.45,636553.20,62817.75,730297),('1','149','257941','328',685.00,760.00,0.00,948.44,649681.40,720814.40,71133.00,730298),('1','149','257942','328',685.00,760.00,0.00,703.11,481630.35,534363.60,52733.25,730299),('1','149','257943','328',685.00,760.00,0.00,37.50,25687.50,28500.00,2812.50,730300),('1','149','257944','328',685.00,760.00,0.00,0.00,0.00,0.00,0.00,730301),('1','149','257945','328',685.00,760.00,0.00,872.02,597333.70,662735.20,65401.50,730302),('1','149','257946','328',685.00,760.00,0.00,683.85,468437.25,519726.00,51288.75,730303),('1','149','257947','328',685.00,760.00,0.00,728.96,499337.60,554009.60,54672.00,730304),('1','149','257948','328',685.00,760.00,0.00,1124.25,770111.25,854430.00,84318.75,730305),('1','149','257949','328',685.00,760.00,0.00,1100.29,753698.65,836220.40,82521.75,730306),('1','149','257950','328',685.00,760.00,0.00,588.17,402896.45,447009.20,44112.75,730307),('1','149','257951','328',685.00,760.00,0.00,0.00,0.00,0.00,0.00,730308),('1','149','257952','328',685.00,760.00,0.00,794.57,544280.45,603873.20,59592.75,730309),('1','149','257953','328',685.00,760.00,0.00,1174.94,804833.90,892954.40,88120.50,730310),('1','149','257954','328',685.00,760.00,0.00,967.04,662422.40,734950.40,72528.00,730311),('1','149','257955','328',685.00,760.00,0.00,877.06,600786.10,666565.60,65779.50,730312),('1','149','257956','328',685.00,760.00,0.00,812.36,556466.60,617393.60,60927.00,730313),('1','149','257957','328',685.00,760.00,0.00,492.00,337020.00,373920.00,36900.00,730314),('1','149','257958','328',685.00,760.00,0.00,0.00,0.00,0.00,0.00,730315),('1','149','257959','328',685.00,760.00,0.00,742.06,508311.10,563965.60,55654.50,730316),('1','149','257960','328',685.00,760.00,0.00,788.53,540143.05,599282.80,59139.75,730317),('1','149','257961','328',685.00,760.00,0.00,1146.59,768527.15,871408.40,102881.25,730318),('1','149','257962','328',670.00,760.00,0.00,819.79,549259.30,623040.40,73781.10,730319),('1','149','257963','328',670.00,760.00,0.00,1074.15,719680.50,816354.00,96673.50,730320),('1','149','257964','328',670.00,760.00,0.00,728.47,488074.90,553637.20,65562.30,730321),('1','149','257965','328',670.00,760.00,0.00,29.70,19899.00,22572.00,2673.00,730322),('1','149','257966','328',670.00,760.00,0.00,0.00,0.00,0.00,0.00,730323),('1','149','257967','328',670.00,760.00,0.00,872.72,584722.40,663267.20,78544.80,730324),('1','149','257968','328',670.00,760.00,0.00,960.83,643756.10,730230.80,86474.70,730325),('1','149','257969','328',670.00,760.00,0.00,985.50,660285.00,748980.00,88695.00,730326),('1','149','257970','328',670.00,760.00,0.00,764.58,512268.60,581080.80,68812.20,730327),('1','149','257971','328',670.00,760.00,0.00,835.15,559550.50,634714.00,75163.50,730328),('1','149','257972','328',670.00,760.00,0.00,173.29,116104.30,129906.88,13802.58,730329),('1','149','257973','328',670.00,736.00,0.00,576.13,386007.10,424031.68,38024.58,730330),('1','149','257974','328',670.00,736.00,0.00,0.00,0.00,0.00,0.00,730331),('1','149','257975','328',670.00,736.00,0.00,1164.99,780543.30,857432.64,76889.34,730332),('1','149','257976','328',670.00,736.00,0.00,716.20,479854.00,527123.20,47269.20,730333),('1','149','257977','328',670.00,736.00,0.00,633.04,422527.06,465917.44,43390.38,730334),('1','149','257978','328',664.00,736.00,0.00,761.12,505383.68,560184.32,54800.64,730335),('1','149','257979','328',664.00,736.00,0.00,667.92,443498.88,491589.12,48090.24,730336),('1','149','257980','328',664.00,736.00,0.00,852.22,565874.08,627233.92,61359.84,730337),('1','149','257981','328',664.00,736.00,0.00,176.59,117255.76,129970.24,12714.48,730338),('1','149','257982','328',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730339),('1','149','257983','328',664.00,736.00,0.00,338.59,226855.30,249202.24,22346.94,730340),('1','149','257984','328',670.00,736.00,0.00,658.07,440906.90,484339.52,43432.62,730341),('1','149','257985','328',670.00,736.00,0.00,770.40,516168.00,567014.40,50846.40,730342),('1','149','257986','328',670.00,736.00,0.00,1167.47,782204.90,859257.92,77053.02,730343),('1','149','257987','328',670.00,736.00,0.00,1081.62,724685.40,796072.32,71386.92,730344),('1','149','257988','328',670.00,736.00,0.00,1004.00,672680.00,738944.00,66264.00,730345),('1','149','257989','328',670.00,736.00,0.00,30.46,20408.20,22418.56,2010.36,730346),('1','149','257990','328',670.00,736.00,0.00,0.00,0.00,0.00,0.00,730347),('1','149','257991','328',670.00,736.00,0.00,526.53,352775.10,387526.08,34750.98,730348),('1','149','257992','328',670.00,736.00,0.00,980.28,656787.60,721486.08,64698.48,730349),('1','149','257993','328',670.00,736.00,0.00,1314.18,880500.60,967236.48,86735.88,730350),('1','149','257994','328',670.00,736.00,0.00,838.23,561614.10,616937.28,55323.18,730351),('1','149','257995','328',670.00,736.00,0.00,733.37,491357.90,539760.32,48402.42,730352),('1','149','257996','328',670.00,736.00,0.00,226.32,151634.40,166571.52,14937.12,730353),('1','149','257997','328',670.00,736.00,0.00,0.00,0.00,0.00,0.00,730354),('1','149','257998','328',670.00,736.00,0.00,440.91,295409.70,324509.76,29100.06,730355),('1','149','257999','328',670.00,736.00,0.00,629.45,421731.50,463275.20,41543.70,730356),('1','149','258000','328',670.00,736.00,0.00,609.59,408425.30,448658.24,40232.94,730357),('1','149','258001','328',670.00,736.00,0.00,914.18,612500.60,672836.48,60335.88,730358),('1','149','258002','328',670.00,736.00,0.00,815.24,546210.80,600016.64,53805.84,730359),('1','149','258003','328',670.00,736.00,0.00,872.88,584829.60,642439.68,57610.08,730360),('1','149','258004','328',670.00,736.00,0.00,428.41,287034.70,315309.76,28275.06,730361),('1','149','258005','328',670.00,736.00,0.00,0.00,0.00,0.00,0.00,730362),('1','149','258006','328',670.00,736.00,0.00,209.86,140606.20,154456.96,13850.76,730363),('1','149','258007','328',670.00,736.00,0.00,1178.76,789769.20,867567.36,77798.16,730364),('1','149','258008','328',670.00,736.00,0.00,1402.08,939393.60,1031930.88,92537.28,730365),('1','149','258009','328',670.00,736.00,0.00,1494.50,1001315.00,1099952.00,98637.00,730366),('1','149','258010','328',670.00,736.00,0.00,529.93,355053.10,390028.48,34975.38,730367),('1','149','258011','328',670.00,736.00,0.00,0.00,0.00,0.00,0.00,730368),('1','149','258012','328',670.00,736.00,0.00,1409.49,944358.30,1037384.64,93026.34,730369),('1','149','258013','328',670.00,736.00,0.00,1071.11,717643.70,788336.96,70693.26,730370),('1','149','258014','328',670.00,736.00,0.00,1272.30,852441.00,936412.80,83971.80,730371),('1','149','258015','328',670.00,736.00,0.00,1377.91,923199.70,1014141.76,90942.06,730372),('1','149','258016','328',670.00,736.00,0.00,328.11,219833.70,241488.96,21655.26,730373),('1','149','258017','328',670.00,736.00,0.00,0.00,0.00,0.00,0.00,730374),('1','149','258018','328',670.00,736.00,0.00,501.98,336326.60,369457.28,33130.68,730375),('1','149','258019','328',670.00,736.00,0.00,1116.62,748135.40,821832.32,73696.92,730376),('1','149','258020','328',670.00,736.00,0.00,892.85,598209.50,657137.60,58928.10,730377),('1','149','258021','328',670.00,736.00,0.00,910.37,609947.90,670032.32,60084.42,730378),('1','149','258022','328',670.00,736.00,0.00,1094.89,733576.30,805839.04,72262.74,730379),('1','149','258023','328',670.00,736.00,0.00,543.13,363897.10,399743.68,35846.58,730380),('1','149','258024','328',670.00,736.00,0.00,0.00,0.00,0.00,0.00,730381),('1','149','258025','328',670.00,736.00,0.00,481.52,322618.40,354398.72,31780.32,730382),('1','149','258026','328',670.00,736.00,0.00,1160.04,777226.80,853789.44,76562.64,730383),('1','149','258027','328',670.00,736.00,0.00,1493.49,1000638.30,1099208.64,98570.34,730384),('1','149','258028','328',670.00,736.00,0.00,689.91,462239.70,507773.76,45534.06,730385),('1','149','258029','328',670.00,736.00,0.00,979.52,656278.40,720926.72,64648.32,730386),('1','149','258030','328',670.00,736.00,0.00,399.87,261430.80,294304.32,32873.52,730387),('1','149','258031','328',640.00,736.00,0.00,0.00,0.00,0.00,0.00,730388),('1','149','258032','328',640.00,736.00,0.00,357.33,228691.20,262994.88,34303.68,730389),('1','149','258033','328',640.00,736.00,0.00,1014.08,649011.20,746362.88,97351.68,730390),('1','149','258034','328',640.00,736.00,0.00,1116.72,714700.80,821905.92,107205.12,730391),('1','149','258035','328',640.00,736.00,0.00,1159.65,742176.00,853502.40,111326.40,730392),('1','149','258036','328',640.00,736.00,0.00,923.91,591302.40,679997.76,88695.36,730393),('1','149','258037','328',640.00,736.00,0.00,580.79,371705.60,427461.44,55755.84,730394),('1','149','258038','328',640.00,736.00,0.00,0.00,0.00,0.00,0.00,730395),('1','149','258039','328',640.00,736.00,0.00,143.38,91763.20,105527.68,13764.48,730396),('1','149','258040','328',640.00,736.00,0.00,782.57,500844.80,575971.52,75126.72,730397),('1','149','258041','328',640.00,736.00,0.00,558.33,357331.20,410930.88,53599.68,730398),('1','149','258042','328',640.00,736.00,0.00,1117.16,714982.40,822229.76,107247.36,730399),('1','149','258043','328',640.00,736.00,0.00,708.53,453459.20,521478.08,68018.88,730400),('1','149','258044','328',640.00,736.00,0.00,1017.69,651321.60,749019.84,97698.24,730401),('1','149','258045','328',640.00,736.00,0.00,572.72,366540.80,421521.92,54981.12,730402),('1','149','258046','328',640.00,736.00,0.00,21.06,13478.40,15500.16,2021.76,730403),('1','149','258047','328',640.00,736.00,0.00,0.00,0.00,0.00,0.00,730404),('1','149','258048','328',640.00,736.00,0.00,252.11,161350.40,185552.96,24202.56,730405),('1','149','258049','328',640.00,736.00,0.00,887.08,567731.20,652890.88,85159.68,730406),('1','149','258050','328',640.00,736.00,0.00,792.30,507072.00,583132.80,76060.80,730407),('1','149','258051','328',640.00,736.00,0.00,960.36,614630.40,706824.96,92194.56,730408),('1','149','258052','328',640.00,736.00,0.00,628.58,402291.20,462634.88,60343.68,730409),('1','149','258053','328',640.00,736.00,0.00,661.70,423488.00,487011.20,63523.20,730410),('1','149','258054','328',640.00,736.00,0.00,671.01,429446.40,493863.36,64416.96,730411),('1','149','258055','328',640.00,736.00,0.00,0.00,0.00,0.00,0.00,730412),('1','149','258056','328',640.00,736.00,0.00,647.96,414694.40,476898.56,62204.16,730413),('1','149','258057','328',640.00,736.00,0.00,729.41,466822.40,536845.76,70023.36,730414),('1','149','258058','328',640.00,736.00,0.00,764.63,489363.20,562767.68,73404.48,730415),('1','149','258059','328',640.00,736.00,0.00,798.92,511308.80,588005.12,76696.32,730416),('1','149','258060','328',640.00,736.00,0.00,781.38,500083.20,575095.68,75012.48,730417),('1','149','258061','328',640.00,736.00,0.00,811.91,519622.40,597565.76,77943.36,730418),('1','149','258062','328',640.00,736.00,0.00,823.78,527219.20,606302.08,79082.88,730419),('1','149','258063','328',640.00,736.00,0.00,229.13,146643.20,168639.68,21996.48,730420),('1','149','258064','328',640.00,736.00,0.00,238.09,152377.60,175234.24,22856.64,730421),('1','149','258065','328',640.00,736.00,0.00,925.04,592025.60,680829.44,88803.84,730422),('1','149','258066','328',640.00,736.00,0.00,1262.17,807788.80,928957.12,121168.32,730423),('1','149','258067','328',640.00,736.00,0.00,897.15,574176.00,660302.40,86126.40,730424),('1','149','258068','328',640.00,736.00,0.00,843.95,540128.00,621147.20,81019.20,730425),('1','149','258069','328',640.00,736.00,0.00,817.77,523372.80,601878.72,78505.92,730426),('1','149','258070','328',640.00,736.00,0.00,1004.49,642873.60,739304.64,96431.04,730427),('1','149','258071','328',640.00,736.00,0.00,805.49,515513.60,592840.64,77327.04,730428),('1','149','258072','328',640.00,736.00,0.00,1075.17,688108.80,791325.12,103216.32,730429),('1','149','258073','328',640.00,736.00,0.00,899.15,575456.00,661774.40,86318.40,730430),('1','149','258074','328',640.00,736.00,0.00,666.02,426252.80,490190.72,63937.92,730431),('1','149','258075','328',640.00,736.00,0.00,750.88,480563.20,552647.68,72084.48,730432),('1','149','258076','328',640.00,736.00,0.00,134.76,86246.40,99183.36,12936.96,730433),('1','149','258077','328',640.00,700.00,0.00,549.31,348262.54,384517.00,36254.46,730434),('1','149','258078','328',634.00,700.00,0.00,847.20,537124.80,593040.00,55915.20,730435),('1','149','258079','328',634.00,700.00,0.00,719.80,456353.20,503860.00,47506.80,730436),('1','149','258080','328',634.00,700.00,0.00,874.42,554382.28,612094.00,57711.72,730437),('1','149','258081','328',634.00,700.00,0.00,928.87,588903.58,650209.00,61305.42,730438),('1','149','258082','328',634.00,700.00,0.00,794.02,503408.68,555814.00,52405.32,730439),('1','149','258083','328',634.00,700.00,0.00,598.63,379531.42,419041.00,39509.58,730440),('1','149','258084','328',634.00,700.00,0.00,569.15,360841.10,398405.00,37563.90,730441),('1','149','258085','328',634.00,700.00,0.00,717.04,454603.36,501928.00,47324.64,730442),('1','149','258086','328',634.00,700.00,0.00,1023.21,648715.14,716247.00,67531.86,730443),('1','149','258087','328',634.00,700.00,0.00,1213.75,769517.50,849625.00,80107.50,730444),('1','149','258088','328',634.00,700.00,0.00,919.71,583096.14,643797.00,60700.86,730445);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=306 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',305,'149','PRODUCT TANK','TANK CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=771 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','149','305',770,1,'328','LPG TANK',7000.00,1.00,5228.64,'TANK CONTAINING LPG','479','2020-08-10 20:52:44','2020-08-12 11:56:51','487',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','149',770,1799.49,'2023-03-20 19:19:30');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2714518 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2108837,'1','149',NULL,328,'Purchased from AA RANO NIGERIA LIMITED',0.00,1806000.00,3000.00,0.00,0.00,'2021-12-01 07:08:25','',''),(2108868,'1','149',NULL,328,'Reception corrector for bridging 125806',0.00,0.00,0.00,3000.00,0.00,'2021-12-01 07:09:20','',''),(2108869,'1','149','770',328,'Received from bridging 125806',0.00,0.00,3000.00,0.00,0.00,'2021-12-01 07:09:20','',''),(2109285,'1','149','770',328,'Retail Sale Id 1254593',6003.20,0.00,0.00,0.00,356.44,'2021-12-01 07:28:16','',''),(2109286,'1','149','770',328,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-01 07:28:16','',''),(2109300,'1','149','770',328,'Retail Sale Id 1254604',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 07:29:29','',''),(2109301,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 07:29:29','',''),(2109318,'1','149','770',328,'Retail Sale Id 1254612',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 07:30:35','',''),(2109319,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 07:30:35','',''),(2109334,'1','149','770',328,'Retail Sale Id 1254622',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 07:31:39','',''),(2109335,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:31:39','',''),(2109364,'1','149','770',328,'Retail Sale Id 1254642',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 07:33:13','',''),(2109365,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 07:33:13','',''),(2109402,'1','149','770',328,'Retail Sale Id 1254664',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 07:35:03','',''),(2109403,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 07:35:03','',''),(2109420,'1','149','770',328,'Retail Sale Id 1254674',998.40,0.00,0.00,0.00,59.28,'2021-12-01 07:36:00','',''),(2109421,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 07:36:00','',''),(2109460,'1','149','770',328,'Retail Sale Id 1254700',3500.80,0.00,0.00,0.00,207.86,'2021-12-01 07:37:53','',''),(2109461,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 07:37:53','',''),(2109496,'1','149','770',328,'Retail Sale Id 1254715',16000.00,0.00,0.00,0.00,950.00,'2021-12-01 07:39:18','',''),(2109497,'1','149','770',328,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 07:39:18','',''),(2109627,'1','149','770',328,'Retail Sale Id 1254765',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 07:44:52','',''),(2109628,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 07:44:52','',''),(2109768,'1','149','770',328,'Retail Sale Id 1254827',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 07:50:09','',''),(2109769,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 07:50:09','',''),(2109930,'1','149','770',328,'Retail Sale Id 1254906',697.60,0.00,0.00,0.00,41.42,'2021-12-01 07:58:28','',''),(2109931,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-01 07:58:28','',''),(2110005,'1','149','770',328,'Retail Sale Id 1254944',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 08:02:53','',''),(2110006,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 08:02:53','',''),(2110114,'1','149','770',328,'Retail Sale Id 1254993',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 08:08:12','',''),(2110115,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 08:08:12','',''),(2110128,'1','149','770',328,'Retail Sale Id 1255001',998.40,0.00,0.00,0.00,59.28,'2021-12-01 08:09:14','',''),(2110129,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 08:09:14','',''),(2110224,'1','149','770',328,'Retail Sale Id 1255046',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 08:14:49','',''),(2110225,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:14:49','',''),(2110252,'1','149','770',328,'Retail Sale Id 1255061',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 08:16:36','',''),(2110253,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 08:16:36','',''),(2110706,'1','149','770',328,'Retail Sale Id 1255283',998.40,0.00,0.00,0.00,59.28,'2021-12-01 08:42:28','',''),(2110707,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 08:42:28','',''),(2110732,'1','149','770',328,'Retail Sale Id 1255294',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 08:43:57','',''),(2110733,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 08:43:57','',''),(2110752,'1','149','770',328,'Retail Sale Id 1255304',2099.20,0.00,0.00,0.00,124.64,'2021-12-01 08:45:12','',''),(2110753,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.28,0.00,'2021-12-01 08:45:12','',''),(2110774,'1','149','770',328,'Retail Sale Id 1255315',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 08:46:27','',''),(2110775,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 08:46:27','',''),(2110934,'1','149','770',328,'Retail Sale Id 1255409',12800.00,0.00,0.00,0.00,760.00,'2021-12-01 08:56:08','',''),(2110935,'1','149','770',328,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-01 08:56:08','',''),(2110962,'1','149','770',328,'Retail Sale Id 1255424',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 08:58:16','',''),(2110964,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 08:58:16','',''),(2110991,'1','149','770',328,'Retail Sale Id 1255439',2598.40,0.00,0.00,0.00,154.28,'2021-12-01 08:59:46','',''),(2110992,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-01 08:59:46','',''),(2111060,'1','149','770',328,'Retail Sale Id 1255470',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 09:03:24','',''),(2111061,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 09:03:24','',''),(2111114,'1','149','770',328,'Retail Sale Id 1255496',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 09:06:44','',''),(2111115,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 09:06:44','',''),(2111176,'1','149','770',328,'Retail Sale Id 1255526',998.40,0.00,0.00,0.00,59.28,'2021-12-01 09:10:38','',''),(2111177,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 09:10:38','',''),(2111266,'1','149','770',328,'Retail Sale Id 1255578',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 09:16:02','',''),(2111267,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 09:16:02','',''),(2111356,'1','149','770',328,'Retail Sale Id 1255629',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 09:21:43','',''),(2111357,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 09:21:43','',''),(2111502,'1','149','770',328,'Retail Sale Id 1255698',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 09:29:37','',''),(2111503,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 09:29:37','',''),(2111607,'1','149','770',328,'Retail Sale Id 1255757',2598.40,0.00,0.00,0.00,154.28,'2021-12-01 09:37:40','',''),(2111608,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-01 09:37:40','',''),(2111708,'1','149','770',328,'Retail Sale Id 1255813',6502.40,0.00,0.00,0.00,386.08,'2021-12-01 09:44:35','',''),(2111709,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-01 09:44:35','',''),(2111786,'1','149','770',328,'Retail Sale Id 1255857',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 09:49:41','',''),(2111787,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 09:49:41','',''),(2111792,'1','149','770',328,'Retail Sale Id 1255860',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 09:50:42','',''),(2111793,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 09:50:42','',''),(2111863,'1','149','770',328,'Retail Sale Id 1255890',998.40,0.00,0.00,0.00,59.28,'2021-12-01 09:55:54','',''),(2111864,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 09:55:54','',''),(2111930,'1','149','770',328,'Retail Sale Id 1255919',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 10:00:01','',''),(2111931,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 10:00:01','',''),(2111947,'1','149','770',328,'Retail Sale Id 1255923',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 10:00:42','',''),(2111948,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 10:00:42','',''),(2112051,'1','149','770',328,'Retail Sale Id 1255978',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 10:08:36','',''),(2112052,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 10:08:36','',''),(2112126,'1','149','770',328,'Retail Sale Id 1256018',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 10:13:17','',''),(2112127,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 10:13:17','',''),(2112212,'1','149','770',328,'Retail Sale Id 1256056',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 10:17:34','',''),(2112213,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 10:17:34','',''),(2112235,'1','149','770',328,'Retail Sale Id 1256066',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 10:19:27','',''),(2112236,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 10:19:27','',''),(2112247,'1','149','770',328,'Retail Sale Id 1256074',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 10:20:31','',''),(2112248,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:20:31','',''),(2112257,'1','149','770',328,'Retail Sale Id 1256081',998.40,0.00,0.00,0.00,59.28,'2021-12-01 10:21:48','',''),(2112258,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 10:21:48','',''),(2112357,'1','149','770',328,'Retail Sale Id 1256124',998.40,0.00,0.00,0.00,59.28,'2021-12-01 10:30:09','',''),(2112358,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 10:30:09','',''),(2112461,'1','149','770',328,'Retail Sale Id 1256175',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 10:36:55','',''),(2112462,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 10:36:55','',''),(2112614,'1','149','770',328,'Retail Sale Id 1256254',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 10:50:19','',''),(2112615,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:50:19','',''),(2112628,'1','149','770',328,'Retail Sale Id 1256262',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 10:51:56','',''),(2112629,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 10:51:56','',''),(2112720,'1','149','770',328,'Retail Sale Id 1256313',2598.40,0.00,0.00,0.00,154.28,'2021-12-01 11:00:04','',''),(2112721,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-01 11:00:04','',''),(2112742,'1','149','770',328,'Retail Sale Id 1256323',2598.40,0.00,0.00,0.00,154.28,'2021-12-01 11:01:56','',''),(2112743,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-01 11:01:56','',''),(2112870,'1','149','770',328,'Retail Sale Id 1256391',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 11:11:04','',''),(2112871,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 11:11:04','',''),(2113003,'1','149',NULL,328,'Purchased from AA RANO NIGERIA LIMITED',0.00,1366540.00,2270.00,0.00,0.00,'2021-12-01 11:18:01','',''),(2113032,'1','149',NULL,328,'Reception corrector for bridging 125839',0.00,0.00,0.00,2270.00,0.00,'2021-12-01 11:19:16','',''),(2113033,'1','149','770',328,'Received from bridging 125839',0.00,0.00,2270.00,0.00,0.00,'2021-12-01 11:19:16','',''),(2113038,'1','149','770',328,'Retail Sale Id 1256458',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 11:19:46','',''),(2113039,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 11:19:46','',''),(2113060,'1','149','770',328,'Retail Sale Id 1256469',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 11:21:23','',''),(2113061,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 11:21:23','',''),(2113158,'1','149','770',328,'Retail Sale Id 1256515',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 11:26:37','',''),(2113159,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 11:26:37','',''),(2113252,'1','149','770',328,'Retail Sale Id 1256570',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 11:34:48','',''),(2113253,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 11:34:48','',''),(2113264,'1','149','770',328,'Retail Sale Id 1256576',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 11:35:42','',''),(2113265,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:35:42','',''),(2113308,'1','149','770',328,'Retail Sale Id 1256596',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 11:38:46','',''),(2113309,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 11:38:46','',''),(2113343,'1','149','770',328,'Retail Sale Id 1256616',998.40,0.00,0.00,0.00,59.28,'2021-12-01 11:41:04','',''),(2113344,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 11:41:04','',''),(2113459,'1','149','770',328,'Retail Sale Id 1256675',800.00,0.00,0.00,0.00,47.50,'2021-12-01 11:50:06','',''),(2113460,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 11:50:06','',''),(2113549,'1','149','770',328,'Retail Sale Id 1256721',998.40,0.00,0.00,0.00,59.28,'2021-12-01 11:57:06','',''),(2113550,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 11:57:06','',''),(2113575,'1','149','770',328,'Retail Sale Id 1256737',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 11:59:41','',''),(2113576,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:59:41','',''),(2113617,'1','149','770',328,'Retail Sale Id 1256762',998.40,0.00,0.00,0.00,59.28,'2021-12-01 12:06:16','',''),(2113618,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 12:06:16','',''),(2113627,'1','149','770',328,'Retail Sale Id 1256768',800.00,0.00,0.00,0.00,47.50,'2021-12-01 12:07:09','',''),(2113628,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 12:07:09','',''),(2113637,'1','149','770',328,'Retail Sale Id 1256772',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 12:08:05','',''),(2113638,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 12:08:05','',''),(2113647,'1','149','770',328,'Retail Sale Id 1256779',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 12:09:13','',''),(2113648,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 12:09:13','',''),(2113679,'1','149','770',328,'Retail Sale Id 1256793',998.40,0.00,0.00,0.00,59.28,'2021-12-01 12:11:50','',''),(2113680,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 12:11:50','',''),(2113731,'1','149','770',328,'Retail Sale Id 1256823',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 12:14:42','',''),(2113732,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 12:14:42','',''),(2113875,'1','149','770',328,'Retail Sale Id 1256893',1798.40,0.00,0.00,0.00,106.78,'2021-12-01 12:23:24','',''),(2113876,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-01 12:23:24','',''),(2113895,'1','149','770',328,'Retail Sale Id 1256903',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 12:25:26','',''),(2113896,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:25:26','',''),(2113925,'1','149','770',328,'Retail Sale Id 1256918',652.80,0.00,0.00,0.00,38.76,'2021-12-01 12:27:22','',''),(2113926,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-01 12:27:22','',''),(2113983,'1','149','770',328,'Retail Sale Id 1256947',800.00,0.00,0.00,0.00,47.50,'2021-12-01 12:32:30','',''),(2113984,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 12:32:30','',''),(2114077,'1','149','770',328,'Retail Sale Id 1256995',32000.00,0.00,0.00,0.00,1900.00,'2021-12-01 12:42:09','',''),(2114078,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 12:42:09','',''),(2114085,'1','149','770',328,'Retail Sale Id 1256999',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 12:43:03','',''),(2114086,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 12:43:03','',''),(2114130,'1','149','770',328,'Retail Sale Id 1257018',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 12:47:54','',''),(2114131,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 12:47:54','',''),(2114144,'1','149','770',328,'Retail Sale Id 1257025',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 12:49:44','',''),(2114145,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 12:49:44','',''),(2114234,'1','149','770',328,'Retail Sale Id 1257076',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 13:00:05','',''),(2114235,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 13:00:05','',''),(2114250,'1','149','770',328,'Retail Sale Id 1257083',998.40,0.00,0.00,0.00,59.28,'2021-12-01 13:01:26','',''),(2114251,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 13:01:26','',''),(2114380,'1','149','770',328,'Retail Sale Id 1257139',652.80,0.00,0.00,0.00,38.76,'2021-12-01 13:10:25','',''),(2114381,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-01 13:10:25','',''),(2114404,'1','149','770',328,'Retail Sale Id 1257187',998.40,0.00,0.00,0.00,59.28,'2021-12-01 13:11:43','',''),(2114405,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 13:11:43','',''),(2114426,'1','149','770',328,'Retail Sale Id 1257203',32000.00,0.00,0.00,0.00,1900.00,'2021-12-01 13:12:59','',''),(2114427,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 13:12:59','',''),(2114464,'1','149','770',328,'Retail Sale Id 1257223',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 13:15:06','',''),(2114465,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:15:06','',''),(2114494,'1','149','770',328,'Retail Sale Id 1257241',652.80,0.00,0.00,0.00,38.76,'2021-12-01 13:17:03','',''),(2114495,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-01 13:17:03','',''),(2114574,'1','149','770',328,'Retail Sale Id 1257283',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 13:23:08','',''),(2114575,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 13:23:08','',''),(2114719,'1','149','770',328,'Retail Sale Id 1257351',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 13:35:43','',''),(2114720,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 13:35:43','',''),(2114740,'1','149','770',328,'Retail Sale Id 1257354',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 13:36:26','',''),(2114741,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 13:36:26','',''),(2114758,'1','149','770',328,'Retail Sale Id 1257361',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 13:37:47','',''),(2114759,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 13:37:47','',''),(2114781,'1','149','770',328,'Retail Sale Id 1257367',998.40,0.00,0.00,0.00,59.28,'2021-12-01 13:38:40','',''),(2114782,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 13:38:40','',''),(2114804,'1','149','770',328,'Retail Sale Id 1257372',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 13:39:48','',''),(2114805,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 13:39:48','',''),(2114876,'1','149','770',328,'Retail Sale Id 1257390',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 13:42:48','',''),(2114877,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 13:42:48','',''),(2114960,'1','149','770',328,'Retail Sale Id 1257421',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 13:48:03','',''),(2114961,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 13:48:03','',''),(2114984,'1','149','770',328,'Retail Sale Id 1257426',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 13:49:01','',''),(2114985,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 13:49:01','',''),(2115023,'1','149','770',328,'Retail Sale Id 1257444',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 13:51:14','',''),(2115024,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:51:14','',''),(2115037,'1','149','770',328,'Retail Sale Id 1257449',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 13:52:21','',''),(2115038,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 13:52:21','',''),(2115162,'1','149','770',328,'Retail Sale Id 1257514',7040.00,0.00,0.00,0.00,418.00,'2021-12-01 13:58:36','',''),(2115163,'1','149','770',328,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-01 13:58:36','',''),(2115283,'1','149','770',328,'Retail Sale Id 1257569',998.40,0.00,0.00,0.00,59.28,'2021-12-01 14:04:52','',''),(2115284,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 14:04:52','',''),(2115301,'1','149','770',328,'Retail Sale Id 1257575',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 14:06:13','',''),(2115302,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 14:06:13','',''),(2115413,'1','149','770',328,'Retail Sale Id 1257644',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 14:13:45','',''),(2115414,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 14:13:45','',''),(2115429,'1','149','770',328,'Retail Sale Id 1257653',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 14:14:53','',''),(2115430,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 14:14:53','',''),(2115445,'1','149','770',328,'Retail Sale Id 1257662',998.40,0.00,0.00,0.00,59.28,'2021-12-01 14:16:23','',''),(2115446,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 14:16:23','',''),(2115457,'1','149','770',328,'Retail Sale Id 1257671',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 14:17:08','',''),(2115458,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:17:08','',''),(2115469,'1','149','770',328,'Retail Sale Id 1257676',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 14:17:54','',''),(2115470,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 14:17:54','',''),(2115536,'1','149','770',328,'Retail Sale Id 1257704',652.80,0.00,0.00,0.00,38.76,'2021-12-01 14:22:19','',''),(2115537,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-01 14:22:19','',''),(2115567,'1','149','770',328,'Retail Sale Id 1257731',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 14:24:58','',''),(2115568,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 14:24:58','',''),(2115581,'1','149','770',328,'Retail Sale Id 1257737',1203.20,0.00,0.00,0.00,71.44,'2021-12-01 14:25:58','',''),(2115582,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-01 14:25:58','',''),(2115595,'1','149','770',328,'Retail Sale Id 1257740',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 14:26:48','',''),(2115596,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 14:26:48','',''),(2115630,'1','149','770',328,'Retail Sale Id 1257759',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 14:29:00','',''),(2115631,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 14:29:00','',''),(2115632,'1','149','770',328,'Retail Sale Id 1257759',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 14:29:00','',''),(2115633,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:29:00','',''),(2115658,'1','149','770',328,'Retail Sale Id 1257773',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 14:31:18','',''),(2115659,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 14:31:18','',''),(2115674,'1','149','770',328,'Retail Sale Id 1257779',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 14:32:25','',''),(2115675,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 14:32:25','',''),(2115690,'1','149','770',328,'Retail Sale Id 1257786',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 14:33:30','',''),(2115691,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 14:33:30','',''),(2115704,'1','149','770',328,'Retail Sale Id 1257794',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 14:34:20','',''),(2115705,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 14:34:20','',''),(2115710,'1','149','770',328,'Retail Sale Id 1257797',998.40,0.00,0.00,0.00,59.28,'2021-12-01 14:35:02','',''),(2115711,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 14:35:02','',''),(2115758,'1','149','770',328,'Retail Sale Id 1257821',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 14:38:16','',''),(2115759,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 14:38:16','',''),(2115778,'1','149','770',328,'Retail Sale Id 1257831',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 14:39:26','',''),(2115779,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 14:39:26','',''),(2115809,'1','149','770',328,'Retail Sale Id 1257846',4499.20,0.00,0.00,0.00,267.14,'2021-12-01 14:43:03','',''),(2115810,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-01 14:43:03','',''),(2115823,'1','149','770',328,'Retail Sale Id 1257852',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 14:44:09','',''),(2115824,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 14:44:09','',''),(2115853,'1','149','770',328,'Retail Sale Id 1257868',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 14:47:13','',''),(2115854,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 14:47:13','',''),(2115869,'1','149','770',328,'Retail Sale Id 1257878',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 14:48:03','',''),(2115870,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 14:48:03','',''),(2116000,'1','149','770',328,'Retail Sale Id 1257916',2803.20,0.00,0.00,0.00,166.44,'2021-12-01 14:52:58','',''),(2116001,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-01 14:52:58','',''),(2116056,'1','149','770',328,'Retail Sale Id 1257936',998.40,0.00,0.00,0.00,59.28,'2021-12-01 14:56:17','',''),(2116057,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 14:56:17','',''),(2116108,'1','149','770',328,'Retail Sale Id 1257962',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 15:00:02','',''),(2116109,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 15:00:02','',''),(2116148,'1','149','770',328,'Retail Sale Id 1257983',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 15:03:06','',''),(2116149,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 15:03:06','',''),(2116184,'1','149','770',328,'Retail Sale Id 1258000',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 15:05:38','',''),(2116185,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 15:05:38','',''),(2116205,'1','149','770',328,'Retail Sale Id 1258012',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 15:07:43','',''),(2116206,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 15:07:43','',''),(2116247,'1','149','770',328,'Retail Sale Id 1258035',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 15:11:50','',''),(2116248,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 15:11:50','',''),(2116253,'1','149','770',328,'Retail Sale Id 1258039',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 15:12:28','',''),(2116254,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 15:12:28','',''),(2116267,'1','149','770',328,'Retail Sale Id 1258046',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 15:13:21','',''),(2116268,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 15:13:21','',''),(2116279,'1','149','770',328,'Retail Sale Id 1258055',998.40,0.00,0.00,0.00,59.28,'2021-12-01 15:14:13','',''),(2116280,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 15:14:13','',''),(2116306,'1','149','770',328,'Retail Sale Id 1258061',748.80,0.00,0.00,0.00,44.46,'2021-12-01 15:15:01','',''),(2116307,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.17,0.00,'2021-12-01 15:15:01','',''),(2116320,'1','149','770',328,'Retail Sale Id 1258070',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 15:16:00','',''),(2116321,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 15:16:00','',''),(2116356,'1','149','770',328,'Retail Sale Id 1258085',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 15:18:11','',''),(2116357,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 15:18:11','',''),(2116384,'1','149','770',328,'Retail Sale Id 1258100',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 15:20:01','',''),(2116385,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 15:20:01','',''),(2116406,'1','149','770',328,'Retail Sale Id 1258111',5203.20,0.00,0.00,0.00,308.94,'2021-12-01 15:21:14','',''),(2116407,'1','149','770',328,'Retail sales',0.00,0.00,0.00,8.13,0.00,'2021-12-01 15:21:14','',''),(2116418,'1','149','770',328,'Retail Sale Id 1258116',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 15:22:05','',''),(2116419,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 15:22:05','',''),(2116430,'1','149','770',328,'Retail Sale Id 1258122',998.40,0.00,0.00,0.00,59.28,'2021-12-01 15:22:37','',''),(2116431,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 15:22:37','',''),(2116452,'1','149','770',328,'Retail Sale Id 1258130',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 15:23:47','',''),(2116453,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 15:23:47','',''),(2116537,'1','149','770',328,'Retail Sale Id 1258169',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 15:28:53','',''),(2116538,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 15:28:53','',''),(2116553,'1','149','770',328,'Retail Sale Id 1258177',998.40,0.00,0.00,0.00,59.28,'2021-12-01 15:29:42','',''),(2116554,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 15:29:42','',''),(2116652,'1','149','770',328,'Retail Sale Id 1258229',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 15:36:55','',''),(2116653,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 15:36:55','',''),(2116666,'1','149','770',328,'Retail Sale Id 1258237',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 15:38:03','',''),(2116667,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 15:38:03','',''),(2116674,'1','149','770',328,'Retail Sale Id 1258243',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 15:38:42','',''),(2116675,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 15:38:42','',''),(2116688,'1','149','770',328,'Retail Sale Id 1258248',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 15:39:25','',''),(2116689,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 15:39:25','',''),(2116784,'1','149','770',328,'Retail Sale Id 1258284',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 15:44:37','',''),(2116785,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 15:44:37','',''),(2116812,'1','149','770',328,'Retail Sale Id 1258298',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 15:46:00','',''),(2116813,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 15:46:00','',''),(2116844,'1','149','770',328,'Retail Sale Id 1258317',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 15:47:25','',''),(2116845,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 15:47:25','',''),(2116870,'1','149','770',328,'Retail Sale Id 1258329',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 15:48:23','',''),(2116871,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 15:48:23','',''),(2116892,'1','149','770',328,'Retail Sale Id 1258340',652.80,0.00,0.00,0.00,38.76,'2021-12-01 15:49:31','',''),(2116893,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-01 15:49:31','',''),(2116915,'1','149','770',328,'Retail Sale Id 1258356',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 15:50:27','',''),(2116916,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:50:27','',''),(2116952,'1','149','770',328,'Retail Sale Id 1258370',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 15:51:29','',''),(2116953,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 15:51:29','',''),(2116988,'1','149','770',328,'Retail Sale Id 1258387',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 15:53:04','',''),(2116989,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 15:53:04','',''),(2117014,'1','149','770',328,'Retail Sale Id 1258397',1702.40,0.00,0.00,0.00,101.08,'2021-12-01 15:54:14','',''),(2117015,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-01 15:54:14','',''),(2117051,'1','149','770',328,'Retail Sale Id 1258415',2099.20,0.00,0.00,0.00,124.64,'2021-12-01 15:55:46','',''),(2117052,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.28,0.00,'2021-12-01 15:55:46','',''),(2117084,'1','149','770',328,'Retail Sale Id 1258430',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 15:57:11','',''),(2117085,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 15:57:11','',''),(2117117,'1','149','770',328,'Retail Sale Id 1258447',1203.20,0.00,0.00,0.00,71.44,'2021-12-01 15:58:39','',''),(2117118,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-01 15:58:39','',''),(2117139,'1','149','770',328,'Retail Sale Id 1258458',998.40,0.00,0.00,0.00,59.28,'2021-12-01 15:59:28','',''),(2117140,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 15:59:28','',''),(2117159,'1','149','770',328,'Retail Sale Id 1258472',2598.40,0.00,0.00,0.00,154.28,'2021-12-01 16:00:25','',''),(2117160,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-01 16:00:25','',''),(2117183,'1','149','770',328,'Retail Sale Id 1258481',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 16:01:35','',''),(2117184,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 16:01:35','',''),(2117223,'1','149','770',328,'Retail Sale Id 1258500',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 16:03:29','',''),(2117224,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 16:03:29','',''),(2117241,'1','149','770',328,'Retail Sale Id 1258513',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 16:04:34','',''),(2117242,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 16:04:34','',''),(2117279,'1','149','770',328,'Retail Sale Id 1258528',998.40,0.00,0.00,0.00,59.28,'2021-12-01 16:05:48','',''),(2117280,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:05:48','',''),(2117341,'1','149','770',328,'Retail Sale Id 1258549',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 16:07:42','',''),(2117342,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 16:07:42','',''),(2117368,'1','149','770',328,'Retail Sale Id 1258558',998.40,0.00,0.00,0.00,59.28,'2021-12-01 16:08:51','',''),(2117369,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:08:51','',''),(2117389,'1','149','770',328,'Retail Sale Id 1258565',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 16:09:42','',''),(2117390,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 16:09:42','',''),(2117438,'1','149','770',328,'Retail Sale Id 1258587',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 16:12:08','',''),(2117439,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 16:12:08','',''),(2117456,'1','149','770',328,'Retail Sale Id 1258600',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 16:13:15','',''),(2117457,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 16:13:15','',''),(2117611,'1','149','770',328,'Retail Sale Id 1258672',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 16:18:48','',''),(2117612,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:18:48','',''),(2117656,'1','149','770',328,'Retail Sale Id 1258693',652.80,0.00,0.00,0.00,38.76,'2021-12-01 16:20:46','',''),(2117657,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-01 16:20:46','',''),(2117686,'1','149','770',328,'Retail Sale Id 1258709',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 16:21:56','',''),(2117687,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:21:56','',''),(2117712,'1','149','770',328,'Retail Sale Id 1258720',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 16:22:56','',''),(2117713,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 16:22:56','',''),(2117736,'1','149','770',328,'Retail Sale Id 1258737',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 16:23:54','',''),(2117737,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 16:23:54','',''),(2117750,'1','149','770',328,'Retail Sale Id 1258744',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 16:24:54','',''),(2117751,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:24:54','',''),(2117776,'1','149','770',328,'Retail Sale Id 1258763',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 16:26:09','',''),(2117777,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 16:26:09','',''),(2117800,'1','149','770',328,'Retail Sale Id 1258783',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 16:27:19','',''),(2117801,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 16:27:19','',''),(2117834,'1','149','770',328,'Retail Sale Id 1258802',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 16:28:51','',''),(2117835,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 16:28:51','',''),(2117886,'1','149','770',328,'Retail Sale Id 1258828',998.40,0.00,0.00,0.00,59.28,'2021-12-01 16:31:17','',''),(2117887,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:31:17','',''),(2118330,'1','149','770',328,'Retail Sale Id 1259060',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 16:53:19','',''),(2118331,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 16:53:19','',''),(2118414,'1','149','770',328,'Retail Sale Id 1259098',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 16:56:25','',''),(2118415,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:56:25','',''),(2118458,'1','149','770',328,'Retail Sale Id 1259121',2598.40,0.00,0.00,0.00,154.28,'2021-12-01 16:58:19','',''),(2118459,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-01 16:58:19','',''),(2118484,'1','149','770',328,'Retail Sale Id 1259135',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 16:59:15','',''),(2118485,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 16:59:15','',''),(2118514,'1','149','770',328,'Retail Sale Id 1259149',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 17:00:36','',''),(2118515,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 17:00:36','',''),(2118540,'1','149','770',328,'Retail Sale Id 1259161',697.60,0.00,0.00,0.00,41.42,'2021-12-01 17:01:45','',''),(2118541,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-01 17:01:45','',''),(2118572,'1','149','770',328,'Retail Sale Id 1259178',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 17:03:15','',''),(2118573,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 17:03:15','',''),(2118600,'1','149','770',328,'Retail Sale Id 1259192',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 17:04:27','',''),(2118601,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 17:04:27','',''),(2118620,'1','149','770',328,'Retail Sale Id 1259200',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 17:05:47','',''),(2118621,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 17:05:47','',''),(2118640,'1','149','770',328,'Retail Sale Id 1259208',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 17:06:44','',''),(2118641,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 17:06:44','',''),(2118664,'1','149','770',328,'Retail Sale Id 1259223',800.00,0.00,0.00,0.00,47.50,'2021-12-01 17:07:52','',''),(2118665,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 17:07:52','',''),(2118704,'1','149','770',328,'Retail Sale Id 1259244',652.80,0.00,0.00,0.00,38.76,'2021-12-01 17:09:48','',''),(2118705,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-01 17:09:48','',''),(2118720,'1','149','770',328,'Retail Sale Id 1259253',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 17:11:06','',''),(2118721,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 17:11:06','',''),(2118740,'1','149','770',328,'Retail Sale Id 1259261',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 17:12:17','',''),(2118741,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 17:12:17','',''),(2118764,'1','149','770',328,'Retail Sale Id 1259276',1299.20,0.00,0.00,0.00,77.14,'2021-12-01 17:13:31','',''),(2118765,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 17:13:31','',''),(2118790,'1','149','770',328,'Retail Sale Id 1259291',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 17:14:59','',''),(2118791,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 17:14:59','',''),(2118834,'1','149','770',328,'Retail Sale Id 1259310',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 17:17:20','',''),(2118835,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 17:17:20','',''),(2118848,'1','149','770',328,'Retail Sale Id 1259317',998.40,0.00,0.00,0.00,59.28,'2021-12-01 17:18:28','',''),(2118849,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 17:18:28','',''),(2118874,'1','149','770',328,'Retail Sale Id 1259332',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 17:20:10','',''),(2118875,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:20:10','',''),(2118892,'1','149','770',328,'Retail Sale Id 1259341',998.40,0.00,0.00,0.00,59.28,'2021-12-01 17:21:24','',''),(2118893,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 17:21:24','',''),(2118914,'1','149','770',328,'Retail Sale Id 1259351',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 17:22:42','',''),(2118915,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 17:22:42','',''),(2118928,'1','149','770',328,'Retail Sale Id 1259358',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 17:23:53','',''),(2118929,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 17:23:53','',''),(2118942,'1','149','770',328,'Retail Sale Id 1259365',4998.40,0.00,0.00,0.00,296.78,'2021-12-01 17:24:43','',''),(2118943,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 17:24:43','',''),(2119238,'1','149','770',328,'Retail Sale Id 1259510',128409.60,0.00,0.00,0.00,7624.32,'2021-12-01 17:45:52','',''),(2119239,'1','149','770',328,'Retail sales',0.00,0.00,0.00,200.64,0.00,'2021-12-01 17:45:52','',''),(2120343,'1','149','770',328,'Retail Sale Id 1259825',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 06:00:24','',''),(2120344,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 06:00:24','',''),(2120357,'1','149','770',328,'Retail Sale Id 1259831',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 06:01:43','',''),(2120358,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 06:01:43','',''),(2120393,'1','149','770',328,'Retail Sale Id 1259850',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 06:04:27','',''),(2120394,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 06:04:27','',''),(2120441,'1','149','770',328,'Retail Sale Id 1259875',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 06:08:37','',''),(2120442,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 06:08:37','',''),(2120453,'1','149','770',328,'Retail Sale Id 1259881',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 06:10:02','',''),(2120454,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 06:10:02','',''),(2120573,'1','149','770',328,'Retail Sale Id 1259937',32000.00,0.00,0.00,0.00,1900.00,'2021-12-02 06:19:13','',''),(2120574,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 06:19:13','',''),(2120694,'1','149','770',328,'Retail Sale Id 1259995',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 06:28:42','',''),(2120695,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 06:28:42','',''),(2120720,'1','149','770',328,'Retail Sale Id 1260011',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 06:30:45','',''),(2120721,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 06:30:45','',''),(2120732,'1','149','770',328,'Retail Sale Id 1260018',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 06:31:45','',''),(2120733,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 06:31:45','',''),(2120750,'1','149','770',328,'Retail Sale Id 1260027',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 06:32:53','',''),(2120751,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 06:32:53','',''),(2120802,'1','149','770',328,'Retail Sale Id 1260055',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 06:36:30','',''),(2120803,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 06:36:30','',''),(2120929,'1','149','770',328,'Retail Sale Id 1260085',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 06:41:32','',''),(2120930,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 06:41:32','',''),(2121096,'1','149','770',328,'Retail Sale Id 1260155',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 06:49:59','',''),(2121097,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 06:49:59','',''),(2121120,'1','149','770',328,'Retail Sale Id 1260166',998.40,0.00,0.00,0.00,59.28,'2021-12-02 06:51:36','',''),(2121121,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 06:51:36','',''),(2121138,'1','149','770',328,'Retail Sale Id 1260176',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 06:52:41','',''),(2121139,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 06:52:41','',''),(2121228,'1','149','770',328,'Retail Sale Id 1260210',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 06:57:45','',''),(2121229,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 06:57:45','',''),(2121310,'1','149','770',328,'Retail Sale Id 1260250',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:02:54','',''),(2121311,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:02:54','',''),(2121342,'1','149','770',328,'Retail Sale Id 1260263',800.00,0.00,0.00,0.00,47.50,'2021-12-02 07:04:32','',''),(2121343,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-02 07:04:32','',''),(2121374,'1','149','770',328,'Retail Sale Id 1260284',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 07:06:20','',''),(2121375,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 07:06:20','',''),(2121384,'1','149','770',328,'Retail Sale Id 1260289',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 07:07:00','',''),(2121385,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:07:00','',''),(2121400,'1','149','770',328,'Retail Sale Id 1260298',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 07:07:54','',''),(2121401,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 07:07:54','',''),(2121554,'1','149','770',328,'Retail Sale Id 1260355',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 07:14:32','',''),(2121555,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 07:14:32','',''),(2121715,'1','149','770',328,'Retail Sale Id 1260430',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 07:22:32','',''),(2121716,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 07:22:32','',''),(2121757,'1','149','770',328,'Retail Sale Id 1260455',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 07:24:54','',''),(2121758,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 07:24:54','',''),(2121783,'1','149','770',328,'Retail Sale Id 1260468',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 07:26:03','',''),(2121784,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 07:26:03','',''),(2121811,'1','149','770',328,'Retail Sale Id 1260483',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 07:27:28','',''),(2121812,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 07:27:28','',''),(2122060,'1','149','770',328,'Retail Sale Id 1260629',998.40,0.00,0.00,0.00,59.28,'2021-12-02 07:40:26','',''),(2122061,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 07:40:26','',''),(2122088,'1','149','770',328,'Retail Sale Id 1260643',4998.40,0.00,0.00,0.00,296.78,'2021-12-02 07:41:37','',''),(2122089,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 07:41:37','',''),(2122114,'1','149','770',328,'Retail Sale Id 1260655',998.40,0.00,0.00,0.00,59.28,'2021-12-02 07:42:24','',''),(2122115,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 07:42:24','',''),(2122371,'1','149','770',328,'Retail Sale Id 1260774',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 07:53:21','',''),(2122372,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 07:53:21','',''),(2122452,'1','149','770',328,'Retail Sale Id 1260810',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 07:56:18','',''),(2122453,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 07:56:18','',''),(2122520,'1','149','770',328,'Retail Sale Id 1260841',2598.40,0.00,0.00,0.00,154.28,'2021-12-02 07:58:51','',''),(2122521,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-02 07:58:51','',''),(2122609,'1','149','770',328,'Retail Sale Id 1260876',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 08:02:10','',''),(2122610,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 08:02:10','',''),(2122623,'1','149','770',328,'Retail Sale Id 1260883',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 08:03:10','',''),(2122624,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 08:03:10','',''),(2122647,'1','149','770',328,'Retail Sale Id 1260893',697.60,0.00,0.00,0.00,41.42,'2021-12-02 08:04:16','',''),(2122648,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 08:04:16','',''),(2122707,'1','149','770',328,'Retail Sale Id 1260921',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 08:07:01','',''),(2122708,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 08:07:01','',''),(2122731,'1','149','770',328,'Retail Sale Id 1260934',7500.80,0.00,0.00,0.00,445.36,'2021-12-02 08:08:00','',''),(2122732,'1','149','770',328,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-02 08:08:00','',''),(2122799,'1','149','770',328,'Retail Sale Id 1260973',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 08:12:13','',''),(2122800,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 08:12:13','',''),(2122813,'1','149','770',328,'Retail Sale Id 1260984',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 08:13:12','',''),(2122814,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 08:13:12','',''),(2122836,'1','149','770',328,'Retail Sale Id 1260993',2598.40,0.00,0.00,0.00,154.28,'2021-12-02 08:13:56','',''),(2122837,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-02 08:13:56','',''),(2122880,'1','149','770',328,'Retail Sale Id 1261018',998.40,0.00,0.00,0.00,59.28,'2021-12-02 08:17:01','',''),(2122881,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 08:17:01','',''),(2122964,'1','149','770',328,'Retail Sale Id 1261064',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 08:20:47','',''),(2122965,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 08:20:47','',''),(2123157,'1','149','770',328,'Retail Sale Id 1261156',2598.40,0.00,0.00,0.00,154.28,'2021-12-02 08:30:25','',''),(2123158,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-02 08:30:25','',''),(2123183,'1','149','770',328,'Retail Sale Id 1261171',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 08:32:23','',''),(2123184,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:32:23','',''),(2123203,'1','149','770',328,'Retail Sale Id 1261181',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 08:33:23','',''),(2123204,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 08:33:23','',''),(2123261,'1','149','770',328,'Retail Sale Id 1261209',998.40,0.00,0.00,0.00,59.28,'2021-12-02 08:36:24','',''),(2123262,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 08:36:24','',''),(2123405,'1','149','770',328,'Retail Sale Id 1261262',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 08:42:11','',''),(2123406,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 08:42:11','',''),(2123489,'1','149','770',328,'Retail Sale Id 1261305',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 08:46:59','',''),(2123490,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:46:59','',''),(2123521,'1','149','770',328,'Retail Sale Id 1261321',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 08:49:25','',''),(2123522,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 08:49:25','',''),(2123601,'1','149','770',328,'Retail Sale Id 1261360',697.60,0.00,0.00,0.00,41.42,'2021-12-02 08:54:16','',''),(2123602,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 08:54:16','',''),(2123615,'1','149','770',328,'Retail Sale Id 1261368',998.40,0.00,0.00,0.00,59.28,'2021-12-02 08:54:55','',''),(2123616,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 08:54:55','',''),(2123637,'1','149','770',328,'Retail Sale Id 1261380',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 08:55:58','',''),(2123638,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 08:55:58','',''),(2123689,'1','149','770',328,'Retail Sale Id 1261405',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 08:58:44','',''),(2123690,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 08:58:44','',''),(2123715,'1','149','770',328,'Retail Sale Id 1261417',1702.40,0.00,0.00,0.00,101.08,'2021-12-02 09:00:08','',''),(2123716,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-02 09:00:08','',''),(2123751,'1','149','770',328,'Retail Sale Id 1261435',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 09:01:38','',''),(2123752,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:01:38','',''),(2123777,'1','149','770',328,'Retail Sale Id 1261463',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 09:03:08','',''),(2123778,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:03:08','',''),(2123815,'1','149','770',328,'Retail Sale Id 1261477',902.40,0.00,0.00,0.00,53.58,'2021-12-02 09:04:57','',''),(2123816,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-02 09:04:57','',''),(2123835,'1','149','770',328,'Retail Sale Id 1261489',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 09:06:07','',''),(2123836,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:06:07','',''),(2123901,'1','149','770',328,'Retail Sale Id 1261526',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 09:09:02','',''),(2123902,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 09:09:02','',''),(2123917,'1','149','770',328,'Retail Sale Id 1261534',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 09:10:05','',''),(2123918,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 09:10:05','',''),(2123977,'1','149','770',328,'Retail Sale Id 1261559',1702.40,0.00,0.00,0.00,101.08,'2021-12-02 09:12:34','',''),(2123978,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-02 09:12:34','',''),(2124087,'1','149','770',328,'Retail Sale Id 1261596',998.40,0.00,0.00,0.00,59.28,'2021-12-02 09:16:45','',''),(2124088,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 09:16:45','',''),(2124119,'1','149','770',328,'Retail Sale Id 1261606',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 09:17:56','',''),(2124120,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 09:17:56','',''),(2124136,'1','149','770',328,'Retail Sale Id 1261616',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 09:18:55','',''),(2124137,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 09:18:55','',''),(2124174,'1','149','770',328,'Retail Sale Id 1261636',1600.00,0.00,0.00,0.00,95.00,'2021-12-02 09:21:01','',''),(2124175,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-02 09:21:01','',''),(2124338,'1','149','770',328,'Retail Sale Id 1261718',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 09:30:51','',''),(2124339,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 09:30:51','',''),(2124397,'1','149','770',328,'Retail Sale Id 1261749',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 09:34:47','',''),(2124398,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 09:34:47','',''),(2124651,'1','149','770',328,'Retail Sale Id 1261873',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 09:50:07','',''),(2124652,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:50:07','',''),(2124751,'1','149','770',328,'Retail Sale Id 1261935',697.60,0.00,0.00,0.00,41.42,'2021-12-02 09:54:22','',''),(2124752,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 09:54:22','',''),(2124776,'1','149','770',328,'Retail Sale Id 1261947',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 09:55:56','',''),(2124777,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 09:55:56','',''),(2124801,'1','149','770',328,'Retail Sale Id 1261959',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 09:57:16','',''),(2124802,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 09:57:16','',''),(2124837,'1','149','770',328,'Retail Sale Id 1261981',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 09:58:34','',''),(2124838,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 09:58:34','',''),(2124853,'1','149','770',328,'Retail Sale Id 1261991',4998.40,0.00,0.00,0.00,296.78,'2021-12-02 09:59:38','',''),(2124854,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 09:59:38','',''),(2124906,'1','149','770',328,'Retail Sale Id 1262010',16000.00,0.00,0.00,0.00,950.00,'2021-12-02 10:02:37','',''),(2124907,'1','149','770',328,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 10:02:37','',''),(2124931,'1','149','770',328,'Retail Sale Id 1262024',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 10:03:39','',''),(2124932,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 10:03:39','',''),(2125017,'1','149','770',328,'Retail Sale Id 1262074',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 10:10:11','',''),(2125018,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 10:10:11','',''),(2125041,'1','149','770',328,'Retail Sale Id 1262081',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 10:11:01','',''),(2125042,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:11:01','',''),(2125053,'1','149','770',328,'Retail Sale Id 1262090',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 10:12:01','',''),(2125054,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 10:12:01','',''),(2125081,'1','149','770',328,'Retail Sale Id 1262104',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 10:13:06','',''),(2125082,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 10:13:06','',''),(2125110,'1','149','770',328,'Retail Sale Id 1262119',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 10:14:51','',''),(2125111,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 10:14:51','',''),(2125134,'1','149','770',328,'Retail Sale Id 1262132',697.60,0.00,0.00,0.00,41.42,'2021-12-02 10:16:10','',''),(2125135,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 10:16:10','',''),(2125146,'1','149','770',328,'Retail Sale Id 1262138',998.40,0.00,0.00,0.00,59.28,'2021-12-02 10:16:55','',''),(2125147,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 10:16:55','',''),(2125160,'1','149','770',328,'Retail Sale Id 1262144',2598.40,0.00,0.00,0.00,154.28,'2021-12-02 10:17:55','',''),(2125161,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-02 10:17:55','',''),(2125176,'1','149','770',328,'Retail Sale Id 1262155',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 10:18:54','',''),(2125177,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 10:18:54','',''),(2125192,'1','149','770',328,'Retail Sale Id 1262161',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 10:19:31','',''),(2125193,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:19:31','',''),(2125206,'1','149','770',328,'Retail Sale Id 1262168',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 10:20:26','',''),(2125207,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 10:20:26','',''),(2125224,'1','149','770',328,'Retail Sale Id 1262179',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 10:21:39','',''),(2125225,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 10:21:39','',''),(2125249,'1','149','770',328,'Retail Sale Id 1262190',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 10:22:38','',''),(2125250,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 10:22:38','',''),(2125291,'1','149','770',328,'Retail Sale Id 1262203',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 10:24:00','',''),(2125292,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 10:24:00','',''),(2125311,'1','149','770',328,'Retail Sale Id 1262211',800.00,0.00,0.00,0.00,47.50,'2021-12-02 10:25:28','',''),(2125312,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-02 10:25:28','',''),(2125360,'1','149','770',328,'Retail Sale Id 1262242',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 10:28:31','',''),(2125361,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:28:31','',''),(2125478,'1','149','770',328,'Retail Sale Id 1262301',998.40,0.00,0.00,0.00,59.28,'2021-12-02 10:36:02','',''),(2125479,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 10:36:02','',''),(2125580,'1','149','770',328,'Retail Sale Id 1262349',6400.00,0.00,0.00,0.00,380.00,'2021-12-02 10:42:18','',''),(2125581,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 10:42:18','',''),(2125620,'1','149','770',328,'Retail Sale Id 1262368',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 10:44:21','',''),(2125621,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 10:44:21','',''),(2125726,'1','149','770',328,'Retail Sale Id 1262415',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 10:51:09','',''),(2125727,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 10:51:09','',''),(2125764,'1','149','770',328,'Retail Sale Id 1262436',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 10:53:43','',''),(2125765,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 10:53:43','',''),(2125824,'1','149','770',328,'Retail Sale Id 1262470',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 10:58:29','',''),(2125825,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 10:58:29','',''),(2125846,'1','149','770',328,'Retail Sale Id 1262481',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 11:00:00','',''),(2125847,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 11:00:00','',''),(2125876,'1','149','770',328,'Retail Sale Id 1262496',998.40,0.00,0.00,0.00,59.28,'2021-12-02 11:01:43','',''),(2125877,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 11:01:43','',''),(2125888,'1','149','770',328,'Retail Sale Id 1262505',800.00,0.00,0.00,0.00,47.50,'2021-12-02 11:02:32','',''),(2125889,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-02 11:02:32','',''),(2125932,'1','149','770',328,'Retail Sale Id 1262527',4998.40,0.00,0.00,0.00,296.78,'2021-12-02 11:05:16','',''),(2125933,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 11:05:16','',''),(2125976,'1','149','770',328,'Retail Sale Id 1262554',998.40,0.00,0.00,0.00,59.28,'2021-12-02 11:07:47','',''),(2125977,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 11:07:47','',''),(2125990,'1','149','770',328,'Retail Sale Id 1262562',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 11:08:52','',''),(2125991,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 11:08:52','',''),(2126360,'1','149','770',328,'Retail Sale Id 1262757',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 11:29:45','',''),(2126361,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 11:29:45','',''),(2126429,'1','149','770',328,'Retail Sale Id 1262781',998.40,0.00,0.00,0.00,59.28,'2021-12-02 11:32:32','',''),(2126430,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 11:32:32','',''),(2126466,'1','149','770',328,'Retail Sale Id 1262797',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 11:34:15','',''),(2126467,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 11:34:15','',''),(2126671,'1','149','770',328,'Retail Sale Id 1262881',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 11:46:41','',''),(2126672,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 11:46:41','',''),(2126727,'1','149','770',328,'Retail Sale Id 1262910',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 11:51:14','',''),(2126728,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 11:51:14','',''),(2126737,'1','149','770',328,'Retail Sale Id 1262918',1798.40,0.00,0.00,0.00,106.78,'2021-12-02 11:52:04','',''),(2126738,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-02 11:52:04','',''),(2126773,'1','149','770',328,'Retail Sale Id 1262939',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 11:54:53','',''),(2126774,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 11:54:53','',''),(2126815,'1','149','770',328,'Retail Sale Id 1262959',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 11:57:31','',''),(2126816,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:57:31','',''),(2126821,'1','149','770',328,'Retail Sale Id 1262965',1203.20,0.00,0.00,0.00,71.44,'2021-12-02 11:58:18','',''),(2126822,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-02 11:58:18','',''),(2126857,'1','149','770',328,'Retail Sale Id 1262980',32000.00,0.00,0.00,0.00,1900.00,'2021-12-02 12:01:22','',''),(2126858,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 12:01:22','',''),(2126889,'1','149','770',328,'Retail Sale Id 1262999',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 12:04:48','',''),(2126890,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 12:04:48','',''),(2126930,'1','149','770',328,'Retail Sale Id 1263019',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 12:08:00','',''),(2126931,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 12:08:00','',''),(2126983,'1','149','770',328,'Retail Sale Id 1263044',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 12:12:26','',''),(2126984,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 12:12:26','',''),(2126997,'1','149','770',328,'Retail Sale Id 1263051',1401.60,0.00,0.00,0.00,83.22,'2021-12-02 12:14:17','',''),(2126998,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-02 12:14:17','',''),(2127096,'1','149','770',328,'Retail Sale Id 1263105',6400.00,0.00,0.00,0.00,380.00,'2021-12-02 12:22:50','',''),(2127097,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 12:22:50','',''),(2127138,'1','149','770',328,'Retail Sale Id 1263122',998.40,0.00,0.00,0.00,59.28,'2021-12-02 12:25:26','',''),(2127139,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 12:25:26','',''),(2127154,'1','149','770',328,'Retail Sale Id 1263131',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 12:26:24','',''),(2127155,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:26:24','',''),(2127172,'1','149','770',328,'Retail Sale Id 1263142',998.40,0.00,0.00,0.00,59.28,'2021-12-02 12:27:29','',''),(2127173,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 12:27:29','',''),(2127180,'1','149','770',328,'Retail Sale Id 1263145',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 12:28:22','',''),(2127181,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 12:28:22','',''),(2127200,'1','149','770',328,'Retail Sale Id 1263155',697.60,0.00,0.00,0.00,41.42,'2021-12-02 12:30:01','',''),(2127201,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 12:30:01','',''),(2127250,'1','149','770',328,'Retail Sale Id 1263200',32000.00,0.00,0.00,0.00,1900.00,'2021-12-02 12:33:22','',''),(2127251,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 12:33:22','',''),(2127260,'1','149','770',328,'Retail Sale Id 1263204',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 12:34:26','',''),(2127261,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 12:34:26','',''),(2127572,'1','149','770',328,'Retail Sale Id 1263346',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 12:58:52','',''),(2127573,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 12:58:52','',''),(2127574,'1','149','770',328,'Retail Sale Id 1263346',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 12:58:52','',''),(2127575,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:58:52','',''),(2127622,'1','149','770',328,'Retail Sale Id 1263372',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 13:01:36','',''),(2127623,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 13:01:36','',''),(2127668,'1','149','770',328,'Retail Sale Id 1263398',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 13:04:54','',''),(2127669,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:04:54','',''),(2127720,'1','149','770',328,'Retail Sale Id 1263424',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 13:09:27','',''),(2127721,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 13:09:27','',''),(2127726,'1','149','770',328,'Retail Sale Id 1263427',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 13:10:08','',''),(2127727,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 13:10:08','',''),(2127740,'1','149','770',328,'Retail Sale Id 1263436',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 13:11:04','',''),(2127741,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 13:11:04','',''),(2127809,'1','149','770',328,'Retail Sale Id 1263467',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 13:15:19','',''),(2127810,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 13:15:19','',''),(2127893,'1','149','770',328,'Retail Sale Id 1263494',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 13:19:18','',''),(2127894,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:19:18','',''),(2128003,'1','149','770',328,'Retail Sale Id 1263537',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 13:26:44','',''),(2128004,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 13:26:44','',''),(2128065,'1','149','770',328,'Retail Sale Id 1263565',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 13:30:57','',''),(2128066,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 13:30:57','',''),(2128240,'1','149','770',328,'Retail Sale Id 1263635',2598.40,0.00,0.00,0.00,154.28,'2021-12-02 13:43:22','',''),(2128241,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-02 13:43:22','',''),(2128254,'1','149','770',328,'Retail Sale Id 1263644',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 13:44:24','',''),(2128255,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:44:24','',''),(2128280,'1','149','770',328,'Retail Sale Id 1263654',2803.20,0.00,0.00,0.00,166.44,'2021-12-02 13:45:41','',''),(2128281,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-02 13:45:41','',''),(2128444,'1','149','770',328,'Retail Sale Id 1263734',7001.60,0.00,0.00,0.00,415.72,'2021-12-02 13:54:56','',''),(2128445,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-02 13:54:56','',''),(2128481,'1','149','770',328,'Retail Sale Id 1263745',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 13:55:58','',''),(2128482,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 13:55:58','',''),(2128501,'1','149','770',328,'Retail Sale Id 1263755',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 13:57:08','',''),(2128502,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 13:57:08','',''),(2128546,'1','149','770',328,'Retail Sale Id 1263772',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 13:59:26','',''),(2128547,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 13:59:26','',''),(2128660,'1','149','770',328,'Retail Sale Id 1263826',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 14:07:19','',''),(2128661,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:07:19','',''),(2128762,'1','149','770',328,'Retail Sale Id 1263869',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 14:13:04','',''),(2128763,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 14:13:04','',''),(2128800,'1','149','770',328,'Retail Sale Id 1263887',2297.60,0.00,0.00,0.00,136.42,'2021-12-02 14:16:03','',''),(2128801,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.59,0.00,'2021-12-02 14:16:03','',''),(2128820,'1','149','770',328,'Retail Sale Id 1263899',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 14:17:15','',''),(2128821,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 14:17:15','',''),(2128901,'1','149','770',328,'Retail Sale Id 1263939',800.00,0.00,0.00,0.00,47.50,'2021-12-02 14:20:39','',''),(2128902,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-02 14:20:39','',''),(2129017,'1','149','770',328,'Retail Sale Id 1263982',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 14:25:44','',''),(2129018,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 14:25:44','',''),(2129156,'1','149','770',328,'Retail Sale Id 1264032',96000.00,0.00,0.00,0.00,5700.00,'2021-12-02 14:30:44','',''),(2129157,'1','149','770',328,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-02 14:30:44','',''),(2129208,'1','149','770',328,'Retail Sale Id 1264046',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 14:32:55','',''),(2129209,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 14:32:55','',''),(2129234,'1','149','770',328,'Retail Sale Id 1264057',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 14:34:33','',''),(2129235,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 14:34:33','',''),(2129264,'1','149','770',328,'Retail Sale Id 1264066',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 14:36:22','',''),(2129265,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:36:22','',''),(2129296,'1','149','770',328,'Retail Sale Id 1264087',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 14:38:08','',''),(2129297,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 14:38:08','',''),(2129325,'1','149','770',328,'Retail Sale Id 1264094',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 14:38:57','',''),(2129326,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 14:38:57','',''),(2129380,'1','149','770',328,'Retail Sale Id 1264112',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 14:40:16','',''),(2129381,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 14:40:16','',''),(2129396,'1','149','770',328,'Retail Sale Id 1264121',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 14:41:20','',''),(2129397,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 14:41:20','',''),(2129449,'1','149','770',328,'Retail Sale Id 1264143',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 14:43:45','',''),(2129450,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 14:43:45','',''),(2129513,'1','149','770',328,'Retail Sale Id 1264181',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 14:48:19','',''),(2129514,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 14:48:19','',''),(2129565,'1','149','770',328,'Retail Sale Id 1264206',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 14:50:52','',''),(2129566,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 14:50:52','',''),(2129583,'1','149','770',328,'Retail Sale Id 1264216',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 14:52:05','',''),(2129584,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 14:52:05','',''),(2129630,'1','149','770',328,'Retail Sale Id 1264239',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 14:55:07','',''),(2129631,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 14:55:07','',''),(2129679,'1','149','770',328,'Retail Sale Id 1264268',6003.20,0.00,0.00,0.00,356.44,'2021-12-02 14:57:09','',''),(2129680,'1','149','770',328,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 14:57:09','',''),(2129701,'1','149','770',328,'Retail Sale Id 1264281',998.40,0.00,0.00,0.00,59.28,'2021-12-02 14:58:23','',''),(2129702,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 14:58:23','',''),(2129725,'1','149','770',328,'Retail Sale Id 1264289',998.40,0.00,0.00,0.00,59.28,'2021-12-02 14:59:28','',''),(2129726,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 14:59:28','',''),(2129827,'1','149','770',328,'Retail Sale Id 1264342',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 15:08:41','',''),(2129828,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 15:08:41','',''),(2129888,'1','149','770',328,'Retail Sale Id 1264370',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 15:12:25','',''),(2129889,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:12:25','',''),(2129908,'1','149','770',328,'Retail Sale Id 1264381',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 15:13:44','',''),(2129909,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 15:13:44','',''),(2129950,'1','149','770',328,'Retail Sale Id 1264404',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 15:15:35','',''),(2129951,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:15:35','',''),(2130114,'1','149','770',328,'Retail Sale Id 1264486',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 15:24:02','',''),(2130115,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 15:24:02','',''),(2130130,'1','149','770',328,'Retail Sale Id 1264494',998.40,0.00,0.00,0.00,59.28,'2021-12-02 15:24:58','',''),(2130131,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 15:24:58','',''),(2130144,'1','149','770',328,'Retail Sale Id 1264502',998.40,0.00,0.00,0.00,59.28,'2021-12-02 15:25:35','',''),(2130145,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 15:25:35','',''),(2130168,'1','149','770',328,'Retail Sale Id 1264511',7801.60,0.00,0.00,0.00,463.22,'2021-12-02 15:26:23','',''),(2130169,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.19,0.00,'2021-12-02 15:26:23','',''),(2130182,'1','149','770',328,'Retail Sale Id 1264519',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 15:27:17','',''),(2130183,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 15:27:17','',''),(2130221,'1','149','770',328,'Retail Sale Id 1264537',998.40,0.00,0.00,0.00,59.28,'2021-12-02 15:28:19','',''),(2130222,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 15:28:19','',''),(2130552,'1','149','770',328,'Retail Sale Id 1264703',998.40,0.00,0.00,0.00,59.28,'2021-12-02 15:43:50','',''),(2130553,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 15:43:50','',''),(2130700,'1','149','770',328,'Retail Sale Id 1264722',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 15:50:50','',''),(2130701,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 15:50:50','',''),(2130718,'1','149','770',328,'Retail Sale Id 1264797',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 15:51:25','',''),(2130719,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:51:25','',''),(2130748,'1','149','770',328,'Retail Sale Id 1264811',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 15:52:30','',''),(2130749,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:52:30','',''),(2130776,'1','149','770',328,'Retail Sale Id 1264823',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 15:53:43','',''),(2130777,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:53:43','',''),(2130826,'1','149','770',328,'Retail Sale Id 1264851',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 15:55:15','',''),(2130827,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 15:55:15','',''),(2130854,'1','149','770',328,'Retail Sale Id 1264866',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 15:56:40','',''),(2130855,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 15:56:40','',''),(2130876,'1','149','770',328,'Retail Sale Id 1264876',697.60,0.00,0.00,0.00,41.42,'2021-12-02 15:57:36','',''),(2130877,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 15:57:36','',''),(2130926,'1','149','770',328,'Retail Sale Id 1264904',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 16:00:16','',''),(2130927,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 16:00:16','',''),(2130946,'1','149','770',328,'Retail Sale Id 1264913',7001.60,0.00,0.00,0.00,415.72,'2021-12-02 16:01:16','',''),(2130947,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-02 16:01:16','',''),(2130978,'1','149','770',328,'Retail Sale Id 1264924',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 16:02:14','',''),(2130979,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 16:02:14','',''),(2130998,'1','149','770',328,'Retail Sale Id 1264935',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 16:03:10','',''),(2130999,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 16:03:10','',''),(2131027,'1','149','770',328,'Retail Sale Id 1264948',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 16:04:33','',''),(2131028,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 16:04:33','',''),(2131060,'1','149','770',328,'Retail Sale Id 1264961',697.60,0.00,0.00,0.00,41.42,'2021-12-02 16:05:55','',''),(2131061,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 16:05:55','',''),(2131086,'1','149','770',328,'Retail Sale Id 1264970',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 16:07:04','',''),(2131087,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 16:07:04','',''),(2131114,'1','149','770',328,'Retail Sale Id 1264980',6003.20,0.00,0.00,0.00,356.44,'2021-12-02 16:07:58','',''),(2131115,'1','149','770',328,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 16:07:58','',''),(2131134,'1','149','770',328,'Retail Sale Id 1264994',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 16:08:45','',''),(2131135,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 16:08:45','',''),(2131156,'1','149','770',328,'Retail Sale Id 1265004',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 16:09:35','',''),(2131157,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 16:09:35','',''),(2131170,'1','149','770',328,'Retail Sale Id 1265012',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 16:10:19','',''),(2131171,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:10:19','',''),(2131192,'1','149','770',328,'Retail Sale Id 1265022',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 16:11:21','',''),(2131193,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 16:11:21','',''),(2131265,'1','149','770',328,'Retail Sale Id 1265063',998.40,0.00,0.00,0.00,59.28,'2021-12-02 16:15:12','',''),(2131266,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 16:15:12','',''),(2131285,'1','149','770',328,'Retail Sale Id 1265072',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 16:16:16','',''),(2131286,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 16:16:16','',''),(2131313,'1','149','770',328,'Retail Sale Id 1265085',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 16:17:18','',''),(2131314,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 16:17:18','',''),(2131329,'1','149','770',328,'Retail Sale Id 1265094',499.20,0.00,0.00,0.00,29.64,'2021-12-02 16:18:33','',''),(2131330,'1','149','770',328,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-02 16:18:33','',''),(2131357,'1','149','770',328,'Retail Sale Id 1265110',4998.40,0.00,0.00,0.00,296.78,'2021-12-02 16:19:50','',''),(2131358,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 16:19:50','',''),(2131373,'1','149','770',328,'Retail Sale Id 1265119',998.40,0.00,0.00,0.00,59.28,'2021-12-02 16:20:53','',''),(2131374,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 16:20:53','',''),(2131390,'1','149','770',328,'Retail Sale Id 1265130',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 16:21:50','',''),(2131391,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 16:21:50','',''),(2131412,'1','149','770',328,'Retail Sale Id 1265137',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 16:22:50','',''),(2131413,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 16:22:50','',''),(2131434,'1','149','770',328,'Retail Sale Id 1265147',998.40,0.00,0.00,0.00,59.28,'2021-12-02 16:23:56','',''),(2131435,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 16:23:56','',''),(2131456,'1','149','770',328,'Retail Sale Id 1265158',998.40,0.00,0.00,0.00,59.28,'2021-12-02 16:25:20','',''),(2131457,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 16:25:20','',''),(2131486,'1','149','770',328,'Retail Sale Id 1265172',1401.60,0.00,0.00,0.00,83.22,'2021-12-02 16:26:21','',''),(2131487,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-02 16:26:21','',''),(2131506,'1','149','770',328,'Retail Sale Id 1265183',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 16:27:20','',''),(2131507,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 16:27:20','',''),(2131542,'1','149','770',328,'Retail Sale Id 1265206',697.60,0.00,0.00,0.00,41.42,'2021-12-02 16:28:57','',''),(2131543,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 16:28:57','',''),(2131600,'1','149','770',328,'Retail Sale Id 1265218',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 16:29:53','',''),(2131601,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 16:29:53','',''),(2131640,'1','149','770',328,'Retail Sale Id 1265236',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 16:31:04','',''),(2131641,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 16:31:04','',''),(2131696,'1','149','770',328,'Retail Sale Id 1265271',3801.60,0.00,0.00,0.00,225.72,'2021-12-02 16:33:45','',''),(2131697,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-02 16:33:45','',''),(2131726,'1','149','770',328,'Retail Sale Id 1265281',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 16:35:12','',''),(2131727,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 16:35:12','',''),(2131740,'1','149','770',328,'Retail Sale Id 1265292',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 16:36:13','',''),(2131741,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 16:36:13','',''),(2131776,'1','149','770',328,'Retail Sale Id 1265312',998.40,0.00,0.00,0.00,59.28,'2021-12-02 16:38:41','',''),(2131777,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 16:38:41','',''),(2131786,'1','149','770',328,'Retail Sale Id 1265315',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 16:39:44','',''),(2131787,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 16:39:44','',''),(2131814,'1','149','770',328,'Retail Sale Id 1265326',1798.40,0.00,0.00,0.00,106.78,'2021-12-02 16:40:38','',''),(2131815,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-02 16:40:38','',''),(2131827,'1','149','770',328,'Retail Sale Id 1265333',998.40,0.00,0.00,0.00,59.28,'2021-12-02 16:41:24','',''),(2131828,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 16:41:24','',''),(2131891,'1','149','770',328,'Retail Sale Id 1265362',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 16:44:10','',''),(2131892,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 16:44:10','',''),(2131913,'1','149','770',328,'Retail Sale Id 1265371',1798.40,0.00,0.00,0.00,106.78,'2021-12-02 16:44:56','',''),(2131914,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-02 16:44:56','',''),(2131946,'1','149','770',328,'Retail Sale Id 1265392',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 16:46:27','',''),(2131947,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:46:27','',''),(2131966,'1','149','770',328,'Retail Sale Id 1265404',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 16:47:15','',''),(2131967,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 16:47:15','',''),(2131986,'1','149','770',328,'Retail Sale Id 1265413',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 16:48:30','',''),(2131987,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:48:30','',''),(2131998,'1','149','770',328,'Retail Sale Id 1265419',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 16:49:42','',''),(2131999,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 16:49:42','',''),(2132018,'1','149','770',328,'Retail Sale Id 1265436',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 16:51:08','',''),(2132019,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:51:08','',''),(2132052,'1','149','770',328,'Retail Sale Id 1265451',697.60,0.00,0.00,0.00,41.42,'2021-12-02 16:53:01','',''),(2132053,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 16:53:01','',''),(2132129,'1','149','770',328,'Retail Sale Id 1265489',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 16:58:01','',''),(2132130,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 16:58:01','',''),(2132197,'1','149','770',328,'Retail Sale Id 1265519',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 17:01:49','',''),(2132198,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 17:01:49','',''),(2132233,'1','149','770',328,'Retail Sale Id 1265532',2598.40,0.00,0.00,0.00,154.28,'2021-12-02 17:03:59','',''),(2132234,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-02 17:03:59','',''),(2132278,'1','149','770',328,'Retail Sale Id 1265556',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 17:06:48','',''),(2132279,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 17:06:48','',''),(2132295,'1','149','770',328,'Retail Sale Id 1265564',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 17:07:58','',''),(2132296,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 17:07:58','',''),(2132321,'1','149','770',328,'Retail Sale Id 1265578',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 17:09:50','',''),(2132322,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 17:09:50','',''),(2132366,'1','149','770',328,'Retail Sale Id 1265598',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 17:12:39','',''),(2132367,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 17:12:39','',''),(2132377,'1','149','770',328,'Retail Sale Id 1265605',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 17:13:38','',''),(2132378,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 17:13:38','',''),(2132398,'1','149','770',328,'Retail Sale Id 1265621',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 17:14:55','',''),(2132399,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 17:14:55','',''),(2132422,'1','149','770',328,'Retail Sale Id 1265629',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 17:16:15','',''),(2132423,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 17:16:15','',''),(2132456,'1','149','770',328,'Retail Sale Id 1265637',998.40,0.00,0.00,0.00,59.28,'2021-12-02 17:17:31','',''),(2132457,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 17:17:31','',''),(2132471,'1','149','770',328,'Retail Sale Id 1265647',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 17:18:37','',''),(2132472,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 17:18:37','',''),(2132497,'1','149','770',328,'Retail Sale Id 1265656',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 17:20:02','',''),(2132498,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 17:20:02','',''),(2132507,'1','149','770',328,'Retail Sale Id 1265661',998.40,0.00,0.00,0.00,59.28,'2021-12-02 17:20:46','',''),(2132508,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 17:20:46','',''),(2132539,'1','149','770',328,'Retail Sale Id 1265671',998.40,0.00,0.00,0.00,59.28,'2021-12-02 17:21:37','',''),(2132540,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 17:21:37','',''),(2132763,'1','149','770',328,'Retail Sale Id 1265777',67897.60,0.00,0.00,0.00,4031.42,'2021-12-02 17:41:27','',''),(2132764,'1','149','770',328,'Retail sales',0.00,0.00,0.00,106.09,0.00,'2021-12-02 17:41:27','',''),(2133912,'1','149','770',328,'Retail Sale Id 1266085',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 06:04:06','',''),(2133913,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 06:04:06','',''),(2133918,'1','149','770',328,'Retail Sale Id 1266090',998.40,0.00,0.00,0.00,59.28,'2021-12-03 06:04:59','',''),(2133919,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 06:04:59','',''),(2133946,'1','149','770',328,'Retail Sale Id 1266103',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 06:08:31','',''),(2133947,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 06:08:31','',''),(2133950,'1','149','770',328,'Retail Sale Id 1266105',998.40,0.00,0.00,0.00,59.28,'2021-12-03 06:09:21','',''),(2133951,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 06:09:21','',''),(2134057,'1','149','770',328,'Retail Sale Id 1266124',998.40,0.00,0.00,0.00,59.28,'2021-12-03 06:15:36','',''),(2134058,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 06:15:36','',''),(2134208,'1','149','770',328,'Retail Sale Id 1266195',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 06:31:16','',''),(2134209,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 06:31:16','',''),(2134234,'1','149','770',328,'Retail Sale Id 1266209',32000.00,0.00,0.00,0.00,1900.00,'2021-12-03 06:33:37','',''),(2134235,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 06:33:37','',''),(2134336,'1','149','770',328,'Retail Sale Id 1266255',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 06:38:51','',''),(2134337,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 06:38:51','',''),(2134411,'1','149','770',328,'Retail Sale Id 1266295',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 06:43:18','',''),(2134412,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 06:43:18','',''),(2134466,'1','149','770',328,'Retail Sale Id 1266323',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 06:45:57','',''),(2134467,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 06:45:57','',''),(2134763,'1','149','770',328,'Retail Sale Id 1266463',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 07:01:54','',''),(2134764,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:01:54','',''),(2134849,'1','149','770',328,'Retail Sale Id 1266518',4499.20,0.00,0.00,0.00,267.14,'2021-12-03 07:07:30','',''),(2134850,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-03 07:07:30','',''),(2134881,'1','149','770',328,'Retail Sale Id 1266535',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 07:09:56','',''),(2134882,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 07:09:56','',''),(2134982,'1','149','770',328,'Retail Sale Id 1266574',998.40,0.00,0.00,0.00,59.28,'2021-12-03 07:14:24','',''),(2134983,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 07:14:24','',''),(2135073,'1','149','770',328,'Retail Sale Id 1266616',15360.00,0.00,0.00,0.00,912.00,'2021-12-03 07:19:12','',''),(2135074,'1','149','770',328,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-03 07:19:12','',''),(2135121,'1','149','770',328,'Retail Sale Id 1266639',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 07:22:00','',''),(2135122,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 07:22:00','',''),(2135139,'1','149','770',328,'Retail Sale Id 1266646',998.40,0.00,0.00,0.00,59.28,'2021-12-03 07:23:00','',''),(2135140,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 07:23:00','',''),(2135166,'1','149','770',328,'Retail Sale Id 1266663',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 07:24:52','',''),(2135167,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 07:24:52','',''),(2135190,'1','149','770',328,'Retail Sale Id 1266675',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 07:26:13','',''),(2135191,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 07:26:13','',''),(2135220,'1','149','770',328,'Retail Sale Id 1266689',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 07:28:12','',''),(2135221,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 07:28:12','',''),(2135232,'1','149','770',328,'Retail Sale Id 1266696',998.40,0.00,0.00,0.00,59.28,'2021-12-03 07:28:59','',''),(2135233,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 07:28:59','',''),(2135248,'1','149','770',328,'Retail Sale Id 1266704',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 07:30:18','',''),(2135249,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 07:30:18','',''),(2135298,'1','149','770',328,'Retail Sale Id 1266730',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 07:33:27','',''),(2135299,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 07:33:27','',''),(2135323,'1','149','770',328,'Retail Sale Id 1266740',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 07:34:28','',''),(2135324,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:34:28','',''),(2135354,'1','149','770',328,'Retail Sale Id 1266756',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 07:35:49','',''),(2135355,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 07:35:49','',''),(2135518,'1','149','770',328,'Retail Sale Id 1266830',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 07:44:44','',''),(2135519,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 07:44:44','',''),(2135552,'1','149','770',328,'Retail Sale Id 1266848',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 07:46:44','',''),(2135553,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 07:46:44','',''),(2135588,'1','149','770',328,'Retail Sale Id 1266862',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 07:48:35','',''),(2135589,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 07:48:35','',''),(2135665,'1','149','770',328,'Retail Sale Id 1266902',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 07:52:05','',''),(2135666,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:52:05','',''),(2135744,'1','149','770',328,'Retail Sale Id 1266935',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 07:56:40','',''),(2135745,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 07:56:40','',''),(2135763,'1','149','770',328,'Retail Sale Id 1266943',998.40,0.00,0.00,0.00,59.28,'2021-12-03 07:57:48','',''),(2135764,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 07:57:48','',''),(2135795,'1','149','770',328,'Retail Sale Id 1266959',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 07:59:35','',''),(2135796,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 07:59:35','',''),(2135931,'1','149','770',328,'Retail Sale Id 1266997',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 08:03:34','',''),(2135932,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 08:03:34','',''),(2135962,'1','149','770',328,'Retail Sale Id 1267016',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 08:04:57','',''),(2135963,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 08:04:57','',''),(2136046,'1','149','770',328,'Retail Sale Id 1267049',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 08:08:25','',''),(2136047,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 08:08:25','',''),(2136088,'1','149','770',328,'Retail Sale Id 1267080',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 08:10:52','',''),(2136089,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 08:10:52','',''),(2136198,'1','149','770',328,'Retail Sale Id 1267142',998.40,0.00,0.00,0.00,59.28,'2021-12-03 08:17:03','',''),(2136199,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 08:17:03','',''),(2136281,'1','149','770',328,'Retail Sale Id 1267183',902.40,0.00,0.00,0.00,53.58,'2021-12-03 08:21:39','',''),(2136282,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-03 08:21:39','',''),(2136394,'1','149','770',328,'Retail Sale Id 1267235',5120.00,0.00,0.00,0.00,304.00,'2021-12-03 08:28:01','',''),(2136395,'1','149','770',328,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 08:28:01','',''),(2136836,'1','149','770',328,'Retail Sale Id 1267376',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 08:47:24','',''),(2136837,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 08:47:24','',''),(2136846,'1','149','770',328,'Retail Sale Id 1267382',1203.20,0.00,0.00,0.00,71.44,'2021-12-03 08:48:06','',''),(2136847,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-03 08:48:06','',''),(2136856,'1','149','770',328,'Retail Sale Id 1267388',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 08:48:47','',''),(2136857,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 08:48:47','',''),(2136866,'1','149','770',328,'Retail Sale Id 1267393',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 08:49:32','',''),(2136867,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 08:49:32','',''),(2136880,'1','149','770',328,'Retail Sale Id 1267400',1299.20,0.00,0.00,0.00,77.14,'2021-12-03 08:50:14','',''),(2136881,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 08:50:14','',''),(2136892,'1','149','770',328,'Retail Sale Id 1267408',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 08:51:03','',''),(2136893,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 08:51:03','',''),(2136904,'1','149','770',328,'Retail Sale Id 1267413',2502.40,0.00,0.00,0.00,148.58,'2021-12-03 08:51:52','',''),(2136905,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 08:51:52','',''),(2136998,'1','149','770',328,'Retail Sale Id 1267461',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 08:57:03','',''),(2136999,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 08:57:03','',''),(2137078,'1','149','770',328,'Retail Sale Id 1267507',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 09:01:27','',''),(2137079,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 09:01:27','',''),(2137196,'1','149','770',328,'Retail Sale Id 1267567',998.40,0.00,0.00,0.00,59.28,'2021-12-03 09:06:52','',''),(2137197,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 09:06:52','',''),(2137221,'1','149','770',328,'Retail Sale Id 1267585',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 09:08:05','',''),(2137222,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 09:08:05','',''),(2137285,'1','149','770',328,'Retail Sale Id 1267626',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 09:11:13','',''),(2137286,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 09:11:13','',''),(2137316,'1','149','770',328,'Retail Sale Id 1267647',3648.00,0.00,0.00,0.00,216.60,'2021-12-03 09:13:02','',''),(2137317,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.70,0.00,'2021-12-03 09:13:02','',''),(2137340,'1','149','770',328,'Retail Sale Id 1267660',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 09:14:13','',''),(2137341,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:14:13','',''),(2137389,'1','149','770',328,'Retail Sale Id 1267687',2502.40,0.00,0.00,0.00,148.58,'2021-12-03 09:16:21','',''),(2137390,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 09:16:21','',''),(2137413,'1','149','770',328,'Retail Sale Id 1267695',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 09:17:29','',''),(2137414,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 09:17:29','',''),(2137529,'1','149','770',328,'Retail Sale Id 1267758',652.80,0.00,0.00,0.00,38.76,'2021-12-03 09:24:21','',''),(2137530,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-03 09:24:21','',''),(2137707,'1','149','770',328,'Retail Sale Id 1267864',1798.40,0.00,0.00,0.00,106.78,'2021-12-03 09:35:49','',''),(2137708,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-03 09:35:49','',''),(2137765,'1','149','770',328,'Retail Sale Id 1267899',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 09:39:27','',''),(2137766,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 09:39:27','',''),(2137777,'1','149','770',328,'Retail Sale Id 1267905',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 09:40:19','',''),(2137778,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:40:19','',''),(2137789,'1','149','770',328,'Retail Sale Id 1267910',1299.20,0.00,0.00,0.00,77.14,'2021-12-03 09:41:23','',''),(2137790,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 09:41:23','',''),(2137823,'1','149','770',328,'Retail Sale Id 1267928',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 09:43:19','',''),(2137824,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 09:43:19','',''),(2137946,'1','149','770',328,'Retail Sale Id 1267983',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 09:50:02','',''),(2137947,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 09:50:02','',''),(2137978,'1','149','770',328,'Retail Sale Id 1268000',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 09:52:05','',''),(2137979,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 09:52:05','',''),(2137988,'1','149','770',328,'Retail Sale Id 1268007',800.00,0.00,0.00,0.00,47.50,'2021-12-03 09:53:04','',''),(2137989,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-03 09:53:04','',''),(2138002,'1','149','770',328,'Retail Sale Id 1268013',697.60,0.00,0.00,0.00,41.42,'2021-12-03 09:53:47','',''),(2138003,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-03 09:53:47','',''),(2138034,'1','149','770',328,'Retail Sale Id 1268029',4998.40,0.00,0.00,0.00,296.78,'2021-12-03 09:56:03','',''),(2138035,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 09:56:03','',''),(2138134,'1','149','770',328,'Retail Sale Id 1268077',4998.40,0.00,0.00,0.00,296.78,'2021-12-03 10:02:06','',''),(2138135,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 10:02:06','',''),(2138152,'1','149','770',328,'Retail Sale Id 1268088',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 10:02:57','',''),(2138153,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:02:57','',''),(2138183,'1','149','770',328,'Retail Sale Id 1268101',998.40,0.00,0.00,0.00,59.28,'2021-12-03 10:05:04','',''),(2138184,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 10:05:04','',''),(2138197,'1','149','770',328,'Retail Sale Id 1268110',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 10:06:04','',''),(2138198,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:06:04','',''),(2138428,'1','149','770',328,'Retail Sale Id 1268226',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 10:18:22','',''),(2138429,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:18:22','',''),(2138452,'1','149','770',328,'Retail Sale Id 1268235',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 10:19:36','',''),(2138453,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 10:19:36','',''),(2138470,'1','149','770',328,'Retail Sale Id 1268241',1299.20,0.00,0.00,0.00,77.14,'2021-12-03 10:20:24','',''),(2138471,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 10:20:24','',''),(2138486,'1','149','770',328,'Retail Sale Id 1268249',998.40,0.00,0.00,0.00,59.28,'2021-12-03 10:21:17','',''),(2138487,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 10:21:17','',''),(2138586,'1','149','770',328,'Retail Sale Id 1268300',2201.60,0.00,0.00,0.00,130.72,'2021-12-03 10:26:54','',''),(2138587,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.44,0.00,'2021-12-03 10:26:54','',''),(2138608,'1','149','770',328,'Retail Sale Id 1268312',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 10:28:55','',''),(2138609,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 10:28:55','',''),(2138631,'1','149','770',328,'Retail Sale Id 1268325',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 10:30:18','',''),(2138632,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 10:30:18','',''),(2138653,'1','149','770',328,'Retail Sale Id 1268336',2502.40,0.00,0.00,0.00,148.58,'2021-12-03 10:31:13','',''),(2138654,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 10:31:13','',''),(2138678,'1','149','770',328,'Retail Sale Id 1268346',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 10:32:48','',''),(2138679,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 10:32:48','',''),(2138745,'1','149','770',328,'Retail Sale Id 1268374',998.40,0.00,0.00,0.00,59.28,'2021-12-03 10:36:58','',''),(2138746,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 10:36:58','',''),(2139067,'1','149','770',328,'Retail Sale Id 1268546',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 11:01:58','',''),(2139068,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 11:01:58','',''),(2139091,'1','149','770',328,'Retail Sale Id 1268557',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 11:03:03','',''),(2139092,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 11:03:03','',''),(2139183,'1','149','770',328,'Retail Sale Id 1268610',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 11:10:53','',''),(2139184,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 11:10:53','',''),(2139195,'1','149','770',328,'Retail Sale Id 1268615',1299.20,0.00,0.00,0.00,77.14,'2021-12-03 11:11:42','',''),(2139196,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 11:11:42','',''),(2139213,'1','149','770',328,'Retail Sale Id 1268625',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 11:13:25','',''),(2139214,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 11:13:25','',''),(2139356,'1','149','770',328,'Retail Sale Id 1268694',998.40,0.00,0.00,0.00,59.28,'2021-12-03 11:23:17','',''),(2139357,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 11:23:17','',''),(2139397,'1','149','770',328,'Retail Sale Id 1268718',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 11:26:38','',''),(2139398,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 11:26:38','',''),(2139439,'1','149','770',328,'Retail Sale Id 1268746',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 11:30:35','',''),(2139440,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 11:30:35','',''),(2139492,'1','149','770',328,'Retail Sale Id 1268769',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 11:34:07','',''),(2139493,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 11:34:07','',''),(2139514,'1','149','770',328,'Retail Sale Id 1268783',998.40,0.00,0.00,0.00,59.28,'2021-12-03 11:36:13','',''),(2139515,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 11:36:13','',''),(2139544,'1','149','770',328,'Retail Sale Id 1268801',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 11:38:35','',''),(2139545,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 11:38:35','',''),(2139564,'1','149','770',328,'Retail Sale Id 1268814',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 11:40:56','',''),(2139565,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 11:40:56','',''),(2139660,'1','149','770',328,'Retail Sale Id 1268868',4000.00,0.00,0.00,0.00,237.50,'2021-12-03 11:47:25','',''),(2139661,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 11:47:25','',''),(2139747,'1','149','770',328,'Retail Sale Id 1268918',1299.20,0.00,0.00,0.00,77.14,'2021-12-03 11:54:30','',''),(2139748,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 11:54:30','',''),(2139761,'1','149','770',328,'Retail Sale Id 1268925',998.40,0.00,0.00,0.00,59.28,'2021-12-03 11:55:26','',''),(2139762,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 11:55:26','',''),(2139795,'1','149','770',328,'Retail Sale Id 1268944',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 11:57:53','',''),(2139796,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 11:57:53','',''),(2139833,'1','149','770',328,'Retail Sale Id 1268964',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 12:00:43','',''),(2139834,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 12:00:43','',''),(2139845,'1','149','770',328,'Retail Sale Id 1268970',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 12:01:39','',''),(2139846,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 12:01:39','',''),(2139861,'1','149','770',328,'Retail Sale Id 1268977',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 12:02:27','',''),(2139862,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 12:02:27','',''),(2139903,'1','149','770',328,'Retail Sale Id 1269007',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 12:04:45','',''),(2139904,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 12:04:45','',''),(2139955,'1','149','770',328,'Retail Sale Id 1269046',2598.40,0.00,0.00,0.00,154.28,'2021-12-03 12:08:14','',''),(2139956,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-03 12:08:14','',''),(2139994,'1','149','770',328,'Retail Sale Id 1269067',1299.20,0.00,0.00,0.00,77.14,'2021-12-03 12:10:23','',''),(2139995,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 12:10:23','',''),(2140050,'1','149','770',328,'Retail Sale Id 1269094',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 12:16:59','',''),(2140051,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 12:16:59','',''),(2140068,'1','149','770',328,'Retail Sale Id 1269103',998.40,0.00,0.00,0.00,59.28,'2021-12-03 12:18:41','',''),(2140069,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 12:18:41','',''),(2140086,'1','149','770',328,'Retail Sale Id 1269115',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 12:21:09','',''),(2140087,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 12:21:09','',''),(2140106,'1','149','770',328,'Retail Sale Id 1269128',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 12:23:52','',''),(2140107,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 12:23:52','',''),(2140130,'1','149','770',328,'Retail Sale Id 1269135',998.40,0.00,0.00,0.00,59.28,'2021-12-03 12:24:37','',''),(2140131,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 12:24:37','',''),(2140149,'1','149','770',328,'Retail Sale Id 1269144',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 12:26:04','',''),(2140150,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 12:26:04','',''),(2140260,'1','149','770',328,'Retail Sale Id 1269216',1900.80,0.00,0.00,0.00,112.86,'2021-12-03 12:35:15','',''),(2140261,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-03 12:35:16','',''),(2140286,'1','149','770',328,'Retail Sale Id 1269231',998.40,0.00,0.00,0.00,59.28,'2021-12-03 12:37:28','',''),(2140287,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 12:37:28','',''),(2140313,'1','149','770',328,'Retail Sale Id 1269243',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 12:39:33','',''),(2140314,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 12:39:33','',''),(2140331,'1','149','770',328,'Retail Sale Id 1269250',998.40,0.00,0.00,0.00,59.28,'2021-12-03 12:40:19','',''),(2140332,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 12:40:19','',''),(2141198,'1','149','770',328,'Retail Sale Id 1269655',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 13:43:25','',''),(2141199,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 13:43:25','',''),(2141219,'1','149','770',328,'Retail Sale Id 1269662',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 13:44:15','',''),(2141220,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 13:44:15','',''),(2141236,'1','149','770',328,'Retail Sale Id 1269672',998.40,0.00,0.00,0.00,59.28,'2021-12-03 13:44:59','',''),(2141237,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 13:44:59','',''),(2141254,'1','149','770',328,'Retail Sale Id 1269680',998.40,0.00,0.00,0.00,59.28,'2021-12-03 13:45:50','',''),(2141255,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 13:45:50','',''),(2141264,'1','149','770',328,'Retail Sale Id 1269687',5120.00,0.00,0.00,0.00,304.00,'2021-12-03 13:46:39','',''),(2141265,'1','149','770',328,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 13:46:39','',''),(2141288,'1','149','770',328,'Retail Sale Id 1269693',998.40,0.00,0.00,0.00,59.28,'2021-12-03 13:47:16','',''),(2141289,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 13:47:16','',''),(2141339,'1','149','770',328,'Retail Sale Id 1269702',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 13:48:08','',''),(2141340,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 13:48:08','',''),(2141415,'1','149','770',328,'Retail Sale Id 1269721',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 13:50:58','',''),(2141416,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 13:50:58','',''),(2141465,'1','149','770',328,'Retail Sale Id 1269742',652.80,0.00,0.00,0.00,38.76,'2021-12-03 13:53:02','',''),(2141466,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-03 13:53:02','',''),(2141481,'1','149','770',328,'Retail Sale Id 1269750',3500.80,0.00,0.00,0.00,207.86,'2021-12-03 13:54:15','',''),(2141482,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-03 13:54:15','',''),(2141501,'1','149','770',328,'Retail Sale Id 1269762',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 13:55:21','',''),(2141502,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 13:55:21','',''),(2141514,'1','149','770',328,'Retail Sale Id 1269766',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 13:56:04','',''),(2141515,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 13:56:04','',''),(2141612,'1','149','770',328,'Retail Sale Id 1269810',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 14:03:35','',''),(2141613,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 14:03:35','',''),(2141639,'1','149','770',328,'Retail Sale Id 1269819',2502.40,0.00,0.00,0.00,148.58,'2021-12-03 14:04:12','',''),(2141640,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 14:04:12','',''),(2141649,'1','149','770',328,'Retail Sale Id 1269824',998.40,0.00,0.00,0.00,59.28,'2021-12-03 14:05:06','',''),(2141650,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 14:05:06','',''),(2141676,'1','149','770',328,'Retail Sale Id 1269834',6400.00,0.00,0.00,0.00,380.00,'2021-12-03 14:06:46','',''),(2141677,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 14:06:46','',''),(2141709,'1','149','770',328,'Retail Sale Id 1269845',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 14:08:03','',''),(2141710,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 14:08:03','',''),(2141717,'1','149','770',328,'Retail Sale Id 1269849',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 14:08:50','',''),(2141718,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 14:08:50','',''),(2141729,'1','149','770',328,'Retail Sale Id 1269855',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 14:09:31','',''),(2141730,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 14:09:31','',''),(2141810,'1','149','770',328,'Retail Sale Id 1269894',1299.20,0.00,0.00,0.00,77.14,'2021-12-03 14:15:55','',''),(2141811,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 14:15:55','',''),(2142028,'1','149','770',328,'Retail Sale Id 1269972',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 14:27:31','',''),(2142029,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 14:27:31','',''),(2142038,'1','149','770',328,'Retail Sale Id 1269980',1299.20,0.00,0.00,0.00,77.14,'2021-12-03 14:28:28','',''),(2142039,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 14:28:28','',''),(2142101,'1','149','770',328,'Retail Sale Id 1270009',998.40,0.00,0.00,0.00,59.28,'2021-12-03 14:32:55','',''),(2142102,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 14:32:55','',''),(2142206,'1','149','770',328,'Retail Sale Id 1270037',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 14:37:40','',''),(2142207,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 14:37:40','',''),(2142221,'1','149','770',328,'Retail Sale Id 1270043',1299.20,0.00,0.00,0.00,77.14,'2021-12-03 14:38:29','',''),(2142222,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 14:38:29','',''),(2142327,'1','149','770',328,'Retail Sale Id 1270082',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 14:43:00','',''),(2142328,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 14:43:00','',''),(2142357,'1','149','770',328,'Retail Sale Id 1270094',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 14:43:52','',''),(2142358,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 14:43:52','',''),(2142375,'1','149','770',328,'Retail Sale Id 1270102',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 14:44:43','',''),(2142376,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 14:44:43','',''),(2142492,'1','149','770',328,'Retail Sale Id 1270164',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 14:49:37','',''),(2142493,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 14:49:37','',''),(2142579,'1','149','770',328,'Retail Sale Id 1270207',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 14:53:42','',''),(2142580,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 14:53:42','',''),(2142589,'1','149','770',328,'Retail Sale Id 1270212',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 14:54:24','',''),(2142590,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 14:54:24','',''),(2142606,'1','149','770',328,'Retail Sale Id 1270219',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 14:55:20','',''),(2142607,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 14:55:20','',''),(2142646,'1','149','770',328,'Retail Sale Id 1270229',1798.40,0.00,0.00,0.00,106.78,'2021-12-03 14:56:15','',''),(2142647,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-03 14:56:15','',''),(2142701,'1','149','770',328,'Retail Sale Id 1270257',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 14:59:45','',''),(2142702,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 14:59:45','',''),(2142734,'1','149','770',328,'Retail Sale Id 1270274',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 15:02:03','',''),(2142735,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 15:02:03','',''),(2142747,'1','149','770',328,'Retail Sale Id 1270280',16000.00,0.00,0.00,0.00,950.00,'2021-12-03 15:03:11','',''),(2142748,'1','149','770',328,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 15:03:11','',''),(2142763,'1','149','770',328,'Retail Sale Id 1270290',998.40,0.00,0.00,0.00,59.28,'2021-12-03 15:04:24','',''),(2142764,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 15:04:24','',''),(2142838,'1','149','770',328,'Retail Sale Id 1270326',1401.60,0.00,0.00,0.00,83.22,'2021-12-03 15:09:06','',''),(2142839,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-03 15:09:06','',''),(2142858,'1','149','770',328,'Retail Sale Id 1270340',2502.40,0.00,0.00,0.00,148.58,'2021-12-03 15:10:06','',''),(2142859,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 15:10:06','',''),(2142897,'1','149','770',328,'Retail Sale Id 1270357',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 15:11:37','',''),(2142898,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 15:11:37','',''),(2142922,'1','149','770',328,'Retail Sale Id 1270368',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 15:13:04','',''),(2142923,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 15:13:04','',''),(2142976,'1','149','770',328,'Retail Sale Id 1270403',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 15:15:08','',''),(2142978,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 15:15:08','',''),(2143002,'1','149','770',328,'Retail Sale Id 1270419',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 15:16:37','',''),(2143003,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:16:37','',''),(2143037,'1','149','770',328,'Retail Sale Id 1270439',4499.20,0.00,0.00,0.00,267.14,'2021-12-03 15:18:19','',''),(2143038,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-03 15:18:19','',''),(2143053,'1','149','770',328,'Retail Sale Id 1270450',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 15:19:14','',''),(2143054,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:19:14','',''),(2143078,'1','149','770',328,'Retail Sale Id 1270464',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 15:20:09','',''),(2143079,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 15:20:09','',''),(2143253,'1','149','770',328,'Retail Sale Id 1270551',4499.20,0.00,0.00,0.00,267.14,'2021-12-03 15:29:24','',''),(2143254,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-03 15:29:24','',''),(2143283,'1','149','770',328,'Retail Sale Id 1270566',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 15:30:40','',''),(2143284,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:30:40','',''),(2143303,'1','149','770',328,'Retail Sale Id 1270573',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 15:31:58','',''),(2143304,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 15:31:58','',''),(2143333,'1','149','770',328,'Retail Sale Id 1270592',8320.00,0.00,0.00,0.00,494.00,'2021-12-03 15:33:33','',''),(2143334,'1','149','770',328,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-03 15:33:33','',''),(2143389,'1','149','770',328,'Retail Sale Id 1270607',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 15:34:56','',''),(2143390,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 15:34:56','',''),(2143425,'1','149','770',328,'Retail Sale Id 1270636',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 15:36:46','',''),(2143426,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 15:36:46','',''),(2143454,'1','149','770',328,'Retail Sale Id 1270650',2502.40,0.00,0.00,0.00,148.58,'2021-12-03 15:37:57','',''),(2143455,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 15:37:57','',''),(2143502,'1','149','770',328,'Retail Sale Id 1270679',1702.40,0.00,0.00,0.00,101.08,'2021-12-03 15:39:51','',''),(2143503,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-03 15:39:51','',''),(2143558,'1','149','770',328,'Retail Sale Id 1270701',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 15:42:10','',''),(2143559,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:42:10','',''),(2143588,'1','149','770',328,'Retail Sale Id 1270717',652.80,0.00,0.00,0.00,38.76,'2021-12-03 15:43:30','',''),(2143589,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-03 15:43:30','',''),(2143626,'1','149','770',328,'Retail Sale Id 1270734',998.40,0.00,0.00,0.00,59.28,'2021-12-03 15:45:03','',''),(2143627,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 15:45:03','',''),(2143654,'1','149','770',328,'Retail Sale Id 1270745',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 15:45:58','',''),(2143655,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 15:45:58','',''),(2143688,'1','149','770',328,'Retail Sale Id 1270770',998.40,0.00,0.00,0.00,59.28,'2021-12-03 15:47:33','',''),(2143689,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 15:47:33','',''),(2143732,'1','149','770',328,'Retail Sale Id 1270781',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 15:48:29','',''),(2143733,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 15:48:29','',''),(2143766,'1','149','770',328,'Retail Sale Id 1270804',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 15:50:34','',''),(2143767,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 15:50:34','',''),(2143784,'1','149','770',328,'Retail Sale Id 1270814',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 15:51:24','',''),(2143785,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 15:51:24','',''),(2144101,'1','149','770',328,'Retail Sale Id 1270973',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 16:06:00','',''),(2144102,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 16:06:00','',''),(2144134,'1','149','770',328,'Retail Sale Id 1270983',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 16:07:06','',''),(2144135,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:07:06','',''),(2144163,'1','149','770',328,'Retail Sale Id 1270996',16000.00,0.00,0.00,0.00,950.00,'2021-12-03 16:08:12','',''),(2144164,'1','149','770',328,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 16:08:12','',''),(2144188,'1','149','770',328,'Retail Sale Id 1271013',998.40,0.00,0.00,0.00,59.28,'2021-12-03 16:09:35','',''),(2144189,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 16:09:35','',''),(2144254,'1','149','770',328,'Retail Sale Id 1271047',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 16:12:42','',''),(2144255,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 16:12:42','',''),(2144294,'1','149','770',328,'Retail Sale Id 1271069',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 16:15:24','',''),(2144295,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:15:24','',''),(2144360,'1','149','770',328,'Retail Sale Id 1271104',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 16:19:06','',''),(2144361,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 16:19:06','',''),(2144450,'1','149','770',328,'Retail Sale Id 1271148',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 16:23:19','',''),(2144451,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:23:19','',''),(2144538,'1','149','770',328,'Retail Sale Id 1271191',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 16:28:13','',''),(2144539,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 16:28:13','',''),(2144592,'1','149','770',328,'Retail Sale Id 1271216',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 16:30:48','',''),(2144593,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 16:30:48','',''),(2144604,'1','149','770',328,'Retail Sale Id 1271222',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 16:31:34','',''),(2144605,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:31:34','',''),(2144626,'1','149','770',328,'Retail Sale Id 1271234',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 16:32:42','',''),(2144627,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:32:42','',''),(2144769,'1','149','770',328,'Retail Sale Id 1271310',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 16:39:42','',''),(2144770,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:39:42','',''),(2144805,'1','149','770',328,'Retail Sale Id 1271329',697.60,0.00,0.00,0.00,41.42,'2021-12-03 16:41:28','',''),(2144806,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-03 16:41:28','',''),(2144826,'1','149','770',328,'Retail Sale Id 1271334',998.40,0.00,0.00,0.00,59.28,'2021-12-03 16:42:09','',''),(2144827,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 16:42:09','',''),(2144915,'1','149','770',328,'Retail Sale Id 1271381',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 16:47:08','',''),(2144916,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:47:08','',''),(2144939,'1','149','770',328,'Retail Sale Id 1271390',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 16:48:23','',''),(2144940,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 16:48:23','',''),(2144993,'1','149','770',328,'Retail Sale Id 1271418',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 16:51:28','',''),(2144994,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:51:28','',''),(2144995,'1','149','770',328,'Retail Sale Id 1271418',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 16:51:28','',''),(2144996,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:51:28','',''),(2145050,'1','149','770',328,'Retail Sale Id 1271436',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 16:53:45','',''),(2145051,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 16:53:45','',''),(2145127,'1','149','770',328,'Retail Sale Id 1271454',2598.40,0.00,0.00,0.00,154.28,'2021-12-03 16:55:59','',''),(2145128,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-03 16:55:59','',''),(2145161,'1','149','770',328,'Retail Sale Id 1271470',998.40,0.00,0.00,0.00,59.28,'2021-12-03 16:57:14','',''),(2145162,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 16:57:14','',''),(2145178,'1','149','770',328,'Retail Sale Id 1271480',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 16:58:18','',''),(2145179,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 16:58:18','',''),(2145204,'1','149','770',328,'Retail Sale Id 1271492',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 17:00:07','',''),(2145205,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 17:00:07','',''),(2145224,'1','149','770',328,'Retail Sale Id 1271502',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 17:01:09','',''),(2145225,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 17:01:09','',''),(2145236,'1','149','770',328,'Retail Sale Id 1271509',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 17:02:14','',''),(2145237,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 17:02:14','',''),(2145284,'1','149','770',328,'Retail Sale Id 1271536',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 17:05:18','',''),(2145285,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 17:05:18','',''),(2145357,'1','149','770',328,'Retail Sale Id 1271574',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 17:12:16','',''),(2145358,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 17:12:16','',''),(2145385,'1','149','770',328,'Retail Sale Id 1271589',6400.00,0.00,0.00,0.00,380.00,'2021-12-03 17:14:06','',''),(2145386,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 17:14:06','',''),(2145447,'1','149','770',328,'Retail Sale Id 1271619',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 17:21:43','',''),(2145448,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 17:21:43','',''),(2145459,'1','149','770',328,'Retail Sale Id 1271626',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 17:23:06','',''),(2145460,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 17:23:06','',''),(2145467,'1','149','770',328,'Retail Sale Id 1271630',998.40,0.00,0.00,0.00,59.28,'2021-12-03 17:24:05','',''),(2145468,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 17:24:05','',''),(2145521,'1','149','770',328,'Retail Sale Id 1271657',998.40,0.00,0.00,0.00,59.28,'2021-12-03 17:30:02','',''),(2145522,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 17:30:02','',''),(2145537,'1','149','770',328,'Retail Sale Id 1271666',3852.80,0.00,0.00,0.00,228.76,'2021-12-03 17:33:07','',''),(2145538,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 17:33:07','',''),(2145544,'1','149','770',328,'Retail Sale Id 1271669',1702.40,0.00,0.00,0.00,101.08,'2021-12-03 17:34:17','',''),(2145545,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-03 17:34:17','',''),(2145591,'1','149','770',328,'Retail Sale Id 1271705',3001.60,0.00,0.00,0.00,178.22,'2021-12-03 17:41:46','',''),(2145592,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 17:41:46','',''),(2145593,'1','149','770',328,'Retail Sale Id 1271705',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 17:41:46','',''),(2145594,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 17:41:46','',''),(2145814,'1','149','770',328,'Retail Sale Id 1271793',97088.00,0.00,0.00,0.00,5764.60,'2021-12-03 18:12:35','',''),(2145815,'1','149','770',328,'Retail sales',0.00,0.00,0.00,151.70,0.00,'2021-12-03 18:12:35','',''),(2146638,'1','149','770',328,'Retail Sale Id 1271998',6003.20,0.00,0.00,0.00,356.44,'2021-12-04 06:08:59','',''),(2146639,'1','149','770',328,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-04 06:08:59','',''),(2146648,'1','149','770',328,'Retail Sale Id 1272002',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 06:10:16','',''),(2146649,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:10:16','',''),(2146654,'1','149','770',328,'Retail Sale Id 1272005',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 06:11:13','',''),(2146655,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 06:11:13','',''),(2146685,'1','149','770',328,'Retail Sale Id 1272013',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 06:13:29','',''),(2146686,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 06:13:29','',''),(2146699,'1','149','770',328,'Retail Sale Id 1272021',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 06:14:55','',''),(2146700,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:14:55','',''),(2146795,'1','149','770',328,'Retail Sale Id 1272046',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 06:20:52','',''),(2146796,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 06:20:52','',''),(2146871,'1','149','770',328,'Retail Sale Id 1272075',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 06:24:58','',''),(2146872,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 06:24:58','',''),(2146906,'1','149','770',328,'Retail Sale Id 1272086',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 06:26:26','',''),(2146907,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 06:26:26','',''),(2146923,'1','149','770',328,'Retail Sale Id 1272094',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 06:27:15','',''),(2146924,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 06:27:15','',''),(2146944,'1','149','770',328,'Retail Sale Id 1272100',2502.40,0.00,0.00,0.00,148.58,'2021-12-04 06:28:02','',''),(2146945,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 06:28:02','',''),(2147000,'1','149','770',328,'Retail Sale Id 1272115',697.60,0.00,0.00,0.00,41.42,'2021-12-04 06:30:18','',''),(2147001,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-04 06:30:18','',''),(2147048,'1','149','770',328,'Retail Sale Id 1272140',32000.00,0.00,0.00,0.00,1900.00,'2021-12-04 06:33:29','',''),(2147049,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 06:33:29','',''),(2147184,'1','149','770',328,'Retail Sale Id 1272202',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 06:40:21','',''),(2147185,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:40:21','',''),(2147249,'1','149','770',328,'Retail Sale Id 1272227',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 06:43:52','',''),(2147250,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 06:43:52','',''),(2147446,'1','149','770',328,'Retail Sale Id 1272316',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 06:54:21','',''),(2147447,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 06:54:21','',''),(2147479,'1','149','770',328,'Retail Sale Id 1272330',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 06:55:47','',''),(2147480,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 06:55:47','',''),(2147512,'1','149','770',328,'Retail Sale Id 1272348',998.40,0.00,0.00,0.00,59.28,'2021-12-04 06:57:12','',''),(2147513,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 06:57:12','',''),(2147572,'1','149','770',328,'Retail Sale Id 1272375',32000.00,0.00,0.00,0.00,1900.00,'2021-12-04 07:00:46','',''),(2147573,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 07:00:46','',''),(2147590,'1','149','770',328,'Retail Sale Id 1272388',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 07:01:41','',''),(2147591,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 07:01:41','',''),(2147631,'1','149','770',328,'Retail Sale Id 1272402',998.40,0.00,0.00,0.00,59.28,'2021-12-04 07:03:27','',''),(2147632,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 07:03:27','',''),(2147707,'1','149','770',328,'Retail Sale Id 1272438',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 07:07:43','',''),(2147708,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 07:07:43','',''),(2147723,'1','149','770',328,'Retail Sale Id 1272446',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 07:08:47','',''),(2147724,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 07:08:47','',''),(2147760,'1','149','770',328,'Retail Sale Id 1272472',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 07:11:32','',''),(2147761,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:11:32','',''),(2147780,'1','149','770',328,'Retail Sale Id 1272482',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 07:12:48','',''),(2147781,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:12:48','',''),(2147841,'1','149','770',328,'Retail Sale Id 1272526',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 07:15:53','',''),(2147842,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:15:53','',''),(2147928,'1','149','770',328,'Retail Sale Id 1272565',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 07:20:00','',''),(2147929,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 07:20:00','',''),(2147942,'1','149','770',328,'Retail Sale Id 1272570',2502.40,0.00,0.00,0.00,148.58,'2021-12-04 07:20:49','',''),(2147943,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 07:20:49','',''),(2148008,'1','149','770',328,'Retail Sale Id 1272604',998.40,0.00,0.00,0.00,59.28,'2021-12-04 07:24:28','',''),(2148009,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 07:24:28','',''),(2148150,'1','149','770',328,'Retail Sale Id 1272675',998.40,0.00,0.00,0.00,59.28,'2021-12-04 07:31:05','',''),(2148151,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 07:31:05','',''),(2148182,'1','149','770',328,'Retail Sale Id 1272693',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 07:32:37','',''),(2148183,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 07:32:37','',''),(2148234,'1','149','770',328,'Retail Sale Id 1272725',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 07:34:57','',''),(2148235,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:34:57','',''),(2148277,'1','149','770',328,'Retail Sale Id 1272749',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 07:37:06','',''),(2148278,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 07:37:06','',''),(2148307,'1','149','770',328,'Retail Sale Id 1272768',998.40,0.00,0.00,0.00,59.28,'2021-12-04 07:38:12','',''),(2148308,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 07:38:12','',''),(2148323,'1','149','770',328,'Retail Sale Id 1272777',998.40,0.00,0.00,0.00,59.28,'2021-12-04 07:39:06','',''),(2148324,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 07:39:06','',''),(2148363,'1','149','770',328,'Retail Sale Id 1272800',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 07:40:36','',''),(2148364,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 07:40:36','',''),(2148378,'1','149','770',328,'Retail Sale Id 1272809',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 07:41:35','',''),(2148379,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 07:41:35','',''),(2148400,'1','149','770',328,'Retail Sale Id 1272836',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 07:42:47','',''),(2148401,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 07:42:47','',''),(2148418,'1','149','770',328,'Retail Sale Id 1272863',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 07:43:58','',''),(2148419,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 07:43:58','',''),(2148438,'1','149','770',328,'Retail Sale Id 1272880',2502.40,0.00,0.00,0.00,148.58,'2021-12-04 07:45:09','',''),(2148439,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 07:45:09','',''),(2148452,'1','149','770',328,'Retail Sale Id 1272893',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 07:46:06','',''),(2148453,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 07:46:06','',''),(2148476,'1','149','770',328,'Retail Sale Id 1272909',5120.00,0.00,0.00,0.00,304.00,'2021-12-04 07:47:43','',''),(2148477,'1','149','770',328,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 07:47:43','',''),(2148922,'1','149','770',328,'Retail Sale Id 1273171',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 08:10:08','',''),(2148923,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 08:10:08','',''),(2148934,'1','149','770',328,'Retail Sale Id 1273178',2502.40,0.00,0.00,0.00,148.58,'2021-12-04 08:10:57','',''),(2148935,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 08:10:57','',''),(2148956,'1','149','770',328,'Retail Sale Id 1273189',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 08:11:42','',''),(2148957,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:11:42','',''),(2149003,'1','149','770',328,'Retail Sale Id 1273210',2598.40,0.00,0.00,0.00,154.28,'2021-12-04 08:13:24','',''),(2149004,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-04 08:13:24','',''),(2149039,'1','149','770',328,'Retail Sale Id 1273225',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 08:14:42','',''),(2149040,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 08:14:42','',''),(2149184,'1','149','770',328,'Retail Sale Id 1273292',998.40,0.00,0.00,0.00,59.28,'2021-12-04 08:20:33','',''),(2149185,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 08:20:33','',''),(2149204,'1','149','770',328,'Retail Sale Id 1273318',652.80,0.00,0.00,0.00,38.76,'2021-12-04 08:21:49','',''),(2149205,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-04 08:21:49','',''),(2149217,'1','149','770',328,'Retail Sale Id 1273354',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 08:22:32','',''),(2149218,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 08:22:32','',''),(2149247,'1','149','770',328,'Retail Sale Id 1273381',998.40,0.00,0.00,0.00,59.28,'2021-12-04 08:23:35','',''),(2149248,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 08:23:35','',''),(2149292,'1','149','770',328,'Retail Sale Id 1273408',1798.40,0.00,0.00,0.00,106.78,'2021-12-04 08:25:34','',''),(2149293,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-04 08:25:34','',''),(2149322,'1','149','770',328,'Retail Sale Id 1273424',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 08:27:11','',''),(2149323,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:27:11','',''),(2149352,'1','149','770',328,'Retail Sale Id 1273436',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 08:28:08','',''),(2149353,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:28:08','',''),(2149370,'1','149','770',328,'Retail Sale Id 1273445',2502.40,0.00,0.00,0.00,148.58,'2021-12-04 08:28:52','',''),(2149371,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 08:28:52','',''),(2149416,'1','149','770',328,'Retail Sale Id 1273471',3500.80,0.00,0.00,0.00,207.86,'2021-12-04 08:30:35','',''),(2149417,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 08:30:35','',''),(2149515,'1','149','770',328,'Retail Sale Id 1273540',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 08:33:20','',''),(2149516,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 08:33:20','',''),(2149541,'1','149','770',328,'Retail Sale Id 1273547',998.40,0.00,0.00,0.00,59.28,'2021-12-04 08:34:05','',''),(2149542,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 08:34:05','',''),(2149560,'1','149','770',328,'Retail Sale Id 1273563',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 08:35:08','',''),(2149561,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:35:08','',''),(2149614,'1','149','770',328,'Retail Sale Id 1273594',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 08:37:30','',''),(2149615,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 08:37:30','',''),(2149664,'1','149','770',328,'Retail Sale Id 1273606',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 08:39:23','',''),(2149665,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 08:39:23','',''),(2149780,'1','149','770',328,'Retail Sale Id 1273666',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 08:44:17','',''),(2149781,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 08:44:17','',''),(2149850,'1','149','770',328,'Retail Sale Id 1273701',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 08:46:45','',''),(2149851,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 08:46:45','',''),(2149900,'1','149','770',328,'Retail Sale Id 1273727',652.80,0.00,0.00,0.00,38.76,'2021-12-04 08:48:55','',''),(2149901,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-04 08:48:55','',''),(2149920,'1','149','770',328,'Retail Sale Id 1273741',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 08:50:05','',''),(2149921,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 08:50:05','',''),(2149936,'1','149','770',328,'Retail Sale Id 1273752',998.40,0.00,0.00,0.00,59.28,'2021-12-04 08:50:57','',''),(2149937,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 08:50:57','',''),(2149970,'1','149','770',328,'Retail Sale Id 1273775',652.80,0.00,0.00,0.00,38.76,'2021-12-04 08:52:46','',''),(2149971,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-04 08:52:46','',''),(2150010,'1','149','770',328,'Retail Sale Id 1273792',998.40,0.00,0.00,0.00,59.28,'2021-12-04 08:54:26','',''),(2150011,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 08:54:26','',''),(2150025,'1','149','770',328,'Retail Sale Id 1273800',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 08:55:11','',''),(2150026,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 08:55:11','',''),(2150055,'1','149','770',328,'Retail Sale Id 1273815',7360.00,0.00,0.00,0.00,437.00,'2021-12-04 08:56:30','',''),(2150056,'1','149','770',328,'Retail sales',0.00,0.00,0.00,11.50,0.00,'2021-12-04 08:56:30','',''),(2150077,'1','149','770',328,'Retail Sale Id 1273828',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 08:57:32','',''),(2150078,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 08:57:32','',''),(2150319,'1','149','770',328,'Retail Sale Id 1273956',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 09:09:29','',''),(2150320,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 09:09:29','',''),(2150369,'1','149','770',328,'Retail Sale Id 1273983',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 09:12:07','',''),(2150370,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 09:12:07','',''),(2150491,'1','149','770',328,'Retail Sale Id 1274045',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 09:18:09','',''),(2150492,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 09:18:09','',''),(2150555,'1','149','770',328,'Retail Sale Id 1274077',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 09:20:36','',''),(2150556,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 09:20:36','',''),(2150579,'1','149','770',328,'Retail Sale Id 1274094',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 09:21:46','',''),(2150580,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 09:21:46','',''),(2150609,'1','149','770',328,'Retail Sale Id 1274110',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 09:23:15','',''),(2150610,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 09:23:15','',''),(2150667,'1','149','770',328,'Retail Sale Id 1274136',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 09:26:18','',''),(2150668,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 09:26:18','',''),(2150708,'1','149','770',328,'Retail Sale Id 1274156',998.40,0.00,0.00,0.00,59.28,'2021-12-04 09:28:27','',''),(2150709,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 09:28:27','',''),(2150738,'1','149','770',328,'Retail Sale Id 1274172',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 09:29:52','',''),(2150739,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 09:29:52','',''),(2150754,'1','149','770',328,'Retail Sale Id 1274182',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 09:30:34','',''),(2150755,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 09:30:34','',''),(2150802,'1','149','770',328,'Retail Sale Id 1274209',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 09:33:04','',''),(2150803,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 09:33:04','',''),(2150818,'1','149','770',328,'Retail Sale Id 1274220',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 09:34:03','',''),(2150819,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 09:34:03','',''),(2150842,'1','149','770',328,'Retail Sale Id 1274231',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 09:34:45','',''),(2150843,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:34:45','',''),(2152442,'1','149','770',328,'Retail Sale Id 1274353',697.60,0.00,0.00,0.00,41.42,'2021-12-04 10:31:59','',''),(2152443,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-04 10:31:59','',''),(2152450,'1','149','770',328,'Retail Sale Id 1274390',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 10:32:50','',''),(2152451,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 10:32:50','',''),(2152463,'1','149','770',328,'Retail Sale Id 1274392',998.40,0.00,0.00,0.00,59.28,'2021-12-04 10:33:33','',''),(2152464,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 10:33:33','',''),(2152474,'1','149','770',328,'Retail Sale Id 1274395',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 10:34:29','',''),(2152475,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 10:34:29','',''),(2152488,'1','149','770',328,'Retail Sale Id 1274401',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 10:35:23','',''),(2152489,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 10:35:23','',''),(2152502,'1','149','770',328,'Retail Sale Id 1274407',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 10:36:36','',''),(2152503,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 10:36:36','',''),(2152517,'1','149','770',328,'Retail Sale Id 1274414',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 10:38:20','',''),(2152518,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 10:38:20','',''),(2152539,'1','149','770',328,'Retail Sale Id 1274427',998.40,0.00,0.00,0.00,59.28,'2021-12-04 10:40:33','',''),(2152540,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 10:40:33','',''),(2152577,'1','149','770',328,'Retail Sale Id 1274436',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 10:42:50','',''),(2152578,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 10:42:50','',''),(2152608,'1','149','770',328,'Retail Sale Id 1274447',998.40,0.00,0.00,0.00,59.28,'2021-12-04 10:44:31','',''),(2152609,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 10:44:31','',''),(2152618,'1','149','770',328,'Retail Sale Id 1274452',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 10:45:35','',''),(2152619,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 10:45:35','',''),(2152640,'1','149','770',328,'Retail Sale Id 1274455',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 10:46:37','',''),(2152641,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 10:46:37','',''),(2152678,'1','149','770',328,'Retail Sale Id 1274474',652.80,0.00,0.00,0.00,38.76,'2021-12-04 10:49:06','',''),(2152679,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-04 10:49:06','',''),(2152696,'1','149','770',328,'Retail Sale Id 1274483',998.40,0.00,0.00,0.00,59.28,'2021-12-04 10:49:56','',''),(2152697,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 10:49:56','',''),(2152730,'1','149','770',328,'Retail Sale Id 1274497',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 10:51:46','',''),(2152731,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 10:51:46','',''),(2152835,'1','149','770',328,'Retail Sale Id 1274540',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 10:57:18','',''),(2152836,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 10:57:18','',''),(2152867,'1','149','770',328,'Retail Sale Id 1274554',998.40,0.00,0.00,0.00,59.28,'2021-12-04 10:59:13','',''),(2152868,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 10:59:13','',''),(2152881,'1','149','770',328,'Retail Sale Id 1274561',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 11:00:16','',''),(2152882,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:00:16','',''),(2152902,'1','149','770',328,'Retail Sale Id 1274569',3500.80,0.00,0.00,0.00,207.86,'2021-12-04 11:01:02','',''),(2152903,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 11:01:02','',''),(2152910,'1','149','770',328,'Retail Sale Id 1274575',998.40,0.00,0.00,0.00,59.28,'2021-12-04 11:01:43','',''),(2152911,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 11:01:43','',''),(2152974,'1','149','770',328,'Retail Sale Id 1274604',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 11:04:42','',''),(2152975,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 11:04:42','',''),(2152994,'1','149','770',328,'Retail Sale Id 1274615',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 11:05:52','',''),(2152995,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 11:05:52','',''),(2152996,'1','149','770',328,'Retail Sale Id 1274615',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 11:05:52','',''),(2152997,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 11:05:52','',''),(2153012,'1','149','770',328,'Retail Sale Id 1274626',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 11:06:51','',''),(2153013,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:06:51','',''),(2153048,'1','149','770',328,'Retail Sale Id 1274644',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 11:08:35','',''),(2153049,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 11:08:35','',''),(2153079,'1','149','770',328,'Retail Sale Id 1274659',998.40,0.00,0.00,0.00,59.28,'2021-12-04 11:10:12','',''),(2153080,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 11:10:12','',''),(2153107,'1','149','770',328,'Retail Sale Id 1274670',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 11:11:15','',''),(2153108,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 11:11:15','',''),(2153173,'1','149','770',328,'Retail Sale Id 1274700',1203.20,0.00,0.00,0.00,71.44,'2021-12-04 11:14:46','',''),(2153174,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-04 11:14:46','',''),(2153193,'1','149','770',328,'Retail Sale Id 1274714',998.40,0.00,0.00,0.00,59.28,'2021-12-04 11:15:36','',''),(2153194,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 11:15:36','',''),(2153219,'1','149','770',328,'Retail Sale Id 1274728',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 11:16:33','',''),(2153220,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 11:16:33','',''),(2153241,'1','149','770',328,'Retail Sale Id 1274739',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 11:17:27','',''),(2153242,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:17:27','',''),(2153265,'1','149','770',328,'Retail Sale Id 1274753',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 11:18:36','',''),(2153266,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 11:18:36','',''),(2153279,'1','149','770',328,'Retail Sale Id 1274759',2502.40,0.00,0.00,0.00,148.58,'2021-12-04 11:19:13','',''),(2153280,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 11:19:13','',''),(2153285,'1','149','770',328,'Retail Sale Id 1274764',998.40,0.00,0.00,0.00,59.28,'2021-12-04 11:19:55','',''),(2153286,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 11:19:55','',''),(2153303,'1','149','770',328,'Retail Sale Id 1274774',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 11:20:42','',''),(2153304,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 11:20:42','',''),(2153331,'1','149','770',328,'Retail Sale Id 1274784',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 11:21:58','',''),(2153332,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 11:21:58','',''),(2153358,'1','149','770',328,'Retail Sale Id 1274795',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 11:23:50','',''),(2153359,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 11:23:50','',''),(2153370,'1','149','770',328,'Retail Sale Id 1274803',998.40,0.00,0.00,0.00,59.28,'2021-12-04 11:24:41','',''),(2153371,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 11:24:41','',''),(2153385,'1','149','770',328,'Retail Sale Id 1274812',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 11:25:50','',''),(2153388,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 11:25:50','',''),(2153404,'1','149','770',328,'Retail Sale Id 1274825',998.40,0.00,0.00,0.00,59.28,'2021-12-04 11:26:49','',''),(2153405,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 11:26:49','',''),(2153416,'1','149','770',328,'Retail Sale Id 1274832',2598.40,0.00,0.00,0.00,154.28,'2021-12-04 11:27:56','',''),(2153417,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-04 11:27:56','',''),(2153442,'1','149','770',328,'Retail Sale Id 1274843',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 11:29:04','',''),(2153444,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:29:04','',''),(2153465,'1','149','770',328,'Retail Sale Id 1274860',652.80,0.00,0.00,0.00,38.76,'2021-12-04 11:30:52','',''),(2153466,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-04 11:30:52','',''),(2153485,'1','149','770',328,'Retail Sale Id 1274869',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 11:31:30','',''),(2153486,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 11:31:30','',''),(2153604,'1','149','770',328,'Retail Sale Id 1274928',6400.00,0.00,0.00,0.00,380.00,'2021-12-04 11:37:06','',''),(2153605,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 11:37:06','',''),(2153643,'1','149','770',328,'Retail Sale Id 1274937',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 11:38:11','',''),(2153644,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 11:38:11','',''),(2153666,'1','149','770',328,'Retail Sale Id 1274946',2502.40,0.00,0.00,0.00,148.58,'2021-12-04 11:39:15','',''),(2153667,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 11:39:15','',''),(2153683,'1','149','770',328,'Retail Sale Id 1274954',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 11:40:35','',''),(2153684,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 11:40:35','',''),(2153701,'1','149','770',328,'Retail Sale Id 1274961',998.40,0.00,0.00,0.00,59.28,'2021-12-04 11:41:48','',''),(2153702,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 11:41:49','',''),(2153735,'1','149','770',328,'Retail Sale Id 1274979',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 11:44:25','',''),(2153736,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 11:44:25','',''),(2153758,'1','149','770',328,'Retail Sale Id 1274988',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 11:45:14','',''),(2153759,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 11:45:14','',''),(2153766,'1','149','770',328,'Retail Sale Id 1274992',998.40,0.00,0.00,0.00,59.28,'2021-12-04 11:45:57','',''),(2153767,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 11:45:57','',''),(2153786,'1','149','770',328,'Retail Sale Id 1275001',998.40,0.00,0.00,0.00,59.28,'2021-12-04 11:46:47','',''),(2153787,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 11:46:47','',''),(2153873,'1','149','770',328,'Retail Sale Id 1275036',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 11:51:42','',''),(2153874,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 11:51:42','',''),(2153899,'1','149','770',328,'Retail Sale Id 1275046',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 11:53:07','',''),(2153900,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 11:53:07','',''),(2153921,'1','149','770',328,'Retail Sale Id 1275054',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 11:54:14','',''),(2153922,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 11:54:14','',''),(2153972,'1','149','770',328,'Retail Sale Id 1275075',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 11:57:15','',''),(2153973,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 11:57:15','',''),(2153986,'1','149','770',328,'Retail Sale Id 1275081',998.40,0.00,0.00,0.00,59.28,'2021-12-04 11:58:36','',''),(2153987,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 11:58:36','',''),(2154031,'1','149','770',328,'Retail Sale Id 1275087',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 11:59:33','',''),(2154032,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 11:59:33','',''),(2154059,'1','149','770',328,'Retail Sale Id 1275095',998.40,0.00,0.00,0.00,59.28,'2021-12-04 12:00:49','',''),(2154060,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 12:00:49','',''),(2154075,'1','149','770',328,'Retail Sale Id 1275100',998.40,0.00,0.00,0.00,59.28,'2021-12-04 12:01:38','',''),(2154076,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 12:01:38','',''),(2154089,'1','149','770',328,'Retail Sale Id 1275107',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 12:02:23','',''),(2154090,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 12:02:23','',''),(2154196,'1','149','770',328,'Retail Sale Id 1275128',998.40,0.00,0.00,0.00,59.28,'2021-12-04 12:05:46','',''),(2154197,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 12:05:46','',''),(2154226,'1','149','770',328,'Retail Sale Id 1275143',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 12:07:24','',''),(2154227,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 12:07:24','',''),(2154238,'1','149','770',328,'Retail Sale Id 1275149',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 12:08:21','',''),(2154239,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 12:08:21','',''),(2154254,'1','149','770',328,'Retail Sale Id 1275158',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 12:09:14','',''),(2154255,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 12:09:14','',''),(2154315,'1','149','770',328,'Retail Sale Id 1275188',697.60,0.00,0.00,0.00,41.42,'2021-12-04 12:12:43','',''),(2154316,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-04 12:12:43','',''),(2154325,'1','149','770',328,'Retail Sale Id 1275193',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 12:13:31','',''),(2154326,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 12:13:31','',''),(2154355,'1','149','770',328,'Retail Sale Id 1275212',4998.40,0.00,0.00,0.00,296.78,'2021-12-04 12:15:15','',''),(2154356,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 12:15:15','',''),(2154387,'1','149','770',328,'Retail Sale Id 1275226',998.40,0.00,0.00,0.00,59.28,'2021-12-04 12:17:58','',''),(2154388,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 12:17:58','',''),(2154397,'1','149','770',328,'Retail Sale Id 1275233',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 12:19:03','',''),(2154398,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 12:19:03','',''),(2154413,'1','149','770',328,'Retail Sale Id 1275242',998.40,0.00,0.00,0.00,59.28,'2021-12-04 12:20:23','',''),(2154414,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 12:20:23','',''),(2154477,'1','149','770',328,'Retail Sale Id 1275277',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 12:24:35','',''),(2154478,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 12:24:35','',''),(2154491,'1','149','770',328,'Retail Sale Id 1275284',998.40,0.00,0.00,0.00,59.28,'2021-12-04 12:25:26','',''),(2154492,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 12:25:26','',''),(2154581,'1','149','770',328,'Retail Sale Id 1275324',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 12:29:47','',''),(2154582,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 12:29:47','',''),(2154611,'1','149','770',328,'Retail Sale Id 1275340',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 12:31:18','',''),(2154612,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 12:31:18','',''),(2154886,'1','149','770',328,'Retail Sale Id 1275469',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 12:49:50','',''),(2154887,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 12:49:50','',''),(2154898,'1','149','770',328,'Retail Sale Id 1275475',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 12:50:45','',''),(2154899,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 12:50:45','',''),(2154960,'1','149','770',328,'Retail Sale Id 1275500',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 12:54:12','',''),(2154961,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 12:54:12','',''),(2155057,'1','149','770',328,'Retail Sale Id 1275766',1203.20,0.00,0.00,0.00,71.44,'2021-12-04 13:07:12','',''),(2155058,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-04 13:07:12','',''),(2155067,'1','149','770',328,'Retail Sale Id 1275772',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 13:07:55','',''),(2155068,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 13:07:55','',''),(2155081,'1','149','770',328,'Retail Sale Id 1275779',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 13:09:06','',''),(2155082,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 13:09:06','',''),(2155106,'1','149','770',328,'Retail Sale Id 1275788',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 13:10:33','',''),(2155107,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 13:10:33','',''),(2155151,'1','149','770',328,'Retail Sale Id 1275808',2502.40,0.00,0.00,0.00,148.58,'2021-12-04 13:13:40','',''),(2155152,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 13:13:40','',''),(2155195,'1','149','770',328,'Retail Sale Id 1275830',32000.00,0.00,0.00,0.00,1900.00,'2021-12-04 13:15:52','',''),(2155196,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 13:15:52','',''),(2155266,'1','149','770',328,'Retail Sale Id 1275855',1203.20,0.00,0.00,0.00,71.44,'2021-12-04 13:20:49','',''),(2155267,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-04 13:20:49','',''),(2155290,'1','149','770',328,'Retail Sale Id 1275862',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 13:21:52','',''),(2155291,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 13:21:52','',''),(2155380,'1','149','770',328,'Retail Sale Id 1275893',3500.80,0.00,0.00,0.00,207.86,'2021-12-04 13:25:48','',''),(2155381,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 13:25:48','',''),(2155437,'1','149','770',328,'Retail Sale Id 1275906',4902.40,0.00,0.00,0.00,291.08,'2021-12-04 13:27:14','',''),(2155438,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.66,0.00,'2021-12-04 13:27:14','',''),(2155537,'1','149','770',328,'Retail Sale Id 1275955',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 13:32:57','',''),(2155538,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 13:32:57','',''),(2155559,'1','149','770',328,'Retail Sale Id 1275967',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 13:34:34','',''),(2155560,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 13:34:34','',''),(2155586,'1','149','770',328,'Retail Sale Id 1275976',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 13:35:56','',''),(2155587,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 13:35:56','',''),(2155654,'1','149','770',328,'Retail Sale Id 1276010',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 13:39:58','',''),(2155655,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 13:39:58','',''),(2155676,'1','149','770',328,'Retail Sale Id 1276020',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 13:41:14','',''),(2155677,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 13:41:14','',''),(2155712,'1','149','770',328,'Retail Sale Id 1276042',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 13:42:50','',''),(2155713,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 13:42:50','',''),(2155734,'1','149','770',328,'Retail Sale Id 1276053',998.40,0.00,0.00,0.00,59.28,'2021-12-04 13:44:12','',''),(2155735,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 13:44:12','',''),(2155786,'1','149','770',328,'Retail Sale Id 1276079',2598.40,0.00,0.00,0.00,154.28,'2021-12-04 13:46:56','',''),(2155787,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-04 13:46:56','',''),(2155882,'1','149','770',328,'Retail Sale Id 1276109',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 13:50:18','',''),(2155883,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 13:50:18','',''),(2155898,'1','149','770',328,'Retail Sale Id 1276119',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 13:51:18','',''),(2155899,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 13:51:18','',''),(2155934,'1','149','770',328,'Retail Sale Id 1276137',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 13:53:25','',''),(2155936,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 13:53:25','',''),(2155946,'1','149','770',328,'Retail Sale Id 1276144',998.40,0.00,0.00,0.00,59.28,'2021-12-04 13:54:34','',''),(2155947,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 13:54:34','',''),(2156037,'1','149','770',328,'Retail Sale Id 1276185',2598.40,0.00,0.00,0.00,154.28,'2021-12-04 13:58:53','',''),(2156038,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-04 13:58:53','',''),(2156080,'1','149','770',328,'Retail Sale Id 1276204',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 14:00:55','',''),(2156081,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 14:00:55','',''),(2156134,'1','149','770',328,'Retail Sale Id 1276219',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 14:02:48','',''),(2156135,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 14:02:48','',''),(2156170,'1','149','770',328,'Retail Sale Id 1276241',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 14:04:16','',''),(2156171,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 14:04:16','',''),(2156261,'1','149','770',328,'Retail Sale Id 1276275',1798.40,0.00,0.00,0.00,106.78,'2021-12-04 14:07:19','',''),(2156262,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-04 14:07:19','',''),(2156315,'1','149','770',328,'Retail Sale Id 1276306',998.40,0.00,0.00,0.00,59.28,'2021-12-04 14:10:14','',''),(2156316,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 14:10:14','',''),(2156333,'1','149','770',328,'Retail Sale Id 1276316',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 14:11:16','',''),(2156334,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 14:11:16','',''),(2156347,'1','149','770',328,'Retail Sale Id 1276324',998.40,0.00,0.00,0.00,59.28,'2021-12-04 14:12:07','',''),(2156348,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 14:12:07','',''),(2156369,'1','149','770',328,'Retail Sale Id 1276333',1401.60,0.00,0.00,0.00,83.22,'2021-12-04 14:12:59','',''),(2156370,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-04 14:12:59','',''),(2156406,'1','149','770',328,'Retail Sale Id 1276347',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 14:14:05','',''),(2156407,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 14:14:05','',''),(2156424,'1','149','770',328,'Retail Sale Id 1276354',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 14:14:52','',''),(2156425,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 14:14:52','',''),(2156448,'1','149','770',328,'Retail Sale Id 1276367',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 14:16:01','',''),(2156449,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 14:16:01','',''),(2156512,'1','149','770',328,'Retail Sale Id 1276401',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 14:18:50','',''),(2156513,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 14:18:50','',''),(2156532,'1','149','770',328,'Retail Sale Id 1276412',998.40,0.00,0.00,0.00,59.28,'2021-12-04 14:19:50','',''),(2156533,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 14:19:50','',''),(2156546,'1','149','770',328,'Retail Sale Id 1276419',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 14:20:37','',''),(2156547,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 14:20:37','',''),(2156556,'1','149','770',328,'Retail Sale Id 1276425',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 14:21:35','',''),(2156557,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 14:21:35','',''),(2156681,'1','149','770',328,'Retail Sale Id 1276485',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 14:28:34','',''),(2156682,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 14:28:34','',''),(2156735,'1','149','770',328,'Retail Sale Id 1276511',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 14:32:09','',''),(2156736,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 14:32:09','',''),(2156764,'1','149','770',328,'Retail Sale Id 1276527',2598.40,0.00,0.00,0.00,154.28,'2021-12-04 14:33:51','',''),(2156765,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-04 14:33:51','',''),(2156800,'1','149','770',328,'Retail Sale Id 1276541',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 14:35:12','',''),(2156801,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 14:35:12','',''),(2156816,'1','149','770',328,'Retail Sale Id 1276552',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 14:36:32','',''),(2156817,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 14:36:32','',''),(2156856,'1','149','770',328,'Retail Sale Id 1276570',998.40,0.00,0.00,0.00,59.28,'2021-12-04 14:38:26','',''),(2156857,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 14:38:26','',''),(2156868,'1','149','770',328,'Retail Sale Id 1276576',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 14:39:10','',''),(2156869,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 14:39:10','',''),(2156886,'1','149','770',328,'Retail Sale Id 1276584',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 14:40:01','',''),(2156887,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 14:40:01','',''),(2156919,'1','149','770',328,'Retail Sale Id 1276595',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 14:42:27','',''),(2156920,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 14:42:27','',''),(2156944,'1','149','770',328,'Retail Sale Id 1276602',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 14:43:18','',''),(2156945,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 14:43:18','',''),(2157112,'1','149','770',328,'Retail Sale Id 1276654',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 14:50:11','',''),(2157113,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 14:50:11','',''),(2157128,'1','149','770',328,'Retail Sale Id 1276663',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 14:51:08','',''),(2157129,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 14:51:08','',''),(2157171,'1','149','770',328,'Retail Sale Id 1276680',998.40,0.00,0.00,0.00,59.28,'2021-12-04 14:53:42','',''),(2157172,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 14:53:42','',''),(2157179,'1','149','770',328,'Retail Sale Id 1276688',652.80,0.00,0.00,0.00,38.76,'2021-12-04 14:54:29','',''),(2157180,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-04 14:54:29','',''),(2157204,'1','149','770',328,'Retail Sale Id 1276694',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 14:55:28','',''),(2157205,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 14:55:28','',''),(2157252,'1','149','770',328,'Retail Sale Id 1276707',998.40,0.00,0.00,0.00,59.28,'2021-12-04 14:57:25','',''),(2157253,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 14:57:25','',''),(2157291,'1','149','770',328,'Retail Sale Id 1276724',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 14:58:46','',''),(2157292,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 14:58:46','',''),(2157338,'1','149','770',328,'Retail Sale Id 1276746',902.40,0.00,0.00,0.00,53.58,'2021-12-04 15:01:39','',''),(2157339,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-04 15:01:39','',''),(2157412,'1','149','770',328,'Retail Sale Id 1276775',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 15:05:13','',''),(2157413,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:05:13','',''),(2158046,'1','149','770',328,'Retail Sale Id 1277064',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 15:36:00','',''),(2158047,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 15:36:00','',''),(2158060,'1','149','770',328,'Retail Sale Id 1277070',1798.40,0.00,0.00,0.00,106.78,'2021-12-04 15:36:47','',''),(2158061,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-04 15:36:47','',''),(2158102,'1','149','770',328,'Retail Sale Id 1277091',998.40,0.00,0.00,0.00,59.28,'2021-12-04 15:39:21','',''),(2158103,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 15:39:21','',''),(2158130,'1','149','770',328,'Retail Sale Id 1277104',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 15:40:39','',''),(2158131,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 15:40:39','',''),(2158154,'1','149','770',328,'Retail Sale Id 1277115',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 15:41:40','',''),(2158155,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 15:41:40','',''),(2158168,'1','149','770',328,'Retail Sale Id 1277124',1203.20,0.00,0.00,0.00,71.44,'2021-12-04 15:42:25','',''),(2158169,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-04 15:42:25','',''),(2158183,'1','149','770',328,'Retail Sale Id 1277130',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 15:43:11','',''),(2158184,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 15:43:11','',''),(2158205,'1','149','770',328,'Retail Sale Id 1277142',1548.80,0.00,0.00,0.00,91.96,'2021-12-04 15:44:07','',''),(2158206,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.42,0.00,'2021-12-04 15:44:07','',''),(2158230,'1','149','770',328,'Retail Sale Id 1277152',998.40,0.00,0.00,0.00,59.28,'2021-12-04 15:45:01','',''),(2158231,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 15:45:01','',''),(2158248,'1','149','770',328,'Retail Sale Id 1277161',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 15:45:53','',''),(2158249,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 15:45:53','',''),(2158260,'1','149','770',328,'Retail Sale Id 1277165',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 15:46:46','',''),(2158261,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 15:46:46','',''),(2158307,'1','149','770',328,'Retail Sale Id 1277183',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 15:48:15','',''),(2158308,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 15:48:15','',''),(2158323,'1','149','770',328,'Retail Sale Id 1277192',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 15:49:28','',''),(2158324,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 15:49:28','',''),(2158370,'1','149','770',328,'Retail Sale Id 1277213',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 15:51:45','',''),(2158371,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:51:45','',''),(2158388,'1','149','770',328,'Retail Sale Id 1277225',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 15:52:52','',''),(2158389,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 15:52:52','',''),(2158420,'1','149','770',328,'Retail Sale Id 1277240',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 15:54:22','',''),(2158421,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 15:54:22','',''),(2158438,'1','149','770',328,'Retail Sale Id 1277249',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 15:55:24','',''),(2158439,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 15:55:24','',''),(2158478,'1','149','770',328,'Retail Sale Id 1277279',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 15:56:57','',''),(2158479,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 15:56:57','',''),(2158494,'1','149','770',328,'Retail Sale Id 1277289',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 15:57:43','',''),(2158495,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 15:57:43','',''),(2158533,'1','149','770',328,'Retail Sale Id 1277313',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 15:59:37','',''),(2158534,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:59:37','',''),(2158557,'1','149','770',328,'Retail Sale Id 1277325',652.80,0.00,0.00,0.00,38.76,'2021-12-04 16:00:38','',''),(2158558,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-04 16:00:38','',''),(2158575,'1','149','770',328,'Retail Sale Id 1277336',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 16:01:34','',''),(2158576,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 16:01:34','',''),(2158606,'1','149','770',328,'Retail Sale Id 1277349',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 16:02:31','',''),(2158607,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 16:02:31','',''),(2158626,'1','149','770',328,'Retail Sale Id 1277359',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 16:04:23','',''),(2158627,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 16:04:23','',''),(2158648,'1','149','770',328,'Retail Sale Id 1277370',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 16:05:38','',''),(2158649,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:05:38','',''),(2158696,'1','149','770',328,'Retail Sale Id 1277395',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 16:07:51','',''),(2158697,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 16:07:51','',''),(2158712,'1','149','770',328,'Retail Sale Id 1277405',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 16:08:39','',''),(2158713,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 16:08:39','',''),(2158743,'1','149','770',328,'Retail Sale Id 1277419',1299.20,0.00,0.00,0.00,77.14,'2021-12-04 16:10:06','',''),(2158744,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 16:10:06','',''),(2158827,'1','149','770',328,'Retail Sale Id 1277467',4499.20,0.00,0.00,0.00,267.14,'2021-12-04 16:13:56','',''),(2158828,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-04 16:13:56','',''),(2158851,'1','149','770',328,'Retail Sale Id 1277478',5497.60,0.00,0.00,0.00,326.42,'2021-12-04 16:14:46','',''),(2158852,'1','149','770',328,'Retail sales',0.00,0.00,0.00,8.59,0.00,'2021-12-04 16:14:46','',''),(2158879,'1','149','770',328,'Retail Sale Id 1277493',1952.00,0.00,0.00,0.00,115.90,'2021-12-04 16:15:48','',''),(2158880,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 16:15:48','',''),(2158891,'1','149','770',328,'Retail Sale Id 1277499',2598.40,0.00,0.00,0.00,154.28,'2021-12-04 16:16:39','',''),(2158892,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-04 16:16:39','',''),(2158911,'1','149','770',328,'Retail Sale Id 1277508',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 16:17:38','',''),(2158912,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 16:17:38','',''),(2158945,'1','149','770',328,'Retail Sale Id 1277525',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 16:19:16','',''),(2158946,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 16:19:16','',''),(2158985,'1','149','770',328,'Retail Sale Id 1277547',2598.40,0.00,0.00,0.00,154.28,'2021-12-04 16:21:24','',''),(2158986,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-04 16:21:24','',''),(2159007,'1','149','770',328,'Retail Sale Id 1277556',998.40,0.00,0.00,0.00,59.28,'2021-12-04 16:22:07','',''),(2159008,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 16:22:07','',''),(2159021,'1','149','770',328,'Retail Sale Id 1277563',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 16:22:56','',''),(2159022,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:22:56','',''),(2159059,'1','149','770',328,'Retail Sale Id 1277589',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 16:24:34','',''),(2159060,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:24:34','',''),(2159099,'1','149','770',328,'Retail Sale Id 1277610',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 16:26:12','',''),(2159100,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 16:26:12','',''),(2159131,'1','149','770',328,'Retail Sale Id 1277625',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 16:27:21','',''),(2159132,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:27:21','',''),(2159159,'1','149','770',328,'Retail Sale Id 1277640',1497.60,0.00,0.00,0.00,88.92,'2021-12-04 16:28:32','',''),(2159160,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 16:28:32','',''),(2159179,'1','149','770',328,'Retail Sale Id 1277649',3001.60,0.00,0.00,0.00,178.22,'2021-12-04 16:29:32','',''),(2159180,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 16:29:32','',''),(2159201,'1','149','770',328,'Retail Sale Id 1277663',2598.40,0.00,0.00,0.00,154.28,'2021-12-04 16:30:35','',''),(2159202,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-04 16:30:35','',''),(2159215,'1','149','770',328,'Retail Sale Id 1277669',2003.20,0.00,0.00,0.00,118.94,'2021-12-04 16:31:15','',''),(2159216,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 16:31:15','',''),(2159236,'1','149','770',328,'Retail Sale Id 1277677',652.80,0.00,0.00,0.00,38.76,'2021-12-04 16:31:52','',''),(2159240,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-04 16:31:52','',''),(2159249,'1','149','770',328,'Retail Sale Id 1277683',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 16:32:44','',''),(2159250,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:32:44','',''),(2159263,'1','149','770',328,'Retail Sale Id 1277689',3852.80,0.00,0.00,0.00,228.76,'2021-12-04 16:33:45','',''),(2159264,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 16:33:45','',''),(2159279,'1','149','770',328,'Retail Sale Id 1277696',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 16:34:54','',''),(2159280,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:34:54','',''),(2160586,'1','149','770',328,'Retail Sale Id 1278295',198400.00,0.00,0.00,0.00,11780.00,'2021-12-04 17:44:33','',''),(2160587,'1','149','770',328,'Retail sales',0.00,0.00,0.00,310.00,0.00,'2021-12-04 17:44:33','',''),(2160672,'1','149',NULL,328,'Purchased from AA RANO NIGERIA LIMITED',0.00,30100.00,50.00,0.00,0.00,'2021-12-04 17:49:44','',''),(2160682,'1','149',NULL,328,'Reception corrector for bridging 126235',0.00,0.00,0.00,50.00,0.00,'2021-12-04 17:50:39','',''),(2160683,'1','149','770',328,'Received from bridging 126235',0.00,0.00,50.00,0.00,0.00,'2021-12-04 17:50:39','',''),(2160688,'1','149','770',328,'Retail Sale Id 1278330',32640.00,0.00,0.00,0.00,1938.00,'2021-12-04 17:51:06','',''),(2160689,'1','149','770',328,'Retail sales',0.00,0.00,0.00,51.00,0.00,'2021-12-04 17:51:06','',''),(2162685,'1','149',NULL,328,'Purchased from AA RANO NIGERIA LIMITED',0.00,1776000.00,3000.00,0.00,0.00,'2021-12-05 06:58:16','',''),(2162692,'1','149',NULL,328,'Reception corrector for bridging 126276',0.00,0.00,0.00,3000.00,0.00,'2021-12-05 06:59:04','',''),(2162693,'1','149','770',328,'Received from bridging 126276',0.00,0.00,3000.00,0.00,0.00,'2021-12-05 06:59:04','',''),(2162708,'1','149','770',328,'Retail Sale Id 1278974',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 06:59:50','',''),(2162709,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 06:59:50','',''),(2162730,'1','149','770',328,'Retail Sale Id 1278981',998.40,0.00,0.00,0.00,74.88,'2021-12-05 07:01:35','',''),(2162731,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 07:01:35','',''),(2162742,'1','149','770',328,'Retail Sale Id 1278992',4499.20,0.00,0.00,0.00,337.44,'2021-12-05 07:02:39','',''),(2162743,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-05 07:02:39','',''),(2162766,'1','149','770',328,'Retail Sale Id 1279005',2502.40,0.00,0.00,0.00,187.68,'2021-12-05 07:03:33','',''),(2162767,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 07:03:33','',''),(2162789,'1','149','770',328,'Retail Sale Id 1279014',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 07:04:30','',''),(2162790,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 07:04:30','',''),(2162821,'1','149','770',328,'Retail Sale Id 1279023',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 07:06:11','',''),(2162822,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 07:06:11','',''),(2162837,'1','149','770',328,'Retail Sale Id 1279037',800.00,0.00,0.00,0.00,60.00,'2021-12-05 07:07:10','',''),(2162838,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-05 07:07:10','',''),(2162853,'1','149','770',328,'Retail Sale Id 1279043',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 07:08:03','',''),(2162854,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 07:08:03','',''),(2162877,'1','149','770',328,'Retail Sale Id 1279058',3852.80,0.00,0.00,0.00,288.96,'2021-12-05 07:09:05','',''),(2162879,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 07:09:05','',''),(2162909,'1','149','770',328,'Retail Sale Id 1279077',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 07:11:11','',''),(2162910,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:11:11','',''),(2162923,'1','149','770',328,'Retail Sale Id 1279085',998.40,0.00,0.00,0.00,74.88,'2021-12-05 07:11:50','',''),(2162924,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 07:11:50','',''),(2162951,'1','149','770',328,'Retail Sale Id 1279100',800.00,0.00,0.00,0.00,60.00,'2021-12-05 07:13:12','',''),(2162952,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-05 07:13:12','',''),(2162995,'1','149','770',328,'Retail Sale Id 1279123',3500.80,0.00,0.00,0.00,262.56,'2021-12-05 07:15:58','',''),(2162996,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-05 07:15:58','',''),(2163070,'1','149','770',328,'Retail Sale Id 1279158',3852.80,0.00,0.00,0.00,288.96,'2021-12-05 07:20:09','',''),(2163071,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 07:20:09','',''),(2163088,'1','149','770',328,'Retail Sale Id 1279171',697.60,0.00,0.00,0.00,52.32,'2021-12-05 07:21:19','',''),(2163089,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-05 07:21:19','',''),(2163102,'1','149','770',328,'Retail Sale Id 1279192',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 07:22:51','',''),(2163103,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 07:22:51','',''),(2163124,'1','149','770',328,'Retail Sale Id 1279215',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 07:24:32','',''),(2163125,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 07:24:32','',''),(2163150,'1','149','770',328,'Retail Sale Id 1279233',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 07:25:33','',''),(2163151,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:25:33','',''),(2163328,'1','149','770',328,'Retail Sale Id 1279339',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 07:36:35','',''),(2163329,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:36:35','',''),(2163366,'1','149','770',328,'Retail Sale Id 1279373',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 07:38:41','',''),(2163367,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 07:38:41','',''),(2163403,'1','149','770',328,'Retail Sale Id 1279388',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 07:39:40','',''),(2163404,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 07:39:40','',''),(2163506,'1','149','770',328,'Retail Sale Id 1279441',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 07:46:35','',''),(2163507,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:46:35','',''),(2163572,'1','149','770',328,'Retail Sale Id 1279474',3852.80,0.00,0.00,0.00,288.96,'2021-12-05 07:50:03','',''),(2163573,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 07:50:03','',''),(2163612,'1','149','770',328,'Retail Sale Id 1279491',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 07:51:38','',''),(2163613,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:51:38','',''),(2163657,'1','149','770',328,'Retail Sale Id 1279507',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 07:53:53','',''),(2163658,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 07:53:53','',''),(2163679,'1','149','770',328,'Retail Sale Id 1279525',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 07:55:02','',''),(2163680,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 07:55:02','',''),(2163709,'1','149','770',328,'Retail Sale Id 1279534',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 07:56:36','',''),(2163710,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 07:56:36','',''),(2163732,'1','149','770',328,'Retail Sale Id 1279547',998.40,0.00,0.00,0.00,74.88,'2021-12-05 07:58:26','',''),(2163733,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 07:58:26','',''),(2163758,'1','149','770',328,'Retail Sale Id 1279565',5452.80,0.00,0.00,0.00,408.96,'2021-12-05 08:00:03','',''),(2163759,'1','149','770',328,'Retail sales',0.00,0.00,0.00,8.52,0.00,'2021-12-05 08:00:03','',''),(2163782,'1','149','770',328,'Retail Sale Id 1279577',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 08:01:19','',''),(2163783,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 08:01:19','',''),(2163808,'1','149','770',328,'Retail Sale Id 1279589',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 08:02:45','',''),(2163809,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:02:45','',''),(2163830,'1','149','770',328,'Retail Sale Id 1279608',6400.00,0.00,0.00,0.00,480.00,'2021-12-05 08:03:49','',''),(2163831,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 08:03:49','',''),(2163864,'1','149','770',328,'Retail Sale Id 1279625',3852.80,0.00,0.00,0.00,288.96,'2021-12-05 08:05:33','',''),(2163865,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 08:05:33','',''),(2163996,'1','149','770',328,'Retail Sale Id 1279707',998.40,0.00,0.00,0.00,74.88,'2021-12-05 08:11:39','',''),(2163997,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 08:11:39','',''),(2164020,'1','149','770',328,'Retail Sale Id 1279725',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 08:13:21','',''),(2164022,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 08:13:21','',''),(2164060,'1','149','770',328,'Retail Sale Id 1279748',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 08:15:36','',''),(2164061,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 08:15:36','',''),(2164118,'1','149','770',328,'Retail Sale Id 1279776',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 08:18:29','',''),(2164119,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:18:29','',''),(2164194,'1','149','770',328,'Retail Sale Id 1279817',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 08:22:03','',''),(2164195,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:22:03','',''),(2164289,'1','149','770',328,'Retail Sale Id 1279857',998.40,0.00,0.00,0.00,74.88,'2021-12-05 08:25:41','',''),(2164291,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 08:25:41','',''),(2164318,'1','149','770',328,'Retail Sale Id 1279880',998.40,0.00,0.00,0.00,74.88,'2021-12-05 08:27:08','',''),(2164319,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 08:27:08','',''),(2164344,'1','149','770',328,'Retail Sale Id 1279894',3852.80,0.00,0.00,0.00,288.96,'2021-12-05 08:28:09','',''),(2164345,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 08:28:09','',''),(2164370,'1','149','770',328,'Retail Sale Id 1279910',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 08:29:39','',''),(2164371,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:29:39','',''),(2164394,'1','149','770',328,'Retail Sale Id 1279923',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 08:31:17','',''),(2164395,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:31:17','',''),(2164422,'1','149','770',328,'Retail Sale Id 1279934',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 08:32:28','',''),(2164423,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 08:32:28','',''),(2164470,'1','149','770',328,'Retail Sale Id 1279959',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 08:34:36','',''),(2164471,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 08:34:36','',''),(2164520,'1','149','770',328,'Retail Sale Id 1279989',697.60,0.00,0.00,0.00,52.32,'2021-12-05 08:37:08','',''),(2164521,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-05 08:37:08','',''),(2164564,'1','149','770',328,'Retail Sale Id 1280012',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 08:40:21','',''),(2164565,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 08:40:21','',''),(2164616,'1','149','770',328,'Retail Sale Id 1280032',1798.40,0.00,0.00,0.00,134.88,'2021-12-05 08:42:49','',''),(2164617,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-05 08:42:49','',''),(2164668,'1','149','770',328,'Retail Sale Id 1280051',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 08:45:04','',''),(2164669,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 08:45:04','',''),(2164689,'1','149','770',328,'Retail Sale Id 1280061',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 08:46:40','',''),(2164690,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:46:40','',''),(2164713,'1','149','770',328,'Retail Sale Id 1280070',998.40,0.00,0.00,0.00,74.88,'2021-12-05 08:47:46','',''),(2164714,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 08:47:46','',''),(2164737,'1','149','770',328,'Retail Sale Id 1280081',2598.40,0.00,0.00,0.00,194.88,'2021-12-05 08:48:55','',''),(2164738,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 08:48:55','',''),(2164749,'1','149','770',328,'Retail Sale Id 1280091',3500.80,0.00,0.00,0.00,262.56,'2021-12-05 08:49:51','',''),(2164750,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-05 08:49:51','',''),(2164837,'1','149','770',328,'Retail Sale Id 1280137',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 08:54:32','',''),(2164838,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 08:54:32','',''),(2164943,'1','149','770',328,'Retail Sale Id 1280199',998.40,0.00,0.00,0.00,74.88,'2021-12-05 09:00:44','',''),(2164944,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 09:00:44','',''),(2165013,'1','149','770',328,'Retail Sale Id 1280235',2502.40,0.00,0.00,0.00,187.68,'2021-12-05 09:04:58','',''),(2165014,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 09:04:58','',''),(2165123,'1','149','770',328,'Retail Sale Id 1280298',1203.20,0.00,0.00,0.00,90.24,'2021-12-05 09:09:53','',''),(2165124,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-05 09:09:53','',''),(2165162,'1','149','770',328,'Retail Sale Id 1280314',697.60,0.00,0.00,0.00,52.32,'2021-12-05 09:11:33','',''),(2165163,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-05 09:11:33','',''),(2165193,'1','149','770',328,'Retail Sale Id 1280332',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 09:13:14','',''),(2165194,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 09:13:14','',''),(2165227,'1','149','770',328,'Retail Sale Id 1280349',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 09:15:21','',''),(2165228,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 09:15:21','',''),(2165248,'1','149','770',328,'Retail Sale Id 1280390',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 09:17:14','',''),(2165249,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 09:17:14','',''),(2165280,'1','149','770',328,'Retail Sale Id 1280405',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 09:18:54','',''),(2165281,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 09:18:54','',''),(2165448,'1','149','770',328,'Retail Sale Id 1280500',697.60,0.00,0.00,0.00,52.32,'2021-12-05 09:28:27','',''),(2165449,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-05 09:28:27','',''),(2165472,'1','149','770',328,'Retail Sale Id 1280513',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 09:29:32','',''),(2165473,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:29:32','',''),(2165536,'1','149','770',328,'Retail Sale Id 1280551',32000.00,0.00,0.00,0.00,2400.00,'2021-12-05 09:32:48','',''),(2165537,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 09:32:48','',''),(2165600,'1','149','770',328,'Retail Sale Id 1280585',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 09:36:24','',''),(2165601,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 09:36:24','',''),(2165626,'1','149','770',328,'Retail Sale Id 1280603',2598.40,0.00,0.00,0.00,194.88,'2021-12-05 09:37:45','',''),(2165627,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 09:37:45','',''),(2165650,'1','149','770',328,'Retail Sale Id 1280614',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 09:39:01','',''),(2165651,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 09:39:01','',''),(2166081,'1','149','770',328,'Retail Sale Id 1280799',6400.00,0.00,0.00,0.00,480.00,'2021-12-05 09:58:24','',''),(2166082,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 09:58:24','',''),(2166089,'1','149','770',328,'Retail Sale Id 1280803',1702.40,0.00,0.00,0.00,127.68,'2021-12-05 09:58:59','',''),(2166090,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-05 09:58:59','',''),(2166175,'1','149','770',328,'Retail Sale Id 1280848',3852.80,0.00,0.00,0.00,288.96,'2021-12-05 10:03:58','',''),(2166176,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 10:03:58','',''),(2166273,'1','149','770',328,'Retail Sale Id 1280898',1798.40,0.00,0.00,0.00,134.88,'2021-12-05 10:11:11','',''),(2166274,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-05 10:11:11','',''),(2166319,'1','149','770',328,'Retail Sale Id 1280923',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 10:14:31','',''),(2166320,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:14:31','',''),(2166343,'1','149','770',328,'Retail Sale Id 1280937',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 10:15:55','',''),(2166344,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 10:15:55','',''),(2166371,'1','149','770',328,'Retail Sale Id 1280952',3852.80,0.00,0.00,0.00,288.96,'2021-12-05 10:17:47','',''),(2166372,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 10:17:47','',''),(2166405,'1','149','770',328,'Retail Sale Id 1280966',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 10:19:48','',''),(2166406,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:19:48','',''),(2166421,'1','149','770',328,'Retail Sale Id 1280976',998.40,0.00,0.00,0.00,74.88,'2021-12-05 10:20:54','',''),(2166422,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 10:20:54','',''),(2166447,'1','149','770',328,'Retail Sale Id 1280992',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 10:22:30','',''),(2166448,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:22:30','',''),(2166477,'1','149','770',328,'Retail Sale Id 1281004',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 10:24:29','',''),(2166478,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 10:24:29','',''),(2166660,'1','149','770',328,'Retail Sale Id 1281097',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 10:35:37','',''),(2166661,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 10:35:37','',''),(2166696,'1','149','770',328,'Retail Sale Id 1281116',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 10:37:43','',''),(2166697,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:37:43','',''),(2166819,'1','149','770',328,'Retail Sale Id 1281179',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 10:44:57','',''),(2166820,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 10:44:57','',''),(2167086,'1','149','770',328,'Retail Sale Id 1281316',3500.80,0.00,0.00,0.00,262.56,'2021-12-05 10:59:17','',''),(2167087,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-05 10:59:17','',''),(2167174,'1','149','770',328,'Retail Sale Id 1281362',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 11:05:01','',''),(2167175,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 11:05:01','',''),(2167204,'1','149','770',328,'Retail Sale Id 1281376',998.40,0.00,0.00,0.00,74.88,'2021-12-05 11:07:09','',''),(2167205,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 11:07:09','',''),(2167238,'1','149','770',328,'Retail Sale Id 1281407',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 11:08:45','',''),(2167239,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 11:08:45','',''),(2167254,'1','149','770',328,'Retail Sale Id 1281421',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 11:09:36','',''),(2167255,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 11:09:36','',''),(2167358,'1','149','770',328,'Retail Sale Id 1281473',697.60,0.00,0.00,0.00,52.32,'2021-12-05 11:15:55','',''),(2167359,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-05 11:15:55','',''),(2167374,'1','149','770',328,'Retail Sale Id 1281482',652.80,0.00,0.00,0.00,48.96,'2021-12-05 11:17:24','',''),(2167375,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-05 11:17:24','',''),(2167419,'1','149','770',328,'Retail Sale Id 1281496',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 11:19:25','',''),(2167420,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 11:19:25','',''),(2167546,'1','149','770',328,'Retail Sale Id 1281559',3852.80,0.00,0.00,0.00,288.96,'2021-12-05 11:27:17','',''),(2167547,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 11:27:17','',''),(2167649,'1','149','770',328,'Retail Sale Id 1281611',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 11:31:58','',''),(2167650,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 11:31:58','',''),(2167735,'1','149','770',328,'Retail Sale Id 1281646',998.40,0.00,0.00,0.00,74.88,'2021-12-05 11:36:42','',''),(2167736,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 11:36:42','',''),(2167967,'1','149','770',328,'Retail Sale Id 1281820',3500.80,0.00,0.00,0.00,262.56,'2021-12-05 11:51:31','',''),(2167968,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-05 11:51:31','',''),(2167998,'1','149','770',328,'Retail Sale Id 1281835',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 11:52:35','',''),(2167999,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 11:52:35','',''),(2168034,'1','149','770',328,'Retail Sale Id 1281853',3852.80,0.00,0.00,0.00,288.96,'2021-12-05 11:54:59','',''),(2168035,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 11:54:59','',''),(2168092,'1','149','770',328,'Retail Sale Id 1281883',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 11:58:15','',''),(2168093,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:58:15','',''),(2168228,'1','149','770',328,'Retail Sale Id 1281955',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 12:06:08','',''),(2168229,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:06:08','',''),(2168261,'1','149','770',328,'Retail Sale Id 1281970',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 12:07:32','',''),(2168262,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 12:07:32','',''),(2168285,'1','149','770',328,'Retail Sale Id 1281985',652.80,0.00,0.00,0.00,48.96,'2021-12-05 12:08:41','',''),(2168286,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-05 12:08:41','',''),(2168344,'1','149','770',328,'Retail Sale Id 1282016',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 12:11:55','',''),(2168345,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 12:11:55','',''),(2168611,'1','149','770',328,'Retail Sale Id 1282141',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 12:22:34','',''),(2168612,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 12:22:34','',''),(2168635,'1','149','770',328,'Retail Sale Id 1282150',17920.00,0.00,0.00,0.00,1344.00,'2021-12-05 12:23:48','',''),(2168636,'1','149','770',328,'Retail sales',0.00,0.00,0.00,28.00,0.00,'2021-12-05 12:23:48','',''),(2168662,'1','149','770',328,'Retail Sale Id 1282165',652.80,0.00,0.00,0.00,48.96,'2021-12-05 12:24:34','',''),(2168663,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-05 12:24:34','',''),(2168688,'1','149','770',328,'Retail Sale Id 1282177',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:25:42','',''),(2168689,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:25:42','',''),(2168770,'1','149','770',328,'Retail Sale Id 1282219',697.60,0.00,0.00,0.00,52.32,'2021-12-05 12:28:48','',''),(2168771,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-05 12:28:48','',''),(2168826,'1','149','770',328,'Retail Sale Id 1282253',1798.40,0.00,0.00,0.00,134.88,'2021-12-05 12:32:09','',''),(2168827,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-05 12:32:09','',''),(2168872,'1','149','770',328,'Retail Sale Id 1282273',652.80,0.00,0.00,0.00,48.96,'2021-12-05 12:34:15','',''),(2168873,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-05 12:34:15','',''),(2168908,'1','149','770',328,'Retail Sale Id 1282294',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 12:36:17','',''),(2168909,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 12:36:17','',''),(2168941,'1','149','770',328,'Retail Sale Id 1282310',4499.20,0.00,0.00,0.00,337.44,'2021-12-05 12:38:05','',''),(2168942,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-05 12:38:05','',''),(2168967,'1','149','770',328,'Retail Sale Id 1282326',998.40,0.00,0.00,0.00,74.88,'2021-12-05 12:39:33','',''),(2168968,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 12:39:33','',''),(2169033,'1','149','770',328,'Retail Sale Id 1282359',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 12:43:08','',''),(2169034,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 12:43:08','',''),(2169309,'1','149','770',328,'Retail Sale Id 1282521',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 12:59:35','',''),(2169310,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:59:35','',''),(2169371,'1','149','770',328,'Retail Sale Id 1282547',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 13:02:01','',''),(2169372,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 13:02:01','',''),(2169389,'1','149','770',328,'Retail Sale Id 1282556',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 13:02:53','',''),(2169390,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 13:02:53','',''),(2169407,'1','149','770',328,'Retail Sale Id 1282565',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 13:03:42','',''),(2169408,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 13:03:42','',''),(2169453,'1','149','770',328,'Retail Sale Id 1282595',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 13:06:23','',''),(2169454,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 13:06:23','',''),(2169495,'1','149','770',328,'Retail Sale Id 1282633',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 13:08:26','',''),(2169496,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 13:08:26','',''),(2169514,'1','149','770',328,'Retail Sale Id 1282641',1798.40,0.00,0.00,0.00,134.88,'2021-12-05 13:09:34','',''),(2169515,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-05 13:09:34','',''),(2169528,'1','149','770',328,'Retail Sale Id 1282649',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 13:10:17','',''),(2169529,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 13:10:17','',''),(2169578,'1','149','770',328,'Retail Sale Id 1282675',3852.80,0.00,0.00,0.00,288.96,'2021-12-05 13:13:25','',''),(2169579,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 13:13:25','',''),(2169616,'1','149','770',328,'Retail Sale Id 1282695',5760.00,0.00,0.00,0.00,432.00,'2021-12-05 13:16:31','',''),(2169617,'1','149','770',328,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-05 13:16:31','',''),(2169684,'1','149','770',328,'Retail Sale Id 1282724',12800.00,0.00,0.00,0.00,960.00,'2021-12-05 13:19:43','',''),(2169685,'1','149','770',328,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-05 13:19:43','',''),(2169726,'1','149','770',328,'Retail Sale Id 1282748',902.40,0.00,0.00,0.00,67.68,'2021-12-05 13:22:32','',''),(2169727,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-05 13:22:32','',''),(2169752,'1','149','770',328,'Retail Sale Id 1282763',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:24:14','',''),(2169753,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:24:14','',''),(2169909,'1','149','770',328,'Retail Sale Id 1282833',3852.80,0.00,0.00,0.00,288.96,'2021-12-05 13:32:03','',''),(2169910,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 13:32:03','',''),(2169923,'1','149','770',328,'Retail Sale Id 1282840',1203.20,0.00,0.00,0.00,90.24,'2021-12-05 13:33:22','',''),(2169924,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-05 13:33:22','',''),(2169937,'1','149','770',328,'Retail Sale Id 1282848',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 13:34:05','',''),(2169938,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 13:34:05','',''),(2170033,'1','149','770',328,'Retail Sale Id 1282889',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 13:38:52','',''),(2170034,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 13:38:52','',''),(2170129,'1','149','770',328,'Retail Sale Id 1282915',2502.40,0.00,0.00,0.00,187.68,'2021-12-05 13:42:43','',''),(2170130,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 13:42:43','',''),(2170194,'1','149','770',328,'Retail Sale Id 1282940',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 13:46:15','',''),(2170195,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 13:46:15','',''),(2170239,'1','149','770',328,'Retail Sale Id 1282961',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:48:46','',''),(2170240,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:48:46','',''),(2170304,'1','149','770',328,'Retail Sale Id 1282986',2598.40,0.00,0.00,0.00,194.88,'2021-12-05 13:51:59','',''),(2170305,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 13:51:59','',''),(2170356,'1','149','770',328,'Retail Sale Id 1283012',172800.00,0.00,0.00,0.00,12960.00,'2021-12-05 13:54:52','',''),(2170357,'1','149','770',328,'Retail sales',0.00,0.00,0.00,270.00,0.00,'2021-12-05 13:54:52','',''),(2170376,'1','149','770',328,'Retail Sale Id 1283021',2502.40,0.00,0.00,0.00,187.68,'2021-12-05 13:55:56','',''),(2170377,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 13:55:56','',''),(2170421,'1','149','770',328,'Retail Sale Id 1283034',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 13:57:30','',''),(2170422,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 13:57:30','',''),(2170545,'1','149','770',328,'Retail Sale Id 1283095',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 14:05:22','',''),(2170546,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 14:05:22','',''),(2170618,'1','149','770',328,'Retail Sale Id 1283131',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 14:10:19','',''),(2170619,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 14:10:19','',''),(2170857,'1','149','770',328,'Retail Sale Id 1283217',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 14:19:46','',''),(2170858,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 14:19:46','',''),(2170889,'1','149','770',328,'Retail Sale Id 1283234',998.40,0.00,0.00,0.00,74.88,'2021-12-05 14:22:05','',''),(2170890,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 14:22:05','',''),(2171158,'1','149','770',328,'Retail Sale Id 1283333',652.80,0.00,0.00,0.00,48.96,'2021-12-05 14:35:49','',''),(2171159,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-05 14:35:49','',''),(2171209,'1','149','770',328,'Retail Sale Id 1283348',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 14:38:20','',''),(2171210,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 14:38:20','',''),(2171239,'1','149','770',328,'Retail Sale Id 1283363',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 14:40:31','',''),(2171240,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 14:40:31','',''),(2171251,'1','149','770',328,'Retail Sale Id 1283370',800.00,0.00,0.00,0.00,60.00,'2021-12-05 14:41:27','',''),(2171252,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-05 14:41:27','',''),(2171273,'1','149','770',328,'Retail Sale Id 1283376',998.40,0.00,0.00,0.00,74.88,'2021-12-05 14:42:28','',''),(2171274,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 14:42:28','',''),(2171337,'1','149','770',328,'Retail Sale Id 1283395',902.40,0.00,0.00,0.00,67.68,'2021-12-05 14:45:08','',''),(2171338,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-05 14:45:08','',''),(2171347,'1','149','770',328,'Retail Sale Id 1283399',652.80,0.00,0.00,0.00,48.96,'2021-12-05 14:46:04','',''),(2171348,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-05 14:46:04','',''),(2171471,'1','149','770',328,'Retail Sale Id 1283464',3852.80,0.00,0.00,0.00,288.96,'2021-12-05 14:54:22','',''),(2171472,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 14:54:22','',''),(2171533,'1','149','770',328,'Retail Sale Id 1283495',800.00,0.00,0.00,0.00,60.00,'2021-12-05 14:59:07','',''),(2171534,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-05 14:59:07','',''),(2171553,'1','149','770',328,'Retail Sale Id 1283503',6400.00,0.00,0.00,0.00,480.00,'2021-12-05 15:00:29','',''),(2171554,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 15:00:29','',''),(2171587,'1','149','770',328,'Retail Sale Id 1283521',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 15:03:54','',''),(2171588,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 15:03:54','',''),(2172078,'1','149','770',328,'Retail Sale Id 1283761',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 15:36:35','',''),(2172079,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:36:35','',''),(2172137,'1','149','770',328,'Retail Sale Id 1283789',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 15:39:21','',''),(2172138,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 15:39:21','',''),(2172189,'1','149','770',328,'Retail Sale Id 1283809',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 15:41:34','',''),(2172190,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 15:41:34','',''),(2172229,'1','149','770',328,'Retail Sale Id 1283835',998.40,0.00,0.00,0.00,74.88,'2021-12-05 15:43:24','',''),(2172230,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 15:43:24','',''),(2172255,'1','149','770',328,'Retail Sale Id 1283852',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 15:44:59','',''),(2172256,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 15:44:59','',''),(2172303,'1','149','770',328,'Retail Sale Id 1283876',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 15:46:51','',''),(2172304,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 15:46:51','',''),(2172343,'1','149','770',328,'Retail Sale Id 1283901',697.60,0.00,0.00,0.00,52.32,'2021-12-05 15:48:53','',''),(2172344,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-05 15:48:53','',''),(2172397,'1','149','770',328,'Retail Sale Id 1283931',2201.60,0.00,0.00,0.00,165.12,'2021-12-05 15:52:00','',''),(2172398,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.44,0.00,'2021-12-05 15:52:00','',''),(2172416,'1','149','770',328,'Retail Sale Id 1283943',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 15:53:09','',''),(2172417,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 15:53:09','',''),(2172430,'1','149','770',328,'Retail Sale Id 1283952',998.40,0.00,0.00,0.00,74.88,'2021-12-05 15:54:15','',''),(2172431,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 15:54:15','',''),(2172580,'1','149','770',328,'Retail Sale Id 1284026',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 16:03:17','',''),(2172581,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 16:03:17','',''),(2172596,'1','149','770',328,'Retail Sale Id 1284033',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 16:04:17','',''),(2172597,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 16:04:17','',''),(2172703,'1','149','770',328,'Retail Sale Id 1284084',998.40,0.00,0.00,0.00,74.88,'2021-12-05 16:10:18','',''),(2172704,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 16:10:18','',''),(2172802,'1','149','770',328,'Retail Sale Id 1284138',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 16:17:22','',''),(2172803,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 16:17:22','',''),(2172818,'1','149','770',328,'Retail Sale Id 1284146',3852.80,0.00,0.00,0.00,288.96,'2021-12-05 16:18:49','',''),(2172819,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 16:18:49','',''),(2172872,'1','149','770',328,'Retail Sale Id 1284181',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 16:21:37','',''),(2172873,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 16:21:37','',''),(2172892,'1','149','770',328,'Retail Sale Id 1284192',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 16:22:55','',''),(2172893,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:22:55','',''),(2172920,'1','149','770',328,'Retail Sale Id 1284204',1401.60,0.00,0.00,0.00,105.12,'2021-12-05 16:23:56','',''),(2172921,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-05 16:23:56','',''),(2173033,'1','149','770',328,'Retail Sale Id 1284269',697.60,0.00,0.00,0.00,52.32,'2021-12-05 16:32:19','',''),(2173034,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-05 16:32:19','',''),(2173109,'1','149','770',328,'Retail Sale Id 1284305',1798.40,0.00,0.00,0.00,134.88,'2021-12-05 16:36:15','',''),(2173110,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-05 16:36:15','',''),(2173129,'1','149','770',328,'Retail Sale Id 1284316',998.40,0.00,0.00,0.00,74.88,'2021-12-05 16:37:17','',''),(2173130,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 16:37:17','',''),(2173161,'1','149','770',328,'Retail Sale Id 1284333',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 16:38:52','',''),(2173162,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 16:38:52','',''),(2173211,'1','149','770',328,'Retail Sale Id 1284359',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 16:42:05','',''),(2173212,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 16:42:05','',''),(2173231,'1','149','770',328,'Retail Sale Id 1284368',3852.80,0.00,0.00,0.00,288.96,'2021-12-05 16:43:18','',''),(2173232,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 16:43:18','',''),(2173331,'1','149','770',328,'Retail Sale Id 1284421',998.40,0.00,0.00,0.00,74.88,'2021-12-05 16:49:43','',''),(2173332,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 16:49:43','',''),(2173383,'1','149','770',328,'Retail Sale Id 1284446',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 16:52:58','',''),(2173384,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 16:52:58','',''),(2173401,'1','149','770',328,'Retail Sale Id 1284456',3852.80,0.00,0.00,0.00,288.96,'2021-12-05 16:53:57','',''),(2173402,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 16:53:57','',''),(2173425,'1','149','770',328,'Retail Sale Id 1284470',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 16:56:04','',''),(2173426,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 16:56:04','',''),(2173447,'1','149','770',328,'Retail Sale Id 1284482',32000.00,0.00,0.00,0.00,2400.00,'2021-12-05 16:56:59','',''),(2173448,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 16:56:59','',''),(2173463,'1','149','770',328,'Retail Sale Id 1284493',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 16:58:22','',''),(2173464,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 16:58:22','',''),(2173504,'1','149','770',328,'Retail Sale Id 1284510',3852.80,0.00,0.00,0.00,288.96,'2021-12-05 17:00:57','',''),(2173505,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 17:00:57','',''),(2173520,'1','149','770',328,'Retail Sale Id 1284518',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 17:01:58','',''),(2173521,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 17:01:58','',''),(2173531,'1','149','770',328,'Retail Sale Id 1284523',998.40,0.00,0.00,0.00,74.88,'2021-12-05 17:02:50','',''),(2173532,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 17:02:50','',''),(2173543,'1','149','770',328,'Retail Sale Id 1284529',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 17:03:51','',''),(2173544,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 17:03:51','',''),(2173564,'1','149','770',328,'Retail Sale Id 1284538',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 17:04:58','',''),(2173565,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 17:04:58','',''),(2173629,'1','149','770',328,'Retail Sale Id 1284563',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 17:08:42','',''),(2173630,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 17:08:42','',''),(2173633,'1','149','770',328,'Retail Sale Id 1284566',998.40,0.00,0.00,0.00,74.88,'2021-12-05 17:09:31','',''),(2173634,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 17:09:31','',''),(2173686,'1','149','770',328,'Retail Sale Id 1284586',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 17:13:32','',''),(2173687,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 17:13:32','',''),(2173720,'1','149','770',328,'Retail Sale Id 1284606',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 17:16:53','',''),(2173721,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 17:16:53','',''),(2173778,'1','149','770',328,'Retail Sale Id 1284633',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 17:21:26','',''),(2173779,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 17:21:26','',''),(2173796,'1','149','770',328,'Retail Sale Id 1284645',998.40,0.00,0.00,0.00,74.88,'2021-12-05 17:22:56','',''),(2173797,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 17:22:56','',''),(2174038,'1','149','770',328,'Retail Sale Id 1284763',333459.20,0.00,0.00,0.00,25009.44,'2021-12-05 17:47:04','',''),(2174039,'1','149','770',328,'Retail sales',0.00,0.00,0.00,521.03,0.00,'2021-12-05 17:47:04','',''),(2174804,'1','149','770',328,'Retail Sale Id 1284909',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 06:03:43','',''),(2174805,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 06:03:43','',''),(2174806,'1','149','770',328,'Retail Sale Id 1284910',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 06:05:12','',''),(2174807,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 06:05:12','',''),(2174815,'1','149','770',328,'Retail Sale Id 1284914',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 06:08:49','',''),(2174816,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 06:08:49','',''),(2174825,'1','149','770',328,'Retail Sale Id 1284918',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 06:10:49','',''),(2174826,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 06:10:49','',''),(2174844,'1','149','770',328,'Retail Sale Id 1284926',1600.00,0.00,0.00,0.00,120.00,'2021-12-06 06:13:21','',''),(2174845,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 06:13:21','',''),(2174870,'1','149','770',328,'Retail Sale Id 1284948',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 06:17:41','',''),(2174871,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 06:17:41','',''),(2174882,'1','149','770',328,'Retail Sale Id 1284955',800.00,0.00,0.00,0.00,60.00,'2021-12-06 06:20:14','',''),(2174883,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-06 06:20:14','',''),(2174888,'1','149','770',328,'Retail Sale Id 1284958',697.60,0.00,0.00,0.00,52.32,'2021-12-06 06:21:02','',''),(2174889,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 06:21:02','',''),(2174915,'1','149','770',328,'Retail Sale Id 1284969',697.60,0.00,0.00,0.00,52.32,'2021-12-06 06:25:46','',''),(2174916,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 06:25:46','',''),(2174939,'1','149','770',328,'Retail Sale Id 1284976',998.40,0.00,0.00,0.00,74.88,'2021-12-06 06:28:03','',''),(2174940,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 06:28:03','',''),(2174953,'1','149','770',328,'Retail Sale Id 1284982',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 06:29:15','',''),(2174954,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 06:29:15','',''),(2175004,'1','149','770',328,'Retail Sale Id 1284989',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 06:31:53','',''),(2175005,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 06:31:53','',''),(2175052,'1','149','770',328,'Retail Sale Id 1285003',32000.00,0.00,0.00,0.00,2400.00,'2021-12-06 06:34:46','',''),(2175053,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 06:34:46','',''),(2175059,'1','149','770',328,'Retail Sale Id 1285006',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 06:35:57','',''),(2175060,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 06:35:57','',''),(2175097,'1','149','770',328,'Retail Sale Id 1285025',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 06:41:26','',''),(2175098,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 06:41:26','',''),(2175133,'1','149','770',328,'Retail Sale Id 1285042',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 06:45:18','',''),(2175134,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 06:45:19','',''),(2175151,'1','149','770',328,'Retail Sale Id 1285053',1203.20,0.00,0.00,0.00,90.24,'2021-12-06 06:46:29','',''),(2175152,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-06 06:46:29','',''),(2175189,'1','149','770',328,'Retail Sale Id 1285073',4998.40,0.00,0.00,0.00,374.88,'2021-12-06 06:49:12','',''),(2175190,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 06:49:12','',''),(2175205,'1','149','770',328,'Retail Sale Id 1285082',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 06:50:20','',''),(2175206,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 06:50:20','',''),(2175215,'1','149','770',328,'Retail Sale Id 1285087',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 06:51:22','',''),(2175216,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 06:51:22','',''),(2175326,'1','149','770',328,'Retail Sale Id 1285136',652.80,0.00,0.00,0.00,48.96,'2021-12-06 06:58:00','',''),(2175327,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-06 06:58:00','',''),(2175363,'1','149','770',328,'Retail Sale Id 1285150',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 06:59:59','',''),(2175364,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 06:59:59','',''),(2175559,'1','149','770',328,'Retail Sale Id 1285230',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 07:13:49','',''),(2175560,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 07:13:49','',''),(2175678,'1','149','770',328,'Retail Sale Id 1285300',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:20:44','',''),(2175679,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:20:44','',''),(2175732,'1','149','770',328,'Retail Sale Id 1285327',652.80,0.00,0.00,0.00,48.96,'2021-12-06 07:23:46','',''),(2175733,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-06 07:23:46','',''),(2175754,'1','149','770',328,'Retail Sale Id 1285335',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 07:24:41','',''),(2175755,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 07:24:41','',''),(2175792,'1','149','770',328,'Retail Sale Id 1285356',1203.20,0.00,0.00,0.00,90.24,'2021-12-06 07:26:49','',''),(2175793,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-06 07:26:49','',''),(2175826,'1','149','770',328,'Retail Sale Id 1285365',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 07:29:17','',''),(2175827,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 07:29:17','',''),(2175866,'1','149','770',328,'Retail Sale Id 1285389',998.40,0.00,0.00,0.00,74.88,'2021-12-06 07:31:41','',''),(2175867,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 07:31:41','',''),(2175903,'1','149','770',328,'Retail Sale Id 1285407',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 07:33:47','',''),(2175904,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 07:33:47','',''),(2175947,'1','149','770',328,'Retail Sale Id 1285431',902.40,0.00,0.00,0.00,67.68,'2021-12-06 07:36:14','',''),(2175948,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-06 07:36:14','',''),(2176119,'1','149','770',328,'Retail Sale Id 1285516',1600.00,0.00,0.00,0.00,120.00,'2021-12-06 07:44:53','',''),(2176120,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 07:44:53','',''),(2176208,'1','149','770',328,'Retail Sale Id 1285560',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 07:48:31','',''),(2176209,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 07:48:31','',''),(2176235,'1','149','770',328,'Retail Sale Id 1285570',998.40,0.00,0.00,0.00,74.88,'2021-12-06 07:49:54','',''),(2176236,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 07:49:54','',''),(2176262,'1','149','770',328,'Retail Sale Id 1285583',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 07:51:03','',''),(2176263,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 07:51:03','',''),(2176456,'1','149','770',328,'Retail Sale Id 1285659',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:58:43','',''),(2176457,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:58:43','',''),(2176596,'1','149','770',328,'Retail Sale Id 1285740',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 08:06:23','',''),(2176597,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 08:06:23','',''),(2176682,'1','149','770',328,'Retail Sale Id 1285784',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 08:11:42','',''),(2176683,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 08:11:42','',''),(2176716,'1','149','770',328,'Retail Sale Id 1285803',697.60,0.00,0.00,0.00,52.32,'2021-12-06 08:14:13','',''),(2176717,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 08:14:13','',''),(2176756,'1','149','770',328,'Retail Sale Id 1285822',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 08:16:33','',''),(2176757,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 08:16:33','',''),(2176832,'1','149','770',328,'Retail Sale Id 1285866',652.80,0.00,0.00,0.00,48.96,'2021-12-06 08:24:15','',''),(2176833,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-06 08:24:15','',''),(2176915,'1','149','770',328,'Retail Sale Id 1285910',4499.20,0.00,0.00,0.00,337.44,'2021-12-06 08:32:27','',''),(2176916,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-06 08:32:27','',''),(2176933,'1','149','770',328,'Retail Sale Id 1285919',697.60,0.00,0.00,0.00,52.32,'2021-12-06 08:33:25','',''),(2176934,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 08:33:25','',''),(2176961,'1','149','770',328,'Retail Sale Id 1285932',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 08:35:24','',''),(2176962,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 08:35:24','',''),(2177021,'1','149','770',328,'Retail Sale Id 1285956',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 08:39:42','',''),(2177022,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 08:39:42','',''),(2177084,'1','149','770',328,'Retail Sale Id 1285985',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 08:44:19','',''),(2177085,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:44:19','',''),(2177098,'1','149','770',328,'Retail Sale Id 1285992',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 08:45:18','',''),(2177099,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 08:45:18','',''),(2177185,'1','149','770',328,'Retail Sale Id 1286036',3500.80,0.00,0.00,0.00,262.56,'2021-12-06 08:51:41','',''),(2177186,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-06 08:51:41','',''),(2177215,'1','149','770',328,'Retail Sale Id 1286053',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 08:54:04','',''),(2177216,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 08:54:04','',''),(2177262,'1','149','770',328,'Retail Sale Id 1286072',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 08:57:08','',''),(2177263,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 08:57:08','',''),(2177377,'1','149','770',328,'Retail Sale Id 1286128',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 09:05:39','',''),(2177378,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 09:05:39','',''),(2177409,'1','149','770',328,'Retail Sale Id 1286140',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 09:07:10','',''),(2177410,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 09:07:10','',''),(2177482,'1','149','770',328,'Retail Sale Id 1286176',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 09:12:41','',''),(2177483,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 09:12:41','',''),(2177622,'1','149','770',328,'Retail Sale Id 1286239',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 09:22:02','',''),(2177623,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 09:22:02','',''),(2177678,'1','149','770',328,'Retail Sale Id 1286266',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 09:25:35','',''),(2177679,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 09:25:35','',''),(2177815,'1','149','770',328,'Retail Sale Id 1286327',998.40,0.00,0.00,0.00,74.88,'2021-12-06 09:33:16','',''),(2177816,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 09:33:16','',''),(2177990,'1','149','770',328,'Retail Sale Id 1286391',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 09:42:18','',''),(2177991,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 09:42:18','',''),(2178042,'1','149','770',328,'Retail Sale Id 1286412',998.40,0.00,0.00,0.00,74.88,'2021-12-06 09:45:06','',''),(2178043,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 09:45:06','',''),(2178153,'1','149','770',328,'Retail Sale Id 1286470',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 09:53:24','',''),(2178154,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 09:53:24','',''),(2178177,'1','149','770',328,'Retail Sale Id 1286482',697.60,0.00,0.00,0.00,52.32,'2021-12-06 09:54:39','',''),(2178178,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 09:54:39','',''),(2178316,'1','149','770',328,'Retail Sale Id 1286551',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 10:04:20','',''),(2178317,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 10:04:20','',''),(2178358,'1','149','770',328,'Retail Sale Id 1286571',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 10:05:59','',''),(2178359,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 10:05:59','',''),(2178597,'1','149','770',328,'Retail Sale Id 1286689',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 10:21:10','',''),(2178598,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 10:21:10','',''),(2178621,'1','149','770',328,'Retail Sale Id 1286703',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 10:22:27','',''),(2178622,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 10:22:27','',''),(2178737,'1','149','770',328,'Retail Sale Id 1286762',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 10:30:26','',''),(2178738,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 10:30:26','',''),(2178832,'1','149','770',328,'Retail Sale Id 1286814',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 10:37:14','',''),(2178833,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 10:37:14','',''),(2178864,'1','149','770',328,'Retail Sale Id 1286832',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 10:39:40','',''),(2178865,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 10:39:40','',''),(2178966,'1','149','770',328,'Retail Sale Id 1286885',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 10:45:51','',''),(2178967,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 10:45:51','',''),(2179068,'1','149','770',328,'Retail Sale Id 1286949',697.60,0.00,0.00,0.00,52.32,'2021-12-06 10:51:30','',''),(2179069,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 10:51:30','',''),(2179217,'1','149','770',328,'Retail Sale Id 1287037',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 11:00:49','',''),(2179218,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:00:49','',''),(2179247,'1','149','770',328,'Retail Sale Id 1287052',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 11:02:57','',''),(2179248,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 11:02:57','',''),(2179309,'1','149','770',328,'Retail Sale Id 1287092',6003.20,0.00,0.00,0.00,450.24,'2021-12-06 11:06:49','',''),(2179310,'1','149','770',328,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-06 11:06:49','',''),(2179331,'1','149','770',328,'Retail Sale Id 1287102',1203.20,0.00,0.00,0.00,90.24,'2021-12-06 11:07:38','',''),(2179332,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-06 11:07:38','',''),(2179357,'1','149','770',328,'Retail Sale Id 1287114',998.40,0.00,0.00,0.00,74.88,'2021-12-06 11:09:05','',''),(2179358,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 11:09:05','',''),(2179367,'1','149','770',328,'Retail Sale Id 1287120',697.60,0.00,0.00,0.00,52.32,'2021-12-06 11:10:11','',''),(2179368,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 11:10:11','',''),(2179397,'1','149','770',328,'Retail Sale Id 1287133',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 11:12:27','',''),(2179398,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 11:12:27','',''),(2179529,'1','149','770',328,'Retail Sale Id 1287208',4998.40,0.00,0.00,0.00,374.88,'2021-12-06 11:19:27','',''),(2179530,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 11:19:27','',''),(2179595,'1','149','770',328,'Retail Sale Id 1287248',998.40,0.00,0.00,0.00,74.88,'2021-12-06 11:23:25','',''),(2179596,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 11:23:25','',''),(2179647,'1','149','770',328,'Retail Sale Id 1287276',6003.20,0.00,0.00,0.00,450.24,'2021-12-06 11:27:47','',''),(2179648,'1','149','770',328,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-06 11:27:47','',''),(2179677,'1','149','770',328,'Retail Sale Id 1287291',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 11:29:55','',''),(2179678,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 11:29:55','',''),(2179699,'1','149','770',328,'Retail Sale Id 1287302',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 11:31:34','',''),(2179700,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 11:31:34','',''),(2179764,'1','149','770',328,'Retail Sale Id 1287341',800.00,0.00,0.00,0.00,60.00,'2021-12-06 11:37:05','',''),(2179765,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-06 11:37:05','',''),(2179806,'1','149','770',328,'Retail Sale Id 1287359',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 11:41:06','',''),(2179807,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 11:41:06','',''),(2179835,'1','149','770',328,'Retail Sale Id 1287373',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 11:43:12','',''),(2179836,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 11:43:12','',''),(2179880,'1','149','770',328,'Retail Sale Id 1287427',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 11:47:22','',''),(2179881,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 11:47:22','',''),(2179920,'1','149','770',328,'Retail Sale Id 1287475',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 11:49:13','',''),(2179921,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 11:49:13','',''),(2179942,'1','149','770',328,'Retail Sale Id 1287490',998.40,0.00,0.00,0.00,74.88,'2021-12-06 11:50:56','',''),(2179943,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 11:50:56','',''),(2180008,'1','149','770',328,'Retail Sale Id 1287519',697.60,0.00,0.00,0.00,52.32,'2021-12-06 11:55:19','',''),(2180009,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 11:55:19','',''),(2180158,'1','149','770',328,'Retail Sale Id 1287595',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 12:04:16','',''),(2180159,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:04:16','',''),(2180600,'1','149','770',328,'Retail Sale Id 1287843',697.60,0.00,0.00,0.00,52.32,'2021-12-06 12:32:05','',''),(2180601,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 12:32:05','',''),(2180641,'1','149','770',328,'Retail Sale Id 1287862',998.40,0.00,0.00,0.00,74.88,'2021-12-06 12:34:10','',''),(2180642,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 12:34:10','',''),(2180672,'1','149','770',328,'Retail Sale Id 1287877',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 12:35:53','',''),(2180673,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 12:35:53','',''),(2180696,'1','149','770',328,'Retail Sale Id 1287892',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 12:37:09','',''),(2180697,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 12:37:09','',''),(2180770,'1','149','770',328,'Retail Sale Id 1287927',2598.40,0.00,0.00,0.00,194.88,'2021-12-06 12:41:57','',''),(2180771,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-06 12:41:57','',''),(2180812,'1','149','770',328,'Retail Sale Id 1287951',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 12:44:50','',''),(2180813,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:44:50','',''),(2180828,'1','149','770',328,'Retail Sale Id 1287960',24998.40,0.00,0.00,0.00,1874.88,'2021-12-06 12:46:21','',''),(2180829,'1','149','770',328,'Retail sales',0.00,0.00,0.00,39.06,0.00,'2021-12-06 12:46:21','',''),(2180860,'1','149','770',328,'Retail Sale Id 1287975',998.40,0.00,0.00,0.00,74.88,'2021-12-06 12:47:41','',''),(2180861,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 12:47:41','',''),(2180878,'1','149','770',328,'Retail Sale Id 1287983',32000.00,0.00,0.00,0.00,2400.00,'2021-12-06 12:48:38','',''),(2180879,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 12:48:38','',''),(2180916,'1','149','770',328,'Retail Sale Id 1288002',2201.60,0.00,0.00,0.00,165.12,'2021-12-06 12:51:13','',''),(2180917,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.44,0.00,'2021-12-06 12:51:13','',''),(2180984,'1','149','770',328,'Retail Sale Id 1288042',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 12:55:26','',''),(2180985,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 12:55:26','',''),(2181118,'1','149','770',328,'Retail Sale Id 1288104',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 13:01:42','',''),(2181119,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 13:01:42','',''),(2181146,'1','149','770',328,'Retail Sale Id 1288118',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 13:04:11','',''),(2181147,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 13:04:11','',''),(2181168,'1','149','770',328,'Retail Sale Id 1288131',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 13:05:31','',''),(2181169,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 13:05:31','',''),(2181584,'1','149','770',328,'Retail Sale Id 1288328',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 13:30:14','',''),(2181585,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 13:30:14','',''),(2181668,'1','149','770',328,'Retail Sale Id 1288354',15001.60,0.00,0.00,0.00,1125.12,'2021-12-06 13:34:22','',''),(2181669,'1','149','770',328,'Retail sales',0.00,0.00,0.00,23.44,0.00,'2021-12-06 13:34:22','',''),(2181720,'1','149','770',328,'Retail Sale Id 1288373',3500.80,0.00,0.00,0.00,262.56,'2021-12-06 13:36:37','',''),(2181721,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-06 13:36:37','',''),(2181736,'1','149','770',328,'Retail Sale Id 1288383',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 13:37:53','',''),(2181737,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 13:37:54','',''),(2181796,'1','149','770',328,'Retail Sale Id 1288413',4998.40,0.00,0.00,0.00,374.88,'2021-12-06 13:40:25','',''),(2181797,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 13:40:25','',''),(2181836,'1','149','770',328,'Retail Sale Id 1288429',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 13:42:13','',''),(2181837,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 13:42:13','',''),(2181864,'1','149','770',328,'Retail Sale Id 1288442',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 13:43:06','',''),(2181865,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 13:43:06','',''),(2181883,'1','149','770',328,'Retail Sale Id 1288447',998.40,0.00,0.00,0.00,74.88,'2021-12-06 13:44:12','',''),(2181884,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 13:44:12','',''),(2181907,'1','149','770',328,'Retail Sale Id 1288461',652.80,0.00,0.00,0.00,48.96,'2021-12-06 13:45:32','',''),(2181908,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-06 13:45:32','',''),(2182033,'1','149','770',328,'Retail Sale Id 1288522',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 13:52:04','',''),(2182034,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 13:52:04','',''),(2182099,'1','149','770',328,'Retail Sale Id 1288553',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 13:55:07','',''),(2182100,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 13:55:07','',''),(2182243,'1','149','770',328,'Retail Sale Id 1288614',652.80,0.00,0.00,0.00,48.96,'2021-12-06 14:01:33','',''),(2182244,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-06 14:01:33','',''),(2182263,'1','149','770',328,'Retail Sale Id 1288626',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 14:02:46','',''),(2182264,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 14:02:46','',''),(2182289,'1','149','770',328,'Retail Sale Id 1288640',998.40,0.00,0.00,0.00,74.88,'2021-12-06 14:03:55','',''),(2182290,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 14:03:55','',''),(2182371,'1','149','770',328,'Retail Sale Id 1288675',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 14:07:46','',''),(2182372,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:07:46','',''),(2182399,'1','149','770',328,'Retail Sale Id 1288687',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 14:09:09','',''),(2182400,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 14:09:09','',''),(2182451,'1','149','770',328,'Retail Sale Id 1288705',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 14:10:55','',''),(2182452,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 14:10:55','',''),(2182495,'1','149','770',328,'Retail Sale Id 1288723',998.40,0.00,0.00,0.00,74.88,'2021-12-06 14:12:36','',''),(2182496,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 14:12:36','',''),(2182521,'1','149','770',328,'Retail Sale Id 1288734',5497.60,0.00,0.00,0.00,412.32,'2021-12-06 14:14:08','',''),(2182522,'1','149','770',328,'Retail sales',0.00,0.00,0.00,8.59,0.00,'2021-12-06 14:14:08','',''),(2182545,'1','149','770',328,'Retail Sale Id 1288746',1600.00,0.00,0.00,0.00,120.00,'2021-12-06 14:15:15','',''),(2182546,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 14:15:15','',''),(2182563,'1','149','770',328,'Retail Sale Id 1288756',800.00,0.00,0.00,0.00,60.00,'2021-12-06 14:16:15','',''),(2182564,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-06 14:16:15','',''),(2182644,'1','149','770',328,'Retail Sale Id 1288794',1798.40,0.00,0.00,0.00,134.88,'2021-12-06 14:19:39','',''),(2182645,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-06 14:19:39','',''),(2182690,'1','149','770',328,'Retail Sale Id 1288816',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 14:22:10','',''),(2182691,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 14:22:10','',''),(2182722,'1','149','770',328,'Retail Sale Id 1288832',4198.40,0.00,0.00,0.00,314.88,'2021-12-06 14:24:01','',''),(2182723,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.56,0.00,'2021-12-06 14:24:01','',''),(2182760,'1','149','770',328,'Retail Sale Id 1288852',697.60,0.00,0.00,0.00,52.32,'2021-12-06 14:26:16','',''),(2182761,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 14:26:16','',''),(2182778,'1','149','770',328,'Retail Sale Id 1288860',1702.40,0.00,0.00,0.00,127.68,'2021-12-06 14:27:02','',''),(2182779,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-06 14:27:02','',''),(2182806,'1','149','770',328,'Retail Sale Id 1288876',1600.00,0.00,0.00,0.00,120.00,'2021-12-06 14:28:40','',''),(2182807,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 14:28:40','',''),(2182832,'1','149','770',328,'Retail Sale Id 1288891',652.80,0.00,0.00,0.00,48.96,'2021-12-06 14:30:32','',''),(2182833,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-06 14:30:32','',''),(2182854,'1','149','770',328,'Retail Sale Id 1288901',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 14:31:49','',''),(2182855,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 14:31:49','',''),(2182899,'1','149','770',328,'Retail Sale Id 1288922',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 14:33:37','',''),(2182900,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 14:33:37','',''),(2182913,'1','149','770',328,'Retail Sale Id 1288930',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 14:34:28','',''),(2182914,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 14:34:28','',''),(2182926,'1','149','770',328,'Retail Sale Id 1288933',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 14:35:20','',''),(2182927,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 14:35:20','',''),(2182944,'1','149','770',328,'Retail Sale Id 1288942',32000.00,0.00,0.00,0.00,2400.00,'2021-12-06 14:36:13','',''),(2182945,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 14:36:13','',''),(2182960,'1','149','770',328,'Retail Sale Id 1288950',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 14:37:09','',''),(2182961,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 14:37:09','',''),(2182972,'1','149','770',328,'Retail Sale Id 1288956',998.40,0.00,0.00,0.00,74.88,'2021-12-06 14:38:19','',''),(2182973,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 14:38:19','',''),(2183078,'1','149','770',328,'Retail Sale Id 1288992',1600.00,0.00,0.00,0.00,120.00,'2021-12-06 14:42:40','',''),(2183079,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 14:42:40','',''),(2183107,'1','149','770',328,'Retail Sale Id 1289005',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 14:43:57','',''),(2183108,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 14:43:57','',''),(2183178,'1','149','770',328,'Retail Sale Id 1289038',800.00,0.00,0.00,0.00,60.00,'2021-12-06 14:47:58','',''),(2183179,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-06 14:47:58','',''),(2183198,'1','149','770',328,'Retail Sale Id 1289044',998.40,0.00,0.00,0.00,74.88,'2021-12-06 14:48:59','',''),(2183199,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 14:48:59','',''),(2183220,'1','149','770',328,'Retail Sale Id 1289054',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 14:49:50','',''),(2183221,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 14:49:50','',''),(2183242,'1','149','770',328,'Retail Sale Id 1289068',4998.40,0.00,0.00,0.00,374.88,'2021-12-06 14:51:06','',''),(2183243,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 14:51:06','',''),(2183277,'1','149','770',328,'Retail Sale Id 1289079',8960.00,0.00,0.00,0.00,672.00,'2021-12-06 14:52:37','',''),(2183278,'1','149','770',328,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-06 14:52:37','',''),(2183301,'1','149','770',328,'Retail Sale Id 1289091',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 14:53:34','',''),(2183302,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 14:53:34','',''),(2183331,'1','149','770',328,'Retail Sale Id 1289106',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 14:55:06','',''),(2183332,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 14:55:06','',''),(2183353,'1','149','770',328,'Retail Sale Id 1289116',1702.40,0.00,0.00,0.00,127.68,'2021-12-06 14:55:57','',''),(2183354,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-06 14:55:57','',''),(2183369,'1','149','770',328,'Retail Sale Id 1289124',64000.00,0.00,0.00,0.00,4800.00,'2021-12-06 14:56:47','',''),(2183370,'1','149','770',328,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 14:56:47','',''),(2183405,'1','149','770',328,'Retail Sale Id 1289141',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 14:58:41','',''),(2183406,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 14:58:41','',''),(2183425,'1','149','770',328,'Retail Sale Id 1289153',6400.00,0.00,0.00,0.00,480.00,'2021-12-06 15:00:07','',''),(2183426,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 15:00:07','',''),(2183469,'1','149','770',328,'Retail Sale Id 1289178',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 15:02:34','',''),(2183470,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 15:02:34','',''),(2183483,'1','149','770',328,'Retail Sale Id 1289186',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 15:03:28','',''),(2183484,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 15:03:28','',''),(2183521,'1','149','770',328,'Retail Sale Id 1289201',2598.40,0.00,0.00,0.00,194.88,'2021-12-06 15:05:14','',''),(2183522,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-06 15:05:14','',''),(2183543,'1','149','770',328,'Retail Sale Id 1289214',998.40,0.00,0.00,0.00,74.88,'2021-12-06 15:06:44','',''),(2183545,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 15:06:44','',''),(2183562,'1','149','770',328,'Retail Sale Id 1289223',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:07:55','',''),(2183563,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:07:55','',''),(2183629,'1','149','770',328,'Retail Sale Id 1289250',4499.20,0.00,0.00,0.00,337.44,'2021-12-06 15:11:49','',''),(2183630,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-06 15:11:49','',''),(2183665,'1','149','770',328,'Retail Sale Id 1289266',652.80,0.00,0.00,0.00,48.96,'2021-12-06 15:13:55','',''),(2183666,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-06 15:13:55','',''),(2183722,'1','149','770',328,'Retail Sale Id 1289287',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 15:16:37','',''),(2183723,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 15:16:37','',''),(2183768,'1','149','770',328,'Retail Sale Id 1289315',998.40,0.00,0.00,0.00,74.88,'2021-12-06 15:19:24','',''),(2183769,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 15:19:24','',''),(2183841,'1','149','770',328,'Retail Sale Id 1289344',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 15:22:14','',''),(2183842,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 15:22:15','',''),(2183878,'1','149','770',328,'Retail Sale Id 1289353',652.80,0.00,0.00,0.00,48.96,'2021-12-06 15:23:01','',''),(2183879,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-06 15:23:01','',''),(2183893,'1','149','770',328,'Retail Sale Id 1289364',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 15:23:46','',''),(2183894,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 15:23:47','',''),(2183917,'1','149','770',328,'Retail Sale Id 1289377',2598.40,0.00,0.00,0.00,194.88,'2021-12-06 15:24:38','',''),(2183918,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-06 15:24:38','',''),(2183945,'1','149','770',328,'Retail Sale Id 1289389',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 15:26:00','',''),(2183946,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 15:26:00','',''),(2184029,'1','149','770',328,'Retail Sale Id 1289435',3500.80,0.00,0.00,0.00,262.56,'2021-12-06 15:30:52','',''),(2184030,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-06 15:30:52','',''),(2184103,'1','149','770',328,'Retail Sale Id 1289471',3500.80,0.00,0.00,0.00,262.56,'2021-12-06 15:34:57','',''),(2184104,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-06 15:34:57','',''),(2184126,'1','149','770',328,'Retail Sale Id 1289482',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 15:36:27','',''),(2184127,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 15:36:27','',''),(2184238,'1','149','770',328,'Retail Sale Id 1289521',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 15:40:17','',''),(2184239,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 15:40:17','',''),(2184284,'1','149','770',328,'Retail Sale Id 1289536',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 15:41:42','',''),(2184285,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:41:42','',''),(2184416,'1','149','770',328,'Retail Sale Id 1289578',998.40,0.00,0.00,0.00,74.88,'2021-12-06 15:45:51','',''),(2184417,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 15:45:51','',''),(2184452,'1','149','770',328,'Retail Sale Id 1289590',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:47:21','',''),(2184453,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:47:21','',''),(2184464,'1','149','770',328,'Retail Sale Id 1289596',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 15:48:14','',''),(2184465,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 15:48:14','',''),(2184486,'1','149','770',328,'Retail Sale Id 1289604',697.60,0.00,0.00,0.00,52.32,'2021-12-06 15:49:13','',''),(2184487,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 15:49:13','',''),(2184532,'1','149','770',328,'Retail Sale Id 1289629',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 15:51:28','',''),(2184533,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 15:51:28','',''),(2184550,'1','149','770',328,'Retail Sale Id 1289639',652.80,0.00,0.00,0.00,48.96,'2021-12-06 15:52:46','',''),(2184551,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-06 15:52:46','',''),(2184578,'1','149','770',328,'Retail Sale Id 1289650',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 15:54:02','',''),(2184579,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 15:54:02','',''),(2184646,'1','149','770',328,'Retail Sale Id 1289683',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 15:57:36','',''),(2184647,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 15:57:36','',''),(2184677,'1','149','770',328,'Retail Sale Id 1289698',6400.00,0.00,0.00,0.00,480.00,'2021-12-06 15:59:08','',''),(2184678,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 15:59:08','',''),(2184704,'1','149','770',328,'Retail Sale Id 1289711',3500.80,0.00,0.00,0.00,262.56,'2021-12-06 16:00:50','',''),(2184705,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-06 16:00:50','',''),(2184739,'1','149','770',328,'Retail Sale Id 1289726',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 16:03:00','',''),(2184740,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 16:03:00','',''),(2184773,'1','149','770',328,'Retail Sale Id 1289740',652.80,0.00,0.00,0.00,48.96,'2021-12-06 16:04:59','',''),(2184774,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-06 16:04:59','',''),(2184793,'1','149','770',328,'Retail Sale Id 1289751',800.00,0.00,0.00,0.00,60.00,'2021-12-06 16:06:06','',''),(2184794,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-06 16:06:06','',''),(2184901,'1','149','770',328,'Retail Sale Id 1289800',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 16:13:44','',''),(2184902,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 16:13:44','',''),(2184972,'1','149','770',328,'Retail Sale Id 1289831',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 16:17:44','',''),(2184973,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 16:17:44','',''),(2185052,'1','149','770',328,'Retail Sale Id 1289873',652.80,0.00,0.00,0.00,48.96,'2021-12-06 16:21:43','',''),(2185053,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-06 16:21:43','',''),(2185079,'1','149','770',328,'Retail Sale Id 1289884',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 16:23:02','',''),(2185080,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 16:23:02','',''),(2185108,'1','149','770',328,'Retail Sale Id 1289899',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 16:24:25','',''),(2185109,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 16:24:25','',''),(2185169,'1','149','770',328,'Retail Sale Id 1289931',998.40,0.00,0.00,0.00,74.88,'2021-12-06 16:27:54','',''),(2185170,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 16:27:54','',''),(2185228,'1','149','770',328,'Retail Sale Id 1289961',1401.60,0.00,0.00,0.00,105.12,'2021-12-06 16:30:44','',''),(2185229,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-06 16:30:44','',''),(2185262,'1','149','770',328,'Retail Sale Id 1289980',1452.80,0.00,0.00,0.00,108.96,'2021-12-06 16:32:29','',''),(2185263,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.27,0.00,'2021-12-06 16:32:29','',''),(2185289,'1','149','770',328,'Retail Sale Id 1289991',902.40,0.00,0.00,0.00,67.68,'2021-12-06 16:33:34','',''),(2185290,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-06 16:33:34','',''),(2185332,'1','149','770',328,'Retail Sale Id 1290011',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 16:35:52','',''),(2185333,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:35:52','',''),(2185399,'1','149','770',328,'Retail Sale Id 1290043',697.60,0.00,0.00,0.00,52.32,'2021-12-06 16:39:45','',''),(2185400,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 16:39:45','',''),(2185438,'1','149','770',328,'Retail Sale Id 1290057',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 16:41:40','',''),(2185439,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 16:41:40','',''),(2185495,'1','149','770',328,'Retail Sale Id 1290087',998.40,0.00,0.00,0.00,74.88,'2021-12-06 16:45:52','',''),(2185496,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 16:45:52','',''),(2185531,'1','149','770',328,'Retail Sale Id 1290104',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 16:47:23','',''),(2185532,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 16:47:23','',''),(2185610,'1','149','770',328,'Retail Sale Id 1290142',800.00,0.00,0.00,0.00,60.00,'2021-12-06 16:50:41','',''),(2185611,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-06 16:50:41','',''),(2185720,'1','149','770',328,'Retail Sale Id 1290202',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 16:57:02','',''),(2185721,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 16:57:02','',''),(2185758,'1','149','770',328,'Retail Sale Id 1290223',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 16:59:46','',''),(2185759,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 16:59:46','',''),(2185772,'1','149','770',328,'Retail Sale Id 1290232',652.80,0.00,0.00,0.00,48.96,'2021-12-06 17:00:43','',''),(2185773,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-06 17:00:43','',''),(2185790,'1','149','770',328,'Retail Sale Id 1290240',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 17:02:05','',''),(2185791,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 17:02:05','',''),(2185812,'1','149','770',328,'Retail Sale Id 1290255',5760.00,0.00,0.00,0.00,432.00,'2021-12-06 17:03:47','',''),(2185813,'1','149','770',328,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-06 17:03:47','',''),(2185852,'1','149','770',328,'Retail Sale Id 1290273',2598.40,0.00,0.00,0.00,194.88,'2021-12-06 17:06:25','',''),(2185853,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-06 17:06:25','',''),(2185911,'1','149','770',328,'Retail Sale Id 1290304',652.80,0.00,0.00,0.00,48.96,'2021-12-06 17:10:20','',''),(2185912,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-06 17:10:20','',''),(2185949,'1','149','770',328,'Retail Sale Id 1290325',697.60,0.00,0.00,0.00,52.32,'2021-12-06 17:12:34','',''),(2185950,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 17:12:34','',''),(2185977,'1','149','770',328,'Retail Sale Id 1290340',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 17:14:22','',''),(2185978,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 17:14:22','',''),(2185987,'1','149','770',328,'Retail Sale Id 1290345',1600.00,0.00,0.00,0.00,120.00,'2021-12-06 17:15:20','',''),(2185988,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 17:15:20','',''),(2186001,'1','149','770',328,'Retail Sale Id 1290352',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 17:16:36','',''),(2186002,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 17:16:36','',''),(2186021,'1','149','770',328,'Retail Sale Id 1290365',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 17:19:29','',''),(2186022,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 17:19:29','',''),(2186029,'1','149','770',328,'Retail Sale Id 1290369',652.80,0.00,0.00,0.00,48.96,'2021-12-06 17:20:24','',''),(2186030,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-06 17:20:24','',''),(2186039,'1','149','770',328,'Retail Sale Id 1290376',998.40,0.00,0.00,0.00,74.88,'2021-12-06 17:21:57','',''),(2186040,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 17:21:57','',''),(2186094,'1','149','770',328,'Retail Sale Id 1290396',800.00,0.00,0.00,0.00,60.00,'2021-12-06 17:26:12','',''),(2186095,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-06 17:26:12','',''),(2186104,'1','149','770',328,'Retail Sale Id 1290405',2598.40,0.00,0.00,0.00,194.88,'2021-12-06 17:27:03','',''),(2186105,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-06 17:27:03','',''),(2186178,'1','149','770',328,'Retail Sale Id 1290435',998.40,0.00,0.00,0.00,74.88,'2021-12-06 17:33:55','',''),(2186179,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 17:33:55','',''),(2186286,'1','149',NULL,328,'Purchased from AA RANO NIGERIA LIMITED',0.00,1308320.00,2210.00,0.00,0.00,'2021-12-06 17:46:26','',''),(2186293,'1','149',NULL,328,'Reception corrector for bridging 126398',0.00,0.00,0.00,2210.00,0.00,'2021-12-06 17:47:31','',''),(2186294,'1','149','770',328,'Received from bridging 126398',0.00,0.00,2210.00,0.00,0.00,'2021-12-06 17:47:31','',''),(2186447,'1','149','770',328,'Retail Sale Id 1290562',502585.60,0.00,0.00,0.00,37693.92,'2021-12-06 18:13:18','',''),(2186448,'1','149','770',328,'Retail sales',0.00,0.00,0.00,785.29,0.00,'2021-12-06 18:13:18','',''),(2187154,'1','149','770',328,'Retail Sale Id 1290665',5203.20,0.00,0.00,0.00,390.24,'2021-12-07 06:00:52','',''),(2187155,'1','149','770',328,'Retail sales',0.00,0.00,0.00,8.13,0.00,'2021-12-07 06:00:52','',''),(2187162,'1','149','770',328,'Retail Sale Id 1290669',3852.80,0.00,0.00,0.00,288.96,'2021-12-07 06:01:43','',''),(2187163,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 06:01:43','',''),(2187172,'1','149','770',328,'Retail Sale Id 1290676',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 06:03:11','',''),(2187173,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:03:11','',''),(2187198,'1','149','770',328,'Retail Sale Id 1290686',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 06:05:19','',''),(2187199,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 06:05:19','',''),(2187220,'1','149','770',328,'Retail Sale Id 1290697',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 06:07:02','',''),(2187221,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 06:07:02','',''),(2187228,'1','149','770',328,'Retail Sale Id 1290701',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 06:08:00','',''),(2187229,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 06:08:00','',''),(2187250,'1','149','770',328,'Retail Sale Id 1290711',652.80,0.00,0.00,0.00,48.96,'2021-12-07 06:10:12','',''),(2187251,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-07 06:10:12','',''),(2187262,'1','149','770',328,'Retail Sale Id 1290718',3852.80,0.00,0.00,0.00,288.96,'2021-12-07 06:11:13','',''),(2187263,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 06:11:13','',''),(2187270,'1','149','770',328,'Retail Sale Id 1290722',7001.60,0.00,0.00,0.00,525.12,'2021-12-07 06:12:27','',''),(2187271,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-07 06:12:27','',''),(2187307,'1','149','770',328,'Retail Sale Id 1290738',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 06:15:52','',''),(2187308,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 06:15:52','',''),(2187320,'1','149','770',328,'Retail Sale Id 1290742',32000.00,0.00,0.00,0.00,2400.00,'2021-12-07 06:17:05','',''),(2187321,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 06:17:05','',''),(2187326,'1','149','770',328,'Retail Sale Id 1290746',3852.80,0.00,0.00,0.00,288.96,'2021-12-07 06:17:44','',''),(2187327,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 06:17:44','',''),(2187378,'1','149','770',328,'Retail Sale Id 1290773',3500.80,0.00,0.00,0.00,262.56,'2021-12-07 06:22:15','',''),(2187379,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-07 06:22:15','',''),(2187394,'1','149','770',328,'Retail Sale Id 1290781',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 06:23:10','',''),(2187395,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 06:23:10','',''),(2187464,'1','149','770',328,'Retail Sale Id 1290818',998.40,0.00,0.00,0.00,74.88,'2021-12-07 06:28:54','',''),(2187465,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 06:28:54','',''),(2187561,'1','149','770',328,'Retail Sale Id 1290866',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 06:36:46','',''),(2187562,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 06:36:46','',''),(2187579,'1','149','770',328,'Retail Sale Id 1290875',1299.20,0.00,0.00,0.00,97.44,'2021-12-07 06:38:14','',''),(2187580,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-07 06:38:14','',''),(2187599,'1','149','770',328,'Retail Sale Id 1290886',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 06:39:36','',''),(2187600,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:39:36','',''),(2187645,'1','149','770',328,'Retail Sale Id 1290910',8320.00,0.00,0.00,0.00,624.00,'2021-12-07 06:42:21','',''),(2187646,'1','149','770',328,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-07 06:42:21','',''),(2187663,'1','149','770',328,'Retail Sale Id 1290921',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 06:43:18','',''),(2187664,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 06:43:18','',''),(2187681,'1','149','770',328,'Retail Sale Id 1290932',6720.00,0.00,0.00,0.00,504.00,'2021-12-07 06:44:50','',''),(2187682,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.50,0.00,'2021-12-07 06:44:50','',''),(2187730,'1','149','770',328,'Retail Sale Id 1290958',1952.00,0.00,0.00,0.00,146.40,'2021-12-07 06:48:33','',''),(2187731,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 06:48:33','',''),(2187739,'1','149','770',328,'Retail Sale Id 1290962',3500.80,0.00,0.00,0.00,262.56,'2021-12-07 06:49:33','',''),(2187740,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-07 06:49:33','',''),(2187782,'1','149','770',328,'Retail Sale Id 1290976',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 06:50:59','',''),(2187783,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:50:59','',''),(2187898,'1','149','770',328,'Retail Sale Id 1291021',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 06:58:20','',''),(2187899,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 06:58:20','',''),(2187918,'1','149','770',328,'Retail Sale Id 1291033',2502.40,0.00,0.00,0.00,187.68,'2021-12-07 06:59:27','',''),(2187919,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-07 06:59:27','',''),(2187938,'1','149','770',328,'Retail Sale Id 1291042',1798.40,0.00,0.00,0.00,134.88,'2021-12-07 07:00:23','',''),(2187939,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-07 07:00:23','',''),(2187984,'1','149','770',328,'Retail Sale Id 1291068',652.80,0.00,0.00,0.00,48.96,'2021-12-07 07:02:40','',''),(2187985,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-07 07:02:40','',''),(2188014,'1','149','770',328,'Retail Sale Id 1291083',3500.80,0.00,0.00,0.00,262.56,'2021-12-07 07:04:16','',''),(2188015,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-07 07:04:16','',''),(2188042,'1','149','770',328,'Retail Sale Id 1291096',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 07:05:25','',''),(2188043,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 07:05:25','',''),(2188070,'1','149','770',328,'Retail Sale Id 1291109',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 07:06:50','',''),(2188071,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 07:06:50','',''),(2188102,'1','149','770',328,'Retail Sale Id 1291121',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 07:07:59','',''),(2188103,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 07:07:59','',''),(2188114,'1','149','770',328,'Retail Sale Id 1291129',998.40,0.00,0.00,0.00,74.88,'2021-12-07 07:09:02','',''),(2188117,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 07:09:02','',''),(2188160,'1','149','770',328,'Retail Sale Id 1291157',1203.20,0.00,0.00,0.00,90.24,'2021-12-07 07:11:18','',''),(2188161,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-07 07:11:18','',''),(2188188,'1','149','770',328,'Retail Sale Id 1291170',2598.40,0.00,0.00,0.00,194.88,'2021-12-07 07:12:48','',''),(2188189,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-07 07:12:48','',''),(2188264,'1','149','770',328,'Retail Sale Id 1291200',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 07:15:56','',''),(2188265,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 07:15:56','',''),(2188286,'1','149','770',328,'Retail Sale Id 1291213',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 07:16:59','',''),(2188287,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 07:16:59','',''),(2188324,'1','149','770',328,'Retail Sale Id 1291236',998.40,0.00,0.00,0.00,74.88,'2021-12-07 07:18:55','',''),(2188325,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 07:18:55','',''),(2188358,'1','149','770',328,'Retail Sale Id 1291260',2803.20,0.00,0.00,0.00,210.24,'2021-12-07 07:20:31','',''),(2188359,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-07 07:20:31','',''),(2188416,'1','149','770',328,'Retail Sale Id 1291286',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 07:23:28','',''),(2188417,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 07:23:28','',''),(2188470,'1','149','770',328,'Retail Sale Id 1291309',1952.00,0.00,0.00,0.00,146.40,'2021-12-07 07:25:27','',''),(2188471,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 07:25:27','',''),(2188532,'1','149','770',328,'Retail Sale Id 1291337',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 07:28:24','',''),(2188533,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 07:28:24','',''),(2188555,'1','149','770',328,'Retail Sale Id 1291349',1900.80,0.00,0.00,0.00,142.56,'2021-12-07 07:29:22','',''),(2188556,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-07 07:29:22','',''),(2188676,'1','149','770',328,'Retail Sale Id 1291416',3852.80,0.00,0.00,0.00,288.96,'2021-12-07 07:35:33','',''),(2188677,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 07:35:33','',''),(2188704,'1','149','770',328,'Retail Sale Id 1291429',4998.40,0.00,0.00,0.00,374.88,'2021-12-07 07:36:37','',''),(2188705,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-07 07:36:37','',''),(2188742,'1','149','770',328,'Retail Sale Id 1291448',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 07:38:22','',''),(2188743,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 07:38:22','',''),(2188774,'1','149','770',328,'Retail Sale Id 1291463',800.00,0.00,0.00,0.00,60.00,'2021-12-07 07:40:07','',''),(2188775,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-07 07:40:07','',''),(2188802,'1','149','770',328,'Retail Sale Id 1291478',1702.40,0.00,0.00,0.00,127.68,'2021-12-07 07:41:30','',''),(2188803,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-07 07:41:30','',''),(2188820,'1','149','770',328,'Retail Sale Id 1291487',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 07:42:20','',''),(2188821,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 07:42:20','',''),(2188852,'1','149','770',328,'Retail Sale Id 1291516',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 07:43:51','',''),(2188853,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 07:43:51','',''),(2188876,'1','149','770',328,'Retail Sale Id 1291532',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 07:45:22','',''),(2188877,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 07:45:22','',''),(2188914,'1','149','770',328,'Retail Sale Id 1291562',998.40,0.00,0.00,0.00,74.88,'2021-12-07 07:47:51','',''),(2188915,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 07:47:51','',''),(2188942,'1','149','770',328,'Retail Sale Id 1291577',1299.20,0.00,0.00,0.00,97.44,'2021-12-07 07:49:31','',''),(2188943,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-07 07:49:31','',''),(2188990,'1','149','770',328,'Retail Sale Id 1291597',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 07:51:54','',''),(2188991,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 07:51:54','',''),(2189008,'1','149','770',328,'Retail Sale Id 1291607',1952.00,0.00,0.00,0.00,146.40,'2021-12-07 07:53:00','',''),(2189009,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 07:53:00','',''),(2189049,'1','149','770',328,'Retail Sale Id 1291624',3302.40,0.00,0.00,0.00,247.68,'2021-12-07 07:55:03','',''),(2189050,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.16,0.00,'2021-12-07 07:55:03','',''),(2189077,'1','149','770',328,'Retail Sale Id 1291635',2502.40,0.00,0.00,0.00,187.68,'2021-12-07 07:56:26','',''),(2189078,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-07 07:56:26','',''),(2189091,'1','149','770',328,'Retail Sale Id 1291642',7500.80,0.00,0.00,0.00,562.56,'2021-12-07 07:57:23','',''),(2189092,'1','149','770',328,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-07 07:57:23','',''),(2189113,'1','149','770',328,'Retail Sale Id 1291652',998.40,0.00,0.00,0.00,74.88,'2021-12-07 07:59:04','',''),(2189114,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 07:59:04','',''),(2189161,'1','149','770',328,'Retail Sale Id 1291671',32000.00,0.00,0.00,0.00,2400.00,'2021-12-07 08:01:23','',''),(2189162,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 08:01:23','',''),(2189398,'1','149','770',328,'Retail Sale Id 1291783',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 08:14:12','',''),(2189399,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 08:14:12','',''),(2189420,'1','149','770',328,'Retail Sale Id 1291796',1952.00,0.00,0.00,0.00,146.40,'2021-12-07 08:15:53','',''),(2189421,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 08:15:53','',''),(2189453,'1','149','770',328,'Retail Sale Id 1291814',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 08:17:36','',''),(2189454,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:17:36','',''),(2189479,'1','149','770',328,'Retail Sale Id 1291826',697.60,0.00,0.00,0.00,52.32,'2021-12-07 08:19:16','',''),(2189480,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-07 08:19:16','',''),(2189499,'1','149','770',328,'Retail Sale Id 1291837',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 08:20:12','',''),(2189500,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 08:20:12','',''),(2189521,'1','149','770',328,'Retail Sale Id 1291848',7001.60,0.00,0.00,0.00,525.12,'2021-12-07 08:21:59','',''),(2189522,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-07 08:21:59','',''),(2189573,'1','149','770',328,'Retail Sale Id 1291870',6400.00,0.00,0.00,0.00,480.00,'2021-12-07 08:24:43','',''),(2189574,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 08:24:43','',''),(2189597,'1','149','770',328,'Retail Sale Id 1291879',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 08:26:17','',''),(2189598,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 08:26:17','',''),(2189609,'1','149','770',328,'Retail Sale Id 1291887',1600.00,0.00,0.00,0.00,120.00,'2021-12-07 08:27:18','',''),(2189610,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 08:27:18','',''),(2189621,'1','149','770',328,'Retail Sale Id 1291896',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 08:28:40','',''),(2189622,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 08:28:40','',''),(2189661,'1','149','770',328,'Retail Sale Id 1291915',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 08:31:07','',''),(2189662,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:31:07','',''),(2189677,'1','149','770',328,'Retail Sale Id 1291924',697.60,0.00,0.00,0.00,52.32,'2021-12-07 08:32:17','',''),(2189678,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-07 08:32:17','',''),(2189697,'1','149','770',328,'Retail Sale Id 1291936',2598.40,0.00,0.00,0.00,194.88,'2021-12-07 08:33:39','',''),(2189698,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-07 08:33:40','',''),(2189736,'1','149','770',328,'Retail Sale Id 1291948',998.40,0.00,0.00,0.00,74.88,'2021-12-07 08:34:42','',''),(2189737,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 08:34:42','',''),(2189762,'1','149','770',328,'Retail Sale Id 1291956',697.60,0.00,0.00,0.00,52.32,'2021-12-07 08:35:33','',''),(2189763,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-07 08:35:33','',''),(2189801,'1','149','770',328,'Retail Sale Id 1291965',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 08:36:50','',''),(2189802,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 08:36:50','',''),(2189848,'1','149','770',328,'Retail Sale Id 1291977',1299.20,0.00,0.00,0.00,97.44,'2021-12-07 08:39:05','',''),(2189849,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-07 08:39:05','',''),(2189870,'1','149','770',328,'Retail Sale Id 1291988',652.80,0.00,0.00,0.00,48.96,'2021-12-07 08:40:54','',''),(2189871,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-07 08:40:54','',''),(2189900,'1','149','770',328,'Retail Sale Id 1292007',1299.20,0.00,0.00,0.00,97.44,'2021-12-07 08:42:33','',''),(2189901,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-07 08:42:33','',''),(2189928,'1','149','770',328,'Retail Sale Id 1292019',1798.40,0.00,0.00,0.00,134.88,'2021-12-07 08:43:45','',''),(2189929,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-07 08:43:45','',''),(2189979,'1','149','770',328,'Retail Sale Id 1292034',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 08:45:41','',''),(2189980,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 08:45:42','',''),(2190019,'1','149','770',328,'Retail Sale Id 1292057',3852.80,0.00,0.00,0.00,288.96,'2021-12-07 08:47:57','',''),(2190020,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 08:47:57','',''),(2190080,'1','149','770',328,'Retail Sale Id 1292083',1952.00,0.00,0.00,0.00,146.40,'2021-12-07 08:50:29','',''),(2190081,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 08:50:29','',''),(2190132,'1','149','770',328,'Retail Sale Id 1292103',25600.00,0.00,0.00,0.00,1920.00,'2021-12-07 08:53:30','',''),(2190133,'1','149','770',328,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-07 08:53:30','',''),(2190154,'1','149','770',328,'Retail Sale Id 1292117',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 08:54:32','',''),(2190155,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 08:54:32','',''),(2190196,'1','149','770',328,'Retail Sale Id 1292140',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 08:57:05','',''),(2190197,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 08:57:05','',''),(2190204,'1','149','770',328,'Retail Sale Id 1292146',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 08:58:15','',''),(2190205,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 08:58:15','',''),(2190248,'1','149','770',328,'Retail Sale Id 1292165',2502.40,0.00,0.00,0.00,187.68,'2021-12-07 09:01:17','',''),(2190249,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-07 09:01:17','',''),(2190305,'1','149','770',328,'Retail Sale Id 1292196',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 09:05:44','',''),(2190306,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 09:05:44','',''),(2190339,'1','149','770',328,'Retail Sale Id 1292207',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 09:06:54','',''),(2190340,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 09:06:54','',''),(2190353,'1','149','770',328,'Retail Sale Id 1292215',1952.00,0.00,0.00,0.00,146.40,'2021-12-07 09:07:56','',''),(2190354,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 09:07:56','',''),(2190399,'1','149','770',328,'Retail Sale Id 1292238',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 09:09:55','',''),(2190400,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 09:09:55','',''),(2190423,'1','149','770',328,'Retail Sale Id 1292251',1203.20,0.00,0.00,0.00,90.24,'2021-12-07 09:11:32','',''),(2190424,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-07 09:11:32','',''),(2190447,'1','149','770',328,'Retail Sale Id 1292265',998.40,0.00,0.00,0.00,74.88,'2021-12-07 09:12:37','',''),(2190448,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 09:12:37','',''),(2190497,'1','149','770',328,'Retail Sale Id 1292291',652.80,0.00,0.00,0.00,48.96,'2021-12-07 09:15:01','',''),(2190498,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-07 09:15:01','',''),(2190529,'1','149','770',328,'Retail Sale Id 1292310',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 09:16:47','',''),(2190530,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:16:47','',''),(2190567,'1','149','770',328,'Retail Sale Id 1292329',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 09:19:18','',''),(2190568,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 09:19:18','',''),(2190595,'1','149','770',328,'Retail Sale Id 1292340',652.80,0.00,0.00,0.00,48.96,'2021-12-07 09:20:35','',''),(2190596,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-07 09:20:35','',''),(2190623,'1','149','770',328,'Retail Sale Id 1292351',998.40,0.00,0.00,0.00,74.88,'2021-12-07 09:21:55','',''),(2190624,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 09:21:55','',''),(2190663,'1','149','770',328,'Retail Sale Id 1292368',3852.80,0.00,0.00,0.00,288.96,'2021-12-07 09:24:07','',''),(2190664,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 09:24:07','',''),(2190681,'1','149','770',328,'Retail Sale Id 1292377',800.00,0.00,0.00,0.00,60.00,'2021-12-07 09:24:53','',''),(2190682,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-07 09:24:53','',''),(2190697,'1','149','770',328,'Retail Sale Id 1292385',7040.00,0.00,0.00,0.00,528.00,'2021-12-07 09:26:15','',''),(2190698,'1','149','770',328,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-07 09:26:15','',''),(2190731,'1','149','770',328,'Retail Sale Id 1292400',2598.40,0.00,0.00,0.00,194.88,'2021-12-07 09:27:25','',''),(2190732,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-07 09:27:25','',''),(2190788,'1','149','770',328,'Retail Sale Id 1292426',1798.40,0.00,0.00,0.00,134.88,'2021-12-07 09:29:28','',''),(2190789,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-07 09:29:28','',''),(2190820,'1','149','770',328,'Retail Sale Id 1292441',6400.00,0.00,0.00,0.00,480.00,'2021-12-07 09:30:50','',''),(2190821,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 09:30:50','',''),(2190832,'1','149','770',328,'Retail Sale Id 1292448',1299.20,0.00,0.00,0.00,97.44,'2021-12-07 09:31:56','',''),(2190833,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-07 09:31:56','',''),(2190864,'1','149','770',328,'Retail Sale Id 1292462',652.80,0.00,0.00,0.00,48.96,'2021-12-07 09:33:07','',''),(2190865,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-07 09:33:07','',''),(2190890,'1','149','770',328,'Retail Sale Id 1292475',1952.00,0.00,0.00,0.00,146.40,'2021-12-07 09:34:37','',''),(2190891,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 09:34:37','',''),(2190922,'1','149','770',328,'Retail Sale Id 1292490',2502.40,0.00,0.00,0.00,187.68,'2021-12-07 09:36:14','',''),(2190923,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-07 09:36:14','',''),(2190966,'1','149','770',328,'Retail Sale Id 1292516',17280.00,0.00,0.00,0.00,1296.00,'2021-12-07 09:39:14','',''),(2190967,'1','149','770',328,'Retail sales',0.00,0.00,0.00,27.00,0.00,'2021-12-07 09:39:14','',''),(2191042,'1','149','770',328,'Retail Sale Id 1292555',17920.00,0.00,0.00,0.00,1344.00,'2021-12-07 09:42:36','',''),(2191043,'1','149','770',328,'Retail sales',0.00,0.00,0.00,28.00,0.00,'2021-12-07 09:42:36','',''),(2191052,'1','149','770',328,'Retail Sale Id 1292562',1203.20,0.00,0.00,0.00,90.24,'2021-12-07 09:43:40','',''),(2191053,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-07 09:43:40','',''),(2191092,'1','149','770',328,'Retail Sale Id 1292582',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 09:46:25','',''),(2191093,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 09:46:25','',''),(2191104,'1','149','770',328,'Retail Sale Id 1292588',998.40,0.00,0.00,0.00,74.88,'2021-12-07 09:48:30','',''),(2191105,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 09:48:30','',''),(2191138,'1','149','770',328,'Retail Sale Id 1292602',652.80,0.00,0.00,0.00,48.96,'2021-12-07 09:50:21','',''),(2191139,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-07 09:50:21','',''),(2191162,'1','149','770',328,'Retail Sale Id 1292619',1299.20,0.00,0.00,0.00,97.44,'2021-12-07 09:52:09','',''),(2191163,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-07 09:52:09','',''),(2191226,'1','149','770',328,'Retail Sale Id 1292655',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 09:56:31','',''),(2191227,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 09:56:31','',''),(2191417,'1','149','770',328,'Retail Sale Id 1292747',652.80,0.00,0.00,0.00,48.96,'2021-12-07 10:09:27','',''),(2191418,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-07 10:09:27','',''),(2191445,'1','149','770',328,'Retail Sale Id 1292766',2598.40,0.00,0.00,0.00,194.88,'2021-12-07 10:11:28','',''),(2191446,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-07 10:11:28','',''),(2191493,'1','149','770',328,'Retail Sale Id 1292792',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 10:14:38','',''),(2191494,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 10:14:38','',''),(2191539,'1','149','770',328,'Retail Sale Id 1292818',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 10:17:20','',''),(2191540,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 10:17:20','',''),(2191579,'1','149','770',328,'Retail Sale Id 1292838',998.40,0.00,0.00,0.00,74.88,'2021-12-07 10:20:33','',''),(2191580,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 10:20:33','',''),(2191617,'1','149','770',328,'Retail Sale Id 1292857',4160.00,0.00,0.00,0.00,312.00,'2021-12-07 10:23:19','',''),(2191618,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-07 10:23:19','',''),(2191700,'1','149','770',328,'Retail Sale Id 1292897',652.80,0.00,0.00,0.00,48.96,'2021-12-07 10:30:46','',''),(2191701,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-07 10:30:46','',''),(2191716,'1','149','770',328,'Retail Sale Id 1292904',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 10:32:03','',''),(2191717,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 10:32:03','',''),(2191775,'1','149','770',328,'Retail Sale Id 1292937',652.80,0.00,0.00,0.00,48.96,'2021-12-07 10:36:47','',''),(2191776,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-07 10:36:47','',''),(2191821,'1','149','770',328,'Retail Sale Id 1292961',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 10:39:21','',''),(2191822,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:39:21','',''),(2191841,'1','149','770',328,'Retail Sale Id 1292970',1702.40,0.00,0.00,0.00,127.68,'2021-12-07 10:40:31','',''),(2191843,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-07 10:40:31','',''),(2191889,'1','149','770',328,'Retail Sale Id 1292995',3852.80,0.00,0.00,0.00,288.96,'2021-12-07 10:43:08','',''),(2191890,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 10:43:08','',''),(2191923,'1','149','770',328,'Retail Sale Id 1293008',64000.00,0.00,0.00,0.00,4800.00,'2021-12-07 10:44:42','',''),(2191924,'1','149','770',328,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-07 10:44:42','',''),(2191965,'1','149','770',328,'Retail Sale Id 1293022',1299.20,0.00,0.00,0.00,97.44,'2021-12-07 10:46:26','',''),(2191966,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-07 10:46:26','',''),(2191990,'1','149','770',328,'Retail Sale Id 1293034',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 10:47:45','',''),(2191991,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 10:47:45','',''),(2192036,'1','149','770',328,'Retail Sale Id 1293059',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 10:49:58','',''),(2192037,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 10:49:58','',''),(2192062,'1','149','770',328,'Retail Sale Id 1293073',1952.00,0.00,0.00,0.00,146.40,'2021-12-07 10:51:28','',''),(2192063,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 10:51:28','',''),(2192096,'1','149','770',328,'Retail Sale Id 1293085',1203.20,0.00,0.00,0.00,90.24,'2021-12-07 10:53:05','',''),(2192097,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-07 10:53:05','',''),(2192142,'1','149','770',328,'Retail Sale Id 1293111',902.40,0.00,0.00,0.00,67.68,'2021-12-07 10:55:37','',''),(2192143,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-07 10:55:37','',''),(2192167,'1','149','770',328,'Retail Sale Id 1293124',1100.80,0.00,0.00,0.00,82.56,'2021-12-07 10:57:08','',''),(2192168,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.72,0.00,'2021-12-07 10:57:08','',''),(2192187,'1','149','770',328,'Retail Sale Id 1293132',1900.80,0.00,0.00,0.00,142.56,'2021-12-07 10:58:14','',''),(2192188,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-07 10:58:14','',''),(2192209,'1','149','770',328,'Retail Sale Id 1293146',2598.40,0.00,0.00,0.00,194.88,'2021-12-07 10:59:14','',''),(2192210,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-07 10:59:14','',''),(2192332,'1','149','770',328,'Retail Sale Id 1293190',6400.00,0.00,0.00,0.00,480.00,'2021-12-07 11:05:04','',''),(2192333,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 11:05:04','',''),(2192377,'1','149','770',328,'Retail Sale Id 1293216',998.40,0.00,0.00,0.00,74.88,'2021-12-07 11:07:44','',''),(2192378,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 11:07:44','',''),(2192684,'1','149','770',328,'Retail Sale Id 1293405',1299.20,0.00,0.00,0.00,97.44,'2021-12-07 11:27:56','',''),(2192685,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-07 11:27:56','',''),(2192811,'1','149','770',328,'Retail Sale Id 1293467',902.40,0.00,0.00,0.00,67.68,'2021-12-07 11:36:38','',''),(2192812,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-07 11:36:38','',''),(2194067,'1','149','770',328,'Retail Sale Id 1294125',4998.40,0.00,0.00,0.00,374.88,'2021-12-07 13:13:23','',''),(2194068,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-07 13:13:23','',''),(2194079,'1','149','770',328,'Retail Sale Id 1294140',32000.00,0.00,0.00,0.00,2400.00,'2021-12-07 13:14:17','',''),(2194080,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 13:14:17','',''),(2194109,'1','149','770',328,'Retail Sale Id 1294155',998.40,0.00,0.00,0.00,74.88,'2021-12-07 13:16:15','',''),(2194110,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 13:16:15','',''),(2194125,'1','149','770',328,'Retail Sale Id 1294163',3852.80,0.00,0.00,0.00,288.96,'2021-12-07 13:17:35','',''),(2194126,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 13:17:35','',''),(2194147,'1','149','770',328,'Retail Sale Id 1294171',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 13:18:35','',''),(2194148,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 13:18:35','',''),(2194173,'1','149','770',328,'Retail Sale Id 1294185',32000.00,0.00,0.00,0.00,2400.00,'2021-12-07 13:20:05','',''),(2194174,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 13:20:05','',''),(2194217,'1','149','770',328,'Retail Sale Id 1294266',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 13:24:16','',''),(2194218,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 13:24:16','',''),(2194284,'1','149','770',328,'Retail Sale Id 1294291',1299.20,0.00,0.00,0.00,97.44,'2021-12-07 13:26:15','',''),(2194285,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-07 13:26:15','',''),(2194315,'1','149','770',328,'Retail Sale Id 1294332',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 13:27:30','',''),(2194316,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 13:27:30','',''),(2194336,'1','149','770',328,'Retail Sale Id 1294343',998.40,0.00,0.00,0.00,74.88,'2021-12-07 13:28:54','',''),(2194337,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 13:28:54','',''),(2196336,'1','149','770',328,'Retail Sale Id 1295279',409600.00,0.00,0.00,0.00,30720.00,'2021-12-07 15:20:37','',''),(2196337,'1','149','770',328,'Retail sales',0.00,0.00,0.00,640.00,0.00,'2021-12-07 15:20:37','',''),(2196407,'1','149',NULL,328,'Purchased from AA RANO NIGERIA LIMITED',0.00,46176.00,78.00,0.00,0.00,'2021-12-07 15:24:30','',''),(2196422,'1','149',NULL,328,'Reception corrector for bridging 126481',0.00,0.00,0.00,78.00,0.00,'2021-12-07 15:25:24','',''),(2196423,'1','149','770',328,'Received from bridging 126481',0.00,0.00,78.00,0.00,0.00,'2021-12-07 15:25:24','',''),(2196452,'1','149','770',328,'Retail Sale Id 1295345',50560.00,0.00,0.00,0.00,3792.00,'2021-12-07 15:26:07','',''),(2196453,'1','149','770',328,'Retail sales',0.00,0.00,0.00,79.00,0.00,'2021-12-07 15:26:07','',''),(2199765,'1','149',NULL,328,'Purchased from AA RANO NIGERIA LIMITED',0.00,1776000.00,3000.00,0.00,0.00,'2021-12-08 06:08:42','',''),(2199780,'1','149',NULL,328,'Reception corrector for bridging 126548',0.00,0.00,0.00,3000.00,0.00,'2021-12-08 06:09:46','',''),(2199781,'1','149','770',328,'Received from bridging 126548',0.00,0.00,3000.00,0.00,0.00,'2021-12-08 06:09:46','',''),(2199858,'1','149','770',328,'Retail Sale Id 1296830',998.40,0.00,0.00,0.00,74.88,'2021-12-08 06:20:56','',''),(2199859,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 06:20:56','',''),(2199896,'1','149','770',328,'Retail Sale Id 1296849',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 06:25:11','',''),(2199897,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:25:11','',''),(2199912,'1','149','770',328,'Retail Sale Id 1296856',32000.00,0.00,0.00,0.00,2400.00,'2021-12-08 06:27:21','',''),(2199913,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 06:27:21','',''),(2199956,'1','149','770',328,'Retail Sale Id 1296879',1203.20,0.00,0.00,0.00,90.24,'2021-12-08 06:33:17','',''),(2199957,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-08 06:33:17','',''),(2199970,'1','149','770',328,'Retail Sale Id 1296886',652.80,0.00,0.00,0.00,48.96,'2021-12-08 06:34:47','',''),(2199971,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-08 06:34:47','',''),(2200004,'1','149','770',328,'Retail Sale Id 1296898',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 06:37:21','',''),(2200005,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 06:37:21','',''),(2200186,'1','149','770',328,'Retail Sale Id 1296969',4160.00,0.00,0.00,0.00,312.00,'2021-12-08 06:46:38','',''),(2200187,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-08 06:46:38','',''),(2200304,'1','149','770',328,'Retail Sale Id 1297013',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 06:53:02','',''),(2200305,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 06:53:02','',''),(2200318,'1','149','770',328,'Retail Sale Id 1297021',3852.80,0.00,0.00,0.00,288.96,'2021-12-08 06:54:31','',''),(2200319,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 06:54:31','',''),(2200373,'1','149','770',328,'Retail Sale Id 1297040',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 06:56:22','',''),(2200374,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 06:56:22','',''),(2200401,'1','149','770',328,'Retail Sale Id 1297055',4998.40,0.00,0.00,0.00,374.88,'2021-12-08 06:57:55','',''),(2200402,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-08 06:57:55','',''),(2200439,'1','149','770',328,'Retail Sale Id 1297071',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 06:59:58','',''),(2200440,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 06:59:58','',''),(2200627,'1','149','770',328,'Retail Sale Id 1297165',3500.80,0.00,0.00,0.00,262.56,'2021-12-08 07:13:29','',''),(2200628,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-08 07:13:29','',''),(2200651,'1','149','770',328,'Retail Sale Id 1297179',652.80,0.00,0.00,0.00,48.96,'2021-12-08 07:14:50','',''),(2200652,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-08 07:14:51','',''),(2200687,'1','149','770',328,'Retail Sale Id 1297198',652.80,0.00,0.00,0.00,48.96,'2021-12-08 07:17:18','',''),(2200688,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-08 07:17:18','',''),(2200818,'1','149','770',328,'Retail Sale Id 1297252',3398.40,0.00,0.00,0.00,254.88,'2021-12-08 07:22:13','',''),(2200819,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.31,0.00,'2021-12-08 07:22:13','',''),(2200848,'1','149','770',328,'Retail Sale Id 1297266',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 07:24:02','',''),(2200849,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 07:24:02','',''),(2200905,'1','149','770',328,'Retail Sale Id 1297294',6502.40,0.00,0.00,0.00,487.68,'2021-12-08 07:27:52','',''),(2200906,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-08 07:27:52','',''),(2201055,'1','149','770',328,'Retail Sale Id 1297358',1299.20,0.00,0.00,0.00,97.44,'2021-12-08 07:34:44','',''),(2201056,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-08 07:34:44','',''),(2201140,'1','149','770',328,'Retail Sale Id 1297394',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 07:38:53','',''),(2201141,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 07:38:53','',''),(2201387,'1','149','770',328,'Retail Sale Id 1297520',3852.80,0.00,0.00,0.00,288.96,'2021-12-08 07:53:07','',''),(2201388,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 07:53:07','',''),(2201433,'1','149','770',328,'Retail Sale Id 1297529',1798.40,0.00,0.00,0.00,134.88,'2021-12-08 07:54:29','',''),(2201434,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-08 07:54:29','',''),(2201458,'1','149','770',328,'Retail Sale Id 1297536',902.40,0.00,0.00,0.00,67.68,'2021-12-08 07:55:09','',''),(2201459,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-08 07:55:09','',''),(2201507,'1','149','770',328,'Retail Sale Id 1297564',652.80,0.00,0.00,0.00,48.96,'2021-12-08 07:57:59','',''),(2201508,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-08 07:57:59','',''),(2201557,'1','149','770',328,'Retail Sale Id 1297582',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 08:00:17','',''),(2201558,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 08:00:17','',''),(2201593,'1','149','770',328,'Retail Sale Id 1297602',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 08:02:23','',''),(2201594,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:02:23','',''),(2201620,'1','149','770',328,'Retail Sale Id 1297613',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 08:03:44','',''),(2201621,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 08:03:44','',''),(2201657,'1','149','770',328,'Retail Sale Id 1297629',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 08:05:24','',''),(2201658,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 08:05:24','',''),(2201685,'1','149','770',328,'Retail Sale Id 1297646',1299.20,0.00,0.00,0.00,97.44,'2021-12-08 08:07:02','',''),(2201686,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-08 08:07:02','',''),(2201720,'1','149','770',328,'Retail Sale Id 1297663',998.40,0.00,0.00,0.00,74.88,'2021-12-08 08:10:22','',''),(2201721,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 08:10:22','',''),(2201817,'1','149','770',328,'Retail Sale Id 1297717',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 08:16:42','',''),(2201818,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 08:16:42','',''),(2201919,'1','149','770',328,'Retail Sale Id 1297772',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 08:23:14','',''),(2201920,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 08:23:14','',''),(2202014,'1','149','770',328,'Retail Sale Id 1297811',2598.40,0.00,0.00,0.00,194.88,'2021-12-08 08:29:03','',''),(2202015,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-08 08:29:03','',''),(2202028,'1','149','770',328,'Retail Sale Id 1297820',652.80,0.00,0.00,0.00,48.96,'2021-12-08 08:30:15','',''),(2202029,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-08 08:30:15','',''),(2202054,'1','149','770',328,'Retail Sale Id 1297829',38400.00,0.00,0.00,0.00,2880.00,'2021-12-08 08:31:59','',''),(2202055,'1','149','770',328,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-08 08:31:59','',''),(2202108,'1','149','770',328,'Retail Sale Id 1297860',6003.20,0.00,0.00,0.00,450.24,'2021-12-08 08:35:24','',''),(2202109,'1','149','770',328,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-08 08:35:24','',''),(2202116,'1','149','770',328,'Retail Sale Id 1297865',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 08:36:00','',''),(2202117,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 08:36:00','',''),(2202170,'1','149','770',328,'Retail Sale Id 1297886',2099.20,0.00,0.00,0.00,157.44,'2021-12-08 08:39:02','',''),(2202171,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.28,0.00,'2021-12-08 08:39:02','',''),(2202184,'1','149','770',328,'Retail Sale Id 1297893',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 08:39:54','',''),(2202185,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 08:39:54','',''),(2202224,'1','149','770',328,'Retail Sale Id 1297903',998.40,0.00,0.00,0.00,74.88,'2021-12-08 08:41:15','',''),(2202225,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 08:41:15','',''),(2202258,'1','149','770',328,'Retail Sale Id 1297914',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 08:42:35','',''),(2202259,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 08:42:35','',''),(2202328,'1','149','770',328,'Retail Sale Id 1297928',2598.40,0.00,0.00,0.00,194.88,'2021-12-08 08:44:32','',''),(2202329,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-08 08:44:32','',''),(2202490,'1','149','770',328,'Retail Sale Id 1297986',652.80,0.00,0.00,0.00,48.96,'2021-12-08 08:52:09','',''),(2202491,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-08 08:52:09','',''),(2202506,'1','149','770',328,'Retail Sale Id 1297992',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 08:53:12','',''),(2202507,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 08:53:12','',''),(2202566,'1','149','770',328,'Retail Sale Id 1298021',3852.80,0.00,0.00,0.00,288.96,'2021-12-08 08:55:46','',''),(2202567,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 08:55:46','',''),(2202584,'1','149','770',328,'Retail Sale Id 1298029',2297.60,0.00,0.00,0.00,172.32,'2021-12-08 08:57:19','',''),(2202585,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.59,0.00,'2021-12-08 08:57:19','',''),(2202648,'1','149','770',328,'Retail Sale Id 1298060',2803.20,0.00,0.00,0.00,210.24,'2021-12-08 09:01:36','',''),(2202649,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-08 09:01:36','',''),(2202819,'1','149','770',328,'Retail Sale Id 1298156',2598.40,0.00,0.00,0.00,194.88,'2021-12-08 09:11:29','',''),(2202820,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-08 09:11:29','',''),(2202825,'1','149','770',328,'Retail Sale Id 1298159',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 09:12:11','',''),(2202826,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 09:12:11','',''),(2202882,'1','149','770',328,'Retail Sale Id 1298180',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 09:14:51','',''),(2202883,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 09:14:51','',''),(2202966,'1','149','770',328,'Retail Sale Id 1298218',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 09:19:39','',''),(2202967,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 09:19:39','',''),(2202988,'1','149',NULL,328,'Purchased from AA RANO NIGERIA LIMITED',0.00,568320.00,960.00,0.00,0.00,'2021-12-08 09:21:12','',''),(2203005,'1','149',NULL,328,'Reception corrector for bridging 126566',0.00,0.00,0.00,960.00,0.00,'2021-12-08 09:22:06','',''),(2203006,'1','149','770',328,'Received from bridging 126566',0.00,0.00,960.00,0.00,0.00,'2021-12-08 09:22:06','',''),(2203131,'1','149','770',328,'Retail Sale Id 1298301',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 09:34:24','',''),(2203132,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:34:24','',''),(2203251,'1','149','770',328,'Retail Sale Id 1298365',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 09:44:38','',''),(2203252,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 09:44:38','',''),(2203354,'1','149','770',328,'Retail Sale Id 1298406',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 09:50:09','',''),(2203355,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 09:50:09','',''),(2203358,'1','149','770',328,'Retail Sale Id 1298408',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 09:50:41','',''),(2203359,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 09:50:41','',''),(2203398,'1','149','770',328,'Retail Sale Id 1298430',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 09:54:48','',''),(2203399,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 09:54:48','',''),(2203428,'1','149','770',328,'Retail Sale Id 1298446',9600.00,0.00,0.00,0.00,720.00,'2021-12-08 09:56:32','',''),(2203429,'1','149','770',328,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-08 09:56:32','',''),(2203460,'1','149','770',328,'Retail Sale Id 1298460',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 09:59:18','',''),(2203461,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 09:59:18','',''),(2203491,'1','149','770',328,'Retail Sale Id 1298473',7001.60,0.00,0.00,0.00,525.12,'2021-12-08 10:01:00','',''),(2203492,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-08 10:01:00','',''),(2203647,'1','149','770',328,'Retail Sale Id 1298539',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 10:11:20','',''),(2203648,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 10:11:20','',''),(2203677,'1','149','770',328,'Retail Sale Id 1298553',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 10:13:16','',''),(2203678,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 10:13:16','',''),(2203699,'1','149','770',328,'Retail Sale Id 1298565',998.40,0.00,0.00,0.00,74.88,'2021-12-08 10:14:30','',''),(2203702,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 10:14:30','',''),(2203713,'1','149','770',328,'Retail Sale Id 1298572',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 10:15:31','',''),(2203714,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 10:15:31','',''),(2203755,'1','149','770',328,'Retail Sale Id 1298589',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 10:17:25','',''),(2203756,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:17:25','',''),(2203809,'1','149','770',328,'Retail Sale Id 1298624',6502.40,0.00,0.00,0.00,487.68,'2021-12-08 10:22:07','',''),(2203810,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-08 10:22:07','',''),(2203985,'1','149','770',328,'Retail Sale Id 1298693',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 10:31:23','',''),(2203986,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 10:31:23','',''),(2204019,'1','149','770',328,'Retail Sale Id 1298711',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 10:33:52','',''),(2204020,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 10:33:52','',''),(2204037,'1','149','770',328,'Retail Sale Id 1298720',652.80,0.00,0.00,0.00,48.96,'2021-12-08 10:34:49','',''),(2204038,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-08 10:34:49','',''),(2204110,'1','149','770',328,'Retail Sale Id 1298762',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 10:41:39','',''),(2204111,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 10:41:39','',''),(2204131,'1','149','770',328,'Retail Sale Id 1298771',3852.80,0.00,0.00,0.00,288.96,'2021-12-08 10:42:47','',''),(2204132,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 10:42:47','',''),(2204145,'1','149','770',328,'Retail Sale Id 1298779',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 10:44:38','',''),(2204146,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 10:44:38','',''),(2204278,'1','149','770',328,'Retail Sale Id 1298844',998.40,0.00,0.00,0.00,74.88,'2021-12-08 10:56:35','',''),(2204279,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 10:56:35','',''),(2204329,'1','149','770',328,'Retail Sale Id 1298869',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 11:00:28','',''),(2204330,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 11:00:28','',''),(2204345,'1','149','770',328,'Retail Sale Id 1298878',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 11:02:12','',''),(2204346,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 11:02:12','',''),(2204436,'1','149','770',328,'Retail Sale Id 1298925',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 11:08:03','',''),(2204437,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 11:08:03','',''),(2204454,'1','149','770',328,'Retail Sale Id 1298934',2502.40,0.00,0.00,0.00,187.68,'2021-12-08 11:08:59','',''),(2204455,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-08 11:08:59','',''),(2204524,'1','149','770',328,'Retail Sale Id 1298974',1203.20,0.00,0.00,0.00,90.24,'2021-12-08 11:13:12','',''),(2204525,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-08 11:13:12','',''),(2204676,'1','149','770',328,'Retail Sale Id 1299048',3852.80,0.00,0.00,0.00,288.96,'2021-12-08 11:24:40','',''),(2204677,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 11:24:40','',''),(2204696,'1','149','770',328,'Retail Sale Id 1299061',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 11:26:08','',''),(2204697,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 11:26:08','',''),(2204704,'1','149','770',328,'Retail Sale Id 1299064',1798.40,0.00,0.00,0.00,134.88,'2021-12-08 11:27:17','',''),(2204705,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-08 11:27:17','',''),(2204736,'1','149','770',328,'Retail Sale Id 1299079',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 11:29:24','',''),(2204737,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 11:29:24','',''),(2204820,'1','149','770',328,'Retail Sale Id 1299125',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 11:35:23','',''),(2204821,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:35:23','',''),(2204868,'1','149','770',328,'Retail Sale Id 1299148',652.80,0.00,0.00,0.00,48.96,'2021-12-08 11:38:14','',''),(2204869,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-08 11:38:14','',''),(2204902,'1','149','770',328,'Retail Sale Id 1299165',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 11:39:16','',''),(2204903,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 11:39:16','',''),(2204978,'1','149','770',328,'Retail Sale Id 1299206',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 11:43:15','',''),(2204979,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 11:43:15','',''),(2205283,'1','149','770',328,'Retail Sale Id 1299342',652.80,0.00,0.00,0.00,48.96,'2021-12-08 12:06:28','',''),(2205284,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-08 12:06:28','',''),(2205337,'1','149','770',328,'Retail Sale Id 1299368',3801.60,0.00,0.00,0.00,285.12,'2021-12-08 12:10:20','',''),(2205338,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-08 12:10:20','',''),(2205373,'1','149','770',328,'Retail Sale Id 1299382',3852.80,0.00,0.00,0.00,288.96,'2021-12-08 12:13:02','',''),(2205374,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 12:13:02','',''),(2205389,'1','149','770',328,'Retail Sale Id 1299392',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 12:14:25','',''),(2205390,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 12:14:25','',''),(2205435,'1','149','770',328,'Retail Sale Id 1299412',1299.20,0.00,0.00,0.00,97.44,'2021-12-08 12:17:51','',''),(2205436,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-08 12:17:51','',''),(2205463,'1','149','770',328,'Retail Sale Id 1299426',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 12:21:02','',''),(2205464,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:21:02','',''),(2205505,'1','149','770',328,'Retail Sale Id 1299446',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 12:24:36','',''),(2205506,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 12:24:36','',''),(2205573,'1','149','770',328,'Retail Sale Id 1299481',7001.60,0.00,0.00,0.00,525.12,'2021-12-08 12:30:13','',''),(2205574,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-08 12:30:13','',''),(2205660,'1','149','770',328,'Retail Sale Id 1299523',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 12:36:14','',''),(2205661,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 12:36:14','',''),(2205750,'1','149','770',328,'Retail Sale Id 1299562',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 12:41:48','',''),(2205751,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:41:48','',''),(2205762,'1','149','770',328,'Retail Sale Id 1299570',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 12:42:51','',''),(2205763,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 12:42:51','',''),(2206168,'1','149','770',328,'Retail Sale Id 1299745',32000.00,0.00,0.00,0.00,2400.00,'2021-12-08 13:09:34','',''),(2206169,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 13:09:34','',''),(2206189,'1','149','770',328,'Retail Sale Id 1299753',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 13:10:32','',''),(2206190,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 13:10:32','',''),(2206217,'1','149','770',328,'Retail Sale Id 1299766',1203.20,0.00,0.00,0.00,90.24,'2021-12-08 13:12:44','',''),(2206218,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-08 13:12:44','',''),(2206313,'1','149','770',328,'Retail Sale Id 1299807',2502.40,0.00,0.00,0.00,187.68,'2021-12-08 13:18:08','',''),(2206314,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-08 13:18:08','',''),(2206347,'1','149','770',328,'Retail Sale Id 1299829',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 13:20:36','',''),(2206348,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 13:20:36','',''),(2206357,'1','149','770',328,'Retail Sale Id 1299835',652.80,0.00,0.00,0.00,48.96,'2021-12-08 13:21:33','',''),(2206358,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-08 13:21:33','',''),(2206552,'1','149','770',328,'Retail Sale Id 1299913',998.40,0.00,0.00,0.00,74.88,'2021-12-08 13:32:48','',''),(2206553,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 13:32:48','',''),(2206568,'1','149','770',328,'Retail Sale Id 1299921',652.80,0.00,0.00,0.00,48.96,'2021-12-08 13:34:11','',''),(2206569,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-08 13:34:11','',''),(2206596,'1','149','770',328,'Retail Sale Id 1299933',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 13:35:54','',''),(2206597,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 13:35:54','',''),(2206680,'1','149','770',328,'Retail Sale Id 1299972',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 13:41:23','',''),(2206681,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 13:41:23','',''),(2206779,'1','149','770',328,'Retail Sale Id 1300007',2598.40,0.00,0.00,0.00,194.88,'2021-12-08 13:45:22','',''),(2206780,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-08 13:45:22','',''),(2206850,'1','149','770',328,'Retail Sale Id 1300025',32000.00,0.00,0.00,0.00,2400.00,'2021-12-08 13:48:55','',''),(2206851,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 13:48:55','',''),(2206862,'1','149','770',328,'Retail Sale Id 1300036',3852.80,0.00,0.00,0.00,288.96,'2021-12-08 13:50:14','',''),(2206863,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 13:50:14','',''),(2206987,'1','149','770',328,'Retail Sale Id 1300088',800.00,0.00,0.00,0.00,60.00,'2021-12-08 13:57:22','',''),(2206988,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-08 13:57:22','',''),(2207022,'1','149','770',328,'Retail Sale Id 1300108',1299.20,0.00,0.00,0.00,97.44,'2021-12-08 14:00:11','',''),(2207023,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-08 14:00:11','',''),(2207088,'1','149','770',328,'Retail Sale Id 1300133',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 14:04:19','',''),(2207089,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 14:04:19','',''),(2207108,'1','149','770',328,'Retail Sale Id 1300140',800.00,0.00,0.00,0.00,60.00,'2021-12-08 14:05:53','',''),(2207109,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-08 14:05:53','',''),(2207277,'1','149','770',328,'Retail Sale Id 1300220',697.60,0.00,0.00,0.00,52.32,'2021-12-08 14:16:43','',''),(2207278,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-08 14:16:43','',''),(2207303,'1','149','770',328,'Retail Sale Id 1300231',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 14:18:19','',''),(2207304,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 14:18:19','',''),(2207367,'1','149','770',328,'Retail Sale Id 1300276',7001.60,0.00,0.00,0.00,525.12,'2021-12-08 14:21:58','',''),(2207368,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-08 14:21:58','',''),(2207379,'1','149','770',328,'Retail Sale Id 1300283',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 14:22:51','',''),(2207380,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 14:22:51','',''),(2207399,'1','149','770',328,'Retail Sale Id 1300293',998.40,0.00,0.00,0.00,74.88,'2021-12-08 14:24:07','',''),(2207400,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 14:24:07','',''),(2207447,'1','149','770',328,'Retail Sale Id 1300311',652.80,0.00,0.00,0.00,48.96,'2021-12-08 14:25:59','',''),(2207448,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-08 14:25:59','',''),(2207567,'1','149','770',328,'Retail Sale Id 1300353',1299.20,0.00,0.00,0.00,97.44,'2021-12-08 14:30:35','',''),(2207568,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-08 14:30:35','',''),(2207606,'1','149','770',328,'Retail Sale Id 1300367',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 14:32:08','',''),(2207607,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:32:09','',''),(2207684,'1','149','770',328,'Retail Sale Id 1300405',652.80,0.00,0.00,0.00,48.96,'2021-12-08 14:36:00','',''),(2207685,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-08 14:36:00','',''),(2207734,'1','149','770',328,'Retail Sale Id 1300432',3852.80,0.00,0.00,0.00,288.96,'2021-12-08 14:38:58','',''),(2207735,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 14:38:58','',''),(2207772,'1','149','770',328,'Retail Sale Id 1300451',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 14:41:25','',''),(2207773,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 14:41:25','',''),(2207800,'1','149','770',328,'Retail Sale Id 1300468',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 14:42:51','',''),(2207801,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 14:42:51','',''),(2207834,'1','149','770',328,'Retail Sale Id 1300487',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 14:44:42','',''),(2207835,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 14:44:43','',''),(2207943,'1','149','770',328,'Retail Sale Id 1300548',697.60,0.00,0.00,0.00,52.32,'2021-12-08 14:51:21','',''),(2207944,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-08 14:51:21','',''),(2207969,'1','149','770',328,'Retail Sale Id 1300560',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 14:52:19','',''),(2207970,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 14:52:19','',''),(2207995,'1','149','770',328,'Retail Sale Id 1300572',3852.80,0.00,0.00,0.00,288.96,'2021-12-08 14:54:05','',''),(2207996,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 14:54:05','',''),(2208027,'1','149','770',328,'Retail Sale Id 1300587',800.00,0.00,0.00,0.00,60.00,'2021-12-08 14:56:46','',''),(2208028,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-08 14:56:46','',''),(2208041,'1','149','770',328,'Retail Sale Id 1300593',1299.20,0.00,0.00,0.00,97.44,'2021-12-08 14:57:48','',''),(2208042,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-08 14:57:48','',''),(2208051,'1','149','770',328,'Retail Sale Id 1300599',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 14:58:54','',''),(2208052,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 14:58:54','',''),(2208067,'1','149','770',328,'Retail Sale Id 1300606',1248.00,0.00,0.00,0.00,93.60,'2021-12-08 15:00:14','',''),(2208068,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.95,0.00,'2021-12-08 15:00:14','',''),(2208106,'1','149','770',328,'Retail Sale Id 1300624',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 15:03:13','',''),(2208107,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 15:03:13','',''),(2208114,'1','149','770',328,'Retail Sale Id 1300630',1203.20,0.00,0.00,0.00,90.24,'2021-12-08 15:04:22','',''),(2208115,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-08 15:04:22','',''),(2208140,'1','149','770',328,'Retail Sale Id 1300637',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 15:05:15','',''),(2208141,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 15:05:15','',''),(2208179,'1','149','770',328,'Retail Sale Id 1300648',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 15:07:35','',''),(2208180,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 15:07:35','',''),(2208271,'1','149','770',328,'Retail Sale Id 1300689',652.80,0.00,0.00,0.00,48.96,'2021-12-08 15:12:34','',''),(2208272,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-08 15:12:34','',''),(2208407,'1','149','770',328,'Retail Sale Id 1300757',998.40,0.00,0.00,0.00,74.88,'2021-12-08 15:20:05','',''),(2208408,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 15:20:05','',''),(2208464,'1','149','770',328,'Retail Sale Id 1300784',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 15:22:31','',''),(2208465,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 15:22:31','',''),(2208484,'1','149','770',328,'Retail Sale Id 1300793',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 15:23:56','',''),(2208485,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 15:23:56','',''),(2208504,'1','149','770',328,'Retail Sale Id 1300804',6003.20,0.00,0.00,0.00,450.24,'2021-12-08 15:25:04','',''),(2208505,'1','149','770',328,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-08 15:25:04','',''),(2208524,'1','149','770',328,'Retail Sale Id 1300814',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 15:25:54','',''),(2208525,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 15:25:54','',''),(2208568,'1','149','770',328,'Retail Sale Id 1300834',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 15:28:25','',''),(2208569,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 15:28:25','',''),(2208594,'1','149','770',328,'Retail Sale Id 1300846',2598.40,0.00,0.00,0.00,194.88,'2021-12-08 15:29:40','',''),(2208595,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-08 15:29:40','',''),(2208695,'1','149','770',328,'Retail Sale Id 1300904',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 15:34:49','',''),(2208696,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 15:34:49','',''),(2208739,'1','149','770',328,'Retail Sale Id 1300926',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 15:36:38','',''),(2208740,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 15:36:38','',''),(2208768,'1','149','770',328,'Retail Sale Id 1300939',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 15:38:03','',''),(2208769,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 15:38:03','',''),(2208795,'1','149','770',328,'Retail Sale Id 1300955',998.40,0.00,0.00,0.00,74.88,'2021-12-08 15:39:11','',''),(2208796,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 15:39:11','',''),(2208813,'1','149','770',328,'Retail Sale Id 1300964',1952.00,0.00,0.00,0.00,146.40,'2021-12-08 15:40:36','',''),(2208814,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 15:40:36','',''),(2208851,'1','149','770',328,'Retail Sale Id 1300983',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 15:42:21','',''),(2208852,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 15:42:21','',''),(2208875,'1','149','770',328,'Retail Sale Id 1300996',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 15:43:19','',''),(2208876,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 15:43:19','',''),(2208901,'1','149','770',328,'Retail Sale Id 1301010',1299.20,0.00,0.00,0.00,97.44,'2021-12-08 15:44:36','',''),(2208902,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-08 15:44:36','',''),(2208917,'1','149','770',328,'Retail Sale Id 1301019',697.60,0.00,0.00,0.00,52.32,'2021-12-08 15:45:56','',''),(2208918,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-08 15:45:56','',''),(2208993,'1','149','770',328,'Retail Sale Id 1301057',1299.20,0.00,0.00,0.00,97.44,'2021-12-08 15:50:12','',''),(2208994,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-08 15:50:12','',''),(2209165,'1','149','770',328,'Retail Sale Id 1301136',3852.80,0.00,0.00,0.00,288.96,'2021-12-08 15:59:53','',''),(2209166,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 15:59:53','',''),(2209193,'1','149','770',328,'Retail Sale Id 1301151',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 16:00:54','',''),(2209194,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 16:00:54','',''),(2209251,'1','149','770',328,'Retail Sale Id 1301183',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 16:03:28','',''),(2209252,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 16:03:28','',''),(2209365,'1','149','770',328,'Retail Sale Id 1301233',652.80,0.00,0.00,0.00,48.96,'2021-12-08 16:08:55','',''),(2209366,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-08 16:08:55','',''),(2209543,'1','149','770',328,'Retail Sale Id 1301316',998.40,0.00,0.00,0.00,74.88,'2021-12-08 16:16:00','',''),(2209544,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 16:16:00','',''),(2209592,'1','149','770',328,'Retail Sale Id 1301332',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 16:17:06','',''),(2209593,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 16:17:06','',''),(2209662,'1','149','770',328,'Retail Sale Id 1301365',697.60,0.00,0.00,0.00,52.32,'2021-12-08 16:20:20','',''),(2209663,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-08 16:20:20','',''),(2209678,'1','149','770',328,'Retail Sale Id 1301373',652.80,0.00,0.00,0.00,48.96,'2021-12-08 16:21:16','',''),(2209679,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-08 16:21:16','',''),(2209721,'1','149','770',328,'Retail Sale Id 1301393',4998.40,0.00,0.00,0.00,374.88,'2021-12-08 16:23:24','',''),(2209722,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-08 16:23:24','',''),(2209875,'1','149','770',328,'Retail Sale Id 1301593',2400.00,0.00,0.00,0.00,180.00,'2021-12-08 16:32:36','',''),(2209876,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.75,0.00,'2021-12-08 16:32:36','',''),(2209939,'1','149','770',328,'Retail Sale Id 1301621',998.40,0.00,0.00,0.00,74.88,'2021-12-08 16:35:26','',''),(2209940,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 16:35:26','',''),(2210035,'1','149','770',328,'Retail Sale Id 1301667',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 16:39:33','',''),(2210036,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 16:39:33','',''),(2210151,'1','149','770',328,'Retail Sale Id 1301731',3852.80,0.00,0.00,0.00,288.96,'2021-12-08 16:45:06','',''),(2210152,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 16:45:06','',''),(2210205,'1','149','770',328,'Retail Sale Id 1301754',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 16:47:47','',''),(2210206,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 16:47:47','',''),(2210215,'1','149','770',328,'Retail Sale Id 1301760',652.80,0.00,0.00,0.00,48.96,'2021-12-08 16:48:41','',''),(2210216,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-08 16:48:41','',''),(2210247,'1','149','770',328,'Retail Sale Id 1301778',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 16:49:54','',''),(2210248,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:49:54','',''),(2210267,'1','149','770',328,'Retail Sale Id 1301786',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 16:51:18','',''),(2210268,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:51:18','',''),(2210300,'1','149','770',328,'Retail Sale Id 1301804',902.40,0.00,0.00,0.00,67.68,'2021-12-08 16:53:02','',''),(2210301,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-08 16:53:02','',''),(2210318,'1','149','770',328,'Retail Sale Id 1301815',998.40,0.00,0.00,0.00,74.88,'2021-12-08 16:54:02','',''),(2210319,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 16:54:02','',''),(2210364,'1','149','770',328,'Retail Sale Id 1301836',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 16:57:03','',''),(2210365,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 16:57:03','',''),(2210408,'1','149','770',328,'Retail Sale Id 1301862',652.80,0.00,0.00,0.00,48.96,'2021-12-08 17:00:19','',''),(2210409,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-08 17:00:19','',''),(2210426,'1','149','770',328,'Retail Sale Id 1301871',902.40,0.00,0.00,0.00,67.68,'2021-12-08 17:01:34','',''),(2210427,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-08 17:01:34','',''),(2210464,'1','149','770',328,'Retail Sale Id 1301892',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 17:04:54','',''),(2210465,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 17:04:54','',''),(2210501,'1','149','770',328,'Retail Sale Id 1301915',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 17:08:35','',''),(2210502,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 17:08:35','',''),(2210664,'1','149','770',328,'Retail Sale Id 1302010',800.00,0.00,0.00,0.00,60.00,'2021-12-08 17:23:44','',''),(2210665,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-08 17:23:44','',''),(2210960,'1','149','770',328,'Retail Sale Id 1302136',261996.80,0.00,0.00,0.00,19649.76,'2021-12-08 17:57:30','',''),(2210961,'1','149','770',328,'Retail sales',0.00,0.00,0.00,409.37,0.00,'2021-12-08 17:57:30','',''),(2212774,'1','149','770',328,'Retail Sale Id 1302711',800.00,0.00,0.00,0.00,60.00,'2021-12-09 06:56:52','',''),(2212775,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-09 06:56:52','',''),(2212812,'1','149','770',328,'Retail Sale Id 1302729',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 06:58:40','',''),(2212813,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 06:58:40','',''),(2212842,'1','149','770',328,'Retail Sale Id 1302743',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 07:00:23','',''),(2212843,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 07:00:23','',''),(2212924,'1','149','770',328,'Retail Sale Id 1302786',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 07:05:27','',''),(2212925,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:05:27','',''),(2213007,'1','149','770',328,'Retail Sale Id 1302815',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 07:09:26','',''),(2213008,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:09:26','',''),(2213016,'1','149','770',328,'Retail Sale Id 1302821',1299.20,0.00,0.00,0.00,97.44,'2021-12-09 07:10:02','',''),(2213017,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-09 07:10:02','',''),(2213046,'1','149','770',328,'Retail Sale Id 1302835',998.40,0.00,0.00,0.00,74.88,'2021-12-09 07:12:06','',''),(2213047,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 07:12:06','',''),(2213073,'1','149','770',328,'Retail Sale Id 1302851',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 07:13:21','',''),(2213074,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 07:13:21','',''),(2213106,'1','149','770',328,'Retail Sale Id 1302866',652.80,0.00,0.00,0.00,48.96,'2021-12-09 07:15:00','',''),(2213107,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-09 07:15:00','',''),(2213155,'1','149','770',328,'Retail Sale Id 1302890',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 07:16:28','',''),(2213156,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:16:28','',''),(2213252,'1','149','770',328,'Retail Sale Id 1302929',998.40,0.00,0.00,0.00,74.88,'2021-12-09 07:20:03','',''),(2213253,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 07:20:03','',''),(2213358,'1','149','770',328,'Retail Sale Id 1302984',2502.40,0.00,0.00,0.00,187.68,'2021-12-09 07:24:58','',''),(2213359,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-09 07:24:58','',''),(2213390,'1','149','770',328,'Retail Sale Id 1303004',2598.40,0.00,0.00,0.00,194.88,'2021-12-09 07:26:14','',''),(2213391,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-09 07:26:14','',''),(2213426,'1','149','770',328,'Retail Sale Id 1303021',998.40,0.00,0.00,0.00,74.88,'2021-12-09 07:28:28','',''),(2213427,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 07:28:28','',''),(2213522,'1','149','770',328,'Retail Sale Id 1303062',1299.20,0.00,0.00,0.00,97.44,'2021-12-09 07:32:26','',''),(2213523,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-09 07:32:26','',''),(2213546,'1','149','770',328,'Retail Sale Id 1303077',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 07:33:25','',''),(2213547,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 07:33:25','',''),(2213590,'1','149','770',328,'Retail Sale Id 1303100',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 07:35:46','',''),(2213591,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 07:35:46','',''),(2213695,'1','149','770',328,'Retail Sale Id 1303153',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 07:41:27','',''),(2213696,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:41:27','',''),(2213818,'1','149','770',328,'Retail Sale Id 1303209',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 07:47:21','',''),(2213819,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 07:47:21','',''),(2213868,'1','149','770',328,'Retail Sale Id 1303235',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 07:50:02','',''),(2213869,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 07:50:02','',''),(2214000,'1','149','770',328,'Retail Sale Id 1303296',1299.20,0.00,0.00,0.00,97.44,'2021-12-09 07:57:01','',''),(2214001,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-09 07:57:01','',''),(2214024,'1','149','770',328,'Retail Sale Id 1303309',2502.40,0.00,0.00,0.00,187.68,'2021-12-09 07:58:42','',''),(2214025,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-09 07:58:42','',''),(2214114,'1','149','770',328,'Retail Sale Id 1303359',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 08:04:16','',''),(2214115,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 08:04:16','',''),(2214260,'1','149','770',328,'Retail Sale Id 1303434',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 08:11:27','',''),(2214261,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 08:11:27','',''),(2214500,'1','149','770',328,'Retail Sale Id 1303537',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 08:23:21','',''),(2214501,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 08:23:21','',''),(2214533,'1','149','770',328,'Retail Sale Id 1303550',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 08:24:40','',''),(2214534,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 08:24:40','',''),(2214626,'1','149','770',328,'Retail Sale Id 1303589',1299.20,0.00,0.00,0.00,97.44,'2021-12-09 08:28:29','',''),(2214627,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-09 08:28:29','',''),(2214738,'1','149','770',328,'Retail Sale Id 1303637',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 08:33:29','',''),(2214739,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:33:29','',''),(2214786,'1','149','770',328,'Retail Sale Id 1303666',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 08:36:36','',''),(2214787,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:36:36','',''),(2214811,'1','149','770',328,'Retail Sale Id 1303677',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 08:37:38','',''),(2214812,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 08:37:38','',''),(2214917,'1','149','770',328,'Retail Sale Id 1303728',902.40,0.00,0.00,0.00,67.68,'2021-12-09 08:41:46','',''),(2214918,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-09 08:41:46','',''),(2214947,'1','149','770',328,'Retail Sale Id 1303742',18560.00,0.00,0.00,0.00,1392.00,'2021-12-09 08:43:37','',''),(2214948,'1','149','770',328,'Retail sales',0.00,0.00,0.00,29.00,0.00,'2021-12-09 08:43:37','',''),(2215003,'1','149','770',328,'Retail Sale Id 1303764',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 08:46:12','',''),(2215004,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 08:46:12','',''),(2215106,'1','149','770',328,'Retail Sale Id 1303812',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 08:52:09','',''),(2215107,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 08:52:09','',''),(2215198,'1','149','770',328,'Retail Sale Id 1303863',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 08:58:27','',''),(2215199,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:58:27','',''),(2215317,'1','149','770',328,'Retail Sale Id 1303923',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 09:04:43','',''),(2215318,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 09:04:43','',''),(2215332,'1','149','770',328,'Retail Sale Id 1303929',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 09:05:44','',''),(2215333,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 09:05:44','',''),(2215356,'1','149','770',328,'Retail Sale Id 1303943',3500.80,0.00,0.00,0.00,262.56,'2021-12-09 09:07:30','',''),(2215357,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-09 09:07:30','',''),(2215404,'1','149','770',328,'Retail Sale Id 1303969',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 09:10:40','',''),(2215405,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 09:10:40','',''),(2215490,'1','149','770',328,'Retail Sale Id 1304012',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 09:16:12','',''),(2215491,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 09:16:12','',''),(2215507,'1','149','770',328,'Retail Sale Id 1304020',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 09:17:16','',''),(2215508,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 09:17:16','',''),(2215543,'1','149','770',328,'Retail Sale Id 1304038',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 09:19:38','',''),(2215544,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:19:38','',''),(2215565,'1','149','770',328,'Retail Sale Id 1304051',652.80,0.00,0.00,0.00,48.96,'2021-12-09 09:20:39','',''),(2215566,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-09 09:20:39','',''),(2215593,'1','149','770',328,'Retail Sale Id 1304063',998.40,0.00,0.00,0.00,74.88,'2021-12-09 09:22:13','',''),(2215594,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 09:22:13','',''),(2215796,'1','149','770',328,'Retail Sale Id 1304164',998.40,0.00,0.00,0.00,74.88,'2021-12-09 09:32:56','',''),(2215797,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 09:32:56','',''),(2216127,'1','149','770',328,'Retail Sale Id 1304280',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 09:47:12','',''),(2216128,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 09:47:12','',''),(2216145,'1','149','770',328,'Retail Sale Id 1304289',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 09:48:04','',''),(2216146,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 09:48:04','',''),(2216189,'1','149','770',328,'Retail Sale Id 1304315',1299.20,0.00,0.00,0.00,97.44,'2021-12-09 09:51:00','',''),(2216190,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-09 09:51:00','',''),(2216217,'1','149','770',328,'Retail Sale Id 1304329',2297.60,0.00,0.00,0.00,172.32,'2021-12-09 09:52:19','',''),(2216218,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.59,0.00,'2021-12-09 09:52:19','',''),(2216241,'1','149','770',328,'Retail Sale Id 1304340',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 09:53:32','',''),(2216242,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 09:53:32','',''),(2216424,'1','149','770',328,'Retail Sale Id 1304420',697.60,0.00,0.00,0.00,52.32,'2021-12-09 10:01:04','',''),(2216425,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-09 10:01:04','',''),(2216488,'1','149','770',328,'Retail Sale Id 1304451',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 10:05:16','',''),(2216489,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 10:05:16','',''),(2216569,'1','149','770',328,'Retail Sale Id 1304494',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 10:09:32','',''),(2216570,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:09:32','',''),(2216731,'1','149','770',328,'Retail Sale Id 1304585',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 10:22:08','',''),(2216732,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:22:08','',''),(2216769,'1','149','770',328,'Retail Sale Id 1304603',1203.20,0.00,0.00,0.00,90.24,'2021-12-09 10:23:35','',''),(2216770,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-09 10:23:35','',''),(2216781,'1','149','770',328,'Retail Sale Id 1304609',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 10:24:43','',''),(2216782,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 10:24:43','',''),(2216887,'1','149','770',328,'Retail Sale Id 1304665',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 10:31:05','',''),(2216888,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 10:31:05','',''),(2217008,'1','149','770',328,'Retail Sale Id 1304728',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 10:40:17','',''),(2217009,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 10:40:17','',''),(2217030,'1','149','770',328,'Retail Sale Id 1304736',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 10:41:22','',''),(2217031,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 10:41:22','',''),(2217384,'1','149','770',328,'Retail Sale Id 1304919',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 11:04:37','',''),(2217385,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 11:04:37','',''),(2217402,'1','149','770',328,'Retail Sale Id 1304929',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 11:05:48','',''),(2217403,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:05:48','',''),(2217481,'1','149','770',328,'Retail Sale Id 1304967',1203.20,0.00,0.00,0.00,90.24,'2021-12-09 11:12:08','',''),(2217482,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-09 11:12:08','',''),(2217498,'1','149','770',328,'Retail Sale Id 1304974',2502.40,0.00,0.00,0.00,187.68,'2021-12-09 11:13:11','',''),(2217499,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-09 11:13:11','',''),(2217522,'1','149','770',328,'Retail Sale Id 1304986',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 11:15:28','',''),(2217523,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 11:15:28','',''),(2217560,'1','149','770',328,'Retail Sale Id 1305009',3500.80,0.00,0.00,0.00,262.56,'2021-12-09 11:17:55','',''),(2217561,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-09 11:17:55','',''),(2217572,'1','149','770',328,'Retail Sale Id 1305015',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 11:19:00','',''),(2217573,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 11:19:00','',''),(2217675,'1','149','770',328,'Retail Sale Id 1305060',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 11:23:12','',''),(2217676,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:23:12','',''),(2217698,'1','149','770',328,'Retail Sale Id 1305071',998.40,0.00,0.00,0.00,74.88,'2021-12-09 11:24:26','',''),(2217699,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 11:24:26','',''),(2217886,'1','149','770',328,'Retail Sale Id 1305161',2502.40,0.00,0.00,0.00,187.68,'2021-12-09 11:35:58','',''),(2217887,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-09 11:35:58','',''),(2218162,'1','149','770',328,'Retail Sale Id 1305294',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 11:53:02','',''),(2218163,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 11:53:02','',''),(2218316,'1','149','770',328,'Retail Sale Id 1305379',1299.20,0.00,0.00,0.00,97.44,'2021-12-09 12:03:52','',''),(2218317,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-09 12:03:52','',''),(2218359,'1','149','770',328,'Retail Sale Id 1305399',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 12:07:18','',''),(2218360,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 12:07:18','',''),(2218377,'1','149','770',328,'Retail Sale Id 1305408',32000.00,0.00,0.00,0.00,2400.00,'2021-12-09 12:08:19','',''),(2218378,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 12:08:19','',''),(2218387,'1','149','770',328,'Retail Sale Id 1305413',998.40,0.00,0.00,0.00,74.88,'2021-12-09 12:09:05','',''),(2218388,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 12:09:05','',''),(2218489,'1','149','770',328,'Retail Sale Id 1305459',998.40,0.00,0.00,0.00,74.88,'2021-12-09 12:14:02','',''),(2218490,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 12:14:02','',''),(2218744,'1','149','770',328,'Retail Sale Id 1305608',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 12:31:55','',''),(2218745,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 12:31:55','',''),(2218760,'1','149','770',328,'Retail Sale Id 1305615',652.80,0.00,0.00,0.00,48.96,'2021-12-09 12:32:46','',''),(2218761,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-09 12:32:46','',''),(2218782,'1','149','770',328,'Retail Sale Id 1305624',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 12:33:53','',''),(2218783,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 12:33:53','',''),(2218834,'1','149','770',328,'Retail Sale Id 1305652',2803.20,0.00,0.00,0.00,210.24,'2021-12-09 12:36:50','',''),(2218835,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-09 12:36:50','',''),(2218908,'1','149','770',328,'Retail Sale Id 1305685',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 12:41:12','',''),(2218909,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 12:41:12','',''),(2218960,'1','149','770',328,'Retail Sale Id 1305714',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 12:44:15','',''),(2218961,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 12:44:15','',''),(2218978,'1','149','770',328,'Retail Sale Id 1305720',998.40,0.00,0.00,0.00,74.88,'2021-12-09 12:45:01','',''),(2218979,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 12:45:01','',''),(2219013,'1','149','770',328,'Retail Sale Id 1305740',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 12:46:50','',''),(2219014,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 12:46:50','',''),(2219081,'1','149','770',328,'Retail Sale Id 1305770',1401.60,0.00,0.00,0.00,105.12,'2021-12-09 12:49:41','',''),(2219082,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-09 12:49:41','',''),(2219099,'1','149','770',328,'Retail Sale Id 1305780',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 12:50:45','',''),(2219100,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 12:50:45','',''),(2219115,'1','149','770',328,'Retail Sale Id 1305788',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 12:52:03','',''),(2219116,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 12:52:03','',''),(2219133,'1','149','770',328,'Retail Sale Id 1305799',800.00,0.00,0.00,0.00,60.00,'2021-12-09 12:52:40','',''),(2219134,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-09 12:52:40','',''),(2219149,'1','149','770',328,'Retail Sale Id 1305810',998.40,0.00,0.00,0.00,74.88,'2021-12-09 12:54:14','',''),(2219150,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 12:54:14','',''),(2219269,'1','149','770',328,'Retail Sale Id 1305859',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 13:00:21','',''),(2219270,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 13:00:21','',''),(2219335,'1','149','770',328,'Retail Sale Id 1305898',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 13:05:36','',''),(2219336,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 13:05:36','',''),(2219363,'1','149','770',328,'Retail Sale Id 1305921',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 13:08:27','',''),(2219364,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 13:08:27','',''),(2219397,'1','149','770',328,'Retail Sale Id 1305939',800.00,0.00,0.00,0.00,60.00,'2021-12-09 13:09:57','',''),(2219398,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-09 13:09:57','',''),(2219436,'1','149','770',328,'Retail Sale Id 1305949',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 13:11:28','',''),(2219437,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 13:11:28','',''),(2219502,'1','149','770',328,'Retail Sale Id 1305975',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 13:16:20','',''),(2219503,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 13:16:20','',''),(2219708,'1','149','770',328,'Retail Sale Id 1306067',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 13:30:23','',''),(2219709,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 13:30:23','',''),(2219769,'1','149','770',328,'Retail Sale Id 1306083',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 13:32:18','',''),(2219770,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 13:32:18','',''),(2219793,'1','149','770',328,'Retail Sale Id 1306087',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 13:33:26','',''),(2219794,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 13:33:26','',''),(2219818,'1','149','770',328,'Retail Sale Id 1306094',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 13:34:33','',''),(2219819,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 13:34:33','',''),(2219854,'1','149','770',328,'Retail Sale Id 1306100',6400.00,0.00,0.00,0.00,480.00,'2021-12-09 13:35:35','',''),(2219855,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 13:35:35','',''),(2219885,'1','149','770',328,'Retail Sale Id 1306107',1401.60,0.00,0.00,0.00,105.12,'2021-12-09 13:36:43','',''),(2219886,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-09 13:36:43','',''),(2219906,'1','149','770',328,'Retail Sale Id 1306113',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 13:37:49','',''),(2219907,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 13:37:49','',''),(2220028,'1','149','770',328,'Retail Sale Id 1306171',902.40,0.00,0.00,0.00,67.68,'2021-12-09 13:44:58','',''),(2220029,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-09 13:44:58','',''),(2220205,'1','149','770',328,'Retail Sale Id 1306261',1203.20,0.00,0.00,0.00,90.24,'2021-12-09 13:56:37','',''),(2220206,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-09 13:56:37','',''),(2220226,'1','149','770',328,'Retail Sale Id 1306271',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 13:58:49','',''),(2220227,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 13:58:49','',''),(2220252,'1','149','770',328,'Retail Sale Id 1306281',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 14:00:54','',''),(2220253,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 14:00:54','',''),(2220628,'1','149','770',328,'Retail Sale Id 1306489',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 14:23:17','',''),(2220629,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 14:23:17','',''),(2220686,'1','149','770',328,'Retail Sale Id 1306522',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 14:26:25','',''),(2220687,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 14:26:25','',''),(2220718,'1','149','770',328,'Retail Sale Id 1306535',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 14:27:33','',''),(2220719,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 14:27:33','',''),(2220757,'1','149','770',328,'Retail Sale Id 1306553',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 14:29:42','',''),(2220758,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 14:29:42','',''),(2220783,'1','149','770',328,'Retail Sale Id 1306564',2598.40,0.00,0.00,0.00,194.88,'2021-12-09 14:31:03','',''),(2220784,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-09 14:31:03','',''),(2220804,'1','149','770',328,'Retail Sale Id 1306575',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 14:32:21','',''),(2220805,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:32:21','',''),(2220839,'1','149','770',328,'Retail Sale Id 1306594',652.80,0.00,0.00,0.00,48.96,'2021-12-09 14:33:35','',''),(2220840,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-09 14:33:35','',''),(2220905,'1','149','770',328,'Retail Sale Id 1306615',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 14:35:54','',''),(2220906,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 14:35:54','',''),(2220943,'1','149','770',328,'Retail Sale Id 1306627',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 14:36:52','',''),(2220944,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 14:36:52','',''),(2220984,'1','149','770',328,'Retail Sale Id 1306646',998.40,0.00,0.00,0.00,74.88,'2021-12-09 14:38:36','',''),(2220985,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 14:38:36','',''),(2221010,'1','149','770',328,'Retail Sale Id 1306669',4499.20,0.00,0.00,0.00,337.44,'2021-12-09 14:39:58','',''),(2221011,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-09 14:39:58','',''),(2221116,'1','149','770',328,'Retail Sale Id 1306716',7001.60,0.00,0.00,0.00,525.12,'2021-12-09 14:44:39','',''),(2221117,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-09 14:44:39','',''),(2221151,'1','149','770',328,'Retail Sale Id 1306729',998.40,0.00,0.00,0.00,74.88,'2021-12-09 14:45:52','',''),(2221152,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 14:45:52','',''),(2221226,'1','149','770',328,'Retail Sale Id 1306767',1299.20,0.00,0.00,0.00,97.44,'2021-12-09 14:49:35','',''),(2221227,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-09 14:49:35','',''),(2221430,'1','149','770',328,'Retail Sale Id 1306820',4998.40,0.00,0.00,0.00,374.88,'2021-12-09 14:56:29','',''),(2221431,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-09 14:56:29','',''),(2221450,'1','149','770',328,'Retail Sale Id 1306831',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 14:57:30','',''),(2221451,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 14:57:30','',''),(2221472,'1','149','770',328,'Retail Sale Id 1306843',1203.20,0.00,0.00,0.00,90.24,'2021-12-09 14:58:58','',''),(2221473,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-09 14:58:58','',''),(2221552,'1','149','770',328,'Retail Sale Id 1306886',697.60,0.00,0.00,0.00,52.32,'2021-12-09 15:03:57','',''),(2221553,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-09 15:03:57','',''),(2221604,'1','149','770',328,'Retail Sale Id 1306914',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 15:06:15','',''),(2221605,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 15:06:15','',''),(2221893,'1','149','770',328,'Retail Sale Id 1307063',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 15:20:23','',''),(2221894,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 15:20:23','',''),(2222007,'1','149','770',328,'Retail Sale Id 1307126',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 15:26:14','',''),(2222008,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 15:26:14','',''),(2222047,'1','149','770',328,'Retail Sale Id 1307147',1600.00,0.00,0.00,0.00,120.00,'2021-12-09 15:28:14','',''),(2222048,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-09 15:28:14','',''),(2222095,'1','149','770',328,'Retail Sale Id 1307170',2803.20,0.00,0.00,0.00,210.24,'2021-12-09 15:30:27','',''),(2222096,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-09 15:30:27','',''),(2222126,'1','149','770',328,'Retail Sale Id 1307181',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 15:31:34','',''),(2222127,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 15:31:34','',''),(2222154,'1','149','770',328,'Retail Sale Id 1307196',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 15:33:05','',''),(2222155,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 15:33:05','',''),(2222170,'1','149','770',328,'Retail Sale Id 1307204',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 15:34:05','',''),(2222171,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 15:34:05','',''),(2222220,'1','149','770',328,'Retail Sale Id 1307231',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 15:36:50','',''),(2222221,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 15:36:50','',''),(2222264,'1','149','770',328,'Retail Sale Id 1307250',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 15:39:06','',''),(2222265,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 15:39:06','',''),(2222288,'1','149','770',328,'Retail Sale Id 1307261',652.80,0.00,0.00,0.00,48.96,'2021-12-09 15:39:57','',''),(2222289,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-09 15:39:57','',''),(2222304,'1','149','770',328,'Retail Sale Id 1307268',1203.20,0.00,0.00,0.00,90.24,'2021-12-09 15:40:49','',''),(2222305,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-09 15:40:49','',''),(2222324,'1','149','770',328,'Retail Sale Id 1307280',902.40,0.00,0.00,0.00,67.68,'2021-12-09 15:42:03','',''),(2222325,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-09 15:42:03','',''),(2222393,'1','149','770',328,'Retail Sale Id 1307314',652.80,0.00,0.00,0.00,48.96,'2021-12-09 15:46:15','',''),(2222394,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-09 15:46:15','',''),(2222425,'1','149','770',328,'Retail Sale Id 1307329',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 15:48:18','',''),(2222426,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 15:48:18','',''),(2222445,'1','149','770',328,'Retail Sale Id 1307338',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 15:49:40','',''),(2222446,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 15:49:40','',''),(2222533,'1','149','770',328,'Retail Sale Id 1307383',1299.20,0.00,0.00,0.00,97.44,'2021-12-09 15:54:17','',''),(2222534,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-09 15:54:17','',''),(2222567,'1','149','770',328,'Retail Sale Id 1307400',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 15:55:39','',''),(2222568,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 15:55:39','',''),(2222594,'1','149','770',328,'Retail Sale Id 1307413',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 15:57:05','',''),(2222595,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 15:57:05','',''),(2222606,'1','149','770',328,'Retail Sale Id 1307417',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 15:57:54','',''),(2222607,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 15:57:54','',''),(2222680,'1','149','770',328,'Retail Sale Id 1307454',998.40,0.00,0.00,0.00,74.88,'2021-12-09 16:02:03','',''),(2222681,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 16:02:03','',''),(2222694,'1','149','770',328,'Retail Sale Id 1307461',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 16:02:55','',''),(2222695,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 16:02:55','',''),(2222791,'1','149','770',328,'Retail Sale Id 1307509',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 16:07:32','',''),(2222792,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 16:07:32','',''),(2222807,'1','149','770',328,'Retail Sale Id 1307518',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 16:08:43','',''),(2222808,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:08:43','',''),(2222853,'1','149','770',328,'Retail Sale Id 1307537',998.40,0.00,0.00,0.00,74.88,'2021-12-09 16:10:29','',''),(2222854,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 16:10:29','',''),(2222931,'1','149','770',328,'Retail Sale Id 1307576',4998.40,0.00,0.00,0.00,374.88,'2021-12-09 16:14:56','',''),(2222932,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-09 16:14:56','',''),(2222953,'1','149','770',328,'Retail Sale Id 1307592',1299.20,0.00,0.00,0.00,97.44,'2021-12-09 16:16:05','',''),(2222954,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-09 16:16:05','',''),(2222991,'1','149','770',328,'Retail Sale Id 1307614',2598.40,0.00,0.00,0.00,194.88,'2021-12-09 16:18:14','',''),(2222992,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-09 16:18:14','',''),(2223025,'1','149','770',328,'Retail Sale Id 1307631',998.40,0.00,0.00,0.00,74.88,'2021-12-09 16:20:16','',''),(2223026,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 16:20:16','',''),(2223057,'1','149','770',328,'Retail Sale Id 1307641',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 16:21:28','',''),(2223058,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 16:21:28','',''),(2223073,'1','149','770',328,'Retail Sale Id 1307649',998.40,0.00,0.00,0.00,74.88,'2021-12-09 16:22:50','',''),(2223074,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 16:22:50','',''),(2223798,'1','149','770',328,'Retail Sale Id 1307965',998.40,0.00,0.00,0.00,74.88,'2021-12-09 17:02:43','',''),(2223799,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 17:02:43','',''),(2223861,'1','149','770',328,'Retail Sale Id 1307994',1798.40,0.00,0.00,0.00,134.88,'2021-12-09 17:05:40','',''),(2223862,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-09 17:05:40','',''),(2223867,'1','149','770',328,'Retail Sale Id 1307997',2598.40,0.00,0.00,0.00,194.88,'2021-12-09 17:06:30','',''),(2223868,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-09 17:06:30','',''),(2223881,'1','149','770',328,'Retail Sale Id 1308004',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 17:07:47','',''),(2223882,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 17:07:47','',''),(2223902,'1','149','770',328,'Retail Sale Id 1308015',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 17:09:19','',''),(2223903,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 17:09:19','',''),(2223910,'1','149','770',328,'Retail Sale Id 1308019',902.40,0.00,0.00,0.00,67.68,'2021-12-09 17:10:10','',''),(2223911,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-09 17:10:10','',''),(2223940,'1','149','770',328,'Retail Sale Id 1308034',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 17:12:38','',''),(2223941,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 17:12:38','',''),(2223981,'1','149','770',328,'Retail Sale Id 1308059',6400.00,0.00,0.00,0.00,480.00,'2021-12-09 17:16:18','',''),(2223982,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 17:16:18','',''),(2224000,'1','149','770',328,'Retail Sale Id 1308067',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 17:18:12','',''),(2224001,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 17:18:12','',''),(2224020,'1','149','770',328,'Retail Sale Id 1308079',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 17:20:41','',''),(2224021,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 17:20:41','',''),(2224071,'1','149','770',328,'Retail Sale Id 1308104',3500.80,0.00,0.00,0.00,262.56,'2021-12-09 17:26:18','',''),(2224072,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-09 17:26:18','',''),(2224132,'1','149','770',328,'Retail Sale Id 1308133',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 17:35:12','',''),(2224133,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 17:35:12','',''),(2224160,'1','149','770',328,'Retail Sale Id 1308146',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 17:39:19','',''),(2224161,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 17:39:19','',''),(2224162,'1','149','770',328,'Retail Sale Id 1308146',6400.00,0.00,0.00,0.00,480.00,'2021-12-09 17:39:19','',''),(2224163,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 17:39:19','',''),(2224168,'1','149','770',328,'Retail Sale Id 1308151',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 17:41:11','',''),(2224169,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 17:41:11','',''),(2224178,'1','149','770',328,'Retail Sale Id 1308156',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 17:42:02','',''),(2224179,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 17:42:02','',''),(2224184,'1','149','770',328,'Retail Sale Id 1308159',998.40,0.00,0.00,0.00,74.88,'2021-12-09 17:45:02','',''),(2224185,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 17:45:02','',''),(2224203,'1','149','770',328,'Retail Sale Id 1308174',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 17:50:25','',''),(2224204,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 17:50:25','',''),(2224205,'1','149','770',328,'Retail Sale Id 1308174',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 17:50:25','',''),(2224206,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 17:50:25','',''),(2224314,'1','149','770',328,'Retail Sale Id 1308219',189472.00,0.00,0.00,0.00,14210.40,'2021-12-09 18:06:41','',''),(2224315,'1','149','770',328,'Retail sales',0.00,0.00,0.00,296.05,0.00,'2021-12-09 18:06:41','',''),(2225095,'1','149','770',328,'Retail Sale Id 1308361',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 06:03:50','',''),(2225096,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 06:03:50','',''),(2225144,'1','149','770',328,'Retail Sale Id 1308382',3002.00,0.00,0.00,0.00,190.00,'2021-12-10 06:09:48','',''),(2225145,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 06:09:48','',''),(2225160,'1','149','770',328,'Retail Sale Id 1308388',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 06:12:04','',''),(2225161,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 06:12:04','',''),(2225229,'1','149','770',328,'Retail Sale Id 1308417',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 06:20:10','',''),(2225230,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 06:20:10','',''),(2225274,'1','149','770',328,'Retail Sale Id 1308441',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 06:24:11','',''),(2225275,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 06:24:11','',''),(2225305,'1','149','770',328,'Retail Sale Id 1308452',998.56,0.00,0.00,0.00,63.20,'2021-12-10 06:26:30','',''),(2225306,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 06:26:30','',''),(2225333,'1','149','770',328,'Retail Sale Id 1308467',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 06:28:30','',''),(2225334,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 06:28:30','',''),(2225349,'1','149','770',328,'Retail Sale Id 1308475',31600.00,0.00,0.00,0.00,2000.00,'2021-12-10 06:29:31','',''),(2225350,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 06:29:31','',''),(2225733,'1','149','770',328,'Retail Sale Id 1308659',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 06:57:14','',''),(2225734,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 06:57:14','',''),(2225751,'1','149','770',328,'Retail Sale Id 1308668',998.56,0.00,0.00,0.00,63.20,'2021-12-10 06:58:36','',''),(2225752,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 06:58:36','',''),(2225757,'1','149','770',328,'Retail Sale Id 1308672',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 06:59:35','',''),(2225758,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 06:59:35','',''),(2225804,'1','149','770',328,'Retail Sale Id 1308696',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 07:02:58','',''),(2225805,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 07:02:58','',''),(2225818,'1','149','770',328,'Retail Sale Id 1308703',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 07:04:03','',''),(2225819,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 07:04:03','',''),(2225830,'1','149','770',328,'Retail Sale Id 1308709',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 07:04:48','',''),(2225831,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:04:48','',''),(2225888,'1','149','770',328,'Retail Sale Id 1308739',4000.56,0.00,0.00,0.00,253.20,'2021-12-10 07:08:48','',''),(2225889,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-10 07:08:48','',''),(2226028,'1','149','770',328,'Retail Sale Id 1308814',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 07:16:57','',''),(2226029,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 07:16:57','',''),(2226100,'1','149','770',328,'Retail Sale Id 1308851',650.96,0.00,0.00,0.00,41.20,'2021-12-10 07:20:09','',''),(2226101,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-10 07:20:09','',''),(2226184,'1','149','770',328,'Retail Sale Id 1308895',3160.00,0.00,0.00,0.00,200.00,'2021-12-10 07:25:09','',''),(2226185,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 07:25:09','',''),(2226212,'1','149','770',328,'Retail Sale Id 1308909',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 07:26:23','',''),(2226213,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:26:23','',''),(2226324,'1','149','770',328,'Retail Sale Id 1308962',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 07:32:44','',''),(2226325,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 07:32:44','',''),(2226481,'1','149','770',328,'Retail Sale Id 1309028',998.56,0.00,0.00,0.00,63.20,'2021-12-10 07:40:50','',''),(2226482,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 07:40:50','',''),(2226565,'1','149','770',328,'Retail Sale Id 1309073',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 07:46:23','',''),(2226566,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 07:46:23','',''),(2226583,'1','149','770',328,'Retail Sale Id 1309082',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 07:47:27','',''),(2226584,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 07:47:27','',''),(2226723,'1','149','770',328,'Retail Sale Id 1309142',1598.96,0.00,0.00,0.00,101.20,'2021-12-10 07:53:06','',''),(2226724,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.53,0.00,'2021-12-10 07:53:06','',''),(2226755,'1','149','770',328,'Retail Sale Id 1309158',3160.00,0.00,0.00,0.00,200.00,'2021-12-10 07:55:19','',''),(2226756,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 07:55:19','',''),(2226810,'1','149','770',328,'Retail Sale Id 1309179',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 07:58:23','',''),(2226811,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 07:58:23','',''),(2227013,'1','149','770',328,'Retail Sale Id 1309250',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 08:06:28','',''),(2227014,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 08:06:28','',''),(2227086,'1','149','770',328,'Retail Sale Id 1309270',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 08:09:42','',''),(2227087,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 08:09:42','',''),(2227114,'1','149','770',328,'Retail Sale Id 1309286',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 08:11:20','',''),(2227115,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:11:20','',''),(2227221,'1','149','770',328,'Retail Sale Id 1309333',3160.00,0.00,0.00,0.00,200.00,'2021-12-10 08:16:56','',''),(2227222,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 08:16:56','',''),(2227281,'1','149','770',328,'Retail Sale Id 1309370',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 08:20:13','',''),(2227282,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 08:20:13','',''),(2227327,'1','149','770',328,'Retail Sale Id 1309394',998.56,0.00,0.00,0.00,63.20,'2021-12-10 08:22:43','',''),(2227328,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 08:22:43','',''),(2227329,'1','149','770',328,'Retail Sale Id 1309394',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 08:22:43','',''),(2227330,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 08:22:43','',''),(2227372,'1','149','770',328,'Retail Sale Id 1309404',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 08:23:53','',''),(2227373,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 08:23:53','',''),(2227429,'1','149','770',328,'Retail Sale Id 1309413',3002.00,0.00,0.00,0.00,190.00,'2021-12-10 08:25:10','',''),(2227430,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 08:25:10','',''),(2227465,'1','149','770',328,'Retail Sale Id 1309432',998.56,0.00,0.00,0.00,63.20,'2021-12-10 08:27:46','',''),(2227466,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 08:27:46','',''),(2227479,'1','149','770',328,'Retail Sale Id 1309448',1200.80,0.00,0.00,0.00,76.00,'2021-12-10 08:28:42','',''),(2227480,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-10 08:28:42','',''),(2227605,'1','149','770',328,'Retail Sale Id 1309514',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 08:34:35','',''),(2227606,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:34:35','',''),(2227635,'1','149','770',328,'Retail Sale Id 1309529',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 08:36:32','',''),(2227636,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 08:36:32','',''),(2227661,'1','149','770',328,'Retail Sale Id 1309544',3501.28,0.00,0.00,0.00,221.60,'2021-12-10 08:37:52','',''),(2227662,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-10 08:37:52','',''),(2227668,'1','149','770',328,'Retail Sale Id 1309548',1801.20,0.00,0.00,0.00,114.00,'2021-12-10 08:38:36','',''),(2227669,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.85,0.00,'2021-12-10 08:38:36','',''),(2227690,'1','149','770',328,'Retail Sale Id 1309556',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 08:39:55','',''),(2227691,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 08:39:55','',''),(2227708,'1','149','770',328,'Retail Sale Id 1309565',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 08:40:50','',''),(2227709,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 08:40:50','',''),(2227746,'1','149','770',328,'Retail Sale Id 1309582',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 08:43:01','',''),(2227747,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 08:43:01','',''),(2227798,'1','149','770',328,'Retail Sale Id 1309608',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 08:45:10','',''),(2227799,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 08:45:10','',''),(2228102,'1','149','770',328,'Retail Sale Id 1309744',4999.12,0.00,0.00,0.00,316.40,'2021-12-10 08:57:47','',''),(2228104,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-10 08:57:47','',''),(2228132,'1','149','770',328,'Retail Sale Id 1309762',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 08:58:56','',''),(2228133,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 08:58:56','',''),(2228252,'1','149','770',328,'Retail Sale Id 1309821',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 09:03:40','',''),(2228253,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 09:03:40','',''),(2228320,'1','149','770',328,'Retail Sale Id 1309851',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 09:07:44','',''),(2228321,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 09:07:44','',''),(2228334,'1','149','770',328,'Retail Sale Id 1309859',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 09:08:44','',''),(2228335,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 09:08:44','',''),(2228421,'1','149','770',328,'Retail Sale Id 1309899',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 09:14:07','',''),(2228422,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 09:14:07','',''),(2228461,'1','149','770',328,'Retail Sale Id 1309914',3197.92,0.00,0.00,0.00,202.40,'2021-12-10 09:15:40','',''),(2228462,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 09:15:40','',''),(2228513,'1','149','770',328,'Retail Sale Id 1309937',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 09:18:56','',''),(2228514,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 09:18:56','',''),(2228598,'1','149','770',328,'Retail Sale Id 1309979',2546.96,0.00,0.00,0.00,161.20,'2021-12-10 09:24:32','',''),(2228599,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-10 09:24:32','',''),(2228636,'1','149','770',328,'Retail Sale Id 1309998',4000.56,0.00,0.00,0.00,253.20,'2021-12-10 09:27:30','',''),(2228637,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-10 09:27:30','',''),(2228656,'1','149','770',328,'Retail Sale Id 1310007',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 09:28:24','',''),(2228657,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 09:28:24','',''),(2228722,'1','149','770',328,'Retail Sale Id 1310044',998.56,0.00,0.00,0.00,63.20,'2021-12-10 09:32:43','',''),(2228723,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 09:32:43','',''),(2228755,'1','149','770',328,'Retail Sale Id 1310055',802.64,0.00,0.00,0.00,50.80,'2021-12-10 09:33:56','',''),(2228756,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.27,0.00,'2021-12-10 09:33:56','',''),(2228797,'1','149','770',328,'Retail Sale Id 1310071',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 09:35:43','',''),(2228798,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 09:35:43','',''),(2228855,'1','149','770',328,'Retail Sale Id 1310100',2502.72,0.00,0.00,0.00,158.40,'2021-12-10 09:39:30','',''),(2228856,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-10 09:39:30','',''),(2228945,'1','149','770',328,'Retail Sale Id 1310146',3197.92,0.00,0.00,0.00,202.40,'2021-12-10 09:44:22','',''),(2228946,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 09:44:22','',''),(2229093,'1','149','770',328,'Retail Sale Id 1310221',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 09:53:04','',''),(2229094,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 09:53:04','',''),(2229127,'1','149','770',328,'Retail Sale Id 1310239',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 09:54:46','',''),(2229128,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 09:54:46','',''),(2229188,'1','149','770',328,'Retail Sale Id 1310268',2502.72,0.00,0.00,0.00,158.40,'2021-12-10 09:58:46','',''),(2229189,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-10 09:58:46','',''),(2229219,'1','149','770',328,'Retail Sale Id 1310283',998.56,0.00,0.00,0.00,63.20,'2021-12-10 10:01:03','',''),(2229220,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 10:01:03','',''),(2229567,'1','149','770',328,'Retail Sale Id 1310438',2502.72,0.00,0.00,0.00,158.40,'2021-12-10 10:19:03','',''),(2229568,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-10 10:19:03','',''),(2229621,'1','149','770',328,'Retail Sale Id 1310465',650.96,0.00,0.00,0.00,41.20,'2021-12-10 10:21:52','',''),(2229622,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-10 10:21:52','',''),(2229639,'1','149','770',328,'Retail Sale Id 1310472',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 10:22:51','',''),(2229640,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 10:22:51','',''),(2229679,'1','149','770',328,'Retail Sale Id 1310488',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 10:24:45','',''),(2229680,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 10:24:45','',''),(2229689,'1','149','770',328,'Retail Sale Id 1310494',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 10:25:36','',''),(2229690,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 10:25:36','',''),(2229729,'1','149','770',328,'Retail Sale Id 1310514',897.44,0.00,0.00,0.00,56.80,'2021-12-10 10:28:06','',''),(2229730,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.42,0.00,'2021-12-10 10:28:06','',''),(2229763,'1','149','770',328,'Retail Sale Id 1310532',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 10:30:09','',''),(2229764,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 10:30:09','',''),(2229795,'1','149','770',328,'Retail Sale Id 1310548',3002.00,0.00,0.00,0.00,190.00,'2021-12-10 10:32:36','',''),(2229796,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 10:32:36','',''),(2229809,'1','149','770',328,'Retail Sale Id 1310556',998.56,0.00,0.00,0.00,63.20,'2021-12-10 10:33:31','',''),(2229810,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 10:33:31','',''),(2229836,'1','149','770',328,'Retail Sale Id 1310561',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 10:34:33','',''),(2229837,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 10:34:33','',''),(2229977,'1','149','770',328,'Retail Sale Id 1310628',701.52,0.00,0.00,0.00,44.40,'2021-12-10 10:43:54','',''),(2229978,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-10 10:43:54','',''),(2230015,'1','149','770',328,'Retail Sale Id 1310642',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 10:45:38','',''),(2230016,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 10:45:38','',''),(2230269,'1','149','770',328,'Retail Sale Id 1310757',650.96,0.00,0.00,0.00,41.20,'2021-12-10 10:59:16','',''),(2230270,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-10 10:59:16','',''),(2230289,'1','149','770',328,'Retail Sale Id 1310769',998.56,0.00,0.00,0.00,63.20,'2021-12-10 11:00:25','',''),(2230290,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 11:00:25','',''),(2230304,'1','149','770',328,'Retail Sale Id 1310775',1200.80,0.00,0.00,0.00,76.00,'2021-12-10 11:01:18','',''),(2230305,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-10 11:01:18','',''),(2230348,'1','149','770',328,'Retail Sale Id 1310800',1099.68,0.00,0.00,0.00,69.60,'2021-12-10 11:03:47','',''),(2230349,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.74,0.00,'2021-12-10 11:03:47','',''),(2230390,'1','149','770',328,'Retail Sale Id 1310811',3197.92,0.00,0.00,0.00,202.40,'2021-12-10 11:05:18','',''),(2230391,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 11:05:18','',''),(2230586,'1','149','770',328,'Retail Sale Id 1310899',3160.00,0.00,0.00,0.00,200.00,'2021-12-10 11:17:36','',''),(2230587,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 11:17:36','',''),(2230725,'1','149','770',328,'Retail Sale Id 1310940',6320.00,0.00,0.00,0.00,400.00,'2021-12-10 11:24:45','',''),(2230726,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 11:24:45','',''),(2230741,'1','149','770',328,'Retail Sale Id 1310948',1099.68,0.00,0.00,0.00,69.60,'2021-12-10 11:25:59','',''),(2230742,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.74,0.00,'2021-12-10 11:25:59','',''),(2230759,'1','149','770',328,'Retail Sale Id 1310957',4999.12,0.00,0.00,0.00,316.40,'2021-12-10 11:26:56','',''),(2230760,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-10 11:26:56','',''),(2230769,'1','149','770',328,'Retail Sale Id 1310961',4999.12,0.00,0.00,0.00,316.40,'2021-12-10 11:27:49','',''),(2230770,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-10 11:27:49','',''),(2230785,'1','149','770',328,'Retail Sale Id 1310969',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 11:29:41','',''),(2230786,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 11:29:41','',''),(2230809,'1','149','770',328,'Retail Sale Id 1310984',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 11:31:35','',''),(2230810,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 11:31:35','',''),(2230987,'1','149','770',328,'Retail Sale Id 1311078',3002.00,0.00,0.00,0.00,190.00,'2021-12-10 11:43:59','',''),(2230988,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 11:43:59','',''),(2231109,'1','149','770',328,'Retail Sale Id 1311144',3160.00,0.00,0.00,0.00,200.00,'2021-12-10 11:53:51','',''),(2231110,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 11:53:51','',''),(2231145,'1','149','770',328,'Retail Sale Id 1311161',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 11:55:50','',''),(2231146,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 11:55:50','',''),(2231179,'1','149','770',328,'Retail Sale Id 1311176',998.56,0.00,0.00,0.00,63.20,'2021-12-10 11:56:59','',''),(2231180,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 11:56:59','',''),(2231191,'1','149','770',328,'Retail Sale Id 1311188',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 11:58:50','',''),(2231194,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 11:58:50','',''),(2231268,'1','149','770',328,'Retail Sale Id 1311223',2546.96,0.00,0.00,0.00,161.20,'2021-12-10 12:04:55','',''),(2231269,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-10 12:04:55','',''),(2231292,'1','149','770',328,'Retail Sale Id 1311235',3160.00,0.00,0.00,0.00,200.00,'2021-12-10 12:06:38','',''),(2231293,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 12:06:38','',''),(2231312,'1','149','770',328,'Retail Sale Id 1311245',701.52,0.00,0.00,0.00,44.40,'2021-12-10 12:07:38','',''),(2231313,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-10 12:07:38','',''),(2231393,'1','149','770',328,'Retail Sale Id 1311280',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 12:13:43','',''),(2231394,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 12:13:43','',''),(2231407,'1','149','770',328,'Retail Sale Id 1311288',1200.80,0.00,0.00,0.00,76.00,'2021-12-10 12:15:13','',''),(2231408,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-10 12:15:13','',''),(2231533,'1','149','770',328,'Retail Sale Id 1311360',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 12:25:32','',''),(2231534,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 12:25:32','',''),(2231552,'1','149','770',328,'Retail Sale Id 1311368',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 12:26:40','',''),(2231553,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 12:26:40','',''),(2231588,'1','149','770',328,'Retail Sale Id 1311387',1700.08,0.00,0.00,0.00,107.60,'2021-12-10 12:30:18','',''),(2231589,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.69,0.00,'2021-12-10 12:30:18','',''),(2231606,'1','149','770',328,'Retail Sale Id 1311399',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 12:33:24','',''),(2231607,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 12:33:24','',''),(2231706,'1','149','770',328,'Retail Sale Id 1311463',998.56,0.00,0.00,0.00,63.20,'2021-12-10 12:43:37','',''),(2231707,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 12:43:37','',''),(2231720,'1','149','770',328,'Retail Sale Id 1311469',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 12:45:01','',''),(2231721,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 12:45:01','',''),(2231824,'1','149','770',328,'Retail Sale Id 1311517',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 12:51:25','',''),(2231825,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 12:51:25','',''),(2231844,'1','149','770',328,'Retail Sale Id 1311528',3002.00,0.00,0.00,0.00,190.00,'2021-12-10 12:52:22','',''),(2231845,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 12:52:22','',''),(2232505,'1','149','770',328,'Retail Sale Id 1311839',4000.56,0.00,0.00,0.00,253.20,'2021-12-10 13:34:38','',''),(2232506,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-10 13:34:38','',''),(2232539,'1','149','770',328,'Retail Sale Id 1311856',2502.72,0.00,0.00,0.00,158.40,'2021-12-10 13:36:16','',''),(2232540,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-10 13:36:16','',''),(2232575,'1','149','770',328,'Retail Sale Id 1311869',3197.92,0.00,0.00,0.00,202.40,'2021-12-10 13:37:30','',''),(2232576,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 13:37:30','',''),(2232597,'1','149','770',328,'Retail Sale Id 1311880',650.96,0.00,0.00,0.00,41.20,'2021-12-10 13:38:40','',''),(2232598,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-10 13:38:40','',''),(2232623,'1','149','770',328,'Retail Sale Id 1311889',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 13:39:40','',''),(2232624,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 13:39:40','',''),(2232640,'1','149','770',328,'Retail Sale Id 1311899',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 13:40:47','',''),(2232641,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 13:40:47','',''),(2232659,'1','149','770',328,'Retail Sale Id 1311905',3002.00,0.00,0.00,0.00,190.00,'2021-12-10 13:41:29','',''),(2232660,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 13:41:29','',''),(2232681,'1','149','770',328,'Retail Sale Id 1311913',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 13:42:32','',''),(2232682,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 13:42:32','',''),(2232693,'1','149','770',328,'Retail Sale Id 1311921',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 13:43:16','',''),(2232694,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 13:43:16','',''),(2232735,'1','149','770',328,'Retail Sale Id 1311934',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 13:44:32','',''),(2232736,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 13:44:32','',''),(2232737,'1','149','770',328,'Retail Sale Id 1311934',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 13:44:32','',''),(2232738,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:44:32','',''),(2232829,'1','149','770',328,'Retail Sale Id 1311976',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 13:48:59','',''),(2232830,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 13:48:59','',''),(2232847,'1','149','770',328,'Retail Sale Id 1311986',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 13:50:18','',''),(2232848,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 13:50:18','',''),(2232871,'1','149','770',328,'Retail Sale Id 1311992',998.56,0.00,0.00,0.00,63.20,'2021-12-10 13:51:11','',''),(2232872,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 13:51:11','',''),(2232886,'1','149','770',328,'Retail Sale Id 1311998',3501.28,0.00,0.00,0.00,221.60,'2021-12-10 13:52:04','',''),(2232887,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-10 13:52:04','',''),(2232935,'1','149','770',328,'Retail Sale Id 1312022',650.96,0.00,0.00,0.00,41.20,'2021-12-10 13:54:29','',''),(2232936,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-10 13:54:29','',''),(2232971,'1','149','770',328,'Retail Sale Id 1312039',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 13:56:28','',''),(2232972,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:56:28','',''),(2233187,'1','149','770',328,'Retail Sale Id 1312115',9480.00,0.00,0.00,0.00,600.00,'2021-12-10 14:04:03','',''),(2233188,'1','149','770',328,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-10 14:04:03','',''),(2233231,'1','149','770',328,'Retail Sale Id 1312135',3002.00,0.00,0.00,0.00,190.00,'2021-12-10 14:07:19','',''),(2233232,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 14:07:19','',''),(2233579,'1','149','770',328,'Retail Sale Id 1312289',3197.92,0.00,0.00,0.00,202.40,'2021-12-10 14:25:04','',''),(2233580,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 14:25:04','',''),(2233638,'1','149','770',328,'Retail Sale Id 1312307',3197.92,0.00,0.00,0.00,202.40,'2021-12-10 14:27:43','',''),(2233639,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 14:27:43','',''),(2233693,'1','149','770',328,'Retail Sale Id 1312335',998.56,0.00,0.00,0.00,63.20,'2021-12-10 14:29:34','',''),(2233694,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 14:29:34','',''),(2233729,'1','149','770',328,'Retail Sale Id 1312354',2546.96,0.00,0.00,0.00,161.20,'2021-12-10 14:31:20','',''),(2233730,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-10 14:31:20','',''),(2233761,'1','149','770',328,'Retail Sale Id 1312371',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 14:32:45','',''),(2233762,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 14:32:45','',''),(2233787,'1','149','770',328,'Retail Sale Id 1312383',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 14:33:58','',''),(2233788,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 14:33:58','',''),(2233950,'1','149','770',328,'Retail Sale Id 1312445',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 14:40:33','',''),(2233951,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 14:40:33','',''),(2233989,'1','149','770',328,'Retail Sale Id 1312463',1200.80,0.00,0.00,0.00,76.00,'2021-12-10 14:42:04','',''),(2233990,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-10 14:42:04','',''),(2234135,'1','149','770',328,'Retail Sale Id 1312526',650.96,0.00,0.00,0.00,41.20,'2021-12-10 14:47:18','',''),(2234136,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-10 14:47:18','',''),(2234171,'1','149','770',328,'Retail Sale Id 1312549',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 14:48:53','',''),(2234172,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 14:48:53','',''),(2234211,'1','149','770',328,'Retail Sale Id 1312565',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 14:50:18','',''),(2234212,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 14:50:18','',''),(2234231,'1','149','770',328,'Retail Sale Id 1312574',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 14:51:22','',''),(2234232,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:51:22','',''),(2234248,'1','149','770',328,'Retail Sale Id 1312581',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 14:52:17','',''),(2234249,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 14:52:17','',''),(2234260,'1','149','770',328,'Retail Sale Id 1312588',1997.12,0.00,0.00,0.00,126.40,'2021-12-10 14:53:06','',''),(2234261,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 14:53:06','',''),(2234276,'1','149','770',328,'Retail Sale Id 1312595',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 14:53:56','',''),(2234277,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 14:53:56','',''),(2234304,'1','149','770',328,'Retail Sale Id 1312607',998.56,0.00,0.00,0.00,63.20,'2021-12-10 14:55:07','',''),(2234305,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 14:55:07','',''),(2234364,'1','149','770',328,'Retail Sale Id 1312638',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 14:59:12','',''),(2234365,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:59:12','',''),(2234408,'1','149','770',328,'Retail Sale Id 1312662',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 15:01:56','',''),(2234409,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 15:01:56','',''),(2234534,'1','149','770',328,'Retail Sale Id 1312722',998.56,0.00,0.00,0.00,63.20,'2021-12-10 15:08:08','',''),(2234535,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 15:08:08','',''),(2234575,'1','149','770',328,'Retail Sale Id 1312741',3197.92,0.00,0.00,0.00,202.40,'2021-12-10 15:10:19','',''),(2234576,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 15:10:19','',''),(2234637,'1','149','770',328,'Retail Sale Id 1312765',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 15:12:51','',''),(2234638,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 15:12:51','',''),(2234667,'1','149','770',328,'Retail Sale Id 1312782',2300.48,0.00,0.00,0.00,145.60,'2021-12-10 15:13:53','',''),(2234668,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.64,0.00,'2021-12-10 15:13:53','',''),(2234763,'1','149','770',328,'Retail Sale Id 1312837',701.52,0.00,0.00,0.00,44.40,'2021-12-10 15:18:26','',''),(2234764,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-10 15:18:26','',''),(2234815,'1','149','770',328,'Retail Sale Id 1312862',998.56,0.00,0.00,0.00,63.20,'2021-12-10 15:20:25','',''),(2234816,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 15:20:25','',''),(2234858,'1','149','770',328,'Retail Sale Id 1312884',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 15:21:52','',''),(2234859,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 15:21:52','',''),(2234880,'1','149','770',328,'Retail Sale Id 1312895',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 15:22:44','',''),(2234881,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:22:44','',''),(2234908,'1','149','770',328,'Retail Sale Id 1312915',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 15:24:08','',''),(2234909,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 15:24:08','',''),(2234968,'1','149','770',328,'Retail Sale Id 1312948',1200.80,0.00,0.00,0.00,76.00,'2021-12-10 15:25:45','',''),(2234969,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-10 15:25:45','',''),(2234990,'1','149','770',328,'Retail Sale Id 1312957',4000.56,0.00,0.00,0.00,253.20,'2021-12-10 15:26:50','',''),(2234991,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-10 15:26:50','',''),(2235143,'1','149','770',328,'Retail Sale Id 1313014',3197.92,0.00,0.00,0.00,202.40,'2021-12-10 15:32:14','',''),(2235144,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 15:32:14','',''),(2235179,'1','149','770',328,'Retail Sale Id 1313030',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 15:33:31','',''),(2235180,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 15:33:31','',''),(2235197,'1','149','770',328,'Retail Sale Id 1313040',2799.76,0.00,0.00,0.00,177.20,'2021-12-10 15:34:07','',''),(2235198,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.43,0.00,'2021-12-10 15:34:07','',''),(2235453,'1','149','770',328,'Retail Sale Id 1313164',4000.56,0.00,0.00,0.00,253.20,'2021-12-10 15:45:11','',''),(2235454,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-10 15:45:11','',''),(2235476,'1','149','770',328,'Retail Sale Id 1313182',3002.00,0.00,0.00,0.00,190.00,'2021-12-10 15:46:17','',''),(2235477,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 15:46:17','',''),(2235570,'1','149','770',328,'Retail Sale Id 1313240',3798.32,0.00,0.00,0.00,240.40,'2021-12-10 15:51:31','',''),(2235571,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 15:51:31','',''),(2235644,'1','149','770',328,'Retail Sale Id 1313281',2502.72,0.00,0.00,0.00,158.40,'2021-12-10 15:55:12','',''),(2235645,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-10 15:55:12','',''),(2235680,'1','149','770',328,'Retail Sale Id 1313290',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 15:56:18','',''),(2235681,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 15:56:18','',''),(2235700,'1','149','770',328,'Retail Sale Id 1313301',15800.00,0.00,0.00,0.00,1000.00,'2021-12-10 15:57:12','',''),(2235701,'1','149','770',328,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 15:57:12','',''),(2235724,'1','149','770',328,'Retail Sale Id 1313317',1497.84,0.00,0.00,0.00,94.80,'2021-12-10 15:58:43','',''),(2235725,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-10 15:58:43','',''),(2235749,'1','149','770',328,'Retail Sale Id 1313330',3002.00,0.00,0.00,0.00,190.00,'2021-12-10 15:59:40','',''),(2235750,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 15:59:40','',''),(2235806,'1','149','770',328,'Retail Sale Id 1313361',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 16:02:17','',''),(2235807,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 16:02:17','',''),(2235859,'1','149','770',328,'Retail Sale Id 1313386',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 16:05:12','',''),(2235860,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:05:12','',''),(2236015,'1','149','770',328,'Retail Sale Id 1313445',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 16:11:16','',''),(2236016,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 16:11:16','',''),(2236053,'1','149','770',328,'Retail Sale Id 1313468',2502.72,0.00,0.00,0.00,158.40,'2021-12-10 16:13:08','',''),(2236054,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-10 16:13:08','',''),(2236075,'1','149','770',328,'Retail Sale Id 1313487',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 16:14:25','',''),(2236076,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 16:14:25','',''),(2236099,'1','149','770',328,'Retail Sale Id 1313498',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 16:15:31','',''),(2236100,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 16:15:31','',''),(2236223,'1','149','770',328,'Retail Sale Id 1313567',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 16:20:57','',''),(2236224,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 16:20:57','',''),(2236274,'1','149','770',328,'Retail Sale Id 1313596',3197.92,0.00,0.00,0.00,202.40,'2021-12-10 16:23:06','',''),(2236275,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 16:23:06','',''),(2236306,'1','149','770',328,'Retail Sale Id 1313613',1902.32,0.00,0.00,0.00,120.40,'2021-12-10 16:24:15','',''),(2236307,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 16:24:15','',''),(2236367,'1','149','770',328,'Retail Sale Id 1313642',701.52,0.00,0.00,0.00,44.40,'2021-12-10 16:26:59','',''),(2236368,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-10 16:26:59','',''),(2237082,'1','149','770',328,'Retail Sale Id 1313980',6199.92,0.00,0.00,0.00,392.40,'2021-12-10 17:06:33','',''),(2237083,'1','149','770',328,'Retail sales',0.00,0.00,0.00,9.81,0.00,'2021-12-10 17:06:33','',''),(2237110,'1','149','770',328,'Retail Sale Id 1313993',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 17:08:59','',''),(2237111,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 17:08:59','',''),(2237128,'1','149','770',328,'Retail Sale Id 1314002',3002.00,0.00,0.00,0.00,190.00,'2021-12-10 17:10:35','',''),(2237129,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 17:10:35','',''),(2237166,'1','149','770',328,'Retail Sale Id 1314017',998.56,0.00,0.00,0.00,63.20,'2021-12-10 17:14:18','',''),(2237167,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 17:14:18','',''),(2237190,'1','149','770',328,'Retail Sale Id 1314032',1301.92,0.00,0.00,0.00,82.40,'2021-12-10 17:15:34','',''),(2237191,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 17:15:34','',''),(2237292,'1','149','770',328,'Retail Sale Id 1314079',701.52,0.00,0.00,0.00,44.40,'2021-12-10 17:25:06','',''),(2237293,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-10 17:25:06','',''),(2237331,'1','149','770',328,'Retail Sale Id 1314085',998.56,0.00,0.00,0.00,63.20,'2021-12-10 17:26:24','',''),(2237332,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 17:26:24','',''),(2237397,'1','149','770',328,'Retail Sale Id 1314107',4000.56,0.00,0.00,0.00,253.20,'2021-12-10 17:33:51','',''),(2237398,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-10 17:33:51','',''),(2237426,'1','149','770',328,'Retail Sale Id 1314122',998.56,0.00,0.00,0.00,63.20,'2021-12-10 17:36:40','',''),(2237427,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 17:36:40','',''),(2237544,'1','149','770',328,'Retail Sale Id 1314209',133175.04,0.00,0.00,0.00,8428.80,'2021-12-10 17:50:03','',''),(2237545,'1','149','770',328,'Retail sales',0.00,0.00,0.00,210.72,0.00,'2021-12-10 17:50:03','',''),(2245019,'1','149','770',328,'Retail Sale Id 1317569',215151.76,0.00,0.00,0.00,13617.20,'2021-12-11 11:47:09','',''),(2245020,'1','149','770',328,'Retail sales',0.00,0.00,0.00,340.43,0.00,'2021-12-11 11:47:09','',''),(2250113,'1','149','770',328,'Retail Sale Id 1320121',31600.00,0.00,0.00,0.00,2000.00,'2021-12-11 16:40:42','',''),(2250114,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 16:40:42','',''),(2250140,'1','149','770',328,'Retail Sale Id 1320134',4424.00,0.00,0.00,0.00,280.00,'2021-12-11 16:42:00','',''),(2250141,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-11 16:42:00','',''),(2250232,'1','149',NULL,328,'Purchased from AA RANO NIGERIA LIMITED',0.00,1776000.00,3000.00,0.00,0.00,'2021-12-11 16:48:28','',''),(2250256,'1','149',NULL,328,'Reception corrector for bridging 127036',0.00,0.00,0.00,3000.00,0.00,'2021-12-11 16:49:26','',''),(2250257,'1','149','770',328,'Received from bridging 127036',0.00,0.00,3000.00,0.00,0.00,'2021-12-11 16:49:26','',''),(2250445,'1','149','770',328,'Retail Sale Id 1320266',650.96,0.00,0.00,0.00,41.20,'2021-12-11 17:00:07','',''),(2250446,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-11 17:00:07','',''),(2250461,'1','149','770',328,'Retail Sale Id 1320273',7900.00,0.00,0.00,0.00,500.00,'2021-12-11 17:01:11','',''),(2250462,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 17:01:11','',''),(2250540,'1','149','770',328,'Retail Sale Id 1320313',3002.00,0.00,0.00,0.00,190.00,'2021-12-11 17:04:57','',''),(2250541,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 17:04:57','',''),(2250562,'1','149','770',328,'Retail Sale Id 1320321',998.56,0.00,0.00,0.00,63.20,'2021-12-11 17:06:07','',''),(2250563,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 17:06:07','',''),(2250986,'1','149','770',328,'Retail Sale Id 1320530',200849.60,0.00,0.00,0.00,12712.00,'2021-12-11 17:42:23','',''),(2250987,'1','149','770',328,'Retail sales',0.00,0.00,0.00,317.80,0.00,'2021-12-11 17:42:23','',''),(2252250,'1','149','770',328,'Retail Sale Id 1320917',998.56,0.00,0.00,0.00,63.20,'2021-12-12 06:32:32','',''),(2252251,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 06:32:32','',''),(2252337,'1','149','770',328,'Retail Sale Id 1320949',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 06:37:04','',''),(2252338,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 06:37:04','',''),(2252400,'1','149','770',328,'Retail Sale Id 1320969',897.44,0.00,0.00,0.00,56.80,'2021-12-12 06:39:32','',''),(2252401,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.42,0.00,'2021-12-12 06:39:32','',''),(2252420,'1','149','770',328,'Retail Sale Id 1320979',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 06:41:06','',''),(2252421,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 06:41:06','',''),(2252486,'1','149','770',328,'Retail Sale Id 1321005',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 06:46:05','',''),(2252487,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 06:46:05','',''),(2252526,'1','149','770',328,'Retail Sale Id 1321019',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 06:47:20','',''),(2252527,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 06:47:20','',''),(2252543,'1','149','770',328,'Retail Sale Id 1321028',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 06:48:47','',''),(2252544,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 06:48:47','',''),(2252600,'1','149','770',328,'Retail Sale Id 1321038',1200.80,0.00,0.00,0.00,76.00,'2021-12-12 06:50:38','',''),(2252601,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-12 06:50:38','',''),(2252627,'1','149','770',328,'Retail Sale Id 1321046',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 06:51:43','',''),(2252628,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 06:51:43','',''),(2252659,'1','149','770',328,'Retail Sale Id 1321062',2597.52,0.00,0.00,0.00,164.40,'2021-12-12 06:53:52','',''),(2252660,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.11,0.00,'2021-12-12 06:53:52','',''),(2252839,'1','149','770',328,'Retail Sale Id 1321154',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 07:09:44','',''),(2252840,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 07:09:44','',''),(2255353,'1','149','770',328,'Retail Sale Id 1322434',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 09:46:09','',''),(2255354,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:46:09','',''),(2255419,'1','149','770',328,'Retail Sale Id 1322461',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 09:49:21','',''),(2255420,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 09:49:21','',''),(2255435,'1','149','770',328,'Retail Sale Id 1322467',998.56,0.00,0.00,0.00,63.20,'2021-12-12 09:50:12','',''),(2255436,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 09:50:12','',''),(2255559,'1','149','770',328,'Retail Sale Id 1322521',4999.12,0.00,0.00,0.00,316.40,'2021-12-12 09:55:31','',''),(2255560,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-12 09:55:31','',''),(2255585,'1','149','770',328,'Retail Sale Id 1322535',998.56,0.00,0.00,0.00,63.20,'2021-12-12 09:56:25','',''),(2255586,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 09:56:25','',''),(2255608,'1','149','770',328,'Retail Sale Id 1322544',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 09:57:19','',''),(2255609,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 09:57:19','',''),(2255666,'1','149','770',328,'Retail Sale Id 1322556',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 10:00:12','',''),(2255667,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 10:00:12','',''),(2255696,'1','149','770',328,'Retail Sale Id 1322582',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 10:01:24','',''),(2255697,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 10:01:24','',''),(2255757,'1','149','770',328,'Retail Sale Id 1322605',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 10:04:10','',''),(2255758,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 10:04:10','',''),(2255791,'1','149','770',328,'Retail Sale Id 1322625',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 10:05:16','',''),(2255792,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 10:05:16','',''),(2255821,'1','149','770',328,'Retail Sale Id 1322646',998.56,0.00,0.00,0.00,63.20,'2021-12-12 10:06:56','',''),(2255822,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 10:06:56','',''),(2255855,'1','149','770',328,'Retail Sale Id 1322663',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 10:08:19','',''),(2255856,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 10:08:19','',''),(2255919,'1','149','770',328,'Retail Sale Id 1322692',897.44,0.00,0.00,0.00,56.80,'2021-12-12 10:11:51','',''),(2255921,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.42,0.00,'2021-12-12 10:11:51','',''),(2255942,'1','149','770',328,'Retail Sale Id 1322703',5100.24,0.00,0.00,0.00,322.80,'2021-12-12 10:12:55','',''),(2255943,'1','149','770',328,'Retail sales',0.00,0.00,0.00,8.07,0.00,'2021-12-12 10:12:55','',''),(2256169,'1','149','770',328,'Retail Sale Id 1322830',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 10:25:57','',''),(2256170,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 10:25:57','',''),(2256297,'1','149','770',328,'Retail Sale Id 1322900',4000.56,0.00,0.00,0.00,253.20,'2021-12-12 10:33:20','',''),(2256298,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-12 10:33:20','',''),(2256333,'1','149','770',328,'Retail Sale Id 1322913',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 10:34:34','',''),(2256334,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 10:34:34','',''),(2256365,'1','149','770',328,'Retail Sale Id 1322934',1301.92,0.00,0.00,0.00,82.40,'2021-12-12 10:36:23','',''),(2256366,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 10:36:23','',''),(2256558,'1','149','770',328,'Retail Sale Id 1323023',897.44,0.00,0.00,0.00,56.80,'2021-12-12 10:45:08','',''),(2256559,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.42,0.00,'2021-12-12 10:45:08','',''),(2256598,'1','149','770',328,'Retail Sale Id 1323045',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 10:47:02','',''),(2256599,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:47:02','',''),(2256628,'1','149','770',328,'Retail Sale Id 1323063',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 10:48:53','',''),(2256629,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 10:48:53','',''),(2256826,'1','149','770',328,'Retail Sale Id 1323164',998.56,0.00,0.00,0.00,63.20,'2021-12-12 10:57:40','',''),(2256827,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 10:57:40','',''),(2257024,'1','149','770',328,'Retail Sale Id 1323262',4000.56,0.00,0.00,0.00,253.20,'2021-12-12 11:05:36','',''),(2257025,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-12 11:05:36','',''),(2257086,'1','149','770',328,'Retail Sale Id 1323296',8001.12,0.00,0.00,0.00,506.40,'2021-12-12 11:08:09','',''),(2257087,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-12 11:08:09','',''),(2257419,'1','149','770',328,'Retail Sale Id 1323460',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 11:21:31','',''),(2257420,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:21:31','',''),(2257515,'1','149','770',328,'Retail Sale Id 1323504',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 11:25:52','',''),(2257516,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 11:25:52','',''),(2257542,'1','149','770',328,'Retail Sale Id 1323519',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 11:27:06','',''),(2257543,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 11:27:06','',''),(2257576,'1','149','770',328,'Retail Sale Id 1323551',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 11:28:47','',''),(2257577,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:28:47','',''),(2257612,'1','149','770',328,'Retail Sale Id 1323572',1801.20,0.00,0.00,0.00,114.00,'2021-12-12 11:30:42','',''),(2257613,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.85,0.00,'2021-12-12 11:30:42','',''),(2257630,'1','149','770',328,'Retail Sale Id 1323583',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 11:31:56','',''),(2257631,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 11:31:56','',''),(2257690,'1','149','770',328,'Retail Sale Id 1323606',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 11:34:29','',''),(2257691,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 11:34:29','',''),(2257715,'1','149','770',328,'Retail Sale Id 1323621',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 11:35:43','',''),(2257716,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 11:35:43','',''),(2257753,'1','149','770',328,'Retail Sale Id 1323635',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 11:37:37','',''),(2257754,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:37:37','',''),(2257779,'1','149','770',328,'Retail Sale Id 1323653',2597.52,0.00,0.00,0.00,164.40,'2021-12-12 11:39:06','',''),(2257780,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.11,0.00,'2021-12-12 11:39:06','',''),(2257818,'1','149','770',328,'Retail Sale Id 1323669',4480.88,0.00,0.00,0.00,283.60,'2021-12-12 11:40:31','',''),(2257819,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.09,0.00,'2021-12-12 11:40:31','',''),(2257842,'1','149','770',328,'Retail Sale Id 1323681',897.44,0.00,0.00,0.00,56.80,'2021-12-12 11:41:35','',''),(2257843,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.42,0.00,'2021-12-12 11:41:35','',''),(2257877,'1','149','770',328,'Retail Sale Id 1323698',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 11:43:09','',''),(2257878,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 11:43:09','',''),(2257899,'1','149','770',328,'Retail Sale Id 1323708',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 11:44:09','',''),(2257900,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:44:09','',''),(2257941,'1','149','770',328,'Retail Sale Id 1323729',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 11:46:09','',''),(2257942,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 11:46:09','',''),(2258040,'1','149','770',328,'Retail Sale Id 1323774',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 11:51:07','',''),(2258041,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:51:07','',''),(2258072,'1','149','770',328,'Retail Sale Id 1323789',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 11:52:19','',''),(2258073,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 11:52:19','',''),(2258174,'1','149','770',328,'Retail Sale Id 1323838',701.52,0.00,0.00,0.00,44.40,'2021-12-12 11:56:50','',''),(2258176,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-12 11:56:50','',''),(2258273,'1','149','770',328,'Retail Sale Id 1323885',1497.84,0.00,0.00,0.00,94.80,'2021-12-12 12:01:56','',''),(2258274,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 12:01:56','',''),(2258294,'1','149','770',328,'Retail Sale Id 1323895',3501.28,0.00,0.00,0.00,221.60,'2021-12-12 12:03:20','',''),(2258295,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-12 12:03:20','',''),(2258314,'1','149','770',328,'Retail Sale Id 1323904',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 12:04:38','',''),(2258315,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 12:04:38','',''),(2258334,'1','149','770',328,'Retail Sale Id 1323917',998.56,0.00,0.00,0.00,63.20,'2021-12-12 12:06:30','',''),(2258335,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 12:06:30','',''),(2258464,'1','149','770',328,'Retail Sale Id 1323981',701.52,0.00,0.00,0.00,44.40,'2021-12-12 12:13:38','',''),(2258465,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-12 12:13:38','',''),(2258520,'1','149','770',328,'Retail Sale Id 1324002',998.56,0.00,0.00,0.00,63.20,'2021-12-12 12:15:53','',''),(2258521,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 12:15:53','',''),(2258540,'1','149','770',328,'Retail Sale Id 1324015',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 12:16:55','',''),(2258541,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 12:16:55','',''),(2258572,'1','149','770',328,'Retail Sale Id 1324027',18960.00,0.00,0.00,0.00,1200.00,'2021-12-12 12:18:14','',''),(2258573,'1','149','770',328,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-12 12:18:14','',''),(2258602,'1','149','770',328,'Retail Sale Id 1324045',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 12:19:43','',''),(2258603,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 12:19:43','',''),(2258654,'1','149','770',328,'Retail Sale Id 1324071',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 12:22:39','',''),(2258655,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:22:39','',''),(2258674,'1','149','770',328,'Retail Sale Id 1324082',998.56,0.00,0.00,0.00,63.20,'2021-12-12 12:23:34','',''),(2258675,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 12:23:34','',''),(2258688,'1','149','770',328,'Retail Sale Id 1324091',1801.20,0.00,0.00,0.00,114.00,'2021-12-12 12:24:42','',''),(2258690,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.85,0.00,'2021-12-12 12:24:42','',''),(2258735,'1','149','770',328,'Retail Sale Id 1324112',2199.36,0.00,0.00,0.00,139.20,'2021-12-12 12:26:20','',''),(2258736,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.48,0.00,'2021-12-12 12:26:20','',''),(2258792,'1','149','770',328,'Retail Sale Id 1324130',1301.92,0.00,0.00,0.00,82.40,'2021-12-12 12:27:57','',''),(2258793,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 12:27:57','',''),(2258816,'1','149','770',328,'Retail Sale Id 1324141',701.52,0.00,0.00,0.00,44.40,'2021-12-12 12:29:12','',''),(2258817,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-12 12:29:12','',''),(2258857,'1','149','770',328,'Retail Sale Id 1324167',8001.12,0.00,0.00,0.00,506.40,'2021-12-12 12:30:59','',''),(2258858,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-12 12:30:59','',''),(2258952,'1','149','770',328,'Retail Sale Id 1324210',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 12:34:54','',''),(2258953,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 12:34:54','',''),(2259103,'1','149','770',328,'Retail Sale Id 1324284',897.44,0.00,0.00,0.00,56.80,'2021-12-12 12:42:14','',''),(2259104,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.42,0.00,'2021-12-12 12:42:14','',''),(2259178,'1','149','770',328,'Retail Sale Id 1324317',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 12:45:19','',''),(2259179,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 12:45:19','',''),(2259278,'1','149','770',328,'Retail Sale Id 1324368',1497.84,0.00,0.00,0.00,94.80,'2021-12-12 12:49:52','',''),(2259279,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 12:49:52','',''),(2259378,'1','149','770',328,'Retail Sale Id 1324412',998.56,0.00,0.00,0.00,63.20,'2021-12-12 12:54:42','',''),(2259379,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 12:54:42','',''),(2259413,'1','149','770',328,'Retail Sale Id 1324428',1497.84,0.00,0.00,0.00,94.80,'2021-12-12 12:56:13','',''),(2259414,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 12:56:13','',''),(2259459,'1','149','770',328,'Retail Sale Id 1324451',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 12:58:51','',''),(2259460,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 12:58:51','',''),(2259483,'1','149','770',328,'Retail Sale Id 1324464',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 13:00:06','',''),(2259484,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 13:00:06','',''),(2259531,'1','149','770',328,'Retail Sale Id 1324486',7501.84,0.00,0.00,0.00,474.80,'2021-12-12 13:03:20','',''),(2259532,'1','149','770',328,'Retail sales',0.00,0.00,0.00,11.87,0.00,'2021-12-12 13:03:20','',''),(2259557,'1','149','770',328,'Retail Sale Id 1324502',8001.12,0.00,0.00,0.00,506.40,'2021-12-12 13:04:40','',''),(2259558,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-12 13:04:40','',''),(2259667,'1','149','770',328,'Retail Sale Id 1324566',8001.12,0.00,0.00,0.00,506.40,'2021-12-12 13:11:43','',''),(2259669,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-12 13:11:43','',''),(2259782,'1','149','770',328,'Retail Sale Id 1324617',1497.84,0.00,0.00,0.00,94.80,'2021-12-12 13:16:54','',''),(2259783,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 13:16:54','',''),(2259809,'1','149','770',328,'Retail Sale Id 1324632',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 13:18:13','',''),(2259810,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 13:18:13','',''),(2259827,'1','149','770',328,'Retail Sale Id 1324636',1497.84,0.00,0.00,0.00,94.80,'2021-12-12 13:19:03','',''),(2259828,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 13:19:03','',''),(2259841,'1','149','770',328,'Retail Sale Id 1324644',2502.72,0.00,0.00,0.00,158.40,'2021-12-12 13:19:55','',''),(2259842,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-12 13:19:55','',''),(2259853,'1','149','770',328,'Retail Sale Id 1324649',1301.92,0.00,0.00,0.00,82.40,'2021-12-12 13:20:43','',''),(2259854,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 13:20:43','',''),(2259871,'1','149','770',328,'Retail Sale Id 1324656',701.52,0.00,0.00,0.00,44.40,'2021-12-12 13:21:35','',''),(2259872,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-12 13:21:35','',''),(2259891,'1','149','770',328,'Retail Sale Id 1324665',650.96,0.00,0.00,0.00,41.20,'2021-12-12 13:22:36','',''),(2259892,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-12 13:22:36','',''),(2259906,'1','149','770',328,'Retail Sale Id 1324669',1301.92,0.00,0.00,0.00,82.40,'2021-12-12 13:23:16','',''),(2259907,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 13:23:16','',''),(2259972,'1','149','770',328,'Retail Sale Id 1324698',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 13:26:34','',''),(2259973,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 13:26:34','',''),(2260002,'1','149','770',328,'Retail Sale Id 1324708',1301.92,0.00,0.00,0.00,82.40,'2021-12-12 13:27:33','',''),(2260003,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 13:27:33','',''),(2260052,'1','149','770',328,'Retail Sale Id 1324720',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 13:28:49','',''),(2260053,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 13:28:49','',''),(2260087,'1','149','770',328,'Retail Sale Id 1324736',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 13:30:13','',''),(2260088,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 13:30:13','',''),(2260135,'1','149','770',328,'Retail Sale Id 1324756',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 13:32:57','',''),(2260136,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 13:32:57','',''),(2260169,'1','149','770',328,'Retail Sale Id 1324776',998.56,0.00,0.00,0.00,63.20,'2021-12-12 13:34:34','',''),(2260170,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 13:34:34','',''),(2260183,'1','149','770',328,'Retail Sale Id 1324783',802.64,0.00,0.00,0.00,50.80,'2021-12-12 13:35:39','',''),(2260184,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.27,0.00,'2021-12-12 13:35:39','',''),(2260232,'1','149','770',328,'Retail Sale Id 1324801',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 13:38:00','',''),(2260233,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 13:38:00','',''),(2260297,'1','149','770',328,'Retail Sale Id 1324827',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 13:40:31','',''),(2260298,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 13:40:31','',''),(2260335,'1','149','770',328,'Retail Sale Id 1324848',1301.92,0.00,0.00,0.00,82.40,'2021-12-12 13:42:18','',''),(2260336,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 13:42:18','',''),(2260341,'1','149','770',328,'Retail Sale Id 1324851',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 13:43:08','',''),(2260342,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 13:43:08','',''),(2260372,'1','149','770',328,'Retail Sale Id 1324863',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 13:44:56','',''),(2260373,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 13:44:56','',''),(2260396,'1','149','770',328,'Retail Sale Id 1324878',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 13:45:59','',''),(2260397,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 13:45:59','',''),(2260438,'1','149','770',328,'Retail Sale Id 1324902',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 13:48:30','',''),(2260439,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 13:48:30','',''),(2260468,'1','149','770',328,'Retail Sale Id 1324912',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 13:49:50','',''),(2260469,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 13:49:50','',''),(2260490,'1','149','770',328,'Retail Sale Id 1324923',998.56,0.00,0.00,0.00,63.20,'2021-12-12 13:50:54','',''),(2260491,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 13:50:54','',''),(2260519,'1','149','770',328,'Retail Sale Id 1324938',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 13:51:51','',''),(2260520,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 13:51:51','',''),(2260572,'1','149','770',328,'Retail Sale Id 1324953',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 13:54:03','',''),(2260573,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 13:54:03','',''),(2260584,'1','149','770',328,'Retail Sale Id 1324960',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 13:55:09','',''),(2260585,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 13:55:09','',''),(2260603,'1','149','770',328,'Retail Sale Id 1324970',998.56,0.00,0.00,0.00,63.20,'2021-12-12 13:56:08','',''),(2260604,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 13:56:08','',''),(2260631,'1','149','770',328,'Retail Sale Id 1324983',1497.84,0.00,0.00,0.00,94.80,'2021-12-12 13:57:02','',''),(2260632,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 13:57:02','',''),(2260657,'1','149','770',328,'Retail Sale Id 1324996',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 13:58:19','',''),(2260658,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 13:58:19','',''),(2260732,'1','149','770',328,'Retail Sale Id 1325011',31600.00,0.00,0.00,0.00,2000.00,'2021-12-12 14:00:55','',''),(2260733,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 14:00:55','',''),(2260767,'1','149','770',328,'Retail Sale Id 1325026',1301.92,0.00,0.00,0.00,82.40,'2021-12-12 14:02:11','',''),(2260768,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 14:02:11','',''),(2260795,'1','149','770',328,'Retail Sale Id 1325031',1200.80,0.00,0.00,0.00,76.00,'2021-12-12 14:02:59','',''),(2260796,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-12 14:02:59','',''),(2260817,'1','149','770',328,'Retail Sale Id 1325037',1497.84,0.00,0.00,0.00,94.80,'2021-12-12 14:03:47','',''),(2260818,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 14:03:47','',''),(2260864,'1','149','770',328,'Retail Sale Id 1325061',2502.72,0.00,0.00,0.00,158.40,'2021-12-12 14:06:31','',''),(2260865,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-12 14:06:31','',''),(2260902,'1','149','770',328,'Retail Sale Id 1325078',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 14:08:05','',''),(2260903,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 14:08:05','',''),(2260946,'1','149','770',328,'Retail Sale Id 1325096',998.56,0.00,0.00,0.00,63.20,'2021-12-12 14:10:22','',''),(2260947,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 14:10:22','',''),(2261047,'1','149','770',328,'Retail Sale Id 1325138',701.52,0.00,0.00,0.00,44.40,'2021-12-12 14:15:23','',''),(2261048,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-12 14:15:23','',''),(2261057,'1','149','770',328,'Retail Sale Id 1325145',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 14:16:26','',''),(2261058,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 14:16:26','',''),(2261208,'1','149','770',328,'Retail Sale Id 1325201',650.96,0.00,0.00,0.00,41.20,'2021-12-12 14:24:16','',''),(2261209,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-12 14:24:16','',''),(2261246,'1','149','770',328,'Retail Sale Id 1325217',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 14:25:41','',''),(2261247,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 14:25:41','',''),(2261357,'1','149','770',328,'Retail Sale Id 1325241',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 14:29:03','',''),(2261358,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 14:29:03','',''),(2261394,'1','149','770',328,'Retail Sale Id 1325253',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 14:30:11','',''),(2261395,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 14:30:11','',''),(2261439,'1','149','770',328,'Retail Sale Id 1325276',998.56,0.00,0.00,0.00,63.20,'2021-12-12 14:33:38','',''),(2261440,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 14:33:38','',''),(2261467,'1','149','770',328,'Retail Sale Id 1325289',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 14:34:49','',''),(2261468,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 14:34:49','',''),(2261480,'1','149','770',328,'Retail Sale Id 1325296',998.56,0.00,0.00,0.00,63.20,'2021-12-12 14:35:28','',''),(2261481,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 14:35:28','',''),(2261498,'1','149','770',328,'Retail Sale Id 1325308',1497.84,0.00,0.00,0.00,94.80,'2021-12-12 14:36:17','',''),(2261499,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 14:36:17','',''),(2261541,'1','149','770',328,'Retail Sale Id 1325327',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 14:38:37','',''),(2261542,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 14:38:37','',''),(2261590,'1','149','770',328,'Retail Sale Id 1325349',1497.84,0.00,0.00,0.00,94.80,'2021-12-12 14:42:34','',''),(2261591,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 14:42:34','',''),(2261624,'1','149','770',328,'Retail Sale Id 1325371',1301.92,0.00,0.00,0.00,82.40,'2021-12-12 14:45:36','',''),(2261625,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 14:45:36','',''),(2261677,'1','149','770',328,'Retail Sale Id 1325387',4000.56,0.00,0.00,0.00,253.20,'2021-12-12 14:47:16','',''),(2261678,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-12 14:47:16','',''),(2261704,'1','149','770',328,'Retail Sale Id 1325400',1403.04,0.00,0.00,0.00,88.80,'2021-12-12 14:49:05','',''),(2261705,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.22,0.00,'2021-12-12 14:49:05','',''),(2261741,'1','149','770',328,'Retail Sale Id 1325414',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 14:49:56','',''),(2261742,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 14:49:56','',''),(2261835,'1','149','770',328,'Retail Sale Id 1325454',650.96,0.00,0.00,0.00,41.20,'2021-12-12 14:55:30','',''),(2261836,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-12 14:55:30','',''),(2261849,'1','149','770',328,'Retail Sale Id 1325461',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 14:56:19','',''),(2261850,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 14:56:19','',''),(2261874,'1','149','770',328,'Retail Sale Id 1325469',1301.92,0.00,0.00,0.00,82.40,'2021-12-12 14:57:33','',''),(2261875,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 14:57:33','',''),(2261891,'1','149','770',328,'Retail Sale Id 1325478',1497.84,0.00,0.00,0.00,94.80,'2021-12-12 14:58:27','',''),(2261892,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 14:58:27','',''),(2262058,'1','149','770',328,'Retail Sale Id 1325539',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 15:06:32','',''),(2262059,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 15:06:32','',''),(2262072,'1','149','770',328,'Retail Sale Id 1325547',650.96,0.00,0.00,0.00,41.20,'2021-12-12 15:07:19','',''),(2262073,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-12 15:07:19','',''),(2262092,'1','149','770',328,'Retail Sale Id 1325557',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 15:08:18','',''),(2262093,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 15:08:18','',''),(2262135,'1','149','770',328,'Retail Sale Id 1325576',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 15:10:43','',''),(2262136,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 15:10:43','',''),(2262283,'1','149','770',328,'Retail Sale Id 1325646',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 15:18:45','',''),(2262284,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 15:18:45','',''),(2262301,'1','149','770',328,'Retail Sale Id 1325655',998.56,0.00,0.00,0.00,63.20,'2021-12-12 15:20:24','',''),(2262302,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 15:20:24','',''),(2262377,'1','149','770',328,'Retail Sale Id 1325690',1801.20,0.00,0.00,0.00,114.00,'2021-12-12 15:25:08','',''),(2262378,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.85,0.00,'2021-12-12 15:25:08','',''),(2262396,'1','149','770',328,'Retail Sale Id 1325700',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 15:26:06','',''),(2262397,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 15:26:06','',''),(2262410,'1','149','770',328,'Retail Sale Id 1325706',1497.84,0.00,0.00,0.00,94.80,'2021-12-12 15:26:54','',''),(2262411,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 15:26:54','',''),(2262467,'1','149','770',328,'Retail Sale Id 1325735',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 15:30:23','',''),(2262468,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 15:30:23','',''),(2262487,'1','149','770',328,'Retail Sale Id 1325746',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 15:31:36','',''),(2262488,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 15:31:36','',''),(2262516,'1','149','770',328,'Retail Sale Id 1325759',1301.92,0.00,0.00,0.00,82.40,'2021-12-12 15:33:03','',''),(2262517,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 15:33:03','',''),(2262536,'1','149','770',328,'Retail Sale Id 1325769',998.56,0.00,0.00,0.00,63.20,'2021-12-12 15:34:55','',''),(2262537,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 15:34:55','',''),(2262578,'1','149','770',328,'Retail Sale Id 1325785',7501.84,0.00,0.00,0.00,474.80,'2021-12-12 15:36:31','',''),(2262579,'1','149','770',328,'Retail sales',0.00,0.00,0.00,11.87,0.00,'2021-12-12 15:36:31','',''),(2262610,'1','149','770',328,'Retail Sale Id 1325798',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 15:38:02','',''),(2262611,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 15:38:02','',''),(2262646,'1','149','770',328,'Retail Sale Id 1325816',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 15:40:18','',''),(2262647,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 15:40:18','',''),(2262668,'1','149','770',328,'Retail Sale Id 1325829',4000.56,0.00,0.00,0.00,253.20,'2021-12-12 15:41:16','',''),(2262669,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-12 15:41:16','',''),(2262748,'1','149','770',328,'Retail Sale Id 1325859',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 15:44:19','',''),(2262749,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 15:44:19','',''),(2262770,'1','149','770',328,'Retail Sale Id 1325870',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 15:45:51','',''),(2262771,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 15:45:51','',''),(2262778,'1','149','770',328,'Retail Sale Id 1325876',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 15:46:57','',''),(2262779,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 15:46:57','',''),(2262798,'1','149','770',328,'Retail Sale Id 1325887',998.56,0.00,0.00,0.00,63.20,'2021-12-12 15:48:01','',''),(2262799,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 15:48:01','',''),(2262826,'1','149','770',328,'Retail Sale Id 1325899',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 15:49:45','',''),(2262827,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 15:49:45','',''),(2262843,'1','149','770',328,'Retail Sale Id 1325910',8001.12,0.00,0.00,0.00,506.40,'2021-12-12 15:50:43','',''),(2262844,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-12 15:50:43','',''),(2262863,'1','149','770',328,'Retail Sale Id 1325920',998.56,0.00,0.00,0.00,63.20,'2021-12-12 15:51:53','',''),(2262864,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 15:51:53','',''),(2262913,'1','149','770',328,'Retail Sale Id 1325945',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 15:56:22','',''),(2262914,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 15:56:22','',''),(2262949,'1','149','770',328,'Retail Sale Id 1325961',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 15:58:19','',''),(2262950,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 15:58:19','',''),(2263045,'1','149','770',328,'Retail Sale Id 1326014',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 16:05:55','',''),(2263046,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 16:05:55','',''),(2263063,'1','149','770',328,'Retail Sale Id 1326023',998.56,0.00,0.00,0.00,63.20,'2021-12-12 16:07:04','',''),(2263064,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 16:07:04','',''),(2263079,'1','149','770',328,'Retail Sale Id 1326033',1497.84,0.00,0.00,0.00,94.80,'2021-12-12 16:08:47','',''),(2263080,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 16:08:47','',''),(2263102,'1','149','770',328,'Retail Sale Id 1326043',650.96,0.00,0.00,0.00,41.20,'2021-12-12 16:09:54','',''),(2263103,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-12 16:09:54','',''),(2263132,'1','149','770',328,'Retail Sale Id 1326058',1497.84,0.00,0.00,0.00,94.80,'2021-12-12 16:12:12','',''),(2263133,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 16:12:12','',''),(2263144,'1','149','770',328,'Retail Sale Id 1326064',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 16:13:01','',''),(2263145,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 16:13:01','',''),(2263176,'1','149','770',328,'Retail Sale Id 1326075',7900.00,0.00,0.00,0.00,500.00,'2021-12-12 16:14:53','',''),(2263177,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:14:53','',''),(2263188,'1','149','770',328,'Retail Sale Id 1326082',1301.92,0.00,0.00,0.00,82.40,'2021-12-12 16:15:49','',''),(2263189,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 16:15:49','',''),(2263202,'1','149','770',328,'Retail Sale Id 1326088',2502.72,0.00,0.00,0.00,158.40,'2021-12-12 16:16:46','',''),(2263203,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-12 16:16:46','',''),(2263224,'1','149','770',328,'Retail Sale Id 1326099',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 16:17:49','',''),(2263225,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 16:17:49','',''),(2263260,'1','149','770',328,'Retail Sale Id 1326118',1200.80,0.00,0.00,0.00,76.00,'2021-12-12 16:20:14','',''),(2263261,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-12 16:20:14','',''),(2263282,'1','149','770',328,'Retail Sale Id 1326127',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 16:21:25','',''),(2263283,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 16:21:25','',''),(2263290,'1','149','770',328,'Retail Sale Id 1326132',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 16:22:12','',''),(2263291,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 16:22:12','',''),(2263322,'1','149','770',328,'Retail Sale Id 1326139',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 16:23:45','',''),(2263323,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 16:23:45','',''),(2263447,'1','149','770',328,'Retail Sale Id 1326184',3798.32,0.00,0.00,0.00,240.40,'2021-12-12 16:30:27','',''),(2263448,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 16:30:27','',''),(2263498,'1','149','770',328,'Retail Sale Id 1326212',2698.64,0.00,0.00,0.00,170.80,'2021-12-12 16:33:22','',''),(2263499,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.27,0.00,'2021-12-12 16:33:22','',''),(2263516,'1','149','770',328,'Retail Sale Id 1326225',998.56,0.00,0.00,0.00,63.20,'2021-12-12 16:34:22','',''),(2263517,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 16:34:22','',''),(2263548,'1','149','770',328,'Retail Sale Id 1326237',1301.92,0.00,0.00,0.00,82.40,'2021-12-12 16:35:33','',''),(2263549,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 16:35:33','',''),(2263586,'1','149','770',328,'Retail Sale Id 1326258',701.52,0.00,0.00,0.00,44.40,'2021-12-12 16:38:12','',''),(2263587,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-12 16:38:12','',''),(2263596,'1','149','770',328,'Retail Sale Id 1326263',2799.76,0.00,0.00,0.00,177.20,'2021-12-12 16:39:08','',''),(2263597,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.43,0.00,'2021-12-12 16:39:08','',''),(2263624,'1','149','770',328,'Retail Sale Id 1326276',1497.84,0.00,0.00,0.00,94.80,'2021-12-12 16:41:19','',''),(2263625,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 16:41:19','',''),(2263636,'1','149','770',328,'Retail Sale Id 1326280',998.56,0.00,0.00,0.00,63.20,'2021-12-12 16:42:16','',''),(2263637,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 16:42:16','',''),(2263709,'1','149','770',328,'Retail Sale Id 1326309',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 16:46:05','',''),(2263710,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 16:46:05','',''),(2263735,'1','149','770',328,'Retail Sale Id 1326322',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 16:47:27','',''),(2263736,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 16:47:27','',''),(2263765,'1','149','770',328,'Retail Sale Id 1326335',701.52,0.00,0.00,0.00,44.40,'2021-12-12 16:48:45','',''),(2263766,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-12 16:48:45','',''),(2263793,'1','149','770',328,'Retail Sale Id 1326347',1896.00,0.00,0.00,0.00,120.00,'2021-12-12 16:49:55','',''),(2263794,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 16:49:55','',''),(2263819,'1','149','770',328,'Retail Sale Id 1326359',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 16:51:10','',''),(2263820,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 16:51:10','',''),(2263845,'1','149','770',328,'Retail Sale Id 1326373',1497.84,0.00,0.00,0.00,94.80,'2021-12-12 16:52:56','',''),(2263846,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 16:52:56','',''),(2263868,'1','149','770',328,'Retail Sale Id 1326383',1301.92,0.00,0.00,0.00,82.40,'2021-12-12 16:54:06','',''),(2263869,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 16:54:06','',''),(2263967,'1','149','770',328,'Retail Sale Id 1326433',701.52,0.00,0.00,0.00,44.40,'2021-12-12 17:01:25','',''),(2263968,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-12 17:01:25','',''),(2264008,'1','149','770',328,'Retail Sale Id 1326447',998.56,0.00,0.00,0.00,63.20,'2021-12-12 17:03:16','',''),(2264009,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 17:03:16','',''),(2264034,'1','149','770',328,'Retail Sale Id 1326458',3002.00,0.00,0.00,0.00,190.00,'2021-12-12 17:05:32','',''),(2264035,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-12 17:05:32','',''),(2264055,'1','149','770',328,'Retail Sale Id 1326467',2502.72,0.00,0.00,0.00,158.40,'2021-12-12 17:07:09','',''),(2264056,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-12 17:07:09','',''),(2264063,'1','149','770',328,'Retail Sale Id 1326472',3197.92,0.00,0.00,0.00,202.40,'2021-12-12 17:08:08','',''),(2264064,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-12 17:08:08','',''),(2264079,'1','149','770',328,'Retail Sale Id 1326477',998.56,0.00,0.00,0.00,63.20,'2021-12-12 17:08:59','',''),(2264080,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 17:08:59','',''),(2264113,'1','149','770',328,'Retail Sale Id 1326493',1497.84,0.00,0.00,0.00,94.80,'2021-12-12 17:11:53','',''),(2264114,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-12 17:11:53','',''),(2264136,'1','149','770',328,'Retail Sale Id 1326498',1649.52,0.00,0.00,0.00,104.40,'2021-12-12 17:14:12','',''),(2264137,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.61,0.00,'2021-12-12 17:14:12','',''),(2264190,'1','149','770',328,'Retail Sale Id 1326523',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 17:20:40','',''),(2264191,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 17:20:40','',''),(2264222,'1','149','770',328,'Retail Sale Id 1326540',1997.12,0.00,0.00,0.00,126.40,'2021-12-12 17:24:35','',''),(2264223,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-12 17:24:35','',''),(2264254,'1','149','770',328,'Retail Sale Id 1326554',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 17:26:47','',''),(2264255,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 17:26:47','',''),(2264266,'1','149','770',328,'Retail Sale Id 1326559',998.56,0.00,0.00,0.00,63.20,'2021-12-12 17:27:44','',''),(2264267,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-12 17:27:44','',''),(2264310,'1','149','770',328,'Retail Sale Id 1326580',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 17:35:04','',''),(2264311,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 17:35:04','',''),(2264349,'1','149',NULL,328,'Purchased from AA RANO NIGERIA LIMITED',0.00,1551040.00,2620.00,0.00,0.00,'2021-12-12 17:40:25','',''),(2264361,'1','149',NULL,328,'Reception corrector for bridging 127190',0.00,0.00,0.00,2620.00,0.00,'2021-12-12 17:41:40','',''),(2264362,'1','149','770',328,'Received from bridging 127190',0.00,0.00,2620.00,0.00,0.00,'2021-12-12 17:41:40','',''),(2264375,'1','149','770',328,'Retail Sale Id 1326607',1902.32,0.00,0.00,0.00,120.40,'2021-12-12 17:43:37','',''),(2264376,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 17:43:37','',''),(2264459,'1','149','770',328,'Retail Sale Id 1326649',308542.40,0.00,0.00,0.00,19528.00,'2021-12-12 17:55:54','',''),(2264460,'1','149','770',328,'Retail sales',0.00,0.00,0.00,488.20,0.00,'2021-12-12 17:55:54','',''),(2267418,'1','149','770',328,'Retail Sale Id 1327748',7900.00,0.00,0.00,0.00,500.00,'2021-12-13 08:31:14','',''),(2267419,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 08:31:14','',''),(2267562,'1','149','770',328,'Retail Sale Id 1327823',3197.92,0.00,0.00,0.00,202.40,'2021-12-13 08:37:25','',''),(2267563,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 08:37:25','',''),(2267663,'1','149','770',328,'Retail Sale Id 1327869',7002.56,0.00,0.00,0.00,443.20,'2021-12-13 08:42:50','',''),(2267664,'1','149','770',328,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-13 08:42:50','',''),(2267692,'1','149','770',328,'Retail Sale Id 1327881',1200.80,0.00,0.00,0.00,76.00,'2021-12-13 08:44:13','',''),(2267693,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-13 08:44:13','',''),(2267754,'1','149','770',328,'Retail Sale Id 1327894',8001.12,0.00,0.00,0.00,506.40,'2021-12-13 08:46:16','',''),(2267755,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-13 08:46:16','',''),(2267781,'1','149','770',328,'Retail Sale Id 1327906',2502.72,0.00,0.00,0.00,158.40,'2021-12-13 08:47:43','',''),(2267782,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-13 08:47:43','',''),(2268151,'1','149','770',328,'Retail Sale Id 1328052',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 09:08:17','',''),(2268152,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 09:08:17','',''),(2268171,'1','149','770',328,'Retail Sale Id 1328063',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 09:09:22','',''),(2268172,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 09:09:22','',''),(2268280,'1','149','770',328,'Retail Sale Id 1328113',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 09:16:00','',''),(2268281,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 09:16:00','',''),(2268350,'1','149','770',328,'Retail Sale Id 1328144',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 09:19:34','',''),(2268351,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 09:19:34','',''),(2268408,'1','149','770',328,'Retail Sale Id 1328175',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 09:23:20','',''),(2268409,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 09:23:20','',''),(2268444,'1','149','770',328,'Retail Sale Id 1328192',998.56,0.00,0.00,0.00,63.20,'2021-12-13 09:25:08','',''),(2268445,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 09:25:08','',''),(2268470,'1','149','770',328,'Retail Sale Id 1328206',3197.92,0.00,0.00,0.00,202.40,'2021-12-13 09:26:45','',''),(2268471,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 09:26:45','',''),(2268506,'1','149','770',328,'Retail Sale Id 1328227',3002.00,0.00,0.00,0.00,190.00,'2021-12-13 09:28:16','',''),(2268507,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 09:28:16','',''),(2268632,'1','149','770',328,'Retail Sale Id 1328291',3002.00,0.00,0.00,0.00,190.00,'2021-12-13 09:38:11','',''),(2268633,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 09:38:11','',''),(2268668,'1','149','770',328,'Retail Sale Id 1328311',897.44,0.00,0.00,0.00,56.80,'2021-12-13 09:41:01','',''),(2268669,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.42,0.00,'2021-12-13 09:41:01','',''),(2268708,'1','149','770',328,'Retail Sale Id 1328333',998.56,0.00,0.00,0.00,63.20,'2021-12-13 09:44:09','',''),(2268709,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 09:44:09','',''),(2268730,'1','149','770',328,'Retail Sale Id 1328344',1301.92,0.00,0.00,0.00,82.40,'2021-12-13 09:45:46','',''),(2268731,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-13 09:45:46','',''),(2268751,'1','149','770',328,'Retail Sale Id 1328352',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 09:47:01','',''),(2268752,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 09:47:01','',''),(2268781,'1','149','770',328,'Retail Sale Id 1328370',998.56,0.00,0.00,0.00,63.20,'2021-12-13 09:48:17','',''),(2268782,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 09:48:17','',''),(2268823,'1','149','770',328,'Retail Sale Id 1328393',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 09:50:39','',''),(2268824,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 09:50:39','',''),(2268841,'1','149','770',328,'Retail Sale Id 1328401',1497.84,0.00,0.00,0.00,94.80,'2021-12-13 09:51:38','',''),(2268842,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 09:51:38','',''),(2268961,'1','149','770',328,'Retail Sale Id 1328454',1497.84,0.00,0.00,0.00,94.80,'2021-12-13 09:58:37','',''),(2268962,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 09:58:37','',''),(2269027,'1','149','770',328,'Retail Sale Id 1328482',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 10:02:35','',''),(2269028,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 10:02:35','',''),(2269105,'1','149','770',328,'Retail Sale Id 1328534',2546.96,0.00,0.00,0.00,161.20,'2021-12-13 10:09:04','',''),(2269106,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-13 10:09:04','',''),(2269125,'1','149','770',328,'Retail Sale Id 1328548',3197.92,0.00,0.00,0.00,202.40,'2021-12-13 10:10:16','',''),(2269126,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 10:10:16','',''),(2269151,'1','149','770',328,'Retail Sale Id 1328561',998.56,0.00,0.00,0.00,63.20,'2021-12-13 10:11:31','',''),(2269152,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 10:11:31','',''),(2269231,'1','149','770',328,'Retail Sale Id 1328608',802.64,0.00,0.00,0.00,50.80,'2021-12-13 10:18:04','',''),(2269232,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.27,0.00,'2021-12-13 10:18:04','',''),(2269241,'1','149','770',328,'Retail Sale Id 1328613',998.56,0.00,0.00,0.00,63.20,'2021-12-13 10:19:00','',''),(2269242,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 10:19:00','',''),(2269391,'1','149','770',328,'Retail Sale Id 1328685',998.56,0.00,0.00,0.00,63.20,'2021-12-13 10:30:09','',''),(2269392,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 10:30:09','',''),(2269417,'1','149','770',328,'Retail Sale Id 1328698',2597.52,0.00,0.00,0.00,164.40,'2021-12-13 10:31:33','',''),(2269418,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.11,0.00,'2021-12-13 10:31:33','',''),(2269435,'1','149','770',328,'Retail Sale Id 1328707',650.96,0.00,0.00,0.00,41.20,'2021-12-13 10:32:45','',''),(2269436,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-13 10:32:45','',''),(2269507,'1','149','770',328,'Retail Sale Id 1328735',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 10:36:19','',''),(2269508,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 10:36:19','',''),(2269546,'1','149','770',328,'Retail Sale Id 1328754',1497.84,0.00,0.00,0.00,94.80,'2021-12-13 10:38:56','',''),(2269547,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 10:38:56','',''),(2269598,'1','149','770',328,'Retail Sale Id 1328780',8001.12,0.00,0.00,0.00,506.40,'2021-12-13 10:41:41','',''),(2269599,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-13 10:41:41','',''),(2269680,'1','149','770',328,'Retail Sale Id 1328812',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 10:46:29','',''),(2269681,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 10:46:29','',''),(2269714,'1','149','770',328,'Retail Sale Id 1328834',1497.84,0.00,0.00,0.00,94.80,'2021-12-13 10:48:39','',''),(2269715,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 10:48:39','',''),(2269814,'1','149','770',328,'Retail Sale Id 1328887',897.44,0.00,0.00,0.00,56.80,'2021-12-13 10:53:13','',''),(2269815,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.42,0.00,'2021-12-13 10:53:13','',''),(2269828,'1','149','770',328,'Retail Sale Id 1328891',3197.92,0.00,0.00,0.00,202.40,'2021-12-13 10:54:40','',''),(2269829,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 10:54:40','',''),(2269939,'1','149','770',328,'Retail Sale Id 1328938',701.52,0.00,0.00,0.00,44.40,'2021-12-13 11:00:48','',''),(2269940,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-13 11:00:48','',''),(2270008,'1','149','770',328,'Retail Sale Id 1328976',8001.12,0.00,0.00,0.00,506.40,'2021-12-13 11:06:34','',''),(2270009,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-13 11:06:34','',''),(2270042,'1','149','770',328,'Retail Sale Id 1328992',3197.92,0.00,0.00,0.00,202.40,'2021-12-13 11:08:47','',''),(2270043,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 11:08:47','',''),(2270107,'1','149','770',328,'Retail Sale Id 1329022',1301.92,0.00,0.00,0.00,82.40,'2021-12-13 11:14:16','',''),(2270108,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-13 11:14:16','',''),(2270129,'1','149','770',328,'Retail Sale Id 1329037',1099.68,0.00,0.00,0.00,69.60,'2021-12-13 11:16:12','',''),(2270130,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.74,0.00,'2021-12-13 11:16:12','',''),(2270161,'1','149','770',328,'Retail Sale Id 1329053',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 11:17:44','',''),(2270162,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 11:17:44','',''),(2270283,'1','149','770',328,'Retail Sale Id 1329100',5201.36,0.00,0.00,0.00,329.20,'2021-12-13 11:26:29','',''),(2270284,'1','149','770',328,'Retail sales',0.00,0.00,0.00,8.23,0.00,'2021-12-13 11:26:29','',''),(2270296,'1','149','770',328,'Retail Sale Id 1329109',6402.16,0.00,0.00,0.00,405.20,'2021-12-13 11:27:44','',''),(2270297,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.13,0.00,'2021-12-13 11:27:44','',''),(2270314,'1','149','770',328,'Retail Sale Id 1329121',31600.00,0.00,0.00,0.00,2000.00,'2021-12-13 11:29:26','',''),(2270315,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 11:29:26','',''),(2270334,'1','149','770',328,'Retail Sale Id 1329130',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 11:30:40','',''),(2270335,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 11:30:40','',''),(2270366,'1','149','770',328,'Retail Sale Id 1329145',3197.92,0.00,0.00,0.00,202.40,'2021-12-13 11:33:14','',''),(2270367,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 11:33:14','',''),(2270384,'1','149','770',328,'Retail Sale Id 1329155',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 11:35:09','',''),(2270385,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 11:35:09','',''),(2270410,'1','149','770',328,'Retail Sale Id 1329165',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 11:37:23','',''),(2270411,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 11:37:23','',''),(2270441,'1','149','770',328,'Retail Sale Id 1329177',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 11:39:11','',''),(2270442,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 11:39:11','',''),(2270457,'1','149','770',328,'Retail Sale Id 1329190',3002.00,0.00,0.00,0.00,190.00,'2021-12-13 11:40:27','',''),(2270458,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 11:40:27','',''),(2270480,'1','149','770',328,'Retail Sale Id 1329202',1403.04,0.00,0.00,0.00,88.80,'2021-12-13 11:42:06','',''),(2270481,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.22,0.00,'2021-12-13 11:42:06','',''),(2270514,'1','149','770',328,'Retail Sale Id 1329219',998.56,0.00,0.00,0.00,63.20,'2021-12-13 11:44:33','',''),(2270515,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 11:44:33','',''),(2270554,'1','149','770',328,'Retail Sale Id 1329240',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 11:49:36','',''),(2270555,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 11:49:36','',''),(2270570,'1','149','770',328,'Retail Sale Id 1329249',1497.84,0.00,0.00,0.00,94.80,'2021-12-13 11:50:35','',''),(2270571,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 11:50:35','',''),(2270588,'1','149','770',328,'Retail Sale Id 1329258',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 11:52:16','',''),(2270589,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 11:52:16','',''),(2270623,'1','149','770',328,'Retail Sale Id 1329275',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 11:56:41','',''),(2270624,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 11:56:41','',''),(2270669,'1','149','770',328,'Retail Sale Id 1329299',2597.52,0.00,0.00,0.00,164.40,'2021-12-13 12:01:10','',''),(2270670,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.11,0.00,'2021-12-13 12:01:10','',''),(2270681,'1','149','770',328,'Retail Sale Id 1329306',1301.92,0.00,0.00,0.00,82.40,'2021-12-13 12:02:26','',''),(2270682,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-13 12:02:26','',''),(2270699,'1','149','770',328,'Retail Sale Id 1329316',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 12:03:35','',''),(2270700,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 12:03:35','',''),(2270721,'1','149','770',328,'Retail Sale Id 1329326',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 12:05:14','',''),(2270722,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 12:05:14','',''),(2270797,'1','149','770',328,'Retail Sale Id 1329372',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 12:12:07','',''),(2270798,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 12:12:07','',''),(2270817,'1','149','770',328,'Retail Sale Id 1329382',8001.12,0.00,0.00,0.00,506.40,'2021-12-13 12:13:38','',''),(2270818,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-13 12:13:38','',''),(2270962,'1','149','770',328,'Retail Sale Id 1329461',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 12:23:45','',''),(2270963,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 12:23:45','',''),(2270978,'1','149','770',328,'Retail Sale Id 1329468',701.52,0.00,0.00,0.00,44.40,'2021-12-13 12:24:59','',''),(2270979,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-13 12:24:59','',''),(2271000,'1','149','770',328,'Retail Sale Id 1329479',4000.56,0.00,0.00,0.00,253.20,'2021-12-13 12:26:36','',''),(2271001,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-13 12:26:36','',''),(2271028,'1','149','770',328,'Retail Sale Id 1329496',998.56,0.00,0.00,0.00,63.20,'2021-12-13 12:28:44','',''),(2271029,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 12:28:44','',''),(2271285,'1','149','770',328,'Retail Sale Id 1329643',3002.00,0.00,0.00,0.00,190.00,'2021-12-13 12:47:04','',''),(2271286,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-13 12:47:04','',''),(2271323,'1','149','770',328,'Retail Sale Id 1329662',998.56,0.00,0.00,0.00,63.20,'2021-12-13 12:49:51','',''),(2271324,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 12:49:51','',''),(2271342,'1','149','770',328,'Retail Sale Id 1329669',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 12:51:27','',''),(2271343,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 12:51:27','',''),(2271406,'1','149','770',328,'Retail Sale Id 1329706',1301.92,0.00,0.00,0.00,82.40,'2021-12-13 12:54:48','',''),(2271407,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-13 12:54:48','',''),(2271461,'1','149','770',328,'Retail Sale Id 1329730',6496.96,0.00,0.00,0.00,411.20,'2021-12-13 12:58:01','',''),(2271462,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.28,0.00,'2021-12-13 12:58:01','',''),(2271647,'1','149','770',328,'Retail Sale Id 1329817',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 13:08:55','',''),(2271648,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 13:08:55','',''),(2271669,'1','149','770',328,'Retail Sale Id 1329827',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 13:10:26','',''),(2271670,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 13:10:26','',''),(2271679,'1','149','770',328,'Retail Sale Id 1329831',7900.00,0.00,0.00,0.00,500.00,'2021-12-13 13:11:31','',''),(2271680,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 13:11:31','',''),(2271752,'1','149','770',328,'Retail Sale Id 1329864',2546.96,0.00,0.00,0.00,161.20,'2021-12-13 13:15:43','',''),(2271753,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-13 13:15:43','',''),(2271766,'1','149','770',328,'Retail Sale Id 1329872',1497.84,0.00,0.00,0.00,94.80,'2021-12-13 13:16:33','',''),(2271767,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 13:16:33','',''),(2271810,'1','149','770',328,'Retail Sale Id 1329889',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 13:17:42','',''),(2271811,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 13:17:42','',''),(2271818,'1','149','770',328,'Retail Sale Id 1329895',7900.00,0.00,0.00,0.00,500.00,'2021-12-13 13:18:44','',''),(2271819,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 13:18:44','',''),(2271984,'1','149','770',328,'Retail Sale Id 1329949',4999.12,0.00,0.00,0.00,316.40,'2021-12-13 13:26:39','',''),(2271985,'1','149','770',328,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-13 13:26:39','',''),(2272043,'1','149','770',328,'Retail Sale Id 1329974',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 13:30:12','',''),(2272044,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 13:30:12','',''),(2272055,'1','149','770',328,'Retail Sale Id 1329983',1497.84,0.00,0.00,0.00,94.80,'2021-12-13 13:31:12','',''),(2272056,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 13:31:12','',''),(2274837,'1','149','770',328,'Retail Sale Id 1331349',802.64,0.00,0.00,0.00,50.80,'2021-12-13 16:05:01','',''),(2274838,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.27,0.00,'2021-12-13 16:05:01','',''),(2274867,'1','149','770',328,'Retail Sale Id 1331365',1301.92,0.00,0.00,0.00,82.40,'2021-12-13 16:07:18','',''),(2274868,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-13 16:07:18','',''),(2275060,'1','149','770',328,'Retail Sale Id 1331463',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 16:17:11','',''),(2275061,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 16:17:11','',''),(2275081,'1','149','770',328,'Retail Sale Id 1331472',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 16:18:29','',''),(2275082,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 16:18:29','',''),(2275478,'1','149','770',328,'Retail Sale Id 1331675',3197.92,0.00,0.00,0.00,202.40,'2021-12-13 16:40:05','',''),(2275479,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 16:40:05','',''),(2275536,'1','149','770',328,'Retail Sale Id 1331702',8001.12,0.00,0.00,0.00,506.40,'2021-12-13 16:43:27','',''),(2275537,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-13 16:43:27','',''),(2275556,'1','149','770',328,'Retail Sale Id 1331718',1301.92,0.00,0.00,0.00,82.40,'2021-12-13 16:44:19','',''),(2275557,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-13 16:44:19','',''),(2275582,'1','149','770',328,'Retail Sale Id 1331732',3798.32,0.00,0.00,0.00,240.40,'2021-12-13 16:47:04','',''),(2275583,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 16:47:04','',''),(2275598,'1','149','770',328,'Retail Sale Id 1331742',1497.84,0.00,0.00,0.00,94.80,'2021-12-13 16:49:07','',''),(2275599,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 16:49:08','',''),(2275621,'1','149','770',328,'Retail Sale Id 1331753',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 16:50:18','',''),(2275622,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 16:50:18','',''),(2275644,'1','149','770',328,'Retail Sale Id 1331764',998.56,0.00,0.00,0.00,63.20,'2021-12-13 16:51:44','',''),(2275645,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 16:51:44','',''),(2275668,'1','149','770',328,'Retail Sale Id 1331776',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 16:53:01','',''),(2275669,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 16:53:01','',''),(2275691,'1','149','770',328,'Retail Sale Id 1331786',8001.12,0.00,0.00,0.00,506.40,'2021-12-13 16:54:36','',''),(2275692,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-13 16:54:36','',''),(2275715,'1','149','770',328,'Retail Sale Id 1331797',998.56,0.00,0.00,0.00,63.20,'2021-12-13 16:55:48','',''),(2275716,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 16:55:48','',''),(2275743,'1','149','770',328,'Retail Sale Id 1331813',3197.92,0.00,0.00,0.00,202.40,'2021-12-13 16:58:10','',''),(2275744,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 16:58:10','',''),(2275903,'1','149','770',328,'Retail Sale Id 1331881',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 17:10:28','',''),(2275904,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 17:10:28','',''),(2275923,'1','149','770',328,'Retail Sale Id 1331899',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 17:13:10','',''),(2275924,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 17:13:10','',''),(2275937,'1','149','770',328,'Retail Sale Id 1331909',8001.12,0.00,0.00,0.00,506.40,'2021-12-13 17:14:55','',''),(2275938,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-13 17:14:55','',''),(2275953,'1','149','770',328,'Retail Sale Id 1331915',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 17:16:30','',''),(2275954,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 17:16:30','',''),(2275965,'1','149','770',328,'Retail Sale Id 1331920',1997.12,0.00,0.00,0.00,126.40,'2021-12-13 17:17:55','',''),(2275966,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 17:17:55','',''),(2275975,'1','149','770',328,'Retail Sale Id 1331925',8001.12,0.00,0.00,0.00,506.40,'2021-12-13 17:19:32','',''),(2275976,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-13 17:19:32','',''),(2275985,'1','149','770',328,'Retail Sale Id 1331931',4000.56,0.00,0.00,0.00,253.20,'2021-12-13 17:20:40','',''),(2275986,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-13 17:20:40','',''),(2275994,'1','149','770',328,'Retail Sale Id 1331935',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 17:21:56','',''),(2275995,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 17:21:56','',''),(2276006,'1','149','770',328,'Retail Sale Id 1331941',650.96,0.00,0.00,0.00,41.20,'2021-12-13 17:23:11','',''),(2276007,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-13 17:23:11','',''),(2276014,'1','149','770',328,'Retail Sale Id 1331946',897.44,0.00,0.00,0.00,56.80,'2021-12-13 17:24:08','',''),(2276015,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.42,0.00,'2021-12-13 17:24:08','',''),(2276036,'1','149','770',328,'Retail Sale Id 1331956',2597.52,0.00,0.00,0.00,164.40,'2021-12-13 17:26:34','',''),(2276037,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.11,0.00,'2021-12-13 17:26:34','',''),(2276046,'1','149','770',328,'Retail Sale Id 1331963',1902.32,0.00,0.00,0.00,120.40,'2021-12-13 17:27:59','',''),(2276047,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 17:27:59','',''),(2276303,'1','149','770',328,'Retail Sale Id 1332052',300351.68,0.00,0.00,0.00,19009.60,'2021-12-13 18:08:56','',''),(2276304,'1','149','770',328,'Retail sales',0.00,0.00,0.00,475.24,0.00,'2021-12-13 18:08:56','',''),(2277609,'1','149','770',328,'Retail Sale Id 1332395',3800.72,0.00,0.00,0.00,148.08,'2021-12-14 06:50:38','',''),(2277610,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-14 06:50:38','',''),(2277640,'1','149','770',328,'Retail Sale Id 1332406',1503.04,0.00,0.00,0.00,58.56,'2021-12-14 06:51:59','',''),(2277641,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-14 06:51:59','',''),(2277684,'1','149','770',328,'Retail Sale Id 1332420',2002.00,0.00,0.00,0.00,78.00,'2021-12-14 06:54:56','',''),(2277685,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-14 06:54:56','',''),(2277732,'1','149','770',328,'Retail Sale Id 1332446',1897.28,0.00,0.00,0.00,73.92,'2021-12-14 06:59:24','',''),(2277733,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-14 06:59:24','',''),(2277750,'1','149','770',328,'Retail Sale Id 1332455',702.24,0.00,0.00,0.00,27.36,'2021-12-14 07:00:39','',''),(2277751,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.14,0.00,'2021-12-14 07:00:39','',''),(2277770,'1','149','770',328,'Retail Sale Id 1332465',899.36,0.00,0.00,0.00,35.04,'2021-12-14 07:02:33','',''),(2277771,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.46,0.00,'2021-12-14 07:02:33','',''),(2277794,'1','149','770',328,'Retail Sale Id 1332477',1503.04,0.00,0.00,0.00,58.56,'2021-12-14 07:04:07','',''),(2277795,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-14 07:04:07','',''),(2277816,'1','149','770',328,'Retail Sale Id 1332488',1897.28,0.00,0.00,0.00,73.92,'2021-12-14 07:05:50','',''),(2277817,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-14 07:05:50','',''),(2277952,'1','149','770',328,'Retail Sale Id 1332565',997.92,0.00,0.00,0.00,38.88,'2021-12-14 07:15:29','',''),(2277953,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-14 07:15:29','',''),(2277974,'1','149','770',328,'Retail Sale Id 1332574',3197.04,0.00,0.00,0.00,124.56,'2021-12-14 07:16:47','',''),(2277975,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.19,0.00,'2021-12-14 07:16:47','',''),(2278037,'1','149','770',328,'Retail Sale Id 1332602',8001.84,0.00,0.00,0.00,311.76,'2021-12-14 07:21:03','',''),(2278038,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.99,0.00,'2021-12-14 07:21:03','',''),(2278087,'1','149','770',328,'Retail Sale Id 1332632',616.00,0.00,0.00,0.00,24.00,'2021-12-14 07:23:30','',''),(2278088,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-14 07:23:30','',''),(2278174,'1','149','770',328,'Retail Sale Id 1332675',1897.28,0.00,0.00,0.00,73.92,'2021-12-14 07:28:52','',''),(2278175,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-14 07:28:52','',''),(2278188,'1','149','770',328,'Retail Sale Id 1332682',997.92,0.00,0.00,0.00,38.88,'2021-12-14 07:29:58','',''),(2278189,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-14 07:29:58','',''),(2278261,'1','149','770',328,'Retail Sale Id 1332713',1848.00,0.00,0.00,0.00,72.00,'2021-12-14 07:34:17','',''),(2278262,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 07:34:17','',''),(2278287,'1','149','770',328,'Retail Sale Id 1332731',3702.16,0.00,0.00,0.00,144.24,'2021-12-14 07:35:55','',''),(2278288,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 07:35:55','',''),(2278311,'1','149','770',328,'Retail Sale Id 1332743',2999.92,0.00,0.00,0.00,116.88,'2021-12-14 07:37:03','',''),(2278312,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-14 07:37:03','',''),(2278331,'1','149','770',328,'Retail Sale Id 1332756',2002.00,0.00,0.00,0.00,78.00,'2021-12-14 07:38:01','',''),(2278332,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-14 07:38:02','',''),(2278357,'1','149','770',328,'Retail Sale Id 1332770',15400.00,0.00,0.00,0.00,600.00,'2021-12-14 07:39:07','',''),(2278358,'1','149','770',328,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-14 07:39:07','',''),(2278416,'1','149','770',328,'Retail Sale Id 1332796',3702.16,0.00,0.00,0.00,144.24,'2021-12-14 07:42:03','',''),(2278417,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 07:42:03','',''),(2278570,'1','149','770',328,'Retail Sale Id 1332988',2500.96,0.00,0.00,0.00,97.44,'2021-12-14 07:52:52','',''),(2278571,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-14 07:52:52','',''),(2278596,'1','149','770',328,'Retail Sale Id 1333001',997.92,0.00,0.00,0.00,38.88,'2021-12-14 07:54:09','',''),(2278597,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-14 07:54:09','',''),(2278626,'1','149','770',328,'Retail Sale Id 1333019',3197.04,0.00,0.00,0.00,124.56,'2021-12-14 07:56:01','',''),(2278629,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.19,0.00,'2021-12-14 07:56:01','',''),(2278662,'1','149','770',328,'Retail Sale Id 1333036',5901.28,0.00,0.00,0.00,229.92,'2021-12-14 07:57:35','',''),(2278663,'1','149','770',328,'Retail sales',0.00,0.00,0.00,9.58,0.00,'2021-12-14 07:57:35','',''),(2278744,'1','149','770',328,'Retail Sale Id 1333080',1897.28,0.00,0.00,0.00,73.92,'2021-12-14 08:01:46','',''),(2278745,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-14 08:01:46','',''),(2278862,'1','149','770',328,'Retail Sale Id 1333125',2500.96,0.00,0.00,0.00,97.44,'2021-12-14 08:07:11','',''),(2278863,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-14 08:07:11','',''),(2278898,'1','149','770',328,'Retail Sale Id 1333143',3702.16,0.00,0.00,0.00,144.24,'2021-12-14 08:09:09','',''),(2278899,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 08:09:09','',''),(2279199,'1','149','770',328,'Retail Sale Id 1333320',1299.76,0.00,0.00,0.00,50.64,'2021-12-14 08:26:18','',''),(2279200,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.11,0.00,'2021-12-14 08:26:18','',''),(2279221,'1','149','770',328,'Retail Sale Id 1333331',8001.84,0.00,0.00,0.00,311.76,'2021-12-14 08:27:45','',''),(2279222,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.99,0.00,'2021-12-14 08:27:45','',''),(2279273,'1','149','770',328,'Retail Sale Id 1333355',6498.80,0.00,0.00,0.00,253.20,'2021-12-14 08:30:36','',''),(2279274,'1','149','770',328,'Retail sales',0.00,0.00,0.00,10.55,0.00,'2021-12-14 08:30:36','',''),(2279333,'1','149','770',328,'Retail Sale Id 1333388',14198.80,0.00,0.00,0.00,553.20,'2021-12-14 08:33:48','',''),(2279334,'1','149','770',328,'Retail sales',0.00,0.00,0.00,23.05,0.00,'2021-12-14 08:33:48','',''),(2279387,'1','149','770',328,'Retail Sale Id 1333417',1897.28,0.00,0.00,0.00,73.92,'2021-12-14 08:36:26','',''),(2279388,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-14 08:36:26','',''),(2279558,'1','149','770',328,'Retail Sale Id 1333501',2002.00,0.00,0.00,0.00,78.00,'2021-12-14 08:45:04','',''),(2279559,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-14 08:45:04','',''),(2279617,'1','149','770',328,'Retail Sale Id 1333544',2500.96,0.00,0.00,0.00,97.44,'2021-12-14 08:48:04','',''),(2279618,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-14 08:48:04','',''),(2280003,'1','149','770',328,'Retail Sale Id 1333685',8001.84,0.00,0.00,0.00,311.76,'2021-12-14 09:05:23','',''),(2280004,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.99,0.00,'2021-12-14 09:05:23','',''),(2280436,'1','149','770',328,'Retail Sale Id 1333869',3197.04,0.00,0.00,0.00,124.56,'2021-12-14 09:25:04','',''),(2280439,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.19,0.00,'2021-12-14 09:25:04','',''),(2280496,'1','149','770',328,'Retail Sale Id 1333901',1897.28,0.00,0.00,0.00,73.92,'2021-12-14 09:28:18','',''),(2280497,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-14 09:28:18','',''),(2280516,'1','149','770',328,'Retail Sale Id 1333913',2500.96,0.00,0.00,0.00,97.44,'2021-12-14 09:29:35','',''),(2280517,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-14 09:29:35','',''),(2280548,'1','149','770',328,'Retail Sale Id 1333930',1897.28,0.00,0.00,0.00,73.92,'2021-12-14 09:31:01','',''),(2280549,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-14 09:31:01','',''),(2280568,'1','149','770',328,'Retail Sale Id 1333939',3197.04,0.00,0.00,0.00,124.56,'2021-12-14 09:32:12','',''),(2280569,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.19,0.00,'2021-12-14 09:32:12','',''),(2280622,'1','149','770',328,'Retail Sale Id 1333971',2002.00,0.00,0.00,0.00,78.00,'2021-12-14 09:35:19','',''),(2280623,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-14 09:35:19','',''),(2280683,'1','149','770',328,'Retail Sale Id 1334002',997.92,0.00,0.00,0.00,38.88,'2021-12-14 09:39:36','',''),(2280684,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-14 09:39:36','',''),(2280707,'1','149','770',328,'Retail Sale Id 1334014',8001.84,0.00,0.00,0.00,311.76,'2021-12-14 09:41:00','',''),(2280708,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.99,0.00,'2021-12-14 09:41:00','',''),(2280745,'1','149','770',328,'Retail Sale Id 1334028',2999.92,0.00,0.00,0.00,116.88,'2021-12-14 09:42:19','',''),(2280746,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-14 09:42:19','',''),(2280762,'1','149','770',328,'Retail Sale Id 1334036',997.92,0.00,0.00,0.00,38.88,'2021-12-14 09:43:31','',''),(2280763,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-14 09:43:31','',''),(2280794,'1','149','770',328,'Retail Sale Id 1334052',1503.04,0.00,0.00,0.00,58.56,'2021-12-14 09:45:05','',''),(2280795,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-14 09:45:05','',''),(2280822,'1','149','770',328,'Retail Sale Id 1334066',3197.04,0.00,0.00,0.00,124.56,'2021-12-14 09:46:46','',''),(2280823,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.19,0.00,'2021-12-14 09:46:46','',''),(2280921,'1','149','770',328,'Retail Sale Id 1334121',2500.96,0.00,0.00,0.00,97.44,'2021-12-14 09:53:57','',''),(2280922,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-14 09:53:57','',''),(2280967,'1','149','770',328,'Retail Sale Id 1334148',1897.28,0.00,0.00,0.00,73.92,'2021-12-14 09:56:50','',''),(2280968,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-14 09:56:50','',''),(2281015,'1','149','770',328,'Retail Sale Id 1334173',2999.92,0.00,0.00,0.00,116.88,'2021-12-14 09:59:41','',''),(2281016,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-14 09:59:41','',''),(2281043,'1','149','770',328,'Retail Sale Id 1334185',2002.00,0.00,0.00,0.00,78.00,'2021-12-14 10:00:54','',''),(2281044,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-14 10:00:54','',''),(2281169,'1','149','770',328,'Retail Sale Id 1334252',2002.00,0.00,0.00,0.00,78.00,'2021-12-14 10:09:05','',''),(2281170,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-14 10:09:05','',''),(2281200,'1','149','770',328,'Retail Sale Id 1334269',1798.72,0.00,0.00,0.00,70.08,'2021-12-14 10:10:31','',''),(2281201,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.92,0.00,'2021-12-14 10:10:31','',''),(2281279,'1','149','770',328,'Retail Sale Id 1334306',3197.04,0.00,0.00,0.00,124.56,'2021-12-14 10:14:06','',''),(2281280,'1','149','770',328,'Retail sales',0.00,0.00,0.00,5.19,0.00,'2021-12-14 10:14:06','',''),(2281297,'1','149','770',328,'Retail Sale Id 1334318',8001.84,0.00,0.00,0.00,311.76,'2021-12-14 10:15:13','',''),(2281298,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.99,0.00,'2021-12-14 10:15:13','',''),(2281361,'1','149','770',328,'Retail Sale Id 1334342',2500.96,0.00,0.00,0.00,97.44,'2021-12-14 10:17:43','',''),(2281362,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-14 10:17:43','',''),(2281414,'1','149','770',328,'Retail Sale Id 1334364',30800.00,0.00,0.00,0.00,1200.00,'2021-12-14 10:19:33','',''),(2281415,'1','149','770',328,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-14 10:19:33','',''),(2281587,'1','149','770',328,'Retail Sale Id 1334451',2999.92,0.00,0.00,0.00,116.88,'2021-12-14 10:28:18','',''),(2281588,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-14 10:28:18','',''),(2281660,'1','149','770',328,'Retail Sale Id 1334539',8001.84,0.00,0.00,0.00,311.76,'2021-12-14 10:33:01','',''),(2281661,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.99,0.00,'2021-12-14 10:33:01','',''),(2281708,'1','149','770',328,'Retail Sale Id 1334569',3800.72,0.00,0.00,0.00,148.08,'2021-12-14 10:35:01','',''),(2281709,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-14 10:35:01','',''),(2281728,'1','149','770',328,'Retail Sale Id 1334578',3800.72,0.00,0.00,0.00,148.08,'2021-12-14 10:36:12','',''),(2281729,'1','149','770',328,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-14 10:36:12','',''),(2281756,'1','149','770',328,'Retail Sale Id 1334598',1503.04,0.00,0.00,0.00,58.56,'2021-12-14 10:37:59','',''),(2281757,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-14 10:37:59','',''),(2281808,'1','149','770',328,'Retail Sale Id 1334622',1897.28,0.00,0.00,0.00,73.92,'2021-12-14 10:41:01','',''),(2281809,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-14 10:41:01','',''),(2281836,'1','149','770',328,'Retail Sale Id 1334636',702.24,0.00,0.00,0.00,27.36,'2021-12-14 10:42:10','',''),(2281837,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.14,0.00,'2021-12-14 10:42:10','',''),(2281862,'1','149','770',328,'Retail Sale Id 1334652',1503.04,0.00,0.00,0.00,58.56,'2021-12-14 10:43:32','',''),(2281863,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-14 10:43:32','',''),(2281896,'1','149','770',328,'Retail Sale Id 1334667',7502.88,0.00,0.00,0.00,292.32,'2021-12-14 10:44:52','',''),(2281897,'1','149','770',328,'Retail sales',0.00,0.00,0.00,12.18,0.00,'2021-12-14 10:44:52','',''),(2281919,'1','149','770',328,'Retail Sale Id 1334679',652.96,0.00,0.00,0.00,25.44,'2021-12-14 10:46:54','',''),(2281920,'1','149','770',328,'Retail sales',0.00,0.00,0.00,1.06,0.00,'2021-12-14 10:46:54','',''),(2282040,'1','149','770',328,'Retail Sale Id 1334747',1503.04,0.00,0.00,0.00,58.56,'2021-12-14 10:54:41','',''),(2282041,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-14 10:54:42','',''),(2282170,'1','149','770',328,'Retail Sale Id 1334813',2999.92,0.00,0.00,0.00,116.88,'2021-12-14 11:03:19','',''),(2282171,'1','149','770',328,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-14 11:03:19','',''),(2282267,'1','149','770',328,'Retail Sale Id 1334866',1897.28,0.00,0.00,0.00,73.92,'2021-12-14 11:08:40','',''),(2282268,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-14 11:08:40','',''),(2282356,'1','149','770',328,'Retail Sale Id 1334909',1700.16,0.00,0.00,0.00,66.24,'2021-12-14 11:12:59','',''),(2282357,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.76,0.00,'2021-12-14 11:12:59','',''),(2282375,'1','149','770',328,'Retail Sale Id 1334919',1897.28,0.00,0.00,0.00,73.92,'2021-12-14 11:14:05','',''),(2282376,'1','149','770',328,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-14 11:14:05','',''),(2282395,'1','149','770',328,'Retail Sale Id 1334927',1299.76,0.00,0.00,0.00,50.64,'2021-12-14 11:15:11','',''),(2282396,'1','149','770',328,'Retail sales',0.00,0.00,0.00,2.11,0.00,'2021-12-14 11:15:11','',''),(2282737,'1','149','770',328,'Retail Sale Id 1335583',997.92,0.00,0.00,1.62,38.88,'2021-12-14 13:00:02','',''),(2282809,'1','149','770',328,'Retail Sale Id 1335650',3197.04,0.00,0.00,5.19,124.56,'2021-12-14 13:09:04','',''),(2282907,'1','149','770',328,'Retail Sale Id 1335737',8001.84,0.00,0.00,12.99,311.76,'2021-12-14 13:22:50','',''),(2283085,'1','149','770',328,'Retail Sale Id 1335866',1503.04,0.00,0.00,2.44,58.56,'2021-12-14 13:42:28','',''),(2283110,'1','149','770',328,'Retail Sale Id 1335874',702.24,0.00,0.00,1.14,27.36,'2021-12-14 13:43:40','',''),(2283120,'1','149','770',328,'Retail Sale Id 1335883',6196.96,0.00,0.00,10.06,241.44,'2021-12-14 13:45:45','',''),(2283146,'1','149','770',328,'Retail Sale Id 1335910',652.96,0.00,0.00,1.06,25.44,'2021-12-14 13:50:18','',''),(2283158,'1','149','770',328,'Retail Sale Id 1335922',1848.00,0.00,0.00,3.00,72.00,'2021-12-14 13:51:52','',''),(2283180,'1','149','770',328,'Retail Sale Id 1335936',7700.00,0.00,0.00,12.50,300.00,'2021-12-14 13:54:15','',''),(2283237,'1','149','770',328,'Retail Sale Id 1335952',1848.00,0.00,0.00,3.00,72.00,'2021-12-14 13:57:27','',''),(2283404,'1','149','770',328,'Retail Sale Id 1336062',2999.92,0.00,0.00,4.87,116.88,'2021-12-14 14:13:44','',''),(2283423,'1','149','770',328,'Retail Sale Id 1336084',1299.76,0.00,0.00,2.11,50.64,'2021-12-14 14:16:23','',''),(2283434,'1','149','770',328,'Retail Sale Id 1336102',1897.28,0.00,0.00,3.08,73.92,'2021-12-14 14:17:53','',''),(2283538,'1','149','770',328,'Retail Sale Id 1336179',1848.00,0.00,0.00,3.00,72.00,'2021-12-14 14:29:02','',''),(2283569,'1','149','770',328,'Retail Sale Id 1336196',2002.00,0.00,0.00,3.25,78.00,'2021-12-14 14:31:09','',''),(2283595,'1','149','770',328,'Retail Sale Id 1336211',1503.04,0.00,0.00,2.44,58.56,'2021-12-14 14:33:03','',''),(2283727,'1','149','770',328,'Retail Sale Id 1336315',1503.04,0.00,0.00,2.44,58.56,'2021-12-14 14:49:43','',''),(2283765,'1','149','770',328,'Retail Sale Id 1336335',997.92,0.00,0.00,1.62,38.88,'2021-12-14 14:52:43','',''),(2283772,'1','149','770',328,'Retail Sale Id 1336343',1299.76,0.00,0.00,2.11,50.64,'2021-12-14 14:53:54','',''),(2283784,'1','149','770',328,'Retail Sale Id 1336353',3702.16,0.00,0.00,6.01,144.24,'2021-12-14 14:55:54','',''),(2283800,'1','149','770',328,'Retail Sale Id 1336364',5999.84,0.00,0.00,9.74,233.76,'2021-12-14 14:57:45','',''),(2283820,'1','149','770',328,'Retail Sale Id 1336378',3098.48,0.00,0.00,5.03,120.72,'2021-12-14 15:00:08','',''),(2283827,'1','149','770',328,'Retail Sale Id 1336386',3098.48,0.00,0.00,5.03,120.72,'2021-12-14 15:01:37','',''),(2283838,'1','149','770',328,'Retail Sale Id 1336397',2500.96,0.00,0.00,4.06,97.44,'2021-12-14 15:03:52','',''),(2283853,'1','149','770',328,'Retail Sale Id 1336413',3997.84,0.00,0.00,6.49,155.76,'2021-12-14 15:06:54','',''),(2283897,'1','149','770',328,'Retail Sale Id 1336430',1848.00,0.00,0.00,3.00,72.00,'2021-12-14 15:14:30','',''),(2283937,'1','149','770',328,'Retail Sale Id 1336503',5999.84,0.00,0.00,9.74,233.76,'2021-12-14 15:22:11','',''),(2284032,'1','149','770',328,'Retail Sale Id 1336558',1503.04,0.00,0.00,2.44,58.56,'2021-12-14 15:30:35','',''),(2284089,'1','149','770',328,'Retail Sale Id 1336603',5001.92,0.00,0.00,8.12,194.88,'2021-12-14 15:37:01','',''),(2284110,'1','149','770',328,'Retail Sale Id 1336614',1398.32,0.00,0.00,2.27,54.48,'2021-12-14 15:38:57','',''),(2284168,'1','149','770',328,'Retail Sale Id 1336634',2802.80,0.00,0.00,4.55,109.20,'2021-12-14 15:41:27','',''),(2284194,'1','149','770',328,'Retail Sale Id 1336646',997.92,0.00,0.00,1.62,38.88,'2021-12-14 15:42:48','',''),(2284234,'1','149','770',328,'Retail Sale Id 1336673',1250.48,0.00,0.00,2.03,48.72,'2021-12-14 15:47:06','',''),(2284293,'1','149','770',328,'Retail Sale Id 1336715',2500.96,0.00,0.00,4.06,97.44,'2021-12-14 15:51:09','',''),(2284299,'1','149','770',328,'Retail Sale Id 1336721',7700.00,0.00,0.00,12.50,300.00,'2021-12-14 15:52:04','',''),(2284314,'1','149','770',328,'Retail Sale Id 1336736',2500.96,0.00,0.00,4.06,97.44,'2021-12-14 15:53:39','',''),(2284321,'1','149','770',328,'Retail Sale Id 1336742',2002.00,0.00,0.00,3.25,78.00,'2021-12-14 15:54:44','',''),(2284336,'1','149','770',328,'Retail Sale Id 1336756',1250.48,0.00,0.00,2.03,48.72,'2021-12-14 15:56:48','',''),(2284352,'1','149','770',328,'Retail Sale Id 1336765',3098.48,0.00,0.00,5.03,120.72,'2021-12-14 15:57:48','',''),(2284375,'1','149','770',328,'Retail Sale Id 1336778',702.24,0.00,0.00,1.14,27.36,'2021-12-14 15:59:57','',''),(2284395,'1','149','770',328,'Retail Sale Id 1336790',2500.96,0.00,0.00,4.06,97.44,'2021-12-14 16:01:14','',''),(2284424,'1','149','770',328,'Retail Sale Id 1336816',652.96,0.00,0.00,1.06,25.44,'2021-12-14 16:03:41','',''),(2284439,'1','149','770',328,'Retail Sale Id 1336828',652.96,0.00,0.00,1.06,25.44,'2021-12-14 16:05:25','',''),(2284458,'1','149','770',328,'Retail Sale Id 1336846',6196.96,0.00,0.00,10.06,241.44,'2021-12-14 16:06:48','',''),(2284492,'1','149','770',328,'Retail Sale Id 1336880',1897.28,0.00,0.00,3.08,73.92,'2021-12-14 16:10:50','',''),(2284524,'1','149','770',328,'Retail Sale Id 1336917',1299.76,0.00,0.00,2.11,50.64,'2021-12-14 16:15:36','',''),(2284552,'1','149','770',328,'Retail Sale Id 1336945',702.24,0.00,0.00,1.14,27.36,'2021-12-14 16:18:48','',''),(2284655,'1','149','770',328,'Retail Sale Id 1337033',2999.92,0.00,0.00,4.87,116.88,'2021-12-14 16:27:20','',''),(2284666,'1','149','770',328,'Retail Sale Id 1337044',2002.00,0.00,0.00,3.25,78.00,'2021-12-14 16:28:13','',''),(2284696,'1','149','770',328,'Retail Sale Id 1337060',3098.48,0.00,0.00,5.03,120.72,'2021-12-14 16:29:34','',''),(2284711,'1','149','770',328,'Retail Sale Id 1337074',1897.28,0.00,0.00,3.08,73.92,'2021-12-14 16:30:56','',''),(2284727,'1','149','770',328,'Retail Sale Id 1337090',3498.88,0.00,0.00,5.68,136.32,'2021-12-14 16:32:55','',''),(2284742,'1','149','770',328,'Retail Sale Id 1337108',1299.76,0.00,0.00,2.11,50.64,'2021-12-14 16:34:00','',''),(2284757,'1','149','770',328,'Retail Sale Id 1337124',3800.72,0.00,0.00,6.17,148.08,'2021-12-14 16:35:29','',''),(2284799,'1','149','770',328,'Retail Sale Id 1337151',3800.72,0.00,0.00,6.17,148.08,'2021-12-14 16:38:36','',''),(2284814,'1','149','770',328,'Retail Sale Id 1337164',997.92,0.00,0.00,1.62,38.88,'2021-12-14 16:40:07','',''),(2284820,'1','149','770',328,'Retail Sale Id 1337172',1503.04,0.00,0.00,2.44,58.56,'2021-12-14 16:41:16','',''),(2284865,'1','149','770',328,'Retail Sale Id 1337184',8001.84,0.00,0.00,12.99,311.76,'2021-12-14 16:42:35','',''),(2284877,'1','149','770',328,'Retail Sale Id 1337196',2002.00,0.00,0.00,3.25,78.00,'2021-12-14 16:43:48','',''),(2284932,'1','149','770',328,'Retail Sale Id 1337238',3197.04,0.00,0.00,5.19,124.56,'2021-12-14 16:49:13','',''),(2284946,'1','149','770',328,'Retail Sale Id 1337248',1897.28,0.00,0.00,3.08,73.92,'2021-12-14 16:51:11','',''),(2284975,'1','149','770',328,'Retail Sale Id 1337260',652.96,0.00,0.00,1.06,25.44,'2021-12-14 16:53:15','',''),(2284991,'1','149','770',328,'Retail Sale Id 1337274',1700.16,0.00,0.00,2.76,66.24,'2021-12-14 16:54:38','',''),(2285004,'1','149','770',328,'Retail Sale Id 1337285',3800.72,0.00,0.00,6.17,148.08,'2021-12-14 16:55:46','',''),(2285010,'1','149','770',328,'Retail Sale Id 1337292',1503.04,0.00,0.00,2.44,58.56,'2021-12-14 16:57:02','',''),(2285021,'1','149','770',328,'Retail Sale Id 1337303',1897.28,0.00,0.00,3.08,73.92,'2021-12-14 16:59:03','',''),(2285036,'1','149','770',328,'Retail Sale Id 1337314',1601.60,0.00,0.00,2.60,62.40,'2021-12-14 17:00:32','',''),(2285046,'1','149','770',328,'Retail Sale Id 1337322',2002.00,0.00,0.00,3.25,78.00,'2021-12-14 17:01:40','',''),(2285068,'1','149','770',328,'Retail Sale Id 1337352',702.24,0.00,0.00,1.14,27.36,'2021-12-14 17:04:34','',''),(2285098,'1','149','770',328,'Retail Sale Id 1337382',2500.96,0.00,0.00,4.06,97.44,'2021-12-14 17:08:11','',''),(2285108,'1','149','770',328,'Retail Sale Id 1337393',1897.28,0.00,0.00,3.08,73.92,'2021-12-14 17:09:25','',''),(2285133,'1','149','770',328,'Retail Sale Id 1337411',7798.56,0.00,0.00,12.66,303.84,'2021-12-14 17:13:44','',''),(2285141,'1','149','770',328,'Retail Sale Id 1337418',1503.04,0.00,0.00,2.44,58.56,'2021-12-14 17:15:11','',''),(2285145,'1','149','770',328,'Retail Sale Id 1337423',702.24,0.00,0.00,1.14,27.36,'2021-12-14 17:16:51','',''),(2285166,'1','149','770',328,'Retail Sale Id 1337439',1503.04,0.00,0.00,2.44,58.56,'2021-12-14 17:18:44','',''),(2285167,'1','149','770',328,'Retail Sale Id 1337439',6997.76,0.00,0.00,11.36,272.64,'2021-12-14 17:18:44','',''),(2285185,'1','149','770',328,'Retail Sale Id 1337452',702.24,0.00,0.00,1.14,27.36,'2021-12-14 17:21:50','',''),(2285190,'1','149','770',328,'Retail Sale Id 1337457',7700.00,0.00,0.00,12.50,300.00,'2021-12-14 17:23:01','',''),(2285194,'1','149','770',328,'Retail Sale Id 1337460',1897.28,0.00,0.00,3.08,73.92,'2021-12-14 17:24:31','',''),(2285206,'1','149','770',328,'Retail Sale Id 1337474',10200.96,0.00,0.00,16.56,397.44,'2021-12-14 17:28:07','',''),(2285214,'1','149','770',328,'Retail Sale Id 1337483',2500.96,0.00,0.00,4.06,97.44,'2021-12-14 17:29:17','',''),(2285238,'1','149','770',328,'Retail Sale Id 1337500',3800.72,0.00,0.00,6.17,148.08,'2021-12-14 17:33:39',''