-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_148
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_148`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_148` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_148`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3214 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2597,20009,'',0,'22','1','148','PURCHASES','','2020-08-10 20:38:39',5,0.00,0.00,'','479','2020-08-10 20:38:39','479',0,1),(2598,400090,'',0,'24','1','148','PURCHASES','','2020-08-10 20:38:53',5,0.00,0.00,'','479','2020-08-10 20:38:53','479',0,1),(2599,20017,'',0,'20','1','148','SALES','','2020-08-10 20:39:59',5,0.00,0.00,'','479','2020-08-10 20:39:59','479',0,1),(2600,40016,'',0,'6.1','1','148','CASH','','2020-08-10 20:40:15',5,0.00,0.00,'','479','2020-08-10 20:40:15','479',0,1),(2601,400091,'',0,'24','1','148','SALARIES & WAGES','','2020-08-10 20:40:31',5,0.00,0.00,'','479','2020-08-10 20:40:31','479',0,1),(2602,400223,'',0,'2','1','148','ZBN(POS):1015965368','','2020-08-10 20:41:11',5,0.00,0.00,'','479','2020-08-10 20:41:11','479',0,1),(2603,400224,'',0,'2','1','148','ZB(E-BILL)1015372548','','2020-08-10 20:41:45',5,0.00,0.00,'','479','2020-08-10 20:41:45','479',0,1),(2659,400110,'',0,'24','1','148','OPERATIONAL LOSS','ALL LOSSES DURING SALES/RECEPTION.','2020-08-13 14:03:26',5,0.00,0.00,'','479','2020-08-13 14:03:26','479',0,1),(2907,400324,'',0,'2','1','148','DANKANO-EBILLS(ZNB:1014717618)','','2020-10-29 14:00:06',5,0.00,0.00,'','489','2020-10-29 14:00:06','489',0,1),(3211,400490,'',0,'2','1','148','FID POS COLLECTION-5620141491','','2021-02-26 16:04:01',5,0.00,0.00,'','489','2021-02-26 16:04:01','489',0,1),(3212,400491,'',0,'2','1','148','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:09:42',5,0.00,0.00,'','792','2023-02-20 14:09:42','792',0,0),(3213,400492,'',0,'2','1','148','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:23:21',5,0.00,0.00,'2023-03-15','792','2023-03-17 12:25:57','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4245 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1590,'','1','148','ALL DEALERS','MUSA','08148063533','ussy090@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-12 13:10:34',5,'508','2020-08-12 13:10:34','508'),(1608,'','1','148','OPERATIONAL LOSS','HAFIZ NURA GAYA','08069129774','hgaya@aaranonigeria.com','KANO','KANO','AA RANO HOUSE HOTORO KANO.','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 14:02:40',5,'479','2020-08-13 14:02:40','479'),(4118,'','1','148','AGK','08060715046','08060715046','adamadamsalisu@gmail.com','NASARAWA','NASARAWA','UNGWAN BIRI','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-12-30 15:33:51',5,'508','2021-12-30 15:33:51','508'),(4146,'','1','148','sb ruga','08148204209','08148204209','adamadamsalisu@gmail.com','NASARAWA','NASARAWA','aso ruga','Nigeria',250.00,0.00,0.00,'0000-00-00','2022-01-06 10:07:57',5,'508','2022-01-06 10:07:57','508'),(4147,'','1','148','prince best oil and gas','07061584877','07061584877','adamadamsalisu@gmail.com','NASARAWA','NASARAWA','prince best oil gas company','Nigeria',150.00,0.00,0.00,'0000-00-00','2022-01-06 10:47:58',5,'508','2022-01-06 10:47:58','508'),(4175,'','1','148','ANDY GASS','ANDY GASS','08060348948','adamadamsalisu@gmail.com','KADUNA','KADUNA','NUMBER ONE P0ST 0FFICE 9','Nigeria',1500.00,0.00,0.00,'0000-00-00','2022-01-16 07:20:24',5,'508','2022-01-16 07:20:24','508'),(4241,'','1','148','ILIYA','07031356383','07031356383','adamadamsalisu@gmail.com','KADUNA','KADUNA','KADUNA KAFANCHA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-27 07:20:32',5,'508','2022-01-27 07:20:32','508'),(4242,'','1','148','treshould','07031335839','08060715046','adamadamsalisu@gmail.com','NASARAWA','NASARAWA','treshuld','Nigeria',850.00,0.00,0.00,'0000-00-00','2022-02-02 18:26:15',5,'508','2022-02-02 18:26:15','508'),(4243,'','1','148','DAN GWARI','08162295591','08162295591','adamadamsalisu@gmail.com','NASARAWA','NASARAWA','DAn gwari','Nigeria',150.00,0.00,0.00,'0000-00-00','2022-02-23 08:12:30',5,'508','2022-02-23 08:12:30','508'),(4244,'','1','148','mado','07046523894','07046523894','adamadamsalisu@gmail.com','NASARAWA','NASARAWA','ado','Nigeria',150.00,0.00,0.00,'0000-00-00','2022-03-01 08:35:49',5,'508','2022-03-01 08:35:49','508');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16360 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','148',16359,'769',3220.33,3220.00,'2021-09-08','new dipping','2021-09-08 18:11:21','483','483',2021,'483','2021-09-08 18:11:21',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2184 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','148','769',2140,'5','LPG NOZZLE ',789184.68,'LPG DISPENSER','',NULL,NULL,'',5,'2021-09-21 14:15:32','483'),('1','148','769',2183,'5','LPG NOZZLE 2',824289.76,'LPG DISPENSER','',NULL,NULL,'',5,'2021-09-21 14:16:58','483');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258007 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','148',146992,'DAILY SHIFT','2020-08-01','2020-08-01 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-12 13:17:43','508','2020-08-12 13:19:22',10,0),('1','148',147019,'DAILY SHIFT','2020-08-02','2020-08-02 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-12 14:08:03','508','2020-08-12 14:08:36',10,0),('1','148',147073,'DAILY SHIFT','2020-08-05','2020-08-05 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-12 16:09:56','508','2020-08-12 16:10:44',10,0),('1','148',147086,'DAILY SHIFT','2020-08-06','2020-08-06 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-12 17:04:04','508','2020-08-12 17:07:26',10,0),('1','148',147105,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-13 10:03:00','508','2020-08-13 10:03:27',10,0),('1','148',147169,'DAILY SHIFT','2020-08-13','2020-08-13 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-13 10:29:33','508','2020-08-13 10:30:14',10,0),('1','148',147187,'DAILY SHIFT','2020-08-07','2020-08-07 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-13 10:59:17','508','2020-08-13 10:59:55',10,0),('1','148',147213,'DAILY SHIFT','2020-08-08','2020-08-08 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-13 12:14:14','508','2020-08-13 12:14:45',10,0),('1','148',147225,'DAILY SHIFT','2020-08-09','2020-08-09 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-13 12:48:07','508','2020-08-13 12:49:02',10,0),('1','148',147243,'DAILY SHIFT','2020-08-13','2020-08-13 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-13 13:39:31','508','2020-08-13 13:40:09',10,0),('1','148',147264,'DAILY SHIFT','2020-08-11','2020-08-11 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-13 14:35:28','508','2020-08-13 14:35:49',10,0),('1','148',147267,'DAILY SHIFT','2020-08-11','2020-08-11 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-13 14:50:36','508','2020-08-13 14:50:57',10,0),('1','148',147271,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-13 15:00:07','508','2020-08-13 15:00:58',10,0),('1','148',147286,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-13 15:54:02','508','2020-08-13 15:54:25',10,0),('1','148',147333,'DAILY SHIFT','2020-08-13','2020-08-13 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-14 10:20:09','508','2020-08-14 10:20:40',10,0),('1','148',147465,'DAILY SHIFT','2020-08-14','2020-08-14 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-15 09:49:23','508','2020-08-15 09:50:00',10,0),('1','148',147592,'DAILY SHIFT','2020-08-15','2020-08-15 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-16 10:01:01','508','2020-08-16 10:01:28',10,0),('1','148',147712,'DAILY SHIFT','2020-08-17','2020-08-17 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-17 09:17:34','508','2020-08-17 09:18:16',10,0),('1','148',147909,'DAILY SHIFT','2020-08-17','2020-08-17 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-18 12:02:56','508','2020-08-18 12:03:35',10,0),('1','148',148011,'DAILY SHIFT','2020-08-18','2020-08-18 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-19 09:24:59','508','2020-08-19 09:25:38',10,0),('1','148',148156,'DAILY SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-20 09:48:51','508','2020-08-20 09:49:20',10,0),('1','148',148305,'DAILY SHIFT','2020-08-21','2020-08-21 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-21 09:30:45','508','2020-08-21 09:31:23',10,0),('1','148',148458,'DAILY SHIFT','2020-08-22','2020-08-22 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-22 09:39:40','508','2020-08-22 09:40:29',10,0),('1','148',148588,'DAILY SHIFT','2020-08-23','2020-08-23 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-23 11:44:56','508','2020-08-23 11:45:59',10,0),('1','148',148700,'DAILY SHIFT','2020-08-24','2020-08-24 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-24 09:37:29','508','2020-08-24 09:37:54',10,0),('1','148',148786,'DAILY SHIFT','2020-08-24','2020-08-24 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-24 16:44:07','508','2020-08-24 16:44:35',10,0),('1','148',148948,'DAILY SHIFT','2020-08-25','2020-08-25 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-25 17:48:29','508','2020-08-25 17:48:53',10,0),('1','148',149200,'DAILY SHIFT','2020-08-27','2020-08-27 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-27 12:12:09','508','2020-08-27 12:12:45',10,0),('1','148',149360,'DAILY SHIFT','2020-08-27','2020-08-27 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-28 11:57:10','508','2020-08-28 11:58:47',10,0),('1','148',149515,'DAILY SHIFT','2020-08-29','2020-08-29 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-30 08:50:31','508','2020-08-30 08:50:59',10,0),('1','148',149624,'DAILY SHIFT','2020-08-30','2020-08-30 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-30 09:47:28','508','2020-08-30 09:48:08',10,0),('1','148',149630,'DAYLLY SHIFT','2020-08-30','2020-08-30 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-30 10:20:09','508','2020-08-30 10:21:23',10,0),('1','148',149831,'DAILY SHIFT','2020-08-31','2020-08-31 00:00:00',NULL,'508',0.00,0.00,'508','2020-08-31 17:50:14','508','2020-08-31 17:50:42',10,0),('1','148',149995,'DAILY SHIFT','2020-09-01','2020-09-01 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-02 18:55:56','508','2020-09-02 18:58:16',10,0),('1','148',150145,'DAILY SHIFT','2020-09-02','2020-09-02 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-02 19:26:10','508','2020-09-02 19:27:12',10,0),('1','148',150364,'DAILY SHIFT','2020-09-03','2020-09-03 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-04 19:01:26','508','2020-09-04 19:01:51',10,0),('1','148',150546,'DAYLLY SHIFT','2020-09-04','2020-09-04 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-05 18:56:28','508','2020-09-05 18:56:50',10,0),('1','148',150709,'DAYLLY SHIFT','2020-09-05','2020-09-05 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-05 19:03:16','508','2020-09-05 19:03:50',10,0),('1','148',150820,'DAYLLY SHIFT','2020-09-06','2020-09-06 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-06 17:08:50','508','2020-09-06 17:09:32',10,0),('1','148',150992,'DAYLLY SHIFT','2020-09-07','2020-09-07 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-07 19:14:40','508','2020-09-07 19:15:14',10,0),('1','148',151147,'DAYLLY SHIFT','2020-09-08','2020-09-08 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-09 18:39:36','508','2020-09-09 18:39:57',10,0),('1','148',151271,'DAYLLY SHIFT','2020-09-09','2020-09-09 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-09 18:44:48','508','2020-09-09 18:51:25',10,0),('1','148',151426,'DAYLLY SHIFT','2020-09-10','2020-09-10 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-11 19:19:45','508','2020-09-11 19:23:38',10,0),('1','148',151584,'DAYLLY SHIFT','2020-09-11','2020-09-11 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-11 19:40:40','508','2020-09-11 19:41:04',10,0),('1','148',151698,'DAYLLY SHIFT','2020-09-12','2020-09-12 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-12 19:41:53','508','2020-09-12 19:44:35',10,0),('1','148',151699,'DAYLLY SHIFT','2020-09-12','2020-09-12 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-13 19:52:03','508','2020-09-13 19:52:29',10,0),('1','148',151854,'DAYLLY SHIFT','2020-09-14','2020-09-14 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-14 09:41:10','508','2020-09-14 09:41:37',10,0),('1','148',152006,'DAYLLY SHIFT','2020-09-14','2020-09-14 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-14 19:33:13','508','2020-09-14 19:36:19',10,0),('1','148',152161,'DAYLLY SHIFT','2020-09-15','2020-09-15 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-15 19:23:28','508','2020-09-15 19:23:56',10,0),('1','148',152321,'DAYLLY SHIFT','2020-09-16','2020-09-16 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-16 19:18:26','508','2020-09-16 19:18:48',10,0),('1','148',152475,'DAYLLY SHIFT','2020-09-17','2020-09-17 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-17 19:13:19','508','2020-09-17 19:13:46',10,0),('1','148',152642,'DAYLLY SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-19 08:19:09','508','2020-09-19 08:19:32',10,0),('1','148',152758,'DAYLLY SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-19 19:09:27','508','2020-09-19 19:09:54',10,0),('1','148',152893,'DAYLLY SHIFT','2020-09-20','2020-09-20 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-20 20:14:24','508','2020-09-20 20:14:45',10,0),('1','148',153083,'DAYLLY SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-21 20:08:43','508','2020-09-21 20:09:05',10,0),('1','148',153272,'DAYLLY SHIFT','2020-09-22','2020-09-22 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-22 19:57:29','508','2020-09-22 19:57:55',10,0),('1','148',153470,'DAYLLY SHIFT','2020-09-23','2020-09-23 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-23 19:12:12','508','2020-09-23 19:12:42',10,0),('1','148',153624,'DAYLLY SHIFT','2020-09-24','2020-09-24 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-25 15:55:30','508','2020-09-25 15:55:59',10,0),('1','148',153770,'DAYLLY SHIFT','2020-09-25','2020-09-25 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-25 16:01:52','508','2020-09-25 16:02:59',10,0),('1','148',153977,'DAYLLY SHIFT','2020-09-27','2020-09-27 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-27 12:15:47','508','2020-09-27 12:16:29',10,0),('1','148',154053,'DAYLLY SHIFT','2020-09-27','2020-09-27 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-27 19:27:14','508','2020-09-27 19:27:35',10,0),('1','148',154270,'DAYLLY SHIFT','2020-09-29','2020-09-29 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-29 08:45:09','508','2020-09-29 08:45:30',10,0),('1','148',154401,'DAYLLY SHIFT','2020-09-29','2020-09-29 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-29 18:07:30','508','2020-09-29 18:07:50',10,0),('1','148',154436,'DAYLLY SHIFT','2020-09-30','2020-09-30 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-30 15:56:53','508','2020-09-30 15:57:10',10,0),('1','148',154575,'DAYLLY SHIFT','2020-09-30','2020-09-30 00:00:00',NULL,'508',0.00,0.00,'508','2020-09-30 18:55:20','508','2020-09-30 18:55:43',10,0),('1','148',154703,'DAYLLY SHIFT','2020-10-01','2020-10-01 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-01 16:42:17','508','2020-10-01 16:42:34',10,0),('1','148',154875,'DAYLLY SHIFT','2020-10-02','2020-10-02 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-03 09:58:14','508','2020-10-03 09:58:42',10,0),('1','148',154919,'DAYLLY SHIFT','2020-10-03','2020-10-03 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-03 19:08:44','508','2020-10-03 19:09:06',10,0),('1','148',155127,'DAYLLY SHIFT','2020-10-04','2020-10-04 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-04 18:52:55','508','2020-10-04 18:54:28',10,0),('1','148',155303,'DAYLLY SHIFT','2020-10-05','2020-10-05 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-05 20:25:03','508','2020-10-05 20:25:25',10,0),('1','148',155460,'DAYLLY SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-07 20:08:26','508','2020-10-07 20:12:52',10,0),('1','148',155641,'DAYLLY SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-07 20:28:48','508','2020-10-07 20:30:06',10,0),('1','148',155776,'DAYLLY SHIFT','2020-10-08','2020-10-08 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-08 19:33:22','508','2020-10-08 19:33:48',10,0),('1','148',155905,'DAYLLY SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-10 20:07:22','508','2020-10-10 20:26:55',10,0),('1','148',156086,'DAYLLY SHIFT','2020-10-10','2020-10-10 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-11 17:30:36','508','2020-10-11 17:32:28',10,0),('1','148',156190,'DAYLLY SHIFT','2020-10-11','2020-10-11 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-11 18:29:57','508','2020-10-11 18:30:15',10,0),('1','148',156197,'DAYLLY SHIFT','2020-10-11','2020-10-11 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-11 18:37:48','508','2020-10-11 18:38:14',10,0),('1','148',156411,'DAYLLY SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-13 17:27:39','508','2020-10-13 17:28:02',10,0),('1','148',156552,'DAYLLY SHIFT','2020-10-13','2020-10-13 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-14 18:13:44','508','2020-10-14 18:14:05',10,0),('1','148',157079,'DAYLLY SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-16 19:09:59','508','2020-10-16 19:10:33',10,0),('1','148',157082,'DAYLLY SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-17 19:45:57','508','2020-10-17 19:46:26',10,0),('1','148',157275,'DAYLLY SHIFT','2020-10-17','2020-10-17 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-18 19:11:16','508','2020-10-18 19:11:32',10,0),('1','148',157447,'DAYLLY SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-18 19:15:27','508','2020-10-18 19:15:47',10,0),('1','148',157665,'DAYLLY SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-20 19:32:06','508','2020-10-20 19:37:16',10,0),('1','148',157818,'DAYLLY SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-21 18:44:26','508','2020-10-21 18:50:58',10,0),('1','148',157947,'DAYLLY SHIFT','2020-10-21','2020-10-21 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-22 18:42:16','508','2020-10-22 18:42:41',10,0),('1','148',158081,'DAYLLY SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-23 18:31:21','508','2020-10-23 18:32:04',10,0),('1','148',158258,'DAYLLY SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-23 18:37:31','508','2020-10-23 18:37:56',10,0),('1','148',158259,'DAYLLY SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-25 13:23:15','508','2020-10-25 13:23:43',10,0),('1','148',158566,'DAYLLY SHIFT','2020-10-25','2020-10-25 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-25 18:17:50','508','2020-10-25 18:21:00',10,0),('1','148',158751,'DAYLLY SHIFT','2020-10-26','2020-10-26 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-27 08:45:34','508','2020-10-27 08:50:09',10,0),('1','148',158926,'DAYLLY SHIFT','2020-10-27','2020-10-27 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-27 17:55:13','508','2020-10-27 17:55:42',10,0),('1','148',159110,'DAYLLY SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-28 18:20:39','508','2020-10-28 18:21:29',10,0),('1','148',159277,'DAYLLY SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-29 19:52:06','508','2020-10-29 19:52:26',10,0),('1','148',159450,'DAYLLY SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'508',0.00,0.00,'508','2020-10-30 18:47:37','508','2020-10-30 18:48:05',10,0),('1','148',159737,'DAYLLY SHIFT','2020-10-31','2020-10-31 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-01 20:48:44','508','2020-11-01 20:49:18',10,0),('1','148',159739,'DAYLLY SHIFT','2020-10-31','2020-10-31 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-01 21:06:39','508','2020-11-01 21:08:39',10,0),('1','148',159740,'DAYLLY SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-01 21:34:39','508','2020-11-01 21:34:59',10,0),('1','148',159936,'DAYLLY SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-02 19:08:03','508','2020-11-02 19:08:39',10,0),('1','148',160105,'DAYLLY SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-03 16:42:45','508','2020-11-03 16:43:03',10,0),('1','148',160309,'DAYLLY SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-04 19:46:21','508','2020-11-04 19:46:48',10,0),('1','148',160453,'DAYLLY SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-05 18:56:18','508','2020-11-05 18:56:41',10,0),('1','148',160595,'DAYLLY SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-06 19:08:44','508','2020-11-06 19:09:07',10,0),('1','148',160597,'DAYLLY SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-06 19:20:48','508','2020-11-06 19:21:12',10,0),('1','148',160741,'DAYLLY SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-07 18:21:38','508','2020-11-07 18:21:59',10,0),('1','148',160856,'DAYLLY SHIFT','2020-11-08','2020-11-08 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-08 14:51:53','508','2020-11-08 14:52:16',10,0),('1','148',161077,'DAYLLY SHIFT','2020-11-09','2020-11-09 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-09 17:14:34','508','2020-11-09 17:15:11',10,0),('1','148',161267,'DAYLLY SHIFT','2020-11-10','2020-11-10 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-10 18:58:04','508','2020-11-10 18:58:57',10,0),('1','148',161447,'DAYLLY SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-11 17:54:31','508','2020-11-11 17:54:55',10,0),('1','148',161653,'DAYLLY SHIFT','2020-11-12','2020-11-12 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-12 18:11:28','508','2020-11-12 18:11:53',10,0),('1','148',161872,'DAYLLY SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-13 18:56:35','508','2020-11-13 18:57:01',10,0),('1','148',162038,'DAYLLY SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-14 18:35:41','508','2020-11-14 18:36:11',10,0),('1','148',162240,'DAYLLY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-15 18:59:31','508','2020-11-15 19:00:28',10,0),('1','148',162455,'DAYLLY SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-16 19:20:05','508','2020-11-16 19:30:03',10,0),('1','148',162635,'DAYLLY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-17 18:03:49','508','2020-11-17 18:15:22',10,0),('1','148',162801,'DAYLLY SHIFT','2020-11-18','2020-11-18 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-18 17:51:34','508','2020-11-18 17:51:53',10,0),('1','148',163002,'DAYLLY SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-19 18:18:54','508','2020-11-19 18:19:51',10,0),('1','148',163196,'DAYLLY SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-20 18:08:41','508','2020-11-20 18:15:22',10,0),('1','148',163376,'DAYLLY SHIFT','2020-11-21','2020-11-21 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-21 19:34:30','508','2020-11-21 19:35:17',10,0),('1','148',163533,'DAYLLY SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-22 17:31:32','508','2020-11-22 17:32:25',10,0),('1','148',163739,'DAYLLY SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-23 18:52:38','508','2020-11-23 18:53:16',10,0),('1','148',163801,'DAYLLY SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-24 18:08:13','508','2020-11-24 18:08:40',10,0),('1','148',164075,'DAYLLY SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-25 18:10:29','508','2020-11-25 18:10:55',10,0),('1','148',164255,'DAYLLY SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-26 18:56:11','508','2020-11-26 18:56:31',10,0),('1','148',164445,'DAYLLY SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-27 19:36:48','508','2020-11-27 19:39:56',10,0),('1','148',164601,'DAYLLY SHIFT','2020-11-28','2020-11-28 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-28 18:55:02','508','2020-11-28 18:56:25',10,0),('1','148',164753,'DAYLLY SHIFT','2020-11-29','2020-11-29 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-29 18:39:13','508','2020-11-29 18:39:36',10,0),('1','148',164964,'DAYLLY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-30 19:34:50','508','2020-11-30 19:35:16',10,0),('1','148',164967,'DAYLLY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-30 19:50:28','508','2020-11-30 19:50:48',10,0),('1','148',164968,'DAYLLY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'508',0.00,0.00,'508','2020-11-30 20:01:46','508','2020-11-30 20:02:26',10,0),('1','148',165144,'DAYLLY SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-02 07:28:57','508','2020-12-02 07:32:10',10,0),('1','148',165310,'DAYLLY SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-02 20:27:57','508','2020-12-02 20:28:33',10,0),('1','148',165447,'DAYLLY SHIFT','2020-12-03','2020-12-03 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-03 21:03:14','508','2020-12-03 21:04:20',10,0),('1','148',165620,'DAYLLY SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-04 19:52:08','508','2020-12-04 19:53:00',10,0),('1','148',165793,'DAYLLY SHIFT','2020-12-05','2020-12-05 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-05 19:24:27','508','2020-12-05 19:24:56',10,0),('1','148',165968,'DAYLLY SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-07 08:14:50','508','2020-12-07 08:15:09',10,0),('1','148',166141,'DAYLLY SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-07 19:27:36','508','2020-12-07 19:29:16',10,0),('1','148',166332,'DAYLLY SHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-09 07:43:49','508','2020-12-09 07:44:21',10,0),('1','148',166340,'DAYLLY SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-09 07:54:23','508','2020-12-09 07:54:40',10,0),('1','148',166496,'DAYLLY SHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-09 18:48:44','508','2020-12-09 18:49:03',10,0),('1','148',166693,'DAYLLY SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-10 19:05:58','508','2020-12-10 19:06:26',10,0),('1','148',166900,'DAYLLY SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-12 07:19:37','508','2020-12-12 07:20:10',10,0),('1','148',166902,'DAYLLY SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-12 07:48:01','508','2020-12-12 07:53:56',10,0),('1','148',167379,'DAYLLY SHIFT','2020-12-12','2020-12-12 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-14 19:43:08','508','2020-12-14 19:44:15',10,0),('1','148',167381,'DAYLLY SHIFT','2020-12-13','2020-12-13 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-14 19:50:07','508','2020-12-14 19:50:43',10,0),('1','148',167382,'DAYLLY SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-14 20:02:59','508','2020-12-14 20:03:22',10,0),('1','148',167567,'DAYLLY SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-15 18:38:43','508','2020-12-15 18:39:02',10,0),('1','148',167747,'DAYLLY SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-17 05:54:15','508','2020-12-17 05:54:32',10,0),('1','148',167916,'DAYLLY SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-17 19:11:17','508','2020-12-17 19:11:36',10,0),('1','148',168114,'DAYLLY SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-18 18:36:23','508','2020-12-18 18:36:47',10,0),('1','148',168286,'DAYLLY SHIFT','2020-12-19','2020-12-19 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-19 19:04:27','508','2020-12-19 19:04:51',10,0),('1','148',168406,'DAYLLY SHIFT','2020-12-20','2020-12-20 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-21 20:10:31','508','2020-12-21 20:11:07',10,0),('1','148',168621,'DAYLLY SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-21 20:16:16','508','2020-12-21 20:16:57',10,0),('1','148',168769,'DAYLLY SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-22 18:31:44','508','2020-12-23 19:30:21',10,0),('1','148',168937,'DAYLLY SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-23 19:47:33','508','2020-12-23 19:47:53',10,0),('1','148',169107,'DAYLLY SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-24 19:36:49','508','2020-12-24 19:37:09',10,0),('1','148',169128,'DAYLLY SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-25 07:53:16','508','2020-12-25 07:53:36',10,0),('1','148',169267,'DAYLLY SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-25 18:54:31','508','2020-12-25 18:55:36',10,0),('1','148',169449,'DAYLLY SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-27 11:26:00','508','2020-12-27 11:27:44',10,0),('1','148',169570,'DAYLLY SHIFT','2020-12-27','2020-12-27 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-27 18:38:49','508','2020-12-27 18:39:13',10,0),('1','148',169769,'DAYLLY SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-29 07:59:41','508','2020-12-29 08:00:00',10,0),('1','148',169921,'DAYLLY SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-29 18:35:44','508','2020-12-29 18:36:22',10,0),('1','148',170141,'DAYLLY SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-31 19:21:09','508','2020-12-31 19:21:32',10,0),('1','148',170333,'DAYLLY SHIFT','2020-12-31','2020-12-31 00:00:00',NULL,'508',0.00,0.00,'508','2020-12-31 19:29:04','508','2020-12-31 19:29:26',10,0),('1','148',170617,'DAYLLY SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-02 15:53:00','508','2021-01-02 15:53:24',10,0),('1','148',170622,'DAYLLY SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-02 16:10:46','508','2021-01-02 16:12:17',10,0),('1','148',170626,'DAYLLY SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-02 16:27:40','508','2021-01-02 16:28:04',10,0),('1','148',170760,'DAYLLY SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-03 14:36:16','508','2021-01-03 14:36:51',10,0),('1','148',170849,'DAYLLY SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-05 09:28:59','508','2021-01-05 09:29:17',10,0),('1','148',171054,'DAYLLY SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-05 09:32:59','508','2021-01-05 09:33:22',10,0),('1','148',171254,'DAYLLY SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-06 10:15:59','508','2021-01-06 10:16:45',10,0),('1','148',171371,'DAYLLY SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-06 19:31:17','508','2021-01-06 19:31:39',10,0),('1','148',171623,'DAYLLY SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-08 09:39:37','508','2021-01-08 09:40:47',10,0),('1','148',171828,'DAYLLY SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-09 10:02:00','508','2021-01-09 10:03:15',10,0),('1','148',172090,'DAYLLY SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-10 21:11:36','508','2021-01-10 21:11:56',10,0),('1','148',172092,'DAYLLY SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-10 21:31:48','508','2021-01-10 21:32:23',10,0),('1','148',172339,'DAYLLY SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-12 10:47:40','508','2021-01-12 10:47:56',10,0),('1','148',172526,'DAYLLY SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-13 07:05:12','508','2021-01-13 07:05:39',10,0),('1','148',172710,'DAYLLY SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-14 06:59:44','508','2021-01-14 07:00:06',10,0),('1','148',172874,'DAYLLY SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-15 19:34:48','508','2021-01-15 19:36:21',10,0),('1','148',173049,'DAYLLY SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-16 10:11:26','508','2021-01-16 10:11:44',10,0),('1','148',173275,'DAYLLY SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-17 11:24:45','508','2021-01-17 11:25:21',10,0),('1','148',173378,'DAYLLY SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-17 20:03:22','508','2021-01-17 20:04:31',10,0),('1','148',173679,'DAYLLY SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-19 12:03:31','508','2021-01-19 12:03:48',10,0),('1','148',173744,'DAYLLY SHIFT','2021-01-19','2021-01-19 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-19 18:58:48','508','2021-01-19 18:59:05',10,0),('1','148',174022,'DAYLLY SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-21 11:32:40','508','2021-01-21 11:33:07',10,0),('1','148',174121,'DAYLLY SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-21 18:49:55','508','2021-01-21 18:50:13',10,0),('1','148',174315,'DAYLLY SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-22 19:04:11','508','2021-01-22 19:04:31',10,0),('1','148',174483,'DAYLLY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-23 19:15:47','508','2021-01-23 19:16:05',10,0),('1','148',174640,'DAYLLY SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-24 19:43:36','508','2021-01-24 19:43:55',10,0),('1','148',174836,'DAYLLY SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-25 18:56:01','508','2021-01-25 18:56:47',10,0),('1','148',174908,'DAYLLY SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-26 18:55:07','508','2021-01-26 18:55:52',10,0),('1','148',175032,'DAYLLY SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-26 19:21:39','508','2021-01-26 19:22:00',10,0),('1','148',175226,'DAYLLY SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-27 18:45:08','508','2021-01-27 18:45:27',10,0),('1','148',175403,'DAYLLY SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-28 18:55:52','508','2021-01-28 18:57:11',10,0),('1','148',175506,'DAYLLY SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-29 18:55:32','508','2021-01-29 18:56:23',10,0),('1','148',175591,'DAYLLY SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-29 19:50:12','508','2021-01-29 19:50:32',10,0),('1','148',175747,'DAYLLY SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-30 19:25:26','508','2021-01-30 19:25:57',10,0),('1','148',175914,'DAYLLY SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'508',0.00,0.00,'508','2021-01-31 19:44:30','508','2021-01-31 19:44:51',10,0),('1','148',176142,'DAYLLY SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-02 19:16:59','508','2021-02-02 19:17:16',10,0),('1','148',176316,'DAYLLY SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-02 19:25:15','508','2021-02-02 19:25:32',10,0),('1','148',176533,'DAYLLY SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-04 08:54:09','508','2021-02-04 08:54:35',10,0),('1','148',176823,'DAYLLY SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-06 19:37:13','508','2021-02-06 19:44:13',10,0),('1','148',177273,'DAYLLY SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-07 10:16:59','508','2021-02-07 10:17:27',10,0),('1','148',177276,'DAYLLY SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-07 20:05:27','508','2021-02-07 20:05:46',10,0),('1','148',177418,'DAYLLY SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-07 20:11:46','508','2021-02-07 20:12:22',10,0),('1','148',177612,'DAYLLY SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-08 19:23:25','508','2021-02-08 19:23:46',10,0),('1','148',177867,'DAYLLY SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-09 18:59:19','508','2021-02-09 18:59:38',10,0),('1','148',178122,'DAYLLY SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-11 19:20:16','508','2021-02-11 19:20:41',10,0),('1','148',178280,'DAYLLY SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-11 19:34:04','508','2021-02-11 19:34:31',10,0),('1','148',178471,'DAYLLY SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-12 20:00:59','508','2021-02-12 20:02:23',10,0),('1','148',178702,'DAYLLY SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-13 19:27:37','508','2021-02-13 19:28:57',10,0),('1','148',178882,'DAYLLY SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-14 19:30:44','508','2021-02-14 19:31:16',10,0),('1','148',179054,'DAYLLY SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-15 19:36:16','508','2021-02-15 19:36:37',10,0),('1','148',179146,'DAYLLY SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-16 19:28:04','508','2021-02-16 19:28:20',10,0),('1','148',179394,'DAYLLY SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-17 11:06:26','508','2021-02-17 11:07:19',10,0),('1','148',179441,'DAYLLY SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-17 16:21:22','508','2021-02-17 16:21:43',10,0),('1','148',179592,'DAYLLY SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-18 18:53:43','508','2021-02-18 18:54:05',10,0),('1','148',179794,'DAYLLY SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-19 18:41:22','508','2021-02-19 18:42:00',10,0),('1','148',180015,'DAYLLY SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-20 14:04:42','508','2021-02-20 14:04:58',10,0),('1','148',180100,'DAYLLY SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-20 14:18:54','508','2021-02-20 14:19:32',10,0),('1','148',180187,'DAYLLY SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-21 19:45:43','508','2021-02-22 07:24:42',10,0),('1','148',180357,'DAYLLY SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-23 09:33:56','508','2021-02-23 09:34:23',10,0),('1','148',180589,'DAYLLY SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-23 20:05:17','508','2021-02-23 20:05:37',10,0),('1','148',180744,'DAYLLY SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-24 20:24:09','508','2021-02-24 20:24:46',10,0),('1','148',181017,'DAYLLY SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-25 19:06:10','508','2021-02-25 19:06:58',10,0),('1','148',181135,'DAYLLY SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-26 19:57:15','508','2021-02-27 10:04:25',10,0),('1','148',181388,'DAYLLY SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-27 19:37:59','508','2021-02-27 19:39:17',10,0),('1','148',181568,'DAYLLY SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'508',0.00,0.00,'508','2021-02-28 19:26:54','508','2021-02-28 19:27:55',10,0),('1','148',181710,'DAYLLY SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-01 19:33:44','508','2021-03-01 19:34:05',10,0),('1','148',181975,'DAYLLY SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-02 19:05:53','508','2021-03-02 19:06:11',10,0),('1','148',182112,'DAYLLY SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-03 19:52:24','508','2021-03-03 19:52:46',10,0),('1','148',182383,'DAYLLY SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-04 14:47:12','508','2021-03-04 14:47:33',10,0),('1','148',182451,'DAYLLY SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-04 19:47:12','508','2021-03-04 19:47:35',10,0),('1','148',182504,'DAYLLY SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-09 07:28:01','508','2021-03-09 07:30:31',10,0),('1','148',183225,'DAYLLY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-09 07:37:36','508','2021-03-09 07:37:58',10,0),('1','148',183228,'DAYLLY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-09 07:59:03','508','2021-03-09 07:59:43',10,0),('1','148',183233,'DAYLLY SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-09 09:09:31','508','2021-03-09 09:10:04',10,0),('1','148',183251,'DAYLLY SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-10 19:24:36','508','2021-03-10 19:27:09',10,0),('1','148',183623,'DAYLLY SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-11 19:18:41','508','2021-03-11 19:19:01',10,0),('1','148',183847,'DAYLLY SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-11 19:21:07','508','2021-03-11 19:21:28',10,0),('1','148',184121,'DAYLLY SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-13 11:33:03','508','2021-03-13 11:33:26',10,0),('1','148',184245,'DAYLLY SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-13 19:41:06','508','2021-03-13 19:41:24',10,0),('1','148',184572,'DAYLLY SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-15 12:16:38','508','2021-03-15 12:16:56',10,0),('1','148',184754,'DAYLLY SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-16 10:08:28','508','2021-03-16 10:09:18',10,0),('1','148',184857,'DAYLLY SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-16 19:48:39','508','2021-03-16 19:49:48',10,0),('1','148',185079,'DAYLLY SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-17 18:53:11','508','2021-03-17 18:53:35',10,0),('1','148',185241,'DAYLLY SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-18 19:17:29','508','2021-03-18 19:17:54',10,0),('1','148',185436,'DAYLLY SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-23 14:37:11','508','2021-03-23 14:37:46',10,0),('1','148',186236,'DAYLLY SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-23 14:47:54','508','2021-03-23 14:48:25',10,0),('1','148',186237,'DAYLLY SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-23 15:06:31','508','2021-03-23 15:06:49',10,0),('1','148',186292,'DAYLLY SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-23 19:02:35','508','2021-03-23 19:02:59',10,0),('1','148',186466,'DAYLLY SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-24 15:30:30','508','2021-03-24 15:31:10',10,0),('1','148',186499,'DAYLLY SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-25 19:01:50','508','2021-03-25 19:02:09',10,0),('1','148',186712,'DAYLLY SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-25 19:05:56','508','2021-03-25 19:06:16',10,0),('1','148',186949,'DAYLLY SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-26 19:21:05','508','2021-03-27 19:49:20',10,0),('1','148',187142,'DAYLLY SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-27 20:36:11','508','2021-03-27 20:36:31',10,0),('1','148',187310,'DAYLLY SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-28 18:58:01','508','2021-03-28 18:58:29',10,0),('1','148',187543,'DAYLLY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-30 10:00:34','508','2021-03-30 10:07:30',10,0),('1','148',187880,'DAYLLY SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'508',0.00,0.00,'508','2021-03-31 10:20:17','508','2021-03-31 10:22:11',10,0),('1','148',188101,'DAYLLY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-01 12:21:12','508','2021-04-01 12:21:50',10,0),('1','148',188189,'DAYLLY SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-01 20:33:24','508','2021-04-01 20:35:09',10,0),('1','148',188302,'DAYLLY SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-02 19:25:34','508','2021-04-02 19:26:07',10,0),('1','148',188493,'DAYLLY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-03 19:48:29','508','2021-04-04 13:59:48',10,0),('1','148',188704,'DAYLLY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-04 14:04:50','508','2021-04-04 14:05:33',10,0),('1','148',188718,'DAYLLY SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-04 19:09:27','508','2021-04-04 19:09:51',10,0),('1','148',188893,'DAYLLY SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-06 10:46:08','508','2021-04-06 10:46:33',10,0),('1','148',189084,'DAYLLY SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-07 10:25:28','508','2021-04-07 10:26:12',10,0),('1','148',189280,'DAYLLY SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-08 08:36:59','508','2021-04-08 08:37:37',10,0),('1','148',189457,'DAYLLY SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-08 18:56:29','508','2021-04-08 18:56:58',10,0),('1','148',189677,'DAYLLY SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-09 09:59:19','508','2021-04-09 10:00:49',10,0),('1','148',189679,'DAYLLY SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-10 19:34:23','508','2021-04-10 19:34:46',10,0),('1','148',190039,'DAYLLY SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-11 18:51:06','508','2021-04-11 18:51:28',10,0),('1','148',190247,'DAYLLY SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-12 20:29:34','508','2021-04-12 20:29:55',10,0),('1','148',190455,'DAYLLY SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-13 19:36:28','508','2021-04-13 19:36:59',10,0),('1','148',190861,'DAYLLY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-15 19:21:49','508','2021-04-15 19:24:34',10,0),('1','148',191131,'DAYLLY SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-16 19:15:00','508','2021-04-16 19:17:16',10,0),('1','148',191336,'DAYLLY SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-18 18:46:52','508','2021-04-18 18:49:22',10,0),('1','148',191678,'DAYLLY SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-18 19:16:20','508','2021-04-18 19:16:40',10,0),('1','148',191738,'DAYLLY SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-19 18:21:08','508','2021-04-19 18:21:32',10,0),('1','148',192084,'DAYLLY SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-20 18:57:50','508','2021-04-20 18:58:19',10,0),('1','148',192143,'DAYLLY SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-21 18:51:08','508','2021-04-21 18:51:25',10,0),('1','148',192350,'DAYLLY SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-23 12:13:01','508','2021-04-23 12:14:00',10,0),('1','148',192654,'DAYLLY SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-23 18:35:48','508','2021-04-23 18:36:09',10,0),('1','148',192787,'DAYLLY SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-24 19:47:33','508','2021-04-24 19:48:06',10,0),('1','148',192989,'DAYLLY SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-25 18:42:14','508','2021-04-25 18:42:41',10,0),('1','148',193222,'DAYLLY SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-26 19:00:44','508','2021-04-26 19:01:12',10,0),('1','148',193602,'DAYLLY SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-27 19:12:01','508','2021-04-27 19:13:07',10,0),('1','148',193636,'DAYLLY SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-28 18:38:29','508','2021-04-28 18:38:50',10,0),('1','148',193974,'DAYLLY SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-30 08:29:54','508','2021-04-30 08:30:32',10,0),('1','148',194120,'DAYLLY SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'508',0.00,0.00,'508','2021-04-30 19:20:24','508','2021-04-30 19:20:47',10,0),('1','148',194331,'DAYLLY SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-01 19:39:16','508','2021-05-01 19:41:42',10,0),('1','148',194509,'DAYLLY SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-02 19:45:04','508','2021-05-02 19:45:32',10,0),('1','148',194686,'DAYLLY SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-03 18:59:59','508','2021-05-03 19:00:27',10,0),('1','148',195054,'DAYLLY SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-04 19:23:22','508','2021-05-04 19:23:45',10,0),('1','148',195137,'DAYLLY SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-05 19:22:39','508','2021-05-05 19:22:57',10,0),('1','148',195390,'DAYLLY SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-06 19:23:42','508','2021-05-06 19:24:06',10,0),('1','148',195656,'DAYLLY SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-07 19:02:05','508','2021-05-07 19:03:38',10,0),('1','148',195874,'DAYLLY SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-08 19:40:32','508','2021-05-08 19:40:56',10,0),('1','148',196190,'DAYLLY SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-09 20:20:31','508','2021-05-09 20:20:54',10,0),('1','148',196396,'DAYLLY SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-10 19:40:16','508','2021-05-10 19:40:37',10,0),('1','148',196630,'DAYLLY SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-11 20:30:22','508','2021-05-11 20:30:40',10,0),('1','148',196713,'DAYLLY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-12 19:08:56','508','2021-05-12 19:09:23',10,0),('1','148',196912,'DAYLLY SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-14 08:41:18','508','2021-05-14 08:41:35',10,0),('1','148',197199,'DAYLLY SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-14 19:41:16','508','2021-05-14 19:41:33',10,0),('1','148',197345,'DAYLLY SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-16 20:26:40','508','2021-05-16 20:27:00',10,0),('1','148',197486,'DAYLLY SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-17 11:43:44','508','2021-05-17 11:44:04',10,0),('1','148',197970,'DAYLLY SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-19 10:44:56','508','2021-05-19 10:46:25',10,0),('1','148',198203,'DAYLLY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-19 11:08:39','508','2021-05-19 11:11:56',10,0),('1','148',198219,'DAYLLY SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-20 11:30:20','508','2021-05-20 11:30:41',10,0),('1','148',198541,'DAYLLY SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-20 20:10:51','508','2021-05-20 20:11:20',10,0),('1','148',198738,'DAYLLY SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-21 20:03:40','508','2021-05-21 20:03:58',10,0),('1','148',198961,'DAYLLY SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-22 20:57:55','508','2021-05-22 20:58:32',10,0),('1','148',199401,'DAYLLY SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-24 19:24:54','508','2021-05-24 19:25:25',10,0),('1','148',199405,'DAYLLY SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-24 20:00:30','508','2021-05-24 20:01:02',10,0),('1','148',199750,'DAYLLY SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-26 10:03:03','508','2021-05-26 10:03:42',10,0),('1','148',199965,'DAYLLY SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-27 11:10:35','508','2021-05-27 11:16:46',10,0),('1','148',200070,'DAYLLY SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-28 19:28:12','508','2021-05-28 19:28:33',10,0),('1','148',200273,'DAYLLY SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-29 20:04:56','508','2021-05-29 20:10:20',10,0),('1','148',200526,'DAYLLY SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-30 08:56:03','508','2021-05-30 08:57:15',10,0),('1','148',200538,'DAYLLY SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-30 10:10:46','508','2021-05-30 10:11:02',10,0),('1','148',200569,'DAYLLY SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-30 20:35:12','508','2021-05-30 20:35:41',10,0),('1','148',200673,'DAYLLY SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'508',0.00,0.00,'508','2021-05-31 07:46:37','508','2021-05-31 07:47:19',10,0),('1','148',200726,'DAYLLY SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-01 11:15:05','508','2021-06-01 11:16:41',10,0),('1','148',201166,'DAYLLY SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-02 09:04:17','508','2021-06-02 09:04:34',10,0),('1','148',201167,'DAYLLY SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-03 10:44:08','508','2021-06-03 10:44:29',10,0),('1','148',201479,'DAYLLY SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-03 19:35:51','508','2021-06-03 19:36:14',10,0),('1','148',201854,'DAYLLY SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-05 11:12:41','508','2021-06-05 11:15:53',10,0),('1','148',201861,'DAYLLY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-05 11:32:12','508','2021-06-05 11:32:34',10,0),('1','148',202155,'DAYLLY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-06 15:58:47','508','2021-06-06 16:01:33',10,0),('1','148',202158,'DAYLLY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-06 16:12:57','508','2021-06-06 16:13:21',10,0),('1','148',202403,'DAYLLY SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-07 19:53:14','508','2021-06-07 19:53:34',10,0),('1','148',202619,'DAYLLY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-08 19:56:49','508','2021-06-08 19:57:08',10,0),('1','148',202818,'DAYLLY SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-09 19:25:05','508','2021-06-09 19:25:40',10,0),('1','148',203083,'DAYLLY SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-10 19:44:53','508','2021-06-10 19:46:27',10,0),('1','148',203246,'DAYLLY SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-11 19:35:05','508','2021-06-11 19:35:30',10,0),('1','148',203472,'DAYLLY SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-13 20:12:37','508','2021-06-13 20:13:27',10,0),('1','148',203701,'DAYLLY SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-14 09:56:00','508','2021-06-14 09:56:23',10,0),('1','148',204007,'DAYLLY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-15 08:47:33','508','2021-06-15 08:47:55',10,0),('1','148',204029,'DAYLLY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-16 10:14:05','508','2021-06-16 10:14:27',10,0),('1','148',204484,'DAYLLY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-17 10:24:11','508','2021-06-17 10:33:59',10,0),('1','148',204495,'DAYLLY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-18 10:18:28','508','2021-06-18 10:18:49',10,0),('1','148',204695,'DAYLLY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-18 19:49:22','508','2021-06-18 19:49:37',10,0),('1','148',204864,'DAYLLY SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-19 19:21:24','508','2021-06-19 19:21:59',10,0),('1','148',205177,'DAYLLY SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-21 09:11:00','508','2021-06-21 09:11:31',10,0),('1','148',205297,'DAYLLY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-22 10:17:58','508','2021-06-22 10:18:24',10,0),('1','148',205553,'DAYLLY SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-22 19:11:56','508','2021-06-22 19:12:14',10,0),('1','148',205822,'DAYLLY SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-24 09:02:40','508','2021-06-24 09:03:03',10,0),('1','148',205998,'DAYLLY SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-25 14:31:51','508','2021-06-25 14:32:42',10,0),('1','148',206288,'DAYLLY SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-25 15:07:19','508','2021-06-25 15:07:45',10,0),('1','148',206298,'DAYLLY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-25 19:03:40','508','2021-06-25 19:04:10',10,0),('1','148',206553,'DAYLLY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-26 22:48:39','508','2021-06-26 22:49:09',10,0),('1','148',206556,'DAYLLY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-27 16:44:18','508','2021-06-27 16:46:15',10,0),('1','148',206741,'DAYLLY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-27 22:48:38','508','2021-06-27 22:49:11',10,0),('1','148',207002,'DAYLLY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-28 21:41:47','508','2021-06-28 21:42:14',10,0),('1','148',207003,'DAYLLY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-28 22:09:31','508','2021-06-28 22:10:00',10,0),('1','148',207201,'DAYLLY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'508',0.00,0.00,'508','2021-06-30 12:28:54','508','2021-06-30 12:29:21',10,0),('1','148',207377,'DAYLLY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-01 10:13:41','508','2021-07-01 10:14:12',10,0),('1','148',207556,'DAYLLY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-01 11:12:38','508','2021-07-01 11:13:02',10,0),('1','148',207570,'DAYLLY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-01 12:10:10','508','2021-07-01 12:11:08',10,0),('1','148',207580,'DAYLLY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-02 12:07:32','508','2021-07-02 12:08:14',10,0),('1','148',207805,'DAYLLY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-02 12:33:05','508','2021-07-02 12:33:31',10,0),('1','148',207854,'DAYLLY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-03 12:20:09','508','2021-07-03 12:20:28',10,0),('1','148',208008,'DAYLLY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-03 18:14:16','508','2021-07-03 18:14:46',10,0),('1','148',208204,'DAYLLY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-05 12:55:48','508','2021-07-05 12:56:14',10,0),('1','148',208455,'DAYLLY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-05 14:33:14','508','2021-07-05 14:33:52',10,0),('1','148',208486,'DAYLLY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-06 13:11:09','508','2021-07-06 13:11:34',10,0),('1','148',208667,'DAYLLY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-06 17:28:15','508','2021-07-06 17:28:47',10,0),('1','148',208727,'DAYLLY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-07 13:22:07','508','2021-07-07 13:22:38',10,0),('1','148',208901,'DAYLLY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-08 09:57:53','508','2021-07-08 09:58:16',10,0),('1','148',209073,'DAYLLY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-08 11:02:20','508','2021-07-08 11:07:14',10,0),('1','148',209095,'DAYLLY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-08 11:31:32','508','2021-07-08 11:32:02',10,0),('1','148',209099,'DAYLLY SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-08 14:23:31','508','2021-07-08 14:23:55',10,0),('1','148',209135,'DAYLLY SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-09 13:03:08','508','2021-07-09 13:03:36',10,0),('1','148',209333,'DAYLLY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-10 17:27:39','508','2021-07-10 17:28:00',10,0),('1','148',209608,'DAYLLY SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-10 17:55:31','508','2021-07-10 17:56:05',10,0),('1','148',209681,'DAYLLY SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-12 12:09:07','508','2021-07-12 12:09:44',10,0),('1','148',209983,'DAYLLY SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-12 12:39:52','508','2021-07-12 12:40:46',10,0),('1','148',209986,'DAYLLY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-13 11:01:01','508','2021-07-13 11:01:21',10,0),('1','148',210192,'DAYLLY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-13 11:16:39','508','2021-07-13 11:17:01',10,0),('1','148',210197,'DAYLLY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-14 12:19:57','508','2021-07-14 12:20:27',10,0),('1','148',210414,'DAYLLY SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-16 11:13:27','508','2021-07-16 11:14:24',10,0),('1','148',210830,'DAYLLY SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-16 11:50:22','508','2021-07-16 11:50:47',10,0),('1','148',210838,'DAYLLY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-17 15:09:19','508','2021-07-17 15:09:55',10,0),('1','148',211095,'DAYLLY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-17 15:29:39','508','2021-07-17 15:30:10',10,0),('1','148',211101,'DAYLLY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-17 16:07:00','508','2021-07-17 16:07:24',10,0),('1','148',211457,'DAYLLY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-19 10:35:16','508','2021-07-19 10:35:46',10,0),('1','148',211471,'DAYLLY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-19 11:55:50','508','2021-07-19 11:56:29',10,0),('1','148',211499,'DAYLLY SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-20 22:19:34','508','2021-07-20 22:19:58',10,0),('1','148',211758,'DAYLLY SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-20 22:29:19','508','2021-07-20 22:29:44',10,0),('1','148',211759,'DAYLLY SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-20 22:33:48','508','2021-07-20 22:34:23',10,0),('1','148',212087,'DAYLLY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-22 13:04:40','508','2021-07-22 13:05:08',10,0),('1','148',212109,'DAYLLY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-22 13:07:33','508','2021-07-22 13:07:52',10,0),('1','148',212112,'DAYLLY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-23 09:44:45','508','2021-07-23 09:45:17',10,0),('1','148',212305,'DAYLLY SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-26 13:01:49','508','2021-07-26 13:02:11',10,0),('1','148',212998,'DAYLLY SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-26 13:18:35','508','2021-07-26 13:19:10',10,0),('1','148',213006,'DAYLLY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-26 13:39:32','508','2021-07-26 13:39:51',10,0),('1','148',213015,'DAYLLY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-27 10:20:00','508','2021-07-27 10:20:24',10,0),('1','148',213226,'DAYLLY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-27 10:49:43','508','2021-07-27 10:53:37',10,0),('1','148',213241,'DAYLLY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-28 15:00:01','508','2021-07-28 15:00:43',10,0),('1','148',213554,'DAYLLY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-29 11:20:32','508','2021-07-29 11:21:14',10,0),('1','148',213723,'DAYLLY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-29 11:53:18','508','2021-07-29 11:53:49',10,0),('1','148',213732,'DAYLLY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-30 11:31:30','508','2021-07-30 11:31:50',10,0),('1','148',213984,'DAYLLY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'508',0.00,0.00,'508','2021-07-30 22:51:08','508','2021-07-30 22:51:42',10,0),('1','148',214507,'DAYLLY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-02 10:57:49','508','2021-08-02 10:59:35',10,0),('1','148',214639,'DAYLLY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-02 12:35:37','508','2021-08-02 12:38:15',10,0),('1','148',214664,'DAYLLY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-03 12:08:50','508','2021-08-03 12:09:13',10,0),('1','148',214890,'DAYLLY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-04 14:15:41','508','2021-08-04 14:16:09',10,0),('1','148',215140,'DAYLLY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-05 11:58:59','508','2021-08-05 11:59:22',10,0),('1','148',215329,'DAYLLY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-06 08:32:11','508','2021-08-06 08:32:45',10,0),('1','148',215485,'DAYLLY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-06 08:57:18','508','2021-08-06 08:57:59',10,0),('1','148',215499,'DAYLLY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-06 09:15:31','508','2021-08-06 09:16:05',10,0),('1','148',215504,'DAYLLY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-07 10:10:36','508','2021-08-07 10:11:00',10,0),('1','148',215738,'DAYLLY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-09 11:06:03','508','2021-08-09 11:06:44',10,0),('1','148',216203,'DAYLLY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-09 11:32:33','508','2021-08-09 11:32:54',10,0),('1','148',216209,'DAYLLY SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-09 11:59:19','508','2021-08-09 12:00:24',10,0),('1','148',216256,'DAYLLY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-10 10:21:44','508','2021-08-10 10:22:07',10,0),('1','148',216413,'DAYLLY SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-11 14:38:27','508','2021-08-11 14:39:04',10,0),('1','148',216707,'DAYLLY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-12 14:51:19','508','2021-08-12 14:53:26',10,0),('1','148',216944,'DAYLLY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-13 10:54:43','508','2021-08-13 10:56:28',10,0),('1','148',217120,'DAYLLY SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-13 11:16:57','508','2021-08-13 11:17:19',10,0),('1','148',217129,'DAYLLY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-14 12:39:55','508','2021-08-14 12:40:21',10,0),('1','148',217391,'DAYLLY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-14 12:54:41','508','2021-08-14 12:55:04',10,0),('1','148',217397,'DAYLLY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-16 11:22:11','508','2021-08-16 11:22:34',10,0),('1','148',217838,'DAYLLY SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-16 11:45:27','508','2021-08-16 11:45:53',10,0),('1','148',217849,'DAYLLY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-17 09:33:42','508','2021-08-17 09:34:29',10,0),('1','148',218054,'DAYLLY SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-18 09:48:00','508','2021-08-18 09:48:23',10,0),('1','148',218300,'DAYLLY SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-19 09:32:40','508','2021-08-19 09:33:00',10,0),('1','148',218525,'DAYLLY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-20 09:25:16','508','2021-08-20 09:27:11',10,0),('1','148',218744,'DAYLLY SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-21 11:07:20','508','2021-08-21 11:08:46',10,0),('1','148',218978,'DAYLLY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-23 06:45:02','508','2021-08-23 06:45:29',10,0),('1','148',219349,'DAYLLY SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-23 07:41:13','508','2021-08-23 07:41:45',10,0),('1','148',219375,'DAYLLY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-24 04:56:16','508','2021-08-24 04:56:37',10,0),('1','148',219577,'DAYLLY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-24 05:00:50','508','2021-08-24 05:01:09',10,0),('1','148',219578,'DAYLLY SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-25 05:14:57','508','2021-08-25 05:15:33',10,0),('1','148',219795,'Daily sales ','2021-08-25','2021-08-25 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-25 21:51:00','508','2021-08-25 21:51:55',10,0),('1','148',220065,'DAYLLY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-27 05:44:37','508','2021-08-27 05:45:04',10,0),('1','148',220233,'DAYLLY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-27 05:54:11','508','2021-08-27 05:54:34',10,0),('1','148',220237,'DAYLLY SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-28 06:23:14','508','2021-08-28 06:23:33',10,0),('1','148',220469,'DAILY SHIFT ','2021-08-28','2021-08-28 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-29 07:01:16','508','2021-08-29 07:02:45',10,0),('1','148',220695,'DAILY SHIFT ','2021-08-28','2021-08-28 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-29 07:10:40','508','2021-08-29 07:11:03',10,0),('1','148',220697,'DAILY SHIFT ','2021-08-29','2021-08-29 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-30 11:46:18','508','2021-08-30 11:46:37',10,0),('1','148',221037,'DAILY SHIFT ','2021-08-30','2021-08-30 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-31 11:22:17','508','2021-08-31 11:22:44',10,0),('1','148',221258,'Daily shift ','2021-08-31','2021-08-31 00:00:00',NULL,'508',0.00,0.00,'508','2021-08-31 11:27:38','508','2021-08-31 11:28:10',10,0),('1','148',221260,'DAILY SHIFT ','2021-08-30','2021-08-30 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-01 06:37:11','508','2021-09-01 06:37:35',10,0),('1','148',221399,'DAILY SHIFT ','2021-08-31','2021-08-31 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-01 11:27:32','508','2021-09-01 11:28:03',10,0),('1','148',221485,'DAYLLY SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-02 08:37:13','508','2021-09-02 08:37:32',10,0),('1','148',221667,'DAILY SHIFT ','2021-09-02','2021-09-02 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-03 06:00:21','508','2021-09-03 06:01:00',10,0),('1','148',221825,'DAILY SHIFT ','2021-09-02','2021-09-02 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-03 10:08:24','508','2021-09-03 10:09:04',10,0),('1','148',221902,'DAYLLY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-04 18:22:34','508','2021-09-04 18:23:00',10,0),('1','148',222237,'DAYLLY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-05 12:21:06','508','2021-09-05 12:21:23',10,0),('1','148',222369,'DAILY SHIFT ','2021-09-04','2021-09-04 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-05 12:35:41','508','2021-09-05 12:36:11',10,0),('1','148',222377,'DAILY SHIFT ','2021-09-04','2021-09-04 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-05 13:01:24','508','2021-09-05 13:01:44',10,0),('1','148',222378,'DAILY SHIFT ','2021-09-05','2021-09-05 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-06 18:43:20','508','2021-09-06 18:43:49',10,0),('1','148',222700,'DAYLLY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-06 19:00:21','508','2021-09-06 19:00:50',10,0),('1','148',222821,'Daily shift ','2021-09-07','2021-09-07 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-08 08:29:58','508','2021-09-08 08:30:25',10,0),('1','148',222975,'DAYLLY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-09 08:49:56','508','2021-09-09 08:50:20',10,0),('1','148',223222,'Daily shift ','2021-09-09','2021-09-09 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-10 10:37:11','508','2021-09-10 10:38:37',10,0),('1','148',223493,'DAYLLY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-10 10:49:00','508','2021-09-10 10:49:53',10,0),('1','148',223495,'DAYLLY SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-11 09:31:37','508','2021-09-11 09:31:57',10,0),('1','148',223698,'Daily shift ','2021-09-11','2021-09-11 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-12 09:46:35','508','2021-09-12 09:47:11',10,0),('1','148',223925,'DAYLLY SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-12 09:56:53','508','2021-09-12 09:57:19',10,0),('1','148',223928,'DAYLLY SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-13 10:48:05','508','2021-09-13 10:48:43',10,0),('1','148',224172,'DAYLLY SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-13 11:07:06','508','2021-09-13 11:07:43',10,0),('1','148',224182,'DAYLLY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-14 08:53:59','508','2021-09-14 08:54:31',10,0),('1','148',224371,'DAYLLY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-14 09:15:36','508','2021-09-14 09:16:16',10,0),('1','148',224379,'DAYLLY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-15 10:18:39','508','2021-09-15 10:20:08',10,0),('1','148',224620,'DAYLLY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-15 10:52:40','508','2021-09-15 10:53:04',10,0),('1','148',224635,'DAYLLY SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-16 06:31:40','508','2021-09-16 06:32:51',10,0),('1','148',224782,'Daily shift ','2021-09-16','2021-09-16 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-17 06:49:36','508','2021-09-17 06:50:00',10,0),('1','148',225027,'Daily shift ','2021-09-16','2021-09-16 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-17 06:56:58','508','2021-09-17 06:57:33',10,0),('1','148',225032,'Daily shift ','2021-09-17','2021-09-17 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-18 06:50:23','508','2021-09-18 06:50:49',10,0),('1','148',225273,'Daily shift ','2021-09-17','2021-09-17 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-18 07:11:46','508','2021-09-18 07:12:06',10,0),('1','148',225282,'Daily shift ','2021-09-18','2021-09-18 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-18 07:20:53','508','2021-09-18 07:21:13',10,0),('1','148',225285,'Daily shift ','2021-09-18','2021-09-18 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-19 07:11:47','508','2021-09-19 07:12:04',10,0),('1','148',225498,'Daily shift ','2021-09-18','2021-09-18 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-19 07:44:57','508','2021-09-19 07:45:32',10,0),('1','148',225506,'Daily shift ','2021-09-19','2021-09-19 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-20 11:03:19','508','2021-09-20 11:04:28',10,0),('1','148',225824,'Daily shift ','2021-09-20','2021-09-20 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-20 19:03:24','508','2021-09-20 19:03:53',10,0),('1','148',225941,'DAYLLY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-20 19:14:06','508','2021-09-20 19:14:25',10,0),('1','148',225943,'DAYLLY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-21 11:57:40','508','2021-09-21 11:58:30',10,0),('1','148',226143,'DAYLLY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-22 10:54:09','508','2021-09-22 10:54:41',10,0),('1','148',226320,'DAYLLY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-22 16:02:49','508','2021-09-22 16:03:10',10,0),('1','148',226532,'DAYLLY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-23 09:18:07','508','2021-09-23 09:18:27',10,0),('1','148',226541,'DAYLLY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-23 12:53:31','508','2021-09-23 12:53:52',10,0),('1','148',226668,'DAYLLY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-24 09:35:19','508','2021-09-24 09:36:22',10,0),('1','148',226813,'DAYLLY SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-25 10:19:03','508','2021-09-25 10:19:35',10,0),('1','148',227032,'DAYLLY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-26 22:49:14','508','2021-09-26 22:49:31',10,0),('1','148',227358,'Daily shift ','2021-09-26','2021-09-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-27 11:43:54','508','2021-09-27 11:44:27',10,0),('1','148',227492,'DAYLLY SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-28 10:32:08','508','2021-09-28 10:33:35',10,0),('1','148',227688,'DAYLLY SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-29 09:57:45','508','2021-09-29 09:58:17',10,0),('1','148',227928,'DAYLLY SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'508',0.00,0.00,'508','2021-09-30 10:57:31','508','2021-09-30 10:58:34',10,0),('1','148',228196,'DAYLLY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-03 13:46:59','508','2021-10-03 13:48:16',10,0),('1','148',228859,'Daily shift ','2021-10-01','2021-10-01 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-03 13:58:14','508','2021-10-03 13:58:30',10,0),('1','148',228864,'Daily shift ','2021-10-02','2021-10-02 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-03 14:12:25','508','2021-10-03 14:12:43',10,0),('1','148',228873,'Daily shift ','2021-10-02','2021-10-02 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-03 14:16:02','508','2021-10-03 14:16:25',10,0),('1','148',228877,'Daily shift ','2021-10-03','2021-10-03 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-05 09:43:16','508','2021-10-05 09:43:48',10,0),('1','148',229232,'DAYLLY SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-05 10:10:29','508','2021-10-05 10:10:51',10,0),('1','148',229239,'DAYLLY SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-05 10:23:53','508','2021-10-05 10:24:13',10,0),('1','148',229243,'DAYLLY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-06 09:05:15','508','2021-10-06 09:05:50',10,0),('1','148',229468,'DAYLLY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-06 09:31:04','508','2021-10-06 09:31:25',10,0),('1','148',229480,'DAYLLY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-07 06:43:34','508','2021-10-07 06:44:09',10,0),('1','148',229668,'Daily shift ','2021-10-07','2021-10-07 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-08 05:22:33','508','2021-10-08 05:22:58',10,0),('1','148',229876,'Daily shift ','2021-10-08','2021-10-08 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-09 12:16:26','508','2021-10-09 12:17:30',10,0),('1','148',230190,'Daily shift ','2021-10-08','2021-10-08 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-10 08:50:10','508','2021-10-10 08:50:35',10,0),('1','148',230717,'DAYLLY SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-11 19:33:30','508','2021-10-11 19:35:28',10,0),('1','148',230753,'Daily shift ','2021-10-09','2021-10-09 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-11 19:52:09','508','2021-10-11 19:55:36',10,0),('1','148',230758,'Daily shift ','2021-10-10','2021-10-10 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-11 20:11:06','508','2021-10-11 20:11:25',10,0),('1','148',230788,'DAYLLY SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-13 05:35:13','508','2021-10-13 05:36:44',10,0),('1','148',231055,'Daily shift ','2021-10-13','2021-10-13 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-14 05:24:12','508','2021-10-14 05:25:20',10,0),('1','148',231359,'Daily shift ','2021-10-13','2021-10-13 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-14 07:59:46','508','2021-10-14 08:00:07',10,0),('1','148',231408,'Daily shift ','2021-10-14','2021-10-14 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-14 09:23:38','508','2021-10-14 09:23:59',10,0),('1','148',231443,'DAYLLY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-15 07:31:19','508','2021-10-15 07:32:54',10,0),('1','148',231667,'Daily shift ','2021-10-15','2021-10-15 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-16 06:10:38','508','2021-10-16 06:12:36',10,0),('1','148',231888,'Daily shift ','2021-10-16','2021-10-16 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-17 07:45:11','508','2021-10-17 08:42:18',10,0),('1','148',232141,'Daily shift ','2021-10-17','2021-10-17 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-17 08:46:14','508','2021-10-17 08:46:36',10,0),('1','148',232142,'Daily shift ','2021-10-17','2021-10-17 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-18 07:11:52','508','2021-10-18 07:13:17',10,0),('1','148',232364,'Daily shift ','2021-10-18','2021-10-18 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-19 05:52:12','508','2021-10-19 05:55:39',10,0),('1','148',232589,'Daily shift ','2021-10-19','2021-10-19 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-20 05:27:25','508','2021-10-20 05:28:10',10,0),('1','148',232832,'Daily shift ','2021-10-19','2021-10-19 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-20 05:36:31','508','2021-10-20 05:36:46',10,0),('1','148',232834,'Daily shift ','2021-10-20','2021-10-20 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-21 05:29:06','508','2021-10-21 05:32:41',10,0),('1','148',233098,'Daily shift ','2021-10-21','2021-10-21 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-22 07:19:56','508','2021-10-22 07:21:35',10,0),('1','148',233408,'Daily shift ','2021-10-22','2021-10-22 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-22 07:26:50','508','2021-10-22 07:27:38',10,0),('1','148',233411,'Daily shift ','2021-10-22','2021-10-22 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-23 05:57:11','508','2021-10-23 05:59:06',10,0),('1','148',233606,'Daily shift ','2021-10-23','2021-10-23 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-24 06:28:19','508','2021-10-24 06:30:26',10,0),('1','148',233852,'Daily shift ','2021-10-24','2021-10-24 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-24 12:38:30','508','2021-10-24 12:39:36',10,0),('1','148',233928,'Daily shift ','2021-10-24','2021-10-24 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-25 06:28:34','508','2021-10-25 06:28:57',10,0),('1','148',234063,'Daily shift ','2021-10-25','2021-10-25 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-26 05:39:04','508','2021-10-26 05:41:27',10,0),('1','148',234303,'Daily shift ','2021-10-26','2021-10-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-26 13:56:51','508','2021-10-26 13:57:34',10,0),('1','148',234479,'Daily shift ','2021-10-26','2021-10-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-27 06:18:21','508','2021-10-27 06:19:04',10,0),('1','148',234564,'Daily shift ','2021-10-27','2021-10-27 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-28 05:37:46','508','2021-10-28 05:38:46',10,0),('1','148',234822,'Daily shift ','2021-10-28','2021-10-28 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-29 05:11:49','508','2021-10-29 05:13:27',10,0),('1','148',235061,'Daily shift ','2021-10-28','2021-10-28 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-29 05:23:18','508','2021-10-29 05:23:33',10,0),('1','148',235064,'Daily shift ','2021-10-28','2021-10-28 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-29 05:47:52','508','2021-10-29 05:48:10',10,0),('1','148',235068,'Daily shift ','2021-10-29','2021-10-29 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-30 05:14:04','508','2021-10-30 05:17:20',10,0),('1','148',235296,'Daily shift ','2021-10-30','2021-10-30 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-31 05:33:38','508','2021-10-31 05:34:17',10,0),('1','148',235522,'Daily shift ','2021-10-31','2021-10-31 00:00:00',NULL,'508',0.00,0.00,'508','2021-10-31 05:37:34','508','2021-10-31 05:37:49',10,0),('1','148',235523,'Daily shift ','2021-10-31','2021-10-31 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-01 05:17:29','508','2021-11-01 05:20:45',10,0),('1','148',235749,'Daily shift ','2021-11-01','2021-11-01 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-02 05:06:04','508','2021-11-02 05:07:13',10,0),('1','148',236004,'Daily shift ','2021-11-01','2021-11-01 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-02 05:19:22','508','2021-11-02 05:19:43',10,0),('1','148',236007,'Daily shift ','2021-11-02','2021-11-02 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-03 05:31:02','508','2021-11-03 05:32:16',10,0),('1','148',236233,'Daily shift ','2021-11-03','2021-11-03 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-03 13:07:17','508','2021-11-03 13:08:25',10,0),('1','148',236485,'Daily shift ','2021-11-03','2021-11-03 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-03 23:58:44','508','2021-11-04 00:01:22',10,0),('1','148',236513,'Daily shift ','2021-11-04','2021-11-04 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-05 05:14:36','508','2021-11-05 05:15:09',10,0),('1','148',236722,'Daily shift ','2021-11-05','2021-11-05 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-06 03:59:55','508','2021-11-06 04:00:22',10,0),('1','148',236937,'Daily shift ','2021-11-06','2021-11-06 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-07 05:28:43','508','2021-11-07 05:29:11',10,0),('1','148',237163,'Daily shift ','2021-11-07','2021-11-07 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-07 22:10:05','508','2021-11-07 22:10:26',10,0),('1','148',237358,'Daily shift ','2021-11-07','2021-11-07 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-07 22:14:31','508','2021-11-07 22:14:44',10,0),('1','148',237359,'Daily shift ','2021-11-07','2021-11-07 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-08 07:02:24','508','2021-11-08 07:02:48',10,0),('1','148',237410,'Daily shift ','2021-11-08','2021-11-08 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-09 04:53:22','508','2021-11-09 04:53:41',10,0),('1','148',237594,'Daily shift ','2021-11-09','2021-11-09 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-10 06:26:20','508','2021-11-10 06:26:56',10,0),('1','148',237890,'Daily shift ','2021-11-09','2021-11-09 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-10 06:52:08','508','2021-11-10 06:52:26',10,0),('1','148',237895,'Daily shift ','2021-11-10','2021-11-10 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-11 04:56:57','508','2021-11-11 04:57:23',10,0),('1','148',238136,'DAYLLY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-12 06:59:47','508','2021-11-12 07:00:10',10,0),('1','148',238387,'Daily shift ','2021-11-12','2021-11-12 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-13 08:14:43','508','2021-11-13 08:15:22',10,0),('1','148',238661,'Daily shift ','2021-11-13','2021-11-13 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-14 13:11:48','508','2021-11-14 13:12:18',10,0),('1','148',238947,'Daily shift ','2021-11-14','2021-11-14 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-15 05:43:12','508','2021-11-15 05:43:31',10,0),('1','148',239057,'Daily shift ','2021-11-15','2021-11-15 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-16 08:41:25','508','2021-11-16 08:41:54',10,0),('1','148',239357,'Daily shift ','2021-11-16','2021-11-16 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-16 08:53:57','508','2021-11-16 08:54:09',10,0),('1','148',239361,'Daily shift ','2021-11-16','2021-11-16 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-17 05:35:47','508','2021-11-17 05:36:06',10,0),('1','148',239529,'Daily shift ','2021-11-17','2021-11-17 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-18 05:19:40','508','2021-11-18 05:20:03',10,0),('1','148',239761,'Daily shift ','2021-11-18','2021-11-18 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-19 05:13:03','508','2021-11-19 05:13:24',10,0),('1','148',239976,'Daily shift ','2021-11-19','2021-11-19 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-19 14:08:40','508','2021-11-19 14:09:10',10,0),('1','148',240115,'DAYLLY SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-20 05:27:12','508','2021-11-20 05:27:29',10,0),('1','148',240196,'Daily shift ','2021-11-20','2021-11-20 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-21 06:28:53','508','2021-11-21 06:29:21',10,0),('1','148',240465,'Daily shift ','2021-11-21','2021-11-21 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-22 06:07:00','508','2021-11-22 06:07:25',10,0),('1','148',240693,'Daily shift ','2021-11-21','2021-11-21 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-22 06:20:07','508','2021-11-22 06:20:21',10,0),('1','148',240723,'Daily shift ','2021-11-22','2021-11-22 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-23 07:30:00','508','2021-11-23 07:30:18',10,0),('1','148',241031,'DAYLLY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-24 06:37:46','508','2021-11-24 06:38:35',10,0),('1','148',241237,'Daily shift ','2021-11-24','2021-11-24 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-25 06:26:52','508','2021-11-25 06:27:19',10,0),('1','148',241497,'Daily shift ','2021-11-24','2021-11-24 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-25 06:46:32','508','2021-11-25 06:48:05',10,0),('1','148',241515,'Daily shift ','2021-11-25','2021-11-25 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-26 07:04:06','508','2021-11-26 07:04:26',10,0),('1','148',241774,'Daily shift ','2021-11-26','2021-11-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-27 05:08:54','508','2021-11-27 05:10:53',10,0),('1','148',241964,'Daily shift ','2021-11-26','2021-11-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-27 05:24:50','508','2021-11-27 05:27:30',10,0),('1','148',241968,'Daily shift ','2021-11-27','2021-11-27 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-28 06:34:04','508','2021-11-28 06:39:20',10,0),('1','148',242218,'Daily shift ','2021-11-28','2021-11-28 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-29 05:42:53','508','2021-11-29 05:44:43',10,0),('1','148',242424,'Daily shift ','2021-11-28','2021-11-28 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-29 05:51:21','508','2021-11-29 05:51:38',10,0),('1','148',242426,'Daily shift ','2021-11-28','2021-11-28 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-29 06:08:12','508','2021-11-29 06:08:26',10,0),('1','148',242436,'Daily shift ','2021-11-29','2021-11-29 00:00:00',NULL,'508',0.00,0.00,'508','2021-11-30 05:37:00','508','2021-11-30 05:41:27',10,0),('1','148',242669,'Daily shift ','2021-11-30','2021-11-30 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-01 05:54:39','508','2021-12-01 05:55:02',10,0),('1','148',242921,'Daily shift ','2021-11-30','2021-11-30 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-01 06:08:58','508','2021-12-01 06:11:23',10,0),('1','148',242924,'Daily shift ','2021-12-01','2021-12-01 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-02 06:06:58','508','2021-12-02 06:44:28',10,0),('1','148',243158,'Daily shift ','2021-12-02','2021-12-02 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-03 06:54:31','508','2021-12-03 07:35:13',10,0),('1','148',243406,'Daily shift ','2021-12-02','2021-12-02 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-03 08:32:16','508','2021-12-03 08:32:38',10,0),('1','148',243430,'Daily shift ','2021-12-02','2021-12-02 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-03 08:40:16','508','2021-12-03 08:42:03',10,0),('1','148',243434,'Daily shift ','2021-12-03','2021-12-03 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-05 06:40:23','508','2021-12-05 06:40:45',10,0),('1','148',243843,'Daily shift ','2021-12-04','2021-12-04 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-05 06:55:03','508','2021-12-05 06:55:27',10,0),('1','148',243849,'Daily shift ','2021-12-05','2021-12-05 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-06 07:22:57','508','2021-12-06 07:36:06',10,0),('1','148',244096,'Daily shift ','2021-12-05','2021-12-05 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-06 07:49:57','508','2021-12-06 07:50:16',10,0),('1','148',244108,'Daily shift ','2021-12-06','2021-12-06 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-07 06:23:36','508','2021-12-07 06:31:21',10,0),('1','148',244303,'Daily shift ','2021-12-07','2021-12-07 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-07 13:06:24','508','2021-12-07 13:29:32',10,0),('1','148',244423,'DAYLLY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-08 09:53:33','508','2021-12-08 10:13:54',10,0),('1','148',244605,'Daily shift ','2021-12-08','2021-12-08 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-09 06:40:57','508','2021-12-09 06:44:05',10,0),('1','148',244766,'Daily shift ','2021-12-09','2021-12-09 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-10 06:04:02','508','2021-12-10 06:19:24',10,0),('1','148',244994,'Daily shift ','2021-12-09','2021-12-09 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-10 06:29:46','508','2021-12-10 06:31:30',10,0),('1','148',244999,'Daily shift ','2021-12-10','2021-12-10 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-11 06:33:37','508','2021-12-11 06:39:03',10,0),('1','148',245229,'Daily shift ','2021-12-11','2021-12-11 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-12 11:25:54','508','2021-12-12 11:29:52',10,0),('1','148',245530,'Daily shift ','2021-12-12','2021-12-12 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-13 06:02:59','508','2021-12-13 06:09:38',10,0),('1','148',245683,'Daily shift ','2021-12-13','2021-12-13 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-14 10:39:29','508','2021-12-14 10:41:32',10,0),('1','148',246036,'Daily shift ','2021-12-14','2021-12-14 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-14 11:08:20','508','2021-12-14 11:08:49',10,0),('1','148',246076,'DAYLLY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-15 06:26:00','508','2021-12-15 06:32:12',10,0),('1','148',246200,'Daily shift ','2021-12-15','2021-12-15 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-16 06:46:00','508','2021-12-16 06:49:07',10,0),('1','148',246470,'Daily shift ','2021-12-16','2021-12-16 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-17 06:30:48','508','2021-12-17 06:32:38',10,0),('1','148',246711,'Daily shift ','2021-12-16','2021-12-16 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-17 06:55:55','508','2021-12-17 06:56:16',10,0),('1','148',246718,'Daily shift ','2021-12-16','2021-12-16 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-17 06:59:44','508','2021-12-17 07:17:05',10,0),('1','148',246726,'Daily shift ','2021-12-17','2021-12-17 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-18 06:49:45','508','2021-12-18 06:50:22',10,0),('1','148',246960,'Daily shift ','2021-12-18','2021-12-18 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-19 06:22:08','508','2021-12-19 06:23:51',10,0),('1','148',247181,'Daily shift ','2021-12-18','2021-12-18 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-19 06:34:05','508','2021-12-19 06:36:37',10,0),('1','148',247186,'Daily shift ','2021-12-19','2021-12-19 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-20 06:01:18','508','2021-12-20 06:04:44',10,0),('1','148',247398,'Daily shift ','2021-12-19','2021-12-19 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-20 06:07:55','508','2021-12-20 06:08:09',10,0),('1','148',247400,'Daily shift ','2021-12-19','2021-12-19 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-20 06:21:56','508','2021-12-20 06:28:16',10,0),('1','148',247412,'Daily shift ','2021-12-20','2021-12-20 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-21 08:58:20','508','2021-12-21 09:12:50',10,0),('1','148',247729,'Daily shift ','2021-12-21','2021-12-21 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-22 06:20:14','508','2021-12-22 06:25:18',10,0),('1','148',247925,'Daily shift ','2021-12-21','2021-12-21 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-22 06:39:32','508','2021-12-22 06:42:02',10,0),('1','148',247930,'Daily shift ','2021-12-22','2021-12-22 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-23 07:54:57','508','2021-12-23 07:58:10',10,0),('1','148',248211,'Daily shift ','2021-12-23','2021-12-23 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-23 18:32:13','508','2021-12-23 18:34:11',10,0),('1','148',248343,'Daily shift ','2021-12-23','2021-12-23 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-24 07:50:18','508','2021-12-24 07:53:01',10,0),('1','148',248451,'Daily shift ','2021-12-24','2021-12-24 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-25 12:25:32','508','2021-12-25 12:31:11',10,0),('1','148',248744,'Daily shift ','2021-12-25','2021-12-25 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-26 12:01:40','508','2021-12-26 12:33:37',10,0),('1','148',248976,'Daily ','2021-12-26','2021-12-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-27 07:04:40','508','2021-12-27 07:05:30',10,0),('1','148',249141,'Daily shift ','2021-12-26','2021-12-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-27 07:12:42','508','2021-12-27 07:13:01',10,0),('1','148',249144,'Daily shift ','2021-12-26','2021-12-26 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-27 07:21:26','508','2021-12-27 07:24:40',10,0),('1','148',249152,'Daily shift ','2021-12-27','2021-12-27 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-28 07:03:02','508','2021-12-28 07:14:00',10,0),('1','148',249385,'Daily shift ','2021-12-27','2021-12-27 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-28 08:07:39','508','2021-12-28 08:15:30',10,0),('1','148',249406,'Daily shift ','2021-12-28','2021-12-28 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-29 08:22:25','508','2021-12-29 08:25:30',10,0),('1','148',249659,'Daily shift ','2021-12-29','2021-12-29 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-30 07:56:36','508','2021-12-30 08:02:52',10,0),('1','148',249903,'Daily shift ','2021-12-29','2021-12-29 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-30 08:32:01','508','2021-12-30 08:35:03',10,0),('1','148',249916,'Daily shift ','2021-12-30','2021-12-30 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-30 10:49:52','508','2021-12-30 10:52:55',10,0),('1','148',249963,'Daily shift ','2021-12-30','2021-12-30 00:00:00',NULL,'508',0.00,0.00,'508','2021-12-31 06:55:57','508','2021-12-31 07:02:53',10,0),('1','148',250124,'Daily shift ','2021-12-31','2021-12-31 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-01 06:19:39','508','2022-01-01 06:28:42',10,0),('1','148',250346,'Daily shift ','2021-12-31','2021-12-31 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-01 06:56:02','508','2022-01-01 06:56:26',10,0),('1','148',250357,'Daily shift ','2022-01-01','2022-01-01 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-02 06:09:09','508','2022-01-02 06:09:54',10,0),('1','148',250564,'Daily shift ','2022-01-02','2022-01-02 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-03 06:27:06','508','2022-01-03 06:27:25',10,0),('1','148',250811,'Daily shift ','2022-01-03','2022-01-03 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-04 07:56:23','508','2022-01-04 08:00:31',10,0),('1','148',251068,'Daily shift ','2022-01-04','2022-01-04 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-05 10:50:59','508','2022-01-05 10:54:15',10,0),('1','148',251351,'Daily shift ','2022-01-05','2022-01-05 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-06 09:28:29','508','2022-01-06 09:38:07',10,0),('1','148',251588,'Daily shift ','2022-01-06','2022-01-06 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-07 08:13:42','508','2022-01-07 08:19:27',10,0),('1','148',251799,'Daily shift ','2022-01-07','2022-01-07 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-08 12:55:17','508','2022-01-08 12:55:41',10,0),('1','148',252102,'Daily shift ','2022-01-08','2022-01-08 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-08 21:01:01','508','2022-01-08 21:13:53',10,0),('1','148',252240,'DAYLLY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-09 17:05:33','508','2022-01-09 17:10:56',10,0),('1','148',252391,'DAYLLY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-10 07:17:30','508','2022-01-10 07:18:42',10,0),('1','148',252480,'DAYLLY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-11 08:11:21','508','2022-01-11 08:37:54',10,0),('1','148',252758,'DAYLLY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-11 15:54:28','508','2022-01-11 16:03:57',10,0),('1','148',252882,'DAYLLY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-11 20:20:25','508','2022-01-11 20:32:40',10,0),('1','148',252973,'DAYLLY SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-12 20:06:21','508','2022-01-12 20:15:14',10,0),('1','148',253216,'DAYLLY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-13 13:56:38','508','2022-01-13 13:57:15',10,0),('1','148',253361,'DAYLLY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-13 19:44:20','508','2022-01-13 19:45:05',10,0),('1','148',253481,'DAYLLY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-14 20:29:50','508','2022-01-14 20:42:59',10,0),('1','148',253723,'DAYLLY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-15 12:04:06','508','2022-01-15 12:05:35',10,0),('1','148',253809,'DAYLLY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-15 19:34:47','508','2022-01-15 19:35:58',10,0),('1','148',253964,'DAYLLY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-16 13:47:58','508','2022-01-16 13:48:47',10,0),('1','148',254110,'DAYLLY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-16 19:32:12','508','2022-01-16 19:33:37',10,0),('1','148',254207,'DAYLLY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-17 18:13:27','508','2022-01-17 18:14:12',10,0),('1','148',254453,'DAYLLY SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-18 20:14:43','508','2022-01-18 20:26:26',10,0),('1','148',254710,'DAYLLY SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-19 13:10:58','508','2022-01-19 13:11:24',10,0),('1','148',254826,'DAYLLY SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-19 20:54:45','508','2022-01-19 20:55:23',10,0),('1','148',254951,'DAYLLY SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-20 19:50:47','508','2022-01-20 19:52:00',10,0),('1','148',255212,'DAYLLY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-21 14:25:18','508','2022-01-21 14:26:29',10,0),('1','148',255325,'DAYLLY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-21 19:30:02','508','2022-01-21 19:30:44',10,0),('1','148',255466,'DAYLLY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-22 20:33:24','508','2022-01-22 20:37:21',10,0),('1','148',255747,'DAYLLY SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-23 10:24:20','508','2022-01-23 10:27:18',10,0),('1','148',255776,'DAYLLY SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-23 20:58:16','508','2022-01-23 20:59:00',10,0),('1','148',256006,'DAYLLY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-24 17:27:22','508','2022-01-24 17:28:50',10,0),('1','148',256126,'DAYLLY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-24 20:32:47','508','2022-01-24 20:44:49',10,0),('1','148',256247,'DAYLLY SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-25 20:14:54','508','2022-01-25 20:18:29',10,0),('1','148',256490,'DAYLLY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-26 13:08:58','508','2022-01-26 13:10:48',10,0),('1','148',256593,'DAYLLY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-27 06:18:45','508','2022-01-27 06:26:16',10,0),('1','148',256731,'DAYLLY SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-27 19:46:17','508','2022-01-27 19:47:17',10,0),('1','148',256961,'DAYLLY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-28 12:44:49','508','2022-01-28 12:45:29',10,0),('1','148',257106,'DAYLLY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-28 20:36:49','508','2022-01-28 20:38:21',10,0),('1','148',257237,'DAYLLY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-29 20:22:41','508','2022-01-29 20:23:57',10,0),('1','148',257520,'Daily','2022-01-30','2022-01-30 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-31 07:15:21','508','2022-01-31 07:15:41',10,0),('1','148',257521,'DAYLLY SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-31 14:33:41','508','2022-01-31 14:34:04',10,0),('1','148',257522,'DAYLLY SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'508',0.00,0.00,'508','2022-01-31 21:11:58','508','2022-01-31 21:12:18',10,0),('1','148',257523,'Daily','2022-02-01','2022-02-01 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-01 22:01:14','508','2022-02-01 22:01:59',10,0),('1','148',257524,'Daily','2022-02-02','2022-02-02 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-02 22:32:39','508','2022-02-02 22:33:01',10,0),('1','148',257525,'DAYLLY SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-03 09:15:19','508','2022-02-03 09:15:36',10,0),('1','148',257526,'DAYLLY SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-04 00:10:14','508','2022-02-04 00:10:35',10,0),('1','148',257527,'DAYLLY SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-04 11:20:17','508','2022-02-04 11:20:34',10,0),('1','148',257528,'DAYLLY SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-04 21:41:27','508','2022-02-04 21:41:54',10,0),('1','148',257529,'DAYLLY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-05 18:34:54','508','2022-02-05 18:35:15',10,0),('1','148',257530,'DAYLLY SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-06 21:08:21','508','2022-02-06 21:08:46',10,0),('1','148',257531,'DAYLLY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-07 12:45:58','508','2022-02-07 12:46:20',10,0),('1','148',257532,'DAYLLY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-07 19:59:37','508','2022-02-07 19:59:58',10,0),('1','148',257533,'DAYLLY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-08 11:25:03','508','2022-02-08 11:25:22',10,0),('1','148',257534,'DAYLLY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-08 20:09:17','508','2022-02-08 20:09:40',10,0),('1','148',257535,'DAYLLY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-09 16:30:29','508','2022-02-09 16:30:50',10,0),('1','148',257536,'DAYLLY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-09 19:49:46','508','2022-02-09 19:50:08',10,0),('1','148',257537,'DAYLLY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-10 19:34:17','508','2022-02-10 19:34:41',10,0),('1','148',257538,'DAYLLY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-11 11:05:01','508','2022-02-11 11:05:18',10,0),('1','148',257539,'DAYLLY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-11 19:33:01','508','2022-02-11 19:33:22',10,0),('1','148',257540,'DAYLLY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-12 16:25:07','508','2022-02-12 16:25:28',10,0),('1','148',257541,'DAYLLY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-13 19:19:34','508','2022-02-13 19:19:53',10,0),('1','148',257542,'DAYLLY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-14 16:32:26','508','2022-02-14 16:32:50',10,0),('1','148',257543,'DAYLLY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-15 19:30:38','508','2022-02-15 19:31:21',10,0),('1','148',257544,'DAYLLY SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-16 19:27:17','508','2022-02-16 19:27:59',10,0),('1','148',257545,'DAYLLY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-17 18:12:14','508','2022-02-17 18:12:35',10,0),('1','148',257546,'DAYLLY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-18 19:22:07','508','2022-02-18 19:22:29',10,0),('1','148',257547,'DAYLLY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-19 19:49:41','508','2022-02-19 19:49:59',10,0),('1','148',257548,'DAYLLY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-20 19:42:51','508','2022-02-20 19:44:37',10,0),('1','148',257549,'DAYLLY SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'508',0.00,0.00,'508','2022-02-21 19:15:23','508','2022-02-21 19:16:02',10,0),('1','148',257550,'Daily ','2022-02-22','2022-02-22 07:05:15','2022-02-23 07:05:15','508',0.00,0.00,'508','2022-02-22 19:30:46','508','2022-02-22 19:31:09',10,0),('1','148',257551,'DAYLLY SHIFT','2022-02-23','2022-02-23 07:19:09','2022-02-24 07:19:09','508',0.00,0.00,'508','2022-02-23 19:08:10','508','2022-02-23 19:09:30',10,0),('1','148',257552,'DAYLLY SHIFT','2022-02-24','2022-02-24 07:29:03','2022-02-25 07:29:03','508',0.00,0.00,'508','2022-02-24 19:38:59','508','2022-02-24 19:39:23',10,0),('1','148',257553,'DAYLLY SHIFT','2022-02-25','2022-02-25 15:00:23','2022-02-26 15:00:23','508',0.00,0.00,'508','2022-02-25 19:25:56','508','2022-02-25 19:26:13',10,0),('1','148',257554,'DAYLLY SHIFT','2022-02-26','2022-02-26 09:59:29','2022-02-27 09:59:29','508',0.00,0.00,'508','2022-02-26 16:17:17','508','2022-02-26 16:17:37',10,0),('1','148',257555,'DAYLLY SHIFT','2022-02-26','2022-02-26 16:20:28','2022-02-27 16:20:28','508',0.00,0.00,'508','2022-02-26 19:25:56','508','2022-02-26 19:27:04',10,0),('1','148',257556,'DAYLLY SHIFT','2022-02-27','2022-02-27 07:31:17','2022-02-28 07:31:17','508',0.00,0.00,'508','2022-02-27 19:20:53','508','2022-02-27 19:21:13',10,0),('1','148',257557,'DAYLLY SHIFT','2022-02-28','2022-02-28 07:16:06','2022-03-01 07:16:06','508',0.00,0.00,'508','2022-02-28 18:15:49','508','2022-02-28 18:16:16',10,0),('1','148',257558,'DAYLLY SHIFT','2022-03-01','2022-03-01 08:33:50','2022-03-02 08:33:50','508',0.00,0.00,'508','2022-03-01 19:35:32','508','2022-03-01 19:36:02',10,0),('1','148',257559,'DAYLLY SHIFT','2022-03-02','2022-03-02 07:07:46','2022-03-03 07:07:46','508',0.00,0.00,'508','2022-03-02 19:17:42','508','2022-03-02 19:17:59',10,0),('1','148',257560,'DAYLLY SHIFT','2022-03-03','2022-03-03 07:41:58','2022-03-04 07:41:58','508',0.00,0.00,'508','2022-03-03 18:52:27','508','2022-03-03 18:52:49',10,0),('1','148',257561,'DAYLLY SHIFT','2022-03-04','2022-03-04 09:19:53','2022-03-05 09:19:53','508',0.00,0.00,'508','2022-03-04 20:05:45','508','2022-03-04 20:06:12',10,0),('1','148',257562,'DAYLLY SHIFT','2022-03-05','2022-03-05 07:34:12','2022-03-06 07:34:12','508',0.00,0.00,'508','2022-03-05 20:04:49','508','2022-03-05 20:05:11',10,0),('1','148',257563,'DAYLLY SHIFT','2022-03-06','2022-03-06 07:10:49','2022-03-07 07:10:49','508',0.00,0.00,'508','2022-03-06 11:15:54','508','2022-03-06 11:16:13',10,0),('1','148',257564,'DAYLLY SHIFT','2022-03-06','2022-03-06 12:04:19','2022-03-07 12:04:19','508',0.00,0.00,'508','2022-03-06 21:25:03','508','2022-03-06 21:25:22',10,0),('1','148',257565,'DAYLLY SHIFT','2022-03-07','2022-03-07 08:12:35','2022-03-08 08:12:35','508',0.00,0.00,'508','2022-03-07 20:26:47','508','2022-03-07 20:27:06',10,0),('1','148',257566,'DAYLLY SHIFT','2022-03-08','2022-03-08 07:04:43','2022-03-09 07:04:43','508',0.00,0.00,'508','2022-03-08 14:38:50','508','2022-03-08 14:39:07',10,0),('1','148',257567,'DAYLLY SHIFT','2022-03-08','2022-03-08 14:39:39','2022-03-09 14:39:39','508',0.00,0.00,'508','2022-03-08 22:41:31','508','2022-03-08 22:41:48',10,0),('1','148',257568,'DAYLLY SHIFT','2022-03-09','2022-03-09 07:06:08','2022-03-10 07:06:08','508',0.00,0.00,'508','2022-03-09 19:27:32','508','2022-03-09 19:27:54',10,0),('1','148',257569,'DAYLLY SHIFT','2022-03-10','2022-03-10 07:29:25','2022-03-11 07:29:25','508',0.00,0.00,'508','2022-03-10 16:39:35','508','2022-03-10 16:39:55',10,0),('1','148',257570,'DAYLLY SHIFT','2022-03-11','2022-03-11 10:21:31','2022-03-12 10:21:31','508',0.00,0.00,'508','2022-03-11 22:31:34','508','2022-03-11 22:32:09',10,0),('1','148',257571,'DAYLLY SHIFT','2022-03-12','2022-03-12 08:22:37','2022-03-13 08:22:37','508',0.00,0.00,'508','2022-03-12 09:40:07','508','2022-03-12 09:40:23',10,0),('1','148',257572,'DAYLLY SHIFT','2022-03-12','2022-03-12 10:51:53','2022-03-13 10:51:53','508',0.00,0.00,'508','2022-03-12 21:14:10','508','2022-03-12 21:14:34',10,0),('1','148',257573,'DAYLLY SHIFT','2022-03-13','2022-03-13 07:37:26','2022-03-14 07:37:26','508',0.00,0.00,'508','2022-03-13 22:16:39','508','2022-03-13 22:17:01',10,0),('1','148',257574,'DAYLLY SHIFT','2022-03-14','2022-03-14 09:55:42','2022-03-15 09:55:42','508',0.00,0.00,'508','2022-03-14 17:21:24','508','2022-03-14 17:21:48',10,0),('1','148',257575,'DAYLLY SHIFT','2022-03-14','2022-03-14 17:25:43','2022-03-15 17:25:43','508',0.00,0.00,'508','2022-03-14 23:42:47','508','2022-03-14 23:43:09',10,0),('1','148',257576,'DAYLLY SHIFT','2022-03-15','2022-03-15 07:25:50','2022-03-16 07:25:50','508',0.00,0.00,'508','2022-03-15 21:11:27','508','2022-03-15 21:11:49',10,0),('1','148',257577,'DAYLLY SHIFT','2022-03-16','2022-03-16 07:48:58','2022-03-17 07:48:58','508',0.00,0.00,'508','2022-03-16 19:31:07','508','2022-03-16 19:31:27',10,0),('1','148',257578,'DAYLLY SHIFT','2022-03-17','2022-03-17 11:27:20','2022-03-18 11:27:20','508',0.00,0.00,'508','2022-03-17 19:22:39','508','2022-03-17 19:22:57',10,0),('1','148',257579,'DAYLLY SHIFT','2022-03-18','2022-03-18 08:12:35','2022-03-19 08:12:35','508',0.00,0.00,'508','2022-03-19 01:48:18','508','2022-03-19 01:48:38',10,0),('1','148',257580,'DAYLLY SHIFT','2022-03-19','2022-03-19 07:22:33','2022-03-20 07:22:33','508',0.00,0.00,'508','2022-03-19 10:29:25','508','2022-03-19 10:29:53',10,0),('1','148',257581,'DAYLLY SHIFT','2022-03-19','2022-03-19 11:36:27','2022-03-20 11:36:27','508',0.00,0.00,'508','2022-03-19 21:00:55','508','2022-03-19 21:01:12',10,0),('1','148',257582,'DAYLLY SHIFT','2022-03-20','2022-03-20 06:53:05','2022-03-21 06:53:05','508',0.00,0.00,'508','2022-03-20 19:57:54','508','2022-03-20 19:58:14',10,0),('1','148',257583,'DAYLLY SHIFT','2022-03-21','2022-03-21 10:10:16','2022-03-22 10:10:16','508',0.00,0.00,'508','2022-03-21 20:25:29','508','2022-03-21 20:25:47',10,0),('1','148',257584,'DAYLLY SHIFT','2022-03-22','2022-03-22 06:57:48','2022-03-23 06:57:48','508',0.00,0.00,'508','2022-03-22 11:43:16','508','2022-03-22 11:43:32',10,0),('1','148',257585,'DAYLLY SHIFT','2022-03-22','2022-03-22 11:46:25','2022-03-23 11:46:25','508',0.00,0.00,'508','2022-03-22 20:03:58','508','2022-03-22 20:04:17',10,0),('1','148',257586,'DAYLLY SHIFT','2022-03-23','2022-03-23 07:25:43','2022-03-24 07:25:43','508',0.00,0.00,'508','2022-03-23 19:21:25','508','2022-03-23 19:22:41',10,0),('1','148',257587,'DAYLLY SHIFT','2022-03-24','2022-03-24 07:16:24','2022-03-25 07:16:24','508',0.00,0.00,'508','2022-03-24 19:24:11','508','2022-03-24 19:24:31',10,0),('1','148',257588,'DAYLLY SHIFT','2022-03-25','2022-03-25 07:26:48','2022-03-26 07:26:48','508',0.00,0.00,'508','2022-03-25 19:46:20','508','2022-03-25 19:46:55',10,0),('1','148',257589,'DAYLLY SHIFT','2022-03-26','2022-03-26 09:53:17','2022-03-27 09:53:17','508',0.00,0.00,'508','2022-03-26 12:14:13','508','2022-03-26 12:14:39',10,0),('1','148',257590,'DAYLLY SHIFT','2022-03-26','2022-03-26 16:50:13','2022-03-27 16:50:13','508',0.00,0.00,'508','2022-03-26 19:35:23','508','2022-03-26 19:35:40',10,0),('1','148',257591,'DAYLLY SHIFT','2022-03-27','2022-03-27 07:35:20','2022-03-28 07:35:20','508',0.00,0.00,'508','2022-03-27 09:30:30','508','2022-03-27 09:30:55',10,0),('1','148',257592,'DAYLLY SHIFT','2022-03-27','2022-03-27 09:35:07','2022-03-28 09:35:07','508',0.00,0.00,'508','2022-03-27 19:33:42','508','2022-03-27 19:34:05',10,0),('1','148',257593,'DAYLLY SHIFT','2022-03-28','2022-03-28 09:48:17','2022-03-29 09:48:17','508',0.00,0.00,'508','2022-03-28 19:34:07','508','2022-03-28 19:34:25',10,0),('1','148',257594,'DAYLLY SHIFT','2022-03-29','2022-03-29 07:41:22','2022-03-30 07:41:22','508',0.00,0.00,'508','2022-03-29 10:28:19','508','2022-03-29 10:28:34',10,0),('1','148',257595,'DAYLLY SHIFT','2022-03-29','2022-03-29 15:05:46','2022-03-30 15:05:46','508',0.00,0.00,'508','2022-03-29 19:11:19','508','2022-03-29 19:12:47',10,0),('1','148',257596,'DAYLLY SHIFT','2022-03-30','2022-03-30 07:07:47','2022-03-31 07:07:47','508',0.00,0.00,'508','2022-03-30 19:31:33','508','2022-03-30 19:32:21',10,0),('1','148',257597,'DAYLLY SHIFT','2022-03-31','2022-03-31 07:05:09','2022-04-01 07:05:09','508',0.00,0.00,'508','2022-03-31 19:58:13','508','2022-03-31 19:58:41',10,0),('1','148',257598,'DAYLLY SHIFT','2022-04-01','2022-04-01 07:20:40','2022-04-02 07:20:40','508',0.00,0.00,'508','2022-04-01 19:16:30','508','2022-04-01 19:17:01',10,0),('1','148',257599,'DAYLLY SHIFT','2022-04-02','2022-04-02 08:50:59','2022-04-03 08:50:59','508',0.00,0.00,'508','2022-04-02 21:04:40','508','2022-04-02 21:05:00',10,0),('1','148',257600,'DAYLLY SHIFT','2022-04-03','2022-04-03 06:55:19','2022-04-04 06:55:19','508',0.00,0.00,'508','2022-04-03 17:15:41','508','2022-04-03 17:15:58',10,0),('1','148',257601,'DAYLLY SHIFT','2022-04-03','2022-04-03 17:42:32','2022-04-04 17:42:32','508',0.00,0.00,'508','2022-04-03 18:54:07','508','2022-04-03 18:54:26',10,0),('1','148',257602,'DAYLLY SHIFT','2022-04-04','2022-04-04 07:08:31','2022-04-05 07:08:31','508',0.00,0.00,'508','2022-04-04 22:11:48','508','2022-04-04 22:12:09',10,0),('1','148',257603,'DAYLLY SHIFT','2022-04-05','2022-04-05 07:09:11','2022-04-06 07:09:11','508',0.00,0.00,'508','2022-04-05 19:23:42','508','2022-04-05 19:24:00',10,0),('1','148',257604,'DAYLLY SHIFT','2022-04-06','2022-04-06 07:42:08','2022-04-07 07:42:08','508',0.00,0.00,'508','2022-04-06 14:00:05','508','2022-04-06 14:00:54',10,0),('1','148',257605,'DAYLLY SHIFT','2022-04-07','2022-04-07 07:18:26','2022-04-08 07:18:26','508',0.00,0.00,'508','2022-04-07 19:02:26','508','2022-04-07 19:03:04',10,0),('1','148',257606,'DAYLLY SHIFT','2022-04-08','2022-04-08 07:33:52','2022-04-09 07:33:52','508',0.00,0.00,'508','2022-04-08 20:30:15','508','2022-04-08 20:30:38',10,0),('1','148',257607,'DAYLLY SHIFT','2022-04-09','2022-04-09 08:15:22','2022-04-10 08:15:22','508',0.00,0.00,'508','2022-04-09 14:39:08','508','2022-04-09 14:39:28',10,0),('1','148',257608,'DAYLLY SHIFT','2022-04-09','2022-04-09 16:36:37','2022-04-10 16:36:37','508',0.00,0.00,'508','2022-04-09 19:03:29','508','2022-04-09 19:04:07',10,0),('1','148',257609,'DAYLLY SHIFT','2022-04-10','2022-04-10 07:17:13','2022-04-11 07:17:13','508',0.00,0.00,'508','2022-04-11 07:25:02','508','2022-04-11 07:26:00',10,0),('1','148',257610,'DAYLLY SHIFT','2022-04-11','2022-04-11 07:26:43','2022-04-12 07:26:43','508',0.00,0.00,'508','2022-04-11 15:54:44','508','2022-04-11 15:55:04',10,0),('1','148',257611,'DAYLLY SHIFT','2022-04-13','2022-04-13 16:33:39','2022-04-14 16:33:39','508',0.00,0.00,'508','2022-04-13 19:10:02','508','2022-04-13 19:10:36',10,0),('1','148',257612,'DAYLLY SHIFT','2022-04-14','2022-04-14 07:14:54','2022-04-15 07:14:54','508',0.00,0.00,'508','2022-04-15 11:26:11','508','2022-04-15 11:26:49',10,0),('1','148',257613,'DAYLLY SHIFT','2022-04-15','2022-04-15 11:28:09','2022-04-16 11:28:09','508',0.00,0.00,'508','2022-04-15 19:10:51','508','2022-04-15 19:11:17',10,0),('1','148',257614,'DAYLLY SHIFT','2022-04-16','2022-04-16 07:43:52','2022-04-17 07:43:52','508',0.00,0.00,'508','2022-04-16 09:23:48','508','2022-04-16 09:24:14',10,0),('1','148',257615,'DAYLLY SHIFT','2022-04-16','2022-04-16 17:48:32','2022-04-17 17:48:32','508',0.00,0.00,'508','2022-04-16 19:36:21','508','2022-04-16 19:36:46',10,0),('1','148',257616,'DAYLLY SHIFT','2022-04-17','2022-04-17 07:23:19','2022-04-18 07:23:19','508',0.00,0.00,'508','2022-04-17 18:57:44','508','2022-04-17 18:58:20',10,0),('1','148',257617,'DAYLLY SHIFT','2022-04-18','2022-04-18 07:14:37','2022-04-19 07:14:37','508',0.00,0.00,'508','2022-04-18 18:50:03','508','2022-04-18 18:51:08',10,0),('1','148',257618,'DAYLLY SHIFT','2022-04-19','2022-04-19 08:19:46','2022-04-20 08:19:46','508',0.00,0.00,'508','2022-04-19 19:25:11','508','2022-04-19 19:26:15',10,0),('1','148',257619,'DAYLLY SHIFT','2022-04-20','2022-04-20 18:04:54','2022-04-21 18:04:54','508',0.00,0.00,'508','2022-04-20 18:07:41','508','2022-04-20 18:10:10',10,0),('1','148',257620,'DAYLLY SHIFT','2022-04-21','2022-04-21 17:41:27','2022-04-22 17:41:27','508',0.00,0.00,'508','2022-04-21 17:44:34','508','2022-04-21 17:45:19',10,0),('1','148',257621,'DAYLLY SHIFT','2022-04-22','2022-04-22 19:16:03','2022-04-23 19:16:03','508',0.00,0.00,'508','2022-04-23 09:25:37','508','2022-04-23 09:26:23',10,0),('1','148',257622,'DAYLLY SHIFT','2022-04-23','2022-04-23 17:56:55','2022-04-24 17:56:55','508',0.00,0.00,'508','2022-04-23 17:58:31','508','2022-04-23 17:58:57',10,0),('1','148',257623,'DAYLLY SHIFT','2022-04-24','2022-04-24 12:42:02','2022-04-25 12:42:02','508',0.00,0.00,'508','2022-04-24 12:47:01','508','2022-04-24 12:47:47',10,0),('1','148',257624,'DAYLLY SHIFT','2022-04-24','2022-04-24 12:51:57','2022-04-25 12:51:57','508',0.00,0.00,'508','2022-04-24 19:28:24','508','2022-04-24 19:29:07',10,0),('1','148',257625,'DAYLLY SHIFT','2022-04-25','2022-04-25 19:24:27','2022-04-26 19:24:27','508',0.00,0.00,'508','2022-04-25 19:26:57','508','2022-04-25 19:27:51',10,0),('1','148',257626,'DAYLLY SHIFT','2022-04-26','2022-04-26 19:01:24','2022-04-27 19:01:24','508',0.00,0.00,'508','2022-04-27 10:30:11','508','2022-04-27 10:30:37',10,0),('1','148',257627,'DAYLLY SHIFT','2022-04-27','2022-04-27 10:31:04','2022-04-28 10:31:04','508',0.00,0.00,'508','2022-04-27 10:32:15','508','2022-04-27 10:32:31',10,0),('1','148',257628,'DAYLLY SHIFT','2022-04-07','2022-04-27 17:15:14','2022-04-28 17:15:14','508',0.00,0.00,'508','2022-04-27 17:19:21','508','2022-04-27 17:19:47',10,0),('1','148',257629,'DAYLLY SHIFT','2022-04-10','2022-04-27 17:20:33','2022-04-28 17:20:33','508',0.00,0.00,'508','2022-04-27 17:23:10','508','2022-04-27 17:23:38',10,0),('1','148',257630,'DAYLLY SHIFT','2022-04-16','2022-04-27 17:24:12','2022-04-28 17:24:12','508',0.00,0.00,'508','2022-04-27 17:26:34','508','2022-04-27 17:26:54',10,0),('1','148',257631,'DAYLLY SHIFT','2022-04-24','2022-04-27 17:27:33','2022-04-28 17:27:33','508',0.00,0.00,'508','2022-04-27 17:30:16','508','2022-04-27 17:30:38',10,0),('1','148',257632,'DAYLLY SHIFT','2022-04-27','2022-04-27 19:40:54','2022-04-28 19:40:54','508',0.00,0.00,'508','2022-04-28 10:14:50','508','2022-04-28 10:15:19',10,0),('1','148',257633,'DAYLLY SHIFT','2022-04-28','2022-04-28 16:55:38','2022-04-29 16:55:38','508',0.00,0.00,'508','2022-04-28 17:04:56','508','2022-04-28 17:05:13',10,0),('1','148',257634,'DAYLLY SHIFT','2022-04-28','2022-04-28 20:44:15','2022-04-29 20:44:15','508',0.00,0.00,'508','2022-04-28 21:56:20','508','2022-04-28 21:56:39',10,0),('1','148',257635,'DAYLLY SHIFT','2022-04-29','2022-04-29 07:38:42','2022-04-30 07:38:42','508',0.00,0.00,'508','2022-04-30 07:39:50','508','2022-04-30 07:40:20',10,0),('1','148',257636,'DAYLLY SHIFT','2022-04-30','2022-04-30 07:46:29','2022-05-01 07:46:29','508',0.00,0.00,'508','2022-04-30 20:53:36','508','2022-04-30 20:53:56',10,0),('1','148',257637,'DAYLLY SHIFT','2022-05-01','2022-05-01 07:47:34','2022-05-02 07:47:34','508',0.00,0.00,'508','2022-05-01 16:30:18','508','2022-05-01 16:30:37',10,0),('1','148',257638,'DAYLLY SHIFT','2022-05-02','2022-05-02 15:54:22','2022-05-03 15:54:22','508',0.00,0.00,'508','2022-05-02 18:34:05','508','2022-05-02 18:34:24',10,0),('1','148',257639,'DAYLLY SHIFT','2022-05-03','2022-05-03 07:31:39','2022-05-04 07:31:39','508',0.00,0.00,'508','2022-05-03 21:45:56','508','2022-05-03 21:46:13',10,0),('1','148',257640,'DAYLLY SHIFT','2022-05-04','2022-05-04 09:43:53','2022-05-05 09:43:53','508',0.00,0.00,'508','2022-05-05 08:53:57','508','2022-05-05 08:54:15',10,0),('1','148',257641,'DAYLLY SHIFT','2022-05-06','2022-05-06 07:59:26','2022-05-07 07:59:26','508',0.00,0.00,'508','2022-05-06 19:16:22','508','2022-05-06 19:16:49',10,0),('1','148',257642,'DAYLLY SHIFT','2022-05-07','2022-05-07 09:11:52','2022-05-08 09:11:52','508',0.00,0.00,'508','2022-05-07 20:14:52','508','2022-05-07 20:15:30',10,0),('1','148',257643,'DAYLLY SHIFT','2022-05-08','2022-05-08 09:11:03','2022-05-09 09:11:03','508',0.00,0.00,'508','2022-05-08 09:14:49','508','2022-05-08 09:15:35',10,0),('1','148',257644,'DAYLLY SHIFT','2022-05-08','2022-05-08 16:50:35','2022-05-09 16:50:35','508',0.00,0.00,'508','2022-05-08 19:57:03','508','2022-05-08 19:57:44',10,0),('1','148',257645,'DAYLLY SHIFT','2022-05-09','2022-05-09 08:03:56','2022-05-10 08:03:56','508',0.00,0.00,'508','2022-05-09 19:35:05','508','2022-05-09 19:35:50',10,0),('1','148',257646,'DAYLLY SHIFT','2022-05-10','2022-05-10 06:21:26','2022-05-11 06:21:26','508',0.00,0.00,'508','2022-05-10 19:26:07','508','2022-05-10 19:26:33',10,0),('1','148',257647,'DAYLLY SHIFT','2022-05-11','2022-05-11 06:21:28','2022-05-12 06:21:28','508',0.00,0.00,'508','2022-05-11 08:28:00','508','2022-05-11 08:29:23',10,0),('1','148',257648,'operational loss','2022-05-12','2022-05-12 17:03:37','2022-05-13 17:03:37','508',0.00,0.00,'508','2022-05-12 17:10:43','508','2022-05-12 17:11:23',10,0),('1','148',257649,'DAYLLY SHIFT','2022-05-12','2022-05-12 17:38:45','2022-05-13 17:38:45','508',0.00,0.00,'508','2022-05-12 19:39:33','508','2022-05-12 19:40:09',10,0),('1','148',257650,'DAYLLY SHIFT','2022-05-13','2022-05-13 06:25:24','2022-05-14 06:25:24','508',0.00,0.00,'508','2022-05-13 18:59:12','508','2022-05-13 18:59:40',10,0),('1','148',257651,'DAYLLY SHIFT','2022-05-14','2022-05-14 06:31:30','2022-05-15 06:31:30','508',0.00,0.00,'508','2022-05-14 19:32:48','508','2022-05-14 19:33:14',10,0),('1','148',257652,'DAYLLY SHIFT','2022-05-15','2022-05-15 06:30:19','2022-05-16 06:30:19','508',0.00,0.00,'508','2022-05-15 08:14:13','508','2022-05-15 08:15:30',10,0),('1','148',257653,'DAYLLY SHIFT','2022-05-15','2022-05-15 08:16:38','2022-05-16 08:16:38','508',0.00,0.00,'508','2022-05-15 09:43:53','508','2022-05-15 09:44:17',10,0),('1','148',257654,'operational loss','2022-05-18','2022-05-18 13:22:56','2022-05-19 13:22:56','508',0.00,0.00,'508','2022-05-18 13:31:14','508','2022-05-18 13:31:40',10,0),('1','148',257655,'DAYLLY SHIFT','2022-05-18','2022-05-18 14:30:04','2022-05-19 14:30:04','508',0.00,0.00,'508','2022-05-18 19:17:14','508','2022-05-18 19:26:32',10,0),('1','148',257656,'DAYLLY SHIFT','2022-05-19','2022-05-19 06:35:51','2022-05-20 06:35:51','508',0.00,0.00,'508','2022-05-19 19:43:29','508','2022-05-19 19:43:55',10,0),('1','148',257657,'DAYLLY SHIFT','2022-05-20','2022-05-20 06:41:00','2022-05-21 06:41:00','508',0.00,0.00,'508','2022-05-20 14:55:43','508','2022-05-20 14:56:06',10,0),('1','148',257658,'DAYLLY SHIFT','2022-05-21','2022-05-21 14:37:03','2022-05-22 14:37:03','508',0.00,0.00,'508','2022-05-21 19:28:33','508','2022-05-21 19:29:18',10,0),('1','148',257659,'DAYLLY SHIFT','2022-05-22','2022-05-22 06:30:03','2022-05-23 06:30:03','508',0.00,0.00,'508','2022-05-22 19:29:56','508','2022-05-22 19:30:18',10,0),('1','148',257660,'DAYLLY SHIFT','2022-05-23','2022-05-23 08:47:42','2022-05-24 08:47:42','508',0.00,0.00,'508','2022-05-23 19:49:04','508','2022-05-23 19:49:24',10,0),('1','148',257661,'DAYLLY SHIFT','2022-05-24','2022-05-24 06:14:18','2022-05-25 06:14:18','508',0.00,0.00,'508','2022-05-24 19:35:28','508','2022-05-24 19:37:15',10,0),('1','148',257662,'DAYLLY SHIFT','2022-05-25','2022-05-25 06:30:13','2022-05-26 06:30:13','508',0.00,0.00,'508','2022-05-25 19:42:56','508','2022-05-25 19:43:30',10,0),('1','148',257663,'DAYLLY SHIFT','2022-05-26','2022-05-26 12:50:32','2022-05-27 12:50:32','508',0.00,0.00,'508','2022-05-26 19:41:56','508','2022-05-26 19:42:54',10,0),('1','148',257664,'DAYLLY SHIFT','2022-05-27','2022-05-27 06:25:52','2022-05-28 06:25:52','508',0.00,0.00,'508','2022-05-27 19:26:51','508','2022-05-27 19:27:15',10,0),('1','148',257665,'DAYLLY SHIFT','2022-05-28','2022-05-28 09:46:04','2022-05-29 09:46:04','508',0.00,0.00,'508','2022-05-28 17:40:16','508','2022-05-28 17:40:45',10,0),('1','148',257666,'DAYLLY SHIFT','2022-05-29','2022-05-29 16:03:38','2022-05-30 16:03:38','508',0.00,0.00,'508','2022-05-29 19:38:53','508','2022-05-29 19:39:17',10,0),('1','148',257667,'DAYLLY SHIFT','2022-05-30','2022-05-30 06:50:02','2022-05-31 06:50:02','508',0.00,0.00,'508','2022-05-30 19:17:34','508','2022-05-30 19:17:56',10,0),('1','148',257668,'DAYLLY SHIFT','2022-05-31','2022-05-31 06:27:38','2022-06-01 06:27:38','508',0.00,0.00,'508','2022-06-01 06:40:52','508','2022-06-01 06:41:45',10,0),('1','148',257669,'DAYLLY SHIFT','2022-06-01','2022-06-01 06:42:25','2022-06-02 06:42:25','508',0.00,0.00,'508','2022-06-01 07:15:53','508','2022-06-01 07:16:31',10,0),('1','148',257670,'operational loss','2022-06-01','2022-06-01 17:28:29','2022-06-02 17:28:29','508',0.00,0.00,'508','2022-06-02 11:22:46','508','2022-06-02 11:23:07',10,0),('1','148',257671,'DAYLLY SHIFT','2022-06-02','2022-06-02 12:02:07','2022-06-03 12:02:07','508',0.00,0.00,'508','2022-06-02 20:14:00','508','2022-06-02 20:14:21',10,0),('1','148',257672,'DAYLLY SHIFT','2022-06-03','2022-06-03 06:34:30','2022-06-04 06:34:30','508',0.00,0.00,'508','2022-06-03 19:32:30','508','2022-06-03 19:32:51',10,0),('1','148',257673,'DAYLLY SHIFT','2022-06-04','2022-06-04 06:02:46','2022-06-05 06:02:46','508',0.00,0.00,'508','2022-06-04 12:43:57','508','2022-06-04 12:44:16',10,0),('1','148',257674,'operational loss','2022-06-06','2022-06-06 08:44:49','2022-06-07 08:44:49','508',0.00,0.00,'508','2022-06-06 09:23:36','508','2022-06-06 09:23:57',10,0),('1','148',257675,'operational loss','2022-06-06','2022-06-06 09:24:24','2022-06-07 09:24:24','508',0.00,0.00,'508','2022-06-06 19:22:08','508','2022-06-06 19:22:33',10,0),('1','148',257676,'DAYLLY SHIFT','2022-06-07','2022-06-07 06:33:38','2022-06-08 06:33:38','508',0.00,0.00,'508','2022-06-07 19:18:21','508','2022-06-07 19:18:45',10,0),('1','148',257677,'DAYLLY SHIFT','2022-06-08','2022-06-08 06:30:00','2022-06-09 06:30:00','508',0.00,0.00,'508','2022-06-08 18:56:01','508','2022-06-08 18:56:22',10,0),('1','148',257678,'DAYLLY SHIFT','2022-06-10','2022-06-10 08:57:25','2022-06-11 08:57:25','508',0.00,0.00,'508','2022-06-10 19:08:05','508','2022-06-10 19:08:27',10,0),('1','148',257679,'DAYLLY SHIFT','2022-06-11','2022-06-11 06:52:00','2022-06-12 06:52:00','508',0.00,0.00,'508','2022-06-11 19:39:58','508','2022-06-11 19:40:30',10,0),('1','148',257680,'DAYLLY SHIFT','2022-06-12','2022-06-12 06:21:52','2022-06-13 06:21:52','508',0.00,0.00,'508','2022-06-12 13:48:44','508','2022-06-12 13:49:08',10,0),('1','148',257681,'DAYLLY SHIFT','2022-06-12','2022-06-12 13:49:33','2022-06-13 13:49:33','508',0.00,0.00,'508','2022-06-12 19:19:37','508','2022-06-12 19:19:59',10,0),('1','148',257682,'DAYLLY SHIFT','2022-06-13','2022-06-13 08:23:30','2022-06-14 08:23:30','508',0.00,0.00,'508','2022-06-13 19:37:07','508','2022-06-13 19:37:34',10,0),('1','148',257683,'DAYLLY SHIFT','2022-06-14','2022-06-14 06:04:15','2022-06-15 06:04:15','508',0.00,0.00,'508','2022-06-14 13:45:19','508','2022-06-14 13:45:41',10,0),('1','148',257684,'DAYLLY SHIFT','2022-06-15','2022-06-15 17:14:12','2022-06-16 17:14:12','508',0.00,0.00,'508','2022-06-15 19:24:36','508','2022-06-15 19:25:53',10,0),('1','148',257685,'DAYLLY SHIFT','2022-06-16','2022-06-16 06:32:16','2022-06-17 06:32:16','508',0.00,0.00,'508','2022-06-16 19:28:20','508','2022-06-16 19:28:52',10,0),('1','148',257686,'DAYLLY SHIFT','2022-06-17','2022-06-17 07:58:09','2022-06-18 07:58:09','508',0.00,0.00,'508','2022-06-17 19:32:27','508','2022-06-17 19:32:52',10,0),('1','148',257687,'DAYLLY SHIFT','2022-06-18','2022-06-18 06:16:57','2022-06-19 06:16:57','508',0.00,0.00,'508','2022-06-18 19:16:45','508','2022-06-18 19:17:08',10,0),('1','148',257688,'DAYLLY SHIFT','2022-06-19','2022-06-19 09:03:34','2022-06-20 09:03:34','508',0.00,0.00,'508','2022-06-19 19:49:51','508','2022-06-19 19:50:15',10,0),('1','148',257689,'DAYLLY SHIFT','2022-06-20','2022-06-20 06:33:00','2022-06-21 06:33:00','508',0.00,0.00,'508','2022-06-20 19:10:18','508','2022-06-20 19:10:40',10,0),('1','148',257690,'DAYLLY SHIFT','2022-06-21','2022-06-21 06:23:03','2022-06-22 06:23:03','508',0.00,0.00,'508','2022-06-21 12:58:30','508','2022-06-21 12:59:23',10,0),('1','148',257691,'DAYLLY SHIFT','2022-06-21','2022-06-21 13:59:36','2022-06-22 13:59:36','508',0.00,0.00,'508','2022-06-21 19:35:32','508','2022-06-21 19:35:56',10,0),('1','148',257692,'DAYLLY SHIFT','2022-06-22','2022-06-22 06:15:14','2022-06-23 06:15:14','508',0.00,0.00,'508','2022-06-22 19:39:56','508','2022-06-22 19:40:18',10,0),('1','148',257693,'DAYLLY SHIFT','2022-06-23','2022-06-23 07:02:22','2022-06-24 07:02:22','508',0.00,0.00,'508','2022-06-23 19:00:10','508','2022-06-23 19:00:30',10,0),('1','148',257694,'DAYLLY SHIFT','2022-06-24','2022-06-24 07:11:04','2022-06-25 07:11:04','508',0.00,0.00,'508','2022-06-24 12:55:05','508','2022-06-24 12:55:31',10,0),('1','148',257695,'DAYLLY SHIFT','2022-06-24','2022-06-24 13:32:46','2022-06-25 13:32:46','508',0.00,0.00,'508','2022-06-24 19:14:56','508','2022-06-24 19:15:40',10,0),('1','148',257696,'DAYLLY SHIFT','2022-06-25','2022-06-25 09:40:24','2022-06-26 09:40:24','508',0.00,0.00,'508','2022-06-25 19:22:48','508','2022-06-25 19:23:08',10,0),('1','148',257697,'DAYLLY SHIFT','2022-06-26','2022-06-26 06:50:20','2022-06-27 06:50:20','508',0.00,0.00,'508','2022-06-26 18:39:48','508','2022-06-26 18:40:27',10,0),('1','148',257698,'DAYLLY SHIFT','2022-06-27','2022-06-27 06:34:27','2022-06-28 06:34:27','508',0.00,0.00,'508','2022-06-27 19:09:54','508','2022-06-27 19:10:28',10,0),('1','148',257699,'DAYLLY SHIFT','2022-06-28','2022-06-28 06:07:41','2022-06-29 06:07:41','508',0.00,0.00,'508','2022-06-28 19:13:28','508','2022-06-28 19:13:54',10,0),('1','148',257700,'DAYLLY SHIFT','2022-06-29','2022-06-29 19:17:28','2022-06-30 19:17:28','508',0.00,0.00,'508','2022-06-29 19:24:19','508','2022-06-29 19:24:38',10,0),('1','148',257701,'DAYLLY SHIFT','2022-06-30','2022-06-30 12:07:40','2022-07-01 12:07:40','508',0.00,0.00,'508','2022-06-30 19:07:02','508','2022-06-30 19:07:31',10,0),('1','148',257702,'DAYLLY SHIFT','2022-07-01','2022-07-01 11:09:21','2022-07-02 11:09:21','508',0.00,0.00,'508','2022-07-01 19:31:21','508','2022-07-01 19:31:44',10,0),('1','148',257703,'DAYLLY SHIFT','2022-07-02','2022-07-02 06:13:05','2022-07-03 06:13:05','508',0.00,0.00,'508','2022-07-02 18:19:34','508','2022-07-02 18:19:59',10,0),('1','148',257704,'DAYLLY SHIFT','2022-07-03','2022-07-03 08:19:10','2022-07-04 08:19:10','508',0.00,0.00,'508','2022-07-03 19:43:32','508','2022-07-03 19:43:59',10,0),('1','148',257705,'DAYLLY SHIFT','2022-07-04','2022-07-04 06:29:52','2022-07-05 06:29:52','508',0.00,0.00,'508','2022-07-04 19:44:24','508','2022-07-04 19:44:48',10,0),('1','148',257706,'DAYLLY SHIFT','2022-07-05','2022-07-05 07:16:58','2022-07-06 07:16:58','508',0.00,0.00,'508','2022-07-05 15:50:10','508','2022-07-05 15:50:35',10,0),('1','148',257707,'DAYLLY SHIFT','2022-07-05','2022-07-05 16:00:44','2022-07-06 16:00:44','508',0.00,0.00,'508','2022-07-05 19:16:17','508','2022-07-05 19:16:40',10,0),('1','148',257708,'DAYLLY SHIFT','2022-07-06','2022-07-06 06:44:08','2022-07-07 06:44:08','508',0.00,0.00,'508','2022-07-06 19:36:44','508','2022-07-06 19:37:09',10,0),('1','148',257709,'DAYLLY SHIFT','2022-07-07','2022-07-07 06:45:23','2022-07-08 06:45:23','508',0.00,0.00,'508','2022-07-07 19:08:00','508','2022-07-07 19:08:23',10,0),('1','148',257710,'DAYLLY SHIFT','2022-07-08','2022-07-08 07:03:02','2022-07-09 07:03:02','508',0.00,0.00,'508','2022-07-08 16:50:09','508','2022-07-08 16:50:34',10,0),('1','148',257711,'DAYLLY SHIFT','2022-07-08','2022-07-08 17:02:48','2022-07-09 17:02:48','508',0.00,0.00,'508','2022-07-08 19:28:14','508','2022-07-08 19:28:37',10,0),('1','148',257712,'DAYLLY SHIFT','2022-07-09','2022-07-09 10:52:49','2022-07-10 10:52:49','508',0.00,0.00,'508','2022-07-09 18:02:31','508','2022-07-09 18:03:01',10,0),('1','148',257713,'DAYLLY SHIFT','2022-07-10','2022-07-10 07:16:38','2022-07-11 07:16:38','508',0.00,0.00,'508','2022-07-10 17:06:41','508','2022-07-10 17:07:16',10,0),('1','148',257714,'DAYLLY SHIFT','2022-07-14','2022-07-14 11:55:16','2022-07-15 11:55:16','508',0.00,0.00,'508','2022-07-14 19:32:22','508','2022-07-14 19:32:52',10,0),('1','148',257715,'DAYLLY SHIFT','2022-07-15','2022-07-15 07:03:25','2022-07-16 07:03:25','508',0.00,0.00,'508','2022-07-15 19:21:05','508','2022-07-15 19:21:32',10,0),('1','148',257716,'DAYLLY SHIFT','2022-07-16','2022-07-16 06:45:57','2022-07-17 06:45:57','508',0.00,0.00,'508','2022-07-16 18:02:39','508','2022-07-16 18:03:01',10,0),('1','148',257717,'DAYLLY SHIFT','2022-07-17','2022-07-17 09:08:12','2022-07-18 09:08:12','508',0.00,0.00,'508','2022-07-17 19:20:50','508','2022-07-17 19:21:18',10,0),('1','148',257718,'DAYLLY SHIFT','2022-07-18','2022-07-18 06:42:31','2022-07-19 06:42:31','508',0.00,0.00,'508','2022-07-18 19:46:54','508','2022-07-18 19:47:17',10,0),('1','148',257719,'DAYLLY SHIFT','2022-07-19','2022-07-19 06:12:41','2022-07-20 06:12:41','508',0.00,0.00,'508','2022-07-19 19:33:27','508','2022-07-19 19:33:47',10,0),('1','148',257720,'DAYLLY SHIFT','2022-07-20','2022-07-20 06:07:08','2022-07-21 06:07:08','508',0.00,0.00,'508','2022-07-20 12:34:19','508','2022-07-20 12:34:47',10,0),('1','148',257721,'DAYLLY SHIFT','2022-07-20','2022-07-20 17:15:42','2022-07-21 17:15:42','508',0.00,0.00,'508','2022-07-20 19:37:25','508','2022-07-20 19:37:52',10,0),('1','148',257722,'DAYLLY SHIFT','2022-07-21','2022-07-21 07:06:36','2022-07-22 07:06:36','508',0.00,0.00,'508','2022-07-21 19:28:33','508','2022-07-21 19:28:56',10,0),('1','148',257723,'DAYLLY SHIFT','2022-07-22','2022-07-22 07:56:59','2022-07-23 07:56:59','508',0.00,0.00,'508','2022-07-22 19:21:53','508','2022-07-22 19:22:17',10,0),('1','148',257724,'DAYLLY SHIFT','2022-07-23','2022-07-23 06:58:30','2022-07-24 06:58:30','508',0.00,0.00,'508','2022-07-23 18:51:57','508','2022-07-23 18:52:20',10,0),('1','148',257725,'DAYLLY SHIFT','2022-07-24','2022-07-24 06:24:39','2022-07-25 06:24:39','508',0.00,0.00,'508','2022-07-24 19:59:50','508','2022-07-24 20:00:10',10,0),('1','148',257726,'DAYLLY SHIFT','2022-07-25','2022-07-25 06:31:48','2022-07-26 06:31:48','508',0.00,0.00,'508','2022-07-25 19:10:15','508','2022-07-25 19:10:39',10,0),('1','148',257727,'DAYLLY SHIFT','2022-07-26','2022-07-26 06:22:14','2022-07-27 06:22:14','508',0.00,0.00,'508','2022-07-26 19:21:37','508','2022-07-26 19:22:11',10,0),('1','148',257728,'DAYLLY SHIFT','2022-07-27','2022-07-27 06:42:23','2022-07-28 06:42:23','508',0.00,0.00,'508','2022-07-27 12:18:12','508','2022-07-27 12:18:41',10,0),('1','148',257729,'DAYLLY SHIFT','2022-07-27','2022-07-27 12:19:29','2022-07-28 12:19:29','508',0.00,0.00,'508','2022-07-27 19:44:55','508','2022-07-27 19:45:23',10,0),('1','148',257730,'DAYLLY SHIFT','2022-07-28','2022-07-28 06:56:46','2022-07-29 06:56:46','508',0.00,0.00,'508','2022-07-28 19:46:14','508','2022-07-28 19:46:43',10,0),('1','148',257731,'DAYLLY SHIFT','2022-07-29','2022-07-29 06:54:10','2022-07-30 06:54:10','508',0.00,0.00,'508','2022-07-29 19:16:09','508','2022-07-29 19:16:31',10,0),('1','148',257732,'DAYLLY SHIFT','2022-07-30','2022-07-30 09:08:05','2022-07-31 09:08:05','508',0.00,0.00,'508','2022-07-30 16:28:44','508','2022-07-30 16:29:18',10,0),('1','148',257733,'DAYLLY SHIFT','2022-07-30','2022-07-30 16:30:08','2022-07-31 16:30:08','508',0.00,0.00,'508','2022-07-31 06:25:18','508','2022-07-31 06:25:51',10,0),('1','148',257734,'DAYLLY SHIFT','2022-07-31','2022-07-31 06:26:27','2022-08-01 06:26:27','508',0.00,0.00,'508','2022-07-31 21:02:33','508','2022-07-31 21:02:52',10,0),('1','148',257735,'DAYLLY SHIFT','2022-08-01','2022-08-01 06:58:37','2022-08-02 06:58:37','508',0.00,0.00,'508','2022-08-01 19:42:04','508','2022-08-01 19:42:24',10,0),('1','148',257736,'DAYLLY SHIFT','2022-08-02','2022-08-02 07:06:12','2022-08-03 07:06:12','508',0.00,0.00,'508','2022-08-02 11:23:36','508','2022-08-02 11:24:25',10,0),('1','148',257737,'DAYLLY SHIFT','2022-08-02','2022-08-02 15:48:43','2022-08-03 15:48:43','508',0.00,0.00,'508','2022-08-02 19:39:49','508','2022-08-02 19:40:07',10,0),('1','148',257738,'DAYLLY SHIFT','2022-08-03','2022-08-03 06:10:44','2022-08-04 06:10:44','508',0.00,0.00,'508','2022-08-03 20:10:40','508','2022-08-03 20:10:58',10,0),('1','148',257739,'DAYLLY SHIFT','2022-08-04','2022-08-04 06:40:37','2022-08-05 06:40:37','508',0.00,0.00,'508','2022-08-04 20:08:55','508','2022-08-04 20:09:13',10,0),('1','148',257740,'DAYLLY SHIFT','2022-08-05','2022-08-05 12:39:36','2022-08-06 12:39:36','508',0.00,0.00,'508','2022-08-06 13:26:25','508','2022-08-06 13:26:57',10,0),('1','148',257741,'DAYLLY SHIFT','2022-08-06','2022-08-06 13:27:54','2022-08-07 13:27:54','508',0.00,0.00,'508','2022-08-06 20:09:33','508','2022-08-06 20:09:54',10,0),('1','148',257742,'DAYLLY SHIFT','2022-08-07','2022-08-07 06:32:55','2022-08-08 06:32:55','508',0.00,0.00,'508','2022-08-07 20:32:28','508','2022-08-07 20:32:53',10,0),('1','148',257743,'DAYLLY SHIFT','2022-08-08','2022-08-08 06:00:05','2022-08-09 06:00:05','508',0.00,0.00,'508','2022-08-08 19:11:39','508','2022-08-08 19:12:11',10,0),('1','148',257744,'DAYLLY SHIFT','2022-08-10','2022-08-10 06:43:45','2022-08-11 06:43:45','508',0.00,0.00,'508','2022-08-10 14:16:42','508','2022-08-10 14:17:04',10,0),('1','148',257745,'DAYLLY SHIFT','2022-08-11','2022-08-11 10:06:19','2022-08-12 10:06:19','508',0.00,0.00,'508','2022-08-11 19:40:18','508','2022-08-11 19:40:42',10,0),('1','148',257746,'DAYLLY SHIFT','2022-08-12','2022-08-12 06:38:14','2022-08-13 06:38:14','508',0.00,0.00,'508','2022-08-12 19:32:36','508','2022-08-12 19:32:57',10,0),('1','148',257747,'DAYLLY SHIFT','2022-08-13','2022-08-13 12:04:30','2022-08-14 12:04:30','508',0.00,0.00,'508','2022-08-13 17:02:54','508','2022-08-13 17:03:59',10,0),('1','148',257748,'DAYLLY SHIFT','2022-08-14','2022-08-14 13:16:25','2022-08-15 13:16:25','508',0.00,0.00,'508','2022-08-14 19:08:11','508','2022-08-14 19:08:42',10,0),('1','148',257749,'DAYLLY SHIFT','2022-08-15','2022-08-15 07:58:20','2022-08-16 07:58:20','508',0.00,0.00,'508','2022-08-15 11:35:58','508','2022-08-15 11:37:01',10,0),('1','148',257750,'DAYLLY SHIFT','2022-08-15','2022-08-15 15:25:45','2022-08-16 15:25:45','508',0.00,0.00,'508','2022-08-15 19:08:12','508','2022-08-15 19:08:34',10,0),('1','148',257751,'DAYLLY SHIFT','2022-08-16','2022-08-16 06:43:34','2022-08-17 06:43:34','508',0.00,0.00,'508','2022-08-16 19:26:43','508','2022-08-16 19:27:19',10,0),('1','148',257752,'DAYLLY SHIFT','2022-08-17','2022-08-17 08:48:00','2022-08-18 08:48:00','508',0.00,0.00,'508','2022-08-17 19:09:32','508','2022-08-17 19:09:55',10,0),('1','148',257753,'DAYLLY SHIFT','2022-08-18','2022-08-18 06:46:21','2022-08-19 06:46:21','508',0.00,0.00,'508','2022-08-18 10:55:50','508','2022-08-18 10:56:25',10,0),('1','148',257754,'DAYLLY SHIFT','2022-08-18','2022-08-18 12:06:44','2022-08-19 12:06:44','508',0.00,0.00,'508','2022-08-18 19:00:13','508','2022-08-18 19:01:30',10,0),('1','148',257755,'DAYLLY SHIFT','2022-08-19','2022-08-19 06:36:13','2022-08-20 06:36:13','508',0.00,0.00,'508','2022-08-19 18:54:02','508','2022-08-19 18:54:24',10,0),('1','148',257756,'DAYLLY SHIFT','2022-08-20','2022-08-20 06:25:52','2022-08-21 06:25:52','508',0.00,0.00,'508','2022-08-20 19:10:23','508','2022-08-20 19:10:48',10,0),('1','148',257757,'DAYLLY SHIFT','2022-08-21','2022-08-21 07:08:17','2022-08-22 07:08:17','508',0.00,0.00,'508','2022-08-21 11:29:28','508','2022-08-21 11:30:01',10,0),('1','148',257758,'OPERATIONAL LOSS','2022-08-21','2022-08-21 12:06:29','2022-08-22 12:06:29','508',0.00,0.00,'508','2022-08-21 12:23:12','508','2022-08-21 12:23:30',10,0),('1','148',257759,'DAILY SHIFT ','2022-08-21','2022-08-21 13:23:52','2022-08-22 13:23:52','508',0.00,0.00,'508','2022-08-21 19:09:21','508','2022-08-21 19:09:51',10,0),('1','148',257760,'DAILY SHIFT ','2022-08-22','2022-08-22 07:06:42','2022-08-23 07:06:42','508',0.00,0.00,'508','2022-08-22 18:47:33','508','2022-08-22 18:48:15',10,0),('1','148',257761,'DAILY SALE','2022-08-23','2022-08-23 06:48:14','2022-08-24 06:48:14','508',0.00,0.00,'508','2022-08-23 19:11:36','508','2022-08-23 19:12:30',10,0),('1','148',257762,'DAILY SALE','2022-08-24','2022-08-24 06:44:36','2022-08-25 06:44:36','508',0.00,0.00,'508','2022-08-24 09:54:03','508','2022-08-24 09:54:23',10,0),('1','148',257763,'DAILY SALE','2022-08-24','2022-08-24 12:50:00','2022-08-25 12:50:00','508',0.00,0.00,'508','2022-08-24 19:45:21','508','2022-08-24 19:45:43',10,0),('1','148',257764,'DAILY SALE','2022-08-25','2022-08-25 06:45:07','2022-08-26 06:45:07','508',0.00,0.00,'508','2022-08-25 19:53:25','508','2022-08-25 19:53:49',10,0),('1','148',257765,'DAILY SALE','2022-08-26','2022-08-26 06:34:10','2022-08-27 06:34:10','508',0.00,0.00,'508','2022-08-26 19:43:54','508','2022-08-26 19:44:28',10,0),('1','148',257766,'DAILY SALE','2022-08-27','2022-08-27 08:58:23','2022-08-28 08:58:23','508',0.00,0.00,'508','2022-08-27 10:34:49','508','2022-08-27 10:35:12',10,0),('1','148',257767,'DAILY SALE','2022-08-27','2022-08-27 14:49:54','2022-08-28 14:49:54','508',0.00,0.00,'508','2022-08-27 19:27:49','508','2022-08-27 19:28:15',10,0),('1','148',257768,'DAILY SALE','2022-08-28','2022-08-28 07:18:26','2022-08-29 07:18:26','508',0.00,0.00,'508','2022-08-28 20:01:24','508','2022-08-28 20:01:49',10,0),('1','148',257769,'DAILY SALE','2022-08-29','2022-08-29 06:28:09','2022-08-30 06:28:09','508',0.00,0.00,'508','2022-08-29 14:23:42','508','2022-08-29 14:24:07',10,0),('1','148',257770,'DAILY SALE','2022-08-29','2022-08-29 14:27:02','2022-08-30 14:27:02','508',0.00,0.00,'508','2022-08-29 19:52:23','508','2022-08-29 19:52:42',10,0),('1','148',257771,'DAILY SALE','2022-08-30','2022-08-30 06:28:06','2022-08-31 06:28:06','508',0.00,0.00,'508','2022-08-30 19:53:27','508','2022-08-30 19:53:50',10,0),('1','148',257772,'DAILY SALE','2022-08-31','2022-08-31 06:56:02','2022-09-01 06:56:02','508',0.00,0.00,'508','2022-08-31 19:37:01','508','2022-08-31 19:37:27',10,0),('1','148',257773,'DAILY SALE','2022-09-01','2022-09-01 06:29:09','2022-09-02 06:29:09','508',0.00,0.00,'508','2022-09-01 17:06:36','508','2022-09-01 17:06:56',10,0),('1','148',257774,'DAILY SALE','2022-09-02','2022-09-02 06:55:56','2022-09-03 06:55:56','508',0.00,0.00,'508','2022-09-02 19:17:27','508','2022-09-02 19:17:50',10,0),('1','148',257775,'DAILY SALE','2022-09-03','2022-09-03 07:06:10','2022-09-04 07:06:10','508',0.00,0.00,'508','2022-09-03 20:27:10','508','2022-09-03 20:27:37',10,0),('1','148',257776,'DAILY SALE','2022-09-04','2022-09-04 06:27:07','2022-09-05 06:27:07','508',0.00,0.00,'508','2022-09-04 07:41:39','508','2022-09-04 07:41:56',10,0),('1','148',257777,'DAILY SALE','2022-09-04','2022-09-04 11:00:23','2022-09-05 11:00:23','508',0.00,0.00,'508','2022-09-04 18:59:16','508','2022-09-04 18:59:35',10,0),('1','148',257778,'DAILY SALE','2022-09-05','2022-09-05 06:40:15','2022-09-06 06:40:15','508',0.00,0.00,'508','2022-09-05 17:06:09','508','2022-09-05 17:06:32',10,0),('1','148',257779,'DAILY SALE','2022-09-06','2022-09-06 08:52:29','2022-09-07 08:52:29','508',0.00,0.00,'508','2022-09-06 18:57:48','508','2022-09-06 18:58:09',10,0),('1','148',257780,'DAILY SALE','2022-09-07','2022-09-07 06:36:14','2022-09-08 06:36:14','508',0.00,0.00,'508','2022-09-07 22:20:32','508','2022-09-07 22:20:54',10,0),('1','148',257781,'DAILY SALE','2022-09-08','2022-09-08 06:01:44','2022-09-09 06:01:44','508',0.00,0.00,'508','2022-09-08 18:01:27','508','2022-09-08 18:01:51',10,0),('1','148',257782,'DAILY SALE','2022-09-09','2022-09-09 08:58:22','2022-09-10 08:58:22','508',0.00,0.00,'508','2022-09-09 18:54:14','508','2022-09-09 18:54:39',10,0),('1','148',257783,'DAILY SALE','2022-09-10','2022-09-10 05:58:25','2022-09-11 05:58:25','508',0.00,0.00,'508','2022-09-10 18:56:30','508','2022-09-10 18:56:49',10,0),('1','148',257784,'DAILY SALE','2022-09-11','2022-09-11 07:02:24','2022-09-12 07:02:24','508',0.00,0.00,'508','2022-09-11 13:47:46','508','2022-09-11 13:48:03',10,0),('1','148',257785,'DAILY SALE','2022-09-11','2022-09-11 14:06:42','2022-09-12 14:06:42','508',0.00,0.00,'508','2022-09-11 14:11:55','508','2022-09-11 14:12:31',10,0),('1','148',257786,'DAILY SALE','2022-09-13','2022-09-13 06:58:48','2022-09-14 06:58:48','508',0.00,0.00,'508','2022-09-13 20:19:08','508','2022-09-13 20:19:48',10,0),('1','148',257787,'DAILY SALE','2022-09-14','2022-09-14 06:55:33','2022-09-15 06:55:33','508',0.00,0.00,'508','2022-09-14 18:49:44','508','2022-09-14 18:50:09',10,0),('1','148',257788,'DAILY SALE','2022-09-15','2022-09-15 08:15:14','2022-09-16 08:15:14','508',0.00,0.00,'508','2022-09-15 19:16:14','508','2022-09-15 19:16:39',10,0),('1','148',257789,'DAILY SALE','2022-09-16','2022-09-16 07:23:42','2022-09-17 07:23:42','508',0.00,0.00,'508','2022-09-16 14:25:47','508','2022-09-16 14:26:18',10,0),('1','148',257790,'Operational loss ','2022-09-16','2022-09-16 21:06:13','2022-09-17 21:06:13','508',0.00,0.00,'508','2022-09-16 21:14:57','508','2022-09-16 21:15:19',10,0),('1','148',257791,'DAILY SALE','2022-09-17','2022-09-17 09:56:20','2022-09-18 09:56:20','508',0.00,0.00,'508','2022-09-17 19:34:01','508','2022-09-17 19:34:25',10,0),('1','148',257792,'DAILY SALE','2022-09-18','2022-09-18 06:50:34','2022-09-19 06:50:34','508',0.00,0.00,'508','2022-09-18 19:27:28','508','2022-09-18 19:28:13',10,0),('1','148',257793,'DAILY SALE','2022-09-19','2022-09-19 06:49:20','2022-09-20 06:49:20','508',0.00,0.00,'508','2022-09-19 19:42:59','508','2022-09-19 19:43:23',10,0),('1','148',257794,'DAILY SALE','2022-09-20','2022-09-20 14:12:43','2022-09-21 14:12:43','508',0.00,0.00,'508','2022-09-20 19:49:51','508','2022-09-20 19:50:14',10,0),('1','148',257795,'DAILY SALE','2022-09-21','2022-09-21 07:25:24','2022-09-22 07:25:24','508',0.00,0.00,'508','2022-09-21 19:41:25','508','2022-09-21 19:41:56',10,0),('1','148',257796,'DAILY SALE','2022-09-22','2022-09-22 06:40:02','2022-09-23 06:40:02','508',0.00,0.00,'508','2022-09-22 19:25:39','508','2022-09-22 19:26:07',10,0),('1','148',257797,'DAILY SALE','2022-09-23','2022-09-23 07:07:32','2022-09-24 07:07:32','508',0.00,0.00,'508','2022-09-23 12:43:46','508','2022-09-23 12:44:14',10,0),('1','148',257798,'DAILY SALE','2022-09-23','2022-09-23 16:02:36','2022-09-24 16:02:36','508',0.00,0.00,'508','2022-09-23 18:50:42','508','2022-09-23 18:51:00',10,0),('1','148',257799,'DAILY SALE','2022-09-24','2022-09-24 06:42:16','2022-09-25 06:42:16','508',0.00,0.00,'508','2022-09-24 19:20:04','508','2022-09-24 19:20:27',10,0),('1','148',257800,'DAILY SALE','2022-09-25','2022-09-25 14:38:31','2022-09-26 14:38:31','508',0.00,0.00,'508','2022-09-25 19:32:39','508','2022-09-25 19:33:03',10,0),('1','148',257801,'DAILY SALE','2022-09-26','2022-09-26 07:09:40','2022-09-27 07:09:40','508',0.00,0.00,'508','2022-09-26 19:47:46','508','2022-09-26 19:48:09',10,0),('1','148',257802,'DAILY SALE','2022-09-27','2022-09-27 08:20:35','2022-09-28 08:20:35','508',0.00,0.00,'508','2022-09-27 10:08:14','508','2022-09-27 10:08:37',10,0),('1','148',257803,'DAILY SALE','2022-09-27','2022-09-27 10:54:43','2022-09-28 10:54:43','508',0.00,0.00,'508','2022-09-27 19:44:57','508','2022-09-27 19:45:22',10,0),('1','148',257804,'DAILY SALE','2022-09-28','2022-09-28 07:00:26','2022-09-29 07:00:26','508',0.00,0.00,'508','2022-09-28 19:28:17','508','2022-09-28 19:28:41',10,0),('1','148',257805,'DAILY SALE','2022-09-29','2022-09-29 06:48:21','2022-09-30 06:48:21','508',0.00,0.00,'508','2022-09-29 19:40:40','508','2022-09-29 19:41:07',10,0),('1','148',257806,'DAILY SALE','2022-09-30','2022-09-30 06:41:09','2022-10-01 06:41:09','508',0.00,0.00,'508','2022-09-30 17:51:45','508','2022-09-30 17:52:05',10,0),('1','148',257807,'DAILY SALE','2022-09-30','2022-09-30 17:52:23','2022-10-01 17:52:23','508',0.00,0.00,'508','2022-09-30 19:32:44','508','2022-09-30 19:33:04',10,0),('1','148',257808,'DAILY SALE','2022-10-01','2022-10-01 06:48:56','2022-10-02 06:48:56','508',0.00,0.00,'508','2022-10-01 19:24:43','508','2022-10-01 19:25:08',10,0),('1','148',257809,'DAILY SHIFT','2022-10-02','2022-10-02 07:44:54','2022-10-03 07:44:54','508',0.00,0.00,'508','2022-10-02 18:31:02','508','2022-10-02 18:31:24',10,0),('1','148',257810,'Operational loss ','2022-10-02','2022-10-02 19:41:37','2022-10-03 19:41:37','508',0.00,0.00,'508','2022-10-02 20:04:43','508','2022-10-02 20:05:06',10,0),('1','148',257811,'DAILY SALE','2022-10-03','2022-10-03 07:49:34','2022-10-04 07:49:34','508',0.00,0.00,'508','2022-10-03 19:15:56','508','2022-10-03 19:16:24',10,0),('1','148',257812,'DAILY SALE','2022-10-04','2022-10-04 06:44:33','2022-10-05 06:44:33','508',0.00,0.00,'508','2022-10-04 19:15:42','508','2022-10-04 19:16:08',10,0),('1','148',257813,'DAILY SALE','2022-10-05','2022-10-05 06:45:35','2022-10-06 06:45:35','508',0.00,0.00,'508','2022-10-05 15:34:21','508','2022-10-05 15:34:43',10,0),('1','148',257814,'DAILY SALE','2022-10-07','2022-10-07 06:50:57','2022-10-08 06:50:57','508',0.00,0.00,'508','2022-10-07 20:05:47','508','2022-10-07 20:06:12',10,0),('1','148',257815,'DAILY SALE','2022-10-08','2022-10-08 06:55:52','2022-10-09 06:55:52','508',0.00,0.00,'508','2022-10-08 11:59:20','508','2022-10-08 11:59:44',10,0),('1','148',257816,'DAILY SHIFT','2022-10-11','2022-10-11 06:22:59','2022-10-12 06:22:59','508',0.00,0.00,'508','2022-10-11 19:15:42','508','2022-10-11 19:16:06',10,0),('1','148',257817,'DAILY SALE','2022-10-12','2022-10-12 07:09:03','2022-10-13 07:09:03','508',0.00,0.00,'508','2022-10-12 15:09:07','508','2022-10-12 15:09:30',10,0),('1','148',257818,'DAILY SALE','2022-10-13','2022-10-13 06:51:00','2022-10-14 06:51:00','508',0.00,0.00,'508','2022-10-13 19:23:35','508','2022-10-13 19:24:02',10,0),('1','148',257819,'DAILY SALE','2022-10-14','2022-10-14 06:53:10','2022-10-15 06:53:10','508',0.00,0.00,'508','2022-10-14 18:38:02','508','2022-10-14 18:38:29',10,0),('1','148',257820,'OPERATIONAL LOSS','2022-10-14','2022-10-14 18:48:38','2022-10-15 18:48:38','508',0.00,0.00,'508','2022-10-14 18:51:50','508','2022-10-14 18:52:11',10,0),('1','148',257821,'DAILY SALE','2022-10-15','2022-10-15 09:05:14','2022-10-16 09:05:14','508',0.00,0.00,'508','2022-10-15 20:03:32','508','2022-10-15 20:04:13',10,0),('1','148',257822,'DAILY SALE','2022-10-16','2022-10-16 06:41:54','2022-10-17 06:41:54','508',0.00,0.00,'508','2022-10-16 19:23:36','508','2022-10-16 19:24:02',10,0),('1','148',257823,'DAILY SALE','2022-10-17','2022-10-17 06:48:50','2022-10-18 06:48:50','508',0.00,0.00,'508','2022-10-17 19:03:18','508','2022-10-17 19:03:41',10,0),('1','148',257824,'DAILY SALE','2022-10-18','2022-10-18 07:10:36','2022-10-19 07:10:36','508',0.00,0.00,'508','2022-10-18 19:39:55','508','2022-10-18 19:40:30',10,0),('1','148',257825,'DAILY SALE','2022-10-19','2022-10-19 06:56:20','2022-10-20 06:56:20','508',0.00,0.00,'508','2022-10-19 17:04:50','508','2022-10-19 17:12:18',10,0),('1','148',257826,'OPERATIONAL LOSS','2022-10-19','2022-10-19 17:12:40','2022-10-20 17:12:40','508',0.00,0.00,'508','2022-10-19 17:18:02','508','2022-10-19 17:18:25',10,0),('1','148',257827,'DAILY SALE','2022-10-20','2022-10-20 09:34:17','2022-10-21 09:34:17','508',0.00,0.00,'508','2022-10-20 19:08:23','508','2022-10-20 19:09:06',10,0),('1','148',257828,'DAILY SALE','2022-10-21','2022-10-21 06:55:17','2022-10-22 06:55:17','508',0.00,0.00,'508','2022-10-21 19:01:08','508','2022-10-21 19:01:45',10,0),('1','148',257829,'DAILY SALE','2022-10-22','2022-10-22 06:53:19','2022-10-23 06:53:19','508',0.00,0.00,'508','2022-10-22 14:50:29','508','2022-10-22 14:51:14',10,0),('1','148',257830,'DAILY SALE','2022-10-23','2022-10-23 08:53:17','2022-10-24 08:53:17','508',0.00,0.00,'508','2022-10-23 18:57:06','508','2022-10-23 18:57:58',10,0),('1','148',257831,'DAILY SALE','2022-10-24','2022-10-24 06:55:40','2022-10-25 06:55:40','508',0.00,0.00,'508','2022-10-24 19:14:10','508','2022-10-24 19:14:48',10,0),('1','148',257832,'DAILY SHIFT','2022-10-25','2022-10-25 08:21:49','2022-10-26 08:21:49','508',0.00,0.00,'508','2022-10-25 19:05:58','508','2022-10-25 19:06:20',10,0),('1','148',257833,'DAILY SALE','2022-10-26','2022-10-26 06:39:54','2022-10-27 06:39:54','508',0.00,0.00,'508','2022-10-26 09:43:43','508','2022-10-26 09:44:05',10,0),('1','148',257834,'DAILY SALE','2022-10-27','2022-10-27 07:40:24','2022-10-28 07:40:24','508',0.00,0.00,'508','2022-10-27 18:52:39','508','2022-10-27 18:53:06',10,0),('1','148',257835,'DAILY SALE','2022-10-28','2022-10-28 06:55:58','2022-10-29 06:55:58','508',0.00,0.00,'508','2022-10-28 19:32:13','508','2022-10-28 19:32:50',10,0),('1','148',257836,'DAILY SALE','2022-10-29','2022-10-29 10:06:38','2022-10-30 10:06:38','508',0.00,0.00,'508','2022-10-29 15:51:14','508','2022-10-29 15:51:37',10,0),('1','148',257837,'DAILY SALE','2022-10-29','2022-10-29 17:27:03','2022-10-30 17:27:03','508',0.00,0.00,'508','2022-10-29 19:26:28','508','2022-10-29 19:26:58',10,0),('1','148',257838,'DAILY SALE','2022-10-30','2022-10-30 06:39:29','2022-10-31 06:39:29','508',0.00,0.00,'508','2022-10-30 20:24:48','508','2022-10-30 20:25:22',10,0),('1','148',257839,'DAILY SHIFT','2022-10-31','2022-10-31 07:54:52','2022-11-01 07:54:52','508',0.00,0.00,'508','2022-10-31 19:33:36','508','2022-10-31 19:34:33',10,0),('1','148',257840,'DAILY SALES','2022-11-01','2022-11-01 08:08:12','2022-11-02 08:08:12','508',0.00,0.00,'508','2022-11-01 15:08:49','508','2022-11-01 15:09:16',10,0),('1','148',257841,'DAILY SHIFT','2022-11-01','2022-11-01 16:11:08','2022-11-02 16:11:08','508',0.00,0.00,'508','2022-11-01 16:26:02','508','2022-11-01 16:26:35',10,0),('1','148',257842,'daily sale','2022-11-04','2022-11-04 10:19:11','2022-11-05 10:19:11','508',0.00,0.00,'508','2022-11-04 19:25:24','508','2022-11-04 19:25:50',10,0),('1','148',257843,'daily sale','2022-11-05','2022-11-05 08:19:39','2022-11-06 08:19:39','508',0.00,0.00,'508','2022-11-06 07:58:46','508','2022-11-06 07:59:10',10,0),('1','148',257844,'daily sale','2022-11-06','2022-11-06 08:04:27','2022-11-07 08:04:27','508',0.00,0.00,'508','2022-11-06 19:22:47','508','2022-11-06 19:23:10',10,0),('1','148',257845,'DAILY SHIFT','2022-11-07','2022-11-07 13:00:57','2022-11-08 13:00:57','508',0.00,0.00,'508','2022-11-07 13:50:43','508','2022-11-07 13:51:09',10,0),('1','148',257846,'DAILY SHIFT','2022-11-07','2022-11-07 14:08:48','2022-11-08 14:08:48','508',0.00,0.00,'508','2022-11-08 06:32:45','508','2022-11-08 06:33:10',10,0),('1','148',257847,'DAILY SALES','2022-11-08','2022-11-08 06:40:12','2022-11-09 06:40:12','508',0.00,0.00,'508','2022-11-08 19:13:42','508','2022-11-08 19:14:21',10,0),('1','148',257848,'DAILY SALES','2022-11-09','2022-11-09 07:09:03','2022-11-10 07:09:03','508',0.00,0.00,'508','2022-11-09 19:06:12','508','2022-11-09 19:07:09',10,0),('1','148',257849,'DAILY SHIFT','2022-11-10','2022-11-10 07:22:04','2022-11-11 07:22:04','508',0.00,0.00,'508','2022-11-10 17:03:15','508','2022-11-10 17:03:36',10,0),('1','148',257850,'DAILY SALES','2022-11-10','2022-11-10 17:03:56','2022-11-11 17:03:56','508',0.00,0.00,'508','2022-11-10 20:27:11','508','2022-11-10 20:27:32',10,0),('1','148',257851,'DAILY SALES','2022-11-11','2022-11-11 09:36:20','2022-11-12 09:36:20','508',0.00,0.00,'508','2022-11-11 23:36:13','508','2022-11-11 23:36:35',10,0),('1','148',257852,'DAILY SALES','2022-11-12','2022-11-12 07:23:01','2022-11-13 07:23:01','508',0.00,0.00,'508','2022-11-12 19:36:32','508','2022-11-12 19:36:58',10,0),('1','148',257853,'DAILY SALES','2022-11-13','2022-11-13 07:40:14','2022-11-14 07:40:14','508',0.00,0.00,'508','2022-11-13 17:12:56','508','2022-11-13 17:13:21',10,0),('1','148',257854,'OPERATIONAL LOSS','2022-11-13','2022-11-13 17:18:58','2022-11-14 17:18:58','508',0.00,0.00,'508','2022-11-13 17:22:10','508','2022-11-13 17:22:32',10,0),('1','148',257855,'DAILY SALES','2022-11-14','2022-11-14 07:06:50','2022-11-15 07:06:50','508',0.00,0.00,'508','2022-11-14 19:10:57','508','2022-11-14 19:11:19',10,0),('1','148',257856,'DAILY SALES','2022-11-15','2022-11-15 07:00:01','2022-11-16 07:00:01','508',0.00,0.00,'508','2022-11-15 19:35:43','508','2022-11-15 19:36:07',10,0),('1','148',257857,'DAILY SALES','2022-11-16','2022-11-16 06:44:42','2022-11-17 06:44:42','508',0.00,0.00,'508','2022-11-16 19:00:21','508','2022-11-16 19:00:55',10,0),('1','148',257858,'DAILY SALES','2022-11-17','2022-11-17 07:22:12','2022-11-18 07:22:12','508',0.00,0.00,'508','2022-11-17 17:32:42','508','2022-11-17 17:33:10',10,0),('1','148',257859,'OPERATIONAL LOSS','2022-11-17','2022-11-17 17:37:15','2022-11-18 17:37:15','508',0.00,0.00,'508','2022-11-18 17:57:04','508','2022-11-18 17:57:30',10,0),('1','148',257860,'DAILY SALE','2022-11-18','2022-11-18 18:03:13','2022-11-19 18:03:13','508',0.00,0.00,'508','2022-11-18 19:38:16','508','2022-11-18 19:38:55',10,0),('1','148',257861,'DAILY SALE','2022-11-19','2022-11-19 06:37:20','2022-11-20 06:37:20','508',0.00,0.00,'508','2022-11-19 19:33:16','508','2022-11-19 19:36:01',10,0),('1','148',257862,'DAILY SALE','2022-11-20','2022-11-20 06:38:39','2022-11-21 06:38:39','508',0.00,0.00,'508','2022-11-20 16:49:20','508','2022-11-20 16:49:45',10,0),('1','148',257863,'DAILY SALE','2022-11-21','2022-11-21 06:58:47','2022-11-22 06:58:47','508',0.00,0.00,'508','2022-11-21 19:13:08','508','2022-11-21 19:13:34',10,0),('1','148',257864,'DAILY SALE','2022-11-22','2022-11-22 07:07:36','2022-11-23 07:07:36','508',0.00,0.00,'508','2022-11-22 19:24:59','508','2022-11-22 19:25:36',10,0),('1','148',257865,'DAILY SALE','2022-11-23','2022-11-23 06:49:03','2022-11-24 06:49:03','508',0.00,0.00,'508','2022-11-23 19:17:46','508','2022-11-23 19:18:16',10,0),('1','148',257866,'DAILY SALE','2022-11-24','2022-11-24 07:19:22','2022-11-25 07:19:22','508',0.00,0.00,'508','2022-11-24 18:29:28','508','2022-11-24 18:29:58',10,0),('1','148',257867,'DAILY SALE','2022-11-25','2022-11-25 06:45:38','2022-11-26 06:45:38','508',0.00,0.00,'508','2022-11-25 19:23:04','508','2022-11-25 19:23:31',10,0),('1','148',257868,'DAILY SALE','2022-11-26','2022-11-26 09:16:09','2022-11-27 09:16:09','508',0.00,0.00,'508','2022-11-26 19:14:38','508','2022-11-26 19:15:04',10,0),('1','148',257869,'DAILY SALE','2022-11-27','2022-11-27 06:59:02','2022-11-28 06:59:02','508',0.00,0.00,'508','2022-11-27 17:46:28','508','2022-11-27 17:47:00',10,0),('1','148',257870,'DAILY SALE','2022-11-28','2022-11-28 06:52:39','2022-11-29 06:52:39','508',0.00,0.00,'508','2022-11-28 19:06:34','508','2022-11-28 19:07:00',10,0),('1','148',257871,'DAILY SALE','2022-11-29','2022-11-29 07:16:43','2022-11-30 07:16:43','508',0.00,0.00,'508','2022-11-29 19:03:54','508','2022-11-29 19:04:34',10,0),('1','148',257872,'DAILY SHIFT','2022-11-30','2022-11-30 09:09:22','2022-12-01 09:09:22','508',0.00,0.00,'508','2022-11-30 19:11:59','508','2022-11-30 19:12:24',10,0),('1','148',257873,'DAILY SALE','2022-12-01','2022-12-01 07:03:31','2022-12-02 07:03:31','508',0.00,0.00,'508','2022-12-01 14:02:24','508','2022-12-01 14:02:46',10,0),('1','148',257874,'DAILY SALE','2022-12-01','2022-12-01 16:03:39','2022-12-02 16:03:39','508',0.00,0.00,'508','2022-12-01 19:10:55','508','2022-12-01 19:11:18',10,0),('1','148',257875,'DAILY SALE','2022-12-02','2022-12-02 07:02:51','2022-12-03 07:02:51','508',0.00,0.00,'508','2022-12-02 18:32:28','508','2022-12-02 18:32:51',10,0),('1','148',257876,'DAILY SALE','2022-12-03','2022-12-03 06:19:50','2022-12-04 06:19:50','508',0.00,0.00,'508','2022-12-03 18:55:07','508','2022-12-03 18:56:33',10,0),('1','148',257877,'DAILY SALE','2022-12-04','2022-12-04 06:58:28','2022-12-05 06:58:28','508',0.00,0.00,'508','2022-12-04 14:36:10','508','2022-12-04 14:36:34',10,0),('1','148',257878,'DAILY SALE','2022-12-04','2022-12-04 14:40:17','2022-12-05 14:40:17','508',0.00,0.00,'508','2022-12-04 19:24:21','508','2022-12-04 19:24:46',10,0),('1','148',257879,'DAILY SALE','2022-12-05','2022-12-05 07:14:41','2022-12-06 07:14:41','508',0.00,0.00,'508','2022-12-05 19:23:16','508','2022-12-05 19:23:49',10,0),('1','148',257880,'DAILY SALE','2022-12-06','2022-12-06 07:07:15','2022-12-07 07:07:15','508',0.00,0.00,'508','2022-12-06 19:02:18','508','2022-12-06 19:02:41',10,0),('1','148',257881,'DAILY SALE','2022-12-07','2022-12-07 06:51:38','2022-12-08 06:51:38','508',0.00,0.00,'508','2022-12-07 17:29:30','508','2022-12-07 17:29:59',10,0),('1','148',257882,'DAILY SALE','2022-12-08','2022-12-08 07:02:07','2022-12-09 07:02:07','508',0.00,0.00,'508','2022-12-08 19:02:22','508','2022-12-08 19:02:47',10,0),('1','148',257883,'DAILY SALE','2022-12-09','2022-12-09 07:19:28','2022-12-10 07:19:28','508',0.00,0.00,'508','2022-12-09 19:00:36','508','2022-12-09 19:01:07',10,0),('1','148',257884,'DAILY SHIFT','2022-12-10','2022-12-10 07:20:07','2022-12-11 07:20:07','508',0.00,0.00,'508','2022-12-10 19:39:01','508','2022-12-10 19:39:25',10,0),('1','148',257885,'OPERATIONAL LOSS','2022-12-11','2022-12-11 06:56:53','2022-12-12 06:56:53','508',0.00,0.00,'508','2022-12-11 06:59:24','508','2022-12-11 06:59:53',10,0),('1','148',257886,'DAILY SALE','2022-12-11','2022-12-11 07:00:15','2022-12-12 07:00:15','508',0.00,0.00,'508','2022-12-11 19:32:13','508','2022-12-11 19:32:38',10,0),('1','148',257887,'DAILY SALE','2022-12-12','2022-12-12 07:01:38','2022-12-13 07:01:38','508',0.00,0.00,'508','2022-12-12 19:05:59','508','2022-12-12 19:07:03',10,0),('1','148',257888,'DAILY SALE','2022-12-13','2022-12-13 06:34:26','2022-12-14 06:34:26','508',0.00,0.00,'508','2022-12-13 19:01:02','508','2022-12-13 19:01:29',10,0),('1','148',257889,'DAILY SALE','2022-12-14','2022-12-14 07:31:30','2022-12-15 07:31:30','508',0.00,0.00,'508','2022-12-14 18:54:49','508','2022-12-14 18:55:20',10,0),('1','148',257890,'OPERATIONAL LOSS','2022-12-14','2022-12-14 18:58:48','2022-12-15 18:58:48','508',0.00,0.00,'508','2022-12-14 19:01:14','508','2022-12-14 19:02:14',10,0),('1','148',257891,'DAILY SALE','2022-12-15','2022-12-15 07:39:16','2022-12-16 07:39:16','508',0.00,0.00,'508','2022-12-15 18:50:45','508','2022-12-15 18:51:08',10,0),('1','148',257892,'DAILY SALE','2022-12-16','2022-12-16 06:49:03','2022-12-17 06:49:03','508',0.00,0.00,'508','2022-12-16 19:02:00','508','2022-12-16 19:02:36',10,0),('1','148',257893,'DAILY SALE','2022-12-17','2022-12-17 07:01:05','2022-12-18 07:01:05','508',0.00,0.00,'508','2022-12-17 19:00:32','508','2022-12-17 19:01:02',10,0),('1','148',257894,'daily sale','2022-12-18','2022-12-18 07:32:00','2022-12-19 07:32:00','508',0.00,0.00,'508','2022-12-18 11:23:18','508','2022-12-18 11:24:00',10,0),('1','148',257895,'DAILY SALE','2022-12-18','2022-12-18 11:59:33','2022-12-19 11:59:33','508',0.00,0.00,'508','2022-12-18 18:54:42','508','2022-12-18 18:55:29',10,0),('1','148',257896,'DAILY SALE','2022-12-19','2022-12-19 07:05:53','2022-12-20 07:05:53','508',0.00,0.00,'508','2022-12-19 18:58:05','508','2022-12-19 18:58:33',10,0),('1','148',257897,'DAILY SALE','2022-12-20','2022-12-20 07:00:16','2022-12-21 07:00:16','508',0.00,0.00,'508','2022-12-20 19:13:05','508','2022-12-20 19:13:41',10,0),('1','148',257898,'DAILY SALE','2022-12-21','2022-12-21 07:08:57','2022-12-22 07:08:57','508',0.00,0.00,'508','2022-12-21 16:12:52','508','2022-12-21 16:13:28',10,0),('1','148',257899,'OPERATIONAL LOSS','2022-12-21','2022-12-21 16:26:35','2022-12-22 16:26:35','508',0.00,0.00,'508','2022-12-21 16:28:41','508','2022-12-21 16:29:09',10,0),('1','148',257900,'DAILY SALE','2022-12-21','2022-12-21 17:01:33','2022-12-22 17:01:33','508',0.00,0.00,'508','2022-12-21 19:34:05','508','2022-12-21 19:34:40',10,0),('1','148',257901,'DAILY SALE','2022-12-22','2022-12-22 06:35:31','2022-12-23 06:35:31','508',0.00,0.00,'508','2022-12-22 19:33:42','508','2022-12-22 19:34:07',10,0),('1','148',257902,'DAILY SALE','2022-12-23','2022-12-23 07:04:15','2022-12-24 07:04:15','508',0.00,0.00,'508','2022-12-23 19:35:11','508','2022-12-23 19:35:34',10,0),('1','148',257903,'DAILY SALE','2022-12-24','2022-12-24 06:24:29','2022-12-25 06:24:29','508',0.00,0.00,'508','2022-12-24 13:13:16','508','2022-12-24 13:13:57',10,0),('1','148',257904,'DAILY SALE','2022-12-24','2022-12-24 16:39:52','2022-12-25 16:39:52','508',0.00,0.00,'508','2022-12-24 19:31:53','508','2022-12-24 19:32:20',10,0),('1','148',257905,'DAILY SALE','2022-12-25','2022-12-25 07:01:20','2022-12-26 07:01:20','508',0.00,0.00,'508','2022-12-25 19:31:54','508','2022-12-25 19:32:18',10,0),('1','148',257906,'DAILY SALE','2022-12-26','2022-12-26 06:42:10','2022-12-27 06:42:10','508',0.00,0.00,'508','2022-12-26 18:09:49','508','2022-12-26 18:10:12',10,0),('1','148',257907,'DAILY SALE','2022-12-27','2022-12-27 08:05:38','2022-12-28 08:05:38','508',0.00,0.00,'508','2022-12-27 19:05:11','508','2022-12-27 19:05:37',10,0),('1','148',257908,'DAILY SALE','2022-12-28','2022-12-28 07:23:31','2022-12-29 07:23:31','508',0.00,0.00,'508','2022-12-28 19:27:12','508','2022-12-28 19:27:52',10,0),('1','148',257909,'DAILY SALE','2022-12-29','2022-12-29 07:03:16','2022-12-30 07:03:16','508',0.00,0.00,'508','2022-12-29 18:55:20','508','2022-12-29 18:57:11',10,0),('1','148',257910,'DAILY SALE','2022-12-30','2022-12-30 07:15:59','2022-12-31 07:15:59','508',0.00,0.00,'508','2022-12-30 18:08:58','508','2022-12-30 18:09:27',10,0),('1','148',257911,'OPERATIONAL LOSS','2022-12-30','2022-12-30 18:15:41','2022-12-31 18:15:41','508',0.00,0.00,'508','2022-12-30 18:17:54','508','2022-12-30 18:18:17',10,0),('1','148',257912,'DAILY SALE','2022-12-31','2022-12-31 09:13:53','2023-01-01 09:13:53','508',0.00,0.00,'508','2022-12-31 19:20:05','508','2022-12-31 19:20:34',10,0),('1','148',257913,'DAILY SALE','2023-01-01','2023-01-01 10:51:10','2023-01-02 10:51:10','508',0.00,0.00,'508','2023-01-01 18:59:44','508','2023-01-01 19:00:15',10,0),('1','148',257914,'DAILY SALE','2023-01-02','2023-01-02 07:11:41','2023-01-03 07:11:41','508',0.00,0.00,'508','2023-01-02 14:53:48','508','2023-01-02 14:54:11',10,0),('1','148',257915,'DAILY SALE','2023-01-02','2023-01-02 14:55:29','2023-01-03 14:55:29','508',0.00,0.00,'508','2023-01-02 18:44:52','508','2023-01-02 18:45:20',10,0),('1','148',257916,'DAILY SALE','2023-01-03','2023-01-03 07:18:13','2023-01-04 07:18:13','508',0.00,0.00,'508','2023-01-03 19:21:27','508','2023-01-03 19:22:15',10,0),('1','148',257917,'DAILY SALE','2023-01-04','2023-01-04 06:59:24','2023-01-05 06:59:24','508',0.00,0.00,'508','2023-01-04 19:07:05','508','2023-01-04 19:07:33',10,0),('1','148',257918,'DAILY SALE','2023-01-05','2023-01-05 07:08:18','2023-01-06 07:08:18','508',0.00,0.00,'508','2023-01-05 18:12:22','508','2023-01-05 18:12:58',10,0),('1','148',257919,'DAILY SALE','2023-01-06','2023-01-06 07:09:13','2023-01-07 07:09:13','508',0.00,0.00,'508','2023-01-06 18:57:43','508','2023-01-06 18:58:10',10,0),('1','148',257920,'DAILY SALE','2023-01-07','2023-01-07 07:08:14','2023-01-08 07:08:14','508',0.00,0.00,'508','2023-01-07 19:20:50','508','2023-01-07 19:21:17',10,0),('1','148',257921,'DAILY SALE','2023-01-08','2023-01-08 07:06:31','2023-01-09 07:06:31','508',0.00,0.00,'508','2023-01-08 18:36:06','508','2023-01-08 18:36:46',10,0),('1','148',257922,'DAILY SALE','2023-01-09','2023-01-09 09:53:10','2023-01-10 09:53:10','508',0.00,0.00,'508','2023-01-09 18:57:52','508','2023-01-09 18:58:28',10,0),('1','148',257923,'DAILY SALE','2023-01-10','2023-01-10 07:08:59','2023-01-11 07:08:59','508',0.00,0.00,'508','2023-01-10 18:58:34','508','2023-01-10 18:58:57',10,0),('1','148',257924,'DAILY SALE','2023-01-11','2023-01-11 06:54:53','2023-01-12 06:54:53','508',0.00,0.00,'508','2023-01-11 19:19:48','508','2023-01-11 19:20:25',10,0),('1','148',257925,'Daily shifts','2023-01-12','2023-01-12 05:50:28','2023-01-13 05:50:28','508',0.00,0.00,'508','2023-01-12 15:48:25','508','2023-01-12 15:48:53',10,0),('1','148',257926,'DAILY SALE','2023-01-13','2023-01-13 07:50:41','2023-01-14 07:50:41','508',0.00,0.00,'508','2023-01-13 19:15:33','508','2023-01-13 19:16:31',10,0),('1','148',257927,'OPERATIONAL LOSS','2023-01-14','2023-01-14 07:15:48','2023-01-15 07:15:48','508',0.00,0.00,'508','2023-01-14 18:13:31','508','2023-01-14 18:15:49',10,0),('1','148',257928,'DAILY SALE','2023-01-14','2023-01-14 18:29:41','2023-01-15 18:29:41','508',0.00,0.00,'508','2023-01-14 19:02:48','508','2023-01-14 19:04:41',10,0),('1','148',257929,'Operational loss ','2023-01-14','2023-01-14 19:23:49','2023-01-15 19:23:49','508',0.00,0.00,'508','2023-01-15 07:06:03','508','2023-01-15 07:06:37',10,0),('1','148',257930,'DAILY SALE','2023-01-15','2023-01-15 07:11:40','2023-01-16 07:11:40','508',0.00,0.00,'508','2023-01-15 19:19:27','508','2023-01-15 19:19:52',10,0),('1','148',257931,'DAILY SALE','2023-01-16','2023-01-16 07:15:22','2023-01-17 07:15:22','508',0.00,0.00,'508','2023-01-16 19:01:50','508','2023-01-16 19:02:12',10,0),('1','148',257932,'DAILY SALE','2023-01-17','2023-01-17 07:08:01','2023-01-18 07:08:01','508',0.00,0.00,'508','2023-01-17 17:41:56','508','2023-01-17 17:42:31',10,0),('1','148',257933,'Operational loss ','2023-01-17','2023-01-17 18:04:25','2023-01-18 18:04:25','508',0.00,0.00,'508','2023-01-18 07:41:47','508','2023-01-18 07:42:36',10,0),('1','148',257934,'DAILY SALE','2023-01-18','2023-01-18 07:43:53','2023-01-19 07:43:53','508',0.00,0.00,'508','2023-01-18 19:17:51','508','2023-01-18 19:18:12',10,0),('1','148',257935,'DAILY SALE','2023-01-19','2023-01-19 07:20:13','2023-01-20 07:20:13','508',0.00,0.00,'508','2023-01-19 19:10:53','508','2023-01-19 19:11:16',10,0),('1','148',257936,'Daily shifts','2023-01-20','2023-01-20 06:23:43','2023-01-21 06:23:43','508',0.00,0.00,'508','2023-01-20 17:37:35','508','2023-01-20 17:37:57',10,0),('1','148',257937,'Operational loss','2023-01-21','2023-01-21 07:58:30','2023-01-22 07:58:30','508',0.00,0.00,'508','2023-01-21 08:00:47','508','2023-01-21 08:01:08',10,0),('1','148',257938,'Daily shifts','2023-01-21','2023-01-21 08:01:33','2023-01-22 08:01:33','508',0.00,0.00,'508','2023-01-21 18:48:52','508','2023-01-21 18:50:34',10,0),('1','148',257939,'Daily shifts','2023-01-22','2023-01-22 06:44:24','2023-01-23 06:44:24','508',0.00,0.00,'508','2023-01-22 19:01:55','508','2023-01-22 19:02:21',10,0),('1','148',257940,'DAILY SALE','2023-01-23','2023-01-23 07:16:14','2023-01-24 07:16:14','508',0.00,0.00,'508','2023-01-23 20:36:04','508','2023-01-23 20:36:39',10,0),('1','148',257941,'Daily shifts','2023-01-24','2023-01-24 07:16:44','2023-01-25 07:16:44','508',0.00,0.00,'508','2023-01-24 18:59:31','508','2023-01-24 19:00:33',10,0),('1','148',257942,'DAILY SHIFT ','2023-01-25','2023-01-25 06:34:19','2023-01-26 06:34:19','508',0.00,0.00,'508','2023-01-25 19:38:16','508','2023-01-25 19:40:57',10,0),('1','148',257943,'Daily shifts','2023-01-26','2023-01-26 04:47:29','2023-01-27 04:47:29','508',0.00,0.00,'508','2023-01-26 19:16:48','508','2023-01-26 19:17:11',10,0),('1','148',257944,'DAILY SALE','2023-01-27','2023-01-27 07:24:23','2023-01-28 07:24:23','508',0.00,0.00,'508','2023-01-27 19:10:43','508','2023-01-27 19:11:13',10,0),('1','148',257945,'Daily shifts','2023-01-28','2023-01-28 06:18:26','2023-01-29 06:18:26','508',0.00,0.00,'508','2023-01-28 18:11:41','508','2023-01-28 18:12:07',10,0),('1','148',257946,'Daily shifts','2023-01-29','2023-01-29 07:01:40','2023-01-30 07:01:40','508',0.00,0.00,'508','2023-01-29 21:39:21','508','2023-01-29 21:40:11',10,0),('1','148',257947,'DAILY SALE','2023-01-30','2023-01-30 07:38:27','2023-01-31 07:38:27','508',0.00,0.00,'508','2023-01-30 20:31:40','508','2023-01-30 20:32:55',10,0),('1','148',257948,'DAILY SALE','2023-01-31','2023-01-31 07:26:16','2023-02-01 07:26:16','508',0.00,0.00,'508','2023-02-01 08:26:52','508','2023-02-01 08:27:16',10,0),('1','148',257949,'DAILY SALE','2023-02-01','2023-02-01 08:42:43','2023-02-02 08:42:43','508',0.00,0.00,'508','2023-02-02 06:42:18','508','2023-02-02 06:42:58',10,0),('1','148',257950,'Daily shifts','2023-02-02','2023-02-02 09:15:44','2023-02-03 09:15:44','508',0.00,0.00,'508','2023-02-02 19:59:47','508','2023-02-02 20:00:06',10,0),('1','148',257951,'DAILY SALE','2023-02-03','2023-02-03 07:00:15','2023-02-04 07:00:15','508',0.00,0.00,'508','2023-02-03 19:40:11','508','2023-02-03 19:40:54',10,0),('1','148',257952,'DAILY SALE','2023-02-04','2023-02-04 07:16:35','2023-02-05 07:16:35','508',0.00,0.00,'508','2023-02-05 07:24:40','508','2023-02-05 07:25:06',10,0),('1','148',257953,'DAILY SALE','2023-02-05','2023-02-05 07:26:52','2023-02-06 07:26:52','508',0.00,0.00,'508','2023-02-05 08:52:03','508','2023-02-05 08:52:40',10,0),('1','148',257954,'DAILY SALE','2023-02-05','2023-02-05 09:05:44','2023-02-06 09:05:44','508',0.00,0.00,'508','2023-02-06 06:51:11','508','2023-02-06 06:51:48',10,0),('1','148',257955,'DAILY SALE','2023-02-06','2023-02-06 06:54:09','2023-02-07 06:54:09','508',0.00,0.00,'508','2023-02-06 20:18:33','508','2023-02-06 20:18:59',10,0),('1','148',257956,'DAILY SALE','2023-02-07','2023-02-07 07:07:24','2023-02-08 07:07:24','508',0.00,0.00,'508','2023-02-07 12:23:10','508','2023-02-07 12:23:36',10,0),('1','148',257957,'Operational loss ','2023-02-07','2023-02-07 15:41:42','2023-02-08 15:41:42','508',0.00,0.00,'508','2023-02-07 15:44:31','508','2023-02-07 15:44:56',10,0),('1','148',257958,'DAILY SALE','2023-02-08','2023-02-08 12:35:35','2023-02-09 12:35:35','508',0.00,0.00,'508','2023-02-09 12:47:23','508','2023-02-09 12:48:26',10,0),('1','148',257959,'DAILY SALE','2023-02-08','2023-02-09 12:50:16','2023-02-10 12:50:16','508',0.00,0.00,'508','2023-02-09 12:51:40','508','2023-02-09 12:52:07',10,0),('1','148',257960,'DAILY SALE','2023-02-09','2023-02-09 12:54:05','2023-02-10 12:54:05','508',0.00,0.00,'508','2023-02-09 21:09:56','508','2023-02-09 21:10:43',10,0),('1','148',257961,'DAILY SALE','2023-02-10','2023-02-10 07:39:18','2023-02-11 07:39:18','508',0.00,0.00,'508','2023-02-10 19:29:01','508','2023-02-10 19:29:26',10,0),('1','148',257962,'DAILY SALE','2023-02-11','2023-02-11 07:03:27','2023-02-12 07:03:27','508',0.00,0.00,'508','2023-02-11 10:52:09','508','2023-02-11 10:52:31',10,0),('1','148',257963,'OPERATIONAL LOSS','2023-02-11','2023-02-11 11:54:36','2023-02-12 11:54:36','508',0.00,0.00,'508','2023-02-11 11:56:40','508','2023-02-11 11:57:08',10,0),('1','148',257964,'DAILY SALE','2023-02-11','2023-02-11 11:57:40','2023-02-12 11:57:40','508',0.00,0.00,'508','2023-02-11 23:34:59','508','2023-02-11 23:35:28',10,0),('1','148',257965,'DAILY SALE','2023-02-12','2023-02-12 06:59:56','2023-02-13 06:59:56','508',0.00,0.00,'508','2023-02-12 19:49:50','508','2023-02-12 19:50:15',10,0),('1','148',257966,'DAILY SALE','2023-02-13','2023-02-13 07:22:49','2023-02-14 07:22:49','508',0.00,0.00,'508','2023-02-13 19:37:19','508','2023-02-13 19:37:45',10,0),('1','148',257967,'DAILY SALE','2023-02-14','2023-02-14 07:15:12','2023-02-15 07:15:12','508',0.00,0.00,'508','2023-02-14 19:35:38','508','2023-02-14 19:37:45',10,0),('1','148',257968,'Daily shifts','2023-02-15','2023-02-15 06:39:26','2023-02-16 06:39:26','508',0.00,0.00,'508','2023-02-15 15:32:56','508','2023-02-15 15:33:22',10,0),('1','148',257969,'DAILY SALE','2023-02-15','2023-02-15 15:37:16','2023-02-16 15:37:16','508',0.00,0.00,'508','2023-02-15 19:16:11','508','2023-02-15 19:16:41',10,0),('1','148',257970,'DAILY SALE','2023-02-16','2023-02-16 07:20:41','2023-02-17 07:20:41','508',0.00,0.00,'508','2023-02-16 19:45:12','508','2023-02-16 19:45:39',10,0),('1','148',257971,'DAILY SALE','2023-02-17','2023-02-17 07:06:20','2023-02-18 07:06:20','508',0.00,0.00,'508','2023-02-17 19:48:45','508','2023-02-17 19:49:07',10,0),('1','148',257972,'DAILY SALE','2023-02-18','2023-02-18 08:55:21','2023-02-19 08:55:21','508',0.00,0.00,'508','2023-02-18 20:05:33','508','2023-02-18 20:05:58',10,0),('1','148',257973,'DAILY SALE','2023-02-19','2023-02-19 07:15:53','2023-02-20 07:15:53','508',0.00,0.00,'508','2023-02-19 14:35:59','508','2023-02-19 14:36:30',10,0),('1','148',257974,'DAILY SALE','2023-02-19','2023-02-19 14:41:01','2023-02-20 14:41:01','508',0.00,0.00,'508','2023-02-19 22:35:41','508','2023-02-19 22:36:04',10,0),('1','148',257975,'DAILY SALE','2023-02-20','2023-02-20 07:37:09','2023-02-21 07:37:09','508',0.00,0.00,'508','2023-02-20 19:33:48','508','2023-02-20 19:34:14',10,0),('1','148',257976,'DAILY SALE','2023-02-21','2023-02-21 06:55:05','2023-02-22 06:55:05','508',0.00,0.00,'508','2023-02-21 20:19:15','508','2023-02-21 20:19:39',10,0),('1','148',257977,'DAILY SALE','2023-02-22','2023-02-22 07:13:16','2023-02-23 07:13:16','508',0.00,0.00,'508','2023-02-22 19:32:47','508','2023-02-22 19:33:21',10,0),('1','148',257978,'Operational loss ','2023-02-22','2023-02-22 22:34:47','2023-02-23 22:34:47','508',0.00,0.00,'508','2023-02-22 22:38:09','508','2023-02-22 22:38:31',10,0),('1','148',257979,'DAILY SALE','2023-02-23','2023-02-23 07:03:00','2023-02-24 07:03:00','508',0.00,0.00,'508','2023-02-23 19:50:42','508','2023-02-23 19:51:21',10,0),('1','148',257980,'DAILY SALE','2023-02-24','2023-02-24 07:01:11','2023-02-25 07:01:11','508',0.00,0.00,'508','2023-02-24 21:35:03','508','2023-02-24 21:35:57',10,0),('1','148',257981,'DAILY SALE','2023-02-26','2023-02-26 10:14:33','2023-02-27 10:14:33','508',0.00,0.00,'508','2023-02-26 19:32:16','508','2023-02-26 19:32:48',10,0),('1','148',257982,'DAILY SALE','2023-02-26','2023-02-26 19:35:47','2023-02-27 19:35:47','508',0.00,0.00,'508','2023-02-26 19:56:17','508','2023-02-26 19:56:43',10,0),('1','148',257983,'DAILY SALE','2023-02-27','2023-02-27 07:32:32','2023-02-28 07:32:32','508',0.00,0.00,'508','2023-02-27 19:57:15','508','2023-02-27 19:57:36',10,0),('1','148',257984,'DAILY SALE','2023-02-28','2023-02-28 07:45:47','2023-03-01 07:45:47','508',0.00,0.00,'508','2023-02-28 19:31:34','508','2023-02-28 19:32:00',10,0),('1','148',257985,'DAILY SALE','2023-03-01','2023-03-01 07:32:46','2023-03-02 07:32:46','508',0.00,0.00,'508','2023-03-01 19:35:03','508','2023-03-01 19:37:02',10,0),('1','148',257986,'DAILY SALE','2023-03-02','2023-03-02 09:41:43','2023-03-03 09:41:43','508',0.00,0.00,'508','2023-03-02 19:48:54','508','2023-03-02 19:53:18',10,0),('1','148',257987,'DAILY SALE','2023-03-03','2023-03-03 08:49:37','2023-03-04 08:49:37','508',0.00,0.00,'508','2023-03-03 19:31:31','508','2023-03-03 19:31:58',10,0),('1','148',257988,'DAILY SALE','2023-03-04','2023-03-04 07:32:15','2023-03-05 07:32:15','508',0.00,0.00,'508','2023-03-04 20:10:52','508','2023-03-04 20:11:15',10,0),('1','148',257989,'DAILY SALE','2023-03-05','2023-03-05 07:32:04','2023-03-06 07:32:04','508',0.00,0.00,'508','2023-03-05 19:18:34','508','2023-03-05 19:18:58',10,0),('1','148',257990,'DAILY SALE','2023-03-06','2023-03-06 08:25:32','2023-03-07 08:25:32','508',0.00,0.00,'508','2023-03-06 19:45:59','508','2023-03-06 19:46:23',10,0),('1','148',257991,'DAILY SALE','2023-03-07','2023-03-07 07:48:04','2023-03-08 07:48:04','508',0.00,0.00,'508','2023-03-07 19:46:23','508','2023-03-07 19:46:58',10,0),('1','148',257992,'DAILY SALE','2023-03-08','2023-03-08 07:15:01','2023-03-09 07:15:01','508',0.00,0.00,'508','2023-03-08 19:23:09','508','2023-03-08 19:23:32',10,0),('1','148',257993,'DAILY SALE','2023-03-09','2023-03-09 07:16:01','2023-03-10 07:16:01','508',0.00,0.00,'508','2023-03-09 19:41:07','508','2023-03-09 19:41:31',10,0),('1','148',257994,'DAILY SALE','2023-03-10','2023-03-10 07:59:00','2023-03-11 07:59:00','508',0.00,0.00,'508','2023-03-10 19:16:09','508','2023-03-10 19:16:30',10,0),('1','148',257995,'DAILY SALE','2023-03-11','2023-03-11 07:49:46','2023-03-12 07:49:46','508',0.00,0.00,'508','2023-03-11 12:09:01','508','2023-03-11 12:09:49',10,0),('1','148',257996,'DAILY SALE','2023-03-11','2023-03-11 12:11:43','2023-03-12 12:11:43','508',0.00,0.00,'508','2023-03-11 20:49:19','508','2023-03-11 20:49:51',10,0),('1','148',257997,'DAILY SALE','2023-03-12','2023-03-12 07:31:31','2023-03-13 07:31:31','508',0.00,0.00,'508','2023-03-12 19:55:58','508','2023-03-12 19:56:21',10,0),('1','148',257998,'DAILY SALE','2023-03-13','2023-03-13 07:59:42','2023-03-14 07:59:42','508',0.00,0.00,'508','2023-03-13 20:09:37','508','2023-03-13 20:10:04',10,0),('1','148',257999,'DAILY SALE','2023-03-14','2023-03-14 07:36:28','2023-03-15 07:36:28','508',0.00,0.00,'508','2023-03-14 16:47:03','508','2023-03-14 16:47:33',10,0),('1','148',258000,'OPERATIONAL LOSS','2023-03-14','2023-03-14 16:50:40','2023-03-15 16:50:40','508',0.00,0.00,'508','2023-03-14 16:55:04','508','2023-03-14 16:55:26',10,0),('1','148',258001,'DAILY SALE','2023-03-14','2023-03-14 16:55:54','2023-03-15 16:55:54','508',0.00,0.00,'508','2023-03-14 20:23:40','508','2023-03-14 20:24:03',10,0),('1','148',258002,'DAILY SALE','2023-03-15','2023-03-15 07:08:51','2023-03-16 07:08:51','508',0.00,0.00,'508','2023-03-15 20:04:17','508','2023-03-15 20:04:46',10,0),('1','148',258003,'DAILY SALE','2023-03-16','2023-03-16 07:16:25','2023-03-17 07:16:25','508',0.00,0.00,'508','2023-03-16 19:30:41','508','2023-03-16 19:31:51',10,0),('1','148',258004,'DAILY SALE','2023-03-17','2023-03-17 07:38:42','2023-03-18 07:38:42','508',0.00,0.00,'508','2023-03-17 19:31:07','508','2023-03-17 19:31:49',10,0),('1','148',258005,'DAILY SALE','2023-03-19','2023-03-19 10:02:35','2023-03-20 10:02:35','508',0.00,0.00,'508','2023-03-19 16:05:29','508','2023-03-19 16:06:18',10,0),('1','148',258006,'DAILY SALE','2023-03-20','2023-03-20 07:28:28','2023-03-21 07:28:28','508',0.00,0.00,'508','2023-03-20 19:39:09','508','2023-03-20 19:39:31',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4904789 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','148','769','146992',2940303,'2140','327',506191.97,507304.66,0.00,0.00,1112.69,311553.20,0.00,0.00,0.00),('1','148','769','146992',2940304,'2183','327',1451954.37,1456270.62,0.00,0.00,4316.25,932310.00,0.00,0.00,0.00),('1','148','769','147019',2940651,'2140','327',507304.66,507573.56,0.00,0.00,268.90,75292.00,0.00,0.00,0.00),('1','148','769','147019',2940652,'2183','327',1456270.62,1457024.78,0.00,0.00,754.16,162898.56,0.00,0.00,0.00),('1','148','769','147073',2941518,'2140','327',507573.56,508236.14,0.00,0.00,662.58,185522.40,0.00,0.00,0.00),('1','148','769','147073',2941519,'2183','327',1457024.78,1457614.25,0.00,0.00,589.47,165051.60,0.00,0.00,0.00),('1','148','769','147086',2941576,'2140','327',508236.14,508470.18,0.00,0.00,234.04,65531.20,0.00,0.00,0.00),('1','148','769','147086',2941577,'2183','327',1457614.25,1458295.29,0.00,0.00,681.04,190691.20,0.00,0.00,0.00),('1','148','769','147105',2941635,'2140','327',508470.18,508704.65,0.00,0.00,234.47,65651.60,0.00,0.00,0.00),('1','148','769','147105',2941636,'2183','327',1458295.29,1458295.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','147169',2942400,'2140','327',508704.65,508704.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','147169',2942401,'2183','327',1458295.29,1459090.34,0.00,0.00,795.05,171730.80,0.00,0.00,0.00),('1','148','769','147187',2942721,'2140','327',508704.65,510006.69,0.00,0.00,1302.04,364571.20,0.00,0.00,0.00),('1','148','769','147187',2942722,'2183','327',1459090.34,1462533.86,0.00,0.00,3443.52,743800.32,0.00,0.00,0.00),('1','148','769','147213',2942992,'2140','327',510006.69,511015.04,0.00,0.00,1008.35,282338.00,0.00,0.00,0.00),('1','148','769','147213',2942993,'2183','327',1462533.86,1466675.40,0.00,0.00,4141.54,894572.64,0.00,0.00,0.00),('1','148','769','147225',2943118,'2140','327',511015.04,512379.80,0.00,0.00,1364.76,382132.80,0.00,0.00,0.00),('1','148','769','147225',2943119,'2183','327',1466675.40,1469764.75,0.00,0.00,3089.35,667299.60,0.00,0.00,0.00),('1','148','769','147243',2943357,'2140','327',512379.80,512693.44,0.00,0.00,313.64,87819.20,0.00,0.00,0.00),('1','148','769','147243',2943358,'2183','327',1469764.75,1471309.06,0.00,0.00,1544.31,333570.96,0.00,0.00,0.00),('1','148','769','147264',2943710,'2140','327',512693.44,513599.77,0.00,0.00,906.33,253772.40,0.00,0.00,0.00),('1','148','769','147264',2943711,'2183','327',1471309.06,1473880.09,0.00,0.00,2571.03,555342.48,0.00,0.00,0.00),('1','148','769','147267',2943729,'2140','327',513599.77,513815.91,0.00,0.00,216.14,60519.20,0.00,0.00,0.00),('1','148','769','147267',2943730,'2183','327',1473880.09,1473880.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','147271',2943783,'2140','327',513815.91,514498.97,0.00,0.00,683.06,191256.80,0.00,0.00,0.00),('1','148','769','147271',2943784,'2183','327',1473880.09,1477693.69,0.00,0.00,3813.60,823737.60,0.00,0.00,0.00),('1','148','769','147286',2943971,'2140','327',514498.97,514498.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','147286',2943972,'2183','327',1477693.69,1478326.88,0.00,0.00,633.19,136769.04,0.00,0.00,0.00),('1','148','769','147333',2944675,'2140','327',514498.97,515518.83,0.00,0.00,1019.86,285560.80,0.00,0.00,0.00),('1','148','769','147333',2944676,'2183','327',1478326.88,1482069.40,0.00,0.00,3742.52,808384.32,0.00,0.00,0.00),('1','148','769','147465',2947228,'2140','327',515518.83,516327.36,0.00,0.00,808.53,226388.40,0.00,0.00,0.00),('1','148','769','147465',2947229,'2183','327',1482069.40,1484231.60,0.00,0.00,2162.20,467035.20,0.00,0.00,0.00),('1','148','769','147592',2949468,'2140','327',516327.36,516625.43,0.00,0.00,298.07,83459.60,0.00,0.00,0.00),('1','148','769','147592',2949469,'2183','327',1484231.60,1484860.97,0.00,0.00,629.37,135943.92,0.00,0.00,0.00),('1','148','769','147712',2951425,'2140','327',516625.43,518082.81,0.00,0.00,1457.38,408066.40,0.00,0.00,0.00),('1','148','769','147712',2951426,'2183','327',1484860.97,1488631.66,0.00,0.00,3770.69,814469.04,0.00,0.00,0.00),('1','148','769','147909',2955069,'2140','327',518082.81,519639.39,0.00,0.00,1556.58,435842.40,0.00,0.00,0.00),('1','148','769','147909',2955070,'2183','327',1488631.66,1493339.04,0.00,0.00,4707.38,1016794.08,0.00,0.00,0.00),('1','148','769','148011',2956556,'2140','327',519639.39,519845.39,0.00,0.00,206.00,57680.00,0.00,0.00,0.00),('1','148','769','148011',2956557,'2183','327',1493339.04,1494364.29,0.00,0.00,1025.25,221454.00,0.00,0.00,0.00),('1','148','769','148156',2959227,'2140','327',519845.39,521072.78,0.00,0.00,1227.39,343669.20,0.00,0.00,0.00),('1','148','769','148156',2959228,'2183','327',1494364.29,1498666.97,0.00,0.00,4302.68,929378.88,0.00,0.00,0.00),('1','148','769','148305',2961787,'2140','327',521072.78,522439.06,0.00,0.00,1366.28,382558.40,0.00,0.00,0.00),('1','148','769','148305',2961788,'2183','327',1498666.97,1502685.62,0.00,0.00,4018.65,868028.40,0.00,0.00,0.00),('1','148','769','148458',2964506,'2140','327',522439.06,523274.15,0.00,0.00,835.09,233825.20,0.00,0.00,0.00),('1','148','769','148458',2964507,'2183','327',1502685.62,1505677.80,0.00,0.00,2992.18,646310.88,0.00,0.00,0.00),('1','148','769','148588',2966761,'2140','327',523274.15,523505.11,0.00,0.00,230.96,64668.80,0.00,0.00,0.00),('1','148','769','148588',2966762,'2183','327',1505677.80,1506814.86,0.00,0.00,1137.06,245604.96,0.00,0.00,0.00),('1','148','769','148700',2968606,'2140','327',523505.11,524880.28,0.00,0.00,1375.17,385047.60,0.00,0.00,0.00),('1','148','769','148700',2968607,'2183','327',1506814.86,1510934.52,0.00,0.00,4119.66,889846.56,0.00,0.00,0.00),('1','148','769','148786',2970022,'2140','327',524880.28,525819.95,0.00,0.00,939.67,263107.60,0.00,0.00,0.00),('1','148','769','148786',2970023,'2183','327',1510934.52,1514247.63,0.00,0.00,3313.11,715631.76,0.00,0.00,0.00),('1','148','769','148948',2973059,'2140','327',525819.95,527129.16,0.00,0.00,1309.21,366578.80,0.00,0.00,0.00),('1','148','769','148948',2973060,'2183','327',1514247.63,1518534.06,0.00,0.00,4286.43,925868.88,0.00,0.00,0.00),('1','148','769','149200',2977934,'2140','327',527129.16,528134.67,0.00,0.00,1005.51,281542.80,0.00,0.00,0.00),('1','148','769','149200',2977935,'2183','327',1518534.06,1522888.56,0.00,0.00,4354.50,940572.00,0.00,0.00,0.00),('1','148','769','149360',2980467,'2140','327',528134.67,528382.74,0.00,0.00,248.07,69459.60,0.00,0.00,0.00),('1','148','769','149360',2980468,'2183','327',1522888.56,1524345.69,0.00,0.00,1457.13,314740.08,0.00,0.00,0.00),('1','148','769','149515',2983032,'2140','327',528382.74,529421.65,0.00,0.00,1038.91,290894.80,0.00,0.00,0.00),('1','148','769','149515',2983033,'2183','327',1524345.69,1527640.39,0.00,0.00,3294.70,711655.20,0.00,0.00,0.00),('1','148','769','149624',2984914,'2140','327',529421.65,530644.08,0.00,0.00,1222.43,342280.40,0.00,0.00,0.00),('1','148','769','149624',2984915,'2183','327',1527640.39,1530691.78,0.00,0.00,3051.39,659100.24,0.00,0.00,0.00),('1','148','769','149630',2985032,'2140','327',530644.08,532100.79,0.00,0.00,1456.71,407878.80,0.00,0.00,0.00),('1','148','769','149630',2985033,'2183','327',1530691.78,1535310.78,0.00,0.00,4619.00,997704.00,0.00,0.00,0.00),('1','148','769','149831',2988637,'2140','327',532100.79,533426.50,0.00,0.00,1325.71,371198.80,0.00,0.00,0.00),('1','148','769','149831',2988638,'2183','327',1535310.78,1540078.30,0.00,0.00,4767.52,1029784.32,0.00,0.00,0.00),('1','148','769','149995',2991542,'2140','327',533426.50,534447.75,0.00,0.00,1021.25,285950.00,0.00,0.00,0.00),('1','148','769','149995',2991543,'2183','327',1540078.30,1545099.53,0.00,0.00,5021.23,1084585.68,0.00,0.00,0.00),('1','148','769','150145',2994761,'2140','327',534447.75,535366.24,0.00,0.00,918.49,257177.20,0.00,0.00,0.00),('1','148','769','150145',2994762,'2183','327',1545099.53,1549028.78,0.00,0.00,3929.25,848718.00,0.00,0.00,0.00),('1','148','769','150364',2998097,'2140','327',535366.24,535939.48,0.00,0.00,573.24,160507.20,0.00,0.00,0.00),('1','148','769','150364',2998098,'2183','327',1549028.78,1549574.40,0.00,0.00,545.62,152773.60,0.00,0.00,0.00),('1','148','769','150546',3001733,'2140','327',535939.48,536792.59,0.00,0.00,853.11,238870.80,0.00,0.00,0.00),('1','148','769','150546',3001734,'2183','327',1549574.40,1550322.82,0.00,0.00,748.42,209557.60,0.00,0.00,0.00),('1','148','769','150709',3005113,'2140','327',536792.59,537478.31,0.00,0.00,685.72,192001.60,0.00,0.00,0.00),('1','148','769','150709',3005114,'2183','327',1550322.82,1551025.50,0.00,0.00,702.68,196750.40,0.00,0.00,0.00),('1','148','769','150820',3007181,'2140','327',537478.31,539066.64,0.00,0.00,1588.33,444732.40,0.00,0.00,0.00),('1','148','769','150820',3007182,'2183','327',1551025.50,1553408.43,0.00,0.00,2382.93,667220.40,0.00,0.00,0.00),('1','148','769','150992',3010192,'2140','327',539066.64,539678.99,0.00,0.00,612.35,171458.00,0.00,0.00,0.00),('1','148','769','150992',3010193,'2183','327',1553408.43,1554065.27,0.00,0.00,656.84,183915.20,0.00,0.00,0.00),('1','148','769','151147',3013052,'2140','327',539678.99,539871.46,0.00,0.00,192.47,53891.60,0.00,0.00,0.00),('1','148','769','151147',3013053,'2183','327',1554065.27,1555018.30,0.00,0.00,953.03,266848.40,0.00,0.00,0.00),('1','148','769','151271',3015553,'2140','327',539871.46,540392.58,0.00,0.00,521.12,145913.60,0.00,0.00,0.00),('1','148','769','151271',3015554,'2183','327',1555018.30,1555609.23,0.00,0.00,590.93,165460.40,0.00,0.00,0.00),('1','148','769','151426',3018438,'2140','327',540392.58,541147.85,0.00,0.00,755.27,211475.60,0.00,0.00,0.00),('1','148','769','151426',3018439,'2183','327',1555609.23,1556030.39,0.00,0.00,421.16,117924.80,0.00,0.00,0.00),('1','148','769','151584',3021192,'2140','327',541147.85,541339.69,0.00,0.00,191.84,53715.20,0.00,0.00,0.00),('1','148','769','151584',3021193,'2183','327',1556030.39,1556792.17,0.00,0.00,761.78,213298.40,0.00,0.00,0.00),('1','148','769','151698',3023264,'2140','327',541339.69,541398.28,0.00,0.00,58.59,16405.20,0.00,0.00,0.00),('1','148','769','151698',3023265,'2183','327',1556792.17,1556892.47,0.00,0.00,100.30,28084.00,0.00,0.00,0.00),('1','148','769','151699',3023266,'2140','327',541398.28,542723.55,0.00,0.00,1325.27,371075.60,0.00,0.00,0.00),('1','148','769','151699',3023267,'2183','327',1556892.47,1560119.97,0.00,0.00,3227.50,697140.00,0.00,0.00,0.00),('1','148','769','151854',3026112,'2140','327',542723.55,543214.90,0.00,0.00,491.35,137578.00,0.00,0.00,0.00),('1','148','769','151854',3026113,'2183','327',1560119.97,1561115.62,0.00,0.00,995.65,215060.40,0.00,0.00,0.00),('1','148','769','152006',3029231,'2140','327',543214.90,544532.93,0.00,0.00,1318.03,369048.40,0.00,0.00,0.00),('1','148','769','152006',3029232,'2183','327',1561115.62,1564361.35,0.00,0.00,3245.73,701077.68,0.00,0.00,0.00),('1','148','769','152161',3031927,'2140','327',544532.93,544792.60,0.00,0.00,259.67,72707.60,0.00,0.00,0.00),('1','148','769','152161',3031928,'2183','327',1564361.35,1565339.71,0.00,0.00,978.36,211325.76,0.00,0.00,0.00),('1','148','769','152321',3035020,'2140','327',544792.60,546159.16,0.00,0.00,1366.56,382636.80,0.00,0.00,0.00),('1','148','769','152321',3035021,'2183','327',1565339.71,1569812.90,0.00,0.00,4473.19,966209.04,0.00,0.00,0.00),('1','148','769','152475',3037699,'2140','327',546159.16,546849.43,0.00,0.00,690.27,193275.60,0.00,0.00,0.00),('1','148','769','152475',3037700,'2183','327',1569812.90,1571725.82,0.00,0.00,1912.92,413190.72,0.00,0.00,0.00),('1','148','769','152642',3040725,'2140','327',546849.43,547456.27,0.00,0.00,606.84,169915.20,0.00,0.00,0.00),('1','148','769','152642',3040726,'2183','327',1571725.82,1574624.20,0.00,0.00,2898.38,649237.12,0.00,0.00,0.00),('1','148','769','152758',3042837,'2140','327',547456.27,548768.50,0.00,0.00,1312.23,367424.40,0.00,0.00,0.00),('1','148','769','152758',3042838,'2183','327',1574624.20,1577877.45,0.00,0.00,3253.25,728728.00,0.00,0.00,0.00),('1','148','769','152893',3045301,'2140','327',548768.50,549205.23,0.00,0.00,436.73,122284.40,0.00,0.00,0.00),('1','148','769','152893',3045302,'2183','327',1577877.45,1578917.71,0.00,0.00,1040.26,233018.24,0.00,0.00,0.00),('1','148','769','153083',3048563,'2140','327',549205.23,550532.40,0.00,0.00,1327.17,371607.60,0.00,0.00,0.00),('1','148','769','153083',3048564,'2183','327',1578917.71,1583658.25,0.00,0.00,4740.54,1023956.64,0.00,0.00,0.00),('1','148','769','153272',3051940,'2140','327',550532.40,551443.26,0.00,0.00,910.86,255040.80,0.00,0.00,0.00),('1','148','769','153272',3051941,'2183','327',1583658.25,1586447.34,0.00,0.00,2789.09,602443.44,0.00,0.00,0.00),('1','148','769','153470',3055743,'2140','327',551443.26,552663.72,0.00,0.00,1220.46,341728.80,0.00,0.00,0.00),('1','148','769','153470',3055744,'2183','327',1586447.34,1589885.61,0.00,0.00,3438.27,742666.32,0.00,0.00,0.00),('1','148','769','153624',3058537,'2140','327',552663.72,553074.46,0.00,0.00,410.74,115007.20,0.00,0.00,0.00),('1','148','769','153624',3058538,'2183','327',1589885.61,1590887.32,0.00,0.00,1001.71,216369.36,0.00,0.00,0.00),('1','148','769','153770',3061145,'2140','327',553074.46,554385.58,0.00,0.00,1311.12,367113.60,0.00,0.00,0.00),('1','148','769','153770',3061146,'2183','327',1590887.32,1595657.58,0.00,0.00,4770.26,1030376.16,0.00,0.00,0.00),('1','148','769','153977',3064736,'2140','327',554385.58,555691.31,0.00,0.00,1305.73,365604.40,0.00,0.00,0.00),('1','148','769','153977',3064737,'2183','327',1595657.58,1600418.29,0.00,0.00,4760.71,1028313.36,0.00,0.00,0.00),('1','148','769','154053',3066071,'2140','327',555691.31,556159.56,0.00,0.00,468.25,131110.00,0.00,0.00,0.00),('1','148','769','154053',3066072,'2183','327',1600418.29,1602090.44,0.00,0.00,1672.15,361184.40,0.00,0.00,0.00),('1','148','769','154270',3069849,'2140','327',556159.56,556878.40,0.00,0.00,718.84,201275.20,0.00,0.00,0.00),('1','148','769','154270',3069850,'2183','327',1602090.44,1604020.58,0.00,0.00,1930.14,416910.24,0.00,0.00,0.00),('1','148','769','154401',3072317,'2140','327',556878.40,557101.75,0.00,0.00,223.35,62538.00,0.00,0.00,0.00),('1','148','769','154401',3072318,'2183','327',1604020.58,1604597.32,0.00,0.00,576.74,124575.84,0.00,0.00,0.00),('1','148','769','154436',3072894,'2140','327',557101.75,557611.24,0.00,0.00,509.49,142657.20,0.00,0.00,0.00),('1','148','769','154436',3072895,'2183','327',1604597.32,1604974.95,0.00,0.00,377.63,105736.40,0.00,0.00,0.00),('1','148','769','154575',3075755,'2140','327',557611.24,558191.11,0.00,0.00,579.87,162363.60,0.00,0.00,0.00),('1','148','769','154575',3075756,'2183','327',1604974.95,1605974.95,0.00,0.00,1000.00,239821.44,0.00,0.00,0.00),('1','148','769','154703',3078217,'2140','327',558191.11,559399.33,0.00,0.00,1208.22,338301.60,0.00,0.00,0.00),('1','148','769','154703',3078218,'2183','327',1605974.95,1609268.87,0.00,0.00,3293.92,711486.72,0.00,0.00,0.00),('1','148','769','154875',3081281,'2140','327',559399.33,560001.57,0.00,0.00,602.24,168627.20,0.00,0.00,0.00),('1','148','769','154875',3081282,'2183','327',1609268.87,1609791.47,0.00,0.00,522.60,146328.00,0.00,0.00,0.00),('1','148','769','154919',3082024,'2140','327',560001.57,560468.83,0.00,0.00,467.26,130832.80,0.00,0.00,0.00),('1','148','769','154919',3082025,'2183','327',1609791.47,1610454.19,0.00,0.00,662.72,185561.60,0.00,0.00,0.00),('1','148','769','155127',3086082,'2140','327',560468.83,560569.04,0.00,0.00,100.21,28058.80,0.00,0.00,0.00),('1','148','769','155127',3086083,'2183','327',1610454.19,1611596.34,0.00,0.00,1142.15,319802.00,0.00,0.00,0.00),('1','148','769','155303',3089329,'2140','327',560569.04,560670.25,0.00,0.00,101.21,28338.80,0.00,0.00,0.00),('1','148','769','155303',3089330,'2183','327',1611596.34,1612607.57,0.00,0.00,1011.23,283144.40,0.00,0.00,0.00),('1','148','769','155460',3092301,'2140','327',560670.25,560950.25,0.00,0.00,280.00,78400.00,0.00,0.00,0.00),('1','148','769','155460',3092302,'2183','327',1612607.57,1613712.84,0.00,0.00,1105.27,309475.60,0.00,0.00,0.00),('1','148','769','155641',3095671,'2140','327',560950.25,561986.97,0.00,0.00,1036.72,290281.60,0.00,0.00,0.00),('1','148','769','155641',3095672,'2183','327',1613712.84,1618828.93,0.00,0.00,5116.09,1105075.44,0.00,0.00,0.00),('1','148','769','155776',3098055,'2140','327',561986.97,563115.69,0.00,0.00,1128.72,316041.60,0.00,0.00,0.00),('1','148','769','155776',3098056,'2183','327',1618828.93,1619239.64,0.00,0.00,410.71,114998.80,0.00,0.00,0.00),('1','148','769','155905',3100268,'2140','327',563115.69,563591.91,0.00,0.00,476.22,133341.60,0.00,0.00,0.00),('1','148','769','155905',3100269,'2183','327',1619239.64,1624840.54,0.00,0.00,5600.90,1568252.00,0.00,0.00,0.00),('1','148','769','156086',3103463,'2140','327',563591.91,564603.12,0.00,0.00,1011.21,283138.80,0.00,0.00,0.00),('1','148','769','156086',3103464,'2183','327',1624840.54,1629911.26,0.00,0.00,5070.72,1095275.52,0.00,0.00,0.00),('1','148','769','156190',3105464,'2140','327',564603.12,564899.83,0.00,0.00,296.71,83078.80,0.00,0.00,0.00),('1','148','769','156190',3105465,'2183','327',1629911.26,1633275.59,0.00,0.00,3364.33,726695.28,0.00,0.00,0.00),('1','148','769','156197',3105556,'2140','327',564899.83,565346.70,0.00,0.00,446.87,125123.60,0.00,0.00,0.00),('1','148','769','156197',3105557,'2183','327',1633275.59,1633702.80,0.00,0.00,427.21,119618.80,0.00,0.00,0.00),('1','148','769','156411',3109460,'2140','327',565346.70,565704.89,0.00,0.00,358.19,100293.20,0.00,0.00,0.00),('1','148','769','156411',3109461,'2183','327',1633702.80,1634306.01,0.00,0.00,603.21,168898.80,0.00,0.00,0.00),('1','148','769','156552',3112186,'2140','327',565704.89,566188.10,0.00,0.00,483.21,135298.80,0.00,0.00,0.00),('1','148','769','156552',3112187,'2183','327',1634306.01,1634833.72,0.00,0.00,527.71,147758.80,0.00,0.00,0.00),('1','148','769','157079',3121701,'2140','327',566188.10,566300.31,0.00,0.00,112.21,31418.80,0.00,0.00,0.00),('1','148','769','157079',3121702,'2183','327',1634833.72,1634967.46,0.00,0.00,133.74,37447.20,0.00,0.00,0.00),('1','148','769','157082',3121733,'2140','327',566300.31,566471.58,0.00,0.00,171.27,47955.60,0.00,0.00,0.00),('1','148','769','157082',3121734,'2183','327',1634967.46,1636068.82,0.00,0.00,1101.36,308380.80,0.00,0.00,0.00),('1','148','769','157275',3125237,'2140','327',566471.58,567198.41,0.00,0.00,726.83,203512.40,0.00,0.00,0.00),('1','148','769','157275',3125238,'2183','327',1636068.82,1640125.36,0.00,0.00,4056.54,876212.64,0.00,0.00,0.00),('1','148','769','157447',3128023,'2140','327',567198.41,567721.13,0.00,0.00,522.72,146361.60,0.00,0.00,0.00),('1','148','769','157447',3128024,'2183','327',1640125.36,1642916.92,0.00,0.00,2791.56,602976.96,0.00,0.00,0.00),('1','148','769','157665',3131912,'2140','327',567721.13,568722.35,0.00,0.00,1001.22,280341.60,0.00,0.00,0.00),('1','148','769','157665',3131913,'2183','327',1642916.92,1647984.70,0.00,0.00,5067.78,1094640.48,0.00,0.00,0.00),('1','148','769','157818',3134729,'2140','327',568722.35,569725.87,0.00,0.00,1003.52,280985.60,0.00,0.00,0.00),('1','148','769','157818',3134730,'2183','327',1647984.70,1653048.18,0.00,0.00,5063.48,1093711.68,0.00,0.00,0.00),('1','148','769','157947',3137278,'2140','327',569725.87,570229.60,0.00,0.00,503.73,141044.40,0.00,0.00,0.00),('1','148','769','157947',3137279,'2183','327',1653048.18,1655074.91,0.00,0.00,2026.73,437773.68,0.00,0.00,0.00),('1','148','769','158081',3139675,'2140','327',570229.60,570339.72,0.00,0.00,110.12,30833.60,0.00,0.00,0.00),('1','148','769','158081',3139676,'2183','327',1655074.91,1656080.56,0.00,0.00,1005.65,217220.40,0.00,0.00,0.00),('1','148','769','158258',3143014,'2140','327',570339.72,571351.95,0.00,0.00,1012.23,283424.40,0.00,0.00,0.00),('1','148','769','158258',3143015,'2183','327',1656080.56,1660899.70,0.00,0.00,4819.14,1040934.24,0.00,0.00,0.00),('1','148','769','158259',3143016,'2140','327',571351.95,572602.34,0.00,0.00,1250.39,350109.20,0.00,0.00,0.00),('1','148','769','158259',3143017,'2183','327',1660899.70,1661800.91,0.00,0.00,901.21,252338.80,0.00,0.00,0.00),('1','148','769','158566',3148654,'2140','327',572602.34,573265.57,0.00,0.00,663.23,185704.40,0.00,0.00,0.00),('1','148','769','158566',3148655,'2183','327',1661800.91,1662212.18,0.00,0.00,411.27,115155.60,0.00,0.00,0.00),('1','148','769','158751',3152045,'2140','327',573265.57,573792.29,0.00,0.00,526.72,147481.60,0.00,0.00,0.00),('1','148','769','158751',3152046,'2183','327',1662212.18,1662814.90,0.00,0.00,602.72,168761.60,0.00,0.00,0.00),('1','148','769','158926',3154999,'2140','327',573792.29,573819.92,0.00,0.00,27.63,7736.40,0.00,0.00,0.00),('1','148','769','158926',3155000,'2183','327',1662814.90,1663846.16,0.00,0.00,1031.26,288752.80,0.00,0.00,0.00),('1','148','769','159110',3158300,'2140','327',573819.92,573856.06,0.00,0.00,36.14,10697.44,0.00,0.00,0.00),('1','148','769','159110',3158301,'2183','327',1663846.16,1664724.02,0.00,0.00,877.86,259846.56,0.00,0.00,0.00),('1','148','769','159277',3161432,'2140','327',573856.06,573899.34,0.00,0.00,43.28,12810.88,0.00,0.00,0.00),('1','148','769','159277',3161433,'2183','327',1664724.02,1665150.74,0.00,0.00,426.72,126309.12,0.00,0.00,0.00),('1','148','769','159450',3164064,'2140','327',573899.34,573926.76,0.00,0.00,27.42,8116.32,0.00,0.00,0.00),('1','148','769','159450',3164065,'2183','327',1665150.74,1666214.61,0.00,0.00,1063.87,314905.52,0.00,0.00,0.00),('1','148','769','159737',3169046,'2140','327',573926.76,573973.11,0.00,0.00,46.35,13719.60,0.00,0.00,0.00),('1','148','769','159737',3169047,'2183','327',1666214.61,1667318.39,0.00,0.00,1103.78,326718.88,0.00,0.00,0.00),('1','148','769','159739',3169082,'2140','327',573973.11,574000.45,0.00,0.00,27.34,8311.36,0.00,0.00,0.00),('1','148','769','159739',3169083,'2183','327',1667318.39,1667745.02,0.00,0.00,426.63,129695.52,0.00,0.00,0.00),('1','148','769','159740',3169084,'2140','327',574000.45,574035.16,0.00,0.00,34.71,10551.84,0.00,0.00,0.00),('1','148','769','159740',3169085,'2183','327',1667745.02,1668821.31,0.00,0.00,1076.29,327192.16,0.00,0.00,0.00),('1','148','769','159936',3172673,'2140','327',574035.16,575326.56,0.00,0.00,1291.40,392585.60,0.00,0.00,0.00),('1','148','769','159936',3172674,'2183','327',1668821.31,1673721.03,0.00,0.00,4899.72,1136735.04,0.00,0.00,0.00),('1','148','769','160105',3175949,'2140','327',575326.56,576460.60,0.00,0.00,1134.04,344748.16,0.00,0.00,0.00),('1','148','769','160105',3175950,'2183','327',1673721.03,1678691.56,0.00,0.00,4970.53,1153162.96,0.00,0.00,0.00),('1','148','769','160309',3179401,'2140','327',576460.60,577492.82,0.00,0.00,1032.22,313794.88,0.00,0.00,0.00),('1','148','769','160309',3179402,'2183','327',1678691.56,1683747.50,0.00,0.00,5055.94,1172978.08,0.00,0.00,0.00),('1','148','769','160453',3182077,'2140','327',577492.82,578505.44,0.00,0.00,1012.62,324038.40,0.00,0.00,0.00),('1','148','769','160453',3182078,'2183','327',1683747.50,1687473.91,0.00,0.00,3726.41,894338.40,0.00,0.00,0.00),('1','148','769','160595',3184616,'2140','327',578505.44,578692.17,0.00,0.00,186.73,59753.60,0.00,0.00,0.00),('1','148','769','160595',3184617,'2183','327',1687473.91,1687688.91,0.00,0.00,215.00,68800.00,0.00,0.00,0.00),('1','148','769','160597',3184619,'2140','327',578692.17,578961.01,0.00,0.00,268.84,86028.80,0.00,0.00,0.00),('1','148','769','160597',3184620,'2183','327',1687688.91,1687852.69,0.00,0.00,163.78,52409.60,0.00,0.00,0.00),('1','148','769','160741',3187005,'2140','327',578961.01,579537.64,0.00,0.00,576.63,184521.60,0.00,0.00,0.00),('1','148','769','160741',3187006,'2183','327',1687852.69,1688435.16,0.00,0.00,582.47,186390.40,0.00,0.00,0.00),('1','148','769','160856',3188996,'2140','327',579537.64,580034.45,0.00,0.00,496.81,158979.20,0.00,0.00,0.00),('1','148','769','160856',3188997,'2183','327',1688435.16,1688951.98,0.00,0.00,516.82,165382.40,0.00,0.00,0.00),('1','148','769','161077',3193065,'2140','327',580034.45,580602.38,0.00,0.00,567.93,181737.60,0.00,0.00,0.00),('1','148','769','161077',3193066,'2183','327',1688951.98,1689479.80,0.00,0.00,527.82,168902.40,0.00,0.00,0.00),('1','148','769','161267',3196543,'2140','327',580602.38,581122.10,0.00,0.00,519.72,166310.40,0.00,0.00,0.00),('1','148','769','161267',3196544,'2183','327',1689479.80,1690482.80,0.00,0.00,1003.00,320960.00,0.00,0.00,0.00),('1','148','769','161447',3199430,'2140','327',581122.10,581285.94,0.00,0.00,163.84,52428.80,0.00,0.00,0.00),('1','148','769','161447',3199431,'2183','327',1690482.80,1691359.73,0.00,0.00,876.93,280617.60,0.00,0.00,0.00),('1','148','769','161653',3202881,'2140','327',581285.94,581429.21,0.00,0.00,143.27,45846.40,0.00,0.00,0.00),('1','148','769','161653',3202882,'2183','327',1691359.73,1692122.92,0.00,0.00,763.19,244220.80,0.00,0.00,0.00),('1','148','769','161872',3206524,'2140','327',581429.21,581494.94,0.00,0.00,65.73,21033.60,0.00,0.00,0.00),('1','148','769','161872',3206525,'2183','327',1692122.92,1693088.15,0.00,0.00,965.23,308873.60,0.00,0.00,0.00),('1','148','769','162038',3209692,'2140','327',581494.94,581718.50,0.00,0.00,223.56,71539.20,0.00,0.00,0.00),('1','148','769','162038',3209693,'2183','327',1693088.15,1693934.87,0.00,0.00,846.72,270950.40,0.00,0.00,0.00),('1','148','769','162240',3213099,'2140','327',581718.50,582046.34,0.00,0.00,327.84,99663.36,0.00,0.00,0.00),('1','148','769','162240',3213100,'2183','327',1693934.87,1694362.19,0.00,0.00,427.32,129905.28,0.00,0.00,0.00),('1','148','769','162455',3216681,'2140','327',582046.34,582582.44,0.00,0.00,536.10,162974.40,0.00,0.00,0.00),('1','148','769','162455',3216682,'2183','327',1694362.19,1694873.92,0.00,0.00,511.73,155565.92,0.00,0.00,0.00),('1','148','769','162635',3219623,'2140','327',582582.44,583069.67,0.00,0.00,487.23,148117.92,0.00,0.00,0.00),('1','148','769','162635',3219624,'2183','327',1694873.92,1695416.75,0.00,0.00,542.83,165020.32,0.00,0.00,0.00),('1','148','769','162801',3222647,'2140','327',583069.67,583116.99,0.00,0.00,47.32,14385.28,0.00,0.00,0.00),('1','148','769','162801',3222648,'2183','327',1695416.75,1696172.41,0.00,0.00,755.66,229720.64,0.00,0.00,0.00),('1','148','769','163002',3226235,'2140','327',583116.99,583159.44,0.00,0.00,42.45,12904.80,0.00,0.00,0.00),('1','148','769','163002',3226236,'2183','327',1696172.41,1697236.86,0.00,0.00,1064.45,323592.80,0.00,0.00,0.00),('1','148','769','163196',3229695,'2140','327',583159.44,583227.27,0.00,0.00,67.83,20620.32,0.00,0.00,0.00),('1','148','769','163196',3229696,'2183','327',1697236.86,1698218.18,0.00,0.00,981.32,298321.28,0.00,0.00,0.00),('1','148','769','163376',3232771,'2140','327',583227.27,584303.50,0.00,0.00,1076.23,327173.92,0.00,0.00,0.00),('1','148','769','163376',3232772,'2183','327',1698218.18,1700922.77,0.00,0.00,2704.59,692375.04,0.00,0.00,0.00),('1','148','769','163533',3235804,'2140','327',584303.50,584831.33,0.00,0.00,527.83,160460.32,0.00,0.00,0.00),('1','148','769','163533',3235805,'2183','327',1700922.77,1702707.35,0.00,0.00,1784.58,456852.48,0.00,0.00,0.00),('1','148','769','163739',3239447,'2140','327',584831.33,585158.06,0.00,0.00,326.73,99325.92,0.00,0.00,0.00),('1','148','769','163739',3239448,'2183','327',1702707.35,1703435.62,0.00,0.00,728.27,186437.12,0.00,0.00,0.00),('1','148','769','163801',3240388,'2140','327',585158.06,586234.40,0.00,0.00,1076.34,327207.36,0.00,0.00,0.00),('1','148','769','163801',3240389,'2183','327',1703435.62,1704962.96,0.00,0.00,1527.34,409327.12,0.00,0.00,0.00),('1','148','769','164075',3245518,'2140','327',586234.40,587161.11,0.00,0.00,926.71,281719.84,0.00,0.00,0.00),('1','148','769','164075',3245519,'2183','327',1704962.96,1705430.85,0.00,0.00,467.89,125394.52,0.00,0.00,0.00),('1','148','769','164255',3248719,'2140','327',587161.11,588173.47,0.00,0.00,1012.36,307757.44,0.00,0.00,0.00),('1','148','769','164255',3248720,'2183','327',1705430.85,1705558.71,0.00,0.00,127.86,34266.48,0.00,0.00,0.00),('1','148','769','164445',3252276,'2140','327',588173.47,588288.16,0.00,0.00,114.69,34865.76,0.00,0.00,0.00),('1','148','769','164445',3252277,'2183','327',1705558.71,1706439.96,0.00,0.00,881.25,236175.00,0.00,0.00,0.00),('1','148','769','164601',3255012,'2140','327',588288.16,589294.95,0.00,0.00,1006.79,306064.16,0.00,0.00,0.00),('1','148','769','164601',3255013,'2183','327',1706439.96,1708048.96,0.00,0.00,1609.00,431212.00,0.00,0.00,0.00),('1','148','769','164753',3257868,'2140','327',589294.95,589450.31,0.00,0.00,155.36,47229.44,0.00,0.00,0.00),('1','148','769','164753',3257869,'2183','327',1708048.96,1708892.19,0.00,0.00,843.23,225985.64,0.00,0.00,0.00),('1','148','769','164964',3261559,'2140','327',589450.31,590468.22,0.00,0.00,1017.91,309444.64,0.00,0.00,0.00),('1','148','769','164964',3261560,'2183','327',1708892.19,1713967.60,0.00,0.00,5075.41,1360209.88,0.00,0.00,0.00),('1','148','769','164967',3261621,'2140','327',590468.22,590845.04,0.00,0.00,376.82,114553.28,0.00,0.00,0.00),('1','148','769','164967',3261622,'2183','327',1713967.60,1714935.42,0.00,0.00,967.82,259375.76,0.00,0.00,0.00),('1','148','769','164968',3261623,'2140','327',590845.04,591069.84,0.00,0.00,224.80,71936.00,0.00,0.00,0.00),('1','148','769','164968',3261624,'2183','327',1714935.42,1715176.74,0.00,0.00,241.32,69982.80,0.00,0.00,0.00),('1','148','769','165144',3264676,'2140','327',591069.84,591788.46,0.00,0.00,718.62,229958.40,0.00,0.00,0.00),('1','148','769','165144',3264677,'2183','327',1715176.74,1715313.57,0.00,0.00,136.83,39680.70,0.00,0.00,0.00),('1','148','769','165310',3267651,'2140','327',591788.46,592599.69,0.00,0.00,811.23,246613.92,0.00,0.00,0.00),('1','148','769','165310',3267652,'2183','327',1715313.57,1715313.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','165447',3269963,'2140','327',592599.69,593619.52,0.00,0.00,1019.83,310028.32,0.00,0.00,0.00),('1','148','769','165447',3269964,'2183','327',1715313.57,1715313.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','165620',3272989,'2140','327',593619.52,594554.15,0.00,0.00,934.63,284127.52,0.00,0.00,0.00),('1','148','769','165620',3272990,'2183','327',1715313.57,1716760.26,0.00,0.00,1446.69,405073.20,0.00,0.00,0.00),('1','148','769','165793',3276321,'2140','327',594554.15,595656.77,0.00,0.00,1102.62,335196.48,0.00,0.00,0.00),('1','148','769','165793',3276322,'2183','327',1716760.26,1718266.53,0.00,0.00,1506.27,421755.60,0.00,0.00,0.00),('1','148','769','165968',3279267,'2140','327',595656.77,596669.60,0.00,0.00,1012.83,307900.32,0.00,0.00,0.00),('1','148','769','165968',3279268,'2183','327',1718266.53,1720195.36,0.00,0.00,1928.83,540072.40,0.00,0.00,0.00),('1','148','769','166141',3282472,'2140','327',596669.60,597591.27,0.00,0.00,921.67,280187.68,0.00,0.00,0.00),('1','148','769','166141',3282473,'2183','327',1720195.36,1720328.03,0.00,0.00,132.67,37147.60,0.00,0.00,0.00),('1','148','769','166332',3285871,'2140','327',597591.27,597919.13,0.00,0.00,327.86,99669.44,0.00,0.00,0.00),('1','148','769','166332',3285872,'2183','327',1720328.03,1722026.12,0.00,0.00,1698.09,475465.20,0.00,0.00,0.00),('1','148','769','166340',3285983,'2140','327',597919.13,597982.95,0.00,0.00,63.82,19401.28,0.00,0.00,0.00),('1','148','769','166340',3285984,'2183','327',1722026.12,1722613.01,0.00,0.00,586.89,164329.20,0.00,0.00,0.00),('1','148','769','166496',3288943,'2140','327',597982.95,599001.62,0.00,0.00,1018.67,309675.68,0.00,0.00,0.00),('1','148','769','166496',3288944,'2183','327',1722613.01,1722659.60,0.00,0.00,46.59,13045.20,0.00,0.00,0.00),('1','148','769','166693',3292277,'2140','327',599001.62,599789.27,0.00,0.00,787.65,239445.60,0.00,0.00,0.00),('1','148','769','166693',3292278,'2183','327',1722659.60,1724333.42,0.00,0.00,1673.82,468669.60,0.00,0.00,0.00),('1','148','769','166900',3295736,'2140','327',599789.27,600227.37,0.00,0.00,438.10,133182.40,0.00,0.00,0.00),('1','148','769','166900',3295737,'2183','327',1724333.42,1726450.14,0.00,0.00,2116.72,592681.60,0.00,0.00,0.00),('1','148','769','166902',3295747,'2140','327',600227.37,600288.84,0.00,0.00,61.47,18686.88,0.00,0.00,0.00),('1','148','769','166902',3295748,'2183','327',1726450.14,1726831.67,0.00,0.00,381.53,106828.40,0.00,0.00,0.00),('1','148','769','167379',3304336,'2140','327',600288.84,600465.67,0.00,0.00,176.83,53756.32,0.00,0.00,0.00),('1','148','769','167379',3304337,'2183','327',1726831.67,1728124.98,0.00,0.00,1293.31,362126.80,0.00,0.00,0.00),('1','148','769','167381',3304339,'2140','327',600465.67,601529.45,0.00,0.00,1063.78,323389.12,0.00,0.00,0.00),('1','148','769','167381',3304340,'2183','327',1728124.98,1730458.98,0.00,0.00,2334.00,653520.00,0.00,0.00,0.00),('1','148','769','167382',3304341,'2140','327',601529.45,601668.18,0.00,0.00,138.73,42173.92,0.00,0.00,0.00),('1','148','769','167382',3304342,'2183','327',1730458.98,1731539.96,0.00,0.00,1080.98,302674.40,0.00,0.00,0.00),('1','148','769','167567',3307866,'2140','327',601668.18,602668.30,0.00,0.00,1000.12,304036.48,0.00,0.00,0.00),('1','148','769','167567',3307867,'2183','327',1731539.96,1731655.59,0.00,0.00,115.63,32376.40,0.00,0.00,0.00),('1','148','769','167747',3310882,'2140','327',602668.30,602932.11,0.00,0.00,263.81,80198.24,0.00,0.00,0.00),('1','148','769','167747',3310883,'2183','327',1731655.59,1733789.78,0.00,0.00,2134.19,597573.20,0.00,0.00,0.00),('1','148','769','167916',3313897,'2140','327',602932.11,603750.08,0.00,0.00,817.97,248662.88,0.00,0.00,0.00),('1','148','769','167916',3313898,'2183','327',1733789.78,1735806.60,0.00,0.00,2016.82,564709.60,0.00,0.00,0.00),('1','148','769','168114',3317726,'2140','327',603750.08,604118.80,0.00,0.00,368.72,112090.88,0.00,0.00,0.00),('1','148','769','168114',3317727,'2183','327',1735806.60,1738693.68,0.00,0.00,2887.08,808382.40,0.00,0.00,0.00),('1','148','769','168286',3320895,'2140','327',604118.80,605125.67,0.00,0.00,1006.87,306088.48,0.00,0.00,0.00),('1','148','769','168286',3320896,'2183','327',1738693.68,1738840.41,0.00,0.00,146.73,41084.40,0.00,0.00,0.00),('1','148','769','168406',3323116,'2140','327',605125.67,605612.30,0.00,0.00,486.63,147935.52,0.00,0.00,0.00),('1','148','769','168406',3323117,'2183','327',1738840.41,1741169.41,0.00,0.00,2329.00,652120.00,0.00,0.00,0.00),('1','148','769','168621',3326923,'2140','327',605612.30,606619.93,0.00,0.00,1007.63,306319.52,0.00,0.00,0.00),('1','148','769','168621',3326924,'2183','327',1741169.41,1741531.50,0.00,0.00,362.09,101385.20,0.00,0.00,0.00),('1','148','769','168769',3329679,'2140','327',606619.93,607531.16,0.00,0.00,911.23,277013.92,0.00,0.00,0.00),('1','148','769','168769',3329680,'2183','327',1741531.50,1742655.12,0.00,0.00,1123.62,314613.60,0.00,0.00,0.00),('1','148','769','168937',3332425,'2140','327',607531.16,607853.81,0.00,0.00,322.65,98085.60,0.00,0.00,0.00),('1','148','769','168937',3332426,'2183','327',1742655.12,1745027.12,0.00,0.00,2372.00,664160.00,0.00,0.00,0.00),('1','148','769','169107',3335467,'2140','327',607853.81,608910.64,0.00,0.00,1056.83,321276.32,0.00,0.00,0.00),('1','148','769','169107',3335468,'2183','327',1745027.12,1746750.44,0.00,0.00,1723.32,482529.60,0.00,0.00,0.00),('1','148','769','169128',3335858,'2140','327',608910.64,609585.25,0.00,0.00,674.61,205081.44,0.00,0.00,0.00),('1','148','769','169128',3335859,'2183','327',1746750.44,1750677.99,0.00,0.00,3927.55,1099714.00,0.00,0.00,0.00),('1','148','769','169267',3338514,'2140','327',609585.25,610048.93,0.00,0.00,463.68,140958.72,0.00,0.00,0.00),('1','148','769','169267',3338515,'2183','327',1750677.99,1751360.31,0.00,0.00,682.32,191049.60,0.00,0.00,0.00),('1','148','769','169449',3342178,'2140','327',610048.93,611253.76,0.00,0.00,1204.83,366268.32,0.00,0.00,0.00),('1','148','769','169449',3342179,'2183','327',1751360.31,1754953.86,0.00,0.00,3593.55,1049316.60,0.00,0.00,0.00),('1','148','769','169570',3344632,'2140','327',611253.76,611687.60,0.00,0.00,433.84,131887.36,0.00,0.00,0.00),('1','148','769','169570',3344633,'2183','327',1754953.86,1755818.02,0.00,0.00,864.16,252334.72,0.00,0.00,0.00),('1','148','769','169769',3348140,'2140','327',611687.60,613094.33,0.00,0.00,1406.73,427645.92,0.00,0.00,0.00),('1','148','769','169769',3348141,'2183','327',1755818.02,1758079.53,0.00,0.00,2261.51,660360.92,0.00,0.00,0.00),('1','148','769','169921',3351122,'2140','327',613094.33,613605.65,0.00,0.00,511.32,155441.28,0.00,0.00,0.00),('1','148','769','169921',3351123,'2183','327',1758079.53,1759999.63,0.00,0.00,1920.10,560669.20,0.00,0.00,0.00),('1','148','769','170141',3354980,'2140','327',613605.65,615074.63,0.00,0.00,1468.98,446569.92,0.00,0.00,0.00),('1','148','769','170141',3354981,'2183','327',1759999.63,1760782.49,0.00,0.00,782.86,228595.12,0.00,0.00,0.00),('1','148','769','170333',3358235,'2140','327',615074.63,616478.35,0.00,0.00,1403.72,426730.88,0.00,0.00,0.00),('1','148','769','170333',3358236,'2183','327',1760782.49,1762366.03,0.00,0.00,1583.54,462393.68,0.00,0.00,0.00),('1','148','769','170617',3363296,'2140','327',616478.35,617024.62,0.00,0.00,546.27,166066.08,0.00,0.00,0.00),('1','148','769','170617',3363297,'2183','327',1762366.03,1762739.04,0.00,0.00,373.01,108918.92,0.00,0.00,0.00),('1','148','769','170622',3363397,'2140','327',617024.62,617545.25,0.00,0.00,520.63,158271.52,0.00,0.00,0.00),('1','148','769','170622',3363398,'2183','327',1762739.04,1763780.04,0.00,0.00,1041.00,316464.00,0.00,0.00,0.00),('1','148','769','170626',3363509,'2140','327',617545.25,617674.89,0.00,0.00,129.64,39410.56,0.00,0.00,0.00),('1','148','769','170626',3363510,'2183','327',1763780.04,1763998.23,0.00,0.00,218.19,66329.76,0.00,0.00,0.00),('1','148','769','170760',3365891,'2140','327',617674.89,618065.34,0.00,0.00,390.45,118696.80,0.00,0.00,0.00),('1','148','769','170760',3365892,'2183','327',1763998.23,1764693.21,0.00,0.00,694.98,211273.92,0.00,0.00,0.00),('1','148','769','170849',3367281,'2140','327',618065.34,618232.79,0.00,0.00,167.45,53584.00,0.00,0.00,0.00),('1','148','769','170849',3367282,'2183','327',1764693.21,1765350.81,0.00,0.00,657.60,210432.00,0.00,0.00,0.00),('1','148','769','171054',3371030,'2140','327',618232.79,618797.06,0.00,0.00,564.27,180566.40,0.00,0.00,0.00),('1','148','769','171054',3371031,'2183','327',1765350.81,1766417.34,0.00,0.00,1066.53,341289.60,0.00,0.00,0.00),('1','148','769','171254',3374783,'2140','327',618797.06,618903.03,0.00,0.00,105.97,33910.40,0.00,0.00,0.00),('1','148','769','171254',3374784,'2183','327',1766417.34,1767353.32,0.00,0.00,935.98,299513.60,0.00,0.00,0.00),('1','148','769','171371',3377004,'2140','327',618903.03,620835.02,0.00,0.00,1931.99,618236.80,0.00,0.00,0.00),('1','148','769','171371',3377005,'2183','327',1767353.32,1767353.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','171623',3381434,'2140','327',620835.02,622060.85,0.00,0.00,1225.83,392265.60,0.00,0.00,0.00),('1','148','769','171623',3381435,'2183','327',1767353.32,1767353.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','171828',3385021,'2140','327',622060.85,623504.94,0.00,0.00,1444.09,462108.80,0.00,0.00,0.00),('1','148','769','171828',3385022,'2183','327',1767353.32,1767353.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','172090',3389816,'2140','327',623504.94,624904.94,0.00,0.00,1400.00,448000.00,0.00,0.00,0.00),('1','148','769','172090',3389817,'2183','327',1767353.32,1767353.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','172092',3389820,'2140','327',624904.94,626368.76,0.00,0.00,1463.82,468422.40,0.00,0.00,0.00),('1','148','769','172092',3389821,'2183','327',1767353.32,1767353.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','172339',3394409,'2140','327',626368.76,628074.89,0.00,0.00,1706.13,545961.60,0.00,0.00,0.00),('1','148','769','172339',3394410,'2183','327',1767353.32,1767353.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','172526',3397901,'2140','327',628074.89,629852.79,0.00,0.00,1777.90,568928.00,0.00,0.00,0.00),('1','148','769','172526',3397902,'2183','327',1767353.32,1767353.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','172710',3401123,'2140','327',629852.79,630564.59,0.00,0.00,711.80,227776.00,0.00,0.00,0.00),('1','148','769','172710',3401124,'2183','327',1767353.32,1767353.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','172874',3404275,'2140','327',630564.59,631398.40,0.00,0.00,833.81,266819.20,0.00,0.00,0.00),('1','148','769','172874',3404276,'2183','327',1767353.32,1767788.71,0.00,0.00,435.39,127133.88,0.00,0.00,0.00),('1','148','769','173049',3407471,'2140','327',631398.40,632902.07,0.00,0.00,1503.67,481174.40,0.00,0.00,0.00),('1','148','769','173049',3407472,'2183','327',1767788.71,1767788.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','173275',3411858,'2140','327',632902.07,634028.26,0.00,0.00,1126.19,360380.80,0.00,0.00,0.00),('1','148','769','173275',3411859,'2183','327',1767788.71,1767788.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','173378',3413777,'2140','327',634028.26,635722.08,0.00,0.00,1693.82,542022.40,0.00,0.00,0.00),('1','148','769','173378',3413778,'2183','327',1767788.71,1768261.92,0.00,0.00,473.21,138177.32,0.00,0.00,0.00),('1','148','769','173679',3419141,'2140','327',635722.08,637148.90,0.00,0.00,1426.82,456582.40,0.00,0.00,0.00),('1','148','769','173679',3419142,'2183','327',1768261.92,1771289.78,0.00,0.00,3027.86,884135.12,0.00,0.00,0.00),('1','148','769','173744',3420545,'2140','327',637148.90,637749.90,0.00,0.00,601.00,192320.00,0.00,0.00,0.00),('1','148','769','173744',3420546,'2183','327',1771289.78,1772319.14,0.00,0.00,1029.36,300573.12,0.00,0.00,0.00),('1','148','769','174022',3425415,'2140','327',637749.90,639173.71,0.00,0.00,1423.81,455619.20,0.00,0.00,0.00),('1','148','769','174022',3425416,'2183','327',1772319.14,1776963.99,0.00,0.00,4644.85,1356296.20,0.00,0.00,0.00),('1','148','769','174121',3427299,'2140','327',639173.71,639284.83,0.00,0.00,111.12,35558.40,0.00,0.00,0.00),('1','148','769','174121',3427300,'2183','327',1776963.99,1777573.65,0.00,0.00,609.66,178020.72,0.00,0.00,0.00),('1','148','769','174315',3430812,'2140','327',639284.83,640715.22,0.00,0.00,1430.39,457724.80,0.00,0.00,0.00),('1','148','769','174315',3430813,'2183','327',1777573.65,1777573.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','174483',3433547,'2140','327',640715.22,642117.88,0.00,0.00,1402.66,448851.20,0.00,0.00,0.00),('1','148','769','174483',3433548,'2183','327',1777573.65,1780819.26,0.00,0.00,3245.61,947718.12,0.00,0.00,0.00),('1','148','769','174640',3436428,'2140','327',642117.88,643524.32,0.00,0.00,1406.44,450060.80,0.00,0.00,0.00),('1','148','769','174640',3436429,'2183','327',1780819.26,1783443.14,0.00,0.00,2623.88,766172.96,0.00,0.00,0.00),('1','148','769','174836',3440025,'2140','327',643524.32,643935.45,0.00,0.00,411.13,131561.60,0.00,0.00,0.00),('1','148','769','174836',3440026,'2183','327',1783443.14,1785068.69,0.00,0.00,1625.55,474660.60,0.00,0.00,0.00),('1','148','769','174908',3441406,'2140','327',643935.45,644715.27,0.00,0.00,779.82,249542.40,0.00,0.00,0.00),('1','148','769','174908',3441407,'2183','327',1785068.69,1787035.27,0.00,0.00,1966.58,574241.36,0.00,0.00,0.00),('1','148','769','175032',3443870,'2140','327',644715.27,645238.33,0.00,0.00,523.06,188301.60,0.00,0.00,0.00),('1','148','769','175032',3443871,'2183','327',1787035.27,1787035.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','175226',3447339,'2140','327',645238.33,645955.66,0.00,0.00,717.33,258238.80,0.00,0.00,0.00),('1','148','769','175226',3447340,'2183','327',1787035.27,1787035.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','175403',3450562,'2140','327',645955.66,646767.99,0.00,0.00,812.33,292438.80,0.00,0.00,0.00),('1','148','769','175403',3450563,'2183','327',1787035.27,1787035.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','175506',3452316,'2140','327',646767.99,648052.99,0.00,0.00,1285.00,462600.00,0.00,0.00,0.00),('1','148','769','175506',3452317,'2183','327',1787035.27,1787035.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','175591',3453948,'2140','327',648052.99,648431.65,0.00,0.00,378.66,136317.60,0.00,0.00,0.00),('1','148','769','175591',3453949,'2183','327',1787035.27,1787035.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','175747',3456854,'2140','327',648431.65,649948.64,0.00,0.00,1516.99,546116.40,0.00,0.00,0.00),('1','148','769','175747',3456855,'2183','327',1787035.27,1787035.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','175914',3459691,'2140','327',649948.64,651361.30,0.00,0.00,1412.66,508557.60,0.00,0.00,0.00),('1','148','769','175914',3459692,'2183','327',1787035.27,1790051.46,0.00,0.00,3016.19,941051.28,0.00,0.00,0.00),('1','148','769','176142',3463884,'2140','327',651361.30,651687.63,0.00,0.00,326.33,117478.80,0.00,0.00,0.00),('1','148','769','176142',3463885,'2183','327',1790051.46,1791386.13,0.00,0.00,1334.67,416417.04,0.00,0.00,0.00),('1','148','769','176316',3467178,'2140','327',651687.63,653093.85,0.00,0.00,1406.22,506239.20,0.00,0.00,0.00),('1','148','769','176316',3467179,'2183','327',1791386.13,1793314.01,0.00,0.00,1927.88,601498.56,0.00,0.00,0.00),('1','148','769','176533',3471331,'2140','327',653093.85,653717.73,0.00,0.00,623.88,224596.80,0.00,0.00,0.00),('1','148','769','176533',3471332,'2183','327',1793314.01,1795398.01,0.00,0.00,2084.00,650208.00,0.00,0.00,0.00),('1','148','769','176823',3476326,'2140','327',653717.73,653841.39,0.00,0.00,123.66,44517.60,0.00,0.00,0.00),('1','148','769','176823',3476327,'2183','327',1795398.01,1796201.01,0.00,0.00,803.00,289080.00,0.00,0.00,0.00),('1','148','769','177273',3485062,'2140','327',653841.39,654058.27,0.00,0.00,216.88,78076.80,0.00,0.00,0.00),('1','148','769','177273',3485063,'2183','327',1796201.01,1796201.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','177276',3485099,'2140','327',654058.27,655473.73,0.00,0.00,1415.46,509565.60,0.00,0.00,0.00),('1','148','769','177276',3485100,'2183','327',1796201.01,1798620.84,0.00,0.00,2419.83,754986.96,0.00,0.00,0.00),('1','148','769','177418',3488085,'2140','327',655473.73,655885.61,0.00,0.00,411.88,148276.80,0.00,0.00,0.00),('1','148','769','177418',3488086,'2183','327',1798620.84,1800194.95,0.00,0.00,1574.11,491122.32,0.00,0.00,0.00),('1','148','769','177612',3492130,'2140','327',655885.61,657126.97,0.00,0.00,1241.36,446889.60,0.00,0.00,0.00),('1','148','769','177612',3492131,'2183','327',1800194.95,1800194.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','177867',3496654,'2140','327',657126.97,658543.52,0.00,0.00,1416.55,509958.00,0.00,0.00,0.00),('1','148','769','177867',3496655,'2183','327',1800194.95,1800194.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','178122',3501519,'2140','327',658543.52,659471.86,0.00,0.00,928.34,289642.08,0.00,0.00,0.00),('1','148','769','178122',3501520,'2183','327',1800194.95,1802621.83,0.00,0.00,2426.88,757186.56,0.00,0.00,0.00),('1','148','769','178280',3504506,'2140','327',659471.86,660235.85,0.00,0.00,763.99,275036.40,0.00,0.00,0.00),('1','148','769','178280',3504507,'2183','327',1802621.83,1802621.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','178471',3508032,'2140','327',660235.85,661664.32,0.00,0.00,1428.47,514249.20,0.00,0.00,0.00),('1','148','769','178471',3508033,'2183','327',1802621.83,1805717.05,0.00,0.00,3095.22,965708.64,0.00,0.00,0.00),('1','148','769','178702',3512277,'2140','327',661664.32,661893.25,0.00,0.00,228.93,82414.80,0.00,0.00,0.00),('1','148','769','178702',3512278,'2183','327',1805717.05,1806255.71,0.00,0.00,538.66,173448.52,0.00,0.00,0.00),('1','148','769','178882',3515483,'2140','327',661893.25,663299.77,0.00,0.00,1406.52,506347.20,0.00,0.00,0.00),('1','148','769','178882',3515484,'2183','327',1806255.71,1806255.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','179054',3518566,'2140','327',663299.77,663652.73,0.00,0.00,352.96,127065.60,0.00,0.00,0.00),('1','148','769','179054',3518567,'2183','327',1806255.71,1807438.33,0.00,0.00,1182.62,380803.64,0.00,0.00,0.00),('1','148','769','179146',3520288,'2140','327',663652.73,664381.79,0.00,0.00,729.06,257961.60,0.00,0.00,0.00),('1','148','769','179146',3520289,'2183','327',1807438.33,1808911.33,0.00,0.00,1473.00,497866.00,0.00,0.00,0.00),('1','148','769','179394',3524995,'2140','327',664381.79,664584.29,0.00,0.00,202.50,72900.00,0.00,0.00,0.00),('1','148','769','179394',3524996,'2183','327',1808911.33,1809516.33,0.00,0.00,605.00,194810.00,0.00,0.00,0.00),('1','148','769','179441',3525890,'2140','327',664584.29,664674.01,0.00,0.00,89.72,32299.20,0.00,0.00,0.00),('1','148','769','179441',3525891,'2183','327',1809516.33,1809906.33,0.00,0.00,390.00,125580.00,0.00,0.00,0.00),('1','148','769','179592',3528696,'2140','327',664674.01,666009.90,0.00,0.00,1335.89,480920.40,0.00,0.00,0.00),('1','148','769','179592',3528697,'2183','327',1809906.33,1809906.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','179794',3532682,'2140','327',666009.90,667511.26,0.00,0.00,1501.36,513490.68,0.00,0.00,0.00),('1','148','769','179794',3532683,'2183','327',1809906.33,1811721.88,0.00,0.00,1815.55,584607.10,0.00,0.00,0.00),('1','148','769','180015',3536715,'2140','327',667511.26,668264.76,0.00,0.00,753.50,271260.00,0.00,0.00,0.00),('1','148','769','180015',3536716,'2183','327',1811721.88,1812269.88,0.00,0.00,548.00,176456.00,0.00,0.00,0.00),('1','148','769','180100',3538354,'2140','327',668264.76,668317.26,0.00,0.00,52.50,18900.00,0.00,0.00,0.00),('1','148','769','180100',3538355,'2183','327',1812269.88,1812680.88,0.00,0.00,411.00,147960.00,0.00,0.00,0.00),('1','148','769','180187',3540029,'2140','327',668317.26,669697.03,0.00,0.00,1379.77,495997.20,0.00,0.00,0.00),('1','148','769','180187',3540030,'2183','327',1812680.88,1814940.09,0.00,0.00,2259.21,727465.62,0.00,0.00,0.00),('1','148','769','180357',3543062,'2140','327',669697.03,670186.38,0.00,0.00,489.35,175806.00,0.00,0.00,0.00),('1','148','769','180357',3543063,'2183','327',1814940.09,1816835.09,0.00,0.00,1895.00,610190.00,0.00,0.00,0.00),('1','148','769','180589',3547329,'2140','327',670186.38,670932.77,0.00,0.00,746.39,268700.40,0.00,0.00,0.00),('1','148','769','180589',3547330,'2183','327',1816835.09,1816835.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','180744',3550083,'2140','327',670932.77,672320.57,0.00,0.00,1387.80,493106.40,0.00,0.00,0.00),('1','148','769','180744',3550084,'2183','327',1816835.09,1816835.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','181017',3555412,'2140','327',672320.57,673427.24,0.00,0.00,1106.67,398401.20,0.00,0.00,0.00),('1','148','769','181017',3555413,'2183','327',1816835.09,1816835.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','181135',3557670,'2140','327',673427.24,673606.97,0.00,0.00,179.73,64702.80,0.00,0.00,0.00),('1','148','769','181135',3557671,'2183','327',1816835.09,1819429.09,0.00,0.00,2594.00,830080.00,0.00,0.00,0.00),('1','148','769','181388',3562470,'2140','327',673606.97,673899.21,0.00,0.00,292.24,105206.40,0.00,0.00,0.00),('1','148','769','181388',3562471,'2183','327',1819429.09,1820619.09,0.00,0.00,1190.00,428400.00,0.00,0.00,0.00),('1','148','769','181568',3565685,'2140','327',673899.21,675300.58,0.00,0.00,1401.37,504493.20,0.00,0.00,0.00),('1','148','769','181568',3565686,'2183','327',1820619.09,1823241.52,0.00,0.00,2622.43,839177.60,0.00,0.00,0.00),('1','148','769','181710',3568181,'2140','327',675300.58,675778.02,0.00,0.00,477.44,171878.40,0.00,0.00,0.00),('1','148','769','181710',3568182,'2183','327',1823241.52,1824719.52,0.00,0.00,1478.00,472960.00,0.00,0.00,0.00),('1','148','769','181975',3572851,'2140','327',675778.02,677171.70,0.00,0.00,1393.68,501724.80,0.00,0.00,0.00),('1','148','769','181975',3572852,'2183','327',1824719.52,1824719.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','182112',3575515,'2140','327',677171.70,678528.04,0.00,0.00,1356.34,488282.40,0.00,0.00,0.00),('1','148','769','182112',3575516,'2183','327',1824719.52,1824719.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','182383',3580245,'2140','327',678528.04,679003.72,0.00,0.00,475.68,171244.80,0.00,0.00,0.00),('1','148','769','182383',3580246,'2183','327',1824719.52,1827455.52,0.00,0.00,2736.00,875520.00,0.00,0.00,0.00),('1','148','769','182451',3581562,'2140','327',679003.72,679049.64,0.00,0.00,45.92,16531.20,0.00,0.00,0.00),('1','148','769','182451',3581563,'2183','327',1827455.52,1827705.52,0.00,0.00,250.00,80000.00,0.00,0.00,0.00),('1','148','769','182504',3582395,'2140','327',679049.64,680209.92,0.00,0.00,1160.28,417700.80,0.00,0.00,0.00),('1','148','769','182504',3582396,'2183','327',1827705.52,1827705.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','183225',3595729,'2140','327',680209.92,680923.58,0.00,0.00,713.66,256917.60,0.00,0.00,0.00),('1','148','769','183225',3595730,'2183','327',1827705.52,1827705.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','183228',3595750,'2140','327',680923.58,681776.31,0.00,0.00,852.73,306982.80,0.00,0.00,0.00),('1','148','769','183228',3595751,'2183','327',1827705.52,1830810.79,0.00,0.00,3105.27,993686.40,0.00,0.00,0.00),('1','148','769','183233',3595793,'2140','327',681776.31,682800.12,0.00,0.00,1023.81,368571.60,0.00,0.00,0.00),('1','148','769','183233',3595794,'2183','327',1830810.79,1834339.36,0.00,0.00,3528.57,1129142.40,0.00,0.00,0.00),('1','148','769','183251',3595996,'2140','327',682800.12,682924.93,0.00,0.00,124.81,44931.60,0.00,0.00,0.00),('1','148','769','183251',3595997,'2183','327',1834339.36,1834997.55,0.00,0.00,658.19,210620.80,0.00,0.00,0.00),('1','148','769','183623',3603077,'2140','327',682924.93,683975.64,0.00,0.00,1050.71,378255.60,0.00,0.00,0.00),('1','148','769','183623',3603078,'2183','327',1834997.55,1836816.32,0.00,0.00,1818.77,654757.20,0.00,0.00,0.00),('1','148','769','183847',3607147,'2140','327',683975.64,685192.19,0.00,0.00,1216.55,437958.00,0.00,0.00,0.00),('1','148','769','183847',3607148,'2183','327',1836816.32,1836816.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','184121',3611993,'2140','327',685192.19,685520.01,0.00,0.00,327.82,118015.20,0.00,0.00,0.00),('1','148','769','184121',3611994,'2183','327',1836816.32,1838368.50,0.00,0.00,1552.18,496697.60,0.00,0.00,0.00),('1','148','769','184245',3614248,'2140','327',685520.01,686899.56,0.00,0.00,1379.55,496638.00,0.00,0.00,0.00),('1','148','769','184245',3614249,'2183','327',1838368.50,1841050.06,0.00,0.00,2681.56,858099.20,0.00,0.00,0.00),('1','148','769','184572',3620014,'2140','327',686899.56,687208.64,0.00,0.00,309.08,111268.80,0.00,0.00,0.00),('1','148','769','184572',3620015,'2183','327',1841050.06,1842699.54,0.00,0.00,1649.48,527833.60,0.00,0.00,0.00),('1','148','769','184754',3623265,'2140','327',687208.64,688211.30,0.00,0.00,1002.66,360957.60,0.00,0.00,0.00),('1','148','769','184754',3623266,'2183','327',1842699.54,1843727.56,0.00,0.00,1028.02,328966.40,0.00,0.00,0.00),('1','148','769','184857',3625316,'2140','327',688211.30,688646.26,0.00,0.00,434.96,156585.60,0.00,0.00,0.00),('1','148','769','184857',3625317,'2183','327',1843727.56,1844680.92,0.00,0.00,953.36,305075.20,0.00,0.00,0.00),('1','148','769','185079',3629129,'2140','327',688646.26,689783.71,0.00,0.00,1137.45,409482.00,0.00,0.00,0.00),('1','148','769','185079',3629130,'2183','327',1844680.92,1844680.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','185241',3631689,'2140','327',689783.71,691185.94,0.00,0.00,1402.23,504802.80,0.00,0.00,0.00),('1','148','769','185241',3631690,'2183','327',1844680.92,1844680.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','185436',3635330,'2140','327',691185.94,691523.75,0.00,0.00,337.81,121611.60,0.00,0.00,0.00),('1','148','769','185436',3635331,'2183','327',1844680.92,1846427.11,0.00,0.00,1746.19,558780.80,0.00,0.00,0.00),('1','148','769','186236',3649435,'2140','327',691523.75,692939.41,0.00,0.00,1415.66,509637.60,0.00,0.00,0.00),('1','148','769','186236',3649436,'2183','327',1846427.11,1848565.92,0.00,0.00,2138.81,701529.68,0.00,0.00,0.00),('1','148','769','186237',3649437,'2140','327',692939.41,693360.58,0.00,0.00,421.17,151621.20,0.00,0.00,0.00),('1','148','769','186237',3649438,'2183','327',1848565.92,1850032.75,0.00,0.00,1466.83,469385.60,0.00,0.00,0.00),('1','148','769','186292',3650381,'2140','327',693360.58,694021.57,0.00,0.00,660.99,237956.40,0.00,0.00,0.00),('1','148','769','186292',3650382,'2183','327',1850032.75,1852064.66,0.00,0.00,2031.91,666466.48,0.00,0.00,0.00),('1','148','769','186466',3653295,'2140','327',694021.57,695423.80,0.00,0.00,1402.23,504802.80,0.00,0.00,0.00),('1','148','769','186466',3653296,'2183','327',1852064.66,1852064.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','186499',3653804,'2140','327',695423.80,695746.19,0.00,0.00,322.39,116060.40,0.00,0.00,0.00),('1','148','769','186499',3653805,'2183','327',1852064.66,1853667.97,0.00,0.00,1603.31,525885.68,0.00,0.00,0.00),('1','148','769','186712',3657541,'2140','327',695746.19,696850.07,0.00,0.00,1103.88,397396.80,0.00,0.00,0.00),('1','148','769','186712',3657542,'2183','327',1853667.97,1853667.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','186949',3661516,'2140','327',696850.07,698106.84,0.00,0.00,1256.77,452437.20,0.00,0.00,0.00),('1','148','769','186949',3661517,'2183','327',1853667.97,1855423.80,0.00,0.00,1755.83,575912.24,0.00,0.00,0.00),('1','148','769','187142',3664778,'2140','327',698106.84,698530.18,0.00,0.00,423.34,152402.40,0.00,0.00,0.00),('1','148','769','187142',3664779,'2183','327',1855423.80,1856916.46,0.00,0.00,1492.66,489592.48,0.00,0.00,0.00),('1','148','769','187310',3667727,'2140','327',698530.18,699931.39,0.00,0.00,1401.21,504435.60,0.00,0.00,0.00),('1','148','769','187310',3667728,'2183','327',1856916.46,1859158.51,0.00,0.00,2242.05,735392.40,0.00,0.00,0.00),('1','148','769','187543',3671992,'2140','327',699931.39,700174.87,0.00,0.00,243.48,87652.80,0.00,0.00,0.00),('1','148','769','187543',3671993,'2183','327',1859158.51,1860090.15,0.00,0.00,931.64,305577.92,0.00,0.00,0.00),('1','148','769','187880',3677749,'2140','327',700174.87,701587.42,0.00,0.00,1412.55,508518.00,0.00,0.00,0.00),('1','148','769','187880',3677750,'2183','327',1860090.15,1860090.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','188101',3681633,'2140','327',701587.42,702543.08,0.00,0.00,955.66,344037.60,0.00,0.00,0.00),('1','148','769','188101',3681634,'2183','327',1860090.15,1863735.94,0.00,0.00,3645.79,1195819.12,0.00,0.00,0.00),('1','148','769','188189',3683343,'2140','327',702543.08,703181.63,0.00,0.00,638.55,229878.00,0.00,0.00,0.00),('1','148','769','188189',3683344,'2183','327',1863735.94,1864248.71,0.00,0.00,512.77,168188.56,0.00,0.00,0.00),('1','148','769','188302',3685066,'2140','327',703181.63,704604.68,0.00,0.00,1423.05,512298.00,0.00,0.00,0.00),('1','148','769','188302',3685067,'2183','327',1864248.71,1866356.26,0.00,0.00,2107.55,691276.40,0.00,0.00,0.00),('1','148','769','188493',3688473,'2140','327',704604.68,704920.55,0.00,0.00,315.87,113713.20,0.00,0.00,0.00),('1','148','769','188493',3688474,'2183','327',1866356.26,1866356.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','188704',3692089,'2140','327',704920.55,704920.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','188704',3692090,'2183','327',1866356.26,1867442.39,0.00,0.00,1086.13,356250.64,0.00,0.00,0.00),('1','148','769','188718',3692320,'2140','327',704920.55,705652.56,0.00,0.00,732.01,263523.60,0.00,0.00,0.00),('1','148','769','188718',3692321,'2183','327',1867442.39,1867442.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','188893',3695496,'2140','327',705652.56,707064.22,0.00,0.00,1411.66,508197.60,0.00,0.00,0.00),('1','148','769','188893',3695497,'2183','327',1867442.39,1869658.18,0.00,0.00,2215.79,726779.12,0.00,0.00,0.00),('1','148','769','189084',3698859,'2140','327',707064.22,707501.46,0.00,0.00,437.24,157406.40,0.00,0.00,0.00),('1','148','769','189084',3698860,'2183','327',1869658.18,1871486.94,0.00,0.00,1828.76,599833.28,0.00,0.00,0.00),('1','148','769','189280',3702418,'2140','327',707501.46,708914.69,0.00,0.00,1413.23,508762.80,0.00,0.00,0.00),('1','148','769','189280',3702419,'2183','327',1871486.94,1872702.48,0.00,0.00,1215.54,398697.12,0.00,0.00,0.00),('1','148','769','189457',3705607,'2140','327',708914.69,710200.42,0.00,0.00,1285.73,462862.80,0.00,0.00,0.00),('1','148','769','189457',3705608,'2183','327',1872702.48,1874357.93,0.00,0.00,1655.45,542987.60,0.00,0.00,0.00),('1','148','769','189677',3709428,'2140','327',710200.42,710200.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','189677',3709429,'2183','327',1874357.93,1874357.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','189679',3709441,'2140','327',710200.42,710521.13,0.00,0.00,320.71,115455.60,0.00,0.00,0.00),('1','148','769','189679',3709442,'2183','327',1874357.93,1876898.92,0.00,0.00,2540.99,833444.72,0.00,0.00,0.00),('1','148','769','190039',3716286,'2140','327',710521.13,711934.57,0.00,0.00,1413.44,508838.40,0.00,0.00,0.00),('1','148','769','190039',3716287,'2183','327',1876898.92,1879001.63,0.00,0.00,2102.71,689688.88,0.00,0.00,0.00),('1','148','769','190247',3720181,'2140','327',711934.57,712468.49,0.00,0.00,533.92,192211.20,0.00,0.00,0.00),('1','148','769','190247',3720182,'2183','327',1879001.63,1880968.45,0.00,0.00,1966.82,645116.96,0.00,0.00,0.00),('1','148','769','190455',3724012,'2140','327',712468.49,713787.26,0.00,0.00,1318.77,474757.20,0.00,0.00,0.00),('1','148','769','190455',3724013,'2183','327',1880968.45,1882831.45,0.00,0.00,1863.00,611064.00,0.00,0.00,0.00),('1','148','769','190861',3731818,'2140','327',713787.26,714987.97,0.00,0.00,1200.71,432255.60,0.00,0.00,0.00),('1','148','769','190861',3731819,'2183','327',1882831.45,1882831.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','191131',3736265,'2140','327',714987.97,716403.63,0.00,0.00,1415.66,509637.60,0.00,0.00,0.00),('1','148','769','191131',3736266,'2183','327',1882831.45,1884539.16,0.00,0.00,1707.71,560128.88,0.00,0.00,0.00),('1','148','769','191336',3739776,'2140','327',716403.63,716725.77,0.00,0.00,322.14,115970.40,0.00,0.00,0.00),('1','148','769','191336',3739777,'2183','327',1884539.16,1885782.02,0.00,0.00,1242.86,407658.08,0.00,0.00,0.00),('1','148','769','191678',3746664,'2140','327',716725.77,718181.65,0.00,0.00,1455.88,524116.80,0.00,0.00,0.00),('1','148','769','191678',3746665,'2183','327',1885782.02,1885782.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','191738',3747533,'2140','327',718181.65,719704.53,0.00,0.00,1522.88,548236.80,0.00,0.00,0.00),('1','148','769','191738',3747534,'2183','327',1885782.02,1885782.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','192084',3754116,'2140','327',719704.53,721127.41,0.00,0.00,1422.88,512236.80,0.00,0.00,0.00),('1','148','769','192084',3754117,'2183','327',1885782.02,1885782.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','192143',3755054,'2140','327',721127.41,722070.41,0.00,0.00,943.00,339480.00,0.00,0.00,0.00),('1','148','769','192143',3755055,'2183','327',1885782.02,1885782.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','192350',3758961,'2140','327',722070.41,723484.67,0.00,0.00,1414.26,509133.60,0.00,0.00,0.00),('1','148','769','192350',3758962,'2183','327',1885782.02,1888304.84,0.00,0.00,2522.82,827484.96,0.00,0.00,0.00),('1','148','769','192654',3764266,'2140','327',723484.67,723971.21,0.00,0.00,486.54,175154.40,0.00,0.00,0.00),('1','148','769','192654',3764267,'2183','327',1888304.84,1889919.84,0.00,0.00,1615.00,529720.00,0.00,0.00,0.00),('1','148','769','192787',3766609,'2140','327',723971.21,725379.43,0.00,0.00,1408.22,506959.20,0.00,0.00,0.00),('1','148','769','192787',3766610,'2183','327',1889919.84,1891535.66,0.00,0.00,1615.82,529988.96,0.00,0.00,0.00),('1','148','769','192989',3770417,'2140','327',725379.43,726051.54,0.00,0.00,672.11,241959.60,0.00,0.00,0.00),('1','148','769','192989',3770418,'2183','327',1891535.66,1893555.82,0.00,0.00,2020.16,662612.48,0.00,0.00,0.00),('1','148','769','193222',3774812,'2140','327',726051.54,726377.38,0.00,0.00,325.84,117302.40,0.00,0.00,0.00),('1','148','769','193222',3774813,'2183','327',1893555.82,1894740.39,0.00,0.00,1184.57,388538.96,0.00,0.00,0.00),('1','148','769','193602',3782560,'2140','327',726377.38,726701.21,0.00,0.00,323.83,116578.80,0.00,0.00,0.00),('1','148','769','193602',3782561,'2183','327',1894740.39,1895772.64,0.00,0.00,1032.25,338578.00,0.00,0.00,0.00),('1','148','769','193636',3782930,'2140','327',726701.21,728113.33,0.00,0.00,1412.12,508363.20,0.00,0.00,0.00),('1','148','769','193636',3782931,'2183','327',1895772.64,1895772.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','193974',3789064,'2140','327',728113.33,730153.89,0.00,0.00,2040.56,734601.60,0.00,0.00,0.00),('1','148','769','193974',3789065,'2183','327',1895772.64,1895772.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','194120',3791361,'2140','327',730153.89,730337.35,0.00,0.00,183.46,66045.60,0.00,0.00,0.00),('1','148','769','194120',3791362,'2183','327',1895772.64,1896797.64,0.00,0.00,1025.00,336200.00,0.00,0.00,0.00),('1','148','769','194331',3795488,'2140','327',730337.35,731340.81,0.00,0.00,1003.46,361245.60,0.00,0.00,0.00),('1','148','769','194331',3795489,'2183','327',1896797.64,1900305.97,0.00,0.00,3508.33,1150732.24,0.00,0.00,0.00),('1','148','769','194509',3798639,'2140','327',731340.81,731668.66,0.00,0.00,327.85,118026.00,0.00,0.00,0.00),('1','148','769','194509',3798640,'2183','327',1900305.97,1901332.13,0.00,0.00,1026.16,336580.48,0.00,0.00,0.00),('1','148','769','194686',3801764,'2140','327',731668.66,732775.87,0.00,0.00,1107.21,398595.60,0.00,0.00,0.00),('1','148','769','194686',3801765,'2183','327',1901332.13,1901332.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','195054',3808966,'2140','327',732775.87,734189.64,0.00,0.00,1413.77,508957.20,0.00,0.00,0.00),('1','148','769','195054',3808967,'2183','327',1901332.13,1903755.95,0.00,0.00,2423.82,795012.96,0.00,0.00,0.00),('1','148','769','195137',3810335,'2140','327',734189.64,734817.39,0.00,0.00,627.75,225990.00,0.00,0.00,0.00),('1','148','769','195137',3810336,'2183','327',1903755.95,1905344.63,0.00,0.00,1588.68,521087.04,0.00,0.00,0.00),('1','148','769','195390',3814825,'2140','327',734817.39,736229.62,0.00,0.00,1412.23,508402.80,0.00,0.00,0.00),('1','148','769','195390',3814826,'2183','327',1905344.63,1905344.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','195656',3819173,'2140','327',736229.62,737646.04,0.00,0.00,1416.42,509911.20,0.00,0.00,0.00),('1','148','769','195656',3819174,'2183','327',1905344.63,1908547.63,0.00,0.00,3203.00,1050584.00,0.00,0.00,0.00),('1','148','769','195874',3823129,'2140','327',737646.04,738082.87,0.00,0.00,436.83,157258.80,0.00,0.00,0.00),('1','148','769','195874',3823130,'2183','327',1908547.63,1909478.51,0.00,0.00,930.88,305328.64,0.00,0.00,0.00),('1','148','769','196190',3829250,'2140','327',738082.87,739497.09,0.00,0.00,1414.22,509119.20,0.00,0.00,0.00),('1','148','769','196190',3829251,'2183','327',1909478.51,1911612.04,0.00,0.00,2133.53,699797.84,0.00,0.00,0.00),('1','148','769','196396',3832962,'2140','327',739497.09,740134.93,0.00,0.00,637.84,229622.40,0.00,0.00,0.00),('1','148','769','196396',3832963,'2183','327',1911612.04,1913416.04,0.00,0.00,1804.00,591712.00,0.00,0.00,0.00),('1','148','769','196630',3837190,'2140','327',740134.93,741575.29,0.00,0.00,1440.36,518529.60,0.00,0.00,0.00),('1','148','769','196630',3837191,'2183','327',1913416.04,1913416.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','196713',3838378,'2140','327',741575.29,742985.65,0.00,0.00,1410.36,507729.60,0.00,0.00,0.00),('1','148','769','196713',3838379,'2183','327',1913416.04,1913416.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','196912',3841962,'2140','327',742985.65,743324.88,0.00,0.00,339.23,122122.80,0.00,0.00,0.00),('1','148','769','196912',3841963,'2183','327',1913416.04,1916296.92,0.00,0.00,2880.88,933405.12,0.00,0.00,0.00),('1','148','769','197199',3847251,'2140','327',743324.88,743526.20,0.00,0.00,201.32,72475.20,0.00,0.00,0.00),('1','148','769','197199',3847252,'2183','327',1916296.92,1916993.60,0.00,0.00,696.68,225724.32,0.00,0.00,0.00),('1','148','769','197345',3850146,'2140','327',743526.20,744981.48,0.00,0.00,1455.28,523900.80,0.00,0.00,0.00),('1','148','769','197345',3850147,'2183','327',1916993.60,1916993.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','197486',3852030,'2140','327',744981.48,746612.88,0.00,0.00,1631.40,587304.00,0.00,0.00,0.00),('1','148','769','197486',3852031,'2183','327',1916993.60,1916993.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','197970',3860594,'2140','327',746612.88,748035.65,0.00,0.00,1422.77,512197.20,0.00,0.00,0.00),('1','148','769','197970',3860595,'2183','327',1916993.60,1916993.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','198203',3864455,'2140','327',748035.65,749649.91,0.00,0.00,1614.26,581133.60,0.00,0.00,0.00),('1','148','769','198203',3864456,'2183','327',1916993.60,1916993.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','198219',3864677,'2140','327',749649.91,751165.62,0.00,0.00,1515.71,545655.60,0.00,0.00,0.00),('1','148','769','198219',3864678,'2183','327',1916993.60,1916993.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','198541',3870465,'2140','327',751165.62,751654.26,0.00,0.00,488.64,175910.40,0.00,0.00,0.00),('1','148','769','198541',3870466,'2183','327',1916993.60,1921021.96,0.00,0.00,4028.36,1289075.20,0.00,0.00,0.00),('1','148','769','198738',3873941,'2140','327',751654.26,753070.98,0.00,0.00,1416.72,510019.20,0.00,0.00,0.00),('1','148','769','198738',3873942,'2183','327',1921021.96,1925654.24,0.00,0.00,4632.28,1482329.60,0.00,0.00,0.00),('1','148','769','198961',3877548,'2140','327',753070.98,753485.06,0.00,0.00,414.08,149068.80,0.00,0.00,0.00),('1','148','769','198961',3877549,'2183','327',1925654.24,1926621.12,0.00,0.00,966.88,309401.60,0.00,0.00,0.00),('1','148','769','199401',3885081,'2140','327',753485.06,754913.68,0.00,0.00,1428.62,514303.20,0.00,0.00,0.00),('1','148','769','199401',3885082,'2183','327',1926621.12,1929221.50,0.00,0.00,2600.38,832121.60,0.00,0.00,0.00),('1','148','769','199405',3885129,'2140','327',754913.68,755232.10,0.00,0.00,318.42,114631.20,0.00,0.00,0.00),('1','148','769','199405',3885130,'2183','327',1929221.50,1930909.08,0.00,0.00,1687.58,540025.60,0.00,0.00,0.00),('1','148','769','199750',3890496,'2140','327',755232.10,756639.73,0.00,0.00,1407.63,506746.80,0.00,0.00,0.00),('1','148','769','199750',3890497,'2183','327',1930909.08,1932931.92,0.00,0.00,2022.84,647308.80,0.00,0.00,0.00),('1','148','769','199965',3894279,'2140','327',756639.73,757173.55,0.00,0.00,533.82,192175.20,0.00,0.00,0.00),('1','148','769','199965',3894280,'2183','327',1932931.92,1934933.92,0.00,0.00,2002.00,640640.00,0.00,0.00,0.00),('1','148','769','200070',3896440,'2140','327',757173.55,757292.32,0.00,0.00,118.77,42757.20,0.00,0.00,0.00),('1','148','769','200070',3896441,'2183','327',1934933.92,1935511.15,0.00,0.00,577.23,184713.60,0.00,0.00,0.00),('1','148','769','200273',3900017,'2140','327',757292.32,757904.65,0.00,0.00,612.33,220438.80,0.00,0.00,0.00),('1','148','769','200273',3900018,'2183','327',1935511.15,1936927.97,0.00,0.00,1416.82,453382.40,0.00,0.00,0.00),('1','148','769','200526',3904451,'2140','327',757904.65,759320.33,0.00,0.00,1415.68,509644.80,0.00,0.00,0.00),('1','148','769','200526',3904452,'2183','327',1936927.97,1939485.97,0.00,0.00,2558.00,818560.00,0.00,0.00,0.00),('1','148','769','200538',3904603,'2140','327',759320.33,760732.03,0.00,0.00,1411.70,508212.00,0.00,0.00,0.00),('1','148','769','200538',3904604,'2183','327',1939485.97,1941495.36,0.00,0.00,2009.39,643004.80,0.00,0.00,0.00),('1','148','769','200569',3905134,'2140','327',760732.03,761299.36,0.00,0.00,567.33,204238.80,0.00,0.00,0.00),('1','148','769','200569',3905135,'2183','327',1941495.36,1943509.36,0.00,0.00,2014.00,644480.00,0.00,0.00,0.00),('1','148','769','200673',3907300,'2140','327',761299.36,761412.39,0.00,0.00,113.03,40690.80,0.00,0.00,0.00),('1','148','769','200673',3907301,'2183','327',1943509.36,1944298.36,0.00,0.00,789.00,252480.00,0.00,0.00,0.00),('1','148','769','200726',3907957,'2140','327',761412.39,761879.71,0.00,0.00,467.32,168235.20,0.00,0.00,0.00),('1','148','769','200726',3907958,'2183','327',1944298.36,1945374.59,0.00,0.00,1076.23,344393.60,0.00,0.00,0.00),('1','148','769','201166',3915338,'2140','327',761879.71,762603.58,0.00,0.00,723.87,260593.20,0.00,0.00,0.00),('1','148','769','201166',3915339,'2183','327',1945374.59,1945374.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','201167',3915340,'2140','327',762603.58,763423.24,0.00,0.00,819.66,295077.60,0.00,0.00,0.00),('1','148','769','201167',3915341,'2183','327',1945374.59,1945374.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','201479',3921294,'2140','327',763423.24,764509.55,0.00,0.00,1086.31,391071.60,0.00,0.00,0.00),('1','148','769','201479',3921295,'2183','327',1945374.59,1947251.59,0.00,0.00,1877.00,600640.00,0.00,0.00,0.00),('1','148','769','201854',3928262,'2140','327',764509.55,765925.18,0.00,0.00,1415.63,509626.80,0.00,0.00,0.00),('1','148','769','201854',3928263,'2183','327',1947251.59,1951882.72,0.00,0.00,4631.13,1481961.60,0.00,0.00,0.00),('1','148','769','201861',3928364,'2140','327',765925.18,765963.01,0.00,0.00,37.83,13618.80,0.00,0.00,0.00),('1','148','769','201861',3928365,'2183','327',1951882.72,1952721.60,0.00,0.00,838.88,268441.60,0.00,0.00,0.00),('1','148','769','202155',3933824,'2140','327',765963.01,766990.34,0.00,0.00,1027.33,369838.80,0.00,0.00,0.00),('1','148','769','202155',3933825,'2183','327',1952721.60,1955508.23,0.00,0.00,2786.63,936307.68,0.00,0.00,0.00),('1','148','769','202158',3933857,'2140','327',766990.34,767177.06,0.00,0.00,186.72,67219.20,0.00,0.00,0.00),('1','148','769','202158',3933858,'2183','327',1955508.23,1956873.61,0.00,0.00,1365.38,458767.68,0.00,0.00,0.00),('1','148','769','202403',3938120,'2140','327',767177.06,767889.39,0.00,0.00,712.33,256438.80,0.00,0.00,0.00),('1','148','769','202403',3938121,'2183','327',1956873.61,1956873.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','202619',3941913,'2140','327',767889.39,769378.02,0.00,0.00,1488.63,535906.80,0.00,0.00,0.00),('1','148','769','202619',3941914,'2183','327',1956873.61,1956873.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','202818',3945484,'2140','327',769378.02,770927.06,0.00,0.00,1549.04,557654.40,0.00,0.00,0.00),('1','148','769','202818',3945485,'2183','327',1956873.61,1956873.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','203083',3950527,'2140','327',770927.06,771927.08,0.00,0.00,1000.02,360007.20,0.00,0.00,0.00),('1','148','769','203083',3950528,'2183','327',1956873.61,1956873.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','203246',3953381,'2140','327',771927.08,773413.79,0.00,0.00,1486.71,535215.60,0.00,0.00,0.00),('1','148','769','203246',3953382,'2183','327',1956873.61,1956873.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','203472',3957507,'2140','327',773413.79,774425.11,0.00,0.00,1011.32,364075.20,0.00,0.00,0.00),('1','148','769','203472',3957508,'2183','327',1956873.61,1959093.97,0.00,0.00,2220.36,746040.96,0.00,0.00,0.00),('1','148','769','203701',3961700,'2140','327',774425.11,775924.35,0.00,0.00,1499.24,539726.40,0.00,0.00,0.00),('1','148','769','203701',3961701,'2183','327',1959093.97,1961418.97,0.00,0.00,2325.00,781200.00,0.00,0.00,0.00),('1','148','769','204007',3966651,'2140','327',775924.35,776090.73,0.00,0.00,166.38,62558.88,0.00,0.00,0.00),('1','148','769','204007',3966652,'2183','327',1961418.97,1964484.08,0.00,0.00,3065.11,1029876.96,0.00,0.00,0.00),('1','148','769','204029',3967159,'2140','327',776090.73,777108.05,0.00,0.00,1017.32,382512.32,0.00,0.00,0.00),('1','148','769','204029',3967160,'2183','327',1964484.08,1964484.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','204484',3975505,'2140','327',777108.05,777306.19,0.00,0.00,198.14,74500.64,0.00,0.00,0.00),('1','148','769','204484',3975506,'2183','327',1964484.08,1965081.34,0.00,0.00,597.26,205457.44,0.00,0.00,0.00),('1','148','769','204495',3975712,'2140','327',777306.19,778590.12,0.00,0.00,1283.93,482757.68,0.00,0.00,0.00),('1','148','769','204495',3975713,'2183','327',1965081.34,1968663.52,0.00,0.00,3582.18,1232269.92,0.00,0.00,0.00),('1','148','769','204695',3979290,'2140','327',778590.12,778865.15,0.00,0.00,275.03,103411.28,0.00,0.00,0.00),('1','148','769','204695',3979291,'2183','327',1968663.52,1969529.45,0.00,0.00,865.93,297879.92,0.00,0.00,0.00),('1','148','769','204864',3981907,'2140','327',778865.15,780005.68,0.00,0.00,1140.53,428839.28,0.00,0.00,0.00),('1','148','769','204864',3981908,'2183','327',1969529.45,1971624.30,0.00,0.00,2094.85,720628.40,0.00,0.00,0.00),('1','148','769','205177',3987862,'2140','327',780005.68,781247.76,0.00,0.00,1242.08,467022.08,0.00,0.00,0.00),('1','148','769','205177',3987863,'2183','327',1971624.30,1973124.31,0.00,0.00,1500.01,516003.44,0.00,0.00,0.00),('1','148','769','205297',3989767,'2140','327',781247.76,781647.77,0.00,0.00,400.01,150403.76,0.00,0.00,0.00),('1','148','769','205297',3989768,'2183','327',1973124.31,1974415.29,0.00,0.00,1290.98,444097.12,0.00,0.00,0.00),('1','148','769','205553',3994451,'2140','327',781647.77,782954.94,0.00,0.00,1307.17,491495.92,0.00,0.00,0.00),('1','148','769','205553',3994452,'2183','327',1974415.29,1975287.13,0.00,0.00,871.84,299912.96,0.00,0.00,0.00),('1','148','769','205822',3999351,'2140','327',782954.94,783955.36,0.00,0.00,1000.42,376157.92,0.00,0.00,0.00),('1','148','769','205822',3999352,'2183','327',1975287.13,1976987.06,0.00,0.00,1699.93,584775.92,0.00,0.00,0.00),('1','148','769','205998',4002451,'2140','327',783955.36,784344.60,0.00,0.00,389.24,146354.24,0.00,0.00,0.00),('1','148','769','205998',4002452,'2183','327',1976987.06,1977679.70,0.00,0.00,692.64,238268.16,0.00,0.00,0.00),('1','148','769','206288',4007687,'2140','327',784344.60,784815.74,0.00,0.00,471.14,177148.64,0.00,0.00,0.00),('1','148','769','206288',4007688,'2183','327',1977679.70,1978987.63,0.00,0.00,1307.93,449927.92,0.00,0.00,0.00),('1','148','769','206298',4007860,'2140','327',784815.74,785807.66,0.00,0.00,991.92,372961.92,0.00,0.00,0.00),('1','148','769','206298',4007861,'2183','327',1978987.63,1980277.52,0.00,0.00,1289.89,443722.16,0.00,0.00,0.00),('1','148','769','206553',4012329,'2140','327',785807.66,786612.48,0.00,0.00,804.82,302612.32,0.00,0.00,0.00),('1','148','769','206553',4012330,'2183','327',1980277.52,1981977.83,0.00,0.00,1700.31,584906.64,0.00,0.00,0.00),('1','148','769','206556',4012360,'2140','327',786612.48,786858.00,0.00,0.00,245.52,92315.52,0.00,0.00,0.00),('1','148','769','206556',4012361,'2183','327',1981977.83,1982537.35,0.00,0.00,559.52,192474.88,0.00,0.00,0.00),('1','148','769','206741',4015574,'2140','327',786858.00,788443.91,0.00,0.00,1585.91,596302.16,0.00,0.00,0.00),('1','148','769','206741',4015575,'2183','327',1982537.35,1984501.76,0.00,0.00,1964.41,675757.04,0.00,0.00,0.00),('1','148','769','207002',4020409,'2140','327',788443.91,788803.65,0.00,0.00,359.74,135262.24,0.00,0.00,0.00),('1','148','769','207002',4020410,'2183','327',1984501.76,1985152.02,0.00,0.00,650.26,223689.44,0.00,0.00,0.00),('1','148','769','207003',4020411,'2140','327',788803.65,789800.29,0.00,0.00,996.64,374736.64,0.00,0.00,0.00),('1','148','769','207003',4020412,'2183','327',1985152.02,1986572.58,0.00,0.00,1420.56,488672.64,0.00,0.00,0.00),('1','148','769','207201',4023846,'2140','327',789800.29,790860.71,0.00,0.00,1060.42,398717.92,0.00,0.00,0.00),('1','148','769','207201',4023847,'2183','327',1986572.58,1987786.99,0.00,0.00,1214.41,417757.04,0.00,0.00,0.00),('1','148','769','207377',4026800,'2140','327',790860.71,791206.31,0.00,0.00,345.60,129945.60,0.00,0.00,0.00),('1','148','769','207377',4026801,'2183','327',1987786.99,1988086.99,0.00,0.00,300.00,103200.00,0.00,0.00,0.00),('1','148','769','207556',4030057,'2140','327',791206.31,791703.20,0.00,0.00,496.89,186830.64,0.00,0.00,0.00),('1','148','769','207556',4030058,'2183','327',1988086.99,1988457.31,0.00,0.00,370.32,127390.08,0.00,0.00,0.00),('1','148','769','207570',4030375,'2140','327',791703.20,791703.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','207570',4030376,'2183','327',1988457.31,1989447.81,0.00,0.00,990.50,340732.00,0.00,0.00,0.00),('1','148','769','207580',4030537,'2140','327',791703.20,793235.90,0.00,0.00,1532.70,576295.20,0.00,0.00,0.00),('1','148','769','207580',4030538,'2183','327',1989447.81,1992863.70,0.00,0.00,3415.89,1175066.16,0.00,0.00,0.00),('1','148','769','207805',4034261,'2140','327',793235.90,793235.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','207805',4034262,'2183','327',1992863.70,1993224.65,0.00,0.00,360.95,124166.80,0.00,0.00,0.00),('1','148','769','207854',4035206,'2140','327',793235.90,794032.03,0.00,0.00,796.13,305713.92,0.00,0.00,0.00),('1','148','769','207854',4035207,'2183','327',1993224.65,1993930.99,0.00,0.00,706.34,248631.68,0.00,0.00,0.00),('1','148','769','208008',4037778,'2140','327',794032.03,795370.95,0.00,0.00,1338.92,514145.28,0.00,0.00,0.00),('1','148','769','208008',4037779,'2183','327',1993930.99,1995065.71,0.00,0.00,1134.72,399421.44,0.00,0.00,0.00),('1','148','769','208204',4041311,'2140','327',795370.95,795999.83,0.00,0.00,628.88,241489.92,0.00,0.00,0.00),('1','148','769','208204',4041312,'2183','327',1995065.71,1995789.49,0.00,0.00,723.78,254770.56,0.00,0.00,0.00),('1','148','769','208455',4045603,'2140','327',795999.83,797004.27,0.00,0.00,1004.44,385704.96,0.00,0.00,0.00),('1','148','769','208455',4045604,'2183','327',1995789.49,1997602.71,0.00,0.00,1813.22,638253.44,0.00,0.00,0.00),('1','148','769','208486',4046243,'2140','327',797004.27,797453.27,0.00,0.00,449.00,172416.00,0.00,0.00,0.00),('1','148','769','208486',4046244,'2183','327',1997602.71,1998969.67,0.00,0.00,1366.96,481169.92,0.00,0.00,0.00),('1','148','769','208667',4049390,'2140','327',797453.27,797699.79,0.00,0.00,246.52,94663.68,0.00,0.00,0.00),('1','148','769','208667',4049391,'2183','327',1998969.67,1999105.67,0.00,0.00,136.00,47872.00,0.00,0.00,0.00),('1','148','769','208727',4050598,'2140','327',797699.79,798606.25,0.00,0.00,906.46,348080.64,0.00,0.00,0.00),('1','148','769','208727',4050599,'2183','327',1999105.67,2001678.81,0.00,0.00,2573.14,905745.28,0.00,0.00,0.00),('1','148','769','208901',4053490,'2140','327',798606.25,799124.03,0.00,0.00,517.78,198827.52,0.00,0.00,0.00),('1','148','769','208901',4053491,'2183','327',2001678.81,2003441.79,0.00,0.00,1762.98,620568.96,0.00,0.00,0.00),('1','148','769','209073',4056315,'2140','327',799124.03,799532.77,0.00,0.00,408.74,156956.16,0.00,0.00,0.00),('1','148','769','209073',4056316,'2183','327',2003441.79,2003903.53,0.00,0.00,461.74,162532.48,0.00,0.00,0.00),('1','148','769','209095',4056719,'2140','327',799532.77,799635.75,0.00,0.00,102.98,39544.32,0.00,0.00,0.00),('1','148','769','209095',4056720,'2183','327',2003903.53,2003903.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','209099',4056760,'2140','327',799635.75,799688.59,0.00,0.00,52.84,20290.56,0.00,0.00,0.00),('1','148','769','209099',4056761,'2183','327',2003903.53,2004447.73,0.00,0.00,544.20,191558.40,0.00,0.00,0.00),('1','148','769','209135',4057451,'2140','327',799688.59,800239.63,0.00,0.00,551.04,220416.00,0.00,0.00,0.00),('1','148','769','209135',4057452,'2183','327',2004447.73,2005338.41,0.00,0.00,890.68,331332.96,0.00,0.00,0.00),('1','148','769','209333',4060958,'2140','327',800239.63,801077.16,0.00,0.00,837.53,334172.00,0.00,0.00,0.00),('1','148','769','209333',4060959,'2183','327',2005338.41,2007122.78,0.00,0.00,1784.37,663785.64,0.00,0.00,0.00),('1','148','769','209608',4066082,'2140','327',801077.16,802018.62,0.00,0.00,941.46,376584.00,0.00,0.00,0.00),('1','148','769','209608',4066083,'2183','327',2007122.78,2008776.32,0.00,0.00,1653.54,615116.88,0.00,0.00,0.00),('1','148','769','209681',4067148,'2140','327',802018.62,802250.44,0.00,0.00,231.82,92728.00,0.00,0.00,0.00),('1','148','769','209681',4067149,'2183','327',2008776.32,2010310.36,0.00,0.00,1534.04,570662.88,0.00,0.00,0.00),('1','148','769','209983',4072629,'2140','327',802250.44,803360.54,0.00,0.00,1110.10,444040.00,0.00,0.00,0.00),('1','148','769','209983',4072630,'2183','327',2010310.36,2011923.46,0.00,0.00,1613.10,600073.20,0.00,0.00,0.00),('1','148','769','209986',4072650,'2140','327',803360.54,804407.77,0.00,0.00,1047.23,439836.60,0.00,0.00,0.00),('1','148','769','209986',4072651,'2183','327',2011923.46,2013306.53,0.00,0.00,1383.07,520034.32,0.00,0.00,0.00),('1','148','769','210192',4076207,'2140','327',804407.77,804507.87,0.00,0.00,100.10,42042.00,0.00,0.00,0.00),('1','148','769','210192',4076208,'2183','327',2013306.53,2013761.26,0.00,0.00,454.73,170978.48,0.00,0.00,0.00),('1','148','769','210197',4076275,'2140','327',804507.87,805282.87,0.00,0.00,775.00,325500.00,0.00,0.00,0.00),('1','148','769','210197',4076276,'2183','327',2013761.26,2013926.34,0.00,0.00,165.08,69333.60,0.00,0.00,0.00),('1','148','769','210414',4080227,'2140','327',805282.87,806040.93,0.00,0.00,758.06,318385.20,0.00,0.00,0.00),('1','148','769','210414',4080228,'2183','327',2013926.34,2014298.69,0.00,0.00,372.35,156387.00,0.00,0.00,0.00),('1','148','769','210830',4087676,'2140','327',806040.93,806843.07,0.00,0.00,802.14,336898.80,0.00,0.00,0.00),('1','148','769','210830',4087677,'2183','327',2014298.69,2014455.83,0.00,0.00,157.14,65998.80,0.00,0.00,0.00),('1','148','769','210838',4087739,'2140','327',806843.07,808173.97,0.00,0.00,1330.90,558978.00,0.00,0.00,0.00),('1','148','769','210838',4087740,'2183','327',2014455.83,2014455.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','211095',4092277,'2140','327',808173.97,808393.00,0.00,0.00,219.03,91992.60,0.00,0.00,0.00),('1','148','769','211095',4092278,'2183','327',2014455.83,2014455.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','211101',4092403,'2140','327',808393.00,810031.32,0.00,0.00,1638.32,688094.40,0.00,0.00,0.00),('1','148','769','211101',4092404,'2183','327',2014455.83,2015034.78,0.00,0.00,578.95,243159.00,0.00,0.00,0.00),('1','148','769','211457',4098654,'2140','327',810031.32,810219.72,0.00,0.00,188.40,79128.00,0.00,0.00,0.00),('1','148','769','211457',4098655,'2183','327',2015034.78,2015279.94,0.00,0.00,245.16,102967.20,0.00,0.00,0.00),('1','148','769','211471',4098915,'2140','327',810219.72,810473.80,0.00,0.00,254.08,106713.60,0.00,0.00,0.00),('1','148','769','211471',4098916,'2183','327',2015279.94,2015975.35,0.00,0.00,695.41,261474.16,0.00,0.00,0.00),('1','148','769','211499',4099387,'2140','327',810473.80,810656.23,0.00,0.00,182.43,76620.60,0.00,0.00,0.00),('1','148','769','211499',4099388,'2183','327',2015975.35,2017275.07,0.00,0.00,1299.72,488694.72,0.00,0.00,0.00),('1','148','769','211758',4103917,'2140','327',810656.23,811507.35,0.00,0.00,851.12,357470.40,0.00,0.00,0.00),('1','148','769','211758',4103918,'2183','327',2017275.07,2018344.20,0.00,0.00,1069.13,401992.88,0.00,0.00,0.00),('1','148','769','211759',4103919,'2140','327',811507.35,812213.79,0.00,0.00,706.44,296704.80,0.00,0.00,0.00),('1','148','769','211759',4103920,'2183','327',2018344.20,2020666.99,0.00,0.00,2322.79,873369.04,0.00,0.00,0.00),('1','148','769','212087',4109659,'2140','327',812213.79,812748.49,0.00,0.00,534.70,224574.00,0.00,0.00,0.00),('1','148','769','212087',4109660,'2183','327',2020666.99,2021184.14,0.00,0.00,517.15,194448.40,0.00,0.00,0.00),('1','148','769','212109',4110081,'2140','327',812748.49,813058.54,0.00,0.00,310.05,130221.00,0.00,0.00,0.00),('1','148','769','212109',4110082,'2183','327',2021184.14,2021184.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','212112',4110112,'2140','327',813058.54,814643.41,0.00,0.00,1584.87,665645.40,0.00,0.00,0.00),('1','148','769','212112',4110113,'2183','327',2021184.14,2021184.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','212305',4113457,'2140','327',814643.41,815813.82,0.00,0.00,1170.41,491572.20,0.00,0.00,0.00),('1','148','769','212305',4113458,'2183','327',2021184.14,2021184.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','212998',4125944,'2140','327',815813.82,816128.65,0.00,0.00,314.83,132228.60,0.00,0.00,0.00),('1','148','769','212998',4125945,'2183','327',2021184.14,2021184.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','213006',4126114,'2140','327',816128.65,817210.39,0.00,0.00,1081.74,454330.80,0.00,0.00,0.00),('1','148','769','213006',4126115,'2183','327',2021184.14,2021184.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','213015',4126270,'2140','327',817210.39,817513.25,0.00,0.00,302.86,127201.20,0.00,0.00,0.00),('1','148','769','213015',4126271,'2183','327',2021184.14,2021568.98,0.00,0.00,384.84,161632.80,0.00,0.00,0.00),('1','148','769','213226',4129710,'2140','327',817513.25,818713.26,0.00,0.00,1200.01,504004.20,0.00,0.00,0.00),('1','148','769','213226',4129711,'2183','327',2021568.98,2021568.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','213241',4129876,'2140','327',818713.26,819759.24,0.00,0.00,1045.98,439311.60,0.00,0.00,0.00),('1','148','769','213241',4129877,'2183','327',2021568.98,2023220.97,0.00,0.00,1651.99,647580.08,0.00,0.00,0.00),('1','148','769','213554',4135087,'2140','327',819759.24,820001.94,0.00,0.00,242.70,101934.00,0.00,0.00,0.00),('1','148','769','213554',4135088,'2183','327',2023220.97,2023784.44,0.00,0.00,563.47,220880.24,0.00,0.00,0.00),('1','148','769','213723',4137964,'2140','327',820001.94,820523.15,0.00,0.00,521.21,218908.20,0.00,0.00,0.00),('1','148','769','213723',4137965,'2183','327',2023784.44,2025908.22,0.00,0.00,2123.78,832521.76,0.00,0.00,0.00),('1','148','769','213732',4138089,'2140','327',820523.15,821558.02,0.00,0.00,1034.87,434645.40,0.00,0.00,0.00),('1','148','769','213732',4138090,'2183','327',2025908.22,2027440.28,0.00,0.00,1532.06,600567.52,0.00,0.00,0.00),('1','148','769','213984',4142207,'2140','327',821558.02,822712.07,0.00,0.00,1154.05,484701.00,0.00,0.00,0.00),('1','148','769','213984',4142208,'2183','327',2027440.28,2029761.20,0.00,0.00,2320.92,909800.64,0.00,0.00,0.00),('1','148','769','214507',4151342,'2140','327',822712.07,824633.21,0.00,0.00,1921.14,773026.80,0.00,0.00,0.00),('1','148','769','214507',4151343,'2183','327',2029761.20,2029761.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','214639',4153363,'2140','327',824633.21,826643.92,0.00,0.00,2010.71,844498.20,0.00,0.00,0.00),('1','148','769','214639',4153364,'2183','327',2029761.20,2031323.46,0.00,0.00,1562.26,612405.92,0.00,0.00,0.00),('1','148','769','214664',4153810,'2140','327',826643.92,828755.03,0.00,0.00,2111.11,873118.40,0.00,0.00,0.00),('1','148','769','214664',4153811,'2183','327',2031323.46,2031323.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','214890',4157730,'2140','327',828755.03,831423.24,0.00,0.00,2668.21,1086679.72,0.00,0.00,0.00),('1','148','769','214890',4157731,'2183','327',2031323.46,2031323.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','215140',4162024,'2140','327',831423.24,832650.45,0.00,0.00,1227.21,515428.20,0.00,0.00,0.00),('1','148','769','215140',4162025,'2183','327',2031323.46,2032352.03,0.00,0.00,1028.57,403199.44,0.00,0.00,0.00),('1','148','769','215329',4165231,'2140','327',832650.45,832909.00,0.00,0.00,258.55,115830.40,0.00,0.00,0.00),('1','148','769','215329',4165232,'2183','327',2032352.03,2032626.80,0.00,0.00,274.77,114304.32,0.00,0.00,0.00),('1','148','769','215485',4167687,'2140','327',832909.00,833871.95,0.00,0.00,962.95,431401.60,0.00,0.00,0.00),('1','148','769','215485',4167688,'2183','327',2032626.80,2032626.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','215499',4167929,'2140','327',833871.95,833871.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','215499',4167930,'2183','327',2032626.80,2033862.27,0.00,0.00,1235.47,425001.68,0.00,0.00,0.00),('1','148','769','215504',4168018,'2140','327',833871.95,835391.67,0.00,0.00,1519.72,680834.56,0.00,0.00,0.00),('1','148','769','215504',4168019,'2183','327',2033862.27,2034234.39,0.00,0.00,372.12,154801.92,0.00,0.00,0.00),('1','148','769','215738',4172048,'2140','327',835391.67,835795.30,0.00,0.00,403.63,180826.24,0.00,0.00,0.00),('1','148','769','215738',4172049,'2183','327',2034234.39,2035130.61,0.00,0.00,896.22,372827.52,0.00,0.00,0.00),('1','148','769','216203',4180092,'2140','327',835795.30,836736.30,0.00,0.00,941.00,421568.00,0.00,0.00,0.00),('1','148','769','216203',4180093,'2183','327',2035130.61,2035130.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','216209',4180184,'2140','327',836736.30,838241.86,0.00,0.00,1505.56,674490.88,0.00,0.00,0.00),('1','148','769','216209',4180185,'2183','327',2035130.61,2036371.10,0.00,0.00,1240.49,516043.84,0.00,0.00,0.00),('1','148','769','216256',4181070,'2140','327',838241.86,839244.34,0.00,0.00,1002.48,449111.04,0.00,0.00,0.00),('1','148','769','216256',4181071,'2183','327',2036371.10,2037784.08,0.00,0.00,1412.98,587799.68,0.00,0.00,0.00),('1','148','769','216413',4183687,'2140','327',839244.34,840506.85,0.00,0.00,1262.51,570654.52,0.00,0.00,0.00),('1','148','769','216413',4183688,'2183','327',2037784.08,2039848.94,0.00,0.00,2064.86,858981.76,0.00,0.00,0.00),('1','148','769','216707',4188970,'2140','327',840506.85,841510.30,0.00,0.00,1003.45,453559.40,0.00,0.00,0.00),('1','148','769','216707',4188971,'2183','327',2039848.94,2040848.94,0.00,0.00,1000.00,416000.00,0.00,0.00,0.00),('1','148','769','216944',4193158,'2140','327',841510.30,841625.80,0.00,0.00,115.50,52206.00,0.00,0.00,0.00),('1','148','769','216944',4193159,'2183','327',2040848.94,2041231.37,0.00,0.00,382.43,172858.36,0.00,0.00,0.00),('1','148','769','217120',4196196,'2140','327',841625.80,842678.44,0.00,0.00,1052.64,475793.28,0.00,0.00,0.00),('1','148','769','217120',4196197,'2183','327',2041231.37,2041915.97,0.00,0.00,684.60,309439.20,0.00,0.00,0.00),('1','148','769','217129',4196314,'2140','327',842678.44,843352.24,0.00,0.00,673.80,322990.56,0.00,0.00,0.00),('1','148','769','217129',4196315,'2183','327',2041915.97,2041915.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','217391',4201141,'2140','327',843352.24,843729.39,0.00,0.00,377.15,181032.00,0.00,0.00,0.00),('1','148','769','217391',4201142,'2183','327',2041915.97,2041915.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','217397',4201224,'2140','327',843729.39,845139.76,0.00,0.00,1410.37,676977.60,0.00,0.00,0.00),('1','148','769','217397',4201225,'2183','327',2041915.97,2042611.66,0.00,0.00,695.69,333931.20,0.00,0.00,0.00),('1','148','769','217838',4209112,'2140','327',845139.76,845760.63,0.00,0.00,620.87,298017.60,0.00,0.00,0.00),('1','148','769','217838',4209113,'2183','327',2042611.66,2043123.00,0.00,0.00,511.34,245443.20,0.00,0.00,0.00),('1','148','769','217849',4209380,'2140','327',845760.63,846427.71,0.00,0.00,667.08,320198.40,0.00,0.00,0.00),('1','148','769','217849',4209381,'2183','327',2043123.00,2043589.20,0.00,0.00,466.20,223776.00,0.00,0.00,0.00),('1','148','769','218054',4212763,'2140','327',846427.71,848173.02,0.00,0.00,1745.31,837748.80,0.00,0.00,0.00),('1','148','769','218054',4212764,'2183','327',2043589.20,2043589.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','218300',4217107,'2140','327',848173.02,849249.37,0.00,0.00,1076.35,516648.00,0.00,0.00,0.00),('1','148','769','218300',4217108,'2183','327',2043589.20,2044554.82,0.00,0.00,965.62,424872.80,0.00,0.00,0.00),('1','148','769','218525',4221149,'2140','327',849249.37,849866.46,0.00,0.00,617.09,296203.20,0.00,0.00,0.00),('1','148','769','218525',4221150,'2183','327',2044554.82,2045526.99,0.00,0.00,972.17,437754.80,0.00,0.00,0.00),('1','148','769','218744',4224905,'2140','327',849866.46,850914.82,0.00,0.00,1048.36,503212.80,0.00,0.00,0.00),('1','148','769','218744',4224906,'2183','327',2045526.99,2046971.13,0.00,0.00,1444.14,635421.60,0.00,0.00,0.00),('1','148','769','218978',4229010,'2140','327',850914.82,851894.81,0.00,0.00,979.99,470395.20,0.00,0.00,0.00),('1','148','769','218978',4229011,'2183','327',2046971.13,2048356.25,0.00,0.00,1385.12,609452.80,0.00,0.00,0.00),('1','148','769','219349',4235447,'2140','327',851894.81,853182.39,0.00,0.00,1287.58,618038.40,0.00,0.00,0.00),('1','148','769','219349',4235448,'2183','327',2048356.25,2050185.85,0.00,0.00,1829.60,805024.00,0.00,0.00,0.00),('1','148','769','219375',4235802,'2140','327',853182.39,853712.66,0.00,0.00,530.27,254529.60,0.00,0.00,0.00),('1','148','769','219375',4235803,'2183','327',2050185.85,2051251.98,0.00,0.00,1066.13,469097.20,0.00,0.00,0.00),('1','148','769','219577',4239626,'2140','327',853712.66,853989.66,0.00,0.00,277.00,132960.00,0.00,0.00,0.00),('1','148','769','219577',4239627,'2183','327',2051251.98,2051251.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','219578',4239628,'2140','327',853989.66,854926.75,0.00,0.00,937.09,449803.20,0.00,0.00,0.00),('1','148','769','219578',4239629,'2183','327',2051251.98,2052604.53,0.00,0.00,1352.55,595122.00,0.00,0.00,0.00),('1','148','769','219795',4243602,'2140','327',854926.75,855889.22,0.00,0.00,962.47,461985.60,0.00,0.00,0.00),('1','148','769','219795',4243603,'2183','327',2052604.53,2053604.76,0.00,0.00,1000.23,440101.20,0.00,0.00,0.00),('1','148','769','220065',4248165,'2140','327',855889.22,856039.22,0.00,0.00,150.00,72000.00,0.00,0.00,0.00),('1','148','769','220065',4248166,'2183','327',2053604.76,2054454.76,0.00,0.00,850.00,369600.00,0.00,0.00,0.00),('1','148','769','220233',4251301,'2140','327',856039.22,856910.78,0.00,0.00,871.56,418348.80,0.00,0.00,0.00),('1','148','769','220233',4251302,'2183','327',2054454.76,2055548.33,0.00,0.00,1093.57,472422.24,0.00,0.00,0.00),('1','148','769','220237',4251356,'2140','327',856910.78,857846.52,0.00,0.00,935.74,449155.20,0.00,0.00,0.00),('1','148','769','220237',4251357,'2183','327',2055548.33,2056769.61,0.00,0.00,1221.28,527592.96,0.00,0.00,0.00),('1','148','769','220469',4255584,'2140','327',857846.52,858252.29,0.00,0.00,405.77,194769.60,0.00,0.00,0.00),('1','148','769','220469',4255585,'2183','327',2056769.61,2057840.36,0.00,0.00,1070.75,462564.00,0.00,0.00,0.00),('1','148','769','220695',4259365,'2140','327',858252.29,859026.41,0.00,0.00,774.12,371577.60,0.00,0.00,0.00),('1','148','769','220695',4259366,'2183','327',2057840.36,2058566.18,0.00,0.00,725.82,313554.24,0.00,0.00,0.00),('1','148','769','220697',4259391,'2140','327',859026.41,860255.97,0.00,0.00,1229.56,590188.80,0.00,0.00,0.00),('1','148','769','220697',4259392,'2183','327',2058566.18,2060393.40,0.00,0.00,1827.22,798479.04,0.00,0.00,0.00),('1','148','769','221037',4265424,'2140','327',860255.97,860430.49,0.00,0.00,174.52,83769.60,0.00,0.00,0.00),('1','148','769','221037',4265425,'2183','327',2060393.40,2061158.81,0.00,0.00,765.41,330657.12,0.00,0.00,0.00),('1','148','769','221258',4269278,'2140','327',860430.49,860680.49,0.00,0.00,250.00,120000.00,0.00,0.00,0.00),('1','148','769','221258',4269279,'2183','327',2061158.81,2061459.35,0.00,0.00,300.54,129833.28,0.00,0.00,0.00),('1','148','769','221260',4269310,'2140','327',860680.49,861690.50,0.00,0.00,1010.01,484804.80,0.00,0.00,0.00),('1','148','769','221260',4269311,'2183','327',2061459.35,2063823.95,0.00,0.00,2364.60,1021507.20,0.00,0.00,0.00),('1','148','769','221399',4271883,'2140','327',861690.50,862443.07,0.00,0.00,752.57,361233.60,0.00,0.00,0.00),('1','148','769','221399',4271884,'2183','327',2063823.95,2065884.82,0.00,0.00,2060.87,890295.84,0.00,0.00,0.00),('1','148','769','221485',4273354,'2140','327',862443.07,863516.70,0.00,0.00,1073.63,515342.40,0.00,0.00,0.00),('1','148','769','221485',4273355,'2183','327',2065884.82,2068810.65,0.00,0.00,2925.83,1263958.56,0.00,0.00,0.00),('1','148','769','221667',4276842,'2140','327',863516.70,863612.26,0.00,0.00,95.56,45868.80,0.00,0.00,0.00),('1','148','769','221667',4276843,'2183','327',2068810.65,2069756.16,0.00,0.00,945.51,408460.32,0.00,0.00,0.00),('1','148','769','221825',4279775,'2140','327',863612.26,864622.75,0.00,0.00,1010.49,485035.20,0.00,0.00,0.00),('1','148','769','221825',4279776,'2183','327',2069756.16,2071929.10,0.00,0.00,2172.94,938710.08,0.00,0.00,0.00),('1','148','769','221902',4280872,'2140','327',864622.75,864880.87,0.00,0.00,258.12,123897.60,0.00,0.00,0.00),('1','148','769','221902',4280873,'2183','327',2071929.10,2073405.08,0.00,0.00,1475.98,702230.40,0.00,0.00,0.00),('1','148','769','222237',4287120,'2140','327',864880.87,865931.07,0.00,0.00,1050.20,504096.00,0.00,0.00,0.00),('1','148','769','222237',4287121,'2183','327',2073405.08,2074663.78,0.00,0.00,1258.70,543758.40,0.00,0.00,0.00),('1','148','769','222369',4289058,'2140','327',865931.07,866937.42,0.00,0.00,1006.35,483048.00,0.00,0.00,0.00),('1','148','769','222369',4289059,'2183','327',2074663.78,2077074.54,0.00,0.00,2410.76,1041448.32,0.00,0.00,0.00),('1','148','769','222377',4289183,'2140','327',866937.42,866937.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','222377',4289184,'2183','327',2077074.54,2077819.42,0.00,0.00,744.88,321788.16,0.00,0.00,0.00),('1','148','769','222378',4289185,'2140','327',866937.42,868299.54,0.00,0.00,1362.12,653817.60,0.00,0.00,0.00),('1','148','769','222378',4289186,'2183','327',2077819.42,2078792.85,0.00,0.00,973.43,467246.40,0.00,0.00,0.00),('1','148','769','222700',4295250,'2140','327',868299.54,870118.19,0.00,0.00,1818.65,872952.00,0.00,0.00,0.00),('1','148','769','222700',4295251,'2183','327',2078792.85,2078792.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','222821',4297229,'2140','327',870118.19,871152.08,0.00,0.00,1033.89,496267.20,0.00,0.00,0.00),('1','148','769','222821',4297230,'2183','327',2078792.85,2078792.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','222975',4300256,'2140','327',871152.08,872705.46,0.00,0.00,1553.38,745622.40,0.00,0.00,0.00),('1','148','769','222975',4300257,'2183','327',2078792.85,2078792.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','223222',4304313,'2140','327',872705.46,874371.41,0.00,0.00,1665.95,799656.00,0.00,0.00,0.00),('1','148','769','223222',4304314,'2183','327',2078792.85,2078792.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','223493',4309158,'2140','327',874371.41,874870.45,0.00,0.00,499.04,239539.20,0.00,0.00,0.00),('1','148','769','223493',4309159,'2183','327',2078792.85,2078792.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','223495',4309191,'2140','327',874870.45,876354.74,0.00,0.00,1484.29,712459.20,0.00,0.00,0.00),('1','148','769','223495',4309192,'2183','327',2078792.85,2080293.30,0.00,0.00,1500.45,696208.80,0.00,0.00,0.00),('1','148','769','223698',4312889,'2140','327',876354.74,876606.52,0.00,0.00,251.78,128911.36,0.00,0.00,0.00),('1','148','769','223698',4312890,'2183','327',2080293.30,2081677.74,0.00,0.00,1384.44,642380.16,0.00,0.00,0.00),('1','148','769','223925',4317120,'2140','327',876606.52,877610.88,0.00,0.00,1004.36,514232.32,0.00,0.00,0.00),('1','148','769','223925',4317121,'2183','327',2081677.74,2084516.42,0.00,0.00,2838.68,1317147.52,0.00,0.00,0.00),('1','148','769','223928',4317153,'2140','327',877610.88,877681.75,0.00,0.00,70.87,36285.44,0.00,0.00,0.00),('1','148','769','223928',4317154,'2183','327',2084516.42,2084692.51,0.00,0.00,176.09,81705.76,0.00,0.00,0.00),('1','148','769','224172',4321368,'2140','327',877681.75,878690.85,0.00,0.00,1009.10,516659.20,0.00,0.00,0.00),('1','148','769','224172',4321369,'2183','327',2084692.51,2086537.99,0.00,0.00,1845.48,856302.72,0.00,0.00,0.00),('1','148','769','224182',4321602,'2140','327',878690.85,878841.38,0.00,0.00,150.53,77071.36,0.00,0.00,0.00),('1','148','769','224182',4321603,'2183','327',2086537.99,2087773.19,0.00,0.00,1235.20,573132.80,0.00,0.00,0.00),('1','148','769','224371',4324978,'2140','327',878841.38,879860.40,0.00,0.00,1019.02,521738.24,0.00,0.00,0.00),('1','148','769','224371',4324979,'2183','327',2087773.19,2089861.00,0.00,0.00,2087.81,968743.84,0.00,0.00,0.00),('1','148','769','224379',4325097,'2140','327',879860.40,880073.90,0.00,0.00,213.50,109312.00,0.00,0.00,0.00),('1','148','769','224379',4325098,'2183','327',2089861.00,2091660.50,0.00,0.00,1799.50,881755.00,0.00,0.00,0.00),('1','148','769','224620',4329379,'2140','327',880073.90,881173.69,0.00,0.00,1099.79,563092.48,0.00,0.00,0.00),('1','148','769','224620',4329380,'2183','327',2091660.50,2092420.51,0.00,0.00,760.01,372404.90,0.00,0.00,0.00),('1','148','769','224635',4329691,'2140','327',881173.69,882247.82,0.00,0.00,1074.13,549954.56,0.00,0.00,0.00),('1','148','769','224635',4329692,'2183','327',2092420.51,2094556.96,0.00,0.00,2136.45,1046860.50,0.00,0.00,0.00),('1','148','769','224782',4332256,'2140','327',882247.82,883405.63,0.00,0.00,1157.81,592798.72,0.00,0.00,0.00),('1','148','769','224782',4332257,'2183','327',2094556.96,2096129.41,0.00,0.00,1572.45,770500.50,0.00,0.00,0.00),('1','148','769','225027',4336618,'2140','327',883405.63,883405.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','225027',4336619,'2183','327',2096129.41,2097131.86,0.00,0.00,1002.45,485185.80,0.00,0.00,0.00),('1','148','769','225032',4336676,'2140','327',883405.63,883701.99,0.00,0.00,296.36,151736.32,0.00,0.00,0.00),('1','148','769','225032',4336677,'2183','327',2097131.86,2098362.07,0.00,0.00,1230.21,595421.64,0.00,0.00,0.00),('1','148','769','225273',4341165,'2140','327',883701.99,884502.09,0.00,0.00,800.10,409651.20,0.00,0.00,0.00),('1','148','769','225273',4341166,'2183','327',2098362.07,2099224.23,0.00,0.00,862.16,417285.44,0.00,0.00,0.00),('1','148','769','225282',4341235,'2140','327',884502.09,884502.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','225282',4341236,'2183','327',2099224.23,2099825.36,0.00,0.00,601.13,214002.28,0.00,0.00,0.00),('1','148','769','225285',4341251,'2140','327',884502.09,885652.25,0.00,0.00,1150.16,588881.92,0.00,0.00,0.00),('1','148','769','225285',4341252,'2183','327',2099825.36,2102331.47,0.00,0.00,2506.11,1212957.24,0.00,0.00,0.00),('1','148','769','225498',4345226,'2140','327',885652.25,885711.23,0.00,0.00,58.98,30197.76,0.00,0.00,0.00),('1','148','769','225498',4345227,'2183','327',2102331.47,2102781.47,0.00,0.00,450.00,217800.00,0.00,0.00,0.00),('1','148','769','225506',4345336,'2140','327',885711.23,886873.73,0.00,0.00,1162.50,595200.00,0.00,0.00,0.00),('1','148','769','225506',4345337,'2183','327',2102781.47,2105592.36,0.00,0.00,2810.89,1360470.76,0.00,0.00,0.00),('1','148','769','225824',4350845,'2140','327',886873.73,887042.46,0.00,0.00,168.73,86389.76,0.00,0.00,0.00),('1','148','769','225824',4350846,'2183','327',2105592.36,2105892.36,0.00,0.00,300.00,145200.00,0.00,0.00,0.00),('1','148','769','225941',4352939,'2140','327',887042.46,887522.82,0.00,0.00,480.36,245944.32,0.00,0.00,0.00),('1','148','769','225941',4352940,'2183','327',2105892.36,2107519.17,0.00,0.00,1626.81,787376.04,0.00,0.00,0.00),('1','148','769','225943',4352969,'2140','327',887522.82,888240.07,0.00,0.00,717.25,367232.00,0.00,0.00,0.00),('1','148','769','225943',4352970,'2183','327',2107519.17,2109072.81,0.00,0.00,1553.64,751961.76,0.00,0.00,0.00),('1','148','769','226143',4356568,'2140','327',254821.94,255587.12,0.00,0.00,765.18,416257.92,0.00,0.00,0.00),('1','148','769','226143',4356569,'2183','327',347124.80,350094.39,0.00,0.00,2969.59,1455099.10,0.00,0.00,0.00),('1','148','769','226320',4359750,'2140','327',255587.12,255907.14,0.00,0.00,320.02,174090.88,0.00,0.00,0.00),('1','148','769','226320',4359751,'2183','327',350094.39,351255.12,0.00,0.00,1160.73,568757.70,0.00,0.00,0.00),('1','148','769','226532',4363377,'2140','327',255907.14,256497.96,0.00,0.00,590.82,321406.08,0.00,0.00,0.00),('1','148','769','226532',4363378,'2183','327',351255.12,353081.99,0.00,0.00,1826.87,895166.30,0.00,0.00,0.00),('1','148','769','226541',4363549,'2140','327',256497.96,257069.74,0.00,0.00,571.78,311048.32,0.00,0.00,0.00),('1','148','769','226541',4363550,'2183','327',353081.99,355421.77,0.00,0.00,2339.78,1146492.20,0.00,0.00,0.00),('1','148','769','226668',4366150,'2140','327',257069.74,257384.66,0.00,0.00,314.92,171316.48,0.00,0.00,0.00),('1','148','769','226668',4366151,'2183','327',355421.77,356361.65,0.00,0.00,939.88,460541.20,0.00,0.00,0.00),('1','148','769','226813',4368616,'2140','327',257384.66,258162.28,0.00,0.00,777.62,423025.28,0.00,0.00,0.00),('1','148','769','226813',4368617,'2183','327',356361.65,359631.94,0.00,0.00,3270.29,1602442.10,0.00,0.00,0.00),('1','148','769','227032',4372338,'2140','327',258162.28,259334.31,0.00,0.00,1172.03,637584.32,0.00,0.00,0.00),('1','148','769','227032',4372339,'2183','327',359631.94,363652.23,0.00,0.00,4020.29,1969942.10,0.00,0.00,0.00),('1','148','769','227358',4378473,'2140','327',259334.31,259821.88,0.00,0.00,487.57,265238.08,0.00,0.00,0.00),('1','148','769','227358',4378474,'2183','327',363652.23,365020.79,0.00,0.00,1368.56,670594.40,0.00,0.00,0.00),('1','148','769','227492',4380653,'2140','327',259821.88,260567.23,0.00,0.00,745.35,405470.40,0.00,0.00,0.00),('1','148','769','227492',4380654,'2183','327',365020.79,367669.69,0.00,0.00,2648.90,1297961.00,0.00,0.00,0.00),('1','148','769','227688',4383972,'2140','327',260567.23,261890.22,0.00,0.00,1322.99,719706.56,0.00,0.00,0.00),('1','148','769','227688',4383973,'2183','327',367669.69,369227.27,0.00,0.00,1557.58,763214.20,0.00,0.00,0.00),('1','148','769','227928',4388262,'2140','327',261890.22,263060.80,0.00,0.00,1170.58,636795.52,0.00,0.00,0.00),('1','148','769','227928',4388263,'2183','327',369227.27,369227.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','228196',4393845,'2140','327',263060.80,264299.17,0.00,0.00,1238.37,673673.28,0.00,0.00,0.00),('1','148','769','228196',4393846,'2183','327',369227.27,369649.57,0.00,0.00,422.30,216217.60,0.00,0.00,0.00),('1','148','769','228859',4405969,'2140','327',264299.17,265065.35,0.00,0.00,766.18,429060.80,0.00,0.00,0.00),('1','148','769','228859',4405970,'2183','327',369649.57,370985.37,0.00,0.00,1335.80,683929.60,0.00,0.00,0.00),('1','148','769','228864',4406018,'2140','327',265065.35,266402.46,0.00,0.00,1337.11,748781.60,0.00,0.00,0.00),('1','148','769','228864',4406019,'2183','327',370985.37,372898.79,0.00,0.00,1913.42,979671.04,0.00,0.00,0.00),('1','148','769','228873',4406227,'2140','327',266402.46,266402.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','228873',4406228,'2183','327',372898.79,372999.01,0.00,0.00,100.22,56123.20,0.00,0.00,0.00),('1','148','769','228877',4406285,'2140','327',266402.46,267417.79,0.00,0.00,1015.33,568584.80,0.00,0.00,0.00),('1','148','769','228877',4406286,'2183','327',372999.01,374586.09,0.00,0.00,1587.08,812584.96,0.00,0.00,0.00),('1','148','769','229232',4413029,'2140','327',267417.79,268356.41,0.00,0.00,938.62,525627.20,0.00,0.00,0.00),('1','148','769','229232',4413030,'2183','327',374586.09,376311.69,0.00,0.00,1725.60,883507.20,0.00,0.00,0.00),('1','148','769','229239',4413162,'2140','327',268356.41,268692.69,0.00,0.00,336.28,188316.80,0.00,0.00,0.00),('1','148','769','229239',4413163,'2183','327',376311.69,376875.24,0.00,0.00,563.55,288537.60,0.00,0.00,0.00),('1','148','769','229243',4413206,'2140','327',268692.69,269811.59,0.00,0.00,1118.90,626584.00,0.00,0.00,0.00),('1','148','769','229243',4413207,'2183','327',376875.24,380315.17,0.00,0.00,3439.93,1761244.16,0.00,0.00,0.00),('1','148','769','229468',4417111,'2140','327',269811.59,270313.72,0.00,0.00,502.13,281192.80,0.00,0.00,0.00),('1','148','769','229468',4417112,'2183','327',380315.17,380720.90,0.00,0.00,405.73,227208.80,0.00,0.00,0.00),('1','148','769','229480',4417394,'2140','327',270313.72,271629.32,0.00,0.00,1315.60,768010.40,0.00,0.00,0.00),('1','148','769','229480',4417395,'2183','327',380720.90,381049.97,0.00,0.00,329.07,175065.24,0.00,0.00,0.00),('1','148','769','229668',4421260,'2140','327',271629.32,272929.59,0.00,0.00,1300.27,759357.68,0.00,0.00,0.00),('1','148','769','229668',4421261,'2183','327',381049.97,381271.22,0.00,0.00,221.25,129210.00,0.00,0.00,0.00),('1','148','769','229876',4425553,'2140','327',272929.59,273437.13,0.00,0.00,507.54,296403.36,0.00,0.00,0.00),('1','148','769','229876',4425554,'2183','327',381271.22,381886.00,0.00,0.00,614.78,359031.52,0.00,0.00,0.00),('1','148','769','230190',4431121,'2140','327',273437.13,273688.84,0.00,0.00,251.71,146998.64,0.00,0.00,0.00),('1','148','769','230190',4431122,'2183','327',381886.00,382033.60,0.00,0.00,147.60,86198.40,0.00,0.00,0.00),('1','148','769','230717',4441289,'2140','327',273688.84,274281.81,0.00,0.00,592.97,346294.48,0.00,0.00,0.00),('1','148','769','230717',4441290,'2183','327',382033.60,382621.82,0.00,0.00,588.22,312933.04,0.00,0.00,0.00),('1','148','769','230753',4441918,'2140','327',274281.81,275476.59,0.00,0.00,1194.78,697751.52,0.00,0.00,0.00),('1','148','769','230753',4441919,'2183','327',382621.82,383153.84,0.00,0.00,532.02,310699.68,0.00,0.00,0.00),('1','148','769','230758',4441955,'2140','327',275476.59,276626.59,0.00,0.00,1150.00,671600.00,0.00,0.00,0.00),('1','148','769','230758',4441956,'2183','327',383153.84,384119.84,0.00,0.00,966.00,564144.00,0.00,0.00,0.00),('1','148','769','230788',4442150,'2140','327',276626.59,277868.60,0.00,0.00,1242.01,725333.84,0.00,0.00,0.00),('1','148','769','230788',4442151,'2183','327',384119.84,384838.85,0.00,0.00,719.01,419901.84,0.00,0.00,0.00),('1','148','769','231055',4446887,'2140','327',277868.60,279009.90,0.00,0.00,1141.30,666519.20,0.00,0.00,0.00),('1','148','769','231055',4446888,'2183','327',384838.85,385399.68,0.00,0.00,560.83,327524.72,0.00,0.00,0.00),('1','148','769','231359',4451724,'2140','327',279009.90,279452.82,0.00,0.00,442.92,258665.28,0.00,0.00,0.00),('1','148','769','231359',4451725,'2183','327',385399.68,385770.07,0.00,0.00,370.39,198737.48,0.00,0.00,0.00),('1','148','769','231408',4452306,'2140','327',279452.82,279452.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','231408',4452307,'2183','327',385770.07,385770.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','231443',4452915,'2140','327',279452.82,280361.67,0.00,0.00,908.85,530768.40,0.00,0.00,0.00),('1','148','769','231443',4452916,'2183','327',385770.07,386168.03,0.00,0.00,397.96,232408.64,0.00,0.00,0.00),('1','148','769','231667',4456758,'2140','327',280361.67,281594.38,0.00,0.00,1232.71,719902.64,0.00,0.00,0.00),('1','148','769','231667',4456759,'2183','327',386168.03,386644.82,0.00,0.00,476.79,278445.36,0.00,0.00,0.00),('1','148','769','231888',4461037,'2140','327',281594.38,282571.34,0.00,0.00,976.96,570544.64,0.00,0.00,0.00),('1','148','769','231888',4461038,'2183','327',386644.82,387692.67,0.00,0.00,1047.85,611944.40,0.00,0.00,0.00),('1','148','769','232141',4465431,'2140','327',282571.34,282571.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','232141',4465432,'2183','327',387692.67,387692.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','232142',4465433,'2140','327',282571.34,283165.43,0.00,0.00,594.09,346948.56,0.00,0.00,0.00),('1','148','769','232142',4465434,'2183','327',387692.67,388344.33,0.00,0.00,651.66,380569.44,0.00,0.00,0.00),('1','148','769','232364',4469360,'2140','327',283165.43,284296.33,0.00,0.00,1130.90,660445.60,0.00,0.00,0.00),('1','148','769','232364',4469361,'2183','327',388344.33,388491.22,0.00,0.00,146.89,85783.76,0.00,0.00,0.00),('1','148','769','232589',4473610,'2140','327',284296.33,284952.41,0.00,0.00,656.08,395449.44,0.00,0.00,0.00),('1','148','769','232589',4473611,'2183','327',388491.22,389371.15,0.00,0.00,879.93,492760.80,0.00,0.00,0.00),('1','148','769','232832',4478110,'2140','327',284952.41,285233.21,0.00,0.00,280.80,168480.00,0.00,0.00,0.00),('1','148','769','232832',4478111,'2183','327',389371.15,389858.75,0.00,0.00,487.60,273056.00,0.00,0.00,0.00),('1','148','769','232834',4478114,'2140','327',285233.21,286394.50,0.00,0.00,1161.29,696774.00,0.00,0.00,0.00),('1','148','769','232834',4478115,'2183','327',389858.75,391234.68,0.00,0.00,1375.93,770654.00,0.00,0.00,0.00),('1','148','769','233098',4482895,'2140','327',286394.50,287118.70,0.00,0.00,724.20,434520.00,0.00,0.00,0.00),('1','148','769','233098',4482896,'2183','327',391234.68,392786.24,0.00,0.00,1551.56,868940.40,0.00,0.00,0.00),('1','148','769','233408',4488245,'2140','327',287118.70,287118.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','233408',4488246,'2183','327',392786.24,392786.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','233411',4488284,'2140','327',287118.70,288421.19,0.00,0.00,1302.49,812753.76,0.00,0.00,0.00),('1','148','769','233411',4488285,'2183','327',392786.24,393547.35,0.00,0.00,761.11,474932.64,0.00,0.00,0.00),('1','148','769','233606',4492028,'2140','327',288421.19,289783.42,0.00,0.00,1362.23,850031.52,0.00,0.00,0.00),('1','148','769','233606',4492029,'2183','327',393547.35,394589.99,0.00,0.00,1042.64,602645.92,0.00,0.00,0.00),('1','148','769','233852',4496308,'2140','327',289783.42,290167.11,0.00,0.00,383.69,239422.56,0.00,0.00,0.00),('1','148','769','233852',4496309,'2183','327',394589.99,395217.99,0.00,0.00,628.00,362984.00,0.00,0.00,0.00),('1','148','769','233928',4497823,'2140','327',290167.11,290851.34,0.00,0.00,684.23,426959.52,0.00,0.00,0.00),('1','148','769','233928',4497824,'2183','327',395217.99,395916.54,0.00,0.00,698.55,403761.90,0.00,0.00,0.00),('1','148','769','234063',4500062,'2140','327',290851.34,291889.70,0.00,0.00,1038.36,647936.64,0.00,0.00,0.00),('1','148','769','234063',4500063,'2183','327',395916.54,397570.75,0.00,0.00,1654.21,956229.06,0.00,0.00,0.00),('1','148','769','234303',4504604,'2140','327',291889.70,292508.01,0.00,0.00,618.31,385825.44,0.00,0.00,0.00),('1','148','769','234303',4504605,'2183','327',397570.75,397926.29,0.00,0.00,355.54,205502.12,0.00,0.00,0.00),('1','148','769','234479',4507719,'2140','327',292508.01,292895.76,0.00,0.00,387.75,241956.00,0.00,0.00,0.00),('1','148','769','234479',4507720,'2183','327',397926.29,398381.07,0.00,0.00,454.78,270787.72,0.00,0.00,0.00),('1','148','769','234564',4509209,'2140','327',292895.76,294047.15,0.00,0.00,1151.39,718467.36,0.00,0.00,0.00),('1','148','769','234564',4509210,'2183','327',398381.07,400024.01,0.00,0.00,1642.94,949619.32,0.00,0.00,0.00),('1','148','769','234822',4513734,'2140','327',294047.15,295210.14,0.00,0.00,1162.99,725705.76,0.00,0.00,0.00),('1','148','769','234822',4513735,'2183','327',400024.01,400245.04,0.00,0.00,221.03,127755.34,0.00,0.00,0.00),('1','148','769','235061',4518075,'2140','327',295210.14,295210.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','235061',4518076,'2183','327',400245.04,400245.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','235064',4518084,'2140','327',295210.14,295347.94,0.00,0.00,137.80,85987.20,0.00,0.00,0.00),('1','148','769','235064',4518085,'2183','327',400245.04,400972.18,0.00,0.00,727.14,425582.44,0.00,0.00,0.00),('1','148','769','235068',4518142,'2140','327',295347.94,296261.18,0.00,0.00,913.24,569861.76,0.00,0.00,0.00),('1','148','769','235068',4518143,'2183','327',400972.18,401973.50,0.00,0.00,1001.32,578762.96,0.00,0.00,0.00),('1','148','769','235296',4522073,'2140','327',296261.18,297661.54,0.00,0.00,1400.36,873824.64,0.00,0.00,0.00),('1','148','769','235296',4522074,'2183','327',401973.50,403227.38,0.00,0.00,1253.88,725317.64,0.00,0.00,0.00),('1','148','769','235522',4526069,'2140','327',297661.54,297661.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','235522',4526070,'2183','327',403227.38,403227.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','235523',4526071,'2140','327',297661.54,299112.12,0.00,0.00,1450.58,905161.92,0.00,0.00,0.00),('1','148','769','235523',4526072,'2183','327',403227.38,406065.35,0.00,0.00,2837.97,1640351.26,0.00,0.00,0.00),('1','148','769','235749',4530111,'2140','327',299112.12,299870.94,0.00,0.00,758.82,485644.80,0.00,0.00,0.00),('1','148','769','235749',4530112,'2183','327',406065.35,406165.35,0.00,0.00,100.00,60000.00,0.00,0.00,0.00),('1','148','769','236004',4534526,'2140','327',299870.94,300568.12,0.00,0.00,697.18,446195.20,0.00,0.00,0.00),('1','148','769','236004',4534527,'2183','327',406165.35,406566.18,0.00,0.00,400.83,240498.00,0.00,0.00,0.00),('1','148','769','236007',4534532,'2140','327',300568.12,301697.02,0.00,0.00,1128.90,722496.00,0.00,0.00,0.00),('1','148','769','236007',4534533,'2183','327',406566.18,408416.67,0.00,0.00,1850.49,1120309.20,0.00,0.00,0.00),('1','148','769','236233',4538661,'2140','327',301697.02,302271.65,0.00,0.00,574.63,367763.20,0.00,0.00,0.00),('1','148','769','236233',4538662,'2183','327',408416.67,408836.67,0.00,0.00,420.00,252000.00,0.00,0.00,0.00),('1','148','769','236485',4543226,'2140','327',302271.65,302595.57,0.00,0.00,323.92,207308.80,0.00,0.00,0.00),('1','148','769','236485',4543227,'2183','327',408836.67,409063.44,0.00,0.00,226.77,136062.00,0.00,0.00,0.00),('1','148','769','236513',4543568,'2140','327',302595.57,303622.37,0.00,0.00,1026.80,657152.00,0.00,0.00,0.00),('1','148','769','236513',4543569,'2183','327',409063.44,410612.34,0.00,0.00,1548.90,929340.00,0.00,0.00,0.00),('1','148','769','236722',4547050,'2140','327',303622.37,304752.79,0.00,0.00,1130.42,723468.80,0.00,0.00,0.00),('1','148','769','236722',4547051,'2183','327',410612.34,411663.25,0.00,0.00,1050.91,630546.00,0.00,0.00,0.00),('1','148','769','236937',4550979,'2140','327',304752.79,305960.74,0.00,0.00,1207.95,773088.00,0.00,0.00,0.00),('1','148','769','236937',4550980,'2183','327',411663.25,412873.51,0.00,0.00,1210.26,726156.00,0.00,0.00,0.00),('1','148','769','237163',4554860,'2140','327',305960.74,306989.87,0.00,0.00,1029.13,658643.20,0.00,0.00,0.00),('1','148','769','237163',4554861,'2183','327',412873.51,414378.55,0.00,0.00,1505.04,903024.00,0.00,0.00,0.00),('1','148','769','237358',4558574,'2140','327',306989.87,306989.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','237358',4558575,'2183','327',414378.55,414378.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','237359',4558576,'2140','327',306989.87,307295.48,0.00,0.00,305.61,195590.40,0.00,0.00,0.00),('1','148','769','237359',4558577,'2183','327',414378.55,414725.97,0.00,0.00,347.42,208452.00,0.00,0.00,0.00),('1','148','769','237410',4559268,'2140','327',307295.48,308309.23,0.00,0.00,1013.75,648800.00,0.00,0.00,0.00),('1','148','769','237410',4559269,'2183','327',414725.97,417203.76,0.00,0.00,2477.79,1486674.00,0.00,0.00,0.00),('1','148','769','237594',4562690,'2140','327',308309.23,308828.60,0.00,0.00,519.37,340501.76,0.00,0.00,0.00),('1','148','769','237594',4562691,'2183','327',417203.76,417800.06,0.00,0.00,596.30,369706.00,0.00,0.00,0.00),('1','148','769','237890',4567348,'2140','327',308828.60,309177.01,0.00,0.00,348.41,228556.96,0.00,0.00,0.00),('1','148','769','237890',4567349,'2183','327',417800.06,418390.95,0.00,0.00,590.89,366351.80,0.00,0.00,0.00),('1','148','769','237895',4567419,'2140','327',309177.01,310237.98,0.00,0.00,1060.97,679020.80,0.00,0.00,0.00),('1','148','769','237895',4567420,'2183','327',418390.95,419481.88,0.00,0.00,1090.93,663335.36,0.00,0.00,0.00),('1','148','769','238136',4571299,'2140','327',310237.98,311191.41,0.00,0.00,953.43,610055.20,0.00,0.00,0.00),('1','148','769','238136',4571300,'2183','327',419481.88,420654.88,0.00,0.00,1173.00,713269.12,0.00,0.00,0.00),('1','148','769','238387',4575746,'2140','327',311191.41,312127.51,0.00,0.00,936.10,599104.00,0.00,0.00,0.00),('1','148','769','238387',4575747,'2183','327',420654.88,421123.39,0.00,0.00,468.51,284854.08,0.00,0.00,0.00),('1','148','769','238661',4580299,'2140','327',312127.51,313565.28,0.00,0.00,1437.77,920172.80,0.00,0.00,0.00),('1','148','769','238661',4580300,'2183','327',421123.39,423475.98,0.00,0.00,2352.59,1430374.72,0.00,0.00,0.00),('1','148','769','238947',4585564,'2140','327',313565.28,314336.12,0.00,0.00,770.84,493337.60,0.00,0.00,0.00),('1','148','769','238947',4585565,'2183','327',423475.98,424460.13,0.00,0.00,984.15,598363.20,0.00,0.00,0.00),('1','148','769','239057',4587538,'2140','327',314336.12,315354.11,0.00,0.00,1017.99,651513.60,0.00,0.00,0.00),('1','148','769','239057',4587539,'2183','327',424460.13,426641.05,0.00,0.00,2180.92,1325999.36,0.00,0.00,0.00),('1','148','769','239357',4592551,'2140','327',315354.11,315354.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','239357',4592552,'2183','327',426641.05,426641.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','239361',4592586,'2140','327',315354.11,316291.87,0.00,0.00,937.76,600166.40,0.00,0.00,0.00),('1','148','769','239361',4592587,'2183','327',426641.05,428630.31,0.00,0.00,1989.26,1209470.08,0.00,0.00,0.00),('1','148','769','239529',4595526,'2140','327',316291.87,316943.49,0.00,0.00,651.62,417036.80,0.00,0.00,0.00),('1','148','769','239529',4595527,'2183','327',428630.31,430280.46,0.00,0.00,1650.15,1003483.84,0.00,0.00,0.00),('1','148','769','239761',4599619,'2140','327',316943.49,318111.65,0.00,0.00,1168.16,747622.40,0.00,0.00,0.00),('1','148','769','239761',4599620,'2183','327',430280.46,431879.27,0.00,0.00,1598.81,972076.48,0.00,0.00,0.00),('1','148','769','239976',4603474,'2140','327',318111.65,318698.04,0.00,0.00,586.39,375289.60,0.00,0.00,0.00),('1','148','769','239976',4603475,'2183','327',431879.27,432665.27,0.00,0.00,786.00,487320.00,0.00,0.00,0.00),('1','148','769','240115',4605836,'2140','327',318698.04,319064.71,0.00,0.00,366.67,234668.80,0.00,0.00,0.00),('1','148','769','240115',4605837,'2183','327',432665.27,433177.90,0.00,0.00,512.63,317830.60,0.00,0.00,0.00),('1','148','769','240196',4607173,'2140','327',319064.71,320083.57,0.00,0.00,1018.86,652070.40,0.00,0.00,0.00),('1','148','769','240196',4607174,'2183','327',433177.90,435006.38,0.00,0.00,1828.48,1133657.60,0.00,0.00,0.00),('1','148','769','240465',4611422,'2140','327',320083.57,320625.70,0.00,0.00,542.13,346963.20,0.00,0.00,0.00),('1','148','769','240465',4611423,'2183','327',435006.38,436038.38,0.00,0.00,1032.00,639840.00,0.00,0.00,0.00),('1','148','769','240693',4615016,'2140','327',320625.70,321222.19,0.00,0.00,596.49,381753.60,0.00,0.00,0.00),('1','148','769','240693',4615017,'2183','327',436038.38,436263.39,0.00,0.00,225.01,139506.20,0.00,0.00,0.00),('1','148','769','240723',4615426,'2140','327',321222.19,322126.16,0.00,0.00,903.97,578540.80,0.00,0.00,0.00),('1','148','769','240723',4615427,'2183','327',436263.39,437682.11,0.00,0.00,1418.72,879606.40,0.00,0.00,0.00),('1','148','769','241031',4620921,'2140','327',322126.16,322953.54,0.00,0.00,827.38,529523.20,0.00,0.00,0.00),('1','148','769','241031',4620922,'2183','327',437682.11,438711.37,0.00,0.00,1029.26,623731.56,0.00,0.00,0.00),('1','148','769','241237',4624652,'2140','327',322953.54,322975.48,0.00,0.00,21.94,14041.60,0.00,0.00,0.00),('1','148','769','241237',4624653,'2183','327',438711.37,438808.37,0.00,0.00,97.00,58782.00,0.00,0.00,0.00),('1','148','769','241497',4629100,'2140','327',322975.48,323826.84,0.00,0.00,851.36,544870.40,0.00,0.00,0.00),('1','148','769','241497',4629101,'2183','327',438808.37,439691.78,0.00,0.00,883.41,535346.46,0.00,0.00,0.00),('1','148','769','241515',4629325,'2140','327',323826.84,324882.64,0.00,0.00,1055.80,675712.00,0.00,0.00,0.00),('1','148','769','241515',4629326,'2183','327',439691.78,441344.39,0.00,0.00,1652.61,1001481.66,0.00,0.00,0.00),('1','148','769','241774',4633934,'2140','327',324882.64,325256.05,0.00,0.00,373.41,238982.40,0.00,0.00,0.00),('1','148','769','241774',4633935,'2183','327',441344.39,441817.39,0.00,0.00,473.00,286638.00,0.00,0.00,0.00),('1','148','769','241964',4637330,'2140','327',325256.05,325736.85,0.00,0.00,480.80,307712.00,0.00,0.00,0.00),('1','148','769','241964',4637331,'2183','327',441817.39,442588.24,0.00,0.00,770.85,467135.10,0.00,0.00,0.00),('1','148','769','241968',4637364,'2140','327',325736.85,326742.59,0.00,0.00,1005.74,643673.60,0.00,0.00,0.00),('1','148','769','241968',4637365,'2183','327',442588.24,445403.61,0.00,0.00,2815.37,1706114.22,0.00,0.00,0.00),('1','148','769','242218',4641703,'2140','327',326742.59,327037.05,0.00,0.00,294.46,188454.40,0.00,0.00,0.00),('1','148','769','242218',4641704,'2183','327',445403.61,445486.61,0.00,0.00,83.00,50298.00,0.00,0.00,0.00),('1','148','769','242424',4645384,'2140','327',327037.05,327037.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','242424',4645385,'2183','327',445486.61,445600.61,0.00,0.00,114.00,69084.00,0.00,0.00,0.00),('1','148','769','242426',4645388,'2140','327',327037.05,327515.60,0.00,0.00,478.55,306272.00,0.00,0.00,0.00),('1','148','769','242426',4645389,'2183','327',445600.61,446006.80,0.00,0.00,406.19,246151.14,0.00,0.00,0.00),('1','148','769','242436',4645485,'2140','327',327515.60,328621.82,0.00,0.00,1106.22,707980.80,0.00,0.00,0.00),('1','148','769','242436',4645486,'2183','327',446006.80,448656.15,0.00,0.00,2649.35,1605506.10,0.00,0.00,0.00),('1','148','769','242669',4649720,'2140','327',328621.82,329102.93,0.00,0.00,481.11,307910.40,0.00,0.00,0.00),('1','148','769','242669',4649721,'2183','327',448656.15,449233.69,0.00,0.00,577.54,349989.24,0.00,0.00,0.00),('1','148','769','242921',4653831,'2140','327',329102.93,329585.52,0.00,0.00,482.59,308857.60,0.00,0.00,0.00),('1','148','769','242921',4653832,'2183','327',449233.69,449882.82,0.00,0.00,649.13,393372.78,0.00,0.00,0.00),('1','148','769','242924',4653885,'2140','327',329585.52,330525.81,0.00,0.00,940.29,601785.60,0.00,0.00,0.00),('1','148','769','242924',4653886,'2183','327',449882.82,452034.04,0.00,0.00,2151.22,1290732.00,0.00,0.00,0.00),('1','148','769','243158',4657940,'2140','327',330525.81,331066.02,0.00,0.00,540.21,345734.40,0.00,0.00,0.00),('1','148','769','243158',4657941,'2183','327',452034.04,452635.68,0.00,0.00,601.64,361481.20,0.00,0.00,0.00),('1','148','769','243406',4662420,'2140','327',331066.02,331066.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','243406',4662421,'2183','327',452635.68,452635.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','243430',4662830,'2140','327',331066.02,331537.16,0.00,0.00,471.14,301529.60,0.00,0.00,0.00),('1','148','769','243430',4662831,'2183','327',452635.68,453410.74,0.00,0.00,775.06,468037.60,0.00,0.00,0.00),('1','148','769','243434',4662875,'2140','327',331537.16,332835.00,0.00,0.00,1297.84,830617.60,0.00,0.00,0.00),('1','148','769','243434',4662876,'2183','327',453410.74,456126.74,0.00,0.00,2716.00,1629600.00,0.00,0.00,0.00),('1','148','769','243843',4670022,'2140','327',332835.00,333476.00,0.00,0.00,641.00,41024.00,0.00,0.00,0.00),('1','148','769','243843',4670023,'2183','327',456126.74,458002.70,0.00,0.00,1875.96,1125576.00,0.00,0.00,0.00),('1','148','769','243849',4670124,'2140','327',333476.00,334573.25,0.00,0.00,1097.25,702240.00,0.00,0.00,0.00),('1','148','769','243849',4670125,'2183','327',458002.70,459798.00,0.00,0.00,1795.30,1446360.00,0.00,0.00,0.00),('1','148','769','244096',4674386,'2140','327',334573.25,334573.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','244096',4674387,'2183','327',459798.00,459925.73,0.00,0.00,127.73,79248.80,0.00,0.00,0.00),('1','148','769','244108',4674583,'2140','327',334573.25,335729.20,0.00,0.00,1155.95,739808.00,0.00,0.00,0.00),('1','148','769','244108',4674584,'2183','327',459925.73,462187.72,0.00,0.00,2261.99,1357694.00,0.00,0.00,0.00),('1','148','769','244303',4677838,'2140','327',335729.20,336098.61,0.00,0.00,369.41,236422.40,0.00,0.00,0.00),('1','148','769','244303',4677839,'2183','327',462187.72,463394.33,0.00,0.00,1206.61,723966.00,0.00,0.00,0.00),('1','148','769','244423',4680100,'2140','327',336098.61,336682.04,0.00,0.00,583.43,373395.20,0.00,0.00,0.00),('1','148','769','244423',4680101,'2183','327',463394.33,464096.59,0.00,0.00,702.26,421356.00,0.00,0.00,0.00),('1','148','769','244605',4683235,'2140','327',336682.04,337685.80,0.00,0.00,1003.76,642406.40,0.00,0.00,0.00),('1','148','769','244605',4683236,'2183','327',464096.59,466198.14,0.00,0.00,2101.55,1260930.00,0.00,0.00,0.00),('1','148','769','244766',4685727,'2140','327',337685.80,337973.95,0.00,0.00,288.15,184416.00,0.00,0.00,0.00),('1','148','769','244766',4685728,'2183','327',466198.14,466965.89,0.00,0.00,767.75,460962.40,0.00,0.00,0.00),('1','148','769','244994',4689825,'2140','327',337973.95,338596.42,0.00,0.00,622.47,398380.80,0.00,0.00,0.00),('1','148','769','244994',4689826,'2183','327',466965.89,467286.92,0.00,0.00,321.03,192618.00,0.00,0.00,0.00),('1','148','769','244999',4689914,'2140','327',338596.42,339659.15,0.00,0.00,1062.73,671926.64,0.00,0.00,0.00),('1','148','769','244999',4689915,'2183','327',467286.92,468534.41,0.00,0.00,1247.49,740366.12,0.00,0.00,0.00),('1','148','769','245229',4693951,'2140','327',339659.15,340153.47,0.00,0.00,494.32,312410.24,0.00,0.00,0.00),('1','148','769','245229',4693952,'2183','327',468534.41,469830.67,0.00,0.00,1296.26,762548.92,0.00,0.00,0.00),('1','148','769','245530',4699239,'2140','327',340153.47,341180.40,0.00,0.00,1026.93,649019.76,0.00,0.00,0.00),('1','148','769','245530',4699240,'2183','327',469830.67,471657.68,0.00,0.00,1827.01,1079583.88,0.00,0.00,0.00),('1','148','769','245683',4701931,'2140','327',341180.40,342000.13,0.00,0.00,819.73,518069.36,0.00,0.00,0.00),('1','148','769','245683',4701932,'2183','327',471657.68,472524.29,0.00,0.00,866.61,510116.68,0.00,0.00,0.00),('1','148','769','246036',4707454,'2140','327',342000.13,342129.83,0.00,0.00,129.70,79895.20,0.00,0.00,0.00),('1','148','769','246036',4707455,'2183','327',472524.29,473224.29,0.00,0.00,700.00,394800.00,0.00,0.00,0.00),('1','148','769','246076',4708152,'2140','327',342129.83,342809.02,0.00,0.00,679.19,418381.04,0.00,0.00,0.00),('1','148','769','246076',4708153,'2183','327',473224.29,474134.29,0.00,0.00,910.00,517167.04,0.00,0.00,0.00),('1','148','769','246200',4710192,'2140','327',342809.02,343942.06,0.00,0.00,1133.04,697952.64,0.00,0.00,0.00),('1','148','769','246200',4710193,'2183','327',474134.29,475844.88,0.00,0.00,1710.59,964772.76,0.00,0.00,0.00),('1','148','769','246470',4714718,'2140','327',343942.06,344160.66,0.00,0.00,218.60,134657.60,0.00,0.00,0.00),('1','148','769','246470',4714719,'2183','327',475844.88,476425.15,0.00,0.00,580.27,327272.28,0.00,0.00,0.00),('1','148','769','246711',4718868,'2140','327',344160.66,344160.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','246711',4718869,'2183','327',476425.15,476425.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','246718',4718945,'2140','327',344160.66,345080.65,0.00,0.00,919.99,566713.84,0.00,0.00,0.00),('1','148','769','246718',4718946,'2183','327',476425.15,477742.95,0.00,0.00,1317.80,743239.20,0.00,0.00,0.00),('1','148','769','246726',4719050,'2140','327',345080.65,346009.89,0.00,0.00,929.24,572411.84,0.00,0.00,0.00),('1','148','769','246726',4719051,'2183','327',477742.95,479148.63,0.00,0.00,1405.68,792803.52,0.00,0.00,0.00),('1','148','769','246960',4723275,'2140','327',346009.89,346444.46,0.00,0.00,434.57,267695.12,0.00,0.00,0.00),('1','148','769','246960',4723276,'2183','327',479148.63,479435.75,0.00,0.00,287.12,161935.68,0.00,0.00,0.00),('1','148','769','247181',4727026,'2140','327',346444.46,347019.42,0.00,0.00,574.96,354175.36,0.00,0.00,0.00),('1','148','769','247181',4727027,'2183','327',479435.75,480818.73,0.00,0.00,1382.98,780000.72,0.00,0.00,0.00),('1','148','769','247186',4727048,'2140','327',347019.42,347818.82,0.00,0.00,799.40,492430.40,0.00,0.00,0.00),('1','148','769','247186',4727049,'2183','327',480818.73,483342.66,0.00,0.00,2523.93,1423496.52,0.00,0.00,0.00),('1','148','769','247398',4731058,'2140','327',347818.82,347818.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','247398',4731059,'2183','327',483342.66,483342.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','247400',4731061,'2140','327',347818.82,348071.68,0.00,0.00,252.86,155761.76,0.00,0.00,0.00),('1','148','769','247400',4731062,'2183','327',483342.66,483498.79,0.00,0.00,156.13,90930.32,0.00,0.00,0.00),('1','148','769','247412',4731167,'2140','327',348071.68,349175.16,0.00,0.00,1103.48,679743.68,0.00,0.00,0.00),('1','148','769','247412',4731168,'2183','327',483498.79,485297.46,0.00,0.00,1798.67,1014449.88,0.00,0.00,0.00),('1','148','769','247729',4736600,'2140','327',349175.16,349796.11,0.00,0.00,620.95,367602.40,0.00,0.00,0.00),('1','148','769','247729',4736601,'2183','327',485297.46,486632.46,0.00,0.00,1335.00,742260.00,0.00,0.00,0.00),('1','148','769','247925',4739795,'2140','327',349796.11,350387.29,0.00,0.00,591.18,349978.56,0.00,0.00,0.00),('1','148','769','247925',4739796,'2183','327',486632.46,487496.59,0.00,0.00,864.13,480456.28,0.00,0.00,0.00),('1','148','769','247930',4739819,'2140','327',350387.29,351605.28,0.00,0.00,1217.99,721050.08,0.00,0.00,0.00),('1','148','769','247930',4739820,'2183','327',487496.59,489740.99,0.00,0.00,2244.40,1247886.40,0.00,0.00,0.00),('1','148','769','248211',4744663,'2140','327',351605.28,352046.60,0.00,0.00,441.32,261261.44,0.00,0.00,0.00),('1','148','769','248211',4744664,'2183','327',489740.99,490177.42,0.00,0.00,436.43,242959.28,0.00,0.00,0.00),('1','148','769','248343',4747170,'2140','327',352046.60,352620.57,0.00,0.00,573.97,339790.24,0.00,0.00,0.00),('1','148','769','248343',4747171,'2183','327',490177.42,490761.59,0.00,0.00,584.17,324798.52,0.00,0.00,0.00),('1','148','769','248451',4748572,'2140','327',352620.57,353798.95,0.00,0.00,1178.38,697600.96,0.00,0.00,0.00),('1','148','769','248451',4748573,'2183','327',490761.59,493335.88,0.00,0.00,2574.29,1437253.88,0.00,0.00,0.00),('1','148','769','248744',4753813,'2140','327',353798.95,355227.49,0.00,0.00,1428.54,845695.68,0.00,0.00,0.00),('1','148','769','248744',4753814,'2183','327',493335.88,496499.00,0.00,0.00,3163.12,1758694.72,0.00,0.00,0.00),('1','148','769','248976',4757677,'2140','327',355227.49,355508.37,0.00,0.00,280.88,166280.96,0.00,0.00,0.00),('1','148','769','248976',4757678,'2183','327',496499.00,496499.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','249141',4760163,'2140','327',355508.37,355508.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','249141',4760164,'2183','327',496499.00,496499.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','249144',4760182,'2140','327',355508.37,356212.66,0.00,0.00,704.29,416939.68,0.00,0.00,0.00),('1','148','769','249144',4760183,'2183','327',496499.00,498214.63,0.00,0.00,1715.63,909283.90,0.00,0.00,0.00),('1','148','769','249152',4760319,'2140','327',356212.66,357078.84,0.00,0.00,866.18,512778.56,0.00,0.00,0.00),('1','148','769','249152',4760320,'2183','327',498214.63,500023.72,0.00,0.00,1809.09,959194.66,0.00,0.00,0.00),('1','148','769','249385',4764396,'2140','327',357078.84,357362.40,0.00,0.00,283.56,167867.52,0.00,0.00,0.00),('1','148','769','249385',4764397,'2183','327',500023.72,500319.79,0.00,0.00,296.07,162063.10,0.00,0.00,0.00),('1','148','769','249406',4764775,'2140','327',357362.40,358595.43,0.00,0.00,1233.03,729953.76,0.00,0.00,0.00),('1','148','769','249406',4764776,'2183','327',500319.79,502264.78,0.00,0.00,1944.99,1030844.70,0.00,0.00,0.00),('1','148','769','249659',4769120,'2140','327',358595.43,359271.72,0.00,0.00,676.29,400363.68,0.00,0.00,0.00),('1','148','769','249659',4769121,'2183','327',502264.78,503131.24,0.00,0.00,866.46,459223.80,0.00,0.00,0.00),('1','148','769','249903',4773219,'2140','327',359271.72,359896.64,0.00,0.00,624.92,369952.64,0.00,0.00,0.00),('1','148','769','249903',4773220,'2183','327',503131.24,503582.60,0.00,0.00,451.36,239220.80,0.00,0.00,0.00),('1','148','769','249916',4773485,'2140','327',359896.64,359969.51,0.00,0.00,72.87,43139.04,0.00,0.00,0.00),('1','148','769','249916',4773486,'2183','327',503582.60,503799.43,0.00,0.00,216.83,114919.90,0.00,0.00,0.00),('1','148','769','249963',4774406,'2140','327',359969.51,361190.94,0.00,0.00,1221.43,723086.56,0.00,0.00,0.00),('1','148','769','249963',4774407,'2183','327',503799.43,505770.47,0.00,0.00,1971.04,1044651.20,0.00,0.00,0.00),('1','148','769','250124',4776824,'2140','327',361190.94,361711.87,0.00,0.00,520.93,308390.56,0.00,0.00,0.00),('1','148','769','250124',4776825,'2183','327',505770.47,506030.35,0.00,0.00,259.88,137736.40,0.00,0.00,0.00),('1','148','769','250346',4780731,'2140','327',361711.87,362433.28,0.00,0.00,721.41,427074.72,0.00,0.00,0.00),('1','148','769','250346',4780732,'2183','327',506030.35,509155.10,0.00,0.00,3124.75,1666117.48,0.00,0.00,0.00),('1','148','769','250357',4780836,'2140','327',362433.28,362879.38,0.00,0.00,446.10,264091.20,0.00,0.00,0.00),('1','148','769','250357',4780837,'2183','327',509155.10,510062.83,0.00,0.00,907.73,490020.56,0.00,0.00,0.00),('1','148','769','250564',4784367,'2140','327',362879.38,364150.11,0.00,0.00,1270.73,748862.16,0.00,0.00,0.00),('1','148','769','250564',4784368,'2183','327',510062.83,512272.69,0.00,0.00,2209.86,1171592.22,0.00,0.00,0.00),('1','148','769','250811',4788629,'2140','327',364150.11,365151.07,0.00,0.00,1000.96,592568.32,0.00,0.00,0.00),('1','148','769','250811',4788630,'2183','327',512272.69,513774.77,0.00,0.00,1502.08,796102.40,0.00,0.00,0.00),('1','148','769','251068',4793134,'2140','327',365151.07,366251.80,0.00,0.00,1100.73,651632.16,0.00,0.00,0.00),('1','148','769','251068',4793135,'2183','327',513774.77,515150.71,0.00,0.00,1375.94,729248.20,0.00,0.00,0.00),('1','148','769','251351',4798117,'2140','327',366251.80,367306.03,0.00,0.00,1054.23,624104.16,0.00,0.00,0.00),('1','148','769','251351',4798118,'2183','327',515150.71,516856.88,0.00,0.00,1706.17,904426.96,0.00,0.00,0.00),('1','148','769','251588',4802055,'2140','327',367306.03,368319.81,0.00,0.00,1013.78,600157.76,0.00,0.00,0.00),('1','148','769','251588',4802056,'2183','327',516856.88,518054.41,0.00,0.00,1197.53,634690.90,0.00,0.00,0.00),('1','148','769','251799',4805870,'2140','327',368319.81,369402.64,0.00,0.00,1082.83,641035.36,0.00,0.00,0.00),('1','148','769','251799',4805871,'2183','327',518054.41,519949.95,0.00,0.00,1895.54,1008847.86,0.00,0.00,0.00),('1','148','769','252102',4811185,'2140','327',369402.64,370296.16,0.00,0.00,893.52,528963.84,0.00,0.00,0.00),('1','148','769','252102',4811186,'2183','327',519949.95,520176.16,0.00,0.00,226.21,120090.32,0.00,0.00,0.00),('1','148','769','252240',4813569,'2140','327',370296.16,371828.22,0.00,0.00,1532.06,906979.52,0.00,0.00,0.00),('1','148','769','252240',4813570,'2183','327',520176.16,522048.44,0.00,0.00,1872.28,995848.60,0.00,0.00,0.00),('1','148','769','252391',4816370,'2140','327',371828.22,372066.25,0.00,0.00,238.03,140913.76,0.00,0.00,0.00),('1','148','769','252391',4816371,'2183','327',522048.44,522064.32,0.00,0.00,15.88,9400.96,0.00,0.00,0.00),('1','148','769','252480',4817953,'2140','327',372066.25,373646.37,0.00,0.00,1580.12,918009.04,0.00,0.00,0.00),('1','148','769','252480',4817954,'2183','327',522064.32,523459.98,0.00,0.00,1395.66,747450.42,0.00,0.00,0.00),('1','148','769','252758',4822517,'2140','327',373646.37,374438.51,0.00,0.00,792.14,468946.88,0.00,0.00,0.00),('1','148','769','252758',4822518,'2183','327',523459.98,524099.56,0.00,0.00,639.58,342421.76,0.00,0.00,0.00),('1','148','769','252882',4824728,'2140','327',374438.51,375098.49,0.00,0.00,659.98,390708.16,0.00,0.00,0.00),('1','148','769','252882',4824729,'2183','327',524099.56,524402.31,0.00,0.00,302.75,160845.00,0.00,0.00,0.00),('1','148','769','252973',4826160,'2140','327',375098.49,376690.83,0.00,0.00,1592.34,938077.28,0.00,0.00,0.00),('1','148','769','252973',4826161,'2183','327',524402.31,525309.26,0.00,0.00,906.95,484679.40,0.00,0.00,0.00),('1','148','769','253216',4830308,'2140','327',376690.83,377489.90,0.00,0.00,799.07,473049.44,0.00,0.00,0.00),('1','148','769','253216',4830309,'2183','327',525309.26,525778.62,0.00,0.00,469.36,249171.92,0.00,0.00,0.00),('1','148','769','253361',4832637,'2140','327',377489.90,378011.13,0.00,0.00,521.23,308568.16,0.00,0.00,0.00),('1','148','769','253361',4832638,'2183','327',525778.62,525908.49,0.00,0.00,129.87,72123.04,0.00,0.00,0.00),('1','148','769','253481',4834824,'2140','327',378011.13,379614.01,0.00,0.00,1602.88,947544.96,0.00,0.00,0.00),('1','148','769','253481',4834825,'2183','327',525908.49,527481.31,0.00,0.00,1572.82,830843.44,0.00,0.00,0.00),('1','148','769','253723',4838837,'2140','327',379614.01,380015.38,0.00,0.00,401.37,237611.04,0.00,0.00,0.00),('1','148','769','253723',4838838,'2183','327',527481.31,527965.31,0.00,0.00,484.00,253616.00,0.00,0.00,0.00),('1','148','769','253809',4840482,'2140','327',380015.38,380992.28,0.00,0.00,976.90,578324.80,0.00,0.00,0.00),('1','148','769','253809',4840483,'2183','327',527965.31,528625.26,0.00,0.00,659.95,350638.40,0.00,0.00,0.00),('1','148','769','253964',4843099,'2140','327',380992.28,383251.06,0.00,0.00,2258.78,1239277.76,0.00,0.00,0.00),('1','148','769','253964',4843100,'2183','327',528625.26,529128.26,0.00,0.00,503.00,263572.00,0.00,0.00,0.00),('1','148','769','254110',4845874,'2140','327',383251.06,383825.78,0.00,0.00,574.72,340234.24,0.00,0.00,0.00),('1','148','769','254110',4845875,'2183','327',529128.26,529273.76,0.00,0.00,145.50,77976.00,0.00,0.00,0.00),('1','148','769','254207',4847486,'2140','327',383825.78,385232.84,0.00,0.00,1407.06,823187.52,0.00,0.00,0.00),('1','148','769','254207',4847487,'2183','327',529273.76,530325.77,0.00,0.00,1052.01,555537.92,0.00,0.00,0.00),('1','148','769','254453',4851772,'2140','327',385232.84,387000.65,0.00,0.00,1767.81,1045455.52,0.00,0.00,0.00),('1','148','769','254453',4851773,'2183','327',530325.77,531657.99,0.00,0.00,1332.22,700886.24,0.00,0.00,0.00),('1','148','769','254710',4856206,'2140','327',387000.65,387849.32,0.00,0.00,848.67,502412.64,0.00,0.00,0.00),('1','148','769','254710',4856207,'2183','327',531657.99,532295.49,0.00,0.00,637.50,334050.00,0.00,0.00,0.00),('1','148','769','254826',4858199,'2140','327',387849.32,388778.96,0.00,0.00,929.64,550346.88,0.00,0.00,0.00),('1','148','769','254826',4858200,'2183','327',532295.49,532731.18,0.00,0.00,435.69,229613.60,0.00,0.00,0.00),('1','148','769','254951',4860341,'2140','327',388778.96,390498.70,0.00,0.00,1719.74,1018086.08,0.00,0.00,0.00),('1','148','769','254951',4860342,'2183','327',532731.18,533324.71,0.00,0.00,593.53,311997.76,0.00,0.00,0.00),('1','148','769','255212',4864687,'2140','327',390498.70,391177.86,0.00,0.00,679.16,402062.72,0.00,0.00,0.00),('1','148','769','255212',4864688,'2183','327',533324.71,533653.71,0.00,0.00,329.00,172396.00,0.00,0.00,0.00),('1','148','769','255325',4866958,'2140','327',391177.86,391699.18,0.00,0.00,521.32,308621.44,0.00,0.00,0.00),('1','148','769','255325',4866959,'2183','327',533653.71,533866.71,0.00,0.00,213.00,111612.00,0.00,0.00,0.00),('1','148','769','255466',4869148,'2140','327',391699.18,393693.89,0.00,0.00,1994.71,1180868.32,0.00,0.00,0.00),('1','148','769','255466',4869149,'2183','327',533866.71,534880.09,0.00,0.00,1013.38,534674.96,0.00,0.00,0.00),('1','148','769','255747',4873675,'2140','327',393693.89,394011.66,0.00,0.00,317.77,188119.84,0.00,0.00,0.00),('1','148','769','255747',4873676,'2183','327',534880.09,535167.09,0.00,0.00,287.00,150388.00,0.00,0.00,0.00),('1','148','769','255776',4874116,'2140','327',394011.66,395360.40,0.00,0.00,1348.74,798454.08,0.00,0.00,0.00),('1','148','769','255776',4874117,'2183','327',535167.09,535818.63,0.00,0.00,651.54,341406.96,0.00,0.00,0.00),('1','148','769','256006',4877944,'2140','327',395360.40,396430.00,0.00,0.00,1069.60,633203.20,0.00,0.00,0.00),('1','148','769','256006',4877945,'2183','327',535818.63,537251.80,0.00,0.00,1433.17,763026.60,0.00,0.00,0.00),('1','148','769','256126',4880105,'2140','327',396430.00,396825.15,0.00,0.00,395.15,232228.80,0.00,0.00,0.00),('1','148','769','256126',4880106,'2183','327',537251.80,537281.87,0.00,0.00,30.07,16101.44,0.00,0.00,0.00),('1','148','769','256247',4881688,'2140','327',396825.15,398869.58,0.00,0.00,2044.43,1210302.56,0.00,0.00,0.00),('1','148','769','256247',4881689,'2183','327',537281.87,538305.56,0.00,0.00,1023.69,537378.48,0.00,0.00,0.00),('1','148','769','256490',4886054,'2140','327',398869.58,399927.97,0.00,0.00,1058.39,626566.88,0.00,0.00,0.00),('1','148','769','256490',4886055,'2183','327',538305.56,538788.18,0.00,0.00,482.62,253099.60,0.00,0.00,0.00),('1','148','769','256593',4887817,'2140','327',399927.97,400755.11,0.00,0.00,827.14,489666.88,0.00,0.00,0.00),('1','148','769','256593',4887818,'2183','327',538788.18,538991.18,0.00,0.00,203.00,106372.00,0.00,0.00,0.00),('1','148','769','256731',4889978,'2140','327',400755.11,402322.47,0.00,0.00,1567.36,927877.12,0.00,0.00,0.00),('1','148','769','256731',4889979,'2183','327',538991.18,540450.68,0.00,0.00,1459.50,765628.00,0.00,0.00,0.00),('1','148','769','256961',4894122,'2140','327',402322.47,403057.31,0.00,0.00,734.84,435025.28,0.00,0.00,0.00),('1','148','769','256961',4894123,'2183','327',540450.68,541061.68,0.00,0.00,611.00,321014.00,0.00,0.00,0.00),('1','148','769','257106',4896819,'2140','327',403057.31,403829.43,0.00,0.00,772.12,457095.04,0.00,0.00,0.00),('1','148','769','257106',4896820,'2183','327',541061.68,541277.68,0.00,0.00,216.00,113184.00,0.00,0.00,0.00),('1','148','769','257237',4899112,'2140','327',403829.43,405591.72,0.00,0.00,1762.29,1043275.68,0.00,0.00,0.00),('1','148','769','257237',4899113,'2183','327',541277.68,542838.90,0.00,0.00,1561.22,833394.24,0.00,0.00,0.00),('1','148','769','257520',4903815,'2140','327',405591.72,407731.34,0.00,0.00,2139.62,1221836.16,0.00,0.00,0.00),('1','148','769','257520',4903816,'2183','327',542838.90,544278.01,0.00,0.00,1439.11,754318.48,0.00,0.00,0.00),('1','148','769','257521',4903817,'2140','327',407731.34,408720.21,0.00,0.00,988.87,561678.16,0.00,0.00,0.00),('1','148','769','257521',4903818,'2183','327',544278.01,544969.72,0.00,0.00,691.71,362676.92,0.00,0.00,0.00),('1','148','769','257522',4903819,'2140','327',408720.21,409429.02,0.00,0.00,708.81,402604.08,0.00,0.00,0.00),('1','148','769','257522',4903820,'2183','327',544969.72,545223.72,0.00,0.00,254.00,133096.00,0.00,0.00,0.00),('1','148','769','257523',4903821,'2140','327',409429.02,411020.27,0.00,0.00,1591.25,903830.00,0.00,0.00,0.00),('1','148','769','257523',4903822,'2183','327',545223.72,547029.48,0.00,0.00,1805.76,931040.64,0.00,0.00,0.00),('1','148','769','257524',4903823,'2140','327',411020.27,413053.78,0.00,0.00,2033.51,1155033.68,0.00,0.00,0.00),('1','148','769','257524',4903824,'2183','327',547029.48,549952.21,0.00,0.00,2922.73,1512528.22,0.00,0.00,0.00),('1','148','769','257525',4903825,'2140','327',413053.78,413560.61,0.00,0.00,506.83,287879.44,0.00,0.00,0.00),('1','148','769','257525',4903826,'2183','327',549952.21,550149.67,0.00,0.00,197.46,101494.44,0.00,0.00,0.00),('1','148','769','257526',4903827,'2140','327',413560.61,414455.20,0.00,0.00,894.59,508127.12,0.00,0.00,0.00),('1','148','769','257526',4903828,'2183','327',550149.67,553566.83,0.00,0.00,3417.16,1756752.88,0.00,0.00,0.00),('1','148','769','257527',4903829,'2140','327',414455.20,414953.26,0.00,0.00,498.06,282898.08,0.00,0.00,0.00),('1','148','769','257527',4903830,'2183','327',553566.83,554041.95,0.00,0.00,475.12,244211.68,0.00,0.00,0.00),('1','148','769','257528',4903831,'2140','327',414953.26,415859.83,0.00,0.00,906.57,514931.76,0.00,0.00,0.00),('1','148','769','257528',4903832,'2183','327',554041.95,554865.80,0.00,0.00,823.85,423458.90,0.00,0.00,0.00),('1','148','769','257529',4903833,'2140','327',415859.83,417809.15,0.00,0.00,1949.32,1107213.76,0.00,0.00,0.00),('1','148','769','257529',4903834,'2183','327',554865.80,555933.50,0.00,0.00,1067.70,556789.80,0.00,0.00,0.00),('1','148','769','257530',4903835,'2140','327',417809.15,420581.41,0.00,0.00,2772.26,1574643.68,0.00,0.00,0.00),('1','148','769','257530',4903836,'2183','327',555933.50,556820.92,0.00,0.00,887.42,462561.56,0.00,0.00,0.00),('1','148','769','257531',4903837,'2140','327',420581.41,421471.85,0.00,0.00,890.44,505769.92,0.00,0.00,0.00),('1','148','769','257531',4903838,'2183','327',556820.92,557572.69,0.00,0.00,751.77,386937.36,0.00,0.00,0.00),('1','148','769','257532',4903839,'2140','327',421471.85,422742.67,0.00,0.00,1270.82,719125.76,0.00,0.00,0.00),('1','148','769','257532',4903840,'2183','327',557572.69,558160.84,0.00,0.00,588.15,302803.20,0.00,0.00,0.00),('1','148','769','257533',4903841,'2140','327',422742.67,423404.25,0.00,0.00,661.58,375777.44,0.00,0.00,0.00),('1','148','769','257533',4903842,'2183','327',558160.84,558505.36,0.00,0.00,344.52,177273.36,0.00,0.00,0.00),('1','148','769','257534',4903843,'2140','327',423404.25,424838.90,0.00,0.00,1434.65,814881.20,0.00,0.00,0.00),('1','148','769','257534',4903844,'2183','327',558505.36,559557.83,0.00,0.00,1052.47,542176.96,0.00,0.00,0.00),('1','148','769','257535',4903845,'2140','327',424838.90,425899.73,0.00,0.00,1060.83,602551.44,0.00,0.00,0.00),('1','148','769','257535',4903846,'2183','327',559557.83,560565.93,0.00,0.00,1008.10,518183.40,0.00,0.00,0.00),('1','148','769','257536',4903847,'2140','327',425899.73,426393.05,0.00,0.00,493.32,280205.76,0.00,0.00,0.00),('1','148','769','257536',4903848,'2183','327',560565.93,560591.43,0.00,0.00,25.50,13107.00,0.00,0.00,0.00),('1','148','769','257537',4903849,'2140','327',426393.05,428087.49,0.00,0.00,1694.44,955799.92,0.00,0.00,0.00),('1','148','769','257537',4903850,'2183','327',560591.43,562598.93,0.00,0.00,2007.50,1031855.00,0.00,0.00,0.00),('1','148','769','257538',4903851,'2140','327',428087.49,428480.26,0.00,0.00,392.77,223093.36,0.00,0.00,0.00),('1','148','769','257538',4903852,'2183','327',562598.93,562900.93,0.00,0.00,302.00,155228.00,0.00,0.00,0.00),('1','148','769','257539',4903853,'2140','327',428480.26,429417.99,0.00,0.00,937.73,532630.64,0.00,0.00,0.00),('1','148','769','257539',4903854,'2183','327',562900.93,563510.86,0.00,0.00,609.93,313504.02,0.00,0.00,0.00),('1','148','769','257540',4903855,'2140','327',429417.99,431014.73,0.00,0.00,1596.74,906948.32,0.00,0.00,0.00),('1','148','769','257540',4903856,'2183','327',563510.86,564466.02,0.00,0.00,955.16,491284.88,0.00,0.00,0.00),('1','148','769','257541',4903857,'2140','327',431014.73,433561.23,0.00,0.00,2546.50,1443496.00,0.00,0.00,0.00),('1','148','769','257541',4903858,'2183','327',564466.02,565813.04,0.00,0.00,1347.02,692558.36,0.00,0.00,0.00),('1','148','769','257542',4903859,'2140','327',433561.23,434370.87,0.00,0.00,809.64,459875.52,0.00,0.00,0.00),('1','148','769','257542',4903860,'2183','327',565813.04,566219.04,0.00,0.00,406.00,208684.00,0.00,0.00,0.00),('1','148','769','257543',4903861,'2140','327',434370.87,435627.35,0.00,0.00,1256.48,713680.64,0.00,0.00,0.00),('1','148','769','257543',4903862,'2183','327',566219.04,566705.18,0.00,0.00,486.14,250018.52,0.00,0.00,0.00),('1','148','769','257544',4903863,'2140','327',435627.35,436805.07,0.00,0.00,1177.72,668944.96,0.00,0.00,0.00),('1','148','769','257544',4903864,'2183','327',566705.18,567245.18,0.00,0.00,540.00,277530.00,0.00,0.00,0.00),('1','148','769','257545',4903865,'2140','327',436805.07,437983.26,0.00,0.00,1178.19,669211.92,0.00,0.00,0.00),('1','148','769','257545',4903866,'2183','327',567245.18,567959.20,0.00,0.00,714.02,367196.36,0.00,0.00,0.00),('1','148','769','257546',4903867,'2140','327',437983.26,439416.44,0.00,0.00,1433.18,810806.24,0.00,0.00,0.00),('1','148','769','257546',4903868,'2183','327',567959.20,568673.20,0.00,0.00,714.00,366996.00,0.00,0.00,0.00),('1','148','769','257547',4903869,'2140','327',439416.44,441044.78,0.00,0.00,1628.34,924897.12,0.00,0.00,0.00),('1','148','769','257547',4903870,'2183','327',568673.20,570221.70,0.00,0.00,1548.50,796604.00,0.00,0.00,0.00),('1','148','769','257548',4903871,'2140','327',441044.78,443012.91,0.00,0.00,1968.13,1117897.84,0.00,0.00,0.00),('1','148','769','257548',4903872,'2183','327',570221.70,570936.70,0.00,0.00,715.00,367510.00,0.00,0.00,0.00),('1','148','769','257549',4903873,'2140','327',443012.91,444382.55,0.00,0.00,1369.64,777955.52,0.00,0.00,0.00),('1','148','769','257549',4903874,'2183','327',570936.70,571982.26,0.00,0.00,1045.56,538150.08,0.00,0.00,0.00),('1','148','769','257550',4903875,'2140','327',444382.55,445705.78,0.00,0.00,1323.23,751594.64,0.00,0.00,0.00),('1','148','769','257550',4903876,'2183','327',571982.26,572644.70,0.00,0.00,662.44,340969.36,0.00,0.00,0.00),('1','148','769','257551',4903877,'2140','327',445705.78,447039.09,0.00,0.00,1333.31,757320.08,0.00,0.00,0.00),('1','148','769','257551',4903878,'2183','327',572644.70,573637.70,0.00,0.00,993.00,510402.00,0.00,0.00,0.00),('1','148','769','257552',4903879,'2140','327',447039.09,448241.66,0.00,0.00,1202.57,681655.76,0.00,0.00,0.00),('1','148','769','257552',4903880,'2183','327',573637.70,574856.22,0.00,0.00,1218.52,626529.36,0.00,0.00,0.00),('1','148','769','257553',4903881,'2140','327',448241.66,448704.18,0.00,0.00,462.52,262711.36,0.00,0.00,0.00),('1','148','769','257553',4903882,'2183','327',574856.22,575226.72,0.00,0.00,370.50,190319.00,0.00,0.00,0.00),('1','148','769','257554',4903883,'2140','327',448704.18,449421.10,0.00,0.00,716.92,407210.56,0.00,0.00,0.00),('1','148','769','257554',4903884,'2183','327',575226.72,575683.48,0.00,0.00,456.76,235544.68,0.00,0.00,0.00),('1','148','769','257555',4903885,'2140','327',449421.10,449886.45,0.00,0.00,465.35,264318.80,0.00,0.00,0.00),('1','148','769','257555',4903886,'2183','327',575683.48,576250.49,0.00,0.00,567.01,291443.14,0.00,0.00,0.00),('1','148','769','257556',4903887,'2140','327',449886.45,451626.30,0.00,0.00,1739.85,988234.80,0.00,0.00,0.00),('1','148','769','257556',4903888,'2183','327',576250.49,577237.74,0.00,0.00,987.25,507446.50,0.00,0.00,0.00),('1','148','769','257557',4903889,'2140','327',451626.30,452605.94,0.00,0.00,979.64,556435.52,0.00,0.00,0.00),('1','148','769','257557',4903890,'2183','327',577237.74,577764.24,0.00,0.00,526.50,270621.00,0.00,0.00,0.00),('1','148','769','257558',4903891,'2140','327',452605.94,453847.74,0.00,0.00,1241.80,705342.40,0.00,0.00,0.00),('1','148','769','257558',4903892,'2183','327',577764.24,578503.24,0.00,0.00,739.00,379846.00,0.00,0.00,0.00),('1','148','769','257559',4903893,'2140','327',453847.74,455034.20,0.00,0.00,1186.46,673909.28,0.00,0.00,0.00),('1','148','769','257559',4903894,'2183','327',578503.24,579379.26,0.00,0.00,876.02,450949.28,0.00,0.00,0.00),('1','148','769','257560',4903895,'2140','327',455034.20,456127.22,0.00,0.00,1093.02,633772.08,0.00,0.00,0.00),('1','148','769','257560',4903896,'2183','327',579379.26,579388.23,0.00,0.00,8.97,5202.60,0.00,0.00,0.00),('1','148','769','257561',4903897,'2140','327',456127.22,457594.57,0.00,0.00,1467.35,851063.00,0.00,0.00,0.00),('1','148','769','257561',4903898,'2183','327',579388.23,579413.22,0.00,0.00,24.99,14494.20,0.00,0.00,0.00),('1','148','769','257562',4903899,'2140','327',457594.57,459866.44,0.00,0.00,2271.87,1320604.60,0.00,0.00,0.00),('1','148','769','257562',4903900,'2183','327',579413.22,579779.84,0.00,0.00,366.62,212639.60,0.00,0.00,0.00),('1','148','769','257563',4903901,'2140','327',459866.44,460648.50,0.00,0.00,782.06,453594.80,0.00,0.00,0.00),('1','148','769','257563',4903902,'2183','327',579779.84,579802.68,0.00,0.00,22.84,13247.20,0.00,0.00,0.00),('1','148','769','257564',4903903,'2140','327',460648.50,461741.08,0.00,0.00,1092.58,633696.40,0.00,0.00,0.00),('1','148','769','257564',4903904,'2183','327',579802.68,579886.75,0.00,0.00,84.07,48760.60,0.00,0.00,0.00),('1','148','769','257565',4903905,'2140','327',461741.08,464212.99,0.00,0.00,2471.91,1433707.80,0.00,0.00,0.00),('1','148','769','257565',4903906,'2183','327',579886.75,580175.46,0.00,0.00,288.71,167451.80,0.00,0.00,0.00),('1','148','769','257566',4903907,'2140','327',464212.99,464426.94,0.00,0.00,213.95,124091.00,0.00,0.00,0.00),('1','148','769','257566',4903908,'2183','327',580175.46,580184.08,0.00,0.00,8.62,4999.60,0.00,0.00,0.00),('1','148','769','257567',4903909,'2140','327',464426.94,465844.18,0.00,0.00,1417.24,821999.20,0.00,0.00,0.00),('1','148','769','257567',4903910,'2183','327',580184.08,580393.44,0.00,0.00,209.36,121428.80,0.00,0.00,0.00),('1','148','769','257568',4903911,'2140','327',465844.18,467875.42,0.00,0.00,2031.24,1299993.60,0.00,0.00,0.00),('1','148','769','257568',4903912,'2183','327',580393.44,580607.30,0.00,0.00,213.86,136870.40,0.00,0.00,0.00),('1','148','769','257569',4903913,'2140','327',467875.42,468786.09,0.00,0.00,910.67,582828.80,0.00,0.00,0.00),('1','148','769','257569',4903914,'2183','327',580607.30,581007.62,0.00,0.00,400.32,256204.80,0.00,0.00,0.00),('1','148','769','257570',4903915,'2140','327',468786.09,470504.92,0.00,0.00,1718.83,1100051.20,0.00,0.00,0.00),('1','148','769','257570',4903916,'2183','327',581007.62,581338.82,0.00,0.00,331.20,211968.00,0.00,0.00,0.00),('1','148','769','257571',4903917,'2140','327',470504.92,470786.06,0.00,0.00,281.14,179929.60,0.00,0.00,0.00),('1','148','769','257571',4903918,'2183','327',581338.82,581463.51,0.00,0.00,124.69,79801.60,0.00,0.00,0.00),('1','148','769','257572',4903919,'2140','327',470786.06,471920.53,0.00,0.00,1134.47,726060.80,0.00,0.00,0.00),('1','148','769','257572',4903920,'2183','327',581463.51,581563.99,0.00,0.00,100.48,64307.20,0.00,0.00,0.00),('1','148','769','257573',4903921,'2140','327',471920.53,474013.59,0.00,0.00,2093.06,1339558.40,0.00,0.00,0.00),('1','148','769','257573',4903922,'2183','327',581563.99,582186.73,0.00,0.00,622.74,398553.60,0.00,0.00,0.00),('1','148','769','257574',4903923,'2140','327',474013.59,474554.83,0.00,0.00,541.24,346393.60,0.00,0.00,0.00),('1','148','769','257574',4903924,'2183','327',582186.73,582540.88,0.00,0.00,354.15,226656.00,0.00,0.00,0.00),('1','148','769','257575',4903925,'2140','327',474554.83,475190.18,0.00,0.00,635.35,406624.00,0.00,0.00,0.00),('1','148','769','257575',4903926,'2183','327',582540.88,582742.12,0.00,0.00,201.24,128793.60,0.00,0.00,0.00),('1','148','769','257576',4903927,'2140','327',475190.18,475902.53,0.00,0.00,712.35,484398.00,0.00,0.00,0.00),('1','148','769','257576',4903928,'2183','327',582742.12,583023.57,0.00,0.00,281.45,191386.00,0.00,0.00,0.00),('1','148','769','257577',4903929,'2140','327',475902.53,476220.75,0.00,0.00,318.22,216389.60,0.00,0.00,0.00),('1','148','769','257577',4903930,'2183','327',583023.57,583038.91,0.00,0.00,15.34,10431.20,0.00,0.00,0.00),('1','148','769','257578',4903931,'2140','327',476220.75,476662.81,0.00,0.00,442.06,300600.80,0.00,0.00,0.00),('1','148','769','257578',4903932,'2183','327',583038.91,583041.85,0.00,0.00,2.94,1999.20,0.00,0.00,0.00),('1','148','769','257579',4903933,'2140','327',476662.81,477737.54,0.00,0.00,1074.73,730816.40,0.00,0.00,0.00),('1','148','769','257579',4903934,'2183','327',583041.85,583144.00,0.00,0.00,102.15,69462.00,0.00,0.00,0.00),('1','148','769','257580',4903935,'2140','327',477737.54,478537.64,0.00,0.00,800.10,544068.00,0.00,0.00,0.00),('1','148','769','257580',4903936,'2183','327',583144.00,583197.23,0.00,0.00,53.23,36196.40,0.00,0.00,0.00),('1','148','769','257581',4903937,'2140','327',478537.64,478647.67,0.00,0.00,110.03,74820.40,0.00,0.00,0.00),('1','148','769','257581',4903938,'2183','327',583197.23,583215.24,0.00,0.00,18.01,12246.80,0.00,0.00,0.00),('1','148','769','257582',4903939,'2140','327',478647.67,480491.04,0.00,0.00,1843.37,1253491.60,0.00,0.00,0.00),('1','148','769','257582',4903940,'2183','327',583215.24,583263.76,0.00,0.00,48.52,32993.60,0.00,0.00,0.00),('1','148','769','257583',4903941,'2140','327',480491.04,482158.14,0.00,0.00,1667.10,1133628.00,0.00,0.00,0.00),('1','148','769','257583',4903942,'2183','327',583263.76,583282.85,0.00,0.00,19.09,12981.20,0.00,0.00,0.00),('1','148','769','257584',4903943,'2140','327',482158.14,482597.48,0.00,0.00,439.34,298751.20,0.00,0.00,0.00),('1','148','769','257584',4903944,'2183','327',583282.85,583282.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257585',4903945,'2140','327',482597.48,483048.29,0.00,0.00,450.81,306550.80,0.00,0.00,0.00),('1','148','769','257585',4903946,'2183','327',583282.85,583297.84,0.00,0.00,14.99,10193.20,0.00,0.00,0.00),('1','148','769','257586',4903947,'2140','327',483048.29,484390.17,0.00,0.00,1341.88,912478.40,0.00,0.00,0.00),('1','148','769','257586',4903948,'2183','327',583297.84,583310.34,0.00,0.00,12.50,8500.00,0.00,0.00,0.00),('1','148','769','257587',4903949,'2140','327',484390.17,485690.29,0.00,0.00,1300.12,884081.60,0.00,0.00,0.00),('1','148','769','257587',4903950,'2183','327',583310.34,583342.32,0.00,0.00,31.98,21746.40,0.00,0.00,0.00),('1','148','769','257588',4903951,'2140','327',485690.29,487128.50,0.00,0.00,1438.21,977982.80,0.00,0.00,0.00),('1','148','769','257588',4903952,'2183','327',583342.32,583355.11,0.00,0.00,12.79,8697.20,0.00,0.00,0.00),('1','148','769','257589',4903953,'2140','327',487128.50,487599.05,0.00,0.00,470.55,319974.00,0.00,0.00,0.00),('1','148','769','257589',4903954,'2183','327',583355.11,583355.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257590',4903955,'2140','327',487599.05,488112.19,0.00,0.00,513.14,348935.20,0.00,0.00,0.00),('1','148','769','257590',4903956,'2183','327',583355.11,583367.09,0.00,0.00,11.98,8146.40,0.00,0.00,0.00),('1','148','769','257591',4903957,'2140','327',488112.19,488736.56,0.00,0.00,624.37,424571.60,0.00,0.00,0.00),('1','148','769','257591',4903958,'2183','327',583367.09,583375.91,0.00,0.00,8.82,5997.60,0.00,0.00,0.00),('1','148','769','257592',4903959,'2140','327',488736.56,490064.73,0.00,0.00,1328.17,913780.96,0.00,0.00,0.00),('1','148','769','257592',4903960,'2183','327',583375.91,583699.92,0.00,0.00,324.01,222918.88,0.00,0.00,0.00),('1','148','769','257593',4903961,'2140','327',490064.73,491243.89,0.00,0.00,1179.16,811262.08,0.00,0.00,0.00),('1','148','769','257593',4903962,'2183','327',583699.92,583957.91,0.00,0.00,257.99,177497.12,0.00,0.00,0.00),('1','148','769','257594',4903963,'2140','327',491243.89,491565.89,0.00,0.00,322.00,221536.00,0.00,0.00,0.00),('1','148','769','257594',4903964,'2183','327',583957.91,583957.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257595',4903965,'2140','327',491565.89,492367.80,0.00,0.00,801.91,576262.08,0.00,0.00,0.00),('1','148','769','257595',4903966,'2183','327',583957.91,583957.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257596',4903967,'2140','327',492367.80,494029.56,0.00,0.00,1661.76,1143290.88,0.00,0.00,0.00),('1','148','769','257596',4903968,'2183','327',583957.91,583957.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257597',4903969,'2140','327',494029.56,495693.60,0.00,0.00,1664.04,1104922.56,0.00,0.00,0.00),('1','148','769','257597',4903970,'2183','327',583957.91,583957.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257598',4903971,'2140','327',495693.60,497679.24,0.00,0.00,1985.64,1318464.96,0.00,0.00,0.00),('1','148','769','257598',4903972,'2183','327',583957.91,583957.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257599',4903973,'2140','327',497679.24,500741.42,0.00,0.00,3062.18,2033287.52,0.00,0.00,0.00),('1','148','769','257599',4903974,'2183','327',583957.91,584168.00,0.00,0.00,210.09,139499.76,0.00,0.00,0.00),('1','148','769','257600',4903975,'2140','327',500741.42,502673.21,0.00,0.00,1931.79,1282708.56,0.00,0.00,0.00),('1','148','769','257600',4903976,'2183','327',584168.00,584251.38,0.00,0.00,83.38,55364.32,0.00,0.00,0.00),('1','148','769','257601',4903977,'2140','327',502673.21,502841.47,0.00,0.00,168.26,111724.64,0.00,0.00,0.00),('1','148','769','257601',4903978,'2183','327',584251.38,584251.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257602',4903979,'2140','327',502841.47,504628.63,0.00,0.00,1787.16,1186674.24,0.00,0.00,0.00),('1','148','769','257602',4903980,'2183','327',584251.38,584449.92,0.00,0.00,198.54,131830.56,0.00,0.00,0.00),('1','148','769','257603',4903981,'2140','327',504628.63,506236.30,0.00,0.00,1607.67,1067492.88,0.00,0.00,0.00),('1','148','769','257603',4903982,'2183','327',584449.92,584661.59,0.00,0.00,211.67,140548.88,0.00,0.00,0.00),('1','148','769','257604',4903983,'2140','327',506236.30,507149.69,0.00,0.00,913.39,606490.96,0.00,0.00,0.00),('1','148','769','257604',4903984,'2183','327',584661.59,584695.93,0.00,0.00,34.34,22801.76,0.00,0.00,0.00),('1','148','769','257605',4903985,'2140','327',507149.69,508627.97,0.00,0.00,1478.28,981577.92,0.00,0.00,0.00),('1','148','769','257605',4903986,'2183','327',584695.93,584718.51,0.00,0.00,22.58,14993.12,0.00,0.00,0.00),('1','148','769','257606',4903987,'2140','327',508627.97,510272.64,0.00,0.00,1644.67,1092060.88,0.00,0.00,0.00),('1','148','769','257606',4903988,'2183','327',584718.51,584945.18,0.00,0.00,226.67,150508.88,0.00,0.00,0.00),('1','148','769','257607',4903989,'2140','327',510272.64,511053.92,0.00,0.00,781.28,518769.92,0.00,0.00,0.00),('1','148','769','257607',4903990,'2183','327',584945.18,585519.71,0.00,0.00,574.53,381487.92,0.00,0.00,0.00),('1','148','769','257608',4903991,'2140','327',511053.92,511599.66,0.00,0.00,545.74,362371.36,0.00,0.00,0.00),('1','148','769','257608',4903992,'2183','327',585519.71,585519.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257609',4903993,'2140','327',511599.66,513713.71,0.00,0.00,2114.05,1403729.20,0.00,0.00,0.00),('1','148','769','257609',4903994,'2183','327',585519.71,585607.06,0.00,0.00,87.35,58000.40,0.00,0.00,0.00),('1','148','769','257610',4903995,'2140','327',513713.71,514787.42,0.00,0.00,1073.71,712943.44,0.00,0.00,0.00),('1','148','769','257610',4903996,'2183','327',585607.06,585607.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257611',4903997,'2140','327',514787.42,515193.87,0.00,0.00,406.45,269882.80,0.00,0.00,0.00),('1','148','769','257611',4903998,'2183','327',585607.06,585629.35,0.00,0.00,22.29,14800.56,0.00,0.00,0.00),('1','148','769','257612',4903999,'2140','327',515193.87,516886.21,0.00,0.00,1692.34,1123713.76,0.00,0.00,0.00),('1','148','769','257612',4904000,'2183','327',585629.35,585651.03,0.00,0.00,21.68,14395.52,0.00,0.00,0.00),('1','148','769','257613',4904001,'2140','327',516886.21,518666.04,0.00,0.00,1779.83,1181807.12,0.00,0.00,0.00),('1','148','769','257613',4904002,'2183','327',585651.03,585727.53,0.00,0.00,76.50,50796.00,0.00,0.00,0.00),('1','148','769','257614',4904003,'2140','327',518666.04,518892.86,0.00,0.00,226.82,150608.48,0.00,0.00,0.00),('1','148','769','257614',4904004,'2183','327',585727.53,585730.09,0.00,0.00,2.56,1699.84,0.00,0.00,0.00),('1','148','769','257615',4904005,'2140','327',518892.86,519380.70,0.00,0.00,487.84,323925.76,0.00,0.00,0.00),('1','148','769','257615',4904006,'2183','327',585730.09,585730.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257616',4904007,'2140','327',519380.70,521390.59,0.00,0.00,2009.89,1334566.96,0.00,0.00,0.00),('1','148','769','257616',4904008,'2183','327',585730.09,585740.63,0.00,0.00,10.54,6998.56,0.00,0.00,0.00),('1','148','769','257617',4904009,'2140','327',521390.59,522725.50,0.00,0.00,1334.91,886380.24,0.00,0.00,0.00),('1','148','769','257617',4904010,'2183','327',585740.63,586062.74,0.00,0.00,322.11,213881.04,0.00,0.00,0.00),('1','148','769','257618',4904011,'2140','327',522725.50,524279.35,0.00,0.00,1553.85,1031756.40,0.00,0.00,0.00),('1','148','769','257618',4904012,'2183','327',586062.74,586119.65,0.00,0.00,56.91,37788.24,0.00,0.00,0.00),('1','148','769','257619',4904013,'2140','327',524279.35,524279.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257619',4904014,'2183','327',586119.65,587597.80,0.00,0.00,1478.15,981491.60,0.00,0.00,0.00),('1','148','769','257620',4904015,'2140','327',524279.35,524279.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257620',4904016,'2183','327',587597.80,589146.87,0.00,0.00,1549.07,1028582.48,0.00,0.00,0.00),('1','148','769','257621',4904017,'2140','327',524279.35,524279.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257621',4904018,'2183','327',589146.87,590723.55,0.00,0.00,1576.68,1046915.52,0.00,0.00,0.00),('1','148','769','257622',4904019,'2140','327',524279.35,524279.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257622',4904020,'2183','327',590723.55,592368.31,0.00,0.00,1644.76,1092120.64,0.00,0.00,0.00),('1','148','769','257623',4904021,'2140','327',524279.35,524279.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257623',4904022,'2183','327',592368.31,593007.14,0.00,0.00,638.83,424183.12,0.00,0.00,0.00),('1','148','769','257624',4904023,'2140','327',524279.35,524279.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257624',4904024,'2183','327',593007.14,594250.15,0.00,0.00,1243.01,825358.64,0.00,0.00,0.00),('1','148','769','257625',4904025,'2140','327',524279.35,524279.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257625',4904026,'2183','327',594250.15,596072.79,0.00,0.00,1822.64,1210232.96,0.00,0.00,0.00),('1','148','769','257626',4904027,'2140','327',524279.35,525039.49,0.00,0.00,760.14,504732.96,0.00,0.00,0.00),('1','148','769','257626',4904028,'2183','327',596072.79,596072.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257627',4904029,'2140','327',525039.49,525468.15,0.00,0.00,428.66,284630.24,0.00,0.00,0.00),('1','148','769','257627',4904030,'2183','327',596072.79,596072.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257628',4904031,'2140','327',525468.15,525586.59,0.00,0.00,118.44,78644.16,0.00,0.00,0.00),('1','148','769','257628',4904032,'2183','327',596072.79,596072.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257629',4904033,'2140','327',525586.59,526307.33,0.00,0.00,720.74,478571.36,0.00,0.00,0.00),('1','148','769','257629',4904034,'2183','327',596072.79,596072.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257630',4904035,'2140','327',526307.33,526307.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257630',4904036,'2183','327',596072.79,596223.77,0.00,0.00,150.98,100250.72,0.00,0.00,0.00),('1','148','769','257631',4904037,'2140','327',526307.33,526307.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257631',4904038,'2183','327',596223.77,596732.48,0.00,0.00,508.71,337783.44,0.00,0.00,0.00),('1','148','769','257632',4904039,'2140','327',526307.33,528796.11,0.00,0.00,2488.78,1652549.92,0.00,0.00,0.00),('1','148','769','257632',4904040,'2183','327',596732.48,596732.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257633',4904041,'2140','327',528796.11,529799.35,0.00,0.00,1003.24,666151.36,0.00,0.00,0.00),('1','148','769','257633',4904042,'2183','327',596732.48,596732.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257634',4904043,'2140','327',529799.35,530857.85,0.00,0.00,1058.50,702844.00,0.00,0.00,0.00),('1','148','769','257634',4904044,'2183','327',596732.48,596732.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257635',4904045,'2140','327',530857.85,531687.72,0.00,0.00,829.87,551033.68,0.00,0.00,0.00),('1','148','769','257635',4904046,'2183','327',596732.48,596732.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257636',4904047,'2140','327',531687.72,533225.22,0.00,0.00,1537.50,1020900.00,0.00,0.00,0.00),('1','148','769','257636',4904048,'2183','327',596732.48,597348.44,0.00,0.00,615.96,408997.44,0.00,0.00,0.00),('1','148','769','257637',4904049,'2140','327',533225.22,533711.15,0.00,0.00,485.93,322657.52,0.00,0.00,0.00),('1','148','769','257637',4904050,'2183','327',597348.44,597422.50,0.00,0.00,74.06,49175.84,0.00,0.00,0.00),('1','148','769','257638',4904051,'2140','327',533711.15,534617.27,0.00,0.00,906.12,601663.68,0.00,0.00,0.00),('1','148','769','257638',4904052,'2183','327',597422.50,597422.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257639',4904053,'2140','327',534617.27,536123.24,0.00,0.00,1505.97,999964.08,0.00,0.00,0.00),('1','148','769','257639',4904054,'2183','327',597422.50,597505.62,0.00,0.00,83.12,55191.68,0.00,0.00,0.00),('1','148','769','257640',4904055,'2140','327',536123.24,538203.50,0.00,0.00,2080.26,1381292.64,0.00,0.00,0.00),('1','148','769','257640',4904056,'2183','327',597505.62,597525.20,0.00,0.00,19.58,13001.12,0.00,0.00,0.00),('1','148','769','257641',4904057,'2140','327',538203.50,539447.14,0.00,0.00,1243.64,825776.96,0.00,0.00,0.00),('1','148','769','257641',4904058,'2183','327',597525.20,598529.10,0.00,0.00,1003.90,666589.60,0.00,0.00,0.00),('1','148','769','257642',4904059,'2140','327',539447.14,539447.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257642',4904060,'2183','327',598529.10,600847.61,0.00,0.00,2318.51,1539490.64,0.00,0.00,0.00),('1','148','769','257643',4904061,'2140','327',539447.14,539447.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257643',4904062,'2183','327',600847.61,600976.62,0.00,0.00,129.01,85662.64,0.00,0.00,0.00),('1','148','769','257644',4904063,'2140','327',539447.14,539889.98,0.00,0.00,442.84,294045.76,0.00,0.00,0.00),('1','148','769','257644',4904064,'2183','327',600976.62,601337.57,0.00,0.00,360.95,239670.80,0.00,0.00,0.00),('1','148','769','257645',4904065,'2140','327',539889.98,540740.56,0.00,0.00,850.58,564785.12,0.00,0.00,0.00),('1','148','769','257645',4904066,'2183','327',601337.57,601956.30,0.00,0.00,618.73,410836.72,0.00,0.00,0.00),('1','148','769','257646',4904067,'2140','327',540740.56,541260.74,0.00,0.00,520.18,345399.52,0.00,0.00,0.00),('1','148','769','257646',4904068,'2183','327',601956.30,602990.87,0.00,0.00,1034.57,686954.48,0.00,0.00,0.00),('1','148','769','257647',4904069,'2140','327',541260.74,541260.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257647',4904070,'2183','327',602990.87,603099.45,0.00,0.00,108.58,72097.12,0.00,0.00,0.00),('1','148','769','257648',4904071,'2140','327',541260.74,541260.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257648',4904072,'2183','327',603099.45,603099.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257649',4904073,'2140','327',541260.74,541260.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257649',4904074,'2183','327',603099.45,603397.16,0.00,0.00,297.71,197679.44,0.00,0.00,0.00),('1','148','769','257650',4904075,'2140','327',541260.74,541796.51,0.00,0.00,535.77,355751.28,0.00,0.00,0.00),('1','148','769','257650',4904076,'2183','327',603397.16,604345.91,0.00,0.00,948.75,629970.00,0.00,0.00,0.00),('1','148','769','257651',4904077,'2140','327',541796.51,542475.20,0.00,0.00,678.69,450650.16,0.00,0.00,0.00),('1','148','769','257651',4904078,'2183','327',604345.91,605846.29,0.00,0.00,1500.38,996588.32,0.00,0.00,0.00),('1','148','769','257652',4904079,'2140','327',542475.20,542534.54,0.00,0.00,59.34,39401.76,0.00,0.00,0.00),('1','148','769','257652',4904080,'2183','327',605846.29,605926.88,0.00,0.00,80.59,53511.76,0.00,0.00,0.00),('1','148','769','257653',4904081,'2140','327',542534.54,542785.21,0.00,0.00,250.67,170438.80,0.00,0.00,0.00),('1','148','769','257653',4904082,'2183','327',605926.88,605984.27,0.00,0.00,57.39,39025.20,0.00,0.00,0.00),('1','148','769','257654',4904083,'2140','327',542785.21,542785.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257654',4904084,'2183','327',605984.27,605984.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257655',4904085,'2140','327',542785.21,542891.98,0.00,0.00,106.77,72603.60,0.00,0.00,0.00),('1','148','769','257655',4904086,'2183','327',605984.27,606926.49,0.00,0.00,942.22,640709.60,0.00,0.00,0.00),('1','148','769','257656',4904087,'2140','327',542891.98,542969.33,0.00,0.00,77.35,52598.00,0.00,0.00,0.00),('1','148','769','257656',4904088,'2183','327',606926.49,609315.99,0.00,0.00,2389.50,1624860.00,0.00,0.00,0.00),('1','148','769','257657',4904089,'2140','327',542969.33,542986.39,0.00,0.00,17.06,11600.80,0.00,0.00,0.00),('1','148','769','257657',4904090,'2183','327',609315.99,610109.92,0.00,0.00,793.93,539872.40,0.00,0.00,0.00),('1','148','769','257658',4904091,'2140','327',542986.39,543142.23,0.00,0.00,155.84,105971.20,0.00,0.00,0.00),('1','148','769','257658',4904092,'2183','327',610109.92,610953.56,0.00,0.00,843.64,573675.20,0.00,0.00,0.00),('1','148','769','257659',4904093,'2140','327',543142.23,543757.55,0.00,0.00,615.32,418417.60,0.00,0.00,0.00),('1','148','769','257659',4904094,'2183','327',610953.56,613135.31,0.00,0.00,2181.75,1483590.00,0.00,0.00,0.00),('1','148','769','257660',4904095,'2140','327',543757.55,544471.43,0.00,0.00,713.88,485438.40,0.00,0.00,0.00),('1','148','769','257660',4904096,'2183','327',613135.31,613946.64,0.00,0.00,811.33,551704.40,0.00,0.00,0.00),('1','148','769','257661',4904097,'2140','327',544471.43,545031.78,0.00,0.00,560.35,381038.00,0.00,0.00,0.00),('1','148','769','257661',4904098,'2183','327',613946.64,615295.73,0.00,0.00,1349.09,917381.20,0.00,0.00,0.00),('1','148','769','257662',4904099,'2140','327',545031.78,545809.37,0.00,0.00,777.59,562444.80,0.00,0.00,0.00),('1','148','769','257662',4904100,'2183','327',615295.73,616038.62,0.00,0.00,742.89,534880.80,0.00,0.00,0.00),('1','148','769','257663',4904101,'2140','327',545809.37,546160.62,0.00,0.00,351.25,252900.00,0.00,0.00,0.00),('1','148','769','257663',4904102,'2183','327',616038.62,616883.27,0.00,0.00,844.65,608148.00,0.00,0.00,0.00),('1','148','769','257664',4904103,'2140','327',546160.62,546572.90,0.00,0.00,412.28,296841.60,0.00,0.00,0.00),('1','148','769','257664',4904104,'2183','327',616883.27,618687.93,0.00,0.00,1804.66,1299355.20,0.00,0.00,0.00),('1','148','769','257665',4904105,'2140','327',546572.90,546842.48,0.00,0.00,269.58,194097.60,0.00,0.00,0.00),('1','148','769','257665',4904106,'2183','327',618687.93,619571.86,0.00,0.00,883.93,636429.60,0.00,0.00,0.00),('1','148','769','257666',4904107,'2140','327',546842.48,547237.46,0.00,0.00,394.98,284385.60,0.00,0.00,0.00),('1','148','769','257666',4904108,'2183','327',619571.86,619948.30,0.00,0.00,376.44,271036.80,0.00,0.00,0.00),('1','148','769','257667',4904109,'2140','327',547237.46,547627.59,0.00,0.00,390.13,289173.60,0.00,0.00,0.00),('1','148','769','257667',4904110,'2183','327',619948.30,621367.83,0.00,0.00,1419.53,1022061.60,0.00,0.00,0.00),('1','148','769','257668',4904111,'2140','327',547627.59,548339.22,0.00,0.00,711.63,540838.80,0.00,0.00,0.00),('1','148','769','257668',4904112,'2183','327',621367.83,622641.20,0.00,0.00,1273.37,967025.20,0.00,0.00,0.00),('1','148','769','257669',4904113,'2140','327',548339.22,548357.78,0.00,0.00,18.56,14105.60,0.00,0.00,0.00),('1','148','769','257669',4904114,'2183','327',622641.20,622647.48,0.00,0.00,6.28,4772.80,0.00,0.00,0.00),('1','148','769','257670',4904115,'2140','327',548357.78,548357.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257670',4904116,'2183','327',622647.48,622647.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257671',4904117,'2140','327',548357.78,549325.76,0.00,0.00,967.98,735664.80,0.00,0.00,0.00),('1','148','769','257671',4904118,'2183','327',622647.48,623370.74,0.00,0.00,723.26,549677.60,0.00,0.00,0.00),('1','148','769','257672',4904119,'2140','327',549325.76,549752.06,0.00,0.00,426.30,323988.00,0.00,0.00,0.00),('1','148','769','257672',4904120,'2183','327',623370.74,625268.00,0.00,0.00,1897.26,1441917.60,0.00,0.00,0.00),('1','148','769','257673',4904121,'2140','327',549752.06,549752.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257673',4904122,'2183','327',625268.00,626206.91,0.00,0.00,938.91,714811.60,0.00,0.00,0.00),('1','148','769','257674',4904123,'2140','327',549752.06,549752.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257674',4904124,'2183','327',626206.91,626206.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257675',4904125,'2140','327',549752.06,549752.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257675',4904126,'2183','327',626206.91,627665.34,0.00,0.00,1458.43,1108406.80,0.00,0.00,0.00),('1','148','769','257676',4904127,'2140','327',549752.06,549770.22,0.00,0.00,18.16,13801.60,0.00,0.00,0.00),('1','148','769','257676',4904128,'2183','327',627665.34,629477.27,0.00,0.00,1811.93,1377066.80,0.00,0.00,0.00),('1','148','769','257677',4904129,'2140','327',549770.22,550398.07,0.00,0.00,627.85,478406.00,0.00,0.00,0.00),('1','148','769','257677',4904130,'2183','327',629477.27,630835.87,0.00,0.00,1358.60,1032536.00,0.00,0.00,0.00),('1','148','769','257678',4904131,'2140','327',550398.07,551322.86,0.00,0.00,924.79,702840.40,0.00,0.00,0.00),('1','148','769','257678',4904132,'2183','327',630835.87,632094.74,0.00,0.00,1258.87,956741.20,0.00,0.00,0.00),('1','148','769','257679',4904133,'2140','327',551322.86,552551.90,0.00,0.00,1229.04,934070.40,0.00,0.00,0.00),('1','148','769','257679',4904134,'2183','327',632094.74,633658.08,0.00,0.00,1563.34,1188138.40,0.00,0.00,0.00),('1','148','769','257680',4904135,'2140','327',552551.90,552710.17,0.00,0.00,158.27,120285.20,0.00,0.00,0.00),('1','148','769','257680',4904136,'2183','327',633658.08,633730.06,0.00,0.00,71.98,54704.80,0.00,0.00,0.00),('1','148','769','257681',4904137,'2140','327',552710.17,553400.42,0.00,0.00,690.25,524590.00,0.00,0.00,0.00),('1','148','769','257681',4904138,'2183','327',633730.06,634532.69,0.00,0.00,802.63,609998.80,0.00,0.00,0.00),('1','148','769','257682',4904139,'2140','327',553400.42,554294.89,0.00,0.00,894.47,682037.20,0.00,0.00,0.00),('1','148','769','257682',4904140,'2183','327',634532.69,635960.70,0.00,0.00,1428.01,1085287.60,0.00,0.00,0.00),('1','148','769','257683',4904141,'2140','327',554294.89,554294.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257683',4904142,'2183','327',635960.70,636851.03,0.00,0.00,890.33,676650.80,0.00,0.00,0.00),('1','148','769','257684',4904143,'2140','327',554294.89,554294.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257684',4904144,'2183','327',636851.03,637397.32,0.00,0.00,546.29,415180.40,0.00,0.00,0.00),('1','148','769','257685',4904145,'2140','327',554294.89,554740.64,0.00,0.00,445.75,338770.00,0.00,0.00,0.00),('1','148','769','257685',4904146,'2183','327',637397.32,639649.73,0.00,0.00,2252.41,1711831.60,0.00,0.00,0.00),('1','148','769','257686',4904147,'2140','327',554740.64,555262.12,0.00,0.00,521.48,396324.80,0.00,0.00,0.00),('1','148','769','257686',4904148,'2183','327',639649.73,641152.39,0.00,0.00,1502.66,1142021.60,0.00,0.00,0.00),('1','148','769','257687',4904149,'2140','327',555262.12,555262.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257687',4904150,'2183','327',641152.39,641412.29,0.00,0.00,259.90,197524.00,0.00,0.00,0.00),('1','148','769','257688',4904151,'2140','327',555262.12,555894.92,0.00,0.00,632.80,480928.00,0.00,0.00,0.00),('1','148','769','257688',4904152,'2183','327',641412.29,643532.62,0.00,0.00,2120.33,1611450.80,0.00,0.00,0.00),('1','148','769','257689',4904153,'2140','327',555894.92,556285.06,0.00,0.00,390.14,296506.40,0.00,0.00,0.00),('1','148','769','257689',4904154,'2183','327',643532.62,644905.22,0.00,0.00,1372.60,1043176.00,0.00,0.00,0.00),('1','148','769','257690',4904155,'2140','327',556285.06,556482.17,0.00,0.00,197.11,149803.60,0.00,0.00,0.00),('1','148','769','257690',4904156,'2183','327',644905.22,645342.24,0.00,0.00,437.02,332135.20,0.00,0.00,0.00),('1','148','769','257691',4904157,'2140','327',556482.17,556484.80,0.00,0.00,2.63,1998.80,0.00,0.00,0.00),('1','148','769','257691',4904158,'2183','327',645342.24,646597.48,0.00,0.00,1255.24,953982.40,0.00,0.00,0.00),('1','148','769','257692',4904159,'2140','327',556484.80,556980.99,0.00,0.00,496.19,377104.40,0.00,0.00,0.00),('1','148','769','257692',4904160,'2183','327',646597.48,648036.16,0.00,0.00,1438.68,1093396.80,0.00,0.00,0.00),('1','148','769','257693',4904161,'2140','327',556980.99,557357.61,0.00,0.00,376.62,286231.20,0.00,0.00,0.00),('1','148','769','257693',4904162,'2183','327',648036.16,649391.08,0.00,0.00,1354.92,1029739.20,0.00,0.00,0.00),('1','148','769','257694',4904163,'2140','327',557357.61,557363.66,0.00,0.00,6.05,4598.00,0.00,0.00,0.00),('1','148','769','257694',4904164,'2183','327',649391.08,649723.66,0.00,0.00,332.58,252760.80,0.00,0.00,0.00),('1','148','769','257695',4904165,'2140','327',557363.66,557691.90,0.00,0.00,328.24,249462.40,0.00,0.00,0.00),('1','148','769','257695',4904166,'2183','327',649723.66,650338.85,0.00,0.00,615.19,467544.40,0.00,0.00,0.00),('1','148','769','257696',4904167,'2140','327',557691.90,557691.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257696',4904168,'2183','327',650338.85,652329.47,0.00,0.00,1990.62,1512871.20,0.00,0.00,0.00),('1','148','769','257697',4904169,'2140','327',557691.90,557704.40,0.00,0.00,12.50,9500.00,0.00,0.00,0.00),('1','148','769','257697',4904170,'2183','327',652329.47,654442.52,0.00,0.00,2113.05,1605918.00,0.00,0.00,0.00),('1','148','769','257698',4904171,'2140','327',557704.40,557716.90,0.00,0.00,12.50,9500.00,0.00,0.00,0.00),('1','148','769','257698',4904172,'2183','327',654442.52,656091.92,0.00,0.00,1649.40,1253544.00,0.00,0.00,0.00),('1','148','769','257699',4904173,'2140','327',557716.90,557741.90,0.00,0.00,25.00,19000.00,0.00,0.00,0.00),('1','148','769','257699',4904174,'2183','327',656091.92,657694.87,0.00,0.00,1602.95,1218242.00,0.00,0.00,0.00),('1','148','769','257700',4904175,'2140','327',557741.90,557741.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257700',4904176,'2183','327',657694.87,659776.76,0.00,0.00,2081.89,1582236.40,0.00,0.00,0.00),('1','148','769','257701',4904177,'2140','327',557741.90,558257.02,0.00,0.00,515.12,391491.20,0.00,0.00,0.00),('1','148','769','257701',4904178,'2183','327',659776.76,660909.24,0.00,0.00,1132.48,860684.80,0.00,0.00,0.00),('1','148','769','257702',4904179,'2140','327',558257.02,558257.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257702',4904180,'2183','327',660909.24,662503.11,0.00,0.00,1593.87,1211341.20,0.00,0.00,0.00),('1','148','769','257703',4904181,'2140','327',558257.02,558265.31,0.00,0.00,8.29,6300.40,0.00,0.00,0.00),('1','148','769','257703',4904182,'2183','327',662503.11,664730.89,0.00,0.00,2227.78,1693112.80,0.00,0.00,0.00),('1','148','769','257704',4904183,'2140','327',558265.31,558265.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257704',4904184,'2183','327',664730.89,666904.20,0.00,0.00,2173.31,1651715.60,0.00,0.00,0.00),('1','148','769','257705',4904185,'2140','327',558265.31,558933.99,0.00,0.00,668.68,508196.80,0.00,0.00,0.00),('1','148','769','257705',4904186,'2183','327',666904.20,668606.94,0.00,0.00,1702.74,1294082.40,0.00,0.00,0.00),('1','148','769','257706',4904187,'2140','327',558933.99,559236.60,0.00,0.00,302.61,229983.60,0.00,0.00,0.00),('1','148','769','257706',4904188,'2183','327',668606.94,669173.77,0.00,0.00,566.83,430790.80,0.00,0.00,0.00),('1','148','769','257707',4904189,'2140','327',559236.60,559236.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257707',4904190,'2183','327',669173.77,669719.32,0.00,0.00,545.55,414618.00,0.00,0.00,0.00),('1','148','769','257708',4904191,'2140','327',559236.60,559818.91,0.00,0.00,582.31,442555.60,0.00,0.00,0.00),('1','148','769','257708',4904192,'2183','327',669719.32,670752.80,0.00,0.00,1033.48,785444.80,0.00,0.00,0.00),('1','148','769','257709',4904193,'2140','327',559818.91,560835.25,0.00,0.00,1016.34,772418.40,0.00,0.00,0.00),('1','148','769','257709',4904194,'2183','327',670752.80,671459.50,0.00,0.00,706.70,537092.00,0.00,0.00,0.00),('1','148','769','257710',4904195,'2140','327',560835.25,561480.71,0.00,0.00,645.46,490549.60,0.00,0.00,0.00),('1','148','769','257710',4904196,'2183','327',671459.50,671828.02,0.00,0.00,368.52,280075.20,0.00,0.00,0.00),('1','148','769','257711',4904197,'2140','327',561480.71,561768.09,0.00,0.00,287.38,218408.80,0.00,0.00,0.00),('1','148','769','257711',4904198,'2183','327',671828.02,672237.89,0.00,0.00,409.87,311501.20,0.00,0.00,0.00),('1','148','769','257712',4904199,'2140','327',561768.09,562047.11,0.00,0.00,279.02,212055.20,0.00,0.00,0.00),('1','148','769','257712',4904200,'2183','327',672237.89,673565.07,0.00,0.00,1327.18,1008656.80,0.00,0.00,0.00),('1','148','769','257713',4904201,'2140','327',562047.11,563028.76,0.00,0.00,981.65,746054.00,0.00,0.00,0.00),('1','148','769','257713',4904202,'2183','327',673565.07,674425.67,0.00,0.00,860.60,654056.00,0.00,0.00,0.00),('1','148','769','257714',4904203,'2140','327',563028.76,563705.62,0.00,0.00,676.86,514413.60,0.00,0.00,0.00),('1','148','769','257714',4904204,'2183','327',674425.67,675050.77,0.00,0.00,625.10,475076.00,0.00,0.00,0.00),('1','148','769','257715',4904205,'2140','327',563705.62,564249.04,0.00,0.00,543.42,412999.20,0.00,0.00,0.00),('1','148','769','257715',4904206,'2183','327',675050.77,676279.46,0.00,0.00,1228.69,933804.40,0.00,0.00,0.00),('1','148','769','257716',4904207,'2140','327',564249.04,564706.31,0.00,0.00,457.27,347525.20,0.00,0.00,0.00),('1','148','769','257716',4904208,'2183','327',676279.46,677623.19,0.00,0.00,1343.73,1021234.80,0.00,0.00,0.00),('1','148','769','257717',4904209,'2140','327',564706.31,565514.20,0.00,0.00,807.89,613996.40,0.00,0.00,0.00),('1','148','769','257717',4904210,'2183','327',677623.19,678438.76,0.00,0.00,815.57,619833.20,0.00,0.00,0.00),('1','148','769','257718',4904211,'2140','327',565514.20,565631.26,0.00,0.00,117.06,88965.60,0.00,0.00,0.00),('1','148','769','257718',4904212,'2183','327',678438.76,679950.04,0.00,0.00,1511.28,1148572.80,0.00,0.00,0.00),('1','148','769','257719',4904213,'2140','327',565631.26,565637.05,0.00,0.00,5.79,4400.40,0.00,0.00,0.00),('1','148','769','257719',4904214,'2183','327',679950.04,681969.47,0.00,0.00,2019.43,1534766.80,0.00,0.00,0.00),('1','148','769','257720',4904215,'2140','327',565637.05,565647.05,0.00,0.00,10.00,7600.00,0.00,0.00,0.00),('1','148','769','257720',4904216,'2183','327',681969.47,682553.47,0.00,0.00,584.00,443840.00,0.00,0.00,0.00),('1','148','769','257721',4904217,'2140','327',565647.05,565863.11,0.00,0.00,216.06,164205.60,0.00,0.00,0.00),('1','148','769','257721',4904218,'2183','327',682553.47,682704.81,0.00,0.00,151.34,115018.40,0.00,0.00,0.00),('1','148','769','257722',4904219,'2140','327',565863.11,566463.35,0.00,0.00,600.24,456182.40,0.00,0.00,0.00),('1','148','769','257722',4904220,'2183','327',682704.81,683928.60,0.00,0.00,1223.79,930080.40,0.00,0.00,0.00),('1','148','769','257723',4904221,'2140','327',566463.35,566899.29,0.00,0.00,435.94,331314.40,0.00,0.00,0.00),('1','148','769','257723',4904222,'2183','327',683928.60,684976.56,0.00,0.00,1047.96,796449.60,0.00,0.00,0.00),('1','148','769','257724',4904223,'2140','327',566899.29,567474.91,0.00,0.00,575.62,428261.28,0.00,0.00,0.00),('1','148','769','257724',4904224,'2183','327',684976.56,685986.58,0.00,0.00,1010.02,751454.88,0.00,0.00,0.00),('1','148','769','257725',4904225,'2140','327',567474.91,567863.53,0.00,0.00,388.62,289133.28,0.00,0.00,0.00),('1','148','769','257725',4904226,'2183','327',685986.58,688131.87,0.00,0.00,2145.29,1596095.76,0.00,0.00,0.00),('1','148','769','257726',4904227,'2140','327',567863.53,568052.95,0.00,0.00,189.42,140928.48,0.00,0.00,0.00),('1','148','769','257726',4904228,'2183','327',688131.87,688998.85,0.00,0.00,866.98,645033.12,0.00,0.00,0.00),('1','148','769','257727',4904229,'2140','327',568052.95,568285.27,0.00,0.00,232.32,172846.08,0.00,0.00,0.00),('1','148','769','257727',4904230,'2183','327',688998.85,690330.07,0.00,0.00,1331.22,990427.68,0.00,0.00,0.00),('1','148','769','257728',4904231,'2140','327',568285.27,568438.96,0.00,0.00,153.69,114345.36,0.00,0.00,0.00),('1','148','769','257728',4904232,'2183','327',690330.07,690445.74,0.00,0.00,115.67,86058.48,0.00,0.00,0.00),('1','148','769','257729',4904233,'2140','327',568438.96,568486.20,0.00,0.00,47.24,35146.56,0.00,0.00,0.00),('1','148','769','257729',4904234,'2183','327',690445.74,691314.43,0.00,0.00,868.69,646305.36,0.00,0.00,0.00),('1','148','769','257730',4904235,'2140','327',568486.20,568978.78,0.00,0.00,492.58,366479.52,0.00,0.00,0.00),('1','148','769','257730',4904236,'2183','327',691314.43,692464.75,0.00,0.00,1150.32,855838.08,0.00,0.00,0.00),('1','148','769','257731',4904237,'2140','327',568978.78,568978.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257731',4904238,'2183','327',692464.75,694034.00,0.00,0.00,1569.25,1167522.00,0.00,0.00,0.00),('1','148','769','257732',4904239,'2140','327',568978.78,568988.19,0.00,0.00,9.41,7001.04,0.00,0.00,0.00),('1','148','769','257732',4904240,'2183','327',694034.00,694674.24,0.00,0.00,640.24,476338.56,0.00,0.00,0.00),('1','148','769','257733',4904241,'2140','327',568988.19,568988.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257733',4904242,'2183','327',694674.24,694674.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257734',4904243,'2140','327',568988.19,570043.70,0.00,0.00,1055.51,785299.44,0.00,0.00,0.00),('1','148','769','257734',4904244,'2183','327',694674.24,696170.69,0.00,0.00,1496.45,1113358.80,0.00,0.00,0.00),('1','148','769','257735',4904245,'2140','327',570043.70,571178.31,0.00,0.00,1134.61,844149.84,0.00,0.00,0.00),('1','148','769','257735',4904246,'2183','327',696170.69,697113.49,0.00,0.00,942.80,701443.20,0.00,0.00,0.00),('1','148','769','257736',4904247,'2140','327',571178.31,571249.86,0.00,0.00,71.55,53233.20,0.00,0.00,0.00),('1','148','769','257736',4904248,'2183','327',697113.49,697677.35,0.00,0.00,563.86,419511.84,0.00,0.00,0.00),('1','148','769','257737',4904249,'2140','327',571249.86,571729.24,0.00,0.00,479.38,356658.72,0.00,0.00,0.00),('1','148','769','257737',4904250,'2183','327',697677.35,697886.94,0.00,0.00,209.59,155934.96,0.00,0.00,0.00),('1','148','769','257738',4904251,'2140','327',571729.24,572599.32,0.00,0.00,870.08,647339.52,0.00,0.00,0.00),('1','148','769','257738',4904252,'2183','327',697886.94,699043.90,0.00,0.00,1156.96,860778.24,0.00,0.00,0.00),('1','148','769','257739',4904253,'2140','327',572599.32,573508.91,0.00,0.00,909.59,676734.96,0.00,0.00,0.00),('1','148','769','257739',4904254,'2183','327',699043.90,700245.39,0.00,0.00,1201.49,893908.56,0.00,0.00,0.00),('1','148','769','257740',4904255,'2140','327',573508.91,573842.55,0.00,0.00,333.64,248228.16,0.00,0.00,0.00),('1','148','769','257740',4904256,'2183','327',700245.39,702127.73,0.00,0.00,1882.34,1400460.96,0.00,0.00,0.00),('1','148','769','257741',4904257,'2140','327',573842.55,574771.79,0.00,0.00,929.24,691354.56,0.00,0.00,0.00),('1','148','769','257741',4904258,'2183','327',702127.73,702449.06,0.00,0.00,321.33,239069.52,0.00,0.00,0.00),('1','148','769','257742',4904259,'2140','327',574771.79,574800.96,0.00,0.00,29.17,21702.48,0.00,0.00,0.00),('1','148','769','257742',4904260,'2183','327',702449.06,702593.72,0.00,0.00,144.66,107627.04,0.00,0.00,0.00),('1','148','769','257743',4904261,'2140','327',574800.96,574891.35,0.00,0.00,90.39,68696.40,0.00,0.00,0.00),('1','148','769','257743',4904262,'2183','327',702593.72,702645.04,0.00,0.00,51.32,39003.20,0.00,0.00,0.00),('1','148','769','257744',4904263,'2140','327',574891.35,575333.02,0.00,0.00,441.67,335669.20,0.00,0.00,0.00),('1','148','769','257744',4904264,'2183','327',702645.04,702850.11,0.00,0.00,205.07,155853.20,0.00,0.00,0.00),('1','148','769','257745',4904265,'2140','327',575333.02,576058.74,0.00,0.00,725.72,551547.20,0.00,0.00,0.00),('1','148','769','257745',4904266,'2183','327',702850.11,703570.90,0.00,0.00,720.79,547800.40,0.00,0.00,0.00),('1','148','769','257746',4904267,'2140','327',576058.74,576500.19,0.00,0.00,441.45,335502.00,0.00,0.00,0.00),('1','148','769','257746',4904268,'2183','327',703570.90,703893.65,0.00,0.00,322.75,245290.00,0.00,0.00,0.00),('1','148','769','257747',4904269,'2140','327',576500.19,576651.75,0.00,0.00,151.56,115185.60,0.00,0.00,0.00),('1','148','769','257747',4904270,'2183','327',703893.65,704076.99,0.00,0.00,183.34,139338.40,0.00,0.00,0.00),('1','148','769','257748',4904271,'2140','327',576651.75,577023.40,0.00,0.00,371.65,282454.00,0.00,0.00,0.00),('1','148','769','257748',4904272,'2183','327',704076.99,705078.37,0.00,0.00,1001.38,761048.80,0.00,0.00,0.00),('1','148','769','257749',4904273,'2140','327',577023.40,577023.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257749',4904274,'2183','327',705078.37,705654.12,0.00,0.00,575.75,437570.00,0.00,0.00,0.00),('1','148','769','257750',4904275,'2140','327',577023.40,577345.34,0.00,0.00,321.94,244674.40,0.00,0.00,0.00),('1','148','769','257750',4904276,'2183','327',705654.12,705958.98,0.00,0.00,304.86,231693.60,0.00,0.00,0.00),('1','148','769','257751',4904277,'2140','327',577345.34,577790.71,0.00,0.00,445.37,331355.28,0.00,0.00,0.00),('1','148','769','257751',4904278,'2183','327',705958.98,707556.27,0.00,0.00,1597.29,1188383.76,0.00,0.00,0.00),('1','148','769','257752',4904279,'2140','327',577790.71,578191.65,0.00,0.00,400.94,298299.36,0.00,0.00,0.00),('1','148','769','257752',4904280,'2183','327',707556.27,709098.24,0.00,0.00,1541.97,1147225.68,0.00,0.00,0.00),('1','148','769','257753',4904281,'2140','327',578191.65,578441.11,0.00,0.00,249.46,185598.24,0.00,0.00,0.00),('1','148','769','257753',4904282,'2183','327',709098.24,709442.86,0.00,0.00,344.62,256397.28,0.00,0.00,0.00),('1','148','769','257754',4904283,'2140','327',578441.11,578489.84,0.00,0.00,48.73,36255.12,0.00,0.00,0.00),('1','148','769','257754',4904284,'2183','327',709442.86,710316.69,0.00,0.00,873.83,650129.52,0.00,0.00,0.00),('1','148','769','257755',4904285,'2140','327',578489.84,578489.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257755',4904286,'2183','327',710316.69,711916.62,0.00,0.00,1599.93,1190347.92,0.00,0.00,0.00),('1','148','769','257756',4904287,'2140','327',578489.84,578908.39,0.00,0.00,418.55,311401.20,0.00,0.00,0.00),('1','148','769','257756',4904288,'2183','327',711916.62,713408.03,0.00,0.00,1491.41,1109609.04,0.00,0.00,0.00),('1','148','769','257757',4904289,'2140','327',578908.39,579166.05,0.00,0.00,257.66,191699.04,0.00,0.00,0.00),('1','148','769','257757',4904290,'2183','327',713408.03,713660.71,0.00,0.00,252.68,187993.92,0.00,0.00,0.00),('1','148','769','257758',4904291,'2140','327',579166.05,579166.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257758',4904292,'2183','327',713660.71,713660.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257759',4904293,'2140','327',579166.05,579168.74,0.00,0.00,2.69,2001.36,0.00,0.00,0.00),('1','148','769','257759',4904294,'2183','327',713660.71,714594.35,0.00,0.00,933.64,694628.16,0.00,0.00,0.00),('1','148','769','257760',4904295,'2140','327',579168.74,579602.50,0.00,0.00,433.76,322717.44,0.00,0.00,0.00),('1','148','769','257760',4904296,'2183','327',714594.35,715874.95,0.00,0.00,1280.60,954022.40,0.00,0.00,0.00),('1','148','769','257761',4904297,'2140','327',579602.50,580178.09,0.00,0.00,575.59,428238.96,0.00,0.00,0.00),('1','148','769','257761',4904298,'2183','327',715874.95,716962.77,0.00,0.00,1087.82,809338.08,0.00,0.00,0.00),('1','148','769','257762',4904299,'2140','327',580178.09,580330.84,0.00,0.00,152.75,113646.00,0.00,0.00,0.00),('1','148','769','257762',4904300,'2183','327',716962.77,717230.25,0.00,0.00,267.48,199005.12,0.00,0.00,0.00),('1','148','769','257763',4904301,'2140','327',580330.84,580817.33,0.00,0.00,486.49,361948.56,0.00,0.00,0.00),('1','148','769','257763',4904302,'2183','327',717230.25,717516.87,0.00,0.00,286.62,213245.28,0.00,0.00,0.00),('1','148','769','257764',4904303,'2140','327',580817.33,581436.16,0.00,0.00,618.83,460409.52,0.00,0.00,0.00),('1','148','769','257764',4904304,'2183','327',717516.87,718525.30,0.00,0.00,1008.43,750271.92,0.00,0.00,0.00),('1','148','769','257765',4904305,'2140','327',581436.16,582024.68,0.00,0.00,588.52,437858.88,0.00,0.00,0.00),('1','148','769','257765',4904306,'2183','327',718525.30,720350.45,0.00,0.00,1825.15,1357911.60,0.00,0.00,0.00),('1','148','769','257766',4904307,'2140','327',582024.68,582037.18,0.00,0.00,12.50,9300.00,0.00,0.00,0.00),('1','148','769','257766',4904308,'2183','327',720350.45,720426.08,0.00,0.00,75.63,56268.72,0.00,0.00,0.00),('1','148','769','257767',4904309,'2140','327',582037.18,582377.32,0.00,0.00,340.14,253064.16,0.00,0.00,0.00),('1','148','769','257767',4904310,'2183','327',720426.08,721207.12,0.00,0.00,781.04,581093.76,0.00,0.00,0.00),('1','148','769','257768',4904311,'2140','327',582377.32,583189.68,0.00,0.00,812.36,604395.84,0.00,0.00,0.00),('1','148','769','257768',4904312,'2183','327',721207.12,723314.57,0.00,0.00,2107.45,1567942.80,0.00,0.00,0.00),('1','148','769','257769',4904313,'2140','327',583189.68,583604.37,0.00,0.00,414.69,308529.36,0.00,0.00,0.00),('1','148','769','257769',4904314,'2183','327',723314.57,723667.36,0.00,0.00,352.79,262475.76,0.00,0.00,0.00),('1','148','769','257770',4904315,'2140','327',583604.37,583930.01,0.00,0.00,325.64,242276.16,0.00,0.00,0.00),('1','148','769','257770',4904316,'2183','327',723667.36,724038.56,0.00,0.00,371.20,276172.80,0.00,0.00,0.00),('1','148','769','257771',4904317,'2140','327',583930.01,584582.36,0.00,0.00,652.35,485348.40,0.00,0.00,0.00),('1','148','769','257771',4904318,'2183','327',724038.56,725205.17,0.00,0.00,1166.61,867957.84,0.00,0.00,0.00),('1','148','769','257772',4904319,'2140','327',584582.36,585131.42,0.00,0.00,549.06,408500.64,0.00,0.00,0.00),('1','148','769','257772',4904320,'2183','327',725205.17,726169.57,0.00,0.00,964.40,717513.60,0.00,0.00,0.00),('1','148','769','257773',4904321,'2140','327',585131.42,585475.61,0.00,0.00,344.19,256077.36,0.00,0.00,0.00),('1','148','769','257773',4904322,'2183','327',726169.57,727085.20,0.00,0.00,915.63,681228.72,0.00,0.00,0.00),('1','148','769','257774',4904323,'2140','327',585475.61,586228.54,0.00,0.00,752.93,560179.92,0.00,0.00,0.00),('1','148','769','257774',4904324,'2183','327',727085.20,728327.69,0.00,0.00,1242.49,925918.56,0.00,0.00,0.00),('1','148','769','257775',4904325,'2140','327',586228.54,586915.51,0.00,0.00,686.97,511105.68,0.00,0.00,0.00),('1','148','769','257775',4904326,'2183','327',728327.69,730664.89,0.00,0.00,2337.20,1738876.80,0.00,0.00,0.00),('1','148','769','257776',4904327,'2140','327',586915.51,586968.94,0.00,0.00,53.43,39751.92,0.00,0.00,0.00),('1','148','769','257776',4904328,'2183','327',730664.89,730690.64,0.00,0.00,25.75,19158.00,0.00,0.00,0.00),('1','148','769','257777',4904329,'2140','327',586968.94,587973.64,0.00,0.00,1004.70,747496.80,0.00,0.00,0.00),('1','148','769','257777',4904330,'2183','327',730690.64,731553.88,0.00,0.00,863.24,642250.56,0.00,0.00,0.00),('1','148','769','257778',4904331,'2140','327',587973.64,588463.47,0.00,0.00,489.83,364433.52,0.00,0.00,0.00),('1','148','769','257778',4904332,'2183','327',731553.88,732626.28,0.00,0.00,1072.40,797865.60,0.00,0.00,0.00),('1','148','769','257779',4904333,'2140','327',588463.47,588965.18,0.00,0.00,501.71,373272.24,0.00,0.00,0.00),('1','148','769','257779',4904334,'2183','327',732626.28,733620.73,0.00,0.00,994.45,739870.80,0.00,0.00,0.00),('1','148','769','257780',4904335,'2140','327',588965.18,589845.82,0.00,0.00,880.64,655196.16,0.00,0.00,0.00),('1','148','769','257780',4904336,'2183','327',733620.73,734597.59,0.00,0.00,976.86,726783.84,0.00,0.00,0.00),('1','148','769','257781',4904337,'2140','327',589845.82,590620.68,0.00,0.00,774.86,576495.84,0.00,0.00,0.00),('1','148','769','257781',4904338,'2183','327',734597.59,735659.81,0.00,0.00,1062.22,790291.68,0.00,0.00,0.00),('1','148','769','257782',4904339,'2140','327',590620.68,591151.83,0.00,0.00,531.15,395175.60,0.00,0.00,0.00),('1','148','769','257782',4904340,'2183','327',735659.81,736538.97,0.00,0.00,879.16,654095.04,0.00,0.00,0.00),('1','148','769','257783',4904341,'2140','327',591151.83,591981.37,0.00,0.00,829.54,617177.76,0.00,0.00,0.00),('1','148','769','257783',4904342,'2183','327',736538.97,737594.25,0.00,0.00,1055.28,785128.32,0.00,0.00,0.00),('1','148','769','257784',4904343,'2140','327',591981.37,592078.02,0.00,0.00,96.65,71907.60,0.00,0.00,0.00),('1','148','769','257784',4904344,'2183','327',737594.25,739058.06,0.00,0.00,1463.81,1089074.64,0.00,0.00,0.00),('1','148','769','257785',4904345,'2140','327',592078.02,592118.34,0.00,0.00,40.32,29998.08,0.00,0.00,0.00),('1','148','769','257785',4904346,'2183','327',739058.06,739058.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257786',4904347,'2140','327',592118.34,593006.42,0.00,0.00,888.08,660731.52,0.00,0.00,0.00),('1','148','769','257786',4904348,'2183','327',739058.06,740077.47,0.00,0.00,1019.41,758441.04,0.00,0.00,0.00),('1','148','769','257787',4904349,'2140','327',593006.42,593474.94,0.00,0.00,468.52,348578.88,0.00,0.00,0.00),('1','148','769','257787',4904350,'2183','327',740077.47,740317.07,0.00,0.00,239.60,178262.40,0.00,0.00,0.00),('1','148','769','257788',4904351,'2140','327',593474.94,594424.40,0.00,0.00,949.46,706398.24,0.00,0.00,0.00),('1','148','769','257788',4904352,'2183','327',740317.07,740802.91,0.00,0.00,485.84,361464.96,0.00,0.00,0.00),('1','148','769','257789',4904353,'2140','327',594424.40,594790.40,0.00,0.00,366.00,272304.00,0.00,0.00,0.00),('1','148','769','257789',4904354,'2183','327',740802.91,741026.78,0.00,0.00,223.87,166559.28,0.00,0.00,0.00),('1','148','769','257790',4904355,'2140','327',594790.40,594790.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257790',4904356,'2183','327',741026.78,741026.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257791',4904357,'2140','327',594790.40,595560.09,0.00,0.00,769.69,566491.84,0.00,0.00,0.00),('1','148','769','257791',4904358,'2183','327',741026.78,741407.59,0.00,0.00,380.81,280276.16,0.00,0.00,0.00),('1','148','769','257792',4904359,'2140','327',595560.09,596832.62,0.00,0.00,1272.53,936582.08,0.00,0.00,0.00),('1','148','769','257792',4904360,'2183','327',741407.59,742106.28,0.00,0.00,698.69,515499.84,0.00,0.00,0.00),('1','148','769','257793',4904361,'2140','327',596832.62,597900.04,0.00,0.00,1067.42,785621.12,0.00,0.00,0.00),('1','148','769','257793',4904362,'2183','327',742106.28,742561.23,0.00,0.00,454.95,334843.20,0.00,0.00,0.00),('1','148','769','257794',4904363,'2140','327',597900.04,598419.07,0.00,0.00,519.03,382006.08,0.00,0.00,0.00),('1','148','769','257794',4904364,'2183','327',742561.23,742944.02,0.00,0.00,382.79,281733.44,0.00,0.00,0.00),('1','148','769','257795',4904365,'2140','327',598419.07,599460.90,0.00,0.00,1041.83,766786.88,0.00,0.00,0.00),('1','148','769','257795',4904366,'2183','327',742944.02,743445.81,0.00,0.00,501.79,373581.44,0.00,0.00,0.00),('1','148','769','257796',4904367,'2140','327',599460.90,600804.01,0.00,0.00,1343.11,988528.96,0.00,0.00,0.00),('1','148','769','257796',4904368,'2183','327',743445.81,744298.74,0.00,0.00,852.93,627756.48,0.00,0.00,0.00),('1','148','769','257797',4904369,'2140','327',600804.01,600958.80,0.00,0.00,154.79,113925.44,0.00,0.00,0.00),('1','148','769','257797',4904370,'2183','327',744298.74,744622.47,0.00,0.00,323.73,238265.28,0.00,0.00,0.00),('1','148','769','257798',4904371,'2140','327',600958.80,601345.31,0.00,0.00,386.51,284471.36,0.00,0.00,0.00),('1','148','769','257798',4904372,'2183','327',744622.47,744763.45,0.00,0.00,140.98,103761.28,0.00,0.00,0.00),('1','148','769','257799',4904373,'2140','327',601345.31,602210.78,0.00,0.00,865.47,636985.92,0.00,0.00,0.00),('1','148','769','257799',4904374,'2183','327',744763.45,745560.39,0.00,0.00,796.94,586547.84,0.00,0.00,0.00),('1','148','769','257800',4904375,'2140','327',602210.78,602822.56,0.00,0.00,611.78,450270.08,0.00,0.00,0.00),('1','148','769','257800',4904376,'2183','327',745560.39,745881.03,0.00,0.00,320.64,235991.04,0.00,0.00,0.00),('1','148','769','257801',4904377,'2140','327',602822.56,603878.07,0.00,0.00,1055.51,776855.36,0.00,0.00,0.00),('1','148','769','257801',4904378,'2183','327',745881.03,746380.91,0.00,0.00,499.88,367911.68,0.00,0.00,0.00),('1','148','769','257802',4904379,'2140','327',603878.07,604180.36,0.00,0.00,302.29,222485.44,0.00,0.00,0.00),('1','148','769','257802',4904380,'2183','327',746380.91,746380.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257803',4904381,'2140','327',604180.36,604842.55,0.00,0.00,662.19,487371.84,0.00,0.00,0.00),('1','148','769','257803',4904382,'2183','327',746380.91,746710.31,0.00,0.00,329.40,242438.40,0.00,0.00,0.00),('1','148','769','257804',4904383,'2140','327',604842.55,605521.08,0.00,0.00,678.53,499398.08,0.00,0.00,0.00),('1','148','769','257804',4904384,'2183','327',746710.31,747064.11,0.00,0.00,353.80,260396.80,0.00,0.00,0.00),('1','148','769','257805',4904385,'2140','327',605521.08,606830.42,0.00,0.00,1309.34,963674.24,0.00,0.00,0.00),('1','148','769','257805',4904386,'2183','327',747064.11,747569.33,0.00,0.00,505.22,371841.92,0.00,0.00,0.00),('1','148','769','257806',4904387,'2140','327',606830.42,607027.17,0.00,0.00,196.75,144808.00,0.00,0.00,0.00),('1','148','769','257806',4904388,'2183','327',747569.33,747682.92,0.00,0.00,113.59,83602.24,0.00,0.00,0.00),('1','148','769','257807',4904389,'2140','327',607027.17,607174.24,0.00,0.00,147.07,108243.52,0.00,0.00,0.00),('1','148','769','257807',4904390,'2183','327',747682.92,747787.76,0.00,0.00,104.84,77162.24,0.00,0.00,0.00),('1','148','769','257808',4904391,'2140','327',607174.24,608898.08,0.00,0.00,1723.84,1268746.24,0.00,0.00,0.00),('1','148','769','257808',4904392,'2183','327',747787.76,748864.95,0.00,0.00,1077.19,792811.84,0.00,0.00,0.00),('1','148','769','257809',4904393,'2140','327',608898.08,610493.85,0.00,0.00,1595.77,1174486.72,0.00,0.00,0.00),('1','148','769','257809',4904394,'2183','327',748864.95,749403.78,0.00,0.00,538.83,396578.88,0.00,0.00,0.00),('1','148','769','257810',4904395,'2140','327',610493.85,610493.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257810',4904396,'2183','327',749403.78,749403.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257811',4904397,'2140','327',610493.85,611730.88,0.00,0.00,1237.03,910454.08,0.00,0.00,0.00),('1','148','769','257811',4904398,'2183','327',749403.78,750073.45,0.00,0.00,669.67,492877.12,0.00,0.00,0.00),('1','148','769','257812',4904399,'2140','327',611730.88,612598.03,0.00,0.00,867.15,638222.40,0.00,0.00,0.00),('1','148','769','257812',4904400,'2183','327',750073.45,750793.52,0.00,0.00,720.07,529971.52,0.00,0.00,0.00),('1','148','769','257813',4904401,'2140','327',612598.03,613326.68,0.00,0.00,728.65,536286.40,0.00,0.00,0.00),('1','148','769','257813',4904402,'2183','327',750793.52,751236.60,0.00,0.00,443.08,326106.88,0.00,0.00,0.00),('1','148','769','257814',4904403,'2140','327',613326.68,615637.39,0.00,0.00,2310.71,1700682.56,0.00,0.00,0.00),('1','148','769','257814',4904404,'2183','327',751236.60,753021.54,0.00,0.00,1784.94,1313715.84,0.00,0.00,0.00),('1','148','769','257815',4904405,'2140','327',615637.39,616321.95,0.00,0.00,684.56,503836.16,0.00,0.00,0.00),('1','148','769','257815',4904406,'2183','327',753021.54,753061.70,0.00,0.00,40.16,29557.76,0.00,0.00,0.00),('1','148','769','257816',4904407,'2140','327',616321.95,618276.34,0.00,0.00,1954.39,1493153.96,0.00,0.00,0.00),('1','148','769','257816',4904408,'2183','327',753061.70,753863.08,0.00,0.00,801.38,612254.32,0.00,0.00,0.00),('1','148','769','257817',4904409,'2140','327',618276.34,619411.39,0.00,0.00,1135.05,852357.72,0.00,0.00,0.00),('1','148','769','257817',4904410,'2183','327',753863.08,754166.85,0.00,0.00,303.77,229225.40,0.00,0.00,0.00),('1','148','769','257818',4904411,'2140','327',619411.39,621710.81,0.00,0.00,2299.42,1719966.16,0.00,0.00,0.00),('1','148','769','257818',4904412,'2183','327',754166.85,754810.77,0.00,0.00,643.92,481652.16,0.00,0.00,0.00),('1','148','769','257819',4904413,'2140','327',621710.81,623495.86,0.00,0.00,1785.05,1335217.40,0.00,0.00,0.00),('1','148','769','257819',4904414,'2183','327',754810.77,755317.85,0.00,0.00,507.08,379295.84,0.00,0.00,0.00),('1','148','769','257820',4904415,'2140','327',623495.86,623495.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257820',4904416,'2183','327',755317.85,755317.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257821',4904417,'2140','327',623495.86,625004.48,0.00,0.00,1508.62,1128447.76,0.00,0.00,0.00),('1','148','769','257821',4904418,'2183','327',755317.85,755979.69,0.00,0.00,661.84,495056.32,0.00,0.00,0.00),('1','148','769','257822',4904419,'2140','327',625004.48,627043.76,0.00,0.00,2039.28,1525381.44,0.00,0.00,0.00),('1','148','769','257822',4904420,'2183','327',755979.69,756745.28,0.00,0.00,765.59,572661.32,0.00,0.00,0.00),('1','148','769','257823',4904421,'2140','327',627043.76,628036.71,0.00,0.00,992.95,742726.60,0.00,0.00,0.00),('1','148','769','257823',4904422,'2183','327',756745.28,756949.25,0.00,0.00,203.97,152569.56,0.00,0.00,0.00),('1','148','769','257824',4904423,'2140','327',628036.71,629587.31,0.00,0.00,1550.60,1159848.80,0.00,0.00,0.00),('1','148','769','257824',4904424,'2183','327',756949.25,757247.66,0.00,0.00,298.41,223210.68,0.00,0.00,0.00),('1','148','769','257825',4904425,'2140','327',629587.31,630600.77,0.00,0.00,1013.46,770229.60,0.00,0.00,0.00),('1','148','769','257825',4904426,'2183','327',757247.66,757776.89,0.00,0.00,529.23,402214.80,0.00,0.00,0.00),('1','148','769','257826',4904427,'2140','327',630600.77,630600.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257826',4904428,'2183','327',757776.89,757776.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257827',4904429,'2140','327',630600.77,631853.12,0.00,0.00,1252.35,951786.00,0.00,0.00,0.00),('1','148','769','257827',4904430,'2183','327',757776.89,758224.14,0.00,0.00,447.25,339910.00,0.00,0.00,0.00),('1','148','769','257828',4904431,'2140','327',631853.12,633396.86,0.00,0.00,1543.74,1173242.40,0.00,0.00,0.00),('1','148','769','257828',4904432,'2183','327',758224.14,758548.98,0.00,0.00,324.84,246878.40,0.00,0.00,0.00),('1','148','769','257829',4904433,'2140','327',633396.86,634689.31,0.00,0.00,1292.45,982262.00,0.00,0.00,0.00),('1','148','769','257829',4904434,'2183','327',758548.98,758936.40,0.00,0.00,387.42,294439.20,0.00,0.00,0.00),('1','148','769','257830',4904435,'2140','327',634689.31,636426.42,0.00,0.00,1737.11,1320203.60,0.00,0.00,0.00),('1','148','769','257830',4904436,'2183','327',758936.40,759174.83,0.00,0.00,238.43,181206.80,0.00,0.00,0.00),('1','148','769','257831',4904437,'2140','327',636426.42,637417.19,0.00,0.00,990.77,752985.20,0.00,0.00,0.00),('1','148','769','257831',4904438,'2183','327',759174.83,759526.40,0.00,0.00,351.57,267193.20,0.00,0.00,0.00),('1','148','769','257832',4904439,'2140','327',637417.19,638819.29,0.00,0.00,1402.10,1065596.00,0.00,0.00,0.00),('1','148','769','257832',4904440,'2183','327',759526.40,759660.36,0.00,0.00,133.96,101809.60,0.00,0.00,0.00),('1','148','769','257833',4904441,'2140','327',638819.29,639103.72,0.00,0.00,284.43,226272.40,0.00,0.00,0.00),('1','148','769','257833',4904442,'2183','327',759660.36,759703.00,0.00,0.00,42.64,34112.00,0.00,0.00,0.00),('1','148','769','257834',4904443,'2140','327',639103.72,640445.56,0.00,0.00,1341.84,1073472.00,0.00,0.00,0.00),('1','148','769','257834',4904444,'2183','327',759703.00,760012.20,0.00,0.00,309.20,247360.00,0.00,0.00,0.00),('1','148','769','257835',4904445,'2140','327',640445.56,641900.81,0.00,0.00,1455.25,1164200.00,0.00,0.00,0.00),('1','148','769','257835',4904446,'2183','327',760012.20,760508.38,0.00,0.00,496.18,396944.00,0.00,0.00,0.00),('1','148','769','257836',4904447,'2140','327',641900.81,642690.40,0.00,0.00,789.59,600088.40,0.00,0.00,0.00),('1','148','769','257836',4904448,'2183','327',760508.38,760718.89,0.00,0.00,210.51,159987.60,0.00,0.00,0.00),('1','148','769','257837',4904449,'2140','327',642690.40,642944.47,0.00,0.00,254.07,193093.20,0.00,0.00,0.00),('1','148','769','257837',4904450,'2183','327',760718.89,760813.06,0.00,0.00,94.17,71569.20,0.00,0.00,0.00),('1','148','769','257838',4904451,'2140','327',642944.47,644682.55,0.00,0.00,1738.08,1320940.80,0.00,0.00,0.00),('1','148','769','257838',4904452,'2183','327',760813.06,761425.60,0.00,0.00,612.54,465530.40,0.00,0.00,0.00),('1','148','769','257839',4904453,'2140','327',644682.55,646112.34,0.00,0.00,1429.79,1086640.40,0.00,0.00,0.00),('1','148','769','257839',4904454,'2183','327',761425.60,761692.05,0.00,0.00,266.45,202502.00,0.00,0.00,0.00),('1','148','769','257840',4904455,'2140','327',646112.34,646870.91,0.00,0.00,758.57,576513.20,0.00,0.00,0.00),('1','148','769','257840',4904456,'2183','327',761692.05,762170.45,0.00,0.00,478.40,363584.00,0.00,0.00,0.00),('1','148','769','257841',4904457,'2140','327',646870.91,646870.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257841',4904458,'2183','327',762170.45,762170.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257842',4904459,'2140','327',646870.91,647675.86,0.00,0.00,804.95,611762.00,0.00,0.00,0.00),('1','148','769','257842',4904460,'2183','327',762170.45,762456.45,0.00,0.00,286.00,217360.00,0.00,0.00,0.00),('1','148','769','257843',4904461,'2140','327',647675.86,649402.05,0.00,0.00,1726.19,1311904.40,0.00,0.00,0.00),('1','148','769','257843',4904462,'2183','327',762456.45,762649.74,0.00,0.00,193.29,146900.40,0.00,0.00,0.00),('1','148','769','257844',4904463,'2140','327',649402.05,650629.40,0.00,0.00,1227.35,932786.00,0.00,0.00,0.00),('1','148','769','257844',4904464,'2183','327',762649.74,763370.06,0.00,0.00,720.32,547443.20,0.00,0.00,0.00),('1','148','769','257845',4904465,'2140','327',650629.40,650941.30,0.00,0.00,311.90,237044.00,0.00,0.00,0.00),('1','148','769','257845',4904466,'2183','327',763370.06,763370.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257846',4904467,'2140','327',650941.30,650941.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257846',4904468,'2183','327',763370.06,764120.01,0.00,0.00,749.95,569962.00,0.00,0.00,0.00),('1','148','769','257847',4904469,'2140','327',650941.30,652098.88,0.00,0.00,1157.58,879760.80,0.00,0.00,0.00),('1','148','769','257847',4904470,'2183','327',764120.01,764404.36,0.00,0.00,284.35,216106.00,0.00,0.00,0.00),('1','148','769','257848',4904471,'2140','327',652098.88,652791.96,0.00,0.00,693.08,526740.80,0.00,0.00,0.00),('1','148','769','257848',4904472,'2183','327',764404.36,765009.36,0.00,0.00,605.00,459800.00,0.00,0.00,0.00),('1','148','769','257849',4904473,'2140','327',652791.96,653298.36,0.00,0.00,506.40,384864.00,0.00,0.00,0.00),('1','148','769','257849',4904474,'2183','327',765009.36,765574.05,0.00,0.00,564.69,429164.40,0.00,0.00,0.00),('1','148','769','257850',4904475,'2140','327',653298.36,653398.55,0.00,0.00,100.19,76144.40,0.00,0.00,0.00),('1','148','769','257850',4904476,'2183','327',765574.05,765643.40,0.00,0.00,69.35,52706.00,0.00,0.00,0.00),('1','148','769','257851',4904477,'2140','327',653398.55,653962.68,0.00,0.00,564.13,428738.80,0.00,0.00,0.00),('1','148','769','257851',4904478,'2183','327',765643.40,766041.48,0.00,0.00,398.08,302540.80,0.00,0.00,0.00),('1','148','769','257852',4904479,'2140','327',653962.68,655271.15,0.00,0.00,1308.47,994437.20,0.00,0.00,0.00),('1','148','769','257852',4904480,'2183','327',766041.48,766622.03,0.00,0.00,580.55,441218.00,0.00,0.00,0.00),('1','148','769','257853',4904481,'2140','327',655271.15,656070.15,0.00,0.00,799.00,607240.00,0.00,0.00,0.00),('1','148','769','257853',4904482,'2183','327',766622.03,767499.98,0.00,0.00,877.95,667242.00,0.00,0.00,0.00),('1','148','769','257854',4904483,'2140','327',656070.15,656070.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257854',4904484,'2183','327',767499.98,767499.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257855',4904485,'2140','327',656070.15,657306.64,0.00,0.00,1236.49,939732.40,0.00,0.00,0.00),('1','148','769','257855',4904486,'2183','327',767499.98,767894.10,0.00,0.00,394.12,299531.20,0.00,0.00,0.00),('1','148','769','257856',4904487,'2140','327',657306.64,658403.93,0.00,0.00,1097.29,833940.40,0.00,0.00,0.00),('1','148','769','257856',4904488,'2183','327',767894.10,768359.19,0.00,0.00,465.09,353468.40,0.00,0.00,0.00),('1','148','769','257857',4904489,'2140','327',658403.93,659252.52,0.00,0.00,848.59,644928.40,0.00,0.00,0.00),('1','148','769','257857',4904490,'2183','327',768359.19,768902.20,0.00,0.00,543.01,412687.60,0.00,0.00,0.00),('1','148','769','257858',4904491,'2140','327',659252.52,659940.18,0.00,0.00,687.66,522621.60,0.00,0.00,0.00),('1','148','769','257858',4904492,'2183','327',768902.20,769249.58,0.00,0.00,347.38,264008.80,0.00,0.00,0.00),('1','148','769','257859',4904493,'2140','327',659940.18,660187.95,0.00,0.00,247.77,188305.20,0.00,0.00,0.00),('1','148','769','257859',4904494,'2183','327',769249.58,769333.87,0.00,0.00,84.29,64060.40,0.00,0.00,0.00),('1','148','769','257860',4904495,'2140','327',660187.95,661597.31,0.00,0.00,1409.36,1071113.60,0.00,0.00,0.00),('1','148','769','257860',4904496,'2183','327',769333.87,769384.72,0.00,0.00,50.85,38646.00,0.00,0.00,0.00),('1','148','769','257861',4904497,'2140','327',661597.31,662974.04,0.00,0.00,1376.73,1046314.80,0.00,0.00,0.00),('1','148','769','257861',4904498,'2183','327',769384.72,769872.82,0.00,0.00,488.10,370956.00,0.00,0.00,0.00),('1','148','769','257862',4904499,'2140','327',662974.04,664222.15,0.00,0.00,1248.11,948563.60,0.00,0.00,0.00),('1','148','769','257862',4904500,'2183','327',769872.82,770175.45,0.00,0.00,302.63,229998.80,0.00,0.00,0.00),('1','148','769','257863',4904501,'2140','327',664222.15,665527.70,0.00,0.00,1305.55,992218.00,0.00,0.00,0.00),('1','148','769','257863',4904502,'2183','327',770175.45,770538.05,0.00,0.00,362.60,275576.00,0.00,0.00,0.00),('1','148','769','257864',4904503,'2140','327',665527.70,666316.53,0.00,0.00,788.83,599510.80,0.00,0.00,0.00),('1','148','769','257864',4904504,'2183','327',770538.05,770908.95,0.00,0.00,370.90,281884.00,0.00,0.00,0.00),('1','148','769','257865',4904505,'2140','327',666316.53,667165.35,0.00,0.00,848.82,645103.20,0.00,0.00,0.00),('1','148','769','257865',4904506,'2183','327',770908.95,771280.53,0.00,0.00,371.58,282400.80,0.00,0.00,0.00),('1','148','769','257866',4904507,'2140','327',667165.35,667982.32,0.00,0.00,816.97,620897.20,0.00,0.00,0.00),('1','148','769','257866',4904508,'2183','327',771280.53,771519.60,0.00,0.00,239.07,181693.20,0.00,0.00,0.00),('1','148','769','257867',4904509,'2140','327',667982.32,668582.81,0.00,0.00,600.49,456372.40,0.00,0.00,0.00),('1','148','769','257867',4904510,'2183','327',771519.60,772522.70,0.00,0.00,1003.10,762356.00,0.00,0.00,0.00),('1','148','769','257868',4904511,'2140','327',668582.81,669975.93,0.00,0.00,1393.12,1058771.20,0.00,0.00,0.00),('1','148','769','257868',4904512,'2183','327',772522.70,772823.84,0.00,0.00,301.14,228866.40,0.00,0.00,0.00),('1','148','769','257869',4904513,'2140','327',669975.93,671683.00,0.00,0.00,1707.07,1297373.20,0.00,0.00,0.00),('1','148','769','257869',4904514,'2183','327',772823.84,773041.45,0.00,0.00,217.61,165383.60,0.00,0.00,0.00),('1','148','769','257870',4904515,'2140','327',671683.00,672775.12,0.00,0.00,1092.12,830011.20,0.00,0.00,0.00),('1','148','769','257870',4904516,'2183','327',773041.45,773193.35,0.00,0.00,151.90,115444.00,0.00,0.00,0.00),('1','148','769','257871',4904517,'2140','327',672775.12,674129.94,0.00,0.00,1354.82,1032903.20,0.00,0.00,0.00),('1','148','769','257871',4904518,'2183','327',773193.35,773343.01,0.00,0.00,149.66,113741.60,0.00,0.00,0.00),('1','148','769','257872',4904519,'2140','327',674129.94,675649.19,0.00,0.00,1519.25,1154630.00,0.00,0.00,0.00),('1','148','769','257872',4904520,'2183','327',773343.01,773447.91,0.00,0.00,104.90,79724.00,0.00,0.00,0.00),('1','148','769','257873',4904521,'2140','327',675649.19,676352.11,0.00,0.00,702.92,534219.20,0.00,0.00,0.00),('1','148','769','257873',4904522,'2183','327',773447.91,773569.87,0.00,0.00,121.96,92689.60,0.00,0.00,0.00),('1','148','769','257874',4904523,'2140','327',676352.11,676771.95,0.00,0.00,419.84,319078.40,0.00,0.00,0.00),('1','148','769','257874',4904524,'2183','327',773569.87,773569.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257875',4904525,'2140','327',676771.95,677739.69,0.00,0.00,967.74,735482.40,0.00,0.00,0.00),('1','148','769','257875',4904526,'2183','327',773569.87,773983.34,0.00,0.00,413.47,314237.20,0.00,0.00,0.00),('1','148','769','257876',4904527,'2140','327',677739.69,679318.90,0.00,0.00,1579.21,1200199.60,0.00,0.00,0.00),('1','148','769','257876',4904528,'2183','327',773983.34,774403.99,0.00,0.00,420.65,319694.00,0.00,0.00,0.00),('1','148','769','257877',4904529,'2140','327',679318.90,680170.52,0.00,0.00,851.62,647231.20,0.00,0.00,0.00),('1','148','769','257877',4904530,'2183','327',774403.99,774920.51,0.00,0.00,516.52,392555.20,0.00,0.00,0.00),('1','148','769','257878',4904531,'2140','327',680170.52,680548.16,0.00,0.00,377.64,287006.40,0.00,0.00,0.00),('1','148','769','257878',4904532,'2183','327',774920.51,775000.77,0.00,0.00,80.26,60997.60,0.00,0.00,0.00),('1','148','769','257879',4904533,'2140','327',680548.16,682228.66,0.00,0.00,1680.50,1278720.00,0.00,0.00,0.00),('1','148','769','257879',4904534,'2183','327',775000.77,775309.06,0.00,0.00,308.29,234300.40,0.00,0.00,0.00),('1','148','769','257880',4904535,'2140','327',682228.66,683685.09,0.00,0.00,1456.43,1106886.80,0.00,0.00,0.00),('1','148','769','257880',4904536,'2183','327',775309.06,775467.93,0.00,0.00,158.87,120741.20,0.00,0.00,0.00),('1','148','769','257881',4904537,'2140','327',683685.09,684359.48,0.00,0.00,674.39,512536.40,0.00,0.00,0.00),('1','148','769','257881',4904538,'2183','327',775467.93,775766.24,0.00,0.00,298.31,226715.60,0.00,0.00,0.00),('1','148','769','257882',4904539,'2140','327',684359.48,685456.88,0.00,0.00,1097.40,834024.00,0.00,0.00,0.00),('1','148','769','257882',4904540,'2183','327',775766.24,776265.87,0.00,0.00,499.63,379718.80,0.00,0.00,0.00),('1','148','769','257883',4904541,'2140','327',685456.88,686386.79,0.00,0.00,929.91,689624.40,0.00,0.00,0.00),('1','148','769','257883',4904542,'2183','327',776265.87,776740.50,0.00,0.00,474.63,353363.76,0.00,0.00,0.00),('1','148','769','257884',4904543,'2140','327',686386.79,687453.48,0.00,0.00,1066.69,785083.84,0.00,0.00,0.00),('1','148','769','257884',4904544,'2183','327',776740.50,777303.71,0.00,0.00,563.21,414522.56,0.00,0.00,0.00),('1','148','769','257885',4904545,'2140','327',687453.48,687453.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257885',4904546,'2183','327',777303.71,777303.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257886',4904547,'2140','327',687453.48,688775.25,0.00,0.00,1321.77,972822.72,0.00,0.00,0.00),('1','148','769','257886',4904548,'2183','327',777303.71,777834.32,0.00,0.00,530.61,390528.96,0.00,0.00,0.00),('1','148','769','257887',4904549,'2140','327',688775.25,689677.25,0.00,0.00,902.00,663872.00,0.00,0.00,0.00),('1','148','769','257887',4904550,'2183','327',777834.32,778177.97,0.00,0.00,343.65,252926.40,0.00,0.00,0.00),('1','148','769','257888',4904551,'2140','327',689677.25,690554.04,0.00,0.00,876.79,645317.44,0.00,0.00,0.00),('1','148','769','257888',4904552,'2183','327',778177.97,778718.48,0.00,0.00,540.51,397815.36,0.00,0.00,0.00),('1','148','769','257889',4904553,'2140','327',690554.04,691577.01,0.00,0.00,1022.97,752905.92,0.00,0.00,0.00),('1','148','769','257889',4904554,'2183','327',778718.48,779111.01,0.00,0.00,392.53,288902.08,0.00,0.00,0.00),('1','148','769','257890',4904555,'2140','327',691577.01,691577.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257890',4904556,'2183','327',779111.01,779111.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257891',4904557,'2140','327',691577.01,692610.83,0.00,0.00,1033.82,760891.52,0.00,0.00,0.00),('1','148','769','257891',4904558,'2183','327',779111.01,779765.51,0.00,0.00,654.50,481712.00,0.00,0.00,0.00),('1','148','769','257892',4904559,'2140','327',692610.83,693489.12,0.00,0.00,878.29,646421.44,0.00,0.00,0.00),('1','148','769','257892',4904560,'2183','327',779765.51,780538.13,0.00,0.00,772.62,568648.32,0.00,0.00,0.00),('1','148','769','257893',4904561,'2140','327',693489.12,694607.91,0.00,0.00,1118.79,823429.44,0.00,0.00,0.00),('1','148','769','257893',4904562,'2183','327',780538.13,781184.67,0.00,0.00,646.54,475853.44,0.00,0.00,0.00),('1','148','769','257894',4904563,'2140','327',694607.91,694959.03,0.00,0.00,351.12,258424.32,0.00,0.00,0.00),('1','148','769','257894',4904564,'2183','327',781184.67,781311.37,0.00,0.00,126.70,93251.20,0.00,0.00,0.00),('1','148','769','257895',4904565,'2140','327',694959.03,695120.87,0.00,0.00,161.84,119114.24,0.00,0.00,0.00),('1','148','769','257895',4904566,'2183','327',781311.37,782120.66,0.00,0.00,809.29,595637.44,0.00,0.00,0.00),('1','148','769','257896',4904567,'2140','327',695120.87,695979.20,0.00,0.00,858.33,631730.88,0.00,0.00,0.00),('1','148','769','257896',4904568,'2183','327',782120.66,782588.35,0.00,0.00,467.69,344219.84,0.00,0.00,0.00),('1','148','769','257897',4904569,'2140','327',695979.20,697101.96,0.00,0.00,1122.76,826351.36,0.00,0.00,0.00),('1','148','769','257897',4904570,'2183','327',782588.35,783003.67,0.00,0.00,415.32,305675.52,0.00,0.00,0.00),('1','148','769','257898',4904571,'2140','327',697101.96,697940.36,0.00,0.00,838.40,617062.40,0.00,0.00,0.00),('1','148','769','257898',4904572,'2183','327',783003.67,783587.93,0.00,0.00,584.26,430015.36,0.00,0.00,0.00),('1','148','769','257899',4904573,'2140','327',697940.36,697940.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257899',4904574,'2183','327',783587.93,783587.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257900',4904575,'2140','327',697940.36,698117.16,0.00,0.00,176.80,130124.80,0.00,0.00,0.00),('1','148','769','257900',4904576,'2183','327',783587.93,783753.31,0.00,0.00,165.38,121719.68,0.00,0.00,0.00),('1','148','769','257901',4904577,'2140','327',698117.16,699889.04,0.00,0.00,1771.88,1304103.68,0.00,0.00,0.00),('1','148','769','257901',4904578,'2183','327',783753.31,784336.20,0.00,0.00,582.89,429007.04,0.00,0.00,0.00),('1','148','769','257902',4904579,'2140','327',699889.04,701398.26,0.00,0.00,1509.22,1110785.92,0.00,0.00,0.00),('1','148','769','257902',4904580,'2183','327',784336.20,784913.05,0.00,0.00,576.85,424561.60,0.00,0.00,0.00),('1','148','769','257903',4904581,'2140','327',701398.26,702023.80,0.00,0.00,625.54,460397.44,0.00,0.00,0.00),('1','148','769','257903',4904582,'2183','327',784913.05,785189.82,0.00,0.00,276.77,203702.72,0.00,0.00,0.00),('1','148','769','257904',4904583,'2140','327',702023.80,702326.50,0.00,0.00,302.70,222787.20,0.00,0.00,0.00),('1','148','769','257904',4904584,'2183','327',785189.82,785359.94,0.00,0.00,170.12,125208.32,0.00,0.00,0.00),('1','148','769','257905',4904585,'2140','327',702326.50,703900.23,0.00,0.00,1573.73,1158265.28,0.00,0.00,0.00),('1','148','769','257905',4904586,'2183','327',785359.94,786139.22,0.00,0.00,779.28,573550.08,0.00,0.00,0.00),('1','148','769','257906',4904587,'2140','327',703900.23,705420.67,0.00,0.00,1520.44,1119043.84,0.00,0.00,0.00),('1','148','769','257906',4904588,'2183','327',786139.22,786526.45,0.00,0.00,387.23,285001.28,0.00,0.00,0.00),('1','148','769','257907',4904589,'2140','327',705420.67,706443.79,0.00,0.00,1023.12,753016.32,0.00,0.00,0.00),('1','148','769','257907',4904590,'2183','327',786526.45,786913.84,0.00,0.00,387.39,285119.04,0.00,0.00,0.00),('1','148','769','257908',4904591,'2140','327',706443.79,707768.78,0.00,0.00,1324.99,975192.64,0.00,0.00,0.00),('1','148','769','257908',4904592,'2183','327',786913.84,787030.71,0.00,0.00,116.87,86016.32,0.00,0.00,0.00),('1','148','769','257909',4904593,'2140','327',707768.78,708994.61,0.00,0.00,1225.83,902210.88,0.00,0.00,0.00),('1','148','769','257909',4904594,'2183','327',787030.71,787351.43,0.00,0.00,320.72,236049.92,0.00,0.00,0.00),('1','148','769','257910',4904595,'2140','327',708994.61,709696.31,0.00,0.00,701.70,516451.20,0.00,0.00,0.00),('1','148','769','257910',4904596,'2183','327',787351.43,787790.46,0.00,0.00,439.03,323126.08,0.00,0.00,0.00),('1','148','769','257911',4904597,'2140','327',709696.31,709696.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257911',4904598,'2183','327',787790.46,787790.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257912',4904599,'2140','327',709696.31,710817.39,0.00,0.00,1121.08,825114.88,0.00,0.00,0.00),('1','148','769','257912',4904600,'2183','327',787790.46,788643.04,0.00,0.00,852.58,627498.88,0.00,0.00,0.00),('1','148','769','257913',4904601,'2140','327',710817.39,712054.54,0.00,0.00,1237.15,910542.40,0.00,0.00,0.00),('1','148','769','257913',4904602,'2183','327',788643.04,789450.53,0.00,0.00,807.49,594312.64,0.00,0.00,0.00),('1','148','769','257914',4904603,'2140','327',712054.54,712831.87,0.00,0.00,777.33,572114.88,0.00,0.00,0.00),('1','148','769','257914',4904604,'2183','327',789450.53,789848.70,0.00,0.00,398.17,293053.12,0.00,0.00,0.00),('1','148','769','257915',4904605,'2140','327',712831.87,713164.00,0.00,0.00,332.13,244447.68,0.00,0.00,0.00),('1','148','769','257915',4904606,'2183','327',789848.70,790264.64,0.00,0.00,415.94,306131.84,0.00,0.00,0.00),('1','148','769','257916',4904607,'2140','327',713164.00,714427.77,0.00,0.00,1263.77,930134.72,0.00,0.00,0.00),('1','148','769','257916',4904608,'2183','327',790264.64,790683.65,0.00,0.00,419.01,308391.36,0.00,0.00,0.00),('1','148','769','257917',4904609,'2140','327',714427.77,715435.01,0.00,0.00,1007.24,741328.64,0.00,0.00,0.00),('1','148','769','257917',4904610,'2183','327',790683.65,791177.23,0.00,0.00,493.58,363274.88,0.00,0.00,0.00),('1','148','769','257918',4904611,'2140','327',715435.01,716163.62,0.00,0.00,728.61,536256.96,0.00,0.00,0.00),('1','148','769','257918',4904612,'2183','327',791177.23,791743.62,0.00,0.00,566.39,416863.04,0.00,0.00,0.00),('1','148','769','257919',4904613,'2140','327',716163.62,717100.19,0.00,0.00,936.57,689315.52,0.00,0.00,0.00),('1','148','769','257919',4904614,'2183','327',791743.62,792639.78,0.00,0.00,896.16,659573.76,0.00,0.00,0.00),('1','148','769','257920',4904615,'2140','327',717100.19,718009.85,0.00,0.00,909.66,669509.76,0.00,0.00,0.00),('1','148','769','257920',4904616,'2183','327',792639.78,793520.21,0.00,0.00,880.43,647996.48,0.00,0.00,0.00),('1','148','769','257921',4904617,'2140','327',718009.85,719056.81,0.00,0.00,1046.96,770562.56,0.00,0.00,0.00),('1','148','769','257921',4904618,'2183','327',793520.21,794290.03,0.00,0.00,769.82,566587.52,0.00,0.00,0.00),('1','148','769','257922',4904619,'2140','327',719056.81,719605.95,0.00,0.00,549.14,404167.04,0.00,0.00,0.00),('1','148','769','257922',4904620,'2183','327',794290.03,794686.63,0.00,0.00,396.60,291897.60,0.00,0.00,0.00),('1','148','769','257923',4904621,'2140','327',719605.95,721111.13,0.00,0.00,1505.18,1107812.48,0.00,0.00,0.00),('1','148','769','257923',4904622,'2183','327',794686.63,795065.21,0.00,0.00,378.58,278634.88,0.00,0.00,0.00),('1','148','769','257924',4904623,'2140','327',721111.13,722422.71,0.00,0.00,1311.58,965322.88,0.00,0.00,0.00),('1','148','769','257924',4904624,'2183','327',795065.21,795311.25,0.00,0.00,246.04,181085.44,0.00,0.00,0.00),('1','148','769','257925',4904625,'2140','327',722422.71,723008.65,0.00,0.00,585.94,431251.84,0.00,0.00,0.00),('1','148','769','257925',4904626,'2183','327',795311.25,795587.16,0.00,0.00,275.91,203069.76,0.00,0.00,0.00),('1','148','769','257926',4904627,'2140','327',723008.65,723813.43,0.00,0.00,804.78,592318.08,0.00,0.00,0.00),('1','148','769','257926',4904628,'2183','327',795587.16,796557.69,0.00,0.00,970.53,714310.08,0.00,0.00,0.00),('1','148','769','257927',4904629,'2140','327',723813.43,723813.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257927',4904630,'2183','327',796557.69,796557.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257928',4904631,'2140','327',723813.43,724113.97,0.00,0.00,300.54,221197.44,0.00,0.00,0.00),('1','148','769','257928',4904632,'2183','327',796557.69,796973.88,0.00,0.00,416.19,306315.84,0.00,0.00,0.00),('1','148','769','257929',4904633,'2140','327',724113.97,724113.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257929',4904634,'2183','327',796973.88,796973.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257930',4904635,'2140','327',724113.97,725642.27,0.00,0.00,1528.30,1124828.80,0.00,0.00,0.00),('1','148','769','257930',4904636,'2183','327',796973.88,798172.59,0.00,0.00,1198.71,882250.56,0.00,0.00,0.00),('1','148','769','257931',4904637,'2140','327',725642.27,726884.03,0.00,0.00,1241.76,913935.36,0.00,0.00,0.00),('1','148','769','257931',4904638,'2183','327',798172.59,798477.00,0.00,0.00,304.41,224045.76,0.00,0.00,0.00),('1','148','769','257932',4904639,'2140','327',726884.03,727260.39,0.00,0.00,376.36,277000.96,0.00,0.00,0.00),('1','148','769','257932',4904640,'2183','327',798477.00,798929.86,0.00,0.00,452.86,333304.96,0.00,0.00,0.00),('1','148','769','257933',4904641,'2140','327',727260.39,727260.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257933',4904642,'2183','327',798929.86,798929.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257934',4904643,'2140','327',727260.39,728623.08,0.00,0.00,1362.69,1002939.84,0.00,0.00,0.00),('1','148','769','257934',4904644,'2183','327',798929.86,799395.26,0.00,0.00,465.40,342534.40,0.00,0.00,0.00),('1','148','769','257935',4904645,'2140','327',728623.08,729867.11,0.00,0.00,1244.03,931184.04,0.00,0.00,0.00),('1','148','769','257935',4904646,'2183','327',799395.26,800103.65,0.00,0.00,708.39,521375.04,0.00,0.00,0.00),('1','148','769','257936',4904647,'2140','327',729867.11,730662.36,0.00,0.00,795.25,585304.00,0.00,0.00,0.00),('1','148','769','257936',4904648,'2183','327',800103.65,800483.85,0.00,0.00,380.20,279827.20,0.00,0.00,0.00),('1','148','769','257937',4904649,'2140','327',730662.36,730746.40,0.00,0.00,84.04,61853.44,0.00,0.00,0.00),('1','148','769','257937',4904650,'2183','327',800483.85,800483.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257938',4904651,'2140','327',730746.40,731822.83,0.00,0.00,1076.43,792252.48,0.00,0.00,0.00),('1','148','769','257938',4904652,'2183','327',800483.85,800973.36,0.00,0.00,489.51,360279.36,0.00,0.00,0.00),('1','148','769','257939',4904653,'2140','327',731822.83,733058.09,0.00,0.00,1235.26,910915.36,0.00,0.00,0.00),('1','148','769','257939',4904654,'2183','327',800973.36,801674.68,0.00,0.00,701.32,516171.52,0.00,0.00,0.00),('1','148','769','257940',4904655,'2140','327',733058.09,734072.45,0.00,0.00,1014.36,746568.96,0.00,0.00,0.00),('1','148','769','257940',4904656,'2183','327',801674.68,802032.94,0.00,0.00,358.26,263679.36,0.00,0.00,0.00),('1','148','769','257941',4904657,'2140','327',734072.45,734339.82,0.00,0.00,267.37,196784.32,0.00,0.00,0.00),('1','148','769','257941',4904658,'2183','327',802032.94,802185.15,0.00,0.00,152.21,112026.56,0.00,0.00,0.00),('1','148','769','257942',4904659,'2140','327',734339.82,735146.60,0.00,0.00,806.78,593790.08,0.00,0.00,0.00),('1','148','769','257942',4904660,'2183','327',802185.15,802823.42,0.00,0.00,638.27,469766.72,0.00,0.00,0.00),('1','148','769','257943',4904661,'2140','327',735146.60,736202.86,0.00,0.00,1056.26,777407.36,0.00,0.00,0.00),('1','148','769','257943',4904662,'2183','327',802823.42,803202.06,0.00,0.00,378.64,278679.04,0.00,0.00,0.00),('1','148','769','257944',4904663,'2140','327',736202.86,737037.89,0.00,0.00,835.03,617546.08,0.00,0.00,0.00),('1','148','769','257944',4904664,'2183','327',803202.06,804104.84,0.00,0.00,902.78,667410.08,0.00,0.00,0.00),('1','148','769','257945',4904665,'2140','327',737037.89,737727.80,0.00,0.00,689.91,507773.76,0.00,0.00,0.00),('1','148','769','257945',4904666,'2183','327',804104.84,804372.55,0.00,0.00,267.71,197034.56,0.00,0.00,0.00),('1','148','769','257946',4904667,'2140','327',737727.80,738655.07,0.00,0.00,927.27,682470.72,0.00,0.00,0.00),('1','148','769','257946',4904668,'2183','327',804372.55,805225.27,0.00,0.00,852.72,627601.92,0.00,0.00,0.00),('1','148','769','257947',4904669,'2140','327',738655.07,740616.18,0.00,0.00,1961.11,1443376.96,0.00,0.00,0.00),('1','148','769','257947',4904670,'2183','327',805225.27,805402.63,0.00,0.00,177.36,130536.96,0.00,0.00,0.00),('1','148','769','257948',4904671,'2140','327',740616.18,741300.39,0.00,0.00,684.21,503578.56,0.00,0.00,0.00),('1','148','769','257948',4904672,'2183','327',805402.63,805673.72,0.00,0.00,271.09,199522.24,0.00,0.00,0.00),('1','148','769','257949',4904673,'2140','327',741300.39,742121.38,0.00,0.00,820.99,604248.64,0.00,0.00,0.00),('1','148','769','257949',4904674,'2183','327',805673.72,805958.82,0.00,0.00,285.10,209833.60,0.00,0.00,0.00),('1','148','769','257950',4904675,'2140','327',742121.38,743560.61,0.00,0.00,1439.23,1059273.28,0.00,0.00,0.00),('1','148','769','257950',4904676,'2183','327',805958.82,806129.02,0.00,0.00,170.20,125267.20,0.00,0.00,0.00),('1','148','769','257951',4904677,'2140','327',743560.61,744868.53,0.00,0.00,1307.92,962629.12,0.00,0.00,0.00),('1','148','769','257951',4904678,'2183','327',806129.02,806541.60,0.00,0.00,412.58,303658.88,0.00,0.00,0.00),('1','148','769','257952',4904679,'2140','327',744868.53,745155.21,0.00,0.00,286.68,210996.48,0.00,0.00,0.00),('1','148','769','257952',4904680,'2183','327',806541.60,806826.00,0.00,0.00,284.40,209318.40,0.00,0.00,0.00),('1','148','769','257953',4904681,'2140','327',745155.21,746425.13,0.00,0.00,1269.92,934661.12,0.00,0.00,0.00),('1','148','769','257953',4904682,'2183','327',806826.00,807026.00,0.00,0.00,200.00,147200.00,0.00,0.00,0.00),('1','148','769','257954',4904683,'2140','327',746425.13,747350.10,0.00,0.00,924.97,680777.92,0.00,0.00,0.00),('1','148','769','257954',4904684,'2183','327',807026.00,808439.52,0.00,0.00,1413.52,1040350.72,0.00,0.00,0.00),('1','148','769','257955',4904685,'2140','327',747350.10,747642.23,0.00,0.00,292.13,215007.68,0.00,0.00,0.00),('1','148','769','257955',4904686,'2183','327',808439.52,809676.68,0.00,0.00,1237.16,910549.76,0.00,0.00,0.00),('1','148','769','257956',4904687,'2140','327',747642.23,747849.26,0.00,0.00,207.03,152374.08,0.00,0.00,0.00),('1','148','769','257956',4904688,'2183','327',809676.68,809931.81,0.00,0.00,255.13,187775.68,0.00,0.00,0.00),('1','148','769','257957',4904689,'2140','327',747849.26,748278.44,0.00,0.00,429.18,315876.48,0.00,0.00,0.00),('1','148','769','257957',4904690,'2183','327',809931.81,809931.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257958',4904691,'2140','327',748278.44,748844.15,0.00,0.00,565.71,416362.56,0.00,0.00,0.00),('1','148','769','257958',4904692,'2183','327',809931.81,810243.76,0.00,0.00,311.95,229595.20,0.00,0.00,0.00),('1','148','769','257959',4904693,'2140','327',748844.15,749053.70,0.00,0.00,209.55,154228.80,0.00,0.00,0.00),('1','148','769','257959',4904694,'2183','327',810243.76,810243.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257960',4904695,'2140','327',749053.70,750607.41,0.00,0.00,1553.71,1143530.56,0.00,0.00,0.00),('1','148','769','257960',4904696,'2183','327',810243.76,810686.06,0.00,0.00,442.30,325532.80,0.00,0.00,0.00),('1','148','769','257961',4904697,'2140','327',750607.41,751971.47,0.00,0.00,1364.06,1003948.16,0.00,0.00,0.00),('1','148','769','257961',4904698,'2183','327',810686.06,811014.88,0.00,0.00,328.82,242011.52,0.00,0.00,0.00),('1','148','769','257962',4904699,'2140','327',751971.47,752402.11,0.00,0.00,430.64,316951.04,0.00,0.00,0.00),('1','148','769','257962',4904700,'2183','327',811014.88,811125.74,0.00,0.00,110.86,81592.96,0.00,0.00,0.00),('1','148','769','257963',4904701,'2140','327',752402.11,752402.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257963',4904702,'2183','327',811125.74,811198.14,0.00,0.00,72.40,53286.40,0.00,0.00,0.00),('1','148','769','257964',4904703,'2140','327',752402.11,753123.51,0.00,0.00,721.40,530950.40,0.00,0.00,0.00),('1','148','769','257964',4904704,'2183','327',811198.14,811668.43,0.00,0.00,470.29,346133.44,0.00,0.00,0.00),('1','148','769','257965',4904705,'2140','327',753123.51,753729.09,0.00,0.00,605.58,445706.88,0.00,0.00,0.00),('1','148','769','257965',4904706,'2183','327',811668.43,812885.00,0.00,0.00,1216.57,895395.52,0.00,0.00,0.00),('1','148','769','257966',4904707,'2140','327',753729.09,754709.68,0.00,0.00,980.59,721714.24,0.00,0.00,0.00),('1','148','769','257966',4904708,'2183','327',812885.00,813314.57,0.00,0.00,429.57,316163.52,0.00,0.00,0.00),('1','148','769','257967',4904709,'2140','327',754709.68,755510.02,0.00,0.00,800.34,589050.24,0.00,0.00,0.00),('1','148','769','257967',4904710,'2183','327',813314.57,813578.46,0.00,0.00,263.89,194223.04,0.00,0.00,0.00),('1','148','769','257968',4904711,'2140','327',755510.02,755887.98,0.00,0.00,377.96,278178.56,0.00,0.00,0.00),('1','148','769','257968',4904712,'2183','327',813578.46,813802.72,0.00,0.00,224.26,165055.36,0.00,0.00,0.00),('1','148','769','257969',4904713,'2140','327',755887.98,756352.90,0.00,0.00,464.92,342181.12,0.00,0.00,0.00),('1','148','769','257969',4904714,'2183','327',813802.72,813872.68,0.00,0.00,69.96,51490.56,0.00,0.00,0.00),('1','148','769','257970',4904715,'2140','327',756352.90,757031.06,0.00,0.00,678.16,499125.76,0.00,0.00,0.00),('1','148','769','257970',4904716,'2183','327',813872.68,814301.17,0.00,0.00,428.49,315368.64,0.00,0.00,0.00),('1','148','769','257971',4904717,'2140','327',757031.06,757916.42,0.00,0.00,885.36,651624.96,0.00,0.00,0.00),('1','148','769','257971',4904718,'2183','327',814301.17,814447.77,0.00,0.00,146.60,107897.60,0.00,0.00,0.00),('1','148','769','257972',4904719,'2140','327',757916.42,759090.51,0.00,0.00,1174.09,864130.24,0.00,0.00,0.00),('1','148','769','257972',4904720,'2183','327',814447.77,814735.37,0.00,0.00,287.60,211673.60,0.00,0.00,0.00),('1','148','769','257973',4904721,'2140','327',759090.51,759823.42,0.00,0.00,732.91,539421.76,0.00,0.00,0.00),('1','148','769','257973',4904722,'2183','327',814735.37,815067.28,0.00,0.00,331.91,244285.76,0.00,0.00,0.00),('1','148','769','257974',4904723,'2140','327',759823.42,760406.22,0.00,0.00,582.80,428940.80,0.00,0.00,0.00),('1','148','769','257974',4904724,'2183','327',815067.28,815672.93,0.00,0.00,605.65,445758.40,0.00,0.00,0.00),('1','148','769','257975',4904725,'2140','327',760406.22,760961.92,0.00,0.00,555.70,408995.20,0.00,0.00,0.00),('1','148','769','257975',4904726,'2183','327',815672.93,815772.65,0.00,0.00,99.72,73393.92,0.00,0.00,0.00),('1','148','769','257976',4904727,'2140','327',760961.92,762112.19,0.00,0.00,1150.27,846598.72,0.00,0.00,0.00),('1','148','769','257976',4904728,'2183','327',815772.65,816226.30,0.00,0.00,453.65,333886.40,0.00,0.00,0.00),('1','148','769','257977',4904729,'2140','327',762112.19,763266.98,0.00,0.00,1154.79,849925.44,0.00,0.00,0.00),('1','148','769','257977',4904730,'2183','327',816226.30,816414.47,0.00,0.00,188.17,138493.12,0.00,0.00,0.00),('1','148','769','257978',4904731,'2140','327',763266.98,763266.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257978',4904732,'2183','327',816414.47,816414.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257979',4904733,'2140','327',763266.98,764945.47,0.00,0.00,1678.49,1235368.64,0.00,0.00,0.00),('1','148','769','257979',4904734,'2183','327',816414.47,816573.40,0.00,0.00,158.93,116972.48,0.00,0.00,0.00),('1','148','769','257980',4904735,'2140','327',764945.47,766962.71,0.00,0.00,2017.24,1484688.64,0.00,0.00,0.00),('1','148','769','257980',4904736,'2183','327',816573.40,816631.41,0.00,0.00,58.01,42695.36,0.00,0.00,0.00),('1','148','769','257981',4904737,'2140','327',766962.71,768230.04,0.00,0.00,1267.33,932754.88,0.00,0.00,0.00),('1','148','769','257981',4904738,'2183','327',816631.41,816631.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257982',4904739,'2140','327',768230.04,768814.25,0.00,0.00,584.21,429978.56,0.00,0.00,0.00),('1','148','769','257982',4904740,'2183','327',816631.41,816631.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','257983',4904741,'2140','327',768814.25,769921.71,0.00,0.00,1107.46,815090.56,0.00,0.00,0.00),('1','148','769','257983',4904742,'2183','327',816631.41,816853.14,0.00,0.00,221.73,163193.28,0.00,0.00,0.00),('1','148','769','257984',4904743,'2140','327',769921.71,770853.78,0.00,0.00,932.07,686003.52,0.00,0.00,0.00),('1','148','769','257984',4904744,'2183','327',816853.14,816919.45,0.00,0.00,66.31,48804.16,0.00,0.00,0.00),('1','148','769','257985',4904745,'2140','327',770853.78,771634.49,0.00,0.00,780.71,574602.56,0.00,0.00,0.00),('1','148','769','257985',4904746,'2183','327',816919.45,817201.93,0.00,0.00,282.48,207905.28,0.00,0.00,0.00),('1','148','769','257986',4904747,'2140','327',771634.49,772477.68,0.00,0.00,843.19,620587.84,0.00,0.00,0.00),('1','148','769','257986',4904748,'2183','327',817201.93,817576.68,0.00,0.00,374.75,275816.00,0.00,0.00,0.00),('1','148','769','257987',4904749,'2140','327',772477.68,773591.56,0.00,0.00,1113.88,819815.68,0.00,0.00,0.00),('1','148','769','257987',4904750,'2183','327',817576.68,817711.66,0.00,0.00,134.98,99345.28,0.00,0.00,0.00),('1','148','769','257988',4904751,'2140','327',773591.56,775262.92,0.00,0.00,1671.36,1230120.96,0.00,0.00,0.00),('1','148','769','257988',4904752,'2183','327',817711.66,818205.89,0.00,0.00,494.23,363753.28,0.00,0.00,0.00),('1','148','769','257989',4904753,'2140','327',775262.92,776537.83,0.00,0.00,1274.91,938333.76,0.00,0.00,0.00),('1','148','769','257989',4904754,'2183','327',818205.89,818951.65,0.00,0.00,745.76,548879.36,0.00,0.00,0.00),('1','148','769','257990',4904755,'2140','327',776537.83,777024.21,0.00,0.00,486.38,357975.68,0.00,0.00,0.00),('1','148','769','257990',4904756,'2183','327',818951.65,819496.95,0.00,0.00,545.30,401340.80,0.00,0.00,0.00),('1','148','769','257991',4904757,'2140','327',777024.21,778153.62,0.00,0.00,1129.41,831245.76,0.00,0.00,0.00),('1','148','769','257991',4904758,'2183','327',819496.95,819725.91,0.00,0.00,228.96,168514.56,0.00,0.00,0.00),('1','148','769','257992',4904759,'2140','327',778153.62,778435.00,0.00,0.00,281.38,198071.56,0.00,0.00,0.00),('1','148','769','257992',4904760,'2183','327',819725.91,820803.74,0.00,0.00,1077.83,754481.00,0.00,0.00,0.00),('1','148','769','257993',4904761,'2140','327',778435.00,779759.05,0.00,0.00,1324.05,926835.00,0.00,0.00,0.00),('1','148','769','257993',4904762,'2183','327',820803.74,820984.47,0.00,0.00,180.73,126511.00,0.00,0.00,0.00),('1','148','769','257994',4904763,'2140','327',779759.05,780377.42,0.00,0.00,618.37,432859.00,0.00,0.00,0.00),('1','148','769','257994',4904764,'2183','327',820984.47,821124.03,0.00,0.00,139.56,97692.00,0.00,0.00,0.00),('1','148','769','257995',4904765,'2140','327',780377.42,780790.22,0.00,0.00,412.80,288960.00,0.00,0.00,0.00),('1','148','769','257995',4904766,'2183','327',821124.03,821297.49,0.00,0.00,173.46,121422.00,0.00,0.00,0.00),('1','148','769','257996',4904767,'2140','327',780790.22,781583.72,0.00,0.00,793.50,555450.00,0.00,0.00,0.00),('1','148','769','257996',4904768,'2183','327',821297.49,821477.21,0.00,0.00,179.72,125804.00,0.00,0.00,0.00),('1','148','769','257997',4904769,'2140','327',781583.72,782987.66,0.00,0.00,1403.94,982758.00,0.00,0.00,0.00),('1','148','769','257997',4904770,'2183','327',821477.21,821889.24,0.00,0.00,412.03,288421.00,0.00,0.00,0.00),('1','148','769','257998',4904771,'2140','327',782987.66,783759.78,0.00,0.00,772.12,540484.00,0.00,0.00,0.00),('1','148','769','257998',4904772,'2183','327',821889.24,822225.54,0.00,0.00,336.30,235410.00,0.00,0.00,0.00),('1','148','769','257999',4904773,'2140','327',783759.78,784272.27,0.00,0.00,512.49,358743.00,0.00,0.00,0.00),('1','148','769','257999',4904774,'2183','327',822225.54,822573.81,0.00,0.00,348.27,243789.00,0.00,0.00,0.00),('1','148','769','258000',4904775,'2140','327',784272.27,784272.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','258000',4904776,'2183','327',822573.81,822573.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','148','769','258001',4904777,'2140','327',784272.27,784523.06,0.00,0.00,250.79,175553.00,0.00,0.00,0.00),('1','148','769','258001',4904778,'2183','327',822573.81,822625.37,0.00,0.00,51.56,36092.00,0.00,0.00,0.00),('1','148','769','258002',4904779,'2140','327',784523.06,785404.19,0.00,0.00,881.13,616791.00,0.00,0.00,0.00),('1','148','769','258002',4904780,'2183','327',822625.37,822904.49,0.00,0.00,279.12,195384.00,0.00,0.00,0.00),('1','148','769','258003',4904781,'2140','327',785404.19,786826.63,0.00,0.00,1422.44,995708.00,0.00,0.00,0.00),('1','148','769','258003',4904782,'2183','327',822904.49,822973.50,0.00,0.00,69.01,48307.00,0.00,0.00,0.00),('1','148','769','258004',4904783,'2140','327',786826.63,787070.37,0.00,0.00,243.74,170618.00,0.00,0.00,0.00),('1','148','769','258004',4904784,'2183','327',822973.50,824115.27,0.00,0.00,1141.77,799239.00,0.00,0.00,0.00),('1','148','769','258005',4904785,'2140','327',787070.37,788076.88,0.00,0.00,1006.51,704557.00,0.00,0.00,0.00),('1','148','769','258005',4904786,'2183','327',824115.27,824218.55,0.00,0.00,103.28,72296.00,0.00,0.00,0.00),('1','148','769','258006',4904787,'2140','327',788076.88,789184.68,0.00,0.00,1107.80,775460.00,0.00,0.00,0.00),('1','148','769','258006',4904788,'2183','327',824218.55,824289.76,0.00,0.00,71.21,49847.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730175 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','148','146992','327',210.00,280.00,0.00,5428.94,1140077.40,1243863.20,103785.80,441531),('1','148','147019','327',210.00,280.00,0.00,1023.06,214842.60,238190.56,23347.96,441587),('1','148','147073','327',210.00,280.00,0.00,1252.05,262930.50,350574.00,87643.50,441719),('1','148','147086','327',210.00,280.00,0.00,915.08,192166.80,256222.40,64055.60,441736),('1','148','147105','327',210.00,280.00,0.00,234.47,49238.70,65651.60,16412.90,441761),('1','148','147169','327',210.00,280.00,0.00,795.05,166960.50,171730.80,4770.30,441895),('1','148','147187','327',210.00,280.00,0.00,4745.56,996567.60,1108371.52,111803.92,441937),('1','148','147213','327',210.00,280.00,0.00,5149.89,1081476.90,1176910.64,95433.74,441985),('1','148','147225','327',210.00,280.00,0.00,4454.11,935363.10,1049432.40,114069.30,442009),('1','148','147243','327',210.00,280.00,0.00,1857.95,390169.50,421390.16,31220.66,442049),('1','148','147264','327',210.00,280.00,0.00,3477.36,730245.60,809114.88,78869.28,442104),('1','148','147267','327',210.00,280.00,0.00,216.14,45389.40,60519.20,15129.80,442109),('1','148','147271','327',210.00,280.00,0.00,4496.66,944298.60,1014994.40,70695.80,442119),('1','148','147286','327',210.00,216.00,0.00,633.19,132969.90,136769.04,3799.14,442153),('1','148','147333','327',210.00,280.00,0.00,4762.38,1000099.80,1093945.12,93845.32,442270),('1','148','147465','327',210.00,280.00,0.00,2970.73,623853.30,693423.60,69570.30,442632),('1','148','147592','327',210.00,280.00,0.00,927.44,194762.40,219403.52,24641.12,442983),('1','148','147712','327',210.00,280.00,0.00,5228.07,1097894.70,1222535.44,124640.74,443292),('1','148','147909','327',202.00,280.00,0.00,6263.96,1265319.92,1452636.48,187316.56,443834),('1','148','148011','327',202.00,280.00,0.00,1231.25,248712.50,279134.00,30421.50,444092),('1','148','148156','327',222.00,280.00,0.00,5530.07,1227675.54,1273048.08,45372.54,444483),('1','148','148305','327',222.00,280.00,0.00,5384.93,1195454.46,1250586.80,55132.34,444856),('1','148','148458','327',222.00,280.00,0.00,3827.27,849653.94,880136.08,30482.14,445275),('1','148','148588','327',222.00,280.00,0.00,1368.02,303700.44,310273.76,6573.32,445612),('1','148','148700','327',222.00,280.00,0.00,5494.83,1219852.26,1274894.16,55041.90,445897),('1','148','148786','327',202.00,280.00,0.00,4252.78,859061.56,978739.36,119677.80,446120),('1','148','148948','327',222.00,280.00,0.00,5595.64,1242232.08,1292447.68,50215.60,446545),('1','148','149200','327',222.00,280.00,0.00,5360.01,1189922.22,1222114.80,32192.58,447215),('1','148','149360','327',205.00,280.00,0.00,1705.20,349566.00,384199.68,34633.68,447628),('1','148','149515','327',205.00,280.00,0.00,4333.61,888390.05,1002550.00,114159.95,448054),('1','148','149624','327',205.00,280.00,0.00,4273.82,876133.10,1001380.64,125247.54,448346),('1','148','149630','327',205.00,280.00,0.00,6075.71,1245520.55,1405582.80,160062.25,448362),('1','148','149831','327',205.00,280.00,0.00,6093.23,1249112.15,1400983.12,151870.97,448906),('1','148','149995','327',205.00,280.00,0.00,6042.48,1238708.40,1370535.68,131827.28,449338),('1','148','150145','327',205.00,280.00,0.00,4847.74,993786.70,1105895.20,112108.50,449733),('1','148','150364','327',222.00,280.00,0.00,1118.86,248386.92,313280.80,64893.88,450298),('1','148','150546','327',222.00,280.00,0.00,1601.53,355539.66,448428.40,92888.74,450786),('1','148','150709','327',222.00,280.00,0.00,1388.40,308224.80,388752.00,80527.20,451211),('1','148','150820','327',222.00,0.00,0.00,3971.26,881619.72,1111952.80,230333.08,451515),('1','148','150992','327',222.00,280.00,0.00,1269.19,281760.18,355373.20,73613.02,451959),('1','148','151147','327',222.00,280.00,0.00,1145.50,254301.00,320740.00,66439.00,452385),('1','148','151271','327',222.00,280.00,0.00,1112.05,246875.10,311374.00,64498.90,452728),('1','148','151426','327',222.00,280.00,0.00,1176.43,261167.46,329400.40,68232.94,453141),('1','148','151584','327',222.00,280.00,0.00,953.62,211703.64,267013.60,55309.96,453574),('1','148','151698','327',222.00,280.00,0.00,158.89,35273.58,44489.20,9215.62,453889),('1','148','151699','327',222.00,280.00,0.00,4552.77,1010714.94,1068215.60,57500.66,453890),('1','148','151854','327',222.00,280.00,0.00,1487.00,330114.00,352638.40,22524.40,454287),('1','148','152006','327',222.00,280.00,0.00,4563.76,1013154.72,1070126.08,56971.36,454709),('1','148','152161','327',222.00,280.00,0.00,1238.03,274842.66,284033.36,9190.70,455115),('1','148','152321','327',222.00,280.00,0.00,5839.75,1296424.50,1348845.84,52421.34,455538),('1','148','152475','327',205.00,280.00,0.00,2603.19,533653.95,606466.32,72812.37,455951),('1','148','152642','327',205.00,280.00,0.00,3505.22,718570.10,819152.32,100582.22,456388),('1','148','152758','327',205.00,280.00,0.00,4565.48,935923.40,1096152.40,160229.00,456715),('1','148','152893','327',205.00,280.00,0.00,1476.99,302782.95,355302.64,52519.69,457078),('1','148','153083','327',205.00,280.00,0.00,6067.71,1243880.55,1395564.24,151683.69,457578),('1','148','153272','327',205.00,280.00,0.00,3699.95,758489.75,857484.24,98994.49,458109),('1','148','153470','327',205.00,0.00,0.00,4658.73,955039.65,1084395.12,129355.47,458658),('1','148','153624','327',205.00,280.00,0.00,1412.45,289552.25,331376.56,41824.31,459068),('1','148','153770','327',205.00,280.00,0.00,6081.38,1246682.90,1397489.76,150806.86,459457),('1','148','153977','327',205.00,280.00,0.00,6066.44,1243620.20,1393917.76,150297.56,459985),('1','148','154053','327',205.00,280.00,0.00,2140.40,438782.00,492294.40,53512.40,460192),('1','148','154270','327',205.00,280.00,0.00,2648.98,543040.90,618185.44,75144.54,460768),('1','148','154401','327',224.00,280.00,0.00,800.09,179220.16,187113.84,7893.68,461120),('1','148','154436','327',224.00,280.00,0.00,887.12,198714.88,248393.60,49678.72,461211),('1','148','154575','327',224.00,280.00,0.00,1579.87,353890.88,402185.04,48294.16,461602),('1','148','154703','327',205.00,0.00,0.00,4502.14,922938.70,1049788.32,126849.62,461952),('1','148','154875','327',224.00,280.00,0.00,1124.84,251964.16,314955.20,62991.04,462423),('1','148','154919','327',224.00,280.00,0.00,1129.98,253115.52,316394.40,63278.88,462533),('1','148','155127','327',224.00,280.00,0.00,1242.36,278288.64,347860.80,69572.16,463104),('1','148','155303','327',224.00,280.00,0.00,1112.44,249186.56,311483.20,62296.64,463571),('1','148','155460','327',205.00,280.00,0.00,1385.27,283980.35,387875.60,103895.25,463984),('1','148','155641','327',205.00,280.00,0.00,6152.81,1261326.05,1395357.04,134030.99,464493),('1','148','155776','327',224.00,280.00,0.00,1539.43,344832.32,431040.40,86208.08,464853),('1','148','155905','327',224.00,280.00,0.00,6077.12,1245809.60,1701593.60,455784.00,465191),('1','148','156086','327',205.00,280.00,0.00,6081.93,1246795.65,1378414.32,131618.67,465661),('1','148','156190','327',205.00,280.00,0.00,3661.04,750513.20,809774.08,59260.88,465939),('1','148','156197','327',205.00,280.00,0.00,874.08,179186.40,244742.40,65556.00,465954),('1','148','156411','327',205.00,280.00,0.00,961.40,197087.00,269192.00,72105.00,466520),('1','148','156552','327',205.00,280.00,0.00,1010.92,207238.60,283057.60,75819.00,466909),('1','148','157079','327',224.00,280.00,0.00,245.95,55092.80,68866.00,13773.20,468320),('1','148','157082','327',205.00,280.00,0.00,1272.63,260889.15,356336.40,95447.25,468325),('1','148','157275','327',205.00,280.00,0.00,4783.37,980590.85,1079725.04,99134.19,468826),('1','148','157447','327',205.00,280.00,0.00,3314.28,679427.40,749338.56,69911.16,469265),('1','148','157665','327',205.00,280.00,0.00,6069.00,1244145.00,1374982.08,130837.08,469834),('1','148','157818','327',205.00,280.00,0.00,6067.00,1243735.00,1374697.28,130962.28,470244),('1','148','157947','327',205.00,280.00,0.00,2530.46,518744.30,578818.08,60073.78,470597),('1','148','158081','327',205.00,280.00,0.00,1115.77,228732.85,248054.00,19321.15,470942),('1','148','158258','327',205.00,280.00,0.00,5831.37,1195430.85,1324358.64,128927.79,471409),('1','148','158259','327',205.00,280.00,0.00,2151.60,441078.00,602448.00,161370.00,471410),('1','148','158566','327',205.00,280.00,0.00,1074.50,220272.50,300860.00,80587.50,472215),('1','148','158751','327',205.00,280.00,0.00,1129.44,231535.20,316243.20,84708.00,472702),('1','148','158926','327',205.00,280.00,0.00,1058.89,217072.45,296489.20,79416.75,473156),('1','148','159110','327',211.00,296.00,0.00,914.00,192854.00,270544.00,77690.00,473655),('1','148','159277','327',234.00,280.00,0.00,470.00,109980.00,139120.00,29140.00,474105),('1','148','159450','327',234.00,296.00,0.00,1091.29,255361.86,323021.84,67659.98,474528),('1','148','159737','327',234.00,296.00,0.00,1150.13,269130.42,340438.48,71308.06,475262),('1','148','159739','327',234.00,304.00,0.00,453.97,106228.98,138006.88,31777.90,475265),('1','148','159740','327',234.00,304.00,0.00,1111.00,259974.00,337744.00,77770.00,475266),('1','148','159936','327',234.00,304.00,0.00,6191.12,2067834.08,1529320.64,-538513.44,475791),('1','148','160105','327',211.00,304.00,0.00,6104.57,1288064.27,1497911.12,209846.85,476233),('1','148','160309','327',211.00,304.00,0.00,6088.16,1284601.76,1486772.96,202171.20,476751),('1','148','160453','327',211.00,320.00,0.00,4739.03,999935.33,1218376.80,218441.47,477134),('1','148','160595','327',211.00,320.00,0.00,401.73,84765.03,128553.60,43788.57,477504),('1','148','160597','327',211.00,320.00,0.00,432.62,91282.82,138438.40,47155.58,477506),('1','148','160741','327',211.00,320.00,0.00,1159.10,244570.10,370912.00,126341.90,477880),('1','148','160856','327',211.00,320.00,0.00,1013.63,213875.93,324361.60,110485.67,478160),('1','148','161077','327',211.00,320.00,0.00,1095.75,231203.25,350640.00,119436.75,478759),('1','148','161267','327',211.00,320.00,0.00,1522.72,321293.92,487270.40,165976.48,479243),('1','148','161447','327',234.00,320.00,0.00,1040.77,243540.18,333046.40,89506.22,479695),('1','148','161653','327',234.00,320.00,0.00,906.46,212111.64,290067.20,77955.56,480225),('1','148','161872','327',234.00,320.00,0.00,1030.96,241244.64,329907.20,88662.56,480763),('1','148','162038','327',234.00,320.00,0.00,1070.28,250445.52,342489.60,92044.08,481219),('1','148','162240','327',211.00,304.00,0.00,755.16,159338.76,229568.64,70229.88,481724),('1','148','162455','327',211.00,304.00,0.00,1047.83,221092.13,318540.32,97448.19,482278),('1','148','162635','327',211.00,304.00,0.00,1030.06,217342.66,313138.24,95795.58,482728),('1','148','162801','327',211.00,304.00,0.00,802.98,169428.78,244105.92,74677.14,483166),('1','148','163002','327',211.00,304.00,0.00,1106.90,233555.90,336497.60,102941.70,483696),('1','148','163196','327',211.00,304.00,0.00,1049.15,243941.01,318941.60,75000.59,484188),('1','148','163376','327',211.00,304.00,0.00,3780.82,797753.02,1019548.96,221795.94,484648),('1','148','163533','327',211.00,304.00,0.00,2312.41,487918.51,617312.80,129394.29,485078),('1','148','163739','327',211.00,304.00,0.00,1055.00,222605.00,285763.04,63158.04,485607),('1','148','163801','327',211.00,304.00,0.00,2603.68,549376.48,736534.48,187158.00,485756),('1','148','164075','327',211.00,304.00,0.00,1394.60,294260.60,407114.36,112853.76,486484),('1','148','164255','327',211.00,304.00,0.00,1140.22,240586.42,342023.92,101437.50,486958),('1','148','164445','327',211.00,304.00,0.00,995.94,210143.34,271040.76,60897.42,487462),('1','148','164601','327',211.00,304.00,0.00,2615.79,551931.69,737276.16,185344.47,487885),('1','148','164753','327',211.00,304.00,0.00,998.59,210702.49,273215.08,62512.59,488295),('1','148','164964','327',211.00,304.00,0.00,6093.32,1285690.52,1669654.52,383964.00,488835),('1','148','164967','327',211.00,304.00,0.00,1344.64,283719.04,373929.04,90210.00,488842),('1','148','164968','327',211.00,320.00,0.00,466.12,98351.32,141918.80,43567.48,488843),('1','148','165144','327',211.00,320.00,0.00,855.45,180499.95,269639.10,89139.15,489289),('1','148','165310','327',211.00,304.00,0.00,811.23,171169.53,246613.92,75444.39,489723),('1','148','165447','327',211.00,304.00,0.00,1019.83,215184.13,310028.32,94844.19,490080),('1','148','165620','327',211.00,304.00,0.00,2381.32,502458.52,689200.72,186742.20,490539),('1','148','165793','327',211.00,304.00,0.00,2608.89,550475.79,756952.08,206476.29,491008),('1','148','165968','327',211.00,304.00,0.00,2941.66,620690.26,847972.72,227282.46,491468),('1','148','166141','327',211.00,304.00,0.00,1054.34,222465.74,317335.28,94869.54,491920),('1','148','166332','327',211.00,304.00,0.00,2025.95,427475.45,575134.64,147659.19,492426),('1','148','166340','327',211.00,304.00,0.00,650.71,137299.81,183730.48,46430.67,492448),('1','148','166496','327',211.00,304.00,0.00,1065.26,224769.86,322720.88,97951.02,492875),('1','148','166693','327',211.00,304.00,0.00,2461.47,519370.17,708115.20,188745.03,493403),('1','148','166900','327',211.00,304.00,0.00,2554.82,605492.34,725864.00,120371.66,493957),('1','148','166902','327',237.00,304.00,0.00,443.00,104991.00,125515.28,20524.28,493961),('1','148','167379','327',237.00,304.00,0.00,1470.14,348423.18,415883.12,67459.94,495247),('1','148','167381','327',237.00,304.00,0.00,3397.78,805273.86,976909.12,171635.26,495249),('1','148','167382','327',237.00,304.00,0.00,1219.71,289071.27,344848.32,55777.05,495250),('1','148','167567','327',237.00,304.00,0.00,1115.75,264432.75,336412.88,71980.13,495741),('1','148','167747','327',237.00,304.00,0.00,2398.00,568326.00,677771.44,109445.44,496204),('1','148','167916','327',237.00,304.00,0.00,2834.79,671845.23,813372.48,141527.25,496657),('1','148','168114','327',237.00,304.00,0.00,3255.80,771624.60,920473.28,148848.68,497184),('1','148','168286','327',237.00,304.00,0.00,1153.60,273403.20,347172.88,73769.68,497645),('1','148','168406','327',237.00,304.00,0.00,2815.63,667304.31,800055.52,132751.21,497973),('1','148','168621','327',237.00,304.00,0.00,1369.72,324623.64,407704.72,83081.08,498533),('1','148','168769','327',237.00,304.00,0.00,2034.85,482259.45,591627.52,109368.07,498937),('1','148','168937','327',237.00,304.00,0.00,2694.65,638632.05,762245.60,123613.55,499371),('1','148','169107','327',237.00,304.00,0.00,2780.15,658895.55,803805.92,144910.37,499803),('1','148','169128','327',237.00,304.00,0.00,4602.16,1090711.92,1304795.44,214083.52,499855),('1','148','169267','327',237.00,304.00,0.00,1146.00,271602.00,332008.32,60406.32,500211),('1','148','169449','327',237.00,304.00,0.00,4798.38,1137216.06,1415584.92,278368.86,500680),('1','148','169570','327',237.00,304.00,0.00,1298.00,307626.00,384222.08,76596.08,500996),('1','148','169769','327',237.00,304.00,0.00,3668.24,869372.88,1088006.84,218633.96,501528),('1','148','169921','327',237.00,304.00,0.00,2431.42,576246.54,716110.48,139863.94,501950),('1','148','170141','327',237.00,304.00,0.00,2251.84,533686.08,675165.04,141478.96,502503),('1','148','170333','327',237.00,304.00,0.00,2987.26,707980.62,889124.56,181143.94,503002),('1','148','170617','327',137.00,304.00,0.00,919.28,125941.36,274985.00,149043.64,503749),('1','148','170622','327',237.00,304.00,0.00,1561.63,370106.31,474735.52,104629.21,503760),('1','148','170626','327',281.00,304.00,0.00,347.83,97740.23,105740.32,8000.09,503769),('1','148','170760','327',281.00,304.00,0.00,1085.43,305005.83,329970.72,24964.89,504124),('1','148','170849','327',281.00,320.00,0.00,825.05,231839.05,264016.00,32176.95,504348),('1','148','171054','327',281.00,320.00,0.00,1630.80,458254.80,521856.00,63601.20,504900),('1','148','171254','327',281.00,320.00,0.00,1041.95,292787.95,333424.00,40636.05,505437),('1','148','171371','327',281.00,320.00,0.00,1931.99,457881.63,618236.80,160355.17,505741),('1','148','171623','327',237.00,320.00,0.00,1225.83,290521.71,392265.60,101743.89,506418),('1','148','171828','327',237.00,0.00,0.00,1444.09,342249.33,462108.80,119859.47,506955),('1','148','172090','327',261.00,320.00,0.00,1400.00,365400.00,448000.00,82600.00,507641),('1','148','172092','327',261.00,320.00,0.00,1463.82,382057.02,468422.40,86365.38,507643),('1','148','172339','327',261.00,320.00,0.00,1706.13,445299.93,545961.60,100661.67,508319),('1','148','172526','327',261.00,320.00,0.00,1777.90,464031.90,568928.00,104896.10,508810),('1','148','172710','327',261.00,0.00,0.00,711.80,197880.40,227776.00,29895.60,509290),('1','148','172874','327',278.00,320.00,0.00,1269.20,352837.60,393953.08,41115.48,509729),('1','148','173049','327',278.00,320.00,0.00,1503.67,418020.26,481174.40,63154.14,510192),('1','148','173275','327',278.00,320.00,0.00,1126.19,313080.82,360380.80,47299.98,510785),('1','148','173378','327',278.00,320.00,0.00,2167.03,602434.34,680199.72,77765.38,511064),('1','148','173679','327',278.00,320.00,0.00,4454.68,1238401.04,1340717.52,102316.48,511863),('1','148','173744','327',278.00,320.00,0.00,1630.36,453240.08,492893.12,39653.04,512046),('1','148','174022','327',278.00,320.00,0.00,6068.66,1687087.48,1811915.40,124827.92,512776),('1','148','174121','327',278.00,320.00,0.00,720.78,200376.84,213579.12,13202.28,513039),('1','148','174315','327',278.00,320.00,0.00,1430.39,397648.42,457724.80,60076.38,513542),('1','148','174483','327',278.00,320.00,0.00,4648.27,1292219.06,1396569.32,104350.26,513967),('1','148','174640','327',278.00,320.00,0.00,4030.32,1120428.96,1216233.76,95804.80,514364),('1','148','174836','327',278.00,320.00,0.00,2036.68,566197.04,606222.20,40025.16,514891),('1','148','174908','327',278.00,320.00,0.00,2746.40,796456.00,823783.76,27327.76,515076),('1','148','175032','327',290.00,360.00,0.00,523.06,151687.40,188301.60,36614.20,515409),('1','148','175226','327',290.00,360.00,0.00,717.33,208025.70,258238.80,50213.10,515927),('1','148','175403','327',290.00,320.00,0.00,812.33,235575.70,292438.80,56863.10,516386),('1','148','175506','327',290.00,360.00,0.00,1285.00,372650.00,462600.00,89950.00,516652),('1','148','175591','327',300.00,360.00,0.00,378.66,113598.00,136317.60,22719.60,516872),('1','148','175747','327',300.00,360.00,0.00,1516.99,455097.00,546116.40,91019.40,517290),('1','148','175914','327',290.00,360.00,0.00,4428.85,1284366.50,1449608.88,165242.38,517721),('1','148','176142','327',290.00,360.00,0.00,1661.00,481690.00,533895.84,52205.84,518297),('1','148','176316','327',290.00,360.00,0.00,3334.10,966889.00,1107737.76,140848.76,518747),('1','148','176533','327',290.00,360.00,0.00,2707.88,785285.20,874804.80,89519.60,519315),('1','148','176823','327',290.00,360.00,0.00,926.66,268731.40,333597.60,64866.20,520086),('1','148','177273','327',293.00,360.00,0.00,216.88,63545.84,78076.80,14530.96,521271),('1','148','177276','327',293.00,360.00,0.00,3835.29,1123739.97,1264552.56,140812.59,521278),('1','148','177418','327',293.00,360.00,0.00,1985.99,581895.07,639399.12,57504.05,521644),('1','148','177612','327',293.00,360.00,0.00,1241.36,363718.48,446889.60,83171.12,522176),('1','148','177867','327',293.00,360.00,0.00,1416.55,415049.15,509958.00,94908.85,522861),('1','148','178122','327',293.00,360.00,0.00,3355.22,983079.46,1046828.64,63749.18,523528),('1','148','178280','327',293.00,360.00,0.00,763.99,223849.07,275036.40,51187.33,523937),('1','148','178471','327',293.00,360.00,0.00,4523.69,1325441.17,1479957.84,154516.67,524438),('1','148','178702','327',293.00,360.00,0.00,767.59,224903.87,255863.32,30959.45,525047),('1','148','178882','327',293.00,360.00,0.00,1406.52,412110.36,506347.20,94236.84,525519),('1','148','179054','327',293.00,360.00,0.00,1535.58,449924.94,507869.24,57944.30,525957),('1','148','179146','327',293.00,360.00,0.00,2202.06,645203.58,755827.60,110624.02,526196),('1','148','179394','327',293.00,360.00,0.00,807.50,236597.50,267710.00,31112.50,526862),('1','148','179441','327',293.00,360.00,0.00,479.72,140557.96,157879.20,17321.24,526994),('1','148','179592','327',288.00,360.00,0.00,1335.89,384736.32,480920.40,96184.08,527382),('1','148','179794','327',288.00,360.00,0.00,3316.91,955270.08,1098097.78,142827.70,527924),('1','148','180015','327',288.00,360.00,0.00,1301.50,374832.00,447716.00,72884.00,528495),('1','148','180100','327',288.00,360.00,0.00,463.50,133488.00,166860.00,33372.00,528734),('1','148','180187','327',288.00,360.00,0.00,3638.98,1120805.84,1223462.82,102656.98,528949),('1','148','180357','327',308.00,360.00,0.00,2384.35,734379.80,785996.00,51616.20,529379),('1','148','180589','327',308.00,360.00,0.00,746.39,229888.12,268700.40,38812.28,530002),('1','148','180744','327',308.00,360.00,0.00,1387.80,427442.40,493106.40,65664.00,530402),('1','148','181017','327',308.00,360.00,0.00,1106.67,340854.36,398401.20,57546.84,531139),('1','148','181135','327',308.00,360.00,0.00,2773.73,854308.84,894782.80,40473.96,531448),('1','148','181388','327',308.00,360.00,0.00,1482.24,456529.92,533606.40,77076.48,532119),('1','148','181568','327',308.00,360.00,0.00,4023.80,1239330.40,1343670.80,104340.40,532596),('1','148','181710','327',308.00,360.00,0.00,1955.44,602275.52,644838.40,42562.88,532969),('1','148','181975','327',308.00,360.00,0.00,1393.68,429253.44,501724.80,72471.36,533695),('1','148','182112','327',308.00,360.00,0.00,1356.34,417752.72,488282.40,70529.68,534052),('1','148','182383','327',308.00,360.00,0.00,3211.68,989197.44,1046764.80,57567.36,534756),('1','148','182451','327',308.00,360.00,0.00,295.92,91143.36,96531.20,5387.84,534953),('1','148','182504','327',308.00,360.00,0.00,1160.28,362866.24,417700.80,54834.56,535081),('1','148','183225','327',313.00,360.00,0.00,713.66,223375.58,256917.60,33542.02,536991),('1','148','183228','327',313.00,360.00,0.00,3958.00,1238854.00,1300669.20,61815.20,536998),('1','148','183233','327',313.00,360.00,0.00,4552.38,1424894.94,1497714.00,72819.06,537010),('1','148','183251','327',313.00,360.00,0.00,783.00,245079.00,255552.40,10473.40,537050),('1','148','183623','327',313.00,360.00,0.00,2869.48,898147.24,1033012.80,134865.56,538051),('1','148','183847','327',313.00,360.00,0.00,1216.55,380780.15,437958.00,57177.85,538640),('1','148','184121','327',313.00,360.00,0.00,1880.00,588440.00,614712.80,26272.80,539360),('1','148','184245','327',313.00,360.00,0.00,4061.11,1271127.43,1354737.20,83609.77,539699),('1','148','184572','327',313.00,360.00,0.00,1958.56,613029.28,639102.40,26073.12,540552),('1','148','184754','327',313.00,360.00,0.00,2030.68,635602.84,689924.00,54321.16,541043),('1','148','184857','327',313.00,360.00,0.00,1388.32,434544.16,461660.80,27116.64,541326),('1','148','185079','327',313.00,360.00,0.00,1137.45,356021.85,409482.00,53460.15,541897),('1','148','185241','327',313.00,360.00,0.00,1402.23,438897.99,504802.80,65904.81,542303),('1','148','185436','327',313.00,360.00,0.00,2084.00,652292.00,680392.40,28100.40,542819),('1','148','186236','327',313.00,360.00,0.00,3554.47,1112549.11,1211167.28,98618.17,544941),('1','148','186237','327',313.00,360.00,0.00,1888.00,590944.00,621006.80,30062.80,544942),('1','148','186292','327',313.00,360.00,0.00,2692.90,842877.70,904422.88,61545.18,545083),('1','148','186466','327',313.00,360.00,0.00,1402.23,438897.99,504802.80,65904.81,545544),('1','148','186499','327',313.00,360.00,0.00,1925.70,602744.10,641946.08,39201.98,545630),('1','148','186712','327',313.00,360.00,0.00,1103.88,345514.44,397396.80,51882.36,546180),('1','148','186949','327',313.00,360.00,0.00,3012.60,942943.80,1028349.44,85405.64,546771),('1','148','187142','327',313.00,360.00,0.00,1916.00,599708.00,641994.88,42286.88,547293),('1','148','187310','327',313.00,360.00,0.00,3643.26,1140340.38,1239828.00,99487.62,547728),('1','148','187543','327',313.00,360.00,0.00,1175.12,367812.56,393230.72,25418.16,548347),('1','148','187880','327',313.00,360.00,0.00,1412.55,442128.15,508518.00,66389.85,549224),('1','148','188101','327',313.00,360.00,0.00,4601.45,1440253.85,1539856.72,99602.87,549799),('1','148','188189','327',313.00,360.00,0.00,1151.32,360363.16,398066.56,37703.40,550044),('1','148','188302','327',313.00,360.00,0.00,3530.60,1105077.80,1203574.40,98496.60,550330),('1','148','188493','327',313.00,360.00,0.00,315.87,98867.31,113713.20,14845.89,550815),('1','148','188704','327',313.00,360.00,0.00,1086.13,339958.69,356250.64,16291.95,551358),('1','148','188718','327',313.00,360.00,0.00,732.01,229119.13,263523.60,34404.47,551396),('1','148','188893','327',313.00,360.00,0.00,3627.45,1135391.85,1234976.72,99584.87,551862),('1','148','189084','327',313.00,360.00,0.00,2266.00,709258.00,757239.68,47981.68,552360),('1','148','189280','327',313.00,360.00,0.00,2628.77,822805.01,907459.92,84654.91,552872),('1','148','189457','327',313.00,360.00,0.00,2941.18,920589.34,1005850.40,85261.06,553333),('1','148','189677','327',313.00,360.00,0.00,0.00,0.00,0.00,0.00,553900),('1','148','189679','327',313.00,360.00,0.00,2861.70,895712.10,948900.32,53188.22,553904),('1','148','190039','327',313.00,360.00,0.00,3516.15,1100554.95,1198527.28,97972.33,554839),('1','148','190247','327',313.00,360.00,0.00,2500.74,782731.62,837328.16,54596.54,555381),('1','148','190455','327',313.00,360.00,0.00,3181.77,995894.01,1085821.20,89927.19,555924),('1','148','190861','327',313.00,360.00,0.00,1200.71,375822.23,432255.60,56433.37,557021),('1','148','191131','327',313.00,360.00,0.00,3123.37,977614.81,1069766.48,92151.67,557708),('1','148','191336','327',313.00,360.00,0.00,1565.00,489845.00,523628.48,33783.48,558247),('1','148','191678','327',323.00,360.00,0.00,1455.88,470249.24,524116.80,53867.56,559178),('1','148','191738','327',323.00,360.00,0.00,1522.88,491890.24,548236.80,56346.56,559311),('1','148','192084','327',323.00,360.00,0.00,1422.88,459590.24,512236.80,52646.56,560254),('1','148','192143','327',323.00,360.00,0.00,943.00,304589.00,339480.00,34891.00,560394),('1','148','192350','327',323.00,360.00,0.00,3937.08,1232591.04,1336618.56,104027.52,560935),('1','148','192654','327',313.00,360.00,0.00,2101.54,657782.02,704874.40,47092.38,561732),('1','148','192787','327',313.00,360.00,0.00,3024.04,946524.52,1036948.16,90423.64,562067),('1','148','192989','327',313.00,360.00,0.00,2692.27,842680.51,904572.08,61891.57,562602),('1','148','193222','327',313.00,360.00,0.00,1510.41,472758.33,505841.36,33083.03,563228),('1','148','193602','327',313.00,360.00,0.00,1356.08,424453.04,455156.80,30703.76,564237),('1','148','193636','327',313.00,360.00,0.00,1412.12,441993.56,508363.20,66369.64,564303),('1','148','193974','327',313.00,360.00,0.00,2040.56,638695.28,734601.60,95906.32,565157),('1','148','194120','327',313.00,360.00,0.00,1208.46,378247.98,402245.60,23997.62,565511),('1','148','194331','327',313.00,360.00,0.00,4511.79,1412190.27,1511977.84,99787.57,566068),('1','148','194509','327',313.00,360.00,0.00,1354.01,423805.13,454606.48,30801.35,566513),('1','148','194686','327',313.00,360.00,0.00,1107.21,346556.73,398595.60,52038.87,566959),('1','148','195054','327',313.00,360.00,0.00,3837.59,1201165.67,1303970.16,102804.49,567947),('1','148','195137','327',313.00,360.00,0.00,2216.43,693742.59,747077.04,53334.45,568152),('1','148','195390','327',313.00,360.00,0.00,1412.23,442027.99,508402.80,66374.81,568804),('1','148','195656','327',313.00,360.00,0.00,4619.42,1445878.46,1560495.20,114616.74,569458),('1','148','195874','327',313.00,360.00,0.00,1367.71,428093.23,462587.44,34494.21,570015),('1','148','196190','327',313.00,360.00,0.00,3547.75,1110445.75,1208917.04,98471.29,570822),('1','148','196396','327',313.00,360.00,0.00,2441.84,764295.92,821334.40,57038.48,571356),('1','148','196630','327',321.00,360.00,0.00,1440.36,462355.56,518529.60,56174.04,571965),('1','148','196713','327',321.00,360.00,0.00,1410.36,452725.56,507729.60,55004.04,572160),('1','148','196912','327',321.00,360.00,0.00,3220.11,1008272.27,1055527.92,47255.65,572684),('1','148','197199','327',313.00,360.00,0.00,898.00,281074.00,298199.52,17125.52,573445),('1','148','197345','327',323.00,360.00,0.00,1455.28,470055.44,523900.80,53845.36,573820),('1','148','197486','327',323.00,360.00,0.00,1631.40,526942.20,587304.00,60361.80,574106),('1','148','197970','327',323.00,360.00,0.00,1422.77,459554.71,512197.20,52642.49,575378),('1','148','198203','327',323.00,360.00,0.00,1614.26,521405.98,581133.60,59727.62,575963),('1','148','198219','327',323.00,360.00,0.00,1515.71,465322.97,545655.60,80332.63,576000),('1','148','198541','327',307.00,360.00,0.00,4517.00,1386719.00,1464985.60,78266.60,576871),('1','148','198738','327',307.00,360.00,0.00,6049.00,1857043.00,1992348.80,135305.80,577380),('1','148','198961','327',307.00,360.00,0.00,1380.96,423954.72,458470.40,34515.68,577927),('1','148','199401','327',307.00,360.00,0.00,4029.00,1236903.00,1346424.80,109521.80,579012),('1','148','199405','327',307.00,360.00,0.00,2006.00,615842.00,654656.80,38814.80,579023),('1','148','199750','327',307.00,360.00,0.00,3430.47,1053154.29,1154055.60,100901.31,579856),('1','148','199965','327',307.00,360.00,0.00,2535.82,778496.74,832815.20,54318.46,580419),('1','148','200070','327',307.00,360.00,0.00,696.00,213672.00,227470.80,13798.80,580699),('1','148','200273','327',307.00,360.00,0.00,2029.15,622949.05,673821.20,50872.15,581230),('1','148','200526','327',307.00,360.00,0.00,3973.68,1219919.76,1328204.80,108285.04,581871),('1','148','200538','327',307.00,360.00,0.00,3421.09,1050274.63,1151216.80,100942.17,581902),('1','148','200569','327',307.00,360.00,0.00,2581.33,792468.31,848718.80,56250.49,581988),('1','148','200673','327',307.00,360.00,0.00,902.03,276923.21,293170.80,16247.59,582275),('1','148','200726','327',307.00,360.00,0.00,1543.55,473869.85,512628.80,38758.95,582395),('1','148','201166','327',307.00,360.00,0.00,723.87,222228.09,260593.20,38365.11,583507),('1','148','201167','327',307.00,360.00,0.00,819.66,251635.62,295077.60,43441.98,583508),('1','148','201479','327',307.00,360.00,0.00,2963.31,909736.17,991711.60,81975.43,584343),('1','148','201854','327',307.00,360.00,0.00,6046.76,1856355.32,1991588.40,135233.08,585328),('1','148','201861','327',307.00,360.00,0.00,876.71,269149.97,282060.40,12910.43,585346),('1','148','202155','327',317.00,360.00,0.00,3813.96,1209025.32,1306146.48,97121.16,586110),('1','148','202158','327',317.00,360.00,0.00,1552.10,492015.70,525986.88,33971.18,586117),('1','148','202403','327',317.00,360.00,0.00,712.33,225808.61,256438.80,30630.19,586751),('1','148','202619','327',317.00,360.00,0.00,1488.63,471895.71,535906.80,64011.09,587303),('1','148','202818','327',317.00,360.00,0.00,1549.04,491045.68,557654.40,66608.72,587815),('1','148','203083','327',337.00,360.00,0.00,1000.02,337006.74,360007.20,23000.46,588506),('1','148','203246','327',337.00,360.00,0.00,1486.71,501021.27,535215.60,34194.33,588932),('1','148','203472','327',337.00,360.00,0.00,3231.68,1089076.16,1110116.16,21040.00,589508),('1','148','203701','327',337.00,360.00,0.00,3824.24,1288768.88,1320926.40,32157.52,590104),('1','148','204007','327',337.00,376.00,0.00,3231.49,1215040.24,1092435.84,-122604.40,590871),('1','148','204029','327',376.00,376.00,0.00,1017.32,382512.32,382512.32,0.00,590930),('1','148','204484','327',376.00,376.00,0.00,795.40,299070.40,279958.08,-19112.32,592124),('1','148','204495','327',376.00,376.00,0.00,4866.11,1518226.32,1715027.60,196801.28,592149),('1','148','204695','327',312.00,376.00,0.00,1140.96,355979.52,401291.20,45311.68,592654),('1','148','204864','327',312.00,376.00,0.00,3235.38,1009438.56,1149467.68,140029.12,593051),('1','148','205177','327',312.00,376.00,0.00,2742.09,855532.08,983025.52,127493.44,593876),('1','148','205297','327',312.00,376.00,0.00,1690.99,527588.88,594500.88,66912.00,594181),('1','148','205553','327',312.00,376.00,0.00,2179.01,679851.12,791408.88,111557.76,594831),('1','148','205822','327',312.00,376.00,0.00,2700.35,842509.20,960933.84,118424.64,595531),('1','148','205998','327',312.00,376.00,0.00,1081.88,337546.56,384622.40,47075.84,595987),('1','148','206288','327',312.00,376.00,0.00,1779.07,555069.84,627076.56,72006.72,596736),('1','148','206298','327',312.00,376.00,0.00,2281.81,711924.72,816684.08,104759.36,596761),('1','148','206553','327',312.00,376.00,0.00,2505.13,781600.56,887518.96,105918.40,597413),('1','148','206556','327',312.00,376.00,0.00,805.04,256002.72,284790.40,28787.68,597420),('1','148','206741','327',318.00,376.00,0.00,3550.32,1129001.76,1272059.20,143057.44,597895),('1','148','207002','327',318.00,376.00,0.00,1010.00,321180.00,358951.68,37771.68,598578),('1','148','207003','327',318.00,376.00,0.00,2417.20,768669.60,863409.28,94739.68,598579),('1','148','207201','327',318.00,376.00,0.00,2274.83,723395.94,816474.96,93079.02,599084),('1','148','207377','327',318.00,376.00,0.00,645.60,205300.80,233145.60,27844.80,599525),('1','148','207556','327',318.00,376.00,0.00,867.21,275772.78,314220.72,38447.94,599985),('1','148','207570','327',318.00,376.00,0.00,990.50,314979.00,340732.00,25753.00,600025),('1','148','207580','327',318.00,376.00,0.00,4948.59,1573651.62,1751361.36,177709.74,600051),('1','148','207805','327',318.00,376.00,0.00,360.95,114782.10,124166.80,9384.70,600619),('1','148','207854','327',318.00,376.00,0.00,1502.47,576948.48,554345.60,-22602.88,600754),('1','148','208008','327',384.00,384.00,0.00,2473.64,949877.76,913566.72,-36311.04,601142),('1','148','208204','327',384.00,384.00,0.00,1352.66,519421.44,496260.48,-23160.96,601644),('1','148','208455','327',384.00,384.00,0.00,2817.66,912921.84,1023958.40,111036.56,602287),('1','148','208486','327',324.00,384.00,0.00,1815.96,588371.04,653585.92,65214.88,602374),('1','148','208667','327',324.00,384.00,0.00,382.52,123396.48,142535.68,19139.20,602835),('1','148','208727','327',318.00,384.00,0.00,3479.60,1106512.80,1253825.92,147313.12,603006),('1','148','208901','327',318.00,384.00,0.00,2280.76,725281.68,819396.48,94114.80,603421),('1','148','209073','327',318.00,384.00,0.00,870.48,276812.64,319488.64,42676.00,603856),('1','148','209095','327',318.00,384.00,0.00,102.98,33571.48,39544.32,5972.84,603912),('1','148','209099','327',326.00,384.00,0.00,597.04,194635.04,211848.96,17213.92,603922),('1','148','209135','327',400.00,400.00,0.00,1441.72,576688.00,551748.96,-24939.04,604018),('1','148','209333','327',400.00,400.00,0.00,2621.90,1048760.00,997957.64,-50802.36,604522),('1','148','209608','327',400.00,400.00,0.00,2595.00,835590.00,991700.88,156110.88,605247),('1','148','209681','327',322.00,400.00,0.00,1765.86,568606.92,663390.88,94783.96,605413),('1','148','209983','327',322.00,400.00,0.00,2723.20,882316.80,1044113.20,161796.40,606200),('1','148','209986','327',324.00,400.00,0.00,2430.30,1020726.00,959870.92,-60855.08,606205),('1','148','210192','327',420.00,420.00,0.00,554.83,179764.92,213020.48,33255.56,606740),('1','148','210197','327',324.00,420.00,0.00,940.08,304585.92,394833.60,90247.68,606752),('1','148','210414','327',324.00,420.00,0.00,1130.41,366252.84,474772.20,108519.36,607318),('1','148','210830','327',324.00,420.00,0.00,959.28,310806.72,402897.60,92090.88,608414),('1','148','210838','327',324.00,420.00,0.00,1330.90,431211.60,558978.00,127766.40,608432),('1','148','211095','327',324.00,420.00,0.00,219.03,71403.78,91992.60,20588.82,609098),('1','148','211101','327',326.00,420.00,0.00,2217.27,722830.02,931253.40,208423.38,609114),('1','148','211457','327',326.00,420.00,0.00,433.56,141340.56,182095.20,40754.64,610030),('1','148','211471','327',326.00,420.00,0.00,949.49,309533.74,368187.76,58654.02,610070),('1','148','211499','327',326.00,420.00,0.00,1482.15,483180.90,565315.32,82134.42,610144),('1','148','211758','327',360.00,420.00,0.00,1920.25,691290.00,759463.28,68173.28,610811),('1','148','211759','327',360.00,420.00,0.00,3029.23,1090522.80,1170073.84,79551.04,610812),('1','148','212087','327',360.00,420.00,0.00,1051.85,378666.00,419022.40,40356.40,611659),('1','148','212109','327',360.00,420.00,0.00,310.05,111618.00,130221.00,18603.00,611722),('1','148','212112','327',360.00,420.00,0.00,1584.87,570553.20,665645.40,95092.20,611729),('1','148','212305','327',360.00,420.00,0.00,1170.41,421347.60,491572.20,70224.60,612231),('1','148','212998','327',360.00,420.00,0.00,314.83,113338.80,132228.60,18889.80,614059),('1','148','213006','327',360.00,420.00,0.00,1081.74,389426.40,454330.80,64904.40,614079),('1','148','213015','327',360.00,420.00,0.00,687.70,247572.00,288834.00,41262.00,614102),('1','148','213226','327',360.00,420.00,0.00,1200.01,463203.86,504004.20,40800.34,614647),('1','148','213241','327',386.00,420.00,0.00,2697.97,1041416.42,1086891.68,45475.26,614682),('1','148','213554','327',386.00,420.00,0.00,806.17,311181.62,322814.24,11632.62,615508),('1','148','213723','327',386.00,420.00,0.00,2644.99,1020966.14,1051429.96,30463.82,615950),('1','148','213732','327',386.00,420.00,0.00,2566.93,990834.98,1035212.92,44377.94,615970),('1','148','213984','327',386.00,420.00,0.00,3474.97,1341338.42,1394501.64,53163.22,616631),('1','148','214507','327',386.00,420.00,0.00,1921.14,741560.04,773026.80,31466.76,617991),('1','148','214639','327',386.00,420.00,0.00,3572.97,1379166.42,1456904.12,77737.70,618325),('1','148','214664','327',386.00,420.00,0.00,2111.11,814888.46,873118.40,58229.94,618385),('1','148','214890','327',386.00,420.00,0.00,2668.21,1029929.06,1086679.72,56750.66,618983),('1','148','215140','327',386.00,420.00,0.00,2255.78,947002.60,918627.64,-28374.96,619638),('1','148','215329','327',420.00,420.00,0.00,533.32,238927.36,230134.72,-8792.64,620120),('1','148','215485','327',448.00,448.00,0.00,962.95,371698.70,431401.60,59702.90,620506),('1','148','215499','327',386.00,448.00,0.00,1235.47,476891.42,425001.68,-51889.74,620546),('1','148','215504','327',386.00,448.00,0.00,1891.84,730250.24,835636.48,105386.24,620559),('1','148','215738','327',386.00,448.00,0.00,1299.85,501742.10,553653.76,51911.66,621166),('1','148','216203','327',386.00,448.00,0.00,941.00,363226.00,421568.00,58342.00,622368),('1','148','216209','327',386.00,448.00,0.00,2746.05,1059975.30,1190534.72,130559.42,622384),('1','148','216256','327',386.00,448.00,0.00,2415.46,932367.56,1036910.72,104543.16,622512),('1','148','216413','327',386.00,448.00,0.00,3327.37,1503971.24,1429636.28,-74334.96,622918),('1','148','216707','327',452.00,452.00,0.00,2003.45,905559.40,869559.40,-36000.00,623702),('1','148','216944','327',452.00,452.00,0.00,497.93,192200.98,225064.36,32863.38,624327),('1','148','217120','327',386.00,452.00,0.00,1737.24,670574.64,785232.48,114657.84,624776),('1','148','217129','327',386.00,452.00,0.00,673.80,321968.88,322990.56,1021.68,624799),('1','148','217391','327',431.00,480.00,0.00,377.15,162551.65,181032.00,18480.35,625490),('1','148','217397','327',431.00,480.00,0.00,2106.06,907711.86,1010908.80,103196.94,625505),('1','148','217838','327',431.00,480.00,0.00,1132.21,487982.51,543460.80,55478.29,626663),('1','148','217849','327',431.00,480.00,0.00,1133.28,488443.68,543974.40,55530.72,626691),('1','148','218054','327',431.00,480.00,0.00,1745.31,752228.61,837748.80,85520.19,627222),('1','148','218300','327',431.00,480.00,0.00,2041.97,880089.07,941520.80,61431.73,627876),('1','148','218525','327',431.00,480.00,0.00,1589.26,684971.06,733958.00,48986.94,628464),('1','148','218744','327',431.00,480.00,0.00,2492.50,1074267.50,1138634.40,64366.90,629020),('1','148','218978','327',431.00,480.00,0.00,2365.11,1019362.41,1079848.00,60485.59,629636),('1','148','219349','327',431.00,480.00,0.00,3117.18,1343504.58,1423062.40,79557.82,630605),('1','148','219375','327',431.00,480.00,0.00,1596.40,688048.40,723626.80,35578.40,630672),('1','148','219577','327',431.00,480.00,0.00,277.00,119387.00,132960.00,13573.00,631221),('1','148','219578','327',431.00,480.00,0.00,2289.64,986834.84,1044925.20,58090.36,631222),('1','148','219795','327',431.00,480.00,0.00,1962.70,845923.70,902086.80,56163.10,631796),('1','148','220065','327',431.00,480.00,0.00,1000.00,431000.00,441600.00,10600.00,632496),('1','148','220233','327',431.00,480.00,0.00,1965.13,846971.03,890771.04,43800.01,632952),('1','148','220237','327',431.00,480.00,0.00,2157.02,929675.62,976748.16,47072.54,632960),('1','148','220469','327',431.00,480.00,0.00,1476.52,636380.12,657333.60,20953.48,633562),('1','148','220695','327',431.00,480.00,0.00,1499.94,646474.14,685131.84,38657.70,634147),('1','148','220697','327',431.00,480.00,0.00,3056.78,1317472.18,1388667.84,71195.66,634151),('1','148','221037','327',431.00,480.00,0.00,939.93,405109.83,414426.72,9316.89,635037),('1','148','221258','327',431.00,480.00,0.00,550.54,237282.74,249833.28,12550.54,635617),('1','148','221260','327',431.00,480.00,0.00,3374.61,1454456.91,1506312.00,51855.09,635621),('1','148','221399','327',431.00,480.00,0.00,2813.44,1212592.64,1251529.44,38936.80,635980),('1','148','221485','327',431.00,480.00,0.00,3999.46,1723767.26,1779300.96,55533.70,636208),('1','148','221667','327',431.00,480.00,0.00,1041.07,448701.17,454329.12,5627.95,636682),('1','148','221825','327',431.00,480.00,0.00,3183.43,1372058.33,1423745.28,51686.95,637103),('1','148','221902','327',431.00,480.00,0.00,1734.10,747397.10,826128.00,78730.90,637288),('1','148','222237','327',431.00,480.00,0.00,2308.90,995135.90,1047854.40,52718.50,638164),('1','148','222369','327',431.00,480.00,0.00,3417.11,1472774.41,1524496.32,51721.91,638498),('1','148','222377','327',436.00,480.00,0.00,744.88,324767.68,321788.16,-2979.52,638520),('1','148','222378','327',436.00,480.00,0.00,2335.55,1018299.80,1121064.00,102764.20,638521),('1','148','222700','327',436.00,480.00,0.00,1818.65,792931.40,872952.00,80020.60,639377),('1','148','222821','327',436.00,480.00,0.00,1033.89,450776.04,496267.20,45491.16,639681),('1','148','222975','327',436.00,480.00,0.00,1553.38,677273.68,745622.40,68348.72,640102),('1','148','223222','327',436.00,480.00,0.00,1665.95,726354.20,799656.00,73301.80,640723),('1','148','223493','327',436.00,480.00,0.00,499.04,217581.44,239539.20,21957.76,641400),('1','148','223495','327',436.00,480.00,0.00,2984.74,1301346.64,1408668.00,107321.36,641404),('1','148','223698','327',436.00,480.00,0.00,1636.22,837744.64,771291.52,-66453.12,641920),('1','148','223925','327',459.00,512.00,0.00,3843.04,1763955.36,1831379.84,67424.48,642505),('1','148','223928','327',459.00,512.00,0.00,246.96,113354.64,117991.20,4636.56,642511),('1','148','224172','327',459.00,512.00,0.00,2854.58,1310252.22,1372961.92,62709.70,643144),('1','148','224182','327',459.00,512.00,0.00,1385.73,636050.07,650204.16,14154.09,643171),('1','148','224371','327',459.00,512.00,0.00,3106.83,1426034.97,1490482.08,64447.11,643662),('1','148','224379','327',459.00,512.00,0.00,2013.00,1014756.00,991067.00,-23689.00,643682),('1','148','224620','327',512.00,512.00,0.00,1859.80,853648.20,935497.38,81849.18,644324),('1','148','224635','327',459.00,512.00,0.00,3210.58,1473656.22,1596815.06,123158.84,644362),('1','148','224782','327',459.00,512.00,0.00,2730.26,1253189.34,1363299.22,110109.88,644731),('1','148','225027','327',459.00,512.00,0.00,1002.45,460124.55,485185.80,25061.25,645356),('1','148','225032','327',459.00,512.00,0.00,1526.57,700695.63,747157.96,46462.33,645368),('1','148','225273','327',459.00,512.00,0.00,1662.26,762977.34,826936.64,63959.30,645993),('1','148','225282','327',459.00,512.00,0.00,601.13,275918.67,214002.28,-61916.39,646007),('1','148','225285','327',459.00,512.00,0.00,3656.27,1678227.93,1801839.16,123611.23,646012),('1','148','225498','327',459.00,512.00,0.00,508.98,234639.78,247997.76,13357.98,646573),('1','148','225506','327',461.00,512.00,0.00,3973.39,1831732.79,1955670.76,123937.97,646590),('1','148','225824','327',461.00,512.00,0.00,468.73,216126.53,231589.76,15463.23,647430),('1','148','225941','327',475.00,512.00,0.00,2107.17,1000905.75,1033320.36,32414.61,647756),('1','148','225943','327',475.00,512.00,0.00,2270.89,1162695.68,1119193.76,-43501.92,647759),('1','148','226143','327',475.00,512.00,0.00,3734.77,2031714.88,1871357.02,-160357.86,648271),('1','148','226320','327',544.00,544.00,0.00,1480.75,805528.00,742848.58,-62679.42,648719),('1','148','226532','327',544.00,544.00,0.00,2417.69,1148402.75,1216572.38,68169.63,649246),('1','148','226541','327',475.00,544.00,0.00,2911.56,1382991.00,1457540.52,74549.52,649272),('1','148','226668','327',475.00,544.00,0.00,1254.80,596030.00,631857.68,35827.68,649625),('1','148','226813','327',475.00,544.00,0.00,4047.91,1922757.25,2025467.38,102710.13,649985),('1','148','227032','327',486.00,544.00,0.00,5192.32,2523467.52,2607526.42,84058.90,650556),('1','148','227358','327',486.00,544.00,0.00,1856.13,902079.18,935832.48,33753.30,651410),('1','148','227492','327',486.00,544.00,0.00,3394.25,1649605.50,1703431.40,53825.90,651746),('1','148','227688','327',486.00,544.00,0.00,2880.57,1399957.02,1482920.76,82963.74,652244),('1','148','227928','327',486.00,544.00,0.00,1170.58,568901.88,636795.52,67893.64,652871),('1','148','228196','327',486.00,544.00,0.00,1660.67,807085.62,889890.88,82805.26,653587),('1','148','228859','327',560.00,560.00,0.00,2101.98,1177108.80,1112990.40,-64118.40,655278),('1','148','228864','327',560.00,560.00,0.00,3250.53,1820296.80,1728452.64,-91844.16,655289),('1','148','228873','327',560.00,560.00,0.00,100.22,56123.20,56123.20,0.00,655314),('1','148','228877','327',560.00,560.00,0.00,2602.41,1264771.26,1381169.76,116398.50,655324),('1','148','229232','327',486.00,560.00,0.00,2664.22,1294810.92,1409134.40,114323.48,656247),('1','148','229239','327',486.00,560.00,0.00,899.83,437317.38,476854.40,39537.02,656264),('1','148','229243','327',486.00,560.00,0.00,4558.83,2215591.38,2387828.16,172236.78,656274),('1','148','229468','327',486.00,560.00,0.00,907.86,477534.36,508401.60,30867.24,656854),('1','148','229480','327',526.00,560.00,0.00,1644.67,959762.28,943075.64,-16686.64,656884),('1','148','229668','327',584.00,584.00,0.00,1521.52,888567.68,888567.68,0.00,657368),('1','148','229876','327',584.00,584.00,0.00,1122.32,655434.88,655434.88,0.00,657910),('1','148','230190','327',584.00,584.00,0.00,399.31,211228.38,233197.04,21968.66,658719),('1','148','230717','327',526.00,584.00,0.00,1181.19,621305.94,659227.52,37921.58,660097),('1','148','230753','327',526.00,584.00,0.00,1726.80,908296.80,1008451.20,100154.40,660195),('1','148','230758','327',526.00,584.00,0.00,2116.00,1113016.00,1235744.00,122728.00,660204),('1','148','230788','327',526.00,584.00,0.00,1961.02,1031496.52,1145235.68,113739.16,660259),('1','148','231055','327',526.00,584.00,0.00,1702.13,895320.38,994043.92,98723.54,660981),('1','148','231359','327',526.00,584.00,0.00,813.31,427801.06,457402.76,29601.70,661794),('1','148','231408','327',526.00,584.00,0.00,0.00,0.00,0.00,0.00,661904),('1','148','231443','327',526.00,584.00,0.00,1306.81,687382.06,763177.04,75794.98,662001),('1','148','231667','327',526.00,584.00,0.00,1709.50,899197.00,998348.00,99151.00,662583),('1','148','231888','327',526.00,584.00,0.00,2024.81,1065050.06,1182489.04,117438.98,663200),('1','148','232141','327',526.00,584.00,0.00,0.00,0.00,0.00,0.00,663854),('1','148','232142','327',526.00,584.00,0.00,1245.75,655264.50,727518.00,72253.50,663855),('1','148','232364','327',526.00,584.00,0.00,1277.79,672117.54,746229.36,74111.82,664429),('1','148','232589','327',600.00,600.00,0.00,1536.01,921606.00,888210.24,-33395.76,665036),('1','148','232832','327',600.00,600.00,0.00,768.40,419546.40,441536.00,21989.60,665691),('1','148','232834','327',546.00,600.00,0.00,2537.22,1385322.12,1467428.00,82105.88,665693),('1','148','233098','327',546.00,600.00,0.00,2275.76,1242564.96,1303460.40,60895.44,666384),('1','148','233408','327',546.00,600.00,0.00,0.00,0.00,0.00,0.00,667182),('1','148','233411','327',546.00,600.00,0.00,2063.60,1176252.00,1287686.40,111434.40,667189),('1','148','233606','327',570.00,624.00,0.00,2404.87,1370775.90,1452677.44,81901.54,667707),('1','148','233852','327',570.00,624.00,0.00,1011.69,576663.30,602406.56,25743.26,668345),('1','148','233928','327',570.00,624.00,0.00,1382.78,862179.72,830721.42,-31458.30,668549),('1','148','234063','327',624.00,624.00,0.00,2692.57,1588369.62,1604165.70,15796.08,668905),('1','148','234303','327',570.00,624.00,0.00,973.85,555094.50,591327.56,36233.06,669549),('1','148','234479','327',570.00,624.00,0.00,842.53,480242.10,512743.72,32501.62,670023),('1','148','234564','327',570.00,624.00,0.00,2794.33,1592768.10,1668086.68,75318.58,670243),('1','148','234822','327',570.00,624.00,0.00,1384.02,788891.40,853461.10,64569.70,670919),('1','148','235061','327',570.00,624.00,0.00,0.00,0.00,0.00,0.00,671575),('1','148','235064','327',570.00,624.00,0.00,864.94,493015.80,511569.64,18553.84,671581),('1','148','235068','327',570.00,624.00,0.00,1914.56,1091299.20,1148624.72,57325.52,671588),('1','148','235296','327',570.00,624.00,0.00,2654.24,1512916.80,1599142.28,86225.48,672179),('1','148','235522','327',570.00,624.00,0.00,0.00,0.00,0.00,0.00,672759),('1','148','235523','327',570.00,624.00,0.00,4288.55,2444473.50,2545513.18,101039.68,672760),('1','148','235749','327',570.00,624.00,0.00,858.82,547461.28,545644.80,-1816.48,673347),('1','148','236004','327',592.00,640.00,0.00,1098.01,650021.92,686693.20,36671.28,674025),('1','148','236007','327',592.00,640.00,0.00,2979.39,1763798.88,1842805.20,79006.32,674028),('1','148','236233','327',592.00,640.00,0.00,994.63,588820.96,619763.20,30942.24,674626),('1','148','236485','327',592.00,640.00,0.00,550.69,326008.48,343370.80,17362.32,675303),('1','148','236513','327',592.00,640.00,0.00,2575.70,1524814.40,1586492.00,61677.60,675363),('1','148','236722','327',592.00,640.00,0.00,2181.33,1291347.36,1354014.80,62667.44,675905),('1','148','236937','327',592.00,640.00,0.00,2418.21,1431580.32,1499244.00,67663.68,676468),('1','148','237163','327',592.00,640.00,0.00,2534.17,1500228.64,1561667.20,61438.56,677040),('1','148','237358','327',592.00,640.00,0.00,0.00,0.00,0.00,0.00,677553),('1','148','237359','327',592.00,640.00,0.00,653.03,386593.76,404042.40,17448.64,677554),('1','148','237410','327',592.00,640.00,0.00,3491.54,2066991.68,2135474.00,68482.32,677662),('1','148','237594','327',592.00,640.00,0.00,1115.67,731059.68,710207.76,-20851.92,678161),('1','148','237890','327',592.00,656.00,0.00,939.30,556065.60,594908.76,38843.16,678913),('1','148','237895','327',592.00,656.00,0.00,2151.90,1377216.00,1342356.16,-34859.84,678925),('1','148','238136','327',640.00,640.00,0.00,2126.43,1360915.20,1323324.32,-37590.88,679557),('1','148','238387','327',640.00,640.00,0.00,1404.61,845575.22,883958.08,38382.86,680192),('1','148','238661','327',602.00,640.00,0.00,3790.36,2281796.72,2350547.52,68750.80,680917),('1','148','238947','327',602.00,640.00,0.00,1754.99,1056503.98,1091700.80,35196.82,681659),('1','148','239057','327',602.00,640.00,0.00,3198.91,1925743.82,1977512.96,51769.14,681946),('1','148','239357','327',602.00,640.00,0.00,0.00,0.00,0.00,0.00,682721),('1','148','239361','327',602.00,640.00,0.00,2927.02,1762066.04,1809636.48,47570.44,682731),('1','148','239529','327',602.00,640.00,0.00,2301.77,1385665.54,1420520.64,34855.10,683177),('1','148','239761','327',602.00,640.00,0.00,2766.97,1665715.94,1719698.88,53982.94,683790),('1','148','239976','327',602.00,640.00,0.00,1372.39,872139.02,862609.60,-9529.42,684347),('1','148','240115','327',640.00,640.00,0.00,879.30,529338.60,552499.40,23160.80,684707),('1','148','240196','327',602.00,640.00,0.00,2847.34,1714098.68,1785728.00,71629.32,684911),('1','148','240465','327',602.00,640.00,0.00,1574.13,947626.26,986803.20,39176.94,685603),('1','148','240693','327',602.00,640.00,0.00,821.50,494543.00,521259.80,26716.80,686155),('1','148','240723','327',602.00,640.00,0.00,2322.69,1398259.38,1458147.20,59887.82,686224),('1','148','241031','327',602.00,640.00,0.00,1856.64,1117697.28,1153254.76,35557.48,687052),('1','148','241237','327',602.00,640.00,0.00,118.94,71601.88,72823.60,1221.72,687590),('1','148','241497','327',602.00,640.00,0.00,1734.77,1044331.54,1080216.86,35885.32,688291),('1','148','241515','327',602.00,640.00,0.00,2708.41,1630462.82,1677193.66,46730.84,688331),('1','148','241774','327',602.00,640.00,0.00,846.41,509538.82,525620.40,16081.58,689022),('1','148','241964','327',602.00,640.00,0.00,1251.65,753493.30,774847.10,21353.80,689525),('1','148','241968','327',602.00,640.00,0.00,3821.11,2300308.22,2349787.82,49479.60,689533),('1','148','242218','327',602.00,640.00,0.00,377.46,227230.92,238752.40,11521.48,690176),('1','148','242424','327',602.00,640.00,0.00,114.00,68628.00,69084.00,456.00,690705),('1','148','242426','327',602.00,640.00,0.00,884.74,532613.48,552423.14,19809.66,690707),('1','148','242436','327',602.00,640.00,0.00,3755.57,2260853.14,2313486.90,52633.76,690727),('1','148','242669','327',602.00,640.00,0.00,1058.65,637307.30,657899.64,20592.34,691346),('1','148','242921','327',602.00,640.00,0.00,1131.72,681295.44,702230.38,20934.94,692000),('1','148','242924','327',602.00,640.00,0.00,3091.51,1861089.02,1892517.60,31428.58,692008),('1','148','243158','327',602.00,640.00,0.00,1141.85,687393.70,707215.60,19821.90,692611),('1','148','243406','327',602.00,640.00,0.00,0.00,0.00,0.00,0.00,693267),('1','148','243430','327',602.00,640.00,0.00,1246.20,737750.40,769567.20,31816.80,693327),('1','148','243434','327',592.00,640.00,0.00,4013.84,2376193.28,2460217.60,84024.32,693335),('1','148','243843','327',592.00,640.00,0.00,2516.96,1490040.32,1166600.00,-323440.32,694400),('1','148','243849','327',592.00,640.00,0.00,2892.55,1712389.60,2148600.00,436210.40,694414),('1','148','244096','327',592.00,640.00,0.00,127.73,75616.16,79248.80,3632.64,695040),('1','148','244108','327',592.00,640.00,0.00,3417.94,2023420.48,2097502.00,74081.52,695073),('1','148','244303','327',592.00,640.00,0.00,1576.02,933003.84,960388.40,27384.56,695593),('1','148','244423','327',592.00,640.00,0.00,1285.69,761128.48,794751.20,33622.72,695905),('1','148','244605','327',592.00,640.00,0.00,3105.31,1838343.52,1903336.40,64992.88,696368),('1','148','244766','327',592.00,640.00,0.00,1055.90,625092.80,645378.40,20285.60,696792),('1','148','244994','327',592.00,640.00,0.00,943.50,558552.00,590998.80,32446.80,697385),('1','148','244999','327',592.00,640.00,0.00,2310.22,1457750.64,1412292.76,-45457.88,697398),('1','148','245229','327',632.00,632.00,0.00,1790.58,1131646.56,1074959.16,-56687.40,697987),('1','148','245530','327',632.00,632.00,0.00,2853.94,1632453.68,1728603.64,96149.96,698763),('1','148','245683','327',572.00,632.00,0.00,1686.34,964586.48,1028186.04,63599.56,699164),('1','148','246036','327',572.00,632.00,0.00,829.70,474588.40,474695.20,106.80,700084),('1','148','246076','327',616.00,616.00,0.00,1589.19,891858.68,935548.08,43689.40,700191),('1','148','246200','327',558.00,616.00,0.00,2843.63,1586745.54,1662725.40,75979.86,700499),('1','148','246470','327',558.00,616.00,0.00,798.87,445769.46,461929.88,16160.42,701216),('1','148','246711','327',558.00,616.00,0.00,0.00,0.00,0.00,0.00,701850),('1','148','246718','327',558.00,616.00,0.00,2237.79,1248686.82,1309953.04,61266.22,701865),('1','148','246726','327',558.00,616.00,0.00,2334.92,1302885.36,1365215.36,62330.00,701883),('1','148','246960','327',558.00,616.00,0.00,721.69,402703.02,429630.80,26927.78,702482),('1','148','247181','327',558.00,616.00,0.00,1957.94,1092530.52,1134176.08,41645.56,703062),('1','148','247186','327',558.00,616.00,0.00,3323.33,1854418.14,1915926.92,61508.78,703069),('1','148','247398','327',558.00,616.00,0.00,0.00,0.00,0.00,0.00,703615),('1','148','247400','327',558.00,616.00,0.00,408.99,228216.42,246692.08,18475.66,703617),('1','148','247412','327',558.00,616.00,0.00,2902.15,1619399.70,1694193.56,74793.86,703641),('1','148','247729','327',558.00,616.00,0.00,1955.95,1157922.40,1109862.40,-48060.00,704474),('1','148','247925','327',592.00,592.00,0.00,1455.31,861543.52,830434.84,-31108.68,704983),('1','148','247930','327',592.00,592.00,0.00,3462.39,2049734.88,1968936.48,-80798.40,704992),('1','148','248211','327',592.00,592.00,0.00,877.75,519628.00,504220.72,-15407.28,705714),('1','148','248343','327',592.00,592.00,0.00,1158.14,646242.12,664588.76,18346.64,706076),('1','148','248451','327',558.00,592.00,0.00,3752.67,2093989.86,2134854.84,40864.98,706329),('1','148','248744','327',558.00,592.00,0.00,4591.66,2562146.28,2604390.40,42244.12,707084),('1','148','248976','327',558.00,592.00,0.00,280.88,156731.04,166280.96,9549.92,707689),('1','148','249141','327',558.00,592.00,0.00,0.00,0.00,0.00,0.00,708092),('1','148','249144','327',558.00,592.00,0.00,2419.92,1350315.36,1326223.58,-24091.78,708097),('1','148','249152','327',558.00,592.00,0.00,2675.27,1492800.66,1471973.22,-20827.44,708117),('1','148','249385','327',558.00,592.00,0.00,579.63,295611.30,329930.62,34319.32,708717),('1','148','249406','327',510.00,592.00,0.00,3178.02,1620790.20,1760798.46,140008.26,708770),('1','148','249659','327',510.00,592.00,0.00,1542.75,786802.50,859587.48,72784.98,709428),('1','148','249903','327',510.00,592.00,0.00,1076.28,548902.80,609173.44,60270.64,710052),('1','148','249916','327',510.00,592.00,0.00,289.70,147747.00,158058.94,10311.94,710088),('1','148','249963','327',510.00,592.00,0.00,3192.47,1628159.70,1767737.76,139578.06,710218),('1','148','250124','327',510.00,592.00,0.00,780.81,398213.10,446126.96,47913.86,710616),('1','148','250346','327',510.00,592.00,0.00,3846.16,1961541.60,2093192.20,131650.60,711187),('1','148','250357','327',510.00,592.00,0.00,1353.83,690453.30,754111.76,63658.46,711208),('1','148','250564','327',510.00,592.00,0.00,3480.59,1740295.00,1920454.38,180159.38,711745),('1','148','250811','327',500.00,592.00,0.00,2503.04,1251520.00,1388670.72,137150.72,712387),('1','148','251068','327',500.00,592.00,0.00,2476.67,1262976.70,1380880.36,117903.66,713042),('1','148','251351','327',510.00,592.00,0.00,2760.40,1407804.00,1528531.12,120727.12,713786),('1','148','251588','327',510.00,592.00,0.00,2211.31,1127768.10,1234848.66,107080.56,714402),('1','148','251799','327',510.00,592.00,0.00,2978.37,1518968.70,1649883.22,130914.52,714955),('1','148','252102','327',510.00,592.00,0.00,1119.73,571062.30,649054.16,77991.86,715748),('1','148','252240','327',510.00,592.00,0.00,3404.34,1736213.40,1902828.12,166614.72,716123),('1','148','252391','327',510.00,592.00,0.00,253.91,129494.10,150314.72,20820.62,716517),('1','148','252480','327',510.00,592.00,0.00,2975.78,1517647.80,1665459.46,147811.66,716740),('1','148','252758','327',510.00,592.00,0.00,1431.72,730177.20,811368.64,81191.44,717439),('1','148','252882','327',510.00,592.00,0.00,962.73,490992.30,551553.16,60560.86,717784),('1','148','252973','327',510.00,592.00,0.00,2499.29,1274637.90,1422756.68,148118.78,718020),('1','148','253216','327',510.00,592.00,0.00,1268.43,36694.50,722221.36,685526.86,718662),('1','148','253361','327',0.00,592.00,0.00,651.10,287961.30,380691.20,92729.90,719034),('1','148','253481','327',510.00,592.00,0.00,3175.70,1619607.00,1778388.40,158781.40,719346),('1','148','253723','327',510.00,592.00,0.00,885.37,451538.70,491227.04,39688.34,719961),('1','148','253809','327',510.00,592.00,0.00,1636.85,834793.50,928963.20,94169.70,720186),('1','148','253964','327',510.00,592.00,0.00,2761.78,1408507.80,1502849.76,94341.96,720590),('1','148','254110','327',510.00,592.00,0.00,720.22,367312.20,418210.24,50898.04,720982),('1','148','254207','327',510.00,592.00,0.00,2459.07,1254125.70,1378725.44,124599.74,721220),('1','148','254453','327',510.00,592.00,0.00,3100.03,1581015.30,1746341.76,165326.46,721868),('1','148','254710','327',510.00,592.00,0.00,1486.17,757946.70,836462.64,78515.94,722511),('1','148','254826','327',510.00,592.00,0.00,1365.33,696318.30,779960.48,83642.18,722802),('1','148','254951','327',510.00,592.00,0.00,2313.27,1179767.70,1330083.84,150316.14,723128),('1','148','255212','327',510.00,592.00,0.00,1008.16,514161.60,574458.72,60297.12,723789),('1','148','255325','327',510.00,592.00,0.00,734.32,374503.20,420233.44,45730.24,724085),('1','148','255466','327',510.00,592.00,0.00,3008.09,1534125.90,1715543.28,181417.38,724431),('1','148','255747','327',510.00,592.00,0.00,604.77,308432.70,338507.84,30075.14,725122),('1','148','255776','327',510.00,592.00,0.00,2000.28,1020142.80,1139861.04,119718.24,725187),('1','148','256006','327',510.00,592.00,0.00,2502.77,1276412.70,1396229.80,119817.10,725781),('1','148','256126','327',510.00,592.00,0.00,425.22,216862.20,248330.24,31468.04,726090),('1','148','256247','327',510.00,592.00,0.00,3068.12,1564741.20,1747681.04,182939.84,726361),('1','148','256490','327',510.00,592.00,0.00,1541.01,785915.10,879666.48,93751.38,727017),('1','148','256593','327',510.00,592.00,0.00,1030.14,525371.40,596038.88,70667.48,727270),('1','148','256731','327',510.00,592.00,0.00,3026.86,1543698.60,1693505.12,149806.52,727632),('1','148','256961','327',510.00,592.00,0.00,1345.84,686378.40,756039.28,69660.88,728249),('1','148','257106','327',510.00,592.00,0.00,988.12,503941.20,570279.04,66337.84,728613),('1','148','257237','327',510.00,592.00,0.00,3323.51,1694990.10,1876669.92,181679.82,728961),('1','148','257520','327',0.00,568.00,0.00,3578.73,1825152.30,1976154.64,151002.34,729688),('1','148','257521','327',510.00,568.00,0.00,1680.58,857095.80,924355.08,67259.28,729689),('1','148','257522','327',510.00,568.00,0.00,962.81,491033.10,535700.08,44666.98,729690),('1','148','257523','327',0.00,568.00,0.00,3397.01,988533.00,1834870.64,846337.64,729691),('1','148','257524','327',510.00,568.00,0.00,4956.24,2478120.00,2667561.90,189441.90,729692),('1','148','257525','327',500.00,568.00,0.00,704.29,352145.00,389373.88,37228.88,729693),('1','148','257526','327',500.00,568.00,0.00,4311.75,2155875.00,2264880.00,109005.00,729694),('1','148','257527','327',500.00,568.00,0.00,973.18,486590.00,527109.76,40519.76,729695),('1','148','257528','327',500.00,568.00,0.00,1730.42,865210.00,938390.66,73180.66,729696),('1','148','257529','327',500.00,568.00,0.00,3017.02,1508510.00,1664003.56,155493.56,729697),('1','148','257530','327',500.00,568.00,0.00,3659.68,1829840.00,2037205.24,207365.24,729698),('1','148','257531','327',500.00,568.00,0.00,1642.21,821105.00,892707.28,71602.28,729699),('1','148','257532','327',500.00,568.00,0.00,1858.97,929485.00,1021928.96,92443.96,729700),('1','148','257533','327',500.00,568.00,0.00,1006.10,503050.00,553050.80,50000.80,729701),('1','148','257534','327',500.00,568.00,0.00,2487.12,1243560.00,1357058.16,113498.16,729702),('1','148','257535','327',500.00,568.00,0.00,2068.93,1034465.00,1120734.84,86269.84,729703),('1','148','257536','327',500.00,568.00,0.00,518.82,259410.00,293312.76,33902.76,729704),('1','148','257537','327',500.00,568.00,0.00,3701.94,1850970.00,1987654.92,136684.92,729705),('1','148','257538','327',500.00,568.00,0.00,694.77,347385.00,378321.36,30936.36,729706),('1','148','257539','327',500.00,568.00,0.00,1547.66,773830.00,846134.66,72304.66,729707),('1','148','257540','327',500.00,568.00,0.00,2551.90,1275950.00,1398233.20,122283.20,729708),('1','148','257541','327',500.00,568.00,0.00,3893.52,1946760.00,2136054.36,189294.36,729709),('1','148','257542','327',500.00,568.00,0.00,1215.64,607820.00,668559.52,60739.52,729710),('1','148','257543','327',500.00,568.00,0.00,1742.62,871310.00,963699.16,92389.16,729711),('1','148','257544','327',500.00,568.00,0.00,1717.72,858860.00,946474.96,87614.96,729712),('1','148','257545','327',500.00,568.00,0.00,1892.21,946105.00,1036408.28,90303.28,729713),('1','148','257546','327',500.00,568.00,0.00,2147.18,1073590.00,1177802.24,104212.24,729714),('1','148','257547','327',500.00,568.00,0.00,3176.84,1588420.00,1721501.12,133081.12,729715),('1','148','257548','327',500.00,568.00,0.00,2683.13,1341565.00,1485407.84,143842.84,729716),('1','148','257549','327',500.00,568.00,0.00,2415.20,1207600.00,1316105.60,108505.60,729717),('1','148','257550','327',500.00,568.00,0.00,1985.67,992835.00,1092564.00,99729.00,729718),('1','148','257551','327',500.00,568.00,0.00,2326.31,1163155.00,1267722.08,104567.08,729719),('1','148','257552','327',500.00,568.00,0.00,2421.09,1210545.00,1308185.12,97640.12,729720),('1','148','257553','327',500.00,568.00,0.00,833.02,416510.00,453030.36,36520.36,729721),('1','148','257554','327',500.00,568.00,0.00,1173.68,586840.00,642755.24,55915.24,729722),('1','148','257555','327',500.00,568.00,0.00,1032.36,516180.00,555761.94,39581.94,729723),('1','148','257556','327',500.00,568.00,0.00,2727.10,1363550.00,1495681.30,132131.30,729724),('1','148','257557','327',500.00,568.00,0.00,1506.14,753070.00,827056.52,73986.52,729725),('1','148','257558','327',500.00,568.00,0.00,1980.80,990400.00,1085188.40,94788.40,729726),('1','148','257559','327',500.00,568.00,0.00,2062.48,1031240.00,1124858.56,93618.56,729727),('1','148','257560','327',500.00,568.00,0.00,1101.99,7480.00,638974.68,631494.68,729728),('1','148','257561','327',0.00,580.00,0.00,1492.34,746170.00,865557.20,119387.20,729729),('1','148','257562','327',500.00,580.00,0.00,2638.49,1319245.00,1533244.20,213999.20,729730),('1','148','257563','327',500.00,580.00,0.00,804.90,402450.00,466842.00,64392.00,729731),('1','148','257564','327',500.00,580.00,0.00,1176.65,588325.00,682457.00,94132.00,729732),('1','148','257565','327',500.00,580.00,0.00,2760.62,1380310.00,1601159.60,220849.60,729733),('1','148','257566','327',500.00,580.00,0.00,222.57,111285.00,129090.60,17805.60,729734),('1','148','257567','327',500.00,580.00,0.00,1626.60,813300.00,943428.00,130128.00,729735),('1','148','257568','327',0.00,640.00,0.00,2245.10,530250.00,1436864.00,906614.00,729736),('1','148','257569','327',500.00,640.00,0.00,1310.99,655495.00,839033.60,183538.60,729737),('1','148','257570','327',500.00,640.00,0.00,2050.03,1025015.00,1312019.20,287004.20,729738),('1','148','257571','327',500.00,640.00,0.00,405.83,202915.00,259731.20,56816.20,729739),('1','148','257572','327',500.00,640.00,0.00,1234.95,617475.00,790368.00,172893.00,729740),('1','148','257573','327',500.00,640.00,0.00,2715.80,1357900.00,1738112.00,380212.00,729741),('1','148','257574','327',500.00,640.00,0.00,895.39,447695.00,573049.60,125354.60,729742),('1','148','257575','327',500.00,640.00,0.00,836.59,418295.00,535417.60,117122.60,729743),('1','148','257576','327',500.00,640.00,0.00,993.80,0.00,675784.00,675784.00,729744),('1','148','257577','327',0.00,680.00,0.00,333.56,0.00,226820.80,226820.80,729745),('1','148','257578','327',0.00,680.00,0.00,445.00,0.00,302600.00,302600.00,729746),('1','148','257579','327',0.00,680.00,0.00,1176.88,461802.30,800278.40,338476.10,729747),('1','148','257580','327',606.00,680.00,0.00,853.33,517117.98,580264.40,63146.42,729748),('1','148','257581','327',606.00,680.00,0.00,128.04,77592.24,87067.20,9474.96,729749),('1','148','257582','327',606.00,680.00,0.00,1891.89,1146485.34,1286485.20,139999.86,729750),('1','148','257583','327',606.00,680.00,0.00,1686.19,1021831.14,1146609.20,124778.06,729751),('1','148','257584','327',606.00,680.00,0.00,439.34,266240.04,298751.20,32511.16,729752),('1','148','257585','327',606.00,680.00,0.00,465.80,282274.80,316744.00,34469.20,729753),('1','148','257586','327',606.00,680.00,0.00,1354.38,820754.28,920978.40,100224.12,729754),('1','148','257587','327',606.00,680.00,0.00,1332.10,807252.60,905828.00,98575.40,729755),('1','148','257588','327',606.00,680.00,0.00,1451.00,879306.00,986680.00,107374.00,729756),('1','148','257589','327',606.00,680.00,0.00,470.55,285153.30,319974.00,34820.70,729757),('1','148','257590','327',606.00,680.00,0.00,525.12,318222.72,357081.60,38858.88,729758),('1','148','257591','327',606.00,680.00,0.00,633.19,383713.14,430569.20,46856.06,729759),('1','148','257592','327',0.00,688.00,0.00,1652.18,0.00,1136699.84,1136699.84,729760),('1','148','257593','327',0.00,688.00,0.00,1437.15,528362.90,988759.20,460396.30,729761),('1','148','257594','327',410.00,688.00,0.00,322.00,132020.00,221536.00,89516.00,729762),('1','148','257595','327',410.00,688.00,0.00,801.91,328783.10,576262.08,247478.98,729763),('1','148','257596','327',410.00,688.00,0.00,1661.76,681321.60,1143290.88,461969.28,729764),('1','148','257597','327',0.00,664.00,0.00,1664.04,723364.63,1104922.56,381557.93,729765),('1','148','257598','327',617.00,664.00,0.00,1985.64,1225139.88,1318464.96,93325.08,729766),('1','148','257599','327',617.00,664.00,0.00,3272.27,2018990.59,2172787.28,153796.69,729767),('1','148','257600','327',617.00,664.00,0.00,2015.17,1243359.89,1338072.88,94712.99,729768),('1','148','257601','327',617.00,664.00,0.00,168.26,103816.42,111724.64,7908.22,729769),('1','148','257602','327',617.00,664.00,0.00,1985.70,1225176.90,1318504.80,93327.90,729770),('1','148','257603','327',617.00,664.00,0.00,1819.34,1122532.78,1208041.76,85508.98,729771),('1','148','257604','327',617.00,664.00,0.00,947.73,584749.41,629292.72,44543.31,729772),('1','148','257605','327',617.00,664.00,0.00,1500.86,926030.62,996571.04,70540.42,729773),('1','148','257606','327',617.00,664.00,0.00,1871.34,1154616.78,1242569.76,87952.98,729774),('1','148','257607','327',617.00,664.00,0.00,1355.81,836534.77,900257.84,63723.07,729775),('1','148','257608','327',617.00,664.00,0.00,545.74,336721.58,362371.36,25649.78,729776),('1','148','257609','327',617.00,664.00,0.00,2201.40,1358263.80,1461729.60,103465.80,729777),('1','148','257610','327',617.00,664.00,0.00,1073.71,662479.07,712943.44,50464.37,729778),('1','148','257611','327',617.00,664.00,0.00,428.74,264532.58,284683.36,20150.78,729779),('1','148','257612','327',617.00,664.00,0.00,1714.02,1057550.34,1138109.28,80558.94,729780),('1','148','257613','327',617.00,664.00,0.00,1856.33,1145355.61,1232603.12,87247.51,729781),('1','148','257614','327',617.00,664.00,0.00,229.38,141527.46,152308.32,10780.86,729782),('1','148','257615','327',617.00,664.00,0.00,487.84,300997.28,323925.76,22928.48,729783),('1','148','257616','327',617.00,664.00,0.00,2020.43,1246605.31,1341565.52,94960.21,729784),('1','148','257617','327',617.00,664.00,0.00,1657.02,1022381.34,1100261.28,77879.94,729785),('1','148','257618','327',617.00,664.00,0.00,1610.76,993838.92,1069544.64,75705.72,729786),('1','148','257619','327',617.00,664.00,0.00,1478.15,912018.55,981491.60,69473.05,729787),('1','148','257620','327',617.00,664.00,0.00,1549.07,955776.19,1028582.48,72806.29,729788),('1','148','257621','327',617.00,664.00,0.00,1576.68,972811.56,1046915.52,74103.96,729789),('1','148','257622','327',617.00,664.00,0.00,1644.76,1014816.92,1092120.64,77303.72,729790),('1','148','257623','327',617.00,664.00,0.00,638.83,394158.11,424183.12,30025.01,729791),('1','148','257624','327',617.00,664.00,0.00,1243.01,766937.17,825358.64,58421.47,729792),('1','148','257625','327',617.00,664.00,0.00,1822.64,1124568.88,1210232.96,85664.08,729793),('1','148','257626','327',617.00,664.00,0.00,760.14,469006.38,504732.96,35726.58,729794),('1','148','257627','327',617.00,664.00,0.00,428.66,264483.22,284630.24,20147.02,729795),('1','148','257628','327',617.00,664.00,0.00,118.44,73077.48,78644.16,5566.68,729796),('1','148','257629','327',617.00,664.00,0.00,720.74,444696.58,478571.36,33874.78,729797),('1','148','257630','327',617.00,664.00,0.00,150.98,93154.66,100250.72,7096.06,729798),('1','148','257631','327',617.00,664.00,0.00,508.71,313874.07,337783.44,23909.37,729799),('1','148','257632','327',617.00,664.00,0.00,2488.78,1473357.76,1652549.92,179192.16,729800),('1','148','257633','327',592.00,664.00,0.00,1003.24,593918.08,666151.36,72233.28,729801),('1','148','257634','327',592.00,664.00,0.00,1058.50,626632.00,702844.00,76212.00,729802),('1','148','257635','327',592.00,664.00,0.00,829.87,491283.04,551033.68,59750.64,729803),('1','148','257636','327',592.00,664.00,0.00,2153.46,1274848.32,1429897.44,155049.12,729804),('1','148','257637','327',592.00,664.00,0.00,559.99,331514.08,371833.36,40319.28,729805),('1','148','257638','327',592.00,664.00,0.00,906.12,536423.04,601663.68,65240.64,729806),('1','148','257639','327',592.00,664.00,0.00,1589.09,940741.28,1055155.76,114414.48,729807),('1','148','257640','327',592.00,664.00,0.00,2099.84,1243105.28,1394293.76,151188.48,729808),('1','148','257641','327',592.00,664.00,0.00,2247.54,1330543.68,1492366.56,161822.88,729809),('1','148','257642','327',592.00,664.00,0.00,2318.51,1372557.92,1539490.64,166932.72,729810),('1','148','257643','327',592.00,664.00,0.00,129.01,76373.92,85662.64,9288.72,729811),('1','148','257644','327',592.00,664.00,0.00,803.79,475843.68,533716.56,57872.88,729812),('1','148','257645','327',592.00,664.00,0.00,1469.31,869831.52,975621.84,105790.32,729813),('1','148','257646','327',592.00,664.00,0.00,1554.75,920412.00,1032354.00,111942.00,729814),('1','148','257647','327',592.00,664.00,0.00,108.58,64279.36,72097.12,7817.76,729815),('1','148','257648','327',592.00,664.00,0.00,0.00,0.00,0.00,0.00,729816),('1','148','257649','327',592.00,664.00,0.00,297.71,176244.32,197679.44,21435.12,729817),('1','148','257650','327',592.00,664.00,0.00,1484.52,878835.84,985721.28,106885.44,729818),('1','148','257651','327',592.00,664.00,0.00,2179.07,1290009.44,1447238.48,157229.04,729819),('1','148','257652','327',592.00,664.00,0.00,139.93,82838.56,92913.52,10074.96,729820),('1','148','257653','327',592.00,664.00,0.00,308.06,182371.52,209464.00,27092.48,729821),('1','148','257654','327',592.00,680.00,0.00,0.00,0.00,0.00,0.00,729822),('1','148','257655','327',592.00,680.00,0.00,1048.99,621002.08,713313.20,92311.12,729823),('1','148','257656','327',592.00,680.00,0.00,2466.85,1460375.20,1677458.00,217082.80,729824),('1','148','257657','327',592.00,680.00,0.00,810.99,480106.08,551473.20,71367.12,729825),('1','148','257658','327',592.00,680.00,0.00,999.48,591692.16,679646.40,87954.24,729826),('1','148','257659','327',592.00,680.00,0.00,2797.07,1655865.44,1902007.60,246142.16,729827),('1','148','257660','327',592.00,680.00,0.00,1525.21,902924.32,1037142.80,134218.48,729828),('1','148','257661','327',592.00,680.00,0.00,1909.44,1130388.48,1298419.20,168030.72,729829),('1','148','257662','327',592.00,680.00,0.00,1520.48,984678.66,1097325.60,112646.94,729830),('1','148','257663','327',662.00,720.00,0.00,1195.90,791685.80,861048.00,69362.20,729831),('1','148','257664','327',662.00,720.00,0.00,2216.94,1467614.28,1596196.80,128582.52,729832),('1','148','257665','327',662.00,720.00,0.00,1153.51,763623.62,830527.20,66903.58,729833),('1','148','257666','327',662.00,720.00,0.00,771.42,510680.04,555422.40,44742.36,729834),('1','148','257667','327',662.00,720.00,0.00,1809.66,1197994.92,1311235.20,113240.28,729835),('1','148','257668','327',662.00,720.00,0.00,1985.00,1506796.80,1507864.00,1067.20,729836),('1','148','257669','327',760.00,760.00,0.00,24.84,18878.40,18878.40,0.00,729837),('1','148','257670','327',760.00,760.00,0.00,0.00,0.00,0.00,0.00,729838),('1','148','257671','327',760.00,760.00,0.00,1691.24,1285342.40,1285342.40,0.00,729839),('1','148','257672','327',760.00,760.00,0.00,2323.56,1765905.60,1765905.60,0.00,729840),('1','148','257673','327',760.00,760.00,0.00,938.91,713571.60,714811.60,1240.00,729841),('1','148','257674','327',760.00,760.00,0.00,0.00,0.00,0.00,0.00,729842),('1','148','257675','327',760.00,760.00,0.00,1458.43,1108406.80,1108406.80,0.00,729843),('1','148','257676','327',760.00,760.00,0.00,1830.09,1390868.40,1390868.40,0.00,729844),('1','148','257677','327',760.00,760.00,0.00,1986.45,1509702.00,1510942.00,1240.00,729845),('1','148','257678','327',760.00,760.00,0.00,2183.66,1659581.60,1659581.60,0.00,729846),('1','148','257679','327',760.00,760.00,0.00,2792.38,2122208.80,2122208.80,0.00,729847),('1','148','257680','327',760.00,760.00,0.00,230.25,174990.00,174990.00,0.00,729848),('1','148','257681','327',760.00,760.00,0.00,1492.88,1134588.80,1134588.80,0.00,729849),('1','148','257682','327',760.00,760.00,0.00,2322.48,1765084.80,1767324.80,2240.00,729850),('1','148','257683','327',760.00,760.00,0.00,890.33,676650.80,676650.80,0.00,729851),('1','148','257684','327',760.00,760.00,0.00,546.29,415180.40,415180.40,0.00,729852),('1','148','257685','327',760.00,760.00,0.00,2698.16,2050601.60,2050601.60,0.00,729853),('1','148','257686','327',760.00,760.00,0.00,2024.14,1538346.40,1538346.40,0.00,729854),('1','148','257687','327',760.00,760.00,0.00,259.90,197524.00,197524.00,0.00,729855),('1','148','257688','327',760.00,760.00,0.00,2753.13,2092378.80,2092378.80,0.00,729856),('1','148','257689','327',760.00,760.00,0.00,1762.74,1339682.40,1339682.40,0.00,729857),('1','148','257690','327',760.00,760.00,0.00,634.13,481938.80,481938.80,0.00,729858),('1','148','257691','327',760.00,760.00,0.00,1257.87,955981.20,955981.20,0.00,729859),('1','148','257692','327',760.00,760.00,0.00,1934.87,1470501.20,1470501.20,0.00,729860),('1','148','257693','327',760.00,760.00,0.00,1731.54,1315970.40,1315970.40,0.00,729861),('1','148','257694','327',760.00,760.00,0.00,338.63,257358.80,257358.80,0.00,729862),('1','148','257695','327',760.00,760.00,0.00,943.43,717006.80,717006.80,0.00,729863),('1','148','257696','327',760.00,760.00,0.00,1990.62,1512871.20,1512871.20,0.00,729864),('1','148','257697','327',760.00,760.00,0.00,2125.55,1615418.00,1615418.00,0.00,729865),('1','148','257698','327',760.00,760.00,0.00,1661.90,1263044.00,1263044.00,0.00,729866),('1','148','257699','327',760.00,760.00,0.00,1627.95,1237242.00,1237242.00,0.00,729867),('1','148','257700','327',760.00,760.00,0.00,2081.89,1582236.40,1582236.40,0.00,729868),('1','148','257701','327',760.00,760.00,0.00,1647.60,1252176.00,1252176.00,0.00,729869),('1','148','257702','327',760.00,760.00,0.00,1593.87,1211341.20,1211341.20,0.00,729870),('1','148','257703','327',760.00,760.00,0.00,2236.07,1699413.20,1699413.20,0.00,729871),('1','148','257704','327',760.00,760.00,0.00,2173.31,1651715.60,1651715.60,0.00,729872),('1','148','257705','327',760.00,760.00,0.00,2371.42,1802279.20,1802279.20,0.00,729873),('1','148','257706','327',760.00,760.00,0.00,869.44,660774.40,660774.40,0.00,729874),('1','148','257707','327',760.00,760.00,0.00,545.55,414618.00,414618.00,0.00,729875),('1','148','257708','327',760.00,760.00,0.00,1615.79,1228000.40,1228000.40,0.00,729876),('1','148','257709','327',760.00,760.00,0.00,1723.04,1309510.40,1309510.40,0.00,729877),('1','148','257710','327',760.00,760.00,0.00,1013.98,770624.80,770624.80,0.00,729878),('1','148','257711','327',760.00,760.00,0.00,697.25,529910.00,529910.00,0.00,729879),('1','148','257712','327',760.00,760.00,0.00,1606.20,1220712.00,1220712.00,0.00,729880),('1','148','257713','327',760.00,760.00,0.00,1842.25,1400110.00,1400110.00,0.00,729881),('1','148','257714','327',760.00,760.00,0.00,1301.96,989489.60,989489.60,0.00,729882),('1','148','257715','327',760.00,760.00,0.00,1772.11,1346803.60,1346803.60,0.00,729883),('1','148','257716','327',760.00,760.00,0.00,1801.00,1368760.00,1368760.00,0.00,729884),('1','148','257717','327',682.00,760.00,0.00,1623.46,1107199.72,1233829.60,126629.88,729885),('1','148','257718','327',682.00,760.00,0.00,1628.34,1110527.88,1237538.40,127010.52,729886),('1','148','257719','327',682.00,760.00,0.00,2025.22,1381200.04,1539167.20,157967.16,729887),('1','148','257720','327',682.00,760.00,0.00,594.00,405108.00,451440.00,46332.00,729888),('1','148','257721','327',682.00,760.00,0.00,367.40,250566.80,279224.00,28657.20,729889),('1','148','257722','327',682.00,760.00,0.00,1824.03,1243988.46,1386262.80,142274.34,729890),('1','148','257723','327',682.00,760.00,0.00,1483.90,1012019.80,1127764.00,115744.20,729891),('1','148','257724','327',682.00,760.00,0.00,1585.64,764112.80,1179716.16,415603.36,729892),('1','148','257725','327',682.00,744.00,0.00,2533.91,1728126.62,1885229.04,157102.42,729893),('1','148','257726','327',682.00,744.00,0.00,1056.40,720464.80,785961.60,65496.80,729894),('1','148','257727','327',682.00,744.00,0.00,1563.54,1066334.28,1163273.76,96939.48,729895),('1','148','257728','327',682.00,744.00,0.00,269.36,183703.52,200403.84,16700.32,729896),('1','148','257729','327',682.00,744.00,0.00,915.93,624664.26,681451.92,56787.66,729897),('1','148','257730','327',682.00,744.00,0.00,1642.90,1120457.80,1222317.60,101859.80,729898),('1','148','257731','327',682.00,744.00,0.00,1569.25,1060831.28,1167522.00,106690.72,729899),('1','148','257732','327',675.00,744.00,0.00,649.65,438513.75,483339.60,44825.85,729900),('1','148','257733','327',675.00,744.00,0.00,0.00,0.00,0.00,0.00,729901),('1','148','257734','327',675.00,744.00,0.00,2551.96,1722573.00,1898658.24,176085.24,729902),('1','148','257735','327',675.00,744.00,0.00,2077.41,1402251.75,1545593.04,143341.29,729903),('1','148','257736','327',675.00,744.00,0.00,635.41,428901.75,472745.04,43843.29,729904),('1','148','257737','327',675.00,744.00,0.00,688.97,465054.75,512593.68,47538.93,729905),('1','148','257738','327',675.00,744.00,0.00,2027.04,1368252.00,1508117.76,139865.76,729906),('1','148','257739','327',675.00,744.00,0.00,2111.08,1424979.00,1570643.52,145664.52,729907),('1','148','257740','327',675.00,744.00,0.00,2215.98,1495786.50,1648689.12,152902.62,729908),('1','148','257741','327',675.00,744.00,0.00,1250.57,844134.75,930424.08,86289.33,729909),('1','148','257742','327',675.00,744.00,0.00,173.83,117335.25,129329.52,11994.27,729910),('1','148','257743','327',675.00,744.00,0.00,141.71,95654.25,107699.60,12045.35,729911),('1','148','257744','327',675.00,760.00,0.00,646.74,436549.50,491522.40,54972.90,729912),('1','148','257745','327',675.00,760.00,0.00,1446.51,976394.25,1099347.60,122953.35,729913),('1','148','257746','327',675.00,760.00,0.00,764.20,515835.00,580792.00,64957.00,729914),('1','148','257747','327',675.00,760.00,0.00,334.90,226057.50,254524.00,28466.50,729915),('1','148','257748','327',675.00,760.00,0.00,1373.03,926795.25,1043502.80,116707.55,729916),('1','148','257749','327',675.00,760.00,0.00,575.75,388631.25,437570.00,48938.75,729917),('1','148','257750','327',675.00,760.00,0.00,626.80,423090.00,476368.00,53278.00,729918),('1','148','257751','327',675.00,760.00,0.00,2042.66,1378795.50,1519739.04,140943.54,729919),('1','148','257752','327',675.00,744.00,0.00,1942.91,1311464.25,1445525.04,134060.79,729920),('1','148','257753','327',675.00,744.00,0.00,594.08,401004.00,441995.52,40991.52,729921),('1','148','257754','327',675.00,744.00,0.00,922.56,622728.00,686384.64,63656.64,729922),('1','148','257755','327',675.00,744.00,0.00,1599.93,1079952.75,1190347.92,110395.17,729923),('1','148','257756','327',675.00,744.00,0.00,1909.96,1289223.00,1421010.24,131787.24,729924),('1','148','257757','327',675.00,744.00,0.00,510.34,344479.50,379692.96,35213.46,729925),('1','148','257758','327',675.00,744.00,0.00,0.00,0.00,0.00,0.00,729926),('1','148','257759','327',675.00,744.00,0.00,936.33,632022.75,696629.52,64606.77,729927),('1','148','257760','327',675.00,744.00,0.00,1714.36,1157193.00,1276739.84,119546.84,729928),('1','148','257761','327',675.00,744.00,0.00,1663.41,1122801.75,1237577.04,114775.29,729929),('1','148','257762','327',675.00,744.00,0.00,420.23,283655.25,312651.12,28995.87,729930),('1','148','257763','327',675.00,744.00,0.00,773.11,521849.25,575193.84,53344.59,729931),('1','148','257764','327',675.00,744.00,0.00,1627.26,1098400.50,1210681.44,112280.94,729932),('1','148','257765','327',675.00,744.00,0.00,2413.67,1629227.25,1795770.48,166543.23,729933),('1','148','257766','327',675.00,744.00,0.00,88.13,59487.75,65568.72,6080.97,729934),('1','148','257767','327',675.00,744.00,0.00,1121.18,756796.50,834157.92,77361.42,729935),('1','148','257768','327',675.00,744.00,0.00,2919.81,1970871.75,2172338.64,201466.89,729936),('1','148','257769','327',675.00,744.00,0.00,767.48,518049.00,571005.12,52956.12,729937),('1','148','257770','327',675.00,744.00,0.00,696.84,470367.00,518448.96,48081.96,729938),('1','148','257771','327',675.00,744.00,0.00,1818.96,1227798.00,1353306.24,125508.24,729939),('1','148','257772','327',675.00,744.00,0.00,1513.46,1021585.50,1126014.24,104428.74,729940),('1','148','257773','327',675.00,744.00,0.00,1259.82,850378.50,937306.08,86927.58,729941),('1','148','257774','327',675.00,744.00,0.00,1995.42,1346908.50,1486098.48,139189.98,729942),('1','148','257775','327',675.00,744.00,0.00,3024.17,2041314.75,2249982.48,208667.73,729943),('1','148','257776','327',675.00,744.00,0.00,79.18,53446.50,58909.92,5463.42,729944),('1','148','257777','327',675.00,744.00,0.00,1867.94,1260859.50,1389747.36,128887.86,729945),('1','148','257778','327',675.00,744.00,0.00,1562.23,1054505.25,1162299.12,107793.87,729946),('1','148','257779','327',675.00,744.00,0.00,1496.16,1009908.00,1113143.04,103235.04,729947),('1','148','257780','327',675.00,744.00,0.00,1857.50,1253812.50,1381980.00,128167.50,729948),('1','148','257781','327',675.00,744.00,0.00,1837.08,1240029.00,1366787.52,126758.52,729949),('1','148','257782','327',675.00,744.00,0.00,1410.31,951959.25,1049270.64,97311.39,729950),('1','148','257783','327',675.00,744.00,0.00,1884.82,1272253.50,1402306.08,130052.58,729951),('1','148','257784','327',675.00,744.00,0.00,1560.46,1053310.50,1160982.24,107671.74,729952),('1','148','257785','327',675.00,744.00,0.00,40.32,27216.00,29998.08,2782.08,729953),('1','148','257786','327',675.00,744.00,0.00,1907.49,1287555.75,1419172.56,131616.81,729954),('1','148','257787','327',675.00,744.00,0.00,708.12,477981.00,526841.28,48860.28,729955),('1','148','257788','327',675.00,744.00,0.00,1435.30,968827.50,1067863.20,99035.70,729956),('1','148','257789','327',675.00,744.00,0.00,589.87,398162.25,438863.28,40701.03,729957),('1','148','257790','327',675.00,744.00,0.00,0.00,0.00,0.00,0.00,729958),('1','148','257791','327',675.00,736.00,0.00,1150.50,776587.50,846768.00,70180.50,729959),('1','148','257792','327',675.00,736.00,0.00,1971.22,1330573.50,1452081.92,121508.42,729960),('1','148','257793','327',675.00,736.00,0.00,1522.37,1027599.75,1120464.32,92864.57,729961),('1','148','257794','327',675.00,736.00,0.00,901.82,608728.50,663739.52,55011.02,729962),('1','148','257795','327',670.00,736.00,0.00,1543.62,1034225.40,1140368.32,106142.92,729963),('1','148','257796','327',670.00,736.00,0.00,2196.04,1471346.80,1616285.44,144938.64,729964),('1','148','257797','327',670.00,736.00,0.00,478.52,320608.40,352190.72,31582.32,729965),('1','148','257798','327',670.00,736.00,0.00,527.49,353418.30,388232.64,34814.34,729966),('1','148','257799','327',670.00,736.00,0.00,1662.41,1113814.70,1223533.76,109719.06,729967),('1','148','257800','327',670.00,736.00,0.00,932.42,624721.40,686261.12,61539.72,729968),('1','148','257801','327',670.00,736.00,0.00,1555.39,1042111.30,1144767.04,102655.74,729969),('1','148','257802','327',670.00,736.00,0.00,302.29,202534.30,222485.44,19951.14,729970),('1','148','257803','327',670.00,736.00,0.00,991.59,664365.30,729810.24,65444.94,729971),('1','148','257804','327',670.00,736.00,0.00,1032.33,691661.10,759794.88,68133.78,729972),('1','148','257805','327',670.00,736.00,0.00,1814.56,1215755.20,1335516.16,119760.96,729973),('1','148','257806','327',670.00,736.00,0.00,310.34,207927.80,228410.24,20482.44,729974),('1','148','257807','327',670.00,736.00,0.00,251.91,168779.70,185405.76,16626.06,729975),('1','148','257808','327',670.00,736.00,0.00,2801.03,1876690.10,2061558.08,184867.98,729976),('1','148','257809','327',670.00,736.00,0.00,2134.60,1430182.00,1571065.60,140883.60,729977),('1','148','257810','327',670.00,736.00,0.00,0.00,0.00,0.00,0.00,729978),('1','148','257811','327',670.00,736.00,0.00,1906.70,1277489.00,1403331.20,125842.20,729979),('1','148','257812','327',670.00,736.00,0.00,1587.22,1063437.40,1168193.92,104756.52,729980),('1','148','257813','327',670.00,736.00,0.00,1171.73,785059.10,862393.28,77334.18,729981),('1','148','257814','327',670.00,736.00,0.00,4095.65,2744085.50,3014398.40,270312.90,729982),('1','148','257815','327',670.00,736.00,0.00,724.72,485562.40,533393.92,47831.52,729983),('1','148','257816','327',675.00,764.00,0.00,2755.77,1860144.75,2105408.28,245263.53,729984),('1','148','257817','327',675.00,764.00,0.00,1438.82,225524.25,1081583.12,856058.87,729985),('1','148','257818','327',675.00,748.00,0.00,2943.34,1986754.50,2201618.32,214863.82,729986),('1','148','257819','327',675.00,748.00,0.00,2292.13,1547187.75,1714513.24,167325.49,729987),('1','148','257820','327',675.00,748.00,0.00,0.00,0.00,0.00,0.00,729988),('1','148','257821','327',675.00,748.00,0.00,2170.46,1465060.50,1623504.08,158443.58,729989),('1','148','257822','327',675.00,748.00,0.00,2804.87,1893287.25,2098042.76,204755.51,729990),('1','148','257823','327',675.00,748.00,0.00,1196.92,807921.00,895296.16,87375.16,729991),('1','148','257824','327',675.00,748.00,0.00,1849.01,1248081.75,1383059.48,134977.73,729992),('1','148','257825','327',0.00,760.00,0.00,1542.69,0.00,1172444.40,1172444.40,729993),('1','148','257826','327',0.00,760.00,0.00,0.00,0.00,0.00,0.00,729994),('1','148','257827','327',675.00,760.00,0.00,1699.60,1147230.00,1291696.00,144466.00,729995),('1','148','257828','327',675.00,760.00,0.00,1868.58,1261291.50,1420120.80,158829.30,729996),('1','148','257829','327',675.00,760.00,0.00,1679.87,1133912.25,1276701.20,142788.95,729997),('1','148','257830','327',675.00,760.00,0.00,1975.54,1333489.50,1501410.40,167920.90,729998),('1','148','257831','327',675.00,760.00,0.00,1342.34,906079.50,1020178.40,114098.90,729999),('1','148','257832','327',675.00,760.00,0.00,1536.06,1036840.50,1167405.60,130565.10,730000),('1','148','257833','327',0.00,800.00,0.00,327.07,0.00,260384.40,260384.40,730001),('1','148','257834','327',670.00,800.00,0.00,1651.04,1106196.80,1320832.00,214635.20,730002),('1','148','257835','327',670.00,800.00,0.00,1951.43,1307458.10,1561144.00,253685.90,730003),('1','148','257836','327',0.00,760.00,0.00,1000.10,0.00,760076.00,760076.00,730004),('1','148','257837','327',0.00,760.00,0.00,348.24,187693.80,264662.40,76968.60,730005),('1','148','257838','327',670.00,760.00,0.00,2350.62,1574915.40,1786471.20,211555.80,730006),('1','148','257839','327',670.00,760.00,0.00,1696.24,1136480.80,1289142.40,152661.60,730007),('1','148','257840','327',670.00,760.00,0.00,1236.97,828769.90,940097.20,111327.30,730008),('1','148','257841','327',670.00,760.00,0.00,0.00,0.00,0.00,0.00,730009),('1','148','257842','327',670.00,760.00,0.00,1090.95,730936.50,829122.00,98185.50,730010),('1','148','257843','327',670.00,760.00,0.00,1919.48,1286051.60,1458804.80,172753.20,730011),('1','148','257844','327',670.00,760.00,0.00,1947.67,1304938.90,1480229.20,175290.30,730012),('1','148','257845','327',670.00,760.00,0.00,311.90,208973.00,237044.00,28071.00,730013),('1','148','257846','327',670.00,760.00,0.00,749.95,502466.50,569962.00,67495.50,730014),('1','148','257847','327',670.00,760.00,0.00,1441.93,966093.10,1095866.80,129773.70,730015),('1','148','257848','327',670.00,760.00,0.00,1298.08,869713.60,986540.80,116827.20,730016),('1','148','257849','327',670.00,760.00,0.00,1071.09,717719.10,814028.40,96309.30,730017),('1','148','257850','327',685.00,760.00,0.00,169.54,116134.90,128850.40,12715.50,730018),('1','148','257851','327',685.00,760.00,0.00,962.21,659113.85,731279.60,72165.75,730019),('1','148','257852','327',685.00,760.00,0.00,1889.02,1293978.70,1435655.20,141676.50,730020),('1','148','257853','327',685.00,760.00,0.00,1676.95,1148710.75,1274482.00,125771.25,730021),('1','148','257854','327',685.00,760.00,0.00,0.00,0.00,0.00,0.00,730022),('1','148','257855','327',685.00,760.00,0.00,1630.61,1116967.85,1239263.60,122295.75,730023),('1','148','257856','327',685.00,760.00,0.00,1562.38,1070230.30,1187408.80,117178.50,730024),('1','148','257857','327',685.00,760.00,0.00,1391.60,953246.00,1057616.00,104370.00,730025),('1','148','257858','327',685.00,760.00,0.00,1035.04,709002.40,786630.40,77628.00,730026),('1','148','257859','327',685.00,760.00,0.00,332.06,227461.10,252365.60,24904.50,730027),('1','148','257860','327',685.00,760.00,0.00,1460.21,1000243.85,1109759.60,109515.75,730028),('1','148','257861','327',685.00,760.00,0.00,1864.83,1277408.55,1417270.80,139862.25,730029),('1','148','257862','327',685.00,760.00,0.00,1550.74,1062256.90,1178562.40,116305.50,730030),('1','148','257863','327',685.00,760.00,0.00,1668.15,1142682.75,1267794.00,125111.25,730031),('1','148','257864','327',685.00,760.00,0.00,1159.73,794415.05,881394.80,86979.75,730032),('1','148','257865','327',685.00,760.00,0.00,1220.40,835974.00,927504.00,91530.00,730033),('1','148','257866','327',685.00,760.00,0.00,1056.04,723387.40,802590.40,79203.00,730034),('1','148','257867','327',685.00,760.00,0.00,1603.59,1098459.15,1218728.40,120269.25,730035),('1','148','257868','327',685.00,760.00,0.00,1694.26,1160568.10,1287637.60,127069.50,730036),('1','148','257869','327',685.00,760.00,0.00,1924.68,1318405.80,1462756.80,144351.00,730037),('1','148','257870','327',685.00,760.00,0.00,1244.02,852153.70,945455.20,93301.50,730038),('1','148','257871','327',685.00,760.00,0.00,1504.48,1030568.80,1146644.80,116076.00,730039),('1','148','257872','327',685.00,760.00,0.00,1624.15,1112542.75,1234354.00,121811.25,730040),('1','148','257873','327',685.00,760.00,0.00,824.88,562832.40,626908.80,64076.40,730041),('1','148','257874','327',670.00,760.00,0.00,419.84,281292.80,319078.40,37785.60,730042),('1','148','257875','327',670.00,760.00,0.00,1381.21,925410.70,1049719.60,124308.90,730043),('1','148','257876','327',670.00,760.00,0.00,1999.86,1339906.20,1519893.60,179987.40,730044),('1','148','257877','327',670.00,760.00,0.00,1368.14,916653.80,1039786.40,123132.60,730045),('1','148','257878','327',670.00,760.00,0.00,457.90,306793.00,348004.00,41211.00,730046),('1','148','257879','327',670.00,760.00,0.00,1988.79,1332489.30,1513020.40,180531.10,730047),('1','148','257880','327',670.00,760.00,0.00,1615.30,1082251.00,1227628.00,145377.00,730048),('1','148','257881','327',670.00,760.00,0.00,972.70,651709.00,739252.00,87543.00,730049),('1','148','257882','327',670.00,760.00,0.00,1597.03,1070010.10,1213742.80,143732.70,730050),('1','148','257883','327',670.00,760.00,0.00,1404.54,250647.00,1042988.16,792341.16,730051),('1','148','257884','327',0.00,736.00,0.00,1629.90,0.00,1199606.40,1199606.40,730052),('1','148','257885','327',0.00,736.00,0.00,0.00,0.00,0.00,0.00,730053),('1','148','257886','327',0.00,736.00,0.00,1852.38,1241094.60,1363351.68,122257.08,730054),('1','148','257887','327',670.00,736.00,0.00,1245.65,834585.50,916798.40,82212.90,730055),('1','148','257888','327',670.00,736.00,0.00,1417.30,949591.00,1043132.80,93541.80,730056),('1','148','257889','327',670.00,736.00,0.00,1415.50,948385.00,1041808.00,93423.00,730057),('1','148','257890','327',670.00,736.00,0.00,0.00,0.00,0.00,0.00,730058),('1','148','257891','327',670.00,736.00,0.00,1688.32,1124249.92,1242603.52,118353.60,730059),('1','148','257892','327',664.00,736.00,0.00,1650.91,1096204.24,1215069.76,118865.52,730060),('1','148','257893','327',664.00,736.00,0.00,1765.33,1172179.12,1299282.88,127103.76,730061),('1','148','257894','327',664.00,736.00,0.00,477.82,317272.48,351675.52,34403.04,730062),('1','148','257895','327',664.00,736.00,0.00,971.13,644830.32,714751.68,69921.36,730063),('1','148','257896','327',664.00,736.00,0.00,1326.02,880477.28,975950.72,95473.44,730064),('1','148','257897','327',664.00,736.00,0.00,1538.08,1021285.12,1132026.88,110741.76,730065),('1','148','257898','327',664.00,736.00,0.00,1422.66,944646.24,1047077.76,102431.52,730066),('1','148','257899','327',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730067),('1','148','257900','327',664.00,736.00,0.00,342.18,227207.52,251844.48,24636.96,730068),('1','148','257901','327',664.00,736.00,0.00,2354.77,1563567.28,1733110.72,169543.44,730069),('1','148','257902','327',664.00,736.00,0.00,2086.07,1385150.48,1535347.52,150197.04,730070),('1','148','257903','327',664.00,736.00,0.00,902.31,599133.84,664100.16,64966.32,730071),('1','148','257904','327',664.00,736.00,0.00,472.82,313952.48,347995.52,34043.04,730072),('1','148','257905','327',664.00,736.00,0.00,2353.01,1562398.64,1731815.36,169416.72,730073),('1','148','257906','327',664.00,736.00,0.00,1907.67,1266692.88,1404045.12,137352.24,730074),('1','148','257907','327',664.00,736.00,0.00,1410.51,936578.64,1038135.36,101556.72,730075),('1','148','257908','327',664.00,736.00,0.00,1441.86,957395.04,1061208.96,103813.92,730076),('1','148','257909','327',664.00,736.00,0.00,1546.55,1026909.20,1138260.80,111351.60,730077),('1','148','257910','327',664.00,736.00,0.00,1140.73,757444.72,839577.28,82132.56,730078),('1','148','257911','327',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730079),('1','148','257912','327',664.00,736.00,0.00,1973.66,1310510.24,1452613.76,142103.52,730080),('1','148','257913','327',664.00,736.00,0.00,2044.64,1357640.96,1504855.04,147214.08,730081),('1','148','257914','327',664.00,736.00,0.00,1175.50,780532.00,865168.00,84636.00,730082),('1','148','257915','327',664.00,736.00,0.00,748.07,496718.48,550579.52,53861.04,730083),('1','148','257916','327',664.00,736.00,0.00,1682.78,1117365.92,1238526.08,121160.16,730084),('1','148','257917','327',664.00,736.00,0.00,1500.82,996544.48,1104603.52,108059.04,730085),('1','148','257918','327',664.00,736.00,0.00,1295.00,859880.00,953120.00,93240.00,730086),('1','148','257919','327',664.00,736.00,0.00,1832.73,1216932.72,1348889.28,131956.56,730087),('1','148','257920','327',664.00,736.00,0.00,1790.09,1188619.76,1317506.24,128886.48,730088),('1','148','257921','327',664.00,736.00,0.00,1816.78,1206341.92,1337150.08,130808.16,730089),('1','148','257922','327',664.00,736.00,0.00,945.74,627971.36,696064.64,68093.28,730090),('1','148','257923','327',664.00,736.00,0.00,1883.76,1250816.64,1386447.36,135630.72,730091),('1','148','257924','327',664.00,736.00,0.00,1557.62,1034259.68,1146408.32,112148.64,730092),('1','148','257925','327',664.00,736.00,0.00,861.85,572268.40,634321.60,62053.20,730093),('1','148','257926','327',664.00,736.00,0.00,1775.31,1178805.84,1306628.16,127822.32,730094),('1','148','257927','327',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730095),('1','148','257928','327',664.00,736.00,0.00,716.73,475908.72,527513.28,51604.56,730096),('1','148','257929','327',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730097),('1','148','257930','327',664.00,736.00,0.00,2727.01,1810734.64,2007079.36,196344.72,730098),('1','148','257931','327',664.00,736.00,0.00,1546.17,1026656.88,1137981.12,111324.24,730099),('1','148','257932','327',664.00,736.00,0.00,829.22,550602.08,610305.92,59703.84,730100),('1','148','257933','327',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730101),('1','148','257934','327',664.00,736.00,0.00,1828.09,1213851.76,1345474.24,131622.48,730102),('1','148','257935','327',664.00,736.00,0.00,1952.42,1296406.88,1452559.08,156152.20,730103),('1','148','257936','327',664.00,736.00,0.00,1175.45,780498.80,865131.20,84632.40,730104),('1','148','257937','327',664.00,736.00,0.00,84.04,55802.56,61853.44,6050.88,730105),('1','148','257938','327',664.00,736.00,0.00,1565.94,1039784.16,1152531.84,112747.68,730106),('1','148','257939','327',664.00,736.00,0.00,1936.58,1245225.68,1427086.88,181861.20,730107),('1','148','257940','327',640.00,736.00,0.00,1372.62,878476.80,1010248.32,131771.52,730108),('1','148','257941','327',640.00,736.00,0.00,419.58,268531.20,308810.88,40279.68,730109),('1','148','257942','327',640.00,736.00,0.00,1445.05,924832.00,1063556.80,138724.80,730110),('1','148','257943','327',640.00,736.00,0.00,1434.90,918336.00,1056086.40,137750.40,730111),('1','148','257944','327',640.00,736.00,0.00,1737.81,1112198.40,1284956.16,172757.76,730112),('1','148','257945','327',640.00,736.00,0.00,957.62,612876.80,704808.32,91931.52,730113),('1','148','257946','327',640.00,736.00,0.00,1779.99,1139193.60,1310072.64,170879.04,730114),('1','148','257947','327',640.00,736.00,0.00,2138.47,1368620.80,1573913.92,205293.12,730115),('1','148','257948','327',640.00,736.00,0.00,955.30,611392.00,703100.80,91708.80,730116),('1','148','257949','327',640.00,736.00,0.00,1106.09,707897.60,814082.24,106184.64,730117),('1','148','257950','327',640.00,736.00,0.00,1609.43,1030035.20,1184540.48,154505.28,730118),('1','148','257951','327',640.00,736.00,0.00,1720.50,1101120.00,1266288.00,165168.00,730119),('1','148','257952','327',640.00,736.00,0.00,571.08,365491.20,420314.88,54823.68,730120),('1','148','257953','327',640.00,736.00,0.00,1469.92,940748.80,1081861.12,141112.32,730121),('1','148','257954','327',640.00,736.00,0.00,2338.49,1496633.60,1721128.64,224495.04,730122),('1','148','257955','327',640.00,736.00,0.00,1529.29,978745.60,1125557.44,146811.84,730123),('1','148','257956','327',640.00,736.00,0.00,462.16,295782.40,340149.76,44367.36,730124),('1','148','257957','327',640.00,736.00,0.00,429.18,274675.20,315876.48,41201.28,730125),('1','148','257958','327',640.00,736.00,0.00,877.66,561702.40,645957.76,84255.36,730126),('1','148','257959','327',640.00,736.00,0.00,209.55,134112.00,154228.80,20116.80,730127),('1','148','257960','327',640.00,736.00,0.00,1996.01,1277446.40,1469063.36,191616.96,730128),('1','148','257961','327',640.00,736.00,0.00,1692.88,1083443.20,1245959.68,162516.48,730129),('1','148','257962','327',640.00,736.00,0.00,541.50,346560.00,398544.00,51984.00,730130),('1','148','257963','327',640.00,736.00,0.00,72.40,46336.00,53286.40,6950.40,730131),('1','148','257964','327',640.00,736.00,0.00,1191.69,762681.60,877083.84,114402.24,730132),('1','148','257965','327',640.00,736.00,0.00,1822.15,1166176.00,1341102.40,174926.40,730133),('1','148','257966','327',640.00,736.00,0.00,1410.16,902502.40,1037877.76,135375.36,730134),('1','148','257967','327',640.00,736.00,0.00,1064.23,681107.20,783273.28,102166.08,730135),('1','148','257968','327',640.00,736.00,0.00,602.22,385420.80,443233.92,57813.12,730136),('1','148','257969','327',640.00,736.00,0.00,534.88,342323.20,393671.68,51348.48,730137),('1','148','257970','327',640.00,736.00,0.00,1106.65,708256.00,814494.40,106238.40,730138),('1','148','257971','327',640.00,736.00,0.00,1031.96,660454.40,759522.56,99068.16,730139),('1','148','257972','327',640.00,736.00,0.00,1461.69,935481.60,1075803.84,140322.24,730140),('1','148','257973','327',640.00,736.00,0.00,1064.82,681484.80,783707.52,102222.72,730141),('1','148','257974','327',640.00,736.00,0.00,1188.45,760608.00,874699.20,114091.20,730142),('1','148','257975','327',640.00,736.00,0.00,655.42,419468.80,482389.12,62920.32,730143),('1','148','257976','327',640.00,736.00,0.00,1603.92,1026508.80,1180485.12,153976.32,730144),('1','148','257977','327',640.00,736.00,0.00,1342.96,859494.40,988418.56,128924.16,730145),('1','148','257978','327',640.00,736.00,0.00,0.00,0.00,0.00,0.00,730146),('1','148','257979','327',640.00,736.00,0.00,1837.42,1175948.80,1352341.12,176392.32,730147),('1','148','257980','327',640.00,736.00,0.00,2075.25,1328160.00,1527384.00,199224.00,730148),('1','148','257981','327',640.00,736.00,0.00,1267.33,811091.20,932754.88,121663.68,730149),('1','148','257982','327',640.00,736.00,0.00,584.21,373894.40,429978.56,56084.16,730150),('1','148','257983','327',640.00,736.00,0.00,1329.19,850681.60,978283.84,127602.24,730151),('1','148','257984','327',640.00,736.00,0.00,998.38,638963.20,734807.68,95844.48,730152),('1','148','257985','327',640.00,736.00,0.00,1063.19,680441.60,782507.84,102066.24,730153),('1','148','257986','327',640.00,736.00,0.00,1217.94,779481.60,896403.84,116922.24,730154),('1','148','257987','327',640.00,736.00,0.00,1248.86,799270.40,919160.96,119890.56,730155),('1','148','257988','327',640.00,736.00,0.00,2165.59,1385977.60,1593874.24,207896.64,730156),('1','148','257989','327',640.00,736.00,0.00,2020.67,1293228.80,1487213.12,193984.32,730157),('1','148','257990','327',640.00,736.00,0.00,1031.68,660275.20,759316.48,99041.28,730158),('1','148','257991','327',640.00,736.00,0.00,1358.37,869356.80,999760.32,130403.52,730159),('1','148','257992','327',640.00,736.00,0.00,1359.21,19654.40,952552.56,932898.16,730160),('1','148','257993','327',0.00,700.00,0.00,1504.78,0.00,1053346.00,1053346.00,730161),('1','148','257994','327',0.00,700.00,0.00,757.93,0.00,530551.00,530551.00,730162),('1','148','257995','327',0.00,700.00,0.00,586.26,0.00,410382.00,410382.00,730163),('1','148','257996','327',634.00,700.00,0.00,973.22,617021.48,681254.00,64232.52,730164),('1','148','257997','327',634.00,700.00,0.00,1815.97,1151324.98,1271179.00,119854.02,730165),('1','148','257998','327',634.00,700.00,0.00,1108.42,702738.28,775894.00,73155.72,730166),('1','148','257999','327',634.00,700.00,0.00,860.76,545721.84,602532.00,56810.16,730167),('1','148','258000','327',634.00,700.00,0.00,0.00,0.00,0.00,0.00,730168),('1','148','258001','327',634.00,700.00,0.00,302.35,191689.90,211645.00,19955.10,730169),('1','148','258002','327',634.00,700.00,0.00,1160.25,735598.50,812175.00,76576.50,730170),('1','148','258003','327',634.00,700.00,0.00,1491.45,945579.30,1044015.00,98435.70,730171),('1','148','258004','327',634.00,700.00,0.00,1385.51,878413.34,969857.00,91443.66,730172),('1','148','258005','327',634.00,700.00,0.00,1109.79,703606.86,776853.00,73246.14,730173),('1','148','258006','327',634.00,700.00,0.00,1179.01,747492.34,825307.00,77814.66,730174);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=305 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',304,'148','PRODUCT TANK','TANK CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=770 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','148','304',769,1,'327','LPG TANK',7000.00,1.00,4254.22,'TANK CONTAINING LPG','479','2020-08-10 20:35:27','2020-08-12 11:58:41','487',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','148',769,4001.64,'2023-03-20 19:38:44');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2735867 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2107790,'1','148','769',327,'Return of Retail Sale Id 1253354',0.00,192000.00,300.00,0.00,-11400.00,'2021-12-01 05:49:21','',''),(2107795,'1','148','769',327,'Retail Sale Id 1253921',31680.00,0.00,0.00,0.00,1881.00,'2021-12-01 05:51:45','',''),(2107796,'1','148','769',327,'Retail sales',0.00,0.00,0.00,49.50,0.00,'2021-12-01 05:51:45','',''),(2107805,'1','148','769',327,'Retail Sale Id 1253926',349989.24,0.00,0.00,0.00,2310.16,'2021-12-01 05:53:28','',''),(2107806,'1','148','769',327,'Retail sales',0.00,0.00,0.00,577.54,0.00,'2021-12-01 05:53:28','',''),(2107895,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,3214680.00,5340.00,0.00,0.00,'2021-12-01 06:03:59','',''),(2107914,'1','148',NULL,327,'Reception corrector for bridging 125796',0.00,0.00,0.00,5340.00,0.00,'2021-12-01 06:05:29','',''),(2107915,'1','148','769',327,'Received from bridging 125796',0.00,0.00,5340.00,0.00,0.00,'2021-12-01 06:05:29','',''),(2107930,'1','148','769',327,'Retail Sale Id 1253985',308857.60,0.00,0.00,0.00,18338.42,'2021-12-01 06:07:11','',''),(2107931,'1','148','769',327,'Retail sales',0.00,0.00,0.00,482.59,0.00,'2021-12-01 06:07:11','',''),(2107944,'1','148','769',327,'Retail Sale Id 1253992',393372.78,0.00,0.00,0.00,2596.52,'2021-12-01 06:08:26','',''),(2107945,'1','148','769',327,'Retail sales',0.00,0.00,0.00,649.13,0.00,'2021-12-01 06:08:26','',''),(2108237,'1','148','769',327,'Retail Sale Id 1254140',44800.00,0.00,0.00,0.00,2660.00,'2021-12-01 06:34:12','',''),(2108238,'1','148','769',327,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-01 06:34:12','',''),(2108285,'1','148','769',327,'Retail Sale Id 1254157',19200.00,0.00,0.00,0.00,1140.00,'2021-12-01 06:36:05','',''),(2108286,'1','148','769',327,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-01 06:36:05','',''),(2108295,'1','148','769',327,'Retail Sale Id 1254163',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 06:36:38','',''),(2108296,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:36:38','',''),(2108303,'1','148','769',327,'Retail Sale Id 1254167',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 06:37:07','',''),(2108304,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 06:37:07','',''),(2108311,'1','148','769',327,'Retail Sale Id 1254170',998.40,0.00,0.00,0.00,59.28,'2021-12-01 06:37:56','',''),(2108312,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 06:37:56','',''),(2108528,'1','148','769',327,'Retail Sale Id 1254274',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 06:53:23','',''),(2108529,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 06:53:23','',''),(2108569,'1','148','769',327,'Retail Sale Id 1254293',35200.00,0.00,0.00,0.00,2090.00,'2021-12-01 06:55:01','',''),(2108570,'1','148','769',327,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-01 06:55:01','',''),(2108613,'1','148','769',327,'Retail Sale Id 1254315',998.40,0.00,0.00,0.00,59.28,'2021-12-01 06:57:05','',''),(2108614,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 06:57:05','',''),(2108965,'1','148','769',327,'Retail Sale Id 1254463',16000.00,0.00,0.00,0.00,950.00,'2021-12-01 07:12:59','',''),(2108966,'1','148','769',327,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 07:12:59','',''),(2109051,'1','148','769',327,'Retail Sale Id 1254509',32000.00,0.00,0.00,0.00,1900.00,'2021-12-01 07:18:04','',''),(2109052,'1','148','769',327,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 07:18:04','',''),(2109098,'1','148','769',327,'Retail Sale Id 1254530',6003.20,0.00,0.00,0.00,356.44,'2021-12-01 07:20:04','',''),(2109099,'1','148','769',327,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-01 07:20:04','',''),(2109556,'1','148','769',327,'Retail Sale Id 1254730',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 07:41:27','',''),(2109557,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 07:41:27','',''),(2109594,'1','148','769',327,'Retail Sale Id 1254749',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 07:43:02','',''),(2109595,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 07:43:02','',''),(2109650,'1','148','769',327,'Retail Sale Id 1254773',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 07:45:20','',''),(2109651,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 07:45:20','',''),(2109770,'1','148','769',327,'Retail Sale Id 1254828',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 07:50:17','',''),(2109771,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 07:50:17','',''),(2109858,'1','148','769',327,'Retail Sale Id 1254867',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 07:54:30','',''),(2109859,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 07:54:30','',''),(2109874,'1','148','769',327,'Retail Sale Id 1254880',998.40,0.00,0.00,0.00,59.28,'2021-12-01 07:55:23','',''),(2109875,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 07:55:23','',''),(2110050,'1','148','769',327,'Retail Sale Id 1254969',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 08:04:34','',''),(2110051,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 08:04:34','',''),(2110060,'1','148','769',327,'Retail Sale Id 1254973',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 08:05:20','',''),(2110061,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:05:20','',''),(2110102,'1','148','769',327,'Retail Sale Id 1254988',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 08:07:33','',''),(2110103,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 08:07:33','',''),(2110118,'1','148','769',327,'Retail Sale Id 1254995',1952.00,0.00,0.00,0.00,115.90,'2021-12-01 08:08:24','',''),(2110119,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 08:08:24','',''),(2110617,'1','148','769',327,'Retail Sale Id 1255239',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 08:38:01','',''),(2110618,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 08:38:01','',''),(2110651,'1','148','769',327,'Retail Sale Id 1255254',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 08:40:05','',''),(2110652,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:40:05','',''),(2111048,'1','148','769',327,'Retail Sale Id 1255465',4998.40,0.00,0.00,0.00,296.78,'2021-12-01 09:03:07','',''),(2111049,'1','148','769',327,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 09:03:07','',''),(2111132,'1','148','769',327,'Retail Sale Id 1255505',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 09:08:14','',''),(2111133,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 09:08:14','',''),(2111160,'1','148','769',327,'Retail Sale Id 1255517',7001.60,0.00,0.00,0.00,415.72,'2021-12-01 09:09:37','',''),(2111161,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-01 09:09:37','',''),(2111244,'1','148','769',327,'Retail Sale Id 1255564',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 09:14:55','',''),(2111245,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 09:14:55','',''),(2111284,'1','148','769',327,'Retail Sale Id 1255589',902.40,0.00,0.00,0.00,53.58,'2021-12-01 09:16:51','',''),(2111285,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-01 09:16:51','',''),(2111338,'1','148','769',327,'Retail Sale Id 1255620',3852.80,0.00,0.00,0.00,228.76,'2021-12-01 09:20:34','',''),(2111339,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-01 09:20:34','',''),(2111406,'1','148','769',327,'Retail Sale Id 1255656',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 09:25:10','',''),(2111407,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 09:25:10','',''),(2111662,'1','148','769',327,'Retail Sale Id 1255786',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 09:40:23','',''),(2111663,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:40:23','',''),(2111736,'1','148','769',327,'Retail Sale Id 1255822',32000.00,0.00,0.00,0.00,1900.00,'2021-12-01 09:46:12','',''),(2111737,'1','148','769',327,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 09:46:12','',''),(2111756,'1','148','769',327,'Retail Sale Id 1255842',4998.40,0.00,0.00,0.00,296.78,'2021-12-01 09:47:53','',''),(2111757,'1','148','769',327,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 09:47:53','',''),(2111839,'1','148','769',327,'Retail Sale Id 1255877',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 09:54:14','',''),(2111840,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 09:54:14','',''),(2111961,'1','148','769',327,'Retail Sale Id 1255930',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 10:01:03','',''),(2111962,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:01:03','',''),(2112045,'1','148','769',327,'Retail Sale Id 1255974',3699.20,0.00,0.00,0.00,219.64,'2021-12-01 10:07:55','',''),(2112046,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.78,0.00,'2021-12-01 10:07:55','',''),(2112259,'1','148','769',327,'Retail Sale Id 1256082',32000.00,0.00,0.00,0.00,1900.00,'2021-12-01 10:21:56','',''),(2112260,'1','148','769',327,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 10:21:56','',''),(2112303,'1','148','769',327,'Retail Sale Id 1256098',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 10:26:14','',''),(2112304,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:26:14','',''),(2112528,'1','148','769',327,'Retail Sale Id 1256209',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 10:42:57','',''),(2112529,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:42:57','',''),(2112642,'1','148','769',327,'Retail Sale Id 1256269',192000.00,0.00,0.00,0.00,11400.00,'2021-12-01 10:52:57','',''),(2112643,'1','148','769',327,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-01 10:52:57','',''),(2112816,'1','148','769',327,'Retail Sale Id 1256272',57600.00,0.00,0.00,0.00,3420.00,'2021-12-01 11:07:47','',''),(2112817,'1','148','769',327,'Retail sales',0.00,0.00,0.00,90.00,0.00,'2021-12-01 11:07:47','',''),(2112935,'1','148','769',327,'Retail Sale Id 1256415',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 11:15:02','',''),(2112936,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:15:02','',''),(2113016,'1','148','769',327,'Retail Sale Id 1256448',32640.00,0.00,0.00,0.00,1938.00,'2021-12-01 11:18:41','',''),(2113017,'1','148','769',327,'Retail sales',0.00,0.00,0.00,51.00,0.00,'2021-12-01 11:18:41','',''),(2113437,'1','148','769',327,'Retail Sale Id 1256663',-32000.00,0.00,0.00,0.00,-1900.00,'2021-12-01 11:48:24','',''),(2113438,'1','148','769',327,'Retail sales',0.00,0.00,0.00,-50.00,0.00,'2021-12-01 11:48:24','',''),(2113467,'1','148','769',327,'Retail Sale Id 1256679',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 11:50:19','',''),(2113468,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:50:19','',''),(2113483,'1','148','769',327,'Retail Sale Id 1256684',16000.00,0.00,0.00,0.00,950.00,'2021-12-01 11:52:03','',''),(2113484,'1','148','769',327,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 11:52:03','',''),(2113541,'1','148','769',327,'Retail Sale Id 1256717',79360.00,0.00,0.00,0.00,4712.00,'2021-12-01 11:56:20','',''),(2113542,'1','148','769',327,'Retail sales',0.00,0.00,0.00,124.00,0.00,'2021-12-01 11:56:20','',''),(2113559,'1','148','769',327,'Retail Sale Id 1256726',35200.00,0.00,0.00,0.00,2090.00,'2021-12-01 11:58:17','',''),(2113560,'1','148','769',327,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-01 11:58:17','',''),(2114039,'1','148','769',327,'Retail Sale Id 1256976',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 12:38:24','',''),(2114040,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:38:24','',''),(2114802,'1','148','769',327,'Retail Sale Id 1257370',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 13:39:32','',''),(2114803,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 13:39:32','',''),(2115021,'1','148','769',327,'Retail Sale Id 1257443',697.60,0.00,0.00,0.00,41.42,'2021-12-01 13:51:09','',''),(2115022,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-01 13:51:09','',''),(2115043,'1','148','769',327,'Retail Sale Id 1257452',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 13:52:28','',''),(2115044,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 13:52:28','',''),(2115477,'1','148','769',327,'Retail Sale Id 1257682',3801.60,0.00,0.00,0.00,225.72,'2021-12-01 14:18:42','',''),(2115478,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-01 14:18:42','',''),(2115897,'1','148','769',327,'Retail Sale Id 1257891',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 14:49:36','',''),(2115898,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:49:36','',''),(2116742,'1','148','769',327,'Retail Sale Id 1258270',16000.00,0.00,0.00,0.00,950.00,'2021-12-01 15:42:51','',''),(2116743,'1','148','769',327,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 15:42:51','',''),(2117726,'1','148','769',327,'Retail Sale Id 1258730',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 16:23:27','',''),(2117727,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:23:27','',''),(2118002,'1','148','769',327,'Retail Sale Id 1258887',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 16:37:05','',''),(2118003,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:37:05','',''),(2120284,'1','148','769',327,'Return of Retail Sale Id 1256269',0.00,192000.00,300.00,0.00,-11400.00,'2021-12-02 05:51:14','',''),(2120292,'1','148','769',327,'Return of Retail Sale Id 1256679',0.00,8000.00,12.50,0.00,-475.00,'2021-12-02 05:52:14','',''),(2120302,'1','148','769',327,'Return of Retail Sale Id 1256209',0.00,8000.00,12.50,0.00,-475.00,'2021-12-02 05:53:58','',''),(2120311,'1','148','769',327,'Retail Sale Id 1259808',5312.00,0.00,0.00,0.00,315.40,'2021-12-02 05:56:29','',''),(2120312,'1','148','769',327,'Retail sales',0.00,0.00,0.00,8.30,0.00,'2021-12-02 05:56:29','',''),(2120417,'1','148','769',327,'Retail Sale Id 1259864',1290732.00,0.00,0.00,0.00,-4302.44,'2021-12-02 06:06:19','',''),(2120418,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2151.22,0.00,'2021-12-02 06:06:19','',''),(2121128,'1','148','769',327,'Retail Sale Id 1260170',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 06:51:50','',''),(2121129,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 06:51:50','',''),(2121154,'1','148','769',327,'Retail Sale Id 1260184',80000.00,0.00,0.00,0.00,4750.00,'2021-12-02 06:54:12','',''),(2121155,'1','148','769',327,'Retail sales',0.00,0.00,0.00,125.00,0.00,'2021-12-02 06:54:12','',''),(2121312,'1','148','769',327,'Retail Sale Id 1260251',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:03:07','',''),(2121313,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:03:07','',''),(2125468,'1','148','769',327,'Retail Sale Id 1262295',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 10:35:17','',''),(2125469,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 10:35:17','',''),(2125780,'1','148','769',327,'Retail Sale Id 1262442',4998.40,0.00,0.00,0.00,296.78,'2021-12-02 10:54:54','',''),(2125781,'1','148','769',327,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 10:54:54','',''),(2125806,'1','148','769',327,'Retail Sale Id 1262458',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 10:57:07','',''),(2125807,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 10:57:07','',''),(2125934,'1','148','769',327,'Retail Sale Id 1262528',1203.20,0.00,0.00,0.00,71.44,'2021-12-02 11:05:26','',''),(2125935,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-02 11:05:26','',''),(2125958,'1','148','769',327,'Retail Sale Id 1262543',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 11:06:51','',''),(2125959,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:06:51','',''),(2126130,'1','148','769',327,'Retail Sale Id 1262639',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 11:16:44','',''),(2126131,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 11:16:44','',''),(2126164,'1','148','769',327,'Retail Sale Id 1262658',998.40,0.00,0.00,0.00,59.28,'2021-12-02 11:18:52','',''),(2126165,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 11:18:52','',''),(2126288,'1','148','769',327,'Retail Sale Id 1262719',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 11:26:37','',''),(2126289,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 11:26:37','',''),(2126310,'1','148','769',327,'Retail Sale Id 1262728',1798.40,0.00,0.00,0.00,106.78,'2021-12-02 11:27:36','',''),(2126311,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-02 11:27:36','',''),(2126342,'1','148','769',327,'Retail Sale Id 1262748',4998.40,0.00,0.00,0.00,296.78,'2021-12-02 11:28:55','',''),(2126343,'1','148','769',327,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 11:28:55','',''),(2126370,'1','148','769',327,'Retail Sale Id 1262758',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 11:29:51','',''),(2126371,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 11:29:51','',''),(2126550,'1','148','769',327,'Retail Sale Id 1262824',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 11:37:43','',''),(2126551,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 11:37:43','',''),(2126600,'1','148','769',327,'Retail Sale Id 1262844',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 11:40:33','',''),(2126601,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 11:40:33','',''),(2127485,'1','148','769',327,'Retail Sale Id 1263307',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 12:51:29','',''),(2127486,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:51:29','',''),(2127538,'1','148','769',327,'Retail Sale Id 1263333',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 12:56:19','',''),(2127539,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 12:56:19','',''),(2127923,'1','148','769',327,'Retail Sale Id 1263509',110720.00,0.00,0.00,0.00,6574.00,'2021-12-02 13:21:56','',''),(2127924,'1','148','769',327,'Retail sales',0.00,0.00,0.00,173.00,0.00,'2021-12-02 13:21:56','',''),(2128330,'1','148','769',327,'Retail Sale Id 1263680',6003.20,0.00,0.00,0.00,356.44,'2021-12-02 13:48:04','',''),(2128331,'1','148','769',327,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 13:48:04','',''),(2128348,'1','148','769',327,'Retail Sale Id 1263688',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 13:48:59','',''),(2128349,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 13:48:59','',''),(2128434,'1','148','769',327,'Retail Sale Id 1263730',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 13:54:22','',''),(2128435,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 13:54:22','',''),(2128446,'1','148','769',327,'Retail Sale Id 1263735',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 13:55:04','',''),(2128447,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:55:04','',''),(2128485,'1','148','769',327,'Retail Sale Id 1263746',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 13:56:10','',''),(2128486,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 13:56:10','',''),(2128521,'1','148','769',327,'Retail Sale Id 1263762',697.60,0.00,0.00,0.00,41.42,'2021-12-02 13:58:15','',''),(2128522,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 13:58:15','',''),(2128552,'1','148','769',327,'Retail Sale Id 1263775',1798.40,0.00,0.00,0.00,106.78,'2021-12-02 14:00:22','',''),(2128553,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-02 14:00:22','',''),(2128564,'1','148','769',327,'Retail Sale Id 1263781',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 14:01:16','',''),(2128565,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 14:01:16','',''),(2128596,'1','148','769',327,'Retail Sale Id 1263799',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 14:03:34','',''),(2128597,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:03:34','',''),(2128702,'1','148','769',327,'Retail Sale Id 1263851',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 14:10:23','',''),(2128703,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:10:23','',''),(2128786,'1','148','769',327,'Retail Sale Id 1263880',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 14:15:05','',''),(2128787,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 14:15:05','',''),(2128806,'1','148','769',327,'Retail Sale Id 1263890',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 14:16:16','',''),(2128807,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 14:16:16','',''),(2128822,'1','148','769',327,'Retail Sale Id 1263900',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 14:17:15','',''),(2128823,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 14:17:15','',''),(2128843,'1','148','769',327,'Retail Sale Id 1263913',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 14:18:06','',''),(2128844,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:18:06','',''),(2128878,'1','148','769',327,'Retail Sale Id 1263929',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 14:19:49','',''),(2128879,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 14:19:49','',''),(2129023,'1','148','769',327,'Retail Sale Id 1263984',998.40,0.00,0.00,0.00,59.28,'2021-12-02 14:26:02','',''),(2129024,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 14:26:02','',''),(2129160,'1','148','769',327,'Retail Sale Id 1264033',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 14:31:02','',''),(2129161,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:31:02','',''),(2129204,'1','148','769',327,'Retail Sale Id 1264044',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 14:32:31','',''),(2129205,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 14:32:31','',''),(2129210,'1','148','769',327,'Retail Sale Id 1264047',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 14:33:11','',''),(2129211,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 14:33:11','',''),(2129238,'1','148','769',327,'Retail Sale Id 1264059',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 14:34:51','',''),(2129239,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 14:34:51','',''),(2129270,'1','148','769',327,'Retail Sale Id 1264076',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 14:36:43','',''),(2129271,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 14:36:43','',''),(2129313,'1','148','769',327,'Retail Sale Id 1264088',998.40,0.00,0.00,0.00,59.28,'2021-12-02 14:38:16','',''),(2129314,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 14:38:16','',''),(2129415,'1','148','769',327,'Retail Sale Id 1264126',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 14:42:04','',''),(2129416,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 14:42:04','',''),(2129541,'1','148','769',327,'Retail Sale Id 1264194',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 14:49:14','',''),(2129542,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 14:49:14','',''),(2129557,'1','148','769',327,'Retail Sale Id 1264202',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 14:50:29','',''),(2129558,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 14:50:29','',''),(2129577,'1','148','769',327,'Retail Sale Id 1264210',6400.00,0.00,0.00,0.00,380.00,'2021-12-02 14:51:42','',''),(2129578,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 14:51:42','',''),(2129665,'1','148','769',327,'Retail Sale Id 1264258',36480.00,0.00,0.00,0.00,2166.00,'2021-12-02 14:56:54','',''),(2129666,'1','148','769',327,'Retail sales',0.00,0.00,0.00,57.00,0.00,'2021-12-02 14:56:54','',''),(2129687,'1','148','769',327,'Retail Sale Id 1264271',1600.00,0.00,0.00,0.00,95.00,'2021-12-02 14:57:45','',''),(2129688,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-02 14:57:45','',''),(2129703,'1','148','769',327,'Retail Sale Id 1264279',1203.20,0.00,0.00,0.00,71.44,'2021-12-02 14:58:24','',''),(2129704,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-02 14:58:24','',''),(2129721,'1','148','769',327,'Retail Sale Id 1264287',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 14:59:08','',''),(2129722,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 14:59:08','',''),(2129731,'1','148','769',327,'Retail Sale Id 1264292',2400.00,0.00,0.00,0.00,142.50,'2021-12-02 14:59:59','',''),(2129732,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.75,0.00,'2021-12-02 14:59:59','',''),(2129735,'1','148','769',327,'Retail Sale Id 1264294',37760.00,0.00,0.00,0.00,2242.00,'2021-12-02 15:00:34','',''),(2129736,'1','148','769',327,'Retail sales',0.00,0.00,0.00,59.00,0.00,'2021-12-02 15:00:34','',''),(2129745,'1','148','769',327,'Retail Sale Id 1264299',3500.80,0.00,0.00,0.00,207.86,'2021-12-02 15:02:16','',''),(2129746,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 15:02:16','',''),(2129751,'1','148','769',327,'Retail Sale Id 1264301',3699.20,0.00,0.00,0.00,219.64,'2021-12-02 15:02:54','',''),(2129752,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.78,0.00,'2021-12-02 15:02:54','',''),(2129773,'1','148','769',327,'Retail Sale Id 1264313',998.40,0.00,0.00,0.00,59.28,'2021-12-02 15:04:43','',''),(2129774,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 15:04:43','',''),(2129813,'1','148','769',327,'Retail Sale Id 1264334',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 15:07:46','',''),(2129814,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 15:07:46','',''),(2129874,'1','148','769',327,'Retail Sale Id 1264364',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 15:11:38','',''),(2129875,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 15:11:38','',''),(2129910,'1','148','769',327,'Retail Sale Id 1264382',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 15:13:50','',''),(2129911,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 15:13:50','',''),(2129958,'1','148','769',327,'Retail Sale Id 1264408',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 15:15:50','',''),(2129959,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 15:15:50','',''),(2129982,'1','148','769',327,'Retail Sale Id 1264420',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 15:17:07','',''),(2129983,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 15:17:07','',''),(2130020,'1','148','769',327,'Retail Sale Id 1264441',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 15:19:01','',''),(2130021,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:19:01','',''),(2130060,'1','148','769',327,'Retail Sale Id 1264460',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 15:21:29','',''),(2130061,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 15:21:29','',''),(2130074,'1','148','769',327,'Retail Sale Id 1264469',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 15:22:26','',''),(2130075,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 15:22:26','',''),(2130096,'1','148','769',327,'Retail Sale Id 1264481',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 15:23:44','',''),(2130097,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:23:44','',''),(2130170,'1','148','769',327,'Retail Sale Id 1264513',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 15:26:39','',''),(2130171,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:26:39','',''),(2130229,'1','148','769',327,'Retail Sale Id 1264541',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 15:28:42','',''),(2130230,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:28:42','',''),(2130267,'1','148','769',327,'Retail Sale Id 1264557',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 15:30:24','',''),(2130268,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 15:30:24','',''),(2130287,'1','148','769',327,'Retail Sale Id 1264566',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 15:31:26','',''),(2130288,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 15:31:26','',''),(2130327,'1','148','769',327,'Retail Sale Id 1264588',4998.40,0.00,0.00,0.00,296.78,'2021-12-02 15:33:39','',''),(2130328,'1','148','769',327,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 15:33:39','',''),(2130504,'1','148','769',327,'Retail Sale Id 1264671',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 15:41:23','',''),(2130505,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:41:23','',''),(2130656,'1','148','769',327,'Retail Sale Id 1264761',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 15:48:31','',''),(2130657,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 15:48:31','',''),(2130874,'1','148','769',327,'Retail Sale Id 1264874',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 15:57:33','',''),(2130875,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 15:57:33','',''),(2130982,'1','148','769',327,'Retail Sale Id 1264926',6400.00,0.00,0.00,0.00,380.00,'2021-12-02 16:02:30','',''),(2130983,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 16:02:30','',''),(2131204,'1','148','769',327,'Retail Sale Id 1265031',6003.20,0.00,0.00,0.00,356.44,'2021-12-02 16:12:12','',''),(2131205,'1','148','769',327,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 16:12:12','',''),(2131305,'1','148','769',327,'Retail Sale Id 1265082',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 16:17:12','',''),(2131306,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 16:17:12','',''),(2131480,'1','148','769',327,'Retail Sale Id 1265165',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 16:25:59','',''),(2131481,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 16:25:59','',''),(2131498,'1','148','769',327,'Retail Sale Id 1265179',499.20,0.00,0.00,0.00,29.64,'2021-12-02 16:27:07','',''),(2131499,'1','148','769',327,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-02 16:27:07','',''),(2131522,'1','148','769',327,'Retail Sale Id 1265193',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 16:28:14','',''),(2131523,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:28:14','',''),(2131558,'1','148','769',327,'Retail Sale Id 1265211',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 16:29:16','',''),(2131559,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 16:29:16','',''),(2131618,'1','148','769',327,'Retail Sale Id 1265226',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 16:30:17','',''),(2131619,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:30:17','',''),(2131692,'1','148','769',327,'Retail Sale Id 1265269',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 16:33:31','',''),(2131693,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 16:33:31','',''),(2131897,'1','148','769',327,'Retail Sale Id 1265364',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 16:44:18','',''),(2131898,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 16:44:18','',''),(2131932,'1','148','769',327,'Retail Sale Id 1265382',1952.00,0.00,0.00,0.00,115.90,'2021-12-02 16:45:31','',''),(2131933,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 16:45:31','',''),(2131964,'1','148','769',327,'Retail Sale Id 1265402',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 16:47:09','',''),(2131965,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:47:09','',''),(2132008,'1','148','769',327,'Retail Sale Id 1265430',6400.00,0.00,0.00,0.00,380.00,'2021-12-02 16:50:18','',''),(2132009,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 16:50:18','',''),(2132038,'1','148','769',327,'Retail Sale Id 1265443',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 16:52:04','',''),(2132039,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:52:04','',''),(2132189,'1','148','769',327,'Retail Sale Id 1265515',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 17:01:28','',''),(2132190,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 17:01:28','',''),(2132311,'1','148','769',327,'Retail Sale Id 1265573',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 17:09:15','',''),(2132312,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 17:09:15','',''),(2132327,'1','148','769',327,'Retail Sale Id 1265581',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 17:10:34','',''),(2132328,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 17:10:34','',''),(2132531,'1','148','769',327,'Retail Sale Id 1265666',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 17:21:02','',''),(2132532,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 17:21:02','',''),(2132577,'1','148','769',327,'Retail Sale Id 1265692',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 17:24:20','',''),(2132578,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 17:24:20','',''),(2132653,'1','148','769',327,'Retail Sale Id 1265724',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 17:31:25','',''),(2132654,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 17:31:25','',''),(2132697,'1','148','769',327,'Retail Sale Id 1265746',3852.80,0.00,0.00,0.00,228.76,'2021-12-02 17:35:27','',''),(2132698,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 17:35:27','',''),(2132800,'1','148','769',327,'Retail Sale Id 1265794',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 17:46:21','',''),(2132801,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 17:46:21','',''),(2134119,'1','148','769',327,'Retail Sale Id 1266158',2003.20,0.00,0.00,0.00,118.94,'2021-12-03 06:24:21','',''),(2134120,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 06:24:21','',''),(2134176,'1','148','769',327,'Retail Sale Id 1266185',1203.20,0.00,0.00,0.00,71.44,'2021-12-03 06:30:01','',''),(2134177,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-03 06:30:01','',''),(2134206,'1','148','769',327,'Retail Sale Id 1266194',1497.60,0.00,0.00,0.00,88.92,'2021-12-03 06:31:14','',''),(2134207,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 06:31:14','',''),(2134218,'1','148','769',327,'Retail Sale Id 1266200',998.40,0.00,0.00,0.00,59.28,'2021-12-03 06:31:49','',''),(2134219,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 06:31:49','',''),(2134222,'1','148','769',327,'Retail Sale Id 1266202',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 06:32:44','',''),(2134223,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 06:32:44','',''),(2134229,'1','148','769',327,'Retail Sale Id 1266207',998.40,0.00,0.00,0.00,59.28,'2021-12-03 06:33:25','',''),(2134230,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 06:33:25','',''),(2134233,'1','148','769',327,'Return of Retail Sale Id 1264258',0.00,36480.00,57.00,0.00,-2166.00,'2021-12-03 06:33:34','',''),(2134242,'1','148','769',327,'Return of Retail Sale Id 1264294',0.00,37760.00,59.00,0.00,-2242.00,'2021-12-03 06:34:05','',''),(2134247,'1','148','769',327,'Retail Sale Id 1266214',3200.00,0.00,0.00,0.00,190.00,'2021-12-03 06:34:18','',''),(2134248,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 06:34:18','',''),(2134270,'1','148','769',327,'Return of Retail Sale Id 1263509',0.00,110720.00,173.00,0.00,-6574.00,'2021-12-03 06:35:10','',''),(2134310,'1','148','769',327,'Return of Retail Sale Id 1264513',0.00,8000.00,12.50,0.00,-475.00,'2021-12-03 06:37:23','',''),(2134319,'1','148','769',327,'Return of Retail Sale Id 1264481',0.00,8000.00,12.50,0.00,-475.00,'2021-12-03 06:38:01','',''),(2134360,'1','148','769',327,'Return of Retail Sale Id 1263735',0.00,8000.00,12.50,0.00,-475.00,'2021-12-03 06:40:00','',''),(2134365,'1','148','769',327,'Return of Retail Sale Id 1263781',0.00,3001.60,4.69,0.00,-178.22,'2021-12-03 06:40:32','',''),(2134374,'1','148','769',327,'Return of Retail Sale Id 1263913',0.00,8000.00,12.50,0.00,-475.00,'2021-12-03 06:41:04','',''),(2134385,'1','148','769',327,'Return of Retail Sale Id 1264441',0.00,8000.00,12.50,0.00,-475.00,'2021-12-03 06:41:48','',''),(2134396,'1','148','769',327,'Return of Retail Sale Id 1265226',0.00,8000.00,12.50,0.00,-475.00,'2021-12-03 06:42:27','',''),(2134434,'1','148','769',327,'Return of Retail Sale Id 1265443',0.00,8000.00,12.50,0.00,-475.00,'2021-12-03 06:44:32','',''),(2134461,'1','148','769',327,'Return of Retail Sale Id 1265402',0.00,8000.00,12.50,0.00,-475.00,'2021-12-03 06:45:41','',''),(2134486,'1','148','769',327,'Return of Retail Sale Id 1265794',0.00,8000.00,12.50,0.00,-475.00,'2021-12-03 06:46:43','',''),(2134523,'1','148','769',327,'Return of Retail Sale Id 1264926',0.00,6400.00,10.00,0.00,-380.00,'2021-12-03 06:48:42','',''),(2134532,'1','148','769',327,'Retail Sale Id 1266353',1952.00,0.00,0.00,0.00,115.90,'2021-12-03 06:49:08','',''),(2134533,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 06:49:08','',''),(2134538,'1','148','769',327,'Return of Retail Sale Id 1265724',0.00,8000.00,12.50,0.00,-475.00,'2021-12-03 06:49:28','',''),(2134581,'1','148','769',327,'Retail Sale Id 1266376',4665.60,0.00,0.00,0.00,277.02,'2021-12-03 06:52:09','',''),(2134582,'1','148','769',327,'Retail sales',0.00,0.00,0.00,7.29,0.00,'2021-12-03 06:52:09','',''),(2134609,'1','148','769',327,'Retail Sale Id 1266390',353526.00,0.00,0.00,0.00,-1178.42,'2021-12-03 06:53:37','',''),(2134610,'1','148','769',327,'Retail sales',0.00,0.00,0.00,589.21,0.00,'2021-12-03 06:53:37','',''),(2135366,'1','148','769',327,'Retail Sale Id 1266762',8000.00,0.00,0.00,0.00,475.00,'2021-12-03 07:36:17','',''),(2135367,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:36:17','',''),(2135400,'1','148','769',327,'Distributed to OPERATIONAL LOSS for sales id:336878',57792.00,0.00,0.00,96.00,0.00,'2021-12-03 07:37:51','',''),(2136440,'1','148','769',327,'Return of Retail Sale Id 1266762',0.00,8000.00,12.50,0.00,-475.00,'2021-12-03 08:31:42','',''),(2136529,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,3113920.00,5260.00,0.00,0.00,'2021-12-03 08:35:39','',''),(2136564,'1','148',NULL,327,'Reception corrector for bridging 126038',0.00,0.00,0.00,5260.00,0.00,'2021-12-03 08:36:41','',''),(2136565,'1','148','769',327,'Received from bridging 126038',0.00,0.00,5260.00,0.00,0.00,'2021-12-03 08:36:41','',''),(2136585,'1','148','769',327,'Retail Sale Id 1267288',301529.60,0.00,0.00,0.00,22614.72,'2021-12-03 08:37:25','',''),(2136586,'1','148','769',327,'Retail sales',0.00,0.00,0.00,471.14,0.00,'2021-12-03 08:37:25','',''),(2136635,'1','148','769',327,'Retail Sale Id 1267301',420012.00,0.00,0.00,0.00,5600.16,'2021-12-03 08:38:40','',''),(2136636,'1','148','769',327,'Retail sales',0.00,0.00,0.00,700.02,0.00,'2021-12-03 08:38:40','',''),(2136652,'1','148','769',327,'Retail Sale Id 1267308',48025.60,0.00,0.00,0.00,3601.92,'2021-12-03 08:39:31','',''),(2136653,'1','148','769',327,'Retail sales',0.00,0.00,0.00,75.04,0.00,'2021-12-03 08:39:31','',''),(2136810,'1','148','769',327,'Retail Sale Id 1267363',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 08:45:27','',''),(2136811,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:45:27','',''),(2136822,'1','148','769',327,'Retail Sale Id 1267368',128000.00,0.00,0.00,0.00,9600.00,'2021-12-03 08:46:46','',''),(2136823,'1','148','769',327,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-03 08:46:46','',''),(2136882,'1','148','769',327,'Retail Sale Id 1267401',115200.00,0.00,0.00,0.00,8640.00,'2021-12-03 08:50:20','',''),(2136883,'1','148','769',327,'Retail sales',0.00,0.00,0.00,180.00,0.00,'2021-12-03 08:50:20','',''),(2137152,'1','148','769',327,'Retail Sale Id 1267547',128000.00,0.00,0.00,0.00,9600.00,'2021-12-03 09:04:53','',''),(2137153,'1','148','769',327,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-03 09:04:53','',''),(2137213,'1','148','769',327,'Retail Sale Id 1267575',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 09:07:43','',''),(2137214,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:07:43','',''),(2137372,'1','148','769',327,'Retail Sale Id 1267678',32000.00,0.00,0.00,0.00,2400.00,'2021-12-03 09:15:37','',''),(2137373,'1','148','769',327,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 09:15:37','',''),(2137436,'1','148','769',327,'Retail Sale Id 1267716',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 09:18:33','',''),(2137437,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:18:33','',''),(2139455,'1','148','769',327,'Retail Sale Id 1268751',192000.00,0.00,0.00,0.00,14400.00,'2021-12-03 11:30:51','',''),(2139456,'1','148','769',327,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-03 11:30:51','',''),(2139471,'1','148','769',327,'Retail Sale Id 1268761',101120.00,0.00,0.00,0.00,7584.00,'2021-12-03 11:32:26','',''),(2139472,'1','148','769',327,'Retail sales',0.00,0.00,0.00,158.00,0.00,'2021-12-03 11:32:26','',''),(2139622,'1','148','769',327,'Retail Sale Id 1268846',1299.20,0.00,0.00,0.00,97.44,'2021-12-03 11:44:51','',''),(2139623,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 11:44:51','',''),(2140397,'1','148','769',327,'Retail Sale Id 1269280',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 12:45:33','',''),(2140398,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 12:45:33','',''),(2140459,'1','148','769',327,'Retail Sale Id 1269307',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 12:49:26','',''),(2140460,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 12:49:26','',''),(2140491,'1','148','769',327,'Retail Sale Id 1269323',998.40,0.00,0.00,0.00,74.88,'2021-12-03 12:51:21','',''),(2140492,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 12:51:21','',''),(2140545,'1','148','769',327,'Retail Sale Id 1269350',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 12:54:55','',''),(2140546,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 12:54:55','',''),(2140646,'1','148','769',327,'Retail Sale Id 1269398',4998.40,0.00,0.00,0.00,374.88,'2021-12-03 13:03:51','',''),(2140647,'1','148','769',327,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 13:03:51','',''),(2141532,'1','148','769',327,'Retail Sale Id 1269775',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 13:57:47','',''),(2141533,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 13:57:47','',''),(2141540,'1','148','769',327,'Retail Sale Id 1269779',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 13:58:35','',''),(2141541,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 13:58:35','',''),(2141566,'1','148','769',327,'Retail Sale Id 1269791',998.40,0.00,0.00,0.00,74.88,'2021-12-03 14:00:31','',''),(2141567,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 14:00:31','',''),(2141600,'1','148','769',327,'Retail Sale Id 1269805',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 14:02:36','',''),(2141601,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 14:02:36','',''),(2141688,'1','148','769',327,'Retail Sale Id 1269838',499.20,0.00,0.00,0.00,37.44,'2021-12-03 14:07:15','',''),(2141689,'1','148','769',327,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-03 14:07:15','',''),(2142024,'1','148','769',327,'Retail Sale Id 1269970',3852.80,0.00,0.00,0.00,288.96,'2021-12-03 14:27:23','',''),(2142025,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 14:27:23','',''),(2142044,'1','148','769',327,'Retail Sale Id 1269983',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 14:29:03','',''),(2142045,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:29:03','',''),(2142765,'1','148','769',327,'Retail Sale Id 1270289',3852.80,0.00,0.00,0.00,288.96,'2021-12-03 15:04:29','',''),(2142766,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 15:04:29','',''),(2142810,'1','148','769',327,'Retail Sale Id 1270310',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 15:07:36','',''),(2142811,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:07:36','',''),(2142822,'1','148','769',327,'Retail Sale Id 1270317',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 15:08:26','',''),(2142823,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 15:08:26','',''),(2142844,'1','148','769',327,'Retail Sale Id 1270329',4998.40,0.00,0.00,0.00,374.88,'2021-12-03 15:09:28','',''),(2142845,'1','148','769',327,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 15:09:28','',''),(2142868,'1','148','769',327,'Retail Sale Id 1270344',6400.00,0.00,0.00,0.00,480.00,'2021-12-03 15:10:40','',''),(2142869,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 15:10:40','',''),(2142994,'1','148','769',327,'Retail Sale Id 1270414',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 15:15:56','',''),(2142995,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:15:56','',''),(2144157,'1','148','769',327,'Retail Sale Id 1270993',998.40,0.00,0.00,0.00,74.88,'2021-12-03 16:07:52','',''),(2144158,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 16:07:52','',''),(2144174,'1','148','769',327,'Retail Sale Id 1271003',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 16:08:53','',''),(2144175,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 16:08:53','',''),(2144204,'1','148','769',327,'Retail Sale Id 1271020',2700.80,0.00,0.00,0.00,202.56,'2021-12-03 16:10:07','',''),(2144205,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.22,0.00,'2021-12-03 16:10:07','',''),(2144562,'1','148','769',327,'Retail Sale Id 1271204',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 16:29:57','',''),(2144563,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 16:29:57','',''),(2144600,'1','148','769',327,'Retail Sale Id 1271220',1952.00,0.00,0.00,0.00,146.40,'2021-12-03 16:31:17','',''),(2144601,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:31:17','',''),(2145107,'1','148','769',327,'Retail Sale Id 1271455',998.40,0.00,0.00,0.00,74.88,'2021-12-03 16:55:44','',''),(2145108,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 16:55:44','',''),(2146513,'1','148','769',327,'Retail Sale Id 1271960',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 05:50:02','',''),(2146514,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 05:50:02','',''),(2146534,'1','148','769',327,'Retail Sale Id 1271964',19200.00,0.00,0.00,0.00,1440.00,'2021-12-04 05:50:50','',''),(2146535,'1','148','769',327,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-04 05:50:50','',''),(2147303,'1','148','769',327,'Retail Sale Id 1272249',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 06:46:55','',''),(2147304,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:46:55','',''),(2148246,'1','148','769',327,'Retail Sale Id 1272736',3852.80,0.00,0.00,0.00,288.96,'2021-12-04 07:35:32','',''),(2148247,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 07:35:32','',''),(2148854,'1','148','769',327,'Retail Sale Id 1273123',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 08:06:30','',''),(2148855,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:06:30','',''),(2149503,'1','148','769',327,'Retail Sale Id 1273535',4998.40,0.00,0.00,0.00,374.88,'2021-12-04 08:33:02','',''),(2149504,'1','148','769',327,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 08:33:02','',''),(2149523,'1','148','769',327,'Retail Sale Id 1273541',6400.00,0.00,0.00,0.00,480.00,'2021-12-04 08:33:48','',''),(2149524,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 08:33:48','',''),(2149582,'1','148','769',327,'Retail Sale Id 1273572',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 08:36:04','',''),(2149583,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:36:04','',''),(2150529,'1','148','769',327,'Retail Sale Id 1274065',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 09:19:39','',''),(2150530,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 09:19:39','',''),(2154794,'1','148','769',327,'Retail Sale Id 1275417',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 12:43:54','',''),(2154795,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:43:54','',''),(2155878,'1','148','769',327,'Retail Sale Id 1276107',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 13:50:10','',''),(2155879,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:50:10','',''),(2157013,'1','148','769',327,'Retail Sale Id 1276619',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 14:45:42','',''),(2157014,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:45:42','',''),(2162133,'1','148','769',327,'Return of Retail Sale Id 1271964',0.00,19200.00,30.00,0.00,-1440.00,'2021-12-05 06:20:53','',''),(2162140,'1','148','769',327,'Return of Retail Sale Id 1267678',0.00,32000.00,50.00,0.00,-2400.00,'2021-12-05 06:22:03','',''),(2162153,'1','148','769',327,'Return of Retail Sale Id 1271960',0.00,8000.00,12.50,0.00,-600.00,'2021-12-05 06:23:33','',''),(2162182,'1','148','769',327,'Retail Sale Id 1278727',5280.00,0.00,0.00,0.00,396.00,'2021-12-05 06:26:40','',''),(2162183,'1','148','769',327,'Retail sales',0.00,0.00,0.00,8.25,0.00,'2021-12-05 06:26:40','',''),(2162241,'1','148','769',327,'Retail Sale Id 1278754',1629600.00,0.00,0.00,0.00,21728.00,'2021-12-05 06:31:45','',''),(2162242,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2716.00,0.00,'2021-12-05 06:31:45','',''),(2162526,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,3202720.00,5410.00,0.00,0.00,'2021-12-05 06:50:01','',''),(2162557,'1','148',NULL,327,'Reception corrector for bridging 126275',0.00,0.00,0.00,5410.00,0.00,'2021-12-05 06:51:04','',''),(2162558,'1','148','769',327,'Received from bridging 126275',0.00,0.00,5410.00,0.00,0.00,'2021-12-05 06:51:04','',''),(2162573,'1','148','769',327,'Retail Sale Id 1278895',41024.00,0.00,0.00,0.00,-338448.00,'2021-12-05 06:52:04','',''),(2162574,'1','148','769',327,'Retail sales',0.00,0.00,0.00,641.00,0.00,'2021-12-05 06:52:04','',''),(2162611,'1','148','769',327,'Retail Sale Id 1278922',1125576.00,0.00,0.00,0.00,15007.68,'2021-12-05 06:54:19','',''),(2162612,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1875.96,0.00,'2021-12-05 06:54:19','',''),(2162895,'1','148','769',327,'Retail Sale Id 1279067',256000.00,0.00,0.00,0.00,19200.00,'2021-12-05 07:10:16','',''),(2162896,'1','148','769',327,'Retail sales',0.00,0.00,0.00,400.00,0.00,'2021-12-05 07:10:16','',''),(2162911,'1','148','769',327,'Retail Sale Id 1279079',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 07:11:16','',''),(2162912,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:11:16','',''),(2164478,'1','148','769',327,'Retail Sale Id 1279965',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 08:34:48','',''),(2164479,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:34:48','',''),(2165406,'1','148','769',327,'Retail Sale Id 1280477',192000.00,0.00,0.00,0.00,14400.00,'2021-12-05 09:26:20','',''),(2165407,'1','148','769',327,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-05 09:26:20','',''),(2165566,'1','148','769',327,'Retail Sale Id 1280567',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 09:34:24','',''),(2165567,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:34:24','',''),(2166899,'1','148','769',327,'Retail Sale Id 1281185',121600.00,0.00,0.00,0.00,9120.00,'2021-12-05 10:48:52','',''),(2166900,'1','148','769',327,'Retail sales',0.00,0.00,0.00,190.00,0.00,'2021-12-05 10:48:52','',''),(2166935,'1','148','769',327,'Retail Sale Id 1281235',96000.00,0.00,0.00,0.00,7200.00,'2021-12-05 10:50:37','',''),(2166936,'1','148','769',327,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-05 10:50:37','',''),(2167872,'1','148','769',327,'Retail Sale Id 1281761',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 11:46:07','',''),(2167873,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:46:07','',''),(2169221,'1','148','769',327,'Retail Sale Id 1282475',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:54:44','',''),(2169222,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:54:44','',''),(2169865,'1','148','769',327,'Retail Sale Id 1282816',16000.00,0.00,0.00,0.00,1200.00,'2021-12-05 13:30:33','',''),(2169866,'1','148','769',327,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 13:30:33','',''),(2170521,'1','148','769',327,'Retail Sale Id 1283083',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 14:03:56','',''),(2170522,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:03:56','',''),(2172036,'1','148','769',327,'Retail Sale Id 1283736',3500.80,0.00,0.00,0.00,262.56,'2021-12-05 15:33:44','',''),(2172037,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-05 15:33:44','',''),(2172056,'1','148','769',327,'Retail Sale Id 1283745',3852.80,0.00,0.00,0.00,288.96,'2021-12-05 15:34:56','',''),(2172057,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 15:34:56','',''),(2174810,'1','148','769',327,'Return of Retail Sale Id 1281235',0.00,96000.00,150.00,0.00,-7200.00,'2021-12-06 06:06:40','',''),(2174813,'1','148','769',327,'Retail Sale Id 1284913',61286.40,0.00,0.00,0.00,4596.48,'2021-12-06 06:08:22','',''),(2174814,'1','148','769',327,'Retail sales',0.00,0.00,0.00,95.76,0.00,'2021-12-06 06:08:22','',''),(2175034,'1','148','769',327,'Retail Sale Id 1284995',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 06:33:25','',''),(2175035,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:33:25','',''),(2175040,'1','148','769',327,'Retail Sale Id 1284998',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 06:34:04','',''),(2175041,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:34:04','',''),(2175067,'1','148','769',327,'Retail Sale Id 1285010',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 06:37:35','',''),(2175068,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 06:37:35','',''),(2175075,'1','148','769',327,'Retail Sale Id 1285015',6400.00,0.00,0.00,0.00,480.00,'2021-12-06 06:38:16','',''),(2175076,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 06:38:16','',''),(2175079,'1','148','769',327,'Retail Sale Id 1285017',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 06:38:47','',''),(2175080,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 06:38:47','',''),(2175244,'1','148','769',327,'Retail Sale Id 1285101',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 06:53:29','',''),(2175245,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 06:53:29','',''),(2175390,'1','148','769',327,'Return of Retail Sale Id 1284913',0.00,61286.40,95.76,0.00,-4596.48,'2021-12-06 07:01:43','',''),(2175441,'1','148','769',327,'Retail Sale Id 1285172',29081.60,0.00,0.00,0.00,2181.12,'2021-12-06 07:03:28','',''),(2175442,'1','148','769',327,'Retail sales',0.00,0.00,0.00,45.44,0.00,'2021-12-06 07:03:28','',''),(2175531,'1','148','769',327,'Retail Sale Id 1285218',738360.00,0.00,0.00,0.00,374102.40,'2021-12-06 07:12:04','',''),(2175532,'1','148','769',327,'Retail sales',0.00,0.00,0.00,615.30,0.00,'2021-12-06 07:12:04','',''),(2175598,'1','148','769',327,'Retail Sale Id 1285251',708000.00,0.00,0.00,0.00,9440.00,'2021-12-06 07:15:43','',''),(2175599,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1180.00,0.00,'2021-12-06 07:15:43','',''),(2176057,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,75616.16,127.73,0.00,0.00,'2021-12-06 07:41:43','',''),(2176084,'1','148',NULL,327,'Reception corrector for bridging 126349',0.00,0.00,0.00,127.73,0.00,'2021-12-06 07:43:02','',''),(2176085,'1','148','769',327,'Received from bridging 126349',0.00,0.00,127.73,0.00,0.00,'2021-12-06 07:43:02','',''),(2176109,'1','148','769',327,'Retail Sale Id 1285509',41772.80,0.00,0.00,0.00,3132.96,'2021-12-06 07:44:11','',''),(2176110,'1','148','769',327,'Retail sales',0.00,0.00,0.00,65.27,0.00,'2021-12-06 07:44:11','',''),(2176127,'1','148','769',327,'Retail Sale Id 1285522',37476.00,0.00,0.00,0.00,499.68,'2021-12-06 07:45:01','',''),(2176128,'1','148','769',327,'Retail sales',0.00,0.00,0.00,62.46,0.00,'2021-12-06 07:45:01','',''),(2176521,'1','148','769',327,'Retail Sale Id 1285701',0.00,0.00,0.00,0.00,0.00,'2021-12-06 08:02:53','',''),(2176522,'1','148','769',327,'Retail sales',0.00,0.00,0.00,0.00,0.00,'2021-12-06 08:02:53','',''),(2176549,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,3025120.00,5110.00,0.00,0.00,'2021-12-06 08:04:22','',''),(2176560,'1','148',NULL,327,'Reception corrector for bridging 126353',0.00,0.00,0.00,5110.00,0.00,'2021-12-06 08:05:15','',''),(2176561,'1','148','769',327,'Received from bridging 126353',0.00,0.00,5110.00,0.00,0.00,'2021-12-06 08:05:15','',''),(2176640,'1','148','769',327,'Retail Sale Id 1285758',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 08:08:49','',''),(2176641,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:08:49','',''),(2176662,'1','148','769',327,'Retail Sale Id 1285773',6400.00,0.00,0.00,0.00,480.00,'2021-12-06 08:10:00','',''),(2176663,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 08:10:00','',''),(2176668,'1','148','769',327,'Retail Sale Id 1285776',3852.80,0.00,0.00,0.00,288.96,'2021-12-06 08:10:34','',''),(2176669,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 08:10:34','',''),(2178427,'1','148','769',327,'Retail Sale Id 1286595',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 10:09:08','',''),(2178428,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:09:08','',''),(2178940,'1','148','769',327,'Retail Sale Id 1286874',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 10:44:34','',''),(2178941,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:44:34','',''),(2181072,'1','148','769',327,'Retail Sale Id 1288086',192000.00,0.00,0.00,0.00,14400.00,'2021-12-06 12:59:44','',''),(2181073,'1','148','769',327,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-06 12:59:44','',''),(2181092,'1','148','769',327,'Retail Sale Id 1288093',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 13:00:38','',''),(2181093,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:00:38','',''),(2181860,'1','148','769',327,'Retail Sale Id 1288440',96000.00,0.00,0.00,0.00,7200.00,'2021-12-06 13:43:05','',''),(2181861,'1','148','769',327,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-06 13:43:05','',''),(2183062,'1','148','769',327,'Retail Sale Id 1288987',30003.20,0.00,0.00,0.00,2250.24,'2021-12-06 14:42:13','',''),(2183063,'1','148','769',327,'Retail sales',0.00,0.00,0.00,46.88,0.00,'2021-12-06 14:42:13','',''),(2183323,'1','148','769',327,'Retail Sale Id 1289098',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 14:54:49','',''),(2183324,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:54:49','',''),(2184217,'1','148','769',327,'Retail Sale Id 1289519',80000.00,0.00,0.00,0.00,6000.00,'2021-12-06 15:39:50','',''),(2184218,'1','148','769',327,'Retail sales',0.00,0.00,0.00,125.00,0.00,'2021-12-06 15:39:50','',''),(2184522,'1','148','769',327,'Retail Sale Id 1289625',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:51:08','',''),(2184523,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:51:08','',''),(2185020,'1','148','769',327,'Retail Sale Id 1289847',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 16:20:14','',''),(2185021,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:20:14','',''),(2187330,'1','148','769',327,'Retail Sale Id 1290748',275552.00,0.00,0.00,0.00,20666.40,'2021-12-07 06:18:15','',''),(2187331,'1','148','769',327,'Retail sales',0.00,0.00,0.00,430.55,0.00,'2021-12-07 06:18:15','',''),(2187346,'1','148','769',327,'Retail Sale Id 1290757',1349694.00,0.00,0.00,0.00,17995.92,'2021-12-07 06:19:44','',''),(2187347,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2249.49,0.00,'2021-12-07 06:19:44','',''),(2187372,'1','148','769',327,'Retail Sale Id 1290770',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 06:21:51','',''),(2187373,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:21:51','',''),(2188836,'1','148','769',327,'Retail Sale Id 1291497',192000.00,0.00,0.00,0.00,14400.00,'2021-12-07 07:43:20','',''),(2188837,'1','148','769',327,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-07 07:43:20','',''),(2188882,'1','148','769',327,'Retail Sale Id 1291527',128000.00,0.00,0.00,0.00,9600.00,'2021-12-07 07:45:32','',''),(2188883,'1','148','769',327,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-07 07:45:32','',''),(2189191,'1','148','769',327,'Retail Sale Id 1291655',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 08:03:17','',''),(2189192,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:03:17','',''),(2189450,'1','148','769',327,'Retail Sale Id 1291809',32000.00,0.00,0.00,0.00,2400.00,'2021-12-07 08:17:34','',''),(2189451,'1','148','769',327,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 08:17:34','',''),(2190665,'1','148','769',327,'Retail Sale Id 1292367',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 09:24:09','',''),(2190666,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:24:09','',''),(2190818,'1','148','769',327,'Retail Sale Id 1292440',3852.80,0.00,0.00,0.00,288.96,'2021-12-07 09:30:46','',''),(2190819,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 09:30:46','',''),(2191423,'1','148','769',327,'Retail Sale Id 1292749',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 10:09:56','',''),(2191424,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:09:56','',''),(2191587,'1','148','769',327,'Retail Sale Id 1292841',192000.00,0.00,0.00,0.00,14400.00,'2021-12-07 10:21:06','',''),(2191588,'1','148','769',327,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-07 10:21:06','',''),(2192466,'1','148','769',327,'Retail Sale Id 1293264',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 11:11:48','',''),(2192467,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 11:11:48','',''),(2192747,'1','148','769',327,'Retail Sale Id 1293431',32000.00,0.00,0.00,0.00,2400.00,'2021-12-07 11:31:02','',''),(2192748,'1','148','769',327,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 11:31:02','',''),(2193011,'1','148','769',327,'Retail Sale Id 1293559',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 11:50:00','',''),(2193012,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 11:50:00','',''),(2193033,'1','148','769',327,'Retail Sale Id 1293571',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 11:51:50','',''),(2193034,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 11:51:50','',''),(2193433,'1','148','769',327,'Retail Sale Id 1293773',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 12:29:18','',''),(2193434,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:29:18','',''),(2193810,'1','148','769',327,'Return of Retail Sale Id 1291527',0.00,128000.00,200.00,0.00,-9600.00,'2021-12-07 12:57:10','',''),(2193826,'1','148','769',327,'Return of Retail Sale Id 1292841',0.00,192000.00,300.00,0.00,-14400.00,'2021-12-07 12:57:47','',''),(2193891,'1','148','769',327,'Return of Retail Sale Id 1291809',0.00,32000.00,50.00,0.00,-2400.00,'2021-12-07 13:00:42','',''),(2193902,'1','148','769',327,'Return of Retail Sale Id 1293431',0.00,32000.00,50.00,0.00,-2400.00,'2021-12-07 13:01:41','',''),(2193921,'1','148','769',327,'Return of Retail Sale Id 1292749',0.00,8000.00,12.50,0.00,-600.00,'2021-12-07 13:03:16','',''),(2193930,'1','148','769',327,'Retail Sale Id 1294061',723966.00,0.00,0.00,0.00,9652.88,'2021-12-07 13:04:16','',''),(2193931,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1206.61,0.00,'2021-12-07 13:04:16','',''),(2193958,'1','148','769',327,'Retail Sale Id 1294074',7564.80,0.00,0.00,0.00,567.36,'2021-12-07 13:06:01','',''),(2193959,'1','148','769',327,'Retail sales',0.00,0.00,0.00,11.82,0.00,'2021-12-07 13:06:01','',''),(2194390,'1','148','769',327,'Retail Sale Id 1294354',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 13:30:46','',''),(2194391,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 13:30:46','',''),(2194903,'1','148','769',327,'Retail Sale Id 1294577',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 14:02:18','',''),(2194904,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:02:18','',''),(2199070,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,3155360.00,5330.00,0.00,0.00,'2021-12-07 18:02:17','',''),(2199082,'1','148',NULL,327,'Reception corrector for bridging 126507',0.00,0.00,0.00,5330.00,0.00,'2021-12-07 18:03:25','',''),(2199083,'1','148','769',327,'Received from bridging 126507',0.00,0.00,5330.00,0.00,0.00,'2021-12-07 18:03:25','',''),(2201855,'1','148','769',327,'Retail Sale Id 1297735',32000.00,0.00,0.00,0.00,2400.00,'2021-12-08 08:19:31','',''),(2201856,'1','148','769',327,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 08:19:31','',''),(2201983,'1','148','769',327,'Retail Sale Id 1297801',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 08:27:17','',''),(2201984,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:27:17','',''),(2202180,'1','148','769',327,'Retail Sale Id 1297892',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 08:39:37','',''),(2202181,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 08:39:37','',''),(2202544,'1','148','769',327,'Retail Sale Id 1298013',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 08:55:00','',''),(2202545,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 08:55:00','',''),(2202791,'1','148','769',327,'Retail Sale Id 1298144',32000.00,0.00,0.00,0.00,2400.00,'2021-12-08 09:10:16','',''),(2202792,'1','148','769',327,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 09:10:16','',''),(2203211,'1','148','769',327,'Retail Sale Id 1298341',3852.80,0.00,0.00,0.00,288.96,'2021-12-08 09:40:15','',''),(2203212,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 09:40:15','',''),(2203295,'1','148','769',327,'Retail Sale Id 1298386',275942.40,0.00,0.00,0.00,20695.68,'2021-12-08 09:47:36','',''),(2203296,'1','148','769',327,'Retail sales',0.00,0.00,0.00,431.16,0.00,'2021-12-08 09:47:36','',''),(2203350,'1','148','769',327,'Retail Sale Id 1298403',421356.00,0.00,0.00,0.00,5618.08,'2021-12-08 09:50:03','',''),(2203351,'1','148','769',327,'Retail sales',0.00,0.00,0.00,702.26,0.00,'2021-12-08 09:50:03','',''),(2203727,'1','148','769',327,'Retail Sale Id 1298578',144000.00,0.00,0.00,0.00,1920.00,'2021-12-08 10:16:02','',''),(2203728,'1','148','769',327,'Retail sales',0.00,0.00,0.00,240.00,0.00,'2021-12-08 10:16:02','',''),(2203821,'1','148','769',327,'Retail Sale Id 1298632',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 10:22:44','',''),(2203822,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:22:44','',''),(2204878,'1','148','769',327,'Retail Sale Id 1299155',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 11:38:31','',''),(2204879,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 11:38:31','',''),(2204912,'1','148','769',327,'Retail Sale Id 1299171',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 11:39:37','',''),(2204913,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 11:39:37','',''),(2205341,'1','148','769',327,'Retail Sale Id 1299369',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 12:10:27','',''),(2205342,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:10:27','',''),(2206884,'1','148','769',327,'Retail Sale Id 1300047',192000.00,0.00,0.00,0.00,14400.00,'2021-12-08 13:51:52','',''),(2206885,'1','148','769',327,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-08 13:51:52','',''),(2206896,'1','148','769',327,'Retail Sale Id 1300051',160000.00,0.00,0.00,0.00,12000.00,'2021-12-08 13:52:26','',''),(2206897,'1','148','769',327,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-08 13:52:26','',''),(2206904,'1','148','769',327,'Retail Sale Id 1300056',128000.00,0.00,0.00,0.00,9600.00,'2021-12-08 13:53:03','',''),(2206905,'1','148','769',327,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-08 13:53:03','',''),(2207035,'1','148','769',327,'Retail Sale Id 1300112',24000.00,0.00,0.00,0.00,1800.00,'2021-12-08 14:00:57','',''),(2207036,'1','148','769',327,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-08 14:00:57','',''),(2207086,'1','148','769',327,'Retail Sale Id 1300131',37760.00,0.00,0.00,0.00,2832.00,'2021-12-08 14:04:13','',''),(2207087,'1','148','769',327,'Retail sales',0.00,0.00,0.00,59.00,0.00,'2021-12-08 14:04:13','',''),(2207111,'1','148','769',327,'Retail Sale Id 1300142',32000.00,0.00,0.00,0.00,2400.00,'2021-12-08 14:06:23','',''),(2207112,'1','148','769',327,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 14:06:23','',''),(2209420,'1','148','769',327,'Retail Sale Id 1301260',96000.00,0.00,0.00,0.00,7200.00,'2021-12-08 16:11:03','',''),(2209421,'1','148','769',327,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-08 16:11:03','',''),(2209434,'1','148','769',327,'Retail Sale Id 1301266',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 16:11:38','',''),(2209435,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:11:38','',''),(2212363,'1','148','769',327,'Return of Retail Sale Id 1301260',0.00,96000.00,150.00,0.00,-7200.00,'2021-12-09 06:34:53','',''),(2212418,'1','148','769',327,'Retail Sale Id 1302550',37644.80,0.00,0.00,0.00,2823.36,'2021-12-09 06:37:24','',''),(2212419,'1','148','769',327,'Retail sales',0.00,0.00,0.00,58.82,0.00,'2021-12-09 06:37:24','',''),(2212466,'1','148','769',327,'Retail Sale Id 1302574',1116930.00,0.00,0.00,0.00,14892.40,'2021-12-09 06:40:08','',''),(2212467,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1861.55,0.00,'2021-12-09 06:40:08','',''),(2212836,'1','148','769',327,'Retail Sale Id 1302740',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 07:00:11','',''),(2212837,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 07:00:11','',''),(2212856,'1','148','769',327,'Retail Sale Id 1302751',160000.00,0.00,0.00,0.00,12000.00,'2021-12-09 07:01:09','',''),(2212857,'1','148','769',327,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-09 07:01:09','',''),(2213028,'1','148','769',327,'Retail Sale Id 1302827',4998.40,0.00,0.00,0.00,374.88,'2021-12-09 07:11:03','',''),(2213029,'1','148','769',327,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-09 07:11:03','',''),(2213067,'1','148','769',327,'Retail Sale Id 1302846',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 07:13:01','',''),(2213068,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 07:13:01','',''),(2213254,'1','148','769',327,'Retail Sale Id 1302930',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 07:20:06','',''),(2213255,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 07:20:06','',''),(2213276,'1','148','769',327,'Retail Sale Id 1302940',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 07:21:01','',''),(2213277,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:21:01','',''),(2213298,'1','148','769',327,'Retail Sale Id 1302954',2502.40,0.00,0.00,0.00,187.68,'2021-12-09 07:21:56','',''),(2213299,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-09 07:21:56','',''),(2213354,'1','148','769',327,'Retail Sale Id 1302980',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 07:24:22','',''),(2213355,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 07:24:22','',''),(2213360,'1','148','769',327,'Retail Sale Id 1302985',2003.20,0.00,0.00,0.00,150.24,'2021-12-09 07:25:08','',''),(2213361,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 07:25:08','',''),(2213378,'1','148','769',327,'Retail Sale Id 1302997',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 07:25:54','',''),(2213379,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 07:25:54','',''),(2213398,'1','148','769',327,'Retail Sale Id 1303007',6400.00,0.00,0.00,0.00,480.00,'2021-12-09 07:26:39','',''),(2213399,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 07:26:39','',''),(2213466,'1','148','769',327,'Retail Sale Id 1303040',5497.60,0.00,0.00,0.00,412.32,'2021-12-09 07:29:52','',''),(2213467,'1','148','769',327,'Retail sales',0.00,0.00,0.00,8.59,0.00,'2021-12-09 07:29:52','',''),(2213484,'1','148','769',327,'Retail Sale Id 1303049',1203.20,0.00,0.00,0.00,90.24,'2021-12-09 07:30:46','',''),(2213485,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-09 07:30:46','',''),(2213520,'1','148','769',327,'Retail Sale Id 1303061',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 07:32:20','',''),(2213521,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 07:32:20','',''),(2213932,'1','148','769',327,'Retail Sale Id 1303260',4998.40,0.00,0.00,0.00,374.88,'2021-12-09 07:52:42','',''),(2213933,'1','148','769',327,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-09 07:52:42','',''),(2213950,'1','148','769',327,'Retail Sale Id 1303269',2502.40,0.00,0.00,0.00,187.68,'2021-12-09 07:53:53','',''),(2213951,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-09 07:53:53','',''),(2214002,'1','148','769',327,'Retail Sale Id 1303295',3200.00,0.00,0.00,0.00,240.00,'2021-12-09 07:57:02','',''),(2214003,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:57:02','',''),(2214020,'1','148','769',327,'Retail Sale Id 1303305',1952.00,0.00,0.00,0.00,146.40,'2021-12-09 07:58:16','',''),(2214021,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 07:58:16','',''),(2214030,'1','148','769',327,'Retail Sale Id 1303312',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 07:59:09','',''),(2214031,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 07:59:09','',''),(2214042,'1','148','769',327,'Retail Sale Id 1303319',1702.40,0.00,0.00,0.00,127.68,'2021-12-09 07:59:51','',''),(2214043,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-09 07:59:51','',''),(2214066,'1','148','769',327,'Retail Sale Id 1303334',1203.20,0.00,0.00,0.00,90.24,'2021-12-09 08:01:30','',''),(2214067,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-09 08:01:30','',''),(2214078,'1','148','769',327,'Retail Sale Id 1303339',998.40,0.00,0.00,0.00,74.88,'2021-12-09 08:02:09','',''),(2214079,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 08:02:09','',''),(2214106,'1','148','769',327,'Retail Sale Id 1303354',902.40,0.00,0.00,0.00,67.68,'2021-12-09 08:03:54','',''),(2214107,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-09 08:03:54','',''),(2214268,'1','148','769',327,'Retail Sale Id 1303440',1299.20,0.00,0.00,0.00,97.44,'2021-12-09 08:12:04','',''),(2214269,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-09 08:12:04','',''),(2214446,'1','148','769',327,'Retail Sale Id 1303525',16000.00,0.00,0.00,0.00,1200.00,'2021-12-09 08:21:44','',''),(2214447,'1','148','769',327,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 08:21:44','',''),(2214498,'1','148','769',327,'Retail Sale Id 1303538',106880.00,0.00,0.00,0.00,8016.00,'2021-12-09 08:23:21','',''),(2214499,'1','148','769',327,'Retail sales',0.00,0.00,0.00,167.00,0.00,'2021-12-09 08:23:21','',''),(2214545,'1','148','769',327,'Retail Sale Id 1303554',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 08:25:11','',''),(2214546,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 08:25:11','',''),(2217646,'1','148','769',327,'Retail Sale Id 1305042',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 11:22:01','',''),(2217647,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:22:01','',''),(2218383,'1','148','769',327,'Retail Sale Id 1305411',42000.00,0.00,0.00,0.00,560.00,'2021-12-09 12:08:37','',''),(2218384,'1','148','769',327,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-09 12:08:37','',''),(2218393,'1','148','769',327,'Retail Sale Id 1305417',96000.00,0.00,0.00,0.00,7200.00,'2021-12-09 12:09:33','',''),(2218394,'1','148','769',327,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-09 12:09:33','',''),(2218401,'1','148','769',327,'Retail Sale Id 1305423',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 12:09:58','',''),(2218402,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 12:09:58','',''),(2218405,'1','148','769',327,'Retail Sale Id 1305426',7801.60,0.00,0.00,0.00,585.12,'2021-12-09 12:10:24','',''),(2218406,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.19,0.00,'2021-12-09 12:10:24','',''),(2218413,'1','148','769',327,'Retail Sale Id 1305430',6700.80,0.00,0.00,0.00,502.56,'2021-12-09 12:10:56','',''),(2218414,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.47,0.00,'2021-12-09 12:10:56','',''),(2218417,'1','148','769',327,'Retail Sale Id 1305432',3001.60,0.00,0.00,0.00,225.12,'2021-12-09 12:11:28','',''),(2218418,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 12:11:28','',''),(2218447,'1','148','769',327,'Retail Sale Id 1305441',4998.40,0.00,0.00,0.00,374.88,'2021-12-09 12:11:58','',''),(2218448,'1','148','769',327,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-09 12:11:58','',''),(2218459,'1','148','769',327,'Retail Sale Id 1305445',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 12:12:28','',''),(2218460,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 12:12:28','',''),(2218465,'1','148','769',327,'Retail Sale Id 1305450',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 12:12:57','',''),(2218466,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 12:12:57','',''),(2221775,'1','148','769',327,'Retail Sale Id 1307007',4000.00,0.00,0.00,0.00,300.00,'2021-12-09 15:14:50','',''),(2221776,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 15:14:50','',''),(2221805,'1','148','769',327,'Retail Sale Id 1307024',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 15:16:07','',''),(2221806,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:16:07','',''),(2221821,'1','148','769',327,'Retail Sale Id 1307033',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 15:16:55','',''),(2221822,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:16:55','',''),(2221887,'1','148','769',327,'Retail Sale Id 1307059',25600.00,0.00,0.00,0.00,1920.00,'2021-12-09 15:20:15','',''),(2221888,'1','148','769',327,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-09 15:20:15','',''),(2222081,'1','148','769',327,'Retail Sale Id 1307163',3852.80,0.00,0.00,0.00,288.96,'2021-12-09 15:29:37','',''),(2222082,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-09 15:29:37','',''),(2222320,'1','148','769',327,'Retail Sale Id 1307278',32000.00,0.00,0.00,0.00,2400.00,'2021-12-09 15:41:49','',''),(2222321,'1','148','769',327,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 15:41:49','',''),(2222563,'1','148','769',327,'Retail Sale Id 1307396',6400.00,0.00,0.00,0.00,480.00,'2021-12-09 15:55:28','',''),(2222564,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 15:55:28','',''),(2222747,'1','148','769',327,'Retail Sale Id 1307487',1497.60,0.00,0.00,0.00,112.32,'2021-12-09 16:05:34','',''),(2222748,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 16:05:34','',''),(2223859,'1','148','769',327,'Retail Sale Id 1307865',8000.00,0.00,0.00,0.00,600.00,'2021-12-09 17:05:34','',''),(2223860,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 17:05:34','',''),(2225002,'1','148','769',327,'Return of Retail Sale Id 1307278',0.00,32000.00,50.00,0.00,-2400.00,'2021-12-10 05:43:54','',''),(2225003,'1','148','769',327,'Return of Retail Sale Id 1307059',0.00,25600.00,40.00,0.00,-1920.00,'2021-12-10 05:44:35','',''),(2225004,'1','148','769',327,'Return of Retail Sale Id 1305411',0.00,42000.00,70.00,0.00,-560.00,'2021-12-10 05:45:41','',''),(2225005,'1','148','769',327,'Return of Retail Sale Id 1305417',0.00,96000.00,150.00,0.00,-7200.00,'2021-12-10 05:46:21','',''),(2225009,'1','148','769',327,'Return of Retail Sale Id 1303538',0.00,106880.00,167.00,0.00,-8016.00,'2021-12-10 05:48:04','',''),(2225010,'1','148','769',327,'Return of Retail Sale Id 1303525',0.00,16000.00,25.00,0.00,-1200.00,'2021-12-10 05:48:55','',''),(2225015,'1','148','769',327,'Retail Sale Id 1305414',96000.00,0.00,0.00,0.00,7200.00,'2021-12-10 05:51:02','',''),(2225016,'1','148','769',327,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-10 05:51:02','',''),(2225019,'1','148','769',327,'Return of Retail Sale Id 1305414',0.00,96000.00,150.00,0.00,-7200.00,'2021-12-10 05:51:32','',''),(2225024,'1','148','769',327,'Return of Retail Sale Id 1302751',0.00,160000.00,250.00,0.00,-12000.00,'2021-12-10 05:52:49','',''),(2225039,'1','148','769',327,'Retail Sale Id 1308339',36780.80,0.00,0.00,0.00,2758.56,'2021-12-10 05:55:26','',''),(2225040,'1','148','769',327,'Retail sales',0.00,0.00,0.00,57.47,0.00,'2021-12-10 05:55:26','',''),(2225069,'1','148','769',327,'Retail Sale Id 1308353',455964.00,0.00,0.00,0.00,6079.52,'2021-12-10 06:02:03','',''),(2225070,'1','148','769',327,'Retail sales',0.00,0.00,0.00,759.94,0.00,'2021-12-10 06:02:03','',''),(2225276,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,3042880.00,5140.00,0.00,0.00,'2021-12-10 06:24:21','',''),(2225293,'1','148',NULL,327,'Reception corrector for bridging 126825',0.00,0.00,0.00,5140.00,0.00,'2021-12-10 06:25:38','',''),(2225294,'1','148','769',327,'Received from bridging 126825',0.00,0.00,5140.00,0.00,0.00,'2021-12-10 06:25:38','',''),(2225307,'1','148','769',327,'Retail Sale Id 1308453',398380.80,0.00,0.00,0.00,29878.56,'2021-12-10 06:26:35','',''),(2225308,'1','148','769',327,'Retail sales',0.00,0.00,0.00,622.47,0.00,'2021-12-10 06:26:35','',''),(2225341,'1','148','769',327,'Retail Sale Id 1308468',192618.00,0.00,0.00,0.00,2568.24,'2021-12-10 06:29:05','',''),(2225342,'1','148','769',327,'Retail sales',0.00,0.00,0.00,321.03,0.00,'2021-12-10 06:29:05','',''),(2225501,'1','148','769',327,'Retail Sale Id 1308542',8000.00,0.00,0.00,0.00,600.00,'2021-12-10 06:41:43','',''),(2225502,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 06:41:43','',''),(2225576,'1','148','769',327,'Retail Sale Id 1308578',16000.00,0.00,0.00,0.00,1200.00,'2021-12-10 06:47:52','',''),(2225577,'1','148','769',327,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 06:47:52','',''),(2225628,'1','148','769',327,'Retail Sale Id 1308606',6400.00,0.00,0.00,0.00,480.00,'2021-12-10 06:50:38','',''),(2225629,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 06:50:38','',''),(2225642,'1','148','769',327,'Retail Sale Id 1308616',8000.00,0.00,0.00,0.00,600.00,'2021-12-10 06:51:36','',''),(2225643,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 06:51:36','',''),(2227207,'1','148','769',327,'Retail Sale Id 1309326',6400.00,0.00,0.00,0.00,480.00,'2021-12-10 08:16:04','',''),(2227208,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 08:16:04','',''),(2227217,'1','148','769',327,'Retail Sale Id 1309332',3852.80,0.00,0.00,0.00,288.96,'2021-12-10 08:16:36','',''),(2227218,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-10 08:16:36','',''),(2227225,'1','148','769',327,'Retail Sale Id 1309335',8000.00,0.00,0.00,0.00,600.00,'2021-12-10 08:17:13','',''),(2227226,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:17:13','',''),(2227247,'1','148','769',327,'Retail Sale Id 1309349',3852.80,0.00,0.00,0.00,288.96,'2021-12-10 08:18:18','',''),(2227248,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-10 08:18:18','',''),(2229605,'1','148','769',327,'Retail Sale Id 1310458',998.40,0.00,0.00,0.00,74.88,'2021-12-10 10:21:17','',''),(2229606,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-10 10:21:17','',''),(2230544,'1','148','769',327,'Retail Sale Id 1310874',4000.00,0.00,0.00,0.00,300.00,'2021-12-10 11:14:57','',''),(2230545,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-10 11:14:57','',''),(2231882,'1','148','769',327,'Retail Sale Id 1311540',7900.00,0.00,0.00,0.00,500.00,'2021-12-10 12:55:32','',''),(2231883,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 12:55:32','',''),(2232144,'1','148','769',327,'Retail Sale Id 1311666',2502.40,0.00,0.00,0.00,187.68,'2021-12-10 13:12:10','',''),(2232145,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-10 13:12:10','',''),(2232329,'1','148','769',327,'Retail Sale Id 1311742',6351.60,0.00,0.00,0.00,402.00,'2021-12-10 13:22:28','',''),(2232330,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.05,0.00,'2021-12-10 13:22:28','',''),(2232441,'1','148','769',327,'Retail Sale Id 1311809',117600.00,0.00,0.00,0.00,-800.00,'2021-12-10 13:31:13','',''),(2232442,'1','148','769',327,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-10 13:31:13','',''),(2232455,'1','148','769',327,'Retail Sale Id 1311815',58800.00,0.00,0.00,0.00,-400.00,'2021-12-10 13:31:56','',''),(2232456,'1','148','769',327,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 13:31:56','',''),(2232463,'1','148','769',327,'Retail Sale Id 1311819',8000.00,0.00,0.00,0.00,600.00,'2021-12-10 13:32:33','',''),(2232464,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:32:33','',''),(2232969,'1','148','769',327,'Retail Sale Id 1312038',8000.00,0.00,0.00,0.00,600.00,'2021-12-10 13:56:23','',''),(2232970,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:56:23','',''),(2233494,'1','148','769',327,'Retail Sale Id 1312260',3197.92,0.00,0.00,0.00,0.00,'2021-12-10 14:22:00','',''),(2233495,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 14:22:00','',''),(2233539,'1','148','769',327,'Retail Sale Id 1312276',2502.72,0.00,0.00,0.00,0.00,'2021-12-10 14:23:38','',''),(2233540,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-10 14:23:38','',''),(2233581,'1','148','769',327,'Retail Sale Id 1312288',3197.92,0.00,0.00,0.00,0.00,'2021-12-10 14:25:04','',''),(2233582,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 14:25:04','',''),(2233611,'1','148','769',327,'Retail Sale Id 1312296',6351.60,0.00,0.00,0.00,0.00,'2021-12-10 14:26:02','',''),(2233612,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.05,0.00,'2021-12-10 14:26:02','',''),(2233625,'1','148','769',327,'Retail Sale Id 1312303',1902.32,0.00,0.00,0.00,0.00,'2021-12-10 14:26:40','',''),(2233626,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 14:26:40','',''),(2233634,'1','148','769',327,'Retail Sale Id 1312308',3197.92,0.00,0.00,0.00,0.00,'2021-12-10 14:27:34','',''),(2233635,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-10 14:27:34','',''),(2233665,'1','148','769',327,'Retail Sale Id 1312319',15800.00,0.00,0.00,0.00,0.00,'2021-12-10 14:28:27','',''),(2233666,'1','148','769',327,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 14:28:27','',''),(2233691,'1','148','769',327,'Retail Sale Id 1312331',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 14:29:33','',''),(2233692,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:29:33','',''),(2233719,'1','148','769',327,'Retail Sale Id 1312349',998.56,0.00,0.00,0.00,0.00,'2021-12-10 14:30:34','',''),(2233720,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 14:30:34','',''),(2233725,'1','148','769',327,'Retail Sale Id 1312352',4000.56,0.00,0.00,0.00,0.00,'2021-12-10 14:31:13','',''),(2233726,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-10 14:31:13','',''),(2233745,'1','148','769',327,'Retail Sale Id 1312362',1997.12,0.00,0.00,0.00,0.00,'2021-12-10 14:32:02','',''),(2233746,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 14:32:02','',''),(2233759,'1','148','769',327,'Retail Sale Id 1312370',1301.92,0.00,0.00,0.00,0.00,'2021-12-10 14:32:43','',''),(2233760,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 14:32:43','',''),(2233779,'1','148','769',327,'Retail Sale Id 1312379',1301.92,0.00,0.00,0.00,0.00,'2021-12-10 14:33:35','',''),(2233780,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-10 14:33:35','',''),(2233807,'1','148','769',327,'Retail Sale Id 1312393',3798.32,0.00,0.00,0.00,0.00,'2021-12-10 14:34:43','',''),(2233808,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 14:34:43','',''),(2234007,'1','148','769',327,'Retail Sale Id 1312470',2546.96,0.00,0.00,0.00,0.00,'2021-12-10 14:42:37','',''),(2234008,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-10 14:42:37','',''),(2234049,'1','148','769',327,'Retail Sale Id 1312494',998.56,0.00,0.00,0.00,0.00,'2021-12-10 14:44:34','',''),(2234050,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-10 14:44:34','',''),(2234177,'1','148','769',327,'Retail Sale Id 1312551',1997.12,0.00,0.00,0.00,0.00,'2021-12-10 14:49:03','',''),(2234178,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 14:49:03','',''),(2234316,'1','148','769',327,'Retail Sale Id 1312614',1902.32,0.00,0.00,0.00,0.00,'2021-12-10 14:55:42','',''),(2234317,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 14:55:42','',''),(2234336,'1','148','769',327,'Retail Sale Id 1312625',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 14:57:14','',''),(2234337,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:57:14','',''),(2234356,'1','148','769',327,'Retail Sale Id 1312633',1902.32,0.00,0.00,0.00,0.00,'2021-12-10 14:58:45','',''),(2234357,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 14:58:45','',''),(2234378,'1','148','769',327,'Retail Sale Id 1312645',3002.00,0.00,0.00,0.00,0.00,'2021-12-10 14:59:56','',''),(2234379,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-10 14:59:56','',''),(2234410,'1','148','769',327,'Retail Sale Id 1312663',1997.12,0.00,0.00,0.00,0.00,'2021-12-10 15:01:58','',''),(2234411,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-10 15:01:58','',''),(2235169,'1','148','769',327,'Retail Sale Id 1313005',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 15:33:03','',''),(2235170,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:33:03','',''),(2236694,'1','148','769',327,'Retail Sale Id 1313781',117600.00,0.00,0.00,0.00,-8800.00,'2021-12-10 16:42:49','',''),(2236695,'1','148','769',327,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-10 16:42:49','',''),(2236726,'1','148','769',327,'Retail Sale Id 1313801',64092.00,0.00,0.00,0.00,-4796.00,'2021-12-10 16:44:38','',''),(2236727,'1','148','769',327,'Retail sales',0.00,0.00,0.00,109.00,0.00,'2021-12-10 16:44:38','',''),(2237114,'1','148','769',327,'Retail Sale Id 1313995',7900.00,0.00,0.00,0.00,0.00,'2021-12-10 17:09:15','',''),(2237115,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 17:09:15','',''),(2237122,'1','148','769',327,'Retail Sale Id 1313999',7602.96,0.00,0.00,0.00,0.00,'2021-12-10 17:10:01','',''),(2237123,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.03,0.00,'2021-12-10 17:10:01','',''),(2237170,'1','148','769',327,'Retail Sale Id 1314021',94080.00,0.00,0.00,0.00,-7040.00,'2021-12-10 17:14:41','',''),(2237171,'1','148','769',327,'Retail sales',0.00,0.00,0.00,160.00,0.00,'2021-12-10 17:14:41','',''),(2237178,'1','148','769',327,'Retail Sale Id 1314025',8001.12,0.00,0.00,0.00,0.00,'2021-12-10 17:15:13','',''),(2237179,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-10 17:15:13','',''),(2238377,'1','148','769',327,'Return of Retail Sale Id 1308542',0.00,8000.00,12.50,0.00,-600.00,'2021-12-11 05:49:48','',''),(2238378,'1','148','769',327,'Return of Retail Sale Id 1308578',0.00,16000.00,25.00,0.00,-1200.00,'2021-12-11 05:50:15','',''),(2238381,'1','148','769',327,'Return of Retail Sale Id 1308606',0.00,6400.00,10.00,0.00,-480.00,'2021-12-11 05:51:11','',''),(2238382,'1','148','769',327,'Return of Retail Sale Id 1308616',0.00,8000.00,12.50,0.00,-600.00,'2021-12-11 05:51:59','',''),(2238384,'1','148','769',327,'Return of Retail Sale Id 1309326',0.00,6400.00,10.00,0.00,-480.00,'2021-12-11 05:52:50','',''),(2238385,'1','148','769',327,'Return of Retail Sale Id 1309332',0.00,3852.80,6.02,0.00,-288.96,'2021-12-11 05:53:18','',''),(2238392,'1','148','769',327,'Return of Retail Sale Id 1309335',0.00,8000.00,12.50,0.00,-600.00,'2021-12-11 05:54:44','',''),(2238397,'1','148','769',327,'Return of Retail Sale Id 1310458',0.00,998.40,1.56,0.00,-74.88,'2021-12-11 05:55:47','',''),(2238400,'1','148','769',327,'Return of Retail Sale Id 1309349',0.00,3852.80,6.02,0.00,-288.96,'2021-12-11 05:56:35','',''),(2238586,'1','148','769',327,'Return of Retail Sale Id 1313781',0.00,117600.00,200.00,0.00,8800.00,'2021-12-11 06:17:10','',''),(2238602,'1','148','769',327,'Return of Retail Sale Id 1313801',0.00,64092.00,109.00,0.00,4796.00,'2021-12-11 06:17:48','',''),(2238613,'1','148','769',327,'Return of Retail Sale Id 1314021',0.00,94080.00,160.00,0.00,7040.00,'2021-12-11 06:19:01','',''),(2238622,'1','148','769',327,'Return of Retail Sale Id 1311809',0.00,117600.00,200.00,0.00,800.00,'2021-12-11 06:20:10','',''),(2238637,'1','148','769',327,'Return of Retail Sale Id 1311815',0.00,58800.00,100.00,0.00,400.00,'2021-12-11 06:20:51','',''),(2238660,'1','148','769',327,'Retail Sale Id 1314515',642090.12,0.00,0.00,0.00,-48047.56,'2021-12-11 06:22:39','',''),(2238661,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1091.99,0.00,'2021-12-11 06:22:39','',''),(2238694,'1','148','769',327,'Retail Sale Id 1314532',98276.00,0.00,0.00,0.00,0.00,'2021-12-11 06:25:21','',''),(2238695,'1','148','769',327,'Retail sales',0.00,0.00,0.00,155.50,0.00,'2021-12-11 06:25:21','',''),(2238700,'1','148','769',327,'Return of Retail Sale Id 1314532',0.00,98276.00,155.50,0.00,0.00,'2021-12-11 06:25:38','',''),(2238733,'1','148','769',327,'Retail Sale Id 1314555',98276.00,0.00,0.00,0.00,0.00,'2021-12-11 06:27:54','',''),(2238734,'1','148','769',327,'Retail sales',0.00,0.00,0.00,155.50,0.00,'2021-12-11 06:27:54','',''),(2238764,'1','148','769',327,'Retail Sale Id 1314569',524073.36,0.00,0.00,0.00,0.00,'2021-12-11 06:30:49','',''),(2238765,'1','148','769',327,'Retail sales',0.00,0.00,0.00,829.23,0.00,'2021-12-11 06:30:49','',''),(2239186,'1','148','769',327,'Retail Sale Id 1314765',299292.00,0.00,0.00,0.00,-22396.00,'2021-12-11 06:58:31','',''),(2239187,'1','148','769',327,'Retail sales',0.00,0.00,0.00,509.00,0.00,'2021-12-11 06:58:31','',''),(2239233,'1','148','769',327,'Retail Sale Id 1314804',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 07:01:22','',''),(2239234,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:01:22','',''),(2239280,'1','148','769',327,'Retail Sale Id 1314823',3798.32,0.00,0.00,0.00,0.00,'2021-12-11 07:04:02','',''),(2239281,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 07:04:02','',''),(2239342,'1','148','769',327,'Retail Sale Id 1314855',7002.56,0.00,0.00,0.00,0.00,'2021-12-11 07:07:28','',''),(2239343,'1','148','769',327,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-11 07:07:28','',''),(2239656,'1','148','769',327,'Retail Sale Id 1315038',4796.88,0.00,0.00,0.00,0.00,'2021-12-11 07:26:40','',''),(2239657,'1','148','769',327,'Retail sales',0.00,0.00,0.00,7.59,0.00,'2021-12-11 07:26:40','',''),(2239684,'1','148','769',327,'Retail Sale Id 1315050',1301.92,0.00,0.00,0.00,0.00,'2021-12-11 07:27:26','',''),(2239685,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-11 07:27:26','',''),(2239692,'1','148','769',327,'Retail Sale Id 1315056',4999.12,0.00,0.00,0.00,0.00,'2021-12-11 07:28:16','',''),(2239693,'1','148','769',327,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-11 07:28:16','',''),(2239724,'1','148','769',327,'Retail Sale Id 1315070',2546.96,0.00,0.00,0.00,0.00,'2021-12-11 07:30:35','',''),(2239725,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-11 07:30:35','',''),(2239742,'1','148','769',327,'Retail Sale Id 1315079',3002.00,0.00,0.00,0.00,0.00,'2021-12-11 07:31:22','',''),(2239743,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 07:31:22','',''),(2239769,'1','148','769',327,'Retail Sale Id 1315089',1902.32,0.00,0.00,0.00,0.00,'2021-12-11 07:32:27','',''),(2239771,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 07:32:27','',''),(2239793,'1','148','769',327,'Retail Sale Id 1315100',1497.84,0.00,0.00,0.00,0.00,'2021-12-11 07:33:17','',''),(2239794,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 07:33:17','',''),(2239823,'1','148','769',327,'Retail Sale Id 1315118',6351.60,0.00,0.00,0.00,0.00,'2021-12-11 07:34:32','',''),(2239824,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.05,0.00,'2021-12-11 07:34:32','',''),(2239837,'1','148','769',327,'Retail Sale Id 1315125',3002.00,0.00,0.00,0.00,0.00,'2021-12-11 07:35:42','',''),(2239838,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-11 07:35:42','',''),(2239861,'1','148','769',327,'Retail Sale Id 1315141',6351.60,0.00,0.00,0.00,0.00,'2021-12-11 07:36:56','',''),(2239862,'1','148','769',327,'Retail sales',0.00,0.00,0.00,10.05,0.00,'2021-12-11 07:36:56','',''),(2240014,'1','148','769',327,'Retail Sale Id 1315217',4796.88,0.00,0.00,0.00,0.00,'2021-12-11 07:44:59','',''),(2240015,'1','148','769',327,'Retail sales',0.00,0.00,0.00,7.59,0.00,'2021-12-11 07:44:59','',''),(2240128,'1','148','769',327,'Retail Sale Id 1315279',126400.00,0.00,0.00,0.00,0.00,'2021-12-11 07:49:34','',''),(2240129,'1','148','769',327,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-11 07:49:34','',''),(2240194,'1','148','769',327,'Retail Sale Id 1315297',41160.00,0.00,0.00,0.00,-3080.00,'2021-12-11 07:50:46','',''),(2240195,'1','148','769',327,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-11 07:50:46','',''),(2240236,'1','148','769',327,'Retail Sale Id 1315318',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 07:53:37','',''),(2240237,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:53:37','',''),(2241268,'1','148','769',327,'Retail Sale Id 1315775',34692.00,0.00,0.00,0.00,-2596.00,'2021-12-11 08:41:57','',''),(2241271,'1','148','769',327,'Retail sales',0.00,0.00,0.00,59.00,0.00,'2021-12-11 08:41:57','',''),(2241376,'1','148','769',327,'Retail Sale Id 1315826',8999.68,0.00,0.00,0.00,0.00,'2021-12-11 08:46:57','',''),(2241377,'1','148','769',327,'Retail sales',0.00,0.00,0.00,14.24,0.00,'2021-12-11 08:46:57','',''),(2241392,'1','148','769',327,'Retail Sale Id 1315849',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 08:47:24','',''),(2241393,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 08:47:24','',''),(2241425,'1','148','769',327,'Retail Sale Id 1315860',1902.32,0.00,0.00,0.00,0.00,'2021-12-11 08:48:33','',''),(2241426,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 08:48:33','',''),(2241437,'1','148','769',327,'Retail Sale Id 1315868',1997.12,0.00,0.00,0.00,0.00,'2021-12-11 08:49:25','',''),(2241438,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-11 08:49:25','',''),(2241714,'1','148','769',327,'Retail Sale Id 1315980',3798.32,0.00,0.00,0.00,0.00,'2021-12-11 09:00:42','',''),(2241715,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 09:00:42','',''),(2241738,'1','148','769',327,'Retail Sale Id 1315993',1497.84,0.00,0.00,0.00,0.00,'2021-12-11 09:01:35','',''),(2241739,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 09:01:35','',''),(2241750,'1','148','769',327,'Retail Sale Id 1315998',3798.32,0.00,0.00,0.00,0.00,'2021-12-11 09:02:26','',''),(2241751,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 09:02:26','',''),(2241760,'1','148','769',327,'Retail Sale Id 1316014',998.56,0.00,0.00,0.00,0.00,'2021-12-11 09:03:07','',''),(2241761,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 09:03:07','',''),(2241782,'1','148','769',327,'Retail Sale Id 1316024',1497.84,0.00,0.00,0.00,0.00,'2021-12-11 09:03:50','',''),(2241783,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 09:03:50','',''),(2241794,'1','148','769',327,'Retail Sale Id 1316031',1497.84,0.00,0.00,0.00,0.00,'2021-12-11 09:04:49','',''),(2241795,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 09:04:49','',''),(2241838,'1','148','769',327,'Retail Sale Id 1316052',1902.32,0.00,0.00,0.00,0.00,'2021-12-11 09:06:34','',''),(2241839,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 09:06:34','',''),(2241876,'1','148','769',327,'Retail Sale Id 1316066',3197.92,0.00,0.00,0.00,0.00,'2021-12-11 09:08:08','',''),(2241877,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-11 09:08:08','',''),(2241894,'1','148','769',327,'Retail Sale Id 1316076',1497.84,0.00,0.00,0.00,0.00,'2021-12-11 09:09:02','',''),(2241895,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-11 09:09:02','',''),(2241916,'1','148','769',327,'Retail Sale Id 1316088',3798.32,0.00,0.00,0.00,0.00,'2021-12-11 09:10:06','',''),(2241917,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 09:10:06','',''),(2241941,'1','148','769',327,'Retail Sale Id 1316099',1902.32,0.00,0.00,0.00,0.00,'2021-12-11 09:11:13','',''),(2241942,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 09:11:13','',''),(2241967,'1','148','769',327,'Retail Sale Id 1316115',1902.32,0.00,0.00,0.00,0.00,'2021-12-11 09:12:23','',''),(2241968,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 09:12:23','',''),(2242010,'1','148','769',327,'Retail Sale Id 1316122',998.56,0.00,0.00,0.00,0.00,'2021-12-11 09:13:43','',''),(2242011,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-11 09:13:43','',''),(2242116,'1','148','769',327,'Retail Sale Id 1316186',31600.00,0.00,0.00,0.00,0.00,'2021-12-11 09:18:37','',''),(2242117,'1','148','769',327,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 09:18:37','',''),(2242293,'1','148','769',327,'Retail Sale Id 1316256',7900.00,0.00,0.00,0.00,0.00,'2021-12-11 09:27:58','',''),(2242294,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:27:58','',''),(2242568,'1','148','769',327,'Retail Sale Id 1316413',3848.88,0.00,0.00,0.00,0.00,'2021-12-11 09:41:20','',''),(2242569,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-11 09:41:20','',''),(2242922,'1','148','769',327,'Retail Sale Id 1316580',3798.32,0.00,0.00,0.00,0.00,'2021-12-11 09:58:36','',''),(2242923,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 09:58:36','',''),(2255273,'1','148','769',327,'Retail Sale Id 1322390',7900.00,0.00,0.00,0.00,0.00,'2021-12-12 09:41:23','',''),(2255274,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:41:23','',''),(2257126,'1','148','769',327,'Return of Retail Sale Id 1316186',0.00,31600.00,50.00,0.00,0.00,'2021-12-12 11:09:18','',''),(2257149,'1','148','769',327,'Return of Retail Sale Id 1315279',0.00,126400.00,200.00,0.00,0.00,'2021-12-12 11:10:07','',''),(2257160,'1','148','769',327,'Return of Retail Sale Id 1315297',0.00,41160.00,70.00,0.00,3080.00,'2021-12-12 11:10:37','',''),(2257167,'1','148','769',327,'Return of Retail Sale Id 1315775',0.00,34692.00,59.00,0.00,2596.00,'2021-12-12 11:11:21','',''),(2257198,'1','148','769',327,'Return of Retail Sale Id 1314765',0.00,299292.00,509.00,0.00,22396.00,'2021-12-12 11:12:34','',''),(2257257,'1','148','769',327,'Retail Sale Id 1323379',757549.80,0.00,0.00,0.00,-56687.40,'2021-12-12 11:15:22','',''),(2257258,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1288.35,0.00,'2021-12-12 11:15:22','',''),(2257497,'1','148','769',327,'Retail Sale Id 1323496',177724.72,0.00,0.00,0.00,0.00,'2021-12-12 11:24:58','',''),(2257498,'1','148','769',327,'Retail sales',0.00,0.00,0.00,281.21,0.00,'2021-12-12 11:24:58','',''),(2257696,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,3117400.00,5450.00,0.00,0.00,'2021-12-12 11:34:48','',''),(2257719,'1','148',NULL,327,'Reception corrector for bridging 127120',0.00,0.00,0.00,5450.00,0.00,'2021-12-12 11:36:03','',''),(2257720,'1','148','769',327,'Received from bridging 127120',0.00,0.00,5450.00,0.00,0.00,'2021-12-12 11:36:03','',''),(2258542,'1','148','769',327,'Retail Sale Id 1324014',147000.00,0.00,0.00,0.00,4000.00,'2021-12-12 12:16:56','',''),(2258543,'1','148','769',327,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-12 12:16:56','',''),(2258566,'1','148','769',327,'Retail Sale Id 1324025',7900.00,0.00,0.00,0.00,750.00,'2021-12-12 12:17:50','',''),(2258567,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:17:50','',''),(2258588,'1','148','769',327,'Retail Sale Id 1324038',5997.68,0.00,0.00,0.00,569.40,'2021-12-12 12:18:56','',''),(2258589,'1','148','769',327,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-12 12:18:56','',''),(2258712,'1','148','769',327,'Retail Sale Id 1324101',4000.56,0.00,0.00,0.00,379.80,'2021-12-12 12:25:31','',''),(2258713,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-12 12:25:31','',''),(2258929,'1','148','769',327,'Retail Sale Id 1324199',31600.00,0.00,0.00,0.00,3000.00,'2021-12-12 12:34:12','',''),(2258930,'1','148','769',327,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 12:34:12','',''),(2258950,'1','148','769',327,'Retail Sale Id 1324209',155820.00,0.00,0.00,0.00,4240.00,'2021-12-12 12:34:48','',''),(2258951,'1','148','769',327,'Retail sales',0.00,0.00,0.00,265.00,0.00,'2021-12-12 12:34:48','',''),(2259623,'1','148','769',327,'Retail Sale Id 1324539',18960.00,0.00,0.00,0.00,1800.00,'2021-12-12 13:08:28','',''),(2259624,'1','148','769',327,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-12 13:08:28','',''),(2261708,'1','148','769',327,'Retail Sale Id 1325405',111720.00,0.00,0.00,0.00,3040.00,'2021-12-12 14:49:20','',''),(2261709,'1','148','769',327,'Retail sales',0.00,0.00,0.00,190.00,0.00,'2021-12-12 14:49:20','',''),(2261735,'1','148','769',327,'Retail Sale Id 1325410',8001.12,0.00,0.00,0.00,759.60,'2021-12-12 14:49:46','',''),(2261736,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.66,0.00,'2021-12-12 14:49:46','',''),(2261747,'1','148','769',327,'Retail Sale Id 1325419',3798.32,0.00,0.00,0.00,360.60,'2021-12-12 14:50:27','',''),(2261748,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 14:50:27','',''),(2261757,'1','148','769',327,'Retail Sale Id 1325422',5599.52,0.00,0.00,0.00,531.60,'2021-12-12 14:50:53','',''),(2261758,'1','148','769',327,'Retail sales',0.00,0.00,0.00,8.86,0.00,'2021-12-12 14:50:54','',''),(2261773,'1','148','769',327,'Retail Sale Id 1325428',15800.00,0.00,0.00,0.00,1500.00,'2021-12-12 14:51:27','',''),(2261774,'1','148','769',327,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-12 14:51:27','',''),(2263033,'1','148','769',327,'Retail Sale Id 1326005',64092.00,0.00,0.00,0.00,1744.00,'2021-12-12 16:04:08','',''),(2263034,'1','148','769',327,'Retail sales',0.00,0.00,0.00,109.00,0.00,'2021-12-12 16:04:08','',''),(2263049,'1','148','769',327,'Retail Sale Id 1326015',7900.00,0.00,0.00,0.00,750.00,'2021-12-12 16:06:16','',''),(2263050,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:06:16','',''),(2263264,'1','148','769',327,'Retail Sale Id 1326021',34104.00,0.00,0.00,0.00,928.00,'2021-12-12 16:20:20','',''),(2263265,'1','148','769',327,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-12 16:20:20','',''),(2265264,'1','148','769',327,'Return of Retail Sale Id 1324014',0.00,147000.00,250.00,0.00,-4000.00,'2021-12-13 05:45:10','',''),(2265267,'1','148','769',327,'Return of Retail Sale Id 1324209',0.00,155820.00,265.00,0.00,-4240.00,'2021-12-13 05:46:11','',''),(2265268,'1','148','769',327,'Return of Retail Sale Id 1325405',0.00,111720.00,190.00,0.00,-3040.00,'2021-12-13 05:46:42','',''),(2265269,'1','148','769',327,'Return of Retail Sale Id 1326005',0.00,64092.00,109.00,0.00,-1744.00,'2021-12-13 05:47:18','',''),(2265272,'1','148','769',327,'Return of Retail Sale Id 1324539',0.00,18960.00,30.00,0.00,-1800.00,'2021-12-13 05:48:16','',''),(2265275,'1','148','769',327,'Return of Retail Sale Id 1325428',0.00,15800.00,25.00,0.00,-1500.00,'2021-12-13 05:48:43','',''),(2265278,'1','148','769',327,'Return of Retail Sale Id 1324199',0.00,31600.00,50.00,0.00,-3000.00,'2021-12-13 05:49:53','',''),(2265281,'1','148','769',327,'Return of Retail Sale Id 1326021',0.00,34104.00,58.00,0.00,-928.00,'2021-12-13 05:51:34','',''),(2265284,'1','148','769',327,'Retail Sale Id 1326779',605822.56,0.00,0.00,0.00,57514.80,'2021-12-13 05:54:55','',''),(2265285,'1','148','769',327,'Retail sales',0.00,0.00,0.00,958.58,0.00,'2021-12-13 05:54:55','',''),(2265303,'1','148','769',327,'Retail Sale Id 1326783',1003427.88,0.00,0.00,0.00,27304.16,'2021-12-13 05:59:29','',''),(2265304,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1706.51,0.00,'2021-12-13 05:59:29','',''),(2265307,'1','148','769',327,'Retail Sale Id 1326785',76156.00,0.00,0.00,0.00,7230.00,'2021-12-13 06:00:30','',''),(2265308,'1','148','769',327,'Retail sales',0.00,0.00,0.00,120.50,0.00,'2021-12-13 06:00:30','',''),(2266606,'1','148','769',327,'Retail Sale Id 1327422',155820.00,0.00,0.00,0.00,4240.00,'2021-12-13 07:51:43','',''),(2266607,'1','148','769',327,'Retail sales',0.00,0.00,0.00,265.00,0.00,'2021-12-13 07:51:43','',''),(2266654,'1','148','769',327,'Retail Sale Id 1327447',7900.00,0.00,0.00,0.00,750.00,'2021-12-13 07:55:10','',''),(2266655,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 07:55:10','',''),(2266670,'1','148','769',327,'Retail Sale Id 1327454',3197.92,0.00,0.00,0.00,303.60,'2021-12-13 07:55:44','',''),(2266671,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 07:55:44','',''),(2266686,'1','148','769',327,'Retail Sale Id 1327462',2799.76,0.00,0.00,0.00,265.80,'2021-12-13 07:56:23','',''),(2266687,'1','148','769',327,'Retail sales',0.00,0.00,0.00,4.43,0.00,'2021-12-13 07:56:23','',''),(2266718,'1','148','769',327,'Retail Sale Id 1327479',3798.32,0.00,0.00,0.00,360.60,'2021-12-13 07:58:34','',''),(2266719,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 07:58:34','',''),(2266757,'1','148','769',327,'Retail Sale Id 1327494',3197.92,0.00,0.00,0.00,303.60,'2021-12-13 08:00:03','',''),(2266758,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 08:00:03','',''),(2266773,'1','148','769',327,'Retail Sale Id 1327502',1902.32,0.00,0.00,0.00,180.60,'2021-12-13 08:00:57','',''),(2266774,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 08:00:57','',''),(2266825,'1','148','769',327,'Retail Sale Id 1327521',3197.92,0.00,0.00,0.00,303.60,'2021-12-13 08:03:02','',''),(2266826,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 08:03:02','',''),(2266870,'1','148','769',327,'Retail Sale Id 1327530',1997.12,0.00,0.00,0.00,189.60,'2021-12-13 08:04:03','',''),(2266871,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 08:04:03','',''),(2266903,'1','148','769',327,'Retail Sale Id 1327543',998.56,0.00,0.00,0.00,94.80,'2021-12-13 08:05:34','',''),(2266904,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 08:05:34','',''),(2266943,'1','148','769',327,'Retail Sale Id 1327555',7900.00,0.00,0.00,0.00,750.00,'2021-12-13 08:07:03','',''),(2266944,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 08:07:03','',''),(2267643,'1','148','769',327,'Retail Sale Id 1327861',98196.00,0.00,0.00,0.00,2672.00,'2021-12-13 08:41:15','',''),(2267644,'1','148','769',327,'Retail sales',0.00,0.00,0.00,167.00,0.00,'2021-12-13 08:41:15','',''),(2267758,'1','148','769',327,'Retail Sale Id 1327900',7644.00,0.00,0.00,0.00,208.00,'2021-12-13 08:46:29','',''),(2267759,'1','148','769',327,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-13 08:46:29','',''),(2267789,'1','148','769',327,'Retail Sale Id 1327910',6004.00,0.00,0.00,0.00,570.00,'2021-12-13 08:48:21','',''),(2267790,'1','148','769',327,'Retail sales',0.00,0.00,0.00,9.50,0.00,'2021-12-13 08:48:21','',''),(2268264,'1','148','769',327,'Retail Sale Id 1328103',3798.32,0.00,0.00,0.00,360.60,'2021-12-13 09:14:29','',''),(2268265,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 09:14:29','',''),(2268288,'1','148','769',327,'Retail Sale Id 1328112',3798.32,0.00,0.00,0.00,360.60,'2021-12-13 09:16:05','',''),(2268289,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 09:16:05','',''),(2268694,'1','148','769',327,'Retail Sale Id 1328325',3197.92,0.00,0.00,0.00,303.60,'2021-12-13 09:43:03','',''),(2268695,'1','148','769',327,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-13 09:43:03','',''),(2268716,'1','148','769',327,'Retail Sale Id 1328337',3798.32,0.00,0.00,0.00,360.60,'2021-12-13 09:44:39','',''),(2268717,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 09:44:39','',''),(2268726,'1','148','769',327,'Retail Sale Id 1328342',998.56,0.00,0.00,0.00,94.80,'2021-12-13 09:45:22','',''),(2268727,'1','148','769',327,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-13 09:45:22','',''),(2268738,'1','148','769',327,'Retail Sale Id 1328348',3798.32,0.00,0.00,0.00,360.60,'2021-12-13 09:46:11','',''),(2268739,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 09:46:11','',''),(2268795,'1','148','769',327,'Retail Sale Id 1328377',111720.00,0.00,0.00,0.00,3040.00,'2021-12-13 09:48:48','',''),(2268796,'1','148','769',327,'Retail sales',0.00,0.00,0.00,190.00,0.00,'2021-12-13 09:48:48','',''),(2268805,'1','148','769',327,'Retail Sale Id 1328382',2502.72,0.00,0.00,0.00,237.60,'2021-12-13 09:49:28','',''),(2268806,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-13 09:49:28','',''),(2268949,'1','148','769',327,'Retail Sale Id 1328447',3798.32,0.00,0.00,0.00,360.60,'2021-12-13 09:57:51','',''),(2268950,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 09:57:51','',''),(2268989,'1','148','769',327,'Retail Sale Id 1328463',3798.32,0.00,0.00,0.00,360.60,'2021-12-13 09:59:53','',''),(2268990,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 09:59:53','',''),(2269265,'1','148','769',327,'Retail Sale Id 1328618',3798.32,0.00,0.00,0.00,360.60,'2021-12-13 10:20:34','',''),(2269266,'1','148','769',327,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 10:20:34','',''),(2269798,'1','148','769',327,'Retail Sale Id 1328880',499.28,0.00,0.00,0.00,47.40,'2021-12-13 10:52:27','',''),(2269799,'1','148','769',327,'Retail sales',0.00,0.00,0.00,0.79,0.00,'2021-12-13 10:52:27','',''),(2269816,'1','148','769',327,'Retail Sale Id 1328888',1997.12,0.00,0.00,0.00,189.60,'2021-12-13 10:53:18','',''),(2269817,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-13 10:53:18','',''),(2270113,'1','148','769',327,'Retail Sale Id 1329026',74382.00,0.00,0.00,0.00,2024.00,'2021-12-13 11:15:03','',''),(2270114,'1','148','769',327,'Retail sales',0.00,0.00,0.00,126.50,0.00,'2021-12-13 11:15:03','',''),(2270502,'1','148','769',327,'Retail Sale Id 1329216',7900.00,0.00,0.00,0.00,750.00,'2021-12-13 11:43:40','',''),(2270503,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 11:43:40','',''),(2270512,'1','148','769',327,'Retail Sale Id 1329220',7900.00,0.00,0.00,0.00,750.00,'2021-12-13 11:44:27','',''),(2270513,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 11:44:27','',''),(2270516,'1','148','769',327,'Retail Sale Id 1329221',47400.00,0.00,0.00,0.00,4500.00,'2021-12-13 11:44:57','',''),(2270517,'1','148','769',327,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-13 11:44:57','',''),(2271203,'1','148','769',327,'Retail Sale Id 1329598',1497.84,0.00,0.00,0.00,142.20,'2021-12-13 12:41:47','',''),(2271204,'1','148','769',327,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-13 12:41:47','',''),(2271257,'1','148','769',327,'Retail Sale Id 1329629',30001.04,0.00,0.00,0.00,2848.20,'2021-12-13 12:45:10','',''),(2271258,'1','148','769',327,'Retail sales',0.00,0.00,0.00,47.47,0.00,'2021-12-13 12:45:10','',''),(2271259,'1','148','769',327,'Retail Sale Id 1329632',15800.00,0.00,0.00,0.00,1500.00,'2021-12-13 12:45:36','',''),(2271260,'1','148','769',327,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-13 12:45:36','',''),(2271723,'1','148','769',327,'Retail Sale Id 1329857',7900.00,0.00,0.00,0.00,750.00,'2021-12-13 13:15:06','',''),(2271724,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 13:15:06','',''),(2280751,'1','148','769',327,'Return of Retail Sale Id 1328377',0.00,111720.00,190.00,0.00,-3040.00,'2021-12-14 09:42:35','',''),(2280761,'1','148','769',327,'Return of Retail Sale Id 1329026',0.00,74382.00,126.50,0.00,-2024.00,'2021-12-14 09:43:27','',''),(2280772,'1','148','769',327,'Return of Retail Sale Id 1329221',0.00,47400.00,75.00,0.00,-4500.00,'2021-12-14 09:43:55','',''),(2280781,'1','148','769',327,'Return of Retail Sale Id 1329629',0.00,30001.04,47.47,0.00,-2848.20,'2021-12-14 09:44:30','',''),(2281106,'1','148','769',327,'Return of Retail Sale Id 1327861',0.00,98196.00,167.00,0.00,-2672.00,'2021-12-14 10:05:04','',''),(2281161,'1','148','769',327,'Return of Retail Sale Id 1329632',0.00,15800.00,25.00,0.00,-1500.00,'2021-12-14 10:08:15','',''),(2281181,'1','148','769',327,'Return of Retail Sale Id 1327422',0.00,155820.00,265.00,0.00,-4240.00,'2021-12-14 10:09:48','',''),(2281232,'1','148','769',327,'Return of Retail Sale Id 1327900',0.00,7644.00,13.00,0.00,-208.00,'2021-12-14 10:11:55','',''),(2281359,'1','148','769',327,'Retail Sale Id 1334345',7900.00,0.00,0.00,0.00,750.00,'2021-12-14 10:17:26','',''),(2281360,'1','148','769',327,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 10:17:26','',''),(2281541,'1','148','769',327,'Retail Sale Id 1334427',25280.00,0.00,0.00,0.00,2400.00,'2021-12-14 10:25:40','',''),(2281542,'1','148','769',327,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-14 10:25:40','',''),(2281585,'1','148','769',327,'Retail Sale Id 1334450',1902.32,0.00,0.00,0.00,180.60,'2021-12-14 10:28:15','',''),(2281586,'1','148','769',327,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-14 10:28:15','',''),(2281684,'1','148','769',327,'Retail Sale Id 1334555',422093.84,0.00,0.00,0.00,40072.20,'2021-12-14 10:34:04','',''),(2281685,'1','148','769',327,'Retail sales',0.00,0.00,0.00,667.87,0.00,'2021-12-14 10:34:04','',''),(2281710,'1','148','769',327,'Retail Sale Id 1334570',502216.68,0.00,0.00,0.00,13665.76,'2021-12-14 10:35:06','',''),(2281711,'1','148','769',327,'Retail sales',0.00,0.00,0.00,854.11,0.00,'2021-12-14 10:35:06','',''),(2281734,'1','148','769',327,'Return of Retail Sale Id 1334427',0.00,25280.00,40.00,0.00,-2400.00,'2021-12-14 10:36:25','',''),(2281741,'1','148','769',327,'Return of Retail Sale Id 1334345',0.00,7900.00,12.50,0.00,-750.00,'2021-12-14 10:36:53','',''),(2281776,'1','148','769',327,'Return of Retail Sale Id 1334450',0.00,1902.32,3.01,0.00,-180.60,'2021-12-14 10:38:54','',''),(2282154,'1','148','769',327,'Retail Sale Id 1334809',79895.20,0.00,0.00,0.00,5706.80,'2021-12-14 11:02:18','',''),(2282155,'1','148','769',327,'Retail sales',0.00,0.00,0.00,129.70,0.00,'2021-12-14 11:02:18','',''),(2282165,'1','148','769',327,'Retail Sale Id 1334814',394800.00,0.00,0.00,0.00,-5600.00,'2021-12-14 11:03:09','',''),(2282166,'1','148','769',327,'Retail sales',0.00,0.00,0.00,700.00,0.00,'2021-12-14 11:03:09','',''),(2283144,'1','148','769',327,'Retail Sale Id 1335908',7700.00,0.00,0.00,12.50,0.00,'2021-12-14 13:50:05','',''),(2283153,'1','148','769',327,'Retail Sale Id 1335916',3702.16,0.00,0.00,6.01,0.00,'2021-12-14 13:51:04','',''),(2283263,'1','148','769',327,'Retail Sale Id 1335976',1848.00,0.00,0.00,3.00,0.00,'2021-12-14 14:01:13','',''),(2283268,'1','148','769',327,'Retail Sale Id 1335981',1503.04,0.00,0.00,2.44,0.00,'2021-12-14 14:01:58','',''),(2283278,'1','148','769',327,'Retail Sale Id 1335992',2002.00,0.00,0.00,3.25,0.00,'2021-12-14 14:02:47','',''),(2283292,'1','148','769',327,'Retail Sale Id 1336003',2002.00,0.00,0.00,3.25,0.00,'2021-12-14 14:04:45','',''),(2283295,'1','148','769',327,'Retail Sale Id 1336008',5001.92,0.00,0.00,8.12,0.00,'2021-12-14 14:05:32','',''),(2283359,'1','148','769',327,'Retail Sale Id 1336032',2002.00,0.00,0.00,3.25,0.00,'2021-12-14 14:08:11','',''),(2283380,'1','148','769',327,'Retail Sale Id 1336043',7700.00,0.00,0.00,12.50,0.00,'2021-12-14 14:09:59','',''),(2283398,'1','148','769',327,'Retail Sale Id 1336059',2500.96,0.00,0.00,4.06,0.00,'2021-12-14 14:12:52','',''),(2283411,'1','148','769',327,'Retail Sale Id 1336071',997.92,0.00,0.00,1.62,0.00,'2021-12-14 14:14:57','',''),(2283418,'1','148','769',327,'Retail Sale Id 1336082',2999.92,0.00,0.00,4.87,0.00,'2021-12-14 14:15:41','',''),(2283452,'1','148','769',327,'Retail Sale Id 1336110',3702.16,0.00,0.00,6.01,0.00,'2021-12-14 14:19:16','',''),(2283464,'1','148','769',327,'Retail Sale Id 1336117',3702.16,0.00,0.00,6.01,0.00,'2021-12-14 14:20:14','',''),(2283505,'1','148','769',327,'Retail Sale Id 1336159',2999.92,0.00,0.00,4.87,0.00,'2021-12-14 14:26:14','',''),(2283545,'1','148','769',327,'Retail Sale Id 1336192',3702.16,0.00,0.00,6.01,0.00,'2021-12-14 14:30:15','',''),(2283591,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,2918340.00,5230.00,0.00,0.00,'2021-12-14 14:32:43','',''),(2283606,'1','148',NULL,327,'Reception corrector for bridging 127363',0.00,0.00,0.00,5230.00,0.00,'2021-12-14 14:34:07','',''),(2283607,'1','148','769',327,'Received from bridging 127363',0.00,0.00,5230.00,0.00,0.00,'2021-12-14 14:34:07','',''),(2283832,'1','148','769',327,'Retail Sale Id 1336390',7700.00,0.00,0.00,12.50,725.00,'2021-12-14 15:02:44','',''),(2284283,'1','148','769',327,'Retail Sale Id 1336708',30800.00,0.00,0.00,50.00,2900.00,'2021-12-14 15:50:33','',''),(2284361,'1','148','769',327,'Retail Sale Id 1336767',29999.20,0.00,0.00,48.70,2824.60,'2021-12-14 15:58:24','',''),(2284392,'1','148','769',327,'Retail Sale Id 1336788',6997.76,0.00,0.00,11.36,658.88,'2021-12-14 16:01:14','',''),(2284408,'1','148','769',327,'Retail Sale Id 1336801',2999.92,0.00,0.00,4.87,282.46,'2021-12-14 16:02:05','',''),(2284450,'1','148','769',327,'Retail Sale Id 1336841',2999.92,0.00,0.00,4.87,282.46,'2021-12-14 16:06:17','',''),(2284461,'1','148','769',327,'Retail Sale Id 1336852',997.92,0.00,0.00,1.62,93.96,'2021-12-14 16:06:54','',''),(2284465,'1','148','769',327,'Retail Sale Id 1336855',2002.00,0.00,0.00,3.25,188.50,'2021-12-14 16:07:32','',''),(2284485,'1','148','769',327,'Retail Sale Id 1336878',2999.92,0.00,0.00,4.87,282.46,'2021-12-14 16:10:19','',''),(2284494,'1','148','769',327,'Retail Sale Id 1336884',997.92,0.00,0.00,1.62,93.96,'2021-12-14 16:11:01','',''),(2284499,'1','148','769',327,'Retail Sale Id 1336890',2999.92,0.00,0.00,4.87,282.46,'2021-12-14 16:11:43','',''),(2284516,'1','148','769',327,'Retail Sale Id 1336908',2500.96,0.00,0.00,4.06,235.48,'2021-12-14 16:13:45','',''),(2284566,'1','148','769',327,'Retail Sale Id 1336962',1250.48,0.00,0.00,2.03,117.74,'2021-12-14 16:20:53','',''),(2284577,'1','148','769',327,'Retail Sale Id 1336971',2002.00,0.00,0.00,3.25,188.50,'2021-12-14 16:21:57','',''),(2284584,'1','148','769',327,'Retail Sale Id 1336978',2002.00,0.00,0.00,3.25,188.50,'2021-12-14 16:22:35','',''),(2284593,'1','148','769',327,'Retail Sale Id 1336987',2999.92,0.00,0.00,4.87,282.46,'2021-12-14 16:23:31','',''),(2284600,'1','148','769',327,'Retail Sale Id 1336993',997.92,0.00,0.00,1.62,93.96,'2021-12-14 16:24:16','',''),(2284624,'1','148','769',327,'Retail Sale Id 1337003',2999.92,0.00,0.00,4.87,282.46,'2021-12-14 16:24:58','',''),(2284633,'1','148','769',327,'Retail Sale Id 1337015',6498.80,0.00,0.00,10.55,611.90,'2021-12-14 16:25:53','',''),(2284648,'1','148','769',327,'Retail Sale Id 1337028',3997.84,0.00,0.00,6.49,376.42,'2021-12-14 16:26:52','',''),(2284687,'1','148','769',327,'Retail Sale Id 1337050',2999.92,0.00,0.00,4.87,282.46,'2021-12-14 16:28:54','',''),(2284704,'1','148','769',327,'Retail Sale Id 1337066',2002.00,0.00,0.00,3.25,188.50,'2021-12-14 16:30:15','',''),(2284710,'1','148','769',327,'Retail Sale Id 1337077',2999.92,0.00,0.00,4.87,282.46,'2021-12-14 16:30:56','',''),(2284726,'1','148','769',327,'Retail Sale Id 1337091',1503.04,0.00,0.00,2.44,141.52,'2021-12-14 16:32:51','',''),(2284741,'1','148','769',327,'Retail Sale Id 1337106',2002.00,0.00,0.00,3.25,188.50,'2021-12-14 16:33:50','',''),(2284876,'1','148','769',327,'Retail Sale Id 1337195',5001.92,0.00,0.00,8.12,470.96,'2021-12-14 16:43:26','',''),(2284885,'1','148','769',327,'Retail Sale Id 1337205',2002.00,0.00,0.00,3.25,188.50,'2021-12-14 16:44:22','',''),(2284938,'1','148','769',327,'Retail Sale Id 1337242',7700.00,0.00,0.00,12.50,725.00,'2021-12-14 16:49:48','',''),(2284948,'1','148','769',327,'Retail Sale Id 1337252',2500.96,0.00,0.00,4.06,235.48,'2021-12-14 16:51:23','',''),(2284970,'1','148','769',327,'Retail Sale Id 1337257',2999.92,0.00,0.00,4.87,282.46,'2021-12-14 16:52:21','',''),(2284976,'1','148','769',327,'Retail Sale Id 1337263',997.92,0.00,0.00,1.62,93.96,'2021-12-14 16:53:21','',''),(2284999,'1','148','769',327,'Retail Sale Id 1337277',3098.48,0.00,0.00,5.03,291.74,'2021-12-14 16:55:30','',''),(2285007,'1','148','769',327,'Retail Sale Id 1337289',800.80,0.00,0.00,1.30,75.40,'2021-12-14 16:56:20','',''),(2285020,'1','148','769',327,'Retail Sale Id 1337302',7700.00,0.00,0.00,12.50,725.00,'2021-12-14 16:58:47','',''),(2285031,'1','148','769',327,'Retail Sale Id 1337308',3997.84,0.00,0.00,6.49,376.42,'2021-12-14 16:59:45','',''),(2285053,'1','148','769',327,'Retail Sale Id 1337331',3702.16,0.00,0.00,6.01,348.58,'2021-12-14 17:02:25','',''),(2285062,'1','148','769',327,'Retail Sale Id 1337342',7700.00,0.00,0.00,12.50,725.00,'2021-12-14 17:03:45','',''),(2285091,'1','148','769',327,'Retail Sale Id 1337374',2999.92,0.00,0.00,4.87,282.46,'2021-12-14 17:07:18','',''),(2285143,'1','148','769',327,'Retail Sale Id 1337421',7700.00,0.00,0.00,12.50,725.00,'2021-12-14 17:16:07','',''),(2285148,'1','148','769',327,'Retail Sale Id 1337428',1798.72,0.00,0.00,2.92,169.36,'2021-12-14 17:17:17','',''),(2285158,'1','148','769',327,'Retail Sale Id 1337434',1250.48,0.00,0.00,2.03,117.74,'2021-12-14 17:18:13','',''),(2285174,'1','148','769',327,'Retail Sale Id 1337442',3702.16,0.00,0.00,6.01,348.58,'2021-12-14 17:19:01','',''),(2285191,'1','148','769',327,'Retail Sale Id 1337458',3702.16,0.00,0.00,6.01,348.58,'2021-12-14 17:23:24','',''),(2285197,'1','148','769',327,'Retail Sale Id 1337464',1503.04,0.00,0.00,2.44,141.52,'2021-12-14 17:24:50','',''),(2285199,'1','148','769',327,'Retail Sale Id 1337466',616.00,0.00,0.00,1.00,58.00,'2021-12-14 17:26:05','',''),(2285296,'1','148','769',327,'Retail Sale Id 1337561',7700.00,0.00,0.00,12.50,725.00,'2021-12-14 18:02:07','',''),(2285924,'1','148','769',327,'Retail Sale Id 1337713',156889.04,0.00,0.00,254.69,14772.02,'2021-12-15 06:11:38','',''),(2286040,'1','148','769',327,'Retail Sale Id 1337756',470646.72,0.00,0.00,834.48,5006.88,'2021-12-15 06:23:49','',''),(2286045,'1','148','769',327,'Retail Sale Id 1337760',46520.32,0.00,0.00,75.52,4380.16,'2021-12-15 06:24:42','',''),(2286129,'1','148','769',327,'Retail Sale Id 1337818',2698.08,0.00,0.00,4.38,254.04,'2021-12-15 06:36:58','',''),(2286138,'1','148','769',327,'Retail Sale Id 1337827',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 06:38:18','',''),(2286153,'1','148','769',327,'Retail Sale Id 1337835',6160.00,0.00,0.00,10.00,580.00,'2021-12-15 06:39:12','',''),(2286165,'1','148','769',327,'Retail Sale Id 1337839',1503.04,0.00,0.00,2.44,141.52,'2021-12-15 06:40:04','',''),(2286169,'1','148','769',327,'Retail Sale Id 1337843',498.96,0.00,0.00,0.81,46.98,'2021-12-15 06:40:47','',''),(2286183,'1','148','769',327,'Retail Sale Id 1337849',5001.92,0.00,0.00,8.12,470.96,'2021-12-15 06:41:35','',''),(2286187,'1','148','769',327,'Retail Sale Id 1337851',2999.92,0.00,0.00,4.87,282.46,'2021-12-15 06:42:33','',''),(2286245,'1','148','769',327,'Retail Sale Id 1337913',800.80,0.00,0.00,1.30,75.40,'2021-12-15 06:50:17','',''),(2286281,'1','148','769',327,'Retail Sale Id 1337954',2002.00,0.00,0.00,3.25,188.50,'2021-12-15 06:57:11','',''),(2286297,'1','148','769',327,'Retail Sale Id 1337968',5001.92,0.00,0.00,8.12,470.96,'2021-12-15 06:59:13','',''),(2286329,'1','148','769',327,'Retail Sale Id 1337990',3702.16,0.00,0.00,6.01,348.58,'2021-12-15 07:01:42','',''),(2286336,'1','148','769',327,'Retail Sale Id 1337998',113364.00,0.00,0.00,201.00,1206.00,'2021-12-15 07:02:50','',''),(2286352,'1','148','769',327,'Retail Sale Id 1338006',2999.92,0.00,0.00,4.87,282.46,'2021-12-15 07:03:35','',''),(2286356,'1','148','769',327,'Retail Sale Id 1338010',2002.00,0.00,0.00,3.25,188.50,'2021-12-15 07:04:19','',''),(2286368,'1','148','769',327,'Retail Sale Id 1338018',997.92,0.00,0.00,1.62,93.96,'2021-12-15 07:05:24','',''),(2286429,'1','148','769',327,'Retail Sale Id 1338093',3498.88,0.00,0.00,5.68,329.44,'2021-12-15 07:12:55','',''),(2286461,'1','148','769',327,'Retail Sale Id 1338128',95316.00,0.00,0.00,169.00,1014.00,'2021-12-15 07:17:46','',''),(2286473,'1','148','769',327,'Retail Sale Id 1338142',2002.00,0.00,0.00,3.25,188.50,'2021-12-15 07:19:00','',''),(2286479,'1','148','769',327,'Retail Sale Id 1338147',1897.28,0.00,0.00,3.08,178.64,'2021-12-15 07:19:36','',''),(2286485,'1','148','769',327,'Retail Sale Id 1338154',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 07:20:28','',''),(2286494,'1','148','769',327,'Retail Sale Id 1338165',997.92,0.00,0.00,1.62,93.96,'2021-12-15 07:21:52','',''),(2286505,'1','148','769',327,'Retail Sale Id 1338174',2999.92,0.00,0.00,4.87,282.46,'2021-12-15 07:23:20','',''),(2286507,'1','148','769',327,'Retail Sale Id 1338177',3997.84,0.00,0.00,6.49,376.42,'2021-12-15 07:23:59','',''),(2286518,'1','148','769',327,'Retail Sale Id 1338188',997.92,0.00,0.00,1.62,93.96,'2021-12-15 07:26:00','',''),(2286526,'1','148','769',327,'Retail Sale Id 1338197',3702.16,0.00,0.00,6.01,348.58,'2021-12-15 07:26:56','',''),(2286543,'1','148','769',327,'Retail Sale Id 1338206',3997.84,0.00,0.00,6.49,376.42,'2021-12-15 07:28:04','',''),(2286602,'1','148','769',327,'Retail Sale Id 1338248',5001.92,0.00,0.00,8.12,470.96,'2021-12-15 07:33:09','',''),(2286610,'1','148','769',327,'Retail Sale Id 1338258',997.92,0.00,0.00,1.62,93.96,'2021-12-15 07:34:09','',''),(2286634,'1','148','769',327,'Retail Sale Id 1338284',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 07:36:32','',''),(2286643,'1','148','769',327,'Retail Sale Id 1338292',1897.28,0.00,0.00,3.08,178.64,'2021-12-15 07:37:18','',''),(2286655,'1','148','769',327,'Retail Sale Id 1338307',3098.48,0.00,0.00,5.03,291.74,'2021-12-15 07:38:24','',''),(2286663,'1','148','769',327,'Retail Sale Id 1338313',1503.04,0.00,0.00,2.44,141.52,'2021-12-15 07:39:18','',''),(2286715,'1','148','769',327,'Retail Sale Id 1338358',800.80,0.00,0.00,1.30,75.40,'2021-12-15 07:45:07','',''),(2286731,'1','148','769',327,'Retail Sale Id 1338367',2648.80,0.00,0.00,4.30,249.40,'2021-12-15 07:46:37','',''),(2286743,'1','148','769',327,'Retail Sale Id 1338374',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 07:47:32','',''),(2286779,'1','148','769',327,'Retail Sale Id 1338401',2002.00,0.00,0.00,3.25,188.50,'2021-12-15 07:50:32','',''),(2286825,'1','148','769',327,'Retail Sale Id 1338420',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 07:52:42','',''),(2286858,'1','148','769',327,'Retail Sale Id 1338455',6997.76,0.00,0.00,11.36,658.88,'2021-12-15 07:58:05','',''),(2286873,'1','148','769',327,'Retail Sale Id 1338467',2002.00,0.00,0.00,3.25,188.50,'2021-12-15 07:59:18','',''),(2286881,'1','148','769',327,'Retail Sale Id 1338473',2999.92,0.00,0.00,4.87,282.46,'2021-12-15 07:59:57','',''),(2286897,'1','148','769',327,'Retail Sale Id 1338485',1897.28,0.00,0.00,3.08,178.64,'2021-12-15 08:01:29','',''),(2286925,'1','148','769',327,'Retail Sale Id 1338500',997.92,0.00,0.00,1.62,93.96,'2021-12-15 08:03:01','',''),(2286934,'1','148','769',327,'Retail Sale Id 1338508',3498.88,0.00,0.00,5.68,329.44,'2021-12-15 08:03:58','',''),(2286945,'1','148','769',327,'Retail Sale Id 1338518',3702.16,0.00,0.00,6.01,348.58,'2021-12-15 08:05:04','',''),(2286980,'1','148','769',327,'Retail Sale Id 1338531',3702.16,0.00,0.00,6.01,348.58,'2021-12-15 08:07:26','',''),(2287014,'1','148','769',327,'Retail Sale Id 1338548',5500.88,0.00,0.00,8.93,517.94,'2021-12-15 08:08:46','',''),(2287225,'1','148','769',327,'Retail Sale Id 1338740',65988.00,0.00,0.00,117.00,702.00,'2021-12-15 08:31:27','',''),(2287253,'1','148','769',327,'Retail Sale Id 1338749',3702.16,0.00,0.00,6.01,348.58,'2021-12-15 08:32:50','',''),(2287276,'1','148','769',327,'Retail Sale Id 1338767',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 08:35:20','',''),(2287622,'1','148','769',327,'Retail Sale Id 1339049',1398.32,0.00,0.00,2.27,131.66,'2021-12-15 09:12:28','',''),(2287627,'1','148','769',327,'Retail Sale Id 1339055',3702.16,0.00,0.00,6.01,348.58,'2021-12-15 09:13:15','',''),(2287649,'1','148','769',327,'Retail Sale Id 1339078',6196.96,0.00,0.00,10.06,583.48,'2021-12-15 09:16:45','',''),(2287658,'1','148','769',327,'Retail Sale Id 1339089',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 09:17:43','',''),(2287673,'1','148','769',327,'Retail Sale Id 1339102',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 09:19:23','',''),(2288066,'1','148','769',327,'Retail Sale Id 1339430',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 10:05:57','',''),(2288121,'1','148','769',327,'Retail Sale Id 1339474',108852.00,0.00,0.00,193.00,1158.00,'2021-12-15 10:12:07','',''),(2288135,'1','148','769',327,'Retail Sale Id 1339489',3702.16,0.00,0.00,6.01,348.58,'2021-12-15 10:14:48','',''),(2288214,'1','148','769',327,'Retail Sale Id 1339552',3997.84,0.00,0.00,6.49,376.42,'2021-12-15 10:25:44','',''),(2288356,'1','148','769',327,'Retail Sale Id 1339676',3098.48,0.00,0.00,5.03,291.74,'2021-12-15 10:45:58','',''),(2288365,'1','148','769',327,'Retail Sale Id 1339686',498.96,0.00,0.00,0.81,46.98,'2021-12-15 10:47:07','',''),(2288382,'1','148','769',327,'Retail Sale Id 1339693',3702.16,0.00,0.00,6.01,348.58,'2021-12-15 10:48:35','',''),(2288384,'1','148','769',327,'Retail Sale Id 1339695',2999.92,0.00,0.00,4.87,282.46,'2021-12-15 10:49:22','',''),(2288396,'1','148','769',327,'Retail Sale Id 1339705',6196.96,0.00,0.00,10.06,583.48,'2021-12-15 10:50:48','',''),(2288417,'1','148','769',327,'Retail Sale Id 1339719',2999.92,0.00,0.00,4.87,282.46,'2021-12-15 10:51:59','',''),(2288444,'1','148','769',327,'Retail Sale Id 1339747',3702.16,0.00,0.00,6.01,348.58,'2021-12-15 10:54:58','',''),(2288459,'1','148','769',327,'Retail Sale Id 1339758',2999.92,0.00,0.00,4.87,282.46,'2021-12-15 10:56:26','',''),(2288467,'1','148','769',327,'Retail Sale Id 1339764',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 10:57:25','',''),(2288487,'1','148','769',327,'Retail Sale Id 1339784',3702.16,0.00,0.00,6.01,348.58,'2021-12-15 10:59:52','',''),(2288557,'1','148','769',327,'Retail Sale Id 1339852',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 11:08:47','',''),(2288566,'1','148','769',327,'Retail Sale Id 1339861',3098.48,0.00,0.00,5.03,291.74,'2021-12-15 11:09:29','',''),(2288575,'1','148','769',327,'Retail Sale Id 1339870',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 11:11:17','',''),(2288655,'1','148','769',327,'Retail Sale Id 1339935',997.92,0.00,0.00,1.62,93.96,'2021-12-15 11:19:00','',''),(2288664,'1','148','769',327,'Retail Sale Id 1339941',3702.16,0.00,0.00,6.01,348.58,'2021-12-15 11:19:47','',''),(2288671,'1','148','769',327,'Retail Sale Id 1339949',3702.16,0.00,0.00,6.01,348.58,'2021-12-15 11:20:40','',''),(2288683,'1','148','769',327,'Retail Sale Id 1339958',3702.16,0.00,0.00,6.01,348.58,'2021-12-15 11:21:52','',''),(2288693,'1','148','769',327,'Retail Sale Id 1339969',3702.16,0.00,0.00,6.01,348.58,'2021-12-15 11:22:46','',''),(2288713,'1','148','769',327,'Retail Sale Id 1339978',997.92,0.00,0.00,1.62,93.96,'2021-12-15 11:24:04','',''),(2288718,'1','148','769',327,'Retail Sale Id 1339982',3098.48,0.00,0.00,5.03,291.74,'2021-12-15 11:24:46','',''),(2288749,'1','148','769',327,'Retail Sale Id 1340008',400.40,0.00,0.00,0.65,37.70,'2021-12-15 11:28:16','',''),(2288780,'1','148','769',327,'Retail Sale Id 1340032',6997.76,0.00,0.00,11.36,658.88,'2021-12-15 11:32:16','',''),(2288789,'1','148','769',327,'Retail Sale Id 1340040',3702.16,0.00,0.00,6.01,348.58,'2021-12-15 11:33:19','',''),(2288804,'1','148','769',327,'Retail Sale Id 1340055',2464.00,0.00,0.00,4.00,232.00,'2021-12-15 11:34:54','',''),(2288817,'1','148','769',327,'Retail Sale Id 1340070',1503.04,0.00,0.00,2.44,141.52,'2021-12-15 11:37:11','',''),(2288957,'1','148','769',327,'Retail Sale Id 1340217',1848.00,0.00,0.00,3.00,174.00,'2021-12-15 11:55:07','',''),(2288960,'1','148','769',327,'Retail Sale Id 1340221',2002.00,0.00,0.00,3.25,188.50,'2021-12-15 11:55:45','',''),(2288966,'1','148','769',327,'Retail Sale Id 1340226',1798.72,0.00,0.00,2.92,169.36,'2021-12-15 11:56:32','',''),(2288987,'1','148','769',327,'Retail Sale Id 1340248',2999.92,0.00,0.00,4.87,282.46,'2021-12-15 11:59:10','',''),(2288993,'1','148','769',327,'Retail Sale Id 1340254',3702.16,0.00,0.00,6.01,348.58,'2021-12-15 12:00:24','',''),(2289039,'1','148','769',327,'Retail Sale Id 1340300',6196.96,0.00,0.00,10.06,583.48,'2021-12-15 12:08:25','',''),(2289044,'1','148','769',327,'Retail Sale Id 1340306',597.52,0.00,0.00,0.97,56.26,'2021-12-15 12:09:27','',''),(2289081,'1','148','769',327,'Retail Sale Id 1340340',1848.00,0.00,0.00,3.00,174.00,'2021-12-15 12:14:03','',''),(2289110,'1','148','769',327,'Retail Sale Id 1340370',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 12:18:00','',''),(2289120,'1','148','769',327,'Retail Sale Id 1340378',1897.28,0.00,0.00,3.08,178.64,'2021-12-15 12:19:05','',''),(2289152,'1','148','769',327,'Retail Sale Id 1340411',1503.04,0.00,0.00,2.44,141.52,'2021-12-15 12:23:26','',''),(2289543,'1','148','769',327,'Retail Sale Id 1340733',3702.16,0.00,0.00,6.01,348.58,'2021-12-15 13:16:55','',''),(2289622,'1','148','769',327,'Retail Sale Id 1340799',1503.04,0.00,0.00,2.44,141.52,'2021-12-15 13:25:10','',''),(2289762,'1','148','769',327,'Retail Sale Id 1340907',3702.16,0.00,0.00,6.01,348.58,'2021-12-15 13:42:05','',''),(2289770,'1','148','769',327,'Retail Sale Id 1340914',997.92,0.00,0.00,1.62,93.96,'2021-12-15 13:43:08','',''),(2289783,'1','148','769',327,'Retail Sale Id 1340925',2002.00,0.00,0.00,3.25,188.50,'2021-12-15 13:44:40','',''),(2289810,'1','148','769',327,'Retail Sale Id 1340943',997.92,0.00,0.00,1.62,93.96,'2021-12-15 13:46:43','',''),(2289846,'1','148','769',327,'Retail Sale Id 1340974',997.92,0.00,0.00,1.62,93.96,'2021-12-15 13:50:28','',''),(2290141,'1','148','769',327,'Retail Sale Id 1341138',2500.96,0.00,0.00,4.06,235.48,'2021-12-15 14:12:07','',''),(2290211,'1','148','769',327,'Retail Sale Id 1341164',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 14:16:45','',''),(2291330,'1','148','769',327,'Retail Sale Id 1342049',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 15:55:58','',''),(2291943,'1','148','769',327,'Retail Sale Id 1342590',7700.00,0.00,0.00,12.50,725.00,'2021-12-15 16:48:25','',''),(2293294,'1','148','769',327,'Retail Sale Id 1343447',333576.32,0.00,0.00,541.52,31408.16,'2021-12-16 06:44:03','',''),(2293310,'1','148','769',327,'Retail Sale Id 1343464',581252.76,0.00,0.00,1030.59,6183.54,'2021-12-16 06:45:23','',''),(2293467,'1','148','769',327,'Retail Sale Id 1343574',6160.00,0.00,0.00,10.00,580.00,'2021-12-16 06:56:45','',''),(2293483,'1','148','769',327,'Retail Sale Id 1343585',5001.92,0.00,0.00,8.12,470.96,'2021-12-16 06:57:57','',''),(2294373,'1','148','769',327,'Retail Sale Id 1344199',5802.72,0.00,0.00,9.42,546.36,'2021-12-16 08:07:38','',''),(2294382,'1','148','769',327,'Retail Sale Id 1344208',3800.72,0.00,0.00,6.17,357.86,'2021-12-16 08:08:24','',''),(2294798,'1','148','769',327,'Retail Sale Id 1344522',4502.96,0.00,0.00,7.31,423.98,'2021-12-16 08:38:53','',''),(2294821,'1','148','769',327,'Retail Sale Id 1344531',7700.00,0.00,0.00,12.50,725.00,'2021-12-16 08:39:45','',''),(2294836,'1','148','769',327,'Retail Sale Id 1344543',6160.00,0.00,0.00,10.00,580.00,'2021-12-16 08:40:51','',''),(2294866,'1','148','769',327,'Retail Sale Id 1344559',3498.88,0.00,0.00,5.68,329.44,'2021-12-16 08:42:11','',''),(2295087,'1','148','769',327,'Retail Sale Id 1344733',1503.04,0.00,0.00,2.44,141.52,'2021-12-16 09:01:59','',''),(2295369,'1','148','769',327,'Retail Sale Id 1344987',2500.96,0.00,0.00,4.06,235.48,'2021-12-16 09:27:31','',''),(2295388,'1','148','769',327,'Retail Sale Id 1345001',3702.16,0.00,0.00,6.01,348.58,'2021-12-16 09:29:21','',''),(2295396,'1','148','769',327,'Retail Sale Id 1345009',1848.00,0.00,0.00,3.00,174.00,'2021-12-16 09:30:21','',''),(2296246,'1','148','769',327,'Retail Sale Id 1345722',3850.00,0.00,0.00,6.25,362.50,'2021-12-16 10:54:11','',''),(2296254,'1','148','769',327,'Retail Sale Id 1345731',7700.00,0.00,0.00,12.50,725.00,'2021-12-16 10:54:49','',''),(2296256,'1','148','769',327,'Retail Sale Id 1345734',6160.00,0.00,0.00,10.00,580.00,'2021-12-16 10:55:22','',''),(2296549,'1','148','769',327,'Retail Sale Id 1345995',1053.36,0.00,0.00,1.71,99.18,'2021-12-16 11:27:47','',''),(2296563,'1','148','769',327,'Retail Sale Id 1346004',7601.44,0.00,0.00,12.34,715.72,'2021-12-16 11:29:51','',''),(2297464,'1','148','769',327,'Retail Sale Id 1346795',113928.00,0.00,0.00,202.00,1212.00,'2021-12-16 13:14:19','',''),(2297475,'1','148','769',327,'Retail Sale Id 1346805',149460.00,0.00,0.00,265.00,1590.00,'2021-12-16 13:15:31','',''),(2297505,'1','148','769',327,'Retail Sale Id 1346833',60912.00,0.00,0.00,108.00,648.00,'2021-12-16 13:18:34','',''),(2297588,'1','148','769',327,'Retail Sale Id 1346908',1848.00,0.00,0.00,3.00,174.00,'2021-12-16 13:26:11','',''),(2297600,'1','148','769',327,'Retail Sale Id 1346919',5999.84,0.00,0.00,9.74,564.92,'2021-12-16 13:27:37','',''),(2297771,'1','148','769',327,'Retail Sale Id 1347056',2002.00,0.00,0.00,3.25,188.50,'2021-12-16 13:43:21','',''),(2297777,'1','148','769',327,'Retail Sale Id 1347062',3702.16,0.00,0.00,6.01,348.58,'2021-12-16 13:44:09','',''),(2297800,'1','148','769',327,'Retail Sale Id 1347067',3702.16,0.00,0.00,6.01,348.58,'2021-12-16 13:44:46','',''),(2297808,'1','148','769',327,'Retail Sale Id 1347075',7700.00,0.00,0.00,12.50,725.00,'2021-12-16 13:45:41','',''),(2297836,'1','148','769',327,'Retail Sale Id 1347092',3702.16,0.00,0.00,6.01,348.58,'2021-12-16 13:47:26','',''),(2297853,'1','148','769',327,'Retail Sale Id 1347100',15400.00,0.00,0.00,25.00,1450.00,'2021-12-16 13:48:15','',''),(2297884,'1','148','769',327,'Retail Sale Id 1347130',652.96,0.00,0.00,1.06,61.48,'2021-12-16 13:51:18','',''),(2297954,'1','148','769',327,'Retail Sale Id 1347193',7700.00,0.00,0.00,12.50,725.00,'2021-12-16 13:58:48','',''),(2298004,'1','148','769',327,'Retail Sale Id 1347235',7700.00,0.00,0.00,12.50,725.00,'2021-12-16 14:05:23','',''),(2298022,'1','148','769',327,'Retail Sale Id 1347244',3702.16,0.00,0.00,6.01,348.58,'2021-12-16 14:06:13','',''),(2298034,'1','148','769',327,'Retail Sale Id 1347254',2500.96,0.00,0.00,4.06,235.48,'2021-12-16 14:07:27','',''),(2298084,'1','148','769',327,'Retail Sale Id 1347274',3098.48,0.00,0.00,5.03,291.74,'2021-12-16 14:09:25','',''),(2298106,'1','148','769',327,'Retail Sale Id 1347296',2999.92,0.00,0.00,4.87,282.46,'2021-12-16 14:11:46','',''),(2298132,'1','148','769',327,'Retail Sale Id 1347323',3098.48,0.00,0.00,5.03,291.74,'2021-12-16 14:14:26','',''),(2298157,'1','148','769',327,'Retail Sale Id 1347350',6997.76,0.00,0.00,11.36,658.88,'2021-12-16 14:18:00','',''),(2298166,'1','148','769',327,'Retail Sale Id 1347356',2500.96,0.00,0.00,4.06,235.48,'2021-12-16 14:18:42','',''),(2298174,'1','148','769',327,'Retail Sale Id 1347365',3702.16,0.00,0.00,6.01,348.58,'2021-12-16 14:19:33','',''),(2298193,'1','148','769',327,'Retail Sale Id 1347375',4502.96,0.00,0.00,7.31,423.98,'2021-12-16 14:20:53','',''),(2298209,'1','148','769',327,'Retail Sale Id 1347387',3702.16,0.00,0.00,6.01,348.58,'2021-12-16 14:21:53','',''),(2298350,'1','148','769',327,'Retail Sale Id 1347534',30800.00,0.00,0.00,50.00,2900.00,'2021-12-16 14:39:28','',''),(2298717,'1','148','769',327,'Retail Sale Id 1347772',7700.00,0.00,0.00,12.50,725.00,'2021-12-16 15:09:13','',''),(2299716,'1','148','769',327,'Retail Sale Id 1348478',7700.00,0.00,0.00,12.50,725.00,'2021-12-16 16:17:15','',''),(2300120,'1','148','769',327,'Return of Retail Sale Id 1347100',0.00,15400.00,25.00,0.00,-1450.00,'2021-12-16 16:56:04','',''),(2300124,'1','148','769',327,'Return of Retail Sale Id 1347534',0.00,30800.00,50.00,0.00,-2900.00,'2021-12-16 16:56:31','',''),(2300149,'1','148','769',327,'Return of Retail Sale Id 1347387',0.00,3702.16,6.01,0.00,-348.58,'2021-12-16 16:57:45','',''),(2300158,'1','148','769',327,'Retail Sale Id 1348894',67116.00,0.00,0.00,119.00,714.00,'2021-12-16 16:59:16','',''),(2301293,'1','148','769',327,'Return of Retail Sale Id 1348478',0.00,7700.00,12.50,0.00,-725.00,'2021-12-17 06:08:43','',''),(2301295,'1','148','769',327,'Return of Retail Sale Id 1347772',0.00,7700.00,12.50,0.00,-725.00,'2021-12-17 06:09:06','',''),(2301298,'1','148','769',327,'Return of Retail Sale Id 1347075',0.00,7700.00,12.50,0.00,-725.00,'2021-12-17 06:09:41','',''),(2301300,'1','148','769',327,'Return of Retail Sale Id 1347350',0.00,6997.76,11.36,0.00,-658.88,'2021-12-17 06:10:07','',''),(2301305,'1','148','769',327,'Return of Retail Sale Id 1344531',0.00,7700.00,12.50,0.00,-725.00,'2021-12-17 06:10:42','',''),(2301320,'1','148','769',327,'Return of Retail Sale Id 1346004',0.00,7601.44,12.34,0.00,-715.72,'2021-12-17 06:11:29','',''),(2301341,'1','148','769',327,'Return of Retail Sale Id 1346805',0.00,149460.00,265.00,0.00,-1590.00,'2021-12-17 06:14:34','',''),(2301346,'1','148','769',327,'Return of Retail Sale Id 1346795',0.00,113928.00,202.00,0.00,-1212.00,'2021-12-17 06:15:08','',''),(2301414,'1','148','769',327,'Retail Sale Id 1349525',8297.52,0.00,0.00,13.47,781.26,'2021-12-17 06:27:43','',''),(2301443,'1','148','769',327,'Retail Sale Id 1349541',199244.28,0.00,0.00,353.27,2119.62,'2021-12-17 06:30:10','',''),(2301523,'1','148','769',327,'Distributed to OPERATIONAL LOSS for sales id:340284',53383.86,0.00,0.00,95.67,0.00,'2021-12-17 06:43:07','',''),(2301536,'1','148','769',327,'Retail Sale Id 1349625',7700.00,0.00,0.00,12.50,725.00,'2021-12-17 06:44:55','',''),(2301555,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,2974140.00,5330.00,0.00,0.00,'2021-12-17 06:47:37','',''),(2301567,'1','148',NULL,327,'Reception corrector for bridging 127680',0.00,0.00,0.00,5330.00,0.00,'2021-12-17 06:49:05','',''),(2301568,'1','148','769',327,'Received from bridging 127680',0.00,0.00,5330.00,0.00,0.00,'2021-12-17 06:49:05','',''),(2301575,'1','148','769',327,'Retail Sale Id 1349658',566713.84,0.00,0.00,919.99,53359.42,'2021-12-17 06:50:02','',''),(2301583,'1','148','769',327,'Retail Sale Id 1349665',743239.20,0.00,0.00,1317.80,7906.80,'2021-12-17 06:51:14','',''),(2301591,'1','148','769',327,'Return of Retail Sale Id 1349625',0.00,7700.00,12.50,0.00,-725.00,'2021-12-17 06:52:18','',''),(2301609,'1','148','769',327,'Return of Retail Sale Id 1349665',0.00,743239.20,1317.80,0.00,-7906.80,'2021-12-17 06:54:34','',''),(2301617,'1','148','769',327,'Return of Retail Sale Id 1349658',0.00,566713.84,919.99,0.00,-53359.42,'2021-12-17 06:55:27','',''),(2301665,'1','148','769',327,'Retail Sale Id 1349703',566713.84,0.00,0.00,919.99,53359.42,'2021-12-17 06:58:02','',''),(2301695,'1','148','769',327,'Retail Sale Id 1349716',743239.20,0.00,0.00,1317.80,7906.80,'2021-12-17 06:59:16','',''),(2302078,'1','148','769',327,'Retail Sale Id 1350048',149460.00,0.00,0.00,265.00,1590.00,'2021-12-17 07:36:56','',''),(2302107,'1','148','769',327,'Retail Sale Id 1350064',7502.88,0.00,0.00,12.18,706.44,'2021-12-17 07:39:23','',''),(2302119,'1','148','769',327,'Retail Sale Id 1350072',1848.00,0.00,0.00,3.00,174.00,'2021-12-17 07:40:12','',''),(2302140,'1','148','769',327,'Retail Sale Id 1350078',4650.80,0.00,0.00,7.55,437.90,'2021-12-17 07:41:14','',''),(2302191,'1','148','769',327,'Retail Sale Id 1350109',1848.00,0.00,0.00,3.00,174.00,'2021-12-17 07:45:11','',''),(2302223,'1','148','769',327,'Retail Sale Id 1350144',4047.12,0.00,0.00,6.57,381.06,'2021-12-17 07:49:57','',''),(2302243,'1','148','769',327,'Retail Sale Id 1350162',3400.32,0.00,0.00,5.52,320.16,'2021-12-17 07:51:46','',''),(2302248,'1','148','769',327,'Retail Sale Id 1350168',3498.88,0.00,0.00,5.68,329.44,'2021-12-17 07:52:23','',''),(2302268,'1','148','769',327,'Retail Sale Id 1350190',15400.00,0.00,0.00,25.00,1450.00,'2021-12-17 07:54:35','',''),(2302301,'1','148','769',327,'Retail Sale Id 1350221',2002.00,0.00,0.00,3.25,188.50,'2021-12-17 07:57:50','',''),(2302314,'1','148','769',327,'Retail Sale Id 1350233',3997.84,0.00,0.00,6.49,376.42,'2021-12-17 07:59:10','',''),(2302411,'1','148','769',327,'Retail Sale Id 1350310',7700.00,0.00,0.00,12.50,725.00,'2021-12-17 08:06:41','',''),(2302418,'1','148','769',327,'Retail Sale Id 1350315',2002.00,0.00,0.00,3.25,188.50,'2021-12-17 08:07:24','',''),(2302427,'1','148','769',327,'Retail Sale Id 1350323',3702.16,0.00,0.00,6.01,348.58,'2021-12-17 08:08:43','',''),(2302478,'1','148','769',327,'Retail Sale Id 1350369',2002.00,0.00,0.00,3.25,188.50,'2021-12-17 08:15:06','',''),(2302488,'1','148','769',327,'Retail Sale Id 1350385',2002.00,0.00,0.00,3.25,188.50,'2021-12-17 08:16:07','',''),(2302512,'1','148','769',327,'Retail Sale Id 1350409',7700.00,0.00,0.00,12.50,725.00,'2021-12-17 08:18:10','',''),(2302521,'1','148','769',327,'Retail Sale Id 1350425',2002.00,0.00,0.00,3.25,188.50,'2021-12-17 08:19:05','',''),(2302571,'1','148','769',327,'Retail Sale Id 1350468',3098.48,0.00,0.00,5.03,291.74,'2021-12-17 08:23:01','',''),(2302604,'1','148','769',327,'Retail Sale Id 1350504',7700.00,0.00,0.00,12.50,725.00,'2021-12-17 08:26:10','',''),(2302643,'1','148','769',327,'Retail Sale Id 1350511',5999.84,0.00,0.00,9.74,564.92,'2021-12-17 08:27:05','',''),(2302881,'1','148','769',327,'Retail Sale Id 1350696',3098.48,0.00,0.00,5.03,291.74,'2021-12-17 08:48:28','',''),(2303001,'1','148','769',327,'Retail Sale Id 1350783',89676.00,0.00,0.00,159.00,954.00,'2021-12-17 08:57:57','',''),(2303049,'1','148','769',327,'Retail Sale Id 1350808',2002.00,0.00,0.00,3.25,188.50,'2021-12-17 09:01:06','',''),(2303087,'1','148','769',327,'Retail Sale Id 1350845',2002.00,0.00,0.00,3.25,188.50,'2021-12-17 09:05:10','',''),(2303319,'1','148','769',327,'Retail Sale Id 1350988',5001.92,0.00,0.00,8.12,470.96,'2021-12-17 09:23:28','',''),(2303323,'1','148','769',327,'Retail Sale Id 1350992',3899.28,0.00,0.00,6.33,367.14,'2021-12-17 09:24:09','',''),(2303342,'1','148','769',327,'Retail Sale Id 1351010',94188.00,0.00,0.00,167.00,1002.00,'2021-12-17 09:26:15','',''),(2303371,'1','148','769',327,'Retail Sale Id 1351026',6498.80,0.00,0.00,10.55,611.90,'2021-12-17 09:28:04','',''),(2303391,'1','148','769',327,'Retail Sale Id 1351049',1503.04,0.00,0.00,2.44,141.52,'2021-12-17 09:30:44','',''),(2303413,'1','148','769',327,'Retail Sale Id 1351062',2002.00,0.00,0.00,3.25,188.50,'2021-12-17 09:32:14','',''),(2303470,'1','148','769',327,'Retail Sale Id 1351101',3997.84,0.00,0.00,6.49,376.42,'2021-12-17 09:35:19','',''),(2303729,'1','148','769',327,'Retail Sale Id 1351303',5001.92,0.00,0.00,8.12,470.96,'2021-12-17 09:59:07','',''),(2303810,'1','148','769',327,'Retail Sale Id 1351419',997.92,0.00,0.00,1.62,93.96,'2021-12-17 10:08:42','',''),(2303898,'1','148','769',327,'Retail Sale Id 1351498',924.00,0.00,0.00,1.50,87.00,'2021-12-17 10:17:44','',''),(2304025,'1','148','769',327,'Retail Sale Id 1351614',2999.92,0.00,0.00,4.87,282.46,'2021-12-17 10:33:00','',''),(2304059,'1','148','769',327,'Retail Sale Id 1351635',1848.00,0.00,0.00,3.00,174.00,'2021-12-17 10:35:59','',''),(2304076,'1','148','769',327,'Retail Sale Id 1351656',3702.16,0.00,0.00,6.01,348.58,'2021-12-17 10:38:09','',''),(2304095,'1','148','769',327,'Retail Sale Id 1351676',5001.92,0.00,0.00,8.12,470.96,'2021-12-17 10:40:27','',''),(2304108,'1','148','769',327,'Retail Sale Id 1351688',2999.92,0.00,0.00,4.87,282.46,'2021-12-17 10:42:08','',''),(2304215,'1','148','769',327,'Retail Sale Id 1351800',3702.16,0.00,0.00,6.01,348.58,'2021-12-17 10:56:02','',''),(2304239,'1','148','769',327,'Retail Sale Id 1351823',24640.00,0.00,0.00,40.00,2320.00,'2021-12-17 10:59:03','',''),(2304254,'1','148','769',327,'Retail Sale Id 1351836',3997.84,0.00,0.00,6.49,376.42,'2021-12-17 11:00:09','',''),(2304264,'1','148','769',327,'Retail Sale Id 1351843',3997.84,0.00,0.00,6.49,376.42,'2021-12-17 11:01:22','',''),(2304303,'1','148','769',327,'Retail Sale Id 1351877',1250.48,0.00,0.00,2.03,117.74,'2021-12-17 11:04:35','',''),(2304322,'1','148','769',327,'Retail Sale Id 1351894',7700.00,0.00,0.00,12.50,725.00,'2021-12-17 11:05:56','',''),(2304328,'1','148','769',327,'Retail Sale Id 1351901',3098.48,0.00,0.00,5.03,291.74,'2021-12-17 11:06:52','',''),(2304333,'1','148','769',327,'Retail Sale Id 1351906',997.92,0.00,0.00,1.62,93.96,'2021-12-17 11:07:30','',''),(2304345,'1','148','769',327,'Retail Sale Id 1351918',2500.96,0.00,0.00,4.06,235.48,'2021-12-17 11:09:12','',''),(2304379,'1','148','769',327,'Retail Sale Id 1351953',3702.16,0.00,0.00,6.01,348.58,'2021-12-17 11:12:31','',''),(2304466,'1','148','769',327,'Retail Sale Id 1352015',1250.48,0.00,0.00,2.03,117.74,'2021-12-17 11:18:52','',''),(2304481,'1','148','769',327,'Retail Sale Id 1352031',61476.00,0.00,0.00,109.00,654.00,'2021-12-17 11:20:14','',''),(2304490,'1','148','769',327,'Retail Sale Id 1352038',90240.00,0.00,0.00,160.00,960.00,'2021-12-17 11:20:58','',''),(2304518,'1','148','769',327,'Retail Sale Id 1352063',2002.00,0.00,0.00,3.25,188.50,'2021-12-17 11:23:30','',''),(2304532,'1','148','769',327,'Retail Sale Id 1352075',5001.92,0.00,0.00,8.12,470.96,'2021-12-17 11:24:31','',''),(2304560,'1','148','769',327,'Retail Sale Id 1352100',997.92,0.00,0.00,1.62,93.96,'2021-12-17 11:26:54','',''),(2304575,'1','148','769',327,'Retail Sale Id 1352116',997.92,0.00,0.00,1.62,93.96,'2021-12-17 11:28:08','',''),(2304582,'1','148','769',327,'Retail Sale Id 1352124',7700.00,0.00,0.00,12.50,725.00,'2021-12-17 11:28:54','',''),(2304598,'1','148','769',327,'Retail Sale Id 1352140',1897.28,0.00,0.00,3.08,178.64,'2021-12-17 11:30:27','',''),(2304604,'1','148','769',327,'Retail Sale Id 1352148',3702.16,0.00,0.00,6.01,348.58,'2021-12-17 11:31:21','',''),(2304616,'1','148','769',327,'Retail Sale Id 1352160',7700.00,0.00,0.00,12.50,725.00,'2021-12-17 11:32:23','',''),(2304631,'1','148','769',327,'Retail Sale Id 1352175',2698.08,0.00,0.00,4.38,254.04,'2021-12-17 11:33:53','',''),(2304740,'1','148','769',327,'Retail Sale Id 1352298',7700.00,0.00,0.00,12.50,725.00,'2021-12-17 11:47:32','',''),(2304755,'1','148','769',327,'Retail Sale Id 1352309',2002.00,0.00,0.00,3.25,188.50,'2021-12-17 11:49:13','',''),(2304836,'1','148','769',327,'Retail Sale Id 1352366',2999.92,0.00,0.00,4.87,282.46,'2021-12-17 11:58:42','',''),(2304842,'1','148','769',327,'Retail Sale Id 1352373',2002.00,0.00,0.00,3.25,188.50,'2021-12-17 11:59:52','',''),(2304886,'1','148','769',327,'Retail Sale Id 1352407',2999.92,0.00,0.00,4.87,282.46,'2021-12-17 12:04:18','',''),(2304932,'1','148','769',327,'Retail Sale Id 1352447',2999.92,0.00,0.00,4.87,282.46,'2021-12-17 12:10:22','',''),(2309274,'1','148','769',327,'Retail Sale Id 1355679',316587.04,0.00,0.00,513.94,29808.52,'2021-12-18 06:44:46','',''),(2309288,'1','148','769',327,'Retail Sale Id 1355696',307763.52,0.00,0.00,545.68,3274.08,'2021-12-18 06:46:52','',''),(2312326,'1','148','769',327,'Retail Sale Id 1358212',7700.00,0.00,0.00,12.50,725.00,'2021-12-18 10:56:00','',''),(2312406,'1','148','769',327,'Retail Sale Id 1358280',6997.76,0.00,0.00,11.36,658.88,'2021-12-18 11:02:56','',''),(2312415,'1','148','769',327,'Retail Sale Id 1358288',3702.16,0.00,0.00,6.01,348.58,'2021-12-18 11:03:43','',''),(2312433,'1','148','769',327,'Retail Sale Id 1358301',3702.16,0.00,0.00,6.01,348.58,'2021-12-18 11:04:59','',''),(2312481,'1','148','769',327,'Retail Sale Id 1358341',5001.92,0.00,0.00,8.12,470.96,'2021-12-18 11:08:10','',''),(2312591,'1','148','769',327,'Retail Sale Id 1358421',3098.48,0.00,0.00,5.03,291.74,'2021-12-18 11:15:21','',''),(2312656,'1','148','769',327,'Retail Sale Id 1358469',3997.84,0.00,0.00,6.49,376.42,'2021-12-18 11:20:15','',''),(2312689,'1','148','769',327,'Retail Sale Id 1358501',3997.84,0.00,0.00,6.49,376.42,'2021-12-18 11:22:58','',''),(2312703,'1','148','769',327,'Retail Sale Id 1358517',3702.16,0.00,0.00,6.01,348.58,'2021-12-18 11:23:51','',''),(2312738,'1','148','769',327,'Retail Sale Id 1358551',2999.92,0.00,0.00,4.87,282.46,'2021-12-18 11:26:46','',''),(2312925,'1','148','769',327,'Retail Sale Id 1358735',997.92,0.00,0.00,1.62,93.96,'2021-12-18 11:42:56','',''),(2313312,'1','148','769',327,'Retail Sale Id 1359103',3098.48,0.00,0.00,5.03,291.74,'2021-12-18 12:26:06','',''),(2313360,'1','148','769',327,'Retail Sale Id 1359150',2002.00,0.00,0.00,3.25,188.50,'2021-12-18 12:31:57','',''),(2313515,'1','148','769',327,'Retail Sale Id 1359284',7700.00,0.00,0.00,12.50,725.00,'2021-12-18 12:45:20','',''),(2314114,'1','148','769',327,'Retail Sale Id 1359797',8001.84,0.00,0.00,12.99,753.42,'2021-12-18 13:41:46','',''),(2314178,'1','148','769',327,'Retail Sale Id 1359853',7700.00,0.00,0.00,12.50,725.00,'2021-12-18 13:46:17','',''),(2315599,'1','148','769',327,'Retail Sale Id 1361023',149460.00,0.00,0.00,265.00,1590.00,'2021-12-18 15:36:25','',''),(2315641,'1','148','769',327,'Retail Sale Id 1361070',61600.00,0.00,0.00,100.00,5800.00,'2021-12-18 15:39:28','',''),(2316009,'1','148','769',327,'Retail Sale Id 1361338',7700.00,0.00,0.00,12.50,725.00,'2021-12-18 16:00:02','',''),(2316568,'1','148','769',327,'Retail Sale Id 1361882',7700.00,0.00,0.00,12.50,725.00,'2021-12-18 16:40:55','',''),(2317893,'1','148','769',327,'Retail Sale Id 1362798',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 06:10:29','',''),(2317923,'1','148','769',327,'Retail Sale Id 1362823',108594.64,0.00,0.00,176.29,10224.82,'2021-12-19 06:19:09','',''),(2317941,'1','148','769',327,'Retail Sale Id 1362834',12475.68,0.00,0.00,22.12,132.72,'2021-12-19 06:21:40','',''),(2318020,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,2957400.00,5300.00,0.00,0.00,'2021-12-19 06:27:43','',''),(2318039,'1','148',NULL,327,'Reception corrector for bridging 127923',0.00,0.00,0.00,5300.00,0.00,'2021-12-19 06:28:53','',''),(2318040,'1','148','769',327,'Received from bridging 127923',0.00,0.00,5300.00,0.00,0.00,'2021-12-19 06:28:53','',''),(2318046,'1','148','769',327,'Retail Sale Id 1362855',354175.36,0.00,0.00,574.96,33347.68,'2021-12-19 06:30:02','',''),(2318055,'1','148','769',327,'Retail Sale Id 1362864',780000.72,0.00,0.00,1382.98,8297.88,'2021-12-19 06:33:31','',''),(2318465,'1','148','769',327,'Retail Sale Id 1363229',817800.00,0.00,0.00,1450.00,8700.00,'2021-12-19 07:17:40','',''),(2318477,'1','148','769',327,'Retail Sale Id 1363240',1503.04,0.00,0.00,2.44,141.52,'2021-12-19 07:18:32','',''),(2318485,'1','148','769',327,'Retail Sale Id 1363249',30800.00,0.00,0.00,50.00,2900.00,'2021-12-19 07:19:11','',''),(2318492,'1','148','769',327,'Retail Sale Id 1363254',6997.76,0.00,0.00,11.36,658.88,'2021-12-19 07:19:53','',''),(2318508,'1','148','769',327,'Retail Sale Id 1363274',3702.16,0.00,0.00,6.01,348.58,'2021-12-19 07:21:26','',''),(2318523,'1','148','769',327,'Retail Sale Id 1363292',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 07:23:17','',''),(2318611,'1','148','769',327,'Retail Sale Id 1363376',8001.84,0.00,0.00,12.99,753.42,'2021-12-19 07:30:24','',''),(2318619,'1','148','769',327,'Retail Sale Id 1363383',7601.44,0.00,0.00,12.34,715.72,'2021-12-19 07:31:02','',''),(2318635,'1','148','769',327,'Retail Sale Id 1363404',3702.16,0.00,0.00,6.01,348.58,'2021-12-19 07:32:41','',''),(2318642,'1','148','769',327,'Retail Sale Id 1363412',5999.84,0.00,0.00,9.74,564.92,'2021-12-19 07:33:12','',''),(2318654,'1','148','769',327,'Retail Sale Id 1363418',3098.48,0.00,0.00,5.03,291.74,'2021-12-19 07:34:09','',''),(2318685,'1','148','769',327,'Retail Sale Id 1363457',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 07:37:34','',''),(2318725,'1','148','769',327,'Retail Sale Id 1363484',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 07:40:34','',''),(2318734,'1','148','769',327,'Retail Sale Id 1363494',1848.00,0.00,0.00,3.00,174.00,'2021-12-19 07:41:16','',''),(2318914,'1','148','769',327,'Retail Sale Id 1363615',3498.88,0.00,0.00,5.68,329.44,'2021-12-19 07:54:15','',''),(2319020,'1','148','769',327,'Retail Sale Id 1363696',3702.16,0.00,0.00,6.01,348.58,'2021-12-19 08:03:28','',''),(2319140,'1','148','769',327,'Retail Sale Id 1363808',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 08:16:57','',''),(2319534,'1','148','769',327,'Retail Sale Id 1364080',30800.00,0.00,0.00,50.00,2900.00,'2021-12-19 08:43:19','',''),(2319542,'1','148','769',327,'Retail Sale Id 1364088',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 08:43:59','',''),(2319637,'1','148','769',327,'Retail Sale Id 1364165',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 08:54:32','',''),(2320470,'1','148','769',327,'Retail Sale Id 1364780',149460.00,0.00,0.00,265.00,1590.00,'2021-12-19 09:55:02','',''),(2320586,'1','148','769',327,'Retail Sale Id 1364901',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 10:04:46','',''),(2321473,'1','148','769',327,'Retail Sale Id 1365763',7700.00,0.00,0.00,12.50,725.00,'2021-12-19 11:15:58','',''),(2324208,'1','148','769',327,'Retail Sale Id 1368215',113928.00,0.00,0.00,202.00,1212.00,'2021-12-19 15:09:31','',''),(2324215,'1','148','769',327,'Retail Sale Id 1368224',107160.00,0.00,0.00,190.00,1140.00,'2021-12-19 15:10:18','',''),(2326127,'1','148','769',327,'Retail Sale Id 1369573',319574.64,0.00,0.00,518.79,30089.82,'2021-12-20 05:55:43','',''),(2326131,'1','148','769',327,'Retail Sale Id 1369575',235148.52,0.00,0.00,416.93,2501.58,'2021-12-20 06:00:42','',''),(2326143,'1','148','769',327,'Distributed to OPERATIONAL LOSS for sales id:340908',53289.00,0.00,0.00,95.50,0.00,'2021-12-20 06:07:20','',''),(2326196,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,1674000.00,3000.00,0.00,0.00,'2021-12-20 06:14:16','',''),(2326200,'1','148',NULL,327,'Reception corrector for bridging 128027',0.00,0.00,0.00,3000.00,0.00,'2021-12-20 06:15:35','',''),(2326201,'1','148','769',327,'Received from bridging 128027',0.00,0.00,3000.00,0.00,0.00,'2021-12-20 06:15:35','',''),(2326209,'1','148','769',327,'Retail Sale Id 1369605',155761.76,0.00,0.00,252.86,14665.88,'2021-12-20 06:17:05','',''),(2326214,'1','148','769',327,'Retail Sale Id 1369609',56896.32,0.00,0.00,100.88,605.28,'2021-12-20 06:19:22','',''),(2326223,'1','148','769',327,'Retail Sale Id 1369617',34034.00,0.00,0.00,55.25,3204.50,'2021-12-20 06:21:22','',''),(2326788,'1','148','769',327,'Retail Sale Id 1370037',2002.00,0.00,0.00,3.25,188.50,'2021-12-20 07:33:38','',''),(2332538,'1','148','769',327,'Retail Sale Id 1374706',228900.00,0.00,0.00,350.00,33600.00,'2021-12-20 17:27:40','',''),(2332551,'1','148','769',327,'Retail Sale Id 1374717',205860.00,0.00,0.00,365.00,2190.00,'2021-12-20 17:29:34','',''),(2332555,'1','148','769',327,'Retail Sale Id 1374722',75012.00,0.00,0.00,133.00,798.00,'2021-12-20 17:30:34','',''),(2332562,'1','148','769',327,'Retail Sale Id 1374726',67680.00,0.00,0.00,120.00,720.00,'2021-12-20 17:31:25','',''),(2332567,'1','148','769',327,'Retail Sale Id 1374731',75576.00,0.00,0.00,134.00,804.00,'2021-12-20 17:32:16','',''),(2332574,'1','148','769',327,'Retail Sale Id 1374737',30800.00,0.00,0.00,50.00,2900.00,'2021-12-20 17:33:22','',''),(2332578,'1','148','769',327,'Retail Sale Id 1374741',7398.16,0.00,0.00,12.01,696.58,'2021-12-20 17:33:56','',''),(2332583,'1','148','769',327,'Retail Sale Id 1374746',7700.00,0.00,0.00,12.50,725.00,'2021-12-20 17:34:44','',''),(2332586,'1','148','769',327,'Retail Sale Id 1374747',15400.00,0.00,0.00,25.00,1450.00,'2021-12-20 17:35:10','',''),(2332589,'1','148','769',327,'Retail Sale Id 1374750',7798.56,0.00,0.00,12.66,734.28,'2021-12-20 17:35:51','',''),(2332592,'1','148','769',327,'Retail Sale Id 1374755',3702.16,0.00,0.00,6.01,348.58,'2021-12-20 17:36:19','',''),(2332595,'1','148','769',327,'Retail Sale Id 1374756',11402.16,0.00,0.00,18.51,1073.58,'2021-12-20 17:37:05','',''),(2332611,'1','148','769',327,'Retail Sale Id 1374766',3098.48,0.00,0.00,5.03,291.74,'2021-12-20 17:39:06','',''),(2332615,'1','148','769',327,'Retail Sale Id 1374770',3997.84,0.00,0.00,6.49,376.42,'2021-12-20 17:39:49','',''),(2332621,'1','148','769',327,'Retail Sale Id 1374774',30800.00,0.00,0.00,50.00,2900.00,'2021-12-20 17:40:26','',''),(2332624,'1','148','769',327,'Retail Sale Id 1374778',15400.00,0.00,0.00,25.00,1450.00,'2021-12-20 17:40:57','',''),(2332629,'1','148','769',327,'Retail Sale Id 1374781',2999.92,0.00,0.00,4.87,282.46,'2021-12-20 17:41:39','',''),(2332632,'1','148','769',327,'Retail Sale Id 1374783',3702.16,0.00,0.00,6.01,348.58,'2021-12-20 17:42:31','',''),(2332645,'1','148','769',327,'Retail Sale Id 1374792',2999.92,0.00,0.00,4.87,282.46,'2021-12-20 17:44:00','',''),(2334690,'1','148','769',327,'Retail Sale Id 1376107',530542.32,0.00,0.00,861.27,49953.66,'2021-12-21 08:47:29','',''),(2334703,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,1244340.00,2230.00,0.00,0.00,'2021-12-21 08:49:09','',''),(2334723,'1','148',NULL,327,'Reception corrector for bridging 128171',0.00,0.00,0.00,2230.00,0.00,'2021-12-21 08:50:09','',''),(2334724,'1','148','769',327,'Received from bridging 128171',0.00,0.00,2230.00,0.00,0.00,'2021-12-21 08:50:09','',''),(2334751,'1','148','769',327,'Retail Sale Id 1376136',392921.88,0.00,0.00,696.67,4180.02,'2021-12-21 08:52:10','',''),(2334765,'1','148','769',327,'Return of Retail Sale Id 1374706',0.00,228900.00,350.00,0.00,-33600.00,'2021-12-21 08:54:36','',''),(2334769,'1','148','769',327,'Return of Retail Sale Id 1374717',0.00,205860.00,365.00,0.00,-2190.00,'2021-12-21 08:55:10','',''),(2334775,'1','148','769',327,'Return of Retail Sale Id 1374731',0.00,75576.00,134.00,0.00,-804.00,'2021-12-21 08:55:38','',''),(2334779,'1','148','769',327,'Return of Retail Sale Id 1374726',0.00,67680.00,120.00,0.00,-720.00,'2021-12-21 08:56:12','',''),(2334788,'1','148','769',327,'Retail Sale Id 1376168',546516.00,0.00,0.00,969.00,5814.00,'2021-12-21 08:57:45','',''),(2335657,'1','148','769',327,'Retail Sale Id 1376900',7400.00,0.00,0.00,12.50,0.00,'2021-12-21 10:34:07','',''),(2335809,'1','148','769',327,'Retail Sale Id 1376992',7400.00,0.00,0.00,12.50,0.00,'2021-12-21 10:47:24','',''),(2335827,'1','148','769',327,'Retail Sale Id 1377010',3599.36,0.00,0.00,6.08,0.00,'2021-12-21 10:49:14','',''),(2336277,'1','148','769',327,'Retail Sale Id 1377392',200160.00,0.00,0.00,360.00,-12960.00,'2021-12-21 11:37:44','',''),(2336329,'1','148','769',327,'Retail Sale Id 1377440',7400.00,0.00,0.00,12.50,0.00,'2021-12-21 11:44:06','',''),(2336385,'1','148','769',327,'Retail Sale Id 1377489',3599.36,0.00,0.00,6.08,0.00,'2021-12-21 11:52:11','',''),(2336520,'1','148','769',327,'Retail Sale Id 1377595',3599.36,0.00,0.00,6.08,0.00,'2021-12-21 12:06:23','',''),(2336765,'1','148','769',327,'Retail Sale Id 1377814',7400.00,0.00,0.00,12.50,0.00,'2021-12-21 12:36:01','',''),(2341084,'1','148','769',327,'Retail Sale Id 1381130',334604.32,0.00,0.00,565.21,0.00,'2021-12-22 05:54:33','',''),(2341121,'1','148','769',327,'Return of Retail Sale Id 1377595',0.00,3599.36,6.08,0.00,0.00,'2021-12-22 05:59:26','',''),(2341134,'1','148','769',327,'Return of Retail Sale Id 1376900',0.00,7400.00,12.50,0.00,0.00,'2021-12-22 06:02:40','',''),(2341140,'1','148','769',327,'Return of Retail Sale Id 1377814',0.00,7400.00,12.50,0.00,0.00,'2021-12-22 06:04:55','',''),(2341143,'1','148','769',327,'Return of Retail Sale Id 1381130',0.00,334604.32,565.21,0.00,0.00,'2021-12-22 06:05:16','',''),(2341145,'1','148','769',327,'Return of Retail Sale Id 1376992',0.00,7400.00,12.50,0.00,0.00,'2021-12-22 06:05:39','',''),(2341148,'1','148','769',327,'Return of Retail Sale Id 1377010',0.00,3599.36,6.08,0.00,0.00,'2021-12-22 06:06:17','',''),(2341149,'1','148','769',327,'Return of Retail Sale Id 1377440',0.00,7400.00,12.50,0.00,0.00,'2021-12-22 06:06:38','',''),(2341150,'1','148','769',327,'Return of Retail Sale Id 1377489',0.00,3599.36,6.08,0.00,0.00,'2021-12-22 06:07:06','',''),(2341159,'1','148','769',327,'Return of Retail Sale Id 1377392',0.00,200160.00,360.00,0.00,12960.00,'2021-12-22 06:08:19','',''),(2341163,'1','148','769',327,'Retail Sale Id 1381181',367602.40,0.00,0.00,620.95,0.00,'2021-12-22 06:09:11','',''),(2341183,'1','148','769',327,'Retail Sale Id 1381201',742260.00,0.00,0.00,1335.00,-48060.00,'2021-12-22 06:12:25','',''),(2341288,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,3445440.00,5820.00,0.00,0.00,'2021-12-22 06:29:24','',''),(2341315,'1','148',NULL,327,'Reception corrector for bridging 128285',0.00,0.00,0.00,5820.00,0.00,'2021-12-22 06:30:51','',''),(2341316,'1','148','769',327,'Received from bridging 128285',0.00,0.00,5820.00,0.00,0.00,'2021-12-22 06:30:51','',''),(2341333,'1','148','769',327,'Retail Sale Id 1381290',349978.56,0.00,0.00,591.18,0.00,'2021-12-22 06:32:39','',''),(2341364,'1','148','769',327,'Retail Sale Id 1381317',480456.28,0.00,0.00,864.13,-31108.68,'2021-12-22 06:36:50','',''),(2341527,'1','148','769',327,'Retail Sale Id 1381434',88960.00,0.00,0.00,160.00,-5760.00,'2021-12-22 06:50:41','',''),(2341530,'1','148','769',327,'Retail Sale Id 1381438',7400.00,0.00,0.00,12.50,0.00,'2021-12-22 06:51:17','',''),(2341538,'1','148','769',327,'Retail Sale Id 1381446',3599.36,0.00,0.00,6.08,0.00,'2021-12-22 06:51:55','',''),(2341553,'1','148','769',327,'Retail Sale Id 1381451',799.20,0.00,0.00,1.35,0.00,'2021-12-22 06:52:28','',''),(2341557,'1','148','769',327,'Retail Sale Id 1381456',3001.44,0.00,0.00,5.07,0.00,'2021-12-22 06:53:10','',''),(2341567,'1','148','769',327,'Retail Sale Id 1381466',899.84,0.00,0.00,1.52,0.00,'2021-12-22 06:53:50','',''),(2341575,'1','148','769',327,'Retail Sale Id 1381473',6002.88,0.00,0.00,10.14,0.00,'2021-12-22 06:54:38','',''),(2341635,'1','148','769',327,'Retail Sale Id 1381531',7400.00,0.00,0.00,12.50,0.00,'2021-12-22 07:00:06','',''),(2341661,'1','148','769',327,'Retail Sale Id 1381560',2000.96,0.00,0.00,3.38,0.00,'2021-12-22 07:02:45','',''),(2341673,'1','148','769',327,'Retail Sale Id 1381570',4001.92,0.00,0.00,6.76,0.00,'2021-12-22 07:03:50','',''),(2341684,'1','148','769',327,'Retail Sale Id 1381578',1799.68,0.00,0.00,3.04,0.00,'2021-12-22 07:04:46','',''),(2341695,'1','148','769',327,'Retail Sale Id 1381591',1497.76,0.00,0.00,2.53,0.00,'2021-12-22 07:05:44','',''),(2341699,'1','148','769',327,'Retail Sale Id 1381595',6002.88,0.00,0.00,10.14,0.00,'2021-12-22 07:06:24','',''),(2341710,'1','148','769',327,'Retail Sale Id 1381604',2498.24,0.00,0.00,4.22,0.00,'2021-12-22 07:07:02','',''),(2341716,'1','148','769',327,'Retail Sale Id 1381611',3599.36,0.00,0.00,6.08,0.00,'2021-12-22 07:08:01','',''),(2341735,'1','148','769',327,'Retail Sale Id 1381632',3599.36,0.00,0.00,6.08,0.00,'2021-12-22 07:09:36','',''),(2341792,'1','148','769',327,'Retail Sale Id 1381677',5002.40,0.00,0.00,8.45,0.00,'2021-12-22 07:13:16','',''),(2341802,'1','148','769',327,'Retail Sale Id 1381685',3001.44,0.00,0.00,5.07,0.00,'2021-12-22 07:13:56','',''),(2341813,'1','148','769',327,'Retail Sale Id 1381693',3498.72,0.00,0.00,5.91,0.00,'2021-12-22 07:14:33','',''),(2341854,'1','148','769',327,'Retail Sale Id 1381720',7400.00,0.00,0.00,12.50,0.00,'2021-12-22 07:18:33','',''),(2342130,'1','148','769',327,'Retail Sale Id 1381952',3001.44,0.00,0.00,5.07,0.00,'2021-12-22 07:42:13','',''),(2342160,'1','148','769',327,'Retail Sale Id 1381965',7400.00,0.00,0.00,12.50,0.00,'2021-12-22 07:43:13','',''),(2342176,'1','148','769',327,'Retail Sale Id 1381980',3001.44,0.00,0.00,5.07,0.00,'2021-12-22 07:44:24','',''),(2342222,'1','148','769',327,'Retail Sale Id 1382015',7400.00,0.00,0.00,12.50,0.00,'2021-12-22 07:47:14','',''),(2342287,'1','148','769',327,'Retail Sale Id 1382053',3599.36,0.00,0.00,6.08,0.00,'2021-12-22 07:50:02','',''),(2342296,'1','148','769',327,'Retail Sale Id 1382064',3001.44,0.00,0.00,5.07,0.00,'2021-12-22 07:50:54','',''),(2342309,'1','148','769',327,'Retail Sale Id 1382078',3599.36,0.00,0.00,6.08,0.00,'2021-12-22 07:51:55','',''),(2342330,'1','148','769',327,'Retail Sale Id 1382096',4001.92,0.00,0.00,6.76,0.00,'2021-12-22 07:53:24','',''),(2342344,'1','148','769',327,'Retail Sale Id 1382113',2000.96,0.00,0.00,3.38,0.00,'2021-12-22 07:54:45','',''),(2342371,'1','148','769',327,'Retail Sale Id 1382125',1799.68,0.00,0.00,3.04,0.00,'2021-12-22 07:55:25','',''),(2342390,'1','148','769',327,'Retail Sale Id 1382145',2498.24,0.00,0.00,4.22,0.00,'2021-12-22 07:56:53','',''),(2342752,'1','148','769',327,'Retail Sale Id 1382448',3599.36,0.00,0.00,6.08,0.00,'2021-12-22 08:21:45','',''),(2342762,'1','148','769',327,'Retail Sale Id 1382459',3001.44,0.00,0.00,5.07,0.00,'2021-12-22 08:22:40','',''),(2342782,'1','148','769',327,'Retail Sale Id 1382472',7400.00,0.00,0.00,12.50,0.00,'2021-12-22 08:24:03','',''),(2342794,'1','148','769',327,'Retail Sale Id 1382480',7400.00,0.00,0.00,12.50,0.00,'2021-12-22 08:24:44','',''),(2342823,'1','148','769',327,'Retail Sale Id 1382510',35999.52,0.00,0.00,60.81,0.00,'2021-12-22 08:26:35','',''),(2342899,'1','148','769',327,'Retail Sale Id 1382549',2699.52,0.00,0.00,4.56,0.00,'2021-12-22 08:29:05','',''),(2343127,'1','148','769',327,'Retail Sale Id 1382736',150120.00,0.00,0.00,270.00,-9720.00,'2021-12-22 08:47:11','',''),(2343164,'1','148','769',327,'Retail Sale Id 1382773',7400.00,0.00,0.00,12.50,0.00,'2021-12-22 08:51:28','',''),(2343639,'1','148','769',327,'Retail Sale Id 1383251',132328.00,0.00,0.00,238.00,-8568.00,'2021-12-22 09:34:42','',''),(2343796,'1','148','769',327,'Retail Sale Id 1383372',3001.44,0.00,0.00,5.07,0.00,'2021-12-22 09:48:19','',''),(2343809,'1','148','769',327,'Retail Sale Id 1383383',2000.96,0.00,0.00,3.38,0.00,'2021-12-22 09:49:26','',''),(2343820,'1','148','769',327,'Retail Sale Id 1383393',1799.68,0.00,0.00,3.04,0.00,'2021-12-22 09:50:27','',''),(2343949,'1','148','769',327,'Retail Sale Id 1383510',7400.00,0.00,0.00,12.50,0.00,'2021-12-22 09:59:33','',''),(2344045,'1','148','769',327,'Retail Sale Id 1383609',3599.36,0.00,0.00,6.08,0.00,'2021-12-22 10:09:12','',''),(2344055,'1','148','769',327,'Retail Sale Id 1383625',4001.92,0.00,0.00,6.76,0.00,'2021-12-22 10:10:23','',''),(2344094,'1','148','769',327,'Retail Sale Id 1383657',1799.68,0.00,0.00,3.04,0.00,'2021-12-22 10:13:34','',''),(2344114,'1','148','769',327,'Retail Sale Id 1383669',3599.36,0.00,0.00,6.08,0.00,'2021-12-22 10:14:57','',''),(2344124,'1','148','769',327,'Retail Sale Id 1383678',7400.00,0.00,0.00,12.50,0.00,'2021-12-22 10:16:02','',''),(2344280,'1','148','769',327,'Retail Sale Id 1383840',2000.96,0.00,0.00,3.38,0.00,'2021-12-22 10:32:37','',''),(2344355,'1','148','769',327,'Retail Sale Id 1383902',7400.00,0.00,0.00,12.50,0.00,'2021-12-22 10:40:52','',''),(2344492,'1','148','769',327,'Retail Sale Id 1384051',6002.88,0.00,0.00,10.14,0.00,'2021-12-22 10:53:28','',''),(2345117,'1','148','769',327,'Retail Sale Id 1384650',2000.96,0.00,0.00,3.38,0.00,'2021-12-22 11:54:17','',''),(2345158,'1','148','769',327,'Retail Sale Id 1384691',7400.00,0.00,0.00,12.50,0.00,'2021-12-22 11:58:20','',''),(2345187,'1','148','769',327,'Retail Sale Id 1384719',92852.00,0.00,0.00,167.00,-6012.00,'2021-12-22 12:01:25','',''),(2345690,'1','148','769',327,'Retail Sale Id 1385155',14800.00,0.00,0.00,25.00,0.00,'2021-12-22 12:53:54','',''),(2345820,'1','148','769',327,'Retail Sale Id 1385267',1799.68,0.00,0.00,3.04,0.00,'2021-12-22 13:07:51','',''),(2345838,'1','148','769',327,'Retail Sale Id 1385285',3001.44,0.00,0.00,5.07,0.00,'2021-12-22 13:09:33','',''),(2345849,'1','148','769',327,'Retail Sale Id 1385296',899.84,0.00,0.00,1.52,0.00,'2021-12-22 13:10:33','',''),(2345869,'1','148','769',327,'Retail Sale Id 1385315',3001.44,0.00,0.00,5.07,0.00,'2021-12-22 13:12:53','',''),(2346739,'1','148','769',327,'Retail Sale Id 1385921',7400.00,0.00,0.00,12.50,0.00,'2021-12-22 14:30:13','',''),(2348101,'1','148','769',327,'Retail Sale Id 1386991',7400.00,0.00,0.00,12.50,0.00,'2021-12-22 16:29:54','',''),(2348153,'1','148','769',327,'Retail Sale Id 1387049',38920.00,0.00,0.00,70.00,-2520.00,'2021-12-22 16:36:21','',''),(2348160,'1','148','769',327,'Retail Sale Id 1387057',33360.00,0.00,0.00,60.00,-2160.00,'2021-12-22 16:37:04','',''),(2348171,'1','148','769',327,'Retail Sale Id 1387066',29600.00,0.00,0.00,50.00,0.00,'2021-12-22 16:38:14','',''),(2348187,'1','148','769',327,'Retail Sale Id 1387081',14800.00,0.00,0.00,25.00,0.00,'2021-12-22 16:40:31','',''),(2348202,'1','148','769',327,'Retail Sale Id 1387096',111200.00,0.00,0.00,200.00,-7200.00,'2021-12-22 16:41:55','',''),(2348228,'1','148','769',327,'Retail Sale Id 1387123',3599.36,0.00,0.00,6.08,0.00,'2021-12-22 16:44:57','',''),(2348246,'1','148','769',327,'Retail Sale Id 1387130',6002.88,0.00,0.00,10.14,0.00,'2021-12-22 16:46:10','',''),(2348392,'1','148','769',327,'Retail Sale Id 1387278',7400.00,0.00,0.00,12.50,0.00,'2021-12-22 17:00:25','',''),(2348483,'1','148','769',327,'Retail Sale Id 1387364',1000.48,0.00,0.00,1.69,0.00,'2021-12-22 17:10:00','',''),(2348503,'1','148','769',327,'Retail Sale Id 1387383',6997.44,0.00,0.00,11.82,0.00,'2021-12-22 17:11:56','',''),(2348538,'1','148','769',327,'Retail Sale Id 1387410',7400.00,0.00,0.00,12.50,0.00,'2021-12-22 17:16:26','',''),(2349661,'1','148','769',327,'Retail Sale Id 1387926',7400.00,0.00,0.00,12.50,0.00,'2021-12-23 06:30:20','',''),(2349670,'1','148','769',327,'Retail Sale Id 1387938',1799.68,0.00,0.00,3.04,0.00,'2021-12-23 06:31:54','',''),(2349677,'1','148','769',327,'Retail Sale Id 1387942',3001.44,0.00,0.00,5.07,0.00,'2021-12-23 06:32:52','',''),(2349701,'1','148','769',327,'Retail Sale Id 1387955',7400.00,0.00,0.00,12.50,0.00,'2021-12-23 06:36:08','',''),(2350646,'1','148','769',327,'Retail Sale Id 1388624',345130.08,0.00,0.00,582.99,0.00,'2021-12-23 07:52:44','',''),(2350658,'1','148','769',327,'Retail Sale Id 1388641',600146.40,0.00,0.00,1079.40,-38858.40,'2021-12-23 07:54:23','',''),(2350757,'1','148','769',327,'Retail Sale Id 1388739',83400.00,0.00,0.00,150.00,-5400.00,'2021-12-23 08:05:14','',''),(2350797,'1','148','769',327,'Retail Sale Id 1388783',5002.40,0.00,0.00,8.45,0.00,'2021-12-23 08:09:43','',''),(2350888,'1','148','769',327,'Retail Sale Id 1388844',7400.00,0.00,0.00,12.50,0.00,'2021-12-23 08:16:50','',''),(2350895,'1','148','769',327,'Retail Sale Id 1388852',14800.00,0.00,0.00,25.00,0.00,'2021-12-23 08:17:54','',''),(2350951,'1','148','769',327,'Retail Sale Id 1388900',6002.88,0.00,0.00,10.14,0.00,'2021-12-23 08:22:58','',''),(2351001,'1','148','769',327,'Retail Sale Id 1388952',3599.36,0.00,0.00,6.08,0.00,'2021-12-23 08:27:37','',''),(2351018,'1','148','769',327,'Retail Sale Id 1388969',1000.48,0.00,0.00,1.69,0.00,'2021-12-23 08:29:50','',''),(2351033,'1','148','769',327,'Retail Sale Id 1388979',2498.24,0.00,0.00,4.22,0.00,'2021-12-23 08:30:41','',''),(2351070,'1','148','769',327,'Retail Sale Id 1389024',7400.00,0.00,0.00,12.50,0.00,'2021-12-23 08:35:15','',''),(2351078,'1','148','769',327,'Retail Sale Id 1389032',2000.96,0.00,0.00,3.38,0.00,'2021-12-23 08:36:06','',''),(2351109,'1','148','769',327,'Retail Sale Id 1389039',3498.72,0.00,0.00,5.91,0.00,'2021-12-23 08:36:52','',''),(2351379,'1','148','769',327,'Retail Sale Id 1389301',3001.44,0.00,0.00,5.07,0.00,'2021-12-23 09:04:22','',''),(2351385,'1','148','769',327,'Retail Sale Id 1389309',3599.36,0.00,0.00,6.08,0.00,'2021-12-23 09:05:12','',''),(2351488,'1','148','769',327,'Retail Sale Id 1389415',4001.92,0.00,0.00,6.76,0.00,'2021-12-23 09:16:41','',''),(2351623,'1','148','769',327,'Retail Sale Id 1389532',3001.44,0.00,0.00,5.07,0.00,'2021-12-23 09:28:16','',''),(2351650,'1','148','769',327,'Retail Sale Id 1389547',2000.96,0.00,0.00,3.38,0.00,'2021-12-23 09:30:15','',''),(2351662,'1','148','769',327,'Retail Sale Id 1389556',3599.36,0.00,0.00,6.08,0.00,'2021-12-23 09:31:07','',''),(2351678,'1','148','769',327,'Retail Sale Id 1389572',7400.00,0.00,0.00,12.50,0.00,'2021-12-23 09:32:17','',''),(2351687,'1','148','769',327,'Retail Sale Id 1389582',3848.00,0.00,0.00,6.50,0.00,'2021-12-23 09:33:04','',''),(2351703,'1','148','769',327,'Retail Sale Id 1389598',2000.96,0.00,0.00,3.38,0.00,'2021-12-23 09:34:06','',''),(2351716,'1','148','769',327,'Retail Sale Id 1389612',2699.52,0.00,0.00,4.56,0.00,'2021-12-23 09:35:16','',''),(2351729,'1','148','769',327,'Retail Sale Id 1389626',4001.92,0.00,0.00,6.76,0.00,'2021-12-23 09:36:15','',''),(2351761,'1','148','769',327,'Retail Sale Id 1389652',2800.16,0.00,0.00,4.73,0.00,'2021-12-23 09:37:51','',''),(2351783,'1','148','769',327,'Retail Sale Id 1389664',1799.68,0.00,0.00,3.04,0.00,'2021-12-23 09:38:47','',''),(2351813,'1','148','769',327,'Retail Sale Id 1389688',3599.36,0.00,0.00,6.08,0.00,'2021-12-23 09:40:31','',''),(2351839,'1','148','769',327,'Retail Sale Id 1389711',88960.00,0.00,0.00,160.00,-5760.00,'2021-12-23 09:42:13','',''),(2351853,'1','148','769',327,'Retail Sale Id 1389719',3001.44,0.00,0.00,5.07,0.00,'2021-12-23 09:42:42','',''),(2351867,'1','148','769',327,'Retail Sale Id 1389734',3599.36,0.00,0.00,6.08,0.00,'2021-12-23 09:44:00','',''),(2351890,'1','148','769',327,'Retail Sale Id 1389759',7400.00,0.00,0.00,12.50,0.00,'2021-12-23 09:46:12','',''),(2351901,'1','148','769',327,'Retail Sale Id 1389769',3001.44,0.00,0.00,5.07,0.00,'2021-12-23 09:47:12','',''),(2351917,'1','148','769',327,'Retail Sale Id 1389783',1000.48,0.00,0.00,1.69,0.00,'2021-12-23 09:48:11','',''),(2351931,'1','148','769',327,'Retail Sale Id 1389790',4499.20,0.00,0.00,7.60,0.00,'2021-12-23 09:49:06','',''),(2351954,'1','148','769',327,'Retail Sale Id 1389812',6002.88,0.00,0.00,10.14,0.00,'2021-12-23 09:51:16','',''),(2351960,'1','148','769',327,'Retail Sale Id 1389818',29600.00,0.00,0.00,50.00,0.00,'2021-12-23 09:51:54','',''),(2352057,'1','148','769',327,'Retail Sale Id 1389891',2498.24,0.00,0.00,4.22,0.00,'2021-12-23 09:57:44','',''),(2352152,'1','148','769',327,'Retail Sale Id 1389915',3599.36,0.00,0.00,6.08,0.00,'2021-12-23 10:00:21','',''),(2352231,'1','148','769',327,'Retail Sale Id 1389980',4001.92,0.00,0.00,6.76,0.00,'2021-12-23 10:06:00','',''),(2352238,'1','148','769',327,'Retail Sale Id 1389990',3599.36,0.00,0.00,6.08,0.00,'2021-12-23 10:06:44','',''),(2352243,'1','148','769',327,'Retail Sale Id 1389994',23680.00,0.00,0.00,40.00,0.00,'2021-12-23 10:07:27','',''),(2352277,'1','148','769',327,'Retail Sale Id 1390031',7400.00,0.00,0.00,12.50,0.00,'2021-12-23 10:11:02','',''),(2352368,'1','148','769',327,'Retail Sale Id 1390111',3001.44,0.00,0.00,5.07,0.00,'2021-12-23 10:19:16','',''),(2352381,'1','148','769',327,'Retail Sale Id 1390121',1799.68,0.00,0.00,3.04,0.00,'2021-12-23 10:20:15','',''),(2354613,'1','148','769',327,'Retail Sale Id 1392221',7400.00,0.00,0.00,12.50,0.00,'2021-12-23 13:43:15','',''),(2355440,'1','148','769',327,'Retail Sale Id 1392775',2498.24,0.00,0.00,4.22,0.00,'2021-12-23 14:39:41','',''),(2355454,'1','148','769',327,'Retail Sale Id 1392789',3599.36,0.00,0.00,6.08,0.00,'2021-12-23 14:41:28','',''),(2355478,'1','148','769',327,'Retail Sale Id 1392816',3599.36,0.00,0.00,6.08,0.00,'2021-12-23 14:44:50','',''),(2355488,'1','148','769',327,'Retail Sale Id 1392828',7400.00,0.00,0.00,12.50,0.00,'2021-12-23 14:46:06','',''),(2355500,'1','148','769',327,'Retail Sale Id 1392838',1799.68,0.00,0.00,3.04,0.00,'2021-12-23 14:47:01','',''),(2355518,'1','148','769',327,'Retail Sale Id 1392847',3498.72,0.00,0.00,5.91,0.00,'2021-12-23 14:47:54','',''),(2355545,'1','148','769',327,'Retail Sale Id 1392868',2000.96,0.00,0.00,3.38,0.00,'2021-12-23 14:49:35','',''),(2355628,'1','148','769',327,'Retail Sale Id 1392957',6399.52,0.00,0.00,10.81,0.00,'2021-12-23 14:59:34','',''),(2355637,'1','148','769',327,'Retail Sale Id 1392968',3001.44,0.00,0.00,5.07,0.00,'2021-12-23 15:00:17','',''),(2355644,'1','148','769',327,'Retail Sale Id 1392974',5002.40,0.00,0.00,8.45,0.00,'2021-12-23 15:01:13','',''),(2355650,'1','148','769',327,'Retail Sale Id 1392980',3599.36,0.00,0.00,6.08,0.00,'2021-12-23 15:01:57','',''),(2355661,'1','148','769',327,'Retail Sale Id 1392994',3001.44,0.00,0.00,5.07,0.00,'2021-12-23 15:03:00','',''),(2355667,'1','148','769',327,'Retail Sale Id 1393001',1497.76,0.00,0.00,2.53,0.00,'2021-12-23 15:03:42','',''),(2355686,'1','148','769',327,'Retail Sale Id 1393019',1497.76,0.00,0.00,2.53,0.00,'2021-12-23 15:05:20','',''),(2356081,'1','148','769',327,'Retail Sale Id 1393373',3599.36,0.00,0.00,6.08,0.00,'2021-12-23 15:38:57','',''),(2356673,'1','148','769',327,'Retail Sale Id 1393960',3001.44,0.00,0.00,5.07,0.00,'2021-12-23 16:29:40','',''),(2356680,'1','148','769',327,'Retail Sale Id 1393969',7400.00,0.00,0.00,12.50,0.00,'2021-12-23 16:30:35','',''),(2356691,'1','148','769',327,'Retail Sale Id 1393980',5002.40,0.00,0.00,8.45,0.00,'2021-12-23 16:31:28','',''),(2356715,'1','148','769',327,'Retail Sale Id 1393995',7997.92,0.00,0.00,13.51,0.00,'2021-12-23 16:33:52','',''),(2357205,'1','148','769',327,'Retail Sale Id 1394439',7400.00,0.00,0.00,12.50,0.00,'2021-12-23 17:18:49','',''),(2357653,'1','148','769',327,'Return of Retail Sale Id 1389818',0.00,29600.00,50.00,0.00,0.00,'2021-12-23 18:20:02','',''),(2357658,'1','148','769',327,'Return of Retail Sale Id 1390031',0.00,7400.00,12.50,0.00,0.00,'2021-12-23 18:20:38','',''),(2357661,'1','148','769',327,'Return of Retail Sale Id 1389572',0.00,7400.00,12.50,0.00,0.00,'2021-12-23 18:21:37','',''),(2357666,'1','148','769',327,'Return of Retail Sale Id 1393969',0.00,7400.00,12.50,0.00,0.00,'2021-12-23 18:22:27','',''),(2357675,'1','148','769',327,'Retail Sale Id 1394798',19914.88,0.00,0.00,33.64,0.00,'2021-12-23 18:24:09','',''),(2357689,'1','148','769',327,'Retail Sale Id 1394806',65596.88,0.00,0.00,117.98,-4247.28,'2021-12-23 18:26:04','',''),(2357707,'1','148','769',327,'Return of Retail Sale Id 1393980',0.00,5002.40,8.45,0.00,0.00,'2021-12-23 18:29:27','',''),(2357710,'1','148','769',327,'Retail Sale Id 1394823',4191.36,0.00,0.00,7.08,0.00,'2021-12-23 18:30:04','',''),(2357721,'1','148','769',327,'Retail Sale Id 1394829',520.96,0.00,0.00,0.88,0.00,'2021-12-23 18:31:38','',''),(2357887,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,2756520.00,4940.00,0.00,0.00,'2021-12-23 19:04:41','',''),(2357890,'1','148',NULL,327,'Reception corrector for bridging 128554',0.00,0.00,0.00,4940.00,0.00,'2021-12-23 19:06:00','',''),(2357891,'1','148','769',327,'Received from bridging 128554',0.00,0.00,4940.00,0.00,0.00,'2021-12-23 19:06:00','',''),(2358825,'1','148','769',327,'Retail Sale Id 1395327',29600.00,0.00,0.00,50.00,1700.00,'2021-12-24 06:59:32','',''),(2358840,'1','148','769',327,'Retail Sale Id 1395345',83400.00,0.00,0.00,150.00,-300.00,'2021-12-24 07:00:48','',''),(2358894,'1','148','769',327,'Retail Sale Id 1395393',1799.68,0.00,0.00,3.04,103.36,'2021-12-24 07:05:28','',''),(2358907,'1','148','769',327,'Retail Sale Id 1395406',3599.36,0.00,0.00,6.08,206.72,'2021-12-24 07:06:35','',''),(2358916,'1','148','769',327,'Retail Sale Id 1395413',7400.00,0.00,0.00,12.50,425.00,'2021-12-24 07:07:37','',''),(2358925,'1','148','769',327,'Retail Sale Id 1395423',1497.76,0.00,0.00,2.53,86.02,'2021-12-24 07:08:42','',''),(2358960,'1','148','769',327,'Retail Sale Id 1395452',3599.36,0.00,0.00,6.08,206.72,'2021-12-24 07:11:28','',''),(2359104,'1','148','769',327,'Retail Sale Id 1395568',5002.40,0.00,0.00,8.45,287.30,'2021-12-24 07:23:01','',''),(2359228,'1','148','769',327,'Retail Sale Id 1395681',31136.00,0.00,0.00,56.00,-112.00,'2021-12-24 07:34:33','',''),(2359263,'1','148','769',327,'Retail Sale Id 1395720',3599.36,0.00,0.00,6.08,206.72,'2021-12-24 07:37:44','',''),(2359306,'1','148','769',327,'Retail Sale Id 1395762',7400.00,0.00,0.00,12.50,425.00,'2021-12-24 07:42:30','',''),(2359369,'1','148','769',327,'Retail Sale Id 1395829',276292.32,0.00,0.00,466.71,15868.14,'2021-12-24 07:48:05','',''),(2359396,'1','148','769',327,'Retail Sale Id 1395851',210262.52,0.00,0.00,378.17,-756.34,'2021-12-24 07:49:47','',''),(2359453,'1','148','769',327,'Retail Sale Id 1395906',33360.00,0.00,0.00,60.00,-120.00,'2021-12-24 07:54:15','',''),(2359464,'1','148','769',327,'Retail Sale Id 1395917',44480.00,0.00,0.00,80.00,-160.00,'2021-12-24 07:55:15','',''),(2359510,'1','148','769',327,'Retail Sale Id 1395947',2000.96,0.00,0.00,3.38,114.92,'2021-12-24 07:58:10','',''),(2359522,'1','148','769',327,'Retail Sale Id 1395958',3599.36,0.00,0.00,6.08,206.72,'2021-12-24 07:58:47','',''),(2359535,'1','148','769',327,'Retail Sale Id 1395971',3001.44,0.00,0.00,5.07,172.38,'2021-12-24 08:00:16','',''),(2359553,'1','148','769',327,'Retail Sale Id 1395990',3001.44,0.00,0.00,5.07,172.38,'2021-12-24 08:01:39','',''),(2359558,'1','148','769',327,'Retail Sale Id 1395997',2000.96,0.00,0.00,3.38,114.92,'2021-12-24 08:02:17','',''),(2359580,'1','148','769',327,'Retail Sale Id 1396006',7400.00,0.00,0.00,12.50,425.00,'2021-12-24 08:03:10','',''),(2359610,'1','148','769',327,'Retail Sale Id 1396033',3599.36,0.00,0.00,6.08,206.72,'2021-12-24 08:05:18','',''),(2359622,'1','148','769',327,'Retail Sale Id 1396041',3498.72,0.00,0.00,5.91,200.94,'2021-12-24 08:06:05','',''),(2359634,'1','148','769',327,'Retail Sale Id 1396054',3001.44,0.00,0.00,5.07,172.38,'2021-12-24 08:07:09','',''),(2359698,'1','148','769',327,'Retail Sale Id 1396100',92852.00,0.00,0.00,167.00,-334.00,'2021-12-24 08:11:47','',''),(2359787,'1','148','769',327,'Retail Sale Id 1396144',3001.44,0.00,0.00,5.07,172.38,'2021-12-24 08:16:20','',''),(2359795,'1','148','769',327,'Retail Sale Id 1396151',7400.00,0.00,0.00,12.50,425.00,'2021-12-24 08:16:59','',''),(2359805,'1','148','769',327,'Retail Sale Id 1396160',7400.00,0.00,0.00,12.50,425.00,'2021-12-24 08:17:32','',''),(2359813,'1','148','769',327,'Retail Sale Id 1396170',6997.44,0.00,0.00,11.82,401.88,'2021-12-24 08:18:25','',''),(2359841,'1','148','769',327,'Retail Sale Id 1396197',4001.92,0.00,0.00,6.76,229.84,'2021-12-24 08:21:37','',''),(2359852,'1','148','769',327,'Retail Sale Id 1396209',3599.36,0.00,0.00,6.08,206.72,'2021-12-24 08:22:52','',''),(2359862,'1','148','769',327,'Retail Sale Id 1396224',1699.04,0.00,0.00,2.87,97.58,'2021-12-24 08:24:02','',''),(2359869,'1','148','769',327,'Retail Sale Id 1396227',3599.36,0.00,0.00,6.08,206.72,'2021-12-24 08:24:39','',''),(2359909,'1','148','769',327,'Retail Sale Id 1396271',1497.76,0.00,0.00,2.53,86.02,'2021-12-24 08:28:11','',''),(2359918,'1','148','769',327,'Retail Sale Id 1396279',2000.96,0.00,0.00,3.38,114.92,'2021-12-24 08:28:47','',''),(2359932,'1','148','769',327,'Retail Sale Id 1396293',7400.00,0.00,0.00,12.50,425.00,'2021-12-24 08:30:01','',''),(2359941,'1','148','769',327,'Retail Sale Id 1396303',3599.36,0.00,0.00,6.08,206.72,'2021-12-24 08:30:43','',''),(2359986,'1','148','769',327,'Retail Sale Id 1396313',6997.44,0.00,0.00,11.82,401.88,'2021-12-24 08:31:46','',''),(2359996,'1','148','769',327,'Retail Sale Id 1396324',2000.96,0.00,0.00,3.38,114.92,'2021-12-24 08:32:24','',''),(2360036,'1','148','769',327,'Retail Sale Id 1396367',7400.00,0.00,0.00,12.50,425.00,'2021-12-24 08:36:27','',''),(2360071,'1','148','769',327,'Retail Sale Id 1396391',3599.36,0.00,0.00,6.08,206.72,'2021-12-24 08:38:17','',''),(2360095,'1','148','769',327,'Retail Sale Id 1396413',698.56,0.00,0.00,1.18,40.12,'2021-12-24 08:40:17','',''),(2360109,'1','148','769',327,'Retail Sale Id 1396430',7400.00,0.00,0.00,12.50,425.00,'2021-12-24 08:41:16','',''),(2360133,'1','148','769',327,'Retail Sale Id 1396457',1900.32,0.00,0.00,3.21,109.14,'2021-12-24 08:43:26','',''),(2360148,'1','148','769',327,'Retail Sale Id 1396474',1799.68,0.00,0.00,3.04,103.36,'2021-12-24 08:44:45','',''),(2360159,'1','148','769',327,'Retail Sale Id 1396485',2397.60,0.00,0.00,4.05,137.70,'2021-12-24 08:45:57','',''),(2360172,'1','148','769',327,'Retail Sale Id 1396501',3001.44,0.00,0.00,5.07,172.38,'2021-12-24 08:46:56','',''),(2360266,'1','148','769',327,'Retail Sale Id 1396599',6997.44,0.00,0.00,11.82,401.88,'2021-12-24 08:53:39','',''),(2360302,'1','148','769',327,'Retail Sale Id 1396618',14800.00,0.00,0.00,25.00,850.00,'2021-12-24 08:54:47','',''),(2360332,'1','148','769',327,'Retail Sale Id 1396646',3001.44,0.00,0.00,5.07,172.38,'2021-12-24 08:56:59','',''),(2360345,'1','148','769',327,'Retail Sale Id 1396656',6002.88,0.00,0.00,10.14,344.76,'2021-12-24 08:57:54','',''),(2360356,'1','148','769',327,'Retail Sale Id 1396670',3599.36,0.00,0.00,6.08,206.72,'2021-12-24 08:58:45','',''),(2360417,'1','148','769',327,'Retail Sale Id 1396717',7400.00,0.00,0.00,12.50,425.00,'2021-12-24 09:02:04','',''),(2362876,'1','148','769',327,'Retail Sale Id 1398994',147340.00,0.00,0.00,265.00,-530.00,'2021-12-24 12:24:45','',''),(2363855,'1','148','769',327,'Retail Sale Id 1399832',25000.16,0.00,0.00,42.23,1435.82,'2021-12-24 13:51:20','',''),(2364188,'1','148','769',327,'Retail Sale Id 1400116',168468.00,0.00,0.00,303.00,-606.00,'2021-12-24 14:14:35','',''),(2364413,'1','148','769',327,'Retail Sale Id 1400307',7400.00,0.00,0.00,12.50,425.00,'2021-12-24 14:32:21','',''),(2365974,'1','148','769',327,'Retail Sale Id 1401536',150120.00,0.00,0.00,270.00,-540.00,'2021-12-24 16:23:02','',''),(2365981,'1','148','769',327,'Retail Sale Id 1401543',44400.00,0.00,0.00,75.00,2550.00,'2021-12-24 16:23:33','',''),(2365988,'1','148','769',327,'Retail Sale Id 1401548',29600.00,0.00,0.00,50.00,1700.00,'2021-12-24 16:24:06','',''),(2365999,'1','148','769',327,'Retail Sale Id 1401561',122320.00,0.00,0.00,220.00,-440.00,'2021-12-24 16:24:58','',''),(2366009,'1','148','769',327,'Retail Sale Id 1401569',7400.00,0.00,0.00,12.50,425.00,'2021-12-24 16:25:36','',''),(2366017,'1','148','769',327,'Retail Sale Id 1401580',18352.00,0.00,0.00,31.00,1054.00,'2021-12-24 16:26:21','',''),(2368457,'1','148','769',327,'Retail Sale Id 1403347',7400.00,0.00,0.00,12.50,425.00,'2021-12-25 06:59:42','',''),(2370062,'1','148','769',327,'Retail Sale Id 1404800',7400.00,0.00,0.00,12.50,425.00,'2021-12-25 09:13:49','',''),(2371259,'1','148','769',327,'Retail Sale Id 1405912',7400.00,0.00,0.00,12.50,425.00,'2021-12-25 11:08:36','',''),(2371425,'1','148','769',327,'Retail Sale Id 1406114',7400.00,0.00,0.00,12.50,425.00,'2021-12-25 11:26:23','',''),(2371882,'1','148','769',327,'Retail Sale Id 1406590',373552.00,0.00,0.00,631.00,21454.00,'2021-12-25 12:20:10','',''),(2371905,'1','148','769',327,'Retail Sale Id 1406613',580491.80,0.00,0.00,1044.05,-2088.10,'2021-12-25 12:22:55','',''),(2371919,'1','148','769',327,'Retail Sale Id 1406626',97822.08,0.00,0.00,165.24,5618.16,'2021-12-25 12:24:39','',''),(2372000,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,2778840.00,4980.00,0.00,0.00,'2021-12-25 12:33:49','',''),(2372008,'1','148',NULL,327,'Reception corrector for bridging 128724',0.00,0.00,0.00,4980.00,0.00,'2021-12-25 12:34:52','',''),(2372009,'1','148','769',327,'Received from bridging 128724',0.00,0.00,4980.00,0.00,0.00,'2021-12-25 12:34:52','',''),(2372688,'1','148','769',327,'Retail Sale Id 1407213',202940.00,0.00,0.00,365.00,-730.00,'2021-12-25 13:38:47','',''),(2372702,'1','148','769',327,'Retail Sale Id 1407222',88960.00,0.00,0.00,160.00,-320.00,'2021-12-25 13:40:02','',''),(2372743,'1','148','769',327,'Retail Sale Id 1407248',3599.36,0.00,0.00,6.08,206.72,'2021-12-25 13:44:21','',''),(2372746,'1','148','769',327,'Retail Sale Id 1407251',2397.60,0.00,0.00,4.05,137.70,'2021-12-25 13:44:47','',''),(2372751,'1','148','769',327,'Retail Sale Id 1407258',3599.36,0.00,0.00,6.08,206.72,'2021-12-25 13:45:34','',''),(2372808,'1','148','769',327,'Retail Sale Id 1407275',44400.00,0.00,0.00,75.00,2550.00,'2021-12-25 13:49:13','',''),(2372833,'1','148','769',327,'Retail Sale Id 1407278',1397.12,0.00,0.00,2.36,80.24,'2021-12-25 13:50:00','',''),(2372851,'1','148','769',327,'Retail Sale Id 1407286',1799.68,0.00,0.00,3.04,103.36,'2021-12-25 13:51:13','',''),(2372858,'1','148','769',327,'Retail Sale Id 1407295',2000.96,0.00,0.00,3.38,114.92,'2021-12-25 13:51:59','',''),(2372888,'1','148','769',327,'Retail Sale Id 1407306',2000.96,0.00,0.00,3.38,114.92,'2021-12-25 13:53:27','',''),(2373018,'1','148','769',327,'Retail Sale Id 1407397',14800.00,0.00,0.00,25.00,850.00,'2021-12-25 14:08:01','',''),(2373024,'1','148','769',327,'Retail Sale Id 1407401',10952.00,0.00,0.00,18.50,629.00,'2021-12-25 14:08:27','',''),(2373037,'1','148','769',327,'Retail Sale Id 1407405',7400.00,0.00,0.00,12.50,425.00,'2021-12-25 14:08:53','',''),(2373042,'1','148','769',327,'Retail Sale Id 1407406',13000.32,0.00,0.00,21.96,746.64,'2021-12-25 14:09:23','',''),(2373049,'1','148','769',327,'Retail Sale Id 1407410',145116.00,0.00,0.00,261.00,-522.00,'2021-12-25 14:09:55','',''),(2373071,'1','148','769',327,'Retail Sale Id 1407416',6002.88,0.00,0.00,10.14,344.76,'2021-12-25 14:11:29','',''),(2373076,'1','148','769',327,'Retail Sale Id 1407419',2498.24,0.00,0.00,4.22,143.48,'2021-12-25 14:12:10','',''),(2373096,'1','148','769',327,'Retail Sale Id 1407425',3599.36,0.00,0.00,6.08,206.72,'2021-12-25 14:13:21','',''),(2373106,'1','148','769',327,'Retail Sale Id 1407433',2498.24,0.00,0.00,4.22,143.48,'2021-12-25 14:14:29','',''),(2373111,'1','148','769',327,'Retail Sale Id 1407439',1201.76,0.00,0.00,2.03,69.02,'2021-12-25 14:15:38','',''),(2373116,'1','148','769',327,'Retail Sale Id 1407443',7400.00,0.00,0.00,12.50,425.00,'2021-12-25 14:16:28','',''),(2373127,'1','148','769',327,'Retail Sale Id 1407450',3599.36,0.00,0.00,6.08,206.72,'2021-12-25 14:18:00','',''),(2373146,'1','148','769',327,'Retail Sale Id 1407465',66720.00,0.00,0.00,120.00,-240.00,'2021-12-25 14:19:37','',''),(2373267,'1','148','769',327,'Retail Sale Id 1407543',1497.76,0.00,0.00,2.53,86.02,'2021-12-25 14:33:13','',''),(2373271,'1','148','769',327,'Retail Sale Id 1407547',2800.16,0.00,0.00,4.73,160.82,'2021-12-25 14:34:01','',''),(2373275,'1','148','769',327,'Retail Sale Id 1407552',2000.96,0.00,0.00,3.38,114.92,'2021-12-25 14:34:42','',''),(2373279,'1','148','769',327,'Retail Sale Id 1407556',1799.68,0.00,0.00,3.04,103.36,'2021-12-25 14:35:29','',''),(2373288,'1','148','769',327,'Retail Sale Id 1407560',6002.88,0.00,0.00,10.14,344.76,'2021-12-25 14:37:02','',''),(2373339,'1','148','769',327,'Retail Sale Id 1407614',1799.68,0.00,0.00,3.04,103.36,'2021-12-25 14:46:24','',''),(2373348,'1','148','769',327,'Retail Sale Id 1407622',22200.00,0.00,0.00,37.50,1275.00,'2021-12-25 14:47:27','',''),(2373353,'1','148','769',327,'Retail Sale Id 1407628',147340.00,0.00,0.00,265.00,-530.00,'2021-12-25 14:48:08','',''),(2373356,'1','148','769',327,'Retail Sale Id 1407632',6997.44,0.00,0.00,11.82,401.88,'2021-12-25 14:48:42','',''),(2373362,'1','148','769',327,'Retail Sale Id 1407637',7400.00,0.00,0.00,12.50,425.00,'2021-12-25 14:49:43','',''),(2373365,'1','148','769',327,'Retail Sale Id 1407640',8998.40,0.00,0.00,15.20,516.80,'2021-12-25 14:50:20','',''),(2373377,'1','148','769',327,'Retail Sale Id 1407651',3599.36,0.00,0.00,6.08,206.72,'2021-12-25 14:52:23','',''),(2373414,'1','148','769',327,'Retail Sale Id 1407690',2000.96,0.00,0.00,3.38,114.92,'2021-12-25 15:00:03','',''),(2373420,'1','148','769',327,'Retail Sale Id 1407696',3001.44,0.00,0.00,5.07,172.38,'2021-12-25 15:01:27','',''),(2373682,'1','148','769',327,'Retail Sale Id 1407906',7400.00,0.00,0.00,12.50,425.00,'2021-12-25 15:46:42','',''),(2373965,'1','148','769',327,'Retail Sale Id 1408114',161240.00,0.00,0.00,290.00,-580.00,'2021-12-25 16:19:10','',''),(2373974,'1','148','769',327,'Retail Sale Id 1408124',29600.00,0.00,0.00,50.00,1700.00,'2021-12-25 16:20:08','',''),(2373992,'1','148','769',327,'Retail Sale Id 1408130',7400.00,0.00,0.00,12.50,425.00,'2021-12-25 16:24:17','',''),(2373999,'1','148','769',327,'Retail Sale Id 1408149',10999.36,0.00,0.00,18.58,631.72,'2021-12-25 16:25:14','',''),(2374000,'1','148','769',327,'Retail Sale Id 1408151',7400.00,0.00,0.00,12.50,425.00,'2021-12-25 16:25:40','',''),(2376135,'1','148','769',327,'Retail Sale Id 1409432',7400.00,0.00,0.00,12.50,425.00,'2021-12-26 09:04:44','',''),(2377624,'1','148','769',327,'Retail Sale Id 1410704',946378.72,0.00,0.00,1702.12,-3404.24,'2021-12-26 11:58:03','',''),(2377650,'1','148','769',327,'Retail Sale Id 1410723',571250.40,0.00,0.00,964.95,32808.30,'2021-12-26 12:00:52','',''),(2378638,'1','148','769',327,'Retail Sale Id 1411497',29600.00,0.00,0.00,50.00,1700.00,'2021-12-26 14:05:11','',''),(2378642,'1','148','769',327,'Retail Sale Id 1411501',3001.44,0.00,0.00,5.07,172.38,'2021-12-26 14:05:42','',''),(2378645,'1','148','769',327,'Retail Sale Id 1411503',2101.60,0.00,0.00,3.55,120.70,'2021-12-26 14:07:04','',''),(2378670,'1','148','769',327,'Retail Sale Id 1411517',17760.00,0.00,0.00,30.00,1020.00,'2021-12-26 14:09:19','',''),(2378673,'1','148','769',327,'Retail Sale Id 1411519',4001.92,0.00,0.00,6.76,229.84,'2021-12-26 14:10:02','',''),(2378679,'1','148','769',327,'Retail Sale Id 1411526',2498.24,0.00,0.00,4.22,143.48,'2021-12-26 14:11:09','',''),(2378682,'1','148','769',327,'Retail Sale Id 1411529',2000.96,0.00,0.00,3.38,114.92,'2021-12-26 14:11:49','',''),(2378686,'1','148','769',327,'Retail Sale Id 1411531',3001.44,0.00,0.00,5.07,172.38,'2021-12-26 14:12:38','',''),(2378693,'1','148','769',327,'Retail Sale Id 1411535',44400.00,0.00,0.00,75.00,2550.00,'2021-12-26 14:13:16','',''),(2378713,'1','148','769',327,'Retail Sale Id 1411552',7400.00,0.00,0.00,12.50,425.00,'2021-12-26 14:18:13','',''),(2378738,'1','148','769',327,'Retail Sale Id 1411562',799.20,0.00,0.00,1.35,45.90,'2021-12-26 14:20:06','',''),(2378748,'1','148','769',327,'Retail Sale Id 1411572',3599.36,0.00,0.00,6.08,206.72,'2021-12-26 14:21:18','',''),(2379085,'1','148','769',327,'Retail Sale Id 1411782',7400.00,0.00,0.00,12.50,425.00,'2021-12-26 14:57:16','',''),(2379119,'1','148','769',327,'Retail Sale Id 1411801',3001.44,0.00,0.00,5.07,172.38,'2021-12-26 14:59:31','',''),(2379161,'1','148','769',327,'Retail Sale Id 1411814',3599.36,0.00,0.00,6.08,206.72,'2021-12-26 15:01:12','',''),(2379483,'1','148','769',327,'Retail Sale Id 1412038',5002.40,0.00,0.00,8.45,287.30,'2021-12-26 15:41:55','',''),(2379487,'1','148','769',327,'Retail Sale Id 1412043',1598.40,0.00,0.00,2.70,91.80,'2021-12-26 15:42:31','',''),(2379492,'1','148','769',327,'Retail Sale Id 1412047',1799.68,0.00,0.00,3.04,103.36,'2021-12-26 15:43:08','',''),(2379496,'1','148','769',327,'Retail Sale Id 1412051',2000.96,0.00,0.00,3.38,114.92,'2021-12-26 15:43:47','',''),(2379503,'1','148','769',327,'Retail Sale Id 1412059',1799.68,0.00,0.00,3.04,103.36,'2021-12-26 15:44:22','',''),(2379520,'1','148','769',327,'Retail Sale Id 1412077',3498.72,0.00,0.00,5.91,200.94,'2021-12-26 15:47:37','',''),(2379529,'1','148','769',327,'Retail Sale Id 1412087',3599.36,0.00,0.00,6.08,206.72,'2021-12-26 15:48:44','',''),(2379539,'1','148','769',327,'Retail Sale Id 1412095',3498.72,0.00,0.00,5.91,200.94,'2021-12-26 15:50:24','',''),(2379541,'1','148','769',327,'Retail Sale Id 1412100',1201.76,0.00,0.00,2.03,69.02,'2021-12-26 15:51:09','',''),(2379556,'1','148','769',327,'Retail Sale Id 1412112',1497.76,0.00,0.00,2.53,86.02,'2021-12-26 15:52:58','',''),(2379563,'1','148','769',327,'Retail Sale Id 1412116',3800.64,0.00,0.00,6.42,218.28,'2021-12-26 15:53:42','',''),(2379587,'1','148','769',327,'Retail Sale Id 1412141',597.92,0.00,0.00,1.01,34.34,'2021-12-26 15:58:36','',''),(2379594,'1','148','769',327,'Retail Sale Id 1412149',1799.68,0.00,0.00,3.04,103.36,'2021-12-26 15:59:39','',''),(2379599,'1','148','769',327,'Retail Sale Id 1412155',2498.24,0.00,0.00,4.22,143.48,'2021-12-26 16:00:42','',''),(2379605,'1','148','769',327,'Retail Sale Id 1412162',3498.72,0.00,0.00,5.91,200.94,'2021-12-26 16:01:16','',''),(2379611,'1','148','769',327,'Retail Sale Id 1412166',698.56,0.00,0.00,1.18,40.12,'2021-12-26 16:01:52','',''),(2379624,'1','148','769',327,'Retail Sale Id 1412181',7400.00,0.00,0.00,12.50,425.00,'2021-12-26 16:03:12','',''),(2379629,'1','148','769',327,'Retail Sale Id 1412188',3599.36,0.00,0.00,6.08,206.72,'2021-12-26 16:03:56','',''),(2379635,'1','148','769',327,'Retail Sale Id 1412198',1799.68,0.00,0.00,3.04,103.36,'2021-12-26 16:04:47','',''),(2379644,'1','148','769',327,'Retail Sale Id 1412207',1497.76,0.00,0.00,2.53,86.02,'2021-12-26 16:05:27','',''),(2379649,'1','148','769',327,'Retail Sale Id 1412212',1497.76,0.00,0.00,2.53,86.02,'2021-12-26 16:06:16','',''),(2379656,'1','148','769',327,'Retail Sale Id 1412220',8880.00,0.00,0.00,15.00,510.00,'2021-12-26 16:08:19','',''),(2379675,'1','148','769',327,'Retail Sale Id 1412238',3001.44,0.00,0.00,5.07,172.38,'2021-12-26 16:12:01','',''),(2379682,'1','148','769',327,'Retail Sale Id 1412247',3001.44,0.00,0.00,5.07,172.38,'2021-12-26 16:12:52','',''),(2379705,'1','148','769',327,'Retail Sale Id 1412267',1000.48,0.00,0.00,1.69,57.46,'2021-12-26 16:17:00','',''),(2379709,'1','148','769',327,'Retail Sale Id 1412271',3001.44,0.00,0.00,5.07,172.38,'2021-12-26 16:18:01','',''),(2379715,'1','148','769',327,'Retail Sale Id 1412279',7400.00,0.00,0.00,12.50,425.00,'2021-12-26 16:18:34','',''),(2379727,'1','148','769',327,'Retail Sale Id 1412290',1799.68,0.00,0.00,3.04,103.36,'2021-12-26 16:20:10','',''),(2379730,'1','148','769',327,'Retail Sale Id 1412293',3599.36,0.00,0.00,6.08,206.72,'2021-12-26 16:20:43','',''),(2379732,'1','148','769',327,'Retail Sale Id 1412295',7400.00,0.00,0.00,12.50,425.00,'2021-12-26 16:21:19','',''),(2380662,'1','148','769',327,'Return of Retail Sale Id 1411497',0.00,29600.00,50.00,0.00,-1700.00,'2021-12-27 06:58:33','',''),(2380666,'1','148','769',327,'Return of Retail Sale Id 1411517',0.00,17760.00,30.00,0.00,-1020.00,'2021-12-27 06:59:29','',''),(2380671,'1','148','769',327,'Return of Retail Sale Id 1412220',0.00,8880.00,15.00,0.00,-510.00,'2021-12-27 07:00:49','',''),(2380673,'1','148','769',327,'Return of Retail Sale Id 1412279',0.00,7400.00,12.50,0.00,-425.00,'2021-12-27 07:01:29','',''),(2380696,'1','148','769',327,'Retail Sale Id 1412757',2486.40,0.00,0.00,4.20,142.80,'2021-12-27 07:03:52','',''),(2380732,'1','148','769',327,'Distributed to OPERATIONAL LOSS for sales id:342517',53289.00,0.00,0.00,95.50,0.00,'2021-12-27 07:12:06','',''),(2380747,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,2806740.00,5030.00,0.00,0.00,'2021-12-27 07:15:54','',''),(2380754,'1','148',NULL,327,'Reception corrector for bridging 128858',0.00,0.00,0.00,5030.00,0.00,'2021-12-27 07:17:05','',''),(2380755,'1','148','769',327,'Received from bridging 128858',0.00,0.00,5030.00,0.00,0.00,'2021-12-27 07:17:05','',''),(2380763,'1','148','769',327,'Retail Sale Id 1412819',416939.68,0.00,0.00,704.29,23945.86,'2021-12-27 07:18:47','',''),(2380769,'1','148','769',327,'Retail Sale Id 1412825',909283.90,0.00,0.00,1715.63,-48037.64,'2021-12-27 07:20:04','',''),(2381105,'1','148','769',327,'Retail Sale Id 1413009',84800.00,0.00,0.00,160.00,-4480.00,'2021-12-27 07:45:30','',''),(2381119,'1','148','769',327,'Retail Sale Id 1413022',29600.00,0.00,0.00,50.00,1700.00,'2021-12-27 07:46:46','',''),(2381130,'1','148','769',327,'Retail Sale Id 1413026',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 07:47:16','',''),(2381139,'1','148','769',327,'Retail Sale Id 1413034',3001.44,0.00,0.00,5.07,172.38,'2021-12-27 07:47:59','',''),(2381177,'1','148','769',327,'Retail Sale Id 1413062',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 07:50:56','',''),(2381192,'1','148','769',327,'Retail Sale Id 1413078',3001.44,0.00,0.00,5.07,172.38,'2021-12-27 07:52:38','',''),(2381221,'1','148','769',327,'Retail Sale Id 1413106',2498.24,0.00,0.00,4.22,143.48,'2021-12-27 07:55:35','',''),(2381237,'1','148','769',327,'Retail Sale Id 1413120',2948.16,0.00,0.00,4.98,169.32,'2021-12-27 07:57:04','',''),(2381250,'1','148','769',327,'Retail Sale Id 1413132',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 07:58:28','',''),(2381270,'1','148','769',327,'Retail Sale Id 1413141',1497.76,0.00,0.00,2.53,86.02,'2021-12-27 07:59:28','',''),(2381279,'1','148','769',327,'Retail Sale Id 1413151',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 08:00:17','',''),(2381341,'1','148','769',327,'Retail Sale Id 1413198',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 08:06:53','',''),(2381421,'1','148','769',327,'Retail Sale Id 1413267',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 08:14:55','',''),(2381425,'1','148','769',327,'Retail Sale Id 1413272',2397.60,0.00,0.00,4.05,137.70,'2021-12-27 08:15:28','',''),(2381443,'1','148','769',327,'Retail Sale Id 1413281',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 08:16:43','',''),(2381448,'1','148','769',327,'Retail Sale Id 1413286',4001.92,0.00,0.00,6.76,229.84,'2021-12-27 08:17:30','',''),(2381464,'1','148','769',327,'Retail Sale Id 1413300',1799.68,0.00,0.00,3.04,103.36,'2021-12-27 08:18:53','',''),(2381469,'1','148','769',327,'Retail Sale Id 1413307',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 08:19:32','',''),(2381493,'1','148','769',327,'Retail Sale Id 1413331',1000.48,0.00,0.00,1.69,57.46,'2021-12-27 08:21:57','',''),(2381600,'1','148','769',327,'Retail Sale Id 1413434',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 08:32:46','',''),(2381651,'1','148','769',327,'Retail Sale Id 1413482',5002.40,0.00,0.00,8.45,287.30,'2021-12-27 08:37:26','',''),(2381662,'1','148','769',327,'Retail Sale Id 1413493',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 08:38:22','',''),(2381671,'1','148','769',327,'Retail Sale Id 1413501',1497.76,0.00,0.00,2.53,86.02,'2021-12-27 08:38:58','',''),(2381691,'1','148','769',327,'Retail Sale Id 1413516',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 08:40:14','',''),(2381707,'1','148','769',327,'Retail Sale Id 1413526',5002.40,0.00,0.00,8.45,287.30,'2021-12-27 08:40:54','',''),(2381714,'1','148','769',327,'Retail Sale Id 1413532',3800.64,0.00,0.00,6.42,218.28,'2021-12-27 08:41:27','',''),(2381732,'1','148','769',327,'Retail Sale Id 1413545',26500.00,0.00,0.00,50.00,-1400.00,'2021-12-27 08:42:34','',''),(2381743,'1','148','769',327,'Retail Sale Id 1413556',2498.24,0.00,0.00,4.22,143.48,'2021-12-27 08:43:33','',''),(2381755,'1','148','769',327,'Retail Sale Id 1413567',799.20,0.00,0.00,1.35,45.90,'2021-12-27 08:44:23','',''),(2381770,'1','148','769',327,'Retail Sale Id 1413576',3001.44,0.00,0.00,5.07,172.38,'2021-12-27 08:45:15','',''),(2381782,'1','148','769',327,'Retail Sale Id 1413580',3001.44,0.00,0.00,5.07,172.38,'2021-12-27 08:45:59','',''),(2381796,'1','148','769',327,'Retail Sale Id 1413595',1000.48,0.00,0.00,1.69,57.46,'2021-12-27 08:47:02','',''),(2381848,'1','148','769',327,'Retail Sale Id 1413653',2000.96,0.00,0.00,3.38,114.92,'2021-12-27 08:51:52','',''),(2381860,'1','148','769',327,'Retail Sale Id 1413665',3001.44,0.00,0.00,5.07,172.38,'2021-12-27 08:52:49','',''),(2381867,'1','148','769',327,'Retail Sale Id 1413668',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 08:53:44','',''),(2381875,'1','148','769',327,'Retail Sale Id 1413680',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 08:54:40','',''),(2381906,'1','148','769',327,'Retail Sale Id 1413712',1799.68,0.00,0.00,3.04,103.36,'2021-12-27 08:58:33','',''),(2381923,'1','148','769',327,'Retail Sale Id 1413724',3001.44,0.00,0.00,5.07,172.38,'2021-12-27 09:00:04','',''),(2381973,'1','148','769',327,'Retail Sale Id 1413778',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 09:04:11','',''),(2381981,'1','148','769',327,'Retail Sale Id 1413786',5002.40,0.00,0.00,8.45,287.30,'2021-12-27 09:04:52','',''),(2381998,'1','148','769',327,'Retail Sale Id 1413805',1497.76,0.00,0.00,2.53,86.02,'2021-12-27 09:06:21','',''),(2382012,'1','148','769',327,'Retail Sale Id 1413818',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 09:07:41','',''),(2382344,'1','148','769',327,'Retail Sale Id 1414138',140450.00,0.00,0.00,265.00,-7420.00,'2021-12-27 09:40:35','',''),(2382364,'1','148','769',327,'Retail Sale Id 1414156',29600.00,0.00,0.00,50.00,1700.00,'2021-12-27 09:43:27','',''),(2382654,'1','148','769',327,'Retail Sale Id 1414352',5002.40,0.00,0.00,8.45,287.30,'2021-12-27 10:07:27','',''),(2382669,'1','148','769',327,'Retail Sale Id 1414363',3001.44,0.00,0.00,5.07,172.38,'2021-12-27 10:08:31','',''),(2382689,'1','148','769',327,'Retail Sale Id 1414386',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 10:10:24','',''),(2382695,'1','148','769',327,'Retail Sale Id 1414391',107060.00,0.00,0.00,202.00,-5656.00,'2021-12-27 10:11:09','',''),(2382704,'1','148','769',327,'Retail Sale Id 1414400',3001.44,0.00,0.00,5.07,172.38,'2021-12-27 10:11:39','',''),(2382715,'1','148','769',327,'Retail Sale Id 1414410',1497.76,0.00,0.00,2.53,86.02,'2021-12-27 10:12:46','',''),(2382720,'1','148','769',327,'Retail Sale Id 1414416',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 10:13:27','',''),(2382737,'1','148','769',327,'Retail Sale Id 1414438',2000.96,0.00,0.00,3.38,114.92,'2021-12-27 10:15:43','',''),(2382747,'1','148','769',327,'Retail Sale Id 1414446',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 10:16:28','',''),(2382757,'1','148','769',327,'Retail Sale Id 1414457',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 10:17:57','',''),(2382767,'1','148','769',327,'Retail Sale Id 1414465',1201.76,0.00,0.00,2.03,69.02,'2021-12-27 10:19:10','',''),(2382810,'1','148','769',327,'Retail Sale Id 1414516',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 10:23:25','',''),(2382817,'1','148','769',327,'Retail Sale Id 1414525',3001.44,0.00,0.00,5.07,172.38,'2021-12-27 10:24:05','',''),(2382828,'1','148','769',327,'Retail Sale Id 1414534',5002.40,0.00,0.00,8.45,287.30,'2021-12-27 10:25:00','',''),(2382844,'1','148','769',327,'Retail Sale Id 1414549',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 10:26:23','',''),(2383062,'1','148','769',327,'Retail Sale Id 1414769',44400.00,0.00,0.00,75.00,2550.00,'2021-12-27 10:45:37','',''),(2383093,'1','148','769',327,'Retail Sale Id 1414801',11401.92,0.00,0.00,19.26,654.84,'2021-12-27 10:49:30','',''),(2383116,'1','148','769',327,'Retail Sale Id 1414819',2000.96,0.00,0.00,3.38,114.92,'2021-12-27 10:51:24','',''),(2383132,'1','148','769',327,'Retail Sale Id 1414835',1799.68,0.00,0.00,3.04,103.36,'2021-12-27 10:52:55','',''),(2383385,'1','148','769',327,'Retail Sale Id 1415076',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 11:19:18','',''),(2383542,'1','148','769',327,'Retail Sale Id 1415225',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 11:37:12','',''),(2383549,'1','148','769',327,'Retail Sale Id 1415232',3001.44,0.00,0.00,5.07,172.38,'2021-12-27 11:37:52','',''),(2383554,'1','148','769',327,'Retail Sale Id 1415243',799.20,0.00,0.00,1.35,45.90,'2021-12-27 11:38:31','',''),(2383564,'1','148','769',327,'Retail Sale Id 1415253',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 11:39:25','',''),(2383585,'1','148','769',327,'Retail Sale Id 1415269',3001.44,0.00,0.00,5.07,172.38,'2021-12-27 11:42:01','',''),(2383721,'1','148','769',327,'Retail Sale Id 1415376',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 11:56:42','',''),(2383729,'1','148','769',327,'Retail Sale Id 1415385',1201.76,0.00,0.00,2.03,69.02,'2021-12-27 11:57:37','',''),(2383735,'1','148','769',327,'Retail Sale Id 1415389',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 11:58:31','',''),(2383756,'1','148','769',327,'Retail Sale Id 1415415',1497.76,0.00,0.00,2.53,86.02,'2021-12-27 12:01:54','',''),(2383764,'1','148','769',327,'Retail Sale Id 1415421',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 12:02:42','',''),(2383767,'1','148','769',327,'Retail Sale Id 1415424',1497.76,0.00,0.00,2.53,86.02,'2021-12-27 12:03:33','',''),(2383770,'1','148','769',327,'Retail Sale Id 1415428',3001.44,0.00,0.00,5.07,172.38,'2021-12-27 12:04:21','',''),(2383774,'1','148','769',327,'Retail Sale Id 1415431',1799.68,0.00,0.00,3.04,103.36,'2021-12-27 12:05:02','',''),(2383790,'1','148','769',327,'Retail Sale Id 1415450',3001.44,0.00,0.00,5.07,172.38,'2021-12-27 12:07:19','',''),(2383833,'1','148','769',327,'Retail Sale Id 1415480',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 12:14:21','',''),(2384063,'1','148','769',327,'Retail Sale Id 1415675',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 12:48:24','',''),(2384147,'1','148','769',327,'Retail Sale Id 1415741',4001.92,0.00,0.00,6.76,229.84,'2021-12-27 12:58:23','',''),(2384158,'1','148','769',327,'Retail Sale Id 1415747',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 12:59:33','',''),(2384189,'1','148','769',327,'Retail Sale Id 1415752',3001.44,0.00,0.00,5.07,172.38,'2021-12-27 13:00:47','',''),(2384225,'1','148','769',327,'Retail Sale Id 1415783',2498.24,0.00,0.00,4.22,143.48,'2021-12-27 13:06:00','',''),(2384285,'1','148','769',327,'Retail Sale Id 1415836',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 13:15:15','',''),(2384370,'1','148','769',327,'Retail Sale Id 1415898',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 13:24:21','',''),(2384469,'1','148','769',327,'Retail Sale Id 1415975',1799.68,0.00,0.00,3.04,103.36,'2021-12-27 13:36:53','',''),(2384522,'1','148','769',327,'Retail Sale Id 1416014',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 13:42:58','',''),(2384537,'1','148','769',327,'Retail Sale Id 1416028',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 13:45:27','',''),(2384575,'1','148','769',327,'Retail Sale Id 1416065',1497.76,0.00,0.00,2.53,86.02,'2021-12-27 13:51:11','',''),(2384631,'1','148','769',327,'Retail Sale Id 1416119',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 14:01:59','',''),(2384640,'1','148','769',327,'Retail Sale Id 1416124',3001.44,0.00,0.00,5.07,172.38,'2021-12-27 14:02:59','',''),(2384689,'1','148','769',327,'Retail Sale Id 1416137',4801.12,0.00,0.00,8.11,275.74,'2021-12-27 14:06:06','',''),(2384811,'1','148','769',327,'Retail Sale Id 1416193',3001.44,0.00,0.00,5.07,172.38,'2021-12-27 14:19:32','',''),(2384815,'1','148','769',327,'Retail Sale Id 1416200',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 14:20:36','',''),(2384884,'1','148','769',327,'Retail Sale Id 1416239',3599.36,0.00,0.00,6.08,206.72,'2021-12-27 14:28:50','',''),(2385206,'1','148','769',327,'Retail Sale Id 1416529',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 15:23:51','',''),(2385308,'1','148','769',327,'Retail Sale Id 1416597',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 15:37:15','',''),(2385520,'1','148','769',327,'Retail Sale Id 1416780',4499.20,0.00,0.00,7.60,258.40,'2021-12-27 16:01:34','',''),(2385531,'1','148','769',327,'Retail Sale Id 1416795',2000.96,0.00,0.00,3.38,114.92,'2021-12-27 16:03:14','',''),(2385591,'1','148','769',327,'Retail Sale Id 1416848',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 16:12:27','',''),(2385596,'1','148','769',327,'Retail Sale Id 1416853',3001.44,0.00,0.00,5.07,172.38,'2021-12-27 16:13:14','',''),(2385678,'1','148','769',327,'Retail Sale Id 1416921',3001.44,0.00,0.00,5.07,172.38,'2021-12-27 16:26:33','',''),(2385682,'1','148','769',327,'Retail Sale Id 1416924',2000.96,0.00,0.00,3.38,114.92,'2021-12-27 16:27:21','',''),(2385685,'1','148','769',327,'Retail Sale Id 1416927',3001.44,0.00,0.00,5.07,172.38,'2021-12-27 16:28:23','',''),(2385696,'1','148','769',327,'Retail Sale Id 1416934',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 16:29:12','',''),(2385717,'1','148','769',327,'Retail Sale Id 1416950',2000.96,0.00,0.00,3.38,114.92,'2021-12-27 16:32:10','',''),(2385850,'1','148','769',327,'Retail Sale Id 1417066',7400.00,0.00,0.00,12.50,425.00,'2021-12-27 16:56:35','',''),(2386735,'1','148','769',327,'Retail Sale Id 1417440',666597.92,0.00,0.00,1126.01,38284.34,'2021-12-28 06:54:18','',''),(2386748,'1','148','769',327,'Return of Retail Sale Id 1417440',0.00,666597.92,1126.01,0.00,-38284.34,'2021-12-28 06:56:17','',''),(2386752,'1','148','769',327,'Retail Sale Id 1417456',596785.30,0.00,0.00,1126.01,-31528.28,'2021-12-28 06:57:17','',''),(2386770,'1','148','769',327,'Retail Sale Id 1417468',13112.80,0.00,0.00,22.15,753.10,'2021-12-28 07:01:47','',''),(2387289,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,1530000.00,3000.00,0.00,0.00,'2021-12-28 08:02:02','',''),(2387302,'1','148',NULL,327,'Reception corrector for bridging 128961',0.00,0.00,0.00,3000.00,0.00,'2021-12-28 08:02:58','',''),(2387303,'1','148','769',327,'Received from bridging 128961',0.00,0.00,3000.00,0.00,0.00,'2021-12-28 08:02:58','',''),(2387313,'1','148','769',327,'Retail Sale Id 1417930',167867.52,0.00,0.00,283.56,23251.92,'2021-12-28 08:03:44','',''),(2387337,'1','148','769',327,'Retail Sale Id 1417948',112927.10,0.00,0.00,213.07,4261.40,'2021-12-28 08:05:36','',''),(2387349,'1','148','769',327,'Retail Sale Id 1417958',49136.00,0.00,0.00,83.00,6806.00,'2021-12-28 08:06:41','',''),(2388153,'1','148','769',327,'Retail Sale Id 1418588',1497.76,0.00,0.00,2.53,207.46,'2021-12-28 09:19:54','',''),(2388185,'1','148','769',327,'Retail Sale Id 1418620',1497.76,0.00,0.00,2.53,207.46,'2021-12-28 09:23:04','',''),(2388520,'1','148','769',327,'Retail Sale Id 1418949',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 10:01:45','',''),(2388532,'1','148','769',327,'Retail Sale Id 1418959',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 10:02:57','',''),(2388572,'1','148','769',327,'Retail Sale Id 1418989',29002.08,0.00,0.00,48.99,4017.18,'2021-12-28 10:06:18','',''),(2388618,'1','148','769',327,'Retail Sale Id 1419037',3001.44,0.00,0.00,5.07,415.74,'2021-12-28 10:12:42','',''),(2389085,'1','148','769',327,'Retail Sale Id 1419463',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 10:57:14','',''),(2389121,'1','148','769',327,'Retail Sale Id 1419497',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 11:01:37','',''),(2389201,'1','148','769',327,'Retail Sale Id 1419555',1799.68,0.00,0.00,3.04,249.28,'2021-12-28 11:08:43','',''),(2389230,'1','148','769',327,'Retail Sale Id 1419584',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 11:12:16','',''),(2389641,'1','148','769',327,'Retail Sale Id 1419960',14800.00,0.00,0.00,25.00,2050.00,'2021-12-28 11:57:59','',''),(2389718,'1','148','769',327,'Retail Sale Id 1420000',6002.88,0.00,0.00,10.14,831.48,'2021-12-28 12:03:19','',''),(2389894,'1','148','769',327,'Retail Sale Id 1420140',3001.44,0.00,0.00,5.07,415.74,'2021-12-28 12:19:27','',''),(2389907,'1','148','769',327,'Retail Sale Id 1420152',1497.76,0.00,0.00,2.53,207.46,'2021-12-28 12:20:19','',''),(2389922,'1','148','769',327,'Retail Sale Id 1420167',1799.68,0.00,0.00,3.04,249.28,'2021-12-28 12:21:35','',''),(2389932,'1','148','769',327,'Retail Sale Id 1420174',5002.40,0.00,0.00,8.45,692.90,'2021-12-28 12:22:23','',''),(2390121,'1','148','769',327,'Retail Sale Id 1420308',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 12:38:08','',''),(2390245,'1','148','769',327,'Retail Sale Id 1420408',2000.96,0.00,0.00,3.38,277.16,'2021-12-28 12:50:24','',''),(2390262,'1','148','769',327,'Retail Sale Id 1420423',1799.68,0.00,0.00,3.04,249.28,'2021-12-28 12:52:07','',''),(2390275,'1','148','769',327,'Retail Sale Id 1420427',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 12:52:59','',''),(2390291,'1','148','769',327,'Retail Sale Id 1420443',1000.48,0.00,0.00,1.69,138.58,'2021-12-28 12:54:25','',''),(2390297,'1','148','769',327,'Retail Sale Id 1420451',4001.92,0.00,0.00,6.76,554.32,'2021-12-28 12:55:07','',''),(2390323,'1','148','769',327,'Retail Sale Id 1420469',10999.36,0.00,0.00,18.58,1523.56,'2021-12-28 12:56:52','',''),(2390328,'1','148','769',327,'Retail Sale Id 1420475',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 12:57:38','',''),(2390335,'1','148','769',327,'Retail Sale Id 1420479',6002.88,0.00,0.00,10.14,831.48,'2021-12-28 12:58:40','',''),(2390359,'1','148','769',327,'Retail Sale Id 1420499',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 13:00:21','',''),(2390366,'1','148','769',327,'Retail Sale Id 1420505',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 13:01:17','',''),(2390375,'1','148','769',327,'Retail Sale Id 1420514',7104.00,0.00,0.00,12.00,984.00,'2021-12-28 13:02:21','',''),(2390481,'1','148','769',327,'Retail Sale Id 1420572',3001.44,0.00,0.00,5.07,415.74,'2021-12-28 13:09:44','',''),(2390488,'1','148','769',327,'Retail Sale Id 1420579',193450.00,0.00,0.00,365.00,7300.00,'2021-12-28 13:11:31','',''),(2390492,'1','148','769',327,'Retail Sale Id 1420582',89570.00,0.00,0.00,169.00,3380.00,'2021-12-28 13:12:09','',''),(2390507,'1','148','769',327,'Retail Sale Id 1420600',31270.00,0.00,0.00,59.00,1180.00,'2021-12-28 13:14:13','',''),(2390528,'1','148','769',327,'Retail Sale Id 1420612',4736.00,0.00,0.00,8.00,656.00,'2021-12-28 13:17:14','',''),(2390536,'1','148','769',327,'Retail Sale Id 1420627',1497.76,0.00,0.00,2.53,207.46,'2021-12-28 13:18:20','',''),(2390551,'1','148','769',327,'Retail Sale Id 1420639',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 13:19:23','',''),(2390566,'1','148','769',327,'Retail Sale Id 1420643',3001.44,0.00,0.00,5.07,415.74,'2021-12-28 13:20:18','',''),(2390585,'1','148','769',327,'Retail Sale Id 1420652',1799.68,0.00,0.00,3.04,249.28,'2021-12-28 13:21:37','',''),(2390605,'1','148','769',327,'Retail Sale Id 1420661',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 13:22:45','',''),(2390620,'1','148','769',327,'Retail Sale Id 1420673',1699.04,0.00,0.00,2.87,235.34,'2021-12-28 13:24:14','',''),(2390632,'1','148','769',327,'Retail Sale Id 1420685',1799.68,0.00,0.00,3.04,249.28,'2021-12-28 13:26:00','',''),(2390636,'1','148','769',327,'Retail Sale Id 1420689',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 13:26:42','',''),(2390639,'1','148','769',327,'Retail Sale Id 1420692',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 13:27:38','',''),(2390657,'1','148','769',327,'Retail Sale Id 1420700',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 13:29:10','',''),(2390671,'1','148','769',327,'Retail Sale Id 1420717',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 13:30:24','',''),(2390712,'1','148','769',327,'Retail Sale Id 1420724',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 13:32:22','',''),(2390731,'1','148','769',327,'Retail Sale Id 1420734',2000.96,0.00,0.00,3.38,277.16,'2021-12-28 13:33:16','',''),(2390739,'1','148','769',327,'Retail Sale Id 1420741',1799.68,0.00,0.00,3.04,249.28,'2021-12-28 13:34:11','',''),(2390743,'1','148','769',327,'Retail Sale Id 1420746',3001.44,0.00,0.00,5.07,415.74,'2021-12-28 13:35:13','',''),(2390752,'1','148','769',327,'Retail Sale Id 1420754',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 13:36:33','',''),(2390819,'1','148','769',327,'Retail Sale Id 1420803',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 13:45:26','',''),(2390855,'1','148','769',327,'Retail Sale Id 1420831',1799.68,0.00,0.00,3.04,249.28,'2021-12-28 13:48:28','',''),(2390906,'1','148','769',327,'Retail Sale Id 1420870',3001.44,0.00,0.00,5.07,415.74,'2021-12-28 13:53:48','',''),(2390946,'1','148','769',327,'Retail Sale Id 1420904',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 13:58:04','',''),(2390977,'1','148','769',327,'Retail Sale Id 1420937',3001.44,0.00,0.00,5.07,415.74,'2021-12-28 14:01:22','',''),(2390996,'1','148','769',327,'Retail Sale Id 1420951',5002.40,0.00,0.00,8.45,692.90,'2021-12-28 14:03:13','',''),(2391021,'1','148','769',327,'Retail Sale Id 1420963',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 14:04:53','',''),(2391029,'1','148','769',327,'Retail Sale Id 1420968',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 14:05:51','',''),(2391068,'1','148','769',327,'Retail Sale Id 1420994',1799.68,0.00,0.00,3.04,249.28,'2021-12-28 14:09:09','',''),(2391151,'1','148','769',327,'Retail Sale Id 1421032',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 14:14:22','',''),(2391156,'1','148','769',327,'Retail Sale Id 1421039',17398.88,0.00,0.00,29.39,2409.98,'2021-12-28 14:15:34','',''),(2391174,'1','148','769',327,'Retail Sale Id 1421050',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 14:17:38','',''),(2391189,'1','148','769',327,'Retail Sale Id 1421065',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 14:19:14','',''),(2391316,'1','148','769',327,'Retail Sale Id 1421178',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 14:35:40','',''),(2392628,'1','148','769',327,'Retail Sale Id 1422207',193450.00,0.00,0.00,365.00,7300.00,'2021-12-28 17:01:57','',''),(2393561,'1','148','769',327,'Retail Sale Id 1422580',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 06:51:33','',''),(2393841,'1','148','769',327,'Retail Sale Id 1422814',1000.48,0.00,0.00,1.69,138.58,'2021-12-29 07:23:09','',''),(2394378,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,1183200.00,2320.00,0.00,0.00,'2021-12-29 08:14:22','',''),(2394384,'1','148',NULL,327,'Reception corrector for bridging 129075',0.00,0.00,0.00,2320.00,0.00,'2021-12-29 08:15:26','',''),(2394385,'1','148','769',327,'Received from bridging 129075',0.00,0.00,2320.00,0.00,0.00,'2021-12-29 08:15:26','',''),(2394416,'1','148','769',327,'Retail Sale Id 1423235',523104.70,0.00,0.00,986.99,19739.80,'2021-12-29 08:19:38','',''),(2394437,'1','148','769',327,'Retail Sale Id 1423254',424209.44,0.00,0.00,716.57,58758.74,'2021-12-29 08:21:48','',''),(2395084,'1','148','769',327,'Retail Sale Id 1423760',140450.00,0.00,0.00,265.00,5300.00,'2021-12-29 09:25:07','',''),(2395139,'1','148','769',327,'Retail Sale Id 1423790',29600.00,0.00,0.00,50.00,4100.00,'2021-12-29 09:31:22','',''),(2395304,'1','148','769',327,'Retail Sale Id 1423966',44400.00,0.00,0.00,75.00,6150.00,'2021-12-29 09:49:28','',''),(2395306,'1','148','769',327,'Retail Sale Id 1423969',100700.00,0.00,0.00,190.00,3800.00,'2021-12-29 09:50:01','',''),(2395308,'1','148','769',327,'Retail Sale Id 1423971',10999.36,0.00,0.00,18.58,1523.56,'2021-12-29 09:50:27','',''),(2395318,'1','148','769',327,'Retail Sale Id 1423978',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 09:51:05','',''),(2395325,'1','148','769',327,'Retail Sale Id 1423985',14800.00,0.00,0.00,25.00,2050.00,'2021-12-29 09:51:37','',''),(2395328,'1','148','769',327,'Retail Sale Id 1423988',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 09:51:59','',''),(2395330,'1','148','769',327,'Retail Sale Id 1423990',11840.00,0.00,0.00,20.00,1640.00,'2021-12-29 09:52:20','',''),(2395333,'1','148','769',327,'Retail Sale Id 1423993',10952.00,0.00,0.00,18.50,1517.00,'2021-12-29 09:52:43','',''),(2396204,'1','148','769',327,'Retail Sale Id 1424762',107060.00,0.00,0.00,202.00,4040.00,'2021-12-29 11:26:14','',''),(2396212,'1','148','769',327,'Retail Sale Id 1424763',29600.00,0.00,0.00,50.00,4100.00,'2021-12-29 11:26:37','',''),(2396218,'1','148','769',327,'Retail Sale Id 1424770',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 11:27:15','',''),(2396431,'1','148','769',327,'Retail Sale Id 1424948',2397.60,0.00,0.00,4.05,332.10,'2021-12-29 11:49:34','',''),(2396441,'1','148','769',327,'Retail Sale Id 1424959',10999.36,0.00,0.00,18.58,1523.56,'2021-12-29 11:50:46','',''),(2396449,'1','148','769',327,'Retail Sale Id 1424966',14800.00,0.00,0.00,25.00,2050.00,'2021-12-29 11:51:27','',''),(2396452,'1','148','769',327,'Retail Sale Id 1424969',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 11:51:55','',''),(2396521,'1','148','769',327,'Retail Sale Id 1425036',6002.88,0.00,0.00,10.14,831.48,'2021-12-29 12:01:11','',''),(2396527,'1','148','769',327,'Retail Sale Id 1425042',29600.00,0.00,0.00,50.00,4100.00,'2021-12-29 12:02:08','',''),(2396764,'1','148','769',327,'Retail Sale Id 1425243',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 12:36:41','',''),(2396969,'1','148','769',327,'Retail Sale Id 1425414',14800.00,0.00,0.00,25.00,2050.00,'2021-12-29 13:01:58','',''),(2396991,'1','148','769',327,'Retail Sale Id 1425423',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 13:02:55','',''),(2397047,'1','148','769',327,'Retail Sale Id 1425466',2000.96,0.00,0.00,3.38,277.16,'2021-12-29 13:10:04','',''),(2397072,'1','148','769',327,'Retail Sale Id 1425493',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 13:13:23','',''),(2397101,'1','148','769',327,'Retail Sale Id 1425527',3001.44,0.00,0.00,5.07,415.74,'2021-12-29 13:17:31','',''),(2397120,'1','148','769',327,'Retail Sale Id 1425542',1799.68,0.00,0.00,3.04,249.28,'2021-12-29 13:19:37','',''),(2397182,'1','148','769',327,'Retail Sale Id 1425593',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 13:26:45','',''),(2397229,'1','148','769',327,'Retail Sale Id 1425625',1799.68,0.00,0.00,3.04,249.28,'2021-12-29 13:31:36','',''),(2397233,'1','148','769',327,'Retail Sale Id 1425628',3001.44,0.00,0.00,5.07,415.74,'2021-12-29 13:33:05','',''),(2397255,'1','148','769',327,'Retail Sale Id 1425643',1000.48,0.00,0.00,1.69,138.58,'2021-12-29 13:35:06','',''),(2397269,'1','148','769',327,'Retail Sale Id 1425648',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 13:35:58','',''),(2397273,'1','148','769',327,'Retail Sale Id 1425652',1799.68,0.00,0.00,3.04,249.28,'2021-12-29 13:36:36','',''),(2397281,'1','148','769',327,'Retail Sale Id 1425661',2000.96,0.00,0.00,3.38,277.16,'2021-12-29 13:38:11','',''),(2397338,'1','148','769',327,'Retail Sale Id 1425699',2000.96,0.00,0.00,3.38,277.16,'2021-12-29 13:44:53','',''),(2397350,'1','148','769',327,'Retail Sale Id 1425713',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 13:46:14','',''),(2397379,'1','148','769',327,'Retail Sale Id 1425733',2000.96,0.00,0.00,3.38,277.16,'2021-12-29 13:49:16','',''),(2397385,'1','148','769',327,'Retail Sale Id 1425740',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 13:50:12','',''),(2397399,'1','148','769',327,'Retail Sale Id 1425754',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 13:51:45','',''),(2397447,'1','148','769',327,'Retail Sale Id 1425799',1201.76,0.00,0.00,2.03,166.46,'2021-12-29 13:57:36','',''),(2397453,'1','148','769',327,'Retail Sale Id 1425803',1201.76,0.00,0.00,2.03,166.46,'2021-12-29 13:58:50','',''),(2397461,'1','148','769',327,'Retail Sale Id 1425808',3001.44,0.00,0.00,5.07,415.74,'2021-12-29 13:59:43','',''),(2397506,'1','148','769',327,'Retail Sale Id 1425850',2000.96,0.00,0.00,3.38,277.16,'2021-12-29 14:04:30','',''),(2397522,'1','148','769',327,'Retail Sale Id 1425860',3001.44,0.00,0.00,5.07,415.74,'2021-12-29 14:05:20','',''),(2397536,'1','148','769',327,'Retail Sale Id 1425867',2000.96,0.00,0.00,3.38,277.16,'2021-12-29 14:06:08','',''),(2397564,'1','148','769',327,'Retail Sale Id 1425887',1497.76,0.00,0.00,2.53,207.46,'2021-12-29 14:09:12','',''),(2397570,'1','148','769',327,'Retail Sale Id 1425893',5002.40,0.00,0.00,8.45,692.90,'2021-12-29 14:09:56','',''),(2397664,'1','148','769',327,'Retail Sale Id 1425974',1799.68,0.00,0.00,3.04,249.28,'2021-12-29 14:20:01','',''),(2397751,'1','148','769',327,'Retail Sale Id 1426034',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 14:28:12','',''),(2397886,'1','148','769',327,'Retail Sale Id 1426123',3001.44,0.00,0.00,5.07,415.74,'2021-12-29 14:38:53','',''),(2397909,'1','148','769',327,'Retail Sale Id 1426129',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 14:40:09','',''),(2397920,'1','148','769',327,'Retail Sale Id 1426144',5002.40,0.00,0.00,8.45,692.90,'2021-12-29 14:41:36','',''),(2397927,'1','148','769',327,'Retail Sale Id 1426151',1000.48,0.00,0.00,1.69,138.58,'2021-12-29 14:42:36','',''),(2397955,'1','148','769',327,'Retail Sale Id 1426166',3001.44,0.00,0.00,5.07,415.74,'2021-12-29 14:44:36','',''),(2397970,'1','148','769',327,'Retail Sale Id 1426177',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 14:45:50','',''),(2398031,'1','148','769',327,'Retail Sale Id 1426227',2800.16,0.00,0.00,4.73,387.86,'2021-12-29 14:51:28','',''),(2398081,'1','148','769',327,'Retail Sale Id 1426243',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 14:53:05','',''),(2398091,'1','148','769',327,'Retail Sale Id 1426254',3001.44,0.00,0.00,5.07,415.74,'2021-12-29 14:54:14','',''),(2398107,'1','148','769',327,'Retail Sale Id 1426266',1000.48,0.00,0.00,1.69,138.58,'2021-12-29 14:56:20','',''),(2398116,'1','148','769',327,'Retail Sale Id 1426270',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 14:57:05','',''),(2398132,'1','148','769',327,'Retail Sale Id 1426283',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 14:59:12','',''),(2398160,'1','148','769',327,'Retail Sale Id 1426311',3001.44,0.00,0.00,5.07,415.74,'2021-12-29 15:04:18','',''),(2398186,'1','148','769',327,'Retail Sale Id 1426328',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 15:07:36','',''),(2398301,'1','148','769',327,'Retail Sale Id 1426362',5002.40,0.00,0.00,8.45,692.90,'2021-12-29 15:13:27','',''),(2398361,'1','148','769',327,'Retail Sale Id 1426407',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 15:19:31','',''),(2398390,'1','148','769',327,'Retail Sale Id 1426440',14800.00,0.00,0.00,25.00,2050.00,'2021-12-29 15:22:54','',''),(2398398,'1','148','769',327,'Retail Sale Id 1426446',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 15:23:32','',''),(2398417,'1','148','769',327,'Retail Sale Id 1426465',5002.40,0.00,0.00,8.45,692.90,'2021-12-29 15:25:31','',''),(2398459,'1','148','769',327,'Retail Sale Id 1426482',3001.44,0.00,0.00,5.07,415.74,'2021-12-29 15:27:33','',''),(2398482,'1','148','769',327,'Retail Sale Id 1426496',5002.40,0.00,0.00,8.45,692.90,'2021-12-29 15:28:45','',''),(2398492,'1','148','769',327,'Retail Sale Id 1426505',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 15:30:01','',''),(2398572,'1','148','769',327,'Retail Sale Id 1426552',3001.44,0.00,0.00,5.07,415.74,'2021-12-29 15:35:28','',''),(2398589,'1','148','769',327,'Retail Sale Id 1426569',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 15:36:58','',''),(2398637,'1','148','769',327,'Retail Sale Id 1426596',6002.88,0.00,0.00,10.14,831.48,'2021-12-29 15:39:09','',''),(2398742,'1','148','769',327,'Retail Sale Id 1426661',8299.84,0.00,0.00,14.02,1149.64,'2021-12-29 15:48:16','',''),(2398767,'1','148','769',327,'Retail Sale Id 1426686',1799.68,0.00,0.00,3.04,249.28,'2021-12-29 15:51:45','',''),(2398786,'1','148','769',327,'Retail Sale Id 1426694',1497.76,0.00,0.00,2.53,207.46,'2021-12-29 15:52:46','',''),(2398826,'1','148','769',327,'Retail Sale Id 1426719',1799.68,0.00,0.00,3.04,249.28,'2021-12-29 15:56:51','',''),(2398860,'1','148','769',327,'Retail Sale Id 1426740',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 15:58:58','',''),(2399115,'1','148','769',327,'Retail Sale Id 1426962',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 16:28:19','',''),(2400318,'1','148','769',327,'Retail Sale Id 1427585',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 06:52:46','',''),(2400346,'1','148','769',327,'Retail Sale Id 1427600',5920.00,0.00,0.00,10.00,820.00,'2021-12-30 06:55:23','',''),(2400402,'1','148','769',327,'Retail Sale Id 1427624',1397.12,0.00,0.00,2.36,193.52,'2021-12-30 06:58:40','',''),(2400435,'1','148','769',327,'Retail Sale Id 1427649',2498.24,0.00,0.00,4.22,346.04,'2021-12-30 07:02:32','',''),(2400442,'1','148','769',327,'Retail Sale Id 1427656',3498.72,0.00,0.00,5.91,484.62,'2021-12-30 07:03:35','',''),(2400462,'1','148','769',327,'Retail Sale Id 1427676',1799.68,0.00,0.00,3.04,249.28,'2021-12-30 07:07:20','',''),(2400603,'1','148','769',327,'Retail Sale Id 1427800',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 07:27:54','',''),(2400607,'1','148','769',327,'Retail Sale Id 1427804',5920.00,0.00,0.00,10.00,820.00,'2021-12-30 07:28:25','',''),(2400659,'1','148','769',327,'Retail Sale Id 1427835',2000.96,0.00,0.00,3.38,277.16,'2021-12-30 07:32:30','',''),(2400703,'1','148','769',327,'Retail Sale Id 1427848',2800.16,0.00,0.00,4.73,387.86,'2021-12-30 07:34:05','',''),(2400721,'1','148','769',327,'Retail Sale Id 1427861',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 07:35:46','',''),(2400800,'1','148','769',327,'Return of Retail Sale Id 1426440',0.00,14800.00,25.00,0.00,-2050.00,'2021-12-30 07:45:28','',''),(2400810,'1','148','769',327,'Return of Retail Sale Id 1423993',0.00,10952.00,18.50,0.00,-1517.00,'2021-12-30 07:46:29','',''),(2400815,'1','148','769',327,'Return of Retail Sale Id 1424763',0.00,29600.00,50.00,0.00,-4100.00,'2021-12-30 07:47:00','',''),(2400822,'1','148','769',327,'Return of Retail Sale Id 1424959',0.00,10999.36,18.58,0.00,-1523.56,'2021-12-30 07:47:32','',''),(2400824,'1','148','769',327,'Retail Sale Id 1427955',6002.88,0.00,0.00,10.14,831.48,'2021-12-30 07:47:37','',''),(2400827,'1','148','769',327,'Return of Retail Sale Id 1424969',0.00,3599.36,6.08,0.00,-498.56,'2021-12-30 07:48:13','',''),(2400833,'1','148','769',327,'Return of Retail Sale Id 1425042',0.00,29600.00,50.00,0.00,-4100.00,'2021-12-30 07:48:55','',''),(2400838,'1','148','769',327,'Return of Retail Sale Id 1425414',0.00,14800.00,25.00,0.00,-2050.00,'2021-12-30 07:49:27','',''),(2400848,'1','148','769',327,'Return of Retail Sale Id 1423966',0.00,44400.00,75.00,0.00,-6150.00,'2021-12-30 07:50:39','',''),(2400875,'1','148','769',327,'Retail Sale Id 1427995',111013.80,0.00,0.00,209.46,4189.20,'2021-12-30 07:53:11','',''),(2400888,'1','148','769',327,'Retail Sale Id 1428010',31962.08,0.00,0.00,53.99,4427.18,'2021-12-30 07:55:13','',''),(2401018,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,2769300.00,5430.00,0.00,0.00,'2021-12-30 08:08:41','',''),(2401081,'1','148',NULL,327,'Reception corrector for bridging 129182',0.00,0.00,0.00,5430.00,0.00,'2021-12-30 08:15:00','',''),(2401082,'1','148','769',327,'Received from bridging 129182',0.00,0.00,5430.00,0.00,0.00,'2021-12-30 08:15:00','',''),(2401100,'1','148','769',327,'Retail Sale Id 1428190',369952.64,0.00,0.00,624.92,51243.44,'2021-12-30 08:16:30','',''),(2401290,'1','148','769',327,'Retail Sale Id 1428291',239220.80,0.00,0.00,451.36,9027.20,'2021-12-30 08:30:55','',''),(2401335,'1','148','769',327,'Retail Sale Id 1428355',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 08:36:05','',''),(2401711,'1','148','769',327,'Retail Sale Id 1428600',3498.72,0.00,0.00,5.91,484.62,'2021-12-30 09:00:11','',''),(2401894,'1','148','769',327,'Retail Sale Id 1428750',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 09:15:26','',''),(2401909,'1','148','769',327,'Retail Sale Id 1428764',3001.44,0.00,0.00,5.07,415.74,'2021-12-30 09:17:11','',''),(2401926,'1','148','769',327,'Retail Sale Id 1428781',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 09:20:04','',''),(2401932,'1','148','769',327,'Retail Sale Id 1428787',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 09:20:54','',''),(2401960,'1','148','769',327,'Retail Sale Id 1428810',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 09:23:12','',''),(2401989,'1','148','769',327,'Retail Sale Id 1428837',4144.00,0.00,0.00,7.00,574.00,'2021-12-30 09:26:16','',''),(2402016,'1','148','769',327,'Retail Sale Id 1428864',1799.68,0.00,0.00,3.04,249.28,'2021-12-30 09:28:31','',''),(2402027,'1','148','769',327,'Retail Sale Id 1428879',1497.76,0.00,0.00,2.53,207.46,'2021-12-30 09:29:40','',''),(2402412,'1','148','769',327,'Retail Sale Id 1429226',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 10:05:36','',''),(2402854,'1','148','769',327,'Retail Sale Id 1429618',114919.90,0.00,0.00,216.83,4336.60,'2021-12-30 10:49:24','',''),(2404642,'1','148','769',327,'Retail Sale Id 1431056',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 14:05:16','',''),(2404652,'1','148','769',327,'Retail Sale Id 1431066',497.28,0.00,0.00,0.84,68.88,'2021-12-30 14:06:42','',''),(2404679,'1','148','769',327,'Retail Sale Id 1431095',5920.00,0.00,0.00,10.00,820.00,'2021-12-30 14:10:19','',''),(2404781,'1','148','769',327,'Retail Sale Id 1431173',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 14:19:26','',''),(2404813,'1','148','769',327,'Retail Sale Id 1431206',193450.00,0.00,0.00,365.00,7300.00,'2021-12-30 14:22:03','',''),(2404819,'1','148','769',327,'Retail Sale Id 1431211',140450.00,0.00,0.00,265.00,5300.00,'2021-12-30 14:22:47','',''),(2404828,'1','148','769',327,'Retail Sale Id 1431221',31800.00,0.00,0.00,60.00,1200.00,'2021-12-30 14:23:22','',''),(2404846,'1','148','769',327,'Retail Sale Id 1431237',1799.68,0.00,0.00,3.04,249.28,'2021-12-30 14:25:55','',''),(2404858,'1','148','769',327,'Retail Sale Id 1431250',1000.48,0.00,0.00,1.69,138.58,'2021-12-30 14:27:40','',''),(2404864,'1','148','769',327,'Retail Sale Id 1431256',1799.68,0.00,0.00,3.04,249.28,'2021-12-30 14:28:08','',''),(2404869,'1','148','769',327,'Retail Sale Id 1431261',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 14:29:17','',''),(2404881,'1','148','769',327,'Retail Sale Id 1431275',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 14:30:54','',''),(2404916,'1','148','769',327,'Retail Sale Id 1431311',1201.76,0.00,0.00,2.03,166.46,'2021-12-30 14:35:09','',''),(2404942,'1','148','769',327,'Retail Sale Id 1431341',5002.40,0.00,0.00,8.45,692.90,'2021-12-30 14:37:43','',''),(2404980,'1','148','769',327,'Retail Sale Id 1431381',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 14:42:17','',''),(2404989,'1','148','769',327,'Retail Sale Id 1431391',1201.76,0.00,0.00,2.03,166.46,'2021-12-30 14:43:02','',''),(2405098,'1','148','769',327,'Retail Sale Id 1431495',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 14:57:36','',''),(2405108,'1','148','769',327,'Retail Sale Id 1431504',1000.48,0.00,0.00,1.69,138.58,'2021-12-30 14:58:36','',''),(2405114,'1','148','769',327,'Retail Sale Id 1431510',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 14:59:13','',''),(2405126,'1','148','769',327,'Retail Sale Id 1431526',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 15:00:50','',''),(2405137,'1','148','769',327,'Retail Sale Id 1431540',6002.88,0.00,0.00,10.14,831.48,'2021-12-30 15:02:27','',''),(2405149,'1','148','769',327,'Retail Sale Id 1431551',1397.12,0.00,0.00,2.36,193.52,'2021-12-30 15:04:09','',''),(2405180,'1','148','769',327,'Retail Sale Id 1431582',2000.96,0.00,0.00,3.38,277.16,'2021-12-30 15:08:45','',''),(2405193,'1','148','769',327,'Retail Sale Id 1431593',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 15:09:57','',''),(2405281,'1','148','769',327,'Retail Sale Id 1431675',57240.00,0.00,0.00,108.00,2160.00,'2021-12-30 15:18:27','',''),(2405289,'1','148','769',327,'Retail Sale Id 1431683',1201.76,0.00,0.00,2.03,166.46,'2021-12-30 15:19:03','',''),(2405308,'1','148','769',327,'Retail Sale Id 1431697',1000.48,0.00,0.00,1.69,138.58,'2021-12-30 15:20:52','',''),(2405314,'1','148','769',327,'Retail Sale Id 1431702',3001.44,0.00,0.00,5.07,415.74,'2021-12-30 15:21:38','',''),(2405352,'1','148','769',327,'Retail Sale Id 1431722',2000.96,0.00,0.00,3.38,277.16,'2021-12-30 15:24:31','',''),(2405355,'1','148','769',327,'Retail Sale Id 1431724',1000.48,0.00,0.00,1.69,138.58,'2021-12-30 15:25:09','',''),(2405397,'1','148','769',327,'Retail Sale Id 1431759',2000.96,0.00,0.00,3.38,277.16,'2021-12-30 15:29:21','',''),(2405404,'1','148','769',327,'Retail Sale Id 1431765',1201.76,0.00,0.00,2.03,166.46,'2021-12-30 15:30:10','',''),(2405461,'1','148','769',327,'Retail Sale Id 1431818',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 15:36:22','',''),(2405472,'1','148','769',327,'Retail Sale Id 1431830',1497.76,0.00,0.00,2.53,207.46,'2021-12-30 15:37:35','',''),(2405512,'1','148','769',327,'Retail Sale Id 1431863',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 15:41:38','',''),(2405523,'1','148','769',327,'Retail Sale Id 1431873',2397.60,0.00,0.00,4.05,332.10,'2021-12-30 15:42:41','',''),(2405532,'1','148','769',327,'Retail Sale Id 1431883',6002.88,0.00,0.00,10.14,831.48,'2021-12-30 15:43:38','',''),(2405557,'1','148','769',327,'Retail Sale Id 1431896',1799.68,0.00,0.00,3.04,249.28,'2021-12-30 15:44:46','',''),(2405562,'1','148','769',327,'Retail Sale Id 1431901',1497.76,0.00,0.00,2.53,207.46,'2021-12-30 15:45:34','',''),(2405582,'1','148','769',327,'Retail Sale Id 1431920',3001.44,0.00,0.00,5.07,415.74,'2021-12-30 15:47:33','',''),(2405617,'1','148','769',327,'Retail Sale Id 1431932',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 15:49:35','',''),(2405675,'1','148','769',327,'Retail Sale Id 1431998',597.92,0.00,0.00,1.01,82.82,'2021-12-30 15:56:03','',''),(2405688,'1','148','769',327,'Retail Sale Id 1432009',2000.96,0.00,0.00,3.38,277.16,'2021-12-30 15:56:58','',''),(2405704,'1','148','769',327,'Retail Sale Id 1432024',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 15:58:14','',''),(2405732,'1','148','769',327,'Retail Sale Id 1432051',2650.00,0.00,0.00,5.00,100.00,'2021-12-30 16:01:22','',''),(2405748,'1','148','769',327,'Retail Sale Id 1432070',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 16:02:41','',''),(2405760,'1','148','769',327,'Retail Sale Id 1432081',4001.92,0.00,0.00,6.76,554.32,'2021-12-30 16:03:32','',''),(2406388,'1','148','769',327,'Retail Sale Id 1432646',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 17:03:44','',''),(2406420,'1','148','769',327,'Retail Sale Id 1432658',29600.00,0.00,0.00,50.00,4100.00,'2021-12-30 17:05:24','',''),(2406447,'1','148','769',327,'Retail Sale Id 1432664',140450.00,0.00,0.00,265.00,5300.00,'2021-12-30 17:06:34','',''),(2406509,'1','148','769',327,'Retail Sale Id 1432698',1799.68,0.00,0.00,3.04,249.28,'2021-12-30 17:13:36','',''),(2406534,'1','148','769',327,'Retail Sale Id 1432720',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 17:18:23','',''),(2406554,'1','148','769',327,'Retail Sale Id 1432753',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 17:21:29','',''),(2407596,'1','148','769',327,'Retail Sale Id 1433131',529461.12,0.00,0.00,894.36,73337.52,'2021-12-31 06:52:00','',''),(2407610,'1','148','769',327,'Retail Sale Id 1433142',478611.20,0.00,0.00,903.04,18060.80,'2021-12-31 06:54:23','',''),(2407725,'1','148','769',327,'Retail Sale Id 1433251',29600.00,0.00,0.00,50.00,4100.00,'2021-12-31 07:09:37','',''),(2407735,'1','148','769',327,'Retail Sale Id 1433261',53000.00,0.00,0.00,100.00,2000.00,'2021-12-31 07:10:29','',''),(2407739,'1','148','769',327,'Retail Sale Id 1433264',12432.00,0.00,0.00,21.00,1722.00,'2021-12-31 07:10:52','',''),(2407751,'1','148','769',327,'Retail Sale Id 1433274',3001.44,0.00,0.00,5.07,415.74,'2021-12-31 07:12:08','',''),(2407759,'1','148','769',327,'Retail Sale Id 1433285',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 07:13:04','',''),(2407795,'1','148','769',327,'Retail Sale Id 1433320',2000.96,0.00,0.00,3.38,277.16,'2021-12-31 07:17:12','',''),(2407798,'1','148','769',327,'Retail Sale Id 1433322',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 07:17:47','',''),(2407820,'1','148','769',327,'Retail Sale Id 1433348',1000.48,0.00,0.00,1.69,138.58,'2021-12-31 07:20:23','',''),(2407828,'1','148','769',327,'Retail Sale Id 1433354',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 07:21:27','',''),(2407834,'1','148','769',327,'Retail Sale Id 1433364',6002.88,0.00,0.00,10.14,831.48,'2021-12-31 07:22:13','',''),(2407843,'1','148','769',327,'Retail Sale Id 1433375',2000.96,0.00,0.00,3.38,277.16,'2021-12-31 07:22:54','',''),(2407856,'1','148','769',327,'Retail Sale Id 1433382',1302.40,0.00,0.00,2.20,180.40,'2021-12-31 07:24:11','',''),(2407860,'1','148','769',327,'Retail Sale Id 1433387',3001.44,0.00,0.00,5.07,415.74,'2021-12-31 07:24:44','',''),(2407879,'1','148','769',327,'Retail Sale Id 1433399',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 07:26:13','',''),(2407900,'1','148','769',327,'Retail Sale Id 1433410',2397.60,0.00,0.00,4.05,332.10,'2021-12-31 07:27:04','',''),(2407925,'1','148','769',327,'Retail Sale Id 1433423',1799.68,0.00,0.00,3.04,249.28,'2021-12-31 07:27:52','',''),(2407945,'1','148','769',327,'Retail Sale Id 1433434',26500.00,0.00,0.00,50.00,1000.00,'2021-12-31 07:29:13','',''),(2407968,'1','148','769',327,'Retail Sale Id 1433447',1497.76,0.00,0.00,2.53,207.46,'2021-12-31 07:30:05','',''),(2407998,'1','148','769',327,'Retail Sale Id 1433460',2000.96,0.00,0.00,3.38,277.16,'2021-12-31 07:32:01','',''),(2408008,'1','148','769',327,'Retail Sale Id 1433473',3498.72,0.00,0.00,5.91,484.62,'2021-12-31 07:33:03','',''),(2408016,'1','148','769',327,'Retail Sale Id 1433483',2498.24,0.00,0.00,4.22,346.04,'2021-12-31 07:33:58','',''),(2408048,'1','148','769',327,'Retail Sale Id 1433514',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 07:37:12','',''),(2408065,'1','148','769',327,'Retail Sale Id 1433523',24910.00,0.00,0.00,47.00,940.00,'2021-12-31 07:38:50','',''),(2408078,'1','148','769',327,'Retail Sale Id 1433533',3001.44,0.00,0.00,5.07,415.74,'2021-12-31 07:39:32','',''),(2408084,'1','148','769',327,'Retail Sale Id 1433539',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 07:40:12','',''),(2408094,'1','148','769',327,'Retail Sale Id 1433550',2000.96,0.00,0.00,3.38,277.16,'2021-12-31 07:41:27','',''),(2408113,'1','148','769',327,'Retail Sale Id 1433564',1799.68,0.00,0.00,3.04,249.28,'2021-12-31 07:42:54','',''),(2408131,'1','148','769',327,'Retail Sale Id 1433580',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 07:44:10','',''),(2408196,'1','148','769',327,'Retail Sale Id 1433639',1497.76,0.00,0.00,2.53,207.46,'2021-12-31 07:51:12','',''),(2408215,'1','148','769',327,'Retail Sale Id 1433653',3001.44,0.00,0.00,5.07,415.74,'2021-12-31 07:52:24','',''),(2408234,'1','148','769',327,'Retail Sale Id 1433661',6997.44,0.00,0.00,11.82,969.24,'2021-12-31 07:53:28','',''),(2408296,'1','148','769',327,'Retail Sale Id 1433699',2498.24,0.00,0.00,4.22,346.04,'2021-12-31 07:57:50','',''),(2408322,'1','148','769',327,'Retail Sale Id 1433727',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 08:01:26','',''),(2408332,'1','148','769',327,'Retail Sale Id 1433738',2000.96,0.00,0.00,3.38,277.16,'2021-12-31 08:02:19','',''),(2408359,'1','148','769',327,'Retail Sale Id 1433751',3700.00,0.00,0.00,6.25,512.50,'2021-12-31 08:03:43','',''),(2408366,'1','148','769',327,'Retail Sale Id 1433757',3001.44,0.00,0.00,5.07,415.74,'2021-12-31 08:04:17','',''),(2408383,'1','148','769',327,'Retail Sale Id 1433772',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 08:05:40','',''),(2408400,'1','148','769',327,'Retail Sale Id 1433791',4149.92,0.00,0.00,7.01,574.82,'2021-12-31 08:07:14','',''),(2408409,'1','148','769',327,'Retail Sale Id 1433802',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 08:07:53','',''),(2408429,'1','148','769',327,'Retail Sale Id 1433824',4801.12,0.00,0.00,8.11,665.02,'2021-12-31 08:10:16','',''),(2408445,'1','148','769',327,'Retail Sale Id 1433836',3001.44,0.00,0.00,5.07,415.74,'2021-12-31 08:11:12','',''),(2408467,'1','148','769',327,'Retail Sale Id 1433859',1799.68,0.00,0.00,3.04,249.28,'2021-12-31 08:13:15','',''),(2408474,'1','148','769',327,'Retail Sale Id 1433867',3001.44,0.00,0.00,5.07,415.74,'2021-12-31 08:13:59','',''),(2408482,'1','148','769',327,'Retail Sale Id 1433873',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 08:14:45','',''),(2408496,'1','148','769',327,'Retail Sale Id 1433885',4001.92,0.00,0.00,6.76,554.32,'2021-12-31 08:15:41','',''),(2408506,'1','148','769',327,'Retail Sale Id 1433897',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 08:16:29','',''),(2408522,'1','148','769',327,'Retail Sale Id 1433909',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 08:17:34','',''),(2408605,'1','148','769',327,'Retail Sale Id 1433972',2498.24,0.00,0.00,4.22,346.04,'2021-12-31 08:24:12','',''),(2408649,'1','148','769',327,'Retail Sale Id 1434013',3700.00,0.00,0.00,6.25,512.50,'2021-12-31 08:28:12','',''),(2408675,'1','148','769',327,'Retail Sale Id 1434042',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 08:30:17','',''),(2408685,'1','148','769',327,'Retail Sale Id 1434055',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 08:31:05','',''),(2408697,'1','148','769',327,'Retail Sale Id 1434068',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 08:32:08','',''),(2408710,'1','148','769',327,'Retail Sale Id 1434086',6002.88,0.00,0.00,10.14,831.48,'2021-12-31 08:33:50','',''),(2408732,'1','148','769',327,'Retail Sale Id 1434106',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 08:36:04','',''),(2408783,'1','148','769',327,'Retail Sale Id 1434135',5499.68,0.00,0.00,9.29,761.78,'2021-12-31 08:38:43','',''),(2408795,'1','148','769',327,'Retail Sale Id 1434148',5002.40,0.00,0.00,8.45,692.90,'2021-12-31 08:39:51','',''),(2408804,'1','148','769',327,'Retail Sale Id 1434156',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 08:40:33','',''),(2408825,'1','148','769',327,'Retail Sale Id 1434179',6997.44,0.00,0.00,11.82,969.24,'2021-12-31 08:42:06','',''),(2408855,'1','148','769',327,'Retail Sale Id 1434207',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 08:44:11','',''),(2408868,'1','148','769',327,'Retail Sale Id 1434214',2000.96,0.00,0.00,3.38,277.16,'2021-12-31 08:44:44','',''),(2408881,'1','148','769',327,'Retail Sale Id 1434224',4001.92,0.00,0.00,6.76,554.32,'2021-12-31 08:45:50','',''),(2408901,'1','148','769',327,'Retail Sale Id 1434243',1201.76,0.00,0.00,2.03,166.46,'2021-12-31 08:47:04','',''),(2408942,'1','148','769',327,'Retail Sale Id 1434276',3001.44,0.00,0.00,5.07,415.74,'2021-12-31 08:49:47','',''),(2408948,'1','148','769',327,'Retail Sale Id 1434286',10999.36,0.00,0.00,18.58,1523.56,'2021-12-31 08:50:36','',''),(2408961,'1','148','769',327,'Retail Sale Id 1434299',4001.92,0.00,0.00,6.76,554.32,'2021-12-31 08:51:42','',''),(2408971,'1','148','769',327,'Retail Sale Id 1434309',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 08:52:35','',''),(2409196,'1','148','769',327,'Retail Sale Id 1434504',84800.00,0.00,0.00,160.00,3200.00,'2021-12-31 09:13:10','',''),(2409256,'1','148','769',327,'Retail Sale Id 1434556',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 09:19:17','',''),(2411317,'1','148','769',327,'Return of Retail Sale Id 1434286',0.00,10999.36,18.58,0.00,-1523.56,'2021-12-31 13:31:48','',''),(2411325,'1','148','769',327,'Return of Retail Sale Id 1433580',0.00,7400.00,12.50,0.00,-1025.00,'2021-12-31 13:32:49','',''),(2411329,'1','148','769',327,'Return of Retail Sale Id 1433802',0.00,7400.00,12.50,0.00,-1025.00,'2021-12-31 13:33:20','',''),(2411339,'1','148','769',327,'Return of Retail Sale Id 1434504',0.00,84800.00,160.00,0.00,-3200.00,'2021-12-31 13:35:08','',''),(2411343,'1','148','769',327,'Return of Retail Sale Id 1433523',0.00,24910.00,47.00,0.00,-940.00,'2021-12-31 13:35:36','',''),(2412001,'1','148','769',327,'Retail Sale Id 1437015',6500.16,0.00,0.00,10.98,900.36,'2021-12-31 14:34:11','',''),(2412008,'1','148','769',327,'Retail Sale Id 1437019',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 14:34:47','',''),(2412020,'1','148','769',327,'Retail Sale Id 1437030',2498.24,0.00,0.00,4.22,346.04,'2021-12-31 14:35:49','',''),(2412535,'1','148','769',327,'Retail Sale Id 1437445',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 15:22:37','',''),(2413033,'1','148','769',327,'Retail Sale Id 1437829',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 15:56:15','',''),(2413300,'1','148','769',327,'Retail Sale Id 1438074',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 16:21:33','',''),(2413365,'1','148','769',327,'Retail Sale Id 1438176',6002.88,0.00,0.00,10.14,831.48,'2021-12-31 16:28:45','',''),(2413377,'1','148','769',327,'Retail Sale Id 1438188',1000.48,0.00,0.00,1.69,138.58,'2021-12-31 16:29:51','',''),(2413386,'1','148','769',327,'Retail Sale Id 1438197',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 16:31:17','',''),(2413509,'1','148','769',327,'Retail Sale Id 1438291',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 16:39:41','',''),(2414511,'1','148','769',327,'Retail Sale Id 1438886',58236.40,0.00,0.00,109.88,2197.60,'2022-01-01 06:18:25','',''),(2414626,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,2641800.00,5180.00,0.00,0.00,'2022-01-01 06:49:24','',''),(2414636,'1','148',NULL,327,'Reception corrector for bridging 129388',0.00,0.00,0.00,5180.00,0.00,'2022-01-01 06:51:05','',''),(2414637,'1','148','769',327,'Received from bridging 129388',0.00,0.00,5180.00,0.00,0.00,'2022-01-01 06:51:05','',''),(2414642,'1','148','769',327,'Retail Sale Id 1438992',427074.72,0.00,0.00,721.41,59155.62,'2022-01-01 06:52:25','',''),(2414650,'1','148','769',327,'Retail Sale Id 1439001',1570633.80,0.00,0.00,2963.46,59269.20,'2022-01-01 06:53:53','',''),(2414663,'1','148','769',327,'Retail Sale Id 1439012',95483.68,0.00,0.00,161.29,13225.78,'2022-01-01 06:55:22','',''),(2420658,'1','148','769',327,'Retail Sale Id 1443786',264091.20,0.00,0.00,446.10,36580.20,'2022-01-02 06:05:09','',''),(2420659,'1','148','769',327,'Retail Sale Id 1443787',404814.00,0.00,0.00,763.80,15276.00,'2022-01-02 06:07:01','',''),(2420660,'1','148','769',327,'Retail Sale Id 1443788',85206.56,0.00,0.00,143.93,11802.26,'2022-01-02 06:08:30','',''),(2420712,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,2983000.00,5966.00,0.00,0.00,'2022-01-02 06:33:08','',''),(2420720,'1','148',NULL,327,'Reception corrector for bridging 129480',0.00,0.00,0.00,5966.00,0.00,'2022-01-02 06:34:23','',''),(2420721,'1','148','769',327,'Received from bridging 129480',0.00,0.00,5966.00,0.00,0.00,'2022-01-02 06:34:23','',''),(2421021,'1','148','769',327,'Retail Sale Id 1444005',63600.00,0.00,0.00,120.00,3600.00,'2022-01-02 07:10:21','',''),(2421045,'1','148','769',327,'Retail Sale Id 1444022',3599.36,0.00,0.00,6.08,559.36,'2022-01-02 07:12:21','',''),(2421159,'1','148','769',327,'Retail Sale Id 1444113',1799.68,0.00,0.00,3.04,279.68,'2022-01-02 07:28:53','',''),(2421227,'1','148','769',327,'Retail Sale Id 1444177',3599.36,0.00,0.00,6.08,559.36,'2022-01-02 07:40:34','',''),(2421239,'1','148','769',327,'Retail Sale Id 1444186',1799.68,0.00,0.00,3.04,279.68,'2022-01-02 07:41:36','',''),(2421252,'1','148','769',327,'Retail Sale Id 1444197',3599.36,0.00,0.00,6.08,559.36,'2022-01-02 07:44:32','',''),(2421269,'1','148','769',327,'Retail Sale Id 1444215',1000.48,0.00,0.00,1.69,155.48,'2022-01-02 07:47:22','',''),(2421275,'1','148','769',327,'Retail Sale Id 1444220',7400.00,0.00,0.00,12.50,1150.00,'2022-01-02 07:48:16','',''),(2421316,'1','148','769',327,'Retail Sale Id 1444272',94340.00,0.00,0.00,178.00,5340.00,'2022-01-02 07:54:52','',''),(2421331,'1','148','769',327,'Retail Sale Id 1444286',53000.00,0.00,0.00,100.00,3000.00,'2022-01-02 07:58:04','',''),(2421381,'1','148','769',327,'Retail Sale Id 1444337',1497.76,0.00,0.00,2.53,232.76,'2022-01-02 08:06:13','',''),(2421405,'1','148','769',327,'Retail Sale Id 1444348',7400.00,0.00,0.00,12.50,1150.00,'2022-01-02 08:07:48','',''),(2421840,'1','148','769',327,'Retail Sale Id 1444733',84270.00,0.00,0.00,159.00,4770.00,'2022-01-02 09:01:56','',''),(2421847,'1','148','769',327,'Retail Sale Id 1444740',7400.00,0.00,0.00,12.50,1150.00,'2022-01-02 09:02:33','',''),(2421896,'1','148','769',327,'Retail Sale Id 1444789',29600.00,0.00,0.00,50.00,4600.00,'2022-01-02 09:09:46','',''),(2421905,'1','148','769',327,'Retail Sale Id 1444798',7400.00,0.00,0.00,12.50,1150.00,'2022-01-02 09:10:54','',''),(2421954,'1','148','769',327,'Retail Sale Id 1444857',2900.80,0.00,0.00,4.90,450.80,'2022-01-02 09:17:51','',''),(2421963,'1','148','769',327,'Retail Sale Id 1444867',2000.96,0.00,0.00,3.38,310.96,'2022-01-02 09:20:02','',''),(2422000,'1','148','769',327,'Retail Sale Id 1444907',7696.00,0.00,0.00,13.00,1196.00,'2022-01-02 09:24:38','',''),(2422006,'1','148','769',327,'Retail Sale Id 1444911',1201.76,0.00,0.00,2.03,186.76,'2022-01-02 09:25:26','',''),(2422021,'1','148','769',327,'Retail Sale Id 1444926',1799.68,0.00,0.00,3.04,279.68,'2022-01-02 09:26:33','',''),(2422027,'1','148','769',327,'Retail Sale Id 1444931',2699.52,0.00,0.00,4.56,419.52,'2022-01-02 09:27:36','',''),(2422099,'1','148','769',327,'Retail Sale Id 1444972',3001.44,0.00,0.00,5.07,466.44,'2022-01-02 09:33:30','',''),(2422130,'1','148','769',327,'Retail Sale Id 1445003',7400.00,0.00,0.00,12.50,1150.00,'2022-01-02 09:36:52','',''),(2422142,'1','148','769',327,'Retail Sale Id 1445017',10600.00,0.00,0.00,20.00,600.00,'2022-01-02 09:38:14','',''),(2422221,'1','148','769',327,'Retail Sale Id 1445066',29150.00,0.00,0.00,55.00,1650.00,'2022-01-02 09:45:03','',''),(2422235,'1','148','769',327,'Retail Sale Id 1445086',5002.40,0.00,0.00,8.45,777.40,'2022-01-02 09:47:00','',''),(2422296,'1','148','769',327,'Retail Sale Id 1445138',2000.96,0.00,0.00,3.38,310.96,'2022-01-02 09:55:21','',''),(2422306,'1','148','769',327,'Retail Sale Id 1445148',7400.00,0.00,0.00,12.50,1150.00,'2022-01-02 09:56:16','',''),(2422312,'1','148','769',327,'Retail Sale Id 1445152',2000.96,0.00,0.00,3.38,310.96,'2022-01-02 09:57:28','',''),(2422324,'1','148','769',327,'Retail Sale Id 1445166',3599.36,0.00,0.00,6.08,559.36,'2022-01-02 09:58:21','',''),(2422332,'1','148','769',327,'Retail Sale Id 1445175',2000.96,0.00,0.00,3.38,310.96,'2022-01-02 09:59:49','',''),(2422344,'1','148','769',327,'Retail Sale Id 1445187',2397.60,0.00,0.00,4.05,372.60,'2022-01-02 10:01:58','',''),(2422360,'1','148','769',327,'Retail Sale Id 1445205',50880.00,0.00,0.00,96.00,2880.00,'2022-01-02 10:04:51','',''),(2422387,'1','148','769',327,'Retail Sale Id 1445224',1000.48,0.00,0.00,1.69,155.48,'2022-01-02 10:07:07','',''),(2422395,'1','148','769',327,'Retail Sale Id 1445231',1000.48,0.00,0.00,1.69,155.48,'2022-01-02 10:07:42','',''),(2422415,'1','148','769',327,'Retail Sale Id 1445256',2000.96,0.00,0.00,3.38,310.96,'2022-01-02 10:10:13','',''),(2422424,'1','148','769',327,'Retail Sale Id 1445264',3599.36,0.00,0.00,6.08,559.36,'2022-01-02 10:11:31','',''),(2422489,'1','148','769',327,'Retail Sale Id 1445307',3599.36,0.00,0.00,6.08,559.36,'2022-01-02 10:17:22','',''),(2422513,'1','148','769',327,'Retail Sale Id 1445331',7400.00,0.00,0.00,12.50,1150.00,'2022-01-02 10:20:20','',''),(2423018,'1','148','769',327,'Retail Sale Id 1445787',29600.00,0.00,0.00,50.00,4600.00,'2022-01-02 11:11:51','',''),(2423189,'1','148','769',327,'Retail Sale Id 1445964',140450.00,0.00,0.00,265.00,7950.00,'2022-01-02 11:29:16','',''),(2423235,'1','148','769',327,'Retail Sale Id 1446011',3599.36,0.00,0.00,6.08,559.36,'2022-01-02 11:33:55','',''),(2423293,'1','148','769',327,'Retail Sale Id 1446072',44400.00,0.00,0.00,75.00,6900.00,'2022-01-02 11:41:14','',''),(2423314,'1','148','769',327,'Retail Sale Id 1446089',3001.44,0.00,0.00,5.07,466.44,'2022-01-02 11:43:26','',''),(2423327,'1','148','769',327,'Retail Sale Id 1446105',3001.44,0.00,0.00,5.07,466.44,'2022-01-02 11:45:29','',''),(2423368,'1','148','769',327,'Retail Sale Id 1446148',7400.00,0.00,0.00,12.50,1150.00,'2022-01-02 11:51:38','',''),(2426398,'1','148','769',327,'Retail Sale Id 1448533',481361.12,0.00,0.00,813.11,74806.12,'2022-01-03 06:18:33','',''),(2426413,'1','148','769',327,'Retail Sale Id 1448535',670953.50,0.00,0.00,1265.95,37978.50,'2022-01-03 06:20:01','',''),(2426455,'1','148','769',327,'Retail Sale Id 1448550',3048.80,0.00,0.00,5.15,473.80,'2022-01-03 06:26:21','',''),(2427966,'1','148','769',327,'Retail Sale Id 1449958',140450.00,0.00,0.00,265.00,7950.00,'2022-01-03 09:48:45','',''),(2427973,'1','148','769',327,'Retail Sale Id 1449965',107060.00,0.00,0.00,202.00,6060.00,'2022-01-03 09:49:28','',''),(2427980,'1','148','769',327,'Retail Sale Id 1449973',29600.00,0.00,0.00,50.00,4600.00,'2022-01-03 09:49:54','',''),(2427988,'1','148','769',327,'Retail Sale Id 1449980',44400.00,0.00,0.00,75.00,6900.00,'2022-01-03 09:50:19','',''),(2427997,'1','148','769',327,'Retail Sale Id 1449988',7400.00,0.00,0.00,12.50,1150.00,'2022-01-03 09:50:58','',''),(2428005,'1','148','769',327,'Retail Sale Id 1449997',14800.00,0.00,0.00,25.00,2300.00,'2022-01-03 09:52:01','',''),(2428008,'1','148','769',327,'Retail Sale Id 1450000',10999.36,0.00,0.00,18.58,1709.36,'2022-01-03 09:52:40','',''),(2428015,'1','148','769',327,'Retail Sale Id 1450007',53000.00,0.00,0.00,100.00,3000.00,'2022-01-03 09:53:21','',''),(2428030,'1','148','769',327,'Retail Sale Id 1450021',26500.00,0.00,0.00,50.00,1500.00,'2022-01-03 09:55:00','',''),(2429911,'1','148','769',327,'Retail Sale Id 1451745',3599.36,0.00,0.00,6.08,559.36,'2022-01-03 13:35:37','',''),(2429954,'1','148','769',327,'Retail Sale Id 1451769',3001.44,0.00,0.00,5.07,466.44,'2022-01-03 13:38:14','',''),(2430005,'1','148','769',327,'Retail Sale Id 1451789',1799.68,0.00,0.00,3.04,279.68,'2022-01-03 13:40:35','',''),(2430129,'1','148','769',327,'Retail Sale Id 1451880',7400.00,0.00,0.00,12.50,1150.00,'2022-01-03 13:50:18','',''),(2430155,'1','148','769',327,'Retail Sale Id 1451906',1497.76,0.00,0.00,2.53,232.76,'2022-01-03 13:52:43','',''),(2430313,'1','148','769',327,'Retail Sale Id 1452017',2000.96,0.00,0.00,3.38,310.96,'2022-01-03 14:03:46','',''),(2430318,'1','148','769',327,'Retail Sale Id 1452024',1497.76,0.00,0.00,2.53,232.76,'2022-01-03 14:04:35','',''),(2430638,'1','148','769',327,'Retail Sale Id 1452251',95400.00,0.00,0.00,180.00,5400.00,'2022-01-03 14:35:19','',''),(2430644,'1','148','769',327,'Retail Sale Id 1452258',7400.00,0.00,0.00,12.50,1150.00,'2022-01-03 14:36:03','',''),(2430655,'1','148','769',327,'Retail Sale Id 1452268',79500.00,0.00,0.00,150.00,4500.00,'2022-01-03 14:37:18','',''),(2430660,'1','148','769',327,'Retail Sale Id 1452275',29600.00,0.00,0.00,50.00,4600.00,'2022-01-03 14:37:47','',''),(2430663,'1','148','769',327,'Retail Sale Id 1452277',3599.36,0.00,0.00,6.08,559.36,'2022-01-03 14:38:12','',''),(2430668,'1','148','769',327,'Retail Sale Id 1452282',10999.36,0.00,0.00,18.58,1709.36,'2022-01-03 14:38:48','',''),(2430673,'1','148','769',327,'Retail Sale Id 1452287',7400.00,0.00,0.00,12.50,1150.00,'2022-01-03 14:39:14','',''),(2430683,'1','148','769',327,'Retail Sale Id 1452298',132500.00,0.00,0.00,250.00,7500.00,'2022-01-03 14:40:17','',''),(2430698,'1','148','769',327,'Retail Sale Id 1452311',7400.00,0.00,0.00,12.50,1150.00,'2022-01-03 14:41:28','',''),(2430702,'1','148','769',327,'Retail Sale Id 1452315',10999.36,0.00,0.00,18.58,1709.36,'2022-01-03 14:41:55','',''),(2430752,'1','148','769',327,'Retail Sale Id 1452333',14800.00,0.00,0.00,25.00,2300.00,'2022-01-03 14:43:36','',''),(2430760,'1','148','769',327,'Retail Sale Id 1452342',7400.00,0.00,0.00,12.50,1150.00,'2022-01-03 14:44:02','',''),(2430787,'1','148','769',327,'Retail Sale Id 1452349',7400.00,0.00,0.00,12.50,1150.00,'2022-01-03 14:44:54','',''),(2430819,'1','148','769',327,'Retail Sale Id 1452363',13616.00,0.00,0.00,23.00,2116.00,'2022-01-03 14:47:04','',''),(2430832,'1','148','769',327,'Retail Sale Id 1452374',7400.00,0.00,0.00,12.50,1150.00,'2022-01-03 14:48:08','',''),(2430932,'1','148','769',327,'Retail Sale Id 1452459',3001.44,0.00,0.00,5.07,466.44,'2022-01-03 14:58:34','',''),(2431373,'1','148','769',327,'Retail Sale Id 1452800',3599.36,0.00,0.00,6.08,559.36,'2022-01-03 15:39:50','',''),(2431420,'1','148','769',327,'Retail Sale Id 1452847',2699.52,0.00,0.00,4.56,419.52,'2022-01-03 15:43:15','',''),(2431429,'1','148','769',327,'Retail Sale Id 1452858',3599.36,0.00,0.00,6.08,559.36,'2022-01-03 15:44:07','',''),(2431458,'1','148','769',327,'Retail Sale Id 1452884',1000.48,0.00,0.00,1.69,155.48,'2022-01-03 15:46:40','',''),(2431463,'1','148','769',327,'Retail Sale Id 1452889',3001.44,0.00,0.00,5.07,466.44,'2022-01-03 15:47:22','',''),(2431469,'1','148','769',327,'Retail Sale Id 1452897',2498.24,0.00,0.00,4.22,388.24,'2022-01-03 15:48:05','',''),(2431483,'1','148','769',327,'Retail Sale Id 1452912',3001.44,0.00,0.00,5.07,466.44,'2022-01-03 15:49:48','',''),(2431490,'1','148','769',327,'Retail Sale Id 1452921',8998.40,0.00,0.00,15.20,1398.40,'2022-01-03 15:50:24','',''),(2431524,'1','148','769',327,'Retail Sale Id 1452952',4001.92,0.00,0.00,6.76,621.92,'2022-01-03 15:53:14','',''),(2431535,'1','148','769',327,'Retail Sale Id 1452962',2000.96,0.00,0.00,3.38,310.96,'2022-01-03 15:54:31','',''),(2431546,'1','148','769',327,'Retail Sale Id 1452970',29600.00,0.00,0.00,50.00,4600.00,'2022-01-03 15:55:09','',''),(2431550,'1','148','769',327,'Retail Sale Id 1452974',1101.12,0.00,0.00,1.86,171.12,'2022-01-03 15:55:42','',''),(2431555,'1','148','769',327,'Retail Sale Id 1452979',14800.00,0.00,0.00,25.00,2300.00,'2022-01-03 15:56:04','',''),(2431569,'1','148','769',327,'Retail Sale Id 1452994',1799.68,0.00,0.00,3.04,279.68,'2022-01-03 15:57:37','',''),(2431588,'1','148','769',327,'Retail Sale Id 1453012',1799.68,0.00,0.00,3.04,279.68,'2022-01-03 15:58:57','',''),(2431618,'1','148','769',327,'Retail Sale Id 1453043',2000.96,0.00,0.00,3.38,310.96,'2022-01-03 16:01:36','',''),(2431811,'1','148','769',327,'Retail Sale Id 1453229',3599.36,0.00,0.00,6.08,559.36,'2022-01-03 16:20:11','',''),(2431819,'1','148','769',327,'Retail Sale Id 1453236',1000.48,0.00,0.00,1.69,155.48,'2022-01-03 16:20:52','',''),(2431830,'1','148','769',327,'Retail Sale Id 1453243',4001.92,0.00,0.00,6.76,621.92,'2022-01-03 16:21:36','',''),(2431839,'1','148','769',327,'Retail Sale Id 1453253',6997.44,0.00,0.00,11.82,1087.44,'2022-01-03 16:22:18','',''),(2431855,'1','148','769',327,'Retail Sale Id 1453261',1497.76,0.00,0.00,2.53,232.76,'2022-01-03 16:23:24','',''),(2431868,'1','148','769',327,'Retail Sale Id 1453277',2000.96,0.00,0.00,3.38,310.96,'2022-01-03 16:24:51','',''),(2431887,'1','148','769',327,'Retail Sale Id 1453298',3001.44,0.00,0.00,5.07,466.44,'2022-01-03 16:26:55','',''),(2431904,'1','148','769',327,'Retail Sale Id 1453324',2000.96,0.00,0.00,3.38,310.96,'2022-01-03 16:28:08','',''),(2431911,'1','148','769',327,'Retail Sale Id 1453331',2000.96,0.00,0.00,3.38,310.96,'2022-01-03 16:28:46','',''),(2431919,'1','148','769',327,'Retail Sale Id 1453338',1000.48,0.00,0.00,1.69,155.48,'2022-01-03 16:29:21','',''),(2431937,'1','148','769',327,'Retail Sale Id 1453353',3001.44,0.00,0.00,5.07,466.44,'2022-01-03 16:30:47','',''),(2431948,'1','148','769',327,'Retail Sale Id 1453363',3599.36,0.00,0.00,6.08,559.36,'2022-01-03 16:31:45','',''),(2431977,'1','148','769',327,'Retail Sale Id 1453390',3001.44,0.00,0.00,5.07,466.44,'2022-01-03 16:34:31','',''),(2431987,'1','148','769',327,'Retail Sale Id 1453393',2000.96,0.00,0.00,3.38,310.96,'2022-01-03 16:35:12','',''),(2431995,'1','148','769',327,'Retail Sale Id 1453401',1497.76,0.00,0.00,2.53,232.76,'2022-01-03 16:35:58','',''),(2431999,'1','148','769',327,'Retail Sale Id 1453406',3001.44,0.00,0.00,5.07,466.44,'2022-01-03 16:36:43','',''),(2432024,'1','148','769',327,'Retail Sale Id 1453427',2699.52,0.00,0.00,4.56,419.52,'2022-01-03 16:39:04','',''),(2432038,'1','148','769',327,'Retail Sale Id 1453438',2000.96,0.00,0.00,3.38,310.96,'2022-01-03 16:40:54','',''),(2432056,'1','148','769',327,'Retail Sale Id 1453455',7400.00,0.00,0.00,12.50,1150.00,'2022-01-03 16:42:48','',''),(2432066,'1','148','769',327,'Retail Sale Id 1453466',3001.44,0.00,0.00,5.07,466.44,'2022-01-03 16:44:26','',''),(2432095,'1','148','769',327,'Retail Sale Id 1453489',59200.00,0.00,0.00,100.00,9200.00,'2022-01-03 16:48:59','',''),(2433663,'1','148','769',327,'Retail Sale Id 1454358',130547.84,0.00,0.00,220.52,20287.84,'2022-01-04 07:53:29','',''),(2433686,'1','148','769',327,'Retail Sale Id 1454383',161692.40,0.00,0.00,305.08,9152.40,'2022-01-04 07:55:52','',''),(2434505,'1','148','769',327,'Retail Sale Id 1455078',7400.00,0.00,0.00,12.50,1150.00,'2022-01-04 09:09:54','',''),(2435073,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,2677500.00,5250.00,0.00,0.00,'2022-01-04 10:02:50','',''),(2435083,'1','148',NULL,327,'Reception corrector for bridging 129665',0.00,0.00,0.00,5250.00,0.00,'2022-01-04 10:04:23','',''),(2435084,'1','148','769',327,'Received from bridging 129665',0.00,0.00,5250.00,0.00,0.00,'2022-01-04 10:04:23','',''),(2435461,'1','148','769',327,'Retail Sale Id 1455862',140450.00,0.00,0.00,265.00,5300.00,'2022-01-04 10:38:14','',''),(2435468,'1','148','769',327,'Retail Sale Id 1455874',29600.00,0.00,0.00,50.00,4100.00,'2022-01-04 10:39:08','',''),(2435502,'1','148','769',327,'Retail Sale Id 1455889',10999.36,0.00,0.00,18.58,1523.56,'2022-01-04 10:41:38','',''),(2435638,'1','148','769',327,'Retail Sale Id 1456039',88510.00,0.00,0.00,167.00,3340.00,'2022-01-04 10:54:53','',''),(2435646,'1','148','769',327,'Retail Sale Id 1456046',84800.00,0.00,0.00,160.00,3200.00,'2022-01-04 10:55:32','',''),(2435647,'1','148','769',327,'Retail Sale Id 1456050',14800.00,0.00,0.00,25.00,2050.00,'2022-01-04 10:56:03','',''),(2435655,'1','148','769',327,'Retail Sale Id 1456055',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 10:56:32','',''),(2435662,'1','148','769',327,'Retail Sale Id 1456062',10999.36,0.00,0.00,18.58,1523.56,'2022-01-04 10:57:07','',''),(2435669,'1','148','769',327,'Retail Sale Id 1456068',29600.00,0.00,0.00,50.00,4100.00,'2022-01-04 10:57:34','',''),(2435675,'1','148','769',327,'Retail Sale Id 1456073',11840.00,0.00,0.00,20.00,1640.00,'2022-01-04 10:58:14','',''),(2435678,'1','148','769',327,'Retail Sale Id 1456077',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 10:58:40','',''),(2435684,'1','148','769',327,'Retail Sale Id 1456082',3800.64,0.00,0.00,6.42,526.44,'2022-01-04 10:59:11','',''),(2435690,'1','148','769',327,'Retail Sale Id 1456096',3599.36,0.00,0.00,6.08,498.56,'2022-01-04 10:59:39','',''),(2435703,'1','148','769',327,'Retail Sale Id 1456098',10656.00,0.00,0.00,18.00,1476.00,'2022-01-04 11:00:51','',''),(2435728,'1','148','769',327,'Retail Sale Id 1456129',5920.00,0.00,0.00,10.00,820.00,'2022-01-04 11:03:15','',''),(2435741,'1','148','769',327,'Retail Sale Id 1456138',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 11:03:51','',''),(2435748,'1','148','769',327,'Retail Sale Id 1456147',57770.00,0.00,0.00,109.00,2180.00,'2022-01-04 11:04:29','',''),(2435756,'1','148','769',327,'Retail Sale Id 1456156',14800.00,0.00,0.00,25.00,2050.00,'2022-01-04 11:05:21','',''),(2435764,'1','148','769',327,'Retail Sale Id 1456163',37100.00,0.00,0.00,70.00,1400.00,'2022-01-04 11:05:57','',''),(2436023,'1','148','769',327,'Retail Sale Id 1456392',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 11:28:33','',''),(2436092,'1','148','769',327,'Retail Sale Id 1456459',17760.00,0.00,0.00,30.00,2460.00,'2022-01-04 11:35:28','',''),(2436102,'1','148','769',327,'Retail Sale Id 1456469',1000.48,0.00,0.00,1.69,138.58,'2022-01-04 11:37:01','',''),(2436166,'1','148','769',327,'Retail Sale Id 1456526',1497.76,0.00,0.00,2.53,207.46,'2022-01-04 11:42:25','',''),(2436187,'1','148','769',327,'Retail Sale Id 1456544',799.20,0.00,0.00,1.35,110.70,'2022-01-04 11:44:38','',''),(2436213,'1','148','769',327,'Retail Sale Id 1456570',3599.36,0.00,0.00,6.08,498.56,'2022-01-04 11:48:25','',''),(2436414,'1','148','769',327,'Retail Sale Id 1456781',10999.36,0.00,0.00,18.58,1523.56,'2022-01-04 12:08:59','',''),(2436419,'1','148','769',327,'Retail Sale Id 1456784',14800.00,0.00,0.00,25.00,2050.00,'2022-01-04 12:09:25','',''),(2436420,'1','148','769',327,'Retail Sale Id 1456785',13320.00,0.00,0.00,22.50,1845.00,'2022-01-04 12:10:01','',''),(2436444,'1','148','769',327,'Retail Sale Id 1456809',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 12:12:55','',''),(2436725,'1','148','769',327,'Retail Sale Id 1457098',3001.44,0.00,0.00,5.07,415.74,'2022-01-04 12:43:20','',''),(2436741,'1','148','769',327,'Retail Sale Id 1457112',3599.36,0.00,0.00,6.08,498.56,'2022-01-04 12:45:54','',''),(2436771,'1','148','769',327,'Retail Sale Id 1457143',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 12:49:31','',''),(2436825,'1','148','769',327,'Retail Sale Id 1457191',3599.36,0.00,0.00,6.08,498.56,'2022-01-04 12:57:12','',''),(2436944,'1','148','769',327,'Retail Sale Id 1457304',497.28,0.00,0.00,0.84,68.88,'2022-01-04 13:08:05','',''),(2437007,'1','148','769',327,'Retail Sale Id 1457345',1900.32,0.00,0.00,3.21,263.22,'2022-01-04 13:14:53','',''),(2437018,'1','148','769',327,'Retail Sale Id 1457357',3001.44,0.00,0.00,5.07,415.74,'2022-01-04 13:16:57','',''),(2437050,'1','148','769',327,'Retail Sale Id 1457377',3599.36,0.00,0.00,6.08,498.56,'2022-01-04 13:19:34','',''),(2437144,'1','148','769',327,'Retail Sale Id 1457537',1497.76,0.00,0.00,2.53,207.46,'2022-01-04 13:30:52','',''),(2437200,'1','148','769',327,'Retail Sale Id 1457586',1799.68,0.00,0.00,3.04,249.28,'2022-01-04 13:33:38','',''),(2437238,'1','148','769',327,'Retail Sale Id 1457616',3599.36,0.00,0.00,6.08,498.56,'2022-01-04 13:36:22','',''),(2437242,'1','148','769',327,'Retail Sale Id 1457621',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 13:37:07','',''),(2437323,'1','148','769',327,'Retail Sale Id 1457670',1201.76,0.00,0.00,2.03,166.46,'2022-01-04 13:41:07','',''),(2437414,'1','148','769',327,'Retail Sale Id 1457738',2397.60,0.00,0.00,4.05,332.10,'2022-01-04 13:49:36','',''),(2437447,'1','148','769',327,'Retail Sale Id 1457759',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 13:52:06','',''),(2438008,'1','148','769',327,'Retail Sale Id 1458190',5499.68,0.00,0.00,9.29,761.78,'2022-01-04 14:40:14','',''),(2438080,'1','148','769',327,'Retail Sale Id 1458236',3001.44,0.00,0.00,5.07,415.74,'2022-01-04 14:44:50','',''),(2438109,'1','148','769',327,'Retail Sale Id 1458247',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 14:46:02','',''),(2439269,'1','148','769',327,'Retail Sale Id 1459249',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 16:21:43','',''),(2439706,'1','148','769',327,'Retail Sale Id 1459697',3599.36,0.00,0.00,6.08,498.56,'2022-01-04 17:23:08','',''),(2440455,'1','148','769',327,'Retail Sale Id 1459923',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 06:29:59','',''),(2440460,'1','148','769',327,'Retail Sale Id 1459929',1799.68,0.00,0.00,3.04,249.28,'2022-01-05 06:31:38','',''),(2440551,'1','148','769',327,'Retail Sale Id 1459970',3001.44,0.00,0.00,5.07,415.74,'2022-01-05 06:42:34','',''),(2440606,'1','148','769',327,'Retail Sale Id 1460018',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 06:51:50','',''),(2440714,'1','148','769',327,'Retail Sale Id 1460110',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 07:08:56','',''),(2440825,'1','148','769',327,'Retail Sale Id 1460209',3001.44,0.00,0.00,5.07,415.74,'2022-01-05 07:24:38','',''),(2440912,'1','148','769',327,'Retail Sale Id 1460288',36698.08,0.00,0.00,61.99,5083.18,'2022-01-05 07:34:53','',''),(2440986,'1','148','769',327,'Retail Sale Id 1460326',1000.48,0.00,0.00,1.69,138.58,'2022-01-05 07:38:04','',''),(2441365,'1','148','769',327,'Retail Sale Id 1460607',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 08:10:19','',''),(2442031,'1','148','769',327,'Retail Sale Id 1461128',2000.96,0.00,0.00,3.38,277.16,'2022-01-05 10:07:22','',''),(2442260,'1','148','769',327,'Retail Sale Id 1461326',14800.00,0.00,0.00,25.00,2050.00,'2022-01-05 10:28:34','',''),(2442449,'1','148','769',327,'Retail Sale Id 1461512',229944.64,0.00,0.00,388.42,31850.44,'2022-01-05 10:46:00','',''),(2442482,'1','148','769',327,'Retail Sale Id 1461539',320618.20,0.00,0.00,604.94,12098.80,'2022-01-05 10:49:11','',''),(2443057,'1','148','769',327,'Retail Sale Id 1462025',1000.48,0.00,0.00,1.69,138.58,'2022-01-05 11:37:32','',''),(2443308,'1','148','769',327,'Retail Sale Id 1462260',1497.76,0.00,0.00,2.53,207.46,'2022-01-05 11:59:22','',''),(2443317,'1','148','769',327,'Retail Sale Id 1462270',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 12:00:14','',''),(2443519,'1','148','769',327,'Retail Sale Id 1462476',3001.44,0.00,0.00,5.07,415.74,'2022-01-05 12:19:25','',''),(2443534,'1','148','769',327,'Retail Sale Id 1462493',2800.16,0.00,0.00,4.73,387.86,'2022-01-05 12:20:23','',''),(2443554,'1','148','769',327,'Retail Sale Id 1462514',1799.68,0.00,0.00,3.04,249.28,'2022-01-05 12:22:07','',''),(2443570,'1','148','769',327,'Retail Sale Id 1462531',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 12:23:10','',''),(2443642,'1','148','769',327,'Retail Sale Id 1462588',3001.44,0.00,0.00,5.07,415.74,'2022-01-05 12:29:21','',''),(2443652,'1','148','769',327,'Retail Sale Id 1462602',4001.92,0.00,0.00,6.76,554.32,'2022-01-05 12:30:30','',''),(2443711,'1','148','769',327,'Retail Sale Id 1462655',1397.12,0.00,0.00,2.36,193.52,'2022-01-05 12:36:42','',''),(2443862,'1','148','769',327,'Retail Sale Id 1462801',1000.48,0.00,0.00,1.69,138.58,'2022-01-05 12:51:45','',''),(2443877,'1','148','769',327,'Retail Sale Id 1462815',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 12:54:02','',''),(2443918,'1','148','769',327,'Retail Sale Id 1462855',23320.00,0.00,0.00,44.00,880.00,'2022-01-05 12:58:13','',''),(2443938,'1','148','769',327,'Retail Sale Id 1462874',6002.88,0.00,0.00,10.14,831.48,'2022-01-05 13:00:13','',''),(2443994,'1','148','769',327,'Retail Sale Id 1462928',4001.92,0.00,0.00,6.76,554.32,'2022-01-05 13:05:42','',''),(2444004,'1','148','769',327,'Retail Sale Id 1462937',27040.60,0.00,0.00,51.02,1020.40,'2022-01-05 13:06:49','',''),(2444027,'1','148','769',327,'Retail Sale Id 1462963',3001.44,0.00,0.00,5.07,415.74,'2022-01-05 13:09:01','',''),(2444033,'1','148','769',327,'Retail Sale Id 1462971',25000.16,0.00,0.00,42.23,3462.86,'2022-01-05 13:09:48','',''),(2444045,'1','148','769',327,'Retail Sale Id 1462980',15001.28,0.00,0.00,25.34,2077.88,'2022-01-05 13:10:39','',''),(2444056,'1','148','769',327,'Retail Sale Id 1462991',3001.44,0.00,0.00,5.07,415.74,'2022-01-05 13:11:45','',''),(2444157,'1','148','769',327,'Retail Sale Id 1463089',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 13:23:25','',''),(2444380,'1','148','769',327,'Retail Sale Id 1463276',3001.44,0.00,0.00,5.07,415.74,'2022-01-05 13:49:26','',''),(2444395,'1','148','769',327,'Retail Sale Id 1463290',5002.40,0.00,0.00,8.45,692.90,'2022-01-05 13:51:46','',''),(2444414,'1','148','769',327,'Retail Sale Id 1463309',140450.00,0.00,0.00,265.00,5300.00,'2022-01-05 13:54:13','',''),(2444419,'1','148','769',327,'Retail Sale Id 1463314',137800.00,0.00,0.00,260.00,5200.00,'2022-01-05 13:54:51','',''),(2444424,'1','148','769',327,'Retail Sale Id 1463320',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 13:55:37','',''),(2444432,'1','148','769',327,'Retail Sale Id 1463326',3001.44,0.00,0.00,5.07,415.74,'2022-01-05 13:56:26','',''),(2444865,'1','148','769',327,'Retail Sale Id 1463645',119250.00,0.00,0.00,225.00,4500.00,'2022-01-05 14:38:53','',''),(2444913,'1','148','769',327,'Retail Sale Id 1463686',1000.48,0.00,0.00,1.69,138.58,'2022-01-05 14:43:53','',''),(2444920,'1','148','769',327,'Retail Sale Id 1463691',3001.44,0.00,0.00,5.07,415.74,'2022-01-05 14:44:44','',''),(2444926,'1','148','769',327,'Retail Sale Id 1463699',6002.88,0.00,0.00,10.14,831.48,'2022-01-05 14:45:21','',''),(2444932,'1','148','769',327,'Retail Sale Id 1463703',29600.00,0.00,0.00,50.00,4100.00,'2022-01-05 14:46:01','',''),(2444949,'1','148','769',327,'Retail Sale Id 1463716',3001.44,0.00,0.00,5.07,415.74,'2022-01-05 14:47:28','',''),(2444964,'1','148','769',327,'Retail Sale Id 1463720',3001.44,0.00,0.00,5.07,415.74,'2022-01-05 14:48:05','',''),(2444972,'1','148','769',327,'Retail Sale Id 1463729',1000.48,0.00,0.00,1.69,138.58,'2022-01-05 14:49:43','',''),(2445007,'1','148','769',327,'Retail Sale Id 1463748',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 14:53:30','',''),(2445011,'1','148','769',327,'Retail Sale Id 1463751',1497.76,0.00,0.00,2.53,207.46,'2022-01-05 14:54:18','',''),(2445019,'1','148','769',327,'Retail Sale Id 1463758',1000.48,0.00,0.00,1.69,138.58,'2022-01-05 14:54:58','',''),(2445024,'1','148','769',327,'Retail Sale Id 1463763',1000.48,0.00,0.00,1.69,138.58,'2022-01-05 14:55:35','',''),(2445038,'1','148','769',327,'Retail Sale Id 1463775',1497.76,0.00,0.00,2.53,207.46,'2022-01-05 14:57:46','',''),(2445075,'1','148','769',327,'Retail Sale Id 1463805',2000.96,0.00,0.00,3.38,277.16,'2022-01-05 15:01:33','',''),(2445164,'1','148','769',327,'Retail Sale Id 1463855',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 15:09:10','',''),(2445212,'1','148','769',327,'Retail Sale Id 1463882',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 15:12:48','',''),(2445230,'1','148','769',327,'Retail Sale Id 1463890',3001.44,0.00,0.00,5.07,415.74,'2022-01-05 15:13:34','',''),(2445239,'1','148','769',327,'Retail Sale Id 1463893',1699.04,0.00,0.00,2.87,235.34,'2022-01-05 15:14:14','',''),(2445265,'1','148','769',327,'Retail Sale Id 1463910',5002.40,0.00,0.00,8.45,692.90,'2022-01-05 15:16:30','',''),(2445271,'1','148','769',327,'Retail Sale Id 1463916',1799.68,0.00,0.00,3.04,249.28,'2022-01-05 15:17:18','',''),(2445288,'1','148','769',327,'Retail Sale Id 1463925',1349.76,0.00,0.00,2.28,186.96,'2022-01-05 15:17:57','',''),(2445404,'1','148','769',327,'Retail Sale Id 1463970',2498.24,0.00,0.00,4.22,346.04,'2022-01-05 15:23:44','',''),(2445422,'1','148','769',327,'Retail Sale Id 1463989',3001.44,0.00,0.00,5.07,415.74,'2022-01-05 15:25:44','',''),(2445429,'1','148','769',327,'Retail Sale Id 1463995',5002.40,0.00,0.00,8.45,692.90,'2022-01-05 15:26:32','',''),(2445435,'1','148','769',327,'Retail Sale Id 1464002',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 15:27:14','',''),(2445441,'1','148','769',327,'Retail Sale Id 1464010',2498.24,0.00,0.00,4.22,346.04,'2022-01-05 15:28:04','',''),(2445448,'1','148','769',327,'Retail Sale Id 1464015',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 15:29:05','',''),(2445469,'1','148','769',327,'Retail Sale Id 1464033',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 15:31:24','',''),(2445489,'1','148','769',327,'Retail Sale Id 1464049',1201.76,0.00,0.00,2.03,166.46,'2022-01-05 15:33:36','',''),(2445543,'1','148','769',327,'Retail Sale Id 1464071',3001.44,0.00,0.00,5.07,415.74,'2022-01-05 15:36:11','',''),(2445571,'1','148','769',327,'Retail Sale Id 1464089',2000.96,0.00,0.00,3.38,277.16,'2022-01-05 15:38:00','',''),(2445609,'1','148','769',327,'Retail Sale Id 1464121',1799.68,0.00,0.00,3.04,249.28,'2022-01-05 15:42:25','',''),(2445614,'1','148','769',327,'Retail Sale Id 1464124',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 15:43:05','',''),(2445625,'1','148','769',327,'Retail Sale Id 1464136',1201.76,0.00,0.00,2.03,166.46,'2022-01-05 15:44:16','',''),(2445643,'1','148','769',327,'Retail Sale Id 1464154',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 15:45:55','',''),(2445657,'1','148','769',327,'Retail Sale Id 1464166',3001.44,0.00,0.00,5.07,415.74,'2022-01-05 15:46:50','',''),(2445672,'1','148','769',327,'Retail Sale Id 1464179',1752.32,0.00,0.00,2.96,242.72,'2022-01-05 15:47:46','',''),(2445749,'1','148','769',327,'Retail Sale Id 1464242',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 15:54:48','',''),(2445761,'1','148','769',327,'Retail Sale Id 1464254',497.28,0.00,0.00,0.84,68.88,'2022-01-05 15:55:45','',''),(2445767,'1','148','769',327,'Retail Sale Id 1464261',6547.52,0.00,0.00,11.06,906.92,'2022-01-05 15:56:37','',''),(2445807,'1','148','769',327,'Retail Sale Id 1464298',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 16:01:10','',''),(2445825,'1','148','769',327,'Retail Sale Id 1464316',1000.48,0.00,0.00,1.69,138.58,'2022-01-05 16:03:18','',''),(2445859,'1','148','769',327,'Retail Sale Id 1464328',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 16:05:40','',''),(2445892,'1','148','769',327,'Retail Sale Id 1464357',2397.60,0.00,0.00,4.05,332.10,'2022-01-05 16:09:17','',''),(2445898,'1','148','769',327,'Retail Sale Id 1464364',1799.68,0.00,0.00,3.04,249.28,'2022-01-05 16:10:16','',''),(2445906,'1','148','769',327,'Retail Sale Id 1464373',4001.92,0.00,0.00,6.76,554.32,'2022-01-05 16:11:25','',''),(2445913,'1','148','769',327,'Retail Sale Id 1464379',1799.68,0.00,0.00,3.04,249.28,'2022-01-05 16:12:14','',''),(2446357,'1','148','769',327,'Retail Sale Id 1464750',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 16:52:09','',''),(2446411,'1','148','769',327,'Retail Sale Id 1464797',44400.00,0.00,0.00,75.00,6150.00,'2022-01-05 16:56:15','',''),(2446418,'1','148','769',327,'Retail Sale Id 1464803',5002.40,0.00,0.00,8.45,692.90,'2022-01-05 16:56:54','',''),(2446426,'1','148','769',327,'Retail Sale Id 1464811',2000.96,0.00,0.00,3.38,277.16,'2022-01-05 16:57:43','',''),(2446435,'1','148','769',327,'Retail Sale Id 1464819',1000.48,0.00,0.00,1.69,138.58,'2022-01-05 16:58:30','',''),(2446454,'1','148','769',327,'Retail Sale Id 1464830',132500.00,0.00,0.00,250.00,5000.00,'2022-01-05 16:59:22','',''),(2446456,'1','148','769',327,'Retail Sale Id 1464831',29600.00,0.00,0.00,50.00,4100.00,'2022-01-05 16:59:52','',''),(2446535,'1','148','769',327,'Retail Sale Id 1464885',5002.40,0.00,0.00,8.45,692.90,'2022-01-05 17:05:40','',''),(2446544,'1','148','769',327,'Retail Sale Id 1464892',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 17:06:23','',''),(2446548,'1','148','769',327,'Retail Sale Id 1464899',1000.48,0.00,0.00,1.69,138.58,'2022-01-05 17:07:02','',''),(2446588,'1','148','769',327,'Retail Sale Id 1464939',5002.40,0.00,0.00,8.45,692.90,'2022-01-05 17:10:50','',''),(2446597,'1','148','769',327,'Retail Sale Id 1464945',2498.24,0.00,0.00,4.22,346.04,'2022-01-05 17:11:37','',''),(2446610,'1','148','769',327,'Retail Sale Id 1464961',3700.00,0.00,0.00,6.25,512.50,'2022-01-05 17:13:06','',''),(2446650,'1','148','769',327,'Retail Sale Id 1464991',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 17:16:04','',''),(2446662,'1','148','769',327,'Retail Sale Id 1465005',3700.00,0.00,0.00,6.25,512.50,'2022-01-05 17:17:03','',''),(2446676,'1','148','769',327,'Retail Sale Id 1465021',3001.44,0.00,0.00,5.07,415.74,'2022-01-05 17:18:07','',''),(2446689,'1','148','769',327,'Retail Sale Id 1465036',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 17:19:09','',''),(2446703,'1','148','769',327,'Retail Sale Id 1465049',4499.20,0.00,0.00,7.60,623.20,'2022-01-05 17:20:14','',''),(2446726,'1','148','769',327,'Retail Sale Id 1465064',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 17:21:59','',''),(2446735,'1','148','769',327,'Retail Sale Id 1465077',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 17:22:45','',''),(2449397,'1','148','769',327,'Retail Sale Id 1466825',196224.32,0.00,0.00,331.46,27179.72,'2022-01-06 09:24:52','',''),(2449463,'1','148','769',327,'Retail Sale Id 1466859',322568.60,0.00,0.00,608.62,12172.40,'2022-01-06 09:27:04','',''),(2449631,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,2641800.00,5180.00,0.00,0.00,'2022-01-06 09:42:43','',''),(2449689,'1','148',NULL,327,'Reception corrector for bridging 129938',0.00,0.00,0.00,5180.00,0.00,'2022-01-06 09:47:17','',''),(2449690,'1','148','769',327,'Received from bridging 129938',0.00,0.00,5180.00,0.00,0.00,'2022-01-06 09:47:17','',''),(2449749,'1','148','769',327,'Retail Sale Id 1467124',84800.00,0.00,0.00,160.00,3200.00,'2022-01-06 09:53:34','',''),(2449756,'1','148','769',327,'Retail Sale Id 1467129',10999.36,0.00,0.00,18.58,1523.56,'2022-01-06 09:54:00','',''),(2449757,'1','148','769',327,'Retail Sale Id 1467132',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 09:54:26','',''),(2449873,'1','148','769',327,'Retail Sale Id 1467270',84270.00,0.00,0.00,159.00,3180.00,'2022-01-06 10:09:23','',''),(2449895,'1','148','769',327,'Retail Sale Id 1467300',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 10:12:10','',''),(2449919,'1','148','769',327,'Retail Sale Id 1467329',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 10:14:34','',''),(2449984,'1','148','769',327,'Retail Sale Id 1467388',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 10:20:31','',''),(2450147,'1','148','769',327,'Retail Sale Id 1467467',31800.00,0.00,0.00,60.00,1200.00,'2022-01-06 10:29:25','',''),(2450161,'1','148','769',327,'Retail Sale Id 1467483',29600.00,0.00,0.00,50.00,4100.00,'2022-01-06 10:30:03','',''),(2450194,'1','148','769',327,'Retail Sale Id 1467513',44520.00,0.00,0.00,84.00,1680.00,'2022-01-06 10:34:24','',''),(2450243,'1','148','769',327,'Retail Sale Id 1467534',4001.92,0.00,0.00,6.76,554.32,'2022-01-06 10:36:55','',''),(2450248,'1','148','769',327,'Retail Sale Id 1467544',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 10:37:32','',''),(2450261,'1','148','769',327,'Retail Sale Id 1467555',1201.76,0.00,0.00,2.03,166.46,'2022-01-06 10:38:16','',''),(2450277,'1','148','769',327,'Retail Sale Id 1467572',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 10:39:15','',''),(2450283,'1','148','769',327,'Retail Sale Id 1467582',6997.44,0.00,0.00,11.82,969.24,'2022-01-06 10:40:00','',''),(2450290,'1','148','769',327,'Retail Sale Id 1467587',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 10:40:49','',''),(2450308,'1','148','769',327,'Retail Sale Id 1467597',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 10:41:35','',''),(2450340,'1','148','769',327,'Retail Sale Id 1467622',2000.96,0.00,0.00,3.38,277.16,'2022-01-06 10:44:28','',''),(2450377,'1','148','769',327,'Retail Sale Id 1467661',26500.00,0.00,0.00,50.00,1000.00,'2022-01-06 10:49:10','',''),(2450423,'1','148','769',327,'Retail Sale Id 1467708',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 10:56:32','',''),(2450435,'1','148','769',327,'Retail Sale Id 1467718',2000.96,0.00,0.00,3.38,277.16,'2022-01-06 10:57:12','',''),(2450802,'1','148','769',327,'Retail Sale Id 1468084',2397.60,0.00,0.00,4.05,332.10,'2022-01-06 11:34:49','',''),(2450810,'1','148','769',327,'Retail Sale Id 1468088',2000.96,0.00,0.00,3.38,277.16,'2022-01-06 11:35:34','',''),(2450821,'1','148','769',327,'Retail Sale Id 1468100',1799.68,0.00,0.00,3.04,249.28,'2022-01-06 11:36:17','',''),(2450852,'1','148','769',327,'Retail Sale Id 1468130',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 11:38:42','',''),(2450860,'1','148','769',327,'Retail Sale Id 1468149',4001.92,0.00,0.00,6.76,554.32,'2022-01-06 11:39:39','',''),(2450876,'1','148','769',327,'Retail Sale Id 1468162',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 11:41:38','',''),(2450894,'1','148','769',327,'Retail Sale Id 1468178',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 11:42:56','',''),(2450909,'1','148','769',327,'Retail Sale Id 1468196',5002.40,0.00,0.00,8.45,692.90,'2022-01-06 11:44:06','',''),(2450960,'1','148','769',327,'Retail Sale Id 1468230',2000.96,0.00,0.00,3.38,277.16,'2022-01-06 11:47:31','',''),(2450983,'1','148','769',327,'Retail Sale Id 1468241',1799.68,0.00,0.00,3.04,249.28,'2022-01-06 11:48:56','',''),(2451030,'1','148','769',327,'Retail Sale Id 1468333',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 11:55:01','',''),(2451038,'1','148','769',327,'Retail Sale Id 1468352',6002.88,0.00,0.00,10.14,831.48,'2022-01-06 11:55:59','',''),(2451057,'1','148','769',327,'Retail Sale Id 1468368',1201.76,0.00,0.00,2.03,166.46,'2022-01-06 11:57:53','',''),(2451076,'1','148','769',327,'Retail Sale Id 1468391',1000.48,0.00,0.00,1.69,138.58,'2022-01-06 12:00:17','',''),(2451111,'1','148','769',327,'Retail Sale Id 1468426',2000.96,0.00,0.00,3.38,277.16,'2022-01-06 12:03:35','',''),(2451147,'1','148','769',327,'Retail Sale Id 1468475',3001.44,0.00,0.00,5.07,415.74,'2022-01-06 12:07:58','',''),(2451251,'1','148','769',327,'Retail Sale Id 1468565',107060.00,0.00,0.00,202.00,4040.00,'2022-01-06 12:17:09','',''),(2451264,'1','148','769',327,'Retail Sale Id 1468577',3001.44,0.00,0.00,5.07,415.74,'2022-01-06 12:18:48','',''),(2451318,'1','148','769',327,'Retail Sale Id 1468618',2000.96,0.00,0.00,3.38,277.16,'2022-01-06 12:25:14','',''),(2451333,'1','148','769',327,'Retail Sale Id 1468633',2000.96,0.00,0.00,3.38,277.16,'2022-01-06 12:27:12','',''),(2451339,'1','148','769',327,'Retail Sale Id 1468637',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 12:27:46','',''),(2451367,'1','148','769',327,'Retail Sale Id 1468671',3001.44,0.00,0.00,5.07,415.74,'2022-01-06 12:30:58','',''),(2451392,'1','148','769',327,'Retail Sale Id 1468706',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 12:34:24','',''),(2451454,'1','148','769',327,'Retail Sale Id 1468786',3001.44,0.00,0.00,5.07,415.74,'2022-01-06 12:41:24','',''),(2451473,'1','148','769',327,'Retail Sale Id 1468800',60950.00,0.00,0.00,115.00,2300.00,'2022-01-06 12:42:45','',''),(2451500,'1','148','769',327,'Retail Sale Id 1468823',6002.88,0.00,0.00,10.14,831.48,'2022-01-06 12:45:28','',''),(2451507,'1','148','769',327,'Retail Sale Id 1468832',64660.00,0.00,0.00,122.00,2440.00,'2022-01-06 12:46:41','',''),(2451682,'1','148','769',327,'Retail Sale Id 1468986',1397.12,0.00,0.00,2.36,193.52,'2022-01-06 13:10:53','',''),(2451747,'1','148','769',327,'Retail Sale Id 1469041',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 13:16:35','',''),(2451783,'1','148','769',327,'Retail Sale Id 1469089',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 13:20:20','',''),(2451818,'1','148','769',327,'Retail Sale Id 1469114',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 13:22:30','',''),(2451823,'1','148','769',327,'Retail Sale Id 1469122',2000.96,0.00,0.00,3.38,277.16,'2022-01-06 13:23:49','',''),(2451864,'1','148','769',327,'Retail Sale Id 1469171',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 13:30:05','',''),(2451876,'1','148','769',327,'Retail Sale Id 1469183',2202.24,0.00,0.00,3.72,305.04,'2022-01-06 13:31:37','',''),(2451901,'1','148','769',327,'Retail Sale Id 1469217',3001.44,0.00,0.00,5.07,415.74,'2022-01-06 13:34:41','',''),(2452209,'1','148','769',327,'Retail Sale Id 1469529',2498.24,0.00,0.00,4.22,346.04,'2022-01-06 14:11:29','',''),(2452244,'1','148','769',327,'Retail Sale Id 1469548',2000.96,0.00,0.00,3.38,277.16,'2022-01-06 14:15:10','',''),(2452278,'1','148','769',327,'Retail Sale Id 1469572',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 14:19:50','',''),(2452328,'1','148','769',327,'Retail Sale Id 1469588',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 14:22:50','',''),(2452335,'1','148','769',327,'Retail Sale Id 1469595',3001.44,0.00,0.00,5.07,415.74,'2022-01-06 14:23:54','',''),(2452401,'1','148','769',327,'Retail Sale Id 1469647',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 14:31:41','',''),(2452527,'1','148','769',327,'Retail Sale Id 1469775',1000.48,0.00,0.00,1.69,138.58,'2022-01-06 14:47:15','',''),(2452638,'1','148','769',327,'Retail Sale Id 1469823',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 14:52:46','',''),(2452664,'1','148','769',327,'Retail Sale Id 1469834',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 14:53:39','',''),(2452741,'1','148','769',327,'Retail Sale Id 1469861',2498.24,0.00,0.00,4.22,346.04,'2022-01-06 14:56:34','',''),(2452751,'1','148','769',327,'Retail Sale Id 1469872',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 14:57:17','',''),(2452836,'1','148','769',327,'Retail Sale Id 1469911',1497.76,0.00,0.00,2.53,207.46,'2022-01-06 15:02:05','',''),(2452872,'1','148','769',327,'Retail Sale Id 1469924',3001.44,0.00,0.00,5.07,415.74,'2022-01-06 15:03:34','',''),(2452879,'1','148','769',327,'Retail Sale Id 1469932',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 15:04:24','',''),(2452898,'1','148','769',327,'Retail Sale Id 1469950',3001.44,0.00,0.00,5.07,415.74,'2022-01-06 15:06:42','',''),(2452909,'1','148','769',327,'Retail Sale Id 1469957',1000.48,0.00,0.00,1.69,138.58,'2022-01-06 15:07:37','',''),(2452998,'1','148','769',327,'Retail Sale Id 1470002',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 15:13:00','',''),(2453040,'1','148','769',327,'Retail Sale Id 1470037',2000.96,0.00,0.00,3.38,277.16,'2022-01-06 15:16:40','',''),(2453109,'1','148','769',327,'Retail Sale Id 1470093',6002.88,0.00,0.00,10.14,831.48,'2022-01-06 15:24:31','',''),(2453125,'1','148','769',327,'Retail Sale Id 1470110',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 15:25:40','',''),(2453134,'1','148','769',327,'Retail Sale Id 1470121',1799.68,0.00,0.00,3.04,249.28,'2022-01-06 15:26:47','',''),(2453144,'1','148','769',327,'Retail Sale Id 1470131',6002.88,0.00,0.00,10.14,831.48,'2022-01-06 15:27:48','',''),(2453155,'1','148','769',327,'Retail Sale Id 1470142',2000.96,0.00,0.00,3.38,277.16,'2022-01-06 15:29:18','',''),(2453161,'1','148','769',327,'Retail Sale Id 1470148',1000.48,0.00,0.00,1.69,138.58,'2022-01-06 15:30:08','',''),(2453166,'1','148','769',327,'Retail Sale Id 1470157',2397.60,0.00,0.00,4.05,332.10,'2022-01-06 15:31:03','',''),(2453235,'1','148','769',327,'Retail Sale Id 1470234',2498.24,0.00,0.00,4.22,346.04,'2022-01-06 15:38:26','',''),(2453327,'1','148','769',327,'Retail Sale Id 1470298',1000.48,0.00,0.00,1.69,138.58,'2022-01-06 15:46:24','',''),(2453370,'1','148','769',327,'Retail Sale Id 1470336',1000.48,0.00,0.00,1.69,138.58,'2022-01-06 15:50:42','',''),(2453422,'1','148','769',327,'Retail Sale Id 1470386',1497.76,0.00,0.00,2.53,207.46,'2022-01-06 15:56:44','',''),(2453478,'1','148','769',327,'Retail Sale Id 1470435',1900.32,0.00,0.00,3.21,263.22,'2022-01-06 16:01:54','',''),(2453486,'1','148','769',327,'Retail Sale Id 1470443',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 16:03:01','',''),(2453638,'1','148','769',327,'Retail Sale Id 1470570',2498.24,0.00,0.00,4.22,346.04,'2022-01-06 16:17:32','',''),(2453682,'1','148','769',327,'Retail Sale Id 1470614',1000.48,0.00,0.00,1.69,138.58,'2022-01-06 16:21:57','',''),(2453702,'1','148','769',327,'Retail Sale Id 1470635',1000.48,0.00,0.00,1.69,138.58,'2022-01-06 16:24:03','',''),(2453810,'1','148','769',327,'Retail Sale Id 1470736',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 16:35:54','',''),(2454368,'1','148','769',327,'Retail Sale Id 1471315',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 17:27:26','',''),(2454399,'1','148','769',327,'Retail Sale Id 1471350',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 17:30:15','',''),(2454749,'1','148','769',327,'Retail Sale Id 1471688',1000.48,0.00,0.00,1.69,138.58,'2022-01-06 18:00:32','',''),(2454767,'1','148','769',327,'Retail Sale Id 1471704',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 18:02:23','',''),(2455932,'1','148','769',327,'Retail Sale Id 1472195',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 07:32:19','',''),(2455960,'1','148','769',327,'Retail Sale Id 1472208',1799.68,0.00,0.00,3.04,249.28,'2022-01-07 07:35:13','',''),(2455971,'1','148','769',327,'Retail Sale Id 1472212',3001.44,0.00,0.00,5.07,415.74,'2022-01-07 07:36:37','',''),(2456031,'1','148','769',327,'Retail Sale Id 1472243',497.28,0.00,0.00,0.84,68.88,'2022-01-07 07:42:31','',''),(2456091,'1','148','769',327,'Retail Sale Id 1472288',1497.76,0.00,0.00,2.53,207.46,'2022-01-07 07:49:22','',''),(2456105,'1','148','769',327,'Retail Sale Id 1472301',2800.16,0.00,0.00,4.73,387.86,'2022-01-07 07:51:26','',''),(2456136,'1','148','769',327,'Retail Sale Id 1472332',1201.76,0.00,0.00,2.03,166.46,'2022-01-07 07:56:31','',''),(2456148,'1','148','769',327,'Retail Sale Id 1472343',6002.88,0.00,0.00,10.14,831.48,'2022-01-07 07:57:47','',''),(2456197,'1','148','769',327,'Retail Sale Id 1472392',130130.90,0.00,0.00,245.53,4910.60,'2022-01-07 08:04:26','',''),(2456204,'1','148','769',327,'Retail Sale Id 1472400',1799.68,0.00,0.00,3.04,249.28,'2022-01-07 08:05:15','',''),(2456248,'1','148','769',327,'Retail Sale Id 1472431',214238.88,0.00,0.00,361.89,29674.98,'2022-01-07 08:08:35','',''),(2456259,'1','148','769',327,'Return of Retail Sale Id 1472431',0.00,214238.88,361.89,0.00,-29674.98,'2022-01-07 08:10:12','',''),(2456293,'1','148','769',327,'Retail Sale Id 1472457',212439.20,0.00,0.00,358.85,29425.70,'2022-01-07 08:13:12','',''),(2457507,'1','148','769',327,'Retail Sale Id 1473502',14800.00,0.00,0.00,25.00,2050.00,'2022-01-07 09:59:13','',''),(2457690,'1','148','769',327,'Retail Sale Id 1473669',3001.44,0.00,0.00,5.07,415.74,'2022-01-07 10:20:31','',''),(2457733,'1','148','769',327,'Retail Sale Id 1473715',3001.44,0.00,0.00,5.07,415.74,'2022-01-07 10:25:47','',''),(2457768,'1','148','769',327,'Retail Sale Id 1473737',3001.44,0.00,0.00,5.07,415.74,'2022-01-07 10:28:44','',''),(2457772,'1','148','769',327,'Retail Sale Id 1473741',799.20,0.00,0.00,1.35,110.70,'2022-01-07 10:29:31','',''),(2457789,'1','148','769',327,'Retail Sale Id 1473754',1497.76,0.00,0.00,2.53,207.46,'2022-01-07 10:30:57','',''),(2457808,'1','148','769',327,'Retail Sale Id 1473772',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 10:33:19','',''),(2457824,'1','148','769',327,'Retail Sale Id 1473802',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 10:34:58','',''),(2457839,'1','148','769',327,'Retail Sale Id 1473818',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 10:36:36','',''),(2458213,'1','148','769',327,'Retail Sale Id 1474121',14800.00,0.00,0.00,25.00,2050.00,'2022-01-07 11:09:27','',''),(2458218,'1','148','769',327,'Retail Sale Id 1474127',59200.00,0.00,0.00,100.00,8200.00,'2022-01-07 11:10:09','',''),(2458224,'1','148','769',327,'Retail Sale Id 1474133',88800.00,0.00,0.00,150.00,12300.00,'2022-01-07 11:10:44','',''),(2458231,'1','148','769',327,'Retail Sale Id 1474139',799.20,0.00,0.00,1.35,110.70,'2022-01-07 11:11:39','',''),(2458240,'1','148','769',327,'Retail Sale Id 1474148',177600.00,0.00,0.00,300.00,24600.00,'2022-01-07 11:12:33','',''),(2458267,'1','148','769',327,'Retail Sale Id 1474172',5002.40,0.00,0.00,8.45,692.90,'2022-01-07 11:15:04','',''),(2458360,'1','148','769',327,'Retail Sale Id 1474259',1000.48,0.00,0.00,1.69,138.58,'2022-01-07 11:23:27','',''),(2458463,'1','148','769',327,'Retail Sale Id 1474352',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 11:34:04','',''),(2458511,'1','148','769',327,'Retail Sale Id 1474403',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 11:40:08','',''),(2458549,'1','148','769',327,'Retail Sale Id 1474429',3700.00,0.00,0.00,6.25,512.50,'2022-01-07 11:43:38','',''),(2458586,'1','148','769',327,'Retail Sale Id 1474471',2000.96,0.00,0.00,3.38,277.16,'2022-01-07 11:46:41','',''),(2458880,'1','148','769',327,'Retail Sale Id 1474762',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 12:18:54','',''),(2459391,'1','148','769',327,'Retail Sale Id 1475281',402.56,0.00,0.00,0.68,55.76,'2022-01-07 13:29:42','',''),(2459393,'1','148','769',327,'Retail Sale Id 1475284',118400.00,0.00,0.00,200.00,16400.00,'2022-01-07 13:30:43','',''),(2459400,'1','148','769',327,'Retail Sale Id 1475289',88800.00,0.00,0.00,150.00,12300.00,'2022-01-07 13:31:18','',''),(2459402,'1','148','769',327,'Retail Sale Id 1475292',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 13:31:46','',''),(2459543,'1','148','769',327,'Retail Sale Id 1475437',5002.40,0.00,0.00,8.45,692.90,'2022-01-07 13:55:41','',''),(2459564,'1','148','769',327,'Retail Sale Id 1475460',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 14:00:13','',''),(2459572,'1','148','769',327,'Retail Sale Id 1475466',6808.00,0.00,0.00,11.50,943.00,'2022-01-07 14:01:27','',''),(2459737,'1','148','769',327,'Retail Sale Id 1475587',4997.90,0.00,0.00,9.43,188.60,'2022-01-07 14:19:45','',''),(2459742,'1','148','769',327,'Retail Sale Id 1475594',3001.44,0.00,0.00,5.07,415.74,'2022-01-07 14:20:53','',''),(2459749,'1','148','769',327,'Retail Sale Id 1475600',5002.40,0.00,0.00,8.45,692.90,'2022-01-07 14:21:35','',''),(2459789,'1','148','769',327,'Retail Sale Id 1475641',1497.76,0.00,0.00,2.53,207.46,'2022-01-07 14:27:27','',''),(2459816,'1','148','769',327,'Retail Sale Id 1475658',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 14:29:48','',''),(2460093,'1','148','769',327,'Retail Sale Id 1475867',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 14:56:28','',''),(2460190,'1','148','769',327,'Retail Sale Id 1475960',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 15:05:36','',''),(2460222,'1','148','769',327,'Retail Sale Id 1475969',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 15:07:09','',''),(2460466,'1','148','769',327,'Retail Sale Id 1476173',2498.24,0.00,0.00,4.22,346.04,'2022-01-07 15:28:01','',''),(2460478,'1','148','769',327,'Retail Sale Id 1476182',1799.68,0.00,0.00,3.04,249.28,'2022-01-07 15:28:46','',''),(2460487,'1','148','769',327,'Retail Sale Id 1476191',5002.40,0.00,0.00,8.45,692.90,'2022-01-07 15:29:32','',''),(2460816,'1','148','769',327,'Retail Sale Id 1476410',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 15:50:44','',''),(2460870,'1','148','769',327,'Retail Sale Id 1476465',1497.76,0.00,0.00,2.53,207.46,'2022-01-07 15:55:57','',''),(2460963,'1','148','769',327,'Retail Sale Id 1476526',1497.76,0.00,0.00,2.53,207.46,'2022-01-07 16:03:39','',''),(2460976,'1','148','769',327,'Retail Sale Id 1476538',6002.88,0.00,0.00,10.14,831.48,'2022-01-07 16:05:41','',''),(2460983,'1','148','769',327,'Retail Sale Id 1476554',497.28,0.00,0.00,0.84,68.88,'2022-01-07 16:06:56','',''),(2460985,'1','148','769',327,'Retail Sale Id 1476558',2397.60,0.00,0.00,4.05,332.10,'2022-01-07 16:07:37','',''),(2460992,'1','148','769',327,'Retail Sale Id 1476563',1397.12,0.00,0.00,2.36,193.52,'2022-01-07 16:08:25','',''),(2461007,'1','148','769',327,'Retail Sale Id 1476578',2000.96,0.00,0.00,3.38,277.16,'2022-01-07 16:10:31','',''),(2461065,'1','148','769',327,'Retail Sale Id 1476638',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 16:17:43','',''),(2461922,'1','148','769',327,'Retail Sale Id 1477323',1497.76,0.00,0.00,2.53,207.46,'2022-01-07 17:34:22','',''),(2461972,'1','148','769',327,'Retail Sale Id 1477363',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 17:39:01','',''),(2461977,'1','148','769',327,'Retail Sale Id 1477368',1799.68,0.00,0.00,3.04,249.28,'2022-01-07 17:40:06','',''),(2461991,'1','148','769',327,'Retail Sale Id 1477379',3001.44,0.00,0.00,5.07,415.74,'2022-01-07 17:41:08','',''),(2462019,'1','148','769',327,'Retail Sale Id 1477399',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 17:43:40','',''),(2462040,'1','148','769',327,'Retail Sale Id 1477409',1000.48,0.00,0.00,1.69,138.58,'2022-01-07 17:44:30','',''),(2462070,'1','148','769',327,'Retail Sale Id 1477437',3001.44,0.00,0.00,5.07,415.74,'2022-01-07 17:47:12','',''),(2462089,'1','148','769',327,'Retail Sale Id 1477455',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 17:49:51','',''),(2462093,'1','148','769',327,'Retail Sale Id 1477461',2000.96,0.00,0.00,3.38,277.16,'2022-01-07 17:50:36','',''),(2462103,'1','148','769',327,'Retail Sale Id 1477471',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 17:51:37','',''),(2462139,'1','148','769',327,'Retail Sale Id 1477503',597.92,0.00,0.00,1.01,82.82,'2022-01-07 17:56:32','',''),(2462177,'1','148','769',327,'Retail Sale Id 1477542',2498.24,0.00,0.00,4.22,346.04,'2022-01-07 18:02:09','',''),(2462185,'1','148','769',327,'Retail Sale Id 1477551',4001.92,0.00,0.00,6.76,554.32,'2022-01-07 18:04:13','',''),(2462192,'1','148','769',327,'Retail Sale Id 1477557',3498.72,0.00,0.00,5.91,484.62,'2022-01-07 18:05:03','',''),(2462199,'1','148','769',327,'Retail Sale Id 1477565',3001.44,0.00,0.00,5.07,415.74,'2022-01-07 18:06:32','',''),(2465499,'1','148','769',327,'Return of Retail Sale Id 1475289',0.00,88800.00,150.00,0.00,-12300.00,'2022-01-08 11:05:44','',''),(2465518,'1','148','769',327,'Return of Retail Sale Id 1474127',0.00,59200.00,100.00,0.00,-8200.00,'2022-01-08 11:07:23','',''),(2465543,'1','148','769',327,'Retail Sale Id 1480147',46631.84,0.00,0.00,78.77,6459.14,'2022-01-08 11:09:30','',''),(2466677,'1','148','769',327,'Retail Sale Id 1481159',963635.40,0.00,0.00,1818.18,36363.60,'2022-01-08 12:52:20','',''),(2466698,'1','148','769',327,'Retail Sale Id 1481183',36615.20,0.00,0.00,61.85,5071.70,'2022-01-08 12:54:42','',''),(2467855,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,1530000.00,3000.00,0.00,0.00,'2022-01-08 14:37:33','',''),(2467868,'1','148',NULL,327,'Reception corrector for bridging 130194',0.00,0.00,0.00,3000.00,0.00,'2022-01-08 14:38:32','',''),(2467869,'1','148','769',327,'Received from bridging 130194',0.00,0.00,3000.00,0.00,0.00,'2022-01-08 14:38:32','',''),(2467898,'1','148','769',327,'Retail Sale Id 1482163',6625.00,0.00,0.00,12.50,250.00,'2022-01-08 14:40:42','',''),(2467983,'1','148','769',327,'Retail Sale Id 1482227',5002.40,0.00,0.00,8.45,692.90,'2022-01-08 14:47:48','',''),(2467991,'1','148','769',327,'Retail Sale Id 1482242',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 14:48:44','',''),(2468000,'1','148','769',327,'Retail Sale Id 1482250',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 14:49:40','',''),(2468009,'1','148','769',327,'Retail Sale Id 1482262',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 14:50:50','',''),(2468032,'1','148','769',327,'Retail Sale Id 1482273',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 14:51:41','',''),(2468051,'1','148','769',327,'Retail Sale Id 1482283',698.56,0.00,0.00,1.18,96.76,'2022-01-08 14:52:39','',''),(2468062,'1','148','769',327,'Retail Sale Id 1482296',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 14:53:52','',''),(2468090,'1','148','769',327,'Retail Sale Id 1482310',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 14:54:58','',''),(2468104,'1','148','769',327,'Retail Sale Id 1482315',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 14:56:17','',''),(2468117,'1','148','769',327,'Retail Sale Id 1482330',1699.04,0.00,0.00,2.87,235.34,'2022-01-08 14:57:28','',''),(2468125,'1','148','769',327,'Retail Sale Id 1482341',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 14:58:39','',''),(2468135,'1','148','769',327,'Retail Sale Id 1482352',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 14:59:35','',''),(2468142,'1','148','769',327,'Retail Sale Id 1482359',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 15:00:31','',''),(2468151,'1','148','769',327,'Retail Sale Id 1482368',1497.76,0.00,0.00,2.53,207.46,'2022-01-08 15:01:56','',''),(2468190,'1','148','769',327,'Retail Sale Id 1482382',1799.68,0.00,0.00,3.04,249.28,'2022-01-08 15:03:47','',''),(2468213,'1','148','769',327,'Retail Sale Id 1482396',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 15:05:28','',''),(2468224,'1','148','769',327,'Retail Sale Id 1482413',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 15:06:29','',''),(2468236,'1','148','769',327,'Retail Sale Id 1482418',1799.68,0.00,0.00,3.04,249.28,'2022-01-08 15:07:52','',''),(2468241,'1','148','769',327,'Retail Sale Id 1482429',1497.76,0.00,0.00,2.53,207.46,'2022-01-08 15:08:47','',''),(2468248,'1','148','769',327,'Retail Sale Id 1482436',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 15:10:05','',''),(2468256,'1','148','769',327,'Retail Sale Id 1482446',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 15:11:04','',''),(2468262,'1','148','769',327,'Retail Sale Id 1482454',5002.40,0.00,0.00,8.45,692.90,'2022-01-08 15:12:00','',''),(2468287,'1','148','769',327,'Retail Sale Id 1482469',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 15:14:55','',''),(2468307,'1','148','769',327,'Retail Sale Id 1482490',6997.44,0.00,0.00,11.82,969.24,'2022-01-08 15:17:32','',''),(2468314,'1','148','769',327,'Retail Sale Id 1482504',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 15:18:22','',''),(2468322,'1','148','769',327,'Retail Sale Id 1482512',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 15:19:42','',''),(2468338,'1','148','769',327,'Retail Sale Id 1482521',6002.88,0.00,0.00,10.14,831.48,'2022-01-08 15:21:35','',''),(2468343,'1','148','769',327,'Retail Sale Id 1482534',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 15:22:25','',''),(2468361,'1','148','769',327,'Retail Sale Id 1482555',5002.40,0.00,0.00,8.45,692.90,'2022-01-08 15:23:54','',''),(2468378,'1','148','769',327,'Retail Sale Id 1482566',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 15:25:19','',''),(2468396,'1','148','769',327,'Retail Sale Id 1482574',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 15:26:21','',''),(2468404,'1','148','769',327,'Retail Sale Id 1482583',1598.40,0.00,0.00,2.70,221.40,'2022-01-08 15:27:32','',''),(2468415,'1','148','769',327,'Retail Sale Id 1482598',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 15:28:56','',''),(2468425,'1','148','769',327,'Retail Sale Id 1482609',5002.40,0.00,0.00,8.45,692.90,'2022-01-08 15:29:58','',''),(2468435,'1','148','769',327,'Retail Sale Id 1482616',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 15:30:57','',''),(2468443,'1','148','769',327,'Retail Sale Id 1482624',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 15:31:50','',''),(2468459,'1','148','769',327,'Retail Sale Id 1482641',1497.76,0.00,0.00,2.53,207.46,'2022-01-08 15:33:08','',''),(2468468,'1','148','769',327,'Retail Sale Id 1482653',1497.76,0.00,0.00,2.53,207.46,'2022-01-08 15:34:15','',''),(2468478,'1','148','769',327,'Retail Sale Id 1482664',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 15:35:11','',''),(2468493,'1','148','769',327,'Retail Sale Id 1482675',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 15:36:29','',''),(2468604,'1','148','769',327,'Retail Sale Id 1482738',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 15:43:30','',''),(2468620,'1','148','769',327,'Retail Sale Id 1482756',1201.76,0.00,0.00,2.03,166.46,'2022-01-08 15:44:26','',''),(2468650,'1','148','769',327,'Retail Sale Id 1482785',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 15:45:53','',''),(2468672,'1','148','769',327,'Retail Sale Id 1482800',6002.88,0.00,0.00,10.14,831.48,'2022-01-08 15:47:43','',''),(2468681,'1','148','769',327,'Retail Sale Id 1482806',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 15:48:33','',''),(2468691,'1','148','769',327,'Retail Sale Id 1482816',1799.68,0.00,0.00,3.04,249.28,'2022-01-08 15:49:27','',''),(2468722,'1','148','769',327,'Retail Sale Id 1482834',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 15:50:31','',''),(2468781,'1','148','769',327,'Retail Sale Id 1482868',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 15:53:50','',''),(2468808,'1','148','769',327,'Retail Sale Id 1482891',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 15:55:04','',''),(2468864,'1','148','769',327,'Retail Sale Id 1482932',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 15:58:17','',''),(2468877,'1','148','769',327,'Retail Sale Id 1482946',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 15:59:27','',''),(2468907,'1','148','769',327,'Retail Sale Id 1482962',1497.76,0.00,0.00,2.53,207.46,'2022-01-08 16:00:51','',''),(2468929,'1','148','769',327,'Retail Sale Id 1482981',1497.76,0.00,0.00,2.53,207.46,'2022-01-08 16:02:38','',''),(2468941,'1','148','769',327,'Retail Sale Id 1482998',1000.48,0.00,0.00,1.69,138.58,'2022-01-08 16:03:31','',''),(2468978,'1','148','769',327,'Retail Sale Id 1483020',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 16:05:00','',''),(2469003,'1','148','769',327,'Retail Sale Id 1483054',1000.48,0.00,0.00,1.69,138.58,'2022-01-08 16:07:17','',''),(2469080,'1','148','769',327,'Retail Sale Id 1483113',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 16:12:57','',''),(2469096,'1','148','769',327,'Retail Sale Id 1483134',3498.72,0.00,0.00,5.91,484.62,'2022-01-08 16:14:30','',''),(2469106,'1','148','769',327,'Retail Sale Id 1483146',1799.68,0.00,0.00,3.04,249.28,'2022-01-08 16:15:31','',''),(2469122,'1','148','769',327,'Retail Sale Id 1483164',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 16:16:39','',''),(2469131,'1','148','769',327,'Retail Sale Id 1483174',5002.40,0.00,0.00,8.45,692.90,'2022-01-08 16:17:36','',''),(2469146,'1','148','769',327,'Retail Sale Id 1483189',1000.48,0.00,0.00,1.69,138.58,'2022-01-08 16:18:40','',''),(2469155,'1','148','769',327,'Retail Sale Id 1483199',1497.76,0.00,0.00,2.53,207.46,'2022-01-08 16:19:38','',''),(2469170,'1','148','769',327,'Retail Sale Id 1483213',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 16:21:11','',''),(2469174,'1','148','769',327,'Retail Sale Id 1483220',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 16:22:04','',''),(2469198,'1','148','769',327,'Retail Sale Id 1483246',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 16:23:51','',''),(2469234,'1','148','769',327,'Retail Sale Id 1483280',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 16:26:34','',''),(2469235,'1','148','769',327,'Retail Sale Id 1483280',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 16:26:34','',''),(2469266,'1','148','769',327,'Retail Sale Id 1483303',6625.00,0.00,0.00,12.50,250.00,'2022-01-08 16:28:46','',''),(2469298,'1','148','769',327,'Retail Sale Id 1483335',6360.00,0.00,0.00,12.00,240.00,'2022-01-08 16:30:23','',''),(2469313,'1','148','769',327,'Retail Sale Id 1483349',1000.48,0.00,0.00,1.69,138.58,'2022-01-08 16:31:39','',''),(2469314,'1','148','769',327,'Retail Sale Id 1483349',1000.48,0.00,0.00,1.69,138.58,'2022-01-08 16:31:39','',''),(2469322,'1','148','769',327,'Retail Sale Id 1483357',4001.92,0.00,0.00,6.76,554.32,'2022-01-08 16:32:24','',''),(2469364,'1','148','769',327,'Retail Sale Id 1483370',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 16:34:32','',''),(2469393,'1','148','769',327,'Retail Sale Id 1483399',2498.24,0.00,0.00,4.22,346.04,'2022-01-08 16:36:09','',''),(2469444,'1','148','769',327,'Retail Sale Id 1483436',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 16:39:36','',''),(2469480,'1','148','769',327,'Retail Sale Id 1483462',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 16:41:39','',''),(2469491,'1','148','769',327,'Retail Sale Id 1483474',1799.68,0.00,0.00,3.04,249.28,'2022-01-08 16:42:42','',''),(2469505,'1','148','769',327,'Retail Sale Id 1483486',1900.32,0.00,0.00,3.21,263.22,'2022-01-08 16:43:39','',''),(2469514,'1','148','769',327,'Retail Sale Id 1483494',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 16:44:46','',''),(2469523,'1','148','769',327,'Retail Sale Id 1483507',4001.92,0.00,0.00,6.76,554.32,'2022-01-08 16:45:35','',''),(2469567,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,790500.00,1550.00,0.00,0.00,'2022-01-08 16:49:34','',''),(2469581,'1','148',NULL,327,'Reception corrector for bridging 130209',0.00,0.00,0.00,1550.00,0.00,'2022-01-08 16:50:34','',''),(2469582,'1','148','769',327,'Received from bridging 130209',0.00,0.00,1550.00,0.00,0.00,'2022-01-08 16:50:34','',''),(2469590,'1','148','769',327,'Retail Sale Id 1483566',1000.48,0.00,0.00,1.69,138.58,'2022-01-08 16:51:15','',''),(2469657,'1','148','769',327,'Retail Sale Id 1483636',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 16:57:23','',''),(2469701,'1','148','769',327,'Retail Sale Id 1483680',1799.68,0.00,0.00,3.04,249.28,'2022-01-08 17:01:25','',''),(2469723,'1','148','769',327,'Retail Sale Id 1483704',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 17:02:57','',''),(2469755,'1','148','769',327,'Retail Sale Id 1483725',1497.76,0.00,0.00,2.53,207.46,'2022-01-08 17:04:22','',''),(2469770,'1','148','769',327,'Retail Sale Id 1483741',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 17:05:28','',''),(2469780,'1','148','769',327,'Retail Sale Id 1483753',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 17:06:18','',''),(2469805,'1','148','769',327,'Retail Sale Id 1483778',95400.00,0.00,0.00,180.00,3600.00,'2022-01-08 17:07:53','',''),(2469831,'1','148','769',327,'Retail Sale Id 1483801',9540.00,0.00,0.00,18.00,360.00,'2022-01-08 17:10:07','',''),(2469850,'1','148','769',327,'Retail Sale Id 1483818',4001.92,0.00,0.00,6.76,554.32,'2022-01-08 17:11:33','',''),(2469864,'1','148','769',327,'Retail Sale Id 1483833',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 17:12:30','',''),(2469882,'1','148','769',327,'Retail Sale Id 1483847',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 17:14:11','',''),(2469891,'1','148','769',327,'Retail Sale Id 1483866',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 17:14:55','',''),(2469959,'1','148','769',327,'Retail Sale Id 1483906',5300.00,0.00,0.00,10.00,200.00,'2022-01-08 17:17:54','',''),(2469967,'1','148','769',327,'Retail Sale Id 1483917',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 17:18:51','',''),(2469977,'1','148','769',327,'Retail Sale Id 1483928',1000.48,0.00,0.00,1.69,138.58,'2022-01-08 17:19:36','',''),(2469987,'1','148','769',327,'Retail Sale Id 1483938',1799.68,0.00,0.00,3.04,249.28,'2022-01-08 17:20:22','',''),(2470000,'1','148','769',327,'Retail Sale Id 1483951',1201.76,0.00,0.00,2.03,166.46,'2022-01-08 17:21:12','',''),(2470020,'1','148','769',327,'Retail Sale Id 1483973',6002.88,0.00,0.00,10.14,831.48,'2022-01-08 17:22:55','',''),(2470037,'1','148','769',327,'Retail Sale Id 1483990',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 17:24:10','',''),(2470051,'1','148','769',327,'Retail Sale Id 1484004',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 17:25:28','',''),(2470064,'1','148','769',327,'Retail Sale Id 1484019',1201.76,0.00,0.00,2.03,166.46,'2022-01-08 17:26:34','',''),(2470079,'1','148','769',327,'Retail Sale Id 1484034',1799.68,0.00,0.00,3.04,249.28,'2022-01-08 17:27:47','',''),(2470138,'1','148','769',327,'Retail Sale Id 1484091',26500.00,0.00,0.00,50.00,1000.00,'2022-01-08 17:32:15','',''),(2470203,'1','148','769',327,'Retail Sale Id 1484161',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 17:37:29','',''),(2470221,'1','148','769',327,'Retail Sale Id 1484176',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 17:38:47','',''),(2470238,'1','148','769',327,'Retail Sale Id 1484194',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 17:40:39','',''),(2470272,'1','148','769',327,'Retail Sale Id 1484227',1000.48,0.00,0.00,1.69,138.58,'2022-01-08 17:43:56','',''),(2470290,'1','148','769',327,'Retail Sale Id 1484247',2800.16,0.00,0.00,4.73,387.86,'2022-01-08 17:45:27','',''),(2470308,'1','148','769',327,'Retail Sale Id 1484258',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 17:46:36','',''),(2470329,'1','148','769',327,'Retail Sale Id 1484276',6399.52,0.00,0.00,10.81,886.42,'2022-01-08 17:48:48','',''),(2470368,'1','148','769',327,'Retail Sale Id 1484313',1799.68,0.00,0.00,3.04,249.28,'2022-01-08 17:52:23','',''),(2470382,'1','148','769',327,'Retail Sale Id 1484333',5002.40,0.00,0.00,8.45,692.90,'2022-01-08 17:54:10','',''),(2470391,'1','148','769',327,'Retail Sale Id 1484351',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 17:55:44','',''),(2470402,'1','148','769',327,'Retail Sale Id 1484396',1497.76,0.00,0.00,2.53,207.46,'2022-01-08 17:56:47','',''),(2470416,'1','148','769',327,'Retail Sale Id 1484460',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 17:58:11','',''),(2470436,'1','148','769',327,'Retail Sale Id 1484479',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 17:59:40','',''),(2470447,'1','148','769',327,'Retail Sale Id 1484492',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 18:00:50','',''),(2470462,'1','148','769',327,'Retail Sale Id 1484508',597.92,0.00,0.00,1.01,82.82,'2022-01-08 18:02:23','',''),(2470469,'1','148','769',327,'Retail Sale Id 1484516',1497.76,0.00,0.00,2.53,207.46,'2022-01-08 18:03:19','',''),(2470484,'1','148','769',327,'Retail Sale Id 1484533',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 18:04:36','',''),(2470497,'1','148','769',327,'Retail Sale Id 1484541',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 18:05:30','',''),(2470508,'1','148','769',327,'Retail Sale Id 1484564',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 18:06:50','',''),(2470533,'1','148','769',327,'Retail Sale Id 1484590',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 18:09:50','',''),(2470547,'1','148','769',327,'Retail Sale Id 1484605',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 18:11:11','',''),(2470587,'1','148','769',327,'Retail Sale Id 1484658',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 18:17:25','',''),(2470595,'1','148','769',327,'Retail Sale Id 1484666',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 18:18:49','',''),(2470601,'1','148','769',327,'Retail Sale Id 1484674',1497.76,0.00,0.00,2.53,207.46,'2022-01-08 18:20:09','',''),(2470611,'1','148','769',327,'Retail Sale Id 1484682',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 18:21:08','',''),(2470621,'1','148','769',327,'Retail Sale Id 1484690',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 18:21:56','',''),(2470650,'1','148','769',327,'Retail Sale Id 1484713',1000.48,0.00,0.00,1.69,138.58,'2022-01-08 18:25:52','',''),(2470663,'1','148','769',327,'Retail Sale Id 1484725',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 18:28:02','',''),(2470690,'1','148','769',327,'Retail Sale Id 1484748',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 18:32:06','',''),(2470697,'1','148','769',327,'Retail Sale Id 1484757',1497.76,0.00,0.00,2.53,207.46,'2022-01-08 18:33:27','',''),(2470705,'1','148','769',327,'Retail Sale Id 1484762',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 18:34:36','',''),(2470711,'1','148','769',327,'Retail Sale Id 1484767',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 18:35:46','',''),(2470738,'1','148','769',327,'Retail Sale Id 1484777',1497.76,0.00,0.00,2.53,207.46,'2022-01-08 18:37:47','',''),(2470769,'1','148','769',327,'Retail Sale Id 1484810',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 18:43:34','',''),(2470774,'1','148','769',327,'Retail Sale Id 1484816',1000.48,0.00,0.00,1.69,138.58,'2022-01-08 18:44:34','',''),(2470785,'1','148','769',327,'Retail Sale Id 1484820',2397.60,0.00,0.00,4.05,332.10,'2022-01-08 18:45:53','',''),(2470789,'1','148','769',327,'Retail Sale Id 1484825',1000.48,0.00,0.00,1.69,138.58,'2022-01-08 18:47:08','',''),(2470804,'1','148','769',327,'Retail Sale Id 1484829',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 18:48:20','',''),(2470817,'1','148','769',327,'Retail Sale Id 1484839',3498.72,0.00,0.00,5.91,484.62,'2022-01-08 18:50:01','',''),(2470822,'1','148','769',327,'Retail Sale Id 1484846',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 18:51:17','',''),(2470828,'1','148','769',327,'Retail Sale Id 1484852',5002.40,0.00,0.00,8.45,692.90,'2022-01-08 18:52:25','',''),(2470834,'1','148','769',327,'Retail Sale Id 1484859',4001.92,0.00,0.00,6.76,554.32,'2022-01-08 18:54:05','',''),(2470839,'1','148','769',327,'Retail Sale Id 1484864',5002.40,0.00,0.00,8.45,692.90,'2022-01-08 18:55:05','',''),(2470849,'1','148','769',327,'Retail Sale Id 1484872',2397.60,0.00,0.00,4.05,332.10,'2022-01-08 18:56:06','',''),(2470867,'1','148','769',327,'Retail Sale Id 1484882',1497.76,0.00,0.00,2.53,207.46,'2022-01-08 18:57:24','',''),(2470881,'1','148','769',327,'Retail Sale Id 1484887',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 18:58:25','',''),(2470885,'1','148','769',327,'Retail Sale Id 1484891',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 18:59:20','',''),(2470905,'1','148','769',327,'Retail Sale Id 1485022',497.28,0.00,0.00,0.84,68.88,'2022-01-08 19:07:03','',''),(2470909,'1','148','769',327,'Retail Sale Id 1485031',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 19:08:19','',''),(2470918,'1','148','769',327,'Retail Sale Id 1485055',3498.72,0.00,0.00,5.91,484.62,'2022-01-08 19:09:29','',''),(2470928,'1','148','769',327,'Retail Sale Id 1485069',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 19:10:49','',''),(2470934,'1','148','769',327,'Retail Sale Id 1485074',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 19:11:52','',''),(2470945,'1','148','769',327,'Retail Sale Id 1485085',6997.44,0.00,0.00,11.82,969.24,'2022-01-08 19:13:30','',''),(2470953,'1','148','769',327,'Retail Sale Id 1485093',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 19:14:49','',''),(2470959,'1','148','769',327,'Retail Sale Id 1485100',1497.76,0.00,0.00,2.53,207.46,'2022-01-08 19:16:15','',''),(2471020,'1','148','769',327,'Retail Sale Id 1485149',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 19:33:27','',''),(2471029,'1','148','769',327,'Retail Sale Id 1485158',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 19:39:48','',''),(2471031,'1','148','769',327,'Retail Sale Id 1485160',1497.76,0.00,0.00,2.53,207.46,'2022-01-08 19:41:05','',''),(2471058,'1','148','769',327,'Return of Retail Sale Id 1483778',0.00,95400.00,180.00,0.00,-3600.00,'2022-01-08 20:12:53','',''),(2471060,'1','148','769',327,'Retail Sale Id 1485184',57240.00,0.00,0.00,108.00,2160.00,'2022-01-08 20:14:22','',''),(2471115,'1','148','769',327,'Retail Sale Id 1485197',15445.28,0.00,0.00,26.09,2139.38,'2022-01-08 21:00:13','',''),(2471454,'1','148','769',327,'Retail Sale Id 1485232',2498.24,0.00,0.00,4.22,346.04,'2022-01-09 07:18:09','',''),(2471460,'1','148','769',327,'Retail Sale Id 1485236',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 07:19:48','',''),(2471475,'1','148','769',327,'Retail Sale Id 1485255',240090.00,0.00,0.00,453.00,9060.00,'2022-01-09 07:25:08','',''),(2471487,'1','148','769',327,'Retail Sale Id 1485264',4197.28,0.00,0.00,7.09,581.38,'2022-01-09 07:27:09','',''),(2471513,'1','148','769',327,'Retail Sale Id 1485289',1201.76,0.00,0.00,2.03,166.46,'2022-01-09 07:33:08','',''),(2471557,'1','148','769',327,'Retail Sale Id 1485321',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 07:39:33','',''),(2471581,'1','148','769',327,'Retail Sale Id 1485329',106000.00,0.00,0.00,200.00,4000.00,'2022-01-09 07:41:52','',''),(2471596,'1','148','769',327,'Retail Sale Id 1485333',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 07:43:27','',''),(2471609,'1','148','769',327,'Retail Sale Id 1485349',1302.40,0.00,0.00,2.20,180.40,'2022-01-09 07:45:18','',''),(2471616,'1','148','769',327,'Retail Sale Id 1485356',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 07:47:03','',''),(2471630,'1','148','769',327,'Retail Sale Id 1485363',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 07:49:19','',''),(2471640,'1','148','769',327,'Retail Sale Id 1485374',2699.52,0.00,0.00,4.56,373.92,'2022-01-09 07:51:04','',''),(2471680,'1','148','769',327,'Retail Sale Id 1485404',1201.76,0.00,0.00,2.03,166.46,'2022-01-09 07:56:27','',''),(2471687,'1','148','769',327,'Retail Sale Id 1485411',2800.16,0.00,0.00,4.73,387.86,'2022-01-09 07:57:29','',''),(2471698,'1','148','769',327,'Retail Sale Id 1485415',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 07:58:32','',''),(2471704,'1','148','769',327,'Retail Sale Id 1485424',1000.48,0.00,0.00,1.69,138.58,'2022-01-09 07:59:35','',''),(2471720,'1','148','769',327,'Retail Sale Id 1485433',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 08:01:07','',''),(2471792,'1','148','769',327,'Retail Sale Id 1485475',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 08:07:27','',''),(2471803,'1','148','769',327,'Retail Sale Id 1485480',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 08:08:34','',''),(2471816,'1','148','769',327,'Retail Sale Id 1485488',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 08:09:25','',''),(2471845,'1','148','769',327,'Retail Sale Id 1485518',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 08:13:19','',''),(2471865,'1','148','769',327,'Retail Sale Id 1485537',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 08:15:55','',''),(2471873,'1','148','769',327,'Retail Sale Id 1485549',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 08:16:50','',''),(2471930,'1','148','769',327,'Retail Sale Id 1485601',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 08:23:33','',''),(2471941,'1','148','769',327,'Retail Sale Id 1485614',1000.48,0.00,0.00,1.69,138.58,'2022-01-09 08:24:35','',''),(2471979,'1','148','769',327,'Retail Sale Id 1485639',1302.40,0.00,0.00,2.20,180.40,'2022-01-09 08:27:27','',''),(2472004,'1','148','769',327,'Retail Sale Id 1485679',42930.00,0.00,0.00,81.00,1620.00,'2022-01-09 08:29:45','',''),(2472019,'1','148','769',327,'Retail Sale Id 1485695',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 08:31:35','',''),(2472052,'1','148','769',327,'Retail Sale Id 1485720',1060.00,0.00,0.00,2.00,40.00,'2022-01-09 08:33:47','',''),(2472085,'1','148','769',327,'Retail Sale Id 1485742',597.92,0.00,0.00,1.01,82.82,'2022-01-09 08:36:16','',''),(2472095,'1','148','769',327,'Retail Sale Id 1485752',899.84,0.00,0.00,1.52,124.64,'2022-01-09 08:37:04','',''),(2472109,'1','148','769',327,'Retail Sale Id 1485771',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 08:38:37','',''),(2472144,'1','148','769',327,'Retail Sale Id 1485785',1497.76,0.00,0.00,2.53,207.46,'2022-01-09 08:40:40','',''),(2472153,'1','148','769',327,'Retail Sale Id 1485796',1699.04,0.00,0.00,2.87,235.34,'2022-01-09 08:41:44','',''),(2472176,'1','148','769',327,'Retail Sale Id 1485810',698.56,0.00,0.00,1.18,96.76,'2022-01-09 08:43:07','',''),(2472185,'1','148','769',327,'Retail Sale Id 1485820',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 08:44:34','',''),(2472191,'1','148','769',327,'Retail Sale Id 1485828',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 08:45:26','',''),(2472198,'1','148','769',327,'Retail Sale Id 1485836',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 08:46:23','',''),(2472208,'1','148','769',327,'Retail Sale Id 1485845',1497.76,0.00,0.00,2.53,207.46,'2022-01-09 08:47:19','',''),(2472220,'1','148','769',327,'Retail Sale Id 1485853',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 08:48:35','',''),(2472233,'1','148','769',327,'Retail Sale Id 1485867',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 08:50:15','',''),(2472245,'1','148','769',327,'Retail Sale Id 1485879',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 08:51:20','',''),(2472254,'1','148','769',327,'Retail Sale Id 1485889',5920.00,0.00,0.00,10.00,820.00,'2022-01-09 08:52:14','',''),(2472264,'1','148','769',327,'Retail Sale Id 1485910',2397.60,0.00,0.00,4.05,332.10,'2022-01-09 08:53:18','',''),(2472278,'1','148','769',327,'Retail Sale Id 1485923',6002.88,0.00,0.00,10.14,831.48,'2022-01-09 08:54:33','',''),(2472291,'1','148','769',327,'Retail Sale Id 1485936',1201.76,0.00,0.00,2.03,166.46,'2022-01-09 08:55:29','',''),(2472306,'1','148','769',327,'Retail Sale Id 1485951',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 08:56:26','',''),(2472317,'1','148','769',327,'Retail Sale Id 1485963',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 08:57:36','',''),(2472331,'1','148','769',327,'Retail Sale Id 1485978',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 08:59:08','',''),(2472342,'1','148','769',327,'Retail Sale Id 1485990',1497.76,0.00,0.00,2.53,207.46,'2022-01-09 09:00:30','',''),(2472364,'1','148','769',327,'Retail Sale Id 1486017',6997.44,0.00,0.00,11.82,969.24,'2022-01-09 09:02:36','',''),(2472384,'1','148','769',327,'Retail Sale Id 1486036',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 09:04:53','',''),(2472392,'1','148','769',327,'Retail Sale Id 1486050',5002.40,0.00,0.00,8.45,692.90,'2022-01-09 09:05:45','',''),(2472403,'1','148','769',327,'Retail Sale Id 1486064',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 09:06:48','',''),(2472438,'1','148','769',327,'Retail Sale Id 1486075',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 09:07:54','',''),(2472448,'1','148','769',327,'Retail Sale Id 1486087',1201.76,0.00,0.00,2.03,166.46,'2022-01-09 09:08:56','',''),(2472456,'1','148','769',327,'Retail Sale Id 1486099',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 09:10:05','',''),(2472464,'1','148','769',327,'Retail Sale Id 1486107',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 09:11:13','',''),(2472475,'1','148','769',327,'Retail Sale Id 1486122',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 09:12:36','',''),(2472502,'1','148','769',327,'Retail Sale Id 1486129',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 09:13:33','',''),(2472517,'1','148','769',327,'Retail Sale Id 1486145',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 09:15:27','',''),(2472558,'1','148','769',327,'Retail Sale Id 1486195',5399.04,0.00,0.00,9.12,747.84,'2022-01-09 09:19:50','',''),(2472579,'1','148','769',327,'Retail Sale Id 1486214',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 09:21:40','',''),(2472592,'1','148','769',327,'Retail Sale Id 1486222',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 09:22:47','',''),(2472602,'1','148','769',327,'Retail Sale Id 1486240',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 09:23:51','',''),(2472625,'1','148','769',327,'Retail Sale Id 1486271',1000.48,0.00,0.00,1.69,138.58,'2022-01-09 09:26:36','',''),(2472640,'1','148','769',327,'Retail Sale Id 1486286',2900.80,0.00,0.00,4.90,401.80,'2022-01-09 09:28:01','',''),(2472650,'1','148','769',327,'Retail Sale Id 1486296',2397.60,0.00,0.00,4.05,332.10,'2022-01-09 09:29:10','',''),(2472665,'1','148','769',327,'Retail Sale Id 1486312',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 09:30:27','',''),(2472678,'1','148','769',327,'Retail Sale Id 1486324',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 09:32:07','',''),(2472687,'1','148','769',327,'Retail Sale Id 1486338',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 09:33:22','',''),(2472694,'1','148','769',327,'Retail Sale Id 1486343',5002.40,0.00,0.00,8.45,692.90,'2022-01-09 09:34:46','',''),(2472699,'1','148','769',327,'Retail Sale Id 1486352',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 09:35:33','',''),(2472716,'1','148','769',327,'Retail Sale Id 1486374',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 09:38:05','',''),(2472722,'1','148','769',327,'Retail Sale Id 1486381',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 09:38:48','',''),(2472734,'1','148','769',327,'Retail Sale Id 1486393',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 09:39:51','',''),(2472743,'1','148','769',327,'Retail Sale Id 1486405',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 09:40:40','',''),(2472764,'1','148','769',327,'Retail Sale Id 1486426',1201.76,0.00,0.00,2.03,166.46,'2022-01-09 09:42:25','',''),(2472777,'1','148','769',327,'Retail Sale Id 1486441',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 09:44:02','',''),(2472789,'1','148','769',327,'Retail Sale Id 1486456',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 09:44:51','',''),(2472805,'1','148','769',327,'Retail Sale Id 1486472',4001.92,0.00,0.00,6.76,554.32,'2022-01-09 09:46:42','',''),(2472825,'1','148','769',327,'Retail Sale Id 1486485',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 09:48:22','',''),(2472840,'1','148','769',327,'Retail Sale Id 1486504',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 09:49:59','',''),(2472863,'1','148','769',327,'Retail Sale Id 1486524',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 09:51:46','',''),(2472877,'1','148','769',327,'Retail Sale Id 1486537',2498.24,0.00,0.00,4.22,346.04,'2022-01-09 09:52:41','',''),(2472889,'1','148','769',327,'Retail Sale Id 1486548',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 09:53:35','',''),(2472918,'1','148','769',327,'Retail Sale Id 1486580',4001.92,0.00,0.00,6.76,554.32,'2022-01-09 09:56:14','',''),(2472927,'1','148','769',327,'Retail Sale Id 1486589',5499.68,0.00,0.00,9.29,761.78,'2022-01-09 09:57:23','',''),(2472951,'1','148','769',327,'Retail Sale Id 1486613',6002.88,0.00,0.00,10.14,831.48,'2022-01-09 09:59:39','',''),(2472962,'1','148','769',327,'Retail Sale Id 1486622',2302.88,0.00,0.00,3.89,318.98,'2022-01-09 10:00:54','',''),(2472977,'1','148','769',327,'Retail Sale Id 1486640',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 10:02:23','',''),(2472991,'1','148','769',327,'Retail Sale Id 1486655',3498.72,0.00,0.00,5.91,484.62,'2022-01-09 10:03:55','',''),(2473016,'1','148','769',327,'Retail Sale Id 1486685',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 10:05:51','',''),(2473020,'1','148','769',327,'Retail Sale Id 1486692',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 10:06:48','',''),(2473027,'1','148','769',327,'Retail Sale Id 1486699',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 10:07:39','',''),(2473036,'1','148','769',327,'Retail Sale Id 1486709',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 10:08:37','',''),(2473046,'1','148','769',327,'Retail Sale Id 1486719',6997.44,0.00,0.00,11.82,969.24,'2022-01-09 10:09:25','',''),(2473058,'1','148','769',327,'Retail Sale Id 1486730',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 10:10:52','',''),(2473067,'1','148','769',327,'Retail Sale Id 1486738',532800.00,0.00,0.00,900.00,73800.00,'2022-01-09 10:11:40','',''),(2473077,'1','148','769',327,'Retail Sale Id 1486746',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 10:12:37','',''),(2473099,'1','148','769',327,'Retail Sale Id 1486771',1000.48,0.00,0.00,1.69,138.58,'2022-01-09 10:14:01','',''),(2473118,'1','148','769',327,'Retail Sale Id 1486798',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 10:16:12','',''),(2473133,'1','148','769',327,'Retail Sale Id 1486812',1000.48,0.00,0.00,1.69,138.58,'2022-01-09 10:17:30','',''),(2473143,'1','148','769',327,'Retail Sale Id 1486826',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 10:18:40','',''),(2473173,'1','148','769',327,'Retail Sale Id 1486850',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 10:20:36','',''),(2473223,'1','148','769',327,'Retail Sale Id 1486887',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 10:24:58','',''),(2473254,'1','148','769',327,'Retail Sale Id 1486897',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 10:26:33','',''),(2473285,'1','148','769',327,'Retail Sale Id 1486926',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 10:28:57','',''),(2473367,'1','148','769',327,'Retail Sale Id 1486963',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 10:33:40','',''),(2473384,'1','148','769',327,'Retail Sale Id 1486994',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 10:35:19','',''),(2473418,'1','148','769',327,'Retail Sale Id 1487020',1000.48,0.00,0.00,1.69,138.58,'2022-01-09 10:37:20','',''),(2473430,'1','148','769',327,'Retail Sale Id 1487032',1000.48,0.00,0.00,1.69,138.58,'2022-01-09 10:38:17','',''),(2473446,'1','148','769',327,'Retail Sale Id 1487046',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 10:39:58','',''),(2473463,'1','148','769',327,'Retail Sale Id 1487066',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 10:41:20','',''),(2473477,'1','148','769',327,'Retail Sale Id 1487080',4001.92,0.00,0.00,6.76,554.32,'2022-01-09 10:42:38','',''),(2473483,'1','148','769',327,'Retail Sale Id 1487085',1497.76,0.00,0.00,2.53,207.46,'2022-01-09 10:43:30','',''),(2473503,'1','148','769',327,'Retail Sale Id 1487099',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 10:44:35','',''),(2473517,'1','148','769',327,'Retail Sale Id 1487117',799.20,0.00,0.00,1.35,110.70,'2022-01-09 10:45:59','',''),(2473539,'1','148','769',327,'Retail Sale Id 1487135',2397.60,0.00,0.00,4.05,332.10,'2022-01-09 10:47:44','',''),(2473551,'1','148','769',327,'Retail Sale Id 1487150',2397.60,0.00,0.00,4.05,332.10,'2022-01-09 10:48:49','',''),(2473616,'1','148','769',327,'Retail Sale Id 1487169',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 10:50:43','',''),(2473635,'1','148','769',327,'Retail Sale Id 1487185',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 10:51:49','',''),(2473681,'1','148','769',327,'Retail Sale Id 1487219',1497.76,0.00,0.00,2.53,207.46,'2022-01-09 10:54:25','',''),(2473694,'1','148','769',327,'Retail Sale Id 1487236',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 10:55:32','',''),(2473706,'1','148','769',327,'Retail Sale Id 1487249',1497.76,0.00,0.00,2.53,207.46,'2022-01-09 10:56:45','',''),(2473716,'1','148','769',327,'Retail Sale Id 1487260',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 10:57:51','',''),(2473735,'1','148','769',327,'Retail Sale Id 1487282',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 10:59:19','',''),(2473752,'1','148','769',327,'Retail Sale Id 1487299',497.28,0.00,0.00,0.84,68.88,'2022-01-09 11:00:35','',''),(2473761,'1','148','769',327,'Retail Sale Id 1487311',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 11:01:41','',''),(2473802,'1','148','769',327,'Retail Sale Id 1487351',1497.76,0.00,0.00,2.53,207.46,'2022-01-09 11:05:41','',''),(2473811,'1','148','769',327,'Retail Sale Id 1487362',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 11:06:45','',''),(2473822,'1','148','769',327,'Retail Sale Id 1487372',1000.48,0.00,0.00,1.69,138.58,'2022-01-09 11:07:41','',''),(2473847,'1','148','769',327,'Retail Sale Id 1487394',9540.00,0.00,0.00,18.00,360.00,'2022-01-09 11:09:45','',''),(2473864,'1','148','769',327,'Retail Sale Id 1487412',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 11:11:32','',''),(2473875,'1','148','769',327,'Retail Sale Id 1487425',6002.88,0.00,0.00,10.14,831.48,'2022-01-09 11:12:58','',''),(2473886,'1','148','769',327,'Retail Sale Id 1487434',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 11:13:58','',''),(2473897,'1','148','769',327,'Retail Sale Id 1487450',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 11:15:07','',''),(2473918,'1','148','769',327,'Retail Sale Id 1487470',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 11:17:13','',''),(2473928,'1','148','769',327,'Retail Sale Id 1487481',28620.00,0.00,0.00,54.00,1080.00,'2022-01-09 11:18:41','',''),(2473943,'1','148','769',327,'Retail Sale Id 1487502',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 11:20:23','',''),(2473964,'1','148','769',327,'Retail Sale Id 1487514',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 11:21:22','',''),(2473973,'1','148','769',327,'Retail Sale Id 1487528',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 11:22:25','',''),(2473986,'1','148','769',327,'Retail Sale Id 1487545',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 11:23:50','',''),(2474000,'1','148','769',327,'Retail Sale Id 1487559',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 11:25:03','',''),(2474035,'1','148','769',327,'Retail Sale Id 1487574',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 11:26:33','',''),(2474084,'1','148','769',327,'Retail Sale Id 1487611',5002.40,0.00,0.00,8.45,692.90,'2022-01-09 11:28:39','',''),(2474096,'1','148','769',327,'Retail Sale Id 1487623',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 11:29:39','',''),(2474115,'1','148','769',327,'Retail Sale Id 1487643',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 11:30:47','',''),(2474133,'1','148','769',327,'Retail Sale Id 1487669',4001.92,0.00,0.00,6.76,554.32,'2022-01-09 11:32:21','',''),(2474148,'1','148','769',327,'Retail Sale Id 1487685',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 11:33:55','',''),(2474166,'1','148','769',327,'Retail Sale Id 1487694',1497.76,0.00,0.00,2.53,207.46,'2022-01-09 11:34:41','',''),(2474193,'1','148','769',327,'Retail Sale Id 1487709',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 11:36:14','',''),(2474208,'1','148','769',327,'Retail Sale Id 1487725',62010.00,0.00,0.00,117.00,2340.00,'2022-01-09 11:37:33','',''),(2474225,'1','148','769',327,'Retail Sale Id 1487734',4499.20,0.00,0.00,7.60,623.20,'2022-01-09 11:38:39','',''),(2474234,'1','148','769',327,'Retail Sale Id 1487742',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 11:39:41','',''),(2474253,'1','148','769',327,'Retail Sale Id 1487759',4001.92,0.00,0.00,6.76,554.32,'2022-01-09 11:41:23','',''),(2474261,'1','148','769',327,'Retail Sale Id 1487767',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 11:42:19','',''),(2474283,'1','148','769',327,'Retail Sale Id 1487784',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 11:43:33','',''),(2474303,'1','148','769',327,'Retail Sale Id 1487805',13402.88,0.00,0.00,22.64,1856.48,'2022-01-09 11:45:22','',''),(2474313,'1','148','769',327,'Retail Sale Id 1487815',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 11:46:19','',''),(2474324,'1','148','769',327,'Retail Sale Id 1487827',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 11:47:15','',''),(2474331,'1','148','769',327,'Retail Sale Id 1487839',6002.88,0.00,0.00,10.14,831.48,'2022-01-09 11:48:28','',''),(2474360,'1','148','769',327,'Retail Sale Id 1487860',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 11:50:37','',''),(2474379,'1','148','769',327,'Retail Sale Id 1487885',1201.76,0.00,0.00,2.03,166.46,'2022-01-09 11:53:03','',''),(2474393,'1','148','769',327,'Retail Sale Id 1487896',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 11:54:41','',''),(2474403,'1','148','769',327,'Retail Sale Id 1487906',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 11:55:39','',''),(2474415,'1','148','769',327,'Retail Sale Id 1487918',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 11:56:37','',''),(2474453,'1','148','769',327,'Retail Sale Id 1487935',4001.92,0.00,0.00,6.76,554.32,'2022-01-09 11:58:04','',''),(2474469,'1','148','769',327,'Retail Sale Id 1487952',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 11:59:18','',''),(2474500,'1','148','769',327,'Retail Sale Id 1487973',31800.00,0.00,0.00,60.00,1200.00,'2022-01-09 12:00:46','',''),(2474526,'1','148','769',327,'Retail Sale Id 1488001',1497.76,0.00,0.00,2.53,207.46,'2022-01-09 12:03:20','',''),(2474544,'1','148','769',327,'Retail Sale Id 1488019',3498.72,0.00,0.00,5.91,484.62,'2022-01-09 12:04:51','',''),(2474556,'1','148','769',327,'Retail Sale Id 1488036',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 12:05:54','',''),(2474567,'1','148','769',327,'Retail Sale Id 1488047',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 12:07:12','',''),(2474587,'1','148','769',327,'Retail Sale Id 1488069',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 12:09:12','',''),(2474609,'1','148','769',327,'Retail Sale Id 1488096',2498.24,0.00,0.00,4.22,346.04,'2022-01-09 12:11:42','',''),(2474621,'1','148','769',327,'Retail Sale Id 1488103',1000.48,0.00,0.00,1.69,138.58,'2022-01-09 12:13:02','',''),(2474630,'1','148','769',327,'Retail Sale Id 1488118',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 12:14:05','',''),(2474643,'1','148','769',327,'Retail Sale Id 1488134',177.60,0.00,0.00,0.30,24.60,'2022-01-09 12:15:47','',''),(2474657,'1','148','769',327,'Retail Sale Id 1488148',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 12:16:55','',''),(2474665,'1','148','769',327,'Retail Sale Id 1488155',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 12:18:11','',''),(2474675,'1','148','769',327,'Retail Sale Id 1488168',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 12:19:36','',''),(2474691,'1','148','769',327,'Retail Sale Id 1488182',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 12:20:59','',''),(2474706,'1','148','769',327,'Retail Sale Id 1488198',4001.92,0.00,0.00,6.76,554.32,'2022-01-09 12:21:59','',''),(2474722,'1','148','769',327,'Retail Sale Id 1488214',2498.24,0.00,0.00,4.22,346.04,'2022-01-09 12:23:33','',''),(2474736,'1','148','769',327,'Retail Sale Id 1488231',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 12:24:35','',''),(2474750,'1','148','769',327,'Retail Sale Id 1488244',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 12:25:44','',''),(2474762,'1','148','769',327,'Retail Sale Id 1488257',2498.24,0.00,0.00,4.22,346.04,'2022-01-09 12:26:48','',''),(2474777,'1','148','769',327,'Retail Sale Id 1488273',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 12:27:59','',''),(2474789,'1','148','769',327,'Retail Sale Id 1488281',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 12:29:04','',''),(2474803,'1','148','769',327,'Retail Sale Id 1488300',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 12:30:30','',''),(2474815,'1','148','769',327,'Retail Sale Id 1488314',1000.48,0.00,0.00,1.69,138.58,'2022-01-09 12:31:35','',''),(2474829,'1','148','769',327,'Retail Sale Id 1488331',5002.40,0.00,0.00,8.45,692.90,'2022-01-09 12:32:50','',''),(2474838,'1','148','769',327,'Retail Sale Id 1488344',2498.24,0.00,0.00,4.22,346.04,'2022-01-09 12:33:34','',''),(2474852,'1','148','769',327,'Retail Sale Id 1488357',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 12:34:37','',''),(2474861,'1','148','769',327,'Retail Sale Id 1488368',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 12:35:32','',''),(2474880,'1','148','769',327,'Retail Sale Id 1488394',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 12:37:11','',''),(2474891,'1','148','769',327,'Retail Sale Id 1488405',1201.76,0.00,0.00,2.03,166.46,'2022-01-09 12:38:14','',''),(2474944,'1','148','769',327,'Retail Sale Id 1488431',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 12:40:00','',''),(2474975,'1','148','769',327,'Retail Sale Id 1488441',497.28,0.00,0.00,0.84,68.88,'2022-01-09 12:40:52','',''),(2474997,'1','148','769',327,'Retail Sale Id 1488463',1497.76,0.00,0.00,2.53,207.46,'2022-01-09 12:41:52','',''),(2475012,'1','148','769',327,'Retail Sale Id 1488478',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 12:43:09','',''),(2475030,'1','148','769',327,'Retail Sale Id 1488497',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 12:44:37','',''),(2475047,'1','148','769',327,'Retail Sale Id 1488512',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 12:45:50','',''),(2475070,'1','148','769',327,'Retail Sale Id 1488534',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 12:47:15','',''),(2475084,'1','148','769',327,'Retail Sale Id 1488547',899.84,0.00,0.00,1.52,124.64,'2022-01-09 12:48:13','',''),(2475107,'1','148','769',327,'Retail Sale Id 1488576',5002.40,0.00,0.00,8.45,692.90,'2022-01-09 12:50:55','',''),(2475125,'1','148','769',327,'Retail Sale Id 1488594',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 12:52:24','',''),(2475146,'1','148','769',327,'Retail Sale Id 1488620',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 12:53:54','',''),(2475171,'1','148','769',327,'Retail Sale Id 1488637',1000.48,0.00,0.00,1.69,138.58,'2022-01-09 12:55:13','',''),(2475190,'1','148','769',327,'Retail Sale Id 1488654',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 12:57:04','',''),(2475206,'1','148','769',327,'Retail Sale Id 1488668',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 12:58:24','',''),(2475223,'1','148','769',327,'Retail Sale Id 1488686',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 13:00:30','',''),(2475240,'1','148','769',327,'Retail Sale Id 1488704',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 13:01:50','',''),(2475246,'1','148','769',327,'Retail Sale Id 1488711',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 13:02:40','',''),(2475262,'1','148','769',327,'Retail Sale Id 1488731',5002.40,0.00,0.00,8.45,692.90,'2022-01-09 13:04:03','',''),(2475272,'1','148','769',327,'Retail Sale Id 1488743',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 13:05:18','',''),(2475301,'1','148','769',327,'Retail Sale Id 1488760',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 13:06:59','',''),(2475313,'1','148','769',327,'Retail Sale Id 1488772',6997.44,0.00,0.00,11.82,969.24,'2022-01-09 13:08:26','',''),(2475323,'1','148','769',327,'Retail Sale Id 1488783',597.92,0.00,0.00,1.01,82.82,'2022-01-09 13:09:48','',''),(2475340,'1','148','769',327,'Retail Sale Id 1488800',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 13:11:55','',''),(2475348,'1','148','769',327,'Retail Sale Id 1488809',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 13:12:57','',''),(2475364,'1','148','769',327,'Retail Sale Id 1488823',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 13:14:08','',''),(2475378,'1','148','769',327,'Retail Sale Id 1488835',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 13:15:31','',''),(2475389,'1','148','769',327,'Retail Sale Id 1488852',1497.76,0.00,0.00,2.53,207.46,'2022-01-09 13:16:45','',''),(2475407,'1','148','769',327,'Retail Sale Id 1488871',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 13:18:06','',''),(2475430,'1','148','769',327,'Retail Sale Id 1488897',4197.28,0.00,0.00,7.09,581.38,'2022-01-09 13:20:03','',''),(2475445,'1','148','769',327,'Retail Sale Id 1488916',5920.00,0.00,0.00,10.00,820.00,'2022-01-09 13:21:17','',''),(2475468,'1','148','769',327,'Retail Sale Id 1488933',5097.12,0.00,0.00,8.61,706.02,'2022-01-09 13:23:14','',''),(2475482,'1','148','769',327,'Retail Sale Id 1488952',4102.56,0.00,0.00,6.93,568.26,'2022-01-09 13:24:22','',''),(2475502,'1','148','769',327,'Retail Sale Id 1488970',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 13:25:57','',''),(2475517,'1','148','769',327,'Retail Sale Id 1488984',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 13:27:33','',''),(2475529,'1','148','769',327,'Retail Sale Id 1488999',1000.48,0.00,0.00,1.69,138.58,'2022-01-09 13:28:53','',''),(2475540,'1','148','769',327,'Retail Sale Id 1489011',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 13:29:58','',''),(2475571,'1','148','769',327,'Retail Sale Id 1489021',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 13:31:08','',''),(2475592,'1','148','769',327,'Retail Sale Id 1489041',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 13:32:37','',''),(2475603,'1','148','769',327,'Retail Sale Id 1489060',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 13:33:46','',''),(2475626,'1','148','769',327,'Retail Sale Id 1489075',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 13:35:11','',''),(2475641,'1','148','769',327,'Retail Sale Id 1489090',3102.08,0.00,0.00,5.24,429.68,'2022-01-09 13:36:21','',''),(2475684,'1','148','769',327,'Retail Sale Id 1489142',799.20,0.00,0.00,1.35,110.70,'2022-01-09 13:40:18','',''),(2475712,'1','148','769',327,'Retail Sale Id 1489174',8998.40,0.00,0.00,15.20,1246.40,'2022-01-09 13:43:18','',''),(2475729,'1','148','769',327,'Retail Sale Id 1489183',2397.60,0.00,0.00,4.05,332.10,'2022-01-09 13:44:26','',''),(2475744,'1','148','769',327,'Retail Sale Id 1489197',2900.80,0.00,0.00,4.90,401.80,'2022-01-09 13:45:47','',''),(2475764,'1','148','769',327,'Retail Sale Id 1489218',1000.48,0.00,0.00,1.69,138.58,'2022-01-09 13:47:49','',''),(2475775,'1','148','769',327,'Retail Sale Id 1489229',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 13:48:42','',''),(2475788,'1','148','769',327,'Retail Sale Id 1489242',2699.52,0.00,0.00,4.56,373.92,'2022-01-09 13:49:59','',''),(2475804,'1','148','769',327,'Retail Sale Id 1489261',2397.60,0.00,0.00,4.05,332.10,'2022-01-09 13:51:13','',''),(2475821,'1','148','769',327,'Retail Sale Id 1489279',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 13:52:55','',''),(2475847,'1','148','769',327,'Retail Sale Id 1489310',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 13:55:48','',''),(2475866,'1','148','769',327,'Retail Sale Id 1489332',31270.00,0.00,0.00,59.00,1180.00,'2022-01-09 13:57:31','',''),(2475873,'1','148','769',327,'Retail Sale Id 1489344',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 13:58:39','',''),(2475881,'1','148','769',327,'Retail Sale Id 1489361',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 13:59:34','',''),(2475903,'1','148','769',327,'Retail Sale Id 1489384',597.92,0.00,0.00,1.01,82.82,'2022-01-09 14:02:26','',''),(2475920,'1','148','769',327,'Retail Sale Id 1489400',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 14:04:21','',''),(2475941,'1','148','769',327,'Retail Sale Id 1489421',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 14:06:10','',''),(2475961,'1','148','769',327,'Retail Sale Id 1489446',4001.92,0.00,0.00,6.76,554.32,'2022-01-09 14:07:49','',''),(2475992,'1','148','769',327,'Retail Sale Id 1489476',1497.76,0.00,0.00,2.53,207.46,'2022-01-09 14:10:56','',''),(2476008,'1','148','769',327,'Retail Sale Id 1489492',9998.88,0.00,0.00,16.89,1384.98,'2022-01-09 14:12:02','',''),(2476084,'1','148','769',327,'Retail Sale Id 1489576',3700.00,0.00,0.00,6.25,512.50,'2022-01-09 14:21:34','',''),(2476100,'1','148','769',327,'Retail Sale Id 1489594',30210.00,0.00,0.00,57.00,1140.00,'2022-01-09 14:23:13','',''),(2476153,'1','148','769',327,'Retail Sale Id 1489624',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 14:27:25','',''),(2476165,'1','148','769',327,'Retail Sale Id 1489638',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 14:28:30','',''),(2476185,'1','148','769',327,'Retail Sale Id 1489657',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 14:30:36','',''),(2476202,'1','148','769',327,'Retail Sale Id 1489664',23320.00,0.00,0.00,44.00,880.00,'2022-01-09 14:31:37','',''),(2476237,'1','148','769',327,'Retail Sale Id 1489701',1497.76,0.00,0.00,2.53,207.46,'2022-01-09 14:35:50','',''),(2476271,'1','148','769',327,'Retail Sale Id 1489723',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 14:38:38','',''),(2476461,'1','148','769',327,'Retail Sale Id 1489829',4149.92,0.00,0.00,7.01,574.82,'2022-01-09 14:49:56','',''),(2476480,'1','148','769',327,'Retail Sale Id 1489843',6997.44,0.00,0.00,11.82,969.24,'2022-01-09 14:51:45','',''),(2476497,'1','148','769',327,'Retail Sale Id 1489848',2498.24,0.00,0.00,4.22,346.04,'2022-01-09 14:53:05','',''),(2476507,'1','148','769',327,'Retail Sale Id 1489868',597.92,0.00,0.00,1.01,82.82,'2022-01-09 14:54:14','',''),(2477692,'1','148','769',327,'Return of Retail Sale Id 1486738',0.00,532800.00,900.00,0.00,-73800.00,'2022-01-09 16:50:20','',''),(2477719,'1','148','769',327,'Retail Sale Id 1491101',209350.00,0.00,0.00,395.00,7900.00,'2022-01-09 16:51:53','',''),(2477741,'1','148','769',327,'Retail Sale Id 1491139',74825.40,0.00,0.00,141.18,2823.60,'2022-01-09 16:53:53','',''),(2477794,'1','148','769',327,'Retail Sale Id 1491181',58300.00,0.00,0.00,110.00,2200.00,'2022-01-09 16:57:04','',''),(2477824,'1','148','769',327,'Retail Sale Id 1491208',12720.00,0.00,0.00,24.00,480.00,'2022-01-09 16:59:29','',''),(2477885,'1','148','769',327,'Retail Sale Id 1491253',78108.48,0.00,0.00,131.94,10819.08,'2022-01-09 17:04:10','',''),(2478372,'1','148','769',327,'Retail Sale Id 1491723',6002.88,0.00,0.00,10.14,831.48,'2022-01-09 17:55:18','',''),(2478381,'1','148','769',327,'Retail Sale Id 1491734',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 17:56:09','',''),(2478384,'1','148','769',327,'Retail Sale Id 1491737',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 17:56:54','',''),(2478393,'1','148','769',327,'Retail Sale Id 1491745',5002.40,0.00,0.00,8.45,692.90,'2022-01-09 17:58:03','',''),(2478402,'1','148','769',327,'Retail Sale Id 1491753',4001.92,0.00,0.00,6.76,554.32,'2022-01-09 17:59:04','',''),(2478406,'1','148','769',327,'Retail Sale Id 1491758',1497.76,0.00,0.00,2.53,207.46,'2022-01-09 17:59:48','',''),(2478456,'1','148','769',327,'Retail Sale Id 1491803',2397.60,0.00,0.00,4.05,332.10,'2022-01-09 18:05:31','',''),(2478470,'1','148','769',327,'Retail Sale Id 1491814',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 18:08:03','',''),(2478495,'1','148','769',327,'Retail Sale Id 1491827',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 18:09:16','',''),(2478518,'1','148','769',327,'Retail Sale Id 1491835',1000.48,0.00,0.00,1.69,138.58,'2022-01-09 18:10:54','',''),(2478521,'1','148','769',327,'Retail Sale Id 1491838',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 18:11:45','',''),(2478584,'1','148','769',327,'Retail Sale Id 1491885',497.28,0.00,0.00,0.84,68.88,'2022-01-09 18:20:15','',''),(2478691,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,1530000.00,3000.00,0.00,0.00,'2022-01-09 18:40:29','',''),(2478692,'1','148',NULL,327,'Reception corrector for bridging 130326',0.00,0.00,0.00,3000.00,0.00,'2022-01-09 18:41:32','',''),(2478693,'1','148','769',327,'Received from bridging 130326',0.00,0.00,3000.00,0.00,0.00,'2022-01-09 18:41:32','',''),(2478700,'1','148','769',327,'Retail Sale Id 1491954',6002.88,0.00,0.00,10.14,831.48,'2022-01-09 18:43:47','',''),(2478706,'1','148','769',327,'Retail Sale Id 1491962',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 18:45:58','',''),(2478712,'1','148','769',327,'Retail Sale Id 1491967',698.56,0.00,0.00,1.18,96.76,'2022-01-09 18:47:15','',''),(2478728,'1','148','769',327,'Retail Sale Id 1491975',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 18:49:58','',''),(2478741,'1','148','769',327,'Retail Sale Id 1491984',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 18:53:41','',''),(2478742,'1','148','769',327,'Retail Sale Id 1491984',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 18:53:41','',''),(2478752,'1','148','769',327,'Retail Sale Id 1491989',2302.88,0.00,0.00,3.89,318.98,'2022-01-09 18:54:54','',''),(2478782,'1','148','769',327,'Retail Sale Id 1491992',4001.92,0.00,0.00,6.76,554.32,'2022-01-09 18:56:17','',''),(2478783,'1','148','769',327,'Retail Sale Id 1491993',1000.48,0.00,0.00,1.69,138.58,'2022-01-09 18:57:09','',''),(2478787,'1','148','769',327,'Retail Sale Id 1491996',2000.96,0.00,0.00,3.38,277.16,'2022-01-09 18:58:31','',''),(2478791,'1','148','769',327,'Retail Sale Id 1492002',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 19:00:17','',''),(2478795,'1','148','769',327,'Retail Sale Id 1492004',4001.92,0.00,0.00,6.76,554.32,'2022-01-09 19:01:36','',''),(2478800,'1','148','769',327,'Retail Sale Id 1492014',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 19:03:38','',''),(2478801,'1','148','769',327,'Retail Sale Id 1492016',5002.40,0.00,0.00,8.45,692.90,'2022-01-09 19:04:49','',''),(2478806,'1','148','769',327,'Retail Sale Id 1492021',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 19:06:37','',''),(2478810,'1','148','769',327,'Retail Sale Id 1492023',2397.60,0.00,0.00,4.05,332.10,'2022-01-09 19:08:20','',''),(2478815,'1','148','769',327,'Retail Sale Id 1492029',1000.48,0.00,0.00,1.69,138.58,'2022-01-09 19:09:16','',''),(2478817,'1','148','769',327,'Retail Sale Id 1492051',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 19:11:34','',''),(2478819,'1','148','769',327,'Retail Sale Id 1492053',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 19:12:28','',''),(2478829,'1','148','769',327,'Retail Sale Id 1492054',1699.04,0.00,0.00,2.87,235.34,'2022-01-09 19:13:36','',''),(2478837,'1','148','769',327,'Retail Sale Id 1492056',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 19:16:23','',''),(2478838,'1','148','769',327,'Retail Sale Id 1492057',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 19:17:59','',''),(2478850,'1','148','769',327,'Retail Sale Id 1492060',5002.40,0.00,0.00,8.45,692.90,'2022-01-09 19:19:27','',''),(2479511,'1','148','769',327,'Retail Sale Id 1492137',31198.40,0.00,0.00,52.70,4321.40,'2022-01-10 07:14:23','',''),(2479566,'1','148','769',327,'Retail Sale Id 1492158',15105.00,0.00,0.00,28.50,570.00,'2022-01-10 07:23:43','',''),(2479567,'1','148','769',327,'Retail Sale Id 1492159',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 07:24:10','',''),(2479578,'1','148','769',327,'Retail Sale Id 1492163',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 07:28:07','',''),(2479591,'1','148','769',327,'Retail Sale Id 1492196',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 07:33:02','',''),(2479629,'1','148','769',327,'Retail Sale Id 1492217',5002.40,0.00,0.00,8.45,692.90,'2022-01-10 07:40:30','',''),(2479636,'1','148','769',327,'Retail Sale Id 1492228',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 07:42:48','',''),(2479640,'1','148','769',327,'Retail Sale Id 1492230',3498.72,0.00,0.00,5.91,484.62,'2022-01-10 07:43:58','',''),(2479647,'1','148','769',327,'Retail Sale Id 1492238',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 07:45:30','',''),(2479681,'1','148','769',327,'Retail Sale Id 1492275',5002.40,0.00,0.00,8.45,692.90,'2022-01-10 07:54:09','',''),(2479700,'1','148','769',327,'Retail Sale Id 1492284',57240.00,0.00,0.00,108.00,2160.00,'2022-01-10 07:55:47','',''),(2479711,'1','148','769',327,'Retail Sale Id 1492291',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 07:56:34','',''),(2479727,'1','148','769',327,'Retail Sale Id 1492306',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 07:58:57','',''),(2479734,'1','148','769',327,'Retail Sale Id 1492314',6002.88,0.00,0.00,10.14,831.48,'2022-01-10 07:59:58','',''),(2479746,'1','148','769',327,'Retail Sale Id 1492327',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 08:01:35','',''),(2479755,'1','148','769',327,'Retail Sale Id 1492341',26500.00,0.00,0.00,50.00,1000.00,'2022-01-10 08:02:43','',''),(2479775,'1','148','769',327,'Retail Sale Id 1492364',6360.00,0.00,0.00,12.00,240.00,'2022-01-10 08:06:18','',''),(2479790,'1','148','769',327,'Retail Sale Id 1492382',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 08:08:54','',''),(2479825,'1','148','769',327,'Retail Sale Id 1492427',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 08:12:17','',''),(2479876,'1','148','769',327,'Retail Sale Id 1492471',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 08:16:54','',''),(2479884,'1','148','769',327,'Retail Sale Id 1492479',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 08:18:24','',''),(2479902,'1','148','769',327,'Retail Sale Id 1492498',597.92,0.00,0.00,1.01,82.82,'2022-01-10 08:20:57','',''),(2479909,'1','148','769',327,'Retail Sale Id 1492507',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 08:21:52','',''),(2479939,'1','148','769',327,'Retail Sale Id 1492534',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 08:24:32','',''),(2479945,'1','148','769',327,'Retail Sale Id 1492538',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 08:25:26','',''),(2479952,'1','148','769',327,'Retail Sale Id 1492546',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 08:26:23','',''),(2479984,'1','148','769',327,'Retail Sale Id 1492579',47700.00,0.00,0.00,90.00,1800.00,'2022-01-10 08:30:54','',''),(2480006,'1','148','769',327,'Retail Sale Id 1492593',62540.00,0.00,0.00,118.00,2360.00,'2022-01-10 08:33:12','',''),(2480031,'1','148','769',327,'Retail Sale Id 1492625',26500.00,0.00,0.00,50.00,1000.00,'2022-01-10 08:35:26','',''),(2480059,'1','148','769',327,'Retail Sale Id 1492653',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 08:38:00','',''),(2480065,'1','148','769',327,'Retail Sale Id 1492659',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 08:39:02','',''),(2480094,'1','148','769',327,'Retail Sale Id 1492688',698.56,0.00,0.00,1.18,96.76,'2022-01-10 08:41:22','',''),(2480109,'1','148','769',327,'Retail Sale Id 1492698',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 08:42:19','',''),(2480121,'1','148','769',327,'Retail Sale Id 1492713',1397.12,0.00,0.00,2.36,193.52,'2022-01-10 08:43:32','',''),(2480129,'1','148','769',327,'Retail Sale Id 1492722',1497.76,0.00,0.00,2.53,207.46,'2022-01-10 08:44:27','',''),(2480136,'1','148','769',327,'Retail Sale Id 1492728',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 08:45:21','',''),(2480147,'1','148','769',327,'Retail Sale Id 1492740',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 08:46:32','',''),(2480156,'1','148','769',327,'Retail Sale Id 1492748',1497.76,0.00,0.00,2.53,207.46,'2022-01-10 08:47:34','',''),(2480171,'1','148','769',327,'Retail Sale Id 1492758',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 08:48:29','',''),(2480185,'1','148','769',327,'Retail Sale Id 1492777',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 08:50:23','',''),(2480227,'1','148','769',327,'Retail Sale Id 1492798',1201.76,0.00,0.00,2.03,166.46,'2022-01-10 08:53:41','',''),(2480289,'1','148','769',327,'Retail Sale Id 1492851',1497.76,0.00,0.00,2.53,207.46,'2022-01-10 08:59:27','',''),(2480294,'1','148','769',327,'Retail Sale Id 1492855',1699.04,0.00,0.00,2.87,235.34,'2022-01-10 09:00:13','',''),(2480303,'1','148','769',327,'Retail Sale Id 1492870',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 09:01:05','',''),(2480307,'1','148','769',327,'Retail Sale Id 1492873',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 09:01:56','',''),(2480315,'1','148','769',327,'Retail Sale Id 1492882',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 09:02:50','',''),(2480323,'1','148','769',327,'Retail Sale Id 1492885',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 09:03:28','',''),(2480333,'1','148','769',327,'Retail Sale Id 1492896',1201.76,0.00,0.00,2.03,166.46,'2022-01-10 09:04:26','',''),(2480334,'1','148','769',327,'Retail Sale Id 1492896',1201.76,0.00,0.00,2.03,166.46,'2022-01-10 09:04:26','',''),(2480377,'1','148','769',327,'Retail Sale Id 1492947',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 09:10:16','',''),(2480388,'1','148','769',327,'Retail Sale Id 1492958',6002.88,0.00,0.00,10.14,831.48,'2022-01-10 09:11:02','',''),(2480420,'1','148','769',327,'Retail Sale Id 1492966',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 09:11:54','',''),(2480457,'1','148','769',327,'Retail Sale Id 1492990',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 09:14:38','',''),(2480660,'1','148','769',327,'Retail Sale Id 1493121',31800.00,0.00,0.00,60.00,1200.00,'2022-01-10 09:29:31','',''),(2480668,'1','148','769',327,'Retail Sale Id 1493130',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 09:30:10','',''),(2480679,'1','148','769',327,'Retail Sale Id 1493148',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 09:31:44','',''),(2480715,'1','148','769',327,'Retail Sale Id 1493180',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 09:35:19','',''),(2480726,'1','148','769',327,'Retail Sale Id 1493193',6002.88,0.00,0.00,10.14,831.48,'2022-01-10 09:36:35','',''),(2480732,'1','148','769',327,'Retail Sale Id 1493201',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 09:37:27','',''),(2480739,'1','148','769',327,'Retail Sale Id 1493207',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 09:38:34','',''),(2480750,'1','148','769',327,'Retail Sale Id 1493218',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 09:39:44','',''),(2480762,'1','148','769',327,'Retail Sale Id 1493226',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 09:40:56','',''),(2480802,'1','148','769',327,'Retail Sale Id 1493260',39750.00,0.00,0.00,75.00,1500.00,'2022-01-10 09:44:42','',''),(2480806,'1','148','769',327,'Retail Sale Id 1493266',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 09:45:11','',''),(2480824,'1','148','769',327,'Retail Sale Id 1493272',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 09:47:00','',''),(2480842,'1','148','769',327,'Retail Sale Id 1493279',4001.92,0.00,0.00,6.76,554.32,'2022-01-10 09:47:41','',''),(2480857,'1','148','769',327,'Retail Sale Id 1493282',1497.76,0.00,0.00,2.53,207.46,'2022-01-10 09:48:48','',''),(2480880,'1','148','769',327,'Retail Sale Id 1493293',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 09:50:54','',''),(2480890,'1','148','769',327,'Retail Sale Id 1493300',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 09:51:59','',''),(2480911,'1','148','769',327,'Retail Sale Id 1493320',2397.60,0.00,0.00,4.05,332.10,'2022-01-10 09:54:19','',''),(2480920,'1','148','769',327,'Retail Sale Id 1493330',2498.24,0.00,0.00,4.22,346.04,'2022-01-10 09:55:29','',''),(2480935,'1','148','769',327,'Retail Sale Id 1493346',6360.00,0.00,0.00,12.00,240.00,'2022-01-10 09:57:20','',''),(2480950,'1','148','769',327,'Retail Sale Id 1493362',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 09:58:48','',''),(2480963,'1','148','769',327,'Retail Sale Id 1493374',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 10:00:00','',''),(2480980,'1','148','769',327,'Retail Sale Id 1493386',1497.76,0.00,0.00,2.53,207.46,'2022-01-10 10:02:15','',''),(2480990,'1','148','769',327,'Retail Sale Id 1493394',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 10:03:43','',''),(2481002,'1','148','769',327,'Retail Sale Id 1493410',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 10:05:34','',''),(2481030,'1','148','769',327,'Retail Sale Id 1493426',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 10:06:51','',''),(2481064,'1','148','769',327,'Retail Sale Id 1493438',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 10:08:02','',''),(2481074,'1','148','769',327,'Retail Sale Id 1493451',4499.20,0.00,0.00,7.60,623.20,'2022-01-10 10:09:26','',''),(2481079,'1','148','769',327,'Retail Sale Id 1493458',597.92,0.00,0.00,1.01,82.82,'2022-01-10 10:10:33','',''),(2481090,'1','148','769',327,'Retail Sale Id 1493471',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 10:11:39','',''),(2481115,'1','148','769',327,'Retail Sale Id 1493494',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 10:15:06','',''),(2481158,'1','148','769',327,'Retail Sale Id 1493526',1201.76,0.00,0.00,2.03,166.46,'2022-01-10 10:18:48','',''),(2481205,'1','148','769',327,'Retail Sale Id 1493576',1302.40,0.00,0.00,2.20,180.40,'2022-01-10 10:23:26','',''),(2481222,'1','148','769',327,'Retail Sale Id 1493598',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 10:24:31','',''),(2481231,'1','148','769',327,'Retail Sale Id 1493606',5002.40,0.00,0.00,8.45,692.90,'2022-01-10 10:25:20','',''),(2481249,'1','148','769',327,'Retail Sale Id 1493618',1497.76,0.00,0.00,2.53,207.46,'2022-01-10 10:26:21','',''),(2481255,'1','148','769',327,'Retail Sale Id 1493623',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 10:27:14','',''),(2481320,'1','148','769',327,'Retail Sale Id 1493706',497.28,0.00,0.00,0.84,68.88,'2022-01-10 10:36:12','',''),(2481330,'1','148','769',327,'Retail Sale Id 1493723',1497.76,0.00,0.00,2.53,207.46,'2022-01-10 10:37:15','',''),(2481337,'1','148','769',327,'Retail Sale Id 1493728',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 10:38:14','',''),(2481342,'1','148','769',327,'Retail Sale Id 1493740',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 10:39:15','',''),(2481365,'1','148','769',327,'Retail Sale Id 1493763',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 10:43:06','',''),(2481371,'1','148','769',327,'Retail Sale Id 1493768',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 10:44:07','',''),(2481381,'1','148','769',327,'Retail Sale Id 1493776',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 10:44:53','',''),(2481390,'1','148','769',327,'Retail Sale Id 1493784',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 10:46:10','',''),(2481434,'1','148','769',327,'Retail Sale Id 1493829',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 10:53:35','',''),(2481463,'1','148','769',327,'Retail Sale Id 1493861',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 10:56:18','',''),(2481471,'1','148','769',327,'Retail Sale Id 1493868',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 10:57:27','',''),(2481508,'1','148','769',327,'Retail Sale Id 1493906',6360.00,0.00,0.00,12.00,240.00,'2022-01-10 11:02:20','',''),(2481514,'1','148','769',327,'Retail Sale Id 1493919',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 11:03:16','',''),(2481522,'1','148','769',327,'Retail Sale Id 1493924',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 11:04:23','',''),(2481569,'1','148','769',327,'Retail Sale Id 1493964',140450.00,0.00,0.00,265.00,5300.00,'2022-01-10 11:09:21','',''),(2481679,'1','148','769',327,'Retail Sale Id 1494053',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 11:22:32','',''),(2481686,'1','148','769',327,'Retail Sale Id 1494060',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 11:23:26','',''),(2481697,'1','148','769',327,'Retail Sale Id 1494071',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 11:24:48','',''),(2481711,'1','148','769',327,'Retail Sale Id 1494091',497.28,0.00,0.00,0.84,68.88,'2022-01-10 11:26:45','',''),(2481728,'1','148','769',327,'Retail Sale Id 1494112',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 11:29:12','',''),(2481744,'1','148','769',327,'Retail Sale Id 1494123',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 11:30:14','',''),(2481805,'1','148','769',327,'Retail Sale Id 1494183',2498.24,0.00,0.00,4.22,346.04,'2022-01-10 11:38:30','',''),(2481810,'1','148','769',327,'Retail Sale Id 1494189',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 11:39:15','',''),(2481821,'1','148','769',327,'Retail Sale Id 1494202',84270.00,0.00,0.00,159.00,3180.00,'2022-01-10 11:40:23','',''),(2481830,'1','148','769',327,'Retail Sale Id 1494211',2800.16,0.00,0.00,4.73,387.86,'2022-01-10 11:41:17','',''),(2481835,'1','148','769',327,'Retail Sale Id 1494216',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 11:42:05','',''),(2481837,'1','148','769',327,'Retail Sale Id 1494218',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 11:42:59','',''),(2481851,'1','148','769',327,'Retail Sale Id 1494228',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 11:44:44','',''),(2481873,'1','148','769',327,'Retail Sale Id 1494249',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 11:47:38','',''),(2481883,'1','148','769',327,'Retail Sale Id 1494256',1201.76,0.00,0.00,2.03,166.46,'2022-01-10 11:48:47','',''),(2481894,'1','148','769',327,'Retail Sale Id 1494266',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 11:49:56','',''),(2481899,'1','148','769',327,'Retail Sale Id 1494272',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 11:50:42','',''),(2481912,'1','148','769',327,'Retail Sale Id 1494284',5002.40,0.00,0.00,8.45,692.90,'2022-01-10 11:51:55','',''),(2481921,'1','148','769',327,'Retail Sale Id 1494295',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 11:52:53','',''),(2481936,'1','148','769',327,'Retail Sale Id 1494304',53000.00,0.00,0.00,100.00,2000.00,'2022-01-10 11:54:54','',''),(2481963,'1','148','769',327,'Retail Sale Id 1494335',3498.72,0.00,0.00,5.91,484.62,'2022-01-10 11:58:05','',''),(2481992,'1','148',NULL,327,'Purchased from AA RANO NIGERIA LIMITED',0.00,851700.00,1670.00,0.00,0.00,'2022-01-10 12:01:45','',''),(2481998,'1','148',NULL,327,'Reception corrector for bridging 130367',0.00,0.00,0.00,1670.00,0.00,'2022-01-10 12:02:49','',''),(2481999,'1','148','769',327,'Received from bridging 130367',0.00,0.00,1670.00,0.00,0.00,'2022-01-10 12:02:49','',''),(2482001,'1','148','769',327,'Retail Sale Id 1494370',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 12:03:22','',''),(2482007,'1','148','769',327,'Retail Sale Id 1494373',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 12:04:18','',''),(2482012,'1','148','769',327,'Retail Sale Id 1494378',3498.72,0.00,0.00,5.91,484.62,'2022-01-10 12:05:11','',''),(2482015,'1','148','769',327,'Retail Sale Id 1494381',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 12:05:57','',''),(2482026,'1','148','769',327,'Retail Sale Id 1494397',1497.76,0.00,0.00,2.53,207.46,'2022-01-10 12:07:13','',''),(2482037,'1','148','769',327,'Retail Sale Id 1494406',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 12:08:13','',''),(2482072,'1','148','769',327,'Retail Sale Id 1494441',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 12:12:48','',''),(2482153,'1','148','769',327,'Retail Sale Id 1494500',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 12:19:19','',''),(2482246,'1','148','769',327,'Retail Sale Id 1494543',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 12:24:00','',''),(2482261,'1','148','769',327,'Retail Sale Id 1494558',1302.40,0.00,0.00,2.20,180.40,'2022-01-10 12:25:48','',''),(2482277,'1','148','769',327,'Retail Sale Id 1494578',29600.00,0.00,0.00,50.00,4100.00,'2022-01-10 12:27:52','',''),(2482450,'1','148','769',327,'Retail Sale Id 1494696',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 12:41:28','',''),(2482454,'1','148','769',327,'Retail Sale Id 1494701',6802.08,0.00,0.00,11.49,942.18,'2022-01-10 12:42:26','',''),(2482480,'1','148','769',327,'Retail Sale Id 1494740',8480.00,0.00,0.00,16.00,320.00,'2022-01-10 12:46:17','',''),(2482665,'1','148','769',327,'Retail Sale Id 1494939',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 13:07:57','',''),(2482687,'1','148','769',327,'Retail Sale Id 1494961',26500.00,0.00,0.00,50.00,1000.00,'2022-01-10 13:10:43','',''),(2482726,'1','148','769',327,'Retail Sale Id 1495011',6360.00,0.00,0.00,12.00,240.00,'2022-01-10 13:18:11','',''),(2482751,'1','148','769',327,'Retail Sale Id 1495037',2397.60,0.00,0.00,4.05,332.10,'2022-01-10 13:22:34','',''),(2482816,'1','148','769',327,'Retail Sale Id 1495103',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 13:33:51','',''),(2482859,'1','148','769',327,'Retail Sale Id 1495152',22790.00,0.00,0.00,43.00,860.00,'2022-01-10 13:40:33','',''),(2482875,'1','148','769',327,'Retail Sale Id 1495169',58300.00,0.00,0.00,110.00,2200.00,'2022-01-10 13:42:55','',''),(2482881,'1','148','769',327,'Retail Sale Id 1495175',1302.40,0.00,0.00,2.20,180.40,'2022-01-10 13:43:44','',''),(2482901,'1','148','769',327,'Retail Sale Id 1495196',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 13:48:01','',''),(2482906,'1','148','769',327,'Retail Sale Id 1495201',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 13:49:12','',''),(2482926,'1','148','769',327,'Retail Sale Id 1495224',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 13:52:29','',''),(2482936,'1','148','769',327,'Retail Sale Id 1495237',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 13:54:07','',''),(2482965,'1','148','769',327,'Retail Sale Id 1495269',2397.60,0.00,0.00,4.05,332.10,'2022-01-10 13:57:30','',''),(2483024,'1','148','769',327,'Retail Sale Id 1495317',10999.36,0.00,0.00,18.58,1523.56,'2022-01-10 14:04:27','',''),(2483044,'1','148','769',327,'Retail Sale Id 1495343',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 14:07:41','',''),(2483065,'1','148','769',327,'Retail Sale Id 1495357',4700.48,0.00,0.00,7.94,651.08,'2022-01-10 14:09:45','',''),(2483084,'1','148','769',327,'Retail Sale Id 1495383',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 14:12:46','',''),(2483109,'1','148','769',327,'Retail Sale Id 1495408',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 14:16:35','',''),(2483144,'1','148','769',327,'Retail Sale Id 1495434',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 14:19:41','',''),(2483160,'1','148','769',327,'Retail Sale Id 1495452',1302.40,0.00,0.00,2.20,180.40,'2022-01-10 14:20:40','',''),(2483171,'1','148','769',327,'Retail Sale Id 1495461',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 14:21:56','',''),(2483180,'1','148','769',327,'Retail Sale Id 1495471',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 14:22:44','',''),(2483193,'1','148','769',327,'Retail Sale Id 1495479',1497.76,0.00,0.00,2.53,207.46,'2022-01-10 14:23:49','',''),(2483270,'1','148','769',327,'Retail Sale Id 1495560',2498.24,0.00,0.00,4.22,346.04,'2022-01-10 14:31:23','',''),(2483285,'1','148','769',327,'Retail Sale Id 1495576',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 14:33:26','',''),(2483319,'1','148','769',327,'Retail Sale Id 1495619',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 14:37:05','',''),(2483351,'1','148','769',327,'Retail Sale Id 1495662',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 14:41:54','',''),(2483387,'1','148','769',327,'Retail Sale Id 1495702',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 14:45:56','',''),(2483402,'1','148','769',327,'Retail Sale Id 1495711',5002.40,0.00,0.00,8.45,692.90,'2022-01-10 14:47:27','',''),(2483419,'1','148','769',327,'Retail Sale Id 1495721',2498.24,0.00,0.00,4.22,346.04,'2022-01-10 14:48:25','',''),(2483433,'1','148','769',327,'Retail Sale Id 1495730',1497.76,0.00,0.00,2.53,207.46,'2022-01-10 14:49:38','',''),(2483471,'1','148','769',327,'Retail Sale Id 1495755',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 14:53:17','',''),(2483491,'1','148','769',327,'Retail Sale Id 1495762',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 14:54:22','',''),(2483504,'1','148','769',327,'Retail Sale Id 1495773',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 14:55:49','',''),(2483513,'1','148','769',327,'Retail Sale Id 1495784',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 14:56:42','',''),(2483569,'1','148','769',327,'Retail Sale Id 1495832',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 15:02:43','',''),(2483574,'1','148','769',327,'Retail Sale Id 1495837',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 15:03:40','',''),(2483623,'1','148','769',327,'Retail Sale Id 1495889',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 15:10:20','',''),(2483643,'1','148','769',327,'Retail Sale Id 1495904',1497.76,0.00,0.00,2.53,207.46,'2022-01-10 15:11:45','',''),(2483666,'1','148','769',327,'Retail Sale Id 1495921',497.28,0.00,0.00,0.84,68.88,'2022-01-10 15:13:26','',''),(2483697,'1','148','769',327,'Retail Sale Id 1495947',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 15:16:18','',''),(2483702,'1','148','769',327,'Retail Sale Id 1495951',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 15:17:11','',''),(2483711,'1','148','769',327,'Retail Sale Id 1495961',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 15:18:40','',''),(2483722,'1','148','769',327,'Retail Sale Id 1495978',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 15:20:39','',''),(2483745,'1','148','769',327,'Retail Sale Id 1496001',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 15:23:25','',''),(2483753,'1','148','769',327,'Retail Sale Id 1496011',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 15:24:54','',''),(2483773,'1','148','769',327,'Retail Sale Id 1496031',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 15:26:57','',''),(2483801,'1','148','769',327,'Retail Sale Id 1496063',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 15:30:43','',''),(2483811,'1','148','769',327,'Retail Sale Id 1496071',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 15:31:56','',''),(2483817,'1','148','769',327,'Retail Sale Id 1496079',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 15:32:46','',''),(2483899,'1','148','769',327,'Retail Sale Id 1496156',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 15:41:23','',''),(2483962,'1','148','769',327,'Retail Sale Id 1496195',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 15:46:13','',''),(2484017,'1','148','769',327,'Retail Sale Id 1496256',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 15:53:43','',''),(2484030,'1','148','769',327,'Retail Sale Id 1496268',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 15:55:04','',''),(2484041,'1','148','769',327,'Retail Sale Id 1496281',591200.80,0.00,0.00,998.65,81889.30,'2022-01-10 15:56:12','',''),(2484045,'1','148','769',327,'Retail Sale Id 1496286',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 15:57:02','',''),(2484054,'1','148','769',327,'Retail Sale Id 1496295',6002.88,0.00,0.00,10.14,831.48,'2022-01-10 15:57:50','',''),(2484061,'1','148','769',327,'Retail Sale Id 1496302',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 15:58:43','',''),(2484067,'1','148','769',327,'Retail Sale Id 1496307',1497.76,0.00,0.00,2.53,207.46,'2022-01-10 15:59:44','',''),(2484072,'1','148','769',327,'Retail Sale Id 1496312',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 16:00:39','',''),(2484081,'1','148','769',327,'Retail Sale Id 1496323',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 16:01:39','',''),(2484097,'1','148','769',327,'Retail Sale Id 1496337',25970.00,0.00,0.00,49.00,980.00,'2022-01-10 16:03:33','',''),(2484102,'1','148','769',327,'Retail Sale Id 1496342',2498.24,0.00,0.00,4.22,346.04,'2022-01-10 16:04:29','',''),(2484116,'1','148','769',327,'Retail Sale Id 1496357',2800.16,0.00,0.00,4.73,387.86,'2022-01-10 16:06:29','',''),(2484157,'1','148','769',327,'Retail Sale Id 1496387',2498.24,0.00,0.00,4.22,346.04,'2022-01-10 16:10:04','',''),(2484182,'1','148','769',327,'Retail Sale Id 1496415',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 16:12:29','',''),(2484246,'1','148','769',327,'Return of Retail Sale Id 1496281',0.00,591200.80,998.65,0.00,-81889.30,'2022-01-10 16:18:40','',''),(2484318,'1','148','769',327,'Retail Sale Id 1496538',1497.76,0.00,0.00,2.53,207.46,'2022-01-10 16:26:28','',''),(2484363,'1','148','769',327,'Retail Sale Id 1496581',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 16:31:22','',''),(2484378,'1','148','769',327,'Retail Sale Id 1496594',1699.04,0.00,0.00,2.87,235.34,'2022-01-10 16:32:47','',''),(2484390,'1','148','769',327,'Retail Sale Id 1496611',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 16:34:39','',''),(2484426,'1','148','769',327,'Retail Sale Id 1496646',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 16:39:32','',''),(2484434,'1','148','769',327,'Retail Sale Id 1496654',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 16:40:34','',''),(2484456,'1','148','769',327,'Retail Sale Id 1496670',1497.76,0.00,0.00,2.53,207.46,'2022-01-10 16:42:12','',''),(2484481,'1','148','769',327,'Retail Sale Id 1496680',698.56,0.00,0.00,1.18,96.76,'2022-01-10 16:43:24','',''),(2484505,'1','148','769',327,'Retail Sale Id 1496688',799.20,0.00,0.00,1.35,110.70,'2022-01-10 16:44:10','',''),(2484540,'1','148','769',327,'Retail Sale Id 1496706',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 16:46:46','',''),(2484546,'1','148','769',327,'Retail Sale Id 1496713',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 16:47:41','',''),(2484561,'1','148','769',327,'Retail Sale Id 1496729',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 16:49:02','',''),(2484585,'1','148','769',327,'Retail Sale Id 1496740',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 16:50:33','',''),(2484599,'1','148','769',327,'Retail Sale Id 1496754',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 16:51:58','',''),(2484619,'1','148','769',327,'Retail Sale Id 1496765',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 16:52:51','',''),(2484636,'1','148','769',327,'Retail Sale Id 1496782',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 16:54:30','',''),(2484652,'1','148','769',327,'Retail Sale Id 1496797',4001.92,0.00,0.00,6.76,554.32,'2022-01-10 16:56:20','',''),(2484661,'1','148','769',327,'Retail Sale Id 1496805',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 16:57:23','',''),(2484697,'1','148','769',327,'Retail Sale Id 1496842',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 17:01:28','',''),(2484730,'1','148','769',327,'Retail Sale Id 1496858',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 17:02:55','',''),(2484755,'1','148','769',327,'Retail Sale Id 1496867',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 17:03:56','',''),(2484769,'1','148','769',327,'Retail Sale Id 1496879',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 17:04:55','',''),(2484829,'1','148','769',327,'Retail Sale Id 1496919',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 17:08:29','',''),(2484876,'1','148','769',327,'Retail Sale Id 1496971',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 17:13:20','',''),(2484885,'1','148','769',327,'Retail Sale Id 1496977',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 17:14:09','',''),(2484895,'1','148','769',327,'Retail Sale Id 1496987',4001.92,0.00,0.00,6.76,554.32,'2022-01-10 17:15:20','',''),(2484931,'1','148','769',327,'Retail Sale Id 1497014',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 17:18:29','',''),(2484952,'1','148','769',327,'Retail Sale Id 1497024',3498.72,0.00,0.00,5.91,484.62,'2022-01-10 17:19:28','',''),(2484980,'1','148','769',327,'Retail Sale Id 1497036',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 17:20:21','',''),(2484997,'1','148','769',327,'Retail Sale Id 1497047',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 17:21:24','',''),(2485018,'1','148','769',327,'Retail Sale Id 1497057',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 17:22:20','',''),(2485040,'1','148','769',327,'Retail Sale Id 1497076',799.20,0.00,0.00,1.35,110.70,'2022-01-10 17:23:57','',''),(2485103,'1','148','769',327,'Retail Sale Id 1497125',4001.92,0.00,0.00,6.76,554.32,'2022-01-10 17:27:07','',''),(2485121,'1','148','769',327,'Retail Sale Id 1497139',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 17:28:10','',''),(2485141,'1','148','769',327,'Retail Sale Id 1497155',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 17:29:27','',''),(2485244,'1','148','769',327,'Retail Sale Id 1497224',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 17:36:33','',''),(2485249,'1','148','769',327,'Retail Sale Id 1497230',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 17:37:22','',''),(2485264,'1','148','769',327,'Retail Sale Id 1497243',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 17:38:51','',''),(2485281,'1','148','769',327,'Retail Sale Id 1497265',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 17:40:11','',''),(2485294,'1','148','769',327,'Retail Sale Id 1497278',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 17:41:29','',''),(2485314,'1','148','769',327,'Retail Sale Id 1497299',2397.60,0.00,0.00,4.05,332.10,'2022-01-10 17:43:29','',''),(2485326,'1','148','769',327,'Retail Sale Id 1497310',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 17:44:26','',''),(2485341,'1','148','769',327,'Retail Sale Id 1497326',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 17:45:59','',''),(2485348,'1','148','769',327,'Retail Sale Id 1497335',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 17:46:58','',''),(2485362,'1','148','769',327,'Retail Sale Id 1497346',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 17:47:52','',''),(2485376,'1','148','769',327,'Retail Sale Id 1497359',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 17:49:09','',''),(2485390,'1','148','769',327,'Retail Sale Id 1497372',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 17:50:31','',''),(2485408,'1','148','769',327,'Retail Sale Id 1497386',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 17:51:56','',''),(2485422,'1','148','769',327,'Retail Sale Id 1497403',1497.76,0.00,0.00,2.53,207.46,'2022-01-10 17:53:03','',''),(2485428,'1','148','769',327,'Retail Sale Id 1497410',1699.04,0.00,0.00,2.87,235.34,'2022-01-10 17:53:56','',''),(2485436,'1','148','769',327,'Retail Sale Id 1497417',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 17:54:54','',''),(2485450,'1','148','769',327,'Retail Sale Id 1497429',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 17:56:41','',''),(2485459,'1','148','769',327,'Retail Sale Id 1497438',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 17:57:38','',''),(2485467,'1','148','769',327,'Retail Sale Id 1497449',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 17:58:36','',''),(2485481,'1','148','769',327,'Retail Sale Id 1497464',1497.76,0.00,0.00,2.53,207.46,'2022-01-10 17:59:32','',''),(2485492,'1','148','769',327,'Retail Sale Id 1497472',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 18:00:38','',''),(2485500,'1','148','769',327,'Retail Sale Id 1497480',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 18:01:30','',''),(2485512,'1','148','769',327,'Retail Sale Id 1497492',2397.60,0.00,0.00,4.05,332.10,'2022-01-10 18:02:36','',''),(2485519,'1','148','769',327,'Retail Sale Id 1497499',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 18:03:33','',''),(2485532,'1','148','769',327,'Retail Sale Id 1497508',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 18:04:55','',''),(2485549,'1','148','769',327,'Retail Sale Id 1497523',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 18:06:39','',''),(2485558,'1','148','769',327,'Retail Sale Id 1497532',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 18:07:25','',''),(2485570,'1','148','769',327,'Retail Sale Id 1497542',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 18:08:34','',''),(2485579,'1','148','769',327,'Retail Sale Id 1497551',6002.88,0.00,0.00,10.14,831.48,'2022-01-10 18:09:45','',''),(2485586,'1','148','769',327,'Retail Sale Id 1497559',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 18:10:56','',''),(2485597,'1','148','769',327,'Retail Sale Id 1497571',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 18:12:34','',''),(2485611,'1','148','769',327,'Retail Sale Id 1497592',2699.52,0.00,0.00,4.56,373.92,'2022-01-10 18:13:28','',''),(2485618,'1','148','769',327,'Retail Sale Id 1497598',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 18:14:41','',''),(2485626,'1','148','769',327,'Retail Sale Id 1497605',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 18:15:49','',''),(2485632,'1','148','769',327,'Retail Sale Id 1497610',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 18:16:48','',''),(2485640,'1','148','769',327,'Retail Sale Id 1497619',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 18:17:44','',''),(2485651,'1','148','769',327,'Retail Sale Id 1497628',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 18:18:35','',''),(2485658,'1','148','769',327,'Retail Sale Id 1497636',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 18:19:24','',''),(2485663,'1','148','769',327,'Retail Sale Id 1497641',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 18:20:31','',''),(2485671,'1','148','769',327,'Retail Sale Id 1497649',4001.92,0.00,0.00,6.76,554.32,'2022-01-10 18:21:51','',''),(2485679,'1','148','769',327,'Retail Sale Id 1497655',7400.00,0.00,0.00,12.50,1025.00,'2022-01-