-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_147
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_147`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_147` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_147`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3213 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2590,20008,'',0,'22','1','147','PURCHASES','','2020-08-10 19:08:57',5,0.00,0.00,'','479','2020-08-10 19:08:57','479',0,1),(2591,400088,'',0,'24','1','147','PURCHASES','','2020-08-10 19:09:13',5,0.00,0.00,'','479','2020-08-10 19:09:13','479',0,1),(2592,20016,'',0,'20','1','147','SALES','','2020-08-10 19:09:31',5,0.00,0.00,'','479','2020-08-10 19:09:31','479',0,1),(2593,40015,'',0,'6.1','1','147','CASH','','2020-08-10 19:09:48',5,0.00,0.00,'','479','2020-08-10 19:09:48','479',0,1),(2594,400089,'',0,'24','1','147','SALARIES & WAGES','','2020-08-10 19:10:08',5,0.00,0.00,'','479','2020-08-10 19:10:08','479',0,1),(2595,400221,'',0,'2','1','147','ZBN(POS):1015965368','','2020-08-10 19:10:21',5,0.00,0.00,'','479','2020-08-10 19:10:21','479',0,1),(2596,400222,'',0,'2','1','147','ZB(E-BILL)1015372548','','2020-08-10 19:13:43',5,0.00,0.00,'','479','2020-08-10 19:13:43','479',0,1),(2658,400109,'',0,'24','1','147','OPERATIONAL LOSS','ALL LOSSES DURING SALES/RECEPTION.','2020-08-13 14:01:37',5,0.00,0.00,'','479','2020-08-13 14:01:37','479',0,1),(2906,400323,'',0,'2','1','147','DANKANO-EBILLS(ZNB:1014717618)','','2020-10-29 13:59:19',5,0.00,0.00,'','489','2020-10-29 13:59:19','489',0,1),(3210,400489,'',0,'2','1','147','FID POS COLLECTION-5620141491','','2021-02-26 16:03:16',5,0.00,0.00,'','489','2021-02-26 16:03:16','489',0,1),(3211,400490,'',0,'2','1','147','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:14:39',5,0.00,0.00,'','792','2023-02-20 14:14:39','792',0,0),(3212,400491,'',0,'2','1','147','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:25:48',5,0.00,0.00,'2023-03-15','792','2023-03-17 12:29:22','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1608 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1607,'','1','147','OPERATIONAL LOSS','HAFIZ NURA GAYA','08069129774','hgaya@aaranonigeria.com','KANO','KANO','AA RANO HOUSE HOTORO KANO.','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 14:00:52',5,'479','2020-08-13 14:00:52','479');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16359 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','147',16357,'768',4497.99,2701.00,'2021-09-08','new dipping','2021-09-08 18:04:41','483','483',2021,'483','2021-09-08 18:04:41',5),('1','147',16358,'768',2546.55,2000.00,'2022-06-13','new','2022-06-13 11:40:25','483','483',2022,'483','2022-06-13 11:40:25',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2943 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','147','768',2139,'5','LPG NOZZLE ',1326286.15,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','147','768',2942,'5','LPG NOZZLE 2',412718.31,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258008 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','147',146994,'DAILY SHIFT','2020-08-04','2020-08-04 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-12 12:59:36','503','2020-08-12 13:00:40',10,0),('1','147',147001,'DAILY SHIFT','2020-08-05','2020-08-05 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-12 13:23:10','503','2020-08-12 13:24:58',10,0),('1','147',147011,'DAILY SHIFT','2020-08-06','2020-08-06 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-12 13:54:57','503','2020-08-12 13:55:36',10,0),('1','147',147028,'DAILY SHIFT','2020-08-07','2020-08-07 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-12 14:06:36','503','2020-08-12 14:07:07',10,0),('1','147',147033,'DAILY SHIFT','2020-08-07','2020-08-07 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-12 14:14:06','503','2020-08-12 14:14:36',10,0),('1','147',147038,'DAILY SHIFT','2020-08-08','2020-08-08 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-12 14:19:31','503','2020-08-12 14:19:58',10,0),('1','147',147045,'DAILY SHIFT','2020-08-09','2020-08-09 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-12 15:53:16','503','2020-08-12 15:53:53',10,0),('1','147',147074,'DAILY SHIFT','2020-08-10','2020-08-10 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-12 16:02:36','503','2020-08-12 16:03:07',10,0),('1','147',147082,'DAILY SHIFT','2020-08-11','2020-08-11 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-12 16:38:11','503','2020-08-12 16:38:30',10,0),('1','147',147154,'DAILY SHIFT','2020-08-13','2020-08-13 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-13 09:26:24','503','2020-08-13 09:26:53',10,0),('1','147',147192,'DAILY SHIFT','2020-08-13','2020-08-13 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-13 11:27:45','503','2020-08-13 11:28:12',10,0),('1','147',147300,'DAILY SHIFT','2020-08-13','2020-08-13 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-13 18:00:17','503','2020-08-13 18:00:53',10,0),('1','147',147424,'DAILY SHIFT','2020-08-14','2020-08-14 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-14 18:45:45','503','2020-08-14 18:46:22',10,0),('1','147',147552,'DAILY SHIFT','2020-08-15','2020-08-15 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-15 18:16:08','503','2020-08-15 18:17:11',10,0),('1','147',147671,'DAILY SHIFT','2020-08-16','2020-08-16 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-16 18:10:32','503','2020-08-16 18:11:31',10,0),('1','147',147853,'DAILY SHIFT','2020-08-17','2020-08-17 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-17 18:09:53','503','2020-08-17 18:10:29',10,0),('1','147',147982,'DAILY SHIFT','2020-08-18','2020-08-18 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-18 18:05:34','503','2020-08-18 18:06:07',10,0),('1','147',148115,'DAILY SHIFT','2020-08-19','2020-08-19 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-19 18:24:15','503','2020-08-19 18:26:13',10,0),('1','147',148262,'DAILY SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-20 17:11:31','503','2020-08-20 17:12:24',10,0),('1','147',148415,'DAILY SHIFT','2020-08-21','2020-08-21 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-21 18:37:50','503','2020-08-21 18:38:21',10,0),('1','147',148544,'DAILY SHIFT','2020-08-22','2020-08-22 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-22 17:45:43','503','2020-08-22 17:47:51',10,0),('1','147',148655,'DAILY SHIFT','2020-08-23','2020-08-23 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-23 18:11:11','503','2020-08-23 18:11:59',10,0),('1','147',148802,'DAILY SHIFT','2020-08-24','2020-08-24 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-24 18:17:48','503','2020-08-24 18:18:21',10,0),('1','147',148952,'DAILY SHIFT','2020-08-25','2020-08-25 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-25 18:01:29','503','2020-08-25 18:01:55',10,0),('1','147',149143,'DAILY SHIFT','2020-08-26','2020-08-26 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-26 18:40:12','503','2020-08-26 18:40:37',10,0),('1','147',149290,'DAILY SHIFT','2020-08-27','2020-08-27 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-27 17:59:25','503','2020-08-27 18:00:05',10,0),('1','147',149437,'DAILY SHIFT','2020-08-28','2020-08-28 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-28 18:26:59','503','2020-08-28 18:27:19',10,0),('1','147',149581,'DAILY SHIFT','2020-08-29','2020-08-29 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-29 17:04:56','503','2020-08-29 17:05:54',10,0),('1','147',149685,'DAILY SHIFT','2020-08-30','2020-08-30 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-30 18:07:08','503','2020-08-30 18:07:39',10,0),('1','147',149834,'DAILY SHIFT','2020-08-31','2020-08-31 00:00:00',NULL,'503',0.00,0.00,'503','2020-08-31 18:33:39','503','2020-08-31 18:34:31',10,0),('1','147',149989,'DAILY SHIFT','2020-09-01','2020-09-01 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-01 18:19:50','503','2020-09-01 18:20:24',10,0),('1','147',150138,'DAILY SHIFT','2020-09-02','2020-09-02 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-02 18:29:06','503','2020-09-02 18:29:31',10,0),('1','147',150361,'DAILY SHIF','2020-09-03','2020-09-03 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-03 18:27:00','503','2020-09-03 18:27:24',10,0),('1','147',150522,'DAILY SHIFT','2020-09-04','2020-09-04 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-04 16:52:33','503','2020-09-04 16:52:53',10,0),('1','147',150710,'DAILY SHIFT','2020-09-05','2020-09-05 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-05 19:29:34','503','2020-09-05 19:40:10',10,0),('1','147',150834,'DAILY SHIFT','2020-09-06','2020-09-06 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-06 18:20:50','503','2020-09-06 18:21:10',10,0),('1','147',150995,'DAILY SHIFT','2020-09-07','2020-09-07 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-07 19:41:58','503','2020-09-07 19:43:53',10,0),('1','147',151131,'DAILY SHIF','2020-09-08','2020-09-08 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-08 20:50:16','503','2020-09-08 20:51:55',10,0),('1','147',151290,'DAILY SHIFT','2020-09-09','2020-09-09 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-09 21:25:52','503','2020-09-09 21:27:07',10,0),('1','147',151456,'DAILY SHIFT','2020-09-11','2020-09-11 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-11 08:03:27','503','2020-09-11 08:03:47',10,0),('1','147',151593,'DAILY SHIFT','2020-09-11','2020-09-11 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-11 22:15:29','503','2020-09-11 22:17:21',10,0),('1','147',151706,'DAILY SHIFT','2020-09-12','2020-09-12 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-12 21:54:54','503','2020-09-12 21:56:32',10,0),('1','147',151832,'DAILY SHIFT','2020-09-13','2020-09-13 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-14 07:35:57','503','2020-09-14 07:36:18',10,0),('1','147',152021,'DAILY SHIFT','2020-09-14','2020-09-14 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-14 20:57:57','503','2020-09-14 21:00:35',10,0),('1','147',152167,'DAILY SHIFT','2020-09-15','2020-09-15 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-15 22:26:24','503','2020-09-15 22:29:30',10,0),('1','147',152327,'DAILY SHIFT','2020-09-16','2020-09-16 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-16 22:16:28','503','2020-09-16 22:17:58',10,0),('1','147',152541,'DAILY SHIFT','2020-09-17','2020-09-17 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-18 12:41:22','503','2020-09-18 12:41:41',10,0),('1','147',152581,'DAILY SHIFT ','2020-09-17','2020-09-17 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-18 21:08:07','503','2020-09-18 21:08:31',10,0),('1','147',152781,'DAILY SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-19 22:19:44','503','2020-09-19 22:20:47',10,0),('1','147',152902,'DAILY SHIF','2020-09-20','2020-09-20 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-20 22:01:50','503','2020-09-20 22:05:01',10,0),('1','147',153090,'DAILY SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-21 21:51:25','503','2020-09-21 21:52:55',10,0),('1','147',153281,'DAILY SHIFT','2020-09-22','2020-09-22 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-22 21:45:54','503','2020-09-22 21:46:17',10,0),('1','147',153282,'DAILY SHIFT','2020-09-22','2020-09-22 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-22 22:00:08','503','2020-09-22 22:04:19',10,0),('1','147',153477,'DAILY SHIFT','2020-09-23','2020-09-23 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-23 21:11:05','503','2020-09-23 21:11:53',10,0),('1','147',153689,'DAILY SHIFT','2020-09-24','2020-09-24 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-25 10:16:58','503','2020-09-25 10:17:42',10,0),('1','147',153805,'DAILY SHIFT','2020-09-25','2020-09-25 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-25 21:32:27','503','2020-09-25 21:35:00',10,0),('1','147',153932,'DAILY SHIFT','2020-09-26','2020-09-26 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-26 23:48:31','503','2020-09-26 23:50:32',10,0),('1','147',153933,'DAILY SHIFT','2020-09-26','2020-09-26 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-27 00:07:18','503','2020-09-27 00:08:02',10,0),('1','147',154065,'Daily shift','2020-09-27','2020-09-27 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-27 21:02:25','503','2020-09-27 21:26:18',10,0),('1','147',154253,'Daily shift','2020-09-28','2020-09-28 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-28 22:10:41','503','2020-09-28 22:11:05',10,0),('1','147',154421,'Daily shift','2020-09-29','2020-09-29 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-30 07:26:01','503','2020-09-30 07:26:39',10,0),('1','147',154574,'Daily shift','2020-09-30','2020-09-30 00:00:00',NULL,'503',0.00,0.00,'503','2020-09-30 18:42:46','503','2020-09-30 18:43:35',10,0),('1','147',154756,'DAILY SHIFT','2020-10-01','2020-10-01 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-02 08:53:22','503','2020-10-02 08:55:22',10,0),('1','147',154890,'DAILY SHIFT','2020-10-02','2020-10-02 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-03 07:36:18','503','2020-10-03 07:37:36',10,0),('1','147',155010,'DAILY SHIFT','2020-10-03','2020-10-03 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-03 18:27:35','503','2020-10-03 18:28:04',10,0),('1','147',155011,'DAILY SHIFT','2020-10-03','2020-10-03 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-03 18:38:23','503','2020-10-03 18:39:16',10,0),('1','147',155153,'DAILY SHIFT','2020-10-04','2020-10-04 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-05 08:19:06','503','2020-10-05 08:19:28',10,0),('1','147',155319,'DAILY SHIFT','2020-10-05','2020-10-05 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-06 07:55:40','503','2020-10-06 07:56:00',10,0),('1','147',155431,'DAILY SHIFT','2020-10-06','2020-10-06 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-06 16:36:33','503','2020-10-06 16:37:00',10,0),('1','147',155444,'DAILY SHIFT','2020-10-06','2020-10-06 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-06 17:26:20','503','2020-10-06 17:26:41',10,0),('1','147',155658,'DAILY SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-08 08:01:32','503','2020-10-08 08:02:16',10,0),('1','147',155783,'Daily shift','2020-10-08','2020-10-08 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-08 21:45:45','503','2020-10-08 21:47:55',10,0),('1','147',155914,'DAILY SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-09 18:00:00','503','2020-10-09 18:01:20',10,0),('1','147',156071,'DAILY SHIFT','2020-10-10','2020-10-10 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-10 18:20:22','503','2020-10-10 18:20:38',10,0),('1','147',156238,'DAILY SHIFT','2020-10-11','2020-10-11 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-12 08:10:35','503','2020-10-12 08:10:58',10,0),('1','147',156402,'DAILY SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-12 17:58:33','503','2020-10-12 17:58:49',10,0),('1','147',156563,'DAILY SHIFT','2020-10-13','2020-10-13 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-13 18:26:51','503','2020-10-13 18:27:36',10,0),('1','147',156740,'Daily shift','2020-10-14','2020-10-14 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-14 22:00:26','503','2020-10-14 22:00:45',10,0),('1','147',156918,'DAILY SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-16 07:42:39','503','2020-10-16 07:44:14',10,0),('1','147',157111,'DAILY SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-17 08:26:11','503','2020-10-17 08:26:36',10,0),('1','147',157264,'DAILY SHIFT','2020-10-17','2020-10-17 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-17 18:03:53','503','2020-10-17 18:04:46',10,0),('1','147',157476,'DAILY SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-19 07:50:53','503','2020-10-19 07:51:48',10,0),('1','147',157638,'DAILY SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-19 17:56:24','503','2020-10-19 17:56:54',10,0),('1','147',157808,'DAILY SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-20 18:43:23','503','2020-10-20 18:49:24',10,0),('1','147',157944,'DAILY SHIFT','2020-10-21','2020-10-21 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-21 18:11:56','503','2020-10-21 18:14:54',10,0),('1','147',158097,'Daily shift','2020-10-23','2020-10-23 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-23 07:31:27','503','2020-10-23 07:32:00',10,0),('1','147',158274,'DAILY SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-24 08:36:01','503','2020-10-24 08:36:42',10,0),('1','147',158294,'DAILY SHIFT','2020-10-24','2020-10-24 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-24 10:34:34','503','2020-10-24 10:35:24',10,0),('1','147',158429,'Daily shift','2020-10-24','2020-10-24 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-25 05:35:08','503','2020-10-25 05:35:58',10,0),('1','147',158610,'Daily shift','2020-10-25','2020-10-25 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-26 09:05:54','503','2020-10-26 09:08:24',10,0),('1','147',158775,'DAILY SHIFT','2020-10-26','2020-10-26 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-27 08:03:07','503','2020-10-27 08:03:26',10,0),('1','147',158904,'DAILY SHIFT','2020-10-27','2020-10-27 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-27 16:22:38','503','2020-10-27 16:22:59',10,0),('1','147',158908,'DAILY SHIFT','2020-10-27','2020-10-27 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-27 16:38:43','503','2020-10-27 16:39:45',10,0),('1','147',159281,'Daily shift','2020-10-29','2020-10-29 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-29 23:50:22','503','2020-10-29 23:51:10',10,0),('1','147',159282,'Bulk sale','2020-10-29','2020-10-29 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-30 22:35:27','503','2020-10-30 22:36:30',10,0),('1','147',159461,'Daily shift','2020-10-30','2020-10-30 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-30 23:38:31','503','2020-10-30 23:38:58',10,0),('1','147',159641,'Morning shift','2020-10-31','2020-10-31 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-31 21:39:47','503','2020-10-31 21:40:36',10,0),('1','147',159642,'Afternoon shift','2020-10-31','2020-10-31 00:00:00',NULL,'503',0.00,0.00,'503','2020-10-31 21:52:34','503','2020-10-31 21:53:12',10,0),('1','147',159643,'Bulk sale','2020-10-31','2020-10-31 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-01 22:24:51','503','2020-11-01 22:27:35',10,0),('1','147',159744,'Daily shift','2020-11-01','2020-11-01 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-01 22:31:37','503','2020-11-01 22:31:53',10,0),('1','147',159954,'DAILY SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-03 07:00:59','503','2020-11-03 07:01:19',10,0),('1','147',159963,'BUIK SALE','2020-11-03','2020-11-03 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-03 07:22:32','503','2020-11-03 07:23:14',10,0),('1','147',160115,'DAILY SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-03 17:59:48','503','2020-11-03 18:00:06',10,0),('1','147',160260,'DAILY SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-05 08:23:36','503','2020-11-05 08:25:35',10,0),('1','147',160448,'DAILY SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-05 17:51:36','503','2020-11-05 17:51:58',10,0),('1','147',160594,'DAILY SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-06 18:58:21','503','2020-11-06 19:01:44',10,0),('1','147',160596,'DAILY SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-06 19:46:40','503','2020-11-06 19:48:14',10,0),('1','147',160601,'DAILY SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-07 09:51:14','503','2020-11-07 09:52:09',10,0),('1','147',160734,'DAILY SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-07 18:00:31','503','2020-11-07 18:01:11',10,0),('1','147',160917,'DAILYSHIFT','2020-11-09','2020-11-09 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-09 10:18:51','503','2020-11-09 10:19:17',10,0),('1','147',161100,'DAILY SHIFT','2020-11-09','2020-11-09 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-10 07:55:14','503','2020-11-10 07:55:40',10,0),('1','147',161260,'DAILY SHIFT','2020-11-10','2020-11-10 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-10 18:06:24','503','2020-11-10 18:07:15',10,0),('1','147',161441,'DAILY SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-11 18:01:25','503','2020-11-11 18:01:43',10,0),('1','147',161649,'DAILY SHIFT','2020-11-12','2020-11-12 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-12 17:47:26','503','2020-11-12 17:47:44',10,0),('1','147',161891,'DAILY SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-14 09:21:20','503','2020-11-14 09:21:41',10,0),('1','147',162048,'DAILY SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-14 20:48:05','503','2020-11-14 20:48:49',10,0),('1','147',162221,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-16 10:40:08','503','2020-11-16 10:41:03',10,0),('1','147',162446,'DAILY SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-16 18:01:50','503','2020-11-16 18:02:10',10,0),('1','147',162646,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-17 21:34:20','503','2020-11-17 21:35:15',10,0),('1','147',162647,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-17 21:47:28','503','2020-11-17 21:49:02',10,0),('1','147',162827,'DAILY SHIFT','2020-11-18','2020-11-18 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-18 21:21:19','503','2020-11-18 21:22:01',10,0),('1','147',163021,'DAILY SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-20 07:04:21','503','2020-11-20 07:04:39',10,0),('1','147',163264,'DAILY SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-21 09:55:09','503','2020-11-21 09:56:32',10,0),('1','147',163268,'DAILY SHIFT','2020-11-21','2020-11-21 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-21 10:11:53','503','2020-11-21 10:12:56',10,0),('1','147',163381,'DAILY SHIFT ','2020-11-21','2020-11-21 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-21 20:52:05','503','2020-11-21 20:52:24',10,0),('1','147',163544,'DAILY SHIFT ','2020-11-22','2020-11-22 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-23 20:30:44','503','2020-11-23 20:31:05',10,0),('1','147',163745,'DAILY SHIFT ','2020-11-23','2020-11-23 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-23 20:35:36','503','2020-11-23 20:35:56',10,0),('1','147',163905,'DAILY SHIFT ','2020-11-24','2020-11-24 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-24 22:10:45','503','2020-11-24 22:11:06',10,0),('1','147',164091,'DAILY SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-25 23:01:50','503','2020-11-25 23:02:36',10,0),('1','147',164259,'DAILY SHIFT ','2020-11-26','2020-11-26 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-26 19:16:53','503','2020-11-26 19:17:18',10,0),('1','147',164447,'DAILY SHIFT ','2020-11-27','2020-11-27 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-27 20:24:33','503','2020-11-27 20:24:53',10,0),('1','147',164604,'DAILY SHIFT ','2020-11-28','2020-11-28 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-28 19:26:55','503','2020-11-28 19:27:24',10,0),('1','147',164977,'DAILY SHIFT ','2020-11-29','2020-11-29 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-30 21:58:26','503','2020-11-30 21:59:40',10,0),('1','147',164978,'DAILY SHIFT ','2020-11-30','2020-11-30 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-30 22:07:50','503','2020-11-30 22:08:09',10,0),('1','147',164979,'DAILY SHIFT ','2020-11-30','2020-11-30 00:00:00',NULL,'503',0.00,0.00,'503','2020-11-30 22:13:07','503','2020-11-30 22:13:32',10,0),('1','147',165114,'DAILY SHIFT ','2020-12-01','2020-12-01 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-02 21:49:42','503','2020-12-02 21:50:03',10,0),('1','147',165314,'DAILY SHIFT ','2020-12-02','2020-12-02 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-03 20:42:48','503','2020-12-03 20:43:40',10,0),('1','147',165446,'DAILY SHIFT ','2020-12-03','2020-12-03 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-03 20:49:02','503','2020-12-03 20:49:24',10,0),('1','147',165660,'DAILY SHIFT ','2020-12-05','2020-12-05 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-05 08:45:11','503','2020-12-05 08:45:39',10,0),('1','147',165799,'DAILY SHIFT ','2020-12-05','2020-12-05 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-05 21:34:45','503','2020-12-05 21:35:10',10,0),('1','147',165932,'DAILY SHIFT ','2020-12-06','2020-12-06 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-06 20:21:57','503','2020-12-06 20:22:32',10,0),('1','147',166138,'DAILY SHIFT ','2020-12-07','2020-12-07 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-07 18:34:19','503','2020-12-07 18:34:39',10,0),('1','147',166323,'DAILY SHIFT ','2020-12-08','2020-12-08 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-08 20:27:24','503','2020-12-08 20:27:45',10,0),('1','147',166487,'DAILYSHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-10 18:03:55','503','2020-12-10 18:04:14',10,0),('1','147',166688,'DAILY SHIFT ','2020-12-10','2020-12-10 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-10 18:07:52','503','2020-12-10 18:08:32',10,0),('1','147',166858,'DAILY SHIFT ','2020-12-11','2020-12-11 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-11 16:18:36','503','2020-12-11 16:19:31',10,0),('1','147',166889,'DAILY SHIFT ','2020-12-11','2020-12-11 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-11 19:46:04','503','2020-12-11 19:46:29',10,0),('1','147',167047,'DAILY SHIFT ','2020-12-12','2020-12-12 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-13 05:48:23','503','2020-12-13 05:48:52',10,0),('1','147',167189,'DAILY SHIFT ','2020-12-13','2020-12-13 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-14 07:29:00','503','2020-12-14 07:29:38',10,0),('1','147',167375,'DAILY SHIFT ','2020-12-14','2020-12-14 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-14 19:23:18','503','2020-12-14 19:24:03',10,0),('1','147',167380,'DAILY SHIFT ','2020-12-14','2020-12-14 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-14 19:59:57','503','2020-12-14 20:00:18',10,0),('1','147',167563,'DAILYSHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-15 18:08:21','503','2020-12-15 18:08:49',10,0),('1','147',167741,'DAILYSHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-16 20:36:08','503','2020-12-16 20:36:40',10,0),('1','147',167891,'DAILY SHIFT ','2020-12-17','2020-12-17 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-17 16:48:17','503','2020-12-17 16:48:37',10,0),('1','147',168134,'DAILY SHIFT ','2020-12-18','2020-12-18 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-18 20:19:07','503','2020-12-18 20:19:43',10,0),('1','147',168281,'DAILYSHIFT','2020-12-19','2020-12-19 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-19 18:21:48','503','2020-12-19 18:23:12',10,0),('1','147',168361,'DAILY SHIFT ','2020-12-20','2020-12-20 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-20 13:42:59','503','2020-12-20 13:43:17',10,0),('1','147',168407,'DAILY SHIFT ','2020-12-20','2020-12-20 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-20 18:32:15','503','2020-12-20 18:33:15',10,0),('1','147',168607,'DAILY SHIFT ','2020-12-21','2020-12-21 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-21 18:34:28','503','2020-12-21 18:34:47',10,0),('1','147',168765,'DAILY SHIFT ','2020-12-22','2020-12-22 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-22 18:00:42','503','2020-12-22 18:01:08',10,0),('1','147',168924,'DAILY SHIFT ','2020-12-23','2020-12-23 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-23 17:43:18','503','2020-12-23 17:43:47',10,0),('1','147',169060,'DAILY SHIFT ','2020-12-24','2020-12-24 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-24 15:14:08','503','2020-12-24 15:14:29',10,0),('1','147',169106,'DAILY SHIFT ','2020-12-24','2020-12-24 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-24 19:21:41','503','2020-12-24 19:22:05',10,0),('1','147',169250,'DAILY SHIFT ','2020-12-25','2020-12-25 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-25 17:14:43','503','2020-12-25 17:15:15',10,0),('1','147',169256,'DAILY SHIFT ','2020-12-25','2020-12-25 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-25 17:59:45','503','2020-12-25 18:00:10',10,0),('1','147',169433,'DAILY SHIFT ','2020-12-26','2020-12-26 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-26 18:05:30','503','2020-12-26 18:05:47',10,0),('1','147',169572,'DAILY SHIFT ','2020-12-27','2020-12-27 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-27 19:03:28','503','2020-12-27 19:03:47',10,0),('1','147',169777,'DAILY SHIFT ','2020-12-28','2020-12-28 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-28 21:11:01','503','2020-12-28 21:11:26',10,0),('1','147',169778,'DAILY SHIFT ','2020-12-28','2020-12-28 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-28 21:19:39','503','2020-12-28 21:19:58',10,0),('1','147',169939,'DAILY SHIFT ','2020-12-29','2020-12-29 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-29 21:31:08','503','2020-12-29 21:31:28',10,0),('1','147',170150,'DAILY SHIFT ','2020-12-30','2020-12-30 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-30 20:04:58','503','2020-12-30 20:05:16',10,0),('1','147',170346,'DAILY SHIFT ','2020-12-31','2020-12-31 00:00:00',NULL,'503',0.00,0.00,'503','2020-12-31 21:40:52','503','2020-12-31 21:41:15',10,0),('1','147',170441,'DAILY SHIFT ','2021-01-01','2021-01-01 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-01 14:31:45','503','2021-01-01 14:32:03',10,0),('1','147',170499,'DAILY SHIFT ','2021-01-01','2021-01-01 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-01 22:06:01','503','2021-01-01 22:06:19',10,0),('1','147',170645,'DAILY SHIFT ','2021-01-02','2021-01-02 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-02 18:06:07','503','2021-01-02 18:06:27',10,0),('1','147',170966,'DAILY SHIFT ','2021-01-03','2021-01-03 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-04 17:10:56','503','2021-01-04 17:11:29',10,0),('1','147',171004,'DAILY SHIFT ','2021-01-04','2021-01-04 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-04 21:24:16','503','2021-01-04 21:24:45',10,0),('1','147',171220,'DAILY SHIFT ','2021-01-05','2021-01-05 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-06 07:03:11','503','2021-01-06 07:04:00',10,0),('1','147',171363,'DAILYSHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-06 18:12:03','503','2021-01-06 18:12:28',10,0),('1','147',171367,'DAILYSHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-06 18:27:46','503','2021-01-06 18:28:17',10,0),('1','147',171585,'DAILY SHIFT ','2021-01-07','2021-01-07 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-07 20:54:46','503','2021-01-07 20:55:10',10,0),('1','147',171764,'DAILY SHIFT ','2021-01-08','2021-01-08 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-08 19:19:42','503','2021-01-08 19:20:29',10,0),('1','147',171966,'DAILYSHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-10 08:09:31','503','2021-01-10 08:10:06',10,0),('1','147',171967,'DAILYSHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-10 08:27:33','503','2021-01-10 08:27:56',10,0),('1','147',172079,'DAILYSHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-10 19:02:26','503','2021-01-10 19:03:00',10,0),('1','147',172270,'DAILYSHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-11 18:52:18','503','2021-01-11 18:52:42',10,0),('1','147',172489,'DAILYSHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-12 18:45:56','503','2021-01-12 18:46:18',10,0),('1','147',172701,'Daily shift','2021-01-13','2021-01-13 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-13 21:25:36','503','2021-01-13 21:26:03',10,0),('1','147',172875,'Daily shift','2021-01-14','2021-01-14 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-14 19:33:45','503','2021-01-14 19:34:26',10,0),('1','147',173056,'Daily shift','2021-01-15','2021-01-15 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-15 20:49:27','503','2021-01-15 20:50:37',10,0),('1','147',173222,'Daily shift','2021-01-16','2021-01-16 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-16 22:08:03','503','2021-01-16 22:08:18',10,0),('1','147',173389,'Daily shift','2021-01-17','2021-01-17 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-18 21:40:03','503','2021-01-18 21:40:24',10,0),('1','147',173600,'Daily shift','2021-01-18','2021-01-18 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-18 21:42:06','503','2021-01-18 21:42:21',10,0),('1','147',173764,'Daily shift','2021-01-19','2021-01-19 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-19 20:18:43','503','2021-01-19 20:18:56',10,0),('1','147',173944,'Daily shift','2021-01-20','2021-01-20 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-20 20:21:39','503','2021-01-20 20:21:55',10,0),('1','147',174029,'DAILYSHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-21 11:51:30','503','2021-01-21 11:51:49',10,0),('1','147',174127,'Daily shift','2021-01-21','2021-01-21 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-21 20:08:36','503','2021-01-21 20:08:50',10,0),('1','147',174128,'Daily shift','2021-01-21','2021-01-21 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-21 20:14:16','503','2021-01-21 20:14:30',10,0),('1','147',174317,'Daily shift','2021-01-22','2021-01-22 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-22 19:13:08','503','2021-01-22 19:13:23',10,0),('1','147',174389,'DAILYSHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-23 19:50:48','503','2021-01-23 19:51:32',10,0),('1','147',174627,'DAILYSHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-24 18:45:13','503','2021-01-24 18:45:40',10,0),('1','147',174838,'DAILYSHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-25 19:02:48','503','2021-01-25 19:03:19',10,0),('1','147',175031,'DAILYSHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-26 18:57:54','503','2021-01-26 18:59:04',10,0),('1','147',175233,'Daily shift','2021-01-27','2021-01-27 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-27 19:27:49','503','2021-01-27 19:28:01',10,0),('1','147',175235,'Daily shift','2021-01-27','2021-01-27 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-27 19:33:35','503','2021-01-27 19:33:55',10,0),('1','147',175400,'DAILYSHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-28 18:27:19','503','2021-01-28 18:28:33',10,0),('1','147',175589,'DAILYSHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-29 19:09:50','503','2021-01-29 19:11:15',10,0),('1','147',175760,'Daily shift','2021-01-30','2021-01-30 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-30 22:26:24','503','2021-01-30 22:27:21',10,0),('1','147',175918,'Daily shift','2021-01-31','2021-01-31 00:00:00',NULL,'503',0.00,0.00,'503','2021-01-31 20:31:07','503','2021-01-31 20:31:28',10,0),('1','147',176144,'Daily shift','2021-02-01','2021-02-01 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-01 21:42:43','503','2021-02-01 21:43:02',10,0),('1','147',176145,'Daily shift','2021-02-01','2021-02-01 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-02 19:08:19','503','2021-02-02 19:08:33',10,0),('1','147',176315,'Daily shift','2021-02-02','2021-02-02 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-02 19:12:16','503','2021-02-02 19:12:34',10,0),('1','147',176547,'Daily shift','2021-02-03','2021-02-03 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-03 20:23:43','503','2021-02-03 20:24:22',10,0),('1','147',176791,'DAILY SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-05 07:23:49','503','2021-02-05 07:24:09',10,0),('1','147',176798,'DAILY SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-05 08:16:18','503','2021-02-05 08:16:39',10,0),('1','147',176960,'DAILYSHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-05 18:43:12','503','2021-02-05 18:44:03',10,0),('1','147',177214,'DAILYSHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-06 20:01:34','503','2021-02-06 20:02:28',10,0),('1','147',177409,'DAILYSHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-07 18:57:00','503','2021-02-07 18:57:25',10,0),('1','147',177622,'Daily shift','2021-02-08','2021-02-08 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-08 21:30:23','503','2021-02-08 21:30:44',10,0),('1','147',177874,'Daily shift','2021-02-09','2021-02-09 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-09 19:47:22','503','2021-02-09 19:47:36',10,0),('1','147',178070,'Daily shift','2021-02-10','2021-02-10 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-10 20:01:58','503','2021-02-10 20:02:15',10,0),('1','147',178071,'Daily shift','2021-02-10','2021-02-10 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-10 20:07:02','503','2021-02-10 20:07:17',10,0),('1','147',178278,'DAILYSHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-11 18:58:38','503','2021-02-11 18:59:07',10,0),('1','147',178490,'Daily shift','2021-02-12','2021-02-12 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-12 21:55:56','503','2021-02-12 21:56:13',10,0),('1','147',178708,'Daily shift','2021-02-13','2021-02-13 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-15 14:07:58','503','2021-02-15 14:08:45',10,0),('1','147',179037,'DAILYSHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-15 14:13:25','503','2021-02-15 14:13:56',10,0),('1','147',179039,'DAILYSHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-15 19:49:50','503','2021-02-15 19:50:38',10,0),('1','147',179141,'DAILYSHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-16 18:38:17','503','2021-02-17 06:01:42',10,0),('1','147',179364,'DAILYSHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-17 08:44:58','503','2021-02-17 08:46:11',10,0),('1','147',179414,'DAILYSHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-17 18:35:22','503','2021-02-17 18:36:10',10,0),('1','147',179568,'DAILYSHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-18 18:49:32','503','2021-02-18 18:50:30',10,0),('1','147',179789,'DAILYSHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-19 18:44:07','503','2021-02-19 18:45:16',10,0),('1','147',180003,'DAILYSHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-20 10:24:51','503','2021-02-20 10:25:20',10,0),('1','147',180058,'DAILYSHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-21 11:22:04','503','2021-02-21 11:22:20',10,0),('1','147',180223,'Daily shift','2021-02-21','2021-02-21 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-21 11:41:57','503','2021-02-21 11:42:12',10,0),('1','147',180240,'DAILYSHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-21 18:16:36','503','2021-02-21 18:17:12',10,0),('1','147',180340,'DAILYSHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-22 19:14:02','503','2021-02-22 19:14:48',10,0),('1','147',180555,'DAILYSHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-23 13:34:18','503','2021-02-23 13:34:57',10,0),('1','147',180674,'DAILYSHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-23 18:47:03','503','2021-02-23 18:47:55',10,0),('1','147',180736,'DAILYSHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-24 18:55:58','503','2021-02-24 18:56:38',10,0),('1','147',180959,'DAILYSHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-25 18:11:26','503','2021-02-25 18:12:06',10,0),('1','147',181131,'DAILYSHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-26 17:56:44','503','2021-02-26 17:57:15',10,0),('1','147',181419,'DAILYSHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-27 18:38:48','503','2021-02-27 18:39:26',10,0),('1','147',181524,'DAILYSHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'503',0.00,0.00,'503','2021-02-28 18:19:51','503','2021-02-28 18:20:36',10,0),('1','147',181703,'DAILYSHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-01 19:19:54','503','2021-03-01 19:20:30',10,0),('1','147',182028,'DAILYSHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-02 18:20:40','503','2021-03-02 18:21:33',10,0),('1','147',182103,'DAILYSHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-03 19:05:51','503','2021-03-03 19:06:24',10,0),('1','147',182307,'DAILYSHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-04 18:37:49','503','2021-03-04 18:38:21',10,0),('1','147',182498,'DAILYSHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-05 10:39:30','503','2021-03-05 10:39:57',10,0),('1','147',182559,'DAILYSHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-08 12:01:36','503','2021-03-08 12:02:11',10,0),('1','147',183087,'DAILYSHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-08 16:39:30','503','2021-03-08 16:40:02',10,0),('1','147',183164,'DAILYSHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-08 16:43:59','503','2021-03-08 16:44:30',10,0),('1','147',183169,'DAILYSHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-08 18:47:14','503','2021-03-08 18:47:49',10,0),('1','147',183196,'DAILYSHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-09 06:34:57','503','2021-03-09 06:35:33',10,0),('1','147',183210,'DAILYSHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-09 11:22:39','503','2021-03-09 11:23:30',10,0),('1','147',183322,'DAILYSHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-09 18:23:05','503','2021-03-09 18:23:52',10,0),('1','147',183426,'DAILYSHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-10 18:46:39','503','2021-03-10 18:48:37',10,0),('1','147',183652,'DAILYSHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-11 18:44:17','503','2021-03-11 18:45:09',10,0),('1','147',183900,'DAILYSHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-13 07:10:15','503','2021-03-13 11:01:41',10,0),('1','147',184127,'DAILYSHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-13 11:54:00','503','2021-03-13 11:54:28',10,0),('1','147',184147,'DAILYSHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-13 18:34:31','503','2021-03-13 18:35:14',10,0),('1','147',184268,'DAILYSHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-14 18:25:33','503','2021-03-14 18:27:19',10,0),('1','147',184512,'DAILYSHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-15 18:00:10','503','2021-03-15 18:00:40',10,0),('1','147',184748,'DAILYSHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-16 09:50:36','503','2021-03-16 09:51:08',10,0),('1','147',184775,'DAILYSHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-16 18:14:18','503','2021-03-16 18:14:49',10,0),('1','147',184908,'DAILYSHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-18 09:35:02','503','2021-03-18 09:35:34',10,0),('1','147',185154,'DAILYSHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-18 18:45:15','503','2021-03-18 18:45:55',10,0),('1','147',185278,'DAILYSHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-19 18:12:53','503','2021-03-19 18:13:32',10,0),('1','147',185480,'DAILYSHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-20 11:13:22','503','2021-03-20 11:13:56',10,0),('1','147',185538,'DAILYSHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-20 18:37:04','503','2021-03-20 18:37:49',10,0),('1','147',185673,'DAILYSHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-21 10:24:01','503','2021-03-21 10:24:31',10,0),('1','147',185764,'DAILYSHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-21 18:02:01','503','2021-03-21 18:03:16',10,0),('1','147',185871,'DAILYSHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-22 18:58:11','503','2021-03-22 18:58:47',10,0),('1','147',186087,'DAILYSHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-23 18:43:24','503','2021-03-23 18:43:58',10,0),('1','147',186309,'DAILYSHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-24 16:05:30','503','2021-03-24 16:06:15',10,0),('1','147',186492,'DAILYSHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-24 18:27:25','503','2021-03-24 18:27:58',10,0),('1','147',186537,'DAILYSHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-25 18:49:42','503','2021-03-25 18:51:04',10,0),('1','147',186747,'DAILYSHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-26 18:47:38','503','2021-03-26 18:48:33',10,0),('1','147',186977,'DAILYSHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-27 18:40:44','503','2021-03-27 18:41:20',10,0),('1','147',187160,'DAILYSHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-28 08:40:55','503','2021-03-28 08:41:28',10,0),('1','147',187284,'DAILYSHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-28 18:35:19','503','2021-03-28 18:35:56',10,0),('1','147',187347,'DAILYSHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-29 18:49:59','503','2021-03-29 18:50:29',10,0),('1','147',187571,'DAILYSHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'503',0.00,0.00,'503','2021-03-30 18:54:31','503','2021-03-30 18:55:36',10,0),('1','147',187793,'DAILYSHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-01 07:47:15','503','2021-04-01 07:47:42',10,0),('1','147',188043,'DAILYSHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-01 19:18:49','503','2021-04-01 19:19:24',10,0),('1','147',188206,'DAILYSHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-02 17:00:24','503','2021-04-02 17:00:54',10,0),('1','147',188509,'DAILYSHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-03 19:29:48','503','2021-04-03 19:30:16',10,0),('1','147',188600,'DAILYSHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-05 10:30:57','503','2021-04-05 10:32:40',10,0),('1','147',188984,'DAILYSHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-05 20:50:05','503','2021-04-05 20:51:05',10,0),('1','147',189083,'DAILYSHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-06 19:00:32','503','2021-04-06 19:01:03',10,0),('1','147',189195,'DAILYSHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-07 14:58:59','503','2021-04-07 14:59:30',10,0),('1','147',189347,'DAILYSHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-07 18:58:35','503','2021-04-07 18:59:43',10,0),('1','147',189417,'DAILYSHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-08 18:45:07','503','2021-04-08 18:46:15',10,0),('1','147',189624,'DAILYSHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-09 18:27:26','503','2021-04-09 18:28:26',10,0),('1','147',189810,'DAILYSHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-10 16:06:16','503','2021-04-10 16:06:50',10,0),('1','147',190066,'DAILYSHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-11 19:09:02','503','2021-04-11 19:09:41',10,0),('1','147',190207,'DAILYSHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-12 18:46:13','503','2021-04-12 18:47:19',10,0),('1','147',190429,'DAILYSHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-14 13:15:29','503','2021-04-14 13:16:12',10,0),('1','147',190904,'DAILYSHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-15 07:48:27','503','2021-04-15 07:48:56',10,0),('1','147',190927,'DAILYSHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-16 09:20:56','503','2021-04-16 09:21:33',10,0),('1','147',191129,'DAILYSHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-21 16:35:33','503','2021-04-21 16:36:10',10,0),('1','147',192294,'daily ','2021-04-17','2021-04-17 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-21 16:47:19','503','2021-04-21 16:47:59',10,0),('1','147',192309,'Daily','2021-04-17','2021-04-17 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-21 19:24:58','503','2021-04-21 19:25:26',10,0),('1','147',192310,'Daily','2021-04-18','2021-04-18 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-21 19:35:03','503','2021-04-21 19:35:47',10,0),('1','147',192311,'Daily','2021-04-19','2021-04-19 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-21 19:44:37','503','2021-04-21 19:45:03',10,0),('1','147',192314,'Daily ','2021-04-20','2021-04-20 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-21 19:58:02','503','2021-04-21 19:58:22',10,0),('1','147',192319,'Daily','2021-04-21','2021-04-21 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-21 21:29:26','503','2021-04-21 21:32:16',10,0),('1','147',192412,'daily ','2021-04-22','2021-04-22 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-22 19:13:50','503','2021-04-22 19:14:42',10,0),('1','147',192563,'Daily','2021-04-23','2021-04-23 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-23 20:39:38','503','2021-04-23 20:40:25',10,0),('1','147',192749,'Daily','2021-04-24','2021-04-24 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-24 14:12:27','503','2021-04-24 14:13:21',10,0),('1','147',192891,'daily 645','2021-04-24','2021-04-24 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-25 04:47:49','503','2021-04-25 04:48:12',10,0),('1','147',192945,'Daily ','2021-04-25','2021-04-25 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-25 18:21:38','503','2021-04-25 18:22:20',10,0),('1','147',193167,'Daily','2021-04-26','2021-04-26 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-26 18:38:27','503','2021-04-26 18:39:02',10,0),('1','147',193409,'Daily','2021-04-27','2021-04-27 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-27 18:22:03','503','2021-04-27 18:22:48',10,0),('1','147',193655,'daily ','2021-04-28','2021-04-28 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-28 18:28:29','503','2021-04-28 18:29:32',10,0),('1','147',193888,'daily ','2021-04-29','2021-04-29 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-29 18:29:06','503','2021-04-29 18:30:05',10,0),('1','147',194086,'Daily','2021-04-30','2021-04-30 00:00:00',NULL,'503',0.00,0.00,'503','2021-04-30 18:31:14','503','2021-04-30 18:31:33',10,0),('1','147',194350,'Daily','2021-05-01','2021-05-01 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-01 09:11:01','503','2021-05-01 09:11:23',10,0),('1','147',194417,'daily ','2021-05-01','2021-05-01 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-01 18:40:41','503','2021-05-01 18:41:48',10,0),('1','147',194489,'Daily','2021-05-02','2021-05-02 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-02 18:16:40','503','2021-05-02 18:17:44',10,0),('1','147',194675,'Daily ','2021-05-03','2021-05-03 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-03 17:30:32','503','2021-05-03 17:31:18',10,0),('1','147',194923,'daily ','2021-05-04','2021-05-04 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-04 18:18:19','503','2021-05-04 18:19:14',10,0),('1','147',195087,'Daily','2021-05-05','2021-05-05 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-05 18:19:51','503','2021-05-05 18:20:48',10,0),('1','147',195305,'Daily','2021-05-06','2021-05-06 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-06 18:33:18','503','2021-05-06 18:34:29',10,0),('1','147',195522,'Daily','2021-05-07','2021-05-07 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-07 10:33:04','503','2021-05-07 10:34:10',10,0),('1','147',195647,'daily ','2021-05-07','2021-05-07 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-07 18:29:18','503','2021-05-07 18:30:34',10,0),('1','147',195764,'Daily ','2021-05-08','2021-05-08 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-08 18:34:54','503','2021-05-08 18:37:09',10,0),('1','147',195999,'Daily ','2021-05-09','2021-05-09 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-09 18:05:50','503','2021-05-09 18:06:36',10,0),('1','147',196275,'daily ','2021-05-10','2021-05-10 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-10 18:20:18','503','2021-05-10 18:21:03',10,0),('1','147',196461,'daily ','2021-05-11','2021-05-11 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-11 18:25:16','503','2021-05-11 18:26:11',10,0),('1','147',196661,'daily ','2021-05-12','2021-05-12 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-12 18:25:11','503','2021-05-12 18:26:14',10,0),('1','147',196908,'daily ','2021-05-13','2021-05-13 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-13 14:10:26','503','2021-05-13 14:12:28',10,0),('1','147',197079,'daily ','2021-05-14','2021-05-14 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-14 18:22:35','503','2021-05-14 18:23:46',10,0),('1','147',197362,'DAILY','2021-05-15','2021-05-15 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-16 13:20:36','503','2021-05-16 13:20:59',10,0),('1','147',197410,'Daily','2021-05-16','2021-05-16 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-16 17:02:41','503','2021-05-16 17:03:04',10,0),('1','147',197564,'DAILY','2021-05-17','2021-05-17 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-17 18:27:38','503','2021-05-17 18:28:06',10,0),('1','147',197930,'DAILY','2021-05-18','2021-05-18 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-18 18:32:31','503','2021-05-18 18:33:18',10,0),('1','147',198146,'DAILY','2021-05-19','2021-05-19 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-19 18:22:55','503','2021-05-19 18:24:10',10,0),('1','147',198364,'DAILY','2021-05-20','2021-05-20 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-20 18:35:59','503','2021-05-20 18:37:18',10,0),('1','147',198567,'DAILY7','2021-05-21','2021-05-21 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-21 13:19:38','503','2021-05-21 13:29:47',10,0),('1','147',198688,'Daily','2021-05-21','2021-05-21 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-21 18:17:55','503','2021-05-21 18:19:17',10,0),('1','147',198781,'DAILY','2021-05-22','2021-05-22 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-22 18:47:50','503','2021-05-22 18:50:34',10,0),('1','147',198986,'DAILY','2021-05-23','2021-05-23 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-23 18:36:50','503','2021-05-23 18:40:17',10,0),('1','147',199222,'DAILY','2021-05-24','2021-05-24 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-24 16:09:59','503','2021-05-24 16:10:52',10,0),('1','147',199399,'DAILY','2021-05-24','2021-05-24 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-24 18:56:00','503','2021-05-24 18:56:22',10,0),('1','147',199464,'DAILY','2021-05-25','2021-05-25 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-25 19:19:22','503','2021-05-25 19:20:48',10,0),('1','147',199671,'DAILY','2021-05-26','2021-05-26 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-26 19:30:03','503','2021-05-26 19:31:01',10,0),('1','147',199967,'DAILY','2021-05-27','2021-05-27 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-27 18:37:10','503','2021-05-27 18:39:04',10,0),('1','147',200107,'DAILY','2021-05-28','2021-05-28 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-28 13:26:55','503','2021-05-28 13:27:38',10,0),('1','147',200224,'DAILY','2021-05-28','2021-05-28 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-28 19:59:53','503','2021-05-28 20:00:33',10,0),('1','147',200294,'DAILY','2021-05-29','2021-05-29 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-29 19:53:00','503','2021-05-29 19:53:33',10,0),('1','147',200497,'DAILY','2021-05-30','2021-05-30 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-30 20:17:30','503','2021-05-30 20:17:59',10,0),('1','147',200712,'DAILY','2021-05-31','2021-05-31 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-31 08:08:47','503','2021-05-31 08:10:25',10,0),('1','147',200770,'DAILY','2021-05-31','2021-05-31 00:00:00',NULL,'503',0.00,0.00,'503','2021-05-31 19:08:04','503','2021-05-31 19:08:29',10,0),('1','147',200933,'DAILY','2021-06-01','2021-06-01 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-01 20:37:48','503','2021-06-01 20:38:33',10,0),('1','147',201134,'DAILY','2021-06-02','2021-06-02 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-02 20:45:53','503','2021-06-02 20:47:08',10,0),('1','147',201345,'DAILY','2021-06-03','2021-06-03 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-03 07:55:53','503','2021-06-03 07:56:18',10,0),('1','147',201350,'DAILY','2021-06-03','2021-06-03 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-03 19:15:21','503','2021-06-03 19:16:26',10,0),('1','147',201518,'DAILY','2021-06-04','2021-06-04 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-04 19:07:00','503','2021-06-04 19:08:32',10,0),('1','147',201770,'DAILY','2021-06-05','2021-06-05 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-05 18:44:18','503','2021-06-05 18:45:04',10,0),('1','147',202046,'DAILY','2021-06-06','2021-06-06 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-06 19:18:21','503','2021-06-06 19:19:03',10,0),('1','147',202263,'DAILY','2021-06-07','2021-06-07 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-07 19:20:39','503','2021-06-07 19:21:37',10,0),('1','147',202455,'DAILY','2021-06-08','2021-06-08 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-08 12:08:23','503','2021-06-08 12:08:58',10,0),('1','147',202702,'DAILY','2021-06-08','2021-06-08 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-09 08:57:38','503','2021-06-09 08:58:08',10,0),('1','147',202707,'DAILY','2021-06-09','2021-06-09 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-09 19:23:34','503','2021-06-09 19:25:15',10,0),('1','147',202849,'DAILY','2021-06-10','2021-06-10 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-10 19:16:23','503','2021-06-10 19:17:15',10,0),('1','147',203100,'DAILY','2021-06-11','2021-06-11 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-11 15:39:52','503','2021-06-11 15:40:41',10,0),('1','147',203382,'DAILY','2021-06-12','2021-06-12 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-12 19:14:58','503','2021-06-12 19:15:34',10,0),('1','147',203518,'DAILY','2021-06-13','2021-06-13 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-13 19:13:29','503','2021-06-13 19:14:28',10,0),('1','147',203730,'DAILY','2021-06-14','2021-06-14 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-14 07:02:30','503','2021-06-14 07:05:01',10,0),('1','147',203747,'DAILY','2021-06-14','2021-06-14 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-14 13:16:55','503','2021-06-14 13:17:35',10,0),('1','147',203930,'DAILY','2021-06-14','2021-06-14 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-14 19:22:28','503','2021-06-14 19:23:06',10,0),('1','147',203957,'DAILY','2021-06-15','2021-06-15 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-15 18:34:54','503','2021-06-15 18:35:39',10,0),('1','147',204189,'DAILY','2021-06-16','2021-06-16 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-16 19:28:31','503','2021-06-16 19:30:49',10,0),('1','147',204390,'DAILY','2021-06-17','2021-06-17 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-17 18:44:35','503','2021-06-17 18:46:16',10,0),('1','147',204676,'DAILY','2021-06-18','2021-06-18 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-18 19:12:48','503','2021-06-18 19:13:41',10,0),('1','147',204862,'DAILY','2021-06-19','2021-06-19 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-19 19:12:06','503','2021-06-19 19:13:27',10,0),('1','147',205039,'DAILY','2021-06-20','2021-06-20 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-20 17:44:45','503','2021-06-20 17:45:53',10,0),('1','147',205262,'DAILY','2021-06-21','2021-06-21 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-21 19:06:57','503','2021-06-21 19:17:52',10,0),('1','147',205480,'DAILY','2021-06-22','2021-06-22 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-22 19:12:04','503','2021-06-22 19:13:39',10,0),('1','147',205725,'DAILY','2021-06-23','2021-06-23 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-23 19:11:10','503','2021-06-23 19:13:12',10,0),('1','147',205943,'DAILY','2021-06-24','2021-06-24 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-24 10:22:37','503','2021-06-24 10:23:54',10,0),('1','147',206038,'DAILY','2021-06-24','2021-06-24 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-24 18:55:25','503','2021-06-24 18:57:03',10,0),('1','147',206194,'DAILY','2021-06-25','2021-06-25 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-25 19:02:30','503','2021-06-25 19:03:49',10,0),('1','147',206437,'DAILY','2021-06-26','2021-06-26 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-26 17:47:52','503','2021-06-26 17:50:34',10,0),('1','147',206618,'DAILY','2021-06-27','2021-06-27 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-27 19:07:59','503','2021-06-27 19:09:37',10,0),('1','147',206838,'DAILY','2021-06-28','2021-06-28 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-28 18:59:06','503','2021-06-28 19:00:23',10,0),('1','147',207072,'DAILY','2021-06-29','2021-06-29 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-29 15:02:06','503','2021-06-29 15:03:51',10,0),('1','147',207207,'DAILY','2021-06-29','2021-06-29 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-29 18:59:08','503','2021-06-29 18:59:51',10,0),('1','147',207258,'DAILY','2021-06-30','2021-06-30 00:00:00',NULL,'503',0.00,0.00,'503','2021-06-30 19:04:39','503','2021-06-30 19:05:44',10,0),('1','147',207509,'DAILY','2021-07-01','2021-07-01 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-01 19:17:45','503','2021-07-01 19:18:29',10,0),('1','147',207757,'DAILY','2021-07-02','2021-07-02 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-02 09:50:02','503','2021-07-02 09:50:33',10,0),('1','147',207775,'DAILY','2021-07-02','2021-07-02 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-02 19:26:00','503','2021-07-02 19:27:09',10,0),('1','147',207882,'DAILY','2021-07-02','2021-07-02 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-02 19:38:25','503','2021-07-02 19:38:47',10,0),('1','147',207987,'DAILY','2021-07-03','2021-07-03 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-03 19:08:30','503','2021-07-03 19:09:21',10,0),('1','147',208160,'DAILY','2021-07-04','2021-07-04 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-04 17:24:53','503','2021-07-04 17:25:47',10,0),('1','147',208284,'DAILY','2021-07-04','2021-07-04 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-04 17:34:49','503','2021-07-04 17:35:12',10,0),('1','147',208378,'DAILY','2021-07-05','2021-07-05 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-05 19:04:39','503','2021-07-05 19:05:21',10,0),('1','147',208585,'DAILY','2021-07-06','2021-07-06 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-06 18:58:57','503','2021-07-06 18:59:41',10,0),('1','147',208734,'DAILY','2021-07-06','2021-07-06 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-06 19:05:39','503','2021-07-06 19:06:17',10,0),('1','147',208826,'DAILY','2021-07-07','2021-07-07 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-07 19:12:12','503','2021-07-07 19:12:58',10,0),('1','147',209036,'DAILY','2021-07-08','2021-07-08 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-08 08:20:30','503','2021-07-08 08:21:27',10,0),('1','147',209040,'DAILY','2021-07-08','2021-07-08 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-08 19:09:54','503','2021-07-08 19:10:33',10,0),('1','147',209269,'DAILY','2021-07-09','2021-07-09 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-09 18:52:45','503','2021-07-09 18:53:56',10,0),('1','147',209405,'DAILY','2021-07-09','2021-07-09 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-09 19:09:05','503','2021-07-09 19:09:31',10,0),('1','147',209441,'DAILY','2021-07-10','2021-07-10 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-10 19:04:19','503','2021-07-10 19:05:09',10,0),('1','147',209640,'DAILY','2021-07-11','2021-07-11 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-11 19:21:49','503','2021-07-11 19:23:20',10,0),('1','147',209855,'DAILY','2021-07-12','2021-07-12 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-12 09:22:23','503','2021-07-12 09:22:49',10,0),('1','147',209932,'DAILY','2021-07-12','2021-07-12 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-12 19:07:15','503','2021-07-12 19:09:31',10,0),('1','147',210126,'DAILY','2021-07-13','2021-07-13 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-13 19:06:07','503','2021-07-13 19:08:10',10,0),('1','147',210359,'DAILY','2021-07-14','2021-07-14 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-14 19:27:31','503','2021-07-14 19:28:45',10,0),('1','147',210623,'DAILY','2021-07-15','2021-07-15 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-15 12:29:55','503','2021-07-15 12:30:23',10,0),('1','147',210628,'DAILY','2021-07-15','2021-07-15 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-15 19:22:04','503','2021-07-15 19:27:35',10,0),('1','147',210774,'DAILY','2021-07-16','2021-07-16 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-16 18:53:14','503','2021-07-16 18:54:53',10,0),('1','147',211001,'DAILY','2021-07-17','2021-07-17 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-17 19:41:58','503','2021-07-17 19:47:59',10,0),('1','147',211252,'DAILY7','2021-07-18','2021-07-18 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-18 14:09:19','503','2021-07-18 14:09:58',10,0),('1','147',211305,'DAILY','2021-07-18','2021-07-18 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-18 18:55:24','503','2021-07-18 18:58:57',10,0),('1','147',211384,'DAILY','2021-07-19','2021-07-19 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-19 21:09:07','503','2021-07-19 21:19:24',10,0),('1','147',211650,'Daily ','2021-07-20','2021-07-20 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-20 11:29:17','503','2021-07-20 11:29:43',10,0),('1','147',211679,'DAILY','2021-07-20','2021-07-20 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-20 19:25:41','503','2021-07-20 19:28:59',10,0),('1','147',211783,'DAILY','2021-07-21','2021-07-21 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-21 20:00:12','503','2021-07-21 20:41:58',10,0),('1','147',211983,'DAILY','2021-07-22','2021-07-22 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-22 20:04:28','503','2021-07-22 20:08:11',10,0),('1','147',212221,'DAILY','2021-07-23','2021-07-23 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-23 13:50:45','503','2021-07-23 13:54:36',10,0),('1','147',212730,'Daily','2021-07-25','2021-07-25 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-25 20:28:48','503','2021-07-25 20:29:29',10,0),('1','147',212859,'DAILY','2021-07-26','2021-07-26 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-26 17:31:42','503','2021-07-26 17:32:54',10,0),('1','147',213250,'DAILY','2021-07-27','2021-07-27 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-27 19:54:06','503','2021-07-27 19:56:16',10,0),('1','147',213385,'DAILY','2021-07-28','2021-07-28 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-28 19:06:29','503','2021-07-28 19:08:03',10,0),('1','147',213851,'Daily','2021-07-29','2021-07-29 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-29 19:56:28','503','2021-07-29 19:57:03',10,0),('1','147',213993,'DAILY','2021-07-30','2021-07-30 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-30 19:43:40','503','2021-07-30 19:44:51',10,0),('1','147',214094,'DAILY','2021-07-31','2021-07-31 00:00:00',NULL,'503',0.00,0.00,'503','2021-07-31 19:44:32','503','2021-07-31 19:52:57',10,0),('1','147',214493,'Daily','2021-08-01','2021-08-01 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-01 18:42:41','503','2021-08-01 18:43:11',10,0),('1','147',214582,'DAILY','2021-08-02','2021-08-02 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-02 18:50:22','503','2021-08-02 18:51:04',10,0),('1','147',214776,'DAILY','2021-08-03','2021-08-03 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-03 18:40:36','503','2021-08-03 18:41:50',10,0),('1','147',214994,'DAILY','2021-08-04','2021-08-04 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-04 13:10:07','503','2021-08-04 13:10:45',10,0),('1','147',215188,'DAILY','2021-08-04','2021-08-04 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-04 18:57:13','503','2021-08-04 18:58:10',10,0),('1','147',215214,'Daily ','2021-08-05','2021-08-05 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-05 18:52:20','503','2021-08-05 18:53:50',10,0),('1','147',215442,'DAILY','2021-08-06','2021-08-06 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-06 17:29:31','503','2021-08-06 17:31:22',10,0),('1','147',215747,'DAILY','2021-08-07','2021-08-07 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-07 18:53:19','503','2021-08-07 18:54:04',10,0),('1','147',215950,'DAILY','2021-08-08','2021-08-08 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-08 18:48:26','503','2021-08-08 18:49:16',10,0),('1','147',216214,'Daily','2021-08-09','2021-08-09 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-09 18:53:56','503','2021-08-09 18:54:53',10,0),('1','147',216364,'DAILY','2021-08-10','2021-08-10 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-10 18:52:18','503','2021-08-10 18:59:16',10,0),('1','147',216546,'DAILY','2021-08-11','2021-08-11 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-11 19:42:24','503','2021-08-11 19:49:21',10,0),('1','147',216936,'DAILY','2021-08-12','2021-08-12 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-12 18:43:31','503','2021-08-12 18:51:43',10,0),('1','147',217095,'DAILY','2021-08-13','2021-08-13 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-13 18:57:04','503','2021-08-13 19:01:09',10,0),('1','147',217281,'DAILY','2021-08-14','2021-08-14 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-14 18:55:07','503','2021-08-14 19:03:37',10,0),('1','147',217541,'DAILY','2021-08-15','2021-08-15 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-15 18:52:07','503','2021-08-15 18:58:30',10,0),('1','147',217706,'DAILY','2021-08-16','2021-08-16 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-16 18:37:36','503','2021-08-16 18:42:43',10,0),('1','147',217987,'DAILY','2021-08-17','2021-08-17 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-17 18:56:50','503','2021-08-17 19:00:40',10,0),('1','147',218212,'DAILY','2021-08-18','2021-08-18 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-18 19:00:39','503','2021-08-18 19:04:55',10,0),('1','147',218436,'DAILY','2021-08-19','2021-08-19 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-19 18:37:25','503','2021-08-19 18:40:44',10,0),('1','147',218726,'DAILY','2021-08-20','2021-08-20 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-20 19:29:44','503','2021-08-20 19:35:33',10,0),('1','147',218903,'DAILY','2021-08-21','2021-08-21 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-21 18:54:14','503','2021-08-21 18:58:32',10,0),('1','147',219116,'DAILY','2021-08-22','2021-08-22 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-22 19:01:56','503','2021-08-22 19:08:40',10,0),('1','147',219355,'DAILY','2021-08-23','2021-08-23 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-23 15:51:50','503','2021-08-23 15:54:02',10,0),('1','147',219535,'DAILY','2021-08-23','2021-08-23 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-23 18:42:59','503','2021-08-23 18:43:38',10,0),('1','147',219614,'DAILY','2021-08-24','2021-08-24 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-24 18:46:05','503','2021-08-24 18:52:57',10,0),('1','147',219814,'DAILY','2021-08-25','2021-08-25 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-25 18:49:17','503','2021-08-25 18:55:27',10,0),('1','147',220038,'DAILY','2021-08-26','2021-08-26 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-26 15:33:50','503','2021-08-26 15:39:55',10,0),('1','147',220184,'DAILY','2021-08-26','2021-08-26 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-26 19:04:18','503','2021-08-26 19:06:18',10,0),('1','147',220278,'DAILY','2021-08-27','2021-08-27 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-27 19:04:12','503','2021-08-27 19:14:47',10,0),('1','147',220462,'daily','2021-08-28','2021-08-28 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-29 05:55:21','503','2021-08-29 05:59:16',10,0),('1','147',220681,'Daily','2021-08-29','2021-08-29 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-29 18:53:58','503','2021-08-29 18:59:08',10,0),('1','147',220903,'daily','2021-08-30','2021-08-30 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-30 19:01:58','503','2021-08-30 19:09:13',10,0),('1','147',221135,'daily','2021-08-31','2021-08-31 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-31 09:40:58','503','2021-08-31 09:43:49',10,0),('1','147',221234,'daily','2021-08-31','2021-08-31 00:00:00',NULL,'503',0.00,0.00,'503','2021-08-31 18:46:41','503','2021-08-31 18:51:15',10,0),('1','147',221423,'daily','2021-09-01','2021-09-01 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-01 19:12:22','503','2021-09-01 19:15:38',10,0),('1','147',221609,'daily','2021-09-02','2021-09-02 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-02 13:16:38','503','2021-09-02 13:21:52',10,0),('1','147',221734,'daily','2021-09-02','2021-09-02 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-02 18:55:01','503','2021-09-02 19:01:42',10,0),('1','147',221822,'daily','2021-09-03','2021-09-03 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-03 19:04:10','503','2021-09-03 19:09:38',10,0),('1','147',222054,'daily','2021-09-04','2021-09-04 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-04 18:31:24','503','2021-09-04 18:38:55',10,0),('1','147',222270,'daily','2021-09-05','2021-09-05 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-05 18:57:12','503','2021-09-05 19:04:47',10,0),('1','147',222495,'daily','2021-09-06','2021-09-06 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-06 22:28:07','503','2021-09-06 22:29:45',10,0),('1','147',222713,'Daily ','2021-09-06','2021-09-06 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-08 17:26:16','503','2021-09-08 17:26:55',10,0),('1','147',223134,'DAILY','2021-09-07','2021-09-07 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-08 17:32:51','503','2021-09-08 17:33:21',10,0),('1','147',223135,'DAILY','2021-09-08','2021-09-08 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-08 18:39:10','503','2021-09-08 18:39:52',10,0),('1','147',223172,'daily','2021-09-09','2021-09-09 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-09 11:46:52','503','2021-09-09 11:52:44',10,0),('1','147',223460,'Daily','2021-09-10','2021-09-10 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-10 11:52:45','503','2021-09-10 11:56:43',10,0),('1','147',223514,'daily','2021-09-10','2021-09-10 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-11 06:20:55','503','2021-09-11 06:22:48',10,0),('1','147',223639,'Dailey','2021-09-11','2021-09-11 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-11 18:37:40','503','2021-09-11 18:42:34',10,0),('1','147',223882,'daily','2021-09-12','2021-09-12 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-12 20:13:52','503','2021-09-12 20:15:57',10,0),('1','147',224055,'daily','2021-09-11','2021-09-11 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-12 20:24:13','503','2021-09-12 20:25:23',10,0),('1','147',224079,'daily','2021-09-13','2021-09-13 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-13 20:59:18','503','2021-09-13 21:05:16',10,0),('1','147',224301,'daily','2021-09-14','2021-09-14 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-14 18:28:48','503','2021-09-14 18:34:35',10,0),('1','147',224524,'daily','2021-09-15','2021-09-15 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-15 19:29:26','503','2021-09-15 19:46:35',10,0),('1','147',224768,'daily','2021-09-16','2021-09-16 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-16 19:14:03','503','2021-09-16 19:18:04',10,0),('1','147',225015,'daily','2021-09-17','2021-09-17 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-17 13:56:31','503','2021-09-17 14:04:32',10,0),('1','147',225165,'daily','2021-09-17','2021-09-17 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-17 19:13:36','503','2021-09-17 19:22:12',10,0),('1','147',225260,'daily','2021-09-18','2021-09-18 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-18 19:07:56','503','2021-09-19 05:52:46',10,0),('1','147',225477,'Daily ','2021-09-19','2021-09-19 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-19 18:07:22','503','2021-09-19 18:11:04',10,0),('1','147',225687,'daily','2021-09-20','2021-09-20 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-20 10:23:10','503','2021-09-20 10:24:22',10,0),('1','147',225804,'daily','2021-09-20','2021-09-20 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-21 05:10:19','503','2021-09-21 05:11:53',10,0),('1','147',225963,'Daily ','2021-09-21','2021-09-21 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-21 19:03:17','503','2021-09-21 19:12:57',10,0),('1','147',226247,'daily','2021-09-22','2021-09-22 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-23 05:41:49','503','2021-09-23 06:07:28',10,0),('1','147',226472,'daily','2021-09-23','2021-09-23 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-23 08:28:12','503','2021-09-23 08:37:12',10,0),('1','147',226529,'daily','2021-09-23','2021-09-23 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-23 19:22:58','503','2021-09-23 19:30:05',10,0),('1','147',226723,'daily','2021-09-24','2021-09-24 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-24 19:53:48','503','2021-09-24 20:02:08',10,0),('1','147',226957,'daily','2021-09-25','2021-09-25 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-25 14:26:59','503','2021-09-25 14:33:26',10,0),('1','147',227111,'daily','2021-09-25','2021-09-25 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-25 19:41:41','503','2021-09-25 19:47:39',10,0),('1','147',227183,'daily','2021-09-26','2021-09-26 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-26 20:59:21','503','2021-09-26 21:08:04',10,0),('1','147',227368,'daily','2021-09-27','2021-09-27 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-27 19:09:23','503','2021-09-27 19:15:37',10,0),('1','147',227604,'daily','2021-09-28','2021-09-28 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-28 20:02:55','503','2021-09-28 21:00:41',10,0),('1','147',227846,'daily','2021-09-29','2021-09-29 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-29 08:46:57','503','2021-09-29 08:54:39',10,0),('1','147',227913,'daily','2021-09-29','2021-09-29 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-29 19:24:42','503','2021-09-29 19:30:06',10,0),('1','147',228112,'daily','2021-09-30','2021-09-30 00:00:00',NULL,'503',0.00,0.00,'503','2021-09-30 19:40:10','503','2021-09-30 19:47:22',10,0),('1','147',228345,'daily','2021-10-01','2021-10-01 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-01 07:33:27','503','2021-10-01 07:40:01',10,0),('1','147',228375,'daily','2021-10-01','2021-10-01 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-01 19:25:29','503','2021-10-01 19:27:46',10,0),('1','147',228528,'daily','2021-10-02','2021-10-02 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-02 18:34:26','503','2021-10-02 18:41:33',10,0),('1','147',228749,'daily','2021-10-03','2021-10-03 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-03 20:04:46','503','2021-10-03 20:11:33',10,0),('1','147',228937,'daily','2021-10-04','2021-10-04 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-04 19:35:23','503','2021-10-04 19:40:54',10,0),('1','147',229166,'daily','2021-10-05','2021-10-05 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-05 19:25:52','503','2021-10-05 19:36:14',10,0),('1','147',229407,'daily','2021-10-06','2021-10-06 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-06 19:48:20','503','2021-10-06 19:50:56',10,0),('1','147',229655,'daily','2021-10-07','2021-10-07 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-07 19:54:54','503','2021-10-07 20:08:07',10,0),('1','147',229884,'daily','2021-10-08','2021-10-08 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-08 09:24:44','503','2021-10-08 09:25:41',10,0),('1','147',229941,'daily','2021-10-08','2021-10-08 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-08 20:20:55','503','2021-10-08 20:27:43',10,0),('1','147',230087,'daily','2021-10-09','2021-10-09 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-09 20:27:42','503','2021-10-09 20:36:33',10,0),('1','147',230287,'daily','2021-10-10','2021-10-10 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-10 20:54:03','503','2021-10-10 21:05:24',10,0),('1','147',230519,'daily','2021-10-11','2021-10-11 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-11 19:33:29','503','2021-10-11 19:36:10',10,0),('1','147',230791,'daily','2021-10-12','2021-10-12 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-12 20:03:25','503','2021-10-12 20:11:42',10,0),('1','147',231057,'daily','2021-10-13','2021-10-13 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-13 21:15:40','503','2021-10-13 21:18:54',10,0),('1','147',231377,'daily','2021-10-14','2021-10-14 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-14 19:44:16','503','2021-10-14 19:48:39',10,0),('1','147',231637,'daily','2021-10-15','2021-10-15 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-15 19:21:48','503','2021-10-15 19:23:52',10,0),('1','147',232110,'daily','2021-10-17','2021-10-17 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-17 20:04:23','503','2021-10-17 20:07:58',10,0),('1','147',232333,'daily','2021-10-18','2021-10-18 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-18 20:09:28','503','2021-10-18 20:12:14',10,0),('1','147',232585,'Daily ','2021-10-19','2021-10-19 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-19 19:35:11','503','2021-10-19 19:40:31',10,0),('1','147',232845,'daily','2021-10-20','2021-10-20 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-20 19:38:37','503','2021-10-20 19:45:34',10,0),('1','147',233117,'daily','2021-10-21','2021-10-21 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-21 19:50:05','503','2021-10-21 19:55:24',10,0),('1','147',233369,'daily','2021-10-22','2021-10-22 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-22 19:57:11','503','2021-10-22 20:02:24',10,0),('1','147',233604,'daily','2021-10-23','2021-10-23 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-23 20:14:23','503','2021-10-23 20:25:49',10,0),('1','147',233842,'daily','2021-10-24','2021-10-24 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-24 20:05:47','503','2021-10-24 20:16:28',10,0),('1','147',234059,'daily','2021-10-25','2021-10-25 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-25 19:42:25','503','2021-10-25 19:47:37',10,0),('1','147',234318,'daily','2021-10-26','2021-10-26 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-26 20:08:45','503','2021-10-26 20:14:28',10,0),('1','147',234554,'daily','2021-10-27','2021-10-27 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-27 19:35:53','503','2021-10-27 19:40:44',10,0),('1','147',234817,'daily','2021-10-28','2021-10-28 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-28 19:43:50','503','2021-10-28 19:54:42',10,0),('1','147',235057,'daily','2021-10-29','2021-10-29 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-29 19:53:35','503','2021-10-29 19:55:53',10,0),('1','147',235309,'daily','2021-10-30','2021-10-30 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-30 19:36:01','503','2021-10-30 19:43:34',10,0),('1','147',235516,'daily','2021-10-31','2021-10-31 00:00:00',NULL,'503',0.00,0.00,'503','2021-10-31 19:28:36','503','2021-10-31 19:39:47',10,0),('1','147',235745,'daily','2021-11-01','2021-11-01 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-01 19:56:23','503','2021-11-01 20:05:06',10,0),('1','147',236009,'daily','2021-11-02','2021-11-02 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-02 18:10:43','503','2021-11-02 18:16:51',10,0),('1','147',236269,'daily','2021-11-03','2021-11-03 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-03 20:16:11','503','2021-11-03 20:19:23',10,0),('1','147',236501,'daily','2021-11-04','2021-11-04 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-04 19:28:39','503','2021-11-04 19:37:25',10,0),('1','147',236718,'daily','2021-11-05','2021-11-05 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-05 16:38:56','503','2021-11-05 16:43:41',10,0),('1','147',236894,'daily','2021-11-05','2021-11-05 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-05 19:42:54','503','2021-11-05 19:43:23',10,0),('1','147',236951,'daily','2021-11-06','2021-11-06 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-06 19:57:49','503','2021-11-06 20:04:02',10,0),('1','147',237175,'daily','2021-11-07','2021-11-07 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-07 18:13:26','503','2021-11-07 18:19:07',10,0),('1','147',237375,'daily','2021-11-08','2021-11-08 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-08 19:15:35','503','2021-11-08 19:18:25',10,0),('1','147',237597,'Daily ','2021-11-09','2021-11-09 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-09 19:47:03','503','2021-11-09 19:53:56',10,0),('1','147',237879,'daily','2021-11-10','2021-11-10 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-10 15:17:32','503','2021-11-10 15:22:58',10,0),('1','147',238045,'daily','2021-11-10','2021-11-10 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-10 20:00:31','503','2021-11-10 20:01:00',10,0),('1','147',238163,'daily','2021-11-11','2021-11-11 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-11 19:49:53','503','2021-11-11 19:57:26',10,0),('1','147',238355,'daily','2021-11-12','2021-11-12 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-12 18:36:57','503','2021-11-12 18:42:55',10,0),('1','147',238590,'daily','2021-11-13','2021-11-13 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-13 12:05:27','503','2021-11-13 12:09:18',10,0),('1','147',238713,'daily','2021-11-13','2021-11-13 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-13 18:55:37','503','2021-11-13 19:00:42',10,0),('1','147',238822,'daily','2021-11-14','2021-11-14 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-14 18:20:22','503','2021-11-14 18:21:05',10,0),('1','147',239058,'daily','2021-11-15','2021-11-15 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-15 18:17:20','503','2021-11-15 18:24:24',10,0),('1','147',239278,'daily','2021-11-16','2021-11-16 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-16 10:21:42','503','2021-11-16 10:28:44',10,0),('1','147',239542,'daily','2021-11-17','2021-11-17 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-17 19:54:43','503','2021-11-17 20:02:00',10,0),('1','147',239771,'daily','2021-11-18','2021-11-18 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-18 18:40:23','503','2021-11-18 18:46:45',10,0),('1','147',239986,'daily','2021-11-19','2021-11-19 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-19 18:26:30','503','2021-11-19 18:35:11',10,0),('1','147',240187,'daily','2021-11-20','2021-11-20 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-20 08:43:35','503','2021-11-20 08:44:26',10,0),('1','147',240256,'daily','2021-11-20','2021-11-20 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-20 19:35:55','503','2021-11-20 19:36:42',10,0),('1','147',240443,'daily','2021-11-21','2021-11-21 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-21 17:55:54','503','2021-11-21 18:03:49',10,0),('1','147',240686,'daily','2021-11-22','2021-11-22 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-22 18:13:44','503','2021-11-22 18:21:14',10,0),('1','147',240972,'Daily ','2021-11-23','2021-11-23 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-23 19:25:24','503','2021-11-23 19:26:38',10,0),('1','147',241216,'daily','2021-11-24','2021-11-24 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-24 19:25:36','503','2021-11-24 19:27:40',10,0),('1','147',241481,'daily','2021-11-25','2021-11-25 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-25 09:57:17','503','2021-11-25 09:58:00',10,0),('1','147',241600,'daily','2021-11-25','2021-11-25 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-25 19:27:43','503','2021-11-25 19:28:31',10,0),('1','147',241719,'daily','2021-11-26','2021-11-26 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-26 19:40:59','503','2021-11-26 19:42:02',10,0),('1','147',241965,'daily','2021-11-27','2021-11-27 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-27 18:18:05','503','2021-11-27 18:22:36',10,0),('1','147',242192,'daily','2021-11-28','2021-11-28 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-28 19:22:40','503','2021-11-28 19:23:53',10,0),('1','147',242418,'daily','2021-11-29','2021-11-29 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-29 18:36:48','503','2021-11-29 18:44:56',10,0),('1','147',242667,'daily','2021-11-30','2021-11-30 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-30 09:09:45','503','2021-11-30 09:10:21',10,0),('1','147',242763,'daily','2021-11-30','2021-11-30 00:00:00',NULL,'503',0.00,0.00,'503','2021-11-30 19:28:20','503','2021-11-30 19:33:24',10,0),('1','147',242906,'daily','2021-12-01','2021-12-01 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-01 18:32:01','503','2021-12-01 18:38:05',10,0),('1','147',243127,'daily','2021-12-02','2021-12-02 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-02 17:13:26','503','2021-12-02 17:18:53',10,0),('1','147',243382,'daily','2021-12-03','2021-12-03 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-03 19:22:20','503','2021-12-03 19:35:46',10,0),('1','147',243593,'daily','2021-12-04','2021-12-04 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-04 18:09:35','503','2021-12-04 18:28:16',10,0),('1','147',243819,'daily','2021-12-05','2021-12-05 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-05 11:40:09','503','2021-12-05 11:43:03',10,0),('1','147',243924,'daily','2021-12-05','2021-12-05 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-05 19:16:27','503','2021-12-05 19:17:46',10,0),('1','147',244036,'daily','2021-12-06','2021-12-06 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-06 18:43:01','503','2021-12-07 06:58:09',10,0),('1','147',244314,'daily','2021-12-07','2021-12-07 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-07 19:19:29','503','2021-12-07 19:27:00',10,0),('1','147',244512,'daily','2021-12-08','2021-12-08 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-08 08:29:22','503','2021-12-08 08:30:00',10,0),('1','147',244583,'daily','2021-12-08','2021-12-08 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-08 18:21:42','503','2021-12-08 18:23:12',10,0),('1','147',244728,'daily','2021-12-09','2021-12-09 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-09 19:29:51','503','2021-12-09 19:31:42',10,0),('1','147',244966,'daily','2021-12-10','2021-12-10 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-10 18:06:37','503','2021-12-10 18:16:41',10,0),('1','147',245213,'Daily ','2021-12-11','2021-12-11 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-11 19:28:03','503','2021-12-11 19:29:47',10,0),('1','147',245426,'daily','2021-12-12','2021-12-12 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-12 16:14:00','503','2021-12-12 16:23:16',10,0),('1','147',245598,'daily','2021-12-12','2021-12-12 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-12 18:50:31','503','2021-12-12 18:51:57',10,0),('1','147',245665,'daily','2021-12-13','2021-12-13 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-13 19:12:30','503','2021-12-13 19:13:28',10,0),('1','147',245926,'Daily ','2021-12-14','2021-12-14 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-14 19:22:12','503','2021-12-14 19:23:44',10,0),('1','147',246181,'daily','2021-12-15','2021-12-15 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-15 13:30:11','503','2021-12-15 13:30:44',10,0),('1','147',246346,'daily','2021-12-15','2021-12-15 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-15 18:59:40','503','2021-12-15 19:00:22',10,0),('1','147',246443,'daily','2021-12-16','2021-12-16 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-16 18:36:53','503','2021-12-16 18:37:38',10,0),('1','147',246688,'daily','2021-12-17','2021-12-17 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-17 15:09:30','503','2021-12-17 15:10:29',10,0),('1','147',246860,'daily','2021-12-17','2021-12-17 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-17 18:56:51','503','2021-12-17 18:57:24',10,0),('1','147',246921,'daily','2021-12-18','2021-12-18 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-18 19:09:17','503','2021-12-18 19:10:19',10,0),('1','147',247159,'daily','2021-12-19','2021-12-19 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-19 13:47:39','503','2021-12-19 13:48:05',10,0),('1','147',247301,'daily','2021-12-19','2021-12-19 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-19 18:58:33','503','2021-12-19 18:59:42',10,0),('1','147',247385,'daily','2021-12-20','2021-12-20 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-20 19:32:18','503','2021-12-20 19:42:50',10,0),('1','147',247657,'daily','2021-12-21','2021-12-21 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-21 11:30:52','503','2021-12-21 11:31:37',10,0),('1','147',247759,'daily','2021-12-21','2021-12-21 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-21 18:09:56','503','2021-12-21 18:10:29',10,0),('1','147',247931,'daily','2021-12-22','2021-12-22 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-22 19:12:53','503','2021-12-22 19:20:26',10,0),('1','147',248144,'daily','2021-12-23','2021-12-23 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-23 19:17:55','503','2021-12-23 19:26:59',10,0),('1','147',248388,'daily','2021-12-24','2021-12-24 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-24 06:44:35','503','2021-12-24 06:45:06',10,0),('1','147',248422,'Daily ','2021-12-24','2021-12-24 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-24 19:37:42','503','2021-12-25 05:16:56',10,0),('1','147',248629,'daily','2021-12-25','2021-12-25 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-25 11:23:16','503','2021-12-25 11:28:39',10,0),('1','147',248733,'daily','2021-12-25','2021-12-25 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-25 18:23:42','503','2021-12-25 18:24:23',10,0),('1','147',248894,'daily','2021-12-26','2021-12-26 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-26 18:06:45','503','2021-12-26 18:07:46',10,0),('1','147',249096,'daily','2021-12-27','2021-12-27 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-27 18:01:06','503','2021-12-27 18:02:20',10,0),('1','147',249387,'Daily','2021-12-28','2021-12-28 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-28 17:49:44','503','2021-12-28 17:50:29',10,0),('1','147',249724,'daily','2021-12-29','2021-12-29 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-29 18:00:56','503','2021-12-29 18:01:49',10,0),('1','147',249840,'daily','2021-12-30','2021-12-30 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-30 19:14:39','503','2021-12-30 19:22:03',10,0),('1','147',250106,'daily','2021-12-31','2021-12-31 00:00:00',NULL,'503',0.00,0.00,'503','2021-12-31 17:54:34','503','2021-12-31 17:55:35',10,0),('1','147',250490,'daily','2022-01-01','2022-01-01 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-01 18:13:54','503','2022-01-01 18:14:34',10,0),('1','147',250558,'daily','2022-01-02','2022-01-02 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-02 18:06:24','503','2022-01-02 18:07:02',10,0),('1','147',250790,'daily','2022-01-03','2022-01-03 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-03 19:22:26','503','2022-01-03 19:23:05',10,0),('1','147',251017,'daily','2022-01-04','2022-01-04 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-04 18:00:30','503','2022-01-04 18:03:30',10,0),('1','147',251336,'daily','2022-01-05','2022-01-05 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-05 20:05:07','503','2022-01-05 20:12:02',10,0),('1','147',251509,'daily','2022-01-06','2022-01-06 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-06 20:25:58','503','2022-01-06 20:33:31',10,0),('1','147',251758,'daily','2022-01-07','2022-01-07 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-07 20:29:50','503','2022-01-07 20:39:16',10,0),('1','147',251987,'daily','2022-01-08','2022-01-08 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-08 08:47:50','503','2022-01-08 09:09:18',10,0),('1','147',252044,'daily','2022-01-08','2022-01-08 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-08 21:05:27','503','2022-01-08 21:17:06',10,0),('1','147',252234,'daily','2022-01-09','2022-01-09 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-09 20:39:30','503','2022-01-09 20:45:37',10,0),('1','147',252465,'daily','2022-01-10','2022-01-10 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-10 11:28:21','503','2022-01-10 11:29:17',10,0),('1','147',252577,'daily','2022-01-10','2022-01-10 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-10 20:51:33','503','2022-01-10 21:04:17',10,0),('1','147',252709,'daily','2022-01-11','2022-01-11 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-11 16:16:40','503','2022-01-11 16:22:51',10,0),('1','147',253040,'daily','2022-01-12','2022-01-12 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-12 20:53:06','503','2022-01-12 20:56:44',10,0),('1','147',253201,'daily','2022-01-13','2022-01-13 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-13 20:24:04','503','2022-01-13 20:29:38',10,0),('1','147',253470,'daily','2022-01-14','2022-01-14 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-14 11:36:05','503','2022-01-14 11:37:25',10,0),('1','147',253578,'daily','2022-01-14','2022-01-14 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-14 20:10:48','503','2022-01-14 20:20:11',10,0),('1','147',253710,'daily','2022-01-15','2022-01-15 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-15 19:59:56','503','2022-01-15 20:13:09',10,0),('1','147',253954,'daily','2022-01-16','2022-01-16 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-16 11:41:49','503','2022-01-16 11:48:39',10,0),('1','147',254103,'daily','2022-01-16','2022-01-16 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-16 19:33:51','503','2022-01-16 19:35:24',10,0),('1','147',254188,'daily','2022-01-17','2022-01-17 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-17 18:04:33','503','2022-01-17 18:13:33',10,0),('1','147',254513,'daily','2022-01-18','2022-01-18 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-18 20:02:42','503','2022-01-18 20:09:12',10,0),('1','147',254694,'daily','2022-01-19','2022-01-19 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-19 20:11:10','503','2022-01-19 20:33:48',10,0),('1','147',254945,'daily','2022-01-20','2022-01-20 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-20 13:01:47','503','2022-01-20 13:03:40',10,0),('1','147',255066,'daily','2022-01-20','2022-01-20 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-21 06:54:10','503','2022-01-21 07:08:34',10,0),('1','147',255193,'daily','2022-01-21','2022-01-21 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-21 23:15:09','503','2022-01-21 23:19:00',10,0),('1','147',255498,'daily','2022-01-22','2022-01-22 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-22 16:17:56','503','2022-01-22 16:21:39',10,0),('1','147',255718,'daily','2022-01-23','2022-01-23 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-24 06:48:58','503','2022-01-24 06:52:41',10,0),('1','147',255940,'Daily shift ','2022-01-24','2022-01-24 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-24 18:01:07','503','2022-01-25 09:09:00',10,0),('1','147',256260,'daily','2022-01-25','2022-01-25 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-26 06:29:43','503','2022-01-26 06:31:24',10,0),('1','147',256475,'Daily shift ','2022-01-26','2022-01-26 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-27 06:54:39','503','2022-01-27 07:01:52',10,0),('1','147',256729,'Daily shift ','2022-01-27','2022-01-27 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-27 15:10:30','503','2022-01-27 15:13:32',10,0),('1','147',256867,'Daily shift ','2022-01-27','2022-01-27 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-28 01:56:52','503','2022-01-28 01:57:29',10,0),('1','147',256947,'Daily shift ','2022-01-28','2022-01-28 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-28 19:36:24','503','2022-01-28 19:38:43',10,0),('1','147',257284,'daily','2022-01-29','2022-01-29 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-30 07:17:47','503','2022-01-30 07:24:38',10,0),('1','147',257500,'daily','2022-01-30','2022-01-30 00:00:00',NULL,'503',0.00,0.00,'503','2022-01-31 07:12:46','503','2022-01-31 07:13:03',10,0),('1','147',257501,'Daily shift ','2022-01-31','2022-01-31 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-01 07:05:06','503','2022-02-01 07:26:06',10,0),('1','147',257502,'Daily shift ','2022-02-01','2022-02-01 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-01 19:56:28','503','2022-02-01 19:59:05',10,0),('1','147',257503,'daily','2022-02-02','2022-02-02 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-02 19:19:35','503','2022-02-02 19:21:41',10,0),('1','147',257504,'daily','2022-02-03','2022-02-03 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-04 08:18:28','503','2022-02-04 08:18:49',10,0),('1','147',257505,'Daily shift ','2022-02-04','2022-02-04 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-04 19:22:27','503','2022-02-04 19:22:46',10,0),('1','147',257506,'Daily shift ','2022-02-05','2022-02-05 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-05 21:53:07','503','2022-02-05 21:55:35',10,0),('1','147',257507,'daily','2022-02-06','2022-02-06 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-07 07:25:19','503','2022-02-07 07:25:45',10,0),('1','147',257508,'Daily shift ','2022-02-07','2022-02-07 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-08 07:10:35','503','2022-02-08 07:14:29',10,0),('1','147',257509,'Daily shift ','2022-02-08','2022-02-08 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-09 07:03:44','503','2022-02-09 07:05:53',10,0),('1','147',257510,'Daily shift ','2022-02-09','2022-02-09 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-09 12:42:45','503','2022-02-09 12:43:08',10,0),('1','147',257511,'daily','2022-02-09','2022-02-09 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-10 07:20:08','503','2022-02-10 07:20:28',10,0),('1','147',257512,'Daily shift ','2022-02-10','2022-02-10 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-11 06:48:22','503','2022-02-11 06:50:17',10,0),('1','147',257513,'Daily shift ','2022-02-11','2022-02-11 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-11 15:41:55','503','2022-02-11 15:42:11',10,0),('1','147',257514,'Daily shift ','2022-02-11','2022-02-11 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-12 06:55:03','503','2022-02-12 06:56:35',10,0),('1','147',257515,'Daily shift ','2022-02-12','2022-02-12 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-13 07:11:22','503','2022-02-13 07:14:47',10,0),('1','147',257516,'Daily shift ','2022-02-13','2022-02-13 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-13 14:34:32','503','2022-02-13 14:34:49',10,0),('1','147',257517,'Daily shift ','2022-02-13','2022-02-13 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-14 06:56:51','503','2022-02-14 06:59:02',10,0),('1','147',257518,'Daily shift ','2022-02-14','2022-02-14 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-15 07:32:29','503','2022-02-15 07:48:43',10,0),('1','147',257519,'Daily shift ','2022-02-15','2022-02-15 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-16 06:54:16','503','2022-02-16 06:56:04',10,0),('1','147',257520,'Daily shift ','2022-02-16','2022-02-16 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-16 13:24:12','503','2022-02-16 13:24:38',10,0),('1','147',257521,'daily','2022-02-16','2022-02-16 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-17 09:28:23','503','2022-02-17 09:28:55',10,0),('1','147',257522,'Daily shift ','2022-02-17','2022-02-17 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-18 01:14:34','503','2022-02-18 01:14:55',10,0),('1','147',257523,'Daily shift ','2022-02-18','2022-02-18 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-19 07:44:23','503','2022-02-19 07:44:42',10,0),('1','147',257524,'Daily shift ','2022-02-19','2022-02-19 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-19 09:54:37','503','2022-02-19 09:56:10',10,0),('1','147',257525,'Daily shift ','2022-02-19','2022-02-19 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-20 06:53:12','503','2022-02-20 06:53:34',10,0),('1','147',257526,'Daily shift ','2022-02-20','2022-02-20 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-21 07:02:22','503','2022-02-21 07:04:27',10,0),('1','147',257527,'daily','2022-02-21','2022-02-21 00:00:00',NULL,'503',0.00,0.00,'503','2022-02-22 07:45:35','503','2022-02-22 07:47:49',10,0),('1','147',257528,'Daily shift ','2022-02-22','2022-02-22 07:48:37','2022-02-23 07:48:37','503',0.00,0.00,'503','2022-02-23 07:35:44','503','2022-02-23 07:36:29',10,0),('1','147',257529,'daily','2022-02-23','2022-02-23 07:36:56','2022-02-24 07:36:56','503',0.00,0.00,'503','2022-02-23 19:41:55','503','2022-02-23 19:42:23',10,0),('1','147',257530,'daily','2022-02-24','2022-02-24 07:19:54','2022-02-25 07:19:54','503',0.00,0.00,'503','2022-02-24 12:28:31','503','2022-02-24 12:28:49',10,0),('1','147',257531,'daily','2022-02-24','2022-02-24 16:18:47','2022-02-25 16:18:47','503',0.00,0.00,'503','2022-02-25 06:48:13','503','2022-02-25 07:01:53',10,0),('1','147',257532,'Daily shift ','2022-02-25','2022-02-25 07:02:29','2022-02-26 07:02:29','503',0.00,0.00,'503','2022-02-26 06:55:32','503','2022-02-26 06:57:04',10,0),('1','147',257533,'Daily','2022-02-26','2022-02-26 06:57:44','2022-02-27 06:57:44','503',0.00,0.00,'503','2022-02-27 08:57:34','503','2022-02-27 09:03:36',10,0),('1','147',257534,'daily','2022-02-26','2022-02-27 09:08:49','2022-02-28 09:08:49','503',0.00,0.00,'503','2022-02-27 09:20:45','503','2022-02-27 09:21:07',10,0),('1','147',257535,'daily','2022-02-27','2022-02-27 09:21:38','2022-02-28 09:21:38','503',0.00,0.00,'503','2022-02-27 10:44:29','503','2022-02-27 10:45:12',10,0),('1','147',257536,'daily','2022-02-27','2022-02-27 11:35:00','2022-02-28 11:35:00','503',0.00,0.00,'503','2022-02-28 06:55:52','503','2022-02-28 06:56:09',10,0),('1','147',257537,'Daily shift ','2022-02-28','2022-02-28 06:56:37','2022-03-01 06:56:37','503',0.00,0.00,'503','2022-03-01 07:15:29','503','2022-03-01 07:15:44',10,0),('1','147',257538,'Daily shift ','2022-02-28','2022-03-01 07:16:34','2022-03-02 07:16:34','503',0.00,0.00,'503','2022-03-01 07:18:08','503','2022-03-01 07:18:30',10,0),('1','147',257539,'Daily shift ','2022-03-01','2022-03-01 07:18:53','2022-03-02 07:18:53','503',0.00,0.00,'503','2022-03-01 18:07:20','503','2022-03-01 18:07:44',10,0),('1','147',257540,'daily','2022-03-02','2022-03-02 10:58:19','2022-03-03 10:58:19','503',0.00,0.00,'503','2022-03-03 06:36:39','503','2022-03-03 06:39:26',10,0),('1','147',257541,'Daily shift ','2022-03-03','2022-03-03 06:39:57','2022-03-04 06:39:57','503',0.00,0.00,'503','2022-03-05 07:10:30','503','2022-03-05 07:12:22',10,0),('1','147',257542,'Daily shift ','2022-03-03','2022-03-05 07:13:02','2022-03-06 07:13:02','503',0.00,0.00,'503','2022-03-05 07:18:23','503','2022-03-05 07:21:08',10,0),('1','147',257543,'Daily shift ','2022-03-05','2022-03-05 07:22:00','2022-03-06 07:22:00','503',0.00,0.00,'503','2022-03-05 16:37:52','503','2022-03-05 16:38:10',10,0),('1','147',257544,'daily','2022-03-05','2022-03-05 16:38:55','2022-03-06 16:38:55','503',0.00,0.00,'503','2022-03-05 20:03:51','503','2022-03-05 20:04:10',10,0),('1','147',257545,'daily','2022-03-06','2022-03-06 06:57:50','2022-03-07 06:57:50','503',0.00,0.00,'503','2022-03-06 20:02:00','503','2022-03-06 20:02:23',10,0),('1','147',257546,'daily','2022-03-07','2022-03-07 07:03:06','2022-03-08 07:03:06','503',0.00,0.00,'503','2022-03-07 19:05:45','503','2022-03-07 19:06:10',10,0),('1','147',257547,'daily','2022-03-08','2022-03-08 08:12:38','2022-03-09 08:12:38','503',0.00,0.00,'503','2022-03-08 20:09:06','503','2022-03-08 20:09:34',10,0),('1','147',257548,'daily','2022-03-09','2022-03-09 07:07:45','2022-03-10 07:07:45','503',0.00,0.00,'503','2022-03-09 07:13:46','503','2022-03-09 07:14:07',10,0),('1','147',257549,'daily','2022-03-09','2022-03-09 07:14:34','2022-03-10 07:14:34','503',0.00,0.00,'503','2022-03-09 19:33:26','503','2022-03-09 19:33:47',10,0),('1','147',257550,'daily','2022-03-10','2022-03-10 07:36:17','2022-03-11 07:36:17','503',0.00,0.00,'503','2022-03-10 09:43:58','503','2022-03-10 09:44:20',10,0),('1','147',257551,'daily','2022-03-10','2022-03-10 10:49:51','2022-03-11 10:49:51','503',0.00,0.00,'503','2022-03-10 20:18:23','503','2022-03-10 20:19:40',10,0),('1','147',257552,'daily','2022-03-11','2022-03-11 07:25:19','2022-03-12 07:25:19','503',0.00,0.00,'503','2022-03-11 20:07:41','503','2022-03-11 20:07:58',10,0),('1','147',257553,'daily','2022-03-12','2022-03-12 07:36:04','2022-03-13 07:36:04','503',0.00,0.00,'503','2022-03-12 16:53:52','503','2022-03-12 16:54:39',10,0),('1','147',257554,'daily','2022-03-13','2022-03-13 07:05:09','2022-03-14 07:05:09','503',0.00,0.00,'503','2022-03-13 19:22:33','503','2022-03-13 19:22:55',10,0),('1','147',257555,'daily','2022-03-14','2022-03-14 07:31:52','2022-03-15 07:31:52','503',0.00,0.00,'503','2022-03-14 16:32:39','503','2022-03-14 16:32:58',10,0),('1','147',257556,'daily','2022-03-14','2022-03-14 16:33:46','2022-03-15 16:33:46','503',0.00,0.00,'503','2022-03-14 20:15:24','503','2022-03-14 20:15:45',10,0),('1','147',257557,'daily','2022-03-15','2022-03-15 06:46:49','2022-03-16 06:46:49','503',0.00,0.00,'503','2022-03-15 19:47:31','503','2022-03-15 19:47:50',10,0),('1','147',257558,'daily','2022-03-16','2022-03-16 07:34:57','2022-03-17 07:34:57','503',0.00,0.00,'503','2022-03-16 20:18:55','503','2022-03-16 20:19:16',10,0),('1','147',257559,'daily','2022-03-17','2022-03-17 06:52:53','2022-03-18 06:52:53','503',0.00,0.00,'503','2022-03-17 12:44:28','503','2022-03-17 12:44:49',10,0),('1','147',257560,'daily','2022-03-17','2022-03-17 12:54:35','2022-03-18 12:54:35','503',0.00,0.00,'503','2022-03-17 19:31:52','503','2022-03-17 19:32:10',10,0),('1','147',257561,'daily','2022-03-18','2022-03-18 07:21:34','2022-03-19 07:21:34','503',0.00,0.00,'503','2022-03-18 20:01:45','503','2022-03-18 20:02:57',10,0),('1','147',257562,'daily','2022-03-19','2022-03-19 06:48:44','2022-03-20 06:48:44','503',0.00,0.00,'503','2022-03-19 19:55:59','503','2022-03-19 19:56:45',10,0),('1','147',257563,'Daly','2022-03-20','2022-03-20 07:15:26','2022-03-21 07:15:26','503',0.00,0.00,'503','2022-03-20 08:05:12','503','2022-03-20 08:05:36',10,0),('1','147',257564,'daily','2022-03-20','2022-03-20 08:07:51','2022-03-21 08:07:51','503',0.00,0.00,'503','2022-03-20 19:58:13','503','2022-03-21 07:51:31',10,0),('1','147',257565,'daily','2022-03-21','2022-03-21 07:51:50','2022-03-22 07:51:50','503',0.00,0.00,'503','2022-03-21 19:57:52','503','2022-03-21 19:59:47',10,0),('1','147',257566,'daily','2022-03-22','2022-03-22 08:36:27','2022-03-23 08:36:27','503',0.00,0.00,'503','2022-03-22 19:50:04','503','2022-03-22 19:51:26',10,0),('1','147',257567,'daily','2022-03-23','2022-03-23 07:09:44','2022-03-24 07:09:44','503',0.00,0.00,'503','2022-03-23 09:27:17','503','2022-03-23 09:27:39',10,0),('1','147',257568,'daily','2022-03-23','2022-03-23 09:49:50','2022-03-24 09:49:50','503',0.00,0.00,'503','2022-03-23 19:51:28','503','2022-03-23 19:52:06',10,0),('1','147',257569,'daily','2022-03-24','2022-03-24 08:36:57','2022-03-25 08:36:57','503',0.00,0.00,'503','2022-03-24 20:17:12','503','2022-03-24 20:17:47',10,0),('1','147',257570,'daily','2022-03-25','2022-03-25 06:59:18','2022-03-26 06:59:18','503',0.00,0.00,'503','2022-03-25 19:54:50','503','2022-03-25 19:55:28',10,0),('1','147',257571,'daily','2022-03-26','2022-03-26 07:02:27','2022-03-27 07:02:27','503',0.00,0.00,'503','2022-03-26 09:41:24','503','2022-03-26 09:41:43',10,0),('1','147',257572,'daily','2022-03-26','2022-03-26 09:45:22','2022-03-27 09:45:22','503',0.00,0.00,'503','2022-03-26 20:17:21','503','2022-03-26 20:18:15',10,0),('1','147',257573,'daily','2022-03-27','2022-03-27 07:55:08','2022-03-28 07:55:08','503',0.00,0.00,'503','2022-03-27 09:56:16','503','2022-03-27 09:57:09',10,0),('1','147',257574,'daily','2022-03-27','2022-03-27 09:58:33','2022-03-28 09:58:33','503',0.00,0.00,'503','2022-03-27 19:58:22','503','2022-03-27 19:58:48',10,0),('1','147',257575,'daily','2022-03-28','2022-03-28 07:32:27','2022-03-29 07:32:27','503',0.00,0.00,'503','2022-03-28 13:44:14','503','2022-03-28 13:44:43',10,0),('1','147',257576,'daily','2022-03-28','2022-03-28 14:06:14','2022-03-29 14:06:14','503',0.00,0.00,'503','2022-03-28 20:05:14','503','2022-03-28 20:05:41',10,0),('1','147',257577,'daily','2022-03-29','2022-03-29 07:55:00','2022-03-30 07:55:00','503',0.00,0.00,'503','2022-03-30 06:44:35','503','2022-03-30 06:45:26',10,0),('1','147',257578,'daily','2022-03-30','2022-03-30 06:45:43','2022-03-31 06:45:43','503',0.00,0.00,'503','2022-03-30 17:51:09','503','2022-03-30 17:51:33',10,0),('1','147',257579,'daily','2022-03-31','2022-03-31 11:57:02','2022-04-01 11:57:02','503',0.00,0.00,'503','2022-03-31 19:33:50','503','2022-03-31 19:34:21',10,0),('1','147',257580,'Daily ','2022-04-01','2022-04-01 06:56:31','2022-04-02 06:56:31','503',0.00,0.00,'503','2022-04-01 20:07:25','503','2022-04-01 20:07:58',10,0),('1','147',257581,'daily','2022-04-02','2022-04-02 06:41:40','2022-04-03 06:41:40','503',0.00,0.00,'503','2022-04-02 08:47:31','503','2022-04-02 08:47:51',10,0),('1','147',257582,'daily','2022-04-02','2022-04-02 08:48:14','2022-04-03 08:48:14','503',0.00,0.00,'503','2022-04-02 20:25:10','503','2022-04-02 20:25:41',10,0),('1','147',257583,'daily','2022-04-03','2022-04-03 06:50:15','2022-04-04 06:50:15','503',0.00,0.00,'503','2022-04-03 18:00:17','503','2022-04-03 18:00:57',10,0),('1','147',257584,'daily','2022-04-04','2022-04-04 10:42:01','2022-04-05 10:42:01','503',0.00,0.00,'503','2022-04-04 19:51:45','503','2022-04-04 19:52:13',10,0),('1','147',257585,'daily','2022-04-05','2022-04-05 09:43:24','2022-04-06 09:43:24','503',0.00,0.00,'503','2022-04-05 19:40:34','503','2022-04-05 19:41:15',10,0),('1','147',257586,'daily','2022-04-06','2022-04-06 07:06:41','2022-04-07 07:06:41','503',0.00,0.00,'503','2022-04-06 11:49:37','503','2022-04-06 11:49:58',10,0),('1','147',257587,'daily','2022-04-06','2022-04-06 16:09:58','2022-04-07 16:09:58','503',0.00,0.00,'503','2022-04-06 19:46:45','503','2022-04-06 19:47:07',10,0),('1','147',257588,'daily','2022-04-07','2022-04-07 06:55:49','2022-04-08 06:55:49','503',0.00,0.00,'503','2022-04-07 19:39:14','503','2022-04-07 19:39:43',10,0),('1','147',257589,'daily','2022-04-08','2022-04-08 10:00:07','2022-04-09 10:00:07','503',0.00,0.00,'503','2022-04-08 19:42:09','503','2022-04-08 19:42:45',10,0),('1','147',257590,'Daily','2022-04-09','2022-04-09 10:02:57','2022-04-10 10:02:57','503',0.00,0.00,'503','2022-04-09 12:04:07','503','2022-04-09 12:05:37',10,0),('1','147',257591,'daily','2022-04-09','2022-04-09 13:23:32','2022-04-10 13:23:32','503',0.00,0.00,'503','2022-04-09 19:43:50','503','2022-04-09 19:44:16',10,0),('1','147',257592,'daily','2022-04-10','2022-04-10 06:40:03','2022-04-11 06:40:03','503',0.00,0.00,'503','2022-04-10 19:40:51','503','2022-04-10 19:41:11',10,0),('1','147',257593,'daily','2022-04-11','2022-04-11 06:52:17','2022-04-12 06:52:17','503',0.00,0.00,'503','2022-04-11 10:29:41','503','2022-04-11 10:30:01',10,0),('1','147',257594,'daily','2022-04-12','2022-04-12 11:07:38','2022-04-13 11:07:38','503',0.00,0.00,'503','2022-04-12 19:55:51','503','2022-04-12 19:56:22',10,0),('1','147',257595,'daily','2022-04-13','2022-04-13 09:30:23','2022-04-14 09:30:23','503',0.00,0.00,'503','2022-04-13 19:30:49','503','2022-04-13 19:31:51',10,0),('1','147',257596,'daily','2022-04-14','2022-04-14 06:56:43','2022-04-15 06:56:43','503',0.00,0.00,'503','2022-04-14 10:58:05','503','2022-04-14 10:58:27',10,0),('1','147',257597,'daily','2022-04-14','2022-04-14 11:03:40','2022-04-15 11:03:40','503',0.00,0.00,'503','2022-04-14 19:29:17','503','2022-04-14 19:29:41',10,0),('1','147',257598,'daily','2022-04-15','2022-04-15 07:17:49','2022-04-16 07:17:49','503',0.00,0.00,'503','2022-04-15 20:31:20','503','2022-04-15 20:31:51',10,0),('1','147',257599,'Daily','2022-04-16','2022-04-16 09:15:23','2022-04-17 09:15:23','503',0.00,0.00,'503','2022-04-16 13:25:10','503','2022-04-16 13:25:43',10,0),('1','147',257600,'daily','2022-04-17','2022-04-17 10:38:12','2022-04-18 10:38:12','503',0.00,0.00,'503','2022-04-17 19:21:49','503','2022-04-17 19:22:18',10,0),('1','147',257601,'daily','2022-04-18','2022-04-18 07:09:20','2022-04-19 07:09:20','503',0.00,0.00,'503','2022-04-18 19:38:10','503','2022-04-18 19:38:31',10,0),('1','147',257602,'daily','2022-04-19','2022-04-19 06:56:20','2022-04-20 06:56:20','503',0.00,0.00,'503','2022-04-19 11:53:11','503','2022-04-19 11:53:38',10,0),('1','147',257603,'daily','2022-04-22','2022-04-22 08:28:36','2022-04-23 08:28:36','503',0.00,0.00,'503','2022-04-22 18:17:57','503','2022-04-22 18:18:25',10,0),('1','147',257604,'daily','2022-04-23','2022-04-23 07:49:21','2022-04-24 07:49:21','503',0.00,0.00,'503','2022-04-23 19:49:48','503','2022-04-23 19:50:14',10,0),('1','147',257605,'daily','2022-04-24','2022-04-24 11:10:29','2022-04-25 11:10:29','503',0.00,0.00,'503','2022-04-24 18:36:30','503','2022-04-24 18:36:51',10,0),('1','147',257606,'daily','2022-04-25','2022-04-25 11:03:45','2022-04-26 11:03:45','503',0.00,0.00,'503','2022-04-25 19:54:18','503','2022-04-25 19:54:39',10,0),('1','147',257607,'daily','2022-04-26','2022-04-26 07:04:49','2022-04-27 07:04:49','503',0.00,0.00,'503','2022-04-26 19:47:01','503','2022-04-26 19:47:20',10,0),('1','147',257608,'daily','2022-04-27','2022-04-27 06:50:14','2022-04-28 06:50:14','503',0.00,0.00,'503','2022-04-27 19:20:59','503','2022-04-27 19:21:45',10,0),('1','147',257609,'daily','2022-04-28','2022-04-28 09:53:47','2022-04-29 09:53:47','503',0.00,0.00,'503','2022-04-28 19:53:42','503','2022-04-28 19:54:05',10,0),('1','147',257610,'daily','2022-04-29','2022-04-29 07:10:51','2022-04-30 07:10:51','503',0.00,0.00,'503','2022-04-29 19:55:50','503','2022-04-29 20:02:55',10,0),('1','147',257611,'daily','2022-04-30','2022-04-30 06:56:20','2022-05-01 06:56:20','503',0.00,0.00,'503','2022-04-30 11:46:51','503','2022-04-30 11:47:13',10,0),('1','147',257612,'daily','2022-04-30','2022-04-30 11:53:22','2022-05-01 11:53:22','503',0.00,0.00,'503','2022-04-30 21:08:53','503','2022-04-30 21:09:32',10,0),('1','147',257613,'daily','2022-05-01','2022-05-01 07:51:47','2022-05-02 07:51:47','503',0.00,0.00,'503','2022-05-01 20:03:09','503','2022-05-01 20:03:46',10,0),('1','147',257614,'daily','2022-05-02','2022-05-02 15:29:19','2022-05-03 15:29:19','503',0.00,0.00,'503','2022-05-02 20:09:41','503','2022-05-02 20:10:11',10,0),('1','147',257615,'daily','2022-05-03','2022-05-03 07:00:23','2022-05-04 07:00:23','503',0.00,0.00,'503','2022-05-03 19:30:34','503','2022-05-03 19:31:19',10,0),('1','147',257616,'daily','2022-05-04','2022-05-04 09:39:42','2022-05-05 09:39:42','503',0.00,0.00,'503','2022-05-04 20:21:24','503','2022-05-04 20:22:07',10,0),('1','147',257617,'daily','2022-05-05','2022-05-05 07:10:22','2022-05-06 07:10:22','503',0.00,0.00,'503','2022-05-05 09:51:36','503','2022-05-05 09:52:15',10,0),('1','147',257618,'daily','2022-05-05','2022-05-05 11:43:35','2022-05-06 11:43:35','503',0.00,0.00,'503','2022-05-05 19:28:12','503','2022-05-05 19:31:31',10,0),('1','147',257619,'daily','2022-05-06','2022-05-06 07:11:40','2022-05-07 07:11:40','503',0.00,0.00,'503','2022-05-06 19:04:14','503','2022-05-06 19:06:12',10,0),('1','147',257620,'daily','2022-05-07','2022-05-07 07:19:10','2022-05-08 07:19:10','503',0.00,0.00,'503','2022-05-07 19:13:33','503','2022-05-07 19:15:46',10,0),('1','147',257621,'daily','2022-05-09','2022-05-09 08:27:54','2022-05-10 08:27:54','503',0.00,0.00,'503','2022-05-09 18:47:07','503','2022-05-09 18:47:32',10,0),('1','147',257622,'daily','2022-05-10','2022-05-10 07:04:08','2022-05-11 07:04:08','503',0.00,0.00,'503','2022-05-10 20:48:50','503','2022-05-10 20:49:46',10,0),('1','147',257623,'daily','2022-05-12','2022-05-12 14:28:24','2022-05-13 14:28:24','503',0.00,0.00,'503','2022-05-12 20:13:21','503','2022-05-12 20:13:48',10,0),('1','147',257624,'daily','2022-05-13','2022-05-13 07:07:27','2022-05-14 07:07:27','503',0.00,0.00,'503','2022-05-13 19:57:58','503','2022-05-13 19:58:28',10,0),('1','147',257625,'daily','2022-05-14','2022-05-14 06:39:17','2022-05-15 06:39:17','503',0.00,0.00,'503','2022-05-14 11:25:39','503','2022-05-14 11:26:24',10,0),('1','147',257626,'daily','2022-05-14','2022-05-14 13:46:18','2022-05-15 13:46:18','503',0.00,0.00,'503','2022-05-14 20:12:39','503','2022-05-14 20:13:03',10,0),('1','147',257627,'daily','2022-05-15','2022-05-15 08:48:11','2022-05-16 08:48:11','503',0.00,0.00,'503','2022-05-15 20:34:02','503','2022-05-15 20:34:31',10,0),('1','147',257628,'daily','2022-05-16','2022-05-16 08:13:45','2022-05-17 08:13:45','503',0.00,0.00,'503','2022-05-16 08:16:03','503','2022-05-16 08:16:29',10,0),('1','147',257629,'daily','2022-05-17','2022-05-17 10:25:48','2022-05-18 10:25:48','503',0.00,0.00,'503','2022-05-17 20:05:40','503','2022-05-17 20:06:06',10,0),('1','147',257630,'daily','2022-05-18','2022-05-18 06:51:21','2022-05-19 06:51:21','503',0.00,0.00,'503','2022-05-18 16:39:51','503','2022-05-18 16:43:56',10,0),('1','147',257631,'daily','2022-05-20','2022-05-20 07:22:02','2022-05-21 07:22:02','503',0.00,0.00,'503','2022-05-20 20:05:45','503','2022-05-20 20:06:21',10,0),('1','147',257632,'daily','2022-05-21','2022-05-21 06:33:59','2022-05-22 06:33:59','503',0.00,0.00,'503','2022-05-21 10:09:57','503','2022-05-21 10:10:21',10,0),('1','147',257633,'daily','2022-05-22','2022-05-22 07:37:16','2022-05-23 07:37:16','503',0.00,0.00,'503','2022-05-22 20:11:22','503','2022-05-22 20:12:28',10,0),('1','147',257634,'daily','2022-05-23','2022-05-23 06:45:13','2022-05-24 06:45:13','503',0.00,0.00,'503','2022-05-23 19:42:21','503','2022-05-23 19:42:46',10,0),('1','147',257635,'Daily ','2022-05-24','2022-05-24 05:58:20','2022-05-25 05:58:20','503',0.00,0.00,'503','2022-05-24 08:52:53','503','2022-05-24 08:53:18',10,0),('1','147',257636,'daily','2022-05-24','2022-05-24 13:05:02','2022-05-25 13:05:02','503',0.00,0.00,'503','2022-05-24 19:00:35','503','2022-05-24 19:00:58',10,0),('1','147',257637,'Daily ','2022-05-25','2022-05-25 06:02:48','2022-05-26 06:02:48','503',0.00,0.00,'503','2022-05-25 17:38:02','503','2022-05-25 17:41:54',10,0),('1','147',257638,'Daily ','2022-05-26','2022-05-26 06:20:10','2022-05-27 06:20:10','503',0.00,0.00,'503','2022-05-26 15:19:47','503','2022-05-26 15:20:13',10,0),('1','147',257639,'daily','2022-05-26','2022-05-26 15:37:57','2022-05-27 15:37:57','503',0.00,0.00,'503','2022-05-26 18:41:16','503','2022-05-26 18:42:12',10,0),('1','147',257640,'Daily ','2022-05-27','2022-05-27 06:36:00','2022-05-28 06:36:00','503',0.00,0.00,'503','2022-05-27 18:40:36','503','2022-05-27 18:42:37',10,0),('1','147',257641,'daily','2022-05-28','2022-05-28 06:25:02','2022-05-29 06:25:02','503',0.00,0.00,'503','2022-05-28 19:48:09','503','2022-05-28 19:48:33',10,0),('1','147',257642,'daily','2022-05-29','2022-05-29 06:59:47','2022-05-30 06:59:47','503',0.00,0.00,'503','2022-05-29 13:15:52','503','2022-05-29 13:16:18',10,0),('1','147',257643,'daily','2022-05-30','2022-05-30 07:34:55','2022-05-31 07:34:55','503',0.00,0.00,'503','2022-05-30 19:54:19','503','2022-05-30 19:54:48',10,0),('1','147',257644,'daily','2022-05-31','2022-05-31 06:19:31','2022-06-01 06:19:31','503',0.00,0.00,'503','2022-05-31 15:44:28','503','2022-05-31 15:45:04',10,0),('1','147',257645,'daily','2022-06-03','2022-06-03 07:00:34','2022-06-04 07:00:34','503',0.00,0.00,'503','2022-06-03 19:44:23','503','2022-06-03 19:44:57',10,0),('1','147',257646,'daily','2022-06-04','2022-06-04 06:30:03','2022-06-05 06:30:03','503',0.00,0.00,'503','2022-06-04 14:06:28','503','2022-06-04 14:06:51',10,0),('1','147',257647,'daily','2022-06-05','2022-06-05 11:27:42','2022-06-06 11:27:42','503',0.00,0.00,'503','2022-06-05 19:51:33','503','2022-06-05 19:51:55',10,0),('1','147',257648,'Daily ','2022-06-06','2022-06-06 05:53:16','2022-06-07 05:53:16','503',0.00,0.00,'503','2022-06-06 19:41:56','503','2022-06-06 19:42:22',10,0),('1','147',257649,'daily','2022-06-07','2022-06-07 06:16:45','2022-06-08 06:16:45','503',0.00,0.00,'503','2022-06-07 10:33:15','503','2022-06-07 10:35:53',10,0),('1','147',257650,'daily','2022-06-07','2022-06-07 12:30:50','2022-06-08 12:30:50','503',0.00,0.00,'503','2022-06-07 19:32:29','503','2022-06-07 19:32:56',10,0),('1','147',257651,'daily','2022-06-08','2022-06-08 06:33:18','2022-06-09 06:33:18','503',0.00,0.00,'503','2022-06-08 19:14:20','503','2022-06-08 19:14:46',10,0),('1','147',257652,'daily','2022-06-09','2022-06-09 06:14:06','2022-06-10 06:14:06','503',0.00,0.00,'503','2022-06-09 18:27:15','503','2022-06-09 18:27:48',10,0),('1','147',257653,'daily','2022-06-11','2022-06-11 08:05:23','2022-06-12 08:05:23','503',0.00,0.00,'503','2022-06-11 19:47:58','503','2022-06-11 19:48:25',10,0),('1','147',257654,'daily','2022-06-12','2022-06-12 06:27:13','2022-06-13 06:27:13','503',0.00,0.00,'503','2022-06-12 14:45:17','503','2022-06-12 14:45:45',10,0),('1','147',257655,'daily','2022-06-13','2022-06-13 11:36:33','2022-06-14 11:36:33','503',0.00,0.00,'503','2022-06-13 19:43:06','503','2022-06-13 19:43:35',10,0),('1','147',257656,'daily','2022-06-14','2022-06-14 06:38:51','2022-06-15 06:38:51','503',0.00,0.00,'503','2022-06-14 19:39:30','503','2022-06-14 19:39:54',10,0),('1','147',257657,'daily','2022-06-15','2022-06-15 06:13:35','2022-06-16 06:13:35','503',0.00,0.00,'503','2022-06-15 11:56:41','503','2022-06-15 11:57:14',10,0),('1','147',257658,'daily','2022-06-16','2022-06-16 14:46:54','2022-06-17 14:46:54','503',0.00,0.00,'503','2022-06-16 19:41:14','503','2022-06-16 19:41:39',10,0),('1','147',257659,'Daily ','2022-06-17','2022-06-17 07:16:20','2022-06-18 07:16:20','503',0.00,0.00,'503','2022-06-17 19:52:56','503','2022-06-17 19:54:18',10,0),('1','147',257660,'daily','2022-06-18','2022-06-18 06:08:37','2022-06-19 06:08:37','503',0.00,0.00,'503','2022-06-18 15:43:15','503','2022-06-18 15:43:42',10,0),('1','147',257661,'daily','2022-06-19','2022-06-19 07:38:54','2022-06-20 07:38:54','503',0.00,0.00,'503','2022-06-19 19:46:27','503','2022-06-19 19:48:38',10,0),('1','147',257662,'Daily ','2022-06-20','2022-06-20 06:21:58','2022-06-21 06:21:58','503',0.00,0.00,'503','2022-06-20 19:51:10','503','2022-06-20 19:51:33',10,0),('1','147',257663,'Daily ','2022-06-21','2022-06-21 06:07:22','2022-06-22 06:07:22','503',0.00,0.00,'503','2022-06-21 13:22:21','503','2022-06-21 13:23:07',10,0),('1','147',257664,'daily','2022-06-21','2022-06-21 15:08:23','2022-06-22 15:08:23','503',0.00,0.00,'503','2022-06-21 19:39:13','503','2022-06-21 19:39:56',10,0),('1','147',257665,'daily','2022-06-22','2022-06-22 06:27:41','2022-06-23 06:27:41','503',0.00,0.00,'503','2022-06-22 19:21:23','503','2022-06-22 19:21:54',10,0),('1','147',257666,'daily','2022-06-23','2022-06-23 06:16:08','2022-06-24 06:16:08','503',0.00,0.00,'503','2022-06-23 19:25:58','503','2022-06-23 19:26:19',10,0),('1','147',257667,'Daily ','2022-06-24','2022-06-24 07:15:20','2022-06-25 07:15:20','503',0.00,0.00,'503','2022-06-24 09:50:25','503','2022-06-24 09:50:49',10,0),('1','147',257668,'daily','2022-06-24','2022-06-24 10:38:30','2022-06-25 10:38:30','503',0.00,0.00,'503','2022-06-24 19:32:29','503','2022-06-24 19:32:52',10,0),('1','147',257669,'Daily ','2022-06-25','2022-06-25 06:32:18','2022-06-26 06:32:18','503',0.00,0.00,'503','2022-06-25 20:02:14','503','2022-06-25 20:02:40',10,0),('1','147',257670,'daily','2022-06-26','2022-06-26 06:11:25','2022-06-27 06:11:25','503',0.00,0.00,'503','2022-06-26 12:36:49','503','2022-06-26 12:37:13',10,0),('1','147',257671,'daily','2022-06-26','2022-06-26 14:31:26','2022-06-27 14:31:26','503',0.00,0.00,'503','2022-06-26 19:42:53','503','2022-06-26 19:43:39',10,0),('1','147',257672,'daily','2022-06-27','2022-06-27 06:16:22','2022-06-28 06:16:22','503',0.00,0.00,'503','2022-06-27 19:28:26','503','2022-06-27 19:28:50',10,0),('1','147',257673,'daily','2022-06-28','2022-06-28 06:34:33','2022-06-29 06:34:33','503',0.00,0.00,'503','2022-06-28 19:28:04','503','2022-06-28 19:28:29',10,0),('1','147',257674,'Daily ','2022-06-29','2022-06-29 06:26:28','2022-06-30 06:26:28','503',0.00,0.00,'503','2022-06-29 11:16:25','503','2022-06-29 11:16:56',10,0),('1','147',257675,'daily','2022-06-29','2022-06-29 13:11:19','2022-06-30 13:11:19','503',0.00,0.00,'503','2022-06-29 19:59:10','503','2022-06-29 19:59:47',10,0),('1','147',257676,'daily','2022-06-30','2022-06-30 06:03:20','2022-07-01 06:03:20','503',0.00,0.00,'503','2022-06-30 20:14:52','503','2022-06-30 20:15:18',10,0),('1','147',257677,'daily','2022-07-01','2022-07-01 06:24:04','2022-07-02 06:24:04','503',0.00,0.00,'503','2022-07-01 15:19:22','503','2022-07-01 15:19:44',10,0),('1','147',257678,'daily','2022-07-01','2022-07-01 16:16:18','2022-07-02 16:16:18','503',0.00,0.00,'503','2022-07-01 19:52:17','503','2022-07-01 19:52:41',10,0),('1','147',257679,'Daily ','2022-07-02','2022-07-02 06:25:17','2022-07-03 06:25:17','503',0.00,0.00,'503','2022-07-02 20:01:37','503','2022-07-02 20:02:08',10,0),('1','147',257680,'Daily ','2022-07-03','2022-07-03 06:26:54','2022-07-04 06:26:54','503',0.00,0.00,'503','2022-07-03 11:56:58','503','2022-07-03 11:57:25',10,0),('1','147',257681,'daily','2022-07-03','2022-07-03 12:09:22','2022-07-04 12:09:22','503',0.00,0.00,'503','2022-07-03 19:40:10','503','2022-07-03 19:40:51',10,0),('1','147',257682,'daily','2022-07-04','2022-07-04 06:18:36','2022-07-05 06:18:36','503',0.00,0.00,'503','2022-07-04 20:18:46','503','2022-07-04 20:23:26',10,0),('1','147',257683,'daily','2022-07-05','2022-07-05 06:10:11','2022-07-06 06:10:11','503',0.00,0.00,'503','2022-07-05 12:04:18','503','2022-07-05 12:04:48',10,0),('1','147',257684,'daily','2022-07-05','2022-07-05 13:25:08','2022-07-06 13:25:08','503',0.00,0.00,'503','2022-07-05 19:29:55','503','2022-07-05 19:30:22',10,0),('1','147',257685,'daily','2022-07-06','2022-07-06 06:04:33','2022-07-07 06:04:33','503',0.00,0.00,'503','2022-07-06 19:59:23','503','2022-07-06 20:00:08',10,0),('1','147',257686,'daily','2022-07-07','2022-07-07 06:27:39','2022-07-08 06:27:39','503',0.00,0.00,'503','2022-07-07 17:32:32','503','2022-07-07 17:33:09',10,0),('1','147',257687,'daily','2022-07-08','2022-07-08 08:13:30','2022-07-09 08:13:30','503',0.00,0.00,'503','2022-07-08 19:58:24','503','2022-07-08 19:58:51',10,0),('1','147',257688,'daily','2022-07-10','2022-07-10 07:30:07','2022-07-11 07:30:07','503',0.00,0.00,'503','2022-07-10 18:52:54','503','2022-07-10 18:53:14',10,0),('1','147',257689,'daily','2022-07-11','2022-07-11 12:17:32','2022-07-12 12:17:32','503',0.00,0.00,'503','2022-07-11 19:43:24','503','2022-07-11 19:43:45',10,0),('1','147',257690,'daily','2022-07-12','2022-07-12 06:48:50','2022-07-13 06:48:50','503',0.00,0.00,'503','2022-07-12 08:41:46','503','2022-07-12 08:42:08',10,0),('1','147',257691,'daily','2022-07-13','2022-07-13 17:59:05','2022-07-14 17:59:05','503',0.00,0.00,'503','2022-07-13 19:34:29','503','2022-07-13 19:34:53',10,0),('1','147',257692,'daily','2022-07-14','2022-07-14 07:09:20','2022-07-15 07:09:20','503',0.00,0.00,'503','2022-07-14 20:06:23','503','2022-07-14 20:06:46',10,0),('1','147',257693,'daily','2022-07-15','2022-07-15 06:47:30','2022-07-16 06:47:30','503',0.00,0.00,'503','2022-07-15 17:49:09','503','2022-07-15 17:49:44',10,0),('1','147',257694,'daily','2022-07-16','2022-07-16 07:46:29','2022-07-17 07:46:29','503',0.00,0.00,'503','2022-07-16 19:20:09','503','2022-07-16 19:20:45',10,0),('1','147',257695,'daily','2022-07-17','2022-07-17 06:54:47','2022-07-18 06:54:47','503',0.00,0.00,'503','2022-07-17 19:23:05','503','2022-07-17 19:23:37',10,0),('1','147',257696,'daily','2022-07-18','2022-07-18 06:55:46','2022-07-19 06:55:46','503',0.00,0.00,'503','2022-07-18 06:56:28','503','2022-07-18 06:57:12',10,0),('1','147',257697,'daily','2022-07-18','2022-07-18 06:57:54','2022-07-19 06:57:54','503',0.00,0.00,'503','2022-07-18 10:00:04','503','2022-07-18 10:00:38',10,0),('1','147',257698,'daily','2022-07-18','2022-07-18 10:40:18','2022-07-19 10:40:18','503',0.00,0.00,'503','2022-07-18 19:31:33','503','2022-07-18 19:31:55',10,0),('1','147',257699,'daily','2022-07-19','2022-07-19 06:43:52','2022-07-20 06:43:52','503',0.00,0.00,'503','2022-07-19 19:25:22','503','2022-07-19 19:25:40',10,0),('1','147',257700,'daily','2022-07-20','2022-07-20 06:16:12','2022-07-21 06:16:12','503',0.00,0.00,'503','2022-07-20 19:32:10','503','2022-07-20 19:33:08',10,0),('1','147',257701,'Daily ','2022-07-21','2022-07-21 06:19:39','2022-07-22 06:19:39','503',0.00,0.00,'503','2022-07-21 14:25:06','503','2022-07-21 14:25:34',10,0),('1','147',257702,'daily','2022-07-21','2022-07-21 14:41:20','2022-07-22 14:41:20','503',0.00,0.00,'503','2022-07-21 19:24:43','503','2022-07-21 19:25:14',10,0),('1','147',257703,'daily','2022-07-22','2022-07-22 07:13:24','2022-07-23 07:13:24','503',0.00,0.00,'503','2022-07-22 19:23:16','503','2022-07-22 19:24:43',10,0),('1','147',257704,'daily','2022-07-23','2022-07-23 06:47:23','2022-07-24 06:47:23','503',0.00,0.00,'503','2022-07-23 17:52:08','503','2022-07-23 17:52:45',10,0),('1','147',257705,'daily','2022-07-24','2022-07-24 07:34:36','2022-07-25 07:34:36','503',0.00,0.00,'503','2022-07-24 19:35:04','503','2022-07-24 19:35:39',10,0),('1','147',257706,'daily','2022-07-25','2022-07-25 06:36:48','2022-07-26 06:36:48','503',0.00,0.00,'503','2022-07-25 19:28:22','503','2022-07-25 19:28:59',10,0),('1','147',257707,'daily','2022-07-26','2022-07-26 06:29:47','2022-07-27 06:29:47','503',0.00,0.00,'503','2022-07-26 14:28:53','503','2022-07-26 14:29:23',10,0),('1','147',257708,'daily','2022-07-26','2022-07-26 14:49:57','2022-07-27 14:49:57','503',0.00,0.00,'503','2022-07-26 14:55:25','503','2022-07-26 14:55:48',10,0),('1','147',257709,'daily','2022-07-26','2022-07-26 15:28:47','2022-07-27 15:28:47','503',0.00,0.00,'503','2022-07-26 19:30:32','503','2022-07-26 19:32:03',10,0),('1','147',257710,'daily','2022-07-27','2022-07-27 06:47:16','2022-07-28 06:47:16','503',0.00,0.00,'503','2022-07-27 19:13:13','503','2022-07-27 19:13:35',10,0),('1','147',257711,'daily','2022-07-28','2022-07-28 07:15:30','2022-07-29 07:15:30','503',0.00,0.00,'503','2022-07-28 19:36:27','503','2022-07-28 19:36:59',10,0),('1','147',257712,'daily','2022-07-29','2022-07-29 07:01:20','2022-07-30 07:01:20','503',0.00,0.00,'503','2022-07-29 08:57:47','503','2022-07-29 08:58:18',10,0),('1','147',257713,'daily','2022-07-29','2022-07-29 09:33:36','2022-07-30 09:33:36','503',0.00,0.00,'503','2022-07-29 19:23:51','503','2022-07-29 19:25:06',10,0),('1','147',257714,'daily','2022-07-30','2022-07-30 06:55:54','2022-07-31 06:55:54','503',0.00,0.00,'503','2022-07-30 19:10:56','503','2022-07-30 19:11:18',10,0),('1','147',257715,'daily','2022-07-31','2022-07-31 07:14:26','2022-08-01 07:14:26','503',0.00,0.00,'503','2022-07-31 10:58:04','503','2022-07-31 10:58:31',10,0),('1','147',257716,'daily','2022-07-31','2022-07-31 11:12:01','2022-08-01 11:12:01','503',0.00,0.00,'503','2022-07-31 19:46:07','503','2022-07-31 19:46:35',10,0),('1','147',257717,'daily','2022-08-01','2022-08-01 07:10:32','2022-08-02 07:10:32','503',0.00,0.00,'503','2022-08-01 19:18:23','503','2022-08-01 19:19:00',10,0),('1','147',257718,'daily','2022-08-02','2022-08-02 06:57:19','2022-08-03 06:57:19','503',0.00,0.00,'503','2022-08-02 11:14:24','503','2022-08-02 11:14:50',10,0),('1','147',257719,'DAILY','2022-08-02','2022-08-02 13:43:02','2022-08-03 13:43:02','503',0.00,0.00,'503','2022-08-02 19:41:41','503','2022-08-02 19:42:11',10,0),('1','147',257720,'daily','2022-08-03','2022-08-03 07:08:25','2022-08-04 07:08:25','503',0.00,0.00,'503','2022-08-03 19:36:01','503','2022-08-03 19:36:42',10,0),('1','147',257721,'daily','2022-08-04','2022-08-04 06:58:35','2022-08-05 06:58:35','503',0.00,0.00,'503','2022-08-04 15:21:56','503','2022-08-04 15:22:31',10,0),('1','147',257722,'DAILY','2022-08-04','2022-08-04 15:51:10','2022-08-05 15:51:10','503',0.00,0.00,'503','2022-08-04 19:23:17','503','2022-08-04 19:23:39',10,0),('1','147',257723,'daily','2022-08-05','2022-08-05 06:54:59','2022-08-06 06:54:59','503',0.00,0.00,'503','2022-08-05 19:44:17','503','2022-08-05 19:44:56',10,0),('1','147',257724,'DAILY','2022-08-06','2022-08-06 06:42:20','2022-08-07 06:42:20','503',0.00,0.00,'503','2022-08-06 15:40:44','503','2022-08-06 15:41:11',10,0),('1','147',257725,'daily','2022-08-06','2022-08-06 16:35:09','2022-08-07 16:35:09','503',0.00,0.00,'503','2022-08-06 19:33:44','503','2022-08-06 19:35:47',10,0),('1','147',257726,'DAILY','2022-08-07','2022-08-07 06:46:50','2022-08-08 06:46:50','503',0.00,0.00,'503','2022-08-07 19:37:07','503','2022-08-07 19:37:36',10,0),('1','147',257727,'daily','2022-08-08','2022-08-08 06:49:10','2022-08-09 06:49:10','503',0.00,0.00,'503','2022-08-08 15:03:29','503','2022-08-08 15:04:40',10,0),('1','147',257728,'daily','2022-08-08','2022-08-08 15:15:04','2022-08-09 15:15:04','503',0.00,0.00,'503','2022-08-08 19:22:07','503','2022-08-08 19:22:33',10,0),('1','147',257729,'daily','2022-08-09','2022-08-09 06:56:53','2022-08-10 06:56:53','503',0.00,0.00,'503','2022-08-09 17:22:05','503','2022-08-09 17:22:41',10,0),('1','147',257730,'DAILY','2022-08-09','2022-08-09 17:46:49','2022-08-10 17:46:49','503',0.00,0.00,'503','2022-08-09 21:40:57','503','2022-08-09 21:41:27',10,0),('1','147',257731,'DAILY','2022-08-10','2022-08-10 06:55:20','2022-08-11 06:55:20','503',0.00,0.00,'503','2022-08-10 19:24:29','503','2022-08-10 19:24:56',10,0),('1','147',257732,'DAILY','2022-08-11','2022-08-11 07:03:13','2022-08-12 07:03:13','503',0.00,0.00,'503','2022-08-11 19:29:38','503','2022-08-11 19:30:08',10,0),('1','147',257733,'daily','2022-08-12','2022-08-12 06:45:50','2022-08-13 06:45:50','503',0.00,0.00,'503','2022-08-12 13:57:51','503','2022-08-12 13:58:24',10,0),('1','147',257734,'DAILY','2022-08-12','2022-08-12 13:59:06','2022-08-13 13:59:06','503',0.00,0.00,'503','2022-08-12 19:19:39','503','2022-08-12 19:20:00',10,0),('1','147',257735,'DAILY','2022-08-13','2022-08-13 06:44:08','2022-08-14 06:44:08','503',0.00,0.00,'503','2022-08-13 19:22:35','503','2022-08-13 19:23:02',10,0),('1','147',257736,'DAILY','2022-08-14','2022-08-14 07:10:20','2022-08-15 07:10:20','503',0.00,0.00,'503','2022-08-14 15:57:46','503','2022-08-14 15:58:10',10,0),('1','147',257737,'DAILY','2022-08-14','2022-08-14 16:25:47','2022-08-15 16:25:47','503',0.00,0.00,'503','2022-08-14 19:27:56','503','2022-08-14 19:28:21',10,0),('1','147',257738,'DAILY','2022-08-15','2022-08-15 07:27:31','2022-08-16 07:27:31','503',0.00,0.00,'503','2022-08-15 19:24:02','503','2022-08-15 19:24:27',10,0),('1','147',257739,'daily','2022-08-16','2022-08-16 06:35:43','2022-08-17 06:35:43','503',0.00,0.00,'503','2022-08-16 19:23:30','503','2022-08-16 19:23:59',10,0),('1','147',257740,'daily','2022-08-17','2022-08-17 07:00:28','2022-08-18 07:00:28','503',0.00,0.00,'503','2022-08-17 09:53:04','503','2022-08-17 09:54:18',10,0),('1','147',257741,'DAILY','2022-08-17','2022-08-17 10:16:44','2022-08-18 10:16:44','503',0.00,0.00,'503','2022-08-17 19:51:16','503','2022-08-17 19:51:41',10,0),('1','147',257742,'daily','2022-08-18','2022-08-18 06:40:21','2022-08-19 06:40:21','503',0.00,0.00,'503','2022-08-18 19:20:19','503','2022-08-18 19:21:20',10,0),('1','147',257743,'DAILY','2022-08-19','2022-08-19 06:38:08','2022-08-20 06:38:08','503',0.00,0.00,'503','2022-08-19 19:58:06','503','2022-08-19 19:59:13',10,0),('1','147',257744,'daily','2022-08-20','2022-08-20 06:14:58','2022-08-21 06:14:58','503',0.00,0.00,'503','2022-08-20 11:34:31','503','2022-08-20 11:34:56',10,0),('1','147',257745,'DAILY','2022-08-20','2022-08-20 12:14:29','2022-08-21 12:14:29','503',0.00,0.00,'503','2022-08-20 19:30:55','503','2022-08-20 19:37:49',10,0),('1','147',257746,'DAILY SALES','2022-08-21','2022-08-21 06:36:00','2022-08-22 06:36:00','503',0.00,0.00,'503','2022-08-21 20:10:59','503','2022-08-21 20:11:24',10,0),('1','147',257747,'DAILY SHIFT','2022-08-22','2022-08-22 06:32:37','2022-08-23 06:32:37','503',0.00,0.00,'503','2022-08-22 19:09:49','503','2022-08-22 19:10:34',10,0),('1','147',257748,'DAILY SHIFT','2022-08-23','2022-08-23 07:56:46','2022-08-24 07:56:46','503',0.00,0.00,'503','2022-08-23 19:46:10','503','2022-08-23 19:46:35',10,0),('1','147',257749,'DAILY SALES','2022-08-24','2022-08-24 06:29:10','2022-08-25 06:29:10','503',0.00,0.00,'503','2022-08-24 19:39:08','503','2022-08-24 19:39:48',10,0),('1','147',257750,'Daily ','2022-08-25','2022-08-25 07:01:38','2022-08-26 07:01:38','503',0.00,0.00,'503','2022-08-25 18:17:01','503','2022-08-25 18:18:01',10,0),('1','147',257751,'DAILY SHIFT','2022-08-26','2022-08-26 07:29:25','2022-08-27 07:29:25','503',0.00,0.00,'503','2022-08-26 21:49:27','503','2022-08-26 21:50:01',10,0),('1','147',257752,'DAILY SHIFT','2022-08-27','2022-08-27 10:53:47','2022-08-28 10:53:47','503',0.00,0.00,'503','2022-08-27 19:43:19','503','2022-08-27 19:43:45',10,0),('1','147',257753,'DAILY SHIFT','2022-08-28','2022-08-28 07:16:23','2022-08-29 07:16:23','503',0.00,0.00,'503','2022-08-28 19:20:15','503','2022-08-28 19:20:42',10,0),('1','147',257754,'DAILY SHIFT','2022-08-29','2022-08-29 06:41:04','2022-08-30 06:41:04','503',0.00,0.00,'503','2022-08-29 09:07:29','503','2022-08-29 09:07:51',10,0),('1','147',257755,'DAILY SHIFT','2022-08-29','2022-08-29 09:08:19','2022-08-30 09:08:19','503',0.00,0.00,'503','2022-08-29 19:52:08','503','2022-08-29 19:52:46',10,0),('1','147',257756,'DAILY SHIFT','2022-08-30','2022-08-30 06:42:37','2022-08-31 06:42:37','503',0.00,0.00,'503','2022-08-30 19:52:17','503','2022-08-30 19:52:49',10,0),('1','147',257757,'DAILY SHIFT','2022-08-31','2022-08-31 06:37:46','2022-09-01 06:37:46','503',0.00,0.00,'503','2022-08-31 19:15:51','503','2022-08-31 19:16:33',10,0),('1','147',257758,'DAILY SHIFT','2022-09-01','2022-09-01 06:32:18','2022-09-02 06:32:18','503',0.00,0.00,'503','2022-09-01 19:44:39','503','2022-09-01 19:45:06',10,0),('1','147',257759,'DAILY SHIFT','2022-09-02','2022-09-02 07:03:50','2022-09-03 07:03:50','503',0.00,0.00,'503','2022-09-02 21:07:55','503','2022-09-02 21:08:17',10,0),('1','147',257760,'DAILY SHIFT','2022-09-02','2022-09-02 21:16:04','2022-09-03 21:16:04','503',0.00,0.00,'503','2022-09-02 21:21:19','503','2022-09-02 21:21:37',10,0),('1','147',257761,'DAILY SHIFT','2022-09-03','2022-09-03 06:42:46','2022-09-04 06:42:46','503',0.00,0.00,'503','2022-09-03 10:24:09','503','2022-09-03 10:24:37',10,0),('1','147',257762,'DAILY SALES','2022-09-03','2022-09-03 14:10:34','2022-09-04 14:10:34','503',0.00,0.00,'503','2022-09-03 19:47:07','503','2022-09-03 19:47:52',10,0),('1','147',257763,'DAILY SHIFT','2022-09-04','2022-09-04 06:20:25','2022-09-05 06:20:25','503',0.00,0.00,'503','2022-09-04 19:24:48','503','2022-09-04 19:25:16',10,0),('1','147',257764,'daily','2022-09-05','2022-09-05 06:40:28','2022-09-06 06:40:28','503',0.00,0.00,'503','2022-09-05 13:54:48','503','2022-09-05 13:55:14',10,0),('1','147',257765,'DAILY','2022-09-05','2022-09-05 14:26:18','2022-09-06 14:26:18','503',0.00,0.00,'503','2022-09-05 19:22:56','503','2022-09-05 19:23:17',10,0),('1','147',257766,'DAILY SALES','2022-09-06','2022-09-06 06:19:59','2022-09-07 06:19:59','503',0.00,0.00,'503','2022-09-06 19:45:32','503','2022-09-06 19:46:11',10,0),('1','147',257767,'DAILY SHIFT','2022-09-07','2022-09-07 06:24:00','2022-09-08 06:24:00','503',0.00,0.00,'503','2022-09-07 18:21:07','503','2022-09-07 18:21:59',10,0),('1','147',257768,'DAILY SHIFT','2022-09-08','2022-09-08 06:48:39','2022-09-09 06:48:39','503',0.00,0.00,'503','2022-09-08 19:42:30','503','2022-09-08 19:50:42',10,0),('1','147',257769,'DAILY SALES','2022-09-09','2022-09-09 06:32:52','2022-09-10 06:32:52','503',0.00,0.00,'503','2022-09-09 19:43:18','503','2022-09-09 19:44:00',10,0),('1','147',257770,'DAILY SALES','2022-09-10','2022-09-10 06:23:58','2022-09-11 06:23:58','503',0.00,0.00,'503','2022-09-10 09:38:44','503','2022-09-10 09:39:06',10,0),('1','147',257771,'DAILY','2022-09-10','2022-09-10 09:40:23','2022-09-11 09:40:23','503',0.00,0.00,'503','2022-09-10 09:52:27','503','2022-09-10 09:52:51',10,0),('1','147',257772,'DAILY','2022-09-10','2022-09-10 09:54:35','2022-09-11 09:54:35','503',0.00,0.00,'503','2022-09-10 19:19:54','503','2022-09-10 19:21:05',10,0),('1','147',257773,'DAILY SALES','2022-09-11','2022-09-11 06:56:11','2022-09-12 06:56:11','503',0.00,0.00,'503','2022-09-11 14:55:50','503','2022-09-11 14:57:06',10,0),('1','147',257774,'DAILY','2022-09-12','2022-09-12 15:12:38','2022-09-13 15:12:38','503',0.00,0.00,'503','2022-09-12 19:32:17','503','2022-09-12 19:32:40',10,0),('1','147',257775,'DAILY SALES','2022-09-13','2022-09-13 06:24:46','2022-09-14 06:24:46','503',0.00,0.00,'503','2022-09-13 19:18:12','503','2022-09-13 19:18:47',10,0),('1','147',257776,'DAILY SALES','2022-09-14','2022-09-14 06:16:42','2022-09-15 06:16:42','503',0.00,0.00,'503','2022-09-14 12:48:06','503','2022-09-14 12:48:29',10,0),('1','147',257777,'DAILY SALES','2022-09-14','2022-09-14 13:05:45','2022-09-15 13:05:45','503',0.00,0.00,'503','2022-09-14 19:15:13','503','2022-09-14 19:15:48',10,0),('1','147',257778,'DAILY SALES','2022-09-15','2022-09-15 06:36:01','2022-09-16 06:36:01','503',0.00,0.00,'503','2022-09-15 19:19:31','503','2022-09-15 19:20:18',10,0),('1','147',257779,'DAILY SALES','2022-09-16','2022-09-16 06:35:49','2022-09-17 06:35:49','503',0.00,0.00,'503','2022-09-16 19:02:58','503','2022-09-16 19:04:16',10,0),('1','147',257780,'DAILY SALES','2022-09-17','2022-09-17 06:13:07','2022-09-18 06:13:07','503',0.00,0.00,'503','2022-09-17 09:17:07','503','2022-09-17 09:17:29',10,0),('1','147',257781,'DAILY','2022-09-17','2022-09-17 11:47:43','2022-09-18 11:47:43','503',0.00,0.00,'503','2022-09-17 19:23:44','503','2022-09-17 19:24:47',10,0),('1','147',257782,'DAILY SALES','2022-09-18','2022-09-18 06:23:47','2022-09-19 06:23:47','503',0.00,0.00,'503','2022-09-18 19:09:08','503','2022-09-18 19:10:23',10,0),('1','147',257783,'DAILY SALES','2022-09-19','2022-09-19 06:34:59','2022-09-20 06:34:59','503',0.00,0.00,'503','2022-09-19 12:21:38','503','2022-09-19 12:22:01',10,0),('1','147',257784,'DAILY','2022-09-19','2022-09-19 14:44:52','2022-09-20 14:44:52','503',0.00,0.00,'503','2022-09-19 18:56:14','503','2022-09-19 18:56:48',10,0),('1','147',257785,'DAILY SALES','2022-09-20','2022-09-20 06:24:24','2022-09-21 06:24:24','503',0.00,0.00,'503','2022-09-20 19:11:58','503','2022-09-20 19:12:35',10,0),('1','147',257786,'DAILY SALES','2022-09-21','2022-09-21 06:35:53','2022-09-22 06:35:53','503',0.00,0.00,'503','2022-09-21 19:06:02','503','2022-09-21 19:06:39',10,0),('1','147',257787,'DAILY SALES','2022-09-22','2022-09-22 06:22:55','2022-09-23 06:22:55','503',0.00,0.00,'503','2022-09-22 10:00:52','503','2022-09-22 10:01:21',10,0),('1','147',257788,'DAILY SALES','2022-09-22','2022-09-22 10:36:03','2022-09-23 10:36:03','503',0.00,0.00,'503','2022-09-22 19:08:21','503','2022-09-22 19:08:59',10,0),('1','147',257789,'DAILY SALES','2022-09-23','2022-09-23 06:23:43','2022-09-24 06:23:43','503',0.00,0.00,'503','2022-09-23 19:02:50','503','2022-09-23 19:03:28',10,0),('1','147',257790,'DAILY SALES','2022-09-24','2022-09-24 06:28:52','2022-09-25 06:28:52','503',0.00,0.00,'503','2022-09-24 19:06:10','503','2022-09-24 19:06:48',10,0),('1','147',257791,'DAILY SALES','2022-09-25','2022-09-25 06:19:48','2022-09-26 06:19:48','503',0.00,0.00,'503','2022-09-25 11:38:20','503','2022-09-25 11:38:43',10,0),('1','147',257792,'DAILY','2022-09-25','2022-09-25 11:40:54','2022-09-26 11:40:54','503',0.00,0.00,'503','2022-09-25 18:53:39','503','2022-09-25 18:54:08',10,0),('1','147',257793,'DAILY SALES','2022-09-26','2022-09-26 06:21:54','2022-09-27 06:21:54','503',0.00,0.00,'503','2022-09-26 19:07:20','503','2022-09-26 19:07:57',10,0),('1','147',257794,'DAILY SALES','2022-09-27','2022-09-27 06:19:45','2022-09-28 06:19:45','503',0.00,0.00,'503','2022-09-27 17:29:08','503','2022-09-27 17:29:38',10,0),('1','147',257795,'DAILY SALES','2022-09-28','2022-09-28 06:35:19','2022-09-29 06:35:19','503',0.00,0.00,'503','2022-09-28 19:01:05','503','2022-09-28 19:02:00',10,0),('1','147',257796,'DAILY SALES','2022-09-29','2022-09-29 06:31:20','2022-09-30 06:31:20','503',0.00,0.00,'503','2022-09-29 18:45:58','503','2022-09-29 18:46:44',10,0),('1','147',257797,'DAILY SALES','2022-09-30','2022-09-30 07:00:08','2022-10-01 07:00:08','503',0.00,0.00,'503','2022-09-30 16:54:14','503','2022-09-30 16:54:40',10,0),('1','147',257798,'DAILY SALES','2022-10-01','2022-10-01 06:57:37','2022-10-02 06:57:37','503',0.00,0.00,'503','2022-10-01 18:58:28','503','2022-10-01 18:59:14',10,0),('1','147',257799,'DAILY SALES','2022-10-02','2022-10-02 07:35:13','2022-10-03 07:35:13','503',0.00,0.00,'503','2022-10-02 13:07:27','503','2022-10-02 13:07:53',10,0),('1','147',257800,'DAILY SALES','2022-10-02','2022-10-02 13:39:00','2022-10-03 13:39:00','503',0.00,0.00,'503','2022-10-02 18:53:58','503','2022-10-02 18:54:25',10,0),('1','147',257801,'DAILY SALES','2022-10-03','2022-10-03 07:10:06','2022-10-04 07:10:06','503',0.00,0.00,'503','2022-10-03 20:08:22','503','2022-10-03 20:08:53',10,0),('1','147',257802,'DAILY SALES','2022-10-04','2022-10-04 06:53:57','2022-10-05 06:53:57','503',0.00,0.00,'503','2022-10-04 16:55:42','503','2022-10-04 16:56:25',10,0),('1','147',257803,'DAILY SALES','2022-10-05','2022-10-05 06:47:14','2022-10-06 06:47:14','503',0.00,0.00,'503','2022-10-05 19:31:09','503','2022-10-05 19:32:31',10,0),('1','147',257804,'DAILY SALES','2022-10-06','2022-10-06 06:36:54','2022-10-07 06:36:54','503',0.00,0.00,'503','2022-10-06 15:43:58','503','2022-10-06 15:45:14',10,0),('1','147',257805,'DAILY SALES','2022-10-11','2022-10-11 09:29:51','2022-10-12 09:29:51','503',0.00,0.00,'503','2022-10-11 18:41:43','503','2022-10-11 18:42:28',10,0),('1','147',257806,'DAILY SALES','2022-10-12','2022-10-12 06:32:06','2022-10-13 06:32:06','503',0.00,0.00,'503','2022-10-12 18:50:41','503','2022-10-12 18:51:29',10,0),('1','147',257807,'DAILY SALES','2022-10-13','2022-10-13 06:42:14','2022-10-14 06:42:14','503',0.00,0.00,'503','2022-10-13 13:28:27','503','2022-10-13 13:28:54',10,0),('1','147',257808,'DAILY SALES','2022-10-13','2022-10-13 13:36:50','2022-10-14 13:36:50','503',0.00,0.00,'503','2022-10-13 18:52:14','503','2022-10-13 18:52:42',10,0),('1','147',257809,'DAILY SALES','2022-10-14','2022-10-14 06:20:16','2022-10-15 06:20:16','503',0.00,0.00,'503','2022-10-14 18:46:05','503','2022-10-14 18:46:46',10,0),('1','147',257810,'Operational loss ','2022-10-14','2022-10-14 18:57:01','2022-10-15 18:57:01','503',0.00,0.00,'503','2022-10-14 19:03:35','503','2022-10-14 19:04:08',10,0),('1','147',257811,'DAILY SALES','2022-10-15','2022-10-15 06:22:47','2022-10-16 06:22:47','503',0.00,0.00,'503','2022-10-15 18:30:15','503','2022-10-15 18:30:51',10,0),('1','147',257812,'Operational loss ','2022-10-15','2022-10-15 20:17:02','2022-10-16 20:17:02','503',0.00,0.00,'503','2022-10-15 20:20:17','503','2022-10-15 20:20:40',10,0),('1','147',257813,'DAILY SALES','2022-10-16','2022-10-16 08:05:46','2022-10-17 08:05:46','503',0.00,0.00,'503','2022-10-16 18:43:52','503','2022-10-16 18:44:32',10,0),('1','147',257814,'DAILY SALES','2022-10-17','2022-10-17 06:44:29','2022-10-18 06:44:29','503',0.00,0.00,'503','2022-10-17 19:11:41','503','2022-10-17 19:12:24',10,0),('1','147',257815,'DAILY SALES','2022-10-18','2022-10-18 06:57:23','2022-10-19 06:57:23','503',0.00,0.00,'503','2022-10-18 16:55:57','503','2022-10-18 16:56:31',10,0),('1','147',257816,'DAILY SALES','2022-10-19','2022-10-19 06:55:34','2022-10-20 06:55:34','503',0.00,0.00,'503','2022-10-19 09:05:10','503','2022-10-19 09:05:40',10,0),('1','147',257817,'DAILY SALES','2022-10-19','2022-10-19 09:07:46','2022-10-20 09:07:46','503',0.00,0.00,'503','2022-10-19 19:00:03','503','2022-10-19 19:00:53',10,0),('1','147',257818,'DAILY SALES','2022-10-20','2022-10-20 06:59:38','2022-10-21 06:59:38','503',0.00,0.00,'503','2022-10-20 18:59:26','503','2022-10-20 19:00:09',10,0),('1','147',257819,'DAILY SALES','2022-10-21','2022-10-21 07:14:52','2022-10-22 07:14:52','503',0.00,0.00,'503','2022-10-21 17:37:05','503','2022-10-21 17:38:07',10,0),('1','147',257820,'DAILY SALES','2022-10-22','2022-10-22 06:50:10','2022-10-23 06:50:10','503',0.00,0.00,'503','2022-10-22 18:53:07','503','2022-10-22 18:53:48',10,0),('1','147',257821,'DAILY SALES','2022-10-23','2022-10-23 06:16:56','2022-10-24 06:16:56','503',0.00,0.00,'503','2022-10-23 11:26:15','503','2022-10-23 11:27:08',10,0),('1','147',257822,'DAILY SALES','2022-10-23','2022-10-23 15:16:56','2022-10-24 15:16:56','503',0.00,0.00,'503','2022-10-23 18:48:26','503','2022-10-23 18:48:52',10,0),('1','147',257823,'DAILY SALES','2022-10-24','2022-10-24 06:20:47','2022-10-25 06:20:47','503',0.00,0.00,'503','2022-10-24 18:47:44','503','2022-10-24 18:48:12',10,0),('1','147',257824,'DAILY SALES','2022-10-25','2022-10-25 06:25:10','2022-10-26 06:25:10','503',0.00,0.00,'503','2022-10-25 18:43:31','503','2022-10-25 18:44:14',10,0),('1','147',257825,'DAILY SALES','2022-10-26','2022-10-26 06:54:15','2022-10-27 06:54:15','503',0.00,0.00,'503','2022-10-26 11:13:27','503','2022-10-26 11:14:54',10,0),('1','147',257826,'DAILY SALES','2022-10-26','2022-10-26 14:00:04','2022-10-27 14:00:04','503',0.00,0.00,'503','2022-10-26 18:46:55','503','2022-10-26 18:47:18',10,0),('1','147',257827,'DAILY SALES','2022-10-27','2022-10-27 06:18:07','2022-10-28 06:18:07','503',0.00,0.00,'503','2022-10-27 18:55:45','503','2022-10-27 18:56:17',10,0),('1','147',257828,'DAILY SALES','2022-10-28','2022-10-28 06:57:36','2022-10-29 06:57:36','503',0.00,0.00,'503','2022-10-28 19:00:23','503','2022-10-28 19:01:57',10,0),('1','147',257829,'DAILY SALES','2022-10-29','2022-10-29 06:51:21','2022-10-30 06:51:21','503',0.00,0.00,'503','2022-10-29 09:45:05','503','2022-10-29 09:48:08',10,0),('1','147',257830,'DAILY SALES','2022-10-29','2022-10-29 10:01:03','2022-10-30 10:01:03','503',0.00,0.00,'503','2022-10-29 18:51:13','503','2022-10-29 18:51:41',10,0),('1','147',257831,'DAILY SALES','2022-10-30','2022-10-30 06:51:35','2022-10-31 06:51:35','503',0.00,0.00,'503','2022-10-30 18:43:28','503','2022-10-30 18:43:59',10,0),('1','147',257832,'DAILY SALES','2022-10-31','2022-10-31 06:22:15','2022-11-01 06:22:15','503',0.00,0.00,'503','2022-10-31 18:44:38','503','2022-10-31 18:45:18',10,0),('1','147',257833,'DAILY SALES','2022-11-02','2022-11-02 12:12:38','2022-11-03 12:12:38','503',0.00,0.00,'503','2022-11-02 12:14:10','503','2022-11-02 12:14:28',10,0),('1','147',257834,'OPERATION LOSS','2022-11-02','2022-11-02 12:15:37','2022-11-03 12:15:37','503',0.00,0.00,'503','2022-11-02 12:19:56','503','2022-11-02 12:20:15',10,0),('1','147',257836,'DAILY SALES','2022-11-04','2022-11-04 08:21:32','2022-11-05 08:21:32','503',0.00,0.00,'503','2022-11-04 18:41:45','503','2022-11-04 18:42:23',10,0),('1','147',257837,'DAILY SALES','2022-11-05','2022-11-05 07:59:30','2022-11-06 07:59:30','503',0.00,0.00,'503','2022-11-05 18:50:52','503','2022-11-05 18:51:33',10,0),('1','147',257838,'DAILY SALES','2022-11-06','2022-11-06 07:45:09','2022-11-07 07:45:09','503',0.00,0.00,'503','2022-11-06 12:42:04','503','2022-11-06 12:42:49',10,0),('1','147',257839,'OPERTIONAL LOSS','2022-11-06','2022-11-06 12:54:07','2022-11-07 12:54:07','503',0.00,0.00,'503','2022-11-06 13:17:21','503','2022-11-06 13:17:47',10,0),('1','147',257840,'DAILY SHIFT','2022-11-06','2022-11-06 13:22:11','2022-11-07 13:22:11','503',0.00,0.00,'503','2022-11-06 18:43:15','503','2022-11-06 18:43:57',10,0),('1','147',257841,'DAILY SALES','2022-11-07','2022-11-07 06:25:09','2022-11-08 06:25:09','503',0.00,0.00,'503','2022-11-07 18:48:41','503','2022-11-07 18:49:06',10,0),('1','147',257842,'DAILY SALES','2022-11-08','2022-11-08 06:33:00','2022-11-09 06:33:00','503',0.00,0.00,'503','2022-11-08 18:55:00','503','2022-11-08 18:55:21',10,0),('1','147',257843,'DAILY SALES','2022-11-09','2022-11-09 06:12:45','2022-11-10 06:12:45','503',0.00,0.00,'503','2022-11-09 12:31:48','503','2022-11-09 12:32:30',10,0),('1','147',257844,'DAILY SALES','2022-11-09','2022-11-09 15:30:03','2022-11-10 15:30:03','503',0.00,0.00,'503','2022-11-09 18:46:49','503','2022-11-09 18:47:30',10,0),('1','147',257845,'DAILY SALES','2022-11-10','2022-11-10 06:54:59','2022-11-11 06:54:59','503',0.00,0.00,'503','2022-11-10 18:51:22','503','2022-11-10 18:51:43',10,0),('1','147',257846,'DAILY SALES','2022-11-11','2022-11-11 11:08:07','2022-11-12 11:08:07','503',0.00,0.00,'503','2022-11-11 19:14:03','503','2022-11-11 19:14:27',10,0),('1','147',257847,'new shift','2022-11-12','2022-11-12 06:44:14','2022-11-13 06:44:14','503',0.00,0.00,'503','2022-11-12 19:08:55','503','2022-11-12 19:09:16',10,0),('1','147',257848,'DAILY SALES','2022-11-13','2022-11-13 07:37:27','2022-11-14 07:37:27','503',0.00,0.00,'503','2022-11-13 18:34:36','503','2022-11-13 18:35:08',10,0),('1','147',257849,'DAILY SALES','2022-11-14','2022-11-14 06:39:10','2022-11-15 06:39:10','503',0.00,0.00,'503','2022-11-14 19:01:51','503','2022-11-14 19:02:13',10,0),('1','147',257850,'DAILY SALES','2022-11-15','2022-11-15 06:19:51','2022-11-16 06:19:51','503',0.00,0.00,'503','2022-11-15 18:31:57','503','2022-11-15 18:33:09',10,0),('1','147',257851,'DAILY SALES','2022-11-16','2022-11-16 08:03:11','2022-11-17 08:03:11','503',0.00,0.00,'503','2022-11-16 18:39:54','503','2022-11-16 18:40:29',10,0),('1','147',257852,'DAILY SALES','2022-11-17','2022-11-17 06:27:28','2022-11-18 06:27:28','503',0.00,0.00,'503','2022-11-17 18:39:44','503','2022-11-17 18:40:40',10,0),('1','147',257853,'DAILY SALES','2022-11-18','2022-11-18 06:34:19','2022-11-19 06:34:19','503',0.00,0.00,'503','2022-11-18 18:48:49','503','2022-11-18 18:49:19',10,0),('1','147',257854,'DAILY SALES','2022-11-19','2022-11-19 06:27:01','2022-11-20 06:27:01','503',0.00,0.00,'503','2022-11-19 08:18:55','503','2022-11-19 08:19:18',10,0),('1','147',257855,'DAILY SALES','2022-11-19','2022-11-19 08:44:11','2022-11-20 08:44:11','503',0.00,0.00,'503','2022-11-19 18:48:37','503','2022-11-19 18:49:23',10,0),('1','147',257856,'DAILY SALES','2022-11-20','2022-11-20 06:28:57','2022-11-21 06:28:57','503',0.00,0.00,'503','2022-11-20 18:36:00','503','2022-11-20 18:36:47',10,0),('1','147',257857,'new shift','2022-11-21','2022-11-21 06:48:24','2022-11-22 06:48:24','503',0.00,0.00,'503','2022-11-21 15:59:06','503','2022-11-21 15:59:35',10,0),('1','147',257858,'new shift','2022-11-21','2022-11-21 16:17:10','2022-11-22 16:17:10','503',0.00,0.00,'503','2022-11-21 18:41:05','503','2022-11-21 18:41:33',10,0),('1','147',257859,'new shift','2022-11-22','2022-11-22 06:50:17','2022-11-23 06:50:17','503',0.00,0.00,'503','2022-11-22 19:13:12','503','2022-11-22 19:13:49',10,0),('1','147',257860,'new shift','2022-11-23','2022-11-23 06:34:29','2022-11-24 06:34:29','503',0.00,0.00,'503','2022-11-23 19:33:00','503','2022-11-23 19:33:41',10,0),('1','147',257861,'new shift','2022-11-24','2022-11-24 06:38:08','2022-11-25 06:38:08','503',0.00,0.00,'503','2022-11-24 15:41:56','503','2022-11-24 15:42:26',10,0),('1','147',257862,'DAILY SALES','2022-11-24','2022-11-24 16:01:24','2022-11-25 16:01:24','503',0.00,0.00,'503','2022-11-24 18:43:31','503','2022-11-24 18:43:55',10,0),('1','147',257863,'new shift','2022-11-25','2022-11-25 06:32:31','2022-11-26 06:32:31','503',0.00,0.00,'503','2022-11-25 18:39:19','503','2022-11-25 18:40:00',10,0),('1','147',257864,'new shift','2022-11-26','2022-11-26 06:33:31','2022-11-27 06:33:31','503',0.00,0.00,'503','2022-11-26 18:57:45','503','2022-11-26 18:58:29',10,0),('1','147',257865,'DAILY SALES','2022-11-27','2022-11-27 06:17:48','2022-11-28 06:17:48','503',0.00,0.00,'503','2022-11-27 10:46:36','503','2022-11-27 10:47:37',10,0),('1','147',257866,'DAILY SALES','2022-11-27','2022-11-27 10:59:45','2022-11-28 10:59:45','503',0.00,0.00,'503','2022-11-27 18:42:47','503','2022-11-27 18:43:30',10,0),('1','147',257867,'DAILY SALES','2022-11-28','2022-11-28 06:21:00','2022-11-29 06:21:00','503',0.00,0.00,'503','2022-11-28 18:38:41','503','2022-11-28 18:39:03',10,0),('1','147',257868,'DAILY SALES','2022-11-29','2022-11-29 06:27:13','2022-11-30 06:27:13','503',0.00,0.00,'503','2022-11-29 18:40:12','503','2022-11-29 18:40:52',10,0),('1','147',257869,'DAILY SALES','2022-11-30','2022-11-30 06:31:09','2022-12-01 06:31:09','503',0.00,0.00,'503','2022-11-30 10:02:50','503','2022-11-30 10:03:30',10,0),('1','147',257870,'DAILY SALES','2022-11-30','2022-11-30 13:01:44','2022-12-01 13:01:44','503',0.00,0.00,'503','2022-11-30 18:37:04','503','2022-11-30 18:37:38',10,0),('1','147',257871,'DAILY SALES','2022-12-01','2022-12-01 06:24:14','2022-12-02 06:24:14','503',0.00,0.00,'503','2022-12-01 18:42:20','503','2022-12-01 18:42:47',10,0),('1','147',257872,'new shift','2022-12-02','2022-12-02 06:41:50','2022-12-03 06:41:50','503',0.00,0.00,'503','2022-12-02 18:45:41','503','2022-12-02 18:46:20',10,0),('1','147',257873,'DAILY SALES','2022-12-03','2022-12-03 06:37:19','2022-12-04 06:37:19','503',0.00,0.00,'503','2022-12-03 08:27:20','503','2022-12-03 08:27:58',10,0),('1','147',257874,'DAILY SALES','2022-12-03','2022-12-03 08:48:29','2022-12-04 08:48:29','503',0.00,0.00,'503','2022-12-03 18:41:22','503','2022-12-03 18:42:31',10,0),('1','147',257875,'new shift','2022-12-04','2022-12-04 06:40:52','2022-12-05 06:40:52','503',0.00,0.00,'503','2022-12-04 18:42:05','503','2022-12-04 18:42:59',10,0),('1','147',257876,'new shift','2022-12-05','2022-12-05 06:47:27','2022-12-06 06:47:27','503',0.00,0.00,'503','2022-12-05 12:05:05','503','2022-12-05 12:05:30',10,0),('1','147',257877,'DALIY SHIFT','2022-12-05','2022-12-05 12:09:50','2022-12-06 12:09:50','503',0.00,0.00,'503','2022-12-05 18:55:49','503','2022-12-05 18:56:40',10,0),('1','147',257878,'new shift','2022-12-06','2022-12-06 06:38:43','2022-12-07 06:38:43','503',0.00,0.00,'503','2022-12-06 18:51:45','503','2022-12-06 18:53:30',10,0),('1','147',257879,'new shift','2022-12-07','2022-12-07 06:48:37','2022-12-08 06:48:37','503',0.00,0.00,'503','2022-12-07 18:42:51','503','2022-12-07 18:43:23',10,0),('1','147',257880,'new shift','2022-12-08','2022-12-08 06:45:43','2022-12-09 06:45:43','503',0.00,0.00,'503','2022-12-08 14:11:19','503','2022-12-08 14:11:39',10,0),('1','147',257881,'DAILY SALES','2022-12-08','2022-12-08 14:42:29','2022-12-09 14:42:29','503',0.00,0.00,'503','2022-12-08 18:42:34','503','2022-12-08 18:42:59',10,0),('1','147',257882,'new shift','2022-12-09','2022-12-09 06:41:15','2022-12-10 06:41:15','503',0.00,0.00,'503','2022-12-09 19:14:03','503','2022-12-09 19:14:24',10,0),('1','147',257883,'new shift','2022-12-10','2022-12-10 06:54:22','2022-12-11 06:54:22','503',0.00,0.00,'503','2022-12-10 19:11:57','503','2022-12-10 19:12:22',10,0),('1','147',257884,'new shift','2022-12-11','2022-12-11 06:38:27','2022-12-12 06:38:27','503',0.00,0.00,'503','2022-12-11 09:45:50','503','2022-12-11 09:46:15',10,0),('1','147',257885,'DAILY SALES','2022-12-11','2022-12-11 10:09:06','2022-12-12 10:09:06','503',0.00,0.00,'503','2022-12-11 18:51:06','503','2022-12-11 18:51:29',10,0),('1','147',257886,'new shift','2022-12-12','2022-12-12 06:46:56','2022-12-13 06:46:56','503',0.00,0.00,'503','2022-12-12 18:58:15','503','2022-12-12 18:58:39',10,0),('1','147',257887,'DAILY SALES','2022-12-13','2022-12-13 06:26:02','2022-12-14 06:26:02','503',0.00,0.00,'503','2022-12-13 18:57:17','503','2022-12-13 18:58:01',10,0),('1','147',257888,'DAILY SALES','2022-12-14','2022-12-14 06:51:22','2022-12-15 06:51:22','503',0.00,0.00,'503','2022-12-14 07:32:55','503','2022-12-14 07:33:12',10,0),('1','147',257889,'DAILY SALES','2022-12-14','2022-12-14 08:00:51','2022-12-15 08:00:51','503',0.00,0.00,'503','2022-12-14 19:29:01','503','2022-12-14 19:29:30',10,0),('1','147',257890,'DAILY SALES','2022-12-15','2022-12-15 06:32:26','2022-12-16 06:32:26','503',0.00,0.00,'503','2022-12-15 18:48:01','503','2022-12-15 18:48:30',10,0),('1','147',257891,'DAILY SALES','2022-12-16','2022-12-16 06:41:06','2022-12-17 06:41:06','503',0.00,0.00,'503','2022-12-16 18:48:06','503','2022-12-16 18:48:54',10,0),('1','147',257892,'DAILY SALES','2022-12-17','2022-12-17 06:38:11','2022-12-18 06:38:11','503',0.00,0.00,'503','2022-12-17 08:21:53','503','2022-12-17 08:22:18',10,0),('1','147',257893,'DAILY SALES','2022-12-17','2022-12-17 08:31:21','2022-12-18 08:31:21','503',0.00,0.00,'503','2022-12-17 19:03:19','503','2022-12-17 19:03:55',10,0),('1','147',257894,'new shift','2022-12-18','2022-12-18 06:37:24','2022-12-19 06:37:24','503',0.00,0.00,'503','2022-12-18 18:53:58','503','2022-12-18 18:54:58',10,0),('1','147',257895,'new shift','2022-12-19','2022-12-19 06:55:24','2022-12-20 06:55:24','503',0.00,0.00,'503','2022-12-19 09:02:48','503','2022-12-19 09:03:13',10,0),('1','147',257896,'DALIY SHIFT','2022-12-19','2022-12-19 09:07:38','2022-12-20 09:07:38','503',0.00,0.00,'503','2022-12-19 18:59:58','503','2022-12-19 19:00:38',10,0),('1','147',257897,'new shift','2022-12-20','2022-12-20 06:53:00','2022-12-21 06:53:00','503',0.00,0.00,'503','2022-12-20 18:57:58','503','2022-12-20 18:59:00',10,0),('1','147',257898,'new shift','2022-12-21','2022-12-21 06:46:16','2022-12-22 06:46:16','503',0.00,0.00,'503','2022-12-21 14:51:22','503','2022-12-21 14:51:47',10,0),('1','147',257899,'DAILY SALES','2022-12-21','2022-12-21 15:03:09','2022-12-22 15:03:09','503',0.00,0.00,'503','2022-12-21 18:53:43','503','2022-12-21 18:54:12',10,0),('1','147',257900,'new shift','2022-12-22','2022-12-22 06:57:05','2022-12-23 06:57:05','503',0.00,0.00,'503','2022-12-22 18:53:08','503','2022-12-22 18:53:37',10,0),('1','147',257901,'new shift','2022-12-23','2022-12-23 06:54:53','2022-12-24 06:54:53','503',0.00,0.00,'503','2022-12-23 17:36:06','503','2022-12-23 17:36:29',10,0),('1','147',257902,'new shift','2022-12-24','2022-12-24 06:55:35','2022-12-25 06:55:35','503',0.00,0.00,'503','2022-12-24 19:29:31','503','2022-12-24 19:30:39',10,0),('1','147',257903,'DAILY SALES','2022-12-25','2022-12-25 06:36:35','2022-12-26 06:36:35','503',0.00,0.00,'503','2022-12-25 11:36:03','503','2022-12-25 11:36:36',10,0),('1','147',257904,'DAILY SALES','2022-12-25','2022-12-25 11:51:57','2022-12-25 21:51:57','503',0.00,0.00,'503','2022-12-25 18:56:10','503','2022-12-25 18:56:31',10,0),('1','147',257905,'DAILY SALES','2022-12-26','2022-12-26 06:41:38','2022-12-27 06:41:38','503',0.00,0.00,'503','2022-12-26 19:17:35','503','2022-12-26 19:18:20',10,0),('1','147',257906,'DAILY SALES','2022-12-27','2022-12-27 06:43:29','2022-12-28 06:43:29','503',0.00,0.00,'503','2022-12-27 19:39:41','503','2022-12-27 19:40:19',10,0),('1','147',257907,'DAILY SALES','2022-12-28','2022-12-28 06:37:52','2022-12-29 06:37:52','503',0.00,0.00,'503','2022-12-28 13:58:35','503','2022-12-28 13:59:00',10,0),('1','147',257908,'DAILY SALES','2022-12-28','2022-12-28 14:41:24','2022-12-29 14:41:24','503',0.00,0.00,'503','2022-12-28 18:52:57','503','2022-12-28 18:53:26',10,0),('1','147',257909,'DAILY SALES','2022-12-29','2022-12-29 06:41:27','2022-12-30 06:41:27','503',0.00,0.00,'503','2022-12-29 18:57:22','503','2022-12-29 18:58:32',10,0),('1','147',257910,'new shift','2022-12-30','2022-12-30 07:02:18','2022-12-31 07:02:18','503',0.00,0.00,'503','2022-12-30 18:59:53','503','2022-12-30 19:00:19',10,0),('1','147',257911,'new shift','2022-12-31','2022-12-31 07:06:06','2023-01-01 07:06:06','503',0.00,0.00,'503','2022-12-31 15:04:31','503','2022-12-31 15:05:01',10,0),('1','147',257912,'DAILY SALES','2022-12-31','2022-12-31 15:28:32','2023-01-01 15:28:32','503',0.00,0.00,'503','2022-12-31 19:03:21','503','2022-12-31 19:04:18',10,0),('1','147',257913,'new shift','2023-01-01','2023-01-01 06:48:42','2023-01-02 06:48:42','503',0.00,0.00,'503','2023-01-01 19:00:47','503','2023-01-01 19:01:25',10,0),('1','147',257914,'new shift','2023-01-02','2023-01-02 06:55:23','2023-01-03 06:55:23','503',0.00,0.00,'503','2023-01-02 19:05:58','503','2023-01-02 19:06:26',10,0),('1','147',257915,'new shift','2023-01-03','2023-01-03 07:23:50','2023-01-04 07:23:50','503',0.00,0.00,'503','2023-01-03 15:55:10','503','2023-01-03 15:55:46',10,0),('1','147',257916,'DAILY SALES','2023-01-03','2023-01-03 16:12:41','2023-01-04 16:12:41','503',0.00,0.00,'503','2023-01-03 18:57:53','503','2023-01-03 18:58:16',10,0),('1','147',257917,'DAILY SALES','2023-01-04','2023-01-04 06:39:32','2023-01-05 06:39:32','503',0.00,0.00,'503','2023-01-04 19:01:22','503','2023-01-04 19:02:10',10,0),('1','147',257918,'DAILY SHIFT','2023-01-05','2023-01-05 06:29:42','2023-01-06 06:29:42','503',0.00,0.00,'503','2023-01-05 19:06:24','503','2023-01-05 19:06:49',10,0),('1','147',257919,'DAILY SALES','2023-01-06','2023-01-06 06:50:36','2023-01-07 06:50:36','503',0.00,0.00,'503','2023-01-06 17:30:15','503','2023-01-06 17:30:52',10,0),('1','147',257920,'DAILY SALES','2023-01-07','2023-01-07 06:33:57','2023-01-08 06:33:57','503',0.00,0.00,'503','2023-01-07 19:07:49','503','2023-01-07 19:08:16',10,0),('1','147',257921,'DAILY SHIFT ','2023-01-08','2023-01-08 06:22:46','2023-01-09 06:22:46','503',0.00,0.00,'503','2023-01-08 19:02:01','503','2023-01-08 19:02:24',10,0),('1','147',257922,'DAILY SALES','2023-01-09','2023-01-09 06:53:12','2023-01-10 06:53:12','503',0.00,0.00,'503','2023-01-09 16:17:47','503','2023-01-09 16:19:04',10,0),('1','147',257923,'DAILY SALES','2023-01-09','2023-01-09 16:23:41','2023-01-10 16:23:41','503',0.00,0.00,'503','2023-01-09 19:06:15','503','2023-01-09 19:06:36',10,0),('1','147',257924,'DAILY SALES','2023-01-10','2023-01-10 07:12:09','2023-01-11 07:12:09','503',0.00,0.00,'503','2023-01-10 19:05:43','503','2023-01-10 19:06:07',10,0),('1','147',257925,'DAILY SALES','2023-01-11','2023-01-11 07:02:41','2023-01-12 07:02:41','503',0.00,0.00,'503','2023-01-11 19:30:29','503','2023-01-11 19:31:26',10,0),('1','147',257926,'NEW SHIFT ','2023-01-12','2023-01-12 06:25:15','2023-01-13 06:25:15','503',0.00,0.00,'503','2023-01-12 11:50:57','503','2023-01-12 11:51:23',10,0),('1','147',257927,'DAILY SALES','2023-01-12','2023-01-12 12:17:16','2023-01-13 12:17:16','503',0.00,0.00,'503','2023-01-12 19:30:35','503','2023-01-12 19:31:00',10,0),('1','147',257928,'DAILY SALES','2023-01-13','2023-01-13 06:50:13','2023-01-14 06:50:13','503',0.00,0.00,'503','2023-01-13 19:22:21','503','2023-01-13 19:22:52',10,0),('1','147',257929,'DAILY SALES','2023-01-14','2023-01-14 06:40:23','2023-01-15 06:40:23','503',0.00,0.00,'503','2023-01-14 18:01:16','503','2023-01-14 18:02:09',10,0),('1','147',257930,'OPERATION LOSS','2023-01-14','2023-01-14 18:13:15','2023-01-15 18:13:15','503',0.00,0.00,'503','2023-01-14 18:19:47','503','2023-01-14 18:20:08',10,0),('1','147',257931,'DAILY SALES','2023-01-15','2023-01-15 07:27:53','2023-01-16 07:27:53','503',0.00,0.00,'503','2023-01-15 19:17:39','503','2023-01-15 19:18:36',10,0),('1','147',257932,'DAILY SALES','2023-01-16','2023-01-16 06:47:32','2023-01-17 06:47:32','503',0.00,0.00,'503','2023-01-16 18:54:59','503','2023-01-16 18:55:26',10,0),('1','147',257933,'DAILY SALES','2023-01-17','2023-01-17 06:45:16','2023-01-18 06:45:16','503',0.00,0.00,'503','2023-01-17 10:27:02','503','2023-01-17 10:27:23',10,0),('1','147',257934,'DAILY SALES','2023-01-17','2023-01-17 10:41:54','2023-01-18 10:41:54','503',0.00,0.00,'503','2023-01-17 19:03:04','503','2023-01-17 19:03:30',10,0),('1','147',257935,'DAILY SALES','2023-01-18','2023-01-18 06:48:35','2023-01-19 06:48:35','503',0.00,0.00,'503','2023-01-18 18:57:18','503','2023-01-18 18:57:47',10,0),('1','147',257936,'DAILY SALES','2023-01-19','2023-01-19 07:07:12','2023-01-20 07:07:12','503',0.00,0.00,'503','2023-01-19 18:11:02','503','2023-01-19 18:12:09',10,0),('1','147',257937,'OPERATION LOSS','2023-01-19','2023-01-19 18:17:03','2023-01-20 18:17:03','503',0.00,0.00,'503','2023-01-19 19:09:11','503','2023-01-19 19:09:33',10,0),('1','147',257938,'DAILY SALES','2023-01-20','2023-01-20 06:55:46','2023-01-21 06:55:46','503',0.00,0.00,'503','2023-01-20 19:04:46','503','2023-01-20 19:05:43',10,0),('1','147',257939,'DAILY SALES','2023-01-21','2023-01-21 06:53:12','2023-01-22 06:53:12','503',0.00,0.00,'503','2023-01-21 19:28:36','503','2023-01-21 19:29:03',10,0),('1','147',257940,'DAILY SALES','2023-01-22','2023-01-22 06:59:17','2023-01-23 06:59:17','503',0.00,0.00,'503','2023-01-22 12:44:53','503','2023-01-22 12:45:15',10,0),('1','147',257941,'DAILY SALES','2023-01-22','2023-01-22 14:26:17','2023-01-23 14:26:17','503',0.00,0.00,'503','2023-01-22 19:16:18','503','2023-01-22 19:16:42',10,0),('1','147',257942,'DAILY SALES','2023-01-23','2023-01-23 06:55:47','2023-01-24 06:55:47','503',0.00,0.00,'503','2023-01-23 20:03:28','503','2023-01-23 20:03:54',10,0),('1','147',257943,'DAILY SALES','2023-01-24','2023-01-24 07:01:26','2023-01-25 07:01:26','503',0.00,0.00,'503','2023-01-24 19:25:28','503','2023-01-24 19:25:54',10,0),('1','147',257944,'DAILY SALES','2023-01-25','2023-01-25 06:51:54','2023-01-26 06:51:54','503',0.00,0.00,'503','2023-01-25 12:58:33','503','2023-01-25 12:58:52',10,0),('1','147',257945,'DAILY SALES','2023-01-25','2023-01-25 14:37:52','2023-01-26 14:37:52','503',0.00,0.00,'503','2023-01-25 19:44:14','503','2023-01-25 19:45:54',10,0),('1','147',257946,'DAILY SHIFT ','2023-01-26','2023-01-26 06:33:22','2023-01-27 06:33:22','503',0.00,0.00,'503','2023-01-26 19:10:51','503','2023-01-26 19:11:20',10,0),('1','147',257947,'DAILY SALES','2023-01-27','2023-01-27 06:55:37','2023-01-28 06:55:37','503',0.00,0.00,'503','2023-01-27 19:36:51','503','2023-01-27 19:37:27',10,0),('1','147',257948,'new shift','2023-01-28','2023-01-28 06:55:58','2023-01-29 06:55:58','503',0.00,0.00,'503','2023-01-28 11:47:12','503','2023-01-28 11:47:34',10,0),('1','147',257949,'DALIY SHIFT','2023-01-28','2023-01-28 11:51:31','2023-01-29 11:51:31','503',0.00,0.00,'503','2023-01-28 19:24:09','503','2023-01-28 19:29:29',10,0),('1','147',257950,'DAILY SALES','2023-01-29','2023-01-29 06:58:11','2023-01-30 06:58:11','503',0.00,0.00,'503','2023-01-29 19:18:27','503','2023-01-29 19:18:53',10,0),('1','147',257951,'new shift','2023-01-30','2023-01-30 07:00:31','2023-01-31 07:00:31','503',0.00,0.00,'503','2023-01-30 19:27:28','503','2023-01-30 19:27:56',10,0),('1','147',257952,'new shift','2023-01-31','2023-01-31 06:51:35','2023-02-01 06:51:35','503',0.00,0.00,'503','2023-01-31 11:11:02','503','2023-01-31 11:11:21',10,0),('1','147',257953,'DAILY SALES','2023-01-31','2023-01-31 11:20:49','2023-02-01 11:20:49','503',0.00,0.00,'503','2023-01-31 19:38:05','503','2023-01-31 19:38:49',10,0),('1','147',257954,'DAILY SHIFT ','2023-02-01','2023-02-01 06:42:03','2023-02-02 06:42:03','503',0.00,0.00,'503','2023-02-01 19:56:17','503','2023-02-01 19:56:57',10,0),('1','147',257955,'DAILY SALES','2023-02-02','2023-02-02 06:44:26','2023-02-03 06:44:26','503',0.00,0.00,'503','2023-02-02 19:16:54','503','2023-02-02 19:17:34',10,0),('1','147',257956,'DAILY SALES','2023-02-03','2023-02-03 06:54:24','2023-02-04 06:54:24','503',0.00,0.00,'503','2023-02-03 18:16:09','503','2023-02-03 18:16:59',10,0),('1','147',257957,'OPERATION LOSS','2023-02-03','2023-02-03 19:14:44','2023-02-04 19:14:44','503',0.00,0.00,'503','2023-02-03 19:23:16','503','2023-02-03 19:24:13',10,0),('1','147',257958,'DAILY SALES','2023-02-04','2023-02-04 06:51:20','2023-02-05 06:51:20','503',0.00,0.00,'503','2023-02-04 19:50:34','503','2023-02-04 19:51:42',10,0),('1','147',257959,'DAILY SALES','2023-02-05','2023-02-05 06:55:03','2023-02-06 06:55:03','503',0.00,0.00,'503','2023-02-05 19:10:50','503','2023-02-05 19:11:28',10,0),('1','147',257960,'DAILY SALES','2023-02-06','2023-02-06 07:01:08','2023-02-07 07:01:08','503',0.00,0.00,'503','2023-02-06 19:20:38','503','2023-02-06 19:22:14',10,0),('1','147',257961,'DAILY SALES','2023-02-07','2023-02-07 11:01:36','2023-02-08 11:01:36','503',0.00,0.00,'503','2023-02-07 20:10:20','503','2023-02-07 20:11:07',10,0),('1','147',257962,'new shift','2023-02-08','2023-02-08 06:58:35','2023-02-09 06:58:35','503',0.00,0.00,'503','2023-02-08 20:03:27','503','2023-02-08 20:05:06',10,0),('1','147',257963,'new shift','2023-02-09','2023-02-09 07:04:57','2023-02-10 07:04:57','503',0.00,0.00,'503','2023-02-09 20:15:41','503','2023-02-09 20:16:14',10,0),('1','147',257964,'new shift','2023-02-10','2023-02-10 07:05:40','2023-02-11 07:05:40','503',0.00,0.00,'503','2023-02-10 21:01:07','503','2023-02-10 21:01:35',10,0),('1','147',257965,'new shift','2023-02-11','2023-02-11 07:08:48','2023-02-12 07:08:48','503',0.00,0.00,'503','2023-02-11 19:58:25','503','2023-02-11 19:59:08',10,0),('1','147',257966,'new shift','2023-02-12','2023-02-12 06:59:56','2023-02-13 06:59:56','503',0.00,0.00,'503','2023-02-12 14:13:03','503','2023-02-12 14:13:25',10,0),('1','147',257967,'DAILY SALES','2023-02-12','2023-02-12 14:26:10','2023-02-13 14:26:10','503',0.00,0.00,'503','2023-02-12 19:19:33','503','2023-02-12 19:20:01',10,0),('1','147',257968,'DAILY SALES','2023-02-13','2023-02-13 06:35:51','2023-02-14 06:35:51','503',0.00,0.00,'503','2023-02-13 19:21:56','503','2023-02-13 19:22:40',10,0),('1','147',257969,'DAILY SALES','2023-02-14','2023-02-14 06:35:29','2023-02-15 06:35:29','503',0.00,0.00,'503','2023-02-14 20:42:37','503','2023-02-14 20:43:00',10,0),('1','147',257970,'DAILY SALES','2023-02-15','2023-02-15 09:56:13','2023-02-16 09:56:13','503',0.00,0.00,'503','2023-02-15 19:13:21','503','2023-02-15 19:14:16',10,0),('1','147',257971,'DAILY SALES','2023-02-16','2023-02-16 06:29:55','2023-02-17 06:29:55','503',0.00,0.00,'503','2023-02-16 19:44:11','503','2023-02-16 19:45:03',10,0),('1','147',257972,'DAILY SALES','2023-02-17','2023-02-17 07:10:34','2023-02-18 07:10:34','503',0.00,0.00,'503','2023-02-17 19:35:22','503','2023-02-17 19:36:09',10,0),('1','147',257973,'DAILY SALES','2023-02-18','2023-02-18 07:05:57','2023-02-19 07:05:57','503',0.00,0.00,'503','2023-02-18 19:33:54','503','2023-02-18 19:34:17',10,0),('1','147',257974,'DAILY SALES','2023-02-19','2023-02-19 06:57:37','2023-02-20 06:57:37','503',0.00,0.00,'503','2023-02-19 16:59:19','503','2023-02-19 16:59:53',10,0),('1','147',257975,'DAILY SALES','2023-02-19','2023-02-19 17:09:13','2023-02-20 17:09:13','503',0.00,0.00,'503','2023-02-19 19:47:41','503','2023-02-19 19:48:04',10,0),('1','147',257976,'DAILY SALES','2023-02-20','2023-02-20 06:57:42','2023-02-21 06:57:42','503',0.00,0.00,'503','2023-02-20 19:48:13','503','2023-02-20 19:48:44',10,0),('1','147',257977,'DAILY SALES','2023-02-21','2023-02-21 07:09:31','2023-02-22 07:09:31','503',0.00,0.00,'503','2023-02-21 19:26:45','503','2023-02-21 19:27:22',10,0),('1','147',257978,'DAILY SALES','2023-02-22','2023-02-22 06:31:30','2023-02-23 06:31:30','503',0.00,0.00,'503','2023-02-22 20:08:31','503','2023-02-22 20:08:59',10,0),('1','147',257979,'DALIY SHIFT','2023-02-23','2023-02-23 07:45:51','2023-02-24 07:45:51','503',0.00,0.00,'503','2023-02-23 19:00:10','503','2023-02-23 19:01:01',10,0),('1','147',257980,'new shift','2023-02-24','2023-02-24 06:55:11','2023-02-25 06:55:11','503',0.00,0.00,'503','2023-02-24 22:08:55','503','2023-02-24 22:09:33',10,0),('1','147',257981,'DALIY SHIFT','2023-02-26','2023-02-26 07:36:17','2023-02-27 07:36:17','503',0.00,0.00,'503','2023-02-26 18:53:36','503','2023-02-26 18:54:06',10,0),('1','147',257982,'DALIY SHIFT','2023-02-27','2023-02-27 06:37:40','2023-02-28 06:37:40','503',0.00,0.00,'503','2023-02-27 10:03:36','503','2023-02-27 10:05:40',10,0),('1','147',257983,'DAILY SALES','2023-02-27','2023-02-27 10:06:05','2023-02-28 10:06:05','503',0.00,0.00,'503','2023-02-27 20:46:51','503','2023-02-27 20:47:16',10,0),('1','147',257984,'new shift','2023-02-28','2023-02-28 08:43:41','2023-03-01 08:43:41','503',0.00,0.00,'503','2023-02-28 19:07:17','503','2023-02-28 19:07:43',10,0),('1','147',257985,'new shift','2023-03-01','2023-03-01 07:15:28','2023-03-02 07:15:28','503',0.00,0.00,'503','2023-03-01 19:21:22','503','2023-03-01 19:21:49',10,0),('1','147',257986,'new shift','2023-03-02','2023-03-02 07:03:48','2023-03-03 07:03:48','503',0.00,0.00,'503','2023-03-02 19:24:10','503','2023-03-02 19:24:42',10,0),('1','147',257987,'new shift','2023-03-03','2023-03-03 06:55:27','2023-03-04 06:55:27','503',0.00,0.00,'503','2023-03-03 09:32:17','503','2023-03-03 09:32:43',10,0),('1','147',257988,'DAILY SALES','2023-03-03','2023-03-03 09:58:49','2023-03-04 09:58:49','503',0.00,0.00,'503','2023-03-03 19:33:30','503','2023-03-03 19:33:56',10,0),('1','147',257989,'new shift','2023-03-04','2023-03-04 07:10:02','2023-03-05 07:10:02','503',0.00,0.00,'503','2023-03-04 19:37:18','503','2023-03-04 19:38:12',10,0),('1','147',257990,'new shift','2023-03-05','2023-03-05 07:03:06','2023-03-06 07:03:06','503',0.00,0.00,'503','2023-03-05 19:34:21','503','2023-03-05 19:34:44',10,0),('1','147',257991,'DAILY SALES','2023-03-06','2023-03-06 06:57:52','2023-03-07 06:57:52','503',0.00,0.00,'503','2023-03-06 13:40:08','503','2023-03-06 13:40:28',10,0),('1','147',257992,'DAILY SALES','2023-03-06','2023-03-06 14:17:12','2023-03-07 14:17:12','503',0.00,0.00,'503','2023-03-06 19:54:37','503','2023-03-06 19:55:47',10,0),('1','147',257993,'DAILY SALES','2023-03-07','2023-03-07 06:36:33','2023-03-08 06:36:33','503',0.00,0.00,'503','2023-03-07 19:22:54','503','2023-03-07 19:23:44',10,0),('1','147',257994,'DAILY SALES','2023-03-08','2023-03-08 06:29:36','2023-03-09 06:29:36','503',0.00,0.00,'503','2023-03-08 19:18:44','503','2023-03-08 19:19:18',10,0),('1','147',257995,'DAILY SALES','2023-03-09','2023-03-09 06:34:35','2023-03-10 06:34:35','503',0.00,0.00,'503','2023-03-09 17:20:49','503','2023-03-09 17:22:05',10,0),('1','147',257996,'DAILY SALES','2023-03-10','2023-03-10 06:30:49','2023-03-11 06:30:49','503',0.00,0.00,'503','2023-03-10 19:10:52','503','2023-03-10 19:11:19',10,0),('1','147',257997,'new shift','2023-03-11','2023-03-11 06:57:46','2023-03-12 06:57:46','503',0.00,0.00,'503','2023-03-11 20:09:24','503','2023-03-11 20:10:28',10,0),('1','147',257998,'DAILY SALES','2023-03-12','2023-03-12 15:48:31','2023-03-13 15:48:31','503',0.00,0.00,'503','2023-03-12 15:52:36','503','2023-03-12 15:52:59',10,0),('1','147',257999,'DAILY SALES','2023-03-12','2023-03-12 15:54:27','2023-03-13 15:54:27','503',0.00,0.00,'503','2023-03-12 19:37:17','503','2023-03-12 19:37:39',10,0),('1','147',258000,'new shift','2023-03-13','2023-03-13 06:54:23','2023-03-14 06:54:23','503',0.00,0.00,'503','2023-03-13 19:26:48','503','2023-03-13 19:28:32',10,0),('1','147',258001,'new shift','2023-03-14','2023-03-14 06:58:15','2023-03-15 06:58:15','503',0.00,0.00,'503','2023-03-14 19:33:12','503','2023-03-14 19:33:54',10,0),('1','147',258002,'new shift','2023-03-15','2023-03-15 06:55:31','2023-03-16 06:55:31','503',0.00,0.00,'503','2023-03-15 20:24:41','503','2023-03-15 20:25:19',10,0),('1','147',258003,'new shift','2023-03-16','2023-03-16 06:52:05','2023-03-17 06:52:05','503',0.00,0.00,'503','2023-03-16 19:17:11','503','2023-03-16 19:17:33',10,0),('1','147',258004,'DAILY SALES','2023-03-17','2023-03-17 07:01:34','2023-03-18 07:01:34','503',0.00,0.00,'503','2023-03-17 19:25:31','503','2023-03-17 19:25:53',10,0),('1','147',258005,'DAILY SALES','2023-03-19','2023-03-19 06:22:59','2023-03-20 06:22:59','503',0.00,0.00,'503','2023-03-19 13:52:00','503','2023-03-19 13:52:35',10,0),('1','147',258006,'DAILY SALES','2023-03-19','2023-03-19 13:59:30','2023-03-20 13:59:30','503',0.00,0.00,'503','2023-03-19 19:40:33','503','2023-03-19 19:40:53',10,0),('1','147',258007,'DAILY SALES','2023-03-20','2023-03-20 06:26:38','2023-03-21 06:26:38','503',0.00,0.00,'503','2023-03-20 19:24:52','503','2023-03-20 19:25:20',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4904609 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','147','768','146994',2940315,'2139','326',0.00,378.57,0.00,0.00,378.57,105999.60,0.00,0.00,0.00),('1','147','768','147001',2940417,'2139','326',378.57,2507.14,0.00,0.00,2128.57,595999.60,0.00,0.00,0.00),('1','147','768','147011',2940547,'2139','326',2507.14,4478.14,0.00,0.00,1971.00,551880.00,0.00,0.00,0.00),('1','147','768','147028',2940776,'2139','326',4478.14,4478.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','147033',2940832,'2139','326',4478.14,5349.92,0.00,0.00,871.78,244098.40,0.00,0.00,0.00),('1','147','768','147038',2940860,'2139','326',5349.92,8047.42,0.00,0.00,2697.50,755300.00,0.00,0.00,0.00),('1','147','768','147045',2940988,'2139','326',8047.42,10078.42,0.00,0.00,2031.00,568680.00,0.00,0.00,0.00),('1','147','768','147074',2941520,'2139','326',10078.42,11739.13,0.00,0.00,1660.71,464998.80,0.00,0.00,0.00),('1','147','768','147082',2941571,'2139','326',11739.13,13496.27,0.00,0.00,1757.14,491999.20,0.00,0.00,0.00),('1','147','768','147154',2942366,'2139','326',13496.27,15086.27,0.00,0.00,1590.00,445200.00,0.00,0.00,0.00),('1','147','768','147192',2942742,'2139','326',15086.27,15234.27,0.00,0.00,148.00,41440.00,0.00,0.00,0.00),('1','147','768','147300',2944165,'2139','326',15234.27,16352.84,0.00,0.00,1118.57,313199.60,0.00,0.00,0.00),('1','147','768','147424',2946494,'2139','326',16352.84,17993.09,0.00,0.00,1640.25,459270.00,0.00,0.00,0.00),('1','147','768','147552',2948858,'2139','326',17993.09,20228.80,0.00,0.00,2235.71,625998.80,0.00,0.00,0.00),('1','147','768','147671',2950901,'2139','326',20228.80,20687.80,0.00,0.00,459.00,128520.00,0.00,0.00,0.00),('1','147','768','147853',2954037,'2139','326',20687.80,22726.72,0.00,0.00,2038.92,570897.60,0.00,0.00,0.00),('1','147','768','147982',2956279,'2139','326',22726.72,24286.00,0.00,0.00,1559.28,436598.40,0.00,0.00,0.00),('1','147','768','148115',2958567,'2139','326',24286.00,25773.67,0.00,0.00,1487.67,416547.60,0.00,0.00,0.00),('1','147','768','148262',2961188,'2139','326',25773.67,26453.67,0.00,0.00,680.00,190400.00,0.00,0.00,0.00),('1','147','768','148415',2963760,'2139','326',26453.67,28873.13,0.00,0.00,2419.46,677448.80,0.00,0.00,0.00),('1','147','768','148544',2966006,'2139','326',28873.13,31375.13,0.00,0.00,2502.00,700560.00,0.00,0.00,0.00),('1','147','768','148655',2967879,'2139','326',31375.13,32430.48,0.00,0.00,1055.35,295498.00,0.00,0.00,0.00),('1','147','768','148802',2970138,'2139','326',32430.48,33890.83,0.00,0.00,1460.35,408898.00,0.00,0.00,0.00),('1','147','768','148952',2973125,'2139','326',33890.83,35497.97,0.00,0.00,1607.14,449999.20,0.00,0.00,0.00),('1','147','768','149143',2976828,'2139','326',35497.97,37147.97,0.00,0.00,1650.00,462000.00,0.00,0.00,0.00),('1','147','768','149290',2979388,'2139','326',37147.97,38799.75,0.00,0.00,1651.78,462498.40,0.00,0.00,0.00),('1','147','768','149437',2981872,'2139','326',38799.75,40720.10,0.00,0.00,1920.35,537698.00,0.00,0.00,0.00),('1','147','768','149581',2984295,'2139','326',40720.10,42913.10,0.00,0.00,2193.00,614040.00,0.00,0.00,0.00),('1','147','768','149685',2985904,'2139','326',42913.10,44871.67,0.00,0.00,1958.57,548399.60,0.00,0.00,0.00),('1','147','768','149834',2988662,'2139','326',44871.67,47034.17,0.00,0.00,2162.50,605500.00,0.00,0.00,0.00),('1','147','768','149989',2991401,'2139','326',47034.17,48165.17,0.00,0.00,1131.00,316680.00,0.00,0.00,0.00),('1','147','768','150138',2994683,'2139','326',48165.17,50852.74,0.00,0.00,2687.57,752519.60,0.00,0.00,0.00),('1','147','768','150361',2998055,'2139','326',50852.74,53176.31,0.00,0.00,2323.57,650599.60,0.00,0.00,0.00),('1','147','768','150522',3001385,'2139','326',53176.31,53550.31,0.00,0.00,374.00,104720.00,0.00,0.00,0.00),('1','147','768','150710',3005115,'2139','326',53550.31,55669.77,0.00,0.00,2119.46,593448.80,0.00,0.00,0.00),('1','147','768','150834',3007360,'2139','326',55669.77,58063.77,0.00,0.00,2394.00,670320.00,0.00,0.00,0.00),('1','147','768','150995',3010224,'2139','326',58063.77,59783.41,0.00,0.00,1719.64,481499.20,0.00,0.00,0.00),('1','147','768','151131',3012816,'2139','326',59783.41,61647.69,0.00,0.00,1864.28,521998.40,0.00,0.00,0.00),('1','147','768','151290',3015770,'2139','326',61647.69,62975.69,0.00,0.00,1328.00,371840.00,0.00,0.00,0.00),('1','147','768','151456',3018873,'2139','326',62975.69,65114.97,0.00,0.00,2139.28,598998.40,0.00,0.00,0.00),('1','147','768','151593',3021329,'2139','326',65114.97,66616.75,0.00,0.00,1501.78,420498.40,0.00,0.00,0.00),('1','147','768','151706',3023366,'2139','326',66616.75,68635.75,0.00,0.00,2019.00,565320.00,0.00,0.00,0.00),('1','147','768','151832',3025690,'2139','326',68635.75,70923.25,0.00,0.00,2287.50,640500.00,0.00,0.00,0.00),('1','147','768','152021',3029437,'2139','326',70923.25,72371.82,0.00,0.00,1448.57,405599.60,0.00,0.00,0.00),('1','147','768','152167',3031935,'2139','326',72371.82,73207.53,0.00,0.00,835.71,233998.80,0.00,0.00,0.00),('1','147','768','152327',3035061,'2139','326',73207.53,74625.03,0.00,0.00,1417.50,396900.00,0.00,0.00,0.00),('1','147','768','152541',3038944,'2139','326',74625.03,76380.03,0.00,0.00,1755.00,491400.00,0.00,0.00,0.00),('1','147','768','152581',3039801,'2139','326',76380.03,77922.03,0.00,0.00,1542.00,431760.00,0.00,0.00,0.00),('1','147','768','152781',3043160,'2139','326',77922.03,79179.17,0.00,0.00,1257.14,351999.20,0.00,0.00,0.00),('1','147','768','152902',3045406,'2139','326',79179.17,81510.59,0.00,0.00,2331.42,652797.60,0.00,0.00,0.00),('1','147','768','153090',3048667,'2139','326',81510.59,82769.87,0.00,0.00,1259.28,352598.40,0.00,0.00,0.00),('1','147','768','153281',3052063,'2139','326',82769.87,83333.87,0.00,0.00,564.00,157920.00,0.00,0.00,0.00),('1','147','768','153282',3052064,'2139','326',83333.87,84137.08,0.00,0.00,803.21,224898.80,0.00,0.00,0.00),('1','147','768','153477',3055772,'2139','326',84137.08,85460.29,0.00,0.00,1323.21,370498.80,0.00,0.00,0.00),('1','147','768','153689',3059663,'2139','326',85460.29,87042.79,0.00,0.00,1582.50,443100.00,0.00,0.00,0.00),('1','147','768','153805',3061655,'2139','326',87042.79,88528.50,0.00,0.00,1485.71,415998.80,0.00,0.00,0.00),('1','147','768','153932',3063930,'2139','326',88528.50,88842.50,0.00,0.00,314.00,87920.00,0.00,0.00,0.00),('1','147','768','153933',3063931,'2139','326',88842.50,89656.07,0.00,0.00,813.57,227799.60,0.00,0.00,0.00),('1','147','768','154065',3066186,'2139','326',89656.07,92011.42,0.00,0.00,2355.35,659498.00,0.00,0.00,0.00),('1','147','768','154253',3069498,'2139','326',92011.42,93518.74,0.00,0.00,1507.32,422049.60,0.00,0.00,0.00),('1','147','768','154421',3072646,'2139','326',93518.74,94422.74,0.00,0.00,904.00,253120.00,0.00,0.00,0.00),('1','147','768','154574',3075754,'2139','326',94422.74,95124.16,0.00,0.00,701.42,196397.60,0.00,0.00,0.00),('1','147','768','154756',3079081,'2139','326',95124.16,97473.08,0.00,0.00,2348.92,657697.60,0.00,0.00,0.00),('1','147','768','154890',3081477,'2139','326',97473.08,98996.65,0.00,0.00,1523.57,426599.60,0.00,0.00,0.00),('1','147','768','155010',3083920,'2139','326',98996.65,100207.65,0.00,0.00,1211.00,339080.00,0.00,0.00,0.00),('1','147','768','155011',3083921,'2139','326',100207.65,101122.29,0.00,0.00,914.64,256099.20,0.00,0.00,0.00),('1','147','768','155153',3086569,'2139','326',101122.29,103779.43,0.00,0.00,2657.14,743999.20,0.00,0.00,0.00),('1','147','768','155319',3089686,'2139','326',103779.43,105470.50,0.00,0.00,1691.07,473499.60,0.00,0.00,0.00),('1','147','768','155431',3091898,'2139','326',105470.50,105985.50,0.00,0.00,515.00,144200.00,0.00,0.00,0.00),('1','147','768','155444',3092149,'2139','326',105985.50,107371.92,0.00,0.00,1386.42,388197.60,0.00,0.00,0.00),('1','147','768','155658',3095861,'2139','326',107371.92,109197.27,0.00,0.00,1825.35,511098.00,0.00,0.00,0.00),('1','147','768','155783',3098144,'2139','326',109197.27,110759.41,0.00,0.00,1562.14,437399.20,0.00,0.00,0.00),('1','147','768','155914',3100378,'2139','326',110759.41,111769.41,0.00,0.00,1010.00,282800.00,0.00,0.00,0.00),('1','147','768','156071',3103313,'2139','326',111769.41,114317.62,0.00,0.00,2548.21,713498.80,0.00,0.00,0.00),('1','147','768','156238',3106286,'2139','326',114317.62,116634.40,0.00,0.00,2316.78,648698.40,0.00,0.00,0.00),('1','147','768','156402',3109293,'2139','326',116634.40,117208.40,0.00,0.00,574.00,160720.00,0.00,0.00,0.00),('1','147','768','156563',3112351,'2139','326',117208.40,118944.82,0.00,0.00,1736.42,486197.60,0.00,0.00,0.00),('1','147','768','156740',3115544,'2139','326',118944.82,120366.24,0.00,0.00,1421.42,397997.60,0.00,0.00,0.00),('1','147','768','156918',3118688,'2139','326',120366.24,122026.24,0.00,0.00,1660.00,464800.00,0.00,0.00,0.00),('1','147','768','157111',3122162,'2139','326',122026.24,122842.24,0.00,0.00,816.00,228480.00,0.00,0.00,0.00),('1','147','768','157264',3125081,'2139','326',122842.24,124959.38,0.00,0.00,2117.14,592799.20,0.00,0.00,0.00),('1','147','768','157476',3128319,'2139','326',124959.38,127727.05,0.00,0.00,2767.67,774947.60,0.00,0.00,0.00),('1','147','768','157638',3131527,'2139','326',127727.05,128618.05,0.00,0.00,891.00,249480.00,0.00,0.00,0.00),('1','147','768','157808',3134595,'2139','326',128618.05,130125.55,0.00,0.00,1507.50,422100.00,0.00,0.00,0.00),('1','147','768','157944',3137223,'2139','326',130125.55,131731.62,0.00,0.00,1606.07,449699.60,0.00,0.00,0.00),('1','147','768','158097',3139860,'2139','326',131731.62,133484.47,0.00,0.00,1752.85,490798.00,0.00,0.00,0.00),('1','147','768','158274',3143231,'2139','326',133484.47,133899.47,0.00,0.00,415.00,116200.00,0.00,0.00,0.00),('1','147','768','158294',3143598,'2139','326',133899.47,134761.97,0.00,0.00,862.50,241500.00,0.00,0.00,0.00),('1','147','768','158429',3146230,'2139','326',134761.97,136652.32,0.00,0.00,1890.35,529298.00,0.00,0.00,0.00),('1','147','768','158610',3149347,'2139','326',136652.32,138900.53,0.00,0.00,2248.21,629498.80,0.00,0.00,0.00),('1','147','768','158775',3152263,'2139','326',138900.53,139746.53,0.00,0.00,846.00,236880.00,0.00,0.00,0.00),('1','147','768','158904',3154654,'2139','326',139746.53,140321.53,0.00,0.00,575.00,170200.00,0.00,0.00,0.00),('1','147','768','158908',3154691,'2139','326',140321.53,140321.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','159281',3161440,'2139','326',140321.53,142496.47,0.00,0.00,2174.94,643782.24,0.00,0.00,0.00),('1','147','768','159282',3161441,'2139','326',142496.47,142496.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','159461',3164203,'2139','326',142496.47,144176.87,0.00,0.00,1680.40,497398.40,0.00,0.00,0.00),('1','147','768','159641',3167480,'2139','326',144176.87,144980.23,0.00,0.00,803.36,237794.56,0.00,0.00,0.00),('1','147','768','159642',3167481,'2139','326',144980.23,145606.49,0.00,0.00,626.26,190383.04,0.00,0.00,0.00),('1','147','768','159643',3167482,'2139','326',145606.49,145606.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','159744',3169092,'2139','326',145606.49,148593.66,0.00,0.00,2987.17,908099.68,0.00,0.00,0.00),('1','147','768','159954',3172872,'2139','326',148593.66,150187.41,0.00,0.00,1593.75,484500.00,0.00,0.00,0.00),('1','147','768','159963',3172980,'2139','326',150187.41,150187.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','160115',3176117,'2139','326',150187.41,151520.30,0.00,0.00,1332.89,405198.56,0.00,0.00,0.00),('1','147','768','160260',3178491,'2139','326',151520.30,153209.77,0.00,0.00,1689.47,513598.88,0.00,0.00,0.00),('1','147','768','160448',3182071,'2139','326',153209.77,154677.27,0.00,0.00,1467.50,469600.00,0.00,0.00,0.00),('1','147','768','160594',3184615,'2139','326',154677.27,155394.45,0.00,0.00,717.18,229497.60,0.00,0.00,0.00),('1','147','768','160596',3184618,'2139','326',155394.45,155394.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','160601',3184675,'2139','326',155394.45,156052.57,0.00,0.00,658.12,210598.40,0.00,0.00,0.00),('1','147','768','160734',3186950,'2139','326',156052.57,157739.44,0.00,0.00,1686.87,539798.40,0.00,0.00,0.00),('1','147','768','160917',3189856,'2139','326',157739.44,160230.37,0.00,0.00,2490.93,797097.60,0.00,0.00,0.00),('1','147','768','161100',3193379,'2139','326',160230.37,161167.37,0.00,0.00,937.00,299840.00,0.00,0.00,0.00),('1','147','768','161260',3196461,'2139','326',161167.37,162089.87,0.00,0.00,922.50,295200.00,0.00,0.00,0.00),('1','147','768','161441',3199375,'2139','326',162089.87,163368.77,0.00,0.00,1278.90,409248.00,0.00,0.00,0.00),('1','147','768','161649',3202833,'2139','326',163368.77,164685.33,0.00,0.00,1316.56,421299.20,0.00,0.00,0.00),('1','147','768','161891',3206881,'2139','326',164685.33,166085.33,0.00,0.00,1400.00,448000.00,0.00,0.00,0.00),('1','147','768','162048',3209794,'2139','326',166085.33,167424.08,0.00,0.00,1338.75,428400.00,0.00,0.00,0.00),('1','147','768','162221',3212841,'2139','326',167424.08,169304.34,0.00,0.00,1880.26,571599.04,0.00,0.00,0.00),('1','147','768','162446',3216602,'2139','326',169304.34,171079.89,0.00,0.00,1775.55,539767.20,0.00,0.00,0.00),('1','147','768','162646',3219726,'2139','326',171079.89,171290.41,0.00,0.00,210.52,63998.08,0.00,0.00,0.00),('1','147','768','162647',3219727,'2139','326',171290.41,172233.50,0.00,0.00,943.09,286699.36,0.00,0.00,0.00),('1','147','768','162827',3223085,'2139','326',172233.50,173409.81,0.00,0.00,1176.31,357598.24,0.00,0.00,0.00),('1','147','768','163021',3226474,'2139','326',173409.81,174729.21,0.00,0.00,1319.40,401097.60,0.00,0.00,0.00),('1','147','768','163264',3230771,'2139','326',174729.21,175990.55,0.00,0.00,1261.34,383447.36,0.00,0.00,0.00),('1','147','768','163268',3230843,'2139','326',175990.55,176566.86,0.00,0.00,576.31,175198.24,0.00,0.00,0.00),('1','147','768','163381',3232835,'2139','326',176566.86,177530.67,0.00,0.00,963.81,292998.24,0.00,0.00,0.00),('1','147','768','163544',3235903,'2139','326',177530.67,179438.56,0.00,0.00,1907.89,579998.56,0.00,0.00,0.00),('1','147','768','163745',3239518,'2139','326',179438.56,180462.57,0.00,0.00,1024.01,311299.04,0.00,0.00,0.00),('1','147','768','163905',3242385,'2139','326',180462.57,181665.59,0.00,0.00,1203.02,365718.08,0.00,0.00,0.00),('1','147','768','164091',3245645,'2139','326',181665.59,182784.01,0.00,0.00,1118.42,339999.68,0.00,0.00,0.00),('1','147','768','164259',3248725,'2139','326',182784.01,184096.34,0.00,0.00,1312.33,398948.32,0.00,0.00,0.00),('1','147','768','164447',3252279,'2139','326',184096.34,185333.18,0.00,0.00,1236.84,375999.36,0.00,0.00,0.00),('1','147','768','164604',3255056,'2139','326',185333.18,186624.13,0.00,0.00,1290.95,392448.80,0.00,0.00,0.00),('1','147','768','164977',3261746,'2139','326',186624.13,188619.19,0.00,0.00,1995.06,606498.24,0.00,0.00,0.00),('1','147','768','164978',3261747,'2139','326',188619.19,189770.50,0.00,0.00,1151.31,349998.24,0.00,0.00,0.00),('1','147','768','164979',3261748,'2139','326',189770.50,190300.18,0.00,0.00,529.68,169497.60,0.00,0.00,0.00),('1','147','768','165114',3264202,'2139','326',190300.18,191784.21,0.00,0.00,1484.03,474889.60,0.00,0.00,0.00),('1','147','768','165314',3267658,'2139','326',191784.21,193718.42,0.00,0.00,1934.21,587999.84,0.00,0.00,0.00),('1','147','768','165446',3269962,'2139','326',193718.42,195369.73,0.00,0.00,1651.31,501998.24,0.00,0.00,0.00),('1','147','768','165660',3273689,'2139','326',195369.73,196991.11,0.00,0.00,1621.38,492899.52,0.00,0.00,0.00),('1','147','768','165799',3276394,'2139','326',196991.11,198555.25,0.00,0.00,1564.14,475498.56,0.00,0.00,0.00),('1','147','768','165932',3278723,'2139','326',198555.25,200956.56,0.00,0.00,2401.31,729998.24,0.00,0.00,0.00),('1','147','768','166138',3282446,'2139','326',200956.56,202046.03,0.00,0.00,1089.47,331198.88,0.00,0.00,0.00),('1','147','768','166323',3285764,'2139','326',202046.03,203692.74,0.00,0.00,1646.71,500599.84,0.00,0.00,0.00),('1','147','768','166487',3288846,'2139','326',203692.74,205628.59,0.00,0.00,1935.85,588498.40,0.00,0.00,0.00),('1','147','768','166688',3292257,'2139','326',205628.59,207006.87,0.00,0.00,1378.28,418997.12,0.00,0.00,0.00),('1','147','768','166858',3295191,'2139','326',207006.87,207217.39,0.00,0.00,210.52,63998.08,0.00,0.00,0.00),('1','147','768','166889',3295619,'2139','326',207217.39,208398.31,0.00,0.00,1180.92,358999.68,0.00,0.00,0.00),('1','147','768','167047',3298534,'2139','326',208398.31,210404.88,0.00,0.00,2006.57,609997.28,0.00,0.00,0.00),('1','147','768','167189',3300986,'2139','326',210404.88,212602.24,0.00,0.00,2197.36,667997.44,0.00,0.00,0.00),('1','147','768','167375',3304289,'2139','326',212602.24,212812.76,0.00,0.00,210.52,63998.08,0.00,0.00,0.00),('1','147','768','167380',3304338,'2139','326',212812.76,213957.10,0.00,0.00,1144.34,347879.36,0.00,0.00,0.00),('1','147','768','167563',3307836,'2139','326',213957.10,215225.19,0.00,0.00,1268.09,385499.36,0.00,0.00,0.00),('1','147','768','167741',3310844,'2139','326',215225.19,216918.61,0.00,0.00,1693.42,514799.68,0.00,0.00,0.00),('1','147','768','167891',3313543,'2139','326',216918.61,217941.86,0.00,0.00,1023.25,311068.00,0.00,0.00,0.00),('1','147','768','168134',3318097,'2139','326',217941.86,219961.59,0.00,0.00,2019.73,613997.92,0.00,0.00,0.00),('1','147','768','168281',3320855,'2139','326',219961.59,222029.02,0.00,0.00,2067.43,628498.72,0.00,0.00,0.00),('1','147','768','168361',3322307,'2139','326',222029.02,223046.78,0.00,0.00,1017.76,309399.04,0.00,0.00,0.00),('1','147','768','168407',3323118,'2139','326',223046.78,224347.73,0.00,0.00,1300.95,395488.80,0.00,0.00,0.00),('1','147','768','168607',3326699,'2139','326',224347.73,225985.55,0.00,0.00,1637.82,497897.28,0.00,0.00,0.00),('1','147','768','168765',3329624,'2139','326',225985.55,227687.85,0.00,0.00,1702.30,517499.20,0.00,0.00,0.00),('1','147','768','168924',3332285,'2139','326',227687.85,228102.32,0.00,0.00,414.47,125998.88,0.00,0.00,0.00),('1','147','768','169060',3334717,'2139','326',228102.32,229913.17,0.00,0.00,1810.85,550498.40,0.00,0.00,0.00),('1','147','768','169106',3335466,'2139','326',229913.17,233023.36,0.00,0.00,3110.19,945497.76,0.00,0.00,0.00),('1','147','768','169250',3338218,'2139','326',233023.36,233940.33,0.00,0.00,916.97,278758.88,0.00,0.00,0.00),('1','147','768','169256',3338364,'2139','326',233940.33,235091.64,0.00,0.00,1151.31,349998.24,0.00,0.00,0.00),('1','147','768','169433',3341835,'2139','326',235091.64,237150.85,0.00,0.00,2059.21,625999.84,0.00,0.00,0.00),('1','147','768','169572',3344684,'2139','326',237150.85,238677.16,0.00,0.00,1526.31,463998.24,0.00,0.00,0.00),('1','147','768','169777',3348231,'2139','326',238677.16,239125.35,0.00,0.00,448.19,136249.76,0.00,0.00,0.00),('1','147','768','169778',3348232,'2139','326',239125.35,240054.62,0.00,0.00,929.27,282498.08,0.00,0.00,0.00),('1','147','768','169939',3351412,'2139','326',240054.62,241561.19,0.00,0.00,1506.57,457997.28,0.00,0.00,0.00),('1','147','768','170150',3355132,'2139','326',241561.19,243302.96,0.00,0.00,1741.77,529498.08,0.00,0.00,0.00),('1','147','768','170346',3358431,'2139','326',243302.96,244202.02,0.00,0.00,899.06,273314.24,0.00,0.00,0.00),('1','147','768','170441',3360063,'2139','326',244202.02,245412.54,0.00,0.00,1210.52,367998.08,0.00,0.00,0.00),('1','147','768','170499',3361126,'2139','326',245412.54,247864.84,0.00,0.00,2452.30,745499.20,0.00,0.00,0.00),('1','147','768','170645',3363878,'2139','326',247864.84,249443.24,0.00,0.00,1578.40,479833.60,0.00,0.00,0.00),('1','147','768','170966',3369498,'2139','326',249443.24,251216.24,0.00,0.00,1773.00,567360.00,0.00,0.00,0.00),('1','147','768','171004',3370166,'2139','326',251216.24,252809.99,0.00,0.00,1593.75,510000.00,0.00,0.00,0.00),('1','147','768','171220',3374248,'2139','326',252809.99,254512.92,0.00,0.00,1702.93,544937.60,0.00,0.00,0.00),('1','147','768','171363',3376924,'2139','326',254512.92,254700.10,0.00,0.00,187.18,59897.60,0.00,0.00,0.00),('1','147','768','171367',3376975,'2139','326',254700.10,255992.28,0.00,0.00,1292.18,413497.60,0.00,0.00,0.00),('1','147','768','171585',3380886,'2139','326',255992.28,257365.71,0.00,0.00,1373.43,439497.60,0.00,0.00,0.00),('1','147','768','171764',3384039,'2139','326',257365.71,259018.83,0.00,0.00,1653.12,528998.40,0.00,0.00,0.00),('1','147','768','171966',3387613,'2139','326',259018.83,260120.23,0.00,0.00,1101.40,352448.00,0.00,0.00,0.00),('1','147','768','171967',3387614,'2139','326',260120.23,260592.10,0.00,0.00,471.87,150998.40,0.00,0.00,0.00),('1','147','768','172079',3389738,'2139','326',260592.10,262615.53,0.00,0.00,2023.43,647497.60,0.00,0.00,0.00),('1','147','768','172270',3393190,'2139','326',262615.53,264206.15,0.00,0.00,1590.62,508998.40,0.00,0.00,0.00),('1','147','768','172489',3397163,'2139','326',264206.15,265025.33,0.00,0.00,819.18,262137.60,0.00,0.00,0.00),('1','147','768','172701',3401032,'2139','326',265025.33,267084.70,0.00,0.00,2059.37,658998.40,0.00,0.00,0.00),('1','147','768','172875',3404277,'2139','326',267084.70,268772.20,0.00,0.00,1687.50,540000.00,0.00,0.00,0.00),('1','147','768','173056',3407630,'2139','326',268772.20,269826.88,0.00,0.00,1054.68,337497.60,0.00,0.00,0.00),('1','147','768','173222',3411056,'2139','326',269826.88,272581.48,0.00,0.00,2754.60,881472.00,0.00,0.00,0.00),('1','147','768','173389',3413941,'2139','326',272581.48,274931.48,0.00,0.00,2350.00,752000.00,0.00,0.00,0.00),('1','147','768','173600',3417800,'2139','326',274931.48,275562.73,0.00,0.00,631.25,202000.00,0.00,0.00,0.00),('1','147','768','173764',3420798,'2139','326',275562.73,277265.85,0.00,0.00,1703.12,544998.40,0.00,0.00,0.00),('1','147','768','173944',3424113,'2139','326',277265.85,279153.35,0.00,0.00,1887.50,604000.00,0.00,0.00,0.00),('1','147','768','174029',3425549,'2139','326',279153.35,279258.94,0.00,0.00,105.59,33788.80,0.00,0.00,0.00),('1','147','768','174127',3427331,'2139','326',279258.94,279258.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','174128',3427332,'2139','326',279258.94,280444.87,0.00,0.00,1185.93,379497.60,0.00,0.00,0.00),('1','147','768','174317',3430844,'2139','326',280444.87,282091.74,0.00,0.00,1646.87,526998.40,0.00,0.00,0.00),('1','147','768','174389',3431841,'2139','326',282091.74,283899.24,0.00,0.00,1807.50,578400.00,0.00,0.00,0.00),('1','147','768','174627',3436186,'2139','326',283899.24,286477.99,0.00,0.00,2578.75,825200.00,0.00,0.00,0.00),('1','147','768','174838',3440061,'2139','326',286477.99,287208.62,0.00,0.00,730.63,233801.60,0.00,0.00,0.00),('1','147','768','175031',3443869,'2139','326',287208.62,288757.48,0.00,0.00,1548.86,557589.60,0.00,0.00,0.00),('1','147','768','175233',3447409,'2139','326',288757.48,289010.48,0.00,0.00,253.00,91080.00,0.00,0.00,0.00),('1','147','768','175235',3447412,'2139','326',289010.48,290051.28,0.00,0.00,1040.80,374688.00,0.00,0.00,0.00),('1','147','768','175400',3450540,'2139','326',290051.28,291771.68,0.00,0.00,1720.40,619344.00,0.00,0.00,0.00),('1','147','768','175589',3453945,'2139','326',291771.68,293456.08,0.00,0.00,1684.40,606384.00,0.00,0.00,0.00),('1','147','768','175760',3457064,'2139','326',293456.08,295406.38,0.00,0.00,1950.30,702108.00,0.00,0.00,0.00),('1','147','768','175918',3459795,'2139','326',295406.38,298106.88,0.00,0.00,2700.50,972180.00,0.00,0.00,0.00),('1','147','768','176144',3463888,'2139','326',298106.88,298376.68,0.00,0.00,269.80,97128.00,0.00,0.00,0.00),('1','147','768','176145',3463889,'2139','326',298376.68,299692.08,0.00,0.00,1315.40,473544.00,0.00,0.00,0.00),('1','147','768','176315',3467177,'2139','326',299692.08,301612.88,0.00,0.00,1920.80,691488.00,0.00,0.00,0.00),('1','147','768','176547',3471560,'2139','326',301612.88,303513.08,0.00,0.00,1900.20,684072.00,0.00,0.00,0.00),('1','147','768','176791',3475821,'2139','326',303513.08,303875.88,0.00,0.00,362.80,130608.00,0.00,0.00,0.00),('1','147','768','176798',3475908,'2139','326',303875.88,305221.08,0.00,0.00,1345.20,484272.00,0.00,0.00,0.00),('1','147','768','176960',3479103,'2139','326',305221.08,306821.18,0.00,0.00,1600.10,576036.00,0.00,0.00,0.00),('1','147','768','177214',3484033,'2139','326',306821.18,308639.18,0.00,0.00,1818.00,654480.00,0.00,0.00,0.00),('1','147','768','177409',3488001,'2139','326',308639.18,311039.68,0.00,0.00,2400.50,864180.00,0.00,0.00,0.00),('1','147','768','177622',3492282,'2139','326',311039.68,312569.68,0.00,0.00,1530.00,550800.00,0.00,0.00,0.00),('1','147','768','177874',3496726,'2139','326',312569.68,314158.48,0.00,0.00,1588.80,571968.00,0.00,0.00,0.00),('1','147','768','178070',3500648,'2139','326',314158.48,314213.18,0.00,0.00,54.70,19692.00,0.00,0.00,0.00),('1','147','768','178071',3500649,'2139','326',314213.18,315403.68,0.00,0.00,1190.50,428580.00,0.00,0.00,0.00),('1','147','768','178278',3504504,'2139','326',315403.68,317054.48,0.00,0.00,1650.80,594288.00,0.00,0.00,0.00),('1','147','768','178490',3508348,'2139','326',317054.48,318335.38,0.00,0.00,1280.90,461124.00,0.00,0.00,0.00),('1','147','768','178708',3512364,'2139','326',318335.38,319727.58,0.00,0.00,1392.20,501192.00,0.00,0.00,0.00),('1','147','768','179037',3518297,'2139','326',319727.58,322068.28,0.00,0.00,2340.70,842652.00,0.00,0.00,0.00),('1','147','768','179039',3518310,'2139','326',322068.28,323598.14,0.00,0.00,1529.86,550749.60,0.00,0.00,0.00),('1','147','768','179141',3520241,'2139','326',323598.14,325290.35,0.00,0.00,1692.21,609195.60,0.00,0.00,0.00),('1','147','768','179364',3524645,'2139','326',325290.35,325432.17,0.00,0.00,141.82,51055.20,0.00,0.00,0.00),('1','147','768','179414',3525375,'2139','326',325432.17,326255.59,0.00,0.00,823.42,296431.20,0.00,0.00,0.00),('1','147','768','179568',3528430,'2139','326',326255.59,328102.15,0.00,0.00,1846.56,664761.60,0.00,0.00,0.00),('1','147','768','179789',3532625,'2139','326',328102.15,330288.53,0.00,0.00,2186.38,787096.80,0.00,0.00,0.00),('1','147','768','180003',3536542,'2139','326',330288.53,330611.31,0.00,0.00,322.78,116200.80,0.00,0.00,0.00),('1','147','768','180058',3537539,'2139','326',330611.31,331416.30,0.00,0.00,804.99,289796.40,0.00,0.00,0.00),('1','147','768','180223',3540723,'2139','326',331416.30,332972.41,0.00,0.00,1556.11,560199.60,0.00,0.00,0.00),('1','147','768','180240',3541067,'2139','326',332972.41,335373.52,0.00,0.00,2401.11,864399.60,0.00,0.00,0.00),('1','147','768','180340',3542808,'2139','326',335373.52,336657.02,0.00,0.00,1283.50,461700.00,0.00,0.00,0.00),('1','147','768','180555',3546705,'2139','326',336657.02,337126.44,0.00,0.00,469.42,168991.20,0.00,0.00,0.00),('1','147','768','180674',3548934,'2139','326',337126.44,338027.89,0.00,0.00,901.45,324522.00,0.00,0.00,0.00),('1','147','768','180736',3550061,'2139','326',338027.89,339498.15,0.00,0.00,1470.26,529293.60,0.00,0.00,0.00),('1','147','768','180959',3554394,'2139','326',339498.15,341090.77,0.00,0.00,1592.62,568843.20,0.00,0.00,0.00),('1','147','768','181131',3557665,'2139','326',341090.77,342295.69,0.00,0.00,1204.92,433771.20,0.00,0.00,0.00),('1','147','768','181419',3563173,'2139','326',342295.69,344202.71,0.00,0.00,1907.02,686527.20,0.00,0.00,0.00),('1','147','768','181524',3565088,'2139','326',344202.71,346523.09,0.00,0.00,2320.38,835336.80,0.00,0.00,0.00),('1','147','768','181703',3568114,'2139','326',346523.09,347917.35,0.00,0.00,1394.26,501933.60,0.00,0.00,0.00),('1','147','768','182028',3573955,'2139','326',347917.35,349279.03,0.00,0.00,1361.68,490204.80,0.00,0.00,0.00),('1','147','768','182103',3575446,'2139','326',349279.03,351106.82,0.00,0.00,1827.79,658004.40,0.00,0.00,0.00),('1','147','768','182307',3578878,'2139','326',351106.82,353257.85,0.00,0.00,2151.03,774370.80,0.00,0.00,0.00),('1','147','768','182498',3582339,'2139','326',353257.85,353473.46,0.00,0.00,215.61,77619.60,0.00,0.00,0.00),('1','147','768','182559',3583364,'2139','326',353473.46,354830.13,0.00,0.00,1356.67,488401.20,0.00,0.00,0.00),('1','147','768','183087',3593433,'2139','326',354830.13,357180.13,0.00,0.00,2350.00,846000.00,0.00,0.00,0.00),('1','147','768','183164',3594681,'2139','326',357180.13,359069.63,0.00,0.00,1889.50,680220.00,0.00,0.00,0.00),('1','147','768','183169',3594753,'2139','326',359069.63,359458.51,0.00,0.00,388.88,139996.80,0.00,0.00,0.00),('1','147','768','183196',3595384,'2139','326',359458.51,361097.40,0.00,0.00,1638.89,590000.40,0.00,0.00,0.00),('1','147','768','183210',3595547,'2139','326',361097.40,361209.39,0.00,0.00,111.99,40316.40,0.00,0.00,0.00),('1','147','768','183322',3597341,'2139','326',361209.39,362061.92,0.00,0.00,852.53,306910.80,0.00,0.00,0.00),('1','147','768','183426',3599407,'2139','326',362061.92,363382.30,0.00,0.00,1320.38,475336.80,0.00,0.00,0.00),('1','147','768','183652',3603389,'2139','326',363382.30,364783.16,0.00,0.00,1400.86,504309.60,0.00,0.00,0.00),('1','147','768','183900',3608054,'2139','326',364783.16,366391.05,0.00,0.00,1607.89,578840.40,0.00,0.00,0.00),('1','147','768','184127',3612090,'2139','326',366391.05,366932.62,0.00,0.00,541.57,194965.20,0.00,0.00,0.00),('1','147','768','184147',3612383,'2139','326',366932.62,368170.40,0.00,0.00,1237.78,445600.80,0.00,0.00,0.00),('1','147','768','184268',3614577,'2139','326',368170.40,370644.97,0.00,0.00,2474.57,890845.20,0.00,0.00,0.00),('1','147','768','184512',3618743,'2139','326',370644.97,371945.06,0.00,0.00,1300.09,468032.40,0.00,0.00,0.00),('1','147','768','184748',3623182,'2139','326',371945.06,372092.28,0.00,0.00,147.22,52999.20,0.00,0.00,0.00),('1','147','768','184775',3623770,'2139','326',372092.28,373313.12,0.00,0.00,1220.84,439502.40,0.00,0.00,0.00),('1','147','768','184908',3626021,'2139','326',373313.12,374468.68,0.00,0.00,1155.56,416001.60,0.00,0.00,0.00),('1','147','768','185154',3630280,'2139','326',374468.68,375788.84,0.00,0.00,1320.16,475257.60,0.00,0.00,0.00),('1','147','768','185278',3632104,'2139','326',375788.84,377170.24,0.00,0.00,1381.40,497304.00,0.00,0.00,0.00),('1','147','768','185480',3635946,'2139','326',377170.24,377825.84,0.00,0.00,655.60,236016.00,0.00,0.00,0.00),('1','147','768','185538',3637068,'2139','326',377825.84,378941.15,0.00,0.00,1115.31,401511.60,0.00,0.00,0.00),('1','147','768','185673',3639524,'2139','326',378941.15,379511.89,0.00,0.00,570.74,205466.40,0.00,0.00,0.00),('1','147','768','185764',3640922,'2139','326',379511.89,380629.98,0.00,0.00,1118.09,402512.40,0.00,0.00,0.00),('1','147','768','185871',3643041,'2139','326',380629.98,381988.07,0.00,0.00,1358.09,488912.40,0.00,0.00,0.00),('1','147','768','186087',3646952,'2139','326',381988.07,383364.32,0.00,0.00,1376.25,495450.00,0.00,0.00,0.00),('1','147','768','186309',3650623,'2139','326',383364.32,384282.31,0.00,0.00,917.99,330476.40,0.00,0.00,0.00),('1','147','768','186492',3653694,'2139','326',384282.31,384555.73,0.00,0.00,273.42,98431.20,0.00,0.00,0.00),('1','147','768','186537',3654449,'2139','326',384555.73,386031.84,0.00,0.00,1476.11,531399.60,0.00,0.00,0.00),('1','147','768','186747',3658093,'2139','326',386031.84,387798.29,0.00,0.00,1766.45,635922.00,0.00,0.00,0.00),('1','147','768','186977',3661891,'2139','326',387798.29,389731.93,0.00,0.00,1933.64,696110.40,0.00,0.00,0.00),('1','147','768','187160',3665026,'2139','326',389731.93,390015.26,0.00,0.00,283.33,101998.80,0.00,0.00,0.00),('1','147','768','187284',3667212,'2139','326',390015.26,391294.31,0.00,0.00,1279.05,460458.00,0.00,0.00,0.00),('1','147','768','187347',3668449,'2139','326',391294.31,392834.66,0.00,0.00,1540.35,554526.00,0.00,0.00,0.00),('1','147','768','187571',3672414,'2139','326',392834.66,394470.70,0.00,0.00,1636.04,588974.40,0.00,0.00,0.00),('1','147','768','187793',3676350,'2139','326',394470.70,395730.52,0.00,0.00,1259.82,453535.20,0.00,0.00,0.00),('1','147','768','188043',3680551,'2139','326',395730.52,398321.81,0.00,0.00,2591.29,932864.40,0.00,0.00,0.00),('1','147','768','188206',3683535,'2139','326',398321.81,400761.79,0.00,0.00,2439.98,878392.80,0.00,0.00,0.00),('1','147','768','188509',3688709,'2139','326',400761.79,403064.66,0.00,0.00,2302.87,829033.20,0.00,0.00,0.00),('1','147','768','188600',3690354,'2139','326',403064.66,405429.39,0.00,0.00,2364.73,851302.80,0.00,0.00,0.00),('1','147','768','188984',3697315,'2139','326',405429.39,408057.61,0.00,0.00,2628.22,946159.20,0.00,0.00,0.00),('1','147','768','189083',3698858,'2139','326',408057.61,409733.75,0.00,0.00,1676.14,603410.40,0.00,0.00,0.00),('1','147','768','189195',3700943,'2139','326',409733.75,410364.59,0.00,0.00,630.84,227102.40,0.00,0.00,0.00),('1','147','768','189347',3703901,'2139','326',410364.59,411156.28,0.00,0.00,791.69,285008.40,0.00,0.00,0.00),('1','147','768','189417',3705033,'2139','326',411156.28,412725.56,0.00,0.00,1569.28,564940.80,0.00,0.00,0.00),('1','147','768','189624',3708493,'2139','326',412725.56,414126.30,0.00,0.00,1400.74,504266.40,0.00,0.00,0.00),('1','147','768','189810',3711885,'2139','326',414126.30,415010.64,0.00,0.00,884.34,318362.40,0.00,0.00,0.00),('1','147','768','190066',3716820,'2139','326',415010.64,417521.68,0.00,0.00,2511.04,903974.40,0.00,0.00,0.00),('1','147','768','190207',3719660,'2139','326',417521.68,419085.06,0.00,0.00,1563.38,562816.80,0.00,0.00,0.00),('1','147','768','190429',3723764,'2139','326',419085.06,419928.16,0.00,0.00,843.10,303516.00,0.00,0.00,0.00),('1','147','768','190904',3732349,'2139','326',419928.16,420721.97,0.00,0.00,793.81,285771.60,0.00,0.00,0.00),('1','147','768','190927',3732668,'2139','326',420721.97,422717.27,0.00,0.00,1995.30,718308.00,0.00,0.00,0.00),('1','147','768','191129',3736252,'2139','326',422717.27,424103.42,0.00,0.00,1386.15,499014.00,0.00,0.00,0.00),('1','147','768','192294',3758211,'2139','326',424103.42,424813.42,0.00,0.00,710.00,255600.00,0.00,0.00,0.00),('1','147','768','192309',3758463,'2139','326',424813.42,425406.75,0.00,0.00,593.33,213598.80,0.00,0.00,0.00),('1','147','768','192310',3758464,'2139','326',425406.75,427720.27,0.00,0.00,2313.52,832867.20,0.00,0.00,0.00),('1','147','768','192311',3758465,'2139','326',427720.27,429287.21,0.00,0.00,1566.94,564098.40,0.00,0.00,0.00),('1','147','768','192314',3758509,'2139','326',429287.21,430083.96,0.00,0.00,796.75,286830.00,0.00,0.00,0.00),('1','147','768','192319',3758601,'2139','326',430083.96,431803.90,0.00,0.00,1719.94,619178.40,0.00,0.00,0.00),('1','147','768','192412',3759809,'2139','326',431803.90,433410.57,0.00,0.00,1606.67,578401.20,0.00,0.00,0.00),('1','147','768','192563',3762872,'2139','326',433410.57,435029.30,0.00,0.00,1618.73,582742.80,0.00,0.00,0.00),('1','147','768','192749',3766224,'2139','326',435029.30,435919.76,0.00,0.00,890.46,320565.60,0.00,0.00,0.00),('1','147','768','192891',3768774,'2139','326',435919.76,436775.59,0.00,0.00,855.83,308098.80,0.00,0.00,0.00),('1','147','768','192945',3769856,'2139','326',436775.59,439161.08,0.00,0.00,2385.49,858776.40,0.00,0.00,0.00),('1','147','768','193167',3773950,'2139','326',439161.08,440623.09,0.00,0.00,1462.01,526323.60,0.00,0.00,0.00),('1','147','768','193409',3778853,'2139','326',440623.09,441783.65,0.00,0.00,1160.56,417801.60,0.00,0.00,0.00),('1','147','768','193655',3783142,'2139','326',441783.65,443676.80,0.00,0.00,1893.15,681534.00,0.00,0.00,0.00),('1','147','768','193888',3787332,'2139','326',443676.80,445354.95,0.00,0.00,1678.15,604134.00,0.00,0.00,0.00),('1','147','768','194086',3790945,'2139','326',445354.95,447190.43,0.00,0.00,1835.48,660772.80,0.00,0.00,0.00),('1','147','768','194350',3795742,'2139','326',447190.43,447629.43,0.00,0.00,439.00,158040.00,0.00,0.00,0.00),('1','147','768','194417',3797068,'2139','326',447629.43,449630.15,0.00,0.00,2000.72,720259.20,0.00,0.00,0.00),('1','147','768','194489',3798343,'2139','326',449630.15,452003.39,0.00,0.00,2373.24,854366.40,0.00,0.00,0.00),('1','147','768','194675',3801670,'2139','326',452003.39,453506.03,0.00,0.00,1502.64,540950.40,0.00,0.00,0.00),('1','147','768','194923',3806697,'2139','326',453506.03,455202.40,0.00,0.00,1696.37,610693.20,0.00,0.00,0.00),('1','147','768','195087',3809459,'2139','326',455202.40,456912.97,0.00,0.00,1710.57,615805.20,0.00,0.00,0.00),('1','147','768','195305',3813376,'2139','326',456912.97,458877.23,0.00,0.00,1964.26,707133.60,0.00,0.00,0.00),('1','147','768','195522',3817210,'2139','326',458877.23,459366.83,0.00,0.00,489.60,176256.00,0.00,0.00,0.00),('1','147','768','195647',3819066,'2139','326',459366.83,460441.23,0.00,0.00,1074.40,386784.00,0.00,0.00,0.00),('1','147','768','195764',3821284,'2139','326',460441.23,462987.79,0.00,0.00,2546.56,916761.60,0.00,0.00,0.00),('1','147','768','195999',3825557,'2139','326',462987.79,464955.13,0.00,0.00,1967.34,708242.40,0.00,0.00,0.00),('1','147','768','196275',3830582,'2139','326',464955.13,466453.38,0.00,0.00,1498.25,539370.00,0.00,0.00,0.00),('1','147','768','196461',3833933,'2139','326',466453.38,468203.13,0.00,0.00,1749.75,629910.00,0.00,0.00,0.00),('1','147','768','196661',3837600,'2139','326',468203.13,470013.69,0.00,0.00,1810.56,651801.60,0.00,0.00,0.00),('1','147','768','196908',3841889,'2139','326',470013.69,470789.42,0.00,0.00,775.73,279262.80,0.00,0.00,0.00),('1','147','768','197079',3844986,'2139','326',470789.42,472199.48,0.00,0.00,1410.06,507621.60,0.00,0.00,0.00),('1','147','768','197362',3850230,'2139','326',472199.48,474109.48,0.00,0.00,1910.00,687600.00,0.00,0.00,0.00),('1','147','768','197410',3850496,'2139','326',474109.48,476041.48,0.00,0.00,1932.00,695520.00,0.00,0.00,0.00),('1','147','768','197564',3853207,'2139','326',476041.48,477405.98,0.00,0.00,1364.50,491220.00,0.00,0.00,0.00),('1','147','768','197930',3859736,'2139','326',477405.98,478890.94,0.00,0.00,1484.96,534585.60,0.00,0.00,0.00),('1','147','768','198146',3863485,'2139','326',478890.94,480107.65,0.00,0.00,1216.71,438015.60,0.00,0.00,0.00),('1','147','768','198364',3867216,'2139','326',480107.65,481339.20,0.00,0.00,1231.55,443358.00,0.00,0.00,0.00),('1','147','768','198567',3870833,'2139','326',481339.20,481869.34,0.00,0.00,530.14,190850.40,0.00,0.00,0.00),('1','147','768','198688',3872971,'2139','326',481869.34,482482.80,0.00,0.00,613.46,220845.60,0.00,0.00,0.00),('1','147','768','198781',3874345,'2139','326',482482.80,484580.04,0.00,0.00,2097.24,755006.40,0.00,0.00,0.00),('1','147','768','198986',3877922,'2139','326',484580.04,486773.09,0.00,0.00,2193.05,789498.00,0.00,0.00,0.00),('1','147','768','199222',3882084,'2139','326',486773.09,487301.57,0.00,0.00,528.48,190252.80,0.00,0.00,0.00),('1','147','768','199399',3885064,'2139','326',487301.57,487834.90,0.00,0.00,533.33,191998.80,0.00,0.00,0.00),('1','147','768','199464',3885826,'2139','326',487834.90,489437.44,0.00,0.00,1602.54,576914.40,0.00,0.00,0.00),('1','147','768','199671',3889409,'2139','326',489437.44,490942.57,0.00,0.00,1505.13,541846.80,0.00,0.00,0.00),('1','147','768','199967',3894322,'2139','326',490942.57,492772.91,0.00,0.00,1830.34,658922.40,0.00,0.00,0.00),('1','147','768','200107',3896857,'2139','326',492772.91,493193.73,0.00,0.00,420.82,151495.20,0.00,0.00,0.00),('1','147','768','200224',3899139,'2139','326',493193.73,494265.42,0.00,0.00,1071.69,385808.40,0.00,0.00,0.00),('1','147','768','200294',3900206,'2139','326',494265.42,496417.28,0.00,0.00,2151.86,774669.60,0.00,0.00,0.00),('1','147','768','200497',3904029,'2139','326',496417.28,498844.03,0.00,0.00,2426.75,873630.00,0.00,0.00,0.00),('1','147','768','200712',3907775,'2139','326',498844.03,499113.63,0.00,0.00,269.60,97056.00,0.00,0.00,0.00),('1','147','768','200770',3908754,'2139','326',499113.63,500514.89,0.00,0.00,1401.26,504453.60,0.00,0.00,0.00),('1','147','768','200933',3911645,'2139','326',500514.89,502785.69,0.00,0.00,2270.80,817488.00,0.00,0.00,0.00),('1','147','768','201134',3914833,'2139','326',502785.69,504875.62,0.00,0.00,2089.93,752374.80,0.00,0.00,0.00),('1','147','768','201345',3918449,'2139','326',504875.62,505004.69,0.00,0.00,129.07,46465.20,0.00,0.00,0.00),('1','147','768','201350',3918505,'2139','326',505004.69,506325.96,0.00,0.00,1321.27,475657.20,0.00,0.00,0.00),('1','147','768','201518',3921667,'2139','326',506325.96,508198.57,0.00,0.00,1872.61,674139.60,0.00,0.00,0.00),('1','147','768','201770',3926684,'2139','326',508198.57,510470.61,0.00,0.00,2272.04,817934.40,0.00,0.00,0.00),('1','147','768','202046',3931781,'2139','326',510470.61,513028.39,0.00,0.00,2557.78,920800.80,0.00,0.00,0.00),('1','147','768','202263',3935364,'2139','326',513028.39,514679.67,0.00,0.00,1651.28,594460.80,0.00,0.00,0.00),('1','147','768','202455',3938769,'2139','326',514679.67,515460.69,0.00,0.00,781.02,281167.20,0.00,0.00,0.00),('1','147','768','202702',3943019,'2139','326',515460.69,516054.38,0.00,0.00,593.69,213728.40,0.00,0.00,0.00),('1','147','768','202707',3943089,'2139','326',516054.38,517795.71,0.00,0.00,1741.33,626878.80,0.00,0.00,0.00),('1','147','768','202849',3945899,'2139','326',517795.71,519419.12,0.00,0.00,1623.41,584427.60,0.00,0.00,0.00),('1','147','768','203100',3950755,'2139','326',519419.12,520639.00,0.00,0.00,1219.88,439156.80,0.00,0.00,0.00),('1','147','768','203382',3955742,'2139','326',520639.00,522513.90,0.00,0.00,1874.90,674964.00,0.00,0.00,0.00),('1','147','768','203518',3958261,'2139','326',522513.90,524881.06,0.00,0.00,2367.16,852177.60,0.00,0.00,0.00),('1','147','768','203730',3962036,'2139','326',524881.06,524882.45,0.00,0.00,1.39,500.40,0.00,0.00,0.00),('1','147','768','203747',3962186,'2139','326',524882.45,525715.79,0.00,0.00,833.34,313260.32,0.00,0.00,0.00),('1','147','768','203930',3965660,'2139','326',525715.79,526138.62,0.00,0.00,422.83,158984.08,0.00,0.00,0.00),('1','147','768','203957',3966063,'2139','326',526138.62,527442.52,0.00,0.00,1303.90,490266.40,0.00,0.00,0.00),('1','147','768','204189',3970329,'2139','326',527442.52,529957.54,0.00,0.00,2515.02,945647.52,0.00,0.00,0.00),('1','147','768','204390',3973963,'2139','326',529957.54,531554.69,0.00,0.00,1597.15,600528.40,0.00,0.00,0.00),('1','147','768','204676',3978804,'2139','326',531554.69,532995.12,0.00,0.00,1440.43,541601.68,0.00,0.00,0.00),('1','147','768','204862',3981892,'2139','326',532995.12,535212.04,0.00,0.00,2216.92,833561.92,0.00,0.00,0.00),('1','147','768','205039',3985205,'2139','326',535212.04,537070.69,0.00,0.00,1858.65,698852.40,0.00,0.00,0.00),('1','147','768','205262',3989107,'2139','326',537070.69,538626.04,0.00,0.00,1555.35,584811.60,0.00,0.00,0.00),('1','147','768','205480',3993136,'2139','326',538626.04,540142.54,0.00,0.00,1516.50,570204.00,0.00,0.00,0.00),('1','147','768','205725',3997708,'2139','326',540142.54,542389.55,0.00,0.00,2247.01,844875.76,0.00,0.00,0.00),('1','147','768','205943',4001562,'2139','326',542389.55,542869.69,0.00,0.00,480.14,180532.64,0.00,0.00,0.00),('1','147','768','206038',4003154,'2139','326',542869.69,543841.13,0.00,0.00,971.44,365261.44,0.00,0.00,0.00),('1','147','768','206194',4005899,'2139','326',543841.13,545634.45,0.00,0.00,1793.32,674288.32,0.00,0.00,0.00),('1','147','768','206437',4010127,'2139','326',545634.45,547870.69,0.00,0.00,2236.24,840826.24,0.00,0.00,0.00),('1','147','768','206618',4013273,'2139','326',547870.69,550536.00,0.00,0.00,2665.31,1002156.56,0.00,0.00,0.00),('1','147','768','206838',4017102,'2139','326',550536.00,552516.76,0.00,0.00,1980.76,744765.76,0.00,0.00,0.00),('1','147','768','207072',4021356,'2139','326',552516.76,553749.69,0.00,0.00,1232.93,463581.68,0.00,0.00,0.00),('1','147','768','207207',4023945,'2139','326',553749.69,554155.68,0.00,0.00,405.99,152652.24,0.00,0.00,0.00),('1','147','768','207258',4024782,'2139','326',554155.68,556554.06,0.00,0.00,2398.38,901790.88,0.00,0.00,0.00),('1','147','768','207509',4029315,'2139','326',556554.06,559072.72,0.00,0.00,2518.66,947016.16,0.00,0.00,0.00),('1','147','768','207757',4033425,'2139','326',559072.72,559618.69,0.00,0.00,545.97,209652.48,0.00,0.00,0.00),('1','147','768','207775',4033705,'2139','326',559618.69,560674.69,0.00,0.00,1056.00,405504.00,0.00,0.00,0.00),('1','147','768','207882',4035703,'2139','326',560674.69,561262.29,0.00,0.00,587.60,225638.40,0.00,0.00,0.00),('1','147','768','207987',4037438,'2139','326',561262.29,564206.72,0.00,0.00,2944.43,1130661.12,0.00,0.00,0.00),('1','147','768','208160',4040419,'2139','326',564206.72,565810.69,0.00,0.00,1603.97,615924.48,0.00,0.00,0.00),('1','147','768','208284',4043001,'2139','326',565810.69,566611.78,0.00,0.00,801.09,307618.56,0.00,0.00,0.00),('1','147','768','208378',4044379,'2139','326',566611.78,569361.97,0.00,0.00,2750.19,1056072.96,0.00,0.00,0.00),('1','147','768','208585',4047904,'2139','326',569361.97,570765.69,0.00,0.00,1403.72,539028.48,0.00,0.00,0.00),('1','147','768','208734',4050702,'2139','326',570765.69,571248.76,0.00,0.00,483.07,185498.88,0.00,0.00,0.00),('1','147','768','208826',4052024,'2139','326',571248.76,573369.98,0.00,0.00,2121.22,814548.48,0.00,0.00,0.00),('1','147','768','209036',4055631,'2139','326',573369.98,573452.01,0.00,0.00,82.03,31499.52,0.00,0.00,0.00),('1','147','768','209040',4055671,'2139','326',573452.01,575485.61,0.00,0.00,2033.60,813440.00,0.00,0.00,0.00),('1','147','768','209269',4059845,'2139','326',575485.61,576660.16,0.00,0.00,1174.55,469820.00,0.00,0.00,0.00),('1','147','768','209405',4062460,'2139','326',576660.16,577032.41,0.00,0.00,372.25,148900.00,0.00,0.00,0.00),('1','147','768','209441',4062915,'2139','326',577032.41,579219.86,0.00,0.00,2187.45,874980.00,0.00,0.00,0.00),('1','147','768','209640',4066552,'2139','326',579219.86,581610.69,0.00,0.00,2390.83,956332.00,0.00,0.00,0.00),('1','147','768','209855',4070376,'2139','326',581610.69,581644.69,0.00,0.00,34.00,13600.00,0.00,0.00,0.00),('1','147','768','209932',4071716,'2139','326',581644.69,583158.47,0.00,0.00,1513.78,635787.60,0.00,0.00,0.00),('1','147','768','210126',4075038,'2139','326',583158.47,585219.43,0.00,0.00,2060.96,865603.20,0.00,0.00,0.00),('1','147','768','210359',4079145,'2139','326',585219.43,586973.80,0.00,0.00,1754.37,736835.40,0.00,0.00,0.00),('1','147','768','210623',4084065,'2139','326',586973.80,587009.69,0.00,0.00,35.89,15073.80,0.00,0.00,0.00),('1','147','768','210628',4084120,'2139','326',587009.69,588261.05,0.00,0.00,1251.36,525571.20,0.00,0.00,0.00),('1','147','768','210774',4086623,'2139','326',588261.05,589700.65,0.00,0.00,1439.60,604632.00,0.00,0.00,0.00),('1','147','768','211001',4090365,'2139','326',589700.65,591799.91,0.00,0.00,2099.26,881689.20,0.00,0.00,0.00),('1','147','768','211252',4095120,'2139','326',591799.91,592401.69,0.00,0.00,601.78,252747.60,0.00,0.00,0.00),('1','147','768','211305',4096055,'2139','326',592401.69,594275.44,0.00,0.00,1873.75,786975.00,0.00,0.00,0.00),('1','147','768','211384',4097414,'2139','326',594275.44,597682.90,0.00,0.00,3407.46,1431133.20,0.00,0.00,0.00),('1','147','768','211650',4101995,'2139','326',597682.90,597993.69,0.00,0.00,310.79,130531.80,0.00,0.00,0.00),('1','147','768','211679',4102476,'2139','326',597993.69,598739.11,0.00,0.00,745.42,313076.40,0.00,0.00,0.00),('1','147','768','211783',4104130,'2139','326',598739.11,601524.46,0.00,0.00,2785.35,1169847.00,0.00,0.00,0.00),('1','147','768','211983',4107819,'2139','326',601524.46,602750.62,0.00,0.00,1226.16,514987.20,0.00,0.00,0.00),('1','147','768','212221',4112072,'2139','326',602750.62,603462.85,0.00,0.00,712.23,299136.60,0.00,0.00,0.00),('1','147','768','212730',4121069,'2139','326',603462.85,606040.01,0.00,0.00,2577.16,1082407.20,0.00,0.00,0.00),('1','147','768','212859',4123518,'2139','326',606040.01,607080.69,0.00,0.00,1040.68,437085.60,0.00,0.00,0.00),('1','147','768','213250',4130037,'2139','326',607080.69,608525.19,0.00,0.00,1444.50,606690.00,0.00,0.00,0.00),('1','147','768','213385',4132364,'2139','326',608525.19,610483.83,0.00,0.00,1958.64,822628.80,0.00,0.00,0.00),('1','147','768','213851',4140113,'2139','326',610483.83,612551.80,0.00,0.00,2067.97,868547.40,0.00,0.00,0.00),('1','147','768','213993',4142350,'2139','326',612551.80,614925.64,0.00,0.00,2373.84,997012.80,0.00,0.00,0.00),('1','147','768','214094',4144136,'2139','326',614925.64,617950.61,0.00,0.00,3024.97,1270487.40,0.00,0.00,0.00),('1','147','768','214493',4151121,'2139','326',617950.61,618421.91,0.00,0.00,471.30,197946.00,0.00,0.00,0.00),('1','147','768','214582',4152325,'2139','326',618421.91,619957.11,0.00,0.00,1535.20,644784.00,0.00,0.00,0.00),('1','147','768','214776',4155870,'2139','326',619957.11,622090.92,0.00,0.00,2133.81,896200.20,0.00,0.00,0.00),('1','147','768','214994',4159507,'2139','326',622090.92,623261.32,0.00,0.00,1170.40,491568.00,0.00,0.00,0.00),('1','147','768','215188',4162865,'2139','326',623261.32,623875.36,0.00,0.00,614.04,257896.80,0.00,0.00,0.00),('1','147','768','215214',4163426,'2139','326',623875.36,625694.16,0.00,0.00,1818.80,814822.40,0.00,0.00,0.00),('1','147','768','215442',4167081,'2139','326',625694.16,627313.69,0.00,0.00,1619.53,725549.44,0.00,0.00,0.00),('1','147','768','215747',4172237,'2139','326',627313.69,630054.92,0.00,0.00,2741.23,1228071.04,0.00,0.00,0.00),('1','147','768','215950',4175724,'2139','326',630054.92,632395.69,0.00,0.00,2340.77,1048664.96,0.00,0.00,0.00),('1','147','768','216214',4180274,'2139','326',632395.69,634104.27,0.00,0.00,1708.58,765443.84,0.00,0.00,0.00),('1','147','768','216364',4182805,'2139','326',634104.27,635824.76,0.00,0.00,1720.49,777661.48,0.00,0.00,0.00),('1','147','768','216546',4186247,'2139','326',635824.76,637459.69,0.00,0.00,1634.93,738988.36,0.00,0.00,0.00),('1','147','768','216936',4193008,'2139','326',637459.69,638145.83,0.00,0.00,686.14,310135.28,0.00,0.00,0.00),('1','147','768','217095',4195595,'2139','326',638145.83,640019.16,0.00,0.00,1873.33,899198.40,0.00,0.00,0.00),('1','147','768','217281',4199422,'2139','326',640019.16,642390.69,0.00,0.00,2371.53,1138334.40,0.00,0.00,0.00),('1','147','768','217541',4203739,'2139','326',642390.69,644825.10,0.00,0.00,2434.41,1168516.80,0.00,0.00,0.00),('1','147','768','217706',4206693,'2139','326',644825.10,646476.93,0.00,0.00,1651.83,792878.40,0.00,0.00,0.00),('1','147','768','217987',4211788,'2139','326',646476.93,647834.69,0.00,0.00,1357.76,651724.80,0.00,0.00,0.00),('1','147','768','218212',4215714,'2139','326',647834.69,649973.79,0.00,0.00,2139.10,1026768.00,0.00,0.00,0.00),('1','147','768','218436',4219749,'2139','326',649973.79,651617.99,0.00,0.00,1644.20,789216.00,0.00,0.00,0.00),('1','147','768','218726',4224629,'2139','326',651617.99,653204.69,0.00,0.00,1586.70,761616.00,0.00,0.00,0.00),('1','147','768','218903',4227991,'2139','326',653204.69,655755.21,0.00,0.00,2550.52,1224249.60,0.00,0.00,0.00),('1','147','768','219116',4231535,'2139','326',655755.21,658154.85,0.00,0.00,2399.64,1151827.20,0.00,0.00,0.00),('1','147','768','219355',4235545,'2139','326',658154.85,658928.69,0.00,0.00,773.84,371443.20,0.00,0.00,0.00),('1','147','768','219535',4238843,'2139','326',658928.69,659706.60,0.00,0.00,777.91,373396.80,0.00,0.00,0.00),('1','147','768','219614',4239935,'2139','326',659706.60,661711.18,0.00,0.00,2004.58,962198.40,0.00,0.00,0.00),('1','147','768','219814',4243745,'2139','326',661711.18,663431.38,0.00,0.00,1720.20,825696.00,0.00,0.00,0.00),('1','147','768','220038',4247856,'2139','326',663431.38,664170.69,0.00,0.00,739.31,354868.80,0.00,0.00,0.00),('1','147','768','220184',4250485,'2139','326',664170.69,665312.56,0.00,0.00,1141.87,548097.60,0.00,0.00,0.00),('1','147','768','220278',4251848,'2139','326',665312.56,667617.19,0.00,0.00,2304.63,1106222.40,0.00,0.00,0.00),('1','147','768','220462',4255559,'2139','326',667617.19,669482.69,0.00,0.00,1865.50,895440.00,0.00,0.00,0.00),('1','147','768','220681',4259237,'2139','326',669482.69,672605.75,0.00,0.00,3123.06,1499068.80,0.00,0.00,0.00),('1','147','768','220903',4263222,'2139','326',672605.75,674519.49,0.00,0.00,1913.74,918595.20,0.00,0.00,0.00),('1','147','768','221135',4267310,'2139','326',674519.49,674568.69,0.00,0.00,49.20,23616.00,0.00,0.00,0.00),('1','147','768','221234',4268831,'2139','326',674568.69,676323.90,0.00,0.00,1755.21,842500.80,0.00,0.00,0.00),('1','147','768','221423',4272242,'2139','326',676323.90,678730.67,0.00,0.00,2406.77,1155249.60,0.00,0.00,0.00),('1','147','768','221609',4276017,'2139','326',678730.67,679838.20,0.00,0.00,1107.53,531614.40,0.00,0.00,0.00),('1','147','768','221734',4278089,'2139','326',679838.20,681134.17,0.00,0.00,1295.97,622065.60,0.00,0.00,0.00),('1','147','768','221822',4279744,'2139','326',681134.17,683363.35,0.00,0.00,2229.18,1070006.40,0.00,0.00,0.00),('1','147','768','222054',4283971,'2139','326',683363.35,685009.69,0.00,0.00,1646.34,790243.20,0.00,0.00,0.00),('1','147','768','222270',4287509,'2139','326',685009.69,688353.67,0.00,0.00,3343.98,1605110.40,0.00,0.00,0.00),('1','147','768','222495',4291348,'2139','326',688353.67,689444.69,0.00,0.00,1091.02,523689.60,0.00,0.00,0.00),('1','147','768','222713',4295615,'2139','326',689444.69,690077.23,0.00,0.00,632.54,303619.20,0.00,0.00,0.00),('1','147','768','223134',4303216,'2139','326',690077.23,692056.38,0.00,0.00,1979.15,949992.00,0.00,0.00,0.00),('1','147','768','223135',4303217,'2139','326',692056.38,693963.55,0.00,0.00,1907.17,915441.60,0.00,0.00,0.00),('1','147','768','223172',4303724,'2139','326',693963.55,694763.38,0.00,0.00,799.83,383918.40,0.00,0.00,0.00),('1','147','768','223460',4308556,'2139','326',694763.38,695314.62,0.00,0.00,551.24,266251.52,0.00,0.00,0.00),('1','147','768','223514',4309470,'2139','326',695314.62,696248.38,0.00,0.00,933.76,478085.12,0.00,0.00,0.00),('1','147','768','223639',4312023,'2139','326',696248.38,697756.05,0.00,0.00,1507.67,771927.04,0.00,0.00,0.00),('1','147','768','223882',4316471,'2139','326',697756.05,699794.83,0.00,0.00,2038.78,1043855.36,0.00,0.00,0.00),('1','147','768','224055',4319620,'2139','326',699794.83,699919.16,0.00,0.00,124.33,63656.96,0.00,0.00,0.00),('1','147','768','224079',4319939,'2139','326',699919.16,701478.56,0.00,0.00,1559.40,798412.80,0.00,0.00,0.00),('1','147','768','224079',4319940,'2942','326',0.00,44.92,0.00,0.00,44.92,22999.04,0.00,0.00,0.00),('1','147','768','224301',4324050,'2139','326',701478.56,702839.77,0.00,0.00,1361.21,696939.52,0.00,0.00,0.00),('1','147','768','224301',4324051,'2942','326',44.92,424.32,0.00,0.00,379.40,194252.80,0.00,0.00,0.00),('1','147','768','224524',4327892,'2139','326',702839.77,703386.64,0.00,0.00,546.87,279997.44,0.00,0.00,0.00),('1','147','768','224524',4327893,'2942','326',424.32,791.79,0.00,0.00,367.47,188144.64,0.00,0.00,0.00),('1','147','768','224768',4332191,'2139','326',703386.64,703691.70,0.00,0.00,305.06,156190.72,0.00,0.00,0.00),('1','147','768','224768',4332192,'2942','326',791.79,2128.45,0.00,0.00,1336.66,684369.92,0.00,0.00,0.00),('1','147','768','225015',4336515,'2139','326',703691.70,703847.93,0.00,0.00,156.23,80277.76,0.00,0.00,0.00),('1','147','768','225015',4336516,'2942','326',2128.45,2693.35,0.00,0.00,564.90,289228.80,0.00,0.00,0.00),('1','147','768','225165',4339229,'2139','326',703847.93,704031.35,0.00,0.00,183.42,93911.04,0.00,0.00,0.00),('1','147','768','225165',4339230,'2942','326',2693.35,3336.54,0.00,0.00,643.19,329313.28,0.00,0.00,0.00),('1','147','768','225260',4341020,'2139','326',704031.35,704322.82,0.00,0.00,291.47,149232.64,0.00,0.00,0.00),('1','147','768','225260',4341021,'2942','326',3336.54,5378.50,0.00,0.00,2041.96,1045483.52,0.00,0.00,0.00),('1','147','768','225477',4345030,'2139','326',704322.82,705454.25,0.00,0.00,1131.43,579292.16,0.00,0.00,0.00),('1','147','768','225477',4345031,'2942','326',5378.50,6244.15,0.00,0.00,865.65,443212.80,0.00,0.00,0.00),('1','147','768','225687',4348649,'2139','326',705454.25,705843.01,0.00,0.00,388.76,199045.12,0.00,0.00,0.00),('1','147','768','225687',4348650,'2942','326',6244.15,6420.65,0.00,0.00,176.50,90368.00,0.00,0.00,0.00),('1','147','768','225804',4350442,'2139','326',705843.01,706073.26,0.00,0.00,230.25,125256.00,0.00,0.00,0.00),('1','147','768','225804',4350443,'2942','326',6420.65,7382.09,0.00,0.00,961.44,523023.36,0.00,0.00,0.00),('1','147','768','225963',4353316,'2139','326',706073.26,706849.67,0.00,0.00,776.41,422367.04,0.00,0.00,0.00),('1','147','768','225963',4353317,'2942','326',7382.09,8306.37,0.00,0.00,924.28,502808.32,0.00,0.00,0.00),('1','147','768','226247',4358542,'2139','326',706849.67,707160.55,0.00,0.00,310.88,169118.72,0.00,0.00,0.00),('1','147','768','226247',4358543,'2942','326',8306.37,9609.20,0.00,0.00,1302.83,708739.52,0.00,0.00,0.00),('1','147','768','226472',4362521,'2139','326',707160.55,707289.43,0.00,0.00,128.88,70110.72,0.00,0.00,0.00),('1','147','768','226472',4362522,'2942','326',9609.20,9636.69,0.00,0.00,27.49,14954.56,0.00,0.00,0.00),('1','147','768','226529',4363352,'2139','326',707289.43,707788.26,0.00,0.00,498.83,271363.52,0.00,0.00,0.00),('1','147','768','226529',4363353,'2942','326',9636.69,10715.50,0.00,0.00,1078.81,586872.64,0.00,0.00,0.00),('1','147','768','226723',4367165,'2139','326',707788.26,709204.86,0.00,0.00,1416.60,770630.40,0.00,0.00,0.00),('1','147','768','226723',4367166,'2942','326',10715.50,11447.78,0.00,0.00,732.28,398360.32,0.00,0.00,0.00),('1','147','768','226957',4371309,'2139','326',709204.86,710237.41,0.00,0.00,1032.55,561707.20,0.00,0.00,0.00),('1','147','768','226957',4371310,'2942','326',11447.78,11905.09,0.00,0.00,457.31,248776.64,0.00,0.00,0.00),('1','147','768','227111',4373876,'2139','326',710237.41,710918.50,0.00,0.00,681.09,370512.96,0.00,0.00,0.00),('1','147','768','227111',4373877,'2942','326',11905.09,12068.05,0.00,0.00,162.96,88650.24,0.00,0.00,0.00),('1','147','768','227183',4375243,'2139','326',710918.50,712703.19,0.00,0.00,1784.69,970871.36,0.00,0.00,0.00),('1','147','768','227183',4375244,'2942','326',12068.05,12916.72,0.00,0.00,848.67,461676.48,0.00,0.00,0.00),('1','147','768','227368',4378518,'2139','326',712703.19,713873.20,0.00,0.00,1170.01,636485.44,0.00,0.00,0.00),('1','147','768','227368',4378519,'2942','326',12916.72,13474.32,0.00,0.00,557.60,303334.40,0.00,0.00,0.00),('1','147','768','227604',4382541,'2139','326',713873.20,715209.71,0.00,0.00,1336.51,727061.44,0.00,0.00,0.00),('1','147','768','227604',4382542,'2942','326',13474.32,14220.91,0.00,0.00,746.59,406144.96,0.00,0.00,0.00),('1','147','768','227846',4386896,'2139','326',715209.71,715477.37,0.00,0.00,267.66,145607.04,0.00,0.00,0.00),('1','147','768','227846',4386897,'2942','326',14220.91,14354.80,0.00,0.00,133.89,72836.16,0.00,0.00,0.00),('1','147','768','227913',4387906,'2139','326',715477.37,715866.56,0.00,0.00,389.19,211719.36,0.00,0.00,0.00),('1','147','768','227913',4387907,'2942','326',14354.80,15558.49,0.00,0.00,1203.69,654807.36,0.00,0.00,0.00),('1','147','768','228112',4391958,'2139','326',715866.56,716750.15,0.00,0.00,883.59,480672.96,0.00,0.00,0.00),('1','147','768','228112',4391959,'2942','326',15558.49,17007.20,0.00,0.00,1448.71,788098.24,0.00,0.00,0.00),('1','147','768','228345',4396433,'2139','326',716750.15,716780.67,0.00,0.00,30.52,16602.88,0.00,0.00,0.00),('1','147','768','228345',4396434,'2942','326',17007.20,17158.46,0.00,0.00,151.26,82918.88,0.00,0.00,0.00),('1','147','768','228375',4396863,'2139','326',716780.67,717011.02,0.00,0.00,230.35,128996.00,0.00,0.00,0.00),('1','147','768','228375',4396864,'2942','326',17158.46,19354.74,0.00,0.00,2196.28,1229916.80,0.00,0.00,0.00),('1','147','768','228528',4399842,'2139','326',717011.02,718040.20,0.00,0.00,1029.18,576340.80,0.00,0.00,0.00),('1','147','768','228528',4399843,'2942','326',19354.74,20759.21,0.00,0.00,1404.47,786503.20,0.00,0.00,0.00),('1','147','768','228749',4404050,'2139','326',718040.20,719094.49,0.00,0.00,1054.29,590402.40,0.00,0.00,0.00),('1','147','768','228749',4404051,'2942','326',20759.21,22855.18,0.00,0.00,2095.97,1173743.20,0.00,0.00,0.00),('1','147','768','228937',4407417,'2139','326',719094.49,720712.68,0.00,0.00,1618.19,906186.40,0.00,0.00,0.00),('1','147','768','228937',4407418,'2942','326',22855.18,23253.89,0.00,0.00,398.71,223277.60,0.00,0.00,0.00),('1','147','768','229166',4411959,'2139','326',720712.68,721170.31,0.00,0.00,457.63,256272.80,0.00,0.00,0.00),('1','147','768','229166',4411960,'2942','326',23253.89,24806.59,0.00,0.00,1552.70,869512.00,0.00,0.00,0.00),('1','147','768','229407',4416263,'2139','326',721170.31,722074.97,0.00,0.00,904.66,528321.44,0.00,0.00,0.00),('1','147','768','229407',4416264,'2942','326',24806.59,25949.64,0.00,0.00,1143.05,667541.20,0.00,0.00,0.00),('1','147','768','229655',4421099,'2139','326',722074.97,723817.78,0.00,0.00,1742.81,1017801.04,0.00,0.00,0.00),('1','147','768','229655',4421100,'2942','326',25949.64,26396.06,0.00,0.00,446.42,260709.28,0.00,0.00,0.00),('1','147','768','229884',4425615,'2139','326',723817.78,724186.76,0.00,0.00,368.98,215484.32,0.00,0.00,0.00),('1','147','768','229884',4425616,'2942','326',26396.06,26593.44,0.00,0.00,197.38,115269.92,0.00,0.00,0.00),('1','147','768','229941',4426488,'2139','326',724186.76,725259.91,0.00,0.00,1073.15,626719.60,0.00,0.00,0.00),('1','147','768','229941',4426489,'2942','326',26593.44,26901.62,0.00,0.00,308.18,179977.12,0.00,0.00,0.00),('1','147','768','230087',4429338,'2139','326',725259.91,725872.30,0.00,0.00,612.39,357635.76,0.00,0.00,0.00),('1','147','768','230087',4429339,'2942','326',26901.62,28738.33,0.00,0.00,1836.71,1072638.64,0.00,0.00,0.00),('1','147','768','230287',4433076,'2139','326',725872.30,727799.50,0.00,0.00,1927.20,1125484.80,0.00,0.00,0.00),('1','147','768','230287',4433077,'2942','326',28738.33,29570.33,0.00,0.00,832.00,485888.00,0.00,0.00,0.00),('1','147','768','230519',4437506,'2139','326',727799.50,729130.86,0.00,0.00,1331.36,777514.24,0.00,0.00,0.00),('1','147','768','230519',4437507,'2942','326',29570.33,30053.23,0.00,0.00,482.90,282013.60,0.00,0.00,0.00),('1','147','768','230791',4442179,'2139','326',729130.86,730474.62,0.00,0.00,1343.76,784755.84,0.00,0.00,0.00),('1','147','768','230791',4442180,'2942','326',30053.23,30284.45,0.00,0.00,231.22,135032.48,0.00,0.00,0.00),('1','147','768','231057',4446890,'2139','326',730474.62,731840.84,0.00,0.00,1366.22,797872.48,0.00,0.00,0.00),('1','147','768','231057',4446891,'2942','326',30284.45,30586.54,0.00,0.00,302.09,176420.56,0.00,0.00,0.00),('1','147','768','231377',4451842,'2139','326',731840.84,733226.32,0.00,0.00,1385.48,809120.32,0.00,0.00,0.00),('1','147','768','231377',4451843,'2942','326',30586.54,30796.52,0.00,0.00,209.98,122628.32,0.00,0.00,0.00),('1','147','768','231637',4456420,'2139','326',733226.32,734437.13,0.00,0.00,1210.81,707113.04,0.00,0.00,0.00),('1','147','768','231637',4456421,'2942','326',30796.52,31081.14,0.00,0.00,284.62,166218.08,0.00,0.00,0.00),('1','147','768','232110',4464982,'2139','326',734437.13,736731.51,0.00,0.00,2294.38,1339917.92,0.00,0.00,0.00),('1','147','768','232110',4464983,'2942','326',31081.14,31523.47,0.00,0.00,442.33,258320.72,0.00,0.00,0.00),('1','147','768','232333',4468923,'2139','326',736731.51,737152.42,0.00,0.00,420.91,245811.44,0.00,0.00,0.00),('1','147','768','232333',4468924,'2942','326',31523.47,32123.39,0.00,0.00,599.92,350353.28,0.00,0.00,0.00),('1','147','768','232585',4473605,'2139','326',737152.42,738421.48,0.00,0.00,1269.06,761436.00,0.00,0.00,0.00),('1','147','768','232585',4473606,'2942','326',32123.39,32420.90,0.00,0.00,297.51,178506.00,0.00,0.00,0.00),('1','147','768','232845',4478215,'2139','326',738421.48,739756.77,0.00,0.00,1335.29,801174.00,0.00,0.00,0.00),('1','147','768','232845',4478216,'2942','326',32420.90,33008.52,0.00,0.00,587.62,352572.00,0.00,0.00,0.00),('1','147','768','233117',4483045,'2139','326',739756.77,740861.95,0.00,0.00,1105.18,663108.00,0.00,0.00,0.00),('1','147','768','233117',4483046,'2942','326',33008.52,33626.53,0.00,0.00,618.01,370806.00,0.00,0.00,0.00),('1','147','768','233369',4487677,'2139','326',740861.95,742069.31,0.00,0.00,1207.36,753392.64,0.00,0.00,0.00),('1','147','768','233369',4487678,'2942','326',33626.53,34068.86,0.00,0.00,442.33,276013.92,0.00,0.00,0.00),('1','147','768','233604',4492002,'2139','326',742069.31,743680.22,0.00,0.00,1610.91,1005207.84,0.00,0.00,0.00),('1','147','768','233604',4492003,'2942','326',34068.86,34793.91,0.00,0.00,725.05,452431.20,0.00,0.00,0.00),('1','147','768','233842',4496200,'2139','326',743680.22,745488.69,0.00,0.00,1808.47,1128485.28,0.00,0.00,0.00),('1','147','768','233842',4496201,'2942','326',34793.91,35491.26,0.00,0.00,697.35,435146.40,0.00,0.00,0.00),('1','147','768','234059',4499998,'2139','326',745488.69,745655.25,0.00,0.00,166.56,103933.44,0.00,0.00,0.00),('1','147','768','234059',4499999,'2942','326',35491.26,36839.03,0.00,0.00,1347.77,841008.48,0.00,0.00,0.00),('1','147','768','234318',4504753,'2139','326',745655.25,746162.62,0.00,0.00,507.37,316598.88,0.00,0.00,0.00),('1','147','768','234318',4504754,'2942','326',36839.03,38274.65,0.00,0.00,1435.62,895826.88,0.00,0.00,0.00),('1','147','768','234554',4509092,'2139','326',746162.62,746188.57,0.00,0.00,25.95,16192.80,0.00,0.00,0.00),('1','147','768','234554',4509093,'2942','326',38274.65,39884.74,0.00,0.00,1610.09,1004696.16,0.00,0.00,0.00),('1','147','768','234817',4513693,'2139','326',746188.57,746287.35,0.00,0.00,98.78,61638.72,0.00,0.00,0.00),('1','147','768','234817',4513694,'2942','326',39884.74,41563.05,0.00,0.00,1678.31,1047265.44,0.00,0.00,0.00),('1','147','768','235057',4518060,'2139','326',746287.35,746604.40,0.00,0.00,317.05,197839.20,0.00,0.00,0.00),('1','147','768','235057',4518061,'2942','326',41563.05,42816.95,0.00,0.00,1253.90,782433.60,0.00,0.00,0.00),('1','147','768','235309',4522259,'2139','326',746604.40,747087.50,0.00,0.00,483.10,301454.40,0.00,0.00,0.00),('1','147','768','235309',4522260,'2942','326',42816.95,44827.86,0.00,0.00,2010.91,1254807.84,0.00,0.00,0.00),('1','147','768','235516',4525958,'2139','326',747087.50,747362.40,0.00,0.00,274.90,171537.60,0.00,0.00,0.00),('1','147','768','235516',4525959,'2942','326',44827.86,47333.87,0.00,0.00,2506.01,1563750.24,0.00,0.00,0.00),('1','147','768','235745',4530068,'2139','326',747362.40,748940.24,0.00,0.00,1577.84,1009721.44,0.00,0.00,0.00),('1','147','768','235745',4530069,'2942','326',47333.87,47671.02,0.00,0.00,337.15,215776.00,0.00,0.00,0.00),('1','147','768','236009',4534536,'2139','326',748940.24,749194.18,0.00,0.00,253.94,162521.60,0.00,0.00,0.00),('1','147','768','236009',4534537,'2942','326',47671.02,48928.06,0.00,0.00,1257.04,804505.60,0.00,0.00,0.00),('1','147','768','236269',4539058,'2139','326',749194.18,750216.98,0.00,0.00,1022.80,654592.00,0.00,0.00,0.00),('1','147','768','236269',4539059,'2942','326',48928.06,49652.57,0.00,0.00,724.51,463686.40,0.00,0.00,0.00),('1','147','768','236501',4543389,'2139','326',750216.98,750898.15,0.00,0.00,681.17,435948.80,0.00,0.00,0.00),('1','147','768','236501',4543390,'2942','326',49652.57,51111.30,0.00,0.00,1458.73,933587.20,0.00,0.00,0.00),('1','147','768','236718',4547041,'2139','326',750898.15,751372.97,0.00,0.00,474.82,303884.80,0.00,0.00,0.00),('1','147','768','236718',4547042,'2942','326',51111.30,52108.69,0.00,0.00,997.39,638329.60,0.00,0.00,0.00),('1','147','768','236894',4550038,'2139','326',751372.97,751416.88,0.00,0.00,43.91,28102.40,0.00,0.00,0.00),('1','147','768','236894',4550039,'2942','326',52108.69,52335.73,0.00,0.00,227.04,145305.60,0.00,0.00,0.00),('1','147','768','236951',4551112,'2139','326',751416.88,753194.69,0.00,0.00,1777.81,1137798.40,0.00,0.00,0.00),('1','147','768','236951',4551113,'2942','326',52335.73,53514.07,0.00,0.00,1178.34,754137.60,0.00,0.00,0.00),('1','147','768','237175',4554978,'2139','326',753194.69,754211.32,0.00,0.00,1016.63,650643.20,0.00,0.00,0.00),('1','147','768','237175',4554979,'2942','326',53514.07,54759.24,0.00,0.00,1245.17,796908.80,0.00,0.00,0.00),('1','147','768','237375',4558712,'2139','326',754211.32,755614.38,0.00,0.00,1403.06,897958.40,0.00,0.00,0.00),('1','147','768','237375',4558713,'2942','326',54759.24,55317.67,0.00,0.00,558.43,357395.20,0.00,0.00,0.00),('1','147','768','237597',4562704,'2139','326',755614.38,756833.83,0.00,0.00,1219.45,799959.20,0.00,0.00,0.00),('1','147','768','237597',4562705,'2942','326',55317.67,56094.93,0.00,0.00,777.26,509882.56,0.00,0.00,0.00),('1','147','768','237879',4567230,'2139','326',756833.83,757702.52,0.00,0.00,868.69,555961.60,0.00,0.00,0.00),('1','147','768','237879',4567231,'2942','326',56094.93,56563.57,0.00,0.00,468.64,299929.60,0.00,0.00,0.00),('1','147','768','238045',4570017,'2139','326',757702.52,757849.65,0.00,0.00,147.13,94163.20,0.00,0.00,0.00),('1','147','768','238045',4570018,'2942','326',56563.57,56919.65,0.00,0.00,356.08,227891.20,0.00,0.00,0.00),('1','147','768','238163',4571780,'2139','326',757849.65,758713.97,0.00,0.00,864.32,553164.80,0.00,0.00,0.00),('1','147','768','238163',4571781,'2942','326',56919.65,57773.80,0.00,0.00,854.15,546656.00,0.00,0.00,0.00),('1','147','768','238355',4575256,'2139','326',758713.97,759883.00,0.00,0.00,1169.03,748179.20,0.00,0.00,0.00),('1','147','768','238355',4575257,'2942','326',57773.80,58486.26,0.00,0.00,712.46,455974.40,0.00,0.00,0.00),('1','147','768','238590',4579291,'2139','326',759883.00,760309.32,0.00,0.00,426.32,272844.80,0.00,0.00,0.00),('1','147','768','238590',4579292,'2942','326',58486.26,59403.40,0.00,0.00,917.14,586969.60,0.00,0.00,0.00),('1','147','768','238713',4581314,'2139','326',760309.32,761301.15,0.00,0.00,991.83,634771.20,0.00,0.00,0.00),('1','147','768','238713',4581315,'2942','326',59403.40,59669.11,0.00,0.00,265.71,170054.40,0.00,0.00,0.00),('1','147','768','238822',4583329,'2139','326',761301.15,762603.62,0.00,0.00,1302.47,833580.80,0.00,0.00,0.00),('1','147','768','238822',4583330,'2942','326',59669.11,60422.76,0.00,0.00,753.65,482336.00,0.00,0.00,0.00),('1','147','768','239058',4587540,'2139','326',762603.62,763786.63,0.00,0.00,1183.01,757126.40,0.00,0.00,0.00),('1','147','768','239058',4587541,'2942','326',60422.76,60824.31,0.00,0.00,401.55,256992.00,0.00,0.00,0.00),('1','147','768','239278',4591343,'2139','326',763786.63,764267.52,0.00,0.00,480.89,307769.60,0.00,0.00,0.00),('1','147','768','239278',4591344,'2942','326',60824.31,60899.62,0.00,0.00,75.31,48198.40,0.00,0.00,0.00),('1','147','768','239542',4595644,'2139','326',764267.52,765212.04,0.00,0.00,944.52,604492.80,0.00,0.00,0.00),('1','147','768','239542',4595645,'2942','326',60899.62,61711.63,0.00,0.00,812.01,519686.40,0.00,0.00,0.00),('1','147','768','239771',4599711,'2139','326',765212.04,766243.48,0.00,0.00,1031.44,660121.60,0.00,0.00,0.00),('1','147','768','239771',4599712,'2942','326',61711.63,62380.80,0.00,0.00,669.17,428268.80,0.00,0.00,0.00),('1','147','768','239986',4603547,'2139','326',766243.48,767402.74,0.00,0.00,1159.26,741926.40,0.00,0.00,0.00),('1','147','768','239986',4603548,'2942','326',62380.80,62811.72,0.00,0.00,430.92,275788.80,0.00,0.00,0.00),('1','147','768','240187',4607096,'2139','326',767402.74,767809.42,0.00,0.00,406.68,260275.20,0.00,0.00,0.00),('1','147','768','240187',4607097,'2942','326',62811.72,62907.83,0.00,0.00,96.11,61510.40,0.00,0.00,0.00),('1','147','768','240256',4608227,'2139','326',767809.42,769303.11,0.00,0.00,1493.69,955961.60,0.00,0.00,0.00),('1','147','768','240256',4608228,'2942','326',62907.83,63289.63,0.00,0.00,381.80,244352.00,0.00,0.00,0.00),('1','147','768','240443',4611202,'2139','326',769303.11,771000.17,0.00,0.00,1697.06,1086118.40,0.00,0.00,0.00),('1','147','768','240443',4611203,'2942','326',63289.63,63713.96,0.00,0.00,424.33,271571.20,0.00,0.00,0.00),('1','147','768','240686',4614919,'2139','326',771000.17,771902.03,0.00,0.00,901.86,577190.40,0.00,0.00,0.00),('1','147','768','240686',4614920,'2942','326',63713.96,64234.33,0.00,0.00,520.37,333036.80,0.00,0.00,0.00),('1','147','768','240972',4619983,'2139','326',771902.03,773216.84,0.00,0.00,1314.81,841478.40,0.00,0.00,0.00),('1','147','768','240972',4619984,'2942','326',64234.33,64737.97,0.00,0.00,503.64,322329.60,0.00,0.00,0.00),('1','147','768','241216',4624449,'2139','326',773216.84,774667.75,0.00,0.00,1450.91,928582.40,0.00,0.00,0.00),('1','147','768','241216',4624450,'2942','326',64737.97,65213.70,0.00,0.00,475.73,304467.20,0.00,0.00,0.00),('1','147','768','241481',4628932,'2139','326',774667.75,775006.45,0.00,0.00,338.70,216768.00,0.00,0.00,0.00),('1','147','768','241481',4628933,'2942','326',65213.70,65420.93,0.00,0.00,207.23,132627.20,0.00,0.00,0.00),('1','147','768','241600',4630872,'2139','326',775006.45,775700.83,0.00,0.00,694.38,444403.20,0.00,0.00,0.00),('1','147','768','241600',4630873,'2942','326',65420.93,65814.87,0.00,0.00,393.94,252121.60,0.00,0.00,0.00),('1','147','768','241719',4633172,'2139','326',775700.83,777318.19,0.00,0.00,1617.36,1035110.40,0.00,0.00,0.00),('1','147','768','241719',4633173,'2942','326',65814.87,66437.38,0.00,0.00,622.51,398406.40,0.00,0.00,0.00),('1','147','768','241965',4637332,'2139','326',777318.19,778861.96,0.00,0.00,1543.77,988012.80,0.00,0.00,0.00),('1','147','768','241965',4637333,'2942','326',66437.38,66977.38,0.00,0.00,540.00,345600.00,0.00,0.00,0.00),('1','147','768','242192',4641419,'2139','326',778861.96,780862.64,0.00,0.00,2000.68,1280435.20,0.00,0.00,0.00),('1','147','768','242192',4641420,'2942','326',66977.38,67712.81,0.00,0.00,735.43,470675.20,0.00,0.00,0.00),('1','147','768','242418',4645327,'2139','326',780862.64,782047.69,0.00,0.00,1185.05,758432.00,0.00,0.00,0.00),('1','147','768','242418',4645328,'2942','326',67712.81,68278.60,0.00,0.00,565.79,362105.60,0.00,0.00,0.00),('1','147','768','242667',4649698,'2139','326',782047.69,782229.96,0.00,0.00,182.27,116652.80,0.00,0.00,0.00),('1','147','768','242667',4649699,'2942','326',68278.60,68598.10,0.00,0.00,319.50,204480.00,0.00,0.00,0.00),('1','147','768','242763',4651281,'2139','326',782229.96,783243.41,0.00,0.00,1013.45,648608.00,0.00,0.00,0.00),('1','147','768','242763',4651282,'2942','326',68598.10,69249.98,0.00,0.00,651.88,417203.20,0.00,0.00,0.00),('1','147','768','242906',4653737,'2139','326',783243.41,784692.72,0.00,0.00,1449.31,927558.40,0.00,0.00,0.00),('1','147','768','242906',4653738,'2942','326',69249.98,69587.56,0.00,0.00,337.58,216051.20,0.00,0.00,0.00),('1','147','768','243127',4657599,'2139','326',784692.72,786052.74,0.00,0.00,1360.02,870412.80,0.00,0.00,0.00),('1','147','768','243127',4657600,'2942','326',69587.56,69942.05,0.00,0.00,354.49,226873.60,0.00,0.00,0.00),('1','147','768','243382',4662012,'2139','326',786052.74,787154.54,0.00,0.00,1101.80,705152.00,0.00,0.00,0.00),('1','147','768','243382',4662013,'2942','326',69942.05,70834.00,0.00,0.00,891.95,570848.00,0.00,0.00,0.00),('1','147','768','243593',4665719,'2139','326',787154.54,788897.47,0.00,0.00,1742.93,1115475.20,0.00,0.00,0.00),('1','147','768','243593',4665720,'2942','326',70834.00,71607.42,0.00,0.00,773.42,494988.80,0.00,0.00,0.00),('1','147','768','243819',4669760,'2139','326',788897.47,789793.95,0.00,0.00,896.48,573747.20,0.00,0.00,0.00),('1','147','768','243819',4669761,'2942','326',71607.42,71936.61,0.00,0.00,329.19,210681.60,0.00,0.00,0.00),('1','147','768','243924',4671459,'2139','326',789793.95,790625.41,0.00,0.00,831.46,532134.40,0.00,0.00,0.00),('1','147','768','243924',4671460,'2942','326',71936.61,72249.14,0.00,0.00,312.53,200019.20,0.00,0.00,0.00),('1','147','768','244036',4673543,'2139','326',790625.41,792259.21,0.00,0.00,1633.80,1045632.00,0.00,0.00,0.00),('1','147','768','244036',4673544,'2942','326',72249.14,72755.19,0.00,0.00,506.05,323872.00,0.00,0.00,0.00),('1','147','768','244314',4677930,'2139','326',792259.21,793359.37,0.00,0.00,1100.16,704102.40,0.00,0.00,0.00),('1','147','768','244314',4677931,'2942','326',72755.19,73309.15,0.00,0.00,553.96,354534.40,0.00,0.00,0.00),('1','147','768','244512',4681612,'2139','326',793359.37,793588.99,0.00,0.00,229.62,146956.80,0.00,0.00,0.00),('1','147','768','244512',4681613,'2942','326',73309.15,73509.38,0.00,0.00,200.23,128147.20,0.00,0.00,0.00),('1','147','768','244583',4682678,'2139','326',793588.99,794062.30,0.00,0.00,473.31,302918.40,0.00,0.00,0.00),('1','147','768','244583',4682679,'2942','326',73509.38,73895.44,0.00,0.00,386.06,247078.40,0.00,0.00,0.00),('1','147','768','244728',4685322,'2139','326',794062.30,795761.84,0.00,0.00,1699.54,1087705.60,0.00,0.00,0.00),('1','147','768','244728',4685323,'2942','326',73895.44,74621.39,0.00,0.00,725.95,464608.00,0.00,0.00,0.00),('1','147','768','244966',4689530,'2139','326',795761.84,797061.48,0.00,0.00,1299.64,821372.48,0.00,0.00,0.00),('1','147','768','244966',4689531,'2942','326',74621.39,75081.28,0.00,0.00,459.89,290650.48,0.00,0.00,0.00),('1','147','768','245213',4693830,'2139','326',797061.48,799299.25,0.00,0.00,2237.77,1414270.64,0.00,0.00,0.00),('1','147','768','245213',4693831,'2942','326',75081.28,75947.06,0.00,0.00,865.78,547172.96,0.00,0.00,0.00),('1','147','768','245426',4697593,'2139','326',799299.25,800809.46,0.00,0.00,1510.21,954452.72,0.00,0.00,0.00),('1','147','768','245426',4697594,'2942','326',75947.06,76518.15,0.00,0.00,571.09,360928.88,0.00,0.00,0.00),('1','147','768','245598',4700664,'2139','326',800809.46,801062.22,0.00,0.00,252.76,159744.32,0.00,0.00,0.00),('1','147','768','245598',4700665,'2942','326',76518.15,76596.45,0.00,0.00,78.30,49485.60,0.00,0.00,0.00),('1','147','768','245665',4701765,'2139','326',801062.22,802415.15,0.00,0.00,1352.93,855051.76,0.00,0.00,0.00),('1','147','768','245665',4701766,'2942','326',76596.45,77019.57,0.00,0.00,423.12,267411.84,0.00,0.00,0.00),('1','147','768','245926',4705756,'2139','326',802415.15,804001.05,0.00,0.00,1585.90,976914.40,0.00,0.00,0.00),('1','147','768','245926',4705757,'2942','326',77019.57,77578.08,0.00,0.00,558.51,344042.16,0.00,0.00,0.00),('1','147','768','246181',4710026,'2139','326',804001.05,804947.39,0.00,0.00,946.34,582945.44,0.00,0.00,0.00),('1','147','768','246181',4710027,'2942','326',77578.08,77826.61,0.00,0.00,248.53,153094.48,0.00,0.00,0.00),('1','147','768','246346',4712563,'2139','326',804947.39,805906.26,0.00,0.00,958.87,590663.92,0.00,0.00,0.00),('1','147','768','246346',4712564,'2942','326',77826.61,78020.30,0.00,0.00,193.69,119313.04,0.00,0.00,0.00),('1','147','768','246443',4714418,'2139','326',805906.26,807881.00,0.00,0.00,1974.74,1216439.84,0.00,0.00,0.00),('1','147','768','246443',4714419,'2942','326',78020.30,78491.28,0.00,0.00,470.98,290123.68,0.00,0.00,0.00),('1','147','768','246688',4718698,'2139','326',807881.00,808950.76,0.00,0.00,1069.76,658972.16,0.00,0.00,0.00),('1','147','768','246688',4718699,'2942','326',78491.28,78928.38,0.00,0.00,437.10,269253.60,0.00,0.00,0.00),('1','147','768','246860',4721742,'2139','326',808950.76,809304.40,0.00,0.00,353.64,217842.24,0.00,0.00,0.00),('1','147','768','246860',4721743,'2942','326',78928.38,79067.91,0.00,0.00,139.53,85950.48,0.00,0.00,0.00),('1','147','768','246921',4722932,'2139','326',809304.40,811513.55,0.00,0.00,2209.15,1360836.40,0.00,0.00,0.00),('1','147','768','246921',4722933,'2942','326',79067.91,79703.58,0.00,0.00,635.67,391572.72,0.00,0.00,0.00),('1','147','768','247159',4726873,'2139','326',811513.55,812930.43,0.00,0.00,1416.88,872798.08,0.00,0.00,0.00),('1','147','768','247159',4726874,'2942','326',79703.58,80117.20,0.00,0.00,413.62,254789.92,0.00,0.00,0.00),('1','147','768','247301',4729410,'2139','326',812930.43,813550.30,0.00,0.00,619.87,381839.92,0.00,0.00,0.00),('1','147','768','247301',4729411,'2942','326',80117.20,80319.51,0.00,0.00,202.31,124622.96,0.00,0.00,0.00),('1','147','768','247385',4730929,'2139','326',813550.30,815339.98,0.00,0.00,1789.68,1102442.88,0.00,0.00,0.00),('1','147','768','247385',4730930,'2942','326',80319.51,80830.13,0.00,0.00,510.62,314541.92,0.00,0.00,0.00),('1','147','768','247657',4735430,'2139','326',815339.98,816331.98,0.00,0.00,992.00,611072.00,0.00,0.00,0.00),('1','147','768','247657',4735431,'2942','326',80830.13,81132.84,0.00,0.00,302.71,186469.36,0.00,0.00,0.00),('1','147','768','247759',4737105,'2139','326',816331.98,817003.23,0.00,0.00,671.25,397796.88,0.00,0.00,0.00),('1','147','768','247759',4737106,'2942','326',81132.84,81390.69,0.00,0.00,257.85,152744.64,0.00,0.00,0.00),('1','147','768','247931',4739821,'2139','326',817003.23,818939.42,0.00,0.00,1936.19,1146224.48,0.00,0.00,0.00),('1','147','768','247931',4739822,'2942','326',81390.69,81999.19,0.00,0.00,608.50,360232.00,0.00,0.00,0.00),('1','147','768','248144',4743720,'2139','326',818939.42,821288.06,0.00,0.00,2348.64,1390394.88,0.00,0.00,0.00),('1','147','768','248144',4743721,'2942','326',81999.19,82402.75,0.00,0.00,403.56,238907.52,0.00,0.00,0.00),('1','147','768','248388',4747854,'2139','326',821288.06,821393.02,0.00,0.00,104.96,62136.32,0.00,0.00,0.00),('1','147','768','248388',4747855,'2942','326',82402.75,82433.83,0.00,0.00,31.08,18399.36,0.00,0.00,0.00),('1','147','768','248422',4748180,'2139','326',821393.02,824186.84,0.00,0.00,2793.82,1653941.44,0.00,0.00,0.00),('1','147','768','248422',4748181,'2942','326',82433.83,83331.98,0.00,0.00,898.15,531704.80,0.00,0.00,0.00),('1','147','768','248629',4751881,'2139','326',824186.84,825417.93,0.00,0.00,1231.09,728805.28,0.00,0.00,0.00),('1','147','768','248629',4751882,'2942','326',83331.98,83833.18,0.00,0.00,501.20,296710.40,0.00,0.00,0.00),('1','147','768','248733',4753625,'2139','326',825417.93,826345.92,0.00,0.00,927.99,549370.08,0.00,0.00,0.00),('1','147','768','248733',4753626,'2942','326',83833.18,84143.64,0.00,0.00,310.46,183792.32,0.00,0.00,0.00),('1','147','768','248894',4756264,'2139','326',826345.92,827637.67,0.00,0.00,1291.75,764716.00,0.00,0.00,0.00),('1','147','768','248894',4756265,'2942','326',84143.64,85072.62,0.00,0.00,928.98,549956.16,0.00,0.00,0.00),('1','147','768','249096',4759761,'2139','326',827637.67,828820.73,0.00,0.00,1183.06,700371.52,0.00,0.00,0.00),('1','147','768','249096',4759762,'2942','326',85072.62,85751.92,0.00,0.00,679.30,402145.60,0.00,0.00,0.00),('1','147','768','249387',4764424,'2139','326',828820.73,829297.39,0.00,0.00,476.66,282182.72,0.00,0.00,0.00),('1','147','768','249387',4764425,'2942','326',85751.92,86260.72,0.00,0.00,508.80,301209.60,0.00,0.00,0.00),('1','147','768','249724',4770224,'2139','326',829297.39,829767.92,0.00,0.00,470.53,278553.76,0.00,0.00,0.00),('1','147','768','249724',4770225,'2942','326',86260.72,86548.40,0.00,0.00,287.68,170306.56,0.00,0.00,0.00),('1','147','768','249840',4772383,'2139','326',829767.92,831062.12,0.00,0.00,1294.20,766166.40,0.00,0.00,0.00),('1','147','768','249840',4772384,'2942','326',86548.40,87512.20,0.00,0.00,963.80,570569.60,0.00,0.00,0.00),('1','147','768','250106',4776656,'2139','326',831062.12,832317.26,0.00,0.00,1255.14,743042.88,0.00,0.00,0.00),('1','147','768','250106',4776657,'2942','326',87512.20,87750.05,0.00,0.00,237.85,140807.20,0.00,0.00,0.00),('1','147','768','250490',4783096,'2139','326',832317.26,832771.08,0.00,0.00,453.82,268661.44,0.00,0.00,0.00),('1','147','768','250490',4783097,'2942','326',87750.05,87750.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','250558',4784342,'2139','326',832771.08,834506.17,0.00,0.00,1735.09,1027173.28,0.00,0.00,0.00),('1','147','768','250558',4784343,'2942','326',87750.05,87762.55,0.00,0.00,12.50,7400.00,0.00,0.00,0.00),('1','147','768','250790',4788376,'2139','326',834506.17,836390.51,0.00,0.00,1884.34,1115529.28,0.00,0.00,0.00),('1','147','768','250790',4788377,'2942','326',87762.55,87822.69,0.00,0.00,60.14,35602.88,0.00,0.00,0.00),('1','147','768','251017',4792494,'2139','326',836390.51,837321.66,0.00,0.00,931.15,551240.80,0.00,0.00,0.00),('1','147','768','251017',4792495,'2942','326',87822.69,88551.45,0.00,0.00,728.76,431425.92,0.00,0.00,0.00),('1','147','768','251336',4797921,'2139','326',837321.66,838306.63,0.00,0.00,984.97,583102.24,0.00,0.00,0.00),('1','147','768','251336',4797922,'2942','326',88551.45,89155.19,0.00,0.00,603.74,357414.08,0.00,0.00,0.00),('1','147','768','251509',4800858,'2139','326',838306.63,839573.36,0.00,0.00,1266.73,749904.16,0.00,0.00,0.00),('1','147','768','251509',4800859,'2942','326',89155.19,89824.37,0.00,0.00,669.18,396154.56,0.00,0.00,0.00),('1','147','768','251758',4805359,'2139','326',839573.36,840619.28,0.00,0.00,1045.92,619184.64,0.00,0.00,0.00),('1','147','768','251758',4805360,'2942','326',89824.37,90896.13,0.00,0.00,1071.76,634481.92,0.00,0.00,0.00),('1','147','768','251987',4809320,'2139','326',840619.28,840729.08,0.00,0.00,109.80,65001.60,0.00,0.00,0.00),('1','147','768','251987',4809321,'2942','326',90896.13,90962.17,0.00,0.00,66.04,39095.68,0.00,0.00,0.00),('1','147','768','252044',4810050,'2139','326',840729.08,842075.30,0.00,0.00,1346.22,796962.24,0.00,0.00,0.00),('1','147','768','252044',4810051,'2942','326',90962.17,91459.48,0.00,0.00,497.31,294407.52,0.00,0.00,0.00),('1','147','768','252234',4813532,'2139','326',842075.30,844241.71,0.00,0.00,2166.41,1282514.72,0.00,0.00,0.00),('1','147','768','252234',4813533,'2942','326',91459.48,92035.43,0.00,0.00,575.95,340962.40,0.00,0.00,0.00),('1','147','768','252465',4817845,'2139','326',844241.71,844646.83,0.00,0.00,405.12,239831.04,0.00,0.00,0.00),('1','147','768','252465',4817846,'2942','326',92035.43,92138.98,0.00,0.00,103.55,61301.60,0.00,0.00,0.00),('1','147','768','252577',4819638,'2139','326',844646.83,845842.43,0.00,0.00,1195.60,707795.20,0.00,0.00,0.00),('1','147','768','252577',4819639,'2942','326',92138.98,92572.26,0.00,0.00,433.28,256501.76,0.00,0.00,0.00),('1','147','768','252709',4821957,'2139','326',845842.43,846440.84,0.00,0.00,598.41,354258.72,0.00,0.00,0.00),('1','147','768','252709',4821958,'2942','326',92572.26,93216.26,0.00,0.00,644.00,381248.00,0.00,0.00,0.00),('1','147','768','253040',4827205,'2139','326',846440.84,847795.39,0.00,0.00,1354.55,801893.60,0.00,0.00,0.00),('1','147','768','253040',4827206,'2942','326',93216.26,93901.18,0.00,0.00,684.92,405472.64,0.00,0.00,0.00),('1','147','768','253201',4830217,'2139','326',847795.39,849343.98,0.00,0.00,1548.59,916765.28,0.00,0.00,0.00),('1','147','768','253201',4830218,'2942','326',93901.18,94458.85,0.00,0.00,557.67,330140.64,0.00,0.00,0.00),('1','147','768','253470',4834727,'2139','326',849343.98,849791.67,0.00,0.00,447.69,265032.48,0.00,0.00,0.00),('1','147','768','253470',4834728,'2942','326',94458.85,94678.27,0.00,0.00,219.42,129896.64,0.00,0.00,0.00),('1','147','768','253578',4836472,'2139','326',849791.67,850697.07,0.00,0.00,905.40,535996.80,0.00,0.00,0.00),('1','147','768','253578',4836473,'2942','326',94678.27,95087.37,0.00,0.00,409.10,242187.20,0.00,0.00,0.00),('1','147','768','253710',4838783,'2139','326',850697.07,852536.86,0.00,0.00,1839.79,1089155.68,0.00,0.00,0.00),('1','147','768','253710',4838784,'2942','326',95087.37,95804.16,0.00,0.00,716.79,424339.68,0.00,0.00,0.00),('1','147','768','253954',4843055,'2139','326',852536.86,853234.07,0.00,0.00,697.21,412748.32,0.00,0.00,0.00),('1','147','768','253954',4843056,'2942','326',95804.16,96001.98,0.00,0.00,197.82,117109.44,0.00,0.00,0.00),('1','147','768','254103',4845797,'2139','326',853234.07,853814.31,0.00,0.00,580.24,343502.08,0.00,0.00,0.00),('1','147','768','254103',4845798,'2942','326',96001.98,96179.87,0.00,0.00,177.89,105310.88,0.00,0.00,0.00),('1','147','768','254188',4847349,'2139','326',853814.31,854968.40,0.00,0.00,1154.09,683221.28,0.00,0.00,0.00),('1','147','768','254188',4847350,'2942','326',96179.87,96437.27,0.00,0.00,257.40,152380.80,0.00,0.00,0.00),('1','147','768','254513',4852732,'2139','326',854968.40,856635.70,0.00,0.00,1667.30,987041.60,0.00,0.00,0.00),('1','147','768','254513',4852733,'2942','326',96437.27,96812.09,0.00,0.00,374.82,221893.44,0.00,0.00,0.00),('1','147','768','254694',4856035,'2139','326',856635.70,858416.97,0.00,0.00,1781.27,1054511.84,0.00,0.00,0.00),('1','147','768','254694',4856036,'2942','326',96812.09,97113.29,0.00,0.00,301.20,178310.40,0.00,0.00,0.00),('1','147','768','254945',4860284,'2139','326',858416.97,859051.43,0.00,0.00,634.46,375600.32,0.00,0.00,0.00),('1','147','768','254945',4860285,'2942','326',97113.29,97391.52,0.00,0.00,278.23,164712.16,0.00,0.00,0.00),('1','147','768','255066',4862349,'2139','326',859051.43,859755.50,0.00,0.00,704.07,416809.44,0.00,0.00,0.00),('1','147','768','255066',4862350,'2942','326',97391.52,97633.42,0.00,0.00,241.90,143204.80,0.00,0.00,0.00),('1','147','768','255193',4864521,'2139','326',859755.50,861388.92,0.00,0.00,1633.42,966984.64,0.00,0.00,0.00),('1','147','768','255193',4864522,'2942','326',97633.42,98004.21,0.00,0.00,370.79,219507.68,0.00,0.00,0.00),('1','147','768','255498',4869509,'2139','326',861388.92,862916.43,0.00,0.00,1527.51,904285.92,0.00,0.00,0.00),('1','147','768','255498',4869510,'2942','326',98004.21,98404.89,0.00,0.00,400.68,237202.56,0.00,0.00,0.00),('1','147','768','255718',4873319,'2139','326',862916.43,865369.15,0.00,0.00,2452.72,1452010.24,0.00,0.00,0.00),('1','147','768','255718',4873320,'2942','326',98404.89,98999.73,0.00,0.00,594.84,352145.28,0.00,0.00,0.00),('1','147','768','255940',4876966,'2139','326',865369.15,866824.56,0.00,0.00,1455.41,861602.72,0.00,0.00,0.00),('1','147','768','255940',4876967,'2942','326',98999.73,99321.01,0.00,0.00,321.28,190197.76,0.00,0.00,0.00),('1','147','768','256260',4881865,'2139','326',866824.56,868559.34,0.00,0.00,1734.78,1026989.76,0.00,0.00,0.00),('1','147','768','256260',4881866,'2942','326',99321.01,99741.63,0.00,0.00,420.62,249007.04,0.00,0.00,0.00),('1','147','768','256475',4885948,'2139','326',868559.34,870432.48,0.00,0.00,1873.14,1108898.88,0.00,0.00,0.00),('1','147','768','256475',4885949,'2942','326',99741.63,99988.60,0.00,0.00,246.97,146206.24,0.00,0.00,0.00),('1','147','768','256729',4889974,'2139','326',870432.48,871156.23,0.00,0.00,723.75,428460.00,0.00,0.00,0.00),('1','147','768','256729',4889975,'2942','326',99988.60,100148.58,0.00,0.00,159.98,94708.16,0.00,0.00,0.00),('1','147','768','256867',4892517,'2139','326',871156.23,871814.16,0.00,0.00,657.93,389494.56,0.00,0.00,0.00),('1','147','768','256867',4892518,'2942','326',100148.58,100416.50,0.00,0.00,267.92,158608.64,0.00,0.00,0.00),('1','147','768','256947',4893997,'2139','326',871814.16,873210.56,0.00,0.00,1396.40,826668.80,0.00,0.00,0.00),('1','147','768','256947',4893998,'2942','326',100416.50,100697.43,0.00,0.00,280.93,166310.56,0.00,0.00,0.00),('1','147','768','257284',4899834,'2139','326',873210.56,875529.40,0.00,0.00,2318.84,1372753.28,0.00,0.00,0.00),('1','147','768','257284',4899835,'2942','326',100697.43,100952.26,0.00,0.00,254.83,150859.36,0.00,0.00,0.00),('1','147','768','257500',4903595,'2139','326',875529.40,877847.50,0.00,0.00,2318.10,1335034.80,0.00,0.00,0.00),('1','147','768','257500',4903596,'2942','326',100952.26,101594.57,0.00,0.00,642.31,375595.84,0.00,0.00,0.00),('1','147','768','257501',4903597,'2139','326',877847.50,879795.12,0.00,0.00,1947.62,1106248.16,0.00,0.00,0.00),('1','147','768','257501',4903598,'2942','326',101594.57,101901.38,0.00,0.00,306.81,174268.08,0.00,0.00,0.00),('1','147','768','257502',4903599,'2139','326',879795.12,881867.34,0.00,0.00,2072.22,1177020.96,0.00,0.00,0.00),('1','147','768','257502',4903600,'2942','326',101901.38,102564.32,0.00,0.00,662.94,376549.92,0.00,0.00,0.00),('1','147','768','257503',4903601,'2139','326',881867.34,883593.35,0.00,0.00,1726.01,980373.68,0.00,0.00,0.00),('1','147','768','257503',4903602,'2942','326',102564.32,103162.54,0.00,0.00,598.22,339788.96,0.00,0.00,0.00),('1','147','768','257504',4903603,'2139','326',883593.35,885845.42,0.00,0.00,2252.07,1279175.76,0.00,0.00,0.00),('1','147','768','257504',4903604,'2942','326',103162.54,103328.91,0.00,0.00,166.37,94498.16,0.00,0.00,0.00),('1','147','768','257505',4903605,'2139','326',885845.42,888198.03,0.00,0.00,2352.61,1336282.48,0.00,0.00,0.00),('1','147','768','257505',4903606,'2942','326',103328.91,103371.86,0.00,0.00,42.95,24395.60,0.00,0.00,0.00),('1','147','768','257506',4903607,'2139','326',888198.03,890946.12,0.00,0.00,2748.09,1560915.12,0.00,0.00,0.00),('1','147','768','257506',4903608,'2942','326',103371.86,103924.43,0.00,0.00,552.57,313859.76,0.00,0.00,0.00),('1','147','768','257507',4903609,'2139','326',890946.12,892806.53,0.00,0.00,1860.41,1056712.88,0.00,0.00,0.00),('1','147','768','257507',4903610,'2942','326',103924.43,104279.24,0.00,0.00,354.81,201532.08,0.00,0.00,0.00),('1','147','768','257508',4903611,'2139','326',892806.53,894879.60,0.00,0.00,2073.07,1177503.76,0.00,0.00,0.00),('1','147','768','257508',4903612,'2942','326',104279.24,104663.86,0.00,0.00,384.62,218464.16,0.00,0.00,0.00),('1','147','768','257509',4903613,'2139','326',894879.60,896464.56,0.00,0.00,1584.96,900257.28,0.00,0.00,0.00),('1','147','768','257509',4903614,'2942','326',104663.86,105025.25,0.00,0.00,361.39,205269.52,0.00,0.00,0.00),('1','147','768','257510',4903615,'2139','326',896464.56,897104.02,0.00,0.00,639.46,363213.28,0.00,0.00,0.00),('1','147','768','257510',4903616,'2942','326',105025.25,105112.22,0.00,0.00,86.97,49398.96,0.00,0.00,0.00),('1','147','768','257511',4903617,'2139','326',897104.02,898093.74,0.00,0.00,989.72,562160.96,0.00,0.00,0.00),('1','147','768','257511',4903618,'2942','326',105112.22,105344.41,0.00,0.00,232.19,131883.92,0.00,0.00,0.00),('1','147','768','257512',4903619,'2139','326',898093.74,899950.18,0.00,0.00,1856.44,1054457.92,0.00,0.00,0.00),('1','147','768','257512',4903620,'2942','326',105344.41,105639.05,0.00,0.00,294.64,167355.52,0.00,0.00,0.00),('1','147','768','257513',4903621,'2139','326',899950.18,900761.29,0.00,0.00,811.11,460710.48,0.00,0.00,0.00),('1','147','768','257513',4903622,'2942','326',105639.05,105872.76,0.00,0.00,233.71,132747.28,0.00,0.00,0.00),('1','147','768','257514',4903623,'2139','326',900761.29,901882.40,0.00,0.00,1121.11,636790.48,0.00,0.00,0.00),('1','147','768','257514',4903624,'2942','326',105872.76,106011.66,0.00,0.00,138.90,78895.20,0.00,0.00,0.00),('1','147','768','257515',4903625,'2139','326',901882.40,903299.77,0.00,0.00,1417.37,805066.16,0.00,0.00,0.00),('1','147','768','257515',4903626,'2942','326',106011.66,107548.40,0.00,0.00,1536.74,872868.32,0.00,0.00,0.00),('1','147','768','257516',4903627,'2139','326',903299.77,903566.25,0.00,0.00,266.48,151360.64,0.00,0.00,0.00),('1','147','768','257516',4903628,'2942','326',107548.40,108169.21,0.00,0.00,620.81,352620.08,0.00,0.00,0.00),('1','147','768','257517',4903629,'2139','326',903566.25,903999.96,0.00,0.00,433.71,246347.28,0.00,0.00,0.00),('1','147','768','257517',4903630,'2942','326',108169.21,108698.08,0.00,0.00,528.87,300398.16,0.00,0.00,0.00),('1','147','768','257518',4903631,'2139','326',903999.96,905010.86,0.00,0.00,1010.90,574191.20,0.00,0.00,0.00),('1','147','768','257518',4903632,'2942','326',108698.08,109327.25,0.00,0.00,629.17,357368.56,0.00,0.00,0.00),('1','147','768','257519',4903633,'2139','326',905010.86,906090.28,0.00,0.00,1079.42,613110.56,0.00,0.00,0.00),('1','147','768','257519',4903634,'2942','326',109327.25,110194.58,0.00,0.00,867.33,492643.44,0.00,0.00,0.00),('1','147','768','257520',4903635,'2139','326',906090.28,906438.20,0.00,0.00,347.92,197618.56,0.00,0.00,0.00),('1','147','768','257520',4903636,'2942','326',110194.58,110548.45,0.00,0.00,353.87,200998.16,0.00,0.00,0.00),('1','147','768','257521',4903637,'2139','326',906438.20,907198.32,0.00,0.00,760.12,431748.16,0.00,0.00,0.00),('1','147','768','257521',4903638,'2942','326',110548.45,110744.88,0.00,0.00,196.43,111572.24,0.00,0.00,0.00),('1','147','768','257522',4903639,'2139','326',907198.32,908838.04,0.00,0.00,1639.72,931360.96,0.00,0.00,0.00),('1','147','768','257522',4903640,'2942','326',110744.88,111023.66,0.00,0.00,278.78,158347.04,0.00,0.00,0.00),('1','147','768','257523',4903641,'2139','326',908838.04,910439.10,0.00,0.00,1601.06,909402.08,0.00,0.00,0.00),('1','147','768','257523',4903642,'2942','326',111023.66,111382.23,0.00,0.00,358.57,203667.76,0.00,0.00,0.00),('1','147','768','257524',4903643,'2139','326',910439.10,910730.66,0.00,0.00,291.56,165606.08,0.00,0.00,0.00),('1','147','768','257524',4903644,'2942','326',111382.23,111420.07,0.00,0.00,37.84,21493.12,0.00,0.00,0.00),('1','147','768','257525',4903645,'2139','326',910730.66,912262.62,0.00,0.00,1531.96,870153.28,0.00,0.00,0.00),('1','147','768','257525',4903646,'2942','326',111420.07,111507.56,0.00,0.00,87.49,49694.32,0.00,0.00,0.00),('1','147','768','257526',4903647,'2139','326',912262.62,914136.07,0.00,0.00,1873.45,1064119.60,0.00,0.00,0.00),('1','147','768','257526',4903648,'2942','326',111507.56,112140.38,0.00,0.00,632.82,359441.76,0.00,0.00,0.00),('1','147','768','257527',4903649,'2139','326',914136.07,915011.22,0.00,0.00,875.15,497085.20,0.00,0.00,0.00),('1','147','768','257527',4903650,'2942','326',112140.38,112318.62,0.00,0.00,178.24,101240.32,0.00,0.00,0.00),('1','147','768','257528',4903651,'2139','326',915011.22,916876.33,0.00,0.00,1865.11,1059382.48,0.00,0.00,0.00),('1','147','768','257528',4903652,'2942','326',112318.62,112657.32,0.00,0.00,338.70,192381.60,0.00,0.00,0.00),('1','147','768','257529',4903653,'2139','326',916876.33,918572.01,0.00,0.00,1695.68,963146.24,0.00,0.00,0.00),('1','147','768','257529',4903654,'2942','326',112657.32,112827.20,0.00,0.00,169.88,96491.84,0.00,0.00,0.00),('1','147','768','257530',4903655,'2139','326',918572.01,919246.12,0.00,0.00,674.11,382894.48,0.00,0.00,0.00),('1','147','768','257530',4903656,'2942','326',112827.20,112976.66,0.00,0.00,149.46,84893.28,0.00,0.00,0.00),('1','147','768','257531',4903657,'2139','326',919246.12,919535.71,0.00,0.00,289.59,164487.12,0.00,0.00,0.00),('1','147','768','257531',4903658,'2942','326',112976.66,113238.96,0.00,0.00,262.30,148986.40,0.00,0.00,0.00),('1','147','768','257532',4903659,'2139','326',919535.71,921408.29,0.00,0.00,1872.58,1063625.44,0.00,0.00,0.00),('1','147','768','257532',4903660,'2942','326',113238.96,113315.54,0.00,0.00,76.58,43497.44,0.00,0.00,0.00),('1','147','768','257533',4903661,'2139','326',921408.29,921752.44,0.00,0.00,344.15,195477.20,0.00,0.00,0.00),('1','147','768','257533',4903662,'2942','326',113315.54,113387.90,0.00,0.00,72.36,41100.48,0.00,0.00,0.00),('1','147','768','257534',4903663,'2139','326',921752.44,921752.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257534',4903664,'2942','326',113387.90,114887.65,0.00,0.00,1499.75,851858.00,0.00,0.00,0.00),('1','147','768','257535',4903665,'2139','326',921752.44,922631.74,0.00,0.00,879.30,499442.40,0.00,0.00,0.00),('1','147','768','257535',4903666,'2942','326',114887.65,114924.79,0.00,0.00,37.14,21095.52,0.00,0.00,0.00),('1','147','768','257536',4903667,'2139','326',922631.74,923931.05,0.00,0.00,1299.31,738008.08,0.00,0.00,0.00),('1','147','768','257536',4903668,'2942','326',114924.79,115377.18,0.00,0.00,452.39,256957.52,0.00,0.00,0.00),('1','147','768','257537',4903669,'2139','326',923931.05,924999.32,0.00,0.00,1068.27,606777.36,0.00,0.00,0.00),('1','147','768','257537',4903670,'2942','326',115377.18,115866.35,0.00,0.00,489.17,277848.56,0.00,0.00,0.00),('1','147','768','257538',4903671,'2139','326',924999.32,925163.70,0.00,0.00,164.38,93367.84,0.00,0.00,0.00),('1','147','768','257538',4903672,'2942','326',115866.35,115866.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257539',4903673,'2139','326',925163.70,926405.23,0.00,0.00,1241.53,705189.04,0.00,0.00,0.00),('1','147','768','257539',4903674,'2942','326',115866.35,116043.56,0.00,0.00,177.21,100655.28,0.00,0.00,0.00),('1','147','768','257540',4903675,'2139','326',926405.23,927745.78,0.00,0.00,1340.55,761432.40,0.00,0.00,0.00),('1','147','768','257540',4903676,'2942','326',116043.56,116374.92,0.00,0.00,331.36,188212.48,0.00,0.00,0.00),('1','147','768','257541',4903677,'2139','326',927745.78,928832.58,0.00,0.00,1086.80,630344.00,0.00,0.00,0.00),('1','147','768','257541',4903678,'2942','326',116374.92,116804.37,0.00,0.00,429.45,249081.00,0.00,0.00,0.00),('1','147','768','257542',4903679,'2139','326',928832.58,929127.29,0.00,0.00,294.71,170931.80,0.00,0.00,0.00),('1','147','768','257542',4903680,'2942','326',116804.37,116804.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257543',4903681,'2139','326',929127.29,930324.45,0.00,0.00,1197.16,694352.80,0.00,0.00,0.00),('1','147','768','257543',4903682,'2942','326',116804.37,116827.64,0.00,0.00,23.27,13496.60,0.00,0.00,0.00),('1','147','768','257544',4903683,'2139','326',930324.45,931062.34,0.00,0.00,737.89,427976.20,0.00,0.00,0.00),('1','147','768','257544',4903684,'2942','326',116827.64,116910.73,0.00,0.00,83.09,48192.20,0.00,0.00,0.00),('1','147','768','257545',4903685,'2139','326',931062.34,933568.49,0.00,0.00,2506.15,1453567.00,0.00,0.00,0.00),('1','147','768','257545',4903686,'2942','326',116910.73,117196.62,0.00,0.00,285.89,165816.20,0.00,0.00,0.00),('1','147','768','257546',4903687,'2139','326',933568.49,934976.15,0.00,0.00,1407.66,816442.80,0.00,0.00,0.00),('1','147','768','257546',4903688,'2942','326',117196.62,117535.88,0.00,0.00,339.26,196770.80,0.00,0.00,0.00),('1','147','768','257547',4903689,'2139','326',934976.15,937086.57,0.00,0.00,2110.42,1224043.60,0.00,0.00,0.00),('1','147','768','257547',4903690,'2942','326',117535.88,117614.42,0.00,0.00,78.54,45553.20,0.00,0.00,0.00),('1','147','768','257548',4903691,'2139','326',937086.57,937150.54,0.00,0.00,63.97,37102.60,0.00,0.00,0.00),('1','147','768','257548',4903692,'2942','326',117614.42,117614.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257549',4903693,'2139','326',937150.54,938483.89,0.00,0.00,1333.35,853344.00,0.00,0.00,0.00),('1','147','768','257549',4903694,'2942','326',117614.42,118022.32,0.00,0.00,407.90,261056.00,0.00,0.00,0.00),('1','147','768','257550',4903695,'2139','326',938483.89,938888.81,0.00,0.00,404.92,259148.80,0.00,0.00,0.00),('1','147','768','257550',4903696,'2942','326',118022.32,118054.90,0.00,0.00,32.58,20851.20,0.00,0.00,0.00),('1','147','768','257551',4903697,'2139','326',938888.81,940131.07,0.00,0.00,1242.26,795046.40,0.00,0.00,0.00),('1','147','768','257551',4903698,'2942','326',118054.90,118109.22,0.00,0.00,54.32,34764.80,0.00,0.00,0.00),('1','147','768','257552',4903699,'2139','326',940131.07,941548.94,0.00,0.00,1417.87,907436.80,0.00,0.00,0.00),('1','147','768','257552',4903700,'2942','326',118109.22,118540.64,0.00,0.00,431.42,276108.80,0.00,0.00,0.00),('1','147','768','257553',4903701,'2139','326',941548.94,943329.53,0.00,0.00,1780.59,1139577.60,0.00,0.00,0.00),('1','147','768','257553',4903702,'2942','326',118540.64,118642.70,0.00,0.00,102.06,65318.40,0.00,0.00,0.00),('1','147','768','257554',4903703,'2139','326',943329.53,945616.91,0.00,0.00,2287.38,1463923.20,0.00,0.00,0.00),('1','147','768','257554',4903704,'2942','326',118642.70,119343.89,0.00,0.00,701.19,448761.60,0.00,0.00,0.00),('1','147','768','257555',4903705,'2139','326',945616.91,946776.04,0.00,0.00,1159.13,741843.20,0.00,0.00,0.00),('1','147','768','257555',4903706,'2942','326',119343.89,119372.49,0.00,0.00,28.60,18304.00,0.00,0.00,0.00),('1','147','768','257556',4903707,'2139','326',946776.04,947470.19,0.00,0.00,694.15,444256.00,0.00,0.00,0.00),('1','147','768','257556',4903708,'2942','326',119372.49,119398.04,0.00,0.00,25.55,16352.00,0.00,0.00,0.00),('1','147','768','257557',4903709,'2139','326',947470.19,948748.15,0.00,0.00,1277.96,869012.80,0.00,0.00,0.00),('1','147','768','257557',4903710,'2942','326',119398.04,119855.61,0.00,0.00,457.57,311147.60,0.00,0.00,0.00),('1','147','768','257558',4903711,'2139','326',948748.15,950483.13,0.00,0.00,1734.98,1179786.40,0.00,0.00,0.00),('1','147','768','257558',4903712,'2942','326',119855.61,119914.74,0.00,0.00,59.13,40208.40,0.00,0.00,0.00),('1','147','768','257559',4903713,'2139','326',950483.13,951129.52,0.00,0.00,646.39,439545.20,0.00,0.00,0.00),('1','147','768','257559',4903714,'2942','326',119914.74,120040.01,0.00,0.00,125.27,85183.60,0.00,0.00,0.00),('1','147','768','257560',4903715,'2139','326',951129.52,951653.98,0.00,0.00,524.46,356632.80,0.00,0.00,0.00),('1','147','768','257560',4903716,'2942','326',120040.01,120281.21,0.00,0.00,241.20,164016.00,0.00,0.00,0.00),('1','147','768','257561',4903717,'2139','326',951653.98,953139.86,0.00,0.00,1485.88,1010398.40,0.00,0.00,0.00),('1','147','768','257561',4903718,'2942','326',120281.21,120346.72,0.00,0.00,65.51,44546.80,0.00,0.00,0.00),('1','147','768','257562',4903719,'2139','326',953139.86,954142.80,0.00,0.00,1002.94,681999.20,0.00,0.00,0.00),('1','147','768','257562',4903720,'2942','326',120346.72,121850.98,0.00,0.00,1504.26,1022896.80,0.00,0.00,0.00),('1','147','768','257563',4903721,'2139','326',954142.80,954142.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257563',4903722,'2942','326',121850.98,121984.11,0.00,0.00,133.13,90528.40,0.00,0.00,0.00),('1','147','768','257564',4903723,'2139','326',954142.80,954767.70,0.00,0.00,624.90,424932.00,0.00,0.00,0.00),('1','147','768','257564',4903724,'2942','326',121984.11,123216.36,0.00,0.00,1232.25,837930.00,0.00,0.00,0.00),('1','147','768','257565',4903725,'2139','326',954767.70,955594.22,0.00,0.00,826.52,562033.60,0.00,0.00,0.00),('1','147','768','257565',4903726,'2942','326',123216.36,124071.90,0.00,0.00,855.54,581767.20,0.00,0.00,0.00),('1','147','768','257566',4903727,'2139','326',955594.22,956155.46,0.00,0.00,561.24,381643.20,0.00,0.00,0.00),('1','147','768','257566',4903728,'2942','326',124071.90,124937.13,0.00,0.00,865.23,588356.40,0.00,0.00,0.00),('1','147','768','257567',4903729,'2139','326',956155.46,956155.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257567',4903730,'2942','326',124937.13,125224.81,0.00,0.00,287.68,195622.40,0.00,0.00,0.00),('1','147','768','257568',4903731,'2139','326',956155.46,956555.69,0.00,0.00,400.23,272156.40,0.00,0.00,0.00),('1','147','768','257568',4903732,'2942','326',125224.81,126024.56,0.00,0.00,799.75,543830.00,0.00,0.00,0.00),('1','147','768','257569',4903733,'2139','326',956555.69,957205.97,0.00,0.00,650.28,442190.40,0.00,0.00,0.00),('1','147','768','257569',4903734,'2942','326',126024.56,126853.18,0.00,0.00,828.62,563461.60,0.00,0.00,0.00),('1','147','768','257570',4903735,'2139','326',957205.97,957913.51,0.00,0.00,707.54,481127.20,0.00,0.00,0.00),('1','147','768','257570',4903736,'2942','326',126853.18,127966.79,0.00,0.00,1113.61,757254.80,0.00,0.00,0.00),('1','147','768','257571',4903737,'2139','326',957913.51,958242.96,0.00,0.00,329.45,224026.00,0.00,0.00,0.00),('1','147','768','257571',4903738,'2942','326',127966.79,128056.72,0.00,0.00,89.93,61152.40,0.00,0.00,0.00),('1','147','768','257572',4903739,'2139','326',958242.96,958864.32,0.00,0.00,621.36,422524.80,0.00,0.00,0.00),('1','147','768','257572',4903740,'2942','326',128056.72,129246.78,0.00,0.00,1190.06,809240.80,0.00,0.00,0.00),('1','147','768','257573',4903741,'2139','326',958864.32,958864.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257573',4903742,'2942','326',129246.78,129721.51,0.00,0.00,474.73,324151.76,0.00,0.00,0.00),('1','147','768','257574',4903743,'2139','326',958864.32,959516.35,0.00,0.00,652.03,448596.64,0.00,0.00,0.00),('1','147','768','257574',4903744,'2942','326',129721.51,131291.36,0.00,0.00,1569.85,1080056.80,0.00,0.00,0.00),('1','147','768','257575',4903745,'2139','326',959516.35,959543.51,0.00,0.00,27.16,18686.08,0.00,0.00,0.00),('1','147','768','257575',4903746,'2942','326',131291.36,131946.71,0.00,0.00,655.35,450880.80,0.00,0.00,0.00),('1','147','768','257576',4903747,'2139','326',959543.51,959993.23,0.00,0.00,449.72,309407.36,0.00,0.00,0.00),('1','147','768','257576',4903748,'2942','326',131946.71,132493.37,0.00,0.00,546.66,376102.08,0.00,0.00,0.00),('1','147','768','257577',4903749,'2139','326',959993.23,960913.55,0.00,0.00,920.32,633180.16,0.00,0.00,0.00),('1','147','768','257577',4903750,'2942','326',132493.37,133725.29,0.00,0.00,1231.92,847560.96,0.00,0.00,0.00),('1','147','768','257578',4903751,'2139','326',960913.55,962248.61,0.00,0.00,1335.06,918521.28,0.00,0.00,0.00),('1','147','768','257578',4903752,'2942','326',133725.29,134354.22,0.00,0.00,628.93,432703.84,0.00,0.00,0.00),('1','147','768','257579',4903753,'2139','326',962248.61,964408.83,0.00,0.00,2160.22,1434386.08,0.00,0.00,0.00),('1','147','768','257579',4903754,'2942','326',134354.22,134421.10,0.00,0.00,66.88,44408.32,0.00,0.00,0.00),('1','147','768','257580',4903755,'2139','326',964408.83,965298.38,0.00,0.00,889.55,590661.20,0.00,0.00,0.00),('1','147','768','257580',4903756,'2942','326',134421.10,135905.93,0.00,0.00,1484.83,985927.12,0.00,0.00,0.00),('1','147','768','257581',4903757,'2139','326',965298.38,965567.94,0.00,0.00,269.56,178987.84,0.00,0.00,0.00),('1','147','768','257581',4903758,'2942','326',135905.93,135916.92,0.00,0.00,10.99,7297.36,0.00,0.00,0.00),('1','147','768','257582',4903759,'2139','326',965567.94,966720.93,0.00,0.00,1152.99,765585.36,0.00,0.00,0.00),('1','147','768','257582',4903760,'2942','326',135916.92,137715.65,0.00,0.00,1798.73,1194356.72,0.00,0.00,0.00),('1','147','768','257583',4903761,'2139','326',966720.93,967927.06,0.00,0.00,1206.13,800870.32,0.00,0.00,0.00),('1','147','768','257583',4903762,'2942','326',137715.65,138629.71,0.00,0.00,914.06,606935.84,0.00,0.00,0.00),('1','147','768','257584',4903763,'2139','326',967927.06,968283.98,0.00,0.00,356.92,236994.88,0.00,0.00,0.00),('1','147','768','257584',4903764,'2942','326',138629.71,140062.24,0.00,0.00,1432.53,951199.92,0.00,0.00,0.00),('1','147','768','257585',4903765,'2139','326',968283.98,968563.96,0.00,0.00,279.98,185906.72,0.00,0.00,0.00),('1','147','768','257585',4903766,'2942','326',140062.24,142125.87,0.00,0.00,2063.63,1370250.32,0.00,0.00,0.00),('1','147','768','257586',4903767,'2139','326',968563.96,969001.60,0.00,0.00,437.64,290592.96,0.00,0.00,0.00),('1','147','768','257586',4903768,'2942','326',142125.87,142653.84,0.00,0.00,527.97,350572.08,0.00,0.00,0.00),('1','147','768','257587',4903769,'2139','326',969001.60,969001.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257587',4903770,'2942','326',142653.84,143269.95,0.00,0.00,616.11,409097.04,0.00,0.00,0.00),('1','147','768','257588',4903771,'2139','326',969001.60,969489.15,0.00,0.00,487.55,323733.20,0.00,0.00,0.00),('1','147','768','257588',4903772,'2942','326',143269.95,144826.96,0.00,0.00,1557.01,1033854.64,0.00,0.00,0.00),('1','147','768','257589',4903773,'2139','326',969489.15,970164.74,0.00,0.00,675.59,448591.76,0.00,0.00,0.00),('1','147','768','257589',4903774,'2942','326',144826.96,146282.22,0.00,0.00,1455.26,966292.64,0.00,0.00,0.00),('1','147','768','257590',4903775,'2139','326',970164.74,970773.93,0.00,0.00,609.19,404502.16,0.00,0.00,0.00),('1','147','768','257590',4903776,'2942','326',146282.22,146332.92,0.00,0.00,50.70,33664.80,0.00,0.00,0.00),('1','147','768','257591',4903777,'2139','326',970773.93,972073.77,0.00,0.00,1299.84,863093.76,0.00,0.00,0.00),('1','147','768','257591',4903778,'2942','326',146332.92,147117.48,0.00,0.00,784.56,520947.84,0.00,0.00,0.00),('1','147','768','257592',4903779,'2139','326',972073.77,972676.92,0.00,0.00,603.15,400491.60,0.00,0.00,0.00),('1','147','768','257592',4903780,'2942','326',147117.48,149118.09,0.00,0.00,2000.61,1328405.04,0.00,0.00,0.00),('1','147','768','257593',4903781,'2139','326',972676.92,973144.12,0.00,0.00,467.20,310220.80,0.00,0.00,0.00),('1','147','768','257593',4903782,'2942','326',149118.09,149229.23,0.00,0.00,111.14,73796.96,0.00,0.00,0.00),('1','147','768','257594',4903783,'2139','326',973144.12,974063.66,0.00,0.00,919.54,610574.56,0.00,0.00,0.00),('1','147','768','257594',4903784,'2942','326',149229.23,150428.12,0.00,0.00,1198.89,796062.96,0.00,0.00,0.00),('1','147','768','257595',4903785,'2139','326',974063.66,974289.56,0.00,0.00,225.90,149997.60,0.00,0.00,0.00),('1','147','768','257595',4903786,'2942','326',150428.12,152400.04,0.00,0.00,1971.92,1309354.88,0.00,0.00,0.00),('1','147','768','257596',4903787,'2139','326',974289.56,974802.01,0.00,0.00,512.45,340266.80,0.00,0.00,0.00),('1','147','768','257596',4903788,'2942','326',152400.04,152441.00,0.00,0.00,40.96,27197.44,0.00,0.00,0.00),('1','147','768','257597',4903789,'2139','326',974802.01,974952.90,0.00,0.00,150.89,100190.96,0.00,0.00,0.00),('1','147','768','257597',4903790,'2942','326',152441.00,153386.46,0.00,0.00,945.46,627785.44,0.00,0.00,0.00),('1','147','768','257598',4903791,'2139','326',974952.90,977720.86,0.00,0.00,2767.96,1837925.44,0.00,0.00,0.00),('1','147','768','257598',4903792,'2942','326',153386.46,153388.72,0.00,0.00,2.26,1500.64,0.00,0.00,0.00),('1','147','768','257599',4903793,'2139','326',977720.86,977720.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257599',4903794,'2942','326',153388.72,154609.35,0.00,0.00,1220.63,810498.32,0.00,0.00,0.00),('1','147','768','257600',4903795,'2139','326',977720.86,978281.10,0.00,0.00,560.24,371999.36,0.00,0.00,0.00),('1','147','768','257600',4903796,'2942','326',154609.35,156640.20,0.00,0.00,2030.85,1348484.40,0.00,0.00,0.00),('1','147','768','257601',4903797,'2139','326',978281.10,978674.84,0.00,0.00,393.74,261443.36,0.00,0.00,0.00),('1','147','768','257601',4903798,'2942','326',156640.20,158160.09,0.00,0.00,1519.89,1009206.96,0.00,0.00,0.00),('1','147','768','257602',4903799,'2139','326',978674.84,978851.08,0.00,0.00,176.24,117023.36,0.00,0.00,0.00),('1','147','768','257602',4903800,'2942','326',158160.09,158368.67,0.00,0.00,208.58,138497.12,0.00,0.00,0.00),('1','147','768','257603',4903801,'2139','326',978851.08,979176.07,0.00,0.00,324.99,215793.36,0.00,0.00,0.00),('1','147','768','257603',4903802,'2942','326',158368.67,159108.08,0.00,0.00,739.41,490968.24,0.00,0.00,0.00),('1','147','768','257604',4903803,'2139','326',979176.07,979712.38,0.00,0.00,536.31,356109.84,0.00,0.00,0.00),('1','147','768','257604',4903804,'2942','326',159108.08,160634.30,0.00,0.00,1526.22,1013410.08,0.00,0.00,0.00),('1','147','768','257605',4903805,'2139','326',979712.38,979889.89,0.00,0.00,177.51,117866.64,0.00,0.00,0.00),('1','147','768','257605',4903806,'2942','326',160634.30,162945.44,0.00,0.00,2311.14,1534596.96,0.00,0.00,0.00),('1','147','768','257606',4903807,'2139','326',979889.89,980447.12,0.00,0.00,557.23,370000.72,0.00,0.00,0.00),('1','147','768','257606',4903808,'2942','326',162945.44,164321.29,0.00,0.00,1375.85,913564.40,0.00,0.00,0.00),('1','147','768','257607',4903809,'2139','326',980447.12,981736.93,0.00,0.00,1289.81,856433.84,0.00,0.00,0.00),('1','147','768','257607',4903810,'2942','326',164321.29,164697.79,0.00,0.00,376.50,249996.00,0.00,0.00,0.00),('1','147','768','257608',4903811,'2139','326',981736.93,981736.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257608',4903812,'2942','326',164697.79,166114.79,0.00,0.00,1417.00,940888.00,0.00,0.00,0.00),('1','147','768','257609',4903813,'2139','326',981736.93,981774.58,0.00,0.00,37.65,24999.60,0.00,0.00,0.00),('1','147','768','257609',4903814,'2942','326',166114.79,167730.48,0.00,0.00,1615.69,1072818.16,0.00,0.00,0.00),('1','147','768','257610',4903815,'2139','326',981774.58,982441.01,0.00,0.00,666.43,442509.52,0.00,0.00,0.00),('1','147','768','257610',4903816,'2942','326',167730.48,169557.98,0.00,0.00,1827.50,1213460.00,0.00,0.00,0.00),('1','147','768','257611',4903817,'2139','326',982441.01,983015.87,0.00,0.00,574.86,381707.04,0.00,0.00,0.00),('1','147','768','257611',4903818,'2942','326',169557.98,169982.45,0.00,0.00,424.47,281848.08,0.00,0.00,0.00),('1','147','768','257612',4903819,'2139','326',983015.87,983642.62,0.00,0.00,626.75,416162.00,0.00,0.00,0.00),('1','147','768','257612',4903820,'2942','326',169982.45,171602.68,0.00,0.00,1620.23,1075832.72,0.00,0.00,0.00),('1','147','768','257613',4903821,'2139','326',983642.62,983669.42,0.00,0.00,26.80,17795.20,0.00,0.00,0.00),('1','147','768','257613',4903822,'2942','326',171602.68,174104.90,0.00,0.00,2502.22,1661474.08,0.00,0.00,0.00),('1','147','768','257614',4903823,'2139','326',983669.42,983669.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257614',4903824,'2942','326',174104.90,174856.40,0.00,0.00,751.50,498996.00,0.00,0.00,0.00),('1','147','768','257615',4903825,'2139','326',983669.42,983673.94,0.00,0.00,4.52,3001.28,0.00,0.00,0.00),('1','147','768','257615',4903826,'2942','326',174856.40,176870.46,0.00,0.00,2014.06,1337335.84,0.00,0.00,0.00),('1','147','768','257616',4903827,'2139','326',983673.94,983676.95,0.00,0.00,3.01,1998.64,0.00,0.00,0.00),('1','147','768','257616',4903828,'2942','326',176870.46,177566.58,0.00,0.00,696.12,462223.68,0.00,0.00,0.00),('1','147','768','257617',4903829,'2139','326',983676.95,983676.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257617',4903830,'2942','326',177566.58,177925.97,0.00,0.00,359.39,238634.96,0.00,0.00,0.00),('1','147','768','257618',4903831,'2139','326',983676.95,983676.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257618',4903832,'2942','326',177925.97,179129.02,0.00,0.00,1203.05,798825.20,0.00,0.00,0.00),('1','147','768','257619',4903833,'2139','326',983676.95,983676.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257619',4903834,'2942','326',179129.02,181094.05,0.00,0.00,1965.03,1304779.92,0.00,0.00,0.00),('1','147','768','257620',4903835,'2139','326',983676.95,983682.97,0.00,0.00,6.02,3997.28,0.00,0.00,0.00),('1','147','768','257620',4903836,'2942','326',181094.05,183591.08,0.00,0.00,2497.03,1658027.92,0.00,0.00,0.00),('1','147','768','257621',4903837,'2139','326',983682.97,983699.24,0.00,0.00,16.27,10803.28,0.00,0.00,0.00),('1','147','768','257621',4903838,'2942','326',183591.08,184997.86,0.00,0.00,1406.78,934101.92,0.00,0.00,0.00),('1','147','768','257622',4903839,'2139','326',983699.24,983729.81,0.00,0.00,30.57,20298.48,0.00,0.00,0.00),('1','147','768','257622',4903840,'2942','326',184997.86,187752.53,0.00,0.00,2754.67,1829100.88,0.00,0.00,0.00),('1','147','768','257623',4903841,'2139','326',983729.81,983729.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257623',4903842,'2942','326',187752.53,188669.23,0.00,0.00,916.70,608688.80,0.00,0.00,0.00),('1','147','768','257624',4903843,'2139','326',983729.81,983729.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257624',4903844,'2942','326',188669.23,190820.14,0.00,0.00,2150.91,1428204.24,0.00,0.00,0.00),('1','147','768','257625',4903845,'2139','326',983729.81,983732.82,0.00,0.00,3.01,1998.64,0.00,0.00,0.00),('1','147','768','257625',4903846,'2942','326',190820.14,192054.40,0.00,0.00,1234.26,819548.64,0.00,0.00,0.00),('1','147','768','257626',4903847,'2139','326',983732.82,984066.22,0.00,0.00,333.40,221377.60,0.00,0.00,0.00),('1','147','768','257626',4903848,'2942','326',192054.40,193151.79,0.00,0.00,1097.39,728666.96,0.00,0.00,0.00),('1','147','768','257627',4903849,'2139','326',984066.22,985559.46,0.00,0.00,1493.24,1015403.20,0.00,0.00,0.00),('1','147','768','257627',4903850,'2942','326',193151.79,195388.85,0.00,0.00,2237.06,1521200.80,0.00,0.00,0.00),('1','147','768','257628',4903851,'2139','326',985559.46,985594.22,0.00,0.00,34.76,23636.80,0.00,0.00,0.00),('1','147','768','257628',4903852,'2942','326',195388.85,195388.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257629',4903853,'2139','326',985594.22,986178.36,0.00,0.00,584.14,397215.20,0.00,0.00,0.00),('1','147','768','257629',4903854,'2942','326',195388.85,196688.24,0.00,0.00,1299.39,883585.20,0.00,0.00,0.00),('1','147','768','257630',4903855,'2139','326',986178.36,987548.20,0.00,0.00,1369.84,931491.20,0.00,0.00,0.00),('1','147','768','257630',4903856,'2942','326',196688.24,197300.87,0.00,0.00,612.63,416588.40,0.00,0.00,0.00),('1','147','768','257631',4903857,'2139','326',987548.20,988128.99,0.00,0.00,580.79,394937.20,0.00,0.00,0.00),('1','147','768','257631',4903858,'2942','326',197300.87,198697.17,0.00,0.00,1396.30,949484.00,0.00,0.00,0.00),('1','147','768','257632',4903859,'2139','326',988128.99,988683.26,0.00,0.00,554.27,376903.60,0.00,0.00,0.00),('1','147','768','257632',4903860,'2942','326',198697.17,198850.99,0.00,0.00,153.82,104597.60,0.00,0.00,0.00),('1','147','768','257633',4903861,'2139','326',988683.26,990185.80,0.00,0.00,1502.54,1021727.20,0.00,0.00,0.00),('1','147','768','257633',4903862,'2942','326',198850.99,200616.23,0.00,0.00,1765.24,1200363.20,0.00,0.00,0.00),('1','147','768','257634',4903863,'2139','326',990185.80,990811.55,0.00,0.00,625.75,425510.00,0.00,0.00,0.00),('1','147','768','257634',4903864,'2942','326',200616.23,201689.67,0.00,0.00,1073.44,729939.20,0.00,0.00,0.00),('1','147','768','257635',4903865,'2139','326',990811.55,990811.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257635',4903866,'2942','326',201689.67,201876.53,0.00,0.00,186.86,127064.80,0.00,0.00,0.00),('1','147','768','257636',4903867,'2139','326',990811.55,991174.69,0.00,0.00,363.14,246935.20,0.00,0.00,0.00),('1','147','768','257636',4903868,'2942','326',201876.53,202423.09,0.00,0.00,546.56,371660.80,0.00,0.00,0.00),('1','147','768','257637',4903869,'2139','326',991174.69,992489.61,0.00,0.00,1314.92,894145.60,0.00,0.00,0.00),('1','147','768','257637',4903870,'2942','326',202423.09,203221.90,0.00,0.00,798.81,543190.80,0.00,0.00,0.00),('1','147','768','257638',4903871,'2139','326',992489.61,993257.54,0.00,0.00,767.93,552909.60,0.00,0.00,0.00),('1','147','768','257638',4903872,'2942','326',203221.90,203525.78,0.00,0.00,303.88,218793.60,0.00,0.00,0.00),('1','147','768','257639',4903873,'2139','326',993257.54,993289.90,0.00,0.00,32.36,23299.20,0.00,0.00,0.00),('1','147','768','257639',4903874,'2942','326',203525.78,203805.34,0.00,0.00,279.56,201283.20,0.00,0.00,0.00),('1','147','768','257640',4903875,'2139','326',993289.90,993601.57,0.00,0.00,311.67,224402.40,0.00,0.00,0.00),('1','147','768','257640',4903876,'2942','326',203805.34,204979.19,0.00,0.00,1173.85,845172.00,0.00,0.00,0.00),('1','147','768','257641',4903877,'2139','326',993601.57,994316.77,0.00,0.00,715.20,514944.00,0.00,0.00,0.00),('1','147','768','257641',4903878,'2942','326',204979.19,206749.68,0.00,0.00,1770.49,1274752.80,0.00,0.00,0.00),('1','147','768','257642',4903879,'2139','326',994316.77,995480.73,0.00,0.00,1163.96,838051.20,0.00,0.00,0.00),('1','147','768','257642',4903880,'2942','326',206749.68,207018.98,0.00,0.00,269.30,193896.00,0.00,0.00,0.00),('1','147','768','257643',4903881,'2139','326',995480.73,996581.16,0.00,0.00,1100.43,792309.60,0.00,0.00,0.00),('1','147','768','257643',4903882,'2942','326',207018.98,208320.86,0.00,0.00,1301.88,937353.60,0.00,0.00,0.00),('1','147','768','257644',4903883,'2139','326',996581.16,996838.30,0.00,0.00,257.14,195426.40,0.00,0.00,0.00),('1','147','768','257644',4903884,'2942','326',208320.86,210043.06,0.00,0.00,1722.20,1308872.00,0.00,0.00,0.00),('1','147','768','257645',4903885,'2139','326',996838.30,998832.65,0.00,0.00,1994.35,1515706.00,0.00,0.00,0.00),('1','147','768','257645',4903886,'2942','326',210043.06,211063.23,0.00,0.00,1020.17,775329.20,0.00,0.00,0.00),('1','147','768','257646',4903887,'2139','326',998832.65,1000156.57,0.00,0.00,1323.92,1006179.20,0.00,0.00,0.00),('1','147','768','257646',4903888,'2942','326',211063.23,211384.72,0.00,0.00,321.49,244332.40,0.00,0.00,0.00),('1','147','768','257647',4903889,'2139','326',1000156.57,1001376.53,0.00,0.00,1219.96,927169.60,0.00,0.00,0.00),('1','147','768','257647',4903890,'2942','326',211384.72,212393.16,0.00,0.00,1008.44,766414.40,0.00,0.00,0.00),('1','147','768','257648',4903891,'2139','326',1001376.53,1001989.37,0.00,0.00,612.84,465758.40,0.00,0.00,0.00),('1','147','768','257648',4903892,'2942','326',212393.16,214168.93,0.00,0.00,1775.77,1349585.20,0.00,0.00,0.00),('1','147','768','257649',4903893,'2139','326',1001989.37,1001989.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257649',4903894,'2942','326',214168.93,214602.22,0.00,0.00,433.29,329300.40,0.00,0.00,0.00),('1','147','768','257650',4903895,'2139','326',1001989.37,1002459.95,0.00,0.00,470.58,357640.80,0.00,0.00,0.00),('1','147','768','257650',4903896,'2942','326',214602.22,215515.34,0.00,0.00,913.12,693971.20,0.00,0.00,0.00),('1','147','768','257651',4903897,'2139','326',1002459.95,1003573.46,0.00,0.00,1113.51,846267.60,0.00,0.00,0.00),('1','147','768','257651',4903898,'2942','326',215515.34,216370.91,0.00,0.00,855.57,650233.20,0.00,0.00,0.00),('1','147','768','257652',4903899,'2139','326',1003573.46,1004364.59,0.00,0.00,791.13,601258.80,0.00,0.00,0.00),('1','147','768','257652',4903900,'2942','326',216370.91,217490.00,0.00,0.00,1119.09,850508.40,0.00,0.00,0.00),('1','147','768','257653',4903901,'2139','326',1004364.59,1005918.61,0.00,0.00,1554.02,1181055.20,0.00,0.00,0.00),('1','147','768','257653',4903902,'2942','326',217490.00,219125.56,0.00,0.00,1635.56,1243025.60,0.00,0.00,0.00),('1','147','768','257654',4903903,'2139','326',1005918.61,1007476.42,0.00,0.00,1557.81,1183935.60,0.00,0.00,0.00),('1','147','768','257654',4903904,'2942','326',219125.56,219572.10,0.00,0.00,446.54,339370.40,0.00,0.00,0.00),('1','147','768','257655',4903905,'2139','326',1007476.42,1008208.81,0.00,0.00,732.39,556616.40,0.00,0.00,0.00),('1','147','768','257655',4903906,'2942','326',219572.10,221238.85,0.00,0.00,1666.75,1266730.00,0.00,0.00,0.00),('1','147','768','257656',4903907,'2139','326',1008208.81,1008685.35,0.00,0.00,476.54,362170.40,0.00,0.00,0.00),('1','147','768','257656',4903908,'2942','326',221238.85,223036.99,0.00,0.00,1798.14,1366586.40,0.00,0.00,0.00),('1','147','768','257657',4903909,'2139','326',1008685.35,1008709.95,0.00,0.00,24.60,18696.00,0.00,0.00,0.00),('1','147','768','257657',4903910,'2942','326',223036.99,223873.48,0.00,0.00,836.49,635732.40,0.00,0.00,0.00),('1','147','768','257658',4903911,'2139','326',1008709.95,1008765.74,0.00,0.00,55.79,42400.40,0.00,0.00,0.00),('1','147','768','257658',4903912,'2942','326',223873.48,224732.33,0.00,0.00,858.85,652726.00,0.00,0.00,0.00),('1','147','768','257659',4903913,'2139','326',1008765.74,1009812.03,0.00,0.00,1046.29,795180.40,0.00,0.00,0.00),('1','147','768','257659',4903914,'2942','326',224732.33,225931.53,0.00,0.00,1199.20,911392.00,0.00,0.00,0.00),('1','147','768','257660',4903915,'2139','326',1009812.03,1010032.40,0.00,0.00,220.37,167481.20,0.00,0.00,0.00),('1','147','768','257660',4903916,'2942','326',225931.53,227502.82,0.00,0.00,1571.29,1194180.40,0.00,0.00,0.00),('1','147','768','257661',4903917,'2139','326',1010032.40,1010783.81,0.00,0.00,751.41,571071.60,0.00,0.00,0.00),('1','147','768','257661',4903918,'2942','326',227502.82,229342.41,0.00,0.00,1839.59,1398088.40,0.00,0.00,0.00),('1','147','768','257662',4903919,'2139','326',1010783.81,1011596.01,0.00,0.00,812.20,617272.00,0.00,0.00,0.00),('1','147','768','257662',4903920,'2942','326',229342.41,230535.45,0.00,0.00,1193.04,906710.40,0.00,0.00,0.00),('1','147','768','257663',4903921,'2139','326',1011596.01,1012024.94,0.00,0.00,428.93,325986.80,0.00,0.00,0.00),('1','147','768','257663',4903922,'2942','326',230535.45,230744.68,0.00,0.00,209.23,159014.80,0.00,0.00,0.00),('1','147','768','257664',4903923,'2139','326',1012024.94,1012125.94,0.00,0.00,101.00,76760.00,0.00,0.00,0.00),('1','147','768','257664',4903924,'2942','326',230744.68,231519.93,0.00,0.00,775.25,589190.00,0.00,0.00,0.00),('1','147','768','257665',4903925,'2139','326',1012125.94,1012851.13,0.00,0.00,725.19,551144.40,0.00,0.00,0.00),('1','147','768','257665',4903926,'2942','326',231519.93,232969.95,0.00,0.00,1450.02,1102015.20,0.00,0.00,0.00),('1','147','768','257666',4903927,'2139','326',1012851.13,1013514.95,0.00,0.00,663.82,504503.20,0.00,0.00,0.00),('1','147','768','257666',4903928,'2942','326',232969.95,234077.20,0.00,0.00,1107.25,841510.00,0.00,0.00,0.00),('1','147','768','257667',4903929,'2139','326',1013514.95,1013514.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257667',4903930,'2942','326',234077.20,234276.69,0.00,0.00,199.49,151612.40,0.00,0.00,0.00),('1','147','768','257668',4903931,'2139','326',1013514.95,1014238.43,0.00,0.00,723.48,549844.80,0.00,0.00,0.00),('1','147','768','257668',4903932,'2942','326',234276.69,234883.35,0.00,0.00,606.66,461061.60,0.00,0.00,0.00),('1','147','768','257669',4903933,'2139','326',1014238.43,1015525.60,0.00,0.00,1287.17,978249.20,0.00,0.00,0.00),('1','147','768','257669',4903934,'2942','326',234883.35,236283.37,0.00,0.00,1400.02,1064015.20,0.00,0.00,0.00),('1','147','768','257670',4903935,'2139','326',1015525.60,1015662.45,0.00,0.00,136.85,104006.00,0.00,0.00,0.00),('1','147','768','257670',4903936,'2942','326',236283.37,237162.76,0.00,0.00,879.39,668336.40,0.00,0.00,0.00),('1','147','768','257671',4903937,'2139','326',1015662.45,1016131.17,0.00,0.00,468.72,356227.20,0.00,0.00,0.00),('1','147','768','257671',4903938,'2942','326',237162.76,237657.54,0.00,0.00,494.78,376032.80,0.00,0.00,0.00),('1','147','768','257672',4903939,'2139','326',1016131.17,1016824.35,0.00,0.00,693.18,526816.80,0.00,0.00,0.00),('1','147','768','257672',4903940,'2942','326',237657.54,239164.69,0.00,0.00,1507.15,1145434.00,0.00,0.00,0.00),('1','147','768','257673',4903941,'2139','326',1016824.35,1017655.14,0.00,0.00,830.79,631400.40,0.00,0.00,0.00),('1','147','768','257673',4903942,'2942','326',239164.69,240200.17,0.00,0.00,1035.48,786964.80,0.00,0.00,0.00),('1','147','768','257674',4903943,'2139','326',1017655.14,1018025.11,0.00,0.00,369.97,281177.20,0.00,0.00,0.00),('1','147','768','257674',4903944,'2942','326',240200.17,240437.13,0.00,0.00,236.96,180089.60,0.00,0.00,0.00),('1','147','768','257675',4903945,'2139','326',1018025.11,1018454.61,0.00,0.00,429.50,326420.00,0.00,0.00,0.00),('1','147','768','257675',4903946,'2942','326',240437.13,241229.94,0.00,0.00,792.81,602535.60,0.00,0.00,0.00),('1','147','768','257676',4903947,'2139','326',1018454.61,1019812.33,0.00,0.00,1357.72,1031867.20,0.00,0.00,0.00),('1','147','768','257676',4903948,'2942','326',241229.94,242531.59,0.00,0.00,1301.65,989254.00,0.00,0.00,0.00),('1','147','768','257677',4903949,'2139','326',1019812.33,1020652.90,0.00,0.00,840.57,638833.20,0.00,0.00,0.00),('1','147','768','257677',4903950,'2942','326',242531.59,243233.21,0.00,0.00,701.62,533231.20,0.00,0.00,0.00),('1','147','768','257678',4903951,'2139','326',1020652.90,1020969.64,0.00,0.00,316.74,240722.40,0.00,0.00,0.00),('1','147','768','257678',4903952,'2942','326',243233.21,243532.37,0.00,0.00,299.16,227361.60,0.00,0.00,0.00),('1','147','768','257679',4903953,'2139','326',1020969.64,1023238.09,0.00,0.00,2268.45,1724022.00,0.00,0.00,0.00),('1','147','768','257679',4903954,'2942','326',243532.37,244729.70,0.00,0.00,1197.33,909970.80,0.00,0.00,0.00),('1','147','768','257680',4903955,'2139','326',1023238.09,1023724.55,0.00,0.00,486.46,369709.60,0.00,0.00,0.00),('1','147','768','257680',4903956,'2942','326',244729.70,245342.88,0.00,0.00,613.18,466016.80,0.00,0.00,0.00),('1','147','768','257681',4903957,'2139','326',1023724.55,1024764.87,0.00,0.00,1040.32,790643.20,0.00,0.00,0.00),('1','147','768','257681',4903958,'2942','326',245342.88,246187.24,0.00,0.00,844.36,641713.60,0.00,0.00,0.00),('1','147','768','257682',4903959,'2139','326',1024764.87,1025955.57,0.00,0.00,1190.70,904932.00,0.00,0.00,0.00),('1','147','768','257682',4903960,'2942','326',246187.24,247215.42,0.00,0.00,1028.18,781416.80,0.00,0.00,0.00),('1','147','768','257683',4903961,'2139','326',1025955.57,1026458.62,0.00,0.00,503.05,382318.00,0.00,0.00,0.00),('1','147','768','257683',4903962,'2942','326',247215.42,247597.20,0.00,0.00,381.78,290152.80,0.00,0.00,0.00),('1','147','768','257684',4903963,'2139','326',1026458.62,1027528.16,0.00,0.00,1069.54,812850.40,0.00,0.00,0.00),('1','147','768','257684',4903964,'2942','326',247597.20,247860.79,0.00,0.00,263.59,200328.40,0.00,0.00,0.00),('1','147','768','257685',4903965,'2139','326',1027528.16,1029367.44,0.00,0.00,1839.28,1397852.80,0.00,0.00,0.00),('1','147','768','257685',4903966,'2942','326',247860.79,248212.18,0.00,0.00,351.39,267056.40,0.00,0.00,0.00),('1','147','768','257686',4903967,'2139','326',1029367.44,1030707.19,0.00,0.00,1339.75,1018210.00,0.00,0.00,0.00),('1','147','768','257686',4903968,'2942','326',248212.18,248449.50,0.00,0.00,237.32,180363.20,0.00,0.00,0.00),('1','147','768','257687',4903969,'2139','326',1030707.19,1033192.70,0.00,0.00,2485.51,1888987.60,0.00,0.00,0.00),('1','147','768','257687',4903970,'2942','326',248449.50,248685.27,0.00,0.00,235.77,179185.20,0.00,0.00,0.00),('1','147','768','257688',4903971,'2139','326',1033192.70,1035328.89,0.00,0.00,2136.19,1623504.40,0.00,0.00,0.00),('1','147','768','257688',4903972,'2942','326',248685.27,248803.30,0.00,0.00,118.03,89702.80,0.00,0.00,0.00),('1','147','768','257689',4903973,'2139','326',1035328.89,1037157.54,0.00,0.00,1828.65,1389774.00,0.00,0.00,0.00),('1','147','768','257689',4903974,'2942','326',248803.30,248807.25,0.00,0.00,3.95,3002.00,0.00,0.00,0.00),('1','147','768','257690',4903975,'2139','326',1037157.54,1037443.33,0.00,0.00,285.79,217200.40,0.00,0.00,0.00),('1','147','768','257690',4903976,'2942','326',248807.25,248807.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257691',4903977,'2139','326',1037443.33,1038038.64,0.00,0.00,595.31,452435.60,0.00,0.00,0.00),('1','147','768','257691',4903978,'2942','326',248807.25,248807.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257692',4903979,'2139','326',1038038.64,1040064.20,0.00,0.00,2025.56,1539425.60,0.00,0.00,0.00),('1','147','768','257692',4903980,'2942','326',248807.25,248876.87,0.00,0.00,69.62,52911.20,0.00,0.00,0.00),('1','147','768','257693',4903981,'2139','326',1040064.20,1041192.05,0.00,0.00,1127.85,857166.00,0.00,0.00,0.00),('1','147','768','257693',4903982,'2942','326',248876.87,249161.70,0.00,0.00,284.83,216470.80,0.00,0.00,0.00),('1','147','768','257694',4903983,'2139','326',1041192.05,1043086.68,0.00,0.00,1894.63,1439918.80,0.00,0.00,0.00),('1','147','768','257694',4903984,'2942','326',249161.70,249675.46,0.00,0.00,513.76,390457.60,0.00,0.00,0.00),('1','147','768','257695',4903985,'2139','326',1043086.68,1045121.43,0.00,0.00,2034.75,1546410.00,0.00,0.00,0.00),('1','147','768','257695',4903986,'2942','326',249675.46,250071.32,0.00,0.00,395.86,300853.60,0.00,0.00,0.00),('1','147','768','257696',4903987,'2139','326',1045121.43,1045121.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257696',4903988,'2942','326',250071.32,250071.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257697',4903989,'2139','326',1045121.43,1045353.92,0.00,0.00,232.49,176692.40,0.00,0.00,0.00),('1','147','768','257697',4903990,'2942','326',250071.32,250145.66,0.00,0.00,74.34,56498.40,0.00,0.00,0.00),('1','147','768','257698',4903991,'2139','326',1045353.92,1045696.39,0.00,0.00,342.47,260277.20,0.00,0.00,0.00),('1','147','768','257698',4903992,'2942','326',250145.66,250199.87,0.00,0.00,54.21,41199.60,0.00,0.00,0.00),('1','147','768','257699',4903993,'2139','326',1045696.39,1047249.96,0.00,0.00,1553.57,1180713.20,0.00,0.00,0.00),('1','147','768','257699',4903994,'2942','326',250199.87,250690.26,0.00,0.00,490.39,372696.40,0.00,0.00,0.00),('1','147','768','257700',4903995,'2139','326',1047249.96,1048593.22,0.00,0.00,1343.26,1020877.60,0.00,0.00,0.00),('1','147','768','257700',4903996,'2942','326',250690.26,251277.26,0.00,0.00,587.00,446120.00,0.00,0.00,0.00),('1','147','768','257701',4903997,'2139','326',1048593.22,1049531.15,0.00,0.00,937.93,712826.80,0.00,0.00,0.00),('1','147','768','257701',4903998,'2942','326',251277.26,251401.87,0.00,0.00,124.61,94703.60,0.00,0.00,0.00),('1','147','768','257702',4903999,'2139','326',1049531.15,1050036.23,0.00,0.00,505.08,383860.80,0.00,0.00,0.00),('1','147','768','257702',4904000,'2942','326',251401.87,251723.39,0.00,0.00,321.52,244355.20,0.00,0.00,0.00),('1','147','768','257703',4904001,'2139','326',1050036.23,1051538.99,0.00,0.00,1502.76,1142097.60,0.00,0.00,0.00),('1','147','768','257703',4904002,'2942','326',251723.39,251993.28,0.00,0.00,269.89,205116.40,0.00,0.00,0.00),('1','147','768','257704',4904003,'2139','326',1051538.99,1053632.13,0.00,0.00,2093.14,1557296.16,0.00,0.00,0.00),('1','147','768','257704',4904004,'2942','326',251993.28,252438.98,0.00,0.00,445.70,331600.80,0.00,0.00,0.00),('1','147','768','257705',4904005,'2139','326',1053632.13,1055364.44,0.00,0.00,1732.31,1289594.64,0.00,0.00,0.00),('1','147','768','257705',4904006,'2942','326',252438.98,252971.62,0.00,0.00,532.64,396284.16,0.00,0.00,0.00),('1','147','768','257706',4904007,'2139','326',1055364.44,1056614.33,0.00,0.00,1249.89,929918.16,0.00,0.00,0.00),('1','147','768','257706',4904008,'2942','326',252971.62,253459.36,0.00,0.00,487.74,362878.56,0.00,0.00,0.00),('1','147','768','257707',4904009,'2139','326',1056614.33,1057548.31,0.00,0.00,933.98,694881.12,0.00,0.00,0.00),('1','147','768','257707',4904010,'2942','326',253459.36,253606.54,0.00,0.00,147.18,109501.92,0.00,0.00,0.00),('1','147','768','257708',4904011,'2139','326',1057548.31,1057548.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257708',4904012,'2942','326',253606.54,253606.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257709',4904013,'2139','326',1057548.31,1058146.26,0.00,0.00,597.95,444874.80,0.00,0.00,0.00),('1','147','768','257709',4904014,'2942','326',253606.54,253913.85,0.00,0.00,307.31,228638.64,0.00,0.00,0.00),('1','147','768','257710',4904015,'2139','326',1058146.26,1059586.29,0.00,0.00,1440.03,1071382.32,0.00,0.00,0.00),('1','147','768','257710',4904016,'2942','326',253913.85,254325.86,0.00,0.00,412.01,306535.44,0.00,0.00,0.00),('1','147','768','257711',4904017,'2139','326',1059586.29,1061205.51,0.00,0.00,1619.22,1204699.68,0.00,0.00,0.00),('1','147','768','257711',4904018,'2942','326',254325.86,254745.31,0.00,0.00,419.45,312070.80,0.00,0.00,0.00),('1','147','768','257712',4904019,'2139','326',1061205.51,1061368.35,0.00,0.00,162.84,121152.96,0.00,0.00,0.00),('1','147','768','257712',4904020,'2942','326',254745.31,254745.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257713',4904021,'2139','326',1061368.35,1062693.81,0.00,0.00,1325.46,986142.24,0.00,0.00,0.00),('1','147','768','257713',4904022,'2942','326',254745.31,255118.98,0.00,0.00,373.67,278010.48,0.00,0.00,0.00),('1','147','768','257714',4904023,'2139','326',1062693.81,1064883.89,0.00,0.00,2190.08,1629419.52,0.00,0.00,0.00),('1','147','768','257714',4904024,'2942','326',255118.98,255803.93,0.00,0.00,684.95,509602.80,0.00,0.00,0.00),('1','147','768','257715',4904025,'2139','326',1064883.89,1065229.03,0.00,0.00,345.14,256784.16,0.00,0.00,0.00),('1','147','768','257715',4904026,'2942','326',255803.93,256147.91,0.00,0.00,343.98,255921.12,0.00,0.00,0.00),('1','147','768','257716',4904027,'2139','326',1065229.03,1066646.92,0.00,0.00,1417.89,1054910.16,0.00,0.00,0.00),('1','147','768','257716',4904028,'2942','326',256147.91,256753.23,0.00,0.00,605.32,450358.08,0.00,0.00,0.00),('1','147','768','257717',4904029,'2139','326',1066646.92,1068141.43,0.00,0.00,1494.51,1111915.44,0.00,0.00,0.00),('1','147','768','257717',4904030,'2942','326',256753.23,257336.94,0.00,0.00,583.71,434280.24,0.00,0.00,0.00),('1','147','768','257718',4904031,'2139','326',1068141.43,1068964.30,0.00,0.00,822.87,612215.28,0.00,0.00,0.00),('1','147','768','257718',4904032,'2942','326',257336.94,257467.73,0.00,0.00,130.79,97307.76,0.00,0.00,0.00),('1','147','768','257719',4904033,'2139','326',1068964.30,1069639.25,0.00,0.00,674.95,502162.80,0.00,0.00,0.00),('1','147','768','257719',4904034,'2942','326',257467.73,257964.20,0.00,0.00,496.47,369373.68,0.00,0.00,0.00),('1','147','768','257720',4904035,'2139','326',1069639.25,1071366.72,0.00,0.00,1727.47,1285237.68,0.00,0.00,0.00),('1','147','768','257720',4904036,'2942','326',257964.20,258635.63,0.00,0.00,671.43,499543.92,0.00,0.00,0.00),('1','147','768','257721',4904037,'2139','326',1071366.72,1072510.26,0.00,0.00,1143.54,850793.76,0.00,0.00,0.00),('1','147','768','257721',4904038,'2942','326',258635.63,259137.97,0.00,0.00,502.34,373740.96,0.00,0.00,0.00),('1','147','768','257722',4904039,'2139','326',1072510.26,1073280.58,0.00,0.00,770.32,573118.08,0.00,0.00,0.00),('1','147','768','257722',4904040,'2942','326',259137.97,259259.14,0.00,0.00,121.17,90150.48,0.00,0.00,0.00),('1','147','768','257723',4904041,'2139','326',1073280.58,1075185.98,0.00,0.00,1905.40,1417617.60,0.00,0.00,0.00),('1','147','768','257723',4904042,'2942','326',259259.14,259949.73,0.00,0.00,690.59,513798.96,0.00,0.00,0.00),('1','147','768','257724',4904043,'2139','326',1075185.98,1076515.65,0.00,0.00,1329.67,989274.48,0.00,0.00,0.00),('1','147','768','257724',4904044,'2942','326',259949.73,260379.70,0.00,0.00,429.97,319897.68,0.00,0.00,0.00),('1','147','768','257725',4904045,'2139','326',1076515.65,1076889.99,0.00,0.00,374.34,278508.96,0.00,0.00,0.00),('1','147','768','257725',4904046,'2942','326',260379.70,260566.22,0.00,0.00,186.52,138770.88,0.00,0.00,0.00),('1','147','768','257726',4904047,'2139','326',1076889.99,1078942.67,0.00,0.00,2052.68,1527193.92,0.00,0.00,0.00),('1','147','768','257726',4904048,'2942','326',260566.22,261183.77,0.00,0.00,617.55,459457.20,0.00,0.00,0.00),('1','147','768','257727',4904049,'2139','326',1078942.67,1079599.62,0.00,0.00,656.95,499282.00,0.00,0.00,0.00),('1','147','768','257727',4904050,'2942','326',261183.77,261591.97,0.00,0.00,408.20,310232.00,0.00,0.00,0.00),('1','147','768','257728',4904051,'2139','326',1079599.62,1080362.43,0.00,0.00,762.81,579735.60,0.00,0.00,0.00),('1','147','768','257728',4904052,'2942','326',261591.97,261794.76,0.00,0.00,202.79,154120.40,0.00,0.00,0.00),('1','147','768','257729',4904053,'2139','326',1080362.43,1081227.99,0.00,0.00,865.56,657825.60,0.00,0.00,0.00),('1','147','768','257729',4904054,'2942','326',261794.76,262310.38,0.00,0.00,515.62,391871.20,0.00,0.00,0.00),('1','147','768','257730',4904055,'2139','326',1081227.99,1081477.72,0.00,0.00,249.73,189794.80,0.00,0.00,0.00),('1','147','768','257730',4904056,'2942','326',262310.38,262376.30,0.00,0.00,65.92,50099.20,0.00,0.00,0.00),('1','147','768','257731',4904057,'2139','326',1081477.72,1082723.05,0.00,0.00,1245.33,946450.80,0.00,0.00,0.00),('1','147','768','257731',4904058,'2942','326',262376.30,263089.62,0.00,0.00,713.32,542123.20,0.00,0.00,0.00),('1','147','768','257732',4904059,'2139','326',1082723.05,1083833.33,0.00,0.00,1110.28,843812.80,0.00,0.00,0.00),('1','147','768','257732',4904060,'2942','326',263089.62,263689.24,0.00,0.00,599.62,455711.20,0.00,0.00,0.00),('1','147','768','257733',4904061,'2139','326',1083833.33,1084479.67,0.00,0.00,646.34,491218.40,0.00,0.00,0.00),('1','147','768','257733',4904062,'2942','326',263689.24,264251.66,0.00,0.00,562.42,427439.20,0.00,0.00,0.00),('1','147','768','257734',4904063,'2139','326',1084479.67,1084929.67,0.00,0.00,450.00,342000.00,0.00,0.00,0.00),('1','147','768','257734',4904064,'2942','326',264251.66,264356.28,0.00,0.00,104.62,79511.20,0.00,0.00,0.00),('1','147','768','257735',4904065,'2139','326',1084929.67,1086630.13,0.00,0.00,1700.46,1292349.60,0.00,0.00,0.00),('1','147','768','257735',4904066,'2942','326',264356.28,265425.99,0.00,0.00,1069.71,812979.60,0.00,0.00,0.00),('1','147','768','257736',4904067,'2139','326',1086630.13,1087754.30,0.00,0.00,1124.17,854369.20,0.00,0.00,0.00),('1','147','768','257736',4904068,'2942','326',265425.99,266067.78,0.00,0.00,641.79,487760.40,0.00,0.00,0.00),('1','147','768','257737',4904069,'2139','326',1087754.30,1087906.80,0.00,0.00,152.50,115900.00,0.00,0.00,0.00),('1','147','768','257737',4904070,'2942','326',266067.78,266187.60,0.00,0.00,119.82,91063.20,0.00,0.00,0.00),('1','147','768','257738',4904071,'2139','326',1087906.80,1089303.96,0.00,0.00,1397.16,1061841.60,0.00,0.00,0.00),('1','147','768','257738',4904072,'2942','326',266187.60,266886.07,0.00,0.00,698.47,530837.20,0.00,0.00,0.00),('1','147','768','257739',4904073,'2139','326',1089303.96,1090791.37,0.00,0.00,1487.41,1106633.04,0.00,0.00,0.00),('1','147','768','257739',4904074,'2942','326',266886.07,267707.45,0.00,0.00,821.38,611106.72,0.00,0.00,0.00),('1','147','768','257740',4904075,'2139','326',1090791.37,1090927.34,0.00,0.00,135.97,101161.68,0.00,0.00,0.00),('1','147','768','257740',4904076,'2942','326',267707.45,267809.40,0.00,0.00,101.95,75850.80,0.00,0.00,0.00),('1','147','768','257741',4904077,'2139','326',1090927.34,1091789.77,0.00,0.00,862.43,641647.92,0.00,0.00,0.00),('1','147','768','257741',4904078,'2942','326',267809.40,268322.49,0.00,0.00,513.09,381738.96,0.00,0.00,0.00),('1','147','768','257742',4904079,'2139','326',1091789.77,1092304.62,0.00,0.00,514.85,383048.40,0.00,0.00,0.00),('1','147','768','257742',4904080,'2942','326',268322.49,268582.55,0.00,0.00,260.06,193484.64,0.00,0.00,0.00),('1','147','768','257743',4904081,'2139','326',1092304.62,1093749.30,0.00,0.00,1444.68,1074841.92,0.00,0.00,0.00),('1','147','768','257743',4904082,'2942','326',268582.55,269157.37,0.00,0.00,574.82,427666.08,0.00,0.00,0.00),('1','147','768','257744',4904083,'2139','326',1093749.30,1094185.33,0.00,0.00,436.03,324406.32,0.00,0.00,0.00),('1','147','768','257744',4904084,'2942','326',269157.37,269775.34,0.00,0.00,617.97,459769.68,0.00,0.00,0.00),('1','147','768','257745',4904085,'2139','326',1094185.33,1095370.13,0.00,0.00,1184.80,881491.20,0.00,0.00,0.00),('1','147','768','257745',4904086,'2942','326',269775.34,269882.48,0.00,0.00,107.14,79712.16,0.00,0.00,0.00),('1','147','768','257746',4904087,'2139','326',1095370.13,1097166.24,0.00,0.00,1796.11,1336305.84,0.00,0.00,0.00),('1','147','768','257746',4904088,'2942','326',269882.48,270509.47,0.00,0.00,626.99,466480.56,0.00,0.00,0.00),('1','147','768','257747',4904089,'2139','326',1097166.24,1098242.02,0.00,0.00,1075.78,800380.32,0.00,0.00,0.00),('1','147','768','257747',4904090,'2942','326',270509.47,270858.56,0.00,0.00,349.09,259722.96,0.00,0.00,0.00),('1','147','768','257748',4904091,'2139','326',1098242.02,1099631.29,0.00,0.00,1389.27,1033616.88,0.00,0.00,0.00),('1','147','768','257748',4904092,'2942','326',270858.56,271321.85,0.00,0.00,463.29,344687.76,0.00,0.00,0.00),('1','147','768','257749',4904093,'2139','326',1099631.29,1101043.44,0.00,0.00,1412.15,1050639.60,0.00,0.00,0.00),('1','147','768','257749',4904094,'2942','326',271321.85,271736.09,0.00,0.00,414.24,308194.56,0.00,0.00,0.00),('1','147','768','257750',4904095,'2139','326',1101043.44,1102540.35,0.00,0.00,1496.91,1113701.04,0.00,0.00,0.00),('1','147','768','257750',4904096,'2942','326',271736.09,272211.66,0.00,0.00,475.57,353824.08,0.00,0.00,0.00),('1','147','768','257751',4904097,'2139','326',1102540.35,1102540.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257751',4904098,'2942','326',272211.66,272211.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257752',4904099,'2139','326',1102540.35,1103540.00,0.00,0.00,999.65,743739.60,0.00,0.00,0.00),('1','147','768','257752',4904100,'2942','326',272211.66,273109.86,0.00,0.00,898.20,668260.80,0.00,0.00,0.00),('1','147','768','257753',4904101,'2139','326',1103540.00,1105045.52,0.00,0.00,1505.52,1120106.88,0.00,0.00,0.00),('1','147','768','257753',4904102,'2942','326',273109.86,274303.09,0.00,0.00,1193.23,887763.12,0.00,0.00,0.00),('1','147','768','257754',4904103,'2139','326',1105045.52,1105164.68,0.00,0.00,119.16,88655.04,0.00,0.00,0.00),('1','147','768','257754',4904104,'2942','326',274303.09,274391.80,0.00,0.00,88.71,66000.24,0.00,0.00,0.00),('1','147','768','257755',4904105,'2139','326',1105164.68,1106203.92,0.00,0.00,1039.24,773194.56,0.00,0.00,0.00),('1','147','768','257755',4904106,'2942','326',274391.80,274915.11,0.00,0.00,523.31,389342.64,0.00,0.00,0.00),('1','147','768','257756',4904107,'2139','326',1106203.92,1107111.46,0.00,0.00,907.54,675209.76,0.00,0.00,0.00),('1','147','768','257756',4904108,'2942','326',274915.11,275499.26,0.00,0.00,584.15,434607.60,0.00,0.00,0.00),('1','147','768','257757',4904109,'2139','326',1107111.46,1108234.84,0.00,0.00,1123.38,835794.72,0.00,0.00,0.00),('1','147','768','257757',4904110,'2942','326',275499.26,276496.73,0.00,0.00,997.47,742117.68,0.00,0.00,0.00),('1','147','768','257758',4904111,'2139','326',1108234.84,1109449.84,0.00,0.00,1215.00,903960.00,0.00,0.00,0.00),('1','147','768','257758',4904112,'2942','326',276496.73,277263.40,0.00,0.00,766.67,570402.48,0.00,0.00,0.00),('1','147','768','257759',4904113,'2139','326',1109449.84,1110292.70,0.00,0.00,842.86,627087.84,0.00,0.00,0.00),('1','147','768','257759',4904114,'2942','326',277263.40,277801.91,0.00,0.00,538.51,400651.44,0.00,0.00,0.00),('1','147','768','257760',4904115,'2139','326',1110292.70,1110565.84,0.00,0.00,273.14,203216.16,0.00,0.00,0.00),('1','147','768','257760',4904116,'2942','326',277801.91,277934.84,0.00,0.00,132.93,98899.92,0.00,0.00,0.00),('1','147','768','257761',4904117,'2139','326',1110565.84,1111093.16,0.00,0.00,527.32,392326.08,0.00,0.00,0.00),('1','147','768','257761',4904118,'2942','326',277934.84,278222.69,0.00,0.00,287.85,214160.40,0.00,0.00,0.00),('1','147','768','257762',4904119,'2139','326',1111093.16,1111831.21,0.00,0.00,738.05,549109.20,0.00,0.00,0.00),('1','147','768','257762',4904120,'2942','326',278222.69,278926.80,0.00,0.00,704.11,523857.84,0.00,0.00,0.00),('1','147','768','257763',4904121,'2139','326',1111831.21,1113815.40,0.00,0.00,1984.19,1476237.36,0.00,0.00,0.00),('1','147','768','257763',4904122,'2942','326',278926.80,279849.12,0.00,0.00,922.32,686206.08,0.00,0.00,0.00),('1','147','768','257764',4904123,'2139','326',1113815.40,1114316.28,0.00,0.00,500.88,372654.72,0.00,0.00,0.00),('1','147','768','257764',4904124,'2942','326',279849.12,280230.78,0.00,0.00,381.66,283955.04,0.00,0.00,0.00),('1','147','768','257765',4904125,'2139','326',1114316.28,1115015.91,0.00,0.00,699.63,520524.72,0.00,0.00,0.00),('1','147','768','257765',4904126,'2942','326',280230.78,280509.86,0.00,0.00,279.08,207635.52,0.00,0.00,0.00),('1','147','768','257766',4904127,'2139','326',1115015.91,1116403.45,0.00,0.00,1387.54,1032329.76,0.00,0.00,0.00),('1','147','768','257766',4904128,'2942','326',280509.86,281267.39,0.00,0.00,757.53,563602.32,0.00,0.00,0.00),('1','147','768','257767',4904129,'2139','326',1116403.45,1117609.93,0.00,0.00,1206.48,897621.12,0.00,0.00,0.00),('1','147','768','257767',4904130,'2942','326',281267.39,281800.67,0.00,0.00,533.28,396760.32,0.00,0.00,0.00),('1','147','768','257768',4904131,'2139','326',1117609.93,1118818.14,0.00,0.00,1208.21,898908.24,0.00,0.00,0.00),('1','147','768','257768',4904132,'2942','326',281800.67,282562.69,0.00,0.00,762.02,566942.88,0.00,0.00,0.00),('1','147','768','257769',4904133,'2139','326',1118818.14,1120188.71,0.00,0.00,1370.57,1019704.08,0.00,0.00,0.00),('1','147','768','257769',4904134,'2942','326',282562.69,283080.76,0.00,0.00,518.07,385444.08,0.00,0.00,0.00),('1','147','768','257770',4904135,'2139','326',1120188.71,1120436.58,0.00,0.00,247.87,184415.28,0.00,0.00,0.00),('1','147','768','257770',4904136,'2942','326',283080.76,283470.71,0.00,0.00,389.95,290122.80,0.00,0.00,0.00),('1','147','768','257771',4904137,'2139','326',1120436.58,1120920.88,0.00,0.00,484.30,360319.20,0.00,0.00,0.00),('1','147','768','257771',4904138,'2942','326',283470.71,283470.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257772',4904139,'2139','326',1120920.88,1121855.10,0.00,0.00,934.22,695059.68,0.00,0.00,0.00),('1','147','768','257772',4904140,'2942','326',283470.71,284218.69,0.00,0.00,747.98,556497.12,0.00,0.00,0.00),('1','147','768','257773',4904141,'2139','326',1121855.10,1122927.18,0.00,0.00,1072.08,797627.52,0.00,0.00,0.00),('1','147','768','257773',4904142,'2942','326',284218.69,285694.59,0.00,0.00,1475.90,1098069.60,0.00,0.00,0.00),('1','147','768','257774',4904143,'2139','326',1122927.18,1123483.75,0.00,0.00,556.57,414088.08,0.00,0.00,0.00),('1','147','768','257774',4904144,'2942','326',285694.59,286057.22,0.00,0.00,362.63,269796.72,0.00,0.00,0.00),('1','147','768','257775',4904145,'2139','326',1123483.75,1124883.33,0.00,0.00,1399.58,1041287.52,0.00,0.00,0.00),('1','147','768','257775',4904146,'2942','326',286057.22,287081.11,0.00,0.00,1023.89,761774.16,0.00,0.00,0.00),('1','147','768','257776',4904147,'2139','326',1124883.33,1125476.99,0.00,0.00,593.66,441683.04,0.00,0.00,0.00),('1','147','768','257776',4904148,'2942','326',287081.11,287573.67,0.00,0.00,492.56,366464.64,0.00,0.00,0.00),('1','147','768','257777',4904149,'2139','326',1125476.99,1126314.69,0.00,0.00,837.70,623248.80,0.00,0.00,0.00),('1','147','768','257777',4904150,'2942','326',287573.67,287808.67,0.00,0.00,235.00,174840.00,0.00,0.00,0.00),('1','147','768','257778',4904151,'2139','326',1126314.69,1127502.35,0.00,0.00,1187.66,883619.04,0.00,0.00,0.00),('1','147','768','257778',4904152,'2942','326',287808.67,288759.75,0.00,0.00,951.08,707603.52,0.00,0.00,0.00),('1','147','768','257779',4904153,'2139','326',1127502.35,1128614.46,0.00,0.00,1112.11,827409.84,0.00,0.00,0.00),('1','147','768','257779',4904154,'2942','326',288759.75,289660.50,0.00,0.00,900.75,670158.00,0.00,0.00,0.00),('1','147','768','257780',4904155,'2139','326',1128614.46,1128784.29,0.00,0.00,169.83,124994.88,0.00,0.00,0.00),('1','147','768','257780',4904156,'2942','326',289660.50,289917.20,0.00,0.00,256.70,188931.20,0.00,0.00,0.00),('1','147','768','257781',4904157,'2139','326',1128784.29,1129950.93,0.00,0.00,1166.64,858647.04,0.00,0.00,0.00),('1','147','768','257781',4904158,'2942','326',289917.20,290424.00,0.00,0.00,506.80,373004.80,0.00,0.00,0.00),('1','147','768','257782',4904159,'2139','326',1129950.93,1131617.51,0.00,0.00,1666.58,1226602.88,0.00,0.00,0.00),('1','147','768','257782',4904160,'2942','326',290424.00,291631.43,0.00,0.00,1207.43,888668.48,0.00,0.00,0.00),('1','147','768','257783',4904161,'2139','326',1131617.51,1131848.19,0.00,0.00,230.68,169780.48,0.00,0.00,0.00),('1','147','768','257783',4904162,'2942','326',291631.43,291980.89,0.00,0.00,349.46,257202.56,0.00,0.00,0.00),('1','147','768','257784',4904163,'2139','326',1131848.19,1132305.08,0.00,0.00,456.89,336271.04,0.00,0.00,0.00),('1','147','768','257784',4904164,'2942','326',291980.89,292443.30,0.00,0.00,462.41,340333.76,0.00,0.00,0.00),('1','147','768','257785',4904165,'2139','326',1132305.08,1133220.35,0.00,0.00,915.27,673638.72,0.00,0.00,0.00),('1','147','768','257785',4904166,'2942','326',292443.30,293278.90,0.00,0.00,835.60,615001.60,0.00,0.00,0.00),('1','147','768','257786',4904167,'2139','326',1133220.35,1134105.67,0.00,0.00,885.32,651595.52,0.00,0.00,0.00),('1','147','768','257786',4904168,'2942','326',293278.90,294078.25,0.00,0.00,799.35,588321.60,0.00,0.00,0.00),('1','147','768','257787',4904169,'2139','326',1134105.67,1134257.65,0.00,0.00,151.98,111857.28,0.00,0.00,0.00),('1','147','768','257787',4904170,'2942','326',294078.25,294476.28,0.00,0.00,398.03,292950.08,0.00,0.00,0.00),('1','147','768','257788',4904171,'2139','326',1134257.65,1135013.62,0.00,0.00,755.97,556393.92,0.00,0.00,0.00),('1','147','768','257788',4904172,'2942','326',294476.28,295051.72,0.00,0.00,575.44,423523.84,0.00,0.00,0.00),('1','147','768','257789',4904173,'2139','326',1135013.62,1135860.31,0.00,0.00,846.69,623163.84,0.00,0.00,0.00),('1','147','768','257789',4904174,'2942','326',295051.72,296154.97,0.00,0.00,1103.25,811992.00,0.00,0.00,0.00),('1','147','768','257790',4904175,'2139','326',1135860.31,1136477.48,0.00,0.00,617.17,454237.12,0.00,0.00,0.00),('1','147','768','257790',4904176,'2942','326',296154.97,297045.46,0.00,0.00,890.49,655400.64,0.00,0.00,0.00),('1','147','768','257791',4904177,'2139','326',1136477.48,1136856.67,0.00,0.00,379.19,279083.84,0.00,0.00,0.00),('1','147','768','257791',4904178,'2942','326',297045.46,297603.54,0.00,0.00,558.08,410746.88,0.00,0.00,0.00),('1','147','768','257792',4904179,'2139','326',1136856.67,1138002.52,0.00,0.00,1145.85,843345.60,0.00,0.00,0.00),('1','147','768','257792',4904180,'2942','326',297603.54,298107.66,0.00,0.00,504.12,371032.32,0.00,0.00,0.00),('1','147','768','257793',4904181,'2139','326',1138002.52,1138771.36,0.00,0.00,768.84,565866.24,0.00,0.00,0.00),('1','147','768','257793',4904182,'2942','326',298107.66,299303.11,0.00,0.00,1195.45,879851.20,0.00,0.00,0.00),('1','147','768','257794',4904183,'2139','326',1138771.36,1139469.15,0.00,0.00,697.79,513573.44,0.00,0.00,0.00),('1','147','768','257794',4904184,'2942','326',299303.11,300161.77,0.00,0.00,858.66,631973.76,0.00,0.00,0.00),('1','147','768','257795',4904185,'2139','326',1139469.15,1140172.10,0.00,0.00,702.95,517371.20,0.00,0.00,0.00),('1','147','768','257795',4904186,'2942','326',300161.77,301455.67,0.00,0.00,1293.90,952310.40,0.00,0.00,0.00),('1','147','768','257796',4904187,'2139','326',1140172.10,1141810.14,0.00,0.00,1638.04,1205597.44,0.00,0.00,0.00),('1','147','768','257796',4904188,'2942','326',301455.67,301743.71,0.00,0.00,288.04,211997.44,0.00,0.00,0.00),('1','147','768','257797',4904189,'2139','326',1141810.14,1142960.03,0.00,0.00,1149.89,846319.04,0.00,0.00,0.00),('1','147','768','257797',4904190,'2942','326',301743.71,301904.85,0.00,0.00,161.14,118599.04,0.00,0.00,0.00),('1','147','768','257798',4904191,'2139','326',1142960.03,1145126.02,0.00,0.00,2165.99,1594168.64,0.00,0.00,0.00),('1','147','768','257798',4904192,'2942','326',301904.85,302862.38,0.00,0.00,957.53,704742.08,0.00,0.00,0.00),('1','147','768','257799',4904193,'2139','326',1145126.02,1146291.04,0.00,0.00,1165.02,857454.72,0.00,0.00,0.00),('1','147','768','257799',4904194,'2942','326',302862.38,303110.37,0.00,0.00,247.99,182520.64,0.00,0.00,0.00),('1','147','768','257800',4904195,'2139','326',1146291.04,1146660.68,0.00,0.00,369.64,272055.04,0.00,0.00,0.00),('1','147','768','257800',4904196,'2942','326',303110.37,303614.69,0.00,0.00,504.32,371179.52,0.00,0.00,0.00),('1','147','768','257801',4904197,'2139','326',1146660.68,1148982.39,0.00,0.00,2321.71,1708778.56,0.00,0.00,0.00),('1','147','768','257801',4904198,'2942','326',303614.69,304120.64,0.00,0.00,505.95,372379.20,0.00,0.00,0.00),('1','147','768','257802',4904199,'2139','326',1148982.39,1149987.27,0.00,0.00,1004.88,739591.68,0.00,0.00,0.00),('1','147','768','257802',4904200,'2942','326',304120.64,304386.74,0.00,0.00,266.10,195849.60,0.00,0.00,0.00),('1','147','768','257803',4904201,'2139','326',1149987.27,1152305.40,0.00,0.00,2318.13,1706143.68,0.00,0.00,0.00),('1','147','768','257803',4904202,'2942','326',304386.74,304824.86,0.00,0.00,438.12,322456.32,0.00,0.00,0.00),('1','147','768','257804',4904203,'2139','326',1152305.40,1153053.52,0.00,0.00,748.12,550616.32,0.00,0.00,0.00),('1','147','768','257804',4904204,'2942','326',304824.86,305916.12,0.00,0.00,1091.26,803167.36,0.00,0.00,0.00),('1','147','768','257805',4904205,'2139','326',1153053.52,1153973.58,0.00,0.00,920.06,694308.42,0.00,0.00,0.00),('1','147','768','257805',4904206,'2942','326',305916.12,306279.48,0.00,0.00,363.36,274150.44,0.00,0.00,0.00),('1','147','768','257806',4904207,'2139','326',1153973.58,1155188.44,0.00,0.00,1214.86,908715.28,0.00,0.00,0.00),('1','147','768','257806',4904208,'2942','326',306279.48,307328.31,0.00,0.00,1048.83,784524.84,0.00,0.00,0.00),('1','147','768','257807',4904209,'2139','326',1155188.44,1155494.63,0.00,0.00,306.19,229030.12,0.00,0.00,0.00),('1','147','768','257807',4904210,'2942','326',307328.31,307903.66,0.00,0.00,575.35,430361.80,0.00,0.00,0.00),('1','147','768','257808',4904211,'2139','326',1155494.63,1156120.08,0.00,0.00,625.45,467836.60,0.00,0.00,0.00),('1','147','768','257808',4904212,'2942','326',307903.66,308050.24,0.00,0.00,146.58,109641.84,0.00,0.00,0.00),('1','147','768','257809',4904213,'2139','326',1156120.08,1157131.65,0.00,0.00,1011.57,756654.36,0.00,0.00,0.00),('1','147','768','257809',4904214,'2942','326',308050.24,308915.42,0.00,0.00,865.18,647154.64,0.00,0.00,0.00),('1','147','768','257810',4904215,'2139','326',1157131.65,1157131.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257810',4904216,'2942','326',308915.42,308915.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257811',4904217,'2139','326',1157131.65,1158501.74,0.00,0.00,1370.09,1024827.32,0.00,0.00,0.00),('1','147','768','257811',4904218,'2942','326',308915.42,309936.99,0.00,0.00,1021.57,764134.36,0.00,0.00,0.00),('1','147','768','257812',4904219,'2139','326',1158501.74,1158501.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257812',4904220,'2942','326',309936.99,309936.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257813',4904221,'2139','326',1158501.74,1159996.71,0.00,0.00,1494.97,1118237.56,0.00,0.00,0.00),('1','147','768','257813',4904222,'2942','326',309936.99,310520.65,0.00,0.00,583.66,436577.68,0.00,0.00,0.00),('1','147','768','257814',4904223,'2139','326',1159996.71,1161075.86,0.00,0.00,1079.15,807204.20,0.00,0.00,0.00),('1','147','768','257814',4904224,'2942','326',310520.65,311226.89,0.00,0.00,706.24,528267.52,0.00,0.00,0.00),('1','147','768','257815',4904225,'2139','326',1161075.86,1162207.05,0.00,0.00,1131.19,846130.12,0.00,0.00,0.00),('1','147','768','257815',4904226,'2942','326',311226.89,311369.69,0.00,0.00,142.80,106814.40,0.00,0.00,0.00),('1','147','768','257816',4904227,'2139','326',1162207.05,1162435.24,0.00,0.00,228.19,170686.12,0.00,0.00,0.00),('1','147','768','257816',4904228,'2942','326',311369.69,311425.70,0.00,0.00,56.01,41895.48,0.00,0.00,0.00),('1','147','768','257817',4904229,'2139','326',1162435.24,1163309.00,0.00,0.00,873.76,664057.60,0.00,0.00,0.00),('1','147','768','257817',4904230,'2942','326',311425.70,311826.49,0.00,0.00,400.79,304600.40,0.00,0.00,0.00),('1','147','768','257818',4904231,'2139','326',1163309.00,1164584.42,0.00,0.00,1275.42,969319.20,0.00,0.00,0.00),('1','147','768','257818',4904232,'2942','326',311826.49,312822.79,0.00,0.00,996.30,757188.00,0.00,0.00,0.00),('1','147','768','257819',4904233,'2139','326',1164584.42,1165726.25,0.00,0.00,1141.83,867790.80,0.00,0.00,0.00),('1','147','768','257819',4904234,'2942','326',312822.79,313187.59,0.00,0.00,364.80,277248.00,0.00,0.00,0.00),('1','147','768','257820',4904235,'2139','326',1165726.25,1168013.12,0.00,0.00,2286.87,1738021.20,0.00,0.00,0.00),('1','147','768','257820',4904236,'2942','326',313187.59,313999.82,0.00,0.00,812.23,617294.80,0.00,0.00,0.00),('1','147','768','257821',4904237,'2139','326',1168013.12,1168265.11,0.00,0.00,251.99,191512.40,0.00,0.00,0.00),('1','147','768','257821',4904238,'2942','326',313999.82,314536.60,0.00,0.00,536.78,407952.80,0.00,0.00,0.00),('1','147','768','257822',4904239,'2139','326',1168265.11,1168807.70,0.00,0.00,542.59,412368.40,0.00,0.00,0.00),('1','147','768','257822',4904240,'2942','326',314536.60,314755.09,0.00,0.00,218.49,166052.40,0.00,0.00,0.00),('1','147','768','257823',4904241,'2139','326',1168807.70,1169940.02,0.00,0.00,1132.32,860563.20,0.00,0.00,0.00),('1','147','768','257823',4904242,'2942','326',314755.09,315485.09,0.00,0.00,730.00,554800.00,0.00,0.00,0.00),('1','147','768','257824',4904243,'2139','326',1169940.02,1170871.01,0.00,0.00,930.99,707552.40,0.00,0.00,0.00),('1','147','768','257824',4904244,'2942','326',315485.09,316199.32,0.00,0.00,714.23,542814.80,0.00,0.00,0.00),('1','147','768','257825',4904245,'2139','326',1170871.01,1171140.47,0.00,0.00,269.46,215568.00,0.00,0.00,0.00),('1','147','768','257825',4904246,'2942','326',316199.32,316555.17,0.00,0.00,355.85,284680.00,0.00,0.00,0.00),('1','147','768','257826',4904247,'2139','326',1171140.47,1171661.86,0.00,0.00,521.39,417112.00,0.00,0.00,0.00),('1','147','768','257826',4904248,'2942','326',316555.17,316715.19,0.00,0.00,160.02,128016.00,0.00,0.00,0.00),('1','147','768','257827',4904249,'2139','326',1171661.86,1172815.51,0.00,0.00,1153.65,922920.00,0.00,0.00,0.00),('1','147','768','257827',4904250,'2942','326',316715.19,317442.01,0.00,0.00,726.82,581456.00,0.00,0.00,0.00),('1','147','768','257828',4904251,'2139','326',1172815.51,1173687.44,0.00,0.00,871.93,697544.00,0.00,0.00,0.00),('1','147','768','257828',4904252,'2942','326',317442.01,317931.63,0.00,0.00,489.62,391696.00,0.00,0.00,0.00),('1','147','768','257829',4904253,'2139','326',1173687.44,1174127.83,0.00,0.00,440.39,352312.00,0.00,0.00,0.00),('1','147','768','257829',4904254,'2942','326',317931.63,318070.02,0.00,0.00,138.39,110712.00,0.00,0.00,0.00),('1','147','768','257830',4904255,'2139','326',1174127.83,1175162.09,0.00,0.00,1034.26,786037.60,0.00,0.00,0.00),('1','147','768','257830',4904256,'2942','326',318070.02,318805.37,0.00,0.00,735.35,558866.00,0.00,0.00,0.00),('1','147','768','257831',4904257,'2139','326',1175162.09,1176735.81,0.00,0.00,1573.72,1196027.20,0.00,0.00,0.00),('1','147','768','257831',4904258,'2942','326',318805.37,319465.49,0.00,0.00,660.12,501691.20,0.00,0.00,0.00),('1','147','768','257832',4904259,'2139','326',1176735.81,1177640.78,0.00,0.00,904.97,687777.20,0.00,0.00,0.00),('1','147','768','257832',4904260,'2942','326',319465.49,320091.98,0.00,0.00,626.49,476132.40,0.00,0.00,0.00),('1','147','768','257833',4904261,'2139','326',1177640.78,1177640.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257833',4904262,'2942','326',320091.98,320091.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257834',4904263,'2139','326',1177640.78,1177640.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257834',4904264,'2942','326',320091.98,320091.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257836',4904265,'2139','326',1177640.78,1178253.17,0.00,0.00,612.39,465416.40,0.00,0.00,0.00),('1','147','768','257836',4904266,'2942','326',320091.98,321063.64,0.00,0.00,971.66,738461.60,0.00,0.00,0.00),('1','147','768','257837',4904267,'2139','326',1178253.17,1179912.52,0.00,0.00,1659.35,1261106.00,0.00,0.00,0.00),('1','147','768','257837',4904268,'2942','326',321063.64,321895.32,0.00,0.00,831.68,632076.80,0.00,0.00,0.00),('1','147','768','257838',4904269,'2139','326',1179912.52,1180479.41,0.00,0.00,566.89,430836.40,0.00,0.00,0.00),('1','147','768','257838',4904270,'2942','326',321895.32,322347.05,0.00,0.00,451.73,343314.80,0.00,0.00,0.00),('1','147','768','257839',4904271,'2139','326',1180479.41,1180515.67,0.00,0.00,36.26,27557.60,0.00,0.00,0.00),('1','147','768','257839',4904272,'2942','326',322347.05,322347.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257840',4904273,'2139','326',1180515.67,1181314.04,0.00,0.00,798.37,606761.20,0.00,0.00,0.00),('1','147','768','257840',4904274,'2942','326',322347.05,322577.81,0.00,0.00,230.76,175377.60,0.00,0.00,0.00),('1','147','768','257841',4904275,'2139','326',1181314.04,1182400.37,0.00,0.00,1086.33,825610.80,0.00,0.00,0.00),('1','147','768','257841',4904276,'2942','326',322577.81,323199.11,0.00,0.00,621.30,472188.00,0.00,0.00,0.00),('1','147','768','257842',4904277,'2139','326',1182400.37,1183450.21,0.00,0.00,1049.84,797878.40,0.00,0.00,0.00),('1','147','768','257842',4904278,'2942','326',323199.11,323915.29,0.00,0.00,716.18,544296.80,0.00,0.00,0.00),('1','147','768','257843',4904279,'2139','326',1183450.21,1183887.73,0.00,0.00,437.52,332515.20,0.00,0.00,0.00),('1','147','768','257843',4904280,'2942','326',323915.29,324157.93,0.00,0.00,242.64,184406.40,0.00,0.00,0.00),('1','147','768','257844',4904281,'2139','326',1183887.73,1184165.98,0.00,0.00,278.25,211470.00,0.00,0.00,0.00),('1','147','768','257844',4904282,'2942','326',324157.93,324450.95,0.00,0.00,293.02,222695.20,0.00,0.00,0.00),('1','147','768','257845',4904283,'2139','326',1184165.98,1185145.72,0.00,0.00,979.74,744602.40,0.00,0.00,0.00),('1','147','768','257845',4904284,'2942','326',324450.95,325003.60,0.00,0.00,552.65,420014.00,0.00,0.00,0.00),('1','147','768','257846',4904285,'2139','326',1185145.72,1185535.27,0.00,0.00,389.55,296058.00,0.00,0.00,0.00),('1','147','768','257846',4904286,'2942','326',325003.60,325552.14,0.00,0.00,548.54,416890.40,0.00,0.00,0.00),('1','147','768','257847',4904287,'2139','326',1185535.27,1187088.48,0.00,0.00,1553.21,1180439.60,0.00,0.00,0.00),('1','147','768','257847',4904288,'2942','326',325552.14,326225.08,0.00,0.00,672.94,511434.40,0.00,0.00,0.00),('1','147','768','257848',4904289,'2139','326',1187088.48,1188582.22,0.00,0.00,1493.74,1135242.40,0.00,0.00,0.00),('1','147','768','257848',4904290,'2942','326',326225.08,326748.97,0.00,0.00,523.89,398156.40,0.00,0.00,0.00),('1','147','768','257849',4904291,'2139','326',1188582.22,1190103.79,0.00,0.00,1521.57,1156393.20,0.00,0.00,0.00),('1','147','768','257849',4904292,'2942','326',326748.97,327083.20,0.00,0.00,334.23,254014.80,0.00,0.00,0.00),('1','147','768','257850',4904293,'2139','326',1190103.79,1191050.59,0.00,0.00,946.80,719568.00,0.00,0.00,0.00),('1','147','768','257850',4904294,'2942','326',327083.20,327564.37,0.00,0.00,481.17,365689.20,0.00,0.00,0.00),('1','147','768','257851',4904295,'2139','326',1191050.59,1192132.55,0.00,0.00,1081.96,822289.60,0.00,0.00,0.00),('1','147','768','257851',4904296,'2942','326',327564.37,328013.84,0.00,0.00,449.47,341597.20,0.00,0.00,0.00),('1','147','768','257852',4904297,'2139','326',1192132.55,1192926.91,0.00,0.00,794.36,603713.60,0.00,0.00,0.00),('1','147','768','257852',4904298,'2942','326',328013.84,328909.27,0.00,0.00,895.43,680526.80,0.00,0.00,0.00),('1','147','768','257853',4904299,'2139','326',1192926.91,1194214.41,0.00,0.00,1287.50,978500.00,0.00,0.00,0.00),('1','147','768','257853',4904300,'2942','326',328909.27,329685.40,0.00,0.00,776.13,589858.80,0.00,0.00,0.00),('1','147','768','257854',4904301,'2139','326',1194214.41,1194293.57,0.00,0.00,79.16,60161.60,0.00,0.00,0.00),('1','147','768','257854',4904302,'2942','326',329685.40,329717.15,0.00,0.00,31.75,24130.00,0.00,0.00,0.00),('1','147','768','257855',4904303,'2139','326',1194293.57,1195674.66,0.00,0.00,1381.09,1049628.40,0.00,0.00,0.00),('1','147','768','257855',4904304,'2942','326',329717.15,330466.80,0.00,0.00,749.65,569734.00,0.00,0.00,0.00),('1','147','768','257856',4904305,'2139','326',1195674.66,1196982.06,0.00,0.00,1307.40,993624.00,0.00,0.00,0.00),('1','147','768','257856',4904306,'2942','326',330466.80,331198.41,0.00,0.00,731.61,556023.60,0.00,0.00,0.00),('1','147','768','257857',4904307,'2139','326',1196982.06,1197682.28,0.00,0.00,700.22,532167.20,0.00,0.00,0.00),('1','147','768','257857',4904308,'2942','326',331198.41,331400.99,0.00,0.00,202.58,153960.80,0.00,0.00,0.00),('1','147','768','257858',4904309,'2139','326',1197682.28,1198000.36,0.00,0.00,318.08,241740.80,0.00,0.00,0.00),('1','147','768','257858',4904310,'2942','326',331400.99,331662.00,0.00,0.00,261.01,198367.60,0.00,0.00,0.00),('1','147','768','257859',4904311,'2139','326',1198000.36,1199227.84,0.00,0.00,1227.48,932884.80,0.00,0.00,0.00),('1','147','768','257859',4904312,'2942','326',331662.00,331976.11,0.00,0.00,314.11,238723.60,0.00,0.00,0.00),('1','147','768','257860',4904313,'2139','326',1199227.84,1200535.00,0.00,0.00,1307.16,993441.60,0.00,0.00,0.00),('1','147','768','257860',4904314,'2942','326',331976.11,332446.76,0.00,0.00,470.65,357694.00,0.00,0.00,0.00),('1','147','768','257861',4904315,'2139','326',1200535.00,1201326.66,0.00,0.00,791.66,601661.60,0.00,0.00,0.00),('1','147','768','257861',4904316,'2942','326',332446.76,332676.71,0.00,0.00,229.95,174762.00,0.00,0.00,0.00),('1','147','768','257862',4904317,'2139','326',1201326.66,1201787.37,0.00,0.00,460.71,350139.60,0.00,0.00,0.00),('1','147','768','257862',4904318,'2942','326',332676.71,332742.95,0.00,0.00,66.24,50342.40,0.00,0.00,0.00),('1','147','768','257863',4904319,'2139','326',1201787.37,1203270.77,0.00,0.00,1483.40,1127384.00,0.00,0.00,0.00),('1','147','768','257863',4904320,'2942','326',332742.95,333124.81,0.00,0.00,381.86,290213.60,0.00,0.00,0.00),('1','147','768','257864',4904321,'2139','326',1203270.77,1205100.64,0.00,0.00,1829.87,1390701.20,0.00,0.00,0.00),('1','147','768','257864',4904322,'2942','326',333124.81,333421.43,0.00,0.00,296.62,225431.20,0.00,0.00,0.00),('1','147','768','257865',4904323,'2139','326',1205100.64,1205565.39,0.00,0.00,464.75,353210.00,0.00,0.00,0.00),('1','147','768','257865',4904324,'2942','326',333421.43,333524.39,0.00,0.00,102.96,78249.60,0.00,0.00,0.00),('1','147','768','257866',4904325,'2139','326',1205565.39,1206724.82,0.00,0.00,1159.43,881166.80,0.00,0.00,0.00),('1','147','768','257866',4904326,'2942','326',333524.39,333672.69,0.00,0.00,148.30,112708.00,0.00,0.00,0.00),('1','147','768','257867',4904327,'2139','326',1206724.82,1207945.84,0.00,0.00,1221.02,927975.20,0.00,0.00,0.00),('1','147','768','257867',4904328,'2942','326',333672.69,333779.85,0.00,0.00,107.16,81441.60,0.00,0.00,0.00),('1','147','768','257868',4904329,'2139','326',1207945.84,1209543.93,0.00,0.00,1598.09,1214548.40,0.00,0.00,0.00),('1','147','768','257868',4904330,'2942','326',333779.85,333910.10,0.00,0.00,130.25,98990.00,0.00,0.00,0.00),('1','147','768','257869',4904331,'2139','326',1209543.93,1210022.32,0.00,0.00,478.39,363576.40,0.00,0.00,0.00),('1','147','768','257869',4904332,'2942','326',333910.10,333949.32,0.00,0.00,39.22,29807.20,0.00,0.00,0.00),('1','147','768','257870',4904333,'2139','326',1210022.32,1210822.42,0.00,0.00,800.10,608076.00,0.00,0.00,0.00),('1','147','768','257870',4904334,'2942','326',333949.32,334049.92,0.00,0.00,100.60,76456.00,0.00,0.00,0.00),('1','147','768','257871',4904335,'2139','326',1210822.42,1212695.17,0.00,0.00,1872.75,1423290.00,0.00,0.00,0.00),('1','147','768','257871',4904336,'2942','326',334049.92,334255.79,0.00,0.00,205.87,156461.20,0.00,0.00,0.00),('1','147','768','257872',4904337,'2139','326',1212695.17,1214428.05,0.00,0.00,1732.88,1316988.80,0.00,0.00,0.00),('1','147','768','257872',4904338,'2942','326',334255.79,334456.57,0.00,0.00,200.78,152592.80,0.00,0.00,0.00),('1','147','768','257873',4904339,'2139','326',1214428.05,1214624.13,0.00,0.00,196.08,149020.80,0.00,0.00,0.00),('1','147','768','257873',4904340,'2942','326',334456.57,334495.91,0.00,0.00,39.34,29898.40,0.00,0.00,0.00),('1','147','768','257874',4904341,'2139','326',1214624.13,1216562.15,0.00,0.00,1938.02,1472895.20,0.00,0.00,0.00),('1','147','768','257874',4904342,'2942','326',334495.91,334839.09,0.00,0.00,343.18,260816.80,0.00,0.00,0.00),('1','147','768','257875',4904343,'2139','326',1216562.15,1218262.20,0.00,0.00,1700.05,1292038.00,0.00,0.00,0.00),('1','147','768','257875',4904344,'2942','326',334839.09,335294.12,0.00,0.00,455.03,345822.80,0.00,0.00,0.00),('1','147','768','257876',4904345,'2139','326',1218262.20,1218826.32,0.00,0.00,564.12,428731.20,0.00,0.00,0.00),('1','147','768','257876',4904346,'2942','326',335294.12,335371.11,0.00,0.00,76.99,58512.40,0.00,0.00,0.00),('1','147','768','257877',4904347,'2139','326',1218826.32,1219595.89,0.00,0.00,769.57,584873.20,0.00,0.00,0.00),('1','147','768','257877',4904348,'2942','326',335371.11,335532.89,0.00,0.00,161.78,122952.80,0.00,0.00,0.00),('1','147','768','257878',4904349,'2139','326',1219595.89,1221286.41,0.00,0.00,1690.52,1284795.20,0.00,0.00,0.00),('1','147','768','257878',4904350,'2942','326',335532.89,335852.26,0.00,0.00,319.37,242721.20,0.00,0.00,0.00),('1','147','768','257879',4904351,'2139','326',1221286.41,1222552.70,0.00,0.00,1266.29,962380.40,0.00,0.00,0.00),('1','147','768','257879',4904352,'2942','326',335852.26,336188.20,0.00,0.00,335.94,255314.40,0.00,0.00,0.00),('1','147','768','257880',4904353,'2139','326',1222552.70,1223086.15,0.00,0.00,533.45,405422.00,0.00,0.00,0.00),('1','147','768','257880',4904354,'2942','326',336188.20,336596.87,0.00,0.00,408.67,310589.20,0.00,0.00,0.00),('1','147','768','257881',4904355,'2139','326',1223086.15,1223154.63,0.00,0.00,68.48,52044.80,0.00,0.00,0.00),('1','147','768','257881',4904356,'2942','326',336596.87,337153.48,0.00,0.00,556.61,423023.60,0.00,0.00,0.00),('1','147','768','257882',4904357,'2139','326',1223154.63,1224205.18,0.00,0.00,1050.55,780119.44,0.00,0.00,0.00),('1','147','768','257882',4904358,'2942','326',337153.48,337984.63,0.00,0.00,831.15,615499.68,0.00,0.00,0.00),('1','147','768','257883',4904359,'2139','326',1224205.18,1225350.13,0.00,0.00,1144.95,842683.20,0.00,0.00,0.00),('1','147','768','257883',4904360,'2942','326',337984.63,339130.89,0.00,0.00,1146.26,843647.36,0.00,0.00,0.00),('1','147','768','257884',4904361,'2139','326',1225350.13,1225709.97,0.00,0.00,359.84,264842.24,0.00,0.00,0.00),('1','147','768','257884',4904362,'2942','326',339130.89,339221.11,0.00,0.00,90.22,66401.92,0.00,0.00,0.00),('1','147','768','257885',4904363,'2139','326',1225709.97,1226448.10,0.00,0.00,738.13,543263.68,0.00,0.00,0.00),('1','147','768','257885',4904364,'2942','326',339221.11,340047.87,0.00,0.00,826.76,608495.36,0.00,0.00,0.00),('1','147','768','257886',4904365,'2139','326',1226448.10,1227212.18,0.00,0.00,764.08,562362.88,0.00,0.00,0.00),('1','147','768','257886',4904366,'2942','326',340047.87,340833.72,0.00,0.00,785.85,578385.60,0.00,0.00,0.00),('1','147','768','257887',4904367,'2139','326',1227212.18,1228249.73,0.00,0.00,1037.55,763636.80,0.00,0.00,0.00),('1','147','768','257887',4904368,'2942','326',340833.72,341599.31,0.00,0.00,765.59,563474.24,0.00,0.00,0.00),('1','147','768','257888',4904369,'2139','326',1228249.73,1228256.90,0.00,0.00,7.17,5277.12,0.00,0.00,0.00),('1','147','768','257888',4904370,'2942','326',341599.31,341629.75,0.00,0.00,30.44,22403.84,0.00,0.00,0.00),('1','147','768','257889',4904371,'2139','326',1228256.90,1229187.00,0.00,0.00,930.10,684553.60,0.00,0.00,0.00),('1','147','768','257889',4904372,'2942','326',341629.75,342334.98,0.00,0.00,705.23,519049.28,0.00,0.00,0.00),('1','147','768','257890',4904373,'2139','326',1229187.00,1230119.57,0.00,0.00,932.57,686371.52,0.00,0.00,0.00),('1','147','768','257890',4904374,'2942','326',342334.98,343074.27,0.00,0.00,739.29,544117.44,0.00,0.00,0.00),('1','147','768','257891',4904375,'2139','326',1230119.57,1231000.16,0.00,0.00,880.59,648114.24,0.00,0.00,0.00),('1','147','768','257891',4904376,'2942','326',343074.27,343915.69,0.00,0.00,841.42,619285.12,0.00,0.00,0.00),('1','147','768','257892',4904377,'2139','326',1231000.16,1231050.11,0.00,0.00,49.95,36763.20,0.00,0.00,0.00),('1','147','768','257892',4904378,'2942','326',343915.69,344083.52,0.00,0.00,167.83,123522.88,0.00,0.00,0.00),('1','147','768','257893',4904379,'2139','326',1231050.11,1232091.24,0.00,0.00,1041.13,766271.68,0.00,0.00,0.00),('1','147','768','257893',4904380,'2942','326',344083.52,345167.02,0.00,0.00,1083.50,797456.00,0.00,0.00,0.00),('1','147','768','257894',4904381,'2139','326',1232091.24,1233816.91,0.00,0.00,1725.67,1270093.12,0.00,0.00,0.00),('1','147','768','257894',4904382,'2942','326',345167.02,346001.18,0.00,0.00,834.16,613941.76,0.00,0.00,0.00),('1','147','768','257895',4904383,'2139','326',1233816.91,1233959.19,0.00,0.00,142.28,104718.08,0.00,0.00,0.00),('1','147','768','257895',4904384,'2942','326',346001.18,346048.97,0.00,0.00,47.79,35173.44,0.00,0.00,0.00),('1','147','768','257896',4904385,'2139','326',1233959.19,1234839.28,0.00,0.00,880.09,647746.24,0.00,0.00,0.00),('1','147','768','257896',4904386,'2942','326',346048.97,346756.35,0.00,0.00,707.38,520631.68,0.00,0.00,0.00),('1','147','768','257897',4904387,'2139','326',1234839.28,1235825.24,0.00,0.00,985.96,725666.56,0.00,0.00,0.00),('1','147','768','257897',4904388,'2942','326',346756.35,347989.38,0.00,0.00,1233.03,907510.08,0.00,0.00,0.00),('1','147','768','257898',4904389,'2139','326',1235825.24,1237155.39,0.00,0.00,1330.15,978990.40,0.00,0.00,0.00),('1','147','768','257898',4904390,'2942','326',347989.38,348164.02,0.00,0.00,174.64,128535.04,0.00,0.00,0.00),('1','147','768','257899',4904391,'2139','326',1237155.39,1237292.41,0.00,0.00,137.02,100846.72,0.00,0.00,0.00),('1','147','768','257899',4904392,'2942','326',348164.02,348684.76,0.00,0.00,520.74,383264.64,0.00,0.00,0.00),('1','147','768','257900',4904393,'2139','326',1237292.41,1238610.70,0.00,0.00,1318.29,970261.44,0.00,0.00,0.00),('1','147','768','257900',4904394,'2942','326',348684.76,349614.34,0.00,0.00,929.58,684170.88,0.00,0.00,0.00),('1','147','768','257901',4904395,'2139','326',1238610.70,1240238.16,0.00,0.00,1627.46,1197810.56,0.00,0.00,0.00),('1','147','768','257901',4904396,'2942','326',349614.34,350280.57,0.00,0.00,666.23,490345.28,0.00,0.00,0.00),('1','147','768','257902',4904397,'2139','326',1240238.16,1242664.78,0.00,0.00,2426.62,1785992.32,0.00,0.00,0.00),('1','147','768','257902',4904398,'2942','326',350280.57,352031.30,0.00,0.00,1750.73,1288537.28,0.00,0.00,0.00),('1','147','768','257903',4904399,'2139','326',1242664.78,1242908.87,0.00,0.00,244.09,179650.24,0.00,0.00,0.00),('1','147','768','257903',4904400,'2942','326',352031.30,352862.11,0.00,0.00,830.81,611476.16,0.00,0.00,0.00),('1','147','768','257904',4904401,'2139','326',1242908.87,1243512.27,0.00,0.00,603.40,444102.40,0.00,0.00,0.00),('1','147','768','257904',4904402,'2942','326',352862.11,353195.54,0.00,0.00,333.43,245404.48,0.00,0.00,0.00),('1','147','768','257905',4904403,'2139','326',1243512.27,1244329.92,0.00,0.00,817.65,601790.40,0.00,0.00,0.00),('1','147','768','257905',4904404,'2942','326',353195.54,354181.12,0.00,0.00,985.58,725386.88,0.00,0.00,0.00),('1','147','768','257906',4904405,'2139','326',1244329.92,1245155.84,0.00,0.00,825.92,607877.12,0.00,0.00,0.00),('1','147','768','257906',4904406,'2942','326',354181.12,354968.46,0.00,0.00,787.34,579482.24,0.00,0.00,0.00),('1','147','768','257907',4904407,'2139','326',1245155.84,1245375.35,0.00,0.00,219.51,161559.36,0.00,0.00,0.00),('1','147','768','257907',4904408,'2942','326',354968.46,355528.74,0.00,0.00,560.28,412366.08,0.00,0.00,0.00),('1','147','768','257908',4904409,'2139','326',1245375.35,1245832.62,0.00,0.00,457.27,336550.72,0.00,0.00,0.00),('1','147','768','257908',4904410,'2942','326',355528.74,355615.87,0.00,0.00,87.13,64127.68,0.00,0.00,0.00),('1','147','768','257909',4904411,'2139','326',1245832.62,1246665.96,0.00,0.00,833.34,613338.24,0.00,0.00,0.00),('1','147','768','257909',4904412,'2942','326',355615.87,356271.94,0.00,0.00,656.07,482867.52,0.00,0.00,0.00),('1','147','768','257910',4904413,'2139','326',1246665.96,1247760.14,0.00,0.00,1094.18,805316.48,0.00,0.00,0.00),('1','147','768','257910',4904414,'2942','326',356271.94,356731.42,0.00,0.00,459.48,338177.28,0.00,0.00,0.00),('1','147','768','257911',4904415,'2139','326',1247760.14,1248853.54,0.00,0.00,1093.40,804742.40,0.00,0.00,0.00),('1','147','768','257911',4904416,'2942','326',356731.42,357115.31,0.00,0.00,383.89,282543.04,0.00,0.00,0.00),('1','147','768','257912',4904417,'2139','326',1248853.54,1249028.80,0.00,0.00,175.26,128991.36,0.00,0.00,0.00),('1','147','768','257912',4904418,'2942','326',357115.31,357608.41,0.00,0.00,493.10,362921.60,0.00,0.00,0.00),('1','147','768','257913',4904419,'2139','326',1249028.80,1250186.76,0.00,0.00,1157.96,852258.56,0.00,0.00,0.00),('1','147','768','257913',4904420,'2942','326',357608.41,357995.08,0.00,0.00,386.67,284589.12,0.00,0.00,0.00),('1','147','768','257914',4904421,'2139','326',1250186.76,1251265.79,0.00,0.00,1079.03,794166.08,0.00,0.00,0.00),('1','147','768','257914',4904422,'2942','326',357995.08,358652.97,0.00,0.00,657.89,484207.04,0.00,0.00,0.00),('1','147','768','257915',4904423,'2139','326',1251265.79,1252112.92,0.00,0.00,847.13,623487.68,0.00,0.00,0.00),('1','147','768','257915',4904424,'2942','326',358652.97,358986.67,0.00,0.00,333.70,245603.20,0.00,0.00,0.00),('1','147','768','257916',4904425,'2139','326',1252112.92,1252262.26,0.00,0.00,149.34,109914.24,0.00,0.00,0.00),('1','147','768','257916',4904426,'2942','326',358986.67,359332.72,0.00,0.00,346.05,254692.80,0.00,0.00,0.00),('1','147','768','257917',4904427,'2139','326',1252262.26,1253204.03,0.00,0.00,941.77,693142.72,0.00,0.00,0.00),('1','147','768','257917',4904428,'2942','326',359332.72,360051.98,0.00,0.00,719.26,529375.36,0.00,0.00,0.00),('1','147','768','257918',4904429,'2139','326',1253204.03,1254152.00,0.00,0.00,947.97,697705.92,0.00,0.00,0.00),('1','147','768','257918',4904430,'2942','326',360051.98,360868.49,0.00,0.00,816.51,600951.36,0.00,0.00,0.00),('1','147','768','257919',4904431,'2139','326',1254152.00,1254734.17,0.00,0.00,582.17,428477.12,0.00,0.00,0.00),('1','147','768','257919',4904432,'2942','326',360868.49,361675.33,0.00,0.00,806.84,593834.24,0.00,0.00,0.00),('1','147','768','257920',4904433,'2139','326',1254734.17,1255756.54,0.00,0.00,1022.37,752464.32,0.00,0.00,0.00),('1','147','768','257920',4904434,'2942','326',361675.33,362743.94,0.00,0.00,1068.61,786496.96,0.00,0.00,0.00),('1','147','768','257921',4904435,'2139','326',1255756.54,1257092.66,0.00,0.00,1336.12,983384.32,0.00,0.00,0.00),('1','147','768','257921',4904436,'2942','326',362743.94,363651.30,0.00,0.00,907.36,667816.96,0.00,0.00,0.00),('1','147','768','257922',4904437,'2139','326',1257092.66,1257949.91,0.00,0.00,857.25,630936.00,0.00,0.00,0.00),('1','147','768','257922',4904438,'2942','326',363651.30,364043.89,0.00,0.00,392.59,288946.24,0.00,0.00,0.00),('1','147','768','257923',4904439,'2139','326',1257949.91,1258163.14,0.00,0.00,213.23,156937.28,0.00,0.00,0.00),('1','147','768','257923',4904440,'2942','326',364043.89,364354.85,0.00,0.00,310.96,228866.56,0.00,0.00,0.00),('1','147','768','257924',4904441,'2139','326',1258163.14,1259505.98,0.00,0.00,1342.84,988330.24,0.00,0.00,0.00),('1','147','768','257924',4904442,'2942','326',364354.85,364818.20,0.00,0.00,463.35,341025.60,0.00,0.00,0.00),('1','147','768','257925',4904443,'2139','326',1259505.98,1260743.60,0.00,0.00,1237.62,910888.32,0.00,0.00,0.00),('1','147','768','257925',4904444,'2942','326',364818.20,365557.32,0.00,0.00,739.12,543992.32,0.00,0.00,0.00),('1','147','768','257926',4904445,'2139','326',1260743.60,1261453.01,0.00,0.00,709.41,522125.76,0.00,0.00,0.00),('1','147','768','257926',4904446,'2942','326',365557.32,365658.98,0.00,0.00,101.66,74821.76,0.00,0.00,0.00),('1','147','768','257927',4904447,'2139','326',1261453.01,1261872.65,0.00,0.00,419.64,308855.04,0.00,0.00,0.00),('1','147','768','257927',4904448,'2942','326',365658.98,366257.19,0.00,0.00,598.21,440282.56,0.00,0.00,0.00),('1','147','768','257928',4904449,'2139','326',1261872.65,1263202.41,0.00,0.00,1329.76,978703.36,0.00,0.00,0.00),('1','147','768','257928',4904450,'2942','326',366257.19,366841.77,0.00,0.00,584.58,430250.88,0.00,0.00,0.00),('1','147','768','257929',4904451,'2139','326',1263202.41,1264307.32,0.00,0.00,1104.91,813213.76,0.00,0.00,0.00),('1','147','768','257929',4904452,'2942','326',366841.77,367959.65,0.00,0.00,1117.88,822759.68,0.00,0.00,0.00),('1','147','768','257930',4904453,'2139','326',1264307.32,1264307.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257930',4904454,'2942','326',367959.65,367959.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257931',4904455,'2139','326',1264307.32,1265857.76,0.00,0.00,1550.44,1141123.84,0.00,0.00,0.00),('1','147','768','257931',4904456,'2942','326',367959.65,369104.34,0.00,0.00,1144.69,842491.84,0.00,0.00,0.00),('1','147','768','257932',4904457,'2139','326',1265857.76,1267164.05,0.00,0.00,1306.29,961429.44,0.00,0.00,0.00),('1','147','768','257932',4904458,'2942','326',369104.34,369762.63,0.00,0.00,658.29,484501.44,0.00,0.00,0.00),('1','147','768','257933',4904459,'2139','326',1267164.05,1267294.52,0.00,0.00,130.47,96025.92,0.00,0.00,0.00),('1','147','768','257933',4904460,'2942','326',369762.63,370123.41,0.00,0.00,360.78,265534.08,0.00,0.00,0.00),('1','147','768','257934',4904461,'2139','326',1267294.52,1268344.56,0.00,0.00,1050.04,772829.44,0.00,0.00,0.00),('1','147','768','257934',4904462,'2942','326',370123.41,370508.15,0.00,0.00,384.74,283168.64,0.00,0.00,0.00),('1','147','768','257935',4904463,'2139','326',1268344.56,1269462.57,0.00,0.00,1118.01,822855.36,0.00,0.00,0.00),('1','147','768','257935',4904464,'2942','326',370508.15,371232.43,0.00,0.00,724.28,533070.08,0.00,0.00,0.00),('1','147','768','257936',4904465,'2139','326',1269462.57,1270294.27,0.00,0.00,831.70,612131.20,0.00,0.00,0.00),('1','147','768','257936',4904466,'2942','326',371232.43,371795.48,0.00,0.00,563.05,414404.80,0.00,0.00,0.00),('1','147','768','257937',4904467,'2139','326',1270294.27,1270294.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257937',4904468,'2942','326',371795.48,371795.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257938',4904469,'2139','326',1270294.27,1271459.23,0.00,0.00,1164.96,857410.56,0.00,0.00,0.00),('1','147','768','257938',4904470,'2942','326',371795.48,372448.39,0.00,0.00,652.91,480541.76,0.00,0.00,0.00),('1','147','768','257939',4904471,'2139','326',1271459.23,1272856.10,0.00,0.00,1396.87,1028096.32,0.00,0.00,0.00),('1','147','768','257939',4904472,'2942','326',372448.39,373431.56,0.00,0.00,983.17,723613.12,0.00,0.00,0.00),('1','147','768','257940',4904473,'2139','326',1272856.10,1273601.41,0.00,0.00,745.31,548548.16,0.00,0.00,0.00),('1','147','768','257940',4904474,'2942','326',373431.56,373767.37,0.00,0.00,335.81,247156.16,0.00,0.00,0.00),('1','147','768','257941',4904475,'2139','326',1273601.41,1273805.19,0.00,0.00,203.78,149982.08,0.00,0.00,0.00),('1','147','768','257941',4904476,'2942','326',373767.37,374365.44,0.00,0.00,598.07,440179.52,0.00,0.00,0.00),('1','147','768','257942',4904477,'2139','326',1273805.19,1274857.84,0.00,0.00,1052.65,774750.40,0.00,0.00,0.00),('1','147','768','257942',4904478,'2942','326',374365.44,375291.71,0.00,0.00,926.27,681734.72,0.00,0.00,0.00),('1','147','768','257943',4904479,'2139','326',1274857.84,1275871.80,0.00,0.00,1013.96,746274.56,0.00,0.00,0.00),('1','147','768','257943',4904480,'2942','326',375291.71,375972.46,0.00,0.00,680.75,501032.00,0.00,0.00,0.00),('1','147','768','257944',4904481,'2139','326',1275871.80,1276479.28,0.00,0.00,607.48,447105.28,0.00,0.00,0.00),('1','147','768','257944',4904482,'2942','326',375972.46,376112.44,0.00,0.00,139.98,103025.28,0.00,0.00,0.00),('1','147','768','257945',4904483,'2139','326',1276479.28,1276761.95,0.00,0.00,282.67,208045.12,0.00,0.00,0.00),('1','147','768','257945',4904484,'2942','326',376112.44,376652.47,0.00,0.00,540.03,397462.08,0.00,0.00,0.00),('1','147','768','257946',4904485,'2139','326',1276761.95,1277783.67,0.00,0.00,1021.72,751985.92,0.00,0.00,0.00),('1','147','768','257946',4904486,'2942','326',376652.47,377356.06,0.00,0.00,703.59,517842.24,0.00,0.00,0.00),('1','147','768','257947',4904487,'2139','326',1277783.67,1278714.78,0.00,0.00,931.11,685296.96,0.00,0.00,0.00),('1','147','768','257947',4904488,'2942','326',377356.06,378359.13,0.00,0.00,1003.07,738259.52,0.00,0.00,0.00),('1','147','768','257948',4904489,'2139','326',1278714.78,1279271.70,0.00,0.00,556.92,409893.12,0.00,0.00,0.00),('1','147','768','257948',4904490,'2942','326',378359.13,378633.95,0.00,0.00,274.82,202267.52,0.00,0.00,0.00),('1','147','768','257949',4904491,'2139','326',1279271.70,1279947.85,0.00,0.00,676.15,497646.40,0.00,0.00,0.00),('1','147','768','257949',4904492,'2942','326',378633.95,379215.85,0.00,0.00,581.90,428278.40,0.00,0.00,0.00),('1','147','768','257950',4904493,'2139','326',1279947.85,1281213.57,0.00,0.00,1265.72,931569.92,0.00,0.00,0.00),('1','147','768','257950',4904494,'2942','326',379215.85,379897.79,0.00,0.00,681.94,501907.84,0.00,0.00,0.00),('1','147','768','257951',4904495,'2139','326',1281213.57,1282219.67,0.00,0.00,1006.10,740489.60,0.00,0.00,0.00),('1','147','768','257951',4904496,'2942','326',379897.79,380551.58,0.00,0.00,653.79,481189.44,0.00,0.00,0.00),('1','147','768','257952',4904497,'2139','326',1282219.67,1282591.46,0.00,0.00,371.79,273637.44,0.00,0.00,0.00),('1','147','768','257952',4904498,'2942','326',380551.58,380664.61,0.00,0.00,113.03,83190.08,0.00,0.00,0.00),('1','147','768','257953',4904499,'2139','326',1282591.46,1283138.76,0.00,0.00,547.30,402812.80,0.00,0.00,0.00),('1','147','768','257953',4904500,'2942','326',380664.61,381186.51,0.00,0.00,521.90,384118.40,0.00,0.00,0.00),('1','147','768','257954',4904501,'2139','326',1283138.76,1284077.50,0.00,0.00,938.74,690912.64,0.00,0.00,0.00),('1','147','768','257954',4904502,'2942','326',381186.51,381788.80,0.00,0.00,602.29,443285.44,0.00,0.00,0.00),('1','147','768','257955',4904503,'2139','326',1284077.50,1285078.62,0.00,0.00,1001.12,736824.32,0.00,0.00,0.00),('1','147','768','257955',4904504,'2942','326',381788.80,382317.24,0.00,0.00,528.44,388931.84,0.00,0.00,0.00),('1','147','768','257956',4904505,'2139','326',1285078.62,1285880.68,0.00,0.00,802.06,590316.16,0.00,0.00,0.00),('1','147','768','257956',4904506,'2942','326',382317.24,382549.75,0.00,0.00,232.51,171127.36,0.00,0.00,0.00),('1','147','768','257957',4904507,'2139','326',1285880.68,1285880.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257957',4904508,'2942','326',382549.75,382549.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','257958',4904509,'2139','326',1285880.68,1287142.70,0.00,0.00,1262.02,928846.72,0.00,0.00,0.00),('1','147','768','257958',4904510,'2942','326',382549.75,383022.60,0.00,0.00,472.85,348017.60,0.00,0.00,0.00),('1','147','768','257959',4904511,'2139','326',1287142.70,1288934.44,0.00,0.00,1791.74,1318720.64,0.00,0.00,0.00),('1','147','768','257959',4904512,'2942','326',383022.60,383689.00,0.00,0.00,666.40,490470.40,0.00,0.00,0.00),('1','147','768','257960',4904513,'2139','326',1288934.44,1289822.16,0.00,0.00,887.72,653361.92,0.00,0.00,0.00),('1','147','768','257960',4904514,'2942','326',383689.00,383937.71,0.00,0.00,248.71,183050.56,0.00,0.00,0.00),('1','147','768','257961',4904515,'2139','326',1289822.16,1290417.24,0.00,0.00,595.08,437978.88,0.00,0.00,0.00),('1','147','768','257961',4904516,'2942','326',383937.71,384713.44,0.00,0.00,775.73,570937.28,0.00,0.00,0.00),('1','147','768','257962',4904517,'2139','326',1290417.24,1291875.85,0.00,0.00,1458.61,1073536.96,0.00,0.00,0.00),('1','147','768','257962',4904518,'2942','326',384713.44,385065.19,0.00,0.00,351.75,258888.00,0.00,0.00,0.00),('1','147','768','257963',4904519,'2139','326',1291875.85,1293328.45,0.00,0.00,1452.60,1069113.60,0.00,0.00,0.00),('1','147','768','257963',4904520,'2942','326',385065.19,385400.51,0.00,0.00,335.32,246795.52,0.00,0.00,0.00),('1','147','768','257964',4904521,'2139','326',1293328.45,1294680.96,0.00,0.00,1352.51,995447.36,0.00,0.00,0.00),('1','147','768','257964',4904522,'2942','326',385400.51,385615.59,0.00,0.00,215.08,158298.88,0.00,0.00,0.00),('1','147','768','257965',4904523,'2139','326',1294680.96,1295755.46,0.00,0.00,1074.50,790832.00,0.00,0.00,0.00),('1','147','768','257965',4904524,'2942','326',385615.59,386766.73,0.00,0.00,1151.14,847239.04,0.00,0.00,0.00),('1','147','768','257966',4904525,'2139','326',1295755.46,1296833.11,0.00,0.00,1077.65,793150.40,0.00,0.00,0.00),('1','147','768','257966',4904526,'2942','326',386766.73,387098.96,0.00,0.00,332.23,244521.28,0.00,0.00,0.00),('1','147','768','257967',4904527,'2139','326',1296833.11,1297322.21,0.00,0.00,489.10,359977.60,0.00,0.00,0.00),('1','147','768','257967',4904528,'2942','326',387098.96,387642.64,0.00,0.00,543.68,400148.48,0.00,0.00,0.00),('1','147','768','257968',4904529,'2139','326',1297322.21,1298273.86,0.00,0.00,951.65,700414.40,0.00,0.00,0.00),('1','147','768','257968',4904530,'2942','326',387642.64,388343.55,0.00,0.00,700.91,515869.76,0.00,0.00,0.00),('1','147','768','257969',4904531,'2139','326',1298273.86,1298833.48,0.00,0.00,559.62,411880.32,0.00,0.00,0.00),('1','147','768','257969',4904532,'2942','326',388343.55,388927.41,0.00,0.00,583.86,429720.96,0.00,0.00,0.00),('1','147','768','257970',4904533,'2139','326',1298833.48,1300433.01,0.00,0.00,1599.53,1177254.08,0.00,0.00,0.00),('1','147','768','257970',4904534,'2942','326',388927.41,389692.87,0.00,0.00,765.46,563378.56,0.00,0.00,0.00),('1','147','768','257971',4904535,'2139','326',1300433.01,1301354.97,0.00,0.00,921.96,678562.56,0.00,0.00,0.00),('1','147','768','257971',4904536,'2942','326',389692.87,390509.17,0.00,0.00,816.30,600796.80,0.00,0.00,0.00),('1','147','768','257972',4904537,'2139','326',1301354.97,1302326.38,0.00,0.00,971.41,714957.76,0.00,0.00,0.00),('1','147','768','257972',4904538,'2942','326',390509.17,391221.97,0.00,0.00,712.80,524620.80,0.00,0.00,0.00),('1','147','768','257973',4904539,'2139','326',1302326.38,1302609.20,0.00,0.00,282.82,208155.52,0.00,0.00,0.00),('1','147','768','257973',4904540,'2942','326',391221.97,391500.34,0.00,0.00,278.37,204880.32,0.00,0.00,0.00),('1','147','768','257974',4904541,'2139','326',1302609.20,1303140.21,0.00,0.00,531.01,390823.36,0.00,0.00,0.00),('1','147','768','257974',4904542,'2942','326',391500.34,391990.27,0.00,0.00,489.93,360588.48,0.00,0.00,0.00),('1','147','768','257975',4904543,'2139','326',1303140.21,1303278.99,0.00,0.00,138.78,102142.08,0.00,0.00,0.00),('1','147','768','257975',4904544,'2942','326',391990.27,392430.52,0.00,0.00,440.25,324024.00,0.00,0.00,0.00),('1','147','768','257976',4904545,'2139','326',1303278.99,1303973.33,0.00,0.00,694.34,511034.24,0.00,0.00,0.00),('1','147','768','257976',4904546,'2942','326',392430.52,393357.54,0.00,0.00,927.02,682286.72,0.00,0.00,0.00),('1','147','768','257977',4904547,'2139','326',1303973.33,1304737.96,0.00,0.00,764.63,562767.68,0.00,0.00,0.00),('1','147','768','257977',4904548,'2942','326',393357.54,394030.91,0.00,0.00,673.37,495600.32,0.00,0.00,0.00),('1','147','768','257978',4904549,'2139','326',1304737.96,1305448.63,0.00,0.00,710.67,523053.12,0.00,0.00,0.00),('1','147','768','257978',4904550,'2942','326',394030.91,395006.78,0.00,0.00,975.87,718240.32,0.00,0.00,0.00),('1','147','768','257979',4904551,'2139','326',1305448.63,1306783.95,0.00,0.00,1335.32,982795.52,0.00,0.00,0.00),('1','147','768','257979',4904552,'2942','326',395006.78,395820.45,0.00,0.00,813.67,598861.12,0.00,0.00,0.00),('1','147','768','257980',4904553,'2139','326',1306783.95,1308078.49,0.00,0.00,1294.54,952781.44,0.00,0.00,0.00),('1','147','768','257980',4904554,'2942','326',395820.45,395923.24,0.00,0.00,102.79,75653.44,0.00,0.00,0.00),('1','147','768','257981',4904555,'2139','326',1308078.49,1308156.02,0.00,0.00,77.53,57062.08,0.00,0.00,0.00),('1','147','768','257981',4904556,'2942','326',395923.24,397090.46,0.00,0.00,1167.22,859073.92,0.00,0.00,0.00),('1','147','768','257982',4904557,'2139','326',1308156.02,1308225.83,0.00,0.00,69.81,51380.16,0.00,0.00,0.00),('1','147','768','257982',4904558,'2942','326',397090.46,397259.29,0.00,0.00,168.83,124258.88,0.00,0.00,0.00),('1','147','768','257983',4904559,'2139','326',1308225.83,1309476.20,0.00,0.00,1250.37,920272.32,0.00,0.00,0.00),('1','147','768','257983',4904560,'2942','326',397259.29,397552.86,0.00,0.00,293.57,216067.52,0.00,0.00,0.00),('1','147','768','257984',4904561,'2139','326',1309476.20,1310660.28,0.00,0.00,1184.08,871482.88,0.00,0.00,0.00),('1','147','768','257984',4904562,'2942','326',397552.86,397556.94,0.00,0.00,4.08,3002.88,0.00,0.00,0.00),('1','147','768','257985',4904563,'2139','326',1310660.28,1311226.53,0.00,0.00,566.25,416760.00,0.00,0.00,0.00),('1','147','768','257985',4904564,'2942','326',397556.94,397970.69,0.00,0.00,413.75,304520.00,0.00,0.00,0.00),('1','147','768','257986',4904565,'2139','326',1311226.53,1312001.21,0.00,0.00,774.68,570164.48,0.00,0.00,0.00),('1','147','768','257986',4904566,'2942','326',397970.69,398785.17,0.00,0.00,814.48,599457.28,0.00,0.00,0.00),('1','147','768','257987',4904567,'2139','326',1312001.21,1312245.95,0.00,0.00,244.74,180128.64,0.00,0.00,0.00),('1','147','768','257987',4904568,'2942','326',398785.17,398889.63,0.00,0.00,104.46,76882.56,0.00,0.00,0.00),('1','147','768','257988',4904569,'2139','326',1312245.95,1312671.74,0.00,0.00,425.79,313381.44,0.00,0.00,0.00),('1','147','768','257988',4904570,'2942','326',398889.63,399461.09,0.00,0.00,571.46,420594.56,0.00,0.00,0.00),('1','147','768','257989',4904571,'2139','326',1312671.74,1313514.59,0.00,0.00,842.85,620337.60,0.00,0.00,0.00),('1','147','768','257989',4904572,'2942','326',399461.09,399955.15,0.00,0.00,494.06,363628.16,0.00,0.00,0.00),('1','147','768','257990',4904573,'2139','326',1313514.59,1313983.18,0.00,0.00,468.59,344882.24,0.00,0.00,0.00),('1','147','768','257990',4904574,'2942','326',399955.15,401517.24,0.00,0.00,1562.09,1149698.24,0.00,0.00,0.00),('1','147','768','257991',4904575,'2139','326',1313983.18,1314236.38,0.00,0.00,253.20,186355.20,0.00,0.00,0.00),('1','147','768','257991',4904576,'2942','326',401517.24,401878.14,0.00,0.00,360.90,265622.40,0.00,0.00,0.00),('1','147','768','257992',4904577,'2139','326',1314236.38,1314592.77,0.00,0.00,356.39,262303.04,0.00,0.00,0.00),('1','147','768','257992',4904578,'2942','326',401878.14,402181.76,0.00,0.00,303.62,223464.32,0.00,0.00,0.00),('1','147','768','257993',4904579,'2139','326',1314592.77,1315348.36,0.00,0.00,755.59,556114.24,0.00,0.00,0.00),('1','147','768','257993',4904580,'2942','326',402181.76,403059.91,0.00,0.00,878.15,646318.40,0.00,0.00,0.00),('1','147','768','257994',4904581,'2139','326',1315348.36,1316622.68,0.00,0.00,1274.32,897703.00,0.00,0.00,0.00),('1','147','768','257994',4904582,'2942','326',403059.91,403404.62,0.00,0.00,344.71,247416.64,0.00,0.00,0.00),('1','147','768','257995',4904583,'2139','326',1316622.68,1317080.23,0.00,0.00,457.55,320285.00,0.00,0.00,0.00),('1','147','768','257995',4904584,'2942','326',403404.62,404150.56,0.00,0.00,745.94,522158.00,0.00,0.00,0.00),('1','147','768','257996',4904585,'2139','326',1317080.23,1318015.78,0.00,0.00,935.55,654885.00,0.00,0.00,0.00),('1','147','768','257996',4904586,'2942','326',404150.56,404708.18,0.00,0.00,557.62,390334.00,0.00,0.00,0.00),('1','147','768','257997',4904587,'2139','326',1318015.78,1318326.66,0.00,0.00,310.88,217616.00,0.00,0.00,0.00),('1','147','768','257997',4904588,'2942','326',404708.18,406579.56,0.00,0.00,1871.38,1309966.00,0.00,0.00,0.00),('1','147','768','257998',4904589,'2139','326',1318326.66,1318466.52,0.00,0.00,139.86,97902.00,0.00,0.00,0.00),('1','147','768','257998',4904590,'2942','326',406579.56,407914.14,0.00,0.00,1334.58,934206.00,0.00,0.00,0.00),('1','147','768','257999',4904591,'2139','326',1318466.52,1319118.79,0.00,0.00,652.27,456589.00,0.00,0.00,0.00),('1','147','768','257999',4904592,'2942','326',407914.14,407914.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','147','768','258000',4904593,'2139','326',1319118.79,1320289.75,0.00,0.00,1170.96,819672.00,0.00,0.00,0.00),('1','147','768','258000',4904594,'2942','326',407914.14,408291.73,0.00,0.00,377.59,264313.00,0.00,0.00,0.00),('1','147','768','258001',4904595,'2139','326',1320289.75,1321431.06,0.00,0.00,1141.31,798917.00,0.00,0.00,0.00),('1','147','768','258001',4904596,'2942','326',408291.73,408634.19,0.00,0.00,342.46,239722.00,0.00,0.00,0.00),('1','147','768','258002',4904597,'2139','326',1321431.06,1322609.84,0.00,0.00,1178.78,825146.00,0.00,0.00,0.00),('1','147','768','258002',4904598,'2942','326',408634.19,409115.18,0.00,0.00,480.99,336693.00,0.00,0.00,0.00),('1','147','768','258003',4904599,'2139','326',1322609.84,1322914.11,0.00,0.00,304.27,212989.00,0.00,0.00,0.00),('1','147','768','258003',4904600,'2942','326',409115.18,410420.05,0.00,0.00,1304.87,913409.00,0.00,0.00,0.00),('1','147','768','258004',4904601,'2139','326',1322914.11,1323898.33,0.00,0.00,984.22,688954.00,0.00,0.00,0.00),('1','147','768','258004',4904602,'2942','326',410420.05,411132.92,0.00,0.00,712.87,499009.00,0.00,0.00,0.00),('1','147','768','258005',4904603,'2139','326',1323898.33,1324465.16,0.00,0.00,566.83,396781.00,0.00,0.00,0.00),('1','147','768','258005',4904604,'2942','326',411132.92,412015.76,0.00,0.00,882.84,617988.00,0.00,0.00,0.00),('1','147','768','258006',4904605,'2139','326',1324465.16,1325278.07,0.00,0.00,812.91,569037.00,0.00,0.00,0.00),('1','147','768','258006',4904606,'2942','326',412015.76,412293.91,0.00,0.00,278.15,194705.00,0.00,0.00,0.00),('1','147','768','258007',4904607,'2139','326',1325278.07,1326286.15,0.00,0.00,1008.08,705656.00,0.00,0.00,0.00),('1','147','768','258007',4904608,'2942','326',412293.91,412718.31,0.00,0.00,424.40,297080.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730151 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','147','146994','326',210.00,280.00,0.00,378.57,79499.70,105999.60,26499.90,441535),('1','147','147001','326',210.00,280.00,0.00,2128.57,446999.70,595999.60,148999.90,441550),('1','147','147011','326',210.00,280.00,0.00,1971.00,413910.00,551880.00,137970.00,441573),('1','147','147028','326',210.00,280.00,0.00,0.00,0.00,0.00,0.00,441609),('1','147','147033','326',210.00,280.00,0.00,871.78,183073.80,244098.40,61024.60,441618),('1','147','147038','326',210.00,280.00,0.00,2697.50,566475.00,755300.00,188825.00,441625),('1','147','147045','326',210.00,280.00,0.00,2031.00,426510.00,568680.00,142170.00,441643),('1','147','147074','326',210.00,280.00,0.00,1660.71,348749.10,464998.80,116249.70,441720),('1','147','147082','326',210.00,280.00,0.00,1757.14,368999.40,491999.20,122999.80,441732),('1','147','147154','326',210.00,280.00,0.00,1590.00,333900.00,445200.00,111300.00,441878),('1','147','147192','326',210.00,280.00,0.00,148.00,31080.00,41440.00,10360.00,441944),('1','147','147300','326',210.00,280.00,0.00,1118.57,234899.70,313199.60,78299.90,442185),('1','147','147424','326',210.00,280.00,0.00,1640.25,344452.50,459270.00,114817.50,442519),('1','147','147552','326',210.00,280.00,0.00,2235.71,469499.10,625998.80,156499.70,442880),('1','147','147671','326',210.00,280.00,0.00,459.00,96390.00,128520.00,32130.00,443192),('1','147','147853','326',210.00,280.00,0.00,2038.92,428173.20,570897.60,142724.40,443693),('1','147','147982','326',210.00,280.00,0.00,1559.28,327448.80,436598.40,109149.60,444031),('1','147','148115','326',210.00,280.00,0.00,1487.67,312410.70,416547.60,104136.90,444374),('1','147','148262','326',210.00,280.00,0.00,680.00,142800.00,190400.00,47600.00,444757),('1','147','148415','326',222.00,280.00,0.00,2419.46,537120.12,677448.80,140328.68,445163),('1','147','148544','326',222.00,280.00,0.00,2502.00,555444.00,700560.00,145116.00,445499),('1','147','148655','326',202.00,280.00,0.00,1055.35,213180.70,295498.00,82317.30,445781),('1','147','148802','326',202.00,280.00,0.00,1460.35,294990.70,408898.00,113907.30,446154),('1','147','148952','326',202.00,280.00,0.00,1607.14,324642.28,449999.20,125356.92,446555),('1','147','149143','326',202.00,280.00,0.00,1650.00,333300.00,462000.00,128700.00,447067),('1','147','149290','326',205.00,280.00,0.00,1651.78,338614.90,462498.40,123883.50,447447),('1','147','149437','326',205.00,280.00,0.00,1920.35,393671.75,537698.00,144026.25,447842),('1','147','149581','326',210.00,280.00,0.00,2193.00,460530.00,614040.00,153510.00,448243),('1','147','149685','326',222.00,280.00,0.00,1958.57,434802.54,548399.60,113597.06,448513),('1','147','149834','326',222.00,280.00,0.00,2162.50,480075.00,605500.00,125425.00,448911),('1','147','149989','326',222.00,280.00,0.00,1131.00,251082.00,316680.00,65598.00,449324),('1','147','150138','326',222.00,280.00,0.00,2687.57,596640.54,752519.60,155879.06,449716),('1','147','150361','326',222.00,280.00,0.00,2323.57,515832.54,650599.60,134767.06,450293),('1','147','150522','326',222.00,280.00,0.00,374.00,83028.00,104720.00,21692.00,450730),('1','147','150710','326',222.00,280.00,0.00,2119.46,470520.12,593448.80,122928.68,451212),('1','147','150834','326',222.00,280.00,0.00,2394.00,531468.00,670320.00,138852.00,451545),('1','147','150995','326',222.00,280.00,0.00,1719.64,381760.08,481499.20,99739.12,451966),('1','147','151131','326',222.00,280.00,0.00,1864.28,413870.16,521998.40,108128.24,452339),('1','147','151290','326',222.00,280.00,0.00,1328.00,294816.00,371840.00,77024.00,452761),('1','147','151456','326',222.00,280.00,0.00,2139.28,474920.16,598998.40,124078.24,453217),('1','147','151593','326',222.00,280.00,0.00,1501.78,333395.16,420498.40,87103.24,453595),('1','147','151706','326',225.00,280.00,0.00,2019.00,454275.00,565320.00,111045.00,453905),('1','147','151832','326',225.00,280.00,0.00,2287.50,514687.50,640500.00,125812.50,454228),('1','147','152021','326',225.00,280.00,0.00,1448.57,325928.25,405599.60,79671.35,454745),('1','147','152167','326',225.00,280.00,0.00,835.71,188034.75,233998.80,45964.05,455121),('1','147','152327','326',225.00,280.00,0.00,1417.50,318937.50,396900.00,77962.50,455549),('1','147','152541','326',225.00,280.00,0.00,1755.00,394875.00,491400.00,96525.00,456137),('1','147','152581','326',225.00,280.00,0.00,1542.00,346950.00,431760.00,84810.00,456252),('1','147','152781','326',225.00,280.00,0.00,1257.14,282856.50,351999.20,69142.70,456764),('1','147','152902','326',225.00,280.00,0.00,2331.42,524569.50,652797.60,128228.10,457097),('1','147','153090','326',225.00,280.00,0.00,1259.28,283338.00,352598.40,69260.40,457595),('1','147','153281','326',225.00,280.00,0.00,564.00,126900.00,157920.00,31020.00,458134),('1','147','153282','326',225.00,280.00,0.00,803.21,180722.25,224898.80,44176.55,458135),('1','147','153477','326',225.00,280.00,0.00,1323.21,297722.25,370498.80,72776.55,458669),('1','147','153689','326',225.00,280.00,0.00,1582.50,356062.50,443100.00,87037.50,459237),('1','147','153805','326',225.00,280.00,0.00,1485.71,334284.75,415998.80,81714.05,459544),('1','147','153932','326',225.00,280.00,0.00,314.00,70650.00,87920.00,17270.00,459867),('1','147','153933','326',225.00,280.00,0.00,813.57,183053.25,227799.60,44746.35,459868),('1','147','154065','326',225.00,280.00,0.00,2355.35,529953.75,659498.00,129544.25,460214),('1','147','154253','326',225.00,280.00,0.00,1507.32,339147.00,422049.60,82902.60,460728),('1','147','154421','326',225.00,280.00,0.00,904.00,203400.00,253120.00,49720.00,461170),('1','147','154574','326',205.00,280.00,0.00,701.42,143791.10,196397.60,52606.50,461601),('1','147','154756','326',205.00,280.00,0.00,2348.92,481528.60,657697.60,176169.00,462098),('1','147','154890','326',205.00,280.00,0.00,1523.57,312331.85,426599.60,114267.75,462456),('1','147','155010','326',205.00,280.00,0.00,1211.00,248255.00,339080.00,90825.00,462788),('1','147','155011','326',231.00,280.00,0.00,914.64,211281.84,256099.20,44817.36,462789),('1','147','155153','326',231.00,280.00,0.00,2657.14,613799.34,743999.20,130199.86,463170),('1','147','155319','326',231.00,280.00,0.00,1691.07,390637.17,473499.60,82862.43,463604),('1','147','155431','326',231.00,280.00,0.00,515.00,115875.00,144200.00,28325.00,463922),('1','147','155444','326',231.00,280.00,0.00,1386.42,320263.02,388197.60,67934.58,463954),('1','147','155658','326',231.00,280.00,0.00,1825.35,421655.85,511098.00,89442.15,464529),('1','147','155783','326',231.00,280.00,0.00,1562.14,360854.34,437399.20,76544.86,464868),('1','147','155914','326',231.00,280.00,0.00,1010.00,233310.00,282800.00,49490.00,465210),('1','147','156071','326',226.00,280.00,0.00,2548.21,575895.46,713498.80,137603.34,465627),('1','147','156238','326',226.00,280.00,0.00,2316.78,523592.28,648698.40,125106.12,466063),('1','147','156402','326',226.00,280.00,0.00,574.00,129150.00,160720.00,31570.00,466500),('1','147','156563','326',226.00,280.00,0.00,1736.42,392430.92,486197.60,93766.68,466933),('1','147','156740','326',226.00,280.00,0.00,1421.42,321240.92,397997.60,76756.68,467418),('1','147','156918','326',226.00,280.00,0.00,1660.00,375160.00,464800.00,89640.00,467902),('1','147','157111','326',225.00,280.00,0.00,816.00,183600.00,228480.00,44880.00,468392),('1','147','157264','326',211.00,280.00,0.00,2117.14,446716.54,592799.20,146082.66,468805),('1','147','157476','326',211.00,280.00,0.00,2767.67,583978.37,774947.60,190969.23,469330),('1','147','157638','326',211.00,280.00,0.00,891.00,188001.00,249480.00,61479.00,469771),('1','147','157808','326',226.00,280.00,0.00,1507.50,340695.00,422100.00,81405.00,470223),('1','147','157944','326',226.00,280.00,0.00,1606.07,362971.82,449699.60,86727.78,470591),('1','147','158097','326',226.00,280.00,0.00,1752.85,396144.10,490798.00,94653.90,470971),('1','147','158274','326',226.00,280.00,0.00,415.00,93790.00,116200.00,22410.00,471445),('1','147','158294','326',226.00,280.00,0.00,862.50,194925.00,241500.00,46575.00,471496),('1','147','158429','326',226.00,280.00,0.00,1890.35,427219.10,529298.00,102078.90,471859),('1','147','158610','326',226.00,280.00,0.00,2248.21,508095.46,629498.80,121403.34,472324),('1','147','158775','326',226.00,280.00,0.00,846.00,191196.00,236880.00,45684.00,472746),('1','147','158904','326',231.00,296.00,0.00,575.00,132825.00,170200.00,37375.00,473099),('1','147','158908','326',231.00,296.00,0.00,0.00,0.00,0.00,0.00,473107),('1','147','159281','326',231.00,296.00,0.00,2174.94,502411.14,643782.24,141371.10,474109),('1','147','159282','326',231.00,296.00,0.00,0.00,0.00,0.00,0.00,474110),('1','147','159461','326',231.00,296.00,0.00,1680.40,388172.40,497398.40,109226.00,474548),('1','147','159641','326',231.00,296.00,0.00,803.36,185576.16,237794.56,52218.40,475029),('1','147','159642','326',231.00,304.00,0.00,626.26,144666.06,190383.04,45716.98,475030),('1','147','159643','326',231.00,304.00,0.00,0.00,0.00,0.00,0.00,475031),('1','147','159744','326',231.00,304.00,0.00,2987.17,690036.27,908099.68,218063.41,475270),('1','147','159954','326',231.00,304.00,0.00,1593.75,368156.25,484500.00,116343.75,475823),('1','147','159963','326',231.00,304.00,0.00,0.00,0.00,0.00,0.00,475842),('1','147','160115','326',235.00,304.00,0.00,1332.89,313229.15,405198.56,91969.41,476251),('1','147','160260','326',235.00,304.00,0.00,1689.47,397025.45,513598.88,116573.43,476637),('1','147','160448','326',235.00,320.00,0.00,1467.50,344862.50,469600.00,124737.50,477129),('1','147','160594','326',235.00,320.00,0.00,717.18,168537.30,229497.60,60960.30,477503),('1','147','160596','326',235.00,320.00,0.00,0.00,0.00,0.00,0.00,477505),('1','147','160601','326',215.00,320.00,0.00,658.12,141495.80,210598.40,69102.60,477513),('1','147','160734','326',215.00,320.00,0.00,1686.87,362677.05,539798.40,177121.35,477869),('1','147','160917','326',215.00,320.00,0.00,2490.93,535549.95,797097.60,261547.65,478300),('1','147','161100','326',215.00,320.00,0.00,937.00,201455.00,299840.00,98385.00,478798),('1','147','161260','326',235.00,320.00,0.00,922.50,216787.50,295200.00,78412.50,479230),('1','147','161441','326',235.00,320.00,0.00,1278.90,300541.50,409248.00,108706.50,479684),('1','147','161649','326',235.00,320.00,0.00,1316.56,309391.60,421299.20,111907.60,480217),('1','147','161891','326',235.00,320.00,0.00,1400.00,329000.00,448000.00,119000.00,480811),('1','147','162048','326',235.00,320.00,0.00,1338.75,314606.25,428400.00,113793.75,481242),('1','147','162221','326',235.00,0.00,0.00,1880.26,441861.10,571599.04,129737.94,481681),('1','147','162446','326',235.00,304.00,0.00,1775.55,417254.25,539767.20,122512.95,482261),('1','147','162646','326',235.00,304.00,0.00,210.52,49472.20,63998.08,14525.88,482745),('1','147','162647','326',235.00,304.00,0.00,943.09,221626.15,286699.36,65073.21,482746),('1','147','162827','326',235.00,304.00,0.00,1176.31,276432.85,357598.24,81165.39,483219),('1','147','163021','326',235.00,304.00,0.00,1319.40,310059.00,401097.60,91038.60,483735),('1','147','163264','326',235.00,304.00,0.00,1261.34,296414.90,383447.36,87032.46,484358),('1','147','163268','326',235.00,304.00,0.00,576.31,135432.85,175198.24,39765.39,484368),('1','147','163381','326',237.00,304.00,0.00,963.81,228422.97,292998.24,64575.27,484659),('1','147','163544','326',237.00,304.00,0.00,1907.89,452169.93,579998.56,127828.63,485095),('1','147','163745','326',237.00,304.00,0.00,1024.01,242690.37,311299.04,68608.67,485617),('1','147','163905','326',237.00,304.00,0.00,1203.02,285115.74,365718.08,80602.34,486028),('1','147','164091','326',237.00,304.00,0.00,1118.42,265065.54,339999.68,74934.14,486511),('1','147','164259','326',237.00,304.00,0.00,1312.33,311022.21,398948.32,87926.11,486962),('1','147','164447','326',237.00,304.00,0.00,1236.84,293131.08,375999.36,82868.28,487464),('1','147','164604','326',237.00,304.00,0.00,1290.95,305955.15,392448.80,86493.65,487892),('1','147','164977','326',237.00,304.00,0.00,1995.06,472829.22,606498.24,133669.02,488858),('1','147','164978','326',237.00,304.00,0.00,1151.31,272860.47,349998.24,77137.77,488859),('1','147','164979','326',237.00,320.00,0.00,529.68,125534.16,169497.60,43963.44,488860),('1','147','165114','326',237.00,320.00,0.00,1484.03,351715.11,474889.60,123174.49,489217),('1','147','165314','326',237.00,304.00,0.00,1934.21,458407.77,587999.84,129592.07,489727),('1','147','165446','326',237.00,304.00,0.00,1651.31,391360.47,501998.24,110637.77,490079),('1','147','165660','326',237.00,304.00,0.00,1621.38,384267.06,492899.52,108632.46,490645),('1','147','165799','326',237.00,304.00,0.00,1564.14,370701.18,475498.56,104797.38,491019),('1','147','165932','326',237.00,304.00,0.00,2401.31,569110.47,729998.24,160887.77,491373),('1','147','166138','326',237.00,304.00,0.00,1089.47,258204.39,331198.88,72994.49,491916),('1','147','166323','326',252.00,304.00,0.00,1646.71,414970.92,500599.84,85628.92,492405),('1','147','166487','326',252.00,304.00,0.00,1935.85,487834.20,588498.40,100664.20,492857),('1','147','166688','326',252.00,304.00,0.00,1378.28,347326.56,418997.12,71670.56,493396),('1','147','166858','326',252.00,304.00,0.00,210.52,53051.04,63998.08,10947.04,493860),('1','147','166889','326',276.00,304.00,0.00,1180.92,325933.92,358999.68,33065.76,493934),('1','147','167047','326',276.00,304.00,0.00,2006.57,553813.32,609997.28,56183.96,494354),('1','147','167189','326',276.00,304.00,0.00,2197.36,606471.36,667997.44,61526.08,494730),('1','147','167375','326',276.00,304.00,0.00,210.52,58103.52,63998.08,5894.56,495239),('1','147','167380','326',275.00,304.00,0.00,1144.34,314693.50,347879.36,33185.86,495248),('1','147','167563','326',275.00,304.00,0.00,1268.09,348724.75,385499.36,36774.61,495736),('1','147','167741','326',275.00,304.00,0.00,1693.42,465690.50,514799.68,49109.18,496194),('1','147','167891','326',275.00,304.00,0.00,1023.25,281393.75,311068.00,29674.25,496601),('1','147','168134','326',275.00,304.00,0.00,2019.73,555425.75,613997.92,58572.17,497235),('1','147','168281','326',275.00,304.00,0.00,2067.43,568543.25,628498.72,59955.47,497638),('1','147','168361','326',275.00,304.00,0.00,1017.76,279884.00,309399.04,29515.04,497857),('1','147','168407','326',275.00,304.00,0.00,1300.95,357761.25,395488.80,37727.55,497974),('1','147','168607','326',275.00,304.00,0.00,1637.82,450400.50,497897.28,47496.78,498498),('1','147','168765','326',275.00,304.00,0.00,1702.30,468132.50,517499.20,49366.70,498927),('1','147','168924','326',275.00,304.00,0.00,414.47,113979.25,125998.88,12019.63,499346),('1','147','169060','326',276.00,304.00,0.00,1810.85,499794.60,550498.40,50703.80,499700),('1','147','169106','326',276.00,304.00,0.00,3110.19,858412.44,945497.76,87085.32,499802),('1','147','169250','326',276.00,304.00,0.00,916.97,253083.72,278758.88,25675.16,500170),('1','147','169256','326',276.00,304.00,0.00,1151.31,317761.56,349998.24,32236.68,500184),('1','147','169433','326',276.00,304.00,0.00,2059.21,568341.96,625999.84,57657.88,500638),('1','147','169572','326',276.00,304.00,0.00,1526.31,421261.56,463998.24,42736.68,501000),('1','147','169777','326',276.00,304.00,0.00,448.19,123700.44,136249.76,12549.32,501542),('1','147','169778','326',276.00,304.00,0.00,929.27,256478.52,282498.08,26019.56,501543),('1','147','169939','326',276.00,304.00,0.00,1506.57,415813.32,457997.28,42183.96,501990),('1','147','170150','326',276.00,304.00,0.00,1741.77,480728.52,529498.08,48769.56,502521),('1','147','170346','326',276.00,304.00,0.00,899.06,248140.56,273314.24,25173.68,503034),('1','147','170441','326',276.00,304.00,0.00,1210.52,334103.52,367998.08,33894.56,503294),('1','147','170499','326',276.00,304.00,0.00,2452.30,676834.80,745499.20,68664.40,503438),('1','147','170645','326',276.00,304.00,0.00,1578.40,435638.40,479833.60,44195.20,503822),('1','147','170966','326',285.00,320.00,0.00,1773.00,505305.00,567360.00,62055.00,504675),('1','147','171004','326',285.00,320.00,0.00,1593.75,454218.75,510000.00,55781.25,504760),('1','147','171220','326',285.00,320.00,0.00,1702.93,485335.05,544937.60,59602.55,505347),('1','147','171363','326',285.00,320.00,0.00,187.18,53346.30,59897.60,6551.30,505727),('1','147','171367','326',285.00,320.00,0.00,1292.18,368271.30,413497.60,45226.30,505735),('1','147','171585','326',285.00,320.00,0.00,1373.43,391427.55,439497.60,48070.05,506323),('1','147','171764','326',285.00,320.00,0.00,1653.12,471139.20,528998.40,57859.20,506794),('1','147','171966','326',285.00,320.00,0.00,1101.40,313899.00,352448.00,38549.00,507324),('1','147','171967','326',276.00,320.00,0.00,471.87,130236.12,150998.40,20762.28,507325),('1','147','172079','326',276.00,320.00,0.00,2023.43,558466.68,647497.60,89030.92,507622),('1','147','172270','326',276.00,320.00,0.00,1590.62,439011.12,508998.40,69987.28,508138),('1','147','172489','326',276.00,320.00,0.00,819.18,226093.68,262137.60,36043.92,508718),('1','147','172701','326',271.00,320.00,0.00,2059.37,558089.27,658998.40,100909.13,509271),('1','147','172875','326',271.00,320.00,0.00,1687.50,457312.50,540000.00,82687.50,509730),('1','147','173056','326',271.00,320.00,0.00,1054.68,285818.28,337497.60,51679.32,510211),('1','147','173222','326',271.00,320.00,0.00,2754.60,746496.60,881472.00,134975.40,510651),('1','147','173389','326',271.00,320.00,0.00,2350.00,636850.00,752000.00,115150.00,511089),('1','147','173600','326',271.00,320.00,0.00,631.25,171068.75,202000.00,30931.25,511649),('1','147','173764','326',271.00,320.00,0.00,1703.12,461545.52,544998.40,83452.88,512084),('1','147','173944','326',271.00,320.00,0.00,1887.50,511512.50,604000.00,92487.50,512559),('1','147','174029','326',271.00,320.00,0.00,105.59,28614.89,33788.80,5173.91,512792),('1','147','174127','326',271.00,320.00,0.00,0.00,0.00,0.00,0.00,513046),('1','147','174128','326',271.00,320.00,0.00,1185.93,321387.03,379497.60,58110.57,513047),('1','147','174317','326',271.00,320.00,0.00,1646.87,446301.77,526998.40,80696.63,513546),('1','147','174389','326',271.00,320.00,0.00,1807.50,489832.50,578400.00,88567.50,513722),('1','147','174627','326',276.00,320.00,0.00,2578.75,711735.00,825200.00,113465.00,514332),('1','147','174838','326',276.00,320.00,0.00,730.63,201653.88,233801.60,32147.72,514895),('1','147','175031','326',276.00,360.00,0.00,1548.86,427485.36,557589.60,130104.24,515408),('1','147','175233','326',276.00,360.00,0.00,253.00,69828.00,91080.00,21252.00,515940),('1','147','175235','326',300.00,360.00,0.00,1040.80,312240.00,374688.00,62448.00,515942),('1','147','175400','326',300.00,360.00,0.00,1720.40,516120.00,619344.00,103224.00,516381),('1','147','175589','326',300.00,360.00,0.00,1684.40,505320.00,606384.00,101064.00,516870),('1','147','175760','326',300.00,360.00,0.00,1950.30,585090.00,702108.00,117018.00,517317),('1','147','175918','326',300.00,360.00,0.00,2700.50,810150.00,972180.00,162030.00,517728),('1','147','176144','326',300.00,360.00,0.00,269.80,80940.00,97128.00,16188.00,518299),('1','147','176145','326',300.00,360.00,0.00,1315.40,394620.00,473544.00,78924.00,518300),('1','147','176315','326',300.00,360.00,0.00,1920.80,576240.00,691488.00,115248.00,518746),('1','147','176547','326',300.00,360.00,0.00,1900.20,570060.00,684072.00,114012.00,519348),('1','147','176791','326',300.00,360.00,0.00,362.80,108840.00,130608.00,21768.00,520001),('1','147','176798','326',303.00,360.00,0.00,1345.20,407595.60,484272.00,76676.40,520018),('1','147','176960','326',303.00,360.00,0.00,1600.10,484830.30,576036.00,91205.70,520466),('1','147','177214','326',303.00,360.00,0.00,1818.00,550854.00,654480.00,103626.00,521115),('1','147','177409','326',308.00,360.00,0.00,2400.50,739354.00,864180.00,124826.00,521627),('1','147','177622','326',308.00,360.00,0.00,1530.00,471240.00,550800.00,79560.00,522196),('1','147','177874','326',308.00,360.00,0.00,1588.80,489350.40,571968.00,82617.60,522872),('1','147','178070','326',308.00,360.00,0.00,54.70,16847.60,19692.00,2844.40,523396),('1','147','178071','326',303.00,360.00,0.00,1190.50,360721.50,428580.00,67858.50,523397),('1','147','178278','326',303.00,360.00,0.00,1650.80,500192.40,594288.00,94095.60,523935),('1','147','178490','326',303.00,360.00,0.00,1280.90,388112.70,461124.00,73011.30,524485),('1','147','178708','326',303.00,360.00,0.00,1392.20,421836.60,501192.00,79355.40,525060),('1','147','179037','326',288.00,0.00,0.00,2340.70,674121.60,842652.00,168530.40,525912),('1','147','179039','326',288.00,360.00,0.00,1529.86,440599.68,550749.60,110149.92,525916),('1','147','179141','326',288.00,360.00,0.00,1692.21,487356.48,609195.60,121839.12,526186),('1','147','179364','326',288.00,360.00,0.00,141.82,40844.16,51055.20,10211.04,526791),('1','147','179414','326',288.00,360.00,0.00,823.42,246809.31,296431.20,49621.89,526919),('1','147','179568','326',303.00,360.00,0.00,1846.56,559507.68,664761.60,105253.92,527329),('1','147','179789','326',303.00,360.00,0.00,2186.38,662473.14,787096.80,124623.66,527911),('1','147','180003','326',303.00,360.00,0.00,322.78,97802.34,116200.80,18398.46,528467),('1','147','180058','326',303.00,360.00,0.00,804.99,243911.97,289796.40,45884.43,528620),('1','147','180223','326',303.00,360.00,0.00,1556.11,448159.68,560199.60,112039.92,529051),('1','147','180240','326',288.00,360.00,0.00,2401.11,691519.68,864399.60,172879.92,529094),('1','147','180340','326',288.00,360.00,0.00,1283.50,369648.00,461700.00,92052.00,529347),('1','147','180555','326',288.00,360.00,0.00,469.42,135192.96,168991.20,33798.24,529913),('1','147','180674','326',308.00,360.00,0.00,901.45,277646.60,324522.00,46875.40,530235),('1','147','180736','326',308.00,360.00,0.00,1470.26,452840.08,529293.60,76453.52,530392),('1','147','180959','326',308.00,360.00,0.00,1592.62,490526.96,568843.20,78316.24,530991),('1','147','181131','326',308.00,360.00,0.00,1204.92,371115.36,433771.20,62655.84,531444),('1','147','181419','326',308.00,360.00,0.00,1907.02,587362.16,686527.20,99165.04,532201),('1','147','181524','326',308.00,360.00,0.00,2320.38,714677.04,835336.80,120659.76,532487),('1','147','181703','326',308.00,360.00,0.00,1394.26,429432.08,501933.60,72501.52,532956),('1','147','182028','326',308.00,360.00,0.00,1361.68,419397.44,490204.80,70807.36,533840),('1','147','182103','326',308.00,360.00,0.00,1827.79,562959.32,658004.40,95045.08,534037),('1','147','182307','326',308.00,360.00,0.00,2151.03,662517.24,774370.80,111853.56,534554),('1','147','182498','326',308.00,360.00,0.00,215.61,66407.88,77619.60,11211.72,535071),('1','147','182559','326',308.00,360.00,0.00,1356.67,417854.36,488401.20,70546.84,535225),('1','147','183087','326',308.00,360.00,0.00,2350.00,723800.00,846000.00,122200.00,536664),('1','147','183164','326',308.00,360.00,0.00,1889.50,581966.00,680220.00,98254.00,536844),('1','147','183169','326',308.00,360.00,0.00,388.88,121719.44,139996.80,18277.36,536857),('1','147','183196','326',313.00,360.00,0.00,1638.89,512972.57,590000.40,77027.83,536932),('1','147','183210','326',313.00,360.00,0.00,111.99,35052.87,40316.40,5263.53,536960),('1','147','183322','326',313.00,360.00,0.00,852.53,266841.89,306910.80,40068.91,537243),('1','147','183426','326',313.00,360.00,0.00,1320.38,413278.94,475336.80,62057.86,537517),('1','147','183652','326',313.00,360.00,0.00,1400.86,438469.18,504309.60,65840.42,538111),('1','147','183900','326',313.00,360.00,0.00,1607.89,503269.57,578840.40,75570.83,538773),('1','147','184127','326',313.00,360.00,0.00,541.57,169511.41,194965.20,25453.79,539375),('1','147','184147','326',313.00,360.00,0.00,1237.78,387425.14,445600.80,58175.66,539429),('1','147','184268','326',313.00,360.00,0.00,2474.57,774540.41,890845.20,116304.79,539754),('1','147','184512','326',313.00,360.00,0.00,1300.09,406928.17,468032.40,61104.23,540377),('1','147','184748','326',313.00,360.00,0.00,147.22,46079.86,52999.20,6919.34,541027),('1','147','184775','326',313.00,360.00,0.00,1220.84,382122.92,439502.40,57379.48,541101),('1','147','184908','326',313.00,360.00,0.00,1155.56,361690.28,416001.60,54311.32,541444),('1','147','185154','326',313.00,360.00,0.00,1320.16,413210.08,475257.60,62047.52,542086),('1','147','185278','326',313.00,360.00,0.00,1381.40,432378.20,497304.00,64925.80,542377),('1','147','185480','326',313.00,360.00,0.00,655.60,205202.80,236016.00,30813.20,542915),('1','147','185538','326',313.00,360.00,0.00,1115.31,349092.03,401511.60,52419.57,543071),('1','147','185673','326',313.00,360.00,0.00,570.74,178641.62,205466.40,26824.78,543440),('1','147','185764','326',313.00,360.00,0.00,1118.09,359529.27,402512.40,42983.13,543683),('1','147','185871','326',323.00,360.00,0.00,1358.09,438663.07,488912.40,50249.33,543967),('1','147','186087','326',323.00,360.00,0.00,1376.25,444528.75,495450.00,50921.25,544537),('1','147','186309','326',323.00,360.00,0.00,917.99,296510.77,330476.40,33965.63,545120),('1','147','186492','326',313.00,360.00,0.00,273.42,85580.46,98431.20,12850.74,545611),('1','147','186537','326',313.00,360.00,0.00,1476.11,462022.43,531399.60,69377.17,545719),('1','147','186747','326',313.00,360.00,0.00,1766.45,552898.85,635922.00,83023.15,546265),('1','147','186977','326',313.00,360.00,0.00,1933.64,605229.32,696110.40,90881.08,546841),('1','147','187160','326',313.00,360.00,0.00,283.33,88682.29,101998.80,13316.51,547332),('1','147','187284','326',313.00,360.00,0.00,1279.05,400342.65,460458.00,60115.35,547660),('1','147','187347','326',313.00,360.00,0.00,1540.35,482129.55,554526.00,72396.45,547820),('1','147','187571','326',313.00,360.00,0.00,1636.04,512080.52,588974.40,76893.88,548414),('1','147','187793','326',313.00,360.00,0.00,1259.82,394323.66,453535.20,59211.54,549002),('1','147','188043','326',313.00,360.00,0.00,2591.29,811073.77,932864.40,121790.63,549642),('1','147','188206','326',313.00,360.00,0.00,2439.98,763713.74,878392.80,114679.06,550080),('1','147','188509','326',313.00,360.00,0.00,2302.87,743765.91,829033.20,85267.29,550851),('1','147','188600','326',323.00,360.00,0.00,2364.73,763807.79,851302.80,87495.01,551088),('1','147','188984','326',313.00,360.00,0.00,2628.22,822632.86,946159.20,123526.34,552108),('1','147','189083','326',313.00,360.00,0.00,1676.14,524631.82,603410.40,78778.58,552359),('1','147','189195','326',313.00,360.00,0.00,630.84,197452.92,227102.40,29649.48,552654),('1','147','189347','326',313.00,360.00,0.00,791.69,247798.97,285008.40,37209.43,553065),('1','147','189417','326',313.00,360.00,0.00,1569.28,491184.64,564940.80,73756.16,553241),('1','147','189624','326',313.00,360.00,0.00,1400.74,438431.62,504266.40,65834.78,553764),('1','147','189810','326',313.00,360.00,0.00,884.34,276798.42,318362.40,41563.98,554251),('1','147','190066','326',313.00,360.00,0.00,2511.04,785955.52,903974.40,118018.88,554911),('1','147','190207','326',313.00,360.00,0.00,1563.38,489337.94,562816.80,73478.86,555290),('1','147','190429','326',313.00,360.00,0.00,843.10,263890.30,303516.00,39625.70,555872),('1','147','190904','326',323.00,360.00,0.00,793.81,256400.63,285771.60,29370.97,557116),('1','147','190927','326',323.00,360.00,0.00,1995.30,644481.90,718308.00,73826.10,557171),('1','147','191129','326',323.00,360.00,0.00,1386.15,447726.45,499014.00,51287.55,557704),('1','147','192294','326',323.00,360.00,0.00,710.00,229330.00,255600.00,26270.00,560815),('1','147','192309','326',323.00,360.00,0.00,593.33,191645.59,213598.80,21953.21,560855),('1','147','192310','326',323.00,360.00,0.00,2313.52,747266.96,832867.20,85600.24,560856),('1','147','192311','326',323.00,360.00,0.00,1566.94,506121.62,564098.40,57976.78,560857),('1','147','192314','326',323.00,360.00,0.00,796.75,257350.25,286830.00,29479.75,560863),('1','147','192319','326',323.00,360.00,0.00,1719.94,555540.62,619178.40,63637.78,560874),('1','147','192412','326',323.00,360.00,0.00,1606.67,518954.41,578401.20,59446.79,561097),('1','147','192563','326',323.00,360.00,0.00,1618.73,522849.79,582742.80,59893.01,561503),('1','147','192749','326',323.00,360.00,0.00,890.46,287618.58,320565.60,32947.02,561992),('1','147','192891','326',313.00,360.00,0.00,855.83,267874.79,308098.80,40224.01,562358),('1','147','192945','326',313.00,360.00,0.00,2385.49,746658.37,858776.40,112118.03,562507),('1','147','193167','326',313.00,360.00,0.00,1462.01,457609.13,526323.60,68714.47,563082),('1','147','193409','326',313.00,360.00,0.00,1160.56,363255.28,417801.60,54546.32,563721),('1','147','193655','326',313.00,360.00,0.00,1893.15,592555.95,681534.00,88978.05,564333),('1','147','193888','326',313.00,360.00,0.00,1678.15,525260.95,604134.00,78873.05,564924),('1','147','194086','326',313.00,360.00,0.00,1835.48,574505.24,660772.80,86267.56,565429),('1','147','194350','326',313.00,360.00,0.00,439.00,137407.00,158040.00,20633.00,566111),('1','147','194417','326',313.00,360.00,0.00,2000.72,626225.36,720259.20,94033.84,566291),('1','147','194489','326',313.00,360.00,0.00,2373.24,742824.12,854366.40,111542.28,566467),('1','147','194675','326',313.00,360.00,0.00,1502.64,470326.32,540950.40,70624.08,566941),('1','147','194923','326',313.00,360.00,0.00,1696.37,530963.81,610693.20,79729.39,567600),('1','147','195087','326',313.00,360.00,0.00,1710.57,535408.41,615805.20,80396.79,568021),('1','147','195305','326',313.00,360.00,0.00,1964.26,614813.38,707133.60,92320.22,568590),('1','147','195522','326',313.00,360.00,0.00,489.60,153244.80,176256.00,23011.20,569147),('1','147','195647','326',313.00,360.00,0.00,1074.40,336287.20,386784.00,50496.80,569437),('1','147','195764','326',313.00,360.00,0.00,2546.56,797073.28,916761.60,119688.32,569751),('1','147','195999','326',313.00,360.00,0.00,1967.34,615777.42,708242.40,92464.98,570350),('1','147','196275','326',313.00,360.00,0.00,1498.25,468952.25,539370.00,70417.75,571027),('1','147','196461','326',313.00,360.00,0.00,1749.75,547671.75,629910.00,82238.25,571516),('1','147','196661','326',313.00,360.00,0.00,1810.56,566705.28,651801.60,85096.32,572032),('1','147','196908','326',313.00,360.00,0.00,775.73,242803.49,279262.80,36459.31,572675),('1','147','197079','326',323.00,360.00,0.00,1410.06,455449.38,507621.60,52172.22,573116),('1','147','197362','326',323.00,360.00,0.00,1910.00,616930.00,687600.00,70670.00,573836),('1','147','197410','326',323.00,360.00,0.00,1932.00,624036.00,695520.00,71484.00,573913),('1','147','197564','326',323.00,360.00,0.00,1364.50,418901.50,491220.00,72318.50,574285),('1','147','197930','326',307.00,360.00,0.00,1484.96,455882.72,534585.60,78702.88,575268),('1','147','198146','326',307.00,360.00,0.00,1216.71,373529.97,438015.60,64485.63,575815),('1','147','198364','326',307.00,360.00,0.00,1231.55,378085.85,443358.00,65272.15,576384),('1','147','198567','326',307.00,360.00,0.00,530.14,162752.98,190850.40,28097.42,576930),('1','147','198688','326',307.00,360.00,0.00,613.46,188332.22,220845.60,32513.38,577247),('1','147','198781','326',307.00,360.00,0.00,2097.24,643852.68,755006.40,111153.72,577446),('1','147','198986','326',307.00,360.00,0.00,2193.05,673266.35,789498.00,116231.65,577983),('1','147','199222','326',307.00,360.00,0.00,528.48,162243.36,190252.80,28009.44,578569),('1','147','199399','326',307.00,360.00,0.00,533.33,163732.31,191998.80,28266.49,579008),('1','147','199464','326',307.00,360.00,0.00,1602.54,491979.78,576914.40,84934.62,579159),('1','147','199671','326',307.00,360.00,0.00,1505.13,462074.91,541846.80,79771.89,579676),('1','147','199967','326',307.00,360.00,0.00,1830.34,561914.38,658922.40,97008.02,580423),('1','147','200107','326',307.00,360.00,0.00,420.82,129191.74,151495.20,22303.46,580781),('1','147','200224','326',307.00,360.00,0.00,1071.69,329008.83,385808.40,56799.57,581097),('1','147','200294','326',307.00,360.00,0.00,2151.86,660621.02,774669.60,114048.58,581272),('1','147','200497','326',307.00,360.00,0.00,2426.75,745012.25,873630.00,128617.75,581799),('1','147','200712','326',307.00,360.00,0.00,269.60,82767.20,97056.00,14288.80,582360),('1','147','200770','326',307.00,360.00,0.00,1401.26,430186.82,504453.60,74266.78,582514),('1','147','200933','326',307.00,360.00,0.00,2270.80,697135.60,817488.00,120352.40,582921),('1','147','201134','326',307.00,360.00,0.00,2089.93,641608.51,752374.80,110766.29,583422),('1','147','201345','326',307.00,360.00,0.00,129.07,39624.49,46465.20,6840.71,583970),('1','147','201350','326',307.00,360.00,0.00,1321.27,418842.59,475657.20,56814.61,583981),('1','147','201518','326',317.00,360.00,0.00,1872.61,593617.37,674139.60,80522.23,584422),('1','147','201770','326',317.00,360.00,0.00,2272.04,720088.68,817934.40,97845.72,585100),('1','147','202046','326',317.00,360.00,0.00,2557.78,810816.26,920800.80,109984.54,585824),('1','147','202263','326',317.00,360.00,0.00,1651.28,523455.76,594460.80,71005.04,586377),('1','147','202455','326',317.00,360.00,0.00,781.02,247583.34,281167.20,33583.86,586869),('1','147','202702','326',317.00,360.00,0.00,593.69,188199.73,213728.40,25528.67,587499),('1','147','202707','326',317.00,360.00,0.00,1741.33,552001.61,626878.80,74877.19,587512),('1','147','202849','326',317.00,360.00,0.00,1623.41,514620.97,584427.60,69806.63,587889),('1','147','203100','326',317.00,360.00,0.00,1219.88,386701.96,439156.80,52454.84,588546),('1','147','203382','326',317.00,360.00,0.00,1874.90,594343.30,674964.00,80620.70,589283),('1','147','203518','326',317.00,360.00,0.00,2367.16,750389.72,852177.60,101787.88,589622),('1','147','203730','326',317.00,360.00,0.00,1.39,440.63,500.40,59.77,590168),('1','147','203747','326',317.00,376.00,0.00,833.34,0.00,313260.32,313260.32,590202),('1','147','203930','326',0.00,376.00,0.00,422.83,131922.96,158984.08,27061.12,590696),('1','147','203957','326',312.00,376.00,0.00,1303.90,406816.80,490266.40,83449.60,590755),('1','147','204189','326',312.00,376.00,0.00,2515.02,784686.24,945647.52,160961.28,591364),('1','147','204390','326',312.00,376.00,0.00,1597.15,498310.80,600528.40,102217.60,591886),('1','147','204676','326',322.00,376.00,0.00,1440.43,463818.46,541601.68,77783.22,592603),('1','147','204862','326',322.00,376.00,0.00,2216.92,713848.24,833561.92,119713.68,593048),('1','147','205039','326',322.00,376.00,0.00,1858.65,598485.30,698852.40,100367.10,593511),('1','147','205262','326',312.00,376.00,0.00,1555.35,485269.20,584811.60,99542.40,594087),('1','147','205480','326',312.00,376.00,0.00,1516.50,473148.00,570204.00,97056.00,594635),('1','147','205725','326',312.00,376.00,0.00,2247.01,701067.12,844875.76,143808.64,595288),('1','147','205943','326',312.00,376.00,0.00,480.14,149803.68,180532.64,30728.96,595847),('1','147','206038','326',322.00,376.00,0.00,971.44,312803.68,365261.44,52457.76,596091),('1','147','206194','326',322.00,376.00,0.00,1793.32,577449.04,674288.32,96839.28,596482),('1','147','206437','326',322.00,376.00,0.00,2236.24,720069.28,840826.24,120756.96,597102),('1','147','206618','326',318.00,376.00,0.00,2665.31,847568.58,1002156.56,154587.98,597559),('1','147','206838','326',318.00,376.00,0.00,1980.76,629881.68,744765.76,114884.08,598129),('1','147','207072','326',318.00,376.00,0.00,1232.93,392071.74,463581.68,71509.94,598735),('1','147','207207','326',318.00,376.00,0.00,405.99,129104.82,152652.24,23547.42,599099),('1','147','207258','326',318.00,376.00,0.00,2398.38,762684.84,901790.88,139106.04,599223),('1','147','207509','326',318.00,376.00,0.00,2518.66,800933.88,947016.16,146082.28,599873),('1','147','207757','326',0.00,384.00,0.00,545.97,173618.46,209652.48,36034.02,600496),('1','147','207775','326',318.00,384.00,0.00,1056.00,335808.00,405504.00,69696.00,600540),('1','147','207882','326',322.00,384.00,0.00,587.60,189207.20,225638.40,36431.20,600828),('1','147','207987','326',322.00,384.00,0.00,2944.43,948106.46,1130661.12,182554.66,601093),('1','147','208160','326',322.00,384.00,0.00,1603.97,516478.34,615924.48,99446.14,601525),('1','147','208284','326',322.00,384.00,0.00,801.09,257950.98,307618.56,49667.58,601866),('1','147','208378','326',322.00,384.00,0.00,2750.19,885561.18,1056072.96,170511.78,602089),('1','147','208585','326',322.00,384.00,0.00,1403.72,451985.84,539028.48,87042.64,602615),('1','147','208734','326',318.00,384.00,0.00,483.07,153616.26,185498.88,31882.62,603023),('1','147','208826','326',318.00,384.00,0.00,2121.22,674547.96,814548.48,140000.52,603224),('1','147','209036','326',318.00,384.00,0.00,82.03,26085.54,31499.52,5413.98,603758),('1','147','209040','326',0.00,400.00,0.00,2033.60,0.00,813440.00,813440.00,603767),('1','147','209269','326',0.00,400.00,0.00,1174.55,57453.06,469820.00,412366.94,604365),('1','147','209405','326',322.00,400.00,0.00,372.25,119864.50,148900.00,29035.50,604721),('1','147','209441','326',322.00,400.00,0.00,2187.45,704358.90,874980.00,170621.10,604796),('1','147','209640','326',322.00,400.00,0.00,2390.83,769847.26,956332.00,186484.74,605315),('1','147','209855','326',322.00,400.00,0.00,34.00,10948.00,13600.00,2652.00,605877),('1','147','209932','326',322.00,400.00,0.00,1513.78,522254.10,635787.60,113533.50,606074),('1','147','210126','326',345.00,420.00,0.00,2060.96,711031.20,865603.20,154572.00,606567),('1','147','210359','326',345.00,420.00,0.00,1754.37,605257.65,736835.40,131577.75,607168),('1','147','210623','326',345.00,420.00,0.00,35.89,12382.05,15073.80,2691.75,607871),('1','147','210628','326',345.00,420.00,0.00,1251.36,431719.20,525571.20,93852.00,607884),('1','147','210774','326',345.00,420.00,0.00,1439.60,496662.00,604632.00,107970.00,608267),('1','147','211001','326',345.00,420.00,0.00,2099.26,724244.70,881689.20,157444.50,608841),('1','147','211252','326',345.00,420.00,0.00,601.78,207614.10,252747.60,45133.50,609499),('1','147','211305','326',345.00,420.00,0.00,1873.75,646443.75,786975.00,140531.25,609638),('1','147','211384','326',345.00,420.00,0.00,3407.46,1175573.70,1431133.20,255559.50,609840),('1','147','211650','326',345.00,420.00,0.00,310.79,107222.55,130531.80,23309.25,610532),('1','147','211679','326',345.00,420.00,0.00,745.42,257169.90,313076.40,55906.50,610598),('1','147','211783','326',345.00,420.00,0.00,2785.35,960945.75,1169847.00,208901.25,610861),('1','147','211983','326',345.00,420.00,0.00,1226.16,423025.20,514987.20,91962.00,611390),('1','147','212221','326',345.00,420.00,0.00,712.23,245719.35,299136.60,53417.25,612017),('1','147','212730','326',345.00,420.00,0.00,2577.16,889120.20,1082407.20,193287.00,613351),('1','147','212859','326',345.00,420.00,0.00,1040.68,359034.60,437085.60,78051.00,613694),('1','147','213250','326',345.00,420.00,0.00,1444.50,557577.00,606690.00,49113.00,614706),('1','147','213385','326',386.00,420.00,0.00,1958.64,756035.04,822628.80,66593.76,615059),('1','147','213851','326',386.00,420.00,0.00,2067.97,798236.42,868547.40,70310.98,616291),('1','147','213993','326',386.00,420.00,0.00,2373.84,916302.24,997012.80,80710.56,616653),('1','147','214094','326',386.00,420.00,0.00,3024.97,1167638.42,1270487.40,102848.98,616919),('1','147','214493','326',386.00,420.00,0.00,471.30,181921.80,197946.00,16024.20,617952),('1','147','214582','326',386.00,420.00,0.00,1535.20,592587.20,644784.00,52196.80,618170),('1','147','214776','326',386.00,420.00,0.00,2133.81,823650.66,896200.20,72549.54,618684),('1','147','214994','326',386.00,420.00,0.00,1170.40,451774.40,491568.00,39793.60,619259),('1','147','215188','326',386.00,420.00,0.00,614.04,237019.44,257896.80,20877.36,619760),('1','147','215214','326',0.00,448.00,0.00,1818.80,0.00,814822.40,814822.40,619825),('1','147','215442','326',0.00,448.00,0.00,1619.53,34033.62,725549.44,691515.82,620403),('1','147','215747','326',386.00,448.00,0.00,2741.23,1058114.78,1228071.04,169956.26,621191),('1','147','215950','326',386.00,448.00,0.00,2340.77,903537.22,1048664.96,145127.74,621706),('1','147','216214','326',386.00,448.00,0.00,1708.58,659511.88,765443.84,105931.96,622396),('1','147','216364','326',0.00,452.00,0.00,1720.49,0.00,777661.48,777661.48,622779),('1','147','216546','326',0.00,452.00,0.00,1634.93,202314.18,738988.36,536674.18,623283),('1','147','216936','326',386.00,452.00,0.00,686.14,264850.04,310135.28,45285.24,624305),('1','147','217095','326',0.00,480.00,0.00,1873.33,0.00,899198.40,899198.40,624710),('1','147','217281','326',0.00,480.00,0.00,2371.53,450786.24,1138334.40,687548.16,625200),('1','147','217541','326',432.00,480.00,0.00,2434.41,1051665.12,1168516.80,116851.68,625870),('1','147','217706','326',432.00,480.00,0.00,1651.83,713590.56,792878.40,79287.84,626314),('1','147','217987','326',432.00,480.00,0.00,1357.76,586552.32,651724.80,65172.48,627052),('1','147','218212','326',432.00,480.00,0.00,2139.10,924091.20,1026768.00,102676.80,627649),('1','147','218436','326',432.00,480.00,0.00,1644.20,710294.40,789216.00,78921.60,628239),('1','147','218726','326',432.00,480.00,0.00,1586.70,685454.40,761616.00,76161.60,628972),('1','147','218903','326',432.00,480.00,0.00,2550.52,1101824.64,1224249.60,122424.96,629456),('1','147','219116','326',432.00,480.00,0.00,2399.64,1036644.48,1151827.20,115182.72,630001),('1','147','219355','326',432.00,480.00,0.00,773.84,334298.88,371443.20,37144.32,630621),('1','147','219535','326',432.00,480.00,0.00,777.91,336057.12,373396.80,37339.68,631111),('1','147','219614','326',432.00,480.00,0.00,2004.58,865978.56,962198.40,96219.84,631298),('1','147','219814','326',432.00,480.00,0.00,1720.20,743126.40,825696.00,82569.60,631830),('1','147','220038','326',432.00,480.00,0.00,739.31,319381.92,354868.80,35486.88,632436),('1','147','220184','326',432.00,480.00,0.00,1141.87,493287.84,548097.60,54809.76,632830),('1','147','220278','326',432.00,480.00,0.00,2304.63,995600.16,1106222.40,110622.24,633050),('1','147','220462','326',432.00,480.00,0.00,1865.50,805896.00,895440.00,89544.00,633553),('1','147','220681','326',432.00,480.00,0.00,3123.06,1349161.92,1499068.80,149906.88,634119),('1','147','220903','326',432.00,480.00,0.00,1913.74,826735.68,918595.20,91859.52,634700),('1','147','221135','326',432.00,480.00,0.00,49.20,21254.40,23616.00,2361.60,635297),('1','147','221234','326',431.00,480.00,0.00,1755.21,756495.51,842500.80,86005.29,635552),('1','147','221423','326',431.00,480.00,0.00,2406.77,1037317.87,1155249.60,117931.73,636040),('1','147','221609','326',431.00,480.00,0.00,1107.53,477345.43,531614.40,54268.97,636539),('1','147','221734','326',431.00,480.00,0.00,1295.97,558563.07,622065.60,63502.53,636864),('1','147','221822','326',431.00,480.00,0.00,2229.18,960776.58,1070006.40,109229.82,637096),('1','147','222054','326',431.00,480.00,0.00,1646.34,709572.54,790243.20,80670.66,637699),('1','147','222270','326',436.00,480.00,0.00,3343.98,1457975.28,1605110.40,147135.12,638241),('1','147','222495','326',436.00,480.00,0.00,1091.02,499244.08,523689.60,24445.52,638817),('1','147','222713','326',480.00,480.00,0.00,632.54,275787.44,303619.20,27831.76,639412),('1','147','223134','326',436.00,480.00,0.00,1979.15,862909.40,949992.00,87082.60,640533),('1','147','223135','326',436.00,480.00,0.00,1907.17,831526.12,915441.60,83915.48,640534),('1','147','223172','326',436.00,480.00,0.00,799.83,348725.88,383918.40,35192.52,640615),('1','147','223460','326',436.00,480.00,0.00,551.24,217773.28,266251.52,48478.24,641310),('1','147','223514','326',0.00,512.00,0.00,933.76,122755.80,478085.12,355329.32,641451),('1','147','223639','326',456.00,512.00,0.00,1507.67,687497.52,771927.04,84429.52,641776),('1','147','223882','326',456.00,512.00,0.00,2038.78,934338.78,1043855.36,109516.58,642396),('1','147','224055','326',459.00,512.00,0.00,124.33,57067.47,63656.96,6589.49,642862),('1','147','224079','326',459.00,512.00,0.00,1604.32,736382.88,821411.84,85028.96,642915),('1','147','224301','326',459.00,512.00,0.00,1740.61,798939.99,891192.32,92252.33,643494),('1','147','224524','326',459.00,512.00,0.00,914.34,419682.06,468142.08,48460.02,644086),('1','147','224768','326',459.00,512.00,0.00,1641.72,753549.48,840560.64,87011.16,644710),('1','147','225015','326',459.00,512.00,0.00,721.13,330998.67,369506.56,38507.89,645332),('1','147','225165','326',459.00,512.00,0.00,826.61,379413.99,423224.32,43810.33,645728),('1','147','225260','326',459.00,512.00,0.00,2333.43,1071044.37,1194716.16,123671.79,645973),('1','147','225477','326',459.00,512.00,0.00,1997.08,916659.72,1022504.96,105845.24,646531),('1','147','225687','326',459.00,512.00,0.00,565.26,265704.90,289413.12,23708.22,647075),('1','147','225804','326',0.00,544.00,0.00,1191.69,0.00,648279.36,648279.36,647378),('1','147','225963','326',0.00,544.00,0.00,1700.69,0.00,925175.36,925175.36,647799),('1','147','226247','326',0.00,544.00,0.00,1613.71,0.00,877858.24,877858.24,648530),('1','147','226472','326',0.00,544.00,0.00,156.37,0.00,85065.28,85065.28,649107),('1','147','226529','326',0.00,544.00,0.00,1577.64,558576.25,858236.16,299659.91,649239),('1','147','226723','326',475.00,544.00,0.00,2148.88,1020718.00,1168990.72,148272.72,649758),('1','147','226957','326',475.00,544.00,0.00,1489.86,707683.50,810483.84,102800.34,650371),('1','147','227111','326',475.00,544.00,0.00,844.05,400923.75,459163.20,58239.45,650770),('1','147','227183','326',475.00,544.00,0.00,2633.36,1271454.83,1432547.84,161093.01,650953),('1','147','227368','326',484.00,544.00,0.00,1727.61,836163.24,939819.84,103656.60,651422),('1','147','227604','326',384.00,544.00,0.00,2083.10,799910.40,1133206.40,333296.00,652035),('1','147','227846','326',384.00,544.00,0.00,401.55,154195.20,218443.20,64248.00,652664),('1','147','227913','326',384.00,544.00,0.00,1592.88,611665.92,866526.72,254860.80,652829),('1','147','228112','326',484.00,544.00,0.00,2332.30,1128833.20,1268771.20,139938.00,653372),('1','147','228345','326',484.00,544.00,0.00,181.78,68819.96,99521.76,30701.80,653973),('1','147','228375','326',0.00,560.00,0.00,2426.63,0.00,1358912.80,1358912.80,654037),('1','147','228528','326',484.00,560.00,0.00,2433.65,1177886.60,1362844.00,184957.40,654437),('1','147','228749','326',484.00,560.00,0.00,3150.26,1524725.84,1764145.60,239419.76,655003),('1','147','228937','326',484.00,560.00,0.00,2016.90,976179.60,1129464.00,153284.40,655479),('1','147','229166','326',560.00,560.00,0.00,2010.33,1125784.80,1125784.80,0.00,656089),('1','147','229407','326',0.00,584.00,0.00,2047.71,0.00,1195862.64,1195862.64,656709),('1','147','229655','326',0.00,584.00,0.00,2189.23,782125.18,1278510.32,496385.14,657341),('1','147','229884','326',526.00,584.00,0.00,566.36,297905.36,330754.24,32848.88,657922),('1','147','229941','326',526.00,584.00,0.00,1381.33,726579.58,806696.72,80117.14,658070),('1','147','230087','326',526.00,584.00,0.00,2449.10,1288226.60,1430274.40,142047.80,658447),('1','147','230287','326',526.00,584.00,0.00,2759.20,1451339.20,1611372.80,160033.60,658956),('1','147','230519','326',526.00,584.00,0.00,1814.26,954300.76,1059527.84,105227.08,659567),('1','147','230791','326',526.00,584.00,0.00,1574.98,828439.48,919788.32,91348.84,660264),('1','147','231057','326',526.00,584.00,0.00,1668.31,877531.06,974293.04,96761.98,660983),('1','147','231377','326',526.00,584.00,0.00,1595.46,839211.96,931748.64,92536.68,661831),('1','147','231637','326',526.00,584.00,0.00,1495.43,786596.18,873331.12,86734.94,662512),('1','147','232110','326',526.00,584.00,0.00,2736.71,1439509.46,1598238.64,158729.18,663781),('1','147','232333','326',526.00,584.00,0.00,1020.83,536956.58,596164.72,59208.14,664355),('1','147','232585','326',0.00,600.00,0.00,1566.57,0.00,939942.00,939942.00,665032),('1','147','232845','326',0.00,600.00,0.00,1922.91,919584.12,1153746.00,234161.88,665719),('1','147','233117','326',546.00,600.00,0.00,1723.19,940861.74,1033914.00,93052.26,666418),('1','147','233369','326',0.00,624.00,0.00,1649.69,0.00,1029406.56,1029406.56,667088),('1','147','233604','326',0.00,624.00,0.00,2335.96,1087252.20,1457639.04,370386.84,667703),('1','147','233842','326',570.00,624.00,0.00,2505.82,1428317.40,1563631.68,135314.28,668324),('1','147','234059','326',570.00,624.00,0.00,1514.33,863168.10,944941.92,81773.82,668896),('1','147','234318','326',570.00,624.00,0.00,1942.99,1107504.30,1212425.76,104921.46,669580),('1','147','234554','326',570.00,624.00,0.00,1636.04,932542.80,1020888.96,88346.16,670216),('1','147','234817','326',570.00,624.00,0.00,1777.09,1012941.30,1108904.16,95962.86,670910),('1','147','235057','326',570.00,624.00,0.00,1570.95,895441.50,980272.80,84831.30,671569),('1','147','235309','326',570.00,624.00,0.00,2494.01,1421585.70,1556262.24,134676.54,672210),('1','147','235516','326',570.00,624.00,0.00,2780.91,1585118.70,1735287.84,150169.14,672744),('1','147','235745','326',570.00,624.00,0.00,1914.99,3425.70,1225497.44,1222071.74,673338),('1','147','236009','326',0.00,640.00,0.00,1510.98,0.00,967027.20,967027.20,674030),('1','147','236269','326',0.00,640.00,0.00,1747.31,829232.16,1118278.40,289046.24,674704),('1','147','236501','326',592.00,640.00,0.00,2139.90,1266820.80,1369536.00,102715.20,675337),('1','147','236718','326',592.00,640.00,0.00,1472.21,871548.32,942214.40,70666.08,675901),('1','147','236894','326',592.00,640.00,0.00,270.95,160402.40,173408.00,13005.60,676354),('1','147','236951','326',592.00,640.00,0.00,2956.15,1750040.80,1891936.00,141895.20,676496),('1','147','237175','326',592.00,640.00,0.00,2261.80,1338985.60,1447552.00,108566.40,677061),('1','147','237375','326',592.00,640.00,0.00,1961.49,1161202.08,1255353.60,94151.52,677582),('1','147','237597','326',0.00,656.00,0.00,1996.71,0.00,1309841.76,1309841.76,678166),('1','147','237879','326',0.00,640.00,0.00,1337.33,0.00,855891.20,855891.20,678893),('1','147','238045','326',0.00,640.00,0.00,503.21,87917.92,322054.40,234136.48,679330),('1','147','238163','326',592.00,640.00,0.00,1718.47,1017334.24,1099820.80,82486.56,679621),('1','147','238355','326',592.00,640.00,0.00,1881.49,1113842.08,1204153.60,90311.52,680116),('1','147','238590','326',592.00,640.00,0.00,1343.46,795328.32,859814.40,64486.08,680754),('1','147','238713','326',592.00,640.00,0.00,1257.54,744463.68,804825.60,60361.92,681051),('1','147','238822','326',592.00,640.00,0.00,2056.12,1217223.04,1315916.80,98693.76,681341),('1','147','239058','326',592.00,640.00,0.00,1584.56,938059.52,1014118.40,76058.88,681947),('1','147','239278','326',592.00,640.00,0.00,556.20,329270.40,355968.00,26697.60,682530),('1','147','239542','326',592.00,640.00,0.00,1756.53,1039865.76,1124179.20,84313.44,683202),('1','147','239771','326',592.00,640.00,0.00,1700.61,1006761.12,1088390.40,81629.28,683807),('1','147','239986','326',592.00,640.00,0.00,1590.18,941386.56,1017715.20,76328.64,684372),('1','147','240187','326',592.00,640.00,0.00,502.79,297651.68,321785.60,24133.92,684890),('1','147','240256','326',592.00,640.00,0.00,1875.49,1200313.60,1200313.60,0.00,685052),('1','147','240443','326',640.00,640.00,0.00,2121.39,1313216.64,1357689.60,44472.96,685556),('1','147','240686','326',592.00,640.00,0.00,1422.23,841960.16,910227.20,68267.04,686144),('1','147','240972','326',592.00,640.00,0.00,1818.45,1076522.40,1163808.00,87285.60,686908),('1','147','241216','326',592.00,640.00,0.00,1926.64,1140570.88,1233049.60,92478.72,687551),('1','147','241481','326',592.00,640.00,0.00,545.93,323190.56,349395.20,26204.64,688254),('1','147','241600','326',592.00,640.00,0.00,1088.32,644285.44,696524.80,52239.36,688556),('1','147','241719','326',592.00,640.00,0.00,2239.87,1326003.04,1433516.80,107513.76,688882),('1','147','241965','326',592.00,640.00,0.00,2083.77,1233591.84,1333612.80,100020.96,689526),('1','147','242192','326',592.00,640.00,0.00,2736.11,1619777.12,1751110.40,131333.28,690115),('1','147','242418','326',592.00,640.00,0.00,1750.84,1036497.28,1120537.60,84040.32,690695),('1','147','242667','326',592.00,640.00,0.00,501.77,297047.84,321132.80,24084.96,691342),('1','147','242763','326',592.00,640.00,0.00,1665.33,985875.36,1065811.20,79935.84,691577),('1','147','242906','326',0.00,640.00,0.00,1786.89,0.00,1143609.60,1143609.60,691973),('1','147','243127','326',0.00,640.00,0.00,1714.51,10354.08,1097286.40,1086932.32,692551),('1','147','243382','326',592.00,640.00,0.00,1993.75,1180300.00,1276000.00,95700.00,693207),('1','147','243593','326',592.00,640.00,0.00,2516.35,1489679.20,1610464.00,120784.80,693755),('1','147','243819','326',592.00,640.00,0.00,1225.67,725596.64,784428.80,58832.16,694348),('1','147','243924','326',592.00,640.00,0.00,1143.99,677242.08,732153.60,54911.52,694600),('1','147','244036','326',592.00,640.00,0.00,2139.85,1266791.20,1369504.00,102712.80,694902),('1','147','244314','326',592.00,640.00,0.00,1654.12,979239.04,1058636.80,79397.76,695614),('1','147','244512','326',592.00,640.00,0.00,429.85,254471.20,275104.00,20632.80,696136),('1','147','244583','326',592.00,640.00,0.00,859.37,508747.04,549996.80,41249.76,696307),('1','147','244728','326',592.00,640.00,0.00,2425.49,1435890.08,1552313.60,116423.52,696713),('1','147','244966','326',0.00,632.00,0.00,1759.53,0.00,1112022.96,1112022.96,697324),('1','147','245213','326',572.00,632.00,0.00,3103.55,1775230.60,1961443.60,186213.00,697958),('1','147','245426','326',572.00,632.00,0.00,2081.30,1190503.60,1315381.60,124878.00,698511),('1','147','245598','326',572.00,632.00,0.00,331.06,189366.32,209229.92,19863.60,698956),('1','147','245665','326',572.00,632.00,0.00,1776.05,1015900.60,1122463.60,106563.00,699130),('1','147','245926','326',0.00,616.00,0.00,2144.41,689431.60,1320956.56,631524.96,699811),('1','147','246181','326',572.00,616.00,0.00,1194.87,683465.64,736039.92,52574.28,700463),('1','147','246346','326',572.00,616.00,0.00,1152.56,643942.16,709976.96,66034.80,700905),('1','147','246443','326',558.00,616.00,0.00,2445.72,1364711.76,1506563.52,141851.76,701161),('1','147','246688','326',558.00,616.00,0.00,1506.86,840827.88,928225.76,87397.88,701809),('1','147','246860','326',558.00,616.00,0.00,493.17,275188.86,303792.72,28603.86,702242),('1','147','246921','326',558.00,616.00,0.00,2844.82,1587409.56,1752409.12,164999.56,702405),('1','147','247159','326',558.00,616.00,0.00,1830.50,1021419.00,1127588.00,106169.00,703020),('1','147','247301','326',558.00,616.00,0.00,822.18,458776.44,506462.88,47686.44,703370),('1','147','247385','326',558.00,616.00,0.00,2300.30,1283567.40,1416984.80,133417.40,703590),('1','147','247657','326',558.00,616.00,0.00,1294.71,722448.18,797541.36,75093.18,704308),('1','147','247759','326',0.00,592.00,0.00,929.10,0.00,550541.52,550541.52,704538),('1','147','247931','326',558.00,592.00,0.00,2544.69,1419937.02,1506456.48,86519.46,704993),('1','147','248144','326',558.00,592.00,0.00,2752.20,1535727.60,1629302.40,93574.80,705564),('1','147','248388','326',558.00,592.00,0.00,136.04,75910.32,80535.68,4625.36,706195),('1','147','248422','326',558.00,592.00,0.00,3691.97,2060119.26,2185646.24,125526.98,706262),('1','147','248629','326',558.00,592.00,0.00,1732.29,966617.82,1025515.68,58897.86,706812),('1','147','248733','326',558.00,592.00,0.00,1238.45,691055.10,733162.40,42107.30,707059),('1','147','248894','326',558.00,592.00,0.00,2220.73,1239167.34,1314672.16,75504.82,707478),('1','147','249096','326',558.00,592.00,0.00,1862.36,1039196.88,1102517.12,63320.24,708015),('1','147','249387','326',510.00,592.00,0.00,985.46,502584.60,583392.32,80807.72,708721),('1','147','249724','326',510.00,592.00,0.00,758.21,386687.10,448860.32,62173.22,709611),('1','147','249840','326',510.00,592.00,0.00,2258.00,1151580.00,1336736.00,185156.00,709913),('1','147','250106','326',510.00,592.00,0.00,1492.99,761424.90,883850.08,122425.18,710579),('1','147','250490','326',510.00,592.00,0.00,453.82,226910.00,268661.44,41751.44,711562),('1','147','250558','326',500.00,592.00,0.00,1747.59,873795.00,1034573.28,160778.28,711737),('1','147','250790','326',500.00,592.00,0.00,1944.48,972240.00,1151132.16,178892.16,712346),('1','147','251017','326',500.00,592.00,0.00,1659.91,829955.00,982666.72,152711.72,712930),('1','147','251336','326',500.00,592.00,0.00,1588.71,810242.10,940516.32,130274.22,713747),('1','147','251509','326',510.00,592.00,0.00,1935.91,987314.10,1146058.72,158744.62,714216),('1','147','251758','326',510.00,592.00,0.00,2117.68,1080016.80,1253666.56,173649.76,714868),('1','147','251987','326',510.00,592.00,0.00,175.84,89678.40,104097.28,14418.88,715473),('1','147','252044','326',510.00,592.00,0.00,1843.53,940200.30,1091369.76,151169.46,715593),('1','147','252234','326',510.00,592.00,0.00,2742.36,1398603.60,1623477.12,224873.52,716115),('1','147','252465','326',510.00,592.00,0.00,508.67,259421.70,301132.64,41710.94,716715),('1','147','252577','326',510.00,592.00,0.00,1628.88,830728.80,964296.96,133568.16,716984),('1','147','252709','326',510.00,592.00,0.00,1242.41,633629.10,735506.72,101877.62,717343),('1','147','253040','326',510.00,592.00,0.00,2039.47,1040129.70,1207366.24,167236.54,718175),('1','147','253201','326',510.00,592.00,0.00,2106.26,1074192.60,1246905.92,172713.32,718634),('1','147','253470','326',510.00,592.00,0.00,667.11,340226.10,394929.12,54703.02,719326),('1','147','253578','326',510.00,592.00,0.00,1314.50,670395.00,778184.00,107789.00,719591),('1','147','253710','326',510.00,592.00,0.00,2556.58,1303855.80,1513495.36,209639.56,719944),('1','147','253954','326',510.00,592.00,0.00,895.03,456465.30,529857.76,73392.46,720576),('1','147','254103','326',510.00,592.00,0.00,758.13,386646.30,448812.96,62166.66,720963),('1','147','254188','326',510.00,592.00,0.00,1411.49,719859.90,835602.08,115742.18,721192),('1','147','254513','326',510.00,592.00,0.00,2042.12,1041481.20,1208935.04,167453.84,722005),('1','147','254694','326',510.00,592.00,0.00,2082.47,1062059.70,1232822.24,170762.54,722478),('1','147','254945','326',510.00,592.00,0.00,912.69,465471.90,540312.48,74840.58,723116),('1','147','255066','326',510.00,592.00,0.00,945.97,482444.70,560014.24,77569.54,723418),('1','147','255193','326',510.00,592.00,0.00,2004.21,1022147.10,1186492.32,164345.22,723758),('1','147','255498','326',510.00,592.00,0.00,1928.19,983376.90,1141488.48,158111.58,724493),('1','147','255718','326',510.00,592.00,0.00,3047.56,1554255.60,1804155.52,249899.92,725055),('1','147','255940','326',510.00,592.00,0.00,1776.69,974607.32,1051800.48,77193.16,725628),('1','147','256260','326',592.00,592.00,0.00,2155.40,1275996.80,1275996.80,0.00,726390),('1','147','256475','326',592.00,592.00,0.00,2120.11,1255105.12,1255105.12,0.00,726990),('1','147','256729','326',592.00,592.00,0.00,883.73,523168.16,523168.16,0.00,727630),('1','147','256867','326',592.00,592.00,0.00,925.85,548103.20,548103.20,0.00,727994),('1','147','256947','326',592.00,592.00,0.00,1677.33,992979.36,992979.36,0.00,728220),('1','147','257284','326',592.00,592.00,0.00,2573.67,1523612.64,1523612.64,0.00,729073),('1','147','257500','326',592.00,592.00,0.00,2960.41,1609294.78,1710630.64,101335.86,729644),('1','147','257501','326',510.00,568.00,0.00,2254.43,1149759.30,1280516.24,130756.94,729645),('1','147','257502','326',510.00,568.00,0.00,2735.16,1385736.00,1553570.88,167834.88,729646),('1','147','257503','326',500.00,568.00,0.00,2324.23,1162115.00,1320162.64,158047.64,729647),('1','147','257504','326',500.00,568.00,0.00,2418.44,1209220.00,1373673.92,164453.92,729648),('1','147','257505','326',500.00,568.00,0.00,2395.56,1197780.00,1360678.08,162898.08,729649),('1','147','257506','326',500.00,568.00,0.00,3300.66,1650330.00,1874774.88,224444.88,729650),('1','147','257507','326',500.00,568.00,0.00,2215.22,1107610.00,1258244.96,150634.96,729651),('1','147','257508','326',500.00,568.00,0.00,2457.69,1228845.00,1395967.92,167122.92,729652),('1','147','257509','326',500.00,568.00,0.00,1946.35,973175.00,1105526.80,132351.80,729653),('1','147','257510','326',500.00,568.00,0.00,726.43,363215.00,412612.24,49397.24,729654),('1','147','257511','326',500.00,568.00,0.00,1221.91,610955.00,694044.88,83089.88,729655),('1','147','257512','326',500.00,568.00,0.00,2151.08,1189565.12,1221813.44,32248.32,729656),('1','147','257513','326',568.00,568.00,0.00,1044.82,593457.76,593457.76,0.00,729657),('1','147','257514','326',568.00,568.00,0.00,1260.01,715685.68,715685.68,0.00,729658),('1','147','257515','326',568.00,568.00,0.00,2954.11,1489200.48,1677934.48,188734.00,729659),('1','147','257516','326',500.00,568.00,0.00,887.29,443645.00,503980.72,60335.72,729660),('1','147','257517','326',500.00,568.00,0.00,962.58,481290.00,546745.44,65455.44,729661),('1','147','257518','326',500.00,568.00,0.00,1640.07,820035.00,931559.76,111524.76,729662),('1','147','257519','326',500.00,568.00,0.00,1946.75,973375.00,1105754.00,132379.00,729663),('1','147','257520','326',500.00,568.00,0.00,701.79,350895.00,398616.72,47721.72,729664),('1','147','257521','326',500.00,568.00,0.00,956.55,478275.00,543320.40,65045.40,729665),('1','147','257522','326',500.00,568.00,0.00,1918.50,1054889.96,1089708.00,34818.04,729666),('1','147','257523','326',568.00,568.00,0.00,1959.63,1071604.80,1113069.84,41465.04,729667),('1','147','257524','326',500.00,568.00,0.00,329.40,164700.00,187099.20,22399.20,729668),('1','147','257525','326',500.00,568.00,0.00,1619.45,809725.00,919847.60,110122.60,729669),('1','147','257526','326',500.00,568.00,0.00,2506.27,1253135.00,1423561.36,170426.36,729670),('1','147','257527','326',500.00,568.00,0.00,1053.39,526695.00,598325.52,71630.52,729671),('1','147','257528','326',500.00,568.00,0.00,2203.81,1101905.00,1251764.08,149859.08,729672),('1','147','257529','326',500.00,568.00,0.00,1865.56,932780.00,1059638.08,126858.08,729673),('1','147','257530','326',500.00,568.00,0.00,823.57,411785.00,467787.76,56002.76,729674),('1','147','257531','326',500.00,568.00,0.00,551.89,275945.00,313473.52,37528.52,729675),('1','147','257532','326',500.00,568.00,0.00,1949.16,974580.00,1107122.88,132542.88,729676),('1','147','257533','326',500.00,568.00,0.00,416.51,208255.00,236577.68,28322.68,729677),('1','147','257534','326',500.00,568.00,0.00,1499.75,749875.00,851858.00,101983.00,729678),('1','147','257535','326',500.00,568.00,0.00,916.44,458220.00,520537.92,62317.92,729679),('1','147','257536','326',500.00,568.00,0.00,1751.70,875850.00,994965.60,119115.60,729680),('1','147','257537','326',500.00,568.00,0.00,1557.44,778720.00,884625.92,105905.92,729681),('1','147','257538','326',500.00,568.00,0.00,164.38,82190.00,93367.84,11177.84,729682),('1','147','257539','326',500.00,568.00,0.00,1418.74,709370.00,805844.32,96474.32,729683),('1','147','257540','326',500.00,568.00,0.00,1671.91,835955.00,949644.88,113689.88,729684),('1','147','257541','326',580.00,580.00,0.00,1516.25,879425.00,879425.00,0.00,729685),('1','147','257542','326',580.00,580.00,0.00,294.71,170931.80,170931.80,0.00,729686),('1','147','257543','326',580.00,580.00,0.00,1220.43,707849.40,707849.40,0.00,729687),('1','147','257544','326',580.00,580.00,0.00,820.98,476168.40,476168.40,0.00,729688),('1','147','257545','326',580.00,580.00,0.00,2792.04,1619383.20,1619383.20,0.00,729689),('1','147','257546','326',580.00,580.00,0.00,1746.92,1013213.60,1013213.60,0.00,729690),('1','147','257547','326',580.00,580.00,0.00,2188.96,1269596.80,1269596.80,0.00,729691),('1','147','257548','326',580.00,580.00,0.00,63.97,37102.60,37102.60,0.00,729692),('1','147','257549','326',580.00,580.00,0.00,1741.25,0.00,1114400.00,1114400.00,729693),('1','147','257550','326',0.00,640.00,0.00,437.50,0.00,280000.00,280000.00,729694),('1','147','257551','326',0.00,640.00,0.00,1296.58,462323.34,829811.20,367487.86,729695),('1','147','257552','326',582.00,640.00,0.00,1849.29,1076286.78,1183545.60,107258.82,729696),('1','147','257553','326',582.00,640.00,0.00,1882.65,1095702.30,1204896.00,109193.70,729697),('1','147','257554','326',582.00,640.00,0.00,2988.57,1739347.74,1912684.80,173337.06,729698),('1','147','257555','326',582.00,640.00,0.00,1187.73,691258.86,760147.20,68888.34,729699),('1','147','257556','326',582.00,640.00,0.00,719.70,418865.40,460608.00,41742.60,729700),('1','147','257557','326',582.00,640.00,0.00,1735.53,0.00,1180160.40,1180160.40,729701),('1','147','257558','326',0.00,680.00,0.00,1794.11,0.00,1219994.80,1219994.80,729702),('1','147','257559','326',0.00,680.00,0.00,771.66,0.00,524728.80,524728.80,729703),('1','147','257560','326',0.00,680.00,0.00,765.66,0.00,520648.80,520648.80,729704),('1','147','257561','326',0.00,680.00,0.00,1551.39,0.00,1054945.20,1054945.20,729705),('1','147','257562','326',0.00,680.00,0.00,2507.20,0.00,1704896.00,1704896.00,729706),('1','147','257563','326',0.00,680.00,0.00,133.13,0.00,90528.40,90528.40,729707),('1','147','257564','326',0.00,680.00,0.00,1857.15,0.00,1262862.00,1262862.00,729708),('1','147','257565','326',0.00,680.00,0.00,1682.06,0.00,1143800.80,1143800.80,729709),('1','147','257566','326',0.00,680.00,0.00,1426.47,0.00,969999.60,969999.60,729710),('1','147','257567','326',0.00,680.00,0.00,287.68,22401.08,195622.40,173221.32,729711),('1','147','257568','326',598.00,680.00,0.00,1199.98,717588.04,815986.40,98398.36,729712),('1','147','257569','326',598.00,680.00,0.00,1478.90,884382.20,1005652.00,121269.80,729713),('1','147','257570','326',598.00,680.00,0.00,1821.15,1089047.70,1238382.00,149334.30,729714),('1','147','257571','326',598.00,680.00,0.00,419.38,250789.24,285178.40,34389.16,729715),('1','147','257572','326',598.00,680.00,0.00,1811.42,1083229.16,1231765.60,148536.44,729716),('1','147','257573','326',598.00,680.00,0.00,474.73,298911.34,324151.76,25240.42,729717),('1','147','257574','326',688.00,688.00,0.00,2221.88,1528653.44,1528653.44,0.00,729718),('1','147','257575','326',688.00,688.00,0.00,682.51,442553.38,469566.88,27013.50,729719),('1','147','257576','326',598.00,688.00,0.00,996.38,595835.24,685509.44,89674.20,729720),('1','147','257577','326',598.00,688.00,0.00,2152.24,1287039.52,1480741.12,193701.60,729721),('1','147','257578','326',598.00,688.00,0.00,1963.99,1174466.02,1351225.12,176759.10,729722),('1','147','257579','326',598.00,688.00,0.00,2227.10,1331805.80,1478794.40,146988.60,729723),('1','147','257580','326',598.00,664.00,0.00,2374.38,1419879.24,1576588.32,156709.08,729724),('1','147','257581','326',598.00,664.00,0.00,280.55,168884.58,186285.20,17400.62,729725),('1','147','257582','326',617.00,664.00,0.00,2951.72,1821211.24,1959942.08,138730.84,729726),('1','147','257583','326',617.00,664.00,0.00,2120.19,1308157.23,1407806.16,99648.93,729727),('1','147','257584','326',617.00,664.00,0.00,1789.45,1104090.65,1188194.80,84104.15,729728),('1','147','257585','326',617.00,664.00,0.00,2343.61,1096902.60,1556157.04,459254.44,729729),('1','147','257586','326',0.00,664.00,0.00,965.61,337234.38,641165.04,303930.66,729730),('1','147','257587','326',602.00,664.00,0.00,616.11,370898.22,409097.04,38198.82,729731),('1','147','257588','326',602.00,664.00,0.00,2044.56,1230825.12,1357587.84,126762.72,729732),('1','147','257589','326',602.00,664.00,0.00,2130.85,1282771.70,1414884.40,132112.70,729733),('1','147','257590','326',602.00,664.00,0.00,659.89,397253.78,438166.96,40913.18,729734),('1','147','257591','326',602.00,664.00,0.00,2084.40,1254808.80,1384041.60,129232.80,729735),('1','147','257592','326',602.00,664.00,0.00,2603.76,1567463.52,1728896.64,161433.12,729736),('1','147','257593','326',602.00,664.00,0.00,578.34,348160.68,384017.76,35857.08,729737),('1','147','257594','326',602.00,664.00,0.00,2118.43,1275294.86,1406637.52,131342.66,729738),('1','147','257595','326',602.00,664.00,0.00,2197.82,1323087.64,1459352.48,136264.84,729739),('1','147','257596','326',602.00,664.00,0.00,553.41,333152.82,367464.24,34311.42,729740),('1','147','257597','326',602.00,664.00,0.00,1096.35,660002.70,727976.40,67973.70,729741),('1','147','257598','326',602.00,664.00,0.00,2770.22,1667672.44,1839426.08,171753.64,729742),('1','147','257599','326',602.00,664.00,0.00,1220.63,734819.26,810498.32,75679.06,729743),('1','147','257600','326',602.00,664.00,0.00,2591.09,1559836.18,1720483.76,160647.58,729744),('1','147','257601','326',602.00,664.00,0.00,1913.63,1152005.26,1270650.32,118645.06,729745),('1','147','257602','326',602.00,664.00,0.00,384.82,231661.64,255520.48,23858.84,729746),('1','147','257603','326',602.00,664.00,0.00,1064.40,630124.80,706761.60,76636.80,729747),('1','147','257604','326',592.00,664.00,0.00,2062.53,1221017.76,1369519.92,148502.16,729748),('1','147','257605','326',592.00,664.00,0.00,2488.65,1473280.80,1652463.60,179182.80,729749),('1','147','257606','326',592.00,664.00,0.00,1933.08,1144383.36,1283565.12,139181.76,729750),('1','147','257607','326',592.00,664.00,0.00,1666.31,986455.52,1106429.84,119974.32,729751),('1','147','257608','326',592.00,664.00,0.00,1417.00,838864.00,940888.00,102024.00,729752),('1','147','257609','326',592.00,664.00,0.00,1653.34,978777.28,1097817.76,119040.48,729753),('1','147','257610','326',592.00,664.00,0.00,2493.93,1476406.56,1655969.52,179562.96,729754),('1','147','257611','326',592.00,664.00,0.00,999.33,591603.36,663555.12,71951.76,729755),('1','147','257612','326',592.00,664.00,0.00,2246.98,1330212.16,1491994.72,161782.56,729756),('1','147','257613','326',592.00,664.00,0.00,2529.02,1497179.84,1679269.28,182089.44,729757),('1','147','257614','326',592.00,664.00,0.00,751.50,444888.00,498996.00,54108.00,729758),('1','147','257615','326',592.00,664.00,0.00,2018.58,1194999.36,1340337.12,145337.76,729759),('1','147','257616','326',592.00,664.00,0.00,699.13,413884.96,464222.32,50337.36,729760),('1','147','257617','326',592.00,664.00,0.00,359.39,212758.88,238634.96,25876.08,729761),('1','147','257618','326',592.00,664.00,0.00,1203.05,712205.60,798825.20,86619.60,729762),('1','147','257619','326',592.00,664.00,0.00,1965.03,1163297.76,1304779.92,141482.16,729763),('1','147','257620','326',592.00,664.00,0.00,2503.05,1481805.60,1662025.20,180219.60,729764),('1','147','257621','326',592.00,664.00,0.00,1423.05,842445.60,944905.20,102459.60,729765),('1','147','257622','326',592.00,664.00,0.00,2785.24,1648862.08,1849399.36,200537.28,729766),('1','147','257623','326',592.00,664.00,0.00,916.70,542686.40,608688.80,66002.40,729767),('1','147','257624','326',592.00,664.00,0.00,2150.91,1273338.72,1428204.24,154865.52,729768),('1','147','257625','326',592.00,664.00,0.00,1237.27,732463.84,821547.28,89083.44,729769),('1','147','257626','326',592.00,664.00,0.00,1430.79,847027.68,950044.56,103016.88,729770),('1','147','257627','326',680.00,680.00,0.00,3730.30,2536604.00,2536604.00,0.00,729771),('1','147','257628','326',680.00,680.00,0.00,34.76,23636.80,23636.80,0.00,729772),('1','147','257629','326',680.00,680.00,0.00,1883.53,1133885.06,1280800.40,146915.34,729773),('1','147','257630','326',602.00,680.00,0.00,1982.47,1193446.94,1348079.60,154632.66,729774),('1','147','257631','326',602.00,680.00,0.00,1977.09,1190208.18,1344421.20,154213.02,729775),('1','147','257632','326',602.00,680.00,0.00,708.09,426270.18,481501.20,55231.02,729776),('1','147','257633','326',602.00,680.00,0.00,3267.78,1967203.56,2222090.40,254886.84,729777),('1','147','257634','326',602.00,680.00,0.00,1699.19,1022912.38,1155449.20,132536.82,729778),('1','147','257635','326',602.00,680.00,0.00,186.86,112489.72,127064.80,14575.08,729779),('1','147','257636','326',602.00,680.00,0.00,909.70,547639.40,618596.00,70956.60,729780),('1','147','257637','326',602.00,680.00,0.00,2113.73,1355741.26,1437336.40,81595.14,729781),('1','147','257638','326',720.00,720.00,0.00,1071.81,771703.20,771703.20,0.00,729782),('1','147','257639','326',720.00,720.00,0.00,311.92,224582.40,224582.40,0.00,729783),('1','147','257640','326',720.00,720.00,0.00,1485.52,1069574.40,1069574.40,0.00,729784),('1','147','257641','326',720.00,720.00,0.00,2485.69,1789696.80,1789696.80,0.00,729785),('1','147','257642','326',720.00,720.00,0.00,1433.26,1031947.20,1031947.20,0.00,729786),('1','147','257643','326',720.00,720.00,0.00,2402.31,1729663.20,1729663.20,0.00,729787),('1','147','257644','326',760.00,760.00,0.00,1979.34,1504298.40,1504298.40,0.00,729788),('1','147','257645','326',760.00,760.00,0.00,3014.52,2291035.20,2291035.20,0.00,729789),('1','147','257646','326',760.00,760.00,0.00,1645.41,1250511.60,1250511.60,0.00,729790),('1','147','257647','326',760.00,760.00,0.00,2228.40,1693584.00,1693584.00,0.00,729791),('1','147','257648','326',760.00,760.00,0.00,2388.61,1815343.60,1815343.60,0.00,729792),('1','147','257649','326',760.00,760.00,0.00,433.29,329300.40,329300.40,0.00,729793),('1','147','257650','326',760.00,760.00,0.00,1383.70,976958.98,1051612.00,74653.02,729794),('1','147','257651','326',682.00,760.00,0.00,1969.08,1342912.56,1496500.80,153588.24,729795),('1','147','257652','326',682.00,760.00,0.00,1910.22,1302770.04,1451767.20,148997.16,729796),('1','147','257653','326',682.00,760.00,0.00,3189.58,2175293.56,2424080.80,248787.24,729797),('1','147','257654','326',682.00,760.00,0.00,2004.35,1366966.70,1523306.00,156339.30,729798),('1','147','257655','326',682.00,760.00,0.00,2399.14,1636213.48,1823346.40,187132.92,729799),('1','147','257656','326',682.00,760.00,0.00,2274.68,1551331.76,1728756.80,177425.04,729800),('1','147','257657','326',682.00,760.00,0.00,861.09,587263.38,654428.40,67165.02,729801),('1','147','257658','326',682.00,760.00,0.00,914.64,623784.48,695126.40,71341.92,729802),('1','147','257659','326',682.00,760.00,0.00,2245.49,1531424.18,1706572.40,175148.22,729803),('1','147','257660','326',682.00,760.00,0.00,1791.66,1221912.12,1361661.60,139749.48,729804),('1','147','257661','326',682.00,760.00,0.00,2591.00,1767062.00,1969160.00,202098.00,729805),('1','147','257662','326',682.00,760.00,0.00,2005.24,1367573.68,1523982.40,156408.72,729806),('1','147','257663','326',682.00,760.00,0.00,638.16,435225.12,485001.60,49776.48,729807),('1','147','257664','326',682.00,760.00,0.00,876.25,597602.50,665950.00,68347.50,729808),('1','147','257665','326',682.00,760.00,0.00,2175.21,1483493.22,1653159.60,169666.38,729809),('1','147','257666','326',682.00,760.00,0.00,1771.07,1207869.74,1346013.20,138143.46,729810),('1','147','257667','326',682.00,760.00,0.00,199.49,136052.18,151612.40,15560.22,729811),('1','147','257668','326',682.00,760.00,0.00,1330.14,907155.48,1010906.40,103750.92,729812),('1','147','257669','326',682.00,760.00,0.00,2687.19,1832663.58,2042264.40,209600.82,729813),('1','147','257670','326',682.00,760.00,0.00,1016.24,693075.68,772342.40,79266.72,729814),('1','147','257671','326',682.00,760.00,0.00,963.50,657107.00,732260.00,75153.00,729815),('1','147','257672','326',682.00,760.00,0.00,2200.33,1500625.06,1672250.80,171625.74,729816),('1','147','257673','326',682.00,760.00,0.00,1866.27,1272796.14,1418365.20,145569.06,729817),('1','147','257674','326',682.00,760.00,0.00,606.93,413926.26,461266.80,47340.54,729818),('1','147','257675','326',682.00,760.00,0.00,1222.31,833615.42,928955.60,95340.18,729819),('1','147','257676','326',682.00,760.00,0.00,2659.37,1813690.34,2021121.20,207430.86,729820),('1','147','257677','326',682.00,760.00,0.00,1542.19,1051773.58,1172064.40,120290.82,729821),('1','147','257678','326',682.00,760.00,0.00,615.90,420043.80,468084.00,48040.20,729822),('1','147','257679','326',682.00,760.00,0.00,3465.78,2363661.96,2633992.80,270330.84,729823),('1','147','257680','326',682.00,760.00,0.00,1099.64,749954.48,835726.40,85771.92,729824),('1','147','257681','326',682.00,760.00,0.00,1884.68,1285351.76,1432356.80,147005.04,729825),('1','147','257682','326',682.00,760.00,0.00,2218.88,1513276.16,1686348.80,173072.64,729826),('1','147','257683','326',682.00,760.00,0.00,884.83,603454.06,672470.80,69016.74,729827),('1','147','257684','326',682.00,760.00,0.00,1333.13,909194.66,1013178.80,103984.14,729828),('1','147','257685','326',682.00,760.00,0.00,2190.67,1494036.94,1664909.20,170872.26,729829),('1','147','257686','326',682.00,760.00,0.00,1577.07,1075561.74,1198573.20,123011.46,729830),('1','147','257687','326',682.00,760.00,0.00,2721.28,1855912.96,2068172.80,212259.84,729831),('1','147','257688','326',682.00,760.00,0.00,2254.22,1537378.04,1713207.20,175829.16,729832),('1','147','257689','326',682.00,760.00,0.00,1832.60,1249833.20,1392776.00,142942.80,729833),('1','147','257690','326',682.00,760.00,0.00,285.79,194908.78,217200.40,22291.62,729834),('1','147','257691','326',682.00,760.00,0.00,595.31,406001.42,452435.60,46434.18,729835),('1','147','257692','326',682.00,760.00,0.00,2095.18,1428912.76,1592336.80,163424.04,729836),('1','147','257693','326',682.00,760.00,0.00,1412.68,963447.76,1073636.80,110189.04,729837),('1','147','257694','326',682.00,760.00,0.00,2408.39,1642521.98,1830376.40,187854.42,729838),('1','147','257695','326',682.00,760.00,0.00,2430.61,1657676.02,1847263.60,189587.58,729839),('1','147','257696','326',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729840),('1','147','257697','326',682.00,760.00,0.00,306.83,209258.06,233190.80,23932.74,729841),('1','147','257698','326',682.00,760.00,0.00,396.68,270535.76,301476.80,30941.04,729842),('1','147','257699','326',682.00,760.00,0.00,2043.96,1393980.72,1553409.60,159428.88,729843),('1','147','257700','326',682.00,760.00,0.00,1930.26,1316437.32,1466997.60,150560.28,729844),('1','147','257701','326',682.00,760.00,0.00,1062.54,724652.28,807530.40,82878.12,729845),('1','147','257702','326',682.00,760.00,0.00,826.60,563741.20,628216.00,64474.80,729846),('1','147','257703','326',682.00,760.00,0.00,1772.65,1208947.30,1347214.00,138266.70,729847),('1','147','257704','326',744.00,744.00,0.00,2538.84,1888896.96,1888896.96,0.00,729848),('1','147','257705','326',744.00,744.00,0.00,2264.95,1685122.80,1685878.80,756.00,729849),('1','147','257706','326',744.00,744.00,0.00,1737.63,1292796.72,1292796.72,0.00,729850),('1','147','257707','326',744.00,744.00,0.00,1081.16,804383.04,804383.04,0.00,729851),('1','147','257708','326',744.00,744.00,0.00,0.00,0.00,0.00,0.00,729852),('1','147','257709','326',744.00,744.00,0.00,905.26,673513.44,673513.44,0.00,729853),('1','147','257710','326',744.00,744.00,0.00,1852.04,1377917.76,1377917.76,0.00,729854),('1','147','257711','326',744.00,744.00,0.00,2038.67,1476614.94,1516770.48,40155.54,729855),('1','147','257712','326',682.00,744.00,0.00,162.84,111056.88,121152.96,10096.08,729856),('1','147','257713','326',675.00,744.00,0.00,1699.13,1146912.75,1264152.72,117239.97,729857),('1','147','257714','326',675.00,744.00,0.00,2875.03,1940645.25,2139022.32,198377.07,729858),('1','147','257715','326',675.00,744.00,0.00,689.12,465156.00,512705.28,47549.28,729859),('1','147','257716','326',675.00,744.00,0.00,2023.21,1365666.75,1505268.24,139601.49,729860),('1','147','257717','326',675.00,744.00,0.00,2078.22,1402798.50,1546195.68,143397.18,729861),('1','147','257718','326',675.00,744.00,0.00,953.66,643720.50,709523.04,65802.54,729862),('1','147','257719','326',675.00,744.00,0.00,1171.42,790708.50,871536.48,80827.98,729863),('1','147','257720','326',675.00,744.00,0.00,2398.90,1619257.50,1784781.60,165524.10,729864),('1','147','257721','326',675.00,744.00,0.00,1645.88,1110969.00,1224534.72,113565.72,729865),('1','147','257722','326',675.00,744.00,0.00,891.49,601755.75,663268.56,61512.81,729866),('1','147','257723','326',675.00,744.00,0.00,2595.99,1752293.25,1931416.56,179123.31,729867),('1','147','257724','326',675.00,744.00,0.00,1759.64,1187757.00,1309172.16,121415.16,729868),('1','147','257725','326',675.00,744.00,0.00,560.86,378580.50,417279.84,38699.34,729869),('1','147','257726','326',675.00,744.00,0.00,2670.23,1802405.25,1986651.12,184245.87,729870),('1','147','257727','326',0.00,760.00,0.00,1065.15,51435.00,809514.00,758079.00,729871),('1','147','257728','326',675.00,760.00,0.00,965.60,651780.00,733856.00,82076.00,729872),('1','147','257729','326',675.00,760.00,0.00,1381.18,932296.50,1049696.80,117400.30,729873),('1','147','257730','326',675.00,760.00,0.00,315.65,213063.75,239894.00,26830.25,729874),('1','147','257731','326',675.00,760.00,0.00,1958.65,1322088.75,1488574.00,166485.25,729875),('1','147','257732','326',675.00,760.00,0.00,1709.90,1154182.50,1299524.00,145341.50,729876),('1','147','257733','326',675.00,760.00,0.00,1208.76,815913.00,918657.60,102744.60,729877),('1','147','257734','326',675.00,760.00,0.00,554.62,374368.50,421511.20,47142.70,729878),('1','147','257735','326',675.00,760.00,0.00,2770.17,1869864.75,2105329.20,235464.45,729879),('1','147','257736','326',675.00,760.00,0.00,1765.96,1192023.00,1342129.60,150106.60,729880),('1','147','257737','326',675.00,760.00,0.00,272.32,183816.00,206963.20,23147.20,729881),('1','147','257738','326',675.00,760.00,0.00,2095.63,1414550.25,1592678.80,178128.55,729882),('1','147','257739','326',0.00,744.00,0.00,2308.79,0.00,1717739.76,1717739.76,729883),('1','147','257740','326',0.00,744.00,0.00,237.92,0.00,177012.48,177012.48,729884),('1','147','257741','326',0.00,744.00,0.00,1375.52,928476.00,1023386.88,94910.88,729885),('1','147','257742','326',675.00,744.00,0.00,774.91,523064.25,576533.04,53468.79,729886),('1','147','257743','326',675.00,744.00,0.00,2019.50,1363162.50,1502508.00,139345.50,729887),('1','147','257744','326',675.00,744.00,0.00,1054.00,711450.00,784176.00,72726.00,729888),('1','147','257745','326',675.00,744.00,0.00,1291.94,872059.50,961203.36,89143.86,729889),('1','147','257746','326',675.00,744.00,0.00,2423.10,1635592.50,1802786.40,167193.90,729890),('1','147','257747','326',675.00,744.00,0.00,1424.87,961787.25,1060103.28,98316.03,729891),('1','147','257748','326',675.00,744.00,0.00,1852.56,1250478.00,1378304.64,127826.64,729892),('1','147','257749','326',675.00,744.00,0.00,1826.39,1232813.25,1358834.16,126020.91,729893),('1','147','257750','326',675.00,744.00,0.00,1972.48,1331424.00,1467525.12,136101.12,729894),('1','147','257751','326',675.00,744.00,0.00,0.00,0.00,0.00,0.00,729895),('1','147','257752','326',675.00,744.00,0.00,1897.85,1281048.75,1412000.40,130951.65,729896),('1','147','257753','326',675.00,744.00,0.00,2698.75,1821656.25,2007870.00,186213.75,729897),('1','147','257754','326',675.00,744.00,0.00,207.87,140312.25,154655.28,14343.03,729898),('1','147','257755','326',675.00,744.00,0.00,1562.55,1054721.25,1162537.20,107815.95,729899),('1','147','257756','326',675.00,744.00,0.00,1491.69,1006890.75,1109817.36,102926.61,729900),('1','147','257757','326',675.00,744.00,0.00,2120.85,1431573.75,1577912.40,146338.65,729901),('1','147','257758','326',675.00,744.00,0.00,1981.67,1337627.25,1474362.48,136735.23,729902),('1','147','257759','326',675.00,744.00,0.00,1381.37,932424.75,1027739.28,95314.53,729903),('1','147','257760','326',675.00,744.00,0.00,406.07,274097.25,302116.08,28018.83,729904),('1','147','257761','326',675.00,744.00,0.00,815.17,550239.75,606486.48,56246.73,729905),('1','147','257762','326',675.00,744.00,0.00,1442.16,973458.00,1072967.04,99509.04,729906),('1','147','257763','326',675.00,744.00,0.00,2906.51,1961894.25,2162443.44,200549.19,729907),('1','147','257764','326',675.00,744.00,0.00,882.54,595714.50,656609.76,60895.26,729908),('1','147','257765','326',675.00,744.00,0.00,978.71,660629.25,728160.24,67530.99,729909),('1','147','257766','326',675.00,744.00,0.00,2145.07,1447922.25,1595932.08,148009.83,729910),('1','147','257767','326',675.00,744.00,0.00,1739.76,1174338.00,1294381.44,120043.44,729911),('1','147','257768','326',675.00,744.00,0.00,1970.23,1329905.25,1465851.12,135945.87,729912),('1','147','257769','326',675.00,744.00,0.00,1888.64,1274832.00,1405148.16,130316.16,729913),('1','147','257770','326',675.00,744.00,0.00,637.82,430528.50,474538.08,44009.58,729914),('1','147','257771','326',675.00,744.00,0.00,484.30,326902.50,360319.20,33416.70,729915),('1','147','257772','326',675.00,744.00,0.00,1682.20,1135485.00,1251556.80,116071.80,729916),('1','147','257773','326',675.00,744.00,0.00,2547.98,1719886.50,1895697.12,175810.62,729917),('1','147','257774','326',675.00,744.00,0.00,919.20,620460.00,683884.80,63424.80,729918),('1','147','257775','326',675.00,744.00,0.00,2423.47,1635842.25,1803061.68,167219.43,729919),('1','147','257776','326',675.00,744.00,0.00,1086.22,733198.50,808147.68,74949.18,729920),('1','147','257777','326',675.00,744.00,0.00,1072.70,724072.50,798088.80,74016.30,729921),('1','147','257778','326',675.00,744.00,0.00,2138.74,1443649.50,1591222.56,147573.06,729922),('1','147','257779','326',675.00,744.00,0.00,2012.86,1358680.50,1497567.84,138887.34,729923),('1','147','257780','326',736.00,736.00,0.00,426.53,313926.08,313926.08,0.00,729924),('1','147','257781','326',736.00,736.00,0.00,1673.44,1129572.00,1231651.84,102079.84,729925),('1','147','257782','326',675.00,736.00,0.00,2874.01,1939956.75,2115271.36,175314.61,729926),('1','147','257783','326',675.00,736.00,0.00,580.14,391594.50,426983.04,35388.54,729927),('1','147','257784','326',675.00,736.00,0.00,919.30,620527.50,676604.80,56077.30,729928),('1','147','257785','326',675.00,736.00,0.00,1750.87,1181837.25,1288640.32,106803.07,729929),('1','147','257786','326',675.00,736.00,0.00,1684.67,1137152.25,1239917.12,102764.87,729930),('1','147','257787','326',675.00,736.00,0.00,550.01,371256.75,404807.36,33550.61,729931),('1','147','257788','326',675.00,736.00,0.00,1331.41,893024.50,979917.76,86893.26,729932),('1','147','257789','326',670.00,736.00,0.00,1949.94,1306459.80,1435155.84,128696.04,729933),('1','147','257790','326',670.00,736.00,0.00,1507.66,1010132.20,1109637.76,99505.56,729934),('1','147','257791','326',670.00,736.00,0.00,937.27,627970.90,689830.72,61859.82,729935),('1','147','257792','326',670.00,736.00,0.00,1649.97,1105479.90,1214377.92,108898.02,729936),('1','147','257793','326',670.00,736.00,0.00,1964.29,1316074.30,1445717.44,129643.14,729937),('1','147','257794','326',670.00,736.00,0.00,1556.45,1042821.50,1145547.20,102725.70,729938),('1','147','257795','326',670.00,736.00,0.00,1996.85,1337889.50,1469681.60,131792.10,729939),('1','147','257796','326',670.00,736.00,0.00,1926.08,1290473.60,1417594.88,127121.28,729940),('1','147','257797','326',670.00,736.00,0.00,1311.03,878390.10,964918.08,86527.98,729941),('1','147','257798','326',670.00,736.00,0.00,3123.52,2092758.40,2298910.72,206152.32,729942),('1','147','257799','326',670.00,736.00,0.00,1413.01,946716.70,1039975.36,93258.66,729943),('1','147','257800','326',670.00,736.00,0.00,873.96,585553.20,643234.56,57681.36,729944),('1','147','257801','326',670.00,736.00,0.00,2827.66,1894532.20,2081157.76,186625.56,729945),('1','147','257802','326',670.00,736.00,0.00,1270.98,851556.60,935441.28,83884.68,729946),('1','147','257803','326',670.00,736.00,0.00,2756.25,1846687.50,2028600.00,181912.50,729947),('1','147','257804','326',670.00,736.00,0.00,1839.38,1232384.60,1353783.68,121399.08,729948),('1','147','257805','326',670.00,764.00,0.00,1283.42,928885.80,968458.86,39573.06,729949),('1','147','257806','326',748.00,748.00,0.00,2263.69,1693240.12,1693240.12,0.00,729950),('1','147','257807','326',748.00,748.00,0.00,881.54,659391.92,659391.92,0.00,729951),('1','147','257808','326',670.00,748.00,0.00,772.03,517260.10,577478.44,60218.34,729952),('1','147','257809','326',670.00,748.00,0.00,1876.75,1257422.50,1403809.00,146386.50,729953),('1','147','257810','326',670.00,748.00,0.00,0.00,0.00,0.00,0.00,729954),('1','147','257811','326',670.00,748.00,0.00,2391.66,1602412.20,1788961.68,186549.48,729955),('1','147','257812','326',670.00,748.00,0.00,0.00,0.00,0.00,0.00,729956),('1','147','257813','326',670.00,748.00,0.00,2078.63,1392682.10,1554815.24,162133.14,729957),('1','147','257814','326',670.00,748.00,0.00,1785.39,1196211.30,1335471.72,139260.42,729958),('1','147','257815','326',670.00,748.00,0.00,1273.99,853573.30,952944.52,99371.22,729959),('1','147','257816','326',670.00,748.00,0.00,284.20,190414.00,212581.60,22167.60,729960),('1','147','257817','326',760.00,760.00,0.00,1274.55,968658.00,968658.00,0.00,729961),('1','147','257818','326',760.00,760.00,0.00,2271.72,1726507.20,1726507.20,0.00,729962),('1','147','257819','326',760.00,760.00,0.00,1506.63,1142599.80,1145038.80,2439.00,729963),('1','147','257820','326',670.00,760.00,0.00,3099.10,2076397.00,2355316.00,278919.00,729964),('1','147','257821','326',670.00,760.00,0.00,788.77,528475.90,599465.20,70989.30,729965),('1','147','257822','326',670.00,760.00,0.00,761.08,509923.60,578420.80,68497.20,729966),('1','147','257823','326',670.00,760.00,0.00,1862.32,1247754.40,1415363.20,167608.80,729967),('1','147','257824','326',670.00,760.00,0.00,1645.22,1102297.40,1250367.20,148069.80,729968),('1','147','257825','326',800.00,800.00,0.00,625.31,497172.20,500248.00,3075.80,729969),('1','147','257826','326',670.00,800.00,0.00,681.41,456544.70,545128.00,88583.30,729970),('1','147','257827','326',670.00,800.00,0.00,1880.47,1259914.90,1504376.00,244461.10,729971),('1','147','257828','326',670.00,800.00,0.00,1361.55,912238.50,1089240.00,177001.50,729972),('1','147','257829','326',670.00,800.00,0.00,578.78,387782.60,463024.00,75241.40,729973),('1','147','257830','326',760.00,760.00,0.00,1769.61,1344903.60,1344903.60,0.00,729974),('1','147','257831','326',760.00,760.00,0.00,2233.84,1697718.40,1697718.40,0.00,729975),('1','147','257832','326',760.00,760.00,0.00,1531.46,1163909.60,1163909.60,0.00,729976),('1','147','257833','326',760.00,760.00,0.00,0.00,0.00,0.00,0.00,729977),('1','147','257834','326',760.00,760.00,0.00,0.00,0.00,0.00,0.00,729978),('1','147','257836','326',760.00,760.00,0.00,1584.05,1061313.50,1203878.00,142564.50,729979),('1','147','257837','326',670.00,760.00,0.00,2491.03,1668990.10,1893182.80,224192.70,729980),('1','147','257838','326',670.00,760.00,0.00,1018.62,682475.40,774151.20,91675.80,729981),('1','147','257839','326',670.00,760.00,0.00,36.26,24294.20,27557.60,3263.40,729982),('1','147','257840','326',670.00,760.00,0.00,1029.13,689517.10,782138.80,92621.70,729983),('1','147','257841','326',670.00,760.00,0.00,1707.63,1144112.10,1297798.80,153686.70,729984),('1','147','257842','326',670.00,760.00,0.00,1766.02,1183233.40,1342175.20,158941.80,729985),('1','147','257843','326',670.00,760.00,0.00,680.16,455707.20,516921.60,61214.40,729986),('1','147','257844','326',685.00,760.00,0.00,571.27,391319.95,434165.20,42845.25,729987),('1','147','257845','326',685.00,760.00,0.00,1532.39,1049687.15,1164616.40,114929.25,729988),('1','147','257846','326',685.00,760.00,0.00,938.09,642591.65,712948.40,70356.75,729989),('1','147','257847','326',685.00,760.00,0.00,2226.15,1524912.75,1691874.00,166961.25,729990),('1','147','257848','326',685.00,760.00,0.00,2017.63,1382076.55,1533398.80,151322.25,729991),('1','147','257849','326',685.00,760.00,0.00,1855.80,1271223.00,1410408.00,139185.00,729992),('1','147','257850','326',685.00,760.00,0.00,1427.97,978159.45,1085257.20,107097.75,729993),('1','147','257851','326',685.00,760.00,0.00,1531.43,1049029.55,1163886.80,114857.25,729994),('1','147','257852','326',685.00,760.00,0.00,1689.79,1157506.15,1284240.40,126734.25,729995),('1','147','257853','326',685.00,760.00,0.00,2063.63,1413586.55,1568358.80,154772.25,729996),('1','147','257854','326',685.00,760.00,0.00,110.91,75973.35,84291.60,8318.25,729997),('1','147','257855','326',685.00,760.00,0.00,2130.74,1459556.90,1619362.40,159805.50,729998),('1','147','257856','326',685.00,760.00,0.00,2039.01,1396721.85,1549647.60,152925.75,729999),('1','147','257857','326',685.00,760.00,0.00,902.80,618418.00,686128.00,67710.00,730000),('1','147','257858','326',685.00,760.00,0.00,579.09,396676.65,440108.40,43431.75,730001),('1','147','257859','326',685.00,760.00,0.00,1541.59,1055989.15,1171608.40,115619.25,730002),('1','147','257860','326',685.00,760.00,0.00,1777.81,1217799.85,1351135.60,133335.75,730003),('1','147','257861','326',685.00,760.00,0.00,1021.61,699802.85,776423.60,76620.75,730004),('1','147','257862','326',685.00,760.00,0.00,526.95,360960.75,400482.00,39521.25,730005),('1','147','257863','326',685.00,760.00,0.00,1865.26,1277703.10,1417597.60,139894.50,730006),('1','147','257864','326',685.00,760.00,0.00,2126.49,1456645.65,1616132.40,159486.75,730007),('1','147','257865','326',685.00,760.00,0.00,567.71,388881.35,431459.60,42578.25,730008),('1','147','257866','326',685.00,760.00,0.00,1307.73,895795.05,993874.80,98079.75,730009),('1','147','257867','326',685.00,760.00,0.00,1328.18,909803.30,1009416.80,99613.50,730010),('1','147','257868','326',685.00,760.00,0.00,1728.34,1183912.90,1313538.40,129625.50,730011),('1','147','257869','326',685.00,760.00,0.00,517.61,354562.85,393383.60,38820.75,730012),('1','147','257870','326',685.00,760.00,0.00,900.70,616979.50,684532.00,67552.50,730013),('1','147','257871','326',685.00,760.00,0.00,2078.62,1423854.70,1579751.20,155896.50,730014),('1','147','257872','326',685.00,760.00,0.00,1933.66,1324557.10,1469581.60,145024.50,730015),('1','147','257873','326',685.00,760.00,0.00,235.42,161262.70,178919.20,17656.50,730016),('1','147','257874','326',685.00,760.00,0.00,2281.20,1562622.00,1733712.00,171090.00,730017),('1','147','257875','326',685.00,760.00,0.00,2155.08,1476229.80,1637860.80,161631.00,730018),('1','147','257876','326',685.00,760.00,0.00,641.11,439160.35,487243.60,48083.25,730019),('1','147','257877','326',685.00,760.00,0.00,931.35,637974.75,707826.00,69851.25,730020),('1','147','257878','326',685.00,760.00,0.00,2009.89,1376774.65,1527516.40,150741.75,730021),('1','147','257879','326',685.00,760.00,0.00,1602.23,1097527.55,1217694.80,120167.25,730022),('1','147','257880','326',685.00,760.00,0.00,942.12,645352.20,716011.20,70659.00,730023),('1','147','257881','326',685.00,760.00,0.00,625.09,428186.65,475068.40,46881.75,730024),('1','147','257882','326',685.00,760.00,0.00,1881.70,1362219.37,1395619.12,33399.75,730025),('1','147','257883','326',736.00,736.00,0.00,2291.21,1686330.56,1686330.56,0.00,730026),('1','147','257884','326',736.00,736.00,0.00,450.06,331244.16,331244.16,0.00,730027),('1','147','257885','326',685.00,736.00,0.00,1564.89,1071949.65,1151759.04,79809.39,730028),('1','147','257886','326',685.00,736.00,0.00,1549.93,1061702.05,1140748.48,79046.43,730029),('1','147','257887','326',685.00,736.00,0.00,1803.14,1235150.90,1327111.04,91960.14,730030),('1','147','257888','326',685.00,736.00,0.00,37.61,25762.85,27680.96,1918.11,730031),('1','147','257889','326',685.00,736.00,0.00,1635.33,1100828.76,1203602.88,102774.12,730032),('1','147','257890','326',664.00,736.00,0.00,1671.86,1110115.04,1230488.96,120373.92,730033),('1','147','257891','326',664.00,736.00,0.00,1722.01,1143414.64,1267399.36,123984.72,730034),('1','147','257892','326',664.00,736.00,0.00,217.78,144605.92,160286.08,15680.16,730035),('1','147','257893','326',664.00,736.00,0.00,2124.63,1410754.32,1563727.68,152973.36,730036),('1','147','257894','326',664.00,736.00,0.00,2559.83,1699727.12,1884034.88,184307.76,730037),('1','147','257895','326',664.00,736.00,0.00,190.07,126206.48,139891.52,13685.04,730038),('1','147','257896','326',664.00,736.00,0.00,1587.47,1054080.08,1168377.92,114297.84,730039),('1','147','257897','326',664.00,736.00,0.00,2218.99,1473409.36,1633176.64,159767.28,730040),('1','147','257898','326',664.00,736.00,0.00,1504.79,999180.56,1107525.44,108344.88,730041),('1','147','257899','326',664.00,736.00,0.00,657.76,436752.64,484111.36,47358.72,730042),('1','147','257900','326',664.00,736.00,0.00,2247.87,1492585.68,1654432.32,161846.64,730043),('1','147','257901','326',664.00,736.00,0.00,2293.69,1523010.16,1688155.84,165145.68,730044),('1','147','257902','326',664.00,736.00,0.00,4177.35,2773760.40,3074529.60,300769.20,730045),('1','147','257903','326',664.00,736.00,0.00,1074.90,713733.60,791126.40,77392.80,730046),('1','147','257904','326',664.00,736.00,0.00,936.83,622055.12,689506.88,67451.76,730047),('1','147','257905','326',664.00,736.00,0.00,1803.23,1197344.72,1327177.28,129832.56,730048),('1','147','257906','326',664.00,736.00,0.00,1613.26,1071204.64,1187359.36,116154.72,730049),('1','147','257907','326',664.00,736.00,0.00,779.79,517780.56,573925.44,56144.88,730050),('1','147','257908','326',664.00,736.00,0.00,544.40,361481.60,400678.40,39196.80,730051),('1','147','257909','326',664.00,736.00,0.00,1489.41,988968.24,1096205.76,107237.52,730052),('1','147','257910','326',664.00,736.00,0.00,1553.66,1031630.24,1143493.76,111863.52,730053),('1','147','257911','326',664.00,736.00,0.00,1477.29,980920.56,1087285.44,106364.88,730054),('1','147','257912','326',664.00,736.00,0.00,668.36,443791.04,491912.96,48121.92,730055),('1','147','257913','326',664.00,736.00,0.00,1544.63,1025634.32,1136847.68,111213.36,730056),('1','147','257914','326',664.00,736.00,0.00,1736.92,1153314.88,1278373.12,125058.24,730057),('1','147','257915','326',664.00,736.00,0.00,1180.83,784071.12,869090.88,85019.76,730058),('1','147','257916','326',664.00,736.00,0.00,495.39,328938.96,364607.04,35668.08,730059),('1','147','257917','326',664.00,736.00,0.00,1661.03,1102923.92,1222518.08,119594.16,730060),('1','147','257918','326',664.00,736.00,0.00,1764.48,1171614.72,1298657.28,127042.56,730061),('1','147','257919','326',664.00,736.00,0.00,1389.01,922302.64,1022311.36,100008.72,730062),('1','147','257920','326',664.00,736.00,0.00,2090.98,1388410.72,1538961.28,150550.56,730063),('1','147','257921','326',664.00,736.00,0.00,2243.48,1489670.72,1651201.28,161530.56,730064),('1','147','257922','326',664.00,736.00,0.00,1249.84,829893.76,919882.24,89988.48,730065),('1','147','257923','326',664.00,736.00,0.00,524.19,348062.16,385803.84,37741.68,730066),('1','147','257924','326',664.00,736.00,0.00,1806.19,1199310.16,1329355.84,130045.68,730067),('1','147','257925','326',664.00,736.00,0.00,1976.74,1312555.36,1454880.64,142325.28,730068),('1','147','257926','326',664.00,736.00,0.00,811.07,538550.48,596947.52,58397.04,730069),('1','147','257927','326',664.00,736.00,0.00,1017.85,675852.40,749137.60,73285.20,730070),('1','147','257928','326',664.00,736.00,0.00,1914.34,1271121.76,1408954.24,137832.48,730071),('1','147','257929','326',664.00,736.00,0.00,2222.79,1475932.56,1635973.44,160040.88,730072),('1','147','257930','326',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730073),('1','147','257931','326',664.00,736.00,0.00,2695.13,1789566.32,1983615.68,194049.36,730074),('1','147','257932','326',664.00,736.00,0.00,1964.58,1304481.12,1445930.88,141449.76,730075),('1','147','257933','326',664.00,736.00,0.00,491.25,326190.00,361560.00,35370.00,730076),('1','147','257934','326',664.00,736.00,0.00,1434.78,952693.92,1055998.08,103304.16,730077),('1','147','257935','326',664.00,736.00,0.00,1842.29,1223280.56,1355925.44,132644.88,730078),('1','147','257936','326',664.00,736.00,0.00,1394.75,926114.00,1026536.00,100422.00,730079),('1','147','257937','326',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730080),('1','147','257938','326',664.00,736.00,0.00,1817.87,1207065.68,1337952.32,130886.64,730081),('1','147','257939','326',664.00,736.00,0.00,2380.04,1580346.56,1751709.44,171362.88,730082),('1','147','257940','326',664.00,736.00,0.00,1081.12,717863.68,795704.32,77840.64,730083),('1','147','257941','326',664.00,736.00,0.00,801.85,532428.40,590161.60,57733.20,730084),('1','147','257942','326',664.00,736.00,0.00,1978.92,1314002.88,1456485.12,142482.24,730085),('1','147','257943','326',664.00,736.00,0.00,1694.71,1125287.44,1247306.56,122019.12,730086),('1','147','257944','326',664.00,736.00,0.00,747.46,496313.44,550130.56,53817.12,730087),('1','147','257945','326',640.00,736.00,0.00,822.70,526528.00,605507.20,78979.20,730088),('1','147','257946','326',640.00,736.00,0.00,1725.31,1104198.40,1269828.16,165629.76,730089),('1','147','257947','326',640.00,736.00,0.00,1934.18,1237875.20,1423556.48,185681.28,730090),('1','147','257948','326',640.00,736.00,0.00,831.74,532313.60,612160.64,79847.04,730091),('1','147','257949','326',640.00,736.00,0.00,1258.05,805152.00,925924.80,120772.80,730092),('1','147','257950','326',640.00,736.00,0.00,1947.66,1246502.40,1433477.76,186975.36,730093),('1','147','257951','326',640.00,736.00,0.00,1659.89,1062329.60,1221679.04,159349.44,730094),('1','147','257952','326',640.00,736.00,0.00,484.82,310284.80,356827.52,46542.72,730095),('1','147','257953','326',640.00,736.00,0.00,1069.20,684288.00,786931.20,102643.20,730096),('1','147','257954','326',640.00,736.00,0.00,1541.03,986259.20,1134198.08,147938.88,730097),('1','147','257955','326',640.00,736.00,0.00,1529.56,978918.40,1125756.16,146837.76,730098),('1','147','257956','326',640.00,736.00,0.00,1034.57,662124.80,761443.52,99318.72,730099),('1','147','257957','326',640.00,736.00,0.00,0.00,0.00,0.00,0.00,730100),('1','147','257958','326',640.00,736.00,0.00,1734.87,1110316.80,1276864.32,166547.52,730101),('1','147','257959','326',640.00,736.00,0.00,2458.14,1573209.60,1809191.04,235981.44,730102),('1','147','257960','326',640.00,736.00,0.00,1136.43,728227.20,836412.48,108185.28,730103),('1','147','257961','326',664.00,736.00,0.00,1370.81,910217.84,1008916.16,98698.32,730104),('1','147','257962','326',664.00,736.00,0.00,1810.36,1202079.04,1332424.96,130345.92,730105),('1','147','257963','326',664.00,736.00,0.00,1787.92,1187178.88,1315909.12,128730.24,730106),('1','147','257964','326',664.00,736.00,0.00,1567.59,1040879.76,1153746.24,112866.48,730107),('1','147','257965','326',664.00,736.00,0.00,2225.64,1477824.96,1638071.04,160246.08,730108),('1','147','257966','326',664.00,736.00,0.00,1409.88,936160.32,1037671.68,101511.36,730109),('1','147','257967','326',664.00,736.00,0.00,1032.78,685765.92,760126.08,74360.16,730110),('1','147','257968','326',664.00,736.00,0.00,1652.56,1097299.84,1216284.16,118984.32,730111),('1','147','257969','326',664.00,736.00,0.00,1143.48,759270.72,841601.28,82330.56,730112),('1','147','257970','326',664.00,736.00,0.00,2364.99,1570353.36,1740632.64,170279.28,730113),('1','147','257971','326',664.00,736.00,0.00,1738.26,1154204.64,1279359.36,125154.72,730114),('1','147','257972','326',664.00,736.00,0.00,1684.21,1118315.44,1239578.56,121263.12,730115),('1','147','257973','326',664.00,736.00,0.00,561.19,372630.16,413035.84,40405.68,730116),('1','147','257974','326',664.00,736.00,0.00,1020.94,677904.16,751411.84,73507.68,730117),('1','147','257975','326',664.00,736.00,0.00,579.03,384475.92,426166.08,41690.16,730118),('1','147','257976','326',664.00,736.00,0.00,1621.36,1076583.04,1193320.96,116737.92,730119),('1','147','257977','326',664.00,736.00,0.00,1438.00,954832.00,1058368.00,103536.00,730120),('1','147','257978','326',664.00,736.00,0.00,1686.54,1119862.56,1241293.44,121430.88,730121),('1','147','257979','326',664.00,736.00,0.00,2148.99,1426929.36,1581656.64,154727.28,730122),('1','147','257980','326',664.00,736.00,0.00,1397.33,927827.12,1028434.88,100607.76,730123),('1','147','257981','326',664.00,736.00,0.00,1244.75,826514.00,916136.00,89622.00,730124),('1','147','257982','326',664.00,736.00,0.00,238.64,158456.96,175639.04,17182.08,730125),('1','147','257983','326',664.00,736.00,0.00,1543.94,1025176.16,1136339.84,111163.68,730126),('1','147','257984','326',664.00,736.00,0.00,1188.16,788938.24,874485.76,85547.52,730127),('1','147','257985','326',664.00,736.00,0.00,980.00,650720.00,721280.00,70560.00,730128),('1','147','257986','326',664.00,736.00,0.00,1589.16,1055202.24,1169621.76,114419.52,730129),('1','147','257987','326',664.00,736.00,0.00,349.20,231868.80,257011.20,25142.40,730130),('1','147','257988','326',664.00,736.00,0.00,997.25,662174.00,733976.00,71802.00,730131),('1','147','257989','326',664.00,736.00,0.00,1336.91,887708.24,983965.76,96257.52,730132),('1','147','257990','326',664.00,736.00,0.00,2030.68,1348371.52,1494580.48,146208.96,730133),('1','147','257991','326',664.00,736.00,0.00,614.10,407762.40,451977.60,44215.20,730134),('1','147','257992','326',664.00,736.00,0.00,660.01,438246.64,485767.36,47520.72,730135),('1','147','257993','326',664.00,736.00,0.00,1633.74,1084803.36,1202432.64,117629.28,730136),('1','147','257994','326',664.00,736.00,0.00,1619.03,1121522.36,1145119.64,23597.28,730137),('1','147','257995','326',700.00,700.00,0.00,1203.49,838787.26,842443.00,3655.74,730138),('1','147','257996','326',634.00,700.00,0.00,1493.17,946669.78,1045219.00,98549.22,730139),('1','147','257997','326',634.00,700.00,0.00,2182.26,1383552.84,1527582.00,144029.16,730140),('1','147','257998','326',634.00,700.00,0.00,1474.44,934794.96,1032108.00,97313.04,730141),('1','147','257999','326',634.00,700.00,0.00,652.27,413539.18,456589.00,43049.82,730142),('1','147','258000','326',634.00,700.00,0.00,1548.55,981780.70,1083985.00,102204.30,730143),('1','147','258001','326',634.00,700.00,0.00,1483.77,940710.18,1038639.00,97928.82,730144),('1','147','258002','326',634.00,700.00,0.00,1659.77,1052294.18,1161839.00,109544.82,730145),('1','147','258003','326',634.00,700.00,0.00,1609.14,1020194.76,1126398.00,106203.24,730146),('1','147','258004','326',634.00,700.00,0.00,1697.09,1075955.06,1187963.00,112007.94,730147),('1','147','258005','326',634.00,700.00,0.00,1449.67,919090.78,1014769.00,95678.22,730148),('1','147','258006','326',634.00,700.00,0.00,1091.06,691732.04,763742.00,72009.96,730149),('1','147','258007','326',634.00,700.00,0.00,1432.48,908192.32,1002736.00,94543.68,730150);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=304 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',303,'147','PRODUCT TANK','TANK CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=769 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','147','303',768,1,'326','LPG TANK',7000.00,1.00,1799.68,'TANK CONTAINING LPG','479','2020-08-10 19:08:15','2020-08-12 12:07:00','487',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','147',768,2716.20,'2023-03-20 19:23:29');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2765478 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2107748,'1','147','768',326,'Retail Sale Id 1253909',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 05:21:55','',''),(2107749,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 05:21:55','',''),(2107750,'1','147','768',326,'Retail Sale Id 1253910',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 05:23:17','',''),(2107751,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 05:23:17','',''),(2107762,'1','147','768',326,'Retail Sale Id 1253913',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 05:35:50','',''),(2107763,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 05:35:50','',''),(2107786,'1','147','768',326,'Retail Sale Id 1253916',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 05:47:19','',''),(2107787,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 05:47:19','',''),(2107799,'1','147','768',326,'Retail Sale Id 1253923',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 05:52:31','',''),(2107800,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 05:52:31','',''),(2107825,'1','147','768',326,'Retail Sale Id 1253937',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 05:56:13','',''),(2107826,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 05:56:13','',''),(2107833,'1','147','768',326,'Retail Sale Id 1253940',800.00,0.00,0.00,0.00,800.00,'2021-12-01 05:57:15','',''),(2107834,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 05:57:15','',''),(2107912,'1','147','768',326,'Retail Sale Id 1253977',4000.00,0.00,0.00,0.00,4000.00,'2021-12-01 06:05:23','',''),(2107913,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 06:05:23','',''),(2107938,'1','147','768',326,'Retail Sale Id 1253989',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 06:07:53','',''),(2107939,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 06:07:53','',''),(2107952,'1','147','768',326,'Retail Sale Id 1253996',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 06:08:49','',''),(2107953,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 06:08:49','',''),(2107962,'1','147','768',326,'Retail Sale Id 1254002',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 06:09:57','',''),(2107963,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 06:09:57','',''),(2107968,'1','147','768',326,'Retail Sale Id 1254005',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 06:10:51','',''),(2107969,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 06:10:51','',''),(2107982,'1','147','768',326,'Retail Sale Id 1254012',998.40,0.00,0.00,0.00,998.40,'2021-12-01 06:11:43','',''),(2107983,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 06:11:43','',''),(2107990,'1','147','768',326,'Retail Sale Id 1254016',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 06:12:36','',''),(2107991,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 06:12:36','',''),(2108020,'1','147','768',326,'Retail Sale Id 1254029',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 06:15:50','',''),(2108021,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 06:15:50','',''),(2108045,'1','147','768',326,'Retail Sale Id 1254036',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 06:17:31','',''),(2108046,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:17:31','',''),(2108069,'1','147','768',326,'Retail Sale Id 1254048',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 06:20:26','',''),(2108070,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 06:20:26','',''),(2108077,'1','147','768',326,'Retail Sale Id 1254053',6003.20,0.00,0.00,0.00,6003.20,'2021-12-01 06:21:21','',''),(2108078,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-01 06:21:21','',''),(2108152,'1','147','768',326,'Retail Sale Id 1254097',3001.60,0.00,0.00,0.00,3001.60,'2021-12-01 06:28:13','',''),(2108153,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 06:28:13','',''),(2108162,'1','147','768',326,'Retail Sale Id 1254107',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 06:29:04','',''),(2108163,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 06:29:04','',''),(2108172,'1','147','768',326,'Retail Sale Id 1254112',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 06:30:02','',''),(2108173,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 06:30:02','',''),(2108193,'1','147','768',326,'Retail Sale Id 1254118',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 06:30:45','',''),(2108194,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 06:30:45','',''),(2108209,'1','147','768',326,'Retail Sale Id 1254126',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 06:32:03','',''),(2108210,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:32:03','',''),(2108219,'1','147','768',326,'Retail Sale Id 1254133',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 06:32:59','',''),(2108220,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:32:59','',''),(2108235,'1','147','768',326,'Retail Sale Id 1254142',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 06:34:06','',''),(2108236,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 06:34:06','',''),(2108287,'1','147','768',326,'Retail Sale Id 1254159',3200.00,0.00,0.00,0.00,3200.00,'2021-12-01 06:36:15','',''),(2108288,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 06:36:15','',''),(2108321,'1','147','768',326,'Retail Sale Id 1254175',3200.00,0.00,0.00,0.00,3200.00,'2021-12-01 06:38:33','',''),(2108322,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 06:38:33','',''),(2108327,'1','147','768',326,'Retail Sale Id 1254180',3001.60,0.00,0.00,0.00,3001.60,'2021-12-01 06:39:00','',''),(2108328,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 06:39:00','',''),(2108355,'1','147','768',326,'Retail Sale Id 1254194',3001.60,0.00,0.00,0.00,3001.60,'2021-12-01 06:41:41','',''),(2108356,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 06:41:41','',''),(2108387,'1','147','768',326,'Retail Sale Id 1254213',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 06:44:54','',''),(2108388,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:44:54','',''),(2108413,'1','147','768',326,'Retail Sale Id 1254225',998.40,0.00,0.00,0.00,998.40,'2021-12-01 06:47:26','',''),(2108414,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 06:47:26','',''),(2108429,'1','147','768',326,'Retail Sale Id 1254232',4998.40,0.00,0.00,0.00,4998.40,'2021-12-01 06:48:19','',''),(2108430,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 06:48:19','',''),(2108444,'1','147','768',326,'Retail Sale Id 1254239',4000.00,0.00,0.00,0.00,4000.00,'2021-12-01 06:49:12','',''),(2108445,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 06:49:12','',''),(2108460,'1','147','768',326,'Retail Sale Id 1254243',3001.60,0.00,0.00,0.00,3001.60,'2021-12-01 06:50:01','',''),(2108461,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 06:50:01','',''),(2108480,'1','147','768',326,'Retail Sale Id 1254254',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 06:51:31','',''),(2108481,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 06:51:31','',''),(2108520,'1','147','768',326,'Retail Sale Id 1254268',998.40,0.00,0.00,0.00,998.40,'2021-12-01 06:53:08','',''),(2108521,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 06:53:08','',''),(2108567,'1','147','768',326,'Retail Sale Id 1254292',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 06:54:58','',''),(2108568,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 06:54:58','',''),(2108642,'1','147','768',326,'Retail Sale Id 1254329',3200.00,0.00,0.00,0.00,3200.00,'2021-12-01 06:58:10','',''),(2108643,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 06:58:10','',''),(2108666,'1','147','768',326,'Retail Sale Id 1254341',4998.40,0.00,0.00,0.00,4998.40,'2021-12-01 06:59:27','',''),(2108667,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 06:59:27','',''),(2108695,'1','147','768',326,'Retail Sale Id 1254355',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 07:00:51','',''),(2108696,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 07:00:51','',''),(2108697,'1','147','768',326,'Retail Sale Id 1254355',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 07:00:51','',''),(2108698,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:00:51','',''),(2108715,'1','147','768',326,'Retail Sale Id 1254368',3001.60,0.00,0.00,0.00,3001.60,'2021-12-01 07:01:57','',''),(2108716,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 07:01:57','',''),(2108736,'1','147','768',326,'Retail Sale Id 1254373',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 07:02:57','',''),(2108737,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:02:57','',''),(2108763,'1','147','768',326,'Retail Sale Id 1254385',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 07:04:45','',''),(2108764,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:04:45','',''),(2108803,'1','147','768',326,'Retail Sale Id 1254398',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 07:05:54','',''),(2108804,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 07:05:54','',''),(2108838,'1','147','768',326,'Retail Sale Id 1254415',3001.60,0.00,0.00,0.00,3001.60,'2021-12-01 07:08:26','',''),(2108839,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 07:08:26','',''),(2108866,'1','147','768',326,'Retail Sale Id 1254429',1952.00,0.00,0.00,0.00,1952.00,'2021-12-01 07:09:19','',''),(2108867,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 07:09:19','',''),(2108899,'1','147','768',326,'Retail Sale Id 1254438',998.40,0.00,0.00,0.00,998.40,'2021-12-01 07:10:27','',''),(2108900,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 07:10:27','',''),(2108937,'1','147','768',326,'Retail Sale Id 1254452',4998.40,0.00,0.00,0.00,4998.40,'2021-12-01 07:11:57','',''),(2108938,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 07:11:57','',''),(2109003,'1','147','768',326,'Retail Sale Id 1254481',3200.00,0.00,0.00,0.00,3200.00,'2021-12-01 07:14:56','',''),(2109004,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 07:14:56','',''),(2109045,'1','147','768',326,'Retail Sale Id 1254506',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 07:17:44','',''),(2109046,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:17:44','',''),(2109071,'1','147','768',326,'Retail Sale Id 1254520',3001.60,0.00,0.00,0.00,3001.60,'2021-12-01 07:18:49','',''),(2109072,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 07:18:49','',''),(2109085,'1','147','768',326,'Retail Sale Id 1254527',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 07:19:44','',''),(2109086,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:19:44','',''),(2109106,'1','147','768',326,'Retail Sale Id 1254535',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 07:20:47','',''),(2109107,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:20:47','',''),(2109137,'1','147','768',326,'Retail Sale Id 1254547',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 07:21:49','',''),(2109138,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 07:21:49','',''),(2109263,'1','147','768',326,'Retail Sale Id 1254588',3200.00,0.00,0.00,0.00,3200.00,'2021-12-01 07:27:54','',''),(2109264,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 07:27:54','',''),(2109323,'1','147','768',326,'Retail Sale Id 1254616',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 07:30:56','',''),(2109325,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 07:30:56','',''),(2109346,'1','147','768',326,'Retail Sale Id 1254628',998.40,0.00,0.00,0.00,998.40,'2021-12-01 07:32:05','',''),(2109347,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 07:32:05','',''),(2109446,'1','147','768',326,'Retail Sale Id 1254690',1952.00,0.00,0.00,0.00,1952.00,'2021-12-01 07:37:08','',''),(2109447,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 07:37:08','',''),(2109482,'1','147','768',326,'Retail Sale Id 1254708',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 07:38:45','',''),(2109483,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:38:45','',''),(2109551,'1','147','768',326,'Retail Sale Id 1254728',3001.60,0.00,0.00,0.00,3001.60,'2021-12-01 07:40:55','',''),(2109552,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 07:40:55','',''),(2109625,'1','147','768',326,'Retail Sale Id 1254764',1952.00,0.00,0.00,0.00,1952.00,'2021-12-01 07:44:46','',''),(2109626,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 07:44:46','',''),(2109679,'1','147','768',326,'Retail Sale Id 1254780',4000.00,0.00,0.00,0.00,4000.00,'2021-12-01 07:46:05','',''),(2109680,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 07:46:05','',''),(2109705,'1','147','768',326,'Retail Sale Id 1254793',998.40,0.00,0.00,0.00,998.40,'2021-12-01 07:47:06','',''),(2109706,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 07:47:06','',''),(2109736,'1','147','768',326,'Retail Sale Id 1254809',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 07:48:15','',''),(2109737,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 07:48:15','',''),(2109766,'1','147','768',326,'Retail Sale Id 1254826',998.40,0.00,0.00,0.00,998.40,'2021-12-01 07:50:01','',''),(2109767,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 07:50:01','',''),(2109800,'1','147','768',326,'Retail Sale Id 1254839',697.60,0.00,0.00,0.00,697.60,'2021-12-01 07:51:48','',''),(2109801,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-01 07:51:48','',''),(2109841,'1','147','768',326,'Retail Sale Id 1254858',998.40,0.00,0.00,0.00,998.40,'2021-12-01 07:53:48','',''),(2109842,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 07:53:48','',''),(2109868,'1','147','768',326,'Retail Sale Id 1254873',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 07:55:11','',''),(2109869,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 07:55:11','',''),(2109924,'1','147','768',326,'Retail Sale Id 1254904',800.00,0.00,0.00,0.00,800.00,'2021-12-01 07:57:56','',''),(2109925,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 07:57:56','',''),(2109945,'1','147','768',326,'Retail Sale Id 1254913',1203.20,0.00,0.00,0.00,1203.20,'2021-12-01 07:59:13','',''),(2109946,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-01 07:59:13','',''),(2109955,'1','147','768',326,'Retail Sale Id 1254919',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 08:00:06','',''),(2109956,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 08:00:06','',''),(2109971,'1','147','768',326,'Retail Sale Id 1254925',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 08:01:13','',''),(2109972,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:01:13','',''),(2109987,'1','147','768',326,'Retail Sale Id 1254934',7001.60,0.00,0.00,0.00,7001.60,'2021-12-01 08:02:00','',''),(2109988,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-01 08:02:00','',''),(2110092,'1','147','768',326,'Retail Sale Id 1254981',3840.00,0.00,0.00,0.00,3840.00,'2021-12-01 08:06:53','',''),(2110093,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:06:53','',''),(2110116,'1','147','768',326,'Retail Sale Id 1254994',998.40,0.00,0.00,0.00,998.40,'2021-12-01 08:08:19','',''),(2110117,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 08:08:19','',''),(2110150,'1','147','768',326,'Retail Sale Id 1255008',4998.40,0.00,0.00,0.00,4998.40,'2021-12-01 08:10:07','',''),(2110151,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 08:10:07','',''),(2110182,'1','147','768',326,'Retail Sale Id 1255026',1920.00,0.00,0.00,0.00,1920.00,'2021-12-01 08:12:40','',''),(2110183,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 08:12:40','',''),(2110222,'1','147','768',326,'Retail Sale Id 1255045',998.40,0.00,0.00,0.00,998.40,'2021-12-01 08:14:24','',''),(2110223,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 08:14:24','',''),(2110322,'1','147','768',326,'Retail Sale Id 1255096',4499.20,0.00,0.00,0.00,4499.20,'2021-12-01 08:20:06','',''),(2110323,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-01 08:20:06','',''),(2110362,'1','147','768',326,'Retail Sale Id 1255115',3840.00,0.00,0.00,0.00,3840.00,'2021-12-01 08:21:58','',''),(2110363,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:21:58','',''),(2110399,'1','147','768',326,'Retail Sale Id 1255134',3500.80,0.00,0.00,0.00,3500.80,'2021-12-01 08:24:21','',''),(2110400,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 08:24:21','',''),(2110425,'1','147','768',326,'Retail Sale Id 1255150',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 08:26:43','',''),(2110426,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:26:43','',''),(2110443,'1','147','768',326,'Retail Sale Id 1255160',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 08:28:08','',''),(2110444,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 08:28:08','',''),(2110469,'1','147','768',326,'Retail Sale Id 1255174',3200.00,0.00,0.00,0.00,3200.00,'2021-12-01 08:29:53','',''),(2110470,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:29:53','',''),(2110504,'1','147','768',326,'Retail Sale Id 1255188',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 08:31:48','',''),(2110505,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 08:31:48','',''),(2110548,'1','147','768',326,'Retail Sale Id 1255205',998.40,0.00,0.00,0.00,998.40,'2021-12-01 08:33:35','',''),(2110549,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 08:33:35','',''),(2110574,'1','147','768',326,'Retail Sale Id 1255221',697.60,0.00,0.00,0.00,697.60,'2021-12-01 08:35:14','',''),(2110575,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-01 08:35:14','',''),(2110631,'1','147','768',326,'Retail Sale Id 1255244',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 08:38:48','',''),(2110632,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 08:38:48','',''),(2110692,'1','147','768',326,'Retail Sale Id 1255264',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 08:41:34','',''),(2110693,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:41:34','',''),(2110716,'1','147','768',326,'Retail Sale Id 1255285',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 08:42:53','',''),(2110717,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 08:42:53','',''),(2110772,'1','147','768',326,'Retail Sale Id 1255314',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 08:46:24','',''),(2110773,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:46:24','',''),(2110842,'1','147','768',326,'Retail Sale Id 1255360',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 08:50:46','',''),(2110843,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 08:50:46','',''),(2110860,'1','147','768',326,'Retail Sale Id 1255370',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 08:51:52','',''),(2110861,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 08:51:52','',''),(2111046,'1','147','768',326,'Retail Sale Id 1255464',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 09:03:03','',''),(2111047,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 09:03:03','',''),(2111072,'1','147','768',326,'Retail Sale Id 1255477',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 09:03:58','',''),(2111073,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 09:03:58','',''),(2111088,'1','147','768',326,'Retail Sale Id 1255484',1900.80,0.00,0.00,0.00,1900.80,'2021-12-01 09:04:56','',''),(2111089,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-01 09:04:56','',''),(2111144,'1','147','768',326,'Retail Sale Id 1255511',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 09:09:02','',''),(2111145,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 09:09:02','',''),(2111188,'1','147','768',326,'Retail Sale Id 1255535',1958.40,0.00,0.00,0.00,1958.40,'2021-12-01 09:11:51','',''),(2111189,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.06,0.00,'2021-12-01 09:11:51','',''),(2111220,'1','147','768',326,'Retail Sale Id 1255545',4000.00,0.00,0.00,0.00,4000.00,'2021-12-01 09:13:30','',''),(2111221,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 09:13:30','',''),(2111288,'1','147','768',326,'Retail Sale Id 1255584',4000.00,0.00,0.00,0.00,4000.00,'2021-12-01 09:16:54','',''),(2111289,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 09:16:54','',''),(2111320,'1','147','768',326,'Retail Sale Id 1255612',3001.60,0.00,0.00,0.00,3001.60,'2021-12-01 09:19:09','',''),(2111321,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 09:19:09','',''),(2111392,'1','147','768',326,'Retail Sale Id 1255646',3001.60,0.00,0.00,0.00,3001.60,'2021-12-01 09:23:42','',''),(2111393,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 09:23:42','',''),(2111400,'1','147','768',326,'Retail Sale Id 1255653',3500.80,0.00,0.00,0.00,3500.80,'2021-12-01 09:24:33','',''),(2111401,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 09:24:33','',''),(2111428,'1','147','768',326,'Retail Sale Id 1255662',3200.00,0.00,0.00,0.00,3200.00,'2021-12-01 09:25:53','',''),(2111429,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 09:25:53','',''),(2111504,'1','147','768',326,'Retail Sale Id 1255700',2502.40,0.00,0.00,0.00,2502.40,'2021-12-01 09:30:07','',''),(2111505,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 09:30:07','',''),(2111585,'1','147','768',326,'Retail Sale Id 1255747',3200.00,0.00,0.00,0.00,3200.00,'2021-12-01 09:36:33','',''),(2111586,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 09:36:33','',''),(2111619,'1','147','768',326,'Retail Sale Id 1255763',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 09:38:02','',''),(2111620,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 09:38:02','',''),(2111648,'1','147','768',326,'Retail Sale Id 1255781',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 09:39:29','',''),(2111649,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 09:39:29','',''),(2111666,'1','147','768',326,'Retail Sale Id 1255790',4000.00,0.00,0.00,0.00,4000.00,'2021-12-01 09:40:34','',''),(2111667,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 09:40:34','',''),(2111722,'1','147','768',326,'Retail Sale Id 1255818',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 09:45:02','',''),(2111723,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 09:45:02','',''),(2111730,'1','147','768',326,'Retail Sale Id 1255825',2502.40,0.00,0.00,0.00,2502.40,'2021-12-01 09:45:51','',''),(2111731,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 09:45:51','',''),(2111784,'1','147','768',326,'Retail Sale Id 1255856',998.40,0.00,0.00,0.00,998.40,'2021-12-01 09:49:40','',''),(2111785,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 09:49:40','',''),(2111911,'1','147','768',326,'Retail Sale Id 1255906',3200.00,0.00,0.00,0.00,3200.00,'2021-12-01 09:58:14','',''),(2111912,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 09:58:14','',''),(2111955,'1','147','768',326,'Retail Sale Id 1255928',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 10:00:58','',''),(2111956,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 10:00:58','',''),(2112023,'1','147','768',326,'Retail Sale Id 1255964',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 10:06:09','',''),(2112024,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 10:06:09','',''),(2112214,'1','147','768',326,'Retail Sale Id 1256057',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 10:17:39','',''),(2112215,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 10:17:39','',''),(2112241,'1','147','768',326,'Retail Sale Id 1256071',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 10:19:55','',''),(2112242,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:19:55','',''),(2112276,'1','147','768',326,'Retail Sale Id 1256091',1299.20,0.00,0.00,0.00,1299.20,'2021-12-01 10:24:20','',''),(2112277,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 10:24:20','',''),(2112347,'1','147','768',326,'Retail Sale Id 1256118',640.00,0.00,0.00,0.00,640.00,'2021-12-01 10:29:07','',''),(2112348,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 10:29:07','',''),(2112373,'1','147','768',326,'Retail Sale Id 1256130',1952.00,0.00,0.00,0.00,1952.00,'2021-12-01 10:30:49','',''),(2112374,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 10:30:49','',''),(2112391,'1','147','768',326,'Retail Sale Id 1256140',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 10:32:23','',''),(2112392,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:32:23','',''),(2112499,'1','147','768',326,'Retail Sale Id 1256196',4998.40,0.00,0.00,0.00,4998.40,'2021-12-01 10:39:55','',''),(2112500,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 10:39:55','',''),(2112507,'1','147','768',326,'Retail Sale Id 1256201',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 10:41:20','',''),(2112508,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 10:41:20','',''),(2112604,'1','147','768',326,'Retail Sale Id 1256248',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 10:49:25','',''),(2112605,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 10:49:25','',''),(2112660,'1','147','768',326,'Retail Sale Id 1256278',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 10:54:56','',''),(2112661,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 10:54:56','',''),(2112686,'1','147','768',326,'Retail Sale Id 1256294',2598.40,0.00,0.00,0.00,2598.40,'2021-12-01 10:57:45','',''),(2112687,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-01 10:57:45','',''),(2112730,'1','147','768',326,'Retail Sale Id 1256317',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 11:00:32','',''),(2112731,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 11:00:32','',''),(2112745,'1','147','768',326,'Retail Sale Id 1256324',998.40,0.00,0.00,0.00,998.40,'2021-12-01 11:02:22','',''),(2112746,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 11:02:22','',''),(2112788,'1','147','768',326,'Retail Sale Id 1256347',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 11:05:47','',''),(2112789,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 11:05:47','',''),(2112806,'1','147','768',326,'Retail Sale Id 1256355',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 11:07:04','',''),(2112807,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 11:07:04','',''),(2112840,'1','147','768',326,'Retail Sale Id 1256371',998.40,0.00,0.00,0.00,998.40,'2021-12-01 11:08:51','',''),(2112841,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 11:08:51','',''),(2112997,'1','147','768',326,'Retail Sale Id 1256438',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 11:17:30','',''),(2112998,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:17:30','',''),(2113078,'1','147','768',326,'Retail Sale Id 1256477',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 11:22:40','',''),(2113079,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 11:22:41','',''),(2113100,'1','147','768',326,'Retail Sale Id 1256489',3001.60,0.00,0.00,0.00,3001.60,'2021-12-01 11:24:02','',''),(2113101,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 11:24:02','',''),(2113194,'1','147','768',326,'Retail Sale Id 1256533',3200.00,0.00,0.00,0.00,3200.00,'2021-12-01 11:29:34','',''),(2113195,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 11:29:34','',''),(2113226,'1','147','768',326,'Retail Sale Id 1256549',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 11:31:53','',''),(2113227,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:31:53','',''),(2113288,'1','147','768',326,'Retail Sale Id 1256587',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 11:37:10','',''),(2113289,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:37:10','',''),(2113386,'1','147','768',326,'Retail Sale Id 1256638',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 11:44:06','',''),(2113387,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 11:44:06','',''),(2113410,'1','147','768',326,'Retail Sale Id 1256648',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 11:46:08','',''),(2113411,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 11:46:08','',''),(2113425,'1','147','768',326,'Retail Sale Id 1256658',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 11:47:46','',''),(2113426,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:47:46','',''),(2113903,'1','147','768',326,'Retail Sale Id 1256908',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 12:25:56','',''),(2113904,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 12:25:56','',''),(2113923,'1','147','768',326,'Retail Sale Id 1256917',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 12:27:18','',''),(2113924,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 12:27:18','',''),(2113953,'1','147','768',326,'Retail Sale Id 1256931',998.40,0.00,0.00,0.00,998.40,'2021-12-01 12:29:22','',''),(2113954,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 12:29:22','',''),(2113967,'1','147','768',326,'Retail Sale Id 1256939',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 12:30:50','',''),(2113968,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:30:51','',''),(2113981,'1','147','768',326,'Retail Sale Id 1256945',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 12:32:19','',''),(2113982,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 12:32:19','',''),(2113993,'1','147','768',326,'Retail Sale Id 1256951',1952.00,0.00,0.00,0.00,1952.00,'2021-12-01 12:33:13','',''),(2113994,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 12:33:13','',''),(2114005,'1','147','768',326,'Retail Sale Id 1256958',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 12:34:14','',''),(2114006,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 12:34:14','',''),(2114015,'1','147','768',326,'Retail Sale Id 1256963',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 12:34:57','',''),(2114016,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 12:34:57','',''),(2114117,'1','147','768',326,'Retail Sale Id 1257014',998.40,0.00,0.00,0.00,998.40,'2021-12-01 12:46:40','',''),(2114118,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 12:46:40','',''),(2114180,'1','147','768',326,'Retail Sale Id 1257045',7001.60,0.00,0.00,0.00,7001.60,'2021-12-01 12:53:46','',''),(2114181,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-01 12:53:46','',''),(2114198,'1','147','768',326,'Retail Sale Id 1257057',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 12:55:21','',''),(2114199,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 12:55:21','',''),(2114212,'1','147','768',326,'Retail Sale Id 1257061',1702.40,0.00,0.00,0.00,1702.40,'2021-12-01 12:56:58','',''),(2114213,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-01 12:56:58','',''),(2114482,'1','147','768',326,'Retail Sale Id 1257230',4000.00,0.00,0.00,0.00,4000.00,'2021-12-01 13:15:53','',''),(2114483,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 13:15:53','',''),(2114498,'1','147','768',326,'Retail Sale Id 1257238',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 13:17:05','',''),(2114499,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 13:17:05','',''),(2114548,'1','147','768',326,'Retail Sale Id 1257266',998.40,0.00,0.00,0.00,998.40,'2021-12-01 13:21:31','',''),(2114549,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 13:21:31','',''),(2114568,'1','147','768',326,'Retail Sale Id 1257279',3001.60,0.00,0.00,0.00,3001.60,'2021-12-01 13:22:54','',''),(2114569,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 13:22:54','',''),(2114655,'1','147','768',326,'Retail Sale Id 1257314',998.40,0.00,0.00,0.00,998.40,'2021-12-01 13:30:13','',''),(2114656,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 13:30:13','',''),(2114683,'1','147','768',326,'Retail Sale Id 1257332',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 13:33:10','',''),(2114684,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:33:10','',''),(2114703,'1','147','768',326,'Retail Sale Id 1257342',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 13:34:40','',''),(2114704,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:34:40','',''),(2114800,'1','147','768',326,'Retail Sale Id 1257369',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 13:39:30','',''),(2114801,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 13:39:30','',''),(2114843,'1','147','768',326,'Retail Sale Id 1257379',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 13:41:17','',''),(2114844,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 13:41:17','',''),(2114886,'1','147','768',326,'Retail Sale Id 1257392',3200.00,0.00,0.00,0.00,3200.00,'2021-12-01 13:43:13','',''),(2114887,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 13:43:13','',''),(2114904,'1','147','768',326,'Retail Sale Id 1257401',4000.00,0.00,0.00,0.00,4000.00,'2021-12-01 13:44:43','',''),(2114905,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 13:44:43','',''),(2114940,'1','147','768',326,'Retail Sale Id 1257412',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 13:46:09','',''),(2114941,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 13:46:09','',''),(2114974,'1','147','768',326,'Retail Sale Id 1257423',7001.60,0.00,0.00,0.00,7001.60,'2021-12-01 13:48:30','',''),(2114975,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-01 13:48:30','',''),(2114976,'1','147','768',326,'Retail Sale Id 1257423',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 13:48:30','',''),(2114977,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:48:30','',''),(2114998,'1','147','768',326,'Retail Sale Id 1257432',32000.00,0.00,0.00,0.00,32000.00,'2021-12-01 13:49:50','',''),(2114999,'1','147','768',326,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 13:49:50','',''),(2115013,'1','147','768',326,'Retail Sale Id 1257441',3200.00,0.00,0.00,0.00,3200.00,'2021-12-01 13:50:54','',''),(2115014,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 13:50:54','',''),(2115035,'1','147','768',326,'Retail Sale Id 1257448',1299.20,0.00,0.00,0.00,1299.20,'2021-12-01 13:52:15','',''),(2115036,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 13:52:15','',''),(2115096,'1','147','768',326,'Retail Sale Id 1257478',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 13:55:05','',''),(2115097,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:55:05','',''),(2115120,'1','147','768',326,'Retail Sale Id 1257488',2502.40,0.00,0.00,0.00,2502.40,'2021-12-01 13:56:33','',''),(2115121,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 13:56:33','',''),(2115144,'1','147','768',326,'Retail Sale Id 1257503',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 13:58:05','',''),(2115145,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 13:58:05','',''),(2115178,'1','147','768',326,'Retail Sale Id 1257518',998.40,0.00,0.00,0.00,998.40,'2021-12-01 13:59:34','',''),(2115179,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 13:59:34','',''),(2115202,'1','147','768',326,'Retail Sale Id 1257530',4998.40,0.00,0.00,0.00,4998.40,'2021-12-01 14:00:43','',''),(2115203,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 14:00:43','',''),(2115231,'1','147','768',326,'Retail Sale Id 1257545',998.40,0.00,0.00,0.00,998.40,'2021-12-01 14:02:01','',''),(2115232,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 14:02:01','',''),(2115279,'1','147','768',326,'Retail Sale Id 1257567',3001.60,0.00,0.00,0.00,3001.60,'2021-12-01 14:04:36','',''),(2115280,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 14:04:36','',''),(2115307,'1','147','768',326,'Retail Sale Id 1257581',3500.80,0.00,0.00,0.00,3500.80,'2021-12-01 14:06:27','',''),(2115308,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 14:06:27','',''),(2115323,'1','147','768',326,'Retail Sale Id 1257589',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 14:07:34','',''),(2115324,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:07:34','',''),(2115353,'1','147','768',326,'Retail Sale Id 1257608',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 14:09:51','',''),(2115354,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 14:09:51','',''),(2115363,'1','147','768',326,'Retail Sale Id 1257613',4998.40,0.00,0.00,0.00,4998.40,'2021-12-01 14:10:38','',''),(2115364,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 14:10:38','',''),(2115389,'1','147','768',326,'Retail Sale Id 1257625',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 14:12:19','',''),(2115390,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 14:12:19','',''),(2115405,'1','147','768',326,'Retail Sale Id 1257639',2700.80,0.00,0.00,0.00,2700.80,'2021-12-01 14:13:18','',''),(2115406,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.22,0.00,'2021-12-01 14:13:18','',''),(2115447,'1','147','768',326,'Retail Sale Id 1257663',6400.00,0.00,0.00,0.00,6400.00,'2021-12-01 14:16:25','',''),(2115448,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 14:16:25','',''),(2115455,'1','147','768',326,'Retail Sale Id 1257668',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 14:17:04','',''),(2115456,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 14:17:04','',''),(2115465,'1','147','768',326,'Retail Sale Id 1257674',4000.00,0.00,0.00,0.00,4000.00,'2021-12-01 14:17:45','',''),(2115466,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 14:17:45','',''),(2115538,'1','147','768',326,'Retail Sale Id 1257702',1920.00,0.00,0.00,0.00,1920.00,'2021-12-01 14:22:21','',''),(2115539,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:22:21','',''),(2115550,'1','147','768',326,'Retail Sale Id 1257711',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 14:23:43','',''),(2115551,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:23:43','',''),(2115573,'1','147','768',326,'Retail Sale Id 1257732',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 14:25:21','',''),(2115574,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 14:25:21','',''),(2115601,'1','147','768',326,'Retail Sale Id 1257743',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 14:27:09','',''),(2115602,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 14:27:09','',''),(2115678,'1','147','768',326,'Retail Sale Id 1257780',3200.00,0.00,0.00,0.00,3200.00,'2021-12-01 14:32:39','',''),(2115679,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 14:32:39','',''),(2115724,'1','147','768',326,'Retail Sale Id 1257804',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 14:35:53','',''),(2115725,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 14:35:53','',''),(2115734,'1','147','768',326,'Retail Sale Id 1257809',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 14:36:35','',''),(2115735,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 14:36:35','',''),(2115742,'1','147','768',326,'Retail Sale Id 1257813',3001.60,0.00,0.00,0.00,3001.60,'2021-12-01 14:37:14','',''),(2115743,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 14:37:14','',''),(2115750,'1','147','768',326,'Retail Sale Id 1257819',499.20,0.00,0.00,0.00,499.20,'2021-12-01 14:37:52','',''),(2115751,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-01 14:37:52','',''),(2115766,'1','147','768',326,'Retail Sale Id 1257823',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 14:38:32','',''),(2115767,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 14:38:32','',''),(2115790,'1','147','768',326,'Retail Sale Id 1257838',998.40,0.00,0.00,0.00,998.40,'2021-12-01 14:40:49','',''),(2115791,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 14:40:49','',''),(2115827,'1','147','768',326,'Retail Sale Id 1257854',3500.80,0.00,0.00,0.00,3500.80,'2021-12-01 14:44:53','',''),(2115828,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 14:44:53','',''),(2115839,'1','147','768',326,'Retail Sale Id 1257861',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 14:46:12','',''),(2115840,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 14:46:12','',''),(2115863,'1','147','768',326,'Retail Sale Id 1257872',2803.20,0.00,0.00,0.00,2803.20,'2021-12-01 14:47:35','',''),(2115864,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-01 14:47:35','',''),(2116038,'1','147','768',326,'Retail Sale Id 1257926',902.40,0.00,0.00,0.00,902.40,'2021-12-01 14:54:32','',''),(2116039,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-01 14:54:32','',''),(2116060,'1','147','768',326,'Retail Sale Id 1257937',1900.80,0.00,0.00,0.00,1900.80,'2021-12-01 14:56:38','',''),(2116061,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-01 14:56:38','',''),(2116086,'1','147','768',326,'Retail Sale Id 1257948',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 14:58:27','',''),(2116087,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:58:27','',''),(2116134,'1','147','768',326,'Retail Sale Id 1257975',1952.00,0.00,0.00,0.00,1952.00,'2021-12-01 15:02:09','',''),(2116135,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 15:02:09','',''),(2116154,'1','147','768',326,'Retail Sale Id 1257985',3500.80,0.00,0.00,0.00,3500.80,'2021-12-01 15:03:28','',''),(2116155,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 15:03:28','',''),(2116170,'1','147','768',326,'Retail Sale Id 1257992',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 15:04:18','',''),(2116171,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 15:04:18','',''),(2116180,'1','147','768',326,'Retail Sale Id 1257998',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 15:05:33','',''),(2116181,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:05:33','',''),(2116192,'1','147','768',326,'Retail Sale Id 1258007',652.80,0.00,0.00,0.00,652.80,'2021-12-01 15:06:50','',''),(2116193,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-01 15:06:50','',''),(2116213,'1','147','768',326,'Retail Sale Id 1258017',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 15:08:35','',''),(2116214,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 15:08:35','',''),(2116257,'1','147','768',326,'Retail Sale Id 1258041',6400.00,0.00,0.00,0.00,6400.00,'2021-12-01 15:12:47','',''),(2116258,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 15:12:47','',''),(2116271,'1','147','768',326,'Retail Sale Id 1258049',3801.60,0.00,0.00,0.00,3801.60,'2021-12-01 15:13:46','',''),(2116272,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-01 15:13:46','',''),(2116302,'1','147','768',326,'Retail Sale Id 1258060',1952.00,0.00,0.00,0.00,1952.00,'2021-12-01 15:14:45','',''),(2116303,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 15:14:45','',''),(2116318,'1','147','768',326,'Retail Sale Id 1258068',998.40,0.00,0.00,0.00,998.40,'2021-12-01 15:15:54','',''),(2116319,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 15:15:54','',''),(2116388,'1','147','768',326,'Retail Sale Id 1258103',1299.20,0.00,0.00,0.00,1299.20,'2021-12-01 15:20:23','',''),(2116389,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 15:20:23','',''),(2116450,'1','147','768',326,'Retail Sale Id 1258129',998.40,0.00,0.00,0.00,998.40,'2021-12-01 15:23:38','',''),(2116451,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 15:23:38','',''),(2116469,'1','147','768',326,'Retail Sale Id 1258135',1900.80,0.00,0.00,0.00,1900.80,'2021-12-01 15:24:23','',''),(2116470,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-01 15:24:23','',''),(2116481,'1','147','768',326,'Retail Sale Id 1258141',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 15:25:02','',''),(2116482,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 15:25:02','',''),(2116491,'1','147','768',326,'Retail Sale Id 1258145',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 15:25:50','',''),(2116492,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 15:25:50','',''),(2116499,'1','147','768',326,'Retail Sale Id 1258149',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 15:26:35','',''),(2116500,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:26:35','',''),(2116509,'1','147','768',326,'Retail Sale Id 1258154',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 15:27:25','',''),(2116510,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:27:25','',''),(2116523,'1','147','768',326,'Retail Sale Id 1258163',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 15:28:19','',''),(2116524,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 15:28:19','',''),(2116559,'1','147','768',326,'Retail Sale Id 1258180',998.40,0.00,0.00,0.00,998.40,'2021-12-01 15:30:19','',''),(2116560,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 15:30:19','',''),(2116636,'1','147','768',326,'Retail Sale Id 1258222',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 15:35:47','',''),(2116637,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 15:35:47','',''),(2116664,'1','147','768',326,'Retail Sale Id 1258233',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 15:37:57','',''),(2116665,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:37:57','',''),(2116690,'1','147','768',326,'Retail Sale Id 1258246',7001.60,0.00,0.00,0.00,7001.60,'2021-12-01 15:39:29','',''),(2116691,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-01 15:39:29','',''),(2116710,'1','147','768',326,'Retail Sale Id 1258258',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 15:40:47','',''),(2116711,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:40:47','',''),(2116754,'1','147','768',326,'Retail Sale Id 1258277',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 15:43:39','',''),(2116755,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 15:43:39','',''),(2116788,'1','147','768',326,'Retail Sale Id 1258287',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 15:44:51','',''),(2116789,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 15:44:51','',''),(2116824,'1','147','768',326,'Retail Sale Id 1258303',4000.00,0.00,0.00,0.00,4000.00,'2021-12-01 15:46:31','',''),(2116825,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 15:46:31','',''),(2116850,'1','147','768',326,'Retail Sale Id 1258318',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 15:47:36','',''),(2116851,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 15:47:36','',''),(2116878,'1','147','768',326,'Retail Sale Id 1258332',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 15:48:54','',''),(2116879,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 15:48:54','',''),(2116904,'1','147','768',326,'Retail Sale Id 1258348',998.40,0.00,0.00,0.00,998.40,'2021-12-01 15:50:05','',''),(2116905,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 15:50:05','',''),(2116940,'1','147','768',326,'Retail Sale Id 1258362',1952.00,0.00,0.00,0.00,1952.00,'2021-12-01 15:51:18','',''),(2116941,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 15:51:18','',''),(2116978,'1','147','768',326,'Retail Sale Id 1258380',902.40,0.00,0.00,0.00,902.40,'2021-12-01 15:52:40','',''),(2116979,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-01 15:52:40','',''),(2117006,'1','147','768',326,'Retail Sale Id 1258395',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 15:53:50','',''),(2117007,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 15:53:50','',''),(2117039,'1','147','768',326,'Retail Sale Id 1258410',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 15:55:26','',''),(2117040,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 15:55:26','',''),(2117070,'1','147','768',326,'Retail Sale Id 1258421',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 15:56:27','',''),(2117071,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 15:56:27','',''),(2117098,'1','147','768',326,'Retail Sale Id 1258438',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 15:57:51','',''),(2117099,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 15:57:51','',''),(2117123,'1','147','768',326,'Retail Sale Id 1258450',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 15:59:06','',''),(2117124,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 15:59:06','',''),(2117161,'1','147','768',326,'Retail Sale Id 1258469',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 16:00:26','',''),(2117164,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:00:26','',''),(2117191,'1','147','768',326,'Retail Sale Id 1258482',2297.60,0.00,0.00,0.00,2297.60,'2021-12-01 16:01:46','',''),(2117192,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.59,0.00,'2021-12-01 16:01:46','',''),(2117211,'1','147','768',326,'Retail Sale Id 1258494',3200.00,0.00,0.00,0.00,3200.00,'2021-12-01 16:03:02','',''),(2117212,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:03:02','',''),(2117245,'1','147','768',326,'Retail Sale Id 1258510',998.40,0.00,0.00,0.00,998.40,'2021-12-01 16:04:36','',''),(2117246,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:04:36','',''),(2117273,'1','147','768',326,'Retail Sale Id 1258525',7001.60,0.00,0.00,0.00,7001.60,'2021-12-01 16:05:43','',''),(2117274,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-01 16:05:43','',''),(2117407,'1','147','768',326,'Retail Sale Id 1258576',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 16:10:41','',''),(2117408,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:10:41','',''),(2117561,'1','147','768',326,'Retail Sale Id 1258642',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 16:16:40','',''),(2117562,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 16:16:40','',''),(2117615,'1','147','768',326,'Retail Sale Id 1258674',3200.00,0.00,0.00,0.00,3200.00,'2021-12-01 16:19:03','',''),(2117616,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:19:03','',''),(2117724,'1','147','768',326,'Retail Sale Id 1258728',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 16:23:19','',''),(2117725,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:23:19','',''),(2117746,'1','147','768',326,'Retail Sale Id 1258741',998.40,0.00,0.00,0.00,998.40,'2021-12-01 16:24:28','',''),(2117747,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:24:28','',''),(2117790,'1','147','768',326,'Retail Sale Id 1258776',2803.20,0.00,0.00,0.00,2803.20,'2021-12-01 16:26:45','',''),(2117791,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-01 16:26:45','',''),(2117838,'1','147','768',326,'Retail Sale Id 1258798',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 16:28:57','',''),(2117839,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 16:28:57','',''),(2117866,'1','147','768',326,'Retail Sale Id 1258815',4000.00,0.00,0.00,0.00,4000.00,'2021-12-01 16:30:08','',''),(2117867,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 16:30:08','',''),(2117904,'1','147','768',326,'Retail Sale Id 1258834',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 16:31:59','',''),(2117905,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 16:31:59','',''),(2117932,'1','147','768',326,'Retail Sale Id 1258850',2598.40,0.00,0.00,0.00,2598.40,'2021-12-01 16:33:22','',''),(2117933,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-01 16:33:22','',''),(2118008,'1','147','768',326,'Retail Sale Id 1258892',998.40,0.00,0.00,0.00,998.40,'2021-12-01 16:37:16','',''),(2118009,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:37:16','',''),(2118028,'1','147','768',326,'Retail Sale Id 1258902',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 16:38:16','',''),(2118029,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 16:38:16','',''),(2118070,'1','147','768',326,'Retail Sale Id 1258922',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 16:40:10','',''),(2118071,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:40:10','',''),(2118102,'1','147','768',326,'Retail Sale Id 1258943',3001.60,0.00,0.00,0.00,3001.60,'2021-12-01 16:41:36','',''),(2118103,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 16:41:36','',''),(2118116,'1','147','768',326,'Retail Sale Id 1258951',998.40,0.00,0.00,0.00,998.40,'2021-12-01 16:42:43','',''),(2118117,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:42:43','',''),(2118138,'1','147','768',326,'Retail Sale Id 1258961',998.40,0.00,0.00,0.00,998.40,'2021-12-01 16:43:52','',''),(2118139,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:43:52','',''),(2118178,'1','147','768',326,'Retail Sale Id 1258974',7040.00,0.00,0.00,0.00,7040.00,'2021-12-01 16:45:40','',''),(2118179,'1','147','768',326,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-01 16:45:40','',''),(2118198,'1','147','768',326,'Retail Sale Id 1258993',3001.60,0.00,0.00,0.00,3001.60,'2021-12-01 16:47:04','',''),(2118199,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 16:47:04','',''),(2118224,'1','147','768',326,'Retail Sale Id 1259006',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 16:48:16','',''),(2118225,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 16:48:16','',''),(2118246,'1','147','768',326,'Retail Sale Id 1259019',4000.00,0.00,0.00,0.00,4000.00,'2021-12-01 16:49:26','',''),(2118247,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 16:49:26','',''),(2118262,'1','147','768',326,'Retail Sale Id 1259028',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 16:50:22','',''),(2118263,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:50:22','',''),(2118326,'1','147','768',326,'Retail Sale Id 1259058',1952.00,0.00,0.00,0.00,1952.00,'2021-12-01 16:53:07','',''),(2118327,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 16:53:07','',''),(2118375,'1','147','768',326,'Retail Sale Id 1259076',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 16:54:39','',''),(2118376,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:54:39','',''),(2118393,'1','147','768',326,'Retail Sale Id 1259087',998.40,0.00,0.00,0.00,998.40,'2021-12-01 16:55:37','',''),(2118394,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:55:37','',''),(2118422,'1','147','768',326,'Retail Sale Id 1259102',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 16:56:37','',''),(2118423,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:56:37','',''),(2118442,'1','147','768',326,'Retail Sale Id 1259112',4000.00,0.00,0.00,0.00,4000.00,'2021-12-01 16:57:42','',''),(2118443,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 16:57:42','',''),(2118470,'1','147','768',326,'Retail Sale Id 1259129',3001.60,0.00,0.00,0.00,3001.60,'2021-12-01 16:58:46','',''),(2118471,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 16:58:46','',''),(2118504,'1','147','768',326,'Retail Sale Id 1259142',800.00,0.00,0.00,0.00,800.00,'2021-12-01 17:00:12','',''),(2118505,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 17:00:12','',''),(2118562,'1','147','768',326,'Retail Sale Id 1259176',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 17:02:43','',''),(2118563,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:02:43','',''),(2118578,'1','147','768',326,'Retail Sale Id 1259183',998.40,0.00,0.00,0.00,998.40,'2021-12-01 17:03:45','',''),(2118579,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 17:03:45','',''),(2118604,'1','147','768',326,'Retail Sale Id 1259194',2201.60,0.00,0.00,0.00,2201.60,'2021-12-01 17:04:53','',''),(2118605,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.44,0.00,'2021-12-01 17:04:53','',''),(2118626,'1','147','768',326,'Retail Sale Id 1259203',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 17:05:57','',''),(2118627,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 17:05:57','',''),(2118650,'1','147','768',326,'Retail Sale Id 1259215',2502.40,0.00,0.00,0.00,2502.40,'2021-12-01 17:07:14','',''),(2118651,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 17:07:14','',''),(2118676,'1','147','768',326,'Retail Sale Id 1259227',1203.20,0.00,0.00,0.00,1203.20,'2021-12-01 17:08:21','',''),(2118677,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-01 17:08:21','',''),(2118692,'1','147','768',326,'Retail Sale Id 1259238',998.40,0.00,0.00,0.00,998.40,'2021-12-01 17:09:25','',''),(2118693,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 17:09:25','',''),(2118710,'1','147','768',326,'Retail Sale Id 1259246',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 17:10:26','',''),(2118711,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 17:10:26','',''),(2118728,'1','147','768',326,'Retail Sale Id 1259255',1497.60,0.00,0.00,0.00,1497.60,'2021-12-01 17:11:30','',''),(2118729,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 17:11:30','',''),(2118748,'1','147','768',326,'Retail Sale Id 1259265',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 17:12:39','',''),(2118749,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 17:12:39','',''),(2118768,'1','147','768',326,'Retail Sale Id 1259279',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 17:13:36','',''),(2118769,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 17:13:36','',''),(2118788,'1','147','768',326,'Retail Sale Id 1259288',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 17:14:43','',''),(2118789,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:14:43','',''),(2118814,'1','147','768',326,'Retail Sale Id 1259300',998.40,0.00,0.00,0.00,998.40,'2021-12-01 17:16:04','',''),(2118815,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 17:16:04','',''),(2118832,'1','147','768',326,'Retail Sale Id 1259308',998.40,0.00,0.00,0.00,998.40,'2021-12-01 17:17:15','',''),(2118833,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 17:17:15','',''),(2118844,'1','147','768',326,'Retail Sale Id 1259315',4998.40,0.00,0.00,0.00,4998.40,'2021-12-01 17:18:19','',''),(2118845,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 17:18:19','',''),(2118860,'1','147','768',326,'Retail Sale Id 1259324',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 17:19:20','',''),(2118861,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:19:20','',''),(2118882,'1','147','768',326,'Retail Sale Id 1259335',1299.20,0.00,0.00,0.00,1299.20,'2021-12-01 17:20:38','',''),(2118883,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 17:20:38','',''),(2118904,'1','147','768',326,'Retail Sale Id 1259346',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 17:22:08','',''),(2118905,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:22:08','',''),(2118922,'1','147','768',326,'Retail Sale Id 1259354',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 17:23:31','',''),(2118923,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:23:31','',''),(2118932,'1','147','768',326,'Retail Sale Id 1259361',998.40,0.00,0.00,0.00,998.40,'2021-12-01 17:24:25','',''),(2118933,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 17:24:25','',''),(2118950,'1','147','768',326,'Retail Sale Id 1259368',3200.00,0.00,0.00,0.00,3200.00,'2021-12-01 17:25:33','',''),(2118951,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 17:25:33','',''),(2118965,'1','147','768',326,'Retail Sale Id 1259375',3897.60,0.00,0.00,0.00,3897.60,'2021-12-01 17:26:43','',''),(2118966,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-01 17:26:43','',''),(2118981,'1','147','768',326,'Retail Sale Id 1259383',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 17:27:49','',''),(2118982,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 17:27:49','',''),(2119003,'1','147','768',326,'Retail Sale Id 1259394',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 17:29:11','',''),(2119004,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 17:29:11','',''),(2119019,'1','147','768',326,'Retail Sale Id 1259402',998.40,0.00,0.00,0.00,998.40,'2021-12-01 17:30:13','',''),(2119020,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 17:30:13','',''),(2119039,'1','147','768',326,'Retail Sale Id 1259412',3001.60,0.00,0.00,0.00,3001.60,'2021-12-01 17:31:18','',''),(2119040,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 17:31:18','',''),(2119053,'1','147','768',326,'Retail Sale Id 1259418',2598.40,0.00,0.00,0.00,2598.40,'2021-12-01 17:32:14','',''),(2119054,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-01 17:32:14','',''),(2119063,'1','147','768',326,'Retail Sale Id 1259423',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 17:32:56','',''),(2119064,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 17:32:56','',''),(2119111,'1','147','768',326,'Retail Sale Id 1259447',1952.00,0.00,0.00,0.00,1952.00,'2021-12-01 17:36:42','',''),(2119112,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 17:36:42','',''),(2119137,'1','147','768',326,'Retail Sale Id 1259460',3200.00,0.00,0.00,0.00,3200.00,'2021-12-01 17:38:55','',''),(2119138,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 17:38:55','',''),(2119183,'1','147','768',326,'Retail Sale Id 1259485',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 17:42:03','',''),(2119184,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:42:03','',''),(2119197,'1','147','768',326,'Retail Sale Id 1259492',4000.00,0.00,0.00,0.00,4000.00,'2021-12-01 17:43:02','',''),(2119198,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 17:43:02','',''),(2119205,'1','147','768',326,'Retail Sale Id 1259496',8000.00,0.00,0.00,0.00,8000.00,'2021-12-01 17:43:58','',''),(2119206,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:43:58','',''),(2119250,'1','147','768',326,'Retail Sale Id 1259515',499.20,0.00,0.00,0.00,499.20,'2021-12-01 17:47:10','',''),(2119251,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-01 17:47:10','',''),(2119260,'1','147','768',326,'Retail Sale Id 1259518',2003.20,0.00,0.00,0.00,2003.20,'2021-12-01 17:48:09','',''),(2119261,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 17:48:09','',''),(2119290,'1','147','768',326,'Retail Sale Id 1259533',499.20,0.00,0.00,0.00,499.20,'2021-12-01 17:52:32','',''),(2119291,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-01 17:52:32','',''),(2119577,'1','147','768',326,'Retail Sale Id 1259677',67500.80,0.00,0.00,0.00,67500.80,'2021-12-01 18:31:21','',''),(2119578,'1','147','768',326,'Retail sales',0.00,0.00,0.00,105.47,0.00,'2021-12-01 18:31:21','',''),(2120232,'1','147','768',326,'Retail Sale Id 1259775',1299.20,0.00,0.00,0.00,1299.20,'2021-12-02 05:24:31','',''),(2120233,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 05:24:31','',''),(2120234,'1','147','768',326,'Retail Sale Id 1259776',6502.40,0.00,0.00,0.00,6502.40,'2021-12-02 05:25:06','',''),(2120235,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-02 05:25:06','',''),(2120280,'1','147','768',326,'Retail Sale Id 1259795',9702.40,0.00,0.00,0.00,9702.40,'2021-12-02 05:50:44','',''),(2120281,'1','147','768',326,'Retail sales',0.00,0.00,0.00,15.16,0.00,'2021-12-02 05:50:44','',''),(2120285,'1','147','768',326,'Retail Sale Id 1259797',1900.80,0.00,0.00,0.00,1900.80,'2021-12-02 05:51:17','',''),(2120286,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-02 05:51:17','',''),(2120290,'1','147','768',326,'Retail Sale Id 1259799',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 05:52:14','',''),(2120291,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 05:52:14','',''),(2120317,'1','147','768',326,'Retail Sale Id 1259811',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 05:57:08','',''),(2120318,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 05:57:08','',''),(2120397,'1','147','768',326,'Retail Sale Id 1259851',3200.00,0.00,0.00,0.00,3200.00,'2021-12-02 06:04:31','',''),(2120398,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 06:04:31','',''),(2120407,'1','147','768',326,'Retail Sale Id 1259857',998.40,0.00,0.00,0.00,998.40,'2021-12-02 06:05:23','',''),(2120408,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 06:05:23','',''),(2120413,'1','147','768',326,'Retail Sale Id 1259861',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 06:05:58','',''),(2120414,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 06:05:58','',''),(2120429,'1','147','768',326,'Retail Sale Id 1259870',4000.00,0.00,0.00,0.00,4000.00,'2021-12-02 06:06:56','',''),(2120430,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 06:06:56','',''),(2120431,'1','147','768',326,'Retail Sale Id 1259871',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 06:07:45','',''),(2120432,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 06:07:45','',''),(2120439,'1','147','768',326,'Retail Sale Id 1259876',6003.20,0.00,0.00,0.00,6003.20,'2021-12-02 06:08:29','',''),(2120440,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 06:08:29','',''),(2120465,'1','147','768',326,'Retail Sale Id 1259888',3200.00,0.00,0.00,0.00,3200.00,'2021-12-02 06:11:03','',''),(2120466,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 06:11:03','',''),(2120522,'1','147','768',326,'Retail Sale Id 1259913',3001.60,0.00,0.00,0.00,3001.60,'2021-12-02 06:15:58','',''),(2120523,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 06:15:58','',''),(2120540,'1','147','768',326,'Retail Sale Id 1259924',5497.60,0.00,0.00,0.00,5497.60,'2021-12-02 06:17:30','',''),(2120541,'1','147','768',326,'Retail sales',0.00,0.00,0.00,8.59,0.00,'2021-12-02 06:17:30','',''),(2120596,'1','147','768',326,'Retail Sale Id 1259945',3001.60,0.00,0.00,0.00,3001.60,'2021-12-02 06:20:34','',''),(2120597,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 06:20:34','',''),(2120600,'1','147','768',326,'Retail Sale Id 1259947',3200.00,0.00,0.00,0.00,3200.00,'2021-12-02 06:21:09','',''),(2120601,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 06:21:09','',''),(2120612,'1','147','768',326,'Retail Sale Id 1259953',2297.60,0.00,0.00,0.00,2297.60,'2021-12-02 06:21:56','',''),(2120613,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.59,0.00,'2021-12-02 06:21:56','',''),(2120624,'1','147','768',326,'Retail Sale Id 1259959',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 06:23:02','',''),(2120625,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 06:23:02','',''),(2120632,'1','147','768',326,'Retail Sale Id 1259964',3200.00,0.00,0.00,0.00,3200.00,'2021-12-02 06:23:42','',''),(2120633,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 06:23:42','',''),(2120662,'1','147','768',326,'Retail Sale Id 1259979',4000.00,0.00,0.00,0.00,4000.00,'2021-12-02 06:26:02','',''),(2120663,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 06:26:02','',''),(2120674,'1','147','768',326,'Retail Sale Id 1259985',2502.40,0.00,0.00,0.00,2502.40,'2021-12-02 06:27:13','',''),(2120675,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 06:27:13','',''),(2120706,'1','147','768',326,'Retail Sale Id 1260001',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 06:29:48','',''),(2120707,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 06:29:48','',''),(2120722,'1','147','768',326,'Retail Sale Id 1260012',697.60,0.00,0.00,0.00,697.60,'2021-12-02 06:30:58','',''),(2120723,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 06:30:58','',''),(2120734,'1','147','768',326,'Retail Sale Id 1260019',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 06:31:48','',''),(2120735,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 06:31:48','',''),(2120756,'1','147','768',326,'Retail Sale Id 1260026',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 06:33:02','',''),(2120757,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 06:33:03','',''),(2121062,'1','147','768',326,'Retail Sale Id 1260134',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 06:48:07','',''),(2121063,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 06:48:07','',''),(2121102,'1','147','768',326,'Retail Sale Id 1260157',3200.00,0.00,0.00,0.00,3200.00,'2021-12-02 06:50:19','',''),(2121103,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 06:50:19','',''),(2121114,'1','147','768',326,'Retail Sale Id 1260163',4998.40,0.00,0.00,0.00,4998.40,'2021-12-02 06:51:07','',''),(2121115,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 06:51:07','',''),(2121126,'1','147','768',326,'Retail Sale Id 1260167',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 06:51:46','',''),(2121127,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 06:51:46','',''),(2121136,'1','147','768',326,'Retail Sale Id 1260175',2502.40,0.00,0.00,0.00,2502.40,'2021-12-02 06:52:29','',''),(2121137,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 06:52:29','',''),(2121196,'1','147','768',326,'Retail Sale Id 1260197',800.00,0.00,0.00,0.00,800.00,'2021-12-02 06:56:12','',''),(2121197,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-02 06:56:12','',''),(2121226,'1','147','768',326,'Retail Sale Id 1260208',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 06:57:30','',''),(2121227,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 06:57:30','',''),(2121248,'1','147','768',326,'Retail Sale Id 1260216',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 06:59:19','',''),(2121249,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 06:59:19','',''),(2121268,'1','147','768',326,'Retail Sale Id 1260231',499.20,0.00,0.00,0.00,499.20,'2021-12-02 07:00:15','',''),(2121269,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-02 07:00:15','',''),(2121282,'1','147','768',326,'Retail Sale Id 1260236',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 07:00:58','',''),(2121283,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:00:58','',''),(2121300,'1','147','768',326,'Retail Sale Id 1260245',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 07:02:31','',''),(2121301,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 07:02:31','',''),(2121338,'1','147','768',326,'Retail Sale Id 1260266',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 07:04:26','',''),(2121339,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:04:26','',''),(2121348,'1','147','768',326,'Retail Sale Id 1260269',998.40,0.00,0.00,0.00,998.40,'2021-12-02 07:05:13','',''),(2121349,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 07:05:13','',''),(2121370,'1','147','768',326,'Retail Sale Id 1260281',1299.20,0.00,0.00,0.00,1299.20,'2021-12-02 07:06:09','',''),(2121371,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 07:06:09','',''),(2121380,'1','147','768',326,'Retail Sale Id 1260287',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 07:06:48','',''),(2121381,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 07:06:48','',''),(2121414,'1','147','768',326,'Retail Sale Id 1260308',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 07:08:39','',''),(2121415,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 07:08:39','',''),(2121453,'1','147','768',326,'Retail Sale Id 1260318',601.60,0.00,0.00,0.00,601.60,'2021-12-02 07:10:18','',''),(2121454,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.94,0.00,'2021-12-02 07:10:18','',''),(2121494,'1','147','768',326,'Retail Sale Id 1260325',998.40,0.00,0.00,0.00,998.40,'2021-12-02 07:11:13','',''),(2121495,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 07:11:14','',''),(2121508,'1','147','768',326,'Retail Sale Id 1260332',6003.20,0.00,0.00,0.00,6003.20,'2021-12-02 07:12:06','',''),(2121509,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 07:12:06','',''),(2121520,'1','147','768',326,'Retail Sale Id 1260338',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 07:12:49','',''),(2121521,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 07:12:49','',''),(2121595,'1','147','768',326,'Retail Sale Id 1260378',3001.60,0.00,0.00,0.00,3001.60,'2021-12-02 07:17:04','',''),(2121596,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 07:17:04','',''),(2121613,'1','147','768',326,'Retail Sale Id 1260387',3200.00,0.00,0.00,0.00,3200.00,'2021-12-02 07:17:44','',''),(2121614,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 07:17:44','',''),(2121631,'1','147','768',326,'Retail Sale Id 1260398',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 07:18:35','',''),(2121632,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:18:35','',''),(2121673,'1','147','768',326,'Retail Sale Id 1260414',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 07:20:48','',''),(2121674,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:20:48','',''),(2121694,'1','147','768',326,'Retail Sale Id 1260422',3001.60,0.00,0.00,0.00,3001.60,'2021-12-02 07:21:39','',''),(2121695,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 07:21:39','',''),(2121769,'1','147','768',326,'Retail Sale Id 1260462',1900.80,0.00,0.00,0.00,1900.80,'2021-12-02 07:25:13','',''),(2121770,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-02 07:25:13','',''),(2121801,'1','147','768',326,'Retail Sale Id 1260475',6400.00,0.00,0.00,0.00,6400.00,'2021-12-02 07:26:54','',''),(2121802,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 07:26:54','',''),(2121831,'1','147','768',326,'Retail Sale Id 1260493',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 07:28:33','',''),(2121832,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 07:28:33','',''),(2121869,'1','147','768',326,'Retail Sale Id 1260517',1600.00,0.00,0.00,0.00,1600.00,'2021-12-02 07:30:26','',''),(2121870,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-02 07:30:26','',''),(2121887,'1','147','768',326,'Retail Sale Id 1260528',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 07:31:26','',''),(2121888,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:31:26','',''),(2121947,'1','147','768',326,'Retail Sale Id 1260570',1299.20,0.00,0.00,0.00,1299.20,'2021-12-02 07:35:22','',''),(2121948,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 07:35:22','',''),(2121973,'1','147','768',326,'Retail Sale Id 1260583',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 07:36:55','',''),(2121974,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:36:55','',''),(2122112,'1','147','768',326,'Retail Sale Id 1260653',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 07:42:14','',''),(2122113,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 07:42:14','',''),(2122124,'1','147','768',326,'Retail Sale Id 1260661',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 07:42:54','',''),(2122125,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:42:54','',''),(2122173,'1','147','768',326,'Retail Sale Id 1260685',3200.00,0.00,0.00,0.00,3200.00,'2021-12-02 07:45:50','',''),(2122174,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 07:45:50','',''),(2122223,'1','147','768',326,'Retail Sale Id 1260713',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 07:48:42','',''),(2122224,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 07:48:42','',''),(2122315,'1','147','768',326,'Retail Sale Id 1260742',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 07:50:52','',''),(2122316,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 07:50:52','',''),(2122355,'1','147','768',326,'Retail Sale Id 1260764',998.40,0.00,0.00,0.00,998.40,'2021-12-02 07:52:28','',''),(2122356,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 07:52:28','',''),(2122412,'1','147','768',326,'Retail Sale Id 1260792',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 07:54:58','',''),(2122413,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 07:54:58','',''),(2122454,'1','147','768',326,'Retail Sale Id 1260809',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 07:56:19','',''),(2122455,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 07:56:19','',''),(2122512,'1','147','768',326,'Retail Sale Id 1260833',1299.20,0.00,0.00,0.00,1299.20,'2021-12-02 07:58:26','',''),(2122513,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 07:58:26','',''),(2122551,'1','147','768',326,'Retail Sale Id 1260849',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 07:59:28','',''),(2122552,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 07:59:28','',''),(2122578,'1','147','768',326,'Retail Sale Id 1260863',1401.60,0.00,0.00,0.00,1401.60,'2021-12-02 08:00:34','',''),(2122579,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-02 08:00:34','',''),(2122603,'1','147','768',326,'Retail Sale Id 1260872',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 08:02:00','',''),(2122604,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 08:02:00','',''),(2122635,'1','147','768',326,'Retail Sale Id 1260887',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 08:03:47','',''),(2122636,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:03:47','',''),(2122667,'1','147','768',326,'Retail Sale Id 1260906',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 08:05:07','',''),(2122668,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:05:07','',''),(2122705,'1','147','768',326,'Retail Sale Id 1260920',998.40,0.00,0.00,0.00,998.40,'2021-12-02 08:06:37','',''),(2122706,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 08:06:37','',''),(2122721,'1','147','768',326,'Retail Sale Id 1260931',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 08:07:36','',''),(2122722,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 08:07:36','',''),(2122769,'1','147','768',326,'Retail Sale Id 1260957',998.40,0.00,0.00,0.00,998.40,'2021-12-02 08:10:30','',''),(2122770,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 08:10:30','',''),(2122797,'1','147','768',326,'Retail Sale Id 1260972',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 08:11:53','',''),(2122798,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 08:11:53','',''),(2122817,'1','147','768',326,'Retail Sale Id 1260985',3097.60,0.00,0.00,0.00,3097.60,'2021-12-02 08:13:20','',''),(2122818,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.84,0.00,'2021-12-02 08:13:20','',''),(2122862,'1','147','768',326,'Retail Sale Id 1261008',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 08:15:56','',''),(2122863,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 08:15:56','',''),(2122894,'1','147','768',326,'Retail Sale Id 1261024',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 08:17:36','',''),(2122895,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:17:37','',''),(2122934,'1','147','768',326,'Retail Sale Id 1261047',4000.00,0.00,0.00,0.00,4000.00,'2021-12-02 08:19:30','',''),(2122935,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 08:19:30','',''),(2122966,'1','147','768',326,'Retail Sale Id 1261063',3001.60,0.00,0.00,0.00,3001.60,'2021-12-02 08:20:49','',''),(2122967,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 08:20:49','',''),(2122986,'1','147','768',326,'Retail Sale Id 1261072',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 08:22:01','',''),(2122987,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 08:22:01','',''),(2123013,'1','147','768',326,'Retail Sale Id 1261086',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 08:23:14','',''),(2123014,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 08:23:14','',''),(2123049,'1','147','768',326,'Retail Sale Id 1261102',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 08:24:41','',''),(2123050,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 08:24:41','',''),(2123077,'1','147','768',326,'Retail Sale Id 1261117',998.40,0.00,0.00,0.00,998.40,'2021-12-02 08:26:19','',''),(2123078,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 08:26:19','',''),(2123121,'1','147','768',326,'Retail Sale Id 1261133',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 08:28:27','',''),(2123122,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 08:28:27','',''),(2123141,'1','147','768',326,'Retail Sale Id 1261149',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 08:29:50','',''),(2123142,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 08:29:50','',''),(2123165,'1','147','768',326,'Retail Sale Id 1261159',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 08:30:56','',''),(2123166,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 08:30:56','',''),(2123175,'1','147','768',326,'Retail Sale Id 1261166',998.40,0.00,0.00,0.00,998.40,'2021-12-02 08:31:58','',''),(2123176,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 08:31:58','',''),(2123237,'1','147','768',326,'Retail Sale Id 1261198',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 08:35:15','',''),(2123238,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:35:15','',''),(2123271,'1','147','768',326,'Retail Sale Id 1261214',3001.60,0.00,0.00,0.00,3001.60,'2021-12-02 08:37:12','',''),(2123272,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 08:37:12','',''),(2123321,'1','147','768',326,'Retail Sale Id 1261223',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 08:38:51','',''),(2123322,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 08:38:51','',''),(2123379,'1','147','768',326,'Retail Sale Id 1261245',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 08:40:48','',''),(2123382,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 08:40:48','',''),(2123397,'1','147','768',326,'Retail Sale Id 1261257',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 08:41:49','',''),(2123398,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 08:41:49','',''),(2123419,'1','147','768',326,'Retail Sale Id 1261269',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 08:43:01','',''),(2123420,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 08:43:01','',''),(2123447,'1','147','768',326,'Retail Sale Id 1261284',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 08:44:23','',''),(2123448,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:44:23','',''),(2123465,'1','147','768',326,'Retail Sale Id 1261293',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 08:45:36','',''),(2123466,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 08:45:36','',''),(2123491,'1','147','768',326,'Retail Sale Id 1261304',3200.00,0.00,0.00,0.00,3200.00,'2021-12-02 08:46:59','',''),(2123492,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:46:59','',''),(2123513,'1','147','768',326,'Retail Sale Id 1261316',4998.40,0.00,0.00,0.00,4998.40,'2021-12-02 08:48:57','',''),(2123514,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 08:48:57','',''),(2123568,'1','147','768',326,'Retail Sale Id 1261341',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 08:52:23','',''),(2123570,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 08:52:23','',''),(2123593,'1','147','768',326,'Retail Sale Id 1261356',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 08:53:45','',''),(2123594,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 08:53:45','',''),(2123773,'1','147','768',326,'Retail Sale Id 1261462',2502.40,0.00,0.00,0.00,2502.40,'2021-12-02 09:03:08','',''),(2123774,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 09:03:08','',''),(2123805,'1','147','768',326,'Retail Sale Id 1261472',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 09:04:32','',''),(2123806,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:04:32','',''),(2123831,'1','147','768',326,'Retail Sale Id 1261486',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 09:05:52','',''),(2123832,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 09:05:52','',''),(2123859,'1','147','768',326,'Retail Sale Id 1261505',998.40,0.00,0.00,0.00,998.40,'2021-12-02 09:07:04','',''),(2123860,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 09:07:04','',''),(2123899,'1','147','768',326,'Retail Sale Id 1261525',998.40,0.00,0.00,0.00,998.40,'2021-12-02 09:08:51','',''),(2123900,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 09:08:51','',''),(2123967,'1','147','768',326,'Retail Sale Id 1261552',998.40,0.00,0.00,0.00,998.40,'2021-12-02 09:11:46','',''),(2123968,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 09:11:46','',''),(2124015,'1','147','768',326,'Retail Sale Id 1261577',1600.00,0.00,0.00,0.00,1600.00,'2021-12-02 09:14:23','',''),(2124016,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-02 09:14:23','',''),(2124052,'1','147','768',326,'Retail Sale Id 1261585',998.40,0.00,0.00,0.00,998.40,'2021-12-02 09:15:42','',''),(2124053,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 09:15:42','',''),(2124106,'1','147','768',326,'Retail Sale Id 1261601',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 09:17:15','',''),(2124107,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:17:15','',''),(2124140,'1','147','768',326,'Retail Sale Id 1261618',1299.20,0.00,0.00,0.00,1299.20,'2021-12-02 09:19:06','',''),(2124141,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 09:19:06','',''),(2124162,'1','147','768',326,'Retail Sale Id 1261629',4000.00,0.00,0.00,0.00,4000.00,'2021-12-02 09:20:24','',''),(2124163,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 09:20:24','',''),(2124188,'1','147','768',326,'Retail Sale Id 1261643',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 09:22:15','',''),(2124189,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 09:22:15','',''),(2124212,'1','147','768',326,'Retail Sale Id 1261656',2502.40,0.00,0.00,0.00,2502.40,'2021-12-02 09:23:23','',''),(2124213,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 09:23:23','',''),(2124240,'1','147','768',326,'Retail Sale Id 1261673',3200.00,0.00,0.00,0.00,3200.00,'2021-12-02 09:24:45','',''),(2124241,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:24:45','',''),(2124255,'1','147','768',326,'Retail Sale Id 1261680',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 09:26:00','',''),(2124257,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 09:26:00','',''),(2124296,'1','147','768',326,'Retail Sale Id 1261698',640.00,0.00,0.00,0.00,640.00,'2021-12-02 09:28:28','',''),(2124297,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-02 09:28:28','',''),(2124316,'1','147','768',326,'Retail Sale Id 1261708',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 09:29:38','',''),(2124317,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 09:29:38','',''),(2124336,'1','147','768',326,'Retail Sale Id 1261716',4998.40,0.00,0.00,0.00,4998.40,'2021-12-02 09:30:49','',''),(2124337,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 09:30:49','',''),(2124358,'1','147','768',326,'Retail Sale Id 1261728',3001.60,0.00,0.00,0.00,3001.60,'2021-12-02 09:31:48','',''),(2124359,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 09:31:48','',''),(2124382,'1','147','768',326,'Retail Sale Id 1261739',3200.00,0.00,0.00,0.00,3200.00,'2021-12-02 09:33:22','',''),(2124383,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:33:22','',''),(2124395,'1','147','768',326,'Retail Sale Id 1261746',3200.00,0.00,0.00,0.00,3200.00,'2021-12-02 09:34:38','',''),(2124396,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:34:38','',''),(2124413,'1','147','768',326,'Retail Sale Id 1261757',998.40,0.00,0.00,0.00,998.40,'2021-12-02 09:35:41','',''),(2124414,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 09:35:41','',''),(2124421,'1','147','768',326,'Retail Sale Id 1261762',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 09:36:55','',''),(2124422,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:36:55','',''),(2124435,'1','147','768',326,'Retail Sale Id 1261768',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 09:38:11','',''),(2124436,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 09:38:11','',''),(2124449,'1','147','768',326,'Retail Sale Id 1261775',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 09:39:26','',''),(2124450,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 09:39:26','',''),(2124459,'1','147','768',326,'Retail Sale Id 1261781',4998.40,0.00,0.00,0.00,4998.40,'2021-12-02 09:40:08','',''),(2124460,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 09:40:08','',''),(2124471,'1','147','768',326,'Retail Sale Id 1261787',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 09:40:44','',''),(2124472,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:40:44','',''),(2124491,'1','147','768',326,'Retail Sale Id 1261798',1299.20,0.00,0.00,0.00,1299.20,'2021-12-02 09:41:54','',''),(2124492,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 09:41:54','',''),(2124503,'1','147','768',326,'Retail Sale Id 1261804',998.40,0.00,0.00,0.00,998.40,'2021-12-02 09:42:26','',''),(2124504,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 09:42:26','',''),(2124616,'1','147','768',326,'Retail Sale Id 1261855',4998.40,0.00,0.00,0.00,4998.40,'2021-12-02 09:48:32','',''),(2124617,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 09:48:32','',''),(2124787,'1','147','768',326,'Retail Sale Id 1261954',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 09:56:27','',''),(2124788,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 09:56:27','',''),(2124879,'1','147','768',326,'Retail Sale Id 1262001',1299.20,0.00,0.00,0.00,1299.20,'2021-12-02 10:01:27','',''),(2124880,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 10:01:27','',''),(2124921,'1','147','768',326,'Retail Sale Id 1262019',998.40,0.00,0.00,0.00,998.40,'2021-12-02 10:03:05','',''),(2124922,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 10:03:05','',''),(2124943,'1','147','768',326,'Retail Sale Id 1262031',4000.00,0.00,0.00,0.00,4000.00,'2021-12-02 10:04:15','',''),(2124944,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 10:04:15','',''),(2124959,'1','147','768',326,'Retail Sale Id 1262036',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 10:05:20','',''),(2124960,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 10:05:20','',''),(2125079,'1','147','768',326,'Retail Sale Id 1262102',998.40,0.00,0.00,0.00,998.40,'2021-12-02 10:13:04','',''),(2125080,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 10:13:04','',''),(2125104,'1','147','768',326,'Retail Sale Id 1262116',3001.60,0.00,0.00,0.00,3001.60,'2021-12-02 10:14:40','',''),(2125105,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 10:14:40','',''),(2125120,'1','147','768',326,'Retail Sale Id 1262123',998.40,0.00,0.00,0.00,998.40,'2021-12-02 10:15:37','',''),(2125121,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 10:15:37','',''),(2125158,'1','147','768',326,'Retail Sale Id 1262142',499.20,0.00,0.00,0.00,499.20,'2021-12-02 10:17:35','',''),(2125159,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-02 10:17:35','',''),(2125190,'1','147','768',326,'Retail Sale Id 1262160',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 10:19:28','',''),(2125191,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 10:19:28','',''),(2125323,'1','147','768',326,'Retail Sale Id 1262220',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 10:26:03','',''),(2125324,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 10:26:03','',''),(2125368,'1','147','768',326,'Retail Sale Id 1262246',998.40,0.00,0.00,0.00,998.40,'2021-12-02 10:29:08','',''),(2125369,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 10:29:08','',''),(2125410,'1','147','768',326,'Retail Sale Id 1262266',4000.00,0.00,0.00,0.00,4000.00,'2021-12-02 10:31:57','',''),(2125411,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 10:31:57','',''),(2125426,'1','147','768',326,'Retail Sale Id 1262274',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 10:33:11','',''),(2125427,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:33:11','',''),(2125454,'1','147','768',326,'Retail Sale Id 1262290',2502.40,0.00,0.00,0.00,2502.40,'2021-12-02 10:34:34','',''),(2125455,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 10:34:34','',''),(2125474,'1','147','768',326,'Retail Sale Id 1262299',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 10:35:42','',''),(2125475,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:35:42','',''),(2125534,'1','147','768',326,'Retail Sale Id 1262326',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 10:39:20','',''),(2125535,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:39:20','',''),(2125601,'1','147','768',326,'Retail Sale Id 1262359',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 10:43:40','',''),(2125602,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:43:40','',''),(2125654,'1','147','768',326,'Retail Sale Id 1262387',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 10:46:09','',''),(2125655,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:46:09','',''),(2125676,'1','147','768',326,'Retail Sale Id 1262396',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 10:47:51','',''),(2125677,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:47:51','',''),(2125738,'1','147','768',326,'Retail Sale Id 1262417',6400.00,0.00,0.00,0.00,6400.00,'2021-12-02 10:51:45','',''),(2125739,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 10:51:45','',''),(2125762,'1','147','768',326,'Retail Sale Id 1262434',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 10:53:35','',''),(2125763,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:53:35','',''),(2125784,'1','147','768',326,'Retail Sale Id 1262443',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 10:55:06','',''),(2125785,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 10:55:06','',''),(2125844,'1','147','768',326,'Retail Sale Id 1262478',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 10:59:54','',''),(2125845,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 10:59:54','',''),(2125866,'1','147','768',326,'Retail Sale Id 1262491',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 11:01:25','',''),(2125867,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 11:01:25','',''),(2125902,'1','147','768',326,'Retail Sale Id 1262511',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 11:03:11','',''),(2125903,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 11:03:11','',''),(2125952,'1','147','768',326,'Retail Sale Id 1262540',3001.60,0.00,0.00,0.00,3001.60,'2021-12-02 11:06:13','',''),(2125953,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 11:06:13','',''),(2125972,'1','147','768',326,'Retail Sale Id 1262550',2598.40,0.00,0.00,0.00,2598.40,'2021-12-02 11:07:39','',''),(2125973,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-02 11:07:39','',''),(2126016,'1','147','768',326,'Retail Sale Id 1262575',6003.20,0.00,0.00,0.00,6003.20,'2021-12-02 11:10:39','',''),(2126017,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 11:10:39','',''),(2126066,'1','147','768',326,'Retail Sale Id 1262596',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 11:13:11','',''),(2126067,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 11:13:11','',''),(2126128,'1','147','768',326,'Retail Sale Id 1262637',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 11:16:43','',''),(2126129,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 11:16:43','',''),(2126156,'1','147','768',326,'Retail Sale Id 1262651',6400.00,0.00,0.00,0.00,6400.00,'2021-12-02 11:18:31','',''),(2126157,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 11:18:31','',''),(2126206,'1','147','768',326,'Retail Sale Id 1262682',697.60,0.00,0.00,0.00,697.60,'2021-12-02 11:21:05','',''),(2126207,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 11:21:05','',''),(2126302,'1','147','768',326,'Retail Sale Id 1262725',998.40,0.00,0.00,0.00,998.40,'2021-12-02 11:27:21','',''),(2126303,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 11:27:21','',''),(2126350,'1','147','768',326,'Retail Sale Id 1262752',1798.40,0.00,0.00,0.00,1798.40,'2021-12-02 11:29:20','',''),(2126351,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-02 11:29:20','',''),(2126409,'1','147','768',326,'Retail Sale Id 1262776',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 11:31:38','',''),(2126410,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 11:31:38','',''),(2126474,'1','147','768',326,'Retail Sale Id 1262798',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 11:34:38','',''),(2126475,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 11:34:38','',''),(2126617,'1','147','768',326,'Retail Sale Id 1262855',1702.40,0.00,0.00,0.00,1702.40,'2021-12-02 11:41:53','',''),(2126618,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-02 11:41:53','',''),(2126639,'1','147','768',326,'Retail Sale Id 1262866',998.40,0.00,0.00,0.00,998.40,'2021-12-02 11:43:18','',''),(2126640,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 11:43:18','',''),(2126653,'1','147','768',326,'Retail Sale Id 1262871',3200.00,0.00,0.00,0.00,3200.00,'2021-12-02 11:44:40','',''),(2126654,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 11:44:40','',''),(2126667,'1','147','768',326,'Retail Sale Id 1262879',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 11:46:02','',''),(2126668,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 11:46:02','',''),(2126679,'1','147','768',326,'Retail Sale Id 1262885',3200.00,0.00,0.00,0.00,3200.00,'2021-12-02 11:47:23','',''),(2126680,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 11:47:23','',''),(2126699,'1','147','768',326,'Retail Sale Id 1262895',6400.00,0.00,0.00,0.00,6400.00,'2021-12-02 11:48:56','',''),(2126700,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 11:48:56','',''),(2126721,'1','147','768',326,'Retail Sale Id 1262908',4000.00,0.00,0.00,0.00,4000.00,'2021-12-02 11:50:47','',''),(2126722,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 11:50:47','',''),(2126830,'1','147','768',326,'Retail Sale Id 1262968',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 11:58:55','',''),(2126831,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 11:58:55','',''),(2126855,'1','147','768',326,'Retail Sale Id 1262979',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 12:01:07','',''),(2126856,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:01:07','',''),(2126920,'1','147','768',326,'Retail Sale Id 1263014',3302.40,0.00,0.00,0.00,3302.40,'2021-12-02 12:07:21','',''),(2126921,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.16,0.00,'2021-12-02 12:07:21','',''),(2126956,'1','147','768',326,'Retail Sale Id 1263031',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 12:10:11','',''),(2126957,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 12:10:11','',''),(2126985,'1','147','768',326,'Retail Sale Id 1263045',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 12:12:53','',''),(2126986,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 12:12:53','',''),(2126987,'1','147','768',326,'Retail Sale Id 1263047',4998.40,0.00,0.00,0.00,4998.40,'2021-12-02 12:13:28','',''),(2126988,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 12:13:28','',''),(2127001,'1','147','768',326,'Retail Sale Id 1263054',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 12:14:32','',''),(2127002,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 12:14:32','',''),(2127007,'1','147','768',326,'Retail Sale Id 1263056',2502.40,0.00,0.00,0.00,2502.40,'2021-12-02 12:15:15','',''),(2127008,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 12:15:15','',''),(2127013,'1','147','768',326,'Retail Sale Id 1263059',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 12:15:43','',''),(2127014,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 12:15:43','',''),(2127072,'1','147','768',326,'Retail Sale Id 1263090',4000.00,0.00,0.00,0.00,4000.00,'2021-12-02 12:21:04','',''),(2127073,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 12:21:04','',''),(2127128,'1','147','768',326,'Retail Sale Id 1263117',4998.40,0.00,0.00,0.00,4998.40,'2021-12-02 12:25:06','',''),(2127129,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 12:25:06','',''),(2127150,'1','147','768',326,'Retail Sale Id 1263129',1299.20,0.00,0.00,0.00,1299.20,'2021-12-02 12:26:06','',''),(2127151,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 12:26:06','',''),(2127232,'1','147','768',326,'Retail Sale Id 1263189',32000.00,0.00,0.00,0.00,32000.00,'2021-12-02 12:32:12','',''),(2127233,'1','147','768',326,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 12:32:12','',''),(2127326,'1','147','768',326,'Retail Sale Id 1263242',1798.40,0.00,0.00,0.00,1798.40,'2021-12-02 12:39:24','',''),(2127327,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-02 12:39:24','',''),(2127414,'1','147','768',326,'Retail Sale Id 1263280',4000.00,0.00,0.00,0.00,4000.00,'2021-12-02 12:47:10','',''),(2127415,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 12:47:10','',''),(2127522,'1','147','768',326,'Retail Sale Id 1263324',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 12:54:26','',''),(2127523,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:54:26','',''),(2127550,'1','147','768',326,'Retail Sale Id 1263335',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 12:57:32','',''),(2127551,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 12:57:32','',''),(2127564,'1','147','768',326,'Retail Sale Id 1263343',6003.20,0.00,0.00,0.00,6003.20,'2021-12-02 12:58:23','',''),(2127565,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 12:58:23','',''),(2127596,'1','147','768',326,'Retail Sale Id 1263360',1203.20,0.00,0.00,0.00,1203.20,'2021-12-02 13:00:28','',''),(2127597,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-02 13:00:28','',''),(2127616,'1','147','768',326,'Retail Sale Id 1263370',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 13:01:23','',''),(2127617,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 13:01:23','',''),(2127644,'1','147','768',326,'Retail Sale Id 1263384',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 13:02:56','',''),(2127645,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 13:02:56','',''),(2127686,'1','147','768',326,'Retail Sale Id 1263407',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 13:06:44','',''),(2127687,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:06:44','',''),(2127742,'1','147','768',326,'Retail Sale Id 1263435',2502.40,0.00,0.00,0.00,2502.40,'2021-12-02 13:11:04','',''),(2127743,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 13:11:04','',''),(2127758,'1','147','768',326,'Retail Sale Id 1263443',6400.00,0.00,0.00,0.00,6400.00,'2021-12-02 13:12:03','',''),(2127759,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 13:12:03','',''),(2127891,'1','147','768',326,'Retail Sale Id 1263493',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 13:18:57','',''),(2127892,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 13:18:57','',''),(2127907,'1','147','768',326,'Retail Sale Id 1263502',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 13:20:23','',''),(2127908,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 13:20:23','',''),(2127945,'1','147','768',326,'Retail Sale Id 1263518',998.40,0.00,0.00,0.00,998.40,'2021-12-02 13:23:37','',''),(2127946,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 13:23:37','',''),(2127957,'1','147','768',326,'Retail Sale Id 1263526',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 13:24:22','',''),(2127958,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 13:24:22','',''),(2128005,'1','147','768',326,'Retail Sale Id 1263538',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 13:27:04','',''),(2128006,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 13:27:04','',''),(2128015,'1','147','768',326,'Retail Sale Id 1263542',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 13:27:44','',''),(2128016,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:27:44','',''),(2128029,'1','147','768',326,'Retail Sale Id 1263549',7500.80,0.00,0.00,0.00,7500.80,'2021-12-02 13:28:27','',''),(2128030,'1','147','768',326,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-02 13:28:27','',''),(2128156,'1','147','768',326,'Retail Sale Id 1263604',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 13:38:28','',''),(2128157,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 13:38:28','',''),(2128196,'1','147','768',326,'Retail Sale Id 1263614',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 13:40:17','',''),(2128197,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:40:17','',''),(2128198,'1','147','768',326,'Retail Sale Id 1263614',16000.00,0.00,0.00,0.00,16000.00,'2021-12-02 13:40:17','',''),(2128199,'1','147','768',326,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 13:40:17','',''),(2128270,'1','147','768',326,'Retail Sale Id 1263650',998.40,0.00,0.00,0.00,998.40,'2021-12-02 13:45:25','',''),(2128271,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 13:45:25','',''),(2128272,'1','147','768',326,'Retail Sale Id 1263650',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 13:45:25','',''),(2128273,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 13:45:25','',''),(2128300,'1','147','768',326,'Retail Sale Id 1263670',3001.60,0.00,0.00,0.00,3001.60,'2021-12-02 13:47:08','',''),(2128301,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 13:47:08','',''),(2128312,'1','147','768',326,'Retail Sale Id 1263677',7500.80,0.00,0.00,0.00,7500.80,'2021-12-02 13:47:50','',''),(2128313,'1','147','768',326,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-02 13:47:50','',''),(2128352,'1','147','768',326,'Retail Sale Id 1263691',4000.00,0.00,0.00,0.00,4000.00,'2021-12-02 13:49:14','',''),(2128353,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 13:49:14','',''),(2128401,'1','147','768',326,'Retail Sale Id 1263719',998.40,0.00,0.00,0.00,998.40,'2021-12-02 13:53:10','',''),(2128402,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 13:53:10','',''),(2128417,'1','147','768',326,'Retail Sale Id 1263724',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 13:53:49','',''),(2128418,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 13:53:49','',''),(2128477,'1','147','768',326,'Retail Sale Id 1263744',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 13:55:55','',''),(2128478,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 13:55:55','',''),(2128529,'1','147','768',326,'Retail Sale Id 1263767',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 13:58:42','',''),(2128530,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:58:42','',''),(2128550,'1','147','768',326,'Retail Sale Id 1263774',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 14:00:14','',''),(2128551,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 14:00:14','',''),(2128582,'1','147','768',326,'Retail Sale Id 1263790',4000.00,0.00,0.00,0.00,4000.00,'2021-12-02 14:02:50','',''),(2128583,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 14:02:50','',''),(2128610,'1','147','768',326,'Retail Sale Id 1263805',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 14:04:18','',''),(2128611,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:04:18','',''),(2128612,'1','147','768',326,'Retail Sale Id 1263805',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 14:04:18','',''),(2128613,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:04:18','',''),(2128624,'1','147','768',326,'Retail Sale Id 1263811',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 14:05:02','',''),(2128625,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 14:05:02','',''),(2128640,'1','147','768',326,'Retail Sale Id 1263819',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 14:06:20','',''),(2128641,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:06:20','',''),(2128684,'1','147','768',326,'Retail Sale Id 1263842',998.40,0.00,0.00,0.00,998.40,'2021-12-02 14:08:52','',''),(2128685,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 14:08:52','',''),(2128704,'1','147','768',326,'Retail Sale Id 1263850',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 14:10:24','',''),(2128705,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 14:10:24','',''),(2128828,'1','147','768',326,'Retail Sale Id 1263903',998.40,0.00,0.00,0.00,998.40,'2021-12-02 14:17:20','',''),(2128829,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 14:17:20','',''),(2128891,'1','147','768',326,'Retail Sale Id 1263936',998.40,0.00,0.00,0.00,998.40,'2021-12-02 14:20:20','',''),(2128892,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 14:20:20','',''),(2128987,'1','147','768',326,'Retail Sale Id 1263966',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 14:24:23','',''),(2128988,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 14:24:23','',''),(2129013,'1','147','768',326,'Retail Sale Id 1263981',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 14:25:37','',''),(2129014,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 14:25:37','',''),(2129216,'1','147','768',326,'Retail Sale Id 1264049',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 14:33:24','',''),(2129217,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:33:24','',''),(2129260,'1','147','768',326,'Retail Sale Id 1264071',3200.00,0.00,0.00,0.00,3200.00,'2021-12-02 14:36:01','',''),(2129261,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 14:36:01','',''),(2129317,'1','147','768',326,'Retail Sale Id 1264091',4998.40,0.00,0.00,0.00,4998.40,'2021-12-02 14:38:25','',''),(2129318,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 14:38:25','',''),(2129429,'1','147','768',326,'Retail Sale Id 1264135',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 14:42:41','',''),(2129430,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 14:42:41','',''),(2129469,'1','147','768',326,'Retail Sale Id 1264154',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 14:45:22','',''),(2129470,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 14:45:22','',''),(2129493,'1','147','768',326,'Retail Sale Id 1264167',2400.00,0.00,0.00,0.00,2400.00,'2021-12-02 14:47:23','',''),(2129494,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.75,0.00,'2021-12-02 14:47:23','',''),(2129523,'1','147','768',326,'Retail Sale Id 1264185',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 14:48:34','',''),(2129524,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 14:48:34','',''),(2129543,'1','147','768',326,'Retail Sale Id 1264196',998.40,0.00,0.00,0.00,998.40,'2021-12-02 14:49:23','',''),(2129544,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 14:49:23','',''),(2129553,'1','147','768',326,'Retail Sale Id 1264199',3001.60,0.00,0.00,0.00,3001.60,'2021-12-02 14:50:22','',''),(2129554,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 14:50:22','',''),(2129593,'1','147','768',326,'Retail Sale Id 1264220',3001.60,0.00,0.00,0.00,3001.60,'2021-12-02 14:52:51','',''),(2129594,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 14:52:51','',''),(2129610,'1','147','768',326,'Retail Sale Id 1264229',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 14:53:45','',''),(2129611,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 14:53:45','',''),(2129642,'1','147','768',326,'Retail Sale Id 1264245',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 14:55:45','',''),(2129643,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:55:45','',''),(2129673,'1','147','768',326,'Retail Sale Id 1264261',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 14:57:02','',''),(2129674,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 14:57:02','',''),(2129707,'1','147','768',326,'Retail Sale Id 1264282',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 14:58:41','',''),(2129708,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 14:58:41','',''),(2129709,'1','147','768',326,'Retail Sale Id 1264282',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 14:58:41','',''),(2129710,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 14:58:41','',''),(2129711,'1','147','768',326,'Retail Sale Id 1264282',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 14:58:41','',''),(2129712,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 14:58:41','',''),(2129723,'1','147','768',326,'Retail Sale Id 1264288',499.20,0.00,0.00,0.00,499.20,'2021-12-02 14:59:21','',''),(2129724,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-02 14:59:21','',''),(2129767,'1','147','768',326,'Retail Sale Id 1264310',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 15:04:17','',''),(2129768,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 15:04:17','',''),(2129787,'1','147','768',326,'Retail Sale Id 1264319',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 15:05:48','',''),(2129788,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 15:05:48','',''),(2129807,'1','147','768',326,'Retail Sale Id 1264330',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 15:07:24','',''),(2129808,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:07:24','',''),(2129829,'1','147','768',326,'Retail Sale Id 1264343',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 15:08:48','',''),(2129830,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 15:08:48','',''),(2129845,'1','147','768',326,'Retail Sale Id 1264350',1401.60,0.00,0.00,0.00,1401.60,'2021-12-02 15:09:55','',''),(2129846,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-02 15:09:55','',''),(2129863,'1','147','768',326,'Retail Sale Id 1264361',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 15:11:04','',''),(2129865,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 15:11:04','',''),(2129882,'1','147','768',326,'Retail Sale Id 1264367',998.40,0.00,0.00,0.00,998.40,'2021-12-02 15:12:12','',''),(2129883,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 15:12:12','',''),(2129918,'1','147','768',326,'Retail Sale Id 1264387',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 15:14:07','',''),(2129919,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 15:14:07','',''),(2129946,'1','147','768',326,'Retail Sale Id 1264400',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 15:15:18','',''),(2129947,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:15:18','',''),(2129974,'1','147','768',326,'Retail Sale Id 1264416',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 15:16:33','',''),(2129975,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 15:16:33','',''),(2129994,'1','147','768',326,'Retail Sale Id 1264426',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 15:17:38','',''),(2129995,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:17:38','',''),(2130018,'1','147','768',326,'Retail Sale Id 1264440',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 15:18:53','',''),(2130019,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:18:53','',''),(2130054,'1','147','768',326,'Retail Sale Id 1264457',4499.20,0.00,0.00,0.00,4499.20,'2021-12-02 15:21:11','',''),(2130055,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-02 15:21:11','',''),(2130072,'1','147','768',326,'Retail Sale Id 1264467',3001.60,0.00,0.00,0.00,3001.60,'2021-12-02 15:22:14','',''),(2130073,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 15:22:14','',''),(2130122,'1','147','768',326,'Retail Sale Id 1264480',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 15:24:31','',''),(2130123,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 15:24:31','',''),(2130148,'1','147','768',326,'Retail Sale Id 1264503',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 15:25:43','',''),(2130149,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 15:25:43','',''),(2130283,'1','147','768',326,'Retail Sale Id 1264563',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 15:31:09','',''),(2130284,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 15:31:09','',''),(2130307,'1','147','768',326,'Retail Sale Id 1264575',3200.00,0.00,0.00,0.00,3200.00,'2021-12-02 15:32:17','',''),(2130308,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:32:17','',''),(2130331,'1','147','768',326,'Retail Sale Id 1264587',3001.60,0.00,0.00,0.00,3001.60,'2021-12-02 15:33:42','',''),(2130332,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 15:33:42','',''),(2130358,'1','147','768',326,'Retail Sale Id 1264600',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 15:34:38','',''),(2130359,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 15:34:38','',''),(2130378,'1','147','768',326,'Retail Sale Id 1264606',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 15:35:43','',''),(2130379,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 15:35:43','',''),(2130414,'1','147','768',326,'Retail Sale Id 1264626',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 15:37:05','',''),(2130415,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:37:05','',''),(2130448,'1','147','768',326,'Retail Sale Id 1264640',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 15:38:50','',''),(2130449,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 15:38:50','',''),(2130548,'1','147','768',326,'Retail Sale Id 1264702',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 15:43:45','',''),(2130549,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 15:43:45','',''),(2130606,'1','147','768',326,'Retail Sale Id 1264735',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 15:45:57','',''),(2130607,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:45:57','',''),(2130632,'1','147','768',326,'Retail Sale Id 1264745',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 15:47:23','',''),(2130633,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 15:47:23','',''),(2130708,'1','147','768',326,'Retail Sale Id 1264790',5152.00,0.00,0.00,0.00,5152.00,'2021-12-02 15:51:08','',''),(2130709,'1','147','768',326,'Retail sales',0.00,0.00,0.00,8.05,0.00,'2021-12-02 15:51:08','',''),(2130754,'1','147','768',326,'Retail Sale Id 1264812',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 15:52:51','',''),(2130755,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:52:51','',''),(2130786,'1','147','768',326,'Retail Sale Id 1264829',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 15:54:10','',''),(2130787,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 15:54:10','',''),(2130834,'1','147','768',326,'Retail Sale Id 1264852',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 15:55:38','',''),(2130835,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:55:38','',''),(2130864,'1','147','768',326,'Retail Sale Id 1264868',1952.00,0.00,0.00,0.00,1952.00,'2021-12-02 15:57:05','',''),(2130865,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 15:57:05','',''),(2130886,'1','147','768',326,'Retail Sale Id 1264879',998.40,0.00,0.00,0.00,998.40,'2021-12-02 15:58:13','',''),(2130887,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 15:58:13','',''),(2130902,'1','147','768',326,'Retail Sale Id 1264890',998.40,0.00,0.00,0.00,998.40,'2021-12-02 15:59:12','',''),(2130903,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 15:59:12','',''),(2130930,'1','147','768',326,'Retail Sale Id 1264905',3200.00,0.00,0.00,0.00,3200.00,'2021-12-02 16:00:20','',''),(2130931,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:00:20','',''),(2130952,'1','147','768',326,'Retail Sale Id 1264917',4000.00,0.00,0.00,0.00,4000.00,'2021-12-02 16:01:43','',''),(2130953,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 16:01:43','',''),(2131002,'1','147','768',326,'Retail Sale Id 1264934',3001.60,0.00,0.00,0.00,3001.60,'2021-12-02 16:03:16','',''),(2131003,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 16:03:16','',''),(2131023,'1','147','768',326,'Retail Sale Id 1264945',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 16:04:19','',''),(2131024,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 16:04:19','',''),(2131048,'1','147','768',326,'Retail Sale Id 1264954',3200.00,0.00,0.00,0.00,3200.00,'2021-12-02 16:05:17','',''),(2131049,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:05:17','',''),(2131074,'1','147','768',326,'Retail Sale Id 1264964',499.20,0.00,0.00,0.00,499.20,'2021-12-02 16:06:15','',''),(2131075,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-02 16:06:15','',''),(2131098,'1','147','768',326,'Retail Sale Id 1264974',2502.40,0.00,0.00,0.00,2502.40,'2021-12-02 16:07:37','',''),(2131099,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 16:07:37','',''),(2131136,'1','147','768',326,'Retail Sale Id 1264993',3001.60,0.00,0.00,0.00,3001.60,'2021-12-02 16:08:48','',''),(2131137,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 16:08:48','',''),(2131172,'1','147','768',326,'Retail Sale Id 1265011',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 16:10:22','',''),(2131173,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 16:10:22','',''),(2131194,'1','147','768',326,'Retail Sale Id 1265023',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 16:11:26','',''),(2131195,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 16:11:26','',''),(2131212,'1','147','768',326,'Retail Sale Id 1265037',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 16:12:49','',''),(2131213,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 16:12:49','',''),(2131232,'1','147','768',326,'Retail Sale Id 1265045',2502.40,0.00,0.00,0.00,2502.40,'2021-12-02 16:13:48','',''),(2131233,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 16:13:48','',''),(2131255,'1','147','768',326,'Retail Sale Id 1265057',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 16:14:48','',''),(2131256,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 16:14:48','',''),(2131281,'1','147','768',326,'Retail Sale Id 1265070',1798.40,0.00,0.00,0.00,1798.40,'2021-12-02 16:15:57','',''),(2131282,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-02 16:15:57','',''),(2131301,'1','147','768',326,'Retail Sale Id 1265081',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 16:16:59','',''),(2131302,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 16:16:59','',''),(2131333,'1','147','768',326,'Retail Sale Id 1265093',3200.00,0.00,0.00,0.00,3200.00,'2021-12-02 16:18:41','',''),(2131334,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:18:41','',''),(2131355,'1','147','768',326,'Retail Sale Id 1265108',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 16:19:48','',''),(2131356,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:19:48','',''),(2131377,'1','147','768',326,'Retail Sale Id 1265121',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 16:20:59','',''),(2131378,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:20:59','',''),(2131404,'1','147','768',326,'Retail Sale Id 1265134',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 16:22:26','',''),(2131405,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 16:22:26','',''),(2131430,'1','147','768',326,'Retail Sale Id 1265145',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 16:23:50','',''),(2131431,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:23:51','',''),(2131496,'1','147','768',326,'Retail Sale Id 1265178',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 16:26:53','',''),(2131497,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 16:26:53','',''),(2131512,'1','147','768',326,'Retail Sale Id 1265187',1497.60,0.00,0.00,0.00,1497.60,'2021-12-02 16:27:32','',''),(2131513,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 16:27:32','',''),(2131528,'1','147','768',326,'Retail Sale Id 1265194',998.40,0.00,0.00,0.00,998.40,'2021-12-02 16:28:21','',''),(2131529,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 16:28:21','',''),(2131552,'1','147','768',326,'Retail Sale Id 1265208',3001.60,0.00,0.00,0.00,3001.60,'2021-12-02 16:29:07','',''),(2131553,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 16:29:07','',''),(2131604,'1','147','768',326,'Retail Sale Id 1265220',3001.60,0.00,0.00,0.00,3001.60,'2021-12-02 16:29:57','',''),(2131605,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 16:29:57','',''),(2131632,'1','147','768',326,'Retail Sale Id 1265233',3200.00,0.00,0.00,0.00,3200.00,'2021-12-02 16:30:46','',''),(2131633,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:30:46','',''),(2131650,'1','147','768',326,'Retail Sale Id 1265239',640.00,0.00,0.00,0.00,640.00,'2021-12-02 16:31:38','',''),(2131651,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-02 16:31:38','',''),(2131668,'1','147','768',326,'Retail Sale Id 1265249',4000.00,0.00,0.00,0.00,4000.00,'2021-12-02 16:32:21','',''),(2131669,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 16:32:21','',''),(2131688,'1','147','768',326,'Retail Sale Id 1265266',2003.20,0.00,0.00,0.00,2003.20,'2021-12-02 16:33:25','',''),(2131689,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 16:33:25','',''),(2131704,'1','147','768',326,'Retail Sale Id 1265275',3897.60,0.00,0.00,0.00,3897.60,'2021-12-02 16:34:15','',''),(2131705,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-02 16:34:15','',''),(2131728,'1','147','768',326,'Retail Sale Id 1265284',8000.00,0.00,0.00,0.00,8000.00,'2021-12-02 16:35:19','',''),(2131729,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:35:19','',''),(2131746,'1','147','768',326,'Retail Sale Id 1265294',1600.00,0.00,0.00,0.00,1600.00,'2021-12-02 16:36:26','',''),(2131747,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-02 16:36:26','',''),(2132331,'1','147',NULL,326,'Purchased from AA RANO NIGERIA LIMITED',0.00,9472.00,16.00,0.00,0.00,'2021-12-02 17:10:41','',''),(2132342,'1','147',NULL,326,'Reception corrector for bridging 125963',0.00,0.00,0.00,16.00,0.00,'2021-12-02 17:11:24','',''),(2132343,'1','147','768',326,'Received from bridging 125963',0.00,0.00,16.00,0.00,0.00,'2021-12-02 17:11:24','',''),(2132358,'1','147','768',326,'Retail Sale Id 1265595',11193.60,0.00,0.00,0.00,839.52,'2021-12-02 17:12:24','',''),(2132359,'1','147','768',326,'Retail sales',0.00,0.00,0.00,17.49,0.00,'2021-12-02 17:12:24','',''),(2134293,'1','147',NULL,326,'Purchased from AA RANO NIGERIA LIMITED',0.00,1776000.00,3000.00,0.00,0.00,'2021-12-03 06:36:28','',''),(2134324,'1','147',NULL,326,'Reception corrector for bridging 126025',0.00,0.00,0.00,3000.00,0.00,'2021-12-03 06:38:09','',''),(2134325,'1','147','768',326,'Received from bridging 126025',0.00,0.00,3000.00,0.00,0.00,'2021-12-03 06:38:09','',''),(2134399,'1','147','768',326,'Retail Sale Id 1266288',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 06:42:34','',''),(2134400,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 06:42:34','',''),(2134419,'1','147','768',326,'Retail Sale Id 1266299',4998.40,0.00,0.00,0.00,374.88,'2021-12-03 06:43:40','',''),(2134420,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 06:43:40','',''),(2134453,'1','147','768',326,'Retail Sale Id 1266315',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 06:45:09','',''),(2134454,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 06:45:09','',''),(2134472,'1','147','768',326,'Retail Sale Id 1266328',1952.00,0.00,0.00,0.00,146.40,'2021-12-03 06:46:25','',''),(2134473,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 06:46:25','',''),(2134503,'1','147','768',326,'Retail Sale Id 1266340',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 06:47:27','',''),(2134504,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 06:47:27','',''),(2134519,'1','147','768',326,'Retail Sale Id 1266348',4499.20,0.00,0.00,0.00,337.44,'2021-12-03 06:48:28','',''),(2134520,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-03 06:48:28','',''),(2134547,'1','147','768',326,'Retail Sale Id 1266357',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 06:49:59','',''),(2134548,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 06:49:59','',''),(2134575,'1','147','768',326,'Retail Sale Id 1266373',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 06:51:46','',''),(2134576,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:51:46','',''),(2134595,'1','147','768',326,'Retail Sale Id 1266383',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 06:52:54','',''),(2134596,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 06:52:54','',''),(2134623,'1','147','768',326,'Retail Sale Id 1266396',800.00,0.00,0.00,0.00,60.00,'2021-12-03 06:54:09','',''),(2134624,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-03 06:54:09','',''),(2134653,'1','147','768',326,'Retail Sale Id 1266410',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 06:55:36','',''),(2134654,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 06:55:36','',''),(2134673,'1','147','768',326,'Retail Sale Id 1266425',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 06:56:51','',''),(2134674,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:56:51','',''),(2134696,'1','147','768',326,'Retail Sale Id 1266432',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 06:58:06','',''),(2134697,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:58:06','',''),(2134717,'1','147','768',326,'Retail Sale Id 1266442',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 06:59:27','',''),(2134718,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 06:59:27','',''),(2134743,'1','147','768',326,'Retail Sale Id 1266457',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 07:00:42','',''),(2134744,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 07:00:42','',''),(2134757,'1','147','768',326,'Retail Sale Id 1266465',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 07:01:39','',''),(2134758,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 07:01:39','',''),(2134775,'1','147','768',326,'Retail Sale Id 1266471',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 07:02:35','',''),(2134776,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 07:02:35','',''),(2134787,'1','147','768',326,'Retail Sale Id 1266479',998.40,0.00,0.00,0.00,74.88,'2021-12-03 07:03:35','',''),(2134788,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 07:03:35','',''),(2134805,'1','147','768',326,'Retail Sale Id 1266489',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 07:04:45','',''),(2134806,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:04:45','',''),(2134823,'1','147','768',326,'Retail Sale Id 1266501',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 07:05:56','',''),(2134824,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:05:56','',''),(2134847,'1','147','768',326,'Retail Sale Id 1266517',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 07:07:14','',''),(2134848,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 07:07:14','',''),(2134863,'1','147','768',326,'Retail Sale Id 1266525',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 07:08:24','',''),(2134864,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 07:08:24','',''),(2134877,'1','147','768',326,'Retail Sale Id 1266533',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 07:09:25','',''),(2134878,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 07:09:25','',''),(2134899,'1','147','768',326,'Retail Sale Id 1266544',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 07:11:12','',''),(2134900,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 07:11:12','',''),(2134940,'1','147','768',326,'Retail Sale Id 1266551',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 07:12:14','',''),(2134941,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 07:12:14','',''),(2134962,'1','147','768',326,'Retail Sale Id 1266562',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 07:13:22','',''),(2134964,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 07:13:22','',''),(2134984,'1','147','768',326,'Retail Sale Id 1266576',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 07:14:27','',''),(2134985,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:14:27','',''),(2135004,'1','147','768',326,'Retail Sale Id 1266586',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 07:15:39','',''),(2135005,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:15:39','',''),(2135018,'1','147','768',326,'Retail Sale Id 1266594',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 07:16:36','',''),(2135019,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:16:36','',''),(2135042,'1','147','768',326,'Retail Sale Id 1266606',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 07:17:54','',''),(2135043,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:17:54','',''),(2135069,'1','147','768',326,'Retail Sale Id 1266614',1299.20,0.00,0.00,0.00,97.44,'2021-12-03 07:19:02','',''),(2135070,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 07:19:02','',''),(2135089,'1','147','768',326,'Retail Sale Id 1266621',998.40,0.00,0.00,0.00,74.88,'2021-12-03 07:20:13','',''),(2135090,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 07:20:13','',''),(2135105,'1','147','768',326,'Retail Sale Id 1266631',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 07:21:08','',''),(2135106,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 07:21:08','',''),(2135125,'1','147','768',326,'Retail Sale Id 1266641',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 07:22:14','',''),(2135126,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:22:14','',''),(2135143,'1','147','768',326,'Retail Sale Id 1266651',998.40,0.00,0.00,0.00,74.88,'2021-12-03 07:23:26','',''),(2135144,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 07:23:26','',''),(2135174,'1','147','768',326,'Retail Sale Id 1266667',998.40,0.00,0.00,0.00,74.88,'2021-12-03 07:25:28','',''),(2135175,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 07:25:28','',''),(2135200,'1','147','768',326,'Retail Sale Id 1266676',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 07:26:57','',''),(2135201,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:26:57','',''),(2135224,'1','147','768',326,'Retail Sale Id 1266692',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 07:28:28','',''),(2135225,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 07:28:28','',''),(2135258,'1','147','768',326,'Retail Sale Id 1266707',601.60,0.00,0.00,0.00,45.12,'2021-12-03 07:30:55','',''),(2135259,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.94,0.00,'2021-12-03 07:30:55','',''),(2135272,'1','147','768',326,'Retail Sale Id 1266717',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 07:31:56','',''),(2135273,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 07:31:56','',''),(2135292,'1','147','768',326,'Retail Sale Id 1266726',1952.00,0.00,0.00,0.00,146.40,'2021-12-03 07:32:56','',''),(2135293,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 07:32:57','',''),(2135317,'1','147','768',326,'Retail Sale Id 1266738',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 07:33:53','',''),(2135318,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 07:33:53','',''),(2135329,'1','147','768',326,'Retail Sale Id 1266744',6003.20,0.00,0.00,0.00,450.24,'2021-12-03 07:34:48','',''),(2135330,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-03 07:34:48','',''),(2135360,'1','147','768',326,'Retail Sale Id 1266757',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 07:35:58','',''),(2135361,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 07:35:58','',''),(2135374,'1','147','768',326,'Retail Sale Id 1266766',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 07:36:56','',''),(2135375,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:36:56','',''),(2135403,'1','147','768',326,'Retail Sale Id 1266775',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 07:37:56','',''),(2135404,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:37:56','',''),(2135449,'1','147','768',326,'Retail Sale Id 1266799',1920.00,0.00,0.00,0.00,144.00,'2021-12-03 07:40:43','',''),(2135450,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 07:40:43','',''),(2135510,'1','147','768',326,'Retail Sale Id 1266826',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 07:44:14','',''),(2135511,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 07:44:14','',''),(2135746,'1','147','768',326,'Retail Sale Id 1266931',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 07:56:41','',''),(2135747,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 07:56:41','',''),(2135767,'1','147','768',326,'Retail Sale Id 1266944',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 07:57:56','',''),(2135768,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 07:57:56','',''),(2135787,'1','147','768',326,'Retail Sale Id 1266956',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 07:59:17','',''),(2135788,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 07:59:17','',''),(2135806,'1','147','768',326,'Retail Sale Id 1266962',998.40,0.00,0.00,0.00,74.88,'2021-12-03 08:00:13','',''),(2135807,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 08:00:13','',''),(2135843,'1','147','768',326,'Retail Sale Id 1266971',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 08:01:17','',''),(2135844,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 08:01:17','',''),(2135917,'1','147','768',326,'Retail Sale Id 1266991',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 08:02:58','',''),(2135918,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:02:58','',''),(2135980,'1','147','768',326,'Retail Sale Id 1267027',1299.20,0.00,0.00,0.00,97.44,'2021-12-03 08:05:53','',''),(2135981,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 08:05:53','',''),(2136054,'1','147','768',326,'Retail Sale Id 1267061',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 08:08:56','',''),(2136055,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 08:08:56','',''),(2136078,'1','147','768',326,'Retail Sale Id 1267073',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 08:10:25','',''),(2136079,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 08:10:25','',''),(2136108,'1','147','768',326,'Retail Sale Id 1267090',1299.20,0.00,0.00,0.00,97.44,'2021-12-03 08:11:57','',''),(2136109,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 08:11:57','',''),(2136166,'1','147','768',326,'Retail Sale Id 1267119',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 08:15:11','',''),(2136167,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 08:15:11','',''),(2136236,'1','147','768',326,'Retail Sale Id 1267160',998.40,0.00,0.00,0.00,74.88,'2021-12-03 08:18:38','',''),(2136237,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 08:18:38','',''),(2136259,'1','147','768',326,'Retail Sale Id 1267171',1952.00,0.00,0.00,0.00,146.40,'2021-12-03 08:20:13','',''),(2136260,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 08:20:13','',''),(2136296,'1','147','768',326,'Retail Sale Id 1267187',5600.00,0.00,0.00,0.00,420.00,'2021-12-03 08:22:13','',''),(2136297,'1','147','768',326,'Retail sales',0.00,0.00,0.00,8.75,0.00,'2021-12-03 08:22:13','',''),(2136312,'1','147','768',326,'Retail Sale Id 1267194',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 08:23:18','',''),(2136313,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 08:23:18','',''),(2136334,'1','147','768',326,'Retail Sale Id 1267203',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 08:24:37','',''),(2136335,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 08:24:37','',''),(2136388,'1','147','768',326,'Retail Sale Id 1267231',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 08:27:50','',''),(2136389,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 08:27:50','',''),(2136418,'1','147','768',326,'Retail Sale Id 1267247',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 08:30:22','',''),(2136419,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 08:30:22','',''),(2136535,'1','147','768',326,'Retail Sale Id 1267273',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 08:35:51','',''),(2136536,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 08:35:51','',''),(2136568,'1','147','768',326,'Retail Sale Id 1267284',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 08:36:47','',''),(2136569,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 08:36:47','',''),(2136606,'1','147','768',326,'Retail Sale Id 1267295',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 08:38:07','',''),(2136607,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 08:38:07','',''),(2136654,'1','147','768',326,'Retail Sale Id 1267309',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 08:39:38','',''),(2136655,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:39:38','',''),(2136730,'1','147','768',326,'Retail Sale Id 1267324',5702.40,0.00,0.00,0.00,427.68,'2021-12-03 08:41:42','',''),(2136731,'1','147','768',326,'Retail sales',0.00,0.00,0.00,8.91,0.00,'2021-12-03 08:41:42','',''),(2136760,'1','147','768',326,'Retail Sale Id 1267338',1798.40,0.00,0.00,0.00,134.88,'2021-12-03 08:42:50','',''),(2136761,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-03 08:42:50','',''),(2136788,'1','147','768',326,'Retail Sale Id 1267350',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 08:44:03','',''),(2136789,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 08:44:03','',''),(2136804,'1','147','768',326,'Retail Sale Id 1267359',3699.20,0.00,0.00,0.00,277.44,'2021-12-03 08:45:17','',''),(2136805,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.78,0.00,'2021-12-03 08:45:17','',''),(2136824,'1','147','768',326,'Retail Sale Id 1267369',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 08:46:57','',''),(2136825,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 08:46:57','',''),(2136844,'1','147','768',326,'Retail Sale Id 1267380',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 08:48:01','',''),(2136845,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 08:48:01','',''),(2136980,'1','147','768',326,'Retail Sale Id 1267451',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 08:56:01','',''),(2136981,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 08:56:01','',''),(2137034,'1','147','768',326,'Retail Sale Id 1267477',4499.20,0.00,0.00,0.00,337.44,'2021-12-03 08:59:17','',''),(2137035,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-03 08:59:17','',''),(2137054,'1','147','768',326,'Retail Sale Id 1267494',998.40,0.00,0.00,0.00,74.88,'2021-12-03 09:00:17','',''),(2137055,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 09:00:17','',''),(2137084,'1','147','768',326,'Retail Sale Id 1267506',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 09:01:36','',''),(2137085,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 09:01:36','',''),(2137102,'1','147','768',326,'Retail Sale Id 1267516',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 09:02:38','',''),(2137103,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 09:02:38','',''),(2137136,'1','147','768',326,'Retail Sale Id 1267531',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 09:03:58','',''),(2137137,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 09:03:58','',''),(2137158,'1','147','768',326,'Retail Sale Id 1267548',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 09:05:04','',''),(2137159,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 09:05:04','',''),(2137192,'1','147','768',326,'Retail Sale Id 1267565',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 09:06:44','',''),(2137193,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:06:44','',''),(2137225,'1','147','768',326,'Retail Sale Id 1267581',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 09:08:10','',''),(2137226,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 09:08:10','',''),(2137346,'1','147','768',326,'Retail Sale Id 1267665',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 09:14:38','',''),(2137347,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 09:14:38','',''),(2137381,'1','147','768',326,'Retail Sale Id 1267682',499.20,0.00,0.00,0.00,37.44,'2021-12-03 09:15:55','',''),(2137382,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-03 09:15:55','',''),(2137391,'1','147','768',326,'Retail Sale Id 1267689',1952.00,0.00,0.00,0.00,146.40,'2021-12-03 09:16:42','',''),(2137392,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 09:16:42','',''),(2137432,'1','147','768',326,'Retail Sale Id 1267713',697.60,0.00,0.00,0.00,52.32,'2021-12-03 09:18:19','',''),(2137433,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-03 09:18:19','',''),(2137455,'1','147','768',326,'Retail Sale Id 1267720',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 09:19:19','',''),(2137456,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:19:19','',''),(2137509,'1','147','768',326,'Retail Sale Id 1267747',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 09:23:05','',''),(2137510,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 09:23:05','',''),(2137601,'1','147','768',326,'Retail Sale Id 1267807',4998.40,0.00,0.00,0.00,374.88,'2021-12-03 09:29:21','',''),(2137602,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 09:29:21','',''),(2137627,'1','147','768',326,'Retail Sale Id 1267818',998.40,0.00,0.00,0.00,74.88,'2021-12-03 09:30:43','',''),(2137628,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 09:30:43','',''),(2137649,'1','147','768',326,'Retail Sale Id 1267830',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 09:32:15','',''),(2137650,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 09:32:15','',''),(2137661,'1','147','768',326,'Retail Sale Id 1267836',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 09:32:59','',''),(2137662,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 09:32:59','',''),(2137675,'1','147','768',326,'Retail Sale Id 1267845',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 09:33:44','',''),(2137676,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 09:33:44','',''),(2137737,'1','147','768',326,'Retail Sale Id 1267875',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 09:37:39','',''),(2137738,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 09:37:39','',''),(2137747,'1','147','768',326,'Retail Sale Id 1267883',2899.20,0.00,0.00,0.00,217.44,'2021-12-03 09:38:31','',''),(2137748,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.53,0.00,'2021-12-03 09:38:31','',''),(2137787,'1','147','768',326,'Retail Sale Id 1267908',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 09:40:59','',''),(2137788,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:40:59','',''),(2137843,'1','147','768',326,'Retail Sale Id 1267935',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 09:44:20','',''),(2137844,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 09:44:20','',''),(2137845,'1','147','768',326,'Retail Sale Id 1267935',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 09:44:20','',''),(2137846,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 09:44:20','',''),(2137859,'1','147','768',326,'Retail Sale Id 1267941',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 09:45:09','',''),(2137860,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 09:45:09','',''),(2137896,'1','147','768',326,'Retail Sale Id 1267961',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 09:47:21','',''),(2137897,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 09:47:21','',''),(2137932,'1','147','768',326,'Retail Sale Id 1267976',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 09:49:17','',''),(2137933,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:49:17','',''),(2138030,'1','147','768',326,'Retail Sale Id 1268027',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 09:55:46','',''),(2138031,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:55:46','',''),(2138076,'1','147','768',326,'Retail Sale Id 1268048',1299.20,0.00,0.00,0.00,97.44,'2021-12-03 09:58:32','',''),(2138077,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 09:58:32','',''),(2138118,'1','147','768',326,'Retail Sale Id 1268069',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 10:01:03','',''),(2138119,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:01:03','',''),(2138128,'1','147','768',326,'Retail Sale Id 1268073',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 10:01:45','',''),(2138129,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 10:01:45','',''),(2138205,'1','147','768',326,'Retail Sale Id 1268114',1299.20,0.00,0.00,0.00,97.44,'2021-12-03 10:06:22','',''),(2138206,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 10:06:22','',''),(2138229,'1','147','768',326,'Retail Sale Id 1268127',6003.20,0.00,0.00,0.00,450.24,'2021-12-03 10:07:24','',''),(2138230,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-03 10:07:24','',''),(2138334,'1','147','768',326,'Retail Sale Id 1268178',998.40,0.00,0.00,0.00,74.88,'2021-12-03 10:12:16','',''),(2138335,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 10:12:16','',''),(2138371,'1','147','768',326,'Retail Sale Id 1268198',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 10:14:50','',''),(2138372,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:14:50','',''),(2138423,'1','147',NULL,326,'Purchased from AA RANO NIGERIA LIMITED',0.00,1604320.00,2710.00,0.00,0.00,'2021-12-03 10:17:46','',''),(2138434,'1','147',NULL,326,'Reception corrector for bridging 126051',0.00,0.00,0.00,2710.00,0.00,'2021-12-03 10:18:30','',''),(2138435,'1','147','768',326,'Received from bridging 126051',0.00,0.00,2710.00,0.00,0.00,'2021-12-03 10:18:30','',''),(2138448,'1','147','768',326,'Retail Sale Id 1268231',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 10:19:06','',''),(2138449,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 10:19:06','',''),(2138460,'1','147','768',326,'Retail Sale Id 1268238',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 10:20:02','',''),(2138461,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 10:20:02','',''),(2138500,'1','147','768',326,'Retail Sale Id 1268258',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 10:22:17','',''),(2138501,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 10:22:17','',''),(2138510,'1','147','768',326,'Retail Sale Id 1268266',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 10:22:56','',''),(2138511,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 10:22:56','',''),(2138558,'1','147','768',326,'Retail Sale Id 1268292',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 10:25:57','',''),(2138559,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 10:25:57','',''),(2138590,'1','147','768',326,'Retail Sale Id 1268302',1952.00,0.00,0.00,0.00,146.40,'2021-12-03 10:27:29','',''),(2138591,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 10:27:29','',''),(2138606,'1','147','768',326,'Retail Sale Id 1268310',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 10:28:46','',''),(2138607,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 10:28:46','',''),(2138625,'1','147','768',326,'Retail Sale Id 1268318',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 10:29:53','',''),(2138626,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:29:53','',''),(2138637,'1','147','768',326,'Retail Sale Id 1268331',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 10:30:42','',''),(2138638,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 10:30:42','',''),(2138663,'1','147','768',326,'Retail Sale Id 1268339',998.40,0.00,0.00,0.00,74.88,'2021-12-03 10:31:43','',''),(2138664,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 10:31:43','',''),(2138699,'1','147','768',326,'Retail Sale Id 1268359',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 10:34:55','',''),(2138700,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 10:34:55','',''),(2138719,'1','147','768',326,'Retail Sale Id 1268368',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 10:36:12','',''),(2138720,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 10:36:12','',''),(2138753,'1','147','768',326,'Retail Sale Id 1268378',998.40,0.00,0.00,0.00,74.88,'2021-12-03 10:37:23','',''),(2138754,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 10:37:23','',''),(2138769,'1','147','768',326,'Retail Sale Id 1268388',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 10:38:15','',''),(2138770,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:38:15','',''),(2139023,'1','147','768',326,'Retail Sale Id 1268522',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 10:58:40','',''),(2139024,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 10:58:40','',''),(2139076,'1','147','768',326,'Retail Sale Id 1268550',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 11:02:32','',''),(2139077,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 11:02:32','',''),(2139143,'1','147','768',326,'Retail Sale Id 1268586',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 11:07:37','',''),(2139144,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 11:07:37','',''),(2139205,'1','147','768',326,'Retail Sale Id 1268621',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 11:12:34','',''),(2139206,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:12:34','',''),(2139221,'1','147','768',326,'Retail Sale Id 1268627',16000.00,0.00,0.00,0.00,1200.00,'2021-12-03 11:13:52','',''),(2139222,'1','147','768',326,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 11:13:52','',''),(2139261,'1','147','768',326,'Retail Sale Id 1268649',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 11:15:51','',''),(2139262,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:15:51','',''),(2139334,'1','147','768',326,'Retail Sale Id 1268682',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 11:20:24','',''),(2139335,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 11:20:24','',''),(2139348,'1','147','768',326,'Retail Sale Id 1268690',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 11:21:40','',''),(2139349,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 11:21:40','',''),(2139403,'1','147','768',326,'Retail Sale Id 1268723',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 11:27:23','',''),(2139404,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 11:27:23','',''),(2139425,'1','147','768',326,'Retail Sale Id 1268730',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 11:28:45','',''),(2139426,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 11:28:45','',''),(2139447,'1','147','768',326,'Retail Sale Id 1268744',4998.40,0.00,0.00,0.00,374.88,'2021-12-03 11:30:43','',''),(2139448,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 11:30:43','',''),(2139463,'1','147','768',326,'Retail Sale Id 1268756',998.40,0.00,0.00,0.00,74.88,'2021-12-03 11:31:48','',''),(2139464,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 11:31:48','',''),(2139518,'1','147','768',326,'Retail Sale Id 1268784',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 11:36:28','',''),(2139519,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 11:36:28','',''),(2139570,'1','147','768',326,'Retail Sale Id 1268815',7500.80,0.00,0.00,0.00,562.56,'2021-12-03 11:41:15','',''),(2139571,'1','147','768',326,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-03 11:41:15','',''),(2139606,'1','147','768',326,'Retail Sale Id 1268836',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 11:43:32','',''),(2139607,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 11:43:32','',''),(2139642,'1','147','768',326,'Retail Sale Id 1268858',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 11:46:19','',''),(2139643,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 11:46:19','',''),(2139662,'1','147','768',326,'Retail Sale Id 1268866',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 11:47:26','',''),(2139663,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:47:26','',''),(2139696,'1','147','768',326,'Retail Sale Id 1268892',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 11:49:47','',''),(2139697,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 11:49:47','',''),(2139721,'1','147','768',326,'Retail Sale Id 1268904',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 11:52:09','',''),(2139722,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 11:52:09','',''),(2139735,'1','147','768',326,'Retail Sale Id 1268913',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 11:53:23','',''),(2139736,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 11:53:23','',''),(2139749,'1','147','768',326,'Retail Sale Id 1268919',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 11:54:40','',''),(2139750,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 11:54:40','',''),(2139763,'1','147','768',326,'Retail Sale Id 1268927',403.20,0.00,0.00,0.00,30.24,'2021-12-03 11:55:30','',''),(2139764,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.63,0.00,'2021-12-03 11:55:30','',''),(2139773,'1','147','768',326,'Retail Sale Id 1268932',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 11:56:09','',''),(2139774,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 11:56:09','',''),(2139783,'1','147','768',326,'Retail Sale Id 1268936',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 11:56:42','',''),(2139784,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 11:56:42','',''),(2139793,'1','147','768',326,'Retail Sale Id 1268942',1952.00,0.00,0.00,0.00,146.40,'2021-12-03 11:57:49','',''),(2139794,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 11:57:49','',''),(2139839,'1','147','768',326,'Retail Sale Id 1268965',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 12:01:13','',''),(2139840,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 12:01:13','',''),(2139867,'1','147','768',326,'Retail Sale Id 1268981',1952.00,0.00,0.00,0.00,146.40,'2021-12-03 12:02:53','',''),(2139868,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 12:02:54','',''),(2139893,'1','147','768',326,'Retail Sale Id 1268997',12198.40,0.00,0.00,0.00,914.88,'2021-12-03 12:04:05','',''),(2139894,'1','147','768',326,'Retail sales',0.00,0.00,0.00,19.06,0.00,'2021-12-03 12:04:05','',''),(2139917,'1','147','768',326,'Retail Sale Id 1269012',998.40,0.00,0.00,0.00,74.88,'2021-12-03 12:05:30','',''),(2139918,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 12:05:30','',''),(2139976,'1','147','768',326,'Retail Sale Id 1269051',998.40,0.00,0.00,0.00,74.88,'2021-12-03 12:09:21','',''),(2139977,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 12:09:21','',''),(2140018,'1','147','768',326,'Retail Sale Id 1269077',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 12:13:44','',''),(2140019,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 12:13:44','',''),(2140036,'1','147','768',326,'Retail Sale Id 1269086',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 12:15:59','',''),(2140037,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 12:15:59','',''),(2140052,'1','147','768',326,'Retail Sale Id 1269095',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 12:16:59','',''),(2140053,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 12:16:59','',''),(2140064,'1','147','768',326,'Retail Sale Id 1269101',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 12:18:29','',''),(2140065,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:18:29','',''),(2140090,'1','147','768',326,'Retail Sale Id 1269118',998.40,0.00,0.00,0.00,74.88,'2021-12-03 12:21:34','',''),(2140091,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 12:21:34','',''),(2140120,'1','147','768',326,'Retail Sale Id 1269131',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 12:24:03','',''),(2140121,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 12:24:03','',''),(2140132,'1','147','768',326,'Retail Sale Id 1269136',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 12:24:55','',''),(2140133,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 12:24:55','',''),(2140145,'1','147','768',326,'Retail Sale Id 1269141',697.60,0.00,0.00,0.00,52.32,'2021-12-03 12:25:36','',''),(2140146,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-03 12:25:36','',''),(2140153,'1','147','768',326,'Retail Sale Id 1269146',998.40,0.00,0.00,0.00,74.88,'2021-12-03 12:26:28','',''),(2140154,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 12:26:28','',''),(2140168,'1','147','768',326,'Retail Sale Id 1269153',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 12:27:55','',''),(2140169,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 12:27:55','',''),(2140198,'1','147','768',326,'Retail Sale Id 1269176',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 12:30:17','',''),(2140199,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:30:17','',''),(2140226,'1','147','768',326,'Retail Sale Id 1269192',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 12:32:11','',''),(2140227,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:32:11','',''),(2140262,'1','147','768',326,'Retail Sale Id 1269218',1952.00,0.00,0.00,0.00,146.40,'2021-12-03 12:35:31','',''),(2140263,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 12:35:31','',''),(2140303,'1','147','768',326,'Retail Sale Id 1269236',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 12:38:16','',''),(2140304,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 12:38:16','',''),(2140319,'1','147','768',326,'Retail Sale Id 1269245',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 12:39:37','',''),(2140320,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 12:39:37','',''),(2140375,'1','147','768',326,'Retail Sale Id 1269267',499.20,0.00,0.00,0.00,37.44,'2021-12-03 12:43:18','',''),(2140376,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-03 12:43:18','',''),(2140389,'1','147','768',326,'Retail Sale Id 1269275',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 12:44:35','',''),(2140390,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 12:44:35','',''),(2140399,'1','147','768',326,'Retail Sale Id 1269281',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 12:45:35','',''),(2140400,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 12:45:35','',''),(2140439,'1','147','768',326,'Retail Sale Id 1269301',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 12:48:29','',''),(2140440,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 12:48:29','',''),(2140463,'1','147','768',326,'Retail Sale Id 1269309',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 12:49:39','',''),(2140464,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 12:49:39','',''),(2140471,'1','147','768',326,'Retail Sale Id 1269314',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 12:50:26','',''),(2140472,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 12:50:26','',''),(2140501,'1','147','768',326,'Retail Sale Id 1269329',998.40,0.00,0.00,0.00,74.88,'2021-12-03 12:51:47','',''),(2140502,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 12:51:47','',''),(2140521,'1','147','768',326,'Retail Sale Id 1269339',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 12:53:05','',''),(2140522,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 12:53:05','',''),(2140535,'1','147','768',326,'Retail Sale Id 1269345',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 12:54:10','',''),(2140536,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 12:54:10','',''),(2140579,'1','147','768',326,'Retail Sale Id 1269370',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 12:57:09','',''),(2140580,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:57:09','',''),(2140594,'1','147','768',326,'Retail Sale Id 1269375',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 12:59:01','',''),(2140595,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:59:01','',''),(2140602,'1','147','768',326,'Retail Sale Id 1269378',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 12:59:58','',''),(2140603,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 12:59:58','',''),(2140610,'1','147','768',326,'Retail Sale Id 1269382',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 13:00:45','',''),(2140611,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 13:00:45','',''),(2140652,'1','147','768',326,'Retail Sale Id 1269402',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 13:04:11','',''),(2140653,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 13:04:11','',''),(2140751,'1','147','768',326,'Retail Sale Id 1269448',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 13:13:09','',''),(2140752,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 13:13:09','',''),(2140757,'1','147','768',326,'Retail Sale Id 1269451',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 13:14:12','',''),(2140758,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 13:14:12','',''),(2140793,'1','147','768',326,'Retail Sale Id 1269468',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 13:16:25','',''),(2140794,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 13:16:25','',''),(2140806,'1','147','768',326,'Retail Sale Id 1269473',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 13:17:33','',''),(2140807,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 13:17:33','',''),(2140833,'1','147','768',326,'Retail Sale Id 1269479',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 13:18:52','',''),(2140834,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 13:18:52','',''),(2140849,'1','147','768',326,'Retail Sale Id 1269482',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 13:19:56','',''),(2140850,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 13:19:56','',''),(2140895,'1','147','768',326,'Retail Sale Id 1269506',4998.40,0.00,0.00,0.00,374.88,'2021-12-03 13:24:17','',''),(2140896,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 13:24:17','',''),(2140915,'1','147','768',326,'Retail Sale Id 1269518',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 13:25:42','',''),(2140916,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 13:25:42','',''),(2140933,'1','147','768',326,'Retail Sale Id 1269526',998.40,0.00,0.00,0.00,74.88,'2021-12-03 13:27:05','',''),(2140934,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 13:27:05','',''),(2140995,'1','147','768',326,'Retail Sale Id 1269558',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 13:31:25','',''),(2140996,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 13:31:25','',''),(2141019,'1','147','768',326,'Retail Sale Id 1269569',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 13:32:51','',''),(2141020,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 13:32:51','',''),(2141035,'1','147','768',326,'Retail Sale Id 1269576',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 13:33:55','',''),(2141036,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 13:33:55','',''),(2141053,'1','147','768',326,'Retail Sale Id 1269586',1952.00,0.00,0.00,0.00,146.40,'2021-12-03 13:35:05','',''),(2141054,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 13:35:05','',''),(2141136,'1','147','768',326,'Retail Sale Id 1269632',998.40,0.00,0.00,0.00,74.88,'2021-12-03 13:40:33','',''),(2141137,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 13:40:33','',''),(2141152,'1','147','768',326,'Retail Sale Id 1269640',697.60,0.00,0.00,0.00,52.32,'2021-12-03 13:41:36','',''),(2141153,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-03 13:41:36','',''),(2141172,'1','147','768',326,'Retail Sale Id 1269646',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 13:42:14','',''),(2141173,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 13:42:14','',''),(2141190,'1','147','768',326,'Retail Sale Id 1269650',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 13:43:09','',''),(2141191,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 13:43:09','',''),(2141211,'1','147','768',326,'Retail Sale Id 1269660',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 13:43:53','',''),(2141212,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:43:53','',''),(2141234,'1','147','768',326,'Retail Sale Id 1269669',1299.20,0.00,0.00,0.00,97.44,'2021-12-03 13:44:56','',''),(2141235,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 13:44:56','',''),(2141337,'1','147','768',326,'Retail Sale Id 1269701',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 13:48:05','',''),(2141338,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:48:05','',''),(2141389,'1','147','768',326,'Retail Sale Id 1269708',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 13:49:06','',''),(2141390,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:49:06','',''),(2141439,'1','147','768',326,'Retail Sale Id 1269732',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 13:51:47','',''),(2141440,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 13:51:47','',''),(2141455,'1','147','768',326,'Retail Sale Id 1269737',998.40,0.00,0.00,0.00,74.88,'2021-12-03 13:52:34','',''),(2141456,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 13:52:34','',''),(2141479,'1','147','768',326,'Retail Sale Id 1269749',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 13:54:08','',''),(2141480,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 13:54:08','',''),(2141507,'1','147','768',326,'Retail Sale Id 1269761',4499.20,0.00,0.00,0.00,337.44,'2021-12-03 13:55:36','',''),(2141508,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-03 13:55:36','',''),(2141518,'1','147','768',326,'Retail Sale Id 1269768',1952.00,0.00,0.00,0.00,146.40,'2021-12-03 13:56:31','',''),(2141519,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 13:56:31','',''),(2141550,'1','147','768',326,'Retail Sale Id 1269783',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 13:59:32','',''),(2141551,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:59:32','',''),(2141588,'1','147','768',326,'Retail Sale Id 1269802',998.40,0.00,0.00,0.00,74.88,'2021-12-03 14:02:27','',''),(2141589,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 14:02:27','',''),(2141637,'1','147','768',326,'Retail Sale Id 1269818',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 14:04:08','',''),(2141638,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 14:04:08','',''),(2141651,'1','147','768',326,'Retail Sale Id 1269826',2598.40,0.00,0.00,0.00,194.88,'2021-12-03 14:05:40','',''),(2141652,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-03 14:05:40','',''),(2141678,'1','147','768',326,'Retail Sale Id 1269835',652.80,0.00,0.00,0.00,48.96,'2021-12-03 14:06:50','',''),(2141679,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-03 14:06:50','',''),(2141680,'1','147','768',326,'Retail Sale Id 1269835',1952.00,0.00,0.00,0.00,146.40,'2021-12-03 14:06:50','',''),(2141681,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 14:06:50','',''),(2141707,'1','147','768',326,'Retail Sale Id 1269846',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 14:08:02','',''),(2141708,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 14:08:02','',''),(2141731,'1','147','768',326,'Retail Sale Id 1269856',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 14:09:46','',''),(2141732,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:09:46','',''),(2141750,'1','147','768',326,'Retail Sale Id 1269865',998.40,0.00,0.00,0.00,74.88,'2021-12-03 14:10:56','',''),(2141751,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 14:10:56','',''),(2141772,'1','147','768',326,'Retail Sale Id 1269876',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 14:12:17','',''),(2141773,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 14:12:17','',''),(2141784,'1','147','768',326,'Retail Sale Id 1269883',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 14:13:24','',''),(2141785,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:13:24','',''),(2141800,'1','147','768',326,'Retail Sale Id 1269891',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 14:14:46','',''),(2141801,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 14:14:46','',''),(2141808,'1','147','768',326,'Retail Sale Id 1269896',998.40,0.00,0.00,0.00,74.88,'2021-12-03 14:15:50','',''),(2141809,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 14:15:50','',''),(2141830,'1','147','768',326,'Retail Sale Id 1269901',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 14:17:21','',''),(2141831,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:17:21','',''),(2141852,'1','147','768',326,'Retail Sale Id 1269909',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 14:18:25','',''),(2141853,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 14:18:25','',''),(2141910,'1','147','768',326,'Retail Sale Id 1269931',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 14:21:20','',''),(2141911,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 14:21:20','',''),(2142081,'1','147','768',326,'Retail Sale Id 1270000',7001.60,0.00,0.00,0.00,525.12,'2021-12-03 14:31:14','',''),(2142082,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-03 14:31:14','',''),(2142110,'1','147','768',326,'Retail Sale Id 1270013',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 14:33:29','',''),(2142112,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 14:33:29','',''),(2142229,'1','147','768',326,'Retail Sale Id 1270047',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 14:39:01','',''),(2142230,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 14:39:01','',''),(2142275,'1','147','768',326,'Retail Sale Id 1270061',800.00,0.00,0.00,0.00,60.00,'2021-12-03 14:41:04','',''),(2142276,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-03 14:41:04','',''),(2142474,'1','147','768',326,'Retail Sale Id 1270153',1299.20,0.00,0.00,0.00,97.44,'2021-12-03 14:48:38','',''),(2142475,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 14:48:38','',''),(2142505,'1','147','768',326,'Retail Sale Id 1270171',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 14:50:18','',''),(2142506,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:50:18','',''),(2142527,'1','147','768',326,'Retail Sale Id 1270181',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 14:51:31','',''),(2142528,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:51:31','',''),(2142585,'1','147','768',326,'Retail Sale Id 1270210',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 14:54:13','',''),(2142586,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 14:54:13','',''),(2142608,'1','147','768',326,'Retail Sale Id 1270220',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 14:55:30','',''),(2142609,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 14:55:30','',''),(2142648,'1','147','768',326,'Retail Sale Id 1270230',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 14:56:25','',''),(2142649,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 14:56:25','',''),(2142665,'1','147','768',326,'Retail Sale Id 1270238',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 14:57:05','',''),(2142666,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 14:57:06','',''),(2142689,'1','147','768',326,'Retail Sale Id 1270251',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 14:59:15','',''),(2142690,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 14:59:15','',''),(2142769,'1','147','768',326,'Retail Sale Id 1270292',1952.00,0.00,0.00,0.00,146.40,'2021-12-03 15:04:54','',''),(2142770,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 15:04:54','',''),(2142786,'1','147','768',326,'Retail Sale Id 1270299',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 15:05:47','',''),(2142787,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 15:05:47','',''),(2142816,'1','147','768',326,'Retail Sale Id 1270314',998.40,0.00,0.00,0.00,74.88,'2021-12-03 15:08:06','',''),(2142817,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 15:08:06','',''),(2142818,'1','147','768',326,'Retail Sale Id 1270314',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 15:08:06','',''),(2142819,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:08:06','',''),(2142832,'1','147','768',326,'Retail Sale Id 1270320',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 15:09:00','',''),(2142833,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 15:09:00','',''),(2142846,'1','147','768',326,'Retail Sale Id 1270332',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 15:09:47','',''),(2142847,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 15:09:47','',''),(2142870,'1','147','768',326,'Retail Sale Id 1270347',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 15:10:51','',''),(2142871,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 15:10:51','',''),(2142908,'1','147','768',326,'Retail Sale Id 1270358',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 15:11:55','',''),(2142909,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 15:11:55','',''),(2142972,'1','147','768',326,'Retail Sale Id 1270399',902.40,0.00,0.00,0.00,67.68,'2021-12-03 15:15:07','',''),(2142973,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-03 15:15:07','',''),(2143012,'1','147','768',326,'Retail Sale Id 1270420',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 15:16:59','',''),(2143013,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 15:16:59','',''),(2143051,'1','147','768',326,'Retail Sale Id 1270445',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 15:19:09','',''),(2143052,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 15:19:09','',''),(2143087,'1','147','768',326,'Retail Sale Id 1270470',998.40,0.00,0.00,0.00,74.88,'2021-12-03 15:20:29','',''),(2143088,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 15:20:29','',''),(2143111,'1','147','768',326,'Retail Sale Id 1270483',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 15:21:38','',''),(2143112,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 15:21:38','',''),(2143137,'1','147','768',326,'Retail Sale Id 1270495',3500.80,0.00,0.00,0.00,262.56,'2021-12-03 15:23:28','',''),(2143138,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-03 15:23:28','',''),(2143157,'1','147','768',326,'Retail Sale Id 1270508',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 15:24:35','',''),(2143158,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 15:24:35','',''),(2143212,'1','147','768',326,'Retail Sale Id 1270530',1920000.00,0.00,0.00,0.00,144000.00,'2021-12-03 15:27:40','',''),(2143213,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3000.00,0.00,'2021-12-03 15:27:40','',''),(2143239,'1','147','768',326,'Retail Sale Id 1270541',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 15:28:56','',''),(2143240,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 15:28:56','',''),(2143271,'1','147','768',326,'Retail Sale Id 1270560',5120.00,0.00,0.00,0.00,384.00,'2021-12-03 15:30:20','',''),(2143272,'1','147','768',326,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 15:30:20','',''),(2143311,'1','147','768',326,'Retail Sale Id 1270576',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 15:32:08','',''),(2143312,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 15:32:08','',''),(2143327,'1','147','768',326,'Retail Sale Id 1270587',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 15:33:21','',''),(2143328,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 15:33:21','',''),(2143393,'1','147','768',326,'Retail Sale Id 1270611',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 15:35:08','',''),(2143394,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 15:35:08','',''),(2143421,'1','147','768',326,'Retail Sale Id 1270632',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 15:36:31','',''),(2143422,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 15:36:31','',''),(2143458,'1','147','768',326,'Retail Sale Id 1270649',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 15:38:05','',''),(2143459,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 15:38:05','',''),(2143488,'1','147','768',326,'Retail Sale Id 1270669',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 15:39:22','',''),(2143489,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 15:39:22','',''),(2143516,'1','147','768',326,'Retail Sale Id 1270682',998.40,0.00,0.00,0.00,74.88,'2021-12-03 15:40:25','',''),(2143517,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 15:40:25','',''),(2143538,'1','147','768',326,'Retail Sale Id 1270694',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 15:41:27','',''),(2143539,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 15:41:27','',''),(2143572,'1','147','768',326,'Retail Sale Id 1270708',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 15:42:36','',''),(2143573,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 15:42:36','',''),(2143598,'1','147','768',326,'Retail Sale Id 1270719',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 15:43:39','',''),(2143599,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 15:43:39','',''),(2143616,'1','147','768',326,'Retail Sale Id 1270731',1952.00,0.00,0.00,0.00,146.40,'2021-12-03 15:44:48','',''),(2143619,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 15:44:48','',''),(2143652,'1','147','768',326,'Retail Sale Id 1270743',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 15:45:55','',''),(2143653,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:45:55','',''),(2143716,'1','147','768',326,'Retail Sale Id 1270776',9952.00,0.00,0.00,0.00,746.40,'2021-12-03 15:48:03','',''),(2143717,'1','147','768',326,'Retail sales',0.00,0.00,0.00,15.55,0.00,'2021-12-03 15:48:03','',''),(2143746,'1','147','768',326,'Retail Sale Id 1270790',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 15:49:17','',''),(2143747,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:49:17','',''),(2143768,'1','147','768',326,'Retail Sale Id 1270805',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 15:50:37','',''),(2143769,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:50:37','',''),(2143790,'1','147','768',326,'Retail Sale Id 1270816',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 15:51:40','',''),(2143791,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:51:40','',''),(2143818,'1','147','768',326,'Retail Sale Id 1270830',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 15:52:46','',''),(2143819,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:52:46','',''),(2143836,'1','147','768',326,'Retail Sale Id 1270839',998.40,0.00,0.00,0.00,74.88,'2021-12-03 15:53:56','',''),(2143837,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 15:53:56','',''),(2143861,'1','147','768',326,'Retail Sale Id 1270853',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 15:54:59','',''),(2143862,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 15:54:59','',''),(2143879,'1','147','768',326,'Retail Sale Id 1270862',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 15:55:56','',''),(2143880,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 15:55:56','',''),(2143897,'1','147','768',326,'Retail Sale Id 1270871',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 15:57:07','',''),(2143898,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 15:57:07','',''),(2143934,'1','147','768',326,'Retail Sale Id 1270888',6400.00,0.00,0.00,0.00,480.00,'2021-12-03 15:58:32','',''),(2143935,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 15:58:32','',''),(2143956,'1','147','768',326,'Retail Sale Id 1270899',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 16:00:06','',''),(2143957,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 16:00:06','',''),(2143987,'1','147','768',326,'Retail Sale Id 1270912',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 16:01:03','',''),(2143988,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 16:01:03','',''),(2144021,'1','147','768',326,'Retail Sale Id 1270927',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 16:02:19','',''),(2144022,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 16:02:19','',''),(2144043,'1','147','768',326,'Retail Sale Id 1270939',1798.40,0.00,0.00,0.00,134.88,'2021-12-03 16:03:34','',''),(2144044,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-03 16:03:34','',''),(2144079,'1','147','768',326,'Retail Sale Id 1270960',998.40,0.00,0.00,0.00,74.88,'2021-12-03 16:05:06','',''),(2144080,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 16:05:06','',''),(2144121,'1','147','768',326,'Retail Sale Id 1270978',6003.20,0.00,0.00,0.00,450.24,'2021-12-03 16:06:22','',''),(2144122,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-03 16:06:22','',''),(2144144,'1','147','768',326,'Retail Sale Id 1270987',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 16:07:28','',''),(2144145,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 16:07:28','',''),(2144200,'1','147','768',326,'Retail Sale Id 1271014',15001.60,0.00,0.00,0.00,1125.12,'2021-12-03 16:09:58','',''),(2144201,'1','147','768',326,'Retail sales',0.00,0.00,0.00,23.44,0.00,'2021-12-03 16:09:58','',''),(2144226,'1','147','768',326,'Retail Sale Id 1271030',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 16:11:04','',''),(2144227,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:11:04','',''),(2144288,'1','147','768',326,'Retail Sale Id 1271064',2560.00,0.00,0.00,0.00,192.00,'2021-12-03 16:14:45','',''),(2144289,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 16:14:45','',''),(2144300,'1','147','768',326,'Retail Sale Id 1271072',998.40,0.00,0.00,0.00,74.88,'2021-12-03 16:15:41','',''),(2144301,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 16:15:41','',''),(2144312,'1','147','768',326,'Retail Sale Id 1271078',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 16:16:45','',''),(2144313,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 16:16:45','',''),(2144322,'1','147','768',326,'Retail Sale Id 1271086',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 16:17:37','',''),(2144323,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:17:37','',''),(2144346,'1','147','768',326,'Retail Sale Id 1271096',998.40,0.00,0.00,0.00,74.88,'2021-12-03 16:18:33','',''),(2144347,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 16:18:33','',''),(2144368,'1','147','768',326,'Retail Sale Id 1271107',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 16:19:19','',''),(2144369,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 16:19:19','',''),(2144388,'1','147','768',326,'Retail Sale Id 1271116',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 16:20:11','',''),(2144389,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 16:20:11','',''),(2144402,'1','147','768',326,'Retail Sale Id 1271126',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 16:21:05','',''),(2144403,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 16:21:06','',''),(2144428,'1','147','768',326,'Retail Sale Id 1271136',4998.40,0.00,0.00,0.00,374.88,'2021-12-03 16:22:06','',''),(2144429,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 16:22:06','',''),(2144440,'1','147','768',326,'Retail Sale Id 1271140',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 16:22:46','',''),(2144441,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 16:22:46','',''),(2144454,'1','147','768',326,'Retail Sale Id 1271149',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 16:23:28','',''),(2144455,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 16:23:28','',''),(2144486,'1','147','768',326,'Retail Sale Id 1271164',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 16:25:14','',''),(2144487,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 16:25:14','',''),(2144500,'1','147','768',326,'Retail Sale Id 1271171',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 16:26:09','',''),(2144501,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:26:09','',''),(2144516,'1','147','768',326,'Retail Sale Id 1271180',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 16:26:57','',''),(2144517,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 16:26:57','',''),(2144526,'1','147','768',326,'Retail Sale Id 1271187',1952.00,0.00,0.00,0.00,146.40,'2021-12-03 16:27:47','',''),(2144527,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:27:47','',''),(2144544,'1','147','768',326,'Retail Sale Id 1271194',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 16:28:38','',''),(2144545,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 16:28:38','',''),(2144556,'1','147','768',326,'Retail Sale Id 1271201',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 16:29:24','',''),(2144559,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:29:24','',''),(2144572,'1','147','768',326,'Retail Sale Id 1271210',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 16:30:20','',''),(2144573,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:30:20','',''),(2144635,'1','147','768',326,'Retail Sale Id 1271238',1952.00,0.00,0.00,0.00,146.40,'2021-12-03 16:33:03','',''),(2144636,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:33:03','',''),(2144649,'1','147','768',326,'Retail Sale Id 1271243',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 16:33:54','',''),(2144650,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:33:54','',''),(2144687,'1','147','768',326,'Retail Sale Id 1271265',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 16:35:47','',''),(2144688,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 16:35:47','',''),(2144712,'1','147','768',326,'Retail Sale Id 1271280',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 16:36:54','',''),(2144713,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 16:36:54','',''),(2144726,'1','147','768',326,'Retail Sale Id 1271287',998.40,0.00,0.00,0.00,74.88,'2021-12-03 16:37:42','',''),(2144727,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 16:37:42','',''),(2144742,'1','147','768',326,'Retail Sale Id 1271298',998.40,0.00,0.00,0.00,74.88,'2021-12-03 16:38:33','',''),(2144743,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 16:38:33','',''),(2144757,'1','147','768',326,'Retail Sale Id 1271305',6400.00,0.00,0.00,0.00,480.00,'2021-12-03 16:39:27','',''),(2144758,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 16:39:27','',''),(2144907,'1','147','768',326,'Retail Sale Id 1271376',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 16:46:43','',''),(2144908,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 16:46:43','',''),(2144937,'1','147','768',326,'Retail Sale Id 1271389',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 16:48:17','',''),(2144938,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 16:48:17','',''),(2144949,'1','147','768',326,'Retail Sale Id 1271398',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 16:49:13','',''),(2144950,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 16:49:13','',''),(2144971,'1','147','768',326,'Retail Sale Id 1271410',1952.00,0.00,0.00,0.00,146.40,'2021-12-03 16:50:34','',''),(2144972,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:50:34','',''),(2144989,'1','147','768',326,'Retail Sale Id 1271416',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 16:51:19','',''),(2144990,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:51:19','',''),(2145133,'1','147','768',326,'Retail Sale Id 1271463',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 16:56:08','',''),(2145134,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 16:56:08','',''),(2145157,'1','147','768',326,'Retail Sale Id 1271468',8998.40,0.00,0.00,0.00,674.88,'2021-12-03 16:57:10','',''),(2145158,'1','147','768',326,'Retail sales',0.00,0.00,0.00,14.06,0.00,'2021-12-03 16:57:10','',''),(2145182,'1','147','768',326,'Retail Sale Id 1271479',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 16:58:23','',''),(2145183,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 16:58:23','',''),(2145194,'1','147','768',326,'Retail Sale Id 1271487',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 16:59:30','',''),(2145195,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 16:59:30','',''),(2145226,'1','147','768',326,'Retail Sale Id 1271503',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 17:01:28','',''),(2145227,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 17:01:28','',''),(2145246,'1','147','768',326,'Retail Sale Id 1271512',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 17:02:46','',''),(2145247,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 17:02:46','',''),(2145256,'1','147','768',326,'Retail Sale Id 1271521',998.40,0.00,0.00,0.00,74.88,'2021-12-03 17:03:45','',''),(2145257,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 17:03:46','',''),(2145270,'1','147','768',326,'Retail Sale Id 1271534',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 17:04:59','',''),(2145271,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 17:04:59','',''),(2145298,'1','147','768',326,'Retail Sale Id 1271542',1900.80,0.00,0.00,0.00,142.56,'2021-12-03 17:06:09','',''),(2145299,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-03 17:06:09','',''),(2145306,'1','147','768',326,'Retail Sale Id 1271547',1299.20,0.00,0.00,0.00,97.44,'2021-12-03 17:07:13','',''),(2145307,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 17:07:13','',''),(2145316,'1','147','768',326,'Retail Sale Id 1271556',6003.20,0.00,0.00,0.00,450.24,'2021-12-03 17:08:22','',''),(2145317,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-03 17:08:22','',''),(2145333,'1','147','768',326,'Retail Sale Id 1271565',998.40,0.00,0.00,0.00,74.88,'2021-12-03 17:09:49','',''),(2145334,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 17:09:49','',''),(2145353,'1','147','768',326,'Retail Sale Id 1271572',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 17:11:52','',''),(2145354,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 17:11:52','',''),(2145371,'1','147','768',326,'Retail Sale Id 1271582',1952.00,0.00,0.00,0.00,146.40,'2021-12-03 17:13:23','',''),(2145372,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 17:13:23','',''),(2145403,'1','147','768',326,'Retail Sale Id 1271598',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 17:16:07','',''),(2145404,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 17:16:07','',''),(2145416,'1','147','768',326,'Retail Sale Id 1271604',7001.60,0.00,0.00,0.00,525.12,'2021-12-03 17:17:43','',''),(2145417,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-03 17:17:43','',''),(2145463,'1','147','768',326,'Retail Sale Id 1271629',3500.80,0.00,0.00,0.00,262.56,'2021-12-03 17:23:33','',''),(2145464,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-03 17:23:33','',''),(2145471,'1','147','768',326,'Retail Sale Id 1271633',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 17:24:29','',''),(2145474,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 17:24:29','',''),(2145485,'1','147','768',326,'Retail Sale Id 1271640',998.40,0.00,0.00,0.00,74.88,'2021-12-03 17:25:58','',''),(2145486,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 17:25:58','',''),(2145499,'1','147','768',326,'Retail Sale Id 1271646',1952.00,0.00,0.00,0.00,146.40,'2021-12-03 17:27:40','',''),(2145500,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 17:27:40','',''),(2145507,'1','147','768',326,'Retail Sale Id 1271649',1299.20,0.00,0.00,0.00,97.44,'2021-12-03 17:28:30','',''),(2145508,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 17:28:30','',''),(2145511,'1','147','768',326,'Retail Sale Id 1271651',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 17:29:12','',''),(2145512,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 17:29:12','',''),(2145523,'1','147','768',326,'Retail Sale Id 1271655',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 17:30:05','',''),(2145524,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 17:30:05','',''),(2145529,'1','147','768',326,'Retail Sale Id 1271662',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 17:31:47','',''),(2145530,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 17:31:47','',''),(2145548,'1','147','768',326,'Return of Retail Sale Id 1270530',0.00,1920000.00,3000.00,0.00,-144000.00,'2021-12-03 17:34:52','',''),(2145557,'1','147','768',326,'Retail Sale Id 1271675',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 17:35:44','',''),(2145558,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 17:35:44','',''),(2145565,'1','147','768',326,'Retail Sale Id 1271678',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 17:37:02','',''),(2145566,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 17:37:02','',''),(2145573,'1','147','768',326,'Retail Sale Id 1271694',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 17:39:29','',''),(2145574,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 17:39:29','',''),(2145585,'1','147','768',326,'Retail Sale Id 1271702',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 17:40:45','',''),(2145586,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 17:40:45','',''),(2145589,'1','147','768',326,'Retail Sale Id 1271704',1702.40,0.00,0.00,0.00,127.68,'2021-12-03 17:41:30','',''),(2145590,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-03 17:41:30','',''),(2145599,'1','147','768',326,'Retail Sale Id 1271708',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 17:42:11','',''),(2145600,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 17:42:11','',''),(2145607,'1','147','768',326,'Retail Sale Id 1271712',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 17:43:11','',''),(2145608,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 17:43:11','',''),(2145635,'1','147','768',326,'Retail Sale Id 1271724',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 17:50:05','',''),(2145636,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 17:50:05','',''),(2145719,'1','147','768',326,'Retail Sale Id 1271748',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 17:58:31','',''),(2145720,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 17:58:31','',''),(2145828,'1','147','768',326,'Retail Sale Id 1271800',3897.60,0.00,0.00,0.00,292.32,'2021-12-03 18:14:52','',''),(2145829,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-03 18:14:52','',''),(2146098,'1','147','768',326,'Retail Sale Id 1271908',28716.80,0.00,0.00,0.00,2153.76,'2021-12-03 19:20:46','',''),(2146099,'1','147','768',326,'Retail sales',0.00,0.00,0.00,44.87,0.00,'2021-12-03 19:20:46','',''),(2146487,'1','147','768',326,'Retail Sale Id 1271946',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 05:37:25','',''),(2146488,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 05:37:25','',''),(2146505,'1','147','768',326,'Retail Sale Id 1271956',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 05:49:27','',''),(2146506,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 05:49:27','',''),(2146530,'1','147','768',326,'Retail Sale Id 1271961',998.40,0.00,0.00,0.00,74.88,'2021-12-04 05:50:36','',''),(2146531,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 05:50:36','',''),(2146539,'1','147','768',326,'Retail Sale Id 1271966',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 05:52:20','',''),(2146540,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 05:52:20','',''),(2146557,'1','147','768',326,'Retail Sale Id 1271969',2598.40,0.00,0.00,0.00,194.88,'2021-12-04 05:53:50','',''),(2146558,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-04 05:53:50','',''),(2146571,'1','147','768',326,'Retail Sale Id 1271975',2598.40,0.00,0.00,0.00,194.88,'2021-12-04 05:55:37','',''),(2146572,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-04 05:55:37','',''),(2146620,'1','147','768',326,'Retail Sale Id 1271989',998.40,0.00,0.00,0.00,74.88,'2021-12-04 06:03:40','',''),(2146621,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 06:03:40','',''),(2146630,'1','147','768',326,'Retail Sale Id 1271993',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 06:07:11','',''),(2146631,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:07:11','',''),(2146640,'1','147','768',326,'Retail Sale Id 1271997',499.20,0.00,0.00,0.00,37.44,'2021-12-04 06:09:09','',''),(2146641,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-04 06:09:09','',''),(2146664,'1','147','768',326,'Retail Sale Id 1272009',6400.00,0.00,0.00,0.00,480.00,'2021-12-04 06:11:55','',''),(2146665,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 06:11:55','',''),(2146719,'1','147','768',326,'Retail Sale Id 1272020',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 06:15:40','',''),(2146720,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:15:40','',''),(2146750,'1','147','768',326,'Retail Sale Id 1272030',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 06:17:44','',''),(2146751,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:17:44','',''),(2146770,'1','147','768',326,'Retail Sale Id 1272038',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 06:19:09','',''),(2146771,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:19:09','',''),(2146785,'1','147','768',326,'Retail Sale Id 1272041',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 06:20:06','',''),(2146786,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 06:20:06','',''),(2146799,'1','147','768',326,'Retail Sale Id 1272048',998.40,0.00,0.00,0.00,74.88,'2021-12-04 06:21:13','',''),(2146800,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 06:21:13','',''),(2146877,'1','147','768',326,'Retail Sale Id 1272072',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 06:25:09','',''),(2146878,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:25:09','',''),(2146902,'1','147','768',326,'Retail Sale Id 1272083',640.00,0.00,0.00,0.00,48.00,'2021-12-04 06:26:06','',''),(2146903,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-04 06:26:06','',''),(2146938,'1','147','768',326,'Retail Sale Id 1272097',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 06:27:53','',''),(2146939,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 06:27:53','',''),(2147018,'1','147','768',326,'Retail Sale Id 1272124',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 06:31:20','',''),(2147019,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:31:20','',''),(2147040,'1','147','768',326,'Retail Sale Id 1272137',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 06:32:31','',''),(2147041,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 06:32:31','',''),(2147055,'1','147','768',326,'Retail Sale Id 1272143',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 06:33:54','',''),(2147056,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 06:33:54','',''),(2147074,'1','147','768',326,'Retail Sale Id 1272152',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 06:35:05','',''),(2147075,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 06:35:05','',''),(2147108,'1','147','768',326,'Retail Sale Id 1272162',6003.20,0.00,0.00,0.00,450.24,'2021-12-04 06:36:05','',''),(2147109,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-04 06:36:05','',''),(2147122,'1','147','768',326,'Retail Sale Id 1272171',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 06:36:57','',''),(2147123,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 06:36:57','',''),(2147134,'1','147','768',326,'Retail Sale Id 1272180',6003.20,0.00,0.00,0.00,450.24,'2021-12-04 06:37:58','',''),(2147135,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-04 06:37:58','',''),(2147170,'1','147','768',326,'Retail Sale Id 1272191',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 06:39:44','',''),(2147171,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 06:39:44','',''),(2147205,'1','147','768',326,'Retail Sale Id 1272204',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 06:40:39','',''),(2147206,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:40:39','',''),(2147215,'1','147','768',326,'Retail Sale Id 1272209',4998.40,0.00,0.00,0.00,374.88,'2021-12-04 06:41:41','',''),(2147216,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 06:41:41','',''),(2147243,'1','147','768',326,'Retail Sale Id 1272221',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 06:43:22','',''),(2147244,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 06:43:22','',''),(2147261,'1','147','768',326,'Retail Sale Id 1272230',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 06:44:34','',''),(2147262,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:44:34','',''),(2147293,'1','147','768',326,'Retail Sale Id 1272244',998.40,0.00,0.00,0.00,74.88,'2021-12-04 06:46:04','',''),(2147294,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 06:46:04','',''),(2147320,'1','147','768',326,'Retail Sale Id 1272257',3500.80,0.00,0.00,0.00,262.56,'2021-12-04 06:47:47','',''),(2147321,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 06:47:47','',''),(2147332,'1','147','768',326,'Retail Sale Id 1272264',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 06:48:46','',''),(2147333,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:48:46','',''),(2147372,'1','147','768',326,'Retail Sale Id 1272279',3500.80,0.00,0.00,0.00,262.56,'2021-12-04 06:50:19','',''),(2147373,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 06:50:19','',''),(2147398,'1','147','768',326,'Retail Sale Id 1272292',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 06:51:46','',''),(2147399,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 06:51:46','',''),(2147410,'1','147','768',326,'Retail Sale Id 1272300',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 06:52:57','',''),(2147411,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 06:52:57','',''),(2147432,'1','147','768',326,'Retail Sale Id 1272310',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 06:54:00','',''),(2147433,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:54:00','',''),(2147461,'1','147','768',326,'Retail Sale Id 1272322',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 06:55:09','',''),(2147462,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 06:55:09','',''),(2147481,'1','147','768',326,'Retail Sale Id 1272331',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 06:56:03','',''),(2147482,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 06:56:03','',''),(2147516,'1','147','768',326,'Retail Sale Id 1272342',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 06:57:29','',''),(2147517,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 06:57:29','',''),(2147536,'1','147','768',326,'Retail Sale Id 1272357',2803.20,0.00,0.00,0.00,210.24,'2021-12-04 06:58:28','',''),(2147537,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-04 06:58:28','',''),(2147556,'1','147','768',326,'Retail Sale Id 1272367',2803.20,0.00,0.00,0.00,210.24,'2021-12-04 06:59:39','',''),(2147557,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-04 06:59:39','',''),(2147574,'1','147','768',326,'Retail Sale Id 1272378',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 07:00:55','',''),(2147575,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:00:55','',''),(2147607,'1','147','768',326,'Retail Sale Id 1272393',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 07:02:05','',''),(2147608,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 07:02:05','',''),(2147627,'1','147','768',326,'Retail Sale Id 1272399',998.40,0.00,0.00,0.00,74.88,'2021-12-04 07:03:11','',''),(2147628,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 07:03:11','',''),(2147645,'1','147','768',326,'Retail Sale Id 1272408',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 07:04:46','',''),(2147646,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 07:04:46','',''),(2147669,'1','147','768',326,'Retail Sale Id 1272419',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 07:05:52','',''),(2147670,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 07:05:52','',''),(2147687,'1','147','768',326,'Retail Sale Id 1272430',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 07:06:59','',''),(2147688,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 07:06:59','',''),(2147711,'1','147','768',326,'Retail Sale Id 1272443',697.60,0.00,0.00,0.00,52.32,'2021-12-04 07:08:06','',''),(2147712,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-04 07:08:06','',''),(2147732,'1','147','768',326,'Retail Sale Id 1272449',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 07:09:32','',''),(2147733,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 07:09:32','',''),(2147750,'1','147','768',326,'Retail Sale Id 1272466',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 07:10:45','',''),(2147751,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 07:10:45','',''),(2147772,'1','147','768',326,'Retail Sale Id 1272477',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 07:11:58','',''),(2147773,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 07:11:58','',''),(2147796,'1','147','768',326,'Retail Sale Id 1272489',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 07:13:23','',''),(2147797,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 07:13:23','',''),(2147817,'1','147','768',326,'Retail Sale Id 1272500',998.40,0.00,0.00,0.00,74.88,'2021-12-04 07:14:38','',''),(2147818,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 07:14:38','',''),(2147843,'1','147','768',326,'Retail Sale Id 1272525',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 07:15:55','',''),(2147844,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 07:15:55','',''),(2147868,'1','147','768',326,'Retail Sale Id 1272532',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 07:16:51','',''),(2147869,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 07:16:51','',''),(2147894,'1','147','768',326,'Retail Sale Id 1272545',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 07:18:08','',''),(2147895,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 07:18:08','',''),(2147914,'1','147','768',326,'Retail Sale Id 1272555',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 07:19:05','',''),(2147915,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 07:19:05','',''),(2147930,'1','147','768',326,'Retail Sale Id 1272564',1600.00,0.00,0.00,0.00,120.00,'2021-12-04 07:20:03','',''),(2147931,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-04 07:20:03','',''),(2147952,'1','147','768',326,'Retail Sale Id 1272576',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 07:21:17','',''),(2147953,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 07:21:17','',''),(2147974,'1','147','768',326,'Retail Sale Id 1272587',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 07:22:15','',''),(2147975,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:22:15','',''),(2147986,'1','147','768',326,'Retail Sale Id 1272594',998.40,0.00,0.00,0.00,74.88,'2021-12-04 07:23:15','',''),(2147987,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 07:23:15','',''),(2148006,'1','147','768',326,'Retail Sale Id 1272603',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 07:24:15','',''),(2148007,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 07:24:15','',''),(2148028,'1','147','768',326,'Retail Sale Id 1272616',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 07:25:35','',''),(2148029,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 07:25:35','',''),(2148058,'1','147','768',326,'Retail Sale Id 1272632',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 07:26:42','',''),(2148059,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:26:42','',''),(2148082,'1','147','768',326,'Retail Sale Id 1272644',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 07:27:47','',''),(2148083,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 07:27:47','',''),(2148102,'1','147','768',326,'Retail Sale Id 1272656',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 07:28:50','',''),(2148103,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 07:28:50','',''),(2148116,'1','147','768',326,'Retail Sale Id 1272661',1798.40,0.00,0.00,0.00,134.88,'2021-12-04 07:29:45','',''),(2148117,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-04 07:29:45','',''),(2148148,'1','147','768',326,'Retail Sale Id 1272672',4998.40,0.00,0.00,0.00,374.88,'2021-12-04 07:30:57','',''),(2148149,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 07:30:57','',''),(2148180,'1','147','768',326,'Retail Sale Id 1272692',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 07:32:24','',''),(2148181,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 07:32:24','',''),(2148192,'1','147','768',326,'Retail Sale Id 1272698',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 07:33:29','',''),(2148193,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 07:33:29','',''),(2148226,'1','147','768',326,'Retail Sale Id 1272720',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 07:34:48','',''),(2148227,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 07:34:48','',''),(2148260,'1','147','768',326,'Retail Sale Id 1272741',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 07:35:55','',''),(2148261,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:35:55','',''),(2148275,'1','147','768',326,'Retail Sale Id 1272751',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 07:37:03','',''),(2148276,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:37:03','',''),(2148357,'1','147','768',326,'Retail Sale Id 1272791',6003.20,0.00,0.00,0.00,450.24,'2021-12-04 07:40:21','',''),(2148358,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-04 07:40:21','',''),(2148375,'1','147','768',326,'Retail Sale Id 1272808',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 07:41:31','',''),(2148376,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 07:41:31','',''),(2148398,'1','147','768',326,'Retail Sale Id 1272838',998.40,0.00,0.00,0.00,74.88,'2021-12-04 07:42:45','',''),(2148399,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 07:42:45','',''),(2148434,'1','147','768',326,'Retail Sale Id 1272879',5849.60,0.00,0.00,0.00,438.72,'2021-12-04 07:45:01','',''),(2148435,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.14,0.00,'2021-12-04 07:45:01','',''),(2148458,'1','147','768',326,'Retail Sale Id 1272895',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 07:46:27','',''),(2148459,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 07:46:27','',''),(2148478,'1','147','768',326,'Retail Sale Id 1272910',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 07:47:55','',''),(2148479,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 07:47:55','',''),(2148500,'1','147','768',326,'Retail Sale Id 1272923',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 07:49:06','',''),(2148501,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 07:49:06','',''),(2148527,'1','147','768',326,'Retail Sale Id 1272937',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 07:50:39','',''),(2148528,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 07:50:39','',''),(2148543,'1','147','768',326,'Retail Sale Id 1272946',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 07:51:48','',''),(2148544,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 07:51:49','',''),(2148562,'1','147','768',326,'Retail Sale Id 1272963',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 07:53:05','',''),(2148563,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 07:53:05','',''),(2148576,'1','147','768',326,'Retail Sale Id 1272971',1100.80,0.00,0.00,0.00,82.56,'2021-12-04 07:54:26','',''),(2148577,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.72,0.00,'2021-12-04 07:54:26','',''),(2148604,'1','147','768',326,'Retail Sale Id 1272979',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 07:55:49','',''),(2148605,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 07:55:49','',''),(2148643,'1','147','768',326,'Retail Sale Id 1273020',5120.00,0.00,0.00,0.00,384.00,'2021-12-04 07:58:00','',''),(2148644,'1','147','768',326,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 07:58:00','',''),(2148687,'1','147','768',326,'Retail Sale Id 1273040',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 07:59:50','',''),(2148688,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 07:59:50','',''),(2148713,'1','147','768',326,'Retail Sale Id 1273048',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 08:00:45','',''),(2148714,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 08:00:45','',''),(2148739,'1','147','768',326,'Retail Sale Id 1273061',652.80,0.00,0.00,0.00,48.96,'2021-12-04 08:02:01','',''),(2148740,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-04 08:02:01','',''),(2148757,'1','147','768',326,'Retail Sale Id 1273072',998.40,0.00,0.00,0.00,74.88,'2021-12-04 08:02:57','',''),(2148758,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 08:02:57','',''),(2148793,'1','147','768',326,'Retail Sale Id 1273087',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 08:04:25','',''),(2148794,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 08:04:25','',''),(2148819,'1','147','768',326,'Retail Sale Id 1273104',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 08:05:29','',''),(2148820,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:05:29','',''),(2148848,'1','147','768',326,'Retail Sale Id 1273122',4998.40,0.00,0.00,0.00,374.88,'2021-12-04 08:06:25','',''),(2148849,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 08:06:25','',''),(2148868,'1','147','768',326,'Retail Sale Id 1273128',6400.00,0.00,0.00,0.00,480.00,'2021-12-04 08:07:13','',''),(2148869,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 08:07:13','',''),(2148894,'1','147','768',326,'Retail Sale Id 1273156',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 08:08:32','',''),(2148895,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 08:08:32','',''),(2148914,'1','147','768',326,'Retail Sale Id 1273166',652.80,0.00,0.00,0.00,48.96,'2021-12-04 08:09:55','',''),(2148915,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-04 08:09:55','',''),(2148946,'1','147','768',326,'Retail Sale Id 1273184',3801.60,0.00,0.00,0.00,285.12,'2021-12-04 08:11:20','',''),(2148947,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-04 08:11:20','',''),(2148978,'1','147','768',326,'Retail Sale Id 1273197',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 08:12:26','',''),(2148979,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:12:26','',''),(2149000,'1','147','768',326,'Retail Sale Id 1273206',998.40,0.00,0.00,0.00,74.88,'2021-12-04 08:13:23','',''),(2149001,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 08:13:23','',''),(2149054,'1','147','768',326,'Retail Sale Id 1273231',11200.00,0.00,0.00,0.00,840.00,'2021-12-04 08:15:04','',''),(2149055,'1','147','768',326,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-04 08:15:04','',''),(2149158,'1','147','768',326,'Retail Sale Id 1273280',499.20,0.00,0.00,0.00,37.44,'2021-12-04 08:19:45','',''),(2149159,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-04 08:19:45','',''),(2149190,'1','147','768',326,'Retail Sale Id 1273293',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 08:20:56','',''),(2149191,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:20:56','',''),(2149210,'1','147','768',326,'Retail Sale Id 1273325',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 08:22:06','',''),(2149211,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 08:22:06','',''),(2149251,'1','147','768',326,'Retail Sale Id 1273386',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 08:23:45','',''),(2149252,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:23:45','',''),(2149272,'1','147','768',326,'Retail Sale Id 1273396',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 08:24:33','',''),(2149273,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 08:24:33','',''),(2149284,'1','147','768',326,'Retail Sale Id 1273405',998.40,0.00,0.00,0.00,74.88,'2021-12-04 08:25:06','',''),(2149285,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 08:25:06','',''),(2149294,'1','147','768',326,'Retail Sale Id 1273410',998.40,0.00,0.00,0.00,74.88,'2021-12-04 08:25:39','',''),(2149295,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 08:25:39','',''),(2149308,'1','147','768',326,'Retail Sale Id 1273415',6003.20,0.00,0.00,0.00,450.24,'2021-12-04 08:26:18','',''),(2149309,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-04 08:26:18','',''),(2149320,'1','147','768',326,'Retail Sale Id 1273421',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 08:27:04','',''),(2149321,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 08:27:04','',''),(2149338,'1','147','768',326,'Retail Sale Id 1273430',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 08:27:40','',''),(2149339,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:27:40','',''),(2149360,'1','147','768',326,'Retail Sale Id 1273440',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 08:28:24','',''),(2149361,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:28:24','',''),(2149372,'1','147','768',326,'Retail Sale Id 1273446',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 08:28:56','',''),(2149373,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:28:56','',''),(2149384,'1','147','768',326,'Retail Sale Id 1273454',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 08:29:29','',''),(2149385,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:29:29','',''),(2149408,'1','147','768',326,'Retail Sale Id 1273465',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 08:30:25','',''),(2149409,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 08:30:25','',''),(2149440,'1','147','768',326,'Retail Sale Id 1273513',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 08:31:13','',''),(2149441,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:31:13','',''),(2149483,'1','147','768',326,'Retail Sale Id 1273523',998.40,0.00,0.00,0.00,74.88,'2021-12-04 08:31:57','',''),(2149484,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 08:31:57','',''),(2149497,'1','147','768',326,'Retail Sale Id 1273530',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 08:32:34','',''),(2149498,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:32:34','',''),(2149511,'1','147','768',326,'Retail Sale Id 1273538',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 08:33:16','',''),(2149512,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 08:33:16','',''),(2149527,'1','147','768',326,'Retail Sale Id 1273545',7001.60,0.00,0.00,0.00,525.12,'2021-12-04 08:33:58','',''),(2149528,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-04 08:33:58','',''),(2149549,'1','147','768',326,'Retail Sale Id 1273555',4998.40,0.00,0.00,0.00,374.88,'2021-12-04 08:34:37','',''),(2149550,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 08:34:37','',''),(2149564,'1','147','768',326,'Retail Sale Id 1273564',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 08:35:13','',''),(2149565,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:35:13','',''),(2149608,'1','147','768',326,'Retail Sale Id 1273590',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 08:37:22','',''),(2149609,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:37:22','',''),(2149650,'1','147','768',326,'Retail Sale Id 1273599',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 08:38:05','',''),(2149651,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:38:05','',''),(2149660,'1','147','768',326,'Retail Sale Id 1273604',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 08:38:44','',''),(2149661,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:38:44','',''),(2149668,'1','147','768',326,'Retail Sale Id 1273611',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 08:39:30','',''),(2149669,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 08:39:30','',''),(2149682,'1','147','768',326,'Retail Sale Id 1273616',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 08:40:04','',''),(2149683,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 08:40:04','',''),(2149692,'1','147','768',326,'Retail Sale Id 1273620',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 08:40:46','',''),(2149693,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 08:40:46','',''),(2149704,'1','147','768',326,'Retail Sale Id 1273627',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 08:41:33','',''),(2149705,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:41:33','',''),(2149727,'1','147','768',326,'Retail Sale Id 1273637',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 08:42:10','',''),(2149728,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:42:10','',''),(2149733,'1','147','768',326,'Retail Sale Id 1273640',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 08:42:46','',''),(2149734,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 08:42:46','',''),(2149768,'1','147','768',326,'Retail Sale Id 1273659',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 08:43:45','',''),(2149769,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 08:43:45','',''),(2149786,'1','147','768',326,'Retail Sale Id 1273667',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 08:44:20','',''),(2149787,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:44:20','',''),(2149802,'1','147','768',326,'Retail Sale Id 1273676',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 08:44:58','',''),(2149803,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 08:44:58','',''),(2149820,'1','147','768',326,'Retail Sale Id 1273688',1920.00,0.00,0.00,0.00,144.00,'2021-12-04 08:45:49','',''),(2149821,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:45:49','',''),(2149842,'1','147','768',326,'Retail Sale Id 1273699',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 08:46:33','',''),(2149845,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 08:46:33','',''),(2149862,'1','147','768',326,'Retail Sale Id 1273708',2598.40,0.00,0.00,0.00,194.88,'2021-12-04 08:47:20','',''),(2149863,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-04 08:47:20','',''),(2149884,'1','147','768',326,'Retail Sale Id 1273718',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 08:48:11','',''),(2149885,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 08:48:11','',''),(2149896,'1','147','768',326,'Retail Sale Id 1273723',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 08:48:48','',''),(2149897,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 08:48:48','',''),(2149908,'1','147','768',326,'Retail Sale Id 1273732',4998.40,0.00,0.00,0.00,374.88,'2021-12-04 08:49:48','',''),(2149909,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 08:49:48','',''),(2149930,'1','147','768',326,'Retail Sale Id 1273747',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 08:50:36','',''),(2149931,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 08:50:37','',''),(2149944,'1','147','768',326,'Retail Sale Id 1273754',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 08:51:29','',''),(2149945,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:51:29','',''),(2149962,'1','147','768',326,'Retail Sale Id 1273763',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 08:52:25','',''),(2149963,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 08:52:25','',''),(2149982,'1','147','768',326,'Retail Sale Id 1273778',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 08:53:08','',''),(2149983,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 08:53:08','',''),(2149996,'1','147','768',326,'Retail Sale Id 1273786',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 08:53:46','',''),(2149997,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 08:53:46','',''),(2150012,'1','147','768',326,'Retail Sale Id 1273793',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 08:54:34','',''),(2150013,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:54:34','',''),(2150027,'1','147','768',326,'Retail Sale Id 1273799',7001.60,0.00,0.00,0.00,525.12,'2021-12-04 08:55:13','',''),(2150028,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-04 08:55:13','',''),(2150039,'1','147','768',326,'Retail Sale Id 1273805',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 08:55:48','',''),(2150040,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 08:55:48','',''),(2150061,'1','147','768',326,'Retail Sale Id 1273818',998.40,0.00,0.00,0.00,74.88,'2021-12-04 08:56:51','',''),(2150062,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 08:56:51','',''),(2150083,'1','147','768',326,'Retail Sale Id 1273830',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 08:57:37','',''),(2150084,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 08:57:37','',''),(2150115,'1','147','768',326,'Retail Sale Id 1273845',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 08:59:12','',''),(2150116,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:59:12','',''),(2150159,'1','147','768',326,'Retail Sale Id 1273866',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 09:01:21','',''),(2150160,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 09:01:21','',''),(2150181,'1','147','768',326,'Retail Sale Id 1273877',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:02:28','',''),(2150182,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:02:28','',''),(2150251,'1','147','768',326,'Retail Sale Id 1273923',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:05:40','',''),(2150252,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:05:40','',''),(2150327,'1','147','768',326,'Retail Sale Id 1273962',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 09:09:59','',''),(2150328,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 09:09:59','',''),(2150341,'1','147','768',326,'Retail Sale Id 1273970',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 09:10:39','',''),(2150342,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 09:10:39','',''),(2150355,'1','147','768',326,'Retail Sale Id 1273974',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:11:29','',''),(2150356,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:11:29','',''),(2150373,'1','147','768',326,'Retail Sale Id 1273984',998.40,0.00,0.00,0.00,74.88,'2021-12-04 09:12:31','',''),(2150374,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 09:12:31','',''),(2150395,'1','147','768',326,'Retail Sale Id 1273993',1920.00,0.00,0.00,0.00,144.00,'2021-12-04 09:13:22','',''),(2150396,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 09:13:22','',''),(2150423,'1','147','768',326,'Retail Sale Id 1274007',4998.40,0.00,0.00,0.00,374.88,'2021-12-04 09:14:57','',''),(2150424,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 09:14:57','',''),(2150441,'1','147','768',326,'Retail Sale Id 1274019',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 09:15:54','',''),(2150442,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 09:15:54','',''),(2150461,'1','147','768',326,'Retail Sale Id 1274028',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:16:40','',''),(2150462,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:16:40','',''),(2150599,'1','147','768',326,'Retail Sale Id 1274102',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 09:22:51','',''),(2150600,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 09:22:51','',''),(2150629,'1','147','768',326,'Retail Sale Id 1274118',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 09:23:49','',''),(2150630,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 09:23:49','',''),(2150649,'1','147','768',326,'Retail Sale Id 1274130',998.40,0.00,0.00,0.00,74.88,'2021-12-04 09:25:50','',''),(2150650,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 09:25:50','',''),(2150675,'1','147','768',326,'Retail Sale Id 1274141',1900.80,0.00,0.00,0.00,142.56,'2021-12-04 09:26:34','',''),(2150676,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-04 09:26:34','',''),(2150683,'1','147','768',326,'Retail Sale Id 1274144',499.20,0.00,0.00,0.00,37.44,'2021-12-04 09:27:13','',''),(2150684,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-04 09:27:13','',''),(2150700,'1','147','768',326,'Retail Sale Id 1274152',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:27:59','',''),(2150701,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:27:59','',''),(2150712,'1','147','768',326,'Retail Sale Id 1274160',7001.60,0.00,0.00,0.00,525.12,'2021-12-04 09:28:43','',''),(2150713,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-04 09:28:43','',''),(2150726,'1','147','768',326,'Retail Sale Id 1274165',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 09:29:26','',''),(2150727,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 09:29:26','',''),(2150792,'1','147','768',326,'Retail Sale Id 1274205',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 09:32:30','',''),(2150793,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 09:32:30','',''),(2150804,'1','147','768',326,'Retail Sale Id 1274210',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:33:08','',''),(2150805,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:33:08','',''),(2150826,'1','147','768',326,'Retail Sale Id 1274224',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 09:34:19','',''),(2150827,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 09:34:19','',''),(2152398,'1','147','768',326,'Retail Sale Id 1274283',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 10:29:21','',''),(2152399,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 10:29:21','',''),(2152400,'1','147','768',326,'Retail Sale Id 1274283',6400.00,0.00,0.00,0.00,480.00,'2021-12-04 10:29:21','',''),(2152401,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 10:29:22','',''),(2152424,'1','147','768',326,'Retail Sale Id 1274378',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 10:30:54','',''),(2152425,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:30:54','',''),(2152461,'1','147','768',326,'Retail Sale Id 1274391',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 10:33:29','',''),(2152462,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 10:33:29','',''),(2152476,'1','147','768',326,'Retail Sale Id 1274396',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 10:34:37','',''),(2152477,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 10:34:37','',''),(2152498,'1','147','768',326,'Retail Sale Id 1274406',198.40,0.00,0.00,0.00,14.88,'2021-12-04 10:36:19','',''),(2152499,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.31,0.00,'2021-12-04 10:36:19','',''),(2152513,'1','147','768',326,'Retail Sale Id 1274412',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 10:37:40','',''),(2152514,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 10:37:40','',''),(2152525,'1','147','768',326,'Retail Sale Id 1274417',6400.00,0.00,0.00,0.00,480.00,'2021-12-04 10:39:13','',''),(2152526,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 10:39:13','',''),(2152541,'1','147','768',326,'Retail Sale Id 1274424',1100.80,0.00,0.00,0.00,82.56,'2021-12-04 10:40:36','',''),(2152542,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.72,0.00,'2021-12-04 10:40:36','',''),(2152549,'1','147','768',326,'Retail Sale Id 1274429',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 10:41:36','',''),(2152550,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 10:41:36','',''),(2152575,'1','147','768',326,'Retail Sale Id 1274435',3500.80,0.00,0.00,0.00,262.56,'2021-12-04 10:42:47','',''),(2152576,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 10:42:47','',''),(2152654,'1','147','768',326,'Retail Sale Id 1274461',998.40,0.00,0.00,0.00,74.88,'2021-12-04 10:47:24','',''),(2152655,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 10:47:24','',''),(2152666,'1','147','768',326,'Retail Sale Id 1274468',800.00,0.00,0.00,0.00,60.00,'2021-12-04 10:48:24','',''),(2152667,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-04 10:48:24','',''),(2152690,'1','147','768',326,'Retail Sale Id 1274477',4998.40,0.00,0.00,0.00,374.88,'2021-12-04 10:49:48','',''),(2152691,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 10:49:48','',''),(2152714,'1','147','768',326,'Retail Sale Id 1274489',6400.00,0.00,0.00,0.00,480.00,'2021-12-04 10:50:52','',''),(2152715,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 10:50:52','',''),(2152736,'1','147','768',326,'Retail Sale Id 1274498',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 10:52:01','',''),(2152737,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 10:52:01','',''),(2152779,'1','147','768',326,'Retail Sale Id 1274514',1100.80,0.00,0.00,0.00,82.56,'2021-12-04 10:54:07','',''),(2152780,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.72,0.00,'2021-12-04 10:54:07','',''),(2152799,'1','147','768',326,'Retail Sale Id 1274521',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 10:55:05','',''),(2152800,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 10:55:05','',''),(2152841,'1','147','768',326,'Retail Sale Id 1274542',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 10:57:48','',''),(2152842,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 10:57:48','',''),(2152891,'1','147','768',326,'Retail Sale Id 1274565',1299.20,0.00,0.00,0.00,97.44,'2021-12-04 11:00:44','',''),(2152892,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 11:00:44','',''),(2152920,'1','147','768',326,'Retail Sale Id 1274579',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 11:02:08','',''),(2152921,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 11:02:08','',''),(2152946,'1','147','768',326,'Retail Sale Id 1274589',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 11:03:15','',''),(2152947,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:03:15','',''),(2152976,'1','147','768',326,'Retail Sale Id 1274606',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 11:04:50','',''),(2152977,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 11:04:50','',''),(2153014,'1','147','768',326,'Retail Sale Id 1274625',1299.20,0.00,0.00,0.00,97.44,'2021-12-04 11:06:58','',''),(2153015,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 11:06:58','',''),(2153042,'1','147','768',326,'Retail Sale Id 1274638',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 11:08:15','',''),(2153043,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:08:15','',''),(2153072,'1','147','768',326,'Retail Sale Id 1274654',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 11:09:34','',''),(2153073,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:09:34','',''),(2153169,'1','147','768',326,'Retail Sale Id 1274699',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 11:14:19','',''),(2153170,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 11:14:19','',''),(2153209,'1','147','768',326,'Retail Sale Id 1274725',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 11:16:14','',''),(2153210,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 11:16:14','',''),(2153227,'1','147','768',326,'Retail Sale Id 1274732',3500.80,0.00,0.00,0.00,262.56,'2021-12-04 11:17:03','',''),(2153228,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 11:17:03','',''),(2153245,'1','147','768',326,'Retail Sale Id 1274743',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 11:17:47','',''),(2153246,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:17:47','',''),(2153267,'1','147','768',326,'Retail Sale Id 1274754',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 11:18:50','',''),(2153268,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:18:50','',''),(2153317,'1','147','768',326,'Retail Sale Id 1274776',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 11:21:15','',''),(2153318,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 11:21:15','',''),(2153334,'1','147','768',326,'Retail Sale Id 1274785',1299.20,0.00,0.00,0.00,97.44,'2021-12-04 11:22:23','',''),(2153335,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 11:22:23','',''),(2153348,'1','147','768',326,'Retail Sale Id 1274792',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 11:23:28','',''),(2153349,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 11:23:28','',''),(2153366,'1','147','768',326,'Retail Sale Id 1274801',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 11:24:25','',''),(2153367,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 11:24:25','',''),(2153383,'1','147','768',326,'Retail Sale Id 1274809',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 11:25:43','',''),(2153384,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 11:25:43','',''),(2153422,'1','147','768',326,'Retail Sale Id 1274834',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 11:28:10','',''),(2153423,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 11:28:10','',''),(2153505,'1','147','768',326,'Retail Sale Id 1274878',3500.80,0.00,0.00,0.00,262.56,'2021-12-04 11:32:17','',''),(2153506,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 11:32:17','',''),(2153539,'1','147','768',326,'Retail Sale Id 1274892',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 11:33:49','',''),(2153540,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 11:33:49','',''),(2153558,'1','147','768',326,'Retail Sale Id 1274903',998.40,0.00,0.00,0.00,74.88,'2021-12-04 11:35:02','',''),(2153559,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 11:35:02','',''),(2153582,'1','147','768',326,'Retail Sale Id 1274914',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 11:36:03','',''),(2153583,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 11:36:03','',''),(2153657,'1','147','768',326,'Retail Sale Id 1274942',6003.20,0.00,0.00,0.00,450.24,'2021-12-04 11:38:54','',''),(2153658,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-04 11:38:54','',''),(2153674,'1','147','768',326,'Retail Sale Id 1274949',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 11:39:48','',''),(2153675,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 11:39:48','',''),(2153691,'1','147','768',326,'Retail Sale Id 1274957',4998.40,0.00,0.00,0.00,374.88,'2021-12-04 11:40:51','',''),(2153692,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 11:40:51','',''),(2153717,'1','147','768',326,'Retail Sale Id 1274970',10598.40,0.00,0.00,0.00,794.88,'2021-12-04 11:43:07','',''),(2153718,'1','147','768',326,'Retail sales',0.00,0.00,0.00,16.56,0.00,'2021-12-04 11:43:07','',''),(2153737,'1','147','768',326,'Retail Sale Id 1274980',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 11:44:32','',''),(2153738,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:44:32','',''),(2153760,'1','147','768',326,'Retail Sale Id 1274989',998.40,0.00,0.00,0.00,74.88,'2021-12-04 11:45:35','',''),(2153761,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 11:45:35','',''),(2153784,'1','147','768',326,'Retail Sale Id 1275000',998.40,0.00,0.00,0.00,74.88,'2021-12-04 11:46:46','',''),(2153785,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 11:46:46','',''),(2153859,'1','147','768',326,'Retail Sale Id 1275028',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 11:51:05','',''),(2153860,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 11:51:05','',''),(2153915,'1','147','768',326,'Retail Sale Id 1275050',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 11:53:52','',''),(2153916,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 11:53:52','',''),(2154200,'1','147','768',326,'Retail Sale Id 1275129',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 12:06:07','',''),(2154201,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 12:06:07','',''),(2154270,'1','147','768',326,'Retail Sale Id 1275165',4998.40,0.00,0.00,0.00,374.88,'2021-12-04 12:10:04','',''),(2154271,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 12:10:04','',''),(2154291,'1','147','768',326,'Retail Sale Id 1275178',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 12:11:27','',''),(2154292,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 12:11:27','',''),(2154313,'1','147','768',326,'Retail Sale Id 1275186',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 12:12:25','',''),(2154314,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 12:12:25','',''),(2154317,'1','147','768',326,'Retail Sale Id 1275189',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 12:13:04','',''),(2154318,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 12:13:04','',''),(2154337,'1','147','768',326,'Retail Sale Id 1275199',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 12:14:11','',''),(2154338,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 12:14:11','',''),(2154373,'1','147','768',326,'Retail Sale Id 1275219',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 12:16:35','',''),(2154374,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 12:16:35','',''),(2154385,'1','147','768',326,'Retail Sale Id 1275225',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 12:17:49','',''),(2154386,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:17:49','',''),(2154501,'1','147','768',326,'Retail Sale Id 1275287',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 12:26:12','',''),(2154502,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:26:12','',''),(2154527,'1','147','768',326,'Retail Sale Id 1275297',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 12:26:53','',''),(2154528,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 12:26:53','',''),(2154551,'1','147','768',326,'Retail Sale Id 1275308',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 12:28:07','',''),(2154552,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 12:28:07','',''),(2154576,'1','147','768',326,'Retail Sale Id 1275313',998.40,0.00,0.00,0.00,74.88,'2021-12-04 12:29:38','',''),(2154577,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 12:29:38','',''),(2154595,'1','147','768',326,'Retail Sale Id 1275331',1900.80,0.00,0.00,0.00,142.56,'2021-12-04 12:30:23','',''),(2154596,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-04 12:30:23','',''),(2154609,'1','147','768',326,'Retail Sale Id 1275339',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 12:31:07','',''),(2154610,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 12:31:07','',''),(2154613,'1','147','768',326,'Retail Sale Id 1275342',4998.40,0.00,0.00,0.00,374.88,'2021-12-04 12:31:43','',''),(2154614,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 12:31:43','',''),(2154667,'1','147','768',326,'Retail Sale Id 1275363',6400.00,0.00,0.00,0.00,480.00,'2021-12-04 12:34:23','',''),(2154668,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 12:34:23','',''),(2154687,'1','147','768',326,'Retail Sale Id 1275376',998.40,0.00,0.00,0.00,74.88,'2021-12-04 12:36:17','',''),(2154688,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 12:36:17','',''),(2154703,'1','147','768',326,'Retail Sale Id 1275384',697.60,0.00,0.00,0.00,52.32,'2021-12-04 12:36:55','',''),(2154704,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-04 12:36:55','',''),(2154717,'1','147','768',326,'Retail Sale Id 1275392',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 12:37:58','',''),(2154718,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 12:37:58','',''),(2154756,'1','147','768',326,'Retail Sale Id 1275408',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 12:40:12','',''),(2154757,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:40:12','',''),(2154778,'1','147','768',326,'Retail Sale Id 1275424',998.40,0.00,0.00,0.00,74.88,'2021-12-04 12:42:07','',''),(2154779,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 12:42:07','',''),(2154796,'1','147','768',326,'Retail Sale Id 1275433',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 12:43:57','',''),(2154797,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 12:43:57','',''),(2154810,'1','147','768',326,'Retail Sale Id 1275436',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 12:45:02','',''),(2154811,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 12:45:02','',''),(2154817,'1','147','768',326,'Retail Sale Id 1275441',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 12:45:56','',''),(2154818,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 12:45:56','',''),(2154831,'1','147','768',326,'Retail Sale Id 1275450',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 12:47:02','',''),(2154832,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 12:47:02','',''),(2154938,'1','147','768',326,'Retail Sale Id 1275488',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 12:52:59','',''),(2154939,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:52:59','',''),(2154954,'1','147','768',326,'Retail Sale Id 1275499',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 12:54:00','',''),(2154955,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 12:54:00','',''),(2155013,'1','147','768',326,'Retail Sale Id 1275678',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 13:04:44','',''),(2155014,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:04:44','',''),(2155049,'1','147','768',326,'Retail Sale Id 1275754',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 13:06:41','',''),(2155050,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 13:06:41','',''),(2155065,'1','147','768',326,'Retail Sale Id 1275771',1299.20,0.00,0.00,0.00,97.44,'2021-12-04 13:07:28','',''),(2155066,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 13:07:28','',''),(2155155,'1','147','768',326,'Retail Sale Id 1275810',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 13:13:46','',''),(2155156,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:13:46','',''),(2155172,'1','147','768',326,'Retail Sale Id 1275817',998.40,0.00,0.00,0.00,74.88,'2021-12-04 13:14:36','',''),(2155173,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 13:14:36','',''),(2155242,'1','147','768',326,'Retail Sale Id 1275845',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 13:19:14','',''),(2155243,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 13:19:14','',''),(2155273,'1','147','768',326,'Retail Sale Id 1275857',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 13:21:02','',''),(2155274,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 13:21:02','',''),(2155296,'1','147','768',326,'Retail Sale Id 1275866',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 13:22:09','',''),(2155297,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 13:22:09','',''),(2155321,'1','147','768',326,'Retail Sale Id 1275876',998.40,0.00,0.00,0.00,74.88,'2021-12-04 13:23:36','',''),(2155322,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 13:23:36','',''),(2155355,'1','147','768',326,'Retail Sale Id 1275886',998.40,0.00,0.00,0.00,74.88,'2021-12-04 13:24:56','',''),(2155356,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 13:24:56','',''),(2155396,'1','147','768',326,'Retail Sale Id 1275900',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 13:26:45','',''),(2155397,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 13:26:45','',''),(2155476,'1','147','768',326,'Retail Sale Id 1275925',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 13:29:54','',''),(2155477,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 13:29:54','',''),(2155500,'1','147','768',326,'Retail Sale Id 1275938',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 13:31:03','',''),(2155501,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 13:31:03','',''),(2155525,'1','147','768',326,'Retail Sale Id 1275949',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 13:32:22','',''),(2155526,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 13:32:22','',''),(2155545,'1','147','768',326,'Retail Sale Id 1275959',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 13:33:38','',''),(2155546,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 13:33:38','',''),(2155594,'1','147','768',326,'Retail Sale Id 1275978',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 13:36:16','',''),(2155595,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 13:36:16','',''),(2155606,'1','147','768',326,'Retail Sale Id 1275987',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 13:37:16','',''),(2155607,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 13:37:16','',''),(2155624,'1','147','768',326,'Retail Sale Id 1275996',998.40,0.00,0.00,0.00,74.88,'2021-12-04 13:38:06','',''),(2155625,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 13:38:06','',''),(2155660,'1','147','768',326,'Retail Sale Id 1276011',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 13:40:05','',''),(2155661,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 13:40:05','',''),(2155690,'1','147','768',326,'Retail Sale Id 1276025',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 13:41:55','',''),(2155691,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 13:41:55','',''),(2155714,'1','147','768',326,'Retail Sale Id 1276043',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 13:42:57','',''),(2155715,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 13:42:57','',''),(2155740,'1','147','768',326,'Retail Sale Id 1276052',7500.80,0.00,0.00,0.00,562.56,'2021-12-04 13:44:49','',''),(2155741,'1','147','768',326,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-04 13:44:49','',''),(2155764,'1','147','768',326,'Retail Sale Id 1276068',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 13:46:17','',''),(2155765,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 13:46:17','',''),(2155792,'1','147','768',326,'Retail Sale Id 1276082',1299.20,0.00,0.00,0.00,97.44,'2021-12-04 13:47:28','',''),(2155793,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 13:47:28','',''),(2155818,'1','147','768',326,'Retail Sale Id 1276091',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 13:48:21','',''),(2155819,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 13:48:21','',''),(2155922,'1','147','768',326,'Retail Sale Id 1276129',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 13:52:51','',''),(2155923,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 13:52:51','',''),(2155952,'1','147','768',326,'Retail Sale Id 1276145',2297.60,0.00,0.00,0.00,172.32,'2021-12-04 13:54:54','',''),(2155953,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.59,0.00,'2021-12-04 13:54:54','',''),(2155966,'1','147','768',326,'Retail Sale Id 1276154',7500.80,0.00,0.00,0.00,562.56,'2021-12-04 13:55:52','',''),(2155967,'1','147','768',326,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-04 13:55:52','',''),(2155997,'1','147','768',326,'Retail Sale Id 1276163',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 13:57:04','',''),(2155998,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:57:04','',''),(2156047,'1','147','768',326,'Retail Sale Id 1276189',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 13:59:34','',''),(2156048,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 13:59:34','',''),(2156049,'1','147','768',326,'Retail Sale Id 1276189',6400.00,0.00,0.00,0.00,480.00,'2021-12-04 13:59:34','',''),(2156050,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 13:59:34','',''),(2156051,'1','147','768',326,'Retail Sale Id 1276189',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 13:59:34','',''),(2156052,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:59:34','',''),(2156066,'1','147','768',326,'Retail Sale Id 1276197',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 14:00:13','',''),(2156067,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 14:00:13','',''),(2156112,'1','147','768',326,'Retail Sale Id 1276213',998.40,0.00,0.00,0.00,74.88,'2021-12-04 14:01:54','',''),(2156113,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 14:01:54','',''),(2156214,'1','147','768',326,'Retail Sale Id 1276249',3500.80,0.00,0.00,0.00,262.56,'2021-12-04 14:05:11','',''),(2156215,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 14:05:11','',''),(2156235,'1','147','768',326,'Retail Sale Id 1276260',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 14:06:09','',''),(2156236,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 14:06:09','',''),(2156295,'1','147','768',326,'Retail Sale Id 1276295',6400.00,0.00,0.00,0.00,480.00,'2021-12-04 14:09:12','',''),(2156296,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 14:09:12','',''),(2156375,'1','147','768',326,'Retail Sale Id 1276335',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 14:13:16','',''),(2156376,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 14:13:16','',''),(2156657,'1','147','768',326,'Retail Sale Id 1276471',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 14:27:15','',''),(2156658,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 14:27:15','',''),(2156673,'1','147','768',326,'Retail Sale Id 1276479',1798.40,0.00,0.00,0.00,134.88,'2021-12-04 14:28:09','',''),(2156674,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-04 14:28:09','',''),(2156695,'1','147','768',326,'Retail Sale Id 1276492',998.40,0.00,0.00,0.00,74.88,'2021-12-04 14:29:21','',''),(2156696,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 14:29:21','',''),(2156739,'1','147','768',326,'Retail Sale Id 1276517',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 14:32:35','',''),(2156740,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 14:32:35','',''),(2156741,'1','147','768',326,'Retail Sale Id 1276517',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 14:32:35','',''),(2156742,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:32:35','',''),(2156792,'1','147','768',326,'Retail Sale Id 1276537',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 14:35:00','',''),(2156793,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 14:35:00','',''),(2156794,'1','147','768',326,'Retail Sale Id 1276537',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 14:35:00','',''),(2156795,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:35:00','',''),(2156814,'1','147','768',326,'Retail Sale Id 1276548',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 14:36:06','',''),(2156815,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 14:36:06','',''),(2156834,'1','147','768',326,'Retail Sale Id 1276559',4998.40,0.00,0.00,0.00,374.88,'2021-12-04 14:37:01','',''),(2156835,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 14:37:01','',''),(2156842,'1','147','768',326,'Retail Sale Id 1276565',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 14:37:50','',''),(2156843,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 14:37:50','',''),(2156870,'1','147','768',326,'Retail Sale Id 1276577',998.40,0.00,0.00,0.00,74.88,'2021-12-04 14:39:15','',''),(2156871,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 14:39:15','',''),(2156878,'1','147','768',326,'Retail Sale Id 1276580',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 14:39:48','',''),(2156879,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 14:39:48','',''),(2156888,'1','147','768',326,'Retail Sale Id 1276585',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 14:40:17','',''),(2156889,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 14:40:17','',''),(2156936,'1','147','768',326,'Retail Sale Id 1276597',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 14:43:04','',''),(2156937,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 14:43:04','',''),(2157038,'1','147','768',326,'Retail Sale Id 1276627',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 14:46:42','',''),(2157039,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 14:46:42','',''),(2157058,'1','147','768',326,'Retail Sale Id 1276634',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 14:47:27','',''),(2157059,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 14:47:27','',''),(2157071,'1','147','768',326,'Retail Sale Id 1276636',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 14:48:09','',''),(2157072,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:48:09','',''),(2157122,'1','147','768',326,'Retail Sale Id 1276658',12000.00,0.00,0.00,0.00,900.00,'2021-12-04 14:50:51','',''),(2157123,'1','147','768',326,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-04 14:50:51','',''),(2157142,'1','147','768',326,'Retail Sale Id 1276672',2598.40,0.00,0.00,0.00,194.88,'2021-12-04 14:51:45','',''),(2157143,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-04 14:51:45','',''),(2157165,'1','147','768',326,'Retail Sale Id 1276679',998.40,0.00,0.00,0.00,74.88,'2021-12-04 14:53:25','',''),(2157166,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 14:53:25','',''),(2157281,'1','147','768',326,'Retail Sale Id 1276716',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 14:58:26','',''),(2157282,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 14:58:26','',''),(2157306,'1','147','768',326,'Retail Sale Id 1276728',4998.40,0.00,0.00,0.00,374.88,'2021-12-04 14:59:17','',''),(2157307,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 14:59:17','',''),(2157318,'1','147','768',326,'Retail Sale Id 1276735',998.40,0.00,0.00,0.00,74.88,'2021-12-04 14:59:51','',''),(2157319,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 14:59:51','',''),(2157365,'1','147','768',326,'Retail Sale Id 1276756',1401.60,0.00,0.00,0.00,105.12,'2021-12-04 15:02:49','',''),(2157366,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-04 15:02:49','',''),(2157388,'1','147','768',326,'Retail Sale Id 1276762',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 15:03:39','',''),(2157389,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 15:03:39','',''),(2157398,'1','147','768',326,'Retail Sale Id 1276766',3500.80,0.00,0.00,0.00,262.56,'2021-12-04 15:04:22','',''),(2157399,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 15:04:22','',''),(2157410,'1','147','768',326,'Retail Sale Id 1276773',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 15:05:06','',''),(2157411,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 15:05:06','',''),(2157418,'1','147','768',326,'Retail Sale Id 1276778',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 15:05:41','',''),(2157419,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 15:05:41','',''),(2157472,'1','147','768',326,'Retail Sale Id 1276811',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 15:09:36','',''),(2157473,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 15:09:36','',''),(2157500,'1','147','768',326,'Retail Sale Id 1276825',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 15:11:55','',''),(2157501,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 15:11:55','',''),(2157534,'1','147','768',326,'Retail Sale Id 1276841',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 15:13:14','',''),(2157535,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 15:13:14','',''),(2157536,'1','147','768',326,'Retail Sale Id 1276841',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 15:13:14','',''),(2157537,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:13:14','',''),(2157590,'1','147','768',326,'Retail Sale Id 1276862',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 15:15:38','',''),(2157591,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 15:15:38','',''),(2157616,'1','147','768',326,'Retail Sale Id 1276875',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 15:17:31','',''),(2157617,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 15:17:31','',''),(2157690,'1','147','768',326,'Retail Sale Id 1276906',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 15:20:24','',''),(2157691,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 15:20:24','',''),(2157760,'1','147','768',326,'Retail Sale Id 1276932',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 15:23:44','',''),(2157761,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 15:23:44','',''),(2157834,'1','147','768',326,'Retail Sale Id 1276963',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 15:26:36','',''),(2157835,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 15:26:36','',''),(2157869,'1','147','768',326,'Retail Sale Id 1276978',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 15:27:49','',''),(2157870,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 15:27:49','',''),(2157903,'1','147','768',326,'Retail Sale Id 1276993',998.40,0.00,0.00,0.00,74.88,'2021-12-04 15:29:06','',''),(2157904,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 15:29:06','',''),(2157969,'1','147','768',326,'Retail Sale Id 1277028',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 15:32:39','',''),(2157970,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 15:32:39','',''),(2158009,'1','147','768',326,'Retail Sale Id 1277044',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 15:34:08','',''),(2158010,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 15:34:08','',''),(2158088,'1','147','768',326,'Retail Sale Id 1277083',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 15:38:18','',''),(2158089,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 15:38:18','',''),(2158112,'1','147','768',326,'Retail Sale Id 1277096',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 15:39:46','',''),(2158113,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 15:39:46','',''),(2158150,'1','147','768',326,'Retail Sale Id 1277110',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 15:41:36','',''),(2158151,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 15:41:36','',''),(2158174,'1','147','768',326,'Retail Sale Id 1277127',1299.20,0.00,0.00,0.00,97.44,'2021-12-04 15:42:43','',''),(2158175,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 15:42:43','',''),(2158197,'1','147','768',326,'Retail Sale Id 1277137',998.40,0.00,0.00,0.00,74.88,'2021-12-04 15:43:46','',''),(2158198,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 15:43:46','',''),(2158291,'1','147','768',326,'Retail Sale Id 1277172',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 15:47:18','',''),(2158292,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:47:18','',''),(2158321,'1','147','768',326,'Retail Sale Id 1277187',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 15:49:03','',''),(2158322,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:49:03','',''),(2158340,'1','147','768',326,'Retail Sale Id 1277199',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 15:50:20','',''),(2158341,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 15:50:20','',''),(2158360,'1','147','768',326,'Retail Sale Id 1277210',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 15:51:22','',''),(2158361,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:51:22','',''),(2158382,'1','147','768',326,'Retail Sale Id 1277217',1299.20,0.00,0.00,0.00,97.44,'2021-12-04 15:52:27','',''),(2158383,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 15:52:27','',''),(2158404,'1','147','768',326,'Retail Sale Id 1277231',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 15:53:28','',''),(2158405,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 15:53:28','',''),(2158434,'1','147','768',326,'Retail Sale Id 1277245',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 15:55:03','',''),(2158435,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 15:55:03','',''),(2158456,'1','147','768',326,'Retail Sale Id 1277265',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 15:56:03','',''),(2158457,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 15:56:03','',''),(2158486,'1','147','768',326,'Retail Sale Id 1277283',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 15:57:21','',''),(2158487,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:57:21','',''),(2158518,'1','147','768',326,'Retail Sale Id 1277303',1299.20,0.00,0.00,0.00,97.44,'2021-12-04 15:59:01','',''),(2158519,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 15:59:01','',''),(2158549,'1','147','768',326,'Retail Sale Id 1277320',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 16:00:16','',''),(2158550,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 16:00:16','',''),(2158610,'1','147','768',326,'Retail Sale Id 1277346',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:02:47','',''),(2158611,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:02:47','',''),(2158624,'1','147','768',326,'Retail Sale Id 1277357',998.40,0.00,0.00,0.00,74.88,'2021-12-04 16:04:21','',''),(2158625,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 16:04:21','',''),(2158646,'1','147','768',326,'Retail Sale Id 1277369',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 16:05:37','',''),(2158647,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 16:05:37','',''),(2158672,'1','147','768',326,'Retail Sale Id 1277383',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 16:06:46','',''),(2158673,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:06:46','',''),(2158690,'1','147','768',326,'Retail Sale Id 1277392',998.40,0.00,0.00,0.00,74.88,'2021-12-04 16:07:43','',''),(2158691,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 16:07:43','',''),(2158718,'1','147','768',326,'Retail Sale Id 1277402',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 16:08:46','',''),(2158719,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 16:08:46','',''),(2158736,'1','147','768',326,'Retail Sale Id 1277414',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 16:09:44','',''),(2158737,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 16:09:44','',''),(2158761,'1','147','768',326,'Retail Sale Id 1277425',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:10:50','',''),(2158762,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:10:50','',''),(2158777,'1','147','768',326,'Retail Sale Id 1277438',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 16:11:44','',''),(2158778,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 16:11:44','',''),(2158807,'1','147','768',326,'Retail Sale Id 1277451',1299.20,0.00,0.00,0.00,97.44,'2021-12-04 16:12:56','',''),(2158808,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 16:12:56','',''),(2158831,'1','147','768',326,'Retail Sale Id 1277465',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 16:14:00','',''),(2158832,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 16:14:00','',''),(2158857,'1','147','768',326,'Retail Sale Id 1277481',6400.00,0.00,0.00,0.00,480.00,'2021-12-04 16:15:08','',''),(2158858,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 16:15:08','',''),(2158887,'1','147','768',326,'Retail Sale Id 1277497',697.60,0.00,0.00,0.00,52.32,'2021-12-04 16:16:22','',''),(2158888,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-04 16:16:22','',''),(2158919,'1','147','768',326,'Retail Sale Id 1277511',1798.40,0.00,0.00,0.00,134.88,'2021-12-04 16:17:49','',''),(2158920,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-04 16:17:49','',''),(2158941,'1','147','768',326,'Retail Sale Id 1277523',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 16:19:09','',''),(2158942,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:19:09','',''),(2158959,'1','147','768',326,'Retail Sale Id 1277533',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 16:20:16','',''),(2158960,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 16:20:16','',''),(2158989,'1','147','768',326,'Retail Sale Id 1277546',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 16:21:33','',''),(2158990,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 16:21:33','',''),(2159015,'1','147','768',326,'Retail Sale Id 1277560',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 16:22:32','',''),(2159016,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 16:22:32','',''),(2159039,'1','147','768',326,'Retail Sale Id 1277571',998.40,0.00,0.00,0.00,74.88,'2021-12-04 16:23:35','',''),(2159040,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 16:23:35','',''),(2159069,'1','147','768',326,'Retail Sale Id 1277592',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 16:24:54','',''),(2159070,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 16:24:54','',''),(2159097,'1','147','768',326,'Retail Sale Id 1277606',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:26:02','',''),(2159098,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:26:02','',''),(2159129,'1','147','768',326,'Retail Sale Id 1277624',499.20,0.00,0.00,0.00,37.44,'2021-12-04 16:27:18','',''),(2159130,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-04 16:27:18','',''),(2159161,'1','147','768',326,'Retail Sale Id 1277636',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 16:28:32','',''),(2159162,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 16:28:32','',''),(2159187,'1','147','768',326,'Retail Sale Id 1277654',998.40,0.00,0.00,0.00,74.88,'2021-12-04 16:29:50','',''),(2159188,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 16:29:50','',''),(2159267,'1','147','768',326,'Retail Sale Id 1277690',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:34:08','',''),(2159268,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:34:08','',''),(2159293,'1','147','768',326,'Retail Sale Id 1277701',4499.20,0.00,0.00,0.00,337.44,'2021-12-04 16:35:48','',''),(2159294,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-04 16:35:48','',''),(2159335,'1','147','768',326,'Retail Sale Id 1277726',4998.40,0.00,0.00,0.00,374.88,'2021-12-04 16:37:40','',''),(2159336,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 16:37:40','',''),(2159356,'1','147','768',326,'Retail Sale Id 1277737',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 16:38:35','',''),(2159357,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 16:38:35','',''),(2159417,'1','147','768',326,'Retail Sale Id 1277748',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 16:39:32','',''),(2159418,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 16:39:32','',''),(2159435,'1','147','768',326,'Retail Sale Id 1277756',1920.00,0.00,0.00,0.00,144.00,'2021-12-04 16:40:38','',''),(2159436,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:40:38','',''),(2159515,'1','147','768',326,'Retail Sale Id 1277836',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 16:44:50','',''),(2159516,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 16:44:50','',''),(2159533,'1','147','768',326,'Retail Sale Id 1277849',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 16:45:56','',''),(2159534,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 16:45:56','',''),(2159554,'1','147','768',326,'Retail Sale Id 1277857',6003.20,0.00,0.00,0.00,450.24,'2021-12-04 16:46:54','',''),(2159555,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-04 16:46:54','',''),(2159610,'1','147','768',326,'Retail Sale Id 1277880',5152.00,0.00,0.00,0.00,386.40,'2021-12-04 16:49:35','',''),(2159611,'1','147','768',326,'Retail sales',0.00,0.00,0.00,8.05,0.00,'2021-12-04 16:49:35','',''),(2159648,'1','147','768',326,'Retail Sale Id 1277898',1798.40,0.00,0.00,0.00,134.88,'2021-12-04 16:51:01','',''),(2159649,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-04 16:51:01','',''),(2159674,'1','147','768',326,'Retail Sale Id 1277910',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 16:52:14','',''),(2159675,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:52:14','',''),(2159692,'1','147','768',326,'Retail Sale Id 1277919',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:53:11','',''),(2159693,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:53:11','',''),(2159712,'1','147','768',326,'Retail Sale Id 1277927',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:54:21','',''),(2159713,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:54:21','',''),(2159732,'1','147','768',326,'Retail Sale Id 1277935',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 16:55:35','',''),(2159733,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:55:35','',''),(2159745,'1','147','768',326,'Retail Sale Id 1277945',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:56:44','',''),(2159746,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:56:44','',''),(2159761,'1','147','768',326,'Retail Sale Id 1277956',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:57:48','',''),(2159762,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:57:48','',''),(2159833,'1','147','768',326,'Retail Sale Id 1277984',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 17:01:14','',''),(2159834,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 17:01:14','',''),(2159853,'1','147','768',326,'Retail Sale Id 1277999',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 17:02:26','',''),(2159854,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 17:02:26','',''),(2159873,'1','147','768',326,'Retail Sale Id 1278008',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 17:03:33','',''),(2159874,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 17:03:33','',''),(2159881,'1','147','768',326,'Retail Sale Id 1278012',1952.00,0.00,0.00,0.00,146.40,'2021-12-04 17:04:29','',''),(2159882,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 17:04:29','',''),(2159899,'1','147','768',326,'Retail Sale Id 1278021',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 17:05:38','',''),(2159900,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 17:05:38','',''),(2159923,'1','147','768',326,'Retail Sale Id 1278033',10502.40,0.00,0.00,0.00,787.68,'2021-12-04 17:07:03','',''),(2159924,'1','147','768',326,'Retail sales',0.00,0.00,0.00,16.41,0.00,'2021-12-04 17:07:03','',''),(2160019,'1','147','768',326,'Retail Sale Id 1278081',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 17:13:32','',''),(2160020,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 17:13:32','',''),(2160039,'1','147','768',326,'Retail Sale Id 1278091',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 17:14:58','',''),(2160040,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 17:14:58','',''),(2160051,'1','147','768',326,'Retail Sale Id 1278097',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 17:15:46','',''),(2160052,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 17:15:46','',''),(2160113,'1','147','768',326,'Retail Sale Id 1278127',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 17:19:53','',''),(2160114,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 17:19:53','',''),(2160121,'1','147','768',326,'Retail Sale Id 1278131',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 17:20:30','',''),(2160122,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 17:20:30','',''),(2160137,'1','147','768',326,'Retail Sale Id 1278140',998.40,0.00,0.00,0.00,74.88,'2021-12-04 17:21:13','',''),(2160138,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 17:21:13','',''),(2160161,'1','147','768',326,'Retail Sale Id 1278148',697.60,0.00,0.00,0.00,52.32,'2021-12-04 17:21:49','',''),(2160162,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-04 17:21:49','',''),(2160227,'1','147','768',326,'Retail Sale Id 1278175',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 17:25:08','',''),(2160228,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 17:25:08','',''),(2160258,'1','147','768',326,'Retail Sale Id 1278182',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 17:25:55','',''),(2160259,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 17:25:55','',''),(2160268,'1','147','768',326,'Retail Sale Id 1278187',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 17:26:39','',''),(2160269,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 17:26:39','',''),(2160309,'1','147','768',326,'Retail Sale Id 1278203',652.80,0.00,0.00,0.00,48.96,'2021-12-04 17:29:44','',''),(2160310,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-04 17:29:44','',''),(2160319,'1','147','768',326,'Retail Sale Id 1278211',499.20,0.00,0.00,0.00,37.44,'2021-12-04 17:30:29','',''),(2160320,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-04 17:30:29','',''),(2160343,'1','147','768',326,'Retail Sale Id 1278221',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 17:32:33','',''),(2160344,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 17:32:33','',''),(2160397,'1','147','768',326,'Retail Sale Id 1278239',3897.60,0.00,0.00,0.00,292.32,'2021-12-04 17:37:06','',''),(2160398,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-04 17:37:06','',''),(2160403,'1','147','768',326,'Retail Sale Id 1278247',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 17:37:48','',''),(2160404,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 17:37:48','',''),(2160533,'1','147','768',326,'Retail Sale Id 1278283',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 17:42:47','',''),(2160534,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 17:42:47','',''),(2160567,'1','147','768',326,'Retail Sale Id 1278290',4499.20,0.00,0.00,0.00,337.44,'2021-12-04 17:43:53','',''),(2160568,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-04 17:43:53','',''),(2160851,'1','147','768',326,'Retail Sale Id 1278411',133382.40,0.00,0.00,0.00,10003.68,'2021-12-04 18:07:41','',''),(2160852,'1','147','768',326,'Retail sales',0.00,0.00,0.00,208.41,0.00,'2021-12-04 18:07:41','',''),(2161886,'1','147','768',326,'Retail Sale Id 1278596',1401.60,0.00,0.00,0.00,105.12,'2021-12-05 05:40:15','',''),(2161887,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-05 05:40:15','',''),(2161907,'1','147','768',326,'Retail Sale Id 1278599',499.20,0.00,0.00,0.00,37.44,'2021-12-05 05:47:47','',''),(2161908,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-05 05:47:47','',''),(2161913,'1','147','768',326,'Retail Sale Id 1278601',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 05:49:57','',''),(2161914,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 05:49:57','',''),(2161921,'1','147','768',326,'Retail Sale Id 1278603',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 05:51:20','',''),(2161922,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 05:51:20','',''),(2161953,'1','147','768',326,'Retail Sale Id 1278616',800.00,0.00,0.00,0.00,60.00,'2021-12-05 05:59:24','',''),(2161954,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-05 05:59:24','',''),(2161959,'1','147','768',326,'Retail Sale Id 1278620',998.40,0.00,0.00,0.00,74.88,'2021-12-05 06:00:08','',''),(2161960,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 06:00:08','',''),(2162032,'1','147','768',326,'Retail Sale Id 1278654',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 06:09:58','',''),(2162033,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 06:09:58','',''),(2162044,'1','147','768',326,'Retail Sale Id 1278659',2899.20,0.00,0.00,0.00,217.44,'2021-12-05 06:10:39','',''),(2162045,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.53,0.00,'2021-12-05 06:10:39','',''),(2162062,'1','147','768',326,'Retail Sale Id 1278667',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 06:12:48','',''),(2162063,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 06:12:48','',''),(2162082,'1','147','768',326,'Retail Sale Id 1278678',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 06:15:04','',''),(2162083,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 06:15:04','',''),(2162111,'1','147','768',326,'Retail Sale Id 1278692',6003.20,0.00,0.00,0.00,450.24,'2021-12-05 06:19:33','',''),(2162112,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-05 06:19:33','',''),(2162125,'1','147','768',326,'Retail Sale Id 1278699',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 06:20:24','',''),(2162126,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 06:20:24','',''),(2162160,'1','147','768',326,'Retail Sale Id 1278715',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 06:23:58','',''),(2162161,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 06:23:58','',''),(2162174,'1','147','768',326,'Retail Sale Id 1278723',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 06:25:28','',''),(2162175,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 06:25:28','',''),(2162217,'1','147','768',326,'Retail Sale Id 1278745',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 06:30:06','',''),(2162218,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 06:30:06','',''),(2162225,'1','147','768',326,'Retail Sale Id 1278749',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 06:30:51','',''),(2162226,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 06:30:51','',''),(2162237,'1','147','768',326,'Retail Sale Id 1278753',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 06:31:30','',''),(2162238,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 06:31:30','',''),(2162247,'1','147','768',326,'Retail Sale Id 1278758',4499.20,0.00,0.00,0.00,337.44,'2021-12-05 06:32:22','',''),(2162248,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-05 06:32:22','',''),(2162255,'1','147','768',326,'Retail Sale Id 1278762',998.40,0.00,0.00,0.00,74.88,'2021-12-05 06:33:43','',''),(2162256,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 06:33:43','',''),(2162262,'1','147','768',326,'Retail Sale Id 1278765',998.40,0.00,0.00,0.00,74.88,'2021-12-05 06:34:22','',''),(2162263,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 06:34:22','',''),(2162352,'1','147','768',326,'Retail Sale Id 1278808',1920.00,0.00,0.00,0.00,144.00,'2021-12-05 06:40:37','',''),(2162353,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 06:40:37','',''),(2162374,'1','147','768',326,'Retail Sale Id 1278819',998.40,0.00,0.00,0.00,74.88,'2021-12-05 06:42:08','',''),(2162375,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 06:42:08','',''),(2162394,'1','147','768',326,'Retail Sale Id 1278825',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 06:43:22','',''),(2162395,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 06:43:22','',''),(2162462,'1','147','768',326,'Retail Sale Id 1278844',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 06:45:31','',''),(2162463,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 06:45:31','',''),(2162470,'1','147','768',326,'Retail Sale Id 1278849',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 06:46:17','',''),(2162471,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 06:46:17','',''),(2162484,'1','147','768',326,'Retail Sale Id 1278855',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 06:47:04','',''),(2162485,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 06:47:04','',''),(2162506,'1','147','768',326,'Retail Sale Id 1278864',7040.00,0.00,0.00,0.00,528.00,'2021-12-05 06:49:09','',''),(2162507,'1','147','768',326,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-05 06:49:09','',''),(2162529,'1','147','768',326,'Retail Sale Id 1278877',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 06:50:05','',''),(2162530,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 06:50:05','',''),(2162555,'1','147','768',326,'Retail Sale Id 1278888',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 06:51:00','',''),(2162556,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 06:51:00','',''),(2162583,'1','147','768',326,'Retail Sale Id 1278901',499.20,0.00,0.00,0.00,37.44,'2021-12-05 06:52:37','',''),(2162584,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-05 06:52:37','',''),(2162593,'1','147','768',326,'Retail Sale Id 1278907',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 06:53:15','',''),(2162594,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 06:53:15','',''),(2162607,'1','147','768',326,'Retail Sale Id 1278916',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 06:54:05','',''),(2162608,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 06:54:05','',''),(2162655,'1','147','768',326,'Retail Sale Id 1278948',2899.20,0.00,0.00,0.00,217.44,'2021-12-05 06:56:53','',''),(2162656,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.53,0.00,'2021-12-05 06:56:53','',''),(2162696,'1','147','768',326,'Retail Sale Id 1278966',998.40,0.00,0.00,0.00,74.88,'2021-12-05 06:59:07','',''),(2162697,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 06:59:07','',''),(2162712,'1','147','768',326,'Retail Sale Id 1278976',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 07:00:21','',''),(2162713,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 07:00:21','',''),(2162760,'1','147','768',326,'Retail Sale Id 1279001',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 07:03:24','',''),(2162761,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:03:24','',''),(2162809,'1','147','768',326,'Retail Sale Id 1279022',998.40,0.00,0.00,0.00,74.88,'2021-12-05 07:05:25','',''),(2162810,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 07:05:25','',''),(2162816,'1','147','768',326,'Retail Sale Id 1279028',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 07:06:06','',''),(2162817,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 07:06:06','',''),(2162857,'1','147','768',326,'Retail Sale Id 1279045',998.40,0.00,0.00,0.00,74.88,'2021-12-05 07:08:19','',''),(2162858,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 07:08:19','',''),(2162881,'1','147','768',326,'Retail Sale Id 1279059',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 07:09:07','',''),(2162882,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 07:09:07','',''),(2162893,'1','147','768',326,'Retail Sale Id 1279068',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 07:10:09','',''),(2162894,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:10:09','',''),(2162915,'1','147','768',326,'Retail Sale Id 1279082',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 07:11:22','',''),(2162916,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:11:22','',''),(2162953,'1','147','768',326,'Retail Sale Id 1279101',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 07:13:19','',''),(2162954,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 07:13:19','',''),(2162991,'1','147','768',326,'Retail Sale Id 1279120',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 07:15:54','',''),(2162992,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 07:15:54','',''),(2163080,'1','147','768',326,'Retail Sale Id 1279167',998.40,0.00,0.00,0.00,74.88,'2021-12-05 07:20:57','',''),(2163081,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 07:20:57','',''),(2163092,'1','147','768',326,'Retail Sale Id 1279172',2803.20,0.00,0.00,0.00,210.24,'2021-12-05 07:21:57','',''),(2163093,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-05 07:21:57','',''),(2163104,'1','147','768',326,'Retail Sale Id 1279193',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 07:22:54','',''),(2163105,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:22:54','',''),(2163120,'1','147','768',326,'Retail Sale Id 1279212',3302.40,0.00,0.00,0.00,247.68,'2021-12-05 07:24:05','',''),(2163121,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.16,0.00,'2021-12-05 07:24:05','',''),(2163130,'1','147','768',326,'Retail Sale Id 1279219',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 07:24:45','',''),(2163131,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:24:45','',''),(2163148,'1','147','768',326,'Retail Sale Id 1279230',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 07:25:32','',''),(2163149,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:25:32','',''),(2163197,'1','147','768',326,'Retail Sale Id 1279263',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 07:27:34','',''),(2163198,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 07:27:34','',''),(2163209,'1','147','768',326,'Retail Sale Id 1279268',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 07:28:25','',''),(2163210,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 07:28:25','',''),(2163254,'1','147','768',326,'Retail Sale Id 1279296',2598.40,0.00,0.00,0.00,194.88,'2021-12-05 07:31:57','',''),(2163255,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 07:31:57','',''),(2163268,'1','147','768',326,'Retail Sale Id 1279306',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 07:33:23','',''),(2163269,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 07:33:23','',''),(2163288,'1','147','768',326,'Retail Sale Id 1279317',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 07:34:23','',''),(2163289,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:34:23','',''),(2163306,'1','147','768',326,'Retail Sale Id 1279329',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 07:35:08','',''),(2163307,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 07:35:08','',''),(2163324,'1','147','768',326,'Retail Sale Id 1279336',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 07:36:20','',''),(2163325,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 07:36:20','',''),(2163338,'1','147','768',326,'Retail Sale Id 1279344',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 07:37:07','',''),(2163339,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:37:07','',''),(2163352,'1','147','768',326,'Retail Sale Id 1279351',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 07:37:57','',''),(2163353,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 07:37:57','',''),(2163370,'1','147','768',326,'Retail Sale Id 1279375',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 07:39:14','',''),(2163371,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 07:39:14','',''),(2163372,'1','147','768',326,'Retail Sale Id 1279375',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 07:39:14','',''),(2163373,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 07:39:14','',''),(2163417,'1','147','768',326,'Retail Sale Id 1279393',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 07:40:10','',''),(2163418,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:40:10','',''),(2163447,'1','147','768',326,'Retail Sale Id 1279411',3398.40,0.00,0.00,0.00,254.88,'2021-12-05 07:42:45','',''),(2163448,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.31,0.00,'2021-12-05 07:42:45','',''),(2163457,'1','147','768',326,'Retail Sale Id 1279416',3500.80,0.00,0.00,0.00,262.56,'2021-12-05 07:43:26','',''),(2163458,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-05 07:43:26','',''),(2163481,'1','147','768',326,'Retail Sale Id 1279425',3398.40,0.00,0.00,0.00,254.88,'2021-12-05 07:44:34','',''),(2163482,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.31,0.00,'2021-12-05 07:44:34','',''),(2163510,'1','147','768',326,'Retail Sale Id 1279442',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 07:46:39','',''),(2163511,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 07:46:39','',''),(2163534,'1','147','768',326,'Retail Sale Id 1279457',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 07:47:45','',''),(2163535,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:47:45','',''),(2163548,'1','147','768',326,'Retail Sale Id 1279465',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 07:48:23','',''),(2163549,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 07:48:23','',''),(2163558,'1','147','768',326,'Retail Sale Id 1279467',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 07:49:08','',''),(2163559,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 07:49:08','',''),(2163608,'1','147','768',326,'Retail Sale Id 1279488',16998.40,0.00,0.00,0.00,1274.88,'2021-12-05 07:51:23','',''),(2163609,'1','147','768',326,'Retail sales',0.00,0.00,0.00,26.56,0.00,'2021-12-05 07:51:23','',''),(2163636,'1','147','768',326,'Retail Sale Id 1279497',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 07:52:18','',''),(2163637,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 07:52:18','',''),(2163653,'1','147','768',326,'Retail Sale Id 1279502',1900.80,0.00,0.00,0.00,142.56,'2021-12-05 07:53:18','',''),(2163654,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-05 07:53:18','',''),(2163661,'1','147','768',326,'Retail Sale Id 1279511',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 07:54:06','',''),(2163662,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 07:54:06','',''),(2163675,'1','147','768',326,'Retail Sale Id 1279523',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 07:54:48','',''),(2163676,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 07:54:48','',''),(2163689,'1','147','768',326,'Retail Sale Id 1279530',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 07:55:45','',''),(2163690,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 07:55:45','',''),(2163711,'1','147','768',326,'Retail Sale Id 1279535',3500.80,0.00,0.00,0.00,262.56,'2021-12-05 07:56:40','',''),(2163712,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-05 07:56:40','',''),(2163719,'1','147','768',326,'Retail Sale Id 1279540',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 07:57:35','',''),(2163720,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 07:57:35','',''),(2163734,'1','147','768',326,'Retail Sale Id 1279546',998.40,0.00,0.00,0.00,74.88,'2021-12-05 07:58:27','',''),(2163735,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 07:58:27','',''),(2163744,'1','147','768',326,'Retail Sale Id 1279556',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 07:59:12','',''),(2163745,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 07:59:12','',''),(2163764,'1','147','768',326,'Retail Sale Id 1279567',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 08:00:11','',''),(2163765,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 08:00:11','',''),(2163780,'1','147','768',326,'Retail Sale Id 1279576',5497.60,0.00,0.00,0.00,412.32,'2021-12-05 08:01:17','',''),(2163781,'1','147','768',326,'Retail sales',0.00,0.00,0.00,8.59,0.00,'2021-12-05 08:01:17','',''),(2163794,'1','147','768',326,'Retail Sale Id 1279583',4499.20,0.00,0.00,0.00,337.44,'2021-12-05 08:02:04','',''),(2163795,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-05 08:02:04','',''),(2163811,'1','147','768',326,'Retail Sale Id 1279591',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 08:02:55','',''),(2163812,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:02:55','',''),(2163832,'1','147','768',326,'Retail Sale Id 1279609',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 08:03:53','',''),(2163833,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 08:03:53','',''),(2163842,'1','147','768',326,'Retail Sale Id 1279615',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 08:04:38','',''),(2163843,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 08:04:38','',''),(2163866,'1','147','768',326,'Retail Sale Id 1279626',697.60,0.00,0.00,0.00,52.32,'2021-12-05 08:05:35','',''),(2163867,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-05 08:05:35','',''),(2163886,'1','147','768',326,'Retail Sale Id 1279638',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 08:06:33','',''),(2163887,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:06:33','',''),(2163902,'1','147','768',326,'Retail Sale Id 1279656',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 08:07:34','',''),(2163903,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 08:07:34','',''),(2163954,'1','147','768',326,'Retail Sale Id 1279679',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 08:09:39','',''),(2163955,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 08:09:39','',''),(2163984,'1','147','768',326,'Retail Sale Id 1279701',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 08:11:08','',''),(2163985,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:11:08','',''),(2164006,'1','147','768',326,'Retail Sale Id 1279715',800.00,0.00,0.00,0.00,60.00,'2021-12-05 08:12:13','',''),(2164007,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-05 08:12:13','',''),(2164016,'1','147','768',326,'Retail Sale Id 1279721',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 08:13:05','',''),(2164017,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 08:13:05','',''),(2164032,'1','147','768',326,'Retail Sale Id 1279733',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 08:13:58','',''),(2164033,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 08:13:58','',''),(2164042,'1','147','768',326,'Retail Sale Id 1279739',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 08:14:45','',''),(2164043,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 08:14:45','',''),(2164062,'1','147','768',326,'Retail Sale Id 1279749',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 08:15:38','',''),(2164063,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 08:15:38','',''),(2164126,'1','147','768',326,'Retail Sale Id 1279779',697.60,0.00,0.00,0.00,52.32,'2021-12-05 08:18:43','',''),(2164127,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-05 08:18:43','',''),(2164138,'1','147','768',326,'Retail Sale Id 1279785',6400.00,0.00,0.00,0.00,480.00,'2021-12-05 08:19:37','',''),(2164139,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 08:19:37','',''),(2164158,'1','147','768',326,'Retail Sale Id 1279795',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 08:20:29','',''),(2164159,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:20:29','',''),(2164170,'1','147','768',326,'Retail Sale Id 1279801',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 08:21:16','',''),(2164171,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 08:21:16','',''),(2164298,'1','147','768',326,'Retail Sale Id 1279859',998.40,0.00,0.00,0.00,74.88,'2021-12-05 08:25:57','',''),(2164299,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 08:25:57','',''),(2164312,'1','147','768',326,'Retail Sale Id 1279877',902.40,0.00,0.00,0.00,67.68,'2021-12-05 08:26:55','',''),(2164313,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-05 08:26:55','',''),(2164332,'1','147','768',326,'Retail Sale Id 1279889',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 08:27:48','',''),(2164333,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:27:48','',''),(2164356,'1','147','768',326,'Retail Sale Id 1279902',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 08:28:51','',''),(2164357,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:28:51','',''),(2164366,'1','147','768',326,'Retail Sale Id 1279908',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 08:29:29','',''),(2164367,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 08:29:29','',''),(2164396,'1','147','768',326,'Retail Sale Id 1279924',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 08:31:24','',''),(2164397,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:31:24','',''),(2164430,'1','147','768',326,'Retail Sale Id 1279937',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 08:32:36','',''),(2164431,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:32:36','',''),(2164451,'1','147','768',326,'Retail Sale Id 1279946',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 08:33:37','',''),(2164452,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 08:33:37','',''),(2164466,'1','147','768',326,'Retail Sale Id 1279955',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 08:34:29','',''),(2164467,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:34:29','',''),(2164492,'1','147','768',326,'Retail Sale Id 1279975',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 08:35:58','',''),(2164493,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 08:35:58','',''),(2164518,'1','147','768',326,'Retail Sale Id 1279987',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 08:37:06','',''),(2164519,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:37:06','',''),(2164608,'1','147','768',326,'Retail Sale Id 1280030',640.00,0.00,0.00,0.00,48.00,'2021-12-05 08:42:24','',''),(2164609,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-05 08:42:24','',''),(2164638,'1','147','768',326,'Retail Sale Id 1280038',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 08:44:01','',''),(2164639,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 08:44:01','',''),(2164653,'1','147','768',326,'Retail Sale Id 1280047',6400.00,0.00,0.00,0.00,480.00,'2021-12-05 08:44:51','',''),(2164654,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 08:44:51','',''),(2164687,'1','147','768',326,'Retail Sale Id 1280059',998.40,0.00,0.00,0.00,74.88,'2021-12-05 08:46:25','',''),(2164688,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 08:46:25','',''),(2164709,'1','147','768',326,'Retail Sale Id 1280067',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 08:47:35','',''),(2164710,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 08:47:35','',''),(2164735,'1','147','768',326,'Retail Sale Id 1280078',7500.80,0.00,0.00,0.00,562.56,'2021-12-05 08:48:54','',''),(2164736,'1','147','768',326,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-05 08:48:54','',''),(2164759,'1','147','768',326,'Retail Sale Id 1280093',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 08:50:25','',''),(2164760,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:50:25','',''),(2164779,'1','147','768',326,'Retail Sale Id 1280102',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 08:51:28','',''),(2164780,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:51:28','',''),(2164791,'1','147','768',326,'Retail Sale Id 1280112',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 08:52:15','',''),(2164792,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:52:15','',''),(2164801,'1','147','768',326,'Retail Sale Id 1280118',998.40,0.00,0.00,0.00,74.88,'2021-12-05 08:52:55','',''),(2164802,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 08:52:55','',''),(2164817,'1','147','768',326,'Retail Sale Id 1280126',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 08:53:34','',''),(2164818,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 08:53:34','',''),(2164831,'1','147','768',326,'Retail Sale Id 1280136',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 08:54:18','',''),(2164832,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 08:54:18','',''),(2164843,'1','147','768',326,'Retail Sale Id 1280141',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 08:54:53','',''),(2164844,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 08:54:53','',''),(2164861,'1','147','768',326,'Retail Sale Id 1280149',2803.20,0.00,0.00,0.00,210.24,'2021-12-05 08:55:44','',''),(2164862,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-05 08:55:44','',''),(2164870,'1','147','768',326,'Retail Sale Id 1280164',1401.60,0.00,0.00,0.00,105.12,'2021-12-05 08:56:45','',''),(2164871,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-05 08:56:45','',''),(2164892,'1','147','768',326,'Retail Sale Id 1280174',499.20,0.00,0.00,0.00,37.44,'2021-12-05 08:58:06','',''),(2164893,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-05 08:58:06','',''),(2164894,'1','147','768',326,'Retail Sale Id 1280174',998.40,0.00,0.00,0.00,74.88,'2021-12-05 08:58:06','',''),(2164895,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 08:58:06','',''),(2164933,'1','147','768',326,'Retail Sale Id 1280191',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 09:00:17','',''),(2164934,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 09:00:17','',''),(2164997,'1','147','768',326,'Retail Sale Id 1280224',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 09:03:47','',''),(2164998,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 09:03:47','',''),(2165009,'1','147','768',326,'Retail Sale Id 1280230',2502.40,0.00,0.00,0.00,187.68,'2021-12-05 09:04:28','',''),(2165010,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 09:04:28','',''),(2165025,'1','147','768',326,'Retail Sale Id 1280237',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 09:05:14','',''),(2165026,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 09:05:14','',''),(2165041,'1','147','768',326,'Retail Sale Id 1280248',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 09:06:13','',''),(2165042,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:06:13','',''),(2165063,'1','147','768',326,'Retail Sale Id 1280263',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 09:07:16','',''),(2165064,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 09:07:16','',''),(2165081,'1','147','768',326,'Retail Sale Id 1280269',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 09:07:56','',''),(2165082,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 09:07:56','',''),(2165099,'1','147','768',326,'Retail Sale Id 1280283',640.00,0.00,0.00,0.00,48.00,'2021-12-05 09:08:56','',''),(2165100,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-05 09:08:56','',''),(2165119,'1','147','768',326,'Retail Sale Id 1280296',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 09:09:45','',''),(2165120,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 09:09:45','',''),(2165142,'1','147','768',326,'Retail Sale Id 1280306',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 09:10:36','',''),(2165143,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:10:36','',''),(2165158,'1','147','768',326,'Retail Sale Id 1280313',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 09:11:20','',''),(2165159,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 09:11:20','',''),(2165201,'1','147','768',326,'Retail Sale Id 1280334',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 09:13:30','',''),(2165202,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:13:30','',''),(2165223,'1','147','768',326,'Retail Sale Id 1280346',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 09:14:43','',''),(2165224,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 09:14:43','',''),(2165252,'1','147','768',326,'Retail Sale Id 1280380',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 09:17:20','',''),(2165253,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 09:17:20','',''),(2165270,'1','147','768',326,'Retail Sale Id 1280401',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 09:18:26','',''),(2165271,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 09:18:26','',''),(2165282,'1','147','768',326,'Retail Sale Id 1280408',2598.40,0.00,0.00,0.00,194.88,'2021-12-05 09:18:58','',''),(2165283,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 09:18:58','',''),(2165294,'1','147','768',326,'Retail Sale Id 1280412',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 09:19:58','',''),(2165295,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 09:19:58','',''),(2165316,'1','147','768',326,'Retail Sale Id 1280424',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 09:21:06','',''),(2165317,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 09:21:06','',''),(2165326,'1','147','768',326,'Retail Sale Id 1280431',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 09:21:41','',''),(2165327,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 09:21:41','',''),(2165416,'1','147','768',326,'Retail Sale Id 1280481',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 09:26:44','',''),(2165417,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 09:26:44','',''),(2165444,'1','147','768',326,'Retail Sale Id 1280496',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 09:28:14','',''),(2165445,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:28:14','',''),(2165480,'1','147','768',326,'Retail Sale Id 1280517',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 09:29:53','',''),(2165481,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 09:29:53','',''),(2165554,'1','147','768',326,'Retail Sale Id 1280562',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 09:33:39','',''),(2165555,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 09:33:39','',''),(2165580,'1','147','768',326,'Retail Sale Id 1280574',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 09:35:02','',''),(2165581,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 09:35:02','',''),(2165598,'1','147','768',326,'Retail Sale Id 1280584',4499.20,0.00,0.00,0.00,337.44,'2021-12-05 09:36:21','',''),(2165599,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-05 09:36:21','',''),(2165632,'1','147','768',326,'Retail Sale Id 1280600',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 09:37:52','',''),(2165633,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 09:37:52','',''),(2165684,'1','147','768',326,'Retail Sale Id 1280625',998.40,0.00,0.00,0.00,74.88,'2021-12-05 09:40:26','',''),(2165685,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 09:40:26','',''),(2165750,'1','147','768',326,'Retail Sale Id 1280656',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 09:43:27','',''),(2165751,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:43:27','',''),(2165809,'1','147','768',326,'Retail Sale Id 1280677',499.20,0.00,0.00,0.00,37.44,'2021-12-05 09:45:20','',''),(2165810,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-05 09:45:20','',''),(2165854,'1','147','768',326,'Retail Sale Id 1280691',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 09:46:34','',''),(2165855,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 09:46:34','',''),(2165890,'1','147','768',326,'Retail Sale Id 1280705',998.40,0.00,0.00,0.00,74.88,'2021-12-05 09:47:26','',''),(2165891,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 09:47:26','',''),(2165919,'1','147','768',326,'Retail Sale Id 1280713',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 09:48:43','',''),(2165920,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 09:48:43','',''),(2165955,'1','147','768',326,'Retail Sale Id 1280733',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 09:51:07','',''),(2165956,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 09:51:07','',''),(2165983,'1','147','768',326,'Retail Sale Id 1280748',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 09:52:52','',''),(2165984,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:52:52','',''),(2166011,'1','147','768',326,'Retail Sale Id 1280761',7897.60,0.00,0.00,0.00,592.32,'2021-12-05 09:54:11','',''),(2166012,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.34,0.00,'2021-12-05 09:54:11','',''),(2166033,'1','147','768',326,'Retail Sale Id 1280771',998.40,0.00,0.00,0.00,74.88,'2021-12-05 09:55:27','',''),(2166034,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 09:55:27','',''),(2166067,'1','147','768',326,'Retail Sale Id 1280790',800.00,0.00,0.00,0.00,60.00,'2021-12-05 09:57:40','',''),(2166068,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-05 09:57:40','',''),(2166095,'1','147','768',326,'Retail Sale Id 1280807',998.40,0.00,0.00,0.00,74.88,'2021-12-05 09:59:12','',''),(2166096,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 09:59:12','',''),(2166203,'1','147','768',326,'Retail Sale Id 1280859',10598.40,0.00,0.00,0.00,794.88,'2021-12-05 10:05:43','',''),(2166204,'1','147','768',326,'Retail sales',0.00,0.00,0.00,16.56,0.00,'2021-12-05 10:05:43','',''),(2166229,'1','147','768',326,'Retail Sale Id 1280871',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 10:08:01','',''),(2166230,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:08:01','',''),(2166249,'1','147','768',326,'Retail Sale Id 1280888',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 10:09:31','',''),(2166250,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 10:09:31','',''),(2166261,'1','147','768',326,'Retail Sale Id 1280892',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 10:10:28','',''),(2166262,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 10:10:28','',''),(2166281,'1','147','768',326,'Retail Sale Id 1280902',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 10:11:22','',''),(2166282,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:11:22','',''),(2166295,'1','147','768',326,'Retail Sale Id 1280908',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 10:12:43','',''),(2166296,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:12:43','',''),(2166307,'1','147','768',326,'Retail Sale Id 1280916',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 10:13:42','',''),(2166308,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 10:13:42','',''),(2166327,'1','147','768',326,'Retail Sale Id 1280924',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 10:14:40','',''),(2166328,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 10:14:40','',''),(2166341,'1','147','768',326,'Retail Sale Id 1280933',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 10:15:47','',''),(2166342,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 10:15:47','',''),(2166363,'1','147','768',326,'Retail Sale Id 1280946',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 10:17:01','',''),(2166364,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:17:01','',''),(2166377,'1','147','768',326,'Retail Sale Id 1280953',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 10:18:01','',''),(2166378,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 10:18:01','',''),(2166389,'1','147','768',326,'Retail Sale Id 1280958',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 10:18:59','',''),(2166390,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:18:59','',''),(2166409,'1','147','768',326,'Retail Sale Id 1280969',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 10:20:14','',''),(2166410,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 10:20:14','',''),(2166435,'1','147','768',326,'Retail Sale Id 1280983',2502.40,0.00,0.00,0.00,187.68,'2021-12-05 10:21:25','',''),(2166436,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 10:21:25','',''),(2166461,'1','147','768',326,'Retail Sale Id 1280995',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 10:22:54','',''),(2166462,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 10:22:54','',''),(2166481,'1','147','768',326,'Retail Sale Id 1281005',4697.60,0.00,0.00,0.00,352.32,'2021-12-05 10:24:43','',''),(2166482,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.34,0.00,'2021-12-05 10:24:43','',''),(2166502,'1','147','768',326,'Retail Sale Id 1281013',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 10:26:02','',''),(2166503,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 10:26:02','',''),(2166522,'1','147','768',326,'Retail Sale Id 1281024',998.40,0.00,0.00,0.00,74.88,'2021-12-05 10:27:16','',''),(2166523,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 10:27:16','',''),(2166536,'1','147','768',326,'Retail Sale Id 1281031',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 10:28:14','',''),(2166538,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:28:14','',''),(2166554,'1','147','768',326,'Retail Sale Id 1281041',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 10:29:10','',''),(2166555,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:29:10','',''),(2166576,'1','147','768',326,'Retail Sale Id 1281053',2297.60,0.00,0.00,0.00,172.32,'2021-12-05 10:30:24','',''),(2166577,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.59,0.00,'2021-12-05 10:30:24','',''),(2166594,'1','147','768',326,'Retail Sale Id 1281061',998.40,0.00,0.00,0.00,74.88,'2021-12-05 10:31:23','',''),(2166595,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 10:31:23','',''),(2166606,'1','147','768',326,'Retail Sale Id 1281070',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 10:32:16','',''),(2166607,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:32:16','',''),(2166620,'1','147','768',326,'Retail Sale Id 1281077',601.60,0.00,0.00,0.00,45.12,'2021-12-05 10:33:32','',''),(2166621,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.94,0.00,'2021-12-05 10:33:32','',''),(2166632,'1','147','768',326,'Retail Sale Id 1281084',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 10:34:43','',''),(2166633,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 10:34:43','',''),(2166662,'1','147','768',326,'Retail Sale Id 1281096',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 10:35:42','',''),(2166663,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:35:42','',''),(2166694,'1','147','768',326,'Retail Sale Id 1281115',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 10:37:33','',''),(2166695,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 10:37:33','',''),(2166708,'1','147','768',326,'Retail Sale Id 1281122',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 10:38:32','',''),(2166709,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 10:38:32','',''),(2166728,'1','147','768',326,'Retail Sale Id 1281132',499.20,0.00,0.00,0.00,37.44,'2021-12-05 10:39:44','',''),(2166729,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-05 10:39:44','',''),(2166740,'1','147','768',326,'Retail Sale Id 1281141',6003.20,0.00,0.00,0.00,450.24,'2021-12-05 10:40:44','',''),(2166741,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-05 10:40:44','',''),(2166758,'1','147','768',326,'Retail Sale Id 1281147',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 10:41:37','',''),(2166759,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 10:41:37','',''),(2166768,'1','147','768',326,'Retail Sale Id 1281152',3500.80,0.00,0.00,0.00,262.56,'2021-12-05 10:42:32','',''),(2166769,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-05 10:42:32','',''),(2166784,'1','147','768',326,'Retail Sale Id 1281161',3500.80,0.00,0.00,0.00,262.56,'2021-12-05 10:43:46','',''),(2166785,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-05 10:43:46','',''),(2166815,'1','147','768',326,'Retail Sale Id 1281178',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 10:44:45','',''),(2166816,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:44:45','',''),(2166839,'1','147','768',326,'Retail Sale Id 1281190',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 10:46:02','',''),(2166840,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 10:46:02','',''),(2166857,'1','147','768',326,'Retail Sale Id 1281200',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 10:46:57','',''),(2166858,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 10:46:57','',''),(2166881,'1','147','768',326,'Retail Sale Id 1281213',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 10:48:07','',''),(2166882,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:48:07','',''),(2166913,'1','147','768',326,'Retail Sale Id 1281230',6400.00,0.00,0.00,0.00,480.00,'2021-12-05 10:49:22','',''),(2166914,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 10:49:22','',''),(2166947,'1','147','768',326,'Retail Sale Id 1281249',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 10:50:57','',''),(2166948,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:50:57','',''),(2166967,'1','147','768',326,'Retail Sale Id 1281259',1900.80,0.00,0.00,0.00,142.56,'2021-12-05 10:52:28','',''),(2166968,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-05 10:52:28','',''),(2166983,'1','147','768',326,'Retail Sale Id 1281266',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 10:53:31','',''),(2166984,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 10:53:31','',''),(2166995,'1','147','768',326,'Retail Sale Id 1281274',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 10:54:32','',''),(2166996,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 10:54:32','',''),(2167029,'1','147','768',326,'Retail Sale Id 1281292',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 10:56:39','',''),(2167030,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 10:56:39','',''),(2167053,'1','147','768',326,'Retail Sale Id 1281304',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 10:57:55','',''),(2167054,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 10:57:55','',''),(2167202,'1','147','768',326,'Retail Sale Id 1281375',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 11:07:01','',''),(2167203,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 11:07:01','',''),(2167232,'1','147','768',326,'Retail Sale Id 1281401',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 11:08:20','',''),(2167233,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:08:20','',''),(2167242,'1','147','768',326,'Retail Sale Id 1281412',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 11:08:59','',''),(2167243,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 11:08:59','',''),(2167264,'1','147','768',326,'Retail Sale Id 1281423',2598.40,0.00,0.00,0.00,194.88,'2021-12-05 11:09:59','',''),(2167265,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 11:09:59','',''),(2167558,'1','147',NULL,326,'Purchased from AA RANO NIGERIA LIMITED',0.00,15984.00,27.00,0.00,0.00,'2021-12-05 11:27:41','',''),(2167573,'1','147',NULL,326,'Reception corrector for bridging 126300',0.00,0.00,0.00,27.00,0.00,'2021-12-05 11:28:45','',''),(2167574,'1','147','768',326,'Received from bridging 126300',0.00,0.00,27.00,0.00,0.00,'2021-12-05 11:28:45','',''),(2167603,'1','147','768',326,'Retail Sale Id 1281585',16787.20,0.00,0.00,0.00,1259.04,'2021-12-05 11:29:37','',''),(2167604,'1','147','768',326,'Retail sales',0.00,0.00,0.00,26.23,0.00,'2021-12-05 11:29:37','',''),(2167878,'1','147',NULL,326,'Purchased from AA RANO NIGERIA LIMITED',0.00,1776000.00,3000.00,0.00,0.00,'2021-12-05 11:46:18','',''),(2167895,'1','147',NULL,326,'Reception corrector for bridging 126302',0.00,0.00,0.00,3000.00,0.00,'2021-12-05 11:47:03','',''),(2167896,'1','147','768',326,'Received from bridging 126302',0.00,0.00,3000.00,0.00,0.00,'2021-12-05 11:47:03','',''),(2167935,'1','147','768',326,'Retail Sale Id 1281792',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 11:49:24','',''),(2167936,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 11:49:24','',''),(2167965,'1','147','768',326,'Retail Sale Id 1281816',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 11:51:12','',''),(2167966,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 11:51:12','',''),(2167986,'1','147','768',326,'Retail Sale Id 1281831',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 11:52:15','',''),(2167987,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 11:52:15','',''),(2168001,'1','147','768',326,'Retail Sale Id 1281836',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 11:52:57','',''),(2168002,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:52:57','',''),(2168028,'1','147','768',326,'Retail Sale Id 1281851',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 11:54:37','',''),(2168029,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 11:54:37','',''),(2168048,'1','147','768',326,'Retail Sale Id 1281860',998.40,0.00,0.00,0.00,74.88,'2021-12-05 11:56:02','',''),(2168049,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 11:56:02','',''),(2168071,'1','147','768',326,'Retail Sale Id 1281873',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 11:56:54','',''),(2168072,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:56:54','',''),(2168090,'1','147','768',326,'Retail Sale Id 1281882',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 11:57:54','',''),(2168091,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:57:54','',''),(2168100,'1','147','768',326,'Retail Sale Id 1281887',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 11:58:46','',''),(2168101,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 11:58:46','',''),(2168120,'1','147','768',326,'Retail Sale Id 1281896',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 11:59:37','',''),(2168121,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 11:59:37','',''),(2168128,'1','147','768',326,'Retail Sale Id 1281899',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:00:18','',''),(2168129,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:00:18','',''),(2168140,'1','147','768',326,'Retail Sale Id 1281908',800.00,0.00,0.00,0.00,60.00,'2021-12-05 12:01:01','',''),(2168141,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-05 12:01:01','',''),(2168156,'1','147','768',326,'Retail Sale Id 1281917',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 12:01:53','',''),(2168157,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 12:01:53','',''),(2168184,'1','147','768',326,'Retail Sale Id 1281926',998.40,0.00,0.00,0.00,74.88,'2021-12-05 12:03:53','',''),(2168185,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 12:03:53','',''),(2168194,'1','147','768',326,'Retail Sale Id 1281935',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 12:04:33','',''),(2168195,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:04:33','',''),(2168252,'1','147','768',326,'Retail Sale Id 1281968',499.20,0.00,0.00,0.00,37.44,'2021-12-05 12:07:12','',''),(2168253,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-05 12:07:12','',''),(2168273,'1','147','768',326,'Retail Sale Id 1281978',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 12:08:15','',''),(2168275,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 12:08:15','',''),(2168289,'1','147','768',326,'Retail Sale Id 1281989',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 12:08:55','',''),(2168290,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 12:08:55','',''),(2168305,'1','147','768',326,'Retail Sale Id 1281995',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 12:09:46','',''),(2168306,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 12:09:46','',''),(2168318,'1','147','768',326,'Retail Sale Id 1282001',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:10:39','',''),(2168319,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:10:39','',''),(2168334,'1','147','768',326,'Retail Sale Id 1282010',2598.40,0.00,0.00,0.00,194.88,'2021-12-05 12:11:23','',''),(2168335,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 12:11:23','',''),(2168350,'1','147','768',326,'Retail Sale Id 1282018',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 12:12:11','',''),(2168351,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:12:11','',''),(2168366,'1','147','768',326,'Retail Sale Id 1282026',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 12:13:26','',''),(2168367,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 12:13:26','',''),(2168442,'1','147','768',326,'Retail Sale Id 1282057',3801.60,0.00,0.00,0.00,285.12,'2021-12-05 12:15:37','',''),(2168443,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-05 12:15:37','',''),(2168466,'1','147','768',326,'Retail Sale Id 1282069',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 12:16:46','',''),(2168467,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 12:16:46','',''),(2168496,'1','147','768',326,'Retail Sale Id 1282079',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 12:18:01','',''),(2168497,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 12:18:01','',''),(2168520,'1','147','768',326,'Retail Sale Id 1282097',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 12:19:03','',''),(2168521,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 12:19:03','',''),(2168546,'1','147','768',326,'Retail Sale Id 1282111',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 12:19:59','',''),(2168547,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 12:19:59','',''),(2168573,'1','147','768',326,'Retail Sale Id 1282120',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 12:21:09','',''),(2168574,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 12:21:09','',''),(2168603,'1','147','768',326,'Retail Sale Id 1282137',640.00,0.00,0.00,0.00,48.00,'2021-12-05 12:22:16','',''),(2168604,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-05 12:22:16','',''),(2168627,'1','147','768',326,'Retail Sale Id 1282149',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 12:23:34','',''),(2168628,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 12:23:34','',''),(2168660,'1','147','768',326,'Retail Sale Id 1282163',998.40,0.00,0.00,0.00,74.88,'2021-12-05 12:24:32','',''),(2168661,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 12:24:32','',''),(2168680,'1','147','768',326,'Retail Sale Id 1282172',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 12:25:33','',''),(2168681,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 12:25:33','',''),(2168714,'1','147','768',326,'Retail Sale Id 1282193',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 12:26:35','',''),(2168715,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 12:26:35','',''),(2168740,'1','147','768',326,'Retail Sale Id 1282205',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 12:27:40','',''),(2168741,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:27:40','',''),(2168774,'1','147','768',326,'Retail Sale Id 1282221',1702.40,0.00,0.00,0.00,127.68,'2021-12-05 12:29:17','',''),(2168775,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-05 12:29:17','',''),(2168796,'1','147','768',326,'Retail Sale Id 1282236',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 12:30:24','',''),(2168797,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 12:30:24','',''),(2168820,'1','147','768',326,'Retail Sale Id 1282250',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 12:31:34','',''),(2168821,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 12:31:34','',''),(2168840,'1','147','768',326,'Retail Sale Id 1282260',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 12:32:37','',''),(2168841,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 12:32:37','',''),(2168951,'1','147','768',326,'Retail Sale Id 1282315',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:38:51','',''),(2168952,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:38:51','',''),(2168973,'1','147','768',326,'Retail Sale Id 1282328',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:39:51','',''),(2168974,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:39:51','',''),(2168995,'1','147','768',326,'Retail Sale Id 1282341',2598.40,0.00,0.00,0.00,194.88,'2021-12-05 12:40:57','',''),(2168996,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 12:40:57','',''),(2169009,'1','147','768',326,'Retail Sale Id 1282349',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 12:41:58','',''),(2169010,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:41:58','',''),(2169027,'1','147','768',326,'Retail Sale Id 1282357',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 12:42:55','',''),(2169028,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 12:42:55','',''),(2169053,'1','147','768',326,'Retail Sale Id 1282370',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 12:43:52','',''),(2169054,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 12:43:52','',''),(2169073,'1','147','768',326,'Retail Sale Id 1282382',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 12:45:06','',''),(2169074,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 12:45:06','',''),(2169085,'1','147','768',326,'Retail Sale Id 1282392',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:46:00','',''),(2169086,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:46:00','',''),(2169107,'1','147','768',326,'Retail Sale Id 1282404',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:47:18','',''),(2169108,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:47:18','',''),(2169151,'1','147','768',326,'Retail Sale Id 1282434',7302.40,0.00,0.00,0.00,547.68,'2021-12-05 12:50:37','',''),(2169152,'1','147','768',326,'Retail sales',0.00,0.00,0.00,11.41,0.00,'2021-12-05 12:50:37','',''),(2169177,'1','147','768',326,'Retail Sale Id 1282450',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 12:52:29','',''),(2169178,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 12:52:29','',''),(2169191,'1','147','768',326,'Retail Sale Id 1282462',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 12:53:30','',''),(2169192,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 12:53:30','',''),(2169213,'1','147','768',326,'Retail Sale Id 1282471',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 12:54:26','',''),(2169214,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:54:26','',''),(2169235,'1','147','768',326,'Retail Sale Id 1282485',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 12:55:24','',''),(2169236,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 12:55:24','',''),(2169253,'1','147','768',326,'Retail Sale Id 1282493',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 12:56:18','',''),(2169254,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 12:56:18','',''),(2169279,'1','147','768',326,'Retail Sale Id 1282504',3097.60,0.00,0.00,0.00,232.32,'2021-12-05 12:57:23','',''),(2169280,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.84,0.00,'2021-12-05 12:57:23','',''),(2169293,'1','147','768',326,'Retail Sale Id 1282511',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 12:58:25','',''),(2169294,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 12:58:25','',''),(2169311,'1','147','768',326,'Retail Sale Id 1282520',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 12:59:37','',''),(2169312,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 12:59:37','',''),(2169337,'1','147','768',326,'Retail Sale Id 1282526',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 13:00:27','',''),(2169338,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 13:00:27','',''),(2169359,'1','147','768',326,'Retail Sale Id 1282540',2598.40,0.00,0.00,0.00,194.88,'2021-12-05 13:01:23','',''),(2169360,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 13:01:23','',''),(2169397,'1','147','768',326,'Retail Sale Id 1282560',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 13:03:05','',''),(2169398,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 13:03:05','',''),(2169443,'1','147','768',326,'Retail Sale Id 1282579',3500.80,0.00,0.00,0.00,262.56,'2021-12-05 13:05:34','',''),(2169444,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-05 13:05:34','',''),(2169469,'1','147','768',326,'Retail Sale Id 1282623',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 13:07:19','',''),(2169470,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 13:07:19','',''),(2169484,'1','147','768',326,'Retail Sale Id 1282630',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 13:08:11','',''),(2169485,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 13:08:11','',''),(2169506,'1','147','768',326,'Retail Sale Id 1282638',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 13:09:14','',''),(2169507,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 13:09:14','',''),(2169526,'1','147','768',326,'Retail Sale Id 1282647',998.40,0.00,0.00,0.00,74.88,'2021-12-05 13:10:14','',''),(2169527,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 13:10:14','',''),(2169540,'1','147','768',326,'Retail Sale Id 1282655',998.40,0.00,0.00,0.00,74.88,'2021-12-05 13:11:08','',''),(2169541,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 13:11:08','',''),(2169562,'1','147','768',326,'Retail Sale Id 1282666',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 13:12:23','',''),(2169563,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 13:12:23','',''),(2169580,'1','147','768',326,'Retail Sale Id 1282674',998.40,0.00,0.00,0.00,74.88,'2021-12-05 13:13:39','',''),(2169581,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 13:13:39','',''),(2169600,'1','147','768',326,'Retail Sale Id 1282686',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 13:14:54','',''),(2169601,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 13:14:54','',''),(2169614,'1','147','768',326,'Retail Sale Id 1282694',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 13:16:25','',''),(2169615,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 13:16:25','',''),(2169664,'1','147','768',326,'Retail Sale Id 1282705',6400.00,0.00,0.00,0.00,480.00,'2021-12-05 13:18:18','',''),(2169665,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 13:18:18','',''),(2169736,'1','147','768',326,'Retail Sale Id 1282753',6003.20,0.00,0.00,0.00,450.24,'2021-12-05 13:23:28','',''),(2169737,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-05 13:23:28','',''),(2169786,'1','147','768',326,'Retail Sale Id 1282783',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 13:26:32','',''),(2169787,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 13:26:32','',''),(2169808,'1','147','768',326,'Retail Sale Id 1282794',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 13:27:37','',''),(2169809,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 13:27:37','',''),(2169895,'1','147','768',326,'Retail Sale Id 1282827',3500.80,0.00,0.00,0.00,262.56,'2021-12-05 13:31:55','',''),(2169896,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-05 13:31:55','',''),(2169973,'1','147','768',326,'Retail Sale Id 1282861',998.40,0.00,0.00,0.00,74.88,'2021-12-05 13:35:33','',''),(2169974,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 13:35:33','',''),(2169993,'1','147','768',326,'Retail Sale Id 1282873',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 13:36:32','',''),(2169994,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 13:36:32','',''),(2170017,'1','147','768',326,'Retail Sale Id 1282884',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 13:37:44','',''),(2170018,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 13:37:44','',''),(2170067,'1','147','768',326,'Retail Sale Id 1282901',32000.00,0.00,0.00,0.00,2400.00,'2021-12-05 13:40:23','',''),(2170068,'1','147','768',326,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 13:40:23','',''),(2170079,'1','147','768',326,'Retail Sale Id 1282905',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 13:41:08','',''),(2170080,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 13:41:08','',''),(2170151,'1','147','768',326,'Retail Sale Id 1282917',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 13:43:15','',''),(2170152,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 13:43:15','',''),(2170163,'1','147','768',326,'Retail Sale Id 1282926',2502.40,0.00,0.00,0.00,187.68,'2021-12-05 13:44:10','',''),(2170164,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 13:44:10','',''),(2170190,'1','147','768',326,'Retail Sale Id 1282934',998.40,0.00,0.00,0.00,74.88,'2021-12-05 13:45:33','',''),(2170191,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 13:45:33','',''),(2170196,'1','147','768',326,'Retail Sale Id 1282941',998.40,0.00,0.00,0.00,74.88,'2021-12-05 13:46:24','',''),(2170197,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 13:46:24','',''),(2170221,'1','147','768',326,'Retail Sale Id 1282953',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 13:47:30','',''),(2170222,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 13:47:30','',''),(2170233,'1','147','768',326,'Retail Sale Id 1282958',7001.60,0.00,0.00,0.00,525.12,'2021-12-05 13:48:27','',''),(2170234,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-05 13:48:27','',''),(2170255,'1','147','768',326,'Retail Sale Id 1282967',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 13:49:51','',''),(2170256,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 13:49:51','',''),(2170294,'1','147','768',326,'Retail Sale Id 1282984',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 13:51:39','',''),(2170295,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 13:51:39','',''),(2170352,'1','147','768',326,'Retail Sale Id 1283005',998.40,0.00,0.00,0.00,74.88,'2021-12-05 13:54:31','',''),(2170353,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 13:54:31','',''),(2170368,'1','147','768',326,'Retail Sale Id 1283017',1798.40,0.00,0.00,0.00,134.88,'2021-12-05 13:55:33','',''),(2170369,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-05 13:55:33','',''),(2170425,'1','147','768',326,'Retail Sale Id 1283035',998.40,0.00,0.00,0.00,74.88,'2021-12-05 13:57:46','',''),(2170426,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 13:57:46','',''),(2170483,'1','147','768',326,'Retail Sale Id 1283062',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 14:01:08','',''),(2170484,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 14:01:08','',''),(2170523,'1','147','768',326,'Retail Sale Id 1283081',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 14:04:01','',''),(2170524,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 14:04:01','',''),(2170555,'1','147','768',326,'Retail Sale Id 1283102',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 14:06:34','',''),(2170556,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 14:06:34','',''),(2170577,'1','147','768',326,'Retail Sale Id 1283112',998.40,0.00,0.00,0.00,74.88,'2021-12-05 14:08:03','',''),(2170578,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 14:08:03','',''),(2170587,'1','147','768',326,'Retail Sale Id 1283119',2502.40,0.00,0.00,0.00,187.68,'2021-12-05 14:08:42','',''),(2170588,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 14:08:42','',''),(2170604,'1','147','768',326,'Retail Sale Id 1283124',998.40,0.00,0.00,0.00,74.88,'2021-12-05 14:09:34','',''),(2170605,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 14:09:34','',''),(2170654,'1','147','768',326,'Retail Sale Id 1283148',499.20,0.00,0.00,0.00,37.44,'2021-12-05 14:12:02','',''),(2170655,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-05 14:12:02','',''),(2170679,'1','147','768',326,'Retail Sale Id 1283158',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 14:13:35','',''),(2170680,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 14:13:35','',''),(2170707,'1','147','768',326,'Retail Sale Id 1283165',1900.80,0.00,0.00,0.00,142.56,'2021-12-05 14:14:37','',''),(2170708,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-05 14:14:37','',''),(2170725,'1','147','768',326,'Retail Sale Id 1283175',998.40,0.00,0.00,0.00,74.88,'2021-12-05 14:15:20','',''),(2170726,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 14:15:20','',''),(2170781,'1','147','768',326,'Retail Sale Id 1283188',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 14:16:48','',''),(2170782,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:16:48','',''),(2170812,'1','147','768',326,'Retail Sale Id 1283200',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 14:18:05','',''),(2170813,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 14:18:05','',''),(2170840,'1','147','768',326,'Retail Sale Id 1283209',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 14:18:52','',''),(2170841,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 14:18:52','',''),(2170885,'1','147','768',326,'Retail Sale Id 1283232',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 14:21:35','',''),(2170886,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 14:21:35','',''),(2170935,'1','147','768',326,'Retail Sale Id 1283255',998.40,0.00,0.00,0.00,74.88,'2021-12-05 14:24:46','',''),(2170936,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 14:24:46','',''),(2170949,'1','147','768',326,'Retail Sale Id 1283264',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 14:26:05','',''),(2170950,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:26:05','',''),(2170977,'1','147','768',326,'Retail Sale Id 1283278',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 14:28:17','',''),(2170978,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 14:28:17','',''),(2170997,'1','147','768',326,'Retail Sale Id 1283288',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 14:29:16','',''),(2170998,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 14:29:16','',''),(2171081,'1','147','768',326,'Retail Sale Id 1283313',2502.40,0.00,0.00,0.00,187.68,'2021-12-05 14:32:37','',''),(2171082,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 14:32:37','',''),(2171104,'1','147','768',326,'Retail Sale Id 1283319',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 14:33:19','',''),(2171105,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 14:33:19','',''),(2171189,'1','147','768',326,'Retail Sale Id 1283337',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 14:36:45','',''),(2171190,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 14:36:45','',''),(2171225,'1','147','768',326,'Retail Sale Id 1283357',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 14:39:20','',''),(2171226,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 14:39:20','',''),(2171367,'1','147','768',326,'Retail Sale Id 1283409',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 14:47:42','',''),(2171368,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 14:47:42','',''),(2171383,'1','147','768',326,'Retail Sale Id 1283416',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 14:48:44','',''),(2171384,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 14:48:44','',''),(2171551,'1','147','768',326,'Retail Sale Id 1283501',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 15:00:28','',''),(2171552,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:00:28','',''),(2171627,'1','147','768',326,'Retail Sale Id 1283541',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 15:06:49','',''),(2171628,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 15:06:49','',''),(2171635,'1','147','768',326,'Retail Sale Id 1283545',2598.40,0.00,0.00,0.00,194.88,'2021-12-05 15:07:30','',''),(2171636,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 15:07:30','',''),(2171675,'1','147','768',326,'Retail Sale Id 1283565',499.20,0.00,0.00,0.00,37.44,'2021-12-05 15:10:59','',''),(2171676,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-05 15:10:59','',''),(2171770,'1','147','768',326,'Retail Sale Id 1283610',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 15:17:59','',''),(2171771,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 15:17:59','',''),(2171790,'1','147','768',326,'Retail Sale Id 1283621',998.40,0.00,0.00,0.00,74.88,'2021-12-05 15:18:56','',''),(2171791,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 15:18:56','',''),(2171816,'1','147','768',326,'Retail Sale Id 1283634',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 15:21:24','',''),(2171817,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 15:21:24','',''),(2171870,'1','147','768',326,'Retail Sale Id 1283662',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 15:24:54','',''),(2171871,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 15:24:54','',''),(2171910,'1','147','768',326,'Retail Sale Id 1283685',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 15:28:27','',''),(2171911,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 15:28:27','',''),(2171926,'1','147','768',326,'Retail Sale Id 1283697',998.40,0.00,0.00,0.00,74.88,'2021-12-05 15:29:30','',''),(2171927,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 15:29:30','',''),(2171964,'1','147','768',326,'Retail Sale Id 1283706',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 15:30:40','',''),(2171965,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 15:30:40','',''),(2171997,'1','147','768',326,'Retail Sale Id 1283723',2502.40,0.00,0.00,0.00,187.68,'2021-12-05 15:32:03','',''),(2171998,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 15:32:03','',''),(2172028,'1','147','768',326,'Retail Sale Id 1283731',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 15:33:11','',''),(2172029,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 15:33:11','',''),(2172044,'1','147','768',326,'Retail Sale Id 1283739',2502.40,0.00,0.00,0.00,187.68,'2021-12-05 15:34:18','',''),(2172045,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 15:34:18','',''),(2172064,'1','147','768',326,'Retail Sale Id 1283751',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 15:35:13','',''),(2172065,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 15:35:13','',''),(2172116,'1','147','768',326,'Retail Sale Id 1283778',499.20,0.00,0.00,0.00,37.44,'2021-12-05 15:38:23','',''),(2172117,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-05 15:38:23','',''),(2172139,'1','147','768',326,'Retail Sale Id 1283790',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 15:39:33','',''),(2172140,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 15:39:33','',''),(2172207,'1','147','768',326,'Retail Sale Id 1283824',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 15:42:22','',''),(2172208,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 15:42:22','',''),(2172237,'1','147','768',326,'Retail Sale Id 1283840',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 15:43:39','',''),(2172238,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:43:39','',''),(2172263,'1','147','768',326,'Retail Sale Id 1283859',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 15:45:18','',''),(2172265,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:45:18','',''),(2172281,'1','147','768',326,'Retail Sale Id 1283869',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 15:46:11','',''),(2172282,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:46:11','',''),(2172337,'1','147','768',326,'Retail Sale Id 1283898',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 15:48:36','',''),(2172338,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 15:48:36','',''),(2172369,'1','147','768',326,'Retail Sale Id 1283915',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 15:50:19','',''),(2172370,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 15:50:19','',''),(2172387,'1','147','768',326,'Retail Sale Id 1283925',6003.20,0.00,0.00,0.00,450.24,'2021-12-05 15:51:18','',''),(2172388,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-05 15:51:18','',''),(2172404,'1','147','768',326,'Retail Sale Id 1283934',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 15:52:13','',''),(2172405,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 15:52:13','',''),(2172426,'1','147','768',326,'Retail Sale Id 1283947',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 15:53:48','',''),(2172427,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 15:53:48','',''),(2172451,'1','147','768',326,'Retail Sale Id 1283957',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 15:55:07','',''),(2172452,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 15:55:07','',''),(2172464,'1','147','768',326,'Retail Sale Id 1283966',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 15:56:07','',''),(2172465,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 15:56:07','',''),(2172488,'1','147','768',326,'Retail Sale Id 1283977',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 15:57:34','',''),(2172489,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:57:34','',''),(2172508,'1','147','768',326,'Retail Sale Id 1283988',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 15:58:44','',''),(2172509,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 15:58:44','',''),(2172526,'1','147','768',326,'Retail Sale Id 1283998',998.40,0.00,0.00,0.00,74.88,'2021-12-05 15:59:40','',''),(2172527,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 15:59:40','',''),(2172548,'1','147','768',326,'Retail Sale Id 1284009',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 16:00:43','',''),(2172549,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 16:00:43','',''),(2172560,'1','147','768',326,'Retail Sale Id 1284014',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 16:01:47','',''),(2172561,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 16:01:47','',''),(2172572,'1','147','768',326,'Retail Sale Id 1284020',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 16:02:43','',''),(2172573,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:02:43','',''),(2172592,'1','147','768',326,'Retail Sale Id 1284030',499.20,0.00,0.00,0.00,37.44,'2021-12-05 16:03:58','',''),(2172593,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-05 16:03:58','',''),(2172720,'1','147','768',326,'Retail Sale Id 1284095',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 16:11:43','',''),(2172721,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 16:11:43','',''),(2172798,'1','147','768',326,'Retail Sale Id 1284136',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 16:17:14','',''),(2172799,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 16:17:14','',''),(2172868,'1','147','768',326,'Retail Sale Id 1284176',902.40,0.00,0.00,0.00,67.68,'2021-12-05 16:21:27','',''),(2172869,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-05 16:21:27','',''),(2172890,'1','147','768',326,'Retail Sale Id 1284193',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 16:22:54','',''),(2172891,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 16:22:54','',''),(2172930,'1','147','768',326,'Retail Sale Id 1284210',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 16:24:51','',''),(2172931,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:24:51','',''),(2172953,'1','147','768',326,'Retail Sale Id 1284225',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 16:26:52','',''),(2172954,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 16:26:52','',''),(2173003,'1','147','768',326,'Retail Sale Id 1284256',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 16:31:07','',''),(2173004,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 16:31:07','',''),(2173023,'1','147','768',326,'Retail Sale Id 1284264',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 16:32:06','',''),(2173024,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 16:32:06','',''),(2173069,'1','147','768',326,'Retail Sale Id 1284286',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 16:34:10','',''),(2173070,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 16:34:10','',''),(2173093,'1','147','768',326,'Retail Sale Id 1284297',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 16:35:32','',''),(2173094,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 16:35:32','',''),(2173115,'1','147','768',326,'Retail Sale Id 1284307',800.00,0.00,0.00,0.00,60.00,'2021-12-05 16:36:31','',''),(2173116,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-05 16:36:31','',''),(2173133,'1','147','768',326,'Retail Sale Id 1284318',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 16:37:25','',''),(2173134,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 16:37:25','',''),(2173147,'1','147','768',326,'Retail Sale Id 1284325',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 16:38:15','',''),(2173148,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 16:38:15','',''),(2173165,'1','147','768',326,'Retail Sale Id 1284336',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 16:39:10','',''),(2173166,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 16:39:10','',''),(2173177,'1','147','768',326,'Retail Sale Id 1284343',998.40,0.00,0.00,0.00,74.88,'2021-12-05 16:40:04','',''),(2173178,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 16:40:04','',''),(2173217,'1','147','768',326,'Retail Sale Id 1284362',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 16:42:28','',''),(2173218,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 16:42:28','',''),(2173251,'1','147','768',326,'Retail Sale Id 1284378',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 16:44:28','',''),(2173252,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 16:44:28','',''),(2173279,'1','147','768',326,'Retail Sale Id 1284394',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 16:46:25','',''),(2173280,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 16:46:25','',''),(2173293,'1','147','768',326,'Retail Sale Id 1284401',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 16:47:37','',''),(2173294,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 16:47:37','',''),(2173313,'1','147','768',326,'Retail Sale Id 1284412',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 16:48:50','',''),(2173314,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 16:48:50','',''),(2173329,'1','147','768',326,'Retail Sale Id 1284420',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 16:49:38','',''),(2173330,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:49:38','',''),(2173361,'1','147','768',326,'Retail Sale Id 1284435',1798.40,0.00,0.00,0.00,134.88,'2021-12-05 16:51:08','',''),(2173362,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-05 16:51:08','',''),(2173369,'1','147','768',326,'Retail Sale Id 1284439',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 16:52:15','',''),(2173370,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 16:52:15','',''),(2173387,'1','147','768',326,'Retail Sale Id 1284449',998.40,0.00,0.00,0.00,74.88,'2021-12-05 16:53:14','',''),(2173388,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 16:53:14','',''),(2173441,'1','147','768',326,'Retail Sale Id 1284477',7001.60,0.00,0.00,0.00,525.12,'2021-12-05 16:56:39','',''),(2173442,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-05 16:56:39','',''),(2173457,'1','147','768',326,'Retail Sale Id 1284487',4499.20,0.00,0.00,0.00,337.44,'2021-12-05 16:57:30','',''),(2173458,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-05 16:57:30','',''),(2173469,'1','147','768',326,'Retail Sale Id 1284494',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 16:58:24','',''),(2173470,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 16:58:24','',''),(2173483,'1','147','768',326,'Retail Sale Id 1284501',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 16:59:37','',''),(2173484,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 16:59:37','',''),(2173500,'1','147','768',326,'Retail Sale Id 1284508',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 17:00:54','',''),(2173501,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 17:00:54','',''),(2173518,'1','147','768',326,'Retail Sale Id 1284517',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 17:01:51','',''),(2173519,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:01:51','',''),(2173535,'1','147','768',326,'Retail Sale Id 1284524',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 17:03:05','',''),(2173536,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 17:03:05','',''),(2173556,'1','147','768',326,'Retail Sale Id 1284534',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 17:04:39','',''),(2173557,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 17:04:39','',''),(2173588,'1','147','768',326,'Retail Sale Id 1284544',2502.40,0.00,0.00,0.00,187.68,'2021-12-05 17:05:52','',''),(2173589,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 17:05:52','',''),(2173608,'1','147','768',326,'Retail Sale Id 1284554',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 17:07:01','',''),(2173609,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 17:07:01','',''),(2173622,'1','147','768',326,'Retail Sale Id 1284560',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 17:08:10','',''),(2173623,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 17:08:10','',''),(2173642,'1','147','768',326,'Retail Sale Id 1284569',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 17:09:41','',''),(2173643,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:09:41','',''),(2173662,'1','147','768',326,'Retail Sale Id 1284575',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 17:10:48','',''),(2173663,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:10:48','',''),(2173694,'1','147','768',326,'Retail Sale Id 1284590',697.60,0.00,0.00,0.00,52.32,'2021-12-05 17:14:09','',''),(2173695,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-05 17:14:09','',''),(2173714,'1','147','768',326,'Retail Sale Id 1284601',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 17:16:04','',''),(2173715,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:16:04','',''),(2173772,'1','147','768',326,'Retail Sale Id 1284631',998.40,0.00,0.00,0.00,74.88,'2021-12-05 17:21:00','',''),(2173773,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 17:21:00','',''),(2173802,'1','147','768',326,'Retail Sale Id 1284646',16000.00,0.00,0.00,0.00,1200.00,'2021-12-05 17:24:10','',''),(2173803,'1','147','768',326,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 17:24:10','',''),(2173818,'1','147','768',326,'Retail Sale Id 1284655',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 17:25:37','',''),(2173819,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 17:25:37','',''),(2173836,'1','147','768',326,'Retail Sale Id 1284662',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 17:26:39','',''),(2173837,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 17:26:39','',''),(2173846,'1','147','768',326,'Retail Sale Id 1284669',998.40,0.00,0.00,0.00,74.88,'2021-12-05 17:27:40','',''),(2173847,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 17:27:40','',''),(2173864,'1','147','768',326,'Retail Sale Id 1284679',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 17:29:26','',''),(2173865,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 17:29:26','',''),(2173876,'1','147','768',326,'Retail Sale Id 1284684',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 17:30:17','',''),(2173877,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 17:30:17','',''),(2173898,'1','147','768',326,'Retail Sale Id 1284692',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 17:31:15','',''),(2173899,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 17:31:15','',''),(2173918,'1','147','768',326,'Retail Sale Id 1284702',1798.40,0.00,0.00,0.00,134.88,'2021-12-05 17:32:53','',''),(2173919,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-05 17:32:53','',''),(2173940,'1','147','768',326,'Retail Sale Id 1284711',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 17:34:32','',''),(2173941,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 17:34:32','',''),(2173986,'1','147','768',326,'Retail Sale Id 1284735',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 17:39:37','',''),(2173987,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 17:39:37','',''),(2173996,'1','147','768',326,'Retail Sale Id 1284740',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 17:40:43','',''),(2173997,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 17:40:43','',''),(2174012,'1','147','768',326,'Retail Sale Id 1284750',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 17:43:48','',''),(2174013,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 17:43:48','',''),(2174016,'1','147','768',326,'Retail Sale Id 1284752',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 17:44:58','',''),(2174017,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 17:44:58','',''),(2174032,'1','147','768',326,'Retail Sale Id 1284760',998.40,0.00,0.00,0.00,74.88,'2021-12-05 17:46:30','',''),(2174034,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 17:46:30','',''),(2174046,'1','147','768',326,'Retail Sale Id 1284767',1798.40,0.00,0.00,0.00,134.88,'2021-12-05 17:48:49','',''),(2174047,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-05 17:48:49','',''),(2174114,'1','147','768',326,'Retail Sale Id 1284800',998.40,0.00,0.00,0.00,74.88,'2021-12-05 18:01:19','',''),(2174115,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 18:01:19','',''),(2174178,'1','147','768',326,'Retail Sale Id 1284817',1952.00,0.00,0.00,0.00,146.40,'2021-12-05 18:11:26','',''),(2174179,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 18:11:26','',''),(2174182,'1','147','768',326,'Retail Sale Id 1284819',6400.00,0.00,0.00,0.00,480.00,'2021-12-05 18:12:40','',''),(2174183,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 18:12:40','',''),(2174186,'1','147','768',326,'Retail Sale Id 1284821',1280.00,0.00,0.00,0.00,96.00,'2021-12-05 18:14:05','',''),(2174187,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 18:14:05','',''),(2174199,'1','147','768',326,'Retail Sale Id 1284824',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 18:16:17','',''),(2174200,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 18:16:17','',''),(2174203,'1','147','768',326,'Retail Sale Id 1284826',7500.80,0.00,0.00,0.00,562.56,'2021-12-05 18:17:09','',''),(2174204,'1','147','768',326,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-05 18:17:09','',''),(2174209,'1','147','768',326,'Retail Sale Id 1284829',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 18:18:31','',''),(2174210,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 18:18:31','',''),(2174214,'1','147','768',326,'Retail Sale Id 1284830',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 18:19:30','',''),(2174215,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 18:19:30','',''),(2174226,'1','147','768',326,'Retail Sale Id 1284835',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 18:23:38','',''),(2174227,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 18:23:38','',''),(2174228,'1','147','768',326,'Retail Sale Id 1284836',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 18:28:48','',''),(2174229,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 18:28:48','',''),(2174230,'1','147','768',326,'Retail Sale Id 1284837',3897.60,0.00,0.00,0.00,292.32,'2021-12-05 18:29:36','',''),(2174231,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-05 18:29:36','',''),(2174234,'1','147','768',326,'Retail Sale Id 1284839',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 18:35:54','',''),(2174235,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 18:35:54','',''),(2174338,'1','147','768',326,'Retail Sale Id 1284862',7366.40,0.00,0.00,0.00,552.48,'2021-12-05 19:14:28','',''),(2174339,'1','147','768',326,'Retail sales',0.00,0.00,0.00,11.51,0.00,'2021-12-05 19:14:28','',''),(2174745,'1','147','768',326,'Retail Sale Id 1284888',998.40,0.00,0.00,0.00,74.88,'2021-12-06 05:35:56','',''),(2174746,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 05:35:56','',''),(2174754,'1','147','768',326,'Retail Sale Id 1284889',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 05:37:35','',''),(2174755,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 05:37:35','',''),(2174764,'1','147','768',326,'Retail Sale Id 1284890',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 05:40:05','',''),(2174765,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 05:40:05','',''),(2174766,'1','147','768',326,'Retail Sale Id 1284891',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 05:41:25','',''),(2174767,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 05:41:25','',''),(2174770,'1','147','768',326,'Retail Sale Id 1284893',998.40,0.00,0.00,0.00,74.88,'2021-12-06 05:47:51','',''),(2174771,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 05:47:51','',''),(2174800,'1','147','768',326,'Retail Sale Id 1284907',998.40,0.00,0.00,0.00,74.88,'2021-12-06 06:02:23','',''),(2174801,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 06:02:23','',''),(2174850,'1','147','768',326,'Retail Sale Id 1284929',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 06:13:43','',''),(2174851,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 06:13:43','',''),(2174858,'1','147','768',326,'Retail Sale Id 1284934',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 06:16:09','',''),(2174859,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 06:16:09','',''),(2174874,'1','147','768',326,'Retail Sale Id 1284951',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 06:18:56','',''),(2174875,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:18:56','',''),(2174896,'1','147','768',326,'Retail Sale Id 1284962',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 06:23:21','',''),(2174897,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 06:23:21','',''),(2174898,'1','147','768',326,'Retail Sale Id 1284965',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 06:24:29','',''),(2174899,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:24:29','',''),(2174941,'1','147','768',326,'Retail Sale Id 1284978',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 06:28:10','',''),(2174942,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 06:28:10','',''),(2174985,'1','147','768',326,'Retail Sale Id 1284984',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 06:30:21','',''),(2174986,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:30:21','',''),(2174996,'1','147','768',326,'Retail Sale Id 1284987',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 06:31:30','',''),(2174997,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 06:31:30','',''),(2175032,'1','147','768',326,'Retail Sale Id 1284994',998.40,0.00,0.00,0.00,74.88,'2021-12-06 06:33:07','',''),(2175033,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 06:33:07','',''),(2175121,'1','147','768',326,'Retail Sale Id 1285037',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 06:44:22','',''),(2175122,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:44:22','',''),(2175135,'1','147','768',326,'Retail Sale Id 1285043',800.00,0.00,0.00,0.00,60.00,'2021-12-06 06:45:23','',''),(2175136,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-06 06:45:23','',''),(2175147,'1','147','768',326,'Retail Sale Id 1285049',998.40,0.00,0.00,0.00,74.88,'2021-12-06 06:46:13','',''),(2175148,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 06:46:13','',''),(2175167,'1','147','768',326,'Retail Sale Id 1285060',32000.00,0.00,0.00,0.00,2400.00,'2021-12-06 06:47:38','',''),(2175168,'1','147','768',326,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 06:47:38','',''),(2175181,'1','147','768',326,'Retail Sale Id 1285070',31001.60,0.00,0.00,0.00,2325.12,'2021-12-06 06:48:44','',''),(2175182,'1','147','768',326,'Retail sales',0.00,0.00,0.00,48.44,0.00,'2021-12-06 06:48:44','',''),(2175207,'1','147','768',326,'Retail Sale Id 1285081',998.40,0.00,0.00,0.00,74.88,'2021-12-06 06:50:21','',''),(2175208,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 06:50:21','',''),(2175227,'1','147','768',326,'Return of Retail Sale Id 1285060',0.00,32000.00,50.00,0.00,-2400.00,'2021-12-06 06:52:28','',''),(2175254,'1','147','768',326,'Retail Sale Id 1285108',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 06:54:35','',''),(2175255,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 06:54:35','',''),(2175299,'1','147','768',326,'Retail Sale Id 1285123',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 06:57:05','',''),(2175300,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 06:57:05','',''),(2175489,'1','147','768',326,'Retail Sale Id 1285198',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 07:07:12','',''),(2175490,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 07:07:12','',''),(2175509,'1','147','768',326,'Retail Sale Id 1285207',4800.00,0.00,0.00,0.00,360.00,'2021-12-06 07:09:54','',''),(2175510,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.50,0.00,'2021-12-06 07:09:54','',''),(2175535,'1','147','768',326,'Retail Sale Id 1285219',998.40,0.00,0.00,0.00,74.88,'2021-12-06 07:12:09','',''),(2175536,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 07:12:09','',''),(2175555,'1','147','768',326,'Retail Sale Id 1285228',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 07:13:28','',''),(2175556,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 07:13:28','',''),(2175572,'1','147','768',326,'Retail Sale Id 1285238',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 07:14:23','',''),(2175573,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 07:14:23','',''),(2175588,'1','147','768',326,'Retail Sale Id 1285246',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 07:15:16','',''),(2175589,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 07:15:16','',''),(2175612,'1','147','768',326,'Retail Sale Id 1285258',2400.00,0.00,0.00,0.00,180.00,'2021-12-06 07:16:35','',''),(2175613,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.75,0.00,'2021-12-06 07:16:35','',''),(2175630,'1','147','768',326,'Retail Sale Id 1285271',800.00,0.00,0.00,0.00,60.00,'2021-12-06 07:17:19','',''),(2175631,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-06 07:17:19','',''),(2175644,'1','147','768',326,'Retail Sale Id 1285279',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 07:18:03','',''),(2175645,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:18:03','',''),(2175666,'1','147','768',326,'Retail Sale Id 1285292',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 07:20:06','',''),(2175667,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 07:20:06','',''),(2175694,'1','147','768',326,'Retail Sale Id 1285305',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 07:21:25','',''),(2175695,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 07:21:25','',''),(2175704,'1','147','768',326,'Retail Sale Id 1285313',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 07:22:15','',''),(2175705,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 07:22:15','',''),(2175748,'1','147','768',326,'Retail Sale Id 1285332',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 07:24:10','',''),(2175749,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 07:24:10','',''),(2175794,'1','147','768',326,'Retail Sale Id 1285354',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 07:26:52','',''),(2175795,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:26:52','',''),(2176074,'1','147','768',326,'Retail Sale Id 1285486',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 07:42:12','',''),(2176075,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 07:42:12','',''),(2176123,'1','147','768',326,'Retail Sale Id 1285519',998.40,0.00,0.00,0.00,74.88,'2021-12-06 07:44:56','',''),(2176124,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 07:44:57','',''),(2176192,'1','147','768',326,'Retail Sale Id 1285552',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 07:47:36','',''),(2176193,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 07:47:36','',''),(2176373,'1','147','768',326,'Retail Sale Id 1285622',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 07:55:14','',''),(2176374,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 07:55:14','',''),(2176429,'1','147','768',326,'Retail Sale Id 1285649',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 07:57:34','',''),(2176430,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:57:34','',''),(2176448,'1','147','768',326,'Retail Sale Id 1285656',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 07:58:18','',''),(2176449,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 07:58:18','',''),(2176568,'1','147','768',326,'Retail Sale Id 1285729',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 08:05:36','',''),(2176569,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 08:05:36','',''),(2176598,'1','147','768',326,'Retail Sale Id 1285741',1798.40,0.00,0.00,0.00,134.88,'2021-12-06 08:06:31','',''),(2176599,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-06 08:06:31','',''),(2176638,'1','147','768',326,'Retail Sale Id 1285755',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 08:08:25','',''),(2176639,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 08:08:25','',''),(2176650,'1','147','768',326,'Retail Sale Id 1285764',998.40,0.00,0.00,0.00,74.88,'2021-12-06 08:09:30','',''),(2176651,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 08:09:30','',''),(2176692,'1','147','768',326,'Retail Sale Id 1285789',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 08:12:28','',''),(2176693,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 08:12:28','',''),(2176704,'1','147','768',326,'Retail Sale Id 1285796',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 08:13:17','',''),(2176705,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 08:13:17','',''),(2176712,'1','147','768',326,'Retail Sale Id 1285800',6003.20,0.00,0.00,0.00,450.24,'2021-12-06 08:13:58','',''),(2176713,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-06 08:13:58','',''),(2176744,'1','147','768',326,'Retail Sale Id 1285816',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 08:15:23','',''),(2176745,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 08:15:23','',''),(2176774,'1','147','768',326,'Retail Sale Id 1285832',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 08:18:37','',''),(2176775,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 08:18:37','',''),(2176784,'1','147','768',326,'Retail Sale Id 1285838',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 08:19:20','',''),(2176785,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 08:19:20','',''),(2176794,'1','147','768',326,'Retail Sale Id 1285844',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 08:20:00','',''),(2176795,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 08:20:00','',''),(2176810,'1','147','768',326,'Retail Sale Id 1285853',640.00,0.00,0.00,0.00,48.00,'2021-12-06 08:21:51','',''),(2176811,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-06 08:21:51','',''),(2176843,'1','147','768',326,'Retail Sale Id 1285871',6400.00,0.00,0.00,0.00,480.00,'2021-12-06 08:25:43','',''),(2176844,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 08:25:43','',''),(2176851,'1','147','768',326,'Retail Sale Id 1285876',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 08:26:22','',''),(2176852,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 08:26:22','',''),(2176891,'1','147','768',326,'Retail Sale Id 1285899',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 08:30:27','',''),(2176892,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 08:30:27','',''),(2176943,'1','147','768',326,'Retail Sale Id 1285922',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 08:33:52','',''),(2176944,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:33:52','',''),(2176951,'1','147','768',326,'Retail Sale Id 1285926',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 08:34:29','',''),(2176952,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 08:34:29','',''),(2177037,'1','147','768',326,'Retail Sale Id 1285965',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 08:41:36','',''),(2177038,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 08:41:36','',''),(2177058,'1','147','768',326,'Retail Sale Id 1285971',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 08:42:28','',''),(2177059,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 08:42:28','',''),(2177080,'1','147','768',326,'Retail Sale Id 1285983',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 08:44:03','',''),(2177081,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 08:44:03','',''),(2177120,'1','147','768',326,'Retail Sale Id 1286000',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 08:46:31','',''),(2177121,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:46:31','',''),(2177134,'1','147','768',326,'Retail Sale Id 1286008',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 08:47:53','',''),(2177135,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 08:47:53','',''),(2177147,'1','147','768',326,'Retail Sale Id 1286015',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 08:48:45','',''),(2177148,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 08:48:45','',''),(2177159,'1','147','768',326,'Retail Sale Id 1286020',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 08:49:26','',''),(2177160,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 08:49:26','',''),(2177179,'1','147','768',326,'Retail Sale Id 1286031',2598.40,0.00,0.00,0.00,194.88,'2021-12-06 08:50:52','',''),(2177180,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-06 08:50:52','',''),(2177191,'1','147','768',326,'Retail Sale Id 1286039',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 08:52:24','',''),(2177192,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 08:52:24','',''),(2177199,'1','147','768',326,'Retail Sale Id 1286043',998.40,0.00,0.00,0.00,74.88,'2021-12-06 08:53:18','',''),(2177200,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 08:53:18','',''),(2177213,'1','147','768',326,'Retail Sale Id 1286052',998.40,0.00,0.00,0.00,74.88,'2021-12-06 08:54:00','',''),(2177214,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 08:54:00','',''),(2177223,'1','147','768',326,'Retail Sale Id 1286057',998.40,0.00,0.00,0.00,74.88,'2021-12-06 08:54:47','',''),(2177224,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 08:54:47','',''),(2177231,'1','147','768',326,'Retail Sale Id 1286061',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 08:55:24','',''),(2177232,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 08:55:24','',''),(2177276,'1','147','768',326,'Retail Sale Id 1286079',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 08:58:17','',''),(2177277,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 08:58:17','',''),(2177305,'1','147','768',326,'Retail Sale Id 1286094',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 09:00:17','',''),(2177306,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:00:17','',''),(2177319,'1','147','768',326,'Retail Sale Id 1286100',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 09:01:19','',''),(2177320,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 09:01:19','',''),(2177351,'1','147','768',326,'Retail Sale Id 1286119',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 09:04:27','',''),(2177352,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:04:27','',''),(2177367,'1','147','768',326,'Retail Sale Id 1286123',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 09:05:14','',''),(2177368,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 09:05:14','',''),(2177387,'1','147','768',326,'Retail Sale Id 1286133',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 09:05:56','',''),(2177388,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 09:05:56','',''),(2177393,'1','147','768',326,'Retail Sale Id 1286137',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 09:06:37','',''),(2177394,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:06:37','',''),(2177413,'1','147','768',326,'Retail Sale Id 1286143',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 09:07:26','',''),(2177414,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 09:07:26','',''),(2177463,'1','147','768',326,'Retail Sale Id 1286165',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 09:11:01','',''),(2177464,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 09:11:01','',''),(2177476,'1','147','768',326,'Retail Sale Id 1286172',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 09:12:34','',''),(2177477,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:12:34','',''),(2177542,'1','147','768',326,'Retail Sale Id 1286202',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 09:17:17','',''),(2177543,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 09:17:17','',''),(2177570,'1','147','768',326,'Retail Sale Id 1286211',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 09:18:59','',''),(2177571,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 09:18:59','',''),(2177588,'1','147','768',326,'Retail Sale Id 1286220',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 09:19:49','',''),(2177589,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 09:19:49','',''),(2177600,'1','147','768',326,'Retail Sale Id 1286225',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 09:20:33','',''),(2177601,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:20:33','',''),(2177624,'1','147','768',326,'Retail Sale Id 1286241',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 09:22:15','',''),(2177625,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 09:22:15','',''),(2177655,'1','147','768',326,'Retail Sale Id 1286257',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 09:24:26','',''),(2177656,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 09:24:26','',''),(2177668,'1','147','768',326,'Retail Sale Id 1286261',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 09:25:13','',''),(2177669,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:25:13','',''),(2177686,'1','147','768',326,'Retail Sale Id 1286271',1798.40,0.00,0.00,0.00,134.88,'2021-12-06 09:25:55','',''),(2177687,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-06 09:25:55','',''),(2177708,'1','147','768',326,'Retail Sale Id 1286281',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 09:27:29','',''),(2177709,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 09:27:29','',''),(2177710,'1','147','768',326,'Retail Sale Id 1286281',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 09:27:29','',''),(2177711,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:27:29','',''),(2177738,'1','147','768',326,'Retail Sale Id 1286294',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 09:28:46','',''),(2177739,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 09:28:46','',''),(2177750,'1','147','768',326,'Retail Sale Id 1286303',652.80,0.00,0.00,0.00,48.96,'2021-12-06 09:29:43','',''),(2177751,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-06 09:29:43','',''),(2177766,'1','147','768',326,'Retail Sale Id 1286309',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 09:30:37','',''),(2177767,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 09:30:37','',''),(2177778,'1','147','768',326,'Retail Sale Id 1286316',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 09:31:15','',''),(2177779,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 09:31:15','',''),(2177788,'1','147','768',326,'Retail Sale Id 1286319',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 09:31:59','',''),(2177789,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 09:31:59','',''),(2177794,'1','147','768',326,'Retail Sale Id 1286322',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 09:32:38','',''),(2177795,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 09:32:38','',''),(2177811,'1','147','768',326,'Retail Sale Id 1286326',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 09:33:13','',''),(2177812,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 09:33:13','',''),(2177861,'1','147','768',326,'Retail Sale Id 1286346',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 09:36:12','',''),(2177862,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 09:36:12','',''),(2177871,'1','147','768',326,'Retail Sale Id 1286351',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 09:36:50','',''),(2177872,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:36:50','',''),(2177939,'1','147','768',326,'Retail Sale Id 1286365',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 09:38:38','',''),(2177940,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:38:38','',''),(2177956,'1','147','768',326,'Retail Sale Id 1286369',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 09:39:30','',''),(2177957,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:39:30','',''),(2177970,'1','147','768',326,'Retail Sale Id 1286380',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 09:40:52','',''),(2177971,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 09:40:52','',''),(2177986,'1','147','768',326,'Retail Sale Id 1286389',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 09:41:54','',''),(2177987,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:41:54','',''),(2178030,'1','147','768',326,'Retail Sale Id 1286404',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 09:44:31','',''),(2178031,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 09:44:31','',''),(2178064,'1','147','768',326,'Retail Sale Id 1286423',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 09:46:48','',''),(2178065,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 09:46:48','',''),(2178078,'1','147','768',326,'Retail Sale Id 1286430',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 09:47:35','',''),(2178079,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 09:47:35','',''),(2178096,'1','147','768',326,'Retail Sale Id 1286439',1702.40,0.00,0.00,0.00,127.68,'2021-12-06 09:48:38','',''),(2178097,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-06 09:48:38','',''),(2178106,'1','147','768',326,'Retail Sale Id 1286443',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 09:49:25','',''),(2178107,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 09:49:25','',''),(2178110,'1','147','768',326,'Retail Sale Id 1286447',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 09:50:10','',''),(2178111,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 09:50:10','',''),(2178127,'1','147','768',326,'Retail Sale Id 1286457',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 09:51:20','',''),(2178128,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 09:51:20','',''),(2178159,'1','147','768',326,'Retail Sale Id 1286473',499.20,0.00,0.00,0.00,37.44,'2021-12-06 09:53:49','',''),(2178160,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-06 09:53:49','',''),(2178304,'1','147','768',326,'Retail Sale Id 1286549',499.20,0.00,0.00,0.00,37.44,'2021-12-06 10:03:44','',''),(2178305,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-06 10:03:45','',''),(2178318,'1','147','768',326,'Retail Sale Id 1286558',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 10:04:28','',''),(2178319,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 10:04:28','',''),(2178350,'1','147','768',326,'Retail Sale Id 1286563',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 10:05:25','',''),(2178351,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 10:05:25','',''),(2178378,'1','147','768',326,'Retail Sale Id 1286578',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 10:07:15','',''),(2178379,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 10:07:15','',''),(2178398,'1','147','768',326,'Retail Sale Id 1286588',998.40,0.00,0.00,0.00,74.88,'2021-12-06 10:08:27','',''),(2178399,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 10:08:27','',''),(2178431,'1','147','768',326,'Retail Sale Id 1286596',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 10:09:14','',''),(2178432,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 10:09:14','',''),(2178499,'1','147','768',326,'Retail Sale Id 1286635',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 10:13:48','',''),(2178500,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:13:48','',''),(2178517,'1','147','768',326,'Retail Sale Id 1286646',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 10:15:21','',''),(2178518,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 10:15:21','',''),(2178571,'1','147','768',326,'Retail Sale Id 1286672',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 10:18:19','',''),(2178572,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:18:19','',''),(2178577,'1','147','768',326,'Retail Sale Id 1286674',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 10:19:07','',''),(2178578,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 10:19:07','',''),(2178735,'1','147','768',326,'Retail Sale Id 1286759',6502.40,0.00,0.00,0.00,487.68,'2021-12-06 10:30:16','',''),(2178736,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-06 10:30:16','',''),(2178745,'1','147','768',326,'Retail Sale Id 1286765',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 10:31:01','',''),(2178746,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 10:31:01','',''),(2178753,'1','147','768',326,'Retail Sale Id 1286769',6003.20,0.00,0.00,0.00,450.24,'2021-12-06 10:31:42','',''),(2178754,'1','147','768',326,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-06 10:31:42','',''),(2178767,'1','147','768',326,'Retail Sale Id 1286775',6400.00,0.00,0.00,0.00,480.00,'2021-12-06 10:32:25','',''),(2178768,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 10:32:25','',''),(2178782,'1','147','768',326,'Retail Sale Id 1286779',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 10:33:07','',''),(2178783,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 10:33:07','',''),(2178822,'1','147','768',326,'Retail Sale Id 1286806',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 10:36:48','',''),(2178823,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 10:36:48','',''),(2178874,'1','147','768',326,'Retail Sale Id 1286837',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 10:40:25','',''),(2178875,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 10:40:25','',''),(2178904,'1','147','768',326,'Retail Sale Id 1286857',800.00,0.00,0.00,0.00,60.00,'2021-12-06 10:42:29','',''),(2178905,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-06 10:42:29','',''),(2178922,'1','147','768',326,'Retail Sale Id 1286865',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 10:43:24','',''),(2178923,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 10:43:24','',''),(2178938,'1','147','768',326,'Retail Sale Id 1286873',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 10:44:31','',''),(2178939,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:44:31','',''),(2178972,'1','147','768',326,'Retail Sale Id 1286887',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 10:46:07','',''),(2178973,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 10:46:07','',''),(2178994,'1','147','768',326,'Retail Sale Id 1286898',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 10:47:16','',''),(2178995,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 10:47:16','',''),(2179010,'1','147','768',326,'Retail Sale Id 1286907',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 10:48:14','',''),(2179011,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:48:14','',''),(2179028,'1','147','768',326,'Retail Sale Id 1286922',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 10:49:30','',''),(2179029,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 10:49:30','',''),(2179050,'1','147','768',326,'Retail Sale Id 1286939',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 10:50:30','',''),(2179051,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 10:50:30','',''),(2179074,'1','147','768',326,'Retail Sale Id 1286950',6400.00,0.00,0.00,0.00,480.00,'2021-12-06 10:51:38','',''),(2179075,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 10:51:38','',''),(2179100,'1','147','768',326,'Retail Sale Id 1286963',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 10:53:43','',''),(2179101,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 10:53:44','',''),(2179235,'1','147','768',326,'Retail Sale Id 1287046',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 11:01:55','',''),(2179236,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 11:01:55','',''),(2179303,'1','147','768',326,'Retail Sale Id 1287088',11520.00,0.00,0.00,0.00,864.00,'2021-12-06 11:06:22','',''),(2179304,'1','147','768',326,'Retail sales',0.00,0.00,0.00,18.00,0.00,'2021-12-06 11:06:22','',''),(2179363,'1','147','768',326,'Retail Sale Id 1287118',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 11:09:57','',''),(2179364,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 11:09:57','',''),(2179405,'1','147','768',326,'Retail Sale Id 1287141',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 11:12:57','',''),(2179406,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 11:12:57','',''),(2179483,'1','147','768',326,'Retail Sale Id 1287179',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 11:16:58','',''),(2179484,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 11:16:58','',''),(2179531,'1','147','768',326,'Retail Sale Id 1287206',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 11:19:30','',''),(2179532,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:19:30','',''),(2179553,'1','147','768',326,'Retail Sale Id 1287220',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 11:20:58','',''),(2179554,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 11:20:58','',''),(2179563,'1','147','768',326,'Retail Sale Id 1287229',7500.80,0.00,0.00,0.00,562.56,'2021-12-06 11:21:54','',''),(2179564,'1','147','768',326,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-06 11:21:54','',''),(2179633,'1','147','768',326,'Retail Sale Id 1287266',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 11:26:46','',''),(2179634,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 11:26:46','',''),(2179651,'1','147','768',326,'Retail Sale Id 1287279',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 11:28:09','',''),(2179652,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 11:28:09','',''),(2179742,'1','147','768',326,'Retail Sale Id 1287328',1401.60,0.00,0.00,0.00,105.12,'2021-12-06 11:35:07','',''),(2179743,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-06 11:35:07','',''),(2179776,'1','147','768',326,'Retail Sale Id 1287345',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 11:38:07','',''),(2179777,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 11:38:07','',''),(2179786,'1','147','768',326,'Retail Sale Id 1287349',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 11:39:03','',''),(2179787,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:39:03','',''),(2179802,'1','147','768',326,'Retail Sale Id 1287357',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 11:40:35','',''),(2179803,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 11:40:35','',''),(2179815,'1','147','768',326,'Retail Sale Id 1287364',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 11:41:37','',''),(2179816,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 11:41:37','',''),(2180018,'1','147','768',326,'Retail Sale Id 1287526',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 11:55:43','',''),(2180019,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 11:55:43','',''),(2180044,'1','147','768',326,'Retail Sale Id 1287541',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 11:57:23','',''),(2180045,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 11:57:23','',''),(2180062,'1','147','768',326,'Retail Sale Id 1287550',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 11:58:36','',''),(2180066,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:58:36','',''),(2180084,'1','147','768',326,'Retail Sale Id 1287561',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 11:59:41','',''),(2180085,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 11:59:41','',''),(2180110,'1','147','768',326,'Retail Sale Id 1287569',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 12:01:55','',''),(2180111,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:01:55','',''),(2180120,'1','147','768',326,'Retail Sale Id 1287578',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 12:02:39','',''),(2180121,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:02:39','',''),(2180146,'1','147','768',326,'Retail Sale Id 1287590',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 12:03:56','',''),(2180147,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:03:56','',''),(2180168,'1','147','768',326,'Retail Sale Id 1287598',998.40,0.00,0.00,0.00,74.88,'2021-12-06 12:04:50','',''),(2180169,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 12:04:50','',''),(2180184,'1','147','768',326,'Retail Sale Id 1287609',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 12:05:47','',''),(2180185,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 12:05:47','',''),(2180202,'1','147','768',326,'Retail Sale Id 1287616',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 12:06:57','',''),(2180203,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:06:58','',''),(2180208,'1','147','768',326,'Retail Sale Id 1287622',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 12:07:37','',''),(2180209,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 12:07:37','',''),(2180220,'1','147','768',326,'Retail Sale Id 1287630',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 12:08:21','',''),(2180221,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:08:21','',''),(2180252,'1','147','768',326,'Retail Sale Id 1287644',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 12:09:58','',''),(2180253,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 12:09:58','',''),(2180268,'1','147','768',326,'Retail Sale Id 1287652',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 12:10:55','',''),(2180269,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 12:10:55','',''),(2180332,'1','147','768',326,'Retail Sale Id 1287701',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 12:14:44','',''),(2180333,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 12:14:44','',''),(2180574,'1','147','768',326,'Retail Sale Id 1287831',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 12:30:18','',''),(2180575,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 12:30:18','',''),(2180678,'1','147','768',326,'Retail Sale Id 1287880',998.40,0.00,0.00,0.00,74.88,'2021-12-06 12:36:13','',''),(2180679,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 12:36:13','',''),(2180704,'1','147','768',326,'Retail Sale Id 1287894',2297.60,0.00,0.00,0.00,172.32,'2021-12-06 12:37:27','',''),(2180705,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.59,0.00,'2021-12-06 12:37:27','',''),(2180720,'1','147','768',326,'Retail Sale Id 1287904',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 12:38:40','',''),(2180721,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 12:38:40','',''),(2180794,'1','147','768',326,'Retail Sale Id 1287938',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 12:43:49','',''),(2180795,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:43:49','',''),(2180814,'1','147','768',326,'Retail Sale Id 1287952',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 12:44:53','',''),(2180815,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 12:44:53','',''),(2180848,'1','147','768',326,'Retail Sale Id 1287966',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 12:46:57','',''),(2180849,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:46:57','',''),(2180927,'1','147','768',326,'Retail Sale Id 1288009',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 12:51:51','',''),(2180928,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 12:51:51','',''),(2180974,'1','147','768',326,'Retail Sale Id 1288031',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 12:54:29','',''),(2180975,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 12:54:29','',''),(2180990,'1','147','768',326,'Retail Sale Id 1288045',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 12:55:35','',''),(2180991,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 12:55:35','',''),(2181008,'1','147','768',326,'Retail Sale Id 1288052',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 12:56:33','',''),(2181009,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 12:56:33','',''),(2181128,'1','147','768',326,'Retail Sale Id 1288109',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 13:02:46','',''),(2181129,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 13:02:46','',''),(2181142,'1','147','768',326,'Retail Sale Id 1288116',6400.00,0.00,0.00,0.00,480.00,'2021-12-06 13:03:48','',''),(2181143,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 13:03:48','',''),(2181170,'1','147','768',326,'Retail Sale Id 1288130',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 13:05:32','',''),(2181171,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:05:32','',''),(2181184,'1','147','768',326,'Retail Sale Id 1288138',1798.40,0.00,0.00,0.00,134.88,'2021-12-06 13:06:40','',''),(2181185,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-06 13:06:40','',''),(2181222,'1','147','768',326,'Retail Sale Id 1288158',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 13:08:38','',''),(2181223,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 13:08:38','',''),(2181248,'1','147','768',326,'Retail Sale Id 1288168',2803.20,0.00,0.00,0.00,210.24,'2021-12-06 13:09:45','',''),(2181249,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-06 13:09:45','',''),(2181260,'1','147','768',326,'Retail Sale Id 1288184',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 13:10:35','',''),(2181261,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:10:35','',''),(2181290,'1','147','768',326,'Retail Sale Id 1288200',7001.60,0.00,0.00,0.00,525.12,'2021-12-06 13:12:10','',''),(2181291,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-06 13:12:10','',''),(2181306,'1','147','768',326,'Retail Sale Id 1288208',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 13:13:13','',''),(2181307,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 13:13:13','',''),(2181341,'1','147','768',326,'Retail Sale Id 1288220',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 13:14:34','',''),(2181342,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:14:34','',''),(2181381,'1','147','768',326,'Retail Sale Id 1288240',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 13:16:34','',''),(2181382,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 13:16:34','',''),(2181400,'1','147','768',326,'Retail Sale Id 1288244',998.40,0.00,0.00,0.00,74.88,'2021-12-06 13:17:47','',''),(2181401,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 13:17:47','',''),(2181435,'1','147','768',326,'Retail Sale Id 1288253',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 13:18:52','',''),(2181436,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 13:18:52','',''),(2181526,'1','147','768',326,'Retail Sale Id 1288295',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 13:24:47','',''),(2181527,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:24:47','',''),(2181653,'1','147','768',326,'Retail Sale Id 1288348',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 13:33:48','',''),(2181654,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:33:48','',''),(2181692,'1','147','768',326,'Retail Sale Id 1288360',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 13:35:17','',''),(2181693,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 13:35:17','',''),(2181768,'1','147','768',326,'Retail Sale Id 1288402',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 13:39:31','',''),(2181769,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 13:39:31','',''),(2181800,'1','147','768',326,'Retail Sale Id 1288414',499.20,0.00,0.00,0.00,37.44,'2021-12-06 13:40:30','',''),(2181801,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-06 13:40:30','',''),(2181826,'1','147','768',326,'Retail Sale Id 1288423',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 13:41:15','',''),(2181827,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:41:15','',''),(2181830,'1','147','768',326,'Retail Sale Id 1288428',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 13:42:10','',''),(2181831,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 13:42:10','',''),(2181905,'1','147','768',326,'Retail Sale Id 1288458',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 13:45:23','',''),(2181906,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 13:45:23','',''),(2181921,'1','147','768',326,'Retail Sale Id 1288467',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 13:46:20','',''),(2181922,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 13:46:20','',''),(2181941,'1','147','768',326,'Retail Sale Id 1288478',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 13:47:19','',''),(2181942,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:47:19','',''),(2181987,'1','147','768',326,'Retail Sale Id 1288495',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 13:49:18','',''),(2181988,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 13:49:18','',''),(2182003,'1','147','768',326,'Retail Sale Id 1288506',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 13:50:23','',''),(2182004,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 13:50:23','',''),(2182015,'1','147','768',326,'Retail Sale Id 1288512',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 13:51:12','',''),(2182016,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 13:51:12','',''),(2182035,'1','147','768',326,'Retail Sale Id 1288521',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 13:52:04','',''),(2182036,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 13:52:04','',''),(2182061,'1','147','768',326,'Retail Sale Id 1288537',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 13:53:26','',''),(2182062,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 13:53:26','',''),(2182081,'1','147','768',326,'Retail Sale Id 1288547',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 13:54:39','',''),(2182082,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 13:54:39','',''),(2182109,'1','147','768',326,'Retail Sale Id 1288560',4998.40,0.00,0.00,0.00,374.88,'2021-12-06 13:55:43','',''),(2182110,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 13:55:43','',''),(2182147,'1','147','768',326,'Retail Sale Id 1288578',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 13:57:56','',''),(2182148,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:57:56','',''),(2182192,'1','147','768',326,'Retail Sale Id 1288593',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 13:59:26','',''),(2182193,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 13:59:26','',''),(2182208,'1','147','768',326,'Retail Sale Id 1288603',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 14:00:13','',''),(2182209,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 14:00:13','',''),(2182273,'1','147','768',326,'Retail Sale Id 1288632',998.40,0.00,0.00,0.00,74.88,'2021-12-06 14:03:11','',''),(2182274,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 14:03:11','',''),(2182293,'1','147','768',326,'Retail Sale Id 1288643',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 14:04:06','',''),(2182294,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 14:04:06','',''),(2182321,'1','147','768',326,'Retail Sale Id 1288654',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 14:05:25','',''),(2182322,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 14:05:25','',''),(2182359,'1','147','768',326,'Retail Sale Id 1288669',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 14:07:08','',''),(2182360,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:07:08','',''),(2182379,'1','147','768',326,'Retail Sale Id 1288680',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 14:08:20','',''),(2182380,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 14:08:20','',''),(2182412,'1','147','768',326,'Retail Sale Id 1288689',2297.60,0.00,0.00,0.00,172.32,'2021-12-06 14:09:25','',''),(2182413,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.59,0.00,'2021-12-06 14:09:25','',''),(2182455,'1','147','768',326,'Retail Sale Id 1288709',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 14:11:08','',''),(2182456,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:11:08','',''),(2182559,'1','147','768',326,'Retail Sale Id 1288754',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 14:16:03','',''),(2182560,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:16:03','',''),(2182589,'1','147','768',326,'Retail Sale Id 1288762',697.60,0.00,0.00,0.00,52.32,'2021-12-06 14:16:51','',''),(2182590,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 14:16:51','',''),(2182619,'1','147',NULL,326,'Purchased from AA RANO NIGERIA LIMITED',0.00,1397120.00,2360.00,0.00,0.00,'2021-12-06 14:18:30','',''),(2182648,'1','147',NULL,326,'Reception corrector for bridging 126376',0.00,0.00,0.00,2360.00,0.00,'2021-12-06 14:19:50','',''),(2182649,'1','147','768',326,'Received from bridging 126376',0.00,0.00,2360.00,0.00,0.00,'2021-12-06 14:19:50','',''),(2182652,'1','147','768',326,'Retail Sale Id 1288799',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 14:20:18','',''),(2182653,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 14:20:18','',''),(2182668,'1','147','768',326,'Retail Sale Id 1288805',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 14:21:03','',''),(2182669,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:21:03','',''),(2182680,'1','147','768',326,'Retail Sale Id 1288814',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 14:21:45','',''),(2182681,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 14:21:45','',''),(2182700,'1','147','768',326,'Retail Sale Id 1288820',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 14:22:46','',''),(2182701,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 14:22:46','',''),(2182780,'1','147','768',326,'Retail Sale Id 1288862',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 14:27:11','',''),(2182781,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 14:27:11','',''),(2182802,'1','147','768',326,'Retail Sale Id 1288874',6400.00,0.00,0.00,0.00,480.00,'2021-12-06 14:28:31','',''),(2182803,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 14:28:31','',''),(2182846,'1','147','768',326,'Retail Sale Id 1288896',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 14:31:33','',''),(2182847,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:31:33','',''),(2182872,'1','147','768',326,'Retail Sale Id 1288911',4998.40,0.00,0.00,0.00,374.88,'2021-12-06 14:32:49','',''),(2182873,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 14:32:49','',''),(2182901,'1','147','768',326,'Retail Sale Id 1288923',998.40,0.00,0.00,0.00,74.88,'2021-12-06 14:33:43','',''),(2182902,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 14:33:43','',''),(2182911,'1','147','768',326,'Retail Sale Id 1288929',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 14:34:28','',''),(2182912,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 14:34:28','',''),(2182970,'1','147','768',326,'Retail Sale Id 1288955',4998.40,0.00,0.00,0.00,374.88,'2021-12-06 14:38:16','',''),(2182971,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 14:38:16','',''),(2182994,'1','147','768',326,'Retail Sale Id 1288966',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 14:39:40','',''),(2182995,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 14:39:40','',''),(2183073,'1','147','768',326,'Retail Sale Id 1288990',6400.00,0.00,0.00,0.00,480.00,'2021-12-06 14:42:34','',''),(2183074,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 14:42:34','',''),(2183093,'1','147','768',326,'Retail Sale Id 1289000',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 14:43:24','',''),(2183094,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 14:43:24','',''),(2183111,'1','147','768',326,'Retail Sale Id 1289008',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 14:44:19','',''),(2183112,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:44:19','',''),(2183133,'1','147','768',326,'Retail Sale Id 1289017',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 14:45:39','',''),(2183134,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 14:45:39','',''),(2183147,'1','147','768',326,'Retail Sale Id 1289026',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 14:46:41','',''),(2183148,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 14:46:41','',''),(2183168,'1','147','768',326,'Retail Sale Id 1289031',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 14:47:36','',''),(2183169,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 14:47:36','',''),(2183234,'1','147','768',326,'Retail Sale Id 1289060',1401.60,0.00,0.00,0.00,105.12,'2021-12-06 14:50:29','',''),(2183235,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.19,0.00,'2021-12-06 14:50:29','',''),(2183287,'1','147','768',326,'Retail Sale Id 1289083',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 14:52:57','',''),(2183288,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 14:52:57','',''),(2183337,'1','147','768',326,'Retail Sale Id 1289108',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 14:55:18','',''),(2183338,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 14:55:18','',''),(2183403,'1','147','768',326,'Retail Sale Id 1289138',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 14:58:39','',''),(2183404,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 14:58:39','',''),(2183415,'1','147','768',326,'Retail Sale Id 1289148',998.40,0.00,0.00,0.00,74.88,'2021-12-06 14:59:40','',''),(2183416,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 14:59:40','',''),(2183479,'1','147','768',326,'Retail Sale Id 1289185',902.40,0.00,0.00,0.00,67.68,'2021-12-06 15:03:20','',''),(2183480,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-06 15:03:20','',''),(2183481,'1','147','768',326,'Retail Sale Id 1289185',902.40,0.00,0.00,0.00,67.68,'2021-12-06 15:03:20','',''),(2183482,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-06 15:03:20','',''),(2183557,'1','147','768',326,'Retail Sale Id 1289221',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 15:07:26','',''),(2183558,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:07:26','',''),(2183578,'1','147','768',326,'Retail Sale Id 1289231',499.20,0.00,0.00,0.00,37.44,'2021-12-06 15:08:40','',''),(2183579,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-06 15:08:40','',''),(2183691,'1','147','768',326,'Retail Sale Id 1289275',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 15:14:53','',''),(2183692,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 15:14:53','',''),(2183740,'1','147','768',326,'Retail Sale Id 1289296',1203.20,0.00,0.00,0.00,90.24,'2021-12-06 15:17:23','',''),(2183741,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-06 15:17:23','',''),(2183764,'1','147','768',326,'Retail Sale Id 1289314',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 15:19:21','',''),(2183765,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 15:19:21','',''),(2183808,'1','147','768',326,'Retail Sale Id 1289328',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 15:20:24','',''),(2183809,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 15:20:24','',''),(2183830,'1','147','768',326,'Retail Sale Id 1289338',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:21:34','',''),(2183831,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:21:34','',''),(2183880,'1','147','768',326,'Retail Sale Id 1289355',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:23:14','',''),(2183881,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:23:14','',''),(2183911,'1','147','768',326,'Retail Sale Id 1289374',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 15:24:28','',''),(2183912,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 15:24:28','',''),(2183935,'1','147','768',326,'Retail Sale Id 1289384',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 15:25:30','',''),(2183936,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 15:25:30','',''),(2183957,'1','147','768',326,'Retail Sale Id 1289395',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 15:26:27','',''),(2183958,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 15:26:27','',''),(2183980,'1','147','768',326,'Retail Sale Id 1289408',2560.00,0.00,0.00,0.00,192.00,'2021-12-06 15:27:45','',''),(2183981,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 15:27:45','',''),(2184045,'1','147','768',326,'Retail Sale Id 1289442',28998.40,0.00,0.00,0.00,2174.88,'2021-12-06 15:31:45','',''),(2184046,'1','147','768',326,'Retail sales',0.00,0.00,0.00,45.31,0.00,'2021-12-06 15:31:45','',''),(2184065,'1','147','768',326,'Retail Sale Id 1289452',4499.20,0.00,0.00,0.00,337.44,'2021-12-06 15:32:27','',''),(2184066,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-06 15:32:27','',''),(2184073,'1','147','768',326,'Retail Sale Id 1289456',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 15:33:04','',''),(2184074,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 15:33:04','',''),(2184085,'1','147','768',326,'Retail Sale Id 1289460',1600.00,0.00,0.00,0.00,120.00,'2021-12-06 15:33:52','',''),(2184086,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 15:33:52','',''),(2184107,'1','147','768',326,'Retail Sale Id 1289472',2700.80,0.00,0.00,0.00,202.56,'2021-12-06 15:35:00','',''),(2184108,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.22,0.00,'2021-12-06 15:35:00','',''),(2184119,'1','147','768',326,'Retail Sale Id 1289479',1798.40,0.00,0.00,0.00,134.88,'2021-12-06 15:35:56','',''),(2184120,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-06 15:35:56','',''),(2184134,'1','147','768',326,'Retail Sale Id 1289486',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:36:37','',''),(2184135,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:36:37','',''),(2184152,'1','147','768',326,'Retail Sale Id 1289497',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:37:24','',''),(2184153,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:37:24','',''),(2184207,'1','147','768',326,'Retail Sale Id 1289514',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 15:39:19','',''),(2184208,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 15:39:19','',''),(2184247,'1','147','768',326,'Retail Sale Id 1289525',2598.40,0.00,0.00,0.00,194.88,'2021-12-06 15:40:33','',''),(2184248,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-06 15:40:33','',''),(2184270,'1','147','768',326,'Retail Sale Id 1289530',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 15:41:12','',''),(2184271,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 15:41:12','',''),(2184305,'1','147','768',326,'Retail Sale Id 1289539',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 15:42:16','',''),(2184306,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 15:42:16','',''),(2184332,'1','147','768',326,'Retail Sale Id 1289548',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 15:42:57','',''),(2184333,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:42:57','',''),(2184363,'1','147','768',326,'Retail Sale Id 1289558',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:43:55','',''),(2184364,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:43:55','',''),(2184389,'1','147','768',326,'Retail Sale Id 1289569',998.40,0.00,0.00,0.00,74.88,'2021-12-06 15:44:53','',''),(2184390,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 15:44:53','',''),(2184412,'1','147','768',326,'Retail Sale Id 1289576',7500.80,0.00,0.00,0.00,562.56,'2021-12-06 15:45:46','',''),(2184413,'1','147','768',326,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-06 15:45:46','',''),(2184443,'1','147','768',326,'Retail Sale Id 1289586',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 15:46:39','',''),(2184444,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 15:46:39','',''),(2184479,'1','147','768',326,'Retail Sale Id 1289602',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:48:53','',''),(2184480,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:48:53','',''),(2184498,'1','147','768',326,'Retail Sale Id 1289612',998.40,0.00,0.00,0.00,74.88,'2021-12-06 15:49:39','',''),(2184499,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 15:49:39','',''),(2184540,'1','147','768',326,'Retail Sale Id 1289632',3302.40,0.00,0.00,0.00,247.68,'2021-12-06 15:51:48','',''),(2184541,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.16,0.00,'2021-12-06 15:51:48','',''),(2184548,'1','147','768',326,'Retail Sale Id 1289636',7040.00,0.00,0.00,0.00,528.00,'2021-12-06 15:52:44','',''),(2184549,'1','147','768',326,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-06 15:52:44','',''),(2184570,'1','147','768',326,'Retail Sale Id 1289647',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 15:53:43','',''),(2184571,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 15:53:43','',''),(2184587,'1','147','768',326,'Retail Sale Id 1289656',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 15:54:27','',''),(2184588,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 15:54:27','',''),(2184604,'1','147','768',326,'Retail Sale Id 1289661',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 15:55:19','',''),(2184605,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 15:55:19','',''),(2184620,'1','147','768',326,'Retail Sale Id 1289670',7001.60,0.00,0.00,0.00,525.12,'2021-12-06 15:56:06','',''),(2184621,'1','147','768',326,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-06 15:56:06','',''),(2184632,'1','147','768',326,'Retail Sale Id 1289676',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:56:47','',''),(2184633,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:56:47','',''),(2184657,'1','147','768',326,'Retail Sale Id 1289687',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 15:57:55','',''),(2184658,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 15:57:55','',''),(2184672,'1','147','768',326,'Retail Sale Id 1289696',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:58:45','',''),(2184673,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:58:45','',''),(2184691,'1','147','768',326,'Retail Sale Id 1289705',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 16:00:13','',''),(2184692,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 16:00:13','',''),(2184710,'1','147','768',326,'Retail Sale Id 1289714',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 16:01:13','',''),(2184711,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:01:13','',''),(2184721,'1','147','768',326,'Retail Sale Id 1289718',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 16:02:02','',''),(2184722,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 16:02:02','',''),(2184741,'1','147','768',326,'Retail Sale Id 1289727',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 16:03:00','',''),(2184742,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 16:03:00','',''),(2184762,'1','147','768',326,'Retail Sale Id 1289737',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 16:04:06','',''),(2184763,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:04:06','',''),(2184775,'1','147','768',326,'Retail Sale Id 1289741',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 16:05:06','',''),(2184776,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 16:05:06','',''),(2184787,'1','147','768',326,'Retail Sale Id 1289747',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 16:05:47','',''),(2184788,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:05:47','',''),(2184815,'1','147','768',326,'Retail Sale Id 1289760',601.60,0.00,0.00,0.00,45.12,'2021-12-06 16:07:25','',''),(2184816,'1','147','768',326,'Retail sales',0.00,0.00,0.00,0.94,0.00,'2021-12-06 16:07:25','',''),(2184820,'1','147','768',326,'Retail Sale Id 1289762',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 16:08:10','',''),(2184821,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 16:08:10','',''),(2184835,'1','147','768',326,'Retail Sale Id 1289769',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 16:09:10','',''),(2184836,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:09:10','',''),(2184849,'1','147','768',326,'Retail Sale Id 1289776',4499.20,0.00,0.00,0.00,337.44,'2021-12-06 16:10:06','',''),(2184850,'1','147','768',326,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-06 16:10:06','',''),(2184871,'1','147','768',326,'Retail Sale Id 1289786',998.40,0.00,0.00,0.00,74.88,'2021-12-06 16:11:31','',''),(2184872,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 16:11:31','',''),(2184886,'1','147','768',326,'Retail Sale Id 1289794',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 16:12:45','',''),(2184887,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 16:12:45','',''),(2184899,'1','147','768',326,'Retail Sale Id 1289799',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 16:13:35','',''),(2184900,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 16:13:35','',''),(2184930,'1','147','768',326,'Retail Sale Id 1289811',13497.60,0.00,0.00,0.00,1012.32,'2021-12-06 16:15:40','',''),(2184931,'1','147','768',326,'Retail sales',0.00,0.00,0.00,21.09,0.00,'2021-12-06 16:15:40','',''),(2184944,'1','147','768',326,'Retail Sale Id 1289820',998.40,0.00,0.00,0.00,74.88,'2021-12-06 16:16:43','',''),(2184945,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 16:16:43','',''),(2184970,'1','147','768',326,'Retail Sale Id 1289830',1900.80,0.00,0.00,0.00,142.56,'2021-12-06 16:17:43','',''),(2184971,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-06 16:17:43','',''),(2184987,'1','147','768',326,'Retail Sale Id 1289839',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 16:18:47','',''),(2184988,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 16:18:47','',''),(2185010,'1','147','768',326,'Retail Sale Id 1289852',998.40,0.00,0.00,0.00,74.88,'2021-12-06 16:19:48','',''),(2185011,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 16:19:48','',''),(2185035,'1','147','768',326,'Retail Sale Id 1289864',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 16:20:58','',''),(2185036,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 16:20:58','',''),(2185145,'1','147','768',326,'Retail Sale Id 1289917',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 16:26:33','',''),(2185146,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:26:33','',''),(2185197,'1','147','768',326,'Retail Sale Id 1289944',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 16:29:06','',''),(2185198,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 16:29:06','',''),(2185220,'1','147','768',326,'Retail Sale Id 1289954',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 16:30:16','',''),(2185221,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 16:30:16','',''),(2185238,'1','147','768',326,'Retail Sale Id 1289966',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 16:31:18','',''),(2185239,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 16:31:18','',''),(2185260,'1','147','768',326,'Retail Sale Id 1289979',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 16:32:27','',''),(2185261,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 16:32:27','',''),(2185293,'1','147','768',326,'Retail Sale Id 1289992',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 16:33:35','',''),(2185294,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 16:33:35','',''),(2185320,'1','147','768',326,'Retail Sale Id 1290005',998.40,0.00,0.00,0.00,74.88,'2021-12-06 16:34:57','',''),(2185321,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 16:34:57','',''),(2185330,'1','147','768',326,'Retail Sale Id 1290010',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 16:35:48','',''),(2185331,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 16:35:48','',''),(2185373,'1','147','768',326,'Retail Sale Id 1290031',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 16:38:11','',''),(2185374,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:38:11','',''),(2185490,'1','147','768',326,'Retail Sale Id 1290085',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 16:45:36','',''),(2185491,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 16:45:36','',''),(2185508,'1','147','768',326,'Retail Sale Id 1290094',14080.00,0.00,0.00,0.00,1056.00,'2021-12-06 16:46:44','',''),(2185509,'1','147','768',326,'Retail sales',0.00,0.00,0.00,22.00,0.00,'2021-12-06 16:46:44','',''),(2185539,'1','147','768',326,'Retail Sale Id 1290108',2700.80,0.00,0.00,0.00,202.56,'2021-12-06 16:47:36','',''),(2185540,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.22,0.00,'2021-12-06 16:47:36','',''),(2185565,'1','147','768',326,'Retail Sale Id 1290117',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 16:48:17','',''),(2185566,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 16:48:17','',''),(2185577,'1','147','768',326,'Retail Sale Id 1290125',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 16:48:58','',''),(2185578,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 16:48:58','',''),(2185591,'1','147','768',326,'Retail Sale Id 1290132',1952.00,0.00,0.00,0.00,146.40,'2021-12-06 16:49:44','',''),(2185592,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 16:49:44','',''),(2185635,'1','147','768',326,'Retail Sale Id 1290157',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 16:51:50','',''),(2185636,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:51:50','',''),(2185650,'1','147','768',326,'Retail Sale Id 1290165',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 16:52:33','',''),(2185651,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 16:52:33','',''),(2185664,'1','147','768',326,'Retail Sale Id 1290170',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 16:53:29','',''),(2185665,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 16:53:29','',''),(2185718,'1','147','768',326,'Retail Sale Id 1290201',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 16:56:59','',''),(2185719,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 16:56:59','',''),(2185750,'1','147','768',326,'Retail Sale Id 1290218',2400.00,0.00,0.00,0.00,180.00,'2021-12-06 16:59:20','',''),(2185751,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.75,0.00,'2021-12-06 16:59:20','',''),(2185780,'1','147','768',326,'Retail Sale Id 1290234',998.40,0.00,0.00,0.00,74.88,'2021-12-06 17:01:16','',''),(2185781,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 17:01:16','',''),(2185802,'1','147','768',326,'Retail Sale Id 1290248',902.40,0.00,0.00,0.00,67.68,'2021-12-06 17:02:49','',''),(2185803,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-06 17:02:49','',''),(2185814,'1','147','768',326,'Retail Sale Id 1290253',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 17:03:48','',''),(2185815,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 17:03:48','',''),(2185830,'1','147','768',326,'Retail Sale Id 1290263',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 17:04:37','',''),(2185831,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 17:04:37','',''),(2185921,'1','147','768',326,'Retail Sale Id 1290308',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 17:10:42','',''),(2185922,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 17:10:42','',''),(2185951,'1','147','768',326,'Retail Sale Id 1290326',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 17:12:35','',''),(2185952,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 17:12:35','',''),(2185965,'1','147','768',326,'Retail Sale Id 1290333',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 17:13:31','',''),(2185966,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 17:13:31','',''),(2185979,'1','147','768',326,'Retail Sale Id 1290341',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 17:14:38','',''),(2185980,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:14:38','',''),(2185989,'1','147','768',326,'Retail Sale Id 1290346',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 17:15:40','',''),(2185990,'1','147','768',326,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 17:15:40','',''),(2186007,'1','147','768',326,'Retail Sale Id 1290355',2700.80,0.00,0.00,0.00,202.56,'2021-12-06 17:17:06','',''),(2186008,'1','147','768',326,'Retail sales',0.00,0.00,0.00,4.22,0.00,'2021-12-06 17:17:06','',''),(2186031,'1','147','768',326,'Retail Sale Id 1290370',1299.20,0.00,0.00,0.00,97.44,'2021-12-06 17:20:51','',''),(2186032,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 17:20:51','',''),(2186061,'1','147','768',326,'Retail Sale Id 1290382',800.00,0.00,0.00,0.00,60.00,'2021-12-06 17:23:26','',''),(2186062,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-06 17:23:26','',''),(2186074,'1','147','768',326,'Retail Sale Id 1290388',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 17:24:34','',''),(2186075,'1','147','768',326,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:24:34','',''),(2186092,'1','147','768',326,'Retail Sale Id 1290398',3897.60,0.00,0.00,0.00,292.32,'2021-12-06 17:26:10','',''),(2186093,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-06 17:26:10','',''),(2186114,'1','147','768',326,'Retail Sale Id 1290410',652.80,0.00,0.00,0.00,48.96,'2021-12-06 17:27:34','',''),(2186115,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.02,0.00,'2021-12-06 17:27:34','',''),(2186126,'1','147','768',326,'Retail Sale Id 1290418',1600.00,0.00,0.00,0.00,120.00,'2021-12-06 17:28:41','',''),(2186127,'1','147','768',326,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 17:28:41','',''),(2186135,'1','147','768',326,'Retail Sale Id 1290422',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 17:29:51','',''),(2186136,'1','147','768',326,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 17:29:51','',''),(2186184,'1','147','768',326,'Retail Sale Id 1290439',998.40,0.00,0.00,0.00,74.88,'2021-12-06 17:34:53','',''),(2186185,'1','147','768',326,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 17:34:53','',''),(2186207,'1','147','768',326,'Retail Sale Id 1290446',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 17:37:20','',''),(2186208,'1','147','768',326,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 17:37:20','',''),(2186221,'1','147','768',326,'Retail Sale Id 1290453',3500.80,0.00,0.00,0.00,262.56,'2021-12-06 17:38:36','',''),(2186222,'1','147','768',326,'Retail sales',0.00,0.00,0