-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_146
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_146`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_146` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_146`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3365 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2583,20007,'',0,'22','1','146','PURCHASES','','2020-08-10 18:59:19',5,0.00,0.00,'','479','2020-08-10 18:59:19','479',0,1),(2584,400086,'',0,'24','1','146','PURCHASES','','2020-08-10 18:59:35',5,0.00,0.00,'','479','2020-08-10 18:59:35','479',0,1),(2585,20015,'',0,'20','1','146','SALES','','2020-08-10 18:59:51',5,0.00,0.00,'','479','2020-08-10 18:59:51','479',0,1),(2586,40014,'',0,'6.1','1','146','CASH','','2020-08-10 19:00:06',5,0.00,0.00,'','479','2020-08-10 19:00:06','479',0,1),(2587,400087,'',0,'24','1','146','SALARIES & WAGES','','2020-08-10 19:00:26',5,0.00,0.00,'','479','2020-08-10 19:00:26','479',0,1),(2588,400219,'',0,'2','1','146','ZBN(POS):1015965368','','2020-08-10 19:00:42',5,0.00,0.00,'','479','2020-08-10 19:00:42','479',0,1),(2589,400220,'',0,'2','1','146','ZB(E-BILL)1015372548','','2020-08-10 19:00:58',5,0.00,0.00,'','479','2020-08-10 19:00:58','479',0,1),(2655,400106,'',0,'24','1','146','OPERATIONAL LOSS','AA RANO HOUSE HOTORO KANO.','2020-08-13 12:33:46',5,0.00,0.00,'','479','2020-08-13 12:33:46','479',0,1),(2905,400322,'',0,'2','1','146','DANKANO-EBILLS(ZNB:1014717618)','','2020-10-29 13:43:17',5,0.00,0.00,'','489','2020-10-29 13:43:17','489',0,1),(3209,400488,'',0,'2','1','146','FID POS COLLECTION-5620141491','','2021-02-26 16:01:59',5,0.00,0.00,'','489','2021-02-26 16:01:59','489',0,1),(3360,400585,'',0,'2','1','146','Ecobank  Acct No:2583000104','','2021-05-25 10:29:54',5,0.00,0.00,'','487','2021-05-25 10:29:54','487',0,1),(3361,400586,'',0,'2','1','146','UBA LPG COLL ACCT','UBA LPG COLL ACCT_1020811140','2022-11-11 15:08:43',5,0.00,0.00,'','489','2022-11-11 15:08:43','489',0,0),(3362,400587,'',0,'2','1','146','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:22:16',5,0.00,0.00,'','792','2023-02-20 14:22:16','792',0,0),(3363,400588,'',0,'2','1','146','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:25:34',5,0.00,0.00,'','792','2023-02-20 14:25:34','792',0,0),(3364,400589,'',0,'2','1','146','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:30:36',5,0.00,0.00,'2023-03-15','792','2023-03-17 12:36:24','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1606 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1587,'','1','146','END USER','USMAN','08148063533','ussy090@gmail.com','ABUJA','ABUJA','ASOKORO','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-12 09:54:48',5,'502','2020-08-12 09:54:48','502'),(1604,'','1','146','OPERATIONAL LOSS','HAFIZ NURA GAYA','08069129774','hgaya@aaranonigeria.com','KANO','KANO','AA RANO HOUSE HOTORO KANO.','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-08-13 12:32:33',5,'479','2020-08-13 12:32:33','479'),(1605,'','1','146','nanahawawu','female','07087000148','abubakarnana2013@yahoo.com','abuja','kogi','tescon street','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-16 18:26:33',5,'502','2022-10-16 18:26:33','502');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16366 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','146',16363,'767',-1407.49,1172.00,'2021-09-08','new','2021-09-08 18:44:48','483','483',2021,'483','2021-09-08 18:44:48',5),('1','146',16364,'767',15973.14,634.00,'2022-09-07','new','2022-09-07 17:51:28','483','483',2022,'483','2022-09-07 17:51:28',5),('1','146',16365,'767',3557.95,634.00,'2022-09-07','new','2022-09-07 17:59:52','483','483',2022,'483','2022-09-07 17:59:52',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2941 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','146','767',2138,'5','LPG NOZZLE ',2090274.25,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','146','767',2940,'5','LPG NOZZLE 2',277368.41,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258231 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','146',146909,'DAILY SHIFT','2020-08-02','2020-08-02 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-12 10:02:06','502','2020-08-12 10:02:36',10,0),('1','146',146929,'DAILY SHIFT','2020-08-03','2020-08-03 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-12 10:27:54','502','2020-08-12 10:28:39',10,0),('1','146',146935,'DAILY SHIFT','2020-08-04','2020-08-04 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-12 10:47:15','502','2020-08-12 10:48:02',10,0),('1','146',146960,'DAILY SHIFT','2020-08-04','2020-08-04 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-12 11:30:00','502','2020-08-12 11:30:26',10,0),('1','146',146976,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-12 12:10:15','502','2020-08-12 12:10:53',10,0),('1','146',146988,'DAILY SHIFT','2020-08-06','2020-08-06 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-12 12:51:28','502','2020-08-12 12:52:59',10,0),('1','146',147014,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-12 13:47:05','502','2020-08-12 13:47:33',10,0),('1','146',147017,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-12 13:59:07','502','2020-08-12 13:59:37',10,0),('1','146',147035,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-12 14:16:13','502','2020-08-12 16:05:46',10,0),('1','146',147077,'DAILY SHIFT','2020-08-09','2020-08-09 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-12 16:10:36','502','2020-08-12 16:21:08',10,0),('1','146',147083,'DAILY SHIFT','2020-08-10','2020-08-10 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-12 16:26:03','502','2020-08-12 16:26:37',10,0),('1','146',147087,'DAILY SHIFT','2020-08-11','2020-08-11 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-12 16:36:35','502','2020-08-12 16:36:59',10,0),('1','146',147301,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-13 18:04:03','502','2020-08-13 18:04:49',10,0),('1','146',147304,'DAILY SHIFT','2020-08-13','2020-08-13 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-13 18:31:08','502','2020-08-13 18:31:37',10,0),('1','146',147423,'DAILY SHIFT','2020-08-14','2020-08-14 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-14 18:17:41','502','2020-08-14 18:18:08',10,0),('1','146',147528,'DAILY SHIFT','2020-08-15','2020-08-15 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-15 16:28:56','502','2020-08-15 16:29:20',10,0),('1','146',147532,'DAILY SHIFT','2020-08-15','2020-08-15 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-15 21:14:40','502','2020-08-15 21:15:05',10,0),('1','146',147566,'DAILY SHIFT','2020-08-15','2020-08-15 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-15 21:20:58','502','2020-08-15 21:21:18',10,0),('1','146',147667,'DAILY SHIFT','2020-08-16','2020-08-16 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-16 17:50:41','502','2020-08-16 17:51:00',10,0),('1','146',147842,'DAILY SHIFT','2020-08-17','2020-08-17 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-18 17:39:19','502','2020-08-18 17:39:42',10,0),('1','146',147984,'DAILY SHIFT','2020-08-18','2020-08-18 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-19 18:03:36','502','2020-08-19 18:04:14',10,0),('1','146',148112,'DAILY SHIFT','2020-08-19','2020-08-19 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-19 18:07:44','502','2020-08-19 18:08:07',10,0),('1','146',148247,'DAILY SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-21 18:10:24','502','2020-08-21 18:10:46',10,0),('1','146',148411,'DAILY SHIFT','2020-08-21','2020-08-21 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-21 18:22:45','502','2020-08-21 18:23:09',10,0),('1','146',148542,'DAILY SHIFT','2020-08-22','2020-08-22 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-23 20:03:38','502','2020-08-23 20:04:24',10,0),('1','146',148669,'DAILY SHIFT','2020-08-23','2020-08-23 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-23 20:08:25','502','2020-08-23 20:08:45',10,0),('1','146',148797,'DAILY SHIFT','2020-08-24','2020-08-24 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-24 17:45:01','502','2020-08-24 17:45:25',10,0),('1','146',148940,'DAILY SHIFT','2020-08-25','2020-08-25 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-25 17:06:11','502','2020-08-25 17:06:41',10,0),('1','146',149149,'DAILY SHIFT','2020-08-26','2020-08-26 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-26 19:47:41','502','2020-08-26 19:48:01',10,0),('1','146',149293,'DAILY SHIFT','2020-08-27','2020-08-27 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-27 18:22:14','502','2020-08-27 18:22:36',10,0),('1','146',149439,'DAILY SHIFT','2020-08-28','2020-08-28 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-28 18:26:31','502','2020-08-28 18:26:59',10,0),('1','146',149599,'DAILY SHIFT','2020-08-29','2020-08-29 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-29 20:38:35','502','2020-08-29 20:38:53',10,0),('1','146',149695,'DAILY SHIFT','2020-08-30','2020-08-30 00:00:00',NULL,'502',0.00,0.00,'502','2020-08-30 20:06:22','502','2020-08-30 20:06:40',10,0),('1','146',149861,'DAILY SHIFT','2020-08-31','2020-08-31 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-01 20:38:18','502','2020-09-01 20:42:12',10,0),('1','146',150012,'DAILY SHIFT','2020-09-01','2020-09-01 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-01 20:50:03','502','2020-09-01 20:51:50',10,0),('1','146',150164,'DAILY SHIFT','2020-09-02','2020-09-02 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-03 18:07:33','502','2020-09-03 18:07:51',10,0),('1','146',150367,'DAILY SHIFT','2020-09-03','2020-09-03 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-04 12:08:48','502','2020-09-04 12:09:30',10,0),('1','146',150460,'DAILY SHIFT','2020-09-04','2020-09-04 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-04 12:16:44','502','2020-09-04 12:17:56',10,0),('1','146',150542,'DAILY SHIFT','2020-09-04','2020-09-04 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-04 18:32:10','502','2020-09-04 18:32:29',10,0),('1','146',150702,'DAILY SHIFT','2020-09-05','2020-09-05 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-05 18:25:47','502','2020-09-05 18:26:06',10,0),('1','146',150803,'DAILY SHIFT','2020-09-06','2020-09-06 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-06 18:46:30','502','2020-09-06 18:46:51',10,0),('1','146',150839,'DAILY SHIFT','2020-09-06','2020-09-06 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-07 16:42:36','502','2020-09-07 16:42:58',10,0),('1','146',150963,'DAILY SHIFT','2020-09-07','2020-09-07 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-07 16:46:57','502','2020-09-07 16:47:19',10,0),('1','146',150974,'DAILY SHIFT','2020-09-07','2020-09-07 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-07 17:48:25','502','2020-09-07 17:48:44',10,0),('1','146',151135,'DAILY SHIFT','2020-09-08','2020-09-08 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-08 18:08:40','502','2020-09-08 18:08:59',10,0),('1','146',151283,'DAILY SHIFT','2020-09-09','2020-09-09 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-09 19:50:53','502','2020-09-09 19:51:13',10,0),('1','146',151417,'DAILY SHIFT','2020-09-10','2020-09-10 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-10 18:13:46','502','2020-09-10 18:14:03',10,0),('1','146',151591,'DAILY SHIFT','2020-09-11','2020-09-11 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-11 20:25:36','502','2020-09-11 20:25:57',10,0),('1','146',151679,'DAILY SHIFT','2020-09-12','2020-09-12 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-12 15:55:21','502','2020-09-12 15:56:52',10,0),('1','146',151705,'DAILY SHIFT','2020-09-12','2020-09-12 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-12 20:36:31','502','2020-09-12 20:36:50',10,0),('1','146',151807,'DAILY SHIFT ','2020-09-13','2020-09-13 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-13 17:54:50','502','2020-09-13 17:55:18',10,0),('1','146',151997,'DAILY SHIFT ','2020-09-14','2020-09-14 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-14 18:23:51','502','2020-09-14 18:24:14',10,0),('1','146',152162,'DAILY SHIFT ','2020-09-15','2020-09-15 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-15 19:32:15','502','2020-09-15 19:33:04',10,0),('1','146',152164,'DAILY SHIFT ','2020-09-15','2020-09-15 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-15 20:41:19','502','2020-09-15 20:42:08',10,0),('1','146',152319,'DAILY SHIFT','2020-09-16','2020-09-16 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-16 18:29:59','502','2020-09-16 18:30:24',10,0),('1','146',152461,'DAILY SHIFT','2020-09-17','2020-09-17 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-17 18:28:57','502','2020-09-17 18:29:38',10,0),('1','146',152610,'DAILY SHIFT ','2020-09-18','2020-09-18 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-18 19:16:11','502','2020-09-18 19:16:36',10,0),('1','146',152613,'DAILY SHIFT ','2020-09-18','2020-09-18 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-18 21:19:27','502','2020-09-18 21:20:28',10,0),('1','146',152749,'DAILY SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-19 18:04:43','502','2020-09-19 18:05:08',10,0),('1','146',152888,'DAILY SHIFT','2020-09-20','2020-09-20 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-20 18:39:35','502','2020-09-20 18:39:59',10,0),('1','146',153070,'DAILY SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-21 18:00:22','502','2020-09-21 18:01:42',10,0),('1','146',153256,'DAILY SHIFT','2020-09-22','2020-09-22 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-22 18:14:18','502','2020-09-22 18:15:22',10,0),('1','146',153474,'DAILY SHIFT ','2020-09-23','2020-09-23 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-24 17:33:37','502','2020-09-24 17:33:57',10,0),('1','146',153626,'DAILY SHIFT','2020-09-24','2020-09-24 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-24 17:37:26','502','2020-09-24 17:37:56',10,0),('1','146',153803,'DAILY SHIFT ','2020-09-25','2020-09-25 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-25 20:33:17','502','2020-09-25 20:33:43',10,0),('1','146',153917,'DAILY SHIFT','2020-09-26','2020-09-26 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-26 18:39:12','502','2020-09-26 18:39:35',10,0),('1','146',154057,'DAILY SHIFT ','2020-09-27','2020-09-27 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-27 20:25:00','502','2020-09-27 20:25:37',10,0),('1','146',154242,'DAILY SHIFT','2020-09-28','2020-09-28 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-28 19:35:55','502','2020-09-28 19:36:15',10,0),('1','146',154244,'DAILY SHIFT','2020-09-28','2020-09-28 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-29 15:57:42','502','2020-09-29 15:58:02',10,0),('1','146',154376,'DAILY SHIFT','2020-09-29','2020-09-29 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-29 16:01:12','502','2020-09-29 16:01:35',10,0),('1','146',154590,'DAILY SHIFT ','2020-09-30','2020-09-30 00:00:00',NULL,'502',0.00,0.00,'502','2020-09-30 22:08:58','502','2020-09-30 22:09:27',10,0),('1','146',154727,'DAILY SHIFT ','2020-10-01','2020-10-01 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-01 21:59:55','502','2020-10-01 22:00:23',10,0),('1','146',154873,'DAILY SHIFT ','2020-10-02','2020-10-02 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-02 21:19:21','502','2020-10-02 21:19:41',10,0),('1','146',154882,'DAILY SHIFT ','2020-10-02','2020-10-02 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-02 21:28:20','502','2020-10-02 21:28:40',10,0),('1','146',155012,'DAILY SHIFT ','2020-10-03','2020-10-03 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-03 18:54:37','502','2020-10-03 18:55:24',10,0),('1','146',155125,'DAILY SHIFT ','2020-10-04','2020-10-04 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-04 18:24:57','502','2020-10-04 18:25:28',10,0),('1','146',155305,'DAILY SHIFT ','2020-10-05','2020-10-05 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-05 21:04:33','502','2020-10-05 21:05:06',10,0),('1','146',155455,'DAILY SHIFT ','2020-10-06','2020-10-06 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-06 19:32:13','502','2020-10-06 19:32:48',10,0),('1','146',155646,'DAILY SHIFT ','2020-10-07','2020-10-07 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-07 20:44:56','502','2020-10-07 20:45:25',10,0),('1','146',155773,'DAILY SHIFT ','2020-10-08','2020-10-08 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-08 18:53:45','502','2020-10-08 18:54:12',10,0),('1','146',155909,'DAILY SHIFT ','2020-10-09','2020-10-09 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-09 19:33:22','502','2020-10-09 19:33:47',10,0),('1','146',155932,'DAILY SHIFT ','2020-10-09','2020-10-09 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-09 22:42:09','502','2020-10-09 22:45:09',10,0),('1','146',156081,'DAILY SHIFT ','2020-10-10','2020-10-10 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-10 19:38:41','502','2020-10-10 19:39:14',10,0),('1','146',156204,'DAILY SHIFT ','2020-10-11','2020-10-11 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-12 14:51:37','502','2020-10-12 14:51:57',10,0),('1','146',156364,'DAILY SHIFT ','2020-10-12','2020-10-12 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-12 15:09:54','502','2020-10-12 15:10:49',10,0),('1','146',156423,'DAILY SHIFT ','2020-10-12','2020-10-12 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-12 20:20:07','502','2020-10-12 20:20:31',10,0),('1','146',156567,'DAILY SHIFT ','2020-10-13','2020-10-13 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-13 18:41:27','502','2020-10-13 18:42:08',10,0),('1','146',156731,'DAILY SHIFT ','2020-10-14','2020-10-14 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-15 11:37:31','502','2020-10-15 11:37:55',10,0),('1','146',156797,'DAILY SHIFT ','2020-10-15','2020-10-15 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-15 11:42:31','502','2020-10-15 11:43:07',10,0),('1','146',156910,'DAILY SHIFT ','2020-10-15','2020-10-15 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-16 15:10:20','502','2020-10-16 15:10:43',10,0),('1','146',157032,'DAILY SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-16 20:45:33','502','2020-10-16 20:45:51',10,0),('1','146',157086,'DAILY SHIFT ','2020-10-16','2020-10-16 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-16 20:53:46','502','2020-10-16 20:54:09',10,0),('1','146',157190,'DAILY SHIFT','2020-10-17','2020-10-17 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-17 21:35:01','502','2020-10-17 21:35:23',10,0),('1','146',157284,'DAILY SHIFT ','2020-10-17','2020-10-17 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-17 21:42:14','502','2020-10-17 21:42:37',10,0),('1','146',157440,'DAILY SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-18 20:56:28','502','2020-10-18 20:57:05',10,0),('1','146',157658,'DAILY SHIFT ','2020-10-19','2020-10-19 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-20 17:42:47','502','2020-10-20 17:43:28',10,0),('1','146',157803,'DAILY SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-21 20:45:33','502','2020-10-21 20:45:59',10,0),('1','146',157952,'DAILY SHIFT ','2020-10-21','2020-10-21 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-22 20:42:16','502','2020-10-22 20:43:00',10,0),('1','146',158088,'DAILY SHIFT ','2020-10-22','2020-10-22 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-22 20:51:12','502','2020-10-22 20:51:39',10,0),('1','146',158261,'DAILY SHIFT ','2020-10-23','2020-10-23 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-24 21:30:47','502','2020-10-24 21:31:09',10,0),('1','146',158425,'DAILY SHIFT ','2020-10-24','2020-10-24 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-24 21:39:08','502','2020-10-24 21:39:39',10,0),('1','146',158577,'DAILY SHIFT ','2020-10-25','2020-10-25 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-25 19:20:50','502','2020-10-25 19:21:17',10,0),('1','146',158700,'DAILY SHIFT ','2020-10-26','2020-10-26 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-26 21:27:18','502','2020-10-26 21:27:51',10,0),('1','146',158938,'DAILY SHIFT ','2020-10-27','2020-10-27 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-27 20:57:28','502','2020-10-27 20:57:47',10,0),('1','146',158939,'DAILY SHIFT ','2020-10-27','2020-10-27 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-27 21:04:10','502','2020-10-27 21:04:45',10,0),('1','146',159122,'DAILY SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-28 21:26:59','502','2020-10-28 21:27:20',10,0),('1','146',159273,'DAILY SHIFT ','2020-10-29','2020-10-29 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-29 19:29:15','502','2020-10-29 19:29:53',10,0),('1','146',159276,'DAILY SHIFT ','2020-10-29','2020-10-29 00:00:00',NULL,'502',0.00,0.00,'502','2020-10-29 19:50:56','502','2020-10-29 19:51:22',10,0),('1','146',159459,'DAILY SHIFT ','2020-10-30','2020-10-30 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-02 07:06:42','502','2020-11-02 07:07:30',10,0),('1','146',159751,'DAILY SHIFT ','2020-10-31','2020-10-31 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-02 07:54:58','502','2020-11-02 07:55:36',10,0),('1','146',159759,'DAILY SHIFT ','2020-10-31','2020-10-31 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-02 08:10:31','502','2020-11-02 08:10:57',10,0),('1','146',159763,'DAILY SHIFT ','2020-11-01','2020-11-01 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-02 20:22:25','502','2020-11-02 20:22:57',10,0),('1','146',159950,'DAILY SHIFT ','2020-11-02','2020-11-02 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-02 20:33:48','502','2020-11-02 20:34:06',10,0),('1','146',159952,'DAILY SHIFT ','2020-11-02','2020-11-02 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-03 21:20:01','502','2020-11-03 21:20:20',10,0),('1','146',160133,'DAILY SHIFT ','2020-11-03','2020-11-03 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-03 21:27:01','502','2020-11-03 21:27:31',10,0),('1','146',160295,'DAILY SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-04 18:10:22','502','2020-11-04 18:10:42',10,0),('1','146',160306,'DAILY SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-05 18:06:15','502','2020-11-05 18:06:34',10,0),('1','146',160451,'DAILY SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-05 18:10:45','502','2020-11-05 18:11:49',10,0),('1','146',160582,'DAILY SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-06 18:19:22','502','2020-11-06 18:19:39',10,0),('1','146',160591,'DAILY SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-06 18:34:55','502','2020-11-06 18:36:19',10,0),('1','146',160737,'DAILY SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-07 18:19:58','502','2020-11-07 18:20:17',10,0),('1','146',160895,'DAILY SHIFT ','2020-11-08','2020-11-08 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-08 20:22:15','502','2020-11-08 20:22:37',10,0),('1','146',160897,'DAILY SHIFT ','2020-11-08','2020-11-08 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-08 20:31:56','502','2020-11-08 20:32:30',10,0),('1','146',161085,'DAILY SHIFT','2020-11-09','2020-11-09 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-09 18:11:28','502','2020-11-09 18:11:46',10,0),('1','146',161241,'DAILY SHIFT','2020-11-10','2020-11-10 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-10 18:31:31','502','2020-11-10 18:32:30',10,0),('1','146',161266,'DAILY SHIFT','2020-11-10','2020-11-10 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-10 18:35:27','502','2020-11-10 18:35:45',10,0),('1','146',161454,'DAILY SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-11 18:12:04','502','2020-11-11 18:12:24',10,0),('1','146',161651,'DAILY SHIFT51519','2020-11-12','2020-11-12 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-12 17:55:51','502','2020-11-12 17:56:11',10,0),('1','146',161888,'DAILY SHIFT ','2020-11-13','2020-11-13 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-13 22:00:57','502','2020-11-13 22:01:17',10,0),('1','146',162047,'DAILY SHIFT ','2020-11-14','2020-11-14 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-14 20:45:54','502','2020-11-14 20:46:13',10,0),('1','146',162211,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-15 16:45:15','502','2020-11-15 16:45:36',10,0),('1','146',162246,'DAILY SHIFT ','2020-11-15','2020-11-15 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-15 20:54:03','502','2020-11-15 20:54:27',10,0),('1','146',162466,'DAILY SHIFT ','2020-11-16','2020-11-16 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-17 18:18:32','502','2020-11-17 18:19:03',10,0),('1','146',162640,'DAILY SHIFT ','2020-11-17','2020-11-17 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-17 18:32:16','502','2020-11-17 18:32:41',10,0),('1','146',162830,'DAILY SHIFT ','2020-11-18','2020-11-18 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-18 21:31:18','502','2020-11-18 21:31:34',10,0),('1','146',163001,'DAILY SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-20 11:51:52','502','2020-11-20 11:52:10',10,0),('1','146',163097,'DAILY SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-20 11:59:44','502','2020-11-20 12:00:01',10,0),('1','146',163213,'DAILY SHIFT ','2020-11-20','2020-11-20 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-20 20:18:20','502','2020-11-20 20:18:42',10,0),('1','146',163368,'DAILY SHIFT','2020-11-21','2020-11-21 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-21 18:14:02','502','2020-11-21 18:14:25',10,0),('1','146',163537,'DAILY SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-22 17:52:23','502','2020-11-22 17:52:47',10,0),('1','146',163583,'DAILY SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-23 08:37:13','502','2020-11-23 08:38:51',10,0),('1','146',163732,'DAILY SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-24 07:19:58','502','2020-11-24 07:20:25',10,0),('1','146',163893,'DAILY SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-25 15:50:22','502','2020-11-25 15:50:37',10,0),('1','146',164054,'DAILY SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-26 11:35:36','502','2020-11-26 11:36:17',10,0),('1','146',164251,'DAILY SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-26 17:41:09','502','2020-11-26 17:41:29',10,0),('1','146',164432,'DAILY SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-27 18:11:54','502','2020-11-27 18:12:13',10,0),('1','146',164435,'DAILY SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-27 18:26:54','502','2020-11-27 18:27:11',10,0),('1','146',164642,'DAILY SHIFT','2020-11-28','2020-11-28 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-29 09:36:04','502','2020-11-29 09:37:31',10,0),('1','146',164743,'DAILY SHIFT','2020-11-29','2020-11-29 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-29 17:48:25','502','2020-11-29 17:48:53',10,0),('1','146',164747,'DAILY SHIFT','2020-11-29','2020-11-29 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-29 18:02:37','502','2020-11-29 18:03:10',10,0),('1','146',164956,'DAILY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'502',0.00,0.00,'502','2020-11-30 18:08:47','502','2020-11-30 18:09:03',10,0),('1','146',165036,'DAILY SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-01 17:49:57','502','2020-12-01 17:50:16',10,0),('1','146',165122,'DAILY SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-01 18:01:20','502','2020-12-01 18:01:37',10,0),('1','146',165284,'DAILY SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-02 17:47:26','502','2020-12-02 17:48:48',10,0),('1','146',165472,'DAILY SHIFT','2020-12-03','2020-12-03 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-04 07:53:41','502','2020-12-04 07:54:37',10,0),('1','146',165601,'DAILY SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-04 17:52:29','502','2020-12-04 17:53:40',10,0),('1','146',165783,'DAILY SHIFT','2020-12-05','2020-12-05 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-05 17:28:31','502','2020-12-05 17:28:58',10,0),('1','146',165934,'DAILY SHIFT ','2020-12-05','2020-12-05 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-07 10:14:31','502','2020-12-07 10:16:34',10,0),('1','146',166018,'DAILY SHIFT','2020-12-06','2020-12-06 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-07 10:28:43','502','2020-12-07 10:29:10',10,0),('1','146',166166,'DAILY SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-08 08:06:27','502','2020-12-08 08:07:18',10,0),('1','146',166171,'DAILY SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-08 08:18:35','502','2020-12-08 08:19:30',10,0),('1','146',166359,'DAILY SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-09 09:12:03','502','2020-12-09 09:12:20',10,0),('1','146',166467,'DAILY SHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-09 17:36:12','502','2020-12-09 17:37:22',10,0),('1','146',166690,'DAILY SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-10 18:17:40','502','2020-12-10 18:18:01',10,0),('1','146',166692,'DAILY SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-10 18:25:15','502','2020-12-10 18:25:34',10,0),('1','146',166870,'DAILY SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-11 17:54:44','502','2020-12-11 17:55:21',10,0),('1','146',167203,'DAILY SHIFT ','2020-12-12','2020-12-12 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-14 07:39:36','502','2020-12-14 07:40:12',10,0),('1','146',167206,'DAILY SHIFT ','2020-12-12','2020-12-12 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-14 08:16:46','502','2020-12-14 08:17:32',10,0),('1','146',167210,'DAILY SHIFT ','2020-12-13','2020-12-13 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-14 08:41:37','502','2020-12-14 08:41:52',10,0),('1','146',167366,'DAILY SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-14 18:22:02','502','2020-12-14 18:23:29',10,0),('1','146',167371,'DAILY SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-14 18:32:26','502','2020-12-14 18:32:51',10,0),('1','146',167564,'DAILY SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-15 18:07:55','502','2020-12-15 18:08:13',10,0),('1','146',167774,'DAILY SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-17 08:54:49','502','2020-12-17 08:55:04',10,0),('1','146',167779,'DAILY SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-17 09:04:58','502','2020-12-17 09:05:15',10,0),('1','146',167904,'DAILY SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-17 17:59:04','502','2020-12-17 17:59:24',10,0),('1','146',168098,'DAILY SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-18 17:46:53','502','2020-12-18 17:47:14',10,0),('1','146',168162,'DAILY SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-19 09:27:20','502','2020-12-19 09:27:43',10,0),('1','146',168393,'DAILY SHIFT','2020-12-19','2020-12-19 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-20 16:53:09','502','2020-12-20 16:54:06',10,0),('1','146',168491,'DAILY SHIFT','2020-12-20','2020-12-20 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-21 10:30:00','502','2020-12-21 10:30:18',10,0),('1','146',168594,'DAILY SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-21 17:39:34','502','2020-12-21 17:40:19',10,0),('1','146',168770,'DAILY SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-22 18:34:32','502','2020-12-22 18:35:17',10,0),('1','146',168771,'DAILY SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-23 08:11:50','502','2020-12-23 08:12:43',10,0),('1','146',168928,'DAILY SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-23 18:12:43','502','2020-12-23 18:13:15',10,0),('1','146',169092,'DAILY SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-24 18:22:31','502','2020-12-24 18:23:57',10,0),('1','146',169095,'DAILY SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-24 19:13:20','502','2020-12-24 19:13:44',10,0),('1','146',169266,'Daily shift','2020-12-25','2020-12-25 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-27 23:19:10','502','2020-12-27 23:19:37',10,0),('1','146',169595,'Daily shift','2020-12-25','2020-12-25 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-28 08:00:44','502','2020-12-28 08:00:58',10,0),('1','146',169597,'Daily shift','2020-12-26','2020-12-26 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-28 08:03:56','502','2020-12-28 08:04:08',10,0),('1','146',169598,'Daily shift','2020-12-27','2020-12-27 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-28 08:07:47','502','2020-12-28 08:08:00',10,0),('1','146',169808,'DAILY SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-29 09:14:49','502','2020-12-29 09:15:06',10,0),('1','146',169918,'DAILY SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-29 18:09:33','502','2020-12-29 18:10:30',10,0),('1','146',170119,'DAILY SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-30 17:54:08','502','2020-12-30 17:55:03',10,0),('1','146',170123,'DAILY SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-30 18:03:20','502','2020-12-30 18:03:37',10,0),('1','146',170320,'DAILY SHIFT','2020-12-31','2020-12-31 00:00:00',NULL,'502',0.00,0.00,'502','2020-12-31 18:03:02','502','2020-12-31 18:03:16',10,0),('1','146',170540,'DAILY SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-02 10:05:57','502','2021-01-02 10:06:17',10,0),('1','146',170541,'DAILY SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-02 10:14:53','502','2021-01-02 10:15:18',10,0),('1','146',170808,'DAILY SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-03 18:00:27','502','2021-01-03 18:00:49',10,0),('1','146',170809,'DAILY SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-03 18:06:15','502','2021-01-03 18:06:44',10,0),('1','146',170877,'DAILY SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-04 11:17:31','502','2021-01-04 11:17:50',10,0),('1','146',171078,'DAILY SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-05 10:49:52','502','2021-01-05 10:50:16',10,0),('1','146',171205,'DAILY SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-05 18:57:03','502','2021-01-05 18:57:20',10,0),('1','146',171235,'DAILY SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-06 08:23:48','502','2021-01-06 08:24:20',10,0),('1','146',171365,'DAILY SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-06 18:21:43','502','2021-01-06 18:26:26',10,0),('1','146',171616,'DAILY SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-08 09:12:02','502','2021-01-08 09:12:19',10,0),('1','146',171618,'DAILY SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-08 18:04:11','502','2021-01-08 18:04:57',10,0),('1','146',171817,'DAILY SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-09 09:23:26','502','2021-01-09 09:23:39',10,0),('1','146',171820,'DAILY SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-09 19:24:10','502','2021-01-09 19:24:26',10,0),('1','146',172459,'DAILY SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-12 16:55:02','502','2021-01-12 16:55:26',10,0),('1','146',172461,'DAILY SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-12 17:09:58','502','2021-01-12 17:10:24',10,0),('1','146',172570,'DAILY SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-13 09:57:41','502','2021-01-13 10:01:58',10,0),('1','146',172574,'DAILY SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-13 10:07:11','502','2021-01-13 11:27:22',10,0),('1','146',172596,'DAILY SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-13 11:30:40','502','2021-01-13 15:19:42',10,0),('1','146',172656,'DAILY SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-13 15:56:49','502','2021-01-13 15:57:03',10,0),('1','146',172669,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-13 16:14:05','502','2021-01-13 16:14:26',10,0),('1','146',172672,'DAILY SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-13 16:19:29','502','2021-01-13 16:19:49',10,0),('1','146',172792,'DAILY SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-14 13:04:45','502','2021-01-14 13:05:26',10,0),('1','146',172794,'DAILY SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-14 13:12:49','502','2021-01-15 09:50:59',10,0),('1','146',172914,'DAILY SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-15 09:55:25','502','2021-01-15 09:55:44',10,0),('1','146',172924,'DAILY SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-15 10:14:14','502','2021-01-15 10:14:30',10,0),('1','146',173041,'DAILY SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-15 18:10:26','502','2021-01-15 18:10:44',10,0),('1','146',173184,'DAILY SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-16 17:15:23','502','2021-01-16 17:15:41',10,0),('1','146',173198,'DAILY SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-16 17:59:45','502','2021-01-16 18:00:01',10,0),('1','146',173422,'DAILY SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-18 08:31:18','502','2021-01-18 08:31:34',10,0),('1','146',173486,'DAILY SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-18 12:00:52','502','2021-01-18 12:01:09',10,0),('1','146',173580,'DAILY SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-18 18:17:30','502','2021-01-18 18:17:46',10,0),('1','146',173850,'DAILY SHIFT','2021-01-19','2021-01-19 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-20 13:20:04','502','2021-01-20 13:20:38',10,0),('1','146',173891,'DAILY SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-20 14:25:22','502','2021-01-20 14:25:42',10,0),('1','146',173929,'DAILY SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-20 18:15:22','502','2021-01-20 18:15:49',10,0),('1','146',174190,'DAILY SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-22 10:52:23','502','2021-01-22 10:52:42',10,0),('1','146',174463,'DAILY SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-24 16:55:42','502','2021-01-24 16:56:05',10,0),('1','146',174605,'DAILY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-24 17:04:30','502','2021-01-24 17:05:56',10,0),('1','146',174607,'DAILY SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-24 17:11:22','502','2021-01-24 17:11:39',10,0),('1','146',174828,'DAILY SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-25 18:07:02','502','2021-01-25 18:07:23',10,0),('1','146',175014,'DAILY SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-26 17:09:53','502','2021-01-26 17:10:09',10,0),('1','146',175222,'DAILY SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-27 18:14:51','502','2021-01-27 18:15:10',10,0),('1','146',175483,'DAILY SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-29 10:40:45','502','2021-01-29 10:41:00',10,0),('1','146',175585,'DAILY SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-29 18:34:05','502','2021-01-29 18:34:23',10,0),('1','146',175892,'DAILY SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'502',0.00,0.00,'502','2021-01-31 16:27:23','502','2021-02-01 09:00:59',10,0),('1','146',175952,'DAILY SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-01 09:10:10','502','2021-02-01 09:10:25',10,0),('1','146',176127,'DAILY SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-02 18:39:09','502','2021-02-02 18:39:36',10,0),('1','146',176311,'DAILY SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-02 18:43:39','502','2021-02-02 18:43:59',10,0),('1','146',176525,'DAILY SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-03 18:25:38','502','2021-02-03 18:25:57',10,0),('1','146',176732,'DAILY SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-04 17:00:57','502','2021-02-04 17:01:15',10,0),('1','146',176753,'DAILY SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-04 18:35:07','502','2021-02-04 18:35:23',10,0),('1','146',176955,'DAILY SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-05 18:23:50','502','2021-02-05 18:24:06',10,0),('1','146',176968,'DAILY SHIFT51519','2021-02-05','2021-02-05 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-05 19:16:58','502','2021-02-05 19:17:25',10,0),('1','146',177190,'DAILY SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-06 17:18:11','502','2021-02-06 17:18:25',10,0),('1','146',177574,'DAILY SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-08 15:25:28','502','2021-02-08 15:25:42',10,0),('1','146',177661,'DAILY SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-09 08:46:09','502','2021-02-09 08:46:23',10,0),('1','146',177855,'DAILY SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-09 18:09:00','502','2021-02-09 18:09:18',10,0),('1','146',178099,'DAILY SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-11 08:50:42','502','2021-02-11 08:50:58',10,0),('1','146',178271,'DAILY SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-11 18:38:19','502','2021-02-11 18:38:42',10,0),('1','146',178470,'DAILY SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-12 18:48:29','502','2021-02-12 18:48:45',10,0),('1','146',178938,'DAILY SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-15 08:56:51','502','2021-02-15 08:57:07',10,0),('1','146',178942,'DAILY SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-15 12:04:31','502','2021-02-15 12:04:51',10,0),('1','146',179009,'DAILY SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-15 12:08:31','502','2021-02-15 12:08:50',10,0),('1','146',179011,'DAILY SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-15 18:27:21','502','2021-02-15 18:27:42',10,0),('1','146',179147,'DAILY SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-16 08:15:28','502','2021-02-16 08:15:47',10,0),('1','146',179186,'DAILY SHIFT 2ND SDALES','2021-02-16','2021-02-16 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-16 18:24:32','502','2021-02-16 18:24:52',10,0),('1','146',179373,'DAILY SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-17 16:45:25','502','2021-02-17 16:45:40',10,0),('1','146',180108,'DAILY SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-21 17:48:49','502','2021-02-21 17:49:05',10,0),('1','146',180302,'DAILY SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-21 17:53:16','502','2021-02-21 17:53:33',10,0),('1','146',180501,'DAILY SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-23 06:53:48','502','2021-02-23 06:54:03',10,0),('1','146',180552,'DAILY SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-23 18:35:42','502','2021-02-23 19:28:47',10,0),('1','146',180742,'DAILY Shift FIRST SALE','2021-02-24','2021-02-24 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-24 09:56:45','502','2021-02-24 09:57:07',10,0),('1','146',180789,'DAILY SHIFT 2ND SDALES','2021-02-24','2021-02-24 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-24 18:20:31','502','2021-02-24 18:20:52',10,0),('1','146',180987,'DAILY SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-25 18:42:34','502','2021-02-25 18:42:52',10,0),('1','146',181141,'DAILY SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-26 13:15:25','502','2021-02-26 13:16:49',10,0),('1','146',181240,'DAILY SHIFT 2ND SALES','2021-02-26','2021-02-26 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-26 18:19:24','502','2021-02-26 18:19:41',10,0),('1','146',181331,'DAILY SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-02-27 18:14:39','502','2021-02-27 18:15:01',10,0),('1','146',181518,'DAILY SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-01 09:35:18','502','2021-03-01 09:37:28',10,0),('1','146',181744,'DAILY SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-01 18:44:32','502','2021-03-01 18:46:19',10,0),('1','146',181899,'DAILY SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-02 19:38:13','502','2021-03-02 19:38:36',10,0),('1','146',182116,'DAILY Shift FIRST SALE','2021-03-03','2021-03-03 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-03 08:25:30','502','2021-03-03 08:25:46',10,0),('1','146',182164,'DAILY SHIFT 2ND SDALES','2021-03-03','2021-03-03 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-03 18:43:07','502','2021-03-03 18:43:27',10,0),('1','146',182298,'DAILY SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-04 18:40:05','502','2021-03-04 18:40:22',10,0),('1','146',182510,'DAILY SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-05 18:51:21','502','2021-03-05 18:51:38',10,0),('1','146',182673,'DAILY SHIFT 2ND SDALES','2021-03-05','2021-03-05 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-05 18:56:42','502','2021-03-05 18:57:06',10,0),('1','146',182686,'DAILY SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-06 18:53:46','502','2021-03-06 18:54:08',10,0),('1','146',182958,'DAILY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-07 17:19:33','502','2021-03-07 17:20:06',10,0),('1','146',183092,'DAILY SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-08 18:25:52','502','2021-03-08 18:26:10',10,0),('1','146',183239,'DAILY SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-09 20:57:20','502','2021-03-09 20:57:39',10,0),('1','146',183432,'DAILY SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-10 22:30:44','502','2021-03-10 22:33:55',10,0),('1','146',183634,'DAILY SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-12 06:52:35','502','2021-03-12 06:52:53',10,0),('1','146',183892,'DAILY Shift FIRST SALE','2021-03-12','2021-03-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-12 10:20:07','502','2021-03-12 13:07:59',10,0),('1','146',183997,'DAILY SALES ','2021-03-12','2021-03-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-12 22:32:07','502','2021-03-12 22:32:22',10,0),('1','146',184072,'DAILY SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-14 05:01:52','502','2021-03-14 05:02:07',10,0),('1','146',184257,'DAILY Shift FIRST SALE','2021-03-14','2021-03-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-14 15:14:23','502','2021-03-14 15:14:41',10,0),('1','146',184398,'DAILY SHIFT 2ND SALES','2021-03-14','2021-03-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-14 22:59:50','502','2021-03-14 23:00:06',10,0),('1','146',184470,'DAILY SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-16 05:29:38','502','2021-03-16 05:29:54',10,0),('1','146',184674,'DAILY SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-16 15:45:04','502','2021-03-16 15:47:31',10,0),('1','146',184830,'DAILY SHIFT 2ND SALES','2021-03-16','2021-03-16 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-16 20:04:58','502','2021-03-16 20:05:16',10,0),('1','146',184867,'DAILY SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-17 22:26:34','502','2021-03-17 22:27:10',10,0),('1','146',185129,'DAILY SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-18 18:38:50','502','2021-03-18 18:39:16',10,0),('1','146',185299,'DAILY SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-20 09:14:34','502','2021-03-20 09:14:54',10,0),('1','146',185503,'DAILY SHIFT 2ND SALES','2021-03-19','2021-03-19 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-20 09:23:20','502','2021-03-20 09:23:36',10,0),('1','146',185506,'DAILY SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-21 02:07:47','502','2021-03-21 02:08:12',10,0),('1','146',185934,'DAILY SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-22 17:42:48','502','2021-03-22 17:43:19',10,0),('1','146',186147,'DAILY SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-24 07:53:12','502','2021-03-24 08:05:47',10,0),('1','146',186342,'DAILY SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-24 18:51:14','502','2021-03-24 18:51:59',10,0),('1','146',186540,'DAILY SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-25 14:35:08','502','2021-03-25 14:35:42',10,0),('1','146',186699,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-03-25','2021-03-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-25 20:04:09','502','2021-03-25 20:04:36',10,0),('1','146',186766,'DAILY SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-27 07:11:06','502','2021-03-27 07:11:53',10,0),('1','146',186989,'DAILY SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-28 08:20:26','502','2021-03-28 08:21:15',10,0),('1','146',187246,'DAILY SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-28 18:36:40','502','2021-03-28 18:37:13',10,0),('1','146',187427,'DAILY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-29 19:47:15','502','2021-03-29 19:47:51',10,0),('1','146',187582,'DAILY SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-30 13:09:27','502','2021-03-30 13:10:27',10,0),('1','146',187706,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-03-30','2021-03-30 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-30 19:15:47','502','2021-03-30 19:16:30',10,0),('1','146',187810,'DAILY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'502',0.00,0.00,'502','2021-03-31 18:51:55','502','2021-03-31 18:53:32',10,0),('1','146',188016,'DAILY SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-01 15:32:46','502','2021-04-01 15:33:38',10,0),('1','146',188147,'DAILY SHIFT 2ND SDALES NEW STOCK','2021-04-01','2021-04-01 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-02 06:37:30','502','2021-04-02 06:39:01',10,0),('1','146',188217,'DAILY SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-02 19:02:10','502','2021-04-02 19:07:49',10,0),('1','146',188449,'DAILY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-03 19:48:42','502','2021-04-03 19:49:28',10,0),('1','146',188610,'DAILY SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-04 19:17:06','502','2021-04-04 19:19:50',10,0),('1','146',188811,'DAILY SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-05 19:13:12','502','2021-04-05 19:13:52',10,0),('1','146',189046,'DAILY SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-06 18:32:18','502','2021-04-06 18:32:54',10,0),('1','146',189203,'DAILY SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-07 19:06:44','502','2021-04-07 19:07:41',10,0),('1','146',189422,'DAILY SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-08 13:24:50','502','2021-04-08 13:25:59',10,0),('1','146',189535,'DAILY SHIFT 2ND SDALES','2021-04-08','2021-04-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-08 19:40:33','502','2021-04-08 19:41:14',10,0),('1','146',189621,'DAILY SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-09 19:02:18','502','2021-04-09 19:03:00',10,0),('1','146',189815,'DAILY SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-10 16:26:17','502','2021-04-10 16:27:03',10,0),('1','146',189967,'DAILY SHIFT 2ND SDALES24','2021-04-10','2021-04-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-10 18:29:23','502','2021-04-10 18:29:54',10,0),('1','146',190031,'DAILY SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-11 18:21:11','502','2021-04-11 18:21:43',10,0),('1','146',190221,'DAILY SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-12 19:52:40','502','2021-04-12 19:53:10',10,0),('1','146',190464,'DAILY SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-13 10:26:02','502','2021-04-13 10:26:33',10,0),('1','146',190510,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-04-13','2021-04-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-13 19:04:16','502','2021-04-13 19:04:53',10,0),('1','146',190672,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-14 18:00:51','502','2021-04-14 18:01:33',10,0),('1','146',190986,'DAILY SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-15 12:56:24','502','2021-04-15 12:56:49',10,0),('1','146',190991,'DAILY SHIFT 2ND SDALES','2021-04-15','2021-04-15 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-16 05:49:58','502','2021-04-16 05:50:53',10,0),('1','146',191076,'DAILY SALES','2021-04-16','2021-04-16 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-17 08:36:38','502','2021-04-17 08:37:15',10,0),('1','146',191324,'DAILY SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-17 18:04:57','502','2021-04-17 18:05:26',10,0),('1','146',191498,'DAILY SALES','2021-04-18','2021-04-18 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-19 06:52:35','502','2021-04-19 06:52:59',10,0),('1','146',191724,'DAILY SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-20 09:23:55','502','2021-04-20 09:24:59',10,0),('1','146',191991,'DAILY SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-20 19:44:45','502','2021-04-20 19:45:50',10,0),('1','146',192129,'DAILY SALES','2021-04-21','2021-04-21 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-22 06:19:54','502','2021-04-22 06:20:58',10,0),('1','146',192336,'DAILY SALES','2021-04-22','2021-04-22 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-23 06:07:29','502','2021-04-23 06:08:14',10,0),('1','146',192560,'DAILY SALES NEW STOCK','2021-04-23','2021-04-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-24 06:10:28','502','2021-04-24 06:11:11',10,0),('1','146',192756,'DAILY SALES','2021-04-24','2021-04-24 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-25 06:18:00','502','2021-04-25 06:18:28',10,0),('1','146',192959,'DAILY SHIFT NEW STOCK','2021-04-25','2021-04-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-25 22:36:53','502','2021-04-25 22:37:27',10,0),('1','146',193163,'DAILY SALES','2021-04-26','2021-04-26 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-27 05:58:32','502','2021-04-27 05:59:28',10,0),('1','146',193404,'DAILY SALES','2021-04-27','2021-04-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-27 11:14:49','502','2021-04-27 11:15:13',10,0),('1','146',193493,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-04-27','2021-04-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-28 06:14:36','502','2021-04-28 06:15:23',10,0),('1','146',193625,'DAILY SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-29 05:35:19','502','2021-04-29 05:35:47',10,0),('1','146',193845,'DAILY SALES','2021-04-29','2021-04-29 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-29 15:52:52','502','2021-04-29 15:53:22',10,0),('1','146',194029,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-04-29','2021-04-29 00:00:00',NULL,'502',0.00,0.00,'502','2021-04-30 06:01:24','502','2021-04-30 06:02:01',10,0),('1','146',194075,'DAILY SALES','2021-04-30','2021-04-30 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-01 05:49:38','502','2021-05-01 05:50:20',10,0),('1','146',194281,'DAILY SALES','2021-05-01','2021-05-01 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-02 06:18:59','502','2021-05-02 06:19:26',10,0),('1','146',194483,'DAILY SALES NEW STOCK','2021-05-02','2021-05-02 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-03 06:13:26','502','2021-05-03 06:14:23',10,0),('1','146',194672,'DAILY SALES','2021-05-03','2021-05-03 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-04 11:41:38','502','2021-05-04 11:42:07',10,0),('1','146',194926,'DAILY SALES NEW STOCK','2021-05-04','2021-05-04 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-05 06:06:35','502','2021-05-05 06:07:00',10,0),('1','146',195076,'DAILY SALES','2021-05-05','2021-05-05 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-05 21:34:48','502','2021-05-05 21:35:11',10,0),('1','146',195298,'DAILY SALES','2021-05-06','2021-05-06 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-06 11:40:15','502','2021-05-06 11:40:44',10,0),('1','146',195408,'DAILY SHIFT 2ND SALES NEW STOCK','2021-05-06','2021-05-06 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-07 06:10:11','502','2021-05-07 06:10:44',10,0),('1','146',195517,'DAILY SALES','2021-05-07','2021-05-07 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-08 05:55:05','502','2021-05-08 05:55:49',10,0),('1','146',195775,'DAILY SALES','2021-05-08','2021-05-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-08 12:51:53','502','2021-05-08 12:52:50',10,0),('1','146',195892,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-05-08','2021-05-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-09 06:24:44','502','2021-05-09 06:25:06',10,0),('1','146',196007,'DAILY SALES','2021-05-09','2021-05-09 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-10 04:06:32','502','2021-05-10 04:07:13',10,0),('1','146',196208,'DAILY SALES','2021-05-10','2021-05-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-10 16:29:03','502','2021-05-10 16:31:51',10,0),('1','146',196398,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-05-10','2021-05-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-11 06:01:01','502','2021-05-11 06:01:53',10,0),('1','146',196448,'DAILY SALES','2021-05-11','2021-05-11 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-11 19:01:08','502','2021-05-11 19:02:02',10,0),('1','146',196658,'DAILY SALES','2021-05-12','2021-05-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-12 12:22:37','502','2021-05-12 12:23:02',10,0),('1','146',196776,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-05-12','2021-05-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-13 09:20:40','502','2021-05-13 09:21:04',10,0),('1','146',196892,'DAILY SALES','2021-05-13','2021-05-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-13 22:00:46','502','2021-05-13 22:01:08',10,0),('1','146',197020,'DAILY SALES','2021-05-14','2021-05-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-16 12:28:35','502','2021-05-16 12:29:03',10,0),('1','146',197344,'DAILY SALES','2021-05-15','2021-05-15 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-16 12:39:24','502','2021-05-16 12:39:46',10,0),('1','146',197349,'DAILY SALES NEW STOCK','2021-05-16','2021-05-16 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-16 18:47:20','502','2021-05-16 18:47:43',10,0),('1','146',197523,'DAILY SALES','2021-05-17','2021-05-17 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-18 06:10:57','502','2021-05-18 06:11:30',10,0),('1','146',197869,'DAILY SALES','2021-05-18','2021-05-18 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-18 14:04:46','502','2021-05-18 14:05:13',10,0),('1','146',198031,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-05-18','2021-05-18 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-19 05:51:34','502','2021-05-19 05:51:58',10,0),('1','146',198117,'DAILY SALES','2021-05-19','2021-05-19 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-20 05:47:28','502','2021-05-20 05:47:54',10,0),('1','146',198339,'DAILY SALES','2021-05-20','2021-05-20 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-21 08:50:41','502','2021-05-21 08:51:15',10,0),('1','146',198635,'DAILY SHIFT NEW STOCK','2021-05-21','2021-05-21 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-22 05:02:51','502','2021-05-22 05:03:18',10,0),('1','146',198769,'DAILY SALES','2021-05-22','2021-05-22 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-22 20:05:21','502','2021-05-22 20:05:44',10,0),('1','146',198979,'DAILY SALES','2021-05-23','2021-05-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-23 12:36:38','502','2021-05-23 12:37:02',10,0),('1','146',199099,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-05-23','2021-05-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-24 05:17:24','502','2021-05-24 05:18:06',10,0),('1','146',199196,'DAILY SALES','2021-05-24','2021-05-24 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-24 19:28:38','502','2021-05-24 19:29:02',10,0),('1','146',199428,'DAILY SALES','2021-05-25','2021-05-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-26 11:36:45','502','2021-05-26 11:37:11',10,0),('1','146',199778,'DAILY SHIFT NEW STOCK','2021-05-26','2021-05-26 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-27 04:37:19','502','2021-05-27 04:37:44',10,0),('1','146',199853,'DAILY SALES','2021-05-27','2021-05-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-28 05:05:13','502','2021-05-28 05:05:38',10,0),('1','146',200084,'DAILY SALES','2021-05-28','2021-05-28 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-28 13:33:36','502','2021-05-28 13:34:56',10,0),('1','146',200214,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-05-28','2021-05-28 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-28 22:55:44','502','2021-05-28 22:56:12',10,0),('1','146',200281,'DAILY SALES','2021-05-29','2021-05-29 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-30 04:46:51','502','2021-05-30 04:47:30',10,0),('1','146',200480,'DAILY SALES','2021-05-30','2021-05-30 00:00:00',NULL,'502',0.00,0.00,'502','2021-05-31 04:46:02','502','2021-05-31 04:46:30',10,0),('1','146',200682,'DAILY SALES','2021-05-31','2021-05-31 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-01 05:02:21','502','2021-06-01 05:10:39',10,0),('1','146',200910,'DAILY SALES','2021-06-01','2021-06-01 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-02 07:38:41','502','2021-06-02 07:39:31',10,0),('1','146',201143,'DAILY SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-02 08:42:39','502','2021-06-02 08:43:02',10,0),('1','146',201159,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-06-02','2021-06-02 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-03 06:03:49','502','2021-06-03 06:04:14',10,0),('1','146',201308,'DAILY SALES','2021-06-03','2021-06-03 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-04 05:11:00','502','2021-06-04 05:11:28',10,0),('1','146',201490,'DAILY SALES','2021-06-04','2021-06-04 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-04 15:31:43','502','2021-06-04 15:32:27',10,0),('1','146',201677,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-06-04','2021-06-04 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-04 19:18:24','502','2021-06-04 19:19:04',10,0),('1','146',201753,'DAILY SALES','2021-06-05','2021-06-05 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-06 08:09:54','502','2021-06-06 08:10:23',10,0),('1','146',202062,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-06-06','2021-06-06 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-07 06:15:58','502','2021-06-07 06:16:26',10,0),('1','146',202211,'DAILY SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-07 19:06:33','502','2021-06-07 19:07:47',10,0),('1','146',202415,'DAILY SALES','2021-06-08','2021-06-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-08 13:58:06','502','2021-06-08 13:58:38',10,0),('1','146',202551,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-06-08','2021-06-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-09 04:29:25','502','2021-06-09 04:29:48',10,0),('1','146',202630,'DAILY SALES','2021-06-09','2021-06-09 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-10 05:06:28','502','2021-06-10 05:07:23',10,0),('1','146',202839,'DAILY SALES','2021-06-10','2021-06-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-10 12:13:36','502','2021-06-10 12:14:02',10,0),('1','146',202972,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-06-10','2021-06-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-11 05:16:01','502','2021-06-11 05:16:54',10,0),('1','146',203098,'DAILY SALES','2021-06-11','2021-06-11 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-12 04:59:49','502','2021-06-12 05:00:45',10,0),('1','146',203295,'DAILY SALES','2021-06-12','2021-06-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-12 10:33:50','502','2021-06-12 10:35:59',10,0),('1','146',203422,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-06-12','2021-06-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-13 04:16:43','502','2021-06-13 04:17:21',10,0),('1','146',203512,'DAILY SALES','2021-06-13','2021-06-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-14 00:15:35','502','2021-06-14 00:16:49',10,0),('1','146',203712,'DAILY SALES','2021-06-14','2021-06-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-14 15:06:45','502','2021-06-14 15:07:08',10,0),('1','146',203895,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-06-14','2021-06-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-15 05:12:56','502','2021-06-15 05:13:25',10,0),('1','146',203955,'DAILY SALES','2021-06-15','2021-06-15 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-16 04:19:32','502','2021-06-16 04:19:57',10,0),('1','146',204175,'DAILY SALES','2021-06-16','2021-06-16 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-16 17:19:35','502','2021-06-16 17:20:12',10,0),('1','146',204354,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-06-16','2021-06-16 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-16 23:01:43','502','2021-06-16 23:02:25',10,0),('1','146',204384,'DAILY SALES','2021-06-17','2021-06-17 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-18 04:21:08','502','2021-06-18 04:21:46',10,0),('1','146',204599,'DAILY SALES','2021-06-18','2021-06-18 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-19 04:23:27','502','2021-06-19 04:24:01',10,0),('1','146',204825,'DAILY SALES NEW STOCK ','2021-06-19','2021-06-19 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-20 04:35:08','502','2021-06-20 04:35:37',10,0),('1','146',205028,'DAILY SALES','2021-06-20','2021-06-20 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-21 05:36:13','502','2021-06-21 05:36:45',10,0),('1','146',205220,'DAILY SALES','2021-06-21','2021-06-21 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-21 10:41:37','502','2021-06-21 10:43:24',10,0),('1','146',205322,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-06-21','2021-06-21 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-22 06:10:46','502','2021-06-22 06:11:03',10,0),('1','146',205473,'DAILY SALES','2021-06-22','2021-06-22 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-22 21:27:15','502','2021-06-22 21:27:51',10,0),('1','146',205721,'DAILY SALES','2021-06-23','2021-06-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-23 11:12:13','502','2021-06-23 11:12:37',10,0),('1','146',205826,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-06-23','2021-06-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-23 21:20:43','502','2021-06-23 21:21:06',10,0),('1','146',205930,'DAILY SALES','2021-06-24','2021-06-24 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-24 21:40:13','502','2021-06-24 21:40:52',10,0),('1','146',206132,'DAILY SALES','2021-06-25','2021-06-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-25 11:03:23','502','2021-06-25 11:03:47',10,0),('1','146',206254,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-06-25','2021-06-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-26 00:01:22','502','2021-06-26 05:36:33',10,0),('1','146',206353,'DAILY SALES','2021-06-26','2021-06-26 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-27 05:44:27','502','2021-06-27 05:45:06',10,0),('1','146',206566,'DAILY SALES','2021-06-27','2021-06-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-27 14:20:17','502','2021-06-27 14:20:40',10,0),('1','146',206705,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-06-27','2021-06-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-28 00:33:21','502','2021-06-28 00:33:44',10,0),('1','146',206778,'DAILY SALES','2021-06-28','2021-06-28 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-28 18:54:34','502','2021-06-28 18:55:24',10,0),('1','146',207009,'DAILY SALES','2021-06-29','2021-06-29 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-29 14:16:00','502','2021-06-29 14:17:02',10,0),('1','146',207177,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-06-29','2021-06-29 00:00:00',NULL,'502',0.00,0.00,'502','2021-06-29 19:48:20','502','2021-06-29 19:49:03',10,0),('1','146',207240,'DAILY SALES','2021-06-30','2021-06-30 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-01 04:46:04','502','2021-07-01 04:46:47',10,0),('1','146',207469,'DAILY SALES','2021-07-01','2021-07-01 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-01 12:31:36','502','2021-07-01 12:32:27',10,0),('1','146',207584,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-01','2021-07-01 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-02 05:21:10','502','2021-07-02 05:22:54',10,0),('1','146',207692,'DAILY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-03 05:32:41','502','2021-07-03 05:35:54',10,0),('1','146',207897,'DAILY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-03 11:43:05','502','2021-07-03 11:43:55',10,0),('1','146',208011,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-03','2021-07-03 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-03 20:07:18','502','2021-07-03 20:08:48',10,0),('1','146',208111,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-04','2021-07-04 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-04 19:52:45','502','2021-07-04 19:53:44',10,0),('1','146',208332,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-05','2021-07-05 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-05 11:28:37','502','2021-07-05 11:29:16',10,0),('1','146',208441,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-05','2021-07-05 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-05 19:06:46','502','2021-07-05 19:07:43',10,0),('1','146',208541,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-06','2021-07-06 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-07 06:12:06','502','2021-07-07 06:12:46',10,0),('1','146',208758,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-07','2021-07-07 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-07 13:31:00','502','2021-07-07 13:34:52',10,0),('1','146',208908,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-07','2021-07-07 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-08 05:49:07','502','2021-07-08 05:50:35',10,0),('1','146',208985,'DAILY SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-08 06:10:38','502','2021-07-08 06:11:17',10,0),('1','146',208995,'DAILY SHIFT SECOND SALES ','2021-07-08','2021-07-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-09 05:49:43','502','2021-07-09 05:53:07',10,0),('1','146',209209,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-09 19:21:48','502','2021-07-09 19:22:42',10,0),('1','146',209408,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-09','2021-07-09 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-09 20:14:50','502','2021-07-09 20:15:15',10,0),('1','146',209440,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-10','2021-07-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-10 18:59:41','502','2021-07-10 19:00:43',10,0),('1','146',209642,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-11','2021-07-11 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-11 15:27:30','502','2021-07-11 15:28:30',10,0),('1','146',209791,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-11','2021-07-11 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-12 06:06:07','502','2021-07-12 06:07:11',10,0),('1','146',209861,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-13 06:02:39','502','2021-07-13 06:03:03',10,0),('1','146',210098,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-13 16:06:06','502','2021-07-13 16:07:09',10,0),('1','146',210262,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-13','2021-07-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-13 19:44:41','502','2021-07-13 19:45:33',10,0),('1','146',210316,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-14','2021-07-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-14 19:31:50','502','2021-07-14 19:32:52',10,0),('1','146',210527,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-15','2021-07-15 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-15 16:41:18','502','2021-07-15 16:43:46',10,0),('1','146',210689,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-15','2021-07-15 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-16 05:48:45','502','2021-07-16 05:49:19',10,0),('1','146',210722,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-17 06:12:30','502','2021-07-17 06:13:57',10,0),('1','146',210946,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-17 16:10:16','502','2021-07-17 16:16:47',10,0),('1','146',211117,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-17','2021-07-17 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-17 20:02:23','502','2021-07-17 20:03:43',10,0),('1','146',211165,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-18 19:15:55','502','2021-07-18 19:17:28',10,0),('1','146',211376,'DAILY SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-19 11:10:33','502','2021-07-19 11:11:54',10,0),('1','146',211494,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-19','2021-07-19 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-19 19:35:29','502','2021-07-19 19:36:56',10,0),('1','146',211626,'DAILY SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-20 18:30:30','502','2021-07-20 18:31:39',10,0),('1','146',211767,'DAILY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-21 15:01:09','502','2021-07-21 15:02:41',10,0),('1','146',211923,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-21','2021-07-21 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-21 18:11:27','502','2021-07-21 18:12:38',10,0),('1','146',211988,'DAILY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-22 18:07:30','502','2021-07-22 18:08:22',10,0),('1','146',212232,'DAILY SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-23 18:51:33','502','2021-07-23 18:53:40',10,0),('1','146',212459,'DAILY SHIFT8','2021-07-24','2021-07-24 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-24 10:28:13','502','2021-07-24 10:28:51',10,0),('1','146',212531,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-24','2021-07-24 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-24 18:59:15','502','2021-07-24 18:59:46',10,0),('1','146',212668,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-25 09:57:09','502','2021-07-25 09:57:31',10,0),('1','146',212719,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-25','2021-07-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-25 18:37:41','502','2021-07-25 18:39:08',10,0),('1','146',212888,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-26 19:35:44','502','2021-07-26 19:38:10',10,0),('1','146',213124,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-27 10:20:23','502','2021-07-27 10:20:56',10,0),('1','146',213227,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-27','2021-07-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-27 18:39:18','502','2021-07-27 18:40:23',10,0),('1','146',213390,'DAILY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-28 20:16:11','502','2021-07-28 20:17:32',10,0),('1','146',213635,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-29 11:26:48','502','2021-07-29 11:27:27',10,0),('1','146',213724,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-29','2021-07-29 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-30 07:03:35','502','2021-07-30 07:12:18',10,0),('1','146',213907,'DAILY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-31 06:33:37','502','2021-07-31 06:34:54',10,0),('1','146',214098,'DAILY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'502',0.00,0.00,'502','2021-07-31 11:12:35','502','2021-07-31 11:18:51',10,0),('1','146',214178,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-07-31','2021-07-31 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-01 06:52:30','502','2021-08-01 06:53:16',10,0),('1','146',214342,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-01 18:26:07','502','2021-08-01 18:27:41',10,0),('1','146',214531,'DAILY SHIFT NEW STOCK','2021-08-02','2021-08-02 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-02 19:53:49','502','2021-08-02 19:55:24',10,0),('1','146',214774,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-03 16:04:52','502','2021-08-03 16:06:45',10,0),('1','146',214954,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-08-03','2021-08-03 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-04 10:16:09','502','2021-08-04 10:24:09',10,0),('1','146',215103,'DAILY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-04 22:32:08','502','2021-08-04 22:36:43',10,0),('1','146',215213,'DAILY SALES','2021-08-05','2021-08-05 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-05 19:03:46','502','2021-08-05 19:04:39',10,0),('1','146',215444,'DAILY SHIFT NEW STOCK','2021-08-06','2021-08-06 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-06 23:26:41','502','2021-08-06 23:28:49',10,0),('1','146',215673,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-07 17:19:46','502','2021-08-07 17:21:53',10,0),('1','146',215850,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-08-07','2021-08-07 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-08 06:21:37','502','2021-08-08 06:22:10',10,0),('1','146',215905,'DAILY SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-08 18:56:36','502','2021-08-08 18:58:35',10,0),('1','146',216101,'DAILY SALES','2021-08-09','2021-08-09 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-09 15:00:30','502','2021-08-09 15:02:14',10,0),('1','146',216265,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-08-09','2021-08-09 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-09 19:20:36','502','2021-08-09 19:21:33',10,0),('1','146',216318,'DAILY SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-10 19:32:50','502','2021-08-10 19:36:06',10,0),('1','146',216549,'DAILY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-11 13:43:55','502','2021-08-11 13:45:46',10,0),('1','146',216688,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-08-11','2021-08-11 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-11 21:06:42','502','2021-08-11 21:08:01',10,0),('1','146',216788,'DAILY SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-13 06:18:34','502','2021-08-13 06:20:41',10,0),('1','146',217019,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-13 11:25:52','502','2021-08-13 11:28:11',10,0),('1','146',217137,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-08-13','2021-08-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-14 05:56:22','502','2021-08-14 05:57:19',10,0),('1','146',217267,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-15 05:22:44','502','2021-08-15 05:23:16',10,0),('1','146',217494,'DAILY SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-15 08:22:47','502','2021-08-15 08:23:17',10,0),('1','146',217533,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-08-15','2021-08-15 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-15 19:04:27','502','2021-08-15 19:07:23',10,0),('1','146',217707,'DAILY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-17 05:33:24','502','2021-08-17 05:36:19',10,0),('1','146',217971,'DAILY SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-18 04:48:12','502','2021-08-18 04:51:03',10,0),('1','146',218207,'DAILY SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-18 18:55:38','502','2021-08-18 18:57:20',10,0),('1','146',218437,'DAILY SHIFT NEW STOCK','2021-08-19','2021-08-19 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-19 19:40:21','502','2021-08-19 19:46:50',10,0),('1','146',218683,'DAILY SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-20 19:40:59','502','2021-08-21 06:20:40',10,0),('1','146',218906,'DAILY SALES','2021-08-21','2021-08-21 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-21 09:56:21','502','2021-08-21 09:56:50',10,0),('1','146',218956,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-08-21','2021-08-21 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-21 19:38:22','502','2021-08-21 19:40:48',10,0),('1','146',219110,'DAILY SHIFT2','2021-08-22','2021-08-22 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-22 18:48:19','502','2021-08-22 18:51:36',10,0),('1','146',219341,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-23 12:02:27','502','2021-08-23 12:03:19',10,0),('1','146',219472,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-08-23','2021-08-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-23 18:15:06','502','2021-08-23 18:20:16',10,0),('1','146',219651,'DAILY SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-24 19:32:47','502','2021-08-24 19:36:06',10,0),('1','146',219803,'DAILY SALES','2021-08-25','2021-08-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-25 09:37:36','502','2021-08-25 09:39:49',10,0),('1','146',219887,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-08-25','2021-08-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-25 18:47:57','502','2021-08-25 18:50:49',10,0),('1','146',220031,'DAILY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-26 18:22:51','502','2021-08-26 18:25:35',10,0),('1','146',220242,'DAILY SALES NEW STOCK','2021-08-27','2021-08-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-27 18:21:14','502','2021-08-27 18:24:00',10,0),('1','146',220467,'DAILY SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-28 17:32:41','502','2021-08-28 17:43:05',10,0),('1','146',220677,'DAILY SHIFT NEW STOCK','2021-08-29','2021-08-29 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-29 19:40:12','502','2021-08-30 05:34:32',10,0),('1','146',220897,'DAILY SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-30 19:49:05','502','2021-08-30 19:52:04',10,0),('1','146',221156,'DAILY SHIFT NEW STOCK','2021-08-31','2021-08-31 00:00:00',NULL,'502',0.00,0.00,'502','2021-08-31 19:27:09','502','2021-09-01 05:05:45',10,0),('1','146',221373,'DAILY SALES','2021-09-01','2021-09-01 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-01 18:53:09','502','2021-09-01 18:59:58',10,0),('1','146',221605,'DAILY SHIFT NEW STOCK','2021-09-02','2021-09-02 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-02 19:52:00','502','2021-09-02 19:54:42',10,0),('1','146',221821,'DAILY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-04 12:53:20','502','2021-09-04 12:57:21',10,0),('1','146',222164,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-04 19:09:42','502','2021-09-04 19:13:28',10,0),('1','146',222261,'DAILY SHIFT NEW STOCK','2021-09-05','2021-09-05 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-05 18:38:50','502','2021-09-05 18:47:06',10,0),('1','146',222493,'DAILY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-06 19:30:31','502','2021-09-06 19:42:08',10,0),('1','146',222772,'DAILY SALES NEW STOCK','2021-09-07','2021-09-07 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-07 21:26:24','502','2021-09-07 21:27:02',10,0),('1','146',222931,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-08 19:27:57','502','2021-09-08 19:34:56',10,0),('1','146',223150,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-09-08','2021-09-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-09 05:53:07','502','2021-09-09 05:53:31',10,0),('1','146',223173,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-10 05:46:02','502','2021-09-10 05:49:20',10,0),('1','146',223410,'DAILY SALES','2021-09-10','2021-09-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-10 14:26:50','502','2021-09-10 14:27:57',10,0),('1','146',223552,'DAILY SALES NEW STOCK','2021-09-10','2021-09-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-10 14:36:53','502','2021-09-10 14:37:34',10,0),('1','146',223559,'DAILY 2ND SALES NEW STOCK','2021-09-10','2021-09-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-10 20:51:21','502','2021-09-10 20:52:37',10,0),('1','146',223843,'DAILY SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-11 20:37:58','502','2021-09-11 20:38:21',10,0),('1','146',223907,'DAILY SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-12 10:48:55','502','2021-09-12 10:51:55',10,0),('1','146',223942,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-09-12','2021-09-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-12 23:34:25','502','2021-09-12 23:35:00',10,0),('1','146',224077,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-13 19:40:00','502','2021-09-13 19:41:41',10,0),('1','146',224303,'DAILY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-14 15:55:32','502','2021-09-14 16:00:21',10,0),('1','146',224481,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-09-14','2021-09-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-14 20:12:57','502','2021-09-15 06:10:40',10,0),('1','146',224528,'DAILY SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-16 05:47:20','502','2021-09-16 05:54:31',10,0),('1','146',224769,'DAILY SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-16 16:22:00','502','2021-09-16 16:25:32',10,0),('1','146',224965,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-09-16','2021-09-16 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-17 05:29:24','502','2021-09-17 05:29:51',10,0),('1','146',225004,'DAILY SALES','2021-09-17','2021-09-17 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-17 20:34:17','502','2021-09-17 20:34:46',10,0),('1','146',225462,'DAILY SALES','2021-09-18','2021-09-18 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-20 19:49:56','502','2021-09-20 19:50:30',10,0),('1','146',225946,'DAILY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-20 20:01:22','502','2021-09-20 20:01:47',10,0),('1','146',225948,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-20 20:05:47','502','2021-09-20 20:06:22',10,0),('1','146',225951,'DAILY SHIFT 2ND SDALES NEW PRICE','2021-09-20','2021-09-20 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-21 07:00:26','502','2021-09-21 07:00:57',10,0),('1','146',225989,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-09-21','2021-09-21 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-21 20:16:10','502','2021-09-21 20:16:41',10,0),('1','146',226290,'DAILY SALES','2021-09-22','2021-09-22 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-22 20:42:49','502','2021-09-22 20:43:21',10,0),('1','146',226473,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-23 07:15:17','502','2021-09-23 07:15:55',10,0),('1','146',226494,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-09-23','2021-09-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-24 06:13:01','502','2021-09-24 06:14:33',10,0),('1','146',226732,'DAILY SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-24 21:48:38','502','2021-09-25 06:07:48',10,0),('1','146',226954,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-25 13:10:24','502','2021-09-25 13:11:38',10,0),('1','146',227078,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-09-25','2021-09-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-25 19:45:16','502','2021-09-25 19:46:44',10,0),('1','146',227186,'DAILY SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-27 05:31:02','502','2021-09-27 05:37:56',10,0),('1','146',227459,'DAILY SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-27 10:05:00','502','2021-09-27 10:08:51',10,0),('1','146',227466,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-09-27','2021-09-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-27 19:15:11','502','2021-09-27 19:16:41',10,0),('1','146',227584,'DAILY SALES','2021-09-27','2021-09-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-27 20:49:01','502','2021-09-27 20:49:29',10,0),('1','146',227610,'DAILY SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-28 21:55:25','502','2021-09-28 21:56:35',10,0),('1','146',227830,'DAILY 2ND SALES NEW STOCK','2021-09-28','2021-09-28 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-28 22:01:12','502','2021-09-28 22:01:42',10,0),('1','146',227856,'DAILY SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-30 06:28:17','502','2021-09-30 06:28:49',10,0),('1','146',228115,'DAILY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-30 19:54:58','502','2021-09-30 19:56:06',10,0),('1','146',228328,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-09-30','2021-09-30 00:00:00',NULL,'502',0.00,0.00,'502','2021-09-30 20:22:49','502','2021-09-30 20:23:29',10,0),('1','146',228344,'DAILY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-01 06:25:13','502','2021-10-01 06:25:45',10,0),('1','146',228353,'DAILY SHIFT 2ND SALES NEW PRICE','2021-10-01','2021-10-01 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-01 20:13:19','502','2021-10-01 20:15:29',10,0),('1','146',228522,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-02 11:33:05','502','2021-10-02 11:37:44',10,0),('1','146',228607,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-10-02','2021-10-02 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-02 19:27:05','502','2021-10-02 19:28:21',10,0),('1','146',228752,'DAILY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-03 19:35:58','502','2021-10-03 19:38:42',10,0),('1','146',229148,'DAILY SALES NEW STOCK','2021-10-04','2021-10-04 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-04 20:08:09','502','2021-10-04 20:08:28',10,0),('1','146',229328,'DAILY SALES','2021-10-05','2021-10-05 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-05 14:29:07','502','2021-10-05 14:29:59',10,0),('1','146',229353,'DAILY 2ND SALES NEW STOCK','2021-10-05','2021-10-05 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-05 19:34:32','502','2021-10-05 19:34:57',10,0),('1','146',229649,'DAILY SALES','2021-10-06','2021-10-06 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-06 22:43:38','502','2021-10-06 22:44:08',10,0),('1','146',229730,'DAILY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-07 11:49:05','502','2021-10-07 11:49:47',10,0),('1','146',229762,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-10-07','2021-10-07 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-08 06:48:29','502','2021-10-08 06:53:08',10,0),('1','146',229896,'DAILY SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-08 18:05:22','502','2021-10-08 18:27:16',10,0),('1','146',230051,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-10-08','2021-10-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-08 20:33:48','502','2021-10-08 20:34:13',10,0),('1','146',230089,'DAILY SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-10 06:00:53','502','2021-10-10 06:03:17',10,0),('1','146',230286,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-10 14:42:53','502','2021-10-10 14:45:21',10,0),('1','146',230465,'operational lost','2021-10-10','2021-10-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-10 16:35:57','502','2021-10-10 16:36:26',10,0),('1','146',230478,'DAILY 2ND SALES NEW STOCK','2021-10-10','2021-10-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-11 06:09:12','502','2021-10-11 06:10:01',10,0),('1','146',230525,'DAILY SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-12 05:50:59','502','2021-10-12 06:02:44',10,0),('1','146',230781,'DAILY SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-12 14:39:04','502','2021-10-12 14:41:50',10,0),('1','146',230976,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-10-12','2021-10-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-12 14:51:05','502','2021-10-12 14:52:02',10,0),('1','146',230981,'OPERATIONAL LOSS','2021-10-12','2021-10-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-12 15:39:34','502','2021-10-12 15:40:22',10,0),('1','146',231001,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-10-12','2021-10-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-13 06:17:41','502','2021-10-13 06:20:00',10,0),('1','146',231066,'DAILY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-13 19:46:30','502','2021-10-13 19:48:58',10,0),('1','146',231371,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-14 17:51:19','502','2021-10-14 17:52:48',10,0),('1','146',231604,'OPERATIONAL LOSS','2021-10-14','2021-10-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-14 18:16:30','502','2021-10-14 18:16:59',10,0),('1','146',231605,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-10-14','2021-10-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-15 04:40:31','502','2021-10-15 04:40:53',10,0),('1','146',231633,'DAILY SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-15 20:29:39','502','2021-10-15 20:33:57',10,0),('1','146',231881,'DAILY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-16 20:46:05','502','2021-10-16 20:51:53',10,0),('1','146',232071,'DAILY 2ND SALES NEW STOCK','2021-10-16','2021-10-16 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-16 20:55:29','502','2021-10-16 20:56:03',10,0),('1','146',232092,'DAILY SALES','2021-10-17','2021-10-17 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-17 19:31:43','502','2021-10-17 19:43:42',10,0),('1','146',232338,'DAILY SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-18 18:18:38','502','2021-10-18 18:21:06',10,0),('1','146',232583,'DAILY SALES NEW STOCK','2021-10-19','2021-10-19 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-19 19:12:29','502','2021-10-19 19:14:13',10,0),('1','146',232841,'DAILY SALES','2021-10-20','2021-10-20 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-20 21:01:29','502','2021-10-20 21:16:36',10,0),('1','146',233082,'DAILY 2ND SALES NEW STOCK','2021-10-20','2021-10-20 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-20 21:24:23','502','2021-10-20 21:25:29',10,0),('1','146',233115,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-21 20:03:03','502','2021-10-21 20:05:15',10,0),('1','146',233337,'OPERATIONAL LOSS','2021-10-21','2021-10-21 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-21 20:36:40','502','2021-10-21 20:37:12',10,0),('1','146',233339,'OPERATIONAL LOSS','2021-10-21','2021-10-21 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-21 22:06:37','502','2021-10-21 22:07:42',10,0),('1','146',233363,'DAILY SALES','2021-10-22','2021-10-22 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-22 20:29:18','502','2021-10-23 04:45:36',10,0),('1','146',233586,'DAILY SALES','2021-10-23','2021-10-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-23 09:32:04','502','2021-10-23 09:34:37',10,0),('1','146',233678,'OPERATIONAL LOSS','2021-10-23','2021-10-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-23 09:41:09','502','2021-10-23 09:41:48',10,0),('1','146',233682,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-10-23','2021-10-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-23 20:43:18','502','2021-10-24 04:58:54',10,0),('1','146',233828,'DAILY SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-24 20:24:18','502','2021-10-24 20:27:06',10,0),('1','146',234032,'DAILY SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-25 09:38:12','502','2021-10-25 09:57:08',10,0),('1','146',234149,'OPERATIONAL LOSS','2021-10-25','2021-10-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-25 10:35:39','502','2021-10-25 10:36:16',10,0),('1','146',234156,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-10-25','2021-10-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-25 20:25:43','502','2021-10-25 20:27:20',10,0),('1','146',234310,'DAILY SALES','2021-10-26','2021-10-26 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-26 20:39:34','502','2021-10-26 20:44:20',10,0),('1','146',234552,'DAILY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-27 10:18:41','502','2021-10-27 10:27:43',10,0),('1','146',234683,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-10-27','2021-10-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-27 20:17:54','502','2021-10-27 20:19:12',10,0),('1','146',234784,'OVERAGE','2021-10-27','2021-10-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-27 20:28:04','502','2021-10-27 20:28:34',10,0),('1','146',234812,'DAILY SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-28 19:47:54','502','2021-10-28 19:52:04',10,0),('1','146',235056,'DAILY SALES','2021-10-29','2021-10-29 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-29 12:09:45','502','2021-10-29 12:12:13',10,0),('1','146',235191,'OPERATIONAL LOSS','2021-10-29','2021-10-29 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-29 12:43:10','502','2021-10-29 12:44:04',10,0),('1','146',235200,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-10-29','2021-10-29 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-29 20:07:45','502','2021-10-29 20:32:44',10,0),('1','146',235292,'DAILY SALES','2021-10-30','2021-10-30 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-30 19:51:35','502','2021-10-30 19:53:13',10,0),('1','146',235514,'DAILY SALES','2021-10-31','2021-10-31 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-31 12:50:36','502','2021-10-31 12:52:07',10,0),('1','146',235638,'OPERATIONAL LOSS','2021-10-31','2021-10-31 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-31 12:58:37','502','2021-10-31 13:00:17',10,0),('1','146',235640,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-10-31','2021-10-31 00:00:00',NULL,'502',0.00,0.00,'502','2021-10-31 19:37:06','502','2021-10-31 19:43:09',10,0),('1','146',235742,'DAILY SALES','2021-11-01','2021-11-01 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-01 20:07:33','502','2021-11-01 20:15:58',10,0),('1','146',236006,'DAILY SALES','2021-11-02','2021-11-02 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-02 15:46:31','502','2021-11-02 15:51:26',10,0),('1','146',236172,'OPERATIONAL LOSS','2021-11-02','2021-11-02 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-02 15:57:10','502','2021-11-02 15:58:50',10,0),('1','146',236173,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-11-02','2021-11-02 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-02 21:20:56','502','2021-11-02 21:22:07',10,0),('1','146',236222,'DAILY SALES','2021-11-03','2021-11-03 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-03 20:21:02','502','2021-11-03 20:22:11',10,0),('1','146',236497,'DAILY SALES','2021-11-04','2021-11-04 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-04 14:00:46','502','2021-11-04 14:02:05',10,0),('1','146',236655,'OPERATIONAL LOSS','2021-11-04','2021-11-04 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-04 14:09:09','502','2021-11-04 14:09:31',10,0),('1','146',236662,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-11-04','2021-11-04 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-04 19:48:19','502','2021-11-04 19:49:40',10,0),('1','146',236720,'DAILY SALES','2021-11-05','2021-11-05 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-05 21:10:30','502','2021-11-05 21:11:04',10,0),('1','146',236946,'DAILY SALES','2021-11-06','2021-11-06 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-06 11:33:14','502','2021-11-06 11:34:07',10,0),('1','146',237050,'OPERATIONAL LOSS','2021-11-06','2021-11-06 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-06 11:39:21','502','2021-11-06 11:40:02',10,0),('1','146',237058,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-11-06','2021-11-06 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-07 05:26:14','502','2021-11-07 05:26:41',10,0),('1','146',237162,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-08 04:59:15','502','2021-11-08 04:59:58',10,0),('1','146',237367,'DAILY SALES','2021-11-08','2021-11-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-08 13:24:10','502','2021-11-08 13:24:43',10,0),('1','146',237509,'OVERAGE','2021-11-08','2021-11-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-08 13:32:38','502','2021-11-08 13:33:11',10,0),('1','146',237511,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-11-08','2021-11-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-08 19:58:03','502','2021-11-08 19:58:26',10,0),('1','146',237590,'DAILY SALES','2021-11-09','2021-11-09 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-09 20:32:14','502','2021-11-09 20:36:21',10,0),('1','146',237853,'DAILY SALES','2021-11-10','2021-11-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-10 15:24:15','502','2021-11-10 15:24:45',10,0),('1','146',238046,'OPERATIONAL LOSS','2021-11-10','2021-11-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-10 15:29:14','502','2021-11-10 15:29:31',10,0),('1','146',238047,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-11-10','2021-11-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-10 21:37:09','502','2021-11-10 21:37:33',10,0),('1','146',238102,'DAILY SALES','2021-11-11','2021-11-11 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-11 20:24:59','502','2021-11-11 20:25:32',10,0),('1','146',238347,'DAILY SALES','2021-11-12','2021-11-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-12 13:31:03','502','2021-11-12 13:31:39',10,0),('1','146',238500,'OVERAGE','2021-11-12','2021-11-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-12 13:37:51','502','2021-11-12 13:38:20',10,0),('1','146',238505,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-11-12','2021-11-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-12 20:07:28','502','2021-11-12 20:08:05',10,0),('1','146',238594,'DAILY SALES','2021-11-13','2021-11-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-13 20:17:14','502','2021-11-13 20:18:05',10,0),('1','146',238829,'DAILY SALES','2021-11-14','2021-11-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-14 15:51:18','502','2021-11-14 15:51:58',10,0),('1','146',238977,'OVERAGE','2021-11-14','2021-11-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-14 15:58:06','502','2021-11-14 15:58:28',10,0),('1','146',238981,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-11-14','2021-11-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-14 19:43:21','502','2021-11-14 19:44:01',10,0),('1','146',239054,'DAILY SALES','2021-11-15','2021-11-15 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-15 20:36:44','502','2021-11-15 20:37:46',10,0),('1','146',239281,'DAILY SALES','2021-11-16','2021-11-16 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-16 21:31:56','502','2021-11-16 21:32:18',10,0),('1','146',239498,'OVERAGE','2021-11-16','2021-11-16 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-16 21:39:19','502','2021-11-16 21:39:40',10,0),('1','146',239499,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-11-16','2021-11-16 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-16 21:45:37','502','2021-11-16 21:45:54',10,0),('1','146',239518,'DAILY SALES','2021-11-17','2021-11-17 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-17 20:30:41','502','2021-11-17 20:31:28',10,0),('1','146',239763,'DAILY SALES','2021-11-18','2021-11-18 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-18 19:58:53','502','2021-11-18 19:59:40',10,0),('1','146',239952,'OVERAGE','2021-11-18','2021-11-18 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-18 20:06:57','502','2021-11-18 20:07:16',10,0),('1','146',239987,'DAILY 2ND SALES NEW STOCK','2021-11-18','2021-11-18 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-19 05:44:25','502','2021-11-19 05:44:55',10,0),('1','146',239991,'DAILY SALES','2021-11-19','2021-11-19 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-19 19:04:23','502','2021-11-19 19:07:00',10,0),('1','146',240186,'DAILY SALES','2021-11-20','2021-11-20 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-20 19:45:19','502','2021-11-20 19:45:50',10,0),('1','146',240438,'DAILY SALES','2021-11-21','2021-11-21 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-21 08:41:05','502','2021-11-21 08:41:39',10,0),('1','146',240504,'OVERAGE','2021-11-21','2021-11-21 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-21 08:55:18','502','2021-11-21 08:55:39',10,0),('1','146',240508,'DAILY SALES','2021-11-21','2021-11-21 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-21 18:33:43','502','2021-11-21 18:41:56',10,0),('1','146',240667,'DAILY SALES','2021-11-22','2021-11-22 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-22 20:42:57','502','2021-11-22 20:43:33',10,0),('1','146',240962,'DAILY SALES','2021-11-23','2021-11-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-23 11:44:12','502','2021-11-23 11:45:09',10,0),('1','146',241089,'OVERAGE','2021-11-23','2021-11-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-23 11:52:10','502','2021-11-23 11:52:30',10,0),('1','146',241090,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-11-23','2021-11-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-23 20:25:41','502','2021-11-23 20:29:14',10,0),('1','146',241207,'DAILY SALES','2021-11-24','2021-11-24 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-24 19:22:33','502','2021-11-24 19:23:03',10,0),('1','146',241467,'DAILY SALES','2021-11-25','2021-11-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-25 19:54:50','502','2021-11-25 19:55:59',10,0),('1','146',241687,'OVERAGE','2021-11-25','2021-11-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-25 20:09:41','502','2021-11-25 20:10:23',10,0),('1','146',241726,'DAILY SALES','2021-11-26','2021-11-26 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-26 23:43:29','502','2021-11-26 23:44:04',10,0),('1','146',241960,'DAILY SALES','2021-11-27','2021-11-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-27 23:23:19','502','2021-11-27 23:24:04',10,0),('1','146',242245,'OVERAGE','2021-11-28','2021-11-28 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-28 08:05:20','502','2021-11-28 08:05:47',10,0),('1','146',242246,'DAILY 2ND SALES NEW STOCK','2021-11-28','2021-11-28 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-28 19:43:47','502','2021-11-28 19:44:21',10,0),('1','146',242411,'DAILY SALES','2021-11-29','2021-11-29 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-29 19:49:41','502','2021-11-29 19:50:48',10,0),('1','146',242660,'DAILY SALES','2021-11-30','2021-11-30 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-30 08:19:55','502','2021-11-30 08:20:30',10,0),('1','146',242738,'OPERATIONAL LOSS','2021-11-30','2021-11-30 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-30 08:56:03','502','2021-11-30 08:56:22',10,0),('1','146',242751,'DAILY SHIFT 2ND SALES NEW STOCK','2021-11-30','2021-11-30 00:00:00',NULL,'502',0.00,0.00,'502','2021-11-30 19:20:11','502','2021-11-30 19:21:39',10,0),('1','146',242905,'DAILY SALES','2021-12-01','2021-12-01 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-01 19:51:38','502','2021-12-01 19:52:25',10,0),('1','146',243126,'DAILY SALES','2021-12-02','2021-12-02 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-02 09:50:28','502','2021-12-02 09:51:27',10,0),('1','146',243230,'DAILY 2ND SALES NEW STOCK','2021-12-02','2021-12-02 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-02 20:00:18','502','2021-12-02 20:01:21',10,0),('1','146',243360,'DAILY SALES','2021-12-03','2021-12-03 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-03 19:21:05','502','2021-12-03 19:22:50',10,0),('1','146',243590,'DAILY SALES','2021-12-04','2021-12-04 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-04 07:50:46','502','2021-12-04 07:52:00',10,0),('1','146',243646,'OVERAGE','2021-12-04','2021-12-04 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-04 08:01:52','502','2021-12-04 08:02:19',10,0),('1','146',243650,'DAILY 2ND SALES NEW STOCK','2021-12-04','2021-12-04 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-04 19:26:48','502','2021-12-04 19:28:22',10,0),('1','146',243814,'DAILY SALES','2021-12-05','2021-12-05 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-05 16:57:48','502','2021-12-05 16:58:59',10,0),('1','146',243989,'OVERAGE','2021-12-05','2021-12-05 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-05 17:06:36','502','2021-12-05 17:07:15',10,0),('1','146',243990,'DAILY SHIFT 2ND SDALES NEW STOCK','2021-12-05','2021-12-05 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-05 20:25:39','502','2021-12-05 20:26:00',10,0),('1','146',244030,'DAILY SALES','2021-12-06','2021-12-06 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-06 19:38:24','502','2021-12-06 19:39:24',10,0),('1','146',244267,'DAILY SALES','2021-12-07','2021-12-07 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-07 16:14:10','502','2021-12-07 16:15:05',10,0),('1','146',244449,'OVERAGE','2021-12-07','2021-12-07 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-07 16:20:07','502','2021-12-07 16:20:59',10,0),('1','146',244450,'DAILY SHIFT 2ND SDALES NEW STOCK','2021-12-07','2021-12-07 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-07 19:25:28','502','2021-12-07 19:35:48',10,0),('1','146',244499,'DAILY SALES','2021-12-08','2021-12-08 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-08 19:39:37','502','2021-12-08 19:41:02',10,0),('1','146',244738,'DAILY SALES','2021-12-09','2021-12-09 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-09 15:52:14','502','2021-12-09 15:52:50',10,0),('1','146',244901,'OVERAGE','2021-12-09','2021-12-09 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-09 16:01:24','502','2021-12-09 16:01:51',10,0),('1','146',244902,'DAILY SALES 2ND NEW STOCK','2021-12-09','2021-12-09 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-09 19:49:03','502','2021-12-09 19:49:20',10,0),('1','146',244977,'DAILY SALES','2021-12-10','2021-12-10 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-10 19:40:42','502','2021-12-10 19:44:34',10,0),('1','146',245197,'DAILY SALES','2021-12-11','2021-12-11 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-11 16:18:30','502','2021-12-11 16:20:03',10,0),('1','146',245357,'OPERATIONAL LOSS','2021-12-11','2021-12-11 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-11 16:34:42','502','2021-12-11 16:35:35',10,0),('1','146',245443,'DAILY SALES','2021-12-12','2021-12-12 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-12 18:57:15','502','2021-12-12 18:58:57',10,0),('1','146',245670,'DAILY SALES','2021-12-13','2021-12-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-13 17:23:24','502','2021-12-13 17:23:53',10,0),('1','146',245877,'OVERAGE','2021-12-13','2021-12-13 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-13 17:40:00','502','2021-12-13 17:40:29',10,0),('1','146',245925,'DAILY SALES','2021-12-14','2021-12-14 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-14 19:59:14','502','2021-12-14 20:00:05',10,0),('1','146',246169,'DAILY SALES','2021-12-15','2021-12-15 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-15 18:37:05','502','2021-12-15 18:38:01',10,0),('1','146',246404,'OPERATIONAL LOSS','2021-12-15','2021-12-15 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-16 20:34:12','502','2021-12-16 20:36:06',10,0),('1','146',246694,'DAILY SALES','2021-12-17','2021-12-17 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-17 19:34:28','502','2021-12-17 19:35:19',10,0),('1','146',246886,'OVERAGE','2021-12-17','2021-12-17 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-17 19:40:16','502','2021-12-17 19:40:33',10,0),('1','146',246887,'DAILY SHIFT 2ND SDALES NEW STOCK','2021-12-17','2021-12-17 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-17 19:44:16','502','2021-12-17 19:44:39',10,0),('1','146',246923,'DAILY SALES NEW STOCK','2021-12-18','2021-12-18 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-18 19:34:50','502','2021-12-18 19:35:31',10,0),('1','146',247157,'DAILY SALES','2021-12-19','2021-12-19 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-19 19:15:59','502','2021-12-19 19:17:35',10,0),('1','146',247374,'OPERATIONAL LOSS','2021-12-19','2021-12-19 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-19 22:30:08','502','2021-12-19 22:30:31',10,0),('1','146',247401,'DAILY SHIFT NEW STOCK','2021-12-20','2021-12-20 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-20 19:38:43','502','2021-12-20 19:39:36',10,0),('1','146',247660,'DAILY SALES','2021-12-21','2021-12-21 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-21 12:07:01','502','2021-12-21 12:07:37',10,0),('1','146',247768,'DAILY SALES','2021-12-21','2021-12-21 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-21 19:36:07','502','2021-12-21 19:36:35',10,0),('1','146',247938,'OVERAGE','2021-12-22','2021-12-22 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-22 07:31:55','502','2021-12-22 07:32:19',10,0),('1','146',247950,'DAILY 2ND SALES NEW STOCK','2021-12-22','2021-12-22 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-22 19:33:19','502','2021-12-22 19:34:25',10,0),('1','146',248151,'DAILY SALES','2021-12-23','2021-12-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-23 15:24:40','502','2021-12-23 15:25:37',10,0),('1','146',248319,'OVERAGE','2021-12-23','2021-12-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-23 15:29:42','502','2021-12-23 15:30:00',10,0),('1','146',248320,'DAILY SHIFT 2ND SALES NEW STOCK','2021-12-23','2021-12-23 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-23 19:30:19','502','2021-12-23 19:30:57',10,0),('1','146',248396,'DAILY SALES','2021-12-24','2021-12-24 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-24 20:06:45','502','2021-12-24 20:09:45',10,0),('1','146',248637,'DAILY SALES','2021-12-25','2021-12-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-25 10:10:32','502','2021-12-25 10:11:09',10,0),('1','146',248721,'OVERAGE','2021-12-25','2021-12-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-25 10:15:52','502','2021-12-25 10:16:11',10,0),('1','146',248722,'DAILY SHIFT 2ND SDALES NEW STOCK','2021-12-25','2021-12-25 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-25 19:21:12','502','2021-12-25 19:21:49',10,0),('1','146',248858,'DAILY SALES','2021-12-26','2021-12-26 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-26 18:22:33','502','2021-12-26 18:24:04',10,0),('1','146',249093,'DAILY SALES','2021-12-27','2021-12-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-27 13:09:47','502','2021-12-27 13:10:22',10,0),('1','146',249238,'DAILY SHIFT 2ND SDALES NEW STOCK','2021-12-27','2021-12-27 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-27 20:01:41','502','2021-12-27 20:06:37',10,0),('1','146',249341,'DAILY SALES','2021-12-28','2021-12-28 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-28 19:17:54','502','2021-12-28 19:19:07',10,0),('1','146',249572,'DAILY SALES','2021-12-29','2021-12-29 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-29 19:14:35','502','2021-12-29 19:16:02',10,0),('1','146',249802,'0PERATIONAL LOSS','2021-12-29','2021-12-29 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-29 19:40:47','502','2021-12-29 19:41:16',10,0),('1','146',249861,'DAILY SALES','2021-12-30','2021-12-30 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-30 19:23:21','502','2021-12-30 19:28:27',10,0),('1','146',250081,'DAILY SALES','2021-12-31','2021-12-31 00:00:00',NULL,'502',0.00,0.00,'502','2021-12-31 18:41:30','502','2021-12-31 18:42:28',10,0),('1','146',250341,'DAILY SALES','2022-01-01','2022-01-01 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-01 10:34:18','502','2022-01-01 10:34:41',10,0),('1','146',250416,'DAILY 2ND SALES NEW STOCK','2022-01-01','2022-01-01 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-01 18:16:05','502','2022-01-01 18:16:34',10,0),('1','146',250552,'DAILY SALES','2022-01-02','2022-01-02 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-02 17:34:35','502','2022-01-02 17:37:14',10,0),('1','146',250812,'DAILY SALES','2022-01-03','2022-01-03 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-03 19:43:41','502','2022-01-03 19:44:13',10,0),('1','146',250978,'OPERATIONAL LOSS','2022-01-03','2022-01-03 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-03 19:55:41','502','2022-01-03 19:56:12',10,0),('1','146',251016,'DAILY SALES','2022-01-04','2022-01-04 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-04 19:12:19','502','2022-01-04 19:13:07',10,0),('1','146',251294,'DAILY SALES','2022-01-05','2022-01-05 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-05 19:58:32','502','2022-01-05 19:59:08',10,0),('1','146',251502,'DAILY SALES','2022-01-06','2022-01-06 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-06 10:27:13','502','2022-01-06 10:27:37',10,0),('1','146',251600,'OPERATIONAL LOSS','2022-01-06','2022-01-06 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-06 10:35:45','502','2022-01-06 10:36:09',10,0),('1','146',251607,'DAILY SALES NEW STOCK','2022-01-06','2022-01-06 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-06 20:34:09','502','2022-01-06 20:35:14',10,0),('1','146',251752,'DAILY SALES','2022-01-07','2022-01-07 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-07 20:39:32','502','2022-01-07 20:40:15',10,0),('1','146',252002,'DAILY SALES','2022-01-08','2022-01-08 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-08 11:36:42','502','2022-01-08 11:37:33',10,0),('1','146',252085,'OPERATIONAL LOSS','2022-01-08','2022-01-08 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-08 11:45:35','502','2022-01-08 11:45:56',10,0),('1','146',252086,'DAILY SHIFT 2ND SDALES NEW STOCK','2022-01-08','2022-01-08 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-08 20:47:01','502','2022-01-08 20:57:32',10,0),('1','146',252241,'DAILY SALES','2022-01-09','2022-01-09 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-09 21:14:06','502','2022-01-09 21:15:31',10,0),('1','146',252467,'DAILY SALES','2022-01-10','2022-01-10 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-10 20:29:01','502','2022-01-10 20:34:26',10,0),('1','146',252719,'DAILY SALES','2022-01-11','2022-01-11 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-11 19:42:39','502','2022-01-11 19:45:38',10,0),('1','146',252975,'DAILY SALES','2022-01-12','2022-01-12 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-12 20:34:24','502','2022-01-12 20:35:45',10,0),('1','146',253203,'DAILY SALES','2022-01-13','2022-01-13 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-13 19:15:28','502','2022-01-13 19:16:42',10,0),('1','146',253472,'DAILY SALES NEW STOCK','2022-01-14','2022-01-14 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-14 20:38:02','502','2022-01-14 20:43:09',10,0),('1','146',253713,'DAILY SALES','2022-01-15','2022-01-15 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-15 18:21:36','502','2022-01-15 18:24:49',10,0),('1','146',253888,'DAILY SALES NEW STOCK','2022-01-15','2022-01-15 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-15 20:45:08','502','2022-01-15 20:45:46',10,0),('1','146',253943,'DAILY SALES','2022-01-16','2022-01-16 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-16 19:29:28','502','2022-01-16 19:34:53',10,0),('1','146',254198,'DAILY SALES','2022-01-17','2022-01-17 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-17 20:07:26','502','2022-01-17 20:11:43',10,0),('1','146',254433,'DAILY SALES','2022-01-18','2022-01-18 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-18 08:27:15','502','2022-01-18 08:27:45',10,0),('1','146',254488,'DAILY SHIFT 2ND SDALES NEW STOCK4744','2022-01-18','2022-01-18 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-18 19:50:51','502','2022-01-18 20:00:33',10,0),('1','146',254708,'DAILY SALES','2022-01-19','2022-01-19 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-19 20:05:20','502','2022-01-19 20:26:19',10,0),('1','146',254929,'DAILY SALES','2022-01-20','2022-01-20 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-20 10:54:25','502','2022-01-20 10:54:55',10,0),('1','146',255041,'DAILY SHIFT 2ND SDALES NEW STOCK','2022-01-20','2022-01-20 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-20 20:18:50','502','2022-01-20 20:20:13',10,0),('1','146',255178,'DAILY SALES','2022-01-21','2022-01-21 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-21 20:35:15','502','2022-01-21 20:36:34',10,0),('1','146',255449,'DAILY SALES','2022-01-22','2022-01-22 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-22 14:05:39','502','2022-01-22 14:07:01',10,0),('1','146',255594,'DAILY SALES NEW STOCK','2022-01-22','2022-01-22 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-22 20:39:11','502','2022-01-22 20:52:16',10,0),('1','146',255699,'DAILY SALES','2022-01-23','2022-01-23 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-23 19:44:44','502','2022-01-23 19:45:57',10,0),('1','146',255956,'DAILY SALES','2022-01-24','2022-01-24 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-24 11:04:00','502','2022-01-24 11:04:33',10,0),('1','146',256048,'DAILY 2ND SALES NEW STOCK','2022-01-24','2022-01-24 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-24 20:29:50','502','2022-01-24 20:31:33',10,0),('1','146',256207,'DAILY SALES','2022-01-25','2022-01-25 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-25 20:18:51','502','2022-01-25 20:19:48',10,0),('1','146',256479,'DAILY SALES','2022-01-26','2022-01-26 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-26 11:29:51','502','2022-01-26 11:31:02',10,0),('1','146',256583,'DAILY SHIFT 2ND SALES NEW STOCK','2022-01-26','2022-01-26 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-27 06:20:23','502','2022-01-27 06:23:12',10,0),('1','146',256712,'DAILY SALES','2022-01-27','2022-01-27 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-27 20:33:20','502','2022-01-27 20:33:39',10,0),('1','146',256962,'DAILY SALES','2022-01-28','2022-01-28 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-28 14:26:56','502','2022-01-28 14:29:39',10,0),('1','146',257105,'DAILY SHIFT 2ND SDALES NEW STOCK','2022-01-28','2022-01-28 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-28 20:06:08','502','2022-01-28 20:10:32',10,0),('1','146',257223,'DAILY SALES','2022-01-29','2022-01-29 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-29 21:28:38','502','2022-01-29 21:30:36',10,0),('1','146',257494,'DAILY SALES','2022-01-30','2022-01-30 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-30 12:14:56','502','2022-01-30 12:15:52',10,0),('1','146',257587,'DAILY 2ND SALES NEW STOCK','2022-01-30','2022-01-30 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-31 10:03:06','502','2022-01-31 10:03:21',10,0),('1','146',257588,'DAILY SALES','2022-01-31','2022-01-31 00:00:00',NULL,'502',0.00,0.00,'502','2022-01-31 20:31:04','502','2022-01-31 20:31:23',10,0),('1','146',257589,'DAILY SALES','2022-02-01','2022-02-01 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-01 12:02:37','502','2022-02-01 12:02:54',10,0),('1','146',257590,'DAILY SALES NEW STOCK','2022-02-01','2022-02-01 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-01 20:45:10','502','2022-02-01 20:45:31',10,0),('1','146',257591,'DAILY SALES','2022-02-02','2022-02-02 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-02 20:27:24','502','2022-02-02 20:27:40',10,0),('1','146',257592,'OPERATIONAL LOSS','2022-02-02','2022-02-02 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-02 20:32:09','502','2022-02-02 20:32:25',10,0),('1','146',257593,'DAILY SALES','2022-02-03','2022-02-03 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-03 20:31:40','502','2022-02-03 20:31:58',10,0),('1','146',257594,'DAILY SALES','2022-02-04','2022-02-04 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-04 17:18:37','502','2022-02-04 17:19:10',10,0),('1','146',257595,'DAILY  2ND SALES NEW STOCK','2022-02-04','2022-02-04 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-04 21:07:42','502','2022-02-04 21:08:00',10,0),('1','146',257596,'DAILY SALES','2022-02-05','2022-02-05 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-05 20:24:17','502','2022-02-05 20:24:45',10,0),('1','146',257597,'DAILY SALES','2022-02-06','2022-02-06 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-06 12:50:05','502','2022-02-06 12:50:23',10,0),('1','146',257598,'DAILY  2ND SALES NEW STOCK','2022-02-06','2022-02-06 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-06 20:43:02','502','2022-02-06 20:45:27',10,0),('1','146',257599,'DAILY SALES','2022-02-07','2022-02-07 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-07 20:27:46','502','2022-02-07 20:28:07',10,0),('1','146',257600,'DAILY SALES','2022-02-08','2022-02-08 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-08 08:48:29','502','2022-02-08 08:48:47',10,0),('1','146',257601,'DAILY SALES NEW STOCK','2022-02-08','2022-02-08 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-08 20:28:00','502','2022-02-08 20:28:40',10,0),('1','146',257602,'DAILY SALES','2022-02-09','2022-02-09 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-10 06:30:56','502','2022-02-10 06:31:22',10,0),('1','146',257603,'DAILY SALES NEW STOCK','2022-02-10','2022-02-10 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-10 20:15:22','502','2022-02-10 20:15:49',10,0),('1','146',257604,'DAILY SALES','2022-02-11','2022-02-11 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-11 16:18:42','502','2022-02-11 16:18:59',10,0),('1','146',257605,'DAILY SALES NEW STOCK','2022-02-11','2022-02-11 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-11 20:23:56','502','2022-02-11 20:24:52',10,0),('1','146',257606,'DAILY SALES','2022-02-13','2022-02-13 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-13 19:13:47','502','2022-02-13 19:14:07',10,0),('1','146',257607,'DAILY SALES','2022-02-14','2022-02-14 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-14 15:36:32','502','2022-02-14 15:36:47',10,0),('1','146',257608,'DAILY  2ND SALES NEW STOCK','2022-02-14','2022-02-14 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-14 20:11:45','502','2022-02-14 20:12:00',10,0),('1','146',257609,'DAILY SALES','2022-02-15','2022-02-15 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-15 20:36:15','502','2022-02-15 20:36:33',10,0),('1','146',257610,'DAILY SALES','2022-02-16','2022-02-16 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-16 09:11:30','502','2022-02-16 09:11:59',10,0),('1','146',257611,'DAILY SALES NEW STOCK ','2022-02-16','2022-02-16 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-16 20:43:18','502','2022-02-16 21:09:02',10,0),('1','146',257612,'DAILY SALES','2022-02-17','2022-02-17 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-17 21:24:20','502','2022-02-17 21:25:00',10,0),('1','146',257613,'DAILY SALES','2022-02-18','2022-02-18 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-18 11:29:38','502','2022-02-18 11:29:59',10,0),('1','146',257614,'DAILY  2ND SALES NEW STOCK','2022-02-18','2022-02-18 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-18 20:35:00','502','2022-02-18 20:35:16',10,0),('1','146',257615,'DAILY SALES','2022-02-19','2022-02-19 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-19 21:17:05','502','2022-02-19 21:17:22',10,0),('1','146',257616,'DAILY SALES','2022-02-20','2022-02-20 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-20 13:41:48','502','2022-02-20 13:42:06',10,0),('1','146',257617,'DAILY SALES NEW STOCK','2022-02-20','2022-02-20 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-20 20:17:19','502','2022-02-20 20:17:37',10,0),('1','146',257618,'DAILY SALES','2022-02-21','2022-02-21 00:00:00',NULL,'502',0.00,0.00,'502','2022-02-21 23:51:11','502','2022-02-21 23:51:31',10,0),('1','146',257619,'DAILY SALES','2022-02-22','2022-02-22 06:55:55','2022-02-23 06:55:55','502',0.00,0.00,'502','2022-02-22 13:50:47','502','2022-02-22 13:51:28',10,0),('1','146',257620,'DAILY SALES NEW STOCK','2022-02-22','2022-02-22 13:57:02','2022-02-23 13:57:02','502',0.00,0.00,'502','2022-02-22 20:35:02','502','2022-02-22 20:36:28',10,0),('1','146',257621,'DAILY SALES','2022-02-23','2022-02-23 07:07:08','2022-02-24 07:07:08','502',0.00,0.00,'502','2022-02-23 19:45:26','502','2022-02-23 19:45:51',10,0),('1','146',257622,'DAILY SALES','2022-02-24','2022-02-24 07:43:31','2022-02-25 07:43:31','502',0.00,0.00,'502','2022-02-24 12:54:44','502','2022-02-24 12:56:14',10,0),('1','146',257623,'DAILY SALES NEW STOCK','2022-02-24','2022-02-24 12:59:21','2022-02-25 12:59:21','502',0.00,0.00,'502','2022-02-24 20:00:30','502','2022-02-24 20:00:53',10,0),('1','146',257624,'DAILY SALES','2022-02-25','2022-02-25 07:19:11','2022-02-26 07:19:11','502',0.00,0.00,'502','2022-02-25 20:11:38','502','2022-02-25 20:12:04',10,0),('1','146',257625,'DAILY SALES','2022-02-26','2022-02-26 06:13:49','2022-02-27 06:13:49','502',0.00,0.00,'502','2022-02-26 13:46:46','502','2022-02-26 13:47:05',10,0),('1','146',257626,'DAILY SALES NEW STOCK','2022-02-26','2022-02-26 13:47:27','2022-02-27 13:47:27','502',0.00,0.00,'502','2022-02-26 19:57:27','502','2022-02-26 19:58:08',10,0),('1','146',257627,'DAILY SALES','2022-02-27','2022-02-27 06:31:39','2022-02-28 06:31:39','502',0.00,0.00,'502','2022-02-28 06:07:43','502','2022-02-28 06:08:33',10,0),('1','146',257628,'DAILY SALES','2022-02-28','2022-02-28 06:09:17','2022-03-01 06:09:17','502',0.00,0.00,'502','2022-02-28 17:05:37','502','2022-02-28 17:06:21',10,0),('1','146',257629,'DAILY SALES NEW STOCK','2022-02-28','2022-02-28 17:42:11','2022-03-01 17:42:11','502',0.00,0.00,'502','2022-02-28 21:13:58','502','2022-02-28 21:14:16',10,0),('1','146',257630,'DAILY SALES','2022-03-01','2022-03-01 06:43:09','2022-03-02 06:43:09','502',0.00,0.00,'502','2022-03-01 20:02:44','502','2022-03-01 20:03:04',10,0),('1','146',257631,'DAILY SALES','2022-03-02','2022-03-02 06:19:13','2022-03-03 06:19:13','502',0.00,0.00,'502','2022-03-02 20:39:29','502','2022-03-02 20:40:13',10,0),('1','146',257632,'DAILY SALES','2022-03-03','2022-03-03 06:53:39','2022-03-04 06:53:39','502',0.00,0.00,'502','2022-03-03 11:15:34','502','2022-03-03 11:15:49',10,0),('1','146',257633,'DAILY SALES','2022-03-03','2022-03-03 11:18:07','2022-03-04 11:18:07','502',0.00,0.00,'502','2022-03-03 20:49:56','502','2022-03-03 20:50:24',10,0),('1','146',257634,'DAILY SALES','2022-03-04','2022-03-04 06:20:18','2022-03-05 06:20:18','502',0.00,0.00,'502','2022-03-04 20:56:54','502','2022-03-04 20:57:11',10,0),('1','146',257635,'DAILY SALES','2022-03-05','2022-03-05 06:42:00','2022-03-06 06:42:00','502',0.00,0.00,'502','2022-03-05 10:14:55','502','2022-03-05 10:15:40',10,0),('1','146',257636,'DAILY  2ND SALES NEW STOCK','2022-03-05','2022-03-05 10:20:00','2022-03-06 10:20:00','502',0.00,0.00,'502','2022-03-05 20:49:03','502','2022-03-05 20:49:43',10,0),('1','146',257637,'DAILY SALES','2022-03-06','2022-03-06 06:23:22','2022-03-07 06:23:22','502',0.00,0.00,'502','2022-03-06 19:09:57','502','2022-03-06 19:10:35',10,0),('1','146',257638,'DAILY SALES','2022-03-07','2022-03-07 07:08:08','2022-03-08 07:08:08','502',0.00,0.00,'502','2022-03-07 20:46:14','502','2022-03-07 20:46:31',10,0),('1','146',257639,'DAILY SALES','2022-03-08','2022-03-08 06:27:22','2022-03-09 06:27:22','502',0.00,0.00,'502','2022-03-08 14:23:03','502','2022-03-08 14:23:31',10,0),('1','146',257640,'DAILY SHIFT 2ND SDALES NEW STOCK','2022-03-08','2022-03-08 14:27:39','2022-03-09 14:27:39','502',0.00,0.00,'502','2022-03-08 20:59:56','502','2022-03-08 21:00:44',10,0),('1','146',257641,'DAILY SALES','2022-03-09','2022-03-09 06:56:43','2022-03-10 06:56:43','502',0.00,0.00,'502','2022-03-09 20:35:41','502','2022-03-09 20:36:06',10,0),('1','146',257642,'DAILY SALES','2022-03-10','2022-03-10 06:14:06','2022-03-11 06:14:06','502',0.00,0.00,'502','2022-03-10 12:05:41','502','2022-03-10 12:05:59',10,0),('1','146',257643,'DAILY SHIFT 2ND SDALES NEW STOCK','2022-03-10','2022-03-10 12:08:04','2022-03-11 12:08:04','502',0.00,0.00,'502','2022-03-10 19:58:57','502','2022-03-10 19:59:18',10,0),('1','146',257644,'DAILY SALES','2022-03-11','2022-03-11 06:40:41','2022-03-12 06:40:41','502',0.00,0.00,'502','2022-03-11 20:05:56','502','2022-03-11 20:06:12',10,0),('1','146',257645,'DAILY SALES','2022-03-12','2022-03-12 06:27:42','2022-03-13 06:27:42','502',0.00,0.00,'502','2022-03-12 16:30:45','502','2022-03-12 16:31:03',10,0),('1','146',257646,'DAILY SHIFT 2ND SALES NEW STOCK','2022-03-12','2022-03-12 16:33:31','2022-03-13 16:33:31','502',0.00,0.00,'502','2022-03-12 20:37:55','502','2022-03-12 20:38:22',10,0),('1','146',257647,'DAILY SALES','2022-03-13','2022-03-13 06:03:01','2022-03-14 06:03:01','502',0.00,0.00,'502','2022-03-13 20:12:33','502','2022-03-13 20:12:51',10,0),('1','146',257648,'DAILY SALES','2022-03-14','2022-03-14 06:33:10','2022-03-15 06:33:10','502',0.00,0.00,'502','2022-03-14 15:55:43','502','2022-03-14 15:56:11',10,0),('1','146',257649,'DAILY SALES NEW STOCK','2022-03-14','2022-03-14 15:59:23','2022-03-15 15:59:23','502',0.00,0.00,'502','2022-03-14 20:35:11','502','2022-03-14 20:36:54',10,0),('1','146',257650,'DAILY SALES','2022-03-15','2022-03-15 06:38:21','2022-03-16 06:38:21','502',0.00,0.00,'502','2022-03-15 19:54:35','502','2022-03-15 19:54:55',10,0),('1','146',257651,'DAILY SALES','2022-03-16','2022-03-16 06:49:37','2022-03-17 06:49:37','502',0.00,0.00,'502','2022-03-16 18:28:50','502','2022-03-16 18:29:19',10,0),('1','146',257652,'DAILY SHIFT 2ND SDALES NEW STOCK','2022-03-16','2022-03-16 18:29:37','2022-03-17 18:29:37','502',0.00,0.00,'502','2022-03-16 20:12:10','502','2022-03-16 20:13:12',10,0),('1','146',257653,'DAILY SALES','2022-03-17','2022-03-17 06:26:27','2022-03-18 06:26:27','502',0.00,0.00,'502','2022-03-17 20:19:42','502','2022-03-17 20:20:04',10,0),('1','146',257654,'DAILY SALES','2022-03-18','2022-03-18 06:25:08','2022-03-19 06:25:08','502',0.00,0.00,'502','2022-03-18 20:14:17','502','2022-03-18 20:18:02',10,0),('1','146',257655,'DAILY SALES','2022-03-19','2022-03-19 07:13:10','2022-03-20 07:13:10','502',0.00,0.00,'502','2022-03-19 13:18:31','502','2022-03-19 13:18:49',10,0),('1','146',257656,'DAILY SHIFT 2ND SDALES NEW STOCK','2022-03-19','2022-03-19 13:20:32','2022-03-20 13:20:32','502',0.00,0.00,'502','2022-03-19 21:01:14','502','2022-03-19 21:01:27',10,0),('1','146',257657,'DAILY SALES','2022-03-20','2022-03-20 06:59:15','2022-03-21 06:59:15','502',0.00,0.00,'502','2022-03-20 20:08:03','502','2022-03-20 20:08:44',10,0),('1','146',257658,'DAILY SALES','2022-03-21','2022-03-21 06:35:44','2022-03-22 06:35:44','502',0.00,0.00,'502','2022-03-21 20:34:33','502','2022-03-21 21:16:05',10,0),('1','146',257659,'OPERATIONAL LOSS','2022-03-21','2022-03-21 21:16:33','2022-03-22 21:16:33','502',0.00,0.00,'502','2022-03-21 21:23:08','502','2022-03-21 21:23:23',10,0),('1','146',257660,'DAILY SALES NEW STOCK','2022-03-22','2022-03-22 07:14:50','2022-03-23 07:14:50','502',0.00,0.00,'502','2022-03-22 20:35:40','502','2022-03-22 20:36:06',10,0),('1','146',257661,'DAILY SALES','2022-03-23','2022-03-23 06:41:19','2022-03-24 06:41:19','502',0.00,0.00,'502','2022-03-23 20:22:08','502','2022-03-23 20:22:22',10,0),('1','146',257662,'DAILY SALES','2022-03-24','2022-03-24 06:27:56','2022-03-25 06:27:56','502',0.00,0.00,'502','2022-03-24 10:47:21','502','2022-03-24 10:47:35',10,0),('1','146',257663,'DAILY SALES NEW STOCK','2022-03-24','2022-03-24 10:56:12','2022-03-25 10:56:12','502',0.00,0.00,'502','2022-03-24 20:20:23','502','2022-03-24 20:20:38',10,0),('1','146',257664,'DAILY SALES','2022-03-25','2022-03-25 07:07:35','2022-03-26 07:07:35','502',0.00,0.00,'502','2022-03-25 20:59:11','502','2022-03-25 20:59:28',10,0),('1','146',257665,'DAILY SALES','2022-03-26','2022-03-26 07:12:05','2022-03-27 07:12:05','502',0.00,0.00,'502','2022-03-26 13:44:31','502','2022-03-26 13:44:52',10,0),('1','146',257666,'OPERATIONAL LOSS','2022-03-26','2022-03-26 13:45:51','2022-03-27 13:45:51','502',0.00,0.00,'502','2022-03-26 13:49:56','502','2022-03-26 13:50:11',10,0),('1','146',257667,'DAILY SHIFT 2ND SDALES NEW STOCK','2022-03-26','2022-03-26 13:50:34','2022-03-27 13:50:34','502',0.00,0.00,'502','2022-03-27 06:25:32','502','2022-03-27 06:25:55',10,0),('1','146',257668,'DAILY SALES','2022-03-27','2022-03-27 06:26:25','2022-03-28 06:26:25','502',0.00,0.00,'502','2022-03-27 10:43:51','502','2022-03-27 10:44:05',10,0),('1','146',257669,'DAILY SALES NEW PRICE ','2022-03-27','2022-03-27 10:46:12','2022-03-28 10:46:12','502',0.00,0.00,'502','2022-03-27 20:22:26','502','2022-03-27 20:22:42',10,0),('1','146',257670,'DAILY SALES','2022-03-28','2022-03-28 07:03:32','2022-03-29 07:03:32','502',0.00,0.00,'502','2022-03-28 14:45:23','502','2022-03-28 14:46:03',10,0),('1','146',257671,'DAILY SHIFT 2ND SDALES NEW STOCK','2022-03-28','2022-03-28 14:49:36','2022-03-29 14:49:36','502',0.00,0.00,'502','2022-03-28 20:23:27','502','2022-03-28 20:23:49',10,0),('1','146',257672,'DAILY SALES','2022-03-29','2022-03-29 06:15:09','2022-03-30 06:15:09','502',0.00,0.00,'502','2022-03-29 20:36:35','502','2022-03-29 20:36:56',10,0),('1','146',257673,'DAILY SALES','2022-03-30','2022-03-30 06:30:37','2022-03-31 06:30:37','502',0.00,0.00,'502','2022-03-30 11:08:29','502','2022-03-30 11:08:45',10,0),('1','146',257674,'DAILY SHIFT 2ND SDALES NEW STOCK','2022-03-30','2022-03-30 11:10:56','2022-03-31 11:10:56','502',0.00,0.00,'502','2022-03-30 20:48:49','502','2022-03-30 20:49:05',10,0),('1','146',257675,'DAILY SALES','2022-03-31','2022-03-31 06:43:31','2022-04-01 06:43:31','502',0.00,0.00,'502','2022-03-31 20:39:41','502','2022-03-31 20:40:08',10,0),('1','146',257676,'DAILY SALES','2022-04-01','2022-04-01 06:52:11','2022-04-02 06:52:11','502',0.00,0.00,'502','2022-04-01 14:35:03','502','2022-04-01 14:35:21',10,0),('1','146',257677,'DAILY SALES NEW STOCK','2022-04-01','2022-04-01 14:37:44','2022-04-02 14:37:44','502',0.00,0.00,'502','2022-04-01 21:27:50','502','2022-04-01 21:28:05',10,0),('1','146',257678,'DAILY SALES','2022-04-02','2022-04-02 06:19:23','2022-04-03 06:19:23','502',0.00,0.00,'502','2022-04-02 20:27:34','502','2022-04-02 20:28:23',10,0),('1','146',257679,'DAILY SALES NEW STOCK ','2022-04-03','2022-04-03 06:03:44','2022-04-04 06:03:44','502',0.00,0.00,'502','2022-04-04 05:52:08','502','2022-04-04 05:52:28',10,0),('1','146',257680,'DAILY SALES','2022-04-04','2022-04-04 06:00:29','2022-04-05 06:00:29','502',0.00,0.00,'502','2022-04-04 14:58:53','502','2022-04-04 14:59:11',10,0),('1','146',257681,'OPERATIONAL LOSS','2022-04-04','2022-04-04 15:00:17','2022-04-05 15:00:17','502',0.00,0.00,'502','2022-04-04 15:03:29','502','2022-04-04 15:03:47',10,0),('1','146',257682,'DAILY SALES NEW STOCK','2022-04-04','2022-04-04 15:06:03','2022-04-05 15:06:03','502',0.00,0.00,'502','2022-04-04 20:20:54','502','2022-04-04 20:21:22',10,0),('1','146',257683,'DAILY SALES','2022-04-05','2022-04-05 06:27:30','2022-04-06 06:27:30','502',0.00,0.00,'502','2022-04-05 20:28:00','502','2022-04-05 20:28:16',10,0),('1','146',257684,'DAILY SALES','2022-04-06','2022-04-06 07:39:29','2022-04-07 07:39:29','502',0.00,0.00,'502','2022-04-06 13:45:32','502','2022-04-06 13:45:48',10,0),('1','146',257685,'DAILY SHIFT 2ND SALES NEW STOCK','2022-04-06','2022-04-06 13:48:10','2022-04-07 13:48:10','502',0.00,0.00,'502','2022-04-06 20:46:37','502','2022-04-06 20:46:57',10,0),('1','146',257686,'DAILY SALES','2022-04-07','2022-04-07 06:22:55','2022-04-08 06:22:55','502',0.00,0.00,'502','2022-04-07 21:00:49','502','2022-04-07 21:01:10',10,0),('1','146',257687,'DAILY SALES','2022-04-08','2022-04-08 06:37:45','2022-04-09 06:37:45','502',0.00,0.00,'502','2022-04-08 11:20:19','502','2022-04-08 11:20:36',10,0),('1','146',257688,'DAILY SHIFT 2ND SALES NEW STOCK','2022-04-08','2022-04-08 11:22:42','2022-04-09 11:22:42','502',0.00,0.00,'502','2022-04-08 21:28:50','502','2022-04-08 21:29:10',10,0),('1','146',257689,'DAILY SALES','2022-04-09','2022-04-09 06:20:43','2022-04-10 06:20:43','502',0.00,0.00,'502','2022-04-09 17:43:53','502','2022-04-09 17:44:09',10,0),('1','146',257690,'DAILY SHIFT 2ND SDALES NEW STOCK','2022-04-09','2022-04-09 17:50:50','2022-04-10 17:50:50','502',0.00,0.00,'502','2022-04-09 19:51:52','502','2022-04-09 19:52:08',10,0),('1','146',257691,'DAILY SALES','2022-04-10','2022-04-10 06:31:55','2022-04-11 06:31:55','502',0.00,0.00,'502','2022-04-10 20:01:47','502','2022-04-10 20:02:12',10,0),('1','146',257692,'DAILY SALES','2022-04-11','2022-04-11 06:12:36','2022-04-12 06:12:36','502',0.00,0.00,'502','2022-04-11 19:32:41','502','2022-04-11 19:33:01',10,0),('1','146',257693,'DAILY SALES NEW STOCK','2022-04-12','2022-04-12 07:33:29','2022-04-13 07:33:29','502',0.00,0.00,'502','2022-04-12 20:45:49','502','2022-04-12 20:46:27',10,0),('1','146',257694,'DAILY SALES','2022-04-13','2022-04-13 06:03:31','2022-04-14 06:03:31','502',0.00,0.00,'502','2022-04-13 15:38:11','502','2022-04-13 15:38:27',10,0),('1','146',257695,'DAILY SHIFT 2ND SALES NEW STOCK','2022-04-13','2022-04-13 15:39:12','2022-04-14 15:39:12','502',0.00,0.00,'502','2022-04-13 20:12:05','502','2022-04-13 20:12:53',10,0),('1','146',257696,'DAILY SALES','2022-04-14','2022-04-14 06:35:34','2022-04-15 06:35:34','502',0.00,0.00,'502','2022-04-14 20:35:17','502','2022-04-14 20:35:42',10,0),('1','146',257697,'DAILY SALES','2022-04-15','2022-04-15 07:25:51','2022-04-16 07:25:51','502',0.00,0.00,'502','2022-04-15 14:29:50','502','2022-04-15 14:30:14',10,0),('1','146',257698,'DAILY SHIFT 2ND SALES NEW STOCK','2022-04-15','2022-04-15 14:31:17','2022-04-16 14:31:17','502',0.00,0.00,'502','2022-04-15 19:47:47','502','2022-04-15 19:48:13',10,0),('1','146',257699,'DAILY SALES','2022-04-16','2022-04-16 06:01:17','2022-04-17 06:01:17','502',0.00,0.00,'502','2022-04-16 20:37:04','502','2022-04-16 20:39:43',10,0),('1','146',257700,'DAILY SALES','2022-04-17','2022-04-17 06:04:20','2022-04-18 06:04:20','502',0.00,0.00,'502','2022-04-17 15:13:42','502','2022-04-17 15:13:56',10,0),('1','146',257701,'DAILY SHIFT 2ND SALES NEW STOCK','2022-04-17','2022-04-17 15:17:13','2022-04-18 15:17:13','502',0.00,0.00,'502','2022-04-17 19:56:40','502','2022-04-17 19:56:54',10,0),('1','146',257702,'DAILY SALES','2022-04-18','2022-04-18 07:03:51','2022-04-19 07:03:51','502',0.00,0.00,'502','2022-04-18 19:47:24','502','2022-04-18 19:47:38',10,0),('1','146',257703,'DAILY SALES','2022-04-19','2022-04-19 05:59:13','2022-04-20 05:59:13','502',0.00,0.00,'502','2022-04-19 17:55:02','502','2022-04-19 17:55:21',10,0),('1','146',257704,'DAILY SALES NEW STOCK ','2022-04-20','2022-04-20 05:58:53','2022-04-21 05:58:53','502',0.00,0.00,'502','2022-04-20 19:47:07','502','2022-04-20 19:47:49',10,0),('1','146',257705,'DAILY SALES','2022-04-21','2022-04-21 06:07:37','2022-04-22 06:07:37','502',0.00,0.00,'502','2022-04-21 12:41:40','502','2022-04-21 12:41:55',10,0),('1','146',257706,'DAILY SHIFT 2ND SALES NEW STOCK','2022-04-21','2022-04-21 12:44:13','2022-04-22 12:44:13','502',0.00,0.00,'502','2022-04-21 20:13:48','502','2022-04-21 20:14:04',10,0),('1','146',257707,'DAILY SALES','2022-04-22','2022-04-22 06:18:55','2022-04-23 06:18:55','502',0.00,0.00,'502','2022-04-22 20:17:25','502','2022-04-22 20:17:41',10,0),('1','146',257708,'DAILY SALES','2022-04-23','2022-04-23 06:14:54','2022-04-24 06:14:54','502',0.00,0.00,'502','2022-04-23 12:49:22','502','2022-04-23 12:49:39',10,0),('1','146',257709,'DAILY SHIFT 2ND SALES NEW STOCK','2022-04-23','2022-04-23 12:51:56','2022-04-24 12:51:56','502',0.00,0.00,'502','2022-04-23 20:05:16','502','2022-04-23 20:05:50',10,0),('1','146',257710,'DAILY SALES','2022-04-24','2022-04-24 06:38:52','2022-04-25 06:38:52','502',0.00,0.00,'502','2022-04-24 19:52:20','502','2022-04-24 19:52:51',10,0),('1','146',257711,'DAILY SALES','2022-04-25','2022-04-25 06:11:42','2022-04-26 06:11:42','502',0.00,0.00,'502','2022-04-25 16:27:29','502','2022-04-25 16:27:46',10,0),('1','146',257712,'DAILY SHIFT 2ND SALES NEW STOCK','2022-04-25','2022-04-25 16:30:05','2022-04-26 16:30:05','502',0.00,0.00,'502','2022-04-25 20:40:50','502','2022-04-25 20:41:08',10,0),('1','146',257713,'DAILY SALES','2022-04-26','2022-04-26 06:57:01','2022-04-27 06:57:01','502',0.00,0.00,'502','2022-04-26 19:55:53','502','2022-04-26 19:56:35',10,0),('1','146',257714,'DAILY SALES','2022-04-27','2022-04-27 06:04:50','2022-04-28 06:04:50','502',0.00,0.00,'502','2022-04-27 16:36:14','502','2022-04-27 16:46:16',10,0),('1','146',257715,'DAILY 2ND SALES NEW STOCK','2022-04-27','2022-04-27 16:58:29','2022-04-28 16:58:29','502',0.00,0.00,'502','2022-04-27 19:55:41','502','2022-04-27 19:55:57',10,0),('1','146',257716,'DAILY SALES','2022-04-28','2022-04-28 05:53:21','2022-04-29 05:53:21','502',0.00,0.00,'502','2022-04-28 23:39:30','502','2022-04-28 23:40:05',10,0),('1','146',257717,'DAILY SALES','2022-04-29','2022-04-29 06:32:18','2022-04-30 06:32:18','502',0.00,0.00,'502','2022-04-29 15:15:42','502','2022-04-29 15:16:14',10,0),('1','146',257718,'DAILY SHIFT 2ND SALES NEW STOCK','2022-04-29','2022-04-29 15:19:16','2022-04-30 15:19:16','502',0.00,0.00,'502','2022-04-29 20:44:43','502','2022-04-29 20:45:00',10,0),('1','146',257719,'DAILY SALES','2022-04-30','2022-04-30 06:26:44','2022-05-01 06:26:44','502',0.00,0.00,'502','2022-04-30 22:12:27','502','2022-04-30 22:12:44',10,0),('1','146',257720,'OPERATIONAL LOSS','2022-04-30','2022-04-30 22:13:15','2022-05-01 22:13:15','502',0.00,0.00,'502','2022-04-30 22:41:28','502','2022-04-30 22:41:43',10,0),('1','146',257721,'DAILY SALES NEW STOCK ','2022-05-01','2022-05-01 08:17:16','2022-05-02 08:17:16','502',0.00,0.00,'502','2022-05-01 20:19:45','502','2022-05-01 20:20:15',10,0),('1','146',257722,'DAILY SALES','2022-05-02','2022-05-02 11:05:09','2022-05-03 11:05:09','502',0.00,0.00,'502','2022-05-03 00:34:15','502','2022-05-03 00:34:39',10,0),('1','146',257723,'OPERATIONAL LOSS','2022-05-03','2022-05-03 07:08:49','2022-05-04 07:08:49','502',0.00,0.00,'502','2022-05-03 08:39:09','502','2022-05-03 08:39:22',10,0),('1','146',257724,'DAILY SALES NEW STOCK','2022-05-03','2022-05-03 08:45:57','2022-05-04 08:45:57','502',0.00,0.00,'502','2022-05-03 20:41:11','502','2022-05-03 20:41:27',10,0),('1','146',257725,'DAILY SALES','2022-05-04','2022-05-04 05:49:34','2022-05-05 05:49:34','502',0.00,0.00,'502','2022-05-04 20:29:47','502','2022-05-04 20:30:07',10,0),('1','146',257726,'DAILY SALES','2022-05-05','2022-05-05 07:09:29','2022-05-06 07:09:29','502',0.00,0.00,'502','2022-05-05 14:10:33','502','2022-05-05 14:11:27',10,0),('1','146',257727,'OPERATIONAL LOSS','2022-05-05','2022-05-05 14:12:14','2022-05-06 14:12:14','502',0.00,0.00,'502','2022-05-05 14:16:54','502','2022-05-05 14:17:10',10,0),('1','146',257728,'DAILY 2ND SALES NEW STOCK','2022-05-05','2022-05-05 14:20:43','2022-05-06 14:20:43','502',0.00,0.00,'502','2022-05-05 21:32:11','502','2022-05-05 21:32:27',10,0),('1','146',257729,'DAILY SALES','2022-05-06','2022-05-06 06:08:24','2022-05-07 06:08:24','502',0.00,0.00,'502','2022-05-06 20:11:39','502','2022-05-06 20:12:05',10,0),('1','146',257730,'DAILY SALES','2022-05-07','2022-05-07 07:36:13','2022-05-08 07:36:13','502',0.00,0.00,'502','2022-05-07 09:13:30','502','2022-05-07 09:13:48',10,0),('1','146',257731,'OPERATIONAL LOSS','2022-05-07','2022-05-07 09:32:25','2022-05-08 09:32:25','502',0.00,0.00,'502','2022-05-07 09:40:05','502','2022-05-07 09:40:37',10,0),('1','146',257732,'DAILY 2ND SALES NEW STOCK','2022-05-07','2022-05-07 09:49:14','2022-05-08 09:49:14','502',0.00,0.00,'502','2022-05-07 22:27:29','502','2022-05-07 22:27:44',10,0),('1','146',257733,'DAILY SALES','2022-05-08','2022-05-08 06:12:20','2022-05-09 06:12:20','502',0.00,0.00,'502','2022-05-08 20:00:41','502','2022-05-08 20:01:07',10,0),('1','146',257734,'DAILY SALES','2022-05-09','2022-05-09 06:28:01','2022-05-10 06:28:01','502',0.00,0.00,'502','2022-05-09 10:20:12','502','2022-05-09 10:20:29',10,0),('1','146',257735,'OPERATIONAL LOSS','2022-05-09','2022-05-09 10:21:43','2022-05-10 10:21:43','502',0.00,0.00,'502','2022-05-09 10:26:01','502','2022-05-09 10:26:33',10,0),('1','146',257736,'DAILY 2ND SALES NEW STOCK','2022-05-09','2022-05-09 10:29:03','2022-05-10 10:29:03','502',0.00,0.00,'502','2022-05-09 20:34:18','502','2022-05-09 20:34:35',10,0),('1','146',257737,'DAILY SALES','2022-05-10','2022-05-10 05:43:28','2022-05-11 05:43:28','502',0.00,0.00,'502','2022-05-10 16:17:53','502','2022-05-10 16:18:12',10,0),('1','146',257738,'OPERATIONAL LOSS','2022-05-11','2022-05-11 05:30:47','2022-05-12 05:30:47','502',0.00,0.00,'502','2022-05-11 05:35:37','502','2022-05-11 05:35:58',10,0),('1','146',257739,'DAILY SALES','2022-05-12','2022-05-12 06:40:26','2022-05-13 06:40:26','502',0.00,0.00,'502','2022-05-12 21:01:36','502','2022-05-12 21:01:56',10,0),('1','146',257740,'DAILY SALES ','2022-05-13','2022-05-13 06:05:51','2022-05-14 06:05:51','502',0.00,0.00,'502','2022-05-13 10:59:59','502','2022-05-13 11:00:17',10,0),('1','146',257741,'DAILY SHIFT 2ND SALES NEW STOCK','2022-05-13','2022-05-13 11:02:31','2022-05-14 11:02:31','502',0.00,0.00,'502','2022-05-13 20:08:48','502','2022-05-13 20:09:18',10,0),('1','146',257742,'DAILY SALES','2022-05-14','2022-05-14 06:05:14','2022-05-15 06:05:14','502',0.00,0.00,'502','2022-05-14 20:39:28','502','2022-05-14 20:39:48',10,0),('1','146',257743,'OPERATIONAL LOSS','2022-05-14','2022-05-14 22:53:08','2022-05-15 22:53:08','502',0.00,0.00,'502','2022-05-14 22:59:06','502','2022-05-14 22:59:22',10,0),('1','146',257744,'DAILY SALES','2022-05-15','2022-05-15 06:36:17','2022-05-16 06:36:17','502',0.00,0.00,'502','2022-05-15 20:06:27','502','2022-05-15 20:06:43',10,0),('1','146',257745,'DAILY SALES','2022-05-16','2022-05-16 06:19:19','2022-05-17 06:19:19','502',0.00,0.00,'502','2022-05-16 16:43:01','502','2022-05-16 16:43:29',10,0),('1','146',257746,'DAILY SALES','2022-05-17','2022-05-17 06:20:37','2022-05-18 06:20:37','502',0.00,0.00,'502','2022-05-17 20:56:37','502','2022-05-17 20:57:03',10,0),('1','146',257747,'DAILY SALES','2022-05-18','2022-05-18 05:45:43','2022-05-19 05:45:43','502',0.00,0.00,'502','2022-05-18 16:38:59','502','2022-05-18 16:40:36',10,0),('1','146',257748,'DAILY SHIFT 2ND SDALES NEW STOCK','2022-05-18','2022-05-18 17:39:57','2022-05-19 17:39:57','502',0.00,0.00,'502','2022-05-18 21:07:01','502','2022-05-18 21:07:24',10,0),('1','146',257749,'DAILY SALES','2022-05-19','2022-05-19 06:31:40','2022-05-20 06:31:40','502',0.00,0.00,'502','2022-05-19 20:43:10','502','2022-05-19 20:43:34',10,0),('1','146',257750,'DAILY SALES','2022-05-20','2022-05-20 06:08:40','2022-05-21 06:08:40','502',0.00,0.00,'502','2022-05-20 16:54:55','502','2022-05-20 16:55:11',10,0),('1','146',257751,'DAILY SALES NEW STOCK','2022-05-21','2022-05-21 05:40:59','2022-05-22 05:40:59','502',0.00,0.00,'502','2022-05-21 21:30:45','502','2022-05-21 21:31:02',10,0),('1','146',257752,'DAILY SALES','2022-05-22','2022-05-22 06:04:34','2022-05-23 06:04:34','502',0.00,0.00,'502','2022-05-22 13:32:47','502','2022-05-22 13:33:03',10,0),('1','146',257753,'DAILY 2ND SALES NEW STOCK','2022-05-22','2022-05-22 13:34:55','2022-05-23 13:34:55','502',0.00,0.00,'502','2022-05-22 21:26:57','502','2022-05-22 21:27:16',10,0),('1','146',257754,'DAILY SALES','2022-05-23','2022-05-23 05:38:07','2022-05-24 05:38:07','502',0.00,0.00,'502','2022-05-23 20:43:00','502','2022-05-23 20:43:19',10,0),('1','146',257755,'DAILY SALES','2022-05-24','2022-05-24 05:58:05','2022-05-25 05:58:05','502',0.00,0.00,'502','2022-05-24 16:49:06','502','2022-05-24 16:49:21',10,0),('1','146',257756,'OPERATIONAL LOSS','2022-05-24','2022-05-24 16:49:51','2022-05-25 16:49:51','502',0.00,0.00,'502','2022-05-24 16:52:09','502','2022-05-24 16:52:30',10,0),('1','146',257757,'DAILY SALES NEW STOCK ','2022-05-24','2022-05-24 16:54:09','2022-05-25 16:54:09','502',0.00,0.00,'502','2022-05-24 19:52:50','502','2022-05-24 19:53:06',10,0),('1','146',257758,'DAILY SALES','2022-05-25','2022-05-25 06:04:23','2022-05-26 06:04:23','502',0.00,0.00,'502','2022-05-25 11:21:03','502','2022-05-25 11:21:25',10,0),('1','146',257759,'DAILY SALES','2022-05-25','2022-05-25 11:22:58','2022-05-26 11:22:58','502',0.00,0.00,'502','2022-05-25 15:00:21','502','2022-05-25 15:00:40',10,0),('1','146',257760,'OPERATIONAL LOSS','2022-05-25','2022-05-25 15:01:21','2022-05-26 15:01:21','502',0.00,0.00,'502','2022-05-25 15:08:18','502','2022-05-25 15:08:33',10,0),('1','146',257761,'DAILY SHIFT 2ND SDALES NEW STOCK','2022-05-25','2022-05-25 16:27:54','2022-05-26 16:27:54','502',0.00,0.00,'502','2022-05-25 20:38:28','502','2022-05-25 20:38:48',10,0),('1','146',257762,'DAILY SALES','2022-05-26','2022-05-26 06:11:13','2022-05-27 06:11:13','502',0.00,0.00,'502','2022-05-26 20:21:51','502','2022-05-26 20:22:13',10,0),('1','146',257763,'DAILY SALES','2022-05-27','2022-05-27 05:53:12','2022-05-28 05:53:12','502',0.00,0.00,'502','2022-05-27 17:37:57','502','2022-05-27 17:38:16',10,0),('1','146',257764,'OPERATIONAL LOSS','2022-05-27','2022-05-27 17:39:10','2022-05-28 17:39:10','502',0.00,0.00,'502','2022-05-27 17:43:31','502','2022-05-27 17:43:48',10,0),('1','146',257765,'DAILY SHIFT 2ND SDALES NEW STOCK','2022-05-27','2022-05-27 18:20:00','2022-05-28 18:20:00','502',0.00,0.00,'502','2022-05-27 19:18:26','502','2022-05-27 19:18:45',10,0),('1','146',257766,'DAILY SALES','2022-05-28','2022-05-28 05:56:55','2022-05-29 05:56:55','502',0.00,0.00,'502','2022-05-28 20:19:15','502','2022-05-28 20:19:33',10,0),('1','146',257767,'DAILY SALES','2022-05-29','2022-05-29 07:20:20','2022-05-30 07:20:20','502',0.00,0.00,'502','2022-05-29 15:32:42','502','2022-05-29 15:32:58',10,0),('1','146',257768,'OPERATIONAL LOSS','2022-05-29','2022-05-29 15:33:22','2022-05-30 15:33:22','502',0.00,0.00,'502','2022-05-29 15:36:36','502','2022-05-29 15:36:50',10,0),('1','146',257769,'DAILY SHIFT 2ND SALES NEW STOCK','2022-05-29','2022-05-29 15:39:46','2022-05-30 15:39:46','502',0.00,0.00,'502','2022-05-29 20:41:16','502','2022-05-29 20:41:30',10,0),('1','146',257770,'DAILY SALES','2022-05-30','2022-05-30 06:12:42','2022-05-31 06:12:42','502',0.00,0.00,'502','2022-05-30 20:26:41','502','2022-05-30 20:26:58',10,0),('1','146',257771,'DAILY SALES','2022-05-31','2022-05-31 05:56:47','2022-06-01 05:56:47','502',0.00,0.00,'502','2022-05-31 10:58:20','502','2022-05-31 10:58:40',10,0),('1','146',257772,'OPERATIONAL LOSS','2022-05-31','2022-05-31 10:59:28','2022-06-01 10:59:28','502',0.00,0.00,'502','2022-05-31 11:05:16','502','2022-05-31 11:05:34',10,0),('1','146',257773,'DAILY SHIFT 2ND SALES NEW STOCK','2022-05-31','2022-05-31 14:17:46','2022-06-01 14:17:46','502',0.00,0.00,'502','2022-05-31 20:18:39','502','2022-05-31 20:18:58',10,0),('1','146',257774,'DAILY 2ND SALES NEW STOCK','2022-06-01','2022-06-01 06:05:18','2022-06-02 06:05:18','502',0.00,0.00,'502','2022-06-01 20:33:48','502','2022-06-01 20:34:16',10,0),('1','146',257775,'OPERATIONAL LOSS','2022-06-02','2022-06-02 09:26:16','2022-06-03 09:26:16','502',0.00,0.00,'502','2022-06-02 09:31:55','502','2022-06-02 09:32:14',10,0),('1','146',257776,'DAILY SALES','2022-06-02','2022-06-02 09:41:02','2022-06-03 09:41:02','502',0.00,0.00,'502','2022-06-02 20:57:11','502','2022-06-02 20:57:36',10,0),('1','146',257777,'DAILY SALES','2022-06-03','2022-06-03 05:56:43','2022-06-04 05:56:43','502',0.00,0.00,'502','2022-06-03 17:19:23','502','2022-06-03 17:20:12',10,0),('1','146',257778,'OPERATIONAL LOSS','2022-06-03','2022-06-03 17:23:00','2022-06-04 17:23:00','502',0.00,0.00,'502','2022-06-03 17:53:57','502','2022-06-03 17:54:10',10,0),('1','146',257779,'DAILY SHIFT 2ND SDALES NEW STOCK','2022-06-03','2022-06-03 18:26:29','2022-06-04 18:26:29','502',0.00,0.00,'502','2022-06-03 20:28:18','502','2022-06-03 20:28:58',10,0),('1','146',257780,'DAILY SALES','2022-06-04','2022-06-04 05:54:07','2022-06-05 05:54:07','502',0.00,0.00,'502','2022-06-04 21:29:16','502','2022-06-04 21:29:36',10,0),('1','146',257781,'DAILY SALES','2022-06-05','2022-06-05 06:10:51','2022-06-06 06:10:51','502',0.00,0.00,'502','2022-06-05 11:23:07','502','2022-06-05 11:23:24',10,0),('1','146',257782,'OPERATIONAL LOSS','2022-06-05','2022-06-05 11:24:01','2022-06-06 11:24:01','502',0.00,0.00,'502','2022-06-05 11:28:00','502','2022-06-05 11:28:15',10,0),('1','146',257783,'DAILY SHIFT 2ND SALES NEW STOCK','2022-06-05','2022-06-05 14:40:08','2022-06-06 14:40:08','502',0.00,0.00,'502','2022-06-05 20:41:21','502','2022-06-05 20:41:39',10,0),('1','146',257784,'DAILY SALES','2022-06-06','2022-06-06 05:29:33','2022-06-07 05:29:33','502',0.00,0.00,'502','2022-06-06 21:10:33','502','2022-06-06 21:11:01',10,0),('1','146',257785,'DAILY SALES','2022-06-07','2022-06-07 06:14:34','2022-06-08 06:14:34','502',0.00,0.00,'502','2022-06-07 12:42:55','502','2022-06-07 12:43:18',10,0),('1','146',257786,'OPERATIONAL LOSS','2022-06-07','2022-06-07 12:46:05','2022-06-08 12:46:05','502',0.00,0.00,'502','2022-06-07 12:48:45','502','2022-06-07 12:49:03',10,0),('1','146',257787,'DAILY SALES NEW STOCK','2022-06-07','2022-06-07 12:51:00','2022-06-08 12:51:00','502',0.00,0.00,'502','2022-06-08 08:27:34','502','2022-06-08 08:27:51',10,0),('1','146',257788,'DAILY SALES','2022-06-08','2022-06-08 08:28:09','2022-06-09 08:28:09','502',0.00,0.00,'502','2022-06-08 20:23:29','502','2022-06-08 20:23:48',10,0),('1','146',257789,'OPERATIONAL LOSS','2022-06-09','2022-06-09 10:30:14','2022-06-10 10:30:14','502',0.00,0.00,'502','2022-06-09 10:36:22','502','2022-06-09 10:36:44',10,0),('1','146',257790,'DAILY SALES','2022-06-09','2022-06-09 10:37:05','2022-06-10 10:37:05','502',0.00,0.00,'502','2022-06-09 22:23:36','502','2022-06-09 22:23:52',10,0),('1','146',257791,'DAILY SALES','2022-06-10','2022-06-10 06:46:36','2022-06-11 06:46:36','502',0.00,0.00,'502','2022-06-10 17:32:18','502','2022-06-10 17:32:36',10,0),('1','146',257792,'OPERATIONAL LOSS','2022-06-10','2022-06-10 17:33:10','2022-06-11 17:33:10','502',0.00,0.00,'502','2022-06-10 17:40:22','502','2022-06-10 17:40:41',10,0),('1','146',257793,'DAILY SALES NEW STOCK','2022-06-10','2022-06-10 18:02:35','2022-06-11 18:02:35','502',0.00,0.00,'502','2022-06-11 07:19:37','502','2022-06-11 07:20:00',10,0),('1','146',257794,'DAILY SALES','2022-06-11','2022-06-11 07:20:26','2022-06-12 07:20:26','502',0.00,0.00,'502','2022-06-11 20:22:22','502','2022-06-11 20:25:33',10,0),('1','146',257795,'DAILY SALES','2022-06-12','2022-06-12 05:28:57','2022-06-13 05:28:57','502',0.00,0.00,'502','2022-06-12 16:31:18','502','2022-06-12 16:31:37',10,0),('1','146',257796,'DAILY SALES','2022-06-13','2022-06-13 06:04:05','2022-06-14 06:04:05','502',0.00,0.00,'502','2022-06-13 21:23:53','502','2022-06-13 21:24:11',10,0),('1','146',257797,'DAILY SALES','2022-06-14','2022-06-14 06:01:57','2022-06-15 06:01:57','502',0.00,0.00,'502','2022-06-14 16:22:36','502','2022-06-14 16:23:07',10,0),('1','146',257798,'OPERATIONAL LOSS','2022-06-14','2022-06-14 16:26:07','2022-06-15 16:26:07','502',0.00,0.00,'502','2022-06-14 16:29:42','502','2022-06-14 16:29:58',10,0),('1','146',257799,'DAILY SHIFT 2ND SALES NEW STOCK','2022-06-14','2022-06-14 16:32:21','2022-06-15 16:32:21','502',0.00,0.00,'502','2022-06-14 20:43:34','502','2022-06-14 20:44:16',10,0),('1','146',257800,'DAILY SALES','2022-06-15','2022-06-15 06:08:45','2022-06-16 06:08:45','502',0.00,0.00,'502','2022-06-15 20:24:22','502','2022-06-15 20:24:52',10,0),('1','146',257801,'DAILY SALES','2022-06-16','2022-06-16 06:14:49','2022-06-17 06:14:49','502',0.00,0.00,'502','2022-06-16 14:42:29','502','2022-06-16 14:42:47',10,0),('1','146',257802,'DAILY SALES','2022-06-17','2022-06-17 06:31:29','2022-06-18 06:31:29','502',0.00,0.00,'502','2022-06-17 20:40:00','502','2022-06-17 20:40:29',10,0),('1','146',257803,'DAILY SALES','2022-06-18','2022-06-18 06:36:11','2022-06-19 06:36:11','502',0.00,0.00,'502','2022-06-18 17:09:51','502','2022-06-18 17:10:08',10,0),('1','146',257804,'OPERATIONAL LOSS','2022-06-18','2022-06-18 17:10:58','2022-06-19 17:10:58','502',0.00,0.00,'502','2022-06-18 17:15:08','502','2022-06-18 17:15:25',10,0),('1','146',257805,'DAILY SHIFT 2ND SALES NEW STOCK','2022-06-18','2022-06-18 17:17:44','2022-06-19 17:17:44','502',0.00,0.00,'502','2022-06-18 20:19:49','502','2022-06-18 20:20:08',10,0),('1','146',257806,'DAILY SALES','2022-06-19','2022-06-19 06:17:35','2022-06-20 06:17:35','502',0.00,0.00,'502','2022-06-19 20:40:07','502','2022-06-19 20:40:43',10,0),('1','146',257807,'DAILY SALES','2022-06-20','2022-06-20 05:59:04','2022-06-21 05:59:04','502',0.00,0.00,'502','2022-06-20 17:51:45','502','2022-06-20 17:52:05',10,0),('1','146',257808,'DAILY SHIFT 2ND SDALES NEW STOCK','2022-06-20','2022-06-20 17:54:50','2022-06-21 17:54:50','502',0.00,0.00,'502','2022-06-20 17:55:12','502','2022-06-20 17:55:29',10,0),('1','146',257809,'OPERATIONAL LOSS','2022-06-20','2022-06-20 17:55:55','2022-06-21 17:55:55','502',0.00,0.00,'502','2022-06-21 06:03:08','502','2022-06-21 06:03:22',10,0),('1','146',257810,'DAILY SALES','2022-06-21','2022-06-21 06:03:47','2022-06-22 06:03:47','502',0.00,0.00,'502','2022-06-21 20:44:39','502','2022-06-21 20:45:05',10,0),('1','146',257811,'DAILY SALES','2022-06-22','2022-06-22 05:54:50','2022-06-23 05:54:50','502',0.00,0.00,'502','2022-06-22 17:42:47','502','2022-06-22 17:43:04',10,0),('1','146',257812,'OPERATIONAL LOSS','2022-06-22','2022-06-22 17:43:27','2022-06-23 17:43:27','502',0.00,0.00,'502','2022-06-22 18:01:11','502','2022-06-22 18:01:27',10,0),('1','146',257813,'DAILY 2ND SALES NEW STOCK','2022-06-22','2022-06-22 18:01:59','2022-06-23 18:01:59','502',0.00,0.00,'502','2022-06-22 20:29:48','502','2022-06-22 20:30:07',10,0),('1','146',257814,'DAILY SALES NEW STOCK','2022-06-23','2022-06-23 07:43:23','2022-06-24 07:43:23','502',0.00,0.00,'502','2022-06-23 20:11:46','502','2022-06-23 20:12:14',10,0),('1','146',257815,'DAILY SALES','2022-06-24','2022-06-24 08:12:45','2022-06-25 08:12:45','502',0.00,0.00,'502','2022-06-24 22:19:23','502','2022-06-24 22:20:24',10,0),('1','146',257816,'OPERATIONAL LOSS','2022-06-24','2022-06-24 22:28:31','2022-06-25 22:28:31','502',0.00,0.00,'502','2022-06-24 22:32:50','502','2022-06-24 22:33:05',10,0),('1','146',257817,'DAILY SALES','2022-06-25','2022-06-25 05:24:22','2022-06-26 05:24:22','502',0.00,0.00,'502','2022-06-25 20:08:07','502','2022-06-25 20:09:13',10,0),('1','146',257818,'DAILY SALES','2022-06-26','2022-06-26 05:49:41','2022-06-27 05:49:41','502',0.00,0.00,'502','2022-06-26 19:31:38','502','2022-06-26 19:31:55',10,0),('1','146',257819,'OPERATIONAL LOSS','2022-06-27','2022-06-27 01:33:36','2022-06-28 01:33:36','502',0.00,0.00,'502','2022-06-27 01:38:25','502','2022-06-27 01:38:43',10,0),('1','146',257820,'DAILY SALES','2022-06-27','2022-06-27 05:45:56','2022-06-28 05:45:56','502',0.00,0.00,'502','2022-06-28 06:01:36','502','2022-06-28 06:02:02',10,0),('1','146',257821,'DAILY SALES','2022-06-28','2022-06-28 06:02:25','2022-06-29 06:02:25','502',0.00,0.00,'502','2022-06-28 16:26:33','502','2022-06-28 16:26:55',10,0),('1','146',257822,'OPERATIONAL LOSS','2022-06-28','2022-06-28 16:27:23','2022-06-29 16:27:23','502',0.00,0.00,'502','2022-06-28 16:32:14','502','2022-06-28 16:32:30',10,0),('1','146',257823,'DAILY SHIFT 2ND SDALES NEW STOCK','2022-06-28','2022-06-28 16:35:14','2022-06-29 16:35:14','502',0.00,0.00,'502','2022-06-28 21:02:54','502','2022-06-28 21:03:17',10,0),('1','146',257824,'DAILY SALES','2022-06-29','2022-06-29 05:58:39','2022-06-30 05:58:39','502',0.00,0.00,'502','2022-06-29 20:26:34','502','2022-06-29 20:26:52',10,0),('1','146',257825,'DAILY SALES','2022-06-30','2022-06-30 06:00:21','2022-07-01 06:00:21','502',0.00,0.00,'502','2022-06-30 10:44:14','502','2022-06-30 10:44:43',10,0),('1','146',257826,'OPERATIONAL LOSS','2022-06-30','2022-06-30 10:45:14','2022-07-01 10:45:14','502',0.00,0.00,'502','2022-06-30 10:48:54','502','2022-06-30 10:49:13',10,0),('1','146',257827,'DAILY SHIFT 2ND SALES NEW STOCK','2022-06-30','2022-06-30 10:51:21','2022-07-01 10:51:21','502',0.00,0.00,'502','2022-06-30 23:19:55','502','2022-06-30 23:20:11',10,0),('1','146',257828,'DAILY SALES','2022-07-01','2022-07-01 05:36:24','2022-07-02 05:36:24','502',0.00,0.00,'502','2022-07-01 17:53:32','502','2022-07-01 17:53:58',10,0),('1','146',257829,'OPERATIONAL LOSS','2022-07-01','2022-07-01 17:54:25','2022-07-02 17:54:25','502',0.00,0.00,'502','2022-07-01 17:57:45','502','2022-07-01 17:58:01',10,0),('1','146',257830,'DAILY SHIFT 2ND SALES NEW STOCK','2022-07-01','2022-07-01 18:01:05','2022-07-02 18:01:05','502',0.00,0.00,'502','2022-07-01 21:14:39','502','2022-07-01 21:15:14',10,0),('1','146',257831,'DAILY SALES','2022-07-02','2022-07-02 05:52:25','2022-07-03 05:52:25','502',0.00,0.00,'502','2022-07-03 05:53:57','502','2022-07-03 05:56:28',10,0),('1','146',257832,'DAILY SALES','2022-07-03','2022-07-03 06:03:29','2022-07-04 06:03:29','502',0.00,0.00,'502','2022-07-03 13:24:54','502','2022-07-03 13:25:10',10,0),('1','146',257833,'DAILY SHIFT 2ND SALES NEW STOCK','2022-07-03','2022-07-03 13:30:24','2022-07-04 13:30:24','502',0.00,0.00,'502','2022-07-03 20:59:28','502','2022-07-03 20:59:50',10,0),('1','146',257834,'DAILY SALES','2022-07-04','2022-07-04 06:29:45','2022-07-05 06:29:45','502',0.00,0.00,'502','2022-07-04 20:51:46','502','2022-07-04 20:52:11',10,0),('1','146',257835,'DAILY SALES','2022-07-05','2022-07-05 06:02:16','2022-07-06 06:02:16','502',0.00,0.00,'502','2022-07-05 08:28:22','502','2022-07-05 08:28:41',10,0),('1','146',257836,'DAILY 2ND SALES NEW STOCK','2022-07-05','2022-07-05 08:31:22','2022-07-06 08:31:22','502',0.00,0.00,'502','2022-07-05 20:57:50','502','2022-07-05 20:58:09',10,0),('1','146',257837,'DAILY SALES','2022-07-06','2022-07-06 06:00:03','2022-07-07 06:00:03','502',0.00,0.00,'502','2022-07-06 17:50:36','502','2022-07-06 17:50:58',10,0),('1','146',257838,'DAILY 2ND SALES NEW STOCK','2022-07-06','2022-07-06 18:34:34','2022-07-07 18:34:34','502',0.00,0.00,'502','2022-07-06 19:58:49','502','2022-07-06 19:59:49',10,0),('1','146',257839,'DAILY SALES','2022-07-07','2022-07-07 06:39:05','2022-07-08 06:39:05','502',0.00,0.00,'502','2022-07-07 20:29:15','502','2022-07-07 20:29:42',10,0),('1','146',257840,'DAILY SALES','2022-07-08','2022-07-08 06:04:54','2022-07-09 06:04:54','502',0.00,0.00,'502','2022-07-08 16:56:20','502','2022-07-08 16:56:42',10,0),('1','146',257841,'DAILY SALES','2022-07-08','2022-07-08 17:02:27','2022-07-09 17:02:27','502',0.00,0.00,'502','2022-07-08 21:30:59','502','2022-07-08 21:31:30',10,0),('1','146',257842,'DAILY SALES','2022-07-09','2022-07-09 09:44:57','2022-07-10 09:44:57','502',0.00,0.00,'502','2022-07-09 20:18:14','502','2022-07-09 20:18:45',10,0),('1','146',257843,'DAILY SALES','2022-07-10','2022-07-10 05:58:03','2022-07-11 05:58:03','502',0.00,0.00,'502','2022-07-10 17:59:42','502','2022-07-10 18:00:20',10,0),('1','146',257844,'DAILY SHIFT 2ND SDALES NEW STOCK','2022-07-10','2022-07-10 18:22:16','2022-07-11 18:22:16','502',0.00,0.00,'502','2022-07-10 20:08:56','502','2022-07-10 20:09:39',10,0),('1','146',257845,'DAILY SALES','2022-07-11','2022-07-11 05:54:58','2022-07-12 05:54:58','502',0.00,0.00,'502','2022-07-11 20:28:26','502','2022-07-11 20:29:02',10,0),('1','146',257846,'DAILY SALES','2022-07-12','2022-07-12 05:43:00','2022-07-13 05:43:00','502',0.00,0.00,'502','2022-07-12 20:02:16','502','2022-07-12 20:02:54',10,0),('1','146',257847,'DAILY SALES','2022-07-13','2022-07-13 05:48:14','2022-07-14 05:48:14','502',0.00,0.00,'502','2022-07-13 13:40:48','502','2022-07-13 13:41:18',10,0),('1','146',257848,'DAILY SHIFT 2ND SALES NEW STOCK','2022-07-13','2022-07-13 13:44:41','2022-07-14 13:44:41','502',0.00,0.00,'502','2022-07-13 19:36:46','502','2022-07-13 19:37:21',10,0),('1','146',257849,'DAILY SALES','2022-07-14','2022-07-14 05:30:04','2022-07-15 05:30:04','502',0.00,0.00,'502','2022-07-14 20:28:09','502','2022-07-14 20:28:33',10,0),('1','146',257850,'DAILY SALES','2022-07-15','2022-07-15 05:43:29','2022-07-16 05:43:29','502',0.00,0.00,'502','2022-07-15 15:29:12','502','2022-07-15 15:30:12',10,0),('1','146',257851,'OPERATIONAL LOSS','2022-07-15','2022-07-15 15:35:57','2022-07-16 15:35:57','502',0.00,0.00,'502','2022-07-15 15:43:32','502','2022-07-15 15:44:19',10,0),('1','146',257852,'DAILY SHIFT 2ND SALES NEW STOCK','2022-07-15','2022-07-15 15:48:02','2022-07-16 15:48:02','502',0.00,0.00,'502','2022-07-15 19:58:41','502','2022-07-15 19:59:16',10,0),('1','146',257853,'DAILY SALES','2022-07-16','2022-07-16 05:34:53','2022-07-17 05:34:53','502',0.00,0.00,'502','2022-07-16 19:45:13','502','2022-07-16 19:45:58',10,0),('1','146',257854,'DAILY SALES','2022-07-17','2022-07-17 06:20:19','2022-07-18 06:20:19','502',0.00,0.00,'502','2022-07-17 16:19:55','502','2022-07-17 16:20:11',10,0),('1','146',257855,'DAILY SHIFT 2ND SALES NEW STOCK','2022-07-17','2022-07-17 16:20:31','2022-07-18 16:20:31','502',0.00,0.00,'502','2022-07-17 19:52:28','502','2022-07-17 19:52:49',10,0),('1','146',257856,'Daily sales','2022-07-18','2022-07-18 06:04:03','2022-07-19 06:04:03','502',0.00,0.00,'502','2022-07-18 20:28:37','502','2022-07-18 20:29:09',10,0),('1','146',257857,'DAILY SALES','2022-07-19','2022-07-19 05:53:13','2022-07-20 05:53:13','502',0.00,0.00,'502','2022-07-19 12:50:37','502','2022-07-19 12:50:56',10,0),('1','146',257858,'NEW STOCK DAILY SALES','2022-07-19','2022-07-19 12:54:49','2022-07-20 12:54:49','502',0.00,0.00,'502','2022-07-19 20:31:30','502','2022-07-19 20:31:54',10,0),('1','146',257859,'Daily sales','2022-07-20','2022-07-20 06:01:02','2022-07-21 06:01:02','502',0.00,0.00,'502','2022-07-20 19:43:39','502','2022-07-20 19:44:17',10,0),('1','146',257860,'Daily sales','2022-07-21','2022-07-21 06:04:45','2022-07-22 06:04:45','502',0.00,0.00,'502','2022-07-21 13:38:32','502','2022-07-21 13:38:53',10,0),('1','146',257861,'OPERATIONAL LOSS','2022-07-21','2022-07-21 13:39:34','2022-07-22 13:39:34','502',0.00,0.00,'502','2022-07-21 13:44:18','502','2022-07-21 13:44:49',10,0),('1','146',257862,'NEW STOCK DAILY SALES','2022-07-21','2022-07-21 13:45:25','2022-07-22 13:45:25','502',0.00,0.00,'502','2022-07-21 20:02:18','502','2022-07-21 20:02:40',10,0),('1','146',257863,'Daily sales','2022-07-22','2022-07-22 08:41:29','2022-07-23 08:41:29','502',0.00,0.00,'502','2022-07-22 20:17:15','502','2022-07-22 20:19:54',10,0),('1','146',257864,'DAILY SALES','2022-07-23','2022-07-23 06:08:34','2022-07-24 06:08:34','502',0.00,0.00,'502','2022-07-23 13:54:54','502','2022-07-23 13:55:10',10,0),('1','146',257865,'OPERATIONAL LOSS','2022-07-23','2022-07-23 13:56:14','2022-07-24 13:56:14','502',0.00,0.00,'502','2022-07-23 13:59:06','502','2022-07-23 13:59:46',10,0),('1','146',257866,'NEW STOCK DAILY SALES','2022-07-23','2022-07-23 14:02:51','2022-07-24 14:02:51','502',0.00,0.00,'502','2022-07-23 20:43:55','502','2022-07-23 20:44:15',10,0),('1','146',257867,'DAILY SALES','2022-07-24','2022-07-24 05:41:14','2022-07-25 05:41:14','502',0.00,0.00,'502','2022-07-24 20:04:21','502','2022-07-24 20:04:51',10,0),('1','146',257868,'DAILY SALES','2022-07-25','2022-07-25 06:47:59','2022-07-26 06:47:59','502',0.00,0.00,'502','2022-07-25 12:35:53','502','2022-07-25 12:36:14',10,0),('1','146',257869,'NEW STOCK DAILY SALES','2022-07-25','2022-07-25 12:39:05','2022-07-26 12:39:05','502',0.00,0.00,'502','2022-07-25 20:03:06','502','2022-07-25 20:03:51',10,0),('1','146',257870,'DAILY SALES','2022-07-26','2022-07-26 05:58:56','2022-07-27 05:58:56','502',0.00,0.00,'502','2022-07-26 20:42:11','502','2022-07-26 20:42:43',10,0),('1','146',257871,'DAILY SALES','2022-07-27','2022-07-27 05:49:18','2022-07-28 05:49:18','502',0.00,0.00,'502','2022-07-27 10:12:05','502','2022-07-27 10:12:20',10,0),('1','146',257872,'DAILY 2ND SALES NEW STOCK','2022-07-27','2022-07-27 10:14:12','2022-07-28 10:14:12','502',0.00,0.00,'502','2022-07-27 20:31:28','502','2022-07-27 20:32:01',10,0),('1','146',257873,'Daily sales','2022-07-28','2022-07-28 06:13:59','2022-07-29 06:13:59','502',0.00,0.00,'502','2022-07-28 21:01:15','502','2022-07-28 21:02:25',10,0),('1','146',257874,'DAILY SALES','2022-07-29','2022-07-29 06:40:21','2022-07-30 06:40:21','502',0.00,0.00,'502','2022-07-29 11:03:38','502','2022-07-29 11:03:55',10,0),('1','146',257875,'NEW STOCK DAILY SALES','2022-07-29','2022-07-29 11:16:48','2022-07-30 11:16:48','502',0.00,0.00,'502','2022-07-29 20:45:17','502','2022-07-29 20:45:37',10,0),('1','146',257876,'DAILY SALES','2022-07-30','2022-07-30 06:21:25','2022-07-31 06:21:25','502',0.00,0.00,'502','2022-07-30 20:15:53','502','2022-07-30 20:16:19',10,0),('1','146',257877,'Daily sales','2022-07-31','2022-07-31 06:04:56','2022-08-01 06:04:56','502',0.00,0.00,'502','2022-07-31 11:09:20','502','2022-07-31 11:09:36',10,0),('1','146',257878,'NEW STOCK DAILY SALES','2022-07-31','2022-07-31 13:59:04','2022-08-01 13:59:04','502',0.00,0.00,'502','2022-07-31 20:27:05','502','2022-07-31 20:27:43',10,0),('1','146',257879,'DAILY SALES','2022-08-01','2022-08-01 05:38:45','2022-08-02 05:38:45','502',0.00,0.00,'502','2022-08-01 20:05:01','502','2022-08-01 20:05:26',10,0),('1','146',257880,'Daily sales','2022-08-02','2022-08-02 05:53:09','2022-08-03 05:53:09','502',0.00,0.00,'502','2022-08-02 09:54:14','502','2022-08-02 09:54:31',10,0),('1','146',257881,'DAILY 2ND SALES NEW STOCK','2022-08-02','2022-08-02 10:14:14','2022-08-03 10:14:14','502',0.00,0.00,'502','2022-08-02 20:50:57','502','2022-08-02 20:51:19',10,0),('1','146',257882,'DAILY SALES','2022-08-03','2022-08-03 06:06:04','2022-08-04 06:06:04','502',0.00,0.00,'502','2022-08-03 20:03:54','502','2022-08-03 20:04:17',10,0),('1','146',257883,'Daily sales','2022-08-04','2022-08-04 06:03:29','2022-08-05 06:03:29','502',0.00,0.00,'502','2022-08-04 20:42:25','502','2022-08-04 20:42:50',10,0),('1','146',257884,'DAILY SALES','2022-08-05','2022-08-05 06:14:36','2022-08-06 06:14:36','502',0.00,0.00,'502','2022-08-05 15:30:35','502','2022-08-05 15:30:54',10,0),('1','146',257885,'NEW STOCK DAILY SALES','2022-08-05','2022-08-05 15:33:38','2022-08-06 15:33:38','502',0.00,0.00,'502','2022-08-05 20:30:53','502','2022-08-05 20:31:19',10,0),('1','146',257886,'DAILY SALES','2022-08-06','2022-08-06 06:20:07','2022-08-07 06:20:07','502',0.00,0.00,'502','2022-08-06 20:39:34','502','2022-08-06 20:40:03',10,0),('1','146',257887,'DAILY SALES','2022-08-07','2022-08-07 05:52:22','2022-08-08 05:52:22','502',0.00,0.00,'502','2022-08-07 10:16:40','502','2022-08-07 10:16:59',10,0),('1','146',257888,'DAILY 2ND SALES NEW STOCK','2022-08-07','2022-08-07 10:19:10','2022-08-08 10:19:10','502',0.00,0.00,'502','2022-08-07 20:45:10','502','2022-08-07 20:45:27',10,0),('1','146',257889,'Daily sales','2022-08-08','2022-08-08 06:03:52','2022-08-09 06:03:52','502',0.00,0.00,'502','2022-08-08 14:12:23','502','2022-08-08 14:12:53',10,0),('1','146',257890,'NEW STOCK DAILY SALES','2022-08-08','2022-08-08 14:15:06','2022-08-09 14:15:06','502',0.00,0.00,'502','2022-08-08 21:04:20','502','2022-08-08 21:04:49',10,0),('1','146',257891,'DAILY SALES','2022-08-09','2022-08-09 05:54:06','2022-08-10 05:54:06','502',0.00,0.00,'502','2022-08-09 20:11:19','502','2022-08-09 20:11:58',10,0),('1','146',257892,'Daily sales','2022-08-10','2022-08-10 05:48:39','2022-08-11 05:48:39','502',0.00,0.00,'502','2022-08-10 11:11:58','502','2022-08-10 11:12:19',10,0),('1','146',257893,'NEW STOCK DAILY SALES','2022-08-10','2022-08-10 11:15:59','2022-08-11 11:15:59','502',0.00,0.00,'502','2022-08-10 20:31:49','502','2022-08-10 20:32:05',10,0),('1','146',257894,'DAILY SALES','2022-08-11','2022-08-11 05:08:13','2022-08-12 05:08:13','502',0.00,0.00,'502','2022-08-11 17:31:07','502','2022-08-11 17:31:57',10,0),('1','146',257895,'OPERATIONAL LOSS','2022-08-11','2022-08-11 17:33:42','2022-08-12 17:33:42','502',0.00,0.00,'502','2022-08-11 17:41:09','502','2022-08-11 17:41:27',10,0),('1','146',257896,'NEW STOCK DAILY SALES','2022-08-11','2022-08-11 17:44:13','2022-08-12 17:44:13','502',0.00,0.00,'502','2022-08-11 19:46:30','502','2022-08-11 19:51:38',10,0),('1','146',257897,'DAILY SALES','2022-08-12','2022-08-12 05:58:58','2022-08-13 05:58:58','502',0.00,0.00,'502','2022-08-12 20:27:57','502','2022-08-12 20:28:20',10,0),('1','146',257898,'DAILY SALES','2022-08-13','2022-08-13 06:06:14','2022-08-14 06:06:14','502',0.00,0.00,'502','2022-08-13 20:28:44','502','2022-08-13 20:29:01',10,0),('1','146',257899,'DAILY SALES','2022-08-14','2022-08-14 06:03:15','2022-08-15 06:03:15','502',0.00,0.00,'502','2022-08-14 19:50:27','502','2022-08-14 19:50:44',10,0),('1','146',257900,'DAILY SALES','2022-08-15','2022-08-15 06:56:31','2022-08-16 06:56:31','502',0.00,0.00,'502','2022-08-15 21:36:42','502','2022-08-15 21:37:06',10,0),('1','146',257901,'DAILY SALES NEW STOCK ','2022-08-16','2022-08-16 08:08:31','2022-08-17 08:08:31','502',0.00,0.00,'502','2022-08-16 20:32:30','502','2022-08-16 20:32:58',10,0),('1','146',257902,'DAILY SALES','2022-08-17','2022-08-17 06:31:04','2022-08-18 06:31:04','502',0.00,0.00,'502','2022-08-17 17:20:20','502','2022-08-17 17:20:43',10,0),('1','146',257903,'NEW STOCK DAILY SALES','2022-08-17','2022-08-17 17:53:55','2022-08-18 17:53:55','502',0.00,0.00,'502','2022-08-17 20:03:51','502','2022-08-17 20:04:14',10,0),('1','146',257904,'Daily sales','2022-08-18','2022-08-18 06:06:49','2022-08-19 06:06:49','502',0.00,0.00,'502','2022-08-18 20:14:56','502','2022-08-18 20:15:30',10,0),('1','146',257905,'DAILY SALES','2022-08-19','2022-08-19 06:31:23','2022-08-20 06:31:23','502',0.00,0.00,'502','2022-08-19 14:08:08','502','2022-08-19 14:08:31',10,0),('1','146',257906,'NEW STOCK DAILY SALES','2022-08-19','2022-08-19 14:10:34','2022-08-20 14:10:34','502',0.00,0.00,'502','2022-08-19 20:57:41','502','2022-08-19 20:58:03',10,0),('1','146',257907,'Daily sales','2022-08-20','2022-08-20 06:05:47','2022-08-21 06:05:47','502',0.00,0.00,'502','2022-08-20 20:20:51','502','2022-08-20 20:21:30',10,0),('1','146',257908,'DAILY SALES','2022-08-21','2022-08-21 06:09:38','2022-08-22 06:09:38','502',0.00,0.00,'502','2022-08-21 11:20:18','502','2022-08-21 11:20:34',10,0),('1','146',257909,'NEW STOCK DAILY SALES','2022-08-21','2022-08-21 11:25:30','2022-08-22 11:25:30','502',0.00,0.00,'502','2022-08-21 20:07:45','502','2022-08-21 20:08:01',10,0),('1','146',257910,'Daily sales','2022-08-22','2022-08-22 05:59:31','2022-08-23 05:59:31','502',0.00,0.00,'502','2022-08-22 19:52:24','502','2022-08-22 19:52:45',10,0),('1','146',257911,'DAILY SALES','2022-08-23','2022-08-23 06:06:28','2022-08-24 06:06:28','502',0.00,0.00,'502','2022-08-23 12:39:46','502','2022-08-23 12:40:03',10,0),('1','146',257912,'OPERATIONAL LOSS','2022-08-23','2022-08-23 12:41:15','2022-08-24 12:41:15','502',0.00,0.00,'502','2022-08-23 12:50:29','502','2022-08-23 12:50:48',10,0),('1','146',257913,'NEW STOCK DAILY SALES','2022-08-23','2022-08-23 12:54:45','2022-08-24 12:54:45','502',0.00,0.00,'502','2022-08-23 20:00:01','502','2022-08-23 20:00:34',10,0),('1','146',257914,'Daily sales','2022-08-24','2022-08-24 05:47:10','2022-08-25 05:47:10','502',0.00,0.00,'502','2022-08-24 20:26:42','502','2022-08-24 20:27:13',10,0),('1','146',257915,'Daily sales','2022-08-25','2022-08-25 05:50:17','2022-08-26 05:50:17','502',0.00,0.00,'502','2022-08-25 10:39:03','502','2022-08-25 10:39:22',10,0),('1','146',257916,'OPERATIONAL LOSS','2022-08-25','2022-08-25 10:39:51','2022-08-26 10:39:51','502',0.00,0.00,'502','2022-08-25 10:43:32','502','2022-08-25 10:43:53',10,0),('1','146',257917,'NEW STOCK DAILY SALES','2022-08-25','2022-08-25 10:45:57','2022-08-26 10:45:57','502',0.00,0.00,'502','2022-08-25 19:58:23','502','2022-08-25 19:58:58',10,0),('1','146',257918,'DAILY SALES','2022-08-26','2022-08-26 06:31:37','2022-08-27 06:31:37','502',0.00,0.00,'502','2022-08-26 20:05:18','502','2022-08-26 20:05:38',10,0),('1','146',257919,'OPERATIONAL LOSS','2022-08-26','2022-08-26 20:08:32','2022-08-27 20:08:32','502',0.00,0.00,'502','2022-08-26 20:18:18','502','2022-08-26 20:18:42',10,0),('1','146',257920,'NEW STOCK DAILY SALES','2022-08-27','2022-08-27 08:05:47','2022-08-28 08:05:47','502',0.00,0.00,'502','2022-08-27 20:01:39','502','2022-08-27 20:02:48',10,0),('1','146',257921,'Daily sales','2022-08-28','2022-08-28 06:08:47','2022-08-29 06:08:47','502',0.00,0.00,'502','2022-08-28 15:25:18','502','2022-08-28 15:25:51',10,0),('1','146',257922,'OPERATIONAL LOSS','2022-08-28','2022-08-28 15:26:27','2022-08-29 15:26:27','502',0.00,0.00,'502','2022-08-28 15:29:24','502','2022-08-28 15:29:41',10,0),('1','146',257923,'NEW STOCK DAILY SALES','2022-08-28','2022-08-28 15:32:24','2022-08-29 15:32:24','502',0.00,0.00,'502','2022-08-28 20:35:27','502','2022-08-28 20:35:58',10,0),('1','146',257924,'DAILY SALES','2022-08-29','2022-08-29 07:03:33','2022-08-30 07:03:33','502',0.00,0.00,'502','2022-08-29 21:03:35','502','2022-08-29 21:03:54',10,0),('1','146',257925,'Daily sales','2022-08-30','2022-08-30 05:52:43','2022-08-31 05:52:43','502',0.00,0.00,'502','2022-08-30 11:15:46','502','2022-08-30 11:16:05',10,0),('1','146',257926,'DAILY 2ND SALES NEW STOCK','2022-08-30','2022-08-30 11:26:26','2022-08-31 11:26:26','502',0.00,0.00,'502','2022-08-30 21:43:35','502','2022-08-30 21:43:53',10,0),('1','146',257927,'DAILY SALES','2022-08-31','2022-08-31 05:50:17','2022-09-01 05:50:17','502',0.00,0.00,'502','2022-08-31 20:12:37','502','2022-08-31 20:12:53',10,0),('1','146',257928,'DAILY SALES','2022-09-01','2022-09-01 05:53:02','2022-09-02 05:53:02','502',0.00,0.00,'502','2022-09-01 10:39:51','502','2022-09-01 10:40:08',10,0),('1','146',257929,'DAILY 2ND SALES NEW STOCK','2022-09-01','2022-09-01 10:43:08','2022-09-02 10:43:08','502',0.00,0.00,'502','2022-09-01 21:48:59','502','2022-09-01 21:49:25',10,0),('1','146',257930,'DAILY SALES','2022-09-02','2022-09-02 05:38:00','2022-09-03 05:38:00','502',0.00,0.00,'502','2022-09-02 20:20:07','502','2022-09-02 20:20:28',10,0),('1','146',257931,'DAILY SALES','2022-09-03','2022-09-03 06:04:33','2022-09-04 06:04:33','502',0.00,0.00,'502','2022-09-03 20:12:27','502','2022-09-03 20:12:45',10,0),('1','146',257932,'DAILY SALES','2022-09-04','2022-09-04 07:05:54','2022-09-05 07:05:54','502',0.00,0.00,'502','2022-09-04 15:08:17','502','2022-09-04 15:08:34',10,0),('1','146',257933,'DAILY SALES NEW STOCK','2022-09-04','2022-09-04 15:15:05','2022-09-05 15:15:05','502',0.00,0.00,'502','2022-09-04 20:18:16','502','2022-09-04 20:18:44',10,0),('1','146',257934,'DAILY SALES','2022-09-05','2022-09-05 06:13:34','2022-09-06 06:13:34','502',0.00,0.00,'502','2022-09-05 20:42:33','502','2022-09-05 20:42:54',10,0),('1','146',257935,'DAILY SALES','2022-09-06','2022-09-06 06:16:16','2022-09-07 06:16:16','502',0.00,0.00,'502','2022-09-06 15:23:03','502','2022-09-06 15:23:23',10,0),('1','146',257936,'DAILY 2ND SALES NEW STOCK','2022-09-06','2022-09-06 15:26:08','2022-09-07 15:26:08','502',0.00,0.00,'502','2022-09-06 20:52:26','502','2022-09-06 20:52:46',10,0),('1','146',257937,'DAILY SALES','2022-09-07','2022-09-07 06:24:05','2022-09-08 06:24:05','502',0.00,0.00,'502','2022-09-07 20:28:44','502','2022-09-07 20:29:04',10,0),('1','146',257938,'DAILY SALES','2022-09-08','2022-09-08 05:59:32','2022-09-09 05:59:32','502',0.00,0.00,'502','2022-09-08 10:00:33','502','2022-09-08 10:00:55',10,0),('1','146',257939,'OPERATIONAL LOSS','2022-09-08','2022-09-08 10:01:26','2022-09-09 10:01:26','502',0.00,0.00,'502','2022-09-08 10:08:20','502','2022-09-08 10:08:37',10,0),('1','146',257940,'DAILY 2ND SALES NEW STOCK','2022-09-08','2022-09-08 10:11:34','2022-09-09 10:11:34','502',0.00,0.00,'502','2022-09-08 20:47:11','502','2022-09-08 20:47:49',10,0),('1','146',257941,'DAILY SALES','2022-09-09','2022-09-09 06:39:35','2022-09-10 06:39:35','502',0.00,0.00,'502','2022-09-09 20:50:02','502','2022-09-09 20:50:19',10,0),('1','146',257942,'DAILY SALES','2022-09-10','2022-09-10 06:35:38','2022-09-11 06:35:38','502',0.00,0.00,'502','2022-09-10 11:15:09','502','2022-09-10 11:15:25',10,0),('1','146',257943,'NEW STOCK','2022-09-10','2022-09-10 11:18:12','2022-09-11 11:18:12','502',0.00,0.00,'502','2022-09-10 19:57:09','502','2022-09-10 19:58:23',10,0),('1','146',257944,'DAILY SALES','2022-09-11','2022-09-11 05:50:52','2022-09-12 05:50:52','502',0.00,0.00,'502','2022-09-11 18:02:22','502','2022-09-11 18:02:45',10,0),('1','146',257945,'OPERATIONAL LOSS','2022-09-11','2022-09-11 18:04:09','2022-09-12 18:04:09','502',0.00,0.00,'502','2022-09-11 18:13:29','502','2022-09-11 18:13:52',10,0),('1','146',257946,'DAILY SALES','2022-09-12','2022-09-12 11:20:45','2022-09-13 11:20:45','502',0.00,0.00,'502','2022-09-12 20:31:19','502','2022-09-12 20:31:44',10,0),('1','146',257947,'DAILY SALES','2022-09-13','2022-09-13 06:37:54','2022-09-14 06:37:54','502',0.00,0.00,'502','2022-09-13 17:32:52','502','2022-09-13 17:33:12',10,0),('1','146',257948,'OPERATIONAL LOSS','2022-09-13','2022-09-13 17:33:31','2022-09-14 17:33:31','502',0.00,0.00,'502','2022-09-13 17:36:34','502','2022-09-13 17:36:53',10,0),('1','146',257949,'NEW STOCK','2022-09-13','2022-09-13 17:39:17','2022-09-14 17:39:17','502',0.00,0.00,'502','2022-09-13 20:59:21','502','2022-09-13 21:00:00',10,0),('1','146',257950,'DAILY SALES','2022-09-14','2022-09-14 05:50:09','2022-09-15 05:50:09','502',0.00,0.00,'502','2022-09-14 17:25:29','502','2022-09-14 17:25:46',10,0),('1','146',257951,'NEW STOCK','2022-09-14','2022-09-14 17:26:29','2022-09-15 17:26:29','502',0.00,0.00,'502','2022-09-14 19:42:09','502','2022-09-14 19:42:41',10,0),('1','146',257952,'DAILY SALES','2022-09-15','2022-09-15 06:03:41','2022-09-16 06:03:41','502',0.00,0.00,'502','2022-09-15 20:10:18','502','2022-09-15 20:10:44',10,0),('1','146',257953,'DAILY SALES','2022-09-16','2022-09-16 06:58:13','2022-09-17 06:58:13','502',0.00,0.00,'502','2022-09-16 13:53:34','502','2022-09-16 13:53:54',10,0),('1','146',257954,'DAILY SALES NEW STOCK ','2022-09-17','2022-09-17 07:07:00','2022-09-18 07:07:00','502',0.00,0.00,'502','2022-09-17 20:05:47','502','2022-09-17 20:06:09',10,0),('1','146',257955,'DAILY SALES','2022-09-18','2022-09-18 05:51:20','2022-09-19 05:51:20','502',0.00,0.00,'502','2022-09-18 18:57:26','502','2022-09-18 18:57:46',10,0),('1','146',257956,'NEW STOCK','2022-09-18','2022-09-18 18:59:40','2022-09-19 18:59:40','502',0.00,0.00,'502','2022-09-18 21:24:38','502','2022-09-18 21:25:04',10,0),('1','146',257957,'DAILY SALES','2022-09-19','2022-09-19 07:00:14','2022-09-20 07:00:14','502',0.00,0.00,'502','2022-09-19 13:18:11','502','2022-09-19 13:18:28',10,0),('1','146',257958,'OPERATIONAL LOSS','2022-09-19','2022-09-19 13:19:17','2022-09-20 13:19:17','502',0.00,0.00,'502','2022-09-19 13:24:35','502','2022-09-19 13:25:00',10,0),('1','146',257959,'NEW STOCK','2022-09-19','2022-09-19 13:28:06','2022-09-20 13:28:06','502',0.00,0.00,'502','2022-09-19 20:37:43','502','2022-09-19 20:40:34',10,0),('1','146',257960,'DAILY SALES','2022-09-20','2022-09-20 05:53:56','2022-09-21 05:53:56','502',0.00,0.00,'502','2022-09-20 20:35:19','502','2022-09-20 20:35:46',10,0),('1','146',257961,'DAILY SALES NEW STOCK ','2022-09-21','2022-09-21 06:46:17','2022-09-22 06:46:17','502',0.00,0.00,'502','2022-09-21 20:32:03','502','2022-09-21 20:32:39',10,0),('1','146',257962,'DAILY SALES','2022-09-22','2022-09-22 05:54:23','2022-09-23 05:54:23','502',0.00,0.00,'502','2022-09-22 20:27:28','502','2022-09-22 20:28:06',10,0),('1','146',257963,'DAILY SALES NEW STOCK ','2022-09-23','2022-09-23 06:56:18','2022-09-24 06:56:18','502',0.00,0.00,'502','2022-09-23 20:45:22','502','2022-09-23 20:45:50',10,0),('1','146',257964,'DAILY SALES','2022-09-24','2022-09-24 05:51:00','2022-09-25 05:51:00','502',0.00,0.00,'502','2022-09-24 19:43:48','502','2022-09-24 19:44:05',10,0),('1','146',257965,'DAILY SALES','2022-09-25','2022-09-25 06:22:50','2022-09-26 06:22:50','502',0.00,0.00,'502','2022-09-25 20:20:08','502','2022-09-25 20:20:35',10,0),('1','146',257966,'DAILY SALES','2022-09-26','2022-09-26 05:53:06','2022-09-27 05:53:06','502',0.00,0.00,'502','2022-09-26 19:38:05','502','2022-09-26 19:38:26',10,0),('1','146',257967,'DAILY SALES NEW STOCK ','2022-09-27','2022-09-27 06:14:18','2022-09-28 06:14:18','502',0.00,0.00,'502','2022-09-27 20:31:51','502','2022-09-27 20:32:16',10,0),('1','146',257968,'DAILY SALES','2022-09-28','2022-09-28 05:55:09','2022-09-29 05:55:09','502',0.00,0.00,'502','2022-09-28 16:19:31','502','2022-09-28 16:19:53',10,0),('1','146',257969,'NEW STOCK','2022-09-28','2022-09-28 16:22:02','2022-09-29 16:22:02','502',0.00,0.00,'502','2022-09-28 20:53:08','502','2022-09-28 20:53:34',10,0),('1','146',257970,'DAILY SALES','2022-09-29','2022-09-29 05:54:48','2022-09-30 05:54:48','502',0.00,0.00,'502','2022-09-29 19:59:30','502','2022-09-29 19:59:56',10,0),('1','146',257971,'DAILY SALES','2022-09-30','2022-09-30 05:42:17','2022-10-01 05:42:17','502',0.00,0.00,'502','2022-09-30 13:09:32','502','2022-09-30 13:09:51',10,0),('1','146',257972,'NEW STOCK','2022-09-30','2022-09-30 13:18:20','2022-10-01 13:18:20','502',0.00,0.00,'502','2022-09-30 19:43:50','502','2022-09-30 19:44:10',10,0),('1','146',257973,'DAILY SALES','2022-10-01','2022-10-01 06:23:58','2022-10-02 06:23:58','502',0.00,0.00,'502','2022-10-01 19:41:17','502','2022-10-01 19:41:47',10,0),('1','146',257974,'OPERATIONAL LOSS','2022-10-01','2022-10-01 20:04:39','2022-10-02 20:04:39','502',0.00,0.00,'502','2022-10-01 20:08:56','502','2022-10-01 20:09:21',10,0),('1','146',257975,'DAILY SALES','2022-10-02','2022-10-02 06:17:57','2022-10-03 06:17:57','502',0.00,0.00,'502','2022-10-02 19:45:06','502','2022-10-02 19:45:36',10,0),('1','146',257976,'DAILY SALES','2022-10-03','2022-10-03 06:45:43','2022-10-04 06:45:43','502',0.00,0.00,'502','2022-10-03 16:20:40','502','2022-10-03 16:21:04',10,0),('1','146',257977,'DAILY SALES NEW STOCK ','2022-10-04','2022-10-04 07:19:43','2022-10-05 07:19:43','502',0.00,0.00,'502','2022-10-04 20:20:23','502','2022-10-04 20:20:57',10,0),('1','146',257978,'DAILY SALES','2022-10-05','2022-10-05 06:36:38','2022-10-06 06:36:38','502',0.00,0.00,'502','2022-10-05 13:24:04','502','2022-10-05 13:24:26',10,0),('1','146',257979,'DAILY SALES','2022-10-06','2022-10-06 11:59:37','2022-10-07 11:59:37','502',0.00,0.00,'502','2022-10-06 20:15:07','502','2022-10-06 20:15:25',10,0),('1','146',257980,'DAILY SALES','2022-10-07','2022-10-07 05:48:38','2022-10-08 05:48:38','502',0.00,0.00,'502','2022-10-07 18:51:27','502','2022-10-07 18:51:49',10,0),('1','146',257981,'DAILY SALES','2022-10-08','2022-10-08 17:45:40','2022-10-09 17:45:40','502',0.00,0.00,'502','2022-10-08 19:22:26','502','2022-10-08 19:22:58',10,0),('1','146',257982,'DAILY SALES','2022-10-09','2022-10-09 06:43:18','2022-10-10 06:43:18','502',0.00,0.00,'502','2022-10-09 19:52:38','502','2022-10-09 19:53:17',10,0),('1','146',257983,'DAILY SALES','2022-10-10','2022-10-10 07:09:15','2022-10-11 07:09:15','502',0.00,0.00,'502','2022-10-10 08:56:05','502','2022-10-10 08:56:24',10,0),('1','146',257984,'NEW STOCK','2022-10-10','2022-10-10 10:24:12','2022-10-11 10:24:12','502',0.00,0.00,'502','2022-10-10 20:41:12','502','2022-10-10 20:41:33',10,0),('1','146',257985,'DAILY SALES','2022-10-11','2022-10-11 05:41:51','2022-10-12 05:41:51','502',0.00,0.00,'502','2022-10-11 12:52:10','502','2022-10-11 12:52:29',10,0),('1','146',257986,'NEW STOCK','2022-10-11','2022-10-11 14:21:53','2022-10-12 14:21:53','502',0.00,0.00,'502','2022-10-11 20:06:21','502','2022-10-11 20:11:32',10,0),('1','146',257987,'DAILY SALES','2022-10-12','2022-10-12 07:02:43','2022-10-13 07:02:43','502',0.00,0.00,'502','2022-10-12 19:38:07','502','2022-10-12 19:38:28',10,0),('1','146',257988,'DAILY SALES','2022-10-13','2022-10-13 06:33:19','2022-10-14 06:33:19','502',0.00,0.00,'502','2022-10-13 18:49:40','502','2022-10-13 18:50:04',10,0),('1','146',257989,'DAILY SALES','2022-10-14','2022-10-14 05:37:47','2022-10-15 05:37:47','502',0.00,0.00,'502','2022-10-14 20:16:54','502','2022-10-14 20:18:04',10,0),('1','146',257990,'DAILY SALES','2022-10-15','2022-10-15 06:18:58','2022-10-16 06:18:58','502',0.00,0.00,'502','2022-10-15 18:13:23','502','2022-10-15 18:13:58',10,0),('1','146',257991,'DAILY SALES NEW STOCK ','2022-10-16','2022-10-16 05:40:20','2022-10-17 05:40:20','502',0.00,0.00,'502','2022-10-16 20:23:58','502','2022-10-16 20:24:21',10,0),('1','146',257992,'DAILY SALES','2022-10-17','2022-10-17 06:37:46','2022-10-18 06:37:46','502',0.00,0.00,'502','2022-10-17 14:20:34','502','2022-10-17 14:21:02',10,0),('1','146',257993,'NEW STOCK','2022-10-17','2022-10-17 16:23:56','2022-10-18 16:23:56','502',0.00,0.00,'502','2022-10-17 20:02:40','502','2022-10-17 20:04:44',10,0),('1','146',257994,'DAILY SALES','2022-10-18','2022-10-18 05:56:10','2022-10-19 05:56:10','502',0.00,0.00,'502','2022-10-18 20:36:14','502','2022-10-18 20:36:45',10,0),('1','146',257995,'DAILY SALES','2022-10-19','2022-10-19 05:56:01','2022-10-20 05:56:01','502',0.00,0.00,'502','2022-10-19 10:06:17','502','2022-10-19 10:06:33',10,0),('1','146',257996,'DAILY SALES NEW PRICE ','2022-10-19','2022-10-19 10:07:47','2022-10-20 10:07:47','502',0.00,0.00,'502','2022-10-19 13:21:49','502','2022-10-19 13:22:13',10,0),('1','146',257997,'NEW STOCK','2022-10-19','2022-10-19 13:27:30','2022-10-20 13:27:30','502',0.00,0.00,'502','2022-10-19 19:59:11','502','2022-10-19 19:59:31',10,0),('1','146',257998,'DAILY SALES','2022-10-20','2022-10-20 05:41:01','2022-10-21 05:41:01','502',0.00,0.00,'502','2022-10-20 19:40:06','502','2022-10-20 19:40:27',10,0),('1','146',257999,'DAILY SALES','2022-10-21','2022-10-21 10:07:06','2022-10-22 10:07:06','502',0.00,0.00,'502','2022-10-21 16:53:14','502','2022-10-21 16:53:31',10,0),('1','146',258000,'OPERATIONAL LOSS','2022-10-21','2022-10-21 16:53:52','2022-10-22 16:53:52','502',0.00,0.00,'502','2022-10-21 17:00:08','502','2022-10-21 17:00:26',10,0),('1','146',258001,'DAILY SALES','2022-10-21','2022-10-21 17:37:30','2022-10-22 17:37:30','502',0.00,0.00,'502','2022-10-21 20:43:57','502','2022-10-21 20:44:20',10,0),('1','146',258002,'DAILY SALES','2022-10-22','2022-10-22 05:56:04','2022-10-23 05:56:04','502',0.00,0.00,'502','2022-10-22 20:59:29','502','2022-10-22 20:59:56',10,0),('1','146',258003,'DAILY SALES','2022-10-23','2022-10-23 06:02:33','2022-10-24 06:02:33','502',0.00,0.00,'502','2022-10-23 10:49:54','502','2022-10-23 10:50:11',10,0),('1','146',258004,'DAILY SALES','2022-10-23','2022-10-23 11:33:30','2022-10-24 11:33:30','502',0.00,0.00,'502','2022-10-23 19:38:49','502','2022-10-23 19:39:14',10,0),('1','146',258005,'DAILY SALES','2022-10-24','2022-10-24 05:57:44','2022-10-25 05:57:44','502',0.00,0.00,'502','2022-10-24 17:35:06','502','2022-10-24 17:35:35',10,0),('1','146',258006,'OPERATIONAL LOSS','2022-10-24','2022-10-24 17:36:34','2022-10-25 17:36:34','502',0.00,0.00,'502','2022-10-24 17:43:26','502','2022-10-24 17:45:04',10,0),('1','146',258007,'NEW STOCK','2022-10-24','2022-10-24 17:47:43','2022-10-25 17:47:43','502',0.00,0.00,'502','2022-10-24 20:18:41','502','2022-10-24 20:19:06',10,0),('1','146',258008,'DAILY SALES','2022-10-25','2022-10-25 06:07:47','2022-10-26 06:07:47','502',0.00,0.00,'502','2022-10-25 20:13:39','502','2022-10-25 20:14:07',10,0),('1','146',258009,'DAILY SALES','2022-10-26','2022-10-26 06:34:24','2022-10-27 06:34:24','502',0.00,0.00,'502','2022-10-26 17:02:27','502','2022-10-26 17:02:45',10,0),('1','146',258010,'NEW STOCK','2022-10-26','2022-10-26 17:12:31','2022-10-27 17:12:31','502',0.00,0.00,'502','2022-10-26 20:25:50','502','2022-10-26 20:26:08',10,0),('1','146',258011,'DAILY SALES','2022-10-27','2022-10-27 06:06:37','2022-10-28 06:06:37','502',0.00,0.00,'502','2022-10-27 19:48:37','502','2022-10-27 19:49:06',10,0),('1','146',258012,'DAILY SALES','2022-10-28','2022-10-28 06:49:28','2022-10-29 06:49:28','502',0.00,0.00,'502','2022-10-28 15:24:37','502','2022-10-28 15:25:12',10,0),('1','146',258013,'OPERATIONAL LOSS','2022-10-28','2022-10-28 15:25:50','2022-10-29 15:25:50','502',0.00,0.00,'502','2022-10-28 15:31:41','502','2022-10-28 15:32:15',10,0),('1','146',258014,'NEW STOCK','2022-10-28','2022-10-28 15:44:53','2022-10-29 15:44:53','502',0.00,0.00,'502','2022-10-28 20:26:18','502','2022-10-28 20:26:38',10,0),('1','146',258015,'DAILY SALES','2022-10-29','2022-10-29 05:55:52','2022-10-30 05:55:52','502',0.00,0.00,'502','2022-10-29 10:13:39','502','2022-10-29 10:13:54',10,0),('1','146',258016,'DAILY SALES','2022-10-29','2022-10-29 10:15:42','2022-10-30 10:15:42','502',0.00,0.00,'502','2022-10-29 20:01:56','502','2022-10-29 20:02:18',10,0),('1','146',258017,'DAILY SALES','2022-10-30','2022-10-30 06:22:04','2022-10-31 06:22:04','502',0.00,0.00,'502','2022-10-30 16:53:35','502','2022-10-30 16:54:01',10,0),('1','146',258018,'OPERATIONAL LOSS','2022-10-30','2022-10-30 16:54:43','2022-10-31 16:54:43','502',0.00,0.00,'502','2022-10-30 16:58:33','502','2022-10-30 16:58:48',10,0),('1','146',258019,'NEW STOCK','2022-10-30','2022-10-30 17:00:36','2022-10-31 17:00:36','502',0.00,0.00,'502','2022-10-30 20:30:52','502','2022-10-30 20:31:20',10,0),('1','146',258020,'DAILY SALES','2022-10-31','2022-10-31 05:56:10','2022-11-01 05:56:10','502',0.00,0.00,'502','2022-10-31 20:28:29','502','2022-10-31 20:29:25',10,0),('1','146',258021,'DAILY SALES','2022-11-01','2022-11-01 07:04:48','2022-11-02 07:04:48','502',0.00,0.00,'502','2022-11-01 12:04:23','502','2022-11-01 12:04:50',10,0),('1','146',258022,'NEW STOCK','2022-11-03','2022-11-03 17:04:14','2022-11-04 17:04:14','502',0.00,0.00,'502','2022-11-03 20:24:55','502','2022-11-03 20:44:19',10,0),('1','146',258023,'DAILY SALES','2022-11-04','2022-11-04 05:59:03','2022-11-05 05:59:03','502',0.00,0.00,'502','2022-11-04 20:16:05','502','2022-11-04 20:16:32',10,0),('1','146',258024,'DAILY SALES','2022-11-05','2022-11-05 08:59:43','2022-11-06 08:59:43','502',0.00,0.00,'502','2022-11-05 10:48:20','502','2022-11-05 10:48:38',10,0),('1','146',258025,'OPERATIONAL LOSS','2022-11-05','2022-11-05 10:49:00','2022-11-06 10:49:00','502',0.00,0.00,'502','2022-11-05 10:55:43','502','2022-11-05 10:56:00',10,0),('1','146',258026,'NEW STOCK','2022-11-05','2022-11-05 11:23:57','2022-11-06 11:23:57','502',0.00,0.00,'502','2022-11-05 20:24:02','502','2022-11-05 20:24:54',10,0),('1','146',258027,'DAILY SALES','2022-11-06','2022-11-06 08:52:24','2022-11-07 08:52:24','502',0.00,0.00,'502','2022-11-06 20:07:41','502','2022-11-06 20:08:10',10,0),('1','146',258028,'DAILY SALES','2022-11-07','2022-11-07 07:25:58','2022-11-08 07:25:58','502',0.00,0.00,'502','2022-11-07 15:11:00','502','2022-11-07 15:11:19',10,0),('1','146',258029,'OPERATIONAL LOSS','2022-11-07','2022-11-07 15:11:57','2022-11-08 15:11:57','502',0.00,0.00,'502','2022-11-07 15:14:40','502','2022-11-07 15:14:55',10,0),('1','146',258030,'NEW STOCK','2022-11-07','2022-11-07 15:17:36','2022-11-08 15:17:36','502',0.00,0.00,'502','2022-11-07 20:31:25','502','2022-11-07 20:31:57',10,0),('1','146',258031,'DAILY SALES','2022-11-08','2022-11-08 06:01:18','2022-11-09 06:01:18','502',0.00,0.00,'502','2022-11-08 20:06:08','502','2022-11-08 20:06:34',10,0),('1','146',258032,'DAILY SALES','2022-11-09','2022-11-09 07:10:50','2022-11-10 07:10:50','502',0.00,0.00,'502','2022-11-09 14:24:13','502','2022-11-09 14:24:51',10,0),('1','146',258033,'NEW STOCK','2022-11-09','2022-11-09 14:45:15','2022-11-10 14:45:15','502',0.00,0.00,'502','2022-11-09 19:28:33','502','2022-11-09 19:28:57',10,0),('1','146',258034,'DAILY SALES','2022-11-10','2022-11-10 05:52:41','2022-11-11 05:52:41','502',0.00,0.00,'502','2022-11-10 20:07:01','502','2022-11-10 20:07:51',10,0),('1','146',258035,'DAILY SALES','2022-11-11','2022-11-11 06:03:21','2022-11-12 06:03:21','502',0.00,0.00,'502','2022-11-11 16:54:13','502','2022-11-11 16:54:31',10,0),('1','146',258036,'DAILY SALES NEW STOCK','2022-11-11','2022-11-11 16:56:48','2022-11-12 16:56:48','502',0.00,0.00,'502','2022-11-11 20:36:40','502','2022-11-11 20:37:03',10,0),('1','146',258037,'DAILY SALES','2022-11-12','2022-11-12 06:18:16','2022-11-13 06:18:16','502',0.00,0.00,'502','2022-11-12 19:41:51','502','2022-11-12 19:42:17',10,0),('1','146',258038,'DAILY SALES NEW STOCK','2022-11-13','2022-11-13 05:46:24','2022-11-14 05:46:24','502',0.00,0.00,'502','2022-11-13 16:06:53','502','2022-11-13 16:07:08',10,0),('1','146',258039,'OPERATIONAL LOSS','2022-11-13','2022-11-13 16:08:55','2022-11-14 16:08:55','502',0.00,0.00,'502','2022-11-13 16:14:47','502','2022-11-13 16:15:02',10,0),('1','146',258040,'DAILY SALES NEW STOCK ','2022-11-13','2022-11-13 16:15:32','2022-11-14 16:15:32','502',0.00,0.00,'502','2022-11-13 19:59:02','502','2022-11-13 20:01:38',10,0),('1','146',258041,'DAILY SALES','2022-11-14','2022-11-14 05:48:03','2022-11-15 05:48:03','502',0.00,0.00,'502','2022-11-14 20:01:28','502','2022-11-14 20:01:47',10,0),('1','146',258042,'DAILY SALES ','2022-11-15','2022-11-15 06:03:22','2022-11-16 06:03:22','502',0.00,0.00,'502','2022-11-15 16:36:15','502','2022-11-15 16:44:47',10,0),('1','146',258043,'OPERATIONAL LOSS','2022-11-15','2022-11-15 16:47:33','2022-11-16 16:47:33','502',0.00,0.00,'502','2022-11-15 16:53:13','502','2022-11-15 16:53:34',10,0),('1','146',258044,'DAILY SALES NEW STOCK','2022-11-15','2022-11-15 18:11:35','2022-11-16 18:11:35','502',0.00,0.00,'502','2022-11-15 19:53:18','502','2022-11-15 19:53:43',10,0),('1','146',258045,'DAILY SALES ','2022-11-16','2022-11-16 06:00:13','2022-11-17 06:00:13','502',0.00,0.00,'502','2022-11-16 20:48:22','502','2022-11-16 20:48:42',10,0),('1','146',258046,'DAILY SALES','2022-11-17','2022-11-17 06:21:07','2022-11-18 06:21:07','502',0.00,0.00,'502','2022-11-17 17:57:34','502','2022-11-17 17:57:51',10,0),('1','146',258047,'OPERATIONAL LOSS','2022-11-17','2022-11-17 17:58:11','2022-11-18 17:58:11','502',0.00,0.00,'502','2022-11-17 18:01:04','502','2022-11-17 18:01:19',10,0),('1','146',258048,'DAILY SALES NEW STOCK','2022-11-17','2022-11-17 18:01:36','2022-11-18 18:01:36','502',0.00,0.00,'502','2022-11-17 20:26:34','502','2022-11-17 20:29:16',10,0),('1','146',258049,'DAILY SALES','2022-11-18','2022-11-18 06:50:10','2022-11-19 06:50:10','502',0.00,0.00,'502','2022-11-18 19:41:18','502','2022-11-18 19:41:42',10,0),('1','146',258050,'DAILY SALES','2022-11-19','2022-11-19 05:56:07','2022-11-20 05:56:07','502',0.00,0.00,'502','2022-11-19 19:50:52','502','2022-11-19 19:51:15',10,0),('1','146',258051,'DAILY SALES','2022-11-20','2022-11-20 07:16:51','2022-11-21 07:16:51','502',0.00,0.00,'502','2022-11-20 09:32:05','502','2022-11-20 09:32:27',10,0),('1','146',258052,'OPERATIONAL LOSS','2022-11-20','2022-11-20 09:34:18','2022-11-21 09:34:18','502',0.00,0.00,'502','2022-11-20 09:43:11','502','2022-11-20 09:43:30',10,0),('1','146',258053,'NEW STOCK/DAILY SALES','2022-11-20','2022-11-20 09:49:57','2022-11-21 09:49:57','502',0.00,0.00,'502','2022-11-20 20:22:48','502','2022-11-20 20:23:25',10,0),('1','146',258054,'DaILY SALES','2022-11-21','2022-11-21 05:57:04','2022-11-22 05:57:04','502',0.00,0.00,'502','2022-11-21 19:35:41','502','2022-11-21 19:36:01',10,0),('1','146',258055,'DAILY SALES','2022-11-22','2022-11-22 06:05:38','2022-11-23 06:05:38','502',0.00,0.00,'502','2022-11-22 19:07:09','502','2022-11-22 19:07:45',10,0),('1','146',258056,'OPERATIONAL LOSS','2022-11-22','2022-11-22 19:56:06','2022-11-23 19:56:06','502',0.00,0.00,'502','2022-11-22 20:00:27','502','2022-11-22 20:00:50',10,0),('1','146',258057,'DaILY SALES','2022-11-23','2022-11-23 05:58:48','2022-11-24 05:58:48','502',0.00,0.00,'502','2022-11-23 20:27:15','502','2022-11-23 20:27:39',10,0),('1','146',258058,'DaILY SALES','2022-11-24','2022-11-24 05:54:13','2022-11-25 05:54:13','502',0.00,0.00,'502','2022-11-24 20:17:04','502','2022-11-24 20:17:46',10,0),('1','146',258059,'DAILY SALES','2022-11-25','2022-11-25 06:49:59','2022-11-26 06:49:59','502',0.00,0.00,'502','2022-11-25 20:20:31','502','2022-11-25 20:20:50',10,0),('1','146',258060,'DAILY SALES','2022-11-26','2022-11-26 05:57:06','2022-11-27 05:57:06','502',0.00,0.00,'502','2022-11-26 17:28:47','502','2022-11-26 17:29:10',10,0),('1','146',258061,'OPERATIONAL LOSS','2022-11-26','2022-11-26 17:29:38','2022-11-27 17:29:38','502',0.00,0.00,'502','2022-11-26 17:33:15','502','2022-11-26 17:33:38',10,0),('1','146',258062,'DaILY SALES','2022-11-27','2022-11-27 05:53:39','2022-11-28 05:53:39','502',0.00,0.00,'502','2022-11-27 19:50:43','502','2022-11-27 19:51:02',10,0),('1','146',258063,'DAILY SALES ','2022-11-28','2022-11-28 06:38:24','2022-11-29 06:38:24','502',0.00,0.00,'502','2022-11-28 20:29:19','502','2022-11-28 20:29:57',10,0),('1','146',258064,'DaILY SALES','2022-11-29','2022-11-29 05:48:34','2022-11-30 05:48:34','502',0.00,0.00,'502','2022-11-29 10:37:32','502','2022-11-29 10:37:49',10,0),('1','146',258065,'OPERATIONAL LOSS','2022-11-29','2022-11-29 10:38:18','2022-11-30 10:38:18','502',0.00,0.00,'502','2022-11-29 10:44:30','502','2022-11-29 10:44:51',10,0),('1','146',258066,'NEW STOCK/DAILY SALES','2022-11-29','2022-11-29 10:46:56','2022-11-30 10:46:56','502',0.00,0.00,'502','2022-11-29 19:58:28','502','2022-11-29 19:58:58',10,0),('1','146',258067,'DAILY SALES ','2022-11-30','2022-11-30 06:40:24','2022-12-01 06:40:24','502',0.00,0.00,'502','2022-11-30 19:42:58','502','2022-11-30 19:43:18',10,0),('1','146',258068,'DaILY SALES','2022-12-01','2022-12-01 06:15:02','2022-12-02 06:15:02','502',0.00,0.00,'502','2022-12-01 11:58:04','502','2022-12-01 11:58:34',10,0),('1','146',258069,'OPERATIONAL LOSS','2022-12-01','2022-12-01 12:31:56','2022-12-02 12:31:56','502',0.00,0.00,'502','2022-12-01 12:37:38','502','2022-12-01 12:37:56',10,0),('1','146',258070,'NEW STOCK/DAILY SALES','2022-12-01','2022-12-01 12:38:33','2022-12-02 12:38:33','502',0.00,0.00,'502','2022-12-01 20:11:10','502','2022-12-01 20:11:35',10,0),('1','146',258071,'DaILY SALES','2022-12-02','2022-12-02 06:57:24','2022-12-03 06:57:24','502',0.00,0.00,'502','2022-12-02 19:40:58','502','2022-12-02 19:41:23',10,0),('1','146',258072,'DaILY SALES','2022-12-03','2022-12-03 05:59:12','2022-12-04 05:59:12','502',0.00,0.00,'502','2022-12-03 13:42:54','502','2022-12-03 13:43:28',10,0),('1','146',258073,'OPERATIONAL LOSS','2022-12-03','2022-12-03 13:44:11','2022-12-04 13:44:11','502',0.00,0.00,'502','2022-12-03 13:50:05','502','2022-12-03 13:50:20',10,0),('1','146',258074,'NEW STOCK/DAILY SALES','2022-12-03','2022-12-03 14:12:40','2022-12-04 14:12:40','502',0.00,0.00,'502','2022-12-03 20:03:03','502','2022-12-03 20:03:37',10,0),('1','146',258075,'DaILY SALES','2022-12-04','2022-12-04 05:51:51','2022-12-05 05:51:51','502',0.00,0.00,'502','2022-12-04 20:16:13','502','2022-12-04 20:16:34',10,0),('1','146',258076,'DaILY SALES','2022-12-05','2022-12-05 06:31:05','2022-12-06 06:31:05','502',0.00,0.00,'502','2022-12-05 14:16:30','502','2022-12-05 14:16:47',10,0),('1','146',258077,'OPERATIONAL LOSS','2022-12-05','2022-12-05 14:17:27','2022-12-06 14:17:27','502',0.00,0.00,'502','2022-12-05 14:30:07','502','2022-12-05 14:30:29',10,0),('1','146',258078,'NEW STOCK/DAILY SALES','2022-12-05','2022-12-05 14:35:06','2022-12-06 14:35:06','502',0.00,0.00,'502','2022-12-05 20:03:55','502','2022-12-05 20:05:31',10,0),('1','146',258079,'DAILY SALES','2022-12-06','2022-12-06 05:58:45','2022-12-07 05:58:45','502',0.00,0.00,'502','2022-12-06 20:21:06','502','2022-12-06 20:21:23',10,0),('1','146',258080,'DaILY SALES','2022-12-07','2022-12-07 05:49:41','2022-12-08 05:49:41','502',0.00,0.00,'502','2022-12-07 16:40:38','502','2022-12-07 16:40:54',10,0),('1','146',258081,'OPERATIONAL LOSS','2022-12-07','2022-12-07 16:41:20','2022-12-08 16:41:20','502',0.00,0.00,'502','2022-12-07 16:57:23','502','2022-12-07 16:58:09',10,0),('1','146',258082,'NEW STOCK/DAILY SALES','2022-12-07','2022-12-07 17:00:48','2022-12-08 17:00:48','502',0.00,0.00,'502','2022-12-07 20:11:20','502','2022-12-07 20:11:50',10,0),('1','146',258083,'DAILY SALES ','2022-12-08','2022-12-08 06:40:26','2022-12-09 06:40:26','502',0.00,0.00,'502','2022-12-08 19:50:09','502','2022-12-08 19:50:39',10,0),('1','146',258084,'DAILY SALES','2022-12-09','2022-12-09 06:15:00','2022-12-10 06:15:00','502',0.00,0.00,'502','2022-12-09 09:29:07','502','2022-12-09 09:29:23',10,0),('1','146',258085,'DAILY SALES/NEW PRICE','2022-12-09','2022-12-09 09:31:07','2022-12-10 09:31:07','502',0.00,0.00,'502','2022-12-09 20:45:22','502','2022-12-09 20:45:40',10,0),('1','146',258086,'DaILY SALES','2022-12-10','2022-12-10 05:58:07','2022-12-11 05:58:07','502',0.00,0.00,'502','2022-12-10 09:24:24','502','2022-12-10 09:24:47',10,0),('1','146',258087,'OPERATIONAL LOSS','2022-12-10','2022-12-10 09:25:12','2022-12-11 09:25:12','502',0.00,0.00,'502','2022-12-10 09:29:27','502','2022-12-10 09:29:42',10,0),('1','146',258088,'DAILY SALES NEW STOCK ','2022-12-10','2022-12-10 09:30:16','2022-12-11 09:30:16','502',0.00,0.00,'502','2022-12-10 20:22:20','502','2022-12-10 20:22:42',10,0),('1','146',258089,'DaILY SALES','2022-12-11','2022-12-11 05:52:45','2022-12-12 05:52:45','502',0.00,0.00,'502','2022-12-11 19:54:11','502','2022-12-11 19:54:36',10,0),('1','146',258090,'DaILY SALES','2022-12-12','2022-12-12 07:26:52','2022-12-13 07:26:52','502',0.00,0.00,'502','2022-12-12 08:47:03','502','2022-12-12 08:47:26',10,0),('1','146',258091,'OPERATIONAL LOSS','2022-12-12','2022-12-12 08:48:11','2022-12-13 08:48:11','502',0.00,0.00,'502','2022-12-12 08:53:06','502','2022-12-12 08:53:24',10,0),('1','146',258092,'NEW STOCK/DAILY SALES','2022-12-12','2022-12-12 08:55:39','2022-12-13 08:55:39','502',0.00,0.00,'502','2022-12-12 20:06:08','502','2022-12-12 20:06:33',10,0),('1','146',258093,'DaILY SALES','2022-12-13','2022-12-13 05:47:07','2022-12-14 05:47:07','502',0.00,0.00,'502','2022-12-13 17:54:39','502','2022-12-13 17:54:56',10,0),('1','146',258094,'OPERATIONAL LOSS','2022-12-13','2022-12-13 17:55:20','2022-12-14 17:55:20','502',0.00,0.00,'502','2022-12-13 17:59:06','502','2022-12-13 17:59:26',10,0),('1','146',258095,'DAILY SALES','2022-12-14','2022-12-14 07:00:40','2022-12-15 07:00:40','502',0.00,0.00,'502','2022-12-14 20:17:05','502','2022-12-14 20:17:24',10,0),('1','146',258096,'DaILY SALES','2022-12-15','2022-12-15 06:00:08','2022-12-16 06:00:08','502',0.00,0.00,'502','2022-12-15 19:53:36','502','2022-12-15 19:54:01',10,0),('1','146',258097,'DaILY SALES','2022-12-16','2022-12-16 07:29:03','2022-12-17 07:29:03','502',0.00,0.00,'502','2022-12-16 09:56:58','502','2022-12-16 09:57:25',10,0),('1','146',258098,'NEW STOCK DAILY SALES','2022-12-16','2022-12-16 10:01:02','2022-12-17 10:01:02','502',0.00,0.00,'502','2022-12-16 20:43:06','502','2022-12-16 20:43:24',10,0),('1','146',258099,'DaILY SALES','2022-12-17','2022-12-17 05:53:25','2022-12-18 05:53:25','502',0.00,0.00,'502','2022-12-17 21:35:33','502','2022-12-17 21:36:53',10,0),('1','146',258100,'DaILY SALES','2022-12-18','2022-12-18 07:42:38','2022-12-19 07:42:38','502',0.00,0.00,'502','2022-12-18 14:51:23','502','2022-12-18 14:51:47',10,0),('1','146',258101,'NEW STOCK DAILY SALES','2022-12-18','2022-12-18 14:55:14','2022-12-19 14:55:14','502',0.00,0.00,'502','2022-12-18 20:49:42','502','2022-12-18 20:50:00',10,0),('1','146',258102,'DaILY SALES','2022-12-19','2022-12-19 06:08:49','2022-12-20 06:08:49','502',0.00,0.00,'502','2022-12-19 20:12:31','502','2022-12-19 20:12:56',10,0),('1','146',258103,'DaILY SALES','2022-12-20','2022-12-20 07:44:11','2022-12-21 07:44:11','502',0.00,0.00,'502','2022-12-20 15:40:58','502','2022-12-20 15:41:16',10,0),('1','146',258104,'DAILY SHIFT 2ND SALES NEW STOCK','2022-12-20','2022-12-20 15:56:45','2022-12-21 15:56:45','502',0.00,0.00,'502','2022-12-20 20:44:14','502','2022-12-20 20:44:33',10,0),('1','146',258105,'DaILY SALES','2022-12-21','2022-12-21 05:54:24','2022-12-22 05:54:24','502',0.00,0.00,'502','2022-12-21 19:38:28','502','2022-12-21 19:38:55',10,0),('1','146',258106,'DAILY SALES','2022-12-22','2022-12-22 05:59:50','2022-12-23 05:59:50','502',0.00,0.00,'502','2022-12-22 11:47:32','502','2022-12-22 11:56:35',10,0),('1','146',258107,'DAILY SALES','2022-12-22','2022-12-22 11:57:51','2022-12-23 11:57:51','502',0.00,0.00,'502','2022-12-22 12:00:58','502','2022-12-22 12:01:17',10,0),('1','146',258108,'NEW-STOCK DAILY SALES','2022-12-22','2022-12-22 12:05:10','2022-12-23 12:05:10','502',0.00,0.00,'502','2022-12-22 21:21:59','502','2022-12-22 21:22:40',10,0),('1','146',258109,'DAILY SALES','2022-12-23','2022-12-23 06:35:04','2022-12-24 06:35:04','502',0.00,0.00,'502','2022-12-23 20:06:59','502','2022-12-23 20:07:16',10,0),('1','146',258110,'DAILY SALES','2022-12-24','2022-12-24 07:19:21','2022-12-25 07:19:21','502',0.00,0.00,'502','2022-12-24 09:19:36','502','2022-12-24 09:20:10',10,0),('1','146',258111,'NEW-STOCK DAILY SALES','2022-12-24','2022-12-24 09:27:35','2022-12-25 09:27:35','502',0.00,0.00,'502','2022-12-24 20:39:25','502','2022-12-24 20:40:13',10,0),('1','146',258112,'DAILY SALES','2022-12-25','2022-12-25 06:02:29','2022-12-26 06:02:29','502',0.00,0.00,'502','2022-12-25 16:49:54','502','2022-12-25 16:50:14',10,0),('1','146',258113,'NEW-STOCK DAILY SALES','2022-12-25','2022-12-25 17:12:56','2022-12-26 17:12:56','502',0.00,0.00,'502','2022-12-25 19:58:49','502','2022-12-25 19:59:18',10,0),('1','146',258114,'DAILY SALES','2022-12-26','2022-12-26 07:50:40','2022-12-27 07:50:40','502',0.00,0.00,'502','2022-12-26 21:03:15','502','2022-12-26 21:03:45',10,0),('1','146',258115,'DAILY SALES','2022-12-27','2022-12-27 06:02:36','2022-12-28 06:02:36','502',0.00,0.00,'502','2022-12-27 20:56:06','502','2022-12-27 20:56:30',10,0),('1','146',258116,'DAILY SALES','2022-12-28','2022-12-28 06:03:12','2022-12-29 06:03:12','502',0.00,0.00,'502','2022-12-28 17:25:52','502','2022-12-28 17:26:39',10,0),('1','146',258117,'NEW-STOCK DAILY SALES','2022-12-28','2022-12-28 17:29:27','2022-12-29 17:29:27','502',0.00,0.00,'502','2022-12-28 20:06:19','502','2022-12-28 20:06:43',10,0),('1','146',258118,'DAILY SALES','2022-12-29','2022-12-29 06:07:42','2022-12-30 06:07:42','502',0.00,0.00,'502','2022-12-29 20:27:56','502','2022-12-29 20:28:22',10,0),('1','146',258119,'DAILY SALES','2022-12-30','2022-12-30 07:15:51','2022-12-31 07:15:51','502',0.00,0.00,'502','2022-12-30 19:55:46','502','2022-12-30 19:56:10',10,0),('1','146',258120,'DAILY SALES','2022-12-31','2022-12-31 06:09:12','2023-01-01 06:09:12','502',0.00,0.00,'502','2022-12-31 11:47:45','502','2022-12-31 11:48:00',10,0),('1','146',258121,'NEW-STOCK DAILY SALES','2022-12-31','2022-12-31 13:25:51','2023-01-01 13:25:51','502',0.00,0.00,'502','2022-12-31 19:57:58','502','2022-12-31 19:58:22',10,0),('1','146',258122,'DAILY SALES','2023-01-01','2023-01-01 06:04:09','2023-01-02 06:04:09','502',0.00,0.00,'502','2023-01-01 19:28:10','502','2023-01-01 19:28:36',10,0),('1','146',258123,'DAILY SALES','2023-01-02','2023-01-02 05:57:32','2023-01-03 05:57:32','502',0.00,0.00,'502','2023-01-02 19:41:00','502','2023-01-02 19:41:18',10,0),('1','146',258124,'DAILY SALES','2023-01-03','2023-01-03 06:06:04','2023-01-04 06:06:04','502',0.00,0.00,'502','2023-01-03 12:37:05','502','2023-01-03 12:37:35',10,0),('1','146',258125,'OPERATIONAL LOSS','2023-01-03','2023-01-03 12:40:05','2023-01-04 12:40:05','502',0.00,0.00,'502','2023-01-03 12:44:37','502','2023-01-03 12:44:54',10,0),('1','146',258126,'NEW-STOCK DAILY SALES','2023-01-03','2023-01-03 12:49:22','2023-01-04 12:49:22','502',0.00,0.00,'502','2023-01-03 20:02:53','502','2023-01-03 20:03:19',10,0),('1','146',258127,'DAILY SALES','2023-01-04','2023-01-04 06:43:00','2023-01-05 06:43:00','502',0.00,0.00,'502','2023-01-04 20:20:17','502','2023-01-04 20:20:39',10,0),('1','146',258128,'DAILY SALES','2023-01-05','2023-01-05 06:08:45','2023-01-06 06:08:45','502',0.00,0.00,'502','2023-01-05 13:41:48','502','2023-01-05 13:42:38',10,0),('1','146',258129,'NEW-STOCK DAILY SALES','2023-01-05','2023-01-05 13:44:49','2023-01-06 13:44:49','502',0.00,0.00,'502','2023-01-05 20:19:26','502','2023-01-05 20:19:44',10,0),('1','146',258130,'DAILY SALES','2023-01-06','2023-01-06 06:07:54','2023-01-07 06:07:54','502',0.00,0.00,'502','2023-01-06 19:36:06','502','2023-01-06 19:36:23',10,0),('1','146',258131,'DAILY SALES','2023-01-07','2023-01-07 06:04:19','2023-01-08 06:04:19','502',0.00,0.00,'502','2023-01-07 15:04:34','502','2023-01-07 15:05:12',10,0),('1','146',258132,'NEW-STOCK DAILY SALES','2023-01-07','2023-01-07 15:07:20','2023-01-08 15:07:20','502',0.00,0.00,'502','2023-01-07 20:10:52','502','2023-01-07 20:11:14',10,0),('1','146',258133,'DAILY SALES','2023-01-08','2023-01-08 07:24:34','2023-01-09 07:24:34','502',0.00,0.00,'502','2023-01-08 19:41:19','502','2023-01-08 19:41:42',10,0),('1','146',258134,'DAILY SALES','2023-01-09','2023-01-09 06:01:01','2023-01-10 06:01:01','502',0.00,0.00,'502','2023-01-09 18:56:47','502','2023-01-09 18:57:27',10,0),('1','146',258135,'OPERATIONAL LOSS','2023-01-09','2023-01-09 18:58:32','2023-01-10 18:58:32','502',0.00,0.00,'502','2023-01-09 19:01:45','502','2023-01-09 19:02:05',10,0),('1','146',258136,'DAILY SALES','2023-01-10','2023-01-10 05:58:37','2023-01-11 05:58:37','502',0.00,0.00,'502','2023-01-10 20:53:29','502','2023-01-10 20:54:04',10,0),('1','146',258137,'DAILY SALES','2023-01-11','2023-01-11 06:04:26','2023-01-12 06:04:26','502',0.00,0.00,'502','2023-01-11 19:32:53','502','2023-01-11 19:33:22',10,0),('1','146',258138,'DAILY SALES','2023-01-12','2023-01-12 05:59:34','2023-01-13 05:59:34','502',0.00,0.00,'502','2023-01-12 20:17:50','502','2023-01-12 20:18:14',10,0),('1','146',258139,'DAILY SALES','2023-01-13','2023-01-13 06:18:00','2023-01-14 06:18:00','502',0.00,0.00,'502','2023-01-13 19:30:25','502','2023-01-13 19:30:49',10,0),('1','146',258140,'OPERATIONAL LOSS','2023-01-13','2023-01-13 19:32:27','2023-01-14 19:32:26','502',0.00,0.00,'502','2023-01-13 19:39:52','502','2023-01-13 19:40:22',10,0),('1','146',258141,'DAILY SALES','2023-01-14','2023-01-14 06:46:59','2023-01-15 06:46:59','502',0.00,0.00,'502','2023-01-14 20:13:24','502','2023-01-14 20:14:24',10,0),('1','146',258142,'DAILY SALES','2023-01-15','2023-01-15 05:59:46','2023-01-16 05:59:46','502',0.00,0.00,'502','2023-01-15 20:07:12','502','2023-01-15 20:07:32',10,0),('1','146',258143,'DAILY SALES','2023-01-16','2023-01-16 05:31:51','2023-01-17 05:31:51','502',0.00,0.00,'502','2023-01-16 20:45:46','502','2023-01-16 20:46:08',10,0),('1','146',258144,'DAILY SALES','2023-01-17','2023-01-17 06:02:37','2023-01-18 06:02:37','502',0.00,0.00,'502','2023-01-17 20:09:53','502','2023-01-17 20:10:22',10,0),('1','146',258145,'DAILY SALES','2023-01-18','2023-01-18 06:07:35','2023-01-19 06:07:35','502',0.00,0.00,'502','2023-01-18 09:39:10','502','2023-01-18 09:39:30',10,0),('1','146',258146,'NEW-STOCK DAILY SALES','2023-01-18','2023-01-18 09:41:40','2023-01-19 09:41:40','502',0.00,0.00,'502','2023-01-18 23:55:44','502','2023-01-18 23:56:12',10,0),('1','146',258147,'DAILY SALES','2023-01-19','2023-01-19 06:05:20','2023-01-20 06:05:20','502',0.00,0.00,'502','2023-01-19 20:03:28','502','2023-01-19 20:03:57',10,0),('1','146',258148,'DAILY SALES','2023-01-20','2023-01-20 06:18:35','2023-01-21 06:18:35','502',0.00,0.00,'502','2023-01-20 17:31:49','502','2023-01-20 17:32:16',10,0),('1','146',258149,'NEW-STOCK DAILY SALES','2023-01-20','2023-01-20 17:34:30','2023-01-21 17:34:30','502',0.00,0.00,'502','2023-01-20 19:54:55','502','2023-01-20 19:55:31',10,0),('1','146',258150,'DAILY SALES','2023-01-21','2023-01-21 06:01:23','2023-01-22 06:01:23','502',0.00,0.00,'502','2023-01-21 19:55:28','502','2023-01-21 19:55:54',10,0),('1','146',258151,'DAILY SALES','2023-01-22','2023-01-22 06:53:56','2023-01-23 06:53:56','502',0.00,0.00,'502','2023-01-22 20:37:26','502','2023-01-22 20:38:04',10,0),('1','146',258152,'DAILY SALES','2023-01-23','2023-01-23 06:06:59','2023-01-24 06:06:59','502',0.00,0.00,'502','2023-01-23 09:07:20','502','2023-01-23 09:07:38',10,0),('1','146',258153,'DAILY SALES NEW STOCK ','2023-01-23','2023-01-23 09:09:58','2023-01-24 09:09:58','502',0.00,0.00,'502','2023-01-23 20:18:53','502','2023-01-23 20:19:17',10,0),('1','146',258154,'DAILY SALES','2023-01-24','2023-01-24 06:08:02','2023-01-25 06:08:02','502',0.00,0.00,'502','2023-01-24 20:28:25','502','2023-01-24 20:28:57',10,0),('1','146',258155,'DAILY SALES','2023-01-25','2023-01-25 06:08:59','2023-01-26 06:08:59','502',0.00,0.00,'502','2023-01-25 11:05:23','502','2023-01-25 11:05:43',10,0),('1','146',258156,'NEW-STOCK DAILY SALES','2023-01-25','2023-01-25 11:31:54','2023-01-26 11:31:54','502',0.00,0.00,'502','2023-01-25 20:16:58','502','2023-01-25 20:17:22',10,0),('1','146',258157,'DAILY SALES','2023-01-26','2023-01-26 06:04:37','2023-01-27 06:04:37','502',0.00,0.00,'502','2023-01-26 20:20:33','502','2023-01-26 20:20:59',10,0),('1','146',258158,'DAILY SALES','2023-01-27','2023-01-27 06:24:51','2023-01-28 06:24:51','502',0.00,0.00,'502','2023-01-27 13:47:45','502','2023-01-27 13:48:41',10,0),('1','146',258159,'NEW-STOCK DAILY SALES','2023-01-27','2023-01-27 13:52:31','2023-01-28 13:52:31','502',0.00,0.00,'502','2023-01-27 21:01:34','502','2023-01-27 21:01:57',10,0),('1','146',258160,'DAILY SALES','2023-01-28','2023-01-28 06:03:56','2023-01-29 06:03:56','502',0.00,0.00,'502','2023-01-28 20:20:37','502','2023-01-28 20:21:07',10,0),('1','146',258161,'DAILY SALES','2023-01-29','2023-01-29 06:33:01','2023-01-30 06:33:01','502',0.00,0.00,'502','2023-01-29 14:03:13','502','2023-01-29 14:03:40',10,0),('1','146',258162,'NEW-STOCK DAILY SALES','2023-01-29','2023-01-29 14:06:54','2023-01-30 14:06:54','502',0.00,0.00,'502','2023-01-29 20:58:35','502','2023-01-29 20:59:08',10,0),('1','146',258163,'DAILY SALES','2023-01-30','2023-01-30 06:06:42','2023-01-31 06:06:42','502',0.00,0.00,'502','2023-01-30 20:36:23','502','2023-01-30 20:36:51',10,0),('1','146',258164,'DAILY SALES','2023-01-31','2023-01-31 06:39:56','2023-02-01 06:39:56','502',0.00,0.00,'502','2023-01-31 21:08:31','502','2023-01-31 21:08:57',10,0),('1','146',258165,'DAILY SALES','2023-02-01','2023-02-01 09:01:20','2023-02-02 09:01:20','502',0.00,0.00,'502','2023-02-01 21:34:48','502','2023-02-01 21:35:06',10,0),('1','146',258166,'DAILY SALES','2023-02-02','2023-02-02 06:06:05','2023-02-03 06:06:05','502',0.00,0.00,'502','2023-02-02 20:16:47','502','2023-02-02 20:17:08',10,0),('1','146',258167,'DAILY SALES NEW STOCK ','2023-02-03','2023-02-03 05:41:22','2023-02-04 05:41:22','502',0.00,0.00,'502','2023-02-03 20:38:45','502','2023-02-03 20:39:16',10,0),('1','146',258168,'DAILY SALES','2023-02-04','2023-02-04 06:03:19','2023-02-05 06:03:19','502',0.00,0.00,'502','2023-02-04 20:46:27','502','2023-02-04 20:46:48',10,0),('1','146',258169,'DAILY SALES','2023-02-05','2023-02-05 07:07:22','2023-02-06 07:07:22','502',0.00,0.00,'502','2023-02-05 21:00:56','502','2023-02-05 21:01:43',10,0),('1','146',258170,'DAILY SALES','2023-02-06','2023-02-06 06:05:54','2023-02-07 06:05:54','502',0.00,0.00,'502','2023-02-06 16:29:47','502','2023-02-06 16:30:16',10,0),('1','146',258171,'NEW-STOCK DAILY SALES','2023-02-06','2023-02-06 17:22:42','2023-02-07 17:22:42','502',0.00,0.00,'502','2023-02-06 20:28:55','502','2023-02-06 20:29:21',10,0),('1','146',258172,'DAILY SALES','2023-02-07','2023-02-07 06:40:26','2023-02-08 06:40:26','502',0.00,0.00,'502','2023-02-07 21:12:04','502','2023-02-07 21:12:34',10,0),('1','146',258173,'DAILY SALES','2023-02-08','2023-02-08 06:03:17','2023-02-09 06:03:17','502',0.00,0.00,'502','2023-02-08 17:20:59','502','2023-02-08 17:21:48',10,0),('1','146',258174,'NEW-STOCK DAILY SALES','2023-02-08','2023-02-08 17:23:41','2023-02-09 17:23:41','502',0.00,0.00,'502','2023-02-08 20:33:00','502','2023-02-08 20:33:25',10,0),('1','146',258175,'DAILY SALES','2023-02-09','2023-02-09 06:06:41','2023-02-10 06:06:41','502',0.00,0.00,'502','2023-02-09 21:06:40','502','2023-02-09 21:07:09',10,0),('1','146',258176,'DAILY SALES','2023-02-10','2023-02-10 07:18:57','2023-02-11 07:18:57','502',0.00,0.00,'502','2023-02-10 16:55:12','502','2023-02-10 16:55:52',10,0),('1','146',258177,'DAILY SALES','2023-02-10','2023-02-10 16:59:00','2023-02-11 16:59:00','502',0.00,0.00,'502','2023-02-10 20:41:08','502','2023-02-10 20:41:40',10,0),('1','146',258178,'DAILY SALES','2023-02-11','2023-02-11 06:06:43','2023-02-12 06:06:43','502',0.00,0.00,'502','2023-02-11 20:31:40','502','2023-02-11 20:32:07',10,0),('1','146',258179,'DAILY SALES','2023-02-12','2023-02-12 07:15:51','2023-02-13 07:15:51','502',0.00,0.00,'502','2023-02-12 15:56:52','502','2023-02-12 15:57:11',10,0),('1','146',258180,'NEW-STOCK DAILY SALES','2023-02-12','2023-02-12 15:57:29','2023-02-13 15:57:29','502',0.00,0.00,'502','2023-02-12 21:28:00','502','2023-02-12 21:28:22',10,0),('1','146',258181,'DAILY SALES','2023-02-13','2023-02-13 06:08:29','2023-02-14 06:08:29','502',0.00,0.00,'502','2023-02-13 21:33:00','502','2023-02-13 21:33:25',10,0),('1','146',258182,'DAILY SALES','2023-02-14','2023-02-14 05:41:52','2023-02-15 05:41:52','502',0.00,0.00,'502','2023-02-14 13:11:04','502','2023-02-14 13:11:28',10,0),('1','146',258183,'NEW-STOCK DAILY SALES','2023-02-14','2023-02-14 14:21:02','2023-02-15 14:21:02','502',0.00,0.00,'502','2023-02-14 19:48:38','502','2023-02-14 19:49:01',10,0),('1','146',258184,'DAILY SALES','2023-02-15','2023-02-15 06:04:22','2023-02-16 06:04:22','502',0.00,0.00,'502','2023-02-15 20:34:13','502','2023-02-15 20:34:36',10,0),('1','146',258185,'DAILY SALES','2023-02-16','2023-02-16 05:34:02','2023-02-17 05:34:02','502',0.00,0.00,'502','2023-02-16 16:30:34','502','2023-02-16 16:30:56',10,0),('1','146',258186,'OPERATIONAL LOSS','2023-02-16','2023-02-16 16:44:43','2023-02-17 16:44:43','502',0.00,0.00,'502','2023-02-16 16:49:56','502','2023-02-16 16:50:17',10,0),('1','146',258187,'DAILY SALES','2023-02-16','2023-02-16 19:46:32','2023-02-17 19:46:32','502',0.00,0.00,'502','2023-02-16 20:38:52','502','2023-02-16 20:39:09',10,0),('1','146',258188,'DAILY SALES','2023-02-17','2023-02-17 06:13:56','2023-02-18 06:13:56','502',0.00,0.00,'502','2023-02-17 21:26:51','502','2023-02-17 21:27:14',10,0),('1','146',258189,'DAILY SALES','2023-02-18','2023-02-18 06:06:25','2023-02-19 06:06:25','502',0.00,0.00,'502','2023-02-18 16:56:02','502','2023-02-18 16:56:38',10,0),('1','146',258190,'OPERATIONAL LOSS','2023-02-18','2023-02-18 16:58:02','2023-02-19 16:58:02','502',0.00,0.00,'502','2023-02-18 17:03:21','502','2023-02-18 17:03:42',10,0),('1','146',258191,'NEW-STOCK DAILY SALES','2023-02-18','2023-02-18 17:06:45','2023-02-19 17:06:45','502',0.00,0.00,'502','2023-02-18 21:27:19','502','2023-02-18 21:27:48',10,0),('1','146',258192,'DAILY SALES','2023-02-19','2023-02-19 07:29:40','2023-02-20 07:29:40','502',0.00,0.00,'502','2023-02-19 20:52:56','502','2023-02-19 20:53:40',10,0),('1','146',258193,'DAILY SALES','2023-02-20','2023-02-20 06:00:53','2023-02-21 06:00:53','502',0.00,0.00,'502','2023-02-20 13:50:40','502','2023-02-20 13:50:59',10,0),('1','146',258194,'NEW-STOCK DAILY SALES','2023-02-20','2023-02-20 13:57:10','2023-02-21 13:57:10','502',0.00,0.00,'502','2023-02-20 21:19:28','502','2023-02-20 21:20:21',10,0),('1','146',258195,'DAILY SALES','2023-02-21','2023-02-21 06:07:04','2023-02-22 06:07:04','502',0.00,0.00,'502','2023-02-21 22:09:50','502','2023-02-21 22:10:11',10,0),('1','146',258196,'DAILY SALES','2023-02-22','2023-02-22 06:16:27','2023-02-23 06:16:27','502',0.00,0.00,'502','2023-02-23 06:32:26','502','2023-02-23 06:32:55',10,0),('1','146',258197,'DAILY SALES','2023-02-23','2023-02-23 06:33:52','2023-02-24 06:33:52','502',0.00,0.00,'502','2023-02-23 15:05:28','502','2023-02-23 15:05:48',10,0),('1','146',258198,'NEW-STOCK DAILY SALES','2023-02-23','2023-02-23 15:13:18','2023-02-24 15:13:18','502',0.00,0.00,'502','2023-02-23 20:23:37','502','2023-02-23 20:24:27',10,0),('1','146',258199,'DAILY SALES','2023-02-24','2023-02-24 06:07:51','2023-02-25 06:07:51','502',0.00,0.00,'502','2023-02-24 22:18:38','502','2023-02-24 22:19:04',10,0),('1','146',258200,'DAILY SALES','2023-02-26','2023-02-26 06:06:34','2023-02-27 06:06:34','502',0.00,0.00,'502','2023-02-26 06:28:22','502','2023-02-26 06:28:40',10,0),('1','146',258201,'OPERATIONAL LOSS','2023-02-26','2023-02-26 06:30:35','2023-02-27 06:30:35','502',0.00,0.00,'502','2023-02-26 06:35:15','502','2023-02-26 06:35:33',10,0),('1','146',258202,'DAILY SALES NEW STOCK ','2023-02-26','2023-02-26 06:37:53','2023-02-27 06:37:53','502',0.00,0.00,'502','2023-02-26 20:37:59','502','2023-02-26 20:38:29',10,0),('1','146',258203,'DAILY SALES','2023-02-27','2023-02-27 06:14:40','2023-02-28 06:14:40','502',0.00,0.00,'502','2023-02-27 16:54:06','502','2023-02-27 16:54:26',10,0),('1','146',258204,'DAILY SALES NEW STOCK ','2023-02-27','2023-02-27 17:09:04','2023-02-28 17:09:04','502',0.00,0.00,'502','2023-02-27 20:36:46','502','2023-02-27 20:37:15',10,0),('1','146',258205,'DAILY SALES','2023-02-28','2023-02-28 06:09:49','2023-03-01 06:09:49','502',0.00,0.00,'502','2023-02-28 21:08:35','502','2023-02-28 21:09:12',10,0),('1','146',258206,'DAILY SALES','2023-03-01','2023-03-01 06:10:12','2023-03-02 06:10:12','502',0.00,0.00,'502','2023-03-02 00:16:50','502','2023-03-02 00:17:16',10,0),('1','146',258207,'DAILY SALES','2023-03-02','2023-03-02 06:21:18','2023-03-03 06:21:18','502',0.00,0.00,'502','2023-03-02 20:45:50','502','2023-03-02 20:46:16',10,0),('1','146',258208,'DAILY SALES','2023-03-03','2023-03-03 06:08:31','2023-03-04 06:08:31','502',0.00,0.00,'502','2023-03-03 16:52:01','502','2023-03-03 16:52:23',10,0),('1','146',258209,'DAILY SALES','2023-03-03','2023-03-03 18:40:22','2023-03-04 18:40:22','502',0.00,0.00,'502','2023-03-03 20:35:44','502','2023-03-03 20:36:02',10,0),('1','146',258210,'DAILY SALES','2023-03-04','2023-03-04 06:12:40','2023-03-05 06:12:40','502',0.00,0.00,'502','2023-03-04 20:14:47','502','2023-03-04 20:15:10',10,0),('1','146',258211,'DAILY SALES','2023-03-05','2023-03-05 06:05:37','2023-03-06 06:05:37','502',0.00,0.00,'502','2023-03-05 17:14:33','502','2023-03-05 17:14:55',10,0),('1','146',258212,'NEW-STOCK DAILY SALES','2023-03-05','2023-03-05 17:17:36','2023-03-06 17:17:36','502',0.00,0.00,'502','2023-03-05 20:43:54','502','2023-03-05 20:44:14',10,0),('1','146',258213,'DAILY SALES','2023-03-06','2023-03-06 06:56:56','2023-03-07 06:56:56','502',0.00,0.00,'502','2023-03-06 20:03:28','502','2023-03-06 20:04:05',10,0),('1','146',258214,'DAILY SALES','2023-03-07','2023-03-07 06:10:43','2023-03-08 06:10:43','502',0.00,0.00,'502','2023-03-07 20:12:18','502','2023-03-07 20:12:46',10,0),('1','146',258215,'DAILY SALES','2023-03-08','2023-03-08 06:31:19','2023-03-09 06:31:19','502',0.00,0.00,'502','2023-03-08 10:43:30','502','2023-03-08 10:43:47',10,0),('1','146',258216,'DAILY SALES NEW PRICE','2023-03-08','2023-03-08 10:44:20','2023-03-09 10:44:20','502',0.00,0.00,'502','2023-03-08 21:07:24','502','2023-03-08 21:07:55',10,0),('1','146',258217,'DAILY SALES','2023-03-09','2023-03-09 06:24:30','2023-03-10 06:24:30','502',0.00,0.00,'502','2023-03-09 21:19:09','502','2023-03-09 21:19:41',10,0),('1','146',258218,'NEW-STOCK DAILY SALES','2023-03-10','2023-03-10 10:54:00','2023-03-11 10:54:00','502',0.00,0.00,'502','2023-03-10 20:24:25','502','2023-03-10 20:24:56',10,0),('1','146',258219,'DAILY SALES','2023-03-11','2023-03-11 06:41:15','2023-03-12 06:41:15','502',0.00,0.00,'502','2023-03-11 20:59:09','502','2023-03-11 20:59:29',10,0),('1','146',258220,'DAILY SALES','2023-03-12','2023-03-12 07:05:34','2023-03-13 07:05:34','502',0.00,0.00,'502','2023-03-12 21:43:01','502','2023-03-12 21:43:24',10,0),('1','146',258221,'DAILY SALES','2023-03-13','2023-03-13 06:24:23','2023-03-14 06:24:23','502',0.00,0.00,'502','2023-03-13 23:40:16','502','2023-03-13 23:40:33',10,0),('1','146',258222,'DAILY SALES NEW STOCK ','2023-03-14','2023-03-14 06:10:15','2023-03-15 06:10:15','502',0.00,0.00,'502','2023-03-14 21:04:27','502','2023-03-14 21:07:41',10,0),('1','146',258223,'DAILY SALES','2023-03-15','2023-03-15 06:45:23','2023-03-16 06:45:23','502',0.00,0.00,'502','2023-03-15 18:19:39','502','2023-03-15 18:20:01',10,0),('1','146',258224,'NEW-STOCK DAILY SALES','2023-03-15','2023-03-15 18:21:54','2023-03-16 18:21:54','502',0.00,0.00,'502','2023-03-15 20:25:00','502','2023-03-15 20:25:34',10,0),('1','146',258225,'DAILY SALES','2023-03-16','2023-03-16 05:58:33','2023-03-17 05:58:33','502',0.00,0.00,'502','2023-03-16 20:51:30','502','2023-03-16 20:51:54',10,0),('1','146',258226,'DAILY SALES','2023-03-17','2023-03-17 06:10:16','2023-03-18 06:10:16','502',0.00,0.00,'502','2023-03-17 20:40:10','502','2023-03-17 21:03:05',10,0),('1','146',258227,'DAILY SALES','2023-03-18','2023-03-18 07:14:55','2023-03-19 07:14:55','502',0.00,0.00,'502','2023-03-18 20:50:54','502','2023-03-18 20:51:25',10,0),('1','146',258228,'DAILY SALES','2023-03-19','2023-03-19 06:02:46','2023-03-20 06:02:46','502',0.00,0.00,'502','2023-03-19 18:32:45','502','2023-03-19 18:33:16',10,0),('1','146',258229,'DAILY SALES NEW STOCK','2023-03-19','2023-03-19 18:36:24','2023-03-20 18:36:24','502',0.00,0.00,'502','2023-03-19 21:14:31','502','2023-03-19 21:14:49',10,0),('1','146',258230,'DAILY SALES','2023-03-20','2023-03-20 06:52:32','2023-03-21 06:52:32','502',0.00,0.00,'502','2023-03-20 20:17:23','502','2023-03-20 20:18:05',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4906377 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','146','767','146909',2938869,'2138','325',0.00,1531.07,0.00,0.00,1531.07,428699.60,0.00,0.00,0.00),('1','146','767','146929',2939129,'2138','325',1531.07,2862.85,0.00,0.00,1331.78,372898.40,0.00,0.00,0.00),('1','146','767','146935',2939212,'2138','325',2862.85,4750.70,0.00,0.00,1887.85,528598.00,0.00,0.00,0.00),('1','146','767','146960',2939706,'2138','325',4750.70,5014.98,0.00,0.00,264.28,73998.40,0.00,0.00,0.00),('1','146','767','146976',2940077,'2138','325',5014.98,7612.12,0.00,0.00,2597.14,727199.20,0.00,0.00,0.00),('1','146','767','146988',2940276,'2138','325',7612.12,9855.12,0.00,0.00,2243.00,628040.00,0.00,0.00,0.00),('1','146','767','147014',2940616,'2138','325',9855.12,11652.62,0.00,0.00,1797.50,503300.00,0.00,0.00,0.00),('1','146','767','147017',2940649,'2138','325',11652.62,13972.62,0.00,0.00,2320.00,649600.00,0.00,0.00,0.00),('1','146','767','147035',2940834,'2138','325',13972.62,15354.62,0.00,0.00,1382.00,386960.00,0.00,0.00,0.00),('1','146','767','147077',2941523,'2138','325',15354.62,15610.69,0.00,0.00,256.07,71699.60,0.00,0.00,0.00),('1','146','767','147083',2941572,'2138','325',15610.69,18068.90,0.00,0.00,2458.21,688298.80,0.00,0.00,0.00),('1','146','767','147087',2941578,'2138','325',18068.90,20884.90,0.00,0.00,2816.00,788480.00,0.00,0.00,0.00),('1','146','767','147301',2944166,'2138','325',20884.90,22227.40,0.00,0.00,1342.50,375900.00,0.00,0.00,0.00),('1','146','767','147304',2944202,'2138','325',22227.40,23849.90,0.00,0.00,1622.50,454300.00,0.00,0.00,0.00),('1','146','767','147423',2946493,'2138','325',23849.90,25908.47,0.00,0.00,2058.57,576399.60,0.00,0.00,0.00),('1','146','767','147528',2948370,'2138','325',25908.47,26223.47,0.00,0.00,315.00,88200.00,0.00,0.00,0.00),('1','146','767','147532',2948433,'2138','325',26223.47,26309.47,0.00,0.00,86.00,24080.00,0.00,0.00,0.00),('1','146','767','147566',2949024,'2138','325',26309.47,27833.39,0.00,0.00,1523.92,426697.60,0.00,0.00,0.00),('1','146','767','147667',2950869,'2138','325',27833.39,30081.06,0.00,0.00,2247.67,629347.60,0.00,0.00,0.00),('1','146','767','147842',2953918,'2138','325',30081.06,31459.06,0.00,0.00,1378.00,385840.00,0.00,0.00,0.00),('1','146','767','147984',2956293,'2138','325',31459.06,33729.77,0.00,0.00,2270.71,635798.80,0.00,0.00,0.00),('1','146','767','148112',2958536,'2138','325',33729.77,35230.12,0.00,0.00,1500.35,420098.00,0.00,0.00,0.00),('1','146','767','148247',2961035,'2138','325',35230.12,36739.12,0.00,0.00,1509.00,422520.00,0.00,0.00,0.00),('1','146','767','148411',2963726,'2138','325',36739.12,38984.47,0.00,0.00,2245.35,628698.00,0.00,0.00,0.00),('1','146','767','148542',2965993,'2138','325',38984.47,41179.47,0.00,0.00,2195.00,614600.00,0.00,0.00,0.00),('1','146','767','148669',2968072,'2138','325',41179.47,43197.32,0.00,0.00,2017.85,564998.00,0.00,0.00,0.00),('1','146','767','148797',2970117,'2138','325',43197.32,45056.60,0.00,0.00,1859.28,520598.40,0.00,0.00,0.00),('1','146','767','148940',2972929,'2138','325',45056.60,47046.60,0.00,0.00,1990.00,557200.00,0.00,0.00,0.00),('1','146','767','149149',2976919,'2138','325',47046.60,49406.13,0.00,0.00,2359.53,660668.40,0.00,0.00,0.00),('1','146','767','149293',2979421,'2138','325',49406.13,51458.27,0.00,0.00,2052.14,574599.20,0.00,0.00,0.00),('1','146','767','149439',2981889,'2138','325',51458.27,52581.27,0.00,0.00,1123.00,314440.00,0.00,0.00,0.00),('1','146','767','149599',2984595,'2138','325',52581.27,55969.62,0.00,0.00,3388.35,948738.00,0.00,0.00,0.00),('1','146','767','149695',2986024,'2138','325',55969.62,57836.40,0.00,0.00,1866.78,522698.40,0.00,0.00,0.00),('1','146','767','149861',2989081,'2138','325',57836.40,60660.32,0.00,0.00,2823.92,790697.60,0.00,0.00,0.00),('1','146','767','150012',2991928,'2138','325',60660.32,63196.32,0.00,0.00,2536.00,710080.00,0.00,0.00,0.00),('1','146','767','150164',2994990,'2138','325',63196.32,65492.57,0.00,0.00,2296.25,642950.00,0.00,0.00,0.00),('1','146','767','150367',2998181,'2138','325',65492.57,67543.64,0.00,0.00,2051.07,574299.60,0.00,0.00,0.00),('1','146','767','150460',3000027,'2138','325',67543.64,68416.64,0.00,0.00,873.00,244440.00,0.00,0.00,0.00),('1','146','767','150542',3001727,'2138','325',68416.64,69203.06,0.00,0.00,786.42,220197.60,0.00,0.00,0.00),('1','146','767','150702',3005009,'2138','325',69203.06,71442.70,0.00,0.00,2239.64,627099.20,0.00,0.00,0.00),('1','146','767','150803',3006855,'2138','325',71442.70,72166.70,0.00,0.00,724.00,202720.00,0.00,0.00,0.00),('1','146','767','150839',3007406,'2138','325',72166.70,73559.55,0.00,0.00,1392.85,389998.00,0.00,0.00,0.00),('1','146','767','150963',3009756,'2138','325',73559.55,74552.55,0.00,0.00,993.00,278040.00,0.00,0.00,0.00),('1','146','767','150974',3009979,'2138','325',74552.55,75730.40,0.00,0.00,1177.85,329798.00,0.00,0.00,0.00),('1','146','767','151135',3012872,'2138','325',75730.40,78333.61,0.00,0.00,2603.21,728898.80,0.00,0.00,0.00),('1','146','767','151283',3015762,'2138','325',78333.61,79752.61,0.00,0.00,1419.00,397320.00,0.00,0.00,0.00),('1','146','767','151417',3018321,'2138','325',79752.61,82384.39,0.00,0.00,2631.78,736898.40,0.00,0.00,0.00),('1','146','767','151591',3021327,'2138','325',82384.39,84777.71,0.00,0.00,2393.32,670129.60,0.00,0.00,0.00),('1','146','767','151679',3022949,'2138','325',84777.71,85562.71,0.00,0.00,785.00,219800.00,0.00,0.00,0.00),('1','146','767','151705',3023365,'2138','325',85562.71,86480.56,0.00,0.00,917.85,256998.00,0.00,0.00,0.00),('1','146','767','151807',3025310,'2138','325',86480.56,88839.13,0.00,0.00,2358.57,660399.60,0.00,0.00,0.00),('1','146','767','151997',3029031,'2138','325',88839.13,90808.05,0.00,0.00,1968.92,551297.60,0.00,0.00,0.00),('1','146','767','152162',3031929,'2138','325',90808.05,91242.05,0.00,0.00,434.00,121520.00,0.00,0.00,0.00),('1','146','767','152164',3031932,'2138','325',91242.05,92608.83,0.00,0.00,1366.78,382698.40,0.00,0.00,0.00),('1','146','767','152319',3035011,'2138','325',92608.83,94974.18,0.00,0.00,2365.35,662298.00,0.00,0.00,0.00),('1','146','767','152461',3037500,'2138','325',94974.18,96600.60,0.00,0.00,1626.42,455397.60,0.00,0.00,0.00),('1','146','767','152610',3040183,'2138','325',96600.60,97140.45,0.00,0.00,539.85,151158.00,0.00,0.00,0.00),('1','146','767','152613',3040204,'2138','325',97140.45,98425.80,0.00,0.00,1285.35,359898.00,0.00,0.00,0.00),('1','146','767','152749',3042720,'2138','325',98425.80,100659.73,0.00,0.00,2233.93,625500.40,0.00,0.00,0.00),('1','146','767','152888',3045257,'2138','325',100659.73,102930.73,0.00,0.00,2271.00,635880.00,0.00,0.00,0.00),('1','146','767','153070',3048433,'2138','325',102930.73,105189.30,0.00,0.00,2258.57,632399.60,0.00,0.00,0.00),('1','146','767','153256',3051682,'2138','325',105189.30,107202.87,0.00,0.00,2013.57,563799.60,0.00,0.00,0.00),('1','146','767','153474',3055749,'2138','325',107202.87,108669.87,0.00,0.00,1467.00,410760.00,0.00,0.00,0.00),('1','146','767','153626',3058564,'2138','325',108669.87,111459.15,0.00,0.00,2789.28,780998.40,0.00,0.00,0.00),('1','146','767','153803',3061624,'2138','325',111459.15,112806.15,0.00,0.00,1347.00,377160.00,0.00,0.00,0.00),('1','146','767','153917',3063828,'2138','325',112806.15,115757.93,0.00,0.00,2951.78,826498.40,0.00,0.00,0.00),('1','146','767','154057',3066093,'2138','325',115757.93,118059.21,0.00,0.00,2301.28,644358.40,0.00,0.00,0.00),('1','146','767','154242',3069409,'2138','325',118059.21,118756.21,0.00,0.00,697.00,195160.00,0.00,0.00,0.00),('1','146','767','154244',3069432,'2138','325',118756.21,120901.56,0.00,0.00,2145.35,600698.00,0.00,0.00,0.00),('1','146','767','154376',3071916,'2138','325',120901.56,121318.56,0.00,0.00,417.00,116760.00,0.00,0.00,0.00),('1','146','767','154590',3075966,'2138','325',121318.56,123266.41,0.00,0.00,1947.85,545398.00,0.00,0.00,0.00),('1','146','767','154727',3078630,'2138','325',123266.41,125967.83,0.00,0.00,2701.42,756397.60,0.00,0.00,0.00),('1','146','767','154873',3081279,'2138','325',125967.83,127187.83,0.00,0.00,1220.00,341600.00,0.00,0.00,0.00),('1','146','767','154882',3081357,'2138','325',127187.83,127634.25,0.00,0.00,446.42,124997.60,0.00,0.00,0.00),('1','146','767','155012',3083922,'2138','325',127634.25,130400.67,0.00,0.00,2766.42,774597.60,0.00,0.00,0.00),('1','146','767','155125',3086052,'2138','325',130400.67,131655.67,0.00,0.00,1255.00,351400.00,0.00,0.00,0.00),('1','146','767','155305',3089333,'2138','325',131655.67,135141.74,0.00,0.00,3486.07,976099.60,0.00,0.00,0.00),('1','146','767','155455',3092274,'2138','325',135141.74,137455.74,0.00,0.00,2314.00,647920.00,0.00,0.00,0.00),('1','146','767','155646',3095700,'2138','325',137455.74,140115.38,0.00,0.00,2659.64,744699.20,0.00,0.00,0.00),('1','146','767','155773',3098025,'2138','325',140115.38,142800.02,0.00,0.00,2684.64,751699.20,0.00,0.00,0.00),('1','146','767','155909',3100321,'2138','325',142800.02,143395.02,0.00,0.00,595.00,166600.00,0.00,0.00,0.00),('1','146','767','155932',3100763,'2138','325',143395.02,144318.94,0.00,0.00,923.92,258697.60,0.00,0.00,0.00),('1','146','767','156081',3103445,'2138','325',144318.94,146426.44,0.00,0.00,2107.50,590100.00,0.00,0.00,0.00),('1','146','767','156204',3105651,'2138','325',146426.44,148430.72,0.00,0.00,2004.28,561198.40,0.00,0.00,0.00),('1','146','767','156364',3108538,'2138','325',148430.72,149261.43,0.00,0.00,830.71,232598.80,0.00,0.00,0.00),('1','146','767','156423',3109625,'2138','325',149261.43,150250.71,0.00,0.00,989.28,276998.40,0.00,0.00,0.00),('1','146','767','156567',3112409,'2138','325',150250.71,152653.92,0.00,0.00,2403.21,672898.80,0.00,0.00,0.00),('1','146','767','156731',3115461,'2138','325',152653.92,154547.49,0.00,0.00,1893.57,530199.60,0.00,0.00,0.00),('1','146','767','156797',3116602,'2138','325',154547.49,154651.49,0.00,0.00,104.00,29120.00,0.00,0.00,0.00),('1','146','767','156910',3118576,'2138','325',154651.49,156075.41,0.00,0.00,1423.92,398697.60,0.00,0.00,0.00),('1','146','767','157032',3120941,'2138','325',156075.41,157201.41,0.00,0.00,1126.00,315280.00,0.00,0.00,0.00),('1','146','767','157086',3121769,'2138','325',157201.41,158329.98,0.00,0.00,1128.57,315999.60,0.00,0.00,0.00),('1','146','767','157190',3123607,'2138','325',158329.98,158614.98,0.00,0.00,285.00,79800.00,0.00,0.00,0.00),('1','146','767','157284',3125320,'2138','325',158614.98,160433.94,0.00,0.00,1818.96,509308.80,0.00,0.00,0.00),('1','146','767','157440',3127955,'2138','325',160433.94,163084.65,0.00,0.00,2650.71,742198.80,0.00,0.00,0.00),('1','146','767','157658',3131825,'2138','325',163084.65,164477.65,0.00,0.00,1393.00,390040.00,0.00,0.00,0.00),('1','146','767','157803',3134545,'2138','325',164477.65,167017.65,0.00,0.00,2540.00,711200.00,0.00,0.00,0.00),('1','146','767','157952',3137331,'2138','325',167017.65,169029.43,0.00,0.00,2011.78,563298.40,0.00,0.00,0.00),('1','146','767','158088',3139797,'2138','325',169029.43,170830.85,0.00,0.00,1801.42,504397.60,0.00,0.00,0.00),('1','146','767','158261',3143058,'2138','325',170830.85,172353.35,0.00,0.00,1522.50,426300.00,0.00,0.00,0.00),('1','146','767','158425',3146209,'2138','325',172353.35,174594.06,0.00,0.00,2240.71,627398.80,0.00,0.00,0.00),('1','146','767','158577',3148743,'2138','325',174594.06,176672.98,0.00,0.00,2078.92,582097.60,0.00,0.00,0.00),('1','146','767','158700',3151200,'2138','325',176672.98,178689.76,0.00,0.00,2016.78,564698.40,0.00,0.00,0.00),('1','146','767','158938',3155177,'2138','325',178689.76,179511.18,0.00,0.00,821.42,229997.60,0.00,0.00,0.00),('1','146','767','158939',3155178,'2138','325',179511.18,181224.15,0.00,0.00,1712.97,507039.12,0.00,0.00,0.00),('1','146','767','159122',3158413,'2138','325',181224.15,183060.97,0.00,0.00,1836.82,543698.72,0.00,0.00,0.00),('1','146','767','159273',3161402,'2138','325',183060.97,183388.67,0.00,0.00,327.70,96999.20,0.00,0.00,0.00),('1','146','767','159276',3161431,'2138','325',183388.67,185588.50,0.00,0.00,2199.83,651149.68,0.00,0.00,0.00),('1','146','767','159459',3164200,'2138','325',185588.50,187308.09,0.00,0.00,1719.59,508998.64,0.00,0.00,0.00),('1','146','767','159751',3169234,'2138','325',187308.09,188099.57,0.00,0.00,791.48,234278.08,0.00,0.00,0.00),('1','146','767','159759',3169355,'2138','325',188099.57,189623.48,0.00,0.00,1523.91,463268.64,0.00,0.00,0.00),('1','146','767','159763',3169407,'2138','325',189623.48,191819.36,0.00,0.00,2195.88,667547.52,0.00,0.00,0.00),('1','146','767','159950',3172866,'2138','325',191819.36,192255.54,0.00,0.00,436.18,132598.72,0.00,0.00,0.00),('1','146','767','159952',3172869,'2138','325',192255.54,194110.47,0.00,0.00,1854.93,563898.72,0.00,0.00,0.00),('1','146','767','160133',3176346,'2138','325',194110.47,196656.85,0.00,0.00,2546.38,774099.52,0.00,0.00,0.00),('1','146','767','160295',3179300,'2138','325',196656.85,197173.95,0.00,0.00,517.10,157198.40,0.00,0.00,0.00),('1','146','767','160306',3179365,'2138','325',197173.95,198633.81,0.00,0.00,1459.86,443797.44,0.00,0.00,0.00),('1','146','767','160451',3182075,'2138','325',198633.81,201303.02,0.00,0.00,2669.21,854147.20,0.00,0.00,0.00),('1','146','767','160582',3184515,'2138','325',201303.02,202414.58,0.00,0.00,1111.56,355699.20,0.00,0.00,0.00),('1','146','767','160591',3184589,'2138','325',202414.58,203275.51,0.00,0.00,860.93,275497.60,0.00,0.00,0.00),('1','146','767','160737',3186977,'2138','325',203275.51,205955.66,0.00,0.00,2680.15,857648.00,0.00,0.00,0.00),('1','146','767','160895',3189589,'2138','325',205955.66,206338.47,0.00,0.00,382.81,122499.20,0.00,0.00,0.00),('1','146','767','160897',3189618,'2138','325',206338.47,207697.06,0.00,0.00,1358.59,434748.80,0.00,0.00,0.00),('1','146','767','161085',3193121,'2138','325',207697.06,210053.68,0.00,0.00,2356.62,754118.40,0.00,0.00,0.00),('1','146','767','161241',3196077,'2138','325',210053.68,210708.11,0.00,0.00,654.43,209417.60,0.00,0.00,0.00),('1','146','767','161266',3196542,'2138','325',210708.11,212244.98,0.00,0.00,1536.87,491798.40,0.00,0.00,0.00),('1','146','767','161454',3199461,'2138','325',212244.98,214593.26,0.00,0.00,2348.28,751449.60,0.00,0.00,0.00),('1','146','767','161651',3202856,'2138','325',214593.26,215932.93,0.00,0.00,1339.67,428694.40,0.00,0.00,0.00),('1','146','767','161888',3206851,'2138','325',215932.93,217717.77,0.00,0.00,1784.84,571148.80,0.00,0.00,0.00),('1','146','767','162047',3209793,'2138','325',217717.77,220316.20,0.00,0.00,2598.43,831497.60,0.00,0.00,0.00),('1','146','767','162211',3212751,'2138','325',220316.20,220828.04,0.00,0.00,511.84,155599.36,0.00,0.00,0.00),('1','146','767','162246',3213181,'2138','325',220828.04,222041.03,0.00,0.00,1212.99,368748.96,0.00,0.00,0.00),('1','146','767','162466',3216821,'2138','325',222041.03,224378.69,0.00,0.00,2337.66,710648.64,0.00,0.00,0.00),('1','146','767','162640',3219694,'2138','325',224378.69,226012.07,0.00,0.00,1633.38,496547.52,0.00,0.00,0.00),('1','146','767','162830',3223122,'2138','325',226012.07,228226.05,0.00,0.00,2213.98,673049.92,0.00,0.00,0.00),('1','146','767','163001',3226234,'2138','325',228226.05,230735.58,0.00,0.00,2509.53,762897.12,0.00,0.00,0.00),('1','146','767','163097',3227732,'2138','325',230735.58,231054.00,0.00,0.00,318.42,96799.68,0.00,0.00,0.00),('1','146','767','163213',3229915,'2138','325',231054.00,232397.25,0.00,0.00,1343.25,408348.00,0.00,0.00,0.00),('1','146','767','163368',3232695,'2138','325',232397.25,235353.00,0.00,0.00,2955.75,898548.00,0.00,0.00,0.00),('1','146','767','163537',3235836,'2138','325',235353.00,235775.69,0.00,0.00,422.69,128497.76,0.00,0.00,0.00),('1','146','767','163583',3236519,'2138','325',235775.69,237084.90,0.00,0.00,1309.21,397999.84,0.00,0.00,0.00),('1','146','767','163732',3239319,'2138','325',237084.90,239042.30,0.00,0.00,1957.40,595049.60,0.00,0.00,0.00),('1','146','767','163893',3242183,'2138','325',239042.30,241077.49,0.00,0.00,2035.19,618697.76,0.00,0.00,0.00),('1','146','767','164054',3245152,'2138','325',241077.49,243799.36,0.00,0.00,2721.87,827448.48,0.00,0.00,0.00),('1','146','767','164251',3248667,'2138','325',243799.36,245963.83,0.00,0.00,2164.47,657998.88,0.00,0.00,0.00),('1','146','767','164432',3252171,'2138','325',245963.83,246307.90,0.00,0.00,344.07,104597.28,0.00,0.00,0.00),('1','146','767','164435',3252190,'2138','325',246307.90,247772.70,0.00,0.00,1464.80,445299.20,0.00,0.00,0.00),('1','146','767','164642',3255695,'2138','325',247772.70,250410.52,0.00,0.00,2637.82,801897.28,0.00,0.00,0.00),('1','146','767','164743',3257764,'2138','325',250410.52,251205.58,0.00,0.00,795.06,241698.24,0.00,0.00,0.00),('1','146','767','164747',3257790,'2138','325',251205.58,252725.97,0.00,0.00,1520.39,462198.56,0.00,0.00,0.00),('1','146','767','164956',3261430,'2138','325',252725.97,255102.37,0.00,0.00,2376.40,731948.00,0.00,0.00,0.00),('1','146','767','165036',3262711,'2138','325',255102.37,255867.68,0.00,0.00,765.31,244899.20,0.00,0.00,0.00),('1','146','767','165122',3264363,'2138','325',255867.68,257572.05,0.00,0.00,1704.37,545398.40,0.00,0.00,0.00),('1','146','767','165284',3267152,'2138','325',257572.05,260191.12,0.00,0.00,2619.07,796197.28,0.00,0.00,0.00),('1','146','767','165472',3270316,'2138','325',260191.12,262172.07,0.00,0.00,1980.95,602208.80,0.00,0.00,0.00),('1','146','767','165601',3272644,'2138','325',262172.07,264362.03,0.00,0.00,2189.96,665747.84,0.00,0.00,0.00),('1','146','767','165783',3276127,'2138','325',264362.03,265731.43,0.00,0.00,1369.40,416297.60,0.00,0.00,0.00),('1','146','767','165934',3278747,'2138','325',265731.43,266979.45,0.00,0.00,1248.02,379398.08,0.00,0.00,0.00),('1','146','767','166018',3280172,'2138','325',266979.45,269911.35,0.00,0.00,2931.90,891297.60,0.00,0.00,0.00),('1','146','767','166166',3282767,'2138','325',269911.35,270927.46,0.00,0.00,1016.11,308897.44,0.00,0.00,0.00),('1','146','767','166171',3282826,'2138','325',270927.46,271821.21,0.00,0.00,893.75,271700.00,0.00,0.00,0.00),('1','146','767','166359',3286301,'2138','325',271821.21,273263.64,0.00,0.00,1442.43,438498.72,0.00,0.00,0.00),('1','146','767','166467',3288461,'2138','325',273263.64,275437.32,0.00,0.00,2173.68,660798.72,0.00,0.00,0.00),('1','146','767','166690',3292259,'2138','325',275437.32,276078.76,0.00,0.00,641.44,194997.76,0.00,0.00,0.00),('1','146','767','166692',3292276,'2138','325',276078.76,277777.60,0.00,0.00,1698.84,516447.36,0.00,0.00,0.00),('1','146','767','166870',3295379,'2138','325',277777.60,280188.06,0.00,0.00,2410.46,732779.84,0.00,0.00,0.00),('1','146','767','167203',3301173,'2138','325',280188.06,280443.98,0.00,0.00,255.92,77799.68,0.00,0.00,0.00),('1','146','767','167206',3301209,'2138','325',280443.98,281969.47,0.00,0.00,1525.49,463748.96,0.00,0.00,0.00),('1','146','767','167210',3301260,'2138','325',281969.47,284396.44,0.00,0.00,2426.97,737798.88,0.00,0.00,0.00),('1','146','767','167366',3304215,'2138','325',284396.44,284743.47,0.00,0.00,347.03,105497.12,0.00,0.00,0.00),('1','146','767','167371',3304263,'2138','325',284743.47,286334.58,0.00,0.00,1591.11,483697.44,0.00,0.00,0.00),('1','146','767','167564',3307837,'2138','325',286334.58,288812.86,0.00,0.00,2478.28,753397.12,0.00,0.00,0.00),('1','146','767','167774',3311315,'2138','325',288812.86,289732.76,0.00,0.00,919.90,279649.60,0.00,0.00,0.00),('1','146','767','167779',3311375,'2138','325',289732.76,291377.49,0.00,0.00,1644.73,499997.92,0.00,0.00,0.00),('1','146','767','167904',3313739,'2138','325',291377.49,293479.79,0.00,0.00,2102.30,639099.20,0.00,0.00,0.00),('1','146','767','168098',3317553,'2138','325',293479.79,293848.54,0.00,0.00,368.75,112100.00,0.00,0.00,0.00),('1','146','767','168162',3318473,'2138','325',293848.54,295626.17,0.00,0.00,1777.63,540399.52,0.00,0.00,0.00),('1','146','767','168393',3322899,'2138','325',295626.17,298394.26,0.00,0.00,2768.09,841499.36,0.00,0.00,0.00),('1','146','767','168491',3324494,'2138','325',298394.26,300878.47,0.00,0.00,2484.21,755199.84,0.00,0.00,0.00),('1','146','767','168594',3326399,'2138','325',300878.47,302893.43,0.00,0.00,2014.96,612547.84,0.00,0.00,0.00),('1','146','767','168770',3329681,'2138','325',302893.43,303852.64,0.00,0.00,959.21,291599.84,0.00,0.00,0.00),('1','146','767','168771',3329682,'2138','325',303852.64,305200.33,0.00,0.00,1347.69,409697.76,0.00,0.00,0.00),('1','146','767','168928',3332334,'2138','325',305200.33,307904.29,0.00,0.00,2703.96,822003.84,0.00,0.00,0.00),('1','146','767','169092',3335218,'2138','325',307904.29,309332.90,0.00,0.00,1428.61,434297.44,0.00,0.00,0.00),('1','146','767','169095',3335255,'2138','325',309332.90,311549.18,0.00,0.00,2216.28,673749.12,0.00,0.00,0.00),('1','146','767','169266',3338513,'2138','325',311549.18,313020.06,0.00,0.00,1470.88,447147.52,0.00,0.00,0.00),('1','146','767','169595',3345031,'2138','325',313020.06,313678.94,0.00,0.00,658.88,200299.52,0.00,0.00,0.00),('1','146','767','169597',3345055,'2138','325',313678.94,315613.94,0.00,0.00,1935.00,588240.00,0.00,0.00,0.00),('1','146','767','169598',3345056,'2138','325',315613.94,317168.22,0.00,0.00,1554.28,472501.12,0.00,0.00,0.00),('1','146','767','169808',3348774,'2138','325',317168.22,319445.52,0.00,0.00,2277.30,692299.20,0.00,0.00,0.00),('1','146','767','169918',3351117,'2138','325',319445.52,321581.04,0.00,0.00,2135.52,649198.08,0.00,0.00,0.00),('1','146','767','170119',3354601,'2138','325',321581.04,322247.15,0.00,0.00,666.11,202497.44,0.00,0.00,0.00),('1','146','767','170123',3354613,'2138','325',322247.15,323593.20,0.00,0.00,1346.05,409199.20,0.00,0.00,0.00),('1','146','767','170320',3357988,'2138','325',323593.20,325213.26,0.00,0.00,1620.06,492498.24,0.00,0.00,0.00),('1','146','767','170540',3361830,'2138','325',325213.26,326936.94,0.00,0.00,1723.68,523998.72,0.00,0.00,0.00),('1','146','767','170541',3361831,'2138','325',326936.94,327372.79,0.00,0.00,435.85,132498.40,0.00,0.00,0.00),('1','146','767','170808',3366749,'2138','325',327372.79,329448.77,0.00,0.00,2075.98,631097.92,0.00,0.00,0.00),('1','146','767','170809',3366750,'2138','325',329448.77,330490.17,0.00,0.00,1041.40,333248.00,0.00,0.00,0.00),('1','146','767','170877',3367816,'2138','325',330490.17,331309.23,0.00,0.00,819.06,262099.20,0.00,0.00,0.00),('1','146','767','171078',3371473,'2138','325',331309.23,333696.43,0.00,0.00,2387.20,763904.00,0.00,0.00,0.00),('1','146','767','171205',3374030,'2138','325',333696.43,335660.86,0.00,0.00,1964.43,628617.60,0.00,0.00,0.00),('1','146','767','171235',3374498,'2138','325',335660.86,336143.04,0.00,0.00,482.18,154297.60,0.00,0.00,0.00),('1','146','767','171365',3376951,'2138','325',336143.04,338330.22,0.00,0.00,2187.18,699897.60,0.00,0.00,0.00),('1','146','767','171616',3381329,'2138','325',338330.22,340592.40,0.00,0.00,2262.18,723897.60,0.00,0.00,0.00),('1','146','767','171618',3381342,'2138','325',340592.40,340775.52,0.00,0.00,183.12,58598.40,0.00,0.00,0.00),('1','146','767','171817',3384861,'2138','325',340775.52,342675.83,0.00,0.00,1900.31,608099.20,0.00,0.00,0.00),('1','146','767','171820',3384901,'2138','325',342675.83,344809.26,0.00,0.00,2133.43,682697.60,0.00,0.00,0.00),('1','146','767','172459',3396692,'2138','325',344809.26,345801.76,0.00,0.00,992.50,317600.00,0.00,0.00,0.00),('1','146','767','172461',3396712,'2138','325',345801.76,347210.01,0.00,0.00,1408.25,450640.00,0.00,0.00,0.00),('1','146','767','172570',3398600,'2138','325',347210.01,348618.26,0.00,0.00,1408.25,450640.00,0.00,0.00,0.00),('1','146','767','172574',3398676,'2138','325',348618.26,351196.38,0.00,0.00,2578.12,824998.40,0.00,0.00,0.00),('1','146','767','172596',3399013,'2138','325',351196.38,352374.06,0.00,0.00,1177.68,376857.60,0.00,0.00,0.00),('1','146','767','172656',3400233,'2138','325',352374.06,352374.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','172669',3400464,'2138','325',352374.06,352374.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','172672',3400483,'2138','325',352374.06,353618.66,0.00,0.00,1244.60,398272.00,0.00,0.00,0.00),('1','146','767','172792',3402698,'2138','325',353618.66,353618.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','172794',3402707,'2138','325',353618.66,356680.91,0.00,0.00,3062.25,979920.00,0.00,0.00,0.00),('1','146','767','172914',3404858,'2138','325',356680.91,357756.91,0.00,0.00,1076.00,344320.00,0.00,0.00,0.00),('1','146','767','172924',3405042,'2138','325',357756.91,358532.53,0.00,0.00,775.62,248198.40,0.00,0.00,0.00),('1','146','767','173041',3407396,'2138','325',358532.53,361425.81,0.00,0.00,2893.28,925849.60,0.00,0.00,0.00),('1','146','767','173184',3410361,'2138','325',361425.81,362757.99,0.00,0.00,1332.18,426297.60,0.00,0.00,0.00),('1','146','767','173198',3410665,'2138','325',362757.99,363945.33,0.00,0.00,1187.34,379948.80,0.00,0.00,0.00),('1','146','767','173422',3414474,'2138','325',363945.33,366303.45,0.00,0.00,2358.12,754598.40,0.00,0.00,0.00),('1','146','767','173486',3415643,'2138','325',366303.45,367405.95,0.00,0.00,1102.50,352800.00,0.00,0.00,0.00),('1','146','767','173580',3417601,'2138','325',367405.95,368714.70,0.00,0.00,1308.75,418800.00,0.00,0.00,0.00),('1','146','767','173850',3422440,'2138','325',368714.70,371341.73,0.00,0.00,2627.03,840649.60,0.00,0.00,0.00),('1','146','767','173891',3423254,'2138','325',371341.73,372416.10,0.00,0.00,1074.37,343798.40,0.00,0.00,0.00),('1','146','767','173929',3423908,'2138','325',372416.10,373313.28,0.00,0.00,897.18,287097.60,0.00,0.00,0.00),('1','146','767','174190',3428491,'2138','325',373313.28,375861.71,0.00,0.00,2548.43,815497.60,0.00,0.00,0.00),('1','146','767','174463',3433225,'2138','325',375861.71,377727.02,0.00,0.00,1865.31,596899.20,0.00,0.00,0.00),('1','146','767','174605',3435801,'2138','325',377727.02,380579.20,0.00,0.00,2852.18,912697.60,0.00,0.00,0.00),('1','146','767','174607',3435815,'2138','325',380579.20,382943.72,0.00,0.00,2364.52,756646.40,0.00,0.00,0.00),('1','146','767','174828',3439888,'2138','325',382943.72,385573.72,0.00,0.00,2630.00,841600.00,0.00,0.00,0.00),('1','146','767','175014',3443589,'2138','325',385573.72,388023.60,0.00,0.00,2449.88,881956.80,0.00,0.00,0.00),('1','146','767','175222',3447284,'2138','325',388023.60,390445.82,0.00,0.00,2422.22,871999.20,0.00,0.00,0.00),('1','146','767','175483',3451900,'2138','325',390445.82,393326.57,0.00,0.00,2880.75,1037070.00,0.00,0.00,0.00),('1','146','767','175585',3453892,'2138','325',393326.57,394994.62,0.00,0.00,1668.05,600498.00,0.00,0.00,0.00),('1','146','767','175892',3459377,'2138','325',394994.62,398283.09,0.00,0.00,3288.47,1183849.20,0.00,0.00,0.00),('1','146','767','175952',3460376,'2138','325',398283.09,401113.17,0.00,0.00,2830.08,1018828.80,0.00,0.00,0.00),('1','146','767','176127',3463658,'2138','325',401113.17,403583.97,0.00,0.00,2470.80,889488.00,0.00,0.00,0.00),('1','146','767','176311',3467116,'2138','325',403583.97,406110.91,0.00,0.00,2526.94,909698.40,0.00,0.00,0.00),('1','146','767','176525',3471138,'2138','325',406110.91,408572.43,0.00,0.00,2461.52,886147.20,0.00,0.00,0.00),('1','146','767','176732',3474834,'2138','325',408572.43,408864.51,0.00,0.00,292.08,105148.80,0.00,0.00,0.00),('1','146','767','176753',3475261,'2138','325',408864.51,410432.84,0.00,0.00,1568.33,564598.80,0.00,0.00,0.00),('1','146','767','176955',3479024,'2138','325',410432.84,410888.28,0.00,0.00,455.44,163958.40,0.00,0.00,0.00),('1','146','767','176968',3479186,'2138','325',410888.28,412923.28,0.00,0.00,2035.00,732600.00,0.00,0.00,0.00),('1','146','767','177190',3483636,'2138','325',412923.28,415990.64,0.00,0.00,3067.36,1104249.60,0.00,0.00,0.00),('1','146','767','177574',3491417,'2138','325',415990.64,419008.41,0.00,0.00,3017.77,1086397.20,0.00,0.00,0.00),('1','146','767','177661',3492861,'2138','325',419008.41,421190.07,0.00,0.00,2181.66,785397.60,0.00,0.00,0.00),('1','146','767','177855',3496473,'2138','325',421190.07,423450.20,0.00,0.00,2260.13,813646.80,0.00,0.00,0.00),('1','146','767','178099',3501099,'2138','325',423450.20,426496.55,0.00,0.00,3046.35,1096686.00,0.00,0.00,0.00),('1','146','767','178271',3504329,'2138','325',426496.55,428490.02,0.00,0.00,1993.47,717649.20,0.00,0.00,0.00),('1','146','767','178470',3508031,'2138','325',428490.02,431228.21,0.00,0.00,2738.19,985748.40,0.00,0.00,0.00),('1','146','767','178938',3516376,'2138','325',431228.21,432199.18,0.00,0.00,970.97,349549.20,0.00,0.00,0.00),('1','146','767','178942',3516428,'2138','325',432199.18,433102.65,0.00,0.00,903.47,325249.20,0.00,0.00,0.00),('1','146','767','179009',3517799,'2138','325',433102.65,435360.78,0.00,0.00,2258.13,812926.80,0.00,0.00,0.00),('1','146','767','179011',3517825,'2138','325',435360.78,437909.56,0.00,0.00,2548.78,917560.80,0.00,0.00,0.00),('1','146','767','179147',3520290,'2138','325',437909.56,438395.94,0.00,0.00,486.38,49996.80,0.00,0.00,0.00),('1','146','767','179186',3520961,'2138','325',438395.94,440802.34,0.00,0.00,2406.40,850804.00,0.00,0.00,0.00),('1','146','767','179373',3524729,'2138','325',440802.34,442816.17,0.00,0.00,2013.83,724978.80,0.00,0.00,0.00),('1','146','767','180108',3538525,'2138','325',442816.17,442972.00,0.00,0.00,155.83,56098.80,0.00,0.00,0.00),('1','146','767','180302',3542237,'2138','325',442972.00,443614.81,0.00,0.00,642.81,231411.60,0.00,0.00,0.00),('1','146','767','180501',3545860,'2138','325',443614.81,446228.69,0.00,0.00,2613.88,940996.80,0.00,0.00,0.00),('1','146','767','180552',3546701,'2138','325',446228.69,448571.88,0.00,0.00,2343.19,839048.40,0.00,0.00,0.00),('1','146','767','180742',3550080,'2138','325',448571.88,448785.21,0.00,0.00,213.33,76798.80,0.00,0.00,0.00),('1','146','767','180789',3551005,'2138','325',448785.21,450706.33,0.00,0.00,1921.12,642553.20,0.00,0.00,0.00),('1','146','767','180987',3554801,'2138','325',450706.33,453337.06,0.00,0.00,2630.73,943822.80,0.00,0.00,0.00),('1','146','767','181141',3557695,'2138','325',453337.06,454104.43,0.00,0.00,767.37,273323.79,0.00,0.00,0.00),('1','146','767','181240',3559887,'2138','325',454104.43,455202.35,0.00,0.00,1097.92,395251.20,0.00,0.00,0.00),('1','146','767','181331',3561691,'2138','325',455202.35,457603.84,0.00,0.00,2401.49,880396.40,0.00,0.00,0.00),('1','146','767','181518',3565063,'2138','325',457603.84,459801.35,0.00,0.00,2197.51,670503.60,0.00,0.00,0.00),('1','146','767','181744',3568708,'2138','325',459801.35,462510.44,0.00,0.00,2709.09,1015412.40,0.00,0.00,0.00),('1','146','767','181899',3571509,'2138','325',462510.44,464742.52,0.00,0.00,2232.08,803548.80,0.00,0.00,0.00),('1','146','767','182116',3575554,'2138','325',464742.52,464870.85,0.00,0.00,128.33,46198.80,0.00,0.00,0.00),('1','146','767','182164',3576349,'2138','325',464870.85,466736.03,0.00,0.00,1865.18,671464.80,0.00,0.00,0.00),('1','146','767','182298',3578822,'2138','325',466736.03,468996.60,0.00,0.00,2260.57,813805.20,0.00,0.00,0.00),('1','146','767','182510',3582437,'2138','325',468996.60,470642.85,0.00,0.00,1646.25,592650.00,0.00,0.00,0.00),('1','146','767','182673',3585746,'2138','325',470642.85,471272.57,0.00,0.00,629.72,226699.20,0.00,0.00,0.00),('1','146','767','182686',3585867,'2138','325',471272.57,473983.95,0.00,0.00,2711.38,971596.80,0.00,0.00,0.00),('1','146','767','182958',3591010,'2138','325',473983.95,475919.50,0.00,0.00,1935.55,696798.00,0.00,0.00,0.00),('1','146','767','183092',3593497,'2138','325',475919.50,478711.16,0.00,0.00,2791.66,1004997.60,0.00,0.00,0.00),('1','146','767','183239',3595868,'2138','325',478711.16,481045.19,0.00,0.00,2334.03,840250.80,0.00,0.00,0.00),('1','146','767','183432',3599432,'2138','325',481045.19,483463.29,0.00,0.00,2418.10,870516.00,0.00,0.00,0.00),('1','146','767','183634',3603239,'2138','325',483463.29,485768.72,0.00,0.00,2305.43,829954.80,0.00,0.00,0.00),('1','146','767','183892',3607946,'2138','325',485768.72,486346.65,0.00,0.00,577.93,208054.80,0.00,0.00,0.00),('1','146','767','183997',3609754,'2138','325',486346.65,487410.26,0.00,0.00,1063.61,382899.60,0.00,0.00,0.00),('1','146','767','184072',3611142,'2138','325',487410.26,489827.45,0.00,0.00,2417.19,870188.40,0.00,0.00,0.00),('1','146','767','184257',3614444,'2138','325',489827.45,490450.45,0.00,0.00,623.00,224280.00,0.00,0.00,0.00),('1','146','767','184398',3616750,'2138','325',490450.45,491762.11,0.00,0.00,1311.66,472197.60,0.00,0.00,0.00),('1','146','767','184470',3618124,'2138','325',491762.11,494546.67,0.00,0.00,2784.56,1002441.60,0.00,0.00,0.00),('1','146','767','184674',3621996,'2138','325',494546.67,495778.89,0.00,0.00,1232.22,443599.20,0.00,0.00,0.00),('1','146','767','184830',3624834,'2138','325',495778.89,496678.06,0.00,0.00,899.17,323701.20,0.00,0.00,0.00),('1','146','767','184867',3625472,'2138','325',496678.06,498760.42,0.00,0.00,2082.36,749649.60,0.00,0.00,0.00),('1','146','767','185129',3629799,'2138','325',498760.42,500180.56,0.00,0.00,1420.14,511250.40,0.00,0.00,0.00),('1','146','767','185299',3632464,'2138','325',500180.56,501249.31,0.00,0.00,1068.75,384750.00,0.00,0.00,0.00),('1','146','767','185503',3636371,'2138','325',501249.31,502046.39,0.00,0.00,797.08,286948.80,0.00,0.00,0.00),('1','146','767','185506',3636422,'2138','325',502046.39,504157.33,0.00,0.00,2110.94,759938.40,0.00,0.00,0.00),('1','146','767','185934',3644223,'2138','325',504157.33,505833.34,0.00,0.00,1676.01,603363.60,0.00,0.00,0.00),('1','146','767','186147',3647871,'2138','325',505833.34,507488.75,0.00,0.00,1655.41,595947.60,0.00,0.00,0.00),('1','146','767','186342',3651032,'2138','325',507488.75,509731.80,0.00,0.00,2243.05,807498.00,0.00,0.00,0.00),('1','146','767','186540',3654468,'2138','325',509731.80,510689.82,0.00,0.00,958.02,344887.20,0.00,0.00,0.00),('1','146','767','186699',3657290,'2138','325',510689.82,511356.34,0.00,0.00,666.52,239947.20,0.00,0.00,0.00),('1','146','767','186766',3658293,'2138','325',511356.34,513544.53,0.00,0.00,2188.19,787748.40,0.00,0.00,0.00),('1','146','767','186989',3662029,'2138','325',513544.53,515685.68,0.00,0.00,2141.15,770814.00,0.00,0.00,0.00),('1','146','767','187246',3666505,'2138','325',515685.68,517260.02,0.00,0.00,1574.34,566762.40,0.00,0.00,0.00),('1','146','767','187427',3669923,'2138','325',517260.02,519340.15,0.00,0.00,2080.13,748846.80,0.00,0.00,0.00),('1','146','767','187582',3672533,'2138','325',519340.15,520666.97,0.00,0.00,1326.82,477655.20,0.00,0.00,0.00),('1','146','767','187706',3674771,'2138','325',520666.97,521783.17,0.00,0.00,1116.20,401832.00,0.00,0.00,0.00),('1','146','767','187810',3676573,'2138','325',521783.17,524350.55,0.00,0.00,2567.38,924256.80,0.00,0.00,0.00),('1','146','767','188016',3680258,'2138','325',524350.55,525765.98,0.00,0.00,1415.43,509554.80,0.00,0.00,0.00),('1','146','767','188147',3682531,'2138','325',525765.98,526641.18,0.00,0.00,875.20,315072.00,0.00,0.00,0.00),('1','146','767','188217',3683683,'2138','325',526641.18,529063.40,0.00,0.00,2422.22,871999.20,0.00,0.00,0.00),('1','146','767','188449',3687497,'2138','325',529063.40,530595.28,0.00,0.00,1531.88,551476.80,0.00,0.00,0.00),('1','146','767','188610',3690411,'2138','325',530595.28,532940.80,0.00,0.00,2345.52,844387.20,0.00,0.00,0.00),('1','146','767','188811',3693992,'2138','325',532940.80,535150.38,0.00,0.00,2209.58,795448.80,0.00,0.00,0.00),('1','146','767','189046',3698154,'2138','325',535150.38,536810.78,0.00,0.00,1660.40,597744.00,0.00,0.00,0.00),('1','146','767','189203',3701062,'2138','325',536810.78,539425.06,0.00,0.00,2614.28,941140.80,0.00,0.00,0.00),('1','146','767','189422',3705093,'2138','325',539425.06,539799.90,0.00,0.00,374.84,134942.40,0.00,0.00,0.00),('1','146','767','189535',3706957,'2138','325',539799.90,541037.24,0.00,0.00,1237.34,445442.40,0.00,0.00,0.00),('1','146','767','189621',3708490,'2138','325',541037.24,543268.78,0.00,0.00,2231.54,803354.40,0.00,0.00,0.00),('1','146','767','189815',3711907,'2138','325',543268.78,545003.10,0.00,0.00,1734.32,624355.20,0.00,0.00,0.00),('1','146','767','189967',3714915,'2138','325',545003.10,545303.94,0.00,0.00,300.84,108302.40,0.00,0.00,0.00),('1','146','767','190031',3716237,'2138','325',545303.94,547157.89,0.00,0.00,1853.95,667422.00,0.00,0.00,0.00),('1','146','767','190221',3719814,'2138','325',547157.89,549835.29,0.00,0.00,2677.40,963864.00,0.00,0.00,0.00),('1','146','767','190464',3724143,'2138','325',549835.29,550086.62,0.00,0.00,251.33,90478.80,0.00,0.00,0.00),('1','146','767','190510',3724950,'2138','325',550086.62,552510.64,0.00,0.00,2424.02,872647.20,0.00,0.00,0.00),('1','146','767','190672',3728166,'2138','325',552510.64,555040.84,0.00,0.00,2530.20,910872.00,0.00,0.00,0.00),('1','146','767','190986',3733792,'2138','325',555040.84,555786.75,0.00,0.00,745.91,268527.60,0.00,0.00,0.00),('1','146','767','190991',3733868,'2138','325',555786.75,557523.55,0.00,0.00,1736.80,625248.00,0.00,0.00,0.00),('1','146','767','191076',3735456,'2138','325',557523.55,559914.10,0.00,0.00,2390.55,860598.00,0.00,0.00,0.00),('1','146','767','191324',3739641,'2138','325',559914.10,561129.55,0.00,0.00,1215.45,437562.00,0.00,0.00,0.00),('1','146','767','191498',3742997,'2138','325',561129.55,563612.77,0.00,0.00,2483.22,893959.20,0.00,0.00,0.00),('1','146','767','191724',3747337,'2138','325',563612.77,566188.64,0.00,0.00,2575.87,927313.20,0.00,0.00,0.00),('1','146','767','191991',3752315,'2138','325',566188.64,567705.53,0.00,0.00,1516.89,546080.40,0.00,0.00,0.00),('1','146','767','192129',3754925,'2138','325',567705.53,569633.17,0.00,0.00,1927.64,693950.40,0.00,0.00,0.00),('1','146','767','192336',3758830,'2138','325',569633.17,571407.07,0.00,0.00,1773.90,638604.00,0.00,0.00,0.00),('1','146','767','192560',3762871,'2138','325',571407.07,574113.26,0.00,0.00,2706.19,974228.40,0.00,0.00,0.00),('1','146','767','192756',3766275,'2138','325',574113.26,576519.36,0.00,0.00,2406.10,866196.00,0.00,0.00,0.00),('1','146','767','192959',3769961,'2138','325',576519.36,579010.97,0.00,0.00,2491.61,896979.60,0.00,0.00,0.00),('1','146','767','193163',3773943,'2138','325',579010.97,581214.51,0.00,0.00,2203.54,793274.40,0.00,0.00,0.00),('1','146','767','193404',3778834,'2138','325',581214.51,581586.60,0.00,0.00,372.09,133952.40,0.00,0.00,0.00),('1','146','767','193493',3780362,'2138','325',581586.60,582966.10,0.00,0.00,1379.50,496620.00,0.00,0.00,0.00),('1','146','767','193625',3782849,'2138','325',582966.10,585364.14,0.00,0.00,2398.04,863294.40,0.00,0.00,0.00),('1','146','767','193845',3786841,'2138','325',585364.14,586835.94,0.00,0.00,1471.80,529848.00,0.00,0.00,0.00),('1','146','767','194029',3790072,'2138','325',586835.94,587622.04,0.00,0.00,786.10,282996.00,0.00,0.00,0.00),('1','146','767','194075',3790867,'2138','325',587622.04,590018.62,0.00,0.00,2396.58,862768.80,0.00,0.00,0.00),('1','146','767','194281',3794806,'2138','325',590018.62,592251.66,0.00,0.00,2233.04,803894.40,0.00,0.00,0.00),('1','146','767','194483',3798317,'2138','325',592251.66,594881.00,0.00,0.00,2629.34,946562.40,0.00,0.00,0.00),('1','146','767','194672',3801634,'2138','325',594881.00,597517.34,0.00,0.00,2636.34,949082.40,0.00,0.00,0.00),('1','146','767','194926',3806748,'2138','325',597517.34,599227.89,0.00,0.00,1710.55,615798.00,0.00,0.00,0.00),('1','146','767','195076',3809338,'2138','325',599227.89,601909.97,0.00,0.00,2682.08,965548.80,0.00,0.00,0.00),('1','146','767','195298',3813259,'2138','325',601909.97,602506.73,0.00,0.00,596.76,214833.60,0.00,0.00,0.00),('1','146','767','195408',3815082,'2138','325',602506.73,604412.35,0.00,0.00,1905.62,686023.20,0.00,0.00,0.00),('1','146','767','195517',3817118,'2138','325',604412.35,606697.39,0.00,0.00,2285.04,822614.40,0.00,0.00,0.00),('1','146','767','195775',3821384,'2138','325',606697.39,607820.44,0.00,0.00,1123.05,404298.00,0.00,0.00,0.00),('1','146','767','195892',3823456,'2138','325',607820.44,609210.79,0.00,0.00,1390.35,500526.00,0.00,0.00,0.00),('1','146','767','196007',3825622,'2138','325',609210.79,611776.71,0.00,0.00,2565.92,923731.20,0.00,0.00,0.00),('1','146','767','196208',3829619,'2138','325',611776.71,613440.47,0.00,0.00,1663.76,598953.60,0.00,0.00,0.00),('1','146','767','196398',3832982,'2138','325',613440.47,613729.36,0.00,0.00,288.89,104000.40,0.00,0.00,0.00),('1','146','767','196448',3833828,'2138','325',613729.36,616404.41,0.00,0.00,2675.05,963018.00,0.00,0.00,0.00),('1','146','767','196658',3837586,'2138','325',616404.41,617675.80,0.00,0.00,1271.39,457700.40,0.00,0.00,0.00),('1','146','767','196776',3839591,'2138','325',617675.80,619061.00,0.00,0.00,1385.20,498672.00,0.00,0.00,0.00),('1','146','767','196892',3841684,'2138','325',619061.00,619874.35,0.00,0.00,813.35,292806.00,0.00,0.00,0.00),('1','146','767','197020',3844143,'2138','325',619874.35,621520.14,0.00,0.00,1645.79,592484.40,0.00,0.00,0.00),('1','146','767','197344',3850145,'2138','325',621520.14,622836.25,0.00,0.00,1316.11,473799.60,0.00,0.00,0.00),('1','146','767','197349',3850173,'2138','325',622836.25,624917.83,0.00,0.00,2081.58,749368.80,0.00,0.00,0.00),('1','146','767','197523',3852539,'2138','325',624917.83,627431.37,0.00,0.00,2513.54,904874.40,0.00,0.00,0.00),('1','146','767','197869',3858767,'2138','325',627431.37,628201.66,0.00,0.00,770.29,277304.40,0.00,0.00,0.00),('1','146','767','198031',3861696,'2138','325',628201.66,629076.93,0.00,0.00,875.27,315097.20,0.00,0.00,0.00),('1','146','767','198117',3863136,'2138','325',629076.93,631223.26,0.00,0.00,2146.33,772678.80,0.00,0.00,0.00),('1','146','767','198339',3866943,'2138','325',631223.26,633651.61,0.00,0.00,2428.35,874206.00,0.00,0.00,0.00),('1','146','767','198635',3871954,'2138','325',633651.61,635406.60,0.00,0.00,1754.99,631796.40,0.00,0.00,0.00),('1','146','767','198769',3874227,'2138','325',635406.60,638178.42,0.00,0.00,2771.82,997855.20,0.00,0.00,0.00),('1','146','767','198979',3877877,'2138','325',638178.42,639054.81,0.00,0.00,876.39,315500.40,0.00,0.00,0.00),('1','146','767','199099',3880020,'2138','325',639054.81,640004.05,0.00,0.00,949.24,341726.40,0.00,0.00,0.00),('1','146','767','199196',3881759,'2138','325',640004.05,642382.55,0.00,0.00,2378.50,856260.00,0.00,0.00,0.00),('1','146','767','199428',3885459,'2138','325',642382.55,644425.68,0.00,0.00,2043.13,735526.80,0.00,0.00,0.00),('1','146','767','199778',3891017,'2138','325',644425.68,647149.86,0.00,0.00,2724.18,980704.80,0.00,0.00,0.00),('1','146','767','199853',3892380,'2138','325',647149.86,649157.93,0.00,0.00,2008.07,722905.20,0.00,0.00,0.00),('1','146','767','200084',3896671,'2138','325',649157.93,649755.69,0.00,0.00,597.76,215193.60,0.00,0.00,0.00),('1','146','767','200214',3898904,'2138','325',649755.69,650789.42,0.00,0.00,1033.73,372142.80,0.00,0.00,0.00),('1','146','767','200281',3900147,'2138','325',650789.42,653861.94,0.00,0.00,3072.52,1106107.20,0.00,0.00,0.00),('1','146','767','200480',3903901,'2138','325',653861.94,655177.98,0.00,0.00,1316.04,473774.40,0.00,0.00,0.00),('1','146','767','200682',3907435,'2138','325',655177.98,657560.11,0.00,0.00,2382.13,857566.80,0.00,0.00,0.00),('1','146','767','200910',3911390,'2138','325',657560.11,660409.33,0.00,0.00,2849.22,1025719.20,0.00,0.00,0.00),('1','146','767','201143',3914958,'2138','325',660409.33,660617.63,0.00,0.00,208.30,74988.00,0.00,0.00,0.00),('1','146','767','201159',3915225,'2138','325',660617.63,662781.49,0.00,0.00,2163.86,778989.60,0.00,0.00,0.00),('1','146','767','201308',3918014,'2138','325',662781.49,665029.70,0.00,0.00,2248.21,809355.60,0.00,0.00,0.00),('1','146','767','201490',3921432,'2138','325',665029.70,666130.79,0.00,0.00,1101.09,396392.40,0.00,0.00,0.00),('1','146','767','201677',3925028,'2138','325',666130.79,667269.14,0.00,0.00,1138.35,409806.00,0.00,0.00,0.00),('1','146','767','201753',3926549,'2138','325',667269.14,671305.07,0.00,0.00,4035.93,1452934.80,0.00,0.00,0.00),('1','146','767','202062',3932012,'2138','325',671305.07,673658.85,0.00,0.00,2353.78,847360.80,0.00,0.00,0.00),('1','146','767','202211',3934646,'2138','325',673658.85,676324.36,0.00,0.00,2665.51,959583.60,0.00,0.00,0.00),('1','146','767','202415',3938308,'2138','325',676324.36,676539.35,0.00,0.00,214.99,77396.40,0.00,0.00,0.00),('1','146','767','202551',3940528,'2138','325',676539.35,678584.38,0.00,0.00,2045.03,736210.80,0.00,0.00,0.00),('1','146','767','202630',3942040,'2138','325',678584.38,680956.59,0.00,0.00,2372.21,853995.60,0.00,0.00,0.00),('1','146','767','202839',3945802,'2138','325',680956.59,681769.36,0.00,0.00,812.77,292597.20,0.00,0.00,0.00),('1','146','767','202972',3948104,'2138','325',681769.36,684075.73,0.00,0.00,2306.37,830293.20,0.00,0.00,0.00),('1','146','767','203098',3950752,'2138','325',684075.73,686504.45,0.00,0.00,2428.72,874339.20,0.00,0.00,0.00),('1','146','767','203295',3954331,'2138','325',686504.45,686859.74,0.00,0.00,355.29,127904.40,0.00,0.00,0.00),('1','146','767','203422',3956499,'2138','325',686859.74,689129.18,0.00,0.00,2269.44,816998.40,0.00,0.00,0.00),('1','146','767','203512',3958225,'2138','325',689129.18,691422.85,0.00,0.00,2293.67,825721.20,0.00,0.00,0.00),('1','146','767','203712',3961889,'2138','325',691422.85,692157.42,0.00,0.00,734.57,276198.32,0.00,0.00,0.00),('1','146','767','203895',3965112,'2138','325',692157.42,693350.80,0.00,0.00,1193.38,448710.88,0.00,0.00,0.00),('1','146','767','203955',3966043,'2138','325',693350.80,695402.53,0.00,0.00,2051.73,771450.48,0.00,0.00,0.00),('1','146','767','204175',3970252,'2138','325',695402.53,697624.46,0.00,0.00,2221.93,835445.68,0.00,0.00,0.00),('1','146','767','204354',3973355,'2138','325',697624.46,698007.97,0.00,0.00,383.51,144199.76,0.00,0.00,0.00),('1','146','767','204384',3973910,'2138','325',698007.97,700485.04,0.00,0.00,2477.07,931378.32,0.00,0.00,0.00),('1','146','767','204599',3977859,'2138','325',700485.04,702749.67,0.00,0.00,2264.63,851500.88,0.00,0.00,0.00),('1','146','767','204825',3981473,'2138','325',702749.67,705459.31,0.00,0.00,2709.64,1018824.64,0.00,0.00,0.00),('1','146','767','205028',3985108,'2138','325',705459.31,707745.33,0.00,0.00,2286.02,859543.52,0.00,0.00,0.00),('1','146','767','205220',3988614,'2138','325',707745.33,708187.60,0.00,0.00,442.27,166293.52,0.00,0.00,0.00),('1','146','767','205322',3990173,'2138','325',708187.60,710191.16,0.00,0.00,2003.56,753338.56,0.00,0.00,0.00),('1','146','767','205473',3993106,'2138','325',710191.16,712525.68,0.00,0.00,2334.52,877779.52,0.00,0.00,0.00),('1','146','767','205721',3997689,'2138','325',712525.68,713153.89,0.00,0.00,628.21,236206.96,0.00,0.00,0.00),('1','146','767','205826',3999384,'2138','325',713153.89,715017.15,0.00,0.00,1863.26,700585.76,0.00,0.00,0.00),('1','146','767','205930',4001437,'2138','325',715017.15,717676.19,0.00,0.00,2659.04,999799.04,0.00,0.00,0.00),('1','146','767','206132',4005008,'2138','325',717676.19,718287.02,0.00,0.00,610.83,229672.08,0.00,0.00,0.00),('1','146','767','206254',4007009,'2138','325',718287.02,719761.70,0.00,0.00,1474.68,554479.68,0.00,0.00,0.00),('1','146','767','206353',4008800,'2138','325',719761.70,722542.26,0.00,0.00,2780.56,1045490.56,0.00,0.00,0.00),('1','146','767','206566',4012523,'2138','325',722542.26,723517.88,0.00,0.00,975.62,366833.12,0.00,0.00,0.00),('1','146','767','206705',4014933,'2138','325',723517.88,724893.47,0.00,0.00,1375.59,517221.84,0.00,0.00,0.00),('1','146','767','206778',4016308,'2138','325',724893.47,727453.62,0.00,0.00,2560.15,962616.40,0.00,0.00,0.00),('1','146','767','207009',4020530,'2138','325',727453.62,728738.80,0.00,0.00,1285.18,483227.68,0.00,0.00,0.00),('1','146','767','207177',4023368,'2138','325',728738.80,729679.39,0.00,0.00,940.59,353661.84,0.00,0.00,0.00),('1','146','767','207240',4024643,'2138','325',729679.39,733120.95,0.00,0.00,3441.56,1294026.56,0.00,0.00,0.00),('1','146','767','207469',4028699,'2138','325',733120.95,734123.91,0.00,0.00,1002.96,377112.96,0.00,0.00,0.00),('1','146','767','207584',4030609,'2138','325',734123.91,735816.32,0.00,0.00,1692.41,636346.16,0.00,0.00,0.00),('1','146','767','207692',4032466,'2138','325',735816.32,738956.61,0.00,0.00,3140.29,1205871.36,0.00,0.00,0.00),('1','146','767','207897',4036006,'2138','325',738956.61,739566.65,0.00,0.00,610.04,234255.36,0.00,0.00,0.00),('1','146','767','208011',4037822,'2138','325',739566.65,741787.33,0.00,0.00,2220.68,852741.12,0.00,0.00,0.00),('1','146','767','208111',4039609,'2138','325',741787.33,744861.34,0.00,0.00,3074.01,1180419.84,0.00,0.00,0.00),('1','146','767','208332',4043619,'2138','325',744861.34,745744.97,0.00,0.00,883.63,339313.92,0.00,0.00,0.00),('1','146','767','208441',4045402,'2138','325',745744.97,747444.64,0.00,0.00,1699.67,652673.28,0.00,0.00,0.00),('1','146','767','208541',4047388,'2138','325',747444.64,750541.88,0.00,0.00,3097.24,1189340.16,0.00,0.00,0.00),('1','146','767','208758',4051066,'2138','325',750541.88,751598.22,0.00,0.00,1056.34,405634.56,0.00,0.00,0.00),('1','146','767','208908',4053603,'2138','325',751598.22,752941.28,0.00,0.00,1343.06,515735.04,0.00,0.00,0.00),('1','146','767','208985',4055053,'2138','325',752941.28,753041.28,0.00,0.00,100.00,38400.00,0.00,0.00,0.00),('1','146','767','208995',4055114,'2138','325',753041.28,755197.53,0.00,0.00,2156.25,862500.00,0.00,0.00,0.00),('1','146','767','209209',4058918,'2138','325',755197.53,757199.78,0.00,0.00,2002.25,800900.00,0.00,0.00,0.00),('1','146','767','209408',4062508,'2138','325',757199.78,757391.03,0.00,0.00,191.25,76500.00,0.00,0.00,0.00),('1','146','767','209440',4062914,'2138','325',757391.03,760705.28,0.00,0.00,3314.25,1325700.00,0.00,0.00,0.00),('1','146','767','209642',4066555,'2138','325',760705.28,762465.28,0.00,0.00,1760.00,704000.00,0.00,0.00,0.00),('1','146','767','209791',4069330,'2138','325',762465.28,763232.78,0.00,0.00,767.50,307000.00,0.00,0.00,0.00),('1','146','767','209861',4070427,'2138','325',763232.78,765851.08,0.00,0.00,2618.30,1099686.00,0.00,0.00,0.00),('1','146','767','210098',4074751,'2138','325',765851.08,768093.79,0.00,0.00,2242.71,941938.20,0.00,0.00,0.00),('1','146','767','210262',4077505,'2138','325',768093.79,768723.06,0.00,0.00,629.27,264293.40,0.00,0.00,0.00),('1','146','767','210316',4078476,'2138','325',768723.06,771974.03,0.00,0.00,3250.97,1365407.40,0.00,0.00,0.00),('1','146','767','210527',4082326,'2138','325',771974.03,773586.22,0.00,0.00,1612.19,677119.80,0.00,0.00,0.00),('1','146','767','210689',4085379,'2138','325',773586.22,773861.22,0.00,0.00,275.00,115500.00,0.00,0.00,0.00),('1','146','767','210722',4085927,'2138','325',773861.22,776863.80,0.00,0.00,3002.58,1261083.60,0.00,0.00,0.00),('1','146','767','210946',4089628,'2138','325',776863.80,779048.55,0.00,0.00,2184.75,917595.00,0.00,0.00,0.00),('1','146','767','211117',4092689,'2138','325',779048.55,779943.56,0.00,0.00,895.01,375904.20,0.00,0.00,0.00),('1','146','767','211165',4093541,'2138','325',779943.56,782927.60,0.00,0.00,2984.04,1253296.80,0.00,0.00,0.00),('1','146','767','211376',4097313,'2138','325',782927.60,783514.88,0.00,0.00,587.28,246657.60,0.00,0.00,0.00),('1','146','767','211494',4099307,'2138','325',783514.88,786082.86,0.00,0.00,2567.98,1078551.60,0.00,0.00,0.00),('1','146','767','211626',4101573,'2138','325',786082.86,787732.84,0.00,0.00,1649.98,692991.60,0.00,0.00,0.00),('1','146','767','211767',4104009,'2138','325',787732.84,789319.70,0.00,0.00,1586.86,666481.20,0.00,0.00,0.00),('1','146','767','211923',4106743,'2138','325',789319.70,789945.89,0.00,0.00,626.19,262999.80,0.00,0.00,0.00),('1','146','767','211988',4107850,'2138','325',789945.89,792135.66,0.00,0.00,2189.77,919703.40,0.00,0.00,0.00),('1','146','767','212232',4112157,'2138','325',792135.66,794387.94,0.00,0.00,2252.28,945957.60,0.00,0.00,0.00),('1','146','767','212459',4116346,'2138','325',794387.94,794901.04,0.00,0.00,513.10,215502.00,0.00,0.00,0.00),('1','146','767','212531',4117581,'2138','325',794901.04,796687.15,0.00,0.00,1786.11,750166.20,0.00,0.00,0.00),('1','146','767','212668',4120070,'2138','325',796687.15,797092.39,0.00,0.00,405.24,170200.80,0.00,0.00,0.00),('1','146','767','212719',4120899,'2138','325',797092.39,798968.35,0.00,0.00,1875.96,787903.20,0.00,0.00,0.00),('1','146','767','212888',4123851,'2138','325',798968.35,802074.34,0.00,0.00,3105.99,1304515.80,0.00,0.00,0.00),('1','146','767','213124',4128122,'2138','325',802074.34,802535.77,0.00,0.00,461.43,193800.60,0.00,0.00,0.00),('1','146','767','213227',4129712,'2138','325',802535.77,804361.40,0.00,0.00,1825.63,766764.60,0.00,0.00,0.00),('1','146','767','213390',4132377,'2138','325',804361.40,807513.51,0.00,0.00,3152.11,1323886.20,0.00,0.00,0.00),('1','146','767','213635',4136460,'2138','325',807513.51,808288.96,0.00,0.00,775.45,325689.00,0.00,0.00,0.00),('1','146','767','213724',4137966,'2138','325',808288.96,810457.48,0.00,0.00,2168.52,910778.40,0.00,0.00,0.00),('1','146','767','213907',4140835,'2138','325',810457.48,813346.04,0.00,0.00,2888.56,1213195.20,0.00,0.00,0.00),('1','146','767','214098',4144151,'2138','325',813346.04,814143.78,0.00,0.00,797.74,335050.80,0.00,0.00,0.00),('1','146','767','214178',4145410,'2138','325',814143.78,816751.94,0.00,0.00,2608.16,1095427.20,0.00,0.00,0.00),('1','146','767','214342',4148407,'2138','325',816751.94,819259.94,0.00,0.00,2508.00,1053360.00,0.00,0.00,0.00),('1','146','767','214531',4151579,'2138','325',819259.94,822809.42,0.00,0.00,3549.48,1490781.60,0.00,0.00,0.00),('1','146','767','214774',4155853,'2138','325',822809.42,824449.96,0.00,0.00,1640.54,689026.80,0.00,0.00,0.00),('1','146','767','214954',4158936,'2138','325',824449.96,825158.25,0.00,0.00,708.29,297481.80,0.00,0.00,0.00),('1','146','767','215103',4161338,'2138','325',825158.25,827702.15,0.00,0.00,2543.90,1068438.00,0.00,0.00,0.00),('1','146','767','215213',4163425,'2138','325',827702.15,829782.02,0.00,0.00,2079.87,931781.76,0.00,0.00,0.00),('1','146','767','215444',4167083,'2138','325',829782.02,832572.59,0.00,0.00,2790.57,1250175.36,0.00,0.00,0.00),('1','146','767','215673',4171112,'2138','325',832572.59,834664.26,0.00,0.00,2091.67,937068.16,0.00,0.00,0.00),('1','146','767','215850',4174190,'2138','325',834664.26,835089.26,0.00,0.00,425.00,190400.00,0.00,0.00,0.00),('1','146','767','215905',4175061,'2138','325',835089.26,837968.39,0.00,0.00,2879.13,1289850.24,0.00,0.00,0.00),('1','146','767','216101',4178478,'2138','325',837968.39,839778.38,0.00,0.00,1809.99,810875.52,0.00,0.00,0.00),('1','146','767','216265',4181255,'2138','325',839778.38,840778.37,0.00,0.00,999.99,447995.52,0.00,0.00,0.00),('1','146','767','216318',4182252,'2138','325',840778.37,843791.63,0.00,0.00,3013.26,1361993.52,0.00,0.00,0.00),('1','146','767','216549',4186254,'2138','325',843791.63,844954.60,0.00,0.00,1162.97,525662.44,0.00,0.00,0.00),('1','146','767','216688',4188534,'2138','325',844954.60,846225.55,0.00,0.00,1270.95,574469.40,0.00,0.00,0.00),('1','146','767','216788',4190501,'2138','325',846225.55,849330.31,0.00,0.00,3104.76,1403351.52,0.00,0.00,0.00),('1','146','767','217019',4194464,'2138','325',849330.31,850195.48,0.00,0.00,865.17,415281.60,0.00,0.00,0.00),('1','146','767','217137',4196481,'2138','325',850195.48,851833.31,0.00,0.00,1637.83,786158.40,0.00,0.00,0.00),('1','146','767','217267',4199298,'2138','325',851833.31,855055.57,0.00,0.00,3222.26,1546684.80,0.00,0.00,0.00),('1','146','767','217494',4203119,'2138','325',855055.57,855251.20,0.00,0.00,195.63,93902.40,0.00,0.00,0.00),('1','146','767','217533',4203588,'2138','325',855251.20,857491.41,0.00,0.00,2240.21,1075300.80,0.00,0.00,0.00),('1','146','767','217707',4206694,'2138','325',857491.41,860483.82,0.00,0.00,2992.41,1436356.80,0.00,0.00,0.00),('1','146','767','217971',4211643,'2138','325',860483.82,863333.47,0.00,0.00,2849.65,1367832.00,0.00,0.00,0.00),('1','146','767','218207',4215676,'2138','325',863333.47,865464.17,0.00,0.00,2130.70,1022736.00,0.00,0.00,0.00),('1','146','767','218437',4219750,'2138','325',865464.17,868095.35,0.00,0.00,2631.18,1262966.40,0.00,0.00,0.00),('1','146','767','218683',4224046,'2138','325',868095.35,870628.59,0.00,0.00,2533.24,1215955.20,0.00,0.00,0.00),('1','146','767','218906',4227997,'2138','325',870628.59,871034.68,0.00,0.00,406.09,194923.20,0.00,0.00,0.00),('1','146','767','218956',4228695,'2138','325',871034.68,873374.38,0.00,0.00,2339.70,1123056.00,0.00,0.00,0.00),('1','146','767','219110',4231507,'2138','325',873374.38,876004.83,0.00,0.00,2630.45,1262616.00,0.00,0.00,0.00),('1','146','767','219341',4235376,'2138','325',876004.83,876376.32,0.00,0.00,371.49,178315.20,0.00,0.00,0.00),('1','146','767','219472',4237673,'2138','325',876376.32,878177.58,0.00,0.00,1801.26,864604.80,0.00,0.00,0.00),('1','146','767','219651',4240646,'2138','325',878177.58,881217.75,0.00,0.00,3040.17,1459281.60,0.00,0.00,0.00),('1','146','767','219803',4243693,'2138','325',881217.75,881576.73,0.00,0.00,358.98,172310.40,0.00,0.00,0.00),('1','146','767','219887',4244940,'2138','325',881576.73,883841.86,0.00,0.00,2265.13,1087262.40,0.00,0.00,0.00),('1','146','767','220031',4247796,'2138','325',883841.86,886757.98,0.00,0.00,2916.12,1399737.60,0.00,0.00,0.00),('1','146','767','220242',4251425,'2138','325',886757.98,889352.08,0.00,0.00,2594.10,1245168.00,0.00,0.00,0.00),('1','146','767','220467',4255568,'2138','325',889352.08,891953.26,0.00,0.00,2601.18,1248566.40,0.00,0.00,0.00),('1','146','767','220677',4259199,'2138','325',891953.26,894954.58,0.00,0.00,3001.32,1440633.60,0.00,0.00,0.00),('1','146','767','220897',4263154,'2138','325',894954.58,897594.11,0.00,0.00,2639.53,1266974.40,0.00,0.00,0.00),('1','146','767','221156',4267480,'2138','325',897594.11,900890.68,0.00,0.00,3296.57,1582353.60,0.00,0.00,0.00),('1','146','767','221373',4271679,'2138','325',900890.68,903146.94,0.00,0.00,2256.26,1083004.80,0.00,0.00,0.00),('1','146','767','221605',4275997,'2138','325',903146.94,905956.33,0.00,0.00,2809.39,1348507.20,0.00,0.00,0.00),('1','146','767','221821',4279743,'2138','325',905956.33,907584.35,0.00,0.00,1628.02,781449.60,0.00,0.00,0.00),('1','146','767','222164',4285700,'2138','325',907584.35,908653.61,0.00,0.00,1069.26,513244.80,0.00,0.00,0.00),('1','146','767','222261',4287451,'2138','325',908653.61,911508.59,0.00,0.00,2854.98,1370390.40,0.00,0.00,0.00),('1','146','767','222493',4291337,'2138','325',911508.59,914295.99,0.00,0.00,2787.40,1337952.00,0.00,0.00,0.00),('1','146','767','222772',4296334,'2138','325',914295.99,917787.68,0.00,0.00,3491.69,1676011.20,0.00,0.00,0.00),('1','146','767','222931',4299615,'2138','325',917787.68,918959.68,0.00,0.00,1172.00,562560.00,0.00,0.00,0.00),('1','146','767','223150',4303381,'2138','325',918959.68,920177.18,0.00,0.00,1217.50,584400.00,0.00,0.00,0.00),('1','146','767','223173',4303725,'2138','325',920177.18,923199.11,0.00,0.00,3021.93,1450526.40,0.00,0.00,0.00),('1','146','767','223410',4307816,'2138','325',923199.11,924239.33,0.00,0.00,1040.22,499305.60,0.00,0.00,0.00),('1','146','767','223552',4310258,'2138','325',924239.33,924777.91,0.00,0.00,538.58,258518.40,0.00,0.00,0.00),('1','146','767','223559',4310384,'2138','325',924777.91,925563.90,0.00,0.00,785.99,402426.88,0.00,0.00,0.00),('1','146','767','223843',4315951,'2138','325',925563.90,925689.41,0.00,0.00,125.51,64261.12,0.00,0.00,0.00),('1','146','767','223907',4316794,'2138','325',925689.41,925805.67,0.00,0.00,116.26,59525.12,0.00,0.00,0.00),('1','146','767','223942',4317425,'2138','325',925805.67,926358.08,0.00,0.00,552.41,282833.92,0.00,0.00,0.00),('1','146','767','224077',4319918,'2138','325',926358.08,927927.83,0.00,0.00,1569.75,803712.00,0.00,0.00,0.00),('1','146','767','224077',4319919,'2940','325',0.00,1086.96,0.00,0.00,1086.96,556523.52,0.00,0.00,0.00),('1','146','767','224303',4324054,'2138','325',927927.83,928843.98,0.00,0.00,916.15,469068.80,0.00,0.00,0.00),('1','146','767','224303',4324055,'2940','325',1086.96,2076.93,0.00,0.00,989.97,506864.64,0.00,0.00,0.00),('1','146','767','224481',4327158,'2138','325',928843.98,929275.65,0.00,0.00,431.67,221015.04,0.00,0.00,0.00),('1','146','767','224481',4327159,'2940','325',2076.93,2203.34,0.00,0.00,126.41,64721.92,0.00,0.00,0.00),('1','146','767','224528',4327908,'2138','325',929275.65,930772.04,0.00,0.00,1496.39,766151.68,0.00,0.00,0.00),('1','146','767','224528',4327909,'2940','325',2203.34,3607.50,0.00,0.00,1404.16,718929.92,0.00,0.00,0.00),('1','146','767','224769',4332193,'2138','325',930772.04,932315.09,0.00,0.00,1543.05,790041.60,0.00,0.00,0.00),('1','146','767','224769',4332194,'2940','325',3607.50,3639.15,0.00,0.00,31.65,16204.80,0.00,0.00,0.00),('1','146','767','224965',4335582,'2138','325',932315.09,932627.88,0.00,0.00,312.79,160148.48,0.00,0.00,0.00),('1','146','767','224965',4335583,'2940','325',3639.15,3639.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','225004',4336471,'2138','325',932627.88,933959.20,0.00,0.00,1331.32,681635.84,0.00,0.00,0.00),('1','146','767','225004',4336472,'2940','325',3639.15,4615.72,0.00,0.00,976.57,500003.84,0.00,0.00,0.00),('1','146','767','225462',4344838,'2138','325',933959.20,935440.52,0.00,0.00,1481.32,758435.84,0.00,0.00,0.00),('1','146','767','225462',4344839,'2940','325',4615.72,5946.71,0.00,0.00,1330.99,681466.88,0.00,0.00,0.00),('1','146','767','225946',4353002,'2138','325',935440.52,936722.21,0.00,0.00,1281.69,656225.28,0.00,0.00,0.00),('1','146','767','225946',4353003,'2940','325',5946.71,7228.40,0.00,0.00,1281.69,656225.28,0.00,0.00,0.00),('1','146','767','225948',4353024,'2138','325',936722.21,937037.32,0.00,0.00,315.11,161336.32,0.00,0.00,0.00),('1','146','767','225948',4353025,'2940','325',7228.40,7543.51,0.00,0.00,315.11,161336.32,0.00,0.00,0.00),('1','146','767','225951',4353070,'2138','325',937037.32,937946.15,0.00,0.00,908.83,494403.52,0.00,0.00,0.00),('1','146','767','225951',4353071,'2940','325',7543.51,8506.12,0.00,0.00,962.61,523659.84,0.00,0.00,0.00),('1','146','767','225989',4353644,'2138','325',937946.15,938982.03,0.00,0.00,1035.88,563518.72,0.00,0.00,0.00),('1','146','767','225989',4353645,'2940','325',8506.12,9575.64,0.00,0.00,1069.52,581818.88,0.00,0.00,0.00),('1','146','767','226290',4359119,'2138','325',938982.03,940253.76,0.00,0.00,1271.73,691821.12,0.00,0.00,0.00),('1','146','767','226290',4359120,'2940','325',9575.64,10792.01,0.00,0.00,1216.37,661705.28,0.00,0.00,0.00),('1','146','767','226473',4362523,'2138','325',940253.76,940317.93,0.00,0.00,64.17,34908.48,0.00,0.00,0.00),('1','146','767','226473',4362524,'2940','325',10792.01,10858.10,0.00,0.00,66.09,35952.96,0.00,0.00,0.00),('1','146','767','226494',4362728,'2138','325',940317.93,941522.76,0.00,0.00,1204.83,655427.52,0.00,0.00,0.00),('1','146','767','226494',4362729,'2940','325',10858.10,11592.79,0.00,0.00,734.69,399671.36,0.00,0.00,0.00),('1','146','767','226732',4367271,'2138','325',941522.76,942745.70,0.00,0.00,1222.94,665279.36,0.00,0.00,0.00),('1','146','767','226732',4367272,'2940','325',11592.79,12961.96,0.00,0.00,1369.17,744828.48,0.00,0.00,0.00),('1','146','767','226954',4371264,'2138','325',942745.70,943336.83,0.00,0.00,591.13,321574.72,0.00,0.00,0.00),('1','146','767','226954',4371265,'2940','325',12961.96,13279.64,0.00,0.00,317.68,172817.92,0.00,0.00,0.00),('1','146','767','227078',4373186,'2138','325',943336.83,943702.20,0.00,0.00,365.37,198761.28,0.00,0.00,0.00),('1','146','767','227078',4373187,'2940','325',13279.64,14169.72,0.00,0.00,890.08,484203.52,0.00,0.00,0.00),('1','146','767','227186',4375269,'2138','325',943702.20,946474.48,0.00,0.00,2772.28,1508120.32,0.00,0.00,0.00),('1','146','767','227186',4375270,'2940','325',14169.72,14377.71,0.00,0.00,207.99,113146.56,0.00,0.00,0.00),('1','146','767','227459',4380052,'2138','325',946474.48,946937.20,0.00,0.00,462.72,251719.68,0.00,0.00,0.00),('1','146','767','227459',4380053,'2940','325',14377.71,14377.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','227466',4380131,'2138','325',946937.20,947934.61,0.00,0.00,997.41,542591.04,0.00,0.00,0.00),('1','146','767','227466',4380132,'2940','325',14377.71,15347.77,0.00,0.00,970.06,527712.64,0.00,0.00,0.00),('1','146','767','227584',4382325,'2138','325',947934.61,947934.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','227584',4382326,'2940','325',15347.77,15347.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','227610',4382590,'2138','325',947934.61,949286.82,0.00,0.00,1352.21,735602.24,0.00,0.00,0.00),('1','146','767','227610',4382591,'2940','325',15347.77,17159.79,0.00,0.00,1812.02,985738.88,0.00,0.00,0.00),('1','146','767','227830',4386730,'2138','325',949286.82,949564.03,0.00,0.00,277.21,150802.24,0.00,0.00,0.00),('1','146','767','227830',4386731,'2940','325',17159.79,17159.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','227856',4386978,'2138','325',949564.03,951776.54,0.00,0.00,2212.51,1203605.44,0.00,0.00,0.00),('1','146','767','227856',4386979,'2940','325',17159.79,17982.44,0.00,0.00,822.65,447521.60,0.00,0.00,0.00),('1','146','767','228115',4391975,'2138','325',951776.54,953319.77,0.00,0.00,1543.23,839517.12,0.00,0.00,0.00),('1','146','767','228115',4391976,'2940','325',17982.44,18439.53,0.00,0.00,457.09,248656.96,0.00,0.00,0.00),('1','146','767','228328',4396233,'2138','325',953319.77,953533.37,0.00,0.00,213.60,116198.40,0.00,0.00,0.00),('1','146','767','228328',4396234,'2940','325',18439.53,18653.13,0.00,0.00,213.60,116198.40,0.00,0.00,0.00),('1','146','767','228344',4396431,'2138','325',953533.37,953545.87,0.00,0.00,12.50,6800.00,0.00,0.00,0.00),('1','146','767','228344',4396432,'2940','325',18653.13,18665.08,0.00,0.00,11.95,6500.80,0.00,0.00,0.00),('1','146','767','228353',4396504,'2138','325',953545.87,955150.52,0.00,0.00,1604.65,898604.00,0.00,0.00,0.00),('1','146','767','228353',4396505,'2940','325',18665.08,19857.67,0.00,0.00,1192.59,667850.40,0.00,0.00,0.00),('1','146','767','228522',4399772,'2138','325',955150.52,955636.19,0.00,0.00,485.67,271975.20,0.00,0.00,0.00),('1','146','767','228522',4399773,'2940','325',19857.67,20279.14,0.00,0.00,421.47,236023.20,0.00,0.00,0.00),('1','146','767','228607',4401121,'2138','325',955636.19,957154.27,0.00,0.00,1518.08,850124.80,0.00,0.00,0.00),('1','146','767','228607',4401122,'2940','325',20279.14,20727.54,0.00,0.00,448.40,251104.00,0.00,0.00,0.00),('1','146','767','228752',4404070,'2138','325',957154.27,959398.88,0.00,0.00,2244.61,1256981.60,0.00,0.00,0.00),('1','146','767','228752',4404071,'2940','325',20727.54,21359.62,0.00,0.00,632.08,353964.80,0.00,0.00,0.00),('1','146','767','229148',4411742,'2138','325',959398.88,960957.70,0.00,0.00,1558.82,872939.20,0.00,0.00,0.00),('1','146','767','229148',4411743,'2940','325',21359.62,22918.44,0.00,0.00,1558.82,872939.20,0.00,0.00,0.00),('1','146','767','229328',4414936,'2138','325',960957.70,961860.36,0.00,0.00,902.66,505489.60,0.00,0.00,0.00),('1','146','767','229328',4414937,'2940','325',22918.44,23821.10,0.00,0.00,902.66,505489.60,0.00,0.00,0.00),('1','146','767','229353',4415412,'2138','325',961860.36,962770.90,0.00,0.00,910.54,509902.40,0.00,0.00,0.00),('1','146','767','229353',4415413,'2940','325',23821.10,23821.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','229649',4421086,'2138','325',962770.90,964165.11,0.00,0.00,1394.21,814218.64,0.00,0.00,0.00),('1','146','767','229649',4421087,'2940','325',23821.10,25215.31,0.00,0.00,1394.21,814218.64,0.00,0.00,0.00),('1','146','767','229730',4422339,'2138','325',964165.11,964747.38,0.00,0.00,582.27,340045.68,0.00,0.00,0.00),('1','146','767','229730',4422340,'2940','325',25215.31,25797.58,0.00,0.00,582.27,340045.68,0.00,0.00,0.00),('1','146','767','229762',4422937,'2138','325',964747.38,965358.65,0.00,0.00,611.27,356981.68,0.00,0.00,0.00),('1','146','767','229762',4422938,'2940','325',25797.58,26834.83,0.00,0.00,1037.25,605754.00,0.00,0.00,0.00),('1','146','767','229896',4425732,'2138','325',965358.65,966384.45,0.00,0.00,1025.80,599067.20,0.00,0.00,0.00),('1','146','767','229896',4425733,'2940','325',26834.83,28264.90,0.00,0.00,1430.07,835160.88,0.00,0.00,0.00),('1','146','767','230051',4428799,'2138','325',966384.45,966598.41,0.00,0.00,213.96,124952.64,0.00,0.00,0.00),('1','146','767','230051',4428800,'2940','325',28264.90,28477.84,0.00,0.00,212.94,124356.96,0.00,0.00,0.00),('1','146','767','230089',4429346,'2138','325',966598.41,968365.18,0.00,0.00,1766.77,1031793.68,0.00,0.00,0.00),('1','146','767','230089',4429347,'2940','325',28477.84,29666.41,0.00,0.00,1188.57,694124.88,0.00,0.00,0.00),('1','146','767','230286',4433074,'2138','325',968365.18,969827.79,0.00,0.00,1462.61,854164.24,0.00,0.00,0.00),('1','146','767','230286',4433075,'2940','325',29666.41,29844.14,0.00,0.00,177.73,103794.32,0.00,0.00,0.00),('1','146','767','230465',4436595,'2138','325',969827.79,969827.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','230465',4436596,'2940','325',29844.14,29844.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','230478',4436791,'2138','325',969827.79,970343.19,0.00,0.00,515.40,300993.60,0.00,0.00,0.00),('1','146','767','230478',4436792,'2940','325',29844.14,30397.66,0.00,0.00,553.52,323255.68,0.00,0.00,0.00),('1','146','767','230525',4437573,'2138','325',970343.19,971874.91,0.00,0.00,1531.72,894524.48,0.00,0.00,0.00),('1','146','767','230525',4437574,'2940','325',30397.66,31499.42,0.00,0.00,1101.76,643427.84,0.00,0.00,0.00),('1','146','767','230781',4442105,'2138','325',971874.91,972693.96,0.00,0.00,819.05,478325.20,0.00,0.00,0.00),('1','146','767','230781',4442106,'2940','325',31499.42,32258.74,0.00,0.00,759.32,443442.88,0.00,0.00,0.00),('1','146','767','230976',4445537,'2138','325',972693.96,972693.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','230976',4445538,'2940','325',32258.74,32258.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','230981',4445626,'2138','325',972693.96,972693.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','230981',4445627,'2940','325',32258.74,32258.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','231001',4445975,'2138','325',972693.96,973789.01,0.00,0.00,1095.05,639509.20,0.00,0.00,0.00),('1','146','767','231001',4445976,'2940','325',32258.74,32288.69,0.00,0.00,29.95,17490.80,0.00,0.00,0.00),('1','146','767','231066',4446949,'2138','325',973789.01,976181.38,0.00,0.00,2392.37,1397144.08,0.00,0.00,0.00),('1','146','767','231066',4446950,'2940','325',32288.69,32854.74,0.00,0.00,566.05,330573.20,0.00,0.00,0.00),('1','146','767','231371',4451808,'2138','325',976181.38,977453.87,0.00,0.00,1272.49,743134.16,0.00,0.00,0.00),('1','146','767','231371',4451809,'2940','325',32854.74,33463.61,0.00,0.00,608.87,355580.08,0.00,0.00,0.00),('1','146','767','231604',4456010,'2138','325',977453.87,977453.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','231604',4456011,'2940','325',33463.61,33463.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','231605',4456012,'2138','325',977453.87,977778.80,0.00,0.00,324.93,189759.12,0.00,0.00,0.00),('1','146','767','231605',4456013,'2940','325',33463.61,33787.61,0.00,0.00,324.00,189216.00,0.00,0.00,0.00),('1','146','767','231633',4456374,'2138','325',977778.80,979008.54,0.00,0.00,1229.74,718168.16,0.00,0.00,0.00),('1','146','767','231633',4456375,'2940','325',33787.61,35597.42,0.00,0.00,1809.81,1056929.04,0.00,0.00,0.00),('1','146','767','231881',4460919,'2138','325',979008.54,980313.00,0.00,0.00,1304.46,761804.64,0.00,0.00,0.00),('1','146','767','231881',4460920,'2940','325',35597.42,36606.04,0.00,0.00,1008.62,589034.08,0.00,0.00,0.00),('1','146','767','232071',4464535,'2138','325',980313.00,980313.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','232071',4464536,'2940','325',36606.04,36692.85,0.00,0.00,86.81,50697.04,0.00,0.00,0.00),('1','146','767','232092',4464818,'2138','325',980313.00,982094.28,0.00,0.00,1781.28,1040267.52,0.00,0.00,0.00),('1','146','767','232092',4464819,'2940','325',36692.85,38054.03,0.00,0.00,1361.18,794929.12,0.00,0.00,0.00),('1','146','767','232338',4468976,'2138','325',982094.28,983982.71,0.00,0.00,1888.43,1102843.12,0.00,0.00,0.00),('1','146','767','232338',4468977,'2940','325',38054.03,38301.95,0.00,0.00,247.92,144785.28,0.00,0.00,0.00),('1','146','767','232583',4473587,'2138','325',983982.71,985768.76,0.00,0.00,1786.05,1071630.00,0.00,0.00,0.00),('1','146','767','232583',4473588,'2940','325',38301.95,39112.85,0.00,0.00,810.90,486540.00,0.00,0.00,0.00),('1','146','767','232841',4478169,'2138','325',985768.76,988087.51,0.00,0.00,2318.75,1391250.00,0.00,0.00,0.00),('1','146','767','232841',4478170,'2940','325',39112.85,39778.89,0.00,0.00,666.04,399624.00,0.00,0.00,0.00),('1','146','767','233082',4482640,'2138','325',988087.51,988087.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','233082',4482641,'2940','325',39778.89,39845.72,0.00,0.00,66.83,40098.00,0.00,0.00,0.00),('1','146','767','233115',4483041,'2138','325',988087.51,990410.82,0.00,0.00,2323.31,1393986.00,0.00,0.00,0.00),('1','146','767','233115',4483042,'2940','325',39845.72,40190.21,0.00,0.00,344.49,206694.00,0.00,0.00,0.00),('1','146','767','233337',4487224,'2138','325',990410.82,990410.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','233337',4487225,'2940','325',40190.21,40190.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','233339',4487250,'2138','325',990410.82,990410.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','233339',4487251,'2940','325',40190.21,40190.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','233363',4487594,'2138','325',990410.82,992305.02,0.00,0.00,1894.20,1181980.80,0.00,0.00,0.00),('1','146','767','233363',4487595,'2940','325',40190.21,40705.51,0.00,0.00,515.30,321547.20,0.00,0.00,0.00),('1','146','767','233586',4491848,'2138','325',992305.02,992497.01,0.00,0.00,191.99,119801.76,0.00,0.00,0.00),('1','146','767','233586',4491849,'2940','325',40705.51,40705.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','233678',4493140,'2138','325',992497.01,992497.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','233678',4493141,'2940','325',40705.51,40705.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','233682',4493191,'2138','325',992497.01,993790.57,0.00,0.00,1293.56,807181.44,0.00,0.00,0.00),('1','146','767','233682',4493192,'2940','325',40705.51,41699.50,0.00,0.00,993.99,620249.76,0.00,0.00,0.00),('1','146','767','233828',4496055,'2138','325',993790.57,995207.01,0.00,0.00,1416.44,883858.56,0.00,0.00,0.00),('1','146','767','233828',4496056,'2940','325',41699.50,43032.05,0.00,0.00,1332.55,831511.20,0.00,0.00,0.00),('1','146','767','234032',4499676,'2138','325',995207.01,995310.55,0.00,0.00,103.54,64608.96,0.00,0.00,0.00),('1','146','767','234032',4499677,'2940','325',43032.05,43189.58,0.00,0.00,157.53,98298.72,0.00,0.00,0.00),('1','146','767','234149',4501830,'2138','325',995310.55,995310.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','234149',4501831,'2940','325',43189.58,43189.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','234156',4501963,'2138','325',995310.55,996939.41,0.00,0.00,1628.86,1016408.64,0.00,0.00,0.00),('1','146','767','234156',4501964,'2940','325',43189.58,43562.01,0.00,0.00,372.43,232396.32,0.00,0.00,0.00),('1','146','767','234310',4504688,'2138','325',996939.41,999242.25,0.00,0.00,2302.84,1436972.16,0.00,0.00,0.00),('1','146','767','234310',4504689,'2940','325',43562.01,44051.91,0.00,0.00,489.90,305697.60,0.00,0.00,0.00),('1','146','767','234552',4509088,'2138','325',999242.25,999760.72,0.00,0.00,518.47,323525.28,0.00,0.00,0.00),('1','146','767','234552',4509089,'2940','325',44051.91,44139.41,0.00,0.00,87.50,54600.00,0.00,0.00,0.00),('1','146','767','234683',4511365,'2138','325',999760.72,1000689.55,0.00,0.00,928.83,579589.92,0.00,0.00,0.00),('1','146','767','234683',4511366,'2940','325',44139.41,44719.82,0.00,0.00,580.41,362175.84,0.00,0.00,0.00),('1','146','767','234784',4513231,'2138','325',1000689.55,1000689.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','234784',4513232,'2940','325',44719.82,44747.19,0.00,0.00,27.37,17078.88,0.00,0.00,0.00),('1','146','767','234812',4513658,'2138','325',1000689.55,1002081.78,0.00,0.00,1392.23,868751.52,0.00,0.00,0.00),('1','146','767','234812',4513659,'2940','325',44747.19,45583.33,0.00,0.00,836.14,521751.36,0.00,0.00,0.00),('1','146','767','235056',4518058,'2138','325',1002081.78,1003028.75,0.00,0.00,946.97,590909.28,0.00,0.00,0.00),('1','146','767','235056',4518059,'2940','325',45583.33,45898.48,0.00,0.00,315.15,196653.60,0.00,0.00,0.00),('1','146','767','235191',4520263,'2138','325',1003028.75,1003028.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','235191',4520264,'2940','325',45898.48,45898.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','235200',4520425,'2138','325',1003028.75,1004194.62,0.00,0.00,1165.87,727502.88,0.00,0.00,0.00),('1','146','767','235200',4520426,'2940','325',45898.48,46017.23,0.00,0.00,118.75,74100.00,0.00,0.00,0.00),('1','146','767','235292',4522023,'2138','325',1004194.62,1005673.68,0.00,0.00,1479.06,922933.44,0.00,0.00,0.00),('1','146','767','235292',4522024,'2940','325',46017.23,47455.43,0.00,0.00,1438.20,897436.80,0.00,0.00,0.00),('1','146','767','235514',4525954,'2138','325',1005673.68,1006445.03,0.00,0.00,771.35,481322.40,0.00,0.00,0.00),('1','146','767','235514',4525955,'2940','325',47455.43,47711.68,0.00,0.00,256.25,159900.00,0.00,0.00,0.00),('1','146','767','235638',4528031,'2138','325',1006445.03,1006445.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','235638',4528032,'2940','325',47711.68,47711.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','235640',4528042,'2138','325',1006445.03,1007608.89,0.00,0.00,1163.86,726248.64,0.00,0.00,0.00),('1','146','767','235640',4528043,'2940','325',47711.68,47892.93,0.00,0.00,181.25,113100.00,0.00,0.00,0.00),('1','146','767','235742',4530062,'2138','325',1007608.89,1009265.51,0.00,0.00,1656.62,1060236.80,0.00,0.00,0.00),('1','146','767','235742',4530063,'2940','325',47892.93,48269.47,0.00,0.00,376.54,240985.60,0.00,0.00,0.00),('1','146','767','236006',4534530,'2138','325',1009265.51,1010464.45,0.00,0.00,1198.94,767321.60,0.00,0.00,0.00),('1','146','767','236006',4534531,'2940','325',48269.47,48867.72,0.00,0.00,598.25,382880.00,0.00,0.00,0.00),('1','146','767','236172',4537626,'2138','325',1010464.45,1010464.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','236172',4537627,'2940','325',48867.72,48867.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','236173',4537628,'2138','325',1010464.45,1010783.31,0.00,0.00,318.86,204070.40,0.00,0.00,0.00),('1','146','767','236173',4537629,'2940','325',48867.72,49026.87,0.00,0.00,159.15,101856.00,0.00,0.00,0.00),('1','146','767','236222',4538563,'2138','325',1010783.31,1013201.86,0.00,0.00,2418.55,1547872.00,0.00,0.00,0.00),('1','146','767','236222',4538564,'2940','325',49026.87,49696.97,0.00,0.00,670.10,428864.00,0.00,0.00,0.00),('1','146','767','236497',4543321,'2138','325',1013201.86,1014369.60,0.00,0.00,1167.74,747353.60,0.00,0.00,0.00),('1','146','767','236497',4543322,'2940','325',49696.97,50124.32,0.00,0.00,427.35,273504.00,0.00,0.00,0.00),('1','146','767','236655',4545934,'2138','325',1014369.60,1014369.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','236655',4545935,'2940','325',50124.32,50124.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','236662',4545992,'2138','325',1014369.60,1015284.67,0.00,0.00,915.07,585644.80,0.00,0.00,0.00),('1','146','767','236662',4545993,'2940','325',50124.32,50508.93,0.00,0.00,384.61,246150.40,0.00,0.00,0.00),('1','146','767','236720',4547047,'2138','325',1015284.67,1017427.96,0.00,0.00,2143.29,1371705.60,0.00,0.00,0.00),('1','146','767','236720',4547048,'2940','325',50508.93,51495.13,0.00,0.00,986.20,631168.00,0.00,0.00,0.00),('1','146','767','236946',4551066,'2138','325',1017427.96,1017939.62,0.00,0.00,511.66,327462.40,0.00,0.00,0.00),('1','146','767','236946',4551067,'2940','325',51495.13,51757.61,0.00,0.00,262.48,167987.20,0.00,0.00,0.00),('1','146','767','237050',4552770,'2138','325',1017939.62,1017939.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','237050',4552771,'2940','325',51757.61,51757.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','237058',4552860,'2138','325',1017939.62,1018946.13,0.00,0.00,1006.51,644166.40,0.00,0.00,0.00),('1','146','767','237058',4552861,'2940','325',51757.61,52420.29,0.00,0.00,662.68,424115.20,0.00,0.00,0.00),('1','146','767','237162',4554858,'2138','325',1018946.13,1020763.21,0.00,0.00,1817.08,1162931.20,0.00,0.00,0.00),('1','146','767','237162',4554859,'2940','325',52420.29,53143.69,0.00,0.00,723.40,462976.00,0.00,0.00,0.00),('1','146','767','237367',4558670,'2138','325',1020763.21,1021640.24,0.00,0.00,877.03,562659.20,0.00,0.00,0.00),('1','146','767','237367',4558671,'2940','325',53143.69,53336.99,0.00,0.00,193.30,123712.00,0.00,0.00,0.00),('1','146','767','237509',4561160,'2138','325',1021640.24,1021706.60,0.00,0.00,66.36,42470.40,0.00,0.00,0.00),('1','146','767','237509',4561161,'2940','325',53336.99,53336.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','237511',4561196,'2138','325',1021706.60,1022624.78,0.00,0.00,918.18,587635.20,0.00,0.00,0.00),('1','146','767','237511',4561197,'2940','325',53336.99,53703.31,0.00,0.00,366.32,234444.80,0.00,0.00,0.00),('1','146','767','237590',4562667,'2138','325',1022624.78,1025009.49,0.00,0.00,2384.71,1564369.76,0.00,0.00,0.00),('1','146','767','237590',4562668,'2940','325',53703.31,53751.63,0.00,0.00,48.32,31697.92,0.00,0.00,0.00),('1','146','767','237853',4566993,'2138','325',1025009.49,1026266.19,0.00,0.00,1256.70,804288.00,0.00,0.00,0.00),('1','146','767','237853',4566994,'2940','325',53751.63,54301.31,0.00,0.00,549.68,351795.20,0.00,0.00,0.00),('1','146','767','238046',4570019,'2138','325',1026266.19,1026266.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','238046',4570020,'2940','325',54301.31,54301.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','238047',4570021,'2138','325',1026266.19,1026885.65,0.00,0.00,619.46,396454.40,0.00,0.00,0.00),('1','146','767','238047',4570022,'2940','325',54301.31,54748.26,0.00,0.00,446.95,286048.00,0.00,0.00,0.00),('1','146','767','238102',4570983,'2138','325',1026885.65,1029275.06,0.00,0.00,2389.41,1529222.40,0.00,0.00,0.00),('1','146','767','238102',4570984,'2940','325',54748.26,55502.20,0.00,0.00,753.94,482521.60,0.00,0.00,0.00),('1','146','767','238347',4575206,'2138','325',1029275.06,1030079.03,0.00,0.00,803.97,514540.80,0.00,0.00,0.00),('1','146','767','238347',4575207,'2940','325',55502.20,55798.47,0.00,0.00,296.27,189612.80,0.00,0.00,0.00),('1','146','767','238500',4577718,'2138','325',1030079.03,1030151.11,0.00,0.00,72.08,46131.20,0.00,0.00,0.00),('1','146','767','238500',4577719,'2940','325',55798.47,55798.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','238505',4577776,'2138','325',1030151.11,1030765.83,0.00,0.00,614.72,393420.80,0.00,0.00,0.00),('1','146','767','238505',4577777,'2940','325',55798.47,56321.00,0.00,0.00,522.53,334419.20,0.00,0.00,0.00),('1','146','767','238594',4579315,'2138','325',1030765.83,1032572.68,0.00,0.00,1806.85,1156384.00,0.00,0.00,0.00),('1','146','767','238594',4579316,'2940','325',56321.00,57097.47,0.00,0.00,776.47,496940.80,0.00,0.00,0.00),('1','146','767','238829',4583399,'2138','325',1032572.68,1033572.66,0.00,0.00,999.98,639987.20,0.00,0.00,0.00),('1','146','767','238829',4583400,'2940','325',57097.47,57696.92,0.00,0.00,599.45,383648.00,0.00,0.00,0.00),('1','146','767','238977',4586205,'2138','325',1033572.66,1033572.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','238977',4586206,'2940','325',57696.92,57697.02,0.00,0.00,0.10,64.00,0.00,0.00,0.00),('1','146','767','238981',4586247,'2138','325',1033572.66,1033975.80,0.00,0.00,403.14,258009.60,0.00,0.00,0.00),('1','146','767','238981',4586248,'2940','325',57697.02,58005.49,0.00,0.00,308.47,197420.80,0.00,0.00,0.00),('1','146','767','239054',4587502,'2138','325',1033975.80,1035922.20,0.00,0.00,1946.40,1245696.00,0.00,0.00,0.00),('1','146','767','239054',4587503,'2940','325',58005.49,58843.89,0.00,0.00,838.40,536576.00,0.00,0.00,0.00),('1','146','767','239281',4591359,'2138','325',1035922.20,1037308.25,0.00,0.00,1386.05,887072.00,0.00,0.00,0.00),('1','146','767','239281',4591360,'2940','325',58843.89,59445.83,0.00,0.00,601.94,385241.60,0.00,0.00,0.00),('1','146','767','239498',4595184,'2138','325',1037308.25,1037308.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','239498',4595185,'2940','325',59445.83,59490.66,0.00,0.00,44.83,28691.20,0.00,0.00,0.00),('1','146','767','239499',4595186,'2138','325',1037308.25,1037811.96,0.00,0.00,503.71,322374.40,0.00,0.00,0.00),('1','146','767','239499',4595187,'2940','325',59490.66,59490.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','239518',4595410,'2138','325',1037811.96,1039443.16,0.00,0.00,1631.20,1043968.00,0.00,0.00,0.00),('1','146','767','239518',4595411,'2940','325',59490.66,60530.97,0.00,0.00,1040.31,665798.40,0.00,0.00,0.00),('1','146','767','239763',4599623,'2138','325',1039443.16,1040719.97,0.00,0.00,1276.81,817158.40,0.00,0.00,0.00),('1','146','767','239763',4599624,'2940','325',60530.97,61298.94,0.00,0.00,767.97,491500.80,0.00,0.00,0.00),('1','146','767','239952',4603053,'2138','325',1040719.97,1040810.27,0.00,0.00,90.30,57792.00,0.00,0.00,0.00),('1','146','767','239952',4603054,'2940','325',61298.94,61298.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','239987',4603549,'2138','325',1040810.27,1040810.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','239987',4603550,'2940','325',61298.94,61548.38,0.00,0.00,249.44,159641.60,0.00,0.00,0.00),('1','146','767','239991',4603569,'2138','325',1040810.27,1042610.66,0.00,0.00,1800.39,1152249.60,0.00,0.00,0.00),('1','146','767','239991',4603570,'2940','325',61548.38,62086.93,0.00,0.00,538.55,344672.00,0.00,0.00,0.00),('1','146','767','240186',4607094,'2138','325',1042610.66,1044182.61,0.00,0.00,1571.95,1006048.00,0.00,0.00,0.00),('1','146','767','240186',4607095,'2940','325',62086.93,62883.68,0.00,0.00,796.75,509920.00,0.00,0.00,0.00),('1','146','767','240438',4611185,'2138','325',1044182.61,1044285.53,0.00,0.00,102.92,65868.80,0.00,0.00,0.00),('1','146','767','240438',4611186,'2940','325',62883.68,62883.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','240504',4612099,'2138','325',1044285.53,1044370.53,0.00,0.00,85.00,54400.00,0.00,0.00,0.00),('1','146','767','240504',4612100,'2940','325',62883.68,62883.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','240508',4612218,'2138','325',1044370.53,1045863.31,0.00,0.00,1492.78,955379.20,0.00,0.00,0.00),('1','146','767','240508',4612219,'2940','325',62883.68,63173.72,0.00,0.00,290.04,185625.60,0.00,0.00,0.00),('1','146','767','240667',4614695,'2138','325',1045863.31,1048468.10,0.00,0.00,2604.79,1667065.60,0.00,0.00,0.00),('1','146','767','240667',4614696,'2940','325',63173.72,63229.66,0.00,0.00,55.94,35801.60,0.00,0.00,0.00),('1','146','767','240962',4619838,'2138','325',1048468.10,1049311.65,0.00,0.00,843.55,539872.00,0.00,0.00,0.00),('1','146','767','240962',4619839,'2940','325',63229.66,63232.56,0.00,0.00,2.90,1856.00,0.00,0.00,0.00),('1','146','767','241089',4622112,'2138','325',1049311.65,1049401.65,0.00,0.00,90.00,57600.00,0.00,0.00,0.00),('1','146','767','241089',4622113,'2940','325',63232.56,63232.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','241090',4622114,'2138','325',1049401.65,1050398.94,0.00,0.00,997.29,638265.60,0.00,0.00,0.00),('1','146','767','241090',4622115,'2940','325',63232.56,63313.89,0.00,0.00,81.33,52051.20,0.00,0.00,0.00),('1','146','767','241207',4624389,'2138','325',1050398.94,1052250.45,0.00,0.00,1851.51,1184966.40,0.00,0.00,0.00),('1','146','767','241207',4624390,'2940','325',63313.89,63556.35,0.00,0.00,242.46,155174.40,0.00,0.00,0.00),('1','146','767','241467',4628838,'2138','325',1052250.45,1054476.92,0.00,0.00,2226.47,1424940.80,0.00,0.00,0.00),('1','146','767','241467',4628839,'2940','325',63556.35,63567.29,0.00,0.00,10.94,7001.60,0.00,0.00,0.00),('1','146','767','241687',4632565,'2138','325',1054476.92,1054592.06,0.00,0.00,115.14,73689.60,0.00,0.00,0.00),('1','146','767','241687',4632566,'2940','325',63567.29,63567.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','241726',4633211,'2138','325',1054592.06,1055864.76,0.00,0.00,1272.70,814528.00,0.00,0.00,0.00),('1','146','767','241726',4633212,'2940','325',63567.29,64766.42,0.00,0.00,1199.13,767443.20,0.00,0.00,0.00),('1','146','767','241960',4637286,'2138','325',1055864.76,1058192.72,0.00,0.00,2327.96,1490254.40,0.00,0.00,0.00),('1','146','767','241960',4637287,'2940','325',64766.42,64877.73,0.00,0.00,111.31,71238.40,0.00,0.00,0.00),('1','146','767','242245',4642135,'2138','325',1058192.72,1058319.93,0.00,0.00,127.21,81414.40,0.00,0.00,0.00),('1','146','767','242245',4642136,'2940','325',64877.73,64877.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','242246',4642137,'2138','325',1058319.93,1059631.11,0.00,0.00,1311.18,839155.20,0.00,0.00,0.00),('1','146','767','242246',4642138,'2940','325',64877.73,65672.97,0.00,0.00,795.24,508953.60,0.00,0.00,0.00),('1','146','767','242411',4645290,'2138','325',1059631.11,1062645.42,0.00,0.00,3014.31,1929158.40,0.00,0.00,0.00),('1','146','767','242411',4645291,'2940','325',65672.97,65676.10,0.00,0.00,3.13,2003.20,0.00,0.00,0.00),('1','146','767','242660',4649615,'2138','325',1062645.42,1062852.77,0.00,0.00,207.35,132704.00,0.00,0.00,0.00),('1','146','767','242660',4649616,'2940','325',65676.10,65751.43,0.00,0.00,75.33,48211.20,0.00,0.00,0.00),('1','146','767','242738',4650797,'2138','325',1062852.77,1062852.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','242738',4650798,'2940','325',65751.43,65751.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','242751',4651113,'2138','325',1062852.77,1064585.08,0.00,0.00,1732.31,1108678.40,0.00,0.00,0.00),('1','146','767','242751',4651114,'2940','325',65751.43,66313.02,0.00,0.00,561.59,359417.60,0.00,0.00,0.00),('1','146','767','242905',4653735,'2138','325',1064585.08,1066841.74,0.00,0.00,2256.66,1444262.40,0.00,0.00,0.00),('1','146','767','242905',4653736,'2940','325',66313.02,66715.58,0.00,0.00,402.56,257638.40,0.00,0.00,0.00),('1','146','767','243126',4657597,'2138','325',1066841.74,1067309.87,0.00,0.00,468.13,299603.20,0.00,0.00,0.00),('1','146','767','243126',4657598,'2940','325',66715.58,66724.33,0.00,0.00,8.75,5600.00,0.00,0.00,0.00),('1','146','767','243230',4659324,'2138','325',1067309.87,1068597.60,0.00,0.00,1287.73,824147.20,0.00,0.00,0.00),('1','146','767','243230',4659325,'2940','325',66724.33,67482.30,0.00,0.00,757.97,485100.80,0.00,0.00,0.00),('1','146','767','243360',4661780,'2138','325',1068597.60,1070957.67,0.00,0.00,2360.07,1510444.80,0.00,0.00,0.00),('1','146','767','243360',4661781,'2940','325',67482.30,68212.49,0.00,0.00,730.19,467321.60,0.00,0.00,0.00),('1','146','767','243590',4665715,'2138','325',1070957.67,1070970.17,0.00,0.00,12.50,8000.00,0.00,0.00,0.00),('1','146','767','243590',4665716,'2940','325',68212.49,68234.03,0.00,0.00,21.54,13785.60,0.00,0.00,0.00),('1','146','767','243646',4666426,'2138','325',1070970.17,1071104.57,0.00,0.00,134.40,86016.00,0.00,0.00,0.00),('1','146','767','243646',4666427,'2940','325',68234.03,68234.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','243650',4666489,'2138','325',1071104.57,1072497.95,0.00,0.00,1393.38,891763.20,0.00,0.00,0.00),('1','146','767','243650',4666490,'2940','325',68234.03,69550.95,0.00,0.00,1316.92,842828.80,0.00,0.00,0.00),('1','146','767','243814',4669735,'2138','325',1072497.95,1074768.43,0.00,0.00,2270.48,1453107.20,0.00,0.00,0.00),('1','146','767','243814',4669736,'2940','325',69550.95,69670.17,0.00,0.00,119.22,76300.80,0.00,0.00,0.00),('1','146','767','243989',4672776,'2138','325',1074768.43,1074768.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','243989',4672777,'2940','325',69670.17,69694.25,0.00,0.00,24.08,15411.20,0.00,0.00,0.00),('1','146','767','243990',4672778,'2138','325',1074768.43,1075051.87,0.00,0.00,283.44,181401.60,0.00,0.00,0.00),('1','146','767','243990',4672779,'2940','325',69694.25,69694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','244030',4673487,'2138','325',1075051.87,1076821.55,0.00,0.00,1769.68,1132595.20,0.00,0.00,0.00),('1','146','767','244030',4673488,'2940','325',69694.25,70933.66,0.00,0.00,1239.41,793222.40,0.00,0.00,0.00),('1','146','767','244267',4677476,'2138','325',1076821.55,1078441.21,0.00,0.00,1619.66,1036582.40,0.00,0.00,0.00),('1','146','767','244267',4677477,'2940','325',70933.66,70991.47,0.00,0.00,57.81,36998.40,0.00,0.00,0.00),('1','146','767','244449',4680578,'2138','325',1078441.21,1078447.18,0.00,0.00,5.97,3820.80,0.00,0.00,0.00),('1','146','767','244449',4680579,'2940','325',70991.47,70991.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','244450',4680580,'2138','325',1078447.18,1078976.60,0.00,0.00,529.42,338828.80,0.00,0.00,0.00),('1','146','767','244450',4680581,'2940','325',70991.47,71010.22,0.00,0.00,18.75,12000.00,0.00,0.00,0.00),('1','146','767','244499',4681544,'2138','325',1078976.60,1080978.16,0.00,0.00,2001.56,1280998.40,0.00,0.00,0.00),('1','146','767','244499',4681545,'2940','325',71010.22,71658.44,0.00,0.00,648.22,414860.80,0.00,0.00,0.00),('1','146','767','244738',4685401,'2138','325',1080978.16,1082781.96,0.00,0.00,1803.80,1154432.00,0.00,0.00,0.00),('1','146','767','244738',4685402,'2940','325',71658.44,71746.69,0.00,0.00,88.25,56480.00,0.00,0.00,0.00),('1','146','767','244901',4688471,'2138','325',1082781.96,1082781.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','244901',4688472,'2940','325',71746.69,71768.12,0.00,0.00,21.43,13715.20,0.00,0.00,0.00),('1','146','767','244902',4688473,'2138','325',1082781.96,1083203.69,0.00,0.00,421.73,269907.20,0.00,0.00,0.00),('1','146','767','244902',4688474,'2940','325',71768.12,71909.92,0.00,0.00,141.80,90752.00,0.00,0.00,0.00),('1','146','767','244977',4689619,'2138','325',1083203.69,1085256.48,0.00,0.00,2052.79,1297363.28,0.00,0.00,0.00),('1','146','767','244977',4689620,'2940','325',71909.92,72501.20,0.00,0.00,591.28,373688.96,0.00,0.00,0.00),('1','146','767','245197',4693671,'2138','325',1085256.48,1087367.94,0.00,0.00,2111.46,1334442.72,0.00,0.00,0.00),('1','146','767','245197',4693672,'2940','325',72501.20,72540.43,0.00,0.00,39.23,24793.36,0.00,0.00,0.00),('1','146','767','245357',4696406,'2138','325',1087367.94,1087369.65,0.00,0.00,1.71,1080.72,0.00,0.00,0.00),('1','146','767','245357',4696407,'2940','325',72540.43,72540.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','245443',4697736,'2138','325',1087369.65,1089877.04,0.00,0.00,2507.39,1584670.48,0.00,0.00,0.00),('1','146','767','245443',4697737,'2940','325',72540.43,73056.34,0.00,0.00,515.91,326055.12,0.00,0.00,0.00),('1','146','767','245670',4701788,'2138','325',1089877.04,1091855.91,0.00,0.00,1978.87,1250645.84,0.00,0.00,0.00),('1','146','767','245670',4701789,'2940','325',73056.34,73102.46,0.00,0.00,46.12,29147.84,0.00,0.00,0.00),('1','146','767','245877',4704981,'2138','325',1091855.91,1091893.54,0.00,0.00,37.63,23782.16,0.00,0.00,0.00),('1','146','767','245877',4704982,'2940','325',73102.46,73102.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','245925',4705754,'2138','325',1091893.54,1094302.22,0.00,0.00,2408.68,1483746.88,0.00,0.00,0.00),('1','146','767','245925',4705755,'2940','325',73102.46,73434.21,0.00,0.00,331.75,204358.00,0.00,0.00,0.00),('1','146','767','246169',4709909,'2138','325',1094302.22,1096425.42,0.00,0.00,2123.20,1307891.20,0.00,0.00,0.00),('1','146','767','246169',4709910,'2940','325',73434.21,73569.11,0.00,0.00,134.90,83098.40,0.00,0.00,0.00),('1','146','767','246404',4713757,'2138','325',1096425.42,1099098.72,0.00,0.00,2673.30,1646752.80,0.00,0.00,0.00),('1','146','767','246404',4713758,'2940','325',73569.11,73647.68,0.00,0.00,78.57,48399.12,0.00,0.00,0.00),('1','146','767','246694',4718725,'2138','325',1099098.72,1101074.32,0.00,0.00,1975.60,1216969.60,0.00,0.00,0.00),('1','146','767','246694',4718726,'2940','325',73647.68,74190.21,0.00,0.00,542.53,334198.48,0.00,0.00,0.00),('1','146','767','246886',4722302,'2138','325',1101074.32,1101134.61,0.00,0.00,60.29,37138.64,0.00,0.00,0.00),('1','146','767','246886',4722303,'2940','325',74190.21,74190.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','246887',4722304,'2138','325',1101134.61,1101134.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','246887',4722305,'2940','325',74190.21,74304.66,0.00,0.00,114.45,70501.20,0.00,0.00,0.00),('1','146','767','246923',4722935,'2138','325',1101134.61,1103362.09,0.00,0.00,2227.48,1372127.68,0.00,0.00,0.00),('1','146','767','246923',4722936,'2940','325',74304.66,74922.96,0.00,0.00,618.30,380872.80,0.00,0.00,0.00),('1','146','767','247157',4726870,'2138','325',1103362.09,1105911.81,0.00,0.00,2549.72,1570627.52,0.00,0.00,0.00),('1','146','767','247157',4726871,'2940','325',74922.96,74948.28,0.00,0.00,25.32,15597.12,0.00,0.00,0.00),('1','146','767','247374',4730794,'2138','325',1105911.81,1105911.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','247374',4730795,'2940','325',74948.28,74948.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','247401',4731063,'2138','325',1105911.81,1108328.12,0.00,0.00,2416.31,1488446.96,0.00,0.00,0.00),('1','146','767','247401',4731064,'2940','325',74948.28,75092.11,0.00,0.00,143.83,88599.28,0.00,0.00,0.00),('1','146','767','247660',4735463,'2138','325',1108328.12,1109271.26,0.00,0.00,943.14,577516.80,0.00,0.00,0.00),('1','146','767','247660',4735464,'2940','325',75092.11,75092.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','247768',4737202,'2138','325',1109271.26,1111046.60,0.00,0.00,1775.34,1051001.28,0.00,0.00,0.00),('1','146','767','247768',4737203,'2940','325',75092.11,75267.59,0.00,0.00,175.48,103884.16,0.00,0.00,0.00),('1','146','767','247938',4739868,'2138','325',1111046.60,1111134.12,0.00,0.00,87.52,51811.84,0.00,0.00,0.00),('1','146','767','247938',4739869,'2940','325',75267.59,75267.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','247950',4740067,'2138','325',1111134.12,1113407.55,0.00,0.00,2273.43,1345870.56,0.00,0.00,0.00),('1','146','767','247950',4740068,'2940','325',75267.59,75891.90,0.00,0.00,624.31,369591.52,0.00,0.00,0.00),('1','146','767','248151',4743774,'2138','325',1113407.55,1115712.54,0.00,0.00,2304.99,1364554.08,0.00,0.00,0.00),('1','146','767','248151',4743775,'2940','325',75891.90,75939.17,0.00,0.00,47.27,27983.84,0.00,0.00,0.00),('1','146','767','248319',4746750,'2138','325',1115712.54,1115730.31,0.00,0.00,17.77,10519.84,0.00,0.00,0.00),('1','146','767','248319',4746751,'2940','325',75939.17,75939.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','248320',4746752,'2138','325',1115730.31,1116301.44,0.00,0.00,571.13,338108.96,0.00,0.00,0.00),('1','146','767','248320',4746753,'2940','325',75939.17,75945.42,0.00,0.00,6.25,3700.00,0.00,0.00,0.00),('1','146','767','248396',4747936,'2138','325',1116301.44,1119417.46,0.00,0.00,3116.02,1844683.84,0.00,0.00,0.00),('1','146','767','248396',4747937,'2940','325',75945.42,76886.00,0.00,0.00,940.58,556823.36,0.00,0.00,0.00),('1','146','767','248637',4751922,'2138','325',1119417.46,1120103.14,0.00,0.00,685.68,405922.56,0.00,0.00,0.00),('1','146','767','248637',4751923,'2940','325',76886.00,76886.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','248721',4753393,'2138','325',1120103.14,1120193.83,0.00,0.00,90.69,53688.48,0.00,0.00,0.00),('1','146','767','248721',4753394,'2940','325',76886.00,76886.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','248722',4753395,'2138','325',1120193.83,1121802.70,0.00,0.00,1608.87,952451.04,0.00,0.00,0.00),('1','146','767','248722',4753396,'2940','325',76886.00,76916.07,0.00,0.00,30.07,17801.44,0.00,0.00,0.00),('1','146','767','248858',4755800,'2138','325',1121802.70,1123352.21,0.00,0.00,1549.51,917309.92,0.00,0.00,0.00),('1','146','767','248858',4755801,'2940','325',76916.07,77270.99,0.00,0.00,354.92,210112.64,0.00,0.00,0.00),('1','146','767','249093',4759753,'2138','325',1123352.21,1124409.74,0.00,0.00,1057.53,626057.76,0.00,0.00,0.00),('1','146','767','249093',4759754,'2940','325',77270.99,77270.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','249238',4762187,'2138','325',1124409.74,1125580.68,0.00,0.00,1170.94,693196.48,0.00,0.00,0.00),('1','146','767','249238',4762188,'2940','325',77270.99,77326.06,0.00,0.00,55.07,32601.44,0.00,0.00,0.00),('1','146','767','249341',4763926,'2138','325',1125580.68,1126792.82,0.00,0.00,1212.14,717586.88,0.00,0.00,0.00),('1','146','767','249341',4763927,'2940','325',77326.06,78132.14,0.00,0.00,806.08,477199.36,0.00,0.00,0.00),('1','146','767','249572',4767883,'2138','325',1126792.82,1128633.19,0.00,0.00,1840.37,1089499.04,0.00,0.00,0.00),('1','146','767','249572',4767884,'2940','325',78132.14,78402.08,0.00,0.00,269.94,159804.48,0.00,0.00,0.00),('1','146','767','249802',4771828,'2138','325',1128633.19,1128633.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','249802',4771829,'2940','325',78402.08,78402.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','249861',4772578,'2138','325',1128633.19,1130511.19,0.00,0.00,1878.00,1111776.00,0.00,0.00,0.00),('1','146','767','249861',4772579,'2940','325',78402.08,78699.80,0.00,0.00,297.72,176250.24,0.00,0.00,0.00),('1','146','767','250081',4776387,'2138','325',1130511.19,1132774.01,0.00,0.00,2262.82,1339589.44,0.00,0.00,0.00),('1','146','767','250081',4776388,'2940','325',78699.80,78813.15,0.00,0.00,113.35,67103.20,0.00,0.00,0.00),('1','146','767','250341',4780690,'2138','325',1132774.01,1133238.34,0.00,0.00,464.33,274883.36,0.00,0.00,0.00),('1','146','767','250341',4780691,'2940','325',78813.15,78939.33,0.00,0.00,126.18,74698.56,0.00,0.00,0.00),('1','146','767','250416',4781717,'2138','325',1133238.34,1134555.68,0.00,0.00,1317.34,779865.28,0.00,0.00,0.00),('1','146','767','250416',4781718,'2940','325',78939.33,79283.93,0.00,0.00,344.60,204003.20,0.00,0.00,0.00),('1','146','767','250552',4784285,'2138','325',1134555.68,1136143.91,0.00,0.00,1588.23,940232.16,0.00,0.00,0.00),('1','146','767','250552',4784286,'2940','325',79283.93,79372.11,0.00,0.00,88.18,52202.56,0.00,0.00,0.00),('1','146','767','250812',4788631,'2138','325',1136143.91,1137565.55,0.00,0.00,1421.64,841610.88,0.00,0.00,0.00),('1','146','767','250812',4788632,'2940','325',79372.11,79692.71,0.00,0.00,320.60,189795.20,0.00,0.00,0.00),('1','146','767','250978',4791835,'2138','325',1137565.55,1137565.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','250978',4791836,'2940','325',79692.71,79692.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','251016',4792492,'2138','325',1137565.55,1139836.02,0.00,0.00,2270.47,1344118.24,0.00,0.00,0.00),('1','146','767','251016',4792493,'2940','325',79692.71,79803.52,0.00,0.00,110.81,65599.52,0.00,0.00,0.00),('1','146','767','251294',4797041,'2138','325',1139836.02,1142096.25,0.00,0.00,2260.23,1338056.16,0.00,0.00,0.00),('1','146','767','251294',4797042,'2940','325',79803.52,80315.19,0.00,0.00,511.67,302908.64,0.00,0.00,0.00),('1','146','767','251502',4800801,'2138','325',1142096.25,1142284.06,0.00,0.00,187.81,111183.52,0.00,0.00,0.00),('1','146','767','251502',4800802,'2940','325',80315.19,80315.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','251600',4802333,'2138','325',1142284.06,1142284.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','251600',4802334,'2940','325',80315.19,80315.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','251607',4802525,'2138','325',1142284.06,1144063.26,0.00,0.00,1779.20,1053286.40,0.00,0.00,0.00),('1','146','767','251607',4802526,'2940','325',80315.19,80538.84,0.00,0.00,223.65,132400.80,0.00,0.00,0.00),('1','146','767','251752',4805315,'2138','325',1144063.26,1146552.50,0.00,0.00,2489.24,1473630.08,0.00,0.00,0.00),('1','146','767','251752',4805316,'2940','325',80538.84,80647.77,0.00,0.00,108.93,64486.56,0.00,0.00,0.00),('1','146','767','252002',4809397,'2138','325',1146552.50,1147148.32,0.00,0.00,595.82,352725.44,0.00,0.00,0.00),('1','146','767','252002',4809398,'2940','325',80647.77,80866.43,0.00,0.00,218.66,129446.72,0.00,0.00,0.00),('1','146','767','252085',4811002,'2138','325',1147148.32,1147148.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','252085',4811003,'2940','325',80866.43,80866.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','252086',4811004,'2138','325',1147148.32,1148913.20,0.00,0.00,1764.88,1044808.96,0.00,0.00,0.00),('1','146','767','252086',4811005,'2940','325',80866.43,81633.41,0.00,0.00,766.98,454052.16,0.00,0.00,0.00),('1','146','767','252241',4813571,'2138','325',1148913.20,1151182.91,0.00,0.00,2269.71,1343668.32,0.00,0.00,0.00),('1','146','767','252241',4813572,'2940','325',81633.41,82086.94,0.00,0.00,453.53,268489.76,0.00,0.00,0.00),('1','146','767','252467',4817864,'2138','325',1151182.91,1153899.62,0.00,0.00,2716.71,1608292.32,0.00,0.00,0.00),('1','146','767','252467',4817865,'2940','325',82086.94,82133.77,0.00,0.00,46.83,27723.36,0.00,0.00,0.00),('1','146','767','252719',4822085,'2138','325',1153899.62,1156227.14,0.00,0.00,2327.52,1377891.84,0.00,0.00,0.00),('1','146','767','252719',4822086,'2940','325',82133.77,82513.16,0.00,0.00,379.39,224598.88,0.00,0.00,0.00),('1','146','767','252975',4826178,'2138','325',1156227.14,1158623.45,0.00,0.00,2396.31,1418615.52,0.00,0.00,0.00),('1','146','767','252975',4826179,'2940','325',82513.16,82513.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','253203',4830223,'2138','325',1158623.45,1161517.98,0.00,0.00,2894.53,1713561.76,0.00,0.00,0.00),('1','146','767','253203',4830224,'2940','325',82513.16,82625.38,0.00,0.00,112.22,66434.24,0.00,0.00,0.00),('1','146','767','253472',4834730,'2138','325',1161517.98,1163714.25,0.00,0.00,2196.27,1300191.84,0.00,0.00,0.00),('1','146','767','253472',4834731,'2940','325',82625.38,83272.69,0.00,0.00,647.31,383207.52,0.00,0.00,0.00),('1','146','767','253713',4838788,'2138','325',1163714.25,1165767.83,0.00,0.00,2053.58,1215719.36,0.00,0.00,0.00),('1','146','767','253713',4838789,'2940','325',83272.69,83687.38,0.00,0.00,414.69,245496.48,0.00,0.00,0.00),('1','146','767','253888',4842094,'2138','325',1165767.83,1165824.93,0.00,0.00,57.10,33803.20,0.00,0.00,0.00),('1','146','767','253888',4842095,'2940','325',83687.38,83687.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','253943',4842999,'2138','325',1165824.93,1168443.14,0.00,0.00,2618.21,1549980.32,0.00,0.00,0.00),('1','146','767','253943',4843000,'2940','325',83687.38,83853.39,0.00,0.00,166.01,98277.92,0.00,0.00,0.00),('1','146','767','254198',4847414,'2138','325',1168443.14,1170558.45,0.00,0.00,2115.31,1252263.52,0.00,0.00,0.00),('1','146','767','254198',4847415,'2940','325',83853.39,84183.46,0.00,0.00,330.07,195401.44,0.00,0.00,0.00),('1','146','767','254433',4851541,'2138','325',1170558.45,1170622.19,0.00,0.00,63.74,37734.08,0.00,0.00,0.00),('1','146','767','254433',4851542,'2940','325',84183.46,84183.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','254488',4852152,'2138','325',1170622.19,1173133.28,0.00,0.00,2511.09,1486565.28,0.00,0.00,0.00),('1','146','767','254488',4852153,'2940','325',84183.46,84252.04,0.00,0.00,68.58,40599.36,0.00,0.00,0.00),('1','146','767','254708',4856195,'2138','325',1173133.28,1174834.18,0.00,0.00,1700.90,1006932.80,0.00,0.00,0.00),('1','146','767','254708',4856196,'2940','325',84252.04,84919.36,0.00,0.00,667.32,395053.44,0.00,0.00,0.00),('1','146','767','254929',4860152,'2138','325',1174834.18,1175300.49,0.00,0.00,466.31,276055.52,0.00,0.00,0.00),('1','146','767','254929',4860153,'2940','325',84919.36,84919.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','255041',4861867,'2138','325',1175300.49,1176910.99,0.00,0.00,1610.50,953416.00,0.00,0.00,0.00),('1','146','767','255041',4861868,'2940','325',84919.36,84932.03,0.00,0.00,12.67,7500.64,0.00,0.00,0.00),('1','146','767','255178',4864396,'2138','325',1176910.99,1179346.69,0.00,0.00,2435.70,1441934.40,0.00,0.00,0.00),('1','146','767','255178',4864397,'2940','325',84932.03,84981.36,0.00,0.00,49.33,29203.36,0.00,0.00,0.00),('1','146','767','255449',4869029,'2138','325',1179346.69,1180695.99,0.00,0.00,1349.30,798785.60,0.00,0.00,0.00),('1','146','767','255449',4869030,'2940','325',84981.36,85048.86,0.00,0.00,67.50,39960.00,0.00,0.00,0.00),('1','146','767','255594',4871156,'2138','325',1180695.99,1182046.82,0.00,0.00,1350.83,799691.36,0.00,0.00,0.00),('1','146','767','255594',4871157,'2940','325',85048.86,85079.95,0.00,0.00,31.09,18405.28,0.00,0.00,0.00),('1','146','767','255699',4873163,'2138','325',1182046.82,1185098.21,0.00,0.00,3051.39,1806422.88,0.00,0.00,0.00),('1','146','767','255699',4873164,'2940','325',85079.95,85414.08,0.00,0.00,334.13,197804.96,0.00,0.00,0.00),('1','146','767','255956',4877113,'2138','325',1185098.21,1185444.05,0.00,0.00,345.84,204737.28,0.00,0.00,0.00),('1','146','767','255956',4877114,'2940','325',85414.08,85466.79,0.00,0.00,52.71,31204.32,0.00,0.00,0.00),('1','146','767','256048',4878799,'2138','325',1185444.05,1186619.92,0.00,0.00,1175.87,696115.04,0.00,0.00,0.00),('1','146','767','256048',4878800,'2940','325',85466.79,86226.41,0.00,0.00,759.62,449695.04,0.00,0.00,0.00),('1','146','767','256207',4881215,'2138','325',1186619.92,1189160.06,0.00,0.00,2540.14,1503762.88,0.00,0.00,0.00),('1','146','767','256207',4881216,'2940','325',86226.41,86295.84,0.00,0.00,69.43,41102.56,0.00,0.00,0.00),('1','146','767','256479',4885957,'2138','325',1189160.06,1189488.28,0.00,0.00,328.22,194306.24,0.00,0.00,0.00),('1','146','767','256479',4885958,'2940','325',86295.84,86394.02,0.00,0.00,98.18,58122.56,0.00,0.00,0.00),('1','146','767','256583',4887650,'2138','325',1189488.28,1190772.59,0.00,0.00,1284.31,760311.52,0.00,0.00,0.00),('1','146','767','256583',4887651,'2940','325',86394.02,86841.52,0.00,0.00,447.50,264920.00,0.00,0.00,0.00),('1','146','767','256712',4889827,'2138','325',1190772.59,1193252.02,0.00,0.00,2479.43,1467822.56,0.00,0.00,0.00),('1','146','767','256712',4889828,'2940','325',86841.52,86878.51,0.00,0.00,36.99,21898.08,0.00,0.00,0.00),('1','146','767','256962',4894124,'2138','325',1193252.02,1194061.65,0.00,0.00,809.63,479300.96,0.00,0.00,0.00),('1','146','767','256962',4894125,'2940','325',86878.51,87210.65,0.00,0.00,332.14,196626.88,0.00,0.00,0.00),('1','146','767','257105',4896817,'2138','325',1194061.65,1195136.50,0.00,0.00,1074.85,636311.20,0.00,0.00,0.00),('1','146','767','257105',4896818,'2940','325',87210.65,87462.21,0.00,0.00,251.56,148923.52,0.00,0.00,0.00),('1','146','767','257223',4898990,'2138','325',1195136.50,1197929.79,0.00,0.00,2793.29,1653627.68,0.00,0.00,0.00),('1','146','767','257223',4898991,'2940','325',87462.21,87581.31,0.00,0.00,119.10,70507.20,0.00,0.00,0.00),('1','146','767','257494',4903581,'2138','325',1197929.79,1198589.52,0.00,0.00,659.73,374726.64,0.00,0.00,0.00),('1','146','767','257494',4903582,'2940','325',87581.31,87733.55,0.00,0.00,152.24,86472.32,0.00,0.00,0.00),('1','146','767','257587',4905089,'2138','325',1198589.52,1200504.90,0.00,0.00,1915.38,1087935.84,0.00,0.00,0.00),('1','146','767','257587',4905090,'2940','325',87733.55,87981.85,0.00,0.00,248.30,141034.40,0.00,0.00,0.00),('1','146','767','257588',4905091,'2138','325',1200504.90,1203325.99,0.00,0.00,2821.09,1602379.12,0.00,0.00,0.00),('1','146','767','257588',4905092,'2940','325',87981.85,88028.59,0.00,0.00,46.74,26548.32,0.00,0.00,0.00),('1','146','767','257589',4905093,'2138','325',1203325.99,1203724.48,0.00,0.00,398.49,226342.32,0.00,0.00,0.00),('1','146','767','257589',4905094,'2940','325',88028.59,88089.75,0.00,0.00,61.16,34738.88,0.00,0.00,0.00),('1','146','767','257590',4905095,'2138','325',1203724.48,1204803.37,0.00,0.00,1078.89,612809.52,0.00,0.00,0.00),('1','146','767','257590',4905096,'2940','325',88089.75,88955.57,0.00,0.00,865.82,491785.76,0.00,0.00,0.00),('1','146','767','257591',4905097,'2138','325',1204803.37,1207496.50,0.00,0.00,2693.13,1530129.84,0.00,0.00,0.00),('1','146','767','257591',4905098,'2940','325',88955.57,89053.80,0.00,0.00,98.23,55794.64,0.00,0.00,0.00),('1','146','767','257592',4905099,'2138','325',1207496.50,1207496.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257592',4905100,'2940','325',89053.80,89053.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257593',4905101,'2138','325',1207496.50,1210556.06,0.00,0.00,3059.56,1737830.08,0.00,0.00,0.00),('1','146','767','257593',4905102,'2940','325',89053.80,89136.46,0.00,0.00,82.66,46950.88,0.00,0.00,0.00),('1','146','767','257594',4905103,'2138','325',1210556.06,1212189.82,0.00,0.00,1633.76,927975.68,0.00,0.00,0.00),('1','146','767','257594',4905104,'2940','325',89136.46,89484.08,0.00,0.00,347.62,197448.16,0.00,0.00,0.00),('1','146','767','257595',4905105,'2138','325',1212189.82,1212801.95,0.00,0.00,612.13,347689.84,0.00,0.00,0.00),('1','146','767','257595',4905106,'2940','325',89484.08,89572.58,0.00,0.00,88.50,50268.00,0.00,0.00,0.00),('1','146','767','257596',4905107,'2138','325',1212801.95,1215633.91,0.00,0.00,2831.96,1608553.28,0.00,0.00,0.00),('1','146','767','257596',4905108,'2940','325',89572.58,90275.15,0.00,0.00,702.57,399059.76,0.00,0.00,0.00),('1','146','767','257597',4905109,'2138','325',1215633.91,1216356.31,0.00,0.00,722.40,410323.20,0.00,0.00,0.00),('1','146','767','257597',4905110,'2940','325',90275.15,90418.72,0.00,0.00,143.57,81547.76,0.00,0.00,0.00),('1','146','767','257598',4905111,'2138','325',1216356.31,1217898.07,0.00,0.00,1541.76,875719.68,0.00,0.00,0.00),('1','146','767','257598',4905112,'2940','325',90418.72,90806.93,0.00,0.00,388.21,220503.28,0.00,0.00,0.00),('1','146','767','257599',4905113,'2138','325',1217898.07,1220163.40,0.00,0.00,2265.33,1286707.44,0.00,0.00,0.00),('1','146','767','257599',4905114,'2940','325',90806.93,91417.30,0.00,0.00,610.37,346690.16,0.00,0.00,0.00),('1','146','767','257600',4905115,'2138','325',1220163.40,1220167.73,0.00,0.00,4.33,2459.44,0.00,0.00,0.00),('1','146','767','257600',4905116,'2940','325',91417.30,91506.36,0.00,0.00,89.06,50586.08,0.00,0.00,0.00),('1','146','767','257601',4905117,'2138','325',1220167.73,1222089.37,0.00,0.00,1921.64,1091491.52,0.00,0.00,0.00),('1','146','767','257601',4905118,'2940','325',91506.36,92561.19,0.00,0.00,1054.83,599143.44,0.00,0.00,0.00),('1','146','767','257602',4905119,'2138','325',1222089.37,1223991.31,0.00,0.00,1901.94,1080301.92,0.00,0.00,0.00),('1','146','767','257602',4905120,'2940','325',92561.19,93354.41,0.00,0.00,793.22,450548.96,0.00,0.00,0.00),('1','146','767','257603',4905121,'2138','325',1223991.31,1226424.24,0.00,0.00,2432.93,1381904.24,0.00,0.00,0.00),('1','146','767','257603',4905122,'2940','325',93354.41,94146.98,0.00,0.00,792.57,450179.76,0.00,0.00,0.00),('1','146','767','257604',4905123,'2138','325',1226424.24,1227888.51,0.00,0.00,1464.27,831705.36,0.00,0.00,0.00),('1','146','767','257604',4905124,'2940','325',94146.98,94505.42,0.00,0.00,358.44,203593.92,0.00,0.00,0.00),('1','146','767','257605',4905125,'2138','325',1227888.51,1228898.74,0.00,0.00,1010.23,573810.64,0.00,0.00,0.00),('1','146','767','257605',4905126,'2940','325',94505.42,94524.61,0.00,0.00,19.19,10899.92,0.00,0.00,0.00),('1','146','767','257606',4905127,'2138','325',1228898.74,1231663.56,0.00,0.00,2764.82,1570417.76,0.00,0.00,0.00),('1','146','767','257606',4905128,'2940','325',94524.61,94773.00,0.00,0.00,248.39,141085.52,0.00,0.00,0.00),('1','146','767','257607',4905129,'2138','325',1231663.56,1232739.13,0.00,0.00,1075.57,610923.76,0.00,0.00,0.00),('1','146','767','257607',4905130,'2940','325',94773.00,94850.02,0.00,0.00,77.02,43747.36,0.00,0.00,0.00),('1','146','767','257608',4905131,'2138','325',1232739.13,1233635.51,0.00,0.00,896.38,509143.84,0.00,0.00,0.00),('1','146','767','257608',4905132,'2940','325',94850.02,94861.78,0.00,0.00,11.76,6679.68,0.00,0.00,0.00),('1','146','767','257609',4905133,'2138','325',1233635.51,1235537.87,0.00,0.00,1902.36,1080540.48,0.00,0.00,0.00),('1','146','767','257609',4905134,'2940','325',94861.78,95520.44,0.00,0.00,658.66,374118.88,0.00,0.00,0.00),('1','146','767','257610',4905135,'2138','325',1235537.87,1235668.71,0.00,0.00,130.84,74317.12,0.00,0.00,0.00),('1','146','767','257610',4905136,'2940','325',95520.44,95611.40,0.00,0.00,90.96,51665.28,0.00,0.00,0.00),('1','146','767','257611',4905137,'2138','325',1235668.71,1237436.62,0.00,0.00,1767.91,1004172.88,0.00,0.00,0.00),('1','146','767','257611',4905138,'2940','325',95611.40,95702.93,0.00,0.00,91.53,51989.04,0.00,0.00,0.00),('1','146','767','257612',4905139,'2138','325',1237436.62,1239992.30,0.00,0.00,2555.68,1451626.24,0.00,0.00,0.00),('1','146','767','257612',4905140,'2940','325',95702.93,95888.14,0.00,0.00,185.21,105199.28,0.00,0.00,0.00),('1','146','767','257613',4905141,'2138','325',1239992.30,1240641.97,0.00,0.00,649.67,369012.56,0.00,0.00,0.00),('1','146','767','257613',4905142,'2940','325',95888.14,95951.46,0.00,0.00,63.32,35965.76,0.00,0.00,0.00),('1','146','767','257614',4905143,'2138','325',1240641.97,1242373.71,0.00,0.00,1731.74,983628.32,0.00,0.00,0.00),('1','146','767','257614',4905144,'2940','325',95951.46,96264.22,0.00,0.00,312.76,177647.68,0.00,0.00,0.00),('1','146','767','257615',4905145,'2138','325',1242373.71,1244471.79,0.00,0.00,2098.08,1191709.44,0.00,0.00,0.00),('1','146','767','257615',4905146,'2940','325',96264.22,96711.32,0.00,0.00,447.10,253952.80,0.00,0.00,0.00),('1','146','767','257616',4905147,'2138','325',1244471.79,1245350.23,0.00,0.00,878.44,498953.92,0.00,0.00,0.00),('1','146','767','257616',4905148,'2940','325',96711.32,96736.14,0.00,0.00,24.82,14097.76,0.00,0.00,0.00),('1','146','767','257617',4905149,'2138','325',1245350.23,1246516.73,0.00,0.00,1166.50,662572.00,0.00,0.00,0.00),('1','146','767','257617',4905150,'2940','325',96736.14,96810.43,0.00,0.00,74.29,42196.72,0.00,0.00,0.00),('1','146','767','257618',4905151,'2138','325',1246516.73,1248630.31,0.00,0.00,2113.58,1200513.44,0.00,0.00,0.00),('1','146','767','257618',4905152,'2940','325',96810.43,97519.85,0.00,0.00,709.42,402950.56,0.00,0.00,0.00),('1','146','767','257619',4905153,'2138','325',1248630.31,1249758.02,0.00,0.00,1127.71,640539.28,0.00,0.00,0.00),('1','146','767','257619',4905154,'2940','325',97519.85,97544.50,0.00,0.00,24.65,14001.20,0.00,0.00,0.00),('1','146','767','257620',4905155,'2138','325',1249758.02,1250935.53,0.00,0.00,1177.51,668825.68,0.00,0.00,0.00),('1','146','767','257620',4905156,'2940','325',97544.50,97681.29,0.00,0.00,136.79,77696.72,0.00,0.00,0.00),('1','146','767','257621',4905157,'2138','325',1250935.53,1252725.54,0.00,0.00,1790.01,1016725.68,0.00,0.00,0.00),('1','146','767','257621',4905158,'2940','325',97681.29,98528.29,0.00,0.00,847.00,481096.00,0.00,0.00,0.00),('1','146','767','257622',4905159,'2138','325',1252725.54,1253897.65,0.00,0.00,1172.11,665758.48,0.00,0.00,0.00),('1','146','767','257622',4905160,'2940','325',98528.29,98565.09,0.00,0.00,36.80,20902.40,0.00,0.00,0.00),('1','146','767','257623',4905161,'2138','325',1253897.65,1255172.19,0.00,0.00,1274.54,723938.72,0.00,0.00,0.00),('1','146','767','257623',4905162,'2940','325',98565.09,98651.36,0.00,0.00,86.27,49001.36,0.00,0.00,0.00),('1','146','767','257624',4905163,'2138','325',1255172.19,1256866.60,0.00,0.00,1694.41,962424.88,0.00,0.00,0.00),('1','146','767','257624',4905164,'2940','325',98651.36,99632.71,0.00,0.00,981.35,557406.80,0.00,0.00,0.00),('1','146','767','257625',4905165,'2138','325',1256866.60,1258006.16,0.00,0.00,1139.56,647270.08,0.00,0.00,0.00),('1','146','767','257625',4905166,'2940','325',99632.71,99736.74,0.00,0.00,104.03,59089.04,0.00,0.00,0.00),('1','146','767','257626',4905167,'2138','325',1258006.16,1259156.02,0.00,0.00,1149.86,653120.48,0.00,0.00,0.00),('1','146','767','257626',4905168,'2940','325',99736.74,99937.44,0.00,0.00,200.70,113997.60,0.00,0.00,0.00),('1','146','767','257627',4905169,'2138','325',1259156.02,1261213.83,0.00,0.00,2057.81,1168836.08,0.00,0.00,0.00),('1','146','767','257627',4905170,'2940','325',99937.44,100416.14,0.00,0.00,478.70,271901.60,0.00,0.00,0.00),('1','146','767','257628',4905171,'2138','325',1261213.83,1262636.55,0.00,0.00,1422.72,808104.96,0.00,0.00,0.00),('1','146','767','257628',4905172,'2940','325',100416.14,100508.03,0.00,0.00,91.89,52193.52,0.00,0.00,0.00),('1','146','767','257629',4905173,'2138','325',1262636.55,1262991.71,0.00,0.00,355.16,201730.88,0.00,0.00,0.00),('1','146','767','257629',4905174,'2940','325',100508.03,100542.71,0.00,0.00,34.68,19698.24,0.00,0.00,0.00),('1','146','767','257630',4905175,'2138','325',1262991.71,1265063.58,0.00,0.00,2071.87,1176822.16,0.00,0.00,0.00),('1','146','767','257630',4905176,'2940','325',100542.71,101407.67,0.00,0.00,864.96,491297.28,0.00,0.00,0.00),('1','146','767','257631',4905177,'2138','325',1265063.58,1267307.81,0.00,0.00,2244.23,1274722.64,0.00,0.00,0.00),('1','146','767','257631',4905178,'2940','325',101407.67,101806.88,0.00,0.00,399.21,226751.28,0.00,0.00,0.00),('1','146','767','257632',4905179,'2138','325',1267307.81,1267943.55,0.00,0.00,635.74,368729.20,0.00,0.00,0.00),('1','146','767','257632',4905180,'2940','325',101806.88,101911.62,0.00,0.00,104.74,60749.20,0.00,0.00,0.00),('1','146','767','257633',4905181,'2138','325',1267943.55,1269343.59,0.00,0.00,1400.04,812023.20,0.00,0.00,0.00),('1','146','767','257633',4905182,'2940','325',101911.62,102636.99,0.00,0.00,725.37,420714.60,0.00,0.00,0.00),('1','146','767','257634',4905183,'2138','325',1269343.59,1272055.35,0.00,0.00,2711.76,1572820.80,0.00,0.00,0.00),('1','146','767','257634',4905184,'2940','325',102636.99,102749.23,0.00,0.00,112.24,65099.20,0.00,0.00,0.00),('1','146','767','257635',4905185,'2138','325',1272055.35,1272416.96,0.00,0.00,361.61,209733.80,0.00,0.00,0.00),('1','146','767','257635',4905186,'2940','325',102749.23,102755.26,0.00,0.00,6.03,3497.40,0.00,0.00,0.00),('1','146','767','257636',4905187,'2138','325',1272416.96,1274279.17,0.00,0.00,1862.21,1080081.80,0.00,0.00,0.00),('1','146','767','257636',4905188,'2940','325',102755.26,103431.55,0.00,0.00,676.29,392248.20,0.00,0.00,0.00),('1','146','767','257637',4905189,'2138','325',1274279.17,1276615.47,0.00,0.00,2336.30,1355054.00,0.00,0.00,0.00),('1','146','767','257637',4905190,'2940','325',103431.55,103575.68,0.00,0.00,144.13,83595.40,0.00,0.00,0.00),('1','146','767','257638',4905191,'2138','325',1276615.47,1279585.84,0.00,0.00,2970.37,1722814.60,0.00,0.00,0.00),('1','146','767','257638',4905192,'2940','325',103575.68,104570.29,0.00,0.00,994.61,576873.80,0.00,0.00,0.00),('1','146','767','257639',4905193,'2138','325',1279585.84,1281140.25,0.00,0.00,1554.41,901557.80,0.00,0.00,0.00),('1','146','767','257639',4905194,'2940','325',104570.29,104620.20,0.00,0.00,49.91,28947.80,0.00,0.00,0.00),('1','146','767','257640',4905195,'2138','325',1281140.25,1282513.91,0.00,0.00,1373.66,796722.80,0.00,0.00,0.00),('1','146','767','257640',4905196,'2940','325',104620.20,104651.23,0.00,0.00,31.03,17997.40,0.00,0.00,0.00),('1','146','767','257641',4905197,'2138','325',1282513.91,1284274.10,0.00,0.00,1760.19,1126521.60,0.00,0.00,0.00),('1','146','767','257641',4905198,'2940','325',104651.23,105345.84,0.00,0.00,694.61,444550.40,0.00,0.00,0.00),('1','146','767','257642',4905199,'2138','325',1284274.10,1285004.83,0.00,0.00,730.73,467667.20,0.00,0.00,0.00),('1','146','767','257642',4905200,'2940','325',105345.84,105349.75,0.00,0.00,3.91,2502.40,0.00,0.00,0.00),('1','146','767','257643',4905201,'2138','325',1285004.83,1286734.15,0.00,0.00,1729.32,1106764.80,0.00,0.00,0.00),('1','146','767','257643',4905202,'2940','325',105349.75,105445.78,0.00,0.00,96.03,61459.20,0.00,0.00,0.00),('1','146','767','257644',4905203,'2138','325',1286734.15,1289181.08,0.00,0.00,2446.93,1566035.20,0.00,0.00,0.00),('1','146','767','257644',4905204,'2940','325',105445.78,105635.16,0.00,0.00,189.38,121203.20,0.00,0.00,0.00),('1','146','767','257645',4905205,'2138','325',1289181.08,1290957.19,0.00,0.00,1776.11,1136710.40,0.00,0.00,0.00),('1','146','767','257645',4905206,'2940','325',105635.16,105668.91,0.00,0.00,33.75,21600.00,0.00,0.00,0.00),('1','146','767','257646',4905207,'2138','325',1290957.19,1291441.13,0.00,0.00,483.94,309721.60,0.00,0.00,0.00),('1','146','767','257646',4905208,'2940','325',105668.91,105681.42,0.00,0.00,12.51,8006.40,0.00,0.00,0.00),('1','146','767','257647',4905209,'2138','325',1291441.13,1294408.46,0.00,0.00,2967.33,1899091.20,0.00,0.00,0.00),('1','146','767','257647',4905210,'2940','325',105681.42,105993.15,0.00,0.00,311.73,199507.20,0.00,0.00,0.00),('1','146','767','257648',4905211,'2138','325',1294408.46,1295750.13,0.00,0.00,1341.67,858668.80,0.00,0.00,0.00),('1','146','767','257648',4905212,'2940','325',105993.15,106262.77,0.00,0.00,269.62,172556.80,0.00,0.00,0.00),('1','146','767','257649',4905213,'2138','325',1295750.13,1296460.27,0.00,0.00,710.14,454489.60,0.00,0.00,0.00),('1','146','767','257649',4905214,'2940','325',106262.77,106309.65,0.00,0.00,46.88,30003.20,0.00,0.00,0.00),('1','146','767','257650',4905215,'2138','325',1296460.27,1298880.63,0.00,0.00,2420.36,1645844.80,0.00,0.00,0.00),('1','146','767','257650',4905216,'2940','325',106309.65,106512.14,0.00,0.00,202.49,137693.20,0.00,0.00,0.00),('1','146','767','257651',4905217,'2138','325',1298880.63,1300332.48,0.00,0.00,1451.85,987258.00,0.00,0.00,0.00),('1','146','767','257651',4905218,'2940','325',106512.14,106625.38,0.00,0.00,113.24,77003.20,0.00,0.00,0.00),('1','146','767','257652',4905219,'2138','325',1300332.48,1300454.97,0.00,0.00,122.49,83293.20,0.00,0.00,0.00),('1','146','767','257652',4905220,'2940','325',106625.38,106650.38,0.00,0.00,25.00,17000.00,0.00,0.00,0.00),('1','146','767','257653',4905221,'2138','325',1300454.97,1302689.39,0.00,0.00,2234.42,1519405.60,0.00,0.00,0.00),('1','146','767','257653',4905222,'2940','325',106650.38,106837.79,0.00,0.00,187.41,127438.80,0.00,0.00,0.00),('1','146','767','257654',4905223,'2138','325',1302689.39,1304755.95,0.00,0.00,2066.56,1405260.80,0.00,0.00,0.00),('1','146','767','257654',4905224,'2940','325',106837.79,107105.95,0.00,0.00,268.16,182348.80,0.00,0.00,0.00),('1','146','767','257655',4905225,'2138','325',1304755.95,1305597.65,0.00,0.00,841.70,572356.00,0.00,0.00,0.00),('1','146','767','257655',4905226,'2940','325',107105.95,107105.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257656',4905227,'2138','325',1305597.65,1306809.13,0.00,0.00,1211.48,823806.40,0.00,0.00,0.00),('1','146','767','257656',4905228,'2940','325',107105.95,107541.25,0.00,0.00,435.30,296004.00,0.00,0.00,0.00),('1','146','767','257657',4905229,'2138','325',1306809.13,1308711.66,0.00,0.00,1902.53,1293720.40,0.00,0.00,0.00),('1','146','767','257657',4905230,'2940','325',107541.25,107966.26,0.00,0.00,425.01,289006.80,0.00,0.00,0.00),('1','146','767','257658',4905231,'2138','325',1308711.66,1310570.58,0.00,0.00,1858.92,1264065.60,0.00,0.00,0.00),('1','146','767','257658',4905232,'2940','325',107966.26,108051.55,0.00,0.00,85.29,57997.20,0.00,0.00,0.00),('1','146','767','257659',4905233,'2138','325',1310570.58,1310570.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257659',4905234,'2940','325',108051.55,108051.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257660',4905235,'2138','325',1310570.58,1312450.37,0.00,0.00,1879.79,1278257.20,0.00,0.00,0.00),('1','146','767','257660',4905236,'2940','325',108051.55,108897.87,0.00,0.00,846.32,575497.60,0.00,0.00,0.00),('1','146','767','257661',4905237,'2138','325',1312450.37,1314248.31,0.00,0.00,1797.94,1222599.20,0.00,0.00,0.00),('1','146','767','257661',4905238,'2940','325',108897.87,108992.50,0.00,0.00,94.63,64348.40,0.00,0.00,0.00),('1','146','767','257662',4905239,'2138','325',1314248.31,1314656.10,0.00,0.00,407.79,277297.20,0.00,0.00,0.00),('1','146','767','257662',4905240,'2940','325',108992.50,108992.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257663',4905241,'2138','325',1314656.10,1316092.19,0.00,0.00,1436.09,976541.20,0.00,0.00,0.00),('1','146','767','257663',4905242,'2940','325',108992.50,109216.02,0.00,0.00,223.52,151993.60,0.00,0.00,0.00),('1','146','767','257664',4905243,'2138','325',1316092.19,1318151.89,0.00,0.00,2059.70,1400596.00,0.00,0.00,0.00),('1','146','767','257664',4905244,'2940','325',109216.02,109781.02,0.00,0.00,565.00,384200.00,0.00,0.00,0.00),('1','146','767','257665',4905245,'2138','325',1318151.89,1319005.78,0.00,0.00,853.89,580645.20,0.00,0.00,0.00),('1','146','767','257665',4905246,'2940','325',109781.02,109906.02,0.00,0.00,125.00,85000.00,0.00,0.00,0.00),('1','146','767','257666',4905247,'2138','325',1319005.78,1319005.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257666',4905248,'2940','325',109906.02,109906.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257667',4905249,'2138','325',1319005.78,1320004.64,0.00,0.00,998.86,679224.80,0.00,0.00,0.00),('1','146','767','257667',4905250,'2940','325',109906.02,110142.79,0.00,0.00,236.77,161003.60,0.00,0.00,0.00),('1','146','767','257668',4905251,'2138','325',1320004.64,1320594.17,0.00,0.00,589.53,400880.40,0.00,0.00,0.00),('1','146','767','257668',4905252,'2940','325',110142.79,110157.50,0.00,0.00,14.71,10002.80,0.00,0.00,0.00),('1','146','767','257669',4905253,'2138','325',1320594.17,1322395.58,0.00,0.00,1801.41,1239370.08,0.00,0.00,0.00),('1','146','767','257669',4905254,'2940','325',110157.50,110298.63,0.00,0.00,141.13,97097.44,0.00,0.00,0.00),('1','146','767','257670',4905255,'2138','325',1322395.58,1323225.86,0.00,0.00,830.28,571232.64,0.00,0.00,0.00),('1','146','767','257670',4905256,'2940','325',110298.63,110843.81,0.00,0.00,545.18,375083.84,0.00,0.00,0.00),('1','146','767','257671',4905257,'2138','325',1323225.86,1324122.72,0.00,0.00,896.86,617039.68,0.00,0.00,0.00),('1','146','767','257671',4905258,'2940','325',110843.81,110911.71,0.00,0.00,67.90,46715.20,0.00,0.00,0.00),('1','146','767','257672',4905259,'2138','325',1324122.72,1327283.00,0.00,0.00,3160.28,2174272.64,0.00,0.00,0.00),('1','146','767','257672',4905260,'2940','325',110911.71,111150.22,0.00,0.00,238.51,164094.88,0.00,0.00,0.00),('1','146','767','257673',4905261,'2138','325',1327283.00,1328064.28,0.00,0.00,781.28,537520.64,0.00,0.00,0.00),('1','146','767','257673',4905262,'2940','325',111150.22,111162.94,0.00,0.00,12.72,8751.36,0.00,0.00,0.00),('1','146','767','257674',4905263,'2138','325',1328064.28,1329692.43,0.00,0.00,1628.15,1120167.20,0.00,0.00,0.00),('1','146','767','257674',4905264,'2940','325',111162.94,111267.00,0.00,0.00,104.06,71593.28,0.00,0.00,0.00),('1','146','767','257675',4905265,'2138','325',1329692.43,1332110.26,0.00,0.00,2417.83,1605439.12,0.00,0.00,0.00),('1','146','767','257675',4905266,'2940','325',111267.00,112032.51,0.00,0.00,765.51,508298.64,0.00,0.00,0.00),('1','146','767','257676',4905267,'2138','325',1332110.26,1332994.15,0.00,0.00,883.89,586902.96,0.00,0.00,0.00),('1','146','767','257676',4905268,'2940','325',112032.51,112456.45,0.00,0.00,423.94,281496.16,0.00,0.00,0.00),('1','146','767','257677',4905269,'2138','325',1332994.15,1334152.11,0.00,0.00,1157.96,768885.44,0.00,0.00,0.00),('1','146','767','257677',4905270,'2940','325',112456.45,113183.17,0.00,0.00,726.72,482542.08,0.00,0.00,0.00),('1','146','767','257678',4905271,'2138','325',1334152.11,1337202.86,0.00,0.00,3050.75,2025698.00,0.00,0.00,0.00),('1','146','767','257678',4905272,'2940','325',113183.17,113609.95,0.00,0.00,426.78,283381.92,0.00,0.00,0.00),('1','146','767','257679',4905273,'2138','325',1337202.86,1340294.09,0.00,0.00,3091.23,2052576.72,0.00,0.00,0.00),('1','146','767','257679',4905274,'2940','325',113609.95,114199.40,0.00,0.00,589.45,391394.80,0.00,0.00,0.00),('1','146','767','257680',4905275,'2138','325',1340294.09,1341697.03,0.00,0.00,1402.94,931552.16,0.00,0.00,0.00),('1','146','767','257680',4905276,'2940','325',114199.40,114325.18,0.00,0.00,125.78,83517.92,0.00,0.00,0.00),('1','146','767','257681',4905277,'2138','325',1341697.03,1341697.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257681',4905278,'2940','325',114325.18,114325.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257682',4905279,'2138','325',1341697.03,1342765.70,0.00,0.00,1068.67,709596.88,0.00,0.00,0.00),('1','146','767','257682',4905280,'2940','325',114325.18,114355.74,0.00,0.00,30.56,20291.84,0.00,0.00,0.00),('1','146','767','257683',4905281,'2138','325',1342765.70,1345687.17,0.00,0.00,2921.47,1939856.08,0.00,0.00,0.00),('1','146','767','257683',4905282,'2940','325',114355.74,114515.82,0.00,0.00,160.08,106293.12,0.00,0.00,0.00),('1','146','767','257684',4905283,'2138','325',1345687.17,1346499.93,0.00,0.00,812.76,539672.64,0.00,0.00,0.00),('1','146','767','257684',4905284,'2940','325',114515.82,114661.00,0.00,0.00,145.18,96399.52,0.00,0.00,0.00),('1','146','767','257685',4905285,'2138','325',1346499.93,1347418.16,0.00,0.00,918.23,609704.72,0.00,0.00,0.00),('1','146','767','257685',4905286,'2940','325',114661.00,115290.07,0.00,0.00,629.07,417702.48,0.00,0.00,0.00),('1','146','767','257686',4905287,'2138','325',1347418.16,1350068.38,0.00,0.00,2650.22,1759746.08,0.00,0.00,0.00),('1','146','767','257686',4905288,'2940','325',115290.07,115716.16,0.00,0.00,426.09,282923.76,0.00,0.00,0.00),('1','146','767','257687',4905289,'2138','325',1350068.38,1350496.94,0.00,0.00,428.56,284563.84,0.00,0.00,0.00),('1','146','767','257687',4905290,'2940','325',115716.16,115766.16,0.00,0.00,50.00,33200.00,0.00,0.00,0.00),('1','146','767','257688',4905291,'2138','325',1350496.94,1352055.11,0.00,0.00,1558.17,1034624.88,0.00,0.00,0.00),('1','146','767','257688',4905292,'2940','325',115766.16,116617.36,0.00,0.00,851.20,565196.80,0.00,0.00,0.00),('1','146','767','257689',4905293,'2138','325',1352055.11,1354458.39,0.00,0.00,2403.28,1595777.92,0.00,0.00,0.00),('1','146','767','257689',4905294,'2940','325',116617.36,116791.01,0.00,0.00,173.65,115303.60,0.00,0.00,0.00),('1','146','767','257690',4905295,'2138','325',1354458.39,1354614.57,0.00,0.00,156.18,103703.52,0.00,0.00,0.00),('1','146','767','257690',4905296,'2940','325',116791.01,116800.04,0.00,0.00,9.03,5995.92,0.00,0.00,0.00),('1','146','767','257691',4905297,'2138','325',1354614.57,1357090.66,0.00,0.00,2476.09,1644123.76,0.00,0.00,0.00),('1','146','767','257691',4905298,'2940','325',116800.04,117487.09,0.00,0.00,687.05,456201.20,0.00,0.00,0.00),('1','146','767','257692',4905299,'2138','325',1357090.66,1359006.30,0.00,0.00,1915.64,1271984.96,0.00,0.00,0.00),('1','146','767','257692',4905300,'2940','325',117487.09,117533.66,0.00,0.00,46.57,30922.48,0.00,0.00,0.00),('1','146','767','257693',4905301,'2138','325',1359006.30,1361302.59,0.00,0.00,2296.29,1524736.56,0.00,0.00,0.00),('1','146','767','257693',4905302,'2940','325',117533.66,118182.87,0.00,0.00,649.21,431075.44,0.00,0.00,0.00),('1','146','767','257694',4905303,'2138','325',1361302.59,1363200.60,0.00,0.00,1898.01,1260278.64,0.00,0.00,0.00),('1','146','767','257694',4905304,'2940','325',118182.87,118299.58,0.00,0.00,116.71,77495.44,0.00,0.00,0.00),('1','146','767','257695',4905305,'2138','325',1363200.60,1364057.67,0.00,0.00,857.07,569094.48,0.00,0.00,0.00),('1','146','767','257695',4905306,'2940','325',118299.58,118373.38,0.00,0.00,73.80,49003.20,0.00,0.00,0.00),('1','146','767','257696',4905307,'2138','325',1364057.67,1366535.91,0.00,0.00,2478.24,1645551.36,0.00,0.00,0.00),('1','146','767','257696',4905308,'2940','325',118373.38,118973.30,0.00,0.00,599.92,398346.88,0.00,0.00,0.00),('1','146','767','257697',4905309,'2138','325',1366535.91,1367331.67,0.00,0.00,795.76,528384.64,0.00,0.00,0.00),('1','146','767','257697',4905310,'2940','325',118973.30,119282.91,0.00,0.00,309.61,205581.04,0.00,0.00,0.00),('1','146','767','257698',4905311,'2138','325',1367331.67,1367850.91,0.00,0.00,519.24,344775.36,0.00,0.00,0.00),('1','146','767','257698',4905312,'2940','325',119282.91,119282.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257699',4905313,'2138','325',1367850.91,1370887.27,0.00,0.00,3036.36,2016143.04,0.00,0.00,0.00),('1','146','767','257699',4905314,'2940','325',119282.91,119401.06,0.00,0.00,118.15,78451.60,0.00,0.00,0.00),('1','146','767','257700',4905315,'2138','325',1370887.27,1372206.07,0.00,0.00,1318.80,875683.20,0.00,0.00,0.00),('1','146','767','257700',4905316,'2940','325',119401.06,119521.52,0.00,0.00,120.46,79985.44,0.00,0.00,0.00),('1','146','767','257701',4905317,'2138','325',1372206.07,1373181.99,0.00,0.00,975.92,648010.88,0.00,0.00,0.00),('1','146','767','257701',4905318,'2940','325',119521.52,119614.29,0.00,0.00,92.77,61599.28,0.00,0.00,0.00),('1','146','767','257702',4905319,'2138','325',1373181.99,1374721.45,0.00,0.00,1539.46,1022201.44,0.00,0.00,0.00),('1','146','767','257702',4905320,'2940','325',119614.29,120565.72,0.00,0.00,951.43,631749.52,0.00,0.00,0.00),('1','146','767','257703',4905321,'2138','325',1374721.45,1375941.86,0.00,0.00,1220.41,810352.24,0.00,0.00,0.00),('1','146','767','257703',4905322,'2940','325',120565.72,120657.58,0.00,0.00,91.86,60995.04,0.00,0.00,0.00),('1','146','767','257704',4905323,'2138','325',1375941.86,1377985.56,0.00,0.00,2043.70,1357016.80,0.00,0.00,0.00),('1','146','767','257704',4905324,'2940','325',120657.58,121817.48,0.00,0.00,1159.90,770173.60,0.00,0.00,0.00),('1','146','767','257705',4905325,'2138','325',1377985.56,1379079.74,0.00,0.00,1094.18,726535.52,0.00,0.00,0.00),('1','146','767','257705',4905326,'2940','325',121817.48,121858.60,0.00,0.00,41.12,27303.68,0.00,0.00,0.00),('1','146','767','257706',4905327,'2138','325',1379079.74,1380546.58,0.00,0.00,1466.84,973981.76,0.00,0.00,0.00),('1','146','767','257706',4905328,'2940','325',121858.60,122109.64,0.00,0.00,251.04,166690.56,0.00,0.00,0.00),('1','146','767','257707',4905329,'2138','325',1380546.58,1382445.14,0.00,0.00,1898.56,1260643.84,0.00,0.00,0.00),('1','146','767','257707',4905330,'2940','325',122109.64,122650.44,0.00,0.00,540.80,359091.20,0.00,0.00,0.00),('1','146','767','257708',4905331,'2138','325',1382445.14,1383220.09,0.00,0.00,774.95,514566.80,0.00,0.00,0.00),('1','146','767','257708',4905332,'2940','325',122650.44,122692.00,0.00,0.00,41.56,27595.84,0.00,0.00,0.00),('1','146','767','257709',4905333,'2138','325',1383220.09,1384259.55,0.00,0.00,1039.46,690201.44,0.00,0.00,0.00),('1','146','767','257709',4905334,'2940','325',122692.00,123147.34,0.00,0.00,455.34,302345.76,0.00,0.00,0.00),('1','146','767','257710',4905335,'2138','325',1384259.55,1386262.26,0.00,0.00,2002.71,1329799.44,0.00,0.00,0.00),('1','146','767','257710',4905336,'2940','325',123147.34,123461.19,0.00,0.00,313.85,208396.40,0.00,0.00,0.00),('1','146','767','257711',4905337,'2138','325',1386262.26,1387938.39,0.00,0.00,1676.13,1112950.32,0.00,0.00,0.00),('1','146','767','257711',4905338,'2940','325',123461.19,123526.19,0.00,0.00,65.00,43160.00,0.00,0.00,0.00),('1','146','767','257712',4905339,'2138','325',1387938.39,1388435.49,0.00,0.00,497.10,330074.40,0.00,0.00,0.00),('1','146','767','257712',4905340,'2940','325',123526.19,123576.05,0.00,0.00,49.86,33107.04,0.00,0.00,0.00),('1','146','767','257713',4905341,'2138','325',1388435.49,1390771.94,0.00,0.00,2336.45,1551402.80,0.00,0.00,0.00),('1','146','767','257713',4905342,'2940','325',123576.05,124061.45,0.00,0.00,485.40,322305.60,0.00,0.00,0.00),('1','146','767','257714',4905343,'2138','325',1390771.94,1392272.64,0.00,0.00,1500.70,996464.80,0.00,0.00,0.00),('1','146','767','257714',4905344,'2940','325',124061.45,124211.94,0.00,0.00,150.49,99925.36,0.00,0.00,0.00),('1','146','767','257715',4905345,'2138','325',1392272.64,1392923.84,0.00,0.00,651.20,432396.80,0.00,0.00,0.00),('1','146','767','257715',4905346,'2940','325',124211.94,124309.31,0.00,0.00,97.37,64653.68,0.00,0.00,0.00),('1','146','767','257716',4905347,'2138','325',1392923.84,1395903.47,0.00,0.00,2979.63,1978474.32,0.00,0.00,0.00),('1','146','767','257716',4905348,'2940','325',124309.31,124661.47,0.00,0.00,352.16,233834.24,0.00,0.00,0.00),('1','146','767','257717',4905349,'2138','325',1395903.47,1396616.32,0.00,0.00,712.85,473332.40,0.00,0.00,0.00),('1','146','767','257717',4905350,'2940','325',124661.47,125029.85,0.00,0.00,368.38,244604.32,0.00,0.00,0.00),('1','146','767','257718',4905351,'2138','325',1396616.32,1397481.03,0.00,0.00,864.71,574167.44,0.00,0.00,0.00),('1','146','767','257718',4905352,'2940','325',125029.85,125378.18,0.00,0.00,348.33,231291.12,0.00,0.00,0.00),('1','146','767','257719',4905353,'2138','325',1397481.03,1400827.32,0.00,0.00,3346.29,2221936.56,0.00,0.00,0.00),('1','146','767','257719',4905354,'2940','325',125378.18,125769.90,0.00,0.00,391.72,260102.08,0.00,0.00,0.00),('1','146','767','257720',4905355,'2138','325',1400827.32,1400827.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257720',4905356,'2940','325',125769.90,125769.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257721',4905357,'2138','325',1400827.32,1403255.22,0.00,0.00,2427.90,1612125.60,0.00,0.00,0.00),('1','146','767','257721',4905358,'2940','325',125769.90,126135.55,0.00,0.00,365.65,242791.60,0.00,0.00,0.00),('1','146','767','257722',4905359,'2138','325',1403255.22,1405035.92,0.00,0.00,1780.70,1182384.80,0.00,0.00,0.00),('1','146','767','257722',4905360,'2940','325',126135.55,126437.20,0.00,0.00,301.65,200295.60,0.00,0.00,0.00),('1','146','767','257723',4905361,'2138','325',1405035.92,1405035.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257723',4905362,'2940','325',126437.20,126437.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257724',4905363,'2138','325',1405035.92,1406778.58,0.00,0.00,1742.66,1157126.24,0.00,0.00,0.00),('1','146','767','257724',4905364,'2940','325',126437.20,126654.96,0.00,0.00,217.76,144592.64,0.00,0.00,0.00),('1','146','767','257725',4905365,'2138','325',1406778.58,1408896.04,0.00,0.00,2117.46,1405993.44,0.00,0.00,0.00),('1','146','767','257725',4905366,'2940','325',126654.96,127193.52,0.00,0.00,538.56,357603.84,0.00,0.00,0.00),('1','146','767','257726',4905367,'2138','325',1408896.04,1409426.24,0.00,0.00,530.20,352052.80,0.00,0.00,0.00),('1','146','767','257726',4905368,'2940','325',127193.52,127310.71,0.00,0.00,117.19,77814.16,0.00,0.00,0.00),('1','146','767','257727',4905369,'2138','325',1409426.24,1409426.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257727',4905370,'2940','325',127310.71,127310.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257728',4905371,'2138','325',1409426.24,1409898.12,0.00,0.00,471.88,313328.32,0.00,0.00,0.00),('1','146','767','257728',4905372,'2940','325',127310.71,128427.49,0.00,0.00,1116.78,741541.92,0.00,0.00,0.00),('1','146','767','257729',4905373,'2138','325',1409898.12,1412629.68,0.00,0.00,2731.56,1813755.84,0.00,0.00,0.00),('1','146','767','257729',4905374,'2940','325',128427.49,128989.27,0.00,0.00,561.78,373021.92,0.00,0.00,0.00),('1','146','767','257730',4905375,'2138','325',1412629.68,1412786.66,0.00,0.00,156.98,104234.72,0.00,0.00,0.00),('1','146','767','257730',4905376,'2940','325',128989.27,128989.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257731',4905377,'2138','325',1412786.66,1412786.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257731',4905378,'2940','325',128989.27,128989.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257732',4905379,'2138','325',1412786.66,1415002.37,0.00,0.00,2215.71,1471231.44,0.00,0.00,0.00),('1','146','767','257732',4905380,'2940','325',128989.27,129603.58,0.00,0.00,614.31,407901.84,0.00,0.00,0.00),('1','146','767','257733',4905381,'2138','325',1415002.37,1416959.12,0.00,0.00,1956.75,1299282.00,0.00,0.00,0.00),('1','146','767','257733',4905382,'2940','325',129603.58,129789.66,0.00,0.00,186.08,123557.12,0.00,0.00,0.00),('1','146','767','257734',4905383,'2138','325',1416959.12,1417058.59,0.00,0.00,99.47,66048.08,0.00,0.00,0.00),('1','146','767','257734',4905384,'2940','325',129789.66,129789.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257735',4905385,'2138','325',1417058.59,1417058.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257735',4905386,'2940','325',129789.66,129789.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257736',4905387,'2138','325',1417058.59,1418572.82,0.00,0.00,1514.23,1005448.72,0.00,0.00,0.00),('1','146','767','257736',4905388,'2940','325',129789.66,130230.77,0.00,0.00,441.11,292897.04,0.00,0.00,0.00),('1','146','767','257737',4905389,'2138','325',1418572.82,1419911.74,0.00,0.00,1338.92,889042.88,0.00,0.00,0.00),('1','146','767','257737',4905390,'2940','325',130230.77,130351.19,0.00,0.00,120.42,79958.88,0.00,0.00,0.00),('1','146','767','257738',4905391,'2138','325',1419911.74,1419911.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257738',4905392,'2940','325',130351.19,130351.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257739',4905393,'2138','325',1419911.74,1422542.92,0.00,0.00,2631.18,1747103.52,0.00,0.00,0.00),('1','146','767','257739',4905394,'2940','325',130351.19,131611.49,0.00,0.00,1260.30,836839.20,0.00,0.00,0.00),('1','146','767','257740',4905395,'2138','325',1422542.92,1422741.00,0.00,0.00,198.08,131525.12,0.00,0.00,0.00),('1','146','767','257740',4905396,'2940','325',131611.49,131733.49,0.00,0.00,122.00,81008.00,0.00,0.00,0.00),('1','146','767','257741',4905397,'2138','325',1422741.00,1424392.50,0.00,0.00,1651.50,1096596.00,0.00,0.00,0.00),('1','146','767','257741',4905398,'2940','325',131733.49,132178.40,0.00,0.00,444.91,295420.24,0.00,0.00,0.00),('1','146','767','257742',4905399,'2138','325',1424392.50,1426835.08,0.00,0.00,2442.58,1621873.12,0.00,0.00,0.00),('1','146','767','257742',4905400,'2940','325',132178.40,132542.54,0.00,0.00,364.14,241788.96,0.00,0.00,0.00),('1','146','767','257743',4905401,'2138','325',1426835.08,1426835.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257743',4905402,'2940','325',132542.54,132542.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257744',4905403,'2138','325',1426835.08,1429706.99,0.00,0.00,2871.91,1952898.80,0.00,0.00,0.00),('1','146','767','257744',4905404,'2940','325',132542.54,133020.16,0.00,0.00,477.62,324781.60,0.00,0.00,0.00),('1','146','767','257745',4905405,'2138','325',1429706.99,1431353.01,0.00,0.00,1646.02,1119293.60,0.00,0.00,0.00),('1','146','767','257745',4905406,'2940','325',133020.16,133257.66,0.00,0.00,237.50,161500.00,0.00,0.00,0.00),('1','146','767','257746',4905407,'2138','325',1431353.01,1433578.22,0.00,0.00,2225.21,1513142.80,0.00,0.00,0.00),('1','146','767','257746',4905408,'2940','325',133257.66,133805.31,0.00,0.00,547.65,372402.00,0.00,0.00,0.00),('1','146','767','257747',4905409,'2138','325',1433578.22,1434625.92,0.00,0.00,1047.70,712436.00,0.00,0.00,0.00),('1','146','767','257747',4905410,'2940','325',133805.31,134181.49,0.00,0.00,376.18,255802.40,0.00,0.00,0.00),('1','146','767','257748',4905411,'2138','325',1434625.92,1435034.29,0.00,0.00,408.37,277691.60,0.00,0.00,0.00),('1','146','767','257748',4905412,'2940','325',134181.49,134181.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257749',4905413,'2138','325',1435034.29,1436937.24,0.00,0.00,1902.95,1294006.00,0.00,0.00,0.00),('1','146','767','257749',4905414,'2940','325',134181.49,134915.32,0.00,0.00,733.83,499004.40,0.00,0.00,0.00),('1','146','767','257750',4905415,'2138','325',1436937.24,1437824.74,0.00,0.00,887.50,603500.00,0.00,0.00,0.00),('1','146','767','257750',4905416,'2940','325',134915.32,135060.69,0.00,0.00,145.37,98851.60,0.00,0.00,0.00),('1','146','767','257751',4905417,'2138','325',1437824.74,1440543.35,0.00,0.00,2718.61,1848654.80,0.00,0.00,0.00),('1','146','767','257751',4905418,'2940','325',135060.69,135863.57,0.00,0.00,802.88,545958.40,0.00,0.00,0.00),('1','146','767','257752',4905419,'2138','325',1440543.35,1441407.23,0.00,0.00,863.88,587438.40,0.00,0.00,0.00),('1','146','767','257752',4905420,'2940','325',135863.57,135978.57,0.00,0.00,115.00,78200.00,0.00,0.00,0.00),('1','146','767','257753',4905421,'2138','325',1441407.23,1442524.00,0.00,0.00,1116.77,759403.60,0.00,0.00,0.00),('1','146','767','257753',4905422,'2940','325',135978.57,136094.31,0.00,0.00,115.74,78703.20,0.00,0.00,0.00),('1','146','767','257754',4905423,'2138','325',1442524.00,1444702.55,0.00,0.00,2178.55,1481414.00,0.00,0.00,0.00),('1','146','767','257754',4905424,'2940','325',136094.31,137219.55,0.00,0.00,1125.24,765163.20,0.00,0.00,0.00),('1','146','767','257755',4905425,'2138','325',1444702.55,1446310.01,0.00,0.00,1607.46,1093072.80,0.00,0.00,0.00),('1','146','767','257755',4905426,'2940','325',137219.55,137325.05,0.00,0.00,105.50,71740.00,0.00,0.00,0.00),('1','146','767','257756',4905427,'2138','325',1446310.01,1446310.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257756',4905428,'2940','325',137325.05,137325.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257757',4905429,'2138','325',1446310.01,1446979.97,0.00,0.00,669.96,455572.80,0.00,0.00,0.00),('1','146','767','257757',4905430,'2940','325',137325.05,137350.26,0.00,0.00,25.21,17142.80,0.00,0.00,0.00),('1','146','767','257758',4905431,'2138','325',1446979.97,1447948.17,0.00,0.00,968.20,658376.00,0.00,0.00,0.00),('1','146','767','257758',4905432,'2940','325',137350.26,137468.79,0.00,0.00,118.53,80600.40,0.00,0.00,0.00),('1','146','767','257759',4905433,'2138','325',1447948.17,1448668.65,0.00,0.00,720.48,518745.60,0.00,0.00,0.00),('1','146','767','257759',4905434,'2940','325',137468.79,137527.77,0.00,0.00,58.98,42465.60,0.00,0.00,0.00),('1','146','767','257760',4905435,'2138','325',1448668.65,1448668.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257760',4905436,'2940','325',137527.77,137527.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257761',4905437,'2138','325',1448668.65,1449366.34,0.00,0.00,697.69,502336.80,0.00,0.00,0.00),('1','146','767','257761',4905438,'2940','325',137527.77,137552.36,0.00,0.00,24.59,17704.80,0.00,0.00,0.00),('1','146','767','257762',4905439,'2138','325',1449366.34,1451461.35,0.00,0.00,2095.01,1508407.20,0.00,0.00,0.00),('1','146','767','257762',4905440,'2940','325',137552.36,138057.09,0.00,0.00,504.73,363405.60,0.00,0.00,0.00),('1','146','767','257763',4905441,'2138','325',1451461.35,1452970.06,0.00,0.00,1508.71,1086271.20,0.00,0.00,0.00),('1','146','767','257763',4905442,'2940','325',138057.09,138383.90,0.00,0.00,326.81,235303.20,0.00,0.00,0.00),('1','146','767','257764',4905443,'2138','325',1452970.06,1452970.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257764',4905444,'2940','325',138383.90,138383.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257765',4905445,'2138','325',1452970.06,1453083.25,0.00,0.00,113.19,81496.80,0.00,0.00,0.00),('1','146','767','257765',4905446,'2940','325',138383.90,138425.57,0.00,0.00,41.67,30002.40,0.00,0.00,0.00),('1','146','767','257766',4905447,'2138','325',1453083.25,1455983.01,0.00,0.00,2899.76,2087827.20,0.00,0.00,0.00),('1','146','767','257766',4905448,'2940','325',138425.57,138712.67,0.00,0.00,287.10,206712.00,0.00,0.00,0.00),('1','146','767','257767',4905449,'2138','325',1455983.01,1457297.97,0.00,0.00,1314.96,946771.20,0.00,0.00,0.00),('1','146','767','257767',4905450,'2940','325',138712.67,138969.81,0.00,0.00,257.14,185140.80,0.00,0.00,0.00),('1','146','767','257768',4905451,'2138','325',1457297.97,1457297.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257768',4905452,'2940','325',138969.81,138969.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257769',4905453,'2138','325',1457297.97,1458168.55,0.00,0.00,870.58,626817.60,0.00,0.00,0.00),('1','146','767','257769',4905454,'2940','325',138969.81,139077.59,0.00,0.00,107.78,77601.60,0.00,0.00,0.00),('1','146','767','257770',4905455,'2138','325',1458168.55,1460495.00,0.00,0.00,2326.45,1675044.00,0.00,0.00,0.00),('1','146','767','257770',4905456,'2940','325',139077.59,139794.25,0.00,0.00,716.66,515995.20,0.00,0.00,0.00),('1','146','767','257771',4905457,'2138','325',1460495.00,1461190.11,0.00,0.00,695.11,528283.60,0.00,0.00,0.00),('1','146','767','257771',4905458,'2940','325',139794.25,139849.90,0.00,0.00,55.65,42294.00,0.00,0.00,0.00),('1','146','767','257772',4905459,'2138','325',1461190.11,1461190.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257772',4905460,'2940','325',139849.90,139849.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257773',4905461,'2138','325',1461190.11,1462351.69,0.00,0.00,1161.58,882800.80,0.00,0.00,0.00),('1','146','767','257773',4905462,'2940','325',139849.90,139941.42,0.00,0.00,91.52,69555.20,0.00,0.00,0.00),('1','146','767','257774',4905463,'2138','325',1462351.69,1465316.85,0.00,0.00,2965.16,2253521.60,0.00,0.00,0.00),('1','146','767','257774',4905464,'2940','325',139941.42,140730.24,0.00,0.00,788.82,599503.20,0.00,0.00,0.00),('1','146','767','257775',4905465,'2138','325',1465316.85,1465316.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257775',4905466,'2940','325',140730.24,140730.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257776',4905467,'2138','325',1465316.85,1467546.97,0.00,0.00,2230.12,1694891.20,0.00,0.00,0.00),('1','146','767','257776',4905468,'2940','325',140730.24,141053.93,0.00,0.00,323.69,246004.40,0.00,0.00,0.00),('1','146','767','257777',4905469,'2138','325',1467546.97,1469177.38,0.00,0.00,1630.41,1239111.60,0.00,0.00,0.00),('1','146','767','257777',4905470,'2940','325',141053.93,141301.89,0.00,0.00,247.96,188449.60,0.00,0.00,0.00),('1','146','767','257778',4905471,'2138','325',1469177.38,1469177.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257778',4905472,'2940','325',141301.89,141301.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257779',4905473,'2138','325',1469177.38,1469451.14,0.00,0.00,273.76,208057.60,0.00,0.00,0.00),('1','146','767','257779',4905474,'2940','325',141301.89,141418.33,0.00,0.00,116.44,88494.40,0.00,0.00,0.00),('1','146','767','257780',4905475,'2138','325',1469451.14,1473439.04,0.00,0.00,3987.90,3030804.00,0.00,0.00,0.00),('1','146','767','257780',4905476,'2940','325',141418.33,142106.81,0.00,0.00,688.48,523244.80,0.00,0.00,0.00),('1','146','767','257781',4905477,'2138','325',1473439.04,1473947.52,0.00,0.00,508.48,386444.80,0.00,0.00,0.00),('1','146','767','257781',4905478,'2940','325',142106.81,142106.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257782',4905479,'2138','325',1473947.52,1473947.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257782',4905480,'2940','325',142106.81,142106.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257783',4905481,'2138','325',1473947.52,1475031.44,0.00,0.00,1083.92,823779.20,0.00,0.00,0.00),('1','146','767','257783',4905482,'2940','325',142106.81,142186.42,0.00,0.00,79.61,60503.60,0.00,0.00,0.00),('1','146','767','257784',4905483,'2138','325',1475031.44,1477458.97,0.00,0.00,2427.53,1844922.80,0.00,0.00,0.00),('1','146','767','257784',4905484,'2940','325',142186.42,142950.76,0.00,0.00,764.34,580898.40,0.00,0.00,0.00),('1','146','767','257785',4905485,'2138','325',1477458.97,1477820.87,0.00,0.00,361.90,275044.00,0.00,0.00,0.00),('1','146','767','257785',4905486,'2940','325',142950.76,143100.23,0.00,0.00,149.47,113597.20,0.00,0.00,0.00),('1','146','767','257786',4905487,'2138','325',1477820.87,1477820.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257786',4905488,'2940','325',143100.23,143100.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257787',4905489,'2138','325',1477820.87,1479426.31,0.00,0.00,1605.44,1220134.40,0.00,0.00,0.00),('1','146','767','257787',4905490,'2940','325',143100.23,143767.54,0.00,0.00,667.31,507155.60,0.00,0.00,0.00),('1','146','767','257788',4905491,'2138','325',1479426.31,1481838.14,0.00,0.00,2411.83,1832990.80,0.00,0.00,0.00),('1','146','767','257788',4905492,'2940','325',143767.54,143881.29,0.00,0.00,113.75,86450.00,0.00,0.00,0.00),('1','146','767','257789',4905493,'2138','325',1481838.14,1481838.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257789',4905494,'2940','325',143881.29,143881.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257790',4905495,'2138','325',1481838.14,1483832.28,0.00,0.00,1994.14,1515546.40,0.00,0.00,0.00),('1','146','767','257790',4905496,'2940','325',143881.29,144125.88,0.00,0.00,244.59,185888.40,0.00,0.00,0.00),('1','146','767','257791',4905497,'2138','325',1483832.28,1485549.85,0.00,0.00,1717.57,1305353.20,0.00,0.00,0.00),('1','146','767','257791',4905498,'2940','325',144125.88,145209.58,0.00,0.00,1083.70,823612.00,0.00,0.00,0.00),('1','146','767','257792',4905499,'2138','325',1485549.85,1485549.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257792',4905500,'2940','325',145209.58,145209.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257793',4905501,'2138','325',1485549.85,1485871.33,0.00,0.00,321.48,244324.80,0.00,0.00,0.00),('1','146','767','257793',4905502,'2940','325',145209.58,145254.58,0.00,0.00,45.00,34200.00,0.00,0.00,0.00),('1','146','767','257794',4905503,'2138','325',1485871.33,1488220.16,0.00,0.00,2348.83,1785110.80,0.00,0.00,0.00),('1','146','767','257794',4905504,'2940','325',145254.58,145530.24,0.00,0.00,275.66,209501.60,0.00,0.00,0.00),('1','146','767','257795',4905505,'2138','325',1488220.16,1489548.12,0.00,0.00,1327.96,1009249.60,0.00,0.00,0.00),('1','146','767','257795',4905506,'2940','325',145530.24,145615.24,0.00,0.00,85.00,64600.00,0.00,0.00,0.00),('1','146','767','257796',4905507,'2138','325',1489548.12,1491826.44,0.00,0.00,2278.32,1731523.20,0.00,0.00,0.00),('1','146','767','257796',4905508,'2940','325',145615.24,146308.92,0.00,0.00,693.68,527196.80,0.00,0.00,0.00),('1','146','767','257797',4905509,'2138','325',1491826.44,1493286.03,0.00,0.00,1459.59,1109288.40,0.00,0.00,0.00),('1','146','767','257797',4905510,'2940','325',146308.92,146883.00,0.00,0.00,574.08,436300.80,0.00,0.00,0.00),('1','146','767','257798',4905511,'2138','325',1493286.03,1493286.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257798',4905512,'2940','325',146883.00,146883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257799',4905513,'2138','325',1493286.03,1493858.91,0.00,0.00,572.88,435388.80,0.00,0.00,0.00),('1','146','767','257799',4905514,'2940','325',146883.00,147194.53,0.00,0.00,311.53,236762.80,0.00,0.00,0.00),('1','146','767','257800',4905515,'2138','325',1493858.91,1496249.84,0.00,0.00,2390.93,1817106.80,0.00,0.00,0.00),('1','146','767','257800',4905516,'2940','325',147194.53,148104.22,0.00,0.00,909.69,691364.40,0.00,0.00,0.00),('1','146','767','257801',4905517,'2138','325',1496249.84,1497208.69,0.00,0.00,958.85,728726.00,0.00,0.00,0.00),('1','146','767','257801',4905518,'2940','325',148104.22,148357.33,0.00,0.00,253.11,192363.60,0.00,0.00,0.00),('1','146','767','257802',4905519,'2138','325',1497208.69,1499400.93,0.00,0.00,2192.24,1666102.40,0.00,0.00,0.00),('1','146','767','257802',4905520,'2940','325',148357.33,149180.51,0.00,0.00,823.18,625616.80,0.00,0.00,0.00),('1','146','767','257803',4905521,'2138','325',1499400.93,1500792.27,0.00,0.00,1391.34,1057418.40,0.00,0.00,0.00),('1','146','767','257803',4905522,'2940','325',149180.51,149857.42,0.00,0.00,676.91,514451.60,0.00,0.00,0.00),('1','146','767','257804',4905523,'2138','325',1500792.27,1500792.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257804',4905524,'2940','325',149857.42,149857.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257805',4905525,'2138','325',1500792.27,1501290.40,0.00,0.00,498.13,378578.80,0.00,0.00,0.00),('1','146','767','257805',4905526,'2940','325',149857.42,150085.97,0.00,0.00,228.55,173698.00,0.00,0.00,0.00),('1','146','767','257806',4905527,'2138','325',1501290.40,1504012.74,0.00,0.00,2722.34,2068978.40,0.00,0.00,0.00),('1','146','767','257806',4905528,'2940','325',150085.97,150288.01,0.00,0.00,202.04,153550.40,0.00,0.00,0.00),('1','146','767','257807',4905529,'2138','325',1504012.74,1506048.91,0.00,0.00,2036.17,1547489.20,0.00,0.00,0.00),('1','146','767','257807',4905530,'2940','325',150288.01,150358.41,0.00,0.00,70.40,53504.00,0.00,0.00,0.00),('1','146','767','257808',4905531,'2138','325',1506048.91,1506048.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257808',4905532,'2940','325',150358.41,150358.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257809',4905533,'2138','325',1506048.91,1506048.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257809',4905534,'2940','325',150358.41,150358.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257810',4905535,'2138','325',1506048.91,1508435.36,0.00,0.00,2386.45,1813702.00,0.00,0.00,0.00),('1','146','767','257810',4905536,'2940','325',150358.41,150942.38,0.00,0.00,583.97,443817.20,0.00,0.00,0.00),('1','146','767','257811',4905537,'2138','325',1508435.36,1510672.55,0.00,0.00,2237.19,1700264.40,0.00,0.00,0.00),('1','146','767','257811',4905538,'2940','325',150942.38,151024.74,0.00,0.00,82.36,62593.60,0.00,0.00,0.00),('1','146','767','257812',4905539,'2138','325',1510672.55,1510672.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257812',4905540,'2940','325',151024.74,151024.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257813',4905541,'2138','325',1510672.55,1510946.09,0.00,0.00,273.54,207890.40,0.00,0.00,0.00),('1','146','767','257813',4905542,'2940','325',151024.74,151039.87,0.00,0.00,15.13,11498.80,0.00,0.00,0.00),('1','146','767','257814',4905543,'2138','325',1510946.09,1512887.88,0.00,0.00,1941.79,1475760.40,0.00,0.00,0.00),('1','146','767','257814',4905544,'2940','325',151039.87,151732.62,0.00,0.00,692.75,526490.00,0.00,0.00,0.00),('1','146','767','257815',4905545,'2138','325',1512887.88,1515284.92,0.00,0.00,2397.04,1821750.40,0.00,0.00,0.00),('1','146','767','257815',4905546,'2940','325',151732.62,151985.90,0.00,0.00,253.28,192492.80,0.00,0.00,0.00),('1','146','767','257816',4905547,'2138','325',1515284.92,1515284.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257816',4905548,'2940','325',151985.90,151985.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257817',4905549,'2138','325',1515284.92,1517762.42,0.00,0.00,2477.50,1886740.00,0.00,0.00,0.00),('1','146','767','257817',4905550,'2940','325',151985.90,152438.53,0.00,0.00,452.63,343998.80,0.00,0.00,0.00),('1','146','767','257818',4905551,'2138','325',1517762.42,1519937.71,0.00,0.00,2175.29,1653220.40,0.00,0.00,0.00),('1','146','767','257818',4905552,'2940','325',152438.53,152836.42,0.00,0.00,397.89,302396.40,0.00,0.00,0.00),('1','146','767','257819',4905553,'2138','325',1519937.71,1519937.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257819',4905554,'2940','325',152836.42,152836.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257820',4905555,'2138','325',1519937.71,1522228.57,0.00,0.00,2290.86,1741053.60,0.00,0.00,0.00),('1','146','767','257820',4905556,'2940','325',152836.42,153458.93,0.00,0.00,622.51,473107.60,0.00,0.00,0.00),('1','146','767','257821',4905557,'2138','325',1522228.57,1523752.14,0.00,0.00,1523.57,1157913.20,0.00,0.00,0.00),('1','146','767','257821',4905558,'2940','325',153458.93,154214.98,0.00,0.00,756.05,574598.00,0.00,0.00,0.00),('1','146','767','257822',4905559,'2138','325',1523752.14,1523752.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257822',4905560,'2940','325',154214.98,154214.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257823',4905561,'2138','325',1523752.14,1524410.03,0.00,0.00,657.89,499996.40,0.00,0.00,0.00),('1','146','767','257823',4905562,'2940','325',154214.98,154322.48,0.00,0.00,107.50,81700.00,0.00,0.00,0.00),('1','146','767','257824',4905563,'2138','325',1524410.03,1527449.99,0.00,0.00,3039.96,2310369.60,0.00,0.00,0.00),('1','146','767','257824',4905564,'2940','325',154322.48,154784.43,0.00,0.00,461.95,351082.00,0.00,0.00,0.00),('1','146','767','257825',4905565,'2138','325',1527449.99,1527909.73,0.00,0.00,459.74,349402.40,0.00,0.00,0.00),('1','146','767','257825',4905566,'2940','325',154784.43,154830.74,0.00,0.00,46.31,35195.60,0.00,0.00,0.00),('1','146','767','257826',4905567,'2138','325',1527909.73,1527909.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257826',4905568,'2940','325',154830.74,154830.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257827',4905569,'2138','325',1527909.73,1530025.62,0.00,0.00,2115.89,1608076.40,0.00,0.00,0.00),('1','146','767','257827',4905570,'2940','325',154830.74,155272.13,0.00,0.00,441.39,335456.40,0.00,0.00,0.00),('1','146','767','257828',4905571,'2138','325',1530025.62,1531990.10,0.00,0.00,1964.48,1493004.80,0.00,0.00,0.00),('1','146','767','257828',4905572,'2940','325',155272.13,155812.76,0.00,0.00,540.63,410878.80,0.00,0.00,0.00),('1','146','767','257829',4905573,'2138','325',1531990.10,1531990.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257829',4905574,'2940','325',155812.76,155812.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257830',4905575,'2138','325',1531990.10,1532477.49,0.00,0.00,487.39,370416.40,0.00,0.00,0.00),('1','146','767','257830',4905576,'2940','325',155812.76,155875.26,0.00,0.00,62.50,47500.00,0.00,0.00,0.00),('1','146','767','257831',4905577,'2138','325',1532477.49,1535509.33,0.00,0.00,3031.84,2304198.40,0.00,0.00,0.00),('1','146','767','257831',4905578,'2940','325',155875.26,156367.62,0.00,0.00,492.36,374193.60,0.00,0.00,0.00),('1','146','767','257832',4905579,'2138','325',1535509.33,1536461.94,0.00,0.00,952.61,723983.60,0.00,0.00,0.00),('1','146','767','257832',4905580,'2940','325',156367.62,156414.99,0.00,0.00,47.37,36001.20,0.00,0.00,0.00),('1','146','767','257833',4905581,'2138','325',1536461.94,1538061.70,0.00,0.00,1599.76,1215817.60,0.00,0.00,0.00),('1','146','767','257833',4905582,'2940','325',156414.99,156817.86,0.00,0.00,402.87,306181.20,0.00,0.00,0.00),('1','146','767','257834',4905583,'2138','325',1538061.70,1540747.11,0.00,0.00,2685.41,2040911.60,0.00,0.00,0.00),('1','146','767','257834',4905584,'2940','325',156817.86,157240.41,0.00,0.00,422.55,321138.00,0.00,0.00,0.00),('1','146','767','257835',4905585,'2138','325',1540747.11,1540845.27,0.00,0.00,98.16,74601.60,0.00,0.00,0.00),('1','146','767','257835',4905586,'2940','325',157240.41,157240.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257836',4905587,'2138','325',1540845.27,1543038.75,0.00,0.00,2193.48,1667044.80,0.00,0.00,0.00),('1','146','767','257836',4905588,'2940','325',157240.41,158165.34,0.00,0.00,924.93,702946.80,0.00,0.00,0.00),('1','146','767','257837',4905589,'2138','325',1543038.75,1544968.78,0.00,0.00,1930.03,1466822.80,0.00,0.00,0.00),('1','146','767','257837',4905590,'2940','325',158165.34,158388.09,0.00,0.00,222.75,169290.00,0.00,0.00,0.00),('1','146','767','257838',4905591,'2138','325',1544968.78,1545148.38,0.00,0.00,179.60,136496.00,0.00,0.00,0.00),('1','146','767','257838',4905592,'2940','325',158388.09,158388.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257839',4905593,'2138','325',1545148.38,1547433.73,0.00,0.00,2285.35,1736866.00,0.00,0.00,0.00),('1','146','767','257839',4905594,'2940','325',158388.09,159078.98,0.00,0.00,690.89,525076.40,0.00,0.00,0.00),('1','146','767','257840',4905595,'2138','325',1547433.73,1549277.52,0.00,0.00,1843.79,1401280.40,0.00,0.00,0.00),('1','146','767','257840',4905596,'2940','325',159078.98,159434.21,0.00,0.00,355.23,269974.80,0.00,0.00,0.00),('1','146','767','257841',4905597,'2138','325',1549277.52,1550231.46,0.00,0.00,953.94,724994.40,0.00,0.00,0.00),('1','146','767','257841',4905598,'2940','325',159434.21,159591.72,0.00,0.00,157.51,119707.60,0.00,0.00,0.00),('1','146','767','257842',4905599,'2138','325',1550231.46,1552288.92,0.00,0.00,2057.46,1563669.60,0.00,0.00,0.00),('1','146','767','257842',4905600,'2940','325',159591.72,159996.11,0.00,0.00,404.39,307336.40,0.00,0.00,0.00),('1','146','767','257843',4905601,'2138','325',1552288.92,1553703.70,0.00,0.00,1414.78,1075232.80,0.00,0.00,0.00),('1','146','767','257843',4905602,'2940','325',159996.11,160284.42,0.00,0.00,288.31,219115.60,0.00,0.00,0.00),('1','146','767','257844',4905603,'2138','325',1553703.70,1553925.38,0.00,0.00,221.68,168476.80,0.00,0.00,0.00),('1','146','767','257844',4905604,'2940','325',160284.42,160305.87,0.00,0.00,21.45,16302.00,0.00,0.00,0.00),('1','146','767','257845',4905605,'2138','325',1553925.38,1555467.98,0.00,0.00,1542.60,1172376.00,0.00,0.00,0.00),('1','146','767','257845',4905606,'2940','325',160305.87,160789.12,0.00,0.00,483.25,367270.00,0.00,0.00,0.00),('1','146','767','257846',4905607,'2138','325',1555467.98,1557178.86,0.00,0.00,1710.88,1300268.80,0.00,0.00,0.00),('1','146','767','257846',4905608,'2940','325',160789.12,161191.61,0.00,0.00,402.49,305892.40,0.00,0.00,0.00),('1','146','767','257847',4905609,'2138','325',1557178.86,1557844.27,0.00,0.00,665.41,505711.60,0.00,0.00,0.00),('1','146','767','257847',4905610,'2940','325',161191.61,161426.86,0.00,0.00,235.25,178790.00,0.00,0.00,0.00),('1','146','767','257848',4905611,'2138','325',1557844.27,1558638.96,0.00,0.00,794.69,603964.40,0.00,0.00,0.00),('1','146','767','257848',4905612,'2940','325',161426.86,161666.02,0.00,0.00,239.16,181761.60,0.00,0.00,0.00),('1','146','767','257849',4905613,'2138','325',1558638.96,1560709.72,0.00,0.00,2070.76,1573777.60,0.00,0.00,0.00),('1','146','767','257849',4905614,'2940','325',161666.02,162372.03,0.00,0.00,706.01,536567.60,0.00,0.00,0.00),('1','146','767','257850',4905615,'2138','325',1560709.72,1561924.57,0.00,0.00,1214.85,923286.00,0.00,0.00,0.00),('1','146','767','257850',4905616,'2940','325',162372.03,162570.18,0.00,0.00,198.15,150594.00,0.00,0.00,0.00),('1','146','767','257851',4905617,'2138','325',1561924.57,1561924.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257851',4905618,'2940','325',162570.18,162570.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257852',4905619,'2138','325',1561924.57,1562337.28,0.00,0.00,412.71,313659.60,0.00,0.00,0.00),('1','146','767','257852',4905620,'2940','325',162570.18,162933.12,0.00,0.00,362.94,275834.40,0.00,0.00,0.00),('1','146','767','257853',4905621,'2138','325',1562337.28,1564764.39,0.00,0.00,2427.11,1844603.60,0.00,0.00,0.00),('1','146','767','257853',4905622,'2940','325',162933.12,163365.49,0.00,0.00,432.37,328601.20,0.00,0.00,0.00),('1','146','767','257854',4905623,'2138','325',1564764.39,1566173.21,0.00,0.00,1408.82,1070703.20,0.00,0.00,0.00),('1','146','767','257854',4905624,'2940','325',163365.49,163481.35,0.00,0.00,115.86,88053.60,0.00,0.00,0.00),('1','146','767','257855',4905625,'2138','325',1566173.21,1566687.31,0.00,0.00,514.10,390716.00,0.00,0.00,0.00),('1','146','767','257855',4905626,'2940','325',163481.35,163562.01,0.00,0.00,80.66,61301.60,0.00,0.00,0.00),('1','146','767','257856',4905627,'2138','325',1566687.31,1568867.22,0.00,0.00,2179.91,1656731.60,0.00,0.00,0.00),('1','146','767','257856',4905628,'2940','325',163562.01,164357.45,0.00,0.00,795.44,604534.40,0.00,0.00,0.00),('1','146','767','257857',4905629,'2138','325',1568867.22,1569559.95,0.00,0.00,692.73,526474.80,0.00,0.00,0.00),('1','146','767','257857',4905630,'2940','325',164357.45,164607.45,0.00,0.00,250.00,190000.00,0.00,0.00,0.00),('1','146','767','257858',4905631,'2138','325',1569559.95,1570645.93,0.00,0.00,1085.98,825344.80,0.00,0.00,0.00),('1','146','767','257858',4905632,'2940','325',164607.45,164977.05,0.00,0.00,369.60,280896.00,0.00,0.00,0.00),('1','146','767','257859',4905633,'2138','325',1570645.93,1572975.73,0.00,0.00,2329.80,1770648.00,0.00,0.00,0.00),('1','146','767','257859',4905634,'2940','325',164977.05,165443.15,0.00,0.00,466.10,354236.00,0.00,0.00,0.00),('1','146','767','257860',4905635,'2138','325',1572975.73,1573796.37,0.00,0.00,820.64,623686.40,0.00,0.00,0.00),('1','146','767','257860',4905636,'2940','325',165443.15,165663.03,0.00,0.00,219.88,167108.80,0.00,0.00,0.00),('1','146','767','257861',4905637,'2138','325',1573796.37,1573796.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257861',4905638,'2940','325',165663.03,165663.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257862',4905639,'2138','325',1573796.37,1575095.86,0.00,0.00,1299.49,987612.40,0.00,0.00,0.00),('1','146','767','257862',4905640,'2940','325',165663.03,165891.98,0.00,0.00,228.95,174002.00,0.00,0.00,0.00),('1','146','767','257863',4905641,'2138','325',1575095.86,1577251.59,0.00,0.00,2155.73,1638354.80,0.00,0.00,0.00),('1','146','767','257863',4905642,'2940','325',165891.98,166461.44,0.00,0.00,569.46,432789.60,0.00,0.00,0.00),('1','146','767','257864',4905643,'2138','325',1577251.59,1578321.34,0.00,0.00,1069.75,795894.00,0.00,0.00,0.00),('1','146','767','257864',4905644,'2940','325',166461.44,166561.44,0.00,0.00,100.00,74400.00,0.00,0.00,0.00),('1','146','767','257865',4905645,'2138','325',1578321.34,1578321.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257865',4905646,'2940','325',166561.44,166561.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257866',4905647,'2138','325',1578321.34,1579536.16,0.00,0.00,1214.82,903826.08,0.00,0.00,0.00),('1','146','767','257866',4905648,'2940','325',166561.44,166802.17,0.00,0.00,240.73,179103.12,0.00,0.00,0.00),('1','146','767','257867',4905649,'2138','325',1579536.16,1582231.31,0.00,0.00,2695.15,2005191.60,0.00,0.00,0.00),('1','146','767','257867',4905650,'2940','325',166802.17,167390.86,0.00,0.00,588.69,437985.36,0.00,0.00,0.00),('1','146','767','257868',4905651,'2138','325',1582231.31,1583047.17,0.00,0.00,815.86,606999.84,0.00,0.00,0.00),('1','146','767','257868',4905652,'2940','325',167390.86,167453.36,0.00,0.00,62.50,46500.00,0.00,0.00,0.00),('1','146','767','257869',4905653,'2138','325',1583047.17,1584446.62,0.00,0.00,1399.45,1041190.80,0.00,0.00,0.00),('1','146','767','257869',4905654,'2940','325',167453.36,167911.54,0.00,0.00,458.18,340885.92,0.00,0.00,0.00),('1','146','767','257870',4905655,'2138','325',1584446.62,1586979.57,0.00,0.00,2532.95,1884514.80,0.00,0.00,0.00),('1','146','767','257870',4905656,'2940','325',167911.54,168278.06,0.00,0.00,366.52,272690.88,0.00,0.00,0.00),('1','146','767','257871',4905657,'2138','325',1586979.57,1587279.43,0.00,0.00,299.86,223095.84,0.00,0.00,0.00),('1','146','767','257871',4905658,'2940','325',168278.06,168368.65,0.00,0.00,90.59,67398.96,0.00,0.00,0.00),('1','146','767','257872',4905659,'2138','325',1587279.43,1589399.80,0.00,0.00,2120.37,1577555.28,0.00,0.00,0.00),('1','146','767','257872',4905660,'2940','325',168368.65,168664.63,0.00,0.00,295.98,220209.12,0.00,0.00,0.00),('1','146','767','257873',4905661,'2138','325',1589399.80,1591561.21,0.00,0.00,2161.41,1608089.04,0.00,0.00,0.00),('1','146','767','257873',4905662,'2940','325',168664.63,169085.73,0.00,0.00,421.10,313298.40,0.00,0.00,0.00),('1','146','767','257874',4905663,'2138','325',1591561.21,1591930.83,0.00,0.00,369.62,274997.28,0.00,0.00,0.00),('1','146','767','257874',4905664,'2940','325',169085.73,169148.23,0.00,0.00,62.50,46500.00,0.00,0.00,0.00),('1','146','767','257875',4905665,'2138','325',1591930.83,1593610.15,0.00,0.00,1679.32,1249414.08,0.00,0.00,0.00),('1','146','767','257875',4905666,'2940','325',169148.23,169379.76,0.00,0.00,231.53,172258.32,0.00,0.00,0.00),('1','146','767','257876',4905667,'2138','325',1593610.15,1596190.29,0.00,0.00,2580.14,1919624.16,0.00,0.00,0.00),('1','146','767','257876',4905668,'2940','325',169379.76,169853.35,0.00,0.00,473.59,352350.96,0.00,0.00,0.00),('1','146','767','257877',4905669,'2138','325',1596190.29,1596563.82,0.00,0.00,373.53,277906.32,0.00,0.00,0.00),('1','146','767','257877',4905670,'2940','325',169853.35,169969.34,0.00,0.00,115.99,86296.56,0.00,0.00,0.00),('1','146','767','257878',4905671,'2138','325',1596563.82,1597762.44,0.00,0.00,1198.62,891773.28,0.00,0.00,0.00),('1','146','767','257878',4905672,'2940','325',169969.34,170289.76,0.00,0.00,320.42,238392.48,0.00,0.00,0.00),('1','146','767','257879',4905673,'2138','325',1597762.44,1600037.28,0.00,0.00,2274.84,1692480.96,0.00,0.00,0.00),('1','146','767','257879',4905674,'2940','325',170289.76,170976.71,0.00,0.00,686.95,511090.80,0.00,0.00,0.00),('1','146','767','257880',4905675,'2138','325',1600037.28,1600200.65,0.00,0.00,163.37,121547.28,0.00,0.00,0.00),('1','146','767','257880',4905676,'2940','325',170976.71,170989.21,0.00,0.00,12.50,9300.00,0.00,0.00,0.00),('1','146','767','257881',4905677,'2138','325',1600200.65,1602595.98,0.00,0.00,2395.33,1782125.52,0.00,0.00,0.00),('1','146','767','257881',4905678,'2940','325',170989.21,171387.81,0.00,0.00,398.60,296558.40,0.00,0.00,0.00),('1','146','767','257882',4905679,'2138','325',1602595.98,1604816.52,0.00,0.00,2220.54,1652081.76,0.00,0.00,0.00),('1','146','767','257882',4905680,'2940','325',171387.81,171876.45,0.00,0.00,488.64,363548.16,0.00,0.00,0.00),('1','146','767','257883',4905681,'2138','325',1604816.52,1608263.69,0.00,0.00,3447.17,2564694.48,0.00,0.00,0.00),('1','146','767','257883',4905682,'2940','325',171876.45,172240.41,0.00,0.00,363.96,270786.24,0.00,0.00,0.00),('1','146','767','257884',4905683,'2138','325',1608263.69,1609934.58,0.00,0.00,1670.89,1243142.16,0.00,0.00,0.00),('1','146','767','257884',4905684,'2940','325',172240.41,172900.62,0.00,0.00,660.21,491196.24,0.00,0.00,0.00),('1','146','767','257885',4905685,'2138','325',1609934.58,1610766.77,0.00,0.00,832.19,619149.36,0.00,0.00,0.00),('1','146','767','257885',4905686,'2940','325',172900.62,173136.10,0.00,0.00,235.48,175197.12,0.00,0.00,0.00),('1','146','767','257886',4905687,'2138','325',1610766.77,1614466.76,0.00,0.00,3699.99,2752792.56,0.00,0.00,0.00),('1','146','767','257886',4905688,'2940','325',173136.10,173831.70,0.00,0.00,695.60,517526.40,0.00,0.00,0.00),('1','146','767','257887',4905689,'2138','325',1614466.76,1614736.11,0.00,0.00,269.35,200396.40,0.00,0.00,0.00),('1','146','767','257887',4905690,'2940','325',173831.70,173849.51,0.00,0.00,17.81,13250.64,0.00,0.00,0.00),('1','146','767','257888',4905691,'2138','325',1614736.11,1617042.71,0.00,0.00,2306.60,1716110.40,0.00,0.00,0.00),('1','146','767','257888',4905692,'2940','325',173849.51,174373.24,0.00,0.00,523.73,389655.12,0.00,0.00,0.00),('1','146','767','257889',4905693,'2138','325',1617042.71,1618392.32,0.00,0.00,1349.61,1025703.60,0.00,0.00,0.00),('1','146','767','257889',4905694,'2940','325',174373.24,174635.62,0.00,0.00,262.38,199408.80,0.00,0.00,0.00),('1','146','767','257890',4905695,'2138','325',1618392.32,1620197.23,0.00,0.00,1804.91,1371731.60,0.00,0.00,0.00),('1','146','767','257890',4905696,'2940','325',174635.62,174922.64,0.00,0.00,287.02,218135.20,0.00,0.00,0.00),('1','146','767','257891',4905697,'2138','325',1620197.23,1622971.84,0.00,0.00,2774.61,2108703.60,0.00,0.00,0.00),('1','146','767','257891',4905698,'2940','325',174922.64,175765.41,0.00,0.00,842.77,640505.20,0.00,0.00,0.00),('1','146','767','257892',4905699,'2138','325',1622971.84,1623223.45,0.00,0.00,251.61,191223.60,0.00,0.00,0.00),('1','146','767','257892',4905700,'2940','325',175765.41,175831.03,0.00,0.00,65.62,49871.20,0.00,0.00,0.00),('1','146','767','257893',4905701,'2138','325',1623223.45,1625430.57,0.00,0.00,2207.12,1677411.20,0.00,0.00,0.00),('1','146','767','257893',4905702,'2940','325',175831.03,176124.73,0.00,0.00,293.70,223212.00,0.00,0.00,0.00),('1','146','767','257894',4905703,'2138','325',1625430.57,1627636.31,0.00,0.00,2205.74,1676362.40,0.00,0.00,0.00),('1','146','767','257894',4905704,'2940','325',176124.73,176323.51,0.00,0.00,198.78,151072.80,0.00,0.00,0.00),('1','146','767','257895',4905705,'2138','325',1627636.31,1627636.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257895',4905706,'2940','325',176323.51,176323.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257896',4905707,'2138','325',1627636.31,1627882.81,0.00,0.00,246.50,187340.00,0.00,0.00,0.00),('1','146','767','257896',4905708,'2940','325',176323.51,176343.65,0.00,0.00,20.14,15306.40,0.00,0.00,0.00),('1','146','767','257897',4905709,'2138','325',1627882.81,1629697.74,0.00,0.00,1814.93,1379346.80,0.00,0.00,0.00),('1','146','767','257897',4905710,'2940','325',176343.65,177141.38,0.00,0.00,797.73,606274.80,0.00,0.00,0.00),('1','146','767','257898',4905711,'2138','325',1629697.74,1631563.80,0.00,0.00,1866.06,1418205.60,0.00,0.00,0.00),('1','146','767','257898',4905712,'2940','325',177141.38,177689.02,0.00,0.00,547.64,416206.40,0.00,0.00,0.00),('1','146','767','257899',4905713,'2138','325',1631563.80,1634281.99,0.00,0.00,2718.19,2065824.40,0.00,0.00,0.00),('1','146','767','257899',4905714,'2940','325',177689.02,178033.97,0.00,0.00,344.95,262162.00,0.00,0.00,0.00),('1','146','767','257900',4905715,'2138','325',1634281.99,1636426.86,0.00,0.00,2144.87,1630101.20,0.00,0.00,0.00),('1','146','767','257900',4905716,'2940','325',178033.97,178659.21,0.00,0.00,625.24,475182.40,0.00,0.00,0.00),('1','146','767','257901',4905717,'2138','325',1636426.86,1639391.62,0.00,0.00,2964.76,2205781.44,0.00,0.00,0.00),('1','146','767','257901',4905718,'2940','325',178659.21,179109.61,0.00,0.00,450.40,335097.60,0.00,0.00,0.00),('1','146','767','257902',4905719,'2138','325',1639391.62,1640628.17,0.00,0.00,1236.55,919993.20,0.00,0.00,0.00),('1','146','767','257902',4905720,'2940','325',179109.61,179837.90,0.00,0.00,728.29,541847.76,0.00,0.00,0.00),('1','146','767','257903',4905721,'2138','325',1640628.17,1640898.34,0.00,0.00,270.17,201006.48,0.00,0.00,0.00),('1','146','767','257903',4905722,'2940','325',179837.90,179925.53,0.00,0.00,87.63,65196.72,0.00,0.00,0.00),('1','146','767','257904',4905723,'2138','325',1640898.34,1644273.75,0.00,0.00,3375.41,2511305.04,0.00,0.00,0.00),('1','146','767','257904',4905724,'2940','325',179925.53,180376.36,0.00,0.00,450.83,335417.52,0.00,0.00,0.00),('1','146','767','257905',4905725,'2138','325',1644273.75,1645185.91,0.00,0.00,912.16,678647.04,0.00,0.00,0.00),('1','146','767','257905',4905726,'2940','325',180376.36,180839.67,0.00,0.00,463.31,344702.64,0.00,0.00,0.00),('1','146','767','257906',4905727,'2138','325',1645185.91,1646232.95,0.00,0.00,1047.04,778997.76,0.00,0.00,0.00),('1','146','767','257906',4905728,'2940','325',180839.67,181094.65,0.00,0.00,254.98,189705.12,0.00,0.00,0.00),('1','146','767','257907',4905729,'2138','325',1646232.95,1648842.25,0.00,0.00,2609.30,1941319.20,0.00,0.00,0.00),('1','146','767','257907',4905730,'2940','325',181094.65,181572.15,0.00,0.00,477.50,355260.00,0.00,0.00,0.00),('1','146','767','257908',4905731,'2138','325',1648842.25,1649278.43,0.00,0.00,436.18,324517.92,0.00,0.00,0.00),('1','146','767','257908',4905732,'2940','325',181572.15,181983.52,0.00,0.00,411.37,306059.28,0.00,0.00,0.00),('1','146','767','257909',4905733,'2138','325',1649278.43,1650796.31,0.00,0.00,1517.88,1129302.72,0.00,0.00,0.00),('1','146','767','257909',4905734,'2940','325',181983.52,182089.56,0.00,0.00,106.04,78893.76,0.00,0.00,0.00),('1','146','767','257910',4905735,'2138','325',1650796.31,1652991.41,0.00,0.00,2195.10,1633154.40,0.00,0.00,0.00),('1','146','767','257910',4905736,'2940','325',182089.56,182353.15,0.00,0.00,263.59,196110.96,0.00,0.00,0.00),('1','146','767','257911',4905737,'2138','325',1652991.41,1653957.60,0.00,0.00,966.19,718845.36,0.00,0.00,0.00),('1','146','767','257911',4905738,'2940','325',182353.15,182440.65,0.00,0.00,87.50,65100.00,0.00,0.00,0.00),('1','146','767','257912',4905739,'2138','325',1653957.60,1653957.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257912',4905740,'2940','325',182440.65,182440.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257913',4905741,'2138','325',1653957.60,1655428.05,0.00,0.00,1470.45,1094014.80,0.00,0.00,0.00),('1','146','767','257913',4905742,'2940','325',182440.65,182847.25,0.00,0.00,406.60,302510.40,0.00,0.00,0.00),('1','146','767','257914',4905743,'2138','325',1655428.05,1657973.41,0.00,0.00,2545.36,1893747.84,0.00,0.00,0.00),('1','146','767','257914',4905744,'2940','325',182847.25,183258.01,0.00,0.00,410.76,305605.44,0.00,0.00,0.00),('1','146','767','257915',4905745,'2138','325',1657973.41,1658146.86,0.00,0.00,173.45,129046.80,0.00,0.00,0.00),('1','146','767','257915',4905746,'2940','325',183258.01,183332.34,0.00,0.00,74.33,55301.52,0.00,0.00,0.00),('1','146','767','257916',4905747,'2138','325',1658146.86,1658146.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257916',4905748,'2940','325',183332.34,183332.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257917',4905749,'2138','325',1658146.86,1660259.78,0.00,0.00,2112.92,1572012.48,0.00,0.00,0.00),('1','146','767','257917',4905750,'2940','325',183332.34,183815.78,0.00,0.00,483.44,359679.36,0.00,0.00,0.00),('1','146','767','257918',4905751,'2138','325',1660259.78,1662029.87,0.00,0.00,1770.09,1316946.96,0.00,0.00,0.00),('1','146','767','257918',4905752,'2940','325',183815.78,184746.96,0.00,0.00,931.18,692797.92,0.00,0.00,0.00),('1','146','767','257919',4905753,'2138','325',1662029.87,1662029.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257919',4905754,'2940','325',184746.96,184746.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257920',4905755,'2138','325',1662029.87,1664318.01,0.00,0.00,2288.14,1702376.16,0.00,0.00,0.00),('1','146','767','257920',4905756,'2940','325',184746.96,185471.21,0.00,0.00,724.25,538842.00,0.00,0.00,0.00),('1','146','767','257921',4905757,'2138','325',1664318.01,1665652.05,0.00,0.00,1334.04,992525.76,0.00,0.00,0.00),('1','146','767','257921',4905758,'2940','325',185471.21,185647.56,0.00,0.00,176.35,131204.40,0.00,0.00,0.00),('1','146','767','257922',4905759,'2138','325',1665652.05,1665652.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257922',4905760,'2940','325',185647.56,185647.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257923',4905761,'2138','325',1665652.05,1666200.24,0.00,0.00,548.19,407853.36,0.00,0.00,0.00),('1','146','767','257923',4905762,'2940','325',185647.56,185757.04,0.00,0.00,109.48,81453.12,0.00,0.00,0.00),('1','146','767','257924',4905763,'2138','325',1666200.24,1668835.60,0.00,0.00,2635.36,1960707.84,0.00,0.00,0.00),('1','146','767','257924',4905764,'2940','325',185757.04,186738.97,0.00,0.00,981.93,730555.92,0.00,0.00,0.00),('1','146','767','257925',4905765,'2138','325',1668835.60,1669482.06,0.00,0.00,646.46,480966.24,0.00,0.00,0.00),('1','146','767','257925',4905766,'2940','325',186738.97,186877.27,0.00,0.00,138.30,102895.20,0.00,0.00,0.00),('1','146','767','257926',4905767,'2138','325',1669482.06,1670530.57,0.00,0.00,1048.51,780091.44,0.00,0.00,0.00),('1','146','767','257926',4905768,'2940','325',186877.27,187462.85,0.00,0.00,585.58,435671.52,0.00,0.00,0.00),('1','146','767','257927',4905769,'2138','325',1670530.57,1672956.95,0.00,0.00,2426.38,1805226.72,0.00,0.00,0.00),('1','146','767','257927',4905770,'2940','325',187462.85,187989.53,0.00,0.00,526.68,391849.92,0.00,0.00,0.00),('1','146','767','257928',4905771,'2138','325',1672956.95,1673481.41,0.00,0.00,524.46,390198.24,0.00,0.00,0.00),('1','146','767','257928',4905772,'2940','325',187989.53,187989.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257929',4905773,'2138','325',1673481.41,1675967.48,0.00,0.00,2486.07,1849636.08,0.00,0.00,0.00),('1','146','767','257929',4905774,'2940','325',187989.53,188677.20,0.00,0.00,687.67,511626.48,0.00,0.00,0.00),('1','146','767','257930',4905775,'2138','325',1675967.48,1678308.51,0.00,0.00,2341.03,1741726.32,0.00,0.00,0.00),('1','146','767','257930',4905776,'2940','325',188677.20,188957.67,0.00,0.00,280.47,208669.68,0.00,0.00,0.00),('1','146','767','257931',4905777,'2138','325',1678308.51,1681586.31,0.00,0.00,3277.80,2438683.20,0.00,0.00,0.00),('1','146','767','257931',4905778,'2940','325',188957.67,189697.63,0.00,0.00,739.96,550530.24,0.00,0.00,0.00),('1','146','767','257932',4905779,'2138','325',1681586.31,1682995.01,0.00,0.00,1408.70,1048072.80,0.00,0.00,0.00),('1','146','767','257932',4905780,'2940','325',189697.63,189891.17,0.00,0.00,193.54,143993.76,0.00,0.00,0.00),('1','146','767','257933',4905781,'2138','325',1682995.01,1683815.06,0.00,0.00,820.05,610117.20,0.00,0.00,0.00),('1','146','767','257933',4905782,'2940','325',189891.17,190011.87,0.00,0.00,120.70,89800.80,0.00,0.00,0.00),('1','146','767','257934',4905783,'2138','325',1683815.06,1686027.62,0.00,0.00,2212.56,1646144.64,0.00,0.00,0.00),('1','146','767','257934',4905784,'2940','325',190011.87,190713.92,0.00,0.00,702.05,522325.20,0.00,0.00,0.00),('1','146','767','257935',4905785,'2138','325',1686027.62,1687138.29,0.00,0.00,1110.67,826338.48,0.00,0.00,0.00),('1','146','767','257935',4905786,'2940','325',190713.92,191019.17,0.00,0.00,305.25,227106.00,0.00,0.00,0.00),('1','146','767','257936',4905787,'2138','325',1687138.29,1688113.20,0.00,0.00,974.91,725333.04,0.00,0.00,0.00),('1','146','767','257936',4905788,'2940','325',191019.17,191248.49,0.00,0.00,229.32,170614.08,0.00,0.00,0.00),('1','146','767','257937',4905789,'2138','325',1688113.20,1690570.69,0.00,0.00,2457.49,1828372.56,0.00,0.00,0.00),('1','146','767','257937',4905790,'2940','325',191248.49,192182.90,0.00,0.00,934.41,695201.04,0.00,0.00,0.00),('1','146','767','257938',4905791,'2138','325',1690570.69,1690828.03,0.00,0.00,257.34,191460.96,0.00,0.00,0.00),('1','146','767','257938',4905792,'2940','325',192182.90,192239.28,0.00,0.00,56.38,41946.72,0.00,0.00,0.00),('1','146','767','257939',4905793,'2138','325',1690828.03,1690828.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257939',4905794,'2940','325',192239.28,192239.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257940',4905795,'2138','325',1690828.03,1692628.78,0.00,0.00,1800.75,1339758.00,0.00,0.00,0.00),('1','146','767','257940',4905796,'2940','325',192239.28,192641.70,0.00,0.00,402.42,299400.48,0.00,0.00,0.00),('1','146','767','257941',4905797,'2138','325',1692628.78,1695066.97,0.00,0.00,2438.19,1814013.36,0.00,0.00,0.00),('1','146','767','257941',4905798,'2940','325',192641.70,193390.91,0.00,0.00,749.21,557412.24,0.00,0.00,0.00),('1','146','767','257942',4905799,'2138','325',1695066.97,1695185.11,0.00,0.00,118.14,87896.16,0.00,0.00,0.00),('1','146','767','257942',4905800,'2940','325',193390.91,193390.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257943',4905801,'2138','325',1695185.11,1696623.93,0.00,0.00,1438.82,1070482.08,0.00,0.00,0.00),('1','146','767','257943',4905802,'2940','325',193390.91,194975.30,0.00,0.00,1584.39,1178786.16,0.00,0.00,0.00),('1','146','767','257944',4905803,'2138','325',1696623.93,1697924.32,0.00,0.00,1300.39,967490.16,0.00,0.00,0.00),('1','146','767','257944',4905804,'2940','325',194975.30,195231.99,0.00,0.00,256.69,190977.36,0.00,0.00,0.00),('1','146','767','257945',4905805,'2138','325',1697924.32,1697924.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257945',4905806,'2940','325',195231.99,195231.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257946',4905807,'2138','325',1697924.32,1699847.16,0.00,0.00,1922.84,1430592.96,0.00,0.00,0.00),('1','146','767','257946',4905808,'2940','325',195231.99,196077.05,0.00,0.00,845.06,628724.64,0.00,0.00,0.00),('1','146','767','257947',4905809,'2138','325',1699847.16,1701640.94,0.00,0.00,1793.78,1334572.32,0.00,0.00,0.00),('1','146','767','257947',4905810,'2940','325',196077.05,196722.00,0.00,0.00,644.95,479842.80,0.00,0.00,0.00),('1','146','767','257948',4905811,'2138','325',1701640.94,1701640.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257948',4905812,'2940','325',196722.00,196722.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257949',4905813,'2138','325',1701640.94,1702124.56,0.00,0.00,483.62,359813.28,0.00,0.00,0.00),('1','146','767','257949',4905814,'2940','325',196722.00,196959.29,0.00,0.00,237.29,176543.76,0.00,0.00,0.00),('1','146','767','257950',4905815,'2138','325',1702124.56,1703790.17,0.00,0.00,1665.61,1239213.84,0.00,0.00,0.00),('1','146','767','257950',4905816,'2940','325',196959.29,197286.33,0.00,0.00,327.04,243317.76,0.00,0.00,0.00),('1','146','767','257951',4905817,'2138','325',1703790.17,1704199.48,0.00,0.00,409.31,304526.64,0.00,0.00,0.00),('1','146','767','257951',4905818,'2940','325',197286.33,197330.61,0.00,0.00,44.28,32944.32,0.00,0.00,0.00),('1','146','767','257952',4905819,'2138','325',1704199.48,1706898.17,0.00,0.00,2698.69,2007825.36,0.00,0.00,0.00),('1','146','767','257952',4905820,'2940','325',197330.61,197835.56,0.00,0.00,504.95,375682.80,0.00,0.00,0.00),('1','146','767','257953',4905821,'2138','325',1706898.17,1707740.43,0.00,0.00,842.26,626641.44,0.00,0.00,0.00),('1','146','767','257953',4905822,'2940','325',197835.56,198406.94,0.00,0.00,571.38,425106.72,0.00,0.00,0.00),('1','146','767','257954',4905823,'2138','325',1707740.43,1709830.39,0.00,0.00,2089.96,1538210.56,0.00,0.00,0.00),('1','146','767','257954',4905824,'2940','325',198406.94,199016.17,0.00,0.00,609.23,448393.28,0.00,0.00,0.00),('1','146','767','257955',4905825,'2138','325',1709830.39,1712137.26,0.00,0.00,2306.87,1697856.32,0.00,0.00,0.00),('1','146','767','257955',4905826,'2940','325',199016.17,199457.21,0.00,0.00,441.04,324605.44,0.00,0.00,0.00),('1','146','767','257956',4905827,'2138','325',1712137.26,1712299.72,0.00,0.00,162.46,119570.56,0.00,0.00,0.00),('1','146','767','257956',4905828,'2940','325',199457.21,199489.81,0.00,0.00,32.60,23993.60,0.00,0.00,0.00),('1','146','767','257957',4905829,'2138','325',1712299.72,1713089.12,0.00,0.00,789.40,580998.40,0.00,0.00,0.00),('1','146','767','257957',4905830,'2940','325',199489.81,199492.53,0.00,0.00,2.72,2001.92,0.00,0.00,0.00),('1','146','767','257958',4905831,'2138','325',1713089.12,1713089.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257958',4905832,'2940','325',199492.53,199492.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257959',4905833,'2138','325',1713089.12,1714457.38,0.00,0.00,1368.26,1007039.36,0.00,0.00,0.00),('1','146','767','257959',4905834,'2940','325',199492.53,199929.62,0.00,0.00,437.09,321698.24,0.00,0.00,0.00),('1','146','767','257960',4905835,'2138','325',1714457.38,1717225.19,0.00,0.00,2767.81,2037108.16,0.00,0.00,0.00),('1','146','767','257960',4905836,'2940','325',199929.62,200607.59,0.00,0.00,677.97,498985.92,0.00,0.00,0.00),('1','146','767','257961',4905837,'2138','325',1717225.19,1719894.08,0.00,0.00,2668.89,1964303.04,0.00,0.00,0.00),('1','146','767','257961',4905838,'2940','325',200607.59,200982.87,0.00,0.00,375.28,276206.08,0.00,0.00,0.00),('1','146','767','257962',4905839,'2138','325',1719894.08,1721613.89,0.00,0.00,1719.81,1265780.16,0.00,0.00,0.00),('1','146','767','257962',4905840,'2940','325',200982.87,201432.42,0.00,0.00,449.55,330868.80,0.00,0.00,0.00),('1','146','767','257963',4905841,'2138','325',1721613.89,1724215.29,0.00,0.00,2601.40,1914630.40,0.00,0.00,0.00),('1','146','767','257963',4905842,'2940','325',201432.42,202068.56,0.00,0.00,636.14,468199.04,0.00,0.00,0.00),('1','146','767','257964',4905843,'2138','325',1724215.29,1726136.30,0.00,0.00,1921.01,1413863.36,0.00,0.00,0.00),('1','146','767','257964',4905844,'2940','325',202068.56,202270.50,0.00,0.00,201.94,148627.84,0.00,0.00,0.00),('1','146','767','257965',4905845,'2138','325',1726136.30,1728529.66,0.00,0.00,2393.36,1761512.96,0.00,0.00,0.00),('1','146','767','257965',4905846,'2940','325',202270.50,202624.85,0.00,0.00,354.35,260801.60,0.00,0.00,0.00),('1','146','767','257966',4905847,'2138','325',1728529.66,1730763.91,0.00,0.00,2234.25,1644408.00,0.00,0.00,0.00),('1','146','767','257966',4905848,'2940','325',202624.85,202884.98,0.00,0.00,260.13,191455.68,0.00,0.00,0.00),('1','146','767','257967',4905849,'2138','325',1730763.91,1733519.64,0.00,0.00,2755.73,2028217.28,0.00,0.00,0.00),('1','146','767','257967',4905850,'2940','325',202884.98,203341.91,0.00,0.00,456.93,336300.48,0.00,0.00,0.00),('1','146','767','257968',4905851,'2138','325',1733519.64,1735206.56,0.00,0.00,1686.92,1241573.12,0.00,0.00,0.00),('1','146','767','257968',4905852,'2940','325',203341.91,203601.42,0.00,0.00,259.51,190999.36,0.00,0.00,0.00),('1','146','767','257969',4905853,'2138','325',1735206.56,1735972.25,0.00,0.00,765.69,563547.84,0.00,0.00,0.00),('1','146','767','257969',4905854,'2940','325',203601.42,203693.71,0.00,0.00,92.29,67925.44,0.00,0.00,0.00),('1','146','767','257970',4905855,'2138','325',1735972.25,1738461.59,0.00,0.00,2489.34,1832154.24,0.00,0.00,0.00),('1','146','767','257970',4905856,'2940','325',203693.71,204167.08,0.00,0.00,473.37,348400.32,0.00,0.00,0.00),('1','146','767','257971',4905857,'2138','325',1738461.59,1739325.79,0.00,0.00,864.20,636051.20,0.00,0.00,0.00),('1','146','767','257971',4905858,'2940','325',204167.08,204625.59,0.00,0.00,458.51,337463.36,0.00,0.00,0.00),('1','146','767','257972',4905859,'2138','325',1739325.79,1740778.78,0.00,0.00,1452.99,1069400.64,0.00,0.00,0.00),('1','146','767','257972',4905860,'2940','325',204625.59,205046.11,0.00,0.00,420.52,309502.72,0.00,0.00,0.00),('1','146','767','257973',4905861,'2138','325',1740778.78,1743420.17,0.00,0.00,2641.39,1944063.04,0.00,0.00,0.00),('1','146','767','257973',4905862,'2940','325',205046.11,205591.23,0.00,0.00,545.12,401208.32,0.00,0.00,0.00),('1','146','767','257974',4905863,'2138','325',1743420.17,1743420.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257974',4905864,'2940','325',205591.23,205591.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','257975',4905865,'2138','325',1743420.17,1745991.18,0.00,0.00,2571.01,1892263.36,0.00,0.00,0.00),('1','146','767','257975',4905866,'2940','325',205591.23,206285.62,0.00,0.00,694.39,511071.04,0.00,0.00,0.00),('1','146','767','257976',4905867,'2138','325',1745991.18,1747814.02,0.00,0.00,1822.84,1341610.24,0.00,0.00,0.00),('1','146','767','257976',4905868,'2940','325',206285.62,206663.95,0.00,0.00,378.33,278450.88,0.00,0.00,0.00),('1','146','767','257977',4905869,'2138','325',1747814.02,1750983.77,0.00,0.00,3169.75,2332936.00,0.00,0.00,0.00),('1','146','767','257977',4905870,'2940','325',206663.95,207273.80,0.00,0.00,609.85,448849.60,0.00,0.00,0.00),('1','146','767','257978',4905871,'2138','325',1750983.77,1751952.63,0.00,0.00,968.86,713080.96,0.00,0.00,0.00),('1','146','767','257978',4905872,'2940','325',207273.80,207460.61,0.00,0.00,186.81,137492.16,0.00,0.00,0.00),('1','146','767','257979',4905873,'2138','325',1751952.63,1753778.98,0.00,0.00,1826.35,1344193.60,0.00,0.00,0.00),('1','146','767','257979',4905874,'2940','325',207460.61,207915.59,0.00,0.00,454.98,334865.28,0.00,0.00,0.00),('1','146','767','257980',4905875,'2138','325',1753778.98,1755831.88,0.00,0.00,2052.90,1510934.40,0.00,0.00,0.00),('1','146','767','257980',4905876,'2940','325',207915.59,208781.01,0.00,0.00,865.42,636949.12,0.00,0.00,0.00),('1','146','767','257981',4905877,'2138','325',1755831.88,1756037.60,0.00,0.00,205.72,157170.08,0.00,0.00,0.00),('1','146','767','257981',4905878,'2940','325',208781.01,208820.67,0.00,0.00,39.66,30300.24,0.00,0.00,0.00),('1','146','767','257982',4905879,'2138','325',1756037.60,1758641.55,0.00,0.00,2603.95,1989417.80,0.00,0.00,0.00),('1','146','767','257982',4905880,'2940','325',208820.67,209379.55,0.00,0.00,558.88,426984.32,0.00,0.00,0.00),('1','146','767','257983',4905881,'2138','325',1758641.55,1758739.52,0.00,0.00,97.97,74849.08,0.00,0.00,0.00),('1','146','767','257983',4905882,'2940','325',209379.55,209461.03,0.00,0.00,81.48,62250.72,0.00,0.00,0.00),('1','146','767','257984',4905883,'2138','325',1758739.52,1760257.15,0.00,0.00,1517.63,1159469.32,0.00,0.00,0.00),('1','146','767','257984',4905884,'2940','325',209461.03,210108.81,0.00,0.00,647.78,494903.92,0.00,0.00,0.00),('1','146','767','257985',4905885,'2138','325',1760257.15,1761015.33,0.00,0.00,758.18,579249.52,0.00,0.00,0.00),('1','146','767','257985',4905886,'2940','325',210108.81,210303.97,0.00,0.00,195.16,149102.24,0.00,0.00,0.00),('1','146','767','257986',4905887,'2138','325',1761015.33,1761882.84,0.00,0.00,867.51,662777.64,0.00,0.00,0.00),('1','146','767','257986',4905888,'2940','325',210303.97,210355.92,0.00,0.00,51.95,39689.80,0.00,0.00,0.00),('1','146','767','257987',4905889,'2138','325',1761882.84,1764559.25,0.00,0.00,2676.41,2001954.68,0.00,0.00,0.00),('1','146','767','257987',4905890,'2940','325',210355.92,210448.04,0.00,0.00,92.12,68905.76,0.00,0.00,0.00),('1','146','767','257988',4905891,'2138','325',1764559.25,1767076.29,0.00,0.00,2517.04,1882745.92,0.00,0.00,0.00),('1','146','767','257988',4905892,'2940','325',210448.04,210494.23,0.00,0.00,46.19,34550.12,0.00,0.00,0.00),('1','146','767','257989',4905893,'2138','325',1767076.29,1769767.47,0.00,0.00,2691.18,2013002.64,0.00,0.00,0.00),('1','146','767','257989',4905894,'2940','325',210494.23,210742.83,0.00,0.00,248.60,185952.80,0.00,0.00,0.00),('1','146','767','257990',4905895,'2138','325',1769767.47,1772095.85,0.00,0.00,2328.38,1741628.24,0.00,0.00,0.00),('1','146','767','257990',4905896,'2940','325',210742.83,210755.53,0.00,0.00,12.70,9499.60,0.00,0.00,0.00),('1','146','767','257991',4905897,'2138','325',1772095.85,1775043.11,0.00,0.00,2947.26,2204550.48,0.00,0.00,0.00),('1','146','767','257991',4905898,'2940','325',210755.53,210805.12,0.00,0.00,49.59,37093.32,0.00,0.00,0.00),('1','146','767','257992',4905899,'2138','325',1775043.11,1776465.84,0.00,0.00,1422.73,1064202.04,0.00,0.00,0.00),('1','146','767','257992',4905900,'2940','325',210805.12,210863.14,0.00,0.00,58.02,43398.96,0.00,0.00,0.00),('1','146','767','257993',4905901,'2138','325',1776465.84,1777048.82,0.00,0.00,582.98,436069.04,0.00,0.00,0.00),('1','146','767','257993',4905902,'2940','325',210863.14,210879.52,0.00,0.00,16.38,12252.24,0.00,0.00,0.00),('1','146','767','257994',4905903,'2138','325',1777048.82,1779810.47,0.00,0.00,2761.65,2065714.20,0.00,0.00,0.00),('1','146','767','257994',4905904,'2940','325',210879.52,211572.24,0.00,0.00,692.72,518154.56,0.00,0.00,0.00),('1','146','767','257995',4905905,'2138','325',1779810.47,1780323.78,0.00,0.00,513.31,383955.88,0.00,0.00,0.00),('1','146','767','257995',4905906,'2940','325',211572.24,211638.10,0.00,0.00,65.86,49263.28,0.00,0.00,0.00),('1','146','767','257996',4905907,'2138','325',1780323.78,1780634.24,0.00,0.00,310.46,235949.60,0.00,0.00,0.00),('1','146','767','257996',4905908,'2940','325',211638.10,211693.89,0.00,0.00,55.79,42400.40,0.00,0.00,0.00),('1','146','767','257997',4905909,'2138','325',1780634.24,1781961.76,0.00,0.00,1327.52,1008915.20,0.00,0.00,0.00),('1','146','767','257997',4905910,'2940','325',211693.89,211937.25,0.00,0.00,243.36,184953.60,0.00,0.00,0.00),('1','146','767','257998',4905911,'2138','325',1781961.76,1784809.59,0.00,0.00,2847.83,2164350.80,0.00,0.00,0.00),('1','146','767','257998',4905912,'2940','325',211937.25,212148.30,0.00,0.00,211.05,160398.00,0.00,0.00,0.00),('1','146','767','257999',4905913,'2138','325',1784809.59,1786320.54,0.00,0.00,1510.95,1148322.00,0.00,0.00,0.00),('1','146','767','257999',4905914,'2940','325',212148.30,212162.77,0.00,0.00,14.47,10997.20,0.00,0.00,0.00),('1','146','767','258000',4905915,'2138','325',1786320.54,1786320.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258000',4905916,'2940','325',212162.77,212162.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258001',4905917,'2138','325',1786320.54,1786845.75,0.00,0.00,525.21,399159.60,0.00,0.00,0.00),('1','146','767','258001',4905918,'2940','325',212162.77,212162.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258002',4905919,'2138','325',1786845.75,1790325.90,0.00,0.00,3480.15,2644914.00,0.00,0.00,0.00),('1','146','767','258002',4905920,'2940','325',212162.77,212976.56,0.00,0.00,813.79,618480.40,0.00,0.00,0.00),('1','146','767','258003',4905921,'2138','325',1790325.90,1790767.59,0.00,0.00,441.69,335684.40,0.00,0.00,0.00),('1','146','767','258003',4905922,'2940','325',212976.56,213014.59,0.00,0.00,38.03,28902.80,0.00,0.00,0.00),('1','146','767','258004',4905923,'2138','325',1790767.59,1792716.74,0.00,0.00,1949.15,1481354.00,0.00,0.00,0.00),('1','146','767','258004',4905924,'2940','325',213014.59,213240.44,0.00,0.00,225.85,171646.00,0.00,0.00,0.00),('1','146','767','258005',4905925,'2138','325',1792716.74,1795388.19,0.00,0.00,2671.45,2030302.00,0.00,0.00,0.00),('1','146','767','258005',4905926,'2940','325',213240.44,213285.70,0.00,0.00,45.26,34397.60,0.00,0.00,0.00),('1','146','767','258006',4905927,'2138','325',1795388.19,1795388.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258006',4905928,'2940','325',213285.70,213285.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258007',4905929,'2138','325',1795388.19,1795934.78,0.00,0.00,546.59,415408.40,0.00,0.00,0.00),('1','146','767','258007',4905930,'2940','325',213285.70,213285.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258008',4905931,'2138','325',1795934.78,1798985.11,0.00,0.00,3050.33,2318250.80,0.00,0.00,0.00),('1','146','767','258008',4905932,'2940','325',213285.70,213593.64,0.00,0.00,307.94,234034.40,0.00,0.00,0.00),('1','146','767','258009',4905933,'2138','325',1798985.11,1800692.72,0.00,0.00,1707.61,1366088.00,0.00,0.00,0.00),('1','146','767','258009',4905934,'2940','325',213593.64,213662.39,0.00,0.00,68.75,55000.00,0.00,0.00,0.00),('1','146','767','258010',4905935,'2138','325',1800692.72,1801362.68,0.00,0.00,669.96,535968.00,0.00,0.00,0.00),('1','146','767','258010',4905936,'2940','325',213662.39,213677.89,0.00,0.00,15.50,12400.00,0.00,0.00,0.00),('1','146','767','258011',4905937,'2138','325',1801362.68,1803520.06,0.00,0.00,2157.38,1725904.00,0.00,0.00,0.00),('1','146','767','258011',4905938,'2940','325',213677.89,214268.79,0.00,0.00,590.90,472720.00,0.00,0.00,0.00),('1','146','767','258012',4905939,'2138','325',1803520.06,1804763.13,0.00,0.00,1243.07,994456.00,0.00,0.00,0.00),('1','146','767','258012',4905940,'2940','325',214268.79,214275.04,0.00,0.00,6.25,5000.00,0.00,0.00,0.00),('1','146','767','258013',4905941,'2138','325',1804763.13,1804763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258013',4905942,'2940','325',214275.04,214275.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258014',4905943,'2138','325',1804763.13,1805651.04,0.00,0.00,887.91,710328.00,0.00,0.00,0.00),('1','146','767','258014',4905944,'2940','325',214275.04,214275.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258015',4905945,'2138','325',1805651.04,1806142.85,0.00,0.00,491.81,393448.00,0.00,0.00,0.00),('1','146','767','258015',4905946,'2940','325',214275.04,214321.79,0.00,0.00,46.75,37400.00,0.00,0.00,0.00),('1','146','767','258016',4905947,'2138','325',1806142.85,1807668.75,0.00,0.00,1525.90,1159684.00,0.00,0.00,0.00),('1','146','767','258016',4905948,'2940','325',214321.79,214742.23,0.00,0.00,420.44,319534.40,0.00,0.00,0.00),('1','146','767','258017',4905949,'2138','325',1807668.75,1809450.58,0.00,0.00,1781.83,1354190.80,0.00,0.00,0.00),('1','146','767','258017',4905950,'2940','325',214742.23,214776.64,0.00,0.00,34.41,26151.60,0.00,0.00,0.00),('1','146','767','258018',4905951,'2138','325',1809450.58,1809450.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258018',4905952,'2940','325',214776.64,214776.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258019',4905953,'2138','325',1809450.58,1810041.48,0.00,0.00,590.90,449084.00,0.00,0.00,0.00),('1','146','767','258019',4905954,'2940','325',214776.64,214789.14,0.00,0.00,12.50,9500.00,0.00,0.00,0.00),('1','146','767','258020',4905955,'2138','325',1810041.48,1812472.45,0.00,0.00,2430.97,1847537.20,0.00,0.00,0.00),('1','146','767','258020',4905956,'2940','325',214789.14,215195.05,0.00,0.00,405.91,308491.60,0.00,0.00,0.00),('1','146','767','258021',4905957,'2138','325',1812472.45,1813164.38,0.00,0.00,691.93,525866.80,0.00,0.00,0.00),('1','146','767','258021',4905958,'2940','325',215195.05,215195.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258022',4905959,'2138','325',1813164.38,1813239.38,0.00,0.00,75.00,57000.00,0.00,0.00,0.00),('1','146','767','258022',4905960,'2940','325',215195.05,215498.47,0.00,0.00,303.42,230599.20,0.00,0.00,0.00),('1','146','767','258023',4905961,'2138','325',1813239.38,1815877.47,0.00,0.00,2638.09,2004948.40,0.00,0.00,0.00),('1','146','767','258023',4905962,'2940','325',215498.47,215516.23,0.00,0.00,17.76,13497.60,0.00,0.00,0.00),('1','146','767','258024',4905963,'2138','325',1815877.47,1816485.37,0.00,0.00,607.90,462004.00,0.00,0.00,0.00),('1','146','767','258024',4905964,'2940','325',215516.23,215516.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258025',4905965,'2138','325',1816485.37,1816485.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258025',4905966,'2940','325',215516.23,215516.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258026',4905967,'2138','325',1816485.37,1818015.40,0.00,0.00,1530.03,1162822.80,0.00,0.00,0.00),('1','146','767','258026',4905968,'2940','325',215516.23,215516.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258027',4905969,'2138','325',1818015.40,1820461.47,0.00,0.00,2446.07,1859013.20,0.00,0.00,0.00),('1','146','767','258027',4905970,'2940','325',215516.23,215800.78,0.00,0.00,284.55,216258.00,0.00,0.00,0.00),('1','146','767','258028',4905971,'2138','325',1820461.47,1821547.83,0.00,0.00,1086.36,825633.60,0.00,0.00,0.00),('1','146','767','258028',4905972,'2940','325',215800.78,215803.41,0.00,0.00,2.63,1998.80,0.00,0.00,0.00),('1','146','767','258029',4905973,'2138','325',1821547.83,1821547.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258029',4905974,'2940','325',215803.41,215803.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258030',4905975,'2138','325',1821547.83,1822228.75,0.00,0.00,680.92,517499.20,0.00,0.00,0.00),('1','146','767','258030',4905976,'2940','325',215803.41,215817.49,0.00,0.00,14.08,10700.80,0.00,0.00,0.00),('1','146','767','258031',4905977,'2138','325',1822228.75,1824048.36,0.00,0.00,1819.61,1382903.60,0.00,0.00,0.00),('1','146','767','258031',4905978,'2940','325',215817.49,216179.19,0.00,0.00,361.70,274892.00,0.00,0.00,0.00),('1','146','767','258032',4905979,'2138','325',1824048.36,1825797.87,0.00,0.00,1749.51,1329627.60,0.00,0.00,0.00),('1','146','767','258032',4905980,'2940','325',216179.19,216193.79,0.00,0.00,14.60,11096.00,0.00,0.00,0.00),('1','146','767','258033',4905981,'2138','325',1825797.87,1826399.37,0.00,0.00,601.50,457140.00,0.00,0.00,0.00),('1','146','767','258033',4905982,'2940','325',216193.79,216281.31,0.00,0.00,87.52,66515.20,0.00,0.00,0.00),('1','146','767','258034',4905983,'2138','325',1826399.37,1828661.02,0.00,0.00,2261.65,1718854.00,0.00,0.00,0.00),('1','146','767','258034',4905984,'2940','325',216281.31,216614.60,0.00,0.00,333.29,253300.40,0.00,0.00,0.00),('1','146','767','258035',4905985,'2138','325',1828661.02,1830140.27,0.00,0.00,1479.25,1124230.00,0.00,0.00,0.00),('1','146','767','258035',4905986,'2940','325',216614.60,216820.51,0.00,0.00,205.91,156491.60,0.00,0.00,0.00),('1','146','767','258036',4905987,'2138','325',1830140.27,1830707.38,0.00,0.00,567.11,431003.60,0.00,0.00,0.00),('1','146','767','258036',4905988,'2940','325',216820.51,216846.83,0.00,0.00,26.32,20003.20,0.00,0.00,0.00),('1','146','767','258037',4905989,'2138','325',1830707.38,1833260.75,0.00,0.00,2553.37,1940561.20,0.00,0.00,0.00),('1','146','767','258037',4905990,'2940','325',216846.83,216903.27,0.00,0.00,56.44,42894.40,0.00,0.00,0.00),('1','146','767','258038',4905991,'2138','325',1833260.75,1834637.15,0.00,0.00,1376.40,1046064.00,0.00,0.00,0.00),('1','146','767','258038',4905992,'2940','325',216903.27,217062.87,0.00,0.00,159.60,121296.00,0.00,0.00,0.00),('1','146','767','258039',4905993,'2138','325',1834637.15,1834637.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258039',4905994,'2940','325',217062.87,217062.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258040',4905995,'2138','325',1834637.15,1835230.17,0.00,0.00,593.02,450695.20,0.00,0.00,0.00),('1','146','767','258040',4905996,'2940','325',217062.87,217113.14,0.00,0.00,50.27,38205.20,0.00,0.00,0.00),('1','146','767','258041',4905997,'2138','325',1835230.17,1837944.52,0.00,0.00,2714.35,2062906.00,0.00,0.00,0.00),('1','146','767','258041',4905998,'2940','325',217113.14,217126.30,0.00,0.00,13.16,10001.60,0.00,0.00,0.00),('1','146','767','258042',4905999,'2138','325',1837944.52,1839431.31,0.00,0.00,1486.79,1129960.40,0.00,0.00,0.00),('1','146','767','258042',4906000,'2940','325',217126.30,217346.68,0.00,0.00,220.38,167488.80,0.00,0.00,0.00),('1','146','767','258043',4906001,'2138','325',1839431.31,1839431.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258043',4906002,'2940','325',217346.68,217346.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258044',4906003,'2138','325',1839431.31,1839542.57,0.00,0.00,111.26,84557.60,0.00,0.00,0.00),('1','146','767','258044',4906004,'2940','325',217346.68,217377.08,0.00,0.00,30.40,23104.00,0.00,0.00,0.00),('1','146','767','258045',4906005,'2138','325',1839542.57,1841974.30,0.00,0.00,2431.73,1848114.80,0.00,0.00,0.00),('1','146','767','258045',4906006,'2940','325',217377.08,217652.35,0.00,0.00,275.27,209205.20,0.00,0.00,0.00),('1','146','767','258046',4906007,'2138','325',1841974.30,1844165.45,0.00,0.00,2191.15,1665274.00,0.00,0.00,0.00),('1','146','767','258046',4906008,'2940','325',217652.35,217677.35,0.00,0.00,25.00,19000.00,0.00,0.00,0.00),('1','146','767','258047',4906009,'2138','325',1844165.45,1844165.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258047',4906010,'2940','325',217677.35,217677.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258048',4906011,'2138','325',1844165.45,1844536.23,0.00,0.00,370.78,281792.80,0.00,0.00,0.00),('1','146','767','258048',4906012,'2940','325',217677.35,217677.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258049',4906013,'2138','325',1844536.23,1847314.82,0.00,0.00,2778.59,2111728.40,0.00,0.00,0.00),('1','146','767','258049',4906014,'2940','325',217677.35,217757.48,0.00,0.00,80.13,60898.80,0.00,0.00,0.00),('1','146','767','258050',4906015,'2138','325',1847314.82,1849723.95,0.00,0.00,2409.13,1839678.80,0.00,0.00,0.00),('1','146','767','258050',4906016,'2940','325',217757.48,217996.57,0.00,0.00,239.09,181708.40,0.00,0.00,0.00),('1','146','767','258051',4906017,'2138','325',1849723.95,1850031.95,0.00,0.00,308.00,234080.00,0.00,0.00,0.00),('1','146','767','258051',4906018,'2940','325',217996.57,217996.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258052',4906019,'2138','325',1850031.95,1850031.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258052',4906020,'2940','325',217996.57,217996.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258053',4906021,'2138','325',1850031.95,1850700.56,0.00,0.00,668.61,508143.60,0.00,0.00,0.00),('1','146','767','258053',4906022,'2940','325',217996.57,218016.57,0.00,0.00,20.00,15200.00,0.00,0.00,0.00),('1','146','767','258054',4906023,'2138','325',1850700.56,1852611.55,0.00,0.00,1910.99,1452352.40,0.00,0.00,0.00),('1','146','767','258054',4906024,'2940','325',218016.57,218362.74,0.00,0.00,346.17,263089.20,0.00,0.00,0.00),('1','146','767','258055',4906025,'2138','325',1852611.55,1854706.32,0.00,0.00,2094.77,1592025.20,0.00,0.00,0.00),('1','146','767','258055',4906026,'2940','325',218362.74,218381.30,0.00,0.00,18.56,14105.60,0.00,0.00,0.00),('1','146','767','258056',4906027,'2138','325',1854706.32,1854706.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258056',4906028,'2940','325',218381.30,218381.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258057',4906029,'2138','325',1854706.32,1857139.88,0.00,0.00,2433.56,1849505.60,0.00,0.00,0.00),('1','146','767','258057',4906030,'2940','325',218381.30,218666.47,0.00,0.00,285.17,216729.20,0.00,0.00,0.00),('1','146','767','258058',4906031,'2138','325',1857139.88,1858959.21,0.00,0.00,1819.33,1382690.80,0.00,0.00,0.00),('1','146','767','258058',4906032,'2940','325',218666.47,219078.41,0.00,0.00,411.94,313074.40,0.00,0.00,0.00),('1','146','767','258059',4906033,'2138','325',1858959.21,1861591.24,0.00,0.00,2632.03,2000342.80,0.00,0.00,0.00),('1','146','767','258059',4906034,'2940','325',219078.41,219132.29,0.00,0.00,53.88,40948.80,0.00,0.00,0.00),('1','146','767','258060',4906035,'2138','325',1861591.24,1863866.45,0.00,0.00,2275.21,1729159.60,0.00,0.00,0.00),('1','146','767','258060',4906036,'2940','325',219132.29,219132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258061',4906037,'2138','325',1863866.45,1863866.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258061',4906038,'2940','325',219132.29,219132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258062',4906039,'2138','325',1863866.45,1866453.35,0.00,0.00,2586.90,1966044.00,0.00,0.00,0.00),('1','146','767','258062',4906040,'2940','325',219132.29,219269.42,0.00,0.00,137.13,104218.80,0.00,0.00,0.00),('1','146','767','258063',4906041,'2138','325',1866453.35,1868602.62,0.00,0.00,2149.27,1633445.20,0.00,0.00,0.00),('1','146','767','258063',4906042,'2940','325',219269.42,219269.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258064',4906043,'2138','325',1868602.62,1868940.62,0.00,0.00,338.00,256880.00,0.00,0.00,0.00),('1','146','767','258064',4906044,'2940','325',219269.42,219294.42,0.00,0.00,25.00,19000.00,0.00,0.00,0.00),('1','146','767','258065',4906045,'2138','325',1868940.62,1868940.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258065',4906046,'2940','325',219294.42,219294.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258066',4906047,'2138','325',1868940.62,1870194.06,0.00,0.00,1253.44,952614.40,0.00,0.00,0.00),('1','146','767','258066',4906048,'2940','325',219294.42,219520.35,0.00,0.00,225.93,171706.80,0.00,0.00,0.00),('1','146','767','258067',4906049,'2138','325',1870194.06,1872740.36,0.00,0.00,2546.30,1935188.00,0.00,0.00,0.00),('1','146','767','258067',4906050,'2940','325',219520.35,219520.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258068',4906051,'2138','325',1872740.36,1873608.01,0.00,0.00,867.65,659414.00,0.00,0.00,0.00),('1','146','767','258068',4906052,'2940','325',219520.35,219586.40,0.00,0.00,66.05,50198.00,0.00,0.00,0.00),('1','146','767','258069',4906053,'2138','325',1873608.01,1873608.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258069',4906054,'2940','325',219586.40,219586.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258070',4906055,'2138','325',1873608.01,1874598.12,0.00,0.00,990.11,752483.60,0.00,0.00,0.00),('1','146','767','258070',4906056,'2940','325',219586.40,219683.18,0.00,0.00,96.78,73552.80,0.00,0.00,0.00),('1','146','767','258071',4906057,'2138','325',1874598.12,1877110.87,0.00,0.00,2512.75,1909690.00,0.00,0.00,0.00),('1','146','767','258071',4906058,'2940','325',219683.18,219683.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258072',4906059,'2138','325',1877110.87,1878408.65,0.00,0.00,1297.78,986312.80,0.00,0.00,0.00),('1','146','767','258072',4906060,'2940','325',219683.18,219732.39,0.00,0.00,49.21,37399.60,0.00,0.00,0.00),('1','146','767','258073',4906061,'2138','325',1878408.65,1878408.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258073',4906062,'2940','325',219732.39,219732.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258074',4906063,'2138','325',1878408.65,1879669.59,0.00,0.00,1260.94,958314.40,0.00,0.00,0.00),('1','146','767','258074',4906064,'2940','325',219732.39,219779.37,0.00,0.00,46.98,35704.80,0.00,0.00,0.00),('1','146','767','258075',4906065,'2138','325',1879669.59,1882005.38,0.00,0.00,2335.79,1775200.40,0.00,0.00,0.00),('1','146','767','258075',4906066,'2940','325',219779.37,219944.43,0.00,0.00,165.06,125445.60,0.00,0.00,0.00),('1','146','767','258076',4906067,'2138','325',1882005.38,1883143.58,0.00,0.00,1138.20,865032.00,0.00,0.00,0.00),('1','146','767','258076',4906068,'2940','325',219944.43,219944.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258077',4906069,'2138','325',1883143.58,1883143.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258077',4906070,'2940','325',219944.43,219944.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258078',4906071,'2138','325',1883143.58,1884364.24,0.00,0.00,1220.66,927701.60,0.00,0.00,0.00),('1','146','767','258078',4906072,'2940','325',219944.43,219944.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258079',4906073,'2138','325',1884364.24,1886581.16,0.00,0.00,2216.92,1684859.20,0.00,0.00,0.00),('1','146','767','258079',4906074,'2940','325',219944.43,219959.56,0.00,0.00,15.13,11498.80,0.00,0.00,0.00),('1','146','767','258080',4906075,'2138','325',1886581.16,1888059.05,0.00,0.00,1477.89,1123196.40,0.00,0.00,0.00),('1','146','767','258080',4906076,'2940','325',219959.56,220132.98,0.00,0.00,173.42,131799.20,0.00,0.00,0.00),('1','146','767','258081',4906077,'2138','325',1888059.05,1888059.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258081',4906078,'2940','325',220132.98,220132.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258082',4906079,'2138','325',1888059.05,1888819.69,0.00,0.00,760.64,578086.40,0.00,0.00,0.00),('1','146','767','258082',4906080,'2940','325',220132.98,220143.51,0.00,0.00,10.53,8002.80,0.00,0.00,0.00),('1','146','767','258083',4906081,'2138','325',1888819.69,1891333.98,0.00,0.00,2514.29,1910860.40,0.00,0.00,0.00),('1','146','767','258083',4906082,'2940','325',220143.51,220227.46,0.00,0.00,83.95,63802.00,0.00,0.00,0.00),('1','146','767','258084',4906083,'2138','325',1891333.98,1891628.84,0.00,0.00,294.86,224093.60,0.00,0.00,0.00),('1','146','767','258084',4906084,'2940','325',220227.46,220299.30,0.00,0.00,71.84,54598.40,0.00,0.00,0.00),('1','146','767','258085',4906085,'2138','325',1891628.84,1893185.85,0.00,0.00,1557.01,1145959.36,0.00,0.00,0.00),('1','146','767','258085',4906086,'2940','325',220299.30,220359.77,0.00,0.00,60.47,44505.92,0.00,0.00,0.00),('1','146','767','258086',4906087,'2138','325',1893185.85,1893222.95,0.00,0.00,37.10,27305.60,0.00,0.00,0.00),('1','146','767','258086',4906088,'2940','325',220359.77,220400.33,0.00,0.00,40.56,29852.16,0.00,0.00,0.00),('1','146','767','258087',4906089,'2138','325',1893222.95,1893222.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258087',4906090,'2940','325',220400.33,220400.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258088',4906091,'2138','325',1893222.95,1894579.60,0.00,0.00,1356.65,998494.40,0.00,0.00,0.00),('1','146','767','258088',4906092,'2940','325',220400.33,220929.28,0.00,0.00,528.95,389307.20,0.00,0.00,0.00),('1','146','767','258089',4906093,'2138','325',1894579.60,1897281.94,0.00,0.00,2702.34,1988922.24,0.00,0.00,0.00),('1','146','767','258089',4906094,'2940','325',220929.28,221422.25,0.00,0.00,492.97,362825.92,0.00,0.00,0.00),('1','146','767','258090',4906095,'2138','325',1897281.94,1897380.38,0.00,0.00,98.44,72451.84,0.00,0.00,0.00),('1','146','767','258090',4906096,'2940','325',221422.25,221422.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258091',4906097,'2138','325',1897380.38,1897380.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258091',4906098,'2940','325',221422.25,221422.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258092',4906099,'2138','325',1897380.38,1900017.34,0.00,0.00,2636.96,1940802.56,0.00,0.00,0.00),('1','146','767','258092',4906100,'2940','325',221422.25,221490.05,0.00,0.00,67.80,49900.80,0.00,0.00,0.00),('1','146','767','258093',4906101,'2138','325',1900017.34,1901778.27,0.00,0.00,1760.93,1296044.48,0.00,0.00,0.00),('1','146','767','258093',4906102,'2940','325',221490.05,221966.82,0.00,0.00,476.77,350902.72,0.00,0.00,0.00),('1','146','767','258094',4906103,'2138','325',1901778.27,1901778.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258094',4906104,'2940','325',221966.82,221966.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258095',4906105,'2138','325',1901778.27,1904416.90,0.00,0.00,2638.63,1942031.68,0.00,0.00,0.00),('1','146','767','258095',4906106,'2940','325',221966.82,221976.88,0.00,0.00,10.06,7404.16,0.00,0.00,0.00),('1','146','767','258096',4906107,'2138','325',1904416.90,1906331.03,0.00,0.00,1914.13,1408799.68,0.00,0.00,0.00),('1','146','767','258096',4906108,'2940','325',221976.88,222439.48,0.00,0.00,462.60,340473.60,0.00,0.00,0.00),('1','146','767','258097',4906109,'2138','325',1906331.03,1906718.65,0.00,0.00,387.62,285288.32,0.00,0.00,0.00),('1','146','767','258097',4906110,'2940','325',222439.48,222439.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258098',4906111,'2138','325',1906718.65,1908820.34,0.00,0.00,2101.69,1546843.84,0.00,0.00,0.00),('1','146','767','258098',4906112,'2940','325',222439.48,222463.23,0.00,0.00,23.75,17480.00,0.00,0.00,0.00),('1','146','767','258099',4906113,'2138','325',1908820.34,1910016.55,0.00,0.00,1196.21,880410.56,0.00,0.00,0.00),('1','146','767','258099',4906114,'2940','325',222463.23,222668.83,0.00,0.00,205.60,151321.60,0.00,0.00,0.00),('1','146','767','258100',4906115,'2138','325',1910016.55,1911656.97,0.00,0.00,1640.42,1207349.12,0.00,0.00,0.00),('1','146','767','258100',4906116,'2940','325',222668.83,222718.69,0.00,0.00,49.86,36696.96,0.00,0.00,0.00),('1','146','767','258101',4906117,'2138','325',1911656.97,1912395.57,0.00,0.00,738.60,543609.60,0.00,0.00,0.00),('1','146','767','258101',4906118,'2940','325',222718.69,222731.88,0.00,0.00,13.19,9707.84,0.00,0.00,0.00),('1','146','767','258102',4906119,'2138','325',1912395.57,1914800.62,0.00,0.00,2405.05,1770116.80,0.00,0.00,0.00),('1','146','767','258102',4906120,'2940','325',222731.88,223193.19,0.00,0.00,461.31,339524.16,0.00,0.00,0.00),('1','146','767','258103',4906121,'2138','325',1914800.62,1916331.65,0.00,0.00,1531.03,1126838.08,0.00,0.00,0.00),('1','146','767','258103',4906122,'2940','325',223193.19,223205.69,0.00,0.00,12.50,9200.00,0.00,0.00,0.00),('1','146','767','258104',4906123,'2138','325',1916331.65,1917191.31,0.00,0.00,859.66,632709.76,0.00,0.00,0.00),('1','146','767','258104',4906124,'2940','325',223205.69,223237.19,0.00,0.00,31.50,23184.00,0.00,0.00,0.00),('1','146','767','258105',4906125,'2138','325',1917191.31,1920028.62,0.00,0.00,2837.31,2088260.16,0.00,0.00,0.00),('1','146','767','258105',4906126,'2940','325',223237.19,223665.97,0.00,0.00,428.78,315582.08,0.00,0.00,0.00),('1','146','767','258106',4906127,'2138','325',1920028.62,1920744.25,0.00,0.00,715.63,526703.68,0.00,0.00,0.00),('1','146','767','258106',4906128,'2940','325',223665.97,223773.32,0.00,0.00,107.35,79009.60,0.00,0.00,0.00),('1','146','767','258107',4906129,'2138','325',1920744.25,1920916.88,0.00,0.00,172.63,127055.68,0.00,0.00,0.00),('1','146','767','258107',4906130,'2940','325',223773.32,223773.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258108',4906131,'2138','325',1920916.88,1922395.35,0.00,0.00,1478.47,1088153.92,0.00,0.00,0.00),('1','146','767','258108',4906132,'2940','325',223773.32,224153.17,0.00,0.00,379.85,279569.60,0.00,0.00,0.00),('1','146','767','258109',4906133,'2138','325',1922395.35,1925699.09,0.00,0.00,3303.74,2431552.64,0.00,0.00,0.00),('1','146','767','258109',4906134,'2940','325',224153.17,224177.63,0.00,0.00,24.46,18002.56,0.00,0.00,0.00),('1','146','767','258110',4906135,'2138','325',1925699.09,1926001.68,0.00,0.00,302.59,222706.24,0.00,0.00,0.00),('1','146','767','258110',4906136,'2940','325',224177.63,224177.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258111',4906137,'2138','325',1926001.68,1928698.74,0.00,0.00,2697.06,1985036.16,0.00,0.00,0.00),('1','146','767','258111',4906138,'2940','325',224177.63,224232.80,0.00,0.00,55.17,40605.12,0.00,0.00,0.00),('1','146','767','258112',4906139,'2138','325',1928698.74,1930493.32,0.00,0.00,1794.58,1320810.88,0.00,0.00,0.00),('1','146','767','258112',4906140,'2940','325',224232.80,224703.84,0.00,0.00,471.04,346685.44,0.00,0.00,0.00),('1','146','767','258113',4906141,'2138','325',1930493.32,1930618.09,0.00,0.00,124.77,91830.72,0.00,0.00,0.00),('1','146','767','258113',4906142,'2940','325',224703.84,224787.19,0.00,0.00,83.35,61345.60,0.00,0.00,0.00),('1','146','767','258114',4906143,'2138','325',1930618.09,1932561.37,0.00,0.00,1943.28,1430254.08,0.00,0.00,0.00),('1','146','767','258114',4906144,'2940','325',224787.19,224805.80,0.00,0.00,18.61,13696.96,0.00,0.00,0.00),('1','146','767','258115',4906145,'2138','325',1932561.37,1934371.71,0.00,0.00,1810.34,1332410.24,0.00,0.00,0.00),('1','146','767','258115',4906146,'2940','325',224805.80,225097.66,0.00,0.00,291.86,214808.96,0.00,0.00,0.00),('1','146','767','258116',4906147,'2138','325',1934371.71,1935955.91,0.00,0.00,1584.20,1165971.20,0.00,0.00,0.00),('1','146','767','258116',4906148,'2940','325',225097.66,225167.16,0.00,0.00,69.50,51152.00,0.00,0.00,0.00),('1','146','767','258117',4906149,'2138','325',1935955.91,1936136.53,0.00,0.00,180.62,132936.32,0.00,0.00,0.00),('1','146','767','258117',4906150,'2940','325',225167.16,225216.62,0.00,0.00,49.46,36402.56,0.00,0.00,0.00),('1','146','767','258118',4906151,'2138','325',1936136.53,1938410.61,0.00,0.00,2274.08,1673722.88,0.00,0.00,0.00),('1','146','767','258118',4906152,'2940','325',225216.62,225222.73,0.00,0.00,6.11,4496.96,0.00,0.00,0.00),('1','146','767','258119',4906153,'2138','325',1938410.61,1940666.42,0.00,0.00,2255.81,1660276.16,0.00,0.00,0.00),('1','146','767','258119',4906154,'2940','325',225222.73,225281.13,0.00,0.00,58.40,42982.40,0.00,0.00,0.00),('1','146','767','258120',4906155,'2138','325',1940666.42,1941226.86,0.00,0.00,560.44,412483.84,0.00,0.00,0.00),('1','146','767','258120',4906156,'2940','325',225281.13,225321.89,0.00,0.00,40.76,29999.36,0.00,0.00,0.00),('1','146','767','258121',4906157,'2138','325',1941226.86,1942330.78,0.00,0.00,1103.92,812485.12,0.00,0.00,0.00),('1','146','767','258121',4906158,'2940','325',225321.89,225597.45,0.00,0.00,275.56,202812.16,0.00,0.00,0.00),('1','146','767','258122',4906159,'2138','325',1942330.78,1943703.90,0.00,0.00,1373.12,1010616.32,0.00,0.00,0.00),('1','146','767','258122',4906160,'2940','325',225597.45,225763.02,0.00,0.00,165.57,121859.52,0.00,0.00,0.00),('1','146','767','258123',4906161,'2138','325',1943703.90,1945543.50,0.00,0.00,1839.60,1353945.60,0.00,0.00,0.00),('1','146','767','258123',4906162,'2940','325',225763.02,225798.36,0.00,0.00,35.34,26010.24,0.00,0.00,0.00),('1','146','767','258124',4906163,'2138','325',1945543.50,1946117.57,0.00,0.00,574.07,422515.52,0.00,0.00,0.00),('1','146','767','258124',4906164,'2940','325',225798.36,225911.40,0.00,0.00,113.04,83197.44,0.00,0.00,0.00),('1','146','767','258125',4906165,'2138','325',1946117.57,1946117.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258125',4906166,'2940','325',225911.40,225911.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258126',4906167,'2138','325',1946117.57,1947533.84,0.00,0.00,1416.27,1042374.72,0.00,0.00,0.00),('1','146','767','258126',4906168,'2940','325',225911.40,226266.15,0.00,0.00,354.75,261096.00,0.00,0.00,0.00),('1','146','767','258127',4906169,'2138','325',1947533.84,1950090.01,0.00,0.00,2556.17,1881341.12,0.00,0.00,0.00),('1','146','767','258127',4906170,'2940','325',226266.15,226266.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258128',4906171,'2138','325',1950090.01,1950916.67,0.00,0.00,826.66,608421.76,0.00,0.00,0.00),('1','146','767','258128',4906172,'2940','325',226266.15,226362.30,0.00,0.00,96.15,70766.40,0.00,0.00,0.00),('1','146','767','258129',4906173,'2138','325',1950916.67,1952239.06,0.00,0.00,1322.39,973279.04,0.00,0.00,0.00),('1','146','767','258129',4906174,'2940','325',226362.30,226687.04,0.00,0.00,324.74,239008.64,0.00,0.00,0.00),('1','146','767','258130',4906175,'2138','325',1952239.06,1954274.94,0.00,0.00,2035.88,1498407.68,0.00,0.00,0.00),('1','146','767','258130',4906176,'2940','325',226687.04,226726.18,0.00,0.00,39.14,28807.04,0.00,0.00,0.00),('1','146','767','258131',4906177,'2138','325',1954274.94,1955565.77,0.00,0.00,1290.83,950050.88,0.00,0.00,0.00),('1','146','767','258131',4906178,'2940','325',226726.18,226980.19,0.00,0.00,254.01,186951.36,0.00,0.00,0.00),('1','146','767','258132',4906179,'2138','325',1955565.77,1956497.94,0.00,0.00,932.17,686077.12,0.00,0.00,0.00),('1','146','767','258132',4906180,'2940','325',226980.19,227066.47,0.00,0.00,86.28,63502.08,0.00,0.00,0.00),('1','146','767','258133',4906181,'2138','325',1956497.94,1958966.54,0.00,0.00,2468.60,1816889.60,0.00,0.00,0.00),('1','146','767','258133',4906182,'2940','325',227066.47,227066.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258134',4906183,'2138','325',1958966.54,1960490.86,0.00,0.00,1524.32,1121899.52,0.00,0.00,0.00),('1','146','767','258134',4906184,'2940','325',227066.47,227488.32,0.00,0.00,421.85,310481.60,0.00,0.00,0.00),('1','146','767','258135',4906185,'2138','325',1960490.86,1960490.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258135',4906186,'2940','325',227488.32,227488.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258136',4906187,'2138','325',1960490.86,1963083.50,0.00,0.00,2592.64,1908183.04,0.00,0.00,0.00),('1','146','767','258136',4906188,'2940','325',227488.32,227553.21,0.00,0.00,64.89,47759.04,0.00,0.00,0.00),('1','146','767','258137',4906189,'2138','325',1963083.50,1965509.53,0.00,0.00,2426.03,1785558.08,0.00,0.00,0.00),('1','146','767','258137',4906190,'2940','325',227553.21,227778.99,0.00,0.00,225.78,166174.08,0.00,0.00,0.00),('1','146','767','258138',4906191,'2138','325',1965509.53,1968182.80,0.00,0.00,2673.27,1967526.72,0.00,0.00,0.00),('1','146','767','258138',4906192,'2940','325',227778.99,228095.16,0.00,0.00,316.17,232701.12,0.00,0.00,0.00),('1','146','767','258139',4906193,'2138','325',1968182.80,1970319.65,0.00,0.00,2136.85,1572721.60,0.00,0.00,0.00),('1','146','767','258139',4906194,'2940','325',228095.16,228107.39,0.00,0.00,12.23,9001.28,0.00,0.00,0.00),('1','146','767','258140',4906195,'2138','325',1970319.65,1970319.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258140',4906196,'2940','325',228107.39,228107.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258141',4906197,'2138','325',1970319.65,1973132.57,0.00,0.00,2812.92,2070309.12,0.00,0.00,0.00),('1','146','767','258141',4906198,'2940','325',228107.39,228118.53,0.00,0.00,11.14,8199.04,0.00,0.00,0.00),('1','146','767','258142',4906199,'2138','325',1973132.57,1975046.57,0.00,0.00,1914.00,1408704.00,0.00,0.00,0.00),('1','146','767','258142',4906200,'2940','325',228118.53,228360.47,0.00,0.00,241.94,178067.84,0.00,0.00,0.00),('1','146','767','258143',4906201,'2138','325',1975046.57,1977531.40,0.00,0.00,2484.83,1828834.88,0.00,0.00,0.00),('1','146','767','258143',4906202,'2940','325',228360.47,228360.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258144',4906203,'2138','325',1977531.40,1980098.87,0.00,0.00,2567.47,1889657.92,0.00,0.00,0.00),('1','146','767','258144',4906204,'2940','325',228360.47,228623.52,0.00,0.00,263.05,193604.80,0.00,0.00,0.00),('1','146','767','258145',4906205,'2138','325',1980098.87,1980364.96,0.00,0.00,266.09,195842.24,0.00,0.00,0.00),('1','146','767','258145',4906206,'2940','325',228623.52,228623.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258146',4906207,'2138','325',1980364.96,1982297.71,0.00,0.00,1932.75,1422504.00,0.00,0.00,0.00),('1','146','767','258146',4906208,'2940','325',228623.52,228649.61,0.00,0.00,26.09,19202.24,0.00,0.00,0.00),('1','146','767','258147',4906209,'2138','325',1982297.71,1984356.96,0.00,0.00,2059.25,1515608.00,0.00,0.00,0.00),('1','146','767','258147',4906210,'2940','325',228649.61,228997.95,0.00,0.00,348.34,256378.24,0.00,0.00,0.00),('1','146','767','258148',4906211,'2138','325',1984356.96,1985538.45,0.00,0.00,1181.49,869576.64,0.00,0.00,0.00),('1','146','767','258148',4906212,'2940','325',228997.95,228997.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258149',4906213,'2138','325',1985538.45,1985646.33,0.00,0.00,107.88,79399.68,0.00,0.00,0.00),('1','146','767','258149',4906214,'2940','325',228997.95,228997.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258150',4906215,'2138','325',1985646.33,1987921.65,0.00,0.00,2275.32,1674635.52,0.00,0.00,0.00),('1','146','767','258150',4906216,'2940','325',228997.95,229201.82,0.00,0.00,203.87,150048.32,0.00,0.00,0.00),('1','146','767','258151',4906217,'2138','325',1987921.65,1990388.29,0.00,0.00,2466.64,1815447.04,0.00,0.00,0.00),('1','146','767','258151',4906218,'2940','325',229201.82,229243.40,0.00,0.00,41.58,30602.88,0.00,0.00,0.00),('1','146','767','258152',4906219,'2138','325',1990388.29,1990554.72,0.00,0.00,166.43,122492.48,0.00,0.00,0.00),('1','146','767','258152',4906220,'2940','325',229243.40,229255.90,0.00,0.00,12.50,9200.00,0.00,0.00,0.00),('1','146','767','258153',4906221,'2138','325',1990554.72,1992144.85,0.00,0.00,1590.13,1170335.68,0.00,0.00,0.00),('1','146','767','258153',4906222,'2940','325',229255.90,229424.67,0.00,0.00,168.77,124214.72,0.00,0.00,0.00),('1','146','767','258154',4906223,'2138','325',1992144.85,1994629.10,0.00,0.00,2484.25,1828408.00,0.00,0.00,0.00),('1','146','767','258154',4906224,'2940','325',229424.67,229731.90,0.00,0.00,307.23,226121.28,0.00,0.00,0.00),('1','146','767','258155',4906225,'2138','325',1994629.10,1995199.81,0.00,0.00,570.71,420042.56,0.00,0.00,0.00),('1','146','767','258155',4906226,'2940','325',229731.90,229731.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258156',4906227,'2138','325',1995199.81,1997259.26,0.00,0.00,2059.45,1515755.20,0.00,0.00,0.00),('1','146','767','258156',4906228,'2940','325',229731.90,229751.90,0.00,0.00,20.00,14720.00,0.00,0.00,0.00),('1','146','767','258157',4906229,'2138','325',1997259.26,1999272.36,0.00,0.00,2013.10,1481641.60,0.00,0.00,0.00),('1','146','767','258157',4906230,'2940','325',229751.90,230010.66,0.00,0.00,258.76,190447.36,0.00,0.00,0.00),('1','146','767','258158',4906231,'2138','325',1999272.36,2000006.64,0.00,0.00,734.28,540430.08,0.00,0.00,0.00),('1','146','767','258158',4906232,'2940','325',230010.66,230010.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258159',4906233,'2138','325',2000006.64,2000990.77,0.00,0.00,984.13,724319.68,0.00,0.00,0.00),('1','146','767','258159',4906234,'2940','325',230010.66,230060.66,0.00,0.00,50.00,36800.00,0.00,0.00,0.00),('1','146','767','258160',4906235,'2138','325',2000990.77,2003000.66,0.00,0.00,2009.89,1479279.04,0.00,0.00,0.00),('1','146','767','258160',4906236,'2940','325',230060.66,230385.88,0.00,0.00,325.22,239361.92,0.00,0.00,0.00),('1','146','767','258161',4906237,'2138','325',2003000.66,2004704.62,0.00,0.00,1703.96,1254114.56,0.00,0.00,0.00),('1','146','767','258161',4906238,'2940','325',230385.88,230392.68,0.00,0.00,6.80,5004.80,0.00,0.00,0.00),('1','146','767','258162',4906239,'2138','325',2004704.62,2005814.36,0.00,0.00,1109.74,816768.64,0.00,0.00,0.00),('1','146','767','258162',4906240,'2940','325',230392.68,230413.41,0.00,0.00,20.73,15257.28,0.00,0.00,0.00),('1','146','767','258163',4906241,'2138','325',2005814.36,2007285.77,0.00,0.00,1471.41,1082957.76,0.00,0.00,0.00),('1','146','767','258163',4906242,'2940','325',230413.41,230626.26,0.00,0.00,212.85,156657.60,0.00,0.00,0.00),('1','146','767','258164',4906243,'2138','325',2007285.77,2009223.29,0.00,0.00,1937.52,1426014.72,0.00,0.00,0.00),('1','146','767','258164',4906244,'2940','325',230626.26,230645.56,0.00,0.00,19.30,14204.80,0.00,0.00,0.00),('1','146','767','258165',4906245,'2138','325',2009223.29,2011324.70,0.00,0.00,2101.41,1546637.76,0.00,0.00,0.00),('1','146','767','258165',4906246,'2940','325',230645.56,230938.23,0.00,0.00,292.67,215405.12,0.00,0.00,0.00),('1','146','767','258166',4906247,'2138','325',2011324.70,2013937.54,0.00,0.00,2612.84,1923050.24,0.00,0.00,0.00),('1','146','767','258166',4906248,'2940','325',230938.23,230977.39,0.00,0.00,39.16,28821.76,0.00,0.00,0.00),('1','146','767','258167',4906249,'2138','325',2013937.54,2015820.13,0.00,0.00,1882.59,1385586.24,0.00,0.00,0.00),('1','146','767','258167',4906250,'2940','325',230977.39,231091.37,0.00,0.00,113.98,83889.28,0.00,0.00,0.00),('1','146','767','258168',4906251,'2138','325',2015820.13,2018675.01,0.00,0.00,2854.88,2101191.68,0.00,0.00,0.00),('1','146','767','258168',4906252,'2940','325',231091.37,231470.61,0.00,0.00,379.24,279120.64,0.00,0.00,0.00),('1','146','767','258169',4906253,'2138','325',2018675.01,2022603.52,0.00,0.00,3928.51,2891383.36,0.00,0.00,0.00),('1','146','767','258169',4906254,'2940','325',231470.61,231470.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258170',4906255,'2138','325',2022603.52,2023839.85,0.00,0.00,1236.33,909938.88,0.00,0.00,0.00),('1','146','767','258170',4906256,'2940','325',231470.61,231575.92,0.00,0.00,105.31,77508.16,0.00,0.00,0.00),('1','146','767','258171',4906257,'2138','325',2023839.85,2024208.87,0.00,0.00,369.02,271598.72,0.00,0.00,0.00),('1','146','767','258171',4906258,'2940','325',231575.92,231689.06,0.00,0.00,113.14,83271.04,0.00,0.00,0.00),('1','146','767','258172',4906259,'2138','325',2024208.87,2027295.87,0.00,0.00,3087.00,2272032.00,0.00,0.00,0.00),('1','146','767','258172',4906260,'2940','325',231689.06,231719.21,0.00,0.00,30.15,22190.40,0.00,0.00,0.00),('1','146','767','258173',4906261,'2138','325',2027295.87,2028694.63,0.00,0.00,1398.76,1029487.36,0.00,0.00,0.00),('1','146','767','258173',4906262,'2940','325',231719.21,231922.93,0.00,0.00,203.72,149937.92,0.00,0.00,0.00),('1','146','767','258174',4906263,'2138','325',2028694.63,2029140.77,0.00,0.00,446.14,328359.04,0.00,0.00,0.00),('1','146','767','258174',4906264,'2940','325',231922.93,232017.28,0.00,0.00,94.35,69441.60,0.00,0.00,0.00),('1','146','767','258175',4906265,'2138','325',2029140.77,2031656.97,0.00,0.00,2516.20,1851923.20,0.00,0.00,0.00),('1','146','767','258175',4906266,'2940','325',232017.28,232567.91,0.00,0.00,550.63,405263.68,0.00,0.00,0.00),('1','146','767','258176',4906267,'2138','325',2031656.97,2033370.51,0.00,0.00,1713.54,1261165.44,0.00,0.00,0.00),('1','146','767','258176',4906268,'2940','325',232567.91,232567.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258177',4906269,'2138','325',2033370.51,2033881.32,0.00,0.00,510.81,375956.16,0.00,0.00,0.00),('1','146','767','258177',4906270,'2940','325',232567.91,232597.05,0.00,0.00,29.14,21447.04,0.00,0.00,0.00),('1','146','767','258178',4906271,'2138','325',2033881.32,2036289.46,0.00,0.00,2408.14,1772391.04,0.00,0.00,0.00),('1','146','767','258178',4906272,'2940','325',232597.05,232887.27,0.00,0.00,290.22,213601.92,0.00,0.00,0.00),('1','146','767','258179',4906273,'2138','325',2036289.46,2038067.66,0.00,0.00,1778.20,1308755.20,0.00,0.00,0.00),('1','146','767','258179',4906274,'2940','325',232887.27,232928.41,0.00,0.00,41.14,30279.04,0.00,0.00,0.00),('1','146','767','258180',4906275,'2138','325',2038067.66,2038952.67,0.00,0.00,885.01,651367.36,0.00,0.00,0.00),('1','146','767','258180',4906276,'2940','325',232928.41,232928.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258181',4906277,'2138','325',2038952.67,2041250.53,0.00,0.00,2297.86,1691224.96,0.00,0.00,0.00),('1','146','767','258181',4906278,'2940','325',232928.41,233523.92,0.00,0.00,595.51,438295.36,0.00,0.00,0.00),('1','146','767','258182',4906279,'2138','325',2041250.53,2042618.24,0.00,0.00,1367.71,1006634.56,0.00,0.00,0.00),('1','146','767','258182',4906280,'2940','325',233523.92,233523.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258183',4906281,'2138','325',2042618.24,2043619.48,0.00,0.00,1001.24,736912.64,0.00,0.00,0.00),('1','146','767','258183',4906282,'2940','325',233523.92,233550.00,0.00,0.00,26.08,19194.88,0.00,0.00,0.00),('1','146','767','258184',4906283,'2138','325',2043619.48,2045628.36,0.00,0.00,2008.88,1478535.68,0.00,0.00,0.00),('1','146','767','258184',4906284,'2940','325',233550.00,233825.76,0.00,0.00,275.76,202959.36,0.00,0.00,0.00),('1','146','767','258185',4906285,'2138','325',2045628.36,2047633.80,0.00,0.00,2005.44,1476003.84,0.00,0.00,0.00),('1','146','767','258185',4906286,'2940','325',233825.76,233825.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258186',4906287,'2138','325',2047633.80,2047633.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258186',4906288,'2940','325',233825.76,233825.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258187',4906289,'2138','325',2047633.80,2047713.89,0.00,0.00,80.09,58946.24,0.00,0.00,0.00),('1','146','767','258187',4906290,'2940','325',233825.76,233825.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258188',4906291,'2138','325',2047713.89,2050348.07,0.00,0.00,2634.18,1938756.48,0.00,0.00,0.00),('1','146','767','258188',4906292,'2940','325',233825.76,234097.53,0.00,0.00,271.77,200022.72,0.00,0.00,0.00),('1','146','767','258189',4906293,'2138','325',2050348.07,2052418.00,0.00,0.00,2069.93,1523468.48,0.00,0.00,0.00),('1','146','767','258189',4906294,'2940','325',234097.53,234323.77,0.00,0.00,226.24,166512.64,0.00,0.00,0.00),('1','146','767','258190',4906295,'2138','325',2052418.00,2052418.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258190',4906296,'2940','325',234323.77,234323.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258191',4906297,'2138','325',2052418.00,2053055.51,0.00,0.00,637.51,469207.36,0.00,0.00,0.00),('1','146','767','258191',4906298,'2940','325',234323.77,234418.07,0.00,0.00,94.30,69404.80,0.00,0.00,0.00),('1','146','767','258192',4906299,'2138','325',2053055.51,2056524.17,0.00,0.00,3468.66,2552933.76,0.00,0.00,0.00),('1','146','767','258192',4906300,'2940','325',234418.07,234447.15,0.00,0.00,29.08,21402.88,0.00,0.00,0.00),('1','146','767','258193',4906301,'2138','325',2056524.17,2057362.10,0.00,0.00,837.93,616716.48,0.00,0.00,0.00),('1','146','767','258193',4906302,'2940','325',234447.15,234545.94,0.00,0.00,98.79,72709.44,0.00,0.00,0.00),('1','146','767','258194',4906303,'2138','325',2057362.10,2058899.55,0.00,0.00,1537.45,1131563.20,0.00,0.00,0.00),('1','146','767','258194',4906304,'2940','325',234545.94,234665.76,0.00,0.00,119.82,88187.52,0.00,0.00,0.00),('1','146','767','258195',4906305,'2138','325',2058899.55,2061120.92,0.00,0.00,2221.37,1634928.32,0.00,0.00,0.00),('1','146','767','258195',4906306,'2940','325',234665.76,235839.44,0.00,0.00,1173.68,863828.48,0.00,0.00,0.00),('1','146','767','258196',4906307,'2138','325',2061120.92,2061861.95,0.00,0.00,741.03,545398.08,0.00,0.00,0.00),('1','146','767','258196',4906308,'2940','325',235839.44,238561.57,0.00,0.00,2722.13,2003487.68,0.00,0.00,0.00),('1','146','767','258197',4906309,'2138','325',2061861.95,2062257.45,0.00,0.00,395.50,291088.00,0.00,0.00,0.00),('1','146','767','258197',4906310,'2940','325',238561.57,240033.83,0.00,0.00,1472.26,1083583.36,0.00,0.00,0.00),('1','146','767','258198',4906311,'2138','325',2062257.45,2062422.93,0.00,0.00,165.48,121793.28,0.00,0.00,0.00),('1','146','767','258198',4906312,'2940','325',240033.83,241160.27,0.00,0.00,1126.44,829059.84,0.00,0.00,0.00),('1','146','767','258199',4906313,'2138','325',2062422.93,2064323.96,0.00,0.00,1901.03,1399158.08,0.00,0.00,0.00),('1','146','767','258199',4906314,'2940','325',241160.27,243059.02,0.00,0.00,1898.75,1397480.00,0.00,0.00,0.00),('1','146','767','258200',4906315,'2138','325',2064323.96,2064323.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258200',4906316,'2940','325',243059.02,243059.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258201',4906317,'2138','325',2064323.96,2064323.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258201',4906318,'2940','325',243059.02,243059.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258202',4906319,'2138','325',2064323.96,2065320.49,0.00,0.00,996.53,733446.08,0.00,0.00,0.00),('1','146','767','258202',4906320,'2940','325',243059.02,245442.88,0.00,0.00,2383.86,1754520.96,0.00,0.00,0.00),('1','146','767','258203',4906321,'2138','325',2065320.49,2065933.51,0.00,0.00,613.02,451182.72,0.00,0.00,0.00),('1','146','767','258203',4906322,'2940','325',245442.88,246569.09,0.00,0.00,1126.21,828890.56,0.00,0.00,0.00),('1','146','767','258204',4906323,'2138','325',2065933.51,2066294.70,0.00,0.00,361.19,265835.84,0.00,0.00,0.00),('1','146','767','258204',4906324,'2940','325',246569.09,246806.26,0.00,0.00,237.17,174557.12,0.00,0.00,0.00),('1','146','767','258205',4906325,'2138','325',2066294.70,2066991.00,0.00,0.00,696.30,512476.80,0.00,0.00,0.00),('1','146','767','258205',4906326,'2940','325',246806.26,248325.16,0.00,0.00,1518.90,1117910.40,0.00,0.00,0.00),('1','146','767','258206',4906327,'2138','325',2066991.00,2067761.44,0.00,0.00,770.44,567043.84,0.00,0.00,0.00),('1','146','767','258206',4906328,'2940','325',248325.16,250212.08,0.00,0.00,1886.92,1388773.12,0.00,0.00,0.00),('1','146','767','258207',4906329,'2138','325',2067761.44,2068400.91,0.00,0.00,639.47,470649.92,0.00,0.00,0.00),('1','146','767','258207',4906330,'2940','325',250212.08,253017.49,0.00,0.00,2805.41,2064781.76,0.00,0.00,0.00),('1','146','767','258208',4906331,'2138','325',2068400.91,2068759.55,0.00,0.00,358.64,263959.04,0.00,0.00,0.00),('1','146','767','258208',4906332,'2940','325',253017.49,254443.53,0.00,0.00,1426.04,1049565.44,0.00,0.00,0.00),('1','146','767','258209',4906333,'2138','325',2068759.55,2068995.05,0.00,0.00,235.50,173328.00,0.00,0.00,0.00),('1','146','767','258209',4906334,'2940','325',254443.53,254469.15,0.00,0.00,25.62,18856.32,0.00,0.00,0.00),('1','146','767','258210',4906335,'2138','325',2068995.05,2070168.61,0.00,0.00,1173.56,863740.16,0.00,0.00,0.00),('1','146','767','258210',4906336,'2940','325',254469.15,256430.86,0.00,0.00,1961.71,1443818.56,0.00,0.00,0.00),('1','146','767','258211',4906337,'2138','325',2070168.61,2071234.99,0.00,0.00,1066.38,784855.68,0.00,0.00,0.00),('1','146','767','258211',4906338,'2940','325',256430.86,257308.79,0.00,0.00,877.93,646156.48,0.00,0.00,0.00),('1','146','767','258212',4906339,'2138','325',2071234.99,2071490.21,0.00,0.00,255.22,187841.92,0.00,0.00,0.00),('1','146','767','258212',4906340,'2940','325',257308.79,257596.64,0.00,0.00,287.85,211857.60,0.00,0.00,0.00),('1','146','767','258213',4906341,'2138','325',2071490.21,2072256.96,0.00,0.00,766.75,564328.00,0.00,0.00,0.00),('1','146','767','258213',4906342,'2940','325',257596.64,259045.28,0.00,0.00,1448.64,1066199.04,0.00,0.00,0.00),('1','146','767','258214',4906343,'2138','325',2072256.96,2074564.87,0.00,0.00,2307.91,1698621.76,0.00,0.00,0.00),('1','146','767','258214',4906344,'2940','325',259045.28,259058.59,0.00,0.00,13.31,9796.16,0.00,0.00,0.00),('1','146','767','258215',4906345,'2138','325',2074564.87,2074678.85,0.00,0.00,113.98,83889.28,0.00,0.00,0.00),('1','146','767','258215',4906346,'2940','325',259058.59,259871.02,0.00,0.00,812.43,597948.48,0.00,0.00,0.00),('1','146','767','258216',4906347,'2138','325',2074678.85,2074901.99,0.00,0.00,223.14,156198.00,0.00,0.00,0.00),('1','146','767','258216',4906348,'2940','325',259871.02,261446.08,0.00,0.00,1575.06,1102542.00,0.00,0.00,0.00),('1','146','767','258217',4906349,'2138','325',2074901.99,2077199.61,0.00,0.00,2297.62,1608334.00,0.00,0.00,0.00),('1','146','767','258217',4906350,'2940','325',261446.08,261549.93,0.00,0.00,103.85,72695.00,0.00,0.00,0.00),('1','146','767','258218',4906351,'2138','325',2077199.61,2077546.45,0.00,0.00,346.84,242788.00,0.00,0.00,0.00),('1','146','767','258218',4906352,'2940','325',261549.93,263541.77,0.00,0.00,1991.84,1394288.00,0.00,0.00,0.00),('1','146','767','258219',4906353,'2138','325',2077546.45,2077948.78,0.00,0.00,402.33,281631.00,0.00,0.00,0.00),('1','146','767','258219',4906354,'2940','325',263541.77,266198.60,0.00,0.00,2656.83,1859781.00,0.00,0.00,0.00),('1','146','767','258220',4906355,'2138','325',2077948.78,2080737.74,0.00,0.00,2788.96,1952272.00,0.00,0.00,0.00),('1','146','767','258220',4906356,'2940','325',266198.60,266198.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258221',4906357,'2138','325',2080737.74,2080940.30,0.00,0.00,202.56,141792.00,0.00,0.00,0.00),('1','146','767','258221',4906358,'2940','325',266198.60,268329.07,0.00,0.00,2130.47,1491329.00,0.00,0.00,0.00),('1','146','767','258222',4906359,'2138','325',2080940.30,2081234.95,0.00,0.00,294.65,206255.00,0.00,0.00,0.00),('1','146','767','258222',4906360,'2940','325',268329.07,271107.18,0.00,0.00,2778.11,1944677.00,0.00,0.00,0.00),('1','146','767','258223',4906361,'2138','325',2081234.95,2083358.75,0.00,0.00,2123.80,1486660.00,0.00,0.00,0.00),('1','146','767','258223',4906362,'2940','325',271107.18,271132.83,0.00,0.00,25.65,17955.00,0.00,0.00,0.00),('1','146','767','258224',4906363,'2138','325',2083358.75,2083582.84,0.00,0.00,224.09,156863.00,0.00,0.00,0.00),('1','146','767','258224',4906364,'2940','325',271132.83,271132.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','146','767','258225',4906365,'2138','325',2083582.84,2084649.19,0.00,0.00,1066.35,746445.00,0.00,0.00,0.00),('1','146','767','258225',4906366,'2940','325',271132.83,272688.88,0.00,0.00,1556.05,1089235.00,0.00,0.00,0.00),('1','146','767','258226',4906367,'2138','325',2084649.19,2086988.62,0.00,0.00,2339.43,1637601.00,0.00,0.00,0.00),('1','146','767','258226',4906368,'2940','325',272688.88,272987.31,0.00,0.00,298.43,208901.00,0.00,0.00,0.00),('1','146','767','258227',4906369,'2138','325',2086988.62,2087666.67,0.00,0.00,678.05,474635.00,0.00,0.00,0.00),('1','146','767','258227',4906370,'2940','325',272987.31,274943.26,0.00,0.00,1955.95,1369165.00,0.00,0.00,0.00),('1','146','767','258228',4906371,'2138','325',2087666.67,2089716.83,0.00,0.00,2050.16,1435112.00,0.00,0.00,0.00),('1','146','767','258228',4906372,'2940','325',274943.26,275293.62,0.00,0.00,350.36,245252.00,0.00,0.00,0.00),('1','146','767','258229',4906373,'2138','325',2089716.83,2089930.22,0.00,0.00,213.39,149373.00,0.00,0.00,0.00),('1','146','767','258229',4906374,'2940','325',275293.62,275306.48,0.00,0.00,12.86,9002.00,0.00,0.00,0.00),('1','146','767','258230',4906375,'2138','325',2089930.22,2090274.25,0.00,0.00,344.03,240821.00,0.00,0.00,0.00),('1','146','767','258230',4906376,'2940','325',275306.48,277368.41,0.00,0.00,2061.93,1443351.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730505 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','146','146909','325',210.00,280.00,0.00,1531.07,321524.70,428699.60,107174.90,441299),('1','146','146929','325',210.00,280.00,0.00,1331.78,279673.80,372898.40,93224.60,441357),('1','146','146935','325',210.00,280.00,0.00,1887.85,396448.50,528598.00,132149.50,441373),('1','146','146960','325',210.00,280.00,0.00,264.28,55498.80,73998.40,18499.60,441446),('1','146','146976','325',210.00,280.00,0.00,2597.14,545399.40,727199.20,181799.80,441492),('1','146','146988','325',210.00,280.00,0.00,2243.00,471030.00,628040.00,157010.00,441525),('1','146','147014','325',210.00,280.00,0.00,1797.50,377475.00,503300.00,125825.00,441580),('1','146','147017','325',210.00,280.00,0.00,2320.00,487200.00,649600.00,162400.00,441585),('1','146','147035','325',210.00,280.00,0.00,1382.00,290220.00,386960.00,96740.00,441620),('1','146','147077','325',210.00,280.00,0.00,256.07,53774.70,71699.60,17924.90,441723),('1','146','147083','325',210.00,280.00,0.00,2458.21,516224.10,688298.80,172074.70,441733),('1','146','147087','325',210.00,280.00,0.00,2816.00,591360.00,788480.00,197120.00,441737),('1','146','147301','325',210.00,280.00,0.00,1342.50,281925.00,375900.00,93975.00,442186),('1','146','147304','325',210.00,280.00,0.00,1622.50,340725.00,454300.00,113575.00,442191),('1','146','147423','325',210.00,280.00,0.00,2058.57,432299.70,576399.60,144099.90,442518),('1','146','147528','325',210.00,280.00,0.00,315.00,66150.00,88200.00,22050.00,442812),('1','146','147532','325',210.00,280.00,0.00,86.00,18060.00,24080.00,6020.00,442822),('1','146','147566','325',210.00,280.00,0.00,1523.92,320023.20,426697.60,106674.40,442913),('1','146','147667','325',210.00,280.00,0.00,2247.67,472010.70,629347.60,157336.90,443186),('1','146','147842','325',210.00,280.00,0.00,1378.00,289380.00,385840.00,96460.00,443666),('1','146','147984','325',222.00,280.00,0.00,2270.71,504097.62,635798.80,131701.18,444035),('1','146','148112','325',222.00,280.00,0.00,1500.35,333077.70,420098.00,87020.30,444369),('1','146','148247','325',222.00,280.00,0.00,1509.00,334998.00,422520.00,87522.00,444727),('1','146','148411','325',222.00,280.00,0.00,2245.35,498467.70,628698.00,130230.30,445155),('1','146','148542','325',222.00,280.00,0.00,2195.00,487290.00,614600.00,127310.00,445495),('1','146','148669','325',202.00,280.00,0.00,2017.85,407605.70,564998.00,157392.30,445812),('1','146','148797','325',202.00,280.00,0.00,1859.28,375574.56,520598.40,145023.84,446145),('1','146','148940','325',202.00,280.00,0.00,1990.00,401980.00,557200.00,155220.00,446527),('1','146','149149','325',225.00,280.00,0.00,2359.53,530894.25,660668.40,129774.15,447079),('1','146','149293','325',225.00,280.00,0.00,2052.14,461731.50,574599.20,112867.70,447454),('1','146','149439','325',225.00,280.00,0.00,1123.00,252675.00,314440.00,61765.00,447846),('1','146','149599','325',225.00,280.00,0.00,3388.35,762378.75,948738.00,186359.25,448285),('1','146','149695','325',225.00,280.00,0.00,1866.78,420025.50,522698.40,102672.90,448534),('1','146','149861','325',225.00,280.00,0.00,2823.92,635382.00,790697.60,155315.60,448965),('1','146','150012','325',225.00,280.00,0.00,2536.00,570600.00,710080.00,139480.00,449379),('1','146','150164','325',225.00,280.00,0.00,2296.25,516656.25,642950.00,126293.75,449784),('1','146','150367','325',225.00,280.00,0.00,2051.07,461490.75,574299.60,112808.85,450305),('1','146','150460','325',225.00,280.00,0.00,873.00,196425.00,244440.00,48015.00,450552),('1','146','150542','325',225.00,280.00,0.00,786.42,176944.50,220197.60,43253.10,450782),('1','146','150702','325',225.00,280.00,0.00,2239.64,503919.00,627099.20,123180.20,451198),('1','146','150803','325',225.00,280.00,0.00,724.00,162900.00,202720.00,39820.00,451470),('1','146','150839','325',225.00,280.00,0.00,1392.85,313391.25,389998.00,76606.75,451558),('1','146','150963','325',225.00,280.00,0.00,993.00,223425.00,278040.00,54615.00,451883),('1','146','150974','325',225.00,280.00,0.00,1177.85,265016.25,329798.00,64781.75,451913),('1','146','151135','325',225.00,280.00,0.00,2603.21,585722.25,728898.80,143176.55,452349),('1','146','151283','325',225.00,280.00,0.00,1419.00,319275.00,397320.00,78045.00,452754),('1','146','151417','325',225.00,280.00,0.00,2631.78,592150.50,736898.40,144747.90,453122),('1','146','151591','325',225.00,280.00,0.00,2393.32,538497.00,670129.60,131632.60,453593),('1','146','151679','325',225.00,280.00,0.00,785.00,176625.00,219800.00,43175.00,453843),('1','146','151705','325',225.00,280.00,0.00,917.85,206516.25,256998.00,50481.75,453904),('1','146','151807','325',225.00,280.00,0.00,2358.57,530678.25,660399.60,129721.35,454172),('1','146','151997','325',225.00,280.00,0.00,1968.92,443007.00,551297.60,108290.60,454689),('1','146','152162','325',225.00,280.00,0.00,434.00,97650.00,121520.00,23870.00,455116),('1','146','152164','325',225.00,280.00,0.00,1366.78,307525.50,382698.40,75172.90,455118),('1','146','152319','325',225.00,280.00,0.00,2365.35,532203.75,662298.00,130094.25,455534),('1','146','152461','325',225.00,280.00,0.00,1626.42,365944.50,455397.60,89453.10,455913),('1','146','152610','325',225.00,280.00,0.00,539.85,121466.25,151158.00,29691.75,456315),('1','146','152613','325',225.00,280.00,0.00,1285.35,289203.75,359898.00,70694.25,456320),('1','146','152749','325',225.00,280.00,0.00,2233.93,502634.25,625500.40,122866.15,456696),('1','146','152888','325',225.00,280.00,0.00,2271.00,510975.00,635880.00,124905.00,457064),('1','146','153070','325',225.00,280.00,0.00,2258.57,508178.25,632399.60,124221.35,457552),('1','146','153256','325',225.00,280.00,0.00,2013.57,453053.25,563799.60,110746.35,458069),('1','146','153474','325',225.00,280.00,0.00,1467.00,330075.00,410760.00,80685.00,458662),('1','146','153626','325',225.00,280.00,0.00,2789.28,627588.00,780998.40,153410.40,459072),('1','146','153803','325',225.00,280.00,0.00,1347.00,303075.00,377160.00,74085.00,459540),('1','146','153917','325',225.00,280.00,0.00,2951.78,664150.50,826498.40,162347.90,459842),('1','146','154057','325',225.00,280.00,0.00,2301.28,517788.00,644358.40,126570.40,460198),('1','146','154242','325',225.00,280.00,0.00,697.00,156825.00,195160.00,38335.00,460709),('1','146','154244','325',225.00,280.00,0.00,2145.35,482703.75,600698.00,117994.25,460713),('1','146','154376','325',225.00,280.00,0.00,417.00,93825.00,116760.00,22935.00,461047),('1','146','154590','325',211.00,280.00,0.00,1947.85,410996.35,545398.00,134401.65,461635),('1','146','154727','325',211.00,280.00,0.00,2701.42,569999.62,756397.60,186397.98,462021),('1','146','154873','325',211.00,280.00,0.00,1220.00,257420.00,341600.00,84180.00,462421),('1','146','154882','325',231.00,280.00,0.00,446.42,103123.02,124997.60,21874.58,462438),('1','146','155012','325',231.00,280.00,0.00,2766.42,639043.02,774597.60,135554.58,462790),('1','146','155125','325',231.00,280.00,0.00,1255.00,289905.00,351400.00,61495.00,463100),('1','146','155305','325',226.00,280.00,0.00,3486.07,787851.82,976099.60,188247.78,463573),('1','146','155455','325',226.00,280.00,0.00,2314.00,522964.00,647920.00,124956.00,463977),('1','146','155646','325',226.00,280.00,0.00,2659.64,601078.64,744699.20,143620.56,464500),('1','146','155773','325',226.00,280.00,0.00,2684.64,606728.64,751699.20,144970.56,464848),('1','146','155909','325',226.00,280.00,0.00,595.00,134470.00,166600.00,32130.00,465200),('1','146','155932','325',226.00,280.00,0.00,923.92,208805.92,258697.60,49891.68,465250),('1','146','156081','325',226.00,0.00,0.00,2107.50,476295.00,590100.00,113805.00,465654),('1','146','156204','325',226.00,280.00,0.00,2004.28,452967.28,561198.40,108231.12,465971),('1','146','156364','325',226.00,280.00,0.00,830.71,187740.46,232598.80,44858.34,466399),('1','146','156423','325',226.00,280.00,0.00,989.28,223577.28,276998.40,53421.12,466551),('1','146','156567','325',226.00,280.00,0.00,2403.21,543125.46,672898.80,129773.34,466940),('1','146','156731','325',226.00,280.00,0.00,1893.57,427946.82,530199.60,102252.78,467399),('1','146','156797','325',226.00,280.00,0.00,104.00,23504.00,29120.00,5616.00,467577),('1','146','156910','325',226.00,280.00,0.00,1423.92,321805.92,398697.60,76891.68,467880),('1','146','157032','325',226.00,280.00,0.00,1126.00,254476.00,315280.00,60804.00,468215),('1','146','157086','325',205.00,280.00,0.00,1128.57,231356.85,315999.60,84642.75,468333),('1','146','157190','325',205.00,280.00,0.00,285.00,58425.00,79800.00,21375.00,468604),('1','146','157284','325',205.00,280.00,0.00,1818.96,372886.80,509308.80,136422.00,468847),('1','146','157440','325',205.00,280.00,0.00,2650.71,543395.55,742198.80,198803.25,469252),('1','146','157658','325',205.00,280.00,0.00,1393.00,285565.00,390040.00,104475.00,469815),('1','146','157803','325',226.00,280.00,0.00,2540.00,574040.00,711200.00,137160.00,470212),('1','146','157952','325',226.00,280.00,0.00,2011.78,454662.28,563298.40,108636.12,470606),('1','146','158088','325',226.00,280.00,0.00,1801.42,407120.92,504397.60,97276.68,470954),('1','146','158261','325',226.00,280.00,0.00,1522.50,344085.00,426300.00,82215.00,471414),('1','146','158425','325',226.00,280.00,0.00,2240.71,506400.46,627398.80,120998.34,471851),('1','146','158577','325',226.00,280.00,0.00,2078.92,469835.92,582097.60,112261.68,472241),('1','146','158700','325',226.00,280.00,0.00,2016.78,463363.68,564698.40,101334.72,472585),('1','146','158938','325',231.00,280.00,0.00,821.42,189748.02,229997.60,40249.58,473182),('1','146','158939','325',231.00,296.00,0.00,1712.97,395696.07,507039.12,111343.05,473183),('1','146','159122','325',231.00,296.00,0.00,1836.82,424305.42,543698.72,119393.30,473676),('1','146','159273','325',231.00,296.00,0.00,327.70,75698.70,96999.20,21300.50,474100),('1','146','159276','325',231.00,296.00,0.00,2199.83,508160.73,651149.68,142988.95,474104),('1','146','159459','325',231.00,280.00,0.00,1719.59,397225.29,508998.64,111773.35,474546),('1','146','159751','325',231.00,296.00,0.00,791.48,182831.88,234278.08,51446.20,475287),('1','146','159759','325',231.00,304.00,0.00,1523.91,352023.21,463268.64,111245.43,475309),('1','146','159763','325',231.00,304.00,0.00,2195.88,507248.28,667547.52,160299.24,475319),('1','146','159950','325',231.00,304.00,0.00,436.18,100757.58,132598.72,31841.14,475819),('1','146','159952','325',231.00,304.00,0.00,1854.93,428488.83,563898.72,135409.89,475821),('1','146','160133','325',231.00,304.00,0.00,2546.38,588213.78,774099.52,185885.74,476282),('1','146','160295','325',231.00,304.00,0.00,517.10,119450.10,157198.40,37748.30,476732),('1','146','160306','325',231.00,304.00,0.00,1459.86,337227.66,443797.44,106569.78,476747),('1','146','160451','325',231.00,320.00,0.00,2669.21,616587.51,854147.20,237559.69,477132),('1','146','160582','325',231.00,320.00,0.00,1111.56,256770.36,355699.20,98928.84,477485),('1','146','160591','325',231.00,320.00,0.00,860.93,198874.83,275497.60,76622.77,477498),('1','146','160737','325',231.00,320.00,0.00,2680.15,619114.65,857648.00,238533.35,477874),('1','146','160895','325',231.00,320.00,0.00,382.81,88429.11,122499.20,34070.09,478251),('1','146','160897','325',251.00,320.00,0.00,1358.59,341006.09,434748.80,93742.71,478255),('1','146','161085','325',251.00,320.00,0.00,2356.62,591511.62,754118.40,162606.78,478773),('1','146','161241','325',251.00,320.00,0.00,654.43,164261.93,209417.60,45155.67,479186),('1','146','161266','325',235.00,320.00,0.00,1536.87,361164.45,491798.40,130633.95,479242),('1','146','161454','325',235.00,320.00,0.00,2348.28,551845.80,751449.60,199603.80,479708),('1','146','161651','325',235.00,320.00,0.00,1339.67,314822.45,428694.40,113871.95,480221),('1','146','161888','325',235.00,320.00,0.00,1784.84,419437.40,571148.80,151711.40,480806),('1','146','162047','325',235.00,320.00,0.00,2598.43,610631.05,831497.60,220866.55,481241),('1','146','162211','325',235.00,304.00,0.00,511.84,120282.40,155599.36,35316.96,481664),('1','146','162246','325',237.00,304.00,0.00,1212.99,287478.63,368748.96,81270.33,481736),('1','146','162466','325',237.00,304.00,0.00,2337.66,554025.42,710648.64,156623.22,482303),('1','146','162640','325',237.00,304.00,0.00,1633.38,387111.06,496547.52,109436.46,482737),('1','146','162830','325',235.00,304.00,0.00,2213.98,520285.30,673049.92,152764.62,483224),('1','146','163001','325',235.00,304.00,0.00,2509.53,589739.55,762897.12,173157.57,483695),('1','146','163097','325',235.00,304.00,0.00,318.42,74828.70,96799.68,21970.98,483934),('1','146','163213','325',237.00,304.00,0.00,1343.25,318350.25,408348.00,89997.75,484223),('1','146','163368','325',237.00,304.00,0.00,2955.75,700512.75,898548.00,198035.25,484633),('1','146','163537','325',237.00,304.00,0.00,422.69,100177.53,128497.76,28320.23,485084),('1','146','163583','325',237.00,304.00,0.00,1309.21,310282.77,397999.84,87717.07,485188),('1','146','163732','325',237.00,304.00,0.00,1957.40,463903.80,595049.60,131145.80,485593),('1','146','163893','325',237.00,304.00,0.00,2035.19,482340.03,618697.76,136357.73,486005),('1','146','164054','325',237.00,304.00,0.00,2721.87,645083.19,827448.48,182365.29,486441),('1','146','164251','325',237.00,304.00,0.00,2164.47,512979.39,657998.88,145019.49,486950),('1','146','164432','325',237.00,304.00,0.00,344.07,81544.59,104597.28,23052.69,487436),('1','146','164435','325',237.00,304.00,0.00,1464.80,347157.60,445299.20,98141.60,487441),('1','146','164642','325',237.00,304.00,0.00,2637.82,625163.34,801897.28,176733.94,487990),('1','146','164743','325',237.00,304.00,0.00,795.06,188429.22,241698.24,53269.02,488273),('1','146','164747','325',237.00,304.00,0.00,1520.39,360332.43,462198.56,101866.13,488279),('1','146','164956','325',237.00,304.00,0.00,2376.40,563206.80,731948.00,168741.20,488816),('1','146','165036','325',237.00,320.00,0.00,765.31,181378.47,244899.20,63520.73,489010),('1','146','165122','325',237.00,320.00,0.00,1704.37,403935.69,545398.40,141462.71,489237),('1','146','165284','325',237.00,304.00,0.00,2619.07,620719.59,796197.28,175477.69,489661),('1','146','165472','325',237.00,304.00,0.00,1980.95,469485.15,602208.80,132723.65,490140),('1','146','165601','325',237.00,304.00,0.00,2189.96,519020.52,665747.84,146727.32,490493),('1','146','165783','325',237.00,304.00,0.00,1369.40,324547.80,416297.60,91749.80,490985),('1','146','165934','325',237.00,304.00,0.00,1248.02,295780.74,379398.08,83617.34,491377),('1','146','166018','325',237.00,304.00,0.00,2931.90,694860.30,891297.60,196437.30,491601),('1','146','166166','325',237.00,304.00,0.00,1016.11,240818.07,308897.44,68079.37,491978),('1','146','166171','325',237.00,304.00,0.00,893.75,211818.75,271700.00,59881.25,491989),('1','146','166359','325',237.00,304.00,0.00,1442.43,341855.91,438498.72,96642.81,492501),('1','146','166467','325',237.00,304.00,0.00,2173.68,515162.16,660798.72,145636.56,492807),('1','146','166690','325',237.00,304.00,0.00,641.44,152021.28,194997.76,42976.48,493398),('1','146','166692','325',273.00,304.00,0.00,1698.84,463783.32,516447.36,52664.04,493402),('1','146','166870','325',273.00,304.00,0.00,2410.46,658055.58,732779.84,74724.26,493893),('1','146','167203','325',273.00,304.00,0.00,255.92,69866.16,77799.68,7933.52,494766),('1','146','167206','325',275.00,304.00,0.00,1525.49,419509.75,463748.96,44239.21,494773),('1','146','167210','325',275.00,304.00,0.00,2426.97,667416.75,737798.88,70382.13,494783),('1','146','167366','325',275.00,304.00,0.00,347.03,95433.25,105497.12,10063.87,495224),('1','146','167371','325',275.00,304.00,0.00,1591.11,437555.25,483697.44,46142.19,495233),('1','146','167564','325',275.00,304.00,0.00,2478.28,681527.00,753397.12,71870.12,495737),('1','146','167774','325',275.00,304.00,0.00,919.90,252972.50,279649.60,26677.10,496277),('1','146','167779','325',276.00,304.00,0.00,1644.73,453945.48,499997.92,46052.44,496289),('1','146','167904','325',276.00,304.00,0.00,2102.30,580234.80,639099.20,58864.40,496633),('1','146','168098','325',276.00,304.00,0.00,368.75,101775.00,112100.00,10325.00,497158),('1','146','168162','325',276.00,304.00,0.00,1777.63,490625.88,540399.52,49773.64,497306),('1','146','168393','325',276.00,304.00,0.00,2768.09,763992.84,841499.36,77506.52,497941),('1','146','168491','325',276.00,304.00,0.00,2484.21,685641.96,755199.84,69557.88,498200),('1','146','168594','325',276.00,304.00,0.00,2014.96,556128.96,612547.84,56418.88,498467),('1','146','168770','325',276.00,304.00,0.00,959.21,264741.96,291599.84,26857.88,498938),('1','146','168771','325',276.00,304.00,0.00,1347.69,371962.44,409697.76,37735.32,498939),('1','146','168928','325',276.00,304.00,0.00,2703.96,746292.96,822003.84,75710.88,499354),('1','146','169092','325',276.00,304.00,0.00,1428.61,394296.36,434297.44,40001.08,499775),('1','146','169095','325',276.00,304.00,0.00,2216.28,611693.28,673749.12,62055.84,499779),('1','146','169266','325',276.00,304.00,0.00,1470.88,405962.88,447147.52,41184.64,500210),('1','146','169595','325',276.00,304.00,0.00,658.88,181850.88,200299.52,18448.64,501059),('1','146','169597','325',276.00,304.00,0.00,1935.00,534060.00,588240.00,54180.00,501063),('1','146','169598','325',276.00,304.00,0.00,1554.28,428981.28,472501.12,43519.84,501064),('1','146','169808','325',276.00,304.00,0.00,2277.30,628534.80,692299.20,63764.40,501626),('1','146','169918','325',276.00,304.00,0.00,2135.52,589403.52,649198.08,59794.56,501947),('1','146','170119','325',276.00,304.00,0.00,666.11,183846.36,202497.44,18651.08,502447),('1','146','170123','325',276.00,304.00,0.00,1346.05,371509.80,409199.20,37689.40,502453),('1','146','170320','325',276.00,304.00,0.00,1620.06,447136.56,492498.24,45361.68,502971),('1','146','170540','325',276.00,304.00,0.00,1723.68,475735.68,523998.72,48263.04,503546),('1','146','170541','325',276.00,304.00,0.00,435.85,120294.60,132498.40,12203.80,503547),('1','146','170808','325',276.00,304.00,0.00,2075.98,572970.48,631097.92,58127.44,504251),('1','146','170809','325',276.00,320.00,0.00,1041.40,287426.40,333248.00,45821.60,504252),('1','146','170877','325',276.00,320.00,0.00,819.06,226060.56,262099.20,36038.64,504429),('1','146','171078','325',276.00,320.00,0.00,2387.20,658867.20,763904.00,105036.80,504967),('1','146','171205','325',276.00,320.00,0.00,1964.43,542182.68,628617.60,86434.92,505318),('1','146','171235','325',285.00,320.00,0.00,482.18,137421.30,154297.60,16876.30,505387),('1','146','171365','325',285.00,320.00,0.00,2187.18,623346.30,699897.60,76551.30,505731),('1','146','171616','325',285.00,320.00,0.00,2262.18,644721.30,723897.60,79176.30,506401),('1','146','171618','325',285.00,320.00,0.00,183.12,52189.20,58598.40,6409.20,506405),('1','146','171817','325',285.00,320.00,0.00,1900.31,541588.35,608099.20,66510.85,506925),('1','146','171820','325',285.00,320.00,0.00,2133.43,608027.55,682697.60,74670.05,506932),('1','146','172459','325',285.00,320.00,0.00,992.50,282862.50,317600.00,34737.50,508640),('1','146','172461','325',271.00,320.00,0.00,1408.25,381635.75,450640.00,69004.25,508644),('1','146','172570','325',271.00,320.00,0.00,1408.25,381635.75,450640.00,69004.25,508928),('1','146','172574','325',271.00,320.00,0.00,2578.12,698670.52,824998.40,126327.88,508938),('1','146','172596','325',271.00,320.00,0.00,1177.68,319151.28,376857.60,57706.32,508997),('1','146','172656','325',271.00,320.00,0.00,0.00,0.00,0.00,0.00,509165),('1','146','172669','325',271.00,320.00,0.00,0.00,0.00,0.00,0.00,509194),('1','146','172672','325',271.00,320.00,0.00,1244.60,364667.80,398272.00,33604.20,509199),('1','146','172792','325',293.00,320.00,0.00,0.00,0.00,0.00,0.00,509515),('1','146','172794','325',293.00,320.00,0.00,3062.25,897239.25,979920.00,82680.75,509519),('1','146','172914','325',293.00,320.00,0.00,1076.00,315268.00,344320.00,29052.00,509828),('1','146','172924','325',293.00,320.00,0.00,775.62,227256.66,248198.40,20941.74,509855),('1','146','173041','325',293.00,320.00,0.00,2893.28,847731.04,925849.60,78118.56,510179),('1','146','173184','325',293.00,320.00,0.00,1332.18,390328.74,426297.60,35968.86,510565),('1','146','173198','325',293.00,320.00,0.00,1187.34,347890.62,379948.80,32058.18,510598),('1','146','173422','325',293.00,320.00,0.00,2358.12,690929.16,754598.40,63669.24,511176),('1','146','173486','325',293.00,320.00,0.00,1102.50,323032.50,352800.00,29767.50,511361),('1','146','173580','325',293.00,320.00,0.00,1308.75,383463.75,418800.00,35336.25,511616),('1','146','173850','325',293.00,320.00,0.00,2627.03,769719.79,840649.60,70929.81,512322),('1','146','173891','325',293.00,320.00,0.00,1074.37,314790.41,343798.40,29007.99,512436),('1','146','173929','325',293.00,320.00,0.00,897.18,262873.74,287097.60,24223.86,512527),('1','146','174190','325',293.00,320.00,0.00,2548.43,746689.99,815497.60,68807.61,513213),('1','146','174463','325',293.00,320.00,0.00,1865.31,546535.83,596899.20,50363.37,513923),('1','146','174605','325',293.00,320.00,0.00,2852.18,835688.74,912697.60,77008.86,514282),('1','146','174607','325',293.00,320.00,0.00,2364.52,692804.36,756646.40,63842.04,514286),('1','146','174828','325',293.00,320.00,0.00,2630.00,770590.00,841600.00,71010.00,514875),('1','146','175014','325',293.00,320.00,0.00,2449.88,717814.84,881956.80,164141.96,515376),('1','146','175222','325',300.00,360.00,0.00,2422.22,726666.00,871999.20,145333.20,515919),('1','146','175483','325',300.00,360.00,0.00,2880.75,864225.00,1037070.00,172845.00,516590),('1','146','175585','325',300.00,360.00,0.00,1668.05,500415.00,600498.00,100083.00,516862),('1','146','175892','325',300.00,360.00,0.00,3288.47,986541.00,1183849.20,197308.20,517673),('1','146','175952','325',300.00,360.00,0.00,2830.08,849024.00,1018828.80,169804.80,517819),('1','146','176127','325',300.00,360.00,0.00,2470.80,741240.00,889488.00,148248.00,518262),('1','146','176311','325',300.00,360.00,0.00,2526.94,758082.00,909698.40,151616.40,518738),('1','146','176525','325',300.00,360.00,0.00,2461.52,738456.00,886147.20,147691.20,519297),('1','146','176732','325',300.00,360.00,0.00,292.08,87624.00,105148.80,17524.80,519862),('1','146','176753','325',300.00,360.00,0.00,1568.33,470499.00,564598.80,94099.80,519915),('1','146','176955','325',300.00,360.00,0.00,455.44,136632.00,163958.40,27326.40,520453),('1','146','176968','325',300.00,360.00,0.00,2035.00,610500.00,732600.00,122100.00,520482),('1','146','177190','325',300.00,360.00,0.00,3067.36,920208.00,1104249.60,184041.60,521062),('1','146','177574','325',300.00,360.00,0.00,3017.77,905331.00,1086397.20,181066.20,522081),('1','146','177661','325',300.00,360.00,0.00,2181.66,654498.00,785397.60,130899.60,522302),('1','146','177855','325',300.00,360.00,0.00,2260.13,678039.00,813646.80,135607.80,522834),('1','146','178099','325',300.00,360.00,0.00,3046.35,913905.00,1096686.00,182781.00,523470),('1','146','178271','325',300.00,360.00,0.00,1993.47,598041.00,717649.20,119608.20,523920),('1','146','178470','325',300.00,360.00,0.00,2738.19,821457.00,985748.40,164291.40,524437),('1','146','178938','325',300.00,360.00,0.00,970.97,291291.00,349549.20,58258.20,525647),('1','146','178942','325',300.00,360.00,0.00,903.47,271041.00,325249.20,54208.20,525657),('1','146','179009','325',300.00,360.00,0.00,2258.13,677439.00,812926.80,135487.80,525836),('1','146','179011','325',300.00,360.00,0.00,2548.78,764634.00,917560.80,152926.80,525840),('1','146','179147','325',300.00,360.00,0.00,486.38,145914.00,49996.80,-95917.20,526197),('1','146','179186','325',300.00,360.00,0.00,2406.40,721920.00,850804.00,128884.00,526305),('1','146','179373','325',300.00,360.00,0.00,2013.83,604149.00,724978.80,120829.80,526810),('1','146','180108','325',300.00,360.00,0.00,155.83,46749.00,56098.80,9349.80,528756),('1','146','180302','325',300.00,360.00,0.00,642.81,192843.00,231411.60,38568.60,529253),('1','146','180501','325',300.00,360.00,0.00,2613.88,784164.00,940996.80,156832.80,529781),('1','146','180552','325',300.00,360.00,0.00,2343.19,702957.00,839048.40,136091.40,529910),('1','146','180742','325',300.00,360.00,0.00,213.33,63999.00,76798.80,12799.80,530400),('1','146','180789','325',300.00,360.00,0.00,1921.12,576336.00,642553.20,66217.20,530526),('1','146','180987','325',300.00,360.00,0.00,2630.73,789219.00,943822.80,154603.80,531059),('1','146','181141','325',300.00,360.00,0.00,767.37,230211.00,273323.79,43112.79,531456),('1','146','181240','325',300.00,360.00,0.00,1097.92,329376.00,395251.20,65875.20,531740),('1','146','181331','325',300.00,360.00,0.00,2401.49,720447.00,880396.40,159949.40,531990),('1','146','181518','325',300.00,360.00,0.00,2197.51,659253.00,670503.60,11250.60,532479),('1','146','181744','325',300.00,360.00,0.00,2709.09,812727.00,1015412.40,202685.40,533053),('1','146','181899','325',300.00,0.00,0.00,2232.08,669624.00,803548.80,133924.80,533495),('1','146','182116','325',300.00,360.00,0.00,128.33,38499.00,46198.80,7699.80,534060),('1','146','182164','325',308.00,360.00,0.00,1865.18,574475.44,671464.80,96989.36,534189),('1','146','182298','325',308.00,360.00,0.00,2260.57,696255.56,813805.20,117549.64,534541),('1','146','182510','325',308.00,360.00,0.00,1646.25,507045.00,592650.00,85605.00,535091),('1','146','182673','325',300.00,360.00,0.00,629.72,188916.00,226699.20,37783.20,535539),('1','146','182686','325',300.00,360.00,0.00,2711.38,813414.00,971596.80,158182.80,535565),('1','146','182958','325',300.00,360.00,0.00,1935.55,580665.00,696798.00,116133.00,536319),('1','146','183092','325',300.00,360.00,0.00,2791.66,837498.00,1004997.60,167499.60,536671),('1','146','183239','325',300.00,360.00,0.00,2334.03,700209.00,840250.80,140041.80,537024),('1','146','183432','325',300.00,360.00,0.00,2418.10,725430.00,870516.00,145086.00,537525),('1','146','183634','325',300.00,360.00,0.00,2305.43,691629.00,829954.80,138325.80,538077),('1','146','183892','325',300.00,360.00,0.00,577.93,173379.00,208054.80,34675.80,538753),('1','146','183997','325',300.00,360.00,0.00,1063.61,319083.00,382899.60,63816.60,539034),('1','146','184072','325',300.00,360.00,0.00,2417.19,725157.00,870188.40,145031.40,539234),('1','146','184257','325',300.00,360.00,0.00,623.00,186900.00,224280.00,37380.00,539733),('1','146','184398','325',300.00,360.00,0.00,1311.66,419731.20,472197.60,52466.40,540090),('1','146','184470','325',320.00,360.00,0.00,2784.56,891059.20,1002441.60,111382.40,540268),('1','146','184674','325',320.00,360.00,0.00,1232.22,394310.40,443599.20,49288.80,540835),('1','146','184830','325',320.00,360.00,0.00,899.17,269751.00,323701.20,53950.20,541253),('1','146','184867','325',300.00,360.00,0.00,2082.36,624708.00,749649.60,124941.60,541348),('1','146','185129','325',300.00,360.00,0.00,1420.14,426042.00,511250.40,85208.40,542014),('1','146','185299','325',300.00,360.00,0.00,1068.75,320625.00,384750.00,64125.00,542436),('1','146','185503','325',300.00,360.00,0.00,797.08,239124.00,286948.80,47824.80,542975),('1','146','185506','325',300.00,360.00,0.00,2110.94,633282.00,759938.40,126656.40,542982),('1','146','185934','325',300.00,360.00,0.00,1676.01,502803.00,603363.60,100560.60,544132),('1','146','186147','325',323.00,360.00,0.00,1655.41,534697.43,595947.60,61250.17,544694),('1','146','186342','325',323.00,360.00,0.00,2243.05,724505.15,807498.00,82992.85,545196),('1','146','186540','325',323.00,360.00,0.00,958.02,309440.46,344887.20,35446.74,545724),('1','146','186699','325',323.00,360.00,0.00,666.52,215285.96,239947.20,24661.24,546144),('1','146','186766','325',323.00,360.00,0.00,2188.19,706785.37,787748.40,80963.03,546304),('1','146','186989','325',323.00,360.00,0.00,2141.15,691591.45,770814.00,79222.55,546866),('1','146','187246','325',323.00,360.00,0.00,1574.34,508511.82,566762.40,58250.58,547554),('1','146','187427','325',323.00,360.00,0.00,2080.13,671881.99,748846.80,76964.81,548029),('1','146','187582','325',323.00,360.00,0.00,1326.82,428562.86,477655.20,49092.34,548438),('1','146','187706','325',323.00,360.00,0.00,1116.20,360532.60,401832.00,41299.40,548773),('1','146','187810','325',323.00,360.00,0.00,2567.38,829263.74,924256.80,94993.06,549042),('1','146','188016','325',323.00,360.00,0.00,1415.43,457183.89,509554.80,52370.91,549583),('1','146','188147','325',323.00,360.00,0.00,875.20,282689.60,315072.00,32382.40,549927),('1','146','188217','325',323.00,360.00,0.00,2422.22,782377.06,871999.20,89622.14,550104),('1','146','188449','325',323.00,360.00,0.00,1531.88,494797.24,551476.80,56679.56,550694),('1','146','188610','325',323.00,360.00,0.00,2345.52,757602.96,844387.20,86784.24,551106),('1','146','188811','325',323.00,360.00,0.00,2209.58,713694.34,795448.80,81754.46,551639),('1','146','189046','325',323.00,360.00,0.00,1660.40,536309.20,597744.00,61434.80,552256),('1','146','189203','325',323.00,360.00,0.00,2614.28,844412.44,941140.80,96728.36,552672),('1','146','189422','325',323.00,360.00,0.00,374.84,121073.32,134942.40,13869.08,553252),('1','146','189535','325',323.00,360.00,0.00,1237.34,399660.82,445442.40,45781.58,553538),('1','146','189621','325',323.00,360.00,0.00,2231.54,720787.42,803354.40,82566.98,553761),('1','146','189815','325',323.00,360.00,0.00,1734.32,560185.36,624355.20,64169.84,554258),('1','146','189967','325',323.00,360.00,0.00,300.84,97171.32,108302.40,11131.08,554663),('1','146','190031','325',323.00,360.00,0.00,1853.95,598825.85,667422.00,68596.15,554828),('1','146','190221','325',323.00,360.00,0.00,2677.40,864800.20,963864.00,99063.80,555321),('1','146','190464','325',323.00,360.00,0.00,251.33,81179.59,90478.80,9299.21,555949),('1','146','190510','325',323.00,360.00,0.00,2424.02,782958.46,872647.20,89688.74,556075),('1','146','190672','325',323.00,360.00,0.00,2530.20,817254.60,910872.00,93617.40,556509),('1','146','190986','325',323.00,360.00,0.00,745.91,240928.93,268527.60,27598.67,557335),('1','146','190991','325',323.00,360.00,0.00,1736.80,560986.40,625248.00,64261.60,557347),('1','146','191076','325',323.00,360.00,0.00,2390.55,772147.65,860598.00,88450.35,557568),('1','146','191324','325',323.00,360.00,0.00,1215.45,392590.35,437562.00,44971.65,558215),('1','146','191498','325',323.00,360.00,0.00,2483.22,802080.06,893959.20,91879.14,558685),('1','146','191724','325',323.00,360.00,0.00,2575.87,832006.01,927313.20,95307.19,559275),('1','146','191991','325',323.00,360.00,0.00,1516.89,489955.47,546080.40,56124.93,559994),('1','146','192129','325',323.00,360.00,0.00,1927.64,622627.72,693950.40,71322.68,560368),('1','146','192336','325',323.00,360.00,0.00,1773.90,572969.70,638604.00,65634.30,560909),('1','146','192560','325',323.00,360.00,0.00,2706.19,874099.37,974228.40,100129.03,561498),('1','146','192756','325',323.00,360.00,0.00,2406.10,777170.30,866196.00,89025.70,562004),('1','146','192959','325',323.00,360.00,0.00,2491.61,804790.03,896979.60,92189.57,562529),('1','146','193163','325',323.00,360.00,0.00,2203.54,711743.42,793274.40,81530.98,563078),('1','146','193404','325',323.00,360.00,0.00,372.09,120185.07,133952.40,13767.33,563713),('1','146','193493','325',323.00,360.00,0.00,1379.50,445578.50,496620.00,51041.50,563941),('1','146','193625','325',323.00,360.00,0.00,2398.04,774566.92,863294.40,88727.48,564284),('1','146','193845','325',323.00,360.00,0.00,1471.80,475391.40,529848.00,54456.60,564839),('1','146','194029','325',323.00,360.00,0.00,786.10,253910.30,282996.00,29085.70,565295),('1','146','194075','325',323.00,360.00,0.00,2396.58,774095.34,862768.80,88673.46,565412),('1','146','194281','325',323.00,360.00,0.00,2233.04,721271.92,803894.40,82622.48,565958),('1','146','194483','325',323.00,360.00,0.00,2629.34,849276.82,946562.40,97285.58,566457),('1','146','194672','325',323.00,360.00,0.00,2636.34,851537.82,949082.40,97544.58,566934),('1','146','194926','325',323.00,360.00,0.00,1710.55,552507.65,615798.00,63290.35,567606),('1','146','195076','325',323.00,360.00,0.00,2682.08,866311.84,965548.80,99236.96,568001),('1','146','195298','325',323.00,360.00,0.00,596.76,192753.48,214833.60,22080.12,568573),('1','146','195408','325',323.00,360.00,0.00,1905.62,615515.26,686023.20,70507.94,568844),('1','146','195517','325',323.00,360.00,0.00,2285.04,738067.92,822614.40,84546.48,569136),('1','146','195775','325',323.00,360.00,0.00,1123.05,362745.15,404298.00,41552.85,569776),('1','146','195892','325',323.00,360.00,0.00,1390.35,449083.05,500526.00,51442.95,570063),('1','146','196007','325',323.00,360.00,0.00,2565.92,828792.16,923731.20,94939.04,570364),('1','146','196208','325',323.00,360.00,0.00,1663.76,537394.48,598953.60,61559.12,570872),('1','146','196398','325',323.00,360.00,0.00,288.89,93311.47,104000.40,10688.93,571360),('1','146','196448','325',323.00,360.00,0.00,2675.05,864041.15,963018.00,98976.85,571491),('1','146','196658','325',323.00,360.00,0.00,1271.39,410658.97,457700.40,47041.43,572027),('1','146','196776','325',323.00,360.00,0.00,1385.20,447419.60,498672.00,51252.40,572337),('1','146','196892','325',323.00,360.00,0.00,813.35,262712.05,292806.00,30093.95,572641),('1','146','197020','325',323.00,360.00,0.00,1645.79,531590.17,592484.40,60894.23,572974),('1','146','197344','325',323.00,360.00,0.00,1316.11,425103.53,473799.60,48696.07,573819),('1','146','197349','325',323.00,360.00,0.00,2081.58,672350.34,749368.80,77018.46,573826),('1','146','197523','325',323.00,360.00,0.00,2513.54,811873.42,904874.40,93000.98,574179),('1','146','197869','325',323.00,360.00,0.00,770.29,248803.67,277304.40,28500.73,575113),('1','146','198031','325',323.00,360.00,0.00,875.27,282712.21,315097.20,32384.99,575534),('1','146','198117','325',323.00,360.00,0.00,2146.33,693264.59,772678.80,79414.21,575756),('1','146','198339','325',323.00,360.00,0.00,2428.35,771939.93,874206.00,102266.07,576333),('1','146','198635','325',317.00,360.00,0.00,1754.99,556331.83,631796.40,75464.57,577100),('1','146','198769','325',317.00,360.00,0.00,2771.82,878666.94,997855.20,119188.26,577422),('1','146','198979','325',317.00,360.00,0.00,876.39,277815.63,315500.40,37684.77,577972),('1','146','199099','325',317.00,360.00,0.00,949.24,300909.08,341726.40,40817.32,578279),('1','146','199196','325',317.00,360.00,0.00,2378.50,753984.50,856260.00,102275.50,578508),('1','146','199428','325',317.00,360.00,0.00,2043.13,647672.21,735526.80,87854.59,579085),('1','146','199778','325',317.00,360.00,0.00,2724.18,863565.06,980704.80,117139.74,579929),('1','146','199853','325',317.00,360.00,0.00,2008.07,636558.19,722905.20,86347.01,580130),('1','146','200084','325',317.00,360.00,0.00,597.76,189489.92,215193.60,25703.68,580737),('1','146','200214','325',317.00,360.00,0.00,1033.73,327692.41,372142.80,44450.39,581072),('1','146','200281','325',317.00,360.00,0.00,3072.52,973988.84,1106107.20,132118.36,581253),('1','146','200480','325',317.00,360.00,0.00,1316.04,417184.68,473774.40,56589.72,581769),('1','146','200682','325',317.00,360.00,0.00,2382.13,755135.21,857566.80,102431.59,582298),('1','146','200910','325',317.00,360.00,0.00,2849.22,903202.74,1025719.20,122516.46,582870),('1','146','201143','325',317.00,360.00,0.00,208.30,66031.10,74988.00,8956.90,583444),('1','146','201159','325',317.00,360.00,0.00,2163.86,685943.62,778989.60,93045.98,583489),('1','146','201308','325',317.00,360.00,0.00,2248.21,712682.57,809355.60,96673.03,583889),('1','146','201490','325',317.00,360.00,0.00,1101.09,349045.53,396392.40,47346.87,584367),('1','146','201677','325',317.00,360.00,0.00,1138.35,360856.95,409806.00,48949.05,584870),('1','146','201753','325',317.00,360.00,0.00,4035.93,1279389.81,1452934.80,173544.99,585068),('1','146','202062','325',317.00,360.00,0.00,2353.78,746148.26,847360.80,101212.54,585865),('1','146','202211','325',317.00,360.00,0.00,2665.51,844966.67,959583.60,114616.93,586250),('1','146','202415','325',317.00,360.00,0.00,214.99,68151.83,77396.40,9244.57,586779),('1','146','202551','325',317.00,360.00,0.00,2045.03,648274.51,736210.80,87936.29,587122),('1','146','202630','325',317.00,360.00,0.00,2372.21,751990.57,853995.60,102005.03,587330),('1','146','202839','325',317.00,360.00,0.00,812.77,257648.09,292597.20,34949.11,587867),('1','146','202972','325',317.00,360.00,0.00,2306.37,731119.29,830293.20,99173.91,588195),('1','146','203098','325',317.00,360.00,0.00,2428.72,769904.24,874339.20,104434.96,588544),('1','146','203295','325',317.00,360.00,0.00,355.29,112626.93,127904.40,15277.47,589064),('1','146','203422','325',317.00,360.00,0.00,2269.44,719412.48,816998.40,97585.92,589381),('1','146','203512','325',317.00,360.00,0.00,2293.67,727093.39,825721.20,98627.81,589610),('1','146','203712','325',317.00,360.00,0.00,734.57,232858.69,276198.32,43339.63,590132),('1','146','203895','325',317.00,376.00,0.00,1193.38,378301.46,448710.88,70409.42,590610),('1','146','203955','325',317.00,376.00,0.00,2051.73,650398.41,771450.48,121052.07,590751),('1','146','204175','325',317.00,376.00,0.00,2221.93,752308.78,835445.68,83136.90,591338),('1','146','204354','325',376.00,376.00,0.00,383.51,144199.76,144199.76,0.00,591797),('1','146','204384','325',376.00,376.00,0.00,2477.07,931378.32,931378.32,0.00,591874),('1','146','204599','325',376.00,376.00,0.00,2264.63,851500.88,851500.88,0.00,592425),('1','146','204825','325',376.00,376.00,0.00,2709.64,1018824.64,1018824.64,0.00,592967),('1','146','205028','325',376.00,376.00,0.00,2286.02,859543.52,859543.52,0.00,593488),('1','146','205220','325',376.00,376.00,0.00,442.27,166293.52,166293.52,0.00,593988),('1','146','205322','325',376.00,376.00,0.00,2003.56,753338.56,753338.56,0.00,594242),('1','146','205473','325',376.00,376.00,0.00,2334.52,877779.52,877779.52,0.00,594626),('1','146','205721','325',376.00,376.00,0.00,628.21,236206.96,236206.96,0.00,595280),('1','146','205826','325',376.00,376.00,0.00,1863.26,700585.76,700585.76,0.00,595539),('1','146','205930','325',376.00,376.00,0.00,2659.04,999799.04,999799.04,0.00,595822),('1','146','206132','325',317.00,376.00,0.00,610.83,193633.11,229672.08,36038.97,596334),('1','146','206254','325',317.00,376.00,0.00,1474.68,467473.56,554479.68,87006.12,596642),('1','146','206353','325',317.00,376.00,0.00,2780.56,881437.52,1045490.56,164053.04,596898),('1','146','206566','325',317.00,376.00,0.00,975.62,309271.54,366833.12,57561.58,597440),('1','146','206705','325',317.00,376.00,0.00,1375.59,436062.03,517221.84,81159.81,597798),('1','146','206778','325',317.00,376.00,0.00,2560.15,811567.55,962616.40,151048.85,597989),('1','146','207009','325',317.00,376.00,0.00,1285.18,407402.06,483227.68,75825.62,598593),('1','146','207177','325',317.00,376.00,0.00,940.59,298167.03,353661.84,55494.81,599022),('1','146','207240','325',317.00,376.00,0.00,3441.56,1090974.52,1294026.56,203052.04,599188),('1','146','207469','325',317.00,376.00,0.00,1002.96,317938.32,377112.96,59174.64,599779),('1','146','207584','325',317.00,376.00,0.00,1692.41,536493.97,636346.16,99852.19,600061),('1','146','207692','325',317.00,384.00,0.00,3140.29,995471.93,1205871.36,210399.43,600336),('1','146','207897','325',317.00,384.00,0.00,610.04,193382.68,234255.36,40872.68,600865),('1','146','208011','325',317.00,384.00,0.00,2220.68,703955.56,852741.12,148785.56,601149),('1','146','208111','325',317.00,384.00,0.00,3074.01,974461.17,1180419.84,205958.67,601405),('1','146','208332','325',317.00,384.00,0.00,883.63,280110.71,339313.92,59203.21,601972),('1','146','208441','325',317.00,384.00,0.00,1699.67,538795.39,652673.28,113877.89,602253),('1','146','208541','325',317.00,384.00,0.00,3097.24,981825.08,1189340.16,207515.08,602519),('1','146','208758','325',317.00,384.00,0.00,1056.34,335005.73,405634.56,70628.83,603073),('1','146','208908','325',324.00,384.00,0.00,1343.06,435151.44,515735.04,80583.60,603439),('1','146','208985','325',324.00,384.00,0.00,100.00,32400.00,38400.00,6000.00,603650),('1','146','208995','325',324.00,400.00,0.00,2156.25,698625.00,862500.00,163875.00,603668),('1','146','209209','325',324.00,400.00,0.00,2002.25,648729.00,800900.00,152171.00,604218),('1','146','209408','325',324.00,400.00,0.00,191.25,61965.00,76500.00,14535.00,604728),('1','146','209440','325',324.00,400.00,0.00,3314.25,1102067.00,1325700.00,223633.00,604795),('1','146','209642','325',334.00,400.00,0.00,1760.00,587840.00,704000.00,116160.00,605317),('1','146','209791','325',334.00,400.00,0.00,767.50,260882.50,307000.00,46117.50,605715),('1','146','209861','325',364.00,420.00,0.00,2618.30,953061.20,1099686.00,146624.80,605887),('1','146','210098','325',364.00,420.00,0.00,2242.71,816346.44,941938.20,125591.76,606511),('1','146','210262','325',364.00,420.00,0.00,629.27,229054.28,264293.40,35239.12,606929),('1','146','210316','325',364.00,420.00,0.00,3250.97,1183353.08,1365407.40,182054.32,607063),('1','146','210527','325',364.00,420.00,0.00,1612.19,586837.16,677119.80,90282.64,607618),('1','146','210689','325',364.00,420.00,0.00,275.00,100100.00,115500.00,15400.00,608059),('1','146','210722','325',364.00,420.00,0.00,3002.58,1092939.12,1261083.60,168144.48,608143),('1','146','210946','325',364.00,420.00,0.00,2184.75,795249.00,917595.00,122346.00,608713),('1','146','211117','325',364.00,420.00,0.00,895.01,325783.64,375904.20,50120.56,609153),('1','146','211165','325',364.00,420.00,0.00,2984.04,1086190.56,1253296.80,167106.24,609275),('1','146','211376','325',364.00,420.00,0.00,587.28,213769.92,246657.60,32887.68,609820),('1','146','211494','325',364.00,420.00,0.00,2567.98,934744.72,1078551.60,143806.88,610132),('1','146','211626','325',364.00,420.00,0.00,1649.98,600592.72,692991.60,92398.88,610473),('1','146','211767','325',364.00,420.00,0.00,1586.86,577794.16,666481.20,88687.04,610830),('1','146','211923','325',376.00,420.00,0.00,626.19,235447.44,262999.80,27552.36,611232),('1','146','211988','325',376.00,420.00,0.00,2189.77,823353.52,919703.40,96349.88,611397),('1','146','212232','325',376.00,420.00,0.00,2252.28,846857.28,945957.60,99100.32,612036),('1','146','212459','325',376.00,420.00,0.00,513.10,192925.60,215502.00,22576.40,612637),('1','146','212531','325',376.00,420.00,0.00,1786.11,671577.36,750166.20,78588.84,612829),('1','146','212668','325',376.00,420.00,0.00,405.24,152370.24,170200.80,17830.56,613192),('1','146','212719','325',376.00,420.00,0.00,1875.96,705360.96,787903.20,82542.24,613326),('1','146','212888','325',376.00,420.00,0.00,3105.99,1167852.24,1304515.80,136663.56,613757),('1','146','213124','325',376.00,420.00,0.00,461.43,173497.68,193800.60,20302.92,614388),('1','146','213227','325',376.00,420.00,0.00,1825.63,686436.88,766764.60,80327.72,614648),('1','146','213390','325',376.00,420.00,0.00,3152.11,1185193.36,1323886.20,138692.84,615066),('1','146','213635','325',376.00,420.00,0.00,775.45,291569.20,325689.00,34119.80,615719),('1','146','213724','325',376.00,420.00,0.00,2168.52,815363.52,910778.40,95414.88,615951),('1','146','213907','325',376.00,420.00,0.00,2888.56,1086098.56,1213195.20,127096.64,616421),('1','146','214098','325',376.00,420.00,0.00,797.74,299950.24,335050.80,35100.56,616925),('1','146','214178','325',376.00,420.00,0.00,2608.16,980668.16,1095427.20,114759.04,617126),('1','146','214342','325',376.00,420.00,0.00,2508.00,943008.00,1053360.00,110352.00,617556),('1','146','214531','325',376.00,420.00,0.00,3549.48,1334604.48,1490781.60,156177.12,618042),('1','146','214774','325',376.00,420.00,0.00,1640.54,616843.04,689026.80,72183.76,618680),('1','146','214954','325',376.00,420.00,0.00,708.29,266317.04,297481.80,31164.76,619163),('1','146','215103','325',376.00,420.00,0.00,2543.90,956506.40,1068438.00,111931.60,619542),('1','146','215213','325',448.00,0.00,0.00,2079.87,782031.12,931781.76,149750.64,619824),('1','146','215444','325',376.00,448.00,0.00,2790.57,1071084.62,1250175.36,179090.74,620405),('1','146','215673','325',386.00,448.00,0.00,2091.67,807384.62,937068.16,129683.54,621009),('1','146','215850','325',386.00,448.00,0.00,425.00,164050.00,190400.00,26350.00,621451),('1','146','215905','325',386.00,448.00,0.00,2879.13,1134704.68,1289850.24,155145.56,621593),('1','146','216101','325',396.00,448.00,0.00,1809.99,716756.04,810875.52,94119.48,622108),('1','146','216265','325',396.00,448.00,0.00,999.99,390627.74,447995.52,57367.78,622536),('1','146','216318','325',386.00,452.00,0.00,3013.26,1163118.36,1361993.52,198875.16,622674),('1','146','216549','325',386.00,452.00,0.00,1162.97,448906.42,525662.44,76756.02,623286),('1','146','216688','325',386.00,452.00,0.00,1270.95,490586.70,574469.40,83882.70,623649),('1','146','216788','325',386.00,452.00,0.00,3104.76,1198437.36,1403351.52,204914.16,623913),('1','146','217019','325',386.00,480.00,0.00,865.17,333955.62,415281.60,81325.98,624512),('1','146','217137','325',386.00,480.00,0.00,1637.83,685822.38,786158.40,100336.02,624821),('1','146','217267','325',421.00,480.00,0.00,3222.26,1356571.46,1546684.80,190113.34,625173),('1','146','217494','325',421.00,480.00,0.00,195.63,82360.23,93902.40,11542.17,625770),('1','146','217533','325',421.00,480.00,0.00,2240.21,956583.81,1075300.80,118716.99,625850),('1','146','217707','325',431.00,480.00,0.00,2992.41,1289728.71,1436356.80,146628.09,626315),('1','146','217971','325',431.00,480.00,0.00,2849.65,1228199.15,1367832.00,139632.85,627018),('1','146','218207','325',431.00,480.00,0.00,2130.70,918331.70,1022736.00,104404.30,627638),('1','146','218437','325',431.00,480.00,0.00,2631.18,1134038.58,1262966.40,128927.82,628240),('1','146','218683','325',431.00,480.00,0.00,2533.24,1091826.44,1215955.20,124128.76,628872),('1','146','218906','325',431.00,480.00,0.00,406.09,175024.79,194923.20,19898.41,629459),('1','146','218956','325',431.00,480.00,0.00,2339.70,1008410.70,1123056.00,114645.30,629585),('1','146','219110','325',431.00,480.00,0.00,2630.45,1133723.95,1262616.00,128892.05,629991),('1','146','219341','325',431.00,480.00,0.00,371.49,160112.19,178315.20,18203.01,630586),('1','146','219472','325',431.00,480.00,0.00,1801.26,776343.06,864604.80,88261.74,630934),('1','146','219651','325',431.00,480.00,0.00,3040.17,1310313.27,1459281.60,148968.33,631400),('1','146','219803','325',431.00,480.00,0.00,358.98,154720.38,172310.40,17590.02,631812),('1','146','219887','325',431.00,480.00,0.00,2265.13,976271.03,1087262.40,110991.37,632026),('1','146','220031','325',431.00,480.00,0.00,2916.12,1256847.72,1399737.60,142889.88,632423),('1','146','220242','325',431.00,480.00,0.00,2594.10,1118057.10,1245168.00,127110.90,632971),('1','146','220467','325',431.00,480.00,0.00,2601.18,1121108.58,1248566.40,127457.82,633558),('1','146','220677','325',431.00,480.00,0.00,3001.32,1293568.92,1440633.60,147064.68,634111),('1','146','220897','325',431.00,480.00,0.00,2639.53,1137637.43,1266974.40,129336.97,634686),('1','146','221156','325',431.00,480.00,0.00,3296.57,1420821.67,1582353.60,161531.93,635336),('1','146','221373','325',431.00,480.00,0.00,2256.26,972448.06,1083004.80,110556.74,635927),('1','146','221605','325',431.00,480.00,0.00,2809.39,1210847.09,1348507.20,137660.11,636533),('1','146','221821','325',431.00,480.00,0.00,1628.02,701676.62,781449.60,79772.98,637095),('1','146','222164','325',431.00,480.00,0.00,1069.26,460851.06,513244.80,52393.74,637970),('1','146','222261','325',431.00,480.00,0.00,2854.98,1230496.38,1370390.40,139894.02,638224),('1','146','222493','325',431.00,480.00,0.00,2787.40,1201369.40,1337952.00,136582.60,638813),('1','146','222772','325',436.00,480.00,0.00,3491.69,1522376.84,1676011.20,153634.36,639544),('1','146','222931','325',436.00,480.00,0.00,1172.00,510992.00,562560.00,51568.00,639990),('1','146','223150','325',436.00,480.00,0.00,1217.50,530830.00,584400.00,53570.00,640566),('1','146','223173','325',436.00,480.00,0.00,3021.93,1317561.48,1450526.40,132964.92,640616),('1','146','223410','325',436.00,480.00,0.00,1040.22,453535.92,499305.60,45769.68,641193),('1','146','223552','325',436.00,480.00,0.00,538.58,234820.88,258518.40,23697.52,641549),('1','146','223559','325',436.00,480.00,0.00,785.99,360769.41,402426.88,41657.47,641566),('1','146','223843','325',459.00,512.00,0.00,125.51,57609.09,64261.12,6652.03,642306),('1','146','223907','325',459.00,512.00,0.00,116.26,53363.34,59525.12,6161.78,642456),('1','146','223942','325',459.00,512.00,0.00,552.41,274935.33,282833.92,7898.59,642550),('1','146','224077','325',512.00,512.00,0.00,2656.71,1360235.52,1360235.52,0.00,642911),('1','146','224303','325',512.00,512.00,0.00,1906.12,975933.44,975933.44,0.00,643496),('1','146','224481','325',512.00,512.00,0.00,558.08,265435.84,285736.96,20301.12,643973),('1','146','224528','325',459.00,512.00,0.00,2900.55,1331352.45,1485081.60,153729.15,644092),('1','146','224769','325',459.00,512.00,0.00,1574.70,722787.30,806246.40,83459.10,644711),('1','146','224965','325',459.00,512.00,0.00,312.79,143570.61,160148.48,16577.87,645217),('1','146','225004','325',459.00,512.00,0.00,2307.89,1059321.51,1181639.68,122318.17,645317),('1','146','225462','325',459.00,512.00,0.00,2812.31,1290850.29,1439902.72,149052.43,646500),('1','146','225946','325',459.00,512.00,0.00,2563.38,1217605.50,1312450.56,94845.06,647766),('1','146','225948','325',475.00,512.00,0.00,630.22,299354.50,322672.64,23318.14,647769),('1','146','225951','325',475.00,544.00,0.00,1871.44,888934.00,1018063.36,129129.36,647776),('1','146','225989','325',475.00,544.00,0.00,2105.40,1000065.00,1145337.60,145272.60,647858),('1','146','226290','325',475.00,544.00,0.00,2488.10,1181847.50,1353526.40,171678.90,648638),('1','146','226473','325',475.00,544.00,0.00,130.26,61873.50,70861.44,8987.94,649108),('1','146','226494','325',475.00,544.00,0.00,1939.52,921272.00,1055098.88,133826.88,649147),('1','146','226732','325',475.00,544.00,0.00,2592.11,1231252.25,1410107.84,178855.59,649777),('1','146','226954','325',475.00,544.00,0.00,908.81,431684.75,494392.64,62707.89,650364),('1','146','227078','325',475.00,544.00,0.00,1255.45,607351.84,682964.80,75612.96,650678),('1','146','227186','325',486.00,544.00,0.00,2980.27,1448411.22,1621266.88,172855.66,650960),('1','146','227459','325',486.00,544.00,0.00,462.72,224881.92,251719.68,26837.76,651658),('1','146','227466','325',486.00,544.00,0.00,1967.47,956190.42,1070303.68,114113.26,651676),('1','146','227584','325',486.00,544.00,0.00,0.00,0.00,0.00,0.00,651996),('1','146','227610','325',486.00,544.00,0.00,3164.23,1537815.78,1721341.12,183525.34,652048),('1','146','227830','325',486.00,544.00,0.00,277.21,134724.06,150802.24,16078.18,652634),('1','146','227856','325',486.00,544.00,0.00,3035.16,1475087.76,1651127.04,176039.28,652686),('1','146','228115','325',486.00,544.00,0.00,2000.32,972155.52,1088174.08,116018.56,653377),('1','146','228328','325',486.00,544.00,0.00,427.20,207619.20,232396.80,24777.60,653943),('1','146','228344','325',486.00,544.00,0.00,24.45,11882.70,13300.80,1418.10,653972),('1','146','228353','325',486.00,560.00,0.00,2797.24,1359458.64,1566454.40,206995.76,653987),('1','146','228522','325',486.00,560.00,0.00,907.14,440870.04,507998.40,67128.36,654425),('1','146','228607','325',486.00,560.00,0.00,1966.48,955709.28,1101228.80,145519.52,654624),('1','146','228752','325',486.00,560.00,0.00,2876.69,1398071.34,1610946.40,212875.06,655008),('1','146','229148','325',486.00,560.00,0.00,3117.64,1515173.04,1745878.40,230705.36,656050),('1','146','229328','325',486.00,560.00,0.00,1805.32,877385.52,1010979.20,133593.68,656506),('1','146','229353','325',486.00,560.00,0.00,910.54,442522.44,509902.40,67379.96,656579),('1','146','229649','325',486.00,560.00,0.00,2788.42,1466708.92,1628437.28,161728.36,657335),('1','146','229730','325',526.00,584.00,0.00,1164.54,612548.04,680091.36,67543.32,657523),('1','146','229762','325',526.00,584.00,0.00,1648.52,867121.52,962735.68,95614.16,657603),('1','146','229896','325',526.00,584.00,0.00,2455.87,1291787.62,1434228.08,142440.46,657950),('1','146','230051','325',526.00,584.00,0.00,426.90,224549.40,249309.60,24760.20,658371),('1','146','230089','325',526.00,584.00,0.00,2955.34,1554508.84,1725918.56,171409.72,658452),('1','146','230286','325',526.00,584.00,0.00,1640.34,862818.84,957958.56,95139.72,658955),('1','146','230465','325',526.00,584.00,0.00,0.00,0.00,0.00,0.00,659438),('1','146','230478','325',526.00,584.00,0.00,1068.92,562251.92,624249.28,61997.36,659468),('1','146','230525','325',526.00,584.00,0.00,2633.48,1385210.48,1537952.32,152741.84,659580),('1','146','230781','325',526.00,584.00,0.00,1578.37,830222.62,921768.08,91545.46,660248),('1','146','230976','325',526.00,584.00,0.00,0.00,0.00,0.00,0.00,660767),('1','146','230981','325',526.00,584.00,0.00,0.00,0.00,0.00,0.00,660780),('1','146','231001','325',526.00,584.00,0.00,1125.00,591750.00,657000.00,65250.00,660837),('1','146','231066','325',526.00,584.00,0.00,2958.42,1556128.92,1727717.28,171588.36,660998),('1','146','231371','325',526.00,584.00,0.00,1881.36,989595.36,1098714.24,109118.88,661819),('1','146','231604','325',526.00,584.00,0.00,0.00,0.00,0.00,0.00,662445),('1','146','231605','325',526.00,584.00,0.00,648.93,341337.18,378975.12,37637.94,662446),('1','146','231633','325',526.00,584.00,0.00,3039.55,1598803.30,1775097.20,176293.90,662504),('1','146','231881','325',526.00,584.00,0.00,2313.08,1216680.08,1350838.72,134158.64,663183),('1','146','232071','325',526.00,584.00,0.00,86.81,45662.06,50697.04,5034.98,663693),('1','146','232092','325',526.00,584.00,0.00,3142.46,1652933.96,1835196.64,182262.68,663744),('1','146','232338','325',526.00,584.00,0.00,2136.35,1123720.10,1247628.40,123908.30,664365),('1','146','232583','325',546.00,600.00,0.00,2596.95,1417934.70,1558170.00,140235.30,665028),('1','146','232841','325',546.00,600.00,0.00,2984.79,1629695.34,1790874.00,161178.66,665708),('1','146','233082','325',546.00,600.00,0.00,66.83,36489.18,40098.00,3608.82,666346),('1','146','233115','325',546.00,600.00,0.00,2667.80,1456618.80,1600680.00,144061.20,666416),('1','146','233337','325',546.00,600.00,0.00,0.00,0.00,0.00,0.00,667012),('1','146','233339','325',546.00,600.00,0.00,0.00,0.00,0.00,0.00,667016),('1','146','233363','325',570.00,624.00,0.00,2409.50,1373415.00,1503528.00,130113.00,667074),('1','146','233586','325',570.00,624.00,0.00,191.99,109434.30,119801.76,10367.46,667664),('1','146','233678','325',570.00,624.00,0.00,0.00,0.00,0.00,0.00,667886),('1','146','233682','325',570.00,624.00,0.00,2287.55,1303903.50,1427431.20,123527.70,667896),('1','146','233828','325',570.00,624.00,0.00,2748.99,1566924.30,1715369.76,148445.46,668297),('1','146','234032','325',570.00,624.00,0.00,261.07,148809.90,162907.68,14097.78,668839),('1','146','234149','325',570.00,624.00,0.00,0.00,0.00,0.00,0.00,669137),('1','146','234156','325',570.00,624.00,0.00,2001.29,1140735.30,1248804.96,108069.66,669155),('1','146','234310','325',570.00,624.00,0.00,2792.74,1591861.80,1742669.76,150807.96,669564),('1','146','234552','325',570.00,624.00,0.00,605.97,345402.90,378125.28,32722.38,670214),('1','146','234683','325',570.00,624.00,0.00,1509.24,860266.80,941765.76,81498.96,670555),('1','146','234784','325',570.00,624.00,0.00,27.37,15600.90,17078.88,1477.98,670832),('1','146','234812','325',570.00,624.00,0.00,2228.37,1270170.90,1390502.88,120331.98,670901),('1','146','235056','325',570.00,624.00,0.00,1262.12,719408.40,787562.88,68154.48,671568),('1','146','235191','325',570.00,624.00,0.00,0.00,0.00,0.00,0.00,671902),('1','146','235200','325',570.00,624.00,0.00,1284.62,732233.40,801602.88,69369.48,671925),('1','146','235292','325',570.00,624.00,0.00,2917.26,1662838.20,1820370.24,157532.04,672168),('1','146','235514','325',570.00,624.00,0.00,1027.60,585732.00,641222.40,55490.40,672742),('1','146','235638','325',570.00,624.00,0.00,0.00,0.00,0.00,0.00,673056),('1','146','235640','325',570.00,624.00,0.00,1345.11,766712.70,839348.64,72635.94,673060),('1','146','235742','325',570.00,640.00,0.00,2033.16,1158901.20,1301222.40,142321.20,673335),('1','146','236006','325',570.00,640.00,0.00,1797.19,1024398.30,1150201.60,125803.30,674027),('1','146','236172','325',570.00,640.00,0.00,0.00,0.00,0.00,0.00,674467),('1','146','236173','325',592.00,640.00,0.00,478.01,282981.92,305926.40,22944.48,674468),('1','146','236222','325',592.00,640.00,0.00,3088.65,1828480.80,1976736.00,148255.20,674600),('1','146','236497','325',592.00,640.00,0.00,1595.09,944293.28,1020857.60,76564.32,675327),('1','146','236655','325',592.00,640.00,0.00,0.00,0.00,0.00,0.00,675732),('1','146','236662','325',592.00,640.00,0.00,1299.68,769410.56,831795.20,62384.64,675752),('1','146','236720','325',592.00,640.00,0.00,3129.49,1852658.08,2002873.60,150215.52,675903),('1','146','236946','325',592.00,640.00,0.00,774.14,458290.88,495449.60,37158.72,676485),('1','146','237050','325',592.00,640.00,0.00,0.00,0.00,0.00,0.00,676743),('1','146','237058','325',592.00,640.00,0.00,1669.19,988160.48,1068281.60,80121.12,676762),('1','146','237162','325',592.00,640.00,0.00,2540.48,1503964.16,1625907.20,121943.04,677039),('1','146','237367','325',592.00,640.00,0.00,1070.33,633635.36,686371.20,52735.84,677570),('1','146','237509','325',592.00,640.00,0.00,66.36,39285.12,42470.40,3185.28,677934),('1','146','237511','325',592.00,640.00,0.00,1284.50,760424.00,822080.00,61656.00,677938),('1','146','237590','325',592.00,656.00,0.00,2433.03,1440353.76,1596067.68,155713.92,678155),('1','146','237853','325',592.00,640.00,0.00,1806.38,1069376.96,1156083.20,86706.24,678842),('1','146','238046','325',592.00,640.00,0.00,0.00,0.00,0.00,0.00,679331),('1','146','238047','325',592.00,640.00,0.00,1066.41,631314.72,682502.40,51187.68,679332),('1','146','238102','325',592.00,640.00,0.00,3143.35,1883108.70,2011744.00,128635.30,679487),('1','146','238347','325',602.00,640.00,0.00,1100.24,662344.48,704153.60,41809.12,680100),('1','146','238500','325',602.00,640.00,0.00,72.08,43392.16,46131.20,2739.04,680507),('1','146','238505','325',602.00,640.00,0.00,1137.25,684624.50,727840.00,43215.50,680522),('1','146','238594','325',602.00,640.00,0.00,2583.32,1555158.64,1653324.80,98166.16,680760),('1','146','238829','325',602.00,640.00,0.00,1599.43,962856.86,1023635.20,60778.34,681355),('1','146','238977','325',602.00,640.00,0.00,0.10,60.20,64.00,3.80,681741),('1','146','238981','325',602.00,640.00,0.00,711.61,428389.22,455430.40,27041.18,681751),('1','146','239054','325',602.00,640.00,0.00,2784.80,1676449.60,1782272.00,105822.40,681941),('1','146','239281','325',602.00,640.00,0.00,1987.99,1196769.98,1272313.60,75543.62,682535),('1','146','239498','325',602.00,640.00,0.00,44.83,26987.66,28691.20,1703.54,683107),('1','146','239499','325',602.00,640.00,0.00,503.71,303233.42,322374.40,19140.98,683108),('1','146','239518','325',602.00,640.00,0.00,2671.51,1608249.02,1709766.40,101517.38,683154),('1','146','239763','325',602.00,640.00,0.00,2044.78,1230957.56,1308659.20,77701.64,683792),('1','146','239952','325',602.00,640.00,0.00,90.30,54360.60,57792.00,3431.40,684287),('1','146','239987','325',602.00,640.00,0.00,249.44,150162.88,159641.60,9478.72,684373),('1','146','239991','325',602.00,640.00,0.00,2338.94,1408041.88,1496921.60,88879.72,684379),('1','146','240186','325',602.00,640.00,0.00,2368.70,1425957.40,1515968.00,90010.60,684889),('1','146','240438','325',602.00,640.00,0.00,102.92,61957.84,65868.80,3910.96,685545),('1','146','240504','325',602.00,640.00,0.00,85.00,51170.00,54400.00,3230.00,685699),('1','146','240508','325',602.00,640.00,0.00,1782.82,1073257.64,1141004.80,67747.16,685709),('1','146','240667','325',602.00,640.00,0.00,2660.73,1601759.46,1702867.20,101107.74,686103),('1','146','240962','325',602.00,640.00,0.00,846.45,509562.90,541728.00,32165.10,686887),('1','146','241089','325',602.00,640.00,0.00,90.00,54180.00,57600.00,3420.00,687213),('1','146','241090','325',602.00,640.00,0.00,1078.62,649329.24,690316.80,40987.56,687214),('1','146','241207','325',602.00,640.00,0.00,2093.97,1260569.94,1340140.80,79570.86,687532),('1','146','241467','325',602.00,640.00,0.00,2237.41,1346920.82,1431942.40,85021.58,688228),('1','146','241687','325',602.00,640.00,0.00,115.14,69314.28,73689.60,4375.32,688803),('1','146','241726','325',602.00,640.00,0.00,2471.83,1488041.66,1581971.20,93929.54,688897),('1','146','241960','325',602.00,640.00,0.00,2439.27,1468440.54,1561492.80,93052.26,689519),('1','146','242245','325',602.00,640.00,0.00,127.21,76580.42,81414.40,4833.98,690243),('1','146','242246','325',602.00,640.00,0.00,2106.42,1268064.84,1348108.80,80043.96,690244),('1','146','242411','325',602.00,640.00,0.00,3017.44,1816498.88,1931161.60,114662.72,690684),('1','146','242660','325',602.00,640.00,0.00,282.68,170173.36,180915.20,10741.84,691324),('1','146','242738','325',602.00,640.00,0.00,0.00,0.00,0.00,0.00,691515),('1','146','242751','325',602.00,640.00,0.00,2293.90,1380927.80,1468096.00,87168.20,691547),('1','146','242905','325',602.00,640.00,0.00,2659.22,1600850.44,1701900.80,101050.36,691972),('1','146','243126','325',602.00,640.00,0.00,476.88,287081.76,305203.20,18121.44,692550),('1','146','243230','325',592.00,640.00,0.00,2045.70,1211054.40,1309248.00,98193.60,692801),('1','146','243360','325',592.00,640.00,0.00,3090.26,1829433.92,1977766.40,148332.48,693163),('1','146','243590','325',592.00,640.00,0.00,34.04,20151.68,21785.60,1633.92,693752),('1','146','243646','325',592.00,640.00,0.00,134.40,79564.80,86016.00,6451.20,693877),('1','146','243650','325',592.00,640.00,0.00,2710.30,1604497.60,1734592.00,130094.40,693887),('1','146','243814','325',592.00,640.00,0.00,2389.70,1414702.40,1529408.00,114705.60,694341),('1','146','243989','325',592.00,640.00,0.00,24.08,14255.36,15411.20,1155.84,694784),('1','146','243990','325',592.00,640.00,0.00,283.44,167796.48,181401.60,13605.12,694785),('1','146','244030','325',592.00,640.00,0.00,3009.09,1781381.28,1925817.60,144436.32,694895),('1','146','244267','325',592.00,640.00,0.00,1677.47,993062.24,1073580.80,80518.56,695518),('1','146','244449','325',592.00,640.00,0.00,5.97,3534.24,3820.80,286.56,695978),('1','146','244450','325',592.00,640.00,0.00,548.17,324516.64,350828.80,26312.16,695979),('1','146','244499','325',592.00,640.00,0.00,2649.78,1568669.76,1695859.20,127189.44,696113),('1','146','244738','325',592.00,640.00,0.00,1892.05,1120093.60,1210912.00,90818.40,696732),('1','146','244901','325',592.00,640.00,0.00,21.43,12686.56,13715.20,1028.64,697159),('1','146','244902','325',592.00,640.00,0.00,563.53,333609.76,360659.20,27049.44,697160),('1','146','244977','325',592.00,632.00,0.00,2644.07,1565289.44,1671052.24,105762.80,697352),('1','146','245197','325',592.00,632.00,0.00,2150.69,1273208.48,1359236.08,86027.60,697925),('1','146','245357','325',592.00,632.00,0.00,1.71,1012.32,1080.72,68.40,698328),('1','146','245443','325',572.00,632.00,0.00,3023.30,1729327.60,1910725.60,181398.00,698541),('1','146','245670','325',572.00,632.00,0.00,2024.99,1158294.28,1279793.68,121499.40,699137),('1','146','245877','325',572.00,632.00,0.00,37.63,21524.36,23782.16,2257.80,699678),('1','146','245925','325',572.00,616.00,0.00,2740.43,1554336.14,1688104.88,133768.74,699810),('1','146','246169','325',558.00,616.00,0.00,2258.10,1260019.80,1390989.60,130969.80,700438),('1','146','246404','325',558.00,616.00,0.00,2751.87,1535543.46,1695151.92,159608.46,701064),('1','146','246694','325',558.00,616.00,0.00,2518.13,1405116.54,1551168.08,146051.54,701820),('1','146','246886','325',558.00,616.00,0.00,60.29,33641.82,37138.64,3496.82,702312),('1','146','246887','325',558.00,616.00,0.00,114.45,63863.10,70501.20,6638.10,702313),('1','146','246923','325',558.00,616.00,0.00,2845.78,1587945.24,1753000.48,165055.24,702407),('1','146','247157','325',558.00,616.00,0.00,2575.04,1436872.32,1586224.64,149352.32,703018),('1','146','247374','325',558.00,616.00,0.00,0.00,0.00,0.00,0.00,703571),('1','146','247401','325',558.00,616.00,0.00,2560.14,1428558.12,1577046.24,148488.12,703618),('1','146','247660','325',558.00,616.00,0.00,943.14,526272.12,577516.80,51244.68,704313),('1','146','247768','325',558.00,592.00,0.00,1950.82,1088557.56,1154885.44,66327.88,704560),('1','146','247938','325',558.00,592.00,0.00,87.52,48836.16,51811.84,2975.68,705004),('1','146','247950','325',558.00,592.00,0.00,2897.74,1616938.92,1715462.08,98523.16,705030),('1','146','248151','325',558.00,592.00,0.00,2352.26,1312561.08,1392537.92,79976.84,705575),('1','146','248319','325',558.00,592.00,0.00,17.77,9915.66,10519.84,604.18,706016),('1','146','248320','325',558.00,592.00,0.00,577.38,322178.04,341808.96,19630.92,706017),('1','146','248396','325',558.00,592.00,0.00,4056.60,2263582.80,2401507.20,137924.40,706209),('1','146','248637','325',558.00,592.00,0.00,685.68,382609.44,405922.56,23313.12,706824),('1','146','248721','325',558.00,592.00,0.00,90.69,50605.02,53688.48,3083.46,707030),('1','146','248722','325',558.00,592.00,0.00,1638.94,914528.52,970252.48,55723.96,707031),('1','146','248858','325',558.00,592.00,0.00,1904.43,1062671.94,1127422.56,64750.62,707396),('1','146','249093','325',558.00,592.00,0.00,1057.53,590101.74,626057.76,35956.02,708012),('1','146','249238','325',558.00,592.00,0.00,1226.01,662667.66,725797.92,63130.26,708365),('1','146','249341','325',510.00,592.00,0.00,2018.22,1029292.20,1194786.24,165494.04,708627),('1','146','249572','325',510.00,592.00,0.00,2110.31,1076258.10,1249303.52,173045.42,709225),('1','146','249802','325',510.00,592.00,0.00,0.00,0.00,0.00,0.00,709820),('1','146','249861','325',510.00,592.00,0.00,2175.72,1109617.20,1288026.24,178409.04,709952),('1','146','250081','325',510.00,592.00,0.00,2376.17,1211846.70,1406692.64,194845.94,710530),('1','146','250341','325',510.00,592.00,0.00,590.51,301160.10,349581.92,48421.82,711178),('1','146','250416','325',510.00,592.00,0.00,1661.94,847589.40,983868.48,136279.08,711353),('1','146','250552','325',510.00,592.00,0.00,1676.41,854969.10,992434.72,137465.62,711729),('1','146','250812','325',510.00,592.00,0.00,1742.24,888542.40,1031406.08,142863.68,712388),('1','146','250978','325',510.00,592.00,0.00,0.00,0.00,0.00,0.00,712833),('1','146','251016','325',510.00,592.00,0.00,2381.28,1214452.80,1409717.76,195264.96,712929),('1','146','251294','325',510.00,592.00,0.00,2771.90,1413669.00,1640964.80,227295.80,713632),('1','146','251502','325',510.00,592.00,0.00,187.81,95783.10,111183.52,15400.42,714203),('1','146','251600','325',510.00,592.00,0.00,0.00,0.00,0.00,0.00,714436),('1','146','251607','325',510.00,592.00,0.00,2002.85,1021453.50,1185687.20,164233.70,714454),('1','146','251752','325',510.00,592.00,0.00,2598.17,1325066.70,1538116.64,213049.94,714855),('1','146','252002','325',510.00,592.00,0.00,814.48,415384.80,482172.16,66787.36,715497),('1','146','252085','325',510.00,592.00,0.00,0.00,0.00,0.00,0.00,715707),('1','146','252086','325',510.00,592.00,0.00,2531.86,1291248.60,1498861.12,207612.52,715708),('1','146','252241','325',510.00,592.00,0.00,2723.24,1388852.40,1612158.08,223305.68,716124),('1','146','252467','325',510.00,592.00,0.00,2763.54,1409405.40,1636015.68,226610.28,716719),('1','146','252719','325',510.00,592.00,0.00,2706.91,1380524.10,1602490.72,221966.62,717363),('1','146','252975','325',510.00,592.00,0.00,2396.31,1222118.10,1418615.52,196497.42,718024),('1','146','253203','325',510.00,592.00,0.00,3006.75,1533442.50,1779996.00,246553.50,718636),('1','146','253472','325',510.00,592.00,0.00,2843.58,1450225.80,1683399.36,233173.56,719328),('1','146','253713','325',510.00,592.00,0.00,2468.27,1258817.70,1461215.84,202398.14,719947),('1','146','253888','325',510.00,592.00,0.00,57.10,29121.00,33803.20,4682.20,720408),('1','146','253943','325',510.00,592.00,0.00,2784.22,1419952.20,1648258.24,228306.04,720557),('1','146','254198','325',510.00,592.00,0.00,2445.38,1247143.80,1447664.96,200521.16,721205),('1','146','254433','325',510.00,592.00,0.00,63.74,32507.40,37734.08,5226.68,721834),('1','146','254488','325',510.00,592.00,0.00,2579.67,1315631.70,1527164.64,211532.94,721940),('1','146','254708','325',510.00,592.00,0.00,2368.22,1207792.20,1401986.24,194194.04,722509),('1','146','254929','325',510.00,592.00,0.00,466.31,237818.10,276055.52,38237.42,723086),('1','146','255041','325',510.00,592.00,0.00,1623.17,827816.70,960916.64,133099.94,723349),('1','146','255178','325',510.00,592.00,0.00,2485.03,1267365.30,1471137.76,203772.46,723730),('1','146','255449','325',510.00,592.00,0.00,1416.80,722568.00,838745.60,116177.60,724401),('1','146','255594','325',510.00,592.00,0.00,1381.92,704779.20,818096.64,113317.44,724724),('1','146','255699','325',510.00,592.00,0.00,3385.52,1726615.20,2004227.84,277612.64,725019),('1','146','255956','325',510.00,592.00,0.00,398.55,203260.50,235941.60,32681.10,725658),('1','146','256048','325',510.00,592.00,0.00,1935.49,987099.90,1145810.08,158710.18,725887),('1','146','256207','325',510.00,592.00,0.00,2609.57,1330880.70,1544865.44,213984.74,726281),('1','146','256479','325',510.00,592.00,0.00,426.40,217464.00,252428.80,34964.80,726994),('1','146','256583','325',510.00,592.00,0.00,1731.81,883223.10,1025231.52,142008.42,727245),('1','146','256712','325',510.00,592.00,0.00,2516.42,1283374.20,1489720.64,206346.44,727595),('1','146','256962','325',510.00,592.00,0.00,1141.77,582302.70,675927.84,93625.14,728250),('1','146','257105','325',510.00,592.00,0.00,1326.41,676469.10,785234.72,108765.62,728612),('1','146','257223','325',510.00,592.00,0.00,2912.39,1485318.90,1724134.88,238815.98,728937),('1','146','257494','325',510.00,568.00,0.00,811.97,414104.70,461198.96,47094.26,729636),('1','146','257587','325',510.00,568.00,0.00,2163.68,1103476.80,1228970.24,125493.44,729861),('1','146','257588','325',510.00,568.00,0.00,2867.83,1462593.30,1628927.44,166334.14,729862),('1','146','257589','325',510.00,568.00,0.00,459.65,233809.90,261081.20,27271.30,729863),('1','146','257590','325',500.00,568.00,0.00,1944.71,972355.00,1104595.28,132240.28,729864),('1','146','257591','325',500.00,568.00,0.00,2791.36,1395680.00,1585924.48,190244.48,729865),('1','146','257592','325',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729866),('1','146','257593','325',500.00,568.00,0.00,3142.22,1571110.00,1784780.96,213670.96,729867),('1','146','257594','325',500.00,568.00,0.00,1981.38,990690.00,1125423.84,134733.84,729868),('1','146','257595','325',500.00,568.00,0.00,700.63,350315.00,397957.84,47642.84,729869),('1','146','257596','325',500.00,568.00,0.00,3534.53,1767265.00,2007613.04,240348.04,729870),('1','146','257597','325',500.00,568.00,0.00,865.97,432985.00,491870.96,58885.96,729871),('1','146','257598','325',500.00,568.00,0.00,1929.97,964985.00,1096222.96,131237.96,729872),('1','146','257599','325',500.00,568.00,0.00,2875.70,1437850.00,1633397.60,195547.60,729873),('1','146','257600','325',500.00,568.00,0.00,93.39,46695.00,53045.52,6350.52,729874),('1','146','257601','325',500.00,568.00,0.00,2976.47,1488235.00,1690634.96,202399.96,729875),('1','146','257602','325',500.00,568.00,0.00,2695.16,1347580.00,1530850.88,183270.88,729876),('1','146','257603','325',500.00,568.00,0.00,3225.50,1612750.00,1832084.00,219334.00,729877),('1','146','257604','325',500.00,568.00,0.00,1822.71,911355.00,1035299.28,123944.28,729878),('1','146','257605','325',500.00,568.00,0.00,1029.42,514710.00,584710.56,70000.56,729879),('1','146','257606','325',500.00,568.00,0.00,3013.21,1506605.00,1711503.28,204898.28,729880),('1','146','257607','325',500.00,568.00,0.00,1152.59,576295.00,654671.12,78376.12,729881),('1','146','257608','325',500.00,568.00,0.00,908.14,454070.00,515823.52,61753.52,729882),('1','146','257609','325',500.00,568.00,0.00,2561.02,1280510.00,1454659.36,174149.36,729883),('1','146','257610','325',500.00,568.00,0.00,221.80,110900.00,125982.40,15082.40,729884),('1','146','257611','325',500.00,568.00,0.00,1859.44,929720.00,1056161.92,126441.92,729885),('1','146','257612','325',500.00,568.00,0.00,2740.89,1370445.00,1556825.52,186380.52,729886),('1','146','257613','325',500.00,568.00,0.00,712.99,356495.00,404978.32,48483.32,729887),('1','146','257614','325',500.00,568.00,0.00,2044.50,1022250.00,1161276.00,139026.00,729888),('1','146','257615','325',500.00,568.00,0.00,2545.18,1272590.00,1445662.24,173072.24,729889),('1','146','257616','325',500.00,568.00,0.00,903.26,451630.00,513051.68,61421.68,729890),('1','146','257617','325',500.00,568.00,0.00,1240.79,620395.00,704768.72,84373.72,729891),('1','146','257618','325',500.00,568.00,0.00,2823.00,1411500.00,1603464.00,191964.00,729892),('1','146','257619','325',500.00,568.00,0.00,1152.36,576180.00,654540.48,78360.48,729893),('1','146','257620','325',500.00,568.00,0.00,1314.30,657150.00,746522.40,89372.40,729894),('1','146','257621','325',500.00,568.00,0.00,2637.01,1318505.00,1497821.68,179316.68,729895),('1','146','257622','325',500.00,568.00,0.00,1208.91,604455.00,686660.88,82205.88,729896),('1','146','257623','325',500.00,568.00,0.00,1360.81,680405.00,772940.08,92535.08,729897),('1','146','257624','325',500.00,568.00,0.00,2675.76,1337880.00,1519831.68,181951.68,729898),('1','146','257625','325',500.00,568.00,0.00,1243.59,621795.00,706359.12,84564.12,729899),('1','146','257626','325',500.00,568.00,0.00,1350.56,675280.00,767118.08,91838.08,729900),('1','146','257627','325',500.00,568.00,0.00,2536.51,1268255.00,1440737.68,172482.68,729901),('1','146','257628','325',500.00,568.00,0.00,1514.61,757305.00,860298.48,102993.48,729902),('1','146','257629','325',500.00,568.00,0.00,389.84,194920.00,221429.12,26509.12,729903),('1','146','257630','325',500.00,568.00,0.00,2936.83,1468415.00,1668119.44,199704.44,729904),('1','146','257631','325',500.00,568.00,0.00,2643.44,1321720.00,1501473.92,179753.92,729905),('1','146','257632','325',500.00,580.00,0.00,740.48,375571.84,429478.40,53906.56,729906),('1','146','257633','325',532.00,580.00,0.00,2125.41,1130718.12,1232737.80,102019.68,729907),('1','146','257634','325',532.00,580.00,0.00,2824.00,1502368.00,1637920.00,135552.00,729908),('1','146','257635','325',532.00,580.00,0.00,367.64,195584.48,213231.20,17646.72,729909),('1','146','257636','325',532.00,580.00,0.00,2538.50,1350482.00,1472330.00,121848.00,729910),('1','146','257637','325',532.00,580.00,0.00,2480.43,1319588.76,1438649.40,119060.64,729911),('1','146','257638','325',532.00,580.00,0.00,3964.98,2109369.36,2299688.40,190319.04,729912),('1','146','257639','325',532.00,580.00,0.00,1604.32,853498.24,930505.60,77007.36,729913),('1','146','257640','325',532.00,580.00,0.00,1404.69,747295.08,814720.20,67425.12,729914),('1','146','257641','325',532.00,580.00,0.00,2454.80,1305953.60,1571072.00,265118.40,729915),('1','146','257642','325',532.00,640.00,0.00,734.64,399534.98,470169.60,70634.62,729916),('1','146','257643','325',582.00,640.00,0.00,1825.35,1062353.70,1168224.00,105870.30,729917),('1','146','257644','325',582.00,640.00,0.00,2636.31,1534332.42,1687238.40,152905.98,729918),('1','146','257645','325',582.00,640.00,0.00,1809.86,1053338.52,1158310.40,104971.88,729919),('1','146','257646','325',582.00,640.00,0.00,496.45,288933.90,317728.00,28794.10,729920),('1','146','257647','325',582.00,640.00,0.00,3279.06,1908412.92,2098598.40,190185.48,729921),('1','146','257648','325',582.00,640.00,0.00,1611.29,937770.78,1031225.60,93454.82,729922),('1','146','257649','325',582.00,640.00,0.00,757.02,440585.64,484492.80,43907.16,729923),('1','146','257650','325',606.00,680.00,0.00,2622.85,1589447.10,1783538.00,194090.90,729924),('1','146','257651','325',606.00,680.00,0.00,1565.09,948444.54,1064261.20,115816.66,729925),('1','146','257652','325',606.00,680.00,0.00,147.49,89378.94,100293.20,10914.26,729926),('1','146','257653','325',606.00,680.00,0.00,2421.83,1467628.98,1646844.40,179215.42,729927),('1','146','257654','325',606.00,680.00,0.00,2334.72,1414840.32,1587609.60,172769.28,729928),('1','146','257655','325',606.00,680.00,0.00,841.70,510070.20,572356.00,62285.80,729929),('1','146','257656','325',606.00,680.00,0.00,1646.78,997948.68,1119810.40,121861.72,729930),('1','146','257657','325',606.00,680.00,0.00,2327.54,1410489.24,1582727.20,172237.96,729931),('1','146','257658','325',606.00,680.00,0.00,1944.21,1178191.26,1322062.80,143871.54,729932),('1','146','257659','325',606.00,680.00,0.00,0.00,0.00,0.00,0.00,729933),('1','146','257660','325',606.00,680.00,0.00,2726.11,1630213.78,1853754.80,223541.02,729934),('1','146','257661','325',598.00,680.00,0.00,1892.57,1131756.86,1286947.60,155190.74,729935),('1','146','257662','325',598.00,680.00,0.00,407.79,243858.42,277297.20,33438.78,729936),('1','146','257663','325',598.00,680.00,0.00,1659.61,992446.78,1128534.80,136088.02,729937),('1','146','257664','325',598.00,680.00,0.00,2624.70,1569570.60,1784796.00,215225.40,729938),('1','146','257665','325',598.00,680.00,0.00,978.89,585376.22,665645.20,80268.98,729939),('1','146','257666','325',598.00,680.00,0.00,0.00,0.00,0.00,0.00,729940),('1','146','257667','325',598.00,680.00,0.00,1235.63,738906.74,840228.40,101321.66,729941),('1','146','257668','325',598.00,680.00,0.00,604.24,361335.52,410883.20,49547.68,729942),('1','146','257669','325',598.00,688.00,0.00,1942.54,1161638.92,1336467.52,174828.60,729943),('1','146','257670','325',598.00,688.00,0.00,1375.46,823244.61,946316.48,123071.87,729944),('1','146','257671','325',617.00,688.00,0.00,964.76,595256.92,663754.88,68497.96,729945),('1','146','257672','325',617.00,688.00,0.00,3398.79,2097053.43,2338367.52,241314.09,729946),('1','146','257673','325',617.00,688.00,0.00,794.00,489898.00,546272.00,56374.00,729947),('1','146','257674','325',617.00,688.00,0.00,1732.21,1068773.57,1191760.48,122986.91,729948),('1','146','257675','325',617.00,664.00,0.00,3183.34,1964120.78,2113737.76,149616.98,729949),('1','146','257676','325',617.00,664.00,0.00,1307.83,806931.11,868399.12,61468.01,729950),('1','146','257677','325',602.00,664.00,0.00,1884.68,1134577.36,1251427.52,116850.16,729951),('1','146','257678','325',602.00,664.00,0.00,3477.53,2093473.06,2309079.92,215606.86,729952),('1','146','257679','325',602.00,664.00,0.00,3680.68,2215769.36,2443971.52,228202.16,729953),('1','146','257680','325',602.00,664.00,0.00,1528.72,920289.44,1015070.08,94780.64,729954),('1','146','257681','325',602.00,664.00,0.00,0.00,0.00,0.00,0.00,729955),('1','146','257682','325',602.00,664.00,0.00,1099.23,661736.46,729888.72,68152.26,729956),('1','146','257683','325',602.00,664.00,0.00,3081.55,1855093.10,2046149.20,191056.10,729957),('1','146','257684','325',602.00,664.00,0.00,957.94,576679.88,636072.16,59392.28,729958),('1','146','257685','325',602.00,664.00,0.00,1547.30,931474.60,1027407.20,95932.60,729959),('1','146','257686','325',602.00,664.00,0.00,3076.31,1851938.62,2042669.84,190731.22,729960),('1','146','257687','325',602.00,664.00,0.00,478.56,288093.12,317763.84,29670.72,729961),('1','146','257688','325',602.00,664.00,0.00,2409.37,1450440.74,1599821.68,149380.94,729962),('1','146','257689','325',602.00,664.00,0.00,2576.93,1551311.86,1711081.52,159769.66,729963),('1','146','257690','325',602.00,664.00,0.00,165.21,99456.42,109699.44,10243.02,729964),('1','146','257691','325',602.00,664.00,0.00,3163.14,1904210.28,2100324.96,196114.68,729965),('1','146','257692','325',602.00,664.00,0.00,1962.21,1181250.42,1302907.44,121657.02,729966),('1','146','257693','325',602.00,664.00,0.00,2945.50,1773191.00,1955812.00,182621.00,729967),('1','146','257694','325',602.00,664.00,0.00,2014.72,1212861.44,1337774.08,124912.64,729968),('1','146','257695','325',602.00,664.00,0.00,930.87,560383.74,618097.68,57713.94,729969),('1','146','257696','325',602.00,664.00,0.00,3078.16,1853052.32,2043898.24,190845.92,729970),('1','146','257697','325',602.00,664.00,0.00,1105.37,665432.74,733965.68,68532.94,729971),('1','146','257698','325',602.00,664.00,0.00,519.24,312582.48,344775.36,32192.88,729972),('1','146','257699','325',602.00,664.00,0.00,3154.51,1899015.02,2094594.64,195579.62,729973),('1','146','257700','325',602.00,664.00,0.00,1439.26,866434.52,955668.64,89234.12,729974),('1','146','257701','325',602.00,664.00,0.00,1068.69,643351.38,709610.16,66258.78,729975),('1','146','257702','325',602.00,664.00,0.00,2490.89,1499515.78,1653950.96,154435.18,729976),('1','146','257703','325',602.00,664.00,0.00,1312.27,789468.04,871347.28,81879.24,729977),('1','146','257704','325',592.00,664.00,0.00,3203.60,1896531.20,2127190.40,230659.20,729978),('1','146','257705','325',592.00,664.00,0.00,1135.30,672097.60,753839.20,81741.60,729979),('1','146','257706','325',592.00,664.00,0.00,1717.88,1016984.96,1140672.32,123687.36,729980),('1','146','257707','325',592.00,664.00,0.00,2439.36,1444101.12,1619735.04,175633.92,729981),('1','146','257708','325',592.00,664.00,0.00,816.51,483373.92,542162.64,58788.72,729982),('1','146','257709','325',592.00,664.00,0.00,1494.80,884921.60,992547.20,107625.60,729983),('1','146','257710','325',592.00,664.00,0.00,2316.56,1371403.52,1538195.84,166792.32,729984),('1','146','257711','325',592.00,664.00,0.00,1741.13,1030748.96,1156110.32,125361.36,729985),('1','146','257712','325',592.00,664.00,0.00,546.96,323800.32,363181.44,39381.12,729986),('1','146','257713','325',592.00,664.00,0.00,2821.85,1670535.20,1873708.40,203173.20,729987),('1','146','257714','325',592.00,664.00,0.00,1651.19,977504.48,1096390.16,118885.68,729988),('1','146','257715','325',592.00,664.00,0.00,748.57,443153.44,497050.48,53897.04,729989),('1','146','257716','325',592.00,664.00,0.00,3331.79,1972419.68,2212308.56,239888.88,729990),('1','146','257717','325',592.00,664.00,0.00,1081.23,640088.16,717936.72,77848.56,729991),('1','146','257718','325',592.00,664.00,0.00,1213.04,718119.68,805458.56,87338.88,729992),('1','146','257719','325',592.00,664.00,0.00,3738.01,2212901.92,2482038.64,269136.72,729993),('1','146','257720','325',592.00,664.00,0.00,0.00,0.00,0.00,0.00,729994),('1','146','257721','325',592.00,664.00,0.00,2793.55,1653781.60,1854917.20,201135.60,729995),('1','146','257722','325',592.00,664.00,0.00,2082.35,1232751.20,1382680.40,149929.20,729996),('1','146','257723','325',592.00,664.00,0.00,0.00,0.00,0.00,0.00,729997),('1','146','257724','325',592.00,664.00,0.00,1960.42,1160568.64,1301718.88,141150.24,729998),('1','146','257725','325',592.00,664.00,0.00,2656.02,1572363.84,1763597.28,191233.44,729999),('1','146','257726','325',592.00,664.00,0.00,647.39,383254.88,429866.96,46612.08,730000),('1','146','257727','325',592.00,664.00,0.00,0.00,0.00,0.00,0.00,730001),('1','146','257728','325',592.00,664.00,0.00,1588.66,940486.72,1054870.24,114383.52,730002),('1','146','257729','325',592.00,664.00,0.00,3293.34,1949657.28,2186777.76,237120.48,730003),('1','146','257730','325',592.00,664.00,0.00,156.98,92932.16,104234.72,11302.56,730004),('1','146','257731','325',592.00,664.00,0.00,0.00,0.00,0.00,0.00,730005),('1','146','257732','325',592.00,664.00,0.00,2830.02,1675371.84,1879133.28,203761.44,730006),('1','146','257733','325',592.00,664.00,0.00,2142.83,1268555.36,1422839.12,154283.76,730007),('1','146','257734','325',592.00,664.00,0.00,99.47,58886.24,66048.08,7161.84,730008),('1','146','257735','325',592.00,664.00,0.00,0.00,0.00,0.00,0.00,730009),('1','146','257736','325',592.00,664.00,0.00,1955.34,1157561.28,1298345.76,140784.48,730010),('1','146','257737','325',592.00,664.00,0.00,1459.34,863929.28,969001.76,105072.48,730011),('1','146','257738','325',592.00,664.00,0.00,0.00,0.00,0.00,0.00,730012),('1','146','257739','325',592.00,664.00,0.00,3891.48,2303756.16,2583942.72,280186.56,730013),('1','146','257740','325',592.00,664.00,0.00,320.08,189487.36,212533.12,23045.76,730014),('1','146','257741','325',592.00,664.00,0.00,2096.41,1241074.72,1392016.24,150941.52,730015),('1','146','257742','325',592.00,664.00,0.00,2806.72,1661578.24,1863662.08,202083.84,730016),('1','146','257743','325',592.00,664.00,0.00,0.00,0.00,0.00,0.00,730017),('1','146','257744','325',592.00,680.00,0.00,3349.53,1982921.76,2277680.40,294758.64,730018),('1','146','257745','325',592.00,680.00,0.00,1883.52,1115674.34,1280793.60,165119.26,730019),('1','146','257746','325',602.00,680.00,0.00,2772.86,1669261.72,1885544.80,216283.08,730020),('1','146','257747','325',602.00,680.00,0.00,1423.88,857175.76,968238.40,111062.64,730021),('1','146','257748','325',602.00,680.00,0.00,408.37,245838.74,277691.60,31852.86,730022),('1','146','257749','325',602.00,680.00,0.00,2636.78,1587341.56,1793010.40,205668.84,730023),('1','146','257750','325',602.00,680.00,0.00,1032.87,621787.74,702351.60,80563.86,730024),('1','146','257751','325',602.00,680.00,0.00,3521.49,2119936.98,2394613.20,274676.22,730025),('1','146','257752','325',602.00,680.00,0.00,978.88,589285.76,665638.40,76352.64,730026),('1','146','257753','325',602.00,680.00,0.00,1232.51,741971.02,838106.80,96135.78,730027),('1','146','257754','325',602.00,680.00,0.00,3303.79,1988881.58,2246577.20,257695.62,730028),('1','146','257755','325',602.00,680.00,0.00,1712.96,1031201.92,1164812.80,133610.88,730029),('1','146','257756','325',602.00,680.00,0.00,0.00,0.00,0.00,0.00,730030),('1','146','257757','325',602.00,680.00,0.00,695.17,418492.34,472715.60,54223.26,730031),('1','146','257758','325',602.00,680.00,0.00,1086.73,654211.46,738976.40,84764.94,730032),('1','146','257759','325',662.00,720.00,0.00,779.46,516002.52,561211.20,45208.68,730033),('1','146','257760','325',662.00,720.00,0.00,0.00,0.00,0.00,0.00,730034),('1','146','257761','325',662.00,720.00,0.00,722.28,478149.36,520041.60,41892.24,730035),('1','146','257762','325',662.00,720.00,0.00,2599.74,1721027.88,1871812.80,150784.92,730036),('1','146','257763','325',662.00,720.00,0.00,1835.52,1215114.24,1321574.40,106460.16,730037),('1','146','257764','325',662.00,720.00,0.00,0.00,0.00,0.00,0.00,730038),('1','146','257765','325',662.00,720.00,0.00,154.86,102517.32,111499.20,8981.88,730039),('1','146','257766','325',662.00,720.00,0.00,3186.86,2109701.32,2294539.20,184837.88,730040),('1','146','257767','325',662.00,720.00,0.00,1572.10,1040730.20,1131912.00,91181.80,730041),('1','146','257768','325',662.00,720.00,0.00,0.00,0.00,0.00,0.00,730042),('1','146','257769','325',662.00,720.00,0.00,978.36,647674.32,704419.20,56744.88,730043),('1','146','257770','325',662.00,720.00,0.00,3043.11,2014538.82,2191039.20,176500.38,730044),('1','146','257771','325',662.00,760.00,0.00,750.76,497003.12,570577.60,73574.48,730045),('1','146','257772','325',662.00,760.00,0.00,0.00,0.00,0.00,0.00,730046),('1','146','257773','325',662.00,760.00,0.00,1253.10,829552.20,952356.00,122803.80,730047),('1','146','257774','325',662.00,760.00,0.00,3753.98,2485134.76,2853024.80,367890.04,730048),('1','146','257775','325',662.00,760.00,0.00,0.00,0.00,0.00,0.00,730049),('1','146','257776','325',662.00,760.00,0.00,2553.81,1690622.22,1940895.60,250273.38,730050),('1','146','257777','325',662.00,760.00,0.00,1878.37,1243480.94,1427561.20,184080.26,730051),('1','146','257778','325',662.00,760.00,0.00,0.00,0.00,0.00,0.00,730052),('1','146','257779','325',682.00,760.00,0.00,390.20,266116.40,296552.00,30435.60,730053),('1','146','257780','325',682.00,760.00,0.00,4676.38,3189291.16,3554048.80,364757.64,730054),('1','146','257781','325',682.00,760.00,0.00,508.48,346783.36,386444.80,39661.44,730055),('1','146','257782','325',682.00,760.00,0.00,0.00,0.00,0.00,0.00,730056),('1','146','257783','325',682.00,760.00,0.00,1163.53,793527.46,884282.80,90755.34,730057),('1','146','257784','325',682.00,760.00,0.00,3191.87,2176855.34,2425821.20,248965.86,730058),('1','146','257785','325',682.00,760.00,0.00,511.37,348754.34,388641.20,39886.86,730059),('1','146','257786','325',682.00,760.00,0.00,0.00,0.00,0.00,0.00,730060),('1','146','257787','325',682.00,760.00,0.00,2272.75,1550015.50,1727290.00,177274.50,730061),('1','146','257788','325',682.00,760.00,0.00,2525.58,1722445.56,1919440.80,196995.24,730062),('1','146','257789','325',682.00,760.00,0.00,0.00,0.00,0.00,0.00,730063),('1','146','257790','325',682.00,760.00,0.00,2238.73,1526813.86,1701434.80,174620.94,730064),('1','146','257791','325',682.00,760.00,0.00,2801.27,1910466.14,2128965.20,218499.06,730065),('1','146','257792','325',682.00,760.00,0.00,0.00,0.00,0.00,0.00,730066),('1','146','257793','325',682.00,760.00,0.00,366.48,249939.36,278524.80,28585.44,730067),('1','146','257794','325',682.00,760.00,0.00,2624.49,1789902.18,1994612.40,204710.22,730068),('1','146','257795','325',682.00,760.00,0.00,1412.96,963638.72,1073849.60,110210.88,730069),('1','146','257796','325',682.00,760.00,0.00,2972.00,2026904.00,2258720.00,231816.00,730070),('1','146','257797','325',682.00,760.00,0.00,2033.67,1386962.94,1545589.20,158626.26,730071),('1','146','257798','325',682.00,760.00,0.00,0.00,0.00,0.00,0.00,730072),('1','146','257799','325',682.00,760.00,0.00,884.41,603167.62,672151.60,68983.98,730073),('1','146','257800','325',682.00,760.00,0.00,3300.62,2251022.84,2508471.20,257448.36,730074),('1','146','257801','325',682.00,760.00,0.00,1211.96,826556.72,921089.60,94532.88,730075),('1','146','257802','325',682.00,760.00,0.00,3015.42,2056516.44,2291719.20,235202.76,730076),('1','146','257803','325',682.00,760.00,0.00,2068.25,1410546.50,1571870.00,161323.50,730077),('1','146','257804','325',682.00,760.00,0.00,0.00,0.00,0.00,0.00,730078),('1','146','257805','325',682.00,760.00,0.00,726.68,495595.76,552276.80,56681.04,730079),('1','146','257806','325',682.00,760.00,0.00,2924.38,1994427.16,2222528.80,228101.64,730080),('1','146','257807','325',682.00,760.00,0.00,2106.57,1436680.74,1600993.20,164312.46,730081),('1','146','257808','325',682.00,760.00,0.00,0.00,0.00,0.00,0.00,730082),('1','146','257809','325',682.00,760.00,0.00,0.00,0.00,0.00,0.00,730083),('1','146','257810','325',682.00,760.00,0.00,2970.42,2025826.44,2257519.20,231692.76,730084),('1','146','257811','325',682.00,760.00,0.00,2319.55,1581933.10,1762858.00,180924.90,730085),('1','146','257812','325',682.00,760.00,0.00,0.00,0.00,0.00,0.00,730086),('1','146','257813','325',682.00,760.00,0.00,288.67,196872.94,219389.20,22516.26,730087),('1','146','257814','325',682.00,760.00,0.00,2634.54,1796756.28,2002250.40,205494.12,730088),('1','146','257815','325',682.00,760.00,0.00,2650.32,1807518.24,2014243.20,206724.96,730089),('1','146','257816','325',682.00,760.00,0.00,0.00,0.00,0.00,0.00,730090),('1','146','257817','325',682.00,760.00,0.00,2930.13,1998348.66,2230738.80,232390.14,730091),('1','146','257818','325',682.00,760.00,0.00,2573.18,1754908.76,1955616.80,200708.04,730092),('1','146','257819','325',682.00,760.00,0.00,0.00,0.00,0.00,0.00,730093),('1','146','257820','325',682.00,760.00,0.00,2913.37,1986918.34,2214161.20,227242.86,730094),('1','146','257821','325',682.00,760.00,0.00,2279.62,1554700.84,1732511.20,177810.36,730095),('1','146','257822','325',682.00,760.00,0.00,0.00,0.00,0.00,0.00,730096),('1','146','257823','325',682.00,760.00,0.00,765.39,521995.98,581696.40,59700.42,730097),('1','146','257824','325',682.00,760.00,0.00,3501.91,2388302.62,2661451.60,273148.98,730098),('1','146','257825','325',682.00,760.00,0.00,506.05,345126.10,384598.00,39471.90,730099),('1','146','257826','325',682.00,760.00,0.00,0.00,0.00,0.00,0.00,730100),('1','146','257827','325',682.00,760.00,0.00,2557.28,1744064.96,1943532.80,199467.84,730101),('1','146','257828','325',682.00,760.00,0.00,2505.11,1708485.02,1903883.60,195398.58,730102),('1','146','257829','325',682.00,760.00,0.00,0.00,0.00,0.00,0.00,730103),('1','146','257830','325',682.00,760.00,0.00,549.89,375024.98,417916.40,42891.42,730104),('1','146','257831','325',682.00,760.00,0.00,3524.20,2403504.40,2678392.00,274887.60,730105),('1','146','257832','325',682.00,760.00,0.00,999.98,681986.36,759984.80,77998.44,730106),('1','146','257833','325',682.00,760.00,0.00,2002.63,1365793.66,1521998.80,156205.14,730107),('1','146','257834','325',682.00,760.00,0.00,3107.96,2119628.72,2362049.60,242420.88,730108),('1','146','257835','325',682.00,760.00,0.00,98.16,66945.12,74601.60,7656.48,730109),('1','146','257836','325',682.00,760.00,0.00,3118.41,2126755.62,2369991.60,243235.98,730110),('1','146','257837','325',682.00,760.00,0.00,2152.78,1468195.96,1636112.80,167916.84,730111),('1','146','257838','325',682.00,760.00,0.00,179.60,122487.20,136496.00,14008.80,730112),('1','146','257839','325',682.00,760.00,0.00,2976.24,2029795.68,2261942.40,232146.72,730113),('1','146','257840','325',682.00,760.00,0.00,2199.02,1499731.64,1671255.20,171523.56,730114),('1','146','257841','325',682.00,760.00,0.00,1111.45,758008.90,844702.00,86693.10,730115),('1','146','257842','325',682.00,760.00,0.00,2461.85,1678981.70,1871006.00,192024.30,730116),('1','146','257843','325',682.00,760.00,0.00,1703.09,1161507.38,1294348.40,132841.02,730117),('1','146','257844','325',682.00,760.00,0.00,243.13,165814.66,184778.80,18964.14,730118),('1','146','257845','325',682.00,760.00,0.00,2025.85,1381629.70,1539646.00,158016.30,730119),('1','146','257846','325',682.00,760.00,0.00,2113.37,1441318.34,1606161.20,164842.86,730120),('1','146','257847','325',682.00,760.00,0.00,900.66,614250.12,684501.60,70251.48,730121),('1','146','257848','325',682.00,760.00,0.00,1033.85,705085.70,785726.00,80640.30,730122),('1','146','257849','325',682.00,760.00,0.00,2776.77,1893757.14,2110345.20,216588.06,730123),('1','146','257850','325',682.00,760.00,0.00,1413.00,963666.00,1073880.00,110214.00,730124),('1','146','257851','325',682.00,760.00,0.00,0.00,0.00,0.00,0.00,730125),('1','146','257852','325',682.00,760.00,0.00,775.65,528993.30,589494.00,60500.70,730126),('1','146','257853','325',682.00,760.00,0.00,2859.48,1950165.36,2173204.80,223039.44,730127),('1','146','257854','325',682.00,760.00,0.00,1524.68,1039831.76,1158756.80,118925.04,730128),('1','146','257855','325',682.00,760.00,0.00,594.76,405626.32,452017.60,46391.28,730129),('1','146','257856','325',682.00,760.00,0.00,2975.35,2029188.70,2261266.00,232077.30,730130),('1','146','257857','325',682.00,760.00,0.00,942.73,642941.86,716474.80,73532.94,730131),('1','146','257858','325',682.00,760.00,0.00,1455.58,992705.56,1106240.80,113535.24,730132),('1','146','257859','325',682.00,760.00,0.00,2795.90,1906803.80,2124884.00,218080.20,730133),('1','146','257860','325',682.00,760.00,0.00,1040.52,709634.64,790795.20,81160.56,730134),('1','146','257861','325',682.00,760.00,0.00,0.00,0.00,0.00,0.00,730135),('1','146','257862','325',682.00,760.00,0.00,1528.44,1042396.08,1161614.40,119218.32,730136),('1','146','257863','325',682.00,760.00,0.00,2725.19,1858579.58,2071144.40,212564.82,730137),('1','146','257864','325',682.00,744.00,0.00,1169.75,797769.50,870294.00,72524.50,730138),('1','146','257865','325',682.00,744.00,0.00,0.00,0.00,0.00,0.00,730139),('1','146','257866','325',682.00,744.00,0.00,1455.55,992685.10,1082929.20,90244.10,730140),('1','146','257867','325',682.00,744.00,0.00,3283.84,2239578.88,2443176.96,203598.08,730141),('1','146','257868','325',682.00,744.00,0.00,878.36,599041.52,653499.84,54458.32,730142),('1','146','257869','325',682.00,744.00,0.00,1857.63,1266903.66,1382076.72,115173.06,730143),('1','146','257870','325',682.00,744.00,0.00,2899.47,1977438.54,2157205.68,179767.14,730144),('1','146','257871','325',682.00,744.00,0.00,390.45,266286.90,290494.80,24207.90,730145),('1','146','257872','325',682.00,744.00,0.00,2416.35,1647950.70,1797764.40,149813.70,730146),('1','146','257873','325',682.00,744.00,0.00,2582.51,1761271.82,1921387.44,160115.62,730147),('1','146','257874','325',682.00,744.00,0.00,432.12,294705.84,321497.28,26791.44,730148),('1','146','257875','325',682.00,744.00,0.00,1910.85,1303199.70,1421672.40,118472.70,730149),('1','146','257876','325',682.00,744.00,0.00,3053.73,2082643.86,2271975.12,189331.26,730150),('1','146','257877','325',682.00,744.00,0.00,489.52,333613.94,364202.88,30588.94,730151),('1','146','257878','325',675.00,744.00,0.00,1519.04,1025352.00,1130165.76,104813.76,730152),('1','146','257879','325',675.00,744.00,0.00,2961.79,1999208.25,2203571.76,204363.51,730153),('1','146','257880','325',675.00,744.00,0.00,175.87,118712.25,130847.28,12135.03,730154),('1','146','257881','325',675.00,744.00,0.00,2793.93,1885902.75,2078683.92,192781.17,730155),('1','146','257882','325',675.00,744.00,0.00,2709.18,1828696.50,2015629.92,186933.42,730156),('1','146','257883','325',675.00,744.00,0.00,3811.13,2572512.75,2835480.72,262967.97,730157),('1','146','257884','325',675.00,744.00,0.00,2331.10,1573492.50,1734338.40,160845.90,730158),('1','146','257885','325',675.00,744.00,0.00,1067.67,720677.25,794346.48,73669.23,730159),('1','146','257886','325',675.00,744.00,0.00,4395.59,2967023.25,3270318.96,303295.71,730160),('1','146','257887','325',675.00,744.00,0.00,287.16,193833.00,213647.04,19814.04,730161),('1','146','257888','325',675.00,744.00,0.00,2830.33,1910472.75,2105765.52,195292.77,730162),('1','146','257889','325',675.00,760.00,0.00,1611.99,1088093.25,1225112.40,137019.15,730163),('1','146','257890','325',675.00,760.00,0.00,2091.93,1412052.75,1589866.80,177814.05,730164),('1','146','257891','325',675.00,760.00,0.00,3617.38,2441731.50,2749208.80,307477.30,730165),('1','146','257892','325',675.00,760.00,0.00,317.23,214130.25,241094.80,26964.55,730166),('1','146','257893','325',675.00,760.00,0.00,2500.82,1688053.50,1900623.20,212569.70,730167),('1','146','257894','325',675.00,760.00,0.00,2404.52,1623051.00,1827435.20,204384.20,730168),('1','146','257895','325',675.00,760.00,0.00,0.00,0.00,0.00,0.00,730169),('1','146','257896','325',675.00,760.00,0.00,266.64,179982.00,202646.40,22664.40,730170),('1','146','257897','325',675.00,760.00,0.00,2612.66,1763545.50,1985621.60,222076.10,730171),('1','146','257898','325',675.00,760.00,0.00,2413.70,1629247.50,1834412.00,205164.50,730172),('1','146','257899','325',675.00,760.00,0.00,3063.14,2067619.50,2327986.40,260366.90,730173),('1','146','257900','325',675.00,760.00,0.00,2770.11,1869824.25,2105283.60,235459.35,730174),('1','146','257901','325',675.00,744.00,0.00,3415.16,2305233.00,2540879.04,235646.04,730175),('1','146','257902','325',675.00,744.00,0.00,1964.84,1326267.00,1461840.96,135573.96,730176),('1','146','257903','325',675.00,744.00,0.00,357.80,241515.00,266203.20,24688.20,730177),('1','146','257904','325',675.00,744.00,0.00,3826.24,2582712.00,2846722.56,264010.56,730178),('1','146','257905','325',675.00,744.00,0.00,1375.47,928442.25,1023349.68,94907.43,730179),('1','146','257906','325',675.00,744.00,0.00,1302.02,878863.50,968702.88,89839.38,730180),('1','146','257907','325',675.00,744.00,0.00,3086.80,2083590.00,2296579.20,212989.20,730181),('1','146','257908','325',675.00,744.00,0.00,847.55,572096.25,630577.20,58480.95,730182),('1','146','257909','325',675.00,744.00,0.00,1623.92,1096146.00,1208196.48,112050.48,730183),('1','146','257910','325',675.00,744.00,0.00,2458.69,1659615.75,1829265.36,169649.61,730184),('1','146','257911','325',675.00,744.00,0.00,1053.69,711240.75,783945.36,72704.61,730185),('1','146','257912','325',675.00,744.00,0.00,0.00,0.00,0.00,0.00,730186),('1','146','257913','325',675.00,744.00,0.00,1877.05,1267008.75,1396525.20,129516.45,730187),('1','146','257914','325',675.00,744.00,0.00,2956.12,1995381.00,2199353.28,203972.28,730188),('1','146','257915','325',675.00,744.00,0.00,247.78,167251.50,184348.32,17096.82,730189),('1','146','257916','325',675.00,744.00,0.00,0.00,0.00,0.00,0.00,730190),('1','146','257917','325',675.00,744.00,0.00,2596.36,1752543.00,1931691.84,179148.84,730191),('1','146','257918','325',675.00,744.00,0.00,2701.27,1823357.25,2009744.88,186387.63,730192),('1','146','257919','325',675.00,744.00,0.00,0.00,0.00,0.00,0.00,730193),('1','146','257920','325',675.00,744.00,0.00,3012.39,2033363.25,2241218.16,207854.91,730194),('1','146','257921','325',675.00,744.00,0.00,1510.39,1019513.25,1123730.16,104216.91,730195),('1','146','257922','325',675.00,744.00,0.00,0.00,0.00,0.00,0.00,730196),('1','146','257923','325',675.00,744.00,0.00,657.67,443927.25,489306.48,45379.23,730197),('1','146','257924','325',675.00,744.00,0.00,3617.29,2441670.75,2691263.76,249593.01,730198),('1','146','257925','325',675.00,744.00,0.00,784.76,529713.00,583861.44,54148.44,730199),('1','146','257926','325',675.00,744.00,0.00,1634.09,1103010.75,1215762.96,112752.21,730200),('1','146','257927','325',675.00,744.00,0.00,2953.06,1993315.50,2197076.64,203761.14,730201),('1','146','257928','325',675.00,744.00,0.00,524.46,354010.50,390198.24,36187.74,730202),('1','146','257929','325',675.00,744.00,0.00,3173.74,2142274.50,2361262.56,218988.06,730203),('1','146','257930','325',675.00,744.00,0.00,2621.50,1769512.50,1950396.00,180883.50,730204),('1','146','257931','325',675.00,744.00,0.00,4017.76,2711988.00,2989213.44,277225.44,730205),('1','146','257932','325',675.00,744.00,0.00,1602.24,1081512.00,1192066.56,110554.56,730206),('1','146','257933','325',675.00,744.00,0.00,940.75,635006.25,699918.00,64911.75,730207),('1','146','257934','325',675.00,744.00,0.00,2914.61,1967361.75,2168469.84,201108.09,730208),('1','146','257935','325',675.00,744.00,0.00,1415.92,955746.00,1053444.48,97698.48,730209),('1','146','257936','325',675.00,744.00,0.00,1204.23,812855.25,895947.12,83091.87,730210),('1','146','257937','325',675.00,744.00,0.00,3391.90,2289532.50,2523573.60,234041.10,730211),('1','146','257938','325',675.00,744.00,0.00,313.72,211761.00,233407.68,21646.68,730212),('1','146','257939','325',675.00,744.00,0.00,0.00,0.00,0.00,0.00,730213),('1','146','257940','325',675.00,744.00,0.00,2203.17,1487139.75,1639158.48,152018.73,730214),('1','146','257941','325',675.00,744.00,0.00,3187.40,2151495.00,2371425.60,219930.60,730215),('1','146','257942','325',675.00,744.00,0.00,118.14,79744.50,87896.16,8151.66,730216),('1','146','257943','325',675.00,744.00,0.00,3023.21,2040666.75,2249268.24,208601.49,730217),('1','146','257944','325',675.00,744.00,0.00,1557.08,1051029.00,1158467.52,107438.52,730218),('1','146','257945','325',675.00,744.00,0.00,0.00,0.00,0.00,0.00,730219),('1','146','257946','325',675.00,744.00,0.00,2767.90,1868332.50,2059317.60,190985.10,730220),('1','146','257947','325',675.00,744.00,0.00,2438.73,1646142.75,1814415.12,168272.37,730221),('1','146','257948','325',675.00,744.00,0.00,0.00,0.00,0.00,0.00,730222),('1','146','257949','325',675.00,744.00,0.00,720.91,486614.25,536357.04,49742.79,730223),('1','146','257950','325',675.00,744.00,0.00,1992.65,1345038.75,1482531.60,137492.85,730224),('1','146','257951','325',675.00,744.00,0.00,453.59,306173.25,337470.96,31297.71,730225),('1','146','257952','325',675.00,744.00,0.00,3203.64,2162457.00,2383508.16,221051.16,730226),('1','146','257953','325',675.00,744.00,0.00,1413.64,954207.00,1051748.16,97541.16,730227),('1','146','257954','325',675.00,736.00,0.00,2699.19,1821953.25,1986603.84,164650.59,730228),('1','146','257955','325',675.00,736.00,0.00,2747.91,1854839.25,2022461.76,167622.51,730229),('1','146','257956','325',675.00,736.00,0.00,195.06,131665.50,143564.16,11898.66,730230),('1','146','257957','325',675.00,736.00,0.00,792.12,534681.00,583000.32,48319.32,730231),('1','146','257958','325',675.00,736.00,0.00,0.00,0.00,0.00,0.00,730232),('1','146','257959','325',675.00,736.00,0.00,1805.35,1218611.25,1328737.60,110126.35,730233),('1','146','257960','325',675.00,736.00,0.00,3445.78,2325695.85,2536094.08,210398.23,730234),('1','146','257961','325',670.00,736.00,0.00,3044.17,2039593.90,2240509.12,200915.22,730235),('1','146','257962','325',670.00,736.00,0.00,2169.36,1453471.20,1596648.96,143177.76,730236),('1','146','257963','325',670.00,736.00,0.00,3237.54,2169151.80,2382829.44,213677.64,730237),('1','146','257964','325',670.00,736.00,0.00,2122.95,1422376.50,1562491.20,140114.70,730238),('1','146','257965','325',670.00,736.00,0.00,2747.71,1840965.70,2022314.56,181348.86,730239),('1','146','257966','325',670.00,736.00,0.00,2494.38,1671234.60,1835863.68,164629.08,730240),('1','146','257967','325',670.00,736.00,0.00,3212.66,2152482.20,2364517.76,212035.56,730241),('1','146','257968','325',670.00,736.00,0.00,1946.43,1304108.10,1432572.48,128464.38,730242),('1','146','257969','325',670.00,736.00,0.00,857.98,574846.60,631473.28,56626.68,730243),('1','146','257970','325',670.00,736.00,0.00,2962.71,1985015.70,2180554.56,195538.86,730244),('1','146','257971','325',670.00,736.00,0.00,1322.71,886215.70,973514.56,87298.86,730245),('1','146','257972','325',670.00,736.00,0.00,1873.51,1255251.70,1378903.36,123651.66,730246),('1','146','257973','325',670.00,736.00,0.00,3186.51,2134961.70,2345271.36,210309.66,730247),('1','146','257974','325',670.00,736.00,0.00,0.00,0.00,0.00,0.00,730248),('1','146','257975','325',670.00,736.00,0.00,3265.40,2187818.00,2403334.40,215516.40,730249),('1','146','257976','325',670.00,736.00,0.00,2201.17,1474783.90,1620061.12,145277.22,730250),('1','146','257977','325',670.00,736.00,0.00,3779.60,2532332.00,2781785.60,249453.60,730251),('1','146','257978','325',670.00,736.00,0.00,1155.67,774298.90,850573.12,76274.22,730252),('1','146','257979','325',670.00,736.00,0.00,2281.33,1528491.10,1679058.88,150567.78,730253),('1','146','257980','325',670.00,736.00,0.00,2918.32,1955274.40,2147883.52,192609.12,730254),('1','146','257981','325',670.00,764.00,0.00,245.38,164404.60,187470.32,23065.72,730255),('1','146','257982','325',670.00,764.00,0.00,3162.83,2119096.10,2416402.12,297306.02,730256),('1','146','257983','325',670.00,764.00,0.00,179.45,120231.50,137099.80,16868.30,730257),('1','146','257984','325',670.00,764.00,0.00,2165.41,1450824.70,1654373.24,203548.54,730258),('1','146','257985','325',670.00,764.00,0.00,953.34,638737.80,728351.76,89613.96,730259),('1','146','257986','325',670.00,764.00,0.00,919.46,616038.20,702467.44,86429.24,730260),('1','146','257987','325',670.00,748.00,0.00,2768.53,1854915.10,2070860.44,215945.34,730261),('1','146','257988','325',670.00,748.00,0.00,2563.23,1717364.10,1917296.04,199931.94,730262),('1','146','257989','325',670.00,748.00,0.00,2939.78,1969652.60,2198955.44,229302.84,730263),('1','146','257990','325',670.00,748.00,0.00,2341.08,1568523.60,1751127.84,182604.24,730264),('1','146','257991','325',670.00,748.00,0.00,2996.85,2007889.50,2241643.80,233754.30,730265),('1','146','257992','325',670.00,748.00,0.00,1480.75,992102.50,1107601.00,115498.50,730266),('1','146','257993','325',670.00,748.00,0.00,599.36,401571.20,448321.28,46750.08,730267),('1','146','257994','325',670.00,748.00,0.00,3454.37,2314427.90,2583868.76,269440.86,730268),('1','146','257995','325',670.00,748.00,0.00,579.17,388043.90,433219.16,45175.26,730269),('1','146','257996','325',670.00,748.00,0.00,366.25,247218.75,278350.00,31131.25,730270),('1','146','257997','325',675.00,760.00,0.00,1570.88,1060344.00,1193868.80,133524.80,730271),('1','146','257998','325',675.00,760.00,0.00,3058.88,2064744.00,2324748.80,260004.80,730272),('1','146','257999','325',675.00,760.00,0.00,1525.42,1029658.50,1159319.20,129660.70,730273),('1','146','258000','325',675.00,760.00,0.00,0.00,0.00,0.00,0.00,730274),('1','146','258001','325',675.00,760.00,0.00,525.21,354516.75,399159.60,44642.85,730275),('1','146','258002','325',675.00,760.00,0.00,4293.94,2898409.50,3263394.40,364984.90,730276),('1','146','258003','325',675.00,760.00,0.00,479.72,323811.00,364587.20,40776.20,730277),('1','146','258004','325',675.00,760.00,0.00,2175.00,1468125.00,1653000.00,184875.00,730278),('1','146','258005','325',675.00,760.00,0.00,2716.71,1833779.25,2064699.60,230920.35,730279),('1','146','258006','325',675.00,760.00,0.00,0.00,0.00,0.00,0.00,730280),('1','146','258007','325',675.00,760.00,0.00,546.59,368948.25,415408.40,46460.15,730281),('1','146','258008','325',675.00,760.00,0.00,3358.27,2266832.25,2552285.20,285452.95,730282),('1','146','258009','325',675.00,800.00,0.00,1776.36,1199043.00,1421088.00,222045.00,730283),('1','146','258010','325',675.00,800.00,0.00,685.46,462685.50,548368.00,85682.50,730284),('1','146','258011','325',675.00,800.00,0.00,2748.28,1855089.00,2198624.00,343535.00,730285),('1','146','258012','325',675.00,800.00,0.00,1249.32,843291.00,999456.00,156165.00,730286),('1','146','258013','325',675.00,800.00,0.00,0.00,0.00,0.00,0.00,730287),('1','146','258014','325',675.00,800.00,0.00,887.91,599339.25,710328.00,110988.75,730288),('1','146','258015','325',675.00,800.00,0.00,538.56,363528.00,430848.00,67320.00,730289),('1','146','258016','325',675.00,760.00,0.00,1946.34,1313779.50,1479218.40,165438.90,730290),('1','146','258017','325',675.00,760.00,0.00,1816.24,1225962.00,1380342.40,154380.40,730291),('1','146','258018','325',675.00,760.00,0.00,0.00,0.00,0.00,0.00,730292),('1','146','258019','325',675.00,760.00,0.00,603.40,407295.00,458584.00,51289.00,730293),('1','146','258020','325',675.00,760.00,0.00,2836.88,1914894.00,2156028.80,241134.80,730294),('1','146','258021','325',675.00,760.00,0.00,691.93,467052.75,525866.80,58814.05,730295),('1','146','258022','325',675.00,760.00,0.00,378.42,255433.50,287599.20,32165.70,730296),('1','146','258023','325',675.00,760.00,0.00,2655.85,1792698.75,2018446.00,225747.25,730297),('1','146','258024','325',675.00,760.00,0.00,607.90,410332.50,462004.00,51671.50,730298),('1','146','258025','325',675.00,760.00,0.00,0.00,0.00,0.00,0.00,730299),('1','146','258026','325',675.00,760.00,0.00,1530.03,1032770.25,1162822.80,130052.55,730300),('1','146','258027','325',675.00,760.00,0.00,2730.62,1843168.50,2075271.20,232102.70,730301),('1','146','258028','325',675.00,760.00,0.00,1088.99,735068.25,827632.40,92564.15,730302),('1','146','258029','325',675.00,760.00,0.00,0.00,0.00,0.00,0.00,730303),('1','146','258030','325',675.00,760.00,0.00,695.00,469125.00,528200.00,59075.00,730304),('1','146','258031','325',675.00,760.00,0.00,2181.31,1472384.25,1657795.60,185411.35,730305),('1','146','258032','325',675.00,760.00,0.00,1764.11,1190774.25,1340723.60,149949.35,730306),('1','146','258033','325',685.00,760.00,0.00,689.02,471978.70,523655.20,51676.50,730307),('1','146','258034','325',685.00,760.00,0.00,2594.94,1777533.90,1972154.40,194620.50,730308),('1','146','258035','325',685.00,760.00,0.00,1685.16,1154334.60,1280721.60,126387.00,730309),('1','146','258036','325',685.00,760.00,0.00,593.43,406499.55,451006.80,44507.25,730310),('1','146','258037','325',685.00,760.00,0.00,2609.81,1787719.85,1983455.60,195735.75,730311),('1','146','258038','325',685.00,760.00,0.00,1536.00,1052160.00,1167360.00,115200.00,730312),('1','146','258039','325',685.00,760.00,0.00,0.00,0.00,0.00,0.00,730313),('1','146','258040','325',685.00,760.00,0.00,643.29,440653.65,488900.40,48246.75,730314),('1','146','258041','325',685.00,760.00,0.00,2727.51,1868344.35,2072907.60,204563.25,730315),('1','146','258042','325',685.00,760.00,0.00,1707.17,1169411.45,1297449.20,128037.75,730316),('1','146','258043','325',685.00,760.00,0.00,0.00,0.00,0.00,0.00,730317),('1','146','258044','325',685.00,760.00,0.00,141.66,97037.10,107661.60,10624.50,730318),('1','146','258045','325',685.00,760.00,0.00,2707.00,1854295.00,2057320.00,203025.00,730319),('1','146','258046','325',685.00,760.00,0.00,2216.15,1518062.75,1684274.00,166211.25,730320),('1','146','258047','325',685.00,760.00,0.00,0.00,0.00,0.00,0.00,730321),('1','146','258048','325',685.00,760.00,0.00,370.78,253984.30,281792.80,27808.50,730322),('1','146','258049','325',685.00,760.00,0.00,2858.72,1958223.20,2172627.20,214404.00,730323),('1','146','258050','325',685.00,760.00,0.00,2648.22,1814030.70,2021387.20,207356.50,730324),('1','146','258051','325',685.00,760.00,0.00,308.00,210980.00,234080.00,23100.00,730325),('1','146','258052','325',685.00,760.00,0.00,0.00,0.00,0.00,0.00,730326),('1','146','258053','325',685.00,760.00,0.00,688.61,471697.85,523343.60,51645.75,730327),('1','146','258054','325',685.00,760.00,0.00,2257.16,1546154.60,1715441.60,169287.00,730328),('1','146','258055','325',685.00,760.00,0.00,2113.33,1447631.05,1606130.80,158499.75,730329),('1','146','258056','325',685.00,760.00,0.00,0.00,0.00,0.00,0.00,730330),('1','146','258057','325',685.00,760.00,0.00,2718.73,1862330.05,2066234.80,203904.75,730331),('1','146','258058','325',685.00,760.00,0.00,2231.27,1528419.95,1695765.20,167345.25,730332),('1','146','258059','325',685.00,760.00,0.00,2685.91,1839848.35,2041291.60,201443.25,730333),('1','146','258060','325',685.00,760.00,0.00,2275.21,1558518.85,1729159.60,170640.75,730334),('1','146','258061','325',685.00,760.00,0.00,0.00,0.00,0.00,0.00,730335),('1','146','258062','325',685.00,760.00,0.00,2724.03,1865960.55,2070262.80,204302.25,730336),('1','146','258063','325',685.00,760.00,0.00,2149.27,1472249.95,1633445.20,161195.25,730337),('1','146','258064','325',685.00,760.00,0.00,363.00,248655.00,275880.00,27225.00,730338),('1','146','258065','325',685.00,760.00,0.00,0.00,0.00,0.00,0.00,730339),('1','146','258066','325',685.00,760.00,0.00,1479.37,1013368.45,1124321.20,110952.75,730340),('1','146','258067','325',670.00,760.00,0.00,2546.30,1706021.00,1935188.00,229167.00,730341),('1','146','258068','325',670.00,760.00,0.00,933.70,625579.00,709612.00,84033.00,730342),('1','146','258069','325',670.00,760.00,0.00,0.00,0.00,0.00,0.00,730343),('1','146','258070','325',670.00,760.00,0.00,1086.89,728216.30,826036.40,97820.10,730344),('1','146','258071','325',670.00,760.00,0.00,2512.75,1683542.50,1909690.00,226147.50,730345),('1','146','258072','325',670.00,760.00,0.00,1346.99,902483.30,1023712.40,121229.10,730346),('1','146','258073','325',670.00,760.00,0.00,0.00,0.00,0.00,0.00,730347),('1','146','258074','325',670.00,760.00,0.00,1307.92,876306.40,994019.20,117712.80,730348),('1','146','258075','325',670.00,760.00,0.00,2500.85,1675569.50,1900646.00,225076.50,730349),('1','146','258076','325',670.00,760.00,0.00,1138.20,762594.00,865032.00,102438.00,730350),('1','146','258077','325',670.00,760.00,0.00,0.00,0.00,0.00,0.00,730351),('1','146','258078','325',670.00,760.00,0.00,1220.66,817842.20,927701.60,109859.40,730352),('1','146','258079','325',670.00,760.00,0.00,2232.05,1495473.50,1696358.00,200884.50,730353),('1','146','258080','325',670.00,760.00,0.00,1651.31,1106377.70,1254995.60,148617.90,730354),('1','146','258081','325',670.00,760.00,0.00,0.00,0.00,0.00,0.00,730355),('1','146','258082','325',670.00,760.00,0.00,771.17,516683.90,586089.20,69405.30,730356),('1','146','258083','325',670.00,760.00,0.00,2598.24,1740820.80,1974662.40,233841.60,730357),('1','146','258084','325',670.00,760.00,0.00,366.70,245689.00,278692.00,33003.00,730358),('1','146','258085','325',670.00,736.00,0.00,1617.48,1083711.60,1190465.28,106753.68,730359),('1','146','258086','325',670.00,736.00,0.00,77.66,52032.20,57157.76,5125.56,730360),('1','146','258087','325',670.00,736.00,0.00,0.00,0.00,0.00,0.00,730361),('1','146','258088','325',670.00,736.00,0.00,1885.60,1263352.00,1387801.60,124449.60,730362),('1','146','258089','325',670.00,736.00,0.00,3195.31,2140857.70,2351748.16,210890.46,730363),('1','146','258090','325',670.00,736.00,0.00,98.44,65954.80,72451.84,6497.04,730364),('1','146','258091','325',670.00,736.00,0.00,0.00,0.00,0.00,0.00,730365),('1','146','258092','325',670.00,736.00,0.00,2704.76,1812189.20,1990703.36,178514.16,730366),('1','146','258093','325',670.00,736.00,0.00,2237.70,1499259.00,1646947.20,147688.20,730367),('1','146','258094','325',670.00,736.00,0.00,0.00,0.00,0.00,0.00,730368),('1','146','258095','325',664.00,736.00,0.00,2648.69,1758730.16,1949435.84,190705.68,730369),('1','146','258096','325',664.00,736.00,0.00,2376.73,1578148.72,1749273.28,171124.56,730370),('1','146','258097','325',664.00,736.00,0.00,387.62,257379.68,285288.32,27908.64,730371),('1','146','258098','325',664.00,736.00,0.00,2125.44,1411292.16,1564323.84,153031.68,730372),('1','146','258099','325',664.00,736.00,0.00,1401.81,930801.84,1031732.16,100930.32,730373),('1','146','258100','325',664.00,736.00,0.00,1690.28,1122345.92,1244046.08,121700.16,730374),('1','146','258101','325',664.00,736.00,0.00,751.79,499188.56,553317.44,54128.88,730375),('1','146','258102','325',664.00,736.00,0.00,2866.36,1903263.04,2109640.96,206377.92,730376),('1','146','258103','325',664.00,736.00,0.00,1543.53,1024903.92,1136038.08,111134.16,730377),('1','146','258104','325',664.00,736.00,0.00,891.16,591730.24,655893.76,64163.52,730378),('1','146','258105','325',664.00,736.00,0.00,3266.09,2168683.76,2403842.24,235158.48,730379),('1','146','258106','325',664.00,736.00,0.00,822.98,546458.72,605713.28,59254.56,730380),('1','146','258107','325',664.00,736.00,0.00,172.63,114626.32,127055.68,12429.36,730381),('1','146','258108','325',664.00,736.00,0.00,1858.32,1233924.48,1367723.52,133799.04,730382),('1','146','258109','325',664.00,736.00,0.00,3328.20,2209924.80,2449555.20,239630.40,730383),('1','146','258110','325',664.00,736.00,0.00,302.59,200919.76,222706.24,21786.48,730384),('1','146','258111','325',664.00,736.00,0.00,2752.23,1827480.72,2025641.28,198160.56,730385),('1','146','258112','325',664.00,736.00,0.00,2265.62,1504371.68,1667496.32,163124.64,730386),('1','146','258113','325',664.00,736.00,0.00,208.12,138191.68,153176.32,14984.64,730387),('1','146','258114','325',664.00,736.00,0.00,1961.89,1302694.96,1443951.04,141256.08,730388),('1','146','258115','325',664.00,736.00,0.00,2102.20,1395860.80,1547219.20,151358.40,730389),('1','146','258116','325',664.00,736.00,0.00,1653.70,1098056.80,1217123.20,119066.40,730390),('1','146','258117','325',664.00,736.00,0.00,230.08,152773.12,169338.88,16565.76,730391),('1','146','258118','325',664.00,736.00,0.00,2280.19,1514046.16,1678219.84,164173.68,730392),('1','146','258119','325',664.00,736.00,0.00,2314.21,1536635.44,1703258.56,166623.12,730393),('1','146','258120','325',664.00,736.00,0.00,601.20,399196.80,442483.20,43286.40,730394),('1','146','258121','325',664.00,736.00,0.00,1379.48,915974.72,1015297.28,99322.56,730395),('1','146','258122','325',664.00,736.00,0.00,1538.69,1021690.16,1132475.84,110785.68,730396),('1','146','258123','325',664.00,736.00,0.00,1874.94,1244960.16,1379955.84,134995.68,730397),('1','146','258124','325',664.00,736.00,0.00,687.11,456241.04,505712.96,49471.92,730398),('1','146','258125','325',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730399),('1','146','258126','325',664.00,736.00,0.00,1771.02,1175957.28,1303470.72,127513.44,730400),('1','146','258127','325',664.00,736.00,0.00,2556.17,1697296.88,1881341.12,184044.24,730401),('1','146','258128','325',664.00,736.00,0.00,922.81,612745.84,679188.16,66442.32,730402),('1','146','258129','325',664.00,736.00,0.00,1647.13,1093694.32,1212287.68,118593.36,730403),('1','146','258130','325',664.00,736.00,0.00,2075.02,1377813.28,1527214.72,149401.44,730404),('1','146','258131','325',664.00,736.00,0.00,1544.84,1025773.76,1137002.24,111228.48,730405),('1','146','258132','325',664.00,736.00,0.00,1018.45,676250.80,749579.20,73328.40,730406),('1','146','258133','325',664.00,736.00,0.00,2468.60,1639150.40,1816889.60,177739.20,730407),('1','146','258134','325',664.00,736.00,0.00,1946.17,1292256.88,1432381.12,140124.24,730408),('1','146','258135','325',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730409),('1','146','258136','325',664.00,736.00,0.00,2657.53,1764599.92,1955942.08,191342.16,730410),('1','146','258137','325',664.00,736.00,0.00,2651.81,1760801.84,1951732.16,190930.32,730411),('1','146','258138','325',664.00,736.00,0.00,2989.44,1984988.16,2200227.84,215239.68,730412),('1','146','258139','325',664.00,736.00,0.00,2149.08,1426989.12,1581722.88,154733.76,730413),('1','146','258140','325',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730414),('1','146','258141','325',664.00,736.00,0.00,2824.06,1875175.84,2078508.16,203332.32,730415),('1','146','258142','325',664.00,736.00,0.00,2155.94,1431544.16,1586771.84,155227.68,730416),('1','146','258143','325',664.00,736.00,0.00,2484.83,1649927.12,1828834.88,178907.76,730417),('1','146','258144','325',664.00,736.00,0.00,2830.52,1879465.28,2083262.72,203797.44,730418),('1','146','258145','325',664.00,736.00,0.00,266.09,176683.76,195842.24,19158.48,730419),('1','146','258146','325',664.00,736.00,0.00,1958.84,1300669.76,1441706.24,141036.48,730420),('1','146','258147','325',664.00,736.00,0.00,2407.59,1598639.76,1771986.24,173346.48,730421),('1','146','258148','325',664.00,736.00,0.00,1181.49,784509.36,869576.64,85067.28,730422),('1','146','258149','325',664.00,736.00,0.00,107.88,71632.32,79399.68,7767.36,730423),('1','146','258150','325',664.00,736.00,0.00,2479.19,1601097.92,1824683.84,223585.92,730424),('1','146','258151','325',640.00,736.00,0.00,2508.22,1605260.80,1846049.92,240789.12,730425),('1','146','258152','325',640.00,736.00,0.00,178.93,114515.20,131692.48,17177.28,730426),('1','146','258153','325',640.00,736.00,0.00,1758.90,1125696.00,1294550.40,168854.40,730427),('1','146','258154','325',640.00,736.00,0.00,2791.48,1786547.20,2054529.28,267982.08,730428),('1','146','258155','325',640.00,736.00,0.00,570.71,365254.40,420042.56,54788.16,730429),('1','146','258156','325',640.00,736.00,0.00,2079.45,1330848.00,1530475.20,199627.20,730430),('1','146','258157','325',640.00,736.00,0.00,2271.86,1453990.40,1672088.96,218098.56,730431),('1','146','258158','325',640.00,736.00,0.00,734.28,469939.20,540430.08,70490.88,730432),('1','146','258159','325',640.00,736.00,0.00,1034.13,661843.20,761119.68,99276.48,730433),('1','146','258160','325',640.00,736.00,0.00,2335.11,1494470.40,1718640.96,224170.56,730434),('1','146','258161','325',640.00,736.00,0.00,1710.76,1094886.40,1259119.36,164232.96,730435),('1','146','258162','325',640.00,736.00,0.00,1130.47,723500.80,832025.92,108525.12,730436),('1','146','258163','325',640.00,736.00,0.00,1684.26,1077926.40,1239615.36,161688.96,730437),('1','146','258164','325',640.00,736.00,0.00,1956.82,1252364.80,1440219.52,187854.72,730438),('1','146','258165','325',640.00,736.00,0.00,2394.08,1532211.20,1762042.88,229831.68,730439),('1','146','258166','325',640.00,736.00,0.00,2652.00,1697280.00,1951872.00,254592.00,730440),('1','146','258167','325',640.00,736.00,0.00,1996.57,1277804.80,1469475.52,191670.72,730441),('1','146','258168','325',640.00,736.00,0.00,3234.12,2069836.80,2380312.32,310475.52,730442),('1','146','258169','325',640.00,736.00,0.00,3928.51,2514246.40,2891383.36,377136.96,730443),('1','146','258170','325',640.00,736.00,0.00,1341.64,858649.60,987447.04,128797.44,730444),('1','146','258171','325',640.00,736.00,0.00,482.16,308582.40,354869.76,46287.36,730445),('1','146','258172','325',640.00,736.00,0.00,3117.15,1994976.00,2294222.40,299246.40,730446),('1','146','258173','325',640.00,736.00,0.00,1602.48,1025587.20,1179425.28,153838.08,730447),('1','146','258174','325',640.00,736.00,0.00,540.49,345913.60,397800.64,51887.04,730448),('1','146','258175','325',640.00,736.00,0.00,3066.83,1962771.20,2257186.88,294415.68,730449),('1','146','258176','325',640.00,736.00,0.00,1713.54,1096665.60,1261165.44,164499.84,730450),('1','146','258177','325',640.00,736.00,0.00,539.95,345568.00,397403.20,51835.20,730451),('1','146','258178','325',640.00,736.00,0.00,2698.36,1726950.40,1985992.96,259042.56,730452),('1','146','258179','325',640.00,736.00,0.00,1819.34,1164377.60,1339034.24,174656.64,730453),('1','146','258180','325',640.00,736.00,0.00,885.01,566406.40,651367.36,84960.96,730454),('1','146','258181','325',640.00,736.00,0.00,2893.37,1851756.80,2129520.32,277763.52,730455),('1','146','258182','325',640.00,736.00,0.00,1367.71,875334.40,1006634.56,131300.16,730456),('1','146','258183','325',640.00,736.00,0.00,1027.32,657484.80,756107.52,98622.72,730457),('1','146','258184','325',640.00,736.00,0.00,2284.64,1462169.60,1681495.04,219325.44,730458),('1','146','258185','325',640.00,736.00,0.00,2005.44,1283481.60,1476003.84,192522.24,730459),('1','146','258186','325',640.00,736.00,0.00,0.00,0.00,0.00,0.00,730460),('1','146','258187','325',640.00,736.00,0.00,80.09,51257.60,58946.24,7688.64,730461),('1','146','258188','325',640.00,736.00,0.00,2905.95,1859808.00,2138779.20,278971.20,730462),('1','146','258189','325',640.00,736.00,0.00,2296.17,1469548.80,1689981.12,220432.32,730463),('1','146','258190','325',640.00,736.00,0.00,0.00,0.00,0.00,0.00,730464),('1','146','258191','325',640.00,736.00,0.00,731.81,468358.40,538612.16,70253.76,730465),('1','146','258192','325',640.00,736.00,0.00,3497.74,2238553.60,2574336.64,335783.04,730466),('1','146','258193','325',640.00,736.00,0.00,936.72,599500.80,689425.92,89925.12,730467),('1','146','258194','325',640.00,736.00,0.00,1657.27,1060652.80,1219750.72,159097.92,730468),('1','146','258195','325',640.00,736.00,0.00,3395.05,2172832.00,2498756.80,325924.80,730469),('1','146','258196','325',640.00,736.00,0.00,3463.16,2216422.40,2548885.76,332463.36,730470),('1','146','258197','325',640.00,736.00,0.00,1867.76,1195366.40,1374671.36,179304.96,730471),('1','146','258198','325',640.00,736.00,0.00,1291.92,826828.80,950853.12,124024.32,730472),('1','146','258199','325',640.00,736.00,0.00,3799.78,2431859.20,2796638.08,364778.88,730473),('1','146','258200','325',640.00,736.00,0.00,0.00,0.00,0.00,0.00,730474),('1','146','258201','325',640.00,736.00,0.00,0.00,0.00,0.00,0.00,730475),('1','146','258202','325',640.00,736.00,0.00,3380.39,2163449.60,2487967.04,324517.44,730476),('1','146','258203','325',640.00,736.00,0.00,1739.23,1113107.20,1280073.28,166966.08,730477),('1','146','258204','325',640.00,736.00,0.00,598.36,382950.40,440392.96,57442.56,730478),('1','146','258205','325',640.00,736.00,0.00,2215.20,1417728.00,1630387.20,212659.20,730479),('1','146','258206','325',640.00,736.00,0.00,2657.36,1700710.40,1955816.96,255106.56,730480),('1','146','258207','325',640.00,736.00,0.00,3444.88,2204723.20,2535431.68,330708.48,730481),('1','146','258208','325',640.00,736.00,0.00,1784.68,1142195.20,1313524.48,171329.28,730482),('1','146','258209','325',640.00,736.00,0.00,261.12,167116.80,192184.32,25067.52,730483),('1','146','258210','325',640.00,736.00,0.00,3135.27,2006572.80,2307558.72,300985.92,730484),('1','146','258211','325',640.00,736.00,0.00,1944.31,1244358.40,1431012.16,186653.76,730485),('1','146','258212','325',640.00,736.00,0.00,543.07,347564.80,399699.52,52134.72,730486),('1','146','258213','325',640.00,736.00,0.00,2215.39,1417849.60,1630527.04,212677.44,730487),('1','146','258214','325',640.00,736.00,0.00,2321.22,1485580.80,1708417.92,222837.12,730488),('1','146','258215','325',640.00,736.00,0.00,926.41,592902.40,681837.76,88935.36,730489),('1','146','258216','325',640.00,736.00,0.00,1798.20,1150450.80,1258740.00,108289.20,730490),('1','146','258217','325',634.00,700.00,0.00,2401.47,1522531.98,1681029.00,158497.02,730491),('1','146','258218','325',634.00,700.00,0.00,2338.68,1482723.12,1637076.00,154352.88,730492),('1','146','258219','325',634.00,700.00,0.00,3059.16,1939507.44,2141412.00,201904.56,730493),('1','146','258220','325',634.00,700.00,0.00,2788.96,1768200.64,1952272.00,184071.36,730494),('1','146','258221','325',634.00,700.00,0.00,2333.03,1479141.02,1633121.00,153979.98,730495),('1','146','258222','325',634.00,700.00,0.00,3072.76,1948129.84,2150932.00,202802.16,730496),('1','146','258223','325',634.00,700.00,0.00,2149.45,1362751.30,1504615.00,141863.70,730497),('1','146','258224','325',634.00,700.00,0.00,224.09,142073.06,156863.00,14789.94,730498),('1','146','258225','325',634.00,700.00,0.00,2622.40,1662601.60,1835680.00,173078.40,730499),('1','146','258226','325',634.00,700.00,0.00,2637.86,1672403.24,1846502.00,174098.76,730500),('1','146','258227','325',634.00,700.00,0.00,2634.00,1669956.00,1843800.00,173844.00,730501),('1','146','258228','325',634.00,700.00,0.00,2400.52,1521929.68,1680364.00,158434.32,730502),('1','146','258229','325',634.00,700.00,0.00,226.25,143442.50,158375.00,14932.50,730503),('1','146','258230','325',634.00,700.00,0.00,2405.96,1525378.64,1684172.00,158793.36,730504);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=303 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',302,'146','PRODUCT TANK','TANKS CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=768 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','146','302',767,1,'325','LPG TANK',7000.00,1.00,1564.81,'TANK CONTAINING LPG','479','2020-08-10 18:58:11','2020-08-12 11:57:30','487',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','146',767,2932.81,'2023-03-20 20:15:57');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2752535 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2108636,'1','146','767',325,'Retail Sale Id 1254322',32000.00,0.00,0.00,0.00,1900.00,'2021-12-01 06:58:06','',''),(2108637,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 06:58:06','',''),(2108754,'1','146','767',325,'Retail Sale Id 1254337',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 07:04:08','',''),(2108755,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:04:08','',''),(2108788,'1','146','767',325,'Retail Sale Id 1254395',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 07:05:24','',''),(2108789,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 07:05:24','',''),(2109717,'1','146','767',325,'Retail Sale Id 1254798',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 07:47:37','',''),(2109718,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 07:47:37','',''),(2109784,'1','146','767',325,'Retail Sale Id 1254832',12000.00,0.00,0.00,0.00,712.50,'2021-12-01 07:50:48','',''),(2109785,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-01 07:50:48','',''),(2109814,'1','146','767',325,'Retail Sale Id 1254843',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 07:52:33','',''),(2109815,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 07:52:33','',''),(2109860,'1','146','767',325,'Retail Sale Id 1254868',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 07:54:48','',''),(2109861,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:54:48','',''),(2109890,'1','146','767',325,'Retail Sale Id 1254893',16000.00,0.00,0.00,0.00,950.00,'2021-12-01 07:56:43','',''),(2109891,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 07:56:43','',''),(2109932,'1','146','767',325,'Retail Sale Id 1254907',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 07:58:34','',''),(2109933,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:58:34','',''),(2109949,'1','146','767',325,'Retail Sale Id 1254916',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 07:59:43','',''),(2109950,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 07:59:43','',''),(2109975,'1','146','767',325,'Retail Sale Id 1254928',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 08:01:23','',''),(2109976,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:01:23','',''),(2110015,'1','146','767',325,'Retail Sale Id 1254950',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 08:03:09','',''),(2110016,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:03:09','',''),(2110040,'1','146','767',325,'Retail Sale Id 1254962',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 08:04:09','',''),(2110041,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 08:04:09','',''),(2110088,'1','146','767',325,'Retail Sale Id 1254980',16000.00,0.00,0.00,0.00,950.00,'2021-12-01 08:06:23','',''),(2110089,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 08:06:23','',''),(2110685,'1','146','767',325,'Retail Sale Id 1255270',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 08:41:17','',''),(2110686,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 08:41:17','',''),(2110798,'1','146','767',325,'Retail Sale Id 1255334',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 08:47:53','',''),(2110799,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 08:47:53','',''),(2110852,'1','146','767',325,'Retail Sale Id 1255365',12000.00,0.00,0.00,0.00,712.50,'2021-12-01 08:51:27','',''),(2110853,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-01 08:51:27','',''),(2110910,'1','146','767',325,'Retail Sale Id 1255392',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 08:54:49','',''),(2110911,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:54:49','',''),(2110928,'1','146','767',325,'Retail Sale Id 1255403',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 08:55:49','',''),(2110929,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 08:55:49','',''),(2110947,'1','146','767',325,'Retail Sale Id 1255415',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 08:56:53','',''),(2110948,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:56:53','',''),(2111022,'1','146','767',325,'Retail Sale Id 1255452',24998.40,0.00,0.00,0.00,1484.28,'2021-12-01 09:01:17','',''),(2111023,'1','146','767',325,'Retail sales',0.00,0.00,0.00,39.06,0.00,'2021-12-01 09:01:17','',''),(2111058,'1','146','767',325,'Retail Sale Id 1255467',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 09:03:23','',''),(2111059,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:03:23','',''),(2111136,'1','146','767',325,'Retail Sale Id 1255506',16000.00,0.00,0.00,0.00,950.00,'2021-12-01 09:08:31','',''),(2111137,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 09:08:31','',''),(2111216,'1','146','767',325,'Retail Sale Id 1255547',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 09:13:19','',''),(2111217,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:13:19','',''),(2111250,'1','146','767',325,'Retail Sale Id 1255567',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 09:15:24','',''),(2111251,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:15:24','',''),(2111370,'1','146','767',325,'Retail Sale Id 1255635',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 09:22:44','',''),(2111371,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:22:44','',''),(2111432,'1','146','767',325,'Retail Sale Id 1255664',4998.40,0.00,0.00,0.00,296.78,'2021-12-01 09:26:06','',''),(2111433,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 09:26:06','',''),(2111458,'1','146','767',325,'Retail Sale Id 1255675',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 09:27:27','',''),(2111459,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 09:27:27','',''),(2111486,'1','146','767',325,'Retail Sale Id 1255692',7001.60,0.00,0.00,0.00,415.72,'2021-12-01 09:29:04','',''),(2111487,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-01 09:29:04','',''),(2111547,'1','146','767',325,'Retail Sale Id 1255726',4998.40,0.00,0.00,0.00,296.78,'2021-12-01 09:34:15','',''),(2111548,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 09:34:15','',''),(2111583,'1','146','767',325,'Retail Sale Id 1255745',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 09:36:31','',''),(2111584,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 09:36:31','',''),(2111682,'1','146','767',325,'Retail Sale Id 1255797',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 09:42:36','',''),(2111683,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 09:42:36','',''),(2111742,'1','146','767',325,'Retail Sale Id 1255831',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 09:46:47','',''),(2111743,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 09:46:47','',''),(2111768,'1','146','767',325,'Retail Sale Id 1255848',16000.00,0.00,0.00,0.00,950.00,'2021-12-01 09:48:41','',''),(2111769,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 09:48:41','',''),(2111898,'1','146','767',325,'Retail Sale Id 1255907',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 09:58:08','',''),(2111899,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 09:58:08','',''),(2111925,'1','146','767',325,'Retail Sale Id 1255916',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 09:59:43','',''),(2111926,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:59:43','',''),(2111953,'1','146','767',325,'Retail Sale Id 1255925',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 10:00:50','',''),(2111954,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 10:00:51','',''),(2111979,'1','146','767',325,'Retail Sale Id 1255940',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 10:02:02','',''),(2111980,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 10:02:02','',''),(2112112,'1','146','767',325,'Retail Sale Id 1256011',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 10:12:19','',''),(2112113,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:12:19','',''),(2112128,'1','146','767',325,'Retail Sale Id 1256019',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 10:13:19','',''),(2112129,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 10:13:19','',''),(2112138,'1','146','767',325,'Retail Sale Id 1256024',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 10:14:06','',''),(2112139,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 10:14:06','',''),(2112156,'1','146','767',325,'Retail Sale Id 1256033',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 10:15:02','',''),(2112157,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 10:15:02','',''),(2112172,'1','146','767',325,'Retail Sale Id 1256043',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 10:15:48','',''),(2112173,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:15:48','',''),(2112198,'1','146','767',325,'Retail Sale Id 1256049',5497.60,0.00,0.00,0.00,326.42,'2021-12-01 10:16:38','',''),(2112199,'1','146','767',325,'Retail sales',0.00,0.00,0.00,8.59,0.00,'2021-12-01 10:16:38','',''),(2112208,'1','146','767',325,'Retail Sale Id 1256055',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 10:17:28','',''),(2112209,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:17:28','',''),(2112249,'1','146','767',325,'Retail Sale Id 1256075',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 10:20:58','',''),(2112250,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:20:58','',''),(2112311,'1','146','767',325,'Retail Sale Id 1256101',6502.40,0.00,0.00,0.00,386.08,'2021-12-01 10:26:27','',''),(2112312,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-01 10:26:27','',''),(2112317,'1','146','767',325,'Retail Sale Id 1256105',1702.40,0.00,0.00,0.00,101.08,'2021-12-01 10:27:15','',''),(2112318,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-01 10:27:15','',''),(2112387,'1','146','767',325,'Retail Sale Id 1256139',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 10:31:55','',''),(2112388,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:31:55','',''),(2112449,'1','146','767',325,'Retail Sale Id 1256172',2598.40,0.00,0.00,0.00,154.28,'2021-12-01 10:36:33','',''),(2112450,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-01 10:36:33','',''),(2112489,'1','146','767',325,'Retail Sale Id 1256190',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 10:39:03','',''),(2112490,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:39:03','',''),(2112505,'1','146','767',325,'Retail Sale Id 1256200',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 10:41:04','',''),(2112506,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 10:41:04','',''),(2112525,'1','146','767',325,'Retail Sale Id 1256208',4998.40,0.00,0.00,0.00,296.78,'2021-12-01 10:42:44','',''),(2112526,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 10:42:44','',''),(2112532,'1','146','767',325,'Retail Sale Id 1256212',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 10:43:45','',''),(2112533,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 10:43:45','',''),(2112552,'1','146','767',325,'Retail Sale Id 1256223',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 10:45:28','',''),(2112553,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 10:45:28','',''),(2112708,'1','146','767',325,'Retail Sale Id 1256307',7001.60,0.00,0.00,0.00,415.72,'2021-12-01 10:59:27','',''),(2112709,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-01 10:59:27','',''),(2112804,'1','146','767',325,'Retail Sale Id 1256356',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 11:06:57','',''),(2112805,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:06:57','',''),(2112856,'1','146','767',325,'Retail Sale Id 1256384',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 11:10:27','',''),(2112857,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 11:10:27','',''),(2112921,'1','146','767',325,'Retail Sale Id 1256409',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 11:13:14','',''),(2112922,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 11:13:14','',''),(2113232,'1','146','767',325,'Retail Sale Id 1256528',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 11:32:54','',''),(2113233,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 11:32:54','',''),(2113240,'1','146','767',325,'Retail Sale Id 1256560',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 11:34:02','',''),(2113241,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 11:34:02','',''),(2113266,'1','146','767',325,'Retail Sale Id 1256575',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 11:35:52','',''),(2113267,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 11:35:52','',''),(2113339,'1','146','767',325,'Retail Sale Id 1256613',12998.40,0.00,0.00,0.00,771.78,'2021-12-01 11:40:43','',''),(2113340,'1','146','767',325,'Retail sales',0.00,0.00,0.00,20.31,0.00,'2021-12-01 11:40:43','',''),(2113398,'1','146','767',325,'Retail Sale Id 1256646',48000.00,0.00,0.00,0.00,2850.00,'2021-12-01 11:45:06','',''),(2113399,'1','146','767',325,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-01 11:45:06','',''),(2114045,'1','146','767',325,'Retail Sale Id 1256979',32000.00,0.00,0.00,0.00,1900.00,'2021-12-01 12:39:30','',''),(2114046,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 12:39:30','',''),(2114059,'1','146','767',325,'Retail Sale Id 1256985',32000.00,0.00,0.00,0.00,1900.00,'2021-12-01 12:40:38','',''),(2114060,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 12:40:38','',''),(2116854,'1','146','767',325,'Retail Sale Id 1258321',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 15:47:45','',''),(2116855,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 15:47:45','',''),(2116872,'1','146','767',325,'Retail Sale Id 1258330',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 15:48:39','',''),(2116873,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:48:39','',''),(2116902,'1','146','767',325,'Retail Sale Id 1258343',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 15:49:58','',''),(2116903,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 15:49:58','',''),(2116950,'1','146','767',325,'Retail Sale Id 1258368',1702.40,0.00,0.00,0.00,101.08,'2021-12-01 15:51:29','',''),(2116951,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-01 15:51:29','',''),(2116974,'1','146','767',325,'Retail Sale Id 1258379',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 15:52:33','',''),(2116975,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:52:33','',''),(2117004,'1','146','767',325,'Retail Sale Id 1258393',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 15:53:47','',''),(2117005,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 15:53:47','',''),(2117024,'1','146','767',325,'Retail Sale Id 1258404',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 15:54:41','',''),(2117025,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 15:54:41','',''),(2117049,'1','146','767',325,'Retail Sale Id 1258413',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 15:55:43','',''),(2117050,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:55:43','',''),(2117094,'1','146','767',325,'Retail Sale Id 1258437',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 15:57:43','',''),(2117095,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 15:57:43','',''),(2117133,'1','146','767',325,'Retail Sale Id 1258457',64000.00,0.00,0.00,0.00,3800.00,'2021-12-01 15:59:22','',''),(2117134,'1','146','767',325,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-01 15:59:22','',''),(2117267,'1','146','767',325,'Retail Sale Id 1258524',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 16:05:36','',''),(2117268,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 16:05:36','',''),(2117393,'1','146','767',325,'Retail Sale Id 1258566',7052.80,0.00,0.00,0.00,418.76,'2021-12-01 16:09:53','',''),(2117394,'1','146','767',325,'Retail sales',0.00,0.00,0.00,11.02,0.00,'2021-12-01 16:09:53','',''),(2117508,'1','146','767',325,'Retail Sale Id 1258612',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 16:14:29','',''),(2117509,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:14:29','',''),(2117541,'1','146','767',325,'Retail Sale Id 1258633',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 16:15:52','',''),(2117542,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:15:52','',''),(2117642,'1','146','767',325,'Retail Sale Id 1258686',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 16:20:10','',''),(2117643,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:20:10','',''),(2117714,'1','146','767',325,'Retail Sale Id 1258721',3200.00,0.00,0.00,0.00,190.00,'2021-12-01 16:23:05','',''),(2117715,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:23:05','',''),(2117768,'1','146','767',325,'Retail Sale Id 1258754',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 16:25:45','',''),(2117769,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:25:45','',''),(2117804,'1','146','767',325,'Retail Sale Id 1258784',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 16:27:23','',''),(2117805,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:27:23','',''),(2117848,'1','146','767',325,'Retail Sale Id 1258806',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 16:29:16','',''),(2117849,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:29:16','',''),(2117880,'1','146','767',325,'Retail Sale Id 1258824',16000.00,0.00,0.00,0.00,950.00,'2021-12-01 16:31:02','',''),(2117881,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 16:31:02','',''),(2117896,'1','146','767',325,'Retail Sale Id 1258831',15001.60,0.00,0.00,0.00,890.72,'2021-12-01 16:31:48','',''),(2117897,'1','146','767',325,'Retail sales',0.00,0.00,0.00,23.44,0.00,'2021-12-01 16:31:48','',''),(2117928,'1','146','767',325,'Retail Sale Id 1258848',998.40,0.00,0.00,0.00,59.28,'2021-12-01 16:33:10','',''),(2117929,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:33:10','',''),(2117954,'1','146','767',325,'Retail Sale Id 1258864',3500.80,0.00,0.00,0.00,207.86,'2021-12-01 16:34:44','',''),(2117955,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 16:34:44','',''),(2117980,'1','146','767',325,'Retail Sale Id 1258878',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 16:36:13','',''),(2117981,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:36:13','',''),(2118014,'1','146','767',325,'Retail Sale Id 1258895',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 16:37:43','',''),(2118015,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 16:37:43','',''),(2118044,'1','146','767',325,'Retail Sale Id 1258913',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 16:39:08','',''),(2118047,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 16:39:08','',''),(2118132,'1','146','767',325,'Retail Sale Id 1258958',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 16:43:27','',''),(2118133,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:43:27','',''),(2118166,'1','146','767',325,'Retail Sale Id 1258978',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 16:45:10','',''),(2118167,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 16:45:10','',''),(2118208,'1','146','767',325,'Retail Sale Id 1259000',2502.40,0.00,0.00,0.00,148.58,'2021-12-01 16:47:47','',''),(2118209,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-01 16:47:47','',''),(2118276,'1','146','767',325,'Retail Sale Id 1259027',24000.00,0.00,0.00,0.00,1425.00,'2021-12-01 16:50:46','',''),(2118277,'1','146','767',325,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-01 16:50:46','',''),(2118290,'1','146','767',325,'Retail Sale Id 1259041',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 16:51:32','',''),(2118291,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 16:51:32','',''),(2118314,'1','146','767',325,'Retail Sale Id 1259053',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 16:52:52','',''),(2118315,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 16:52:52','',''),(2118383,'1','146','767',325,'Retail Sale Id 1259081',7200.00,0.00,0.00,0.00,427.50,'2021-12-01 16:55:13','',''),(2118384,'1','146','767',325,'Retail sales',0.00,0.00,0.00,11.25,0.00,'2021-12-01 16:55:13','',''),(2118466,'1','146','767',325,'Retail Sale Id 1259125',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 16:58:34','',''),(2118467,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 16:58:34','',''),(2118516,'1','146','767',325,'Retail Sale Id 1259151',3500.80,0.00,0.00,0.00,207.86,'2021-12-01 17:00:39','',''),(2118517,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-01 17:00:39','',''),(2118550,'1','146','767',325,'Retail Sale Id 1259171',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 17:02:26','',''),(2118551,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:02:26','',''),(2118582,'1','146','767',325,'Retail Sale Id 1259185',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 17:03:48','',''),(2118583,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:03:48','',''),(2118642,'1','146','767',325,'Retail Sale Id 1259209',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 17:06:47','',''),(2118643,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 17:06:47','',''),(2118690,'1','146','767',325,'Retail Sale Id 1259236',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 17:09:22','',''),(2118691,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 17:09:22','',''),(2118754,'1','146','767',325,'Retail Sale Id 1259270',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 17:13:05','',''),(2118755,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:13:05','',''),(2118796,'1','146','767',325,'Retail Sale Id 1259293',6003.20,0.00,0.00,0.00,356.44,'2021-12-01 17:15:06','',''),(2118797,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-01 17:15:06','',''),(2118820,'1','146','767',325,'Retail Sale Id 1259303',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 17:16:30','',''),(2118821,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 17:16:30','',''),(2118886,'1','146','767',325,'Retail Sale Id 1259338',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 17:21:12','',''),(2118887,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 17:21:12','',''),(2118967,'1','146','767',325,'Retail Sale Id 1259376',3001.60,0.00,0.00,0.00,178.22,'2021-12-01 17:26:46','',''),(2118968,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-01 17:26:46','',''),(2118987,'1','146','767',325,'Retail Sale Id 1259388',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 17:28:10','',''),(2118988,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:28:10','',''),(2119117,'1','146','767',325,'Retail Sale Id 1259451',6400.00,0.00,0.00,0.00,380.00,'2021-12-01 17:37:03','',''),(2119118,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 17:37:03','',''),(2119171,'1','146','767',325,'Retail Sale Id 1259476',24000.00,0.00,0.00,0.00,1425.00,'2021-12-01 17:41:11','',''),(2119172,'1','146','767',325,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-01 17:41:11','',''),(2119226,'1','146','767',325,'Retail Sale Id 1259506',1497.60,0.00,0.00,0.00,88.92,'2021-12-01 17:45:29','',''),(2119227,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-01 17:45:29','',''),(2119272,'1','146','767',325,'Retail Sale Id 1259526',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 17:50:04','',''),(2119273,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 17:50:04','',''),(2119282,'1','146','767',325,'Retail Sale Id 1259531',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 17:51:44','',''),(2119283,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:51:44','',''),(2119359,'1','146','767',325,'Retail Sale Id 1259571',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 18:01:51','',''),(2119360,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 18:01:51','',''),(2119385,'1','146','767',325,'Retail Sale Id 1259582',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 18:06:09','',''),(2119386,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 18:06:09','',''),(2119396,'1','146','767',325,'Retail Sale Id 1259586',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 18:07:40','',''),(2119397,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 18:07:40','',''),(2119411,'1','146','767',325,'Retail Sale Id 1259594',4000.00,0.00,0.00,0.00,237.50,'2021-12-01 18:09:22','',''),(2119412,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 18:09:22','',''),(2119436,'1','146','767',325,'Retail Sale Id 1259613',1280.00,0.00,0.00,0.00,76.00,'2021-12-01 18:13:04','',''),(2119437,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 18:13:04','',''),(2119444,'1','146','767',325,'Retail Sale Id 1259618',96000.00,0.00,0.00,0.00,5700.00,'2021-12-01 18:14:37','',''),(2119445,'1','146','767',325,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-01 18:14:37','',''),(2119451,'1','146','767',325,'Retail Sale Id 1259621',128000.00,0.00,0.00,0.00,7600.00,'2021-12-01 18:15:08','',''),(2119452,'1','146','767',325,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-01 18:15:08','',''),(2119457,'1','146','767',325,'Retail Sale Id 1259624',192000.00,0.00,0.00,0.00,11400.00,'2021-12-01 18:15:37','',''),(2119458,'1','146','767',325,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-01 18:15:37','',''),(2119465,'1','146','767',325,'Retail Sale Id 1259627',12000.00,0.00,0.00,0.00,712.50,'2021-12-01 18:16:35','',''),(2119466,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-01 18:16:35','',''),(2119480,'1','146','767',325,'Retail Sale Id 1259635',998.40,0.00,0.00,0.00,59.28,'2021-12-01 18:18:40','',''),(2119481,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 18:18:40','',''),(2119494,'1','146','767',325,'Retail Sale Id 1259643',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 18:20:23','',''),(2119495,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 18:20:23','',''),(2119509,'1','146','767',325,'Retail Sale Id 1259650',2003.20,0.00,0.00,0.00,118.94,'2021-12-01 18:21:58','',''),(2119510,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 18:21:58','',''),(2119524,'1','146','767',325,'Retail Sale Id 1259654',8000.00,0.00,0.00,0.00,475.00,'2021-12-01 18:23:22','',''),(2119525,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 18:23:22','',''),(2119534,'1','146','767',325,'Retail Sale Id 1259661',256000.00,0.00,0.00,0.00,15200.00,'2021-12-01 18:24:41','',''),(2119535,'1','146','767',325,'Retail sales',0.00,0.00,0.00,400.00,0.00,'2021-12-01 18:24:41','',''),(2119859,'1','146','767',325,'Retail Sale Id 1259762',52633.60,0.00,0.00,0.00,3125.12,'2021-12-01 19:51:16','',''),(2119860,'1','146','767',325,'Retail sales',0.00,0.00,0.00,82.24,0.00,'2021-12-01 19:51:16','',''),(2120260,'1','146','767',325,'Retail Sale Id 1259784',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 05:42:18','',''),(2120261,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 05:42:18','',''),(2120482,'1','146','767',325,'Retail Sale Id 1259896',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 06:12:09','',''),(2120483,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 06:12:09','',''),(2120512,'1','146','767',325,'Retail Sale Id 1259909',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 06:14:52','',''),(2120513,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 06:14:52','',''),(2120557,'1','146','767',325,'Retail Sale Id 1259926',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 06:17:55','',''),(2120558,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 06:17:55','',''),(2120634,'1','146','767',325,'Retail Sale Id 1259965',1497.60,0.00,0.00,0.00,88.92,'2021-12-02 06:23:48','',''),(2120635,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 06:23:48','',''),(2120650,'1','146','767',325,'Retail Sale Id 1259972',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 06:25:33','',''),(2120651,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 06:25:33','',''),(2120680,'1','146','767',325,'Retail Sale Id 1259988',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 06:27:27','',''),(2120681,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 06:27:27','',''),(2120696,'1','146','767',325,'Retail Sale Id 1259996',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 06:28:45','',''),(2120697,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 06:28:45','',''),(2120724,'1','146','767',325,'Retail Sale Id 1260013',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 06:31:01','',''),(2120725,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 06:31:01','',''),(2120746,'1','146','767',325,'Retail Sale Id 1260024',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 06:32:31','',''),(2120747,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 06:32:31','',''),(2120772,'1','146','767',325,'Retail Sale Id 1260036',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 06:34:19','',''),(2120773,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 06:34:19','',''),(2120784,'1','146','767',325,'Retail Sale Id 1260043',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 06:35:39','',''),(2120785,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 06:35:39','',''),(2120981,'1','146','767',325,'Retail Sale Id 1260106',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 06:44:24','',''),(2120982,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 06:44:24','',''),(2121166,'1','146','767',325,'Retail Sale Id 1260144',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 06:54:54','',''),(2121167,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 06:54:54','',''),(2121208,'1','146','767',325,'Retail Sale Id 1260202',2502.40,0.00,0.00,0.00,148.58,'2021-12-02 06:56:33','',''),(2121209,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 06:56:33','',''),(2121264,'1','146','767',325,'Retail Sale Id 1260227',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 06:59:48','',''),(2121265,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 06:59:48','',''),(2121320,'1','146','767',325,'Retail Sale Id 1260255',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:03:44','',''),(2121321,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:03:44','',''),(2121412,'1','146','767',325,'Retail Sale Id 1260305',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 07:08:36','',''),(2121413,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:08:36','',''),(2121514,'1','146','767',325,'Retail Sale Id 1260335',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:12:19','',''),(2121515,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:12:19','',''),(2121540,'1','146','767',325,'Retail Sale Id 1260351',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:14:08','',''),(2121541,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:14:08','',''),(2121588,'1','146','767',325,'Retail Sale Id 1260372',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 07:16:37','',''),(2121589,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 07:16:37','',''),(2121629,'1','146','767',325,'Retail Sale Id 1260396',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 07:18:30','',''),(2121630,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:18:30','',''),(2121791,'1','146','767',325,'Retail Sale Id 1260454',18003.20,0.00,0.00,0.00,1068.94,'2021-12-02 07:26:19','',''),(2121792,'1','146','767',325,'Retail sales',0.00,0.00,0.00,28.13,0.00,'2021-12-02 07:26:19','',''),(2121845,'1','146','767',325,'Retail Sale Id 1260502',11200.00,0.00,0.00,0.00,665.00,'2021-12-02 07:28:58','',''),(2121846,'1','146','767',325,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-02 07:28:58','',''),(2121879,'1','146','767',325,'Retail Sale Id 1260523',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 07:31:01','',''),(2121880,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 07:31:01','',''),(2121899,'1','146','767',325,'Retail Sale Id 1260539',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:32:51','',''),(2121900,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:32:51','',''),(2121953,'1','146','767',325,'Retail Sale Id 1260573',6003.20,0.00,0.00,0.00,356.44,'2021-12-02 07:35:50','',''),(2121954,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 07:35:50','',''),(2121987,'1','146','767',325,'Retail Sale Id 1260594',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 07:37:41','',''),(2121988,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 07:37:41','',''),(2122047,'1','146','767',325,'Retail Sale Id 1260625',2003.20,0.00,0.00,0.00,118.94,'2021-12-02 07:40:09','',''),(2122048,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 07:40:09','',''),(2122233,'1','146','767',325,'Retail Sale Id 1260720',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 07:48:57','',''),(2122234,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:48:57','',''),(2122347,'1','146','767',325,'Retail Sale Id 1260761',2598.40,0.00,0.00,0.00,154.28,'2021-12-02 07:51:57','',''),(2122348,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-02 07:51:57','',''),(2122389,'1','146','767',325,'Retail Sale Id 1260782',20800.00,0.00,0.00,0.00,1235.00,'2021-12-02 07:53:54','',''),(2122390,'1','146','767',325,'Retail sales',0.00,0.00,0.00,32.50,0.00,'2021-12-02 07:53:54','',''),(2122518,'1','146','767',325,'Retail Sale Id 1260839',16000.00,0.00,0.00,0.00,950.00,'2021-12-02 07:58:47','',''),(2122519,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 07:58:47','',''),(2122570,'1','146','767',325,'Retail Sale Id 1260856',3200.00,0.00,0.00,0.00,190.00,'2021-12-02 08:00:07','',''),(2122571,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:00:07','',''),(2122615,'1','146','767',325,'Retail Sale Id 1260878',7001.60,0.00,0.00,0.00,415.72,'2021-12-02 08:02:42','',''),(2122616,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-02 08:02:42','',''),(2122669,'1','146','767',325,'Retail Sale Id 1260908',499.20,0.00,0.00,0.00,29.64,'2021-12-02 08:05:17','',''),(2122670,'1','146','767',325,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-02 08:05:17','',''),(2122781,'1','146','767',325,'Retail Sale Id 1260959',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 08:10:59','',''),(2122782,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 08:10:59','',''),(2122823,'1','146','767',325,'Retail Sale Id 1260978',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 08:13:33','',''),(2122824,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 08:13:33','',''),(2122874,'1','146','767',325,'Retail Sale Id 1261014',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 08:16:41','',''),(2122875,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 08:16:41','',''),(2122898,'1','146','767',325,'Retail Sale Id 1261026',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 08:17:51','',''),(2122899,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:17:51','',''),(2122938,'1','146','767',325,'Retail Sale Id 1261049',1299.20,0.00,0.00,0.00,77.14,'2021-12-02 08:19:39','',''),(2122939,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 08:19:39','',''),(2123009,'1','146','767',325,'Retail Sale Id 1261088',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 08:23:09','',''),(2123010,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 08:23:09','',''),(2123071,'1','146','767',325,'Retail Sale Id 1261114',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 08:25:48','',''),(2123072,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:25:48','',''),(2123089,'1','146','767',325,'Retail Sale Id 1261122',4000.00,0.00,0.00,0.00,237.50,'2021-12-02 08:27:00','',''),(2123090,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 08:27:00','',''),(2123129,'1','146','767',325,'Retail Sale Id 1261140',8000.00,0.00,0.00,0.00,475.00,'2021-12-02 08:28:50','',''),(2123130,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:28:50','',''),(2123213,'1','146','767',325,'Retail Sale Id 1261187',12000.00,0.00,0.00,0.00,712.50,'2021-12-02 08:33:54','',''),(2123214,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-02 08:33:54','',''),(2123253,'1','146','767',325,'Retail Sale Id 1261206',3001.60,0.00,0.00,0.00,178.22,'2021-12-02 08:35:57','',''),(2123254,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 08:35:57','',''),(2124637,'1','146','767',325,'Retail Sale Id 1261870',26374.40,0.00,0.00,0.00,1565.98,'2021-12-02 09:49:34','',''),(2124638,'1','146','767',325,'Retail sales',0.00,0.00,0.00,41.21,0.00,'2021-12-02 09:49:34','',''),(2124782,'1','146',NULL,325,'Purchased from AA RANO NIGERIA LIMITED',0.00,1184000.00,2000.00,0.00,0.00,'2021-12-02 09:56:19','',''),(2124819,'1','146',NULL,325,'Reception corrector for bridging 125928',0.00,0.00,0.00,2000.00,0.00,'2021-12-02 09:57:57','',''),(2124820,'1','146','767',325,'Received from bridging 125928',0.00,0.00,2000.00,0.00,0.00,'2021-12-02 09:57:57','',''),(2125742,'1','146','767',325,'Retail Sale Id 1262422',3500.80,0.00,0.00,0.00,262.56,'2021-12-02 10:51:49','',''),(2125743,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 10:51:49','',''),(2125760,'1','146','767',325,'Retail Sale Id 1262433',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 10:53:18','',''),(2125761,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 10:53:18','',''),(2125778,'1','146','767',325,'Retail Sale Id 1262441',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 10:54:32','',''),(2125779,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 10:54:32','',''),(2125794,'1','146','767',325,'Retail Sale Id 1262448',3001.60,0.00,0.00,0.00,225.12,'2021-12-02 10:56:09','',''),(2125795,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 10:56:09','',''),(2125814,'1','146','767',325,'Retail Sale Id 1262462',16000.00,0.00,0.00,0.00,1200.00,'2021-12-02 10:57:55','',''),(2125815,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 10:57:55','',''),(2125834,'1','146','767',325,'Retail Sale Id 1262476',12000.00,0.00,0.00,0.00,900.00,'2021-12-02 10:59:44','',''),(2125835,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-02 10:59:44','',''),(2125860,'1','146','767',325,'Retail Sale Id 1262486',3200.00,0.00,0.00,0.00,240.00,'2021-12-02 11:01:14','',''),(2125861,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 11:01:14','',''),(2125890,'1','146','767',325,'Retail Sale Id 1262504',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 11:02:32','',''),(2125891,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:02:32','',''),(2125924,'1','146','767',325,'Retail Sale Id 1262523',3500.80,0.00,0.00,0.00,262.56,'2021-12-02 11:04:34','',''),(2125925,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 11:04:34','',''),(2125944,'1','146','767',325,'Retail Sale Id 1262537',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 11:05:58','',''),(2125945,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 11:05:58','',''),(2125960,'1','146','767',325,'Retail Sale Id 1262544',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 11:06:58','',''),(2125961,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:06:58','',''),(2125994,'1','146','767',325,'Retail Sale Id 1262565',6400.00,0.00,0.00,0.00,480.00,'2021-12-02 11:09:15','',''),(2125995,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 11:09:15','',''),(2126037,'1','146','767',325,'Retail Sale Id 1262585',3200.00,0.00,0.00,0.00,240.00,'2021-12-02 11:11:22','',''),(2126038,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 11:11:22','',''),(2126124,'1','146','767',325,'Retail Sale Id 1262627',998.40,0.00,0.00,0.00,74.88,'2021-12-02 11:16:35','',''),(2126125,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 11:16:35','',''),(2126160,'1','146','767',325,'Retail Sale Id 1262655',16000.00,0.00,0.00,0.00,1200.00,'2021-12-02 11:18:33','',''),(2126161,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 11:18:33','',''),(2126188,'1','146','767',325,'Retail Sale Id 1262670',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 11:20:08','',''),(2126189,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 11:20:08','',''),(2126220,'1','146','767',325,'Retail Sale Id 1262687',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 11:21:37','',''),(2126221,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 11:21:37','',''),(2126244,'1','146','767',325,'Retail Sale Id 1262700',16000.00,0.00,0.00,0.00,1200.00,'2021-12-02 11:23:30','',''),(2126245,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 11:23:30','',''),(2126272,'1','146','767',325,'Retail Sale Id 1262712',4998.40,0.00,0.00,0.00,374.88,'2021-12-02 11:25:33','',''),(2126273,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 11:25:33','',''),(2126418,'1','146','767',325,'Retail Sale Id 1262777',32000.00,0.00,0.00,0.00,2400.00,'2021-12-02 11:31:49','',''),(2126419,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 11:31:49','',''),(2126458,'1','146','767',325,'Retail Sale Id 1262671',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 11:33:58','',''),(2126459,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 11:33:58','',''),(2126495,'1','146','767',325,'Retail Sale Id 1262806',499.20,0.00,0.00,0.00,37.44,'2021-12-02 11:35:47','',''),(2126496,'1','146','767',325,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-02 11:35:47','',''),(2126546,'1','146','767',325,'Retail Sale Id 1262821',3001.60,0.00,0.00,0.00,225.12,'2021-12-02 11:37:40','',''),(2126547,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 11:37:40','',''),(2126573,'1','146','767',325,'Retail Sale Id 1262834',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 11:39:26','',''),(2126574,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:39:26','',''),(2126603,'1','146','767',325,'Retail Sale Id 1262848',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 11:40:46','',''),(2126604,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:40:46','',''),(2126621,'1','146','767',325,'Retail Sale Id 1262858',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 11:42:13','',''),(2126622,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 11:42:13','',''),(2126659,'1','146','767',325,'Retail Sale Id 1262875',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 11:45:06','',''),(2126660,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 11:45:06','',''),(2126673,'1','146','767',325,'Retail Sale Id 1262882',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 11:46:47','',''),(2126674,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 11:46:47','',''),(2126779,'1','146','767',325,'Retail Sale Id 1262941',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 11:55:00','',''),(2126780,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 11:55:00','',''),(2126851,'1','146','767',325,'Retail Sale Id 1262978',22400.00,0.00,0.00,0.00,1680.00,'2021-12-02 12:00:46','',''),(2126852,'1','146','767',325,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-02 12:00:46','',''),(2126887,'1','146','767',325,'Retail Sale Id 1262997',26003.20,0.00,0.00,0.00,1950.24,'2021-12-02 12:04:24','',''),(2126888,'1','146','767',325,'Retail sales',0.00,0.00,0.00,40.63,0.00,'2021-12-02 12:04:24','',''),(2126944,'1','146','767',325,'Retail Sale Id 1263025',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 12:09:21','',''),(2126945,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:09:21','',''),(2126958,'1','146','767',325,'Retail Sale Id 1263032',4998.40,0.00,0.00,0.00,374.88,'2021-12-02 12:10:32','',''),(2126959,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 12:10:32','',''),(2127003,'1','146','767',325,'Retail Sale Id 1263052',6003.20,0.00,0.00,0.00,450.24,'2021-12-02 12:14:40','',''),(2127004,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-02 12:14:40','',''),(2127017,'1','146','767',325,'Retail Sale Id 1263061',4998.40,0.00,0.00,0.00,374.88,'2021-12-02 12:16:04','',''),(2127018,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 12:16:04','',''),(2127036,'1','146','767',325,'Retail Sale Id 1263069',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 12:18:31','',''),(2127037,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 12:18:31','',''),(2127068,'1','146','767',325,'Retail Sale Id 1263087',48000.00,0.00,0.00,0.00,3600.00,'2021-12-02 12:20:56','',''),(2127069,'1','146','767',325,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-02 12:20:56','',''),(2127094,'1','146','767',325,'Retail Sale Id 1263102',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 12:22:40','',''),(2127095,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 12:22:40','',''),(2127116,'1','146','767',325,'Retail Sale Id 1263112',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 12:24:16','',''),(2127117,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:24:16','',''),(2127242,'1','146','767',325,'Retail Sale Id 1263195',3001.60,0.00,0.00,0.00,225.12,'2021-12-02 12:32:48','',''),(2127243,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 12:32:48','',''),(2127298,'1','146','767',325,'Retail Sale Id 1263224',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 12:37:43','',''),(2127299,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:37:43','',''),(2127316,'1','146','767',325,'Retail Sale Id 1263233',1299.20,0.00,0.00,0.00,97.44,'2021-12-02 12:38:55','',''),(2127317,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 12:38:55','',''),(2127367,'1','146',NULL,325,'Purchased from AA RANO NIGERIA LIMITED',0.00,1876640.00,3170.00,0.00,0.00,'2021-12-02 12:43:00','',''),(2127384,'1','146',NULL,325,'Reception corrector for bridging 125947',0.00,0.00,0.00,3170.00,0.00,'2021-12-02 12:45:13','',''),(2127385,'1','146','767',325,'Received from bridging 125947',0.00,0.00,3170.00,0.00,0.00,'2021-12-02 12:45:13','',''),(2127416,'1','146','767',325,'Retail Sale Id 1263278',12800.00,0.00,0.00,0.00,960.00,'2021-12-02 12:47:15','',''),(2127417,'1','146','767',325,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-02 12:47:15','',''),(2127481,'1','146','767',325,'Retail Sale Id 1263305',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 12:50:46','',''),(2127482,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:50:46','',''),(2127526,'1','146','767',325,'Retail Sale Id 1263326',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 12:54:46','',''),(2127527,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:54:46','',''),(2127554,'1','146','767',325,'Retail Sale Id 1263337',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 12:57:46','',''),(2127555,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:57:46','',''),(2127584,'1','146','767',325,'Retail Sale Id 1263352',30003.20,0.00,0.00,0.00,2250.24,'2021-12-02 12:59:28','',''),(2127585,'1','146','767',325,'Retail sales',0.00,0.00,0.00,46.88,0.00,'2021-12-02 12:59:28','',''),(2127600,'1','146','767',325,'Retail Sale Id 1263362',32000.00,0.00,0.00,0.00,2400.00,'2021-12-02 13:00:45','',''),(2127601,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 13:00:45','',''),(2127680,'1','146','767',325,'Retail Sale Id 1263404',11001.60,0.00,0.00,0.00,825.12,'2021-12-02 13:06:26','',''),(2127681,'1','146','767',325,'Retail sales',0.00,0.00,0.00,17.19,0.00,'2021-12-02 13:06:26','',''),(2127724,'1','146','767',325,'Retail Sale Id 1263426',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 13:09:46','',''),(2127725,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:09:46','',''),(2127748,'1','146','767',325,'Retail Sale Id 1263438',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 13:11:26','',''),(2127749,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:11:26','',''),(2128908,'1','146','767',325,'Retail Sale Id 1263941',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 14:21:35','',''),(2128909,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:21:35','',''),(2129236,'1','146','767',325,'Retail Sale Id 1264058',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 14:34:35','',''),(2129237,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 14:34:35','',''),(2129262,'1','146','767',325,'Retail Sale Id 1264072',3001.60,0.00,0.00,0.00,225.12,'2021-12-02 14:36:07','',''),(2129263,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 14:36:07','',''),(2129378,'1','146','767',325,'Retail Sale Id 1264110',998.40,0.00,0.00,0.00,74.88,'2021-12-02 14:40:15','',''),(2129379,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 14:40:15','',''),(2129405,'1','146','767',325,'Retail Sale Id 1264122',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 14:41:27','',''),(2129406,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 14:41:27','',''),(2129437,'1','146','767',325,'Retail Sale Id 1264138',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 14:43:00','',''),(2129438,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 14:43:00','',''),(2129465,'1','146','767',325,'Retail Sale Id 1264152',6400.00,0.00,0.00,0.00,480.00,'2021-12-02 14:44:53','',''),(2129466,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 14:44:53','',''),(2129477,'1','146','767',325,'Retail Sale Id 1264160',1299.20,0.00,0.00,0.00,97.44,'2021-12-02 14:46:16','',''),(2129478,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-02 14:46:16','',''),(2129505,'1','146','767',325,'Retail Sale Id 1264175',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 14:47:58','',''),(2129506,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:47:58','',''),(2129547,'1','146','767',325,'Retail Sale Id 1264197',4998.40,0.00,0.00,0.00,374.88,'2021-12-02 14:49:28','',''),(2129548,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 14:49:28','',''),(2129567,'1','146','767',325,'Retail Sale Id 1264207',3500.80,0.00,0.00,0.00,262.56,'2021-12-02 14:51:19','',''),(2129568,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-02 14:51:19','',''),(2129604,'1','146','767',325,'Retail Sale Id 1264226',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 14:53:32','',''),(2129605,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 14:53:32','',''),(2129634,'1','146','767',325,'Retail Sale Id 1264240',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 14:55:16','',''),(2129635,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:55:16','',''),(2129663,'1','146','767',325,'Retail Sale Id 1264254',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 14:56:35','',''),(2129664,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 14:56:35','',''),(2129695,'1','146','767',325,'Retail Sale Id 1264275',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 14:58:07','',''),(2129696,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:58:07','',''),(2129783,'1','146','767',325,'Retail Sale Id 1264318',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 15:05:41','',''),(2129784,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 15:05:41','',''),(2129855,'1','146','767',325,'Retail Sale Id 1264351',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 15:10:23','',''),(2129856,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:10:24','',''),(2129960,'1','146','767',325,'Retail Sale Id 1264403',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 15:15:56','',''),(2129961,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 15:15:56','',''),(2130012,'1','146','767',325,'Retail Sale Id 1264436',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 15:18:35','',''),(2130013,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 15:18:35','',''),(2130040,'1','146','767',325,'Retail Sale Id 1264449',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 15:20:22','',''),(2130041,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 15:20:22','',''),(2130158,'1','146','767',325,'Retail Sale Id 1264507',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 15:26:03','',''),(2130159,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 15:26:03','',''),(2130243,'1','146','767',325,'Retail Sale Id 1264535',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 15:29:22','',''),(2130244,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:29:22','',''),(2130301,'1','146','767',325,'Retail Sale Id 1264570',16000.00,0.00,0.00,0.00,1200.00,'2021-12-02 15:32:04','',''),(2130302,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 15:32:04','',''),(2130323,'1','146','767',325,'Retail Sale Id 1264586',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 15:33:36','',''),(2130324,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:33:36','',''),(2130454,'1','146','767',325,'Retail Sale Id 1264645',6400.00,0.00,0.00,0.00,480.00,'2021-12-02 15:39:12','',''),(2130455,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 15:39:12','',''),(2130496,'1','146','767',325,'Retail Sale Id 1264663',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 15:41:14','',''),(2130497,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:41:14','',''),(2130908,'1','146','767',325,'Retail Sale Id 1264892',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 15:59:26','',''),(2130909,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:59:26','',''),(2130944,'1','146','767',325,'Retail Sale Id 1264912',16000.00,0.00,0.00,0.00,1200.00,'2021-12-02 16:01:15','',''),(2130945,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 16:01:15','',''),(2130996,'1','146','767',325,'Retail Sale Id 1264933',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 16:03:08','',''),(2130997,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 16:03:08','',''),(2131084,'1','146','767',325,'Retail Sale Id 1264968',7001.60,0.00,0.00,0.00,525.12,'2021-12-02 16:07:03','',''),(2131085,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-02 16:07:03','',''),(2131122,'1','146','767',325,'Retail Sale Id 1264988',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 16:08:25','',''),(2131123,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:08:25','',''),(2131168,'1','146','767',325,'Retail Sale Id 1265008',2502.40,0.00,0.00,0.00,187.68,'2021-12-02 16:10:16','',''),(2131169,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 16:10:16','',''),(2131442,'1','146','767',325,'Retail Sale Id 1265028',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 16:24:16','',''),(2131443,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:24:16','',''),(2131462,'1','146','767',325,'Retail Sale Id 1265161',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 16:25:31','',''),(2131463,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 16:25:31','',''),(2131508,'1','146','767',325,'Retail Sale Id 1265185',7001.60,0.00,0.00,0.00,525.12,'2021-12-02 16:27:24','',''),(2131509,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-02 16:27:24','',''),(2131560,'1','146','767',325,'Retail Sale Id 1265209',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 16:29:17','',''),(2131561,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:29:17','',''),(2131634,'1','146','767',325,'Retail Sale Id 1265232',4998.40,0.00,0.00,0.00,374.88,'2021-12-02 16:30:52','',''),(2131635,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 16:30:52','',''),(2131658,'1','146','767',325,'Retail Sale Id 1265244',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 16:31:46','',''),(2131659,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 16:31:46','',''),(2131676,'1','146','767',325,'Retail Sale Id 1265255',3001.60,0.00,0.00,0.00,225.12,'2021-12-02 16:32:57','',''),(2131677,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 16:32:57','',''),(2131748,'1','146','767',325,'Retail Sale Id 1265296',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 16:36:32','',''),(2131749,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 16:36:32','',''),(2131760,'1','146','767',325,'Retail Sale Id 1265304',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 16:37:42','',''),(2131761,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 16:37:42','',''),(2131808,'1','146','767',325,'Retail Sale Id 1265322',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 16:40:22','',''),(2131809,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 16:40:22','',''),(2131825,'1','146','767',325,'Retail Sale Id 1265331',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 16:41:17','',''),(2131826,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:41:17','',''),(2131853,'1','146','767',325,'Retail Sale Id 1265346',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 16:42:46','',''),(2131854,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 16:42:46','',''),(2131879,'1','146','767',325,'Retail Sale Id 1265357',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 16:43:51','',''),(2131880,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 16:43:51','',''),(2131917,'1','146','767',325,'Retail Sale Id 1265372',3001.60,0.00,0.00,0.00,225.12,'2021-12-02 16:45:05','',''),(2131918,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 16:45:05','',''),(2131948,'1','146','767',325,'Retail Sale Id 1265394',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 16:46:40','',''),(2131949,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 16:46:40','',''),(2131978,'1','146','767',325,'Retail Sale Id 1265410',998.40,0.00,0.00,0.00,74.88,'2021-12-02 16:48:18','',''),(2131979,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 16:48:18','',''),(2132000,'1','146','767',325,'Retail Sale Id 1265421',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 16:49:50','',''),(2132002,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:49:50','',''),(2132042,'1','146','767',325,'Retail Sale Id 1265446',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 16:52:32','',''),(2132044,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 16:52:32','',''),(2132154,'1','146','767',325,'Retail Sale Id 1265505',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 16:59:15','',''),(2132155,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 16:59:15','',''),(2132173,'1','146','767',325,'Retail Sale Id 1265509',8499.20,0.00,0.00,0.00,637.44,'2021-12-02 17:00:44','',''),(2132174,'1','146','767',325,'Retail sales',0.00,0.00,0.00,13.28,0.00,'2021-12-02 17:00:44','',''),(2132319,'1','146','767',325,'Retail Sale Id 1265577',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 17:09:45','',''),(2132320,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 17:09:45','',''),(2132334,'1','146','767',325,'Retail Sale Id 1265584',11500.80,0.00,0.00,0.00,862.56,'2021-12-02 17:10:52','',''),(2132335,'1','146','767',325,'Retail sales',0.00,0.00,0.00,17.97,0.00,'2021-12-02 17:10:52','',''),(2132373,'1','146','767',325,'Retail Sale Id 1265602',12000.00,0.00,0.00,0.00,900.00,'2021-12-02 17:13:20','',''),(2132374,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-02 17:13:20','',''),(2132394,'1','146','767',325,'Retail Sale Id 1265615',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 17:14:39','',''),(2132395,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 17:14:39','',''),(2132416,'1','146','767',325,'Retail Sale Id 1265627',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 17:15:48','',''),(2132417,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 17:15:48','',''),(2132450,'1','146','767',325,'Retail Sale Id 1265634',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 17:17:17','',''),(2132451,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 17:17:17','',''),(2132473,'1','146','767',325,'Retail Sale Id 1265646',1497.60,0.00,0.00,0.00,112.32,'2021-12-02 17:18:39','',''),(2132474,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-02 17:18:39','',''),(2132499,'1','146','767',325,'Retail Sale Id 1265657',32000.00,0.00,0.00,0.00,2400.00,'2021-12-02 17:20:17','',''),(2132500,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 17:20:17','',''),(2132543,'1','146','767',325,'Retail Sale Id 1265673',697.60,0.00,0.00,0.00,52.32,'2021-12-02 17:21:55','',''),(2132544,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-02 17:21:55','',''),(2132629,'1','146','767',325,'Retail Sale Id 1265712',8000.00,0.00,0.00,0.00,600.00,'2021-12-02 17:27:54','',''),(2132630,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 17:27:54','',''),(2132633,'1','146','767',325,'Retail Sale Id 1265717',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 17:29:11','',''),(2132635,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 17:29:11','',''),(2132699,'1','146','767',325,'Retail Sale Id 1265747',3001.60,0.00,0.00,0.00,225.12,'2021-12-02 17:35:42','',''),(2132700,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-02 17:35:42','',''),(2132735,'1','146','767',325,'Retail Sale Id 1265765',4000.00,0.00,0.00,0.00,300.00,'2021-12-02 17:39:16','',''),(2132736,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 17:39:16','',''),(2132753,'1','146','767',325,'Retail Sale Id 1265773',4998.40,0.00,0.00,0.00,374.88,'2021-12-02 17:41:03','',''),(2132754,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-02 17:41:03','',''),(2132790,'1','146','767',325,'Retail Sale Id 1265795',2003.20,0.00,0.00,0.00,150.24,'2021-12-02 17:45:49','',''),(2132791,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 17:45:49','',''),(2133450,'1','146','767',325,'Retail Sale Id 1266040',485100.80,0.00,0.00,0.00,36382.56,'2021-12-02 19:56:37','',''),(2133451,'1','146','767',325,'Retail sales',0.00,0.00,0.00,757.97,0.00,'2021-12-02 19:56:37','',''),(2133948,'1','146','767',325,'Retail Sale Id 1266104',7097.60,0.00,0.00,0.00,532.32,'2021-12-03 06:09:10','',''),(2133949,'1','146','767',325,'Retail sales',0.00,0.00,0.00,11.09,0.00,'2021-12-03 06:09:10','',''),(2133982,'1','146','767',325,'Retail Sale Id 1266114',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 06:11:42','',''),(2133983,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:11:42','',''),(2134095,'1','146','767',325,'Retail Sale Id 1266143',64000.00,0.00,0.00,0.00,4800.00,'2021-12-03 06:21:20','',''),(2134096,'1','146','767',325,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-03 06:21:20','',''),(2134117,'1','146','767',325,'Retail Sale Id 1266156',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 06:23:49','',''),(2134118,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:23:49','',''),(2134143,'1','146','767',325,'Retail Sale Id 1266169',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 06:26:29','',''),(2134144,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 06:26:29','',''),(2134159,'1','146','767',325,'Retail Sale Id 1266177',6400.00,0.00,0.00,0.00,480.00,'2021-12-03 06:28:10','',''),(2134160,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 06:28:10','',''),(2134165,'1','146','767',325,'Retail Sale Id 1266181',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 06:28:56','',''),(2134166,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 06:28:56','',''),(2134182,'1','146','767',325,'Retail Sale Id 1266189',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 06:30:32','',''),(2134183,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 06:30:32','',''),(2134204,'1','146','767',325,'Retail Sale Id 1266193',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 06:31:07','',''),(2134205,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:31:07','',''),(2134212,'1','146','767',325,'Retail Sale Id 1266198',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 06:31:42','',''),(2134213,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 06:31:42','',''),(2134236,'1','146','767',325,'Retail Sale Id 1266206',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 06:33:39','',''),(2134237,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:33:39','',''),(2134258,'1','146','767',325,'Retail Sale Id 1266217',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 06:34:33','',''),(2134259,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:34:33','',''),(2134275,'1','146','767',325,'Retail Sale Id 1266223',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 06:35:23','',''),(2134276,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:35:23','',''),(2134289,'1','146','767',325,'Retail Sale Id 1266231',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 06:36:07','',''),(2134290,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 06:36:07','',''),(2134298,'1','146','767',325,'Retail Sale Id 1266235',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 06:36:45','',''),(2134299,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 06:36:45','',''),(2134308,'1','146','767',325,'Retail Sale Id 1266239',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 06:37:22','',''),(2134309,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 06:37:22','',''),(2134317,'1','146','767',325,'Retail Sale Id 1266245',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 06:37:58','',''),(2134318,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 06:37:58','',''),(2134372,'1','146','767',325,'Retail Sale Id 1266275',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 06:40:53','',''),(2134373,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 06:40:53','',''),(2134409,'1','146','767',325,'Retail Sale Id 1266294',4998.40,0.00,0.00,0.00,374.88,'2021-12-03 06:43:04','',''),(2134410,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 06:43:04','',''),(2134470,'1','146','767',325,'Retail Sale Id 1266324',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 06:46:16','',''),(2134471,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 06:46:16','',''),(2134521,'1','146','767',325,'Retail Sale Id 1266346',697.60,0.00,0.00,0.00,52.32,'2021-12-03 06:48:31','',''),(2134522,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-03 06:48:31','',''),(2134563,'1','146','767',325,'Retail Sale Id 1266366',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 06:51:05','',''),(2134564,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:51:05','',''),(2134587,'1','146','767',325,'Retail Sale Id 1266378',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 06:52:21','',''),(2134588,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:52:21','',''),(2134607,'1','146','767',325,'Retail Sale Id 1266389',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 06:53:27','',''),(2134608,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 06:53:27','',''),(2134621,'1','146','767',325,'Retail Sale Id 1266397',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 06:54:05','',''),(2134622,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:54:05','',''),(2134635,'1','146','767',325,'Retail Sale Id 1266406',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 06:55:03','',''),(2134636,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:55:03','',''),(2134675,'1','146','767',325,'Retail Sale Id 1266420',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 06:56:57','',''),(2134676,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 06:56:57','',''),(2134713,'1','146','767',325,'Retail Sale Id 1266439',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 06:58:54','',''),(2134714,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:58:54','',''),(2134725,'1','146','767',325,'Retail Sale Id 1266446',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 06:59:50','',''),(2134726,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:59:50','',''),(2134745,'1','146','767',325,'Retail Sale Id 1266458',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 07:01:01','',''),(2134746,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:01:01','',''),(2134789,'1','146','767',325,'Retail Sale Id 1266480',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 07:03:39','',''),(2134790,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:03:39','',''),(2134803,'1','146','767',325,'Retail Sale Id 1266487',6400.00,0.00,0.00,0.00,480.00,'2021-12-03 07:04:39','',''),(2134804,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 07:04:39','',''),(2134819,'1','146','767',325,'Retail Sale Id 1266496',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 07:05:35','',''),(2134820,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:05:35','',''),(2134831,'1','146','767',325,'Retail Sale Id 1266506',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 07:06:21','',''),(2134832,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:06:21','',''),(2134859,'1','146','767',325,'Retail Sale Id 1266523',16000.00,0.00,0.00,0.00,1200.00,'2021-12-03 07:08:00','',''),(2134860,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 07:08:00','',''),(2134903,'1','146','767',325,'Retail Sale Id 1266540',9600.00,0.00,0.00,0.00,720.00,'2021-12-03 07:11:33','',''),(2134904,'1','146','767',325,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-03 07:11:33','',''),(2134942,'1','146','767',325,'Retail Sale Id 1266552',16000.00,0.00,0.00,0.00,1200.00,'2021-12-03 07:12:14','',''),(2134943,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 07:12:14','',''),(2134974,'1','146','767',325,'Retail Sale Id 1266566',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 07:14:09','',''),(2134975,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:14:09','',''),(2135000,'1','146','767',325,'Retail Sale Id 1266584',7052.80,0.00,0.00,0.00,528.96,'2021-12-03 07:15:31','',''),(2135001,'1','146','767',325,'Retail sales',0.00,0.00,0.00,11.02,0.00,'2021-12-03 07:15:31','',''),(2135008,'1','146','767',325,'Retail Sale Id 1266589',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 07:16:05','',''),(2135009,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:16:05','',''),(2135022,'1','146','767',325,'Retail Sale Id 1266596',16000.00,0.00,0.00,0.00,1200.00,'2021-12-03 07:16:44','',''),(2135023,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 07:16:44','',''),(2135081,'1','146','767',325,'Retail Sale Id 1266622',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 07:20:01','',''),(2135082,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:20:01','',''),(2135109,'1','146','767',325,'Retail Sale Id 1266633',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 07:21:13','',''),(2135110,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:21:13','',''),(2135131,'1','146','767',325,'Retail Sale Id 1266645',8998.40,0.00,0.00,0.00,674.88,'2021-12-03 07:22:43','',''),(2135132,'1','146','767',325,'Retail sales',0.00,0.00,0.00,14.06,0.00,'2021-12-03 07:22:43','',''),(2135208,'1','146','767',325,'Retail Sale Id 1266683',19200.00,0.00,0.00,0.00,1440.00,'2021-12-03 07:27:23','',''),(2135209,'1','146','767',325,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-03 07:27:23','',''),(2135262,'1','146','767',325,'Retail Sale Id 1266709',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 07:31:09','',''),(2135263,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 07:31:09','',''),(2135309,'1','146','767',325,'Retail Sale Id 1266735',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 07:33:43','',''),(2135310,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 07:33:43','',''),(2135339,'1','146','767',325,'Retail Sale Id 1266750',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 07:35:18','',''),(2135340,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:35:18','',''),(2135370,'1','146','767',325,'Retail Sale Id 1266764',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 07:36:53','',''),(2135371,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:36:53','',''),(2135394,'1','146','767',325,'Retail Sale Id 1266773',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 07:37:39','',''),(2135395,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:37:39','',''),(2135419,'1','146','767',325,'Retail Sale Id 1266784',4998.40,0.00,0.00,0.00,374.88,'2021-12-03 07:39:14','',''),(2135420,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 07:39:14','',''),(2135429,'1','146','767',325,'Retail Sale Id 1266788',6400.00,0.00,0.00,0.00,480.00,'2021-12-03 07:39:47','',''),(2135430,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 07:39:47','',''),(2135461,'1','146','767',325,'Retail Sale Id 1266801',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 07:41:53','',''),(2135464,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:41:53','',''),(2135475,'1','146','767',325,'Retail Sale Id 1266811',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 07:42:45','',''),(2135476,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 07:42:45','',''),(2135483,'1','146','767',325,'Retail Sale Id 1266815',7001.60,0.00,0.00,0.00,525.12,'2021-12-03 07:43:25','',''),(2135484,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-03 07:43:25','',''),(2135512,'1','146','767',325,'Retail Sale Id 1266828',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 07:44:20','',''),(2135513,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:44:20','',''),(2135524,'1','146','767',325,'Retail Sale Id 1266833',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 07:45:10','',''),(2135525,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 07:45:10','',''),(2135528,'1','146','767',325,'Retail Sale Id 1266837',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 07:45:44','',''),(2135529,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:45:44','',''),(2135543,'1','146','767',325,'Retail Sale Id 1266843',6400.00,0.00,0.00,0.00,480.00,'2021-12-03 07:46:19','',''),(2135544,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 07:46:19','',''),(2135651,'1','146','767',325,'Retail Sale Id 1266894',998.40,0.00,0.00,0.00,74.88,'2021-12-03 07:51:19','',''),(2135652,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 07:51:19','',''),(2135779,'1','146','767',325,'Retail Sale Id 1266951',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 07:58:36','',''),(2135780,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 07:58:36','',''),(2135797,'1','146','767',325,'Retail Sale Id 1266960',20000.00,0.00,0.00,0.00,1500.00,'2021-12-03 07:59:39','',''),(2135798,'1','146','767',325,'Retail sales',0.00,0.00,0.00,31.25,0.00,'2021-12-03 07:59:39','',''),(2135847,'1','146','767',325,'Retail Sale Id 1266974',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 08:01:34','',''),(2135848,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:01:34','',''),(2135889,'1','146','767',325,'Retail Sale Id 1266981',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 08:02:17','',''),(2135890,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:02:17','',''),(2135964,'1','146','767',325,'Retail Sale Id 1267017',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 08:05:08','',''),(2135965,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:05:08','',''),(2136016,'1','146','767',325,'Retail Sale Id 1267044',6003.20,0.00,0.00,0.00,450.24,'2021-12-03 08:08:12','',''),(2136017,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-03 08:08:12','',''),(2136056,'1','146','767',325,'Retail Sale Id 1267063',3500.80,0.00,0.00,0.00,262.56,'2021-12-03 08:09:03','',''),(2136057,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-03 08:09:03','',''),(2136066,'1','146','767',325,'Retail Sale Id 1267067',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 08:09:46','',''),(2136067,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 08:09:46','',''),(2136158,'1','146','767',325,'Retail Sale Id 1267115',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 08:14:06','',''),(2136159,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 08:14:06','',''),(2136214,'1','146','767',325,'Retail Sale Id 1267149',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 08:17:31','',''),(2136215,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 08:17:31','',''),(2136283,'1','146','767',325,'Retail Sale Id 1267184',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 08:21:44','',''),(2136284,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:21:44','',''),(2136324,'1','146','767',325,'Retail Sale Id 1267192',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 08:24:01','',''),(2136325,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:24:01','',''),(2136402,'1','146','767',325,'Retail Sale Id 1267239',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 08:28:36','',''),(2136403,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 08:28:36','',''),(2136410,'1','146','767',325,'Retail Sale Id 1267242',16000.00,0.00,0.00,0.00,1200.00,'2021-12-03 08:29:33','',''),(2136411,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 08:29:33','',''),(2136432,'1','146','767',325,'Retail Sale Id 1267246',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 08:31:26','',''),(2136433,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 08:31:26','',''),(2136734,'1','146','767',325,'Retail Sale Id 1267312',7097.60,0.00,0.00,0.00,532.32,'2021-12-03 08:41:57','',''),(2136735,'1','146','767',325,'Retail sales',0.00,0.00,0.00,11.09,0.00,'2021-12-03 08:41:57','',''),(2136914,'1','146','767',325,'Retail Sale Id 1267419',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 08:52:51','',''),(2136915,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:52:51','',''),(2136928,'1','146','767',325,'Retail Sale Id 1267427',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 08:53:33','',''),(2136929,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:53:33','',''),(2136940,'1','146','767',325,'Retail Sale Id 1267432',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 08:54:01','',''),(2136941,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:54:01','',''),(2136954,'1','146','767',325,'Retail Sale Id 1267440',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 08:54:37','',''),(2136955,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 08:54:37','',''),(2136968,'1','146','767',325,'Retail Sale Id 1267447',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 08:55:23','',''),(2136969,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 08:55:23','',''),(2136990,'1','146','767',325,'Retail Sale Id 1267458',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 08:56:40','',''),(2136991,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 08:56:40','',''),(2137004,'1','146','767',325,'Retail Sale Id 1267464',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 08:57:14','',''),(2137005,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:57:14','',''),(2137015,'1','146','767',325,'Retail Sale Id 1267469',6400.00,0.00,0.00,0.00,480.00,'2021-12-03 08:58:13','',''),(2137016,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 08:58:13','',''),(2137029,'1','146','767',325,'Retail Sale Id 1267476',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 08:58:53','',''),(2137030,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:58:53','',''),(2137046,'1','146','767',325,'Retail Sale Id 1267486',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 08:59:58','',''),(2137047,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 08:59:58','',''),(2137064,'1','146','767',325,'Retail Sale Id 1267497',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 09:00:54','',''),(2137065,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:00:54','',''),(2137090,'1','146','767',325,'Retail Sale Id 1267508',32000.00,0.00,0.00,0.00,2400.00,'2021-12-03 09:01:59','',''),(2137091,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 09:01:59','',''),(2137106,'1','146','767',325,'Retail Sale Id 1267519',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 09:02:48','',''),(2137107,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 09:02:48','',''),(2137120,'1','146','767',325,'Retail Sale Id 1267526',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 09:03:26','',''),(2137121,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 09:03:26','',''),(2137194,'1','146','767',325,'Retail Sale Id 1267566',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 09:06:46','',''),(2137195,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:06:46','',''),(2137215,'1','146','767',325,'Retail Sale Id 1267578',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 09:07:46','',''),(2137216,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:07:46','',''),(2137239,'1','146','767',325,'Retail Sale Id 1267593',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 09:08:44','',''),(2137240,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:08:44','',''),(2137247,'1','146','767',325,'Retail Sale Id 1267598',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 09:09:19','',''),(2137248,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:09:19','',''),(2137261,'1','146','767',325,'Retail Sale Id 1267605',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 09:10:07','',''),(2137262,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:10:07','',''),(2137374,'1','146','767',325,'Retail Sale Id 1267681',60800.00,0.00,0.00,0.00,4560.00,'2021-12-03 09:15:46','',''),(2137376,'1','146','767',325,'Retail sales',0.00,0.00,0.00,95.00,0.00,'2021-12-03 09:15:46','',''),(2137403,'1','146','767',325,'Retail Sale Id 1267694',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 09:16:57','',''),(2137404,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:16:57','',''),(2137425,'1','146','767',325,'Retail Sale Id 1267711',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 09:18:09','',''),(2137426,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:18:09','',''),(2137481,'1','146','767',325,'Retail Sale Id 1267735',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 09:21:23','',''),(2137482,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:21:23','',''),(2137659,'1','146','767',325,'Retail Sale Id 1267834',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 09:32:37','',''),(2137660,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:32:37','',''),(2137687,'1','146','767',325,'Retail Sale Id 1267850',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 09:34:13','',''),(2137688,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:34:13','',''),(2137699,'1','146','767',325,'Retail Sale Id 1267855',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 09:34:59','',''),(2137700,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:34:59','',''),(2137705,'1','146','767',325,'Retail Sale Id 1267861',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 09:35:47','',''),(2137706,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:35:47','',''),(2137719,'1','146','767',325,'Retail Sale Id 1267870',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 09:36:38','',''),(2137720,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:36:38','',''),(2137745,'1','146','767',325,'Retail Sale Id 1267881',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 09:38:12','',''),(2137746,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:38:12','',''),(2137761,'1','146','767',325,'Retail Sale Id 1267887',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 09:39:18','',''),(2137762,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:39:18','',''),(2137831,'1','146','767',325,'Retail Sale Id 1267930',32000.00,0.00,0.00,0.00,2400.00,'2021-12-03 09:43:31','',''),(2137832,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 09:43:31','',''),(2137865,'1','146','767',325,'Retail Sale Id 1267947',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 09:45:32','',''),(2137866,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:45:33','',''),(2137885,'1','146','767',325,'Retail Sale Id 1267954',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 09:46:37','',''),(2137886,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:46:37','',''),(2137900,'1','146','767',325,'Retail Sale Id 1267965',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 09:47:32','',''),(2137901,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:47:32','',''),(2137948,'1','146','767',325,'Retail Sale Id 1267985',9497.60,0.00,0.00,0.00,712.32,'2021-12-03 09:50:20','',''),(2137949,'1','146','767',325,'Retail sales',0.00,0.00,0.00,14.84,0.00,'2021-12-03 09:50:20','',''),(2137958,'1','146','767',325,'Retail Sale Id 1267990',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 09:50:57','',''),(2137959,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:50:57','',''),(2137972,'1','146','767',325,'Retail Sale Id 1267997',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 09:51:44','',''),(2137973,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:51:44','',''),(2137986,'1','146','767',325,'Retail Sale Id 1268004',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 09:52:54','',''),(2137987,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:52:54','',''),(2138000,'1','146','767',325,'Retail Sale Id 1268012',9497.60,0.00,0.00,0.00,712.32,'2021-12-03 09:53:34','',''),(2138001,'1','146','767',325,'Retail sales',0.00,0.00,0.00,14.84,0.00,'2021-12-03 09:53:34','',''),(2138010,'1','146','767',325,'Retail Sale Id 1268016',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 09:54:12','',''),(2138011,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 09:54:12','',''),(2138024,'1','146','767',325,'Retail Sale Id 1268022',6400.00,0.00,0.00,0.00,480.00,'2021-12-03 09:55:29','',''),(2138025,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 09:55:29','',''),(2138038,'1','146','767',325,'Retail Sale Id 1268030',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 09:56:13','',''),(2138039,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 09:56:13','',''),(2138050,'1','146','767',325,'Retail Sale Id 1268036',998.40,0.00,0.00,0.00,74.88,'2021-12-03 09:56:51','',''),(2138051,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 09:56:51','',''),(2138265,'1','146','767',325,'Retail Sale Id 1268143',998.40,0.00,0.00,0.00,74.88,'2021-12-03 10:08:59','',''),(2138266,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 10:08:59','',''),(2138298,'1','146','767',325,'Retail Sale Id 1268159',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 10:10:34','',''),(2138299,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:10:34','',''),(2138330,'1','146','767',325,'Retail Sale Id 1268170',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 10:12:04','',''),(2138331,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 10:12:04','',''),(2138342,'1','146','767',325,'Retail Sale Id 1268181',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 10:12:47','',''),(2138343,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:12:47','',''),(2138365,'1','146','767',325,'Retail Sale Id 1268196',14003.20,0.00,0.00,0.00,1050.24,'2021-12-03 10:14:33','',''),(2138366,'1','146','767',325,'Retail sales',0.00,0.00,0.00,21.88,0.00,'2021-12-03 10:14:33','',''),(2138405,'1','146','767',325,'Retail Sale Id 1268215',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 10:16:43','',''),(2138406,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:16:43','',''),(2138415,'1','146','767',325,'Retail Sale Id 1268220',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 10:17:21','',''),(2138416,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 10:17:21','',''),(2138426,'1','146','767',325,'Retail Sale Id 1268224',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 10:18:06','',''),(2138427,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 10:18:06','',''),(2138466,'1','146','767',325,'Retail Sale Id 1268232',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 10:20:14','',''),(2138467,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 10:20:14','',''),(2138480,'1','146','767',325,'Retail Sale Id 1268247',3500.80,0.00,0.00,0.00,262.56,'2021-12-03 10:21:04','',''),(2138481,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-03 10:21:04','',''),(2138492,'1','146','767',325,'Retail Sale Id 1268253',4998.40,0.00,0.00,0.00,374.88,'2021-12-03 10:22:02','',''),(2138493,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 10:22:02','',''),(2138504,'1','146','767',325,'Retail Sale Id 1268261',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 10:22:39','',''),(2138505,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 10:22:39','',''),(2138635,'1','146','767',325,'Retail Sale Id 1268329',5798.40,0.00,0.00,0.00,434.88,'2021-12-03 10:30:32','',''),(2138636,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.06,0.00,'2021-12-03 10:30:32','',''),(2138667,'1','146','767',325,'Retail Sale Id 1268341',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 10:31:51','',''),(2138668,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 10:31:51','',''),(2138680,'1','146','767',325,'Retail Sale Id 1268347',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 10:33:06','',''),(2138681,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 10:33:06','',''),(2138797,'1','146','767',325,'Retail Sale Id 1268391',998.40,0.00,0.00,0.00,74.88,'2021-12-03 10:40:05','',''),(2138798,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 10:40:05','',''),(2138823,'1','146','767',325,'Retail Sale Id 1268414',16000.00,0.00,0.00,0.00,1200.00,'2021-12-03 10:41:41','',''),(2138824,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 10:41:41','',''),(2138853,'1','146','767',325,'Retail Sale Id 1268440',32000.00,0.00,0.00,0.00,2400.00,'2021-12-03 10:44:34','',''),(2138854,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 10:44:34','',''),(2138883,'1','146','767',325,'Retail Sale Id 1268454',24000.00,0.00,0.00,0.00,1800.00,'2021-12-03 10:47:06','',''),(2138884,'1','146','767',325,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-03 10:47:06','',''),(2138913,'1','146','767',325,'Retail Sale Id 1268470',16000.00,0.00,0.00,0.00,1200.00,'2021-12-03 10:49:33','',''),(2138914,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 10:49:33','',''),(2138961,'1','146','767',325,'Retail Sale Id 1268495',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 10:53:15','',''),(2138962,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:53:15','',''),(2139048,'1','146','767',325,'Retail Sale Id 1268525',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 11:00:28','',''),(2139049,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 11:00:28','',''),(2139060,'1','146','767',325,'Retail Sale Id 1268543',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 11:01:23','',''),(2139061,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 11:01:23','',''),(2139109,'1','146','767',325,'Retail Sale Id 1268563',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 11:04:28','',''),(2139110,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:04:28','',''),(2139115,'1','146','767',325,'Retail Sale Id 1268569',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 11:05:13','',''),(2139116,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:05:13','',''),(2139141,'1','146','767',325,'Retail Sale Id 1268585',998.40,0.00,0.00,0.00,74.88,'2021-12-03 11:07:04','',''),(2139142,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 11:07:04','',''),(2139157,'1','146','767',325,'Retail Sale Id 1268595',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 11:08:44','',''),(2139158,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 11:08:44','',''),(2139173,'1','146','767',325,'Retail Sale Id 1268605',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 11:10:06','',''),(2139174,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:10:06','',''),(2139187,'1','146','767',325,'Retail Sale Id 1268612',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 11:11:19','',''),(2139188,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 11:11:19','',''),(2139314,'1','146','767',325,'Retail Sale Id 1268669',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 11:18:26','',''),(2139315,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 11:18:26','',''),(2139372,'1','146','767',325,'Retail Sale Id 1268703',1299.20,0.00,0.00,0.00,97.44,'2021-12-03 11:24:34','',''),(2139373,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 11:24:34','',''),(2139394,'1','146','767',325,'Retail Sale Id 1268714',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 11:26:30','',''),(2139395,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 11:26:30','',''),(2139411,'1','146','767',325,'Retail Sale Id 1268727',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 11:28:06','',''),(2139412,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 11:28:06','',''),(2139423,'1','146','767',325,'Retail Sale Id 1268733',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 11:28:45','',''),(2139424,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 11:28:45','',''),(2139431,'1','146','767',325,'Retail Sale Id 1268734',1299.20,0.00,0.00,0.00,97.44,'2021-12-03 11:29:27','',''),(2139432,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 11:29:27','',''),(2139457,'1','146','767',325,'Retail Sale Id 1268752',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 11:30:53','',''),(2139458,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 11:30:53','',''),(2139465,'1','146','767',325,'Retail Sale Id 1268755',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 11:31:53','',''),(2139466,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 11:31:53','',''),(2139476,'1','146','767',325,'Retail Sale Id 1268762',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 11:32:37','',''),(2139477,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 11:32:37','',''),(2139482,'1','146','767',325,'Retail Sale Id 1268765',12000.00,0.00,0.00,0.00,900.00,'2021-12-03 11:33:39','',''),(2139483,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-03 11:33:39','',''),(2139508,'1','146','767',325,'Retail Sale Id 1268779',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 11:35:41','',''),(2139509,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 11:35:41','',''),(2139516,'1','146','767',325,'Retail Sale Id 1268785',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 11:36:19','',''),(2139517,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:36:19','',''),(2139568,'1','146','767',325,'Retail Sale Id 1268813',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 11:41:13','',''),(2139569,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:41:13','',''),(2139592,'1','146','767',325,'Retail Sale Id 1268829',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 11:42:01','',''),(2139593,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:42:02','',''),(2139600,'1','146','767',325,'Retail Sale Id 1268835',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 11:42:54','',''),(2139601,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 11:42:54','',''),(2139640,'1','146','767',325,'Retail Sale Id 1268859',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 11:46:18','',''),(2139641,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 11:46:18','',''),(2139658,'1','146','767',325,'Retail Sale Id 1268867',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 11:47:24','',''),(2139659,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 11:47:24','',''),(2139674,'1','146','767',325,'Retail Sale Id 1268874',6003.20,0.00,0.00,0.00,450.24,'2021-12-03 11:48:33','',''),(2139675,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-03 11:48:33','',''),(2139700,'1','146','767',325,'Retail Sale Id 1268894',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 11:50:18','',''),(2139701,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:50:18','',''),(2139709,'1','146','767',325,'Retail Sale Id 1268899',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 11:51:09','',''),(2139710,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:51:09','',''),(2139723,'1','146','767',325,'Retail Sale Id 1268905',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 11:52:13','',''),(2139724,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:52:13','',''),(2139769,'1','146','767',325,'Retail Sale Id 1268929',7001.60,0.00,0.00,0.00,525.12,'2021-12-03 11:55:48','',''),(2139770,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-03 11:55:48','',''),(2139895,'1','146','767',325,'Retail Sale Id 1269000',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 12:04:07','',''),(2139896,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 12:04:07','',''),(2139909,'1','146','767',325,'Retail Sale Id 1269008',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 12:05:07','',''),(2139910,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:05:07','',''),(2139931,'1','146','767',325,'Retail Sale Id 1269032',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 12:06:36','',''),(2139932,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 12:06:36','',''),(2139951,'1','146','767',325,'Retail Sale Id 1269044',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 12:07:51','',''),(2139952,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:07:51','',''),(2139960,'1','146','767',325,'Retail Sale Id 1269048',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 12:08:39','',''),(2139961,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 12:08:39','',''),(2139978,'1','146','767',325,'Retail Sale Id 1269058',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 12:09:28','',''),(2139979,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 12:09:28','',''),(2139990,'1','146','767',325,'Retail Sale Id 1269064',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 12:10:12','',''),(2139991,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 12:10:12','',''),(2140100,'1','146','767',325,'Retail Sale Id 1269123',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 12:22:32','',''),(2140101,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 12:22:32','',''),(2140116,'1','146','767',325,'Retail Sale Id 1269132',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 12:24:01','',''),(2140117,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 12:24:01','',''),(2140136,'1','146','767',325,'Retail Sale Id 1269138',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 12:25:08','',''),(2140137,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 12:25:08','',''),(2140147,'1','146','767',325,'Retail Sale Id 1269143',4499.20,0.00,0.00,0.00,337.44,'2021-12-03 12:26:00','',''),(2140148,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-03 12:26:00','',''),(2140232,'1','146','767',325,'Retail Sale Id 1269196',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 12:32:40','',''),(2140233,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:32:40','',''),(2140309,'1','146','767',325,'Retail Sale Id 1269238',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 12:38:49','',''),(2140310,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 12:38:49','',''),(2140373,'1','146','767',325,'Retail Sale Id 1269266',7500.80,0.00,0.00,0.00,562.56,'2021-12-03 12:43:17','',''),(2140374,'1','146','767',325,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-03 12:43:17','',''),(2140461,'1','146','767',325,'Retail Sale Id 1269308',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 12:49:33','',''),(2140462,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:49:33','',''),(2140519,'1','146','767',325,'Retail Sale Id 1269337',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 12:53:02','',''),(2140520,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:53:02','',''),(2140533,'1','146','767',325,'Retail Sale Id 1269344',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 12:53:57','',''),(2140534,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:53:57','',''),(2140632,'1','146','767',325,'Retail Sale Id 1269391',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 13:02:08','',''),(2140633,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 13:02:08','',''),(2140644,'1','146','767',325,'Retail Sale Id 1269396',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 13:03:39','',''),(2140645,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:03:39','',''),(2140775,'1','146','767',325,'Retail Sale Id 1269459',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 13:15:16','',''),(2140776,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 13:15:16','',''),(2140865,'1','146','767',325,'Retail Sale Id 1269488',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 13:21:12','',''),(2140866,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:21:12','',''),(2140903,'1','146','767',325,'Retail Sale Id 1269511',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 13:24:53','',''),(2140904,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:24:53','',''),(2140962,'1','146','767',325,'Retail Sale Id 1269540',6003.20,0.00,0.00,0.00,450.24,'2021-12-03 13:29:05','',''),(2140963,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-03 13:29:05','',''),(2141047,'1','146','767',325,'Retail Sale Id 1269584',7001.60,0.00,0.00,0.00,525.12,'2021-12-03 13:34:40','',''),(2141048,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-03 13:34:40','',''),(2141100,'1','146','767',325,'Retail Sale Id 1269614',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 13:38:23','',''),(2141101,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:38:23','',''),(2141128,'1','146','767',325,'Retail Sale Id 1269628',4998.40,0.00,0.00,0.00,374.88,'2021-12-03 13:40:03','',''),(2141129,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 13:40:03','',''),(2141146,'1','146','767',325,'Retail Sale Id 1269636',16000.00,0.00,0.00,0.00,1200.00,'2021-12-03 13:40:54','',''),(2141147,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 13:40:54','',''),(2141224,'1','146','767',325,'Retail Sale Id 1269663',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 13:44:22','',''),(2141225,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 13:44:22','',''),(2141248,'1','146','767',325,'Retail Sale Id 1269676',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 13:45:40','',''),(2141249,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 13:45:40','',''),(2141268,'1','146','767',325,'Retail Sale Id 1269688',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 13:46:42','',''),(2141269,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:46:42','',''),(2141524,'1','146','767',325,'Retail Sale Id 1269772',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 13:57:17','',''),(2141525,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:57:17','',''),(2141538,'1','146','767',325,'Retail Sale Id 1269778',23699.20,0.00,0.00,0.00,1777.44,'2021-12-03 13:58:16','',''),(2141539,'1','146','767',325,'Retail sales',0.00,0.00,0.00,37.03,0.00,'2021-12-03 13:58:16','',''),(2141552,'1','146','767',325,'Retail Sale Id 1269786',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 13:59:49','',''),(2141553,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 13:59:49','',''),(2141641,'1','146','767',325,'Retail Sale Id 1269821',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 14:04:43','',''),(2141642,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 14:04:43','',''),(2141722,'1','146','767',325,'Retail Sale Id 1269851',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 14:09:08','',''),(2141724,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 14:09:08','',''),(2141738,'1','146','767',325,'Retail Sale Id 1269859',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 14:10:02','',''),(2141739,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:10:02','',''),(2141770,'1','146','767',325,'Retail Sale Id 1269874',15001.60,0.00,0.00,0.00,1125.12,'2021-12-03 14:12:08','',''),(2141771,'1','146','767',325,'Retail sales',0.00,0.00,0.00,23.44,0.00,'2021-12-03 14:12:08','',''),(2141782,'1','146','767',325,'Retail Sale Id 1269882',6400.00,0.00,0.00,0.00,480.00,'2021-12-03 14:13:08','',''),(2141783,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 14:13:08','',''),(2141983,'1','146','767',325,'Retail Sale Id 1269951',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 14:24:44','',''),(2141984,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:24:44','',''),(2141995,'1','146','767',325,'Retail Sale Id 1269958',7001.60,0.00,0.00,0.00,525.12,'2021-12-03 14:25:16','',''),(2141996,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-03 14:25:16','',''),(2142089,'1','146','767',325,'Retail Sale Id 1270002',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 14:31:44','',''),(2142090,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:31:44','',''),(2142217,'1','146','767',325,'Retail Sale Id 1270040',6201.60,0.00,0.00,0.00,465.12,'2021-12-03 14:38:06','',''),(2142218,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.69,0.00,'2021-12-03 14:38:06','',''),(2142231,'1','146','767',325,'Retail Sale Id 1270048',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 14:39:13','',''),(2142232,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:39:13','',''),(2142283,'1','146','767',325,'Retail Sale Id 1270067',4998.40,0.00,0.00,0.00,374.88,'2021-12-03 14:41:27','',''),(2142284,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 14:41:27','',''),(2142451,'1','146','767',325,'Retail Sale Id 1270144',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 14:47:54','',''),(2142452,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 14:47:54','',''),(2142472,'1','146','767',325,'Retail Sale Id 1270154',32000.00,0.00,0.00,0.00,2400.00,'2021-12-03 14:48:37','',''),(2142473,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 14:48:37','',''),(2142515,'1','146','767',325,'Retail Sale Id 1270177',499.20,0.00,0.00,0.00,37.44,'2021-12-03 14:50:58','',''),(2142516,'1','146','767',325,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-03 14:50:58','',''),(2142525,'1','146','767',325,'Retail Sale Id 1270182',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 14:51:30','',''),(2142526,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 14:51:30','',''),(2142547,'1','146','767',325,'Retail Sale Id 1270194',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 14:52:24','',''),(2142548,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:52:24','',''),(2142777,'1','146','767',325,'Retail Sale Id 1270297',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 15:05:23','',''),(2142778,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:05:23','',''),(2142796,'1','146','767',325,'Retail Sale Id 1270303',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 15:06:51','',''),(2142797,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:06:51','',''),(2142814,'1','146','767',325,'Retail Sale Id 1270311',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 15:07:47','',''),(2142815,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 15:07:47','',''),(2142920,'1','146','767',325,'Retail Sale Id 1270366',4998.40,0.00,0.00,0.00,374.88,'2021-12-03 15:13:00','',''),(2142921,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 15:13:00','',''),(2142954,'1','146','767',325,'Retail Sale Id 1270384',17497.60,0.00,0.00,0.00,1312.32,'2021-12-03 15:14:15','',''),(2142955,'1','146','767',325,'Retail sales',0.00,0.00,0.00,27.34,0.00,'2021-12-03 15:14:15','',''),(2142977,'1','146','767',325,'Retail Sale Id 1270395',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 15:15:08','',''),(2142979,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:15:08','',''),(2143000,'1','146','767',325,'Retail Sale Id 1270417',998.40,0.00,0.00,0.00,74.88,'2021-12-03 15:16:24','',''),(2143001,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 15:16:24','',''),(2143028,'1','146','767',325,'Retail Sale Id 1270434',21798.40,0.00,0.00,0.00,1634.88,'2021-12-03 15:17:30','',''),(2143029,'1','146','767',325,'Retail sales',0.00,0.00,0.00,34.06,0.00,'2021-12-03 15:17:30','',''),(2143032,'1','146','767',325,'Return of Retail Sale Id 1270434',0.00,21798.40,34.06,0.00,-1634.88,'2021-12-03 15:18:04','',''),(2143091,'1','146','767',325,'Retail Sale Id 1270463',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 15:20:42','',''),(2143092,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:20:42','',''),(2143115,'1','146','767',325,'Retail Sale Id 1270485',16000.00,0.00,0.00,0.00,1200.00,'2021-12-03 15:22:11','',''),(2143116,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 15:22:11','',''),(2143159,'1','146','767',325,'Retail Sale Id 1270501',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 15:24:38','',''),(2143160,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:24:38','',''),(2143173,'1','146','767',325,'Retail Sale Id 1270513',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 15:25:35','',''),(2143174,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:25:35','',''),(2143187,'1','146','767',325,'Retail Sale Id 1270519',1299.20,0.00,0.00,0.00,97.44,'2021-12-03 15:26:16','',''),(2143188,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 15:26:16','',''),(2143220,'1','146','767',325,'Retail Sale Id 1270536',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 15:28:20','',''),(2143221,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 15:28:20','',''),(2143255,'1','146','767',325,'Retail Sale Id 1270552',7001.60,0.00,0.00,0.00,525.12,'2021-12-03 15:29:27','',''),(2143256,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-03 15:29:27','',''),(2143277,'1','146','767',325,'Retail Sale Id 1270563',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 15:30:33','',''),(2143278,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 15:30:33','',''),(2143299,'1','146','767',325,'Retail Sale Id 1270575',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 15:31:46','',''),(2143300,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 15:31:46','',''),(2143318,'1','146','767',325,'Retail Sale Id 1270581',4998.40,0.00,0.00,0.00,374.88,'2021-12-03 15:32:35','',''),(2143320,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 15:32:35','',''),(2143339,'1','146','767',325,'Retail Sale Id 1270596',3801.60,0.00,0.00,0.00,285.12,'2021-12-03 15:33:45','',''),(2143340,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-03 15:33:45','',''),(2143494,'1','146','767',325,'Retail Sale Id 1270672',3001.60,0.00,0.00,0.00,225.12,'2021-12-03 15:39:34','',''),(2143495,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-03 15:39:34','',''),(2143530,'1','146','767',325,'Retail Sale Id 1270688',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 15:41:02','',''),(2143531,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:41:02','',''),(2143566,'1','146','767',325,'Retail Sale Id 1270705',4998.40,0.00,0.00,0.00,374.88,'2021-12-03 15:42:28','',''),(2143567,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 15:42:28','',''),(2143646,'1','146','767',325,'Retail Sale Id 1270741',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 15:45:38','',''),(2143647,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:45:38','',''),(2143756,'1','146','767',325,'Retail Sale Id 1270797',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 15:49:58','',''),(2143757,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 15:49:58','',''),(2143770,'1','146','767',325,'Retail Sale Id 1270806',1497.60,0.00,0.00,0.00,112.32,'2021-12-03 15:50:44','',''),(2143771,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 15:50:44','',''),(2143798,'1','146','767',325,'Retail Sale Id 1270819',2502.40,0.00,0.00,0.00,187.68,'2021-12-03 15:52:01','',''),(2143799,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-03 15:52:01','',''),(2143824,'1','146','767',325,'Retail Sale Id 1270835',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 15:53:12','',''),(2143825,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 15:53:12','',''),(2143851,'1','146','767',325,'Retail Sale Id 1270847',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 15:54:34','',''),(2143852,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 15:54:34','',''),(2143869,'1','146','767',325,'Retail Sale Id 1270859',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 15:55:36','',''),(2143870,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:55:36','',''),(2143963,'1','146','767',325,'Retail Sale Id 1270900',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 16:00:11','',''),(2143964,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:00:11','',''),(2144051,'1','146','767',325,'Retail Sale Id 1270944',7500.80,0.00,0.00,0.00,562.56,'2021-12-03 16:03:44','',''),(2144052,'1','146','767',325,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-03 16:03:44','',''),(2144125,'1','146','767',325,'Retail Sale Id 1270977',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 16:06:30','',''),(2144126,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:06:30','',''),(2144146,'1','146','767',325,'Retail Sale Id 1270989',6003.20,0.00,0.00,0.00,450.24,'2021-12-03 16:07:35','',''),(2144147,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-03 16:07:35','',''),(2144244,'1','146','767',325,'Retail Sale Id 1271040',32000.00,0.00,0.00,0.00,2400.00,'2021-12-03 16:12:12','',''),(2144245,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 16:12:12','',''),(2144376,'1','146','767',325,'Retail Sale Id 1271110',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 16:19:32','',''),(2144377,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:19:32','',''),(2144430,'1','146','767',325,'Retail Sale Id 1271137',15001.60,0.00,0.00,0.00,1125.12,'2021-12-03 16:22:18','',''),(2144431,'1','146','767',325,'Retail sales',0.00,0.00,0.00,23.44,0.00,'2021-12-03 16:22:18','',''),(2144554,'1','146','767',325,'Retail Sale Id 1271199',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 16:29:12','',''),(2144555,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 16:29:13','',''),(2144568,'1','146','767',325,'Retail Sale Id 1271206',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 16:30:08','',''),(2144569,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 16:30:08','',''),(2144614,'1','146','767',325,'Retail Sale Id 1271228',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 16:32:04','',''),(2144615,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:32:04','',''),(2144689,'1','146','767',325,'Retail Sale Id 1271268',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 16:35:58','',''),(2144690,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:35:58','',''),(2144728,'1','146','767',325,'Retail Sale Id 1271288',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 16:37:54','',''),(2144729,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:37:54','',''),(2144748,'1','146','767',325,'Retail Sale Id 1271299',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 16:38:46','',''),(2144749,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 16:38:46','',''),(2144759,'1','146','767',325,'Retail Sale Id 1271306',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 16:39:29','',''),(2144760,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:39:29','',''),(2144773,'1','146','767',325,'Retail Sale Id 1271315',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 16:40:06','',''),(2144774,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:40:06','',''),(2144791,'1','146','767',325,'Retail Sale Id 1271323',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 16:40:56','',''),(2144792,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 16:40:56','',''),(2144840,'1','146','767',325,'Retail Sale Id 1271342',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 16:42:43','',''),(2144841,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 16:42:43','',''),(2144856,'1','146','767',325,'Retail Sale Id 1271350',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 16:43:33','',''),(2144857,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 16:43:33','',''),(2144901,'1','146','767',325,'Retail Sale Id 1271372',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 16:45:57','',''),(2144902,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 16:45:57','',''),(2144955,'1','146','767',325,'Retail Sale Id 1271397',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 16:49:37','',''),(2144956,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:49:37','',''),(2145072,'1','146','767',325,'Retail Sale Id 1271440',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 16:54:03','',''),(2145073,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 16:54:03','',''),(2145086,'1','146','767',325,'Retail Sale Id 1271448',16000.00,0.00,0.00,0.00,1200.00,'2021-12-03 16:54:42','',''),(2145087,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 16:54:42','',''),(2145149,'1','146','767',325,'Retail Sale Id 1271465',8000.00,0.00,0.00,0.00,600.00,'2021-12-03 16:56:32','',''),(2145150,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:56:32','',''),(2145290,'1','146','767',325,'Retail Sale Id 1271537',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 17:05:31','',''),(2145291,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 17:05:31','',''),(2145487,'1','146','767',325,'Retail Sale Id 1271639',6400.00,0.00,0.00,0.00,480.00,'2021-12-03 17:26:00','',''),(2145488,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 17:26:00','',''),(2145603,'1','146','767',325,'Retail Sale Id 1271710',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 17:43:00','',''),(2145604,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 17:43:00','',''),(2145641,'1','146','767',325,'Retail Sale Id 1271727',3200.00,0.00,0.00,0.00,240.00,'2021-12-03 17:50:52','',''),(2145642,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 17:50:52','',''),(2145647,'1','146','767',325,'Retail Sale Id 1271730',2003.20,0.00,0.00,0.00,150.24,'2021-12-03 17:51:43','',''),(2145648,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 17:51:43','',''),(2145787,'1','146','767',325,'Retail Sale Id 1271781',4000.00,0.00,0.00,0.00,300.00,'2021-12-03 18:09:55','',''),(2145788,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 18:09:55','',''),(2145959,'1','146','767',325,'Retail Sale Id 1271840',43200.00,0.00,0.00,0.00,3240.00,'2021-12-03 18:27:32','',''),(2145960,'1','146','767',325,'Retail sales',0.00,0.00,0.00,67.50,0.00,'2021-12-03 18:27:32','',''),(2145973,'1','146','767',325,'Retail Sale Id 1271847',1299.20,0.00,0.00,0.00,97.44,'2021-12-03 18:30:05','',''),(2145974,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-03 18:30:05','',''),(2146096,'1','146','767',325,'Retail Sale Id 1271907',13747.20,0.00,0.00,0.00,1031.04,'2021-12-03 19:20:35','',''),(2146097,'1','146','767',325,'Retail sales',0.00,0.00,0.00,21.48,0.00,'2021-12-03 19:20:35','',''),(2146528,'1','146','767',325,'Retail Sale Id 1271963',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 05:50:35','',''),(2146529,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 05:50:35','',''),(2148486,'1','146','767',325,'Retail Sale Id 1272914',13785.60,0.00,0.00,0.00,1033.92,'2021-12-04 07:48:28','',''),(2148487,'1','146','767',325,'Retail sales',0.00,0.00,0.00,21.54,0.00,'2021-12-04 07:48:28','',''),(2148640,'1','146',NULL,325,'Purchased from AA RANO NIGERIA LIMITED',0.00,79564.80,134.40,0.00,0.00,'2021-12-04 07:57:45','',''),(2148683,'1','146',NULL,325,'Reception corrector for bridging 126158',0.00,0.00,0.00,134.40,0.00,'2021-12-04 07:59:40','',''),(2148684,'1','146','767',325,'Received from bridging 126158',0.00,0.00,134.40,0.00,0.00,'2021-12-04 07:59:40','',''),(2148717,'1','146','767',325,'Retail Sale Id 1273049',86016.00,0.00,0.00,0.00,6451.20,'2021-12-04 08:00:59','',''),(2148718,'1','146','767',325,'Retail sales',0.00,0.00,0.00,134.40,0.00,'2021-12-04 08:00:59','',''),(2148847,'1','146',NULL,325,'Purchased from AA RANO NIGERIA LIMITED',0.00,1184000.00,2000.00,0.00,0.00,'2021-12-04 08:06:14','',''),(2148862,'1','146',NULL,325,'Reception corrector for bridging 126161',0.00,0.00,0.00,2000.00,0.00,'2021-12-04 08:07:07','',''),(2148863,'1','146','767',325,'Received from bridging 126161',0.00,0.00,2000.00,0.00,0.00,'2021-12-04 08:07:07','',''),(2148972,'1','146','767',325,'Retail Sale Id 1273196',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 08:12:14','',''),(2148973,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:12:14','',''),(2148986,'1','146','767',325,'Retail Sale Id 1273202',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 08:12:49','',''),(2148987,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:12:49','',''),(2149007,'1','146','767',325,'Retail Sale Id 1273211',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 08:13:26','',''),(2149008,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:13:26','',''),(2149026,'1','146','767',325,'Retail Sale Id 1273219',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 08:14:00','',''),(2149027,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:14:00','',''),(2149037,'1','146','767',325,'Retail Sale Id 1273224',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 08:14:41','',''),(2149038,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:14:41','',''),(2149060,'1','146','767',325,'Retail Sale Id 1273235',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 08:15:20','',''),(2149061,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 08:15:20','',''),(2149075,'1','146','767',325,'Retail Sale Id 1273241',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 08:15:59','',''),(2149076,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 08:15:59','',''),(2149090,'1','146','767',325,'Retail Sale Id 1273245',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 08:16:39','',''),(2149091,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 08:16:39','',''),(2149115,'1','146','767',325,'Retail Sale Id 1273258',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 08:17:28','',''),(2149116,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 08:17:28','',''),(2149127,'1','146','767',325,'Retail Sale Id 1273261',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 08:18:01','',''),(2149128,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 08:18:01','',''),(2149140,'1','146','767',325,'Retail Sale Id 1273268',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 08:18:39','',''),(2149141,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:18:39','',''),(2149148,'1','146','767',325,'Retail Sale Id 1273273',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 08:19:19','',''),(2149149,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:19:19','',''),(2149164,'1','146','767',325,'Retail Sale Id 1273286',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 08:19:54','',''),(2149165,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:19:54','',''),(2149392,'1','146','767',325,'Retail Sale Id 1273458',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 08:29:44','',''),(2149393,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:29:44','',''),(2149406,'1','146','767',325,'Retail Sale Id 1273464',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 08:30:22','',''),(2149407,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:30:22','',''),(2149434,'1','146','767',325,'Retail Sale Id 1273512',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 08:31:10','',''),(2149435,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:31:10','',''),(2149450,'1','146','767',325,'Retail Sale Id 1273520',6400.00,0.00,0.00,0.00,480.00,'2021-12-04 08:31:39','',''),(2149451,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 08:31:39','',''),(2149491,'1','146','767',325,'Retail Sale Id 1273527',6400.00,0.00,0.00,0.00,480.00,'2021-12-04 08:32:18','',''),(2149492,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 08:32:18','',''),(2149501,'1','146','767',325,'Retail Sale Id 1273532',16000.00,0.00,0.00,0.00,1200.00,'2021-12-04 08:32:55','',''),(2149502,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 08:32:55','',''),(2149696,'1','146','767',325,'Retail Sale Id 1273624',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 08:41:02','',''),(2149697,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 08:41:02','',''),(2149729,'1','146','767',325,'Retail Sale Id 1273636',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 08:42:20','',''),(2149730,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:42:20','',''),(2149758,'1','146','767',325,'Retail Sale Id 1273648',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 08:43:23','',''),(2149759,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:43:23','',''),(2149798,'1','146','767',325,'Retail Sale Id 1273672',1497.60,0.00,0.00,0.00,112.32,'2021-12-04 08:44:52','',''),(2149799,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 08:44:52','',''),(2149843,'1','146','767',325,'Retail Sale Id 1273697',32000.00,0.00,0.00,0.00,2400.00,'2021-12-04 08:46:33','',''),(2149844,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 08:46:33','',''),(2149886,'1','146','767',325,'Retail Sale Id 1273719',7001.60,0.00,0.00,0.00,525.12,'2021-12-04 08:48:18','',''),(2149887,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-04 08:48:18','',''),(2149906,'1','146','767',325,'Retail Sale Id 1273731',1299.20,0.00,0.00,0.00,97.44,'2021-12-04 08:49:34','',''),(2149907,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 08:49:34','',''),(2149938,'1','146','767',325,'Retail Sale Id 1273751',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 08:50:58','',''),(2149939,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:50:58','',''),(2149946,'1','146','767',325,'Retail Sale Id 1273755',12000.00,0.00,0.00,0.00,900.00,'2021-12-04 08:51:37','',''),(2149947,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-04 08:51:37','',''),(2149968,'1','146','767',325,'Retail Sale Id 1273768',32000.00,0.00,0.00,0.00,2400.00,'2021-12-04 08:52:38','',''),(2149969,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 08:52:38','',''),(2149988,'1','146','767',325,'Retail Sale Id 1273781',3500.80,0.00,0.00,0.00,262.56,'2021-12-04 08:53:28','',''),(2149989,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 08:53:28','',''),(2150016,'1','146','767',325,'Retail Sale Id 1273795',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 08:54:56','',''),(2150017,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:54:56','',''),(2150043,'1','146','767',325,'Retail Sale Id 1273806',12000.00,0.00,0.00,0.00,900.00,'2021-12-04 08:56:12','',''),(2150044,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-04 08:56:12','',''),(2150081,'1','146','767',325,'Retail Sale Id 1273827',12000.00,0.00,0.00,0.00,900.00,'2021-12-04 08:57:35','',''),(2150082,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-04 08:57:35','',''),(2150099,'1','146','767',325,'Retail Sale Id 1273837',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 08:58:39','',''),(2150100,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:58:39','',''),(2150134,'1','146','767',325,'Retail Sale Id 1273855',14099.20,0.00,0.00,0.00,1057.44,'2021-12-04 08:59:53','',''),(2150135,'1','146','767',325,'Retail sales',0.00,0.00,0.00,22.03,0.00,'2021-12-04 08:59:53','',''),(2150155,'1','146','767',325,'Retail Sale Id 1273864',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:01:08','',''),(2150156,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:01:08','',''),(2150171,'1','146','767',325,'Retail Sale Id 1273872',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:02:16','',''),(2150172,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:02:16','',''),(2150195,'1','146','767',325,'Retail Sale Id 1273886',499.20,0.00,0.00,0.00,37.44,'2021-12-04 09:03:16','',''),(2150196,'1','146','767',325,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-04 09:03:16','',''),(2150225,'1','146','767',325,'Retail Sale Id 1273909',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:04:24','',''),(2150226,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:04:24','',''),(2150243,'1','146','767',325,'Retail Sale Id 1273920',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 09:05:13','',''),(2150244,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 09:05:13','',''),(2150257,'1','146','767',325,'Retail Sale Id 1273926',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:05:47','',''),(2150258,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:05:47','',''),(2150272,'1','146','767',325,'Retail Sale Id 1273932',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:06:36','',''),(2150273,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:06:36','',''),(2150288,'1','146','767',325,'Retail Sale Id 1273942',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:07:27','',''),(2150289,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:07:27','',''),(2150303,'1','146','767',325,'Retail Sale Id 1273949',1299.20,0.00,0.00,0.00,97.44,'2021-12-04 09:08:26','',''),(2150304,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 09:08:26','',''),(2150315,'1','146','767',325,'Retail Sale Id 1273955',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 09:09:19','',''),(2150316,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 09:09:19','',''),(2150333,'1','146','767',325,'Retail Sale Id 1273965',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:10:14','',''),(2150334,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:10:14','',''),(2150347,'1','146','767',325,'Retail Sale Id 1273972',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:10:59','',''),(2150348,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:10:59','',''),(2150401,'1','146','767',325,'Retail Sale Id 1273995',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:13:36','',''),(2150402,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:13:36','',''),(2150413,'1','146','767',325,'Retail Sale Id 1274003',24000.00,0.00,0.00,0.00,1800.00,'2021-12-04 09:14:21','',''),(2150414,'1','146','767',325,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-04 09:14:21','',''),(2150439,'1','146','767',325,'Retail Sale Id 1274016',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:15:48','',''),(2150440,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:15:48','',''),(2150513,'1','146','767',325,'Retail Sale Id 1274058',11001.60,0.00,0.00,0.00,825.12,'2021-12-04 09:19:02','',''),(2150514,'1','146','767',325,'Retail sales',0.00,0.00,0.00,17.19,0.00,'2021-12-04 09:19:02','',''),(2150545,'1','146','767',325,'Retail Sale Id 1274073',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 09:20:22','',''),(2150546,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 09:20:22','',''),(2150571,'1','146','767',325,'Retail Sale Id 1274090',7001.60,0.00,0.00,0.00,525.12,'2021-12-04 09:21:31','',''),(2150572,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-04 09:21:31','',''),(2150828,'1','146','767',325,'Retail Sale Id 1274228',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 09:34:22','',''),(2150829,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:34:22','',''),(2152849,'1','146','767',325,'Retail Sale Id 1274495',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 10:58:04','',''),(2152850,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:58:04','',''),(2152859,'1','146','767',325,'Retail Sale Id 1274548',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 10:58:40','',''),(2152860,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:58:40','',''),(2153081,'1','146','767',325,'Retail Sale Id 1274343',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 11:10:15','',''),(2153082,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 11:10:15','',''),(2153099,'1','146','767',325,'Retail Sale Id 1274337',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 11:10:58','',''),(2153100,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:10:58','',''),(2153125,'1','146','767',325,'Retail Sale Id 1274678',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 11:12:12','',''),(2153126,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 11:12:12','',''),(2153155,'1','146','767',325,'Retail Sale Id 1274693',28000.00,0.00,0.00,0.00,2100.00,'2021-12-04 11:13:30','',''),(2153156,'1','146','767',325,'Retail sales',0.00,0.00,0.00,43.75,0.00,'2021-12-04 11:13:30','',''),(2153179,'1','146','767',325,'Retail Sale Id 1274285',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 11:15:07','',''),(2153181,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 11:15:07','',''),(2153197,'1','146','767',325,'Retail Sale Id 1274716',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 11:15:42','',''),(2153198,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 11:15:42','',''),(2153239,'1','146','767',325,'Retail Sale Id 1274265',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 11:17:20','',''),(2153240,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:17:20','',''),(2153251,'1','146','767',325,'Retail Sale Id 1274746',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 11:18:01','',''),(2153252,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 11:18:01','',''),(2153275,'1','146','767',325,'Retail Sale Id 1274756',6502.40,0.00,0.00,0.00,487.68,'2021-12-04 11:19:02','',''),(2153276,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-04 11:19:02','',''),(2153283,'1','146','767',325,'Retail Sale Id 1274763',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 11:19:43','',''),(2153284,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 11:19:43','',''),(2153291,'1','146','767',325,'Retail Sale Id 1274767',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 11:20:16','',''),(2153292,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 11:20:16','',''),(2153352,'1','146','767',325,'Retail Sale Id 1274794',6400.00,0.00,0.00,0.00,480.00,'2021-12-04 11:23:39','',''),(2153353,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 11:23:39','',''),(2153378,'1','146','767',325,'Return of Retail Sale Id 1274756',0.00,6502.40,10.16,0.00,-487.68,'2021-12-04 11:25:18','',''),(2153515,'1','146','767',325,'Retail Sale Id 1274882',25600.00,0.00,0.00,0.00,1920.00,'2021-12-04 11:32:35','',''),(2153516,'1','146','767',325,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-04 11:32:35','',''),(2153537,'1','146','767',325,'Retail Sale Id 1274894',10003.20,0.00,0.00,0.00,750.24,'2021-12-04 11:33:47','',''),(2153538,'1','146','767',325,'Retail sales',0.00,0.00,0.00,15.63,0.00,'2021-12-04 11:33:47','',''),(2153551,'1','146','767',325,'Return of Retail Sale Id 1274894',0.00,10003.20,15.63,0.00,-750.24,'2021-12-04 11:34:26','',''),(2153580,'1','146','767',325,'Retail Sale Id 1274913',25600.00,0.00,0.00,0.00,1920.00,'2021-12-04 11:35:57','',''),(2153581,'1','146','767',325,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-04 11:35:57','',''),(2153753,'1','146','767',325,'Retail Sale Id 1274986',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 11:44:57','',''),(2153754,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:44:57','',''),(2153793,'1','146','767',325,'Retail Sale Id 1275004',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 11:47:15','',''),(2153794,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:47:15','',''),(2153842,'1','146','767',325,'Retail Sale Id 1275024',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 11:50:14','',''),(2153843,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 11:50:14','',''),(2153871,'1','146','767',325,'Retail Sale Id 1275033',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 11:51:32','',''),(2153872,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:51:32','',''),(2153885,'1','146','767',325,'Retail Sale Id 1275039',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 11:52:21','',''),(2153886,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:52:21','',''),(2153905,'1','146','767',325,'Retail Sale Id 1275051',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 11:53:43','',''),(2153906,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:53:43','',''),(2154353,'1','146','767',325,'Retail Sale Id 1275211',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 12:15:11','',''),(2154354,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:15:11','',''),(2154367,'1','146','767',325,'Retail Sale Id 1275216',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 12:16:01','',''),(2154368,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:16:01','',''),(2154439,'1','146','767',325,'Retail Sale Id 1275256',6003.20,0.00,0.00,0.00,450.24,'2021-12-04 12:22:02','',''),(2154440,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-04 12:22:02','',''),(2154485,'1','146','767',325,'Retail Sale Id 1275280',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 12:25:18','',''),(2154486,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 12:25:18','',''),(2154537,'1','146','767',325,'Retail Sale Id 1275303',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 12:27:36','',''),(2154538,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 12:27:36','',''),(2154653,'1','146','767',325,'Retail Sale Id 1275358',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 12:33:34','',''),(2154654,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:33:34','',''),(2154689,'1','146','767',325,'Retail Sale Id 1275378',6502.40,0.00,0.00,0.00,487.68,'2021-12-04 12:36:17','',''),(2154690,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-04 12:36:17','',''),(2154711,'1','146','767',325,'Retail Sale Id 1275385',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 12:37:21','',''),(2154712,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:37:21','',''),(2154743,'1','146','767',325,'Retail Sale Id 1275405',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 12:39:33','',''),(2154744,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:39:33','',''),(2154762,'1','146','767',325,'Retail Sale Id 1275415',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 12:40:40','',''),(2154763,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 12:40:40','',''),(2154770,'1','146','767',325,'Retail Sale Id 1275418',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 12:41:25','',''),(2154771,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 12:41:25','',''),(2154834,'1','146','767',325,'Retail Sale Id 1275451',12000.00,0.00,0.00,0.00,900.00,'2021-12-04 12:47:20','',''),(2154835,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-04 12:47:20','',''),(2154917,'1','146','767',325,'Retail Sale Id 1275481',32000.00,0.00,0.00,0.00,2400.00,'2021-12-04 12:51:59','',''),(2154918,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 12:51:59','',''),(2154958,'1','146','767',325,'Retail Sale Id 1275496',16000.00,0.00,0.00,0.00,1200.00,'2021-12-04 12:54:06','',''),(2154959,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 12:54:06','',''),(2154974,'1','146','767',325,'Retail Sale Id 1275508',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 12:55:07','',''),(2154975,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:55:07','',''),(2154982,'1','146','767',325,'Retail Sale Id 1275511',998.40,0.00,0.00,0.00,74.88,'2021-12-04 12:55:51','',''),(2154983,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 12:55:51','',''),(2155042,'1','146','767',325,'Retail Sale Id 1275751',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 13:06:34','',''),(2155043,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 13:06:34','',''),(2155109,'1','146','767',325,'Retail Sale Id 1275731',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 13:11:05','',''),(2155110,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:11:05','',''),(2155138,'1','146','767',325,'Retail Sale Id 1275799',6400.00,0.00,0.00,0.00,480.00,'2021-12-04 13:12:26','',''),(2155139,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 13:12:26','',''),(2155163,'1','146','767',325,'Retail Sale Id 1275727',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 13:14:04','',''),(2155164,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:14:04','',''),(2155178,'1','146','767',325,'Retail Sale Id 1275821',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 13:15:00','',''),(2155179,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 13:15:00','',''),(2155204,'1','146','767',325,'Retail Sale Id 1275833',8998.40,0.00,0.00,0.00,674.88,'2021-12-04 13:16:26','',''),(2155205,'1','146','767',325,'Retail sales',0.00,0.00,0.00,14.06,0.00,'2021-12-04 13:16:26','',''),(2155233,'1','146','767',325,'Retail Sale Id 1275840',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 13:18:46','',''),(2155234,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 13:18:46','',''),(2155283,'1','146','767',325,'Retail Sale Id 1275858',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 13:21:12','',''),(2155284,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 13:21:12','',''),(2155298,'1','146','767',325,'Retail Sale Id 1275864',32000.00,0.00,0.00,0.00,2400.00,'2021-12-04 13:22:11','',''),(2155299,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 13:22:11','',''),(2155307,'1','146','767',325,'Retail Sale Id 1275872',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 13:22:42','',''),(2155308,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:22:42','',''),(2155372,'1','146','767',325,'Retail Sale Id 1275888',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 13:25:23','',''),(2155373,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:25:23','',''),(2155392,'1','146','767',325,'Retail Sale Id 1275899',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 13:26:27','',''),(2155393,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 13:26:27','',''),(2155432,'1','146','767',325,'Retail Sale Id 1275903',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 13:27:04','',''),(2155433,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 13:27:04','',''),(2155488,'1','146','767',325,'Retail Sale Id 1275930',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 13:30:12','',''),(2155489,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:30:12','',''),(2155498,'1','146','767',325,'Retail Sale Id 1275937',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 13:31:02','',''),(2155499,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:31:02','',''),(2155514,'1','146','767',325,'Retail Sale Id 1275943',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 13:31:38','',''),(2155515,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 13:31:38','',''),(2155588,'1','146','767',325,'Retail Sale Id 1275948',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 13:35:57','',''),(2155589,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:35:58','',''),(2155914,'1','146','767',325,'Retail Sale Id 1275981',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 13:52:39','',''),(2155915,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 13:52:39','',''),(2155984,'1','146','767',325,'Retail Sale Id 1276165',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 13:56:50','',''),(2155985,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 13:56:50','',''),(2156259,'1','146','767',325,'Retail Sale Id 1276274',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 14:07:07','',''),(2156260,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:07:07','',''),(2157157,'1','146','767',325,'Retail Sale Id 1276484',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 14:53:15','',''),(2157158,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:53:15','',''),(2158335,'1','146',NULL,325,'Purchased from AA RANO NIGERIA LIMITED',0.00,1835200.00,3100.00,0.00,0.00,'2021-12-04 15:50:02','',''),(2158368,'1','146',NULL,325,'Reception corrector for bridging 126222',0.00,0.00,0.00,3100.00,0.00,'2021-12-04 15:51:36','',''),(2158369,'1','146','767',325,'Received from bridging 126222',0.00,0.00,3100.00,0.00,0.00,'2021-12-04 15:51:36','',''),(2158454,'1','146','767',325,'Retail Sale Id 1277264',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 15:55:57','',''),(2158455,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:55:57','',''),(2158498,'1','146','767',325,'Retail Sale Id 1277291',6400.00,0.00,0.00,0.00,480.00,'2021-12-04 15:57:46','',''),(2158499,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 15:57:46','',''),(2158551,'1','146','767',325,'Retail Sale Id 1277323',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 16:00:26','',''),(2158552,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 16:00:26','',''),(2158589,'1','146','767',325,'Retail Sale Id 1277343',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:02:10','',''),(2158590,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:02:10','',''),(2158616,'1','146','767',325,'Retail Sale Id 1277353',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 16:03:28','',''),(2158617,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 16:03:28','',''),(2158692,'1','146','767',325,'Retail Sale Id 1277394',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 16:07:45','',''),(2158693,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 16:07:45','',''),(2158706,'1','146','767',325,'Retail Sale Id 1277400',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 16:08:26','',''),(2158707,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 16:08:26','',''),(2158726,'1','146','767',325,'Retail Sale Id 1277411',5203.20,0.00,0.00,0.00,390.24,'2021-12-04 16:09:16','',''),(2158727,'1','146','767',325,'Retail sales',0.00,0.00,0.00,8.13,0.00,'2021-12-04 16:09:16','',''),(2158833,'1','146','767',325,'Retail Sale Id 1277468',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 16:14:06','',''),(2158834,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 16:14:06','',''),(2158865,'1','146','767',325,'Retail Sale Id 1277485',4998.40,0.00,0.00,0.00,374.88,'2021-12-04 16:15:26','',''),(2158866,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 16:15:26','',''),(2158913,'1','146','767',325,'Retail Sale Id 1277513',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 16:17:42','',''),(2158914,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:17:42','',''),(2159011,'1','146','767',325,'Retail Sale Id 1277557',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:22:17','',''),(2159012,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:22:17','',''),(2159033,'1','146','767',325,'Retail Sale Id 1277570',2598.40,0.00,0.00,0.00,194.88,'2021-12-04 16:23:23','',''),(2159034,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-04 16:23:23','',''),(2159049,'1','146','767',325,'Retail Sale Id 1277585',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:23:59','',''),(2159050,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:23:59','',''),(2159065,'1','146','767',325,'Retail Sale Id 1277591',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 16:24:47','',''),(2159066,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 16:24:47','',''),(2159081,'1','146','767',325,'Retail Sale Id 1277599',7001.60,0.00,0.00,0.00,525.12,'2021-12-04 16:25:34','',''),(2159082,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-04 16:25:34','',''),(2159101,'1','146','767',325,'Retail Sale Id 1277611',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 16:26:17','',''),(2159102,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 16:26:17','',''),(2159119,'1','146','767',325,'Retail Sale Id 1277620',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 16:27:12','',''),(2159120,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 16:27:12','',''),(2159145,'1','146','767',325,'Retail Sale Id 1277632',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 16:27:58','',''),(2159146,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 16:27:58','',''),(2159167,'1','146','767',325,'Retail Sale Id 1277644',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:28:44','',''),(2159168,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:28:44','',''),(2159183,'1','146','767',325,'Retail Sale Id 1277652',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:29:49','',''),(2159184,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:29:49','',''),(2159207,'1','146','767',325,'Retail Sale Id 1277666',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 16:30:47','',''),(2159208,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 16:30:47','',''),(2159227,'1','146','767',325,'Retail Sale Id 1277675',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 16:31:47','',''),(2159228,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:31:47','',''),(2159307,'1','146','767',325,'Retail Sale Id 1277713',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 16:36:33','',''),(2159308,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 16:36:33','',''),(2159393,'1','146','767',325,'Retail Sale Id 1277743',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 16:39:02','',''),(2159394,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 16:39:02','',''),(2159419,'1','146','767',325,'Retail Sale Id 1277750',2502.40,0.00,0.00,0.00,187.68,'2021-12-04 16:39:55','',''),(2159420,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 16:39:55','',''),(2159451,'1','146','767',325,'Retail Sale Id 1277763',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 16:41:07','',''),(2159452,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 16:41:07','',''),(2159477,'1','146','767',325,'Retail Sale Id 1277776',12000.00,0.00,0.00,0.00,900.00,'2021-12-04 16:42:16','',''),(2159478,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-04 16:42:16','',''),(2159491,'1','146','767',325,'Retail Sale Id 1277809',3500.80,0.00,0.00,0.00,262.56,'2021-12-04 16:44:15','',''),(2159492,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-04 16:44:15','',''),(2159517,'1','146','767',325,'Retail Sale Id 1277838',6003.20,0.00,0.00,0.00,450.24,'2021-12-04 16:45:00','',''),(2159518,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-04 16:45:00','',''),(2159529,'1','146','767',325,'Retail Sale Id 1277848',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:45:52','',''),(2159530,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:45:52','',''),(2159589,'1','146','767',325,'Retail Sale Id 1277872',28800.00,0.00,0.00,0.00,2160.00,'2021-12-04 16:48:28','',''),(2159590,'1','146','767',325,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-04 16:48:28','',''),(2159622,'1','146','767',325,'Retail Sale Id 1277887',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:49:54','',''),(2159623,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:49:54','',''),(2159638,'1','146','767',325,'Retail Sale Id 1277892',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:50:23','',''),(2159639,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:50:23','',''),(2159676,'1','146','767',325,'Retail Sale Id 1277911',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 16:52:19','',''),(2159677,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 16:52:19','',''),(2159688,'1','146','767',325,'Retail Sale Id 1277917',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:53:00','',''),(2159689,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:53:00','',''),(2159783,'1','146','767',325,'Retail Sale Id 1277966',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 16:58:48','',''),(2159784,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:58:48','',''),(2159857,'1','146','767',325,'Retail Sale Id 1278001',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 17:02:42','',''),(2159858,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 17:02:42','',''),(2159942,'1','146','767',325,'Retail Sale Id 1278044',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 17:08:18','',''),(2159943,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 17:08:18','',''),(2159963,'1','146','767',325,'Retail Sale Id 1278056',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 17:09:53','',''),(2159964,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 17:09:53','',''),(2160087,'1','146','767',325,'Retail Sale Id 1278114',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 17:17:46','',''),(2160088,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 17:17:46','',''),(2160107,'1','146','767',325,'Retail Sale Id 1278124',4000.00,0.00,0.00,0.00,300.00,'2021-12-04 17:18:55','',''),(2160108,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 17:18:55','',''),(2160115,'1','146','767',325,'Retail Sale Id 1278128',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 17:19:59','',''),(2160116,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 17:19:59','',''),(2160139,'1','146','767',325,'Retail Sale Id 1278142',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 17:21:15','',''),(2160140,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 17:21:15','',''),(2160165,'1','146','767',325,'Retail Sale Id 1278150',32000.00,0.00,0.00,0.00,2400.00,'2021-12-04 17:22:02','',''),(2160166,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 17:22:02','',''),(2160183,'1','146','767',325,'Retail Sale Id 1278160',14003.20,0.00,0.00,0.00,1050.24,'2021-12-04 17:23:05','',''),(2160184,'1','146','767',325,'Retail sales',0.00,0.00,0.00,21.88,0.00,'2021-12-04 17:23:05','',''),(2160195,'1','146','767',325,'Retail Sale Id 1278166',9600.00,0.00,0.00,0.00,720.00,'2021-12-04 17:23:57','',''),(2160196,'1','146','767',325,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-04 17:23:57','',''),(2160311,'1','146','767',325,'Retail Sale Id 1278204',2003.20,0.00,0.00,0.00,150.24,'2021-12-04 17:29:51','',''),(2160312,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 17:29:51','',''),(2160321,'1','146','767',325,'Retail Sale Id 1278212',20000.00,0.00,0.00,0.00,1500.00,'2021-12-04 17:30:40','',''),(2160322,'1','146','767',325,'Retail sales',0.00,0.00,0.00,31.25,0.00,'2021-12-04 17:30:40','',''),(2160323,'1','146','767',325,'Retail Sale Id 1278214',3001.60,0.00,0.00,0.00,225.12,'2021-12-04 17:31:23','',''),(2160324,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 17:31:23','',''),(2160697,'1','146','767',325,'Retail Sale Id 1278339',4998.40,0.00,0.00,0.00,374.88,'2021-12-04 17:52:26','',''),(2160698,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 17:52:26','',''),(2160752,'1','146','767',325,'Retail Sale Id 1278366',6400.00,0.00,0.00,0.00,480.00,'2021-12-04 17:57:36','',''),(2160753,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 17:57:36','',''),(2160817,'1','146','767',325,'Retail Sale Id 1278397',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 18:05:08','',''),(2160818,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 18:05:08','',''),(2160859,'1','146','767',325,'Retail Sale Id 1278419',8000.00,0.00,0.00,0.00,600.00,'2021-12-04 18:09:24','',''),(2160860,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 18:09:24','',''),(2161018,'1','146','767',325,'Retail Sale Id 1278498',3200.00,0.00,0.00,0.00,240.00,'2021-12-04 18:36:20','',''),(2161019,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 18:36:20','',''),(2161099,'1','146','767',325,'Retail Sale Id 1278524',12000.00,0.00,0.00,0.00,900.00,'2021-12-04 18:51:11','',''),(2161100,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-04 18:51:11','',''),(2161255,'1','146','767',325,'Retail Sale Id 1278567',499801.60,0.00,0.00,0.00,37485.12,'2021-12-04 19:26:25','',''),(2161256,'1','146','767',325,'Retail sales',0.00,0.00,0.00,780.94,0.00,'2021-12-04 19:26:25','',''),(2161888,'1','146','767',325,'Retail Sale Id 1278597',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 05:42:56','',''),(2161889,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 05:42:56','',''),(2161890,'1','146','767',325,'Retail Sale Id 1278598',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 05:44:24','',''),(2161891,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 05:44:24','',''),(2161909,'1','146','767',325,'Retail Sale Id 1278600',998.40,0.00,0.00,0.00,74.88,'2021-12-05 05:49:04','',''),(2161910,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 05:49:04','',''),(2161915,'1','146','767',325,'Retail Sale Id 1278602',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 05:50:38','',''),(2161916,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 05:50:38','',''),(2161925,'1','146','767',325,'Retail Sale Id 1278604',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 05:51:45','',''),(2161926,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 05:51:45','',''),(2161931,'1','146','767',325,'Retail Sale Id 1278606',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 05:52:58','',''),(2161932,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 05:52:58','',''),(2161933,'1','146','767',325,'Retail Sale Id 1278607',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 05:54:15','',''),(2161934,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 05:54:15','',''),(2161943,'1','146','767',325,'Retail Sale Id 1278611',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 05:57:55','',''),(2161944,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 05:57:55','',''),(2161955,'1','146','767',325,'Retail Sale Id 1278618',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 06:00:00','',''),(2161956,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 06:00:00','',''),(2161985,'1','146','767',325,'Retail Sale Id 1278641',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 06:04:23','',''),(2161986,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 06:04:23','',''),(2162008,'1','146','767',325,'Retail Sale Id 1278644',2502.40,0.00,0.00,0.00,187.68,'2021-12-05 06:05:41','',''),(2162009,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 06:05:41','',''),(2162038,'1','146','767',325,'Retail Sale Id 1278657',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 06:10:19','',''),(2162039,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 06:10:19','',''),(2162056,'1','146','767',325,'Retail Sale Id 1278665',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 06:12:12','',''),(2162057,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 06:12:12','',''),(2162068,'1','146','767',325,'Retail Sale Id 1278671',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 06:13:34','',''),(2162069,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 06:13:34','',''),(2162078,'1','146','767',325,'Retail Sale Id 1278676',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 06:14:40','',''),(2162079,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 06:14:40','',''),(2162088,'1','146','767',325,'Retail Sale Id 1278681',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 06:15:42','',''),(2162089,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 06:15:42','',''),(2162095,'1','146','767',325,'Retail Sale Id 1278684',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 06:17:32','',''),(2162096,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 06:17:32','',''),(2162149,'1','146','767',325,'Retail Sale Id 1278709',32000.00,0.00,0.00,0.00,2400.00,'2021-12-05 06:23:11','',''),(2162150,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 06:23:11','',''),(2162170,'1','146','767',325,'Retail Sale Id 1278722',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 06:25:22','',''),(2162171,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 06:25:22','',''),(2162308,'1','146','767',325,'Retail Sale Id 1278781',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 06:37:19','',''),(2162309,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 06:37:19','',''),(2162346,'1','146','767',325,'Retail Sale Id 1278802',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 06:40:05','',''),(2162347,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 06:40:05','',''),(2162360,'1','146','767',325,'Retail Sale Id 1278812',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 06:41:04','',''),(2162361,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 06:41:04','',''),(2162380,'1','146','767',325,'Retail Sale Id 1278822',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 06:42:37','',''),(2162381,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 06:42:37','',''),(2162398,'1','146','767',325,'Retail Sale Id 1278827',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 06:43:43','',''),(2162399,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 06:43:43','',''),(2162492,'1','146','767',325,'Retail Sale Id 1278858',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 06:47:52','',''),(2162493,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 06:47:52','',''),(2162522,'1','146','767',325,'Retail Sale Id 1278874',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 06:49:45','',''),(2162523,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 06:49:45','',''),(2162547,'1','146','767',325,'Retail Sale Id 1278884',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 06:50:45','',''),(2162548,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 06:50:45','',''),(2162575,'1','146','767',325,'Retail Sale Id 1278897',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 06:52:07','',''),(2162576,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 06:52:07','',''),(2162679,'1','146','767',325,'Retail Sale Id 1278954',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 06:57:56','',''),(2162680,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 06:57:56','',''),(2162702,'1','146','767',325,'Retail Sale Id 1278968',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 06:59:33','',''),(2162703,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 06:59:33','',''),(2162740,'1','146','767',325,'Retail Sale Id 1278988',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 07:01:59','',''),(2162741,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 07:01:59','',''),(2162797,'1','146','767',325,'Retail Sale Id 1279006',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 07:04:54','',''),(2162798,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:04:54','',''),(2162835,'1','146','767',325,'Retail Sale Id 1279033',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 07:06:47','',''),(2162836,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:06:47','',''),(2162855,'1','146','767',325,'Retail Sale Id 1279044',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 07:08:06','',''),(2162856,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 07:08:06','',''),(2162887,'1','146','767',325,'Retail Sale Id 1279063',697.60,0.00,0.00,0.00,52.32,'2021-12-05 07:09:30','',''),(2162888,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-05 07:09:30','',''),(2162903,'1','146','767',325,'Retail Sale Id 1279072',998.40,0.00,0.00,0.00,74.88,'2021-12-05 07:10:35','',''),(2162904,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 07:10:35','',''),(2162937,'1','146','767',325,'Retail Sale Id 1279092',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 07:12:34','',''),(2162938,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:12:34','',''),(2162977,'1','146','767',325,'Retail Sale Id 1279111',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 07:14:42','',''),(2162978,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 07:14:42','',''),(2163030,'1','146','767',325,'Retail Sale Id 1279140',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 07:17:53','',''),(2163031,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 07:17:53','',''),(2163076,'1','146','767',325,'Retail Sale Id 1279157',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 07:20:33','',''),(2163077,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 07:20:33','',''),(2163098,'1','146','767',325,'Retail Sale Id 1279180',998.40,0.00,0.00,0.00,74.88,'2021-12-05 07:22:37','',''),(2163099,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 07:22:37','',''),(2163118,'1','146','767',325,'Retail Sale Id 1279213',3500.80,0.00,0.00,0.00,262.56,'2021-12-05 07:24:03','',''),(2163119,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-05 07:24:03','',''),(2163161,'1','146','767',325,'Retail Sale Id 1279237',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 07:26:03','',''),(2163162,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:26:03','',''),(2163191,'1','146','767',325,'Retail Sale Id 1279257',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 07:27:24','',''),(2163192,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 07:27:24','',''),(2163219,'1','146','767',325,'Retail Sale Id 1279275',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 07:28:37','',''),(2163220,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 07:28:37','',''),(2163376,'1','146','767',325,'Retail Sale Id 1279381',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 07:39:18','',''),(2163377,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:39:18','',''),(2163421,'1','146','767',325,'Retail Sale Id 1279395',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 07:40:46','',''),(2163422,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 07:40:46','',''),(2163598,'1','146','767',325,'Retail Sale Id 1279483',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 07:51:06','',''),(2163599,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 07:51:06','',''),(2163639,'1','146','767',325,'Retail Sale Id 1279498',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 07:52:43','',''),(2163640,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:52:43','',''),(2163683,'1','146','767',325,'Retail Sale Id 1279528',3500.80,0.00,0.00,0.00,262.56,'2021-12-05 07:55:28','',''),(2163684,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-05 07:55:28','',''),(2163806,'1','146','767',325,'Retail Sale Id 1279588',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 08:02:25','',''),(2163807,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:02:25','',''),(2163834,'1','146','767',325,'Retail Sale Id 1279607',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 08:03:56','',''),(2163835,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:03:56','',''),(2163860,'1','146','767',325,'Retail Sale Id 1279624',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 08:05:22','',''),(2163861,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:05:22','',''),(2163892,'1','146','767',325,'Retail Sale Id 1279643',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 08:06:55','',''),(2163893,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:06:55','',''),(2163912,'1','146','767',325,'Retail Sale Id 1279663',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 08:08:02','',''),(2163913,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:08:02','',''),(2163964,'1','146','767',325,'Retail Sale Id 1279684',14003.20,0.00,0.00,0.00,1050.24,'2021-12-05 08:09:55','',''),(2163965,'1','146','767',325,'Retail sales',0.00,0.00,0.00,21.88,0.00,'2021-12-05 08:09:55','',''),(2164014,'1','146','767',325,'Retail Sale Id 1279722',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 08:13:03','',''),(2164015,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 08:13:03','',''),(2164040,'1','146','767',325,'Retail Sale Id 1279737',6400.00,0.00,0.00,0.00,480.00,'2021-12-05 08:14:38','',''),(2164041,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 08:14:38','',''),(2164066,'1','146','767',325,'Retail Sale Id 1279753',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 08:16:11','',''),(2164067,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 08:16:11','',''),(2164102,'1','146','767',325,'Retail Sale Id 1279771',30003.20,0.00,0.00,0.00,2250.24,'2021-12-05 08:18:10','',''),(2164103,'1','146','767',325,'Retail sales',0.00,0.00,0.00,46.88,0.00,'2021-12-05 08:18:10','',''),(2164156,'1','146','767',325,'Retail Sale Id 1279793',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 08:20:19','',''),(2164157,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:20:19','',''),(2164176,'1','146','767',325,'Retail Sale Id 1279805',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 08:21:18','',''),(2164177,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:21:18','',''),(2164206,'1','146','767',325,'Retail Sale Id 1279822',7001.60,0.00,0.00,0.00,525.12,'2021-12-05 08:22:41','',''),(2164207,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-05 08:22:41','',''),(2164288,'1','146','767',325,'Retail Sale Id 1279855',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 08:25:41','',''),(2164290,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:25:41','',''),(2164416,'1','146','767',325,'Retail Sale Id 1279929',12000.00,0.00,0.00,0.00,900.00,'2021-12-05 08:32:05','',''),(2164417,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-05 08:32:05','',''),(2164444,'1','146','767',325,'Retail Sale Id 1279944',998.40,0.00,0.00,0.00,74.88,'2021-12-05 08:33:05','',''),(2164445,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 08:33:05','',''),(2164482,'1','146','767',325,'Retail Sale Id 1279969',998.40,0.00,0.00,0.00,74.88,'2021-12-05 08:35:18','',''),(2164483,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 08:35:18','',''),(2164510,'1','146','767',325,'Retail Sale Id 1279983',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 08:36:45','',''),(2164511,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 08:36:45','',''),(2164580,'1','146','767',325,'Retail Sale Id 1280018',6400.00,0.00,0.00,0.00,480.00,'2021-12-05 08:41:27','',''),(2164581,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 08:41:27','',''),(2164614,'1','146','767',325,'Retail Sale Id 1280031',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 08:42:43','',''),(2164615,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 08:42:43','',''),(2164636,'1','146','767',325,'Retail Sale Id 1280037',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 08:43:49','',''),(2164637,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 08:43:49','',''),(2164725,'1','146','767',325,'Retail Sale Id 1280075',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 08:48:21','',''),(2164726,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:48:21','',''),(2164769,'1','146','767',325,'Retail Sale Id 1280100',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 08:50:51','',''),(2164770,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:50:51','',''),(2164819,'1','146','767',325,'Retail Sale Id 1280127',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 08:53:36','',''),(2164820,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:53:36','',''),(2164839,'1','146','767',325,'Retail Sale Id 1280139',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 08:54:35','',''),(2164840,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:54:35','',''),(2164866,'1','146','767',325,'Retail Sale Id 1280163',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 08:56:42','',''),(2164867,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 08:56:42','',''),(2164900,'1','146','767',325,'Retail Sale Id 1280177',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 08:58:16','',''),(2164901,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:58:16','',''),(2164924,'1','146','767',325,'Retail Sale Id 1280188',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 08:59:43','',''),(2164925,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:59:43','',''),(2164947,'1','146','767',325,'Retail Sale Id 1280200',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 09:01:00','',''),(2164948,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 09:01:00','',''),(2164965,'1','146','767',325,'Retail Sale Id 1280208',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 09:02:08','',''),(2164966,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 09:02:08','',''),(2165001,'1','146','767',325,'Retail Sale Id 1280225',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 09:03:57','',''),(2165002,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 09:03:57','',''),(2165029,'1','146','767',325,'Retail Sale Id 1280241',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 09:05:32','',''),(2165030,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:05:32','',''),(2165057,'1','146','767',325,'Retail Sale Id 1280258',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 09:07:03','',''),(2165058,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 09:07:03','',''),(2165089,'1','146','767',325,'Retail Sale Id 1280275',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 09:08:26','',''),(2165090,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:08:26','',''),(2165179,'1','146','767',325,'Retail Sale Id 1280322',80000.00,0.00,0.00,0.00,6000.00,'2021-12-05 09:12:26','',''),(2165180,'1','146','767',325,'Retail sales',0.00,0.00,0.00,125.00,0.00,'2021-12-05 09:12:26','',''),(2165221,'1','146','767',325,'Retail Sale Id 1280347',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 09:14:30','',''),(2165222,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:14:30','',''),(2165246,'1','146','767',325,'Retail Sale Id 1280372',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 09:17:13','',''),(2165247,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:17:13','',''),(2165272,'1','146','767',325,'Retail Sale Id 1280400',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 09:18:29','',''),(2165273,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 09:18:29','',''),(2165300,'1','146','767',325,'Retail Sale Id 1280415',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 09:20:09','',''),(2165301,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 09:20:09','',''),(2165376,'1','146','767',325,'Retail Sale Id 1280456',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 09:24:55','',''),(2165377,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:24:55','',''),(2165402,'1','146','767',325,'Retail Sale Id 1280474',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 09:26:03','',''),(2165403,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 09:26:03','',''),(2165434,'1','146','767',325,'Retail Sale Id 1280492',5120.00,0.00,0.00,0.00,384.00,'2021-12-05 09:27:40','',''),(2165435,'1','146','767',325,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 09:27:40','',''),(2165454,'1','146','767',325,'Retail Sale Id 1280504',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 09:28:53','',''),(2165455,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 09:28:53','',''),(2165488,'1','146','767',325,'Retail Sale Id 1280522',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 09:30:32','',''),(2165489,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 09:30:32','',''),(2165520,'1','146','767',325,'Retail Sale Id 1280544',16000.00,0.00,0.00,0.00,1200.00,'2021-12-05 09:32:01','',''),(2165521,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 09:32:01','',''),(2165550,'1','146','767',325,'Retail Sale Id 1280559',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 09:33:18','',''),(2165551,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 09:33:18','',''),(2165570,'1','146','767',325,'Retail Sale Id 1280569',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 09:34:45','',''),(2165572,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 09:34:45','',''),(2165590,'1','146','767',325,'Retail Sale Id 1280579',6003.20,0.00,0.00,0.00,450.24,'2021-12-05 09:36:01','',''),(2165591,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-05 09:36:01','',''),(2165622,'1','146','767',325,'Retail Sale Id 1280597',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 09:37:32','',''),(2165623,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 09:37:32','',''),(2165660,'1','146','767',325,'Retail Sale Id 1280618',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 09:39:40','',''),(2165661,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:39:40','',''),(2165696,'1','146','767',325,'Retail Sale Id 1280631',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 09:41:12','',''),(2165697,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:41:12','',''),(2165746,'1','146','767',325,'Retail Sale Id 1280658',16000.00,0.00,0.00,0.00,1200.00,'2021-12-05 09:43:21','',''),(2165747,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 09:43:21','',''),(2165913,'1','146','767',325,'Retail Sale Id 1280712',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 09:48:23','',''),(2165914,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 09:48:23','',''),(2165961,'1','146','767',325,'Retail Sale Id 1280735',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 09:51:20','',''),(2165962,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:51:20','',''),(2165985,'1','146','767',325,'Retail Sale Id 1280749',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 09:53:08','',''),(2165986,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 09:53:08','',''),(2166049,'1','146','767',325,'Retail Sale Id 1280780',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 09:56:19','',''),(2166050,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 09:56:19','',''),(2166112,'1','146','767',325,'Retail Sale Id 1280812',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 10:00:04','',''),(2166113,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 10:00:04','',''),(2166138,'1','146','767',325,'Retail Sale Id 1280830',1299.20,0.00,0.00,0.00,97.44,'2021-12-05 10:01:44','',''),(2166139,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-05 10:01:44','',''),(2166187,'1','146','767',325,'Retail Sale Id 1280854',28000.00,0.00,0.00,0.00,2100.00,'2021-12-05 10:04:56','',''),(2166188,'1','146','767',325,'Retail sales',0.00,0.00,0.00,43.75,0.00,'2021-12-05 10:04:56','',''),(2166215,'1','146','767',325,'Retail Sale Id 1280870',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 10:07:30','',''),(2166216,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:07:30','',''),(2166269,'1','146','767',325,'Retail Sale Id 1280894',32000.00,0.00,0.00,0.00,2400.00,'2021-12-05 10:10:46','',''),(2166270,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 10:10:46','',''),(2166301,'1','146','767',325,'Retail Sale Id 1280913',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 10:13:06','',''),(2166302,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 10:13:06','',''),(2166329,'1','146','767',325,'Retail Sale Id 1280925',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 10:14:41','',''),(2166330,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 10:14:41','',''),(2166351,'1','146','767',325,'Retail Sale Id 1280940',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 10:16:24','',''),(2166352,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 10:16:24','',''),(2166385,'1','146','767',325,'Retail Sale Id 1280957',6400.00,0.00,0.00,0.00,480.00,'2021-12-05 10:18:31','',''),(2166386,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 10:18:31','',''),(2166407,'1','146','767',325,'Retail Sale Id 1280968',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 10:19:55','',''),(2166408,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:19:55','',''),(2166429,'1','146','767',325,'Retail Sale Id 1280980',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 10:21:16','',''),(2166430,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 10:21:16','',''),(2166471,'1','146','767',325,'Retail Sale Id 1280999',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 10:24:08','',''),(2166472,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 10:24:08','',''),(2166494,'1','146','767',325,'Retail Sale Id 1281011',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 10:25:45','',''),(2166495,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:25:45','',''),(2166526,'1','146','767',325,'Retail Sale Id 1281026',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 10:27:27','',''),(2166527,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 10:27:27','',''),(2166552,'1','146','767',325,'Retail Sale Id 1281040',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 10:28:51','',''),(2166553,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 10:28:51','',''),(2166570,'1','146','767',325,'Retail Sale Id 1281048',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 10:30:00','',''),(2166571,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 10:30:00','',''),(2166754,'1','146','767',325,'Retail Sale Id 1281066',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 10:41:16','',''),(2166755,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:41:16','',''),(2166762,'1','146','767',325,'Retail Sale Id 1281149',6003.20,0.00,0.00,0.00,450.24,'2021-12-05 10:42:13','',''),(2166763,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-05 10:42:13','',''),(2166780,'1','146','767',325,'Retail Sale Id 1281157',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 10:43:33','',''),(2166781,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 10:43:33','',''),(2166991,'1','146','767',325,'Retail Sale Id 1281271',2252.80,0.00,0.00,0.00,168.96,'2021-12-05 10:53:46','',''),(2166992,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.52,0.00,'2021-12-05 10:53:46','',''),(2167655,'1','146','767',325,'Retail Sale Id 1281612',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 11:32:10','',''),(2167656,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 11:32:10','',''),(2167693,'1','146','767',325,'Retail Sale Id 1281626',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 11:33:38','',''),(2167694,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:33:38','',''),(2167705,'1','146','767',325,'Retail Sale Id 1281632',7001.60,0.00,0.00,0.00,525.12,'2021-12-05 11:34:43','',''),(2167706,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-05 11:34:43','',''),(2167719,'1','146','767',325,'Retail Sale Id 1281640',7001.60,0.00,0.00,0.00,525.12,'2021-12-05 11:35:46','',''),(2167720,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-05 11:35:46','',''),(2167785,'1','146','767',325,'Retail Sale Id 1281670',3801.60,0.00,0.00,0.00,285.12,'2021-12-05 11:39:43','',''),(2167786,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-05 11:39:43','',''),(2167796,'1','146','767',325,'Retail Sale Id 1281704',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 11:41:50','',''),(2167797,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:41:50','',''),(2167837,'1','146','767',325,'Retail Sale Id 1281742',499.20,0.00,0.00,0.00,37.44,'2021-12-05 11:43:53','',''),(2167838,'1','146','767',325,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-05 11:43:53','',''),(2167858,'1','146','767',325,'Retail Sale Id 1281756',32000.00,0.00,0.00,0.00,2400.00,'2021-12-05 11:45:26','',''),(2167859,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 11:45:26','',''),(2167897,'1','146','767',325,'Retail Sale Id 1281772',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 11:47:06','',''),(2167898,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:47:06','',''),(2167929,'1','146','767',325,'Retail Sale Id 1281793',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 11:49:18','',''),(2167930,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:49:18','',''),(2167994,'1','146','767',325,'Retail Sale Id 1281833',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 11:52:23','',''),(2167995,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:52:23','',''),(2168016,'1','146','767',325,'Retail Sale Id 1281844',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 11:53:42','',''),(2168017,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 11:53:42','',''),(2168036,'1','146','767',325,'Retail Sale Id 1281855',5120.00,0.00,0.00,0.00,384.00,'2021-12-05 11:55:18','',''),(2168037,'1','146','767',325,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 11:55:18','',''),(2168073,'1','146','767',325,'Retail Sale Id 1281683',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 11:57:14','',''),(2168074,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:57:14','',''),(2168178,'1','146','767',325,'Retail Sale Id 1281928',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:03:27','',''),(2168179,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:03:27','',''),(2168198,'1','146','767',325,'Retail Sale Id 1281937',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 12:04:47','',''),(2168199,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 12:04:47','',''),(2168226,'1','146','767',325,'Retail Sale Id 1281954',6400.00,0.00,0.00,0.00,480.00,'2021-12-05 12:06:01','',''),(2168227,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 12:06:01','',''),(2168256,'1','146','767',325,'Retail Sale Id 1281969',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:07:17','',''),(2168257,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:07:17','',''),(2168293,'1','146','767',325,'Retail Sale Id 1281991',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 12:09:10','',''),(2168294,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 12:09:10','',''),(2168316,'1','146','767',325,'Retail Sale Id 1282000',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 12:10:31','',''),(2168317,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 12:10:31','',''),(2168348,'1','146','767',325,'Retail Sale Id 1282017',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 12:12:06','',''),(2168349,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:12:06','',''),(2168407,'1','146','767',325,'Retail Sale Id 1282047',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:14:31','',''),(2168408,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:14:31','',''),(2168452,'1','146','767',325,'Retail Sale Id 1282060',32000.00,0.00,0.00,0.00,2400.00,'2021-12-05 12:16:16','',''),(2168453,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 12:16:16','',''),(2168510,'1','146','767',325,'Retail Sale Id 1282091',2502.40,0.00,0.00,0.00,187.68,'2021-12-05 12:18:22','',''),(2168511,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 12:18:22','',''),(2168552,'1','146','767',325,'Retail Sale Id 1282114',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:20:18','',''),(2168553,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:20:18','',''),(2168585,'1','146','767',325,'Retail Sale Id 1282129',16000.00,0.00,0.00,0.00,1200.00,'2021-12-05 12:21:29','',''),(2168586,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 12:21:29','',''),(2168629,'1','146','767',325,'Retail Sale Id 1282148',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:23:41','',''),(2168630,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:23:41','',''),(2168706,'1','146','767',325,'Retail Sale Id 1282188',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 12:26:15','',''),(2168707,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 12:26:15','',''),(2168748,'1','146','767',325,'Retail Sale Id 1282209',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:27:55','',''),(2168749,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:27:55','',''),(2168900,'1','146','767',325,'Retail Sale Id 1282180',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 12:35:46','',''),(2168901,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 12:35:46','',''),(2168927,'1','146','767',325,'Retail Sale Id 1282304',5497.60,0.00,0.00,0.00,412.32,'2021-12-05 12:37:43','',''),(2168928,'1','146','767',325,'Retail sales',0.00,0.00,0.00,8.59,0.00,'2021-12-05 12:37:43','',''),(2168955,'1','146','767',325,'Retail Sale Id 1282317',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:38:57','',''),(2168956,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:38:57','',''),(2168971,'1','146','767',325,'Retail Sale Id 1282318',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:39:37','',''),(2168972,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:39:37','',''),(2169121,'1','146','767',325,'Retail Sale Id 1282419',32000.00,0.00,0.00,0.00,2400.00,'2021-12-05 12:48:57','',''),(2169122,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 12:48:57','',''),(2169149,'1','146','767',325,'Retail Sale Id 1282435',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:50:34','',''),(2169150,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:50:34','',''),(2169167,'1','146','767',325,'Retail Sale Id 1282448',998.40,0.00,0.00,0.00,74.88,'2021-12-05 12:52:05','',''),(2169168,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 12:52:05','',''),(2169203,'1','146','767',325,'Retail Sale Id 1282466',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 12:54:03','',''),(2169204,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:54:03','',''),(2169241,'1','146','767',325,'Retail Sale Id 1282486',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 12:55:45','',''),(2169242,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 12:55:45','',''),(2169427,'1','146','767',325,'Retail Sale Id 1282572',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 13:04:35','',''),(2169428,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 13:04:35','',''),(2169590,'1','146','767',325,'Retail Sale Id 1282681',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 13:14:05','',''),(2169591,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 13:14:05','',''),(2169650,'1','146','767',325,'Retail Sale Id 1282707',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 13:18:08','',''),(2169651,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 13:18:08','',''),(2169680,'1','146','767',325,'Retail Sale Id 1282720',6400.00,0.00,0.00,0.00,480.00,'2021-12-05 13:19:30','',''),(2169681,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 13:19:30','',''),(2169712,'1','146','767',325,'Retail Sale Id 1282741',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:21:36','',''),(2169713,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:21:36','',''),(2169754,'1','146','767',325,'Retail Sale Id 1282764',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:24:22','',''),(2169755,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:24:22','',''),(2169798,'1','146','767',325,'Retail Sale Id 1282788',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:27:18','',''),(2169799,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:27:18','',''),(2169851,'1','146','767',325,'Retail Sale Id 1282803',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:29:18','',''),(2169852,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:29:18','',''),(2169869,'1','146','767',325,'Retail Sale Id 1282818',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 13:30:42','',''),(2169870,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 13:30:42','',''),(2169913,'1','146','767',325,'Retail Sale Id 1282835',16000.00,0.00,0.00,0.00,1200.00,'2021-12-05 13:32:26','',''),(2169914,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 13:32:26','',''),(2169943,'1','146','767',325,'Retail Sale Id 1282849',6003.20,0.00,0.00,0.00,450.24,'2021-12-05 13:34:14','',''),(2169944,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-05 13:34:14','',''),(2169997,'1','146','767',325,'Retail Sale Id 1282874',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:36:37','',''),(2169998,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:36:37','',''),(2170019,'1','146','767',325,'Retail Sale Id 1282885',1798.40,0.00,0.00,0.00,134.88,'2021-12-05 13:37:54','',''),(2170020,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-05 13:37:54','',''),(2170041,'1','146','767',325,'Retail Sale Id 1282892',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 13:38:58','',''),(2170042,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 13:38:58','',''),(2170061,'1','146','767',325,'Retail Sale Id 1282898',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 13:40:14','',''),(2170062,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 13:40:14','',''),(2170161,'1','146','767',325,'Retail Sale Id 1282925',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 13:43:56','',''),(2170162,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 13:43:56','',''),(2170192,'1','146','767',325,'Retail Sale Id 1282939',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:46:13','',''),(2170193,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:46:13','',''),(2170223,'1','146','767',325,'Retail Sale Id 1282951',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:47:32','',''),(2170224,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:47:32','',''),(2170241,'1','146','767',325,'Retail Sale Id 1282962',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:48:54','',''),(2170242,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:48:54','',''),(2170257,'1','146','767',325,'Retail Sale Id 1282970',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 13:50:03','',''),(2170258,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 13:50:03','',''),(2170290,'1','146','767',325,'Retail Sale Id 1282982',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 13:51:25','',''),(2170291,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 13:51:25','',''),(2170320,'1','146','767',325,'Retail Sale Id 1282993',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 13:52:37','',''),(2170321,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 13:52:37','',''),(2170338,'1','146','767',325,'Retail Sale Id 1283000',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 13:53:53','',''),(2170339,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 13:53:53','',''),(2170382,'1','146','767',325,'Retail Sale Id 1283025',2502.40,0.00,0.00,0.00,187.68,'2021-12-05 13:56:30','',''),(2170383,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 13:56:30','',''),(2170445,'1','146','767',325,'Retail Sale Id 1283044',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 13:58:41','',''),(2170446,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:58:41','',''),(2170465,'1','146','767',325,'Retail Sale Id 1283053',2502.40,0.00,0.00,0.00,187.68,'2021-12-05 14:00:06','',''),(2170466,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 14:00:06','',''),(2170481,'1','146','767',325,'Retail Sale Id 1283061',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 14:01:06','',''),(2170482,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:01:06','',''),(2170527,'1','146','767',325,'Retail Sale Id 1283085',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 14:04:36','',''),(2170528,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 14:04:36','',''),(2170575,'1','146','767',325,'Retail Sale Id 1283111',6400.00,0.00,0.00,0.00,480.00,'2021-12-05 14:07:58','',''),(2170576,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 14:07:58','',''),(2170600,'1','146','767',325,'Retail Sale Id 1283126',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 14:09:34','',''),(2170601,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 14:09:34','',''),(2170624,'1','146','767',325,'Retail Sale Id 1283134',998.40,0.00,0.00,0.00,74.88,'2021-12-05 14:10:42','',''),(2170625,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 14:10:42','',''),(2170729,'1','146','767',325,'Retail Sale Id 1283178',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 14:15:26','',''),(2170730,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 14:15:26','',''),(2170779,'1','146','767',325,'Retail Sale Id 1283189',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 14:16:48','',''),(2170780,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:16:48','',''),(2170933,'1','146','767',325,'Retail Sale Id 1283252',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 14:24:45','',''),(2170934,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 14:24:45','',''),(2170953,'1','146','767',325,'Retail Sale Id 1283265',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 14:26:09','',''),(2170954,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:26:09','',''),(2170991,'1','146','767',325,'Retail Sale Id 1283273',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 14:29:05','',''),(2170992,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:29:05','',''),(2171021,'1','146','767',325,'Retail Sale Id 1283293',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 14:30:22','',''),(2171022,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 14:30:22','',''),(2171056,'1','146','767',325,'Retail Sale Id 1283306',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 14:31:37','',''),(2171057,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 14:31:37','',''),(2171099,'1','146','767',325,'Retail Sale Id 1283316',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 14:33:01','',''),(2171100,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:33:01','',''),(2171135,'1','146','767',325,'Retail Sale Id 1283328',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 14:34:50','',''),(2171136,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 14:34:50','',''),(2171183,'1','146','767',325,'Retail Sale Id 1283335',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 14:36:15','',''),(2171184,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 14:36:15','',''),(2171369,'1','146','767',325,'Retail Sale Id 1283411',2502.40,0.00,0.00,0.00,187.68,'2021-12-05 14:47:45','',''),(2171370,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 14:47:45','',''),(2171455,'1','146','767',325,'Retail Sale Id 1283454',2502.40,0.00,0.00,0.00,187.68,'2021-12-05 14:52:47','',''),(2171456,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-05 14:52:47','',''),(2171473,'1','146','767',325,'Retail Sale Id 1283465',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 14:54:32','',''),(2171475,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 14:54:32','',''),(2171509,'1','146','767',325,'Retail Sale Id 1283482',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 14:57:10','',''),(2171510,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:57:10','',''),(2171527,'1','146','767',325,'Retail Sale Id 1283492',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 14:58:57','',''),(2171528,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:58:57','',''),(2171547,'1','146','767',325,'Retail Sale Id 1283500',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 15:00:15','',''),(2171548,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:00:15','',''),(2171569,'1','146','767',325,'Retail Sale Id 1283511',3001.60,0.00,0.00,0.00,225.12,'2021-12-05 15:02:11','',''),(2171570,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 15:02:11','',''),(2171589,'1','146','767',325,'Retail Sale Id 1283520',1203.20,0.00,0.00,0.00,90.24,'2021-12-05 15:03:56','',''),(2171590,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-05 15:03:56','',''),(2171611,'1','146','767',325,'Retail Sale Id 1283533',2598.40,0.00,0.00,0.00,194.88,'2021-12-05 15:05:40','',''),(2171612,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-05 15:05:40','',''),(2171631,'1','146','767',325,'Retail Sale Id 1283543',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 15:07:12','',''),(2171632,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 15:07:12','',''),(2171643,'1','146','767',325,'Retail Sale Id 1283550',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 15:08:20','',''),(2171644,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 15:08:20','',''),(2171669,'1','146','767',325,'Retail Sale Id 1283561',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 15:10:02','',''),(2171670,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 15:10:02','',''),(2171677,'1','146','767',325,'Retail Sale Id 1283566',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 15:11:13','',''),(2171678,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 15:11:13','',''),(2171703,'1','146','767',325,'Retail Sale Id 1283580',4998.40,0.00,0.00,0.00,374.88,'2021-12-05 15:13:10','',''),(2171704,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 15:13:10','',''),(2171717,'1','146','767',325,'Retail Sale Id 1283586',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 15:14:33','',''),(2171718,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 15:14:33','',''),(2171836,'1','146','767',325,'Retail Sale Id 1283645',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 15:22:33','',''),(2171837,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 15:22:33','',''),(2171886,'1','146','767',325,'Retail Sale Id 1283668',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 15:26:18','',''),(2171887,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 15:26:18','',''),(2171896,'1','146','767',325,'Retail Sale Id 1283677',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 15:26:53','',''),(2171897,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 15:26:53','',''),(2172026,'1','146','767',325,'Retail Sale Id 1283728',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 15:32:55','',''),(2172027,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 15:32:55','',''),(2172070,'1','146','767',325,'Retail Sale Id 1283755',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 15:35:57','',''),(2172071,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 15:35:57','',''),(2172141,'1','146','767',325,'Retail Sale Id 1283791',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 15:39:41','',''),(2172142,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 15:39:41','',''),(2172173,'1','146','767',325,'Retail Sale Id 1283811',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 15:41:05','',''),(2172174,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 15:41:05','',''),(2172209,'1','146','767',325,'Retail Sale Id 1283826',1497.60,0.00,0.00,0.00,112.32,'2021-12-05 15:42:27','',''),(2172210,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 15:42:27','',''),(2172275,'1','146','767',325,'Retail Sale Id 1283866',7001.60,0.00,0.00,0.00,525.12,'2021-12-05 15:45:45','',''),(2172276,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-05 15:45:45','',''),(2172313,'1','146','767',325,'Retail Sale Id 1283884',998.40,0.00,0.00,0.00,74.88,'2021-12-05 15:47:06','',''),(2172314,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 15:47:06','',''),(2172381,'1','146','767',325,'Retail Sale Id 1283922',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 15:51:03','',''),(2172382,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:51:03','',''),(2172420,'1','146','767',325,'Retail Sale Id 1283942',3200.00,0.00,0.00,0.00,240.00,'2021-12-05 15:53:25','',''),(2172421,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 15:53:25','',''),(2172449,'1','146','767',325,'Retail Sale Id 1283958',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 15:55:05','',''),(2172450,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:55:05','',''),(2172470,'1','146','767',325,'Retail Sale Id 1283970',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 15:56:21','',''),(2172471,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:56:21','',''),(2172490,'1','146','767',325,'Retail Sale Id 1283980',10003.20,0.00,0.00,0.00,750.24,'2021-12-05 15:57:44','',''),(2172491,'1','146','767',325,'Retail sales',0.00,0.00,0.00,15.63,0.00,'2021-12-05 15:57:44','',''),(2173439,'1','146','767',325,'Retail Sale Id 1284478',105702.40,0.00,0.00,0.00,7927.68,'2021-12-05 16:56:29','',''),(2173440,'1','146','767',325,'Retail sales',0.00,0.00,0.00,165.16,0.00,'2021-12-05 16:56:29','',''),(2173524,'1','146',NULL,325,'Purchased from AA RANO NIGERIA LIMITED',0.00,14255.36,24.08,0.00,0.00,'2021-12-05 17:02:14','',''),(2173553,'1','146',NULL,325,'Reception corrector for bridging 126338',0.00,0.00,0.00,24.08,0.00,'2021-12-05 17:04:25','',''),(2173554,'1','146','767',325,'Received from bridging 126338',0.00,0.00,24.08,0.00,0.00,'2021-12-05 17:04:25','',''),(2173586,'1','146','767',325,'Retail Sale Id 1284543',15411.20,0.00,0.00,0.00,1155.84,'2021-12-05 17:05:37','',''),(2173587,'1','146','767',325,'Retail sales',0.00,0.00,0.00,24.08,0.00,'2021-12-05 17:05:37','',''),(2173628,'1','146',NULL,325,'Purchased from AA RANO NIGERIA LIMITED',0.00,1184000.00,2000.00,0.00,0.00,'2021-12-05 17:08:33','',''),(2173635,'1','146',NULL,325,'Reception corrector for bridging 126340',0.00,0.00,0.00,2000.00,0.00,'2021-12-05 17:09:31','',''),(2173636,'1','146','767',325,'Received from bridging 126340',0.00,0.00,2000.00,0.00,0.00,'2021-12-05 17:09:31','',''),(2173878,'1','146','767',325,'Retail Sale Id 1284683',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 17:30:24','',''),(2173879,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:30:24','',''),(2173914,'1','146','767',325,'Retail Sale Id 1284699',16000.00,0.00,0.00,0.00,1200.00,'2021-12-05 17:32:26','',''),(2173915,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 17:32:26','',''),(2173934,'1','146','767',325,'Retail Sale Id 1284708',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 17:33:54','',''),(2173935,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:33:54','',''),(2173948,'1','146','767',325,'Retail Sale Id 1284715',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 17:35:16','',''),(2173949,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:35:16','',''),(2173974,'1','146','767',325,'Retail Sale Id 1284724',2003.20,0.00,0.00,0.00,150.24,'2021-12-05 17:36:50','',''),(2173975,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 17:36:50','',''),(2173980,'1','146','767',325,'Retail Sale Id 1284732',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 17:38:05','',''),(2173981,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 17:38:05','',''),(2173992,'1','146','767',325,'Retail Sale Id 1284736',8000.00,0.00,0.00,0.00,600.00,'2021-12-05 17:40:18','',''),(2173993,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:40:18','',''),(2174118,'1','146','767',325,'Retail Sale Id 1284799',4000.00,0.00,0.00,0.00,300.00,'2021-12-05 18:01:50','',''),(2174119,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 18:01:50','',''),(2174450,'1','146','767',325,'Retail Sale Id 1284877',123398.40,0.00,0.00,0.00,9254.88,'2021-12-05 20:25:14','',''),(2174451,'1','146','767',325,'Retail sales',0.00,0.00,0.00,192.81,0.00,'2021-12-05 20:25:14','',''),(2174838,'1','146','767',325,'Retail Sale Id 1284923',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 06:12:26','',''),(2174839,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:12:26','',''),(2174846,'1','146','767',325,'Retail Sale Id 1284927',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 06:13:21','',''),(2174847,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 06:13:21','',''),(2174854,'1','146','767',325,'Retail Sale Id 1284931',3500.80,0.00,0.00,0.00,262.56,'2021-12-06 06:14:18','',''),(2174855,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-06 06:14:18','',''),(2174943,'1','146','767',325,'Retail Sale Id 1284979',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 06:28:44','',''),(2174944,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:28:44','',''),(2175021,'1','146','767',325,'Retail Sale Id 1284992',4998.40,0.00,0.00,0.00,374.88,'2021-12-06 06:32:54','',''),(2175022,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 06:32:54','',''),(2175038,'1','146','767',325,'Retail Sale Id 1284996',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 06:33:52','',''),(2175039,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 06:33:52','',''),(2175050,'1','146','767',325,'Retail Sale Id 1285004',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 06:34:46','',''),(2175051,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:34:46','',''),(2175061,'1','146','767',325,'Retail Sale Id 1285007',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 06:36:48','',''),(2175062,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:36:48','',''),(2175065,'1','146','767',325,'Retail Sale Id 1285009',6003.20,0.00,0.00,0.00,450.24,'2021-12-06 06:37:24','',''),(2175066,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-06 06:37:24','',''),(2175081,'1','146','767',325,'Retail Sale Id 1285016',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 06:38:54','',''),(2175082,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:38:54','',''),(2175099,'1','146','767',325,'Retail Sale Id 1285023',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 06:41:36','',''),(2175100,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 06:41:36','',''),(2175109,'1','146','767',325,'Retail Sale Id 1285030',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 06:43:11','',''),(2175110,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 06:43:11','',''),(2175123,'1','146','767',325,'Retail Sale Id 1285034',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 06:44:32','',''),(2175124,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 06:44:32','',''),(2175141,'1','146','767',325,'Retail Sale Id 1285046',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 06:45:39','',''),(2175142,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 06:45:39','',''),(2175149,'1','146','767',325,'Retail Sale Id 1285052',7001.60,0.00,0.00,0.00,525.12,'2021-12-06 06:46:22','',''),(2175150,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-06 06:46:22','',''),(2175157,'1','146','767',325,'Retail Sale Id 1285055',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 06:47:03','',''),(2175158,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 06:47:03','',''),(2175169,'1','146','767',325,'Retail Sale Id 1285061',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 06:47:43','',''),(2175170,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:47:43','',''),(2175177,'1','146','767',325,'Retail Sale Id 1285067',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 06:48:17','',''),(2175178,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 06:48:17','',''),(2175183,'1','146','767',325,'Retail Sale Id 1285071',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 06:48:57','',''),(2175184,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 06:48:57','',''),(2175197,'1','146','767',325,'Retail Sale Id 1285076',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 06:49:43','',''),(2175198,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 06:49:43','',''),(2175211,'1','146','767',325,'Retail Sale Id 1285084',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 06:50:45','',''),(2175212,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 06:50:45','',''),(2175217,'1','146','767',325,'Retail Sale Id 1285088',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 06:51:35','',''),(2175218,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 06:51:35','',''),(2175221,'1','146','767',325,'Retail Sale Id 1285092',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 06:52:21','',''),(2175222,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 06:52:21','',''),(2175238,'1','146','767',325,'Retail Sale Id 1285096',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 06:52:59','',''),(2175239,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 06:52:59','',''),(2175248,'1','146','767',325,'Retail Sale Id 1285105',2598.40,0.00,0.00,0.00,194.88,'2021-12-06 06:53:46','',''),(2175249,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-06 06:53:46','',''),(2175268,'1','146','767',325,'Retail Sale Id 1285112',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 06:55:18','',''),(2175269,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:55:18','',''),(2175293,'1','146','767',325,'Retail Sale Id 1285120',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 06:56:55','',''),(2175294,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 06:56:55','',''),(2175320,'1','146','767',325,'Retail Sale Id 1285134',6400.00,0.00,0.00,0.00,480.00,'2021-12-06 06:57:52','',''),(2175321,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 06:57:52','',''),(2175340,'1','146','767',325,'Retail Sale Id 1285142',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 06:58:48','',''),(2175341,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:58:48','',''),(2175365,'1','146','767',325,'Retail Sale Id 1285151',6400.00,0.00,0.00,0.00,480.00,'2021-12-06 07:00:01','',''),(2175366,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 07:00:01','',''),(2175371,'1','146','767',325,'Retail Sale Id 1285156',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 07:00:39','',''),(2175372,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 07:00:39','',''),(2175423,'1','146','767',325,'Retail Sale Id 1285166',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:02:49','',''),(2175424,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:02:49','',''),(2175455,'1','146','767',325,'Retail Sale Id 1285181',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:04:21','',''),(2175456,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:04:21','',''),(2175465,'1','146','767',325,'Retail Sale Id 1285184',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 07:05:13','',''),(2175466,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 07:05:13','',''),(2175475,'1','146','767',325,'Retail Sale Id 1285191',16000.00,0.00,0.00,0.00,1200.00,'2021-12-06 07:05:49','',''),(2175476,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 07:05:49','',''),(2175483,'1','146','767',325,'Retail Sale Id 1285195',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:06:38','',''),(2175484,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:06:38','',''),(2175537,'1','146','767',325,'Retail Sale Id 1285222',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:12:23','',''),(2175538,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:12:23','',''),(2175614,'1','146','767',325,'Retail Sale Id 1285260',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:16:35','',''),(2175615,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:16:35','',''),(2175660,'1','146','767',325,'Retail Sale Id 1285286',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:19:14','',''),(2175661,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:19:14','',''),(2175688,'1','146','767',325,'Retail Sale Id 1285306',6400.00,0.00,0.00,0.00,480.00,'2021-12-06 07:21:20','',''),(2175689,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 07:21:20','',''),(2175710,'1','146','767',325,'Retail Sale Id 1285314',32000.00,0.00,0.00,0.00,2400.00,'2021-12-06 07:22:23','',''),(2175711,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 07:22:23','',''),(2175762,'1','146','767',325,'Retail Sale Id 1285340',998.40,0.00,0.00,0.00,74.88,'2021-12-06 07:25:07','',''),(2175763,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 07:25:07','',''),(2175778,'1','146','767',325,'Retail Sale Id 1285350',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 07:25:59','',''),(2175779,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 07:25:59','',''),(2175788,'1','146','767',325,'Retail Sale Id 1285353',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:26:31','',''),(2175789,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:26:31','',''),(2175806,'1','146','767',325,'Retail Sale Id 1285361',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:27:25','',''),(2175807,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:27:25','',''),(2175838,'1','146','767',325,'Retail Sale Id 1285376',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 07:30:07','',''),(2175839,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 07:30:07','',''),(2175919,'1','146','767',325,'Retail Sale Id 1285416',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:34:51','',''),(2175920,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:34:51','',''),(2175951,'1','146','767',325,'Retail Sale Id 1285433',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:36:27','',''),(2175952,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:36:27','',''),(2176005,'1','146','767',325,'Retail Sale Id 1285459',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:39:52','',''),(2176006,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:39:52','',''),(2176025,'1','146','767',325,'Retail Sale Id 1285465',64000.00,0.00,0.00,0.00,4800.00,'2021-12-06 07:40:43','',''),(2176026,'1','146','767',325,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 07:40:43','',''),(2176107,'1','146','767',325,'Retail Sale Id 1285508',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:44:11','',''),(2176108,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:44:11','',''),(2176174,'1','146','767',325,'Retail Sale Id 1285542',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:46:42','',''),(2176175,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:46:42','',''),(2176247,'1','146','767',325,'Retail Sale Id 1285576',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 07:50:16','',''),(2176248,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 07:50:16','',''),(2176258,'1','146','767',325,'Retail Sale Id 1285580',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 07:50:53','',''),(2176259,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 07:50:53','',''),(2176420,'1','146','767',325,'Retail Sale Id 1285645',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 07:57:19','',''),(2176421,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:57:19','',''),(2176437,'1','146','767',325,'Retail Sale Id 1285653',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 07:58:08','',''),(2176438,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 07:58:08','',''),(2176475,'1','146','767',325,'Retail Sale Id 1285671',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 08:00:04','',''),(2176476,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 08:00:04','',''),(2176491,'1','146','767',325,'Retail Sale Id 1285683',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 08:00:41','',''),(2176492,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:00:41','',''),(2176503,'1','146','767',325,'Retail Sale Id 1285691',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 08:01:47','',''),(2176504,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 08:01:47','',''),(2176541,'1','146','767',325,'Retail Sale Id 1285710',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 08:03:45','',''),(2176542,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:03:45','',''),(2176600,'1','146','767',325,'Retail Sale Id 1285747',12000.00,0.00,0.00,0.00,900.00,'2021-12-06 08:07:03','',''),(2176601,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-06 08:07:03','',''),(2176632,'1','146','767',325,'Retail Sale Id 1285754',32000.00,0.00,0.00,0.00,2400.00,'2021-12-06 08:07:59','',''),(2176633,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 08:07:59','',''),(2176742,'1','146','767',325,'Retail Sale Id 1285814',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 08:15:16','',''),(2176743,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 08:15:16','',''),(2176764,'1','146','767',325,'Retail Sale Id 1285827',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 08:17:55','',''),(2176765,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:17:55','',''),(2176816,'1','146','767',325,'Retail Sale Id 1285857',30003.20,0.00,0.00,0.00,2250.24,'2021-12-06 08:22:31','',''),(2176817,'1','146','767',325,'Retail sales',0.00,0.00,0.00,46.88,0.00,'2021-12-06 08:22:31','',''),(2176826,'1','146','767',325,'Retail Sale Id 1285861',4998.40,0.00,0.00,0.00,374.88,'2021-12-06 08:23:38','',''),(2176827,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 08:23:38','',''),(2176836,'1','146','767',325,'Retail Sale Id 1285867',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 08:24:30','',''),(2176837,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 08:24:30','',''),(2176840,'1','146','767',325,'Retail Sale Id 1285869',5798.40,0.00,0.00,0.00,434.88,'2021-12-06 08:25:13','',''),(2176841,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.06,0.00,'2021-12-06 08:25:13','',''),(2176847,'1','146','767',325,'Retail Sale Id 1285872',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 08:25:56','',''),(2176848,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 08:25:56','',''),(2176863,'1','146','767',325,'Retail Sale Id 1285882',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 08:26:58','',''),(2176864,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 08:26:58','',''),(2176867,'1','146','767',325,'Retail Sale Id 1285884',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 08:27:45','',''),(2176868,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 08:27:45','',''),(2176873,'1','146','767',325,'Retail Sale Id 1285887',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 08:28:46','',''),(2176874,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:28:46','',''),(2176899,'1','146','767',325,'Retail Sale Id 1285902',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 08:31:00','',''),(2176900,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:31:00','',''),(2176911,'1','146','767',325,'Retail Sale Id 1285907',998.40,0.00,0.00,0.00,74.88,'2021-12-06 08:31:34','',''),(2176912,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 08:31:34','',''),(2176957,'1','146','767',325,'Retail Sale Id 1285929',998.40,0.00,0.00,0.00,74.88,'2021-12-06 08:35:05','',''),(2176958,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 08:35:05','',''),(2176976,'1','146','767',325,'Retail Sale Id 1285934',7001.60,0.00,0.00,0.00,525.12,'2021-12-06 08:36:11','',''),(2176977,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-06 08:36:11','',''),(2176986,'1','146','767',325,'Retail Sale Id 1285940',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 08:37:02','',''),(2176987,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 08:37:02','',''),(2177017,'1','146','767',325,'Retail Sale Id 1285954',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 08:39:35','',''),(2177018,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 08:39:35','',''),(2177064,'1','146','767',325,'Retail Sale Id 1285975',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 08:43:00','',''),(2177065,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 08:43:00','',''),(2177132,'1','146','767',325,'Retail Sale Id 1286004',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 08:47:39','',''),(2177133,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:47:39','',''),(2177153,'1','146','767',325,'Retail Sale Id 1286014',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 08:48:58','',''),(2177154,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 08:48:58','',''),(2177165,'1','146','767',325,'Retail Sale Id 1286023',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 08:49:55','',''),(2177166,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:49:55','',''),(2177249,'1','146','767',325,'Retail Sale Id 1286069',7001.60,0.00,0.00,0.00,525.12,'2021-12-06 08:56:11','',''),(2177250,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-06 08:56:11','',''),(2177274,'1','146','767',325,'Retail Sale Id 1286080',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 08:58:15','',''),(2177275,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:58:15','',''),(2177295,'1','146','767',325,'Retail Sale Id 1286089',998.40,0.00,0.00,0.00,74.88,'2021-12-06 08:59:24','',''),(2177296,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 08:59:24','',''),(2177341,'1','146','767',325,'Retail Sale Id 1286112',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 09:03:23','',''),(2177342,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:03:23','',''),(2177349,'1','146','767',325,'Retail Sale Id 1286118',7001.60,0.00,0.00,0.00,525.12,'2021-12-06 09:04:25','',''),(2177350,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-06 09:04:25','',''),(2177365,'1','146','767',325,'Retail Sale Id 1286122',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 09:05:11','',''),(2177366,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:05:11','',''),(2177399,'1','146','767',325,'Retail Sale Id 1286130',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 09:06:58','',''),(2177400,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 09:06:58','',''),(2177432,'1','146','767',325,'Retail Sale Id 1286149',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 09:08:35','',''),(2177433,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 09:08:35','',''),(2177441,'1','146','767',325,'Retail Sale Id 1286154',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 09:09:29','',''),(2177442,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 09:09:29','',''),(2177566,'1','146','767',325,'Retail Sale Id 1286209',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 09:18:25','',''),(2177567,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 09:18:25','',''),(2177590,'1','146','767',325,'Retail Sale Id 1286221',6502.40,0.00,0.00,0.00,487.68,'2021-12-06 09:19:55','',''),(2177591,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-06 09:19:55','',''),(2177632,'1','146','767',325,'Retail Sale Id 1286247',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 09:23:08','',''),(2177633,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:23:08','',''),(2177638,'1','146','767',325,'Retail Sale Id 1286251',16000.00,0.00,0.00,0.00,1200.00,'2021-12-06 09:23:40','',''),(2177639,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 09:23:40','',''),(2177680,'1','146','767',325,'Retail Sale Id 1286267',4998.40,0.00,0.00,0.00,374.88,'2021-12-06 09:25:37','',''),(2177681,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 09:25:37','',''),(2177725,'1','146','767',325,'Retail Sale Id 1286289',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 09:28:09','',''),(2177726,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:28:09','',''),(2177740,'1','146','767',325,'Retail Sale Id 1286295',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 09:28:52','',''),(2177741,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 09:28:52','',''),(2177746,'1','146','767',325,'Retail Sale Id 1286302',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 09:29:31','',''),(2177747,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 09:29:31','',''),(2177865,'1','146','767',325,'Retail Sale Id 1286348',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 09:36:27','',''),(2177866,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:36:27','',''),(2177889,'1','146','767',325,'Retail Sale Id 1286353',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 09:37:08','',''),(2177890,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:37:08','',''),(2177954,'1','146','767',325,'Retail Sale Id 1286371',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 09:39:19','',''),(2177955,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 09:39:19','',''),(2177988,'1','146','767',325,'Retail Sale Id 1286388',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 09:41:56','',''),(2177989,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:41:56','',''),(2178044,'1','146','767',325,'Retail Sale Id 1286413',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 09:45:08','',''),(2178045,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:45:08','',''),(2178060,'1','146','767',325,'Retail Sale Id 1286421',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 09:46:22','',''),(2178061,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 09:46:22','',''),(2178084,'1','146','767',325,'Retail Sale Id 1286434',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 09:48:05','',''),(2178085,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:48:05','',''),(2178115,'1','146','767',325,'Retail Sale Id 1286449',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 09:50:20','',''),(2178116,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:50:20','',''),(2178123,'1','146','767',325,'Retail Sale Id 1286455',32000.00,0.00,0.00,0.00,2400.00,'2021-12-06 09:51:17','',''),(2178124,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 09:51:17','',''),(2178131,'1','146','767',325,'Retail Sale Id 1286460',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 09:51:53','',''),(2178132,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 09:51:53','',''),(2178173,'1','146','767',325,'Retail Sale Id 1286480',4998.40,0.00,0.00,0.00,374.88,'2021-12-06 09:54:33','',''),(2178174,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 09:54:33','',''),(2178294,'1','146',NULL,325,'Purchased from AA RANO NIGERIA LIMITED',0.00,1758240.00,2970.00,0.00,0.00,'2021-12-06 10:03:04','',''),(2178302,'1','146','767',325,'Retail Sale Id 1286548',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 10:03:39','',''),(2178303,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 10:03:39','',''),(2178314,'1','146',NULL,325,'Reception corrector for bridging 126362',0.00,0.00,0.00,2970.00,0.00,'2021-12-06 10:04:00','',''),(2178315,'1','146','767',325,'Received from bridging 126362',0.00,0.00,2970.00,0.00,0.00,'2021-12-06 10:04:00','',''),(2178457,'1','146','767',325,'Retail Sale Id 1286612',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 10:11:03','',''),(2178458,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:11:03','',''),(2178491,'1','146','767',325,'Retail Sale Id 1286631',16000.00,0.00,0.00,0.00,1200.00,'2021-12-06 10:13:14','',''),(2178492,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 10:13:14','',''),(2178557,'1','146','767',325,'Retail Sale Id 1286666',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 10:17:34','',''),(2178558,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 10:17:34','',''),(2178661,'1','146','767',325,'Retail Sale Id 1286723',7001.60,0.00,0.00,0.00,525.12,'2021-12-06 10:25:52','',''),(2178662,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-06 10:25:52','',''),(2178719,'1','146','767',325,'Retail Sale Id 1286749',6003.20,0.00,0.00,0.00,450.24,'2021-12-06 10:29:14','',''),(2178720,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-06 10:29:14','',''),(2178765,'1','146','767',325,'Retail Sale Id 1286774',6003.20,0.00,0.00,0.00,450.24,'2021-12-06 10:32:19','',''),(2178766,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-06 10:32:19','',''),(2178898,'1','146','767',325,'Retail Sale Id 1286849',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 10:42:12','',''),(2178899,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 10:42:12','',''),(2179032,'1','146','767',325,'Retail Sale Id 1286928',32000.00,0.00,0.00,0.00,2400.00,'2021-12-06 10:49:44','',''),(2179033,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 10:49:44','',''),(2179112,'1','146','767',325,'Retail Sale Id 1286974',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 10:54:36','',''),(2179113,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:54:36','',''),(2179209,'1','146','767',325,'Retail Sale Id 1287033',24000.00,0.00,0.00,0.00,1800.00,'2021-12-06 11:00:24','',''),(2179210,'1','146','767',325,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-06 11:00:24','',''),(2179253,'1','146','767',325,'Retail Sale Id 1287060',10003.20,0.00,0.00,0.00,750.24,'2021-12-06 11:03:36','',''),(2179254,'1','146','767',325,'Retail sales',0.00,0.00,0.00,15.63,0.00,'2021-12-06 11:03:36','',''),(2179349,'1','146','767',325,'Retail Sale Id 1287113',3500.80,0.00,0.00,0.00,262.56,'2021-12-06 11:08:54','',''),(2179350,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-06 11:08:54','',''),(2179379,'1','146','767',325,'Retail Sale Id 1287130',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 11:11:15','',''),(2179380,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 11:11:15','',''),(2179389,'1','146','767',325,'Retail Sale Id 1287135',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 11:11:54','',''),(2179390,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 11:11:54','',''),(2179577,'1','146','767',325,'Retail Sale Id 1287235',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 11:22:18','',''),(2179578,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:22:18','',''),(2179629,'1','146','767',325,'Retail Sale Id 1287265',2598.40,0.00,0.00,0.00,194.88,'2021-12-06 11:26:28','',''),(2179630,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-06 11:26:28','',''),(2179657,'1','146','767',325,'Retail Sale Id 1287281',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 11:28:27','',''),(2179658,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 11:28:27','',''),(2179679,'1','146','767',325,'Retail Sale Id 1287293',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 11:30:19','',''),(2179680,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:30:19','',''),(2179720,'1','146','767',325,'Retail Sale Id 1287314',12000.00,0.00,0.00,0.00,900.00,'2021-12-06 11:32:56','',''),(2179721,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-06 11:32:56','',''),(2179746,'1','146','767',325,'Retail Sale Id 1287327',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 11:35:14','',''),(2179747,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:35:14','',''),(2179760,'1','146','767',325,'Retail Sale Id 1287336',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 11:36:32','',''),(2179761,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:36:32','',''),(2179890,'1','146','767',325,'Retail Sale Id 1287464',31001.60,0.00,0.00,0.00,2325.12,'2021-12-06 11:47:33','',''),(2179891,'1','146','767',325,'Retail sales',0.00,0.00,0.00,48.44,0.00,'2021-12-06 11:47:33','',''),(2179926,'1','146','767',325,'Retail Sale Id 1287478',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 11:49:23','',''),(2179927,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 11:49:23','',''),(2179935,'1','146','767',325,'Retail Sale Id 1287487',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 11:50:09','',''),(2179936,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 11:50:09','',''),(2179962,'1','146','767',325,'Retail Sale Id 1287500',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 11:52:25','',''),(2179963,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 11:52:25','',''),(2180052,'1','146','767',325,'Retail Sale Id 1287545',20000.00,0.00,0.00,0.00,1500.00,'2021-12-06 11:58:05','',''),(2180053,'1','146','767',325,'Retail sales',0.00,0.00,0.00,31.25,0.00,'2021-12-06 11:58:05','',''),(2180088,'1','146','767',325,'Retail Sale Id 1287563',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 12:00:16','',''),(2180089,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:00:16','',''),(2180122,'1','146','767',325,'Retail Sale Id 1287577',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 12:02:45','',''),(2180123,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 12:02:45','',''),(2180134,'1','146','767',325,'Retail Sale Id 1287585',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 12:03:18','',''),(2180135,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 12:03:18','',''),(2180160,'1','146','767',325,'Retail Sale Id 1287591',24000.00,0.00,0.00,0.00,1800.00,'2021-12-06 12:04:20','',''),(2180161,'1','146','767',325,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-06 12:04:20','',''),(2180172,'1','146','767',325,'Retail Sale Id 1287605',32000.00,0.00,0.00,0.00,2400.00,'2021-12-06 12:05:06','',''),(2180173,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 12:05:06','',''),(2180196,'1','146','767',325,'Retail Sale Id 1287614',32000.00,0.00,0.00,0.00,2400.00,'2021-12-06 12:06:45','',''),(2180197,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 12:06:45','',''),(2180408,'1','146','767',325,'Retail Sale Id 1287741',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 12:18:47','',''),(2180409,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:18:47','',''),(2180460,'1','146','767',325,'Retail Sale Id 1287771',29497.60,0.00,0.00,0.00,2212.32,'2021-12-06 12:22:59','',''),(2180461,'1','146','767',325,'Retail sales',0.00,0.00,0.00,46.09,0.00,'2021-12-06 12:22:59','',''),(2180474,'1','146','767',325,'Retail Sale Id 1287776',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 12:23:47','',''),(2180475,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:23:47','',''),(2180568,'1','146','767',325,'Retail Sale Id 1287827',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 12:29:51','',''),(2180569,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 12:29:51','',''),(2180637,'1','146','767',325,'Retail Sale Id 1287860',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 12:33:58','',''),(2180638,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 12:33:58','',''),(2180652,'1','146','767',325,'Retail Sale Id 1287867',8198.40,0.00,0.00,0.00,614.88,'2021-12-06 12:34:33','',''),(2180653,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.81,0.00,'2021-12-06 12:34:33','',''),(2180660,'1','146','767',325,'Retail Sale Id 1287872',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 12:35:24','',''),(2180661,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 12:35:24','',''),(2180682,'1','146','767',325,'Retail Sale Id 1287885',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 12:36:38','',''),(2180685,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 12:36:38','',''),(2180706,'1','146','767',325,'Retail Sale Id 1287897',9600.00,0.00,0.00,0.00,720.00,'2021-12-06 12:37:32','',''),(2180707,'1','146','767',325,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-06 12:37:32','',''),(2180764,'1','146','767',325,'Retail Sale Id 1287924',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 12:41:48','',''),(2180765,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:41:48','',''),(2180838,'1','146','767',325,'Retail Sale Id 1287967',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 12:46:49','',''),(2180839,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:46:49','',''),(2180864,'1','146','767',325,'Retail Sale Id 1287977',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 12:47:48','',''),(2180865,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:47:48','',''),(2180898,'1','146','767',325,'Retail Sale Id 1287996',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 12:50:10','',''),(2180899,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 12:50:10','',''),(2180949,'1','146','767',325,'Retail Sale Id 1288023',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 12:53:13','',''),(2180950,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:53:13','',''),(2181130,'1','146','767',325,'Retail Sale Id 1288108',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 13:02:47','',''),(2181131,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:02:47','',''),(2181144,'1','146','767',325,'Retail Sale Id 1288117',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 13:04:06','',''),(2181145,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 13:04:06','',''),(2181162,'1','146','767',325,'Retail Sale Id 1288126',998.40,0.00,0.00,0.00,74.88,'2021-12-06 13:05:01','',''),(2181163,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 13:05:01','',''),(2181268,'1','146','767',325,'Retail Sale Id 1288190',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 13:11:00','',''),(2181269,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 13:11:00','',''),(2181310,'1','146','767',325,'Retail Sale Id 1288212',4998.40,0.00,0.00,0.00,374.88,'2021-12-06 13:13:34','',''),(2181311,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 13:13:34','',''),(2181328,'1','146','767',325,'Retail Sale Id 1288221',3200.00,0.00,0.00,0.00,240.00,'2021-12-06 13:14:28','',''),(2181329,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 13:14:28','',''),(2181398,'1','146','767',325,'Retail Sale Id 1288243',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 13:17:18','',''),(2181399,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 13:17:18','',''),(2181429,'1','146','767',325,'Retail Sale Id 1288249',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 13:18:22','',''),(2181430,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:18:22','',''),(2181441,'1','146','767',325,'Retail Sale Id 1288257',998.40,0.00,0.00,0.00,74.88,'2021-12-06 13:19:11','',''),(2181442,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 13:19:11','',''),(2181464,'1','146','767',325,'Retail Sale Id 1288264',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 13:19:54','',''),(2181465,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:19:54','',''),(2181474,'1','146','767',325,'Retail Sale Id 1288268',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 13:20:37','',''),(2181475,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 13:20:37','',''),(2181504,'1','146','767',325,'Retail Sale Id 1288281',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 13:22:20','',''),(2181505,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:22:20','',''),(2181510,'1','146','767',325,'Retail Sale Id 1288285',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 13:23:15','',''),(2181511,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 13:23:15','',''),(2181520,'1','146','767',325,'Retail Sale Id 1288290',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 13:24:03','',''),(2181521,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 13:24:03','',''),(2181596,'1','146','767',325,'Retail Sale Id 1288333',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 13:30:50','',''),(2181597,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 13:30:50','',''),(2181700,'1','146','767',325,'Retail Sale Id 1288364',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 13:35:38','',''),(2181701,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:35:38','',''),(2181722,'1','146','767',325,'Retail Sale Id 1288372',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 13:36:39','',''),(2181723,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:36:39','',''),(2181748,'1','146','767',325,'Retail Sale Id 1288385',22400.00,0.00,0.00,0.00,1680.00,'2021-12-06 13:38:15','',''),(2181749,'1','146','767',325,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-06 13:38:15','',''),(2181943,'1','146','767',325,'Retail Sale Id 1288483',998.40,0.00,0.00,0.00,74.88,'2021-12-06 13:47:31','',''),(2181944,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 13:47:31','',''),(2181961,'1','146','767',325,'Retail Sale Id 1288489',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 13:48:36','',''),(2181962,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 13:48:36','',''),(2181997,'1','146','767',325,'Retail Sale Id 1288505',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 13:49:57','',''),(2181998,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 13:49:57','',''),(2182007,'1','146','767',325,'Retail Sale Id 1288508',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 13:50:43','',''),(2182008,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 13:50:43','',''),(2182023,'1','146','767',325,'Retail Sale Id 1288516',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 13:51:37','',''),(2182024,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 13:51:37','',''),(2182043,'1','146','767',325,'Retail Sale Id 1288527',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 13:52:30','',''),(2182044,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 13:52:30','',''),(2182053,'1','146','767',325,'Retail Sale Id 1288533',4998.40,0.00,0.00,0.00,374.88,'2021-12-06 13:53:12','',''),(2182054,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-06 13:53:12','',''),(2182069,'1','146','767',325,'Retail Sale Id 1288540',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 13:54:02','',''),(2182070,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 13:54:02','',''),(2182085,'1','146','767',325,'Retail Sale Id 1288549',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 13:54:42','',''),(2182086,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 13:54:42','',''),(2182206,'1','146','767',325,'Retail Sale Id 1288599',9600.00,0.00,0.00,0.00,720.00,'2021-12-06 14:00:08','',''),(2182207,'1','146','767',325,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-06 14:00:08','',''),(2182291,'1','146','767',325,'Retail Sale Id 1288641',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 14:03:57','',''),(2182292,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:03:57','',''),(2182323,'1','146','767',325,'Retail Sale Id 1288657',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 14:05:44','',''),(2182324,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:05:44','',''),(2182341,'1','146','767',325,'Retail Sale Id 1288663',38003.20,0.00,0.00,0.00,2850.24,'2021-12-06 14:06:28','',''),(2182342,'1','146','767',325,'Retail sales',0.00,0.00,0.00,59.38,0.00,'2021-12-06 14:06:28','',''),(2182509,'1','146','767',325,'Retail Sale Id 1288713',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 14:13:24','',''),(2182510,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 14:13:24','',''),(2182515,'1','146','767',325,'Retail Sale Id 1288732',7699.20,0.00,0.00,0.00,577.44,'2021-12-06 14:13:55','',''),(2182516,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.03,0.00,'2021-12-06 14:13:55','',''),(2182553,'1','146','767',325,'Retail Sale Id 1288750',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 14:15:35','',''),(2182554,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:15:35','',''),(2182724,'1','146','767',325,'Retail Sale Id 1288833',24000.00,0.00,0.00,0.00,1800.00,'2021-12-06 14:24:03','',''),(2182725,'1','146','767',325,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-06 14:24:03','',''),(2182740,'1','146','767',325,'Retail Sale Id 1288839',6003.20,0.00,0.00,0.00,450.24,'2021-12-06 14:24:49','',''),(2182741,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-06 14:24:49','',''),(2182818,'1','146','767',325,'Retail Sale Id 1288882',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 14:29:52','',''),(2182819,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:29:52','',''),(2182962,'1','146','767',325,'Retail Sale Id 1288951',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 14:37:49','',''),(2182963,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 14:37:49','',''),(2183020,'1','146','767',325,'Retail Sale Id 1288975',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 14:40:16','',''),(2183021,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:40:16','',''),(2183258,'1','146','767',325,'Retail Sale Id 1289073',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 14:51:51','',''),(2183259,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 14:51:51','',''),(2183429,'1','146','767',325,'Retail Sale Id 1289155',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:00:25','',''),(2183430,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:00:25','',''),(2183447,'1','146','767',325,'Retail Sale Id 1289165',12000.00,0.00,0.00,0.00,900.00,'2021-12-06 15:01:29','',''),(2183448,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-06 15:01:29','',''),(2183582,'1','146','767',325,'Retail Sale Id 1289234',12000.00,0.00,0.00,0.00,900.00,'2021-12-06 15:09:13','',''),(2183583,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-06 15:09:13','',''),(2183734,'1','146','767',325,'Retail Sale Id 1289297',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:17:15','',''),(2183735,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:17:15','',''),(2183762,'1','146','767',325,'Retail Sale Id 1289311',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 15:19:04','',''),(2183763,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 15:19:04','',''),(2183810,'1','146','767',325,'Retail Sale Id 1289329',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:20:27','',''),(2183811,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:20:27','',''),(2183839,'1','146','767',325,'Retail Sale Id 1289346',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 15:22:14','',''),(2183840,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 15:22:14','',''),(2184027,'1','146','767',325,'Retail Sale Id 1289434',998.40,0.00,0.00,0.00,74.88,'2021-12-06 15:30:47','',''),(2184028,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 15:30:47','',''),(2184049,'1','146','767',325,'Retail Sale Id 1289445',2502.40,0.00,0.00,0.00,187.68,'2021-12-06 15:31:50','',''),(2184050,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 15:31:50','',''),(2184113,'1','146','767',325,'Retail Sale Id 1289476',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 15:35:40','',''),(2184114,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 15:35:40','',''),(2184140,'1','146','767',325,'Retail Sale Id 1289489',32000.00,0.00,0.00,0.00,2400.00,'2021-12-06 15:36:53','',''),(2184141,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 15:36:53','',''),(2184161,'1','146','767',325,'Retail Sale Id 1289475',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:37:51','',''),(2184162,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:37:51','',''),(2184211,'1','146','767',325,'Retail Sale Id 1289515',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:39:31','',''),(2184212,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:39:31','',''),(2184249,'1','146','767',325,'Retail Sale Id 1289527',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 15:40:40','',''),(2184250,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 15:40:40','',''),(2184351,'1','146','767',325,'Retail Sale Id 1289551',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:43:34','',''),(2184352,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:43:34','',''),(2184462,'1','146','767',325,'Retail Sale Id 1289595',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 15:48:05','',''),(2184463,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 15:48:05','',''),(2184566,'1','146','767',325,'Retail Sale Id 1289644',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 15:53:35','',''),(2184567,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:53:35','',''),(2184600,'1','146','767',325,'Retail Sale Id 1289660',40000.00,0.00,0.00,0.00,3000.00,'2021-12-06 15:55:03','',''),(2184601,'1','146','767',325,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-06 15:55:03','',''),(2184892,'1','146','767',325,'Retail Sale Id 1289795',3500.80,0.00,0.00,0.00,262.56,'2021-12-06 16:13:04','',''),(2184893,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-06 16:13:04','',''),(2184946,'1','146','767',325,'Retail Sale Id 1289819',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 16:16:46','',''),(2184947,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 16:16:46','',''),(2185003,'1','146','767',325,'Retail Sale Id 1289848',7001.60,0.00,0.00,0.00,525.12,'2021-12-06 16:19:11','',''),(2185004,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-06 16:19:11','',''),(2185012,'1','146','767',325,'Retail Sale Id 1289855',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 16:19:50','',''),(2185013,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 16:19:50','',''),(2185050,'1','146','767',325,'Retail Sale Id 1289874',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 16:21:42','',''),(2185051,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 16:21:42','',''),(2185135,'1','146','767',325,'Retail Sale Id 1289910',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 16:25:47','',''),(2185136,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:25:47','',''),(2185179,'1','146','767',325,'Retail Sale Id 1289935',4499.20,0.00,0.00,0.00,337.44,'2021-12-06 16:28:31','',''),(2185180,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-06 16:28:31','',''),(2185209,'1','146','767',325,'Retail Sale Id 1289950',998.40,0.00,0.00,0.00,74.88,'2021-12-06 16:29:45','',''),(2185210,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 16:29:45','',''),(2185224,'1','146','767',325,'Retail Sale Id 1289959',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 16:30:28','',''),(2185225,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 16:30:28','',''),(2185240,'1','146','767',325,'Retail Sale Id 1289970',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 16:31:21','',''),(2185241,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 16:31:21','',''),(2185340,'1','146','767',325,'Retail Sale Id 1290015',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 16:36:24','',''),(2185341,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 16:36:24','',''),(2185448,'1','146','767',325,'Retail Sale Id 1290064',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 16:42:21','',''),(2185449,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 16:42:21','',''),(2185462,'1','146','767',325,'Retail Sale Id 1290070',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 16:43:12','',''),(2185463,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:43:12','',''),(2185500,'1','146','767',325,'Retail Sale Id 1290088',26297.60,0.00,0.00,0.00,1972.32,'2021-12-06 16:46:05','',''),(2185501,'1','146','767',325,'Retail sales',0.00,0.00,0.00,41.09,0.00,'2021-12-06 16:46:05','',''),(2185559,'1','146','767',325,'Retail Sale Id 1290116',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 16:48:13','',''),(2185560,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 16:48:13','',''),(2185581,'1','146','767',325,'Retail Sale Id 1290128',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 16:49:07','',''),(2185582,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 16:49:07','',''),(2185597,'1','146','767',325,'Retail Sale Id 1290136',2598.40,0.00,0.00,0.00,194.88,'2021-12-06 16:49:58','',''),(2185598,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-06 16:49:58','',''),(2185614,'1','146','767',325,'Retail Sale Id 1290144',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 16:50:48','',''),(2185615,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 16:50:48','',''),(2185643,'1','146','767',325,'Retail Sale Id 1290162',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 16:52:14','',''),(2185644,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 16:52:14','',''),(2185659,'1','146','767',325,'Retail Sale Id 1290167',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 16:53:11','',''),(2185660,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 16:53:11','',''),(2185676,'1','146','767',325,'Retail Sale Id 1290174',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 16:53:59','',''),(2185677,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 16:53:59','',''),(2185698,'1','146','767',325,'Retail Sale Id 1290187',32000.00,0.00,0.00,0.00,2400.00,'2021-12-06 16:55:41','',''),(2185699,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 16:55:41','',''),(2185734,'1','146','767',325,'Retail Sale Id 1290209',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 16:58:20','',''),(2185735,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:58:20','',''),(2185742,'1','146','767',325,'Retail Sale Id 1290214',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 16:58:55','',''),(2185743,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 16:58:55','',''),(2185881,'1','146','767',325,'Retail Sale Id 1290285',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 17:08:11','',''),(2185882,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:08:11','',''),(2185899,'1','146','767',325,'Retail Sale Id 1290296',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 17:09:20','',''),(2185900,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:09:20','',''),(2185955,'1','146','767',325,'Retail Sale Id 1290329',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 17:12:51','',''),(2185956,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 17:12:51','',''),(2186003,'1','146','767',325,'Retail Sale Id 1290353',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 17:16:54','',''),(2186004,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 17:16:54','',''),(2186015,'1','146','767',325,'Retail Sale Id 1290361',998.40,0.00,0.00,0.00,74.88,'2021-12-06 17:18:25','',''),(2186016,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 17:18:25','',''),(2186108,'1','146','767',325,'Retail Sale Id 1290408',998.40,0.00,0.00,0.00,74.88,'2021-12-06 17:27:21','',''),(2186109,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 17:27:21','',''),(2186128,'1','146','767',325,'Retail Sale Id 1290419',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 17:29:01','',''),(2186129,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 17:29:01','',''),(2186133,'1','146','767',325,'Retail Sale Id 1290421',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 17:29:41','',''),(2186134,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:29:41','',''),(2186192,'1','146','767',325,'Retail Sale Id 1290443',1497.60,0.00,0.00,0.00,112.32,'2021-12-06 17:35:52','',''),(2186193,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-06 17:35:52','',''),(2186197,'1','146','767',325,'Retail Sale Id 1290445',3001.60,0.00,0.00,0.00,225.12,'2021-12-06 17:36:36','',''),(2186198,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 17:36:36','',''),(2186209,'1','146','767',325,'Retail Sale Id 1290448',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 17:37:32','',''),(2186210,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 17:37:32','',''),(2186219,'1','146','767',325,'Retail Sale Id 1290454',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 17:38:33','',''),(2186220,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 17:38:33','',''),(2186315,'1','146','767',325,'Retail Sale Id 1290524',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 17:50:32','',''),(2186316,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 17:50:32','',''),(2186334,'1','146','767',325,'Retail Sale Id 1290533',16000.00,0.00,0.00,0.00,1200.00,'2021-12-06 17:53:00','',''),(2186335,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 17:53:00','',''),(2186343,'1','146','767',325,'Retail Sale Id 1290535',32000.00,0.00,0.00,0.00,2400.00,'2021-12-06 17:54:32','',''),(2186344,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 17:54:32','',''),(2186356,'1','146','767',325,'Retail Sale Id 1290545',5203.20,0.00,0.00,0.00,390.24,'2021-12-06 17:56:52','',''),(2186357,'1','146','767',325,'Retail sales',0.00,0.00,0.00,8.13,0.00,'2021-12-06 17:56:52','',''),(2186362,'1','146','767',325,'Retail Sale Id 1290546',2003.20,0.00,0.00,0.00,150.24,'2021-12-06 17:57:45','',''),(2186363,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 17:57:45','',''),(2186369,'1','146','767',325,'Retail Sale Id 1290549',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 17:58:45','',''),(2186370,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:58:45','',''),(2186405,'1','146','767',325,'Retail Sale Id 1290556',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 18:02:46','',''),(2186406,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 18:02:46','',''),(2186421,'1','146','767',325,'Retail Sale Id 1290559',8000.00,0.00,0.00,0.00,600.00,'2021-12-06 18:07:19','',''),(2186422,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 18:07:19','',''),(2186519,'1','146','767',325,'Retail Sale Id 1290572',4000.00,0.00,0.00,0.00,300.00,'2021-12-06 18:38:41','',''),(2186520,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-06 18:38:41','',''),(2186593,'1','146','767',325,'Return of Retail Sale Id 1290443',0.00,1497.60,2.34,0.00,-112.32,'2021-12-06 19:37:01','',''),(2186594,'1','146','767',325,'Retail Sale Id 1290593',998.40,0.00,0.00,0.00,74.88,'2021-12-06 19:37:44','',''),(2186595,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 19:37:44','',''),(2186998,'1','146','767',325,'Retail Sale Id 1290609',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 05:24:32','',''),(2186999,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 05:24:32','',''),(2187017,'1','146','767',325,'Retail Sale Id 1290610',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 05:26:09','',''),(2187018,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 05:26:09','',''),(2187021,'1','146','767',325,'Retail Sale Id 1290612',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 05:27:23','',''),(2187022,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 05:27:23','',''),(2187035,'1','146','767',325,'Retail Sale Id 1290613',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 05:28:22','',''),(2187036,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 05:28:22','',''),(2187037,'1','146','767',325,'Retail Sale Id 1290614',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 05:29:49','',''),(2187038,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 05:29:49','',''),(2187039,'1','146','767',325,'Retail Sale Id 1290615',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 05:30:49','',''),(2187040,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 05:30:49','',''),(2187053,'1','146','767',325,'Retail Sale Id 1290617',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 05:31:56','',''),(2187054,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 05:31:56','',''),(2187090,'1','146','767',325,'Retail Sale Id 1290630',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 05:48:35','',''),(2187091,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 05:48:35','',''),(2187092,'1','146','767',325,'Retail Sale Id 1290631',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 05:49:44','',''),(2187093,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 05:49:44','',''),(2187094,'1','146','767',325,'Retail Sale Id 1290632',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 05:51:03','',''),(2187095,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 05:51:03','',''),(2187096,'1','146','767',325,'Retail Sale Id 1290633',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 05:52:08','',''),(2187097,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 05:52:08','',''),(2187100,'1','146','767',325,'Retail Sale Id 1290635',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 05:53:23','',''),(2187101,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 05:53:23','',''),(2187108,'1','146','767',325,'Retail Sale Id 1290640',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 05:54:22','',''),(2187109,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 05:54:22','',''),(2187114,'1','146','767',325,'Retail Sale Id 1290642',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 05:55:26','',''),(2187115,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 05:55:26','',''),(2187124,'1','146','767',325,'Retail Sale Id 1290647',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 05:56:29','',''),(2187125,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 05:56:29','',''),(2187132,'1','146','767',325,'Retail Sale Id 1290651',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 05:57:47','',''),(2187133,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 05:57:47','',''),(2187140,'1','146','767',325,'Retail Sale Id 1290655',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 05:59:01','',''),(2187141,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 05:59:01','',''),(2187146,'1','146','767',325,'Retail Sale Id 1290658',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 06:00:04','',''),(2187147,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 06:00:04','',''),(2187166,'1','146','767',325,'Retail Sale Id 1290672',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 06:02:28','',''),(2187167,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:02:28','',''),(2187178,'1','146','767',325,'Retail Sale Id 1290677',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 06:03:35','',''),(2187179,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 06:03:35','',''),(2187188,'1','146','767',325,'Retail Sale Id 1290683',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 06:04:40','',''),(2187189,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 06:04:40','',''),(2187204,'1','146','767',325,'Retail Sale Id 1290689',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 06:05:42','',''),(2187205,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 06:05:42','',''),(2187216,'1','146','767',325,'Retail Sale Id 1290695',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 06:06:48','',''),(2187217,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 06:06:48','',''),(2187232,'1','146','767',325,'Retail Sale Id 1290703',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 06:08:21','',''),(2187233,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 06:08:21','',''),(2187252,'1','146','767',325,'Retail Sale Id 1290713',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 06:10:23','',''),(2187253,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:10:23','',''),(2187266,'1','146','767',325,'Retail Sale Id 1290720',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 06:11:43','',''),(2187267,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:11:43','',''),(2187283,'1','146','767',325,'Retail Sale Id 1290725',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 06:13:00','',''),(2187284,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 06:13:00','',''),(2187368,'1','146','767',325,'Retail Sale Id 1290768',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 06:21:31','',''),(2187369,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 06:21:31','',''),(2187402,'1','146','767',325,'Retail Sale Id 1290784',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 06:23:32','',''),(2187403,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 06:23:32','',''),(2187416,'1','146','767',325,'Retail Sale Id 1290791',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 06:24:56','',''),(2187417,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:24:56','',''),(2187489,'1','146','767',325,'Retail Sale Id 1290828',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 06:31:14','',''),(2187490,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:31:14','',''),(2187505,'1','146','767',325,'Retail Sale Id 1290836',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 06:33:09','',''),(2187506,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 06:33:09','',''),(2187525,'1','146','767',325,'Retail Sale Id 1290846',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 06:34:30','',''),(2187526,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:34:30','',''),(2187545,'1','146','767',325,'Retail Sale Id 1290856',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 06:35:45','',''),(2187546,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:35:45','',''),(2187559,'1','146','767',325,'Retail Sale Id 1290865',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 06:36:46','',''),(2187560,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 06:36:46','',''),(2187745,'1','146','767',325,'Retail Sale Id 1290963',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 06:49:59','',''),(2187746,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:49:59','',''),(2187792,'1','146','767',325,'Retail Sale Id 1290978',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 06:51:30','',''),(2187793,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:51:30','',''),(2187821,'1','146','767',325,'Retail Sale Id 1290988',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 06:53:02','',''),(2187822,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 06:53:03','',''),(2187972,'1','146','767',325,'Retail Sale Id 1291059',6400.00,0.00,0.00,0.00,480.00,'2021-12-07 07:02:15','',''),(2187973,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 07:02:15','',''),(2188006,'1','146','767',325,'Retail Sale Id 1291078',16000.00,0.00,0.00,0.00,1200.00,'2021-12-07 07:03:58','',''),(2188007,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 07:03:58','',''),(2188038,'1','146','767',325,'Retail Sale Id 1291094',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 07:05:15','',''),(2188039,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:05:15','',''),(2188060,'1','146','767',325,'Retail Sale Id 1291105',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 07:06:19','',''),(2188061,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 07:06:19','',''),(2188080,'1','146','767',325,'Retail Sale Id 1291113',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 07:07:22','',''),(2188081,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 07:07:22','',''),(2188115,'1','146','767',325,'Retail Sale Id 1291130',4499.20,0.00,0.00,0.00,337.44,'2021-12-07 07:09:02','',''),(2188116,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-07 07:09:02','',''),(2188138,'1','146','767',325,'Retail Sale Id 1291143',2297.60,0.00,0.00,0.00,172.32,'2021-12-07 07:10:10','',''),(2188139,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.59,0.00,'2021-12-07 07:10:10','',''),(2188212,'1','146','767',325,'Retail Sale Id 1291177',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 07:13:31','',''),(2188213,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:13:31','',''),(2188290,'1','146','767',325,'Retail Sale Id 1291217',13600.00,0.00,0.00,0.00,1020.00,'2021-12-07 07:17:16','',''),(2188291,'1','146','767',325,'Retail sales',0.00,0.00,0.00,21.25,0.00,'2021-12-07 07:17:16','',''),(2188334,'1','146','767',325,'Retail Sale Id 1291242',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 07:19:11','',''),(2188335,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 07:19:11','',''),(2188356,'1','146','767',325,'Retail Sale Id 1291254',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 07:20:21','',''),(2188357,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:20:21','',''),(2188402,'1','146','767',325,'Retail Sale Id 1291277',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 07:22:25','',''),(2188403,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 07:22:25','',''),(2188448,'1','146','767',325,'Retail Sale Id 1291296',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 07:24:40','',''),(2188449,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 07:24:40','',''),(2188569,'1','146','767',325,'Retail Sale Id 1291356',12000.00,0.00,0.00,0.00,900.00,'2021-12-07 07:30:04','',''),(2188570,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-07 07:30:04','',''),(2188612,'1','146','767',325,'Retail Sale Id 1291380',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 07:31:49','',''),(2188613,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 07:31:49','',''),(2188642,'1','146','767',325,'Retail Sale Id 1291399',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 07:33:39','',''),(2188643,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:33:39','',''),(2188688,'1','146','767',325,'Retail Sale Id 1291420',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 07:35:54','',''),(2188689,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:35:54','',''),(2188766,'1','146','767',325,'Retail Sale Id 1291459',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 07:39:41','',''),(2188767,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 07:39:41','',''),(2188808,'1','146','767',325,'Retail Sale Id 1291480',43200.00,0.00,0.00,0.00,3240.00,'2021-12-07 07:41:40','',''),(2188809,'1','146','767',325,'Retail sales',0.00,0.00,0.00,67.50,0.00,'2021-12-07 07:41:40','',''),(2188854,'1','146','767',325,'Retail Sale Id 1291520',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 07:43:57','',''),(2188855,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 07:43:57','',''),(2188930,'1','146','767',325,'Retail Sale Id 1291566',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 07:48:40','',''),(2188931,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:48:40','',''),(2188953,'1','146','767',325,'Retail Sale Id 1291580',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 07:49:44','',''),(2188954,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 07:49:44','',''),(2188977,'1','146','767',325,'Retail Sale Id 1291592',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 07:51:19','',''),(2188978,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 07:51:19','',''),(2189323,'1','146','767',325,'Retail Sale Id 1291746',35001.60,0.00,0.00,0.00,2625.12,'2021-12-07 08:09:58','',''),(2189324,'1','146','767',325,'Retail sales',0.00,0.00,0.00,54.69,0.00,'2021-12-07 08:09:58','',''),(2189367,'1','146','767',325,'Retail Sale Id 1291770',998.40,0.00,0.00,0.00,74.88,'2021-12-07 08:12:43','',''),(2189368,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 08:12:43','',''),(2189465,'1','146','767',325,'Retail Sale Id 1291819',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 08:18:27','',''),(2189466,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 08:18:27','',''),(2189491,'1','146','767',325,'Retail Sale Id 1291833',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 08:19:54','',''),(2189492,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 08:19:54','',''),(2189563,'1','146','767',325,'Retail Sale Id 1291866',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 08:24:01','',''),(2189564,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 08:24:01','',''),(2189611,'1','146','767',325,'Retail Sale Id 1291888',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 08:27:21','',''),(2189612,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 08:27:21','',''),(2189627,'1','146','767',325,'Retail Sale Id 1291897',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 08:28:50','',''),(2189628,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:28:50','',''),(2189884,'1','146','767',325,'Retail Sale Id 1291999',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 08:41:49','',''),(2189885,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 08:41:49','',''),(2189916,'1','146','767',325,'Retail Sale Id 1292012',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 08:43:09','',''),(2189917,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:43:09','',''),(2189936,'1','146','767',325,'Retail Sale Id 1292024',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 08:44:27','',''),(2189937,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 08:44:27','',''),(2190049,'1','146','767',325,'Retail Sale Id 1292073',7001.60,0.00,0.00,0.00,525.12,'2021-12-07 08:49:34','',''),(2190050,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-07 08:49:34','',''),(2190206,'1','146','767',325,'Retail Sale Id 1292145',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 08:58:15','',''),(2190207,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:58:15','',''),(2190246,'1','146','767',325,'Retail Sale Id 1292166',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 09:01:15','',''),(2190247,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:01:15','',''),(2190271,'1','146','767',325,'Retail Sale Id 1292178',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 09:03:02','',''),(2190272,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 09:03:02','',''),(2190301,'1','146','767',325,'Retail Sale Id 1292193',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 09:05:35','',''),(2190302,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 09:05:35','',''),(2190413,'1','146','767',325,'Retail Sale Id 1292245',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 09:10:47','',''),(2190414,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 09:10:47','',''),(2190451,'1','146','767',325,'Retail Sale Id 1292267',2598.40,0.00,0.00,0.00,194.88,'2021-12-07 09:12:44','',''),(2190452,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-07 09:12:44','',''),(2190483,'1','146','767',325,'Retail Sale Id 1292282',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 09:14:31','',''),(2190484,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 09:14:31','',''),(2190535,'1','146','767',325,'Retail Sale Id 1292311',28998.40,0.00,0.00,0.00,2174.88,'2021-12-07 09:17:01','',''),(2190536,'1','146','767',325,'Retail sales',0.00,0.00,0.00,45.31,0.00,'2021-12-07 09:17:01','',''),(2190559,'1','146','767',325,'Retail Sale Id 1292322',6003.20,0.00,0.00,0.00,450.24,'2021-12-07 09:18:22','',''),(2190560,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-07 09:18:22','',''),(2190575,'1','146','767',325,'Retail Sale Id 1292330',4998.40,0.00,0.00,0.00,374.88,'2021-12-07 09:19:31','',''),(2190576,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-07 09:19:31','',''),(2190601,'1','146','767',325,'Retail Sale Id 1292343',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 09:20:41','',''),(2190602,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 09:20:41','',''),(2190625,'1','146','767',325,'Retail Sale Id 1292352',998.40,0.00,0.00,0.00,74.88,'2021-12-07 09:21:57','',''),(2190626,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 09:21:57','',''),(2190679,'1','146','767',325,'Retail Sale Id 1292376',6400.00,0.00,0.00,0.00,480.00,'2021-12-07 09:24:51','',''),(2190680,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 09:24:51','',''),(2190790,'1','146','767',325,'Retail Sale Id 1292425',7500.80,0.00,0.00,0.00,562.56,'2021-12-07 09:29:30','',''),(2190791,'1','146','767',325,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-07 09:29:30','',''),(2190816,'1','146','767',325,'Retail Sale Id 1292438',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 09:30:32','',''),(2190817,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 09:30:32','',''),(2190886,'1','146','767',325,'Retail Sale Id 1292472',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 09:34:09','',''),(2190887,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 09:34:09','',''),(2190918,'1','146','767',325,'Retail Sale Id 1292488',7500.80,0.00,0.00,0.00,562.56,'2021-12-07 09:36:05','',''),(2190919,'1','146','767',325,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-07 09:36:05','',''),(2191076,'1','146','767',325,'Retail Sale Id 1292572',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 09:44:41','',''),(2191077,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 09:44:41','',''),(2191088,'1','146','767',325,'Retail Sale Id 1292579',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 09:46:17','',''),(2191089,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:46:17','',''),(2191210,'1','146','767',325,'Retail Sale Id 1292647',40000.00,0.00,0.00,0.00,3000.00,'2021-12-07 09:55:42','',''),(2191211,'1','146','767',325,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-07 09:55:42','',''),(2191437,'1','146','767',325,'Retail Sale Id 1292756',40000.00,0.00,0.00,0.00,3000.00,'2021-12-07 10:10:51','',''),(2191440,'1','146','767',325,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-07 10:10:51','',''),(2191529,'1','146','767',325,'Retail Sale Id 1292812',1299.20,0.00,0.00,0.00,97.44,'2021-12-07 10:16:38','',''),(2191530,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-07 10:16:38','',''),(2191607,'1','146','767',325,'Retail Sale Id 1292852',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 10:22:37','',''),(2191608,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 10:22:37','',''),(2191694,'1','146','767',325,'Retail Sale Id 1292893',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 10:29:52','',''),(2191695,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 10:29:52','',''),(2191767,'1','146','767',325,'Retail Sale Id 1292934',12800.00,0.00,0.00,0.00,960.00,'2021-12-07 10:36:31','',''),(2191768,'1','146','767',325,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-07 10:36:31','',''),(2191819,'1','146','767',325,'Retail Sale Id 1292960',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 10:39:18','',''),(2191820,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 10:39:18','',''),(2191863,'1','146','767',325,'Retail Sale Id 1292984',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 10:41:24','',''),(2191864,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 10:41:24','',''),(2191891,'1','146','767',325,'Retail Sale Id 1292994',32000.00,0.00,0.00,0.00,2400.00,'2021-12-07 10:43:26','',''),(2191892,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 10:43:26','',''),(2191969,'1','146','767',325,'Retail Sale Id 1293023',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 10:46:29','',''),(2191970,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:46:29','',''),(2192014,'1','146','767',325,'Retail Sale Id 1293039',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 10:48:13','',''),(2192015,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:48:13','',''),(2192038,'1','146','767',325,'Retail Sale Id 1293060',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 10:50:10','',''),(2192039,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:50:10','',''),(2192102,'1','146','767',325,'Retail Sale Id 1293091',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 10:53:18','',''),(2192103,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:53:18','',''),(2192159,'1','146','767',325,'Retail Sale Id 1293120',36000.00,0.00,0.00,0.00,2700.00,'2021-12-07 10:56:34','',''),(2192160,'1','146','767',325,'Retail sales',0.00,0.00,0.00,56.25,0.00,'2021-12-07 10:56:34','',''),(2192223,'1','146','767',325,'Retail Sale Id 1293152',12000.00,0.00,0.00,0.00,900.00,'2021-12-07 11:00:25','',''),(2192224,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-07 11:00:25','',''),(2192326,'1','146','767',325,'Retail Sale Id 1293189',16000.00,0.00,0.00,0.00,1200.00,'2021-12-07 11:04:47','',''),(2192327,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 11:04:47','',''),(2192422,'1','146','767',325,'Retail Sale Id 1293235',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 11:09:38','',''),(2192423,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 11:09:38','',''),(2192516,'1','146','767',325,'Retail Sale Id 1293294',16000.00,0.00,0.00,0.00,1200.00,'2021-12-07 11:15:03','',''),(2192517,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 11:15:03','',''),(2192552,'1','146','767',325,'Retail Sale Id 1293313',1299.20,0.00,0.00,0.00,97.44,'2021-12-07 11:17:18','',''),(2192553,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-07 11:17:18','',''),(2192586,'1','146','767',325,'Retail Sale Id 1293344',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 11:19:47','',''),(2192587,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:19:47','',''),(2192658,'1','146','767',325,'Retail Sale Id 1293355',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 11:25:28','',''),(2192659,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 11:25:28','',''),(2192690,'1','146','767',325,'Retail Sale Id 1293411',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 11:28:22','',''),(2192691,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:28:22','',''),(2192714,'1','146','767',325,'Retail Sale Id 1293424',998.40,0.00,0.00,0.00,74.88,'2021-12-07 11:29:35','',''),(2192715,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 11:29:35','',''),(2192889,'1','146','767',325,'Retail Sale Id 1293510',1497.60,0.00,0.00,0.00,112.32,'2021-12-07 11:42:07','',''),(2192890,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-07 11:42:07','',''),(2192907,'1','146','767',325,'Retail Sale Id 1293521',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 11:43:12','',''),(2192908,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:43:12','',''),(2192965,'1','146','767',325,'Retail Sale Id 1293537',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 11:45:44','',''),(2192966,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:45:44','',''),(2193007,'1','146','767',325,'Retail Sale Id 1293558',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 11:49:35','',''),(2193008,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 11:49:35','',''),(2193023,'1','146','767',325,'Retail Sale Id 1293564',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 11:51:12','',''),(2193024,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 11:51:12','',''),(2193039,'1','146','767',325,'Retail Sale Id 1293575',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 11:52:36','',''),(2193040,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 11:52:36','',''),(2193191,'1','146','767',325,'Retail Sale Id 1293666',1299.20,0.00,0.00,0.00,97.44,'2021-12-07 12:07:14','',''),(2193192,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-07 12:07:14','',''),(2193247,'1','146','767',325,'Retail Sale Id 1293696',998.40,0.00,0.00,0.00,74.88,'2021-12-07 12:12:07','',''),(2193248,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 12:12:07','',''),(2193289,'1','146','767',325,'Retail Sale Id 1293716',20000.00,0.00,0.00,0.00,1500.00,'2021-12-07 12:15:11','',''),(2193290,'1','146','767',325,'Retail sales',0.00,0.00,0.00,31.25,0.00,'2021-12-07 12:15:11','',''),(2193405,'1','146','767',325,'Retail Sale Id 1293763',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 12:27:50','',''),(2193406,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 12:27:50','',''),(2193437,'1','146','767',325,'Retail Sale Id 1293801',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 12:29:24','',''),(2193438,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:29:24','',''),(2193501,'1','146','767',325,'Retail Sale Id 1293829',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 12:34:39','',''),(2193502,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 12:34:39','',''),(2193535,'1','146','767',325,'Retail Sale Id 1293847',16000.00,0.00,0.00,0.00,1200.00,'2021-12-07 12:37:01','',''),(2193536,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 12:37:01','',''),(2193561,'1','146','767',325,'Retail Sale Id 1293864',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 12:38:51','',''),(2193562,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:38:51','',''),(2193601,'1','146','767',325,'Retail Sale Id 1293883',998.40,0.00,0.00,0.00,74.88,'2021-12-07 12:42:05','',''),(2193602,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 12:42:05','',''),(2193725,'1','146','767',325,'Retail Sale Id 1293964',2502.40,0.00,0.00,0.00,187.68,'2021-12-07 12:51:23','',''),(2193726,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-07 12:51:23','',''),(2193989,'1','146','767',325,'Retail Sale Id 1294091',1900.80,0.00,0.00,0.00,142.56,'2021-12-07 13:08:36','',''),(2193990,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-07 13:08:36','',''),(2194149,'1','146','767',325,'Retail Sale Id 1294172',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 13:18:37','',''),(2194150,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:18:37','',''),(2194171,'1','146','767',325,'Retail Sale Id 1294184',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 13:20:03','',''),(2194172,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:20:03','',''),(2194396,'1','146','767',325,'Retail Sale Id 1294357',15001.60,0.00,0.00,0.00,1125.12,'2021-12-07 13:31:02','',''),(2194397,'1','146','767',325,'Retail sales',0.00,0.00,0.00,23.44,0.00,'2021-12-07 13:31:02','',''),(2194485,'1','146','767',325,'Retail Sale Id 1294392',11200.00,0.00,0.00,0.00,840.00,'2021-12-07 13:36:08','',''),(2194486,'1','146','767',325,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-07 13:36:08','',''),(2194538,'1','146','767',325,'Retail Sale Id 1294413',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 13:38:34','',''),(2194539,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:38:34','',''),(2194571,'1','146','767',325,'Retail Sale Id 1294429',10003.20,0.00,0.00,0.00,750.24,'2021-12-07 13:40:17','',''),(2194572,'1','146','767',325,'Retail sales',0.00,0.00,0.00,15.63,0.00,'2021-12-07 13:40:17','',''),(2194605,'1','146','767',325,'Retail Sale Id 1294446',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 13:43:15','',''),(2194606,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:43:15','',''),(2194649,'1','146','767',325,'Retail Sale Id 1294469',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 13:46:17','',''),(2194650,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:46:17','',''),(2194680,'1','146','767',325,'Retail Sale Id 1294485',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 13:48:18','',''),(2194681,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 13:48:18','',''),(2194751,'1','146','767',325,'Retail Sale Id 1294504',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 13:52:06','',''),(2194752,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 13:52:06','',''),(2194843,'1','146','767',325,'Retail Sale Id 1294556',2598.40,0.00,0.00,0.00,194.88,'2021-12-07 13:58:32','',''),(2194844,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-07 13:58:32','',''),(2195019,'1','146','767',325,'Retail Sale Id 1294643',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 14:09:32','',''),(2195020,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:09:32','',''),(2195394,'1','146','767',325,'Retail Sale Id 1294802',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 14:28:36','',''),(2195395,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:28:36','',''),(2195483,'1','146','767',325,'Retail Sale Id 1294847',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 14:34:24','',''),(2195484,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:34:24','',''),(2195521,'1','146','767',325,'Retail Sale Id 1294876',4499.20,0.00,0.00,0.00,337.44,'2021-12-07 14:36:37','',''),(2195522,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-07 14:36:37','',''),(2195563,'1','146','767',325,'Retail Sale Id 1294896',7001.60,0.00,0.00,0.00,525.12,'2021-12-07 14:38:39','',''),(2195564,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-07 14:38:39','',''),(2195577,'1','146','767',325,'Retail Sale Id 1294903',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 14:39:45','',''),(2195578,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 14:39:45','',''),(2195591,'1','146','767',325,'Retail Sale Id 1294909',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 14:40:53','',''),(2195592,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 14:40:53','',''),(2195619,'1','146','767',325,'Retail Sale Id 1294923',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 14:42:04','',''),(2195620,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 14:42:04','',''),(2195714,'1','146','767',325,'Retail Sale Id 1294969',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 14:46:35','',''),(2195715,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:46:35','',''),(2197423,'1','146','767',325,'Retail Sale Id 1295832',7129.60,0.00,0.00,0.00,534.72,'2021-12-07 16:12:51','',''),(2197424,'1','146','767',325,'Retail sales',0.00,0.00,0.00,11.14,0.00,'2021-12-07 16:12:51','',''),(2197522,'1','146',NULL,325,'Purchased from AA RANO NIGERIA LIMITED',0.00,1187534.24,2005.97,0.00,0.00,'2021-12-07 16:17:15','',''),(2197546,'1','146',NULL,325,'Reception corrector for bridging 126482',0.00,0.00,0.00,2005.97,0.00,'2021-12-07 16:18:20','',''),(2197547,'1','146','767',325,'Received from bridging 126482',0.00,0.00,2005.97,0.00,0.00,'2021-12-07 16:18:20','',''),(2197580,'1','146','767',325,'Retail Sale Id 1295921',3820.80,0.00,0.00,0.00,286.56,'2021-12-07 16:19:29','',''),(2197581,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.97,0.00,'2021-12-07 16:19:29','',''),(2197709,'1','146','767',325,'Retail Sale Id 1295989',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 16:26:04','',''),(2197710,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 16:26:04','',''),(2197773,'1','146','767',325,'Retail Sale Id 1296019',40000.00,0.00,0.00,0.00,3000.00,'2021-12-07 16:28:39','',''),(2197774,'1','146','767',325,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-07 16:28:39','',''),(2197807,'1','146','767',325,'Retail Sale Id 1296038',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 16:30:13','',''),(2197808,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 16:30:13','',''),(2197827,'1','146','767',325,'Retail Sale Id 1296048',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 16:31:24','',''),(2197828,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:31:24','',''),(2197860,'1','146','767',325,'Retail Sale Id 1296066',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 16:32:40','',''),(2197863,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:32:40','',''),(2197893,'1','146','767',325,'Retail Sale Id 1296080',5203.20,0.00,0.00,0.00,390.24,'2021-12-07 16:34:30','',''),(2197894,'1','146','767',325,'Retail sales',0.00,0.00,0.00,8.13,0.00,'2021-12-07 16:34:30','',''),(2197920,'1','146','767',325,'Retail Sale Id 1296096',902.40,0.00,0.00,0.00,67.68,'2021-12-07 16:36:04','',''),(2197921,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-07 16:36:04','',''),(2197942,'1','146','767',325,'Retail Sale Id 1296109',32000.00,0.00,0.00,0.00,2400.00,'2021-12-07 16:37:44','',''),(2197943,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 16:37:44','',''),(2197965,'1','146','767',325,'Retail Sale Id 1296125',3500.80,0.00,0.00,0.00,262.56,'2021-12-07 16:39:27','',''),(2197966,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-07 16:39:27','',''),(2197992,'1','146','767',325,'Retail Sale Id 1296137',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 16:40:55','',''),(2197993,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 16:40:55','',''),(2198010,'1','146','767',325,'Retail Sale Id 1296148',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 16:42:36','',''),(2198011,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:42:36','',''),(2198039,'1','146','767',325,'Retail Sale Id 1296160',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 16:44:05','',''),(2198040,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:44:05','',''),(2198057,'1','146','767',325,'Retail Sale Id 1296175',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 16:45:08','',''),(2198058,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:45:08','',''),(2198085,'1','146','767',325,'Retail Sale Id 1296187',12000.00,0.00,0.00,0.00,900.00,'2021-12-07 16:47:01','',''),(2198086,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-07 16:47:01','',''),(2198118,'1','146','767',325,'Retail Sale Id 1296204',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 16:48:47','',''),(2198119,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 16:48:47','',''),(2198135,'1','146','767',325,'Retail Sale Id 1296213',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 16:50:02','',''),(2198136,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:50:02','',''),(2198152,'1','146','767',325,'Retail Sale Id 1296221',12000.00,0.00,0.00,0.00,900.00,'2021-12-07 16:51:12','',''),(2198153,'1','146','767',325,'Retail sales',0.00,0.00,0.00,18.75,0.00,'2021-12-07 16:51:12','',''),(2198174,'1','146','767',325,'Retail Sale Id 1296230',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 16:52:24','',''),(2198175,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 16:52:24','',''),(2198238,'1','146','767',325,'Retail Sale Id 1296259',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 16:55:17','',''),(2198239,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 16:55:17','',''),(2198270,'1','146','767',325,'Retail Sale Id 1296282',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 16:56:39','',''),(2198271,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:56:39','',''),(2198302,'1','146','767',325,'Retail Sale Id 1296299',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 16:58:14','',''),(2198303,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 16:58:14','',''),(2198333,'1','146','767',325,'Retail Sale Id 1296314',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 16:59:38','',''),(2198334,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 16:59:38','',''),(2198349,'1','146','767',325,'Retail Sale Id 1296323',4499.20,0.00,0.00,0.00,337.44,'2021-12-07 17:00:59','',''),(2198350,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-07 17:00:59','',''),(2198384,'1','146','767',325,'Retail Sale Id 1296338',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 17:02:23','',''),(2198385,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 17:02:23','',''),(2198415,'1','146','767',325,'Retail Sale Id 1296349',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 17:03:58','',''),(2198416,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 17:03:58','',''),(2198437,'1','146','767',325,'Retail Sale Id 1296359',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 17:05:33','',''),(2198438,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 17:05:33','',''),(2198457,'1','146','767',325,'Retail Sale Id 1296370',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 17:07:09','',''),(2198458,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 17:07:09','',''),(2198480,'1','146','767',325,'Retail Sale Id 1296384',3500.80,0.00,0.00,0.00,262.56,'2021-12-07 17:08:18','',''),(2198481,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-07 17:08:18','',''),(2198496,'1','146','767',325,'Retail Sale Id 1296390',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 17:09:41','',''),(2198497,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:09:41','',''),(2198517,'1','146','767',325,'Retail Sale Id 1296399',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 17:10:54','',''),(2198518,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 17:10:54','',''),(2198569,'1','146','767',325,'Retail Sale Id 1296445',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 17:15:16','',''),(2198570,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 17:15:16','',''),(2198585,'1','146','767',325,'Retail Sale Id 1296452',998.40,0.00,0.00,0.00,74.88,'2021-12-07 17:16:38','',''),(2198586,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 17:16:38','',''),(2198611,'1','146','767',325,'Retail Sale Id 1296466',4000.00,0.00,0.00,0.00,300.00,'2021-12-07 17:18:31','',''),(2198612,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 17:18:31','',''),(2198633,'1','146','767',325,'Retail Sale Id 1296481',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 17:20:09','',''),(2198634,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:20:09','',''),(2198657,'1','146','767',325,'Retail Sale Id 1296495',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 17:22:13','',''),(2198658,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:22:13','',''),(2198669,'1','146','767',325,'Retail Sale Id 1296501',3001.60,0.00,0.00,0.00,225.12,'2021-12-07 17:23:14','',''),(2198670,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 17:23:14','',''),(2198703,'1','146','767',325,'Retail Sale Id 1296516',2003.20,0.00,0.00,0.00,150.24,'2021-12-07 17:26:08','',''),(2198704,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 17:26:08','',''),(2198722,'1','146','767',325,'Retail Sale Id 1296524',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 17:28:53','',''),(2198723,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:28:53','',''),(2198781,'1','146','767',325,'Retail Sale Id 1296550',12998.40,0.00,0.00,0.00,974.88,'2021-12-07 17:35:46','',''),(2198782,'1','146','767',325,'Retail sales',0.00,0.00,0.00,20.31,0.00,'2021-12-07 17:35:46','',''),(2198801,'1','146','767',325,'Retail Sale Id 1296560',6400.00,0.00,0.00,0.00,480.00,'2021-12-07 17:37:13','',''),(2198802,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 17:37:13','',''),(2198824,'1','146','767',325,'Retail Sale Id 1296572',4499.20,0.00,0.00,0.00,337.44,'2021-12-07 17:39:05','',''),(2198825,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-07 17:39:05','',''),(2198854,'1','146','767',325,'Retail Sale Id 1296582',6400.00,0.00,0.00,0.00,480.00,'2021-12-07 17:42:04','',''),(2198855,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 17:42:04','',''),(2198876,'1','146','767',325,'Retail Sale Id 1296588',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 17:43:57','',''),(2198877,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 17:43:57','',''),(2198948,'1','146','767',325,'Retail Sale Id 1296621',7500.80,0.00,0.00,0.00,562.56,'2021-12-07 17:49:46','',''),(2198949,'1','146','767',325,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-07 17:49:46','',''),(2198990,'1','146','767',325,'Retail Sale Id 1296636',3200.00,0.00,0.00,0.00,240.00,'2021-12-07 17:53:37','',''),(2198991,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 17:53:37','',''),(2199048,'1','146','767',325,'Retail Sale Id 1296649',499.20,0.00,0.00,0.00,37.44,'2021-12-07 17:57:58','',''),(2199049,'1','146','767',325,'Retail sales',0.00,0.00,0.00,0.78,0.00,'2021-12-07 17:57:58','',''),(2199054,'1','146','767',325,'Retail Sale Id 1296653',6003.20,0.00,0.00,0.00,450.24,'2021-12-07 17:59:13','',''),(2199055,'1','146','767',325,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-07 17:59:13','',''),(2199116,'1','146','767',325,'Retail Sale Id 1296678',8000.00,0.00,0.00,0.00,600.00,'2021-12-07 18:07:25','',''),(2199117,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 18:07:25','',''),(2199170,'1','146','767',325,'Return of Retail Sale Id 1296572',0.00,4499.20,7.03,0.00,-337.44,'2021-12-07 18:31:31','',''),(2199214,'1','146','767',325,'Retail Sale Id 1296724',40000.00,0.00,0.00,0.00,3000.00,'2021-12-07 18:49:04','',''),(2199215,'1','146','767',325,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-07 18:49:04','',''),(2199301,'1','146','767',325,'Return of Retail Sale Id 1296452',0.00,998.40,1.56,0.00,-74.88,'2021-12-07 19:24:26','',''),(2199570,'1','146',NULL,325,'Purchased from AA RANO NIGERIA LIMITED',0.00,1829280.00,3090.00,0.00,0.00,'2021-12-08 04:47:35','',''),(2199571,'1','146',NULL,325,'Reception corrector for bridging 126538',0.00,0.00,0.00,3090.00,0.00,'2021-12-08 04:48:44','',''),(2199572,'1','146','767',325,'Received from bridging 126538',0.00,0.00,3090.00,0.00,0.00,'2021-12-08 04:48:44','',''),(2199721,'1','146','767',325,'Retail Sale Id 1296777',7001.60,0.00,0.00,0.00,525.12,'2021-12-08 05:56:07','',''),(2199722,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-08 05:56:07','',''),(2199751,'1','146','767',325,'Retail Sale Id 1296793',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 06:04:55','',''),(2199752,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 06:04:55','',''),(2199768,'1','146','767',325,'Retail Sale Id 1296799',9600.00,0.00,0.00,0.00,720.00,'2021-12-08 06:08:48','',''),(2199769,'1','146','767',325,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-08 06:08:48','',''),(2199848,'1','146','767',325,'Retail Sale Id 1296825',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 06:19:55','',''),(2199849,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 06:19:55','',''),(2199882,'1','146','767',325,'Retail Sale Id 1296842',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 06:23:33','',''),(2199883,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 06:23:33','',''),(2199898,'1','146','767',325,'Retail Sale Id 1296850',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 06:25:36','',''),(2199899,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:25:36','',''),(2199916,'1','146','767',325,'Retail Sale Id 1296857',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 06:27:29','',''),(2199917,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:27:29','',''),(2199936,'1','146','767',325,'Retail Sale Id 1296868',998.40,0.00,0.00,0.00,74.88,'2021-12-08 06:30:14','',''),(2199937,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 06:30:14','',''),(2199948,'1','146','767',325,'Retail Sale Id 1296875',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 06:32:37','',''),(2199949,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 06:32:37','',''),(2199958,'1','146','767',325,'Retail Sale Id 1296880',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 06:33:33','',''),(2199959,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 06:33:33','',''),(2200006,'1','146','767',325,'Retail Sale Id 1296903',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 06:37:25','',''),(2200007,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:37:25','',''),(2200046,'1','146','767',325,'Retail Sale Id 1296920',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 06:39:49','',''),(2200047,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 06:39:49','',''),(2200079,'1','146','767',325,'Retail Sale Id 1296931',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 06:41:25','',''),(2200080,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:41:25','',''),(2200115,'1','146','767',325,'Retail Sale Id 1296947',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 06:44:13','',''),(2200116,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:44:13','',''),(2200141,'1','146','767',325,'Retail Sale Id 1296961',1203.20,0.00,0.00,0.00,90.24,'2021-12-08 06:45:32','',''),(2200142,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-08 06:45:32','',''),(2200229,'1','146','767',325,'Retail Sale Id 1296984',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 06:48:31','',''),(2200230,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:48:31','',''),(2200343,'1','146','767',325,'Retail Sale Id 1297027',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 06:55:12','',''),(2200344,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:55:12','',''),(2200361,'1','146','767',325,'Retail Sale Id 1297034',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 06:55:52','',''),(2200362,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:55:52','',''),(2200393,'1','146','767',325,'Retail Sale Id 1297051',640.00,0.00,0.00,0.00,48.00,'2021-12-08 06:57:26','',''),(2200394,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 06:57:26','',''),(2200403,'1','146','767',325,'Retail Sale Id 1297056',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 06:58:01','',''),(2200404,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:58:01','',''),(2200412,'1','146','767',325,'Return of Retail Sale Id 1297051',0.00,640.00,1.00,0.00,-48.00,'2021-12-08 06:58:48','',''),(2200429,'1','146','767',325,'Retail Sale Id 1297068',8998.40,0.00,0.00,0.00,674.88,'2021-12-08 06:59:25','',''),(2200430,'1','146','767',325,'Retail sales',0.00,0.00,0.00,14.06,0.00,'2021-12-08 06:59:25','',''),(2200471,'1','146','767',325,'Retail Sale Id 1297089',3500.80,0.00,0.00,0.00,262.56,'2021-12-08 07:02:15','',''),(2200472,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.47,0.00,'2021-12-08 07:02:15','',''),(2200483,'1','146','767',325,'Retail Sale Id 1297095',7001.60,0.00,0.00,0.00,525.12,'2021-12-08 07:03:11','',''),(2200484,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-08 07:03:11','',''),(2200499,'1','146','767',325,'Retail Sale Id 1297094',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 07:04:02','',''),(2200500,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:04:02','',''),(2200537,'1','146','767',325,'Retail Sale Id 1297121',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 07:06:18','',''),(2200538,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:06:18','',''),(2200547,'1','146','767',325,'Retail Sale Id 1297127',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 07:06:50','',''),(2200548,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 07:06:50','',''),(2200619,'1','146','767',325,'Retail Sale Id 1297161',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 07:12:40','',''),(2200620,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:12:40','',''),(2200661,'1','146','767',325,'Retail Sale Id 1297184',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 07:15:31','',''),(2200662,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 07:15:31','',''),(2200798,'1','146','767',325,'Retail Sale Id 1297240',22400.00,0.00,0.00,0.00,1680.00,'2021-12-08 07:21:23','',''),(2200799,'1','146','767',325,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-08 07:21:23','',''),(2200826,'1','146','767',325,'Retail Sale Id 1297253',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 07:22:54','',''),(2200827,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:22:54','',''),(2200883,'1','146','767',325,'Retail Sale Id 1297286',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 07:26:26','',''),(2200884,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:26:26','',''),(2200903,'1','146','767',325,'Retail Sale Id 1297293',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 07:27:49','',''),(2200904,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 07:27:49','',''),(2200920,'1','146','767',325,'Retail Sale Id 1297303',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 07:28:57','',''),(2200921,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 07:28:57','',''),(2200940,'1','146','767',325,'Retail Sale Id 1297314',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 07:30:08','',''),(2200941,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 07:30:08','',''),(2200965,'1','146','767',325,'Retail Sale Id 1297319',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 07:30:49','',''),(2200966,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:30:49','',''),(2201027,'1','146','767',325,'Retail Sale Id 1297348',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 07:33:52','',''),(2201028,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 07:33:52','',''),(2201192,'1','146','767',325,'Retail Sale Id 1297421',16000.00,0.00,0.00,0.00,1200.00,'2021-12-08 07:42:18','',''),(2201193,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 07:42:18','',''),(2201204,'1','146','767',325,'Retail Sale Id 1297428',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 07:43:00','',''),(2201205,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 07:43:00','',''),(2201214,'1','146','767',325,'Retail Sale Id 1297433',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 07:43:37','',''),(2201215,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 07:43:37','',''),(2201228,'1','146','767',325,'Retail Sale Id 1297441',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 07:45:02','',''),(2201229,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 07:45:02','',''),(2201310,'1','146','767',325,'Retail Sale Id 1297482',16000.00,0.00,0.00,0.00,1200.00,'2021-12-08 07:50:05','',''),(2201311,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 07:50:05','',''),(2201349,'1','146','767',325,'Retail Sale Id 1297498',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 07:51:26','',''),(2201350,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:51:26','',''),(2201363,'1','146','767',325,'Retail Sale Id 1297507',16000.00,0.00,0.00,0.00,1200.00,'2021-12-08 07:52:22','',''),(2201364,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 07:52:22','',''),(2201549,'1','146','767',325,'Retail Sale Id 1297577',40000.00,0.00,0.00,0.00,3000.00,'2021-12-08 08:00:09','',''),(2201550,'1','146','767',325,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-08 08:00:09','',''),(2201651,'1','146','767',325,'Retail Sale Id 1297626',998.40,0.00,0.00,0.00,74.88,'2021-12-08 08:05:05','',''),(2201652,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 08:05:05','',''),(2201665,'1','146','767',325,'Retail Sale Id 1297633',5203.20,0.00,0.00,0.00,390.24,'2021-12-08 08:05:50','',''),(2201666,'1','146','767',325,'Retail sales',0.00,0.00,0.00,8.13,0.00,'2021-12-08 08:05:50','',''),(2201730,'1','146','767',325,'Retail Sale Id 1297669',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 08:11:05','',''),(2201731,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 08:11:05','',''),(2201736,'1','146','767',325,'Retail Sale Id 1297672',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 08:11:38','',''),(2201737,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 08:11:38','',''),(2201746,'1','146','767',325,'Retail Sale Id 1297677',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 08:12:14','',''),(2201747,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:12:14','',''),(2201758,'1','146','767',325,'Retail Sale Id 1297685',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 08:13:22','',''),(2201759,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 08:13:22','',''),(2201770,'1','146','767',325,'Retail Sale Id 1297690',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 08:14:03','',''),(2201771,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 08:14:03','',''),(2201789,'1','146','767',325,'Retail Sale Id 1297699',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 08:15:13','',''),(2201790,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:15:13','',''),(2201813,'1','146','767',325,'Retail Sale Id 1297705',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 08:16:37','',''),(2201814,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:16:37','',''),(2201851,'1','146','767',325,'Retail Sale Id 1297722',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 08:19:00','',''),(2201852,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:19:00','',''),(2201869,'1','146','767',325,'Retail Sale Id 1297740',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 08:20:20','',''),(2201870,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:20:20','',''),(2201891,'1','146','767',325,'Retail Sale Id 1297754',11001.60,0.00,0.00,0.00,825.12,'2021-12-08 08:21:33','',''),(2201892,'1','146','767',325,'Retail sales',0.00,0.00,0.00,17.19,0.00,'2021-12-08 08:21:33','',''),(2201913,'1','146','767',325,'Retail Sale Id 1297769',7001.60,0.00,0.00,0.00,525.12,'2021-12-08 08:22:48','',''),(2201914,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-08 08:22:48','',''),(2201925,'1','146','767',325,'Retail Sale Id 1297763',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 08:23:43','',''),(2201926,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:23:43','',''),(2201937,'1','146','767',325,'Retail Sale Id 1297779',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 08:24:18','',''),(2201938,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:24:18','',''),(2201945,'1','146','767',325,'Retail Sale Id 1297783',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 08:25:19','',''),(2201946,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 08:25:19','',''),(2201959,'1','146','767',325,'Retail Sale Id 1297791',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 08:26:20','',''),(2201960,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 08:26:20','',''),(2202004,'1','146','767',325,'Retail Sale Id 1297780',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 08:28:36','',''),(2202005,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 08:28:36','',''),(2202016,'1','146','767',325,'Retail Sale Id 1297812',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 08:29:22','',''),(2202017,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 08:29:22','',''),(2202024,'1','146','767',325,'Retail Sale Id 1297817',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 08:30:02','',''),(2202025,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 08:30:02','',''),(2202034,'1','146','767',325,'Retail Sale Id 1297822',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 08:30:52','',''),(2202035,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 08:30:52','',''),(2202052,'1','146','767',325,'Retail Sale Id 1297828',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 08:31:58','',''),(2202053,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 08:31:58','',''),(2202066,'1','146','767',325,'Retail Sale Id 1297835',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 08:32:42','',''),(2202067,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 08:32:42','',''),(2202084,'1','146','767',325,'Retail Sale Id 1297844',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 08:34:08','',''),(2202085,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 08:34:08','',''),(2202094,'1','146','767',325,'Retail Sale Id 1297852',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 08:35:02','',''),(2202095,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 08:35:02','',''),(2202132,'1','146','767',325,'Retail Sale Id 1297869',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 08:36:34','',''),(2202133,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:36:34','',''),(2202148,'1','146','767',325,'Retail Sale Id 1297874',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 08:38:03','',''),(2202149,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 08:38:03','',''),(2202172,'1','146','767',325,'Retail Sale Id 1297889',998.40,0.00,0.00,0.00,74.88,'2021-12-08 08:39:22','',''),(2202173,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 08:39:22','',''),(2202206,'1','146','767',325,'Retail Sale Id 1297899',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 08:40:28','',''),(2202207,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:40:28','',''),(2202240,'1','146','767',325,'Retail Sale Id 1297908',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 08:41:54','',''),(2202241,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 08:41:54','',''),(2202260,'1','146','767',325,'Retail Sale Id 1297915',6400.00,0.00,0.00,0.00,480.00,'2021-12-08 08:42:43','',''),(2202261,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 08:42:43','',''),(2202346,'1','146','767',325,'Retail Sale Id 1297937',16000.00,0.00,0.00,0.00,1200.00,'2021-12-08 08:45:45','',''),(2202347,'1','146','767',325,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 08:45:45','',''),(2202403,'1','146','767',325,'Retail Sale Id 1297956',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 08:48:00','',''),(2202404,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:48:00','',''),(2202432,'1','146','767',325,'Retail Sale Id 1297966',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 08:49:36','',''),(2202433,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:49:36','',''),(2202482,'1','146','767',325,'Retail Sale Id 1297982',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 08:51:59','',''),(2202483,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 08:51:59','',''),(2202568,'1','146','767',325,'Retail Sale Id 1298019',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 08:55:46','',''),(2202569,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:55:46','',''),(2202762,'1','146','767',325,'Retail Sale Id 1298127',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 09:08:00','',''),(2202763,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 09:08:00','',''),(2202864,'1','146','767',325,'Retail Sale Id 1298172',40000.00,0.00,0.00,0.00,3000.00,'2021-12-08 09:13:44','',''),(2202865,'1','146','767',325,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-08 09:13:44','',''),(2202904,'1','146','767',325,'Retail Sale Id 1298189',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 09:16:17','',''),(2202905,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:16:17','',''),(2202928,'1','146','767',325,'Retail Sale Id 1298199',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 09:17:17','',''),(2202929,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 09:17:17','',''),(2202954,'1','146','767',325,'Retail Sale Id 1298214',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 09:19:01','',''),(2202955,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 09:19:01','',''),(2202968,'1','146','767',325,'Retail Sale Id 1298221',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 09:19:46','',''),(2202969,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 09:19:46','',''),(2202993,'1','146','767',325,'Retail Sale Id 1298232',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 09:21:46','',''),(2202994,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 09:21:46','',''),(2203039,'1','146','767',325,'Retail Sale Id 1298256',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 09:26:14','',''),(2203040,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:26:14','',''),(2203081,'1','146','767',325,'Retail Sale Id 1298276',3200.00,0.00,0.00,0.00,240.00,'2021-12-08 09:30:05','',''),(2203082,'1','146','767',325,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 09:30:05','',''),(2203099,'1','146','767',325,'Retail Sale Id 1298287',3001.60,0.00,0.00,0.00,225.12,'2021-12-08 09:32:00','',''),(2203100,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-08 09:32:00','',''),(2203137,'1','146','767',325,'Retail Sale Id 1298306',32000.00,0.00,0.00,0.00,2400.00,'2021-12-08 09:35:12','',''),(2203138,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 09:35:12','',''),(2203330,'1','146','767',325,'Retail Sale Id 1298395',1497.60,0.00,0.00,0.00,112.32,'2021-12-08 09:48:53','',''),(2203331,'1','146','767',325,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 09:48:53','',''),(2203370,'1','146','767',325,'Retail Sale Id 1298414',7398.40,0.00,0.00,0.00,554.88,'2021-12-08 09:51:26','',''),(2203371,'1','146','767',325,'Retail sales',0.00,0.00,0.00,11.56,0.00,'2021-12-08 09:51:26','',''),(2203404,'1','146','767',325,'Retail Sale Id 1298433',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 09:55:09','',''),(2203405,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 09:55:09','',''),(2203442,'1','146','767',325,'Retail Sale Id 1298453',4000.00,0.00,0.00,0.00,300.00,'2021-12-08 09:58:18','',''),(2203443,'1','146','767',325,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 09:58:18','',''),(2203455,'1','146','767',325,'Retail Sale Id 1298458',32000.00,0.00,0.00,0.00,2400.00,'2021-12-08 09:58:58','',''),(2203456,'1','146','767',325,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 09:58:58','',''),(2203536,'1','146','767',325,'Retail Sale Id 1298488',7001.60,0.00,0.00,0.00,525.12,'2021-12-08 10:03:57','',''),(2203537,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-08 10:03:57','',''),(2203588,'1','146','767',325,'Retail Sale Id 1298513',4499.20,0.00,0.00,0.00,337.44,'2021-12-08 10:08:05','',''),(2203589,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-08 10:08:05','',''),(2203600,'1','146','767',325,'Retail Sale Id 1298521',998.40,0.00,0.00,0.00,74.88,'2021-12-08 10:08:59','',''),(2203601,'1','146','767',325,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 10:08:59','',''),(2203621,'1','146','767',325,'Retail Sale Id 1298527',6502.40,0.00,0.00,0.00,487.68,'2021-12-08 10:09:55','',''),(2203622,'1','146','767',325,'Retail sales',0.00,0.00,0.00,10.16,0.00,'2021-12-08 10:09:55','',''),(2203683,'1','146','767',325,'Retail Sale Id 1298556',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 10:13:28','',''),(2203684,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:13:28','',''),(2203703,'1','146','767',325,'Retail Sale Id 1298566',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 10:14:34','',''),(2203704,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:14:34','',''),(2203881,'1','146','767',325,'Retail Sale Id 1298656',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 10:25:46','',''),(2203882,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:25:46','',''),(2203909,'1','146','767',325,'Retail Sale Id 1298665',4998.40,0.00,0.00,0.00,374.88,'2021-12-08 10:26:51','',''),(2203910,'1','146','767',325,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-08 10:26:51','',''),(2203927,'1','146','767',325,'Retail Sale Id 1298674',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 10:27:56','',''),(2203928,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:27:56','',''),(2204035,'1','146','767',325,'Retail Sale Id 1298719',30803.20,0.00,0.00,0.00,2310.24,'2021-12-08 10:34:30','',''),(2204036,'1','146','767',325,'Retail sales',0.00,0.00,0.00,48.13,0.00,'2021-12-08 10:34:30','',''),(2204106,'1','146','767',325,'Retail Sale Id 1298759',2598.40,0.00,0.00,0.00,194.88,'2021-12-08 10:41:21','',''),(2204107,'1','146','767',325,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-08 10:41:21','',''),(2204416,'1','146','767',325,'Retail Sale Id 1298915',2003.20,0.00,0.00,0.00,150.24,'2021-12-08 11:07:28','',''),(2204417,'1','146','767',325,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 11:07:28','',''),(2204448,'1','146','767',325,'Retail Sale Id 1298929',8000.00,0.00,0.00,0.00,600.00,'2021-12-08 11:08:35','',''),(2204449,'1','146','767',325,'Retail sales',0.00,0.00,0.00,12.50,0.00,'202