-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_145
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_145`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_145` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_145`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3214 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2837,400116,'',0,'22','1','145','PURCHASES','','2020-10-06 13:16:07',5,0.00,0.00,'','479','2020-10-06 13:16:07','479',0,1),(2838,20032,'',0,'20','1','145','SALES','','2020-10-06 13:16:36',5,0.00,0.00,'','479','2020-10-06 13:16:36','479',0,1),(2839,40031,'',0,'6.1','1','145','CASH','','2020-10-06 13:16:53',5,0.00,0.00,'','479','2020-10-06 13:16:53','479',0,1),(2840,400209,'',0,'24','1','145','SALARIES & WAGES','','2020-10-06 13:17:15',5,0.00,0.00,'','479','2020-10-06 13:17:15','479',0,1),(2841,400210,'',0,'24','1','145','PURCHASES','','2020-10-06 13:17:35',5,0.00,0.00,'','479','2020-10-06 13:17:35','479',0,1),(2842,400283,'',0,'2','1','145','DANKANO-EBILLS(ZNB:1014717618)','','2020-10-06 13:20:06',5,0.00,0.00,'','479','2020-10-06 13:20:06','479',0,1),(3208,400487,'',0,'2','1','145','FID POS COLLECTION-5620141491','','2021-02-26 16:01:25',5,0.00,0.00,'','489','2021-02-26 16:01:25','489',0,1),(3211,400488,'',0,'2','1','145','POLARIS  CALABAR:-4091583216','','2022-07-05 16:48:32',5,0.00,0.00,'2022-07-05','792','2022-07-05 16:52:17','792',0,0),(3212,400489,'',0,'2','1','145','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:48:22',5,0.00,0.00,'','792','2023-02-20 14:48:22','792',0,0),(3213,400490,'',0,'2','1','145','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:51:24',5,0.00,0.00,'2023-03-15','792','2023-03-17 14:09:52','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3447 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1689,'','1','145','END USERS','CALABAR','08033609616','amohammed2727@gmail.com','CALABAR','CR','TECHNICAL ROUND ABOUT','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-10-08 13:17:28',5,'542','2020-10-08 13:17:28','542'),(1690,'','1','145','WINZ GAS','WINZ GAS','08063885128','winzgas@gmails.com','CALABAR','CR','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-10-08 13:22:11',5,'542','2020-10-08 13:22:11','542'),(1691,'','1','145','ALL DEALERS','ALL DEALERS','08033609616','alldealers@gmail.com','CALABAR','CR','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-10-08 13:23:29',5,'542','2020-10-08 13:23:29','542'),(1718,'','1','145','OPERATIONAL LOSS','HAFIZ NURA GAYA','08069129774','hgaya@aaranonigeria.com','KANO','KANO','AA RANO HOUSE HOTORO.','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-10-28 14:05:28',5,'479','2020-10-28 14:05:28','479'),(1886,'','1','145','VICTOR GAS','MR VICTOR','08037967257','victorgas@yahoo.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-12-01 19:40:54',5,'542','2020-12-01 19:40:54','542'),(1999,'','1','145','HENIC GAS','TUNJI','08078536585','@gmail.com','CALABAR','CROSS RIVER','BYE PASS CALABAR.','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-05 21:45:09',5,'542','2021-02-05 21:45:09','542'),(2443,'','1','145','BLUEFLAME GAS','EMMUAEL','07032593107','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-29 18:37:30',5,'542','2021-03-29 18:37:30','542'),(2444,'','1','145','EVERYDAY GAS','JUSTIN','08178803411','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-29 18:38:27',5,'542','2021-03-29 18:38:27','542'),(2445,'','1','145','JAY GAS','JOHN','08071767783','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-29 18:39:30',5,'542','2021-03-29 18:39:30','542'),(2446,'','1','145','ASSURANCE GAS','ALLI','09062314568','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-29 18:40:42',5,'542','2021-03-29 18:40:42','542'),(2447,'','1','145','O GAS','ABEL','07066231643','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-29 18:42:33',5,'542','2021-03-29 18:42:33','542'),(2448,'','1','145','FAMOUS GAS','OLIVER','08032587941','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-29 18:43:35',5,'542','2021-03-29 18:43:35','542'),(2449,'','1','145','CUCHEL','CHUKWUMA','08037006157','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-29 18:45:43',5,'542','2021-03-29 18:45:43','542'),(2450,'','1','145','DEALER','MAURICE','08034274485','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-30 07:39:37',5,'542','2021-03-30 07:39:37','542'),(2452,'','1','145','STUDENT ','JEHU','08175891320','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-30 09:50:06',5,'542','2021-03-30 09:50:06','542'),(2967,'','1','145','BANKU GAS','BANKU','07017785104','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-21 11:06:56',5,'542','2021-07-21 11:06:56','542'),(2968,'','1','145','CLEMENT GAS','CLEMENT','07088362014','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-21 11:13:26',5,'542','2021-07-21 11:13:26','542'),(2969,'','1','145','SPENCER GAS','SPENCER','08064490793','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-21 11:20:19',5,'542','2021-07-21 11:20:19','542'),(2970,'','1','145','NOBLE GAS','NOBLE','08096035226','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-21 11:21:41',5,'542','2021-07-21 11:21:41','542'),(2971,'','1','145','ANI AKPAN GAS','ANI AKPAN','09070904090','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-21 11:23:45',5,'542','2021-07-21 11:23:45','542'),(2972,'','1','145','CHARLES GAS','CHARLES','07035401395','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-21 11:31:02',5,'542','2021-07-21 11:31:02','542'),(2973,'','1','145','ANA GAS','ANA','07049137945','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-21 11:44:21',5,'542','2021-07-21 11:44:21','542'),(2974,'','1','145','O CLERKS','O CLERKS','07035894606','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-21 11:46:25',5,'542','2021-07-21 11:46:25','542'),(2975,'','1','145','ALPHA GAS','ALPHA','08127056960','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-21 11:54:09',5,'542','2021-07-21 11:54:09','542'),(2976,'','1','145','PTEX GAS','PTEX','08165617213','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-21 12:01:28',5,'542','2021-07-21 12:01:28','542'),(2982,'','1','145','U ARE D BEST','U ARE D BEST','07034453728','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-25 10:56:26',5,'542','2021-07-25 10:56:26','542'),(2991,'','1','145','RICHIE GAS','RICHIE','08185179857','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-28 12:26:34',5,'542','2021-07-28 12:26:34','542'),(3076,'','1','145','NAMNOMI GAS','NAMNOMI','09080071158','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-14 14:56:45',5,'542','2021-08-14 14:56:45','542'),(3141,'','1','145','NATH GAS','NATH','07069779548','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-22 14:45:34',5,'542','2021-08-22 14:45:34','542'),(3158,'','1','145','VERSSMEN ENERGY','VERSSMEN','08032984353','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-28 12:14:05',5,'542','2021-08-28 12:14:05','542'),(3196,'','1','145','SIMEON GAS','SIMEON','07062419459','@gmail.com','CALABAR','CRS','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-08 08:47:43',5,'542','2021-09-08 08:47:43','542'),(3197,'','1','145','APPLES GAS','APPLES','08064248734','@gmail.com','CALABAR','CRS','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-08 10:14:49',5,'542','2021-09-08 10:14:49','542'),(3200,'','1','145','CHRIZ GAS','CHRIS','07031927138','@gmail.com','CALABAR','CRS','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-08 10:46:58',5,'542','2021-09-08 10:46:58','542'),(3201,'','1','145','WILLIAMS GAS','WILLIAMS','08143224813','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-08 12:24:45',5,'542','2021-09-08 12:24:45','542'),(3216,'','1','145','BENLEO','BEN','07038331510','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-10 07:58:02',5,'542','2021-09-10 07:58:02','542'),(3217,'','1','145',' MOSES GAS','MOSES','08068397999','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-10 08:04:24',5,'542','2021-09-10 08:04:24','542'),(3218,'','1','145','PUIS GAS','PUIS','09060862362','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-10 08:36:20',5,'542','2021-09-10 08:36:20','542'),(3219,'','1','145','EMMAH GAS','EMMANUEL ','08147783858','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-10 11:09:35',5,'542','2021-09-10 11:09:35','542'),(3220,'','1','145','E A UDOH GAS','E A UDOH','08039097867','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-10 12:32:32',5,'542','2021-09-10 12:32:32','542'),(3221,'','1','145','OFON GAS','OFON','09035958839','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-10 15:37:08',5,'542','2021-09-10 15:37:08','542'),(3222,'','1','145','BLESSED GAS','BLESSED','09092587495','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-11 09:39:03',5,'542','2021-09-11 09:39:03','542'),(3274,'','1','145','BLUE PRINT','EDIMA','08087551384','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-15 09:18:52',5,'542','2021-09-15 09:18:52','542'),(3431,'','1','145','ASU GAS','ASUQUO','08035749249','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-10 13:32:50',5,'542','2021-10-10 13:32:50','542'),(3433,'','1','145','GLODAVOUR GAS','JESHAIH','08057251762','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-10 18:51:25',5,'542','2021-10-10 18:51:25','542'),(3434,'','1','145','FAVOURITE GAS','NSIKAK','07037290988','@gmail.com','CALABAR','CROSS RIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-15 11:29:35',5,'542','2022-02-15 11:29:35','542'),(3435,'','1','145','OB GAS','OBEEKING','07067291175','calabarlpg@aarano','CALABAR','CRS','\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nCALABAR\r\n\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-19 15:04:57',5,'542','2022-11-19 15:04:57','542'),(3436,'','1','145','JARUSALEM GAS','JARUSALEM','08160837048','calabarlpg@aarano','CALABAR','CRS','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-19 15:06:59',5,'542','2022-11-19 15:06:59','542'),(3437,'','1','145','SAM GIFT GAS','SAMUEL GIFT','08066210514','calabarlpg@aarano','CALABAR','CRS','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-19 15:08:16',5,'542','2022-11-19 15:08:16','542'),(3438,'','1','145','EFFI-BASSEL','EFFIONG BASSEL','08136286692','calabarlpg@aarano','CALABAR','CRS','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-19 15:10:57',5,'542','2022-11-19 15:10:57','542'),(3439,'','1','145','ENGR FRANK GAS','MR FRANK','08063359173','calabarlpg@gmail.com','CALABAR','CRS','CALABAR ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-19 16:51:16',5,'542','2022-11-19 16:51:16','542'),(3440,'','1','145','PALUKAS','LUKE','08033420729','calabarlpg@gmail.com','CALABAR','CRS','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-19 16:52:06',5,'542','2022-11-19 16:52:06','542'),(3441,'','1','145','DAN ENEYO','DANIEL EFA','08059014047','calabarlpg@gmail.com','CALABAR','CRS','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-27 15:03:38',5,'542','2022-11-27 15:03:38','542'),(3442,'','1','145','EXTRICATE','08034616495','08034616495','oscar4cheery@gmail.com','CALABAR','CROSSRIVER','CROSSPIL ESTATE, AKPASANYO CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-21 11:22:34',5,'542','2022-12-21 11:22:34','542'),(3443,'','1','145','FELIX GAS','FELIX EDEM','08033433180','calabarlpg@gmail.com','CALABAR','CROSSRIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-02 12:11:15',5,'542','2023-01-02 12:11:15','542'),(3444,'','1','145','TRANSCORP GAS','MR HENRY','08053760521','calabarlpg@gmail.com','CALABAR','CROSSRIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-05 15:33:34',5,'542','2023-01-05 15:33:34','542'),(3445,'','1','145','PEETINTELS','PETER','08056341498','calabarlpg@gmail.com','CALABAR','CROSSRIVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-31 10:09:10',5,'542','2023-01-31 10:09:10','542'),(3446,'','1','145','ANIESCO','ANIETIE JONAH','08033910736','calabarlpg@gmail.com','CALABAR','CROSSRIVER','AKAMKPA 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-03 09:39:43',5,'542','2023-02-03 09:39:43','542');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18498 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','145',18497,'827',10.60,3303.00,'2022-01-18','','2022-01-18 17:41:30','483','483',2022,'483','2022-01-18 17:41:30',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2360 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','145','826',2358,'5','LPG NOZZLE 1',1822680.54,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','145','827',2359,'5','LPG TANK 2',1794064.88,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258030 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','145',156181,'DAILY SALES ON 1/10/2020','2020-10-11','2020-10-11 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-15 16:41:40','542','2020-10-15 16:42:10',10,0),('1','145',156874,'DAILY SALES ON 1/10/2020','2020-10-01','2020-10-01 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-15 16:58:50','542','2020-10-15 16:59:28',10,0),('1','145',156881,'DAILY SALES','2020-10-02','2020-10-02 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-15 17:13:08','542','2020-10-15 17:13:31',10,0),('1','145',156883,'DAILY SALES','2020-10-03','2020-10-03 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-15 17:26:02','542','2020-10-15 17:26:31',10,0),('1','145',156886,'DAILY SALES','2020-10-04','2020-10-04 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-15 17:35:48','542','2020-10-15 17:36:15',10,0),('1','145',156887,'DAILY SALES','2020-10-05','2020-10-05 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-15 17:45:42','542','2020-10-15 17:46:04',10,0),('1','145',156889,'DAILY SALES','2020-10-06','2020-10-06 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-15 17:54:25','542','2020-10-15 17:54:48',10,0),('1','145',159324,'DAILY SALES','2020-10-30','2020-10-30 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-30 09:28:18','542','2020-10-30 09:28:52',10,0),('1','145',159330,'DAILY SALES','2020-10-08','2020-10-08 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-30 09:39:30','542','2020-10-30 09:39:53',10,0),('1','145',159334,'DAILY SALES','2020-10-09','2020-10-09 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-30 09:47:52','542','2020-10-30 09:48:20',10,0),('1','145',159337,'DAILY SALES','2020-10-10','2020-10-10 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-30 10:03:07','542','2020-10-30 10:06:27',10,0),('1','145',159339,'DAILY SALES','2020-10-11','2020-10-11 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-30 10:26:34','542','2020-10-30 10:26:54',10,0),('1','145',159343,'DAILY SALES','2020-10-30','2020-10-30 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-30 10:50:22','542','2020-10-30 10:50:49',10,0),('1','145',159347,'DAILY SALES','2020-10-12','2020-10-12 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-30 10:59:07','542','2020-10-30 10:59:32',10,0),('1','145',159350,'DAILY SALES','2020-10-13','2020-10-13 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-30 11:05:55','542','2020-10-30 11:06:17',10,0),('1','145',159354,'DAILY SALES','2020-10-13','2020-10-13 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-30 11:13:07','542','2020-10-30 11:13:48',10,0),('1','145',159359,'DAILY SALES','2020-10-30','2020-10-30 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-30 11:27:26','542','2020-10-30 11:27:50',10,0),('1','145',159366,'DAILY SALES','2020-10-16','2020-10-16 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-30 11:55:44','542','2020-10-30 11:56:07',10,0),('1','145',159369,'DAILY SALES','2020-10-16','2020-10-16 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-30 12:01:54','542','2020-10-30 12:02:28',10,0),('1','145',159373,'DAILY SALES','2020-10-17','2020-10-17 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-30 12:15:58','542','2020-10-30 12:16:19',10,0),('1','145',159375,'DAILY SALES','2020-10-18','2020-10-18 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-30 12:23:49','542','2020-10-30 12:24:11',10,0),('1','145',159376,'DAILY SALES','2020-10-19','2020-10-19 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-30 12:31:23','542','2020-10-30 12:32:10',10,0),('1','145',159379,'DAILY SALES','2020-10-20','2020-10-20 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-30 12:39:40','542','2020-10-30 12:40:01',10,0),('1','145',159421,'DAILY SALES','2020-10-21','2020-10-21 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-30 16:11:36','542','2020-10-30 16:12:14',10,0),('1','145',159426,'DAILY SALES','2020-10-23','2020-10-23 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-30 16:29:49','542','2020-10-30 16:30:14',10,0),('1','145',159508,'DAILY SALES','2020-10-27','2020-10-27 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-31 11:41:31','542','2020-10-31 11:41:54',10,0),('1','145',159519,'DAILY SALES','2020-10-22','2020-10-22 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-31 12:24:07','542','2020-10-31 12:24:33',10,0),('1','145',159524,'DAILY SALES','2020-10-31','2020-10-31 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-31 12:34:43','542','2020-10-31 12:35:07',10,0),('1','145',159526,'DAILY SALES','2020-10-28','2020-10-28 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-31 12:43:44','542','2020-10-31 12:46:07',10,0),('1','145',159529,'DAILY SALES','2020-10-31','2020-10-31 00:00:00',NULL,'542',0.00,0.00,'542','2020-10-31 12:53:51','542','2020-10-31 12:54:23',10,0),('1','145',160123,'DAILY SALES','2020-11-01','2020-11-01 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-03 18:31:50','542','2020-11-03 18:32:14',10,0),('1','145',160130,'DAILY SALES','2020-11-02','2020-11-02 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-03 20:43:07','542','2020-11-03 20:43:30',10,0),('1','145',160131,'DAILY SALES','2020-11-03','2020-11-03 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-03 20:47:22','542','2020-11-03 20:47:45',10,0),('1','145',160456,'DAILY SALES','2020-11-04','2020-11-04 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-05 19:32:36','542','2020-11-05 19:32:55',10,0),('1','145',160457,'DAILY SALES','2020-11-05','2020-11-05 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-05 19:46:40','542','2020-11-05 19:47:01',10,0),('1','145',160825,'DAILY SALES','2020-11-06','2020-11-06 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-08 13:23:24','542','2020-11-08 13:23:50',10,0),('1','145',160830,'DAILY SALES','2020-11-07','2020-11-07 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-08 13:39:02','542','2020-11-08 13:39:25',10,0),('1','145',160891,'DAILY SALES','2020-11-08','2020-11-08 00:00:00',NULL,'542',14.14,19.04,'542','2020-11-08 19:08:01','542','2020-11-08 19:08:31',10,0),('1','145',161136,'DAILY SALES','2020-11-10','2020-11-10 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-10 09:52:36','542','2020-11-10 09:53:16',10,0),('1','145',161331,'DAILY SALES','2020-11-10','2020-11-10 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-11 09:13:30','542','2020-11-11 09:13:52',10,0),('1','145',161332,'DAILY SALES','2020-11-10','2020-11-10 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-11 09:18:21','542','2020-11-11 09:18:44',10,0),('1','145',161483,'DAILY SALES','2020-11-11','2020-11-11 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-11 20:37:52','542','2020-11-11 20:38:13',10,0),('1','145',161661,'DAILY SALES','2020-11-12','2020-11-12 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-12 18:47:23','542','2020-11-12 18:48:09',10,0),('1','145',161881,'DAILY SALES','2020-11-13','2020-11-13 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-13 19:53:18','542','2020-11-13 19:53:52',10,0),('1','145',162046,'DAILY SALES','2020-11-14','2020-11-14 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-14 20:41:58','542','2020-11-14 20:42:29',10,0),('1','145',162049,'DAILY SALES','2020-11-14','2020-11-14 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-14 20:51:30','542','2020-11-14 20:51:54',10,0),('1','145',162245,'DAILY SALES','2020-11-15','2020-11-15 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-15 20:38:14','542','2020-11-15 20:38:37',10,0),('1','145',162461,'DAILY SALES','2020-11-16','2020-11-16 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-16 19:16:23','542','2020-11-16 19:16:42',10,0),('1','145',162642,'DAILY  SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-17 19:15:44','542','2020-11-17 19:16:08',10,0),('1','145',162824,'DAILY SALES','2020-11-18','2020-11-18 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-18 20:55:03','542','2020-11-18 20:55:33',10,0),('1','145',162825,'DAILY SALES','2020-11-18','2020-11-18 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-18 21:03:49','542','2020-11-18 21:06:19',10,0),('1','145',163005,'DAILY SALES','2020-11-19','2020-11-19 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-19 18:55:13','542','2020-11-19 18:55:33',10,0),('1','145',163219,'DAILY SALES','2020-11-20','2020-11-20 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-20 21:11:41','542','2020-11-20 21:12:35',10,0),('1','145',163382,'DAILY SALES','2020-11-21','2020-11-21 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-21 21:35:02','542','2020-11-21 21:35:26',10,0),('1','145',163541,'DAILY SALES','2020-11-22','2020-11-22 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-22 18:20:22','542','2020-11-22 18:20:42',10,0),('1','145',163779,'DAILY  SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-24 09:42:00','542','2020-11-24 09:42:21',10,0),('1','145',163904,'DAILY  SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-24 21:27:59','542','2020-11-24 21:28:21',10,0),('1','145',164082,'DAILY  SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-25 20:37:48','542','2020-11-25 20:38:15',10,0),('1','145',164258,'DAILY  SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-26 19:06:58','542','2020-11-26 19:07:26',10,0),('1','145',164493,'DAILY  SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-28 09:59:17','542','2020-11-28 09:59:49',10,0),('1','145',164611,'DAILY  SHIFT','2020-11-28','2020-11-28 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-28 21:49:28','542','2020-11-28 21:49:53',10,0),('1','145',164733,'DAILY  SHIFT','2020-11-29','2020-11-29 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-29 17:19:45','542','2020-11-29 17:20:08',10,0),('1','145',164973,'DAILY  SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'542',0.00,0.00,'542','2020-11-30 21:13:03','542','2020-11-30 21:13:24',10,0),('1','145',165128,'DAILY  SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-01 19:42:57','542','2020-12-01 19:43:22',10,0),('1','145',165311,'DAILY  SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-02 20:21:41','542','2020-12-02 20:22:03',10,0),('1','145',165312,'DAILY  SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-02 20:37:19','542','2020-12-02 20:37:38',10,0),('1','145',165445,'DAILY  SHIFT','2020-12-03','2020-12-03 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-03 20:39:51','542','2020-12-03 20:40:14',10,0),('1','145',165621,'DAILY  SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-04 19:58:21','542','2020-12-04 19:58:46',10,0),('1','145',165798,'DAILY  SHIFT','2020-12-05','2020-12-05 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-05 21:01:15','542','2020-12-05 21:01:38',10,0),('1','145',165922,'DAILY  SHIFT','2020-12-06','2020-12-06 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-06 18:23:09','542','2020-12-06 18:23:31',10,0),('1','145',166147,'DAILY  SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-07 19:56:24','542','2020-12-07 19:56:49',10,0),('1','145',166500,'DAILY  SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-09 19:13:01','542','2020-12-09 19:13:35',10,0),('1','145',166502,'DAILY  SHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-09 19:21:43','542','2020-12-09 19:22:05',10,0),('1','145',166503,'DAILY  SHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-09 19:34:34','542','2020-12-09 19:34:59',10,0),('1','145',166702,'DAILY  SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-10 19:08:01','542','2020-12-10 19:08:26',10,0),('1','145',166706,'DAILY  SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-10 19:19:19','542','2020-12-10 19:19:42',10,0),('1','145',166880,'DAILY  SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-11 18:45:53','542','2020-12-11 18:46:15',10,0),('1','145',167185,'DAILY  SHIFT','2020-12-12','2020-12-12 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-13 20:08:52','542','2020-12-13 20:09:14',10,0),('1','145',167186,'DAILY  SHIFT','2020-12-13','2020-12-13 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-13 20:37:27','542','2020-12-13 20:37:52',10,0),('1','145',167389,'DAILY  SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-14 20:55:36','542','2020-12-14 20:55:56',10,0),('1','145',167575,'DAILY  SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-15 20:49:22','542','2020-12-15 20:49:44',10,0),('1','145',167742,'DAILY  SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-16 21:08:21','542','2020-12-16 21:09:17',10,0),('1','145',167923,'DAILY  SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-17 20:52:36','542','2020-12-17 20:52:57',10,0),('1','145',167924,'DAILY  SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-17 21:43:10','542','2020-12-17 21:43:32',10,0),('1','145',168135,'DAILY  SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-18 21:10:59','542','2020-12-18 21:11:19',10,0),('1','145',168136,'DAILY  SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-18 21:21:58','542','2020-12-18 21:22:18',10,0),('1','145',168277,'DAILY  SHIFT','2020-12-19','2020-12-19 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-19 17:41:15','542','2020-12-19 17:41:45',10,0),('1','145',168414,'DAILY  SHIFT','2020-12-20','2020-12-20 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-20 20:44:36','542','2020-12-20 20:45:04',10,0),('1','145',168622,'DAILY  SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-21 21:22:20','542','2020-12-21 21:22:41',10,0),('1','145',168779,'DAILY  SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-22 21:19:15','542','2020-12-22 21:19:37',10,0),('1','145',169223,'DAILY  SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-25 14:45:43','542','2020-12-25 14:46:04',10,0),('1','145',169226,'DAILY  SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-25 14:53:18','542','2020-12-25 14:53:39',10,0),('1','145',169229,'DAILY  SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-25 15:07:02','542','2020-12-25 15:07:40',10,0),('1','145',169283,'DAILY  SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-25 21:43:48','542','2020-12-25 21:44:36',10,0),('1','145',169578,'DAILY  SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-27 21:24:14','542','2020-12-27 21:24:41',10,0),('1','145',169937,'DAILY  SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-29 21:05:51','542','2020-12-29 21:06:12',10,0),('1','145',170151,'DAILY  SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-30 20:55:57','542','2020-12-30 20:56:22',10,0),('1','145',170345,'DAILY  SHIFT','2020-12-31','2020-12-31 00:00:00',NULL,'542',0.00,0.00,'542','2020-12-31 21:33:12','542','2020-12-31 21:34:17',10,0),('1','145',170565,'DAILY  SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-02 13:05:54','542','2021-01-02 13:06:15',10,0),('1','145',170671,'DAILY  SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-02 21:29:12','542','2021-01-02 21:29:35',10,0),('1','145',170818,'DAILY  SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-03 21:17:35','542','2021-01-03 21:18:10',10,0),('1','145',171001,'DAILY  SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-04 20:59:27','542','2021-01-04 20:59:51',10,0),('1','145',171216,'DAILY  SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-05 21:44:08','542','2021-01-05 21:44:33',10,0),('1','145',171538,'DAILY  SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-07 15:26:18','542','2021-01-07 15:26:49',10,0),('1','145',171588,'DAILY  SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-07 21:48:32','542','2021-01-07 21:49:05',10,0),('1','145',171777,'DAILY  SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-08 21:11:58','542','2021-01-08 21:12:24',10,0),('1','145',171778,'DAILY  SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-08 21:22:04','542','2021-01-08 21:22:27',10,0),('1','145',171951,'DAILY  SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-09 21:11:02','542','2021-01-09 21:11:22',10,0),('1','145',172284,'DAILY  SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-11 20:21:52','542','2021-01-11 20:22:17',10,0),('1','145',172288,'DAILY  SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-11 20:30:44','542','2021-01-11 20:31:12',10,0),('1','145',172749,'DAILY  SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-14 10:01:53','542','2021-01-14 10:02:19',10,0),('1','145',172761,'DAILY  SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-14 11:09:14','542','2021-01-14 11:09:34',10,0),('1','145',172763,'DAILY  SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-14 11:16:10','542','2021-01-14 11:16:32',10,0),('1','145',173129,'DAILY  SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-16 12:21:33','542','2021-01-16 12:22:23',10,0),('1','145',173134,'DAILY  SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-16 12:41:52','542','2021-01-16 12:42:25',10,0),('1','145',173180,'DAILY  SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-16 15:13:49','542','2021-01-16 15:14:35',10,0),('1','145',174012,'DAILY  SHIFT','2021-01-19','2021-01-19 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-21 10:31:25','542','2021-01-21 10:31:48',10,0),('1','145',174016,'DAILY  SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-21 10:45:20','542','2021-01-21 10:45:50',10,0),('1','145',174129,'DAILY  SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-21 21:06:15','542','2021-01-21 21:06:43',10,0),('1','145',174325,'DAILY  SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-22 21:35:16','542','2021-01-22 21:36:06',10,0),('1','145',174554,'DAILY  SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-24 13:21:57','542','2021-01-24 13:22:31',10,0),('1','145',174560,'DAILY  SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-24 13:33:02','542','2021-01-24 13:33:27',10,0),('1','145',174646,'DAILY  SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-24 21:01:57','542','2021-01-24 21:02:21',10,0),('1','145',174840,'DAILY  SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-25 19:07:24','542','2021-01-25 19:07:50',10,0),('1','145',175193,'DAILY  SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-27 15:43:59','542','2021-01-27 15:44:27',10,0),('1','145',175203,'DAILY  SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-27 16:18:22','542','2021-01-27 16:18:42',10,0),('1','145',175241,'DAILY  SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-27 21:28:33','542','2021-01-27 21:29:06',10,0),('1','145',175413,'DAILY  SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-28 20:23:37','542','2021-01-28 20:24:04',10,0),('1','145',175596,'DAILY  SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-29 21:02:04','542','2021-01-29 21:02:31',10,0),('1','145',175597,'DAILY  SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-29 21:15:10','542','2021-01-29 21:15:35',10,0),('1','145',175879,'DAILY  SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-31 15:28:47','542','2021-01-31 15:29:19',10,0),('1','145',175919,'DAILY  SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'542',0.00,0.00,'542','2021-01-31 20:46:21','542','2021-01-31 20:46:43',10,0),('1','145',176198,'DAILY  SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-02 10:22:41','542','2021-02-02 10:23:07',10,0),('1','145',176333,'DAILY  SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-02 22:42:51','542','2021-02-02 22:43:11',10,0),('1','145',176334,'DAILY  SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-02 22:50:44','542','2021-02-02 22:51:09',10,0),('1','145',176551,'DAILY  SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-03 21:45:37','542','2021-02-03 21:46:02',10,0),('1','145',176775,'DAILY  SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-04 21:32:32','542','2021-02-04 21:33:02',10,0),('1','145',176776,'DAILY  SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-04 21:54:11','542','2021-02-04 21:54:33',10,0),('1','145',176975,'DAILY  SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-05 21:30:29','542','2021-02-05 21:30:57',10,0),('1','145',176976,'DAILY  SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-05 21:53:44','542','2021-02-05 21:54:07',10,0),('1','145',176979,'DAILY  SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-05 22:05:29','542','2021-02-05 22:05:49',10,0),('1','145',177619,'DAILY  SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-08 20:31:12','542','2021-02-08 20:31:36',10,0),('1','145',178632,'DAILY  SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-13 14:27:29','542','2021-02-13 14:27:53',10,0),('1','145',178635,'DAILY  SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-13 14:33:14','542','2021-02-13 14:33:41',10,0),('1','145',178641,'DAILY  SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-13 14:44:54','542','2021-02-13 14:45:15',10,0),('1','145',178642,'DAILY  SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-13 14:51:33','542','2021-02-13 14:51:55',10,0),('1','145',178646,'DAILY  SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-13 14:58:18','542','2021-02-13 14:58:40',10,0),('1','145',178647,'DAILY  SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-13 15:06:48','542','2021-02-13 15:07:12',10,0),('1','145',178898,'DAILY  SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-14 23:42:13','542','2021-02-14 23:42:54',10,0),('1','145',178899,'DAILY  SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-14 23:52:31','542','2021-02-14 23:52:56',10,0),('1','145',178900,'DAILY  SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-15 00:10:20','542','2021-02-15 00:10:49',10,0),('1','145',178901,'DAILY  SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-15 00:18:52','542','2021-02-15 00:19:14',10,0),('1','145',179917,'DAILY  SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-19 14:52:43','542','2021-02-19 14:53:03',10,0),('1','145',179922,'DAILY  SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-19 14:59:19','542','2021-02-19 14:59:46',10,0),('1','145',179930,'DAILY  SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-19 15:26:51','542','2021-02-19 15:27:15',10,0),('1','145',179939,'DAILY  SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-19 15:41:34','542','2021-02-19 15:42:05',10,0),('1','145',179947,'DAILY  SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-19 16:09:43','542','2021-02-19 16:10:09',10,0),('1','145',179953,'DAILY  SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-19 16:39:08','542','2021-02-19 16:39:32',10,0),('1','145',179981,'DAILY  SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-19 20:02:35','542','2021-02-19 20:03:19',10,0),('1','145',180332,'DAILY  SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-21 22:09:53','542','2021-02-21 22:10:21',10,0),('1','145',180333,'DAILY  SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-21 22:19:36','542','2021-02-21 22:20:35',10,0),('1','145',180715,'DAILY  SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-23 18:16:58','542','2021-02-23 18:17:30',10,0),('1','145',180717,'DAILY  SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-23 18:27:22','542','2021-02-23 18:27:50',10,0),('1','145',180719,'DAILY  SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-23 19:09:20','542','2021-02-23 19:09:41',10,0),('1','145',181300,'DAILY  SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-26 16:46:48','542','2021-02-26 16:48:40',10,0),('1','145',181306,'DAILY  SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-26 17:03:42','542','2021-02-26 17:04:09',10,0),('1','145',181308,'DAILY  SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-26 17:13:53','542','2021-02-26 17:14:26',10,0),('1','145',181314,'DAILY  SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-26 17:31:04','542','2021-02-26 17:31:32',10,0),('1','145',181464,'DAILY  SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'542',0.00,0.00,'542','2021-02-27 15:44:31','542','2021-02-27 15:44:54',10,0),('1','145',182275,'DAILY  SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-03 17:27:24','542','2021-03-03 17:27:46',10,0),('1','145',182278,'DAILY  SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-03 17:39:24','542','2021-03-03 17:39:53',10,0),('1','145',182281,'DAILY  SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-03 17:46:43','542','2021-03-03 17:47:06',10,0),('1','145',182804,'DAILY  SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-09 15:08:15','542','2021-03-09 15:08:37',10,0),('1','145',183365,'DAILY  SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-09 15:14:26','542','2021-03-09 15:14:46',10,0),('1','145',183367,'DAILY  SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-09 15:21:58','542','2021-03-09 15:22:27',10,0),('1','145',183369,'DAILY  SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-09 15:31:27','542','2021-03-09 15:32:17',10,0),('1','145',183377,'DAILY  SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-09 16:09:22','542','2021-03-09 16:09:48',10,0),('1','145',183380,'DAILY  SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-09 16:16:23','542','2021-03-09 16:16:48',10,0),('1','145',183384,'DAILY  SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-09 16:26:58','542','2021-03-09 16:27:18',10,0),('1','145',183385,'DAILY  SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-09 16:32:28','542','2021-03-09 16:32:49',10,0),('1','145',183388,'DAILY  SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-09 16:41:39','542','2021-03-09 16:42:01',10,0),('1','145',183390,'DAILY  SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-09 16:47:36','542','2021-03-09 16:48:05',10,0),('1','145',183392,'DAILY  SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-09 16:52:21','542','2021-03-09 16:52:43',10,0),('1','145',184342,'DAILY  SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-14 11:15:21','542','2021-03-14 11:15:42',10,0),('1','145',184859,'DAILY  SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-16 20:10:16','542','2021-03-16 20:10:38',10,0),('1','145',184963,'DAILY  SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-17 10:57:39','542','2021-03-17 10:58:01',10,0),('1','145',184965,'DAILY  SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-17 11:10:16','542','2021-03-17 11:10:38',10,0),('1','145',184973,'DAILY  SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-17 11:30:43','542','2021-03-17 11:31:03',10,0),('1','145',184979,'DAILY  SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-17 11:36:53','542','2021-03-17 11:37:14',10,0),('1','145',184983,'DAILY  SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-17 11:47:43','542','2021-03-17 11:48:07',10,0),('1','145',184986,'DAILY  SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-17 11:54:14','542','2021-03-17 11:54:36',10,0),('1','145',184997,'DAILY  SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-17 12:50:45','542','2021-03-17 12:51:05',10,0),('1','145',185087,'DAILY  SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-17 21:06:59','542','2021-03-17 21:07:19',10,0),('1','145',185088,'DAILY  SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-17 21:24:11','542','2021-03-17 21:24:31',10,0),('1','145',185245,'DAILY  SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-18 20:28:08','542','2021-03-18 20:28:32',10,0),('1','145',185246,'DAILY  SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-18 20:35:50','542','2021-03-18 20:36:10',10,0),('1','145',185247,'DAILY  SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-18 21:03:46','542','2021-03-18 21:04:06',10,0),('1','145',185454,'DAILY  SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-19 21:16:36','542','2021-03-19 21:17:04',10,0),('1','145',186060,'DAILY  SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-22 20:53:49','542','2021-03-22 20:54:09',10,0),('1','145',186062,'DAILY  SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-22 21:01:32','542','2021-03-22 21:01:52',10,0),('1','145',186064,'DAILY  SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-22 21:17:29','542','2021-03-22 21:17:49',10,0),('1','145',186065,'DAILY  SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-22 21:27:56','542','2021-03-22 21:28:21',10,0),('1','145',186300,'DAILY  SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-23 21:20:17','542','2021-03-23 21:20:34',10,0),('1','145',186301,'DAILY  SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-23 21:26:37','542','2021-03-23 21:26:57',10,0),('1','145',186678,'DAILY  SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-25 15:11:17','542','2021-03-25 15:11:39',10,0),('1','145',186728,'DAILY  SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-25 20:50:41','542','2021-03-25 20:51:03',10,0),('1','145',186729,'DAILY  SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-25 21:03:53','542','2021-03-25 21:04:12',10,0),('1','145',186960,'DAILY  SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-26 21:46:19','542','2021-03-26 21:46:50',10,0),('1','145',186961,'DAILY  SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-26 22:03:50','542','2021-03-26 22:04:12',10,0),('1','145',187302,'DAILY  SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-28 18:33:24','542','2021-03-28 18:38:26',10,0),('1','145',187307,'DAILY  SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-28 18:45:02','542','2021-03-28 18:45:21',10,0),('1','145',187539,'DAILY  SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-29 18:32:32','542','2021-03-29 18:32:52',10,0),('1','145',187581,'DAILY  SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-30 20:08:45','542','2021-03-30 20:09:19',10,0),('1','145',187779,'DAILY  SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-30 20:27:47','542','2021-03-30 20:28:06',10,0),('1','145',187807,'DAILY  SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'542',0.00,0.00,'542','2021-03-31 17:30:28','542','2021-03-31 17:30:51',10,0),('1','145',188019,'DAILY  SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-01 19:15:33','542','2021-04-01 19:16:39',10,0),('1','145',188186,'DAILY  SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-01 19:23:07','542','2021-04-01 19:23:34',10,0),('1','145',188222,'DAILY  SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-02 17:59:13','542','2021-04-02 17:59:36',10,0),('1','145',188431,'DAILY  SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-03 19:39:02','542','2021-04-03 19:39:40',10,0),('1','145',188580,'DAILY  SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-03 20:02:55','542','2021-04-03 20:03:18',10,0),('1','145',188633,'DAILY  SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-04 18:54:51','542','2021-04-04 18:55:18',10,0),('1','145',188806,'DAILY  SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-05 18:48:14','542','2021-04-05 18:48:58',10,0),('1','145',189013,'DAILY  SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-06 17:42:16','542','2021-04-06 17:42:39',10,0),('1','145',189210,'DAILY  SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-07 18:38:58','542','2021-04-07 18:39:22',10,0),('1','145',189530,'DAILY  SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-08 13:09:10','542','2021-04-08 13:09:36',10,0),('1','145',189586,'DAILY  SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-08 18:32:09','542','2021-04-08 18:32:35',10,0),('1','145',189629,'DAILY  SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-09 17:02:24','542','2021-04-09 17:02:54',10,0),('1','145',189818,'DAILY  SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-10 18:08:45','542','2021-04-10 18:09:09',10,0),('1','145',189993,'DAILY  SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-10 18:20:15','542','2021-04-10 18:20:53',10,0),('1','145',190587,'DAILY  SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-13 14:05:48','542','2021-04-13 14:06:21',10,0),('1','145',190589,'DAILY  SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-13 14:16:44','542','2021-04-13 14:17:07',10,0),('1','145',190614,'DAILY  SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-13 15:54:20','542','2021-04-13 15:54:50',10,0),('1','145',190671,'DAILY  SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-14 16:11:21','542','2021-04-14 16:12:13',10,0),('1','145',190889,'DAILY  SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-15 16:15:49','542','2021-04-15 16:16:17',10,0),('1','145',191249,'DAILY  SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-16 16:37:12','542','2021-04-16 16:37:37',10,0),('1','145',191252,'DAILY  SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-16 16:55:23','542','2021-04-16 16:55:46',10,0),('1','145',191254,'DAILY  SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-16 17:04:47','542','2021-04-16 17:05:06',10,0),('1','145',191295,'DAILY  SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-17 17:16:14','542','2021-04-17 17:17:09',10,0),('1','145',191522,'DAILY  SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-18 16:48:11','542','2021-04-18 16:48:36',10,0),('1','145',191721,'DAILY  SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-19 16:17:03','542','2021-04-19 16:17:34',10,0),('1','145',191938,'DAILY  SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-20 12:14:39','542','2021-04-20 12:15:21',10,0),('1','145',192033,'DAILY  SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-21 10:25:25','542','2021-04-21 10:25:47',10,0),('1','145',192217,'DAILY  SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-21 16:08:11','542','2021-04-21 16:08:45',10,0),('1','145',192526,'DAILY  SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-22 16:43:31','542','2021-04-22 16:44:03',10,0),('1','145',192719,'DAILY  SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-23 17:11:57','542','2021-04-23 17:12:15',10,0),('1','145',193124,'DAILY  SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-25 16:37:29','542','2021-04-25 16:38:04',10,0),('1','145',193172,'DAILY  SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-26 16:39:26','542','2021-04-26 16:41:00',10,0),('1','145',193412,'DAILY  SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-28 08:55:25','542','2021-04-28 08:56:00',10,0),('1','145',193660,'DAILY  SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-28 16:30:24','542','2021-04-28 16:32:01',10,0),('1','145',193856,'DAILY  SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-29 17:02:23','542','2021-04-29 17:02:50',10,0),('1','145',194165,'DAILY  SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-30 10:29:24','542','2021-04-30 10:30:00',10,0),('1','145',194169,'DAILY  SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'542',0.00,0.00,'542','2021-04-30 17:08:10','542','2021-04-30 17:08:38',10,0),('1','145',194294,'DAILY  SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-01 17:36:21','542','2021-05-01 17:37:00',10,0),('1','145',194520,'DAILY  SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-02 16:34:20','542','2021-05-02 16:35:03',10,0),('1','145',194679,'DAILY  SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-03 16:43:21','542','2021-05-03 16:46:51',10,0),('1','145',194891,'DAILY  SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-04 10:30:03','542','2021-05-04 10:31:04',10,0),('1','145',194895,'DAILY  SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-04 17:21:00','542','2021-05-04 17:21:34',10,0),('1','145',195084,'DAILY  SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-05 16:20:58','542','2021-05-05 16:21:51',10,0),('1','145',195309,'DAILY  SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-06 14:45:54','542','2021-05-06 14:46:26',10,0),('1','145',195462,'DAILY  SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-06 14:53:42','542','2021-05-06 14:54:03',10,0),('1','145',195528,'DAILY  SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-07 16:26:41','542','2021-05-07 16:27:40',10,0),('1','145',195786,'DAILY  SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-08 16:30:50','542','2021-05-08 16:31:21',10,0),('1','145',196055,'DAILY  SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-09 16:10:40','542','2021-05-09 16:11:02',10,0),('1','145',196239,'DAILY  SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-10 17:02:24','542','2021-05-10 17:02:45',10,0),('1','145',196538,'DAILY  SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-11 10:51:36','542','2021-05-11 10:51:55',10,0),('1','145',196542,'DAILY  SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-11 17:20:24','542','2021-05-11 17:20:46',10,0),('1','145',196683,'DAILY  SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-12 17:35:35','542','2021-05-12 17:36:26',10,0),('1','145',196895,'DAILY  SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-14 06:33:11','542','2021-05-14 06:33:39',10,0),('1','145',197034,'DAILY  SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-14 16:47:35','542','2021-05-14 16:48:03',10,0),('1','145',197171,'DAILY  SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-14 16:51:32','542','2021-05-14 16:51:51',10,0),('1','145',197541,'DAILY  SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-17 17:24:10','542','2021-05-17 17:24:32',10,0),('1','145',197819,'DAILY  SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-17 17:38:45','542','2021-05-17 17:39:08',10,0),('1','145',197821,'DAILY  SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-17 17:45:32','542','2021-05-17 17:45:53',10,0),('1','145',197978,'DAILY  SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-18 17:46:47','542','2021-05-18 17:47:15',10,0),('1','145',198079,'DAILY  SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-18 17:56:14','542','2021-05-18 17:56:40',10,0),('1','145',198123,'DAILY  SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-19 16:53:32','542','2021-05-19 16:54:03',10,0),('1','145',198361,'DAILY  SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-20 16:11:24','542','2021-05-20 16:11:57',10,0),('1','145',198580,'DAILY  SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-21 16:37:42','542','2021-05-21 16:38:10',10,0),('1','145',198723,'DAILY  SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-21 17:23:41','542','2021-05-21 17:24:04',10,0),('1','145',198791,'DAILY  SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-22 17:44:14','542','2021-05-22 17:44:33',10,0),('1','145',199028,'DAILY  SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-23 16:31:58','542','2021-05-23 16:32:15',10,0),('1','145',199218,'DAILY  SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-24 17:11:25','542','2021-05-24 17:12:07',10,0),('1','145',199442,'DAILY  SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-26 17:54:13','542','2021-05-26 17:54:36',10,0),('1','145',199834,'DAILY  SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-26 18:02:54','542','2021-05-26 18:03:18',10,0),('1','145',199837,'DAILY  SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-26 18:19:15','542','2021-05-26 18:19:34',10,0),('1','145',199876,'DAILY  SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-27 16:44:01','542','2021-05-27 16:44:31',10,0),('1','145',200102,'DAILY  SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-28 16:41:22','542','2021-05-28 16:43:25',10,0),('1','145',200309,'DAILY  SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-29 17:30:19','542','2021-05-29 17:30:45',10,0),('1','145',200454,'DAILY  SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-29 17:38:18','542','2021-05-29 17:38:38',10,0),('1','145',200534,'DAILY  SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-30 16:29:52','542','2021-05-30 16:30:22',10,0),('1','145',200709,'DAILY  SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'542',0.00,0.00,'542','2021-05-31 16:45:50','542','2021-05-31 16:46:15',10,0),('1','145',200930,'DAILY  SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-01 18:12:30','542','2021-06-01 18:12:52',10,0),('1','145',201084,'DAILY  SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-01 18:19:28','542','2021-06-01 18:19:50',10,0),('1','145',201124,'DAILY  SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-02 17:40:38','542','2021-06-02 17:41:05',10,0),('1','145',202325,'DAILY  SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-07 12:18:43','542','2021-06-07 12:19:45',10,0),('1','145',202330,'DAILY  SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-07 12:30:32','542','2021-06-07 12:31:03',10,0),('1','145',202334,'DAILY  SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-07 16:20:40','542','2021-06-07 16:21:07',10,0),('1','145',202379,'DAILY  SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-07 16:42:45','542','2021-06-07 16:43:06',10,0),('1','145',202383,'DAILY  SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-07 16:52:08','542','2021-06-07 16:52:33',10,0),('1','145',202385,'DAILY  SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-07 16:58:43','542','2021-06-07 16:59:03',10,0),('1','145',202509,'DAILY  SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-08 11:08:52','542','2021-06-08 11:09:14',10,0),('1','145',202534,'DAILY  SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-08 17:30:56','542','2021-06-08 17:31:27',10,0),('1','145',202660,'DAILY  SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-09 17:32:57','542','2021-06-09 17:33:41',10,0),('1','145',202866,'DAILY  SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-10 16:36:42','542','2021-06-10 16:37:13',10,0),('1','145',203115,'DAILY  SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-11 17:22:38','542','2021-06-11 17:23:02',10,0),('1','145',203266,'DAILY  SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-11 17:26:49','542','2021-06-11 17:27:13',10,0),('1','145',203318,'DAILY  SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-12 17:43:43','542','2021-06-12 17:44:12',10,0),('1','145',203575,'DAILY  SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-13 17:44:54','542','2021-06-13 17:45:21',10,0),('1','145',203810,'DAILY  SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-14 17:38:58','542','2021-06-14 17:39:31',10,0),('1','145',203928,'DAILY  SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-14 18:24:34','542','2021-06-14 18:25:07',10,0),('1','145',204002,'DAILY  SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-15 17:15:58','542','2021-06-15 17:16:21',10,0),('1','145',204200,'DAILY  SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-16 17:46:03','542','2021-06-16 17:46:27',10,0),('1','145',204442,'DAILY  SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-17 17:26:39','542','2021-06-17 17:27:07',10,0),('1','145',204578,'DAILY  SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-17 17:46:21','542','2021-06-17 17:47:09',10,0),('1','145',204637,'DAILY  SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-18 16:42:23','542','2021-06-18 16:43:06',10,0),('1','145',204845,'DAILY  SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-19 17:53:44','542','2021-06-19 17:54:18',10,0),('1','145',205076,'DAILY  SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-20 16:58:08','542','2021-06-20 16:58:32',10,0),('1','145',205245,'DAILY  SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-21 18:36:05','542','2021-06-21 18:36:52',10,0),('1','145',205485,'DAILY  SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-22 17:04:58','542','2021-06-22 17:05:56',10,0),('1','145',205736,'DAILY  SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-23 16:36:21','542','2021-06-23 16:40:28',10,0),('1','145',205957,'DAILY  SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-24 16:49:40','542','2021-06-24 16:50:10',10,0),('1','145',206227,'DAILY  SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-25 17:03:38','542','2021-06-25 17:05:34',10,0),('1','145',206324,'DAILY  SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-25 17:31:54','542','2021-06-25 17:32:20',10,0),('1','145',206325,'DAILY  SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-25 17:40:07','542','2021-06-25 17:40:37',10,0),('1','145',206369,'DAILY  SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-26 19:27:40','542','2021-06-26 19:28:28',10,0),('1','145',206602,'DAILY  SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-27 16:52:41','542','2021-06-27 16:53:10',10,0),('1','145',206815,'DAILY  SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-28 16:50:14','542','2021-06-28 16:51:02',10,0),('1','145',207034,'DAILY  SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-29 16:49:25','542','2021-06-29 16:50:10',10,0),('1','145',207254,'DAILY  SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'542',0.00,0.00,'542','2021-06-30 16:49:03','542','2021-06-30 16:49:33',10,0),('1','145',207487,'DAILY  SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-01 16:45:17','542','2021-07-01 16:45:49',10,0),('1','145',207649,'DAILY  SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-01 16:56:08','542','2021-07-01 16:56:32',10,0),('1','145',207748,'DAILY  SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-02 17:36:01','542','2021-07-02 17:36:37',10,0),('1','145',207914,'DAILY  SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-03 16:47:59','542','2021-07-03 16:48:35',10,0),('1','145',208071,'DAILY  SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-03 17:14:11','542','2021-07-03 17:16:01',10,0),('1','145',208144,'DAILY  SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-04 17:22:56','542','2021-07-04 17:23:59',10,0),('1','145',208339,'DAILY  SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-05 17:46:14','542','2021-07-05 17:46:31',10,0),('1','145',208517,'DAILY  SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-05 17:54:10','542','2021-07-05 17:54:31',10,0),('1','145',208566,'DAILY  SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-06 17:34:24','542','2021-07-06 17:34:53',10,0),('1','145',208769,'DAILY  SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-07 16:30:20','542','2021-07-07 16:31:03',10,0),('1','145',209006,'DAILY  SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-08 18:16:32','542','2021-07-08 18:17:09',10,0),('1','145',209220,'DAILY  SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-09 17:23:39','542','2021-07-09 17:25:01',10,0),('1','145',209449,'DAILY  SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-10 17:55:26','542','2021-07-10 17:55:54',10,0),('1','145',209612,'DAILY  SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-10 18:06:30','542','2021-07-10 18:06:53',10,0),('1','145',209613,'DAILY  SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-10 18:26:20','542','2021-07-10 18:26:43',10,0),('1','145',209684,'DAILY  SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-11 17:34:27','542','2021-07-11 17:37:06',10,0),('1','145',209874,'DAILY  SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-12 17:06:29','542','2021-07-12 17:06:57',10,0),('1','145',210106,'DAILY  SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-13 15:55:28','542','2021-07-13 15:56:32',10,0),('1','145',210596,'DAILY  SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-15 10:35:31','542','2021-07-15 10:36:11',10,0),('1','145',210779,'DAILY  SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-16 17:16:33','542','2021-07-16 17:17:04',10,0),('1','145',210963,'DAILY  SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-17 16:57:35','542','2021-07-17 16:58:43',10,0),('1','145',211204,'DAILY  SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-18 16:55:56','542','2021-07-18 16:58:00',10,0),('1','145',211382,'DAILY  SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-19 17:27:16','542','2021-07-19 17:27:58',10,0),('1','145',211652,'DAILY  SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-20 15:58:38','542','2021-07-20 15:59:07',10,0),('1','145',211785,'DAILY  SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-21 16:19:54','542','2021-07-21 16:20:29',10,0),('1','145',211998,'DAILY  SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-22 16:29:44','542','2021-07-22 16:30:42',10,0),('1','145',212240,'DAILY  SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-23 17:34:27','542','2021-07-23 17:35:30',10,0),('1','145',212460,'DAILY  SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-24 16:55:59','542','2021-07-24 16:56:29',10,0),('1','145',212616,'DAILY  SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-24 17:15:43','542','2021-07-24 17:16:19',10,0),('1','145',212707,'DAILY  SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-25 16:27:08','542','2021-07-25 16:27:50',10,0),('1','145',212878,'DAILY  SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-26 16:26:15','542','2021-07-26 16:27:31',10,0),('1','145',213133,'DAILY  SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-27 16:26:58','542','2021-07-27 16:27:39',10,0),('1','145',213398,'DAILY  SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-28 16:19:05','542','2021-07-28 16:19:36',10,0),('1','145',213704,'DAILY  SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-29 10:19:40','542','2021-07-29 10:20:07',10,0),('1','145',213706,'DAILY  SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-29 17:16:07','542','2021-07-29 17:16:52',10,0),('1','145',213894,'DAILY  SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-30 16:41:52','542','2021-07-30 16:42:48',10,0),('1','145',214100,'DAILY  SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'542',0.00,0.00,'542','2021-07-31 16:58:39','542','2021-07-31 16:59:33',10,0),('1','145',214367,'DAILY  SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-01 16:30:24','542','2021-08-01 16:30:54',10,0),('1','145',214542,'DAILY  SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-02 17:39:53','542','2021-08-02 17:42:10',10,0),('1','145',214790,'DAILY  SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-03 17:06:32','542','2021-08-03 17:07:28',10,0),('1','145',215017,'DAILY  SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-04 16:14:44','542','2021-08-04 16:15:31',10,0),('1','145',215334,'DAILY  SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-05 12:55:18','542','2021-08-05 12:57:04',10,0),('1','145',215344,'DAILY  SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-05 13:30:54','542','2021-08-05 13:31:17',10,0),('1','145',215363,'DAILY  SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-05 17:07:07','542','2021-08-05 17:07:38',10,0),('1','145',215449,'DAILY  SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-06 16:39:51','542','2021-08-06 16:40:30',10,0),('1','145',215681,'DAILY  SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-07 16:42:40','542','2021-08-07 16:43:31',10,0),('1','145',215933,'DAILY  SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-09 10:19:42','542','2021-08-09 10:20:36',10,0),('1','145',216192,'DAILY  SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-09 17:04:24','542','2021-08-09 17:04:53',10,0),('1','145',216328,'DAILY  SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-10 16:22:03','542','2021-08-10 16:23:09',10,0),('1','145',216562,'DAILY  SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-11 16:41:05','542','2021-08-11 16:46:35',10,0),('1','145',216796,'DAILY  SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-12 16:25:11','542','2021-08-12 16:25:42',10,0),('1','145',217068,'DAILY  SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-13 09:16:01','542','2021-08-13 09:17:55',10,0),('1','145',217082,'DAILY  SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-14 06:44:51','542','2021-08-14 06:45:23',10,0),('1','145',217283,'DAILY  SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-14 17:33:56','542','2021-08-14 17:34:54',10,0),('1','145',217577,'DAILY  SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-15 16:55:26','542','2021-08-15 16:55:58',10,0),('1','145',217716,'DAILY  SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-16 17:44:50','542','2021-08-16 17:45:38',10,0),('1','145',218012,'DAILY  SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-17 16:45:42','542','2021-08-17 16:46:09',10,0),('1','145',218409,'DAILY  SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-18 17:58:08','542','2021-08-18 17:58:28',10,0),('1','145',218486,'DAILY  SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-19 17:14:53','542','2021-08-19 17:15:35',10,0),('1','145',218629,'DAILY  SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-19 17:42:59','542','2021-08-19 17:43:30',10,0),('1','145',218634,'DAILY  SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-19 17:59:41','542','2021-08-19 18:00:09',10,0),('1','145',218697,'DAILY  SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-20 17:24:50','542','2021-08-20 17:25:39',10,0),('1','145',218916,'DAILY  SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-21 16:51:52','542','2021-08-21 16:53:39',10,0),('1','145',219159,'DAILY  SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-22 17:22:51','542','2021-08-22 17:24:44',10,0),('1','145',219371,'DAILY  SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-23 16:53:33','542','2021-08-23 16:54:56',10,0),('1','145',219608,'DAILY  SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-24 17:05:01','542','2021-08-24 17:06:03',10,0),('1','145',219817,'DAILY  SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-25 17:03:41','542','2021-08-25 17:09:36',10,0),('1','145',220047,'DAILY  SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-26 17:07:41','542','2021-08-26 17:09:51',10,0),('1','145',220262,'DAILY  SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-27 18:49:36','542','2021-08-27 18:52:11',10,0),('1','145',220477,'DAILY  SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-28 09:31:06','542','2021-08-28 09:32:30',10,0),('1','145',220518,'DAILY  SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-28 18:02:54','542','2021-08-28 18:06:28',10,0),('1','145',220736,'DAILY  SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-29 16:47:07','542','2021-08-29 16:50:38',10,0),('1','145',220925,'DAILY  SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-30 17:07:02','542','2021-08-30 17:11:10',10,0),('1','145',221153,'DAILY  SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'542',0.00,0.00,'542','2021-08-31 17:28:29','542','2021-08-31 17:29:44',10,0),('1','145',221431,'DAILY  SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-01 17:13:40','542','2021-09-01 17:16:00',10,0),('1','145',221631,'DAILY  SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-02 17:42:08','542','2021-09-02 17:42:53',10,0),('1','145',221795,'DAILY  SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-02 17:56:13','542','2021-09-02 17:56:31',10,0),('1','145',221862,'DAILY  SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-03 17:17:34','542','2021-09-03 17:18:52',10,0),('1','145',222061,'DAILY  SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-04 17:29:33','542','2021-09-04 17:31:56',10,0),('1','145',222308,'DAILY  SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-05 17:19:34','542','2021-09-05 17:28:10',10,0),('1','145',222496,'DAILY  SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-06 17:38:43','542','2021-09-06 17:40:39',10,0),('1','145',222727,'DAILY  SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-08 07:15:09','542','2021-09-08 07:17:00',10,0),('1','145',222960,'DAILY  SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-08 16:54:02','542','2021-09-08 16:54:40',10,0),('1','145',223138,'DAILY  SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-09 06:43:18','542','2021-09-09 06:43:37',10,0),('1','145',223186,'DAILY  SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-09 17:28:50','542','2021-09-09 17:30:43',10,0),('1','145',223381,'DAILY  SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-09 19:03:45','542','2021-09-09 19:04:05',10,0),('1','145',223435,'DAILY  SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-10 17:33:16','542','2021-09-10 17:34:12',10,0),('1','145',223644,'DAILY  SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-11 17:22:18','542','2021-09-11 17:27:02',10,0),('1','145',223906,'DAILY  SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-12 17:09:03','542','2021-09-12 17:12:24',10,0),('1','145',224089,'DAILY  SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-13 17:22:45','542','2021-09-13 17:23:49',10,0),('1','145',224310,'DAILY  SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-14 18:08:38','542','2021-09-14 18:09:58',10,0),('1','145',224532,'DAILY  SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-15 16:53:41','542','2021-09-15 17:08:33',10,0),('1','145',224744,'DAILY  SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-15 17:44:09','542','2021-09-15 17:44:48',10,0),('1','145',224787,'DAILY  SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-16 17:40:25','542','2021-09-16 17:41:17',10,0),('1','145',225024,'DAILY  SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-17 19:49:58','542','2021-09-17 19:50:51',10,0),('1','145',225269,'DAILY  SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-18 18:56:53','542','2021-09-18 18:58:48',10,0),('1','145',225515,'DAILY  SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-19 18:06:42','542','2021-09-19 18:07:43',10,0),('1','145',225748,'DAILY  SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-20 08:11:45','542','2021-09-20 08:12:19',10,0),('1','145',225749,'DAILY  SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-20 17:35:22','542','2021-09-20 17:37:57',10,0),('1','145',225981,'DAILY  SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-21 16:32:10','542','2021-09-21 16:33:40',10,0),('1','145',226235,'DAILY  SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-22 16:43:30','542','2021-09-22 16:45:18',10,0),('1','145',226478,'DAILY  SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-23 17:55:34','542','2021-09-23 17:56:53',10,0),('1','145',226741,'DAILY  SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-24 17:35:54','542','2021-09-24 17:37:17',10,0),('1','145',226965,'DAILY  SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-25 13:22:10','542','2021-09-25 13:22:54',10,0),('1','145',227083,'DAILY  SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-25 17:21:14','542','2021-09-25 17:22:10',10,0),('1','145',227219,'DAILY  SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-26 16:55:41','542','2021-09-26 17:07:55',10,0),('1','145',227379,'DAILY  SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-27 17:13:05','542','2021-09-27 17:16:00',10,0),('1','145',227612,'DAILY  SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-28 17:21:34','542','2021-09-28 17:27:13',10,0),('1','145',227858,'DAILY  SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-29 17:20:47','542','2021-09-29 17:21:46',10,0),('1','145',228118,'DAILY  SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'542',0.00,0.00,'542','2021-09-30 17:43:04','542','2021-09-30 17:44:30',10,0),('1','145',228354,'DAILY  SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-01 17:21:57','542','2021-10-01 17:23:13',10,0),('1','145',228534,'DAILY  SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-02 16:01:54','542','2021-10-02 16:03:48',10,0),('1','145',228682,'DAILY  SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-02 18:04:44','542','2021-10-02 18:05:11',10,0),('1','145',228776,'DAILY  SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-03 18:02:08','542','2021-10-03 18:04:34',10,0),('1','145',228947,'DAILY  SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-04 18:31:49','542','2021-10-05 06:36:16',10,0),('1','145',229176,'DAILY  SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-05 17:24:31','542','2021-10-05 17:26:43',10,0),('1','145',229420,'DAILY  SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-06 17:11:27','542','2021-10-06 17:12:18',10,0),('1','145',229685,'DAILY  SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-07 17:51:46','542','2021-10-07 17:53:43',10,0),('1','145',229847,'DAILY  SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-07 18:04:21','542','2021-10-07 18:04:48',10,0),('1','145',229893,'DAILY  SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-08 18:07:31','542','2021-10-08 18:08:31',10,0),('1','145',230093,'DAILY  SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-09 18:06:54','542','2021-10-09 18:08:37',10,0),('1','145',230329,'DAILY  SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-10 18:36:12','542','2021-10-10 18:37:52',10,0),('1','145',230491,'DAILY  SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-10 19:00:01','542','2021-10-10 19:00:18',10,0),('1','145',230537,'DAILY  SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-11 12:08:02','542','2021-10-11 12:08:44',10,0),('1','145',231564,'DAILY  SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-14 15:23:46','542','2021-10-14 15:24:37',10,0),('1','145',231646,'DAILY  SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-15 17:52:52','542','2021-10-15 17:54:20',10,0),('1','145',231904,'DAILY  SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-16 18:04:31','542','2021-10-16 18:05:32',10,0),('1','145',232140,'DAILY  SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-17 17:27:57','542','2021-10-17 17:28:38',10,0),('1','145',232275,'DAILY  SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-17 17:35:46','542','2021-10-17 17:36:06',10,0),('1','145',232361,'DAILY  SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-18 18:12:30','542','2021-10-18 18:13:38',10,0),('1','145',232603,'DAILY  SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-19 13:41:33','542','2021-10-19 13:42:59',10,0),('1','145',232729,'DAILY  SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-19 17:26:25','542','2021-10-19 17:28:29',10,0),('1','145',232857,'DAILY  SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-20 17:20:08','542','2021-10-20 17:23:32',10,0),('1','145',233128,'DAILY  SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-21 17:12:48','542','2021-10-21 17:14:06',10,0),('1','145',233394,'DAILY  SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-22 17:34:31','542','2021-10-22 17:35:50',10,0),('1','145',233621,'DAILY  SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-23 11:46:14','542','2021-10-23 11:47:11',10,0),('1','145',233714,'DAILY  SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-23 19:00:19','542','2021-10-23 19:01:54',10,0),('1','145',233882,'DAILY  SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-24 17:08:02','542','2021-10-24 17:10:10',10,0),('1','145',234140,'DAILY  SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-25 17:46:35','542','2021-10-25 17:47:49',10,0),('1','145',234319,'DAILY  SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-26 18:01:33','542','2021-10-26 18:02:59',10,0),('1','145',234580,'DAILY  SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-27 17:16:34','542','2021-10-27 17:18:26',10,0),('1','145',234845,'DAILY  SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-28 16:48:59','542','2021-10-29 06:42:15',10,0),('1','145',235090,'DAILY  SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-29 07:23:53','542','2021-10-29 07:25:06',10,0),('1','145',235118,'DAILY  SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-29 17:25:51','542','2021-10-29 17:31:24',10,0),('1','145',235338,'DAILY  SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-30 17:34:02','542','2021-10-30 17:35:41',10,0),('1','145',235574,'DAILY  SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'542',0.00,0.00,'542','2021-10-31 17:39:38','542','2021-10-31 17:42:02',10,0),('1','145',235772,'DAILY  SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-01 16:58:06','542','2021-11-01 17:05:15',10,0),('1','145',236039,'DAILY  SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-02 16:59:33','542','2021-11-02 17:01:13',10,0),('1','145',236247,'DAILY  SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-03 16:54:08','542','2021-11-03 16:55:41',10,0),('1','145',236526,'DAILY  SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-04 16:47:44','542','2021-11-04 16:48:45',10,0),('1','145',236749,'DAILY  SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-05 17:03:19','542','2021-11-05 17:03:49',10,0),('1','145',236982,'DAILY  SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-06 16:46:02','542','2021-11-06 16:46:34',10,0),('1','145',237215,'DAILY  SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-07 16:35:38','542','2021-11-07 16:36:12',10,0),('1','145',237404,'DAILY  SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-08 16:36:06','542','2021-11-08 16:39:39',10,0),('1','145',237626,'DAILY  SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-09 06:53:11','542','2021-11-09 06:53:28',10,0),('1','145',237635,'DAILY  SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-09 16:45:39','542','2021-11-09 16:46:10',10,0),('1','145',237888,'DAILY  SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-10 16:41:22','542','2021-11-10 16:42:06',10,0),('1','145',238143,'DAILY  SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-11 17:05:30','542','2021-11-11 17:06:00',10,0),('1','145',238298,'DAILY  SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-11 17:17:50','542','2021-11-11 17:18:42',10,0),('1','145',238371,'DAILY  SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-12 16:39:45','542','2021-11-12 16:40:11',10,0),('1','145',238620,'DAILY  SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-13 17:06:23','542','2021-11-13 17:06:51',10,0),('1','145',238879,'DAILY  SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-14 16:42:35','542','2021-11-14 16:43:59',10,0),('1','145',239080,'DAILY  SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-15 16:34:30','542','2021-11-15 16:35:29',10,0),('1','145',239312,'DAILY  SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-16 09:58:07','542','2021-11-16 09:58:49',10,0),('1','145',239378,'DAILY  SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-16 17:02:03','542','2021-11-16 17:02:42',10,0),('1','145',239541,'DAILY  SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-17 17:14:19','542','2021-11-17 17:14:49',10,0),('1','145',239791,'DAILY  SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-18 17:37:36','542','2021-11-18 17:38:01',10,0),('1','145',240012,'DAILY  SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-19 17:13:49','542','2021-11-19 17:14:20',10,0),('1','145',240142,'DAILY  SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-20 06:40:31','542','2021-11-20 06:41:12',10,0),('1','145',240212,'DAILY  SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-20 16:58:03','542','2021-11-20 16:59:21',10,0),('1','145',240494,'DAILY  SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-21 16:48:07','542','2021-11-21 16:48:47',10,0),('1','145',240705,'DAILY  SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-22 16:54:48','542','2021-11-22 16:55:14',10,0),('1','145',240983,'DAILY  SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-23 12:10:37','542','2021-11-23 12:11:11',10,0),('1','145',241094,'DAILY  SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-23 16:35:55','542','2021-11-23 16:36:21',10,0),('1','145',241233,'DAILY  SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-24 17:06:23','542','2021-11-24 17:07:15',10,0),('1','145',241501,'DAILY  SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-25 16:47:11','542','2021-11-25 16:47:53',10,0),('1','145',241751,'DAILY  SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-26 17:12:42','542','2021-11-26 17:13:12',10,0),('1','145',241993,'DAILY  SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-27 17:40:45','542','2021-11-27 17:41:18',10,0),('1','145',242263,'DAILY  SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-28 12:17:06','542','2021-11-28 12:17:40',10,0),('1','145',242300,'DAILY  SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-28 17:10:53','542','2021-11-28 17:11:16',10,0),('1','145',242441,'DAILY  SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-29 17:12:05','542','2021-11-29 17:12:48',10,0),('1','145',242685,'DAILY  SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'542',0.00,0.00,'542','2021-11-30 17:16:46','542','2021-11-30 17:17:17',10,0),('1','145',242935,'DAILY  SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-01 17:10:09','542','2021-12-01 17:10:36',10,0),('1','145',243155,'DAILY  SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-03 06:36:24','542','2021-12-03 06:36:50',10,0),('1','145',243380,'DAILY  SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-03 11:06:40','542','2021-12-03 11:07:03',10,0),('1','145',243465,'DAILY  SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-03 17:28:11','542','2021-12-03 17:28:39',10,0),('1','145',243611,'DAILY  SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-04 17:42:34','542','2021-12-04 17:43:41',10,0),('1','145',243905,'DAILY  SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-05 17:05:13','542','2021-12-05 17:05:53',10,0),('1','145',244067,'DAILY  SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-06 16:54:30','542','2021-12-06 16:56:08',10,0),('1','145',244305,'DAILY  SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-07 17:06:57','542','2021-12-07 17:07:27',10,0),('1','145',244534,'DAILY  SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-08 17:06:27','542','2021-12-08 17:07:05',10,0),('1','145',244764,'DAILY  SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-09 16:32:40','542','2021-12-09 16:34:29',10,0),('1','145',245002,'DAILY  SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-10 17:04:30','542','2021-12-10 17:04:58',10,0),('1','145',245230,'DAILY  SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-11 15:02:03','542','2021-12-11 15:02:36',10,0),('1','145',245346,'DAILY  SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-11 17:11:38','542','2021-12-11 17:12:48',10,0),('1','145',245507,'DAILY  SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-12 16:52:16','542','2021-12-12 16:53:05',10,0),('1','145',245691,'DAILY  SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-13 17:25:09','542','2021-12-13 17:26:51',10,0),('1','145',245954,'DAILY  SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-14 17:25:16','542','2021-12-14 17:25:51',10,0),('1','145',246202,'DAILY  SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-15 17:04:53','542','2021-12-15 17:06:45',10,0),('1','145',246467,'DAILY  SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-16 17:07:50','542','2021-12-16 17:08:26',10,0),('1','145',246715,'DAILY  SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-17 17:29:07','542','2021-12-17 17:30:24',10,0),('1','145',246874,'DAILY  SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-17 17:41:04','542','2021-12-17 17:41:27',10,0),('1','145',246955,'DAILY  SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-18 17:23:25','542','2021-12-18 17:24:13',10,0),('1','145',247224,'DAILY  SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-19 08:56:29','542','2021-12-19 08:56:55',10,0),('1','145',247231,'DAILY  SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-19 17:06:03','542','2021-12-19 17:06:37',10,0),('1','145',247419,'DAILY  SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-20 18:00:22','542','2021-12-20 18:00:56',10,0),('1','145',247684,'DAILY  SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-21 17:14:35','542','2021-12-21 17:16:31',10,0),('1','145',247927,'DAILY  SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-22 17:00:27','542','2021-12-22 17:01:02',10,0),('1','145',248175,'DAILY  SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-23 17:05:20','542','2021-12-23 17:06:39',10,0),('1','145',248418,'DAILY  SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-24 17:54:04','542','2021-12-24 17:54:46',10,0),('1','145',248655,'DAILY  SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-25 11:51:16','542','2021-12-25 11:51:41',10,0),('1','145',248735,'DAILY  SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-25 11:56:51','542','2021-12-25 11:57:41',10,0),('1','145',248737,'DAILY  SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-25 17:39:19','542','2021-12-25 17:40:05',10,0),('1','145',248925,'DAILY  SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-26 17:03:31','542','2021-12-26 17:04:13',10,0),('1','145',249127,'DAILY  SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-27 16:59:11','542','2021-12-27 17:00:15',10,0),('1','145',249365,'DAILY  SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-28 17:12:04','542','2021-12-28 17:12:49',10,0),('1','145',249602,'DAILY  SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-29 17:16:31','542','2021-12-29 17:16:58',10,0),('1','145',249871,'DAILY  SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-30 17:15:55','542','2021-12-30 17:16:32',10,0),('1','145',250116,'DAILY  SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-31 14:25:17','542','2021-12-31 14:25:44',10,0),('1','145',250240,'DAILY  SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'542',0.00,0.00,'542','2021-12-31 17:38:12','542','2021-12-31 17:38:37',10,0),('1','145',250396,'DAILY  SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-01 08:59:04','542','2022-01-01 08:59:37',10,0),('1','145',250398,'DAILY  SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-01 17:04:24','542','2022-01-01 17:04:54',10,0),('1','145',250613,'DAILY  SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-02 16:58:15','542','2022-01-02 16:58:41',10,0),('1','145',250815,'DAILY  SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-03 17:22:46','542','2022-01-03 17:23:31',10,0),('1','145',251037,'DAILY  SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-04 17:14:36','542','2022-01-04 17:15:13',10,0),('1','145',251286,'DAILY  SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-05 18:27:43','542','2022-01-05 18:28:09',10,0),('1','145',251527,'DAILY  SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-06 18:16:11','542','2022-01-06 18:17:05',10,0),('1','145',251781,'DAILY  SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-07 18:27:09','542','2022-01-07 18:27:53',10,0),('1','145',252009,'DAILY  SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-08 17:55:15','542','2022-01-08 17:56:36',10,0),('1','145',252282,'DAILY  SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-09 17:46:45','542','2022-01-09 17:47:33',10,0),('1','145',252493,'DAILY  SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-10 18:11:46','542','2022-01-10 18:12:56',10,0),('1','145',252727,'DAILY  SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-11 10:26:45','542','2022-01-11 10:27:42',10,0),('1','145',252806,'DAILY  SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-11 18:22:48','542','2022-01-11 18:23:23',10,0),('1','145',252979,'DAILY  SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-12 18:05:58','542','2022-01-12 18:07:29',10,0),('1','145',253217,'DAILY  SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-13 18:42:30','542','2022-01-13 18:43:21',10,0),('1','145',253419,'DAILY  SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-14 07:41:01','542','2022-01-14 07:41:39',10,0),('1','145',253493,'DAILY  SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-14 18:11:13','542','2022-01-14 18:11:55',10,0),('1','145',253721,'DAILY  SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-15 18:21:52','542','2022-01-15 18:22:48',10,0),('1','145',254014,'DAILY  SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-16 18:13:32','542','2022-01-16 18:14:55',10,0),('1','145',254215,'DAILY  SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-17 18:12:06','542','2022-01-17 18:13:12',10,0),('1','145',254470,'DAILY  SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-18 18:16:12','542','2022-01-18 18:16:38',10,0),('1','145',254637,'DAILY  SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-18 18:23:53','542','2022-01-18 18:25:37',10,0),('1','145',254638,'DAILY  SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-18 18:40:15','542','2022-01-18 18:40:38',10,0),('1','145',254715,'DAILY  SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-19 18:35:24','542','2022-01-19 18:36:00',10,0),('1','145',254968,'DAILY  SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-20 18:17:20','542','2022-01-20 18:18:20',10,0),('1','145',255207,'DAILY  SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-21 18:38:58','542','2022-01-21 18:39:38',10,0),('1','145',255395,'DAILY  SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-22 07:44:28','542','2022-01-22 07:45:18',10,0),('1','145',255478,'DAILY  SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-22 18:34:25','542','2022-01-22 18:39:36',10,0),('1','145',255766,'DAILY  SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-23 16:07:50','542','2022-01-23 16:08:41',10,0),('1','145',255862,'DAILY  SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-23 18:44:02','542','2022-01-23 18:45:08',10,0),('1','145',255965,'DAILY  SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-24 18:42:23','542','2022-01-24 18:43:10',10,0),('1','145',256229,'DAILY  SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-25 18:54:15','542','2022-01-25 18:55:40',10,0),('1','145',256420,'DAILY  SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-25 19:18:32','542','2022-01-25 19:19:30',10,0),('1','145',256498,'DAILY  SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-26 18:28:58','542','2022-01-26 18:38:12',10,0),('1','145',256743,'DAILY  SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-27 18:19:52','542','2022-01-27 18:20:56',10,0),('1','145',256978,'DAILY  SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-28 19:29:52','542','2022-01-28 19:30:32',10,0),('1','145',257184,'DAILY  SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-28 19:41:46','542','2022-01-28 19:42:09',10,0),('1','145',257250,'DAILY  SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-29 18:01:45','542','2022-01-29 18:02:34',10,0),('1','145',257535,'DAILY  SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'542',0.00,0.00,'542','2022-01-30 18:15:09','542','2022-01-30 18:16:14',10,0),('1','145',257536,'DAILY  SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-01 18:36:30','542','2022-02-01 18:36:58',10,0),('1','145',257537,'DAILY  SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-02 07:38:34','542','2022-02-02 07:39:01',10,0),('1','145',257538,'DAILY  SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-02 18:33:49','542','2022-02-02 18:34:10',10,0),('1','145',257539,'DAILY  SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-03 18:35:33','542','2022-02-03 18:35:52',10,0),('1','145',257540,'DAILY  SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-04 18:34:54','542','2022-02-04 18:36:01',10,0),('1','145',257541,'DAILY  SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-05 10:48:34','542','2022-02-05 10:49:43',10,0),('1','145',257542,'DAILY  SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-05 18:53:42','542','2022-02-05 18:54:50',10,0),('1','145',257543,'DAILY  SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-06 17:57:41','542','2022-02-06 17:58:09',10,0),('1','145',257544,'DAILY  SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-07 07:35:42','542','2022-02-07 07:36:11',10,0),('1','145',257545,'DAILY  SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-07 18:24:42','542','2022-02-07 18:25:52',10,0),('1','145',257546,'DAILY  SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-08 18:54:58','542','2022-02-08 18:56:12',10,0),('1','145',257547,'DAILY  SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-09 18:34:54','542','2022-02-09 18:35:42',10,0),('1','145',257548,'DAILY  SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-10 08:53:16','542','2022-02-10 08:53:46',10,0),('1','145',257549,'DAILY  SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-10 18:24:12','542','2022-02-10 18:25:02',10,0),('1','145',257550,'DAILY  SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-11 18:29:48','542','2022-02-11 18:30:04',10,0),('1','145',257551,'DAILY  SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-12 18:33:44','542','2022-02-12 18:34:32',10,0),('1','145',257552,'DAILY  SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-13 18:02:12','542','2022-02-13 18:02:54',10,0),('1','145',257553,'DAILY  SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-14 18:57:07','542','2022-02-14 18:57:24',10,0),('1','145',257554,'DAILY  SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-15 18:14:09','542','2022-02-15 18:14:45',10,0),('1','145',257555,'DAILY  SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-16 18:55:46','542','2022-02-16 18:56:30',10,0),('1','145',257556,'DAILY  SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-17 18:00:22','542','2022-02-17 18:00:45',10,0),('1','145',257557,'DAILY  SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-18 13:32:21','542','2022-02-18 13:32:47',10,0),('1','145',257558,'DAILY  SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-18 13:35:53','542','2022-02-18 13:36:11',10,0),('1','145',257559,'DAILY  SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-18 13:48:44','542','2022-02-18 13:49:02',10,0),('1','145',257560,'DAILY  SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-18 18:29:48','542','2022-02-18 18:30:15',10,0),('1','145',257561,'DAILY  SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-19 18:06:45','542','2022-02-19 18:07:01',10,0),('1','145',257562,'DAILY  SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-20 18:08:01','542','2022-02-20 18:08:15',10,0),('1','145',257563,'DAILY  SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'542',0.00,0.00,'542','2022-02-21 18:29:49','542','2022-02-21 18:30:05',10,0),('1','145',257564,'DAILY  SHIFT','2022-02-22','2022-02-22 07:36:40','2022-02-23 07:36:40','542',0.00,0.00,'542','2022-02-22 18:58:32','542','2022-02-22 18:58:49',10,0),('1','145',257565,'DAILY  SHIFT','2022-02-23','2022-02-23 07:36:55','2022-02-24 07:36:55','542',0.00,0.00,'542','2022-02-23 18:40:38','542','2022-02-23 18:40:54',10,0),('1','145',257566,'DAILY  SHIFT','2022-02-24','2022-02-24 07:39:34','2022-02-25 07:39:34','542',0.00,0.00,'542','2022-02-24 18:37:57','542','2022-02-24 18:38:22',10,0),('1','145',257567,'DAILY  SHIFT','2022-02-25','2022-02-25 07:27:06','2022-02-26 07:27:06','542',0.00,0.00,'542','2022-02-25 09:57:17','542','2022-02-25 09:57:35',10,0),('1','145',257568,'DAILY  SHIFT','2022-02-25','2022-02-25 09:58:05','2022-02-26 09:58:05','542',0.00,0.00,'542','2022-02-25 18:29:44','542','2022-02-25 18:30:30',10,0),('1','145',257569,'DAILY  SHIFT','2022-02-26','2022-02-26 07:47:25','2022-02-27 07:47:25','542',0.00,0.00,'542','2022-02-26 18:59:13','542','2022-02-26 18:59:29',10,0),('1','145',257570,'DAILY  SHIFT','2022-02-27','2022-02-27 09:26:22','2022-02-28 09:26:22','542',0.00,0.00,'542','2022-02-27 18:14:04','542','2022-02-27 18:14:19',10,0),('1','145',257571,'DAILY  SHIFT','2022-02-28','2022-02-28 07:49:13','2022-03-01 07:49:13','542',0.00,0.00,'542','2022-02-28 08:29:14','542','2022-02-28 08:30:16',10,0),('1','145',257572,'DAILY  SHIFT','2022-02-28','2022-02-28 08:42:38','2022-03-01 08:42:38','542',0.00,0.00,'542','2022-02-28 09:06:45','542','2022-02-28 09:07:01',10,0),('1','145',257573,'DAILY  SHIFT','2022-02-28','2022-02-28 09:08:31','2022-03-01 09:08:31','542',0.00,0.00,'542','2022-02-28 18:20:21','542','2022-02-28 18:20:38',10,0),('1','145',257574,'DAILY  SHIFT','2022-03-01','2022-03-01 07:31:17','2022-03-02 07:31:17','542',0.00,0.00,'542','2022-03-01 18:18:27','542','2022-03-01 18:18:45',10,0),('1','145',257575,'DAILY  SHIFT','2022-03-02','2022-03-02 07:37:19','2022-03-03 07:37:19','542',0.00,0.00,'542','2022-03-02 11:58:51','542','2022-03-02 11:59:12',10,0),('1','145',257576,'DAILY  SHIFT','2022-03-02','2022-03-02 12:00:29','2022-03-03 12:00:29','542',0.00,0.00,'542','2022-03-02 18:44:10','542','2022-03-02 18:45:52',10,0),('1','145',257577,'DAILY  SHIFT','2022-03-03','2022-03-03 07:51:45','2022-03-04 07:51:45','542',0.00,0.00,'542','2022-03-03 18:24:10','542','2022-03-03 18:24:25',10,0),('1','145',257578,'DAILY  SHIFT','2022-03-04','2022-03-04 07:43:13','2022-03-05 07:43:13','542',0.00,0.00,'542','2022-03-04 08:37:59','542','2022-03-04 08:38:20',10,0),('1','145',257579,'DAILY  SHIFT','2022-03-04','2022-03-04 08:54:25','2022-03-05 08:54:25','542',0.00,0.00,'542','2022-03-05 07:37:55','542','2022-03-05 07:38:10',10,0),('1','145',257580,'DAILY  SHIFT','2022-03-05','2022-03-05 07:38:25','2022-03-06 07:38:25','542',0.00,0.00,'542','2022-03-05 18:47:20','542','2022-03-05 18:47:37',10,0),('1','145',257581,'DAILY  SHIFT','2022-03-06','2022-03-06 09:33:56','2022-03-07 09:33:56','542',0.00,0.00,'542','2022-03-06 19:47:40','542','2022-03-06 19:47:56',10,0),('1','145',257582,'DAILY  SHIFT','2022-03-07','2022-03-07 07:45:18','2022-03-08 07:45:18','542',0.00,0.00,'542','2022-03-07 17:46:30','542','2022-03-07 17:46:47',10,0),('1','145',257583,'DAILY  SHIFT','2022-03-08','2022-03-08 12:15:58','2022-03-09 12:15:58','542',0.00,0.00,'542','2022-03-08 18:23:09','542','2022-03-08 18:23:28',10,0),('1','145',257584,'DAILY  SHIFT','2022-03-09','2022-03-09 07:32:21','2022-03-10 07:32:21','542',0.00,0.00,'542','2022-03-09 18:49:40','542','2022-03-09 18:50:04',10,0),('1','145',257585,'DAILY  SHIFT','2022-03-10','2022-03-10 07:39:48','2022-03-11 07:39:48','542',0.00,0.00,'542','2022-03-10 18:28:35','542','2022-03-10 18:29:39',10,0),('1','145',257586,'DAILY  SHIFT','2022-03-11','2022-03-11 08:11:30','2022-03-12 08:11:30','542',0.00,0.00,'542','2022-03-11 13:48:22','542','2022-03-11 13:49:23',10,0),('1','145',257587,'DAILY  SHIFT','2022-03-11','2022-03-11 14:05:52','2022-03-12 14:05:52','542',0.00,0.00,'542','2022-03-11 18:27:19','542','2022-03-11 18:28:18',10,0),('1','145',257588,'DAILY  SHIFT','2022-03-12','2022-03-12 07:41:24','2022-03-13 07:41:24','542',0.00,0.00,'542','2022-03-12 18:02:33','542','2022-03-12 18:03:35',10,0),('1','145',257589,'DAILY  SHIFT','2022-03-13','2022-03-13 09:20:29','2022-03-14 09:20:29','542',0.00,0.00,'542','2022-03-13 18:39:59','542','2022-03-13 18:40:33',10,0),('1','145',257590,'DAILY  SHIFT','2022-03-14','2022-03-14 07:30:11','2022-03-15 07:30:11','542',0.00,0.00,'542','2022-03-14 18:31:23','542','2022-03-14 18:31:50',10,0),('1','145',257591,'DAILY  SHIFT','2022-03-15','2022-03-15 07:34:53','2022-03-16 07:34:53','542',0.00,0.00,'542','2022-03-15 07:42:48','542','2022-03-15 07:43:20',10,0),('1','145',257592,'DAILY  SHIFT','2022-03-15','2022-03-15 07:48:07','2022-03-16 07:48:07','542',0.00,0.00,'542','2022-03-15 18:40:44','542','2022-03-15 18:41:13',10,0),('1','145',257593,'DAILY  SHIFT','2022-03-16','2022-03-16 07:32:47','2022-03-17 07:32:47','542',0.00,0.00,'542','2022-03-16 18:17:22','542','2022-03-16 18:17:46',10,0),('1','145',257594,'DAILY  SHIFT','2022-03-17','2022-03-17 07:38:46','2022-03-18 07:38:46','542',0.00,0.00,'542','2022-03-17 18:20:05','542','2022-03-17 18:21:42',10,0),('1','145',257595,'DAILY  SHIFT','2022-03-18','2022-03-18 07:35:50','2022-03-19 07:35:50','542',0.00,0.00,'542','2022-03-18 18:34:23','542','2022-03-18 18:34:50',10,0),('1','145',257596,'DAILY  SHIFT','2022-03-19','2022-03-19 07:40:09','2022-03-20 07:40:09','542',0.00,0.00,'542','2022-03-19 14:10:43','542','2022-03-19 14:11:09',10,0),('1','145',257597,'DAILY  SHIFT','2022-03-19','2022-03-19 14:12:17','2022-03-20 14:12:17','542',0.00,0.00,'542','2022-03-19 18:36:01','542','2022-03-19 18:36:38',10,0),('1','145',257598,'DAILY  SHIFT','2022-03-20','2022-03-20 10:07:29','2022-03-21 10:07:29','542',0.00,0.00,'542','2022-03-20 17:38:01','542','2022-03-20 17:38:50',10,0),('1','145',257599,'DAILY  SHIFT','2022-03-21','2022-03-21 07:36:14','2022-03-22 07:36:14','542',0.00,0.00,'542','2022-03-21 07:40:03','542','2022-03-21 07:40:30',10,0),('1','145',257600,'DAILY  SHIFT','2022-03-21','2022-03-21 07:45:06','2022-03-22 07:45:06','542',0.00,0.00,'542','2022-03-21 18:35:32','542','2022-03-21 18:36:11',10,0),('1','145',257601,'DAILY  SHIFT','2022-03-22','2022-03-22 07:29:26','2022-03-23 07:29:26','542',0.00,0.00,'542','2022-03-22 18:27:27','542','2022-03-22 18:29:29',10,0),('1','145',257602,'DAILY  SHIFT','2022-03-23','2022-03-23 07:31:25','2022-03-24 07:31:25','542',0.00,0.00,'542','2022-03-23 18:19:02','542','2022-03-23 18:19:23',10,0),('1','145',257603,'DAILY  SHIFT','2022-03-24','2022-03-24 07:32:58','2022-03-25 07:32:58','542',0.00,0.00,'542','2022-03-24 18:02:43','542','2022-03-24 18:02:59',10,0),('1','145',257604,'DAILY  SHIFT','2022-03-25','2022-03-25 07:48:08','2022-03-26 07:48:08','542',0.00,0.00,'542','2022-03-25 17:50:23','542','2022-03-25 17:50:42',10,0),('1','145',257605,'DAILY  SHIFT','2022-03-26','2022-03-26 07:30:09','2022-03-27 07:30:09','542',0.00,0.00,'542','2022-03-26 18:34:31','542','2022-03-26 18:34:54',10,0),('1','145',257606,'DAILY  SHIFT','2022-03-27','2022-03-27 09:17:07','2022-03-28 09:17:07','542',0.00,0.00,'542','2022-03-27 17:48:40','542','2022-03-27 17:51:11',10,0),('1','145',257607,'DAILY  SHIFT','2022-03-28','2022-03-28 07:30:33','2022-03-29 07:30:33','542',0.00,0.00,'542','2022-03-28 18:23:36','542','2022-03-28 18:23:59',10,0),('1','145',257608,'DAILY  SHIFT','2022-03-29','2022-03-29 07:31:43','2022-03-30 07:31:43','542',0.00,0.00,'542','2022-03-29 18:26:50','542','2022-03-29 18:28:02',10,0),('1','145',257609,'DAILY  SHIFT','2022-03-30','2022-03-30 07:18:26','2022-03-31 07:18:26','542',0.00,0.00,'542','2022-03-30 12:11:53','542','2022-03-30 12:12:34',10,0),('1','145',257610,'DAILY  SHIFT','2022-03-30','2022-03-30 12:12:54','2022-03-31 12:12:54','542',0.00,0.00,'542','2022-03-30 18:23:22','542','2022-03-30 18:23:39',10,0),('1','145',257611,'DAILY  SHIFT','2022-03-31','2022-03-31 07:12:52','2022-04-01 07:12:52','542',0.00,0.00,'542','2022-03-31 07:21:32','542','2022-03-31 07:21:48',10,0),('1','145',257612,'DAILY  SHIFT','2022-03-31','2022-03-31 07:23:40','2022-04-01 07:23:40','542',0.00,0.00,'542','2022-03-31 17:53:15','542','2022-03-31 17:53:31',10,0),('1','145',257613,'DAILY  SHIFT','2022-04-01','2022-04-01 07:26:28','2022-04-02 07:26:28','542',0.00,0.00,'542','2022-04-01 17:40:16','542','2022-04-01 17:40:39',10,0),('1','145',257614,'DAILY  SHIFT','2022-04-02','2022-04-02 07:42:26','2022-04-03 07:42:26','542',0.00,0.00,'542','2022-04-02 18:02:11','542','2022-04-02 18:02:32',10,0),('1','145',257615,'DAILY  SHIFT','2022-04-03','2022-04-03 09:29:45','2022-04-04 09:29:45','542',0.00,0.00,'542','2022-04-03 17:31:31','542','2022-04-03 17:32:06',10,0),('1','145',257616,'DAILY  SHIFT','2022-04-04','2022-04-04 07:37:56','2022-04-05 07:37:56','542',0.00,0.00,'542','2022-04-04 17:51:51','542','2022-04-04 17:52:08',10,0),('1','145',257617,'DAILY  SHIFT','2022-04-05','2022-04-05 07:17:46','2022-04-06 07:17:46','542',0.00,0.00,'542','2022-04-05 18:09:47','542','2022-04-05 18:10:02',10,0),('1','145',257618,'DAILY  SHIFT','2022-04-06','2022-04-06 07:04:52','2022-04-07 07:04:52','542',0.00,0.00,'542','2022-04-06 17:52:58','542','2022-04-06 17:53:37',10,0),('1','145',257619,'DAILY  SHIFT','2022-04-07','2022-04-07 07:07:21','2022-04-08 07:07:21','542',0.00,0.00,'542','2022-04-07 10:15:39','542','2022-04-07 10:16:09',10,0),('1','145',257620,'DAILY  SHIFT','2022-04-07','2022-04-07 10:27:46','2022-04-08 10:27:46','542',0.00,0.00,'542','2022-04-07 17:30:05','542','2022-04-07 17:30:22',10,0),('1','145',257621,'DAILY  SHIFT','2022-04-08','2022-04-08 07:26:13','2022-04-09 07:26:13','542',0.00,0.00,'542','2022-04-08 17:18:03','542','2022-04-08 17:18:24',10,0),('1','145',257622,'DAILY  SHIFT','2022-04-08','2022-04-08 17:21:58','2022-04-09 17:21:58','542',0.00,0.00,'542','2022-04-09 07:34:41','542','2022-04-09 07:35:07',10,0),('1','145',257623,'DAILY  SHIFT','2022-04-09','2022-04-09 07:35:53','2022-04-10 07:35:53','542',0.00,0.00,'542','2022-04-09 18:21:18','542','2022-04-09 18:21:51',10,0),('1','145',257624,'DAILY  SHIFT','2022-04-10','2022-04-10 09:29:25','2022-04-11 09:29:25','542',0.00,0.00,'542','2022-04-10 17:56:56','542','2022-04-10 17:57:19',10,0),('1','145',257625,'DAILY  SHIFT','2022-04-11','2022-04-11 07:28:40','2022-04-12 07:28:40','542',0.00,0.00,'542','2022-04-11 17:57:04','542','2022-04-11 17:57:20',10,0),('1','145',257626,'DAILY  SHIFT','2022-04-12','2022-04-12 07:46:41','2022-04-13 07:46:41','542',0.00,0.00,'542','2022-04-12 17:38:56','542','2022-04-12 17:39:15',10,0),('1','145',257627,'DAILY  SHIFT','2022-04-13','2022-04-13 07:36:11','2022-04-14 07:36:11','542',0.00,0.00,'542','2022-04-13 11:49:15','542','2022-04-13 11:49:32',10,0),('1','145',257628,'DAILY  SHIFT','2022-04-13','2022-04-13 11:51:17','2022-04-14 11:51:17','542',0.00,0.00,'542','2022-04-13 18:41:44','542','2022-04-13 18:42:04',10,0),('1','145',257629,'DAILY  SHIFT','2022-04-14','2022-04-14 07:27:42','2022-04-15 07:27:42','542',0.00,0.00,'542','2022-04-14 17:57:31','542','2022-04-14 17:57:59',10,0),('1','145',257630,'DAILY  SHIFT','2022-04-15','2022-04-15 07:26:43','2022-04-16 07:26:43','542',0.00,0.00,'542','2022-04-15 17:35:59','542','2022-04-15 17:36:15',10,0),('1','145',257631,'DAILY  SHIFT','2022-04-15','2022-04-15 17:39:32','2022-04-16 17:39:32','542',0.00,0.00,'542','2022-04-16 07:28:57','542','2022-04-16 07:29:13',10,0),('1','145',257632,'DAILY  SHIFT','2022-04-16','2022-04-16 07:29:35','2022-04-17 07:29:35','542',0.00,0.00,'542','2022-04-16 18:02:29','542','2022-04-16 18:02:53',10,0),('1','145',257633,'DAILY  SHIFT','2022-04-17','2022-04-17 09:32:31','2022-04-18 09:32:31','542',0.00,0.00,'542','2022-04-17 17:10:25','542','2022-04-17 17:10:39',10,0),('1','145',257634,'DAILY  SHIFT','2022-04-18','2022-04-18 07:32:41','2022-04-19 07:32:41','542',0.00,0.00,'542','2022-04-18 17:45:07','542','2022-04-18 17:45:22',10,0),('1','145',257635,'DAILY  SHIFT','2022-04-19','2022-04-19 07:34:15','2022-04-20 07:34:15','542',0.00,0.00,'542','2022-04-19 17:48:27','542','2022-04-19 17:48:51',10,0),('1','145',257636,'DAILY  SHIFT','2022-04-20','2022-04-20 07:31:04','2022-04-21 07:31:04','542',0.00,0.00,'542','2022-04-20 17:16:35','542','2022-04-20 17:16:49',10,0),('1','145',257637,'DAILY  SHIFT','2022-04-21','2022-04-21 07:28:49','2022-04-22 07:28:49','542',0.00,0.00,'542','2022-04-21 17:09:52','542','2022-04-21 17:10:07',10,0),('1','145',257638,'DAILY  SHIFT','2022-04-22','2022-04-22 07:30:34','2022-04-23 07:30:34','542',0.00,0.00,'542','2022-04-22 10:11:18','542','2022-04-22 10:11:34',10,0),('1','145',257639,'DAILY  SHIFT','2022-04-22','2022-04-22 10:11:57','2022-04-23 10:11:57','542',0.00,0.00,'542','2022-04-22 17:38:31','542','2022-04-22 17:38:56',10,0),('1','145',257640,'DAILY  SHIFT','2022-04-23','2022-04-23 07:47:43','2022-04-24 07:47:43','542',0.00,0.00,'542','2022-04-23 17:57:06','542','2022-04-23 17:57:27',10,0),('1','145',257641,'DAILY  SHIFT','2022-04-24','2022-04-24 09:43:34','2022-04-25 09:43:34','542',0.00,0.00,'542','2022-04-24 17:04:42','542','2022-04-24 17:04:59',10,0),('1','145',257642,'DAILY  SHIFT','2022-04-25','2022-04-25 07:38:05','2022-04-26 07:38:05','542',0.00,0.00,'542','2022-04-25 07:45:24','542','2022-04-25 07:45:41',10,0),('1','145',257643,'DAILY  SHIFT','2022-04-25','2022-04-25 07:50:57','2022-04-26 07:50:57','542',0.00,0.00,'542','2022-04-25 17:05:38','542','2022-04-25 17:06:04',10,0),('1','145',257644,'DAILY  SHIFT','2022-04-26','2022-04-26 07:23:22','2022-04-27 07:23:22','542',0.00,0.00,'542','2022-04-26 17:35:03','542','2022-04-26 17:35:19',10,0),('1','145',257645,'DAILY  SHIFT','2022-04-27','2022-04-27 07:30:41','2022-04-28 07:30:41','542',0.00,0.00,'542','2022-04-27 17:59:15','542','2022-04-27 17:59:29',10,0),('1','145',257646,'DAILY  SHIFT','2022-04-28','2022-04-28 07:29:51','2022-04-29 07:29:51','542',0.00,0.00,'542','2022-04-28 18:19:14','542','2022-04-28 18:19:32',10,0),('1','145',257647,'DAILY  SHIFT','2022-04-29','2022-04-29 07:48:04','2022-04-30 07:48:04','542',0.00,0.00,'542','2022-04-29 17:57:29','542','2022-04-29 17:57:45',10,0),('1','145',257648,'DAILY  SHIFT','2022-04-30','2022-04-30 07:48:40','2022-05-01 07:48:40','542',0.00,0.00,'542','2022-04-30 17:30:13','542','2022-04-30 17:31:15',10,0),('1','145',257649,'DAILY  SHIFT','2022-05-01','2022-05-01 09:36:36','2022-05-02 09:36:36','542',0.00,0.00,'542','2022-05-01 14:20:58','542','2022-05-01 14:21:38',10,0),('1','145',257650,'DAILY  SHIFT','2022-05-01','2022-05-01 14:22:51','2022-05-02 14:22:51','542',0.00,0.00,'542','2022-05-01 17:27:31','542','2022-05-01 17:27:47',10,0),('1','145',257651,'DAILY  SHIFT','2022-05-02','2022-05-02 11:25:45','2022-05-03 11:25:45','542',0.00,0.00,'542','2022-05-02 16:37:41','542','2022-05-02 16:38:18',10,0),('1','145',257652,'DAILY  SHIFT','2022-05-03','2022-05-03 07:24:24','2022-05-04 07:24:24','542',0.00,0.00,'542','2022-05-03 07:50:06','542','2022-05-03 07:50:26',10,0),('1','145',257653,'DAILY  SHIFT','2022-05-03','2022-05-03 08:01:54','2022-05-04 08:01:54','542',0.00,0.00,'542','2022-05-03 18:09:19','542','2022-05-03 18:09:49',10,0),('1','145',257654,'DAILY  SHIFT','2022-05-04','2022-05-04 07:26:51','2022-05-05 07:26:51','542',0.00,0.00,'542','2022-05-04 17:55:02','542','2022-05-04 17:55:15',10,0),('1','145',257655,'DAILY  SHIFT','2022-05-05','2022-05-05 07:31:14','2022-05-06 07:31:14','542',0.00,0.00,'542','2022-05-05 17:55:36','542','2022-05-05 17:56:18',10,0),('1','145',257656,'DAILY  SHIFT','2022-05-06','2022-05-06 07:32:16','2022-05-07 07:32:16','542',0.00,0.00,'542','2022-05-06 18:05:48','542','2022-05-06 18:06:04',10,0),('1','145',257657,'DAILY  SHIFT','2022-05-07','2022-05-07 07:37:34','2022-05-08 07:37:34','542',0.00,0.00,'542','2022-05-07 18:03:41','542','2022-05-07 18:03:56',10,0),('1','145',257658,'DAILY  SHIFT','2022-05-08','2022-05-08 09:36:12','2022-05-09 09:36:12','542',0.00,0.00,'542','2022-05-08 16:39:20','542','2022-05-08 16:39:47',10,0),('1','145',257659,'DAILY  SHIFT','2022-05-09','2022-05-09 07:28:06','2022-05-10 07:28:06','542',0.00,0.00,'542','2022-05-09 17:59:47','542','2022-05-09 18:00:03',10,0),('1','145',257660,'DAILY  SHIFT','2022-05-10','2022-05-10 07:28:13','2022-05-11 07:28:13','542',0.00,0.00,'542','2022-05-10 18:21:16','542','2022-05-10 18:21:32',10,0),('1','145',257661,'DAILY  SHIFT','2022-05-11','2022-05-11 07:27:53','2022-05-12 07:27:53','542',0.00,0.00,'542','2022-05-11 18:04:12','542','2022-05-11 18:04:26',10,0),('1','145',257662,'DAILY  SHIFT','2022-05-12','2022-05-12 07:32:16','2022-05-13 07:32:16','542',0.00,0.00,'542','2022-05-12 07:36:07','542','2022-05-12 07:36:25',10,0),('1','145',257663,'DAILY  SHIFT','2022-05-12','2022-05-12 07:37:24','2022-05-13 07:37:24','542',0.00,0.00,'542','2022-05-12 17:48:21','542','2022-05-12 17:48:36',10,0),('1','145',257664,'DAILY  SHIFT','2022-05-13','2022-05-13 07:32:36','2022-05-14 07:32:36','542',0.00,0.00,'542','2022-05-13 17:09:51','542','2022-05-13 17:10:08',10,0),('1','145',257665,'DAILY  SHIFT','2022-05-14','2022-05-14 07:28:24','2022-05-15 07:28:24','542',0.00,0.00,'542','2022-05-14 18:08:42','542','2022-05-14 18:09:00',10,0),('1','145',257666,'DAILY  SHIFT','2022-05-15','2022-05-15 09:21:03','2022-05-16 09:21:03','542',0.00,0.00,'542','2022-05-15 17:34:19','542','2022-05-15 17:34:35',10,0),('1','145',257667,'DAILY  SHIFT','2022-05-16','2022-05-16 08:21:57','2022-05-17 08:21:57','542',0.00,0.00,'542','2022-05-16 18:24:46','542','2022-05-16 18:25:12',10,0),('1','145',257668,'DAILY  SHIFT','2022-05-17','2022-05-17 08:47:52','2022-05-18 08:47:52','542',0.00,0.00,'542','2022-05-17 18:08:18','542','2022-05-17 18:08:38',10,0),('1','145',257669,'DAILY  SHIFT','2022-05-18','2022-05-18 07:34:59','2022-05-19 07:34:59','542',0.00,0.00,'542','2022-05-18 13:39:36','542','2022-05-18 13:39:52',10,0),('1','145',257670,'DAILY  SHIFT','2022-05-19','2022-05-19 12:24:19','2022-05-20 12:24:19','542',0.00,0.00,'542','2022-05-19 12:33:06','542','2022-05-19 12:33:21',10,0),('1','145',257671,'DAILY  SHIFT','2022-05-19','2022-05-19 12:33:48','2022-05-20 12:33:48','542',0.00,0.00,'542','2022-05-19 17:04:54','542','2022-05-19 17:05:09',10,0),('1','145',257672,'DAILY  SHIFT','2022-05-20','2022-05-20 07:36:20','2022-05-21 07:36:20','542',0.00,0.00,'542','2022-05-20 17:45:29','542','2022-05-20 17:46:03',10,0),('1','145',257673,'DAILY  SHIFT','2022-05-21','2022-05-21 07:33:20','2022-05-22 07:33:20','542',0.00,0.00,'542','2022-05-21 18:00:40','542','2022-05-21 18:00:58',10,0),('1','145',257674,'DAILY  SHIFT','2022-05-23','2022-05-23 08:10:34','2022-05-24 08:10:34','542',0.00,0.00,'542','2022-05-23 18:03:57','542','2022-05-23 18:04:13',10,0),('1','145',257675,'DAILY  SHIFT','2022-05-24','2022-05-24 07:40:08','2022-05-25 07:40:08','542',0.00,0.00,'542','2022-05-24 10:04:35','542','2022-05-24 10:04:53',10,0),('1','145',257676,'DAILY  SHIFT','2022-05-24','2022-05-24 10:06:35','2022-05-25 10:06:35','542',0.00,0.00,'542','2022-05-24 18:24:39','542','2022-05-24 18:25:00',10,0),('1','145',257677,'DAILY  SHIFT','2022-05-25','2022-05-25 07:37:32','2022-05-26 07:37:32','542',0.00,0.00,'542','2022-05-25 18:18:23','542','2022-05-25 18:18:52',10,0),('1','145',257678,'DAILY  SHIFT','2022-05-26','2022-05-26 07:34:45','2022-05-27 07:34:45','542',0.00,0.00,'542','2022-05-26 18:31:15','542','2022-05-26 18:31:35',10,0),('1','145',257679,'DAILY  SHIFT','2022-05-26','2022-05-26 18:55:25','2022-05-27 18:55:25','542',0.00,0.00,'542','2022-05-26 19:00:03','542','2022-05-26 19:00:16',10,0),('1','145',257680,'DAILY  SHIFT','2022-05-27','2022-05-27 07:46:52','2022-05-28 07:46:52','542',0.00,0.00,'542','2022-05-27 18:05:18','542','2022-05-27 18:05:44',10,0),('1','145',257681,'DAILY SHIFT','2022-05-27','2022-05-27 18:19:14','2022-05-28 18:19:14','542',0.00,0.00,'542','2022-05-28 07:30:59','542','2022-05-28 07:32:08',10,0),('1','145',257682,'DAILY  SHIFT','2022-05-28','2022-05-28 07:32:45','2022-05-29 07:32:45','542',0.00,0.00,'542','2022-05-28 18:46:56','542','2022-05-28 18:47:23',10,0),('1','145',257683,'DAILY  SHIFT','2022-05-29','2022-05-29 09:37:57','2022-05-30 09:37:57','542',0.00,0.00,'542','2022-05-29 18:03:15','542','2022-05-29 18:03:38',10,0),('1','145',257684,'DAILY  SHIFT','2022-05-30','2022-05-30 07:38:01','2022-05-31 07:38:01','542',0.00,0.00,'542','2022-05-30 18:20:42','542','2022-05-30 18:21:09',10,0),('1','145',257685,'DAILY  SHIFT','2022-05-31','2022-05-31 07:21:18','2022-06-01 07:21:18','542',0.00,0.00,'542','2022-06-01 07:23:38','542','2022-06-01 07:24:04',10,0),('1','145',257686,'DAILY  SHIFT','2022-06-01','2022-06-01 07:31:53','2022-06-02 07:31:53','542',0.00,0.00,'542','2022-06-01 19:10:48','542','2022-06-01 19:11:16',10,0),('1','145',257687,'DAILY  SHIFT','2022-06-02','2022-06-02 07:27:02','2022-06-03 07:27:02','542',0.00,0.00,'542','2022-06-02 18:30:26','542','2022-06-02 18:30:45',10,0),('1','145',257688,'DAILY  SHIFT','2022-06-03','2022-06-03 07:30:48','2022-06-04 07:30:48','542',0.00,0.00,'542','2022-06-03 17:20:37','542','2022-06-03 17:21:25',10,0),('1','145',257689,'DAILY  SHIFT','2022-06-04','2022-06-04 07:42:18','2022-06-05 07:42:18','542',0.00,0.00,'542','2022-06-04 10:13:24','542','2022-06-04 10:13:41',10,0),('1','145',257690,'DAILY  SHIFT','2022-06-04','2022-06-04 10:14:15','2022-06-05 10:14:15','542',0.00,0.00,'542','2022-06-04 18:10:45','542','2022-06-04 18:11:27',10,0),('1','145',257691,'DAILY SHIFT','2022-06-04','2022-06-04 18:12:25','2022-06-05 18:12:25','542',0.00,0.00,'542','2022-06-05 09:35:26','542','2022-06-05 09:35:57',10,0),('1','145',257692,'DAILY  SHIFT','2022-06-05','2022-06-05 09:36:24','2022-06-06 09:36:24','542',0.00,0.00,'542','2022-06-05 17:31:34','542','2022-06-05 17:31:59',10,0),('1','145',257693,'DAILY  SHIFT','2022-06-06','2022-06-06 07:22:56','2022-06-07 07:22:56','542',0.00,0.00,'542','2022-06-06 18:31:08','542','2022-06-06 18:31:59',10,0),('1','145',257694,'DAILY  SHIFT','2022-06-07','2022-06-07 07:27:25','2022-06-08 07:27:25','542',0.00,0.00,'542','2022-06-07 17:52:51','542','2022-06-07 17:53:10',10,0),('1','145',257695,'DAILY  SHIFT','2022-06-08','2022-06-08 07:29:29','2022-06-09 07:29:29','542',0.00,0.00,'542','2022-06-08 18:33:27','542','2022-06-08 18:33:52',10,0),('1','145',257696,'DAILY  SHIFT','2022-06-09','2022-06-09 07:30:16','2022-06-10 07:30:16','542',0.00,0.00,'542','2022-06-09 18:01:12','542','2022-06-09 18:01:46',10,0),('1','145',257697,'DAILY  SHIFT','2022-06-10','2022-06-10 07:30:38','2022-06-11 07:30:38','542',0.00,0.00,'542','2022-06-10 18:07:25','542','2022-06-10 18:07:44',10,0),('1','145',257698,'DAILY  SHIFT','2022-06-11','2022-06-11 07:27:53','2022-06-12 07:27:53','542',0.00,0.00,'542','2022-06-11 18:17:39','542','2022-06-11 18:18:24',10,0),('1','145',257699,'DAILY  SHIFT','2022-06-12','2022-06-12 09:35:44','2022-06-13 09:35:44','542',0.00,0.00,'542','2022-06-12 10:54:07','542','2022-06-12 10:54:54',10,0),('1','145',257700,'DAILY SHIFT','2022-06-12','2022-06-12 10:55:48','2022-06-13 10:55:48','542',0.00,0.00,'542','2022-06-12 11:01:25','542','2022-06-12 11:01:58',10,0),('1','145',257701,'DAILY  SHIFT','2022-06-12','2022-06-12 11:16:24','2022-06-13 11:16:24','542',0.00,0.00,'542','2022-06-12 17:46:56','542','2022-06-12 17:47:48',10,0),('1','145',257702,'DAILY  SHIFT','2022-06-13','2022-06-13 07:37:25','2022-06-14 07:37:25','542',0.00,0.00,'542','2022-06-13 18:02:53','542','2022-06-13 18:03:12',10,0),('1','145',257703,'DAILY  SHIFT','2022-06-14','2022-06-14 07:34:18','2022-06-15 07:34:18','542',0.00,0.00,'542','2022-06-14 18:02:35','542','2022-06-14 18:02:58',10,0),('1','145',257704,'DAILY  SHIFT','2022-06-15','2022-06-15 07:36:53','2022-06-16 07:36:53','542',0.00,0.00,'542','2022-06-15 18:02:21','542','2022-06-15 18:02:45',10,0),('1','145',257705,'DAILY  SHIFT','2022-06-16','2022-06-16 07:37:48','2022-06-17 07:37:48','542',0.00,0.00,'542','2022-06-16 18:14:36','542','2022-06-16 18:15:05',10,0),('1','145',257706,'DAILY  SHIFT','2022-06-17','2022-06-17 07:40:25','2022-06-18 07:40:25','542',0.00,0.00,'542','2022-06-17 18:02:15','542','2022-06-17 18:02:51',10,0),('1','145',257707,'DAILY  SHIFT','2022-06-18','2022-06-18 07:45:24','2022-06-19 07:45:24','542',0.00,0.00,'542','2022-06-18 18:00:29','542','2022-06-18 18:01:37',10,0),('1','145',257708,'DAILY  SHIFT','2022-06-19','2022-06-19 09:40:15','2022-06-20 09:40:15','542',0.00,0.00,'542','2022-06-19 17:59:01','542','2022-06-19 17:59:39',10,0),('1','145',257709,'DAILY  SHIFT','2022-06-20','2022-06-20 07:59:42','2022-06-21 07:59:42','542',0.00,0.00,'542','2022-06-20 17:43:56','542','2022-06-20 17:44:52',10,0),('1','145',257710,'DAILY  SHIFT','2022-06-21','2022-06-21 07:39:56','2022-06-22 07:39:56','542',0.00,0.00,'542','2022-06-21 14:50:18','542','2022-06-21 14:50:36',10,0),('1','145',257711,'DAILY  SHIFT','2022-06-23','2022-06-23 07:45:40','2022-06-24 07:45:40','542',0.00,0.00,'542','2022-06-23 12:22:48','542','2022-06-23 12:23:16',10,0),('1','145',257712,'DAILY SHIFT','2022-06-23','2022-06-23 12:25:14','2022-06-24 12:25:14','542',0.00,0.00,'542','2022-06-23 12:33:04','542','2022-06-23 12:33:26',10,0),('1','145',257713,'DAILY  SHIFT','2022-06-23','2022-06-23 12:36:40','2022-06-24 12:36:40','542',0.00,0.00,'542','2022-06-23 17:36:12','542','2022-06-23 17:36:38',10,0),('1','145',257714,'DAILY  SHIFT','2022-06-24','2022-06-24 10:06:32','2022-06-25 10:06:32','542',0.00,0.00,'542','2022-06-24 18:17:31','542','2022-06-24 18:18:30',10,0),('1','145',257715,'DAILY  SHIFT','2022-06-25','2022-06-25 07:41:11','2022-06-26 07:41:11','542',0.00,0.00,'542','2022-06-25 18:14:23','542','2022-06-25 18:14:50',10,0),('1','145',257716,'DAILY  SHIFT','2022-06-26','2022-06-26 09:36:56','2022-06-27 09:36:56','542',0.00,0.00,'542','2022-06-26 18:05:53','542','2022-06-26 18:06:27',10,0),('1','145',257717,'DAILY  SHIFT','2022-06-27','2022-06-27 07:35:50','2022-06-28 07:35:50','542',0.00,0.00,'542','2022-06-27 18:11:33','542','2022-06-27 18:12:00',10,0),('1','145',257718,'DAILY  SHIFT','2022-06-28','2022-06-28 07:22:27','2022-06-29 07:22:27','542',0.00,0.00,'542','2022-06-28 17:59:56','542','2022-06-28 18:00:20',10,0),('1','145',257719,'DAILY  SHIFT','2022-06-29','2022-06-29 07:29:30','2022-06-30 07:29:30','542',0.00,0.00,'542','2022-06-29 18:24:09','542','2022-06-29 18:24:39',10,0),('1','145',257720,'DAILY  SHIFT','2022-06-30','2022-06-30 07:29:11','2022-07-01 07:29:11','542',0.00,0.00,'542','2022-06-30 09:19:13','542','2022-06-30 09:19:27',10,0),('1','145',257721,'DAILY  SHIFT','2022-06-30','2022-06-30 09:19:48','2022-07-01 09:19:48','542',0.00,0.00,'542','2022-06-30 09:23:43','542','2022-06-30 09:23:58',10,0),('1','145',257722,'DAILY  SHIFT','2022-06-30','2022-06-30 09:24:22','2022-07-01 09:24:22','542',0.00,0.00,'542','2022-06-30 18:22:53','542','2022-06-30 18:23:17',10,0),('1','145',257723,'DAILY  SHIFT','2022-07-01','2022-07-01 07:44:38','2022-07-02 07:44:38','542',0.00,0.00,'542','2022-07-01 17:44:37','542','2022-07-01 17:44:56',10,0),('1','145',257724,'DAILY  SHIFT','2022-07-02','2022-07-02 07:33:30','2022-07-03 07:33:30','542',0.00,0.00,'542','2022-07-02 18:03:37','542','2022-07-02 18:04:11',10,0),('1','145',257725,'DAILY  SHIFT','2022-07-03','2022-07-03 09:46:34','2022-07-04 09:46:34','542',0.00,0.00,'542','2022-07-03 18:21:55','542','2022-07-03 18:22:26',10,0),('1','145',257726,'DAILY  SHIFT','2022-07-04','2022-07-04 07:34:58','2022-07-05 07:34:58','542',0.00,0.00,'542','2022-07-04 18:10:53','542','2022-07-04 18:11:25',10,0),('1','145',257727,'DAILY  SHIFT','2022-07-05','2022-07-05 07:41:05','2022-07-06 07:41:05','542',0.00,0.00,'542','2022-07-05 16:30:13','542','2022-07-05 16:30:48',10,0),('1','145',257728,'DAILY  SHIFT','2022-07-08','2022-07-08 12:00:06','2022-07-09 12:00:06','542',0.00,0.00,'542','2022-07-08 12:07:38','542','2022-07-08 12:08:12',10,0),('1','145',257729,'DAILY  SHIFT','2022-07-09','2022-07-09 07:55:48','2022-07-10 07:55:48','542',0.00,0.00,'542','2022-07-09 16:55:10','542','2022-07-09 16:55:32',10,0),('1','145',257730,'DAILY  SHIFT','2022-07-10','2022-07-10 09:38:45','2022-07-11 09:38:45','542',0.00,0.00,'542','2022-07-10 16:53:50','542','2022-07-10 16:54:11',10,0),('1','145',257731,'DAILY  SHIFT','2022-07-11','2022-07-11 07:46:11','2022-07-12 07:46:11','542',0.00,0.00,'542','2022-07-11 17:36:52','542','2022-07-11 17:37:14',10,0),('1','145',257732,'DAILY  SHIFT','2022-07-12','2022-07-12 08:02:29','2022-07-13 08:02:29','542',0.00,0.00,'542','2022-07-12 17:32:40','542','2022-07-12 17:33:26',10,0),('1','145',257733,'DAILY  SHIFT','2022-07-13','2022-07-13 07:42:46','2022-07-14 07:42:46','542',0.00,0.00,'542','2022-07-13 18:10:56','542','2022-07-13 18:11:36',10,0),('1','145',257734,'DAILY  SHIFT','2022-07-14','2022-07-14 07:41:39','2022-07-15 07:41:39','542',0.00,0.00,'542','2022-07-14 17:42:42','542','2022-07-14 17:43:13',10,0),('1','145',257735,'DAILY  SHIFT','2022-07-15','2022-07-15 07:39:20','2022-07-16 07:39:20','542',0.00,0.00,'542','2022-07-15 17:54:38','542','2022-07-15 17:55:13',10,0),('1','145',257736,'DAILY  SHIFT','2022-07-16','2022-07-16 07:40:31','2022-07-17 07:40:31','542',0.00,0.00,'542','2022-07-16 18:01:12','542','2022-07-16 18:01:33',10,0),('1','145',257737,'DAILY  SHIFT','2022-07-17','2022-07-17 09:51:45','2022-07-18 09:51:45','542',0.00,0.00,'542','2022-07-17 17:26:02','542','2022-07-17 17:26:18',10,0),('1','145',257738,'DAILY  SHIFT','2022-07-18','2022-07-18 07:33:57','2022-07-19 07:33:57','542',0.00,0.00,'542','2022-07-18 18:17:50','542','2022-07-18 18:18:14',10,0),('1','145',257739,'DAILY  SHIFT','2022-07-19','2022-07-19 07:38:24','2022-07-20 07:38:24','542',0.00,0.00,'542','2022-07-19 12:42:33','542','2022-07-19 12:43:13',10,0),('1','145',257740,'DAILY  SHIFT','2022-07-19','2022-07-19 12:43:34','2022-07-20 12:43:34','542',0.00,0.00,'542','2022-07-19 18:47:32','542','2022-07-19 18:47:52',10,0),('1','145',257741,'DAILY  SHIFT','2022-07-20','2022-07-20 07:43:27','2022-07-21 07:43:27','542',0.00,0.00,'542','2022-07-20 17:32:48','542','2022-07-20 17:33:11',10,0),('1','145',257742,'DAILY  SHIFT','2022-07-21','2022-07-21 07:45:22','2022-07-22 07:45:22','542',0.00,0.00,'542','2022-07-21 17:23:57','542','2022-07-21 17:24:24',10,0),('1','145',257743,'DAILY  SHIFT','2022-07-22','2022-07-22 07:44:48','2022-07-23 07:44:48','542',0.00,0.00,'542','2022-07-22 17:17:23','542','2022-07-22 17:17:44',10,0),('1','145',257744,'DAILY  SHIFT','2022-07-23','2022-07-23 07:42:19','2022-07-24 07:42:19','542',0.00,0.00,'542','2022-07-23 07:48:31','542','2022-07-23 07:48:54',10,0),('1','145',257745,'DAILY  SHIFT','2022-07-23','2022-07-23 07:49:13','2022-07-24 07:49:13','542',0.00,0.00,'542','2022-07-23 17:44:01','542','2022-07-23 17:47:35',10,0),('1','145',257746,'DAILY  SHIFT','2022-07-25','2022-07-25 07:55:02','2022-07-26 07:55:02','542',0.00,0.00,'542','2022-07-25 19:08:59','542','2022-07-25 19:09:26',10,0),('1','145',257747,'DAILY  SHIFT','2022-07-26','2022-07-26 07:38:45','2022-07-27 07:38:45','542',0.00,0.00,'542','2022-07-26 17:29:38','542','2022-07-26 17:30:16',10,0),('1','145',257748,'DAILY  SHIFT','2022-07-27','2022-07-27 07:37:00','2022-07-28 07:37:00','542',0.00,0.00,'542','2022-07-27 18:08:25','542','2022-07-27 18:08:56',10,0),('1','145',257749,'DAILY  SHIFT','2022-07-28','2022-07-28 07:46:05','2022-07-29 07:46:05','542',0.00,0.00,'542','2022-07-28 17:34:44','542','2022-07-28 17:35:13',10,0),('1','145',257750,'DAILY  SHIFT','2022-07-29','2022-07-29 07:34:57','2022-07-30 07:34:57','542',0.00,0.00,'542','2022-07-29 18:19:22','542','2022-07-29 18:19:44',10,0),('1','145',257751,'DAILY  SHIFT','2022-07-29','2022-07-29 18:54:05','2022-07-30 18:54:05','542',0.00,0.00,'542','2022-07-29 18:58:22','542','2022-07-29 18:58:38',10,0),('1','145',257752,'DAILY  SHIFT','2022-07-30','2022-07-30 07:28:26','2022-07-31 07:28:26','542',0.00,0.00,'542','2022-07-30 23:17:40','542','2022-07-30 23:17:59',10,0),('1','145',257753,'DAILY  SHIFT','2022-07-31','2022-07-31 09:36:26','2022-08-01 09:36:26','542',0.00,0.00,'542','2022-07-31 17:40:26','542','2022-07-31 17:40:53',10,0),('1','145',257754,'DAILY  SHIFT','2022-08-01','2022-08-01 07:47:45','2022-08-02 07:47:45','542',0.00,0.00,'542','2022-08-01 17:47:55','542','2022-08-01 17:48:17',10,0),('1','145',257755,'DAILY  SHIFT','2022-08-02','2022-08-02 07:29:15','2022-08-03 07:29:15','542',0.00,0.00,'542','2022-08-02 16:28:21','542','2022-08-02 16:28:48',10,0),('1','145',257756,'DAILY SHIFT','2022-08-02','2022-08-02 16:29:31','2022-08-03 16:29:31','542',0.00,0.00,'542','2022-08-02 17:25:27','542','2022-08-02 17:25:47',10,0),('1','145',257757,'DAILY  SHIFT','2022-08-03','2022-08-03 07:30:59','2022-08-04 07:30:59','542',0.00,0.00,'542','2022-08-03 19:05:55','542','2022-08-03 19:06:30',10,0),('1','145',257758,'DAILY  SHIFT','2022-08-04','2022-08-04 07:38:58','2022-08-05 07:38:58','542',0.00,0.00,'542','2022-08-04 18:26:29','542','2022-08-04 18:27:54',10,0),('1','145',257759,'DAILY SHIFT','2022-08-05','2022-08-05 07:49:12','2022-08-06 07:49:12','542',0.00,0.00,'542','2022-08-05 18:03:58','542','2022-08-05 18:04:25',10,0),('1','145',257760,'DAILY SHIFT','2022-08-06','2022-08-06 07:31:37','2022-08-07 07:31:37','542',0.00,0.00,'542','2022-08-06 11:52:52','542','2022-08-06 11:53:17',10,0),('1','145',257761,'DAILY SHIFT','2022-08-06','2022-08-06 11:57:39','2022-08-07 11:57:39','542',0.00,0.00,'542','2022-08-06 12:01:14','542','2022-08-06 12:01:31',10,0),('1','145',257762,'DAILY  SHIFT','2022-08-07','2022-08-07 10:38:29','2022-08-08 10:38:29','542',0.00,0.00,'542','2022-08-07 17:43:33','542','2022-08-07 17:44:35',10,0),('1','145',257763,'DAILY  SHIFT','2022-08-08','2022-08-08 07:47:38','2022-08-09 07:47:38','542',0.00,0.00,'542','2022-08-08 18:43:53','542','2022-08-08 18:44:14',10,0),('1','145',257764,'DAILY  SHIFT','2022-08-09','2022-08-09 07:32:01','2022-08-10 07:32:01','542',0.00,0.00,'542','2022-08-09 17:56:05','542','2022-08-09 17:56:52',10,0),('1','145',257765,'DAILY SHIFT','2022-08-10','2022-08-10 14:50:27','2022-08-11 14:50:27','542',0.00,0.00,'542','2022-08-10 14:51:28','542','2022-08-10 14:52:31',10,0),('1','145',257766,'DAILY SHIFT','2022-08-10','2022-08-10 14:53:31','2022-08-11 14:53:31','542',0.00,0.00,'542','2022-08-10 15:47:57','542','2022-08-10 15:48:23',10,0),('1','145',257767,'DAILY  SHIFT','2022-08-10','2022-08-10 15:58:02','2022-08-11 15:58:02','542',0.00,0.00,'542','2022-08-11 09:56:14','542','2022-08-11 09:56:42',10,0),('1','145',257768,'DAILY  SHIFT','2022-08-11','2022-08-11 10:37:33','2022-08-12 10:37:33','542',0.00,0.00,'542','2022-08-11 18:40:47','542','2022-08-11 18:41:23',10,0),('1','145',257769,'DAILY  SHIFT','2022-08-12','2022-08-12 07:29:47','2022-08-13 07:29:47','542',0.00,0.00,'542','2022-08-12 18:39:45','542','2022-08-12 18:40:37',10,0),('1','145',257770,'DAILY  SHIFT','2022-08-13','2022-08-13 07:35:24','2022-08-14 07:35:24','542',0.00,0.00,'542','2022-08-13 10:41:31','542','2022-08-13 10:42:38',10,0),('1','145',257771,'DAILY SHIFT','2022-08-14','2022-08-14 13:52:39','2022-08-15 13:52:39','542',0.00,0.00,'542','2022-08-14 18:06:25','542','2022-08-14 18:07:01',10,0),('1','145',257772,'DAILY  SHIFT','2022-08-15','2022-08-15 07:32:27','2022-08-16 07:32:27','542',0.00,0.00,'542','2022-08-15 18:47:25','542','2022-08-15 18:48:02',10,0),('1','145',257773,'DAILY  SHIFT','2022-08-16','2022-08-16 07:33:32','2022-08-17 07:33:32','542',0.00,0.00,'542','2022-08-16 18:26:40','542','2022-08-16 18:27:18',10,0),('1','145',257774,'DAILY  SHIFT','2022-08-17','2022-08-17 07:38:27','2022-08-18 07:38:27','542',0.00,0.00,'542','2022-08-17 18:12:57','542','2022-08-17 18:13:52',10,0),('1','145',257775,'DAILY  SHIFT','2022-08-18','2022-08-18 07:36:09','2022-08-19 07:36:09','542',0.00,0.00,'542','2022-08-18 17:38:01','542','2022-08-18 17:38:35',10,0),('1','145',257776,'DAILY SHIFT','2022-08-18','2022-08-18 17:42:35','2022-08-19 17:42:35','542',0.00,0.00,'542','2022-08-18 17:46:30','542','2022-08-18 17:46:59',10,0),('1','145',257777,'DAILY  SHIFT','2022-08-19','2022-08-19 07:38:29','2022-08-20 07:38:29','542',0.00,0.00,'542','2022-08-19 18:23:06','542','2022-08-19 18:23:41',10,0),('1','145',257778,'DAILY  SHIFT','2022-08-20','2022-08-20 07:30:35','2022-08-21 07:30:35','542',0.00,0.00,'542','2022-08-20 10:28:59','542','2022-08-20 10:29:20',10,0),('1','145',257779,'DAILY  SHIFT','2022-08-20','2022-08-20 10:29:36','2022-08-21 10:29:36','542',0.00,0.00,'542','2022-08-20 18:40:18','542','2022-08-20 18:41:53',10,0),('1','145',257780,'DAILY  SHIFT','2022-08-21','2022-08-21 09:23:48','2022-08-22 09:23:48','542',0.00,0.00,'542','2022-08-21 17:34:09','542','2022-08-21 17:34:35',10,0),('1','145',257781,'DAILY SHIFT','2022-08-21','2022-08-21 17:38:08','2022-08-22 17:38:08','542',0.00,0.00,'542','2022-08-21 17:41:33','542','2022-08-21 17:41:59',10,0),('1','145',257782,'DAILY  SHIFT','2022-08-22','2022-08-22 07:35:39','2022-08-23 07:35:39','542',0.00,0.00,'542','2022-08-22 17:50:45','542','2022-08-22 17:51:24',10,0),('1','145',257783,'DAILY  SHIFT','2022-08-23','2022-08-23 07:35:32','2022-08-24 07:35:32','542',0.00,0.00,'542','2022-08-23 18:19:17','542','2022-08-23 18:19:44',10,0),('1','145',257784,'DAILY  SHIFT','2022-08-24','2022-08-24 07:31:34','2022-08-25 07:31:34','542',0.00,0.00,'542','2022-08-24 17:38:02','542','2022-08-24 17:39:35',10,0),('1','145',257785,'DAILY  SHIFT','2022-08-25','2022-08-25 07:42:14','2022-08-26 07:42:14','542',0.00,0.00,'542','2022-08-25 18:20:30','542','2022-08-25 18:20:47',10,0),('1','145',257786,'DAILY  SHIFT','2022-08-26','2022-08-26 07:33:14','2022-08-27 07:33:14','542',0.00,0.00,'542','2022-08-26 18:04:02','542','2022-08-26 18:04:29',10,0),('1','145',257787,'DAILY  SHIFT','2022-08-27','2022-08-27 07:48:08','2022-08-28 07:48:08','542',0.00,0.00,'542','2022-08-27 17:44:37','542','2022-08-27 17:45:20',10,0),('1','145',257788,'DAILY  SHIFT','2022-08-28','2022-08-28 09:16:07','2022-08-29 09:16:07','542',0.00,0.00,'542','2022-08-28 14:11:45','542','2022-08-28 14:12:13',10,0),('1','145',257789,'DAILY  SHIFT','2022-08-28','2022-08-28 14:12:58','2022-08-29 14:12:58','542',0.00,0.00,'542','2022-08-28 14:19:40','542','2022-08-28 14:20:02',10,0),('1','145',257790,'DAILY  SHIFT','2022-08-28','2022-08-28 14:20:28','2022-08-29 14:20:28','542',0.00,0.00,'542','2022-08-28 18:11:51','542','2022-08-28 18:12:09',10,0),('1','145',257791,'DAILY  SHIFT','2022-08-29','2022-08-29 07:33:49','2022-08-30 07:33:49','542',0.00,0.00,'542','2022-08-29 17:49:04','542','2022-08-29 17:49:34',10,0),('1','145',257792,'DAILY  SHIFT','2022-08-30','2022-08-30 07:25:13','2022-08-31 07:25:13','542',0.00,0.00,'542','2022-08-30 17:56:08','542','2022-08-30 17:56:31',10,0),('1','145',257793,'DAILY  SHIFT','2022-08-31','2022-08-31 07:22:46','2022-09-01 07:22:46','542',0.00,0.00,'542','2022-08-31 17:06:10','542','2022-08-31 17:06:30',10,0),('1','145',257794,'DAILY  SHIFT','2022-09-01','2022-09-01 08:13:20','2022-09-02 08:13:20','542',0.00,0.00,'542','2022-09-01 17:30:35','542','2022-09-01 17:31:31',10,0),('1','145',257795,'DAILY  SHIFT','2022-09-02','2022-09-02 07:33:56','2022-09-03 07:33:56','542',0.00,0.00,'542','2022-09-02 17:51:29','542','2022-09-02 17:52:02',10,0),('1','145',257796,'DAILY  SHIFT','2022-09-03','2022-09-03 07:32:19','2022-09-04 07:32:19','542',0.00,0.00,'542','2022-09-03 11:20:15','542','2022-09-03 11:21:31',10,0),('1','145',257797,'DAILY  SHIFT','2022-09-03','2022-09-03 11:22:59','2022-09-04 11:22:59','542',0.00,0.00,'542','2022-09-03 19:27:26','542','2022-09-03 19:27:59',10,0),('1','145',257798,'DAILY  SHIFT','2022-09-04','2022-09-04 09:25:24','2022-09-05 09:25:24','542',0.00,0.00,'542','2022-09-04 13:00:23','542','2022-09-04 13:00:51',10,0),('1','145',257799,'DAILY SHIFT','2022-09-04','2022-09-04 13:10:46','2022-09-05 13:10:46','542',0.00,0.00,'542','2022-09-04 13:17:08','542','2022-09-04 13:17:41',10,0),('1','145',257800,'DAILY SHIFT','2022-09-04','2022-09-04 13:18:25','2022-09-05 13:18:25','542',0.00,0.00,'542','2022-09-04 14:42:14','542','2022-09-04 14:42:28',10,0),('1','145',257801,'DAILY  SHIFT','2022-09-05','2022-09-05 07:32:59','2022-09-06 07:32:59','542',0.00,0.00,'542','2022-09-05 19:00:37','542','2022-09-05 19:01:12',10,0),('1','145',257802,'DAILY  SHIFT','2022-09-06','2022-09-06 07:28:29','2022-09-07 07:28:29','542',0.00,0.00,'542','2022-09-06 12:21:31','542','2022-09-06 12:22:15',10,0),('1','145',257803,'DAILY SHIFT','2022-09-06','2022-09-06 12:31:05','2022-09-07 12:31:05','542',0.00,0.00,'542','2022-09-06 12:34:41','542','2022-09-06 12:35:19',10,0),('1','145',257804,'DAILY  SHIFT','2022-09-09','2022-09-09 10:23:06','2022-09-10 10:23:06','542',0.00,0.00,'542','2022-09-09 17:50:21','542','2022-09-09 17:50:37',10,0),('1','145',257805,'DAILY  SHIFT','2022-09-10','2022-09-10 07:32:52','2022-09-11 07:32:52','542',0.00,0.00,'542','2022-09-10 18:39:57','542','2022-09-10 18:40:51',10,0),('1','145',257806,'DAILY  SHIFT','2022-09-11','2022-09-11 09:19:52','2022-09-12 09:19:52','542',0.00,0.00,'542','2022-09-11 18:00:43','542','2022-09-11 18:01:56',10,0),('1','145',257807,'DAILY  SHIFT','2022-09-12','2022-09-12 07:28:14','2022-09-13 07:28:14','542',0.00,0.00,'542','2022-09-12 11:13:09','542','2022-09-12 11:13:54',10,0),('1','145',257808,'DAILY SHIFT','2022-09-12','2022-09-12 11:27:06','2022-09-13 11:27:06','542',0.00,0.00,'542','2022-09-12 12:23:07','542','2022-09-12 12:23:52',10,0),('1','145',257809,'DAILY  SHIFT','2022-09-15','2022-09-15 07:25:33','2022-09-16 07:25:33','542',0.00,0.00,'542','2022-09-15 18:08:01','542','2022-09-15 18:12:41',10,0),('1','145',257810,'DAILY  SHIFT','2022-09-16','2022-09-16 08:06:14','2022-09-17 08:06:14','542',0.00,0.00,'542','2022-09-16 19:06:43','542','2022-09-16 19:07:46',10,0),('1','145',257811,'DAILY  SHIFT','2022-09-17','2022-09-17 07:36:32','2022-09-18 07:36:32','542',0.00,0.00,'542','2022-09-17 18:17:55','542','2022-09-17 18:18:50',10,0),('1','145',257812,'DAILY SHIFT','2022-09-17','2022-09-17 18:22:58','2022-09-18 18:22:58','542',0.00,0.00,'542','2022-09-17 18:29:05','542','2022-09-17 18:29:42',10,0),('1','145',257813,'DAILY  SHIFT','2022-09-18','2022-09-18 09:47:12','2022-09-19 09:47:12','542',0.00,0.00,'542','2022-09-18 18:51:16','542','2022-09-18 18:51:50',10,0),('1','145',257814,'DAILY  SHIFT','2022-09-19','2022-09-19 07:34:05','2022-09-20 07:34:05','542',0.00,0.00,'542','2022-09-19 18:22:02','542','2022-09-19 18:22:31',10,0),('1','145',257815,'DAILY  SHIFT','2022-09-20','2022-09-20 07:34:24','2022-09-21 07:34:24','542',0.00,0.00,'542','2022-09-20 18:13:53','542','2022-09-20 18:14:33',10,0),('1','145',257816,'DAILY  SHIFT','2022-09-21','2022-09-21 07:32:30','2022-09-22 07:32:30','542',0.00,0.00,'542','2022-09-21 17:39:05','542','2022-09-21 17:39:34',10,0),('1','145',257817,'DAILY  SHIFT','2022-09-22','2022-09-22 07:31:06','2022-09-23 07:31:06','542',0.00,0.00,'542','2022-09-22 18:06:08','542','2022-09-22 18:11:14',10,0),('1','145',257818,'DAILY  SHIFT','2022-09-23','2022-09-23 07:33:23','2022-09-24 07:33:23','542',0.00,0.00,'542','2022-09-23 13:11:27','542','2022-09-23 13:12:00',10,0),('1','145',257819,'DAILY  SHIFT','2022-09-23','2022-09-23 13:17:58','2022-09-24 13:17:58','542',0.00,0.00,'542','2022-09-23 17:55:51','542','2022-09-23 17:56:21',10,0),('1','145',257820,'DAILY  SHIFT','2022-09-24','2022-09-24 07:32:43','2022-09-25 07:32:43','542',0.00,0.00,'542','2022-09-24 18:10:54','542','2022-09-24 18:11:29',10,0),('1','145',257821,'DAILY  SHIFT','2022-09-25','2022-09-25 09:23:42','2022-09-26 09:23:42','542',0.00,0.00,'542','2022-09-25 17:30:57','542','2022-09-25 17:31:13',10,0),('1','145',257822,'DAILY  SHIFT','2022-09-26','2022-09-26 07:30:25','2022-09-27 07:30:25','542',0.00,0.00,'542','2022-09-26 17:38:54','542','2022-09-26 17:39:25',10,0),('1','145',257823,'DAILY  SHIFT','2022-09-27','2022-09-27 07:34:48','2022-09-28 07:34:48','542',0.00,0.00,'542','2022-09-27 18:04:05','542','2022-09-27 18:04:31',10,0),('1','145',257824,'DAILY  SHIFT','2022-09-28','2022-09-28 07:37:27','2022-09-29 07:37:27','542',0.00,0.00,'542','2022-09-28 18:04:58','542','2022-09-28 18:05:45',10,0),('1','145',257825,'DAILY  SHIFT','2022-09-29','2022-09-29 07:36:22','2022-09-30 07:36:22','542',0.00,0.00,'542','2022-09-30 07:35:57','542','2022-09-30 07:36:12',10,0),('1','145',257826,'DAILY  SHIFT','2022-09-30','2022-09-30 07:37:00','2022-10-01 07:37:00','542',0.00,0.00,'542','2022-09-30 18:30:18','542','2022-09-30 18:31:58',10,0),('1','145',257827,'DAILY  SHIFT','2022-10-02','2022-10-02 12:38:10','2022-10-03 12:38:10','542',0.00,0.00,'542','2022-10-02 15:43:55','542','2022-10-02 15:44:19',10,0),('1','145',257828,'DAILY SHIFT','2022-10-02','2022-10-02 15:45:18','2022-10-03 15:45:18','542',0.00,0.00,'542','2022-10-02 15:49:10','542','2022-10-02 15:50:02',10,0),('1','145',257829,'DAILY  SHIFT','2022-10-03','2022-10-03 07:28:05','2022-10-04 07:28:05','542',0.00,0.00,'542','2022-10-03 18:23:22','542','2022-10-03 18:23:44',10,0),('1','145',257830,'DAILY  SHIFT','2022-10-04','2022-10-04 08:10:17','2022-10-05 08:10:17','542',0.00,0.00,'542','2022-10-04 17:49:25','542','2022-10-04 17:49:56',10,0),('1','145',257831,'DAILY  SHIFT','2022-10-05','2022-10-05 07:34:39','2022-10-06 07:34:39','542',0.00,0.00,'542','2022-10-05 17:50:52','542','2022-10-05 17:51:23',10,0),('1','145',257832,'DAILY  SHIFT','2022-10-06','2022-10-06 07:31:01','2022-10-07 07:31:01','542',0.00,0.00,'542','2022-10-06 17:49:03','542','2022-10-06 17:49:31',10,0),('1','145',257833,'DAILY  SHIFT','2022-10-07','2022-10-07 07:42:11','2022-10-08 07:42:11','542',0.00,0.00,'542','2022-10-07 17:57:30','542','2022-10-07 17:58:18',10,0),('1','145',257834,'DAILY  SHIFT','2022-10-08','2022-10-08 07:27:55','2022-10-09 07:27:55','542',0.00,0.00,'542','2022-10-08 17:24:18','542','2022-10-08 17:24:55',10,0),('1','145',257835,'DAILY SHIFT','2022-10-08','2022-10-08 17:30:45','2022-10-09 17:30:45','542',0.00,0.00,'542','2022-10-08 17:35:54','542','2022-10-08 17:36:19',10,0),('1','145',257836,'DAILY  SHIFT','2022-10-09','2022-10-09 09:42:12','2022-10-10 09:42:12','542',0.00,0.00,'542','2022-10-09 17:30:45','542','2022-10-09 17:32:10',10,0),('1','145',257837,'DAILY  SHIFT','2022-10-10','2022-10-10 07:41:49','2022-10-11 07:41:49','542',0.00,0.00,'542','2022-10-10 17:34:56','542','2022-10-10 17:35:26',10,0),('1','145',257838,'DAILY  SHIFT','2022-10-11','2022-10-11 07:29:00','2022-10-12 07:29:00','542',0.00,0.00,'542','2022-10-11 11:29:17','542','2022-10-11 11:30:51',10,0),('1','145',257839,'DAILY  SHIFT','2022-10-11','2022-10-11 11:38:31','2022-10-12 11:38:31','542',0.00,0.00,'542','2022-10-11 18:10:11','542','2022-10-11 18:10:49',10,0),('1','145',257840,'OPERATIONAL LOSS','2022-10-11','2022-10-11 18:17:10','2022-10-12 18:17:10','542',0.00,0.00,'542','2022-10-11 18:21:21','542','2022-10-11 18:22:04',10,0),('1','145',257841,'DAILY  SHIFT','2022-10-12','2022-10-12 07:44:26','2022-10-13 07:44:26','542',0.00,0.00,'542','2022-10-12 17:39:08','542','2022-10-12 17:39:30',10,0),('1','145',257842,'DAILY  SHIFT','2022-10-13','2022-10-13 07:41:20','2022-10-14 07:41:20','542',0.00,0.00,'542','2022-10-13 18:44:04','542','2022-10-13 18:46:18',10,0),('1','145',257843,'DAILY  SHIFT','2022-10-14','2022-10-14 07:46:29','2022-10-15 07:46:29','542',0.00,0.00,'542','2022-10-14 17:44:14','542','2022-10-14 17:44:47',10,0),('1','145',257844,'DAILY  SHIFT','2022-10-15','2022-10-15 08:17:38','2022-10-16 08:17:38','542',0.00,0.00,'542','2022-10-15 15:25:04','542','2022-10-15 15:25:27',10,0),('1','145',257845,'DAILY  SHIFT','2022-10-16','2022-10-16 13:11:17','2022-10-17 13:11:17','542',0.00,0.00,'542','2022-10-16 17:38:41','542','2022-10-16 17:39:25',10,0),('1','145',257846,'DAILY  SHIFT','2022-10-17','2022-10-17 07:37:48','2022-10-18 07:37:48','542',0.00,0.00,'542','2022-10-17 17:50:46','542','2022-10-17 17:51:47',10,0),('1','145',257847,'DAILY  SHIFT','2022-10-18','2022-10-18 07:35:42','2022-10-19 07:35:42','542',0.00,0.00,'542','2022-10-18 14:25:23','542','2022-10-18 14:29:57',10,0),('1','145',257848,'OPERATIONAL LOSS','2022-10-21','2022-10-21 17:08:29','2022-10-22 17:08:29','542',0.00,0.00,'542','2022-10-21 17:12:39','542','2022-10-21 17:13:05',10,0),('1','145',257849,'DAILY  SHIFT','2022-10-22','2022-10-22 07:14:05','2022-10-23 07:14:05','542',0.00,0.00,'542','2022-10-22 18:55:15','542','2022-10-22 18:55:39',10,0),('1','145',257850,'DAILY  SHIFT','2022-10-23','2022-10-23 09:52:28','2022-10-24 09:52:28','542',0.00,0.00,'542','2022-10-23 17:59:31','542','2022-10-23 17:59:54',10,0),('1','145',257851,'DAILY  SHIFT','2022-10-24','2022-10-24 07:33:56','2022-10-25 07:33:56','542',0.00,0.00,'542','2022-10-24 18:23:15','542','2022-10-24 18:23:45',10,0),('1','145',257852,'DAILY  SHIFT','2022-10-25','2022-10-25 07:28:11','2022-10-26 07:28:11','542',0.00,0.00,'542','2022-10-25 18:14:22','542','2022-10-25 18:14:49',10,0),('1','145',257853,'DAILY SHIFT','2022-10-26','2022-10-26 07:25:44','2022-10-27 07:25:44','542',0.00,0.00,'542','2022-10-26 08:16:45','542','2022-10-26 08:17:08',10,0),('1','145',257854,'DAILY SHIFT','2022-10-26','2022-10-26 08:17:41','2022-10-27 08:17:41','542',0.00,0.00,'542','2022-10-26 19:34:40','542','2022-10-26 19:35:14',10,0),('1','145',257855,'DAILY  SHIFT','2022-10-27','2022-10-27 07:44:34','2022-10-28 07:44:34','542',0.00,0.00,'542','2022-10-27 16:36:42','542','2022-10-27 16:37:04',10,0),('1','145',257856,'DAILY  SHIFT','2022-10-28','2022-10-28 07:39:05','2022-10-29 07:39:05','542',0.00,0.00,'542','2022-10-28 16:34:57','542','2022-10-28 16:35:17',10,0),('1','145',257857,'OPERATIONAL LOSS','2022-10-29','2022-10-29 12:57:17','2022-10-30 12:57:17','542',0.00,0.00,'542','2022-10-29 13:00:57','542','2022-10-29 13:01:26',10,0),('1','145',257858,'DAILY  SHIFT','2022-10-31','2022-10-31 14:21:08','2022-11-01 14:21:08','542',0.00,0.00,'542','2022-10-31 17:38:51','542','2022-10-31 17:39:20',10,0),('1','145',257859,'DAILY  SHIFT','2022-11-01','2022-11-01 07:39:45','2022-11-02 07:39:45','542',0.00,0.00,'542','2022-11-01 17:38:18','542','2022-11-01 17:38:38',10,0),('1','145',257860,'DAILY  SHIFT','2022-11-02','2022-11-02 07:48:19','2022-11-03 07:48:19','542',0.00,0.00,'542','2022-11-02 18:46:06','542','2022-11-02 18:46:59',10,0),('1','145',257861,'DAILY  SHIFT','2022-11-03','2022-11-03 07:59:36','2022-11-04 07:59:36','542',0.00,0.00,'542','2022-11-03 17:51:53','542','2022-11-03 17:52:16',10,0),('1','145',257862,'DAILY  SHIFT','2022-11-04','2022-11-04 07:39:24','2022-11-05 07:39:24','542',0.00,0.00,'542','2022-11-04 17:47:43','542','2022-11-04 17:48:11',10,0),('1','145',257863,'DAILY  SHIFT','2022-11-05','2022-11-05 08:13:50','2022-11-06 08:13:50','542',0.00,0.00,'542','2022-11-05 18:16:53','542','2022-11-05 18:17:23',10,0),('1','145',257864,'DAILY  SHIFT','2022-11-06','2022-11-06 09:40:31','2022-11-07 09:40:31','542',0.00,0.00,'542','2022-11-07 12:25:42','542','2022-11-07 12:25:57',10,0),('1','145',257865,'DAILY  SHIFT','2022-11-07','2022-11-07 12:26:18','2022-11-08 12:26:18','542',0.00,0.00,'542','2022-11-07 13:32:58','542','2022-11-07 13:33:23',10,0),('1','145',257866,'DAILY SHIFT','2022-11-07','2022-11-07 13:33:51','2022-11-08 13:33:51','542',0.00,0.00,'542','2022-11-07 17:44:33','542','2022-11-07 17:44:54',10,0),('1','145',257867,'DAILY  SHIFT','2022-11-08','2022-11-08 07:50:06','2022-11-09 07:50:06','542',0.00,0.00,'542','2022-11-08 11:06:43','542','2022-11-08 11:07:04',10,0),('1','145',257868,'DAILY  SHIFT','2022-11-08','2022-11-08 11:09:09','2022-11-09 11:09:09','542',0.00,0.00,'542','2022-11-08 18:17:37','542','2022-11-08 18:18:53',10,0),('1','145',257869,'DAILY  SHIFT','2022-11-09','2022-11-09 07:33:17','2022-11-10 07:33:17','542',0.00,0.00,'542','2022-11-09 17:44:01','542','2022-11-09 17:45:41',10,0),('1','145',257870,'DAILY  SHIFT','2022-11-10','2022-11-10 07:37:48','2022-11-11 07:37:48','542',0.00,0.00,'542','2022-11-10 17:21:34','542','2022-11-10 17:22:16',10,0),('1','145',257871,'DAILY  SHIFT','2022-11-11','2022-11-11 07:59:30','2022-11-12 07:59:30','542',0.00,0.00,'542','2022-11-11 17:38:22','542','2022-11-11 17:39:28',10,0),('1','145',257872,'DAILY  SHIFT','2022-11-12','2022-11-12 07:42:08','2022-11-13 07:42:08','542',0.00,0.00,'542','2022-11-12 18:53:36','542','2022-11-12 18:54:08',10,0),('1','145',257873,'DAILY  SHIFT','2022-11-13','2022-11-13 10:42:54','2022-11-14 10:42:54','542',0.00,0.00,'542','2022-11-13 17:38:56','542','2022-11-13 17:39:22',10,0),('1','145',257874,'OPERATIONAL LOSS','2022-11-14','2022-11-14 07:40:36','2022-11-15 07:40:36','542',0.00,0.00,'542','2022-11-14 07:50:03','542','2022-11-14 07:50:30',10,0),('1','145',257875,'DAILY SHIFT','2022-11-14','2022-11-14 07:50:49','2022-11-15 07:50:49','542',0.00,0.00,'542','2022-11-14 18:05:15','542','2022-11-14 18:05:47',10,0),('1','145',257876,'DAILY  SHIFT','2022-11-15','2022-11-15 13:33:35','2022-11-16 13:33:35','542',0.00,0.00,'542','2022-11-15 17:42:55','542','2022-11-15 17:43:46',10,0),('1','145',257877,'DAILY  SHIFT','2022-11-16','2022-11-16 07:43:29','2022-11-17 07:43:29','542',0.00,0.00,'542','2022-11-16 18:20:18','542','2022-11-16 18:21:12',10,0),('1','145',257878,'DAILY  SHIFT','2022-11-17','2022-11-17 07:40:02','2022-11-18 07:40:02','542',0.00,0.00,'542','2022-11-17 13:00:40','542','2022-11-17 13:13:35',10,0),('1','145',257879,'DAILY  SHIFT','2022-11-17','2022-11-17 13:13:55','2022-11-18 13:13:55','542',0.00,0.00,'542','2022-11-17 17:36:40','542','2022-11-17 17:36:58',10,0),('1','145',257880,'DAILY  SHIFT','2022-11-18','2022-11-18 07:43:29','2022-11-19 07:43:29','542',0.00,0.00,'542','2022-11-18 18:21:29','542','2022-11-18 18:22:54',10,0),('1','145',257881,'DAILY  SHIFT','2022-11-19','2022-11-19 07:43:55','2022-11-20 07:43:55','542',0.00,0.00,'542','2022-11-19 17:46:19','542','2022-11-19 17:46:49',10,0),('1','145',257882,'OPERATIONAL LOSS','2022-11-19','2022-11-19 17:54:33','2022-11-20 17:54:33','542',0.00,0.00,'542','2022-11-19 17:57:44','542','2022-11-19 17:58:06',10,0),('1','145',257883,'DAILY  SHIFT','2022-11-20','2022-11-20 09:32:21','2022-11-21 09:32:21','542',0.00,0.00,'542','2022-11-20 17:04:26','542','2022-11-20 17:05:41',10,0),('1','145',257884,'DAILY  SHIFT','2022-11-21','2022-11-21 07:57:37','2022-11-22 07:57:37','542',0.00,0.00,'542','2022-11-21 17:17:11','542','2022-11-21 17:17:36',10,0),('1','145',257885,'DAILY  SHIFT','2022-11-22','2022-11-22 07:43:08','2022-11-23 07:43:08','542',0.00,0.00,'542','2022-11-22 17:34:33','542','2022-11-22 17:35:03',10,0),('1','145',257886,'DAILY SHIFT','2022-11-23','2022-11-23 08:04:31','2022-11-24 08:04:31','542',0.00,0.00,'542','2022-11-23 17:22:02','542','2022-11-23 17:22:54',10,0),('1','145',257887,'DAILY  SHIFT','2022-11-24','2022-11-24 07:42:43','2022-11-25 07:42:43','542',0.00,0.00,'542','2022-11-24 17:18:12','542','2022-11-24 17:18:56',10,0),('1','145',257888,'DAILY  SHIFT','2022-11-25','2022-11-25 07:46:42','2022-11-26 07:46:42','542',0.00,0.00,'542','2022-11-25 17:30:12','542','2022-11-25 17:31:09',10,0),('1','145',257889,'DAILY SHIFT','2022-11-26','2022-11-26 07:35:54','2022-11-27 07:35:54','542',0.00,0.00,'542','2022-11-26 17:04:28','542','2022-11-26 17:05:03',10,0),('1','145',257890,'DAILY  SHIFT','2022-11-27','2022-11-27 09:51:43','2022-11-28 09:51:43','542',0.00,0.00,'542','2022-11-27 17:36:43','542','2022-11-27 17:37:12',10,0),('1','145',257891,'DAILY  SHIFT','2022-11-28','2022-11-28 07:44:40','2022-11-29 07:44:40','542',0.00,0.00,'542','2022-11-28 11:58:37','542','2022-11-28 11:59:18',10,0),('1','145',257892,'DAILY  SHIFT','2022-11-28','2022-11-28 11:59:36','2022-11-29 11:59:36','542',0.00,0.00,'542','2022-11-28 17:32:39','542','2022-11-28 17:33:25',10,0),('1','145',257893,'DAILY SHIFT','2022-11-29','2022-11-29 07:38:46','2022-11-30 07:38:46','542',0.00,0.00,'542','2022-11-29 18:29:03','542','2022-11-29 18:29:34',10,0),('1','145',257894,'DAILY  SHIFT','2022-11-30','2022-11-30 07:25:02','2022-12-01 07:25:02','542',0.00,0.00,'542','2022-11-30 18:01:13','542','2022-11-30 18:01:40',10,0),('1','145',257895,'DAILY SHIFT','2022-12-01','2022-12-01 07:42:53','2022-12-02 07:42:53','542',0.00,0.00,'542','2022-12-01 18:01:47','542','2022-12-01 18:02:22',10,0),('1','145',257896,'DAILY  SHIFT','2022-12-02','2022-12-02 07:44:25','2022-12-03 07:44:25','542',0.00,0.00,'542','2022-12-02 17:47:55','542','2022-12-02 17:48:51',10,0),('1','145',257897,'OPERATIONAL LOSS','2022-12-02','2022-12-02 17:53:28','2022-12-03 17:53:28','542',0.00,0.00,'542','2022-12-02 17:56:47','542','2022-12-02 17:57:17',10,0),('1','145',257898,'DAILY SHIFT','2022-12-03','2022-12-03 07:43:13','2022-12-04 07:43:13','542',0.00,0.00,'542','2022-12-03 18:09:27','542','2022-12-03 18:10:09',10,0),('1','145',257899,'DAILY  SHIFT','2022-12-04','2022-12-04 09:17:50','2022-12-05 09:17:50','542',0.00,0.00,'542','2022-12-04 17:16:49','542','2022-12-04 17:17:05',10,0),('1','145',257900,'DAILY SHIFT','2022-12-05','2022-12-05 07:45:13','2022-12-06 07:45:13','542',0.00,0.00,'542','2022-12-05 17:56:35','542','2022-12-05 17:58:17',10,0),('1','145',257901,'DAILY  SHIFT','2022-12-06','2022-12-06 07:30:40','2022-12-07 07:30:40','542',0.00,0.00,'542','2022-12-06 10:32:41','542','2022-12-06 10:33:08',10,0),('1','145',257902,'OPERATIONAL LOSS','2022-12-06','2022-12-06 10:37:43','2022-12-07 10:37:43','542',0.00,0.00,'542','2022-12-06 10:41:03','542','2022-12-06 10:41:25',10,0),('1','145',257903,'DAILY  SHIFT','2022-12-07','2022-12-07 14:57:02','2022-12-08 14:57:02','542',0.00,0.00,'542','2022-12-07 18:27:37','542','2022-12-07 18:28:04',10,0),('1','145',257904,'DAILY  SHIFT','2022-12-08','2022-12-08 07:18:58','2022-12-09 07:18:58','542',0.00,0.00,'542','2022-12-08 17:53:01','542','2022-12-08 17:53:47',10,0),('1','145',257905,'DAILY  SHIFT','2022-12-09','2022-12-09 07:33:34','2022-12-10 07:33:34','542',0.00,0.00,'542','2022-12-09 18:04:57','542','2022-12-09 18:05:24',10,0),('1','145',257906,'DAILY  SHIFT','2022-12-10','2022-12-10 07:54:34','2022-12-11 07:54:34','542',0.00,0.00,'542','2022-12-11 10:24:22','542','2022-12-11 10:24:57',10,0),('1','145',257907,'DAILY  SHIFT','2022-12-11','2022-12-11 10:25:22','2022-12-12 10:25:22','542',0.00,0.00,'542','2022-12-11 17:49:53','542','2022-12-11 17:50:19',10,0),('1','145',257908,'DAILY  SHIFT','2022-12-12','2022-12-12 07:45:20','2022-12-13 07:45:20','542',0.00,0.00,'542','2022-12-12 17:46:39','542','2022-12-12 17:47:31',10,0),('1','145',257909,'DAILY  SHIFT','2022-12-13','2022-12-13 07:37:54','2022-12-14 07:37:54','542',0.00,0.00,'542','2022-12-13 17:43:34','542','2022-12-13 17:44:24',10,0),('1','145',257910,'DAILY  SHIFT','2022-12-14','2022-12-14 07:40:07','2022-12-15 07:40:07','542',0.00,0.00,'542','2022-12-14 17:22:48','542','2022-12-14 17:23:31',10,0),('1','145',257911,'DAILY  SHIFT','2022-12-15','2022-12-15 07:35:51','2022-12-16 07:35:51','542',0.00,0.00,'542','2022-12-15 09:42:52','542','2022-12-15 09:43:19',10,0),('1','145',257912,'DAILY  SHIFT','2022-12-15','2022-12-15 09:44:46','2022-12-16 09:44:46','542',0.00,0.00,'542','2022-12-15 16:43:23','542','2022-12-15 16:43:46',10,0),('1','145',257913,'DAILY SHIFT','2022-12-16','2022-12-16 07:43:57','2022-12-17 07:43:57','542',0.00,0.00,'542','2022-12-16 17:30:58','542','2022-12-16 17:31:27',10,0),('1','145',257914,'OPERATIONAL LOSS','2022-12-16','2022-12-16 17:35:12','2022-12-17 17:35:12','542',0.00,0.00,'542','2022-12-16 17:39:20','542','2022-12-16 17:39:50',10,0),('1','145',257915,'DAILY  SHIFT','2022-12-17','2022-12-17 07:48:50','2022-12-18 07:48:50','542',0.00,0.00,'542','2022-12-17 17:43:22','542','2022-12-17 17:44:30',10,0),('1','145',257916,'DAILY  SHIFT','2022-12-18','2022-12-18 09:37:46','2022-12-19 09:37:46','542',0.00,0.00,'542','2022-12-18 17:28:46','542','2022-12-18 17:29:07',10,0),('1','145',257917,'DAILY  SHIFT','2022-12-19','2022-12-19 07:35:10','2022-12-20 07:35:10','542',0.00,0.00,'542','2022-12-19 18:05:42','542','2022-12-19 18:06:18',10,0),('1','145',257918,'DAILY  SHIFT','2022-12-20','2022-12-20 07:45:26','2022-12-21 07:45:26','542',0.00,0.00,'542','2022-12-20 18:07:24','542','2022-12-20 18:07:58',10,0),('1','145',257919,'DAILY  SHIFT','2022-12-21','2022-12-21 07:40:45','2022-12-22 07:40:45','542',0.00,0.00,'542','2022-12-21 17:48:00','542','2022-12-21 17:48:38',10,0),('1','145',257920,'DAILY  SHIFT','2022-12-22','2022-12-22 07:44:43','2022-12-23 07:44:43','542',0.00,0.00,'542','2022-12-22 18:46:25','542','2022-12-22 18:47:28',10,0),('1','145',257921,'DAILY  SHIFT','2022-12-23','2022-12-23 07:48:29','2022-12-24 07:48:29','542',0.00,0.00,'542','2022-12-23 18:28:27','542','2022-12-23 18:30:02',10,0),('1','145',257922,'DAILY SHIFT','2022-12-24','2022-12-24 08:47:57','2022-12-25 08:47:57','542',0.00,0.00,'542','2022-12-24 10:11:57','542','2022-12-24 10:12:16',10,0),('1','145',257923,'DAILY  SHIFT','2022-12-24','2022-12-24 10:12:54','2022-12-25 10:12:54','542',0.00,0.00,'542','2022-12-24 19:29:53','542','2022-12-24 19:30:20',10,0),('1','145',257924,'DAILY  SHIFT','2022-12-25','2022-12-25 09:35:07','2022-12-26 09:35:07','542',0.00,0.00,'542','2022-12-25 17:52:55','542','2022-12-25 17:53:31',10,0),('1','145',257925,'DAILY  SHIFT','2022-12-26','2022-12-26 07:42:26','2022-12-27 07:42:26','542',0.00,0.00,'542','2022-12-26 18:48:28','542','2022-12-26 18:48:52',10,0),('1','145',257926,'DAILY  SHIFT','2022-12-28','2022-12-28 08:21:38','2022-12-29 08:21:38','542',0.00,0.00,'542','2022-12-28 14:17:42','542','2022-12-28 14:18:06',10,0),('1','145',257927,'DAILY  SHIFT','2022-12-29','2022-12-29 07:42:24','2022-12-30 07:42:24','542',0.00,0.00,'542','2022-12-29 12:12:48','542','2022-12-29 12:13:10',10,0),('1','145',257928,'OPERATIONAL LOSS','2022-12-29','2022-12-29 12:13:41','2022-12-30 12:13:41','542',0.00,0.00,'542','2022-12-29 12:22:48','542','2022-12-29 12:23:09',10,0),('1','145',257929,'DAILY  SHIFT','2022-12-29','2022-12-29 12:23:26','2022-12-30 12:23:26','542',0.00,0.00,'542','2022-12-29 17:20:27','542','2022-12-29 17:20:53',10,0),('1','145',257930,'DAILY  SHIFT','2022-12-30','2022-12-30 07:44:45','2022-12-31 07:44:45','542',0.00,0.00,'542','2022-12-30 17:53:18','542','2022-12-30 17:53:35',10,0),('1','145',257931,'DAILY  SHIFT','2022-12-31','2022-12-31 07:44:53','2023-01-01 07:44:53','542',0.00,0.00,'542','2022-12-31 18:13:28','542','2022-12-31 18:13:58',10,0),('1','145',257932,'DAILY  SHIFT','2023-01-01','2023-01-01 09:23:50','2023-01-02 09:23:50','542',0.00,0.00,'542','2023-01-01 17:12:38','542','2023-01-01 17:12:54',10,0),('1','145',257933,'DAILY  SHIFT','2023-01-02','2023-01-02 07:41:53','2023-01-03 07:41:53','542',0.00,0.00,'542','2023-01-02 14:32:09','542','2023-01-02 14:32:38',10,0),('1','145',257934,'DAILY  SHIFT','2023-01-03','2023-01-03 07:41:06','2023-01-04 07:41:06','542',0.00,0.00,'542','2023-01-03 10:36:34','542','2023-01-03 10:37:10',10,0),('1','145',257935,'OPERATIONAL LOSS','2023-01-03','2023-01-03 10:40:31','2023-01-04 10:40:31','542',0.00,0.00,'542','2023-01-03 10:43:09','542','2023-01-03 10:43:31',10,0),('1','145',257936,'OPERATIONAL LOSS','2023-01-03','2023-01-03 10:44:04','2023-01-04 10:44:04','542',0.00,0.00,'542','2023-01-03 10:47:54','542','2023-01-03 10:48:43',10,0),('1','145',257937,'DAILY  SHIFT','2023-01-03','2023-01-03 11:49:05','2023-01-04 11:49:05','542',0.00,0.00,'542','2023-01-03 17:25:14','542','2023-01-03 17:25:46',10,0),('1','145',257938,'DAILY  SHIFT','2023-01-04','2023-01-04 07:40:31','2023-01-05 07:40:31','542',0.00,0.00,'542','2023-01-04 17:13:31','542','2023-01-04 17:13:58',10,0),('1','145',257939,'DAILY  SHIFT','2023-01-05','2023-01-05 07:45:40','2023-01-06 07:45:40','542',0.00,0.00,'542','2023-01-05 18:12:31','542','2023-01-05 18:13:02',10,0),('1','145',257940,'DAILY  SHIFT','2023-01-06','2023-01-06 07:44:25','2023-01-07 07:44:25','542',0.00,0.00,'542','2023-01-06 18:31:06','542','2023-01-06 18:31:28',10,0),('1','145',257941,'DAILY  SHIFT','2023-01-07','2023-01-07 07:40:08','2023-01-08 07:40:08','542',0.00,0.00,'542','2023-01-07 08:49:53','542','2023-01-07 08:50:17',10,0),('1','145',257942,'DAILY  SHIFT','2023-01-07','2023-01-07 08:51:12','2023-01-08 08:51:12','542',0.00,0.00,'542','2023-01-07 17:22:09','542','2023-01-07 17:22:58',10,0),('1','145',257943,'OPERATIONAL LOSS','2023-01-07','2023-01-07 17:33:42','2023-01-08 17:33:42','542',0.00,0.00,'542','2023-01-07 17:36:26','542','2023-01-07 17:36:57',10,0),('1','145',257944,'DAILY  SHIFT','2023-01-08','2023-01-08 09:51:40','2023-01-09 09:51:40','542',0.00,0.00,'542','2023-01-08 17:35:43','542','2023-01-08 17:36:11',10,0),('1','145',257945,'DAILY  SHIFT','2023-01-09','2023-01-09 07:40:21','2023-01-10 07:40:21','542',0.00,0.00,'542','2023-01-09 18:09:05','542','2023-01-09 18:09:27',10,0),('1','145',257946,'DAILY  SHIFT','2023-01-10','2023-01-10 07:41:20','2023-01-11 07:41:20','542',0.00,0.00,'542','2023-01-10 10:15:29','542','2023-01-10 10:15:57',10,0),('1','145',257947,'OPERATIONAL LOSS','2023-01-10','2023-01-10 12:09:03','2023-01-11 12:09:03','542',0.00,0.00,'542','2023-01-10 12:15:37','542','2023-01-10 12:16:04',10,0),('1','145',257948,'DAILY  SHIFT','2023-01-10','2023-01-10 12:54:23','2023-01-11 12:54:23','542',0.00,0.00,'542','2023-01-10 17:40:01','542','2023-01-10 17:42:26',10,0),('1','145',257949,'DAILY  SHIFT','2023-01-11','2023-01-11 07:38:48','2023-01-12 07:38:48','542',0.00,0.00,'542','2023-01-11 18:31:11','542','2023-01-11 18:31:58',10,0),('1','145',257950,'DAILY  SHIFT','2023-01-12','2023-01-12 07:52:42','2023-01-13 07:52:42','542',0.00,0.00,'542','2023-01-12 18:39:20','542','2023-01-12 18:40:05',10,0),('1','145',257951,'DAILY  SHIFT','2023-01-13','2023-01-13 07:45:20','2023-01-14 07:45:20','542',0.00,0.00,'542','2023-01-13 10:08:53','542','2023-01-13 10:10:11',10,0),('1','145',257952,'DAILY  SHIFT','2023-01-14','2023-01-14 08:11:42','2023-01-15 08:11:42','542',0.00,0.00,'542','2023-01-14 18:15:55','542','2023-01-14 18:16:22',10,0),('1','145',257953,'DAILY  SHIFT','2023-01-15','2023-01-15 09:41:32','2023-01-16 09:41:32','542',0.00,0.00,'542','2023-01-15 17:21:58','542','2023-01-15 17:22:39',10,0),('1','145',257954,'OPERATIONAL LOSS','2023-01-15','2023-01-15 17:32:32','2023-01-16 17:32:32','542',0.00,0.00,'542','2023-01-15 17:35:29','542','2023-01-15 17:35:48',10,0),('1','145',257955,'DAILY  SHIFT','2023-01-16','2023-01-16 07:46:00','2023-01-17 07:46:00','542',0.00,0.00,'542','2023-01-16 17:48:13','542','2023-01-16 17:49:34',10,0),('1','145',257956,'DAILY  SHIFT','2023-01-17','2023-01-17 07:47:22','2023-01-18 07:47:22','542',0.00,0.00,'542','2023-01-17 17:42:56','542','2023-01-17 17:43:22',10,0),('1','145',257957,'DAILY  SHIFT','2023-01-18','2023-01-18 07:49:14','2023-01-19 07:49:14','542',0.00,0.00,'542','2023-01-18 17:37:18','542','2023-01-18 17:37:55',10,0),('1','145',257958,'DAILY  SHIFT','2023-01-19','2023-01-19 07:45:11','2023-01-20 07:45:11','542',0.00,0.00,'542','2023-01-19 09:52:23','542','2023-01-19 09:52:41',10,0),('1','145',257959,'DAILY  SHIFT','2023-01-19','2023-01-19 09:53:07','2023-01-20 09:53:07','542',0.00,0.00,'542','2023-01-19 17:46:26','542','2023-01-19 17:47:17',10,0),('1','145',257960,'DAILY  SHIFT','2023-01-20','2023-01-20 07:49:42','2023-01-21 07:49:42','542',0.00,0.00,'542','2023-01-20 18:29:45','542','2023-01-20 18:30:28',10,0),('1','145',257961,'DAILY SHIFT','2023-01-21','2023-01-21 07:51:48','2023-01-22 07:51:48','542',0.00,0.00,'542','2023-01-21 17:50:45','542','2023-01-21 17:51:16',10,0),('1','145',257962,'DAILY  SHIFT','2023-01-22','2023-01-22 09:24:18','2023-01-23 09:24:18','542',0.00,0.00,'542','2023-01-22 17:21:21','542','2023-01-22 17:21:55',10,0),('1','145',257963,'DAILY  SHIFT','2023-01-23','2023-01-23 07:45:36','2023-01-24 07:45:36','542',0.00,0.00,'542','2023-01-23 18:06:12','542','2023-01-23 18:06:33',10,0),('1','145',257964,'DAILY  SHIFT','2023-01-24','2023-01-24 07:46:47','2023-01-25 07:46:47','542',0.00,0.00,'542','2023-01-24 13:44:08','542','2023-01-24 13:45:26',10,0),('1','145',257965,'OPERATIONAL LOSS','2023-01-25','2023-01-25 14:40:58','2023-01-26 14:40:58','542',0.00,0.00,'542','2023-01-25 14:44:21','542','2023-01-25 14:45:01',10,0),('1','145',257966,'OPERATIONAL LOSS','2023-01-25','2023-01-25 14:45:44','2023-01-26 14:45:44','542',0.00,0.00,'542','2023-01-25 14:50:29','542','2023-01-25 14:50:58',10,0),('1','145',257967,'DAILY  SHIFT','2023-01-26','2023-01-26 08:11:31','2023-01-27 08:11:31','542',0.00,0.00,'542','2023-01-27 07:48:52','542','2023-01-27 07:49:09',10,0),('1','145',257968,'DAILY  SHIFT','2023-01-27','2023-01-27 08:07:40','2023-01-28 08:07:40','542',0.00,0.00,'542','2023-01-27 18:07:49','542','2023-01-27 18:08:30',10,0),('1','145',257969,'DAILY SHIFT','2023-01-27','2023-01-27 18:23:33','2023-01-28 18:23:33','542',0.00,0.00,'542','2023-01-27 18:28:17','542','2023-01-27 18:28:44',10,0),('1','145',257970,'DAILY  SHIFT','2023-01-28','2023-01-28 07:44:26','2023-01-29 07:44:26','542',0.00,0.00,'542','2023-01-28 18:13:00','542','2023-01-28 18:13:46',10,0),('1','145',257971,'DAILY  SHIFT','2023-01-29','2023-01-29 09:36:49','2023-01-30 09:36:49','542',0.00,0.00,'542','2023-01-29 17:05:57','542','2023-01-29 17:06:54',10,0),('1','145',257972,'DAILY  SHIFT','2023-01-30','2023-01-30 07:38:22','2023-01-31 07:38:22','542',0.00,0.00,'542','2023-01-30 17:54:22','542','2023-01-30 17:55:02',10,0),('1','145',257973,'DAILY  SHIFT','2023-01-31','2023-01-31 07:38:37','2023-02-01 07:38:37','542',0.00,0.00,'542','2023-01-31 18:38:00','542','2023-01-31 18:39:21',10,0),('1','145',257974,'DAILY  SHIFT','2023-02-01','2023-02-01 07:44:30','2023-02-02 07:44:30','542',0.00,0.00,'542','2023-02-01 11:02:49','542','2023-02-01 11:48:12',10,0),('1','145',257975,'DAILY  SHIFT','2023-02-02','2023-02-02 07:52:34','2023-02-03 07:52:34','542',0.00,0.00,'542','2023-02-02 18:35:48','542','2023-02-02 18:36:48',10,0),('1','145',257976,'DAILY  SHIFT','2023-02-03','2023-02-03 07:34:49','2023-02-04 07:34:49','542',0.00,0.00,'542','2023-02-03 17:40:51','542','2023-02-03 17:41:36',10,0),('1','145',257977,'DAILY  SHIFT','2023-02-04','2023-02-04 07:38:55','2023-02-05 07:38:55','542',0.00,0.00,'542','2023-02-04 18:27:33','542','2023-02-04 18:28:04',10,0),('1','145',257978,'DAILY SHIFT','2023-02-05','2023-02-05 08:55:37','2023-02-06 08:55:37','542',0.00,0.00,'542','2023-02-05 17:29:58','542','2023-02-05 17:30:14',10,0),('1','145',257979,'DAILY  SHIFT','2023-02-06','2023-02-06 07:44:02','2023-02-07 07:44:02','542',0.00,0.00,'542','2023-02-06 18:17:08','542','2023-02-06 18:17:35',10,0),('1','145',257980,'OPERATIONAL LOSS','2023-02-06','2023-02-06 18:27:10','2023-02-07 18:27:10','542',0.00,0.00,'542','2023-02-06 18:32:47','542','2023-02-06 18:33:23',10,0),('1','145',257981,'DAILY  SHIFT','2023-02-07','2023-02-07 07:40:53','2023-02-08 07:40:53','542',0.00,0.00,'542','2023-02-07 11:38:32','542','2023-02-07 11:39:22',10,0),('1','145',257982,'DAILY  SHIFT46662','2023-02-09','2023-02-09 07:49:20','2023-02-10 07:49:20','542',0.00,0.00,'542','2023-02-09 17:53:15','542','2023-02-09 18:01:23',10,0),('1','145',257983,'DAILY  SHIFT','2023-02-10','2023-02-10 07:47:19','2023-02-11 07:47:19','542',0.00,0.00,'542','2023-02-10 17:59:18','542','2023-02-10 18:00:12',10,0),('1','145',257984,'DAILY  SHIFT','2023-02-11','2023-02-11 07:45:24','2023-02-12 07:45:24','542',0.00,0.00,'542','2023-02-11 18:13:33','542','2023-02-11 18:13:59',10,0),('1','145',257985,'OPERATIONAL LOSS','2023-02-11','2023-02-11 18:23:39','2023-02-12 18:23:39','542',0.00,0.00,'542','2023-02-11 18:33:02','542','2023-02-11 18:33:48',10,0),('1','145',257986,'DAILY  SHIFT46662','2023-02-12','2023-02-12 09:33:25','2023-02-13 09:33:25','542',0.00,0.00,'542','2023-02-12 17:46:36','542','2023-02-12 17:46:58',10,0),('1','145',257987,'DAILY SHIFT','2023-02-13','2023-02-13 07:33:43','2023-02-14 07:33:43','542',0.00,0.00,'542','2023-02-13 18:57:36','542','2023-02-13 18:58:40',10,0),('1','145',257988,'DAILY SHIFT','2023-02-14','2023-02-14 07:31:57','2023-02-15 07:31:57','542',0.00,0.00,'542','2023-02-14 16:46:57','542','2023-02-14 16:47:21',10,0),('1','145',257989,'DAILY  SHIFT','2023-02-14','2023-02-14 16:51:23','2023-02-15 16:51:23','542',0.00,0.00,'542','2023-02-14 19:12:03','542','2023-02-14 19:13:14',10,0),('1','145',257990,'DAILY  SHIFT','2023-02-15','2023-02-15 07:47:50','2023-02-16 07:47:50','542',0.00,0.00,'542','2023-02-15 18:47:16','542','2023-02-15 18:48:00',10,0),('1','145',257991,'DAILY SHIFT','2023-02-16','2023-02-16 07:40:19','2023-02-17 07:40:19','542',0.00,0.00,'542','2023-02-16 18:20:10','542','2023-02-16 18:20:37',10,0),('1','145',257992,'DAILY SHIFT','2023-02-17','2023-02-17 07:58:23','2023-02-18 07:58:23','542',0.00,0.00,'542','2023-02-17 18:42:04','542','2023-02-17 18:42:30',10,0),('1','145',257993,'DAILY  SHIFT','2023-02-18','2023-02-18 07:39:20','2023-02-19 07:39:20','542',0.00,0.00,'542','2023-02-18 18:29:51','542','2023-02-18 18:30:35',10,0),('1','145',257994,'DAILY  SHIFT','2023-02-19','2023-02-19 09:30:52','2023-02-20 09:30:52','542',0.00,0.00,'542','2023-02-19 17:13:46','542','2023-02-19 17:14:17',10,0),('1','145',257995,'OPERATIONAL LOSS','2023-02-19','2023-02-19 17:28:46','2023-02-20 17:28:46','542',0.00,0.00,'542','2023-02-19 17:34:42','542','2023-02-19 17:34:56',10,0),('1','145',257996,'DAILY  SHIFT','2023-02-20','2023-02-20 07:45:55','2023-02-21 07:45:55','542',0.00,0.00,'542','2023-02-20 08:26:46','542','2023-02-20 08:27:06',10,0),('1','145',257997,'DAILY  SHIFT','2023-02-20','2023-02-20 08:27:20','2023-02-21 08:27:20','542',0.00,0.00,'542','2023-02-20 19:55:56','542','2023-02-20 19:56:39',10,0),('1','145',257998,'DAILY SHIFT','2023-02-21','2023-02-21 08:00:39','2023-02-22 08:00:39','542',0.00,0.00,'542','2023-02-21 18:59:32','542','2023-02-21 19:02:40',10,0),('1','145',257999,'DAILY SHIFT','2023-02-22','2023-02-22 07:39:58','2023-02-23 07:39:58','542',0.00,0.00,'542','2023-02-22 18:39:15','542','2023-02-22 18:40:02',10,0),('1','145',258000,'DAILY  SHIFT','2023-02-23','2023-02-23 07:51:51','2023-02-24 07:51:51','542',0.00,0.00,'542','2023-02-23 18:43:36','542','2023-02-23 18:44:46',10,0),('1','145',258001,'DAILY  SHIFT','2023-02-24','2023-02-24 07:38:04','2023-02-25 07:38:04','542',0.00,0.00,'542','2023-02-24 20:04:05','542','2023-02-24 20:22:01',10,0),('1','145',258002,'DAILY  SHIFT','2023-02-27','2023-02-27 07:34:17','2023-02-28 07:34:17','542',0.00,0.00,'542','2023-02-27 19:02:42','542','2023-02-27 19:03:22',10,0),('1','145',258003,'DAILY  SHIFT15','2023-02-28','2023-02-28 07:33:45','2023-03-01 07:33:45','542',0.00,0.00,'542','2023-02-28 08:15:46','542','2023-02-28 08:16:11',10,0),('1','145',258004,'OPERATIONAL LOSS','2023-02-28','2023-02-28 08:16:30','2023-03-01 08:16:30','542',0.00,0.00,'542','2023-02-28 08:24:27','542','2023-02-28 08:24:47',10,0),('1','145',258005,'DAILY SHIFT','2023-02-28','2023-02-28 08:25:17','2023-03-01 08:25:17','542',0.00,0.00,'542','2023-02-28 18:40:32','542','2023-02-28 18:41:19',10,0),('1','145',258006,'DAILY  SHIFT','2023-03-01','2023-03-01 07:39:25','2023-03-02 07:39:25','542',0.00,0.00,'542','2023-03-01 18:09:31','542','2023-03-01 18:10:21',10,0),('1','145',258007,'DAILY  SHIFT','2023-03-02','2023-03-02 07:36:26','2023-03-03 07:36:26','542',0.00,0.00,'542','2023-03-02 18:16:58','542','2023-03-02 18:17:54',10,0),('1','145',258008,'DAILY  SHIFT','2023-03-03','2023-03-03 07:41:25','2023-03-04 07:41:25','542',0.00,0.00,'542','2023-03-03 19:09:31','542','2023-03-03 19:10:01',10,0),('1','145',258009,'DAILY  SHIFT','2023-03-04','2023-03-04 08:05:53','2023-03-05 08:05:53','542',0.00,0.00,'542','2023-03-04 18:54:54','542','2023-03-04 18:56:13',10,0),('1','145',258010,'DAILY  SHIFT','2023-03-05','2023-03-05 09:52:57','2023-03-06 09:52:57','542',0.00,0.00,'542','2023-03-05 17:14:29','542','2023-03-05 17:15:02',10,0),('1','145',258011,'DAILY  SHIFT','2023-03-06','2023-03-06 07:41:27','2023-03-07 07:41:27','542',0.00,0.00,'542','2023-03-06 18:51:29','542','2023-03-06 18:52:05',10,0),('1','145',258012,'OPERATIONAL LOSS','2023-03-06','2023-03-06 19:22:15','2023-03-07 19:22:15','542',0.00,0.00,'542','2023-03-06 19:29:53','542','2023-03-06 19:30:12',10,0),('1','145',258013,'DAILY SHIFT','2023-03-07','2023-03-07 07:50:25','2023-03-08 07:50:25','542',0.00,0.00,'542','2023-03-07 18:57:26','542','2023-03-07 18:58:24',10,0),('1','145',258014,'DAILY  SHIFT','2023-03-08','2023-03-08 07:37:44','2023-03-09 07:37:44','542',0.00,0.00,'542','2023-03-08 18:40:25','542','2023-03-08 18:41:11',10,0),('1','145',258015,'DAILY  SHIFT','2023-03-09','2023-03-09 08:46:34','2023-03-10 08:46:34','542',0.00,0.00,'542','2023-03-09 18:29:06','542','2023-03-09 18:29:58',10,0),('1','145',258016,'DAILY  SHIFT','2023-03-10','2023-03-10 07:49:17','2023-03-11 07:49:17','542',0.00,0.00,'542','2023-03-10 17:59:34','542','2023-03-10 18:01:16',10,0),('1','145',258017,'DAILY  SHIFT','2023-03-11','2023-03-11 07:46:49','2023-03-12 07:46:49','542',0.00,0.00,'542','2023-03-11 18:53:10','542','2023-03-11 18:53:57',10,0),('1','145',258018,'DAILY  SHIFT','2023-03-12','2023-03-12 10:05:51','2023-03-13 10:05:51','542',0.00,0.00,'542','2023-03-12 17:21:05','542','2023-03-12 17:22:00',10,0),('1','145',258019,'DAILY  SHIFT','2023-03-13','2023-03-13 07:37:26','2023-03-14 07:37:26','542',0.00,0.00,'542','2023-03-13 15:44:56','542','2023-03-13 15:52:31',10,0),('1','145',258020,'OPERATIONAL LOSS','2023-03-13','2023-03-13 15:56:24','2023-03-14 15:56:24','542',0.00,0.00,'542','2023-03-13 16:01:27','542','2023-03-13 16:01:48',10,0),('1','145',258021,'DAILY SHIFT','2023-03-13','2023-03-13 17:06:07','2023-03-14 17:06:07','542',0.00,0.00,'542','2023-03-13 18:31:38','542','2023-03-13 18:32:40',10,0),('1','145',258022,'DAILY  SHIFT','2023-03-14','2023-03-14 07:42:14','2023-03-15 07:42:14','542',0.00,0.00,'542','2023-03-14 18:33:19','542','2023-03-14 18:34:14',10,0),('1','145',258023,'DAILY  SHIFT','2023-03-15','2023-03-15 07:42:00','2023-03-16 07:42:00','542',0.00,0.00,'542','2023-03-15 17:42:44','542','2023-03-15 17:43:20',10,0),('1','145',258024,'DAILY  SHIFT','2023-03-16','2023-03-16 07:33:32','2023-03-17 07:33:32','542',0.00,0.00,'542','2023-03-16 18:31:26','542','2023-03-16 18:31:53',10,0),('1','145',258025,'DAILY  SHIFT','2023-03-17','2023-03-17 07:48:07','2023-03-18 07:48:07','542',0.00,0.00,'542','2023-03-17 19:35:46','542','2023-03-17 19:36:24',10,0),('1','145',258026,'DAILY  SHIFT','2023-03-19','2023-03-19 10:14:45','2023-03-20 10:14:45','542',0.00,0.00,'542','2023-03-19 18:46:10','542','2023-03-19 18:46:48',10,0),('1','145',258027,'DAILY  SHIFT','2023-03-20','2023-03-20 07:33:40','2023-03-21 07:33:40','542',0.00,0.00,'542','2023-03-20 16:19:24','542','2023-03-20 16:19:51',10,0),('1','145',258028,'OPERATIONAL LOSS','2023-03-20','2023-03-20 16:21:08','2023-03-21 16:21:08','542',0.00,0.00,'542','2023-03-20 16:25:03','542','2023-03-20 16:25:33',10,0),('1','145',258029,'DAILY  SHIFT','2023-03-20','2023-03-20 16:32:09','2023-03-21 16:32:09','542',0.00,0.00,'542','2023-03-20 19:07:16','542','2023-03-20 19:07:40',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4905033 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','145','826','156181',3105337,'2358','359',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','156181',3105338,'2359','359',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','156874',3118069,'2358','359',0.00,859.70,0.00,0.00,859.70,197390.00,0.00,0.00,0.00),('1','145','827','156874',3118070,'2359','359',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','156881',3118241,'2358','359',859.70,2083.70,0.00,0.00,1224.00,276350.00,0.00,0.00,0.00),('1','145','827','156881',3118242,'2359','359',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','156883',3118268,'2358','359',2083.70,3817.30,0.00,0.00,1733.60,393030.00,0.00,0.00,0.00),('1','145','827','156883',3118269,'2359','359',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','156886',3118302,'2358','359',3817.30,4414.70,0.00,0.00,597.40,135850.00,0.00,0.00,0.00),('1','145','827','156886',3118303,'2359','359',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','156887',3118304,'2358','359',4414.70,5824.60,0.00,0.00,1409.90,319215.00,0.00,0.00,0.00),('1','145','827','156887',3118305,'2359','359',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','156889',3118308,'2358','359',5824.60,9295.10,0.00,0.00,3470.50,773130.00,0.00,0.00,0.00),('1','145','827','156889',3118309,'2359','359',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','159324',3162017,'2358','359',9295.10,11979.40,0.00,0.00,2684.30,601979.00,0.00,0.00,0.00),('1','145','827','159324',3162018,'2359','359',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','159330',3162102,'2358','359',11979.40,14271.90,0.00,0.00,2292.50,522275.00,0.00,0.00,0.00),('1','145','827','159330',3162103,'2359','359',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','159334',3162158,'2358','359',14271.90,16855.40,0.00,0.00,2583.50,588115.00,0.00,0.00,0.00),('1','145','827','159334',3162159,'2359','359',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','159337',3162187,'2358','359',16855.40,20467.60,0.00,0.00,3612.20,824375.00,0.00,0.00,0.00),('1','145','827','159337',3162188,'2359','359',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','159339',3162205,'2358','359',20467.60,20994.50,0.00,0.00,526.90,118852.50,0.00,0.00,0.00),('1','145','827','159339',3162206,'2359','359',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','159343',3162311,'2358','359',20994.50,20994.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','159343',3162312,'2359','359',0.00,655.00,0.00,0.00,655.00,148500.00,0.00,0.00,0.00),('1','145','826','159347',3162366,'2358','359',20994.50,20994.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','159347',3162367,'2359','359',655.00,7684.70,0.00,0.00,7029.70,1568886.50,0.00,0.00,0.00),('1','145','826','159350',3162409,'2358','359',20994.50,20994.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','159350',3162410,'2359','359',7684.70,11955.80,0.00,0.00,4271.10,972247.50,0.00,0.00,0.00),('1','145','826','159354',3162463,'2358','359',20994.50,20994.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','159354',3162464,'2359','359',11955.80,16796.40,0.00,0.00,4840.60,1098935.00,0.00,0.00,0.00),('1','145','826','159359',3162542,'2358','359',20994.50,20994.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','159359',3162543,'2359','359',16796.40,20451.50,0.00,0.00,3655.10,831357.50,0.00,0.00,0.00),('1','145','826','159366',3162676,'2358','359',20994.50,20994.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','159366',3162677,'2359','359',20451.50,20451.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','159369',3162724,'2358','359',20994.50,26201.10,0.00,0.00,5206.60,1180122.50,0.00,0.00,0.00),('1','145','827','159369',3162725,'2359','359',20451.50,20451.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','159373',3162786,'2358','359',26201.10,33279.40,0.00,0.00,7078.30,1604730.00,0.00,0.00,0.00),('1','145','827','159373',3162787,'2359','359',20451.50,20451.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','159375',3162807,'2358','359',33279.40,34594.90,0.00,0.00,1315.50,297825.00,0.00,0.00,0.00),('1','145','827','159375',3162808,'2359','359',20451.50,20451.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','159376',3162809,'2358','359',34594.90,43734.80,0.00,0.00,9139.90,2066140.00,0.00,0.00,0.00),('1','145','827','159376',3162810,'2359','359',20451.50,20451.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','159379',3162858,'2358','359',43734.80,44727.10,0.00,0.00,992.30,224992.50,0.00,0.00,0.00),('1','145','827','159379',3162859,'2359','359',20451.50,20451.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','159421',3163747,'2358','359',44727.10,44727.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','159421',3163748,'2359','359',20451.50,24717.30,0.00,0.00,4265.80,969562.50,0.00,0.00,0.00),('1','145','826','159426',3163781,'2358','359',44727.10,44727.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','159426',3163782,'2359','359',24717.30,36156.00,0.00,0.00,11438.70,2592480.00,0.00,0.00,0.00),('1','145','826','159508',3165172,'2358','359',44727.10,44727.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','159508',3165173,'2359','359',36156.00,42990.70,0.00,0.00,6834.70,1552852.50,0.00,0.00,0.00),('1','145','826','159519',3165395,'2358','359',44727.10,49430.00,0.00,0.00,4702.90,1073980.00,0.00,0.00,0.00),('1','145','827','159519',3165396,'2359','359',42990.70,42990.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','159524',3165456,'2358','359',49430.00,57319.50,0.00,0.00,7889.50,1789812.50,0.00,0.00,0.00),('1','145','827','159524',3165457,'2359','359',42990.70,42990.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','159526',3165469,'2358','359',57319.50,62961.80,0.00,0.00,5642.30,1287897.50,0.00,0.00,0.00),('1','145','827','159526',3165470,'2359','359',42990.70,42990.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','159529',3165543,'2358','359',62961.80,67222.80,0.00,0.00,4261.00,986737.50,0.00,0.00,0.00),('1','145','827','159529',3165544,'2359','359',42990.70,42990.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','160123',3176245,'2358','359',67222.80,67222.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','160123',3176246,'2359','359',42990.70,50946.50,0.00,0.00,7955.80,1896606.40,0.00,0.00,0.00),('1','145','826','160130',3176319,'2358','359',67222.80,67222.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','160130',3176320,'2359','359',50946.50,56613.80,0.00,0.00,5667.30,1373112.00,0.00,0.00,0.00),('1','145','826','160131',3176321,'2358','359',67222.80,67222.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','160131',3176322,'2359','359',56613.80,61907.90,0.00,0.00,5294.10,1286685.60,0.00,0.00,0.00),('1','145','826','160456',3182102,'2358','359',67222.80,67222.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','160456',3182103,'2359','359',61907.90,65555.30,0.00,0.00,3647.40,879772.80,0.00,0.00,0.00),('1','145','826','160457',3182104,'2358','359',67222.80,72781.00,0.00,0.00,5558.20,1347454.40,0.00,0.00,0.00),('1','145','827','160457',3182105,'2359','359',65555.30,65555.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','160825',3188512,'2358','359',72781.00,72781.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','160825',3188513,'2359','359',65555.30,70504.10,0.00,0.00,4948.80,1196576.40,0.00,0.00,0.00),('1','145','826','160830',3188574,'2358','359',72781.00,79719.90,0.00,0.00,6938.90,1663195.60,0.00,0.00,0.00),('1','145','827','160830',3188575,'2359','359',70504.10,70504.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','160891',3189544,'2358','359',79719.90,80929.90,0.00,0.00,1210.00,293616.80,0.00,0.00,0.00),('1','145','827','160891',3189545,'2359','359',70504.10,70504.17,0.07,19.04,0.00,0.00,0.00,0.00,0.00),('1','145','826','161136',3193952,'2358','359',80929.90,87883.20,0.00,0.00,6953.30,1680460.00,0.00,0.00,0.00),('1','145','827','161136',3193953,'2359','359',70504.17,70504.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','161331',3197234,'2358','359',87883.20,89894.80,0.00,0.00,2011.60,482553.20,0.00,0.00,0.00),('1','145','827','161331',3197235,'2359','359',70504.17,70504.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','161332',3197236,'2358','359',89894.80,89894.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','161332',3197237,'2359','359',70504.17,73774.27,0.00,0.00,3270.10,791594.00,0.00,0.00,0.00),('1','145','826','161483',3199749,'2358','359',89894.80,95369.00,0.00,0.00,5474.20,1316524.40,0.00,0.00,0.00),('1','145','827','161483',3199750,'2359','359',73774.27,73774.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','161661',3202960,'2358','359',95369.00,95369.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','161661',3202961,'2359','359',73774.27,79012.57,0.00,0.00,5238.30,1265496.00,0.00,0.00,0.00),('1','145','826','161881',3206705,'2358','359',95369.00,95369.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','161881',3206706,'2359','359',79012.57,85888.27,0.00,0.00,6875.70,1636224.00,0.00,0.00,0.00),('1','145','826','162046',3209791,'2358','359',95369.00,95369.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','162046',3209792,'2359','359',85888.27,88220.27,0.00,0.00,2332.00,568478.00,0.00,0.00,0.00),('1','145','826','162049',3209795,'2358','359',95369.00,100687.50,0.00,0.00,5318.50,1280175.20,0.00,0.00,0.00),('1','145','827','162049',3209796,'2359','359',88220.27,88220.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','162245',3213179,'2358','359',100687.50,100687.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','162245',3213180,'2359','359',88220.27,90819.37,0.00,0.00,2599.10,624270.40,0.00,0.00,0.00),('1','145','826','162461',3216777,'2358','359',100687.50,106459.20,0.00,0.00,5771.70,1388170.80,0.00,0.00,0.00),('1','145','827','162461',3216778,'2359','359',90819.37,90819.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','162642',3219697,'2358','359',106459.20,111107.00,0.00,0.00,4647.80,1132045.60,0.00,0.00,0.00),('1','145','827','162642',3219698,'2359','359',90819.37,90819.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','162824',3223063,'2358','359',111107.00,112550.20,0.00,0.00,1443.20,348821.20,0.00,0.00,0.00),('1','145','827','162824',3223064,'2359','359',90819.37,90819.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','162825',3223065,'2358','359',112550.20,112550.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','162825',3223066,'2359','359',90819.37,93735.77,0.00,0.00,2916.40,700431.20,0.00,0.00,0.00),('1','145','826','163005',3226266,'2358','359',112550.20,119347.10,0.00,0.00,6796.90,1620554.00,0.00,0.00,0.00),('1','145','827','163005',3226267,'2359','359',93735.77,93735.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','163219',3230028,'2358','359',119347.10,119347.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','163219',3230029,'2359','359',93735.77,97422.87,0.00,0.00,3687.10,898566.80,0.00,0.00,0.00),('1','145','826','163382',3232836,'2358','359',119347.10,119347.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','163382',3232837,'2359','359',97422.87,103315.17,0.00,0.00,5892.30,1422205.20,0.00,0.00,0.00),('1','145','826','163541',3235859,'2358','359',119347.10,119347.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','163541',3235860,'2359','359',103315.17,105097.07,0.00,0.00,1781.90,429985.60,0.00,0.00,0.00),('1','145','826','163779',3240072,'2358','359',119347.10,119347.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','163779',3240073,'2359','359',105097.07,110831.67,0.00,0.00,5734.60,1386615.20,0.00,0.00,0.00),('1','145','826','163904',3242383,'2358','359',119347.10,126207.10,0.00,0.00,6860.00,1635046.00,0.00,0.00,0.00),('1','145','827','163904',3242384,'2359','359',110831.67,110831.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','164082',3245530,'2358','359',126207.10,126207.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','164082',3245531,'2359','359',110831.67,113733.67,0.00,0.00,2902.00,775026.80,0.00,0.00,0.00),('1','145','826','164258',3248723,'2358','359',126207.10,130767.90,0.00,0.00,4560.80,1211004.40,0.00,0.00,0.00),('1','145','827','164258',3248724,'2359','359',113733.67,113733.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','164493',3253019,'2358','359',130767.90,134010.60,0.00,0.00,3242.70,864676.80,0.00,0.00,0.00),('1','145','827','164493',3253020,'2359','359',113733.67,113733.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','164611',3255104,'2358','359',134010.60,134010.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','164611',3255105,'2359','359',113733.67,121088.57,0.00,0.00,7354.90,1956032.00,0.00,0.00,0.00),('1','145','826','164733',3257606,'2358','359',134010.60,134010.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','164733',3257607,'2359','359',121088.57,123067.97,0.00,0.00,1979.40,526704.00,0.00,0.00,0.00),('1','145','826','164973',3261661,'2358','359',134010.60,139104.40,0.00,0.00,5093.80,1354692.80,0.00,0.00,0.00),('1','145','827','164973',3261662,'2359','359',123067.97,123067.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','165128',3264463,'2358','359',139104.40,139104.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','165128',3264464,'2359','359',123067.97,130381.87,0.00,0.00,7313.90,2134984.00,0.00,0.00,0.00),('1','145','826','165311',3267653,'2358','359',139104.40,139104.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','165311',3267654,'2359','359',130381.87,133496.17,0.00,0.00,3114.30,923439.00,0.00,0.00,0.00),('1','145','826','165312',3267655,'2358','359',139104.40,139928.60,0.00,0.00,824.20,243479.00,0.00,0.00,0.00),('1','145','827','165312',3267656,'2359','359',133496.17,133496.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','165445',3269960,'2358','359',139928.60,143575.20,0.00,0.00,3646.60,1079102.00,0.00,0.00,0.00),('1','145','827','165445',3269961,'2359','359',133496.17,133496.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','165621',3272991,'2358','359',143575.20,143575.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','165621',3272992,'2359','359',133496.17,136355.57,0.00,0.00,2859.40,854738.00,0.00,0.00,0.00),('1','145','826','165798',3276392,'2358','359',143575.20,148426.20,0.00,0.00,4851.00,1434591.00,0.00,0.00,0.00),('1','145','827','165798',3276393,'2359','359',136355.57,136355.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','165922',3278643,'2358','359',148426.20,150137.30,0.00,0.00,1711.10,508594.00,0.00,0.00,0.00),('1','145','827','165922',3278644,'2359','359',136355.57,136355.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','166147',3282541,'2358','359',150137.30,152568.60,0.00,0.00,2431.30,724292.00,0.00,0.00,0.00),('1','145','827','166147',3282542,'2359','359',136355.57,136355.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','166500',3288993,'2358','359',152568.60,156202.70,0.00,0.00,3634.10,1077088.00,0.00,0.00,0.00),('1','145','827','166500',3288994,'2359','359',136355.57,136355.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','166502',3289011,'2358','359',156202.70,156673.50,0.00,0.00,470.80,143789.00,0.00,0.00,0.00),('1','145','827','166502',3289012,'2359','359',136355.57,136355.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','166503',3289013,'2358','359',156673.50,156673.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','166503',3289014,'2359','359',136355.57,138837.47,0.00,0.00,2481.90,732357.00,0.00,0.00,0.00),('1','145','826','166702',3292391,'2358','359',156673.50,156673.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','166702',3292392,'2359','359',138837.47,138837.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','166706',3292437,'2358','359',156673.50,159608.10,0.00,0.00,2934.60,870513.00,0.00,0.00,0.00),('1','145','827','166706',3292438,'2359','359',138837.47,138837.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','166880',3295520,'2358','359',159608.10,159608.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','166880',3295521,'2359','359',138837.47,141576.77,0.00,0.00,2739.30,813645.00,0.00,0.00,0.00),('1','145','826','167185',3300951,'2358','359',159608.10,159608.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','167185',3300952,'2359','359',141576.77,144562.97,0.00,0.00,2986.20,900543.00,0.00,0.00,0.00),('1','145','826','167186',3300953,'2358','359',159608.10,159608.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','167186',3300954,'2359','359',144562.97,145450.57,0.00,0.00,887.60,264394.00,0.00,0.00,0.00),('1','145','826','167389',3304464,'2358','359',159608.10,159608.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','167389',3304465,'2359','359',145450.57,149294.37,0.00,0.00,3843.80,1136080.00,0.00,0.00,0.00),('1','145','826','167575',3307916,'2358','359',159608.10,159608.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','167575',3307917,'2359','359',149294.37,152080.17,0.00,0.00,2785.80,829968.00,0.00,0.00,0.00),('1','145','826','167742',3310845,'2358','359',159608.10,159608.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','167742',3310846,'2359','359',152080.17,154105.47,0.00,0.00,2025.30,611316.00,0.00,0.00,0.00),('1','145','826','167923',3313963,'2358','359',159608.10,159608.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','167923',3313964,'2359','359',154105.47,156183.07,0.00,0.00,2077.60,617432.00,0.00,0.00,0.00),('1','145','826','167924',3313965,'2358','359',159608.10,160361.60,0.00,0.00,753.50,226840.00,0.00,0.00,0.00),('1','145','827','167924',3313966,'2359','359',156183.07,156183.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','168135',3318098,'2358','359',160361.60,160361.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','168135',3318099,'2359','359',156183.07,156183.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','168136',3318100,'2358','359',160361.60,160361.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','168136',3318101,'2359','359',156183.07,157999.27,0.00,0.00,1816.20,547437.00,0.00,0.00,0.00),('1','145','826','168277',3320850,'2358','359',160361.60,162999.90,0.00,0.00,2638.30,787934.00,0.00,0.00,0.00),('1','145','827','168277',3320851,'2359','359',157999.27,157999.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','168414',3323214,'2358','359',162999.90,164518.20,0.00,0.00,1518.30,449883.00,0.00,0.00,0.00),('1','145','827','168414',3323215,'2359','359',157999.27,157999.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','168622',3326925,'2358','359',164518.20,167583.50,0.00,0.00,3065.30,917734.00,0.00,0.00,0.00),('1','145','827','168622',3326926,'2359','359',157999.27,157999.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','168779',3329797,'2358','359',167583.50,171665.70,0.00,0.00,4082.20,1213511.00,0.00,0.00,0.00),('1','145','827','168779',3329798,'2359','359',157999.27,157999.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','169223',3337633,'2358','359',171665.70,174740.50,0.00,0.00,3074.80,924929.00,0.00,0.00,0.00),('1','145','827','169223',3337634,'2359','359',157999.27,157999.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','169226',3337689,'2358','359',174740.50,179272.00,0.00,0.00,4531.50,1345476.00,0.00,0.00,0.00),('1','145','827','169226',3337690,'2359','359',157999.27,157999.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','169229',3337727,'2358','359',179272.00,179272.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','169229',3337728,'2359','359',157999.27,158909.47,0.00,0.00,910.20,276078.00,0.00,0.00,0.00),('1','145','826','169283',3338804,'2358','359',179272.00,179272.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','169283',3338805,'2359','359',158909.47,162794.07,0.00,0.00,3884.60,1150495.00,0.00,0.00,0.00),('1','145','826','169578',3344808,'2358','359',179272.00,184951.30,0.00,0.00,5679.30,1669971.00,0.00,0.00,0.00),('1','145','827','169578',3344809,'2359','359',162794.07,162794.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','169937',3351381,'2358','359',184951.30,184951.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','169937',3351382,'2359','359',162794.07,166148.07,0.00,0.00,3354.00,1019462.00,0.00,0.00,0.00),('1','145','826','170151',3355133,'2358','359',184951.30,184951.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','170151',3355134,'2359','359',166148.07,168640.57,0.00,0.00,2492.50,760358.00,0.00,0.00,0.00),('1','145','826','170345',3358429,'2358','359',184951.30,184951.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','170345',3358430,'2359','359',168640.57,174551.57,0.00,0.00,5911.00,1718130.00,0.00,0.00,0.00),('1','145','826','170565',3362432,'2358','359',184951.30,184951.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','170565',3362433,'2359','359',174551.57,177900.77,0.00,0.00,3349.20,975634.00,0.00,0.00,0.00),('1','145','826','170671',3364323,'2358','359',184951.30,191274.70,0.00,0.00,6323.40,1822031.50,0.00,0.00,0.00),('1','145','827','170671',3364324,'2359','359',177900.77,177900.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','170818',3366819,'2358','359',191274.70,191274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','170818',3366820,'2359','359',177900.77,179173.57,0.00,0.00,1272.80,373353.00,0.00,0.00,0.00),('1','145','826','171001',3370133,'2358','359',191274.70,191274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','171001',3370134,'2359','359',179173.57,183824.17,0.00,0.00,4650.60,1346599.50,0.00,0.00,0.00),('1','145','826','171216',3374219,'2358','359',191274.70,195000.30,0.00,0.00,3725.60,1080920.00,0.00,0.00,0.00),('1','145','827','171216',3374220,'2359','359',183824.17,183824.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','171538',3380047,'2358','359',195000.30,198600.80,0.00,0.00,3600.50,1049781.50,0.00,0.00,0.00),('1','145','827','171538',3380048,'2359','359',183824.17,183824.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','171588',3380917,'2358','359',198600.80,202182.00,0.00,0.00,3581.20,1040284.00,0.00,0.00,0.00),('1','145','827','171588',3380918,'2359','359',183824.17,183824.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','171777',3384185,'2358','359',202182.00,204028.10,0.00,0.00,1846.10,539410.50,0.00,0.00,0.00),('1','145','827','171777',3384186,'2359','359',183824.17,183824.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','171778',3384187,'2358','359',204028.10,204259.30,0.00,0.00,231.20,73984.00,0.00,0.00,0.00),('1','145','827','171778',3384188,'2359','359',183824.17,185605.17,0.00,0.00,1781.00,507585.00,0.00,0.00,0.00),('1','145','826','171951',3387394,'2358','359',204259.30,204259.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','171951',3387395,'2359','359',185605.17,191954.27,0.00,0.00,6349.10,1843345.50,0.00,0.00,0.00),('1','145','826','172284',3393463,'2358','359',204259.30,204259.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','172284',3393464,'2359','359',191954.27,193725.47,0.00,0.00,1771.20,518711.50,0.00,0.00,0.00),('1','145','826','172288',3393471,'2358','359',204259.30,204259.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','172288',3393472,'2359','359',193725.47,199458.37,0.00,0.00,5732.90,1656542.50,0.00,0.00,0.00),('1','145','826','172749',3401881,'2358','359',204259.30,204259.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','172749',3401882,'2359','359',199458.37,202211.27,0.00,0.00,2752.90,787478.00,0.00,0.00,0.00),('1','145','826','172761',3402085,'2358','359',204259.30,208275.30,0.00,0.00,4016.00,1155858.00,0.00,0.00,0.00),('1','145','827','172761',3402086,'2359','359',202211.27,202211.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','172763',3402106,'2358','359',208275.30,214185.90,0.00,0.00,5910.60,1700519.50,0.00,0.00,0.00),('1','145','827','172763',3402107,'2359','359',202211.27,202211.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','173129',3409175,'2358','359',214185.90,219961.60,0.00,0.00,5775.70,1665538.00,0.00,0.00,0.00),('1','145','827','173129',3409176,'2359','359',202211.27,202211.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','173134',3409306,'2358','359',219961.60,223806.40,0.00,0.00,3844.80,1115515.00,0.00,0.00,0.00),('1','145','827','173134',3409307,'2359','359',202211.27,202211.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','173180',3410296,'2358','359',223806.40,228894.40,0.00,0.00,5088.00,1472014.50,0.00,0.00,0.00),('1','145','827','173180',3410297,'2359','359',202211.27,202211.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','174012',3425293,'2358','359',228894.40,228894.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','174012',3425294,'2359','359',202211.27,211955.27,0.00,0.00,9744.00,2807388.50,0.00,0.00,0.00),('1','145','826','174016',3425316,'2358','359',228894.40,233967.70,0.00,0.00,5073.30,1472679.50,0.00,0.00,0.00),('1','145','827','174016',3425317,'2359','359',211955.27,211955.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','174129',3427333,'2358','359',233967.70,233967.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','174129',3427334,'2359','359',211955.27,218109.97,0.00,0.00,6154.70,1774970.50,0.00,0.00,0.00),('1','145','826','174325',3430993,'2358','359',233967.70,233967.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','174325',3430994,'2359','359',218109.97,224929.67,0.00,0.00,6819.70,1967565.00,0.00,0.00,0.00),('1','145','826','174554',3434895,'2358','359',233967.70,233967.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','174554',3434896,'2359','359',224929.67,226918.67,0.00,0.00,1989.00,574799.50,0.00,0.00,0.00),('1','145','826','174560',3435002,'2358','359',233967.70,242511.00,0.00,0.00,8543.30,2461766.00,0.00,0.00,0.00),('1','145','827','174560',3435003,'2359','359',226918.67,226918.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','174646',3436486,'2358','359',242511.00,242511.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','174646',3436487,'2359','359',226918.67,230581.17,0.00,0.00,3662.50,1059300.00,0.00,0.00,0.00),('1','145','826','174840',3440063,'2358','359',242511.00,251859.30,0.00,0.00,9348.30,2690554.00,0.00,0.00,0.00),('1','145','827','174840',3440064,'2359','359',230581.17,230581.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','175193',3446719,'2358','359',251859.30,253503.80,0.00,0.00,1644.50,513214.00,0.00,0.00,0.00),('1','145','827','175193',3446720,'2359','359',230581.17,230581.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','175203',3446918,'2358','359',253503.80,253503.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','175203',3446919,'2359','359',230581.17,235019.47,0.00,0.00,4438.30,1385327.20,0.00,0.00,0.00),('1','145','826','175241',3447499,'2358','359',253503.80,253503.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','175241',3447500,'2359','359',235019.47,242516.37,0.00,0.00,7496.90,2339438.80,0.00,0.00,0.00),('1','145','826','175413',3450694,'2358','359',253503.80,260296.00,0.00,0.00,6792.20,2125903.60,0.00,0.00,0.00),('1','145','827','175413',3450695,'2359','359',242516.37,242516.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','175596',3454006,'2358','359',260296.00,260296.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','175596',3454007,'2359','359',242516.37,248380.27,0.00,0.00,5863.90,1828352.00,0.00,0.00,0.00),('1','145','826','175597',3454008,'2358','359',260296.00,262884.10,0.00,0.00,2588.10,809489.60,0.00,0.00,0.00),('1','145','827','175597',3454009,'2359','359',248380.27,248380.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','175879',3459154,'2358','359',262884.10,262884.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','175879',3459155,'2359','359',248380.27,261477.27,0.00,0.00,13097.00,4085016.60,0.00,0.00,0.00),('1','145','826','175919',3459796,'2358','359',262884.10,266720.50,0.00,0.00,3836.40,1197211.40,0.00,0.00,0.00),('1','145','827','175919',3459797,'2359','359',261477.27,261477.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','176198',3464781,'2358','359',266720.50,277642.50,0.00,0.00,10922.00,3407015.20,0.00,0.00,0.00),('1','145','827','176198',3464782,'2359','359',261477.27,261477.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','176333',3467413,'2358','359',277642.50,278333.10,0.00,0.00,690.60,216038.60,0.00,0.00,0.00),('1','145','827','176333',3467414,'2359','359',261477.27,261477.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','176334',3467415,'2358','359',278333.10,278333.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','176334',3467416,'2359','359',261477.27,270236.77,0.00,0.00,8759.50,2734144.20,0.00,0.00,0.00),('1','145','826','176551',3471603,'2358','359',278333.10,288812.70,0.00,0.00,10479.60,3270932.00,0.00,0.00,0.00),('1','145','827','176551',3471604,'2359','359',270236.77,270236.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','176775',3475632,'2358','359',288812.70,288812.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','176775',3475633,'2359','359',270236.77,272840.57,0.00,0.00,2603.80,814871.40,0.00,0.00,0.00),('1','145','826','176776',3475634,'2358','359',288812.70,294980.00,0.00,0.00,6167.30,1927161.40,0.00,0.00,0.00),('1','145','827','176776',3475635,'2359','359',272840.57,272840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','176975',3479259,'2358','359',294980.00,303052.30,0.00,0.00,8072.30,2510253.30,0.00,0.00,0.00),('1','145','827','176975',3479260,'2359','359',272840.57,272840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','176976',3479261,'2358','359',303052.30,303052.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','176976',3479262,'2359','359',272840.57,272840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','176979',3479282,'2358','359',303052.30,303052.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','176979',3479283,'2359','359',272840.57,275884.77,0.00,0.00,3044.20,950703.80,0.00,0.00,0.00),('1','145','826','177619',3492276,'2358','359',303052.30,303052.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','177619',3492277,'2359','359',275884.77,277671.47,0.00,0.00,1786.70,556471.80,0.00,0.00,0.00),('1','145','826','178632',3510986,'2358','359',303052.30,310696.30,0.00,0.00,7644.00,2391324.00,0.00,0.00,0.00),('1','145','827','178632',3510987,'2359','359',277671.47,277671.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','178635',3511023,'2358','359',310696.30,317606.10,0.00,0.00,6909.80,2152575.80,0.00,0.00,0.00),('1','145','827','178635',3511024,'2359','359',277671.47,277671.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','178641',3511109,'2358','359',317606.10,317606.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','178641',3511110,'2359','359',277671.47,289304.17,0.00,0.00,11632.70,3638423.80,0.00,0.00,0.00),('1','145','826','178642',3511111,'2358','359',317606.10,327655.70,0.00,0.00,10049.60,3132257.80,0.00,0.00,0.00),('1','145','827','178642',3511112,'2359','359',289304.17,289304.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','178646',3511145,'2358','359',327655.70,327655.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','178646',3511146,'2359','359',289304.17,291114.77,0.00,0.00,1810.60,565669.60,0.00,0.00,0.00),('1','145','826','178647',3511147,'2358','359',327655.70,327655.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','178647',3511148,'2359','359',291114.77,302399.77,0.00,0.00,11285.00,3513963.00,0.00,0.00,0.00),('1','145','826','178898',3515746,'2358','359',327655.70,338545.60,0.00,0.00,10889.90,3387380.30,0.00,0.00,0.00),('1','145','827','178898',3515747,'2359','359',302399.77,302399.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','178899',3515748,'2358','359',338545.60,347819.50,0.00,0.00,9273.90,2891941.60,0.00,0.00,0.00),('1','145','827','178899',3515749,'2359','359',302399.77,302399.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','178900',3515750,'2358','359',347819.50,347819.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','178900',3515751,'2359','359',302399.77,311295.97,0.00,0.00,8896.20,2831857.20,0.00,0.00,0.00),('1','145','826','178901',3515752,'2358','359',347819.50,352151.90,0.00,0.00,4332.40,1374882.40,0.00,0.00,0.00),('1','145','827','178901',3515753,'2359','359',311295.97,311295.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','179917',3535148,'2358','359',352151.90,359558.90,0.00,0.00,7407.00,2348069.50,0.00,0.00,0.00),('1','145','827','179917',3535149,'2359','359',311295.97,311295.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','179922',3535271,'2358','359',359558.90,359558.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','179922',3535272,'2359','359',311295.97,319607.67,0.00,0.00,8311.70,2640731.20,0.00,0.00,0.00),('1','145','826','179930',3535406,'2358','359',359558.90,359558.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','179930',3535407,'2359','359',319607.67,325132.17,0.00,0.00,5524.50,1760020.00,0.00,0.00,0.00),('1','145','826','179939',3535581,'2358','359',359558.90,359558.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','179939',3535582,'2359','359',325132.17,326554.07,0.00,0.00,1421.90,452148.40,0.00,0.00,0.00),('1','145','826','179947',3535701,'2358','359',359558.90,367199.50,0.00,0.00,7640.60,2423289.60,0.00,0.00,0.00),('1','145','827','179947',3535702,'2359','359',326554.07,326554.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','179953',3535771,'2358','359',367199.50,367199.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','179953',3535772,'2359','359',326554.07,326554.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','179981',3536285,'2358','359',367199.50,367199.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','179981',3536286,'2359','359',326554.07,332900.07,0.00,0.00,6346.00,2018582.00,0.00,0.00,0.00),('1','145','826','180332',3542766,'2358','359',367199.50,376226.50,0.00,0.00,9027.00,2859657.50,0.00,0.00,0.00),('1','145','827','180332',3542767,'2359','359',332900.07,332900.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','180333',3542768,'2358','359',376226.50,376226.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','180333',3542769,'2359','359',332900.07,334666.17,0.00,0.00,1766.10,561711.60,0.00,0.00,0.00),('1','145','826','180715',3549805,'2358','359',376226.50,376226.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','180715',3549806,'2359','359',334666.17,338181.77,0.00,0.00,3515.60,1119067.60,0.00,0.00,0.00),('1','145','826','180717',3549837,'2358','359',376226.50,376226.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','180717',3549838,'2359','359',338181.77,349470.57,0.00,0.00,11288.80,3589178.80,0.00,0.00,0.00),('1','145','826','180719',3549853,'2358','359',376226.50,376226.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','180719',3549854,'2359','359',349470.57,349470.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','181300',3561076,'2358','359',376226.50,376226.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','181300',3561077,'2359','359',349470.57,350258.97,0.00,0.00,788.40,251832.40,0.00,0.00,0.00),('1','145','826','181306',3561199,'2358','359',376226.50,382932.50,0.00,0.00,6706.00,2134282.00,0.00,0.00,0.00),('1','145','827','181306',3561200,'2359','359',350258.97,350258.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','181308',3561230,'2358','359',382932.50,389281.30,0.00,0.00,6348.80,2021290.80,0.00,0.00,0.00),('1','145','827','181308',3561231,'2359','359',350258.97,350258.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','181314',3561346,'2358','359',389281.30,389281.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','181314',3561347,'2359','359',350258.97,355190.17,0.00,0.00,4931.20,1616270.80,0.00,0.00,0.00),('1','145','826','181464',3564071,'2358','359',389281.30,395231.00,0.00,0.00,5949.70,1949098.40,0.00,0.00,0.00),('1','145','827','181464',3564072,'2359','359',355190.17,355190.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','182275',3578481,'2358','359',395231.00,399918.50,0.00,0.00,4687.50,1537433.60,0.00,0.00,0.00),('1','145','827','182275',3578482,'2359','359',355190.17,355190.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','182278',3578500,'2358','359',399918.50,399918.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','182278',3578501,'2359','359',355190.17,360110.67,0.00,0.00,4920.50,1612390.60,0.00,0.00,0.00),('1','145','826','182281',3578545,'2358','359',399918.50,399918.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','182281',3578546,'2359','359',360110.67,363319.67,0.00,0.00,3209.00,1052394.80,0.00,0.00,0.00),('1','145','826','182804',3588083,'2358','359',399918.50,406599.10,0.00,0.00,6680.60,2190069.60,0.00,0.00,0.00),('1','145','827','182804',3588084,'2359','359',363319.67,363319.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','183365',3598410,'2358','359',406599.10,406599.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','183365',3598411,'2359','359',363319.67,368958.27,0.00,0.00,5638.60,1849191.80,0.00,0.00,0.00),('1','145','826','183367',3598462,'2358','359',406599.10,406599.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','183367',3598463,'2359','359',368958.27,374802.97,0.00,0.00,5844.70,1913999.00,0.00,0.00,0.00),('1','145','826','183369',3598487,'2358','359',406599.10,407105.90,0.00,0.00,506.80,167118.00,0.00,0.00,0.00),('1','145','827','183369',3598488,'2359','359',374802.97,374802.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','183377',3598621,'2358','359',407105.90,407105.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','183377',3598622,'2359','359',374802.97,382155.97,0.00,0.00,7353.00,2401971.80,0.00,0.00,0.00),('1','145','826','183380',3598642,'2358','359',407105.90,412666.50,0.00,0.00,5560.60,1826275.40,0.00,0.00,0.00),('1','145','827','183380',3598643,'2359','359',382155.97,382155.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','183384',3598701,'2358','359',412666.50,422212.50,0.00,0.00,9546.00,3129801.20,0.00,0.00,0.00),('1','145','827','183384',3598702,'2359','359',382155.97,382155.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','183385',3598703,'2358','359',422212.50,424647.00,0.00,0.00,2434.50,795481.00,0.00,0.00,0.00),('1','145','827','183385',3598704,'2359','359',382155.97,382155.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','183388',3598765,'2358','359',424647.00,424647.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','183388',3598766,'2359','359',382155.97,384579.27,0.00,0.00,2423.30,794851.00,0.00,0.00,0.00),('1','145','826','183390',3598784,'2358','359',424647.00,424647.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','183390',3598785,'2359','359',384579.27,392268.17,0.00,0.00,7688.90,2519929.00,0.00,0.00,0.00),('1','145','826','183392',3598815,'2358','359',424647.00,424647.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','183392',3598816,'2359','359',392268.17,399242.87,0.00,0.00,6974.70,2281973.00,0.00,0.00,0.00),('1','145','826','184342',3615806,'2358','359',424647.00,424647.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','184342',3615807,'2359','359',399242.87,399242.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','184859',3625344,'2358','359',424647.00,424647.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','184859',3625345,'2359','359',399242.87,399242.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','184963',3627060,'2358','359',424647.00,440847.60,0.00,0.00,16200.60,5297053.90,0.00,0.00,0.00),('1','145','827','184963',3627061,'2359','359',399242.87,399242.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','184965',3627102,'2358','359',440847.60,449332.80,0.00,0.00,8485.20,2771203.40,0.00,0.00,0.00),('1','145','827','184965',3627103,'2359','359',399242.87,399242.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','184973',3627227,'2358','359',449332.80,449332.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','184973',3627228,'2359','359',399242.87,403815.17,0.00,0.00,4572.30,1494440.80,0.00,0.00,0.00),('1','145','826','184979',3627356,'2358','359',449332.80,449332.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','184979',3627357,'2359','359',403815.17,418573.77,0.00,0.00,14758.60,4835950.60,0.00,0.00,0.00),('1','145','826','184983',3627382,'2358','359',449332.80,454915.80,0.00,0.00,5583.00,1827009.00,0.00,0.00,0.00),('1','145','827','184983',3627383,'2359','359',418573.77,418573.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','184986',3627424,'2358','359',454915.80,454915.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','184986',3627425,'2359','359',418573.77,424013.87,0.00,0.00,5440.10,1781041.00,0.00,0.00,0.00),('1','145','826','184997',3627564,'2358','359',454915.80,462966.70,0.00,0.00,8050.90,2635020.60,0.00,0.00,0.00),('1','145','827','184997',3627565,'2359','359',424013.87,424013.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','185087',3629283,'2358','359',462966.70,462966.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','185087',3629284,'2359','359',424013.87,433263.57,0.00,0.00,9249.70,3031206.80,0.00,0.00,0.00),('1','145','826','185088',3629285,'2358','359',462966.70,472663.20,0.00,0.00,9696.50,3172135.80,0.00,0.00,0.00),('1','145','827','185088',3629286,'2359','359',433263.57,433263.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','185245',3631747,'2358','359',472663.20,474187.10,0.00,0.00,1523.90,500081.40,0.00,0.00,0.00),('1','145','827','185245',3631748,'2359','359',433263.57,433263.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','185246',3631749,'2358','359',474187.10,474187.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','185246',3631750,'2359','359',433263.57,438889.57,0.00,0.00,5626.00,1843307.60,0.00,0.00,0.00),('1','145','826','185247',3631751,'2358','359',474187.10,474187.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','185247',3631752,'2359','359',438889.57,438889.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','185454',3635700,'2358','359',474187.10,482895.00,0.00,0.00,8707.90,2841387.20,0.00,0.00,0.00),('1','145','827','185454',3635701,'2359','359',438889.57,438889.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','186060',3646544,'2358','359',482895.00,482895.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','186060',3646545,'2359','359',438889.57,448839.97,0.00,0.00,9950.40,3257883.60,0.00,0.00,0.00),('1','145','826','186062',3646557,'2358','359',482895.00,485321.50,0.00,0.00,2426.50,793734.00,0.00,0.00,0.00),('1','145','827','186062',3646558,'2359','359',448839.97,448839.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','186064',3646581,'2358','359',485321.50,485321.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','186064',3646582,'2359','359',448839.97,454697.77,0.00,0.00,5857.80,1916704.40,0.00,0.00,0.00),('1','145','826','186065',3646583,'2358','359',485321.50,493324.40,0.00,0.00,8002.90,2620695.60,0.00,0.00,0.00),('1','145','827','186065',3646584,'2359','359',454697.77,454697.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','186300',3650518,'2358','359',493324.40,498736.30,0.00,0.00,5411.90,1772130.60,0.00,0.00,0.00),('1','145','827','186300',3650519,'2359','359',454697.77,454697.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','186301',3650520,'2358','359',498736.30,498736.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','186301',3650521,'2359','359',454697.77,457151.57,0.00,0.00,2453.80,803346.40,0.00,0.00,0.00),('1','145','826','186678',3656907,'2358','359',498736.30,498736.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','186678',3656908,'2359','359',457151.57,457151.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','186728',3657829,'2358','359',498736.30,498736.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','186728',3657830,'2359','359',457151.57,465572.97,0.00,0.00,8421.40,2759064.20,0.00,0.00,0.00),('1','145','826','186729',3657831,'2358','359',498736.30,507392.50,0.00,0.00,8656.20,2835422.80,0.00,0.00,0.00),('1','145','827','186729',3657832,'2359','359',465572.97,465572.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','186960',3661694,'2358','359',507392.50,507392.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','186960',3661695,'2359','359',465572.97,473432.97,0.00,0.00,7860.00,2573354.20,0.00,0.00,0.00),('1','145','826','186961',3661696,'2358','359',507392.50,507816.20,0.00,0.00,423.70,140642.00,0.00,0.00,0.00),('1','145','827','186961',3661697,'2359','359',473432.97,473432.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','187302',3667608,'2358','359',507816.20,507816.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','187302',3667609,'2359','359',473432.97,483416.37,0.00,0.00,9983.40,3274420.80,0.00,0.00,0.00),('1','145','826','187307',3667657,'2358','359',507816.20,511609.10,0.00,0.00,3792.90,1243579.20,0.00,0.00,0.00),('1','145','827','187307',3667658,'2359','359',483416.37,483416.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','187539',3671956,'2358','359',511609.10,520569.70,0.00,0.00,8960.60,2936671.80,0.00,0.00,0.00),('1','145','827','187539',3671957,'2359','359',483416.37,483416.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','187581',3672531,'2358','359',520569.70,520569.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','187581',3672532,'2359','359',483416.37,489610.77,0.00,0.00,6194.40,2030591.20,0.00,0.00,0.00),('1','145','826','187779',3676228,'2358','359',520569.70,520676.50,0.00,0.00,106.80,35323.60,0.00,0.00,0.00),('1','145','827','187779',3676229,'2359','359',489610.77,489610.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','187807',3676522,'2358','359',520676.50,528992.50,0.00,0.00,8316.00,2723733.60,0.00,0.00,0.00),('1','145','827','187807',3676523,'2359','359',489610.77,489610.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','188019',3680268,'2358','359',528992.50,528992.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','188019',3680269,'2359','359',489610.77,497098.07,0.00,0.00,7487.30,2458026.60,0.00,0.00,0.00),('1','145','826','188186',3683306,'2358','359',528992.50,530600.30,0.00,0.00,1607.80,526129.20,0.00,0.00,0.00),('1','145','827','188186',3683307,'2359','359',497098.07,497098.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','188222',3683726,'2358','359',530600.30,539253.60,0.00,0.00,8653.30,2839063.60,0.00,0.00,0.00),('1','145','827','188222',3683727,'2359','359',497098.07,497098.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','188431',3687278,'2358','359',539253.60,544368.60,0.00,0.00,5115.00,1677591.80,0.00,0.00,0.00),('1','145','827','188431',3687279,'2359','359',497098.07,497098.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','188580',3690085,'2358','359',544368.60,544368.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','188580',3690086,'2359','359',497098.07,502593.37,0.00,0.00,5495.30,1804498.00,0.00,0.00,0.00),('1','145','826','188633',3690814,'2358','359',544368.60,547867.50,0.00,0.00,3498.90,1149216.40,0.00,0.00,0.00),('1','145','827','188633',3690815,'2359','359',502593.37,502593.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','188806',3693954,'2358','359',547867.50,557822.00,0.00,0.00,9954.50,3260477.00,0.00,0.00,0.00),('1','145','827','188806',3693955,'2359','359',502593.37,502593.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','189013',3697733,'2358','359',557822.00,557825.00,0.00,0.00,3.00,1020.00,0.00,0.00,0.00),('1','145','827','189013',3697734,'2359','359',502593.37,507875.37,0.00,0.00,5282.00,1731219.20,0.00,0.00,0.00),('1','145','826','189210',3701128,'2358','359',557825.00,557825.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','189210',3701129,'2359','359',507875.37,516424.47,0.00,0.00,8549.10,2803095.00,0.00,0.00,0.00),('1','145','826','189530',3706890,'2358','359',557825.00,557825.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','189530',3706891,'2359','359',516424.47,516854.27,0.00,0.00,429.80,141195.60,0.00,0.00,0.00),('1','145','826','189586',3708042,'2358','359',557825.00,561727.80,0.00,0.00,3902.80,1284743.40,0.00,0.00,0.00),('1','145','827','189586',3708043,'2359','359',516854.27,516854.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','189629',3708560,'2358','359',561727.80,561727.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','189629',3708561,'2359','359',516854.27,523738.27,0.00,0.00,6884.00,2255771.00,0.00,0.00,0.00),('1','145','826','189818',3711964,'2358','359',561727.80,569000.60,0.00,0.00,7272.80,2385038.40,0.00,0.00,0.00),('1','145','827','189818',3711965,'2359','359',523738.27,523782.77,0.00,0.00,44.50,14605.00,0.00,0.00,0.00),('1','145','826','189993',3715598,'2358','359',569000.60,569000.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','189993',3715599,'2359','359',523782.77,524822.47,0.00,0.00,1039.70,340912.00,0.00,0.00,0.00),('1','145','826','190587',3726516,'2358','359',569000.60,569525.90,0.00,0.00,525.30,171896.00,0.00,0.00,0.00),('1','145','827','190587',3726517,'2359','359',524822.47,524822.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','190589',3726568,'2358','359',569525.90,577738.90,0.00,0.00,8213.00,2692052.20,0.00,0.00,0.00),('1','145','827','190589',3726569,'2359','359',524822.47,524822.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','190614',3727137,'2358','359',577738.90,577738.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','190614',3727138,'2359','359',524822.47,529209.07,0.00,0.00,4386.60,1442542.00,0.00,0.00,0.00),('1','145','826','190671',3728164,'2358','359',577738.90,577738.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','190671',3728165,'2359','359',529209.07,533524.87,0.00,0.00,4315.80,1419689.60,0.00,0.00,0.00),('1','145','826','190889',3732195,'2358','359',577738.90,577738.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','190889',3732196,'2359','359',533524.87,538667.67,0.00,0.00,5142.80,1685164.60,0.00,0.00,0.00),('1','145','826','191249',3738656,'2358','359',577738.90,577738.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','191249',3738657,'2359','359',538667.67,541438.17,0.00,0.00,2770.50,898192.00,0.00,0.00,0.00),('1','145','826','191252',3738692,'2358','359',577738.90,577738.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','191252',3738693,'2359','359',541438.17,541438.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','191254',3738720,'2358','359',577738.90,580568.90,0.00,0.00,2830.00,911264.00,0.00,0.00,0.00),('1','145','827','191254',3738721,'2359','359',541438.17,541438.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','191295',3739319,'2358','359',580568.90,580568.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','191295',3739320,'2359','359',541438.17,549137.77,0.00,0.00,7699.60,2487506.00,0.00,0.00,0.00),('1','145','826','191522',3743192,'2358','359',580568.90,583671.10,0.00,0.00,3102.20,1002582.00,0.00,0.00,0.00),('1','145','827','191522',3743193,'2359','359',549137.77,549137.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','191721',3747310,'2358','359',583671.10,588697.80,0.00,0.00,5026.70,1623690.00,0.00,0.00,0.00),('1','145','827','191721',3747311,'2359','359',549137.77,549137.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','191938',3751598,'2358','359',588697.80,593571.80,0.00,0.00,4874.00,1569416.00,0.00,0.00,0.00),('1','145','827','191938',3751599,'2359','359',549137.77,549137.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','192033',3753165,'2358','359',593571.80,593571.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','192033',3753166,'2359','359',549137.77,552747.67,0.00,0.00,3609.90,1167150.00,0.00,0.00,0.00),('1','145','826','192217',3756455,'2358','359',593571.80,598383.10,0.00,0.00,4811.30,1556976.00,0.00,0.00,0.00),('1','145','827','192217',3756456,'2359','359',552747.67,552747.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','192526',3762273,'2358','359',598383.10,598383.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','192526',3762274,'2359','359',552747.67,556171.17,0.00,0.00,3423.50,1110004.00,0.00,0.00,0.00),('1','145','826','192719',3765674,'2358','359',598383.10,598383.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','192719',3765675,'2359','359',556171.17,561179.37,0.00,0.00,5008.20,1622404.00,0.00,0.00,0.00),('1','145','826','193124',3773251,'2358','359',598383.10,598383.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','193124',3773252,'2359','359',561179.37,566051.57,0.00,0.00,4872.20,1577620.00,0.00,0.00,0.00),('1','145','826','193172',3774021,'2358','359',598383.10,598383.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','193172',3774022,'2359','359',566051.57,573208.87,0.00,0.00,7157.30,2309756.00,0.00,0.00,0.00),('1','145','826','193412',3778860,'2358','359',598383.10,604881.40,0.00,0.00,6498.30,2099468.00,0.00,0.00,0.00),('1','145','827','193412',3778861,'2359','359',573208.87,573208.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','193660',3783217,'2358','359',604881.40,610355.10,0.00,0.00,5473.70,1771666.00,0.00,0.00,0.00),('1','145','827','193660',3783218,'2359','359',573208.87,573208.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','193856',3786899,'2358','359',610355.10,616434.10,0.00,0.00,6079.00,1966668.00,0.00,0.00,0.00),('1','145','827','193856',3786900,'2359','359',573208.87,573208.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','194165',3792344,'2358','359',616434.10,618050.90,0.00,0.00,1616.80,524072.00,0.00,0.00,0.00),('1','145','827','194165',3792345,'2359','359',573208.87,573208.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','194169',3792439,'2358','359',618050.90,618050.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','194169',3792440,'2359','359',573208.87,577782.37,0.00,0.00,4573.50,1479618.00,0.00,0.00,0.00),('1','145','826','194294',3794866,'2358','359',618050.90,624930.70,0.00,0.00,6879.80,2235086.00,0.00,0.00,0.00),('1','145','827','194294',3794867,'2359','359',577782.37,577782.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','194520',3798809,'2358','359',624930.70,624930.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','194520',3798810,'2359','359',577782.37,581431.07,0.00,0.00,3648.70,1177734.00,0.00,0.00,0.00),('1','145','826','194679',3801724,'2358','359',624930.70,624930.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','194679',3801725,'2359','359',581431.07,588984.57,0.00,0.00,7553.50,2443860.00,0.00,0.00,0.00),('1','145','826','194891',3806079,'2358','359',624930.70,624930.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','194891',3806080,'2359','359',588984.57,590720.77,0.00,0.00,1736.20,560054.00,0.00,0.00,0.00),('1','145','826','194895',3806121,'2358','359',624930.70,631007.90,0.00,0.00,6077.20,1960062.00,0.00,0.00,0.00),('1','145','827','194895',3806122,'2359','359',590720.77,590720.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','195084',3809437,'2358','359',631007.90,637373.00,0.00,0.00,6365.10,2058686.00,0.00,0.00,0.00),('1','145','827','195084',3809438,'2359','359',590720.77,590720.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','195309',3813414,'2358','359',637373.00,642723.40,0.00,0.00,5350.40,1725626.00,0.00,0.00,0.00),('1','145','827','195309',3813415,'2359','359',590720.77,590720.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','195462',3816071,'2358','359',642723.40,642723.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','195462',3816072,'2359','359',590720.77,590720.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','195528',3817246,'2358','359',642723.40,642723.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','195528',3817247,'2359','359',590720.77,598242.47,0.00,0.00,7521.70,2428144.00,0.00,0.00,0.00),('1','145','826','195786',3821527,'2358','359',642723.40,642735.90,0.00,0.00,12.50,4250.00,0.00,0.00,0.00),('1','145','827','195786',3821528,'2359','359',598242.47,605151.77,0.00,0.00,6909.30,2241672.00,0.00,0.00,0.00),('1','145','826','196055',3826391,'2358','359',642735.90,647987.40,0.00,0.00,5251.50,1693770.00,0.00,0.00,0.00),('1','145','827','196055',3826392,'2359','359',605151.77,605151.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','196239',3830048,'2358','359',647987.40,648006.90,0.00,0.00,19.50,6630.00,0.00,0.00,0.00),('1','145','827','196239',3830049,'2359','359',605151.77,614668.37,0.00,0.00,9516.60,3072642.00,0.00,0.00,0.00),('1','145','826','196538',3835417,'2358','359',648006.90,648006.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','196538',3835418,'2359','359',614668.37,615422.57,0.00,0.00,754.20,247488.00,0.00,0.00,0.00),('1','145','826','196542',3835476,'2358','359',648006.90,655277.90,0.00,0.00,7271.00,2345842.00,0.00,0.00,0.00),('1','145','827','196542',3835477,'2359','359',615422.57,615422.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','196683',3837905,'2358','359',655277.90,655280.90,0.00,0.00,3.00,1020.00,0.00,0.00,0.00),('1','145','827','196683',3837906,'2359','359',615422.57,625104.87,0.00,0.00,9682.30,3123467.60,0.00,0.00,0.00),('1','145','826','196895',3841702,'2358','359',655280.90,662515.80,0.00,0.00,7234.90,2334334.00,0.00,0.00,0.00),('1','145','827','196895',3841703,'2359','359',625104.87,625104.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','197034',3844296,'2358','359',662515.80,667285.30,0.00,0.00,4769.50,1539446.00,0.00,0.00,0.00),('1','145','827','197034',3844297,'2359','359',625104.87,625104.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','197171',3846664,'2358','359',667285.30,667285.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','197171',3846665,'2359','359',625104.87,626699.97,0.00,0.00,1595.10,516572.00,0.00,0.00,0.00),('1','145','826','197541',3852775,'2358','359',667285.30,667285.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','197541',3852776,'2359','359',626699.97,634143.47,0.00,0.00,7443.50,2407200.00,0.00,0.00,0.00),('1','145','826','197819',3857967,'2358','359',667285.30,674227.40,0.00,0.00,6942.10,2248502.00,0.00,0.00,0.00),('1','145','827','197819',3857968,'2359','359',634143.47,634143.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','197821',3858001,'2358','359',674227.40,674227.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','197821',3858002,'2359','359',634143.47,638012.27,0.00,0.00,3868.80,1249490.00,0.00,0.00,0.00),('1','145','826','197978',3860713,'2358','359',674227.40,678903.50,0.00,0.00,4676.10,1508384.00,0.00,0.00,0.00),('1','145','827','197978',3860714,'2359','359',638012.27,638012.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','198079',3862571,'2358','359',678903.50,678903.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','198079',3862572,'2359','359',638012.27,639970.47,0.00,0.00,1958.20,632782.00,0.00,0.00,0.00),('1','145','826','198123',3863160,'2358','359',678903.50,678908.50,0.00,0.00,5.00,1700.00,0.00,0.00,0.00),('1','145','827','198123',3863161,'2359','359',639970.47,644910.17,0.00,0.00,4939.70,1602092.00,0.00,0.00,0.00),('1','145','826','198361',3867209,'2358','359',678908.50,685127.50,0.00,0.00,6219.00,2008548.00,0.00,0.00,0.00),('1','145','827','198361',3867210,'2359','359',644910.17,644910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','198580',3870916,'2358','359',685127.50,691957.90,0.00,0.00,6830.40,2203978.00,0.00,0.00,0.00),('1','145','827','198580',3870917,'2359','359',644910.17,644910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','198723',3873681,'2358','359',691957.90,691957.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','198723',3873682,'2359','359',644910.17,644910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','198791',3874477,'2358','359',691957.90,701226.70,0.00,0.00,9268.80,2996152.00,0.00,0.00,0.00),('1','145','827','198791',3874478,'2359','359',644910.17,644910.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','199028',3878589,'2358','359',701226.70,701237.10,0.00,0.00,10.40,3536.00,0.00,0.00,0.00),('1','145','827','199028',3878590,'2359','359',644910.17,649171.77,0.00,0.00,4261.60,1376848.00,0.00,0.00,0.00),('1','145','826','199218',3882036,'2358','359',701237.10,701360.10,0.00,0.00,123.00,39620.00,0.00,0.00,0.00),('1','145','827','199218',3882037,'2359','359',649171.77,657428.37,0.00,0.00,8256.60,2668702.00,0.00,0.00,0.00),('1','145','826','199442',3885570,'2358','359',701360.10,701360.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','199442',3885571,'2359','359',657428.37,664327.87,0.00,0.00,6899.50,2226502.00,0.00,0.00,0.00),('1','145','826','199834',3892009,'2358','359',701360.10,702539.30,0.00,0.00,1179.20,378636.00,0.00,0.00,0.00),('1','145','827','199834',3892010,'2359','359',664327.87,664327.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','199837',3892054,'2358','359',702539.30,702539.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','199837',3892055,'2359','359',664327.87,670634.27,0.00,0.00,6306.40,2038230.00,0.00,0.00,0.00),('1','145','826','199876',3892608,'2358','359',702539.30,709478.00,0.00,0.00,6938.70,2246174.00,0.00,0.00,0.00),('1','145','827','199876',3892609,'2359','359',670634.27,670634.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','200102',3896816,'2358','359',709478.00,716301.40,0.00,0.00,6823.40,2206250.00,0.00,0.00,0.00),('1','145','827','200102',3896817,'2359','359',670634.27,670634.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','200309',3900409,'2358','359',716301.40,716301.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','200309',3900410,'2359','359',670634.27,678852.57,0.00,0.00,8218.30,2660312.00,0.00,0.00,0.00),('1','145','826','200454',3903300,'2358','359',716301.40,716753.80,0.00,0.00,452.40,146396.00,0.00,0.00,0.00),('1','145','827','200454',3903301,'2359','359',678852.57,678852.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','200534',3904560,'2358','359',716753.80,721041.50,0.00,0.00,4287.70,1385264.00,0.00,0.00,0.00),('1','145','827','200534',3904561,'2359','359',678852.57,678863.57,0.00,0.00,11.00,3740.00,0.00,0.00,0.00),('1','145','826','200709',3907738,'2358','359',721041.50,728063.80,0.00,0.00,7022.30,2270542.00,0.00,0.00,0.00),('1','145','827','200709',3907739,'2359','359',678863.57,678863.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','200930',3911612,'2358','359',728063.80,728118.80,0.00,0.00,55.00,17600.00,0.00,0.00,0.00),('1','145','827','200930',3911613,'2359','359',678863.57,688934.47,0.00,0.00,10070.90,3247484.00,0.00,0.00,0.00),('1','145','826','201084',3914330,'2358','359',728118.80,728986.20,0.00,0.00,867.40,277986.00,0.00,0.00,0.00),('1','145','827','201084',3914331,'2359','359',688934.47,688934.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','201124',3914706,'2358','359',728986.20,741384.60,0.00,0.00,12398.40,3992346.00,0.00,0.00,0.00),('1','145','827','201124',3914707,'2359','359',688934.47,688994.47,0.00,0.00,60.00,19200.00,0.00,0.00,0.00),('1','145','826','202325',3936554,'2358','359',741384.60,741384.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','202325',3936555,'2359','359',688994.47,688994.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','202330',3936632,'2358','359',741384.60,741384.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','202330',3936633,'2359','359',688994.47,707500.77,0.00,0.00,18506.30,5951780.00,0.00,0.00,0.00),('1','145','826','202334',3936696,'2358','359',741384.60,741384.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','202334',3936697,'2359','359',707500.77,713126.47,0.00,0.00,5625.70,1881213.00,0.00,0.00,0.00),('1','145','826','202379',3937709,'2358','359',741384.60,750516.00,0.00,0.00,9131.40,3044469.00,0.00,0.00,0.00),('1','145','827','202379',3937710,'2359','359',713126.47,713126.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','202383',3937760,'2358','359',750516.00,760117.70,0.00,0.00,9601.70,3186192.00,0.00,0.00,0.00),('1','145','827','202383',3937761,'2359','359',713126.47,713126.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','202385',3937778,'2358','359',760117.70,765674.70,0.00,0.00,5557.00,1857087.00,0.00,0.00,0.00),('1','145','827','202385',3937779,'2359','359',713126.47,713126.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','202509',3939781,'2358','359',765674.70,765674.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','202509',3939782,'2359','359',713126.47,713126.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','202534',3940254,'2358','359',765674.70,765674.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','202534',3940255,'2359','359',713126.47,718266.27,0.00,0.00,5139.80,1777638.80,0.00,0.00,0.00),('1','145','826','202660',3942353,'2358','359',765674.70,765674.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','202660',3942354,'2359','359',718266.27,731868.47,0.00,0.00,13602.20,4681102.40,0.00,0.00,0.00),('1','145','826','202866',3946061,'2358','359',765674.70,775807.40,0.00,0.00,10132.70,3487965.20,0.00,0.00,0.00),('1','145','827','202866',3946062,'2359','359',731868.47,731868.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','203115',3950899,'2358','359',775807.40,775807.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','203115',3950900,'2359','359',731868.47,737733.37,0.00,0.00,5864.90,2018427.20,0.00,0.00,0.00),('1','145','826','203266',3953784,'2358','359',775807.40,779494.70,0.00,0.00,3687.30,1277906.40,0.00,0.00,0.00),('1','145','827','203266',3953785,'2359','359',737733.37,737733.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','203318',3954579,'2358','359',779494.70,790177.50,0.00,0.00,10682.80,3679194.40,0.00,0.00,0.00),('1','145','827','203318',3954580,'2359','359',737733.37,737733.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','203575',3959064,'2358','359',790177.50,790177.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','203575',3959065,'2359','359',737733.37,744382.47,0.00,0.00,6649.10,2276228.00,0.00,0.00,0.00),('1','145','826','203810',3963374,'2358','359',790177.50,790177.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','203810',3963375,'2359','359',744382.47,751445.37,0.00,0.00,7062.90,2751772.70,0.00,0.00,0.00),('1','145','826','203928',3965632,'2358','359',790177.50,790177.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','203928',3965633,'2359','359',751445.37,751445.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','204002',3966557,'2358','359',790177.50,790177.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','204002',3966558,'2359','359',751445.37,755729.97,0.00,0.00,4284.60,1682675.90,0.00,0.00,0.00),('1','145','826','204200',3970428,'2358','359',790177.50,790181.50,0.00,0.00,4.00,1664.00,0.00,0.00,0.00),('1','145','827','204200',3970429,'2359','359',755729.97,761885.97,0.00,0.00,6156.00,2408363.60,0.00,0.00,0.00),('1','145','826','204442',3974640,'2358','359',790181.50,792856.90,0.00,0.00,2675.40,1056571.20,0.00,0.00,0.00),('1','145','827','204442',3974641,'2359','359',761885.97,761885.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','204578',3977482,'2358','359',792856.90,792856.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','204578',3977483,'2359','359',761885.97,762391.27,0.00,0.00,505.30,199714.40,0.00,0.00,0.00),('1','145','826','204637',3978252,'2358','359',792856.90,797412.40,0.00,0.00,4555.50,1782377.40,0.00,0.00,0.00),('1','145','827','204637',3978253,'2359','359',762391.27,762398.47,0.00,0.00,7.20,2995.20,0.00,0.00,0.00),('1','145','826','204845',3981634,'2358','359',797412.40,797412.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','204845',3981635,'2359','359',762398.47,766767.57,0.00,0.00,4369.10,1727648.70,0.00,0.00,0.00),('1','145','826','205076',3985687,'2358','359',797412.40,797412.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','205076',3985688,'2359','359',766767.57,769820.67,0.00,0.00,3053.10,1192341.60,0.00,0.00,0.00),('1','145','826','205245',3988865,'2358','359',797412.40,802421.60,0.00,0.00,5009.20,1965453.70,0.00,0.00,0.00),('1','145','827','205245',3988866,'2359','359',769820.67,769920.67,0.00,0.00,100.00,38500.00,0.00,0.00,0.00),('1','145','826','205485',3993214,'2358','359',802421.60,806861.70,0.00,0.00,4440.10,1748988.30,0.00,0.00,0.00),('1','145','827','205485',3993215,'2359','359',769920.67,769920.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','205736',3997800,'2358','359',806861.70,810130.20,0.00,0.00,3268.50,1291009.30,0.00,0.00,0.00),('1','145','827','205736',3997801,'2359','359',769920.67,769920.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','205957',4001728,'2358','359',810130.20,813693.30,0.00,0.00,3563.10,1408525.40,0.00,0.00,0.00),('1','145','827','205957',4001729,'2359','359',769920.67,769920.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','206227',4006592,'2358','359',813693.30,813693.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','206227',4006593,'2359','359',769920.67,771714.07,0.00,0.00,1793.40,708262.30,0.00,0.00,0.00),('1','145','826','206324',4008351,'2358','359',813693.30,814621.80,0.00,0.00,928.50,367873.00,0.00,0.00,0.00),('1','145','827','206324',4008352,'2359','359',771714.07,771714.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','206325',4008353,'2358','359',814621.80,814621.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','206325',4008354,'2359','359',771714.07,771714.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','206369',4008972,'2358','359',814621.80,822195.00,0.00,0.00,7573.20,2962795.80,0.00,0.00,0.00),('1','145','827','206369',4008973,'2359','359',771714.07,771714.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','206602',4012985,'2358','359',822195.00,822195.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','206602',4012986,'2359','359',771714.07,774124.67,0.00,0.00,2410.60,949263.30,0.00,0.00,0.00),('1','145','826','206815',4016752,'2358','359',822195.00,822195.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','206815',4016753,'2359','359',774124.67,778086.97,0.00,0.00,3962.30,1561058.00,0.00,0.00,0.00),('1','145','826','207034',4020767,'2358','359',822195.00,822195.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','207034',4020768,'2359','359',778086.97,781272.37,0.00,0.00,3185.40,1260181.40,0.00,0.00,0.00),('1','145','826','207254',4024722,'2358','359',822195.00,822195.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','207254',4024723,'2359','359',781272.37,785330.67,0.00,0.00,4058.30,1604283.10,0.00,0.00,0.00),('1','145','826','207487',4028896,'2358','359',822195.00,822195.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','207487',4028897,'2359','359',785330.67,787037.47,0.00,0.00,1706.80,678052.30,0.00,0.00,0.00),('1','145','826','207649',4031752,'2358','359',822195.00,823283.40,0.00,0.00,1088.40,435020.70,0.00,0.00,0.00),('1','145','827','207649',4031753,'2359','359',787037.47,787037.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','207748',4033268,'2358','359',823283.40,826861.00,0.00,0.00,3577.60,1412883.40,0.00,0.00,0.00),('1','145','827','207748',4033269,'2359','359',787037.47,787037.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','207914',4036109,'2358','359',826861.00,832370.80,0.00,0.00,5509.80,2177882.10,0.00,0.00,0.00),('1','145','827','207914',4036110,'2359','359',787037.47,787037.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','208071',4038928,'2358','359',832370.80,832370.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','208071',4038929,'2359','359',787037.47,787037.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','208144',4040074,'2358','359',832370.80,835695.70,0.00,0.00,3324.90,1308665.40,0.00,0.00,0.00),('1','145','827','208144',4040075,'2359','359',787037.47,787037.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','208339',4043708,'2358','359',835695.70,838248.50,0.00,0.00,2552.80,1005454.90,0.00,0.00,0.00),('1','145','827','208339',4043709,'2359','359',787037.47,787037.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','208517',4046935,'2358','359',838248.50,838248.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','208517',4046936,'2359','359',787037.47,789049.27,0.00,0.00,2011.80,799842.10,0.00,0.00,0.00),('1','145','826','208566',4047602,'2358','359',838248.50,838248.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','208566',4047603,'2359','359',789049.27,792872.97,0.00,0.00,3823.70,1516972.20,0.00,0.00,0.00),('1','145','826','208769',4051173,'2358','359',838248.50,838248.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','208769',4051174,'2359','359',792872.97,795911.27,0.00,0.00,3038.30,1208501.70,0.00,0.00,0.00),('1','145','826','209006',4055212,'2358','359',838248.50,842514.30,0.00,0.00,4265.80,1717909.90,0.00,0.00,0.00),('1','145','827','209006',4055213,'2359','359',795911.27,795911.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','209220',4059034,'2358','359',842514.30,842514.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','209220',4059035,'2359','359',795911.27,803325.77,0.00,0.00,7414.50,2966993.90,0.00,0.00,0.00),('1','145','826','209449',4063005,'2358','359',842514.30,842514.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','209449',4063006,'2359','359',803325.77,806595.17,0.00,0.00,3269.40,1336993.00,0.00,0.00,0.00),('1','145','826','209612',4066137,'2358','359',842514.30,847055.80,0.00,0.00,4541.50,1840448.30,0.00,0.00,0.00),('1','145','827','209612',4066138,'2359','359',806595.17,806595.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','209613',4066139,'2358','359',847055.80,847055.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','209613',4066140,'2359','359',806595.17,806595.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','209684',4067194,'2358','359',847055.80,852322.30,0.00,0.00,5266.50,2127168.50,0.00,0.00,0.00),('1','145','827','209684',4067195,'2359','359',806595.17,806595.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','209874',4070600,'2358','359',852322.30,859307.60,0.00,0.00,6985.30,2975536.50,0.00,0.00,0.00),('1','145','827','209874',4070601,'2359','359',806595.17,806595.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','210106',4074797,'2358','359',859307.60,862951.20,0.00,0.00,3643.60,1559588.40,0.00,0.00,0.00),('1','145','827','210106',4074798,'2359','359',806595.17,806595.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','210596',4083524,'2358','359',862951.20,862951.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','210596',4083525,'2359','359',806595.17,806595.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','210779',4086732,'2358','359',862951.20,862951.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','210779',4086733,'2359','359',806595.17,811597.57,0.00,0.00,5002.40,2143264.10,0.00,0.00,0.00),('1','145','826','210963',4089763,'2358','359',862951.20,862951.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','210963',4089764,'2359','359',811597.57,816511.17,0.00,0.00,4913.60,2117366.80,0.00,0.00,0.00),('1','145','826','211204',4094029,'2358','359',862951.20,865680.10,0.00,0.00,2728.90,1169921.20,0.00,0.00,0.00),('1','145','827','211204',4094030,'2359','359',816511.17,816511.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','211382',4097386,'2358','359',865680.10,870663.50,0.00,0.00,4983.40,2134220.80,0.00,0.00,0.00),('1','145','827','211382',4097387,'2359','359',816511.17,816511.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','211652',4101997,'2358','359',870663.50,870663.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','211652',4101998,'2359','359',816511.17,818824.97,0.00,0.00,2313.80,992494.70,0.00,0.00,0.00),('1','145','826','211785',4104139,'2358','359',870663.50,870663.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','211785',4104140,'2359','359',818824.97,822659.07,0.00,0.00,3834.10,1647726.60,0.00,0.00,0.00),('1','145','826','211998',4107978,'2358','359',870663.50,870667.60,0.00,0.00,4.10,1849.10,0.00,0.00,0.00),('1','145','827','211998',4107979,'2359','359',822659.07,825778.77,0.00,0.00,3119.70,1341032.20,0.00,0.00,0.00),('1','145','826','212240',4112236,'2358','359',870667.60,870667.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','212240',4112237,'2359','359',825778.77,829772.67,0.00,0.00,3993.90,1715192.90,0.00,0.00,0.00),('1','145','826','212460',4116347,'2358','359',870667.60,870667.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','212460',4116348,'2359','359',829772.67,831107.57,0.00,0.00,1334.90,569914.60,0.00,0.00,0.00),('1','145','826','212616',4119248,'2358','359',870667.60,875105.00,0.00,0.00,4437.40,1911404.60,0.00,0.00,0.00),('1','145','827','212616',4119249,'2359','359',831107.57,831107.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','212707',4120724,'2358','359',875105.00,877506.30,0.00,0.00,2401.30,1026938.30,0.00,0.00,0.00),('1','145','827','212707',4120725,'2359','359',831107.57,831107.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','212878',4123736,'2358','359',877506.30,877506.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','212878',4123737,'2359','359',831107.57,835228.67,0.00,0.00,4121.10,1765482.80,0.00,0.00,0.00),('1','145','826','213133',4128163,'2358','359',877506.30,881751.40,0.00,0.00,4245.10,1821707.50,0.00,0.00,0.00),('1','145','827','213133',4128164,'2359','359',835228.67,835241.17,0.00,0.00,12.50,5637.50,0.00,0.00,0.00),('1','145','826','213398',4132463,'2358','359',881751.40,886400.30,0.00,0.00,4648.90,1984595.10,0.00,0.00,0.00),('1','145','827','213398',4132464,'2359','359',835241.17,835241.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','213704',4137658,'2358','359',886400.30,887578.80,0.00,0.00,1178.50,505934.70,0.00,0.00,0.00),('1','145','827','213704',4137659,'2359','359',835241.17,835241.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','213706',4137692,'2358','359',887578.80,887578.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','213706',4137693,'2359','359',835241.17,837146.07,0.00,0.00,1904.90,829371.60,0.00,0.00,0.00),('1','145','826','213894',4140709,'2358','359',887578.80,887581.80,0.00,0.00,3.00,1353.00,0.00,0.00,0.00),('1','145','827','213894',4140710,'2359','359',837146.07,840911.97,0.00,0.00,3765.90,1619854.50,0.00,0.00,0.00),('1','145','826','214100',4144166,'2358','359',887581.80,887594.30,0.00,0.00,12.50,5250.00,0.00,0.00,0.00),('1','145','827','214100',4144167,'2359','359',840911.97,845448.97,0.00,0.00,4537.00,1964784.10,0.00,0.00,0.00),('1','145','826','214367',4148745,'2358','359',887594.30,887594.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','214367',4148746,'2359','359',845448.97,846327.47,0.00,0.00,878.50,380126.90,0.00,0.00,0.00),('1','145','826','214542',4151707,'2358','359',887594.30,887594.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','214542',4151708,'2359','359',846327.47,851399.87,0.00,0.00,5072.40,2175423.10,0.00,0.00,0.00),('1','145','826','214790',4156034,'2358','359',887594.30,892583.10,0.00,0.00,4988.80,2150308.60,0.00,0.00,0.00),('1','145','827','214790',4156035,'2359','359',851399.87,851399.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','215017',4159813,'2358','359',892583.10,892583.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','215017',4159814,'2359','359',851399.87,854978.47,0.00,0.00,3578.60,1540664.60,0.00,0.00,0.00),('1','145','826','215334',4165324,'2358','359',892583.10,892583.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','215334',4165325,'2359','359',854978.47,855789.67,0.00,0.00,811.20,399936.00,0.00,0.00,0.00),('1','145','826','215344',4165459,'2358','359',892583.10,892583.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','215344',4165460,'2359','359',855789.67,855789.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','215363',4165783,'2358','359',892583.10,894933.10,0.00,0.00,2350.00,1150668.00,0.00,0.00,0.00),('1','145','827','215363',4165784,'2359','359',855789.67,855789.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','215449',4167114,'2358','359',894933.10,894935.10,0.00,0.00,2.00,1020.00,0.00,0.00,0.00),('1','145','827','215449',4167115,'2359','359',855789.67,858856.07,0.00,0.00,3066.40,1507560.00,0.00,0.00,0.00),('1','145','826','215681',4171141,'2358','359',894935.10,894935.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','215681',4171142,'2359','359',858856.07,863885.07,0.00,0.00,5029.00,2465241.00,0.00,0.00,0.00),('1','145','826','215933',4175403,'2358','359',894935.10,897314.50,0.00,0.00,2379.40,1165986.00,0.00,0.00,0.00),('1','145','827','215933',4175404,'2359','359',863885.07,863897.57,0.00,0.00,12.50,6375.00,0.00,0.00,0.00),('1','145','826','216192',4179882,'2358','359',897314.50,901053.20,0.00,0.00,3738.70,1831347.00,0.00,0.00,0.00),('1','145','827','216192',4179883,'2359','359',863897.57,863897.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','216328',4182331,'2358','359',901053.20,904871.40,0.00,0.00,3818.20,1862199.00,0.00,0.00,0.00),('1','145','827','216328',4182332,'2359','359',863897.57,863897.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','216562',4186345,'2358','359',904871.40,908601.00,0.00,0.00,3729.60,1824321.00,0.00,0.00,0.00),('1','145','827','216562',4186346,'2359','359',863897.57,863897.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','216796',4190557,'2358','359',908601.00,911935.40,0.00,0.00,3334.40,1638672.00,0.00,0.00,0.00),('1','145','827','216796',4190558,'2359','359',863897.57,863897.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','217068',4195187,'2358','359',911935.40,912123.20,0.00,0.00,187.80,96492.00,0.00,0.00,0.00),('1','145','827','217068',4195188,'2359','359',863897.57,863897.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','217082',4195380,'2358','359',912123.20,912303.20,0.00,0.00,180.00,90000.00,0.00,0.00,0.00),('1','145','827','217082',4195381,'2359','359',863897.57,867418.77,0.00,0.00,3521.20,1801780.00,0.00,0.00,0.00),('1','145','826','217283',4199463,'2358','359',912303.20,918079.60,0.00,0.00,5776.40,2949124.00,0.00,0.00,0.00),('1','145','827','217283',4199464,'2359','359',867418.77,867504.77,0.00,0.00,86.00,43240.00,0.00,0.00,0.00),('1','145','826','217577',4204368,'2358','359',918079.60,918084.60,0.00,0.00,5.00,2700.00,0.00,0.00,0.00),('1','145','827','217577',4204369,'2359','359',867504.77,869722.17,0.00,0.00,2217.40,1135396.00,0.00,0.00,0.00),('1','145','826','217716',4206715,'2358','359',918084.60,918084.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','217716',4206716,'2359','359',869722.17,874338.07,0.00,0.00,4615.90,2366038.00,0.00,0.00,0.00),('1','145','826','218012',4212142,'2358','359',918084.60,918084.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','218012',4212143,'2359','359',874338.07,876730.07,0.00,0.00,2392.00,1227232.00,0.00,0.00,0.00),('1','145','826','218409',4219218,'2358','359',918084.60,918084.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','218409',4219219,'2359','359',876730.07,878063.67,0.00,0.00,1333.60,673416.00,0.00,0.00,0.00),('1','145','826','218486',4220325,'2358','359',918084.60,918084.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','218486',4220326,'2359','359',878063.67,880323.07,0.00,0.00,2259.40,1164208.00,0.00,0.00,0.00),('1','145','826','218629',4223223,'2358','359',918084.60,918956.20,0.00,0.00,871.60,453704.00,0.00,0.00,0.00),('1','145','827','218629',4223224,'2359','359',880323.07,880323.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','218634',4223313,'2358','359',918956.20,918956.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','218634',4223314,'2359','359',880323.07,880323.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','218697',4224167,'2358','359',918956.20,918956.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','218697',4224168,'2359','359',880323.07,883527.27,0.00,0.00,3204.20,1648324.00,0.00,0.00,0.00),('1','145','826','218916',4228048,'2358','359',918956.20,918956.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','218916',4228049,'2359','359',883527.27,886506.17,0.00,0.00,2978.90,1549286.00,0.00,0.00,0.00),('1','145','826','219159',4232085,'2358','359',918956.20,921593.80,0.00,0.00,2637.60,1350672.00,0.00,0.00,0.00),('1','145','827','219159',4232086,'2359','359',886506.17,886506.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','219371',4235757,'2358','359',921593.80,925086.10,0.00,0.00,3492.30,1790642.00,0.00,0.00,0.00),('1','145','827','219371',4235758,'2359','359',886506.17,886514.17,0.00,0.00,8.00,4320.00,0.00,0.00,0.00),('1','145','826','219608',4239899,'2358','359',925086.10,927978.30,0.00,0.00,2892.20,1487932.00,0.00,0.00,0.00),('1','145','827','219608',4239900,'2359','359',886514.17,886514.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','219817',4243759,'2358','359',927978.30,930627.60,0.00,0.00,2649.30,1362446.00,0.00,0.00,0.00),('1','145','827','219817',4243760,'2359','359',886514.17,886514.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','220047',4247926,'2358','359',930627.60,933563.00,0.00,0.00,2935.40,1516596.00,0.00,0.00,0.00),('1','145','827','220047',4247927,'2359','359',886514.17,886514.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','220262',4251641,'2358','359',933563.00,934010.50,0.00,0.00,447.50,209690.00,0.00,0.00,0.00),('1','145','827','220262',4251642,'2359','359',886514.17,886514.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','220477',4255641,'2358','359',934010.50,936723.10,0.00,0.00,2712.60,1265176.00,0.00,0.00,0.00),('1','145','827','220477',4255642,'2359','359',886514.17,886514.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','220518',4256235,'2358','359',936723.10,936723.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','220518',4256236,'2359','359',886514.17,892514.47,0.00,0.00,6000.30,2813878.00,0.00,0.00,0.00),('1','145','826','220736',4259904,'2358','359',936723.10,939473.30,0.00,0.00,2750.20,1291572.00,0.00,0.00,0.00),('1','145','827','220736',4259905,'2359','359',892514.47,892514.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','220925',4263424,'2358','359',939473.30,944108.20,0.00,0.00,4634.90,2186886.00,0.00,0.00,0.00),('1','145','827','220925',4263425,'2359','359',892514.47,892514.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','221153',4267446,'2358','359',944108.20,944108.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','221153',4267447,'2359','359',892514.47,897169.87,0.00,0.00,4655.40,2205332.00,0.00,0.00,0.00),('1','145','826','221431',4272349,'2358','359',944108.20,944108.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','221431',4272350,'2359','359',897169.87,901786.87,0.00,0.00,4617.00,2184128.00,0.00,0.00,0.00),('1','145','826','221631',4276179,'2358','359',944108.20,944108.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','221631',4276180,'2359','359',901786.87,904986.37,0.00,0.00,3199.50,1516286.00,0.00,0.00,0.00),('1','145','826','221795',4279278,'2358','359',944108.20,944415.20,0.00,0.00,307.00,153500.00,0.00,0.00,0.00),('1','145','827','221795',4279279,'2359','359',904986.37,905446.57,0.00,0.00,460.20,214212.00,0.00,0.00,0.00),('1','145','826','221862',4280209,'2358','359',944415.20,947627.80,0.00,0.00,3212.60,1539896.00,0.00,0.00,0.00),('1','145','827','221862',4280210,'2359','359',905446.57,905446.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','222061',4284037,'2358','359',947627.80,952433.50,0.00,0.00,4805.70,2297250.00,0.00,0.00,0.00),('1','145','827','222061',4284038,'2359','359',905446.57,905446.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','222308',4287900,'2358','359',952433.50,952433.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','222308',4287901,'2359','359',905446.57,907550.97,0.00,0.00,2104.40,994844.00,0.00,0.00,0.00),('1','145','826','222496',4291349,'2358','359',952433.50,952433.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','222496',4291350,'2359','359',907550.97,910841.07,0.00,0.00,3290.10,1568942.00,0.00,0.00,0.00),('1','145','826','222727',4295736,'2358','359',952433.50,955837.10,0.00,0.00,3403.60,1619588.00,0.00,0.00,0.00),('1','145','827','222727',4295737,'2359','359',910841.07,910841.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','222960',4300012,'2358','359',955837.10,959762.20,0.00,0.00,3925.10,1848822.00,0.00,0.00,0.00),('1','145','827','222960',4300013,'2359','359',910841.07,910841.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','223138',4303260,'2358','359',959762.20,959762.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','223138',4303261,'2359','359',910841.07,910841.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','223186',4303819,'2358','359',959762.20,960785.30,0.00,0.00,1023.10,539734.00,0.00,0.00,0.00),('1','145','827','223186',4303820,'2359','359',910841.07,910841.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','223381',4307201,'2358','359',960785.30,960785.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','223381',4307202,'2359','359',910841.07,911724.67,0.00,0.00,883.60,460536.00,0.00,0.00,0.00),('1','145','826','223435',4308094,'2358','359',960785.30,960785.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','223435',4308095,'2359','359',911724.67,914836.27,0.00,0.00,3111.60,1600588.00,0.00,0.00,0.00),('1','145','826','223644',4312051,'2358','359',960785.30,960785.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','223644',4312052,'2359','359',914836.27,918502.97,0.00,0.00,3666.70,1895962.00,0.00,0.00,0.00),('1','145','826','223906',4316792,'2358','359',960785.30,960785.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','223906',4316793,'2359','359',918502.97,921008.07,0.00,0.00,2505.10,1277586.00,0.00,0.00,0.00),('1','145','826','224089',4320011,'2358','359',960785.30,960785.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','224089',4320012,'2359','359',921008.07,923992.87,0.00,0.00,2984.80,1548940.00,0.00,0.00,0.00),('1','145','826','224310',4324108,'2358','359',960785.30,960791.30,0.00,0.00,6.00,3240.00,0.00,0.00,0.00),('1','145','827','224310',4324109,'2359','359',923992.87,927508.27,0.00,0.00,3515.40,1799188.00,0.00,0.00,0.00),('1','145','826','224532',4327942,'2358','359',960791.30,960791.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','224532',4327943,'2359','359',927508.27,929976.27,0.00,0.00,2468.00,1275456.00,0.00,0.00,0.00),('1','145','826','224744',4331717,'2358','359',960791.30,961713.20,0.00,0.00,921.90,472534.00,0.00,0.00,0.00),('1','145','827','224744',4331718,'2359','359',929976.27,929976.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','224787',4332286,'2358','359',961713.20,966244.10,0.00,0.00,4530.90,2311886.00,0.00,0.00,0.00),('1','145','827','224787',4332287,'2359','359',929976.27,929976.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','225024',4336608,'2358','359',966244.10,969864.80,0.00,0.00,3620.70,1868330.00,0.00,0.00,0.00),('1','145','827','225024',4336609,'2359','359',929976.27,929976.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','225269',4341137,'2358','359',969864.80,976052.10,0.00,0.00,6187.30,3147382.00,0.00,0.00,0.00),('1','145','827','225269',4341138,'2359','359',929976.27,929976.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','225515',4345517,'2358','359',976052.10,979911.30,0.00,0.00,3859.20,1966596.00,0.00,0.00,0.00),('1','145','827','225515',4345518,'2359','359',929976.27,929976.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','225748',4349386,'2358','359',979911.30,980492.20,0.00,0.00,580.90,295686.00,0.00,0.00,0.00),('1','145','827','225748',4349387,'2359','359',929976.27,929976.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','225749',4349388,'2358','359',980492.20,980492.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','225749',4349389,'2359','359',929976.27,937951.17,0.00,0.00,7974.90,4024894.00,0.00,0.00,0.00),('1','145','826','225981',4353490,'2358','359',980492.20,980508.30,0.00,0.00,16.10,8694.00,0.00,0.00,0.00),('1','145','827','225981',4353491,'2359','359',937951.17,941134.67,0.00,0.00,3183.50,1638318.00,0.00,0.00,0.00),('1','145','826','226235',4358383,'2358','359',980508.30,980508.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','226235',4358384,'2359','359',941134.67,945596.97,0.00,0.00,4462.30,2277990.00,0.00,0.00,0.00),('1','145','826','226478',4362574,'2358','359',980508.30,984670.00,0.00,0.00,4161.70,2342683.00,0.00,0.00,0.00),('1','145','827','226478',4362575,'2359','359',945596.97,945596.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','226741',4367353,'2358','359',984670.00,984670.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','226741',4367354,'2359','359',945596.97,947964.97,0.00,0.00,2368.00,1358296.00,0.00,0.00,0.00),('1','145','826','226965',4371374,'2358','359',984670.00,984670.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','226965',4371375,'2359','359',947964.97,949570.37,0.00,0.00,1605.40,900170.00,0.00,0.00,0.00),('1','145','826','227083',4373265,'2358','359',984670.00,986367.40,0.00,0.00,1697.40,980550.00,0.00,0.00,0.00),('1','145','827','227083',4373266,'2359','359',949570.37,949570.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','227219',4375628,'2358','359',986367.40,988851.80,0.00,0.00,2484.40,1391656.00,0.00,0.00,0.00),('1','145','827','227219',4375629,'2359','359',949570.37,949570.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','227379',4378635,'2358','359',988851.80,988851.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','227379',4378636,'2359','359',949570.37,953195.97,0.00,0.00,3625.60,2055364.00,0.00,0.00,0.00),('1','145','826','227612',4382626,'2358','359',988851.80,991605.60,0.00,0.00,2753.80,1556742.00,0.00,0.00,0.00),('1','145','827','227612',4382627,'2359','359',953195.97,953195.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','227858',4387006,'2358','359',991605.60,994413.70,0.00,0.00,2808.10,1594827.00,0.00,0.00,0.00),('1','145','827','227858',4387007,'2359','359',953195.97,953195.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','228118',4391979,'2358','359',994413.70,998366.30,0.00,0.00,3952.60,2227994.00,0.00,0.00,0.00),('1','145','827','228118',4391980,'2359','359',953195.97,953195.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','228354',4396506,'2358','359',998366.30,1002511.20,0.00,0.00,4144.90,2349543.00,0.00,0.00,0.00),('1','145','827','228354',4396507,'2359','359',953195.97,953195.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','228534',4399871,'2358','359',1002511.20,1005133.90,0.00,0.00,2622.70,1487549.00,0.00,0.00,0.00),('1','145','827','228534',4399872,'2359','359',953195.97,953195.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','228682',4402721,'2358','359',1005133.90,1005133.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','228682',4402722,'2359','359',953195.97,953195.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','228776',4404335,'2358','359',1005133.90,1005133.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','228776',4404336,'2359','359',953195.97,957243.67,0.00,0.00,4047.70,2258479.00,0.00,0.00,0.00),('1','145','826','228947',4407501,'2358','359',1005133.90,1005133.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','228947',4407502,'2359','359',957243.67,961678.17,0.00,0.00,4434.50,2492015.00,0.00,0.00,0.00),('1','145','826','229176',4412052,'2358','359',1005133.90,1005133.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','229176',4412053,'2359','359',961678.17,966777.17,0.00,0.00,5099.00,2872674.00,0.00,0.00,0.00),('1','145','826','229420',4416365,'2358','359',1005133.90,1009178.00,0.00,0.00,4044.10,2436283.00,0.00,0.00,0.00),('1','145','827','229420',4416366,'2359','359',966777.17,966827.17,0.00,0.00,50.00,29500.00,0.00,0.00,0.00),('1','145','826','229685',4421488,'2358','359',1009178.00,1012904.20,0.00,0.00,3726.20,2267314.00,0.00,0.00,0.00),('1','145','827','229685',4421489,'2359','359',966827.17,966827.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','229847',4425073,'2358','359',1012904.20,1012904.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','229847',4425074,'2359','359',966827.17,966827.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','229893',4425705,'2358','359',1012904.20,1015528.10,0.00,0.00,2623.90,1597341.00,0.00,0.00,0.00),('1','145','827','229893',4425706,'2359','359',966827.17,966827.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','230093',4429366,'2358','359',1015528.10,1019757.60,0.00,0.00,4229.50,2541665.00,0.00,0.00,0.00),('1','145','827','230093',4429367,'2359','359',966827.17,966827.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','230329',4433640,'2358','359',1019757.60,1019769.60,0.00,0.00,12.00,7560.00,0.00,0.00,0.00),('1','145','827','230329',4433641,'2359','359',966827.17,972449.27,0.00,0.00,5622.10,3368895.00,0.00,0.00,0.00),('1','145','826','230491',4437088,'2358','359',1019769.60,1019769.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','230491',4437089,'2359','359',972449.27,972449.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','230537',4437686,'2358','359',1019769.60,1019769.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','230537',4437687,'2359','359',972449.27,974205.27,0.00,0.00,1756.00,1047288.00,0.00,0.00,0.00),('1','145','826','231564',4455226,'2358','359',1019769.60,1019769.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','231564',4455227,'2359','359',974205.27,974205.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','231646',4456493,'2358','359',1019769.60,1019769.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','231646',4456494,'2359','359',974205.27,979668.47,0.00,0.00,5463.20,3549300.00,0.00,0.00,0.00),('1','145','826','231904',4461198,'2358','359',1019769.60,1019769.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','231904',4461199,'2359','359',979668.47,984401.57,0.00,0.00,4733.10,3098280.00,0.00,0.00,0.00),('1','145','826','232140',4465429,'2358','359',1019769.60,1019769.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','232140',4465430,'2359','359',984401.57,987835.27,0.00,0.00,3433.70,2231336.00,0.00,0.00,0.00),('1','145','826','232275',4468033,'2358','359',1019769.60,1019769.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','232275',4468034,'2359','359',987835.27,987835.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','232361',4469323,'2358','359',1019769.60,1019769.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','232361',4469324,'2359','359',987835.27,994613.67,0.00,0.00,6778.40,4414844.00,0.00,0.00,0.00),('1','145','826','232603',4473787,'2358','359',1019769.60,1019769.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','232603',4473788,'2359','359',994613.67,998806.57,0.00,0.00,4192.90,2736468.00,0.00,0.00,0.00),('1','145','826','232729',4476234,'2358','359',1019769.60,1021830.40,0.00,0.00,2060.80,1350604.00,0.00,0.00,0.00),('1','145','827','232729',4476235,'2359','359',998806.57,998806.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','232857',4478318,'2358','359',1021830.40,1025779.20,0.00,0.00,3948.80,2584364.00,0.00,0.00,0.00),('1','145','827','232857',4478319,'2359','359',998806.57,998806.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','233128',4483177,'2358','359',1025779.20,1025789.20,0.00,0.00,10.00,6800.00,0.00,0.00,0.00),('1','145','827','233128',4483178,'2359','359',998806.57,1003101.97,0.00,0.00,4295.40,2803788.00,0.00,0.00,0.00),('1','145','826','233394',4488061,'2358','359',1025789.20,1030944.80,0.00,0.00,5155.60,3358036.00,0.00,0.00,0.00),('1','145','827','233394',4488062,'2359','359',1003101.97,1003101.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','233621',4492182,'2358','359',1030944.80,1032580.20,0.00,0.00,1635.40,1065100.00,0.00,0.00,0.00),('1','145','827','233621',4492183,'2359','359',1003101.97,1003101.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','233714',4493888,'2358','359',1032580.20,1032580.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','233714',4493889,'2359','359',1003101.97,1009045.97,0.00,0.00,5944.00,3869276.00,0.00,0.00,0.00),('1','145','826','233882',4496845,'2358','359',1032580.20,1032605.20,0.00,0.00,25.00,17000.00,0.00,0.00,0.00),('1','145','827','233882',4496846,'2359','359',1009045.97,1012481.57,0.00,0.00,3435.60,2228816.00,0.00,0.00,0.00),('1','145','826','234140',4501647,'2358','359',1032605.20,1036955.10,0.00,0.00,4349.90,2856032.00,0.00,0.00,0.00),('1','145','827','234140',4501648,'2359','359',1012481.57,1012481.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','234319',4504755,'2358','359',1036955.10,1036955.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','234319',4504756,'2359','359',1012481.57,1019313.27,0.00,0.00,6831.70,4441684.00,0.00,0.00,0.00),('1','145','826','234580',4509377,'2358','359',1036955.10,1036955.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','234580',4509378,'2359','359',1019313.27,1021355.67,0.00,0.00,2042.40,1423472.00,0.00,0.00,0.00),('1','145','826','234845',4514069,'2358','359',1036955.10,1036955.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','234845',4514070,'2359','359',1021355.67,1023639.67,0.00,0.00,2284.00,1582224.00,0.00,0.00,0.00),('1','145','826','235090',4518487,'2358','359',1036955.10,1037452.40,0.00,0.00,497.30,341903.00,0.00,0.00,0.00),('1','145','827','235090',4518488,'2359','359',1023639.67,1023639.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','235118',4518972,'2358','359',1037452.40,1040536.00,0.00,0.00,3083.60,2109064.00,0.00,0.00,0.00),('1','145','827','235118',4518973,'2359','359',1023639.67,1023639.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','235338',4522747,'2358','359',1040536.00,1040536.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','235338',4522748,'2359','359',1023639.67,1027208.47,0.00,0.00,3568.80,2459692.00,0.00,0.00,0.00),('1','145','826','235574',4526852,'2358','359',1040536.00,1040536.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','235574',4526853,'2359','359',1027208.47,1029774.27,0.00,0.00,2565.80,1749746.00,0.00,0.00,0.00),('1','145','826','235772',4530355,'2358','359',1040536.00,1044423.00,0.00,0.00,3887.00,2655506.00,0.00,0.00,0.00),('1','145','827','235772',4530356,'2359','359',1029774.27,1029774.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','236039',4534989,'2358','359',1044423.00,1047804.50,0.00,0.00,3381.50,2320113.00,0.00,0.00,0.00),('1','145','827','236039',4534990,'2359','359',1029774.27,1029774.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','236247',4538786,'2358','359',1047804.50,1051121.50,0.00,0.00,3317.00,2279138.00,0.00,0.00,0.00),('1','145','827','236247',4538787,'2359','359',1029774.27,1029784.27,0.00,0.00,10.00,7100.00,0.00,0.00,0.00),('1','145','826','236526',4543698,'2358','359',1051121.50,1054892.80,0.00,0.00,3771.30,2582007.00,0.00,0.00,0.00),('1','145','827','236526',4543699,'2359','359',1029784.27,1029784.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','236749',4547409,'2358','359',1054892.80,1057077.70,0.00,0.00,2184.90,1512867.00,0.00,0.00,0.00),('1','145','827','236749',4547410,'2359','359',1029784.27,1029784.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','236982',4551588,'2358','359',1057077.70,1057103.70,0.00,0.00,26.00,17420.00,0.00,0.00,0.00),('1','145','827','236982',4551589,'2359','359',1029784.27,1033700.07,0.00,0.00,3915.80,2692394.00,0.00,0.00,0.00),('1','145','826','237215',4555658,'2358','359',1057103.70,1057103.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','237215',4555659,'2359','359',1033700.07,1036004.57,0.00,0.00,2304.50,1576111.00,0.00,0.00,0.00),('1','145','826','237404',4559178,'2358','359',1057103.70,1057103.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','237404',4559179,'2359','359',1036004.57,1038667.77,0.00,0.00,2663.20,1836496.00,0.00,0.00,0.00),('1','145','826','237626',4563052,'2358','359',1057103.70,1057103.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','237626',4563053,'2359','359',1038667.77,1038695.27,0.00,0.00,27.50,19525.00,0.00,0.00,0.00),('1','145','826','237635',4563169,'2358','359',1057103.70,1057103.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','237635',4563170,'2359','359',1038695.27,1041877.37,0.00,0.00,3182.10,2118389.00,0.00,0.00,0.00),('1','145','826','237888',4567345,'2358','359',1057103.70,1057103.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','237888',4567346,'2359','359',1041877.37,1045141.87,0.00,0.00,3264.50,2181201.00,0.00,0.00,0.00),('1','145','826','238143',4571394,'2358','359',1057103.70,1057103.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','238143',4571395,'2359','359',1045141.87,1048242.47,0.00,0.00,3100.60,2058534.00,0.00,0.00,0.00),('1','145','826','238298',4574329,'2358','359',1057103.70,1057738.10,0.00,0.00,634.40,417956.00,0.00,0.00,0.00),('1','145','827','238298',4574330,'2359','359',1048242.47,1048242.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','238371',4575512,'2358','359',1057738.10,1061327.00,0.00,0.00,3588.90,2385753.00,0.00,0.00,0.00),('1','145','827','238371',4575513,'2359','359',1048242.47,1048245.47,0.00,0.00,3.00,2070.00,0.00,0.00,0.00),('1','145','826','238620',4579552,'2358','359',1061327.00,1067115.80,0.00,0.00,5788.80,3820968.00,0.00,0.00,0.00),('1','145','827','238620',4579553,'2359','359',1048245.47,1048245.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','238879',4584291,'2358','359',1067115.80,1070667.10,0.00,0.00,3551.30,2342141.00,0.00,0.00,0.00),('1','145','827','238879',4584292,'2359','359',1048245.47,1048250.47,0.00,0.00,5.00,3450.00,0.00,0.00,0.00),('1','145','826','239080',4587777,'2358','359',1070667.10,1075829.30,0.00,0.00,5162.20,3515958.00,0.00,0.00,0.00),('1','145','827','239080',4587778,'2359','359',1048250.47,1048250.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','239312',4591777,'2358','359',1075829.30,1076740.50,0.00,0.00,911.20,624312.00,0.00,0.00,0.00),('1','145','827','239312',4591778,'2359','359',1048250.47,1048250.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','239378',4592979,'2358','359',1076740.50,1076740.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','239378',4592980,'2359','359',1048250.47,1050228.87,0.00,0.00,1978.40,1364220.00,0.00,0.00,0.00),('1','145','826','239541',4595642,'2358','359',1076740.50,1076740.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','239541',4595643,'2359','359',1050228.87,1052891.37,0.00,0.00,2662.50,1826231.00,0.00,0.00,0.00),('1','145','826','239791',4600026,'2358','359',1076740.50,1076740.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','239791',4600027,'2359','359',1052891.37,1055621.67,0.00,0.00,2730.30,1876773.00,0.00,0.00,0.00),('1','145','826','240012',4603859,'2358','359',1076740.50,1076740.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','240012',4603860,'2359','359',1055621.67,1058366.47,0.00,0.00,2744.80,1881536.00,0.00,0.00,0.00),('1','145','826','240142',4606340,'2358','359',1076740.50,1076740.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','240142',4606341,'2359','359',1058366.47,1058366.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','240212',4607376,'2358','359',1076740.50,1076740.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','240212',4607377,'2359','359',1058366.47,1062184.57,0.00,0.00,3818.10,2626783.00,0.00,0.00,0.00),('1','145','826','240494',4611917,'2358','359',1076740.50,1076740.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','240494',4611918,'2359','359',1062184.57,1064590.07,0.00,0.00,2405.50,1647001.00,0.00,0.00,0.00),('1','145','826','240705',4615157,'2358','359',1076740.50,1076740.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','240705',4615158,'2359','359',1064590.07,1066449.07,0.00,0.00,1859.00,1288706.00,0.00,0.00,0.00),('1','145','826','240983',4620068,'2358','359',1076740.50,1076740.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','240983',4620069,'2359','359',1066449.07,1067915.97,0.00,0.00,1466.90,1004455.00,0.00,0.00,0.00),('1','145','826','241094',4622151,'2358','359',1076740.50,1078136.60,0.00,0.00,1396.10,961615.00,0.00,0.00,0.00),('1','145','827','241094',4622152,'2359','359',1067915.97,1067915.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','241233',4624629,'2358','359',1078136.60,1080934.90,0.00,0.00,2798.30,1929141.00,0.00,0.00,0.00),('1','145','827','241233',4624630,'2359','359',1067915.97,1067915.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','241501',4629154,'2358','359',1080934.90,1083511.10,0.00,0.00,2576.20,1776342.00,0.00,0.00,0.00),('1','145','827','241501',4629155,'2359','359',1067915.97,1067915.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','241751',4633555,'2358','359',1083511.10,1085789.00,0.00,0.00,2277.90,1575861.00,0.00,0.00,0.00),('1','145','827','241751',4633556,'2359','359',1067915.97,1067928.47,0.00,0.00,12.50,8875.00,0.00,0.00,0.00),('1','145','826','241993',4637622,'2358','359',1085789.00,1089752.60,0.00,0.00,3963.60,2735544.00,0.00,0.00,0.00),('1','145','827','241993',4637623,'2359','359',1067928.47,1067928.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','242263',4642490,'2358','359',1089752.60,1091155.90,0.00,0.00,1403.30,921157.00,0.00,0.00,0.00),('1','145','827','242263',4642491,'2359','359',1067928.47,1067928.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','242300',4643133,'2358','359',1091155.90,1091155.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','242300',4643134,'2359','359',1067928.47,1069025.67,0.00,0.00,1097.20,732996.00,0.00,0.00,0.00),('1','145','826','242441',4645563,'2358','359',1091155.90,1091155.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','242441',4645564,'2359','359',1069025.67,1072076.27,0.00,0.00,3050.60,2035258.00,0.00,0.00,0.00),('1','145','826','242685',4649879,'2358','359',1091155.90,1091155.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','242685',4649880,'2359','359',1072076.27,1074784.17,0.00,0.00,2707.90,1822703.00,0.00,0.00,0.00),('1','145','826','242935',4654087,'2358','359',1091155.90,1091160.90,0.00,0.00,5.00,3450.00,0.00,0.00,0.00),('1','145','827','242935',4654088,'2359','359',1074784.17,1078173.27,0.00,0.00,3389.10,2260799.00,0.00,0.00,0.00),('1','145','826','243155',4657880,'2358','359',1091160.90,1091160.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','243155',4657881,'2359','359',1078173.27,1081186.87,0.00,0.00,3013.60,2021940.00,0.00,0.00,0.00),('1','145','826','243380',4661993,'2358','359',1091160.90,1091160.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','243380',4661994,'2359','359',1081186.87,1081897.57,0.00,0.00,710.70,467403.00,0.00,0.00,0.00),('1','145','826','243465',4663585,'2358','359',1091160.90,1092805.20,0.00,0.00,1644.30,1119615.00,0.00,0.00,0.00),('1','145','827','243465',4663586,'2359','359',1081897.57,1081897.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','243611',4665901,'2358','359',1092805.20,1097012.20,0.00,0.00,4207.00,2831990.00,0.00,0.00,0.00),('1','145','827','243611',4665902,'2359','359',1081897.57,1081897.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','243905',4671090,'2358','359',1097012.20,1099252.60,0.00,0.00,2240.40,1492544.00,0.00,0.00,0.00),('1','145','827','243905',4671091,'2359','359',1081897.57,1081897.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','244067',4673903,'2358','359',1099252.60,1101904.20,0.00,0.00,2651.60,1782408.00,0.00,0.00,0.00),('1','145','827','244067',4673904,'2359','359',1081897.57,1081897.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','244305',4677842,'2358','359',1101904.20,1104922.60,0.00,0.00,3018.40,2035792.00,0.00,0.00,0.00),('1','145','827','244305',4677843,'2359','359',1081897.57,1081897.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','244534',4681880,'2358','359',1104922.60,1107378.20,0.00,0.00,2455.60,1652272.00,0.00,0.00,0.00),('1','145','827','244534',4681881,'2359','359',1081897.57,1081897.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','244764',4685724,'2358','359',1107378.20,1109619.00,0.00,0.00,2240.80,1511812.00,0.00,0.00,0.00),('1','145','827','244764',4685725,'2359','359',1081897.57,1081897.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','245002',4689925,'2358','359',1109619.00,1112104.50,0.00,0.00,2485.50,1637752.00,0.00,0.00,0.00),('1','145','827','245002',4689926,'2359','359',1081897.57,1081897.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','245230',4693953,'2358','359',1112104.50,1115716.00,0.00,0.00,3611.50,2365548.00,0.00,0.00,0.00),('1','145','827','245230',4693954,'2359','359',1081897.57,1081897.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','245346',4696167,'2358','359',1115716.00,1115716.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','245346',4696168,'2359','359',1081897.57,1083177.87,0.00,0.00,1280.30,850392.00,0.00,0.00,0.00),('1','145','826','245507',4698789,'2358','359',1115716.00,1117947.20,0.00,0.00,2231.20,1456960.00,0.00,0.00,0.00),('1','145','827','245507',4698790,'2359','359',1083177.87,1083177.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','245691',4701981,'2358','359',1117947.20,1121193.90,0.00,0.00,3246.70,2136828.00,0.00,0.00,0.00),('1','145','827','245691',4701982,'2359','359',1083177.87,1083177.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','245954',4706005,'2358','359',1121193.90,1121227.40,0.00,0.00,33.50,21440.00,0.00,0.00,0.00),('1','145','827','245954',4706006,'2359','359',1083177.87,1087230.47,0.00,0.00,4052.60,2491720.00,0.00,0.00,0.00),('1','145','826','246202',4710213,'2358','359',1121227.40,1121227.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','246202',4710214,'2359','359',1087230.47,1090207.07,0.00,0.00,2976.60,1837944.00,0.00,0.00,0.00),('1','145','826','246467',4714689,'2358','359',1121227.40,1121227.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','246467',4714690,'2359','359',1090207.07,1093975.57,0.00,0.00,3768.50,2315448.00,0.00,0.00,0.00),('1','145','826','246715',4718919,'2358','359',1121227.40,1121227.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','246715',4718920,'2359','359',1093975.57,1095496.57,0.00,0.00,1521.00,946712.00,0.00,0.00,0.00),('1','145','826','246874',4721990,'2358','359',1121227.40,1121631.20,0.00,0.00,403.80,258432.00,0.00,0.00,0.00),('1','145','827','246874',4721991,'2359','359',1095496.57,1095496.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','246955',4723228,'2358','359',1121631.20,1126049.30,0.00,0.00,4418.10,2725584.00,0.00,0.00,0.00),('1','145','827','246955',4723229,'2359','359',1095496.57,1095496.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','247224',4727786,'2358','359',1126049.30,1126049.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','247224',4727787,'2359','359',1095496.57,1095496.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','247231',4727958,'2358','359',1126049.30,1128438.70,0.00,0.00,2389.40,1474908.00,0.00,0.00,0.00),('1','145','827','247231',4727959,'2359','359',1095496.57,1095496.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','247419',4731242,'2358','359',1128438.70,1131301.30,0.00,0.00,2862.60,1785340.00,0.00,0.00,0.00),('1','145','827','247419',4731243,'2359','359',1095496.57,1095496.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','247684',4735676,'2358','359',1131301.30,1134440.40,0.00,0.00,3139.10,1945992.00,0.00,0.00,0.00),('1','145','827','247684',4735677,'2359','359',1095496.57,1095496.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','247927',4739809,'2358','359',1134440.40,1137677.70,0.00,0.00,3237.30,2002380.00,0.00,0.00,0.00),('1','145','827','247927',4739810,'2359','359',1095496.57,1095496.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','248175',4744065,'2358','359',1137677.70,1137682.70,0.00,0.00,5.00,3200.00,0.00,0.00,0.00),('1','145','827','248175',4744066,'2359','359',1095496.57,1099097.57,0.00,0.00,3601.00,2226524.00,0.00,0.00,0.00),('1','145','826','248418',4748160,'2358','359',1137682.70,1137695.20,0.00,0.00,12.50,8000.00,0.00,0.00,0.00),('1','145','827','248418',4748161,'2359','359',1099097.57,1103050.07,0.00,0.00,3952.50,2455684.00,0.00,0.00,0.00),('1','145','826','248655',4752065,'2358','359',1137695.20,1140239.70,0.00,0.00,2544.50,1555616.00,0.00,0.00,0.00),('1','145','827','248655',4752066,'2359','359',1103050.07,1103050.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','248735',4753641,'2358','359',1140239.70,1140239.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','248735',4753642,'2359','359',1103050.07,1103050.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','248737',4753685,'2358','359',1140239.70,1140239.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','248737',4753686,'2359','359',1103050.07,1105254.17,0.00,0.00,2204.10,1353672.00,0.00,0.00,0.00),('1','145','826','248925',4756658,'2358','359',1140239.70,1140239.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','248925',4756659,'2359','359',1105254.17,1107418.97,0.00,0.00,2164.80,1329376.00,0.00,0.00,0.00),('1','145','826','249127',4760006,'2358','359',1140239.70,1140239.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','249127',4760007,'2359','359',1107418.97,1109609.77,0.00,0.00,2190.80,1358480.00,0.00,0.00,0.00),('1','145','826','249365',4764195,'2358','359',1140239.70,1140239.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','249365',4764196,'2359','359',1109609.77,1111598.67,0.00,0.00,1988.90,1230304.00,0.00,0.00,0.00),('1','145','826','249602',4768228,'2358','359',1140239.70,1140239.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','249602',4768229,'2359','359',1111598.67,1115775.27,0.00,0.00,4176.60,2419897.00,0.00,0.00,0.00),('1','145','826','249871',4772704,'2358','359',1140239.70,1140239.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','249871',4772705,'2359','359',1115775.27,1118467.27,0.00,0.00,2692.00,1575860.00,0.00,0.00,0.00),('1','145','826','250116',4776749,'2358','359',1140239.70,1140239.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','250116',4776750,'2359','359',1118467.27,1120185.77,0.00,0.00,1718.50,1005138.00,0.00,0.00,0.00),('1','145','826','250240',4779024,'2358','359',1140239.70,1142425.30,0.00,0.00,2185.60,1277689.20,0.00,0.00,0.00),('1','145','827','250240',4779025,'2359','359',1120185.77,1120185.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','250396',4781453,'2358','359',1142425.30,1142425.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','250396',4781454,'2359','359',1120185.77,1120185.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','250398',4781473,'2358','359',1142425.30,1142425.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','250398',4781474,'2359','359',1120185.77,1123943.77,0.00,0.00,3758.00,2181523.00,0.00,0.00,0.00),('1','145','826','250613',4785018,'2358','359',1142425.30,1142425.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','250613',4785019,'2359','359',1123943.77,1125622.67,0.00,0.00,1678.90,977424.60,0.00,0.00,0.00),('1','145','826','250815',4788651,'2358','359',1142425.30,1145173.00,0.00,0.00,2747.70,1609900.40,0.00,0.00,0.00),('1','145','827','250815',4788652,'2359','359',1125622.67,1125622.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','251037',4792718,'2358','359',1145173.00,1147802.90,0.00,0.00,2629.90,1541819.60,0.00,0.00,0.00),('1','145','827','251037',4792719,'2359','359',1125622.67,1125622.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','251286',4796931,'2358','359',1147802.90,1149646.60,0.00,0.00,1843.70,1086511.20,0.00,0.00,0.00),('1','145','827','251286',4796932,'2359','359',1125622.67,1125622.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','251527',4801037,'2358','359',1149646.60,1151046.30,0.00,0.00,1399.70,836121.60,0.00,0.00,0.00),('1','145','827','251527',4801038,'2359','359',1125622.67,1125622.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','251781',4805582,'2358','359',1151046.30,1152669.30,0.00,0.00,1623.00,969421.80,0.00,0.00,0.00),('1','145','827','251781',4805583,'2359','359',1125622.67,1125622.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','252009',4809507,'2358','359',1152669.30,1155527.30,0.00,0.00,2858.00,1684255.00,0.00,0.00,0.00),('1','145','827','252009',4809508,'2359','359',1125622.67,1125622.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','252282',4814177,'2358','359',1155527.30,1157299.80,0.00,0.00,1772.50,1037848.40,0.00,0.00,0.00),('1','145','827','252282',4814178,'2359','359',1125622.67,1125622.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','252493',4818120,'2358','359',1157299.80,1159230.70,0.00,0.00,1930.90,1145597.40,0.00,0.00,0.00),('1','145','827','252493',4818121,'2359','359',1125622.67,1125622.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','252727',4822184,'2358','359',1159230.70,1159792.70,0.00,0.00,562.00,312790.00,0.00,0.00,0.00),('1','145','827','252727',4822185,'2359','359',1125622.67,1125622.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','252806',4823427,'2358','359',1159792.70,1159832.70,0.00,0.00,40.00,22000.00,0.00,0.00,0.00),('1','145','827','252806',4823428,'2359','359',1125622.67,1127619.27,0.00,0.00,1996.60,1135594.00,0.00,0.00,0.00),('1','145','826','252979',4826204,'2358','359',1159832.70,1159845.70,0.00,0.00,13.00,7540.00,0.00,0.00,0.00),('1','145','827','252979',4826205,'2359','359',1127619.27,1129631.07,0.00,0.00,2011.80,1138506.00,0.00,0.00,0.00),('1','145','826','253217',4830310,'2358','359',1159845.70,1159845.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','253217',4830311,'2359','359',1129631.07,1131599.77,0.00,0.00,1968.70,1118539.00,0.00,0.00,0.00),('1','145','826','253419',4833854,'2358','359',1159845.70,1159845.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','253419',4833855,'2359','359',1131599.77,1131599.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','253493',4834939,'2358','359',1159845.70,1159845.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','253493',4834940,'2359','359',1131599.77,1133688.97,0.00,0.00,2089.20,1184163.00,0.00,0.00,0.00),('1','145','826','253721',4838834,'2358','359',1159845.70,1159858.20,0.00,0.00,12.50,7250.00,0.00,0.00,0.00),('1','145','827','253721',4838835,'2359','359',1133688.97,1136608.07,0.00,0.00,2919.10,1658914.00,0.00,0.00,0.00),('1','145','826','254014',4843901,'2358','359',1159858.20,1159858.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','254014',4843902,'2359','359',1136608.07,1138707.47,0.00,0.00,2099.40,1180998.00,0.00,0.00,0.00),('1','145','826','254215',4847638,'2358','359',1159858.20,1159858.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','254215',4847639,'2359','359',1138707.47,1141802.47,0.00,0.00,3095.00,1740989.00,0.00,0.00,0.00),('1','145','826','254470',4851907,'2358','359',1159858.20,1159858.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','254470',4851908,'2359','359',1141802.47,1144671.87,0.00,0.00,2869.40,1605548.00,0.00,0.00,0.00),('1','145','826','254637',4855181,'2358','359',1159858.20,1159858.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','254637',4855182,'2359','359',1144671.87,1144671.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','254638',4855183,'2358','359',1159858.20,1160140.70,0.00,0.00,282.50,163850.00,0.00,0.00,0.00),('1','145','827','254638',4855184,'2359','359',1144671.87,1144671.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','254715',4856228,'2358','359',1160140.70,1162893.30,0.00,0.00,2752.60,1552813.00,0.00,0.00,0.00),('1','145','827','254715',4856229,'2359','359',1144671.87,1144695.67,0.00,0.00,23.80,13804.00,0.00,0.00,0.00),('1','145','826','254968',4860542,'2358','359',1162893.30,1165942.20,0.00,0.00,3048.90,1717887.00,0.00,0.00,0.00),('1','145','827','254968',4860543,'2359','359',1144695.67,1144695.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','255207',4864595,'2358','359',1165942.20,1169522.40,0.00,0.00,3580.20,1995480.00,0.00,0.00,0.00),('1','145','827','255207',4864596,'2359','359',1144695.67,1144695.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','255395',4868126,'2358','359',1169522.40,1169522.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','255395',4868127,'2359','359',1144695.67,1144695.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','255478',4869288,'2358','359',1169522.40,1172746.00,0.00,0.00,3223.60,1815538.00,0.00,0.00,0.00),('1','145','827','255478',4869289,'2359','359',1144695.67,1144695.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','255766',4873952,'2358','359',1172746.00,1174334.90,0.00,0.00,1588.90,890662.00,0.00,0.00,0.00),('1','145','827','255766',4873953,'2359','359',1144695.67,1144695.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','255862',4875715,'2358','359',1174334.90,1174334.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','255862',4875716,'2359','359',1144695.67,1145508.57,0.00,0.00,812.90,460622.00,0.00,0.00,0.00),('1','145','826','255965',4877240,'2358','359',1174334.90,1174351.90,0.00,0.00,17.00,9860.00,0.00,0.00,0.00),('1','145','827','255965',4877241,'2359','359',1145508.57,1149045.67,0.00,0.00,3537.10,1991611.00,0.00,0.00,0.00),('1','145','826','256229',4881435,'2358','359',1174351.90,1174356.90,0.00,0.00,5.00,2900.00,0.00,0.00,0.00),('1','145','827','256229',4881436,'2359','359',1149045.67,1153435.97,0.00,0.00,4390.30,2448019.00,0.00,0.00,0.00),('1','145','826','256420',4885052,'2358','359',1174356.90,1174356.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','256420',4885053,'2359','359',1153435.97,1153435.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','256498',4886179,'2358','359',1174356.90,1174356.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','256498',4886180,'2359','359',1153435.97,1155417.07,0.00,0.00,1981.10,1159320.00,0.00,0.00,0.00),('1','145','826','256743',4890122,'2358','359',1174356.90,1174356.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','256743',4890123,'2359','359',1155417.07,1157817.57,0.00,0.00,2400.50,1409346.00,0.00,0.00,0.00),('1','145','826','256978',4894285,'2358','359',1174356.90,1174356.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','256978',4894286,'2359','359',1157817.57,1158809.47,0.00,0.00,991.90,587061.00,0.00,0.00,0.00),('1','145','826','257184',4898315,'2358','359',1174356.90,1175325.00,0.00,0.00,968.10,567762.00,0.00,0.00,0.00),('1','145','827','257184',4898316,'2359','359',1158809.47,1158809.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257250',4899240,'2358','359',1175325.00,1178570.90,0.00,0.00,3245.90,1904358.00,0.00,0.00,0.00),('1','145','827','257250',4899241,'2359','359',1158809.47,1158821.97,0.00,0.00,12.50,7500.00,0.00,0.00,0.00),('1','145','826','257535',4904043,'2358','359',1178570.90,1180967.40,0.00,0.00,2396.50,1394886.00,0.00,0.00,0.00),('1','145','827','257535',4904044,'2359','359',1158821.97,1158821.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257536',4904045,'2358','359',1180967.40,1184384.40,0.00,0.00,3417.00,1997469.00,0.00,0.00,0.00),('1','145','827','257536',4904046,'2359','359',1158821.97,1158821.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257537',4904047,'2358','359',1184384.40,1184384.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257537',4904048,'2359','359',1158821.97,1158821.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257538',4904049,'2358','359',1184384.40,1184385.90,0.00,0.00,1.50,900.00,0.00,0.00,0.00),('1','145','827','257538',4904050,'2359','359',1158821.97,1162134.27,0.00,0.00,3312.30,1934649.00,0.00,0.00,0.00),('1','145','826','257539',4904051,'2358','359',1184385.90,1184402.50,0.00,0.00,16.60,9960.00,0.00,0.00,0.00),('1','145','827','257539',4904052,'2359','359',1162134.27,1164742.97,0.00,0.00,2608.70,1529730.00,0.00,0.00,0.00),('1','145','826','257540',4904053,'2358','359',1184402.50,1186625.90,0.00,0.00,2223.40,1303569.00,0.00,0.00,0.00),('1','145','827','257540',4904054,'2359','359',1164742.97,1164742.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257541',4904055,'2358','359',1186625.90,1186910.90,0.00,0.00,285.00,164400.00,0.00,0.00,0.00),('1','145','827','257541',4904056,'2359','359',1164742.97,1164742.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257542',4904057,'2358','359',1186910.90,1186923.40,0.00,0.00,12.50,7500.00,0.00,0.00,0.00),('1','145','827','257542',4904058,'2359','359',1164742.97,1167714.57,0.00,0.00,2971.60,1737213.00,0.00,0.00,0.00),('1','145','826','257543',4904059,'2358','359',1186923.40,1186926.40,0.00,0.00,3.00,1740.00,0.00,0.00,0.00),('1','145','827','257543',4904060,'2359','359',1167714.57,1170088.17,0.00,0.00,2373.60,1323936.00,0.00,0.00,0.00),('1','145','826','257544',4904061,'2358','359',1186926.40,1186926.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257544',4904062,'2359','359',1170088.17,1170088.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257545',4904063,'2358','359',1186926.40,1186926.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257545',4904064,'2359','359',1170088.17,1173367.87,0.00,0.00,3279.70,1834942.00,0.00,0.00,0.00),('1','145','826','257546',4904065,'2358','359',1186926.40,1186926.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257546',4904066,'2359','359',1173367.87,1177992.47,0.00,0.00,4624.60,2553256.00,0.00,0.00,0.00),('1','145','826','257547',4904067,'2358','359',1186926.40,1186926.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257547',4904068,'2359','359',1177992.47,1183201.37,0.00,0.00,5208.90,2882066.00,0.00,0.00,0.00),('1','145','826','257548',4904069,'2358','359',1186926.40,1186926.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257548',4904070,'2359','359',1183201.37,1183453.47,0.00,0.00,252.10,143770.00,0.00,0.00,0.00),('1','145','826','257549',4904071,'2358','359',1186926.40,1190136.60,0.00,0.00,3210.20,1783044.00,0.00,0.00,0.00),('1','145','827','257549',4904072,'2359','359',1183453.47,1183488.97,0.00,0.00,35.50,20590.00,0.00,0.00,0.00),('1','145','826','257550',4904073,'2358','359',1190136.60,1193090.30,0.00,0.00,2953.70,1640982.00,0.00,0.00,0.00),('1','145','827','257550',4904074,'2359','359',1183488.97,1183488.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257551',4904075,'2358','359',1193090.30,1197150.30,0.00,0.00,4060.00,2273944.00,0.00,0.00,0.00),('1','145','827','257551',4904076,'2359','359',1183488.97,1183488.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257552',4904077,'2358','359',1197150.30,1199218.20,0.00,0.00,2067.90,1151230.00,0.00,0.00,0.00),('1','145','827','257552',4904078,'2359','359',1183488.97,1183488.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257553',4904079,'2358','359',1199218.20,1202967.70,0.00,0.00,3749.50,2082282.00,0.00,0.00,0.00),('1','145','827','257553',4904080,'2359','359',1183488.97,1183488.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257554',4904081,'2358','359',1202967.70,1206429.70,0.00,0.00,3462.00,1917104.00,0.00,0.00,0.00),('1','145','827','257554',4904082,'2359','359',1183488.97,1183488.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257555',4904083,'2358','359',1206429.70,1209403.70,0.00,0.00,2974.00,1653488.00,0.00,0.00,0.00),('1','145','827','257555',4904084,'2359','359',1183488.97,1183488.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257556',4904085,'2358','359',1209403.70,1211006.90,0.00,0.00,1603.20,899376.00,0.00,0.00,0.00),('1','145','827','257556',4904086,'2359','359',1183488.97,1183488.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257557',4904087,'2358','359',1211006.90,1212487.30,0.00,0.00,1480.40,824868.00,0.00,0.00,0.00),('1','145','827','257557',4904088,'2359','359',1183488.97,1183488.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257558',4904089,'2358','359',1212487.30,1212487.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257558',4904090,'2359','359',1183488.97,1183488.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257559',4904091,'2358','359',1212487.30,1212487.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257559',4904092,'2359','359',1183488.97,1183488.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257560',4904093,'2358','359',1212487.30,1212487.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257560',4904094,'2359','359',1183488.97,1184372.27,0.00,0.00,883.30,497414.00,0.00,0.00,0.00),('1','145','826','257561',4904095,'2358','359',1212487.30,1212487.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257561',4904096,'2359','359',1184372.27,1188319.47,0.00,0.00,3947.20,2195244.00,0.00,0.00,0.00),('1','145','826','257562',4904097,'2358','359',1212487.30,1212487.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257562',4904098,'2359','359',1188319.47,1191027.17,0.00,0.00,2707.70,1500562.00,0.00,0.00,0.00),('1','145','826','257563',4904099,'2358','359',1212487.30,1215530.60,0.00,0.00,3043.30,1694078.00,0.00,0.00,0.00),('1','145','827','257563',4904100,'2359','359',1191027.17,1191033.17,0.00,0.00,6.00,3480.00,0.00,0.00,0.00),('1','145','826','257564',4904101,'2358','359',1215530.60,1222315.20,0.00,0.00,6784.60,3697408.40,0.00,0.00,0.00),('1','145','827','257564',4904102,'2359','359',1191033.17,1191033.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257565',4904103,'2358','359',1222315.20,1222315.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257565',4904104,'2359','359',1191033.17,1198686.17,0.00,0.00,7653.00,4404793.60,0.00,0.00,0.00),('1','145','826','257566',4904105,'2358','359',1222315.20,1222315.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257566',4904106,'2359','359',1198686.17,1207314.47,0.00,0.00,8628.30,4952842.20,0.00,0.00,0.00),('1','145','826','257567',4904107,'2358','359',1222315.20,1222315.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257567',4904108,'2359','359',1207314.47,1207941.37,0.00,0.00,626.90,366377.00,0.00,0.00,0.00),('1','145','826','257568',4904109,'2358','359',1222315.20,1225620.50,0.00,0.00,3305.30,1931029.00,0.00,0.00,0.00),('1','145','827','257568',4904110,'2359','359',1207941.37,1207941.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257569',4904111,'2358','359',1225620.50,1230032.20,0.00,0.00,4411.70,2582633.00,0.00,0.00,0.00),('1','145','827','257569',4904112,'2359','359',1207941.37,1207941.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257570',4904113,'2358','359',1230032.20,1232563.40,0.00,0.00,2531.20,1481476.00,0.00,0.00,0.00),('1','145','827','257570',4904114,'2359','359',1207941.37,1207941.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257571',4904115,'2358','359',1232563.40,1232563.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257571',4904116,'2359','359',1207941.37,1207941.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257572',4904117,'2358','359',1232563.40,1232563.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257572',4904118,'2359','359',1207941.37,1208435.97,0.00,0.00,494.60,287090.00,0.00,0.00,0.00),('1','145','826','257573',4904119,'2358','359',1232563.40,1232563.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257573',4904120,'2359','359',1208435.97,1212259.37,0.00,0.00,3823.40,2341544.00,0.00,0.00,0.00),('1','145','826','257574',4904121,'2358','359',1232563.40,1235167.60,0.00,0.00,2604.20,1605204.00,0.00,0.00,0.00),('1','145','827','257574',4904122,'2359','359',1212259.37,1212259.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257575',4904123,'2358','359',1235167.60,1236983.60,0.00,0.00,1816.00,1108820.00,0.00,0.00,0.00),('1','145','827','257575',4904124,'2359','359',1212259.37,1212259.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257576',4904125,'2358','359',1236983.60,1236983.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257576',4904126,'2359','359',1212259.37,1214508.67,0.00,0.00,2249.30,1390668.00,0.00,0.00,0.00),('1','145','826','257577',4904127,'2358','359',1236983.60,1236983.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257577',4904128,'2359','359',1214508.67,1216989.87,0.00,0.00,2481.20,1552808.00,0.00,0.00,0.00),('1','145','826','257578',4904129,'2358','359',1236983.60,1236983.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257578',4904130,'2359','359',1216989.87,1216989.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257579',4904131,'2358','359',1236983.60,1240686.00,0.00,0.00,3702.40,2285484.00,0.00,0.00,0.00),('1','145','827','257579',4904132,'2359','359',1216989.87,1216989.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257580',4904133,'2358','359',1240686.00,1244615.70,0.00,0.00,3929.70,2437904.00,0.00,0.00,0.00),('1','145','827','257580',4904134,'2359','359',1216989.87,1216989.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257581',4904135,'2358','359',1244615.70,1244615.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257581',4904136,'2359','359',1216989.87,1220464.47,0.00,0.00,3474.60,2131288.00,0.00,0.00,0.00),('1','145','826','257582',4904137,'2358','359',1244615.70,1244615.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257582',4904138,'2359','359',1220464.47,1224040.57,0.00,0.00,3576.10,2207264.00,0.00,0.00,0.00),('1','145','826','257583',4904139,'2358','359',1244615.70,1244615.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257583',4904140,'2359','359',1224040.57,1225685.97,0.00,0.00,1645.40,1017044.00,0.00,0.00,0.00),('1','145','826','257584',4904141,'2358','359',1244615.70,1244615.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257584',4904142,'2359','359',1225685.97,1228476.07,0.00,0.00,2790.10,1897882.00,0.00,0.00,0.00),('1','145','826','257585',4904143,'2358','359',1244615.70,1244615.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257585',4904144,'2359','359',1228476.07,1231230.87,0.00,0.00,2754.80,1879068.00,0.00,0.00,0.00),('1','145','826','257586',4904145,'2358','359',1244615.70,1244615.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257586',4904146,'2359','359',1231230.87,1232542.67,0.00,0.00,1311.80,896060.00,0.00,0.00,0.00),('1','145','826','257587',4904147,'2358','359',1244615.70,1245672.10,0.00,0.00,1056.40,724192.00,0.00,0.00,0.00),('1','145','827','257587',4904148,'2359','359',1232542.67,1232542.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257588',4904149,'2358','359',1245672.10,1248847.20,0.00,0.00,3175.10,2162198.00,0.00,0.00,0.00),('1','145','827','257588',4904150,'2359','359',1232542.67,1232542.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257589',4904151,'2358','359',1248847.20,1252413.10,0.00,0.00,3565.90,2404650.00,0.00,0.00,0.00),('1','145','827','257589',4904152,'2359','359',1232542.67,1232542.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257590',4904153,'2358','359',1252413.10,1255384.20,0.00,0.00,2971.10,2016142.00,0.00,0.00,0.00),('1','145','827','257590',4904154,'2359','359',1232542.67,1232542.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257591',4904155,'2358','359',1255384.20,1255384.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257591',4904156,'2359','359',1232542.67,1232542.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257592',4904157,'2358','359',1255384.20,1255384.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257592',4904158,'2359','359',1232542.67,1235745.67,0.00,0.00,3203.00,2166596.00,0.00,0.00,0.00),('1','145','826','257593',4904159,'2358','359',1255384.20,1255384.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257593',4904160,'2359','359',1235745.67,1237604.97,0.00,0.00,1859.30,1275926.00,0.00,0.00,0.00),('1','145','826','257594',4904161,'2358','359',1255384.20,1258013.30,0.00,0.00,2629.10,1784122.00,0.00,0.00,0.00),('1','145','827','257594',4904162,'2359','359',1237604.97,1237604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257595',4904163,'2358','359',1258013.30,1259835.60,0.00,0.00,1822.30,1246002.00,0.00,0.00,0.00),('1','145','827','257595',4904164,'2359','359',1237604.97,1237604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257596',4904165,'2358','359',1259835.60,1261743.70,0.00,0.00,1908.10,1297586.00,0.00,0.00,0.00),('1','145','827','257596',4904166,'2359','359',1237604.97,1237604.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257597',4904167,'2358','359',1261743.70,1261743.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257597',4904168,'2359','359',1237604.97,1238716.87,0.00,0.00,1111.90,755254.00,0.00,0.00,0.00),('1','145','826','257598',4904169,'2358','359',1261743.70,1261743.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257598',4904170,'2359','359',1238716.87,1240126.27,0.00,0.00,1409.40,959360.00,0.00,0.00,0.00),('1','145','826','257599',4904171,'2358','359',1261743.70,1261743.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257599',4904172,'2359','359',1240126.27,1240126.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257600',4904173,'2358','359',1261743.70,1263917.50,0.00,0.00,2173.80,1490988.00,0.00,0.00,0.00),('1','145','827','257600',4904174,'2359','359',1240126.27,1240126.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257601',4904175,'2358','359',1263917.50,1266169.60,0.00,0.00,2252.10,1651587.00,0.00,0.00,0.00),('1','145','827','257601',4904176,'2359','359',1240126.27,1240126.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257602',4904177,'2358','359',1266169.60,1266169.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257602',4904178,'2359','359',1240126.27,1242182.07,0.00,0.00,2055.80,1499018.00,0.00,0.00,0.00),('1','145','826','257603',4904179,'2358','359',1266169.60,1266169.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257603',4904180,'2359','359',1242182.07,1244570.77,0.00,0.00,2388.70,1747085.00,0.00,0.00,0.00),('1','145','826','257604',4904181,'2358','359',1266169.60,1266169.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257604',4904182,'2359','359',1244570.77,1246511.57,0.00,0.00,1940.80,1428108.00,0.00,0.00,0.00),('1','145','826','257605',4904183,'2358','359',1266169.60,1266169.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257605',4904184,'2359','359',1246511.57,1249317.87,0.00,0.00,2806.30,2062957.00,0.00,0.00,0.00),('1','145','826','257606',4904185,'2358','359',1266169.60,1266169.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257606',4904186,'2359','359',1249317.87,1251208.97,0.00,0.00,1891.10,1382397.00,0.00,0.00,0.00),('1','145','826','257607',4904187,'2358','359',1266169.60,1266169.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257607',4904188,'2359','359',1251208.97,1253353.07,0.00,0.00,2144.10,1581559.00,0.00,0.00,0.00),('1','145','826','257608',4904189,'2358','359',1266169.60,1266169.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257608',4904190,'2359','359',1253353.07,1255791.07,0.00,0.00,2438.00,1781512.00,0.00,0.00,0.00),('1','145','826','257609',4904191,'2358','359',1266169.60,1266169.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257609',4904192,'2359','359',1255791.07,1257045.27,0.00,0.00,1254.20,885586.00,0.00,0.00,0.00),('1','145','826','257610',4904193,'2358','359',1266169.60,1267444.90,0.00,0.00,1275.30,908838.00,0.00,0.00,0.00),('1','145','827','257610',4904194,'2359','359',1257045.27,1257045.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257611',4904195,'2358','359',1267444.90,1267444.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257611',4904196,'2359','359',1257045.27,1257045.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257612',4904197,'2358','359',1267444.90,1269792.20,0.00,0.00,2347.30,1645828.00,0.00,0.00,0.00),('1','145','827','257612',4904198,'2359','359',1257045.27,1257045.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257613',4904199,'2358','359',1269792.20,1272520.40,0.00,0.00,2728.20,1909652.00,0.00,0.00,0.00),('1','145','827','257613',4904200,'2359','359',1257045.27,1257045.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257614',4904201,'2358','359',1272520.40,1276025.90,0.00,0.00,3505.50,2467216.00,0.00,0.00,0.00),('1','145','827','257614',4904202,'2359','359',1257045.27,1257045.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257615',4904203,'2358','359',1276025.90,1277714.40,0.00,0.00,1688.50,1184560.00,0.00,0.00,0.00),('1','145','827','257615',4904204,'2359','359',1257045.27,1257045.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257616',4904205,'2358','359',1277714.40,1280897.20,0.00,0.00,3182.80,2235532.00,0.00,0.00,0.00),('1','145','827','257616',4904206,'2359','359',1257045.27,1257045.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257617',4904207,'2358','359',1280897.20,1283479.20,0.00,0.00,2582.00,1809376.00,0.00,0.00,0.00),('1','145','827','257617',4904208,'2359','359',1257045.27,1257045.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257618',4904209,'2358','359',1283479.20,1285429.60,0.00,0.00,1950.40,1381728.00,0.00,0.00,0.00),('1','145','827','257618',4904210,'2359','359',1257045.27,1257045.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257619',4904211,'2358','359',1285429.60,1286324.60,0.00,0.00,895.00,626832.00,0.00,0.00,0.00),('1','145','827','257619',4904212,'2359','359',1257045.27,1257045.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257620',4904213,'2358','359',1286324.60,1286324.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257620',4904214,'2359','359',1257045.27,1258495.37,0.00,0.00,1450.10,1017860.00,0.00,0.00,0.00),('1','145','826','257621',4904215,'2358','359',1286324.60,1286324.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257621',4904216,'2359','359',1258495.37,1260627.67,0.00,0.00,2132.30,1497168.00,0.00,0.00,0.00),('1','145','826','257622',4904217,'2358','359',1286324.60,1286324.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257622',4904218,'2359','359',1260627.67,1260627.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257623',4904219,'2358','359',1286324.60,1289178.80,0.00,0.00,2854.20,2016740.00,0.00,0.00,0.00),('1','145','827','257623',4904220,'2359','359',1260627.67,1260627.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257624',4904221,'2358','359',1289178.80,1292149.80,0.00,0.00,2971.00,2074744.00,0.00,0.00,0.00),('1','145','827','257624',4904222,'2359','359',1260627.67,1260627.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257625',4904223,'2358','359',1292149.80,1292149.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257625',4904224,'2359','359',1260627.67,1263854.27,0.00,0.00,3226.60,1984030.00,0.00,0.00,0.00),('1','145','826','257626',4904225,'2358','359',1292149.80,1292149.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257626',4904226,'2359','359',1263854.27,1268300.27,0.00,0.00,4446.00,2747590.00,0.00,0.00,0.00),('1','145','826','257627',4904227,'2358','359',1292149.80,1292149.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257627',4904228,'2359','359',1268300.27,1271187.77,0.00,0.00,2887.50,1801214.00,0.00,0.00,0.00),('1','145','826','257628',4904229,'2358','359',1292149.80,1292845.30,0.00,0.00,695.50,459860.00,0.00,0.00,0.00),('1','145','827','257628',4904230,'2359','359',1271187.77,1271187.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257629',4904231,'2358','359',1292845.30,1296127.60,0.00,0.00,3282.30,2180287.00,0.00,0.00,0.00),('1','145','827','257629',4904232,'2359','359',1271187.77,1271187.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257630',4904233,'2358','359',1296127.60,1299462.40,0.00,0.00,3334.80,2220172.00,0.00,0.00,0.00),('1','145','827','257630',4904234,'2359','359',1271187.77,1271187.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257631',4904235,'2358','359',1299462.40,1299462.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257631',4904236,'2359','359',1271187.77,1271187.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257632',4904237,'2358','359',1299462.40,1302556.30,0.00,0.00,3093.90,2083551.00,0.00,0.00,0.00),('1','145','827','257632',4904238,'2359','359',1271187.77,1271187.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257633',4904239,'2358','359',1302556.30,1302556.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257633',4904240,'2359','359',1271187.77,1273218.47,0.00,0.00,2030.70,1345683.00,0.00,0.00,0.00),('1','145','826','257634',4904241,'2358','359',1302556.30,1302556.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257634',4904242,'2359','359',1273218.47,1275951.57,0.00,0.00,2733.10,1830159.00,0.00,0.00,0.00),('1','145','826','257635',4904243,'2358','359',1302556.30,1305339.90,0.00,0.00,2783.60,1850279.00,0.00,0.00,0.00),('1','145','827','257635',4904244,'2359','359',1275951.57,1275951.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257636',4904245,'2358','359',1305339.90,1307931.00,0.00,0.00,2591.10,1724259.00,0.00,0.00,0.00),('1','145','827','257636',4904246,'2359','359',1275951.57,1275951.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257637',4904247,'2358','359',1307931.00,1310212.80,0.00,0.00,2281.80,1524087.00,0.00,0.00,0.00),('1','145','827','257637',4904248,'2359','359',1275951.57,1275951.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257638',4904249,'2358','359',1310212.80,1310813.40,0.00,0.00,600.60,399564.00,0.00,0.00,0.00),('1','145','827','257638',4904250,'2359','359',1275951.57,1275951.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257639',4904251,'2358','359',1310813.40,1310813.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257639',4904252,'2359','359',1275951.57,1277488.87,0.00,0.00,1537.30,1026042.00,0.00,0.00,0.00),('1','145','826','257640',4904253,'2358','359',1310813.40,1310813.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257640',4904254,'2359','359',1277488.87,1280622.27,0.00,0.00,3133.40,2084311.00,0.00,0.00,0.00),('1','145','826','257641',4904255,'2358','359',1310813.40,1310813.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257641',4904256,'2359','359',1280622.27,1282590.07,0.00,0.00,1967.80,1300057.00,0.00,0.00,0.00),('1','145','826','257642',4904257,'2358','359',1310813.40,1310813.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257642',4904258,'2359','359',1282590.07,1282590.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257643',4904259,'2358','359',1310813.40,1313158.70,0.00,0.00,2345.30,1563772.00,0.00,0.00,0.00),('1','145','827','257643',4904260,'2359','359',1282590.07,1282590.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257644',4904261,'2358','359',1313158.70,1315482.10,0.00,0.00,2323.40,1543261.00,0.00,0.00,0.00),('1','145','827','257644',4904262,'2359','359',1282590.07,1282590.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257645',4904263,'2358','359',1315482.10,1315482.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257645',4904264,'2359','359',1282590.07,1285577.87,0.00,0.00,2987.80,1986577.00,0.00,0.00,0.00),('1','145','826','257646',4904265,'2358','359',1315482.10,1315482.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257646',4904266,'2359','359',1285577.87,1288670.87,0.00,0.00,3093.00,2063995.00,0.00,0.00,0.00),('1','145','826','257647',4904267,'2358','359',1315482.10,1315482.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257647',4904268,'2359','359',1288670.87,1291174.77,0.00,0.00,2503.90,1682076.00,0.00,0.00,0.00),('1','145','826','257648',4904269,'2358','359',1315482.10,1315482.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257648',4904270,'2359','359',1291174.77,1294634.87,0.00,0.00,3460.10,2315044.00,0.00,0.00,0.00),('1','145','826','257649',4904271,'2358','359',1315482.10,1315482.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257649',4904272,'2359','359',1294634.87,1295786.17,0.00,0.00,1151.30,753622.00,0.00,0.00,0.00),('1','145','826','257650',4904273,'2358','359',1315482.10,1316038.50,0.00,0.00,556.40,370891.00,0.00,0.00,0.00),('1','145','827','257650',4904274,'2359','359',1295786.17,1295786.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257651',4904275,'2358','359',1316038.50,1317827.90,0.00,0.00,1789.40,1188526.00,0.00,0.00,0.00),('1','145','827','257651',4904276,'2359','359',1295786.17,1295786.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257652',4904277,'2358','359',1317827.90,1317827.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257652',4904278,'2359','359',1295786.17,1295786.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257653',4904279,'2358','359',1317827.90,1317827.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257653',4904280,'2359','359',1295786.17,1298258.77,0.00,0.00,2472.60,1589982.00,0.00,0.00,0.00),('1','145','826','257654',4904281,'2358','359',1317827.90,1317827.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257654',4904282,'2359','359',1298258.77,1301182.87,0.00,0.00,2924.10,1878827.00,0.00,0.00,0.00),('1','145','826','257655',4904283,'2358','359',1317827.90,1320182.20,0.00,0.00,2354.30,1532876.00,0.00,0.00,0.00),('1','145','827','257655',4904284,'2359','359',1301182.87,1301182.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257656',4904285,'2358','359',1320182.20,1323326.70,0.00,0.00,3144.50,2035385.00,0.00,0.00,0.00),('1','145','827','257656',4904286,'2359','359',1301182.87,1301182.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257657',4904287,'2358','359',1323326.70,1326921.20,0.00,0.00,3594.50,2344830.00,0.00,0.00,0.00),('1','145','827','257657',4904288,'2359','359',1301182.87,1301182.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257658',4904289,'2358','359',1326921.20,1328834.50,0.00,0.00,1913.30,1230021.00,0.00,0.00,0.00),('1','145','827','257658',4904290,'2359','359',1301182.87,1301182.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257659',4904291,'2358','359',1328834.50,1332122.70,0.00,0.00,3288.20,2081489.00,0.00,0.00,0.00),('1','145','827','257659',4904292,'2359','359',1301182.87,1301182.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257660',4904293,'2358','359',1332122.70,1334926.70,0.00,0.00,2804.00,1800995.00,0.00,0.00,0.00),('1','145','827','257660',4904294,'2359','359',1301182.87,1301182.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257661',4904295,'2358','359',1334926.70,1334926.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257661',4904296,'2359','359',1301182.87,1304997.87,0.00,0.00,3815.00,2416820.00,0.00,0.00,0.00),('1','145','826','257662',4904297,'2358','359',1334926.70,1334926.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257662',4904298,'2359','359',1304997.87,1304997.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257663',4904299,'2358','359',1334926.70,1338049.90,0.00,0.00,3123.20,2008059.00,0.00,0.00,0.00),('1','145','827','257663',4904300,'2359','359',1304997.87,1304997.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257664',4904301,'2358','359',1338049.90,1338049.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257664',4904302,'2359','359',1304997.87,1307761.77,0.00,0.00,2763.90,1779233.00,0.00,0.00,0.00),('1','145','826','257665',4904303,'2358','359',1338049.90,1338049.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257665',4904304,'2359','359',1307761.77,1311290.47,0.00,0.00,3528.70,2417092.00,0.00,0.00,0.00),('1','145','826','257666',4904305,'2358','359',1338049.90,1338049.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257666',4904306,'2359','359',1311290.47,1313607.67,0.00,0.00,2317.20,1574427.00,0.00,0.00,0.00),('1','145','826','257667',4904307,'2358','359',1338049.90,1338049.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257667',4904308,'2359','359',1313607.67,1316307.37,0.00,0.00,2699.70,1847282.00,0.00,0.00,0.00),('1','145','826','257668',4904309,'2358','359',1338049.90,1338049.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257668',4904310,'2359','359',1316307.37,1319002.17,0.00,0.00,2694.80,1851438.00,0.00,0.00,0.00),('1','145','826','257669',4904311,'2358','359',1338049.90,1338049.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257669',4904312,'2359','359',1319002.17,1320125.67,0.00,0.00,1123.50,772575.00,0.00,0.00,0.00),('1','145','826','257670',4904313,'2358','359',1338049.90,1338049.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257670',4904314,'2359','359',1320125.67,1320402.17,0.00,0.00,276.50,183215.00,0.00,0.00,0.00),('1','145','826','257671',4904315,'2358','359',1338049.90,1339470.80,0.00,0.00,1420.90,971364.00,0.00,0.00,0.00),('1','145','827','257671',4904316,'2359','359',1320402.17,1320402.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257672',4904317,'2358','359',1339470.80,1341772.70,0.00,0.00,2301.90,1592479.00,0.00,0.00,0.00),('1','145','827','257672',4904318,'2359','359',1320402.17,1320402.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257673',4904319,'2358','359',1341772.70,1345328.30,0.00,0.00,3555.60,2445066.00,0.00,0.00,0.00),('1','145','827','257673',4904320,'2359','359',1320402.17,1320402.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257674',4904321,'2358','359',1345328.30,1348555.90,0.00,0.00,3227.60,2214186.00,0.00,0.00,0.00),('1','145','827','257674',4904322,'2359','359',1320402.17,1320402.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257675',4904323,'2358','359',1348555.90,1350923.20,0.00,0.00,2367.30,1581418.00,0.00,0.00,0.00),('1','145','827','257675',4904324,'2359','359',1320402.17,1320402.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257676',4904325,'2358','359',1350923.20,1353192.20,0.00,0.00,2269.00,1630956.00,0.00,0.00,0.00),('1','145','827','257676',4904326,'2359','359',1320402.17,1320402.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257677',4904327,'2358','359',1353192.20,1356574.29,0.00,0.00,3382.09,2568621.00,0.00,0.00,0.00),('1','145','827','257677',4904328,'2359','359',1320402.17,1320402.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257678',4904329,'2358','359',1356574.29,1358989.85,0.00,0.00,2415.56,1844020.80,0.00,0.00,0.00),('1','145','827','257678',4904330,'2359','359',1320402.17,1320402.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257679',4904331,'2358','359',1358989.85,1358989.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257679',4904332,'2359','359',1320402.17,1320583.11,0.00,0.00,180.94,138933.20,0.00,0.00,0.00),('1','145','826','257680',4904333,'2358','359',1358989.85,1358989.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257680',4904334,'2359','359',1320583.11,1323249.91,0.00,0.00,2666.80,2036213.20,0.00,0.00,0.00),('1','145','826','257681',4904335,'2358','359',1358989.85,1358989.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257681',4904336,'2359','359',1323249.91,1323249.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257682',4904337,'2358','359',1358989.85,1358989.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257682',4904338,'2359','359',1323249.91,1326274.60,0.00,0.00,3024.69,2315630.20,0.00,0.00,0.00),('1','145','826','257683',4904339,'2358','359',1358989.85,1358989.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257683',4904340,'2359','359',1326274.60,1328300.35,0.00,0.00,2025.75,1539644.20,0.00,0.00,0.00),('1','145','826','257684',4904341,'2358','359',1358989.85,1358989.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257684',4904342,'2359','359',1328300.35,1331969.56,0.00,0.00,3669.21,2785830.20,0.00,0.00,0.00),('1','145','826','257685',4904343,'2358','359',1358989.85,1358989.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257685',4904344,'2359','359',1331969.56,1334759.93,0.00,0.00,2790.37,2134067.80,0.00,0.00,0.00),('1','145','826','257686',4904345,'2358','359',1358989.85,1358989.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257686',4904346,'2359','359',1334759.93,1338588.65,0.00,0.00,3828.72,2912854.80,0.00,0.00,0.00),('1','145','826','257687',4904347,'2358','359',1358989.85,1358989.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257687',4904348,'2359','359',1338588.65,1342114.53,0.00,0.00,3525.88,2690786.40,0.00,0.00,0.00),('1','145','826','257688',4904349,'2358','359',1358989.85,1358989.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257688',4904350,'2359','359',1342114.53,1344629.06,0.00,0.00,2514.53,1913831.00,0.00,0.00,0.00),('1','145','826','257689',4904351,'2358','359',1358989.85,1358989.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257689',4904352,'2359','359',1344629.06,1345071.03,0.00,0.00,441.97,333134.60,0.00,0.00,0.00),('1','145','826','257690',4904353,'2358','359',1358989.85,1363215.76,0.00,0.00,4225.91,3214405.00,0.00,0.00,0.00),('1','145','827','257690',4904354,'2359','359',1345071.03,1345071.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257691',4904355,'2358','359',1363215.76,1363215.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257691',4904356,'2359','359',1345071.03,1345071.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257692',4904357,'2358','359',1363215.76,1365140.83,0.00,0.00,1925.07,1466624.60,0.00,0.00,0.00),('1','145','827','257692',4904358,'2359','359',1345071.03,1345071.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257693',4904359,'2358','359',1365140.83,1368310.49,0.00,0.00,3169.66,2408367.60,0.00,0.00,0.00),('1','145','827','257693',4904360,'2359','359',1345071.03,1345071.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257694',4904361,'2358','359',1368310.49,1371083.75,0.00,0.00,2773.26,2112306.80,0.00,0.00,0.00),('1','145','827','257694',4904362,'2359','359',1345071.03,1345071.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257695',4904363,'2358','359',1371083.75,1373514.91,0.00,0.00,2431.16,1860965.60,0.00,0.00,0.00),('1','145','827','257695',4904364,'2359','359',1345071.03,1345071.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257696',4904365,'2358','359',1373514.91,1376634.34,0.00,0.00,3119.43,2379847.80,0.00,0.00,0.00),('1','145','827','257696',4904366,'2359','359',1345071.03,1345071.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257697',4904367,'2358','359',1376634.34,1379455.78,0.00,0.00,2821.44,2148609.60,0.00,0.00,0.00),('1','145','827','257697',4904368,'2359','359',1345071.03,1345071.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257698',4904369,'2358','359',1379455.78,1383298.89,0.00,0.00,3843.11,2930421.80,0.00,0.00,0.00),('1','145','827','257698',4904370,'2359','359',1345071.03,1345071.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257699',4904371,'2358','359',1383298.89,1383639.08,0.00,0.00,340.19,256339.00,0.00,0.00,0.00),('1','145','827','257699',4904372,'2359','359',1345071.03,1345071.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257700',4904373,'2358','359',1383639.08,1383639.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257700',4904374,'2359','359',1345071.03,1345071.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257701',4904375,'2358','359',1383639.08,1383639.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257701',4904376,'2359','359',1345071.03,1346536.18,0.00,0.00,1465.15,1112153.00,0.00,0.00,0.00),('1','145','826','257702',4904377,'2358','359',1383639.08,1383639.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257702',4904378,'2359','359',1346536.18,1349795.96,0.00,0.00,3259.78,2488411.20,0.00,0.00,0.00),('1','145','826','257703',4904379,'2358','359',1383639.08,1383639.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257703',4904380,'2359','359',1349795.96,1352115.35,0.00,0.00,2319.39,1760427.80,0.00,0.00,0.00),('1','145','826','257704',4904381,'2358','359',1383639.08,1383639.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257704',4904382,'2359','359',1352115.35,1353995.45,0.00,0.00,1880.10,1438594.00,0.00,0.00,0.00),('1','145','826','257705',4904383,'2358','359',1383639.08,1383639.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257705',4904384,'2359','359',1353995.45,1356408.15,0.00,0.00,2412.70,1847922.40,0.00,0.00,0.00),('1','145','826','257706',4904385,'2358','359',1383639.08,1383639.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257706',4904386,'2359','359',1356408.15,1359655.13,0.00,0.00,3246.98,2466647.20,0.00,0.00,0.00),('1','145','826','257707',4904387,'2358','359',1383639.08,1383639.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257707',4904388,'2359','359',1359655.13,1363335.76,0.00,0.00,3680.63,2806026.60,0.00,0.00,0.00),('1','145','826','257708',4904389,'2358','359',1383639.08,1383639.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257708',4904390,'2359','359',1363335.76,1365426.55,0.00,0.00,2090.79,1586592.60,0.00,0.00,0.00),('1','145','826','257709',4904391,'2358','359',1383639.08,1383639.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257709',4904392,'2359','359',1365426.55,1368054.29,0.00,0.00,2627.74,1998454.80,0.00,0.00,0.00),('1','145','826','257710',4904393,'2358','359',1383639.08,1383639.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257710',4904394,'2359','359',1368054.29,1368054.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257711',4904395,'2358','359',1383639.08,1383639.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257711',4904396,'2359','359',1368054.29,1369644.22,0.00,0.00,1589.93,1207222.60,0.00,0.00,0.00),('1','145','826','257712',4904397,'2358','359',1383639.08,1383639.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257712',4904398,'2359','359',1369644.22,1369644.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257713',4904399,'2358','359',1383639.08,1384759.51,0.00,0.00,1120.43,855891.80,0.00,0.00,0.00),('1','145','827','257713',4904400,'2359','359',1369644.22,1369644.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257714',4904401,'2358','359',1384759.51,1386694.96,0.00,0.00,1935.45,1473412.60,0.00,0.00,0.00),('1','145','827','257714',4904402,'2359','359',1369644.22,1369644.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257715',4904403,'2358','359',1386694.96,1389976.49,0.00,0.00,3281.53,2511465.80,0.00,0.00,0.00),('1','145','827','257715',4904404,'2359','359',1369644.22,1369644.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257716',4904405,'2358','359',1389976.49,1392121.87,0.00,0.00,2145.38,1623877.20,0.00,0.00,0.00),('1','145','827','257716',4904406,'2359','359',1369644.22,1369644.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257717',4904407,'2358','359',1392121.87,1394362.66,0.00,0.00,2240.79,1722848.60,0.00,0.00,0.00),('1','145','827','257717',4904408,'2359','359',1369644.22,1369644.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257718',4904409,'2358','359',1394362.66,1396727.62,0.00,0.00,2364.96,1815794.80,0.00,0.00,0.00),('1','145','827','257718',4904410,'2359','359',1369644.22,1369644.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257719',4904411,'2358','359',1396727.62,1399529.90,0.00,0.00,2802.28,2140130.40,0.00,0.00,0.00),('1','145','827','257719',4904412,'2359','359',1369644.22,1369644.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257720',4904413,'2358','359',1399529.90,1399822.59,0.00,0.00,292.69,226698.20,0.00,0.00,0.00),('1','145','827','257720',4904414,'2359','359',1369644.22,1369644.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257721',4904415,'2358','359',1399822.59,1399822.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257721',4904416,'2359','359',1369644.22,1369644.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257722',4904417,'2358','359',1399822.59,1399822.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257722',4904418,'2359','359',1369644.22,1372119.74,0.00,0.00,2475.52,1889794.80,0.00,0.00,0.00),('1','145','826','257723',4904419,'2358','359',1399822.59,1399822.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257723',4904420,'2359','359',1372119.74,1374365.62,0.00,0.00,2245.88,1733561.60,0.00,0.00,0.00),('1','145','826','257724',4904421,'2358','359',1399822.59,1399822.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257724',4904422,'2359','359',1374365.62,1377916.71,0.00,0.00,3551.09,2723395.40,0.00,0.00,0.00),('1','145','826','257725',4904423,'2358','359',1399822.59,1399822.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257725',4904424,'2359','359',1377916.71,1379629.61,0.00,0.00,1712.90,1310247.20,0.00,0.00,0.00),('1','145','826','257726',4904425,'2358','359',1399822.59,1399822.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257726',4904426,'2359','359',1379629.61,1382271.89,0.00,0.00,2642.28,2035130.00,0.00,0.00,0.00),('1','145','826','257727',4904427,'2358','359',1399822.59,1399822.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257727',4904428,'2359','359',1382271.89,1384404.71,0.00,0.00,2132.82,1626770.40,0.00,0.00,0.00),('1','145','826','257728',4904429,'2358','359',1399822.59,1399822.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257728',4904430,'2359','359',1384404.71,1384404.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257729',4904431,'2358','359',1399822.59,1402055.17,0.00,0.00,2232.58,1720272.00,0.00,0.00,0.00),('1','145','827','257729',4904432,'2359','359',1384404.71,1384404.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257730',4904433,'2358','359',1402055.17,1403589.55,0.00,0.00,1534.38,1165024.40,0.00,0.00,0.00),('1','145','827','257730',4904434,'2359','359',1384404.71,1384404.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257731',4904435,'2358','359',1403589.55,1406512.78,0.00,0.00,2923.23,2240953.80,0.00,0.00,0.00),('1','145','827','257731',4904436,'2359','359',1384404.71,1384404.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257732',4904437,'2358','359',1406512.78,1409139.15,0.00,0.00,2626.37,2018134.20,0.00,0.00,0.00),('1','145','827','257732',4904438,'2359','359',1384404.71,1384404.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257733',4904439,'2358','359',1409139.15,1411413.30,0.00,0.00,2274.15,1735942.60,0.00,0.00,0.00),('1','145','827','257733',4904440,'2359','359',1384404.71,1384404.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257734',4904441,'2358','359',1411413.30,1413731.31,0.00,0.00,2318.01,1769384.20,0.00,0.00,0.00),('1','145','827','257734',4904442,'2359','359',1384404.71,1384404.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257735',4904443,'2358','359',1413731.31,1415841.76,0.00,0.00,2110.45,1617510.20,0.00,0.00,0.00),('1','145','827','257735',4904444,'2359','359',1384404.71,1384404.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257736',4904445,'2358','359',1415841.76,1418643.92,0.00,0.00,2802.16,2148194.00,0.00,0.00,0.00),('1','145','827','257736',4904446,'2359','359',1384404.71,1384404.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257737',4904447,'2358','359',1418643.92,1420448.00,0.00,0.00,1804.08,1368884.00,0.00,0.00,0.00),('1','145','827','257737',4904448,'2359','359',1384404.71,1384404.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257738',4904449,'2358','359',1420448.00,1422636.92,0.00,0.00,2188.92,1669530.00,0.00,0.00,0.00),('1','145','827','257738',4904450,'2359','359',1384404.71,1384404.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257739',4904451,'2358','359',1422636.92,1423273.50,0.00,0.00,636.58,485704.00,0.00,0.00,0.00),('1','145','827','257739',4904452,'2359','359',1384404.71,1384404.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257740',4904453,'2358','359',1423273.50,1423273.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257740',4904454,'2359','359',1384404.71,1385869.12,0.00,0.00,1464.41,1114597.00,0.00,0.00,0.00),('1','145','826','257741',4904455,'2358','359',1423273.50,1423273.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257741',4904456,'2359','359',1385869.12,1387532.43,0.00,0.00,1663.31,1279746.20,0.00,0.00,0.00),('1','145','826','257742',4904457,'2358','359',1423273.50,1423273.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257742',4904458,'2359','359',1387532.43,1389632.56,0.00,0.00,2100.13,1578974.60,0.00,0.00,0.00),('1','145','826','257743',4904459,'2358','359',1423273.50,1423286.50,0.00,0.00,13.00,10010.00,0.00,0.00,0.00),('1','145','827','257743',4904460,'2359','359',1389632.56,1391806.34,0.00,0.00,2173.78,1630911.10,0.00,0.00,0.00),('1','145','826','257744',4904461,'2358','359',1423286.50,1423286.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257744',4904462,'2359','359',1391806.34,1391806.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257745',4904463,'2358','359',1423286.50,1423286.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257745',4904464,'2359','359',1391806.34,1395113.27,0.00,0.00,3306.93,2479382.10,0.00,0.00,0.00),('1','145','826','257746',4904465,'2358','359',1423286.50,1423286.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257746',4904466,'2359','359',1395113.27,1397911.19,0.00,0.00,2797.92,2102586.90,0.00,0.00,0.00),('1','145','826','257747',4904467,'2358','359',1423286.50,1424471.89,0.00,0.00,1185.39,886800.30,0.00,0.00,0.00),('1','145','827','257747',4904468,'2359','359',1397911.19,1397911.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257748',4904469,'2358','359',1424471.89,1427477.71,0.00,0.00,3005.82,2234393.90,0.00,0.00,0.00),('1','145','827','257748',4904470,'2359','359',1397911.19,1397911.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257749',4904471,'2358','359',1427477.71,1430035.53,0.00,0.00,2557.82,1920169.40,0.00,0.00,0.00),('1','145','827','257749',4904472,'2359','359',1397911.19,1397911.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257750',4904473,'2358','359',1430035.53,1432507.00,0.00,0.00,2471.47,1854136.40,0.00,0.00,0.00),('1','145','827','257750',4904474,'2359','359',1397911.19,1397911.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257751',4904475,'2358','359',1432507.00,1432507.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257751',4904476,'2359','359',1397911.19,1397911.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257752',4904477,'2358','359',1432507.00,1432507.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257752',4904478,'2359','359',1397911.19,1402109.19,0.00,0.00,4198.00,3141559.00,0.00,0.00,0.00),('1','145','826','257753',4904479,'2358','359',1432507.00,1432507.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257753',4904480,'2359','359',1402109.19,1404825.17,0.00,0.00,2715.98,2014743.60,0.00,0.00,0.00),('1','145','826','257754',4904481,'2358','359',1432507.00,1432507.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257754',4904482,'2359','359',1404825.17,1408401.79,0.00,0.00,3576.62,2669773.40,0.00,0.00,0.00),('1','145','826','257755',4904483,'2358','359',1432507.00,1432507.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257755',4904484,'2359','359',1408401.79,1411183.19,0.00,0.00,2781.40,2066085.50,0.00,0.00,0.00),('1','145','826','257756',4904485,'2358','359',1432507.00,1433518.91,0.00,0.00,1011.91,747290.20,0.00,0.00,0.00),('1','145','827','257756',4904486,'2359','359',1411183.19,1411183.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257757',4904487,'2358','359',1433518.91,1438928.60,0.00,0.00,5409.69,3982249.80,0.00,0.00,0.00),('1','145','827','257757',4904488,'2359','359',1411183.19,1411183.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257758',4904489,'2358','359',1438928.60,1442352.29,0.00,0.00,3423.69,2534751.30,0.00,0.00,0.00),('1','145','827','257758',4904490,'2359','359',1411183.19,1411183.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257759',4904491,'2358','359',1442352.29,1445022.55,0.00,0.00,2670.26,1997817.20,0.00,0.00,0.00),('1','145','827','257759',4904492,'2359','359',1411183.19,1411183.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257760',4904493,'2358','359',1445022.55,1445486.98,0.00,0.00,464.43,349111.10,0.00,0.00,0.00),('1','145','827','257760',4904494,'2359','359',1411183.19,1411183.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257761',4904495,'2358','359',1445486.98,1445486.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257761',4904496,'2359','359',1411183.19,1411183.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257762',4904497,'2358','359',1445486.98,1445486.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257762',4904498,'2359','359',1411183.19,1413413.89,0.00,0.00,2230.70,1662650.50,0.00,0.00,0.00),('1','145','826','257763',4904499,'2358','359',1445486.98,1445486.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257763',4904500,'2359','359',1413413.89,1418294.65,0.00,0.00,4880.76,3592725.70,0.00,0.00,0.00),('1','145','826','257764',4904501,'2358','359',1445486.98,1445486.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257764',4904502,'2359','359',1418294.65,1421074.16,0.00,0.00,2779.51,2055646.20,0.00,0.00,0.00),('1','145','826','257765',4904503,'2358','359',1445486.98,1445486.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257765',4904504,'2359','359',1421074.16,1421074.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257766',4904505,'2358','359',1445486.98,1445486.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257766',4904506,'2359','359',1421074.16,1421318.14,0.00,0.00,243.98,182064.60,0.00,0.00,0.00),('1','145','826','257767',4904507,'2358','359',1445486.98,1446958.02,0.00,0.00,1471.04,1088588.30,0.00,0.00,0.00),('1','145','827','257767',4904508,'2359','359',1421318.14,1421318.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257768',4904509,'2358','359',1446958.02,1454085.65,0.00,0.00,7127.63,5210321.60,0.00,0.00,0.00),('1','145','827','257768',4904510,'2359','359',1421318.14,1421318.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257769',4904511,'2358','359',1454085.65,1461383.44,0.00,0.00,7297.79,5473457.10,0.00,0.00,0.00),('1','145','827','257769',4904512,'2359','359',1421318.14,1421318.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257770',4904513,'2358','359',1461383.44,1462836.73,0.00,0.00,1453.29,1086465.60,0.00,0.00,0.00),('1','145','827','257770',4904514,'2359','359',1421318.14,1421318.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257771',4904515,'2358','359',1462836.73,1462836.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257771',4904516,'2359','359',1421318.14,1424061.16,0.00,0.00,2743.02,2067698.80,0.00,0.00,0.00),('1','145','826','257772',4904517,'2358','359',1462836.73,1462836.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257772',4904518,'2359','359',1424061.16,1429470.77,0.00,0.00,5409.61,4080047.90,0.00,0.00,0.00),('1','145','826','257773',4904519,'2358','359',1462836.73,1462836.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257773',4904520,'2359','359',1429470.77,1432939.01,0.00,0.00,3468.24,2644475.60,0.00,0.00,0.00),('1','145','826','257774',4904521,'2358','359',1462836.73,1462836.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257774',4904522,'2359','359',1432939.01,1436841.55,0.00,0.00,3902.54,2957734.60,0.00,0.00,0.00),('1','145','826','257775',4904523,'2358','359',1462836.73,1462836.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257775',4904524,'2359','359',1436841.55,1438851.34,0.00,0.00,2009.79,1555163.60,0.00,0.00,0.00),('1','145','826','257776',4904525,'2358','359',1462836.73,1462836.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257776',4904526,'2359','359',1438851.34,1438851.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257777',4904527,'2358','359',1462836.73,1462836.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257777',4904528,'2359','359',1438851.34,1440549.33,0.00,0.00,1697.99,1319162.10,0.00,0.00,0.00),('1','145','826','257778',4904529,'2358','359',1462836.73,1462836.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257778',4904530,'2359','359',1440549.33,1441238.34,0.00,0.00,689.01,519534.60,0.00,0.00,0.00),('1','145','826','257779',4904531,'2358','359',1462836.73,1464724.14,0.00,0.00,1887.41,1435293.08,0.00,0.00,0.00),('1','145','827','257779',4904532,'2359','359',1441238.34,1441238.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257780',4904533,'2358','359',1464724.14,1467066.72,0.00,0.00,2342.58,1746042.48,0.00,0.00,0.00),('1','145','827','257780',4904534,'2359','359',1441238.34,1441238.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257781',4904535,'2358','359',1467066.72,1467066.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257781',4904536,'2359','359',1441238.34,1441238.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257782',4904537,'2358','359',1467066.72,1469428.93,0.00,0.00,2362.21,1792374.48,0.00,0.00,0.00),('1','145','827','257782',4904538,'2359','359',1441238.34,1441238.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257783',4904539,'2358','359',1469428.93,1472233.46,0.00,0.00,2804.53,2121632.76,0.00,0.00,0.00),('1','145','827','257783',4904540,'2359','359',1441238.34,1441238.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257784',4904541,'2358','359',1472233.46,1474494.27,0.00,0.00,2260.81,1716973.96,0.00,0.00,0.00),('1','145','827','257784',4904542,'2359','359',1441238.34,1441238.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257785',4904543,'2358','359',1474494.27,1476438.65,0.00,0.00,1944.38,1481407.20,0.00,0.00,0.00),('1','145','827','257785',4904544,'2359','359',1441238.34,1441238.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257786',4904545,'2358','359',1476438.65,1478857.77,0.00,0.00,2419.12,1833697.32,0.00,0.00,0.00),('1','145','827','257786',4904546,'2359','359',1441238.34,1441238.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257787',4904547,'2358','359',1478857.77,1481694.11,0.00,0.00,2836.34,2170915.24,0.00,0.00,0.00),('1','145','827','257787',4904548,'2359','359',1441238.34,1441238.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257788',4904549,'2358','359',1481694.11,1482892.33,0.00,0.00,1198.22,904008.04,0.00,0.00,0.00),('1','145','827','257788',4904550,'2359','359',1441238.34,1441238.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257789',4904551,'2358','359',1482892.33,1482892.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257789',4904552,'2359','359',1441238.34,1441238.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257790',4904553,'2358','359',1482892.33,1482892.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257790',4904554,'2359','359',1441238.34,1442179.43,0.00,0.00,941.09,705253.64,0.00,0.00,0.00),('1','145','826','257791',4904555,'2358','359',1482892.33,1482892.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257791',4904556,'2359','359',1442179.43,1445148.28,0.00,0.00,2968.85,2239371.68,0.00,0.00,0.00),('1','145','826','257792',4904557,'2358','359',1482892.33,1482892.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257792',4904558,'2359','359',1445148.28,1448231.30,0.00,0.00,3083.02,2337361.00,0.00,0.00,0.00),('1','145','826','257793',4904559,'2358','359',1482892.33,1482892.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257793',4904560,'2359','359',1448231.30,1449897.84,0.00,0.00,1666.54,1262850.16,0.00,0.00,0.00),('1','145','826','257794',4904561,'2358','359',1482892.33,1482892.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257794',4904562,'2359','359',1449897.84,1452432.93,0.00,0.00,2535.09,1909345.88,0.00,0.00,0.00),('1','145','826','257795',4904563,'2358','359',1482892.33,1482892.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257795',4904564,'2359','359',1452432.93,1456933.74,0.00,0.00,4500.81,3374516.60,0.00,0.00,0.00),('1','145','826','257796',4904565,'2358','359',1482892.33,1482892.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257796',4904566,'2359','359',1456933.74,1458546.00,0.00,0.00,1612.26,1207589.76,0.00,0.00,0.00),('1','145','826','257797',4904567,'2358','359',1482892.33,1490148.93,0.00,0.00,7256.60,5383463.28,0.00,0.00,0.00),('1','145','827','257797',4904568,'2359','359',1458546.00,1458546.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257798',4904569,'2358','359',1490148.93,1491767.66,0.00,0.00,1618.73,1200945.20,0.00,0.00,0.00),('1','145','827','257798',4904570,'2359','359',1458546.00,1458546.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257799',4904571,'2358','359',1491767.66,1491767.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257799',4904572,'2359','359',1458546.00,1458546.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257800',4904573,'2358','359',1491767.66,1491767.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257800',4904574,'2359','359',1458546.00,1458546.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257801',4904575,'2358','359',1491767.66,1491767.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257801',4904576,'2359','359',1458546.00,1467717.85,0.00,0.00,9171.85,6797601.84,0.00,0.00,0.00),('1','145','826','257802',4904577,'2358','359',1491767.66,1491767.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257802',4904578,'2359','359',1467717.85,1470142.35,0.00,0.00,2424.50,1801983.56,0.00,0.00,0.00),('1','145','826','257803',4904579,'2358','359',1491767.66,1491767.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257803',4904580,'2359','359',1470142.35,1470142.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257804',4904581,'2358','359',1491767.66,1495668.13,0.00,0.00,3900.47,2918341.92,0.00,0.00,0.00),('1','145','827','257804',4904582,'2359','359',1470142.35,1470142.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257805',4904583,'2358','359',1495668.13,1503301.57,0.00,0.00,7633.44,5690544.08,0.00,0.00,0.00),('1','145','827','257805',4904584,'2359','359',1470142.35,1470142.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257806',4904585,'2358','359',1503301.57,1508914.62,0.00,0.00,5613.05,4164407.00,0.00,0.00,0.00),('1','145','827','257806',4904586,'2359','359',1470142.35,1470142.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257807',4904587,'2358','359',1508914.62,1510624.97,0.00,0.00,1710.35,1261622.96,0.00,0.00,0.00),('1','145','827','257807',4904588,'2359','359',1470142.35,1470142.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257808',4904589,'2358','359',1510624.97,1510624.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257808',4904590,'2359','359',1470142.35,1470142.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257809',4904591,'2358','359',1510624.97,1510624.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257809',4904592,'2359','359',1470142.35,1479718.96,0.00,0.00,9576.61,6982952.20,0.00,0.00,0.00),('1','145','826','257810',4904593,'2358','359',1510624.97,1510624.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257810',4904594,'2359','359',1479718.96,1489155.32,0.00,0.00,9436.36,6929892.70,0.00,0.00,0.00),('1','145','826','257811',4904595,'2358','359',1510624.97,1517269.52,0.00,0.00,6644.55,4887290.50,0.00,0.00,0.00),('1','145','827','257811',4904596,'2359','359',1489155.32,1489155.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257812',4904597,'2358','359',1517269.52,1517269.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257812',4904598,'2359','359',1489155.32,1489155.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257813',4904599,'2358','359',1517269.52,1521294.67,0.00,0.00,4025.15,2959673.50,0.00,0.00,0.00),('1','145','827','257813',4904600,'2359','359',1489155.32,1489155.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257814',4904601,'2358','359',1521294.67,1527600.30,0.00,0.00,6305.63,4638061.10,0.00,0.00,0.00),('1','145','827','257814',4904602,'2359','359',1489155.32,1489155.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257815',4904603,'2358','359',1527600.30,1532889.29,0.00,0.00,5288.99,3909759.30,0.00,0.00,0.00),('1','145','827','257815',4904604,'2359','359',1489155.32,1489155.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257816',4904605,'2358','359',1532889.29,1536656.02,0.00,0.00,3766.73,2799180.60,0.00,0.00,0.00),('1','145','827','257816',4904606,'2359','359',1489155.32,1489155.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257817',4904607,'2358','359',1536656.02,1540014.57,0.00,0.00,3358.55,2485342.50,0.00,0.00,0.00),('1','145','827','257817',4904608,'2359','359',1489155.32,1489155.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257818',4904609,'2358','359',1540014.57,1541715.53,0.00,0.00,1700.96,1268689.20,0.00,0.00,0.00),('1','145','827','257818',4904610,'2359','359',1489155.32,1489155.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257819',4904611,'2358','359',1541715.53,1541715.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257819',4904612,'2359','359',1489155.32,1490350.00,0.00,0.00,1194.68,892246.60,0.00,0.00,0.00),('1','145','826','257820',4904613,'2358','359',1541715.53,1541715.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257820',4904614,'2359','359',1490350.00,1494150.55,0.00,0.00,3800.55,2829908.00,0.00,0.00,0.00),('1','145','826','257821',4904615,'2358','359',1541715.53,1541715.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257821',4904616,'2359','359',1494150.55,1496550.21,0.00,0.00,2399.66,1774176.70,0.00,0.00,0.00),('1','145','826','257822',4904617,'2358','359',1541715.53,1541715.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257822',4904618,'2359','359',1496550.21,1499476.08,0.00,0.00,2925.87,2189060.40,0.00,0.00,0.00),('1','145','826','257823',4904619,'2358','359',1541715.53,1541715.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257823',4904620,'2359','359',1499476.08,1501974.99,0.00,0.00,2498.91,1885419.70,0.00,0.00,0.00),('1','145','826','257824',4904621,'2358','359',1541715.53,1541715.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257824',4904622,'2359','359',1501974.99,1504319.00,0.00,0.00,2344.01,1761788.70,0.00,0.00,0.00),('1','145','826','257825',4904623,'2358','359',1541715.53,1541715.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257825',4904624,'2359','359',1504319.00,1507897.79,0.00,0.00,3578.79,2591299.50,0.00,0.00,0.00),('1','145','826','257826',4904625,'2358','359',1541715.53,1541715.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257826',4904626,'2359','359',1507897.79,1511767.77,0.00,0.00,3869.98,2792060.00,0.00,0.00,0.00),('1','145','826','257827',4904627,'2358','359',1541715.53,1541715.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257827',4904628,'2359','359',1511767.77,1512630.15,0.00,0.00,862.38,628137.00,0.00,0.00,0.00),('1','145','826','257828',4904629,'2358','359',1541715.53,1541715.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257828',4904630,'2359','359',1512630.15,1512630.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257829',4904631,'2358','359',1541715.53,1547573.29,0.00,0.00,5857.76,4217126.00,0.00,0.00,0.00),('1','145','827','257829',4904632,'2359','359',1512630.15,1512630.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257830',4904633,'2358','359',1547573.29,1550310.89,0.00,0.00,2737.60,1991443.00,0.00,0.00,0.00),('1','145','827','257830',4904634,'2359','359',1512630.15,1512630.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257831',4904635,'2358','359',1550310.89,1552712.93,0.00,0.00,2402.04,1755055.00,0.00,0.00,0.00),('1','145','827','257831',4904636,'2359','359',1512630.15,1512630.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257832',4904637,'2358','359',1552712.93,1554993.79,0.00,0.00,2280.86,1662391.00,0.00,0.00,0.00),('1','145','827','257832',4904638,'2359','359',1512630.15,1512633.15,0.00,0.00,3.00,2250.00,0.00,0.00,0.00),('1','145','826','257833',4904639,'2358','359',1554993.79,1557600.68,0.00,0.00,2606.89,1902867.00,0.00,0.00,0.00),('1','145','827','257833',4904640,'2359','359',1512633.15,1512633.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257834',4904641,'2358','359',1557600.68,1561025.87,0.00,0.00,3425.19,2501704.50,0.00,0.00,0.00),('1','145','827','257834',4904642,'2359','359',1512633.15,1512633.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257835',4904643,'2358','359',1561025.87,1561025.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257835',4904644,'2359','359',1512633.15,1512633.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257836',4904645,'2358','359',1561025.87,1562691.44,0.00,0.00,1665.57,1209889.00,0.00,0.00,0.00),('1','145','827','257836',4904646,'2359','359',1512633.15,1512633.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257837',4904647,'2358','359',1562691.44,1565296.02,0.00,0.00,2604.58,1909172.50,0.00,0.00,0.00),('1','145','827','257837',4904648,'2359','359',1512633.15,1512633.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257838',4904649,'2358','359',1565296.02,1566181.46,0.00,0.00,885.44,650611.50,0.00,0.00,0.00),('1','145','827','257838',4904650,'2359','359',1512633.15,1512633.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257839',4904651,'2358','359',1566181.46,1566181.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257839',4904652,'2359','359',1512633.15,1514052.34,0.00,0.00,1419.19,999170.40,0.00,0.00,0.00),('1','145','826','257840',4904653,'2358','359',1566181.46,1566181.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257840',4904654,'2359','359',1514052.34,1514052.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257841',4904655,'2358','359',1566181.46,1566181.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257841',4904656,'2359','359',1514052.34,1517163.62,0.00,0.00,3111.28,2178898.80,0.00,0.00,0.00),('1','145','826','257842',4904657,'2358','359',1566181.46,1566181.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257842',4904658,'2359','359',1517163.62,1520289.71,0.00,0.00,3126.09,2184612.00,0.00,0.00,0.00),('1','145','826','257843',4904659,'2358','359',1566181.46,1566181.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257843',4904660,'2359','359',1520289.71,1522494.67,0.00,0.00,2204.96,1542206.40,0.00,0.00,0.00),('1','145','826','257844',4904661,'2358','359',1566181.46,1566181.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257844',4904662,'2359','359',1522494.67,1525172.24,0.00,0.00,2677.57,1863046.00,0.00,0.00,0.00),('1','145','826','257845',4904663,'2358','359',1566181.46,1566181.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257845',4904664,'2359','359',1525172.24,1526199.11,0.00,0.00,1026.87,717256.80,0.00,0.00,0.00),('1','145','826','257846',4904665,'2358','359',1566181.46,1566181.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257846',4904666,'2359','359',1526199.11,1529811.00,0.00,0.00,3611.89,2514552.80,0.00,0.00,0.00),('1','145','826','257847',4904667,'2358','359',1566181.46,1566181.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257847',4904668,'2359','359',1529811.00,1530130.80,0.00,0.00,319.80,222002.00,0.00,0.00,0.00),('1','145','826','257848',4904669,'2358','359',1566181.46,1566181.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257848',4904670,'2359','359',1530130.80,1530130.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257849',4904671,'2358','359',1566181.46,1572368.53,0.00,0.00,6187.07,4313240.00,0.00,0.00,0.00),('1','145','827','257849',4904672,'2359','359',1530130.80,1530130.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257850',4904673,'2358','359',1572368.53,1576236.11,0.00,0.00,3867.58,2689265.20,0.00,0.00,0.00),('1','145','827','257850',4904674,'2359','359',1530130.80,1530130.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257851',4904675,'2358','359',1576236.11,1580828.53,0.00,0.00,4592.42,3196297.20,0.00,0.00,0.00),('1','145','827','257851',4904676,'2359','359',1530130.80,1530130.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257852',4904677,'2358','359',1580828.53,1585251.68,0.00,0.00,4423.15,3080832.00,0.00,0.00,0.00),('1','145','827','257852',4904678,'2359','359',1530130.80,1530130.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257853',4904679,'2358','359',1585251.68,1585439.72,0.00,0.00,188.04,127867.20,0.00,0.00,0.00),('1','145','827','257853',4904680,'2359','359',1530130.80,1530130.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257854',4904681,'2358','359',1585439.72,1585439.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257854',4904682,'2359','359',1530130.80,1533480.26,0.00,0.00,3349.46,2493028.30,0.00,0.00,0.00),('1','145','826','257855',4904683,'2358','359',1585439.72,1585439.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257855',4904684,'2359','359',1533480.26,1537531.24,0.00,0.00,4050.98,3019730.40,0.00,0.00,0.00),('1','145','826','257856',4904685,'2358','359',1585439.72,1585439.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257856',4904686,'2359','359',1537531.24,1539644.41,0.00,0.00,2113.17,1602747.10,0.00,0.00,0.00),('1','145','826','257857',4904687,'2358','359',1585439.72,1585439.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257857',4904688,'2359','359',1539644.41,1539644.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257858',4904689,'2358','359',1585439.72,1585439.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257858',4904690,'2359','359',1539644.41,1540191.39,0.00,0.00,546.98,423644.40,0.00,0.00,0.00),('1','145','826','257859',4904691,'2358','359',1585439.72,1585439.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257859',4904692,'2359','359',1540191.39,1542432.08,0.00,0.00,2240.69,1721115.70,0.00,0.00,0.00),('1','145','826','257860',4904693,'2358','359',1585439.72,1585439.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257860',4904694,'2359','359',1542432.08,1544909.30,0.00,0.00,2477.22,1888847.60,0.00,0.00,0.00),('1','145','826','257861',4904695,'2358','359',1585439.72,1585439.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257861',4904696,'2359','359',1544909.30,1546738.19,0.00,0.00,1828.89,1388089.70,0.00,0.00,0.00),('1','145','826','257862',4904697,'2358','359',1585439.72,1585439.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257862',4904698,'2359','359',1546738.19,1548791.33,0.00,0.00,2053.14,1555155.20,0.00,0.00,0.00),('1','145','826','257863',4904699,'2358','359',1585439.72,1585439.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257863',4904700,'2359','359',1548791.33,1552200.65,0.00,0.00,3409.32,2581095.60,0.00,0.00,0.00),('1','145','826','257864',4904701,'2358','359',1585439.72,1585439.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257864',4904702,'2359','359',1552200.65,1553613.81,0.00,0.00,1413.16,1062391.80,0.00,0.00,0.00),('1','145','826','257865',4904703,'2358','359',1585439.72,1585439.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257865',4904704,'2359','359',1553613.81,1554134.55,0.00,0.00,520.74,389401.70,0.00,0.00,0.00),('1','145','826','257866',4904705,'2358','359',1585439.72,1586526.28,0.00,0.00,1086.56,826316.80,0.00,0.00,0.00),('1','145','827','257866',4904706,'2359','359',1554134.55,1554134.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257867',4904707,'2358','359',1586526.28,1587858.19,0.00,0.00,1331.91,999522.30,0.00,0.00,0.00),('1','145','827','257867',4904708,'2359','359',1554134.55,1554134.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257868',4904709,'2358','359',1587858.19,1589208.37,0.00,0.00,1350.18,999802.30,0.00,0.00,0.00),('1','145','827','257868',4904710,'2359','359',1554134.55,1554141.59,0.00,0.00,7.04,5350.40,0.00,0.00,0.00),('1','145','826','257869',4904711,'2358','359',1589208.37,1592316.47,0.00,0.00,3108.10,2270916.00,0.00,0.00,0.00),('1','145','827','257869',4904712,'2359','359',1554141.59,1554141.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257870',4904713,'2358','359',1592316.47,1595315.40,0.00,0.00,2998.93,2208933.80,0.00,0.00,0.00),('1','145','827','257870',4904714,'2359','359',1554141.59,1554141.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257871',4904715,'2358','359',1595315.40,1597917.73,0.00,0.00,2602.33,1902361.30,0.00,0.00,0.00),('1','145','827','257871',4904716,'2359','359',1554141.59,1554141.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257872',4904717,'2358','359',1597917.73,1600604.49,0.00,0.00,2686.76,1977482.60,0.00,0.00,0.00),('1','145','827','257872',4904718,'2359','359',1554141.59,1554141.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257873',4904719,'2358','359',1600604.49,1602246.41,0.00,0.00,1641.92,1204951.70,0.00,0.00,0.00),('1','145','827','257873',4904720,'2359','359',1554141.59,1554141.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257874',4904721,'2358','359',1602246.41,1602246.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257874',4904722,'2359','359',1554141.59,1554141.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257875',4904723,'2358','359',1602246.41,1605000.57,0.00,0.00,2754.16,2020495.10,0.00,0.00,0.00),('1','145','827','257875',4904724,'2359','359',1554141.59,1554141.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257876',4904725,'2358','359',1605000.57,1605755.22,0.00,0.00,754.65,559634.00,0.00,0.00,0.00),('1','145','827','257876',4904726,'2359','359',1554141.59,1554141.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257877',4904727,'2358','359',1605755.22,1608160.33,0.00,0.00,2405.11,1767764.10,0.00,0.00,0.00),('1','145','827','257877',4904728,'2359','359',1554141.59,1554141.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257878',4904729,'2358','359',1608160.33,1609579.35,0.00,0.00,1419.02,1039786.20,0.00,0.00,0.00),('1','145','827','257878',4904730,'2359','359',1554141.59,1554141.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257879',4904731,'2358','359',1609579.35,1609579.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257879',4904732,'2359','359',1554141.59,1554956.81,0.00,0.00,815.22,597569.70,0.00,0.00,0.00),('1','145','826','257880',4904733,'2358','359',1609579.35,1609579.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257880',4904734,'2359','359',1554956.81,1557305.98,0.00,0.00,2349.17,1728368.70,0.00,0.00,0.00),('1','145','826','257881',4904735,'2358','359',1609579.35,1609579.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257881',4904736,'2359','359',1557305.98,1559986.04,0.00,0.00,2680.06,1981708.60,0.00,0.00,0.00),('1','145','826','257882',4904737,'2358','359',1609579.35,1609579.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257882',4904738,'2359','359',1559986.04,1559986.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257883',4904739,'2358','359',1609579.35,1609579.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257883',4904740,'2359','359',1559986.04,1561493.75,0.00,0.00,1507.71,1111539.60,0.00,0.00,0.00),('1','145','826','257884',4904741,'2358','359',1609579.35,1609579.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257884',4904742,'2359','359',1561493.75,1564226.77,0.00,0.00,2733.02,2007860.20,0.00,0.00,0.00),('1','145','826','257885',4904743,'2358','359',1609579.35,1609579.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257885',4904744,'2359','359',1564226.77,1566424.62,0.00,0.00,2197.85,1623099.00,0.00,0.00,0.00),('1','145','826','257886',4904745,'2358','359',1609579.35,1609579.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257886',4904746,'2359','359',1566424.62,1568391.44,0.00,0.00,1966.82,1461204.70,0.00,0.00,0.00),('1','145','826','257887',4904747,'2358','359',1609579.35,1609579.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257887',4904748,'2359','359',1568391.44,1570193.44,0.00,0.00,1802.00,1311755.40,0.00,0.00,0.00),('1','145','826','257888',4904749,'2358','359',1609579.35,1609579.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257888',4904750,'2359','359',1570193.44,1571898.12,0.00,0.00,1704.68,1247301.60,0.00,0.00,0.00),('1','145','826','257889',4904751,'2358','359',1609579.35,1609579.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257889',4904752,'2359','359',1571898.12,1575375.18,0.00,0.00,3477.06,2505918.00,0.00,0.00,0.00),('1','145','826','257890',4904753,'2358','359',1609579.35,1609579.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257890',4904754,'2359','359',1575375.18,1577394.55,0.00,0.00,2019.37,1449228.90,0.00,0.00,0.00),('1','145','826','257891',4904755,'2358','359',1609579.35,1609579.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257891',4904756,'2359','359',1577394.55,1578469.94,0.00,0.00,1075.39,783119.10,0.00,0.00,0.00),('1','145','826','257892',4904757,'2358','359',1609579.35,1611243.24,0.00,0.00,1663.89,1194008.70,0.00,0.00,0.00),('1','145','827','257892',4904758,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257893',4904759,'2358','359',1611243.24,1614321.96,0.00,0.00,3078.72,2168387.40,0.00,0.00,0.00),('1','145','827','257893',4904760,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257894',4904761,'2358','359',1614321.96,1617267.92,0.00,0.00,2945.96,2081325.00,0.00,0.00,0.00),('1','145','827','257894',4904762,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257895',4904763,'2358','359',1617267.92,1620724.94,0.00,0.00,3457.02,2436246.00,0.00,0.00,0.00),('1','145','827','257895',4904764,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257896',4904765,'2358','359',1620724.94,1623804.81,0.00,0.00,3079.87,2173651.50,0.00,0.00,0.00),('1','145','827','257896',4904766,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257897',4904767,'2358','359',1623804.81,1623804.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257897',4904768,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257898',4904769,'2358','359',1623804.81,1628597.19,0.00,0.00,4792.38,3358886.10,0.00,0.00,0.00),('1','145','827','257898',4904770,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257899',4904771,'2358','359',1628597.19,1630708.88,0.00,0.00,2111.69,1475605.60,0.00,0.00,0.00),('1','145','827','257899',4904772,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257900',4904773,'2358','359',1630708.88,1633468.70,0.00,0.00,2759.82,1937711.60,0.00,0.00,0.00),('1','145','827','257900',4904774,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257901',4904775,'2358','359',1633468.70,1634082.47,0.00,0.00,613.77,436722.40,0.00,0.00,0.00),('1','145','827','257901',4904776,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257902',4904777,'2358','359',1634082.47,1634082.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257902',4904778,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257903',4904779,'2358','359',1634082.47,1634511.32,0.00,0.00,428.85,306132.00,0.00,0.00,0.00),('1','145','827','257903',4904780,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257904',4904781,'2358','359',1634511.32,1637232.55,0.00,0.00,2721.23,1906695.60,0.00,0.00,0.00),('1','145','827','257904',4904782,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257905',4904783,'2358','359',1637232.55,1639839.55,0.00,0.00,2607.00,1826092.40,0.00,0.00,0.00),('1','145','827','257905',4904784,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257906',4904785,'2358','359',1639839.55,1643830.75,0.00,0.00,3991.20,2801585.60,0.00,0.00,0.00),('1','145','827','257906',4904786,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257907',4904787,'2358','359',1643830.75,1645791.76,0.00,0.00,1961.01,1370340.00,0.00,0.00,0.00),('1','145','827','257907',4904788,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257908',4904789,'2358','359',1645791.76,1648465.22,0.00,0.00,2673.46,1870122.40,0.00,0.00,0.00),('1','145','827','257908',4904790,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257909',4904791,'2358','359',1648465.22,1650961.97,0.00,0.00,2496.75,1750850.00,0.00,0.00,0.00),('1','145','827','257909',4904792,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257910',4904793,'2358','359',1650961.97,1653157.69,0.00,0.00,2195.72,1545287.20,0.00,0.00,0.00),('1','145','827','257910',4904794,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257911',4904795,'2358','359',1653157.69,1653497.52,0.00,0.00,339.83,242324.80,0.00,0.00,0.00),('1','145','827','257911',4904796,'2359','359',1578469.94,1578469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257912',4904797,'2358','359',1653497.52,1653497.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257912',4904798,'2359','359',1578469.94,1579891.06,0.00,0.00,1421.12,994126.00,0.00,0.00,0.00),('1','145','826','257913',4904799,'2358','359',1653497.52,1653497.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257913',4904800,'2359','359',1579891.06,1582558.33,0.00,0.00,2667.27,1878572.80,0.00,0.00,0.00),('1','145','826','257914',4904801,'2358','359',1653497.52,1653497.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257914',4904802,'2359','359',1582558.33,1582558.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257915',4904803,'2358','359',1653497.52,1653497.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257915',4904804,'2359','359',1582558.33,1586342.82,0.00,0.00,3784.49,2651872.00,0.00,0.00,0.00),('1','145','826','257916',4904805,'2358','359',1653497.52,1653497.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257916',4904806,'2359','359',1586342.82,1587834.59,0.00,0.00,1491.77,1047408.80,0.00,0.00,0.00),('1','145','826','257917',4904807,'2358','359',1653497.52,1653497.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257917',4904808,'2359','359',1587834.59,1590552.49,0.00,0.00,2717.90,1914756.00,0.00,0.00,0.00),('1','145','826','257918',4904809,'2358','359',1653497.52,1653497.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257918',4904810,'2359','359',1590552.49,1593235.79,0.00,0.00,2683.30,1890594.40,0.00,0.00,0.00),('1','145','826','257919',4904811,'2358','359',1653497.52,1653497.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257919',4904812,'2359','359',1593235.79,1596778.47,0.00,0.00,3542.68,2480021.20,0.00,0.00,0.00),('1','145','826','257920',4904813,'2358','359',1653497.52,1653497.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257920',4904814,'2359','359',1596778.47,1599237.68,0.00,0.00,2459.21,1742044.00,0.00,0.00,0.00),('1','145','826','257921',4904815,'2358','359',1653497.52,1653497.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257921',4904816,'2359','359',1599237.68,1602739.47,0.00,0.00,3501.79,2457462.40,0.00,0.00,0.00),('1','145','826','257922',4904817,'2358','359',1653497.52,1653497.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257922',4904818,'2359','359',1602739.47,1603387.07,0.00,0.00,647.60,453481.50,0.00,0.00,0.00),('1','145','826','257923',4904819,'2358','359',1653497.52,1658378.45,0.00,0.00,4880.93,3393977.10,0.00,0.00,0.00),('1','145','827','257923',4904820,'2359','359',1603387.07,1603387.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257924',4904821,'2358','359',1658378.45,1663863.57,0.00,0.00,5485.12,3735143.90,0.00,0.00,0.00),('1','145','827','257924',4904822,'2359','359',1603387.07,1603387.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257925',4904823,'2358','359',1663863.57,1670510.89,0.00,0.00,6647.32,4524721.90,0.00,0.00,0.00),('1','145','827','257925',4904824,'2359','359',1603387.07,1603387.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257926',4904825,'2358','359',1670510.89,1675060.04,0.00,0.00,4549.15,3096227.00,0.00,0.00,0.00),('1','145','827','257926',4904826,'2359','359',1603387.07,1603387.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257927',4904827,'2358','359',1675060.04,1678295.54,0.00,0.00,3235.50,2199415.50,0.00,0.00,0.00),('1','145','827','257927',4904828,'2359','359',1603387.07,1603387.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257928',4904829,'2358','359',1678295.54,1678295.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257928',4904830,'2359','359',1603387.07,1603387.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257929',4904831,'2358','359',1678295.54,1678295.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257929',4904832,'2359','359',1603387.07,1606195.10,0.00,0.00,2808.03,1923378.10,0.00,0.00,0.00),('1','145','826','257930',4904833,'2358','359',1678295.54,1678295.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257930',4904834,'2359','359',1606195.10,1612930.59,0.00,0.00,6735.49,4613782.80,0.00,0.00,0.00),('1','145','826','257931',4904835,'2358','359',1678295.54,1678295.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257931',4904836,'2359','359',1612930.59,1619315.40,0.00,0.00,6384.81,4383341.20,0.00,0.00,0.00),('1','145','826','257932',4904837,'2358','359',1678295.54,1678295.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257932',4904838,'2359','359',1619315.40,1622166.11,0.00,0.00,2850.71,1942735.20,0.00,0.00,0.00),('1','145','826','257933',4904839,'2358','359',1678295.54,1678295.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257933',4904840,'2359','359',1622166.11,1626962.49,0.00,0.00,4796.38,3260852.60,0.00,0.00,0.00),('1','145','826','257934',4904841,'2358','359',1678295.54,1678295.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257934',4904842,'2359','359',1626962.49,1627029.16,0.00,0.00,66.67,45502.40,0.00,0.00,0.00),('1','145','826','257935',4904843,'2358','359',1678295.54,1678295.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257935',4904844,'2359','359',1627029.16,1627029.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257936',4904845,'2358','359',1678295.54,1678295.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257936',4904846,'2359','359',1627029.16,1627029.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257937',4904847,'2358','359',1678295.54,1678295.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257937',4904848,'2359','359',1627029.16,1629322.02,0.00,0.00,2292.86,1570915.20,0.00,0.00,0.00),('1','145','826','257938',4904849,'2358','359',1678295.54,1678295.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257938',4904850,'2359','359',1629322.02,1635130.70,0.00,0.00,5808.68,3937661.10,0.00,0.00,0.00),('1','145','826','257939',4904851,'2358','359',1678295.54,1678295.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257939',4904852,'2359','359',1635130.70,1641493.11,0.00,0.00,6362.41,4330348.40,0.00,0.00,0.00),('1','145','826','257940',4904853,'2358','359',1678295.54,1678295.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257940',4904854,'2359','359',1641493.11,1648116.44,0.00,0.00,6623.33,4485182.00,0.00,0.00,0.00),('1','145','826','257941',4904855,'2358','359',1678295.54,1678295.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257941',4904856,'2359','359',1648116.44,1648819.76,0.00,0.00,703.32,481944.90,0.00,0.00,0.00),('1','145','826','257942',4904857,'2358','359',1678295.54,1686529.09,0.00,0.00,8233.55,5600966.50,0.00,0.00,0.00),('1','145','827','257942',4904858,'2359','359',1648819.76,1648819.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257943',4904859,'2358','359',1686529.09,1686529.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257943',4904860,'2359','359',1648819.76,1648819.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257944',4904861,'2358','359',1686529.09,1691100.14,0.00,0.00,4571.05,3109626.00,0.00,0.00,0.00),('1','145','827','257944',4904862,'2359','359',1648819.76,1648819.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257945',4904863,'2358','359',1691100.14,1701278.45,0.00,0.00,10178.31,6904757.70,0.00,0.00,0.00),('1','145','827','257945',4904864,'2359','359',1648819.76,1648819.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257946',4904865,'2358','359',1701278.45,1702708.92,0.00,0.00,1430.47,968679.40,0.00,0.00,0.00),('1','145','827','257946',4904866,'2359','359',1648819.76,1648819.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257947',4904867,'2358','359',1702708.92,1702708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257947',4904868,'2359','359',1648819.76,1648819.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257948',4904869,'2358','359',1702708.92,1702708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257948',4904870,'2359','359',1648819.76,1651877.13,0.00,0.00,3057.37,2077642.40,0.00,0.00,0.00),('1','145','826','257949',4904871,'2358','359',1702708.92,1702708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257949',4904872,'2359','359',1651877.13,1662524.51,0.00,0.00,10647.38,7227967.10,0.00,0.00,0.00),('1','145','826','257950',4904873,'2358','359',1702708.92,1702708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257950',4904874,'2359','359',1662524.51,1671597.82,0.00,0.00,9073.31,6164887.70,0.00,0.00,0.00),('1','145','826','257951',4904875,'2358','359',1702708.92,1702708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257951',4904876,'2359','359',1671597.82,1673192.06,0.00,0.00,1594.24,1082404.30,0.00,0.00,0.00),('1','145','826','257952',4904877,'2358','359',1702708.92,1710267.95,0.00,0.00,7559.03,5169299.60,0.00,0.00,0.00),('1','145','827','257952',4904878,'2359','359',1673192.06,1673192.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257953',4904879,'2358','359',1710267.95,1714209.95,0.00,0.00,3942.00,2687994.50,0.00,0.00,0.00),('1','145','827','257953',4904880,'2359','359',1673192.06,1673192.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257954',4904881,'2358','359',1714209.95,1714209.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257954',4904882,'2359','359',1673192.06,1673192.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257955',4904883,'2358','359',1714209.95,1718303.27,0.00,0.00,4093.32,2828478.40,0.00,0.00,0.00),('1','145','827','257955',4904884,'2359','359',1673192.06,1673192.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257956',4904885,'2358','359',1718303.27,1722331.84,0.00,0.00,4028.57,2765606.40,0.00,0.00,0.00),('1','145','827','257956',4904886,'2359','359',1673192.06,1673192.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257957',4904887,'2358','359',1722331.84,1725950.24,0.00,0.00,3618.40,2481782.50,0.00,0.00,0.00),('1','145','827','257957',4904888,'2359','359',1673192.06,1673192.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257958',4904889,'2358','359',1725950.24,1727218.68,0.00,0.00,1268.44,864145.30,0.00,0.00,0.00),('1','145','827','257958',4904890,'2359','359',1673192.06,1673192.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257959',4904891,'2358','359',1727218.68,1727218.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257959',4904892,'2359','359',1673192.06,1675803.62,0.00,0.00,2611.56,1795349.20,0.00,0.00,0.00),('1','145','826','257960',4904893,'2358','359',1727218.68,1727218.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257960',4904894,'2359','359',1675803.62,1681558.11,0.00,0.00,5754.49,3914013.30,0.00,0.00,0.00),('1','145','826','257961',4904895,'2358','359',1727218.68,1727218.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257961',4904896,'2359','359',1681558.11,1685951.95,0.00,0.00,4393.84,3025134.30,0.00,0.00,0.00),('1','145','826','257962',4904897,'2358','359',1727218.68,1727218.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257962',4904898,'2359','359',1685951.95,1689580.38,0.00,0.00,3628.43,2477359.60,0.00,0.00,0.00),('1','145','826','257963',4904899,'2358','359',1727218.68,1727218.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257963',4904900,'2359','359',1689580.38,1694678.90,0.00,0.00,5098.52,3483288.90,0.00,0.00,0.00),('1','145','826','257964',4904901,'2358','359',1727218.68,1727218.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257964',4904902,'2359','359',1694678.90,1696619.27,0.00,0.00,1940.37,1329252.40,0.00,0.00,0.00),('1','145','826','257965',4904903,'2358','359',1727218.68,1727218.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257965',4904904,'2359','359',1696619.27,1696619.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257966',4904905,'2358','359',1727218.68,1727218.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257966',4904906,'2359','359',1696619.27,1696619.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257967',4904907,'2358','359',1727218.68,1727218.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257967',4904908,'2359','359',1696619.27,1696619.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257968',4904909,'2358','359',1727218.68,1732639.38,0.00,0.00,5420.70,3701895.00,0.00,0.00,0.00),('1','145','827','257968',4904910,'2359','359',1696619.27,1696619.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257969',4904911,'2358','359',1732639.38,1732639.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257969',4904912,'2359','359',1696619.27,1696673.10,0.00,0.00,53.83,37057.60,0.00,0.00,0.00),('1','145','826','257970',4904913,'2358','359',1732639.38,1737528.46,0.00,0.00,4889.08,3354803.10,0.00,0.00,0.00),('1','145','827','257970',4904914,'2359','359',1696673.10,1696673.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257971',4904915,'2358','359',1737528.46,1740897.26,0.00,0.00,3368.80,2299769.00,0.00,0.00,0.00),('1','145','827','257971',4904916,'2359','359',1696673.10,1696673.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257972',4904917,'2358','359',1740897.26,1745198.65,0.00,0.00,4301.39,2957561.80,0.00,0.00,0.00),('1','145','827','257972',4904918,'2359','359',1696673.10,1696673.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257973',4904919,'2358','359',1745198.65,1749655.50,0.00,0.00,4456.85,3060296.50,0.00,0.00,0.00),('1','145','827','257973',4904920,'2359','359',1696673.10,1696673.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257974',4904921,'2358','359',1749655.50,1750970.43,0.00,0.00,1314.93,896422.60,0.00,0.00,0.00),('1','145','827','257974',4904922,'2359','359',1696673.10,1696673.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257975',4904923,'2358','359',1750970.43,1750970.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257975',4904924,'2359','359',1696673.10,1701507.14,0.00,0.00,4834.04,3310924.30,0.00,0.00,0.00),('1','145','826','257976',4904925,'2358','359',1750970.43,1750970.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257976',4904926,'2359','359',1701507.14,1705481.46,0.00,0.00,3974.32,2721825.40,0.00,0.00,0.00),('1','145','826','257977',4904927,'2358','359',1750970.43,1750970.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257977',4904928,'2359','359',1705481.46,1711675.80,0.00,0.00,6194.34,4255763.80,0.00,0.00,0.00),('1','145','826','257978',4904929,'2358','359',1750970.43,1750970.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257978',4904930,'2359','359',1711675.80,1715055.99,0.00,0.00,3380.19,2326318.30,0.00,0.00,0.00),('1','145','826','257979',4904931,'2358','359',1750970.43,1750970.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257979',4904932,'2359','359',1715055.99,1719795.09,0.00,0.00,4739.10,3239746.50,0.00,0.00,0.00),('1','145','826','257980',4904933,'2358','359',1750970.43,1750970.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257980',4904934,'2359','359',1719795.09,1719795.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257981',4904935,'2358','359',1750970.43,1750970.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257981',4904936,'2359','359',1719795.09,1721080.81,0.00,0.00,1285.72,876444.90,0.00,0.00,0.00),('1','145','826','257982',4904937,'2358','359',1750970.43,1755136.67,0.00,0.00,4166.24,2846245.30,0.00,0.00,0.00),('1','145','827','257982',4904938,'2359','359',1721080.81,1721080.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257983',4904939,'2358','359',1755136.67,1757909.36,0.00,0.00,2772.69,1906730.30,0.00,0.00,0.00),('1','145','827','257983',4904940,'2359','359',1721080.81,1721080.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257984',4904941,'2358','359',1757909.36,1761737.45,0.00,0.00,3828.09,2633339.30,0.00,0.00,0.00),('1','145','827','257984',4904942,'2359','359',1721080.81,1721080.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257985',4904943,'2358','359',1761737.45,1761737.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257985',4904944,'2359','359',1721080.81,1721080.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257986',4904945,'2358','359',1761737.45,1765775.12,0.00,0.00,4037.67,2759457.40,0.00,0.00,0.00),('1','145','827','257986',4904946,'2359','359',1721080.81,1721080.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257987',4904947,'2358','359',1765775.12,1770746.75,0.00,0.00,4971.63,3406577.10,0.00,0.00,0.00),('1','145','827','257987',4904948,'2359','359',1721080.81,1721080.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257988',4904949,'2358','359',1770746.75,1774832.86,0.00,0.00,4086.11,2793820.70,0.00,0.00,0.00),('1','145','827','257988',4904950,'2359','359',1721080.81,1721080.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257989',4904951,'2358','359',1774832.86,1774832.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257989',4904952,'2359','359',1721080.81,1722118.35,0.00,0.00,1037.54,704146.80,0.00,0.00,0.00),('1','145','826','257990',4904953,'2358','359',1774832.86,1774832.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257990',4904954,'2359','359',1722118.35,1727694.44,0.00,0.00,5576.09,3818894.80,0.00,0.00,0.00),('1','145','826','257991',4904955,'2358','359',1774832.86,1774832.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257991',4904956,'2359','359',1727694.44,1732579.86,0.00,0.00,4885.42,3353569.90,0.00,0.00,0.00),('1','145','826','257992',4904957,'2358','359',1774832.86,1774832.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257992',4904958,'2359','359',1732579.86,1736368.34,0.00,0.00,3788.48,2617040.10,0.00,0.00,0.00),('1','145','826','257993',4904959,'2358','359',1774832.86,1774832.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257993',4904960,'2359','359',1736368.34,1742851.41,0.00,0.00,6483.07,4440774.90,0.00,0.00,0.00),('1','145','826','257994',4904961,'2358','359',1774832.86,1774832.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257994',4904962,'2359','359',1742851.41,1745679.38,0.00,0.00,2827.97,1943490.40,0.00,0.00,0.00),('1','145','826','257995',4904963,'2358','359',1774832.86,1774832.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257995',4904964,'2359','359',1745679.38,1745679.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257996',4904965,'2358','359',1774832.86,1774832.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','257996',4904966,'2359','359',1745679.38,1745921.26,0.00,0.00,241.88,165968.60,0.00,0.00,0.00),('1','145','826','257997',4904967,'2358','359',1774832.86,1778518.64,0.00,0.00,3685.78,2527014.60,0.00,0.00,0.00),('1','145','827','257997',4904968,'2359','359',1745921.26,1745921.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257998',4904969,'2358','359',1778518.64,1782451.26,0.00,0.00,3932.62,2716621.40,0.00,0.00,0.00),('1','145','827','257998',4904970,'2359','359',1745921.26,1745921.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','257999',4904971,'2358','359',1782451.26,1786199.71,0.00,0.00,3748.45,2574604.00,0.00,0.00,0.00),('1','145','827','257999',4904972,'2359','359',1745921.26,1745921.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','258000',4904973,'2358','359',1786199.71,1789625.49,0.00,0.00,3425.78,2391853.10,0.00,0.00,0.00),('1','145','827','258000',4904974,'2359','359',1745921.26,1745921.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','258001',4904975,'2358','359',1789625.49,1793210.86,0.00,0.00,3585.37,2487716.90,0.00,0.00,0.00),('1','145','827','258001',4904976,'2359','359',1745921.26,1745921.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','258002',4904977,'2358','359',1793210.86,1798533.86,0.00,0.00,5323.00,3656047.50,0.00,0.00,0.00),('1','145','827','258002',4904978,'2359','359',1745921.26,1745921.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','258003',4904979,'2358','359',1798533.86,1798620.47,0.00,0.00,86.61,61659.20,0.00,0.00,0.00),('1','145','827','258003',4904980,'2359','359',1745921.26,1745921.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','258004',4904981,'2358','359',1798620.47,1798620.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','258004',4904982,'2359','359',1745921.26,1745921.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','258005',4904983,'2358','359',1798620.47,1798620.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','258005',4904984,'2359','359',1745921.26,1750317.53,0.00,0.00,4396.27,3016674.40,0.00,0.00,0.00),('1','145','826','258006',4904985,'2358','359',1798620.47,1798620.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','258006',4904986,'2359','359',1750317.53,1753185.40,0.00,0.00,2867.87,1983197.90,0.00,0.00,0.00),('1','145','826','258007',4904987,'2358','359',1798620.47,1798620.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','258007',4904988,'2359','359',1753185.40,1756168.58,0.00,0.00,2983.18,2054803.10,0.00,0.00,0.00),('1','145','826','258008',4904989,'2358','359',1798620.47,1798620.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','258008',4904990,'2359','359',1756168.58,1759112.09,0.00,0.00,2943.51,2040224.70,0.00,0.00,0.00),('1','145','826','258009',4904991,'2358','359',1798620.47,1798620.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','258009',4904992,'2359','359',1759112.09,1763568.91,0.00,0.00,4456.82,3085392.40,0.00,0.00,0.00),('1','145','826','258010',4904993,'2358','359',1798620.47,1798620.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','258010',4904994,'2359','359',1763568.91,1765537.22,0.00,0.00,1968.31,1375416.70,0.00,0.00,0.00),('1','145','826','258011',4904995,'2358','359',1798620.47,1798620.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','258011',4904996,'2359','359',1765537.22,1769941.53,0.00,0.00,4404.31,3038406.20,0.00,0.00,0.00),('1','145','826','258012',4904997,'2358','359',1798620.47,1798620.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','258012',4904998,'2359','359',1769941.53,1769941.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','258013',4904999,'2358','359',1798620.47,1802918.74,0.00,0.00,4298.27,2956052.40,0.00,0.00,0.00),('1','145','827','258013',4905000,'2359','359',1769941.53,1769941.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','258014',4905001,'2358','359',1802918.74,1806734.05,0.00,0.00,3815.31,2635431.20,0.00,0.00,0.00),('1','145','827','258014',4905002,'2359','359',1769941.53,1769941.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','258015',4905003,'2358','359',1806734.05,1811539.87,0.00,0.00,4805.82,3304327.90,0.00,0.00,0.00),('1','145','827','258015',4905004,'2359','359',1769941.53,1769941.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','258016',4905005,'2358','359',1811539.87,1814596.35,0.00,0.00,3056.48,2114212.60,0.00,0.00,0.00),('1','145','827','258016',4905006,'2359','359',1769941.53,1769941.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','258017',4905007,'2358','359',1814596.35,1819368.75,0.00,0.00,4772.40,3313168.00,0.00,0.00,0.00),('1','145','827','258017',4905008,'2359','359',1769941.53,1769941.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','258018',4905009,'2358','359',1819368.75,1821249.15,0.00,0.00,1880.40,1306811.50,0.00,0.00,0.00),('1','145','827','258018',4905010,'2359','359',1769941.53,1769941.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','258019',4905011,'2358','359',1821249.15,1822042.54,0.00,0.00,793.39,551011.80,0.00,0.00,0.00),('1','145','827','258019',4905012,'2359','359',1769941.53,1769941.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','258020',4905013,'2358','359',1822042.54,1822042.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','258020',4905014,'2359','359',1769941.53,1769941.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','258021',4905015,'2358','359',1822042.54,1822042.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','258021',4905016,'2359','359',1769941.53,1770773.36,0.00,0.00,831.83,559762.10,0.00,0.00,0.00),('1','145','826','258022',4905017,'2358','359',1822042.54,1822042.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','258022',4905018,'2359','359',1770773.36,1773960.09,0.00,0.00,3186.73,2209758.10,0.00,0.00,0.00),('1','145','826','258023',4905019,'2358','359',1822042.54,1822042.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','258023',4905020,'2359','359',1773960.09,1777108.10,0.00,0.00,3148.01,2168720.20,0.00,0.00,0.00),('1','145','826','258024',4905021,'2358','359',1822042.54,1822042.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','258024',4905022,'2359','359',1777108.10,1780689.68,0.00,0.00,3581.58,2470501.10,0.00,0.00,0.00),('1','145','826','258025',4905023,'2358','359',1822042.54,1822042.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','258025',4905024,'2359','359',1780689.68,1784827.10,0.00,0.00,4137.42,2871524.90,0.00,0.00,0.00),('1','145','826','258026',4905025,'2358','359',1822042.54,1822042.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','258026',4905026,'2359','359',1784827.10,1789619.37,0.00,0.00,4792.27,3276670.90,0.00,0.00,0.00),('1','145','826','258027',4905027,'2358','359',1822042.54,1822042.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','258027',4905028,'2359','359',1789619.37,1794064.88,0.00,0.00,4445.51,3038019.70,0.00,0.00,0.00),('1','145','826','258028',4905029,'2358','359',1822042.54,1822042.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','827','258028',4905030,'2359','359',1794064.88,1794064.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','145','826','258029',4905031,'2358','359',1822042.54,1822680.54,0.00,0.00,638.00,442394.00,0.00,0.00,0.00),('1','145','827','258029',4905032,'2359','359',1794064.88,1794064.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730220 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','145','156181','359',202.00,250.00,0.00,0.00,0.00,0.00,0.00,465920),('1','145','156874','359',202.00,250.00,0.00,859.70,173659.40,197390.00,23730.60,467796),('1','145','156881','359',202.00,250.00,0.00,1224.00,247248.00,276350.00,29102.00,467815),('1','145','156883','359',202.00,250.00,0.00,1733.60,350187.20,393030.00,42842.80,467819),('1','145','156886','359',202.00,250.00,0.00,597.40,120674.80,135850.00,15175.20,467826),('1','145','156887','359',202.00,250.00,0.00,1409.90,284799.80,319215.00,34415.20,467827),('1','145','156889','359',202.00,250.00,0.00,3470.50,701041.00,773130.00,72089.00,467829),('1','145','159324','359',202.00,250.00,0.00,2684.30,542228.60,601979.00,59750.40,474219),('1','145','159330','359',202.00,250.00,0.00,2292.50,463085.00,522275.00,59190.00,474235),('1','145','159334','359',202.00,250.00,0.00,2583.50,521867.00,588115.00,66248.00,474243),('1','145','159337','359',202.00,250.00,0.00,3612.20,729664.40,824375.00,94710.60,474250),('1','145','159339','359',202.00,250.00,0.00,526.90,106433.80,118852.50,12418.70,474254),('1','145','159343','359',202.00,250.00,0.00,655.00,132310.00,148500.00,16190.00,474263),('1','145','159347','359',202.00,250.00,0.00,7029.70,1419999.40,1568886.50,148887.10,474270),('1','145','159350','359',202.00,0.00,0.00,4271.10,862762.20,972247.50,109485.30,474277),('1','145','159354','359',202.00,250.00,0.00,4840.60,977801.20,1098935.00,121133.80,474285),('1','145','159359','359',202.00,250.00,0.00,3655.10,738330.20,831357.50,93027.30,474295),('1','145','159366','359',202.00,250.00,0.00,0.00,0.00,0.00,0.00,474313),('1','145','159369','359',202.00,0.00,0.00,5206.60,1051733.20,1180122.50,128389.30,474320),('1','145','159373','359',202.00,250.00,0.00,7078.30,1429816.60,1604730.00,174913.40,474330),('1','145','159375','359',202.00,250.00,0.00,1315.50,265731.00,297825.00,32094.00,474334),('1','145','159376','359',202.00,250.00,0.00,9139.90,1846259.80,2066140.00,219880.20,474335),('1','145','159379','359',202.00,250.00,0.00,992.30,200444.60,224992.50,24547.90,474342),('1','145','159421','359',202.00,250.00,0.00,4265.80,861691.60,969562.50,107870.90,474466),('1','145','159426','359',202.00,250.00,0.00,11438.70,2310617.40,2592480.00,281862.60,474477),('1','145','159508','359',202.00,250.00,0.00,6834.70,1380609.40,1552852.50,172243.10,474683),('1','145','159519','359',202.00,250.00,0.00,4702.90,949985.80,1073980.00,123994.20,474713),('1','145','159524','359',202.00,250.00,0.00,7889.50,1593679.00,1789812.50,196133.50,474726),('1','145','159526','359',202.00,250.00,0.00,5642.30,1139744.60,1287897.50,148152.90,474730),('1','145','159529','359',202.00,250.00,0.00,4261.00,860722.00,986737.50,126015.50,474737),('1','145','160123','359',202.00,272.00,0.00,7955.80,1607071.60,1896606.40,289534.80,476265),('1','145','160130','359',202.00,272.00,0.00,5667.30,1144794.60,1373112.00,228317.40,476277),('1','145','160131','359',202.00,272.00,0.00,5294.10,1069408.20,1286685.60,217277.40,476278),('1','145','160456','359',202.00,272.00,0.00,3647.40,736774.80,879772.80,142998.00,477139),('1','145','160457','359',202.00,272.00,0.00,5558.20,1122756.40,1347454.40,224698.00,477140),('1','145','160825','359',202.00,272.00,0.00,4948.80,999657.60,1196576.40,196918.80,478085),('1','145','160830','359',202.00,272.00,0.00,6938.90,1401657.80,1663195.60,261537.80,478096),('1','145','160891','359',202.00,272.00,0.07,1210.00,244420.00,293616.80,49196.80,478243),('1','145','161136','359',202.00,272.00,0.00,6953.30,1404566.60,1680460.00,275893.40,478889),('1','145','161331','359',202.00,272.00,0.00,2011.60,406343.20,482553.20,76210.00,479377),('1','145','161332','359',202.00,272.00,0.00,3270.10,660560.20,791594.00,131033.80,479378),('1','145','161483','359',202.00,272.00,0.00,5474.20,1105788.40,1316524.40,210736.00,479758),('1','145','161661','359',202.00,272.00,0.00,5238.30,1058136.60,1265496.00,207359.40,480237),('1','145','161881','359',202.00,272.00,0.00,6875.70,1388891.40,1636224.00,247332.60,480789),('1','145','162046','359',202.00,272.00,0.00,2332.00,471064.00,568478.00,97414.00,481240),('1','145','162049','359',202.00,272.00,0.00,5318.50,1074337.00,1280175.20,205838.20,481243),('1','145','162245','359',202.00,272.00,0.00,2599.10,525018.20,624270.40,99252.20,481735),('1','145','162461','359',202.00,272.00,0.00,5771.70,1165883.40,1388170.80,222287.40,482294),('1','145','162642','359',202.00,272.00,0.00,4647.80,938855.60,1132045.60,193190.00,482739),('1','145','162824','359',202.00,272.00,0.00,1443.20,291526.40,348821.20,57294.80,483215),('1','145','162825','359',202.00,272.00,0.00,2916.40,589112.80,700431.20,111318.40,483216),('1','145','163005','359',202.00,272.00,0.00,6796.90,1372973.80,1620554.00,247580.20,483701),('1','145','163219','359',202.00,272.00,0.00,3687.10,744794.20,898566.80,153772.60,484238),('1','145','163382','359',202.00,272.00,0.00,5892.30,1190244.60,1422205.20,231960.60,484660),('1','145','163541','359',202.00,272.00,0.00,1781.90,359943.80,429985.60,70041.80,485089),('1','145','163779','359',202.00,272.00,0.00,5734.60,1158389.20,1386615.20,228226.00,485704),('1','145','163904','359',202.00,272.00,0.00,6860.00,1385720.00,1635046.00,249326.00,486027),('1','145','164082','359',202.00,296.00,0.00,2902.00,586204.00,775026.80,188822.80,486491),('1','145','164258','359',202.00,296.00,0.00,4560.80,921281.60,1211004.40,289722.80,486961),('1','145','164493','359',202.00,296.00,0.00,3242.70,655025.40,864676.80,209651.40,487592),('1','145','164611','359',202.00,296.00,0.00,7354.90,1485689.80,1956032.00,470342.20,487907),('1','145','164733','359',202.00,296.00,0.00,1979.40,399838.80,526704.00,126865.20,488248),('1','145','164973','359',202.00,296.00,0.00,5093.80,1028947.60,1354692.80,325745.20,488850),('1','145','165128','359',202.00,320.00,0.00,7313.90,1477407.80,2134984.00,657576.20,489251),('1','145','165311','359',202.00,320.00,0.00,3114.30,629088.60,923439.00,294350.40,489724),('1','145','165312','359',202.00,320.00,0.00,824.20,166488.40,243479.00,76990.60,489725),('1','145','165445','359',202.00,320.00,0.00,3646.60,736613.20,1079102.00,342488.80,490078),('1','145','165621','359',202.00,320.00,0.00,2859.40,577598.80,854738.00,277139.20,490540),('1','145','165798','359',202.00,320.00,0.00,4851.00,979902.00,1434591.00,454689.00,491018),('1','145','165922','359',202.00,320.00,0.00,1711.10,345642.20,508594.00,162951.80,491355),('1','145','166147','359',202.00,320.00,0.00,2431.30,491122.60,724292.00,233169.40,491933),('1','145','166500','359',202.00,320.00,0.00,3634.10,734088.20,1077088.00,342999.80,492885),('1','145','166502','359',202.00,320.00,0.00,470.80,95101.60,143789.00,48687.40,492889),('1','145','166503','359',202.00,320.00,0.00,2481.90,501343.80,732357.00,231013.20,492890),('1','145','166702','359',202.00,320.00,0.00,0.00,0.00,0.00,0.00,493422),('1','145','166706','359',202.00,0.00,0.00,2934.60,592789.20,870513.00,277723.80,493434),('1','145','166880','359',202.00,320.00,0.00,2739.30,553338.60,813645.00,260306.40,493917),('1','145','167185','359',202.00,320.00,0.00,2986.20,603212.40,900543.00,297330.60,494724),('1','145','167186','359',202.00,320.00,0.00,887.60,179295.20,264394.00,85098.80,494725),('1','145','167389','359',202.00,320.00,0.00,3843.80,776447.60,1136080.00,359632.40,495269),('1','145','167575','359',202.00,320.00,0.00,2785.80,562731.60,829968.00,267236.40,495755),('1','145','167742','359',202.00,320.00,0.00,2025.30,409110.60,611316.00,202205.40,496195),('1','145','167923','359',202.00,320.00,0.00,2077.60,419675.20,617432.00,197756.80,496669),('1','145','167924','359',202.00,320.00,0.00,753.50,152207.00,226840.00,74633.00,496670),('1','145','168135','359',202.00,320.00,0.00,0.00,0.00,0.00,0.00,497236),('1','145','168136','359',202.00,320.00,0.00,1816.20,366872.40,547437.00,180564.60,497237),('1','145','168277','359',202.00,320.00,0.00,2638.30,532936.60,787934.00,254997.40,497634),('1','145','168414','359',202.00,320.00,0.00,1518.30,306696.60,449883.00,143186.40,497991),('1','145','168622','359',202.00,320.00,0.00,3065.30,619190.60,917734.00,298543.40,498534),('1','145','168779','359',202.00,320.00,0.00,4082.20,824604.40,1213511.00,388906.60,498957),('1','145','169223','359',202.00,320.00,0.00,3074.80,621109.60,924929.00,303819.40,500108),('1','145','169226','359',202.00,320.00,0.00,4531.50,915363.00,1345476.00,430113.00,500115),('1','145','169229','359',202.00,320.00,0.00,910.20,183860.40,276078.00,92217.60,500122),('1','145','169283','359',202.00,320.00,0.00,3884.60,784689.20,1150495.00,365805.80,500247),('1','145','169578','359',212.00,320.00,0.00,5679.30,1204011.60,1669971.00,465959.40,501012),('1','145','169937','359',212.00,320.00,0.00,3354.00,711048.00,1019462.00,308414.00,501986),('1','145','170151','359',212.00,320.00,0.00,2492.50,528410.00,760358.00,231948.00,502522),('1','145','170345','359',212.00,320.00,0.00,5911.00,1253132.00,1718130.00,464998.00,503033),('1','145','170565','359',212.00,320.00,0.00,3349.20,710030.40,975634.00,265603.60,503615),('1','145','170671','359',212.00,320.00,0.00,6323.40,1340560.80,1822031.50,481470.70,503887),('1','145','170818','359',212.00,320.00,0.00,1272.80,269833.60,373353.00,103519.40,504265),('1','145','171001','359',212.00,320.00,0.00,4650.60,985927.20,1346599.50,360672.30,504755),('1','145','171216','359',212.00,320.00,0.00,3725.60,789827.20,1080920.00,291092.80,505341),('1','145','171538','359',212.00,320.00,0.00,3600.50,763306.00,1049781.50,286475.50,506204),('1','145','171588','359',212.00,320.00,0.00,3581.20,759214.40,1040284.00,281069.60,506328),('1','145','171777','359',212.00,320.00,0.00,1846.10,391373.20,539410.50,148037.30,506819),('1','145','171778','359',212.00,320.00,0.00,2012.20,426586.40,581569.00,154982.60,506820),('1','145','171951','359',212.00,320.00,0.00,6349.10,1346009.20,1843345.50,497336.30,507289),('1','145','172284','359',212.00,320.00,0.00,1771.20,375494.40,518711.50,143217.10,508169),('1','145','172288','359',212.00,320.00,0.00,5732.90,1215374.80,1656542.50,441167.70,508173),('1','145','172749','359',212.00,320.00,0.00,2752.90,583614.80,787478.00,203863.20,509396),('1','145','172761','359',270.00,320.00,0.00,4016.00,1084320.00,1155858.00,71538.00,509427),('1','145','172763','359',270.00,320.00,0.00,5910.60,1595862.00,1700519.50,104657.50,509431),('1','145','173129','359',270.00,320.00,0.00,5775.70,1559439.00,1665538.00,106099.00,510418),('1','145','173134','359',270.00,320.00,0.00,3844.80,1038096.00,1115515.00,77419.00,510430),('1','145','173180','359',270.00,320.00,0.00,5088.00,1373760.00,1472014.50,98254.50,510556),('1','145','174012','359',272.00,320.00,0.00,9744.00,2650368.00,2807388.50,157020.50,512752),('1','145','174016','359',272.00,320.00,0.00,5073.30,1379937.60,1472679.50,92741.90,512760),('1','145','174129','359',272.00,320.00,0.00,6154.70,1674078.40,1774970.50,100892.10,513048),('1','145','174325','359',272.00,320.00,0.00,6819.70,1854958.40,1967565.00,112606.60,513566),('1','145','174554','359',272.00,320.00,0.00,1989.00,541008.00,574799.50,33791.50,514150),('1','145','174560','359',272.00,320.00,0.00,8543.30,2323777.60,2461766.00,137988.40,514166),('1','145','174646','359',272.00,320.00,0.00,3662.50,996200.00,1059300.00,63100.00,514373),('1','145','174840','359',272.00,320.00,0.00,9348.30,2542737.60,2690554.00,147816.40,514897),('1','145','175193','359',272.00,336.00,0.00,1644.50,447304.00,513214.00,65910.00,515844),('1','145','175203','359',272.00,336.00,0.00,4438.30,1207217.60,1385327.20,178109.60,515868),('1','145','175241','359',272.00,336.00,0.00,7496.90,2039156.80,2339438.80,300282.00,515954),('1','145','175413','359',290.00,336.00,0.00,6792.20,1969738.00,2125903.60,156165.60,516404),('1','145','175596','359',290.00,336.00,0.00,5863.90,1700531.00,1828352.00,127821.00,516883),('1','145','175597','359',290.00,336.00,0.00,2588.10,750549.00,809489.60,58940.60,516884),('1','145','175879','359',290.00,336.00,0.00,13097.00,3798130.00,4085016.60,286886.60,517642),('1','145','175919','359',290.00,336.00,0.00,3836.40,1112556.00,1197211.40,84655.40,517729),('1','145','176198','359',290.00,336.00,0.00,10922.00,3167380.00,3407015.20,239635.20,518436),('1','145','176333','359',290.00,336.00,0.00,690.60,200274.00,216038.60,15764.60,518778),('1','145','176334','359',290.00,336.00,0.00,8759.50,2540255.00,2734144.20,193889.20,518779),('1','145','176551','359',290.00,336.00,0.00,10479.60,3039084.00,3270932.00,231848.00,519356),('1','145','176775','359',290.00,336.00,0.00,2603.80,755102.00,814871.40,59769.40,519964),('1','145','176776','359',290.00,336.00,0.00,6167.30,1788517.00,1927161.40,138644.40,519965),('1','145','176975','359',290.00,336.00,0.00,8072.30,2340967.00,2510253.30,169286.30,520497),('1','145','176976','359',290.00,336.00,0.00,0.00,0.00,0.00,0.00,520498),('1','145','176979','359',290.00,336.00,0.00,3044.20,882818.00,950703.80,67885.80,520502),('1','145','177619','359',290.00,336.00,0.00,1786.70,518143.00,556471.80,38328.80,522193),('1','145','178632','359',290.00,336.00,0.00,7644.00,2186184.00,2391324.00,205140.00,524873),('1','145','178635','359',286.00,336.00,0.00,6909.80,1976202.80,2152575.80,176373.00,524880),('1','145','178641','359',286.00,336.00,0.00,11632.70,3326952.20,3638423.80,311471.60,524894),('1','145','178642','359',286.00,336.00,0.00,10049.60,2874185.60,3132257.80,258072.20,524895),('1','145','178646','359',286.00,336.00,0.00,1810.60,517831.60,565669.60,47838.00,524905),('1','145','178647','359',286.00,336.00,0.00,11285.00,3227510.00,3513963.00,286453.00,524906),('1','145','178898','359',286.00,336.00,0.00,10889.90,3114511.40,3387380.30,272868.90,525555),('1','145','178899','359',286.00,336.00,0.00,9273.90,2652335.40,2891941.60,239606.20,525556),('1','145','178900','359',286.00,336.00,0.00,8896.20,2544313.20,2831857.20,287544.00,525557),('1','145','178901','359',286.00,336.00,0.00,4332.40,1239066.40,1374882.40,135816.00,525558),('1','145','179917','359',286.00,336.00,0.00,7407.00,2118402.00,2348069.50,229667.50,528271),('1','145','179922','359',286.00,336.00,0.00,8311.70,2377146.20,2640731.20,263585.00,528284),('1','145','179930','359',286.00,336.00,0.00,5524.50,1580007.00,1760020.00,180013.00,528304),('1','145','179939','359',286.00,336.00,0.00,1421.90,406663.40,452148.40,45485.00,528328),('1','145','179947','359',286.00,336.00,0.00,7640.60,2185211.60,2423289.60,238078.00,528347),('1','145','179953','359',286.00,336.00,0.00,0.00,0.00,0.00,0.00,528359),('1','145','179981','359',286.00,336.00,0.00,6346.00,1814956.00,2018582.00,203626.00,528427),('1','145','180332','359',286.00,336.00,0.00,9027.00,2581722.00,2859657.50,277935.50,529337),('1','145','180333','359',286.00,336.00,0.00,1766.10,505104.60,561711.60,56607.00,529338),('1','145','180715','359',286.00,336.00,0.00,3515.60,1005461.60,1119067.60,113606.00,530347),('1','145','180717','359',286.00,336.00,0.00,11288.80,3228596.80,3589178.80,360582.00,530351),('1','145','180719','359',306.00,336.00,0.00,0.00,0.00,0.00,0.00,530355),('1','145','181300','359',306.00,336.00,0.00,788.40,241250.40,251832.40,10582.00,531909),('1','145','181306','359',306.00,336.00,0.00,6706.00,2052036.00,2134282.00,82246.00,531924),('1','145','181308','359',306.00,336.00,0.00,6348.80,1942732.80,2021290.80,78558.00,531928),('1','145','181314','359',306.00,336.00,0.00,4931.20,1508947.20,1616270.80,107323.60,531944),('1','145','181464','359',306.00,340.00,0.00,5949.70,1820608.20,1949098.40,128490.20,532332),('1','145','182275','359',306.00,340.00,0.00,4687.50,1434375.00,1537433.60,103058.60,534488),('1','145','182278','359',306.00,340.00,0.00,4920.50,1505673.00,1612390.60,106717.60,534493),('1','145','182281','359',306.00,340.00,0.00,3209.00,981954.00,1052394.80,70440.80,534499),('1','145','182804','359',311.00,340.00,0.00,6680.60,2077666.60,2190069.60,112403.00,535892),('1','145','183365','359',311.00,340.00,0.00,5638.60,1753604.60,1849191.80,95587.20,537364),('1','145','183367','359',311.00,340.00,0.00,5844.70,1817701.70,1913999.00,96297.30,537368),('1','145','183369','359',311.00,340.00,0.00,506.80,157614.80,167118.00,9503.20,537372),('1','145','183377','359',311.00,340.00,0.00,7353.00,2286783.00,2401971.80,115188.80,537394),('1','145','183380','359',311.00,340.00,0.00,5560.60,1729346.60,1826275.40,96928.80,537401),('1','145','183384','359',311.00,340.00,0.00,9546.00,2968806.00,3129801.20,160995.20,537410),('1','145','183385','359',311.00,340.00,0.00,2434.50,757129.50,795481.00,38351.50,537411),('1','145','183388','359',311.00,340.00,0.00,2423.30,753646.30,794851.00,41204.70,537418),('1','145','183390','359',311.00,340.00,0.00,7688.90,2391247.90,2519929.00,128681.10,537422),('1','145','183392','359',311.00,340.00,0.00,6974.70,2169131.70,2281973.00,112841.30,537426),('1','145','184342','359',311.00,340.00,0.00,0.00,0.00,0.00,0.00,539945),('1','145','184859','359',311.00,340.00,0.00,0.00,0.00,0.00,0.00,541330),('1','145','184963','359',311.00,340.00,0.00,16200.60,5038386.60,5297053.90,258667.30,541606),('1','145','184965','359',311.00,340.00,0.00,8485.20,2638897.20,2771203.40,132306.20,541610),('1','145','184973','359',311.00,340.00,0.00,4572.30,1421985.30,1494440.80,72455.50,541632),('1','145','184979','359',311.00,340.00,0.00,14758.60,4589924.60,4835950.60,246026.00,541647),('1','145','184983','359',311.00,340.00,0.00,5583.00,1736313.00,1827009.00,90696.00,541655),('1','145','184986','359',311.00,340.00,0.00,5440.10,1691871.10,1781041.00,89169.90,541662),('1','145','184997','359',311.00,340.00,0.00,8050.90,2503829.90,2635020.60,131190.70,541689),('1','145','185087','359',311.00,340.00,0.00,9249.70,2876656.70,3031206.80,154550.10,541918),('1','145','185088','359',311.00,340.00,0.00,9696.50,3015611.50,3172135.80,156524.30,541919),('1','145','185245','359',311.00,340.00,0.00,1523.90,473932.90,500081.40,26148.50,542313),('1','145','185246','359',311.00,340.00,0.00,5626.00,1749686.00,1843307.60,93621.60,542314),('1','145','185247','359',311.00,340.00,0.00,0.00,0.00,0.00,0.00,542315),('1','145','185454','359',311.00,340.00,0.00,8707.90,2708156.90,2841387.20,133230.30,542866),('1','145','186060','359',311.00,340.00,0.00,9950.40,3094574.40,3257883.60,163309.20,544480),('1','145','186062','359',311.00,340.00,0.00,2426.50,754641.50,793734.00,39092.50,544484),('1','145','186064','359',311.00,340.00,0.00,5857.80,1821775.80,1916704.40,94928.60,544488),('1','145','186065','359',311.00,340.00,0.00,8002.90,2488901.90,2620695.60,131793.70,544489),('1','145','186300','359',311.00,340.00,0.00,5411.90,1683100.90,1772130.60,89029.70,545105),('1','145','186301','359',311.00,340.00,0.00,2453.80,763131.80,803346.40,40214.60,545106),('1','145','186678','359',311.00,340.00,0.00,0.00,0.00,0.00,0.00,546088),('1','145','186728','359',311.00,340.00,0.00,8421.40,2619055.40,2759064.20,140008.80,546226),('1','145','186729','359',311.00,340.00,0.00,8656.20,2692078.20,2835422.80,143344.60,546227),('1','145','186960','359',311.00,340.00,0.00,7860.00,2444460.00,2573354.20,128894.20,546802),('1','145','186961','359',311.00,340.00,0.00,423.70,131770.70,140642.00,8871.30,546803),('1','145','187302','359',311.00,340.00,0.00,9983.40,3104837.40,3274420.80,169583.40,547711),('1','145','187307','359',311.00,340.00,0.00,3792.90,1179591.90,1243579.20,63987.30,547722),('1','145','187539','359',311.00,340.00,0.00,8960.60,2786746.60,2936671.80,149925.20,548339),('1','145','187581','359',311.00,340.00,0.00,6194.40,1926458.40,2030591.20,104132.80,548437),('1','145','187779','359',311.00,340.00,0.00,106.80,33214.80,35323.60,2108.80,548974),('1','145','187807','359',311.00,340.00,0.00,8316.00,2586276.00,2723733.60,137457.60,549035),('1','145','188019','359',311.00,340.00,0.00,7487.30,2328550.30,2458026.60,129476.30,549588),('1','145','188186','359',311.00,340.00,0.00,1607.80,500025.80,526129.20,26103.40,550037),('1','145','188222','359',311.00,340.00,0.00,8653.30,2691176.30,2839063.60,147887.30,550113),('1','145','188431','359',311.00,340.00,0.00,5115.00,1590765.00,1677591.80,86826.80,550655),('1','145','188580','359',311.00,340.00,0.00,5495.30,1709038.30,1804498.00,95459.70,551042),('1','145','188633','359',311.00,340.00,0.00,3498.90,1088157.90,1149216.40,61058.50,551163),('1','145','188806','359',311.00,340.00,0.00,9954.50,3095849.50,3260477.00,164627.50,551630),('1','145','189013','359',311.00,340.00,0.00,5285.00,1643635.00,1732239.20,88604.20,552176),('1','145','189210','359',311.00,340.00,0.00,8549.10,2658770.10,2803095.00,144324.90,552686),('1','145','189530','359',311.00,340.00,0.00,429.80,133667.80,141195.60,7527.80,553525),('1','145','189586','359',311.00,340.00,0.00,3902.80,1213770.80,1284743.40,70972.60,553678),('1','145','189629','359',311.00,340.00,0.00,6884.00,2140924.00,2255771.00,114847.00,553775),('1','145','189818','359',311.00,340.00,0.00,7317.30,2275680.30,2399643.40,123963.10,554263),('1','145','189993','359',311.00,340.00,0.00,1039.70,323346.70,340912.00,17565.30,554736),('1','145','190587','359',305.00,340.00,0.00,525.30,160216.50,171896.00,11679.50,556299),('1','145','190589','359',305.00,340.00,0.00,8213.00,2504965.00,2692052.20,187087.20,556303),('1','145','190614','359',305.00,340.00,0.00,4386.60,1337913.00,1442542.00,104629.00,556373),('1','145','190671','359',305.00,340.00,0.00,4315.80,1316319.00,1419689.60,103370.60,556508),('1','145','190889','359',305.00,340.00,0.00,5142.80,1568554.00,1685164.60,116610.60,557081),('1','145','191249','359',305.00,340.00,0.00,2770.50,845002.50,898192.00,53189.50,558041),('1','145','191252','359',305.00,340.00,0.00,0.00,0.00,0.00,0.00,558048),('1','145','191254','359',305.00,340.00,0.00,2830.00,863150.00,911264.00,48114.00,558051),('1','145','191295','359',305.00,340.00,0.00,7699.60,2348378.00,2487506.00,139128.00,558145),('1','145','191522','359',305.00,340.00,0.00,3102.20,946171.00,1002582.00,56411.00,558735),('1','145','191721','359',305.00,340.00,0.00,5026.70,1533143.50,1623690.00,90546.50,559270),('1','145','191938','359',305.00,340.00,0.00,4874.00,1486570.00,1569416.00,82846.00,559863),('1','145','192033','359',305.00,340.00,0.00,3609.90,1101019.50,1167150.00,66130.50,560114),('1','145','192217','359',305.00,340.00,0.00,4811.30,1467446.50,1556976.00,89529.50,560596),('1','145','192526','359',305.00,340.00,0.00,3423.50,1044167.50,1110004.00,65836.50,561415),('1','145','192719','359',305.00,340.00,0.00,5008.20,1527501.00,1622404.00,94903.00,561916),('1','145','193124','359',305.00,340.00,0.00,4872.20,1486021.00,1577620.00,91599.00,562979),('1','145','193172','359',305.00,340.00,0.00,7157.30,2182976.50,2309756.00,126779.50,563094),('1','145','193412','359',305.00,340.00,0.00,6498.30,1981981.50,2099468.00,117486.50,563724),('1','145','193660','359',305.00,340.00,0.00,5473.70,1669478.50,1771666.00,102187.50,564346),('1','145','193856','359',305.00,340.00,0.00,6079.00,1854095.00,1966668.00,112573.00,564854),('1','145','194165','359',305.00,340.00,0.00,1616.80,493124.00,524072.00,30948.00,565643),('1','145','194169','359',305.00,340.00,0.00,4573.50,1394917.50,1479618.00,84700.50,565653),('1','145','194294','359',305.00,340.00,0.00,6879.80,2098339.00,2235086.00,136747.00,565977),('1','145','194520','359',305.00,340.00,0.00,3648.70,1112853.50,1177734.00,64880.50,566536),('1','145','194679','359',305.00,340.00,0.00,7553.50,2303817.50,2443860.00,140042.50,566948),('1','145','194891','359',305.00,340.00,0.00,1736.20,529541.00,560054.00,30513.00,567516),('1','145','194895','359',305.00,340.00,0.00,6077.20,1853546.00,1960062.00,106516.00,567524),('1','145','195084','359',305.00,340.00,0.00,6365.10,1941355.50,2058686.00,117330.50,568016),('1','145','195309','359',305.00,340.00,0.00,5350.40,1631872.00,1725626.00,93754.00,568598),('1','145','195462','359',305.00,340.00,0.00,0.00,0.00,0.00,0.00,568992),('1','145','195528','359',305.00,340.00,0.00,7521.70,2294118.50,2428144.00,134025.50,569157),('1','145','195786','359',305.00,340.00,0.00,6921.80,2111149.00,2245922.00,134773.00,569801),('1','145','196055','359',305.00,340.00,0.00,5251.50,1601707.50,1693770.00,92062.50,570484),('1','145','196239','359',305.00,340.00,0.00,9536.10,2908510.50,3079272.00,170761.50,570944),('1','145','196538','359',305.00,340.00,0.00,754.20,230031.00,247488.00,17457.00,571717),('1','145','196542','359',305.00,340.00,0.00,7271.00,2217655.00,2345842.00,128187.00,571726),('1','145','196683','359',305.00,340.00,0.00,9685.30,2954016.50,3124487.60,170471.10,572081),('1','145','196895','359',305.00,340.00,0.00,7234.90,2206644.50,2334334.00,127689.50,572647),('1','145','197034','359',305.00,340.00,0.00,4769.50,1454697.50,1539446.00,84748.50,573002),('1','145','197171','359',305.00,340.00,0.00,1595.10,486505.50,516572.00,30066.50,573370),('1','145','197541','359',294.00,340.00,0.00,7443.50,2188389.00,2407200.00,218811.00,574222),('1','145','197819','359',294.00,340.00,0.00,6942.10,2040977.40,2248502.00,207524.60,574987),('1','145','197821','359',294.00,340.00,0.00,3868.80,1137427.20,1249490.00,112062.80,574990),('1','145','197978','359',294.00,340.00,0.00,4676.10,1374773.40,1508384.00,133610.60,575398),('1','145','198079','359',294.00,340.00,0.00,1958.20,575710.80,632782.00,57071.20,575664),('1','145','198123','359',294.00,340.00,0.00,4944.70,1453741.80,1603792.00,150050.20,575764),('1','145','198361','359',294.00,340.00,0.00,6219.00,1828386.00,2008548.00,180162.00,576381),('1','145','198580','359',294.00,340.00,0.00,6830.40,2008137.60,2203978.00,195840.40,576951),('1','145','198723','359',294.00,340.00,0.00,0.00,0.00,0.00,0.00,577338),('1','145','198791','359',294.00,340.00,0.00,9268.80,2725027.20,2996152.00,271124.80,577467),('1','145','199028','359',294.00,340.00,0.00,4272.00,1255968.00,1380384.00,124416.00,578087),('1','145','199218','359',294.00,340.00,0.00,8379.60,2463602.40,2708322.00,244719.60,578559),('1','145','199442','359',294.00,340.00,0.00,6899.50,2028453.00,2226502.00,198049.00,579111),('1','145','199834','359',294.00,340.00,0.00,1179.20,346684.80,378636.00,31951.20,580082),('1','145','199837','359',294.00,340.00,0.00,6306.40,1854081.60,2038230.00,184148.40,580088),('1','145','199876','359',294.00,340.00,0.00,6938.70,2039977.80,2246174.00,206196.20,580177),('1','145','200102','359',294.00,340.00,0.00,6823.40,2006079.60,2206250.00,200170.40,580773),('1','145','200309','359',294.00,340.00,0.00,8218.30,2416180.20,2660312.00,244131.80,581307),('1','145','200454','359',294.00,340.00,0.00,452.40,133005.60,146396.00,13390.40,581700),('1','145','200534','359',294.00,340.00,0.00,4298.70,1263817.80,1389004.00,125186.20,581892),('1','145','200709','359',294.00,340.00,0.00,7022.30,2064556.20,2270542.00,205985.80,582353),('1','145','200930','359',294.00,340.00,0.00,10125.90,2977014.60,3265084.00,288069.40,582914),('1','145','201084','359',294.00,340.00,0.00,867.40,255015.60,277986.00,22970.40,583318),('1','145','201124','359',294.00,340.00,0.00,12458.40,3662769.60,4011546.00,348776.40,583400),('1','145','202325','359',304.00,340.00,0.00,0.00,0.00,0.00,0.00,586544),('1','145','202330','359',304.00,340.00,0.00,18506.30,5625915.20,5951780.00,325864.80,586554),('1','145','202334','359',304.00,360.00,0.00,5625.70,1710212.80,1881213.00,171000.20,586563),('1','145','202379','359',304.00,360.00,0.00,9131.40,2775945.60,3044469.00,268523.40,586689),('1','145','202383','359',304.00,360.00,0.00,9601.70,2918916.80,3186192.00,267275.20,586699),('1','145','202385','359',304.00,360.00,0.00,5557.00,1689328.00,1857087.00,167759.00,586703),('1','145','202509','359',306.00,360.00,0.00,0.00,0.00,0.00,0.00,587021),('1','145','202534','359',360.00,360.00,0.00,5139.80,1616467.10,1777638.80,161171.70,587084),('1','145','202660','359',314.50,376.00,0.00,13602.20,4277891.90,4681102.40,403210.50,587397),('1','145','202866','359',314.50,376.00,0.00,10132.70,3186734.15,3487965.20,301231.05,587927),('1','145','203115','359',314.50,376.00,0.00,5864.90,1844511.05,2018427.20,173916.15,588579),('1','145','203266','359',314.50,376.00,0.00,3687.30,1159655.85,1277906.40,118250.55,588989),('1','145','203318','359',314.50,376.00,0.00,10682.80,3359740.60,3679194.40,319453.80,589115),('1','145','203575','359',314.50,376.00,0.00,6649.10,2091141.95,2276228.00,185086.05,589760),('1','145','203810','359',314.50,416.00,0.00,7062.90,2221282.05,2751772.70,530490.65,590371),('1','145','203928','359',314.50,416.00,0.00,0.00,0.00,0.00,0.00,590693),('1','145','204002','359',314.50,416.00,0.00,4284.60,1347506.70,1682675.90,335169.20,590860),('1','145','204200','359',314.50,416.00,0.00,6160.00,1937320.00,2410027.60,472707.60,591386),('1','145','204442','359',314.50,416.00,0.00,2675.40,841413.30,1056571.20,215157.90,592007),('1','145','204578','359',314.50,416.00,0.00,505.30,158916.85,199714.40,40797.55,592370),('1','145','204637','359',314.50,416.00,0.00,4562.70,1434969.15,1785372.60,350403.45,592503),('1','145','204845','359',314.50,416.00,0.00,4369.10,1374081.95,1727648.70,353566.75,593006),('1','145','205076','359',314.50,416.00,0.00,3053.10,960199.95,1192341.60,232141.65,593593),('1','145','205245','359',314.50,416.00,0.00,5109.20,1606843.40,2003953.70,397110.30,594044),('1','145','205485','359',314.50,416.00,0.00,4440.10,1396411.45,1748988.30,352576.85,594648),('1','145','205736','359',314.50,416.00,0.00,3268.50,1027943.25,1291009.30,263066.05,595311),('1','145','205957','359',314.50,416.00,0.00,3563.10,1120594.95,1408525.40,287930.45,595879),('1','145','206227','359',314.50,416.00,0.00,1793.40,564024.30,708262.30,144238.00,596574),('1','145','206324','359',314.50,416.00,0.00,928.50,292013.25,367873.00,75859.75,596827),('1','145','206325','359',315.00,416.00,0.00,0.00,0.00,0.00,0.00,596828),('1','145','206369','359',314.50,416.00,0.00,7573.20,2381771.40,2962795.80,581024.40,596929),('1','145','206602','359',314.50,416.00,0.00,2410.60,758133.70,949263.30,191129.60,597520),('1','145','206815','359',314.50,416.00,0.00,3962.30,1246143.35,1561058.00,314914.65,598071),('1','145','207034','359',314.50,416.00,0.00,3185.40,1001808.30,1260181.40,258373.10,598644),('1','145','207254','359',314.50,416.00,0.00,4058.30,1276335.35,1604283.10,327947.75,599213),('1','145','207487','359',314.50,416.00,0.00,1706.80,536788.60,678052.30,141263.70,599816),('1','145','207649','359',314.50,416.00,0.00,1088.40,342301.80,435020.70,92718.90,600233),('1','145','207748','359',314.50,416.00,0.00,3577.60,1125155.20,1412883.40,287728.20,600471),('1','145','207914','359',314.50,416.00,0.00,5509.80,1732832.10,2177882.10,445050.00,600893),('1','145','208071','359',319.00,416.00,0.00,0.00,0.00,0.00,0.00,601310),('1','145','208144','359',319.00,416.00,0.00,3324.90,1060643.10,1308665.40,248022.30,601484),('1','145','208339','359',319.00,416.00,0.00,2552.80,814343.20,1005454.90,191111.70,601991),('1','145','208517','359',319.00,416.00,0.00,2011.80,641764.20,799842.10,158077.90,602454),('1','145','208566','359',319.00,416.00,0.00,3823.70,1219760.30,1516972.20,297211.90,602568),('1','145','208769','359',319.00,416.00,0.00,3038.30,969217.70,1208501.70,239284.00,603094),('1','145','209006','359',330.00,416.00,0.00,4265.80,1407714.00,1717909.90,310195.90,603687),('1','145','209220','359',330.00,426.00,0.00,7414.50,2446785.00,2966993.90,520208.90,604242),('1','145','209449','359',304.00,431.00,0.00,3269.40,993897.60,1336993.00,343095.40,604816),('1','145','209612','359',304.00,431.00,0.00,4541.50,1380616.00,1840448.30,459832.30,605257),('1','145','209613','359',304.00,431.00,0.00,0.00,0.00,0.00,0.00,605258),('1','145','209684','359',304.00,431.00,0.00,5266.50,1601016.00,2127168.50,526152.50,605420),('1','145','209874','359',314.00,451.00,0.00,6985.30,2193384.20,2975536.50,782152.30,605915),('1','145','210106','359',314.00,451.00,0.00,3643.60,1144090.40,1559588.40,415498.00,606523),('1','145','210596','359',314.00,451.00,0.00,0.00,0.00,0.00,0.00,607799),('1','145','210779','359',364.00,451.00,0.00,5002.40,1820873.60,2143264.10,322390.50,608280),('1','145','210963','359',364.00,451.00,0.00,4913.60,1788550.40,2117366.80,328816.40,608747),('1','145','211204','359',364.00,451.00,0.00,2728.90,993319.60,1169921.20,176601.60,609363),('1','145','211382','359',364.00,451.00,0.00,4983.40,1813957.60,2134220.80,320263.20,609836),('1','145','211652','359',364.00,451.00,0.00,2313.80,842223.20,992494.70,150271.50,610534),('1','145','211785','359',364.00,451.00,0.00,3834.10,1395612.40,1647726.60,252114.20,610865),('1','145','211998','359',364.00,451.00,0.00,3123.80,1137063.20,1342881.30,205818.10,611421),('1','145','212240','359',364.00,451.00,0.00,3993.90,1453779.60,1715192.90,261413.30,612052),('1','145','212460','359',364.00,451.00,0.00,1334.90,485903.60,569914.60,84011.00,612638),('1','145','212616','359',364.00,451.00,0.00,4437.40,1615213.60,1911404.60,296191.00,613066),('1','145','212707','359',364.00,451.00,0.00,2401.30,874073.20,1026938.30,152865.10,613294),('1','145','212878','359',364.00,451.00,0.00,4121.10,1500080.40,1765482.80,265402.40,613737),('1','145','213133','359',364.00,451.00,0.00,4257.60,1549766.40,1827345.00,277578.60,614404),('1','145','213398','359',364.00,451.00,0.00,4648.90,1692199.60,1984595.10,292395.50,615079),('1','145','213704','359',364.00,451.00,0.00,1178.50,428974.00,505934.70,76960.70,615899),('1','145','213706','359',364.00,451.00,0.00,1904.90,693383.60,829371.60,135988.00,615902),('1','145','213894','359',364.00,451.00,0.00,3768.90,1371879.60,1621207.50,249327.90,616394),('1','145','214100','359',364.00,451.00,0.00,4549.50,1656018.00,1970034.10,314016.10,616928),('1','145','214367','359',364.00,451.00,0.00,878.50,319774.00,380126.90,60352.90,617616),('1','145','214542','359',364.00,451.00,0.00,5072.40,1846353.60,2175423.10,329069.50,618072),('1','145','214790','359',364.00,451.00,0.00,4988.80,1815923.20,2150308.60,334385.40,618717),('1','145','215017','359',364.00,451.00,0.00,3578.60,1302610.40,1540664.60,238054.20,619310),('1','145','215334','359',364.00,451.00,0.00,811.20,295276.80,399936.00,104659.20,620133),('1','145','215344','359',364.00,510.00,0.00,0.00,0.00,0.00,0.00,620157),('1','145','215363','359',364.00,510.00,0.00,2350.00,855400.00,1150668.00,295268.00,620210),('1','145','215449','359',400.00,510.00,0.00,3068.40,1227360.00,1508580.00,281220.00,620414),('1','145','215681','359',400.00,510.00,0.00,5029.00,2011600.00,2465241.00,453641.00,621021),('1','145','215933','359',400.00,510.00,0.00,2391.90,956760.00,1172361.00,215601.00,621659),('1','145','216192','359',400.00,510.00,0.00,3738.70,1495480.00,1831347.00,335867.00,622341),('1','145','216328','359',400.00,510.00,0.00,3818.20,1527280.00,1862199.00,334919.00,622692),('1','145','216562','359',400.00,510.00,0.00,3729.60,1491840.00,1824321.00,332481.00,623311),('1','145','216796','359',400.00,510.00,0.00,3334.40,1333760.00,1638672.00,304912.00,623926),('1','145','217068','359',400.00,510.00,0.00,187.80,68359.20,96492.00,28132.80,624635),('1','145','217082','359',364.00,540.00,0.00,3701.20,1347236.80,1891780.00,544543.20,624673),('1','145','217283','359',384.00,540.00,0.00,5862.40,2251161.60,2992364.00,741202.40,625204),('1','145','217577','359',384.00,540.00,0.00,2222.40,853401.60,1138096.00,284694.40,625969),('1','145','217716','359',384.00,540.00,0.00,4615.90,1772505.60,2366038.00,593532.40,626327),('1','145','218012','359',384.00,540.00,0.00,2392.00,918528.00,1227232.00,308704.00,627110),('1','145','218409','359',384.00,540.00,0.00,1333.60,512102.40,673416.00,161313.60,628171),('1','145','218486','359',384.00,540.00,0.00,2259.40,867609.60,1164208.00,296598.40,628352),('1','145','218629','359',384.00,540.00,0.00,871.60,334694.40,453704.00,119009.60,628738),('1','145','218634','359',384.00,540.00,0.00,0.00,0.00,0.00,0.00,628751),('1','145','218697','359',384.00,540.00,0.00,3204.20,1230412.80,1648324.00,417911.20,628898),('1','145','218916','359',384.00,540.00,0.00,2978.90,1143897.60,1549286.00,405388.40,629475),('1','145','219159','359',384.00,540.00,0.00,2637.60,1012838.40,1350672.00,337833.60,630106),('1','145','219371','359',384.00,540.00,0.00,3500.30,1344115.20,1794962.00,450846.80,630662),('1','145','219608','359',384.00,540.00,0.00,2892.20,1110604.80,1487932.00,377327.20,631286),('1','145','219817','359',384.00,540.00,0.00,2649.30,1017331.20,1362446.00,345114.80,631835),('1','145','220047','359',384.00,540.00,0.00,2935.40,1127193.60,1516596.00,389402.40,632455),('1','145','220262','359',386.00,500.00,0.00,447.50,172735.00,209690.00,36955.00,633019),('1','145','220477','359',386.00,500.00,0.00,2712.60,1047063.60,1265176.00,218112.40,633579),('1','145','220518','359',386.00,500.00,0.00,6000.30,2316115.80,2813878.00,497762.20,633691),('1','145','220736','359',384.00,500.00,0.00,2750.20,1056076.80,1291572.00,235495.20,634254),('1','145','220925','359',384.00,500.00,0.00,4634.90,1779801.60,2186886.00,407084.40,634743),('1','145','221153','359',384.00,500.00,0.00,4655.40,1787673.60,2205332.00,417658.40,635331),('1','145','221431','359',384.00,500.00,0.00,4617.00,1772928.00,2184128.00,411200.00,636062),('1','145','221631','359',384.00,500.00,0.00,3199.50,1228608.00,1516286.00,287678.00,636584),('1','145','221795','359',384.00,500.00,0.00,767.20,294604.80,367712.00,73107.20,637027),('1','145','221862','359',384.00,500.00,0.00,3212.60,1233638.40,1539896.00,306257.60,637182),('1','145','222061','359',384.00,500.00,0.00,4805.70,1845388.80,2297250.00,451861.20,637713),('1','145','222308','359',414.00,500.00,0.00,2104.40,871221.60,994844.00,123622.40,638334),('1','145','222496','359',414.00,500.00,0.00,3290.10,1362101.40,1568942.00,206840.60,638818),('1','145','222727','359',414.00,500.00,0.00,3403.60,1409090.40,1619588.00,210497.60,639436),('1','145','222960','359',414.00,500.00,0.00,3925.10,1624991.40,1848822.00,223830.60,640062),('1','145','223138','359',414.00,500.00,0.00,0.00,0.00,0.00,0.00,640540),('1','145','223186','359',414.00,540.00,0.00,1023.10,423563.40,539734.00,116170.60,640638),('1','145','223381','359',414.00,540.00,0.00,883.60,365810.40,460536.00,94725.60,641127),('1','145','223435','359',414.00,540.00,0.00,3111.60,1288202.40,1600588.00,312385.60,641242),('1','145','223644','359',414.00,540.00,0.00,3666.70,1518013.80,1895962.00,377948.20,641786),('1','145','223906','359',414.00,540.00,0.00,2505.10,1037111.40,1277586.00,240474.60,642455),('1','145','224089','359',414.00,540.00,0.00,2984.80,1235707.20,1548940.00,313232.80,642933),('1','145','224310','359',414.00,540.00,0.00,3521.40,1457859.60,1802428.00,344568.40,643507),('1','145','224532','359',414.00,540.00,0.00,2468.00,1021752.00,1275456.00,253704.00,644099),('1','145','224744','359',414.00,540.00,0.00,921.90,381666.60,472534.00,90867.40,644654),('1','145','224787','359',414.00,540.00,0.00,4530.90,1875792.60,2311886.00,436093.40,644738),('1','145','225024','359',414.00,540.00,0.00,3620.70,1498969.80,1868330.00,369360.20,645351),('1','145','225269','359',414.00,540.00,0.00,6187.30,2561542.20,3147382.00,585839.80,645989),('1','145','225515','359',414.00,540.00,0.00,3859.20,1597708.80,1966596.00,368887.20,646615),('1','145','225748','359',464.00,540.00,0.00,580.90,269537.60,295686.00,26148.40,647228),('1','145','225749','359',464.00,540.00,0.00,7974.90,3700353.60,4024894.00,324540.40,647229),('1','145','225981','359',464.00,540.00,0.00,3199.60,1484614.40,1647012.00,162397.60,647838),('1','145','226235','359',464.00,540.00,0.00,4462.30,2070507.20,2277990.00,207482.80,648500),('1','145','226478','359',464.00,540.00,0.00,4161.70,1931028.80,2342683.00,411654.20,649119),('1','145','226741','359',464.00,590.00,0.00,2368.00,1098752.00,1358296.00,259544.00,649794),('1','145','226965','359',464.00,590.00,0.00,1605.40,744905.60,900170.00,155264.40,650389),('1','145','227083','359',464.00,590.00,0.00,1697.40,787593.60,980550.00,192956.40,650690),('1','145','227219','359',464.00,590.00,0.00,2484.40,1152761.60,1391656.00,238894.40,651040),('1','145','227379','359',464.00,590.00,0.00,3625.60,1682278.40,2055364.00,373085.60,651448),('1','145','227612','359',464.00,590.00,0.00,2753.80,1277763.20,1556742.00,278978.80,652052),('1','145','227858','359',464.00,590.00,0.00,2808.10,1302958.40,1594827.00,291868.60,652690),('1','145','228118','359',464.00,590.00,0.00,3952.60,1834006.40,2227994.00,393987.60,653380),('1','145','228354','359',464.00,590.00,0.00,4144.90,1923233.60,2349543.00,426309.40,653988),('1','145','228534','359',464.00,590.00,0.00,2622.70,1216932.80,1487549.00,270616.20,654445),('1','145','228682','359',464.00,590.00,0.00,0.00,0.00,0.00,0.00,654835),('1','145','228776','359',488.00,590.00,0.00,4047.70,1975277.60,2258479.00,283201.40,655062),('1','145','228947','359',488.00,590.00,0.00,4434.50,2164036.00,2492015.00,327979.00,655497),('1','145','229176','359',488.00,590.00,0.00,5099.00,2488312.00,2872674.00,384362.00,656106),('1','145','229420','359',488.00,630.00,0.00,4094.10,1997920.80,2465783.00,467862.20,656734),('1','145','229685','359',488.00,630.00,0.00,3726.20,1818385.60,2267314.00,448928.40,657407),('1','145','229847','359',488.00,630.00,0.00,0.00,0.00,0.00,0.00,657840),('1','145','229893','359',488.00,630.00,0.00,2623.90,1280463.20,1597341.00,316877.80,657943),('1','145','230093','359',488.00,630.00,0.00,4229.50,2063996.00,2541665.00,477669.00,658457),('1','145','230329','359',488.00,630.00,0.00,5634.10,2749440.80,3376455.00,627014.20,659067),('1','145','230491','359',507.00,630.00,0.00,0.00,0.00,0.00,0.00,659503),('1','145','230537','359',507.00,630.00,0.00,1756.00,890292.00,1047288.00,156996.00,659604),('1','145','231564','359',515.00,630.00,0.00,0.00,0.00,0.00,0.00,662336),('1','145','231646','359',525.00,680.00,0.00,5463.20,2868180.00,3549300.00,681120.00,662531),('1','145','231904','359',525.00,680.00,0.00,4733.10,2484877.50,3098280.00,613402.50,663236),('1','145','232140','359',525.00,680.00,0.00,3433.70,1802692.50,2231336.00,428643.50,663853),('1','145','232275','359',525.00,680.00,0.00,0.00,0.00,0.00,0.00,664215),('1','145','232361','359',525.00,680.00,0.00,6778.40,3558660.00,4414844.00,856184.00,664422),('1','145','232603','359',525.00,680.00,0.00,4192.90,2201272.50,2736468.00,535195.50,665067),('1','145','232729','359',525.00,680.00,0.00,2060.80,1081920.00,1350604.00,268684.00,665407),('1','145','232857','359',525.00,680.00,0.00,3948.80,2073120.00,2584364.00,511244.00,665743),('1','145','233128','359',524.00,680.00,0.00,4305.40,2256029.60,2810588.00,554558.40,666440),('1','145','233394','359',524.00,680.00,0.00,5155.60,2701534.40,3358036.00,656501.60,667152),('1','145','233621','359',524.00,680.00,0.00,1635.40,856949.60,1065100.00,208150.40,667740),('1','145','233714','359',524.00,680.00,0.00,5944.00,3114656.00,3869276.00,754620.00,667986),('1','145','233882','359',524.00,680.00,0.00,3460.60,1813354.40,2245816.00,432461.60,668420),('1','145','234140','359',555.00,680.00,0.00,4349.90,2414194.50,2856032.00,441837.50,669114),('1','145','234319','359',555.00,680.00,0.00,6831.70,3791593.50,4441684.00,650090.50,669581),('1','145','234580','359',555.00,710.00,0.00,2042.40,1133532.00,1423472.00,289940.00,670274),('1','145','234845','359',555.00,710.00,0.00,2284.00,1267620.00,1582224.00,314604.00,670971),('1','145','235090','359',555.00,710.00,0.00,497.30,276001.50,341903.00,65901.50,671643),('1','145','235118','359',555.00,710.00,0.00,3083.60,1711398.00,2109064.00,397666.00,671711),('1','145','235338','359',555.00,710.00,0.00,3568.80,1980684.00,2459692.00,479008.00,672278),('1','145','235574','359',555.00,710.00,0.00,2565.80,1424019.00,1749746.00,325727.00,672883),('1','145','235772','359',555.00,710.00,0.00,3887.00,2157285.00,2655506.00,498221.00,673397),('1','145','236039','359',555.00,710.00,0.00,3381.50,1876732.50,2320113.00,443380.50,674104),('1','145','236247','359',555.00,710.00,0.00,3327.00,1846485.00,2286238.00,439753.00,674652),('1','145','236526','359',555.00,710.00,0.00,3771.30,2093071.50,2582007.00,488935.50,675392),('1','145','236749','359',555.00,710.00,0.00,2184.90,1212619.50,1512867.00,300247.50,675963),('1','145','236982','359',555.00,710.00,0.00,3941.80,2187699.00,2709814.00,522115.00,676566),('1','145','237215','359',555.00,710.00,0.00,2304.50,1278997.50,1576111.00,297113.50,677161),('1','145','237404','359',555.00,710.00,0.00,2663.20,1478076.00,1836496.00,358420.00,677651),('1','145','237626','359',555.00,710.00,0.00,27.50,15262.50,19525.00,4262.50,678232),('1','145','237635','359',555.00,690.00,0.00,3182.10,1766065.50,2118389.00,352323.50,678254),('1','145','237888','359',555.00,690.00,0.00,3264.50,1811797.50,2181201.00,369403.50,678911),('1','145','238143','359',550.00,690.00,0.00,3100.60,1705330.00,2058534.00,353204.00,679571),('1','145','238298','359',550.00,690.00,0.00,634.40,348920.00,417956.00,69036.00,679979),('1','145','238371','359',550.00,690.00,0.00,3591.90,1975545.00,2387823.00,412278.00,680154),('1','145','238620','359',550.00,690.00,0.00,5788.80,3183840.00,3820968.00,637128.00,680809),('1','145','238879','359',550.00,690.00,0.00,3556.30,1955965.00,2345591.00,389626.00,681478),('1','145','239080','359',555.00,710.00,0.00,5162.20,2865021.00,3515958.00,650937.00,681996),('1','145','239312','359',555.00,710.00,0.00,911.20,505716.00,624312.00,118596.00,682600),('1','145','239378','359',555.00,710.00,0.00,1978.40,1098012.00,1364220.00,266208.00,682780),('1','145','239541','359',555.00,710.00,0.00,2662.50,1477687.50,1826231.00,348543.50,683201),('1','145','239791','359',555.00,710.00,0.00,2730.30,1515316.50,1876773.00,361456.50,683851),('1','145','240012','359',555.00,710.00,0.00,2744.80,1523364.00,1881536.00,358172.00,684420),('1','145','240142','359',555.00,710.00,0.00,0.00,0.00,0.00,0.00,684780),('1','145','240212','359',555.00,710.00,0.00,3818.10,2119045.50,2626783.00,507737.50,684939),('1','145','240494','359',555.00,710.00,0.00,2405.50,1335052.50,1647001.00,311948.50,685674),('1','145','240705','359',555.00,710.00,0.00,1859.00,1031745.00,1288706.00,256961.00,686183),('1','145','240983','359',555.00,710.00,0.00,1466.90,814129.50,1004455.00,190325.50,686928),('1','145','241094','359',555.00,710.00,0.00,1396.10,774835.50,961615.00,186779.50,687224),('1','145','241233','359',578.00,710.00,0.00,2798.30,1617417.40,1929141.00,311723.60,687584),('1','145','241501','359',578.00,710.00,0.00,2576.20,1489043.60,1776342.00,287298.40,688301),('1','145','241751','359',578.00,710.00,0.00,2290.40,1323851.20,1584736.00,260884.80,688963),('1','145','241993','359',578.00,710.00,0.00,3963.60,2290960.80,2735544.00,444583.20,689589),('1','145','242263','359',578.00,710.00,0.00,1403.30,778831.50,921157.00,142325.50,690284),('1','145','242300','359',555.00,690.00,0.00,1097.20,608946.00,732996.00,124050.00,690376),('1','145','242441','359',555.00,690.00,0.00,3050.60,1693083.00,2035258.00,342175.00,690740),('1','145','242685','359',555.00,690.00,0.00,2707.90,1502884.50,1822703.00,319818.50,691378),('1','145','242935','359',555.00,690.00,0.00,3394.10,1883725.50,2264249.00,380523.50,692034),('1','145','243155','359',555.00,690.00,0.00,3013.60,1672548.00,2021940.00,349392.00,692605),('1','145','243380','359',570.00,690.00,0.00,710.70,405099.00,467403.00,62304.00,693203),('1','145','243465','359',570.00,690.00,0.00,1644.30,937251.00,1119615.00,182364.00,693417),('1','145','243611','359',570.00,690.00,0.00,4207.00,2397990.00,2831990.00,434000.00,693795),('1','145','243905','359',570.00,690.00,0.00,2240.40,1277028.00,1492544.00,215516.00,694555),('1','145','244067','359',570.00,690.00,0.00,2651.60,1511412.00,1782408.00,270996.00,694968),('1','145','244305','359',570.00,690.00,0.00,3018.40,1720488.00,2035792.00,315304.00,695595),('1','145','244534','359',570.00,690.00,0.00,2455.60,1399692.00,1652272.00,252580.00,696184),('1','145','244764','359',570.00,690.00,0.00,2240.80,1277256.00,1511812.00,234556.00,696790),('1','145','245002','359',560.00,690.00,0.00,2485.50,1391880.00,1637752.00,245872.00,697403),('1','145','245230','359',560.00,680.00,0.00,3611.50,2022440.00,2365548.00,343108.00,697988),('1','145','245346','359',560.00,680.00,0.00,1280.30,716968.00,850392.00,133424.00,698297),('1','145','245507','359',560.00,680.00,0.00,2231.20,1249472.00,1456960.00,207488.00,698701),('1','145','245691','359',560.00,680.00,0.00,3246.70,1818152.00,2136828.00,318676.00,699178),('1','145','245954','359',560.00,680.00,0.00,4086.10,2288216.00,2513160.00,224944.00,699877),('1','145','246202','359',560.00,640.00,0.00,2976.60,1666896.00,1837944.00,171048.00,700503),('1','145','246467','359',560.00,640.00,0.00,3768.50,2110360.00,2315448.00,205088.00,701211),('1','145','246715','359',560.00,640.00,0.00,1521.00,851760.00,946712.00,94952.00,701858),('1','145','246874','359',560.00,640.00,0.00,403.80,226128.00,258432.00,32304.00,702279),('1','145','246955','359',560.00,640.00,0.00,4418.10,2474136.00,2725584.00,251448.00,702473),('1','145','247224','359',560.00,640.00,0.00,0.00,0.00,0.00,0.00,703169),('1','145','247231','359',560.00,640.00,0.00,2389.40,1338064.00,1474908.00,136844.00,703187),('1','145','247419','359',560.00,640.00,0.00,2862.60,1603056.00,1785340.00,182284.00,703655),('1','145','247684','359',560.00,640.00,0.00,3139.10,1757896.00,1945992.00,188096.00,704359),('1','145','247927','359',560.00,640.00,0.00,3237.30,1812888.00,2002380.00,189492.00,704987),('1','145','248175','359',560.00,640.00,0.00,3606.00,1543368.00,2229724.00,686356.00,705626),('1','145','248418','359',428.00,640.00,0.00,3965.00,1697020.00,2463684.00,766664.00,706255),('1','145','248655','359',428.00,640.00,0.00,2544.50,1089046.00,1555616.00,466570.00,706852),('1','145','248735','359',428.00,640.00,0.00,0.00,0.00,0.00,0.00,707064),('1','145','248737','359',428.00,640.00,0.00,2204.10,943354.80,1353672.00,410317.20,707067),('1','145','248925','359',428.00,640.00,0.00,2164.80,926534.40,1329376.00,402841.60,707549),('1','145','249127','359',428.00,640.00,0.00,2190.80,937662.40,1358480.00,420817.60,708066),('1','145','249365','359',428.00,640.00,0.00,1988.90,851249.20,1230304.00,379054.80,708673),('1','145','249602','359',508.00,608.00,0.00,4176.60,2121712.80,2419897.00,298184.20,709287),('1','145','249871','359',508.00,608.00,0.00,2692.00,1367536.00,1575860.00,208324.00,709976),('1','145','250116','359',508.00,608.00,0.00,1718.50,872998.00,1005138.00,132140.00,710599),('1','145','250240','359',508.00,608.00,0.00,2185.60,1110284.80,1277689.20,167404.40,710928),('1','145','250396','359',508.00,608.00,0.00,0.00,0.00,0.00,0.00,711305),('1','145','250398','359',508.00,608.00,0.00,3758.00,1909064.00,2181523.00,272459.00,711309),('1','145','250613','359',508.00,608.00,0.00,1678.90,852881.20,977424.60,124543.40,711861),('1','145','250815','359',508.00,608.00,0.00,2747.70,1395831.60,1609900.40,214068.80,712393),('1','145','251037','359',508.00,608.00,0.00,2629.90,1335989.20,1541819.60,205830.40,712970),('1','145','251286','359',508.00,608.00,0.00,1843.70,936599.60,1086511.20,149911.60,713616),('1','145','251527','359',508.00,608.00,0.00,1399.70,711047.60,836121.60,125074.00,714248),('1','145','251781','359',508.00,608.00,0.00,1623.00,824484.00,969421.80,144937.80,714911),('1','145','252009','359',508.00,608.00,0.00,2858.00,1451864.00,1684255.00,232391.00,715511),('1','145','252282','359',508.00,608.00,0.00,1772.50,900430.00,1037848.40,137418.40,716215),('1','145','252493','359',508.00,608.00,0.00,1930.90,980897.20,1145597.40,164700.20,716768),('1','145','252727','359',498.00,580.00,0.00,562.00,279876.00,312790.00,32914.00,717379),('1','145','252806','359',498.00,580.00,0.00,2036.60,1014226.80,1157594.00,143367.20,717573),('1','145','252979','359',498.00,580.00,0.00,2024.80,1008350.40,1146046.00,137695.60,718032),('1','145','253217','359',498.00,580.00,0.00,1968.70,980412.60,1118539.00,138126.40,718663),('1','145','253419','359',498.00,580.00,0.00,0.00,0.00,0.00,0.00,719189),('1','145','253493','359',498.00,580.00,0.00,2089.20,1040421.60,1184163.00,143741.40,719370),('1','145','253721','359',498.00,580.00,0.00,2931.60,1459936.80,1666164.00,206227.20,719959),('1','145','254014','359',498.00,580.00,0.00,2099.40,1045501.20,1180998.00,135496.80,720714),('1','145','254215','359',498.00,580.00,0.00,3095.00,1541310.00,1740989.00,199679.00,721242),('1','145','254470','359',498.00,580.00,0.00,2869.40,1428961.20,1605548.00,176586.80,721897),('1','145','254637','359',498.00,580.00,0.00,0.00,0.00,0.00,0.00,722343),('1','145','254638','359',498.00,580.00,0.00,282.50,140685.00,163850.00,23165.00,722344),('1','145','254715','359',498.00,580.00,0.00,2776.40,1382647.20,1566617.00,183969.80,722518),('1','145','254968','359',498.00,580.00,0.00,3048.90,1518352.20,1717887.00,199534.80,723165),('1','145','255207','359',498.00,580.00,0.00,3580.20,1782939.60,1995480.00,212540.40,723778),('1','145','255395','359',498.00,580.00,0.00,0.00,0.00,0.00,0.00,724258),('1','145','255478','359',498.00,580.00,0.00,3223.60,1605352.80,1815538.00,210185.20,724452),('1','145','255766','359',498.00,580.00,0.00,1588.90,791272.20,890662.00,99389.80,725166),('1','145','255862','359',498.00,580.00,0.00,812.90,404824.20,460622.00,55797.80,725425),('1','145','255965','359',498.00,580.00,0.00,3554.10,1769941.80,2001471.00,231529.20,725677),('1','145','256229','359',498.00,580.00,0.00,4395.30,2188859.40,2450919.00,262059.60,726324),('1','145','256420','359',498.00,580.00,0.00,0.00,0.00,0.00,0.00,726836),('1','145','256498','359',528.00,600.00,0.00,1981.10,1046020.80,1159320.00,113299.20,727033),('1','145','256743','359',528.00,600.00,0.00,2400.50,1267464.00,1409346.00,141882.00,727655),('1','145','256978','359',528.00,600.00,0.00,991.90,522223.20,587061.00,64837.80,728277),('1','145','257184','359',498.00,600.00,0.00,968.10,482113.80,567762.00,85648.20,728830),('1','145','257250','359',498.00,600.00,0.00,3258.40,1622683.20,1911858.00,289174.80,728985),('1','145','257535','359',498.00,600.00,0.00,2396.50,1193457.00,1394886.00,201429.00,729725),('1','145','257536','359',498.00,600.00,0.00,3417.00,1701666.00,1997469.00,295803.00,729726),('1','145','257537','359',498.00,600.00,0.00,0.00,0.00,0.00,0.00,729727),('1','145','257538','359',498.00,600.00,0.00,3313.80,1650272.40,1935549.00,285276.60,729728),('1','145','257539','359',498.00,600.00,0.00,2625.30,1307399.40,1539690.00,232290.60,729729),('1','145','257540','359',498.00,600.00,0.00,2223.40,1107253.20,1303569.00,196315.80,729730),('1','145','257541','359',498.00,600.00,0.00,285.00,141930.00,164400.00,22470.00,729731),('1','145','257542','359',498.00,600.00,0.00,2984.10,1486081.80,1744713.00,258631.20,729732),('1','145','257543','359',498.00,600.00,0.00,2376.60,1207312.80,1325676.00,118363.20,729733),('1','145','257544','359',508.00,580.00,0.00,0.00,0.00,0.00,0.00,729734),('1','145','257545','359',508.00,580.00,0.00,3279.70,1666087.60,1834942.00,168854.40,729735),('1','145','257546','359',508.00,580.00,0.00,4624.60,2349296.80,2553256.00,203959.20,729736),('1','145','257547','359',508.00,580.00,0.00,5208.90,2646121.20,2882066.00,235944.80,729737),('1','145','257548','359',508.00,580.00,0.00,252.10,128066.80,143770.00,15703.20,729738),('1','145','257549','359',493.00,580.00,0.00,3245.70,1600130.10,1803634.00,203503.90,729739),('1','145','257550','359',493.00,580.00,0.00,2953.70,1456174.10,1640982.00,184807.90,729740),('1','145','257551','359',493.00,580.00,0.00,4060.00,2001580.00,2273944.00,272364.00,729741),('1','145','257552','359',493.00,580.00,0.00,2067.90,1019474.70,1151230.00,131755.30,729742),('1','145','257553','359',493.00,580.00,0.00,3749.50,1848503.50,2082282.00,233778.50,729743),('1','145','257554','359',493.00,580.00,0.00,3462.00,1706766.00,1917104.00,210338.00,729744),('1','145','257555','359',493.00,580.00,0.00,2974.00,1466182.00,1653488.00,187306.00,729745),('1','145','257556','359',493.00,580.00,0.00,1603.20,790377.60,899376.00,108998.40,729746),('1','145','257557','359',493.00,580.00,0.00,1480.40,729837.20,824868.00,95030.80,729747),('1','145','257558','359',493.00,580.00,0.00,0.00,0.00,0.00,0.00,729748),('1','145','257559','359',493.00,580.00,0.00,0.00,0.00,0.00,0.00,729749),('1','145','257560','359',493.00,580.00,0.00,883.30,435466.90,497414.00,61947.10,729750),('1','145','257561','359',493.00,580.00,0.00,3947.20,1945969.60,2195244.00,249274.40,729751),('1','145','257562','359',493.00,580.00,0.00,2707.70,1334896.10,1500562.00,165665.90,729752),('1','145','257563','359',493.00,580.00,0.00,3049.30,1503304.90,1697558.00,194253.10,729753),('1','145','257564','359',493.00,580.00,0.00,6784.60,3344807.80,3697408.40,352600.60,729754),('1','145','257565','359',493.00,580.00,0.00,7653.00,3772929.00,4404793.60,631864.60,729755),('1','145','257566','359',493.00,610.00,0.00,8628.30,4253751.90,4952842.20,699090.30,729756),('1','145','257567','359',493.00,610.00,0.00,626.90,309061.70,366377.00,57315.30,729757),('1','145','257568','359',493.00,610.00,0.00,3305.30,1629512.90,1931029.00,301516.10,729758),('1','145','257569','359',493.00,610.00,0.00,4411.70,2174968.10,2582633.00,407664.90,729759),('1','145','257570','359',493.00,610.00,0.00,2531.20,1247881.60,1481476.00,233594.40,729760),('1','145','257571','359',493.00,610.00,0.00,0.00,0.00,0.00,0.00,729761),('1','145','257572','359',493.00,610.00,0.00,494.60,243837.80,287090.00,43252.20,729762),('1','145','257573','359',493.00,640.00,0.00,3823.40,1884936.20,2341544.00,456607.80,729763),('1','145','257574','359',493.00,640.00,0.00,2604.20,1283870.60,1605204.00,321333.40,729764),('1','145','257575','359',493.00,640.00,0.00,1816.00,895288.00,1108820.00,213532.00,729765),('1','145','257576','359',493.00,640.00,0.00,2249.30,1108904.90,1390668.00,281763.10,729766),('1','145','257577','359',493.00,640.00,0.00,2481.20,1223231.60,1552808.00,329576.40,729767),('1','145','257578','359',493.00,640.00,0.00,0.00,0.00,0.00,0.00,729768),('1','145','257579','359',508.00,640.00,0.00,3702.40,1880819.20,2285484.00,404664.80,729769),('1','145','257580','359',508.00,640.00,0.00,3929.70,1996287.60,2437904.00,441616.40,729770),('1','145','257581','359',508.00,640.00,0.00,3474.60,1765096.80,2131288.00,366191.20,729771),('1','145','257582','359',508.00,640.00,0.00,3576.10,1816658.80,2207264.00,390605.20,729772),('1','145','257583','359',508.00,640.00,0.00,1645.40,835863.20,1017044.00,181180.80,729773),('1','145','257584','359',508.00,640.00,0.00,2790.10,1674060.00,1897882.00,223822.00,729774),('1','145','257585','359',600.00,700.00,0.00,2754.80,1652880.00,1879068.00,226188.00,729775),('1','145','257586','359',600.00,700.00,0.00,1311.80,787080.00,896060.00,108980.00,729776),('1','145','257587','359',600.00,700.00,0.00,1056.40,633840.00,724192.00,90352.00,729777),('1','145','257588','359',600.00,700.00,0.00,3175.10,1905060.00,2162198.00,257138.00,729778),('1','145','257589','359',600.00,700.00,0.00,3565.90,2139540.00,2404650.00,265110.00,729779),('1','145','257590','359',600.00,700.00,0.00,2971.10,1782660.00,2016142.00,233482.00,729780),('1','145','257591','359',600.00,700.00,0.00,0.00,0.00,0.00,0.00,729781),('1','145','257592','359',574.00,700.00,0.00,3203.00,1838522.00,2166596.00,328074.00,729782),('1','145','257593','359',574.00,700.00,0.00,1859.30,1067238.20,1275926.00,208687.80,729783),('1','145','257594','359',574.00,700.00,0.00,2629.10,1509103.40,1784122.00,275018.60,729784),('1','145','257595','359',574.00,700.00,0.00,1822.30,1046000.20,1246002.00,200001.80,729785),('1','145','257596','359',574.00,700.00,0.00,1908.10,1095249.40,1297586.00,202336.60,729786),('1','145','257597','359',574.00,700.00,0.00,1111.90,638230.60,755254.00,117023.40,729787),('1','145','257598','359',574.00,700.00,0.00,1409.40,808995.60,959360.00,150364.40,729788),('1','145','257599','359',574.00,700.00,0.00,0.00,0.00,0.00,0.00,729789),('1','145','257600','359',574.00,700.00,0.00,2173.80,1247761.20,1490988.00,243226.80,729790),('1','145','257601','359',574.00,700.00,0.00,2252.10,1292705.40,1651587.00,358881.60,729791),('1','145','257602','359',574.00,750.00,0.00,2055.80,1180029.20,1499018.00,318988.80,729792),('1','145','257603','359',574.00,750.00,0.00,2388.70,1371113.80,1747085.00,375971.20,729793),('1','145','257604','359',574.00,750.00,0.00,1940.80,1114019.20,1428108.00,314088.80,729794),('1','145','257605','359',574.00,750.00,0.00,2806.30,1610816.20,2062957.00,452140.80,729795),('1','145','257606','359',574.00,750.00,0.00,1891.10,1085491.40,1382397.00,296905.60,729796),('1','145','257607','359',574.00,750.00,0.00,2144.10,1230713.40,1581559.00,350845.60,729797),('1','145','257608','359',574.00,750.00,0.00,2438.00,1399412.00,1781512.00,382100.00,729798),('1','145','257609','359',574.00,680.00,0.00,1254.20,719910.80,885586.00,165675.20,729799),('1','145','257610','359',574.00,740.00,0.00,1275.30,732022.20,908838.00,176815.80,729800),('1','145','257611','359',574.00,740.00,0.00,0.00,0.00,0.00,0.00,729801),('1','145','257612','359',574.00,740.00,0.00,2347.30,1347350.20,1645828.00,298477.80,729802),('1','145','257613','359',574.00,720.00,0.00,2728.20,1565986.80,1909652.00,343665.20,729803),('1','145','257614','359',574.00,720.00,0.00,3505.50,2012157.00,2467216.00,455059.00,729804),('1','145','257615','359',574.00,720.00,0.00,1688.50,969199.00,1184560.00,215361.00,729805),('1','145','257616','359',574.00,720.00,0.00,3182.80,1826927.20,2235532.00,408604.80,729806),('1','145','257617','359',574.00,720.00,0.00,2582.00,1482068.00,1809376.00,327308.00,729807),('1','145','257618','359',574.00,720.00,0.00,1950.40,1119529.60,1381728.00,262198.40,729808),('1','145','257619','359',574.00,720.00,0.00,895.00,513730.00,626832.00,113102.00,729809),('1','145','257620','359',574.00,720.00,0.00,1450.10,832357.40,1017860.00,185502.60,729810),('1','145','257621','359',574.00,720.00,0.00,2132.30,1223940.20,1497168.00,273227.80,729811),('1','145','257622','359',574.00,720.00,0.00,0.00,0.00,0.00,0.00,729812),('1','145','257623','359',574.00,720.00,0.00,2854.20,1638310.80,2016740.00,378429.20,729813),('1','145','257624','359',574.00,720.00,0.00,2971.00,1705354.00,2074744.00,369390.00,729814),('1','145','257625','359',574.00,720.00,0.00,3226.60,1852068.40,1984030.00,131961.60,729815),('1','145','257626','359',574.00,650.00,0.00,4446.00,2552004.00,2747590.00,195586.00,729816),('1','145','257627','359',574.00,650.00,0.00,2887.50,1657425.00,1801214.00,143789.00,729817),('1','145','257628','359',574.00,690.00,0.00,695.50,399217.00,459860.00,60643.00,729818),('1','145','257629','359',574.00,690.00,0.00,3282.30,1884040.20,2180287.00,296246.80,729819),('1','145','257630','359',574.00,690.00,0.00,3334.80,1914175.20,2220172.00,305996.80,729820),('1','145','257631','359',574.00,690.00,0.00,0.00,0.00,0.00,0.00,729821),('1','145','257632','359',574.00,690.00,0.00,3093.90,1775898.60,2083551.00,307652.40,729822),('1','145','257633','359',574.00,690.00,0.00,2030.70,1194051.60,1345683.00,151631.40,729823),('1','145','257634','359',588.00,690.00,0.00,2733.10,1607062.80,1830159.00,223096.20,729824),('1','145','257635','359',588.00,690.00,0.00,2783.60,1636756.80,1850279.00,213522.20,729825),('1','145','257636','359',588.00,690.00,0.00,2591.10,1523566.80,1724259.00,200692.20,729826),('1','145','257637','359',588.00,690.00,0.00,2281.80,1341698.40,1524087.00,182388.60,729827),('1','145','257638','359',588.00,690.00,0.00,600.60,353152.80,399564.00,46411.20,729828),('1','145','257639','359',588.00,690.00,0.00,1537.30,903932.40,1026042.00,122109.60,729829),('1','145','257640','359',588.00,690.00,0.00,3133.40,1842439.20,2084311.00,241871.80,729830),('1','145','257641','359',588.00,690.00,0.00,1967.80,1157066.40,1300057.00,142990.60,729831),('1','145','257642','359',588.00,690.00,0.00,0.00,0.00,0.00,0.00,729832),('1','145','257643','359',588.00,690.00,0.00,2345.30,1379036.40,1563772.00,184735.60,729833),('1','145','257644','359',588.00,690.00,0.00,2323.40,1366159.20,1543261.00,177101.80,729834),('1','145','257645','359',588.00,690.00,0.00,2987.80,1756826.40,1986577.00,229750.60,729835),('1','145','257646','359',588.00,690.00,0.00,3093.00,1818684.00,2063995.00,245311.00,729836),('1','145','257647','359',588.00,690.00,0.00,2503.90,1472293.20,1682076.00,209782.80,729837),('1','145','257648','359',588.00,690.00,0.00,3460.10,2034538.80,2315044.00,280505.20,729838),('1','145','257649','359',588.00,690.00,0.00,1151.30,676964.40,753622.00,76657.60,729839),('1','145','257650','359',588.00,690.00,0.00,556.40,327163.20,370891.00,43727.80,729840),('1','145','257651','359',588.00,690.00,0.00,1789.40,1052167.20,1188526.00,136358.80,729841),('1','145','257652','359',588.00,690.00,0.00,0.00,0.00,0.00,0.00,729842),('1','145','257653','359',588.00,690.00,0.00,2472.60,1389601.20,1589982.00,200380.80,729843),('1','145','257654','359',562.00,670.00,0.00,2924.10,1643344.20,1878827.00,235482.80,729844),('1','145','257655','359',562.00,670.00,0.00,2354.30,1323116.60,1532876.00,209759.40,729845),('1','145','257656','359',562.00,670.00,0.00,3144.50,1767209.00,2035385.00,268176.00,729846),('1','145','257657','359',562.00,670.00,0.00,3594.50,2020109.00,2344830.00,324721.00,729847),('1','145','257658','359',562.00,670.00,0.00,1913.30,1075274.60,1230021.00,154746.40,729848),('1','145','257659','359',562.00,670.00,0.00,3288.20,1847968.40,2081489.00,233520.60,729849),('1','145','257660','359',562.00,670.00,0.00,2804.00,1575848.00,1800995.00,225147.00,729850),('1','145','257661','359',562.00,670.00,0.00,3815.00,2144030.00,2416820.00,272790.00,729851),('1','145','257662','359',562.00,670.00,0.00,0.00,0.00,0.00,0.00,729852),('1','145','257663','359',562.00,670.00,0.00,3123.20,1770854.40,2008059.00,237204.60,729853),('1','145','257664','359',567.00,670.00,0.00,2763.90,1567131.30,1779233.00,212101.70,729854),('1','145','257665','359',567.00,670.00,0.00,3528.70,1739649.10,2417092.00,677442.90,729855),('1','145','257666','359',493.00,710.00,0.00,2317.20,1142379.60,1574427.00,432047.40,729856),('1','145','257667','359',493.00,710.00,0.00,2699.70,1330952.10,1847282.00,516329.90,729857),('1','145','257668','359',493.00,710.00,0.00,2694.80,1328536.40,1851438.00,522901.60,729858),('1','145','257669','359',493.00,710.00,0.00,1123.50,553885.50,772575.00,218689.50,729859),('1','145','257670','359',493.00,710.00,0.00,276.50,136314.50,183215.00,46900.50,729860),('1','145','257671','359',493.00,710.00,0.00,1420.90,700503.70,971364.00,270860.30,729861),('1','145','257672','359',493.00,710.00,0.00,2301.90,1134836.70,1592479.00,457642.30,729862),('1','145','257673','359',493.00,710.00,0.00,3555.60,1752910.80,2445066.00,692155.20,729863),('1','145','257674','359',493.00,710.00,0.00,3227.60,1591206.80,2214186.00,622979.20,729864),('1','145','257675','359',493.00,710.00,0.00,2367.30,1167078.90,1581418.00,414339.10,729865),('1','145','257676','359',574.00,740.00,0.00,2269.00,1302406.00,1630956.00,328550.00,729866),('1','145','257677','359',574.00,780.00,0.00,3382.09,1941319.66,2568621.00,627301.34,729867),('1','145','257678','359',574.00,780.00,0.00,2415.56,1386531.44,1844020.80,457489.36,729868),('1','145','257679','359',632.00,780.00,0.00,180.94,114354.08,138933.20,24579.12,729869),('1','145','257680','359',632.00,780.00,0.00,2666.80,1685417.60,2036213.20,350795.60,729870),('1','145','257681','359',632.00,780.00,0.00,0.00,0.00,0.00,0.00,729871),('1','145','257682','359',632.00,780.00,0.00,3024.69,1911604.08,2315630.20,404026.12,729872),('1','145','257683','359',632.00,780.00,0.00,2025.75,1280274.00,1539644.20,259370.20,729873),('1','145','257684','359',632.00,780.00,0.00,3669.21,2318940.72,2785830.20,466889.48,729874),('1','145','257685','359',632.00,780.00,0.00,2790.37,1763513.84,2134067.80,370553.96,729875),('1','145','257686','359',632.00,780.00,0.00,3828.72,2419751.04,2912854.80,493103.76,729876),('1','145','257687','359',632.00,780.00,0.00,3525.88,2228356.16,2690786.40,462430.24,729877),('1','145','257688','359',632.00,780.00,0.00,2514.53,1589182.96,1913831.00,324648.04,729878),('1','145','257689','359',632.00,780.00,0.00,441.97,279325.04,333134.60,53809.56,729879),('1','145','257690','359',632.00,780.00,0.00,4225.91,2670775.12,3214405.00,543629.88,729880),('1','145','257691','359',632.00,780.00,0.00,0.00,0.00,0.00,0.00,729881),('1','145','257692','359',632.00,780.00,0.00,1925.07,1216644.24,1466624.60,249980.36,729882),('1','145','257693','359',632.00,780.00,0.00,3169.66,2003225.12,2408367.60,405142.48,729883),('1','145','257694','359',632.00,780.00,0.00,2773.26,1752700.32,2112306.80,359606.48,729884),('1','145','257695','359',632.00,780.00,0.00,2431.16,1536493.12,1860965.60,324472.48,729885),('1','145','257696','359',632.00,780.00,0.00,3119.43,1971479.76,2379847.80,408368.04,729886),('1','145','257697','359',632.00,780.00,0.00,2821.44,1783150.08,2148609.60,365459.52,729887),('1','145','257698','359',632.00,780.00,0.00,3843.11,2428845.52,2930421.80,501576.28,729888),('1','145','257699','359',632.00,780.00,0.00,340.19,215000.08,256339.00,41338.92,729889),('1','145','257700','359',632.00,780.00,0.00,0.00,0.00,0.00,0.00,729890),('1','145','257701','359',632.00,780.00,0.00,1465.15,925974.80,1112153.00,186178.20,729891),('1','145','257702','359',632.00,780.00,0.00,3259.78,2060180.96,2488411.20,428230.24,729892),('1','145','257703','359',632.00,780.00,0.00,2319.39,1465854.48,1760427.80,294573.32,729893),('1','145','257704','359',632.00,780.00,0.00,1880.10,1188223.20,1438594.00,250370.80,729894),('1','145','257705','359',632.00,780.00,0.00,2412.70,1524826.40,1847922.40,323096.00,729895),('1','145','257706','359',632.00,780.00,0.00,3246.98,2052091.36,2466647.20,414555.84,729896),('1','145','257707','359',632.00,780.00,0.00,3680.63,2326158.16,2806026.60,479868.44,729897),('1','145','257708','359',632.00,780.00,0.00,2090.79,1321379.28,1586592.60,265213.32,729898),('1','145','257709','359',632.00,780.00,0.00,2627.74,1660731.68,1998454.80,337723.12,729899),('1','145','257710','359',632.00,780.00,0.00,0.00,0.00,0.00,0.00,729900),('1','145','257711','359',632.00,780.00,0.00,1589.93,1004835.76,1207222.60,202386.84,729901),('1','145','257712','359',632.00,780.00,0.00,0.00,0.00,0.00,0.00,729902),('1','145','257713','359',652.00,780.00,0.00,1120.43,730520.36,855891.80,125371.44,729903),('1','145','257714','359',652.00,780.00,0.00,1935.45,1261913.40,1473412.60,211499.20,729904),('1','145','257715','359',652.00,780.00,0.00,3281.53,2139557.56,2511465.80,371908.24,729905),('1','145','257716','359',652.00,780.00,0.00,2145.38,1398787.76,1623877.20,225089.44,729906),('1','145','257717','359',652.00,780.00,0.00,2240.79,1460995.08,1722848.60,261853.52,729907),('1','145','257718','359',652.00,780.00,0.00,2364.96,1541953.92,1815794.80,273840.88,729908),('1','145','257719','359',652.00,780.00,0.00,2802.28,1827086.56,2140130.40,313043.84,729909),('1','145','257720','359',652.00,780.00,0.00,292.69,190833.88,226698.20,35864.32,729910),('1','145','257721','359',652.00,780.00,0.00,0.00,0.00,0.00,0.00,729911),('1','145','257722','359',652.00,780.00,0.00,2475.52,1614039.04,1889794.80,275755.76,729912),('1','145','257723','359',652.00,780.00,0.00,2245.88,1464313.76,1733561.60,269247.84,729913),('1','145','257724','359',652.00,780.00,0.00,3551.09,2315310.68,2723395.40,408084.72,729914),('1','145','257725','359',652.00,780.00,0.00,1712.90,1116810.80,1310247.20,193436.40,729915),('1','145','257726','359',652.00,780.00,0.00,2642.28,1722766.56,2035130.00,312363.44,729916),('1','145','257727','359',652.00,780.00,0.00,2132.82,1390598.64,1626770.40,236171.76,729917),('1','145','257728','359',652.00,780.00,0.00,0.00,0.00,0.00,0.00,729918),('1','145','257729','359',652.00,780.00,0.00,2232.58,1455642.16,1720272.00,264629.84,729919),('1','145','257730','359',652.00,780.00,0.00,1534.38,1000415.76,1165024.40,164608.64,729920),('1','145','257731','359',652.00,780.00,0.00,2923.23,1905945.96,2240953.80,335007.84,729921),('1','145','257732','359',652.00,780.00,0.00,2626.37,1712393.24,2018134.20,305740.96,729922),('1','145','257733','359',652.00,780.00,0.00,2274.15,1482745.80,1735942.60,253196.80,729923),('1','145','257734','359',652.00,780.00,0.00,2318.01,1511342.52,1769384.20,258041.68,729924),('1','145','257735','359',652.00,780.00,0.00,2110.45,1376013.40,1617510.20,241496.80,729925),('1','145','257736','359',652.00,780.00,0.00,2802.16,1827008.32,2148194.00,321185.68,729926),('1','145','257737','359',652.00,780.00,0.00,1804.08,1176260.16,1368884.00,192623.84,729927),('1','145','257738','359',652.00,780.00,0.00,2188.92,1427175.84,1669530.00,242354.16,729928),('1','145','257739','359',652.00,780.00,0.00,636.58,415050.16,485704.00,70653.84,729929),('1','145','257740','359',652.00,780.00,0.00,1464.41,954795.32,1114597.00,159801.68,729930),('1','145','257741','359',652.00,780.00,0.00,1663.31,1084478.12,1279746.20,195268.08,729931),('1','145','257742','359',652.00,770.00,0.00,2100.13,1369284.76,1578974.60,209689.84,729932),('1','145','257743','359',652.00,770.00,0.00,2186.78,1425780.56,1640921.10,215140.54,729933),('1','145','257744','359',652.00,770.00,0.00,0.00,0.00,0.00,0.00,729934),('1','145','257745','359',652.00,770.00,0.00,3306.93,2156118.36,2479382.10,323263.74,729935),('1','145','257746','359',652.00,770.00,0.00,2797.92,1824243.84,2102586.90,278343.06,729936),('1','145','257747','359',642.00,770.00,0.00,1185.39,761020.38,886800.30,125779.92,729937),('1','145','257748','359',642.00,770.00,0.00,3005.82,1929736.44,2234393.90,304657.46,729938),('1','145','257749','359',642.00,770.00,0.00,2557.82,1642120.44,1920169.40,278048.96,729939),('1','145','257750','359',642.00,770.00,0.00,2471.47,1586683.74,1854136.40,267452.66,729940),('1','145','257751','359',642.00,770.00,0.00,0.00,0.00,0.00,0.00,729941),('1','145','257752','359',642.00,770.00,0.00,4198.00,2695116.00,3141559.00,446443.00,729942),('1','145','257753','359',642.00,770.00,0.00,2715.98,1743659.16,2014743.60,271084.44,729943),('1','145','257754','359',642.00,770.00,0.00,3576.62,2296190.04,2669773.40,373583.36,729944),('1','145','257755','359',642.00,770.00,0.00,2781.40,1785658.80,2066085.50,280426.70,729945),('1','145','257756','359',642.00,770.00,0.00,1011.91,649646.22,747290.20,97643.98,729946),('1','145','257757','359',642.00,770.00,0.00,5409.69,3473020.98,3982249.80,509228.82,729947),('1','145','257758','359',642.00,770.00,0.00,3423.69,2198008.98,2534751.30,336742.32,729948),('1','145','257759','359',642.00,770.00,0.00,2670.26,1714306.92,1997817.20,283510.28,729949),('1','145','257760','359',642.00,770.00,0.00,464.43,298164.06,349111.10,50947.04,729950),('1','145','257761','359',642.00,770.00,0.00,0.00,0.00,0.00,0.00,729951),('1','145','257762','359',642.00,770.00,0.00,2230.70,1432109.40,1662650.50,230541.10,729952),('1','145','257763','359',642.00,770.00,0.00,4880.76,3133447.92,3592725.70,459277.78,729953),('1','145','257764','359',642.00,770.00,0.00,2779.51,1784445.42,2055646.20,271200.78,729954),('1','145','257765','359',642.00,770.00,0.00,0.00,0.00,0.00,0.00,729955),('1','145','257766','359',642.00,770.00,0.00,243.98,156635.16,182064.60,25429.44,729956),('1','145','257767','359',642.00,770.00,0.00,1471.04,944407.68,1088588.30,144180.62,729957),('1','145','257768','359',642.00,770.00,0.00,7127.63,4575938.46,5210321.60,634383.14,729958),('1','145','257769','359',642.00,770.00,0.00,7297.79,4685181.18,5473457.10,788275.92,729959),('1','145','257770','359',642.00,790.00,0.00,1453.29,933012.18,1086465.60,153453.42,729960),('1','145','257771','359',642.00,790.00,0.00,2743.02,1761018.84,2067698.80,306679.96,729961),('1','145','257772','359',642.00,790.00,0.00,5409.61,3472969.62,4080047.90,607078.28,729962),('1','145','257773','359',642.00,790.00,0.00,3468.24,2226610.08,2644475.60,417865.52,729963),('1','145','257774','359',642.00,790.00,0.00,3902.54,2505430.68,2957734.60,452303.92,729964),('1','145','257775','359',642.00,790.00,0.00,2009.79,1290285.18,1555163.60,264878.42,729965),('1','145','257776','359',642.00,790.00,0.00,0.00,0.00,0.00,0.00,729966),('1','145','257777','359',642.00,790.00,0.00,1697.99,1090109.58,1319162.10,229052.52,729967),('1','145','257778','359',642.00,780.00,0.00,689.01,442344.42,519534.60,77190.18,729968),('1','145','257779','359',642.00,780.00,0.00,1887.41,1211717.22,1435293.08,223575.86,729969),('1','145','257780','359',642.00,780.00,0.00,2342.58,1503936.36,1746042.48,242106.12,729970),('1','145','257781','359',642.00,780.00,0.00,0.00,0.00,0.00,0.00,729971),('1','145','257782','359',642.00,780.00,0.00,2362.21,1516538.82,1792374.48,275835.66,729972),('1','145','257783','359',642.00,780.00,0.00,2804.53,1800508.26,2121632.76,321124.50,729973),('1','145','257784','359',642.00,780.00,0.00,2260.81,1451440.02,1716973.96,265533.94,729974),('1','145','257785','359',642.00,780.00,0.00,1944.38,1248291.96,1481407.20,233115.24,729975),('1','145','257786','359',642.00,780.00,0.00,2419.12,1553075.04,1833697.32,280622.28,729976),('1','145','257787','359',642.00,780.00,0.00,2836.34,1820930.28,2170915.24,349984.96,729977),('1','145','257788','359',642.00,780.00,0.00,1198.22,769257.24,904008.04,134750.80,729978),('1','145','257789','359',642.00,780.00,0.00,0.00,0.00,0.00,0.00,729979),('1','145','257790','359',642.00,780.00,0.00,941.09,604179.78,705253.64,101073.86,729980),('1','145','257791','359',642.00,780.00,0.00,2968.85,1906001.70,2239371.68,333369.98,729981),('1','145','257792','359',642.00,780.00,0.00,3083.02,1979298.84,2337361.00,358062.16,729982),('1','145','257793','359',642.00,780.00,0.00,1666.54,1069918.68,1262850.16,192931.48,729983),('1','145','257794','359',642.00,780.00,0.00,2535.09,1627527.78,1909345.88,281818.10,729984),('1','145','257795','359',642.00,780.00,0.00,4500.81,2889520.02,3374516.60,484996.58,729985),('1','145','257796','359',642.00,780.00,0.00,1612.26,1035070.92,1207589.76,172518.84,729986),('1','145','257797','359',642.00,780.00,0.00,7256.60,4658737.20,5383463.28,724726.08,729987),('1','145','257798','359',642.00,780.00,0.00,1618.73,1039224.66,1200945.20,161720.54,729988),('1','145','257799','359',642.00,780.00,0.00,0.00,0.00,0.00,0.00,729989),('1','145','257800','359',642.00,780.00,0.00,0.00,0.00,0.00,0.00,729990),('1','145','257801','359',642.00,780.00,0.00,9171.85,5888327.70,6797601.84,909274.14,729991),('1','145','257802','359',642.00,780.00,0.00,2424.50,1556529.00,1801983.56,245454.56,729992),('1','145','257803','359',642.00,780.00,0.00,0.00,0.00,0.00,0.00,729993),('1','145','257804','359',656.00,780.00,0.00,3900.47,2558708.32,2918341.92,359633.60,729994),('1','145','257805','359',656.00,780.00,0.00,7633.44,5007536.64,5690544.08,683007.44,729995),('1','145','257806','359',656.00,780.00,0.00,5613.05,3682160.80,4164407.00,482246.20,729996),('1','145','257807','359',656.00,780.00,0.00,1710.35,1121989.60,1261622.96,139633.36,729997),('1','145','257808','359',656.00,780.00,0.00,0.00,0.00,0.00,0.00,729998),('1','145','257809','359',656.00,780.00,0.00,9576.61,6282256.16,6982952.20,700696.04,729999),('1','145','257810','359',656.00,770.00,0.00,9436.36,6190252.16,6929892.70,739640.54,730000),('1','145','257811','359',656.00,770.00,0.00,6644.55,4252512.00,4887290.50,634778.50,730001),('1','145','257812','359',640.00,770.00,0.00,0.00,0.00,0.00,0.00,730002),('1','145','257813','359',640.00,770.00,0.00,4025.15,2576096.00,2959673.50,383577.50,730003),('1','145','257814','359',640.00,770.00,0.00,6305.63,4035603.20,4638061.10,602457.90,730004),('1','145','257815','359',640.00,770.00,0.00,5288.99,3384953.60,3909759.30,524805.70,730005),('1','145','257816','359',640.00,770.00,0.00,3766.73,2410707.20,2799180.60,388473.40,730006),('1','145','257817','359',640.00,770.00,0.00,3358.55,2149472.00,2485342.50,335870.50,730007),('1','145','257818','359',640.00,770.00,0.00,1700.96,1088614.40,1268689.20,180074.80,730008),('1','145','257819','359',640.00,770.00,0.00,1194.68,764595.20,892246.60,127651.40,730009),('1','145','257820','359',640.00,770.00,0.00,3800.55,2432352.00,2829908.00,397556.00,730010),('1','145','257821','359',640.00,770.00,0.00,2399.66,1535782.40,1774176.70,238394.30,730011),('1','145','257822','359',640.00,770.00,0.00,2925.87,1872556.80,2189060.40,316503.60,730012),('1','145','257823','359',640.00,770.00,0.00,2498.91,1599302.40,1885419.70,286117.30,730013),('1','145','257824','359',640.00,770.00,0.00,2344.01,1500166.40,1761788.70,261622.30,730014),('1','145','257825','359',640.00,770.00,0.00,3578.79,2297583.18,2591299.50,293716.32,730015),('1','145','257826','359',642.00,750.00,0.00,3869.98,2484527.16,2792060.00,307532.84,730016),('1','145','257827','359',642.00,750.00,0.00,862.38,553647.96,628137.00,74489.04,730017),('1','145','257828','359',642.00,750.00,0.00,0.00,0.00,0.00,0.00,730018),('1','145','257829','359',640.00,750.00,0.00,5857.76,3748966.40,4217126.00,468159.60,730019),('1','145','257830','359',640.00,750.00,0.00,2737.60,1752064.00,1991443.00,239379.00,730020),('1','145','257831','359',640.00,750.00,0.00,2402.04,1537305.60,1755055.00,217749.40,730021),('1','145','257832','359',640.00,750.00,0.00,2283.86,1461670.40,1664641.00,202970.60,730022),('1','145','257833','359',640.00,750.00,0.00,2606.89,1668409.60,1902867.00,234457.40,730023),('1','145','257834','359',640.00,750.00,0.00,3425.19,2192121.60,2501704.50,309582.90,730024),('1','145','257835','359',640.00,750.00,0.00,0.00,0.00,0.00,0.00,730025),('1','145','257836','359',640.00,750.00,0.00,1665.57,1065964.80,1209889.00,143924.20,730026),('1','145','257837','359',640.00,750.00,0.00,2604.58,1666931.20,1909172.50,242241.30,730027),('1','145','257838','359',640.00,750.00,0.00,885.44,562208.75,650611.50,88402.75,730028),('1','145','257839','359',625.00,720.00,0.00,1419.19,886993.75,999170.40,112176.65,730029),('1','145','257840','359',625.00,720.00,0.00,0.00,0.00,0.00,0.00,730030),('1','145','257841','359',625.00,720.00,0.00,3111.28,1944550.00,2178898.80,234348.80,730031),('1','145','257842','359',625.00,720.00,0.00,3126.09,1953806.25,2184612.00,230805.75,730032),('1','145','257843','359',625.00,720.00,0.00,2204.96,1378100.00,1542206.40,164106.40,730033),('1','145','257844','359',625.00,720.00,0.00,2677.57,1673481.25,1863046.00,189564.75,730034),('1','145','257845','359',625.00,720.00,0.00,1026.87,641793.75,717256.80,75463.05,730035),('1','145','257846','359',625.00,720.00,0.00,3611.89,2257431.25,2514552.80,257121.55,730036),('1','145','257847','359',625.00,720.00,0.00,319.80,199875.00,222002.00,22127.00,730037),('1','145','257848','359',625.00,720.00,0.00,0.00,0.00,0.00,0.00,730038),('1','145','257849','359',625.00,720.00,0.00,6187.07,3866918.75,4313240.00,446321.25,730039),('1','145','257850','359',625.00,720.00,0.00,3867.58,2417237.50,2689265.20,272027.70,730040),('1','145','257851','359',625.00,720.00,0.00,4592.42,2870262.50,3196297.20,326034.70,730041),('1','145','257852','359',625.00,720.00,0.00,4423.15,2787658.61,3080832.00,293173.39,730042),('1','145','257853','359',656.00,780.00,0.00,188.04,123354.24,127867.20,4512.96,730043),('1','145','257854','359',656.00,780.00,0.00,3349.46,2197245.76,2493028.30,295782.54,730044),('1','145','257855','359',656.00,780.00,0.00,4050.98,2657442.88,3019730.40,362287.52,730045),('1','145','257856','359',656.00,780.00,0.00,2113.17,1386239.52,1602747.10,216507.58,730046),('1','145','257857','359',656.00,780.00,0.00,0.00,0.00,0.00,0.00,730047),('1','145','257858','359',656.00,780.00,0.00,546.98,358818.88,423644.40,64825.52,730048),('1','145','257859','359',656.00,780.00,0.00,2240.69,1469892.64,1721115.70,251223.06,730049),('1','145','257860','359',656.00,780.00,0.00,2477.22,1625056.32,1888847.60,263791.28,730050),('1','145','257861','359',656.00,780.00,0.00,1828.89,1199751.84,1388089.70,188337.86,730051),('1','145','257862','359',656.00,780.00,0.00,2053.14,1346859.84,1555155.20,208295.36,730052),('1','145','257863','359',656.00,780.00,0.00,3409.32,2236513.92,2581095.60,344581.68,730053),('1','145','257864','359',656.00,780.00,0.00,1413.16,927032.96,1062391.80,135358.84,730054),('1','145','257865','359',656.00,780.00,0.00,520.74,341605.44,389401.70,47796.26,730055),('1','145','257866','359',656.00,780.00,0.00,1086.56,712783.36,826316.80,113533.44,730056),('1','145','257867','359',656.00,780.00,0.00,1331.91,873732.96,999522.30,125789.34,730057),('1','145','257868','359',656.00,760.00,0.00,1357.22,890336.32,1005152.70,114816.38,730058),('1','145','257869','359',656.00,760.00,0.00,3108.10,2038913.60,2270916.00,232002.40,730059),('1','145','257870','359',656.00,760.00,0.00,2998.93,1967298.08,2208933.80,241635.72,730060),('1','145','257871','359',656.00,760.00,0.00,2602.33,1707128.48,1902361.30,195232.82,730061),('1','145','257872','359',656.00,760.00,0.00,2686.76,1762514.56,1977482.60,214968.04,730062),('1','145','257873','359',656.00,760.00,0.00,1641.92,1077099.52,1204951.70,127852.18,730063),('1','145','257874','359',656.00,760.00,0.00,0.00,0.00,0.00,0.00,730064),('1','145','257875','359',656.00,760.00,0.00,2754.16,1806728.96,2020495.10,213766.14,730065),('1','145','257876','359',656.00,760.00,0.00,754.65,495050.40,559634.00,64583.60,730066),('1','145','257877','359',656.00,760.00,0.00,2405.11,1577752.16,1767764.10,190011.94,730067),('1','145','257878','359',656.00,760.00,0.00,1419.02,916814.88,1039786.20,122971.32,730068),('1','145','257879','359',640.00,760.00,0.00,815.22,521740.80,597569.70,75828.90,730069),('1','145','257880','359',640.00,760.00,0.00,2349.17,1503468.80,1728368.70,224899.90,730070),('1','145','257881','359',640.00,760.00,0.00,2680.06,1715238.40,1981708.60,266470.20,730071),('1','145','257882','359',640.00,760.00,0.00,0.00,0.00,0.00,0.00,730072),('1','145','257883','359',640.00,760.00,0.00,1507.71,964934.40,1111539.60,146605.20,730073),('1','145','257884','359',640.00,760.00,0.00,2733.02,1749132.80,2007860.20,258727.40,730074),('1','145','257885','359',640.00,760.00,0.00,2197.85,1406624.00,1623099.00,216475.00,730075),('1','145','257886','359',640.00,760.00,0.00,1966.82,1258764.80,1461204.70,202439.90,730076),('1','145','257887','359',656.00,750.00,0.00,1802.00,1182112.00,1311755.40,129643.40,730077),('1','145','257888','359',656.00,750.00,0.00,1704.68,1118270.08,1247301.60,129031.52,730078),('1','145','257889','359',656.00,750.00,0.00,3477.06,2280951.36,2505918.00,224966.64,730079),('1','145','257890','359',656.00,750.00,0.00,2019.37,1324706.72,1449228.90,124522.18,730080),('1','145','257891','359',656.00,750.00,0.00,1075.39,705156.84,783119.10,77962.26,730081),('1','145','257892','359',630.00,750.00,0.00,1663.89,1048250.70,1194008.70,145758.00,730082),('1','145','257893','359',630.00,750.00,0.00,3078.72,1939593.60,2168387.40,228793.80,730083),('1','145','257894','359',630.00,720.00,0.00,2945.96,1855954.80,2081325.00,225370.20,730084),('1','145','257895','359',630.00,720.00,0.00,3457.02,2177922.60,2436246.00,258323.40,730085),('1','145','257896','359',630.00,720.00,0.00,3079.87,1940318.10,2173651.50,233333.40,730086),('1','145','257897','359',630.00,720.00,0.00,0.00,0.00,0.00,0.00,730087),('1','145','257898','359',630.00,720.00,0.00,4792.38,3019199.40,3358886.10,339686.70,730088),('1','145','257899','359',630.00,720.00,0.00,2111.69,1330364.70,1475605.60,145240.90,730089),('1','145','257900','359',630.00,720.00,0.00,2759.82,1738686.60,1937711.60,199025.00,730090),('1','145','257901','359',630.00,720.00,0.00,613.77,386675.10,436722.40,50047.30,730091),('1','145','257902','359',630.00,720.00,0.00,0.00,0.00,0.00,0.00,730092),('1','145','257903','359',630.00,720.00,0.00,428.85,270175.50,306132.00,35956.50,730093),('1','145','257904','359',630.00,720.00,0.00,2721.23,1714374.90,1906695.60,192320.70,730094),('1','145','257905','359',630.00,720.00,0.00,2607.00,1642410.00,1826092.40,183682.40,730095),('1','145','257906','359',630.00,720.00,0.00,3991.20,2514456.00,2801585.60,287129.60,730096),('1','145','257907','359',630.00,720.00,0.00,1961.01,1235436.30,1370340.00,134903.70,730097),('1','145','257908','359',630.00,720.00,0.00,2673.46,1684279.80,1870122.40,185842.60,730098),('1','145','257909','359',630.00,720.00,0.00,2496.75,1572952.50,1750850.00,177897.50,730099),('1','145','257910','359',630.00,720.00,0.00,2195.72,1383303.60,1545287.20,161983.60,730100),('1','145','257911','359',630.00,720.00,0.00,339.83,214092.90,242324.80,28231.90,730101),('1','145','257912','359',630.00,720.00,0.00,1421.12,895305.60,994126.00,98820.40,730102),('1','145','257913','359',630.00,720.00,0.00,2667.27,1680380.10,1878572.80,198192.70,730103),('1','145','257914','359',630.00,720.00,0.00,0.00,0.00,0.00,0.00,730104),('1','145','257915','359',630.00,720.00,0.00,3784.49,2384228.70,2651872.00,267643.30,730105),('1','145','257916','359',630.00,720.00,0.00,1491.77,939815.10,1047408.80,107593.70,730106),('1','145','257917','359',630.00,720.00,0.00,2717.90,1712277.00,1914756.00,202479.00,730107),('1','145','257918','359',630.00,720.00,0.00,2683.30,1690479.00,1890594.40,200115.40,730108),('1','145','257919','359',630.00,720.00,0.00,3542.68,2231888.40,2480021.20,248132.80,730109),('1','145','257920','359',630.00,720.00,0.00,2459.21,1549302.30,1742044.00,192741.70,730110),('1','145','257921','359',630.00,720.00,0.00,3501.79,2206127.70,2457462.40,251334.70,730111),('1','145','257922','359',630.00,720.00,0.00,647.60,407988.00,453481.50,45493.50,730112),('1','145','257923','359',630.00,720.00,0.00,4880.93,3074985.90,3393977.10,318991.20,730113),('1','145','257924','359',630.00,720.00,0.00,5485.12,3455625.60,3735143.90,279518.30,730114),('1','145','257925','359',630.00,720.00,0.00,6647.32,4187811.60,4524721.90,336910.30,730115),('1','145','257926','359',630.00,720.00,0.00,4549.15,2865964.50,3096227.00,230262.50,730116),('1','145','257927','359',630.00,720.00,0.00,3235.50,2038365.00,2199415.50,161050.50,730117),('1','145','257928','359',630.00,720.00,0.00,0.00,0.00,0.00,0.00,730118),('1','145','257929','359',630.00,720.00,0.00,2808.03,1769058.90,1923378.10,154319.20,730119),('1','145','257930','359',630.00,720.00,0.00,6735.49,4243358.70,4613782.80,370424.10,730120),('1','145','257931','359',630.00,720.00,0.00,6384.81,4022430.30,4383341.20,360910.90,730121),('1','145','257932','359',630.00,720.00,0.00,2850.71,1795947.30,1942735.20,146787.90,730122),('1','145','257933','359',630.00,720.00,0.00,4796.38,3021719.40,3260852.60,239133.20,730123),('1','145','257934','359',630.00,720.00,0.00,66.67,42002.10,45502.40,3500.30,730124),('1','145','257935','359',630.00,720.00,0.00,0.00,0.00,0.00,0.00,730125),('1','145','257936','359',630.00,720.00,0.00,0.00,0.00,0.00,0.00,730126),('1','145','257937','359',630.00,720.00,0.00,2292.86,1444501.80,1570915.20,126413.40,730127),('1','145','257938','359',630.00,720.00,0.00,5808.68,3659468.40,3937661.10,278192.70,730128),('1','145','257939','359',630.00,720.00,0.00,6362.41,4008318.30,4330348.40,322030.10,730129),('1','145','257940','359',630.00,720.00,0.00,6623.33,4172697.90,4485182.00,312484.10,730130),('1','145','257941','359',630.00,720.00,0.00,703.32,443091.60,481944.90,38853.30,730131),('1','145','257942','359',630.00,720.00,0.00,8233.55,5187136.50,5600966.50,413830.00,730132),('1','145','257943','359',630.00,720.00,0.00,0.00,0.00,0.00,0.00,730133),('1','145','257944','359',630.00,720.00,0.00,4571.05,2879761.50,3109626.00,229864.50,730134),('1','145','257945','359',630.00,720.00,0.00,10178.31,6412335.30,6904757.70,492422.40,730135),('1','145','257946','359',630.00,720.00,0.00,1430.47,901196.10,968679.40,67483.30,730136),('1','145','257947','359',630.00,720.00,0.00,0.00,0.00,0.00,0.00,730137),('1','145','257948','359',630.00,720.00,0.00,3057.37,1926143.10,2077642.40,151499.30,730138),('1','145','257949','359',630.00,720.00,0.00,10647.38,6707849.40,7227967.10,520117.70,730139),('1','145','257950','359',630.00,720.00,0.00,9073.31,5716185.30,6164887.70,448702.40,730140),('1','145','257951','359',630.00,720.00,0.00,1594.24,1004371.20,1082404.30,78033.10,730141),('1','145','257952','359',630.00,720.00,0.00,7559.03,4762188.90,5169299.60,407110.70,730142),('1','145','257953','359',630.00,720.00,0.00,3942.00,2483460.00,2687994.50,204534.50,730143),('1','145','257954','359',630.00,720.00,0.00,0.00,0.00,0.00,0.00,730144),('1','145','257955','359',630.00,720.00,0.00,4093.32,2578791.60,2828478.40,249686.80,730145),('1','145','257956','359',630.00,720.00,0.00,4028.57,2537999.10,2765606.40,227607.30,730146),('1','145','257957','359',630.00,720.00,0.00,3618.40,2279592.00,2481782.50,202190.50,730147),('1','145','257958','359',630.00,720.00,0.00,1268.44,799117.20,864145.30,65028.10,730148),('1','145','257959','359',630.00,720.00,0.00,2611.56,1645282.80,1795349.20,150066.40,730149),('1','145','257960','359',630.00,720.00,0.00,5754.49,3625328.70,3914013.30,288684.60,730150),('1','145','257961','359',630.00,720.00,0.00,4393.84,2768119.20,3025134.30,257015.10,730151),('1','145','257962','359',630.00,720.00,0.00,3628.43,2285910.90,2477359.60,191448.70,730152),('1','145','257963','359',630.00,720.00,0.00,5098.52,3212067.60,3483288.90,271221.30,730153),('1','145','257964','359',630.00,720.00,0.00,1940.37,1222433.10,1329252.40,106819.30,730154),('1','145','257965','359',630.00,720.00,0.00,0.00,0.00,0.00,0.00,730155),('1','145','257966','359',630.00,720.00,0.00,0.00,0.00,0.00,0.00,730156),('1','145','257967','359',630.00,720.00,0.00,0.00,0.00,0.00,0.00,730157),('1','145','257968','359',630.00,720.00,0.00,5420.70,3415041.00,3701895.00,286854.00,730158),('1','145','257969','359',630.00,720.00,0.00,53.83,33912.90,37057.60,3144.70,730159),('1','145','257970','359',630.00,720.00,0.00,4889.08,3080120.40,3354803.10,274682.70,730160),('1','145','257971','359',630.00,720.00,0.00,3368.80,2122344.00,2299769.00,177425.00,730161),('1','145','257972','359',630.00,720.00,0.00,4301.39,2709875.70,2957561.80,247686.10,730162),('1','145','257973','359',630.00,720.00,0.00,4456.85,2807815.50,3060296.50,252481.00,730163),('1','145','257974','359',630.00,720.00,0.00,1314.93,828405.90,896422.60,68016.70,730164),('1','145','257975','359',630.00,720.00,0.00,4834.04,3045445.20,3310924.30,265479.10,730165),('1','145','257976','359',630.00,720.00,0.00,3974.32,2503821.60,2721825.40,218003.80,730166),('1','145','257977','359',630.00,720.00,0.00,6194.34,3902434.20,4255763.80,353329.60,730167),('1','145','257978','359',630.00,720.00,0.00,3380.19,2129519.70,2326318.30,196798.60,730168),('1','145','257979','359',630.00,720.00,0.00,4739.10,2985633.00,3239746.50,254113.50,730169),('1','145','257980','359',630.00,720.00,0.00,0.00,0.00,0.00,0.00,730170),('1','145','257981','359',630.00,720.00,0.00,1285.72,810003.60,876444.90,66441.30,730171),('1','145','257982','359',630.00,720.00,0.00,4166.24,2624731.20,2846245.30,221514.10,730172),('1','145','257983','359',630.00,720.00,0.00,2772.69,1746794.70,1906730.30,159935.60,730173),('1','145','257984','359',630.00,720.00,0.00,3828.09,2411696.70,2633339.30,221642.60,730174),('1','145','257985','359',630.00,720.00,0.00,0.00,0.00,0.00,0.00,730175),('1','145','257986','359',630.00,720.00,0.00,4037.67,2543732.10,2759457.40,215725.30,730176),('1','145','257987','359',630.00,720.00,0.00,4971.63,3132126.90,3406577.10,274450.20,730177),('1','145','257988','359',630.00,720.00,0.00,4086.11,2574249.30,2793820.70,219571.40,730178),('1','145','257989','359',630.00,720.00,0.00,1037.54,653650.20,704146.80,50496.60,730179),('1','145','257990','359',630.00,720.00,0.00,5576.09,3512936.70,3818894.80,305958.10,730180),('1','145','257991','359',630.00,720.00,0.00,4885.42,3077814.60,3353569.90,275755.30,730181),('1','145','257992','359',630.00,720.00,0.00,3788.48,2386742.40,2617040.10,230297.70,730182),('1','145','257993','359',630.00,720.00,0.00,6483.07,4084334.10,4440774.90,356440.80,730183),('1','145','257994','359',630.00,720.00,0.00,2827.97,1781621.10,1943490.40,161869.30,730184),('1','145','257995','359',630.00,720.00,0.00,0.00,0.00,0.00,0.00,730185),('1','145','257996','359',630.00,720.00,0.00,241.88,148291.65,165968.60,17676.95,730186),('1','145','257997','359',605.00,720.00,0.00,3685.78,2229896.90,2527014.60,297117.70,730187),('1','145','257998','359',605.00,720.00,0.00,3932.62,2379235.10,2716621.40,337386.30,730188),('1','145','257999','359',605.00,720.00,0.00,3748.45,2267812.25,2574604.00,306791.75,730189),('1','145','258000','359',605.00,720.00,0.00,3425.78,2072596.90,2391853.10,319256.20,730190),('1','145','258001','359',605.00,720.00,0.00,3585.37,2169148.85,2487716.90,318568.05,730191),('1','145','258002','359',605.00,720.00,0.00,5323.00,3220415.00,3656047.50,435632.50,730192),('1','145','258003','359',605.00,720.00,0.00,86.61,52399.05,61659.20,9260.15,730193),('1','145','258004','359',605.00,720.00,0.00,0.00,0.00,0.00,0.00,730194),('1','145','258005','359',605.00,720.00,0.00,4396.27,2659743.35,3016674.40,356931.05,730195),('1','145','258006','359',605.00,720.00,0.00,2867.87,1735061.35,1983197.90,248136.55,730196),('1','145','258007','359',605.00,720.00,0.00,2983.18,1804823.90,2054803.10,249979.20,730197),('1','145','258008','359',605.00,720.00,0.00,2943.51,1780823.55,2040224.70,259401.15,730198),('1','145','258009','359',605.00,720.00,0.00,4456.82,2696376.10,3085392.40,389016.30,730199),('1','145','258010','359',605.00,720.00,0.00,1968.31,1190827.55,1375416.70,184589.15,730200),('1','145','258011','359',605.00,720.00,0.00,4404.31,2664607.55,3038406.20,373798.65,730201),('1','145','258012','359',605.00,720.00,0.00,0.00,0.00,0.00,0.00,730202),('1','145','258013','359',605.00,720.00,0.00,4298.27,2600453.35,2956052.40,355599.05,730203),('1','145','258014','359',605.00,720.00,0.00,3815.31,2308262.55,2635431.20,327168.65,730204),('1','145','258015','359',605.00,720.00,0.00,4805.82,2907521.10,3304327.90,396806.80,730205),('1','145','258016','359',605.00,720.00,0.00,3056.48,1849170.40,2114212.60,265042.20,730206),('1','145','258017','359',605.00,720.00,0.00,4772.40,2887302.00,3313168.00,425866.00,730207),('1','145','258018','359',605.00,720.00,0.00,1880.40,1137642.00,1306811.50,169169.50,730208),('1','145','258019','359',605.00,720.00,0.00,793.39,480000.95,551011.80,71010.85,730209),('1','145','258020','359',605.00,720.00,0.00,0.00,0.00,0.00,0.00,730210),('1','145','258021','359',605.00,720.00,0.00,831.83,503257.15,559762.10,56504.95,730211),('1','145','258022','359',605.00,720.00,0.00,3186.73,1927971.65,2209758.10,281786.45,730212),('1','145','258023','359',605.00,720.00,0.00,3148.01,1904546.05,2168720.20,264174.15,730213),('1','145','258024','359',605.00,720.00,0.00,3581.58,2166855.90,2470501.10,303645.20,730214),('1','145','258025','359',605.00,720.00,0.00,4137.42,2503139.10,2871524.90,368385.80,730215),('1','145','258026','359',605.00,720.00,0.00,4792.27,2899323.35,3276670.90,377347.55,730216),('1','145','258027','359',605.00,720.00,0.00,4445.51,2689533.55,3038019.70,348486.15,730217),('1','145','258028','359',605.00,720.00,0.00,0.00,0.00,0.00,0.00,730218),('1','145','258029','359',605.00,720.00,0.00,638.00,385990.00,442394.00,56404.00,730219);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=328 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',327,'145','PRODUCT TANKS','TANKS CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=828 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','145','327',826,1,'359','LPG TANK 1',22000.00,1.00,10488.20,'TANK CONTAINING LPG PRODUCT.','479','2020-10-06 13:10:32','2020-10-06 13:10:32','479',5,1),('1','145','327',827,1,'359','LPG TANK 2',22000.00,1.00,16249.60,'TANK CONTAINING LPG PRODUCT.','479','2020-10-06 13:12:07','2020-10-06 13:12:07','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','145',826,21362.00,'2023-03-20 18:13:45'),(2,'1','145',827,826.65,'2023-03-20 18:13:14');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2742375 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2108319,'1','145','827',359,'Retail Sale Id 1254177',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 06:38:33','',''),(2108320,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:38:33','',''),(2108337,'1','145','827',359,'Retail Sale Id 1254186',2760.00,0.00,0.00,0.00,540.00,'2021-12-01 06:40:15','',''),(2108338,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 06:40:15','',''),(2108357,'1','145','827',359,'Retail Sale Id 1254196',75400.00,0.00,0.00,0.00,11020.00,'2021-12-01 06:42:03','',''),(2108358,'1','145','827',359,'Retail sales',0.00,0.00,0.00,116.00,0.00,'2021-12-01 06:42:03','',''),(2108389,'1','145','827',359,'Retail Sale Id 1254211',39000.00,0.00,0.00,0.00,5700.00,'2021-12-01 06:44:58','',''),(2108390,'1','145','827',359,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-01 06:44:58','',''),(2108399,'1','145','827',359,'Retail Sale Id 1254219',65000.00,0.00,0.00,0.00,9500.00,'2021-12-01 06:46:18','',''),(2108400,'1','145','827',359,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-01 06:46:18','',''),(2108423,'1','145','827',359,'Retail Sale Id 1254229',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 06:47:49','',''),(2108424,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:47:49','',''),(2108454,'1','145','827',359,'Retail Sale Id 1254240',17250.00,0.00,0.00,0.00,3375.00,'2021-12-01 06:49:34','',''),(2108455,'1','145','827',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 06:49:34','',''),(2108476,'1','145','827',359,'Retail Sale Id 1254252',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 06:51:17','',''),(2108477,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 06:51:17','',''),(2108497,'1','145','827',359,'Retail Sale Id 1254259',1380.00,0.00,0.00,0.00,270.00,'2021-12-01 06:52:04','',''),(2108498,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 06:52:04','',''),(2108514,'1','145','827',359,'Retail Sale Id 1254267',1380.00,0.00,0.00,0.00,270.00,'2021-12-01 06:53:03','',''),(2108515,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 06:53:03','',''),(2108540,'1','145','827',359,'Retail Sale Id 1254280',6900.00,0.00,0.00,0.00,1350.00,'2021-12-01 06:54:13','',''),(2108541,'1','145','827',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 06:54:13','',''),(2108581,'1','145','827',359,'Retail Sale Id 1254300',1380.00,0.00,0.00,0.00,270.00,'2021-12-01 06:55:49','',''),(2108582,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 06:55:49','',''),(2108628,'1','145','827',359,'Retail Sale Id 1254326',4485.00,0.00,0.00,0.00,877.50,'2021-12-01 06:57:44','',''),(2108629,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-01 06:57:44','',''),(2108707,'1','145','827',359,'Retail Sale Id 1254360',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 07:01:23','',''),(2108708,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:01:23','',''),(2108815,'1','145','827',359,'Retail Sale Id 1254404',4830.00,0.00,0.00,0.00,945.00,'2021-12-01 07:06:35','',''),(2108816,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 07:06:35','',''),(2108842,'1','145','827',359,'Retail Sale Id 1254419',2001.00,0.00,0.00,0.00,391.50,'2021-12-01 07:08:42','',''),(2108843,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-01 07:08:42','',''),(2108967,'1','145','827',359,'Retail Sale Id 1254465',11730.00,0.00,0.00,0.00,2295.00,'2021-12-01 07:13:03','',''),(2108968,'1','145','827',359,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-01 07:13:03','',''),(2108975,'1','145','827',359,'Retail Sale Id 1254469',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 07:13:33','',''),(2108976,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:13:33','',''),(2109011,'1','145','827',359,'Retail Sale Id 1254484',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 07:15:34','',''),(2109012,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:15:34','',''),(2109027,'1','145','827',359,'Retail Sale Id 1254495',32500.00,0.00,0.00,0.00,4750.00,'2021-12-01 07:16:36','',''),(2109028,'1','145','827',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 07:16:36','',''),(2109049,'1','145','827',359,'Retail Sale Id 1254508',1380.00,0.00,0.00,0.00,270.00,'2021-12-01 07:17:53','',''),(2109050,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 07:17:53','',''),(2109075,'1','145','827',359,'Retail Sale Id 1254524',2691.00,0.00,0.00,0.00,526.50,'2021-12-01 07:19:10','',''),(2109076,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.90,0.00,'2021-12-01 07:19:10','',''),(2109265,'1','145','827',359,'Retail Sale Id 1254590',1380.00,0.00,0.00,0.00,270.00,'2021-12-01 07:27:56','',''),(2109266,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 07:27:56','',''),(2109312,'1','145','827',359,'Retail Sale Id 1254609',2484.00,0.00,0.00,0.00,486.00,'2021-12-01 07:30:21','',''),(2109313,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.60,0.00,'2021-12-01 07:30:21','',''),(2109332,'1','145','827',359,'Retail Sale Id 1254621',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 07:31:37','',''),(2109333,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 07:31:37','',''),(2109376,'1','145','827',359,'Retail Sale Id 1254650',7590.00,0.00,0.00,0.00,1485.00,'2021-12-01 07:33:59','',''),(2109377,'1','145','827',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-01 07:33:59','',''),(2109398,'1','145','827',359,'Retail Sale Id 1254661',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 07:34:56','',''),(2109399,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:34:56','',''),(2109450,'1','145','827',359,'Retail Sale Id 1254691',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 07:37:15','',''),(2109451,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 07:37:15','',''),(2109502,'1','145','827',359,'Retail Sale Id 1254720',1380.00,0.00,0.00,0.00,270.00,'2021-12-01 07:39:51','',''),(2109503,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 07:39:51','',''),(2109545,'1','145','827',359,'Retail Sale Id 1254726',36400.00,0.00,0.00,0.00,5320.00,'2021-12-01 07:40:46','',''),(2109546,'1','145','827',359,'Retail sales',0.00,0.00,0.00,56.00,0.00,'2021-12-01 07:40:46','',''),(2109592,'1','145','827',359,'Retail Sale Id 1254748',2760.00,0.00,0.00,0.00,540.00,'2021-12-01 07:42:47','',''),(2109593,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 07:42:47','',''),(2109602,'1','145','827',359,'Retail Sale Id 1254753',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 07:43:29','',''),(2109603,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:43:29','',''),(2109641,'1','145','827',359,'Retail Sale Id 1254772',1449.00,0.00,0.00,0.00,283.50,'2021-12-01 07:45:14','',''),(2109642,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-01 07:45:14','',''),(2109673,'1','145','827',359,'Retail Sale Id 1254778',1380.00,0.00,0.00,0.00,270.00,'2021-12-01 07:45:58','',''),(2109674,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 07:45:58','',''),(2109713,'1','145','827',359,'Retail Sale Id 1254799',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 07:47:34','',''),(2109714,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 07:47:34','',''),(2109738,'1','145','827',359,'Retail Sale Id 1254813',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 07:48:34','',''),(2109739,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 07:48:34','',''),(2109788,'1','145','827',359,'Retail Sale Id 1254835',1380.00,0.00,0.00,0.00,270.00,'2021-12-01 07:50:56','',''),(2109789,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 07:50:56','',''),(2109802,'1','145','827',359,'Retail Sale Id 1254841',35750.00,0.00,0.00,0.00,5225.00,'2021-12-01 07:52:01','',''),(2109803,'1','145','827',359,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-01 07:52:01','',''),(2109854,'1','145','827',359,'Retail Sale Id 1254860',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 07:54:12','',''),(2109855,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 07:54:12','',''),(2109866,'1','145','827',359,'Retail Sale Id 1254869',4830.00,0.00,0.00,0.00,945.00,'2021-12-01 07:55:03','',''),(2109867,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 07:55:03','',''),(2109899,'1','145','827',359,'Retail Sale Id 1254895',91425.00,0.00,0.00,0.00,17887.50,'2021-12-01 07:57:04','',''),(2109900,'1','145','827',359,'Retail sales',0.00,0.00,0.00,132.50,0.00,'2021-12-01 07:57:04','',''),(2109917,'1','145','827',359,'Return of Retail Sale Id 1254895',0.00,91425.00,132.50,0.00,-17887.50,'2021-12-01 07:57:36','',''),(2109938,'1','145','827',359,'Retail Sale Id 1254908',86125.00,0.00,0.00,0.00,12587.50,'2021-12-01 07:58:52','',''),(2109939,'1','145','827',359,'Retail sales',0.00,0.00,0.00,132.50,0.00,'2021-12-01 07:58:52','',''),(2109969,'1','145','827',359,'Retail Sale Id 1254926',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 08:01:04','',''),(2109970,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:01:04','',''),(2109981,'1','145','827',359,'Retail Sale Id 1254931',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 08:01:49','',''),(2109982,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:01:49','',''),(2110007,'1','145','827',359,'Retail Sale Id 1254948',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 08:02:55','',''),(2110008,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 08:02:55','',''),(2110046,'1','145','827',359,'Retail Sale Id 1254968',4692.00,0.00,0.00,0.00,918.00,'2021-12-01 08:04:31','',''),(2110047,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.80,0.00,'2021-12-01 08:04:31','',''),(2110058,'1','145','827',359,'Retail Sale Id 1254972',2760.00,0.00,0.00,0.00,540.00,'2021-12-01 08:05:16','',''),(2110059,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 08:05:16','',''),(2110122,'1','145','827',359,'Retail Sale Id 1254997',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 08:09:07','',''),(2110123,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:09:07','',''),(2110154,'1','145','827',359,'Retail Sale Id 1255011',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 08:10:18','',''),(2110155,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:10:18','',''),(2110166,'1','145','827',359,'Retail Sale Id 1255016',39000.00,0.00,0.00,0.00,5700.00,'2021-12-01 08:11:32','',''),(2110167,'1','145','827',359,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-01 08:11:32','',''),(2110186,'1','145','827',359,'Retail Sale Id 1255019',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 08:12:51','',''),(2110187,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:12:51','',''),(2110210,'1','145','827',359,'Retail Sale Id 1255039',61100.00,0.00,0.00,0.00,8930.00,'2021-12-01 08:14:06','',''),(2110211,'1','145','827',359,'Retail sales',0.00,0.00,0.00,94.00,0.00,'2021-12-01 08:14:06','',''),(2110250,'1','145','827',359,'Retail Sale Id 1255057',7590.00,0.00,0.00,0.00,1485.00,'2021-12-01 08:16:27','',''),(2110251,'1','145','827',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-01 08:16:27','',''),(2110294,'1','145','827',359,'Retail Sale Id 1255083',4830.00,0.00,0.00,0.00,945.00,'2021-12-01 08:18:22','',''),(2110295,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 08:18:22','',''),(2110320,'1','145','827',359,'Retail Sale Id 1255100',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 08:20:01','',''),(2110321,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 08:20:01','',''),(2110340,'1','145','827',359,'Retail Sale Id 1255105',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 08:20:47','',''),(2110341,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:20:47','',''),(2110360,'1','145','827',359,'Retail Sale Id 1255117',81250.00,0.00,0.00,0.00,11875.00,'2021-12-01 08:21:57','',''),(2110361,'1','145','827',359,'Retail sales',0.00,0.00,0.00,125.00,0.00,'2021-12-01 08:21:57','',''),(2110445,'1','145','827',359,'Retail Sale Id 1255161',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 08:28:11','',''),(2110446,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 08:28:11','',''),(2110485,'1','145','827',359,'Retail Sale Id 1255182',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 08:30:55','',''),(2110486,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:30:55','',''),(2110513,'1','145','827',359,'Retail Sale Id 1255191',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 08:32:05','',''),(2110514,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:32:05','',''),(2110529,'1','145','827',359,'Retail Sale Id 1255201',26000.00,0.00,0.00,0.00,3800.00,'2021-12-01 08:32:55','',''),(2110530,'1','145','827',359,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-01 08:32:55','',''),(2110546,'1','145','827',359,'Retail Sale Id 1255207',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 08:33:30','',''),(2110547,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:33:30','',''),(2110558,'1','145','827',359,'Retail Sale Id 1255216',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 08:34:18','',''),(2110559,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:34:18','',''),(2110572,'1','145','827',359,'Retail Sale Id 1255220',4830.00,0.00,0.00,0.00,945.00,'2021-12-01 08:35:00','',''),(2110573,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 08:35:00','',''),(2110582,'1','145','827',359,'Retail Sale Id 1255225',4830.00,0.00,0.00,0.00,945.00,'2021-12-01 08:35:43','',''),(2110585,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 08:35:43','',''),(2110598,'1','145','827',359,'Retail Sale Id 1255233',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 08:37:08','',''),(2110599,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:37:08','',''),(2110619,'1','145','827',359,'Retail Sale Id 1255238',2967.00,0.00,0.00,0.00,580.50,'2021-12-01 08:38:04','',''),(2110620,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.30,0.00,'2021-12-01 08:38:04','',''),(2110690,'1','145','827',359,'Retail Sale Id 1255272',13000.00,0.00,0.00,0.00,1900.00,'2021-12-01 08:41:26','',''),(2110691,'1','145','827',359,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-01 08:41:26','',''),(2110724,'1','145','827',359,'Retail Sale Id 1255289',4830.00,0.00,0.00,0.00,945.00,'2021-12-01 08:43:06','',''),(2110725,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 08:43:06','',''),(2110766,'1','145','827',359,'Retail Sale Id 1255312',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 08:46:05','',''),(2110767,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:46:05','',''),(2110802,'1','145','827',359,'Retail Sale Id 1255336',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 08:48:02','',''),(2110803,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 08:48:02','',''),(2110816,'1','145','827',359,'Retail Sale Id 1255348',2967.00,0.00,0.00,0.00,580.50,'2021-12-01 08:49:06','',''),(2110817,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.30,0.00,'2021-12-01 08:49:06','',''),(2110836,'1','145','827',359,'Retail Sale Id 1255355',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 08:50:09','',''),(2110837,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:50:09','',''),(2110892,'1','145','827',359,'Retail Sale Id 1255384',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 08:53:47','',''),(2110893,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:53:47','',''),(2110922,'1','145','827',359,'Retail Sale Id 1255402',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 08:55:32','',''),(2110923,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 08:55:32','',''),(2110951,'1','145','827',359,'Retail Sale Id 1255417',2760.00,0.00,0.00,0.00,540.00,'2021-12-01 08:57:03','',''),(2110952,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 08:57:03','',''),(2110957,'1','145','827',359,'Retail Sale Id 1255422',4830.00,0.00,0.00,0.00,945.00,'2021-12-01 08:57:51','',''),(2110958,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 08:57:51','',''),(2110983,'1','145','827',359,'Retail Sale Id 1255433',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 08:59:14','',''),(2110984,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:59:14','',''),(2111004,'1','145','827',359,'Retail Sale Id 1255444',5520.00,0.00,0.00,0.00,1080.00,'2021-12-01 09:00:33','',''),(2111005,'1','145','827',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 09:00:33','',''),(2111032,'1','145','827',359,'Retail Sale Id 1255455',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 09:02:02','',''),(2111033,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:02:02','',''),(2111078,'1','145','827',359,'Retail Sale Id 1255479',2001.00,0.00,0.00,0.00,391.50,'2021-12-01 09:04:17','',''),(2111079,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-01 09:04:17','',''),(2111098,'1','145','827',359,'Retail Sale Id 1255487',8280.00,0.00,0.00,0.00,1620.00,'2021-12-01 09:05:09','',''),(2111099,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-01 09:05:09','',''),(2111126,'1','145','827',359,'Retail Sale Id 1255500',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 09:07:15','',''),(2111127,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:07:15','',''),(2111190,'1','145','827',359,'Retail Sale Id 1255537',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 09:11:53','',''),(2111191,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 09:11:53','',''),(2111212,'1','145','827',359,'Retail Sale Id 1255544',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 09:13:12','',''),(2111213,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:13:12','',''),(2111264,'1','145','827',359,'Retail Sale Id 1255577',4830.00,0.00,0.00,0.00,945.00,'2021-12-01 09:15:53','',''),(2111265,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 09:15:53','',''),(2111276,'1','145','827',359,'Retail Sale Id 1255586',2760.00,0.00,0.00,0.00,540.00,'2021-12-01 09:16:27','',''),(2111277,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 09:16:27','',''),(2111299,'1','145','827',359,'Retail Sale Id 1255594',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 09:18:04','',''),(2111300,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:18:04','',''),(2111334,'1','145','827',359,'Retail Sale Id 1255619',2760.00,0.00,0.00,0.00,540.00,'2021-12-01 09:20:09','',''),(2111335,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 09:20:09','',''),(2111364,'1','145','827',359,'Retail Sale Id 1255633',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 09:22:31','',''),(2111365,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:22:31','',''),(2111470,'1','145','827',359,'Retail Sale Id 1255681',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 09:27:58','',''),(2111471,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:27:58','',''),(2111482,'1','145','827',359,'Retail Sale Id 1255690',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 09:28:48','',''),(2111483,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:28:48','',''),(2111508,'1','145','827',359,'Retail Sale Id 1255705',2760.00,0.00,0.00,0.00,540.00,'2021-12-01 09:30:57','',''),(2111509,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 09:30:57','',''),(2111518,'1','145','827',359,'Retail Sale Id 1255708',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 09:31:44','',''),(2111519,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:31:44','',''),(2111524,'1','145','827',359,'Retail Sale Id 1255713',2001.00,0.00,0.00,0.00,391.50,'2021-12-01 09:32:36','',''),(2111525,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-01 09:32:36','',''),(2111545,'1','145','827',359,'Retail Sale Id 1255720',8280.00,0.00,0.00,0.00,1620.00,'2021-12-01 09:33:58','',''),(2111546,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-01 09:33:58','',''),(2111571,'1','145','827',359,'Retail Sale Id 1255738',9660.00,0.00,0.00,0.00,1890.00,'2021-12-01 09:35:48','',''),(2111572,'1','145','827',359,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-01 09:35:48','',''),(2111615,'1','145','827',359,'Retail Sale Id 1255761',61100.00,0.00,0.00,0.00,8930.00,'2021-12-01 09:37:49','',''),(2111616,'1','145','827',359,'Retail sales',0.00,0.00,0.00,94.00,0.00,'2021-12-01 09:37:49','',''),(2111654,'1','145','827',359,'Retail Sale Id 1255784',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 09:40:11','',''),(2111655,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:40:11','',''),(2111674,'1','145','827',359,'Retail Sale Id 1255793',2001.00,0.00,0.00,0.00,391.50,'2021-12-01 09:41:51','',''),(2111675,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-01 09:41:51','',''),(2111702,'1','145','827',359,'Retail Sale Id 1255810',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 09:44:14','',''),(2111703,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:44:14','',''),(2111748,'1','145','827',359,'Retail Sale Id 1255837',4830.00,0.00,0.00,0.00,945.00,'2021-12-01 09:47:11','',''),(2111749,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 09:47:11','',''),(2111772,'1','145','827',359,'Retail Sale Id 1255851',6003.00,0.00,0.00,0.00,1174.50,'2021-12-01 09:48:47','',''),(2111773,'1','145','827',359,'Retail sales',0.00,0.00,0.00,8.70,0.00,'2021-12-01 09:48:47','',''),(2111798,'1','145','827',359,'Retail Sale Id 1255863',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 09:51:18','',''),(2111799,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:51:18','',''),(2111823,'1','145','827',359,'Retail Sale Id 1255871',2001.00,0.00,0.00,0.00,391.50,'2021-12-01 09:52:54','',''),(2111824,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-01 09:52:54','',''),(2111855,'1','145','827',359,'Retail Sale Id 1255888',17940.00,0.00,0.00,0.00,3510.00,'2021-12-01 09:55:21','',''),(2111856,'1','145','827',359,'Retail sales',0.00,0.00,0.00,26.00,0.00,'2021-12-01 09:55:21','',''),(2111876,'1','145','827',359,'Retail Sale Id 1255896',2760.00,0.00,0.00,0.00,540.00,'2021-12-01 09:56:43','',''),(2111877,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 09:56:43','',''),(2111993,'1','145','827',359,'Retail Sale Id 1255948',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 10:02:52','',''),(2111994,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 10:02:52','',''),(2112039,'1','145','827',359,'Retail Sale Id 1255971',2001.00,0.00,0.00,0.00,391.50,'2021-12-01 10:07:22','',''),(2112040,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-01 10:07:22','',''),(2112090,'1','145','827',359,'Retail Sale Id 1255997',2898.00,0.00,0.00,0.00,567.00,'2021-12-01 10:11:13','',''),(2112091,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-01 10:11:13','',''),(2112132,'1','145','827',359,'Retail Sale Id 1256021',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 10:13:41','',''),(2112133,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 10:13:41','',''),(2112323,'1','145','827',359,'Retail Sale Id 1256107',16560.00,0.00,0.00,0.00,3240.00,'2021-12-01 10:27:23','',''),(2112324,'1','145','827',359,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-01 10:27:23','',''),(2112343,'1','145','827',359,'Retail Sale Id 1256117',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 10:28:53','',''),(2112344,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 10:28:53','',''),(2112359,'1','145','827',359,'Retail Sale Id 1256125',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 10:30:20','',''),(2112360,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 10:30:20','',''),(2112401,'1','145','827',359,'Retail Sale Id 1256148',8970.00,0.00,0.00,0.00,1755.00,'2021-12-01 10:33:03','',''),(2112402,'1','145','827',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-01 10:33:03','',''),(2112425,'1','145','827',359,'Retail Sale Id 1256163',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 10:35:14','',''),(2112426,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 10:35:14','',''),(2112453,'1','145','827',359,'Retail Sale Id 1256173',1449.00,0.00,0.00,0.00,283.50,'2021-12-01 10:36:43','',''),(2112454,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-01 10:36:43','',''),(2112471,'1','145','827',359,'Retail Sale Id 1256181',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 10:38:02','',''),(2112472,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 10:38:02','',''),(2112554,'1','145','827',359,'Retail Sale Id 1256225',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 10:45:45','',''),(2112555,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 10:45:45','',''),(2112574,'1','145','827',359,'Retail Sale Id 1255987',2001.00,0.00,0.00,0.00,391.50,'2021-12-01 10:47:18','',''),(2112575,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-01 10:47:18','',''),(2112588,'1','145','827',359,'Retail Sale Id 1256242',6900.00,0.00,0.00,0.00,1350.00,'2021-12-01 10:47:59','',''),(2112589,'1','145','827',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 10:47:59','',''),(2112602,'1','145','827',359,'Retail Sale Id 1256251',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 10:49:23','',''),(2112603,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:49:23','',''),(2112632,'1','145','827',359,'Retail Sale Id 1256265',32500.00,0.00,0.00,0.00,4750.00,'2021-12-01 10:52:07','',''),(2112633,'1','145','827',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 10:52:07','',''),(2112654,'1','145','827',359,'Retail Sale Id 1256276',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 10:54:30','',''),(2112655,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 10:54:30','',''),(2112712,'1','145','827',359,'Retail Sale Id 1256309',2001.00,0.00,0.00,0.00,391.50,'2021-12-01 10:59:52','',''),(2112713,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-01 10:59:52','',''),(2112767,'1','145','827',359,'Retail Sale Id 1256334',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 11:04:14','',''),(2112768,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 11:04:14','',''),(2112929,'1','145','827',359,'Retail Sale Id 1256412',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 11:14:26','',''),(2112930,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 11:14:26','',''),(2112937,'1','145','827',359,'Retail Sale Id 1256416',2001.00,0.00,0.00,0.00,391.50,'2021-12-01 11:15:08','',''),(2112938,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-01 11:15:08','',''),(2113066,'1','145','827',359,'Retail Sale Id 1256472',2760.00,0.00,0.00,0.00,540.00,'2021-12-01 11:21:55','',''),(2113067,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 11:21:55','',''),(2113076,'1','145','827',359,'Retail Sale Id 1256478',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 11:22:36','',''),(2113077,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 11:22:36','',''),(2113088,'1','145','827',359,'Retail Sale Id 1256483',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 11:23:40','',''),(2113089,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 11:23:40','',''),(2113174,'1','145','827',359,'Retail Sale Id 1256521',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 11:27:52','',''),(2113175,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 11:27:52','',''),(2113192,'1','145','827',359,'Retail Sale Id 1256532',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 11:29:12','',''),(2113193,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:29:12','',''),(2113202,'1','145','827',359,'Retail Sale Id 1256537',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 11:30:10','',''),(2113203,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 11:30:10','',''),(2113224,'1','145','827',359,'Retail Sale Id 1256548',1449.00,0.00,0.00,0.00,283.50,'2021-12-01 11:31:41','',''),(2113225,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-01 11:31:41','',''),(2113268,'1','145','827',359,'Retail Sale Id 1256577',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 11:35:53','',''),(2113269,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 11:35:53','',''),(2113314,'1','145','827',359,'Retail Sale Id 1256599',11730.00,0.00,0.00,0.00,2295.00,'2021-12-01 11:39:06','',''),(2113315,'1','145','827',359,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-01 11:39:06','',''),(2113371,'1','145','827',359,'Retail Sale Id 1256630',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 11:43:02','',''),(2113372,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 11:43:02','',''),(2113449,'1','145','827',359,'Retail Sale Id 1256669',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 11:49:09','',''),(2113450,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 11:49:09','',''),(2113461,'1','145','827',359,'Retail Sale Id 1256676',10695.00,0.00,0.00,0.00,2092.50,'2021-12-01 11:50:08','',''),(2113462,'1','145','827',359,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-01 11:50:08','',''),(2113489,'1','145','827',359,'Retail Sale Id 1256688',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 11:52:21','',''),(2113490,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 11:52:21','',''),(2113581,'1','145','827',359,'Retail Sale Id 1256742',1449.00,0.00,0.00,0.00,283.50,'2021-12-01 12:00:42','',''),(2113582,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-01 12:00:42','',''),(2113603,'1','145','827',359,'Retail Sale Id 1256756',1380.00,0.00,0.00,0.00,270.00,'2021-12-01 12:03:33','',''),(2113604,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 12:03:33','',''),(2113611,'1','145','827',359,'Retail Sale Id 1256759',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 12:05:21','',''),(2113612,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 12:05:21','',''),(2113645,'1','145','827',359,'Retail Sale Id 1256778',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 12:09:05','',''),(2113646,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:09:05','',''),(2113751,'1','145','827',359,'Retail Sale Id 1256832',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 12:16:11','',''),(2113752,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:16:11','',''),(2113763,'1','145','827',359,'Retail Sale Id 1256838',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 12:17:08','',''),(2113764,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:17:08','',''),(2113837,'1','145','827',359,'Retail Sale Id 1256874',4830.00,0.00,0.00,0.00,945.00,'2021-12-01 12:21:17','',''),(2113838,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 12:21:17','',''),(2114025,'1','145','827',359,'Retail Sale Id 1256968',5520.00,0.00,0.00,0.00,1080.00,'2021-12-01 12:35:53','',''),(2114026,'1','145','827',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 12:35:53','',''),(2114035,'1','145','827',359,'Retail Sale Id 1256974',1380.00,0.00,0.00,0.00,270.00,'2021-12-01 12:37:30','',''),(2114036,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 12:37:30','',''),(2114073,'1','145','827',359,'Retail Sale Id 1256993',5520.00,0.00,0.00,0.00,1080.00,'2021-12-01 12:42:02','',''),(2114074,'1','145','827',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 12:42:02','',''),(2114119,'1','145','827',359,'Retail Sale Id 1257015',6900.00,0.00,0.00,0.00,1350.00,'2021-12-01 12:46:49','',''),(2114120,'1','145','827',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 12:46:49','',''),(2114158,'1','145','827',359,'Retail Sale Id 1257030',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 12:50:40','',''),(2114159,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 12:50:40','',''),(2114186,'1','145','827',359,'Retail Sale Id 1257049',4002.00,0.00,0.00,0.00,783.00,'2021-12-01 12:53:58','',''),(2114187,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-01 12:53:58','',''),(2114206,'1','145','827',359,'Retail Sale Id 1257060',139750.00,0.00,0.00,0.00,20425.00,'2021-12-01 12:56:29','',''),(2114207,'1','145','827',359,'Retail sales',0.00,0.00,0.00,215.00,0.00,'2021-12-01 12:56:29','',''),(2114236,'1','145','827',359,'Retail Sale Id 1257077',17250.00,0.00,0.00,0.00,3375.00,'2021-12-01 13:00:17','',''),(2114237,'1','145','827',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 13:00:17','',''),(2114252,'1','145','827',359,'Retail Sale Id 1257084',2760.00,0.00,0.00,0.00,540.00,'2021-12-01 13:01:44','',''),(2114253,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 13:01:44','',''),(2114272,'1','145','827',359,'Retail Sale Id 1257094',4830.00,0.00,0.00,0.00,945.00,'2021-12-01 13:02:58','',''),(2114273,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 13:02:58','',''),(2114285,'1','145','827',359,'Retail Sale Id 1257099',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 13:03:49','',''),(2114286,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 13:03:49','',''),(2114354,'1','145','827',359,'Retail Sale Id 1257120',2760.00,0.00,0.00,0.00,540.00,'2021-12-01 13:07:17','',''),(2114355,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 13:07:17','',''),(2114366,'1','145','827',359,'Retail Sale Id 1257126',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 13:08:43','',''),(2114367,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 13:08:43','',''),(2114376,'1','145','827',359,'Retail Sale Id 1257135',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 13:10:23','',''),(2114377,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 13:10:23','',''),(2114390,'1','145','827',359,'Retail Sale Id 1257181',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 13:11:02','',''),(2114391,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:11:02','',''),(2114474,'1','145','827',359,'Retail Sale Id 1257228',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 13:15:24','',''),(2114475,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 13:15:24','',''),(2114514,'1','145','827',359,'Retail Sale Id 1257248',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 13:18:57','',''),(2114515,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 13:18:57','',''),(2114627,'1','145','827',359,'Retail Sale Id 1257304',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 13:27:50','',''),(2114628,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 13:27:50','',''),(2114635,'1','145','827',359,'Retail Sale Id 1257307',7590.00,0.00,0.00,0.00,1485.00,'2021-12-01 13:28:35','',''),(2114636,'1','145','827',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-01 13:28:35','',''),(2114673,'1','145','827',359,'Retail Sale Id 1257327',2967.00,0.00,0.00,0.00,580.50,'2021-12-01 13:31:55','',''),(2114674,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.30,0.00,'2021-12-01 13:31:55','',''),(2114677,'1','145','827',359,'Retail Sale Id 1257329',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 13:32:41','',''),(2114678,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:32:41','',''),(2114699,'1','145','827',359,'Retail Sale Id 1257339',2001.00,0.00,0.00,0.00,391.50,'2021-12-01 13:34:07','',''),(2114700,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-01 13:34:07','',''),(2114725,'1','145','827',359,'Retail Sale Id 1257343',39000.00,0.00,0.00,0.00,5700.00,'2021-12-01 13:35:54','',''),(2114726,'1','145','827',359,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-01 13:35:54','',''),(2114841,'1','145','827',359,'Retail Sale Id 1257378',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 13:41:02','',''),(2114842,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:41:02','',''),(2114896,'1','145','827',359,'Retail Sale Id 1257397',4830.00,0.00,0.00,0.00,945.00,'2021-12-01 13:44:00','',''),(2114897,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 13:44:00','',''),(2114900,'1','145','827',359,'Retail Sale Id 1257400',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 13:44:30','',''),(2114901,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:44:30','',''),(2114938,'1','145','827',359,'Retail Sale Id 1257407',17250.00,0.00,0.00,0.00,3375.00,'2021-12-01 13:46:06','',''),(2114939,'1','145','827',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 13:46:06','',''),(2114950,'1','145','827',359,'Retail Sale Id 1257415',65000.00,0.00,0.00,0.00,9500.00,'2021-12-01 13:47:01','',''),(2114951,'1','145','827',359,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-01 13:47:01','',''),(2114979,'1','145','827',359,'Retail Sale Id 1257424',1380.00,0.00,0.00,0.00,270.00,'2021-12-01 13:48:46','',''),(2114980,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 13:48:46','',''),(2114996,'1','145','827',359,'Retail Sale Id 1257434',4002.00,0.00,0.00,0.00,783.00,'2021-12-01 13:49:34','',''),(2114997,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-01 13:49:34','',''),(2115049,'1','145','827',359,'Retail Sale Id 1257456',22750.00,0.00,0.00,0.00,3325.00,'2021-12-01 13:52:50','',''),(2115050,'1','145','827',359,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-01 13:52:50','',''),(2115124,'1','145','827',359,'Retail Sale Id 1257495',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 13:56:51','',''),(2115125,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 13:56:51','',''),(2115136,'1','145','827',359,'Retail Sale Id 1257500',1449.00,0.00,0.00,0.00,283.50,'2021-12-01 13:57:42','',''),(2115137,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-01 13:57:42','',''),(2115158,'1','145','827',359,'Retail Sale Id 1257511',2760.00,0.00,0.00,0.00,540.00,'2021-12-01 13:58:28','',''),(2115159,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 13:58:28','',''),(2115184,'1','145','827',359,'Retail Sale Id 1257523',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 13:59:40','',''),(2115185,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:59:40','',''),(2115224,'1','145','827',359,'Retail Sale Id 1257544',39000.00,0.00,0.00,0.00,5700.00,'2021-12-01 14:01:40','',''),(2115225,'1','145','827',359,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-01 14:01:40','',''),(2115239,'1','145','827',359,'Retail Sale Id 1257550',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 14:02:27','',''),(2115240,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 14:02:27','',''),(2115265,'1','145','827',359,'Retail Sale Id 1257560',4002.00,0.00,0.00,0.00,783.00,'2021-12-01 14:03:43','',''),(2115266,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-01 14:03:43','',''),(2115287,'1','145','827',359,'Retail Sale Id 1257571',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 14:05:17','',''),(2115288,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 14:05:17','',''),(2115347,'1','145','827',359,'Retail Sale Id 1257602',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 14:09:23','',''),(2115348,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 14:09:23','',''),(2115367,'1','145','827',359,'Retail Sale Id 1257621',8280.00,0.00,0.00,0.00,1620.00,'2021-12-01 14:11:11','',''),(2115368,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-01 14:11:11','',''),(2115411,'1','145','827',359,'Retail Sale Id 1257643',1449.00,0.00,0.00,0.00,283.50,'2021-12-01 14:13:31','',''),(2115412,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-01 14:13:31','',''),(2115540,'1','145','827',359,'Retail Sale Id 1257705',2760.00,0.00,0.00,0.00,540.00,'2021-12-01 14:22:35','',''),(2115541,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 14:22:35','',''),(2115557,'1','145','827',359,'Retail Sale Id 1257715',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 14:24:43','',''),(2115558,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 14:24:43','',''),(2115589,'1','145','827',359,'Retail Sale Id 1257734',6900.00,0.00,0.00,0.00,1350.00,'2021-12-01 14:26:07','',''),(2115590,'1','145','827',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 14:26:07','',''),(2115599,'1','145','827',359,'Retail Sale Id 1257744',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 14:27:07','',''),(2115600,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:27:07','',''),(2115611,'1','145','827',359,'Retail Sale Id 1257749',4830.00,0.00,0.00,0.00,945.00,'2021-12-01 14:27:46','',''),(2115612,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 14:27:46','',''),(2115646,'1','145','827',359,'Retail Sale Id 1257763',29900.00,0.00,0.00,0.00,4370.00,'2021-12-01 14:30:31','',''),(2115647,'1','145','827',359,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-01 14:30:31','',''),(2115680,'1','145','827',359,'Retail Sale Id 1257782',2208.00,0.00,0.00,0.00,432.00,'2021-12-01 14:32:41','',''),(2115681,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.20,0.00,'2021-12-01 14:32:41','',''),(2115718,'1','145','827',359,'Retail Sale Id 1257801',1380.00,0.00,0.00,0.00,270.00,'2021-12-01 14:35:22','',''),(2115719,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 14:35:22','',''),(2115730,'1','145','827',359,'Retail Sale Id 1257807',2001.00,0.00,0.00,0.00,391.50,'2021-12-01 14:36:14','',''),(2115731,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-01 14:36:14','',''),(2115746,'1','145','827',359,'Retail Sale Id 1257817',1449.00,0.00,0.00,0.00,283.50,'2021-12-01 14:37:46','',''),(2115747,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-01 14:37:46','',''),(2115801,'1','145','827',359,'Retail Sale Id 1257842',30550.00,0.00,0.00,0.00,4465.00,'2021-12-01 14:41:47','',''),(2115802,'1','145','827',359,'Retail sales',0.00,0.00,0.00,47.00,0.00,'2021-12-01 14:41:47','',''),(2115811,'1','145','827',359,'Retail Sale Id 1257847',966.00,0.00,0.00,0.00,189.00,'2021-12-01 14:43:07','',''),(2115812,'1','145','827',359,'Retail sales',0.00,0.00,0.00,1.40,0.00,'2021-12-01 14:43:07','',''),(2115819,'1','145','827',359,'Retail Sale Id 1257851',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 14:43:57','',''),(2115820,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 14:43:57','',''),(2115833,'1','145','827',359,'Retail Sale Id 1257860',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 14:45:43','',''),(2115834,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 14:45:43','',''),(2115859,'1','145','827',359,'Retail Sale Id 1257871',7800.00,0.00,0.00,0.00,1140.00,'2021-12-01 14:47:26','',''),(2115860,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-01 14:47:26','',''),(2115873,'1','145','827',359,'Retail Sale Id 1257880',2760.00,0.00,0.00,0.00,540.00,'2021-12-01 14:48:13','',''),(2115874,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 14:48:13','',''),(2115891,'1','145','827',359,'Retail Sale Id 1257888',6003.00,0.00,0.00,0.00,1174.50,'2021-12-01 14:49:20','',''),(2115892,'1','145','827',359,'Retail sales',0.00,0.00,0.00,8.70,0.00,'2021-12-01 14:49:20','',''),(2116036,'1','145','827',359,'Retail Sale Id 1257925',1449.00,0.00,0.00,0.00,283.50,'2021-12-01 14:54:05','',''),(2116037,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-01 14:54:05','',''),(2116046,'1','145','827',359,'Retail Sale Id 1257930',1380.00,0.00,0.00,0.00,270.00,'2021-12-01 14:55:18','',''),(2116047,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 14:55:18','',''),(2116080,'1','145','827',359,'Retail Sale Id 1257949',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 14:58:13','',''),(2116081,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 14:58:13','',''),(2116096,'1','145','827',359,'Retail Sale Id 1257955',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 14:59:08','',''),(2116097,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 14:59:08','',''),(2116116,'1','145','827',359,'Retail Sale Id 1257967',4830.00,0.00,0.00,0.00,945.00,'2021-12-01 15:00:45','',''),(2116117,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 15:00:45','',''),(2116164,'1','145','827',359,'Retail Sale Id 1257990',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 15:03:58','',''),(2116165,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:03:58','',''),(2116229,'1','145','827',359,'Retail Sale Id 1258027',73125.00,0.00,0.00,0.00,10687.50,'2021-12-01 15:10:46','',''),(2116230,'1','145','827',359,'Retail sales',0.00,0.00,0.00,112.50,0.00,'2021-12-01 15:10:46','',''),(2116298,'1','145','827',359,'Retail Sale Id 1258057',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 15:14:31','',''),(2116299,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:14:31','',''),(2116326,'1','145','827',359,'Retail Sale Id 1258073',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 15:16:12','',''),(2116327,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 15:16:12','',''),(2116338,'1','145','827',359,'Retail Sale Id 1258078',31200.00,0.00,0.00,0.00,4560.00,'2021-12-01 15:17:12','',''),(2116339,'1','145','827',359,'Retail sales',0.00,0.00,0.00,48.00,0.00,'2021-12-01 15:17:12','',''),(2116364,'1','145','827',359,'Retail Sale Id 1258090',2760.00,0.00,0.00,0.00,540.00,'2021-12-01 15:18:30','',''),(2116365,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 15:18:30','',''),(2116394,'1','145','827',359,'Retail Sale Id 1258105',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 15:20:27','',''),(2116395,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:20:27','',''),(2116404,'1','145','827',359,'Retail Sale Id 1258110',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 15:21:11','',''),(2116405,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 15:21:11','',''),(2116420,'1','145','827',359,'Retail Sale Id 1258117',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 15:22:06','',''),(2116421,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:22:06','',''),(2116434,'1','145','827',359,'Retail Sale Id 1258125',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 15:23:03','',''),(2116435,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:23:03','',''),(2116483,'1','145','827',359,'Retail Sale Id 1258142',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 15:25:19','',''),(2116484,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:25:19','',''),(2116495,'1','145','827',359,'Retail Sale Id 1258147',6900.00,0.00,0.00,0.00,1350.00,'2021-12-01 15:26:19','',''),(2116496,'1','145','827',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 15:26:19','',''),(2116507,'1','145','826',359,'Retail Sale Id 1258153',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 15:27:18','',''),(2116508,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 15:27:18','',''),(2116519,'1','145','827',359,'Retail Sale Id 1258159',2691.00,0.00,0.00,0.00,526.50,'2021-12-01 15:28:04','',''),(2116520,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.90,0.00,'2021-12-01 15:28:04','',''),(2116541,'1','145','827',359,'Retail Sale Id 1258171',7590.00,0.00,0.00,0.00,1485.00,'2021-12-01 15:29:04','',''),(2116542,'1','145','827',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-01 15:29:04','',''),(2116555,'1','145','827',359,'Retail Sale Id 1258178',1380.00,0.00,0.00,0.00,270.00,'2021-12-01 15:29:53','',''),(2116556,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 15:29:53','',''),(2116577,'1','145','827',359,'Retail Sale Id 1258189',8280.00,0.00,0.00,0.00,1620.00,'2021-12-01 15:31:48','',''),(2116578,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-01 15:31:48','',''),(2116589,'1','145','827',359,'Retail Sale Id 1258193',39000.00,0.00,0.00,0.00,5700.00,'2021-12-01 15:32:41','',''),(2116590,'1','145','827',359,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-01 15:32:41','',''),(2116610,'1','145','827',359,'Retail Sale Id 1258206',1380.00,0.00,0.00,0.00,270.00,'2021-12-01 15:34:07','',''),(2116611,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 15:34:07','',''),(2116660,'1','145','827',359,'Retail Sale Id 1258234',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 15:37:47','',''),(2116661,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:37:47','',''),(2116736,'1','145','827',359,'Retail Sale Id 1258267',4140.00,0.00,0.00,0.00,810.00,'2021-12-01 15:42:35','',''),(2116737,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:42:35','',''),(2116762,'1','145','827',359,'Retail Sale Id 1258279',3450.00,0.00,0.00,0.00,675.00,'2021-12-01 15:43:56','',''),(2116763,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 15:43:56','',''),(2116804,'1','145','827',359,'Retail Sale Id 1258294',1035.00,0.00,0.00,0.00,202.50,'2021-12-01 15:45:31','',''),(2116805,'1','145','827',359,'Retail sales',0.00,0.00,0.00,1.50,0.00,'2021-12-01 15:45:31','',''),(2116818,'1','145','827',359,'Retail Sale Id 1258302',2001.00,0.00,0.00,0.00,391.50,'2021-12-01 15:46:19','',''),(2116819,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-01 15:46:19','',''),(2116868,'1','145','827',359,'Retail Sale Id 1258328',4002.00,0.00,0.00,0.00,783.00,'2021-12-01 15:48:17','',''),(2116869,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-01 15:48:17','',''),(2116900,'1','145','827',359,'Retail Sale Id 1258345',4485.00,0.00,0.00,0.00,877.50,'2021-12-01 15:49:53','',''),(2116901,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-01 15:49:53','',''),(2116934,'1','145','827',359,'Retail Sale Id 1258361',2070.00,0.00,0.00,0.00,405.00,'2021-12-01 15:51:01','',''),(2116935,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:51:01','',''),(2116964,'1','145','827',359,'Retail Sale Id 1258375',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 15:52:04','',''),(2116965,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:52:04','',''),(2116986,'1','145','827',359,'Retail Sale Id 1258385',6900.00,0.00,0.00,0.00,1350.00,'2021-12-01 15:53:00','',''),(2116987,'1','145','827',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 15:53:00','',''),(2117055,'1','145','827',359,'Retail Sale Id 1258416',46150.00,0.00,0.00,0.00,6745.00,'2021-12-01 15:55:50','',''),(2117056,'1','145','827',359,'Retail sales',0.00,0.00,0.00,71.00,0.00,'2021-12-01 15:55:50','',''),(2117110,'1','145','827',359,'Retail Sale Id 1258444',1449.00,0.00,0.00,0.00,283.50,'2021-12-01 15:58:21','',''),(2117111,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-01 15:58:21','',''),(2117221,'1','145','827',359,'Retail Sale Id 1258499',14950.00,0.00,0.00,0.00,2185.00,'2021-12-01 16:03:26','',''),(2117222,'1','145','827',359,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-01 16:03:26','',''),(2117257,'1','145','827',359,'Retail Sale Id 1258515',8625.00,0.00,0.00,0.00,1687.50,'2021-12-01 16:04:56','',''),(2117258,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:04:56','',''),(2117275,'1','145','827',359,'Retail Sale Id 1258529',2760.00,0.00,0.00,0.00,540.00,'2021-12-01 16:05:45','',''),(2117276,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 16:05:45','',''),(2117428,'1','145','827',359,'Retail Sale Id 1258579',2001.00,0.00,0.00,0.00,391.50,'2021-12-01 16:11:27','',''),(2117429,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-01 16:11:27','',''),(2117533,'1','145','827',359,'Retail Sale Id 1258627',4830.00,0.00,0.00,0.00,945.00,'2021-12-01 16:15:27','',''),(2117534,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 16:15:27','',''),(2120920,'1','145','827',359,'Retail Sale Id 1260081',7590.00,0.00,0.00,0.00,1485.00,'2021-12-02 06:41:02','',''),(2120921,'1','145','827',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-02 06:41:02','',''),(2120945,'1','145','827',359,'Retail Sale Id 1260089',2001.00,0.00,0.00,0.00,391.50,'2021-12-02 06:41:54','',''),(2120946,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-02 06:41:54','',''),(2120957,'1','145','827',359,'Retail Sale Id 1260095',4830.00,0.00,0.00,0.00,945.00,'2021-12-02 06:42:47','',''),(2120958,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 06:42:47','',''),(2120977,'1','145','827',359,'Retail Sale Id 1260105',2760.00,0.00,0.00,0.00,540.00,'2021-12-02 06:44:04','',''),(2120978,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 06:44:04','',''),(2121022,'1','145','827',359,'Retail Sale Id 1260116',8280.00,0.00,0.00,0.00,1620.00,'2021-12-02 06:45:53','',''),(2121023,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 06:45:53','',''),(2121066,'1','145','827',359,'Retail Sale Id 1260136',4485.00,0.00,0.00,0.00,877.50,'2021-12-02 06:48:12','',''),(2121067,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-02 06:48:12','',''),(2121084,'1','145','827',359,'Retail Sale Id 1260147',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 06:49:14','',''),(2121085,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 06:49:14','',''),(2121098,'1','145','827',359,'Retail Sale Id 1260153',4830.00,0.00,0.00,0.00,945.00,'2021-12-02 06:49:59','',''),(2121099,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 06:49:59','',''),(2121118,'1','145','827',359,'Retail Sale Id 1260165',2760.00,0.00,0.00,0.00,540.00,'2021-12-02 06:51:13','',''),(2121119,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 06:51:13','',''),(2121150,'1','145','827',359,'Retail Sale Id 1260183',27300.00,0.00,0.00,0.00,3990.00,'2021-12-02 06:54:08','',''),(2121151,'1','145','827',359,'Retail sales',0.00,0.00,0.00,42.00,0.00,'2021-12-02 06:54:08','',''),(2121164,'1','145','827',359,'Retail Sale Id 1260189',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 06:54:44','',''),(2121165,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 06:54:44','',''),(2121176,'1','145','827',359,'Retail Sale Id 1260194',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 06:55:36','',''),(2121177,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 06:55:36','',''),(2121210,'1','145','827',359,'Retail Sale Id 1260203',1380.00,0.00,0.00,0.00,270.00,'2021-12-02 06:56:34','',''),(2121211,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 06:56:34','',''),(2121224,'1','145','827',359,'Retail Sale Id 1260205',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 06:57:23','',''),(2121225,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 06:57:23','',''),(2121238,'1','145','827',359,'Retail Sale Id 1260213',4485.00,0.00,0.00,0.00,877.50,'2021-12-02 06:58:34','',''),(2121239,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-02 06:58:34','',''),(2121254,'1','145','827',359,'Retail Sale Id 1260221',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 06:59:26','',''),(2121255,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 06:59:26','',''),(2121274,'1','145','827',359,'Retail Sale Id 1260232',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 07:00:22','',''),(2121275,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 07:00:22','',''),(2121294,'1','145','827',359,'Retail Sale Id 1260241',4830.00,0.00,0.00,0.00,945.00,'2021-12-02 07:01:52','',''),(2121295,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 07:01:52','',''),(2121308,'1','145','827',359,'Retail Sale Id 1260249',6210.00,0.00,0.00,0.00,1215.00,'2021-12-02 07:02:51','',''),(2121309,'1','145','827',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 07:02:51','',''),(2121340,'1','145','827',359,'Retail Sale Id 1260265',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 07:04:28','',''),(2121341,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 07:04:28','',''),(2121366,'1','145','827',359,'Retail Sale Id 1260279',8280.00,0.00,0.00,0.00,1620.00,'2021-12-02 07:06:02','',''),(2121367,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 07:06:02','',''),(2121398,'1','145','827',359,'Retail Sale Id 1260296',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 07:07:40','',''),(2121399,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:07:40','',''),(2121422,'1','145','827',359,'Retail Sale Id 1260311',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 07:09:04','',''),(2121423,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:09:04','',''),(2121461,'1','145','827',359,'Retail Sale Id 1260322',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 07:10:39','',''),(2121462,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:10:39','',''),(2121512,'1','145','827',359,'Retail Sale Id 1260334',1449.00,0.00,0.00,0.00,283.50,'2021-12-02 07:12:17','',''),(2121513,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-02 07:12:17','',''),(2121534,'1','145','827',359,'Retail Sale Id 1260346',1380.00,0.00,0.00,0.00,270.00,'2021-12-02 07:13:35','',''),(2121535,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 07:13:35','',''),(2121548,'1','145','827',359,'Retail Sale Id 1260352',4830.00,0.00,0.00,0.00,945.00,'2021-12-02 07:14:19','',''),(2121549,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 07:14:19','',''),(2121566,'1','145','827',359,'Retail Sale Id 1260363',2760.00,0.00,0.00,0.00,540.00,'2021-12-02 07:15:06','',''),(2121567,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 07:15:06','',''),(2121605,'1','145','827',359,'Retail Sale Id 1260383',2001.00,0.00,0.00,0.00,391.50,'2021-12-02 07:17:16','',''),(2121606,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-02 07:17:16','',''),(2121635,'1','145','827',359,'Retail Sale Id 1260400',46085.00,0.00,0.00,0.00,6735.50,'2021-12-02 07:18:37','',''),(2121636,'1','145','827',359,'Retail sales',0.00,0.00,0.00,70.90,0.00,'2021-12-02 07:18:37','',''),(2121647,'1','145','827',359,'Retail Sale Id 1260404',12935.00,0.00,0.00,0.00,1890.50,'2021-12-02 07:19:13','',''),(2121648,'1','145','827',359,'Retail sales',0.00,0.00,0.00,19.90,0.00,'2021-12-02 07:19:13','',''),(2121690,'1','145','827',359,'Retail Sale Id 1260421',8694.00,0.00,0.00,0.00,1701.00,'2021-12-02 07:21:36','',''),(2121691,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.60,0.00,'2021-12-02 07:21:36','',''),(2121723,'1','145','827',359,'Retail Sale Id 1260434',14300.00,0.00,0.00,0.00,2090.00,'2021-12-02 07:23:08','',''),(2121724,'1','145','827',359,'Retail sales',0.00,0.00,0.00,22.00,0.00,'2021-12-02 07:23:08','',''),(2121759,'1','145','827',359,'Retail Sale Id 1260458',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 07:24:58','',''),(2121760,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:24:58','',''),(2121777,'1','145','827',359,'Retail Sale Id 1260465',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 07:25:40','',''),(2121778,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:25:40','',''),(2121789,'1','145','827',359,'Retail Sale Id 1260473',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 07:26:18','',''),(2121790,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:26:18','',''),(2121807,'1','145','827',359,'Retail Sale Id 1260482',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 07:27:17','',''),(2121808,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:27:17','',''),(2121865,'1','145','827',359,'Retail Sale Id 1260515',11730.00,0.00,0.00,0.00,2295.00,'2021-12-02 07:30:11','',''),(2121866,'1','145','827',359,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-02 07:30:11','',''),(2121891,'1','145','827',359,'Retail Sale Id 1260530',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 07:31:40','',''),(2121892,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 07:31:40','',''),(2121895,'1','145','827',359,'Retail Sale Id 1260537',1449.00,0.00,0.00,0.00,283.50,'2021-12-02 07:32:18','',''),(2121896,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-02 07:32:18','',''),(2121901,'1','145','827',359,'Retail Sale Id 1260542',1449.00,0.00,0.00,0.00,283.50,'2021-12-02 07:32:53','',''),(2121902,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-02 07:32:53','',''),(2121917,'1','145','827',359,'Retail Sale Id 1260554',4002.00,0.00,0.00,0.00,783.00,'2021-12-02 07:33:50','',''),(2121918,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-02 07:33:50','',''),(2121931,'1','145','827',359,'Retail Sale Id 1260562',68900.00,0.00,0.00,0.00,10070.00,'2021-12-02 07:34:30','',''),(2121932,'1','145','827',359,'Retail sales',0.00,0.00,0.00,106.00,0.00,'2021-12-02 07:34:30','',''),(2121971,'1','145','827',359,'Retail Sale Id 1260584',2001.00,0.00,0.00,0.00,391.50,'2021-12-02 07:36:55','',''),(2121972,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-02 07:36:55','',''),(2121993,'1','145','827',359,'Retail Sale Id 1260596',8004.00,0.00,0.00,0.00,1566.00,'2021-12-02 07:37:48','',''),(2121994,'1','145','827',359,'Retail sales',0.00,0.00,0.00,11.60,0.00,'2021-12-02 07:37:48','',''),(2122023,'1','145','827',359,'Retail Sale Id 1260604',6900.00,0.00,0.00,0.00,1350.00,'2021-12-02 07:38:51','',''),(2122024,'1','145','827',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 07:38:51','',''),(2122056,'1','145','827',359,'Retail Sale Id 1260628',4968.00,0.00,0.00,0.00,972.00,'2021-12-02 07:40:21','',''),(2122057,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.20,0.00,'2021-12-02 07:40:21','',''),(2122082,'1','145','827',359,'Retail Sale Id 1260642',4968.00,0.00,0.00,0.00,972.00,'2021-12-02 07:41:23','',''),(2122083,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.20,0.00,'2021-12-02 07:41:23','',''),(2122102,'1','145','827',359,'Retail Sale Id 1260649',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 07:42:06','',''),(2122103,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:42:06','',''),(2122135,'1','145','827',359,'Retail Sale Id 1260668',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 07:43:54','',''),(2122136,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:43:54','',''),(2122153,'1','145','827',359,'Retail Sale Id 1260677',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 07:45:00','',''),(2122154,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 07:45:00','',''),(2122175,'1','145','827',359,'Retail Sale Id 1260687',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 07:45:55','',''),(2122176,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 07:45:55','',''),(2122207,'1','145','827',359,'Retail Sale Id 1260705',2760.00,0.00,0.00,0.00,540.00,'2021-12-02 07:47:35','',''),(2122208,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 07:47:35','',''),(2122241,'1','145','827',359,'Retail Sale Id 1260723',8280.00,0.00,0.00,0.00,1620.00,'2021-12-02 07:49:07','',''),(2122242,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 07:49:07','',''),(2122323,'1','145','827',359,'Retail Sale Id 1260750',1380.00,0.00,0.00,0.00,270.00,'2021-12-02 07:51:03','',''),(2122324,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 07:51:03','',''),(2122339,'1','145','827',359,'Retail Sale Id 1260760',71500.00,0.00,0.00,0.00,10450.00,'2021-12-02 07:51:50','',''),(2122340,'1','145','827',359,'Retail sales',0.00,0.00,0.00,110.00,0.00,'2021-12-02 07:51:50','',''),(2122363,'1','145','827',359,'Retail Sale Id 1260769',2001.00,0.00,0.00,0.00,391.50,'2021-12-02 07:52:40','',''),(2122364,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-02 07:52:40','',''),(2122422,'1','145','827',359,'Retail Sale Id 1260791',2691.00,0.00,0.00,0.00,526.50,'2021-12-02 07:55:17','',''),(2122423,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.90,0.00,'2021-12-02 07:55:17','',''),(2122436,'1','145','827',359,'Retail Sale Id 1260805',1380.00,0.00,0.00,0.00,270.00,'2021-12-02 07:56:00','',''),(2122437,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 07:56:00','',''),(2122458,'1','145','827',359,'Retail Sale Id 1260812',8280.00,0.00,0.00,0.00,1620.00,'2021-12-02 07:56:43','',''),(2122459,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 07:56:43','',''),(2122474,'1','145','827',359,'Retail Sale Id 1260824',1449.00,0.00,0.00,0.00,283.50,'2021-12-02 07:57:37','',''),(2122475,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-02 07:57:37','',''),(2122510,'1','145','827',359,'Retail Sale Id 1260838',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 07:58:22','',''),(2122511,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:58:22','',''),(2122530,'1','145','827',359,'Retail Sale Id 1260846',19500.00,0.00,0.00,0.00,2850.00,'2021-12-02 07:59:10','',''),(2122531,'1','145','827',359,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-02 07:59:10','',''),(2122589,'1','145','827',359,'Retail Sale Id 1260867',4830.00,0.00,0.00,0.00,945.00,'2021-12-02 08:01:08','',''),(2122591,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 08:01:08','',''),(2122607,'1','145','827',359,'Retail Sale Id 1260871',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 08:02:08','',''),(2122608,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:02:08','',''),(2122621,'1','145','827',359,'Retail Sale Id 1260882',1449.00,0.00,0.00,0.00,283.50,'2021-12-02 08:03:05','',''),(2122622,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-02 08:03:05','',''),(2122659,'1','145','827',359,'Retail Sale Id 1260900',6900.00,0.00,0.00,0.00,1350.00,'2021-12-02 08:04:41','',''),(2122660,'1','145','827',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 08:04:41','',''),(2122679,'1','145','827',359,'Retail Sale Id 1260912',6210.00,0.00,0.00,0.00,1215.00,'2021-12-02 08:05:43','',''),(2122680,'1','145','827',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 08:05:43','',''),(2122715,'1','145','827',359,'Retail Sale Id 1260929',8280.00,0.00,0.00,0.00,1620.00,'2021-12-02 08:07:20','',''),(2122716,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 08:07:20','',''),(2122725,'1','145','827',359,'Retail Sale Id 1260935',2760.00,0.00,0.00,0.00,540.00,'2021-12-02 08:07:53','',''),(2122726,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 08:07:53','',''),(2122755,'1','145','827',359,'Retail Sale Id 1260951',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 08:09:38','',''),(2122756,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:09:38','',''),(2122765,'1','145','827',359,'Retail Sale Id 1260955',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 08:10:19','',''),(2122766,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:10:19','',''),(2122789,'1','145','827',359,'Retail Sale Id 1260969',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 08:11:37','',''),(2122790,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:11:37','',''),(2122805,'1','145','827',359,'Retail Sale Id 1260977',76700.00,0.00,0.00,0.00,11210.00,'2021-12-02 08:12:43','',''),(2122806,'1','145','827',359,'Retail sales',0.00,0.00,0.00,118.00,0.00,'2021-12-02 08:12:43','',''),(2122848,'1','145','827',359,'Retail Sale Id 1261000',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 08:15:00','',''),(2122849,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:15:00','',''),(2122866,'1','145','827',359,'Retail Sale Id 1261009',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 08:16:13','',''),(2122867,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:16:13','',''),(2122886,'1','145','827',359,'Retail Sale Id 1261022',2001.00,0.00,0.00,0.00,391.50,'2021-12-02 08:17:16','',''),(2122887,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-02 08:17:16','',''),(2122900,'1','145','827',359,'Retail Sale Id 1261028',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 08:17:56','',''),(2122901,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:17:56','',''),(2122924,'1','145','827',359,'Retail Sale Id 1261040',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 08:19:15','',''),(2122925,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:19:15','',''),(2122952,'1','145','827',359,'Retail Sale Id 1261057',6900.00,0.00,0.00,0.00,1350.00,'2021-12-02 08:20:22','',''),(2122953,'1','145','827',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 08:20:22','',''),(2122982,'1','145','827',359,'Retail Sale Id 1261069',6900.00,0.00,0.00,0.00,1350.00,'2021-12-02 08:21:56','',''),(2122983,'1','145','827',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 08:21:56','',''),(2123002,'1','145','827',359,'Retail Sale Id 1261084',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 08:22:50','',''),(2123003,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:22:50','',''),(2123031,'1','145','827',359,'Retail Sale Id 1261095',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 08:23:48','',''),(2123032,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:23:48','',''),(2123057,'1','145','827',359,'Retail Sale Id 1261106',39325.00,0.00,0.00,0.00,5747.50,'2021-12-02 08:25:06','',''),(2123058,'1','145','827',359,'Retail sales',0.00,0.00,0.00,60.50,0.00,'2021-12-02 08:25:06','',''),(2123127,'1','145','827',359,'Retail Sale Id 1261138',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 08:28:44','',''),(2123128,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 08:28:44','',''),(2123155,'1','145','827',359,'Retail Sale Id 1261155',1449.00,0.00,0.00,0.00,283.50,'2021-12-02 08:30:24','',''),(2123156,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-02 08:30:24','',''),(2123167,'1','145','827',359,'Retail Sale Id 1261162',1380.00,0.00,0.00,0.00,270.00,'2021-12-02 08:31:19','',''),(2123168,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 08:31:19','',''),(2123189,'1','145','827',359,'Retail Sale Id 1261174',2760.00,0.00,0.00,0.00,540.00,'2021-12-02 08:32:41','',''),(2123190,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 08:32:41','',''),(2123385,'1','145','827',359,'Retail Sale Id 1261250',39000.00,0.00,0.00,0.00,5700.00,'2021-12-02 08:40:54','',''),(2123386,'1','145','827',359,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-02 08:40:54','',''),(2123433,'1','145','827',359,'Retail Sale Id 1261278',39000.00,0.00,0.00,0.00,5700.00,'2021-12-02 08:43:50','',''),(2123434,'1','145','827',359,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-02 08:43:50','',''),(2123519,'1','145','827',359,'Retail Sale Id 1261319',1380.00,0.00,0.00,0.00,270.00,'2021-12-02 08:49:19','',''),(2123520,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 08:49:19','',''),(2123535,'1','145','827',359,'Retail Sale Id 1261328',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 08:50:29','',''),(2123536,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:50:29','',''),(2123575,'1','145','827',359,'Retail Sale Id 1261351',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 08:52:40','',''),(2123576,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 08:52:40','',''),(2123629,'1','145','827',359,'Retail Sale Id 1261375',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 08:55:32','',''),(2123630,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 08:55:32','',''),(2123737,'1','145','827',359,'Retail Sale Id 1261428',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 09:01:02','',''),(2123738,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:01:02','',''),(2123792,'1','145','827',359,'Retail Sale Id 1261469',2001.00,0.00,0.00,0.00,391.50,'2021-12-02 09:04:06','',''),(2123793,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-02 09:04:06','',''),(2123841,'1','145','827',359,'Retail Sale Id 1261494',4830.00,0.00,0.00,0.00,945.00,'2021-12-02 09:06:22','',''),(2123842,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 09:06:22','',''),(2123857,'1','145','827',359,'Retail Sale Id 1261506',2691.00,0.00,0.00,0.00,526.50,'2021-12-02 09:07:04','',''),(2123858,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.90,0.00,'2021-12-02 09:07:04','',''),(2123875,'1','145','827',359,'Retail Sale Id 1261513',1311.00,0.00,0.00,0.00,256.50,'2021-12-02 09:07:53','',''),(2123876,'1','145','827',359,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-02 09:07:53','',''),(2123891,'1','145','827',359,'Retail Sale Id 1261523',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 09:08:31','',''),(2123892,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:08:31','',''),(2123919,'1','145','827',359,'Retail Sale Id 1261535',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 09:10:05','',''),(2123920,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:10:05','',''),(2123939,'1','145','827',359,'Retail Sale Id 1261545',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 09:11:10','',''),(2123940,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:11:10','',''),(2124003,'1','145','827',359,'Retail Sale Id 1261571',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 09:13:44','',''),(2124004,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:13:45','',''),(2124031,'1','145','827',359,'Retail Sale Id 1261582',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 09:15:02','',''),(2124032,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:15:02','',''),(2124060,'1','145','827',359,'Retail Sale Id 1261592',7590.00,0.00,0.00,0.00,1485.00,'2021-12-02 09:16:11','',''),(2124061,'1','145','827',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-02 09:16:11','',''),(2124146,'1','145','827',359,'Retail Sale Id 1261621',4002.00,0.00,0.00,0.00,783.00,'2021-12-02 09:19:32','',''),(2124147,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-02 09:19:32','',''),(2124158,'1','145','827',359,'Retail Sale Id 1261628',17250.00,0.00,0.00,0.00,3375.00,'2021-12-02 09:20:17','',''),(2124159,'1','145','827',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 09:20:17','',''),(2124206,'1','145','827',359,'Retail Sale Id 1261654',2208.00,0.00,0.00,0.00,432.00,'2021-12-02 09:23:10','',''),(2124207,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.20,0.00,'2021-12-02 09:23:10','',''),(2124266,'1','145','827',359,'Retail Sale Id 1261685',4830.00,0.00,0.00,0.00,945.00,'2021-12-02 09:26:36','',''),(2124267,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 09:26:36','',''),(2124290,'1','145','827',359,'Retail Sale Id 1261697',1380.00,0.00,0.00,0.00,270.00,'2021-12-02 09:28:12','',''),(2124291,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 09:28:12','',''),(2124320,'1','145','827',359,'Retail Sale Id 1261710',1380.00,0.00,0.00,0.00,270.00,'2021-12-02 09:29:44','',''),(2124321,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 09:29:44','',''),(2124334,'1','145','827',359,'Retail Sale Id 1261717',5520.00,0.00,0.00,0.00,1080.00,'2021-12-02 09:30:43','',''),(2124335,'1','145','827',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-02 09:30:43','',''),(2124368,'1','145','827',359,'Retail Sale Id 1261733',4830.00,0.00,0.00,0.00,945.00,'2021-12-02 09:32:31','',''),(2124369,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 09:32:31','',''),(2124451,'1','145','827',359,'Retail Sale Id 1261777',7590.00,0.00,0.00,0.00,1485.00,'2021-12-02 09:39:31','',''),(2124452,'1','145','827',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-02 09:39:31','',''),(2124641,'1','145','827',359,'Retail Sale Id 1261871',4692.00,0.00,0.00,0.00,918.00,'2021-12-02 09:49:41','',''),(2124642,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.80,0.00,'2021-12-02 09:49:41','',''),(2124661,'1','145','827',359,'Retail Sale Id 1261875',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 09:50:27','',''),(2124662,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:50:27','',''),(2124689,'1','145','827',359,'Retail Sale Id 1261902',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 09:51:52','',''),(2124690,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:51:52','',''),(2124745,'1','145','827',359,'Retail Sale Id 1261930',8694.00,0.00,0.00,0.00,1701.00,'2021-12-02 09:53:58','',''),(2124746,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.60,0.00,'2021-12-02 09:53:58','',''),(2124759,'1','145','827',359,'Retail Sale Id 1261940',19500.00,0.00,0.00,0.00,2850.00,'2021-12-02 09:54:53','',''),(2124760,'1','145','827',359,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-02 09:54:53','',''),(2124763,'1','145','827',359,'Return of Retail Sale Id 1261940',0.00,19500.00,30.00,0.00,-2850.00,'2021-12-02 09:55:19','',''),(2124797,'1','145','827',359,'Retail Sale Id 1261961',19500.00,0.00,0.00,0.00,2850.00,'2021-12-02 09:57:13','',''),(2124798,'1','145','827',359,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-02 09:57:13','',''),(2124825,'1','145','827',359,'Retail Sale Id 1261973',6900.00,0.00,0.00,0.00,1350.00,'2021-12-02 09:58:04','',''),(2124826,'1','145','827',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 09:58:04','',''),(2124849,'1','145','827',359,'Retail Sale Id 1261988',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 09:59:26','',''),(2124850,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:59:26','',''),(2124875,'1','145','827',359,'Retail Sale Id 1261999',4830.00,0.00,0.00,0.00,945.00,'2021-12-02 10:01:16','',''),(2124876,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 10:01:16','',''),(2124979,'1','145','827',359,'Retail Sale Id 1262052',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 10:07:28','',''),(2124980,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 10:07:28','',''),(2124995,'1','145','827',359,'Retail Sale Id 1262060',6900.00,0.00,0.00,0.00,1350.00,'2021-12-02 10:08:30','',''),(2124996,'1','145','827',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 10:08:30','',''),(2125067,'1','145','827',359,'Retail Sale Id 1262097',6210.00,0.00,0.00,0.00,1215.00,'2021-12-02 10:12:30','',''),(2125068,'1','145','827',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 10:12:30','',''),(2125138,'1','145','827',359,'Retail Sale Id 1262134',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 10:16:36','',''),(2125139,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 10:16:36','',''),(2125208,'1','145','827',359,'Retail Sale Id 1262169',2760.00,0.00,0.00,0.00,540.00,'2021-12-02 10:20:37','',''),(2125209,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 10:20:37','',''),(2125243,'1','145','827',359,'Retail Sale Id 1262188',9660.00,0.00,0.00,0.00,1890.00,'2021-12-02 10:22:11','',''),(2125244,'1','145','827',359,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-02 10:22:11','',''),(2125392,'1','145','827',359,'Retail Sale Id 1262257',76700.00,0.00,0.00,0.00,11210.00,'2021-12-02 10:30:39','',''),(2125393,'1','145','827',359,'Retail sales',0.00,0.00,0.00,118.00,0.00,'2021-12-02 10:30:39','',''),(2125438,'1','145','827',359,'Retail Sale Id 1262282',4830.00,0.00,0.00,0.00,945.00,'2021-12-02 10:33:53','',''),(2125439,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 10:33:53','',''),(2125498,'1','145','827',359,'Retail Sale Id 1262312',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 10:37:09','',''),(2125499,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:37:09','',''),(2125628,'1','145','827',359,'Retail Sale Id 1262372',7590.00,0.00,0.00,0.00,1485.00,'2021-12-02 10:44:57','',''),(2125629,'1','145','827',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-02 10:44:57','',''),(2125664,'1','145','827',359,'Retail Sale Id 1262394',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 10:46:53','',''),(2125665,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:46:53','',''),(2125710,'1','145','827',359,'Retail Sale Id 1262409',1380.00,0.00,0.00,0.00,270.00,'2021-12-02 10:49:50','',''),(2125711,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 10:49:50','',''),(2125732,'1','145','827',359,'Retail Sale Id 1262421',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 10:51:35','',''),(2125733,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 10:51:35','',''),(2125768,'1','145','827',359,'Retail Sale Id 1262438',1725.00,0.00,0.00,0.00,337.50,'2021-12-02 10:53:52','',''),(2125769,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-02 10:53:52','',''),(2125868,'1','145','827',359,'Retail Sale Id 1262494',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 11:01:28','',''),(2125869,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:01:28','',''),(2125928,'1','145','827',359,'Retail Sale Id 1262525',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 11:05:02','',''),(2125929,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:05:02','',''),(2126074,'1','145','827',359,'Retail Sale Id 1262603',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 11:13:51','',''),(2126075,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:13:51','',''),(2126134,'1','145','827',359,'Retail Sale Id 1262642',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 11:17:03','',''),(2126135,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 11:17:03','',''),(2126198,'1','145','827',359,'Retail Sale Id 1262677',2760.00,0.00,0.00,0.00,540.00,'2021-12-02 11:20:38','',''),(2126199,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 11:20:38','',''),(2126224,'1','145','827',359,'Retail Sale Id 1262689',23400.00,0.00,0.00,0.00,3420.00,'2021-12-02 11:21:50','',''),(2126225,'1','145','827',359,'Retail sales',0.00,0.00,0.00,36.00,0.00,'2021-12-02 11:21:50','',''),(2126248,'1','145','827',359,'Retail Sale Id 1262702',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 11:23:43','',''),(2126249,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 11:23:43','',''),(2126266,'1','145','827',359,'Retail Sale Id 1262710',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 11:25:06','',''),(2126267,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 11:25:06','',''),(2126308,'1','145','827',359,'Retail Sale Id 1262731',2001.00,0.00,0.00,0.00,391.50,'2021-12-02 11:27:36','',''),(2126309,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-02 11:27:36','',''),(2126340,'1','145','827',359,'Retail Sale Id 1262749',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 11:28:53','',''),(2126341,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:28:53','',''),(2126358,'1','145','827',359,'Retail Sale Id 1262756',1380.00,0.00,0.00,0.00,270.00,'2021-12-02 11:29:42','',''),(2126359,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 11:29:42','',''),(2126398,'1','145','827',359,'Retail Sale Id 1262771',2967.00,0.00,0.00,0.00,580.50,'2021-12-02 11:31:15','',''),(2126399,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.30,0.00,'2021-12-02 11:31:15','',''),(2126431,'1','145','827',359,'Retail Sale Id 1262782',2001.00,0.00,0.00,0.00,391.50,'2021-12-02 11:32:32','',''),(2126432,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-02 11:32:32','',''),(2126452,'1','145','827',359,'Retail Sale Id 1262789',2967.00,0.00,0.00,0.00,580.50,'2021-12-02 11:33:35','',''),(2126453,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.30,0.00,'2021-12-02 11:33:35','',''),(2126460,'1','145','827',359,'Retail Sale Id 1262794',1449.00,0.00,0.00,0.00,283.50,'2021-12-02 11:34:06','',''),(2126461,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-02 11:34:06','',''),(2126480,'1','145','827',359,'Retail Sale Id 1262803',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 11:35:10','',''),(2126481,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:35:10','',''),(2126567,'1','145','827',359,'Retail Sale Id 1262832',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 11:38:56','',''),(2126568,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:38:56','',''),(2126589,'1','145','827',359,'Retail Sale Id 1262842',8970.00,0.00,0.00,0.00,1755.00,'2021-12-02 11:39:42','',''),(2126590,'1','145','827',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-02 11:39:42','',''),(2126609,'1','145','827',359,'Retail Sale Id 1262851',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 11:41:03','',''),(2126610,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:41:03','',''),(2126645,'1','145','827',359,'Retail Sale Id 1262869',2691.00,0.00,0.00,0.00,526.50,'2021-12-02 11:43:55','',''),(2126646,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.90,0.00,'2021-12-02 11:43:55','',''),(2126657,'1','145','827',359,'Retail Sale Id 1262874',7038.00,0.00,0.00,0.00,1377.00,'2021-12-02 11:44:59','',''),(2126658,'1','145','827',359,'Retail sales',0.00,0.00,0.00,10.20,0.00,'2021-12-02 11:44:59','',''),(2126775,'1','145','827',359,'Retail Sale Id 1262938',1449.00,0.00,0.00,0.00,283.50,'2021-12-02 11:54:56','',''),(2126776,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-02 11:54:56','',''),(2126910,'1','145','827',359,'Retail Sale Id 1263007',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 12:06:00','',''),(2126911,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:06:00','',''),(2126974,'1','145','827',359,'Retail Sale Id 1263040',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 12:11:37','',''),(2126975,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 12:11:37','',''),(2126991,'1','145','827',359,'Retail Sale Id 1263048',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 12:13:40','',''),(2126992,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 12:13:40','',''),(2127009,'1','145','827',359,'Retail Sale Id 1263057',31200.00,0.00,0.00,0.00,4560.00,'2021-12-02 12:15:31','',''),(2127010,'1','145','827',359,'Retail sales',0.00,0.00,0.00,48.00,0.00,'2021-12-02 12:15:31','',''),(2127044,'1','145','827',359,'Retail Sale Id 1263073',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 12:19:19','',''),(2127045,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 12:19:19','',''),(2127052,'1','145','827',359,'Retail Sale Id 1263081',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 12:20:17','',''),(2127053,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 12:20:17','',''),(2127070,'1','145','827',359,'Retail Sale Id 1263089',1380.00,0.00,0.00,0.00,270.00,'2021-12-02 12:20:58','',''),(2127071,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 12:20:58','',''),(2127082,'1','145','827',359,'Retail Sale Id 1263096',156000.00,0.00,0.00,0.00,22800.00,'2021-12-02 12:22:04','',''),(2127083,'1','145','827',359,'Retail sales',0.00,0.00,0.00,240.00,0.00,'2021-12-02 12:22:04','',''),(2127130,'1','145','827',359,'Retail Sale Id 1263118',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 12:25:14','',''),(2127131,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 12:25:14','',''),(2127160,'1','145','827',359,'Retail Sale Id 1263136',13110.00,0.00,0.00,0.00,2565.00,'2021-12-02 12:27:03','',''),(2127161,'1','145','827',359,'Retail sales',0.00,0.00,0.00,19.00,0.00,'2021-12-02 12:27:03','',''),(2127222,'1','145','827',359,'Retail Sale Id 1263184',4830.00,0.00,0.00,0.00,945.00,'2021-12-02 12:31:47','',''),(2127223,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 12:31:47','',''),(2127234,'1','145','827',359,'Retail Sale Id 1263191',4830.00,0.00,0.00,0.00,945.00,'2021-12-02 12:32:22','',''),(2127235,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 12:32:22','',''),(2127264,'1','145','827',359,'Retail Sale Id 1263206',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 12:34:34','',''),(2127265,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:34:34','',''),(2127308,'1','145','827',359,'Retail Sale Id 1263230',1449.00,0.00,0.00,0.00,283.50,'2021-12-02 12:38:19','',''),(2127309,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-02 12:38:19','',''),(2127363,'1','145','827',359,'Retail Sale Id 1263254',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 12:42:54','',''),(2127364,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:42:54','',''),(2127465,'1','145','827',359,'Retail Sale Id 1263297',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 12:49:53','',''),(2127466,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 12:49:53','',''),(2127624,'1','145','827',359,'Retail Sale Id 1263377',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 13:01:45','',''),(2127625,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 13:01:45','',''),(2127660,'1','145','827',359,'Retail Sale Id 1263394',2898.00,0.00,0.00,0.00,567.00,'2021-12-02 13:04:19','',''),(2127661,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-02 13:04:19','',''),(2127688,'1','145','827',359,'Retail Sale Id 1263408',2760.00,0.00,0.00,0.00,540.00,'2021-12-02 13:06:57','',''),(2127689,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 13:06:57','',''),(2127752,'1','145','827',359,'Retail Sale Id 1263440',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 13:11:38','',''),(2127753,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:11:38','',''),(2127827,'1','145','827',359,'Retail Sale Id 1263471',17250.00,0.00,0.00,0.00,3375.00,'2021-12-02 13:15:40','',''),(2127828,'1','145','827',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 13:15:40','',''),(2127875,'1','145','827',359,'Retail Sale Id 1263485',6900.00,0.00,0.00,0.00,1350.00,'2021-12-02 13:17:47','',''),(2127876,'1','145','827',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 13:17:47','',''),(2127887,'1','145','827',359,'Retail Sale Id 1263492',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 13:18:49','',''),(2127888,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 13:18:49','',''),(2127947,'1','145','827',359,'Retail Sale Id 1263522',6900.00,0.00,0.00,0.00,1350.00,'2021-12-02 13:24:03','',''),(2127948,'1','145','827',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 13:24:03','',''),(2128081,'1','145','827',359,'Retail Sale Id 1263573',39130.00,0.00,0.00,0.00,5719.00,'2021-12-02 13:32:45','',''),(2128082,'1','145','827',359,'Retail sales',0.00,0.00,0.00,60.20,0.00,'2021-12-02 13:32:45','',''),(2128093,'1','145','827',359,'Retail Sale Id 1263580',8970.00,0.00,0.00,0.00,1755.00,'2021-12-02 13:34:14','',''),(2128094,'1','145','827',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-02 13:34:14','',''),(2128117,'1','145','827',359,'Retail Sale Id 1263589',4830.00,0.00,0.00,0.00,945.00,'2021-12-02 13:35:56','',''),(2128118,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 13:35:56','',''),(2128276,'1','145','827',359,'Retail Sale Id 1263653',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 13:45:35','',''),(2128277,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 13:45:35','',''),(2128389,'1','145','827',359,'Retail Sale Id 1263709',2898.00,0.00,0.00,0.00,567.00,'2021-12-02 13:51:57','',''),(2128390,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-02 13:51:57','',''),(2128423,'1','145','827',359,'Retail Sale Id 1263727',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 13:54:03','',''),(2128424,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:54:03','',''),(2128450,'1','145','827',359,'Retail Sale Id 1263737',6900.00,0.00,0.00,0.00,1350.00,'2021-12-02 13:55:15','',''),(2128451,'1','145','827',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 13:55:15','',''),(2128495,'1','145','827',359,'Retail Sale Id 1263753',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 13:56:46','',''),(2128496,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 13:56:46','',''),(2128533,'1','145','827',359,'Retail Sale Id 1263770',8280.00,0.00,0.00,0.00,1620.00,'2021-12-02 13:59:02','',''),(2128534,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 13:59:02','',''),(2128554,'1','145','827',359,'Retail Sale Id 1263777',2898.00,0.00,0.00,0.00,567.00,'2021-12-02 14:00:24','',''),(2128555,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-02 14:00:24','',''),(2128566,'1','145','827',359,'Retail Sale Id 1263782',16250.00,0.00,0.00,0.00,2375.00,'2021-12-02 14:01:26','',''),(2128567,'1','145','827',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 14:01:26','',''),(2128618,'1','145','827',359,'Retail Sale Id 1263808',4485.00,0.00,0.00,0.00,877.50,'2021-12-02 14:04:43','',''),(2128619,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-02 14:04:43','',''),(2128644,'1','145','827',359,'Retail Sale Id 1263821',1380.00,0.00,0.00,0.00,270.00,'2021-12-02 14:06:39','',''),(2128645,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 14:06:39','',''),(2128680,'1','145','827',359,'Retail Sale Id 1263838',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 14:08:46','',''),(2128681,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:08:46','',''),(2128700,'1','145','827',359,'Retail Sale Id 1263852',54990.00,0.00,0.00,0.00,8037.00,'2021-12-02 14:10:22','',''),(2128701,'1','145','827',359,'Retail sales',0.00,0.00,0.00,84.60,0.00,'2021-12-02 14:10:22','',''),(2128736,'1','145','827',359,'Retail Sale Id 1263862',6210.00,0.00,0.00,0.00,1215.00,'2021-12-02 14:11:56','',''),(2128737,'1','145','827',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 14:11:56','',''),(2128760,'1','145','827',359,'Retail Sale Id 1263868',5175.00,0.00,0.00,0.00,1012.50,'2021-12-02 14:12:55','',''),(2128761,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.50,0.00,'2021-12-02 14:12:55','',''),(2128778,'1','145','827',359,'Retail Sale Id 1263876',4830.00,0.00,0.00,0.00,945.00,'2021-12-02 14:14:23','',''),(2128779,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 14:14:23','',''),(2128796,'1','145','827',359,'Retail Sale Id 1263885',6900.00,0.00,0.00,0.00,1350.00,'2021-12-02 14:15:52','',''),(2128797,'1','145','827',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 14:15:52','',''),(2128816,'1','145','827',359,'Retail Sale Id 1263896',2001.00,0.00,0.00,0.00,391.50,'2021-12-02 14:16:55','',''),(2128817,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-02 14:16:55','',''),(2128834,'1','145','827',359,'Retail Sale Id 1263907',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 14:17:38','',''),(2128835,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 14:17:38','',''),(2128862,'1','145','827',359,'Retail Sale Id 1263921',2001.00,0.00,0.00,0.00,391.50,'2021-12-02 14:18:55','',''),(2128863,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-02 14:18:55','',''),(2128887,'1','145','827',359,'Retail Sale Id 1263932',2001.00,0.00,0.00,0.00,391.50,'2021-12-02 14:20:11','',''),(2128888,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-02 14:20:11','',''),(2128912,'1','145','827',359,'Retail Sale Id 1263947',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 14:21:39','',''),(2128913,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:21:39','',''),(2129019,'1','145','827',359,'Retail Sale Id 1263983',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 14:25:45','',''),(2129020,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 14:25:45','',''),(2129079,'1','145','827',359,'Retail Sale Id 1263996',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 14:27:10','',''),(2129080,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:27:10','',''),(2129110,'1','145','827',359,'Retail Sale Id 1264008',22750.00,0.00,0.00,0.00,3325.00,'2021-12-02 14:28:21','',''),(2129111,'1','145','827',359,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-02 14:28:21','',''),(2129168,'1','145','827',359,'Retail Sale Id 1264037',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 14:31:21','',''),(2129169,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:31:21','',''),(2129200,'1','145','827',359,'Retail Sale Id 1264042',2001.00,0.00,0.00,0.00,391.50,'2021-12-02 14:32:13','',''),(2129201,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-02 14:32:13','',''),(2129206,'1','145','827',359,'Retail Sale Id 1264045',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 14:32:52','',''),(2129207,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:32:52','',''),(2129232,'1','145','827',359,'Retail Sale Id 1264056',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 14:34:26','',''),(2129233,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 14:34:26','',''),(2129250,'1','145','827',359,'Retail Sale Id 1264065',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 14:35:04','',''),(2129251,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 14:35:04','',''),(2129268,'1','145','827',359,'Retail Sale Id 1264075',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 14:36:41','',''),(2129269,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:36:41','',''),(2129288,'1','145','827',359,'Retail Sale Id 1264081',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 14:37:26','',''),(2129289,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:37:26','',''),(2129315,'1','145','827',359,'Retail Sale Id 1264090',6900.00,0.00,0.00,0.00,1350.00,'2021-12-02 14:38:21','',''),(2129316,'1','145','827',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 14:38:21','',''),(2129337,'1','145','827',359,'Retail Sale Id 1264100',39000.00,0.00,0.00,0.00,5700.00,'2021-12-02 14:39:13','',''),(2129338,'1','145','827',359,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-02 14:39:13','',''),(2129419,'1','145','827',359,'Retail Sale Id 1264130',1380.00,0.00,0.00,0.00,270.00,'2021-12-02 14:42:12','',''),(2129420,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 14:42:12','',''),(2129475,'1','145','827',359,'Retail Sale Id 1264159',4002.00,0.00,0.00,0.00,783.00,'2021-12-02 14:46:00','',''),(2129476,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-02 14:46:00','',''),(2129499,'1','145','827',359,'Retail Sale Id 1264171',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 14:47:37','',''),(2129500,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:47:37','',''),(2129525,'1','145','827',359,'Retail Sale Id 1264187',2898.00,0.00,0.00,0.00,567.00,'2021-12-02 14:48:43','',''),(2129526,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-02 14:48:43','',''),(2129545,'1','145','827',359,'Retail Sale Id 1264195',7590.00,0.00,0.00,0.00,1485.00,'2021-12-02 14:49:27','',''),(2129546,'1','145','827',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-02 14:49:27','',''),(2129600,'1','145','827',359,'Retail Sale Id 1264225',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 14:53:27','',''),(2129601,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:53:27','',''),(2129626,'1','145','827',359,'Retail Sale Id 1264238',2760.00,0.00,0.00,0.00,540.00,'2021-12-02 14:54:57','',''),(2129627,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 14:54:57','',''),(2129651,'1','145','827',359,'Retail Sale Id 1264252',2001.00,0.00,0.00,0.00,391.50,'2021-12-02 14:56:22','',''),(2129652,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-02 14:56:22','',''),(2129677,'1','145','827',359,'Retail Sale Id 1264267',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 14:57:07','',''),(2129678,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:57:07','',''),(2129689,'1','145','827',359,'Retail Sale Id 1264273',2760.00,0.00,0.00,0.00,540.00,'2021-12-02 14:57:53','',''),(2129690,'1','145','827',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 14:57:53','',''),(2129727,'1','145','827',359,'Retail Sale Id 1264290',4140.00,0.00,0.00,0.00,810.00,'2021-12-02 14:59:41','',''),(2129728,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:59:41','',''),(2129749,'1','145','827',359,'Retail Sale Id 1264302',1449.00,0.00,0.00,0.00,283.50,'2021-12-02 15:02:51','',''),(2129750,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-02 15:02:51','',''),(2129779,'1','145','827',359,'Retail Sale Id 1264317',4830.00,0.00,0.00,0.00,945.00,'2021-12-02 15:05:18','',''),(2129780,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 15:05:18','',''),(2129797,'1','145','827',359,'Retail Sale Id 1264327',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 15:06:31','',''),(2129798,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:06:31','',''),(2129821,'1','145','827',359,'Retail Sale Id 1264338',1449.00,0.00,0.00,0.00,283.50,'2021-12-02 15:08:16','',''),(2129822,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-02 15:08:16','',''),(2129839,'1','145','827',359,'Retail Sale Id 1264347',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 15:09:33','',''),(2129840,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:09:33','',''),(2129851,'1','145','827',359,'Retail Sale Id 1264355',6210.00,0.00,0.00,0.00,1215.00,'2021-12-02 15:10:11','',''),(2129852,'1','145','827',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 15:10:11','',''),(2129944,'1','145','827',359,'Retail Sale Id 1264402',2484.00,0.00,0.00,0.00,486.00,'2021-12-02 15:15:17','',''),(2129945,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.60,0.00,'2021-12-02 15:15:17','',''),(2129968,'1','145','827',359,'Retail Sale Id 1264412',4830.00,0.00,0.00,0.00,945.00,'2021-12-02 15:16:06','',''),(2129969,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 15:16:06','',''),(2130038,'1','145','827',359,'Retail Sale Id 1264450',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 15:20:22','',''),(2130039,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:20:22','',''),(2130128,'1','145','827',359,'Retail Sale Id 1264491',1794.00,0.00,0.00,0.00,351.00,'2021-12-02 15:24:48','',''),(2130129,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.60,0.00,'2021-12-02 15:24:48','',''),(2130162,'1','145','827',359,'Retail Sale Id 1264504',6210.00,0.00,0.00,0.00,1215.00,'2021-12-02 15:26:06','',''),(2130163,'1','145','827',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 15:26:06','',''),(2130257,'1','145','827',359,'Retail Sale Id 1264552',2001.00,0.00,0.00,0.00,391.50,'2021-12-02 15:29:54','',''),(2130258,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-02 15:29:54','',''),(2130354,'1','145','827',359,'Retail Sale Id 1264599',2001.00,0.00,0.00,0.00,391.50,'2021-12-02 15:34:30','',''),(2130355,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-02 15:34:30','',''),(2130402,'1','145','827',359,'Retail Sale Id 1264620',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 15:36:35','',''),(2130403,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:36:35','',''),(2130436,'1','145','827',359,'Retail Sale Id 1264637',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 15:38:35','',''),(2130437,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:38:35','',''),(2130468,'1','145','827',359,'Retail Sale Id 1264654',2070.00,0.00,0.00,0.00,405.00,'2021-12-02 15:39:59','',''),(2130469,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:39:59','',''),(2130530,'1','145','827',359,'Retail Sale Id 1264687',8280.00,0.00,0.00,0.00,1620.00,'2021-12-02 15:42:49','',''),(2130531,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 15:42:50','',''),(2130586,'1','145','827',359,'Retail Sale Id 1264723',7590.00,0.00,0.00,0.00,1485.00,'2021-12-02 15:45:09','',''),(2130587,'1','145','827',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-02 15:45:09','',''),(2130684,'1','145','827',359,'Retail Sale Id 1264778',8280.00,0.00,0.00,0.00,1620.00,'2021-12-02 15:50:04','',''),(2130685,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 15:50:04','',''),(2130738,'1','145','827',359,'Retail Sale Id 1264808',4899.00,0.00,0.00,0.00,958.50,'2021-12-02 15:52:15','',''),(2130739,'1','145','827',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-02 15:52:15','',''),(2130766,'1','145','827',359,'Retail Sale Id 1264821',2001.00,0.00,0.00,0.00,391.50,'2021-12-02 15:53:20','',''),(2130767,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-02 15:53:20','',''),(2130790,'1','145','827',359,'Retail Sale Id 1264833',8280.00,0.00,0.00,0.00,1620.00,'2021-12-02 15:54:17','',''),(2130791,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 15:54:17','',''),(2130904,'1','145','827',359,'Retail Sale Id 1264893',8280.00,0.00,0.00,0.00,1620.00,'2021-12-02 15:59:24','',''),(2130905,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 15:59:24','',''),(2130924,'1','145','827',359,'Retail Sale Id 1264902',3450.00,0.00,0.00,0.00,675.00,'2021-12-02 16:00:13','',''),(2130925,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:00:13','',''),(2130970,'1','145','827',359,'Retail Sale Id 1264923',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 16:01:53','',''),(2130971,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:01:53','',''),(2131128,'1','145','827',359,'Retail Sale Id 1264989',8625.00,0.00,0.00,0.00,1687.50,'2021-12-02 16:08:38','',''),(2131129,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:08:38','',''),(2131154,'1','145','827',359,'Retail Sale Id 1265002',2001.00,0.00,0.00,0.00,391.50,'2021-12-02 16:09:23','',''),(2131155,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-02 16:09:23','',''),(2131236,'1','145','827',359,'Retail Sale Id 1265047',10350.00,0.00,0.00,0.00,2025.00,'2021-12-02 16:13:53','',''),(2131237,'1','145','827',359,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-02 16:13:53','',''),(2132026,'1','145',NULL,359,'Purchased from AA RANO NIGERIA LIMITED',0.00,14193000.00,24900.00,0.00,0.00,'2021-12-02 16:51:18','',''),(2132101,'1','145',NULL,359,'Reception corrector for bridging 125958',0.00,0.00,0.00,15000.00,0.00,'2021-12-02 16:55:52','',''),(2132102,'1','145','826',359,'Received from bridging 125958',0.00,0.00,15000.00,0.00,0.00,'2021-12-02 16:55:52','',''),(2134340,'1','145','827',359,'Retail Sale Id 1266257',2001.00,0.00,0.00,0.00,348.00,'2021-12-03 06:38:53','',''),(2134341,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-03 06:38:53','',''),(2134358,'1','145','827',359,'Retail Sale Id 1266269',17250.00,0.00,0.00,0.00,3000.00,'2021-12-03 06:39:51','',''),(2134359,'1','145','827',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 06:39:51','',''),(2134379,'1','145','827',359,'Retail Sale Id 1266277',2001.00,0.00,0.00,0.00,348.00,'2021-12-03 06:41:34','',''),(2134380,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-03 06:41:34','',''),(2134392,'1','145','827',359,'Retail Sale Id 1266284',4140.00,0.00,0.00,0.00,720.00,'2021-12-03 06:42:22','',''),(2134393,'1','145','827',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 06:42:22','',''),(2134417,'1','145','827',359,'Retail Sale Id 1266298',8625.00,0.00,0.00,0.00,1500.00,'2021-12-03 06:43:30','',''),(2134418,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:43:30','',''),(2134449,'1','145','827',359,'Retail Sale Id 1266314',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 06:44:57','',''),(2134450,'1','145','827',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 06:44:57','',''),(2134462,'1','145','827',359,'Retail Sale Id 1266321',2001.00,0.00,0.00,0.00,348.00,'2021-12-03 06:45:44','',''),(2134463,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-03 06:45:44','',''),(2134478,'1','145','827',359,'Retail Sale Id 1266332',5520.00,0.00,0.00,0.00,960.00,'2021-12-03 06:46:40','',''),(2134479,'1','145','827',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 06:46:40','',''),(2134499,'1','145','827',359,'Retail Sale Id 1266338',8625.00,0.00,0.00,0.00,1500.00,'2021-12-03 06:47:17','',''),(2134500,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:47:17','',''),(2134511,'1','145','827',359,'Retail Sale Id 1266343',8625.00,0.00,0.00,0.00,1500.00,'2021-12-03 06:48:10','',''),(2134512,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:48:10','',''),(2134555,'1','145','827',359,'Retail Sale Id 1266363',1449.00,0.00,0.00,0.00,252.00,'2021-12-03 06:50:43','',''),(2134556,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-03 06:50:43','',''),(2134591,'1','145','827',359,'Retail Sale Id 1266382',8970.00,0.00,0.00,0.00,1560.00,'2021-12-03 06:52:41','',''),(2134592,'1','145','827',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-03 06:52:41','',''),(2134617,'1','145','827',359,'Retail Sale Id 1266394',2001.00,0.00,0.00,0.00,348.00,'2021-12-03 06:53:50','',''),(2134618,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-03 06:53:50','',''),(2134633,'1','145','827',359,'Retail Sale Id 1266401',8125.00,0.00,0.00,0.00,1000.00,'2021-12-03 06:54:49','',''),(2134634,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:54:49','',''),(2134657,'1','145','827',359,'Retail Sale Id 1266417',3450.00,0.00,0.00,0.00,600.00,'2021-12-03 06:55:46','',''),(2134658,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 06:55:46','',''),(2134669,'1','145','827',359,'Retail Sale Id 1266424',8625.00,0.00,0.00,0.00,1500.00,'2021-12-03 06:56:43','',''),(2134670,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:56:43','',''),(2134694,'1','145','827',359,'Retail Sale Id 1266433',8625.00,0.00,0.00,0.00,1500.00,'2021-12-03 06:58:04','',''),(2134695,'1','145','827',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:58:04','',''),(2134747,'1','145','827',359,'Retail Sale Id 1266459',6900.00,0.00,0.00,0.00,1200.00,'2021-12-03 07:01:11','',''),(2134748,'1','145','827',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 07:01:11','',''),(2134769,'1','145','827',359,'Retail Sale Id 1266469',1449.00,0.00,0.00,0.00,252.00,'2021-12-03 07:02:11','',''),(2134770,'1','145','827',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-03 07:02:11','',''),(2134781,'1','145','827',359,'Retail Sale Id 1266477',3450.00,0.00,0.00,0.00,600.00,'2021-12-03 07:03:07','',''),(2134782,'1','145','827',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:03:07','',''),(2139066,'1','145','827',359,'Return of Retail Sale Id 1266477',0.00,3450.00,5.00,0.00,-600.00,'2021-12-03 11:01:57','',''),(2139075,'1','145','827',359,'Return of Retail Sale Id 1266469',0.00,1449.00,2.10,0.00,-252.00,'2021-12-03 11:02:26','',''),(2139082,'1','145','827',359,'Return of Retail Sale Id 1266459',0.00,6900.00,10.00,0.00,-1200.00,'2021-12-03 11:02:49','',''),(2139117,'1','145','827',359,'Retail Sale Id 1268570',365300.00,0.00,0.00,0.00,44960.00,'2021-12-03 11:05:17','',''),(2139118,'1','145','827',359,'Retail sales',0.00,0.00,0.00,562.00,0.00,'2021-12-03 11:05:17','',''),(2139151,'1','145','826',359,'Retail Sale Id 1268593',11799.00,0.00,0.00,0.00,2052.00,'2021-12-03 11:08:19','',''),(2139152,'1','145','826',359,'Retail sales',0.00,0.00,0.00,17.10,0.00,'2021-12-03 11:08:19','',''),(2139193,'1','145','826',359,'Retail Sale Id 1268616',8694.00,0.00,0.00,0.00,1512.00,'2021-12-03 11:11:32','',''),(2139194,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.60,0.00,'2021-12-03 11:11:32','',''),(2139211,'1','145','826',359,'Retail Sale Id 1268624',2001.00,0.00,0.00,0.00,348.00,'2021-12-03 11:13:20','',''),(2139212,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-03 11:13:20','',''),(2139251,'1','145','826',359,'Retail Sale Id 1268646',2760.00,0.00,0.00,0.00,480.00,'2021-12-03 11:15:18','',''),(2139252,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 11:15:18','',''),(2139269,'1','145','826',359,'Retail Sale Id 1268654',33800.00,0.00,0.00,0.00,4160.00,'2021-12-03 11:16:09','',''),(2139270,'1','145','826',359,'Retail sales',0.00,0.00,0.00,52.00,0.00,'2021-12-03 11:16:09','',''),(2139380,'1','145','826',359,'Retail Sale Id 1268709',2760.00,0.00,0.00,0.00,480.00,'2021-12-03 11:25:22','',''),(2139381,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 11:25:22','',''),(2139401,'1','145','826',359,'Retail Sale Id 1268721',3450.00,0.00,0.00,0.00,600.00,'2021-12-03 11:27:05','',''),(2139402,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 11:27:05','',''),(2139419,'1','145','826',359,'Retail Sale Id 1268732',4830.00,0.00,0.00,0.00,840.00,'2021-12-03 11:28:28','',''),(2139420,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-03 11:28:28','',''),(2139494,'1','145','826',359,'Retail Sale Id 1268771',76440.00,0.00,0.00,0.00,9408.00,'2021-12-03 11:34:10','',''),(2139495,'1','145','826',359,'Retail sales',0.00,0.00,0.00,117.60,0.00,'2021-12-03 11:34:10','',''),(2139612,'1','145','826',359,'Retail Sale Id 1268842',2760.00,0.00,0.00,0.00,480.00,'2021-12-03 11:44:21','',''),(2139613,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 11:44:21','',''),(2139668,'1','145','826',359,'Retail Sale Id 1268871',8625.00,0.00,0.00,0.00,1500.00,'2021-12-03 11:48:16','',''),(2139669,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:48:16','',''),(2139690,'1','145','826',359,'Retail Sale Id 1268891',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 11:49:29','',''),(2139691,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 11:49:29','',''),(2139755,'1','145','826',359,'Retail Sale Id 1268921',3450.00,0.00,0.00,0.00,600.00,'2021-12-03 11:54:57','',''),(2139756,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 11:54:57','',''),(2139787,'1','145','826',359,'Retail Sale Id 1268938',4140.00,0.00,0.00,0.00,720.00,'2021-12-03 11:56:52','',''),(2139788,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 11:56:52','',''),(2139815,'1','145','826',359,'Retail Sale Id 1268951',6900.00,0.00,0.00,0.00,1200.00,'2021-12-03 11:59:34','',''),(2139816,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 11:59:34','',''),(2139875,'1','145','826',359,'Retail Sale Id 1268988',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 12:03:28','',''),(2139876,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 12:03:28','',''),(2139907,'1','145','826',359,'Retail Sale Id 1269005',3450.00,0.00,0.00,0.00,600.00,'2021-12-03 12:05:02','',''),(2139908,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 12:05:02','',''),(2139927,'1','145','826',359,'Retail Sale Id 1269030',8625.00,0.00,0.00,0.00,1500.00,'2021-12-03 12:06:29','',''),(2139928,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:06:29','',''),(2139964,'1','145','826',359,'Retail Sale Id 1269050',8625.00,0.00,0.00,0.00,1500.00,'2021-12-03 12:08:40','',''),(2139965,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:08:40','',''),(2139998,'1','145','826',359,'Retail Sale Id 1269068',8280.00,0.00,0.00,0.00,1440.00,'2021-12-03 12:10:30','',''),(2139999,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-03 12:10:30','',''),(2140006,'1','145','826',359,'Retail Sale Id 1269071',32500.00,0.00,0.00,0.00,4000.00,'2021-12-03 12:11:54','',''),(2140007,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 12:11:54','',''),(2140088,'1','145','826',359,'Retail Sale Id 1269116',2001.00,0.00,0.00,0.00,348.00,'2021-12-03 12:21:17','',''),(2140089,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-03 12:21:17','',''),(2140094,'1','145','826',359,'Retail Sale Id 1269120',3450.00,0.00,0.00,0.00,600.00,'2021-12-03 12:22:17','',''),(2140095,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 12:22:17','',''),(2140151,'1','145','826',359,'Retail Sale Id 1269145',4830.00,0.00,0.00,0.00,840.00,'2021-12-03 12:26:26','',''),(2140152,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-03 12:26:26','',''),(2140160,'1','145','826',359,'Retail Sale Id 1269149',3450.00,0.00,0.00,0.00,600.00,'2021-12-03 12:27:23','',''),(2140161,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 12:27:23','',''),(2140901,'1','145','826',359,'Retail Sale Id 1269510',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 13:24:48','',''),(2140902,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 13:24:48','',''),(2140913,'1','145','826',359,'Retail Sale Id 1269517',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 13:25:37','',''),(2140914,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 13:25:37','',''),(2140923,'1','145','826',359,'Retail Sale Id 1269521',3450.00,0.00,0.00,0.00,600.00,'2021-12-03 13:26:21','',''),(2140924,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 13:26:21','',''),(2140946,'1','145','826',359,'Retail Sale Id 1269532',1380.00,0.00,0.00,0.00,240.00,'2021-12-03 13:27:58','',''),(2140947,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 13:27:58','',''),(2140960,'1','145','826',359,'Retail Sale Id 1269539',4140.00,0.00,0.00,0.00,720.00,'2021-12-03 13:29:05','',''),(2140961,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 13:29:05','',''),(2140978,'1','145','826',359,'Retail Sale Id 1269549',8625.00,0.00,0.00,0.00,1500.00,'2021-12-03 13:29:46','',''),(2140979,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:29:46','',''),(2140986,'1','145','826',359,'Retail Sale Id 1269553',1449.00,0.00,0.00,0.00,252.00,'2021-12-03 13:30:48','',''),(2140987,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-03 13:30:48','',''),(2141001,'1','145','826',359,'Retail Sale Id 1269563',8625.00,0.00,0.00,0.00,1500.00,'2021-12-03 13:32:00','',''),(2141002,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:32:00','',''),(2141031,'1','145','826',359,'Retail Sale Id 1269577',4830.00,0.00,0.00,0.00,840.00,'2021-12-03 13:33:47','',''),(2141032,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-03 13:33:47','',''),(2141049,'1','145','826',359,'Retail Sale Id 1269585',3450.00,0.00,0.00,0.00,600.00,'2021-12-03 13:34:41','',''),(2141050,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 13:34:41','',''),(2141098,'1','145','826',359,'Retail Sale Id 1269613',2898.00,0.00,0.00,0.00,504.00,'2021-12-03 13:38:20','',''),(2141099,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-03 13:38:20','',''),(2141118,'1','145','826',359,'Retail Sale Id 1269622',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 13:39:06','',''),(2141119,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 13:39:06','',''),(2141148,'1','145','826',359,'Retail Sale Id 1269639',12155.00,0.00,0.00,0.00,1496.00,'2021-12-03 13:41:01','',''),(2141149,'1','145','826',359,'Retail sales',0.00,0.00,0.00,18.70,0.00,'2021-12-03 13:41:01','',''),(2141174,'1','145','826',359,'Retail Sale Id 1269612',2760.00,0.00,0.00,0.00,480.00,'2021-12-03 13:42:26','',''),(2141175,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 13:42:26','',''),(2141252,'1','145','826',359,'Retail Sale Id 1269678',2346.00,0.00,0.00,0.00,408.00,'2021-12-03 13:45:44','',''),(2141253,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.40,0.00,'2021-12-03 13:45:44','',''),(2141290,'1','145','826',359,'Retail Sale Id 1269694',2001.00,0.00,0.00,0.00,348.00,'2021-12-03 13:47:16','',''),(2141291,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-03 13:47:16','',''),(2141425,'1','145','826',359,'Retail Sale Id 1269728',8280.00,0.00,0.00,0.00,1440.00,'2021-12-03 13:51:23','',''),(2141426,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-03 13:51:23','',''),(2141469,'1','145','826',359,'Retail Sale Id 1269743',4002.00,0.00,0.00,0.00,696.00,'2021-12-03 13:53:20','',''),(2141470,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-03 13:53:20','',''),(2141493,'1','145','826',359,'Retail Sale Id 1269757',1380.00,0.00,0.00,0.00,240.00,'2021-12-03 13:54:53','',''),(2141494,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 13:54:53','',''),(2141590,'1','145','826',359,'Retail Sale Id 1269804',8280.00,0.00,0.00,0.00,1440.00,'2021-12-03 14:02:27','',''),(2141591,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-03 14:02:27','',''),(2141620,'1','145','826',359,'Retail Sale Id 1269815',13650.00,0.00,0.00,0.00,1680.00,'2021-12-03 14:04:00','',''),(2141621,'1','145','826',359,'Retail sales',0.00,0.00,0.00,21.00,0.00,'2021-12-03 14:04:00','',''),(2141713,'1','145','826',359,'Retail Sale Id 1269847',4830.00,0.00,0.00,0.00,840.00,'2021-12-03 14:08:18','',''),(2141714,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-03 14:08:18','',''),(2141721,'1','145','826',359,'Retail Sale Id 1269853',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 14:09:08','',''),(2141723,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:09:08','',''),(2141796,'1','145','826',359,'Retail Sale Id 1269885',8625.00,0.00,0.00,0.00,1500.00,'2021-12-03 14:14:26','',''),(2141797,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:14:26','',''),(2141848,'1','145','826',359,'Retail Sale Id 1269911',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 14:18:20','',''),(2141849,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:18:20','',''),(2141892,'1','145','826',359,'Retail Sale Id 1269923',4140.00,0.00,0.00,0.00,720.00,'2021-12-03 14:20:22','',''),(2141893,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 14:20:22','',''),(2141920,'1','145','826',359,'Retail Sale Id 1269932',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 14:21:50','',''),(2141921,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:21:50','',''),(2141955,'1','145','826',359,'Retail Sale Id 1269943',4140.00,0.00,0.00,0.00,720.00,'2021-12-03 14:23:42','',''),(2141956,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 14:23:42','',''),(2141975,'1','145','826',359,'Retail Sale Id 1269920',2760.00,0.00,0.00,0.00,480.00,'2021-12-03 14:24:34','',''),(2141976,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 14:24:34','',''),(2142012,'1','145','826',359,'Retail Sale Id 1269965',6900.00,0.00,0.00,0.00,1200.00,'2021-12-03 14:26:34','',''),(2142013,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 14:26:34','',''),(2142036,'1','145','826',359,'Retail Sale Id 1269978',2760.00,0.00,0.00,0.00,480.00,'2021-12-03 14:28:21','',''),(2142037,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 14:28:21','',''),(2142058,'1','145','826',359,'Retail Sale Id 1269990',2001.00,0.00,0.00,0.00,348.00,'2021-12-03 14:29:45','',''),(2142059,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-03 14:29:45','',''),(2142079,'1','145','826',359,'Retail Sale Id 1269999',8280.00,0.00,0.00,0.00,1440.00,'2021-12-03 14:31:00','',''),(2142080,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-03 14:31:00','',''),(2142087,'1','145','826',359,'Retail Sale Id 1270003',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 14:31:44','',''),(2142088,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:31:44','',''),(2142091,'1','145','826',359,'Retail Sale Id 1270004',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 14:32:30','',''),(2142092,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:32:30','',''),(2142107,'1','145','826',359,'Retail Sale Id 1270012',3450.00,0.00,0.00,0.00,600.00,'2021-12-03 14:33:24','',''),(2142108,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 14:33:24','',''),(2142146,'1','145','826',359,'Retail Sale Id 1270023',10005.00,0.00,0.00,0.00,1740.00,'2021-12-03 14:34:42','',''),(2142147,'1','145','826',359,'Retail sales',0.00,0.00,0.00,14.50,0.00,'2021-12-03 14:34:42','',''),(2142170,'1','145','826',359,'Retail Sale Id 1270030',8625.00,0.00,0.00,0.00,1500.00,'2021-12-03 14:35:44','',''),(2142171,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:35:44','',''),(2142204,'1','145','826',359,'Retail Sale Id 1270036',1449.00,0.00,0.00,0.00,252.00,'2021-12-03 14:37:33','',''),(2142205,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-03 14:37:33','',''),(2142219,'1','145','826',359,'Retail Sale Id 1270042',2898.00,0.00,0.00,0.00,504.00,'2021-12-03 14:38:18','',''),(2142220,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-03 14:38:18','',''),(2142244,'1','145','826',359,'Retail Sale Id 1270051',1449.00,0.00,0.00,0.00,252.00,'2021-12-03 14:39:25','',''),(2142245,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-03 14:39:25','',''),(2142261,'1','145','826',359,'Retail Sale Id 1270057',8625.00,0.00,0.00,0.00,1500.00,'2021-12-03 14:40:24','',''),(2142262,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:40:24','',''),(2142285,'1','145','826',359,'Retail Sale Id 1270068',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 14:41:32','',''),(2142286,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:41:32','',''),(2142313,'1','145','826',359,'Retail Sale Id 1270076',6900.00,0.00,0.00,0.00,1200.00,'2021-12-03 14:42:21','',''),(2142314,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 14:42:21','',''),(2142347,'1','145','826',359,'Retail Sale Id 1270090',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 14:43:43','',''),(2142348,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:43:43','',''),(2142369,'1','145','826',359,'Retail Sale Id 1270100',2760.00,0.00,0.00,0.00,480.00,'2021-12-03 14:44:28','',''),(2142370,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 14:44:28','',''),(2142429,'1','145','826',359,'Retail Sale Id 1270133',2898.00,0.00,0.00,0.00,504.00,'2021-12-03 14:46:57','',''),(2142430,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-03 14:46:57','',''),(2142467,'1','145','826',359,'Retail Sale Id 1270151',1449.00,0.00,0.00,0.00,252.00,'2021-12-03 14:48:15','',''),(2142468,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-03 14:48:15','',''),(2142486,'1','145','826',359,'Retail Sale Id 1270160',2760.00,0.00,0.00,0.00,480.00,'2021-12-03 14:49:14','',''),(2142487,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 14:49:14','',''),(2142529,'1','145','826',359,'Retail Sale Id 1270183',3450.00,0.00,0.00,0.00,600.00,'2021-12-03 14:51:32','',''),(2142530,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 14:51:32','',''),(2142545,'1','145','826',359,'Retail Sale Id 1270193',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 14:52:16','',''),(2142546,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:52:16','',''),(2142640,'1','145','826',359,'Retail Sale Id 1270227',2760.00,0.00,0.00,0.00,480.00,'2021-12-03 14:56:02','',''),(2142641,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 14:56:02','',''),(2142657,'1','145','826',359,'Retail Sale Id 1270236',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 14:56:55','',''),(2142658,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:56:55','',''),(2142677,'1','145','826',359,'Retail Sale Id 1270245',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 14:58:36','',''),(2142678,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:58:36','',''),(2142705,'1','145','826',359,'Retail Sale Id 1270259',3450.00,0.00,0.00,0.00,600.00,'2021-12-03 14:59:54','',''),(2142706,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 14:59:54','',''),(2142757,'1','145','826',359,'Retail Sale Id 1270286',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 15:03:54','',''),(2142758,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:03:54','',''),(2142773,'1','145','826',359,'Retail Sale Id 1270295',2760.00,0.00,0.00,0.00,480.00,'2021-12-03 15:05:12','',''),(2142774,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 15:05:12','',''),(2142812,'1','145','826',359,'Retail Sale Id 1270312',4830.00,0.00,0.00,0.00,840.00,'2021-12-03 15:07:44','',''),(2142813,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-03 15:07:44','',''),(2142828,'1','145','826',359,'Retail Sale Id 1270322',4830.00,0.00,0.00,0.00,840.00,'2021-12-03 15:08:53','',''),(2142829,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-03 15:08:53','',''),(2142862,'1','145','826',359,'Retail Sale Id 1270342',4140.00,0.00,0.00,0.00,720.00,'2021-12-03 15:10:15','',''),(2142863,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:10:16','',''),(2142924,'1','145','826',359,'Retail Sale Id 1270370',2760.00,0.00,0.00,0.00,480.00,'2021-12-03 15:13:12','',''),(2142925,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 15:13:12','',''),(2142982,'1','145','826',359,'Retail Sale Id 1270404',2001.00,0.00,0.00,0.00,348.00,'2021-12-03 15:15:23','',''),(2142983,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-03 15:15:23','',''),(2143025,'1','145','826',359,'Retail Sale Id 1270432',1449.00,0.00,0.00,0.00,252.00,'2021-12-03 15:17:26','',''),(2143026,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-03 15:17:26','',''),(2143045,'1','145','826',359,'Retail Sale Id 1270446',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 15:18:39','',''),(2143046,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:18:40','',''),(2143095,'1','145','826',359,'Retail Sale Id 1270472',2760.00,0.00,0.00,0.00,480.00,'2021-12-03 15:20:59','',''),(2143096,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 15:20:59','',''),(2143113,'1','145','826',359,'Retail Sale Id 1270484',4140.00,0.00,0.00,0.00,720.00,'2021-12-03 15:22:02','',''),(2143114,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:22:02','',''),(2143141,'1','145','826',359,'Retail Sale Id 1270499',12420.00,0.00,0.00,0.00,2160.00,'2021-12-03 15:23:31','',''),(2143142,'1','145','826',359,'Retail sales',0.00,0.00,0.00,18.00,0.00,'2021-12-03 15:23:31','',''),(2143161,'1','145','826',359,'Retail Sale Id 1270509',1380.00,0.00,0.00,0.00,240.00,'2021-12-03 15:24:43','',''),(2143162,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 15:24:43','',''),(2143179,'1','145','826',359,'Retail Sale Id 1270516',27300.00,0.00,0.00,0.00,3360.00,'2021-12-03 15:25:58','',''),(2143180,'1','145','826',359,'Retail sales',0.00,0.00,0.00,42.00,0.00,'2021-12-03 15:25:58','',''),(2143195,'1','145','826',359,'Retail Sale Id 1270524',1380.00,0.00,0.00,0.00,240.00,'2021-12-03 15:26:38','',''),(2143196,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 15:26:38','',''),(2143231,'1','145','826',359,'Retail Sale Id 1270540',5520.00,0.00,0.00,0.00,960.00,'2021-12-03 15:28:37','',''),(2143232,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 15:28:37','',''),(2143269,'1','145','826',359,'Retail Sale Id 1270559',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 15:30:06','',''),(2143270,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:30:06','',''),(2143291,'1','145','826',359,'Retail Sale Id 1270570',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 15:31:08','',''),(2143292,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:31:08','',''),(2143323,'1','145','826',359,'Retail Sale Id 1270584',2001.00,0.00,0.00,0.00,348.00,'2021-12-03 15:32:46','',''),(2143324,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-03 15:32:46','',''),(2143337,'1','145','826',359,'Retail Sale Id 1270594',8280.00,0.00,0.00,0.00,1440.00,'2021-12-03 15:33:39','',''),(2143338,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-03 15:33:39','',''),(2143409,'1','145','826',359,'Retail Sale Id 1270620',8694.00,0.00,0.00,0.00,1512.00,'2021-12-03 15:36:06','',''),(2143410,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.60,0.00,'2021-12-03 15:36:06','',''),(2143431,'1','145','826',359,'Retail Sale Id 1270638',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 15:37:03','',''),(2143432,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:37:03','',''),(2143448,'1','145','826',359,'Retail Sale Id 1270647',3450.00,0.00,0.00,0.00,600.00,'2021-12-03 15:37:46','',''),(2143449,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 15:37:46','',''),(2143470,'1','145','826',359,'Retail Sale Id 1270660',8280.00,0.00,0.00,0.00,1440.00,'2021-12-03 15:38:39','',''),(2143471,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-03 15:38:39','',''),(2143498,'1','145','826',359,'Retail Sale Id 1270674',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 15:39:38','',''),(2143499,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:39:38','',''),(2143528,'1','145','826',359,'Retail Sale Id 1270690',2898.00,0.00,0.00,0.00,504.00,'2021-12-03 15:40:53','',''),(2143529,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-03 15:40:53','',''),(2143544,'1','145','826',359,'Retail Sale Id 1270697',4140.00,0.00,0.00,0.00,720.00,'2021-12-03 15:41:35','',''),(2143545,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:41:35','',''),(2143578,'1','145','826',359,'Retail Sale Id 1270712',1449.00,0.00,0.00,0.00,252.00,'2021-12-03 15:42:57','',''),(2143579,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-03 15:42:57','',''),(2143604,'1','145','826',359,'Retail Sale Id 1270724',5520.00,0.00,0.00,0.00,960.00,'2021-12-03 15:43:58','',''),(2143605,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 15:43:58','',''),(2143676,'1','145','826',359,'Retail Sale Id 1270758',8625.00,0.00,0.00,0.00,1500.00,'2021-12-03 15:47:06','',''),(2143677,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:47:06','',''),(2143764,'1','145','826',359,'Retail Sale Id 1270802',4140.00,0.00,0.00,0.00,720.00,'2021-12-03 15:50:09','',''),(2143765,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:50:09','',''),(2143774,'1','145','826',359,'Retail Sale Id 1270808',4140.00,0.00,0.00,0.00,720.00,'2021-12-03 15:51:02','',''),(2143775,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:51:02','',''),(2143810,'1','145','826',359,'Retail Sale Id 1270826',4140.00,0.00,0.00,0.00,720.00,'2021-12-03 15:52:29','',''),(2143811,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:52:29','',''),(2143857,'1','145','826',359,'Retail Sale Id 1270852',39000.00,0.00,0.00,0.00,4800.00,'2021-12-03 15:54:53','',''),(2143858,'1','145','826',359,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-03 15:54:53','',''),(2143929,'1','145','826',359,'Retail Sale Id 1270887',2001.00,0.00,0.00,0.00,348.00,'2021-12-03 15:58:22','',''),(2143930,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-03 15:58:22','',''),(2143999,'1','145','826',359,'Retail Sale Id 1270920',2001.00,0.00,0.00,0.00,348.00,'2021-12-03 16:01:38','',''),(2144000,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-03 16:01:38','',''),(2144041,'1','145','826',359,'Retail Sale Id 1270938',9660.00,0.00,0.00,0.00,1680.00,'2021-12-03 16:03:19','',''),(2144042,'1','145','826',359,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-03 16:03:19','',''),(2144075,'1','145','826',359,'Retail Sale Id 1270957',1380.00,0.00,0.00,0.00,240.00,'2021-12-03 16:04:44','',''),(2144076,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 16:04:44','',''),(2144091,'1','145','826',359,'Retail Sale Id 1270971',4002.00,0.00,0.00,0.00,696.00,'2021-12-03 16:05:46','',''),(2144092,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-03 16:05:46','',''),(2144252,'1','145','826',359,'Retail Sale Id 1271046',4830.00,0.00,0.00,0.00,840.00,'2021-12-03 16:12:33','',''),(2144253,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-03 16:12:33','',''),(2144266,'1','145','826',359,'Retail Sale Id 1271058',1449.00,0.00,0.00,0.00,252.00,'2021-12-03 16:13:50','',''),(2144267,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-03 16:13:50','',''),(2144296,'1','145','826',359,'Retail Sale Id 1271070',8694.00,0.00,0.00,0.00,1512.00,'2021-12-03 16:15:25','',''),(2144297,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.60,0.00,'2021-12-03 16:15:25','',''),(2144390,'1','145','826',359,'Retail Sale Id 1271117',2760.00,0.00,0.00,0.00,480.00,'2021-12-03 16:20:23','',''),(2144391,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 16:20:23','',''),(2144418,'1','145','826',359,'Retail Sale Id 1271131',2070.00,0.00,0.00,0.00,360.00,'2021-12-03 16:21:44','',''),(2144419,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:21:44','',''),(2144436,'1','145','826',359,'Retail Sale Id 1271142',1380.00,0.00,0.00,0.00,240.00,'2021-12-03 16:22:45','',''),(2144437,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 16:22:45','',''),(2144472,'1','145','826',359,'Retail Sale Id 1271159',1035.00,0.00,0.00,0.00,180.00,'2021-12-03 16:24:33','',''),(2144473,'1','145','826',359,'Retail sales',0.00,0.00,0.00,1.50,0.00,'2021-12-03 16:24:33','',''),(2144647,'1','145','826',359,'Retail Sale Id 1271244',8125.00,0.00,0.00,0.00,1000.00,'2021-12-03 16:33:53','',''),(2144648,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:33:53','',''),(2144724,'1','145','826',359,'Retail Sale Id 1271286',395646.00,0.00,0.00,0.00,68808.00,'2021-12-03 16:37:36','',''),(2144725,'1','145','826',359,'Retail sales',0.00,0.00,0.00,573.40,0.00,'2021-12-03 16:37:36','',''),(2147297,'1','145','826',359,'Retail Sale Id 1272245',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 06:46:16','',''),(2147298,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 06:46:16','',''),(2147310,'1','145','826',359,'Retail Sale Id 1272253',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 06:47:23','',''),(2147311,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:47:23','',''),(2147330,'1','145','826',359,'Retail Sale Id 1272263',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 06:48:37','',''),(2147331,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 06:48:37','',''),(2147346,'1','145','826',359,'Retail Sale Id 1272272',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 06:49:25','',''),(2147347,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 06:49:25','',''),(2147388,'1','145','826',359,'Retail Sale Id 1272286',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 06:50:53','',''),(2147389,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 06:50:53','',''),(2147402,'1','145','826',359,'Retail Sale Id 1272295',39000.00,0.00,0.00,0.00,4800.00,'2021-12-04 06:52:17','',''),(2147403,'1','145','826',359,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-04 06:52:17','',''),(2147426,'1','145','826',359,'Retail Sale Id 1272308',8280.00,0.00,0.00,0.00,1440.00,'2021-12-04 06:53:35','',''),(2147427,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 06:53:35','',''),(2147485,'1','145','826',359,'Retail Sale Id 1272332',1380.00,0.00,0.00,0.00,240.00,'2021-12-04 06:56:07','',''),(2147486,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 06:56:07','',''),(2147514,'1','145','826',359,'Retail Sale Id 1272350',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 06:57:27','',''),(2147515,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 06:57:27','',''),(2147534,'1','145','826',359,'Retail Sale Id 1272356',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 06:58:21','',''),(2147535,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 06:58:21','',''),(2147562,'1','145','826',359,'Retail Sale Id 1272371',1380.00,0.00,0.00,0.00,240.00,'2021-12-04 07:00:08','',''),(2147563,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 07:00:08','',''),(2147584,'1','145','826',359,'Retail Sale Id 1272384',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 07:01:25','',''),(2147585,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 07:01:25','',''),(2147629,'1','145','826',359,'Retail Sale Id 1272401',5520.00,0.00,0.00,0.00,960.00,'2021-12-04 07:03:17','',''),(2147630,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 07:03:17','',''),(2147663,'1','145','826',359,'Retail Sale Id 1272412',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 07:05:31','',''),(2147664,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:05:31','',''),(2147693,'1','145','826',359,'Retail Sale Id 1272433',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 07:07:19','',''),(2147694,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:07:19','',''),(2147728,'1','145','826',359,'Retail Sale Id 1272447',8970.00,0.00,0.00,0.00,1560.00,'2021-12-04 07:09:23','',''),(2147729,'1','145','826',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-04 07:09:23','',''),(2147778,'1','145','826',359,'Retail Sale Id 1272481',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 07:12:43','',''),(2147779,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:12:43','',''),(2147815,'1','145','826',359,'Retail Sale Id 1272499',8280.00,0.00,0.00,0.00,1440.00,'2021-12-04 07:14:35','',''),(2147816,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 07:14:35','',''),(2147845,'1','145','826',359,'Retail Sale Id 1272527',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 07:15:59','',''),(2147846,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:15:59','',''),(2147874,'1','145','826',359,'Retail Sale Id 1272535',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 07:17:05','',''),(2147875,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:17:05','',''),(2147902,'1','145','826',359,'Retail Sale Id 1272549',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 07:18:41','',''),(2147903,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:18:41','',''),(2147920,'1','145','826',359,'Retail Sale Id 1272563',8280.00,0.00,0.00,0.00,1440.00,'2021-12-04 07:19:44','',''),(2147921,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 07:19:44','',''),(2147954,'1','145','826',359,'Retail Sale Id 1272579',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 07:21:25','',''),(2147955,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:21:25','',''),(2147978,'1','145','826',359,'Retail Sale Id 1272589',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 07:22:46','',''),(2147979,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:22:46','',''),(2148016,'1','145','826',359,'Retail Sale Id 1272607',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 07:24:54','',''),(2148017,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 07:24:54','',''),(2148062,'1','145','826',359,'Retail Sale Id 1272633',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 07:26:46','',''),(2148063,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:26:46','',''),(2148094,'1','145','826',359,'Retail Sale Id 1272651',15925.00,0.00,0.00,0.00,1960.00,'2021-12-04 07:28:31','',''),(2148095,'1','145','826',359,'Retail sales',0.00,0.00,0.00,24.50,0.00,'2021-12-04 07:28:31','',''),(2148138,'1','145','826',359,'Retail Sale Id 1272668',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 07:30:15','',''),(2148139,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 07:30:15','',''),(2148160,'1','145','826',359,'Retail Sale Id 1272681',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 07:31:33','',''),(2148161,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:31:33','',''),(2148186,'1','145','826',359,'Retail Sale Id 1272696',966.00,0.00,0.00,0.00,168.00,'2021-12-04 07:33:17','',''),(2148187,'1','145','826',359,'Retail sales',0.00,0.00,0.00,1.40,0.00,'2021-12-04 07:33:17','',''),(2148238,'1','145','826',359,'Retail Sale Id 1272728',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 07:35:04','',''),(2148239,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 07:35:04','',''),(2148267,'1','145','826',359,'Retail Sale Id 1272745',9660.00,0.00,0.00,0.00,1680.00,'2021-12-04 07:36:34','',''),(2148268,'1','145','826',359,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-04 07:36:34','',''),(2148297,'1','145','826',359,'Retail Sale Id 1272762',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 07:37:34','',''),(2148298,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:37:34','',''),(2148359,'1','145','826',359,'Retail Sale Id 1272798',32500.00,0.00,0.00,0.00,4000.00,'2021-12-04 07:40:26','',''),(2148360,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 07:40:26','',''),(2148394,'1','145','826',359,'Retail Sale Id 1272819',7590.00,0.00,0.00,0.00,1320.00,'2021-12-04 07:42:07','',''),(2148395,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-04 07:42:07','',''),(2148426,'1','145','826',359,'Retail Sale Id 1272871',1449.00,0.00,0.00,0.00,252.00,'2021-12-04 07:44:27','',''),(2148427,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-04 07:44:27','',''),(2148446,'1','145','826',359,'Retail Sale Id 1272891',1380.00,0.00,0.00,0.00,240.00,'2021-12-04 07:45:38','',''),(2148447,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 07:45:38','',''),(2148472,'1','145','826',359,'Retail Sale Id 1272902',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 07:47:20','',''),(2148473,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 07:47:20','',''),(2148517,'1','145','826',359,'Retail Sale Id 1272930',8280.00,0.00,0.00,0.00,1440.00,'2021-12-04 07:49:55','',''),(2148518,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 07:49:55','',''),(2148537,'1','145','826',359,'Retail Sale Id 1272938',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 07:51:13','',''),(2148538,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:51:13','',''),(2148558,'1','145','826',359,'Retail Sale Id 1272960',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 07:52:23','',''),(2148559,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 07:52:23','',''),(2148572,'1','145','826',359,'Retail Sale Id 1272970',5520.00,0.00,0.00,0.00,960.00,'2021-12-04 07:54:17','',''),(2148573,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 07:54:17','',''),(2148600,'1','145','826',359,'Retail Sale Id 1272978',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 07:55:30','',''),(2148601,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 07:55:31','',''),(2148634,'1','145','826',359,'Retail Sale Id 1273016',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 07:57:31','',''),(2148635,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 07:57:31','',''),(2148657,'1','145','826',359,'Retail Sale Id 1273031',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 07:58:55','',''),(2148658,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 07:58:55','',''),(2148679,'1','145','826',359,'Retail Sale Id 1273038',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 07:59:33','',''),(2148680,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:59:33','',''),(2148705,'1','145','826',359,'Retail Sale Id 1273045',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 08:00:25','',''),(2148706,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 08:00:25','',''),(2148721,'1','145','826',359,'Retail Sale Id 1273053',17250.00,0.00,0.00,0.00,3000.00,'2021-12-04 08:01:12','',''),(2148722,'1','145','826',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 08:01:12','',''),(2148778,'1','145','826',359,'Retail Sale Id 1273082',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 08:03:51','',''),(2148779,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 08:03:51','',''),(2148803,'1','145','826',359,'Retail Sale Id 1273090',2001.00,0.00,0.00,0.00,348.00,'2021-12-04 08:04:41','',''),(2148804,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 08:04:41','',''),(2148823,'1','145','826',359,'Retail Sale Id 1273103',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 08:05:31','',''),(2148824,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:05:31','',''),(2148839,'1','145','826',359,'Retail Sale Id 1273119',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 08:06:06','',''),(2148840,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 08:06:06','',''),(2148876,'1','145','826',359,'Retail Sale Id 1273136',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 08:07:41','',''),(2148877,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:07:41','',''),(2148898,'1','145','826',359,'Retail Sale Id 1273158',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 08:08:47','',''),(2148899,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:08:47','',''),(2148910,'1','145','826',359,'Retail Sale Id 1273163',8970.00,0.00,0.00,0.00,1560.00,'2021-12-04 08:09:31','',''),(2148911,'1','145','826',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-04 08:09:31','',''),(2148926,'1','145','826',359,'Retail Sale Id 1273172',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 08:10:27','',''),(2148927,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:10:27','',''),(2148950,'1','145','826',359,'Retail Sale Id 1273185',51350.00,0.00,0.00,0.00,6320.00,'2021-12-04 08:11:25','',''),(2148951,'1','145','826',359,'Retail sales',0.00,0.00,0.00,79.00,0.00,'2021-12-04 08:11:25','',''),(2148976,'1','145','826',359,'Retail Sale Id 1273198',57200.00,0.00,0.00,0.00,7040.00,'2021-12-04 08:12:25','',''),(2148977,'1','145','826',359,'Retail sales',0.00,0.00,0.00,88.00,0.00,'2021-12-04 08:12:25','',''),(2148998,'1','145','826',359,'Retail Sale Id 1273208',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 08:13:20','',''),(2148999,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:13:20','',''),(2149028,'1','145','826',359,'Retail Sale Id 1273223',6210.00,0.00,0.00,0.00,1080.00,'2021-12-04 08:14:10','',''),(2149029,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-04 08:14:10','',''),(2149045,'1','145','826',359,'Retail Sale Id 1273227',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 08:14:45','',''),(2149046,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:14:45','',''),(2149064,'1','145','826',359,'Retail Sale Id 1273234',1380.00,0.00,0.00,0.00,240.00,'2021-12-04 08:15:24','',''),(2149065,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 08:15:24','',''),(2149079,'1','145','826',359,'Retail Sale Id 1273243',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 08:16:11','',''),(2149080,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:16:11','',''),(2149144,'1','145','826',359,'Retail Sale Id 1273270',2898.00,0.00,0.00,0.00,504.00,'2021-12-04 08:18:48','',''),(2149145,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-04 08:18:48','',''),(2149170,'1','145','826',359,'Retail Sale Id 1273281',5520.00,0.00,0.00,0.00,960.00,'2021-12-04 08:20:01','',''),(2149171,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 08:20:01','',''),(2149200,'1','145','826',359,'Retail Sale Id 1273307',1380.00,0.00,0.00,0.00,240.00,'2021-12-04 08:21:22','',''),(2149201,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 08:21:22','',''),(2149215,'1','145','826',359,'Retail Sale Id 1273335',4002.00,0.00,0.00,0.00,696.00,'2021-12-04 08:22:27','',''),(2149216,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-04 08:22:27','',''),(2149235,'1','145','826',359,'Retail Sale Id 1273378',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 08:23:13','',''),(2149236,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 08:23:13','',''),(2149310,'1','145','826',359,'Retail Sale Id 1273416',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 08:26:23','',''),(2149311,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:26:23','',''),(2149380,'1','145','826',359,'Retail Sale Id 1273451',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 08:29:11','',''),(2149381,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:29:11','',''),(2149410,'1','145','826',359,'Retail Sale Id 1273466',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 08:30:26','',''),(2149411,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 08:30:26','',''),(2149448,'1','145','826',359,'Retail Sale Id 1273518',1449.00,0.00,0.00,0.00,252.00,'2021-12-04 08:31:38','',''),(2149449,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-04 08:31:38','',''),(2149495,'1','145','826',359,'Retail Sale Id 1273529',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 08:32:34','',''),(2149496,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:32:34','',''),(2149554,'1','145','826',359,'Retail Sale Id 1273559',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 08:34:56','',''),(2149555,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 08:34:56','',''),(2149576,'1','145','826',359,'Retail Sale Id 1273571',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 08:35:44','',''),(2149577,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 08:35:44','',''),(2149635,'1','145','826',359,'Retail Sale Id 1273597',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 08:37:51','',''),(2149636,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:37:51','',''),(2149676,'1','145','826',359,'Retail Sale Id 1273613',17250.00,0.00,0.00,0.00,3000.00,'2021-12-04 08:39:44','',''),(2149677,'1','145','826',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 08:39:44','',''),(2149698,'1','145','826',359,'Retail Sale Id 1273623',2001.00,0.00,0.00,0.00,348.00,'2021-12-04 08:41:03','',''),(2149699,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 08:41:03','',''),(2149712,'1','145','826',359,'Retail Sale Id 1273633',17250.00,0.00,0.00,0.00,3000.00,'2021-12-04 08:41:44','',''),(2149713,'1','145','826',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 08:41:44','',''),(2149731,'1','145','826',359,'Retail Sale Id 1273638',38350.00,0.00,0.00,0.00,4720.00,'2021-12-04 08:42:35','',''),(2149732,'1','145','826',359,'Retail sales',0.00,0.00,0.00,59.00,0.00,'2021-12-04 08:42:35','',''),(2149772,'1','145','826',359,'Retail Sale Id 1273660',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 08:43:54','',''),(2149773,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:43:54','',''),(2149868,'1','145','826',359,'Retail Sale Id 1273711',10350.00,0.00,0.00,0.00,1800.00,'2021-12-04 08:47:37','',''),(2149869,'1','145','826',359,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-04 08:47:37','',''),(2149892,'1','145','826',359,'Retail Sale Id 1273724',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 08:48:46','',''),(2149893,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:48:46','',''),(2149932,'1','145','826',359,'Retail Sale Id 1273748',2001.00,0.00,0.00,0.00,348.00,'2021-12-04 08:50:43','',''),(2149933,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 08:50:43','',''),(2150002,'1','145','826',359,'Retail Sale Id 1273787',2001.00,0.00,0.00,0.00,348.00,'2021-12-04 08:54:10','',''),(2150003,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 08:54:10','',''),(2150021,'1','145','826',359,'Retail Sale Id 1273797',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 08:55:03','',''),(2150022,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:55:03','',''),(2150041,'1','145','826',359,'Retail Sale Id 1273807',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 08:55:56','',''),(2150042,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:55:56','',''),(2150063,'1','145','826',359,'Retail Sale Id 1273819',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 08:56:55','',''),(2150064,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:56:55','',''),(2150085,'1','145','826',359,'Retail Sale Id 1273831',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 08:57:38','',''),(2150086,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:57:38','',''),(2150101,'1','145','826',359,'Retail Sale Id 1273838',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 08:58:41','',''),(2150102,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:58:41','',''),(2150129,'1','145','826',359,'Retail Sale Id 1273852',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 08:59:36','',''),(2150130,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 08:59:36','',''),(2150151,'1','145','826',359,'Retail Sale Id 1273863',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 09:00:50','',''),(2150152,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 09:00:50','',''),(2150177,'1','145','826',359,'Retail Sale Id 1273876',4278.00,0.00,0.00,0.00,744.00,'2021-12-04 09:02:24','',''),(2150178,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.20,0.00,'2021-12-04 09:02:24','',''),(2150193,'1','145','826',359,'Retail Sale Id 1273887',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 09:03:10','',''),(2150194,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 09:03:10','',''),(2150233,'1','145','826',359,'Retail Sale Id 1273914',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 09:04:47','',''),(2150234,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 09:04:47','',''),(2150255,'1','145','826',359,'Retail Sale Id 1273924',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 09:05:44','',''),(2150256,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 09:05:44','',''),(2150307,'1','145','826',359,'Retail Sale Id 1273951',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 09:08:32','',''),(2150308,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 09:08:32','',''),(2150335,'1','145','826',359,'Retail Sale Id 1273967',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 09:10:15','',''),(2150336,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 09:10:15','',''),(2150363,'1','145','826',359,'Retail Sale Id 1273982',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 09:11:51','',''),(2150364,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:11:51','',''),(2150397,'1','145','826',359,'Retail Sale Id 1273994',48100.00,0.00,0.00,0.00,5920.00,'2021-12-04 09:13:24','',''),(2150398,'1','145','826',359,'Retail sales',0.00,0.00,0.00,74.00,0.00,'2021-12-04 09:13:24','',''),(2150433,'1','145','826',359,'Retail Sale Id 1274013',1380.00,0.00,0.00,0.00,240.00,'2021-12-04 09:15:18','',''),(2150434,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 09:15:18','',''),(2150449,'1','145','826',359,'Retail Sale Id 1274026',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 09:16:20','',''),(2150450,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 09:16:20','',''),(2150469,'1','145','826',359,'Retail Sale Id 1274036',2001.00,0.00,0.00,0.00,348.00,'2021-12-04 09:17:17','',''),(2150470,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 09:17:17','',''),(2150493,'1','145','826',359,'Retail Sale Id 1274046',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 09:18:13','',''),(2150494,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 09:18:13','',''),(2150523,'1','145','826',359,'Retail Sale Id 1274063',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 09:19:26','',''),(2150524,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:19:26','',''),(2150557,'1','145','826',359,'Retail Sale Id 1274078',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 09:20:41','',''),(2150558,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 09:20:41','',''),(2150611,'1','145','826',359,'Retail Sale Id 1274104',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 09:23:17','',''),(2150612,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 09:23:17','',''),(2150643,'1','145','826',359,'Retail Sale Id 1274126',32500.00,0.00,0.00,0.00,4000.00,'2021-12-04 09:25:03','',''),(2150644,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 09:25:03','',''),(2150657,'1','145','826',359,'Retail Sale Id 1274133',39000.00,0.00,0.00,0.00,4800.00,'2021-12-04 09:26:13','',''),(2150658,'1','145','826',359,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-04 09:26:13','',''),(2150685,'1','145','826',359,'Retail Sale Id 1274145',2898.00,0.00,0.00,0.00,504.00,'2021-12-04 09:27:18','',''),(2150686,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-04 09:27:18','',''),(2150704,'1','145','826',359,'Retail Sale Id 1274154',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 09:28:03','',''),(2150705,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 09:28:03','',''),(2150722,'1','145','826',359,'Retail Sale Id 1274163',2898.00,0.00,0.00,0.00,504.00,'2021-12-04 09:29:06','',''),(2150723,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-04 09:29:06','',''),(2150742,'1','145','826',359,'Retail Sale Id 1274174',1449.00,0.00,0.00,0.00,252.00,'2021-12-04 09:29:57','',''),(2150743,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-04 09:29:57','',''),(2150764,'1','145','826',359,'Retail Sale Id 1274184',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 09:31:03','',''),(2150765,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 09:31:03','',''),(2150770,'1','145','826',359,'Retail Sale Id 1274195',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 09:31:46','',''),(2150771,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 09:31:46','',''),(2150794,'1','145','826',359,'Retail Sale Id 1274206',5520.00,0.00,0.00,0.00,960.00,'2021-12-04 09:32:33','',''),(2150795,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 09:32:33','',''),(2150816,'1','145','826',359,'Retail Sale Id 1274219',2001.00,0.00,0.00,0.00,348.00,'2021-12-04 09:34:00','',''),(2150817,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 09:34:00','',''),(2150844,'1','145','826',359,'Retail Sale Id 1274232',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 09:34:47','',''),(2150845,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 09:34:47','',''),(2152456,'1','145','826',359,'Retail Sale Id 1274256',9660.00,0.00,0.00,0.00,1680.00,'2021-12-04 10:32:54','',''),(2152457,'1','145','826',359,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-04 10:32:54','',''),(2152484,'1','145','826',359,'Retail Sale Id 1274400',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 10:34:54','',''),(2152485,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 10:34:54','',''),(2152500,'1','145','826',359,'Retail Sale Id 1274402',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 10:36:21','',''),(2152501,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 10:36:21','',''),(2152509,'1','145','826',359,'Retail Sale Id 1274410',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 10:37:14','',''),(2152510,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 10:37:14','',''),(2152515,'1','145','826',359,'Retail Sale Id 1274413',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 10:37:54','',''),(2152516,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:37:54','',''),(2152529,'1','145','826',359,'Retail Sale Id 1274416',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 10:39:28','',''),(2152530,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:39:28','',''),(2152537,'1','145','826',359,'Retail Sale Id 1274426',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 10:40:31','',''),(2152538,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:40:31','',''),(2152594,'1','145','826',359,'Retail Sale Id 1274439',6555.00,0.00,0.00,0.00,1140.00,'2021-12-04 10:43:45','',''),(2152595,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.50,0.00,'2021-12-04 10:43:45','',''),(2152610,'1','145','826',359,'Retail Sale Id 1274448',7590.00,0.00,0.00,0.00,1320.00,'2021-12-04 10:45:08','',''),(2152611,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-04 10:45:08','',''),(2152632,'1','145','826',359,'Retail Sale Id 1274453',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 10:45:57','',''),(2152633,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 10:45:57','',''),(2152652,'1','145','826',359,'Retail Sale Id 1274462',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 10:47:07','',''),(2152653,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 10:47:07','',''),(2152664,'1','145','826',359,'Retail Sale Id 1274465',37700.00,0.00,0.00,0.00,4640.00,'2021-12-04 10:48:19','',''),(2152665,'1','145','826',359,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-04 10:48:19','',''),(2152680,'1','145','826',359,'Retail Sale Id 1274473',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 10:49:20','',''),(2152681,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 10:49:20','',''),(2152702,'1','145','826',359,'Retail Sale Id 1274486',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 10:50:23','',''),(2152703,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 10:50:23','',''),(2152753,'1','145','826',359,'Retail Sale Id 1274506',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 10:52:52','',''),(2152754,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 10:52:52','',''),(2152777,'1','145','826',359,'Retail Sale Id 1274512',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 10:54:04','',''),(2152778,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 10:54:04','',''),(2152797,'1','145','826',359,'Retail Sale Id 1274520',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 10:54:54','',''),(2152798,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 10:54:54','',''),(2152815,'1','145','826',359,'Retail Sale Id 1274529',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 10:55:56','',''),(2152816,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 10:55:56','',''),(2152855,'1','145','826',359,'Retail Sale Id 1274547',4968.00,0.00,0.00,0.00,864.00,'2021-12-04 10:58:22','',''),(2152856,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.20,0.00,'2021-12-04 10:58:22','',''),(2152865,'1','145','826',359,'Retail Sale Id 1274552',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 10:59:11','',''),(2152866,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 10:59:11','',''),(2152883,'1','145','826',359,'Retail Sale Id 1274562',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 11:00:23','',''),(2152884,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 11:00:23','',''),(2152912,'1','145','826',359,'Retail Sale Id 1274573',1380.00,0.00,0.00,0.00,240.00,'2021-12-04 11:01:45','',''),(2152913,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 11:01:45','',''),(2152950,'1','145','826',359,'Retail Sale Id 1274593',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 11:03:18','',''),(2152951,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:03:18','',''),(2152998,'1','145','826',359,'Retail Sale Id 1274614',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 11:05:58','',''),(2152999,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 11:05:58','',''),(2153028,'1','145','826',359,'Retail Sale Id 1274631',6210.00,0.00,0.00,0.00,1080.00,'2021-12-04 11:07:26','',''),(2153029,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-04 11:07:26','',''),(2153060,'1','145','826',359,'Retail Sale Id 1274650',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 11:08:53','',''),(2153061,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 11:08:53','',''),(2153075,'1','145','826',359,'Retail Sale Id 1274655',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 11:09:55','',''),(2153076,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 11:09:55','',''),(2153097,'1','145','826',359,'Retail Sale Id 1274666',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 11:10:56','',''),(2153098,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 11:10:56','',''),(2153121,'1','145','826',359,'Retail Sale Id 1274677',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 11:11:57','',''),(2153122,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 11:11:57','',''),(2153139,'1','145','826',359,'Retail Sale Id 1274683',8280.00,0.00,0.00,0.00,1440.00,'2021-12-04 11:12:46','',''),(2153140,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 11:12:46','',''),(2153153,'1','145','826',359,'Retail Sale Id 1274692',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 11:13:26','',''),(2153154,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:13:26','',''),(2153187,'1','145','826',359,'Retail Sale Id 1274711',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 11:15:21','',''),(2153188,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:15:21','',''),(2153217,'1','145','826',359,'Retail Sale Id 1274727',2001.00,0.00,0.00,0.00,348.00,'2021-12-04 11:16:28','',''),(2153218,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 11:16:28','',''),(2153261,'1','145','826',359,'Retail Sale Id 1274749',6210.00,0.00,0.00,0.00,1080.00,'2021-12-04 11:18:21','',''),(2153262,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-04 11:18:21','',''),(2153301,'1','145','826',359,'Retail Sale Id 1274772',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 11:20:40','',''),(2153302,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 11:20:40','',''),(2153346,'1','145','826',359,'Retail Sale Id 1274790',34450.00,0.00,0.00,0.00,4240.00,'2021-12-04 11:23:10','',''),(2153347,'1','145','826',359,'Retail sales',0.00,0.00,0.00,53.00,0.00,'2021-12-04 11:23:10','',''),(2153364,'1','145','826',359,'Retail Sale Id 1274800',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 11:24:14','',''),(2153365,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 11:24:14','',''),(2153386,'1','145','826',359,'Retail Sale Id 1274811',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 11:25:50','',''),(2153389,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 11:25:50','',''),(2153406,'1','145','826',359,'Retail Sale Id 1274827',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 11:26:54','',''),(2153407,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 11:26:54','',''),(2153433,'1','145','826',359,'Retail Sale Id 1274838',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 11:28:40','',''),(2153434,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 11:28:40','',''),(2153463,'1','145','826',359,'Retail Sale Id 1274858',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 11:30:36','',''),(2153464,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 11:30:36','',''),(2153507,'1','145','826',359,'Retail Sale Id 1274873',4899.00,0.00,0.00,0.00,852.00,'2021-12-04 11:32:20','',''),(2153508,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-04 11:32:20','',''),(2153535,'1','145','826',359,'Retail Sale Id 1274891',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 11:33:44','',''),(2153536,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 11:33:44','',''),(2153556,'1','145','826',359,'Retail Sale Id 1274901',4899.00,0.00,0.00,0.00,852.00,'2021-12-04 11:34:51','',''),(2153557,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-04 11:34:51','',''),(2153574,'1','145','826',359,'Retail Sale Id 1274909',17250.00,0.00,0.00,0.00,3000.00,'2021-12-04 11:35:40','',''),(2153575,'1','145','826',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 11:35:40','',''),(2153596,'1','145','826',359,'Retail Sale Id 1274925',8280.00,0.00,0.00,0.00,1440.00,'2021-12-04 11:36:58','',''),(2153597,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 11:36:58','',''),(2153651,'1','145','826',359,'Retail Sale Id 1274940',1380.00,0.00,0.00,0.00,240.00,'2021-12-04 11:38:41','',''),(2153652,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 11:38:41','',''),(2153745,'1','145','826',359,'Retail Sale Id 1274976',4209.00,0.00,0.00,0.00,732.00,'2021-12-04 11:44:38','',''),(2153746,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 11:44:38','',''),(2153776,'1','145','826',359,'Retail Sale Id 1274997',8280.00,0.00,0.00,0.00,1440.00,'2021-12-04 11:46:15','',''),(2153777,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 11:46:15','',''),(2153791,'1','145','826',359,'Retail Sale Id 1275003',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 11:47:10','',''),(2153792,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 11:47:10','',''),(2153815,'1','145','826',359,'Retail Sale Id 1275011',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 11:48:34','',''),(2153816,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 11:48:34','',''),(2153844,'1','145','826',359,'Retail Sale Id 1275025',1380.00,0.00,0.00,0.00,240.00,'2021-12-04 11:50:20','',''),(2153845,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 11:50:20','',''),(2153869,'1','145','826',359,'Retail Sale Id 1275032',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 11:51:19','',''),(2153870,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:51:19','',''),(2153901,'1','145','826',359,'Retail Sale Id 1275049',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 11:53:21','',''),(2153902,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 11:53:21','',''),(2153928,'1','145','826',359,'Retail Sale Id 1275058',2001.00,0.00,0.00,0.00,348.00,'2021-12-04 11:54:38','',''),(2153929,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 11:54:38','',''),(2153946,'1','145','826',359,'Retail Sale Id 1275064',6210.00,0.00,0.00,0.00,1080.00,'2021-12-04 11:55:34','',''),(2153947,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-04 11:55:34','',''),(2153970,'1','145','826',359,'Retail Sale Id 1275074',6210.00,0.00,0.00,0.00,1080.00,'2021-12-04 11:57:06','',''),(2153971,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-04 11:57:06','',''),(2154004,'1','145','826',359,'Retail Sale Id 1275082',32500.00,0.00,0.00,0.00,4000.00,'2021-12-04 11:59:01','',''),(2154005,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 11:59:01','',''),(2154041,'1','145','826',359,'Retail Sale Id 1275091',39000.00,0.00,0.00,0.00,4800.00,'2021-12-04 11:59:50','',''),(2154042,'1','145','826',359,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-04 11:59:50','',''),(2154079,'1','145','826',359,'Retail Sale Id 1275101',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 12:01:54','',''),(2154080,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 12:01:54','',''),(2154109,'1','145','826',359,'Retail Sale Id 1275111',5520.00,0.00,0.00,0.00,960.00,'2021-12-04 12:02:59','',''),(2154110,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 12:02:59','',''),(2154158,'1','145','826',359,'Retail Sale Id 1275117',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 12:04:00','',''),(2154159,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 12:04:00','',''),(2154186,'1','145','826',359,'Retail Sale Id 1275122',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 12:05:06','',''),(2154187,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 12:05:06','',''),(2154258,'1','145','826',359,'Retail Sale Id 1275159',10350.00,0.00,0.00,0.00,1800.00,'2021-12-04 12:09:30','',''),(2154259,'1','145','826',359,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-04 12:09:30','',''),(2154280,'1','145','826',359,'Return of Retail Sale Id 1275091',0.00,39000.00,60.00,0.00,-4800.00,'2021-12-04 12:10:25','',''),(2154287,'1','145','826',359,'Retail Sale Id 1275176',38090.00,0.00,0.00,0.00,4688.00,'2021-12-04 12:11:16','',''),(2154288,'1','145','826',359,'Retail sales',0.00,0.00,0.00,58.60,0.00,'2021-12-04 12:11:16','',''),(2154309,'1','145','826',359,'Retail Sale Id 1275184',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 12:12:19','',''),(2154310,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 12:12:19','',''),(2154327,'1','145','826',359,'Retail Sale Id 1275195',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 12:13:34','',''),(2154328,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:13:34','',''),(2154343,'1','145','826',359,'Retail Sale Id 1275204',1380.00,0.00,0.00,0.00,240.00,'2021-12-04 12:14:38','',''),(2154344,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 12:14:38','',''),(2154365,'1','145','826',359,'Retail Sale Id 1275215',2001.00,0.00,0.00,0.00,348.00,'2021-12-04 12:15:58','',''),(2154366,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 12:15:58','',''),(2154395,'1','145','826',359,'Retail Sale Id 1275232',76960.00,0.00,0.00,0.00,9472.00,'2021-12-04 12:18:54','',''),(2154396,'1','145','826',359,'Retail sales',0.00,0.00,0.00,118.40,0.00,'2021-12-04 12:18:54','',''),(2154447,'1','145','826',359,'Retail Sale Id 1275258',5520.00,0.00,0.00,0.00,960.00,'2021-12-04 12:22:23','',''),(2154448,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 12:22:23','',''),(2154607,'1','145','826',359,'Retail Sale Id 1275338',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 12:31:04','',''),(2154608,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 12:31:04','',''),(2154623,'1','145','826',359,'Retail Sale Id 1275346',2898.00,0.00,0.00,0.00,504.00,'2021-12-04 12:32:15','',''),(2154624,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-04 12:32:15','',''),(2154655,'1','145','826',359,'Retail Sale Id 1275360',4899.00,0.00,0.00,0.00,852.00,'2021-12-04 12:33:37','',''),(2154656,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-04 12:33:37','',''),(2154691,'1','145','826',359,'Retail Sale Id 1275379',4002.00,0.00,0.00,0.00,696.00,'2021-12-04 12:36:25','',''),(2154692,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-04 12:36:25','',''),(2154709,'1','145','826',359,'Retail Sale Id 1275386',8125.00,0.00,0.00,0.00,1000.00,'2021-12-04 12:37:19','',''),(2154710,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:37:19','',''),(2154727,'1','145','826',359,'Retail Sale Id 1275394',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 12:38:31','',''),(2154728,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 12:38:32','',''),(2154739,'1','145','826',359,'Retail Sale Id 1275403',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 12:39:30','',''),(2154740,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 12:39:30','',''),(2154752,'1','145','826',359,'Retail Sale Id 1275410',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 12:40:09','',''),(2154753,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 12:40:09','',''),(2154780,'1','145','826',359,'Retail Sale Id 1275423',1449.00,0.00,0.00,0.00,252.00,'2021-12-04 12:42:10','',''),(2154781,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-04 12:42:10','',''),(2154788,'1','145','826',359,'Retail Sale Id 1275429',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 12:43:11','',''),(2154789,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 12:43:11','',''),(2154808,'1','145','826',359,'Retail Sale Id 1275440',55900.00,0.00,0.00,0.00,6880.00,'2021-12-04 12:44:57','',''),(2154809,'1','145','826',359,'Retail sales',0.00,0.00,0.00,86.00,0.00,'2021-12-04 12:44:57','',''),(2154840,'1','145','826',359,'Retail Sale Id 1275454',1449.00,0.00,0.00,0.00,252.00,'2021-12-04 12:47:25','',''),(2154841,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-04 12:47:25','',''),(2154850,'1','145','826',359,'Retail Sale Id 1275457',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 12:48:33','',''),(2154851,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 12:48:33','',''),(2154882,'1','145','826',359,'Retail Sale Id 1275468',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 12:49:43','',''),(2154883,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:49:43','',''),(2154902,'1','145','826',359,'Retail Sale Id 1275474',32500.00,0.00,0.00,0.00,4000.00,'2021-12-04 12:51:03','',''),(2154903,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 12:51:03','',''),(2154915,'1','145','826',359,'Retail Sale Id 1275482',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 12:51:59','',''),(2154916,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 12:51:59','',''),(2154944,'1','145','826',359,'Retail Sale Id 1275492',8280.00,0.00,0.00,0.00,1440.00,'2021-12-04 12:53:22','',''),(2154945,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 12:53:22','',''),(2154970,'1','145','826',359,'Retail Sale Id 1275507',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 12:54:46','',''),(2154971,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 12:54:46','',''),(2155061,'1','145','826',359,'Retail Sale Id 1275769',4002.00,0.00,0.00,0.00,696.00,'2021-12-04 13:07:17','',''),(2155062,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-04 13:07:17','',''),(2155071,'1','145','826',359,'Retail Sale Id 1275774',32500.00,0.00,0.00,0.00,4000.00,'2021-12-04 13:08:08','',''),(2155072,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 13:08:08','',''),(2155093,'1','145','826',359,'Retail Sale Id 1275784',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 13:09:58','',''),(2155094,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 13:09:58','',''),(2155113,'1','145','826',359,'Retail Sale Id 1275792',8280.00,0.00,0.00,0.00,1440.00,'2021-12-04 13:11:12','',''),(2155114,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 13:11:12','',''),(2155136,'1','145','826',359,'Retail Sale Id 1275801',8694.00,0.00,0.00,0.00,1512.00,'2021-12-04 13:12:24','',''),(2155137,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.60,0.00,'2021-12-04 13:12:24','',''),(2155165,'1','145','826',359,'Retail Sale Id 1275812',8349.00,0.00,0.00,0.00,1452.00,'2021-12-04 13:14:05','',''),(2155166,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.10,0.00,'2021-12-04 13:14:05','',''),(2155180,'1','145','826',359,'Retail Sale Id 1275820',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 13:15:00','',''),(2155181,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:15:00','',''),(2155199,'1','145','826',359,'Retail Sale Id 1275828',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 13:15:53','',''),(2155200,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 13:15:53','',''),(2155216,'1','145','826',359,'Retail Sale Id 1275837',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 13:17:28','',''),(2155217,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 13:17:28','',''),(2155251,'1','145','826',359,'Retail Sale Id 1275846',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 13:19:48','',''),(2155252,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 13:19:48','',''),(2155305,'1','145','826',359,'Retail Sale Id 1275871',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 13:22:40','',''),(2155306,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 13:22:40','',''),(2155319,'1','145','826',359,'Retail Sale Id 1275874',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 13:23:21','',''),(2155320,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:23:21','',''),(2155440,'1','145','826',359,'Retail Sale Id 1275907',8694.00,0.00,0.00,0.00,1512.00,'2021-12-04 13:27:19','',''),(2155441,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.60,0.00,'2021-12-04 13:27:19','',''),(2155472,'1','145','826',359,'Retail Sale Id 1275923',91000.00,0.00,0.00,0.00,11200.00,'2021-12-04 13:29:47','',''),(2155473,'1','145','826',359,'Retail sales',0.00,0.00,0.00,140.00,0.00,'2021-12-04 13:29:47','',''),(2155516,'1','145','826',359,'Retail Sale Id 1275944',2001.00,0.00,0.00,0.00,348.00,'2021-12-04 13:31:41','',''),(2155517,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 13:31:41','',''),(2155539,'1','145','826',359,'Retail Sale Id 1275958',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 13:33:26','',''),(2155540,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 13:33:26','',''),(2155555,'1','145','826',359,'Retail Sale Id 1275966',1449.00,0.00,0.00,0.00,252.00,'2021-12-04 13:34:11','',''),(2155556,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-04 13:34:11','',''),(2155569,'1','145','826',359,'Retail Sale Id 1275971',1449.00,0.00,0.00,0.00,252.00,'2021-12-04 13:35:00','',''),(2155570,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-04 13:35:00','',''),(2155652,'1','145','826',359,'Retail Sale Id 1276009',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 13:39:52','',''),(2155653,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 13:39:52','',''),(2155672,'1','145','826',359,'Retail Sale Id 1276017',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 13:40:51','',''),(2155673,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 13:40:51','',''),(2155682,'1','145','826',359,'Retail Sale Id 1276023',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 13:41:39','',''),(2155683,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 13:41:39','',''),(2155706,'1','145','826',359,'Retail Sale Id 1276037',1380.00,0.00,0.00,0.00,240.00,'2021-12-04 13:42:44','',''),(2155707,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 13:42:44','',''),(2155724,'1','145','826',359,'Retail Sale Id 1276049',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 13:43:42','',''),(2155725,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 13:43:42','',''),(2155928,'1','145','826',359,'Retail Sale Id 1276128',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 13:52:58','',''),(2155929,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:52:58','',''),(2155964,'1','145','826',359,'Retail Sale Id 1276153',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 13:55:42','',''),(2155965,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:55:42','',''),(2155982,'1','145','826',359,'Retail Sale Id 1276164',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 13:56:48','',''),(2155983,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 13:56:48','',''),(2156015,'1','145','826',359,'Retail Sale Id 1276173',1380.00,0.00,0.00,0.00,240.00,'2021-12-04 13:57:44','',''),(2156016,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 13:57:44','',''),(2156041,'1','145','826',359,'Retail Sale Id 1276186',8694.00,0.00,0.00,0.00,1512.00,'2021-12-04 13:58:58','',''),(2156042,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.60,0.00,'2021-12-04 13:58:58','',''),(2156061,'1','145','826',359,'Retail Sale Id 1276192',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 13:59:55','',''),(2156062,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:59:55','',''),(2156084,'1','145','826',359,'Retail Sale Id 1276206',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 14:01:02','',''),(2156085,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 14:01:02','',''),(2156108,'1','145','826',359,'Retail Sale Id 1276211',32500.00,0.00,0.00,0.00,4000.00,'2021-12-04 14:01:44','',''),(2156109,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 14:01:44','',''),(2156148,'1','145','826',359,'Retail Sale Id 1276226',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 14:03:31','',''),(2156149,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 14:03:31','',''),(2156178,'1','145','826',359,'Retail Sale Id 1276245',7590.00,0.00,0.00,0.00,1320.00,'2021-12-04 14:04:39','',''),(2156179,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-04 14:04:39','',''),(2156229,'1','145','826',359,'Retail Sale Id 1276259',1449.00,0.00,0.00,0.00,252.00,'2021-12-04 14:06:03','',''),(2156230,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-04 14:06:03','',''),(2156265,'1','145','826',359,'Retail Sale Id 1276278',8280.00,0.00,0.00,0.00,1440.00,'2021-12-04 14:07:46','',''),(2156266,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 14:07:46','',''),(2156293,'1','145','826',359,'Retail Sale Id 1276294',6003.00,0.00,0.00,0.00,1044.00,'2021-12-04 14:08:56','',''),(2156294,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.70,0.00,'2021-12-04 14:08:56','',''),(2156317,'1','145','826',359,'Retail Sale Id 1276308',1449.00,0.00,0.00,0.00,252.00,'2021-12-04 14:10:21','',''),(2156318,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-04 14:10:21','',''),(2156337,'1','145','826',359,'Retail Sale Id 1276319',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 14:11:39','',''),(2156338,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:11:39','',''),(2156355,'1','145','826',359,'Retail Sale Id 1276329',13800.00,0.00,0.00,0.00,2400.00,'2021-12-04 14:12:26','',''),(2156356,'1','145','826',359,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-04 14:12:26','',''),(2156383,'1','145','826',359,'Retail Sale Id 1276341',4485.00,0.00,0.00,0.00,780.00,'2021-12-04 14:13:45','',''),(2156384,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-04 14:13:45','',''),(2156422,'1','145','826',359,'Retail Sale Id 1276352',8280.00,0.00,0.00,0.00,1440.00,'2021-12-04 14:14:49','',''),(2156423,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 14:14:49','',''),(2156454,'1','145','826',359,'Retail Sale Id 1276370',6210.00,0.00,0.00,0.00,1080.00,'2021-12-04 14:16:19','',''),(2156455,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-04 14:16:19','',''),(2156484,'1','145','826',359,'Retail Sale Id 1276385',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 14:17:44','',''),(2156485,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 14:17:44','',''),(2156510,'1','145','826',359,'Retail Sale Id 1276400',2001.00,0.00,0.00,0.00,348.00,'2021-12-04 14:18:44','',''),(2156511,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 14:18:44','',''),(2156526,'1','145','826',359,'Retail Sale Id 1276404',8280.00,0.00,0.00,0.00,1440.00,'2021-12-04 14:19:42','',''),(2156527,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 14:19:42','',''),(2156558,'1','145','826',359,'Retail Sale Id 1276426',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 14:21:37','',''),(2156559,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 14:21:37','',''),(2156655,'1','145','826',359,'Retail Sale Id 1276470',8280.00,0.00,0.00,0.00,1440.00,'2021-12-04 14:26:50','',''),(2156656,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 14:26:50','',''),(2156679,'1','145','826',359,'Retail Sale Id 1276483',1449.00,0.00,0.00,0.00,252.00,'2021-12-04 14:28:24','',''),(2156680,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-04 14:28:24','',''),(2156721,'1','145','826',359,'Retail Sale Id 1276506',2001.00,0.00,0.00,0.00,348.00,'2021-12-04 14:31:23','',''),(2156722,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 14:31:23','',''),(2156774,'1','145','826',359,'Retail Sale Id 1276532',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 14:34:18','',''),(2156775,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 14:34:18','',''),(2156806,'1','145','826',359,'Retail Sale Id 1276543',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 14:35:39','',''),(2156807,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:35:39','',''),(2156826,'1','145','826',359,'Retail Sale Id 1276556',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 14:36:51','',''),(2156827,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:36:51','',''),(2156840,'1','145','826',359,'Retail Sale Id 1276564',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 14:37:44','',''),(2156841,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:37:44','',''),(2157017,'1','145','826',359,'Retail Sale Id 1276621',8280.00,0.00,0.00,0.00,1440.00,'2021-12-04 14:45:49','',''),(2157018,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 14:45:49','',''),(2157056,'1','145','826',359,'Retail Sale Id 1276633',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 14:47:21','',''),(2157057,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 14:47:21','',''),(2157173,'1','145','826',359,'Retail Sale Id 1276683',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 14:53:56','',''),(2157174,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 14:53:56','',''),(2157196,'1','145','826',359,'Retail Sale Id 1276690',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 14:54:53','',''),(2157197,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 14:54:53','',''),(2157236,'1','145','826',359,'Retail Sale Id 1276704',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 14:56:14','',''),(2157237,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 14:56:14','',''),(2157256,'1','145','826',359,'Retail Sale Id 1276711',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 14:57:33','',''),(2157257,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 14:57:33','',''),(2157293,'1','145','826',359,'Retail Sale Id 1276725',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 14:58:49','',''),(2157294,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 14:58:49','',''),(2157320,'1','145','826',359,'Retail Sale Id 1276734',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 14:59:53','',''),(2157321,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 14:59:53','',''),(2157332,'1','145','826',359,'Retail Sale Id 1276742',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 15:00:28','',''),(2157333,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 15:00:28','',''),(2157349,'1','145','826',359,'Retail Sale Id 1276745',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 15:01:53','',''),(2157350,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 15:01:53','',''),(2157382,'1','145','826',359,'Retail Sale Id 1276758',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 15:03:15','',''),(2157383,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:03:15','',''),(2157394,'1','145','826',359,'Retail Sale Id 1276763',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 15:04:05','',''),(2157395,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:04:05','',''),(2157438,'1','145','826',359,'Retail Sale Id 1276790',4899.00,0.00,0.00,0.00,852.00,'2021-12-04 15:06:45','',''),(2157439,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-04 15:06:45','',''),(2157458,'1','145','826',359,'Retail Sale Id 1276802',1380.00,0.00,0.00,0.00,240.00,'2021-12-04 15:08:36','',''),(2157459,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 15:08:36','',''),(2157470,'1','145','826',359,'Retail Sale Id 1276810',4899.00,0.00,0.00,0.00,852.00,'2021-12-04 15:09:32','',''),(2157471,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-04 15:09:32','',''),(2157478,'1','145','826',359,'Retail Sale Id 1276814',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 15:10:21','',''),(2157479,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 15:10:21','',''),(2157490,'1','145','826',359,'Retail Sale Id 1276820',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 15:11:09','',''),(2157491,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:11:09','',''),(2157514,'1','145','826',359,'Retail Sale Id 1276832',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 15:12:38','',''),(2157515,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 15:12:38','',''),(2157542,'1','145','826',359,'Retail Sale Id 1276842',1380.00,0.00,0.00,0.00,240.00,'2021-12-04 15:13:27','',''),(2157543,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 15:13:27','',''),(2157576,'1','145','826',359,'Retail Sale Id 1276857',2001.00,0.00,0.00,0.00,348.00,'2021-12-04 15:14:54','',''),(2157577,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 15:14:54','',''),(2157594,'1','145','826',359,'Retail Sale Id 1276864',1449.00,0.00,0.00,0.00,252.00,'2021-12-04 15:15:51','',''),(2157595,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-04 15:15:51','',''),(2157608,'1','145','826',359,'Retail Sale Id 1276871',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 15:16:43','',''),(2157609,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 15:16:43','',''),(2157624,'1','145','826',359,'Retail Sale Id 1276873',8280.00,0.00,0.00,0.00,1440.00,'2021-12-04 15:17:36','',''),(2157625,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 15:17:36','',''),(2157644,'1','145','826',359,'Retail Sale Id 1276888',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 15:18:39','',''),(2157645,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:18:39','',''),(2157674,'1','145','826',359,'Retail Sale Id 1276896',1380.00,0.00,0.00,0.00,240.00,'2021-12-04 15:19:24','',''),(2157675,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 15:19:24','',''),(2157688,'1','145','826',359,'Retail Sale Id 1276907',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 15:20:21','',''),(2157689,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 15:20:21','',''),(2157728,'1','145','826',359,'Retail Sale Id 1276915',65000.00,0.00,0.00,0.00,8000.00,'2021-12-04 15:21:53','',''),(2157729,'1','145','826',359,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-04 15:21:53','',''),(2157808,'1','145','826',359,'Retail Sale Id 1276949',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 15:25:26','',''),(2157809,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 15:25:26','',''),(2157861,'1','145','826',359,'Retail Sale Id 1276974',4140.00,0.00,0.00,0.00,720.00,'2021-12-04 15:27:25','',''),(2157862,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:27:25','',''),(2157955,'1','145','826',359,'Retail Sale Id 1277023',8775.00,0.00,0.00,0.00,1080.00,'2021-12-04 15:32:03','',''),(2157956,'1','145','826',359,'Retail sales',0.00,0.00,0.00,13.50,0.00,'2021-12-04 15:32:03','',''),(2157991,'1','145','826',359,'Retail Sale Id 1277035',5520.00,0.00,0.00,0.00,960.00,'2021-12-04 15:33:07','',''),(2157992,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 15:33:07','',''),(2158052,'1','145','826',359,'Retail Sale Id 1277066',4968.00,0.00,0.00,0.00,864.00,'2021-12-04 15:36:17','',''),(2158053,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.20,0.00,'2021-12-04 15:36:17','',''),(2158070,'1','145','826',359,'Retail Sale Id 1277077',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 15:37:06','',''),(2158071,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 15:37:06','',''),(2158084,'1','145','826',359,'Retail Sale Id 1277085',2001.00,0.00,0.00,0.00,348.00,'2021-12-04 15:38:10','',''),(2158085,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 15:38:10','',''),(2158098,'1','145','826',359,'Retail Sale Id 1277092',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 15:39:08','',''),(2158099,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:39:08','',''),(2158118,'1','145','826',359,'Retail Sale Id 1277100',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 15:40:09','',''),(2158119,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:40:09','',''),(2158138,'1','145','826',359,'Retail Sale Id 1277107',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 15:41:07','',''),(2158139,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:41:07','',''),(2158176,'1','145','826',359,'Retail Sale Id 1277123',3381.00,0.00,0.00,0.00,588.00,'2021-12-04 15:42:46','',''),(2158177,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.90,0.00,'2021-12-04 15:42:46','',''),(2158199,'1','145','826',359,'Retail Sale Id 1277141',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 15:43:58','',''),(2158200,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 15:43:58','',''),(2158222,'1','145','826',359,'Retail Sale Id 1277147',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 15:44:37','',''),(2158223,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:44:37','',''),(2158246,'1','145','826',359,'Retail Sale Id 1277159',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 15:45:49','',''),(2158247,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 15:45:49','',''),(2158258,'1','145','826',359,'Retail Sale Id 1277164',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 15:46:32','',''),(2158259,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 15:46:32','',''),(2158317,'1','145','826',359,'Retail Sale Id 1277189',2001.00,0.00,0.00,0.00,348.00,'2021-12-04 15:48:59','',''),(2158318,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 15:48:59','',''),(2158366,'1','145','826',359,'Retail Sale Id 1277212',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 15:51:26','',''),(2158367,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:51:26','',''),(2158372,'1','145','826',359,'Retail Sale Id 1277214',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 15:52:03','',''),(2158373,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:52:03','',''),(2158398,'1','145','826',359,'Retail Sale Id 1277229',1449.00,0.00,0.00,0.00,252.00,'2021-12-04 15:53:15','',''),(2158399,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-04 15:53:15','',''),(2158424,'1','145','826',359,'Retail Sale Id 1277239',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 15:54:33','',''),(2158425,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:54:33','',''),(2158442,'1','145','826',359,'Retail Sale Id 1277253',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 15:55:25','',''),(2158443,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 15:55:25','',''),(2158484,'1','145','826',359,'Retail Sale Id 1277280',32500.00,0.00,0.00,0.00,4000.00,'2021-12-04 15:57:09','',''),(2158485,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 15:57:09','',''),(2158516,'1','145','826',359,'Retail Sale Id 1277305',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 15:58:59','',''),(2158517,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:58:59','',''),(2158541,'1','145','826',359,'Retail Sale Id 1277318',2898.00,0.00,0.00,0.00,504.00,'2021-12-04 15:59:56','',''),(2158542,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-04 15:59:56','',''),(2158563,'1','145','826',359,'Retail Sale Id 1277329',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 16:00:50','',''),(2158564,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:00:50','',''),(2158579,'1','145','826',359,'Retail Sale Id 1277337',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 16:01:36','',''),(2158580,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 16:01:36','',''),(2158604,'1','145','826',359,'Retail Sale Id 1277345',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 16:02:27','',''),(2158605,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:02:27','',''),(2158618,'1','145','826',359,'Retail Sale Id 1277354',7590.00,0.00,0.00,0.00,1320.00,'2021-12-04 16:04:00','',''),(2158619,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-04 16:04:00','',''),(2158644,'1','145','826',359,'Retail Sale Id 1277368',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 16:05:33','',''),(2158645,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:05:33','',''),(2158684,'1','145','826',359,'Retail Sale Id 1277387',2001.00,0.00,0.00,0.00,348.00,'2021-12-04 16:07:34','',''),(2158685,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 16:07:34','',''),(2158714,'1','145','826',359,'Retail Sale Id 1277406',2070.00,0.00,0.00,0.00,360.00,'2021-12-04 16:08:42','',''),(2158715,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:08:42','',''),(2158767,'1','145','826',359,'Retail Sale Id 1277432',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 16:11:01','',''),(2158768,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:11:01','',''),(2158781,'1','145','826',359,'Retail Sale Id 1277441',1380.00,0.00,0.00,0.00,240.00,'2021-12-04 16:11:54','',''),(2158782,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 16:11:54','',''),(2158929,'1','145','826',359,'Retail Sale Id 1277520',8625.00,0.00,0.00,0.00,1500.00,'2021-12-04 16:18:33','',''),(2158930,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:18:33','',''),(2158971,'1','145','826',359,'Retail Sale Id 1277541',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 16:20:51','',''),(2158972,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:20:51','',''),(2159025,'1','145','826',359,'Retail Sale Id 1277565',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 16:23:07','',''),(2159026,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:23:07','',''),(2159075,'1','145','826',359,'Retail Sale Id 1277596',4899.00,0.00,0.00,0.00,852.00,'2021-12-04 16:25:08','',''),(2159076,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-04 16:25:08','',''),(2159137,'1','145','826',359,'Retail Sale Id 1277629',4830.00,0.00,0.00,0.00,840.00,'2021-12-04 16:27:46','',''),(2159138,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 16:27:46','',''),(2159163,'1','145','826',359,'Retail Sale Id 1277643',2001.00,0.00,0.00,0.00,348.00,'2021-12-04 16:28:33','',''),(2159164,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 16:28:33','',''),(2159273,'1','145','826',359,'Retail Sale Id 1277694',1380.00,0.00,0.00,0.00,240.00,'2021-12-04 16:34:40','',''),(2159274,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 16:34:40','',''),(2159315,'1','145','826',359,'Retail Sale Id 1277721',2001.00,0.00,0.00,0.00,348.00,'2021-12-04 16:37:11','',''),(2159316,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 16:37:11','',''),(2159339,'1','145','826',359,'Retail Sale Id 1277729',6900.00,0.00,0.00,0.00,1200.00,'2021-12-04 16:37:58','',''),(2159340,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 16:37:58','',''),(2159362,'1','145','826',359,'Retail Sale Id 1277740',5520.00,0.00,0.00,0.00,960.00,'2021-12-04 16:38:46','',''),(2159363,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 16:38:46','',''),(2159421,'1','145','826',359,'Retail Sale Id 1277749',3450.00,0.00,0.00,0.00,600.00,'2021-12-04 16:40:02','',''),(2159422,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:40:02','',''),(2159459,'1','145','826',359,'Retail Sale Id 1277768',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 16:41:19','',''),(2159460,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 16:41:19','',''),(2159489,'1','145','826',359,'Retail Sale Id 1277806',8280.00,0.00,0.00,0.00,1440.00,'2021-12-04 16:44:13','',''),(2159490,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 16:44:13','',''),(2159519,'1','145','826',359,'Retail Sale Id 1277839',2001.00,0.00,0.00,0.00,348.00,'2021-12-04 16:45:08','',''),(2159520,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 16:45:08','',''),(2159527,'1','145','826',359,'Retail Sale Id 1277847',2760.00,0.00,0.00,0.00,480.00,'2021-12-04 16:45:49','',''),(2159528,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 16:45:49','',''),(2159702,'1','145','826',359,'Retail Sale Id 1277924',199134.00,0.00,0.00,0.00,34632.00,'2021-12-04 16:53:53','',''),(2159703,'1','145','826',359,'Retail sales',0.00,0.00,0.00,288.60,0.00,'2021-12-04 16:53:53','',''),(2159716,'1','145','826',359,'Retail Sale Id 1277932',218725.00,0.00,0.00,0.00,26920.00,'2021-12-04 16:54:44','',''),(2159717,'1','145','826',359,'Retail sales',0.00,0.00,0.00,336.50,0.00,'2021-12-04 16:54:44','',''),(2165977,'1','145','826',359,'Retail Sale Id 1280746',1380.00,0.00,0.00,0.00,240.00,'2021-12-05 09:52:39','',''),(2165978,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 09:52:39','',''),(2166013,'1','145','826',359,'Retail Sale Id 1280762',3450.00,0.00,0.00,0.00,600.00,'2021-12-05 09:54:27','',''),(2166014,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 09:54:27','',''),(2166087,'1','145','826',359,'Retail Sale Id 1280802',3450.00,0.00,0.00,0.00,600.00,'2021-12-05 09:58:53','',''),(2166088,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 09:58:53','',''),(2166148,'1','145','826',359,'Retail Sale Id 1280831',39000.00,0.00,0.00,0.00,4800.00,'2021-12-05 10:02:32','',''),(2166149,'1','145','826',359,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-05 10:02:32','',''),(2166243,'1','145','826',359,'Retail Sale Id 1280883',8970.00,0.00,0.00,0.00,1560.00,'2021-12-05 10:09:07','',''),(2166244,'1','145','826',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-05 10:09:07','',''),(2166287,'1','145','826',359,'Retail Sale Id 1280906',1380.00,0.00,0.00,0.00,240.00,'2021-12-05 10:12:15','',''),(2166288,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 10:12:15','',''),(2166383,'1','145','826',359,'Retail Sale Id 1280955',2001.00,0.00,0.00,0.00,348.00,'2021-12-05 10:18:12','',''),(2166384,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-05 10:18:12','',''),(2166445,'1','145','826',359,'Retail Sale Id 1280988',690.00,0.00,0.00,0.00,120.00,'2021-12-05 10:22:28','',''),(2166446,'1','145','826',359,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-05 10:22:28','',''),(2166489,'1','145','826',359,'Return of Retail Sale Id 1280988',0.00,690.00,1.00,0.00,-120.00,'2021-12-05 10:25:17','',''),(2166508,'1','145','826',359,'Retail Sale Id 1281017',65000.00,0.00,0.00,0.00,8000.00,'2021-12-05 10:26:33','',''),(2166509,'1','145','826',359,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-05 10:26:33','',''),(2166560,'1','145','826',359,'Retail Sale Id 1281045',8487.00,0.00,0.00,0.00,1476.00,'2021-12-05 10:29:30','',''),(2166561,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.30,0.00,'2021-12-05 10:29:30','',''),(2166586,'1','145','826',359,'Retail Sale Id 1281057',1380.00,0.00,0.00,0.00,240.00,'2021-12-05 10:31:10','',''),(2166587,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 10:31:10','',''),(2166604,'1','145','826',359,'Retail Sale Id 1281069',1449.00,0.00,0.00,0.00,252.00,'2021-12-05 10:32:13','',''),(2166605,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-05 10:32:13','',''),(2166618,'1','145','826',359,'Retail Sale Id 1281076',2760.00,0.00,0.00,0.00,480.00,'2021-12-05 10:33:32','',''),(2166619,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 10:33:32','',''),(2166656,'1','145','826',359,'Retail Sale Id 1281093',4830.00,0.00,0.00,0.00,840.00,'2021-12-05 10:35:32','',''),(2166657,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 10:35:32','',''),(2166710,'1','145','826',359,'Retail Sale Id 1281123',17250.00,0.00,0.00,0.00,3000.00,'2021-12-05 10:38:38','',''),(2166711,'1','145','826',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 10:38:38','',''),(2166738,'1','145','826',359,'Retail Sale Id 1281140',1380.00,0.00,0.00,0.00,240.00,'2021-12-05 10:40:30','',''),(2166739,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 10:40:30','',''),(2166772,'1','145','826',359,'Retail Sale Id 1281154',4830.00,0.00,0.00,0.00,840.00,'2021-12-05 10:42:52','',''),(2166773,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 10:42:52','',''),(2167047,'1','145','826',359,'Retail Sale Id 1281303',4140.00,0.00,0.00,0.00,720.00,'2021-12-05 10:57:46','',''),(2167048,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:57:46','',''),(2167100,'1','145','826',359,'Retail Sale Id 1281322',690.00,0.00,0.00,0.00,120.00,'2021-12-05 11:00:05','',''),(2167101,'1','145','826',359,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-05 11:00:05','',''),(2167122,'1','145','826',359,'Retail Sale Id 1281334',2070.00,0.00,0.00,0.00,360.00,'2021-12-05 11:01:15','',''),(2167125,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 11:01:15','',''),(2167196,'1','145','826',359,'Retail Sale Id 1281371',12765.00,0.00,0.00,0.00,2220.00,'2021-12-05 11:06:22','',''),(2167197,'1','145','826',359,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-05 11:06:22','',''),(2167240,'1','145','826',359,'Retail Sale Id 1281410',8625.00,0.00,0.00,0.00,1500.00,'2021-12-05 11:08:57','',''),(2167241,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:08:57','',''),(2167278,'1','145','826',359,'Retail Sale Id 1281432',8625.00,0.00,0.00,0.00,1500.00,'2021-12-05 11:10:43','',''),(2167279,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:10:43','',''),(2167320,'1','145','826',359,'Retail Sale Id 1281454',8625.00,0.00,0.00,0.00,1500.00,'2021-12-05 11:13:45','',''),(2167321,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:13:45','',''),(2167350,'1','145','826',359,'Retail Sale Id 1281470',1380.00,0.00,0.00,0.00,240.00,'2021-12-05 11:15:40','',''),(2167351,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 11:15:40','',''),(2167504,'1','145','826',359,'Retail Sale Id 1281536',4140.00,0.00,0.00,0.00,720.00,'2021-12-05 11:24:48','',''),(2167505,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:24:48','',''),(2167605,'1','145','826',359,'Retail Sale Id 1281579',7590.00,0.00,0.00,0.00,1320.00,'2021-12-05 11:29:38','',''),(2167606,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-05 11:29:38','',''),(2167653,'1','145','826',359,'Retail Sale Id 1281607',4140.00,0.00,0.00,0.00,720.00,'2021-12-05 11:32:03','',''),(2167654,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:32:03','',''),(2167697,'1','145','826',359,'Retail Sale Id 1281629',4830.00,0.00,0.00,0.00,840.00,'2021-12-05 11:34:00','',''),(2167698,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 11:34:00','',''),(2167717,'1','145','826',359,'Retail Sale Id 1281638',2070.00,0.00,0.00,0.00,360.00,'2021-12-05 11:35:43','',''),(2167718,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 11:35:43','',''),(2167747,'1','145','826',359,'Retail Sale Id 1281652',1380.00,0.00,0.00,0.00,240.00,'2021-12-05 11:37:24','',''),(2167748,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 11:37:24','',''),(2167775,'1','145','826',359,'Retail Sale Id 1281667',1380.00,0.00,0.00,0.00,240.00,'2021-12-05 11:39:09','',''),(2167776,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 11:39:10','',''),(2168246,'1','145','826',359,'Retail Sale Id 1281965',3450.00,0.00,0.00,0.00,600.00,'2021-12-05 12:06:58','',''),(2168247,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:06:58','',''),(2168299,'1','145','826',359,'Retail Sale Id 1281986',113295.00,0.00,0.00,0.00,13944.00,'2021-12-05 12:09:34','',''),(2168300,'1','145','826',359,'Retail sales',0.00,0.00,0.00,174.30,0.00,'2021-12-05 12:09:34','',''),(2168322,'1','145','826',359,'Retail Sale Id 1282004',1380.00,0.00,0.00,0.00,240.00,'2021-12-05 12:10:56','',''),(2168323,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 12:10:56','',''),(2168403,'1','145','826',359,'Retail Sale Id 1282038',8625.00,0.00,0.00,0.00,1500.00,'2021-12-05 12:14:17','',''),(2168404,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:14:17','',''),(2168478,'1','145','826',359,'Retail Sale Id 1282073',8625.00,0.00,0.00,0.00,1500.00,'2021-12-05 12:17:08','',''),(2168479,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:17:08','',''),(2168528,'1','145','826',359,'Retail Sale Id 1282103',3450.00,0.00,0.00,0.00,600.00,'2021-12-05 12:19:17','',''),(2168529,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:19:17','',''),(2168670,'1','145','826',359,'Retail Sale Id 1282152',1380.00,0.00,0.00,0.00,240.00,'2021-12-05 12:24:47','',''),(2168671,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 12:24:47','',''),(2168684,'1','145','826',359,'Retail Sale Id 1282175',2070.00,0.00,0.00,0.00,360.00,'2021-12-05 12:25:38','',''),(2168685,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:25:38','',''),(2168794,'1','145','826',359,'Retail Sale Id 1282238',8125.00,0.00,0.00,0.00,1000.00,'2021-12-05 12:30:22','',''),(2168795,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:30:22','',''),(2168824,'1','145','826',359,'Retail Sale Id 1282255',3450.00,0.00,0.00,0.00,600.00,'2021-12-05 12:32:02','',''),(2168825,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:32:02','',''),(2168858,'1','145','826',359,'Retail Sale Id 1282269',2967.00,0.00,0.00,0.00,516.00,'2021-12-05 12:33:43','',''),(2168859,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.30,0.00,'2021-12-05 12:33:43','',''),(2168892,'1','145','826',359,'Retail Sale Id 1282284',2070.00,0.00,0.00,0.00,360.00,'2021-12-05 12:35:22','',''),(2168893,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:35:22','',''),(2168929,'1','145','826',359,'Retail Sale Id 1282301',32500.00,0.00,0.00,0.00,4000.00,'2021-12-05 12:37:46','',''),(2168930,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 12:37:46','',''),(2169059,'1','145','826',359,'Retail Sale Id 1282375',3450.00,0.00,0.00,0.00,600.00,'2021-12-05 12:44:18','',''),(2169060,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:44:18','',''),(2169181,'1','145','826',359,'Retail Sale Id 1282440',6900.00,0.00,0.00,0.00,1200.00,'2021-12-05 12:52:40','',''),(2169182,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 12:52:40','',''),(2169201,'1','145','826',359,'Retail Sale Id 1282465',4140.00,0.00,0.00,0.00,720.00,'2021-12-05 12:53:56','',''),(2169202,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:53:56','',''),(2169233,'1','145','826',359,'Retail Sale Id 1282484',3450.00,0.00,0.00,0.00,600.00,'2021-12-05 12:55:20','',''),(2169234,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:55:20','',''),(2169281,'1','145','826',359,'Retail Sale Id 1282505',4830.00,0.00,0.00,0.00,840.00,'2021-12-05 12:57:26','',''),(2169282,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 12:57:26','',''),(2169349,'1','145','826',359,'Retail Sale Id 1282534',8280.00,0.00,0.00,0.00,1440.00,'2021-12-05 13:01:05','',''),(2169350,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-05 13:01:05','',''),(2169475,'1','145','826',359,'Retail Sale Id 1282625',2760.00,0.00,0.00,0.00,480.00,'2021-12-05 13:07:49','',''),(2169476,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 13:07:49','',''),(2169556,'1','145','826',359,'Retail Sale Id 1282662',4830.00,0.00,0.00,0.00,840.00,'2021-12-05 13:12:01','',''),(2169557,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 13:12:01','',''),(2169658,'1','145','826',359,'Retail Sale Id 1282708',966.00,0.00,0.00,0.00,168.00,'2021-12-05 13:18:12','',''),(2169659,'1','145','826',359,'Retail sales',0.00,0.00,0.00,1.40,0.00,'2021-12-05 13:18:12','',''),(2169698,'1','145','826',359,'Retail Sale Id 1282731',8970.00,0.00,0.00,0.00,1560.00,'2021-12-05 13:21:02','',''),(2169699,'1','145','826',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-05 13:21:02','',''),(2169732,'1','145','826',359,'Retail Sale Id 1282751',4830.00,0.00,0.00,0.00,840.00,'2021-12-05 13:23:08','',''),(2169733,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 13:23:08','',''),(2169768,'1','145','826',359,'Retail Sale Id 1282771',8625.00,0.00,0.00,0.00,1500.00,'2021-12-05 13:25:17','',''),(2169769,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:25:17','',''),(2169817,'1','145','826',359,'Retail Sale Id 1282796',4830.00,0.00,0.00,0.00,840.00,'2021-12-05 13:28:04','',''),(2169818,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 13:28:04','',''),(2169889,'1','145','826',359,'Retail Sale Id 1282828',44980.00,0.00,0.00,0.00,5536.00,'2021-12-05 13:31:44','',''),(2169890,'1','145','826',359,'Retail sales',0.00,0.00,0.00,69.20,0.00,'2021-12-05 13:31:44','',''),(2169933,'1','145','826',359,'Retail Sale Id 1282846',3450.00,0.00,0.00,0.00,600.00,'2021-12-05 13:33:57','',''),(2169934,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 13:33:57','',''),(2169983,'1','145','826',359,'Retail Sale Id 1282866',2760.00,0.00,0.00,0.00,480.00,'2021-12-05 13:35:55','',''),(2169984,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 13:35:55','',''),(2170011,'1','145','826',359,'Retail Sale Id 1282881',4140.00,0.00,0.00,0.00,720.00,'2021-12-05 13:37:29','',''),(2170012,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 13:37:29','',''),(2170031,'1','145','826',359,'Retail Sale Id 1282888',4830.00,0.00,0.00,0.00,840.00,'2021-12-05 13:38:47','',''),(2170032,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 13:38:47','',''),(2170081,'1','145','826',359,'Retail Sale Id 1282904',20700.00,0.00,0.00,0.00,3600.00,'2021-12-05 13:41:12','',''),(2170082,'1','145','826',359,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-05 13:41:12','',''),(2170131,'1','145','826',359,'Retail Sale Id 1282916',2070.00,0.00,0.00,0.00,360.00,'2021-12-05 13:42:45','',''),(2170132,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 13:42:45','',''),(2170155,'1','145','826',359,'Retail Sale Id 1282923',8280.00,0.00,0.00,0.00,1440.00,'2021-12-05 13:43:45','',''),(2170156,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-05 13:43:45','',''),(2170227,'1','145','826',359,'Retail Sale Id 1282955',8280.00,0.00,0.00,0.00,1440.00,'2021-12-05 13:47:48','',''),(2170228,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-05 13:47:48','',''),(2170251,'1','145','826',359,'Retail Sale Id 1282969',966.00,0.00,0.00,0.00,168.00,'2021-12-05 13:49:46','',''),(2170252,'1','145','826',359,'Retail sales',0.00,0.00,0.00,1.40,0.00,'2021-12-05 13:49:46','',''),(2170322,'1','145','826',359,'Retail Sale Id 1282992',32500.00,0.00,0.00,0.00,4000.00,'2021-12-05 13:52:42','',''),(2170323,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 13:52:42','',''),(2170362,'1','145','826',359,'Retail Sale Id 1283014',4140.00,0.00,0.00,0.00,720.00,'2021-12-05 13:55:12','',''),(2170363,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 13:55:12','',''),(2170388,'1','145','826',359,'Retail Sale Id 1283024',8625.00,0.00,0.00,0.00,1500.00,'2021-12-05 13:56:43','',''),(2170389,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:56:43','',''),(2170443,'1','145','826',359,'Retail Sale Id 1283045',2070.00,0.00,0.00,0.00,360.00,'2021-12-05 13:58:40','',''),(2170444,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 13:58:40','',''),(2170473,'1','145','826',359,'Retail Sale Id 1283056',2070.00,0.00,0.00,0.00,360.00,'2021-12-05 14:00:38','',''),(2170474,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:00:38','',''),(2170499,'1','145','826',359,'Retail Sale Id 1283068',2070.00,0.00,0.00,0.00,360.00,'2021-12-05 14:02:28','',''),(2170500,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:02:28','',''),(2170529,'1','145','826',359,'Retail Sale Id 1283086',29900.00,0.00,0.00,0.00,3680.00,'2021-12-05 14:04:37','',''),(2170530,'1','145','826',359,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-05 14:04:37','',''),(2170557,'1','145','826',359,'Retail Sale Id 1283100',8625.00,0.00,0.00,0.00,1500.00,'2021-12-05 14:06:36','',''),(2170558,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:06:36','',''),(2170591,'1','145','826',359,'Retail Sale Id 1283120',8625.00,0.00,0.00,0.00,1500.00,'2021-12-05 14:08:48','',''),(2170592,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:08:48','',''),(2170638,'1','145','826',359,'Retail Sale Id 1283139',2760.00,0.00,0.00,0.00,480.00,'2021-12-05 14:11:20','',''),(2170639,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 14:11:20','',''),(2170673,'1','145','826',359,'Retail Sale Id 1283156',3450.00,0.00,0.00,0.00,600.00,'2021-12-05 14:12:56','',''),(2170674,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 14:12:56','',''),(2170713,'1','145','826',359,'Retail Sale Id 1283171',77415.00,0.00,0.00,0.00,9528.00,'2021-12-05 14:14:57','',''),(2170714,'1','145','826',359,'Retail sales',0.00,0.00,0.00,119.10,0.00,'2021-12-05 14:14:57','',''),(2170836,'1','145','826',359,'Retail Sale Id 1283208',4830.00,0.00,0.00,0.00,840.00,'2021-12-05 14:18:46','',''),(2170837,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 14:18:46','',''),(2170879,'1','145','826',359,'Retail Sale Id 1283229',2070.00,0.00,0.00,0.00,360.00,'2021-12-05 14:21:19','',''),(2170880,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:21:19','',''),(2170907,'1','145','826',359,'Retail Sale Id 1283240',2070.00,0.00,0.00,0.00,360.00,'2021-12-05 14:23:30','',''),(2170908,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:23:30','',''),(2170923,'1','145','826',359,'Retail Sale Id 1283250',8625.00,0.00,0.00,0.00,1500.00,'2021-12-05 14:24:28','',''),(2170924,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:24:28','',''),(2170969,'1','145','826',359,'Retail Sale Id 1283274',4830.00,0.00,0.00,0.00,840.00,'2021-12-05 14:27:33','',''),(2170970,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 14:27:33','',''),(2170971,'1','145','826',359,'Retail Sale Id 1283276',10350.00,0.00,0.00,0.00,1800.00,'2021-12-05 14:28:04','',''),(2170972,'1','145','826',359,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-05 14:28:04','',''),(2171007,'1','145','826',359,'Retail Sale Id 1283292',4830.00,0.00,0.00,0.00,840.00,'2021-12-05 14:29:52','',''),(2171008,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 14:29:52','',''),(2171033,'1','145','826',359,'Retail Sale Id 1283301',1380.00,0.00,0.00,0.00,240.00,'2021-12-05 14:30:45','',''),(2171034,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 14:30:45','',''),(2171058,'1','145','826',359,'Retail Sale Id 1283307',48300.00,0.00,0.00,0.00,8400.00,'2021-12-05 14:31:37','',''),(2171059,'1','145','826',359,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-05 14:31:37','',''),(2171156,'1','145','826',359,'Retail Sale Id 1283331',4830.00,0.00,0.00,0.00,840.00,'2021-12-05 14:35:27','',''),(2171157,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 14:35:27','',''),(2171247,'1','145','826',359,'Retail Sale Id 1283366',77220.00,0.00,0.00,0.00,9504.00,'2021-12-05 14:41:03','',''),(2171248,'1','145','826',359,'Retail sales',0.00,0.00,0.00,118.80,0.00,'2021-12-05 14:41:03','',''),(2171314,'1','145','826',359,'Retail Sale Id 1283388',2070.00,0.00,0.00,0.00,360.00,'2021-12-05 14:44:20','',''),(2171315,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:44:20','',''),(2171335,'1','145','826',359,'Retail Sale Id 1283394',1380.00,0.00,0.00,0.00,240.00,'2021-12-05 14:45:06','',''),(2171336,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 14:45:06','',''),(2171353,'1','145','826',359,'Retail Sale Id 1283403',1449.00,0.00,0.00,0.00,252.00,'2021-12-05 14:46:37','',''),(2171354,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-05 14:46:37','',''),(2171393,'1','145','826',359,'Retail Sale Id 1283422',32500.00,0.00,0.00,0.00,4000.00,'2021-12-05 14:49:40','',''),(2171394,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 14:49:40','',''),(2171431,'1','145','826',359,'Retail Sale Id 1283440',6210.00,0.00,0.00,0.00,1080.00,'2021-12-05 14:51:45','',''),(2171432,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-05 14:51:45','',''),(2171485,'1','145','826',359,'Retail Sale Id 1283471',1449.00,0.00,0.00,0.00,252.00,'2021-12-05 14:55:33','',''),(2171486,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-05 14:55:33','',''),(2171501,'1','145','826',359,'Retail Sale Id 1283478',1449.00,0.00,0.00,0.00,252.00,'2021-12-05 14:56:34','',''),(2171502,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-05 14:56:34','',''),(2171511,'1','145','826',359,'Retail Sale Id 1283481',6210.00,0.00,0.00,0.00,1080.00,'2021-12-05 14:57:15','',''),(2171512,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-05 14:57:15','',''),(2171523,'1','145','826',359,'Retail Sale Id 1283490',1380.00,0.00,0.00,0.00,240.00,'2021-12-05 14:58:33','',''),(2171524,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 14:58:33','',''),(2171537,'1','145','826',359,'Retail Sale Id 1283496',1449.00,0.00,0.00,0.00,252.00,'2021-12-05 14:59:13','',''),(2171538,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-05 14:59:13','',''),(2171545,'1','145','826',359,'Retail Sale Id 1283499',2070.00,0.00,0.00,0.00,360.00,'2021-12-05 14:59:58','',''),(2171546,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:59:58','',''),(2171565,'1','145','826',359,'Retail Sale Id 1283509',4140.00,0.00,0.00,0.00,720.00,'2021-12-05 15:02:02','',''),(2171566,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:02:02','',''),(2171581,'1','145','826',359,'Retail Sale Id 1283517',2760.00,0.00,0.00,0.00,480.00,'2021-12-05 15:03:17','',''),(2171582,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 15:03:17','',''),(2171721,'1','145','826',359,'Retail Sale Id 1283592',8625.00,0.00,0.00,0.00,1500.00,'2021-12-05 15:14:38','',''),(2171722,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:14:38','',''),(2171731,'1','145','826',359,'Retail Sale Id 1283600',26000.00,0.00,0.00,0.00,3200.00,'2021-12-05 15:15:47','',''),(2171732,'1','145','826',359,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-05 15:15:47','',''),(2171766,'1','145','826',359,'Retail Sale Id 1283609',2070.00,0.00,0.00,0.00,360.00,'2021-12-05 15:17:50','',''),(2171767,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:17:50','',''),(2171784,'1','145','826',359,'Retail Sale Id 1283617',3450.00,0.00,0.00,0.00,600.00,'2021-12-05 15:18:41','',''),(2171785,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 15:18:41','',''),(2171840,'1','145','826',359,'Retail Sale Id 1283648',2001.00,0.00,0.00,0.00,348.00,'2021-12-05 15:22:51','',''),(2171841,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-05 15:22:51','',''),(2171912,'1','145','826',359,'Retail Sale Id 1283686',2760.00,0.00,0.00,0.00,480.00,'2021-12-05 15:28:30','',''),(2171913,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 15:28:30','',''),(2172030,'1','145','826',359,'Retail Sale Id 1283733',76960.00,0.00,0.00,0.00,9472.00,'2021-12-05 15:33:24','',''),(2172031,'1','145','826',359,'Retail sales',0.00,0.00,0.00,118.40,0.00,'2021-12-05 15:33:24','',''),(2172104,'1','145','826',359,'Retail Sale Id 1283770',4830.00,0.00,0.00,0.00,840.00,'2021-12-05 15:37:49','',''),(2172105,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 15:37:49','',''),(2172123,'1','145','826',359,'Retail Sale Id 1283781',110500.00,0.00,0.00,0.00,13600.00,'2021-12-05 15:38:49','',''),(2172124,'1','145','826',359,'Retail sales',0.00,0.00,0.00,170.00,0.00,'2021-12-05 15:38:49','',''),(2172241,'1','145','826',359,'Retail Sale Id 1283846',8625.00,0.00,0.00,0.00,1500.00,'2021-12-05 15:44:12','',''),(2172242,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:44:12','',''),(2172271,'1','145','826',359,'Retail Sale Id 1283863',2760.00,0.00,0.00,0.00,480.00,'2021-12-05 15:45:21','',''),(2172272,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 15:45:21','',''),(2172279,'1','145','826',359,'Retail Sale Id 1283868',2484.00,0.00,0.00,0.00,432.00,'2021-12-05 15:46:04','',''),(2172280,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.60,0.00,'2021-12-05 15:46:04','',''),(2172558,'1','145','826',359,'Retail Sale Id 1284013',4830.00,0.00,0.00,0.00,840.00,'2021-12-05 16:01:41','',''),(2172559,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 16:01:41','',''),(2172582,'1','145','826',359,'Retail Sale Id 1284024',1449.00,0.00,0.00,0.00,252.00,'2021-12-05 16:03:21','',''),(2172583,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-05 16:03:21','',''),(2172688,'1','145','826',359,'Retail Sale Id 1284082',2001.00,0.00,0.00,0.00,348.00,'2021-12-05 16:09:32','',''),(2172689,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-05 16:09:32','',''),(2172848,'1','145','826',359,'Retail Sale Id 1284167',2070.00,0.00,0.00,0.00,360.00,'2021-12-05 16:20:11','',''),(2172849,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 16:20:11','',''),(2173169,'1','145','826',359,'Retail Sale Id 1284339',100750.00,0.00,0.00,0.00,12400.00,'2021-12-05 16:39:24','',''),(2173170,'1','145','826',359,'Retail sales',0.00,0.00,0.00,155.00,0.00,'2021-12-05 16:39:24','',''),(2173227,'1','145','826',359,'Retail Sale Id 1284367',116127.00,0.00,0.00,0.00,20196.00,'2021-12-05 16:43:08','',''),(2173228,'1','145','826',359,'Retail sales',0.00,0.00,0.00,168.30,0.00,'2021-12-05 16:43:08','',''),(2175105,'1','145','826',359,'Retail Sale Id 1285029',6900.00,0.00,0.00,0.00,1200.00,'2021-12-06 06:42:36','',''),(2175106,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 06:42:36','',''),(2175117,'1','145','826',359,'Retail Sale Id 1285033',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 06:43:49','',''),(2175118,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 06:43:49','',''),(2175129,'1','145','826',359,'Retail Sale Id 1285041',4899.00,0.00,0.00,0.00,852.00,'2021-12-06 06:45:15','',''),(2175130,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-06 06:45:15','',''),(2175145,'1','145','826',359,'Retail Sale Id 1285050',1449.00,0.00,0.00,0.00,252.00,'2021-12-06 06:46:13','',''),(2175146,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-06 06:46:13','',''),(2175163,'1','145','826',359,'Retail Sale Id 1285058',1380.00,0.00,0.00,0.00,240.00,'2021-12-06 06:47:12','',''),(2175164,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 06:47:12','',''),(2175173,'1','145','826',359,'Retail Sale Id 1285064',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 06:47:55','',''),(2175174,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 06:47:55','',''),(2175223,'1','145','826',359,'Retail Sale Id 1285091',31200.00,0.00,0.00,0.00,3840.00,'2021-12-06 06:52:26','',''),(2175224,'1','145','826',359,'Retail sales',0.00,0.00,0.00,48.00,0.00,'2021-12-06 06:52:26','',''),(2175318,'1','145','826',359,'Retail Sale Id 1285131',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 06:57:45','',''),(2175319,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 06:57:45','',''),(2175332,'1','145','826',359,'Retail Sale Id 1285139',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 06:58:26','',''),(2175333,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 06:58:26','',''),(2175357,'1','145','826',359,'Retail Sale Id 1285149',8004.00,0.00,0.00,0.00,1392.00,'2021-12-06 06:59:45','',''),(2175358,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.60,0.00,'2021-12-06 06:59:45','',''),(2175392,'1','145','826',359,'Retail Sale Id 1285162',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 07:01:44','',''),(2175393,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 07:01:44','',''),(2175425,'1','145','826',359,'Retail Sale Id 1285168',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 07:02:51','',''),(2175426,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 07:02:51','',''),(2175439,'1','145','826',359,'Retail Sale Id 1285174',4002.00,0.00,0.00,0.00,696.00,'2021-12-06 07:03:28','',''),(2175440,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-06 07:03:28','',''),(2175459,'1','145','826',359,'Retail Sale Id 1285182',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 07:04:25','',''),(2175460,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:04:25','',''),(2175477,'1','145','826',359,'Retail Sale Id 1285192',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 07:06:02','',''),(2175478,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:06:02','',''),(2175501,'1','145','826',359,'Retail Sale Id 1285203',2760.00,0.00,0.00,0.00,480.00,'2021-12-06 07:08:37','',''),(2175502,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 07:08:37','',''),(2175515,'1','145','826',359,'Retail Sale Id 1285210',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 07:10:09','',''),(2175516,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 07:10:09','',''),(2175529,'1','145','826',359,'Retail Sale Id 1285217',4899.00,0.00,0.00,0.00,852.00,'2021-12-06 07:12:00','',''),(2175530,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-06 07:12:00','',''),(2175547,'1','145','826',359,'Retail Sale Id 1285224',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 07:13:02','',''),(2175548,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 07:13:02','',''),(2175557,'1','145','826',359,'Retail Sale Id 1285229',2760.00,0.00,0.00,0.00,480.00,'2021-12-06 07:13:41','',''),(2175558,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 07:13:41','',''),(2175602,'1','145','826',359,'Retail Sale Id 1285256',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 07:16:09','',''),(2175603,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:16:09','',''),(2175628,'1','145','826',359,'Retail Sale Id 1285269',2691.00,0.00,0.00,0.00,468.00,'2021-12-06 07:17:15','',''),(2175629,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.90,0.00,'2021-12-06 07:17:15','',''),(2175650,'1','145','826',359,'Retail Sale Id 1285281',4899.00,0.00,0.00,0.00,852.00,'2021-12-06 07:18:20','',''),(2175651,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-06 07:18:20','',''),(2175662,'1','145','826',359,'Retail Sale Id 1285287',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 07:19:43','',''),(2175663,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 07:19:43','',''),(2175682,'1','145','826',359,'Retail Sale Id 1285301',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 07:20:51','',''),(2175683,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 07:20:51','',''),(2175708,'1','145','826',359,'Retail Sale Id 1285316',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 07:22:18','',''),(2175709,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:22:18','',''),(2175730,'1','145','826',359,'Retail Sale Id 1285324',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 07:23:23','',''),(2175731,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:23:23','',''),(2175752,'1','145','826',359,'Retail Sale Id 1285334',4830.00,0.00,0.00,0.00,840.00,'2021-12-06 07:24:38','',''),(2175753,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 07:24:38','',''),(2175772,'1','145','826',359,'Retail Sale Id 1285346',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 07:25:37','',''),(2175773,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:25:37','',''),(2175824,'1','145','826',359,'Retail Sale Id 1285371',8970.00,0.00,0.00,0.00,1560.00,'2021-12-06 07:28:49','',''),(2175825,'1','145','826',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-06 07:28:49','',''),(2175842,'1','145','826',359,'Retail Sale Id 1285378',3795.00,0.00,0.00,0.00,660.00,'2021-12-06 07:30:34','',''),(2175843,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-06 07:30:34','',''),(2175897,'1','145','826',359,'Retail Sale Id 1285404',4899.00,0.00,0.00,0.00,852.00,'2021-12-06 07:33:28','',''),(2175898,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-06 07:33:28','',''),(2175915,'1','145','826',359,'Retail Sale Id 1285412',7590.00,0.00,0.00,0.00,1320.00,'2021-12-06 07:34:20','',''),(2175916,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-06 07:34:20','',''),(2175955,'1','145','826',359,'Retail Sale Id 1285436',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 07:37:03','',''),(2175956,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 07:37:03','',''),(2175967,'1','145','826',359,'Retail Sale Id 1285421',38610.00,0.00,0.00,0.00,4752.00,'2021-12-06 07:37:25','',''),(2175968,'1','145','826',359,'Retail sales',0.00,0.00,0.00,59.40,0.00,'2021-12-06 07:37:25','',''),(2175977,'1','145','826',359,'Retail Sale Id 1285447',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 07:38:17','',''),(2175978,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:38:17','',''),(2176003,'1','145','826',359,'Retail Sale Id 1285461',4830.00,0.00,0.00,0.00,840.00,'2021-12-06 07:39:50','',''),(2176004,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 07:39:50','',''),(2176021,'1','145','826',359,'Retail Sale Id 1285467',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 07:40:35','',''),(2176022,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 07:40:35','',''),(2176053,'1','145','826',359,'Retail Sale Id 1285479',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 07:41:41','',''),(2176054,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:41:41','',''),(2176076,'1','145','826',359,'Retail Sale Id 1285489',8280.00,0.00,0.00,0.00,1440.00,'2021-12-06 07:42:13','',''),(2176077,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-06 07:42:13','',''),(2176101,'1','145','826',359,'Retail Sale Id 1285503',55900.00,0.00,0.00,0.00,6880.00,'2021-12-06 07:43:54','',''),(2176102,'1','145','826',359,'Retail sales',0.00,0.00,0.00,86.00,0.00,'2021-12-06 07:43:54','',''),(2176111,'1','145','826',359,'Retail Sale Id 1285510',8450.00,0.00,0.00,0.00,1040.00,'2021-12-06 07:44:34','',''),(2176112,'1','145','826',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-06 07:44:34','',''),(2176160,'1','145','826',359,'Retail Sale Id 1285539',46800.00,0.00,0.00,0.00,5760.00,'2021-12-06 07:46:32','',''),(2176161,'1','145','826',359,'Retail sales',0.00,0.00,0.00,72.00,0.00,'2021-12-06 07:46:32','',''),(2176221,'1','145','826',359,'Retail Sale Id 1285563',1725.00,0.00,0.00,0.00,300.00,'2021-12-06 07:48:52','',''),(2176222,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 07:48:52','',''),(2176241,'1','145','826',359,'Retail Sale Id 1285571',7590.00,0.00,0.00,0.00,1320.00,'2021-12-06 07:50:05','',''),(2176242,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-06 07:50:05','',''),(2176276,'1','145','826',359,'Retail Sale Id 1285589',1380.00,0.00,0.00,0.00,240.00,'2021-12-06 07:51:35','',''),(2176277,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 07:51:35','',''),(2176296,'1','145','826',359,'Retail Sale Id 1285595',1380.00,0.00,0.00,0.00,240.00,'2021-12-06 07:52:25','',''),(2176297,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 07:52:25','',''),(2176333,'1','145','826',359,'Retail Sale Id 1285601',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 07:52:56','',''),(2176334,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 07:52:56','',''),(2176349,'1','145','826',359,'Retail Sale Id 1285611',26000.00,0.00,0.00,0.00,3200.00,'2021-12-06 07:54:06','',''),(2176350,'1','145','826',359,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-06 07:54:06','',''),(2176371,'1','145','826',359,'Retail Sale Id 1285617',32500.00,0.00,0.00,0.00,4000.00,'2021-12-06 07:55:03','',''),(2176372,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 07:55:03','',''),(2176397,'1','145','826',359,'Retail Sale Id 1285634',75400.00,0.00,0.00,0.00,9280.00,'2021-12-06 07:56:10','',''),(2176398,'1','145','826',359,'Retail sales',0.00,0.00,0.00,116.00,0.00,'2021-12-06 07:56:10','',''),(2176463,'1','145','826',359,'Retail Sale Id 1285660',5520.00,0.00,0.00,0.00,960.00,'2021-12-06 07:59:06','',''),(2176464,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-06 07:59:06','',''),(2176485,'1','145','826',359,'Retail Sale Id 1285677',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 08:00:34','',''),(2176486,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 08:00:34','',''),(2176505,'1','145','826',359,'Retail Sale Id 1285690',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 08:01:50','',''),(2176506,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 08:01:50','',''),(2176517,'1','145','826',359,'Retail Sale Id 1285700',65000.00,0.00,0.00,0.00,8000.00,'2021-12-06 08:02:37','',''),(2176518,'1','145','826',359,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 08:02:37','',''),(2176547,'1','145','826',359,'Retail Sale Id 1285719',2001.00,0.00,0.00,0.00,348.00,'2021-12-06 08:04:12','',''),(2176548,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 08:04:12','',''),(2176562,'1','145','826',359,'Retail Sale Id 1285728',1380.00,0.00,0.00,0.00,240.00,'2021-12-06 08:05:32','',''),(2176563,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 08:05:32','',''),(2176590,'1','145','826',359,'Retail Sale Id 1285739',1380.00,0.00,0.00,0.00,240.00,'2021-12-06 08:06:17','',''),(2176591,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 08:06:17','',''),(2176606,'1','145','826',359,'Retail Sale Id 1285749',19500.00,0.00,0.00,0.00,2400.00,'2021-12-06 08:07:10','',''),(2176607,'1','145','826',359,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-06 08:07:10','',''),(2176700,'1','145','826',359,'Retail Sale Id 1285792',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 08:13:00','',''),(2176701,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 08:13:00','',''),(2176718,'1','145','826',359,'Retail Sale Id 1285802',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 08:14:23','',''),(2176719,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 08:14:23','',''),(2176750,'1','145','826',359,'Retail Sale Id 1285821',6210.00,0.00,0.00,0.00,1080.00,'2021-12-06 08:16:25','',''),(2176751,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-06 08:16:25','',''),(2176768,'1','145','826',359,'Retail Sale Id 1285829',8280.00,0.00,0.00,0.00,1440.00,'2021-12-06 08:18:17','',''),(2176769,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-06 08:18:17','',''),(2176790,'1','145','826',359,'Retail Sale Id 1285840',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 08:19:37','',''),(2176791,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:19:37','',''),(2176820,'1','145','826',359,'Retail Sale Id 1285828',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 08:22:55','',''),(2176821,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:22:55','',''),(2176861,'1','145','826',359,'Retail Sale Id 1285881',1449.00,0.00,0.00,0.00,252.00,'2021-12-06 08:26:54','',''),(2176862,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-06 08:26:54','',''),(2176883,'1','145','826',359,'Retail Sale Id 1285893',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 08:29:37','',''),(2176884,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:29:37','',''),(2176913,'1','145','826',359,'Retail Sale Id 1285909',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 08:31:35','',''),(2176914,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 08:31:35','',''),(2176919,'1','145','826',359,'Retail Sale Id 1285912',4002.00,0.00,0.00,0.00,696.00,'2021-12-06 08:32:30','',''),(2176920,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-06 08:32:30','',''),(2176955,'1','145','826',359,'Retail Sale Id 1285928',6900.00,0.00,0.00,0.00,1200.00,'2021-12-06 08:34:52','',''),(2176956,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 08:34:52','',''),(2176980,'1','145','826',359,'Retail Sale Id 1285938',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 08:36:41','',''),(2176981,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:36:41','',''),(2177009,'1','145','826',359,'Retail Sale Id 1285949',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 08:38:46','',''),(2177010,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:38:46','',''),(2177029,'1','145','826',359,'Retail Sale Id 1285960',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 08:40:32','',''),(2177030,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:40:32','',''),(2177045,'1','145','826',359,'Retail Sale Id 1285968',1380.00,0.00,0.00,0.00,240.00,'2021-12-06 08:41:51','',''),(2177046,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 08:41:51','',''),(2177072,'1','145','826',359,'Retail Sale Id 1285979',1380.00,0.00,0.00,0.00,240.00,'2021-12-06 08:43:32','',''),(2177073,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 08:43:32','',''),(2177086,'1','145','826',359,'Retail Sale Id 1285986',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 08:44:31','',''),(2177087,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 08:44:31','',''),(2177100,'1','145','826',359,'Retail Sale Id 1285993',1449.00,0.00,0.00,0.00,252.00,'2021-12-06 08:45:28','',''),(2177101,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-06 08:45:28','',''),(2177122,'1','145','826',359,'Retail Sale Id 1286001',8280.00,0.00,0.00,0.00,1440.00,'2021-12-06 08:46:32','',''),(2177123,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-06 08:46:32','',''),(2177140,'1','145','826',359,'Retail Sale Id 1286012',2898.00,0.00,0.00,0.00,504.00,'2021-12-06 08:48:12','',''),(2177141,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-06 08:48:12','',''),(2177151,'1','145','826',359,'Retail Sale Id 1286017',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 08:48:52','',''),(2177152,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 08:48:52','',''),(2177169,'1','145','826',359,'Retail Sale Id 1286027',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 08:50:13','',''),(2177170,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:50:13','',''),(2177189,'1','145','826',359,'Retail Sale Id 1286035',22100.00,0.00,0.00,0.00,2720.00,'2021-12-06 08:52:14','',''),(2177190,'1','145','826',359,'Retail sales',0.00,0.00,0.00,34.00,0.00,'2021-12-06 08:52:14','',''),(2177211,'1','145','826',359,'Retail Sale Id 1286047',5525.00,0.00,0.00,0.00,680.00,'2021-12-06 08:53:53','',''),(2177212,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.50,0.00,'2021-12-06 08:53:53','',''),(2177251,'1','145','826',359,'Retail Sale Id 1286071',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 08:56:26','',''),(2177252,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 08:56:26','',''),(2177282,'1','145','826',359,'Retail Sale Id 1286086',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 08:58:32','',''),(2177283,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 08:58:32','',''),(2177329,'1','145','826',359,'Retail Sale Id 1286105',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 09:02:16','',''),(2177330,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:02:16','',''),(2177339,'1','145','826',359,'Retail Sale Id 1286111',1449.00,0.00,0.00,0.00,252.00,'2021-12-06 09:03:01','',''),(2177340,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-06 09:03:01','',''),(2177381,'1','145','826',359,'Retail Sale Id 1286124',1380.00,0.00,0.00,0.00,240.00,'2021-12-06 09:05:41','',''),(2177382,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 09:05:41','',''),(2177524,'1','145','826',359,'Retail Sale Id 1286193',2760.00,0.00,0.00,0.00,480.00,'2021-12-06 09:15:45','',''),(2177525,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 09:15:45','',''),(2177536,'1','145','826',359,'Retail Sale Id 1286199',2001.00,0.00,0.00,0.00,348.00,'2021-12-06 09:16:21','',''),(2177537,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 09:16:21','',''),(2177578,'1','145','826',359,'Retail Sale Id 1286213',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 09:19:13','',''),(2177579,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:19:13','',''),(2177598,'1','145','826',359,'Retail Sale Id 1286226',2760.00,0.00,0.00,0.00,480.00,'2021-12-06 09:20:32','',''),(2177599,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 09:20:32','',''),(2177616,'1','145','826',359,'Retail Sale Id 1286236',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 09:21:31','',''),(2177617,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 09:21:31','',''),(2177628,'1','145','826',359,'Retail Sale Id 1286243',40300.00,0.00,0.00,0.00,4960.00,'2021-12-06 09:22:34','',''),(2177629,'1','145','826',359,'Retail sales',0.00,0.00,0.00,62.00,0.00,'2021-12-06 09:22:34','',''),(2177644,'1','145','826',359,'Retail Sale Id 1286253',2484.00,0.00,0.00,0.00,432.00,'2021-12-06 09:24:05','',''),(2177645,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.60,0.00,'2021-12-06 09:24:05','',''),(2177660,'1','145','826',359,'Retail Sale Id 1286259',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 09:24:54','',''),(2177661,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 09:24:54','',''),(2177684,'1','145','826',359,'Retail Sale Id 1286268',6900.00,0.00,0.00,0.00,1200.00,'2021-12-06 09:25:50','',''),(2177685,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 09:25:50','',''),(2177719,'1','145','826',359,'Retail Sale Id 1286284',6900.00,0.00,0.00,0.00,1200.00,'2021-12-06 09:27:40','',''),(2177720,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 09:27:40','',''),(2177748,'1','145','826',359,'Retail Sale Id 1286300',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 09:29:34','',''),(2177749,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:29:34','',''),(2177768,'1','145','826',359,'Retail Sale Id 1286311',1380.00,0.00,0.00,0.00,240.00,'2021-12-06 09:30:47','',''),(2177769,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 09:30:47','',''),(2177827,'1','145','826',359,'Retail Sale Id 1286333',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 09:33:43','',''),(2177828,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 09:33:43','',''),(2177869,'1','145','826',359,'Retail Sale Id 1286349',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 09:36:36','',''),(2177870,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 09:36:36','',''),(2177895,'1','145','826',359,'Retail Sale Id 1286356',2001.00,0.00,0.00,0.00,348.00,'2021-12-06 09:37:22','',''),(2177896,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 09:37:22','',''),(2177950,'1','145','826',359,'Retail Sale Id 1286367',2760.00,0.00,0.00,0.00,480.00,'2021-12-06 09:38:55','',''),(2177951,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 09:38:55','',''),(2177958,'1','145','826',359,'Retail Sale Id 1286373',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 09:39:37','',''),(2177959,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 09:39:37','',''),(2178050,'1','145','826',359,'Retail Sale Id 1286417',4485.00,0.00,0.00,0.00,780.00,'2021-12-06 09:45:45','',''),(2178051,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-06 09:45:45','',''),(2178066,'1','145','826',359,'Retail Sale Id 1286424',3835.00,0.00,0.00,0.00,472.00,'2021-12-06 09:46:52','',''),(2178067,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.90,0.00,'2021-12-06 09:46:52','',''),(2178082,'1','145','826',359,'Retail Sale Id 1286433',1380.00,0.00,0.00,0.00,240.00,'2021-12-06 09:47:56','',''),(2178083,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 09:47:56','',''),(2178119,'1','145','826',359,'Retail Sale Id 1286454',2760.00,0.00,0.00,0.00,480.00,'2021-12-06 09:51:00','',''),(2178120,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 09:51:00','',''),(2178133,'1','145','826',359,'Retail Sale Id 1286462',2760.00,0.00,0.00,0.00,480.00,'2021-12-06 09:51:56','',''),(2178134,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 09:51:56','',''),(2178143,'1','145','826',359,'Retail Sale Id 1286467',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 09:52:44','',''),(2178144,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:52:44','',''),(2178161,'1','145','826',359,'Retail Sale Id 1286474',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 09:53:52','',''),(2178162,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 09:53:52','',''),(2178183,'1','145','826',359,'Retail Sale Id 1286486',2760.00,0.00,0.00,0.00,480.00,'2021-12-06 09:54:52','',''),(2178184,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 09:54:52','',''),(2178192,'1','145','826',359,'Retail Sale Id 1286489',4830.00,0.00,0.00,0.00,840.00,'2021-12-06 09:55:24','',''),(2178193,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 09:55:24','',''),(2178202,'1','145','826',359,'Retail Sale Id 1286494',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 09:56:23','',''),(2178203,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:56:23','',''),(2178210,'1','145','826',359,'Retail Sale Id 1286496',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 09:57:25','',''),(2178211,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 09:57:25','',''),(2178218,'1','145','826',359,'Retail Sale Id 1286508',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 09:58:05','',''),(2178219,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:58:05','',''),(2178240,'1','145','826',359,'Retail Sale Id 1286519',32500.00,0.00,0.00,0.00,4000.00,'2021-12-06 10:00:06','',''),(2178241,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 10:00:06','',''),(2178280,'1','145','826',359,'Retail Sale Id 1286536',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 10:01:58','',''),(2178281,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:01:58','',''),(2178290,'1','145','826',359,'Retail Sale Id 1286542',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 10:02:57','',''),(2178291,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 10:02:57','',''),(2178352,'1','145','826',359,'Retail Sale Id 1286564',6900.00,0.00,0.00,0.00,1200.00,'2021-12-06 10:05:34','',''),(2178353,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 10:05:34','',''),(2178372,'1','145','826',359,'Retail Sale Id 1286575',6900.00,0.00,0.00,0.00,1200.00,'2021-12-06 10:06:53','',''),(2178373,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 10:06:53','',''),(2178394,'1','145','826',359,'Retail Sale Id 1286585',4899.00,0.00,0.00,0.00,852.00,'2021-12-06 10:08:07','',''),(2178395,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-06 10:08:07','',''),(2178429,'1','145','826',359,'Retail Sale Id 1286598',1380.00,0.00,0.00,0.00,240.00,'2021-12-06 10:09:11','',''),(2178430,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 10:09:11','',''),(2178551,'1','145','826',359,'Retail Sale Id 1286663',39000.00,0.00,0.00,0.00,4800.00,'2021-12-06 10:17:10','',''),(2178552,'1','145','826',359,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-06 10:17:10','',''),(2178649,'1','145','826',359,'Retail Sale Id 1286716',8970.00,0.00,0.00,0.00,1560.00,'2021-12-06 10:25:19','',''),(2178650,'1','145','826',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-06 10:25:19','',''),(2178683,'1','145','826',359,'Retail Sale Id 1286730',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 10:26:39','',''),(2178684,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 10:26:39','',''),(2178689,'1','145','826',359,'Retail Sale Id 1286731',1380.00,0.00,0.00,0.00,240.00,'2021-12-06 10:27:14','',''),(2178690,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 10:27:14','',''),(2178741,'1','145','826',359,'Retail Sale Id 1286761',7590.00,0.00,0.00,0.00,1320.00,'2021-12-06 10:30:40','',''),(2178742,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-06 10:30:40','',''),(2178820,'1','145','826',359,'Retail Sale Id 1286808',2760.00,0.00,0.00,0.00,480.00,'2021-12-06 10:36:48','',''),(2178821,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 10:36:48','',''),(2178842,'1','145','826',359,'Retail Sale Id 1286822',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 10:37:54','',''),(2178843,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 10:37:54','',''),(2178854,'1','145','826',359,'Retail Sale Id 1286827',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 10:38:41','',''),(2178855,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:38:41','',''),(2178954,'1','145','826',359,'Retail Sale Id 1286879',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 10:45:13','',''),(2178955,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:45:13','',''),(2179187,'1','145','826',359,'Retail Sale Id 1287022',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 10:58:49','',''),(2179188,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 10:58:49','',''),(2179277,'1','145','826',359,'Retail Sale Id 1287071',2001.00,0.00,0.00,0.00,348.00,'2021-12-06 11:04:43','',''),(2179278,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 11:04:43','',''),(2179295,'1','145','826',359,'Retail Sale Id 1287086',1380.00,0.00,0.00,0.00,240.00,'2021-12-06 11:06:00','',''),(2179296,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 11:06:00','',''),(2179323,'1','145','826',359,'Retail Sale Id 1287098',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 11:07:25','',''),(2179324,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:07:25','',''),(2179361,'1','145','826',359,'Retail Sale Id 1287117',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 11:09:54','',''),(2179362,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 11:09:54','',''),(2179437,'1','145','826',359,'Retail Sale Id 1287150',8280.00,0.00,0.00,0.00,1440.00,'2021-12-06 11:14:13','',''),(2179438,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-06 11:14:13','',''),(2179491,'1','145','826',359,'Retail Sale Id 1287180',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 11:17:13','',''),(2179492,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:17:13','',''),(2179533,'1','145','826',359,'Retail Sale Id 1287210',84500.00,0.00,0.00,0.00,10400.00,'2021-12-06 11:19:35','',''),(2179534,'1','145','826',359,'Retail sales',0.00,0.00,0.00,130.00,0.00,'2021-12-06 11:19:35','',''),(2179559,'1','145','826',359,'Retail Sale Id 1287226',2001.00,0.00,0.00,0.00,348.00,'2021-12-06 11:21:39','',''),(2179560,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 11:21:39','',''),(2179591,'1','145','826',359,'Retail Sale Id 1287246',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 11:23:11','',''),(2179592,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 11:23:11','',''),(2179619,'1','145','826',359,'Retail Sale Id 1287257',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 11:25:45','',''),(2179620,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 11:25:45','',''),(2179675,'1','145','826',359,'Retail Sale Id 1287290',2139.00,0.00,0.00,0.00,372.00,'2021-12-06 11:29:51','',''),(2179676,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.10,0.00,'2021-12-06 11:29:51','',''),(2179697,'1','145','826',359,'Retail Sale Id 1287301',1380.00,0.00,0.00,0.00,240.00,'2021-12-06 11:31:28','',''),(2179698,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 11:31:28','',''),(2179790,'1','145','826',359,'Retail Sale Id 1287351',2760.00,0.00,0.00,0.00,480.00,'2021-12-06 11:39:42','',''),(2179791,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 11:39:42','',''),(2179825,'1','145','826',359,'Retail Sale Id 1287367',6900.00,0.00,0.00,0.00,1200.00,'2021-12-06 11:42:28','',''),(2179826,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 11:42:28','',''),(2180050,'1','145','826',359,'Retail Sale Id 1287544',2760.00,0.00,0.00,0.00,480.00,'2021-12-06 11:57:53','',''),(2180051,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 11:57:53','',''),(2180148,'1','145','826',359,'Retail Sale Id 1287593',4899.00,0.00,0.00,0.00,852.00,'2021-12-06 12:04:06','',''),(2180149,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-06 12:04:06','',''),(2180260,'1','145','826',359,'Retail Sale Id 1287650',6900.00,0.00,0.00,0.00,1200.00,'2021-12-06 12:10:30','',''),(2180261,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 12:10:30','',''),(2180308,'1','145','826',359,'Retail Sale Id 1287686',2001.00,0.00,0.00,0.00,348.00,'2021-12-06 12:13:45','',''),(2180309,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 12:13:45','',''),(2180330,'1','145','826',359,'Retail Sale Id 1287700',1449.00,0.00,0.00,0.00,252.00,'2021-12-06 12:14:33','',''),(2180331,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-06 12:14:33','',''),(2180348,'1','145','826',359,'Retail Sale Id 1287707',17250.00,0.00,0.00,0.00,3000.00,'2021-12-06 12:15:43','',''),(2180349,'1','145','826',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 12:15:43','',''),(2180378,'1','145','826',359,'Retail Sale Id 1287726',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 12:17:14','',''),(2180379,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:17:14','',''),(2180452,'1','145','826',359,'Retail Sale Id 1287764',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 12:21:54','',''),(2180453,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:21:54','',''),(2180470,'1','145','826',359,'Retail Sale Id 1287775',2484.00,0.00,0.00,0.00,432.00,'2021-12-06 12:23:37','',''),(2180471,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.60,0.00,'2021-12-06 12:23:37','',''),(2180538,'1','145','826',359,'Retail Sale Id 1287811',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 12:28:16','',''),(2180539,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:28:16','',''),(2180554,'1','145','826',359,'Retail Sale Id 1287822',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 12:29:28','',''),(2180555,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:29:28','',''),(2180604,'1','145','826',359,'Retail Sale Id 1287845',4830.00,0.00,0.00,0.00,840.00,'2021-12-06 12:32:17','',''),(2180605,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 12:32:17','',''),(2180631,'1','145','826',359,'Retail Sale Id 1287857',2898.00,0.00,0.00,0.00,504.00,'2021-12-06 12:33:37','',''),(2180632,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-06 12:33:37','',''),(2180662,'1','145','826',359,'Retail Sale Id 1287873',8970.00,0.00,0.00,0.00,1560.00,'2021-12-06 12:35:28','',''),(2180663,'1','145','826',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-06 12:35:28','',''),(2180683,'1','145','826',359,'Retail Sale Id 1287886',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 12:36:38','',''),(2180684,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:36:38','',''),(2180702,'1','145','826',359,'Retail Sale Id 1287896',2001.00,0.00,0.00,0.00,348.00,'2021-12-06 12:37:25','',''),(2180703,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 12:37:25','',''),(2180708,'1','145','826',359,'Retail Sale Id 1287898',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 12:38:01','',''),(2180709,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:38:01','',''),(2180784,'1','145','826',359,'Retail Sale Id 1287934',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 12:42:58','',''),(2180785,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:42:58','',''),(2180796,'1','145','826',359,'Retail Sale Id 1287941',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 12:44:03','',''),(2180797,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:44:03','',''),(2180870,'1','145','826',359,'Retail Sale Id 1287981',2760.00,0.00,0.00,0.00,480.00,'2021-12-06 12:48:21','',''),(2180871,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 12:48:21','',''),(2180982,'1','145','826',359,'Retail Sale Id 1288039',1380.00,0.00,0.00,0.00,240.00,'2021-12-06 12:55:14','',''),(2180983,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 12:55:14','',''),(2181020,'1','145','826',359,'Retail Sale Id 1288060',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 12:57:36','',''),(2181021,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:57:36','',''),(2181040,'1','145','826',359,'Retail Sale Id 1288073',2760.00,0.00,0.00,0.00,480.00,'2021-12-06 12:58:26','',''),(2181041,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 12:58:26','',''),(2181078,'1','145','826',359,'Retail Sale Id 1288085',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 12:59:56','',''),(2181079,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:59:56','',''),(2181238,'1','145','826',359,'Retail Sale Id 1288166',4830.00,0.00,0.00,0.00,840.00,'2021-12-06 13:09:25','',''),(2181239,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 13:09:25','',''),(2181339,'1','145','826',359,'Retail Sale Id 1288219',7590.00,0.00,0.00,0.00,1320.00,'2021-12-06 13:14:32','',''),(2181340,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-06 13:14:32','',''),(2181352,'1','145','826',359,'Retail Sale Id 1288229',2001.00,0.00,0.00,0.00,348.00,'2021-12-06 13:15:16','',''),(2181353,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 13:15:16','',''),(2181451,'1','145','826',359,'Retail Sale Id 1288261',1449.00,0.00,0.00,0.00,252.00,'2021-12-06 13:19:33','',''),(2181452,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-06 13:19:33','',''),(2181470,'1','145','826',359,'Retail Sale Id 1288270',1449.00,0.00,0.00,0.00,252.00,'2021-12-06 13:20:30','',''),(2181471,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-06 13:20:30','',''),(2181488,'1','145','826',359,'Retail Sale Id 1288275',2001.00,0.00,0.00,0.00,348.00,'2021-12-06 13:21:17','',''),(2181489,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 13:21:17','',''),(2181528,'1','145','826',359,'Retail Sale Id 1288297',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 13:25:11','',''),(2181529,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 13:25:11','',''),(2181546,'1','145','826',359,'Retail Sale Id 1288307',1380.00,0.00,0.00,0.00,240.00,'2021-12-06 13:26:46','',''),(2181547,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 13:26:46','',''),(2181556,'1','145','826',359,'Retail Sale Id 1288313',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 13:27:46','',''),(2181557,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 13:27:46','',''),(2181568,'1','145','826',359,'Retail Sale Id 1288320',2001.00,0.00,0.00,0.00,348.00,'2021-12-06 13:28:38','',''),(2181569,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 13:28:38','',''),(2181580,'1','145','826',359,'Retail Sale Id 1288324',17250.00,0.00,0.00,0.00,3000.00,'2021-12-06 13:29:34','',''),(2181581,'1','145','826',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 13:29:34','',''),(2181622,'1','145','826',359,'Retail Sale Id 1288342',2001.00,0.00,0.00,0.00,348.00,'2021-12-06 13:32:03','',''),(2181623,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 13:32:03','',''),(2181666,'1','145','826',359,'Retail Sale Id 1288353',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 13:34:15','',''),(2181667,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 13:34:15','',''),(2181708,'1','145','826',359,'Retail Sale Id 1288366',8694.00,0.00,0.00,0.00,1512.00,'2021-12-06 13:36:10','',''),(2181709,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.60,0.00,'2021-12-06 13:36:10','',''),(2181762,'1','145','826',359,'Retail Sale Id 1288401',2760.00,0.00,0.00,0.00,480.00,'2021-12-06 13:39:17','',''),(2181763,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 13:39:17','',''),(2181915,'1','145','826',359,'Retail Sale Id 1288464',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 13:45:56','',''),(2181916,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 13:45:56','',''),(2181989,'1','145','826',359,'Retail Sale Id 1288499',8694.00,0.00,0.00,0.00,1512.00,'2021-12-06 13:49:36','',''),(2181990,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.60,0.00,'2021-12-06 13:49:36','',''),(2182063,'1','145','826',359,'Retail Sale Id 1288532',2760.00,0.00,0.00,0.00,480.00,'2021-12-06 13:53:30','',''),(2182064,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 13:53:30','',''),(2182131,'1','145','826',359,'Retail Sale Id 1288571',34500.00,0.00,0.00,0.00,6000.00,'2021-12-06 13:57:02','',''),(2182132,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 13:57:02','',''),(2182177,'1','145','826',359,'Retail Sale Id 1288594',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 13:59:19','',''),(2182178,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 13:59:19','',''),(2182229,'1','145','826',359,'Retail Sale Id 1288607',2001.00,0.00,0.00,0.00,348.00,'2021-12-06 14:00:49','',''),(2182230,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 14:00:49','',''),(2182253,'1','145','826',359,'Retail Sale Id 1288618',8280.00,0.00,0.00,0.00,1440.00,'2021-12-06 14:01:52','',''),(2182254,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-06 14:01:52','',''),(2182287,'1','145','826',359,'Retail Sale Id 1288642',2760.00,0.00,0.00,0.00,480.00,'2021-12-06 14:03:55','',''),(2182288,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 14:03:55','',''),(2182309,'1','145','826',359,'Retail Sale Id 1288650',5520.00,0.00,0.00,0.00,960.00,'2021-12-06 14:05:03','',''),(2182310,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-06 14:05:03','',''),(2182335,'1','145','826',359,'Retail Sale Id 1288661',13000.00,0.00,0.00,0.00,1600.00,'2021-12-06 14:06:15','',''),(2182336,'1','145','826',359,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-06 14:06:15','',''),(2182361,'1','145','826',359,'Retail Sale Id 1288670',6210.00,0.00,0.00,0.00,1080.00,'2021-12-06 14:07:13','',''),(2182362,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-06 14:07:13','',''),(2182383,'1','145','826',359,'Retail Sale Id 1288683',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 14:08:45','',''),(2182384,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:08:45','',''),(2182414,'1','145','826',359,'Retail Sale Id 1288691',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 14:09:40','',''),(2182415,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:09:40','',''),(2182449,'1','145','826',359,'Retail Sale Id 1288706',20150.00,0.00,0.00,0.00,2480.00,'2021-12-06 14:10:53','',''),(2182450,'1','145','826',359,'Retail sales',0.00,0.00,0.00,31.00,0.00,'2021-12-06 14:10:53','',''),(2182501,'1','145','826',359,'Retail Sale Id 1288725',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 14:12:42','',''),(2182502,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:12:42','',''),(2182519,'1','145','826',359,'Retail Sale Id 1288733',2691.00,0.00,0.00,0.00,468.00,'2021-12-06 14:14:06','',''),(2182520,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.90,0.00,'2021-12-06 14:14:06','',''),(2182630,'1','145','826',359,'Retail Sale Id 1288788',6210.00,0.00,0.00,0.00,1080.00,'2021-12-06 14:19:14','',''),(2182632,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-06 14:19:14','',''),(2182656,'1','145','826',359,'Retail Sale Id 1288801',4485.00,0.00,0.00,0.00,780.00,'2021-12-06 14:20:19','',''),(2182657,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-06 14:20:19','',''),(2182666,'1','145','826',359,'Retail Sale Id 1288806',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 14:21:00','',''),(2182667,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:21:00','',''),(2182702,'1','145','826',359,'Retail Sale Id 1288821',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 14:22:52','',''),(2182703,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 14:22:52','',''),(2182730,'1','145','826',359,'Retail Sale Id 1288835',1449.00,0.00,0.00,0.00,252.00,'2021-12-06 14:24:11','',''),(2182731,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-06 14:24:11','',''),(2182746,'1','145','826',359,'Retail Sale Id 1288844',1449.00,0.00,0.00,0.00,252.00,'2021-12-06 14:25:08','',''),(2182747,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-06 14:25:08','',''),(2182758,'1','145','826',359,'Retail Sale Id 1288851',2001.00,0.00,0.00,0.00,348.00,'2021-12-06 14:25:54','',''),(2182759,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 14:25:54','',''),(2182766,'1','145','826',359,'Retail Sale Id 1288856',6900.00,0.00,0.00,0.00,1200.00,'2021-12-06 14:26:30','',''),(2182767,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 14:26:30','',''),(2182790,'1','145','826',359,'Retail Sale Id 1288867',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 14:27:53','',''),(2182791,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:27:53','',''),(2182812,'1','145','826',359,'Retail Sale Id 1288879',2760.00,0.00,0.00,0.00,480.00,'2021-12-06 14:29:14','',''),(2182813,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 14:29:14','',''),(2182820,'1','145','826',359,'Retail Sale Id 1288885',1380.00,0.00,0.00,0.00,240.00,'2021-12-06 14:30:01','',''),(2182821,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 14:30:01','',''),(2182836,'1','145','826',359,'Retail Sale Id 1288892',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 14:30:37','',''),(2182837,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 14:30:37','',''),(2182856,'1','145','826',359,'Retail Sale Id 1288903',2001.00,0.00,0.00,0.00,348.00,'2021-12-06 14:31:55','',''),(2182857,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 14:31:55','',''),(2182928,'1','145','826',359,'Retail Sale Id 1288934',12805.00,0.00,0.00,0.00,1576.00,'2021-12-06 14:35:20','',''),(2182929,'1','145','826',359,'Retail sales',0.00,0.00,0.00,19.70,0.00,'2021-12-06 14:35:20','',''),(2182948,'1','145','826',359,'Retail Sale Id 1288944',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 14:36:41','',''),(2182949,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 14:36:41','',''),(2182964,'1','145','826',359,'Retail Sale Id 1288953',2277.00,0.00,0.00,0.00,396.00,'2021-12-06 14:37:54','',''),(2182965,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.30,0.00,'2021-12-06 14:37:54','',''),(2182974,'1','145','826',359,'Retail Sale Id 1288958',690.00,0.00,0.00,0.00,120.00,'2021-12-06 14:38:25','',''),(2182975,'1','145','826',359,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-06 14:38:25','',''),(2182990,'1','145','826',359,'Retail Sale Id 1288965',6900.00,0.00,0.00,0.00,1200.00,'2021-12-06 14:39:28','',''),(2182991,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 14:39:28','',''),(2183172,'1','145','826',359,'Retail Sale Id 1289034',4830.00,0.00,0.00,0.00,840.00,'2021-12-06 14:47:43','',''),(2183173,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 14:47:43','',''),(2183216,'1','145','826',359,'Retail Sale Id 1289051',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 14:49:34','',''),(2183217,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:49:34','',''),(2183230,'1','145','826',359,'Retail Sale Id 1289058',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 14:50:25','',''),(2183231,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 14:50:25','',''),(2183252,'1','145','826',359,'Retail Sale Id 1289069',4899.00,0.00,0.00,0.00,852.00,'2021-12-06 14:51:18','',''),(2183253,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-06 14:51:18','',''),(2183270,'1','145','826',359,'Retail Sale Id 1289078',5520.00,0.00,0.00,0.00,960.00,'2021-12-06 14:52:03','',''),(2183271,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-06 14:52:03','',''),(2183285,'1','145','826',359,'Retail Sale Id 1289084',6003.00,0.00,0.00,0.00,1044.00,'2021-12-06 14:52:54','',''),(2183286,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.70,0.00,'2021-12-06 14:52:54','',''),(2183317,'1','145','826',359,'Retail Sale Id 1289101',8280.00,0.00,0.00,0.00,1440.00,'2021-12-06 14:54:41','',''),(2183318,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-06 14:54:41','',''),(2183347,'1','145','826',359,'Retail Sale Id 1289113',8280.00,0.00,0.00,0.00,1440.00,'2021-12-06 14:55:44','',''),(2183348,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-06 14:55:44','',''),(2183385,'1','145','826',359,'Retail Sale Id 1289133',4830.00,0.00,0.00,0.00,840.00,'2021-12-06 14:57:51','',''),(2183386,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 14:57:51','',''),(2183455,'1','145','826',359,'Retail Sale Id 1289169',2001.00,0.00,0.00,0.00,348.00,'2021-12-06 15:01:48','',''),(2183456,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 15:01:48','',''),(2183523,'1','145','826',359,'Retail Sale Id 1289202',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 15:05:15','',''),(2183524,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:05:15','',''),(2183535,'1','145','826',359,'Retail Sale Id 1289210',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 15:06:14','',''),(2183536,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:06:14','',''),(2183547,'1','145','826',359,'Retail Sale Id 1289217',4899.00,0.00,0.00,0.00,852.00,'2021-12-06 15:06:50','',''),(2183548,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-06 15:06:50','',''),(2183568,'1','145','826',359,'Retail Sale Id 1289228',2001.00,0.00,0.00,0.00,348.00,'2021-12-06 15:08:16','',''),(2183569,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 15:08:16','',''),(2183590,'1','145','826',359,'Retail Sale Id 1289237',2001.00,0.00,0.00,0.00,348.00,'2021-12-06 15:09:42','',''),(2183591,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 15:09:42','',''),(2183695,'1','145','826',359,'Retail Sale Id 1289277',8280.00,0.00,0.00,0.00,1440.00,'2021-12-06 15:15:02','',''),(2183696,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-06 15:15:02','',''),(2183712,'1','145','826',359,'Retail Sale Id 1289284',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 15:16:13','',''),(2183713,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:16:13','',''),(2183738,'1','145','826',359,'Retail Sale Id 1289299',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 15:17:22','',''),(2183739,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:17:22','',''),(2183835,'1','145','826',359,'Retail Sale Id 1289340',2001.00,0.00,0.00,0.00,348.00,'2021-12-06 15:21:54','',''),(2183836,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 15:21:54','',''),(2183915,'1','145','826',359,'Retail Sale Id 1289376',8280.00,0.00,0.00,0.00,1440.00,'2021-12-06 15:24:36','',''),(2183916,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-06 15:24:36','',''),(2183959,'1','145','826',359,'Retail Sale Id 1289396',2898.00,0.00,0.00,0.00,504.00,'2021-12-06 15:26:30','',''),(2183960,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-06 15:26:30','',''),(2183986,'1','145','826',359,'Retail Sale Id 1289410',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 15:28:16','',''),(2183987,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:28:16','',''),(2184097,'1','145','826',359,'Retail Sale Id 1289468',38025.00,0.00,0.00,0.00,4680.00,'2021-12-06 15:34:39','',''),(2184098,'1','145','826',359,'Retail sales',0.00,0.00,0.00,58.50,0.00,'2021-12-06 15:34:39','',''),(2184177,'1','145','826',359,'Retail Sale Id 1289507',6900.00,0.00,0.00,0.00,1200.00,'2021-12-06 15:38:22','',''),(2184178,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 15:38:22','',''),(2184365,'1','145','826',359,'Retail Sale Id 1289559',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 15:44:00','',''),(2184366,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:44:00','',''),(2184379,'1','145','826',359,'Retail Sale Id 1289567',1449.00,0.00,0.00,0.00,252.00,'2021-12-06 15:44:45','',''),(2184380,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-06 15:44:45','',''),(2184482,'1','145','826',359,'Retail Sale Id 1289603',2898.00,0.00,0.00,0.00,504.00,'2021-12-06 15:49:07','',''),(2184483,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-06 15:49:07','',''),(2184510,'1','145','826',359,'Retail Sale Id 1289617',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 15:50:21','',''),(2184511,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:50:21','',''),(2184538,'1','145','826',359,'Retail Sale Id 1289631',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 15:51:43','',''),(2184539,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:51:43','',''),(2184591,'1','145','826',359,'Retail Sale Id 1289652',1380.00,0.00,0.00,0.00,240.00,'2021-12-06 15:54:33','',''),(2184592,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:54:33','',''),(2184607,'1','145','826',359,'Retail Sale Id 1289664',16900.00,0.00,0.00,0.00,2080.00,'2021-12-06 15:55:39','',''),(2184608,'1','145','826',359,'Retail sales',0.00,0.00,0.00,26.00,0.00,'2021-12-06 15:55:39','',''),(2184626,'1','145','826',359,'Retail Sale Id 1289672',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 15:56:40','',''),(2184627,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:56:40','',''),(2184641,'1','145','826',359,'Return of Retail Sale Id 1289603',0.00,2898.00,4.20,0.00,-504.00,'2021-12-06 15:57:16','',''),(2184659,'1','145','826',359,'Retail Sale Id 1289688',4140.00,0.00,0.00,0.00,720.00,'2021-12-06 15:58:14','',''),(2184660,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:58:14','',''),(2184681,'1','145','826',359,'Retail Sale Id 1289701',8694.00,0.00,0.00,0.00,1512.00,'2021-12-06 15:59:31','',''),(2184682,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.60,0.00,'2021-12-06 15:59:31','',''),(2184689,'1','145','826',359,'Retail Sale Id 1289704',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 16:00:11','',''),(2184690,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 16:00:11','',''),(2184702,'1','145','826',359,'Retail Sale Id 1289710',3450.00,0.00,0.00,0.00,600.00,'2021-12-06 16:00:49','',''),(2184703,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 16:00:49','',''),(2184779,'1','145','826',359,'Retail Sale Id 1289743',8625.00,0.00,0.00,0.00,1500.00,'2021-12-06 16:05:08','',''),(2184780,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:05:08','',''),(2184818,'1','145','826',359,'Retail Sale Id 1289761',38935.00,0.00,0.00,0.00,4792.00,'2021-12-06 16:07:56','',''),(2184819,'1','145','826',359,'Retail sales',0.00,0.00,0.00,59.90,0.00,'2021-12-06 16:07:56','',''),(2184916,'1','145','826',359,'Retail Sale Id 1289806',2070.00,0.00,0.00,0.00,360.00,'2021-12-06 16:14:47','',''),(2184917,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:14:47','',''),(2184985,'1','145','826',359,'Retail Sale Id 1289838',1380.00,0.00,0.00,0.00,240.00,'2021-12-06 16:18:40','',''),(2184986,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 16:18:40','',''),(2187553,'1','145','826',359,'Retail Sale Id 1290862',6900.00,0.00,0.00,0.00,1200.00,'2021-12-07 06:36:21','',''),(2187554,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 06:36:21','',''),(2187575,'1','145','826',359,'Retail Sale Id 1290872',4830.00,0.00,0.00,0.00,840.00,'2021-12-07 06:37:38','',''),(2187576,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 06:37:38','',''),(2187589,'1','145','826',359,'Retail Sale Id 1290881',6900.00,0.00,0.00,0.00,1200.00,'2021-12-07 06:38:59','',''),(2187590,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 06:38:59','',''),(2187609,'1','145','826',359,'Retail Sale Id 1290891',2001.00,0.00,0.00,0.00,348.00,'2021-12-07 06:39:49','',''),(2187610,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-07 06:39:49','',''),(2187611,'1','145','826',359,'Retail Sale Id 1290895',2001.00,0.00,0.00,0.00,348.00,'2021-12-07 06:40:26','',''),(2187612,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-07 06:40:26','',''),(2187629,'1','145','826',359,'Retail Sale Id 1290902',2001.00,0.00,0.00,0.00,348.00,'2021-12-07 06:41:12','',''),(2187630,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-07 06:41:12','',''),(2187639,'1','145','826',359,'Retail Sale Id 1290908',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 06:41:48','',''),(2187640,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 06:41:48','',''),(2187661,'1','145','826',359,'Retail Sale Id 1290923',8970.00,0.00,0.00,0.00,1560.00,'2021-12-07 06:43:14','',''),(2187662,'1','145','826',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-07 06:43:14','',''),(2187675,'1','145','826',359,'Retail Sale Id 1290928',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 06:44:10','',''),(2187676,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 06:44:10','',''),(2187691,'1','145','826',359,'Retail Sale Id 1290937',2691.00,0.00,0.00,0.00,468.00,'2021-12-07 06:45:21','',''),(2187692,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.90,0.00,'2021-12-07 06:45:21','',''),(2187695,'1','145','826',359,'Retail Sale Id 1290941',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 06:46:01','',''),(2187696,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 06:46:01','',''),(2187703,'1','145','826',359,'Retail Sale Id 1290946',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 06:46:54','',''),(2187704,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 06:46:54','',''),(2187712,'1','145','826',359,'Retail Sale Id 1290951',6900.00,0.00,0.00,0.00,1200.00,'2021-12-07 06:47:27','',''),(2187713,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 06:47:27','',''),(2187774,'1','145','826',359,'Retail Sale Id 1290972',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 06:50:42','',''),(2187775,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:50:42','',''),(2187860,'1','145','826',359,'Retail Sale Id 1291004',8280.00,0.00,0.00,0.00,1440.00,'2021-12-07 06:56:06','',''),(2187861,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 06:56:06','',''),(2187885,'1','145','826',359,'Retail Sale Id 1291012',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 06:57:22','',''),(2187886,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 06:57:22','',''),(2187908,'1','145','826',359,'Retail Sale Id 1291022',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 06:58:42','',''),(2187909,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 06:58:42','',''),(2187920,'1','145','826',359,'Retail Sale Id 1291032',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 06:59:36','',''),(2187921,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 06:59:36','',''),(2187934,'1','145','826',359,'Retail Sale Id 1291040',8280.00,0.00,0.00,0.00,1440.00,'2021-12-07 07:00:15','',''),(2187935,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 07:00:15','',''),(2187951,'1','145','826',359,'Retail Sale Id 1291049',6210.00,0.00,0.00,0.00,1080.00,'2021-12-07 07:01:03','',''),(2187952,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-07 07:01:03','',''),(2187970,'1','145','826',359,'Retail Sale Id 1291061',13000.00,0.00,0.00,0.00,1600.00,'2021-12-07 07:02:13','',''),(2187971,'1','145','826',359,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-07 07:02:13','',''),(2188004,'1','145','826',359,'Retail Sale Id 1291079',2001.00,0.00,0.00,0.00,348.00,'2021-12-07 07:03:55','',''),(2188005,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-07 07:03:55','',''),(2188033,'1','145','826',359,'Retail Sale Id 1291092',4830.00,0.00,0.00,0.00,840.00,'2021-12-07 07:05:02','',''),(2188034,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 07:05:02','',''),(2188054,'1','145','826',359,'Retail Sale Id 1291102',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 07:06:04','',''),(2188055,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 07:06:04','',''),(2188098,'1','145','826',359,'Retail Sale Id 1291119',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 07:07:47','',''),(2188099,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:07:47','',''),(2188122,'1','145','826',359,'Retail Sale Id 1291131',1449.00,0.00,0.00,0.00,252.00,'2021-12-07 07:09:10','',''),(2188123,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-07 07:09:10','',''),(2188142,'1','145','826',359,'Retail Sale Id 1291146',1449.00,0.00,0.00,0.00,252.00,'2021-12-07 07:10:17','',''),(2188143,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-07 07:10:17','',''),(2188172,'1','145','826',359,'Retail Sale Id 1291162',8280.00,0.00,0.00,0.00,1440.00,'2021-12-07 07:11:41','',''),(2188173,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 07:11:41','',''),(2188182,'1','145','826',359,'Retail Sale Id 1291167',1449.00,0.00,0.00,0.00,252.00,'2021-12-07 07:12:35','',''),(2188183,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-07 07:12:35','',''),(2188206,'1','145','826',359,'Retail Sale Id 1291176',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 07:13:20','',''),(2188207,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:13:20','',''),(2188222,'1','145','826',359,'Retail Sale Id 1291184',4002.00,0.00,0.00,0.00,696.00,'2021-12-07 07:14:08','',''),(2188223,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-07 07:14:08','',''),(2188272,'1','145','826',359,'Retail Sale Id 1291204',8970.00,0.00,0.00,0.00,1560.00,'2021-12-07 07:16:28','',''),(2188275,'1','145','826',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-07 07:16:28','',''),(2188296,'1','145','826',359,'Retail Sale Id 1291220',5520.00,0.00,0.00,0.00,960.00,'2021-12-07 07:17:25','',''),(2188297,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-07 07:17:25','',''),(2188322,'1','145','826',359,'Retail Sale Id 1291233',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 07:18:48','',''),(2188323,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 07:18:48','',''),(2188348,'1','145','826',359,'Retail Sale Id 1291248',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 07:19:38','',''),(2188349,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:19:38','',''),(2188428,'1','145','826',359,'Retail Sale Id 1291292',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 07:23:59','',''),(2188429,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 07:23:59','',''),(2188464,'1','145','826',359,'Retail Sale Id 1291306',7590.00,0.00,0.00,0.00,1320.00,'2021-12-07 07:25:15','',''),(2188465,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-07 07:25:15','',''),(2188484,'1','145','826',359,'Retail Sale Id 1291315',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 07:26:42','',''),(2188485,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:26:42','',''),(2188522,'1','145','826',359,'Retail Sale Id 1291332',29900.00,0.00,0.00,0.00,3680.00,'2021-12-07 07:28:12','',''),(2188523,'1','145','826',359,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-07 07:28:12','',''),(2188581,'1','145','826',359,'Retail Sale Id 1291360',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 07:30:27','',''),(2188582,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 07:30:27','',''),(2188610,'1','145','826',359,'Retail Sale Id 1291375',5520.00,0.00,0.00,0.00,960.00,'2021-12-07 07:31:46','',''),(2188611,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-07 07:31:46','',''),(2188668,'1','145','826',359,'Retail Sale Id 1291411',7590.00,0.00,0.00,0.00,1320.00,'2021-12-07 07:34:52','',''),(2188669,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-07 07:34:52','',''),(2188686,'1','145','826',359,'Retail Sale Id 1291418',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 07:35:52','',''),(2188687,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:35:52','',''),(2188722,'1','145','826',359,'Retail Sale Id 1291438',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 07:37:34','',''),(2188723,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:37:34','',''),(2188764,'1','145','826',359,'Retail Sale Id 1291458',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 07:39:33','',''),(2188765,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:39:33','',''),(2188786,'1','145','826',359,'Retail Sale Id 1291470',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 07:40:48','',''),(2188787,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 07:40:48','',''),(2188812,'1','145','826',359,'Retail Sale Id 1291485',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 07:41:52','',''),(2188813,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:41:52','',''),(2188834,'1','145','826',359,'Retail Sale Id 1291495',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 07:43:16','',''),(2188835,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 07:43:16','',''),(2188856,'1','145','826',359,'Retail Sale Id 1291521',6210.00,0.00,0.00,0.00,1080.00,'2021-12-07 07:44:18','',''),(2188857,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-07 07:44:18','',''),(2188898,'1','145','826',359,'Retail Sale Id 1291547',8280.00,0.00,0.00,0.00,1440.00,'2021-12-07 07:46:44','',''),(2188899,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 07:46:44','',''),(2188916,'1','145','826',359,'Retail Sale Id 1291564',8970.00,0.00,0.00,0.00,1560.00,'2021-12-07 07:47:57','',''),(2188917,'1','145','826',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-07 07:47:57','',''),(2188934,'1','145','826',359,'Retail Sale Id 1291573',4830.00,0.00,0.00,0.00,840.00,'2021-12-07 07:49:01','',''),(2188935,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 07:49:01','',''),(2188965,'1','145','826',359,'Retail Sale Id 1291585',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 07:50:03','',''),(2188966,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:50:03','',''),(2188975,'1','145','826',359,'Retail Sale Id 1291591',8280.00,0.00,0.00,0.00,1440.00,'2021-12-07 07:50:59','',''),(2188976,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 07:50:59','',''),(2189002,'1','145','826',359,'Retail Sale Id 1291605',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 07:52:49','',''),(2189003,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 07:52:49','',''),(2189033,'1','145','826',359,'Retail Sale Id 1291616',1449.00,0.00,0.00,0.00,252.00,'2021-12-07 07:54:09','',''),(2189034,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-07 07:54:09','',''),(2189045,'1','145','826',359,'Retail Sale Id 1291621',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 07:54:54','',''),(2189046,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 07:54:54','',''),(2189061,'1','145','826',359,'Retail Sale Id 1291629',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 07:55:52','',''),(2189062,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:55:52','',''),(2189143,'1','145','826',359,'Retail Sale Id 1291662',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 07:59:49','',''),(2189144,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 07:59:49','',''),(2189157,'1','145','826',359,'Retail Sale Id 1291669',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 08:00:55','',''),(2189158,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 08:00:55','',''),(2189189,'1','145','826',359,'Retail Sale Id 1291692',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 08:03:15','',''),(2189190,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 08:03:15','',''),(2189205,'1','145','826',359,'Retail Sale Id 1291700',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 08:04:26','',''),(2189206,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 08:04:26','',''),(2189239,'1','145','826',359,'Retail Sale Id 1291717',8280.00,0.00,0.00,0.00,1440.00,'2021-12-07 08:06:29','',''),(2189240,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 08:06:29','',''),(2189285,'1','145','826',359,'Retail Sale Id 1291733',76570.00,0.00,0.00,0.00,9424.00,'2021-12-07 08:08:21','',''),(2189286,'1','145','826',359,'Retail sales',0.00,0.00,0.00,117.80,0.00,'2021-12-07 08:08:21','',''),(2189349,'1','145','826',359,'Retail Sale Id 1291759',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 08:11:33','',''),(2189350,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 08:11:33','',''),(2189379,'1','145','826',359,'Retail Sale Id 1291775',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 08:13:44','',''),(2189380,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:13:44','',''),(2189408,'1','145','826',359,'Retail Sale Id 1291786',39000.00,0.00,0.00,0.00,4800.00,'2021-12-07 08:14:59','',''),(2189409,'1','145','826',359,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-07 08:14:59','',''),(2189436,'1','145','826',359,'Retail Sale Id 1291804',7590.00,0.00,0.00,0.00,1320.00,'2021-12-07 08:16:42','',''),(2189437,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-07 08:16:42','',''),(2189460,'1','145','826',359,'Retail Sale Id 1291817',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 08:17:55','',''),(2189461,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 08:17:55','',''),(2189549,'1','145','826',359,'Retail Sale Id 1291859',4899.00,0.00,0.00,0.00,852.00,'2021-12-07 08:22:50','',''),(2189550,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-07 08:22:50','',''),(2189553,'1','145','826',359,'Retail Sale Id 1291861',8280.00,0.00,0.00,0.00,1440.00,'2021-12-07 08:23:33','',''),(2189554,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 08:23:33','',''),(2189575,'1','145','826',359,'Retail Sale Id 1291871',17250.00,0.00,0.00,0.00,3000.00,'2021-12-07 08:24:49','',''),(2189576,'1','145','826',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 08:24:49','',''),(2189623,'1','145','826',359,'Retail Sale Id 1291893',31200.00,0.00,0.00,0.00,3840.00,'2021-12-07 08:28:48','',''),(2189624,'1','145','826',359,'Retail sales',0.00,0.00,0.00,48.00,0.00,'2021-12-07 08:28:48','',''),(2189639,'1','145','826',359,'Retail Sale Id 1291904',11040.00,0.00,0.00,0.00,1920.00,'2021-12-07 08:29:39','',''),(2189640,'1','145','826',359,'Retail sales',0.00,0.00,0.00,16.00,0.00,'2021-12-07 08:29:39','',''),(2189647,'1','145','826',359,'Retail Sale Id 1291907',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 08:30:28','',''),(2189648,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 08:30:28','',''),(2189659,'1','145','826',359,'Retail Sale Id 1291914',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 08:31:06','',''),(2189660,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 08:31:06','',''),(2189685,'1','145','826',359,'Retail Sale Id 1291927',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 08:32:45','',''),(2189686,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 08:32:45','',''),(2189699,'1','145','826',359,'Retail Sale Id 1291937',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 08:33:48','',''),(2189700,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 08:33:48','',''),(2189738,'1','145','826',359,'Retail Sale Id 1291949',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 08:34:44','',''),(2189739,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:34:44','',''),(2189770,'1','145','826',359,'Retail Sale Id 1291960',32500.00,0.00,0.00,0.00,4000.00,'2021-12-07 08:36:09','',''),(2189771,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 08:36:09','',''),(2189838,'1','145','826',359,'Retail Sale Id 1291974',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 08:38:31','',''),(2189839,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 08:38:31','',''),(2189850,'1','145','826',359,'Retail Sale Id 1291978',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 08:39:23','',''),(2189851,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 08:39:23','',''),(2189860,'1','145','826',359,'Retail Sale Id 1291983',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 08:40:04','',''),(2189861,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 08:40:04','',''),(2189868,'1','145','826',359,'Retail Sale Id 1291990',32500.00,0.00,0.00,0.00,4000.00,'2021-12-07 08:40:45','',''),(2189869,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 08:40:45','',''),(2189896,'1','145','826',359,'Retail Sale Id 1292006',61100.00,0.00,0.00,0.00,7520.00,'2021-12-07 08:42:25','',''),(2189897,'1','145','826',359,'Retail sales',0.00,0.00,0.00,94.00,0.00,'2021-12-07 08:42:25','',''),(2189918,'1','145','826',359,'Retail Sale Id 1292014',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 08:43:13','',''),(2189919,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:43:13','',''),(2189930,'1','145','826',359,'Retail Sale Id 1292021',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 08:44:17','',''),(2189931,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 08:44:17','',''),(2189983,'1','145','826',359,'Retail Sale Id 1292035',9660.00,0.00,0.00,0.00,1680.00,'2021-12-07 08:45:47','',''),(2189984,'1','145','826',359,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-07 08:45:47','',''),(2189993,'1','145','826',359,'Retail Sale Id 1292041',2001.00,0.00,0.00,0.00,348.00,'2021-12-07 08:46:35','',''),(2189994,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-07 08:46:35','',''),(2190013,'1','145','826',359,'Retail Sale Id 1292055',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 08:47:29','',''),(2190014,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 08:47:29','',''),(2190037,'1','145','826',359,'Retail Sale Id 1292067',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 08:48:54','',''),(2190038,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 08:48:54','',''),(2190057,'1','145','826',359,'Retail Sale Id 1292078',8280.00,0.00,0.00,0.00,1440.00,'2021-12-07 08:49:56','',''),(2190058,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 08:49:56','',''),(2190096,'1','145','826',359,'Retail Sale Id 1292093',32500.00,0.00,0.00,0.00,4000.00,'2021-12-07 08:51:33','',''),(2190097,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 08:51:33','',''),(2190118,'1','145','826',359,'Retail Sale Id 1292100',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 08:52:53','',''),(2190119,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 08:52:53','',''),(2190134,'1','145','826',359,'Retail Sale Id 1292104',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 08:53:31','',''),(2190135,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 08:53:31','',''),(2190156,'1','145','826',359,'Retail Sale Id 1292118',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 08:54:39','',''),(2190157,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 08:54:39','',''),(2190184,'1','145','826',359,'Retail Sale Id 1292133',2001.00,0.00,0.00,0.00,348.00,'2021-12-07 08:56:03','',''),(2190185,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-07 08:56:03','',''),(2190208,'1','145','826',359,'Retail Sale Id 1292144',34450.00,0.00,0.00,0.00,4240.00,'2021-12-07 08:58:19','',''),(2190209,'1','145','826',359,'Retail sales',0.00,0.00,0.00,53.00,0.00,'2021-12-07 08:58:19','',''),(2190226,'1','145','826',359,'Retail Sale Id 1292154',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 08:59:42','',''),(2190227,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:59:42','',''),(2190254,'1','145','826',359,'Retail Sale Id 1292170',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 09:01:35','',''),(2190255,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 09:01:35','',''),(2190262,'1','145','826',359,'Retail Sale Id 1292174',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 09:02:26','',''),(2190263,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:02:26','',''),(2190282,'1','145','826',359,'Retail Sale Id 1292184',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 09:03:52','',''),(2190284,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 09:03:52','',''),(2190295,'1','145','826',359,'Retail Sale Id 1292190',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 09:04:59','',''),(2190296,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:04:59','',''),(2190307,'1','145','826',359,'Retail Sale Id 1292197',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 09:05:53','',''),(2190308,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:05:53','',''),(2190361,'1','145','826',359,'Retail Sale Id 1292219',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 09:08:04','',''),(2190362,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 09:08:04','',''),(2190455,'1','145','826',359,'Retail Sale Id 1292268',2001.00,0.00,0.00,0.00,348.00,'2021-12-07 09:12:52','',''),(2190456,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-07 09:12:52','',''),(2190495,'1','145','826',359,'Retail Sale Id 1292290',9798.00,0.00,0.00,0.00,1704.00,'2021-12-07 09:14:55','',''),(2190496,'1','145','826',359,'Retail sales',0.00,0.00,0.00,14.20,0.00,'2021-12-07 09:14:55','',''),(2190599,'1','145','826',359,'Retail Sale Id 1292342',13455.00,0.00,0.00,0.00,2340.00,'2021-12-07 09:20:40','',''),(2190600,'1','145','826',359,'Retail sales',0.00,0.00,0.00,19.50,0.00,'2021-12-07 09:20:40','',''),(2190617,'1','145','826',359,'Retail Sale Id 1292348',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 09:21:31','',''),(2190618,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:21:31','',''),(2190629,'1','145','826',359,'Retail Sale Id 1292355',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 09:22:19','',''),(2190630,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:22:19','',''),(2190741,'1','145','826',359,'Retail Sale Id 1292403',40170.00,0.00,0.00,0.00,4944.00,'2021-12-07 09:27:52','',''),(2190742,'1','145','826',359,'Retail sales',0.00,0.00,0.00,61.80,0.00,'2021-12-07 09:27:52','',''),(2190786,'1','145','826',359,'Retail Sale Id 1292423',1449.00,0.00,0.00,0.00,252.00,'2021-12-07 09:29:21','',''),(2190787,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-07 09:29:21','',''),(2190802,'1','145','826',359,'Retail Sale Id 1292433',17250.00,0.00,0.00,0.00,3000.00,'2021-12-07 09:30:05','',''),(2190803,'1','145','826',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 09:30:05','',''),(2190834,'1','145','826',359,'Retail Sale Id 1292449',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 09:32:05','',''),(2190835,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 09:32:05','',''),(2190860,'1','145','826',359,'Retail Sale Id 1292456',4830.00,0.00,0.00,0.00,840.00,'2021-12-07 09:32:58','',''),(2190861,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 09:32:58','',''),(2190916,'1','145','826',359,'Retail Sale Id 1292487',7590.00,0.00,0.00,0.00,1320.00,'2021-12-07 09:35:48','',''),(2190917,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-07 09:35:48','',''),(2190996,'1','145','826',359,'Retail Sale Id 1292529',2484.00,0.00,0.00,0.00,432.00,'2021-12-07 09:40:22','',''),(2190997,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.60,0.00,'2021-12-07 09:40:22','',''),(2191020,'1','145','826',359,'Retail Sale Id 1292544',2001.00,0.00,0.00,0.00,348.00,'2021-12-07 09:41:50','',''),(2191021,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-07 09:41:50','',''),(2191084,'1','145','826',359,'Retail Sale Id 1292577',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 09:45:53','',''),(2191085,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 09:45:53','',''),(2191140,'1','145','826',359,'Retail Sale Id 1292608',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 09:50:25','',''),(2191141,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 09:50:25','',''),(2191158,'1','145','826',359,'Retail Sale Id 1292617',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 09:51:45','',''),(2191159,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 09:51:45','',''),(2191184,'1','145','826',359,'Retail Sale Id 1292629',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 09:53:43','',''),(2191185,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 09:53:43','',''),(2191198,'1','145','826',359,'Retail Sale Id 1292638',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 09:54:41','',''),(2191199,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:54:41','',''),(2191331,'1','145','826',359,'Retail Sale Id 1292706',8280.00,0.00,0.00,0.00,1440.00,'2021-12-07 10:03:50','',''),(2191332,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 10:03:50','',''),(2191343,'1','145','826',359,'Retail Sale Id 1292715',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 10:04:43','',''),(2191344,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:04:43','',''),(2191393,'1','145','826',359,'Retail Sale Id 1292735',2208.00,0.00,0.00,0.00,384.00,'2021-12-07 10:07:54','',''),(2191394,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.20,0.00,'2021-12-07 10:07:54','',''),(2191433,'1','145','826',359,'Retail Sale Id 1292757',2898.00,0.00,0.00,0.00,504.00,'2021-12-07 10:10:45','',''),(2191434,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-07 10:10:45','',''),(2191451,'1','145','826',359,'Retail Sale Id 1292769',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 10:11:38','',''),(2191452,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 10:11:38','',''),(2191525,'1','145','826',359,'Retail Sale Id 1292810',2967.00,0.00,0.00,0.00,516.00,'2021-12-07 10:16:27','',''),(2191526,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.30,0.00,'2021-12-07 10:16:27','',''),(2191561,'1','145','826',359,'Retail Sale Id 1292828',2208.00,0.00,0.00,0.00,384.00,'2021-12-07 10:19:00','',''),(2191562,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.20,0.00,'2021-12-07 10:19:00','',''),(2191641,'1','145','826',359,'Retail Sale Id 1292869',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 10:25:49','',''),(2191642,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:25:49','',''),(2191724,'1','145','826',359,'Retail Sale Id 1292910',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 10:32:43','',''),(2191725,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:32:43','',''),(2191803,'1','145','826',359,'Retail Sale Id 1292948',2898.00,0.00,0.00,0.00,504.00,'2021-12-07 10:38:11','',''),(2191804,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-07 10:38:11','',''),(2191839,'1','145','826',359,'Retail Sale Id 1292969',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 10:40:31','',''),(2191840,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:40:31','',''),(2191877,'1','145','826',359,'Retail Sale Id 1292988',17250.00,0.00,0.00,0.00,3000.00,'2021-12-07 10:42:29','',''),(2191878,'1','145','826',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 10:42:29','',''),(2191935,'1','145','826',359,'Retail Sale Id 1293014',1449.00,0.00,0.00,0.00,252.00,'2021-12-07 10:45:20','',''),(2191936,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-07 10:45:20','',''),(2191967,'1','145','826',359,'Retail Sale Id 1293026',5175.00,0.00,0.00,0.00,900.00,'2021-12-07 10:46:28','',''),(2191968,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.50,0.00,'2021-12-07 10:46:28','',''),(2192030,'1','145','826',359,'Retail Sale Id 1293006',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 10:49:32','',''),(2192031,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 10:49:32','',''),(2192048,'1','145','826',359,'Retail Sale Id 1293067',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 10:50:40','',''),(2192049,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:50:40','',''),(2192092,'1','145','826',359,'Retail Sale Id 1293088',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 10:52:59','',''),(2192093,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 10:52:59','',''),(2192108,'1','145','826',359,'Retail Sale Id 1293095',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 10:53:51','',''),(2192109,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 10:53:51','',''),(2192123,'1','145','826',359,'Retail Sale Id 1293102',5520.00,0.00,0.00,0.00,960.00,'2021-12-07 10:54:35','',''),(2192124,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-07 10:54:35','',''),(2192148,'1','145','826',359,'Retail Sale Id 1293114',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 10:56:03','',''),(2192149,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 10:56:03','',''),(2192175,'1','145','826',359,'Retail Sale Id 1293128',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 10:57:33','',''),(2192176,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:57:33','',''),(2192197,'1','145','826',359,'Retail Sale Id 1293140',10350.00,0.00,0.00,0.00,1800.00,'2021-12-07 10:58:56','',''),(2192198,'1','145','826',359,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-07 10:58:56','',''),(2192296,'1','145','826',359,'Retail Sale Id 1293173',6210.00,0.00,0.00,0.00,1080.00,'2021-12-07 11:03:07','',''),(2192297,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-07 11:03:07','',''),(2192334,'1','145','826',359,'Retail Sale Id 1293193',2898.00,0.00,0.00,0.00,504.00,'2021-12-07 11:05:06','',''),(2192335,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-07 11:05:06','',''),(2192350,'1','145','826',359,'Retail Sale Id 1293200',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 11:06:06','',''),(2192351,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 11:06:06','',''),(2192375,'1','145','826',359,'Retail Sale Id 1293211',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 11:07:41','',''),(2192376,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 11:07:41','',''),(2192406,'1','145','826',359,'Retail Sale Id 1293227',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 11:08:47','',''),(2192407,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 11:08:47','',''),(2192602,'1','145','826',359,'Retail Sale Id 1293354',1449.00,0.00,0.00,0.00,252.00,'2021-12-07 11:21:12','',''),(2192603,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-07 11:21:12','',''),(2192676,'1','145','826',359,'Retail Sale Id 1293402',1035.00,0.00,0.00,0.00,180.00,'2021-12-07 11:27:09','',''),(2192677,'1','145','826',359,'Retail sales',0.00,0.00,0.00,1.50,0.00,'2021-12-07 11:27:09','',''),(2192712,'1','145','826',359,'Retail Sale Id 1293422',13800.00,0.00,0.00,0.00,2400.00,'2021-12-07 11:29:21','',''),(2192713,'1','145','826',359,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-07 11:29:21','',''),(2192773,'1','145','826',359,'Retail Sale Id 1293447',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 11:33:40','',''),(2192774,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 11:33:40','',''),(2192835,'1','145','826',359,'Retail Sale Id 1293481',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 11:38:43','',''),(2192836,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 11:38:43','',''),(2192853,'1','145','826',359,'Retail Sale Id 1293491',6900.00,0.00,0.00,0.00,1200.00,'2021-12-07 11:39:55','',''),(2192854,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 11:39:55','',''),(2192883,'1','145','826',359,'Retail Sale Id 1293511',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 11:41:44','',''),(2192884,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:41:44','',''),(2192911,'1','145','826',359,'Retail Sale Id 1293525',4830.00,0.00,0.00,0.00,840.00,'2021-12-07 11:43:42','',''),(2192912,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 11:43:42','',''),(2192981,'1','145','826',359,'Retail Sale Id 1293545',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 11:47:04','',''),(2192982,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 11:47:04','',''),(2192999,'1','145','826',359,'Retail Sale Id 1293552',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 11:48:28','',''),(2193000,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 11:48:28','',''),(2193031,'1','145','826',359,'Retail Sale Id 1293570',19500.00,0.00,0.00,0.00,2400.00,'2021-12-07 11:51:38','',''),(2193032,'1','145','826',359,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-07 11:51:38','',''),(2193045,'1','145','826',359,'Retail Sale Id 1293579',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 11:53:23','',''),(2193046,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 11:53:23','',''),(2193055,'1','145','826',359,'Retail Sale Id 1293591',4830.00,0.00,0.00,0.00,840.00,'2021-12-07 11:54:18','',''),(2193056,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 11:54:18','',''),(2193067,'1','145','826',359,'Retail Sale Id 1293597',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 11:55:36','',''),(2193068,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:55:36','',''),(2193105,'1','145','826',359,'Retail Sale Id 1293615',8280.00,0.00,0.00,0.00,1440.00,'2021-12-07 11:58:48','',''),(2193106,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 11:58:48','',''),(2193183,'1','145','826',359,'Retail Sale Id 1293663',8280.00,0.00,0.00,0.00,1440.00,'2021-12-07 12:06:38','',''),(2193184,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 12:06:38','',''),(2193193,'1','145','826',359,'Retail Sale Id 1293668',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 12:07:56','',''),(2193194,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 12:07:56','',''),(2193207,'1','145','826',359,'Retail Sale Id 1293675',2001.00,0.00,0.00,0.00,348.00,'2021-12-07 12:09:34','',''),(2193208,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-07 12:09:34','',''),(2193233,'1','145','826',359,'Retail Sale Id 1293683',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 12:11:19','',''),(2193234,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:11:19','',''),(2193257,'1','145','826',359,'Retail Sale Id 1293700',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 12:12:42','',''),(2193258,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:12:42','',''),(2193271,'1','145','826',359,'Retail Sale Id 1293708',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 12:13:38','',''),(2193272,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 12:13:38','',''),(2193291,'1','145','826',359,'Retail Sale Id 1293717',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 12:15:22','',''),(2193292,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 12:15:22','',''),(2193307,'1','145','826',359,'Retail Sale Id 1293728',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 12:17:15','',''),(2193308,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 12:17:15','',''),(2193335,'1','145','826',359,'Retail Sale Id 1293742',6210.00,0.00,0.00,0.00,1080.00,'2021-12-07 12:19:05','',''),(2193336,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-07 12:19:05','',''),(2193349,'1','145','826',359,'Retail Sale Id 1293753',8280.00,0.00,0.00,0.00,1440.00,'2021-12-07 12:19:52','',''),(2193350,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 12:19:52','',''),(2193367,'1','145','826',359,'Retail Sale Id 1293762',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 12:22:23','',''),(2193368,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 12:22:23','',''),(2193371,'1','145','826',359,'Retail Sale Id 1293766',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 12:23:36','',''),(2193372,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 12:23:36','',''),(2193471,'1','145','826',359,'Retail Sale Id 1293814',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 12:31:48','',''),(2193472,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 12:31:48','',''),(2193507,'1','145','826',359,'Retail Sale Id 1293828',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 12:34:47','',''),(2193508,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:34:47','',''),(2193519,'1','145','826',359,'Retail Sale Id 1293837',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 12:36:01','',''),(2193520,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 12:36:01','',''),(2193585,'1','145','826',359,'Retail Sale Id 1293876',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 12:41:13','',''),(2193586,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:41:13','',''),(2193606,'1','145','826',359,'Retail Sale Id 1293885',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 12:42:51','',''),(2193607,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 12:42:51','',''),(2193712,'1','145','826',359,'Retail Sale Id 1293953',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 12:50:47','',''),(2193713,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 12:50:47','',''),(2193781,'1','145','826',359,'Retail Sale Id 1293991',39000.00,0.00,0.00,0.00,4800.00,'2021-12-07 12:54:37','',''),(2193782,'1','145','826',359,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-07 12:54:37','',''),(2193794,'1','145','826',359,'Retail Sale Id 1293995',8970.00,0.00,0.00,0.00,1560.00,'2021-12-07 12:55:25','',''),(2193795,'1','145','826',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-07 12:55:25','',''),(2193822,'1','145','826',359,'Retail Sale Id 1294004',2898.00,0.00,0.00,0.00,504.00,'2021-12-07 12:57:37','',''),(2193823,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-07 12:57:37','',''),(2193837,'1','145','826',359,'Retail Sale Id 1294009',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 12:58:54','',''),(2193838,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 12:58:54','',''),(2193868,'1','145','826',359,'Retail Sale Id 1294038',8694.00,0.00,0.00,0.00,1512.00,'2021-12-07 13:00:07','',''),(2193869,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.60,0.00,'2021-12-07 13:00:07','',''),(2193936,'1','145','826',359,'Retail Sale Id 1294064',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 13:04:41','',''),(2193937,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 13:04:41','',''),(2194013,'1','145','826',359,'Retail Sale Id 1294102',1449.00,0.00,0.00,0.00,252.00,'2021-12-07 13:10:47','',''),(2194014,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-07 13:10:47','',''),(2194073,'1','145','826',359,'Retail Sale Id 1294132',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 13:13:56','',''),(2194074,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:13:56','',''),(2194088,'1','145','826',359,'Retail Sale Id 1294144',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 13:15:02','',''),(2194089,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 13:15:02','',''),(2194094,'1','145','826',359,'Retail Sale Id 1294148',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 13:15:36','',''),(2194095,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 13:15:36','',''),(2194139,'1','145','826',359,'Retail Sale Id 1294168',65000.00,0.00,0.00,0.00,8000.00,'2021-12-07 13:18:25','',''),(2194140,'1','145','826',359,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-07 13:18:25','',''),(2194177,'1','145','826',359,'Retail Sale Id 1294187',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 13:20:25','',''),(2194178,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 13:20:25','',''),(2194200,'1','145','826',359,'Retail Sale Id 1294244',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 13:23:50','',''),(2194201,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 13:23:50','',''),(2194241,'1','145','826',359,'Retail Sale Id 1294281',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 13:24:55','',''),(2194242,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:24:55','',''),(2194449,'1','145','826',359,'Retail Sale Id 1294377',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 13:33:53','',''),(2194450,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:33:53','',''),(2194627,'1','145','826',359,'Retail Sale Id 1294450',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 13:45:02','',''),(2194628,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:45:02','',''),(2194672,'1','145','826',359,'Retail Sale Id 1294483',6555.00,0.00,0.00,0.00,1140.00,'2021-12-07 13:47:57','',''),(2194673,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.50,0.00,'2021-12-07 13:47:57','',''),(2194823,'1','145','826',359,'Retail Sale Id 1294545',1725.00,0.00,0.00,0.00,300.00,'2021-12-07 13:56:52','',''),(2194824,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 13:56:52','',''),(2194835,'1','145','826',359,'Retail Sale Id 1294551',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 13:57:40','',''),(2194836,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 13:57:40','',''),(2194845,'1','145','826',359,'Retail Sale Id 1294558',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 13:58:34','',''),(2194846,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 13:58:34','',''),(2194901,'1','145','826',359,'Retail Sale Id 1294587',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 14:02:16','',''),(2194902,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:02:16','',''),(2194933,'1','145','826',359,'Retail Sale Id 1294604',10350.00,0.00,0.00,0.00,1800.00,'2021-12-07 14:04:25','',''),(2194934,'1','145','826',359,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-07 14:04:25','',''),(2194967,'1','145','826',359,'Retail Sale Id 1294622',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 14:07:15','',''),(2194968,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:07:15','',''),(2195001,'1','145','826',359,'Retail Sale Id 1294638',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 14:09:02','',''),(2195003,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:09:02','',''),(2195075,'1','145','826',359,'Retail Sale Id 1294668',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 14:12:04','',''),(2195076,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:12:04','',''),(2195298,'1','145','826',359,'Retail Sale Id 1294753',4830.00,0.00,0.00,0.00,840.00,'2021-12-07 14:23:48','',''),(2195299,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 14:23:48','',''),(2195322,'1','145','826',359,'Retail Sale Id 1294766',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 14:25:10','',''),(2195323,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:25:10','',''),(2195420,'1','145','826',359,'Retail Sale Id 1294808',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 14:29:49','',''),(2195421,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 14:29:49','',''),(2195430,'1','145','826',359,'Retail Sale Id 1294815',2967.00,0.00,0.00,0.00,516.00,'2021-12-07 14:31:07','',''),(2195431,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.30,0.00,'2021-12-07 14:31:07','',''),(2195485,'1','145','826',359,'Retail Sale Id 1294846',3588.00,0.00,0.00,0.00,624.00,'2021-12-07 14:34:26','',''),(2195486,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.20,0.00,'2021-12-07 14:34:26','',''),(2195497,'1','145','826',359,'Retail Sale Id 1294860',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 14:35:03','',''),(2195498,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:35:03','',''),(2195517,'1','145','826',359,'Retail Sale Id 1294874',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 14:36:20','',''),(2195518,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:36:20','',''),(2195557,'1','145','826',359,'Retail Sale Id 1294892',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 14:38:35','',''),(2195558,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 14:38:35','',''),(2195595,'1','145','826',359,'Retail Sale Id 1294913',2001.00,0.00,0.00,0.00,348.00,'2021-12-07 14:41:13','',''),(2195596,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-07 14:41:13','',''),(2195641,'1','145','826',359,'Retail Sale Id 1294934',4002.00,0.00,0.00,0.00,696.00,'2021-12-07 14:42:53','',''),(2195642,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-07 14:42:53','',''),(2195653,'1','145','826',359,'Retail Sale Id 1294942',2001.00,0.00,0.00,0.00,348.00,'2021-12-07 14:43:43','',''),(2195654,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-07 14:43:43','',''),(2195686,'1','145','826',359,'Retail Sale Id 1294952',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 14:45:02','',''),(2195687,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:45:02','',''),(2195728,'1','145','826',359,'Retail Sale Id 1294977',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 14:47:28','',''),(2195729,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 14:47:28','',''),(2195760,'1','145','826',359,'Retail Sale Id 1294995',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 14:49:01','',''),(2195761,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 14:49:01','',''),(2195810,'1','145','826',359,'Retail Sale Id 1295019',17250.00,0.00,0.00,0.00,3000.00,'2021-12-07 14:51:04','',''),(2195811,'1','145','826',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 14:51:04','',''),(2195836,'1','145','826',359,'Retail Sale Id 1295035',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 14:52:09','',''),(2195837,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:52:09','',''),(2195864,'1','145','826',359,'Retail Sale Id 1295056',4830.00,0.00,0.00,0.00,840.00,'2021-12-07 14:53:49','',''),(2195865,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 14:53:49','',''),(2195896,'1','145','826',359,'Retail Sale Id 1295070',4830.00,0.00,0.00,0.00,840.00,'2021-12-07 14:55:48','',''),(2195897,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 14:55:48','',''),(2195910,'1','145','826',359,'Retail Sale Id 1295077',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 14:57:03','',''),(2195911,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 14:57:03','',''),(2195928,'1','145','826',359,'Retail Sale Id 1295086',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 14:57:52','',''),(2195929,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:57:52','',''),(2195938,'1','145','826',359,'Retail Sale Id 1295092',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 14:59:03','',''),(2195939,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 14:59:03','',''),(2196005,'1','145','826',359,'Retail Sale Id 1295114',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 15:02:34','',''),(2196006,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 15:02:34','',''),(2196017,'1','145','826',359,'Retail Sale Id 1295120',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 15:03:27','',''),(2196018,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:03:27','',''),(2196048,'1','145','826',359,'Retail Sale Id 1295137',6003.00,0.00,0.00,0.00,1044.00,'2021-12-07 15:05:26','',''),(2196049,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.70,0.00,'2021-12-07 15:05:26','',''),(2196060,'1','145','826',359,'Retail Sale Id 1295144',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 15:06:30','',''),(2196061,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:06:30','',''),(2196076,'1','145','826',359,'Retail Sale Id 1295151',6900.00,0.00,0.00,0.00,1200.00,'2021-12-07 15:07:09','',''),(2196077,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 15:07:09','',''),(2196124,'1','145','826',359,'Retail Sale Id 1295179',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 15:09:38','',''),(2196125,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 15:09:38','',''),(2196170,'1','145','826',359,'Retail Sale Id 1295199',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 15:11:36','',''),(2196171,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 15:11:36','',''),(2196242,'1','145','826',359,'Retail Sale Id 1295235',32500.00,0.00,0.00,0.00,4000.00,'2021-12-07 15:15:11','',''),(2196243,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 15:15:11','',''),(2196272,'1','145','826',359,'Retail Sale Id 1295247',8280.00,0.00,0.00,0.00,1440.00,'2021-12-07 15:16:42','',''),(2196273,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 15:16:42','',''),(2196290,'1','145','826',359,'Retail Sale Id 1295256',65000.00,0.00,0.00,0.00,8000.00,'2021-12-07 15:17:48','',''),(2196291,'1','145','826',359,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-07 15:17:48','',''),(2196320,'1','145','826',359,'Retail Sale Id 1295273',40300.00,0.00,0.00,0.00,4960.00,'2021-12-07 15:19:40','',''),(2196321,'1','145','826',359,'Retail sales',0.00,0.00,0.00,62.00,0.00,'2021-12-07 15:19:40','',''),(2196348,'1','145','826',359,'Retail Sale Id 1295287',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 15:21:24','',''),(2196349,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:21:24','',''),(2196362,'1','145','826',359,'Retail Sale Id 1295292',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 15:22:01','',''),(2196363,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:22:01','',''),(2196376,'1','145','826',359,'Retail Sale Id 1295301',6900.00,0.00,0.00,0.00,1200.00,'2021-12-07 15:23:03','',''),(2196377,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 15:23:03','',''),(2196405,'1','145','826',359,'Retail Sale Id 1295322',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 15:24:29','',''),(2196406,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:24:29','',''),(2196426,'1','145','826',359,'Retail Sale Id 1295332',4830.00,0.00,0.00,0.00,840.00,'2021-12-07 15:25:28','',''),(2196427,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 15:25:28','',''),(2196464,'1','145','826',359,'Retail Sale Id 1295350',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 15:26:30','',''),(2196465,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 15:26:30','',''),(2196476,'1','145','826',359,'Retail Sale Id 1295354',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 15:27:38','',''),(2196477,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 15:27:38','',''),(2196498,'1','145','826',359,'Retail Sale Id 1295369',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 15:28:33','',''),(2196499,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 15:28:33','',''),(2196522,'1','145','826',359,'Retail Sale Id 1295377',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 15:29:39','',''),(2196523,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:29:39','',''),(2196536,'1','145','826',359,'Retail Sale Id 1295385',6900.00,0.00,0.00,0.00,1200.00,'2021-12-07 15:30:40','',''),(2196537,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 15:30:40','',''),(2196556,'1','145','826',359,'Retail Sale Id 1295396',4830.00,0.00,0.00,0.00,840.00,'2021-12-07 15:31:25','',''),(2196557,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 15:31:25','',''),(2196582,'1','145','826',359,'Retail Sale Id 1295407',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 15:32:27','',''),(2196583,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 15:32:27','',''),(2196606,'1','145','826',359,'Retail Sale Id 1295420',6900.00,0.00,0.00,0.00,1200.00,'2021-12-07 15:33:45','',''),(2196607,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 15:33:45','',''),(2196618,'1','145','826',359,'Retail Sale Id 1295426',19500.00,0.00,0.00,0.00,2400.00,'2021-12-07 15:34:40','',''),(2196619,'1','145','826',359,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-07 15:34:40','',''),(2196638,'1','145','826',359,'Retail Sale Id 1295435',9315.00,0.00,0.00,0.00,1620.00,'2021-12-07 15:35:26','',''),(2196639,'1','145','826',359,'Retail sales',0.00,0.00,0.00,13.50,0.00,'2021-12-07 15:35:26','',''),(2196644,'1','145','826',359,'Retail Sale Id 1295439',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 15:36:00','',''),(2196645,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 15:36:00','',''),(2196660,'1','145','826',359,'Retail Sale Id 1295454',26000.00,0.00,0.00,0.00,3200.00,'2021-12-07 15:36:58','',''),(2196661,'1','145','826',359,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-07 15:36:58','',''),(2196687,'1','145','826',359,'Retail Sale Id 1295461',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 15:37:54','',''),(2196688,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:37:54','',''),(2196715,'1','145','826',359,'Retail Sale Id 1295475',1449.00,0.00,0.00,0.00,252.00,'2021-12-07 15:38:59','',''),(2196716,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-07 15:38:59','',''),(2196750,'1','145','826',359,'Retail Sale Id 1295487',2760.00,0.00,0.00,0.00,480.00,'2021-12-07 15:40:00','',''),(2196751,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 15:40:00','',''),(2196769,'1','145','826',359,'Retail Sale Id 1295495',15525.00,0.00,0.00,0.00,2700.00,'2021-12-07 15:40:56','',''),(2196770,'1','145','826',359,'Retail sales',0.00,0.00,0.00,22.50,0.00,'2021-12-07 15:40:56','',''),(2196785,'1','145','826',359,'Retail Sale Id 1295503',4002.00,0.00,0.00,0.00,696.00,'2021-12-07 15:42:11','',''),(2196786,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-07 15:42:11','',''),(2196813,'1','145','826',359,'Retail Sale Id 1295516',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 15:43:23','',''),(2196814,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 15:43:23','',''),(2196843,'1','145','826',359,'Retail Sale Id 1295533',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 15:44:45','',''),(2196844,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 15:44:45','',''),(2196853,'1','145','826',359,'Retail Sale Id 1295540',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 15:45:29','',''),(2196854,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:45:29','',''),(2196875,'1','145','826',359,'Retail Sale Id 1295549',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 15:46:08','',''),(2196876,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:46:08','',''),(2196895,'1','145','826',359,'Retail Sale Id 1295560',34500.00,0.00,0.00,0.00,6000.00,'2021-12-07 15:47:09','',''),(2196896,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 15:47:09','',''),(2196931,'1','145','826',359,'Retail Sale Id 1295576',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 15:49:14','',''),(2196932,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 15:49:14','',''),(2196962,'1','145','826',359,'Retail Sale Id 1295594',8625.00,0.00,0.00,0.00,1500.00,'2021-12-07 15:50:47','',''),(2196963,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:50:47','',''),(2196994,'1','145','826',359,'Retail Sale Id 1295613',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 15:52:07','',''),(2196995,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:52:07','',''),(2197036,'1','145','826',359,'Retail Sale Id 1295637',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 15:53:54','',''),(2197039,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 15:53:54','',''),(2197052,'1','145','826',359,'Retail Sale Id 1295644',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 15:54:46','',''),(2197053,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 15:54:46','',''),(2197139,'1','145','826',359,'Retail Sale Id 1295686',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 15:58:29','',''),(2197140,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:58:29','',''),(2197170,'1','145','826',359,'Retail Sale Id 1295701',4140.00,0.00,0.00,0.00,720.00,'2021-12-07 16:00:22','',''),(2197171,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:00:22','',''),(2197296,'1','145','826',359,'Retail Sale Id 1295761',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 16:06:01','',''),(2197297,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 16:06:01','',''),(2197372,'1','145','826',359,'Retail Sale Id 1295804',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 16:10:06','',''),(2197373,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 16:10:06','',''),(2197382,'1','145','826',359,'Retail Sale Id 1295808',7590.00,0.00,0.00,0.00,1320.00,'2021-12-07 16:10:57','',''),(2197383,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-07 16:10:57','',''),(2197400,'1','145','826',359,'Retail Sale Id 1295818',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 16:11:45','',''),(2197401,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 16:11:45','',''),(2197442,'1','145','826',359,'Retail Sale Id 1295842',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 16:13:29','',''),(2197443,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 16:13:29','',''),(2197510,'1','145','826',359,'Retail Sale Id 1295883',1380.00,0.00,0.00,0.00,240.00,'2021-12-07 16:16:54','',''),(2197511,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 16:16:54','',''),(2197560,'1','145','826',359,'Retail Sale Id 1295903',4830.00,0.00,0.00,0.00,840.00,'2021-12-07 16:18:57','',''),(2197561,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 16:18:57','',''),(2197597,'1','145','826',359,'Retail Sale Id 1295930',32500.00,0.00,0.00,0.00,4000.00,'2021-12-07 16:20:03','',''),(2197598,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 16:20:03','',''),(2197637,'1','145','826',359,'Retail Sale Id 1295943',4830.00,0.00,0.00,0.00,840.00,'2021-12-07 16:22:10','',''),(2197638,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 16:22:10','',''),(2197667,'1','145','826',359,'Retail Sale Id 1295966',2070.00,0.00,0.00,0.00,360.00,'2021-12-07 16:23:19','',''),(2197668,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:23:19','',''),(2197749,'1','145','826',359,'Retail Sale Id 1295999',3450.00,0.00,0.00,0.00,600.00,'2021-12-07 16:27:33','',''),(2197750,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 16:27:33','',''),(2200221,'1','145','826',359,'Retail Sale Id 1296980',4830.00,0.00,0.00,0.00,840.00,'2021-12-08 06:48:14','',''),(2200222,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 06:48:14','',''),(2200244,'1','145','826',359,'Retail Sale Id 1296990',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 06:49:23','',''),(2200245,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:49:23','',''),(2200286,'1','145','826',359,'Retail Sale Id 1297006',2001.00,0.00,0.00,0.00,348.00,'2021-12-08 06:51:38','',''),(2200287,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-08 06:51:38','',''),(2200300,'1','145','826',359,'Retail Sale Id 1297011',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 06:52:29','',''),(2200301,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:52:29','',''),(2200306,'1','145','826',359,'Retail Sale Id 1297015',4140.00,0.00,0.00,0.00,720.00,'2021-12-08 06:53:24','',''),(2200307,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 06:53:24','',''),(2200345,'1','145','826',359,'Retail Sale Id 1297026',1173.00,0.00,0.00,0.00,204.00,'2021-12-08 06:55:20','',''),(2200346,'1','145','826',359,'Retail sales',0.00,0.00,0.00,1.70,0.00,'2021-12-08 06:55:20','',''),(2200365,'1','145','826',359,'Retail Sale Id 1297036',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 06:56:07','',''),(2200366,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 06:56:07','',''),(2200383,'1','145','826',359,'Retail Sale Id 1297045',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 06:56:53','',''),(2200384,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:56:53','',''),(2200425,'1','145','826',359,'Retail Sale Id 1297067',2760.00,0.00,0.00,0.00,480.00,'2021-12-08 06:59:22','',''),(2200426,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 06:59:22','',''),(2200449,'1','145','826',359,'Retail Sale Id 1297077',1380.00,0.00,0.00,0.00,240.00,'2021-12-08 07:00:35','',''),(2200450,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 07:00:35','',''),(2200459,'1','145','826',359,'Retail Sale Id 1297082',8487.00,0.00,0.00,0.00,1476.00,'2021-12-08 07:01:32','',''),(2200460,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.30,0.00,'2021-12-08 07:01:32','',''),(2200479,'1','145','826',359,'Retail Sale Id 1297092',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 07:02:45','',''),(2200480,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 07:02:45','',''),(2200495,'1','145','826',359,'Retail Sale Id 1297102',12870.00,0.00,0.00,0.00,1584.00,'2021-12-08 07:03:51','',''),(2200496,'1','145','826',359,'Retail sales',0.00,0.00,0.00,19.80,0.00,'2021-12-08 07:03:51','',''),(2200519,'1','145','826',359,'Retail Sale Id 1297114',1794.00,0.00,0.00,0.00,312.00,'2021-12-08 07:05:02','',''),(2200520,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.60,0.00,'2021-12-08 07:05:02','',''),(2200597,'1','145','826',359,'Retail Sale Id 1297148',4899.00,0.00,0.00,0.00,852.00,'2021-12-08 07:10:57','',''),(2200598,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-08 07:10:57','',''),(2200657,'1','145','826',359,'Retail Sale Id 1297181',2001.00,0.00,0.00,0.00,348.00,'2021-12-08 07:15:02','',''),(2200658,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-08 07:15:02','',''),(2200669,'1','145','826',359,'Retail Sale Id 1297186',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 07:15:55','',''),(2200670,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:15:55','',''),(2200691,'1','145','826',359,'Retail Sale Id 1297197',4830.00,0.00,0.00,0.00,840.00,'2021-12-08 07:17:20','',''),(2200692,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 07:17:20','',''),(2200725,'1','145','826',359,'Retail Sale Id 1297211',5520.00,0.00,0.00,0.00,960.00,'2021-12-08 07:18:20','',''),(2200726,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-08 07:18:20','',''),(2200760,'1','145','826',359,'Retail Sale Id 1297220',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 07:19:32','',''),(2200761,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:19:32','',''),(2200794,'1','145','826',359,'Retail Sale Id 1297238',2760.00,0.00,0.00,0.00,480.00,'2021-12-08 07:21:08','',''),(2200795,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 07:21:08','',''),(2200863,'1','145','826',359,'Retail Sale Id 1297276',1449.00,0.00,0.00,0.00,252.00,'2021-12-08 07:25:03','',''),(2200864,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-08 07:25:03','',''),(2200934,'1','145','826',359,'Retail Sale Id 1297309',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 07:29:41','',''),(2200935,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 07:29:41','',''),(2200959,'1','145','826',359,'Retail Sale Id 1297316',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 07:30:15','',''),(2200960,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 07:30:15','',''),(2201025,'1','145','826',359,'Retail Sale Id 1297349',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 07:33:52','',''),(2201026,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 07:33:52','',''),(2201099,'1','145','826',359,'Retail Sale Id 1297374',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 07:36:32','',''),(2201100,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 07:36:32','',''),(2201156,'1','145','826',359,'Retail Sale Id 1297405',2898.00,0.00,0.00,0.00,504.00,'2021-12-08 07:39:59','',''),(2201157,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-08 07:39:59','',''),(2201166,'1','145','826',359,'Retail Sale Id 1297409',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 07:40:38','',''),(2201167,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 07:40:39','',''),(2201196,'1','145','826',359,'Retail Sale Id 1297423',41600.00,0.00,0.00,0.00,5120.00,'2021-12-08 07:42:40','',''),(2201197,'1','145','826',359,'Retail sales',0.00,0.00,0.00,64.00,0.00,'2021-12-08 07:42:40','',''),(2201216,'1','145','826',359,'Retail Sale Id 1297432',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 07:43:43','',''),(2201217,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:43:43','',''),(2201236,'1','145','826',359,'Retail Sale Id 1297444',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 07:45:08','',''),(2201237,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 07:45:08','',''),(2201244,'1','145','826',359,'Retail Sale Id 1297450',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 07:45:54','',''),(2201245,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 07:45:54','',''),(2201258,'1','145','826',359,'Retail Sale Id 1297456',5520.00,0.00,0.00,0.00,960.00,'2021-12-08 07:46:55','',''),(2201259,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-08 07:46:55','',''),(2201276,'1','145','826',359,'Retail Sale Id 1297468',1449.00,0.00,0.00,0.00,252.00,'2021-12-08 07:48:02','',''),(2201277,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-08 07:48:02','',''),(2201294,'1','145','826',359,'Retail Sale Id 1297476',1035.00,0.00,0.00,0.00,180.00,'2021-12-08 07:49:08','',''),(2201295,'1','145','826',359,'Retail sales',0.00,0.00,0.00,1.50,0.00,'2021-12-08 07:49:08','',''),(2201316,'1','145','826',359,'Retail Sale Id 1297487',22750.00,0.00,0.00,0.00,2800.00,'2021-12-08 07:50:26','',''),(2201317,'1','145','826',359,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-08 07:50:26','',''),(2201353,'1','145','826',359,'Retail Sale Id 1297501',2001.00,0.00,0.00,0.00,348.00,'2021-12-08 07:51:44','',''),(2201354,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-08 07:51:44','',''),(2201424,'1','145','826',359,'Retail Sale Id 1297525',8280.00,0.00,0.00,0.00,1440.00,'2021-12-08 07:53:45','',''),(2201425,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-08 07:53:45','',''),(2201462,'1','145','826',359,'Retail Sale Id 1297538',6900.00,0.00,0.00,0.00,1200.00,'2021-12-08 07:55:21','',''),(2201463,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 07:55:21','',''),(2201474,'1','145','826',359,'Retail Sale Id 1297545',10350.00,0.00,0.00,0.00,1800.00,'2021-12-08 07:56:05','',''),(2201475,'1','145','826',359,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-08 07:56:05','',''),(2201488,'1','145','826',359,'Return of Retail Sale Id 1297545',0.00,10350.00,15.00,0.00,-1800.00,'2021-12-08 07:56:56','',''),(2201497,'1','145','826',359,'Retail Sale Id 1297557',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 07:57:30','',''),(2201498,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 07:57:30','',''),(2201633,'1','145','826',359,'Retail Sale Id 1297617',4830.00,0.00,0.00,0.00,840.00,'2021-12-08 08:04:14','',''),(2201634,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 08:04:14','',''),(2201714,'1','145','826',359,'Retail Sale Id 1297660',1380.00,0.00,0.00,0.00,240.00,'2021-12-08 08:09:53','',''),(2201715,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 08:09:53','',''),(2201726,'1','145','826',359,'Retail Sale Id 1297665',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 08:10:43','',''),(2201727,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 08:10:43','',''),(2201740,'1','145','826',359,'Retail Sale Id 1297674',5175.00,0.00,0.00,0.00,900.00,'2021-12-08 08:11:52','',''),(2201741,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.50,0.00,'2021-12-08 08:11:52','',''),(2201760,'1','145','826',359,'Retail Sale Id 1297687',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 08:13:24','',''),(2201761,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:13:24','',''),(2201778,'1','145','826',359,'Retail Sale Id 1297695',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 08:14:41','',''),(2201779,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:14:41','',''),(2201799,'1','145','826',359,'Retail Sale Id 1297704',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 08:15:48','',''),(2201800,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 08:15:48','',''),(2201815,'1','145','826',359,'Retail Sale Id 1297718',2001.00,0.00,0.00,0.00,348.00,'2021-12-08 08:16:42','',''),(2201816,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-08 08:16:42','',''),(2201833,'1','145','826',359,'Retail Sale Id 1297727',2001.00,0.00,0.00,0.00,348.00,'2021-12-08 08:17:57','',''),(2201834,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-08 08:17:57','',''),(2201847,'1','145','826',359,'Retail Sale Id 1297734',2760.00,0.00,0.00,0.00,480.00,'2021-12-08 08:18:53','',''),(2201848,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 08:18:53','',''),(2201859,'1','145','826',359,'Retail Sale Id 1297737',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 08:19:41','',''),(2201860,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 08:19:41','',''),(2201871,'1','145','826',359,'Retail Sale Id 1297743',7590.00,0.00,0.00,0.00,1320.00,'2021-12-08 08:20:21','',''),(2201872,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-08 08:20:21','',''),(2201943,'1','145','826',359,'Retail Sale Id 1297782',9660.00,0.00,0.00,0.00,1680.00,'2021-12-08 08:25:13','',''),(2201944,'1','145','826',359,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-08 08:25:13','',''),(2201977,'1','145','826',359,'Retail Sale Id 1297797',7590.00,0.00,0.00,0.00,1320.00,'2021-12-08 08:27:06','',''),(2201978,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-08 08:27:06','',''),(2202040,'1','145','826',359,'Retail Sale Id 1297825',8487.00,0.00,0.00,0.00,1476.00,'2021-12-08 08:31:22','',''),(2202041,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.30,0.00,'2021-12-08 08:31:22','',''),(2202076,'1','145','826',359,'Retail Sale Id 1297841',1380.00,0.00,0.00,0.00,240.00,'2021-12-08 08:33:35','',''),(2202077,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 08:33:35','',''),(2202110,'1','145','826',359,'Retail Sale Id 1297857',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 08:35:33','',''),(2202111,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 08:35:33','',''),(2202130,'1','145','826',359,'Retail Sale Id 1297867',1449.00,0.00,0.00,0.00,252.00,'2021-12-08 08:36:26','',''),(2202131,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-08 08:36:26','',''),(2202150,'1','145','826',359,'Retail Sale Id 1297878',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 08:38:10','',''),(2202151,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:38:10','',''),(2202162,'1','145','826',359,'Retail Sale Id 1297884',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 08:38:48','',''),(2202163,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 08:38:48','',''),(2202176,'1','145','826',359,'Retail Sale Id 1297890',4140.00,0.00,0.00,0.00,720.00,'2021-12-08 08:39:25','',''),(2202177,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 08:39:25','',''),(2202244,'1','145','826',359,'Retail Sale Id 1297909',4140.00,0.00,0.00,0.00,720.00,'2021-12-08 08:42:08','',''),(2202245,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 08:42:08','',''),(2202279,'1','145','826',359,'Retail Sale Id 1297919',4830.00,0.00,0.00,0.00,840.00,'2021-12-08 08:43:04','',''),(2202280,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 08:43:04','',''),(2202322,'1','145','826',359,'Retail Sale Id 1297925',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 08:44:16','',''),(2202323,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 08:44:16','',''),(2202344,'1','145','826',359,'Retail Sale Id 1297935',8280.00,0.00,0.00,0.00,1440.00,'2021-12-08 08:45:43','',''),(2202345,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-08 08:45:43','',''),(2202380,'1','145','826',359,'Retail Sale Id 1297949',4140.00,0.00,0.00,0.00,720.00,'2021-12-08 08:47:16','',''),(2202381,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 08:47:16','',''),(2202411,'1','145','826',359,'Retail Sale Id 1297959',42250.00,0.00,0.00,0.00,5200.00,'2021-12-08 08:48:31','',''),(2202412,'1','145','826',359,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-08 08:48:31','',''),(2202462,'1','145','826',359,'Retail Sale Id 1297973',4140.00,0.00,0.00,0.00,720.00,'2021-12-08 08:50:54','',''),(2202463,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 08:50:54','',''),(2202594,'1','145','826',359,'Retail Sale Id 1298035',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 08:57:45','',''),(2202595,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 08:57:45','',''),(2202716,'1','145','826',359,'Retail Sale Id 1298094',8775.00,0.00,0.00,0.00,1080.00,'2021-12-08 09:05:23','',''),(2202717,'1','145','826',359,'Retail sales',0.00,0.00,0.00,13.50,0.00,'2021-12-08 09:05:23','',''),(2202754,'1','145','826',359,'Retail Sale Id 1298125',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 09:07:43','',''),(2202755,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 09:07:43','',''),(2202926,'1','145','826',359,'Retail Sale Id 1298200',34500.00,0.00,0.00,0.00,6000.00,'2021-12-08 09:17:12','',''),(2202927,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 09:17:12','',''),(2203037,'1','145','826',359,'Retail Sale Id 1298255',2760.00,0.00,0.00,0.00,480.00,'2021-12-08 09:26:02','',''),(2203038,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 09:26:02','',''),(2203051,'1','145','826',359,'Retail Sale Id 1298263',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 09:27:36','',''),(2203052,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 09:27:36','',''),(2203085,'1','145','826',359,'Retail Sale Id 1298278',6210.00,0.00,0.00,0.00,1080.00,'2021-12-08 09:30:49','',''),(2203086,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-08 09:30:49','',''),(2203119,'1','145','826',359,'Retail Sale Id 1298295',6210.00,0.00,0.00,0.00,1080.00,'2021-12-08 09:33:39','',''),(2203120,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-08 09:33:39','',''),(2203143,'1','145','826',359,'Retail Sale Id 1298309',35750.00,0.00,0.00,0.00,4400.00,'2021-12-08 09:35:34','',''),(2203144,'1','145','826',359,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-08 09:35:34','',''),(2203199,'1','145','826',359,'Retail Sale Id 1298334',17250.00,0.00,0.00,0.00,3000.00,'2021-12-08 09:39:07','',''),(2203200,'1','145','826',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 09:39:07','',''),(2203213,'1','145','826',359,'Retail Sale Id 1298342',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 09:40:16','',''),(2203214,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 09:40:16','',''),(2203249,'1','145','826',359,'Retail Sale Id 1298361',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 09:44:23','',''),(2203250,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:44:23','',''),(2203293,'1','145','826',359,'Retail Sale Id 1298385',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 09:47:25','',''),(2203294,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:47:25','',''),(2203336,'1','145','826',359,'Retail Sale Id 1298397',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 09:49:34','',''),(2203337,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 09:49:34','',''),(2203364,'1','145','826',359,'Retail Sale Id 1298411',6900.00,0.00,0.00,0.00,1200.00,'2021-12-08 09:51:07','',''),(2203365,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 09:51:07','',''),(2203446,'1','145','826',359,'Retail Sale Id 1298456',4830.00,0.00,0.00,0.00,840.00,'2021-12-08 09:58:39','',''),(2203447,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 09:58:39','',''),(2203503,'1','145','826',359,'Retail Sale Id 1298475',1380.00,0.00,0.00,0.00,240.00,'2021-12-08 10:01:59','',''),(2203504,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 10:01:59','',''),(2203719,'1','145','826',359,'Retail Sale Id 1298577',65000.00,0.00,0.00,0.00,8000.00,'2021-12-08 10:15:47','',''),(2203720,'1','145','826',359,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-08 10:15:47','',''),(2203805,'1','145','826',359,'Retail Sale Id 1298616',39000.00,0.00,0.00,0.00,4800.00,'2021-12-08 10:21:50','',''),(2203806,'1','145','826',359,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-08 10:21:50','',''),(2203961,'1','145','826',359,'Retail Sale Id 1298686',2001.00,0.00,0.00,0.00,348.00,'2021-12-08 10:30:21','',''),(2203962,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-08 10:30:21','',''),(2204053,'1','145','826',359,'Retail Sale Id 1298728',2208.00,0.00,0.00,0.00,384.00,'2021-12-08 10:36:25','',''),(2204054,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.20,0.00,'2021-12-08 10:36:25','',''),(2204064,'1','145','826',359,'Retail Sale Id 1298733',8280.00,0.00,0.00,0.00,1440.00,'2021-12-08 10:37:51','',''),(2204065,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-08 10:37:51','',''),(2204104,'1','145','826',359,'Retail Sale Id 1298757',690.00,0.00,0.00,0.00,120.00,'2021-12-08 10:41:16','',''),(2204105,'1','145','826',359,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 10:41:16','',''),(2204115,'1','145','826',359,'Retail Sale Id 1298764',8970.00,0.00,0.00,0.00,1560.00,'2021-12-08 10:41:49','',''),(2204116,'1','145','826',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-08 10:41:49','',''),(2204147,'1','145','826',359,'Retail Sale Id 1298780',1449.00,0.00,0.00,0.00,252.00,'2021-12-08 10:44:45','',''),(2204148,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-08 10:44:45','',''),(2204240,'1','145','826',359,'Retail Sale Id 1298825',7590.00,0.00,0.00,0.00,1320.00,'2021-12-08 10:53:52','',''),(2204241,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-08 10:53:52','',''),(2204319,'1','145','826',359,'Retail Sale Id 1298864',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 10:59:35','',''),(2204320,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 10:59:35','',''),(2204339,'1','145','826',359,'Retail Sale Id 1298874',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 11:01:14','',''),(2204340,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:01:14','',''),(2204358,'1','145','826',359,'Retail Sale Id 1298882',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 11:03:16','',''),(2204359,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:03:16','',''),(2204492,'1','145','826',359,'Retail Sale Id 1298956',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 11:10:57','',''),(2204493,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:10:57','',''),(2204510,'1','145','826',359,'Retail Sale Id 1298965',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 11:12:25','',''),(2204511,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:12:25','',''),(2204614,'1','145','826',359,'Retail Sale Id 1299016',8970.00,0.00,0.00,0.00,1560.00,'2021-12-08 11:20:28','',''),(2204615,'1','145','826',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-08 11:20:28','',''),(2204634,'1','145','826',359,'Retail Sale Id 1299027',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 11:21:37','',''),(2204635,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 11:21:37','',''),(2204644,'1','145','826',359,'Retail Sale Id 1299035',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 11:22:35','',''),(2204645,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:22:35','',''),(2204692,'1','145','826',359,'Retail Sale Id 1299059',7452.00,0.00,0.00,0.00,1296.00,'2021-12-08 11:26:03','',''),(2204693,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.80,0.00,'2021-12-08 11:26:03','',''),(2204710,'1','145','826',359,'Retail Sale Id 1299067',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 11:27:29','',''),(2204711,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 11:27:29','',''),(2204732,'1','145','826',359,'Retail Sale Id 1299077',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 11:29:09','',''),(2204733,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:29:09','',''),(2204744,'1','145','826',359,'Retail Sale Id 1299083',1449.00,0.00,0.00,0.00,252.00,'2021-12-08 11:30:31','',''),(2204745,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-08 11:30:31','',''),(2204768,'1','145','826',359,'Retail Sale Id 1299098',4485.00,0.00,0.00,0.00,780.00,'2021-12-08 11:32:03','',''),(2204769,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-08 11:32:03','',''),(2204800,'1','145','826',359,'Retail Sale Id 1299116',2760.00,0.00,0.00,0.00,480.00,'2021-12-08 11:34:15','',''),(2204801,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 11:34:15','',''),(2204824,'1','145','826',359,'Retail Sale Id 1299127',1380.00,0.00,0.00,0.00,240.00,'2021-12-08 11:35:36','',''),(2204825,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 11:35:36','',''),(2204844,'1','145','826',359,'Retail Sale Id 1299137',19500.00,0.00,0.00,0.00,2400.00,'2021-12-08 11:36:34','',''),(2204845,'1','145','826',359,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-08 11:36:34','',''),(2204886,'1','145','826',359,'Retail Sale Id 1299160',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 11:38:50','',''),(2204887,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 11:38:50','',''),(2204924,'1','145','826',359,'Retail Sale Id 1299182',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 11:40:31','',''),(2204925,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 11:40:31','',''),(2205060,'1','145','826',359,'Retail Sale Id 1299243',12420.00,0.00,0.00,0.00,2160.00,'2021-12-08 11:49:27','',''),(2205061,'1','145','826',359,'Retail sales',0.00,0.00,0.00,18.00,0.00,'2021-12-08 11:49:27','',''),(2205084,'1','145','826',359,'Retail Sale Id 1299256',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 11:51:58','',''),(2205085,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 11:51:58','',''),(2205208,'1','145','826',359,'Retail Sale Id 1299319',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 12:01:11','',''),(2205209,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 12:01:11','',''),(2205293,'1','145','826',359,'Retail Sale Id 1299348',6900.00,0.00,0.00,0.00,1200.00,'2021-12-08 12:07:40','',''),(2205294,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 12:07:40','',''),(2205329,'1','145','826',359,'Retail Sale Id 1299364',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 12:10:00','',''),(2205330,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 12:10:00','',''),(2205439,'1','145','826',359,'Retail Sale Id 1299414',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 12:18:16','',''),(2205440,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 12:18:16','',''),(2205483,'1','145','826',359,'Retail Sale Id 1299436',4140.00,0.00,0.00,0.00,720.00,'2021-12-08 12:22:43','',''),(2205484,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 12:22:43','',''),(2205493,'1','145','826',359,'Retail Sale Id 1299440',1380.00,0.00,0.00,0.00,240.00,'2021-12-08 12:23:36','',''),(2205494,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 12:23:36','',''),(2205513,'1','145','826',359,'Retail Sale Id 1299451',2001.00,0.00,0.00,0.00,348.00,'2021-12-08 12:24:57','',''),(2205514,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-08 12:24:57','',''),(2205532,'1','145','826',359,'Retail Sale Id 1299462',4002.00,0.00,0.00,0.00,696.00,'2021-12-08 12:26:02','',''),(2205533,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-08 12:26:02','',''),(2205563,'1','145','826',359,'Retail Sale Id 1299482',1449.00,0.00,0.00,0.00,252.00,'2021-12-08 12:29:45','',''),(2205564,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-08 12:29:45','',''),(2205586,'1','145','826',359,'Retail Sale Id 1299488',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 12:31:02','',''),(2205587,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 12:31:02','',''),(2205642,'1','145','826',359,'Retail Sale Id 1299512',2760.00,0.00,0.00,0.00,480.00,'2021-12-08 12:35:16','',''),(2205643,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 12:35:16','',''),(2205648,'1','145','826',359,'Retail Sale Id 1299518',2760.00,0.00,0.00,0.00,480.00,'2021-12-08 12:35:46','',''),(2205649,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 12:35:46','',''),(2205674,'1','145','826',359,'Retail Sale Id 1299530',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 12:37:11','',''),(2205675,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 12:37:11','',''),(2205692,'1','145','826',359,'Retail Sale Id 1299538',34500.00,0.00,0.00,0.00,6000.00,'2021-12-08 12:38:38','',''),(2205693,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 12:38:38','',''),(2205708,'1','145','826',359,'Return of Retail Sale Id 1299538',0.00,34500.00,50.00,0.00,-6000.00,'2021-12-08 12:39:36','',''),(2205725,'1','145','826',359,'Return of Retail Sale Id 1298200',0.00,34500.00,50.00,0.00,-6000.00,'2021-12-08 12:40:29','',''),(2205730,'1','145','826',359,'Retail Sale Id 1299556',65000.00,0.00,0.00,0.00,8000.00,'2021-12-08 12:41:07','',''),(2205731,'1','145','826',359,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-08 12:41:07','',''),(2205752,'1','145','826',359,'Retail Sale Id 1299565',4140.00,0.00,0.00,0.00,720.00,'2021-12-08 12:41:53','',''),(2205753,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 12:41:53','',''),(2205800,'1','145','826',359,'Retail Sale Id 1299588',2001.00,0.00,0.00,0.00,348.00,'2021-12-08 12:45:50','',''),(2205801,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-08 12:45:50','',''),(2205810,'1','145','826',359,'Retail Sale Id 1299598',2760.00,0.00,0.00,0.00,480.00,'2021-12-08 12:46:28','',''),(2205811,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 12:46:28','',''),(2205827,'1','145','826',359,'Retail Sale Id 1299608',38350.00,0.00,0.00,0.00,4720.00,'2021-12-08 12:47:28','',''),(2205828,'1','145','826',359,'Retail sales',0.00,0.00,0.00,59.00,0.00,'2021-12-08 12:47:28','',''),(2205899,'1','145','826',359,'Retail Sale Id 1299621',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 12:49:33','',''),(2205900,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:49:33','',''),(2205933,'1','145','826',359,'Retail Sale Id 1299637',1035.00,0.00,0.00,0.00,180.00,'2021-12-08 12:51:14','',''),(2205934,'1','145','826',359,'Retail sales',0.00,0.00,0.00,1.50,0.00,'2021-12-08 12:51:14','',''),(2205975,'1','145','826',359,'Retail Sale Id 1299653',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 12:54:59','',''),(2205976,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 12:54:59','',''),(2205991,'1','145','826',359,'Retail Sale Id 1299663',4140.00,0.00,0.00,0.00,720.00,'2021-12-08 12:56:09','',''),(2205992,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 12:56:09','',''),(2206092,'1','145','826',359,'Retail Sale Id 1299704',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 13:03:45','',''),(2206093,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:03:45','',''),(2206148,'1','145','826',359,'Retail Sale Id 1299734',4830.00,0.00,0.00,0.00,840.00,'2021-12-08 13:07:45','',''),(2206149,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 13:07:45','',''),(2206197,'1','145','826',359,'Retail Sale Id 1299756',4140.00,0.00,0.00,0.00,720.00,'2021-12-08 13:11:03','',''),(2206198,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 13:11:03','',''),(2206230,'1','145','826',359,'Retail Sale Id 1299773',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 13:13:31','',''),(2206231,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:13:31','',''),(2206261,'1','145','826',359,'Retail Sale Id 1299781',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 13:14:24','',''),(2206262,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:14:24','',''),(2206277,'1','145','826',359,'Retail Sale Id 1299794',4899.00,0.00,0.00,0.00,852.00,'2021-12-08 13:16:34','',''),(2206278,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-08 13:16:34','',''),(2206319,'1','145','826',359,'Retail Sale Id 1299810',1380.00,0.00,0.00,0.00,240.00,'2021-12-08 13:18:31','',''),(2206320,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 13:18:31','',''),(2206365,'1','145','826',359,'Retail Sale Id 1299840',15180.00,0.00,0.00,0.00,2640.00,'2021-12-08 13:22:12','',''),(2206366,'1','145','826',359,'Retail sales',0.00,0.00,0.00,22.00,0.00,'2021-12-08 13:22:12','',''),(2206383,'1','145','826',359,'Retail Sale Id 1299849',4899.00,0.00,0.00,0.00,852.00,'2021-12-08 13:23:55','',''),(2206384,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-08 13:23:55','',''),(2206389,'1','145','826',359,'Retail Sale Id 1299853',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 13:24:52','',''),(2206390,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:24:52','',''),(2206529,'1','145','826',359,'Retail Sale Id 1299906',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 13:31:55','',''),(2206530,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:31:55','',''),(2206570,'1','145','826',359,'Retail Sale Id 1299923',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 13:34:13','',''),(2206571,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 13:34:13','',''),(2206651,'1','145','826',359,'Retail Sale Id 1299960',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 13:39:35','',''),(2206652,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:39:35','',''),(2206769,'1','145','826',359,'Retail Sale Id 1300002',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 13:44:46','',''),(2206770,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:44:46','',''),(2206785,'1','145','826',359,'Retail Sale Id 1300010',6900.00,0.00,0.00,0.00,1200.00,'2021-12-08 13:45:42','',''),(2206786,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 13:45:42','',''),(2206955,'1','145','826',359,'Retail Sale Id 1300071',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 13:55:24','',''),(2206956,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:55:24','',''),(2206997,'1','145','826',359,'Retail Sale Id 1300091',5520.00,0.00,0.00,0.00,960.00,'2021-12-08 13:58:06','',''),(2206998,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-08 13:58:06','',''),(2207055,'1','145','826',359,'Retail Sale Id 1300119',13000.00,0.00,0.00,0.00,1600.00,'2021-12-08 14:02:36','',''),(2207056,'1','145','826',359,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-08 14:02:36','',''),(2207093,'1','145','826',359,'Retail Sale Id 1300135',49680.00,0.00,0.00,0.00,8640.00,'2021-12-08 14:04:51','',''),(2207094,'1','145','826',359,'Retail sales',0.00,0.00,0.00,72.00,0.00,'2021-12-08 14:04:51','',''),(2207110,'1','145','826',359,'Return of Retail Sale Id 1300135',0.00,49680.00,72.00,0.00,-8640.00,'2021-12-08 14:06:17','',''),(2207121,'1','145','826',359,'Retail Sale Id 1300147',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 14:07:03','',''),(2207122,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:07:03','',''),(2207152,'1','145','826',359,'Retail Sale Id 1300156',12765.00,0.00,0.00,0.00,2220.00,'2021-12-08 14:08:34','',''),(2207153,'1','145','826',359,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-08 14:08:34','',''),(2207165,'1','145','826',359,'Retail Sale Id 1300166',6210.00,0.00,0.00,0.00,1080.00,'2021-12-08 14:09:24','',''),(2207166,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-08 14:09:24','',''),(2207187,'1','145','826',359,'Retail Sale Id 1300173',46800.00,0.00,0.00,0.00,5760.00,'2021-12-08 14:10:22','',''),(2207188,'1','145','826',359,'Retail sales',0.00,0.00,0.00,72.00,0.00,'2021-12-08 14:10:22','',''),(2207237,'1','145','826',359,'Retail Sale Id 1300195',4830.00,0.00,0.00,0.00,840.00,'2021-12-08 14:14:38','',''),(2207238,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 14:14:38','',''),(2207259,'1','145','826',359,'Retail Sale Id 1300209',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 14:15:49','',''),(2207260,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:15:49','',''),(2207385,'1','145','826',359,'Retail Sale Id 1300286',155350.00,0.00,0.00,0.00,19120.00,'2021-12-08 14:23:24','',''),(2207386,'1','145','826',359,'Retail sales',0.00,0.00,0.00,239.00,0.00,'2021-12-08 14:23:24','',''),(2207429,'1','145','826',359,'Retail Sale Id 1300301',4140.00,0.00,0.00,0.00,720.00,'2021-12-08 14:24:58','',''),(2207430,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:24:58','',''),(2207500,'1','145','826',359,'Retail Sale Id 1300332',5520.00,0.00,0.00,0.00,960.00,'2021-12-08 14:28:45','',''),(2207501,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-08 14:28:45','',''),(2207574,'1','145','826',359,'Retail Sale Id 1300356',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 14:31:02','',''),(2207575,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 14:31:02','',''),(2207600,'1','145','826',359,'Retail Sale Id 1300364',1449.00,0.00,0.00,0.00,252.00,'2021-12-08 14:31:47','',''),(2207601,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-08 14:31:47','',''),(2207621,'1','145','826',359,'Retail Sale Id 1300374',2484.00,0.00,0.00,0.00,432.00,'2021-12-08 14:32:54','',''),(2207622,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.60,0.00,'2021-12-08 14:32:54','',''),(2207639,'1','145','826',359,'Retail Sale Id 1300381',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 14:33:50','',''),(2207640,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:33:50','',''),(2207651,'1','145','826',359,'Retail Sale Id 1300391',2967.00,0.00,0.00,0.00,516.00,'2021-12-08 14:34:36','',''),(2207652,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.30,0.00,'2021-12-08 14:34:36','',''),(2207670,'1','145','826',359,'Retail Sale Id 1300397',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 14:35:21','',''),(2207671,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:35:21','',''),(2207694,'1','145','826',359,'Retail Sale Id 1300414',55250.00,0.00,0.00,0.00,6800.00,'2021-12-08 14:36:35','',''),(2207695,'1','145','826',359,'Retail sales',0.00,0.00,0.00,85.00,0.00,'2021-12-08 14:36:35','',''),(2207722,'1','145','826',359,'Retail Sale Id 1300426',14300.00,0.00,0.00,0.00,1760.00,'2021-12-08 14:38:24','',''),(2207723,'1','145','826',359,'Retail sales',0.00,0.00,0.00,22.00,0.00,'2021-12-08 14:38:24','',''),(2207746,'1','145','826',359,'Retail Sale Id 1300440',1380.00,0.00,0.00,0.00,240.00,'2021-12-08 14:39:57','',''),(2207747,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 14:39:57','',''),(2207766,'1','145','826',359,'Retail Sale Id 1300448',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 14:41:05','',''),(2207767,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:41:05','',''),(2207780,'1','145','826',359,'Retail Sale Id 1300455',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 14:41:47','',''),(2207781,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:41:47','',''),(2207792,'1','145','826',359,'Retail Sale Id 1300467',2898.00,0.00,0.00,0.00,504.00,'2021-12-08 14:42:40','',''),(2207793,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-08 14:42:40','',''),(2207808,'1','145','826',359,'Retail Sale Id 1300471',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 14:43:18','',''),(2207809,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 14:43:18','',''),(2207839,'1','145','826',359,'Retail Sale Id 1300489',2898.00,0.00,0.00,0.00,504.00,'2021-12-08 14:45:08','',''),(2207840,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-08 14:45:08','',''),(2207855,'1','145','826',359,'Retail Sale Id 1300499',4140.00,0.00,0.00,0.00,720.00,'2021-12-08 14:45:54','',''),(2207856,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:45:54','',''),(2207881,'1','145','826',359,'Retail Sale Id 1300504',6210.00,0.00,0.00,0.00,1080.00,'2021-12-08 14:47:35','',''),(2207882,'1','145','826',359,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-08 14:47:35','',''),(2207901,'1','145','826',359,'Retail Sale Id 1300527',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 14:48:39','',''),(2207902,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:48:39','',''),(2207919,'1','145','826',359,'Retail Sale Id 1300536',1449.00,0.00,0.00,0.00,252.00,'2021-12-08 14:49:25','',''),(2207920,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-08 14:49:25','',''),(2207935,'1','145','826',359,'Retail Sale Id 1300544',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 14:50:43','',''),(2207936,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:50:43','',''),(2207949,'1','145','826',359,'Retail Sale Id 1300552',1380.00,0.00,0.00,0.00,240.00,'2021-12-08 14:51:43','',''),(2207950,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 14:51:43','',''),(2207971,'1','145','826',359,'Retail Sale Id 1300561',6900.00,0.00,0.00,0.00,1200.00,'2021-12-08 14:52:35','',''),(2207972,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 14:52:35','',''),(2207987,'1','145','826',359,'Retail Sale Id 1300571',4140.00,0.00,0.00,0.00,720.00,'2021-12-08 14:53:59','',''),(2207988,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:53:59','',''),(2208005,'1','145','826',359,'Retail Sale Id 1300578',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 14:54:54','',''),(2208006,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:54:54','',''),(2208025,'1','145','826',359,'Retail Sale Id 1300585',2070.00,0.00,0.00,0.00,360.00,'2021-12-08 14:56:15','',''),(2208026,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:56:16','',''),(2208043,'1','145','826',359,'Retail Sale Id 1300594',4140.00,0.00,0.00,0.00,720.00,'2021-12-08 14:58:02','',''),(2208044,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:58:02','',''),(2208049,'1','145','826',359,'Retail Sale Id 1300598',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 14:58:50','',''),(2208050,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:58:50','',''),(2208081,'1','145','826',359,'Retail Sale Id 1300613',4140.00,0.00,0.00,0.00,720.00,'2021-12-08 15:01:18','',''),(2208082,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:01:18','',''),(2208138,'1','145','826',359,'Retail Sale Id 1300634',6900.00,0.00,0.00,0.00,1200.00,'2021-12-08 15:04:59','',''),(2208139,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 15:04:59','',''),(2208191,'1','145','826',359,'Retail Sale Id 1300654',8556.00,0.00,0.00,0.00,1488.00,'2021-12-08 15:08:17','',''),(2208192,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.40,0.00,'2021-12-08 15:08:17','',''),(2208209,'1','145','826',359,'Retail Sale Id 1300663',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 15:09:27','',''),(2208210,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 15:09:27','',''),(2208263,'1','145','826',359,'Retail Sale Id 1300685',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 15:12:06','',''),(2208264,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:12:06','',''),(2208283,'1','145','826',359,'Retail Sale Id 1300696',4140.00,0.00,0.00,0.00,720.00,'2021-12-08 15:13:18','',''),(2208284,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:13:18','',''),(2208313,'1','145','826',359,'Retail Sale Id 1300714',8450.00,0.00,0.00,0.00,1040.00,'2021-12-08 15:15:03','',''),(2208314,'1','145','826',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-08 15:15:03','',''),(2208333,'1','145','826',359,'Retail Sale Id 1300723',8694.00,0.00,0.00,0.00,1512.00,'2021-12-08 15:16:31','',''),(2208334,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.60,0.00,'2021-12-08 15:16:31','',''),(2208353,'1','145','826',359,'Retail Sale Id 1300736',2760.00,0.00,0.00,0.00,480.00,'2021-12-08 15:17:49','',''),(2208354,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 15:17:49','',''),(2208381,'1','145','826',359,'Retail Sale Id 1300744',6900.00,0.00,0.00,0.00,1200.00,'2021-12-08 15:18:42','',''),(2208382,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 15:18:42','',''),(2208395,'1','145','826',359,'Retail Sale Id 1300753',7590.00,0.00,0.00,0.00,1320.00,'2021-12-08 15:19:31','',''),(2208396,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-08 15:19:31','',''),(2208419,'1','145','826',359,'Retail Sale Id 1300758',4830.00,0.00,0.00,0.00,840.00,'2021-12-08 15:20:16','',''),(2208420,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 15:20:16','',''),(2208435,'1','145','826',359,'Retail Sale Id 1300771',5520.00,0.00,0.00,0.00,960.00,'2021-12-08 15:21:20','',''),(2208436,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-08 15:21:20','',''),(2208460,'1','145','826',359,'Retail Sale Id 1300777',2967.00,0.00,0.00,0.00,516.00,'2021-12-08 15:22:16','',''),(2208461,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.30,0.00,'2021-12-08 15:22:16','',''),(2208472,'1','145','826',359,'Retail Sale Id 1300788',2208.00,0.00,0.00,0.00,384.00,'2021-12-08 15:23:02','',''),(2208473,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.20,0.00,'2021-12-08 15:23:02','',''),(2208498,'1','145','826',359,'Retail Sale Id 1300801',8280.00,0.00,0.00,0.00,1440.00,'2021-12-08 15:24:56','',''),(2208499,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-08 15:24:56','',''),(2208522,'1','145','826',359,'Retail Sale Id 1300812',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 15:25:50','',''),(2208523,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:25:50','',''),(2208540,'1','145','826',359,'Retail Sale Id 1300821',11040.00,0.00,0.00,0.00,1920.00,'2021-12-08 15:26:53','',''),(2208541,'1','145','826',359,'Retail sales',0.00,0.00,0.00,16.00,0.00,'2021-12-08 15:26:53','',''),(2208564,'1','145','826',359,'Retail Sale Id 1300833',2898.00,0.00,0.00,0.00,504.00,'2021-12-08 15:28:17','',''),(2208565,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-08 15:28:17','',''),(2208588,'1','145','826',359,'Retail Sale Id 1300844',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 15:29:09','',''),(2208589,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 15:29:09','',''),(2208655,'1','145','826',359,'Retail Sale Id 1300878',4140.00,0.00,0.00,0.00,720.00,'2021-12-08 15:32:38','',''),(2208656,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:32:38','',''),(2208701,'1','145','826',359,'Retail Sale Id 1300903',2760.00,0.00,0.00,0.00,480.00,'2021-12-08 15:34:54','',''),(2208702,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 15:34:54','',''),(2208731,'1','145','826',359,'Retail Sale Id 1300923',2001.00,0.00,0.00,0.00,348.00,'2021-12-08 15:36:14','',''),(2208732,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-08 15:36:14','',''),(2208777,'1','145','826',359,'Retail Sale Id 1300943',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 15:38:24','',''),(2208778,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:38:24','',''),(2208867,'1','145','826',359,'Retail Sale Id 1300992',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 15:43:03','',''),(2208868,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 15:43:03','',''),(2208941,'1','145','826',359,'Retail Sale Id 1301034',11385.00,0.00,0.00,0.00,1980.00,'2021-12-08 15:47:03','',''),(2208942,'1','145','826',359,'Retail sales',0.00,0.00,0.00,16.50,0.00,'2021-12-08 15:47:03','',''),(2208997,'1','145','826',359,'Retail Sale Id 1301060',2760.00,0.00,0.00,0.00,480.00,'2021-12-08 15:50:35','',''),(2208998,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 15:50:35','',''),(2209055,'1','145','826',359,'Retail Sale Id 1301077',8694.00,0.00,0.00,0.00,1512.00,'2021-12-08 15:53:15','',''),(2209056,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.60,0.00,'2021-12-08 15:53:15','',''),(2209247,'1','145','826',359,'Retail Sale Id 1301182',3450.00,0.00,0.00,0.00,600.00,'2021-12-08 16:03:13','',''),(2209248,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:03:13','',''),(2209704,'1','145','826',359,'Retail Sale Id 1301387',1449.00,0.00,0.00,0.00,252.00,'2021-12-08 16:22:44','',''),(2209705,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-08 16:22:44','',''),(2209757,'1','145','826',359,'Retail Sale Id 1301419',4140.00,0.00,0.00,0.00,720.00,'2021-12-08 16:25:16','',''),(2209758,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:25:16','',''),(2209782,'1','145','826',359,'Retail Sale Id 1301458',12765.00,0.00,0.00,0.00,2220.00,'2021-12-08 16:28:27','',''),(2209783,'1','145','826',359,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-08 16:28:27','',''),(2209819,'1','145','826',359,'Retail Sale Id 1301566',6900.00,0.00,0.00,0.00,1200.00,'2021-12-08 16:29:40','',''),(2209820,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 16:29:40','',''),(2209905,'1','145','826',359,'Retail Sale Id 1301604',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 16:33:40','',''),(2209906,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:33:40','',''),(2210199,'1','145','826',359,'Retail Sale Id 1301751',8625.00,0.00,0.00,0.00,1500.00,'2021-12-08 16:47:39','',''),(2210200,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:47:40','',''),(2212452,'1','145','826',359,'Retail Sale Id 1302568',8625.00,0.00,0.00,0.00,1500.00,'2021-12-09 06:39:34','',''),(2212453,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 06:39:34','',''),(2212480,'1','145','826',359,'Retail Sale Id 1302579',2760.00,0.00,0.00,0.00,480.00,'2021-12-09 06:40:52','',''),(2212481,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 06:40:52','',''),(2212504,'1','145','826',359,'Retail Sale Id 1302591',2760.00,0.00,0.00,0.00,480.00,'2021-12-09 06:42:08','',''),(2212505,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 06:42:08','',''),(2212518,'1','145','826',359,'Retail Sale Id 1302598',2760.00,0.00,0.00,0.00,480.00,'2021-12-09 06:42:54','',''),(2212519,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 06:42:54','',''),(2212548,'1','145','826',359,'Retail Sale Id 1302612',8280.00,0.00,0.00,0.00,1440.00,'2021-12-09 06:44:34','',''),(2212549,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-09 06:44:34','',''),(2212569,'1','145','826',359,'Retail Sale Id 1302620',4140.00,0.00,0.00,0.00,720.00,'2021-12-09 06:45:25','',''),(2212570,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 06:45:25','',''),(2212575,'1','145','826',359,'Retail Sale Id 1302625',26000.00,0.00,0.00,0.00,3200.00,'2021-12-09 06:46:17','',''),(2212576,'1','145','826',359,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-09 06:46:17','',''),(2212613,'1','145','826',359,'Retail Sale Id 1302642',7590.00,0.00,0.00,0.00,1320.00,'2021-12-09 06:47:40','',''),(2212614,'1','145','826',359,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-09 06:47:40','',''),(2212636,'1','145','826',359,'Retail Sale Id 1302655',8694.00,0.00,0.00,0.00,1512.00,'2021-12-09 06:49:21','',''),(2212637,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.60,0.00,'2021-12-09 06:49:21','',''),(2212654,'1','145','826',359,'Retail Sale Id 1302661',2001.00,0.00,0.00,0.00,348.00,'2021-12-09 06:50:07','',''),(2212655,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-09 06:50:07','',''),(2212668,'1','145','826',359,'Retail Sale Id 1302671',4002.00,0.00,0.00,0.00,696.00,'2021-12-09 06:50:44','',''),(2212669,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-09 06:50:44','',''),(2212780,'1','145','826',359,'Retail Sale Id 1302715',2001.00,0.00,0.00,0.00,348.00,'2021-12-09 06:57:28','',''),(2212781,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-09 06:57:28','',''),(2212806,'1','145','826',359,'Retail Sale Id 1302724',22750.00,0.00,0.00,0.00,2800.00,'2021-12-09 06:58:29','',''),(2212807,'1','145','826',359,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-09 06:58:29','',''),(2212866,'1','145','826',359,'Retail Sale Id 1302757',2070.00,0.00,0.00,0.00,360.00,'2021-12-09 07:01:49','',''),(2212867,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 07:01:49','',''),(2212914,'1','145','826',359,'Retail Sale Id 1302783',13110.00,0.00,0.00,0.00,2280.00,'2021-12-09 07:05:00','',''),(2212915,'1','145','826',359,'Retail sales',0.00,0.00,0.00,19.00,0.00,'2021-12-09 07:05:00','',''),(2212949,'1','145','826',359,'Retail Sale Id 1302798',11050.00,0.00,0.00,0.00,1360.00,'2021-12-09 07:06:43','',''),(2212950,'1','145','826',359,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-09 07:06:43','',''),(2212987,'1','145','826',359,'Retail Sale Id 1302811',8625.00,0.00,0.00,0.00,1500.00,'2021-12-09 07:08:57','',''),(2212988,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:08:57','',''),(2213009,'1','145','826',359,'Retail Sale Id 1302817',2070.00,0.00,0.00,0.00,360.00,'2021-12-09 07:09:34','',''),(2213010,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 07:09:34','',''),(2213055,'1','145','826',359,'Retail Sale Id 1302844',65000.00,0.00,0.00,0.00,8000.00,'2021-12-09 07:12:29','',''),(2213056,'1','145','826',359,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-09 07:12:29','',''),(2213093,'1','145','826',359,'Retail Sale Id 1302860',32500.00,0.00,0.00,0.00,4000.00,'2021-12-09 07:14:20','',''),(2213094,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 07:14:20','',''),(2213122,'1','145','826',359,'Retail Sale Id 1302877',37700.00,0.00,0.00,0.00,4640.00,'2021-12-09 07:15:26','',''),(2213123,'1','145','826',359,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-09 07:15:26','',''),(2213159,'1','145','826',359,'Retail Sale Id 1302891',2070.00,0.00,0.00,0.00,360.00,'2021-12-09 07:16:36','',''),(2213160,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 07:16:36','',''),(2213182,'1','145','826',359,'Retail Sale Id 1302900',4830.00,0.00,0.00,0.00,840.00,'2021-12-09 07:17:21','',''),(2213183,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-09 07:17:21','',''),(2213216,'1','145','826',359,'Retail Sale Id 1302917',3450.00,0.00,0.00,0.00,600.00,'2021-12-09 07:19:01','',''),(2213217,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:19:01','',''),(2213296,'1','145','826',359,'Retail Sale Id 1302952',4968.00,0.00,0.00,0.00,864.00,'2021-12-09 07:21:50','',''),(2213297,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.20,0.00,'2021-12-09 07:21:50','',''),(2213318,'1','145','826',359,'Retail Sale Id 1302963',8625.00,0.00,0.00,0.00,1500.00,'2021-12-09 07:22:51','',''),(2213319,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:22:51','',''),(2213364,'1','145','826',359,'Retail Sale Id 1302986',44265.00,0.00,0.00,0.00,5448.00,'2021-12-09 07:25:16','',''),(2213365,'1','145','826',359,'Retail sales',0.00,0.00,0.00,68.10,0.00,'2021-12-09 07:25:16','',''),(2213408,'1','145','826',359,'Retail Sale Id 1303012',8625.00,0.00,0.00,0.00,1500.00,'2021-12-09 07:27:21','',''),(2213409,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:27:21','',''),(2213434,'1','145','826',359,'Retail Sale Id 1303026',2001.00,0.00,0.00,0.00,348.00,'2021-12-09 07:28:46','',''),(2213435,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-09 07:28:46','',''),(2213470,'1','145','826',359,'Retail Sale Id 1303042',1380.00,0.00,0.00,0.00,240.00,'2021-12-09 07:30:04','',''),(2213471,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 07:30:04','',''),(2213490,'1','145','826',359,'Retail Sale Id 1303051',4830.00,0.00,0.00,0.00,840.00,'2021-12-09 07:31:05','',''),(2213491,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-09 07:31:05','',''),(2213556,'1','145','826',359,'Retail Sale Id 1303082',2070.00,0.00,0.00,0.00,360.00,'2021-12-09 07:34:09','',''),(2213557,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 07:34:09','',''),(2213614,'1','145','826',359,'Retail Sale Id 1303112',3450.00,0.00,0.00,0.00,600.00,'2021-12-09 07:37:01','',''),(2213615,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:37:01','',''),(2213648,'1','145','826',359,'Retail Sale Id 1303130',3450.00,0.00,0.00,0.00,600.00,'2021-12-09 07:38:55','',''),(2213649,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:38:55','',''),(2213674,'1','145','826',359,'Retail Sale Id 1303145',4140.00,0.00,0.00,0.00,720.00,'2021-12-09 07:40:47','',''),(2213675,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 07:40:47','',''),(2213699,'1','145','826',359,'Retail Sale Id 1303155',32500.00,0.00,0.00,0.00,4000.00,'2021-12-09 07:41:50','',''),(2213700,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 07:41:50','',''),(2213760,'1','145','826',359,'Retail Sale Id 1303178',2070.00,0.00,0.00,0.00,360.00,'2021-12-09 07:44:02','',''),(2213761,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 07:44:02','',''),(2213790,'1','145','826',359,'Retail Sale Id 1303196',3450.00,0.00,0.00,0.00,600.00,'2021-12-09 07:45:58','',''),(2213793,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:45:58','',''),(2213828,'1','145','826',359,'Retail Sale Id 1303210',8970.00,0.00,0.00,0.00,1560.00,'2021-12-09 07:47:48','',''),(2213829,'1','145','826',359,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-09 07:47:48','',''),(2213862,'1','145','826',359,'Retail Sale Id 1303231',2484.00,0.00,0.00,0.00,432.00,'2021-12-09 07:49:30','',''),(2213863,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.60,0.00,'2021-12-09 07:49:30','',''),(2213882,'1','145','826',359,'Retail Sale Id 1303237',8280.00,0.00,0.00,0.00,1440.00,'2021-12-09 07:50:50','',''),(2213883,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-09 07:50:50','',''),(2213910,'1','145','826',359,'Retail Sale Id 1303254',2760.00,0.00,0.00,0.00,480.00,'2021-12-09 07:52:36','',''),(2213912,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 07:52:36','',''),(2213958,'1','145','826',359,'Retail Sale Id 1303273',3450.00,0.00,0.00,0.00,600.00,'2021-12-09 07:53:59','',''),(2213959,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:53:59','',''),(2213980,'1','145','826',359,'Retail Sale Id 1303283',4140.00,0.00,0.00,0.00,720.00,'2021-12-09 07:55:29','',''),(2213981,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 07:55:29','',''),(2214046,'1','145','826',359,'Retail Sale Id 1303322',8625.00,0.00,0.00,0.00,1500.00,'2021-12-09 08:00:09','',''),(2214047,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:00:09','',''),(2214076,'1','145','826',359,'Retail Sale Id 1303336',1449.00,0.00,0.00,0.00,252.00,'2021-12-09 08:01:56','',''),(2214077,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-09 08:01:56','',''),(2214098,'1','145','826',359,'Retail Sale Id 1303350',8625.00,0.00,0.00,0.00,1500.00,'2021-12-09 08:03:21','',''),(2214099,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:03:21','',''),(2214116,'1','145','826',359,'Retail Sale Id 1303360',3450.00,0.00,0.00,0.00,600.00,'2021-12-09 08:04:19','',''),(2214117,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 08:04:19','',''),(2214134,'1','145','826',359,'Retail Sale Id 1303368',3795.00,0.00,0.00,0.00,660.00,'2021-12-09 08:05:15','',''),(2214135,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-09 08:05:15','',''),(2214276,'1','145','826',359,'Retail Sale Id 1303443',3450.00,0.00,0.00,0.00,600.00,'2021-12-09 08:12:32','',''),(2214277,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 08:12:32','',''),(2214292,'1','145','826',359,'Retail Sale Id 1303450',2001.00,0.00,0.00,0.00,348.00,'2021-12-09 08:13:43','',''),(2214293,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-09 08:13:43','',''),(2214328,'1','145','826',359,'Retail Sale Id 1303472',4140.00,0.00,0.00,0.00,720.00,'2021-12-09 08:15:14','',''),(2214329,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 08:15:14','',''),(2214346,'1','145','826',359,'Retail Sale Id 1303481',8280.00,0.00,0.00,0.00,1440.00,'2021-12-09 08:16:09','',''),(2214347,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-09 08:16:10','',''),(2214393,'1','145','826',359,'Retail Sale Id 1303497',38480.00,0.00,0.00,0.00,4736.00,'2021-12-09 08:18:05','',''),(2214394,'1','145','826',359,'Retail sales',0.00,0.00,0.00,59.20,0.00,'2021-12-09 08:18:05','',''),(2214404,'1','145','826',359,'Retail Sale Id 1303502',3450.00,0.00,0.00,0.00,600.00,'2021-12-09 08:18:50','',''),(2214405,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 08:18:50','',''),(2214506,'1','145','826',359,'Retail Sale Id 1303542',3450.00,0.00,0.00,0.00,600.00,'2021-12-09 08:23:39','',''),(2214507,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 08:23:39','',''),(2214610,'1','145','826',359,'Retail Sale Id 1303580',3795.00,0.00,0.00,0.00,660.00,'2021-12-09 08:27:48','',''),(2214611,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-09 08:27:48','',''),(2214687,'1','145','826',359,'Retail Sale Id 1303611',2760.00,0.00,0.00,0.00,480.00,'2021-12-09 08:30:48','',''),(2214688,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 08:30:48','',''),(2214764,'1','145','826',359,'Retail Sale Id 1303654',1449.00,0.00,0.00,0.00,252.00,'2021-12-09 08:34:58','',''),(2214765,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-09 08:34:58','',''),(2214772,'1','145','826',359,'Retail Sale Id 1303659',5520.00,0.00,0.00,0.00,960.00,'2021-12-09 08:35:36','',''),(2214773,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-09 08:35:36','',''),(2214788,'1','145','826',359,'Retail Sale Id 1303670',1380.00,0.00,0.00,0.00,240.00,'2021-12-09 08:36:39','',''),(2214789,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 08:36:39','',''),(2214817,'1','145','826',359,'Retail Sale Id 1303683',4002.00,0.00,0.00,0.00,696.00,'2021-12-09 08:38:11','',''),(2214818,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-09 08:38:11','',''),(2214859,'1','145','826',359,'Retail Sale Id 1303700',2070.00,0.00,0.00,0.00,360.00,'2021-12-09 08:39:26','',''),(2214860,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 08:39:26','',''),(2214873,'1','145','826',359,'Retail Sale Id 1303708',2070.00,0.00,0.00,0.00,360.00,'2021-12-09 08:40:07','',''),(2214874,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 08:40:07','',''),(2214897,'1','145','826',359,'Retail Sale Id 1303719',8625.00,0.00,0.00,0.00,1500.00,'2021-12-09 08:41:05','',''),(2214898,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:41:05','',''),(2214943,'1','145','826',359,'Retail Sale Id 1303741',1380.00,0.00,0.00,0.00,240.00,'2021-12-09 08:43:21','',''),(2214944,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 08:43:21','',''),(2214993,'1','145','826',359,'Retail Sale Id 1303761',8625.00,0.00,0.00,0.00,1500.00,'2021-12-09 08:45:20','',''),(2214994,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:45:20','',''),(2215020,'1','145','826',359,'Retail Sale Id 1303772',5520.00,0.00,0.00,0.00,960.00,'2021-12-09 08:47:02','',''),(2215021,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-09 08:47:02','',''),(2215052,'1','145','826',359,'Retail Sale Id 1303784',8625.00,0.00,0.00,0.00,1500.00,'2021-12-09 08:48:23','',''),(2215053,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:48:23','',''),(2215080,'1','145','826',359,'Retail Sale Id 1303799',1380.00,0.00,0.00,0.00,240.00,'2021-12-09 08:50:30','',''),(2215081,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 08:50:30','',''),(2215094,'1','145','826',359,'Retail Sale Id 1303809',8625.00,0.00,0.00,0.00,1500.00,'2021-12-09 08:51:58','',''),(2215095,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:51:58','',''),(2215110,'1','145','826',359,'Retail Sale Id 1303816',3450.00,0.00,0.00,0.00,600.00,'2021-12-09 08:52:49','',''),(2215111,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 08:52:49','',''),(2215140,'1','145','826',359,'Retail Sale Id 1303831',4830.00,0.00,0.00,0.00,840.00,'2021-12-09 08:54:36','',''),(2215141,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-09 08:54:36','',''),(2215156,'1','145','826',359,'Retail Sale Id 1303838',4002.00,0.00,0.00,0.00,696.00,'2021-12-09 08:55:36','',''),(2215157,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-09 08:55:36','',''),(2215224,'1','145','826',359,'Retail Sale Id 1303877',6900.00,0.00,0.00,0.00,1200.00,'2021-12-09 09:00:03','',''),(2215225,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 09:00:03','',''),(2215283,'1','145','826',359,'Retail Sale Id 1303901',2760.00,0.00,0.00,0.00,480.00,'2021-12-09 09:02:43','',''),(2215284,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 09:02:43','',''),(2215301,'1','145','826',359,'Retail Sale Id 1303914',4140.00,0.00,0.00,0.00,720.00,'2021-12-09 09:03:49','',''),(2215302,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 09:03:49','',''),(2215326,'1','145','826',359,'Retail Sale Id 1303927',4002.00,0.00,0.00,0.00,696.00,'2021-12-09 09:05:32','',''),(2215327,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.80,0.00,'2021-12-09 09:05:32','',''),(2215354,'1','145','826',359,'Retail Sale Id 1303942',8625.00,0.00,0.00,0.00,1500.00,'2021-12-09 09:07:29','',''),(2215355,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:07:29','',''),(2215398,'1','145','826',359,'Retail Sale Id 1303966',1449.00,0.00,0.00,0.00,252.00,'2021-12-09 09:09:50','',''),(2215399,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-09 09:09:50','',''),(2215484,'1','145','826',359,'Retail Sale Id 1304008',1380.00,0.00,0.00,0.00,240.00,'2021-12-09 09:15:52','',''),(2215485,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 09:15:52','',''),(2215509,'1','145','826',359,'Retail Sale Id 1304018',2001.00,0.00,0.00,0.00,348.00,'2021-12-09 09:17:18','',''),(2215510,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-09 09:17:19','',''),(2215609,'1','145','826',359,'Retail Sale Id 1304073',3450.00,0.00,0.00,0.00,600.00,'2021-12-09 09:22:49','',''),(2215610,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 09:22:49','',''),(2215642,'1','145','826',359,'Retail Sale Id 1304086',1725.00,0.00,0.00,0.00,300.00,'2021-12-09 09:23:57','',''),(2215643,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-09 09:23:57','',''),(2215668,'1','145','826',359,'Retail Sale Id 1304101',32500.00,0.00,0.00,0.00,4000.00,'2021-12-09 09:25:17','',''),(2215669,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 09:25:17','',''),(2215716,'1','145','826',359,'Retail Sale Id 1304126',4830.00,0.00,0.00,0.00,840.00,'2021-12-09 09:28:03','',''),(2215717,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-09 09:28:03','',''),(2215778,'1','145','826',359,'Retail Sale Id 1304152',2070.00,0.00,0.00,0.00,360.00,'2021-12-09 09:31:58','',''),(2215779,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 09:31:58','',''),(2215808,'1','145','826',359,'Retail Sale Id 1304171',32500.00,0.00,0.00,0.00,4000.00,'2021-12-09 09:33:34','',''),(2215809,'1','145','826',359,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 09:33:34','',''),(2215907,'1','145','826',359,'Retail Sale Id 1304210',16560.00,0.00,0.00,0.00,2880.00,'2021-12-09 09:37:07','',''),(2215908,'1','145','826',359,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-09 09:37:07','',''),(2215931,'1','145','826',359,'Retail Sale Id 1304221',8625.00,0.00,0.00,0.00,1500.00,'2021-12-09 09:37:57','',''),(2215932,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:37:57','',''),(2215953,'1','145','826',359,'Retail Sale Id 1304232',2760.00,0.00,0.00,0.00,480.00,'2021-12-09 09:39:52','',''),(2215954,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 09:39:52','',''),(2215980,'1','145','826',359,'Retail Sale Id 1304240',4830.00,0.00,0.00,0.00,840.00,'2021-12-09 09:40:55','',''),(2215981,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-09 09:40:55','',''),(2216053,'1','145','826',359,'Retail Sale Id 1304261',6900.00,0.00,0.00,0.00,1200.00,'2021-12-09 09:43:57','',''),(2216054,'1','145','826',359,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 09:43:57','',''),(2216123,'1','145','826',359,'Retail Sale Id 1304278',1380.00,0.00,0.00,0.00,240.00,'2021-12-09 09:46:29','',''),(2216124,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 09:46:29','',''),(2216227,'1','145','826',359,'Retail Sale Id 1304335',2070.00,0.00,0.00,0.00,360.00,'2021-12-09 09:52:53','',''),(2216228,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 09:52:53','',''),(2216288,'1','145','826',359,'Retail Sale Id 1304355',2001.00,0.00,0.00,0.00,348.00,'2021-12-09 09:55:12','',''),(2216289,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-09 09:55:12','',''),(2216408,'1','145','826',359,'Retail Sale Id 1304411',4899.00,0.00,0.00,0.00,852.00,'2021-12-09 10:00:24','',''),(2216409,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.10,0.00,'2021-12-09 10:00:24','',''),(2216438,'1','145','826',359,'Retail Sale Id 1304424',8625.00,0.00,0.00,0.00,1500.00,'2021-12-09 10:01:54','',''),(2216439,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:01:54','',''),(2216449,'1','145','826',359,'Retail Sale Id 1304430',4140.00,0.00,0.00,0.00,720.00,'2021-12-09 10:03:02','',''),(2216450,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 10:03:02','',''),(2216477,'1','145','826',359,'Retail Sale Id 1304447',5520.00,0.00,0.00,0.00,960.00,'2021-12-09 10:04:57','',''),(2216478,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-09 10:04:57','',''),(2216513,'1','145','826',359,'Retail Sale Id 1304462',4140.00,0.00,0.00,0.00,720.00,'2021-12-09 10:06:22','',''),(2216514,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 10:06:22','',''),(2216603,'1','145','826',359,'Retail Sale Id 1304512',4830.00,0.00,0.00,0.00,840.00,'2021-12-09 10:12:36','',''),(2216604,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-09 10:12:36','',''),(2216615,'1','145','826',359,'Retail Sale Id 1304517',4830.00,0.00,0.00,0.00,840.00,'2021-12-09 10:13:18','',''),(2216616,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-09 10:13:18','',''),(2216739,'1','145','826',359,'Retail Sale Id 1304589',8625.00,0.00,0.00,0.00,1500.00,'2021-12-09 10:22:24','',''),(2216740,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:22:24','',''),(2216903,'1','145','826',359,'Retail Sale Id 1304673',2070.00,0.00,0.00,0.00,360.00,'2021-12-09 10:31:50','',''),(2216904,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 10:31:50','',''),(2216921,'1','145','826',359,'Retail Sale Id 1304685',2760.00,0.00,0.00,0.00,480.00,'2021-12-09 10:33:28','',''),(2216922,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 10:33:28','',''),(2216990,'1','145','826',359,'Retail Sale Id 1304719',14490.00,0.00,0.00,0.00,2520.00,'2021-12-09 10:38:51','',''),(2216991,'1','145','826',359,'Retail sales',0.00,0.00,0.00,21.00,0.00,'2021-12-09 10:38:51','',''),(2217120,'1','145','826',359,'Retail Sale Id 1304790',3450.00,0.00,0.00,0.00,600.00,'2021-12-09 10:47:26','',''),(2217121,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 10:47:26','',''),(2217307,'1','145','826',359,'Retail Sale Id 1304885',8625.00,0.00,0.00,0.00,1500.00,'2021-12-09 11:00:04','',''),(2217308,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:00:04','',''),(2217329,'1','145','826',359,'Retail Sale Id 1304892',5520.00,0.00,0.00,0.00,960.00,'2021-12-09 11:00:48','',''),(2217330,'1','145','826',359,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-09 11:00:48','',''),(2217372,'1','145','826',359,'Retail Sale Id 1304913',15600.00,0.00,0.00,0.00,1920.00,'2021-12-09 11:03:32','',''),(2217373,'1','145','826',359,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-09 11:03:32','',''),(2217390,'1','145','826',359,'Retail Sale Id 1304922',4140.00,0.00,0.00,0.00,720.00,'2021-12-09 11:05:09','',''),(2217391,'1','145','826',359,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 11:05:09','',''),(2217416,'1','145','826',359,'Retail Sale Id 1304938',2760.00,0.00,0.00,0.00,480.00,'2021-12-09 11:06:48','',''),(2217417,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 11:06:48','',''),(2217430,'1','145','826',359,'Retail Sale Id 1304945',8280.00,0.00,0.00,0.00,1440.00,'2021-12-09 11:07:39','',''),(2217431,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-09 11:07:39','',''),(2217540,'1','145','826',359,'Retail Sale Id 1304994',2070.00,0.00,0.00,0.00,360.00,'2021-12-09 11:16:33','',''),(2217541,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:16:33','',''),(2217548,'1','145','826',359,'Retail Sale Id 1305002',3450.00,0.00,0.00,0.00,600.00,'2021-12-09 11:17:33','',''),(2217549,'1','145','826',359,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 11:17:33','',''),(2217636,'1','145','826',359,'Retail Sale Id 1305040',4830.00,0.00,0.00,0.00,840.00,'2021-12-09 11:21:45','',''),(2217637,'1','145','826',359,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-09 11:21:45','',''),(2217817,'1','145','826',359,'Retail Sale Id 1305123',17250.00,0.00,0.00,0.00,3000.00,'2021-12-09 11:31:29','',''),(2217818,'1','145','826',359,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 11:31:29','',''),(2217845,'1','145','826',359,'Retail Sale Id 1305140',2070.00,0.00,0.00,0.00,360.00,'2021-12-09 11:33:03','',''),(2217846,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:33:03','',''),(2217884,'1','145','826',359,'Retail Sale Id 1305160',8280.00,0.00,0.00,0.00,1440.00,'2021-12-09 11:35:56','',''),(2217885,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-09 11:35:56','',''),(2217907,'1','145','826',359,'Retail Sale Id 1305171',2760.00,0.00,0.00,0.00,480.00,'2021-12-09 11:37:44','',''),(2217908,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 11:37:44','',''),(2217935,'1','145','826',359,'Retail Sale Id 1305183',1449.00,0.00,0.00,0.00,252.00,'2021-12-09 11:39:03','',''),(2217936,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-09 11:39:03','',''),(2217949,'1','145','826',359,'Retail Sale Id 1305188',8625.00,0.00,0.00,0.00,1500.00,'2021-12-09 11:40:30','',''),(2217950,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:40:30','',''),(2218000,'1','145','826',359,'Retail Sale Id 1305217',2070.00,0.00,0.00,0.00,360.00,'2021-12-09 11:44:36','',''),(2218001,'1','145','826',359,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:44:36','',''),(2218030,'1','145','826',359,'Retail Sale Id 1305229',2829.00,0.00,0.00,0.00,492.00,'2021-12-09 11:45:59','',''),(2218031,'1','145','826',359,'Retail sales',0.00,0.00,0.00,4.10,0.00,'2021-12-09 11:45:59','',''),(2218062,'1','145','826',359,'Retail Sale Id 1305235',1380.00,0.00,0.00,0.00,240.00,'2021-12-09 11:47:34','',''),(2218063,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 11:47:34','',''),(2218190,'1','145','826',359,'Retail Sale Id 1305309',8625.00,0.00,0.00,0.00,1500.00,'2021-12-09 11:55:26','',''),(2218191,'1','145','826',359,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:55:26','',''),(2218232,'1','145','826',359,'Retail Sale Id 1305336',2001.00,0.00,0.00,0.00,348.00,'2021-12-09 11:58:19','',''),(2218233,'1','145','826',359,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-09 11:58:19','',''),(2218345,'1','145','826',359,'Retail Sale Id 1305393',13800.00,0.00,0.00,0.00,2400.00,'2021-12-09