-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_144
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_144`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_144` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_144`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3220 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2843,400117,'',0,'22','1','144','PURCHASES','','2020-10-11 12:18:13',5,0.00,0.00,'','479','2020-10-11 12:18:13','479',0,1),(2844,20033,'',0,'20','1','144','SALES','','2020-10-11 12:18:32',5,0.00,0.00,'','479','2020-10-11 12:18:32','479',0,1),(2845,400211,'',0,'24','1','144','SALARIES & WAGES','','2020-10-11 12:19:24',5,0.00,0.00,'','479','2020-10-11 12:19:24','479',0,1),(2846,400212,'',0,'24','1','144','PURCHASES','','2020-10-11 12:19:45',5,0.00,0.00,'','479','2020-10-11 12:19:45','479',0,1),(2847,400284,'',0,'2','1','144','DANKANO-EBILLS(ZNB:1014717618)','','2020-10-11 12:21:41',5,0.00,0.00,'','479','2020-10-11 12:21:41','479',0,1),(2848,40032,'',0,'6.1','1','144','CASH','','2020-10-11 12:23:02',5,0.00,0.00,'','479','2020-10-11 12:23:02','479',0,1),(3207,400486,'',0,'2','1','144','FID POS COLLECTION-5620141491','','2021-02-26 16:00:56',5,0.00,0.00,'','489','2021-02-26 16:00:56','489',0,1),(3217,400496,'',0,'2','1','144','UBA YOLA-1021398099','','2021-02-26 16:12:11',5,0.00,0.00,'','489','2021-02-26 16:12:11','489',0,1),(3218,400497,'',0,'2','1','144','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:32:14',5,0.00,0.00,'','792','2023-02-20 14:32:14','792',0,0),(3219,400498,'',0,'2','1','144','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:36:03',5,0.00,0.00,'2023-03-15','792','2023-03-17 13:50:58','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4260 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1700,'','1','144','YOLA GAS','AHMAD','08054291357','aliyu2784@gmail','JIMAITA','ADAMAWA','YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-10-17 08:54:25',5,'543','2020-10-17 08:54:25','543'),(1753,'','1','144','OPERATIONAL LOSS','HAFIZ NURA','08069129774','hafiz@aaranonigeria.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-10-29 13:39:04',5,'489','2020-10-29 13:39:04','489'),(1780,'','1','144','ALL DEALERS','ALIH','08034887867','aliyu2784@gmail','YOLA','ADAMAWA','YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-11-08 09:54:00',5,'543','2020-11-08 09:54:00','543'),(1781,'','1','144','END USER','ALIH','08034887867','aliyu2784@gmail','YOLA','ADAMAWA','YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-11-08 09:55:00',5,'543','2020-11-08 09:55:00','543'),(2395,'','1','144','DAN GILE','ISMA IL MUHAMMAD','09061610202','aliyu2784@gmail','YOLA','ADAMAWA','MUBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-25 11:39:23',5,'543','2021-03-25 11:39:23','543'),(3019,'','1','144','ANABAB','ABUBAKAR ','09067471234','@gmai.com','YOLA','ADAMAWA','YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-06 07:54:37',5,'543','2021-08-06 07:54:37','543'),(3020,'','1','144','ZAIDU GWANBI GAS','ZAIDU','08169959916','@gmai.com','YOLA','ADAMAWA','GOMBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-06 07:56:14',5,'543','2021-08-06 07:56:14','543'),(3026,'','1','144','HAMZA GAS','HAMZA','07064787899','@gmai.com','YOLA','ADAMAWA','YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-06 14:56:43',5,'543','2021-08-06 14:56:43','543'),(3027,'','1','144','SAMADA GAS','SAMAD','07065376916','@gmai.com','YOLA','ADAMAWA','YOLA BYE PASS','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-07 06:22:04',5,'543','2021-08-07 06:22:04','543'),(3028,'','1','144','JEMS EMOS GAS','JEMS','07034609402','@gmai.com','YOLA','ADAMAWA','BIRKILA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-07 06:29:45',5,'543','2021-08-07 06:29:45','543'),(3029,'','1','144','BEST GAS ','ABUBAKAR HAMXA','08039150180','@gmai.com','YOLA','ADAMAWA','BEHIND BANK ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-07 06:49:52',5,'543','2021-08-07 06:49:52','543'),(3030,'','1','144','USTAZ GAS','USTAS','0000000000','@gmai.com','YOLA','ADAMAWA','GIRE  ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-07 07:12:55',5,'543','2021-08-07 07:12:55','543'),(3031,'','1','144','BELLO GAS','BELLO','07037775057','@gmai.com','YOLA','ADAMAWA','OPP ZENITH BANK, YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-07 10:22:05',5,'543','2021-08-07 10:22:05','543'),(3032,'','1','144','SAMJA GAS','SAMJA','08107004098','@gmai.com','YOLA','ADAMAWA','F C E GEMETA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-07 14:15:33',5,'543','2021-08-07 14:15:33','543'),(3034,'','1','144','SARKI GAS','SARKI','07067744480','@gmai.com','YOLA','ADAMAWA','OPP GT BANK, YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-08 06:50:43',5,'543','2021-08-08 06:50:43','543'),(3035,'','1','144','YAKUBU GAS','YAKUBU','09072167276','@gmai.com','YOLA','ADAMAWA','MARARRABA MADAGALI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-08 07:07:02',5,'543','2021-08-08 07:07:02','543'),(3039,'','1','144','A S W GAS','A S W','08069118988','@gmai.com','YOLA','ADAMAWA','YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-08 11:17:04',5,'543','2021-08-08 11:17:04','543'),(3042,'','1','144','CHIDERA  GAS','CHIDERA WKPAI','08063376588','wkpaic4@gmail.com','JALINGO','ADAMAWA','university gate ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-09 08:53:51',5,'543','2021-08-09 08:53:51','543'),(3043,'','1','144','SALBETER GAS','SALBESTER','07038570414','@gmai.com','JALINGO','ADAMAWA','JALINGO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-09 09:45:44',5,'543','2021-08-09 09:45:44','543'),(3044,'','1','144','ISA GAS','ISA','08164349677','@gmai.com','YOLA','ADAMAWA','SENGERE FUTE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-09 10:23:07',5,'543','2021-08-09 10:23:07','543'),(3046,'','1','144','ABDULKAREEM GAG','ABDULKAREEM','07037878499','@gmai.com','YOLA','ADAMAWA','SENGERO HUTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-09 11:53:46',5,'543','2021-08-09 11:53:46','543'),(3050,'','1','144','EMMA GASES','EMMA','08064666804','@gmai.com','YOLA','ADAMAWA','YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-09 15:43:29',5,'543','2021-08-09 15:43:29','543'),(3068,'','1','144','CHIGBO CHIDERA GAS ','CHIDERA','09063626141','@gmai.com','JALINGO','TARABA','JALINGO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-13 14:17:27',5,'543','2021-08-13 14:17:27','543'),(3069,'','1','144','LEO GAS','ABAAGU USHA LEONERD','09062695813','@gmai.com','JALINGO','TARABA','JALINGO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-13 14:19:57',5,'543','2021-08-13 14:19:57','543'),(3070,'','1','144','J S GAS','JAMES','08139481119','@gmai.com','JALINGO','TARABA','JALINGO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-13 14:21:06',5,'543','2021-08-13 14:21:06','543'),(3071,'','1','144','K WAY','BENJAMIN','08162526275','@gmai.com','JALINGO','TARABA','JALINGO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-13 14:22:44',5,'543','2021-08-13 14:22:44','543'),(3072,'','1','144','SAMJAH GAS','S WALI','08033669760','@gmai.com','YOLA','ADAMAWA','YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-14 07:13:53',5,'543','2021-08-14 07:13:53','543'),(3073,'','1','144','AJASCO GAS','ABDULGANIYU','09065688535','abdulganiyuadeniran2019@gmail.','YOLA','ADAMAWA','YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-14 09:13:18',5,'543','2021-08-14 09:13:18','543'),(3074,'','1','144','MUHD GAS KUFURE','MUHD','08029368607','@gmai.com','YOLA','ADAMAWA','YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-14 10:38:25',5,'543','2021-08-14 10:38:25','543'),(3077,'','1','144','AMOS  GAS','AMOS','08160061255','@gmai.com','YOLA','ADAMAWA','YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-14 16:09:26',5,'543','2021-08-14 16:09:26','543'),(3078,'','1','144','RONACO GAS','RAPHAEL','08034910034','@gmai.com','YOLA','ADAMAWA','YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-14 16:11:04',5,'543','2021-08-14 16:11:04','543'),(3079,'','1','144','DONA GAS','DONATUS','08036156672','@gmai.com','YOLA','ADAMAWA','DAMSAWO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-16 06:38:54',5,'543','2021-08-16 06:38:54','543'),(3081,'','1','144','M YARIMA GAS','MUHD YARIMA','09098277797','@gmai.com','YOLA','ADAMAWA','SANGERE FUTI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-16 07:47:23',5,'543','2021-08-16 07:47:23','543'),(3082,'','1','144','ADAMAWA UNITED GAS','NURA','09031230117','@gmai.com','YOLA','ADAMAWA','HAYIN GADA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-16 10:57:49',5,'543','2021-08-16 10:57:49','543'),(3084,'','1','144','S0N NUMAN','SON','07037062448','@gmai.com','YOLA','ADAMAWA','NUMAN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-16 18:13:36',5,'543','2021-08-16 18:13:36','543'),(3122,'','1','144','AHMAD SAAD GAS','AHMAD','0000000000','@gmai.com','YOLA','ADAMAWA','GIREI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-20 06:44:40',5,'543','2021-08-20 06:44:40','543'),(3124,'','1','144','LINCO   GAS','LIVINUSY  OVAGA','08030657457','@gmai.com','YOLA','ADAMAWA','LAFIYA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-20 08:15:49',5,'543','2021-08-20 08:15:49','543'),(3126,'','1','144','YAHAYA    GAS','MOHAMMED YAHAYA','09038345056','@gmai.com','YOLA','ADAMAWA','J YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-20 13:49:07',5,'543','2021-08-20 13:49:07','543'),(3134,'','1','144','TEEDAL GAS','USMAN','0813766224','usman muhammad5000000@gmail.co','YOLA','ADAMAWA','yola','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-21 10:24:07',5,'543','2021-08-21 10:24:07','543'),(3135,'','1','144','LASS FOTT GAS GOMBI','UMAR','07066960333','@gmai.com','GOMBI','ADAMAWA','GOMBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-21 11:04:40',5,'543','2021-08-21 11:04:40','543'),(3137,'','1','144','NASWAN GAS','KABIRU IBRAHIM','08050411193','kbyola1990@gmail.com','YOLA','ADAMAWA','NUMAN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-21 17:25:13',5,'543','2021-08-21 17:25:13','543'),(3140,'','1','144','ASMAU GAS','ASMAU','07030360725','asmauahmedbelel@gmail.com','MAIHA','ADAMAWA','belel','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-22 10:55:59',5,'543','2021-08-22 10:55:59','543'),(3142,'','1','144','ROYALTY GAS','JOSEPH DAVID','09064115965','davidfoxjoseph316@gmail.com','ZING','TARABA','ZING','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-23 06:33:50',5,'543','2021-08-23 06:33:50','543'),(3150,'','1','144','sadiq  gas','sadiq','08030461592','@gmai.com','YOLA','ADAMAWA','futy','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-26 10:18:28',5,'543','2021-08-26 10:18:28','543'),(3174,'','1','144','BECENT GAG','BECENT','08023000050','@gmai.com','YOLA','ADAMAWA','YOLA TOWN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-31 05:39:43',5,'543','2021-08-31 05:39:43','543'),(3187,'','1','144','YOLA METRO HUB','TASIU MUHD','08032618346','@gmai.com','YOLA','ADAMAWA','YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-04 12:06:10',5,'543','2021-09-04 12:06:10','543'),(3211,'','1','144','UCHE GAS NIG ENTERPRISES','UCHE GOMBE','08033552794','@gmai.com','GOMBE','GOMBE','GOMBE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-09 13:29:34',5,'543','2021-09-09 13:29:34','543'),(3223,'','1','144','MADAM IGBO','MADAM','09035491560','@gmai.com','BALI','TARABA','BALI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-11 12:17:11',5,'543','2021-09-11 12:17:11','543'),(3233,'','1','144','A A UMAR GAS','AA UMAR','08036534591','@gmai.com','JALINGO','TARABA','JALINGO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-12 07:39:35',5,'543','2021-09-12 07:39:35','543'),(3331,'','1','144','ONYENKA GAS','OYENKA','08023000050','@gmai.com','YOLA','ADAMAWA','TOUNGO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-20 11:28:27',5,'543','2021-09-20 11:28:27','543'),(3357,'','1','144','DADDY ALAM GAS','LUCY','08146484589','@gmai.com','YOLA','ADAMAWA','GORURE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-25 08:17:59',5,'543','2021-09-25 08:17:59','543'),(3380,'','1','144','INTERGRETED GAS','IBRAHIM','08036949822','@gmai.com','YOLA','ADAMAWA','INYAKO QUATERS','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-01 05:54:37',5,'543','2021-10-01 05:54:37','543'),(3483,'','1','144','GANYE GAS','ISSEC','08024206717','@gmai.com','YOLA','ADAMAWA','GANYE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-18 13:34:03',5,'543','2021-10-18 13:34:03','543'),(4134,'','1','144','MUBI GAS','MUBI','08060006799','abdulazizgaji38@yahoo.com','YOLA','ADAMAWA','MUBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-02 18:14:54',5,'543','2022-01-02 18:14:54','543'),(4168,'','1','144','JORAM DARIUS','MAI RAWANI','08136363222','joramdarius@gmail.com','YOLA','ADAMAWA','mai rawani','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-12 11:38:41',5,'543','2022-01-12 11:38:41','543'),(4206,'','1','144','MICHAEL GAS','08166381190','08166381190','michaeljmr55@5gmail.com','adamawa','adamawa','st peters yola.','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-20 10:09:36',5,'543','2022-01-20 10:09:36','543'),(4229,'','1','144','ADILI GAS','09062379124','09062379124','aliyu2784@gmail','jameta','adamawa','karewa maskare','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-24 09:45:04',5,'543','2022-01-24 09:45:04','543'),(4230,'','1','144','DE-FAMOS','07034389811','07034389811','aliyu2784@gmail','jameta','adamawa','NO3 LUGERO ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-24 09:52:10',5,'543','2022-01-24 09:52:10','543'),(4231,'','1','144','DAN DIJE GAS','07041019457','07041019457','afdeeafakallah@gmail.com','jameta','adamawa','jameta yola ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-01 10:25:07',5,'543','2022-02-01 10:25:07','543'),(4232,'','1','144','OBITRACO','08032677425','07032677425','wkpaic4@gmail.com','ZING','TARABA','OPPOSITE BIZARE HOTEL ZINK','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-03 11:09:12',5,'543','2022-02-03 11:09:12','543'),(4233,'','1','144','AUWALSIYYA OIL & GAS','08108907995','08108907995','auwalsiyya79@gmail.com','yola','adamawa','karewa extention of yola','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-08 08:56:35',5,'543','2022-02-08 08:56:35','543'),(4234,'','1','144','tubra nig lmt','07034322306','07034322306','daudatukur@gmail.com','jameta','adamawa','ajecent icpc office bachure kufare','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-09 11:21:25',5,'543','2022-02-09 11:21:25','543'),(4235,'','1','144','LUCY AUGUSTINE','08146484589','08146484589','wkpaic4@gmail.com','YOLA','ADAMAWA','GUTORE ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-17 10:37:33',5,'543','2022-02-17 10:37:33','543'),(4236,'','1','144','ISAAC SUNDAY','08106050990','08106050990','isaacsunday0990@gmail.com','ganye','ADAMAWA','ganye','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-23 10:42:10',5,'543','2022-02-23 10:42:10','543'),(4237,'','1','144','NAIRA GAS','07036580570','07036580570','abubakarhamidu880@gmail.com','jimeta yola','adamawa','dogire modibbo street','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-02 09:03:07',5,'543','2022-03-02 09:03:07','543'),(4238,'','1','144','F.G.GAS','MAY0','07065122399','wkpaic4@gmail.com','YOLA','ADAMAWA','ZING','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-02 18:26:10',5,'543','2022-03-02 18:26:10','543'),(4239,'','1','144','EDIWADATA','HONG','08069365276','abdulganiyuadeniran2019@gmail.','YOLA','ADAMAWA','HONG','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-03 16:04:33',5,'543','2022-03-03 16:04:33','543'),(4240,'','1','144','JAMILU GOMBI','08039668010','08039668010','yamiluyusuf10@gmail.com','GOMBI','ADAMAWA','oppossite yako plaza','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-13 10:46:17',5,'543','2022-03-13 10:52:20','543'),(4241,'','1','144','NIBRAS GAS','08038416221','08038416221','neebras@outlook.com','jameta','ADAMAWA','behind pz janbutu','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-20 10:57:29',5,'543','2022-03-20 10:57:29','543'),(4242,'','1','144','BITRUS LUKA','09130033139','09030033139','wkpaic4@gmail.com','JADA','ADAMAWA','JADA LOCAL GOVERMENT','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-29 08:28:53',5,'543','2022-03-29 08:28:53','543'),(4243,'','1','144','LUCID ENERGY','08068577027','08068577027','okenwajames012@gmail.com','yola','ADAMAWA','guyuk local goverment adamawa state','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-03 09:27:49',5,'543','2022-04-03 09:27:49','543'),(4244,'','1','144','BRISTON GAS','07063602694','07063602694','bristonyohana@gmail.com','YOLA','ADAMAWA','SCHOOL OF NURSING YOLA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-09 09:17:40',5,'543','2022-04-09 09:17:40','543'),(4245,'','1','144','I.B. GAS','YOLA','07069468740','wkpaic4@gmail.com','YOLA','ADAMAWA','YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-18 16:37:41',5,'543','2022-04-18 16:37:41','543'),(4246,'','1','144','PETER NUMAN','07030635893','07030635893','wkpaic4@gmail.com','NUMAN','ADAMAWA','NUMAN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-03 16:17:45',5,'543','2022-05-03 16:17:45','543'),(4247,'','1','144','TUMBA KWADA','08033556533','07033556533','@gmai.com','YOLA','ADAMAWA','YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-05 10:57:21',5,'543','2022-05-05 10:57:21','543'),(4248,'','1','144','RABO GAS','07042608288','07042608288','wkpaic4@gmail.com','YOLA','ADAMAWA','SANGERE NUMAN ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-09 10:53:16',5,'543','2022-05-09 10:53:16','543'),(4249,'','1','144','YAKUBU  KAZA','YALO','08160004652','wkpaic4@gmail.com','yola','ADAMAWA','YALO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-05 15:20:32',5,'543','2022-06-05 15:20:32','543'),(4250,'','1','144','HAMISU GEMBU','GEMBU','08061247740','@gmai.com','GEMBU','TARABA','GEMBU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-24 19:54:49',5,'543','2022-06-24 19:54:49','543'),(4251,'','1','144','TARABA GAS','JALINGO','08032653157','tarabagas@gmail.com','taraba','TARABA','taraba jalingo','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-24 10:12:28',5,'543','2022-07-24 10:12:28','543'),(4252,'','1','144','MADAGALI OIL','NURA TUKUR','07066304535','hafiz nuragaya@g.com','ADAMAWA','YOLA','GOVERMENT HOUSE ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-08 09:59:55',5,'916','2022-08-08 09:59:55','916'),(4253,'','1','144','DAN JAKADA','MOHAMMAD BASHIR','08038888961','hafiz nuragaya@g.com','ADAMAWA','YOLA','HUNG LGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-10 09:56:45',5,'916','2022-08-10 09:56:45','916'),(4254,'','1','144','G LIMAN  GAS','KABIORU GADADO','08039365443','hafiz nuragaya@g.com','ADAMAWA','YOLA','LELEWANT 2YOLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-13 18:35:21',5,'916','2022-08-13 18:35:21','916'),(4255,'','1','144','kenneth  gases','kenneth','07066304535','hafiz nuragaya@g.com','ADAMAWA','YOLA','mubi','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-03 15:27:12',5,'916','2022-09-03 15:27:12','916'),(4256,'','1','144','SABORE INTERNATIONAL FARM','SADAK TUKUR','09034166074','hafiznuragaya@gmail.com','YOLA','ADAMAWA','MOYO BALWA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-11 14:07:56',5,'916','2022-09-11 14:07:56','916'),(4257,'','1','144','SHAGARI GAS','YUSIF IBRAHIM','08034457986','hafiznuragaya@gmail.com','YOLA','ADAMAWA','SHAGARI LOW COST FASE TWO YOLA SOUTH','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-01 09:16:36',5,'916','2022-10-01 09:16:36','916'),(4258,'','1','144','CLEMENT ABBA GAS','CLEMENT ABBA','08108682099','hafiznuragaya@gmail.com','jameta','ADAMAWA','BACHURE OPPOSITE ARMY BARRAK JIMETA YOLA ADAMAWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-29 14:19:38',5,'916','2022-12-29 14:19:38','916'),(4259,'','1','144','CLEMZ GAS','CLEMENT','08122200278','clemz@gmail.com','JIMETA','ADAMAWA','BACHURE','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-05 10:36:46',5,'916','2023-01-05 10:36:46','916');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16350 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','144',16347,'828',1142.97,1.00,'2021-09-08','new dipping','2021-09-08 13:08:58','483','483',2021,'483','2021-09-08 13:08:58',5),('1','144',16348,'829',16622.14,8952.00,'2021-09-08','new dipping','2021-09-08 13:10:38','483','483',2021,'483','2021-09-08 13:10:38',5),('1','144',16349,'828',16817.24,16501.00,'2022-06-16','new','2022-06-16 11:59:54','483','483',2022,'483','2022-06-16 11:59:54',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2362 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','144','828',2360,'5','LPG NOZZLE 1',2373864.20,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','144','829',2361,'5','LPG NOZZLE 2',722402.22,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257976 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','144',157104,'DEALY SELL','2020-10-17','2020-10-17 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-08 10:03:06','543','2020-11-08 10:03:57',10,0),('1','144',160790,'DEALY SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-08 10:30:01','543','2020-11-08 10:30:39',10,0),('1','144',160796,'DEALY SHIFT','2020-10-13','2020-10-13 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-08 10:53:08','543','2020-11-08 10:53:42',10,0),('1','144',160802,'DEALY SHIFT','2020-10-14','2020-10-14 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-08 11:20:02','543','2020-11-08 11:20:32',10,0),('1','144',160807,'DEALY SHIFT','2020-10-15','2020-10-15 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-08 11:44:43','543','2020-11-08 11:45:17',10,0),('1','144',160809,'DEALY SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-08 11:55:20','543','2020-11-08 11:55:49',10,0),('1','144',160812,'DEALY SHIFT','2020-10-17','2020-10-17 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-08 12:08:49','543','2020-11-08 12:09:15',10,0),('1','144',160814,'DEALY SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-08 12:28:06','543','2020-11-08 12:28:30',10,0),('1','144',160827,'DEALY SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-08 13:27:07','543','2020-11-08 13:27:31',10,0),('1','144',160833,'DEALY SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-08 13:44:18','543','2020-11-08 13:44:45',10,0),('1','144',160849,'DEALY SHIFT','2020-10-21','2020-10-21 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-08 14:37:59','543','2020-11-08 14:38:43',10,0),('1','144',160857,'DEALY SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-09 06:43:25','543','2020-11-09 06:43:59',10,0),('1','144',160909,'DEALY SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-09 06:54:10','543','2020-11-09 06:54:39',10,0),('1','144',160914,'DEALY SHIFT','2020-10-24','2020-10-24 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-09 07:13:02','543','2020-11-09 07:13:44',10,0),('1','144',160921,'DEALY SHIFT','2020-10-25','2020-10-25 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-09 07:47:27','543','2020-11-12 09:39:05',10,0),('1','144',161534,'DEALY SHIFT','2020-10-25','2020-10-25 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-12 09:50:18','543','2020-11-12 09:50:44',10,0),('1','144',161537,'DEALY SHIFT','2020-10-27','2020-10-27 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-12 10:06:54','543','2020-11-12 10:07:24',10,0),('1','144',161540,'DEALY SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-12 10:24:41','543','2020-11-12 10:25:11',10,0),('1','144',161550,'DEALY SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-12 10:58:51','543','2020-11-12 10:59:19',10,0),('1','144',161556,'DEALY SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-12 11:16:38','543','2020-11-12 11:17:12',10,0),('1','144',161559,'DEALY SHIFT','2020-10-31','2020-10-31 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-12 11:37:51','543','2020-11-12 11:38:20',10,0),('1','144',162310,'DEALY SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-16 10:32:19','543','2020-11-16 10:33:00',10,0),('1','144',162320,'DEALY SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-16 11:12:16','543','2020-11-16 11:13:04',10,0),('1','144',162341,'DEALY SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-16 11:38:30','543','2020-11-16 11:38:54',10,0),('1','144',162346,'DEALY SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-16 11:49:38','543','2020-11-16 11:50:05',10,0),('1','144',162348,'DEALY SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-16 11:59:15','543','2020-11-16 11:59:47',10,0),('1','144',162432,'DEALY SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-16 16:29:14','543','2020-11-16 16:29:39',10,0),('1','144',162435,'DEALY SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-16 16:41:58','543','2020-11-16 16:42:21',10,0),('1','144',162510,'DEALY SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-17 09:20:06','543','2020-11-17 09:20:33',10,0),('1','144',162533,'DEALY SHIFT','2020-11-08','2020-11-08 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-17 10:34:11','543','2020-11-17 10:34:36',10,0),('1','144',162535,'DEALY SHIFT','2020-11-09','2020-11-09 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-17 11:01:48','543','2020-11-17 11:02:10',10,0),('1','144',162540,'DEALY SHIFT','2020-11-10','2020-11-10 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-17 11:07:48','543','2020-11-17 11:08:10',10,0),('1','144',162545,'DEALY SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-17 11:33:20','543','2020-11-17 11:33:46',10,0),('1','144',162551,'DEALY SHIFT','2020-11-12','2020-11-12 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-17 11:43:11','543','2020-11-17 11:43:43',10,0),('1','144',162555,'DEALY SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-17 11:53:56','543','2020-11-17 11:54:24',10,0),('1','144',162558,'DEALY SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-17 12:03:01','543','2020-11-17 12:03:29',10,0),('1','144',162782,'DEALY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-18 16:02:46','543','2020-11-18 16:03:28',10,0),('1','144',162785,'DEALY SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-19 15:05:41','543','2020-11-19 15:06:06',10,0),('1','144',162969,'DEALY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-19 15:32:25','543','2020-11-19 15:32:50',10,0),('1','144',162973,'DEALY SHIFT','2020-11-18','2020-11-18 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-19 15:42:33','543','2020-11-19 15:42:54',10,0),('1','144',163022,'DEALY SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-20 07:31:35','543','2020-11-20 07:31:59',10,0),('1','144',163027,'DEALY SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-21 09:01:17','543','2020-11-21 09:01:45',10,0),('1','144',163644,'DEALY SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-23 12:03:12','543','2020-11-23 12:03:29',10,0),('1','144',163646,'DEALY SHIFT','2020-11-21','2020-11-21 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-23 12:15:53','543','2020-11-23 12:16:15',10,0),('1','144',163648,'DEALY SHIFT','2020-11-22','2020-11-22 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-23 12:32:13','543','2020-11-23 12:33:03',10,0),('1','144',163665,'DEALY SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-24 14:21:16','543','2020-11-24 14:21:39',10,0),('1','144',163907,'DEALY SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-25 05:34:28','543','2020-11-25 05:37:30',10,0),('1','144',164092,'DEALY SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-26 05:43:26','543','2020-11-26 05:43:47',10,0),('1','144',164094,'DEALY SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-26 06:07:49','543','2020-11-26 06:08:14',10,0),('1','144',164309,'DEALY SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-27 09:11:36','543','2020-11-27 09:12:21',10,0),('1','144',164808,'DEALY SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-30 09:43:42','543','2020-11-30 09:44:10',10,0),('1','144',164812,'DEALY SHIFT','2020-11-28','2020-11-28 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-30 09:55:41','543','2020-11-30 09:56:06',10,0),('1','144',164813,'DEALY SHIFT','2020-11-29','2020-11-29 00:00:00',NULL,'543',0.00,0.00,'543','2020-11-30 10:08:53','543','2020-11-30 10:09:21',10,0),('1','144',165069,'DEALY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-01 14:52:45','543','2020-12-01 14:53:11',10,0),('1','144',165091,'DEALY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-01 16:11:36','543','2020-12-01 16:12:26',10,0),('1','144',165169,'DEALY SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-02 09:22:01','543','2020-12-02 09:22:34',10,0),('1','144',165380,'DEALY SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-03 11:53:52','543','2020-12-03 11:54:52',10,0),('1','144',165516,'DEALY SHIFT','2020-12-03','2020-12-03 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-04 10:06:03','543','2020-12-04 10:09:37',10,0),('1','144',166116,'DEALY SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-07 16:41:07','543','2020-12-07 16:41:43',10,0),('1','144',166123,'DEALY SHIFT','2020-12-05','2020-12-05 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-08 05:51:14','543','2020-12-08 05:51:36',10,0),('1','144',166154,'DEALY SHIFT','2020-12-06','2020-12-06 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-08 05:59:46','543','2020-12-08 06:00:09',10,0),('1','144',166155,'DEALY SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-08 06:10:10','543','2020-12-08 06:10:33',10,0),('1','144',166384,'DEALY SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-09 11:31:39','543','2020-12-09 11:33:46',10,0),('1','144',166591,'DEALY SHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-10 11:45:03','543','2020-12-10 11:48:38',10,0),('1','144',166739,'DEALY SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-11 09:58:54','543','2020-12-11 09:59:18',10,0),('1','144',167501,'DEALY SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-15 16:15:10','543','2020-12-15 16:15:35',10,0),('1','144',167548,'DEALY SHIFT','2020-12-12','2020-12-12 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-15 16:27:04','543','2020-12-15 16:27:27',10,0),('1','144',167631,'DEALY SHIFT','2020-12-13','2020-12-13 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-16 11:32:42','543','2020-12-16 11:33:04',10,0),('1','144',167637,'DEALY SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-16 11:40:19','543','2020-12-16 11:40:41',10,0),('1','144',167642,'DEALY SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-16 15:22:34','543','2020-12-16 15:23:50',10,0),('1','144',167693,'DEALY SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-16 15:28:44','543','2020-12-16 15:29:05',10,0),('1','144',167781,'DEALY SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-17 09:12:47','543','2020-12-17 09:13:43',10,0),('1','144',168145,'DEALY SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-19 07:21:15','543','2020-12-19 07:25:48',10,0),('1','144',168147,'DEALY SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-19 07:37:06','543','2020-12-19 07:37:29',10,0),('1','144',168481,'DEALY SHIFT','2020-12-19','2020-12-19 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-21 10:11:18','543','2020-12-21 10:11:45',10,0),('1','144',168485,'DEALY SHIFT','2020-12-20','2020-12-20 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-21 10:22:10','543','2020-12-21 10:22:34',10,0),('1','144',168627,'DEALY SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-22 06:40:25','543','2020-12-22 06:40:52',10,0),('1','144',168961,'DEALY SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-24 08:24:45','543','2020-12-24 08:25:44',10,0),('1','144',168963,'DEALY SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-24 08:37:41','543','2020-12-24 08:38:06',10,0),('1','144',169152,'DEALY SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-25 09:53:07','543','2020-12-25 09:53:35',10,0),('1','144',169945,'DEALY SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-30 08:20:51','543','2020-12-30 08:21:18',10,0),('1','144',169948,'DEALY SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-30 08:30:24','543','2020-12-30 08:30:41',10,0),('1','144',169949,'DEALY SHIFT','2020-12-27','2020-12-27 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-30 08:40:51','543','2020-12-30 08:41:17',10,0),('1','144',169953,'DEALY SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-30 08:47:02','543','2020-12-30 08:53:40',10,0),('1','144',169954,'DEALY SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-30 09:27:54','543','2020-12-30 09:28:16',10,0),('1','144',169968,'DEALY SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-30 09:52:19','543','2020-12-30 09:52:40',10,0),('1','144',169979,'DEALY SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-30 09:59:42','543','2020-12-30 10:00:03',10,0),('1','144',169986,'DEALY SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-30 10:09:38','543','2020-12-30 10:10:00',10,0),('1','144',170155,'DEALY SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'543',0.00,0.00,'543','2020-12-31 05:50:27','543','2020-12-31 05:50:45',10,0),('1','144',170944,'DEALY SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-04 15:28:23','543','2021-01-04 15:31:33',10,0),('1','144',170952,'DEALY SHIFT','2020-01-31','2020-01-31 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-04 15:45:51','543','2021-01-04 15:46:14',10,0),('1','144',170955,'DEALY SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-04 16:04:56','543','2021-01-04 16:07:41',10,0),('1','144',170964,'DEALY SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-04 17:07:08','543','2021-01-04 17:07:27',10,0),('1','144',171075,'DEALY SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-05 10:41:57','543','2021-01-05 10:42:15',10,0),('1','144',171087,'DEALY SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-05 11:04:38','543','2021-01-05 11:05:00',10,0),('1','144',171192,'DEALY SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-05 17:04:38','543','2021-01-05 17:05:02',10,0),('1','144',171194,'DEALY SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-05 17:18:57','543','2021-01-05 17:19:15',10,0),('1','144',171339,'DEALY SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-10 10:15:07','543','2021-01-10 10:15:27',10,0),('1','144',171986,'DEALY SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-10 10:22:08','543','2021-01-10 10:22:28',10,0),('1','144',171988,'DEALY SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-10 10:33:24','543','2021-01-10 10:33:47',10,0),('1','144',171992,'DEALY SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-10 10:42:26','543','2021-01-10 10:42:44',10,0),('1','144',171994,'DEALY SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-10 10:52:20','543','2021-01-10 10:52:39',10,0),('1','144',171997,'DEALY SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-10 11:31:45','543','2021-01-10 11:32:04',10,0),('1','144',172350,'DEALY SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-12 11:17:17','543','2021-01-12 11:17:35',10,0),('1','144',172352,'DEALY SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-12 11:33:36','543','2021-01-12 11:33:57',10,0),('1','144',172514,'DEALY SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-13 05:25:25','543','2021-01-13 05:25:47',10,0),('1','144',172704,'DEALY SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-14 05:43:41','543','2021-01-14 05:44:00',10,0),('1','144',172878,'DEALY SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-15 05:44:42','543','2021-01-15 05:45:01',10,0),('1','144',173064,'DEALY SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-16 06:03:23','543','2021-01-16 06:03:53',10,0),('1','144',173225,'DEALY SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-17 06:51:25','543','2021-01-17 06:51:48',10,0),('1','144',173300,'DEALY SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-17 13:31:05','543','2021-01-17 13:31:34',10,0),('1','144',173393,'DEALY SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-18 05:56:22','543','2021-01-18 05:56:44',10,0),('1','144',173672,'DEALY SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-19 11:39:23','543','2021-01-19 11:39:45',10,0),('1','144',173770,'DEALY SHIFT','2021-01-19','2021-01-19 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-20 05:54:25','543','2021-01-20 05:54:44',10,0),('1','144',173950,'DEALY SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-21 05:26:33','543','2021-01-21 05:27:00',10,0),('1','144',174134,'DEALY SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-22 05:49:11','543','2021-01-22 05:49:31',10,0),('1','144',174326,'DEALY SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-23 05:42:54','543','2021-01-23 05:43:13',10,0),('1','144',174515,'DEALY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-24 10:01:40','543','2021-01-24 10:01:58',10,0),('1','144',174527,'DEALY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-24 11:01:08','543','2021-01-24 11:02:05',10,0),('1','144',174648,'DEALY SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-25 05:22:57','543','2021-01-25 05:23:26',10,0),('1','144',174856,'DEALY SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-26 07:38:31','543','2021-01-26 07:38:55',10,0),('1','144',175245,'DEALY SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-28 05:35:13','543','2021-01-28 05:35:33',10,0),('1','144',175247,'DEALY SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-29 06:49:39','543','2021-01-29 06:50:00',10,0),('1','144',175424,'DEALY SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-29 06:54:54','543','2021-01-29 06:55:13',10,0),('1','144',175426,'DEALY SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'543',0.00,0.00,'543','2021-01-29 07:11:55','543','2021-01-29 07:12:16',10,0),('1','144',175969,'DEALY SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-01 09:54:28','543','2021-02-01 09:54:50',10,0),('1','144',175971,'DEALY SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-01 10:05:49','543','2021-02-01 10:06:11',10,0),('1','144',175978,'DEALY SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-01 10:26:06','543','2021-02-01 10:26:27',10,0),('1','144',176150,'DEALY SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-04 07:42:11','543','2021-02-04 07:42:48',10,0),('1','144',176571,'DEALY SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-04 07:47:15','543','2021-02-04 07:47:34',10,0),('1','144',176575,'DEALY SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-04 07:55:22','543','2021-02-04 07:55:43',10,0),('1','144',176845,'DEALY SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-05 11:00:12','543','2021-02-05 11:00:56',10,0),('1','144',178163,'DEALY SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-11 12:06:45','543','2021-02-11 12:07:10',10,0),('1','144',178173,'DEALY SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-11 12:33:50','543','2021-02-11 12:34:12',10,0),('1','144',178186,'DEALY SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-11 13:09:28','543','2021-02-11 13:09:47',10,0),('1','144',178198,'DEALY SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-11 17:22:12','543','2021-02-11 17:22:31',10,0),('1','144',178261,'DEALY SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-11 17:31:47','543','2021-02-11 17:32:04',10,0),('1','144',178265,'DEALY SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-11 17:52:51','543','2021-02-11 17:53:21',10,0),('1','144',178305,'DEALY SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-12 08:17:41','543','2021-02-12 08:18:05',10,0),('1','144',178315,'DEALY SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-12 08:47:47','543','2021-02-12 08:48:14',10,0),('1','144',178682,'DEALY SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-13 17:24:28','543','2021-02-13 17:24:46',10,0),('1','144',178738,'DEALY SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-14 07:24:29','543','2021-02-14 07:24:46',10,0),('1','144',179514,'DEALY SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-17 15:54:27','543','2021-02-17 15:54:44',10,0),('1','144',179515,'DEALY SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-17 16:00:39','543','2021-02-17 16:00:58',10,0),('1','144',179517,'DEALY SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-17 16:05:59','543','2021-02-17 16:06:18',10,0),('1','144',179796,'DEALY SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-19 17:12:56','543','2021-02-19 17:13:25',10,0),('1','144',180352,'DEALY SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-22 07:42:57','543','2021-02-22 07:43:32',10,0),('1','144',180355,'DEALY SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-22 07:49:09','543','2021-02-22 07:49:32',10,0),('1','144',180361,'DEALY SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-22 07:59:26','543','2021-02-22 07:59:43',10,0),('1','144',180365,'DEALY SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-22 08:05:31','543','2021-02-22 08:06:07',10,0),('1','144',180367,'DEALY SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-22 08:10:12','543','2021-02-22 08:10:30',10,0),('1','144',180616,'DEALY SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-23 10:35:46','543','2021-02-23 10:36:09',10,0),('1','144',180956,'DEALY SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-25 06:20:02','543','2021-02-25 06:20:36',10,0),('1','144',181365,'DEALY SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-27 09:10:58','543','2021-02-27 09:11:21',10,0),('1','144',181373,'DEALY SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-27 09:29:32','543','2021-02-27 09:30:10',10,0),('1','144',181382,'DEALY SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-27 09:53:21','543','2021-02-27 09:53:43',10,0),('1','144',181386,'DEALY SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-27 10:03:29','543','2021-02-27 10:03:48',10,0),('1','144',181389,'DEALY SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-27 10:09:59','543','2021-02-27 10:10:22',10,0),('1','144',181414,'DEALY SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-27 11:43:12','543','2021-02-27 11:43:38',10,0),('1','144',181581,'DEALY SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'543',0.00,0.00,'543','2021-02-28 11:02:48','543','2021-02-28 11:03:04',10,0),('1','144',181847,'DEALY SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-01 17:02:28','543','2021-03-01 17:02:51',10,0),('1','144',182082,'DEALY SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-03 13:11:31','543','2021-03-03 13:13:02',10,0),('1','144',182204,'DEALY SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-03 13:50:09','543','2021-03-03 13:50:34',10,0),('1','144',182602,'DEALY SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-05 14:43:31','543','2021-03-05 14:43:51',10,0),('1','144',182614,'DEALY SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-05 14:56:27','543','2021-03-05 14:56:54',10,0),('1','144',183212,'DEALY SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-12 13:30:42','543','2021-03-12 13:31:52',10,0),('1','144',184004,'DEALY SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-12 14:07:32','543','2021-03-12 14:07:56',10,0),('1','144',184011,'DEALY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-12 14:17:39','543','2021-03-12 14:17:57',10,0),('1','144',184013,'DEALY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-13 14:43:12','543','2021-03-13 15:38:02',10,0),('1','144',184192,'DEALY SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-13 15:54:22','543','2021-03-13 15:54:44',10,0),('1','144',184199,'DEALY SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-13 16:06:57','543','2021-03-13 16:07:13',10,0),('1','144',184203,'DEALY SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-13 16:17:55','543','2021-03-13 16:18:11',10,0),('1','144',184415,'DEALY SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-14 16:47:29','543','2021-03-14 16:48:07',10,0),('1','144',184417,'DEALY SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-14 16:52:11','543','2021-03-14 16:52:30',10,0),('1','144',184418,'DEALY SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-14 16:59:56','543','2021-03-14 17:00:26',10,0),('1','144',184834,'DEALY SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-16 16:23:56','543','2021-03-16 16:24:19',10,0),('1','144',184836,'DEALY SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-16 16:29:36','543','2021-03-16 16:29:53',10,0),('1','144',185040,'DEALY SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-17 15:44:31','543','2021-03-17 15:57:54',10,0),('1','144',185049,'DEALY SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-17 16:01:26','543','2021-03-17 16:01:52',10,0),('1','144',186489,'DEALY SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-25 13:47:06','543','2021-03-25 13:47:29',10,0),('1','144',186883,'DEALY SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-26 14:43:34','543','2021-03-26 14:43:55',10,0),('1','144',186897,'DEALY SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-26 15:28:26','543','2021-03-26 15:28:45',10,0),('1','144',186902,'DEALY SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-26 15:39:05','543','2021-03-26 15:39:23',10,0),('1','144',186912,'DEALY SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-26 16:11:21','543','2021-03-26 16:11:38',10,0),('1','144',186920,'DEALY SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-26 16:22:05','543','2021-03-26 16:22:21',10,0),('1','144',186925,'DEALY SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-26 16:34:23','543','2021-03-26 16:34:43',10,0),('1','144',186927,'DEALY SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-26 16:45:48','543','2021-03-26 16:46:09',10,0),('1','144',186928,'DEALY SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-26 16:55:29','543','2021-03-26 16:56:09',10,0),('1','144',186929,'DEALY SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-26 16:59:30','543','2021-03-26 16:59:49',10,0),('1','144',186930,'DEALY SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-26 18:33:11','543','2021-03-26 18:34:06',10,0),('1','144',186971,'DEALY SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-27 17:53:17','543','2021-03-27 17:55:03',10,0),('1','144',187147,'DEALY SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-28 14:03:12','543','2021-03-28 14:03:46',10,0),('1','144',187273,'DEALY SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-28 17:57:04','543','2021-03-28 17:57:42',10,0),('1','144',187334,'DEALY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-29 17:50:29','543','2021-03-29 17:53:12',10,0),('1','144',187558,'DEALY SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-30 17:53:57','543','2021-03-30 17:54:44',10,0),('1','144',187782,'DEALY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'543',0.00,0.00,'543','2021-03-31 17:49:02','543','2021-03-31 17:49:33',10,0),('1','144',188000,'DEALY SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-01 17:35:04','543','2021-04-01 17:35:50',10,0),('1','144',188195,'DEALY SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-02 18:26:12','543','2021-04-02 18:33:24',10,0),('1','144',188406,'DEALY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-03 17:48:41','543','2021-04-03 17:49:25',10,0),('1','144',188593,'DEALY SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-04 18:08:15','543','2021-04-04 18:09:12',10,0),('1','144',188792,'DEALY SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-05 17:54:36','543','2021-04-05 17:55:57',10,0),('1','144',188991,'DEALY SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-06 18:06:12','543','2021-04-06 18:07:52',10,0),('1','144',189189,'DEALY SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-07 18:04:58','543','2021-04-07 18:05:34',10,0),('1','144',189406,'DEALY SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-08 17:53:47','543','2021-04-08 17:55:06',10,0),('1','144',189604,'DEALY SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-09 17:56:08','543','2021-04-09 17:56:42',10,0),('1','144',189816,'DEALY SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-10 17:51:53','543','2021-04-10 17:52:35',10,0),('1','144',190023,'DEALY SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-11 18:17:53','543','2021-04-11 18:18:21',10,0),('1','144',190211,'DEALY SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-12 18:04:06','543','2021-04-12 18:04:40',10,0),('1','144',190421,'DEALY SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-13 18:43:30','543','2021-04-13 18:44:45',10,0),('1','144',190660,'DEALY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-14 17:55:10','543','2021-04-14 17:58:58',10,0),('1','144',190877,'DEALY SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-15 17:55:03','543','2021-04-15 17:56:16',10,0),('1','144',191066,'DEALY SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-16 18:05:25','543','2021-04-16 18:06:09',10,0),('1','144',191277,'DEALY SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-17 18:37:00','543','2021-04-17 18:38:01',10,0),('1','144',191486,'DEALY SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-18 17:54:00','543','2021-04-18 17:54:23',10,0),('1','144',191710,'DEALY SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-19 17:54:01','543','2021-04-19 17:58:20',10,0),('1','144',191922,'DEALY SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-20 18:05:05','543','2021-04-20 18:09:37',10,0),('1','144',192124,'DEALY SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-21 18:14:34','543','2021-04-21 21:42:15',10,0),('1','144',192329,'DEALY SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-22 18:01:54','543','2021-04-22 18:02:58',10,0),('1','144',192650,'DEALY SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-23 17:58:35','543','2021-04-23 18:00:54',10,0),('1','144',192747,'DEALY SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-24 17:50:09','543','2021-04-24 18:07:04',10,0),('1','144',192950,'DEALY SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-25 18:30:09','543','2021-04-25 18:31:07',10,0),('1','144',193164,'DEALY SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-26 18:02:55','543','2021-04-26 18:04:53',10,0),('1','144',193394,'DEALY SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-27 17:56:12','543','2021-04-27 18:04:32',10,0),('1','144',193618,'DEALY SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-28 17:54:44','543','2021-04-28 17:59:31',10,0),('1','144',193842,'DEALY SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-29 17:57:49','543','2021-04-29 17:58:59',10,0),('1','144',194069,'DEALY SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'543',0.00,0.00,'543','2021-04-30 18:01:46','543','2021-04-30 18:05:18',10,0),('1','144',194276,'DEALY SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-01 17:58:01','543','2021-05-02 03:54:17',10,0),('1','144',194470,'DEALY SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-02 19:35:52','543','2021-05-03 03:47:17',10,0),('1','144',194657,'DEALY SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-04 10:31:47','543','2021-05-04 10:34:55',10,0),('1','144',194897,'DEALY SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-04 18:25:54','543','2021-05-04 18:27:25',10,0),('1','144',195067,'DEALY SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-05 18:32:53','543','2021-05-05 18:35:02',10,0),('1','144',195290,'DEALY SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-06 17:35:14','543','2021-05-06 17:39:54',10,0),('1','144',195506,'DEALY SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-08 04:19:36','543','2021-05-08 04:21:44',10,0),('1','144',195762,'DEALY SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-08 17:22:42','543','2021-05-08 18:26:25',10,0),('1','144',195995,'DEALY SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-09 19:24:01','543','2021-05-09 19:27:09',10,0),('1','144',196211,'DEALY SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-10 18:45:22','543','2021-05-11 08:47:29',10,0),('1','144',196524,'DEALY SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-11 18:19:57','543','2021-05-11 18:25:37',10,0),('1','144',196650,'DEALY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-12 19:27:39','543','2021-05-13 06:12:45',10,0),('1','144',196866,'DEALY SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-14 04:41:36','543','2021-05-14 04:43:36',10,0),('1','144',197014,'DEALY SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-14 17:22:53','543','2021-05-16 11:53:08',10,0),('1','144',197327,'DEALY SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-16 14:10:36','543','2021-05-16 14:11:09',10,0),('1','144',197422,'DEALY SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-16 18:34:43','543','2021-05-16 18:36:31',10,0),('1','144',197504,'DEALY SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-17 19:36:03','543','2021-05-17 19:38:03',10,0),('1','144',197858,'DEALY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-18 19:49:22','543','2021-05-18 19:50:08',10,0),('1','144',198105,'DEALY SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-19 17:35:51','543','2021-05-19 17:36:55',10,0),('1','144',198337,'DEALY SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-20 20:35:42','543','2021-05-20 20:37:36',10,0),('1','144',198554,'DEALY SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-21 21:23:27','543','2021-05-21 21:24:49',10,0),('1','144',198770,'DEALY SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-22 18:03:38','543','2021-05-22 18:04:51',10,0),('1','144',198973,'DEALY SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-24 20:15:51','543','2021-05-24 20:16:18',10,0),('1','144',199409,'DEALY SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-24 20:26:03','543','2021-05-24 20:26:47',10,0),('1','144',199632,'DAILY SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 05:49:59','543','2021-05-26 05:50:22',10,0),('1','144',199634,'DAILY SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 05:57:23','543','2021-05-26 05:57:43',10,0),('1','144',199636,'DAILY SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 06:05:04','543','2021-05-26 06:05:26',10,0),('1','144',199640,'DAILY SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 06:11:14','543','2021-05-26 06:11:35',10,0),('1','144',199644,'DAILY SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 06:17:49','543','2021-05-26 06:18:11',10,0),('1','144',199647,'DAILY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 06:23:16','543','2021-05-26 06:23:40',10,0),('1','144',199650,'DAILY SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 06:28:43','543','2021-05-26 06:29:08',10,0),('1','144',199655,'DAILY SHIFT','2020-12-20','2020-12-20 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 06:35:05','543','2021-05-26 06:35:27',10,0),('1','144',199656,'DAILY SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 06:40:16','543','2021-05-26 06:40:44',10,0),('1','144',199658,'DAILY SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 06:46:06','543','2021-05-26 06:46:24',10,0),('1','144',199662,'DAILY SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 06:50:11','543','2021-05-26 06:50:35',10,0),('1','144',199665,'DAILY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 06:55:04','543','2021-05-26 06:55:29',10,0),('1','144',199668,'DAILY SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 06:59:51','543','2021-05-26 07:00:08',10,0),('1','144',199673,'DAILY SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 07:07:19','543','2021-05-26 07:07:42',10,0),('1','144',199676,'DAILY SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 07:14:35','543','2021-05-26 07:15:10',10,0),('1','144',199678,'DAILY SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 07:22:47','543','2021-05-26 07:23:13',10,0),('1','144',199679,'DAILY SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 07:28:18','543','2021-05-26 07:29:05',10,0),('1','144',199684,'DAILY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 07:35:33','543','2021-05-26 07:36:10',10,0),('1','144',199689,'DAILY SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 07:45:02','543','2021-05-26 07:46:37',10,0),('1','144',199695,'DAILY SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 07:58:13','543','2021-05-26 07:58:43',10,0),('1','144',199697,'DAILY SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 08:05:15','543','2021-05-26 08:05:34',10,0),('1','144',199701,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 08:09:50','543','2021-05-26 08:10:58',10,0),('1','144',199703,'DAILY SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 08:18:58','543','2021-05-26 08:19:23',10,0),('1','144',199706,'DAILY SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 08:23:58','543','2021-05-26 08:24:21',10,0),('1','144',199707,'DAILY SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 08:38:44','543','2021-05-26 08:39:09',10,0),('1','144',199715,'DAILY SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 08:44:59','543','2021-05-26 08:45:58',10,0),('1','144',199722,'DAILY SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 08:55:08','543','2021-05-26 08:55:28',10,0),('1','144',199728,'DAILY SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 09:00:15','543','2021-05-26 09:00:55',10,0),('1','144',199732,'DAILY SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-26 09:06:14','543','2021-05-26 09:06:35',10,0),('1','144',200889,'DAILY SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-31 21:14:57','543','2021-05-31 21:15:53',10,0),('1','144',200892,'DAILY SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-31 21:40:03','543','2021-05-31 21:40:46',10,0),('1','144',200893,'DAILY SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-31 22:00:02','543','2021-05-31 22:00:26',10,0),('1','144',200894,'DAILY SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-31 22:26:28','543','2021-05-31 22:26:57',10,0),('1','144',200896,'DAILY SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-31 22:36:14','543','2021-05-31 22:36:38',10,0),('1','144',200898,'DAILY SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-31 22:47:57','543','2021-05-31 22:48:27',10,0),('1','144',200899,'DAILY SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'543',0.00,0.00,'543','2021-05-31 22:58:25','543','2021-05-31 22:58:55',10,0),('1','144',200907,'DAILY SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-01 04:44:17','543','2021-06-01 04:44:46',10,0),('1','144',200908,'DAILY SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-01 05:00:00','543','2021-06-01 05:00:20',10,0),('1','144',200947,'DAILY SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-01 19:05:47','543','2021-06-01 20:50:54',10,0),('1','144',201098,'DAILY SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-02 19:10:04','543','2021-06-02 19:11:27',10,0),('1','144',201298,'DAILY SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-03 20:07:54','543','2021-06-03 20:09:00',10,0),('1','144',201488,'DAILY SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-04 21:23:22','543','2021-06-04 21:25:02',10,0),('1','144',201757,'DAILY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-05 16:06:18','543','2021-06-05 16:07:43',10,0),('1','144',202017,'DAILY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-06 12:05:08','543','2021-06-06 12:05:50',10,0),('1','144',202108,'DAILY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-06 19:34:40','543','2021-06-06 19:35:02',10,0),('1','144',202207,'DAILY SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-07 19:03:33','543','2021-06-07 19:04:45',10,0),('1','144',202416,'DAILY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-08 18:05:08','543','2021-06-08 18:06:24',10,0),('1','144',202633,'DAILY SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-09 18:38:31','543','2021-06-09 18:39:49',10,0),('1','144',202846,'DAILY SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-10 17:44:11','543','2021-06-10 17:45:12',10,0),('1','144',203106,'DAILY SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-11 18:16:51','543','2021-06-11 18:17:48',10,0),('1','144',203294,'DAILY SHIFT94716','2021-06-12','2021-06-12 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-12 18:53:32','543','2021-06-12 18:54:39',10,0),('1','144',203552,'DAILY SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-13 08:15:23','543','2021-06-13 08:15:44',10,0),('1','144',203564,'DAILY SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-13 20:22:28','543','2021-06-13 20:23:31',10,0),('1','144',203717,'DAILY SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-14 18:27:17','543','2021-06-14 18:28:16',10,0),('1','144',203952,'DAILY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-15 18:32:27','543','2021-06-15 18:33:47',10,0),('1','144',204185,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-16 18:26:06','543','2021-06-16 18:27:43',10,0),('1','144',204391,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-17 18:35:57','543','2021-06-17 18:36:58',10,0),('1','144',204618,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 19:22:33','543','2021-06-18 19:24:13',10,0),('1','144',204797,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 20:51:05','543','2021-06-18 20:51:28',10,0),('1','144',204798,'DAILY SHIFT','2020-11-12','2020-11-12 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 20:57:43','543','2021-06-18 20:58:05',10,0),('1','144',204799,'DAILY SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 21:04:05','543','2021-06-18 21:04:47',10,0),('1','144',204800,'DAILY SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 21:08:21','543','2021-06-18 21:08:59',10,0),('1','144',204801,'DAILY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 21:15:16','543','2021-06-18 21:15:35',10,0),('1','144',204802,'DAILY SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 21:21:07','543','2021-06-18 21:21:27',10,0),('1','144',204803,'DAILY SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 21:25:46','543','2021-06-18 21:26:07',10,0),('1','144',204804,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 21:31:18','543','2021-06-18 21:31:43',10,0),('1','144',204806,'DAILY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 21:36:00','543','2021-06-18 21:36:37',10,0),('1','144',204807,'DAILY SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 21:40:04','543','2021-06-18 21:40:24',10,0),('1','144',204808,'DAILY SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 21:44:29','543','2021-06-18 21:44:49',10,0),('1','144',204809,'DAILY SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 21:52:15','543','2021-06-18 21:52:44',10,0),('1','144',204810,'DAILY SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 22:00:45','543','2021-06-18 22:01:04',10,0),('1','144',204811,'DAILY SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 22:06:17','543','2021-06-18 22:06:50',10,0),('1','144',204812,'DAILY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 22:13:49','543','2021-06-18 22:14:34',10,0),('1','144',204814,'DAILY SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 22:20:07','543','2021-06-18 22:20:27',10,0),('1','144',204815,'DAILY SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 22:27:05','543','2021-06-18 22:27:25',10,0),('1','144',204816,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 22:36:37','543','2021-06-18 22:37:37',10,0),('1','144',204817,'DAILY SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 22:42:33','543','2021-06-18 22:42:55',10,0),('1','144',204818,'DAILY SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 22:46:28','543','2021-06-18 22:46:46',10,0),('1','144',204819,'DAILY SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 22:53:38','543','2021-06-18 22:53:59',10,0),('1','144',204820,'DAILY SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 22:57:43','543','2021-06-18 22:58:02',10,0),('1','144',204821,'DAILY SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 23:02:21','543','2021-06-18 23:02:44',10,0),('1','144',204822,'DAILY SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-18 23:20:38','543','2021-06-18 23:20:58',10,0),('1','144',204918,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-19 10:45:50','543','2021-06-19 10:46:11',10,0),('1','144',204938,'DAILY SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-19 20:18:39','543','2021-06-19 20:19:11',10,0),('1','144',205134,'DAILY SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-20 19:45:31','543','2021-06-20 19:45:55',10,0),('1','144',205224,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-21 19:01:25','543','2021-06-21 19:03:18',10,0),('1','144',205472,'DAILY SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-22 18:20:56','543','2021-06-22 18:24:10',10,0),('1','144',205716,'DAILY SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-23 18:23:59','543','2021-06-23 18:24:50',10,0),('1','144',205940,'DAILY SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-24 18:30:32','543','2021-06-24 18:31:59',10,0),('1','144',206222,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-26 07:44:35','543','2021-06-26 07:45:21',10,0),('1','144',206384,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-26 07:56:32','543','2021-06-26 07:56:55',10,0),('1','144',206387,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-27 06:03:03','543','2021-06-27 06:05:09',10,0),('1','144',206570,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-27 18:25:51','543','2021-06-27 18:28:26',10,0),('1','144',206795,'DAILY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-28 18:21:33','543','2021-06-28 18:24:03',10,0),('1','144',207015,'DAILY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-29 18:56:24','543','2021-06-29 18:57:52',10,0),('1','144',207346,'DAILY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-30 10:15:36','543','2021-06-30 10:16:27',10,0),('1','144',207350,'DAILY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'543',0.00,0.00,'543','2021-06-30 18:34:41','543','2021-06-30 18:36:23',10,0),('1','144',207472,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-01 18:18:41','543','2021-07-01 18:20:22',10,0),('1','144',207794,'DAILY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-02 18:55:19','543','2021-07-02 18:56:16',10,0),('1','144',207900,'DAILY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-03 19:06:08','543','2021-07-03 19:08:23',10,0),('1','144',208103,'DAILY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-05 07:27:06','543','2021-07-05 07:28:24',10,0),('1','144',208430,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-05 10:38:27','543','2021-07-05 10:38:50',10,0),('1','144',208446,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-05 20:15:59','543','2021-07-05 20:16:52',10,0),('1','144',208571,'DAILY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-06 19:05:35','543','2021-07-06 19:07:12',10,0),('1','144',208747,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-07 18:32:49','543','2021-07-07 18:36:25',10,0),('1','144',208992,'DAILY SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-08 19:47:39','543','2021-07-08 19:50:00',10,0),('1','144',209212,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-09 17:20:10','543','2021-07-09 17:21:41',10,0),('1','144',209402,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-09 18:30:02','543','2021-07-09 18:31:06',10,0),('1','144',209432,'DAILY SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-10 18:59:01','543','2021-07-10 19:00:05',10,0),('1','144',209633,'DAILY SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-11 18:20:05','543','2021-07-11 18:22:29',10,0),('1','144',209867,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-12 18:22:29','543','2021-07-12 18:26:01',10,0),('1','144',210103,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-13 18:49:15','543','2021-07-13 18:50:34',10,0),('1','144',210308,'DAILY SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-14 18:36:02','543','2021-07-14 18:38:06',10,0),('1','144',210521,'DAILY SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-16 09:25:20','543','2021-07-16 09:28:34',10,0),('1','144',210808,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-16 10:01:17','543','2021-07-16 10:01:53',10,0),('1','144',210812,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-16 19:31:18','543','2021-07-16 19:32:30',10,0),('1','144',210958,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-17 19:53:39','543','2021-07-17 19:55:25',10,0),('1','144',211183,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-18 19:06:44','543','2021-07-18 19:09:51',10,0),('1','144',211374,'DAILY SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-19 19:53:54','543','2021-07-19 19:59:09',10,0),('1','144',211600,'DAILY SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-20 14:28:50','543','2021-07-20 14:29:15',10,0),('1','144',211701,'DAILY SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-20 15:04:33','543','2021-07-20 15:06:22',10,0),('1','144',211709,'DAILY SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-20 18:59:33','543','2021-07-20 19:01:01',10,0),('1','144',211779,'DAILY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-21 20:19:21','543','2021-07-21 20:20:18',10,0),('1','144',211987,'DEALY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-22 19:57:29','543','2021-07-22 19:59:00',10,0),('1','144',212226,'DAILY SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-23 20:00:43','543','2021-07-23 20:01:46',10,0),('1','144',212452,'DAILY SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-24 18:55:45','543','2021-07-24 18:58:04',10,0),('1','144',212824,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-25 18:32:06','543','2021-07-25 18:32:47',10,0),('1','144',212827,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-25 18:54:21','543','2021-07-25 18:54:54',10,0),('1','144',212950,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-26 20:16:56','543','2021-07-26 20:18:31',10,0),('1','144',213127,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-27 18:55:49','543','2021-07-27 18:58:31',10,0),('1','144',213397,'DAILY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-28 18:34:21','543','2021-07-28 18:36:18',10,0),('1','144',213632,'DEALY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-29 18:19:26','543','2021-07-29 18:21:30',10,0),('1','144',213880,'DEALY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-30 19:05:25','543','2021-07-30 19:10:04',10,0),('1','144',214086,'DAILY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-31 10:26:57','543','2021-07-31 10:28:07',10,0),('1','144',214158,'DAILY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-31 10:34:52','543','2021-07-31 10:35:23',10,0),('1','144',214165,'DAILY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'543',0.00,0.00,'543','2021-07-31 21:46:09','543','2021-07-31 21:47:19',10,0),('1','144',214327,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-01 21:11:16','543','2021-08-01 21:12:50',10,0),('1','144',214518,'DAILY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-02 18:24:09','543','2021-08-02 18:46:16',10,0),('1','144',214769,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-03 19:41:49','543','2021-08-03 19:43:36',10,0),('1','144',214991,'DAILY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-04 18:01:00','543','2021-08-04 18:03:31',10,0),('1','144',215250,'DAILY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-05 18:03:20','543','2021-08-05 18:03:43',10,0),('1','144',215406,'DAILY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-05 18:17:01','543','2021-08-05 18:17:41',10,0),('1','144',215439,'DAILY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-06 18:18:31','543','2021-08-06 18:20:37',10,0),('1','144',215674,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-07 20:28:03','543','2021-08-07 20:29:55',10,0),('1','144',215904,'DAILY SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-08 18:29:17','543','2021-08-08 18:30:17',10,0),('1','144',216096,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-10 13:26:40','543','2021-08-10 13:29:00',10,0),('1','144',216550,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-11 06:21:02','543','2021-08-11 06:21:26',10,0),('1','144',217008,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-13 19:08:49','543','2021-08-13 19:10:41',10,0),('1','144',217265,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-14 18:25:34','543','2021-08-14 18:28:37',10,0),('1','144',217500,'DAILY SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-15 18:34:03','543','2021-08-15 18:47:59',10,0),('1','144',217703,'DAILY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-16 18:50:07','543','2021-08-16 18:53:25',10,0),('1','144',218171,'DAILY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-17 18:05:29','543','2021-08-17 18:05:54',10,0),('1','144',218321,'DAILY SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-18 19:05:45','543','2021-08-18 19:07:25',10,0),('1','144',218444,'DAILY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-19 18:26:52','543','2021-08-19 18:30:21',10,0),('1','144',218685,'DAILY SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-20 18:53:27','543','2021-08-20 18:54:09',10,0),('1','144',218908,'DAILY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-21 20:26:52','543','2021-08-21 20:29:13',10,0),('1','144',219148,'DAILY SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-22 19:08:42','543','2021-08-22 19:12:21',10,0),('1','144',219306,'DAILY SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-22 22:10:33','543','2021-08-22 22:10:56',10,0),('1','144',219339,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-23 19:13:46','543','2021-08-23 19:17:37',10,0),('1','144',219603,'DAILY SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-24 18:59:41','543','2021-08-24 19:01:53',10,0),('1','144',219798,'DAILY SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-25 18:18:29','543','2021-08-25 18:20:46',10,0),('1','144',220028,'DAILY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-26 20:34:37','543','2021-08-26 20:38:36',10,0),('1','144',220232,'DAILY SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-27 19:49:31','543','2021-08-27 19:50:34',10,0),('1','144',220445,'DAILY SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-27 20:12:55','543','2021-08-27 20:13:32',10,0),('1','144',220457,'DAILY SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-28 21:20:44','543','2021-08-28 21:23:48',10,0),('1','144',220686,'DAILY SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-29 19:29:20','543','2021-08-29 19:32:31',10,0),('1','144',220919,'DAILY SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-30 19:17:11','543','2021-08-30 19:20:06',10,0),('1','144',221129,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-31 19:16:55','543','2021-08-31 19:20:35',10,0),('1','144',221358,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'543',0.00,0.00,'543','2021-08-31 19:43:18','543','2021-08-31 19:43:40',10,0),('1','144',221384,'DAILY SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-01 19:17:18','543','2021-09-01 19:19:35',10,0),('1','144',221604,'DAILY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-02 20:28:32','543','2021-09-02 20:31:30',10,0),('1','144',221817,'DAILY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-03 18:36:39','543','2021-09-03 18:41:50',10,0),('1','144',222050,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-04 19:52:38','543','2021-09-04 19:55:01',10,0),('1','144',222246,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-05 11:53:29','543','2021-09-05 11:54:16',10,0),('1','144',222362,'DAILY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-05 19:37:42','543','2021-09-05 19:38:05',10,0),('1','144',222477,'DAILY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-06 20:59:04','543','2021-09-06 21:02:51',10,0),('1','144',222719,'DAILY SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-08 11:31:25','543','2021-09-08 11:33:08',10,0),('1','144',223050,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-08 18:22:33','543','2021-09-08 18:23:52',10,0),('1','144',223162,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-09 14:00:26','543','2021-09-09 14:02:36',10,0),('1','144',223369,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-10 05:23:31','543','2021-09-10 05:24:14',10,0),('1','144',223405,'DAILY SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-10 20:03:30','543','2021-09-10 20:07:12',10,0),('1','144',223631,'DAILY SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-11 20:47:24','543','2021-09-11 20:52:44',10,0),('1','144',223865,'DAILY SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-12 16:22:59','543','2021-09-12 16:26:57',10,0),('1','144',224029,'DAILY SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-12 16:57:22','543','2021-09-12 16:57:48',10,0),('1','144',224084,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-13 20:11:57','543','2021-09-13 20:13:06',10,0),('1','144',224298,'DAILY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-14 19:06:44','543','2021-09-14 19:13:15',10,0),('1','144',224520,'DAILY SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-15 21:13:11','543','2021-09-15 21:16:30',10,0),('1','144',224766,'DAILY SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-16 18:34:29','543','2021-09-16 18:38:58',10,0),('1','144',225005,'DAILY SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-17 19:47:18','543','2021-09-17 19:48:41',10,0),('1','144',225238,'DAILY SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-17 20:23:55','543','2021-09-17 20:24:20',10,0),('1','144',225308,'DAILY SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-18 18:22:02','543','2021-09-18 18:25:01',10,0),('1','144',225482,'DAILY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-19 17:50:26','543','2021-09-19 17:52:14',10,0),('1','144',225695,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-20 18:12:40','543','2021-09-20 18:15:19',10,0),('1','144',225962,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-21 18:06:05','543','2021-09-21 18:11:14',10,0),('1','144',226430,'DAILY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-22 16:54:08','543','2021-09-22 16:55:40',10,0),('1','144',226435,'DAILY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-22 17:10:11','543','2021-09-22 17:10:36',10,0),('1','144',226718,'DAILY SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-24 18:27:58','543','2021-09-24 18:38:33',10,0),('1','144',226941,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-25 21:10:53','543','2021-09-25 21:15:27',10,0),('1','144',227174,'DAILY SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-26 19:06:49','543','2021-09-26 19:08:44',10,0),('1','144',227576,'DAILY SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-27 18:54:19','543','2021-09-27 18:55:13',10,0),('1','144',227579,'DAILY SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-28 06:31:01','543','2021-09-28 06:31:27',10,0),('1','144',227614,'DAILY SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-28 18:02:51','543','2021-09-28 18:21:02',10,0),('1','144',227875,'DAILY SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-29 18:33:03','543','2021-09-29 18:43:36',10,0),('1','144',228126,'DAILY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'543',0.00,0.00,'543','2021-09-30 18:45:56','543','2021-09-30 18:47:31',10,0),('1','144',228343,'DAILY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-01 20:12:56','543','2021-10-01 20:16:17',10,0),('1','144',228536,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-02 18:59:00','543','2021-10-02 19:02:33',10,0),('1','144',228723,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-03 08:05:58','543','2021-10-03 08:07:44',10,0),('1','144',228775,'DAILY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-03 19:57:37','543','2021-10-03 19:59:14',10,0),('1','144',228952,'DAILY SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-04 18:46:53','543','2021-10-04 18:50:03',10,0),('1','144',229194,'DAILY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-05 18:49:06','543','2021-10-05 18:51:46',10,0),('1','144',229486,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-06 19:16:17','543','2021-10-06 19:16:53',10,0),('1','144',229637,'DAILY SHIFT797','2021-10-06','2021-10-06 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-08 14:37:49','543','2021-10-08 14:38:28',10,0),('1','144',230021,'DAILY SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-09 06:36:33','543','2021-10-09 06:37:00',10,0),('1','144',230102,'DAILY SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-09 18:06:57','543','2021-10-09 18:12:16',10,0),('1','144',230274,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-10 19:45:02','543','2021-10-10 19:46:43',10,0),('1','144',230515,'DAILY SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-11 20:00:09','543','2021-10-11 20:03:00',10,0),('1','144',230760,'DAILY SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-12 05:14:59','543','2021-10-12 05:15:16',10,0),('1','144',230770,'DAILY SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-12 18:30:36','543','2021-10-12 18:33:06',10,0),('1','144',231060,'DAILY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-13 17:53:54','543','2021-10-13 17:54:45',10,0),('1','144',231370,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-14 18:26:24','543','2021-10-14 18:32:30',10,0),('1','144',231625,'DAILY SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-15 19:54:43','543','2021-10-15 19:56:01',10,0),('1','144',231889,'DAILY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-16 17:53:32','543','2021-10-16 17:54:46',10,0),('1','144',232097,'DAILY SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-17 19:58:57','543','2021-10-17 20:03:11',10,0),('1','144',232299,'DAILY SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-17 20:19:57','543','2021-10-17 20:20:23',10,0),('1','144',232323,'DAILY SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-18 18:32:03','543','2021-10-18 18:34:35',10,0),('1','144',232575,'DAILY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-19 18:11:37','543','2021-10-19 18:31:56',10,0),('1','144',232874,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-20 18:10:59','543','2021-10-20 18:19:22',10,0),('1','144',233103,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-21 18:28:34','543','2021-10-21 18:31:28',10,0),('1','144',233360,'DAILY SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-22 18:40:37','543','2021-10-22 18:43:54',10,0),('1','144',233562,'DAILY SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-22 19:10:07','543','2021-10-22 19:10:32',10,0),('1','144',233584,'DAILY SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-23 18:07:28','543','2021-10-23 18:09:23',10,0),('1','144',233827,'DAILY SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-24 19:57:00','543','2021-10-24 19:57:59',10,0),('1','144',234045,'DAILY SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-25 17:51:52','543','2021-10-25 17:56:31',10,0),('1','144',234295,'DAILY SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-26 18:40:47','543','2021-10-26 18:44:39',10,0),('1','144',234602,'DAILY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-27 18:04:12','543','2021-10-27 18:16:42',10,0),('1','144',234811,'DAILY SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-28 18:38:39','543','2021-10-28 18:49:13',10,0),('1','144',235026,'DAILY SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-29 04:56:28','543','2021-10-29 04:56:51',10,0),('1','144',235052,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-29 18:05:39','543','2021-10-29 18:18:11',10,0),('1','144',235314,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-30 18:28:29','543','2021-10-30 18:30:12',10,0),('1','144',235544,'DAILY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'543',0.00,0.00,'543','2021-10-31 21:08:03','543','2021-10-31 21:09:23',10,0),('1','144',235750,'DAILY SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-01 18:04:06','543','2021-11-01 19:47:41',10,0),('1','144',236425,'DEALY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-03 16:11:56','543','2021-11-03 16:14:42',10,0),('1','144',236431,'DEALY SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-03 18:07:08','543','2021-11-03 18:08:02',10,0),('1','144',236450,'DEALY SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-03 19:03:10','543','2021-11-03 19:03:34',10,0),('1','144',236491,'DEALY SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-04 20:06:26','543','2021-11-04 20:09:21',10,0),('1','144',236716,'DEALY SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-05 19:15:21','543','2021-11-05 19:16:14',10,0),('1','144',236942,'DEALY SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-06 18:59:41','543','2021-11-06 19:00:22',10,0),('1','144',237160,'DEALY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-07 19:16:04','543','2021-11-07 19:20:25',10,0),('1','144',237339,'DEALY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-08 05:23:33','543','2021-11-08 05:23:55',10,0),('1','144',237376,'DEALY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-08 17:57:34','543','2021-11-08 17:58:12',10,0),('1','144',237605,'DEALY SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-09 18:52:20','543','2021-11-09 18:52:54',10,0),('1','144',237859,'DEALY SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-10 18:15:04','543','2021-11-10 18:16:45',10,0),('1','144',238099,'DEALY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-11 18:23:58','543','2021-11-11 18:24:41',10,0),('1','144',238308,'DEALY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-11 18:42:39','543','2021-11-11 18:42:56',10,0),('1','144',238340,'DEALY SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-12 18:28:24','543','2021-11-12 18:28:52',10,0),('1','144',238588,'DEALY SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-13 18:43:55','543','2021-11-13 18:45:07',10,0),('1','144',238814,'DEALY SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-14 18:00:24','543','2021-11-14 18:01:42',10,0),('1','144',239088,'DEALY SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-15 18:43:53','543','2021-11-15 18:44:46',10,0),('1','144',239309,'DEALY SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-16 18:37:40','543','2021-11-16 18:40:46',10,0),('1','144',239521,'DEALY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-17 18:51:46','543','2021-11-17 18:52:18',10,0),('1','144',239719,'DEALY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-18 05:44:38','543','2021-11-18 05:45:06',10,0),('1','144',239769,'DEALY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-18 18:26:29','543','2021-11-18 18:27:22',10,0),('1','144',239988,'DEALY SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-19 18:04:04','543','2021-11-19 18:04:35',10,0),('1','144',240191,'DEALY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-20 18:42:10','543','2021-11-20 18:42:34',10,0),('1','144',240448,'DEALY SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-21 17:56:21','543','2021-11-21 17:56:46',10,0),('1','144',240688,'DEALY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-22 18:43:42','543','2021-11-22 18:44:08',10,0),('1','144',240966,'DEALY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-23 18:07:52','543','2021-11-23 18:08:49',10,0),('1','144',241170,'DEALY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-24 05:37:33','543','2021-11-24 05:37:54',10,0),('1','144',241217,'DEALY SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-24 18:08:25','543','2021-11-24 18:08:49',10,0),('1','144',241585,'DEALY SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-25 17:48:37','543','2021-11-25 17:49:09',10,0),('1','144',241721,'DEALY SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-26 17:57:24','543','2021-11-26 17:58:06',10,0),('1','144',241982,'DEALY SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-27 17:55:07','543','2021-11-27 17:55:46',10,0),('1','144',242187,'DEALY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-28 17:51:58','543','2021-11-28 17:52:26',10,0),('1','144',242425,'DEALY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-29 17:56:57','543','2021-11-29 17:57:36',10,0),('1','144',242654,'DEALY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-30 18:15:57','543','2021-11-30 18:16:38',10,0),('1','144',242859,'DEALY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'543',0.00,0.00,'543','2021-11-30 18:36:03','543','2021-11-30 18:36:26',10,0),('1','144',242913,'DEALY SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-01 18:41:30','543','2021-12-01 18:42:07',10,0),('1','144',243122,'DEALY SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-02 17:56:27','543','2021-12-02 17:57:25',10,0),('1','144',243361,'DEALY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-03 18:13:35','543','2021-12-03 18:24:32',10,0),('1','144',243594,'DEALY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-04 17:51:17','543','2021-12-04 17:52:58',10,0),('1','144',243824,'DEALY SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-05 17:47:10','543','2021-12-05 17:47:54',10,0),('1','144',244046,'DEALY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-06 17:34:08','543','2021-12-06 17:46:41',10,0),('1','144',244293,'DEALY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-07 18:58:52','543','2021-12-07 18:59:58',10,0),('1','144',244468,'DEALY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-08 05:55:15','543','2021-12-08 05:55:36',10,0),('1','144',244518,'DEALY SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-08 18:13:25','543','2021-12-08 18:16:34',10,0),('1','144',244748,'DEALY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-09 18:12:16','543','2021-12-09 18:13:32',10,0),('1','144',244971,'DEALY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-10 17:47:17','543','2021-12-10 17:49:11',10,0),('1','144',245216,'DEALY SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-11 18:34:19','543','2021-12-11 18:35:18',10,0),('1','144',245430,'DEALY SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-12 18:31:37','543','2021-12-12 18:32:08',10,0),('1','144',245676,'DEALY SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-13 18:37:38','543','2021-12-13 18:39:21',10,0),('1','144',245982,'DEALY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-14 18:23:10','543','2021-12-14 18:24:51',10,0),('1','144',246139,'DEALY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-15 05:41:00','543','2021-12-15 05:41:23',10,0),('1','144',246183,'DEALY SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-15 18:19:22','543','2021-12-15 18:20:44',10,0),('1','144',246452,'DEALY SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-16 17:54:04','543','2021-12-16 17:54:59',10,0),('1','144',246696,'DEALY SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-17 17:58:46','543','2021-12-17 18:01:11',10,0),('1','144',246930,'DEALY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-18 18:15:25','543','2021-12-18 18:15:56',10,0),('1','144',247164,'DEALY SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-19 18:21:34','543','2021-12-19 18:22:00',10,0),('1','144',247391,'DEALY SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-20 18:13:29','543','2021-12-20 18:14:06',10,0),('1','144',247604,'DEALY SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-21 05:46:29','543','2021-12-21 05:46:50',10,0),('1','144',247661,'DEALY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-21 18:06:54','543','2021-12-21 18:08:22',10,0),('1','144',247910,'DEALY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-22 21:45:58','543','2021-12-22 21:46:55',10,0),('1','144',248149,'DEALY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-23 18:01:30','543','2021-12-23 18:03:07',10,0),('1','144',248393,'DEALY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-24 18:01:33','543','2021-12-24 18:02:36',10,0),('1','144',248635,'DEALY SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-25 18:50:34','543','2021-12-25 18:51:34',10,0),('1','144',248864,'DEALY SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-26 18:18:25','543','2021-12-26 18:18:51',10,0),('1','144',249055,'DEALY SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-27 05:59:56','543','2021-12-27 06:00:19',10,0),('1','144',249103,'DEALY SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-27 18:01:23','543','2021-12-27 18:02:13',10,0),('1','144',249338,'DEALY SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-28 17:55:33','543','2021-12-28 17:56:48',10,0),('1','144',249583,'DEALY SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-29 18:18:21','543','2021-12-29 18:19:22',10,0),('1','144',249849,'DEALY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-30 18:07:09','543','2021-12-30 18:08:20',10,0),('1','144',250093,'DEALY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'543',0.00,0.00,'543','2021-12-31 19:16:55','543','2021-12-31 19:17:46',10,0),('1','144',250330,'DEALY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-01 18:01:57','543','2022-01-01 18:02:35',10,0),('1','144',250559,'DEALY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-02 18:16:27','543','2022-01-02 18:17:02',10,0),('1','144',250745,'DEALY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-03 05:41:03','543','2022-01-03 05:41:24',10,0),('1','144',250792,'DEALY SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-03 17:57:20','543','2022-01-03 17:58:09',10,0),('1','144',251032,'DEALY SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-04 18:15:18','543','2022-01-04 18:15:53',10,0),('1','144',251267,'DEALY SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-05 19:38:40','543','2022-01-05 19:42:18',10,0),('1','144',251513,'DEALY SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-06 18:57:46','543','2022-01-06 18:59:11',10,0),('1','144',251753,'DEALY SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-07 18:53:35','543','2022-01-07 18:57:40',10,0),('1','144',251985,'DEALY SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-08 19:22:07','543','2022-01-08 19:25:10',10,0),('1','144',252233,'DEALY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-09 20:07:04','543','2022-01-09 20:08:51',10,0),('1','144',252474,'DEALY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-10 19:28:24','543','2022-01-10 19:32:00',10,0),('1','144',252661,'DEALY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-11 06:41:42','543','2022-01-11 06:42:05',10,0),('1','144',252708,'DEALY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-11 19:39:31','543','2022-01-11 19:43:37',10,0),('1','144',252963,'DEALY SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-12 19:24:34','543','2022-01-12 19:26:32',10,0),('1','144',253195,'DEALY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-13 19:55:10','543','2022-01-13 19:59:28',10,0),('1','144',253492,'DEALY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-14 19:07:03','543','2022-01-14 19:10:06',10,0),('1','144',253708,'DEALY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-15 19:16:06','543','2022-01-15 19:26:34',10,0),('1','144',253961,'DEALY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-16 20:07:11','543','2022-01-16 20:10:45',10,0),('1','144',254150,'DEALY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-16 20:53:50','543','2022-01-16 20:54:29',10,0),('1','144',254193,'DEALY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-17 19:13:02','543','2022-01-17 19:17:19',10,0),('1','144',254448,'DEALY SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-18 19:41:20','543','2022-01-18 19:44:59',10,0),('1','144',254756,'DEALY SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-19 19:08:39','543','2022-01-19 19:11:48',10,0),('1','144',254953,'DEALY SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-20 19:44:41','543','2022-01-20 19:46:42',10,0),('1','144',255196,'DEALY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-21 19:10:39','543','2022-01-21 19:14:51',10,0),('1','144',255467,'DEALY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-22 19:55:10','543','2022-01-22 19:59:48',10,0),('1','144',255667,'DEALY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-22 20:26:03','543','2022-01-22 20:26:31',10,0),('1','144',255710,'DEALY SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-23 19:28:53','543','2022-01-23 19:48:27',10,0),('1','144',255952,'DEALY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-24 17:23:32','543','2022-01-24 17:24:17',10,0),('1','144',256382,'DEALY SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-25 20:32:33','543','2022-01-25 20:33:31',10,0),('1','144',256492,'DEALY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-26 19:42:12','543','2022-01-26 19:50:28',10,0),('1','144',256730,'DEALY SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-27 20:37:17','543','2022-01-27 20:38:51',10,0),('1','144',256916,'DEALY SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-28 07:09:54','543','2022-01-28 07:10:30',10,0),('1','144',256969,'DEALY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-28 21:01:49','543','2022-01-28 21:04:10',10,0),('1','144',257243,'DEALY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-29 19:07:41','543','2022-01-29 19:09:01',10,0),('1','144',257499,'DEALY SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-31 10:51:01','543','2022-01-31 10:51:24',10,0),('1','144',257500,'DAILY SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'543',0.00,0.00,'543','2022-01-31 19:38:37','543','2022-01-31 19:39:08',10,0),('1','144',257501,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-01 19:45:53','543','2022-02-01 19:46:21',10,0),('1','144',257502,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-02 19:49:18','543','2022-02-02 19:49:39',10,0),('1','144',257503,'DAILY SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-03 20:12:00','543','2022-02-03 20:12:21',10,0),('1','144',257504,'DAILY SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-03 20:31:06','543','2022-02-03 20:31:23',10,0),('1','144',257505,'DAILY SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-04 20:05:15','543','2022-02-04 20:05:36',10,0),('1','144',257506,'DAILY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-05 19:13:19','543','2022-02-05 19:13:44',10,0),('1','144',257507,'DAILY SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-06 20:43:59','543','2022-02-06 20:44:17',10,0),('1','144',257508,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-07 19:24:42','543','2022-02-07 19:25:02',10,0),('1','144',257509,'DAILY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-08 20:18:10','543','2022-02-08 20:18:32',10,0),('1','144',257510,'DAILY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-08 20:48:30','543','2022-02-08 20:48:49',10,0),('1','144',257511,'DAILY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-09 19:29:01','543','2022-02-09 19:29:24',10,0),('1','144',257512,'DAILY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-10 19:54:20','543','2022-02-10 19:54:40',10,0),('1','144',257513,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-11 19:24:43','543','2022-02-11 19:25:03',10,0),('1','144',257514,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-12 19:59:06','543','2022-02-12 19:59:34',10,0),('1','144',257515,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-13 19:59:49','543','2022-02-13 20:00:10',10,0),('1','144',257516,'DAILY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-14 19:16:45','543','2022-02-14 19:17:08',10,0),('1','144',257517,'DAILY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-15 19:59:22','543','2022-02-15 19:59:44',10,0),('1','144',257518,'DAILY SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-16 06:56:33','543','2022-02-16 06:56:51',10,0),('1','144',257519,'DAILY SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-16 19:51:12','543','2022-02-16 19:51:34',10,0),('1','144',257520,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-17 19:24:49','543','2022-02-17 19:25:12',10,0),('1','144',257521,'DAILY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-18 19:25:37','543','2022-02-18 19:26:20',10,0),('1','144',257522,'DAILY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-19 19:35:32','543','2022-02-19 19:35:51',10,0),('1','144',257523,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-20 19:29:54','543','2022-02-20 19:30:14',10,0),('1','144',257524,'DAILY SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'543',0.00,0.00,'543','2022-02-21 19:27:21','543','2022-02-21 19:27:40',10,0),('1','144',257525,'DAILY SHIFT','2022-02-22','2022-02-22 07:30:17','2022-02-23 07:30:17','543',0.00,0.00,'543','2022-02-22 20:11:27','543','2022-02-22 20:11:45',10,0),('1','144',257526,'DAILY SHIFT','2022-02-23','2022-02-23 07:14:59','2022-02-24 07:14:59','543',0.00,0.00,'543','2022-02-23 07:29:23','543','2022-02-23 07:29:45',10,0),('1','144',257527,'DAILY SHIFT','2022-02-23','2022-02-23 07:30:16','2022-02-24 07:30:16','543',0.00,0.00,'543','2022-02-23 19:59:15','543','2022-02-23 19:59:34',10,0),('1','144',257528,'DAILY SHIFT','2022-02-24','2022-02-24 08:06:22','2022-02-25 08:06:22','543',0.00,0.00,'543','2022-02-25 06:40:36','543','2022-02-25 06:40:52',10,0),('1','144',257529,'DAILY SHIFT','2022-02-25','2022-02-25 07:41:14','2022-02-26 07:41:14','543',0.00,0.00,'543','2022-02-25 19:45:19','543','2022-02-25 19:45:41',10,0),('1','144',257530,'DAILY SHIFT','2022-02-26','2022-02-26 07:57:19','2022-02-27 07:57:19','543',0.00,0.00,'543','2022-02-26 19:21:22','543','2022-02-26 19:21:45',10,0),('1','144',257531,'DAILY SHIFT','2022-02-27','2022-02-27 07:43:58','2022-02-28 07:43:58','543',0.00,0.00,'543','2022-02-27 19:14:51','543','2022-02-27 19:15:19',10,0),('1','144',257532,'DAILY SHIFT','2022-02-28','2022-02-28 07:13:11','2022-03-01 07:13:11','543',0.00,0.00,'543','2022-02-28 19:23:53','543','2022-02-28 19:24:14',10,0),('1','144',257533,'DAILY SHIFT','2022-03-01','2022-03-01 08:00:39','2022-03-02 08:00:39','543',0.00,0.00,'543','2022-03-01 20:03:57','543','2022-03-01 20:04:18',10,0),('1','144',257534,'DAILY SHIFT','2022-03-02','2022-03-02 07:44:20','2022-03-03 07:44:20','543',0.00,0.00,'543','2022-03-02 19:41:32','543','2022-03-02 19:42:36',10,0),('1','144',257535,'DAILY SHIFT','2022-03-02','2022-03-02 20:07:44','2022-03-03 20:07:44','543',0.00,0.00,'543','2022-03-03 07:17:41','543','2022-03-03 07:17:57',10,0),('1','144',257536,'DAILY SHIFT','2022-03-03','2022-03-03 07:18:19','2022-03-04 07:18:19','543',0.00,0.00,'543','2022-03-03 19:59:59','543','2022-03-03 20:00:34',10,0),('1','144',257537,'DAILY SHIFT','2022-03-04','2022-03-04 07:19:40','2022-03-05 07:19:40','543',0.00,0.00,'543','2022-03-04 20:04:00','543','2022-03-04 20:04:18',10,0),('1','144',257538,'DAILY SHIFT','2022-03-05','2022-03-05 07:48:54','2022-03-06 07:48:54','543',0.00,0.00,'543','2022-03-05 19:57:49','543','2022-03-05 19:58:07',10,0),('1','144',257539,'DAILY SHIFT','2022-03-06','2022-03-06 06:46:18','2022-03-07 06:46:18','543',0.00,0.00,'543','2022-03-06 19:27:40','543','2022-03-06 19:28:00',10,0),('1','144',257540,'DAILY SHIFT','2022-03-07','2022-03-07 07:38:27','2022-03-08 07:38:27','543',0.00,0.00,'543','2022-03-07 19:35:15','543','2022-03-07 19:35:37',10,0),('1','144',257541,'DAILY SHIFT','2022-03-08','2022-03-08 07:15:15','2022-03-09 07:15:15','543',0.00,0.00,'543','2022-03-08 20:05:11','543','2022-03-08 20:05:27',10,0),('1','144',257542,'DAILY SHIFT','2022-03-08','2022-03-08 20:26:33','2022-03-09 20:26:33','543',0.00,0.00,'543','2022-03-09 07:35:18','543','2022-03-09 07:36:34',10,0),('1','144',257543,'DAILY SHIFT','2022-03-09','2022-03-09 07:37:03','2022-03-10 07:37:03','543',0.00,0.00,'543','2022-03-09 20:15:32','543','2022-03-09 20:15:52',10,0),('1','144',257544,'DAILY SHIFT','2022-03-10','2022-03-10 07:13:59','2022-03-11 07:13:59','543',0.00,0.00,'543','2022-03-10 20:33:10','543','2022-03-10 20:33:32',10,0),('1','144',257545,'DAILY SHIFT','2022-03-11','2022-03-11 08:05:07','2022-03-12 08:05:07','543',0.00,0.00,'543','2022-03-11 20:12:16','543','2022-03-11 20:12:36',10,0),('1','144',257546,'DAILY SHIFT','2022-03-12','2022-03-12 07:06:58','2022-03-13 07:06:58','543',0.00,0.00,'543','2022-03-12 19:23:43','543','2022-03-12 19:24:01',10,0),('1','144',257547,'DAILY SHIFT','2022-03-13','2022-03-13 07:04:56','2022-03-14 07:04:56','543',0.00,0.00,'543','2022-03-13 19:57:45','543','2022-03-13 19:58:09',10,0),('1','144',257548,'DAILY SHIFT','2022-03-14','2022-03-14 07:02:35','2022-03-15 07:02:35','543',0.00,0.00,'543','2022-03-14 20:00:23','543','2022-03-14 20:00:37',10,0),('1','144',257549,'DAILY SHIFT','2022-03-15','2022-03-15 07:14:22','2022-03-16 07:14:22','543',0.00,0.00,'543','2022-03-15 19:37:00','543','2022-03-15 19:37:17',10,0),('1','144',257550,'DAILY SHIFT','2022-03-16','2022-03-16 07:06:28','2022-03-17 07:06:28','543',0.00,0.00,'543','2022-03-16 20:06:12','543','2022-03-16 20:06:30',10,0),('1','144',257551,'DAILY SHIFT','2022-03-16','2022-03-16 20:20:04','2022-03-17 20:20:04','543',0.00,0.00,'543','2022-03-17 06:42:41','543','2022-03-17 06:43:01',10,0),('1','144',257552,'DAILY SHIFT','2022-03-17','2022-03-17 06:43:22','2022-03-18 06:43:22','543',0.00,0.00,'543','2022-03-17 19:45:09','543','2022-03-17 19:45:34',10,0),('1','144',257553,'DAILY SHIFT','2022-03-18','2022-03-18 07:05:41','2022-03-19 07:05:41','543',0.00,0.00,'543','2022-03-18 19:31:41','543','2022-03-18 19:32:00',10,0),('1','144',257554,'DAILY SHIFT','2022-03-19','2022-03-19 06:44:05','2022-03-20 06:44:05','543',0.00,0.00,'543','2022-03-19 19:16:26','543','2022-03-19 19:16:45',10,0),('1','144',257555,'DAILY SHIFT','2022-03-20','2022-03-20 07:00:47','2022-03-21 07:00:47','543',0.00,0.00,'543','2022-03-20 19:47:39','543','2022-03-20 19:47:56',10,0),('1','144',257556,'DAILY SHIFT','2022-03-21','2022-03-21 06:36:14','2022-03-22 06:36:14','543',0.00,0.00,'543','2022-03-21 19:54:24','543','2022-03-21 19:54:44',10,0),('1','144',257557,'DAILY SHIFT','2022-03-22','2022-03-22 07:09:29','2022-03-23 07:09:29','543',0.00,0.00,'543','2022-03-22 20:39:36','543','2022-03-22 20:39:56',10,0),('1','144',257558,'DAILY SHIFT','2022-03-23','2022-03-23 06:42:23','2022-03-24 06:42:23','543',0.00,0.00,'543','2022-03-23 20:03:59','543','2022-03-23 20:04:21',10,0),('1','144',257559,'DAILY SHIFT','2022-03-23','2022-03-23 20:15:54','2022-03-24 20:15:54','543',0.00,0.00,'543','2022-03-24 19:37:19','543','2022-03-24 19:37:37',10,0),('1','144',257560,'DAILY SHIFT','2022-03-25','2022-03-25 06:28:19','2022-03-26 06:28:19','543',0.00,0.00,'543','2022-03-25 19:49:18','543','2022-03-25 19:49:36',10,0),('1','144',257561,'DAILY SHIFT','2022-03-26','2022-03-26 07:10:00','2022-03-27 07:10:00','543',0.00,0.00,'543','2022-03-26 19:49:43','543','2022-03-26 19:50:00',10,0),('1','144',257562,'DAILY SHIFT','2022-03-27','2022-03-27 07:17:15','2022-03-28 07:17:15','543',0.00,0.00,'543','2022-03-27 19:45:18','543','2022-03-27 19:45:35',10,0),('1','144',257563,'DAILY SHIFT','2022-03-28','2022-03-28 06:50:40','2022-03-29 06:50:40','543',0.00,0.00,'543','2022-03-28 20:25:08','543','2022-03-28 20:25:36',10,0),('1','144',257564,'DAILY SHIFT','2022-03-29','2022-03-29 06:50:46','2022-03-30 06:50:46','543',0.00,0.00,'543','2022-03-29 20:16:01','543','2022-03-29 20:16:24',10,0),('1','144',257565,'DAILY SHIFT','2022-03-30','2022-03-30 06:49:36','2022-03-31 06:49:36','543',0.00,0.00,'543','2022-03-30 21:30:30','543','2022-03-30 21:30:53',10,0),('1','144',257566,'DAILY SHIFT','2022-03-31','2022-03-31 06:58:26','2022-04-01 06:58:26','543',0.00,0.00,'543','2022-03-31 20:28:49','543','2022-03-31 20:29:09',10,0),('1','144',257567,'DAILY SHIFT','2022-03-31','2022-03-31 20:44:11','2022-04-01 20:44:11','543',0.00,0.00,'543','2022-03-31 20:50:21','543','2022-03-31 20:50:40',10,0),('1','144',257568,'DAILY SHIFT','2022-04-01','2022-04-01 07:15:16','2022-04-02 07:15:16','543',0.00,0.00,'543','2022-04-01 20:18:23','543','2022-04-01 20:18:44',10,0),('1','144',257569,'DAILY SHIFT','2022-04-02','2022-04-02 06:35:52','2022-04-03 06:35:52','543',0.00,0.00,'543','2022-04-02 20:04:08','543','2022-04-02 20:04:26',10,0),('1','144',257570,'DAILY SHIFT','2022-04-03','2022-04-03 06:33:39','2022-04-04 06:33:39','543',0.00,0.00,'543','2022-04-03 19:38:29','543','2022-04-03 19:38:56',10,0),('1','144',257571,'DAILY SHIFT','2022-04-04','2022-04-04 06:24:00','2022-04-05 06:24:00','543',0.00,0.00,'543','2022-04-04 20:29:54','543','2022-04-04 20:30:12',10,0),('1','144',257572,'DAILY SHIFT','2022-04-04','2022-04-04 20:42:57','2022-04-05 20:42:57','543',0.00,0.00,'543','2022-04-04 21:00:45','543','2022-04-04 21:01:02',10,0),('1','144',257573,'DAILY SHIFT','2022-04-05','2022-04-05 06:45:03','2022-04-06 06:45:03','543',0.00,0.00,'543','2022-04-05 20:18:33','543','2022-04-05 20:18:51',10,0),('1','144',257574,'DAILY SHIFT','2022-04-06','2022-04-06 06:40:00','2022-04-07 06:40:00','543',0.00,0.00,'543','2022-04-06 20:00:39','543','2022-04-06 20:01:01',10,0),('1','144',257575,'DAILY SHIFT','2022-04-07','2022-04-07 06:42:07','2022-04-08 06:42:07','543',0.00,0.00,'543','2022-04-07 20:12:11','543','2022-04-07 20:12:37',10,0),('1','144',257576,'DAILY SHIFT','2022-04-08','2022-04-08 06:42:06','2022-04-09 06:42:06','543',0.00,0.00,'543','2022-04-08 20:04:41','543','2022-04-08 20:04:58',10,0),('1','144',257577,'DAILY SHIFT','2022-04-09','2022-04-09 06:21:03','2022-04-10 06:21:03','543',0.00,0.00,'543','2022-04-09 20:22:59','543','2022-04-09 20:23:21',10,0),('1','144',257578,'DAILY SHIFT','2022-04-10','2022-04-10 06:30:30','2022-04-11 06:30:30','543',0.00,0.00,'543','2022-04-10 20:43:09','543','2022-04-10 20:43:29',10,0),('1','144',257579,'DAILY SHIFT','2022-04-11','2022-04-11 06:46:37','2022-04-12 06:46:37','543',0.00,0.00,'543','2022-04-11 22:12:29','543','2022-04-11 22:13:36',10,0),('1','144',257580,'DAILY SHIFT','2022-04-11','2022-04-11 22:27:55','2022-04-12 22:27:55','543',0.00,0.00,'543','2022-04-11 22:32:17','543','2022-04-11 22:32:41',10,0),('1','144',257581,'DAILY SHIFT','2022-04-12','2022-04-12 22:53:10','2022-04-13 22:53:10','543',0.00,0.00,'543','2022-04-12 23:02:12','543','2022-04-12 23:02:31',10,0),('1','144',257582,'DAILY SHIFT','2022-04-13','2022-04-13 06:29:43','2022-04-14 06:29:43','543',0.00,0.00,'543','2022-04-13 20:17:01','543','2022-04-13 20:17:29',10,0),('1','144',257583,'DAILY SHIFT','2022-04-14','2022-04-14 06:40:56','2022-04-15 06:40:56','543',0.00,0.00,'543','2022-04-14 19:28:57','543','2022-04-14 19:29:14',10,0),('1','144',257584,'DAILY SHIFT','2022-04-15','2022-04-15 06:31:53','2022-04-16 06:31:53','543',0.00,0.00,'543','2022-04-15 20:21:52','543','2022-04-15 20:22:13',10,0),('1','144',257585,'DAILY SHIFT','2022-04-16','2022-04-16 06:51:53','2022-04-17 06:51:53','543',0.00,0.00,'543','2022-04-16 20:33:32','543','2022-04-16 20:33:50',10,0),('1','144',257586,'DAILY SHIFT','2022-04-17','2022-04-17 06:39:02','2022-04-18 06:39:02','543',0.00,0.00,'543','2022-04-17 19:25:10','543','2022-04-17 19:25:27',10,0),('1','144',257587,'DAILY SHIFT','2022-04-18','2022-04-18 06:23:59','2022-04-19 06:23:59','543',0.00,0.00,'543','2022-04-18 20:12:36','543','2022-04-18 20:13:01',10,0),('1','144',257588,'DAILY SHIFT','2022-04-18','2022-04-18 20:28:07','2022-04-19 20:28:07','543',0.00,0.00,'543','2022-04-19 06:39:43','543','2022-04-19 06:40:16',10,0),('1','144',257589,'DAILY SHIFT','2022-04-19','2022-04-19 06:40:49','2022-04-20 06:40:49','543',0.00,0.00,'543','2022-04-19 20:19:39','543','2022-04-19 20:20:06',10,0),('1','144',257590,'DAILY SHIFT','2022-04-20','2022-04-20 07:01:21','2022-04-21 07:01:21','543',0.00,0.00,'543','2022-04-20 19:38:19','543','2022-04-20 19:38:59',10,0),('1','144',257591,'DAILY SHIFT','2022-04-21','2022-04-21 05:55:33','2022-04-22 05:55:33','543',0.00,0.00,'543','2022-04-22 06:25:06','543','2022-04-22 06:25:36',10,0),('1','144',257592,'DAILY SHIFT','2022-04-22','2022-04-22 06:26:08','2022-04-23 06:26:08','543',0.00,0.00,'543','2022-04-22 19:28:07','543','2022-04-22 19:28:25',10,0),('1','144',257593,'DAILY SHIFT','2022-04-23','2022-04-23 06:47:35','2022-04-24 06:47:35','543',0.00,0.00,'543','2022-04-23 19:39:59','543','2022-04-23 19:40:17',10,0),('1','144',257594,'DAILY SHIFT','2022-04-24','2022-04-24 06:34:18','2022-04-25 06:34:18','543',0.00,0.00,'543','2022-04-24 19:57:10','543','2022-04-24 19:57:27',10,0),('1','144',257595,'DAILY SHIFT','2022-04-25','2022-04-25 06:16:41','2022-04-26 06:16:41','543',0.00,0.00,'543','2022-04-25 19:22:40','543','2022-04-25 19:23:02',10,0),('1','144',257596,'DAILY SHIFT','2022-04-26','2022-04-26 06:17:00','2022-04-27 06:17:00','543',0.00,0.00,'543','2022-04-26 19:34:37','543','2022-04-26 19:34:54',10,0),('1','144',257597,'DAILY SHIFT','2022-04-27','2022-04-27 06:15:51','2022-04-28 06:15:51','543',0.00,0.00,'543','2022-04-27 21:25:49','543','2022-04-27 21:26:22',10,0),('1','144',257598,'DAILY SHIFT','2022-04-27','2022-04-27 21:37:31','2022-04-28 21:37:31','543',0.00,0.00,'543','2022-04-27 22:11:42','543','2022-04-27 22:12:51',10,0),('1','144',257599,'DAILY SHIFT','2022-04-28','2022-04-28 07:04:07','2022-04-29 07:04:07','543',0.00,0.00,'543','2022-04-28 20:05:42','543','2022-04-28 20:05:59',10,0),('1','144',257600,'DAILY SHIFT','2022-04-29','2022-04-29 06:30:39','2022-04-30 06:30:39','543',0.00,0.00,'543','2022-04-29 20:39:35','543','2022-04-29 20:39:54',10,0),('1','144',257601,'DAILY SHIFT','2022-04-30','2022-04-30 07:38:39','2022-05-01 07:38:39','543',0.00,0.00,'543','2022-04-30 20:11:22','543','2022-04-30 20:11:46',10,0),('1','144',257602,'DAILY SHIFT','2022-05-01','2022-05-01 06:40:02','2022-05-02 06:40:02','543',0.00,0.00,'543','2022-05-01 20:02:27','543','2022-05-01 20:02:44',10,0),('1','144',257603,'DAILY SHIFT','2022-05-02','2022-05-02 07:28:08','2022-05-03 07:28:08','543',0.00,0.00,'543','2022-05-02 19:17:31','543','2022-05-02 19:17:53',10,0),('1','144',257604,'DAILY SHIFT','2022-05-03','2022-05-03 06:43:54','2022-05-04 06:43:54','543',0.00,0.00,'543','2022-05-03 19:45:05','543','2022-05-03 19:45:27',10,0),('1','144',257605,'DAILY SHIFT','2022-05-04','2022-05-04 07:30:29','2022-05-05 07:30:29','543',0.00,0.00,'543','2022-05-04 20:08:34','543','2022-05-04 20:09:11',10,0),('1','144',257606,'DAILY SHIFT','2022-05-04','2022-05-04 20:25:36','2022-05-05 20:25:36','543',0.00,0.00,'543','2022-05-05 06:49:16','543','2022-05-05 06:49:48',10,0),('1','144',257607,'DAILY SHIFT','2022-05-05','2022-05-05 06:50:26','2022-05-06 06:50:26','543',0.00,0.00,'543','2022-05-06 07:17:26','543','2022-05-06 07:17:54',10,0),('1','144',257608,'DAILY SHIFT','2022-05-06','2022-05-06 07:18:21','2022-05-07 07:18:21','543',0.00,0.00,'543','2022-05-06 19:33:09','543','2022-05-06 19:33:27',10,0),('1','144',257609,'DAILY SHIFT','2022-05-07','2022-05-07 06:47:02','2022-05-08 06:47:02','543',0.00,0.00,'543','2022-05-07 20:08:28','543','2022-05-07 20:09:06',10,0),('1','144',257610,'DAILY SHIFT','2022-05-08','2022-05-08 06:34:16','2022-05-09 06:34:16','543',0.00,0.00,'543','2022-05-08 19:42:14','543','2022-05-08 19:42:42',10,0),('1','144',257611,'DAILY SHIFT','2022-05-09','2022-05-09 06:29:50','2022-05-10 06:29:50','543',0.00,0.00,'543','2022-05-09 20:01:12','543','2022-05-09 20:01:32',10,0),('1','144',257612,'DAILY SHIFT','2022-05-10','2022-05-10 06:41:04','2022-05-11 06:41:04','543',0.00,0.00,'543','2022-05-10 21:03:15','543','2022-05-10 21:03:33',10,0),('1','144',257613,'DAILY SHIFT','2022-05-10','2022-05-10 21:06:57','2022-05-11 21:06:57','543',0.00,0.00,'543','2022-05-10 21:20:22','543','2022-05-10 21:20:41',10,0),('1','144',257614,'DAILY SHIFT','2022-05-11','2022-05-11 06:26:48','2022-05-12 06:26:48','543',0.00,0.00,'543','2022-05-11 19:27:52','543','2022-05-11 19:28:10',10,0),('1','144',257615,'DAILY SHIFT','2022-05-12','2022-05-12 06:10:33','2022-05-13 06:10:33','543',0.00,0.00,'543','2022-05-12 19:33:11','543','2022-05-12 19:33:32',10,0),('1','144',257616,'DAILY SHIFT','2022-05-13','2022-05-13 06:29:39','2022-05-14 06:29:39','543',0.00,0.00,'543','2022-05-13 19:20:26','543','2022-05-13 19:20:43',10,0),('1','144',257617,'DAILY SHIFT','2022-05-14','2022-05-14 06:55:55','2022-05-15 06:55:55','543',0.00,0.00,'543','2022-05-14 19:36:50','543','2022-05-14 19:37:31',10,0),('1','144',257618,'DAILY SHIFT','2022-05-15','2022-05-15 06:09:01','2022-05-16 06:09:01','543',0.00,0.00,'543','2022-05-16 07:04:21','543','2022-05-16 07:06:11',10,0),('1','144',257619,'DAILY SHIFT','2022-05-16','2022-05-16 08:39:27','2022-05-17 08:39:27','543',0.00,0.00,'543','2022-05-16 19:08:02','543','2022-05-16 19:08:22',10,0),('1','144',257620,'DAILY SHIFT','2022-05-17','2022-05-17 09:53:01','2022-05-18 09:53:01','543',0.00,0.00,'543','2022-05-17 18:28:07','543','2022-05-17 18:28:26',10,0),('1','144',257621,'DAILY SHIFT','2022-05-18','2022-05-18 11:15:40','2022-05-19 11:15:40','543',0.00,0.00,'543','2022-05-18 11:58:12','543','2022-05-18 11:58:32',10,0),('1','144',257622,'DAILY SHIFT','2022-05-18','2022-05-18 12:12:43','2022-05-19 12:12:43','543',0.00,0.00,'543','2022-05-19 16:44:52','543','2022-05-19 16:45:13',10,0),('1','144',257623,'DAILY SHIFT','2022-05-23','2022-05-23 07:04:04','2022-05-24 07:04:04','543',0.00,0.00,'543','2022-05-23 07:05:54','543','2022-05-23 07:06:14',10,0),('1','144',257624,'DAILY SHIFT','2022-05-27','2022-05-27 06:43:37','2022-05-28 06:43:37','543',0.00,0.00,'543','2022-05-27 20:01:09','543','2022-05-27 20:01:29',10,0),('1','144',257625,'DAILY SHIFT','2022-05-28','2022-05-28 06:42:04','2022-05-29 06:42:04','543',0.00,0.00,'543','2022-05-28 21:33:32','543','2022-05-28 21:33:53',10,0),('1','144',257626,'DAILY SHIFT','2022-05-29','2022-05-29 06:20:12','2022-05-30 06:20:12','543',0.00,0.00,'543','2022-05-29 20:16:04','543','2022-05-29 20:16:25',10,0),('1','144',257627,'DAILY SHIFT','2022-05-30','2022-05-30 06:29:49','2022-05-31 06:29:49','543',0.00,0.00,'543','2022-05-30 19:48:07','543','2022-05-30 19:48:36',10,0),('1','144',257628,'DAILY SHIFT','2022-05-31','2022-05-31 06:40:11','2022-06-01 06:40:11','543',0.00,0.00,'543','2022-05-31 20:06:44','543','2022-05-31 20:07:10',10,0),('1','144',257629,'DAILY SHIFT','2022-05-31','2022-05-31 20:17:22','2022-06-01 20:17:22','543',0.00,0.00,'543','2022-05-31 20:23:28','543','2022-05-31 20:23:48',10,0),('1','144',257630,'DEALY SHIFT','2022-06-01','2022-06-01 06:33:48','2022-06-02 06:33:48','543',0.00,0.00,'543','2022-06-01 20:16:47','543','2022-06-01 20:17:09',10,0),('1','144',257631,'DAILY SHIFT','2022-06-02','2022-06-02 06:41:20','2022-06-03 06:41:20','543',0.00,0.00,'543','2022-06-02 19:45:56','543','2022-06-02 19:46:19',10,0),('1','144',257632,'DAILY SHIFT','2022-06-03','2022-06-03 06:26:45','2022-06-04 06:26:45','543',0.00,0.00,'543','2022-06-03 19:37:58','543','2022-06-03 19:38:22',10,0),('1','144',257633,'DAILY SHIFT','2022-06-04','2022-06-04 06:13:53','2022-06-05 06:13:53','543',0.00,0.00,'543','2022-06-04 20:01:57','543','2022-06-04 20:02:16',10,0),('1','144',257634,'DAILY SHIFT','2022-06-05','2022-06-05 06:45:30','2022-06-06 06:45:30','543',0.00,0.00,'543','2022-06-05 21:14:02','543','2022-06-05 21:14:25',10,0),('1','144',257635,'DAILY SHIFT','2022-06-06','2022-06-06 06:32:03','2022-06-07 06:32:03','543',0.00,0.00,'543','2022-06-06 20:19:27','543','2022-06-06 20:19:51',10,0),('1','144',257636,'DAILY SHIFT','2022-06-06','2022-06-06 20:34:06','2022-06-07 20:34:06','543',0.00,0.00,'543','2022-06-06 20:39:57','543','2022-06-06 20:40:16',10,0),('1','144',257637,'DAILY SHIFT','2022-06-07','2022-06-07 06:43:20','2022-06-08 06:43:20','543',0.00,0.00,'543','2022-06-07 19:37:14','543','2022-06-07 19:37:31',10,0),('1','144',257638,'DAILY SHIFT','2022-06-08','2022-06-08 06:24:34','2022-06-09 06:24:34','543',0.00,0.00,'543','2022-06-08 19:24:44','543','2022-06-08 19:26:26',10,0),('1','144',257639,'DAILY SHIFT','2022-06-09','2022-06-09 05:59:48','2022-06-10 05:59:48','543',0.00,0.00,'543','2022-06-09 19:53:10','543','2022-06-09 19:53:27',10,0),('1','144',257640,'DAILY SHIFT','2022-06-10','2022-06-10 06:36:25','2022-06-11 06:36:25','543',0.00,0.00,'543','2022-06-10 19:41:18','543','2022-06-10 19:41:38',10,0),('1','144',257641,'DAILY SHIFT','2022-06-11','2022-06-11 06:45:20','2022-06-12 06:45:20','543',0.00,0.00,'543','2022-06-11 19:57:43','543','2022-06-11 19:58:01',10,0),('1','144',257642,'DAILY SHIFT','2022-06-12','2022-06-12 06:50:16','2022-06-13 06:50:16','543',0.00,0.00,'543','2022-06-12 19:35:55','543','2022-06-12 19:36:17',10,0),('1','144',257643,'DAILY SHIFT','2022-06-13','2022-06-13 06:51:33','2022-06-14 06:51:33','543',0.00,0.00,'543','2022-06-13 20:08:26','543','2022-06-13 20:08:49',10,0),('1','144',257644,'DAILY SHIFT','2022-06-13','2022-06-13 20:16:10','2022-06-14 20:16:10','543',0.00,0.00,'543','2022-06-13 20:22:22','543','2022-06-13 20:22:40',10,0),('1','144',257645,'DAILY SHIFT','2022-06-14','2022-06-14 06:28:04','2022-06-15 06:28:04','543',0.00,0.00,'543','2022-06-14 20:04:46','543','2022-06-14 20:05:07',10,0),('1','144',257646,'DAILY SHIFT','2022-06-15','2022-06-15 06:43:46','2022-06-16 06:43:46','543',0.00,0.00,'543','2022-06-15 19:31:49','543','2022-06-15 19:32:09',10,0),('1','144',257647,'DAILY SHIFT','2022-06-16','2022-06-16 06:40:02','2022-06-17 06:40:02','543',0.00,0.00,'543','2022-06-16 20:00:04','543','2022-06-16 20:00:32',10,0),('1','144',257648,'DAILY SHIFT','2022-06-17','2022-06-17 07:06:34','2022-06-18 07:06:34','543',0.00,0.00,'543','2022-06-17 19:57:54','543','2022-06-17 19:58:13',10,0),('1','144',257649,'DAILY SHIFT','2022-06-18','2022-06-18 06:33:37','2022-06-19 06:33:37','543',0.00,0.00,'543','2022-06-18 19:31:10','543','2022-06-18 19:31:30',10,0),('1','144',257650,'DAILY SHIFT','2022-06-19','2022-06-19 06:37:33','2022-06-20 06:37:33','543',0.00,0.00,'543','2022-06-19 22:41:02','543','2022-06-19 22:41:25',10,0),('1','144',257651,'DAILY SHIFT','2022-06-20','2022-06-20 06:39:14','2022-06-21 06:39:14','543',0.00,0.00,'543','2022-06-20 20:04:48','543','2022-06-20 20:05:08',10,0),('1','144',257652,'DAILY SHIFT','2022-06-20','2022-06-20 20:09:15','2022-06-21 20:09:15','543',0.00,0.00,'543','2022-06-21 06:51:51','543','2022-06-21 06:53:08',10,0),('1','144',257653,'DAILY SHIFT','2022-06-21','2022-06-21 06:54:35','2022-06-22 06:54:35','543',0.00,0.00,'543','2022-06-21 20:07:07','543','2022-06-21 20:07:35',10,0),('1','144',257654,'DAILY SHIFT','2022-06-22','2022-06-22 06:37:53','2022-06-23 06:37:53','543',0.00,0.00,'543','2022-06-22 20:03:58','543','2022-06-22 20:04:18',10,0),('1','144',257655,'DAILY SHIFT','2022-06-23','2022-06-23 06:29:32','2022-06-24 06:29:32','543',0.00,0.00,'543','2022-06-23 19:56:45','543','2022-06-23 19:57:02',10,0),('1','144',257656,'DAILY SHIFT','2022-06-24','2022-06-24 06:38:00','2022-06-25 06:38:00','543',0.00,0.00,'543','2022-06-24 19:56:44','543','2022-06-24 19:57:03',10,0),('1','144',257657,'DAILY SHIFT','2022-06-25','2022-06-25 06:38:56','2022-06-26 06:38:56','543',0.00,0.00,'543','2022-06-25 19:36:37','543','2022-06-25 19:36:59',10,0),('1','144',257658,'DAILY SHIFT','2022-06-26','2022-06-26 06:36:10','2022-06-27 06:36:10','543',0.00,0.00,'543','2022-06-26 19:51:34','543','2022-06-26 19:51:58',10,0),('1','144',257659,'DAILY SHIFT','2022-06-26','2022-06-26 19:56:22','2022-06-27 19:56:22','543',0.00,0.00,'543','2022-06-26 20:10:19','543','2022-06-26 20:10:41',10,0),('1','144',257660,'DAILY SHIFT','2022-06-28','2022-06-28 06:13:48','2022-06-29 06:13:48','543',0.00,0.00,'543','2022-06-28 19:50:46','543','2022-06-28 19:51:09',10,0),('1','144',257661,'DAILY SHIFT','2022-06-29','2022-06-29 06:35:52','2022-06-30 06:35:52','543',0.00,0.00,'543','2022-06-29 20:00:35','543','2022-06-29 20:00:53',10,0),('1','144',257662,'DAILY SHIFT','2022-06-30','2022-06-30 06:47:41','2022-07-01 06:47:41','543',0.00,0.00,'543','2022-06-30 19:59:22','543','2022-06-30 19:59:42',10,0),('1','144',257663,'DAILY SHIFT','2022-07-01','2022-07-01 06:45:54','2022-07-02 06:45:54','543',0.00,0.00,'543','2022-07-01 19:58:43','543','2022-07-01 19:59:02',10,0),('1','144',257664,'DAILY SHIFT','2022-07-02','2022-07-02 06:53:01','2022-07-03 06:53:01','543',0.00,0.00,'543','2022-07-02 20:12:24','543','2022-07-02 20:12:43',10,0),('1','144',257665,'DAILY SHIFT','2022-07-03','2022-07-03 06:04:45','2022-07-04 06:04:45','543',0.00,0.00,'543','2022-07-03 21:27:40','543','2022-07-03 21:28:02',10,0),('1','144',257666,'DAILY SHIFT','2022-07-03','2022-07-03 21:32:30','2022-07-04 21:32:30','543',0.00,0.00,'543','2022-07-03 21:37:17','543','2022-07-03 21:37:38',10,0),('1','144',257667,'DAILY SHIFT','2022-07-04','2022-07-04 06:30:13','2022-07-05 06:30:13','543',0.00,0.00,'543','2022-07-04 06:35:47','543','2022-07-04 06:36:17',10,0),('1','144',257668,'DAILY SHIFT','2022-07-04','2022-07-04 06:54:43','2022-07-05 06:54:43','543',0.00,0.00,'543','2022-07-04 20:01:21','543','2022-07-04 20:01:42',10,0),('1','144',257669,'DAILY SHIFT','2022-07-05','2022-07-05 06:27:47','2022-07-06 06:27:47','543',0.00,0.00,'543','2022-07-05 20:22:37','543','2022-07-05 20:22:59',10,0),('1','144',257670,'DAILY SHIFT','2022-07-06','2022-07-06 07:25:20','2022-07-07 07:25:20','543',0.00,0.00,'543','2022-07-06 19:59:05','543','2022-07-06 20:00:47',10,0),('1','144',257671,'DAILY SHIFT','2022-07-07','2022-07-07 06:34:47','2022-07-08 06:34:47','543',0.00,0.00,'543','2022-07-07 19:42:43','543','2022-07-07 19:43:01',10,0),('1','144',257672,'DAILY SHIFT','2022-07-08','2022-07-08 06:34:41','2022-07-09 06:34:41','543',0.00,0.00,'543','2022-07-08 19:33:05','543','2022-07-08 19:33:30',10,0),('1','144',257673,'DAILY SHIFT','2022-07-09','2022-07-09 06:44:39','2022-07-10 06:44:39','543',0.00,0.00,'543','2022-07-09 18:02:03','543','2022-07-09 18:02:19',10,0),('1','144',257674,'DAILY SHIFT','2022-07-10','2022-07-10 06:47:21','2022-07-11 06:47:21','543',0.00,0.00,'543','2022-07-10 19:52:25','543','2022-07-10 19:52:47',10,0),('1','144',257675,'DAILY SHIFT','2022-07-10','2022-07-10 19:57:50','2022-07-11 19:57:50','543',0.00,0.00,'543','2022-07-10 20:32:56','543','2022-07-10 20:33:21',10,0),('1','144',257676,'DAILY SHIFT','2022-07-11','2022-07-11 06:35:17','2022-07-12 06:35:17','543',0.00,0.00,'543','2022-07-11 19:58:45','543','2022-07-11 19:59:10',10,0),('1','144',257677,'DAILY SHIFT','2022-07-12','2022-07-12 06:43:43','2022-07-13 06:43:43','543',0.00,0.00,'543','2022-07-12 19:44:38','543','2022-07-12 19:45:02',10,0),('1','144',257678,'DAILY SHIFT','2022-07-13','2022-07-13 06:45:26','2022-07-14 06:45:26','543',0.00,0.00,'543','2022-07-13 19:31:27','543','2022-07-13 19:31:46',10,0),('1','144',257679,'DAILY SHIFT','2022-07-14','2022-07-14 06:46:22','2022-07-15 06:46:22','543',0.00,0.00,'543','2022-07-14 19:12:43','543','2022-07-14 19:13:02',10,0),('1','144',257680,'DAILY SHIFT','2022-07-15','2022-07-15 07:00:04','2022-07-16 07:00:04','543',0.00,0.00,'543','2022-07-15 19:30:36','543','2022-07-15 19:30:55',10,0),('1','144',257681,'DAILY SHIFT','2022-07-16','2022-07-16 06:52:15','2022-07-17 06:52:15','543',0.00,0.00,'543','2022-07-16 20:30:30','543','2022-07-16 20:30:48',10,0),('1','144',257682,'DAILY SHIFT','2022-07-17','2022-07-17 06:56:45','2022-07-18 06:56:45','543',0.00,0.00,'543','2022-07-17 19:47:25','543','2022-07-17 19:47:45',10,0),('1','144',257683,'DAILY SHIFT','2022-07-17','2022-07-17 19:50:32','2022-07-18 19:50:32','543',0.00,0.00,'543','2022-07-18 06:18:56','543','2022-07-18 06:19:15',10,0),('1','144',257684,'DAILY SHIFT','2022-07-18','2022-07-18 06:19:38','2022-07-19 06:19:38','543',0.00,0.00,'543','2022-07-18 17:57:52','543','2022-07-18 17:58:14',10,0),('1','144',257685,'DAILY SHIFT','2022-07-19','2022-07-19 06:24:40','2022-07-20 06:24:40','543',0.00,0.00,'543','2022-07-19 19:54:30','543','2022-07-19 19:54:55',10,0),('1','144',257686,'DAILY SHIFT','2022-07-20','2022-07-20 07:03:13','2022-07-21 07:03:13','543',0.00,0.00,'543','2022-07-20 23:13:09','543','2022-07-20 23:13:37',10,0),('1','144',257687,'DAILY SHIFT','2022-07-21','2022-07-21 06:45:10','2022-07-22 06:45:10','543',0.00,0.00,'543','2022-07-21 20:44:28','543','2022-07-21 20:44:54',10,0),('1','144',257688,'DAILY SHIFT','2022-07-22','2022-07-22 06:47:54','2022-07-23 06:47:54','543',0.00,0.00,'543','2022-07-22 23:00:08','543','2022-07-22 23:00:42',10,0),('1','144',257689,'DAILY SHIFT','2022-07-23','2022-07-23 06:42:59','2022-07-24 06:42:59','543',0.00,0.00,'543','2022-07-23 14:55:23','543','2022-07-23 14:55:56',10,0),('1','144',257690,'DAILY SHIFT','2022-07-23','2022-07-23 14:59:21','2022-07-24 14:59:21','543',0.00,0.00,'543','2022-07-23 15:17:47','543','2022-07-23 15:18:16',10,0),('1','144',257691,'DAILY SHIFT','2022-07-23','2022-07-23 15:18:46','2022-07-24 15:18:46','543',0.00,0.00,'543','2022-07-23 23:15:21','543','2022-07-23 23:17:21',10,0),('1','144',257692,'DEALY SHIFT','2022-07-24','2022-07-24 06:42:48','2022-07-25 06:42:48','543',0.00,0.00,'543','2022-07-24 23:56:28','543','2022-07-24 23:57:19',10,0),('1','144',257693,'DAILY SHIFT','2022-07-25','2022-07-25 06:39:04','2022-07-26 06:39:04','543',0.00,0.00,'543','2022-07-25 22:49:20','543','2022-07-25 22:50:02',10,0),('1','144',257694,'DAILY SHIFT','2022-07-26','2022-07-26 06:44:00','2022-07-27 06:44:00','543',0.00,0.00,'543','2022-07-26 23:01:12','543','2022-07-27 06:57:24',10,0),('1','144',257695,'DAILY SHIFT','2022-07-27','2022-07-27 06:57:44','2022-07-28 06:57:44','543',0.00,0.00,'543','2022-07-27 19:58:39','543','2022-07-27 20:01:24',10,0),('1','144',257696,'DAILY SHIFT','2022-07-28','2022-07-28 06:53:12','2022-07-29 06:53:12','543',0.00,0.00,'543','2022-07-28 20:35:30','543','2022-07-28 20:36:04',10,0),('1','144',257697,'DAILY SALES','2022-07-29','2022-07-29 07:01:08','2022-07-30 07:01:08','543',0.00,0.00,'916','2022-07-29 19:38:30','916','2022-07-29 19:38:59',10,0),('1','144',257698,'DAILY SALES','2022-07-30','2022-07-30 06:35:43','2022-07-31 06:35:43','916',0.00,0.00,'916','2022-07-30 19:05:36','916','2022-07-30 19:07:26',10,0),('1','144',257699,'DAILY SALES','2022-07-31','2022-07-31 06:36:10','2022-08-01 06:36:10','916',0.00,0.00,'916','2022-07-31 13:39:07','916','2022-07-31 13:39:43',10,0),('1','144',257700,'BULK SALES','2022-07-31','2022-07-31 13:41:48','2022-08-01 13:41:48','916',0.00,0.00,'916','2022-07-31 18:02:15','916','2022-07-31 18:02:42',10,0),('1','144',257701,'DAILY SALES','2022-08-02','2022-08-02 14:53:18','2022-08-03 14:53:18','916',0.00,0.00,'916','2022-08-02 20:10:14','916','2022-08-02 20:10:46',10,0),('1','144',257702,'DAILY SALES','2022-08-03','2022-08-03 06:37:31','2022-08-04 06:37:31','916',0.00,0.00,'916','2022-08-03 19:59:00','916','2022-08-03 19:59:36',10,0),('1','144',257703,'DAILY SALES','2022-08-04','2022-08-04 06:48:49','2022-08-05 06:48:49','916',0.00,0.00,'916','2022-08-04 19:21:45','916','2022-08-04 19:22:18',10,0),('1','144',257704,'DAILY SALES','2022-08-05','2022-08-05 06:46:23','2022-08-06 06:46:23','916',0.00,0.00,'916','2022-08-05 20:55:50','916','2022-08-05 20:56:32',10,0),('1','144',257705,'DAILY SALES','2022-08-06','2022-08-06 06:58:20','2022-08-07 06:58:20','916',0.00,0.00,'916','2022-08-06 18:51:09','916','2022-08-06 18:51:47',10,0),('1','144',257706,'DAILY SALES','2022-08-07','2022-08-07 06:40:27','2022-08-08 06:40:27','916',0.00,0.00,'916','2022-08-08 06:34:55','916','2022-08-08 06:35:25',10,0),('1','144',257707,'DAILY SALES','2022-08-08','2022-08-08 06:36:04','2022-08-09 06:36:04','916',0.00,0.00,'916','2022-08-08 09:28:45','916','2022-08-08 09:29:09',10,0),('1','144',257708,'BULK SALES','2022-08-08','2022-08-08 09:29:54','2022-08-09 09:29:54','916',0.00,0.00,'916','2022-08-08 09:35:04','916','2022-08-08 09:35:30',10,0),('1','144',257709,'DAILY SALES','2022-08-08','2022-08-08 09:36:18','2022-08-09 09:36:18','916',0.00,0.00,'916','2022-08-08 19:23:49','916','2022-08-08 19:24:31',10,0),('1','144',257710,'DAILY SALES','2022-08-09','2022-08-09 06:36:00','2022-08-10 06:36:00','916',0.00,0.00,'916','2022-08-09 18:36:49','916','2022-08-09 18:37:28',10,0),('1','144',257711,'DAILY SALES','2022-08-10','2022-08-10 06:45:08','2022-08-11 06:45:08','916',0.00,0.00,'916','2022-08-10 19:00:40','916','2022-08-10 19:01:29',10,0),('1','144',257712,'DAILY SALES','2022-08-11','2022-08-11 06:26:44','2022-08-12 06:26:44','916',0.00,0.00,'916','2022-08-11 19:19:11','916','2022-08-11 19:19:40',10,0),('1','144',257713,'DAILY SALES','2022-08-12','2022-08-12 06:33:18','2022-08-13 06:33:18','916',0.00,0.00,'916','2022-08-12 19:09:30','916','2022-08-12 19:10:05',10,0),('1','144',257714,'DAILY SALES','2022-08-13','2022-08-13 06:24:45','2022-08-14 06:24:45','916',0.00,0.00,'916','2022-08-13 19:03:56','916','2022-08-13 19:04:18',10,0),('1','144',257715,'DAILY SALES','2022-08-14','2022-08-14 06:34:41','2022-08-15 06:34:41','916',0.00,0.00,'916','2022-08-14 18:48:37','916','2022-08-14 18:49:02',10,0),('1','144',257716,'DAILY SALES','2022-08-15','2022-08-15 06:55:00','2022-08-16 06:55:00','916',0.00,0.00,'916','2022-08-15 12:54:44','916','2022-08-15 12:55:10',10,0),('1','144',257717,'BULK SALES','2022-08-15','2022-08-15 12:56:04','2022-08-16 12:56:04','916',0.00,0.00,'916','2022-08-15 18:36:20','916','2022-08-15 18:36:47',10,0),('1','144',257718,'DAILY SALES','2022-08-16','2022-08-16 06:18:32','2022-08-17 06:18:32','916',0.00,0.00,'916','2022-08-16 18:20:30','916','2022-08-16 18:20:57',10,0),('1','144',257719,'DAILY SALES','2022-08-17','2022-08-17 05:51:13','2022-08-18 05:51:13','916',0.00,0.00,'916','2022-08-17 18:35:56','916','2022-08-17 18:37:21',10,0),('1','144',257720,'DAILY SALES','2022-08-18','2022-08-18 06:46:34','2022-08-19 06:46:34','916',0.00,0.00,'916','2022-08-18 21:13:23','916','2022-08-18 21:13:58',10,0),('1','144',257721,'DAILY SALES','2022-08-19','2022-08-19 06:42:47','2022-08-20 06:42:47','916',0.00,0.00,'916','2022-08-19 18:54:12','916','2022-08-19 18:54:47',10,0),('1','144',257722,'DAILY SALES','2022-08-20','2022-08-20 06:29:31','2022-08-21 06:29:31','916',0.00,0.00,'916','2022-08-20 18:41:38','916','2022-08-20 18:42:16',10,0),('1','144',257723,'DAILY SALES','2022-08-21','2022-08-21 06:40:45','2022-08-22 06:40:45','916',0.00,0.00,'916','2022-08-21 18:24:05','916','2022-08-21 18:24:45',10,0),('1','144',257724,'DAILY SALES','2022-08-22','2022-08-22 06:25:21','2022-08-23 06:25:21','916',0.00,0.00,'916','2022-08-22 19:02:37','916','2022-08-22 19:03:03',10,0),('1','144',257725,'DAILY SALES','2022-08-23','2022-08-23 06:28:19','2022-08-24 06:28:19','916',0.00,0.00,'916','2022-08-23 18:42:14','916','2022-08-23 18:42:37',10,0),('1','144',257726,'DAILY SALES','2022-08-24','2022-08-24 06:29:14','2022-08-25 06:29:14','916',0.00,0.00,'916','2022-08-24 10:40:19','916','2022-08-24 10:40:44',10,0),('1','144',257727,'BULK SALES','2022-08-24','2022-08-24 10:41:38','2022-08-25 10:41:38','916',0.00,0.00,'916','2022-08-24 10:46:06','916','2022-08-24 10:46:33',10,0),('1','144',257728,'DAILY SALES','2022-08-24','2022-08-24 10:51:55','2022-08-25 10:51:55','916',0.00,0.00,'916','2022-08-24 18:31:15','916','2022-08-24 18:31:47',10,0),('1','144',257729,'DAILY SALES','2022-08-25','2022-08-25 06:34:51','2022-08-26 06:34:51','916',0.00,0.00,'916','2022-08-25 18:22:49','916','2022-08-25 18:23:17',10,0),('1','144',257730,'DAILY SALES','2022-08-26','2022-08-26 06:42:20','2022-08-27 06:42:20','916',0.00,0.00,'916','2022-08-26 19:11:30','916','2022-08-26 19:12:36',10,0),('1','144',257731,'DAILY SALES','2022-08-27','2022-08-27 06:21:45','2022-08-28 06:21:45','916',0.00,0.00,'916','2022-08-27 18:37:09','916','2022-08-27 18:37:33',10,0),('1','144',257732,'DAILY SALES','2022-08-28','2022-08-28 06:29:49','2022-08-29 06:29:49','916',0.00,0.00,'916','2022-08-28 18:21:45','916','2022-08-28 18:22:26',10,0),('1','144',257733,'DAILY SALES','2022-08-29','2022-08-29 06:21:11','2022-08-30 06:21:11','916',0.00,0.00,'916','2022-08-29 18:44:31','916','2022-08-29 18:45:10',10,0),('1','144',257734,'DAILY SALES','2022-08-30','2022-08-30 06:14:26','2022-08-31 06:14:26','916',0.00,0.00,'916','2022-08-30 21:45:53','916','2022-08-30 21:46:18',10,0),('1','144',257735,'DAILY SALES','2022-08-31','2022-08-31 06:24:37','2022-09-01 06:24:37','916',0.00,0.00,'916','2022-08-31 18:53:35','916','2022-08-31 18:54:16',10,0),('1','144',257736,'DAILY SALES','2022-09-01','2022-09-01 06:39:54','2022-09-02 06:39:54','916',0.00,0.00,'916','2022-09-01 12:24:33','916','2022-09-01 12:24:58',10,0),('1','144',257737,'BULK SALES','2022-09-01','2022-09-01 12:25:46','2022-09-02 12:25:46','916',0.00,0.00,'916','2022-09-01 12:30:25','916','2022-09-01 12:30:48',10,0),('1','144',257738,'DAILY SALES','2022-09-01','2022-09-01 12:35:48','2022-09-02 12:35:48','916',0.00,0.00,'916','2022-09-01 18:51:47','916','2022-09-01 18:52:19',10,0),('1','144',257739,'DAILY SALES','2022-09-02','2022-09-02 05:32:56','2022-09-03 05:32:56','916',0.00,0.00,'916','2022-09-02 18:57:07','916','2022-09-02 18:57:36',10,0),('1','144',257740,'DAILY SALES','2022-09-03','2022-09-03 05:48:27','2022-09-04 05:48:27','916',0.00,0.00,'916','2022-09-03 19:01:29','916','2022-09-03 19:02:01',10,0),('1','144',257741,'DAILY SALES','2022-09-04','2022-09-04 04:10:55','2022-09-05 04:10:55','916',0.00,0.00,'916','2022-09-04 20:03:58','916','2022-09-04 20:20:14',10,0),('1','144',257742,'DAILY SALES','2022-09-05','2022-09-05 06:39:11','2022-09-06 06:39:11','916',0.00,0.00,'916','2022-09-05 21:00:07','916','2022-09-05 21:00:33',10,0),('1','144',257743,'DAILY SALES','2022-09-06','2022-09-06 06:36:41','2022-09-07 06:36:41','916',0.00,0.00,'916','2022-09-06 19:22:03','916','2022-09-06 19:22:29',10,0),('1','144',257744,'DAILY SALES','2022-09-07','2022-09-07 06:29:58','2022-09-08 06:29:58','916',0.00,0.00,'916','2022-09-07 18:29:53','916','2022-09-07 18:30:19',10,0),('1','144',257745,'DAILY SALES','2022-09-08','2022-09-08 06:38:01','2022-09-09 06:38:01','916',0.00,0.00,'916','2022-09-08 18:55:46','916','2022-09-08 18:56:29',10,0),('1','144',257746,'DAILY SALES','2022-09-09','2022-09-09 06:27:24','2022-09-10 06:27:24','916',0.00,0.00,'916','2022-09-09 12:40:54','916','2022-09-09 12:41:20',10,0),('1','144',257747,'BULK SALES','2022-09-09','2022-09-09 12:41:49','2022-09-10 12:41:49','916',0.00,0.00,'916','2022-09-09 12:46:46','916','2022-09-09 12:47:07',10,0),('1','144',257748,'DAILY SALES','2022-09-09','2022-09-09 12:56:06','2022-09-10 12:56:06','916',0.00,0.00,'916','2022-09-09 18:28:00','916','2022-09-09 18:28:28',10,0),('1','144',257749,'DAILY SALES','2022-09-10','2022-09-10 06:56:49','2022-09-11 06:56:49','916',0.00,0.00,'916','2022-09-10 18:41:46','916','2022-09-10 18:42:17',10,0),('1','144',257750,'DAILY SALES','2022-09-11','2022-09-11 06:44:54','2022-09-12 06:44:54','916',0.00,0.00,'916','2022-09-11 18:40:16','916','2022-09-11 18:40:43',10,0),('1','144',257751,'DAILY SALE','2022-09-12','2022-09-12 06:41:06','2022-09-13 06:41:06','916',0.00,0.00,'916','2022-09-12 19:05:24','916','2022-09-12 19:05:59',10,0),('1','144',257752,'DAILY SALE','2022-09-13','2022-09-13 06:38:21','2022-09-14 06:38:21','916',0.00,0.00,'916','2022-09-13 18:21:50','916','2022-09-13 18:22:26',10,0),('1','144',257753,'DAILY SALE','2022-09-14','2022-09-14 06:32:02','2022-09-15 06:32:02','916',0.00,0.00,'916','2022-09-14 18:36:05','916','2022-09-14 18:36:58',10,0),('1','144',257754,'DAILY SALE','2022-09-15','2022-09-15 06:31:51','2022-09-16 06:31:51','916',0.00,0.00,'916','2022-09-15 18:27:03','916','2022-09-15 18:27:47',10,0),('1','144',257755,'DAILY SALES','2022-09-16','2022-09-16 06:34:27','2022-09-17 06:34:27','916',0.00,0.00,'916','2022-09-16 18:54:05','916','2022-09-16 18:55:07',10,0),('1','144',257756,'DAILY SALE','2022-09-17','2022-09-17 06:41:00','2022-09-18 06:41:00','916',0.00,0.00,'916','2022-09-17 12:35:36','916','2022-09-17 12:37:05',10,0),('1','144',257757,'BULK SALES','2022-09-17','2022-09-17 12:38:37','2022-09-18 12:38:37','916',0.00,0.00,'916','2022-09-17 12:43:14','916','2022-09-17 12:43:39',10,0),('1','144',257758,'DAILY SALE','2022-09-17','2022-09-17 12:56:22','2022-09-18 12:56:22','916',0.00,0.00,'916','2022-09-17 18:44:07','916','2022-09-17 18:45:00',10,0),('1','144',257759,'DAILY SALES','2022-09-18','2022-09-18 05:52:50','2022-09-19 05:52:50','916',0.00,0.00,'916','2022-09-18 18:11:17','916','2022-09-18 18:11:41',10,0),('1','144',257760,'DAILY SALES','2022-09-19','2022-09-19 07:06:21','2022-09-20 07:06:21','916',0.00,0.00,'916','2022-09-19 18:55:23','916','2022-09-19 18:55:53',10,0),('1','144',257761,'DAILY SALES','2022-09-20','2022-09-20 06:27:13','2022-09-21 06:27:13','916',0.00,0.00,'916','2022-09-20 19:30:49','916','2022-09-20 19:31:43',10,0),('1','144',257762,'DAILY SALES','2022-09-21','2022-09-21 06:16:05','2022-09-22 06:16:05','916',0.00,0.00,'916','2022-09-21 19:01:39','916','2022-09-21 19:02:07',10,0),('1','144',257763,'DAILY SALE','2022-09-22','2022-09-22 06:17:31','2022-09-23 06:17:31','916',0.00,0.00,'916','2022-09-22 18:40:34','916','2022-09-22 18:40:56',10,0),('1','144',257764,'DAILY SALES','2022-09-23','2022-09-23 06:24:21','2022-09-24 06:24:21','916',0.00,0.00,'916','2022-09-23 18:42:53','916','2022-09-23 18:43:55',10,0),('1','144',257765,'DAILY SALES','2022-09-24','2022-09-24 06:23:45','2022-09-25 06:23:45','916',0.00,0.00,'916','2022-09-24 15:09:10','916','2022-09-24 15:09:33',10,0),('1','144',257766,'BULK SALES','2022-09-24','2022-09-24 15:10:10','2022-09-25 15:10:10','916',0.00,0.00,'916','2022-09-24 15:16:35','916','2022-09-24 15:16:54',10,0),('1','144',257767,'DAILY SALE','2022-09-24','2022-09-24 15:17:16','2022-09-25 15:17:16','916',0.00,0.00,'916','2022-09-24 18:43:16','916','2022-09-24 18:44:47',10,0),('1','144',257768,'DAILY SALES','2022-09-25','2022-09-25 06:43:49','2022-09-26 06:43:49','916',0.00,0.00,'916','2022-09-25 18:46:21','916','2022-09-25 18:47:27',10,0),('1','144',257769,'DAILY SALES','2022-09-26','2022-09-26 06:26:48','2022-09-27 06:26:48','916',0.00,0.00,'916','2022-09-26 18:54:19','916','2022-09-26 18:58:39',10,0),('1','144',257770,'DAILY SALE','2022-09-27','2022-09-27 06:30:36','2022-09-28 06:30:36','916',0.00,0.00,'916','2022-09-27 18:53:21','916','2022-09-27 18:54:03',10,0),('1','144',257771,'DAILY SALES','2022-09-28','2022-09-28 06:29:50','2022-09-29 06:29:50','916',0.00,0.00,'916','2022-09-28 18:31:28','916','2022-09-28 18:32:13',10,0),('1','144',257772,'DAILY SALES','2022-09-29','2022-09-29 06:41:12','2022-09-30 06:41:12','916',0.00,0.00,'916','2022-09-29 19:06:47','916','2022-09-29 19:07:14',10,0),('1','144',257773,'DAILY SALE','2022-09-30','2022-09-30 06:23:18','2022-10-01 06:23:18','916',0.00,0.00,'916','2022-10-01 06:39:20','916','2022-10-01 06:40:12',10,0),('1','144',257774,'DAILY SALES','2022-10-01','2022-10-01 06:40:40','2022-10-02 06:40:40','916',0.00,0.00,'916','2022-10-01 10:08:30','916','2022-10-01 10:08:54',10,0),('1','144',257775,'BULK SALES','2022-10-01','2022-10-01 10:09:22','2022-10-02 10:09:22','916',0.00,0.00,'916','2022-10-01 10:13:57','916','2022-10-01 10:14:14',10,0),('1','144',257776,'DAILY SALE','2022-10-01','2022-10-01 10:20:21','2022-10-02 10:20:21','916',0.00,0.00,'916','2022-10-01 18:30:01','916','2022-10-01 18:30:48',10,0),('1','144',257777,'DAILY SALE','2022-10-02','2022-10-02 06:36:17','2022-10-03 06:36:17','916',0.00,0.00,'916','2022-10-02 18:40:54','916','2022-10-02 18:41:26',10,0),('1','144',257778,'DAILY SALES','2022-10-03','2022-10-03 06:16:43','2022-10-04 06:16:43','916',0.00,0.00,'916','2022-10-03 18:42:50','916','2022-10-03 18:43:23',10,0),('1','144',257779,'DAILY SALES','2022-10-04','2022-10-04 06:34:47','2022-10-05 06:34:47','916',0.00,0.00,'916','2022-10-04 18:40:06','916','2022-10-04 18:40:45',10,0),('1','144',257780,'DAILY SALES','2022-10-05','2022-10-05 06:36:34','2022-10-06 06:36:34','916',0.00,0.00,'916','2022-10-05 18:26:13','916','2022-10-05 18:26:37',10,0),('1','144',257781,'DAILY SALES','2022-10-06','2022-10-06 04:18:35','2022-10-07 04:18:35','916',0.00,0.00,'916','2022-10-06 18:50:27','916','2022-10-06 18:51:04',10,0),('1','144',257782,'DAILY SALES','2022-10-07','2022-10-07 06:42:03','2022-10-08 06:42:03','916',0.00,0.00,'916','2022-10-07 18:26:32','916','2022-10-07 18:27:00',10,0),('1','144',257783,'DAILY SALES','2022-10-08','2022-10-08 06:42:36','2022-10-09 06:42:36','916',0.00,0.00,'916','2022-10-08 18:43:33','916','2022-10-08 18:45:23',10,0),('1','144',257784,'DAILY SALES','2022-10-09','2022-10-09 06:37:24','2022-10-10 06:37:24','916',0.00,0.00,'916','2022-10-09 15:02:02','916','2022-10-09 15:02:23',10,0),('1','144',257785,'BULK SALES','2022-10-09','2022-10-09 15:02:52','2022-10-10 15:02:52','916',0.00,0.00,'916','2022-10-09 15:08:39','916','2022-10-09 15:08:59',10,0),('1','144',257786,'DAILY SALE','2022-10-09','2022-10-09 15:13:46','2022-10-10 15:13:46','916',0.00,0.00,'916','2022-10-09 22:04:06','916','2022-10-09 22:04:30',10,0),('1','144',257787,'DAILY SALES','2022-10-10','2022-10-10 06:27:11','2022-10-11 06:27:11','916',0.00,0.00,'916','2022-10-10 18:25:26','916','2022-10-10 18:28:18',10,0),('1','144',257788,'DAILY SALES','2022-10-11','2022-10-11 06:46:04','2022-10-12 06:46:04','916',0.00,0.00,'916','2022-10-11 18:29:03','916','2022-10-11 18:29:53',10,0),('1','144',257789,'DAILY SALES','2022-10-12','2022-10-12 06:35:04','2022-10-13 06:35:04','916',0.00,0.00,'916','2022-10-12 18:45:08','916','2022-10-12 18:45:44',10,0),('1','144',257790,'DAILY SALES','2022-10-13','2022-10-13 06:15:48','2022-10-14 06:15:48','916',0.00,0.00,'916','2022-10-13 18:25:07','916','2022-10-13 18:26:34',10,0),('1','144',257791,'DAILY SALES','2022-10-14','2022-10-14 06:30:17','2022-10-15 06:30:17','916',0.00,0.00,'916','2022-10-14 18:13:06','916','2022-10-14 18:13:35',10,0),('1','144',257792,'DAILY SALES','2022-10-15','2022-10-15 06:26:40','2022-10-16 06:26:40','916',0.00,0.00,'916','2022-10-15 18:17:02','916','2022-10-15 18:17:25',10,0),('1','144',257793,'DAILY SALES','2022-10-16','2022-10-16 06:36:35','2022-10-17 06:36:35','916',0.00,0.00,'916','2022-10-16 18:32:51','916','2022-10-16 18:33:40',10,0),('1','144',257794,'DAILY SALES','2022-10-17','2022-10-17 06:12:16','2022-10-18 06:12:16','916',0.00,0.00,'916','2022-10-17 18:21:15','916','2022-10-17 18:21:56',10,0),('1','144',257795,'DAILY SALES','2022-10-18','2022-10-18 06:23:56','2022-10-19 06:23:56','916',0.00,0.00,'916','2022-10-18 18:06:56','916','2022-10-18 18:07:21',10,0),('1','144',257796,'BULK SALES','2022-10-18','2022-10-18 22:54:40','2022-10-19 22:54:40','916',0.00,0.00,'916','2022-10-18 23:16:52','916','2022-10-18 23:17:24',10,0),('1','144',257797,'DAILY SALES','2022-10-22','2022-10-22 06:13:25','2022-10-23 06:13:25','916',0.00,0.00,'916','2022-10-22 18:27:07','916','2022-10-22 18:27:49',10,0),('1','144',257798,'DAILY SALES','2022-10-23','2022-10-23 06:30:51','2022-10-24 06:30:51','916',0.00,0.00,'916','2022-10-23 18:24:58','916','2022-10-23 18:25:26',10,0),('1','144',257799,'DAILY SALES','2022-10-24','2022-10-24 06:23:49','2022-10-25 06:23:49','916',0.00,0.00,'916','2022-10-24 18:16:58','916','2022-10-24 18:17:27',10,0),('1','144',257800,'DAILY SALE','2022-10-25','2022-10-25 06:08:52','2022-10-26 06:08:52','916',0.00,0.00,'916','2022-10-25 18:19:44','916','2022-10-25 18:20:11',10,0),('1','144',257801,'DAILY SALES','2022-10-26','2022-10-26 06:15:39','2022-10-27 06:15:39','916',0.00,0.00,'916','2022-10-26 18:25:20','916','2022-10-26 18:25:42',10,0),('1','144',257802,'DAILY SALE','2022-10-27','2022-10-27 06:45:50','2022-10-28 06:45:50','916',0.00,0.00,'916','2022-10-27 18:26:29','916','2022-10-27 18:27:00',10,0),('1','144',257803,'DAILY SALES','2022-10-28','2022-10-28 06:31:03','2022-10-29 06:31:03','916',0.00,0.00,'916','2022-10-28 18:08:31','916','2022-10-28 18:08:54',10,0),('1','144',257804,'DAILY SALES','2022-10-29','2022-10-29 06:19:44','2022-10-30 06:19:44','916',0.00,0.00,'916','2022-10-29 18:30:59','916','2022-10-29 18:31:21',10,0),('1','144',257805,'DAILY SALES','2022-10-30','2022-10-30 06:36:36','2022-10-31 06:36:36','916',0.00,0.00,'916','2022-10-30 15:18:14','916','2022-10-30 15:18:49',10,0),('1','144',257806,'OVERAGATE','2022-10-30','2022-10-30 15:20:42','2022-10-31 15:20:42','916',0.00,0.00,'916','2022-10-30 16:27:39','916','2022-10-30 16:28:15',10,0),('1','144',257807,'DAILY SALES','2022-10-30','2022-10-30 16:52:09','2022-10-31 16:52:09','916',0.00,0.00,'916','2022-10-30 18:51:26','916','2022-10-30 18:52:08',10,0),('1','144',257808,'DAILY SALES','2022-10-31','2022-10-31 06:06:30','2022-11-01 06:06:30','916',0.00,0.00,'916','2022-10-31 18:42:45','916','2022-10-31 18:43:13',10,0),('1','144',257809,'DAILY SALES','2022-11-01','2022-11-01 06:28:58','2022-11-02 06:28:58','916',0.00,0.00,'916','2022-11-01 18:15:03','916','2022-11-01 18:15:26',10,0),('1','144',257810,'DAILY SALES','2022-11-02','2022-11-02 06:28:44','2022-11-03 06:28:44','916',0.00,0.00,'916','2022-11-02 18:36:38','916','2022-11-02 18:37:12',10,0),('1','144',257811,'DAILY SALES','2022-11-03','2022-11-03 06:28:18','2022-11-04 06:28:18','916',0.00,0.00,'916','2022-11-03 18:21:28','916','2022-11-03 18:21:54',10,0),('1','144',257812,'DAILY SALES','2022-11-04','2022-11-04 06:37:09','2022-11-05 06:37:09','916',0.00,0.00,'916','2022-11-04 19:09:48','916','2022-11-04 19:10:15',10,0),('1','144',257813,'DAILY SALE','2022-11-05','2022-11-05 08:15:31','2022-11-06 08:15:31','916',0.00,0.00,'916','2022-11-05 18:31:17','916','2022-11-05 18:32:08',10,0),('1','144',257814,'DAILY SALES','2022-11-06','2022-11-06 08:04:11','2022-11-07 08:04:11','916',0.00,0.00,'916','2022-11-06 13:29:07','916','2022-11-06 13:29:30',10,0),('1','144',257815,'BULK SALES','2022-11-06','2022-11-06 13:31:59','2022-11-07 13:31:59','916',0.00,0.00,'916','2022-11-06 13:37:43','916','2022-11-06 13:38:06',10,0),('1','144',257816,'DAILY SALES','2022-11-06','2022-11-06 13:49:28','2022-11-07 13:49:28','916',0.00,0.00,'916','2022-11-06 18:39:01','916','2022-11-06 18:39:31',10,0),('1','144',257817,'DAILY SALES','2022-11-07','2022-11-07 06:29:20','2022-11-08 06:29:20','916',0.00,0.00,'916','2022-11-07 18:26:42','916','2022-11-07 18:27:06',10,0),('1','144',257818,'DAILY SALES','2022-11-08','2022-11-08 06:13:35','2022-11-09 06:13:35','916',0.00,0.00,'916','2022-11-09 06:32:40','916','2022-11-09 06:33:21',10,0),('1','144',257819,'DAILY SALES','2022-11-09','2022-11-09 06:34:32','2022-11-10 06:34:32','916',0.00,0.00,'916','2022-11-09 18:10:55','916','2022-11-09 18:11:29',10,0),('1','144',257820,'DAILY SALES','2022-11-10','2022-11-10 06:44:02','2022-11-11 06:44:02','916',0.00,0.00,'916','2022-11-10 18:09:26','916','2022-11-10 18:09:55',10,0),('1','144',257821,'DAILY SALES','2022-11-11','2022-11-11 06:34:01','2022-11-12 06:34:01','916',0.00,0.00,'916','2022-11-11 18:06:56','916','2022-11-11 18:07:32',10,0),('1','144',257822,'DAILY SALES','2022-11-12','2022-11-12 06:28:44','2022-11-13 06:28:44','916',0.00,0.00,'916','2022-11-12 18:30:08','916','2022-11-12 18:30:40',10,0),('1','144',257823,'DAILY SALES','2022-11-13','2022-11-13 06:28:13','2022-11-14 06:28:13','916',0.00,0.00,'916','2022-11-13 18:18:01','916','2022-11-13 18:18:34',10,0),('1','144',257824,'DAILY SALES','2022-11-14','2022-11-14 06:28:39','2022-11-15 06:28:39','916',0.00,0.00,'916','2022-11-14 17:39:21','916','2022-11-14 17:41:54',10,0),('1','144',257825,'BULK SALES','2022-11-14','2022-11-14 17:49:41','2022-11-15 17:49:41','916',0.00,0.00,'916','2022-11-14 17:54:10','916','2022-11-14 17:54:35',10,0),('1','144',257826,'DAILY SALES','2022-11-15','2022-11-15 06:29:33','2022-11-16 06:29:33','916',0.00,0.00,'916','2022-11-15 18:34:15','916','2022-11-15 18:35:52',10,0),('1','144',257827,'DAILY SALES','2022-11-16','2022-11-16 06:37:06','2022-11-17 06:37:06','916',0.00,0.00,'916','2022-11-16 18:57:14','916','2022-11-16 18:57:50',10,0),('1','144',257828,'DAILY SALES','2022-11-17','2022-11-17 06:28:04','2022-11-18 06:28:04','916',0.00,0.00,'916','2022-11-17 18:29:21','916','2022-11-17 18:29:58',10,0),('1','144',257829,'DAILY SALES','2022-11-18','2022-11-18 06:22:17','2022-11-19 06:22:17','916',0.00,0.00,'916','2022-11-18 18:23:51','916','2022-11-18 18:27:51',10,0),('1','144',257830,'DAILY SALES','2022-11-19','2022-11-19 06:25:27','2022-11-20 06:25:27','916',0.00,0.00,'916','2022-11-19 18:23:45','916','2022-11-19 18:24:10',10,0),('1','144',257831,'DAILY SALES','2022-11-20','2022-11-20 06:36:26','2022-11-21 06:36:26','916',0.00,0.00,'916','2022-11-20 18:40:02','916','2022-11-20 18:40:46',10,0),('1','144',257832,'DAILY SALES','2022-11-21','2022-11-21 06:26:13','2022-11-22 06:26:13','916',0.00,0.00,'916','2022-11-21 18:06:16','916','2022-11-21 18:06:50',10,0),('1','144',257833,'DAILY SALES','2022-11-22','2022-11-22 06:27:53','2022-11-23 06:27:53','916',0.00,0.00,'916','2022-11-22 18:43:51','916','2022-11-22 18:44:35',10,0),('1','144',257834,'DAILY SALES','2022-11-23','2022-11-23 06:25:43','2022-11-24 06:25:43','916',0.00,0.00,'916','2022-11-23 18:12:40','916','2022-11-23 18:13:38',10,0),('1','144',257835,'DAILY SALES','2022-11-24','2022-11-24 06:38:59','2022-11-25 06:38:59','916',0.00,0.00,'916','2022-11-24 15:05:55','916','2022-11-24 15:06:22',10,0),('1','144',257836,'BULK SALES','2022-11-24','2022-11-24 15:08:26','2022-11-25 15:08:26','916',0.00,0.00,'916','2022-11-24 15:12:30','916','2022-11-24 15:12:56',10,0),('1','144',257837,'DAILY SALES','2022-11-24','2022-11-24 15:18:37','2022-11-25 15:18:37','916',0.00,0.00,'916','2022-11-24 18:14:42','916','2022-11-24 18:15:13',10,0),('1','144',257838,'DAILY SALES','2022-11-25','2022-11-25 06:28:46','2022-11-26 06:28:46','916',0.00,0.00,'916','2022-11-25 18:33:09','916','2022-11-25 18:40:46',10,0),('1','144',257839,'DAILY SALES','2022-11-26','2022-11-26 06:23:25','2022-11-27 06:23:25','916',0.00,0.00,'916','2022-11-26 18:23:01','916','2022-11-26 18:23:29',10,0),('1','144',257840,'DAILY SALES','2022-11-27','2022-11-27 06:22:56','2022-11-28 06:22:56','916',0.00,0.00,'916','2022-11-27 18:42:48','916','2022-11-27 18:43:23',10,0),('1','144',257841,'DAILY SALES','2022-11-28','2022-11-28 06:25:34','2022-11-29 06:25:34','916',0.00,0.00,'916','2022-11-28 18:22:11','916','2022-11-28 18:22:39',10,0),('1','144',257842,'DAILY SALES','2022-11-29','2022-11-29 06:23:21','2022-11-30 06:23:21','916',0.00,0.00,'916','2022-11-29 18:22:40','916','2022-11-29 18:23:06',10,0),('1','144',257843,'DAILY SALES','2022-11-30','2022-11-30 06:24:41','2022-12-01 06:24:41','916',0.00,0.00,'916','2022-11-30 18:25:04','916','2022-11-30 18:25:25',10,0),('1','144',257844,'DAILY SALES','2022-12-01','2022-12-01 07:05:20','2022-12-02 07:05:20','916',0.00,0.00,'916','2022-12-01 18:22:19','916','2022-12-01 18:23:03',10,0),('1','144',257845,'DAILY SALES','2022-12-02','2022-12-02 06:30:31','2022-12-03 06:30:31','916',0.00,0.00,'916','2022-12-02 10:48:05','916','2022-12-02 10:48:30',10,0),('1','144',257846,'BULK SALES','2022-12-02','2022-12-02 10:49:17','2022-12-03 10:49:17','916',0.00,0.00,'916','2022-12-02 10:56:24','916','2022-12-02 10:56:50',10,0),('1','144',257847,'DAILY SALES','2022-12-02','2022-12-02 11:04:23','2022-12-03 11:04:23','916',0.00,0.00,'916','2022-12-03 06:32:37','916','2022-12-03 06:33:10',10,0),('1','144',257848,'DAILY SALES','2022-12-03','2022-12-03 06:34:19','2022-12-04 06:34:19','916',0.00,0.00,'916','2022-12-04 06:29:11','916','2022-12-04 06:29:33',10,0),('1','144',257849,'DAILY SALES','2022-12-04','2022-12-04 06:30:09','2022-12-05 06:30:09','916',0.00,0.00,'916','2022-12-04 18:29:23','916','2022-12-04 18:33:57',10,0),('1','144',257850,'DAILY SALES','2022-12-05','2022-12-05 06:25:26','2022-12-06 06:25:26','916',0.00,0.00,'916','2022-12-05 18:17:30','916','2022-12-05 18:17:58',10,0),('1','144',257851,'DAILY SALES','2022-12-06','2022-12-06 06:20:48','2022-12-07 06:20:48','916',0.00,0.00,'916','2022-12-06 18:03:41','916','2022-12-06 18:04:19',10,0),('1','144',257852,'DAILY SALES','2022-12-07','2022-12-07 06:37:23','2022-12-08 06:37:23','916',0.00,0.00,'916','2022-12-07 18:06:24','916','2022-12-07 18:06:55',10,0),('1','144',257853,'DAILY SALES','2022-12-08','2022-12-08 06:42:42','2022-12-09 06:42:42','916',0.00,0.00,'916','2022-12-08 18:21:12','916','2022-12-08 18:21:36',10,0),('1','144',257854,'DAILY SALES','2022-12-09','2022-12-09 06:37:24','2022-12-10 06:37:24','916',0.00,0.00,'916','2022-12-10 06:16:56','916','2022-12-10 06:17:22',10,0),('1','144',257855,'DAILY SALES','2022-12-10','2022-12-10 06:17:55','2022-12-11 06:17:55','916',0.00,0.00,'916','2022-12-10 18:11:55','916','2022-12-10 18:12:19',10,0),('1','144',257856,'DAILY SALES','2022-12-11','2022-12-11 06:18:47','2022-12-12 06:18:47','916',0.00,0.00,'916','2022-12-11 12:40:49','916','2022-12-11 12:41:14',10,0),('1','144',257857,'BULK SALES','2022-12-11','2022-12-11 12:42:16','2022-12-12 12:42:16','916',0.00,0.00,'916','2022-12-11 12:48:29','916','2022-12-11 12:48:55',10,0),('1','144',257858,'DAILY SALES','2022-12-11','2022-12-11 12:53:20','2022-12-12 12:53:20','916',0.00,0.00,'916','2022-12-11 18:22:13','916','2022-12-11 18:22:35',10,0),('1','144',257859,'DAILY SALES','2022-12-12','2022-12-12 06:20:18','2022-12-13 06:20:18','916',0.00,0.00,'916','2022-12-12 18:09:18','916','2022-12-12 18:09:44',10,0),('1','144',257860,'DAILY SALES','2022-12-13','2022-12-13 06:31:40','2022-12-14 06:31:40','916',0.00,0.00,'916','2022-12-13 18:21:57','916','2022-12-13 18:22:20',10,0),('1','144',257861,'DAILY SALES','2022-12-14','2022-12-14 06:37:54','2022-12-15 06:37:54','916',0.00,0.00,'916','2022-12-14 19:54:18','916','2022-12-14 19:54:43',10,0),('1','144',257862,'DAILY SALES','2022-12-15','2022-12-15 06:23:22','2022-12-16 06:23:22','916',0.00,0.00,'916','2022-12-15 18:34:22','916','2022-12-15 18:35:14',10,0),('1','144',257863,'DAILY SALES','2022-12-16','2022-12-16 06:22:22','2022-12-17 06:22:22','916',0.00,0.00,'916','2022-12-16 18:11:24','916','2022-12-16 18:12:13',10,0),('1','144',257864,'DAILY SALES','2022-12-17','2022-12-17 06:26:59','2022-12-18 06:26:59','916',0.00,0.00,'916','2022-12-17 22:48:34','916','2022-12-17 22:49:06',10,0),('1','144',257865,'DAILY SALES','2022-12-18','2022-12-18 06:19:24','2022-12-19 06:19:24','916',0.00,0.00,'916','2022-12-18 18:11:25','916','2022-12-18 18:11:47',10,0),('1','144',257866,'DAILY SALES','2022-12-19','2022-12-19 06:25:15','2022-12-20 06:25:15','916',0.00,0.00,'916','2022-12-19 18:47:46','916','2022-12-19 18:48:11',10,0),('1','144',257867,'DAILY SALES','2022-12-20','2022-12-20 07:14:41','2022-12-21 07:14:41','916',0.00,0.00,'916','2022-12-20 07:19:02','916','2022-12-20 07:19:52',10,0),('1','144',257868,'BULK SALES','2022-12-20','2022-12-20 07:21:36','2022-12-21 07:21:36','916',0.00,0.00,'916','2022-12-20 07:27:16','916','2022-12-20 07:27:44',10,0),('1','144',257869,'DAILY SALES','2022-12-20','2022-12-20 07:38:18','2022-12-21 07:38:18','916',0.00,0.00,'916','2022-12-20 18:28:20','916','2022-12-20 18:29:04',10,0),('1','144',257870,'DAILY SALES','2022-12-21','2022-12-21 06:33:21','2022-12-22 06:33:21','916',0.00,0.00,'916','2022-12-21 18:22:06','916','2022-12-21 18:22:32',10,0),('1','144',257871,'DAILY SALES','2022-12-22','2022-12-22 07:02:59','2022-12-23 07:02:59','916',0.00,0.00,'916','2022-12-22 18:22:56','916','2022-12-22 18:23:20',10,0),('1','144',257872,'DAILY SALES','2022-12-23','2022-12-23 06:36:44','2022-12-24 06:36:44','916',0.00,0.00,'916','2022-12-24 06:29:55','916','2022-12-24 06:30:19',10,0),('1','144',257873,'DAILY SALES','2022-12-24','2022-12-24 06:30:48','2022-12-25 06:30:48','916',0.00,0.00,'916','2022-12-24 18:23:04','916','2022-12-24 18:24:01',10,0),('1','144',257874,'DAILY SALES','2022-12-25','2022-12-25 06:25:09','2022-12-26 06:25:09','916',0.00,0.00,'916','2022-12-25 18:03:34','916','2022-12-25 18:04:01',10,0),('1','144',257875,'DAILY SALES','2022-12-26','2022-12-26 06:42:26','2022-12-27 06:42:26','916',0.00,0.00,'916','2022-12-26 18:14:07','916','2022-12-26 18:14:40',10,0),('1','144',257876,'DAILY SALES','2022-12-27','2022-12-27 06:39:33','2022-12-28 06:39:33','916',0.00,0.00,'916','2022-12-27 18:06:39','916','2022-12-27 18:07:10',10,0),('1','144',257877,'DAILY SALES','2022-12-28','2022-12-28 06:46:54','2022-12-29 06:46:54','916',0.00,0.00,'916','2022-12-28 13:19:54','916','2022-12-28 13:20:21',10,0),('1','144',257878,'BULK SALES','2022-12-28','2022-12-28 13:22:15','2022-12-29 13:22:15','916',0.00,0.00,'916','2022-12-28 13:27:39','916','2022-12-28 13:28:01',10,0),('1','144',257879,'DAILY SALES','2022-12-28','2022-12-28 13:33:08','2022-12-29 13:33:08','916',0.00,0.00,'916','2022-12-28 18:10:03','916','2022-12-28 18:10:27',10,0),('1','144',257880,'DAILY SALES','2022-12-29','2022-12-29 06:45:18','2022-12-30 06:45:18','916',0.00,0.00,'916','2022-12-29 18:05:06','916','2022-12-29 18:05:37',10,0),('1','144',257881,'DAILY SALES','2022-12-30','2022-12-30 06:28:05','2022-12-31 06:28:05','916',0.00,0.00,'916','2022-12-30 18:01:58','916','2022-12-30 18:03:26',10,0),('1','144',257882,'DAILY SALES','2022-12-31','2022-12-31 06:25:31','2023-01-01 06:25:31','916',0.00,0.00,'916','2023-01-01 06:31:57','916','2023-01-01 06:32:20',10,0),('1','144',257883,'DAILY SALES','2023-01-01','2023-01-01 06:32:38','2023-01-02 06:32:38','916',0.00,0.00,'916','2023-01-01 18:05:48','916','2023-01-01 18:06:12',10,0),('1','144',257884,'DAILY SALES','2023-01-02','2023-01-02 06:35:54','2023-01-03 06:35:54','916',0.00,0.00,'916','2023-01-03 06:59:12','916','2023-01-03 06:59:37',10,0),('1','144',257885,'DAILY SALES','2023-01-03','2023-01-03 07:00:06','2023-01-04 07:00:06','916',0.00,0.00,'916','2023-01-03 18:30:39','916','2023-01-03 18:31:04',10,0),('1','144',257886,'DAILY SALES','2023-01-04','2023-01-04 06:41:52','2023-01-05 06:41:52','916',0.00,0.00,'916','2023-01-04 18:26:16','916','2023-01-04 18:26:38',10,0),('1','144',257887,'DAILY SALES','2023-01-05','2023-01-05 06:35:23','2023-01-06 06:35:23','916',0.00,0.00,'916','2023-01-05 18:35:31','916','2023-01-05 18:36:08',10,0),('1','144',257888,'DAILY SALES','2023-01-06','2023-01-06 06:57:58','2023-01-07 06:57:58','916',0.00,0.00,'916','2023-01-06 18:07:39','916','2023-01-06 18:08:22',10,0),('1','144',257889,'DAILY SALES','2023-01-07','2023-01-07 06:29:17','2023-01-08 06:29:17','916',0.00,0.00,'916','2023-01-07 14:42:11','916','2023-01-07 14:42:35',10,0),('1','144',257890,'BULK SALES','2023-01-07','2023-01-07 14:43:22','2023-01-08 14:43:22','916',0.00,0.00,'916','2023-01-07 14:46:54','916','2023-01-07 14:47:14',10,0),('1','144',257891,'DAILY SALES','2023-01-07','2023-01-07 14:51:20','2023-01-08 14:51:20','916',0.00,0.00,'916','2023-01-08 06:28:47','916','2023-01-08 06:29:33',10,0),('1','144',257892,'DAILY SALES','2023-01-08','2023-01-08 06:41:39','2023-01-09 06:41:39','916',0.00,0.00,'916','2023-01-09 06:41:00','916','2023-01-09 06:41:44',10,0),('1','144',257893,'DAILY SALES','2023-01-09','2023-01-09 06:42:13','2023-01-10 06:42:13','916',0.00,0.00,'916','2023-01-10 06:39:04','916','2023-01-10 06:39:27',10,0),('1','144',257894,'DAILY SALES','2023-01-10','2023-01-10 06:39:58','2023-01-11 06:39:58','916',0.00,0.00,'916','2023-01-11 06:27:59','916','2023-01-11 06:28:22',10,0),('1','144',257895,'DAILY SALES','2023-01-11','2023-01-11 06:28:44','2023-01-12 06:28:44','916',0.00,0.00,'916','2023-01-11 18:15:33','916','2023-01-11 18:16:27',10,0),('1','144',257896,'DAILY SALES','2023-01-12','2023-01-12 06:37:36','2023-01-13 06:37:36','916',0.00,0.00,'916','2023-01-12 18:41:07','916','2023-01-12 18:41:50',10,0),('1','144',257897,'DAILY SALES','2023-01-13','2023-01-13 06:39:23','2023-01-14 06:39:23','916',0.00,0.00,'916','2023-01-13 18:28:18','916','2023-01-13 18:28:44',10,0),('1','144',257898,'DAILY SALES','2023-01-14','2023-01-14 06:26:50','2023-01-15 06:26:50','916',0.00,0.00,'916','2023-01-15 06:45:53','916','2023-01-15 06:46:31',10,0),('1','144',257899,'DAILY SALES','2023-01-15','2023-01-15 06:46:52','2023-01-16 06:46:52','916',0.00,0.00,'916','2023-01-15 14:09:53','916','2023-01-15 14:10:18',10,0),('1','144',257900,'BULK SALES','2023-01-15','2023-01-15 14:11:21','2023-01-16 14:11:21','916',0.00,0.00,'916','2023-01-15 14:15:51','916','2023-01-15 14:16:15',10,0),('1','144',257901,'DAILY SALES','2023-01-15','2023-01-15 14:23:58','2023-01-16 14:23:58','916',0.00,0.00,'916','2023-01-15 18:26:21','916','2023-01-15 18:26:49',10,0),('1','144',257902,'DAILY SALES','2023-01-16','2023-01-16 06:31:07','2023-01-17 06:31:07','916',0.00,0.00,'916','2023-01-16 18:41:19','916','2023-01-16 18:41:46',10,0),('1','144',257903,'DAILY SALES','2023-01-17','2023-01-17 06:29:55','2023-01-18 06:29:55','916',0.00,0.00,'916','2023-01-17 19:02:34','916','2023-01-17 19:03:05',10,0),('1','144',257904,'DAILY SALES','2023-01-18','2023-01-18 06:28:04','2023-01-19 06:28:04','916',0.00,0.00,'916','2023-01-19 06:32:28','916','2023-01-19 06:32:49',10,0),('1','144',257905,'DAILY SALES','2023-01-19','2023-01-19 06:33:09','2023-01-20 06:33:09','916',0.00,0.00,'916','2023-01-19 18:39:18','916','2023-01-19 18:39:50',10,0),('1','144',257906,'DAILY SALES','2023-01-20','2023-01-20 06:41:18','2023-01-21 06:41:18','916',0.00,0.00,'916','2023-01-20 18:41:00','916','2023-01-20 18:41:31',10,0),('1','144',257907,'DAILY SALES','2023-01-21','2023-01-21 06:33:03','2023-01-22 06:33:03','916',0.00,0.00,'916','2023-01-21 18:33:45','916','2023-01-21 18:34:18',10,0),('1','144',257908,'DAILY SALES','2023-01-22','2023-01-22 06:39:55','2023-01-23 06:39:55','916',0.00,0.00,'916','2023-01-22 18:23:40','916','2023-01-22 18:24:16',10,0),('1','144',257909,'DAILY SALES','2023-01-23','2023-01-23 06:32:50','2023-01-24 06:32:50','916',0.00,0.00,'916','2023-01-23 16:14:48','916','2023-01-23 16:15:09',10,0),('1','144',257910,'BULK SALES','2023-01-23','2023-01-23 16:16:06','2023-01-24 16:16:06','916',0.00,0.00,'916','2023-01-23 16:19:55','916','2023-01-23 16:20:14',10,0),('1','144',257911,'DAILY SALES','2023-01-23','2023-01-23 16:27:44','2023-01-24 16:27:44','916',0.00,0.00,'916','2023-01-23 18:55:05','916','2023-01-23 18:55:41',10,0),('1','144',257912,'DAILY SALES','2023-01-24','2023-01-24 06:41:01','2023-01-25 06:41:01','916',0.00,0.00,'916','2023-01-24 18:54:17','916','2023-01-24 18:54:51',10,0),('1','144',257913,'DAILY SALES','2023-01-25','2023-01-25 07:02:31','2023-01-26 07:02:31','916',0.00,0.00,'916','2023-01-26 06:53:40','916','2023-01-26 06:54:24',10,0),('1','144',257914,'DAILY SALES','2023-01-26','2023-01-26 06:55:11','2023-01-27 06:55:11','916',0.00,0.00,'916','2023-01-26 18:37:36','916','2023-01-26 18:38:26',10,0),('1','144',257915,'DAILY SALES','2023-01-27','2023-01-27 06:52:20','2023-01-28 06:52:20','916',0.00,0.00,'916','2023-01-27 19:04:33','916','2023-01-27 19:05:14',10,0),('1','144',257916,'DAILY SALES','2023-01-28','2023-01-28 06:35:20','2023-01-29 06:35:20','916',0.00,0.00,'916','2023-01-28 18:45:11','916','2023-01-28 18:45:38',10,0),('1','144',257917,'DAILY SALES','2023-01-29','2023-01-29 06:50:08','2023-01-30 06:50:08','916',0.00,0.00,'916','2023-01-29 18:28:13','916','2023-01-29 18:28:46',10,0),('1','144',257918,'DAILY SALES','2023-01-30','2023-01-30 06:40:27','2023-01-31 06:40:27','916',0.00,0.00,'916','2023-01-30 18:32:46','916','2023-01-30 18:33:25',10,0),('1','144',257919,'DAILY SALES','2023-01-31','2023-01-31 06:49:26','2023-02-01 06:49:26','916',0.00,0.00,'916','2023-01-31 18:53:58','916','2023-01-31 19:14:05',10,0),('1','144',257920,'DAILY SALES','2023-02-01','2023-02-01 07:23:53','2023-02-02 07:23:53','916',0.00,0.00,'916','2023-02-01 08:53:13','916','2023-02-01 08:54:46',10,0),('1','144',257921,'BULK SALES','2023-02-01','2023-02-01 08:56:05','2023-02-02 08:56:05','916',0.00,0.00,'916','2023-02-01 09:06:52','916','2023-02-01 09:07:52',10,0),('1','144',257922,'DAILY SALES','2023-02-01','2023-02-01 09:18:58','2023-02-02 09:18:58','916',0.00,0.00,'916','2023-02-01 19:06:31','916','2023-02-01 19:07:22',10,0),('1','144',257923,'DAILY SALES','2023-02-02','2023-02-02 06:34:04','2023-02-03 06:34:04','916',0.00,0.00,'916','2023-02-02 18:55:37','916','2023-02-02 18:56:04',10,0),('1','144',257924,'DAILY SALES','2023-02-03','2023-02-03 06:51:07','2023-02-04 06:51:07','916',0.00,0.00,'916','2023-02-03 19:28:07','916','2023-02-03 19:28:35',10,0),('1','144',257925,'DAILY SALES','2023-02-04','2023-02-04 06:49:23','2023-02-05 06:49:23','916',0.00,0.00,'916','2023-02-04 19:04:25','916','2023-02-04 19:05:22',10,0),('1','144',257926,'DAILY SALES','2023-02-05','2023-02-05 06:48:48','2023-02-06 06:48:48','916',0.00,0.00,'916','2023-02-05 22:41:11','916','2023-02-05 22:42:02',10,0),('1','144',257927,'DAILY SALES','2023-02-06','2023-02-06 06:55:05','2023-02-07 06:55:05','916',0.00,0.00,'916','2023-02-06 19:49:16','916','2023-02-06 19:49:50',10,0),('1','144',257928,'DAILY SALES','2023-02-07','2023-02-07 06:43:58','2023-02-08 06:43:58','916',0.00,0.00,'916','2023-02-08 06:41:12','916','2023-02-08 06:41:43',10,0),('1','144',257929,'DAILY SALES','2023-02-08','2023-02-08 06:42:05','2023-02-09 06:42:05','916',0.00,0.00,'916','2023-02-09 06:40:37','916','2023-02-09 06:41:06',10,0),('1','144',257930,'DAILY SALES','2023-02-09','2023-02-09 06:42:08','2023-02-10 06:42:08','916',0.00,0.00,'916','2023-02-09 09:04:12','916','2023-02-09 09:04:40',10,0),('1','144',257931,'DAILY SALES','2023-02-09','2023-02-09 09:05:37','2023-02-10 09:05:37','916',0.00,0.00,'916','2023-02-09 09:10:19','916','2023-02-09 09:10:39',10,0),('1','144',257932,'DAILY SALES','2023-02-09','2023-02-09 09:15:01','2023-02-10 09:15:01','916',0.00,0.00,'916','2023-02-10 06:41:18','916','2023-02-10 06:41:42',10,0),('1','144',257933,'DAILY SALES','2023-02-10','2023-02-10 06:42:07','2023-02-11 06:42:07','916',0.00,0.00,'916','2023-02-10 19:32:24','916','2023-02-10 19:53:37',10,0),('1','144',257934,'DAILY SALES','2023-02-11','2023-02-11 06:55:18','2023-02-12 06:55:18','916',0.00,0.00,'916','2023-02-11 18:50:50','916','2023-02-11 18:51:15',10,0),('1','144',257935,'DAILY SALES','2023-02-12','2023-02-12 06:47:44','2023-02-13 06:47:44','916',0.00,0.00,'916','2023-02-13 06:32:05','916','2023-02-13 06:32:34',10,0),('1','144',257936,'DAILY SALES','2023-02-13','2023-02-13 06:33:01','2023-02-14 06:33:01','916',0.00,0.00,'916','2023-02-14 06:37:48','916','2023-02-14 06:38:17',10,0),('1','144',257937,'DAILY SALES','2023-02-14','2023-02-14 06:38:36','2023-02-15 06:38:36','916',0.00,0.00,'916','2023-02-15 06:41:49','916','2023-02-15 06:42:18',10,0),('1','144',257938,'DAILY SALES','2023-02-15','2023-02-15 06:42:41','2023-02-16 06:42:41','916',0.00,0.00,'916','2023-02-15 18:54:28','916','2023-02-15 18:54:59',10,0),('1','144',257939,'DAILY SALES','2023-02-16','2023-02-16 06:40:36','2023-02-17 06:40:36','916',0.00,0.00,'916','2023-02-16 13:00:43','916','2023-02-16 13:01:09',10,0),('1','144',257940,'BULK SALES','2023-02-16','2023-02-16 13:01:43','2023-02-17 13:01:43','916',0.00,0.00,'916','2023-02-16 13:05:50','916','2023-02-16 13:06:19',10,0),('1','144',257941,'DAILY SALES','2023-02-16','2023-02-16 13:33:48','2023-02-17 13:33:48','916',0.00,0.00,'916','2023-02-17 06:48:40','916','2023-02-17 06:49:39',10,0),('1','144',257942,'DAILY SALES','2023-02-17','2023-02-17 06:49:58','2023-02-18 06:49:58','916',0.00,0.00,'916','2023-02-17 19:02:36','916','2023-02-17 19:03:22',10,0),('1','144',257943,'DAILY SALES','2023-02-18','2023-02-18 07:01:21','2023-02-19 07:01:21','916',0.00,0.00,'916','2023-02-18 19:52:39','916','2023-02-18 19:53:26',10,0),('1','144',257944,'DAILY SALES','2023-02-19','2023-02-19 06:39:44','2023-02-20 06:39:44','916',0.00,0.00,'916','2023-02-19 22:49:29','916','2023-02-19 22:49:54',10,0),('1','144',257945,'DAILY SALES','2023-02-20','2023-02-20 06:58:23','2023-02-21 06:58:23','916',0.00,0.00,'916','2023-02-20 19:09:39','916','2023-02-20 19:10:03',10,0),('1','144',257946,'DAILY SALES','2023-02-21','2023-02-21 06:39:48','2023-02-22 06:39:48','916',0.00,0.00,'916','2023-02-21 18:40:45','916','2023-02-21 18:41:34',10,0),('1','144',257947,'DAILY SALES','2023-02-22','2023-02-22 06:52:28','2023-02-23 06:52:28','916',0.00,0.00,'916','2023-02-22 18:57:40','916','2023-02-22 18:58:03',10,0),('1','144',257948,'DAILY SALES','2023-02-23','2023-02-23 06:47:22','2023-02-24 06:47:22','916',0.00,0.00,'916','2023-02-24 06:40:42','916','2023-02-24 06:41:35',10,0),('1','144',257949,'DAILY SALES','2023-02-24','2023-02-24 06:42:27','2023-02-25 06:42:27','916',0.00,0.00,'916','2023-02-24 23:26:36','916','2023-02-24 23:27:14',10,0),('1','144',257950,'DAILY SALES','2023-02-26','2023-02-26 07:13:46','2023-02-27 07:13:46','916',0.00,0.00,'916','2023-02-27 06:34:27','916','2023-02-27 06:34:51',10,0),('1','144',257951,'DAILY SALES','2023-02-27','2023-02-27 06:50:49','2023-02-28 06:50:49','916',0.00,0.00,'916','2023-02-27 08:44:47','916','2023-02-27 08:45:28',10,0),('1','144',257952,'BULK SALES','2023-02-27','2023-02-27 08:46:44','2023-02-28 08:46:44','916',0.00,0.00,'916','2023-02-27 08:56:28','916','2023-02-27 08:56:59',10,0),('1','144',257953,'DAILY SALES','2023-02-27','2023-02-27 09:03:48','2023-02-28 09:03:48','916',0.00,0.00,'916','2023-02-28 06:27:33','916','2023-02-28 06:28:01',10,0),('1','144',257954,'DAILY SALES','2023-02-28','2023-02-28 06:35:23','2023-03-01 06:35:23','916',0.00,0.00,'916','2023-02-28 19:08:06','916','2023-02-28 19:08:33',10,0),('1','144',257955,'DAILY SALES','2023-03-01','2023-03-01 06:53:28','2023-03-02 06:53:28','916',0.00,0.00,'916','2023-03-01 19:07:01','916','2023-03-01 19:07:56',10,0),('1','144',257956,'DAILY SALES','2023-03-02','2023-03-02 06:49:37','2023-03-03 06:49:37','916',0.00,0.00,'916','2023-03-03 06:57:35','916','2023-03-03 06:58:12',10,0),('1','144',257957,'DAILY SALES','2023-03-03','2023-03-03 06:58:52','2023-03-04 06:58:52','916',0.00,0.00,'916','2023-03-03 19:03:26','916','2023-03-03 19:04:11',10,0),('1','144',257958,'DAILY SALES','2023-03-04','2023-03-04 06:57:08','2023-03-05 06:57:08','916',0.00,0.00,'916','2023-03-05 06:44:42','916','2023-03-05 06:45:24',10,0),('1','144',257959,'DAILY SALES','2023-03-05','2023-03-05 06:45:44','2023-03-06 06:45:44','916',0.00,0.00,'916','2023-03-06 06:29:37','916','2023-03-06 06:30:14',10,0),('1','144',257960,'DAILY SALES','2023-03-06','2023-03-06 06:30:44','2023-03-07 06:30:44','916',0.00,0.00,'916','2023-03-06 19:10:07','916','2023-03-06 19:11:23',10,0),('1','144',257961,'DAILY SALES','2023-03-07','2023-03-07 06:37:53','2023-03-08 06:37:53','916',0.00,0.00,'916','2023-03-07 19:08:43','916','2023-03-07 19:09:20',10,0),('1','144',257962,'DAILY SALES','2023-03-08','2023-03-08 06:32:43','2023-03-09 06:32:43','916',0.00,0.00,'916','2023-03-09 09:21:50','916','2023-03-09 09:22:15',10,0),('1','144',257963,'BULK SALES','2023-03-09','2023-03-09 09:36:42','2023-03-10 09:36:42','916',0.00,0.00,'916','2023-03-09 09:42:08','916','2023-03-09 09:42:33',10,0),('1','144',257964,'DAILY SALES','2023-03-10','2023-03-10 06:55:39','2023-03-11 06:55:39','916',0.00,0.00,'916','2023-03-11 06:35:15','916','2023-03-11 06:35:48',10,0),('1','144',257965,'DAILY SALES','2023-03-11','2023-03-11 06:45:29','2023-03-12 06:45:29','916',0.00,0.00,'916','2023-03-12 06:44:33','916','2023-03-12 06:44:57',10,0),('1','144',257966,'DAILY SALES','2023-03-12','2023-03-12 06:45:24','2023-03-13 06:45:24','916',0.00,0.00,'916','2023-03-13 06:41:41','916','2023-03-13 06:42:19',10,0),('1','144',257967,'DAILY SALES','2023-03-13','2023-03-13 06:56:47','2023-03-14 06:56:47','916',0.00,0.00,'916','2023-03-13 19:41:03','916','2023-03-13 19:41:30',10,0),('1','144',257968,'DAILY SALES','2023-03-14','2023-03-14 06:34:34','2023-03-15 06:34:34','916',0.00,0.00,'916','2023-03-14 19:00:07','916','2023-03-15 06:45:29',10,0),('1','144',257969,'DAILY SALES','2023-03-15','2023-03-15 06:45:58','2023-03-16 06:45:58','916',0.00,0.00,'916','2023-03-15 18:44:17','916','2023-03-15 18:44:56',10,0),('1','144',257970,'DAILY SALES','2023-03-16','2023-03-16 06:38:13','2023-03-17 06:38:13','916',0.00,0.00,'916','2023-03-16 19:55:31','916','2023-03-16 19:56:09',10,0),('1','144',257971,'DAILY SALES','2023-03-17','2023-03-17 06:51:34','2023-03-18 06:51:34','916',0.00,0.00,'916','2023-03-17 19:39:54','916','2023-03-17 19:40:40',10,0),('1','144',257972,'DAILY SALES','2023-03-19','2023-03-19 06:46:37','2023-03-20 06:46:37','916',0.00,0.00,'916','2023-03-19 08:23:50','916','2023-03-19 08:24:22',10,0),('1','144',257973,'BULK SALES','2023-03-19','2023-03-19 09:04:38','2023-03-20 09:04:38','916',0.00,0.00,'916','2023-03-19 09:33:06','916','2023-03-19 09:33:34',10,0),('1','144',257974,'DAILY SALES','2023-03-19','2023-03-19 09:38:46','2023-03-20 09:38:46','916',0.00,0.00,'916','2023-03-19 19:27:56','916','2023-03-19 19:39:51',10,0),('1','144',257975,'DAILY SALES','2023-03-20','2023-03-20 06:36:56','2023-03-21 06:36:56','916',0.00,0.00,'916','2023-03-20 19:13:50','916','2023-03-20 19:14:17',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4904547 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','144','828','157104',3122054,'2360','360',0.00,921.40,0.00,0.00,921.40,248672.00,0.00,0.00,0.00),('1','144','829','157104',3122055,'2361','360',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','160790',3187923,'2360','360',921.40,1741.00,0.00,0.00,819.60,219888.00,0.00,0.00,0.00),('1','144','829','160790',3187924,'2361','360',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','160796',3188078,'2360','360',1741.00,2731.00,0.00,0.00,990.00,265490.00,0.00,0.00,0.00),('1','144','829','160796',3188079,'2361','360',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','160802',3188220,'2360','360',2731.00,3450.80,0.00,0.00,719.80,195744.00,0.00,0.00,0.00),('1','144','829','160802',3188221,'2361','360',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','160807',3188277,'2360','360',3450.80,4584.30,0.00,0.00,1133.50,304380.00,0.00,0.00,0.00),('1','144','829','160807',3188278,'2361','360',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','160809',3188280,'2360','360',4584.30,5105.60,0.00,0.00,521.30,144964.00,0.00,0.00,0.00),('1','144','829','160809',3188281,'2361','360',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','160812',3188336,'2360','360',5105.60,6295.20,0.00,0.00,1189.60,317088.00,0.00,0.00,0.00),('1','144','829','160812',3188337,'2361','360',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','160814',3188351,'2360','360',6295.20,7546.60,0.00,0.00,1251.40,339392.00,0.00,0.00,0.00),('1','144','829','160814',3188352,'2361','360',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','160827',3188535,'2360','360',7546.60,9133.10,0.00,0.00,1586.50,415320.00,0.00,0.00,0.00),('1','144','829','160827',3188536,'2361','360',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','160833',3188628,'2360','360',9133.10,9884.90,0.00,0.00,751.80,202004.00,0.00,0.00,0.00),('1','144','829','160833',3188629,'2361','360',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','160849',3188872,'2360','360',9884.90,10971.80,0.00,0.00,1086.90,287332.00,0.00,0.00,0.00),('1','144','829','160849',3188873,'2361','360',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','160857',3188998,'2360','360',10971.80,17594.90,0.00,0.00,6623.10,1564764.00,0.00,0.00,0.00),('1','144','829','160857',3188999,'2361','360',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','160909',3189760,'2360','360',17594.90,19499.40,0.00,0.00,1904.50,483720.00,0.00,0.00,0.00),('1','144','829','160909',3189761,'2361','360',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','160914',3189812,'2360','360',19499.40,21333.80,0.00,0.00,1834.40,471532.00,0.00,0.00,0.00),('1','144','829','160914',3189813,'2361','360',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','160921',3189918,'2360','360',21333.80,22062.20,0.00,0.00,728.40,192052.00,0.00,0.00,0.00),('1','144','829','160921',3189919,'2361','360',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','161534',3200627,'2360','360',22062.20,22062.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','161534',3200628,'2361','360',0.00,763.50,0.00,0.00,763.50,196780.00,0.00,0.00,0.00),('1','144','828','161537',3200665,'2360','360',22062.20,22062.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','161537',3200666,'2361','360',763.50,3787.30,0.00,0.00,3023.80,755804.00,0.00,0.00,0.00),('1','144','828','161540',3200707,'2360','360',22062.20,22062.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','161540',3200708,'2361','360',3787.30,5421.20,0.00,0.00,1633.90,438367.00,0.00,0.00,0.00),('1','144','828','161550',3200892,'2360','360',22062.20,22062.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','161550',3200893,'2361','360',5421.20,8437.00,0.00,0.00,3015.80,774524.00,0.00,0.00,0.00),('1','144','828','161556',3201021,'2360','360',22062.20,22062.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','161556',3201022,'2361','360',8437.00,10758.00,0.00,0.00,2321.00,601380.00,0.00,0.00,0.00),('1','144','828','161559',3201067,'2360','360',22062.20,22062.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','161559',3201068,'2361','360',10758.00,19037.00,0.00,0.00,8279.00,1988480.00,0.00,0.00,0.00),('1','144','828','162310',3214150,'2360','360',22062.20,22062.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','162310',3214151,'2361','360',19037.00,20237.60,0.00,0.00,1200.60,298168.00,0.00,0.00,0.00),('1','144','828','162320',3214337,'2360','360',22062.20,24612.20,0.00,0.00,2550.00,656200.00,0.00,0.00,0.00),('1','144','829','162320',3214338,'2361','360',20237.60,20237.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','162341',3214739,'2360','360',24612.20,25823.10,0.00,0.00,1210.90,322052.00,0.00,0.00,0.00),('1','144','829','162341',3214740,'2361','360',20237.60,20237.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','162346',3214787,'2360','360',25823.10,27489.90,0.00,0.00,1666.80,446304.00,0.00,0.00,0.00),('1','144','829','162346',3214788,'2361','360',20237.60,20237.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','162348',3214807,'2360','360',27489.90,29640.20,0.00,0.00,2150.30,553884.00,0.00,0.00,0.00),('1','144','829','162348',3214808,'2361','360',20237.60,20237.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','162432',3216424,'2360','360',29640.20,32802.50,0.00,0.00,3162.30,793944.00,0.00,0.00,0.00),('1','144','829','162432',3216425,'2361','360',20237.60,20237.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','162435',3216451,'2360','360',32802.50,34729.20,0.00,0.00,1926.70,510372.00,0.00,0.00,0.00),('1','144','829','162435',3216452,'2361','360',20237.60,20237.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','162510',3217474,'2360','360',34729.20,44768.20,0.00,0.00,10039.00,2434166.00,0.00,0.00,0.00),('1','144','829','162510',3217475,'2361','360',20237.60,20237.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','162533',3217849,'2360','360',44768.20,44768.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','162533',3217850,'2361','360',20237.60,22009.00,0.00,0.00,1771.40,470492.00,0.00,0.00,0.00),('1','144','828','162535',3217874,'2360','360',44768.20,44768.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','162535',3217875,'2361','360',22009.00,25234.00,0.00,0.00,3225.00,816502.00,0.00,0.00,0.00),('1','144','828','162540',3217976,'2360','360',44768.20,44768.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','162540',3217977,'2361','360',25234.00,27158.10,0.00,0.00,1924.10,505088.00,0.00,0.00,0.00),('1','144','828','162545',3218054,'2360','360',44768.20,44768.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','162545',3218055,'2361','360',27158.10,29119.60,0.00,0.00,1961.50,507120.00,0.00,0.00,0.00),('1','144','828','162551',3218119,'2360','360',44768.20,44768.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','162551',3218120,'2361','360',29119.60,32658.80,0.00,0.00,3539.20,896676.00,0.00,0.00,0.00),('1','144','828','162555',3218193,'2360','360',44768.20,44768.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','162555',3218194,'2361','360',32658.80,34900.50,0.00,0.00,2241.70,578776.00,0.00,0.00,0.00),('1','144','828','162558',3218227,'2360','360',44768.20,44768.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','162558',3218228,'2361','360',34900.50,42907.80,0.00,0.00,8007.30,1963534.00,0.00,0.00,0.00),('1','144','828','162782',3222345,'2360','360',44768.20,48198.60,0.00,0.00,3430.40,872812.00,0.00,0.00,0.00),('1','144','829','162782',3222346,'2361','360',42907.80,42907.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','162785',3222361,'2360','360',48198.60,61744.60,0.00,0.00,13546.00,3287535.00,0.00,0.00,0.00),('1','144','829','162785',3222362,'2361','360',42907.80,42907.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','162969',3225646,'2360','360',61744.60,63549.20,0.00,0.00,1804.60,478088.00,0.00,0.00,0.00),('1','144','829','162969',3225647,'2361','360',42907.80,42907.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','162973',3225706,'2360','360',63549.20,65864.60,0.00,0.00,2315.40,596512.00,0.00,0.00,0.00),('1','144','829','162973',3225707,'2361','360',42907.80,42907.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','163022',3226475,'2360','360',65864.60,67448.70,0.00,0.00,1584.10,392648.00,0.00,0.00,0.00),('1','144','829','163022',3226476,'2361','360',42907.80,42907.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','163027',3226505,'2360','360',67448.70,67448.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','163027',3226506,'2361','360',42907.80,44725.30,0.00,0.00,1817.50,477450.00,0.00,0.00,0.00),('1','144','828','163644',3237716,'2360','360',67448.70,67448.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','163644',3237717,'2361','360',44725.30,46577.80,0.00,0.00,1852.50,486400.00,0.00,0.00,0.00),('1','144','828','163646',3237748,'2360','360',67448.70,67448.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','163646',3237749,'2361','360',46577.80,49169.30,0.00,0.00,2591.50,678971.60,0.00,0.00,0.00),('1','144','828','163648',3237766,'2360','360',67448.70,67448.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','163648',3237767,'2361','360',49169.30,56947.00,0.00,0.00,7777.70,1924256.00,0.00,0.00,0.00),('1','144','828','163665',3238023,'2360','360',67448.70,67448.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','163665',3238024,'2361','360',56947.00,59923.50,0.00,0.00,2976.50,765878.00,0.00,0.00,0.00),('1','144','828','163907',3242387,'2360','360',67448.70,67448.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','163907',3242388,'2361','360',59923.50,63730.50,0.00,0.00,3807.00,966660.00,0.00,0.00,0.00),('1','144','828','164092',3245646,'2360','360',67448.70,67448.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','164092',3245647,'2361','360',63730.50,65502.80,0.00,0.00,1772.30,470744.00,0.00,0.00,0.00),('1','144','828','164094',3245650,'2360','360',67448.70,67831.80,0.00,0.00,383.10,114930.00,0.00,0.00,0.00),('1','144','829','164094',3245651,'2361','360',65502.80,65502.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','164309',3249603,'2360','360',67831.80,70523.80,0.00,0.00,2692.00,752250.00,0.00,0.00,0.00),('1','144','829','164309',3249604,'2361','360',65502.80,65502.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','164808',3258752,'2360','360',70523.80,72666.50,0.00,0.00,2142.70,601260.00,0.00,0.00,0.00),('1','144','829','164808',3258753,'2361','360',65502.80,65502.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','164812',3258807,'2360','360',72666.50,75482.50,0.00,0.00,2816.00,789300.00,0.00,0.00,0.00),('1','144','829','164812',3258808,'2361','360',65502.80,65502.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','164813',3258809,'2360','360',75482.50,80192.40,0.00,0.00,4709.90,1292070.00,0.00,0.00,0.00),('1','144','829','164813',3258810,'2361','360',65502.80,65502.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','165069',3263433,'2360','360',80192.40,87058.10,0.00,0.00,6865.70,1856739.00,0.00,0.00,0.00),('1','144','829','165069',3263434,'2361','360',65502.80,65502.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','165091',3263875,'2360','360',87058.10,87058.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','165091',3263876,'2361','360',65502.80,68160.10,0.00,0.00,2657.30,741495.00,0.00,0.00,0.00),('1','144','828','165169',3265056,'2360','360',87058.10,87058.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','165169',3265057,'2361','360',68160.10,69758.30,0.00,0.00,1598.20,498424.00,0.00,0.00,0.00),('1','144','828','165380',3268764,'2360','360',87058.10,87058.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','165380',3268765,'2361','360',69758.30,71331.30,0.00,0.00,1573.00,490110.00,0.00,0.00,0.00),('1','144','828','165516',3271005,'2360','360',87058.10,87058.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','165516',3271006,'2361','360',71331.30,72746.70,0.00,0.00,1415.40,442678.00,0.00,0.00,0.00),('1','144','828','166116',3282066,'2360','360',87058.10,87058.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','166116',3282067,'2361','360',72746.70,74541.90,0.00,0.00,1795.20,551764.00,0.00,0.00,0.00),('1','144','828','166123',3282185,'2360','360',87058.10,87058.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','166123',3282186,'2361','360',74541.90,75555.80,0.00,0.00,1013.90,324448.00,0.00,0.00,0.00),('1','144','828','166154',3282582,'2360','360',87058.10,87058.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','166154',3282583,'2361','360',75555.80,76506.50,0.00,0.00,950.70,304224.00,0.00,0.00,0.00),('1','144','828','166155',3282584,'2360','360',87058.10,87058.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','166155',3282585,'2361','360',76506.50,77733.10,0.00,0.00,1226.60,388012.00,0.00,0.00,0.00),('1','144','828','166384',3286845,'2360','360',87058.10,87058.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','166384',3286846,'2361','360',77733.10,78925.50,0.00,0.00,1192.40,375568.00,0.00,0.00,0.00),('1','144','828','166591',3290585,'2360','360',87058.10,87058.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','166591',3290586,'2361','360',78925.50,80218.30,0.00,0.00,1292.80,401896.00,0.00,0.00,0.00),('1','144','828','166739',3292979,'2360','360',87058.10,87058.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','166739',3292980,'2361','360',80218.30,82306.60,0.00,0.00,2088.30,639370.00,0.00,0.00,0.00),('1','144','828','167501',3306780,'2360','360',87058.10,87058.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','167501',3306781,'2361','360',82306.60,83448.70,0.00,0.00,1142.10,359272.00,0.00,0.00,0.00),('1','144','828','167548',3307631,'2360','360',87058.10,87058.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','167548',3307632,'2361','360',83448.70,84939.80,0.00,0.00,1491.10,467352.00,0.00,0.00,0.00),('1','144','828','167631',3308948,'2360','360',87058.10,87058.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','167631',3308949,'2361','360',84939.80,86803.70,0.00,0.00,1863.90,572323.00,0.00,0.00,0.00),('1','144','828','167637',3309036,'2360','360',87058.10,87058.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','167637',3309037,'2361','360',86803.70,87303.70,0.00,0.00,500.00,150000.00,0.00,0.00,0.00),('1','144','828','167642',3309118,'2360','360',87058.10,99020.00,0.00,0.00,11961.90,3462498.00,0.00,0.00,0.00),('1','144','829','167642',3309119,'2361','360',87303.70,87303.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','167693',3310079,'2360','360',99020.00,100371.50,0.00,0.00,1351.50,422630.00,0.00,0.00,0.00),('1','144','829','167693',3310080,'2361','360',87303.70,87303.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','167781',3311393,'2360','360',100371.50,101672.90,0.00,0.00,1301.40,403523.00,0.00,0.00,0.00),('1','144','829','167781',3311394,'2361','360',87303.70,87303.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','168145',3318212,'2360','360',101672.90,102979.70,0.00,0.00,1306.80,414756.00,0.00,0.00,0.00),('1','144','829','168145',3318213,'2361','360',87303.70,87303.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','168147',3318234,'2360','360',102979.70,104085.20,0.00,0.00,1105.50,343760.00,0.00,0.00,0.00),('1','144','829','168147',3318235,'2361','360',87303.70,87303.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','168481',3324317,'2360','360',104085.20,105525.90,0.00,0.00,1440.70,446774.00,0.00,0.00,0.00),('1','144','829','168481',3324318,'2361','360',87303.70,87303.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','168485',3324380,'2360','360',105525.90,107973.30,0.00,0.00,2447.40,744568.00,0.00,0.00,0.00),('1','144','829','168485',3324381,'2361','360',87303.70,87303.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','168627',3326976,'2360','360',107973.30,109389.70,0.00,0.00,1416.40,436435.50,0.00,0.00,0.00),('1','144','829','168627',3326977,'2361','360',87303.70,87303.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','168961',3332910,'2360','360',109389.70,109389.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','168961',3332911,'2361','360',87303.70,89119.00,0.00,0.00,1815.30,556661.00,0.00,0.00,0.00),('1','144','828','168963',3332937,'2360','360',109389.70,109389.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','168963',3332938,'2361','360',89119.00,91097.30,0.00,0.00,1978.30,590536.00,0.00,0.00,0.00),('1','144','828','169152',3336205,'2360','360',109389.70,109389.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','169152',3336206,'2361','360',91097.30,93602.30,0.00,0.00,2505.00,762030.00,0.00,0.00,0.00),('1','144','828','169945',3351479,'2360','360',109389.70,109389.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','169945',3351480,'2361','360',93602.30,95277.30,0.00,0.00,1675.00,518250.00,0.00,0.00,0.00),('1','144','828','169948',3351514,'2360','360',109389.70,109389.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','169948',3351515,'2361','360',95277.30,97484.90,0.00,0.00,2207.60,676212.00,0.00,0.00,0.00),('1','144','828','169949',3351516,'2360','360',109389.70,109389.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','169949',3351517,'2361','360',97484.90,99460.50,0.00,0.00,1975.60,605892.00,0.00,0.00,0.00),('1','144','828','169953',3351560,'2360','360',109389.70,109389.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','169953',3351561,'2361','360',99460.50,99460.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','169954',3351562,'2360','360',109389.70,109389.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','169954',3351563,'2361','360',99460.50,101076.60,0.00,0.00,1616.10,495884.00,0.00,0.00,0.00),('1','144','828','169968',3351835,'2360','360',109389.70,109389.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','169968',3351836,'2361','360',101076.60,101076.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','169979',3352073,'2360','360',109389.70,109389.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','169979',3352074,'2361','360',101076.60,103054.90,0.00,0.00,1978.30,590536.00,0.00,0.00,0.00),('1','144','828','169986',3352207,'2360','360',109389.70,109389.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','169986',3352208,'2361','360',103054.90,104671.00,0.00,0.00,1616.10,495884.00,0.00,0.00,0.00),('1','144','828','170155',3355209,'2360','360',109389.70,109389.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','170155',3355210,'2361','360',104671.00,105990.50,0.00,0.00,1319.50,405590.00,0.00,0.00,0.00),('1','144','828','170944',3369049,'2360','360',109389.70,109389.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','170944',3369050,'2361','360',105990.50,107249.10,0.00,0.00,1258.60,391502.00,0.00,0.00,0.00),('1','144','828','170952',3369207,'2360','360',109389.70,109389.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','170952',3369208,'2361','360',107249.10,108918.10,0.00,0.00,1669.00,510880.00,0.00,0.00,0.00),('1','144','828','170955',3369257,'2360','360',109389.70,109389.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','170955',3369258,'2361','360',108918.10,113500.70,0.00,0.00,4582.60,1309716.00,0.00,0.00,0.00),('1','144','828','170964',3369468,'2360','360',109389.70,112691.80,0.00,0.00,3302.10,972728.00,0.00,0.00,0.00),('1','144','829','170964',3369469,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','171075',3371410,'2360','360',112691.80,113769.90,0.00,0.00,1078.10,334492.00,0.00,0.00,0.00),('1','144','829','171075',3371411,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','171087',3371675,'2360','360',113769.90,115707.30,0.00,0.00,1937.40,588030.50,0.00,0.00,0.00),('1','144','829','171087',3371676,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','171192',3373778,'2360','360',115707.30,117644.70,0.00,0.00,1937.40,588030.50,0.00,0.00,0.00),('1','144','829','171192',3373779,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','171194',3373802,'2360','360',117644.70,118399.40,0.00,0.00,754.70,377841.50,0.00,0.00,0.00),('1','144','829','171194',3373803,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','171339',3376480,'2360','360',118399.40,120726.50,0.00,0.00,2327.10,688672.00,0.00,0.00,0.00),('1','144','829','171339',3376481,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','171986',3387940,'2360','360',120726.50,122908.90,0.00,0.00,2182.40,652105.00,0.00,0.00,0.00),('1','144','829','171986',3387941,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','171988',3387968,'2360','360',122908.90,130226.00,0.00,0.00,7317.10,2112572.00,0.00,0.00,0.00),('1','144','829','171988',3387969,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','171992',3388011,'2360','360',130226.00,133425.40,0.00,0.00,3199.40,936658.00,0.00,0.00,0.00),('1','144','829','171992',3388012,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','171994',3388015,'2360','360',133425.40,135413.50,0.00,0.00,1988.10,573958.50,0.00,0.00,0.00),('1','144','829','171994',3388016,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','171997',3388049,'2360','360',135413.50,136227.90,0.00,0.00,814.40,249691.50,0.00,0.00,0.00),('1','144','829','171997',3388050,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','172350',3394565,'2360','360',136227.90,138205.80,0.00,0.00,1977.90,599328.00,0.00,0.00,0.00),('1','144','829','172350',3394566,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','172352',3394610,'2360','360',138205.80,140096.50,0.00,0.00,1890.70,564896.50,0.00,0.00,0.00),('1','144','829','172352',3394611,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','172514',3397714,'2360','360',140096.50,142020.90,0.00,0.00,1924.40,576608.00,0.00,0.00,0.00),('1','144','829','172514',3397715,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','172704',3401036,'2360','360',142020.90,151161.40,0.00,0.00,9140.50,2633844.00,0.00,0.00,0.00),('1','144','829','172704',3401037,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','172878',3404282,'2360','360',151161.40,152965.50,0.00,0.00,1804.10,539288.00,0.00,0.00,0.00),('1','144','829','172878',3404283,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','173064',3407800,'2360','360',152965.50,157106.70,0.00,0.00,4141.20,1208284.00,0.00,0.00,0.00),('1','144','829','173064',3407801,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','173225',3411071,'2360','360',157106.70,160353.50,0.00,0.00,3246.80,951476.00,0.00,0.00,0.00),('1','144','829','173225',3411072,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','173300',3412390,'2360','360',160353.50,160511.50,0.00,0.00,158.00,50560.00,0.00,0.00,0.00),('1','144','829','173300',3412391,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','173393',3413947,'2360','360',160511.50,163227.80,0.00,0.00,2716.30,812936.00,0.00,0.00,0.00),('1','144','829','173393',3413948,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','173672',3419018,'2360','360',163227.80,165408.70,0.00,0.00,2180.90,653333.00,0.00,0.00,0.00),('1','144','829','173672',3419019,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','173770',3420866,'2360','360',165408.70,173207.70,0.00,0.00,7799.00,2253305.00,0.00,0.00,0.00),('1','144','829','173770',3420867,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','173950',3424217,'2360','360',173207.70,176107.50,0.00,0.00,2899.80,852721.00,0.00,0.00,0.00),('1','144','829','173950',3424218,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','174134',3427363,'2360','360',176107.50,179079.60,0.00,0.00,2972.10,879864.50,0.00,0.00,0.00),('1','144','829','174134',3427364,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','174326',3430995,'2360','360',179079.60,181536.30,0.00,0.00,2456.70,735331.00,0.00,0.00,0.00),('1','144','829','174326',3430996,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','174515',3434140,'2360','360',181536.30,184817.50,0.00,0.00,3281.20,939734.00,0.00,0.00,0.00),('1','144','829','174515',3434141,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','174527',3434350,'2360','360',184817.50,186447.10,0.00,0.00,1629.60,488880.00,0.00,0.00,0.00),('1','144','829','174527',3434351,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','174648',3436489,'2360','360',186447.10,191869.50,0.00,0.00,5422.40,1626720.00,0.00,0.00,0.00),('1','144','829','174648',3436490,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','174856',3440317,'2360','360',191869.50,195474.40,0.00,0.00,3604.90,1088570.00,0.00,0.00,0.00),('1','144','829','174856',3440318,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','175245',3447527,'2360','360',195474.40,203118.30,0.00,0.00,7643.90,2411466.80,0.00,0.00,0.00),('1','144','829','175245',3447528,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','175247',3447531,'2360','360',203118.30,208022.10,0.00,0.00,4903.80,1560198.60,0.00,0.00,0.00),('1','144','829','175247',3447532,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','175424',3450797,'2360','360',208022.10,209397.50,0.00,0.00,1375.40,452960.30,0.00,0.00,0.00),('1','144','829','175424',3450798,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','175426',3450815,'2360','360',209397.50,209585.50,0.00,0.00,188.00,64226.00,0.00,0.00,0.00),('1','144','829','175426',3450816,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','175969',3460758,'2360','360',209585.50,211297.00,0.00,0.00,1711.50,572628.00,0.00,0.00,0.00),('1','144','829','175969',3460759,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','175971',3460782,'2360','360',211297.00,213562.10,0.00,0.00,2265.10,746915.20,0.00,0.00,0.00),('1','144','829','175971',3460783,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','175978',3460900,'2360','360',213562.10,216129.00,0.00,0.00,2566.90,843971.80,0.00,0.00,0.00),('1','144','829','175978',3460901,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','176150',3463926,'2360','360',216129.00,225339.00,0.00,0.00,9210.00,2917092.00,0.00,0.00,0.00),('1','144','829','176150',3463927,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','176571',3471837,'2360','360',225339.00,227091.10,0.00,0.00,1752.10,570539.20,0.00,0.00,0.00),('1','144','829','176571',3471838,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','176575',3471882,'2360','360',227091.10,229932.10,0.00,0.00,2841.00,911328.00,0.00,0.00,0.00),('1','144','829','176575',3471883,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','176845',3476899,'2360','360',229932.10,233983.50,0.00,0.00,4051.40,1300202.00,0.00,0.00,0.00),('1','144','829','176845',3476900,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','178163',3502353,'2360','360',233983.50,235840.30,0.00,0.00,1856.80,594793.60,0.00,0.00,0.00),('1','144','829','178163',3502354,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','178173',3502528,'2360','360',235840.30,246730.20,0.00,0.00,10889.90,3424044.80,0.00,0.00,0.00),('1','144','829','178173',3502529,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','178186',3502745,'2360','360',246730.20,248441.10,0.00,0.00,1710.90,575956.80,0.00,0.00,0.00),('1','144','829','178186',3502746,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','178198',3502953,'2360','360',248441.10,251119.10,0.00,0.00,2678.00,894056.00,0.00,0.00,0.00),('1','144','829','178198',3502954,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','178261',3504194,'2360','360',251119.10,253233.60,0.00,0.00,2114.50,699304.00,0.00,0.00,0.00),('1','144','829','178261',3504195,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','178265',3504254,'2360','360',253233.60,256542.60,0.00,0.00,3309.00,1076568.00,0.00,0.00,0.00),('1','144','829','178265',3504255,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','178305',3504795,'2360','360',256542.60,258533.50,0.00,0.00,1990.90,654511.60,0.00,0.00,0.00),('1','144','829','178305',3504796,'2361','360',113500.70,113500.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','178315',3504965,'2360','360',258533.50,258533.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','178315',3504966,'2361','360',113500.70,115953.10,0.00,0.00,2452.40,803844.80,0.00,0.00,0.00),('1','144','828','178682',3511960,'2360','360',258533.50,258533.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','178682',3511961,'2361','360',115953.10,127623.00,0.00,0.00,11669.90,3674432.80,0.00,0.00,0.00),('1','144','828','178738',3512788,'2360','360',258533.50,258533.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','178738',3512789,'2361','360',127623.00,130124.30,0.00,0.00,2501.30,842157.60,0.00,0.00,0.00),('1','144','828','179514',3527439,'2360','360',258533.50,258533.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','179514',3527440,'2361','360',130124.30,132233.90,0.00,0.00,2109.60,722579.20,0.00,0.00,0.00),('1','144','828','179515',3527441,'2360','360',258533.50,258533.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','179515',3527442,'2361','360',132233.90,134537.70,0.00,0.00,2303.80,781817.60,0.00,0.00,0.00),('1','144','828','179517',3527461,'2360','360',258533.50,258533.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','179517',3527462,'2361','360',134537.70,136218.60,0.00,0.00,1680.90,574446.80,0.00,0.00,0.00),('1','144','828','179796',3532700,'2360','360',258533.50,258533.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','179796',3532701,'2361','360',136218.60,138098.70,0.00,0.00,1880.10,625793.20,0.00,0.00,0.00),('1','144','828','180352',3542976,'2360','360',258533.50,260028.40,0.00,0.00,1494.90,508964.80,0.00,0.00,0.00),('1','144','829','180352',3542977,'2361','360',138098.70,138098.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','180355',3543058,'2360','360',260028.40,260829.00,0.00,0.00,800.60,281811.20,0.00,0.00,0.00),('1','144','829','180355',3543059,'2361','360',138098.70,141648.70,0.00,0.00,3550.00,1178600.00,0.00,0.00,0.00),('1','144','828','180361',3543098,'2360','360',260829.00,261992.80,0.00,0.00,1163.80,398407.60,0.00,0.00,0.00),('1','144','829','180361',3543099,'2361','360',141648.70,141648.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','180365',3543152,'2360','360',261992.80,269155.20,0.00,0.00,7162.40,2394364.80,0.00,0.00,0.00),('1','144','829','180365',3543153,'2361','360',141648.70,141648.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','180367',3543170,'2360','360',269155.20,271223.40,0.00,0.00,2068.20,709006.40,0.00,0.00,0.00),('1','144','829','180367',3543171,'2361','360',141648.70,141648.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','180616',3547794,'2360','360',271223.40,273701.10,0.00,0.00,2477.70,838950.40,0.00,0.00,0.00),('1','144','829','180616',3547795,'2361','360',141648.70,141648.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','180956',3554389,'2360','360',273701.10,275244.40,0.00,0.00,1543.30,528241.60,0.00,0.00,0.00),('1','144','829','180956',3554390,'2361','360',141648.70,141648.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','181365',3562090,'2360','360',275244.40,277722.10,0.00,0.00,2477.70,838950.40,0.00,0.00,0.00),('1','144','829','181365',3562091,'2361','360',141648.70,141648.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','181373',3562225,'2360','360',277722.10,279265.40,0.00,0.00,1543.30,528241.60,0.00,0.00,0.00),('1','144','829','181373',3562226,'2361','360',141648.70,141648.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','181382',3562375,'2360','360',279265.40,280528.60,0.00,0.00,1263.20,433526.40,0.00,0.00,0.00),('1','144','829','181382',3562376,'2361','360',141648.70,141648.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','181386',3562452,'2360','360',280528.60,282350.90,0.00,0.00,1822.30,625609.60,0.00,0.00,0.00),('1','144','829','181386',3562453,'2361','360',141648.70,141648.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','181389',3562472,'2360','360',282350.90,283482.00,0.00,0.00,1131.10,387547.20,0.00,0.00,0.00),('1','144','829','181389',3562473,'2361','360',141648.70,141648.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','181414',3563044,'2360','360',283482.00,283482.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','181414',3563045,'2361','360',141648.70,142487.10,0.00,0.00,838.40,283116.80,0.00,0.00,0.00),('1','144','828','181581',3565874,'2360','360',283482.00,283482.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','181581',3565875,'2361','360',142487.10,144832.20,0.00,0.00,2345.10,793475.20,0.00,0.00,0.00),('1','144','828','181847',3570575,'2360','360',283482.00,283482.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','181847',3570576,'2361','360',144832.20,149549.00,0.00,0.00,4716.80,1579416.60,0.00,0.00,0.00),('1','144','828','182082',3575094,'2360','360',283482.00,283482.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','182082',3575095,'2361','360',149549.00,151337.60,0.00,0.00,1788.60,610987.20,0.00,0.00,0.00),('1','144','828','182204',3577100,'2360','360',283482.00,283482.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','182204',3577101,'2361','360',151337.60,153399.10,0.00,0.00,2061.50,700148.00,0.00,0.00,0.00),('1','144','828','182602',3584310,'2360','360',283482.00,283482.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','182602',3584311,'2361','360',153399.10,155245.20,0.00,0.00,1846.10,629817.20,0.00,0.00,0.00),('1','144','828','182614',3584578,'2360','360',283482.00,283482.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','182614',3584579,'2361','360',155245.20,160509.60,0.00,0.00,5264.40,1756318.80,0.00,0.00,0.00),('1','144','828','183212',3595571,'2360','360',283482.00,283482.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','183212',3595572,'2361','360',160509.60,161909.60,0.00,0.00,1400.00,479800.00,0.00,0.00,0.00),('1','144','828','184004',3609895,'2360','360',283482.00,283482.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','184004',3609896,'2361','360',161909.60,164745.60,0.00,0.00,2836.00,960532.00,0.00,0.00,0.00),('1','144','828','184011',3610025,'2360','360',283482.00,283482.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','184011',3610026,'2361','360',164745.60,166018.70,0.00,0.00,1273.10,426131.20,0.00,0.00,0.00),('1','144','828','184013',3610043,'2360','360',283482.00,284351.30,0.00,0.00,869.30,299993.60,0.00,0.00,0.00),('1','144','829','184013',3610044,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','184192',3613320,'2360','360',284351.30,287899.00,0.00,0.00,3547.70,1187099.40,0.00,0.00,0.00),('1','144','829','184192',3613321,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','184199',3613463,'2360','360',287899.00,289489.60,0.00,0.00,1590.60,544891.20,0.00,0.00,0.00),('1','144','829','184199',3613464,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','184203',3613529,'2360','360',289489.60,294764.90,0.00,0.00,5275.30,1758955.60,0.00,0.00,0.00),('1','144','829','184203',3613530,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','184415',3617191,'2360','360',294764.90,297250.30,0.00,0.00,2485.40,843790.80,0.00,0.00,0.00),('1','144','829','184415',3617192,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','184417',3617217,'2360','360',297250.30,298931.60,0.00,0.00,1681.30,572267.60,0.00,0.00,0.00),('1','144','829','184417',3617218,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','184418',3617219,'2360','360',298931.60,302385.20,0.00,0.00,3453.60,1155767.20,0.00,0.00,0.00),('1','144','829','184418',3617220,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','184834',3624908,'2360','360',302385.20,304210.60,0.00,0.00,1825.40,618140.80,0.00,0.00,0.00),('1','144','829','184834',3624909,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','184836',3624922,'2360','360',304210.60,306681.10,0.00,0.00,2470.50,831966.00,0.00,0.00,0.00),('1','144','829','184836',3624923,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','185040',3628334,'2360','360',306681.10,309151.60,0.00,0.00,2470.50,831966.00,0.00,0.00,0.00),('1','144','829','185040',3628335,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','185049',3628501,'2360','360',309151.60,309452.50,0.00,0.00,300.90,101916.80,0.00,0.00,0.00),('1','144','829','185049',3628502,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','186489',3653658,'2360','360',309452.50,310489.50,0.00,0.00,1037.00,353024.00,0.00,0.00,0.00),('1','144','829','186489',3653659,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','186883',3660450,'2360','360',310489.50,312444.90,0.00,0.00,1955.40,662420.80,0.00,0.00,0.00),('1','144','829','186883',3660451,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','186897',3660669,'2360','360',312444.90,315813.90,0.00,0.00,3369.00,1126613.00,0.00,0.00,0.00),('1','144','829','186897',3660670,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','186902',3660778,'2360','360',315813.90,316663.20,0.00,0.00,849.30,294433.60,0.00,0.00,0.00),('1','144','829','186902',3660779,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','186912',3660873,'2360','360',316663.20,320745.30,0.00,0.00,4082.10,1363449.20,0.00,0.00,0.00),('1','144','829','186912',3660874,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','186920',3660984,'2360','360',320745.30,322901.60,0.00,0.00,2156.30,730017.60,0.00,0.00,0.00),('1','144','829','186920',3660985,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','186925',3661051,'2360','360',322901.60,324094.30,0.00,0.00,1192.70,411330.40,0.00,0.00,0.00),('1','144','829','186925',3661052,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','186927',3661069,'2360','360',324094.30,326093.60,0.00,0.00,1999.30,680503.60,0.00,0.00,0.00),('1','144','829','186927',3661070,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','186928',3661071,'2360','360',326093.60,327315.50,0.00,0.00,1221.90,418858.80,0.00,0.00,0.00),('1','144','829','186928',3661072,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','186929',3661073,'2360','360',327315.50,328778.90,0.00,0.00,1463.40,500126.80,0.00,0.00,0.00),('1','144','829','186929',3661074,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','186930',3661075,'2360','360',328778.90,331198.80,0.00,0.00,2419.90,815254.80,0.00,0.00,0.00),('1','144','829','186930',3661076,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','186971',3661797,'2360','360',331198.80,332722.90,0.00,0.00,1524.10,526483.20,0.00,0.00,0.00),('1','144','829','186971',3661798,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','187147',3664891,'2360','360',332722.90,333795.90,0.00,0.00,1073.00,371696.00,0.00,0.00,0.00),('1','144','829','187147',3664892,'2361','360',166018.70,166018.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','187273',3666943,'2360','360',333795.90,333801.90,0.00,0.00,6.00,2112.00,0.00,0.00,0.00),('1','144','829','187273',3666944,'2361','360',166018.70,166896.30,0.00,0.00,877.60,297915.20,0.00,0.00,0.00),('1','144','828','187334',3668276,'2360','360',333801.90,333845.40,0.00,0.00,43.50,15312.00,0.00,0.00,0.00),('1','144','829','187334',3668277,'2361','360',166896.30,168249.50,0.00,0.00,1353.20,470326.40,0.00,0.00,0.00),('1','144','828','187558',3672278,'2360','360',333845.40,333857.90,0.00,0.00,12.50,4400.00,0.00,0.00,0.00),('1','144','829','187558',3672279,'2361','360',168249.50,169847.30,0.00,0.00,1597.80,548175.60,0.00,0.00,0.00),('1','144','828','187782',3676263,'2360','360',333857.90,333857.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','187782',3676264,'2361','360',169847.30,171539.90,0.00,0.00,1692.60,577695.20,0.00,0.00,0.00),('1','144','828','188000',3680066,'2360','360',333857.90,333857.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','188000',3680067,'2361','360',171539.90,173498.80,0.00,0.00,1958.90,669778.80,0.00,0.00,0.00),('1','144','828','188195',3683436,'2360','360',333857.90,333862.90,0.00,0.00,5.00,1760.00,0.00,0.00,0.00),('1','144','829','188195',3683437,'2361','360',173498.80,174845.00,0.00,0.00,1346.20,460862.40,0.00,0.00,0.00),('1','144','828','188406',3687041,'2360','360',333862.90,333862.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','188406',3687042,'2361','360',174845.00,176042.90,0.00,0.00,1197.90,411660.80,0.00,0.00,0.00),('1','144','828','188593',3690300,'2360','360',333862.90,333862.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','188593',3690301,'2361','360',176042.90,183798.80,0.00,0.00,7755.90,2580076.80,0.00,0.00,0.00),('1','144','828','188792',3693850,'2360','360',333862.90,333862.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','188792',3693851,'2361','360',183798.80,189335.80,0.00,0.00,5537.00,1835684.00,0.00,0.00,0.00),('1','144','828','188991',3697407,'2360','360',333862.90,335900.90,0.00,0.00,2038.00,691576.00,0.00,0.00,0.00),('1','144','829','188991',3697408,'2361','360',189335.80,190355.30,0.00,0.00,1019.50,336864.00,0.00,0.00,0.00),('1','144','828','189189',3700921,'2360','360',335900.90,337704.30,0.00,0.00,1803.40,617596.80,0.00,0.00,0.00),('1','144','829','189189',3700922,'2361','360',190355.30,190367.30,0.00,0.00,12.00,4224.00,0.00,0.00,0.00),('1','144','828','189406',3704918,'2360','360',337704.30,339605.90,0.00,0.00,1901.60,647613.20,0.00,0.00,0.00),('1','144','829','189406',3704919,'2361','360',190367.30,190367.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','189604',3708349,'2360','360',339605.90,341568.30,0.00,0.00,1962.40,665964.80,0.00,0.00,0.00),('1','144','829','189604',3708350,'2361','360',190367.30,190367.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','189816',3711908,'2360','360',341568.30,346312.00,0.00,0.00,4743.70,1579442.40,0.00,0.00,0.00),('1','144','829','189816',3711909,'2361','360',190367.30,190367.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','190023',3716182,'2360','360',346312.00,349743.30,0.00,0.00,3431.30,1154417.60,0.00,0.00,0.00),('1','144','829','190023',3716183,'2361','360',190367.30,190367.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','190211',3719696,'2360','360',349743.30,352677.80,0.00,0.00,2934.50,997144.00,0.00,0.00,0.00),('1','144','829','190211',3719697,'2361','360',190367.30,190367.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','190421',3723663,'2360','360',352677.80,356090.70,0.00,0.00,3412.90,1157040.80,0.00,0.00,0.00),('1','144','829','190421',3723664,'2361','360',190367.30,190367.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','190660',3728116,'2360','360',356090.70,358330.70,0.00,0.00,2240.00,757880.00,0.00,0.00,0.00),('1','144','829','190660',3728117,'2361','360',190367.30,191557.30,0.00,0.00,1190.00,408880.00,0.00,0.00,0.00),('1','144','828','190877',3732108,'2360','360',358330.70,358330.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','190877',3732109,'2361','360',191557.30,195459.20,0.00,0.00,3901.90,1311198.80,0.00,0.00,0.00),('1','144','828','191066',3735374,'2360','360',358330.70,358330.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','191066',3735375,'2361','360',195459.20,199244.80,0.00,0.00,3785.60,1268831.20,0.00,0.00,0.00),('1','144','828','191277',3739140,'2360','360',358330.70,358330.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','191277',3739141,'2361','360',199244.80,202635.00,0.00,0.00,3390.20,1138290.40,0.00,0.00,0.00),('1','144','828','191486',3742866,'2360','360',358330.70,358330.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','191486',3742867,'2361','360',202635.00,205569.70,0.00,0.00,2934.70,985014.40,0.00,0.00,0.00),('1','144','828','191710',3747187,'2360','360',358330.70,358330.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','191710',3747188,'2361','360',205569.70,207182.60,0.00,0.00,1612.90,549740.80,0.00,0.00,0.00),('1','144','828','191922',3751425,'2360','360',358330.70,358330.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','191922',3751426,'2361','360',207182.60,210845.40,0.00,0.00,3662.80,1226805.60,0.00,0.00,0.00),('1','144','828','192124',3754846,'2360','360',358330.70,358330.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','192124',3754847,'2361','360',210845.40,212384.50,0.00,0.00,1539.10,525513.20,0.00,0.00,0.00),('1','144','828','192329',3758755,'2360','360',358330.70,358330.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','192329',3758756,'2361','360',212384.50,214770.40,0.00,0.00,2385.90,807980.80,0.00,0.00,0.00),('1','144','828','192650',3764227,'2360','360',358330.70,361158.80,0.00,0.00,2828.10,953641.20,0.00,0.00,0.00),('1','144','829','192650',3764228,'2361','360',214770.40,214782.90,0.00,0.00,12.50,4400.00,0.00,0.00,0.00),('1','144','828','192747',3766221,'2360','360',361158.80,364661.00,0.00,0.00,3502.20,1173832.40,0.00,0.00,0.00),('1','144','829','192747',3766222,'2361','360',214782.90,214782.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','192950',3769871,'2360','360',364661.00,369563.80,0.00,0.00,4902.80,1653843.60,0.00,0.00,0.00),('1','144','829','192950',3769872,'2361','360',214782.90,214782.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','193164',3773944,'2360','360',369563.80,371163.20,0.00,0.00,1599.40,553988.80,0.00,0.00,0.00),('1','144','829','193164',3773945,'2361','360',214782.90,214782.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','193394',3778727,'2360','360',371163.20,372870.50,0.00,0.00,1707.30,585969.60,0.00,0.00,0.00),('1','144','829','193394',3778728,'2361','360',214782.90,214784.90,0.00,0.00,2.00,704.00,0.00,0.00,0.00),('1','144','828','193618',3782822,'2360','360',372870.50,378678.40,0.00,0.00,5807.90,1940780.80,0.00,0.00,0.00),('1','144','829','193618',3782823,'2361','360',214784.90,214784.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','193842',3786817,'2360','360',378678.40,382920.40,0.00,0.00,4242.00,1416025.00,0.00,0.00,0.00),('1','144','829','193842',3786818,'2361','360',214784.90,214784.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','194069',3790808,'2360','360',382920.40,382945.40,0.00,0.00,25.00,8700.00,0.00,0.00,0.00),('1','144','829','194069',3790809,'2361','360',214784.90,217590.10,0.00,0.00,2805.20,936345.60,0.00,0.00,0.00),('1','144','828','194276',3794743,'2360','360',382945.40,382948.40,0.00,0.00,3.00,1044.00,0.00,0.00,0.00),('1','144','829','194276',3794744,'2361','360',217590.10,222850.00,0.00,0.00,5259.90,1741335.20,0.00,0.00,0.00),('1','144','828','194470',3798125,'2360','360',382948.40,382948.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','194470',3798126,'2361','360',222850.00,224561.50,0.00,0.00,1711.50,586602.00,0.00,0.00,0.00),('1','144','828','194657',3801409,'2360','360',382948.40,384711.10,0.00,0.00,1762.70,602419.60,0.00,0.00,0.00),('1','144','829','194657',3801410,'2361','360',224561.50,239361.00,0.00,0.00,14799.50,4736442.00,0.00,0.00,0.00),('1','144','828','194897',3806136,'2360','360',384711.10,386657.30,0.00,0.00,1946.20,659277.60,0.00,0.00,0.00),('1','144','829','194897',3806137,'2361','360',239361.00,239361.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','195067',3809261,'2360','360',386657.30,389775.00,0.00,0.00,3117.70,1056559.60,0.00,0.00,0.00),('1','144','829','195067',3809262,'2361','360',239361.00,239361.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','195290',3813236,'2360','360',389775.00,393844.00,0.00,0.00,4069.00,1372412.00,0.00,0.00,0.00),('1','144','829','195290',3813237,'2361','360',239361.00,239361.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','195506',3817032,'2360','360',393844.00,396051.30,0.00,0.00,2207.30,751140.40,0.00,0.00,0.00),('1','144','829','195506',3817033,'2361','360',239361.00,239361.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','195762',3821281,'2360','360',396051.30,399408.80,0.00,0.00,3357.50,1124910.00,0.00,0.00,0.00),('1','144','829','195762',3821282,'2361','360',239361.00,239361.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','195995',3825482,'2360','360',399408.80,403990.70,0.00,0.00,4581.90,1511863.20,0.00,0.00,0.00),('1','144','829','195995',3825483,'2361','360',239361.00,239361.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','196211',3829632,'2360','360',403990.70,406477.30,0.00,0.00,2486.60,841836.80,0.00,0.00,0.00),('1','144','829','196211',3829633,'2361','360',239361.00,239361.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','196524',3835162,'2360','360',406477.30,407544.10,0.00,0.00,1066.80,349246.40,0.00,0.00,0.00),('1','144','829','196524',3835163,'2361','360',239361.00,241129.80,0.00,0.00,1768.80,603042.40,0.00,0.00,0.00),('1','144','828','196650',3837530,'2360','360',407544.10,407544.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','196650',3837531,'2361','360',241129.80,243740.30,0.00,0.00,2610.50,896454.00,0.00,0.00,0.00),('1','144','828','196866',3841279,'2360','360',407544.10,407544.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','196866',3841280,'2361','360',243740.30,245171.00,0.00,0.00,1430.70,485383.60,0.00,0.00,0.00),('1','144','828','197014',3844112,'2360','360',407544.10,407544.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','197014',3844113,'2361','360',245171.00,247828.80,0.00,0.00,2657.80,893414.40,0.00,0.00,0.00),('1','144','828','197327',3849896,'2360','360',407544.10,407544.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','197327',3849897,'2361','360',247828.80,250257.80,0.00,0.00,2429.00,813842.00,0.00,0.00,0.00),('1','144','828','197422',3850634,'2360','360',407544.10,407544.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','197422',3850635,'2361','360',250257.80,263918.36,0.00,0.00,13660.56,4451054.88,0.00,0.00,0.00),('1','144','828','197504',3852309,'2360','360',407544.10,409583.20,0.00,0.00,2039.10,692006.80,0.00,0.00,0.00),('1','144','829','197504',3852310,'2361','360',263918.36,265600.36,0.00,0.00,1682.00,548332.00,0.00,0.00,0.00),('1','144','828','197858',3858637,'2360','360',409583.20,414308.80,0.00,0.00,4725.60,1579808.80,0.00,0.00,0.00),('1','144','829','197858',3858638,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','198105',3863019,'2360','360',414308.80,417030.70,0.00,0.00,2721.90,927121.20,0.00,0.00,0.00),('1','144','829','198105',3863020,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','198337',3866940,'2360','360',417030.70,419803.30,0.00,0.00,2772.60,946864.80,0.00,0.00,0.00),('1','144','829','198337',3866941,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','198554',3870694,'2360','360',419803.30,422786.40,0.00,0.00,2983.10,1019918.80,0.00,0.00,0.00),('1','144','829','198554',3870695,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','198770',3874228,'2360','360',422786.40,424866.50,0.00,0.00,2080.10,718874.80,0.00,0.00,0.00),('1','144','829','198770',3874229,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','198973',3877786,'2360','360',424866.50,429162.10,0.00,0.00,4295.60,1442968.80,0.00,0.00,0.00),('1','144','829','198973',3877787,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199409',3885166,'2360','360',429162.10,430162.10,0.00,0.00,1000.00,326000.00,0.00,0.00,0.00),('1','144','829','199409',3885167,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199632',3889092,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199632',3889093,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199634',3889102,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199634',3889103,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199636',3889119,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199636',3889120,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199640',3889163,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199640',3889164,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199644',3889208,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199644',3889209,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199647',3889212,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199647',3889213,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199650',3889222,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199650',3889223,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199655',3889276,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199655',3889277,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199656',3889278,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199656',3889279,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199658',3889308,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199658',3889309,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199662',3889325,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199662',3889326,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199665',3889335,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199665',3889336,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199668',3889346,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199668',3889347,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199673',3889412,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199673',3889413,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199676',3889421,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199676',3889422,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199678',3889425,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199678',3889426,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199679',3889427,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199679',3889428,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199684',3889493,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199684',3889494,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199689',3889563,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199689',3889564,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199695',3889658,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199695',3889659,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199697',3889673,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199697',3889674,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199701',3889740,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199701',3889741,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199703',3889767,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199703',3889768,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199706',3889816,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199706',3889817,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199707',3889818,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199707',3889819,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199715',3889966,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199715',3889967,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199722',3890057,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199722',3890058,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199728',3890112,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199728',3890113,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','199732',3890184,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','199732',3890185,'2361','360',265600.36,265600.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','200889',3911142,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','200889',3911143,'2361','360',265600.36,270548.36,0.00,0.00,4948.00,1650744.00,0.00,0.00,0.00),('1','144','828','200892',3911182,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','200892',3911183,'2361','360',270548.36,272070.36,0.00,0.00,1522.00,522656.00,0.00,0.00,0.00),('1','144','828','200893',3911184,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','200893',3911185,'2361','360',272070.36,278887.36,0.00,0.00,6817.00,2264306.00,0.00,0.00,0.00),('1','144','828','200894',3911186,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','200894',3911187,'2361','360',278887.36,281215.36,0.00,0.00,2328.00,794344.00,0.00,0.00,0.00),('1','144','828','200896',3911206,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','200896',3911207,'2361','360',281215.36,283962.36,0.00,0.00,2747.00,931956.00,0.00,0.00,0.00),('1','144','828','200898',3911230,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','200898',3911231,'2361','360',283962.36,287153.36,0.00,0.00,3191.00,1084468.00,0.00,0.00,0.00),('1','144','828','200899',3911232,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','200899',3911233,'2361','360',287153.36,289856.36,0.00,0.00,2703.00,910944.00,0.00,0.00,0.00),('1','144','828','200907',3911370,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','200907',3911371,'2361','360',289856.36,289856.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','200908',3911372,'2360','360',430162.10,430162.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','200908',3911373,'2361','360',289856.36,290734.36,0.00,0.00,878.00,300244.00,0.00,0.00,0.00),('1','144','828','200947',3911771,'2360','360',430162.10,430174.10,0.00,0.00,12.00,4176.00,0.00,0.00,0.00),('1','144','829','200947',3911772,'2361','360',290734.36,293913.76,0.00,0.00,3179.40,1077081.20,0.00,0.00,0.00),('1','144','828','201098',3914512,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','201098',3914513,'2361','360',293913.76,300785.76,0.00,0.00,6872.00,2278956.00,0.00,0.00,0.00),('1','144','828','201298',3917862,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','201298',3917863,'2361','360',300785.76,302742.46,0.00,0.00,1956.70,673931.60,0.00,0.00,0.00),('1','144','828','201488',3921414,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','201488',3921415,'2361','360',302742.46,312006.36,0.00,0.00,9263.90,3045687.20,0.00,0.00,0.00),('1','144','828','201757',3926569,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','201757',3926570,'2361','360',312006.36,314077.36,0.00,0.00,2071.00,695688.00,0.00,0.00,0.00),('1','144','828','202017',3931487,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','202017',3931488,'2361','360',314077.36,314077.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','202108',3932932,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','202108',3932933,'2361','360',314077.36,317700.36,0.00,0.00,3623.00,1259880.00,0.00,0.00,0.00),('1','144','828','202207',3934619,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','202207',3934620,'2361','360',317700.36,321695.46,0.00,0.00,3995.10,1378236.00,0.00,0.00,0.00),('1','144','828','202416',3938309,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','202416',3938310,'2361','360',321695.46,323784.46,0.00,0.00,2089.00,732940.00,0.00,0.00,0.00),('1','144','828','202633',3942079,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','202633',3942080,'2361','360',323784.46,329324.46,0.00,0.00,5540.00,1881812.00,0.00,0.00,0.00),('1','144','828','202846',3945866,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','202846',3945867,'2361','360',329324.46,330941.46,0.00,0.00,1617.00,564520.00,0.00,0.00,0.00),('1','144','828','203106',3950809,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','203106',3950810,'2361','360',330941.46,335673.46,0.00,0.00,4732.00,1608480.00,0.00,0.00,0.00),('1','144','828','203294',3954329,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','203294',3954330,'2361','360',335673.46,338358.46,0.00,0.00,2685.00,924690.00,0.00,0.00,0.00),('1','144','828','203552',3958731,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','203552',3958732,'2361','360',338358.46,338358.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','203564',3958893,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','203564',3958894,'2361','360',338358.46,341461.46,0.00,0.00,3103.00,1084774.00,0.00,0.00,0.00),('1','144','828','203717',3961909,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','203717',3961910,'2361','360',341461.46,344721.96,0.00,0.00,3260.50,1127280.00,0.00,0.00,0.00),('1','144','828','203952',3966030,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','203952',3966031,'2361','360',344721.96,347132.96,0.00,0.00,2411.00,836360.00,0.00,0.00,0.00),('1','144','828','204185',3970316,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204185',3970317,'2361','360',347132.96,354070.96,0.00,0.00,6938.00,2356200.00,0.00,0.00,0.00),('1','144','828','204391',3973964,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204391',3973965,'2361','360',354070.96,357151.96,0.00,0.00,3081.00,1067300.00,0.00,0.00,0.00),('1','144','828','204618',3978051,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204618',3978052,'2361','360',357151.96,362203.46,0.00,0.00,5051.50,1707880.00,0.00,0.00,0.00),('1','144','828','204797',3981341,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204797',3981342,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204798',3981343,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204798',3981344,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204799',3981345,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204799',3981346,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204800',3981347,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204800',3981348,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204801',3981349,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204801',3981350,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204802',3981351,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204802',3981352,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204803',3981353,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204803',3981354,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204804',3981355,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204804',3981356,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204806',3981372,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204806',3981373,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204807',3981374,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204807',3981375,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204808',3981376,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204808',3981377,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204809',3981378,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204809',3981379,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204810',3981380,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204810',3981381,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204811',3981382,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204811',3981383,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204812',3981384,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204812',3981385,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204814',3981399,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204814',3981400,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204815',3981401,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204815',3981402,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204816',3981403,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204816',3981404,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204817',3981405,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204817',3981406,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204818',3981407,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204818',3981408,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204819',3981409,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204819',3981410,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204820',3981411,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204820',3981412,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204821',3981413,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204821',3981414,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204822',3981415,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204822',3981416,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204918',3982949,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204918',3982950,'2361','360',362203.46,362203.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','204938',3983293,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','204938',3983294,'2361','360',362203.46,367334.46,0.00,0.00,5131.00,1735460.00,0.00,0.00,0.00),('1','144','828','205134',3986911,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','205134',3986912,'2361','360',367334.46,372727.46,0.00,0.00,5393.00,1835840.00,0.00,0.00,0.00),('1','144','828','205224',3988630,'2360','360',430174.10,430174.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','205224',3988631,'2361','360',372727.46,375270.06,0.00,0.00,2542.60,885737.60,0.00,0.00,0.00),('1','144','828','205472',3993104,'2360','360',430174.10,430674.10,0.00,0.00,500.00,167000.00,0.00,0.00,0.00),('1','144','829','205472',3993105,'2361','360',375270.06,377787.06,0.00,0.00,2517.00,872720.00,0.00,0.00,0.00),('1','144','828','205716',3997653,'2360','360',430674.10,430676.10,0.00,0.00,2.00,720.00,0.00,0.00,0.00),('1','144','829','205716',3997654,'2361','360',377787.06,380273.06,0.00,0.00,2486.00,861280.00,0.00,0.00,0.00),('1','144','828','205940',4001552,'2360','360',430676.10,430676.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','205940',4001553,'2361','360',380273.06,384224.06,0.00,0.00,3951.00,1351600.00,0.00,0.00,0.00),('1','144','828','206222',4006500,'2360','360',430676.10,430679.10,0.00,0.00,3.00,1080.00,0.00,0.00,0.00),('1','144','829','206222',4006501,'2361','360',384224.06,385788.06,0.00,0.00,1564.00,536240.00,0.00,0.00,0.00),('1','144','828','206384',4009135,'2360','360',430679.10,430679.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','206384',4009136,'2361','360',385788.06,385788.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','206387',4009189,'2360','360',430679.10,430679.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','206387',4009190,'2361','360',385788.06,392219.06,0.00,0.00,6431.00,2185392.00,0.00,0.00,0.00),('1','144','828','206570',4012556,'2360','360',430679.10,430679.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','206570',4012557,'2361','360',392219.06,399056.06,0.00,0.00,6837.00,2344232.00,0.00,0.00,0.00),('1','144','828','206795',4016511,'2360','360',430679.10,430679.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','206795',4016512,'2361','360',399056.06,401730.06,0.00,0.00,2674.00,929040.00,0.00,0.00,0.00),('1','144','828','207015',4020590,'2360','360',430679.10,430679.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','207015',4020591,'2361','360',401730.06,407606.06,0.00,0.00,5876.00,1990200.00,0.00,0.00,0.00),('1','144','828','207346',4026243,'2360','360',430679.10,430679.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','207346',4026244,'2361','360',407606.06,407606.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','207350',4026266,'2360','360',430679.10,430679.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','207350',4026267,'2361','360',407606.06,412043.06,0.00,0.00,4437.00,1516932.00,0.00,0.00,0.00),('1','144','828','207472',4028737,'2360','360',430679.10,430679.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','207472',4028738,'2361','360',412043.06,416449.06,0.00,0.00,4406.00,1510960.00,0.00,0.00,0.00),('1','144','828','207794',4034044,'2360','360',430679.10,430679.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','207794',4034045,'2361','360',416449.06,421578.06,0.00,0.00,5129.00,1786336.00,0.00,0.00,0.00),('1','144','828','207900',4036029,'2360','360',430679.10,430689.10,0.00,0.00,10.00,3840.00,0.00,0.00,0.00),('1','144','829','207900',4036030,'2361','360',421578.06,425699.06,0.00,0.00,4121.00,1497668.00,0.00,0.00,0.00),('1','144','828','208103',4039549,'2360','360',430689.10,430689.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','208103',4039550,'2361','360',425699.06,430730.56,0.00,0.00,5031.50,1829971.00,0.00,0.00,0.00),('1','144','828','208430',4045284,'2360','360',430689.10,430689.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','208430',4045285,'2361','360',430730.56,430730.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','208446',4045463,'2360','360',430689.10,430689.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','208446',4045464,'2361','360',430730.56,435588.56,0.00,0.00,4858.00,1711572.00,0.00,0.00,0.00),('1','144','828','208571',4047663,'2360','360',430689.10,430689.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','208571',4047664,'2361','360',435588.56,438270.56,0.00,0.00,2682.00,989088.00,0.00,0.00,0.00),('1','144','828','208747',4050967,'2360','360',430689.10,430689.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','208747',4050968,'2361','360',438270.56,450318.56,0.00,0.00,12048.00,4215834.00,0.00,0.00,0.00),('1','144','828','208992',4055095,'2360','360',430689.10,430689.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','208992',4055096,'2361','360',450318.56,453823.66,0.00,0.00,3505.10,1299982.00,0.00,0.00,0.00),('1','144','828','209212',4058965,'2360','360',430689.10,430689.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','209212',4058966,'2361','360',453823.66,454974.86,0.00,0.00,1151.20,447080.00,0.00,0.00,0.00),('1','144','828','209402',4062414,'2360','360',430689.10,430689.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','209402',4062415,'2361','360',454974.86,454974.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','209432',4062814,'2360','360',430689.10,430689.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','209432',4062815,'2361','360',454974.86,460392.86,0.00,0.00,5418.00,2060740.00,0.00,0.00,0.00),('1','144','828','209633',4066507,'2360','360',430689.10,430689.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','209633',4066508,'2361','360',460392.86,463846.26,0.00,0.00,3453.40,1342000.00,0.00,0.00,0.00),('1','144','828','209867',4070500,'2360','360',430689.10,430689.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','209867',4070501,'2361','360',463846.26,466186.56,0.00,0.00,2340.30,948026.00,0.00,0.00,0.00),('1','144','828','210103',4074768,'2360','360',430689.10,430689.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','210103',4074769,'2361','360',466186.56,468537.50,0.00,0.00,2350.94,947090.80,0.00,0.00,0.00),('1','144','828','210308',4078328,'2360','360',430689.10,430700.10,0.00,0.00,11.00,4620.00,0.00,0.00,0.00),('1','144','829','210308',4078329,'2361','360',468537.50,474465.14,0.00,0.00,5927.64,2315880.80,0.00,0.00,0.00),('1','144','828','210521',4082257,'2360','360',430700.10,430700.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','210521',4082258,'2361','360',474465.14,479020.34,0.00,0.00,4555.20,1791614.00,0.00,0.00,0.00),('1','144','828','210808',4087266,'2360','360',430700.10,430700.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','210808',4087267,'2361','360',479020.34,479020.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','210812',4087316,'2360','360',430700.10,430700.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','210812',4087317,'2361','360',479020.34,481670.64,0.00,0.00,2650.30,1068610.00,0.00,0.00,0.00),('1','144','828','210958',4089740,'2360','360',430700.10,430700.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','210958',4089741,'2361','360',481670.64,495728.70,0.00,0.00,14058.06,5435839.20,0.00,0.00,0.00),('1','144','828','211183',4093725,'2360','360',430700.10,430700.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','211183',4093726,'2361','360',495728.70,499118.30,0.00,0.00,3389.60,1430074.00,0.00,0.00,0.00),('1','144','828','211374',4097298,'2360','360',430700.10,430700.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','211374',4097299,'2361','360',499118.30,502582.70,0.00,0.00,3464.40,1469436.00,0.00,0.00,0.00),('1','144','828','211600',4101244,'2360','360',430700.10,430700.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','211600',4101245,'2361','360',502582.70,503211.40,0.00,0.00,628.70,258628.00,0.00,0.00,0.00),('1','144','828','211701',4102807,'2360','360',430700.10,430700.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','211701',4102808,'2361','360',503211.40,503211.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','211709',4102994,'2360','360',430700.10,430700.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','211709',4102995,'2361','360',503211.40,509281.00,0.00,0.00,6069.60,2408479.00,0.00,0.00,0.00),('1','144','828','211779',4104120,'2360','360',430700.10,430700.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','211779',4104121,'2361','360',509281.00,514858.40,0.00,0.00,5577.40,2242536.00,0.00,0.00,0.00),('1','144','828','211987',4107848,'2360','360',430700.10,430700.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','211987',4107849,'2361','360',514858.40,517119.02,0.00,0.00,2260.62,945307.80,0.00,0.00,0.00),('1','144','828','212226',4112097,'2360','360',430700.10,430712.10,0.00,0.00,12.00,5280.00,0.00,0.00,0.00),('1','144','829','212226',4112098,'2361','360',517119.02,520130.96,0.00,0.00,3011.94,1251275.10,0.00,0.00,0.00),('1','144','828','212452',4116289,'2360','360',430712.10,430712.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','212452',4116290,'2361','360',520130.96,526952.21,0.00,0.00,6821.25,2759875.00,0.00,0.00,0.00),('1','144','828','212824',4122926,'2360','360',430712.10,430712.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','212824',4122927,'2361','360',526952.21,527468.91,0.00,0.00,516.70,216098.00,0.00,0.00,0.00),('1','144','828','212827',4122956,'2360','360',430712.10,430712.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','212827',4122957,'2361','360',527468.91,527468.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','212950',4125035,'2360','360',430712.10,430712.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','212950',4125036,'2361','360',527468.91,534086.88,0.00,0.00,6617.97,2742066.80,0.00,0.00,0.00),('1','144','828','213127',4128144,'2360','360',430712.10,430712.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','213127',4128145,'2361','360',534086.88,537212.63,0.00,0.00,3125.75,1329730.00,0.00,0.00,0.00),('1','144','828','213397',4132461,'2360','360',430712.10,430712.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','213397',4132462,'2361','360',537212.63,541839.15,0.00,0.00,4626.52,1926708.80,0.00,0.00,0.00),('1','144','828','213632',4136434,'2360','360',430712.10,430714.80,0.00,0.00,2.70,1188.00,0.00,0.00,0.00),('1','144','829','213632',4136435,'2361','360',541839.15,545507.72,0.00,0.00,3668.57,1550670.80,0.00,0.00,0.00),('1','144','828','213880',4140524,'2360','360',430714.80,430714.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','213880',4140525,'2361','360',545507.72,547444.57,0.00,0.00,1936.85,832714.00,0.00,0.00,0.00),('1','144','828','214086',4144049,'2360','360',430714.80,430714.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','214086',4144050,'2361','360',547444.57,551474.97,0.00,0.00,4030.40,1661076.00,0.00,0.00,0.00),('1','144','828','214158',4145110,'2360','360',430714.80,430714.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','214158',4145111,'2361','360',551474.97,551474.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','214165',4145202,'2360','360',430714.80,430714.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','214165',4145203,'2361','360',551474.97,553967.48,0.00,0.00,2492.51,1051204.40,0.00,0.00,0.00),('1','144','828','214327',4148258,'2360','360',430714.80,430714.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','214327',4148259,'2361','360',553967.48,560796.44,0.00,0.00,6828.96,2842502.40,0.00,0.00,0.00),('1','144','828','214518',4151513,'2360','360',430714.80,430714.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','214518',4151514,'2361','360',560796.44,564583.04,0.00,0.00,3786.60,1601104.00,0.00,0.00,0.00),('1','144','828','214769',4155833,'2360','360',430714.80,430720.80,0.00,0.00,6.00,2640.00,0.00,0.00,0.00),('1','144','829','214769',4155834,'2361','360',564583.04,571054.94,0.00,0.00,6471.90,2698071.00,0.00,0.00,0.00),('1','144','828','214991',4159491,'2360','360',430720.80,430743.80,0.00,0.00,23.00,10120.00,0.00,0.00,0.00),('1','144','829','214991',4159492,'2361','360',571054.94,574342.04,0.00,0.00,3287.10,1401324.00,0.00,0.00,0.00),('1','144','828','215250',4163795,'2360','360',430743.80,430743.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','215250',4163796,'2361','360',574342.04,575042.04,0.00,0.00,700.00,285600.00,0.00,0.00,0.00),('1','144','828','215406',4166568,'2360','360',430743.80,430743.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','215406',4166569,'2361','360',575042.04,575042.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','215439',4167076,'2360','360',430743.80,438723.04,0.00,0.00,7979.24,3307230.60,0.00,0.00,0.00),('1','144','829','215439',4167077,'2361','360',575042.04,575084.04,0.00,0.00,42.00,18480.00,0.00,0.00,0.00),('1','144','828','215674',4171113,'2360','360',438723.04,441601.64,0.00,0.00,2878.60,1231194.00,0.00,0.00,0.00),('1','144','829','215674',4171114,'2361','360',575084.04,575089.04,0.00,0.00,5.00,2200.00,0.00,0.00,0.00),('1','144','828','215904',4175059,'2360','360',441601.64,446479.70,0.00,0.00,4878.06,2055096.40,0.00,0.00,0.00),('1','144','829','215904',4175060,'2361','360',575089.04,575092.04,0.00,0.00,3.00,1320.00,0.00,0.00,0.00),('1','144','828','216096',4178425,'2360','360',446479.70,455552.13,0.00,0.00,9072.43,3757217.20,0.00,0.00,0.00),('1','144','829','216096',4178426,'2361','360',575092.04,575098.04,0.00,0.00,6.00,2640.00,0.00,0.00,0.00),('1','144','828','216550',4186255,'2360','360',455552.13,455552.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','216550',4186256,'2361','360',575098.04,575098.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','217008',4194395,'2360','360',455552.13,455552.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','217008',4194396,'2361','360',575098.04,585312.45,0.00,0.00,10214.41,4540756.80,0.00,0.00,0.00),('1','144','828','217265',4199294,'2360','360',455552.13,455552.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','217265',4199295,'2361','360',585312.45,588284.40,0.00,0.00,2971.95,1359436.00,0.00,0.00,0.00),('1','144','828','217500',4203214,'2360','360',455552.13,455552.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','217500',4203215,'2361','360',588284.40,594085.20,0.00,0.00,5800.80,2604884.00,0.00,0.00,0.00),('1','144','828','217703',4206688,'2360','360',455552.13,455552.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','217703',4206689,'2361','360',594085.20,599566.93,0.00,0.00,5481.73,2440728.40,0.00,0.00,0.00),('1','144','828','218171',4214990,'2360','360',455552.13,455552.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','218171',4214991,'2361','360',599566.93,599566.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','218321',4217509,'2360','360',455552.13,455552.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','218321',4217510,'2361','360',599566.93,604577.97,0.00,0.00,5011.04,2241773.20,0.00,0.00,0.00),('1','144','828','218444',4219812,'2360','360',455552.13,455552.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','218444',4219813,'2361','360',604577.97,610852.00,0.00,0.00,6274.03,2813786.40,0.00,0.00,0.00),('1','144','828','218685',4224063,'2360','360',455552.13,455552.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','218685',4224064,'2361','360',610852.00,614139.30,0.00,0.00,3287.30,1478916.00,0.00,0.00,0.00),('1','144','828','218908',4228000,'2360','360',455552.13,455552.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','218908',4228001,'2361','360',614139.30,621943.90,0.00,0.00,7804.60,3466952.00,0.00,0.00,0.00),('1','144','828','219148',4231922,'2360','360',455552.13,455552.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','219148',4231923,'2361','360',621943.90,623995.50,0.00,0.00,2051.60,946768.00,0.00,0.00,0.00),('1','144','828','219306',4234993,'2360','360',455552.13,455552.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','219306',4234994,'2361','360',623995.50,623995.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','219339',4235370,'2360','360',455552.13,455557.13,0.00,0.00,5.00,2400.00,0.00,0.00,0.00),('1','144','829','219339',4235371,'2361','360',623995.50,631568.31,0.00,0.00,7572.81,3366268.80,0.00,0.00,0.00),('1','144','828','219603',4239871,'2360','360',455557.13,455570.13,0.00,0.00,13.00,6240.00,0.00,0.00,0.00),('1','144','829','219603',4239872,'2361','360',631568.31,634346.17,0.00,0.00,2777.86,1269532.80,0.00,0.00,0.00),('1','144','828','219798',4243637,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','219798',4243638,'2361','360',634346.17,637299.20,0.00,0.00,2953.03,1352078.40,0.00,0.00,0.00),('1','144','828','220028',4247784,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','220028',4247785,'2361','360',637299.20,645862.58,0.00,0.00,8563.38,3817862.40,0.00,0.00,0.00),('1','144','828','220232',4251299,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','220232',4251300,'2361','360',645862.58,648584.98,0.00,0.00,2722.40,1209882.00,0.00,0.00,0.00),('1','144','828','220445',4255342,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','220445',4255343,'2361','360',648584.98,648584.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','220457',4255486,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','220457',4255487,'2361','360',648584.98,658720.28,0.00,0.00,10135.30,4495453.00,0.00,0.00,0.00),('1','144','828','220686',4259288,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','220686',4259289,'2361','360',658720.28,662525.08,0.00,0.00,3804.80,1745744.00,0.00,0.00,0.00),('1','144','828','220919',4263354,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','220919',4263355,'2361','360',662525.08,667005.58,0.00,0.00,4480.50,2025160.00,0.00,0.00,0.00),('1','144','828','221129',4267282,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','221129',4267283,'2361','360',667005.58,673233.02,0.00,0.00,6227.44,2778109.20,0.00,0.00,0.00),('1','144','828','221358',4271320,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','221358',4271321,'2361','360',673233.02,673233.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','221384',4271766,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','221384',4271767,'2361','360',673233.02,679394.02,0.00,0.00,6161.00,2757580.00,0.00,0.00,0.00),('1','144','828','221604',4275995,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','221604',4275996,'2361','360',679394.02,686953.22,0.00,0.00,7559.20,3384818.00,0.00,0.00,0.00),('1','144','828','221817',4279686,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','221817',4279687,'2361','360',686953.22,692264.92,0.00,0.00,5311.70,2403136.00,0.00,0.00,0.00),('1','144','828','222050',4283936,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','222050',4283937,'2361','360',692264.92,697820.62,0.00,0.00,5555.70,2464236.00,0.00,0.00,0.00),('1','144','828','222246',4287256,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','222246',4287257,'2361','360',697820.62,697820.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','222362',4288958,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','222362',4288959,'2361','360',697820.62,701800.62,0.00,0.00,3980.00,1768460.00,0.00,0.00,0.00),('1','144','828','222477',4291197,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','222477',4291198,'2361','360',701800.62,709531.82,0.00,0.00,7731.20,3443226.00,0.00,0.00,0.00),('1','144','828','222719',4295690,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','222719',4295691,'2361','360',709531.82,713343.22,0.00,0.00,3811.40,1733772.00,0.00,0.00,0.00),('1','144','828','223050',4301695,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','223050',4301696,'2361','360',713343.22,718891.52,0.00,0.00,5548.30,2478828.00,0.00,0.00,0.00),('1','144','828','223162',4303646,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','223162',4303647,'2361','360',718891.52,722402.22,0.00,0.00,3510.70,1613214.40,0.00,0.00,0.00),('1','144','828','223369',4306879,'2360','360',455570.13,455570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','223369',4306880,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','223405',4307806,'2360','360',455570.13,464592.33,0.00,0.00,9022.20,4146604.80,0.00,0.00,0.00),('1','144','829','223405',4307807,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','223631',4311955,'2360','360',464592.33,475653.13,0.00,0.00,11060.80,5157689.60,0.00,0.00,0.00),('1','144','829','223631',4311956,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','223865',4316314,'2360','360',475653.13,480120.43,0.00,0.00,4467.30,2096755.60,0.00,0.00,0.00),('1','144','829','223865',4316315,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','224029',4319111,'2360','360',480120.43,480120.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','224029',4319112,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','224084',4319966,'2360','360',480120.43,485696.03,0.00,0.00,5575.60,2622395.20,0.00,0.00,0.00),('1','144','829','224084',4319967,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','224298',4324020,'2360','360',485696.03,493916.53,0.00,0.00,8220.50,3903322.00,0.00,0.00,0.00),('1','144','829','224298',4324021,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','224520',4327854,'2360','360',493916.53,498199.33,0.00,0.00,4282.80,2144896.00,0.00,0.00,0.00),('1','144','829','224520',4327855,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','224766',4332177,'2360','360',498199.33,503386.03,0.00,0.00,5186.70,2588640.00,0.00,0.00,0.00),('1','144','829','224766',4332178,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','225005',4336473,'2360','360',503386.03,504713.03,0.00,0.00,1327.00,660500.00,0.00,0.00,0.00),('1','144','829','225005',4336474,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','225238',4340619,'2360','360',504713.03,504713.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','225238',4340620,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','225308',4341634,'2360','360',504713.03,510001.03,0.00,0.00,5288.00,2613254.40,0.00,0.00,0.00),('1','144','829','225308',4341635,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','225482',4345077,'2360','360',510001.03,515692.63,0.00,0.00,5691.60,2815868.00,0.00,0.00,0.00),('1','144','829','225482',4345078,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','225695',4348711,'2360','360',515692.63,518544.63,0.00,0.00,2852.00,1411580.00,0.00,0.00,0.00),('1','144','829','225695',4348712,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','225962',4353314,'2360','360',518544.63,525723.23,0.00,0.00,7178.60,3543299.20,0.00,0.00,0.00),('1','144','829','225962',4353315,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','226430',4361876,'2360','360',525723.23,529031.23,0.00,0.00,3308.00,1635640.00,0.00,0.00,0.00),('1','144','829','226430',4361877,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','226435',4361962,'2360','360',529031.23,529031.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','226435',4361963,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','226718',4367140,'2360','360',529031.23,537821.93,0.00,0.00,8790.70,4337290.00,0.00,0.00,0.00),('1','144','829','226718',4367141,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','226941',4371163,'2360','360',537821.93,544031.63,0.00,0.00,6209.70,3071598.00,0.00,0.00,0.00),('1','144','829','226941',4371164,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','227174',4375165,'2360','360',544031.63,551403.63,0.00,0.00,7372.00,3645100.00,0.00,0.00,0.00),('1','144','829','227174',4375166,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','227576',4382180,'2360','360',551403.63,553606.13,0.00,0.00,2202.50,1095530.00,0.00,0.00,0.00),('1','144','829','227576',4382181,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','227579',4382223,'2360','360',553606.13,553606.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','227579',4382224,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','227614',4382654,'2360','360',553606.13,558246.33,0.00,0.00,4640.20,2370294.00,0.00,0.00,0.00),('1','144','829','227614',4382655,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','227875',4387245,'2360','360',558246.33,563362.03,0.00,0.00,5115.70,2612040.00,0.00,0.00,0.00),('1','144','829','227875',4387246,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','228126',4392134,'2360','360',563362.03,567647.53,0.00,0.00,4285.50,2191560.00,0.00,0.00,0.00),('1','144','829','228126',4392135,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','228343',4396429,'2360','360',567647.53,573828.23,0.00,0.00,6180.70,3183484.00,0.00,0.00,0.00),('1','144','829','228343',4396430,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','228536',4399889,'2360','360',573828.23,578171.23,0.00,0.00,4343.00,2250580.00,0.00,0.00,0.00),('1','144','829','228536',4399890,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','228723',4403631,'2360','360',578171.23,578171.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','228723',4403632,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','228775',4404333,'2360','360',578171.23,585001.63,0.00,0.00,6830.40,3587804.00,0.00,0.00,0.00),('1','144','829','228775',4404334,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','228952',4407550,'2360','360',585001.63,589716.03,0.00,0.00,4714.40,2487064.00,0.00,0.00,0.00),('1','144','829','228952',4407551,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','229194',4412305,'2360','360',589716.03,593483.53,0.00,0.00,3767.50,2008000.00,0.00,0.00,0.00),('1','144','829','229194',4412306,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','229486',4417496,'2360','360',593483.53,597783.83,0.00,0.00,4300.30,2267852.00,0.00,0.00,0.00),('1','144','829','229486',4417497,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','229637',4420896,'2360','360',597783.83,597783.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','229637',4420897,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','230021',4428171,'2360','360',597783.83,606909.43,0.00,0.00,9125.60,4903548.80,0.00,0.00,0.00),('1','144','829','230021',4428172,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','230102',4429479,'2360','360',606909.43,611810.23,0.00,0.00,4900.80,2682220.40,0.00,0.00,0.00),('1','144','829','230102',4429480,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','230274',4432983,'2360','360',611810.23,615398.93,0.00,0.00,3588.70,1974621.60,0.00,0.00,0.00),('1','144','829','230274',4432984,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','230515',4437472,'2360','360',615398.93,621832.37,0.00,0.00,6433.44,3490933.92,0.00,0.00,0.00),('1','144','829','230515',4437473,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','230760',4441962,'2360','360',621832.37,621832.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','230760',4441963,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','230770',4442036,'2360','360',621832.37,625264.17,0.00,0.00,3431.80,1933851.20,0.00,0.00,0.00),('1','144','829','230770',4442037,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','231060',4446923,'2360','360',625264.17,628786.88,0.00,0.00,3522.71,1988513.04,0.00,0.00,0.00),('1','144','829','231060',4446924,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','231370',4451806,'2360','360',628786.88,636467.28,0.00,0.00,7680.40,4301393.60,0.00,0.00,0.00),('1','144','829','231370',4451807,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','231625',4456336,'2360','360',636467.28,639858.08,0.00,0.00,3390.80,1910347.20,0.00,0.00,0.00),('1','144','829','231625',4456337,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','231889',4461039,'2360','360',639858.08,645543.78,0.00,0.00,5685.70,3193828.80,0.00,0.00,0.00),('1','144','829','231889',4461040,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','232097',4464859,'2360','360',645543.78,646445.38,0.00,0.00,901.60,512374.40,0.00,0.00,0.00),('1','144','829','232097',4464860,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','232299',4468524,'2360','360',646445.38,646445.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','232299',4468525,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','232323',4468842,'2360','360',646445.38,651549.48,0.00,0.00,5104.10,2875050.40,0.00,0.00,0.00),('1','144','829','232323',4468843,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','232575',4473554,'2360','360',651549.48,657711.38,0.00,0.00,6161.90,3456441.60,0.00,0.00,0.00),('1','144','829','232575',4473555,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','232874',4478532,'2360','360',657711.38,661715.48,0.00,0.00,4004.10,2258454.40,0.00,0.00,0.00),('1','144','829','232874',4478533,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','233103',4482925,'2360','360',661715.48,664787.28,0.00,0.00,3071.80,1721871.20,0.00,0.00,0.00),('1','144','829','233103',4482926,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','233360',4487589,'2360','360',664787.28,671087.28,0.00,0.00,6300.00,3589683.00,0.00,0.00,0.00),('1','144','829','233360',4487590,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','233562',4491386,'2360','360',671087.28,671087.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','233562',4491387,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','233584',4491839,'2360','360',671087.28,675705.28,0.00,0.00,4618.00,2677095.00,0.00,0.00,0.00),('1','144','829','233584',4491840,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','233827',4496053,'2360','360',675705.28,682303.88,0.00,0.00,6598.60,3946676.40,0.00,0.00,0.00),('1','144','829','233827',4496054,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','234045',4499812,'2360','360',682303.88,685624.38,0.00,0.00,3320.50,2002737.00,0.00,0.00,0.00),('1','144','829','234045',4499813,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','234295',4504535,'2360','360',685624.38,689241.78,0.00,0.00,3617.40,2175037.60,0.00,0.00,0.00),('1','144','829','234295',4504536,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','234602',4509733,'2360','360',689241.78,691807.69,0.00,0.00,2565.91,1553441.64,0.00,0.00,0.00),('1','144','829','234602',4509734,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','234811',4513656,'2360','360',691807.69,695671.19,0.00,0.00,3863.50,2311851.00,0.00,0.00,0.00),('1','144','829','234811',4513657,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','235026',4517556,'2360','360',695671.19,695671.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','235026',4517557,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','235052',4518019,'2360','360',695671.19,701589.59,0.00,0.00,5918.40,3533186.60,0.00,0.00,0.00),('1','144','829','235052',4518020,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','235314',4522315,'2360','360',701589.59,705754.89,0.00,0.00,4165.30,2510137.20,0.00,0.00,0.00),('1','144','829','235314',4522316,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','235544',4526388,'2360','360',705754.89,711422.29,0.00,0.00,5667.40,3395959.60,0.00,0.00,0.00),('1','144','829','235544',4526389,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','235750',4530113,'2360','360',711422.29,713788.99,0.00,0.00,2366.70,1431620.80,0.00,0.00,0.00),('1','144','829','235750',4530114,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','236425',4542076,'2360','360',713788.99,717597.19,0.00,0.00,3808.20,2288166.80,0.00,0.00,0.00),('1','144','829','236425',4542077,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','236431',4542167,'2360','360',717597.19,720243.29,0.00,0.00,2646.10,1603692.60,0.00,0.00,0.00),('1','144','829','236431',4542168,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','236450',4542513,'2360','360',720243.29,720243.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','236450',4542514,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','236491',4543267,'2360','360',720243.29,729624.49,0.00,0.00,9381.20,5589712.60,0.00,0.00,0.00),('1','144','829','236491',4543268,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','236716',4547017,'2360','360',729624.49,734289.69,0.00,0.00,4665.20,2809859.70,0.00,0.00,0.00),('1','144','829','236716',4547018,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','236942',4551049,'2360','360',734289.69,740993.29,0.00,0.00,6703.60,4133936.00,0.00,0.00,0.00),('1','144','829','236942',4551050,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','237160',4554854,'2360','360',740993.29,744805.19,0.00,0.00,3811.90,2366336.00,0.00,0.00,0.00),('1','144','829','237160',4554855,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','237339',4558202,'2360','360',744805.19,744805.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','237339',4558203,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','237376',4558714,'2360','360',744805.19,752882.69,0.00,0.00,8077.50,4950662.00,0.00,0.00,0.00),('1','144','829','237376',4558715,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','237605',4562770,'2360','360',752882.69,757356.38,0.00,0.00,4473.69,2835225.60,0.00,0.00,0.00),('1','144','829','237605',4562771,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','237859',4567029,'2360','360',757356.38,763999.56,0.00,0.00,6643.18,4311451.56,0.00,0.00,0.00),('1','144','829','237859',4567030,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','238099',4570967,'2360','360',763999.56,769329.52,0.00,0.00,5329.96,3487467.12,0.00,0.00,0.00),('1','144','829','238099',4570968,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','238308',4574541,'2360','360',769329.52,769329.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','238308',4574542,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','238340',4575154,'2360','360',769329.52,772664.32,0.00,0.00,3334.80,2182145.60,0.00,0.00,0.00),('1','144','829','238340',4575155,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','238588',4579287,'2360','360',772664.32,778690.32,0.00,0.00,6026.00,3918752.00,0.00,0.00,0.00),('1','144','829','238588',4579288,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','238814',4583274,'2360','360',778690.32,781058.72,0.00,0.00,2368.40,1567061.80,0.00,0.00,0.00),('1','144','829','238814',4583275,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','239088',4587921,'2360','360',781058.72,786822.93,0.00,0.00,5764.21,3735131.94,0.00,0.00,0.00),('1','144','829','239088',4587922,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','239309',4591736,'2360','360',786822.93,791883.64,0.00,0.00,5060.71,3283481.12,0.00,0.00,0.00),('1','144','829','239309',4591737,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','239521',4595448,'2360','360',791883.64,793702.01,0.00,0.00,1818.37,1195944.64,0.00,0.00,0.00),('1','144','829','239521',4595449,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','239719',4599032,'2360','360',793702.01,793702.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','239719',4599033,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','239769',4599707,'2360','360',793702.01,801409.52,0.00,0.00,7707.51,4980136.72,0.00,0.00,0.00),('1','144','829','239769',4599708,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','239988',4603551,'2360','360',801409.52,806339.32,0.00,0.00,4929.80,3193125.60,0.00,0.00,0.00),('1','144','829','239988',4603552,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','240191',4607122,'2360','360',806339.32,808098.22,0.00,0.00,1758.90,1155460.80,0.00,0.00,0.00),('1','144','829','240191',4607123,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','240448',4611268,'2360','360',808098.22,810044.55,0.00,0.00,1946.33,1283493.76,0.00,0.00,0.00),('1','144','829','240448',4611269,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','240688',4614922,'2360','360',810044.55,814591.12,0.00,0.00,4546.57,2887971.20,0.00,0.00,0.00),('1','144','829','240688',4614923,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','240966',4619937,'2360','360',814591.12,818261.32,0.00,0.00,3670.20,2332301.20,0.00,0.00,0.00),('1','144','829','240966',4619938,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','241170',4623698,'2360','360',818261.32,818261.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','241170',4623699,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','241217',4624451,'2360','360',818261.32,822450.12,0.00,0.00,4188.80,2662912.80,0.00,0.00,0.00),('1','144','829','241217',4624452,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','241585',4630679,'2360','360',822450.12,824851.27,0.00,0.00,2401.15,1546554.40,0.00,0.00,0.00),('1','144','829','241585',4630680,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','241721',4633176,'2360','360',824851.27,828969.07,0.00,0.00,4117.80,2608376.80,0.00,0.00,0.00),('1','144','829','241721',4633177,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','241982',4637481,'2360','360',828969.07,831393.97,0.00,0.00,2424.90,1559694.40,0.00,0.00,0.00),('1','144','829','241982',4637482,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','242187',4641382,'2360','360',831393.97,837966.15,0.00,0.00,6572.18,4164029.68,0.00,0.00,0.00),('1','144','829','242187',4641383,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','242425',4645386,'2360','360',837966.15,840337.75,0.00,0.00,2371.60,1524725.60,0.00,0.00,0.00),('1','144','829','242425',4645387,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','242654',4649554,'2360','360',840337.75,842598.05,0.00,0.00,2260.30,1449996.80,0.00,0.00,0.00),('1','144','829','242654',4649555,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','242859',4652846,'2360','360',842598.05,842598.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','242859',4652847,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','242913',4653760,'2360','360',842598.05,848872.35,0.00,0.00,6274.30,3957628.80,0.00,0.00,0.00),('1','144','829','242913',4653761,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','243122',4657574,'2360','360',848872.35,854317.65,0.00,0.00,5445.30,3446496.80,0.00,0.00,0.00),('1','144','829','243122',4657575,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','243361',4661782,'2360','360',854317.65,856378.15,0.00,0.00,2060.50,1324648.00,0.00,0.00,0.00),('1','144','829','243361',4661783,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','243594',4665721,'2360','360',856378.15,858552.05,0.00,0.00,2173.90,1365496.00,0.00,0.00,0.00),('1','144','829','243594',4665722,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','243824',4669805,'2360','360',858552.05,861058.52,0.00,0.00,2506.47,1571567.70,0.00,0.00,0.00),('1','144','829','243824',4669806,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','244046',4673613,'2360','360',861058.52,862958.06,0.00,0.00,1899.54,1193955.60,0.00,0.00,0.00),('1','144','829','244046',4673614,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','244293',4677730,'2360','360',862958.06,867266.16,0.00,0.00,4308.10,2651609.00,0.00,0.00,0.00),('1','144','829','244293',4677731,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','244468',4680959,'2360','360',867266.16,867266.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','244468',4680960,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','244518',4681715,'2360','360',867266.16,869521.16,0.00,0.00,2255.00,1409750.00,0.00,0.00,0.00),('1','144','829','244518',4681716,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','244748',4685494,'2360','360',869521.16,872921.86,0.00,0.00,3400.70,2099948.00,0.00,0.00,0.00),('1','144','829','244748',4685495,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','244971',4689561,'2360','360',872921.86,874830.96,0.00,0.00,1909.10,1187804.00,0.00,0.00,0.00),('1','144','829','244971',4689562,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','245216',4693862,'2360','360',874830.96,881035.16,0.00,0.00,6204.20,3801988.00,0.00,0.00,0.00),('1','144','829','245216',4693863,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','245430',4697629,'2360','360',881035.16,883052.96,0.00,0.00,2017.80,1272192.00,0.00,0.00,0.00),('1','144','829','245430',4697630,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','245676',4701848,'2360','360',883052.96,887854.26,0.00,0.00,4801.30,2959202.00,0.00,0.00,0.00),('1','144','829','245676',4701849,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','245982',4706438,'2360','360',887854.26,891864.36,0.00,0.00,4010.10,2375821.60,0.00,0.00,0.00),('1','144','829','245982',4706439,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','246139',4709397,'2360','360',891864.36,891864.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','246139',4709398,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','246183',4710030,'2360','360',891864.36,895666.76,0.00,0.00,3802.40,2234878.40,0.00,0.00,0.00),('1','144','829','246183',4710031,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','246452',4714488,'2360','360',895666.76,900999.06,0.00,0.00,5332.30,3115296.80,0.00,0.00,0.00),('1','144','829','246452',4714489,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','246696',4718729,'2360','360',900999.06,902597.36,0.00,0.00,1598.30,965832.80,0.00,0.00,0.00),('1','144','829','246696',4718730,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','246930',4722986,'2360','360',902597.36,909870.86,0.00,0.00,7273.50,4236196.00,0.00,0.00,0.00),('1','144','829','246930',4722987,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','247164',4726887,'2360','360',909870.86,912553.36,0.00,0.00,2682.50,1602740.00,0.00,0.00,0.00),('1','144','829','247164',4726888,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','247391',4730984,'2360','360',912553.36,916742.66,0.00,0.00,4189.30,2470008.80,0.00,0.00,0.00),('1','144','829','247391',4730985,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','247604',4734460,'2360','360',916742.66,916742.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','247604',4734461,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','247661',4735465,'2360','360',916742.66,919266.46,0.00,0.00,2523.80,1506780.80,0.00,0.00,0.00),('1','144','829','247661',4735466,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','247910',4739626,'2360','360',919266.46,924022.56,0.00,0.00,4756.10,2795857.60,0.00,0.00,0.00),('1','144','829','247910',4739627,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','248149',4743756,'2360','360',924022.56,926781.76,0.00,0.00,2759.20,1651931.20,0.00,0.00,0.00),('1','144','829','248149',4743757,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','248393',4747917,'2360','360',926781.76,933587.66,0.00,0.00,6805.90,3993234.40,0.00,0.00,0.00),('1','144','829','248393',4747918,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','248635',4751918,'2360','360',933587.66,935878.76,0.00,0.00,2291.10,1373067.60,0.00,0.00,0.00),('1','144','829','248635',4751919,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','248864',4755827,'2360','360',935878.76,941416.93,0.00,0.00,5538.17,3135158.00,0.00,0.00,0.00),('1','144','829','248864',4755828,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','249055',4759132,'2360','360',941416.93,941416.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','249055',4759133,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','249103',4759838,'2360','360',941416.93,944269.93,0.00,0.00,2853.00,1638037.60,0.00,0.00,0.00),('1','144','829','249103',4759839,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','249338',4763880,'2360','360',944269.93,946903.33,0.00,0.00,2633.40,1519256.00,0.00,0.00,0.00),('1','144','829','249338',4763881,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','249583',4767998,'2360','360',946903.33,951097.03,0.00,0.00,4193.70,2378860.00,0.00,0.00,0.00),('1','144','829','249583',4767999,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','249849',4772485,'2360','360',951097.03,955876.23,0.00,0.00,4779.20,2710560.00,0.00,0.00,0.00),('1','144','829','249849',4772486,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','250093',4776525,'2360','360',955876.23,957980.43,0.00,0.00,2104.20,1221520.00,0.00,0.00,0.00),('1','144','829','250093',4776526,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','250330',4780595,'2360','360',957980.43,960557.83,0.00,0.00,2577.40,1492840.00,0.00,0.00,0.00),('1','144','829','250330',4780596,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','250559',4784344,'2360','360',960557.83,966081.23,0.00,0.00,5523.40,3137040.00,0.00,0.00,0.00),('1','144','829','250559',4784345,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','250745',4787657,'2360','360',966081.23,966081.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','250745',4787658,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','250792',4788408,'2360','360',966081.23,968482.13,0.00,0.00,2400.90,1394540.00,0.00,0.00,0.00),('1','144','829','250792',4788409,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','251032',4792637,'2360','360',968482.13,971591.83,0.00,0.00,3109.70,1786500.00,0.00,0.00,0.00),('1','144','829','251032',4792638,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','251267',4796765,'2360','360',971591.83,974092.78,0.00,0.00,2500.95,1453356.00,0.00,0.00,0.00),('1','144','829','251267',4796766,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','251513',4800889,'2360','360',974092.78,976340.68,0.00,0.00,2247.90,1302740.00,0.00,0.00,0.00),('1','144','829','251513',4800890,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','251753',4805317,'2360','360',976340.68,981638.48,0.00,0.00,5297.80,2999740.00,0.00,0.00,0.00),('1','144','829','251753',4805318,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','251985',4809289,'2360','360',981638.48,984211.38,0.00,0.00,2572.90,1487240.00,0.00,0.00,0.00),('1','144','829','251985',4809290,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','252233',4813530,'2360','360',984211.38,987748.38,0.00,0.00,3537.00,2030600.00,0.00,0.00,0.00),('1','144','829','252233',4813531,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','252474',4817933,'2360','360',987748.38,990614.56,0.00,0.00,2866.18,1657948.00,0.00,0.00,0.00),('1','144','829','252474',4817934,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','252661',4821184,'2360','360',990614.56,990614.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','252661',4821185,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','252708',4821955,'2360','360',990614.56,993860.63,0.00,0.00,3246.07,1874122.00,0.00,0.00,0.00),('1','144','829','252708',4821956,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','252963',4826062,'2360','360',993860.63,998585.73,0.00,0.00,4725.10,2684200.00,0.00,0.00,0.00),('1','144','829','252963',4826063,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','253195',4830167,'2360','360',998585.73,1004434.66,0.00,0.00,5848.93,3320758.00,0.00,0.00,0.00),('1','144','829','253195',4830168,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','253492',4834937,'2360','360',1004434.66,1006337.26,0.00,0.00,1902.60,1109960.00,0.00,0.00,0.00),('1','144','829','253492',4834938,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','253708',4838758,'2360','360',1006337.26,1008904.76,0.00,0.00,2567.50,1491320.00,0.00,0.00,0.00),('1','144','829','253708',4838759,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','253961',4843073,'2360','360',1008904.76,1015184.86,0.00,0.00,6280.10,3564540.00,0.00,0.00,0.00),('1','144','829','253961',4843074,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','254150',4846728,'2360','360',1015184.86,1015184.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','254150',4846729,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','254193',4847387,'2360','360',1015184.86,1019151.16,0.00,0.00,3966.30,2256220.00,0.00,0.00,0.00),('1','144','829','254193',4847388,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','254448',4851726,'2360','360',1019151.16,1022622.96,0.00,0.00,3471.80,1994840.00,0.00,0.00,0.00),('1','144','829','254448',4851727,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','254756',4856729,'2360','360',1022622.96,1025784.76,0.00,0.00,3161.80,1816112.00,0.00,0.00,0.00),('1','144','829','254756',4856730,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','254953',4860350,'2360','360',1025784.76,1034970.66,0.00,0.00,9185.90,5155336.00,0.00,0.00,0.00),('1','144','829','254953',4860351,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','255196',4864543,'2360','360',1034970.66,1037436.16,0.00,0.00,2465.50,1424700.00,0.00,0.00,0.00),('1','144','829','255196',4864544,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','255467',4869150,'2360','360',1037436.16,1039780.86,0.00,0.00,2344.70,1361220.00,0.00,0.00,0.00),('1','144','829','255467',4869151,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','255667',4872607,'2360','360',1039780.86,1039780.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','255667',4872608,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','255710',4873229,'2360','360',1039780.86,1042191.26,0.00,0.00,2410.40,1401840.00,0.00,0.00,0.00),('1','144','829','255710',4873230,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','255952',4877065,'2360','360',1042191.26,1048677.76,0.00,0.00,6486.50,3643000.00,0.00,0.00,0.00),('1','144','829','255952',4877066,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','256382',4884218,'2360','360',1048677.76,1051759.40,0.00,0.00,3081.64,1750544.00,0.00,0.00,0.00),('1','144','829','256382',4884219,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','256492',4886099,'2360','360',1051759.40,1056176.15,0.00,0.00,4416.75,2514386.00,0.00,0.00,0.00),('1','144','829','256492',4886100,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','256730',4889976,'2360','360',1056176.15,1063836.89,0.00,0.00,7660.74,4346988.40,0.00,0.00,0.00),('1','144','829','256730',4889977,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','256916',4893425,'2360','360',1063836.89,1063836.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','256916',4893426,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','256969',4894161,'2360','360',1063836.89,1067117.59,0.00,0.00,3280.70,1885964.00,0.00,0.00,0.00),('1','144','829','256969',4894162,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257243',4899165,'2360','360',1067117.59,1070139.09,0.00,0.00,3021.50,1756372.00,0.00,0.00,0.00),('1','144','829','257243',4899166,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257499',4903593,'2360','360',1070139.09,1073007.07,0.00,0.00,2867.98,1678256.80,0.00,0.00,0.00),('1','144','829','257499',4903594,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257500',4903595,'2360','360',1073007.07,1076237.71,0.00,0.00,3230.64,1852420.40,0.00,0.00,0.00),('1','144','829','257500',4903596,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257501',4903597,'2360','360',1076237.71,1082899.61,0.00,0.00,6661.90,3774820.00,0.00,0.00,0.00),('1','144','829','257501',4903598,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257502',4903599,'2360','360',1082899.61,1085968.21,0.00,0.00,3068.60,1770280.00,0.00,0.00,0.00),('1','144','829','257502',4903600,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257503',4903601,'2360','360',1085968.21,1088431.46,0.00,0.00,2463.25,1440350.00,0.00,0.00,0.00),('1','144','829','257503',4903602,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257504',4903603,'2360','360',1088431.46,1088431.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257504',4903604,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257505',4903605,'2360','360',1088431.46,1096599.56,0.00,0.00,8168.10,4591288.00,0.00,0.00,0.00),('1','144','829','257505',4903606,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257506',4903607,'2360','360',1096599.56,1099786.16,0.00,0.00,3186.60,1845960.00,0.00,0.00,0.00),('1','144','829','257506',4903608,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257507',4903609,'2360','360',1099786.16,1105100.06,0.00,0.00,5313.90,3024740.00,0.00,0.00,0.00),('1','144','829','257507',4903610,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257508',4903611,'2360','360',1105100.06,1107923.86,0.00,0.00,2823.80,1626680.00,0.00,0.00,0.00),('1','144','829','257508',4903612,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257509',4903613,'2360','360',1107923.86,1113083.86,0.00,0.00,5160.00,2928180.40,0.00,0.00,0.00),('1','144','829','257509',4903614,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257510',4903615,'2360','360',1113083.86,1113083.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257510',4903616,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257511',4903617,'2360','360',1113083.86,1115042.46,0.00,0.00,1958.60,1140420.00,0.00,0.00,0.00),('1','144','829','257511',4903618,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257512',4903619,'2360','360',1115042.46,1117844.86,0.00,0.00,2802.40,1605240.00,0.00,0.00,0.00),('1','144','829','257512',4903620,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257513',4903621,'2360','360',1117844.86,1119842.86,0.00,0.00,1998.00,1161520.00,0.00,0.00,0.00),('1','144','829','257513',4903622,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257514',4903623,'2360','360',1119842.86,1125331.86,0.00,0.00,5489.00,3113220.00,0.00,0.00,0.00),('1','144','829','257514',4903624,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257515',4903625,'2360','360',1125331.86,1131005.76,0.00,0.00,5673.90,3216030.00,0.00,0.00,0.00),('1','144','829','257515',4903626,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257516',4903627,'2360','360',1131005.76,1133018.66,0.00,0.00,2012.90,1172140.00,0.00,0.00,0.00),('1','144','829','257516',4903628,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257517',4903629,'2360','360',1133018.66,1137730.16,0.00,0.00,4711.50,2669100.00,0.00,0.00,0.00),('1','144','829','257517',4903630,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257518',4903631,'2360','360',1137730.16,1137730.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257518',4903632,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257519',4903633,'2360','360',1137730.16,1141414.15,0.00,0.00,3683.99,2094597.24,0.00,0.00,0.00),('1','144','829','257519',4903634,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257520',4903635,'2360','360',1141414.15,1146281.55,0.00,0.00,4867.40,2759760.00,0.00,0.00,0.00),('1','144','829','257520',4903636,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257521',4903637,'2360','360',1146281.55,1147715.70,0.00,0.00,1434.15,836890.00,0.00,0.00,0.00),('1','144','829','257521',4903638,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257522',4903639,'2360','360',1147715.70,1150636.50,0.00,0.00,2920.80,1637664.00,0.00,0.00,0.00),('1','144','829','257522',4903640,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257523',4903641,'2360','360',1150636.50,1156055.80,0.00,0.00,5419.30,3003644.00,0.00,0.00,0.00),('1','144','829','257523',4903642,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257524',4903643,'2360','360',1156055.80,1158496.50,0.00,0.00,2440.70,1377716.00,0.00,0.00,0.00),('1','144','829','257524',4903644,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257525',4903645,'2360','360',1158496.50,1162318.20,0.00,0.00,3821.70,2127286.00,0.00,0.00,0.00),('1','144','829','257525',4903646,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257526',4903647,'2360','360',1162318.20,1162318.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257526',4903648,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257527',4903649,'2360','360',1162318.20,1164496.70,0.00,0.00,2178.50,1231130.00,0.00,0.00,0.00),('1','144','829','257527',4903650,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257528',4903651,'2360','360',1164496.70,1166114.10,0.00,0.00,1617.40,923092.00,0.00,0.00,0.00),('1','144','829','257528',4903652,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257529',4903653,'2360','360',1166114.10,1168317.30,0.00,0.00,2203.20,1245186.00,0.00,0.00,0.00),('1','144','829','257529',4903654,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257530',4903655,'2360','360',1168317.30,1172976.80,0.00,0.00,4659.50,2586635.00,0.00,0.00,0.00),('1','144','829','257530',4903656,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257531',4903657,'2360','360',1172976.80,1175127.60,0.00,0.00,2150.80,1232267.20,0.00,0.00,0.00),('1','144','829','257531',4903658,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257532',4903659,'2360','360',1175127.60,1177082.30,0.00,0.00,1954.70,1119424.80,0.00,0.00,0.00),('1','144','829','257532',4903660,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257533',4903661,'2360','360',1177082.30,1182591.90,0.00,0.00,5509.60,3076646.40,0.00,0.00,0.00),('1','144','829','257533',4903662,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257534',4903663,'2360','360',1182591.90,1186827.50,0.00,0.00,4235.60,2379570.40,0.00,0.00,0.00),('1','144','829','257534',4903664,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257535',4903665,'2360','360',1186827.50,1186827.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257535',4903666,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257536',4903667,'2360','360',1186827.50,1189856.70,0.00,0.00,3029.20,1714540.80,0.00,0.00,0.00),('1','144','829','257536',4903668,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257537',4903669,'2360','360',1189856.70,1192724.30,0.00,0.00,2867.60,1629878.40,0.00,0.00,0.00),('1','144','829','257537',4903670,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257538',4903671,'2360','360',1192724.30,1197788.50,0.00,0.00,5064.20,2840932.80,0.00,0.00,0.00),('1','144','829','257538',4903672,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257539',4903673,'2360','360',1197788.50,1200720.70,0.00,0.00,2932.20,1675892.80,0.00,0.00,0.00),('1','144','829','257539',4903674,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257540',4903675,'2360','360',1200720.70,1203985.60,0.00,0.00,3264.90,1843301.60,0.00,0.00,0.00),('1','144','829','257540',4903676,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257541',4903677,'2360','360',1203985.60,1211191.80,0.00,0.00,7206.20,4019580.80,0.00,0.00,0.00),('1','144','829','257541',4903678,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257542',4903679,'2360','360',1211191.80,1211191.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257542',4903680,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257543',4903681,'2360','360',1211191.80,1213055.41,0.00,0.00,1863.61,1170193.98,0.00,0.00,0.00),('1','144','829','257543',4903682,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257544',4903683,'2360','360',1213055.41,1214373.51,0.00,0.00,1318.10,849765.00,0.00,0.00,0.00),('1','144','829','257544',4903684,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257545',4903685,'2360','360',1214373.51,1216948.11,0.00,0.00,2574.60,1644490.00,0.00,0.00,0.00),('1','144','829','257545',4903686,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257546',4903687,'2360','360',1216948.11,1220130.01,0.00,0.00,3181.90,2022355.00,0.00,0.00,0.00),('1','144','829','257546',4903688,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257547',4903689,'2360','360',1220130.01,1222621.21,0.00,0.00,2491.20,1595180.00,0.00,0.00,0.00),('1','144','829','257547',4903690,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257548',4903691,'2360','360',1222621.21,1224503.56,0.00,0.00,1882.35,1211950.50,0.00,0.00,0.00),('1','144','829','257548',4903692,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257549',4903693,'2360','360',1224503.56,1231020.86,0.00,0.00,6517.30,4158524.00,0.00,0.00,0.00),('1','144','829','257549',4903694,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257550',4903695,'2360','360',1231020.86,1235769.56,0.00,0.00,4748.70,3106316.00,0.00,0.00,0.00),('1','144','829','257550',4903696,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257551',4903697,'2360','360',1235769.56,1235769.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257551',4903698,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257552',4903699,'2360','360',1235769.56,1238244.06,0.00,0.00,2474.50,1635760.00,0.00,0.00,0.00),('1','144','829','257552',4903700,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257553',4903701,'2360','360',1238244.06,1242345.46,0.00,0.00,4101.40,2687682.00,0.00,0.00,0.00),('1','144','829','257553',4903702,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257554',4903703,'2360','360',1242345.46,1244152.96,0.00,0.00,1807.50,1209600.00,0.00,0.00,0.00),('1','144','829','257554',4903704,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257555',4903705,'2360','360',1244152.96,1247088.56,0.00,0.00,2935.60,1959233.00,0.00,0.00,0.00),('1','144','829','257555',4903706,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257556',4903707,'2360','360',1247088.56,1249886.06,0.00,0.00,2797.50,1844500.00,0.00,0.00,0.00),('1','144','829','257556',4903708,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257557',4903709,'2360','360',1249886.06,1257573.76,0.00,0.00,7687.70,4939986.00,0.00,0.00,0.00),('1','144','829','257557',4903710,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257558',4903711,'2360','360',1257573.76,1260246.13,0.00,0.00,2672.37,1748736.80,0.00,0.00,0.00),('1','144','829','257558',4903712,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257559',4903713,'2360','360',1260246.13,1260686.81,0.00,0.00,440.68,299662.40,0.00,0.00,0.00),('1','144','829','257559',4903714,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257560',4903715,'2360','360',1260686.81,1262660.41,0.00,0.00,1973.60,1283091.00,0.00,0.00,0.00),('1','144','829','257560',4903716,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257561',4903717,'2360','360',1262660.41,1264600.61,0.00,0.00,1940.20,1257732.00,0.00,0.00,0.00),('1','144','829','257561',4903718,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257562',4903719,'2360','360',1264600.61,1266573.71,0.00,0.00,1973.10,1284246.00,0.00,0.00,0.00),('1','144','829','257562',4903720,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257563',4903721,'2360','360',1266573.71,1274932.31,0.00,0.00,8358.60,5293276.00,0.00,0.00,0.00),('1','144','829','257563',4903722,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257564',4903723,'2360','360',1274932.31,1277209.51,0.00,0.00,2277.20,1504124.00,0.00,0.00,0.00),('1','144','829','257564',4903724,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257565',4903725,'2360','360',1277209.51,1280067.41,0.00,0.00,2857.90,1874993.00,0.00,0.00,0.00),('1','144','829','257565',4903726,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257566',4903727,'2360','360',1280067.41,1284562.31,0.00,0.00,4494.90,2942983.00,0.00,0.00,0.00),('1','144','829','257566',4903728,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257567',4903729,'2360','360',1284562.31,1284562.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257567',4903730,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257568',4903731,'2360','360',1284562.31,1289942.21,0.00,0.00,5379.90,3535313.00,0.00,0.00,0.00),('1','144','829','257568',4903732,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257569',4903733,'2360','360',1289942.21,1294920.81,0.00,0.00,4978.60,3296164.00,0.00,0.00,0.00),('1','144','829','257569',4903734,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257570',4903735,'2360','360',1294920.81,1301282.11,0.00,0.00,6361.30,4169011.00,0.00,0.00,0.00),('1','144','829','257570',4903736,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257571',4903737,'2360','360',1301282.11,1309183.01,0.00,0.00,7900.90,5137203.00,0.00,0.00,0.00),('1','144','829','257571',4903738,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257572',4903739,'2360','360',1309183.01,1309183.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257572',4903740,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257573',4903741,'2360','360',1309183.01,1312758.07,0.00,0.00,3575.06,2342360.20,0.00,0.00,0.00),('1','144','829','257573',4903742,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257574',4903743,'2360','360',1312758.07,1315062.82,0.00,0.00,2304.75,1523348.50,0.00,0.00,0.00),('1','144','829','257574',4903744,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257575',4903745,'2360','360',1315062.82,1322437.32,0.00,0.00,7374.50,4795395.00,0.00,0.00,0.00),('1','144','829','257575',4903746,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257576',4903747,'2360','360',1322437.32,1324993.42,0.00,0.00,2556.10,1683841.00,0.00,0.00,0.00),('1','144','829','257576',4903748,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257577',4903749,'2360','360',1324993.42,1327618.86,0.00,0.00,2625.44,1732019.84,0.00,0.00,0.00),('1','144','829','257577',4903750,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257578',4903751,'2360','360',1327618.86,1332617.86,0.00,0.00,4999.00,3268290.00,0.00,0.00,0.00),('1','144','829','257578',4903752,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257579',4903753,'2360','360',1332617.86,1333579.30,0.00,0.00,961.44,632964.80,0.00,0.00,0.00),('1','144','829','257579',4903754,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257580',4903755,'2360','360',1333579.30,1333579.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257580',4903756,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257581',4903757,'2360','360',1333579.30,1339203.20,0.00,0.00,5623.90,3648713.00,0.00,0.00,0.00),('1','144','829','257581',4903758,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257582',4903759,'2360','360',1339203.20,1341306.00,0.00,0.00,2102.80,1383562.00,0.00,0.00,0.00),('1','144','829','257582',4903760,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257583',4903761,'2360','360',1341306.00,1344200.70,0.00,0.00,2894.70,1901229.00,0.00,0.00,0.00),('1','144','829','257583',4903762,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257584',4903763,'2360','360',1344200.70,1348015.60,0.00,0.00,3814.90,2495183.00,0.00,0.00,0.00),('1','144','829','257584',4903764,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257585',4903765,'2360','360',1348015.60,1350097.71,0.00,0.00,2082.11,1372880.66,0.00,0.00,0.00),('1','144','829','257585',4903766,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257586',4903767,'2360','360',1350097.71,1355426.31,0.00,0.00,5328.60,3476142.00,0.00,0.00,0.00),('1','144','829','257586',4903768,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257587',4903769,'2360','360',1355426.31,1358166.11,0.00,0.00,2739.80,1803716.00,0.00,0.00,0.00),('1','144','829','257587',4903770,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257588',4903771,'2360','360',1358166.11,1358166.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257588',4903772,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257589',4903773,'2360','360',1358166.11,1359532.81,0.00,0.00,1366.70,906549.00,0.00,0.00,0.00),('1','144','829','257589',4903774,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257590',4903775,'2360','360',1359532.81,1361035.60,0.00,0.00,1502.79,995629.30,0.00,0.00,0.00),('1','144','829','257590',4903776,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257591',4903777,'2360','360',1361035.60,1366596.60,0.00,0.00,5561.00,3626000.00,0.00,0.00,0.00),('1','144','829','257591',4903778,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257592',4903779,'2360','360',1366596.60,1368262.80,0.00,0.00,1666.20,1104354.00,0.00,0.00,0.00),('1','144','829','257592',4903780,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257593',4903781,'2360','360',1368262.80,1373144.10,0.00,0.00,4881.30,3180031.00,0.00,0.00,0.00),('1','144','829','257593',4903782,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257594',4903783,'2360','360',1373144.10,1375182.90,0.00,0.00,2038.80,1351396.00,0.00,0.00,0.00),('1','144','829','257594',4903784,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257595',4903785,'2360','360',1375182.90,1377609.47,0.00,0.00,2426.57,1599091.90,0.00,0.00,0.00),('1','144','829','257595',4903786,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257596',4903787,'2360','360',1377609.47,1380851.65,0.00,0.00,3242.18,2117200.60,0.00,0.00,0.00),('1','144','829','257596',4903788,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257597',4903789,'2360','360',1380851.65,1382856.35,0.00,0.00,2004.70,1313909.00,0.00,0.00,0.00),('1','144','829','257597',4903790,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257598',4903791,'2360','360',1382856.35,1382856.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257598',4903792,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257599',4903793,'2360','360',1382856.35,1385455.75,0.00,0.00,2599.40,1715998.00,0.00,0.00,0.00),('1','144','829','257599',4903794,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257600',4903795,'2360','360',1385455.75,1391802.52,0.00,0.00,6346.77,4134159.90,0.00,0.00,0.00),('1','144','829','257600',4903796,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257601',4903797,'2360','360',1391802.52,1394687.49,0.00,0.00,2884.97,1903529.90,0.00,0.00,0.00),('1','144','829','257601',4903798,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257602',4903799,'2360','360',1394687.49,1397838.89,0.00,0.00,3151.40,2078806.00,0.00,0.00,0.00),('1','144','829','257602',4903800,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257603',4903801,'2360','360',1397838.89,1402787.82,0.00,0.00,4948.93,3222563.10,0.00,0.00,0.00),('1','144','829','257603',4903802,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257604',4903803,'2360','360',1402787.82,1404790.95,0.00,0.00,2003.13,1328097.10,0.00,0.00,0.00),('1','144','829','257604',4903804,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257605',4903805,'2360','360',1404790.95,1407450.94,0.00,0.00,2659.99,1747240.30,0.00,0.00,0.00),('1','144','829','257605',4903806,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257606',4903807,'2360','360',1407450.94,1407450.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257606',4903808,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257607',4903809,'2360','360',1407450.94,1410591.00,0.00,0.00,3140.06,2055448.20,0.00,0.00,0.00),('1','144','829','257607',4903810,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257608',4903811,'2360','360',1410591.00,1415435.44,0.00,0.00,4844.44,3165200.80,0.00,0.00,0.00),('1','144','829','257608',4903812,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257609',4903813,'2360','360',1415435.44,1421459.06,0.00,0.00,6023.62,3929925.40,0.00,0.00,0.00),('1','144','829','257609',4903814,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257610',4903815,'2360','360',1421459.06,1424799.46,0.00,0.00,3340.40,2212748.00,0.00,0.00,0.00),('1','144','829','257610',4903816,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257611',4903817,'2360','360',1424799.46,1428636.68,0.00,0.00,3837.22,2519737.40,0.00,0.00,0.00),('1','144','829','257611',4903818,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257612',4903819,'2360','360',1428636.68,1432074.16,0.00,0.00,3437.48,2265117.40,0.00,0.00,0.00),('1','144','829','257612',4903820,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257613',4903821,'2360','360',1432074.16,1432074.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257613',4903822,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257614',4903823,'2360','360',1432074.16,1434875.99,0.00,0.00,2801.83,1839063.30,0.00,0.00,0.00),('1','144','829','257614',4903824,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257615',4903825,'2360','360',1434875.99,1442866.95,0.00,0.00,7990.96,5194483.20,0.00,0.00,0.00),('1','144','829','257615',4903826,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257616',4903827,'2360','360',1442866.95,1445507.55,0.00,0.00,2640.60,1733102.00,0.00,0.00,0.00),('1','144','829','257616',4903828,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257617',4903829,'2360','360',1445507.55,1450219.09,0.00,0.00,4711.54,3075018.76,0.00,0.00,0.00),('1','144','829','257617',4903830,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257618',4903831,'2360','360',1450219.09,1451518.19,0.00,0.00,1299.10,930155.60,0.00,0.00,0.00),('1','144','829','257618',4903832,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257619',4903833,'2360','360',1451518.19,1453546.69,0.00,0.00,2028.50,1370806.00,0.00,0.00,0.00),('1','144','829','257619',4903834,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257620',4903835,'2360','360',1453546.69,1454611.29,0.00,0.00,1064.60,731673.60,0.00,0.00,0.00),('1','144','829','257620',4903836,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257621',4903837,'2360','360',1454611.29,1454729.79,0.00,0.00,118.50,84846.00,0.00,0.00,0.00),('1','144','829','257621',4903838,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257622',4903839,'2360','360',1454729.79,1454729.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257622',4903840,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257623',4903841,'2360','360',1454729.79,1455619.79,0.00,0.00,890.00,553580.00,0.00,0.00,0.00),('1','144','829','257623',4903842,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257624',4903843,'2360','360',1455619.79,1461688.89,0.00,0.00,6069.10,4390465.00,0.00,0.00,0.00),('1','144','829','257624',4903844,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257625',4903845,'2360','360',1461688.89,1467625.92,0.00,0.00,5937.03,4299662.50,0.00,0.00,0.00),('1','144','829','257625',4903846,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257626',4903847,'2360','360',1467625.92,1471324.90,0.00,0.00,3698.98,2698095.00,0.00,0.00,0.00),('1','144','829','257626',4903848,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257627',4903849,'2360','360',1471324.90,1474449.45,0.00,0.00,3124.55,2291962.50,0.00,0.00,0.00),('1','144','829','257627',4903850,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257628',4903851,'2360','360',1474449.45,1479791.49,0.00,0.00,5342.04,3878630.00,0.00,0.00,0.00),('1','144','829','257628',4903852,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257629',4903853,'2360','360',1479791.49,1479791.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257629',4903854,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257630',4903855,'2360','360',1479791.49,1483490.47,0.00,0.00,3698.98,2693429.00,0.00,0.00,0.00),('1','144','829','257630',4903856,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257631',4903857,'2360','360',1483490.47,1486854.64,0.00,0.00,3364.17,2464157.50,0.00,0.00,0.00),('1','144','829','257631',4903858,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257632',4903859,'2360','360',1486854.64,1490324.58,0.00,0.00,3469.94,2539195.00,0.00,0.00,0.00),('1','144','829','257632',4903860,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257633',4903861,'2360','360',1490324.58,1494720.71,0.00,0.00,4396.13,3205000.70,0.00,0.00,0.00),('1','144','829','257633',4903862,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257634',4903863,'2360','360',1494720.71,1498471.49,0.00,0.00,3750.78,2750735.00,0.00,0.00,0.00),('1','144','829','257634',4903864,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257635',4903865,'2360','360',1498471.49,1504443.39,0.00,0.00,5971.90,4325371.00,0.00,0.00,0.00),('1','144','829','257635',4903866,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257636',4903867,'2360','360',1504443.39,1504443.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257636',4903868,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257637',4903869,'2360','360',1504443.39,1508839.52,0.00,0.00,4396.13,3187683.50,0.00,0.00,0.00),('1','144','829','257637',4903870,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257638',4903871,'2360','360',1508839.52,1510590.68,0.00,0.00,1751.16,1292370.00,0.00,0.00,0.00),('1','144','829','257638',4903872,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257639',4903873,'2360','360',1510590.68,1515990.71,0.00,0.00,5400.03,3902384.50,0.00,0.00,0.00),('1','144','829','257639',4903874,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257640',4903875,'2360','360',1515990.71,1518558.53,0.00,0.00,2567.82,1929499.60,0.00,0.00,0.00),('1','144','829','257640',4903876,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257641',4903877,'2360','360',1518558.53,1520864.27,0.00,0.00,2305.74,1745537.20,0.00,0.00,0.00),('1','144','829','257641',4903878,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257642',4903879,'2360','360',1520864.27,1524585.32,0.00,0.00,3721.05,2797939.00,0.00,0.00,0.00),('1','144','829','257642',4903880,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257643',4903881,'2360','360',1524585.32,1528874.83,0.00,0.00,4289.51,3219297.80,0.00,0.00,0.00),('1','144','829','257643',4903882,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257644',4903883,'2360','360',1528874.83,1528874.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257644',4903884,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257645',4903885,'2360','360',1528874.83,1535373.42,0.00,0.00,6498.59,4834674.60,0.00,0.00,0.00),('1','144','829','257645',4903886,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257646',4903887,'2360','360',1535373.42,1537585.94,0.00,0.00,2212.52,1664965.60,0.00,0.00,0.00),('1','144','829','257646',4903888,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257647',4903889,'2360','360',1537585.94,1540402.09,0.00,0.00,2816.15,2123013.00,0.00,0.00,0.00),('1','144','829','257647',4903890,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257648',4903891,'2360','360',1540402.09,1542746.75,0.00,0.00,2344.66,1791654.80,0.00,0.00,0.00),('1','144','829','257648',4903892,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257649',4903893,'2360','360',1542746.75,1545614.35,0.00,0.00,2867.60,2168648.00,0.00,0.00,0.00),('1','144','829','257649',4903894,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257650',4903895,'2360','360',1545614.35,1548376.35,0.00,0.00,2762.00,2096780.00,0.00,0.00,0.00),('1','144','829','257650',4903896,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257651',4903897,'2360','360',1548376.35,1553476.35,0.00,0.00,5100.00,3802956.00,0.00,0.00,0.00),('1','144','829','257651',4903898,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257652',4903899,'2360','360',1553476.35,1553476.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257652',4903900,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257653',4903901,'2360','360',1553476.35,1558507.08,0.00,0.00,5030.73,3758770.52,0.00,0.00,0.00),('1','144','829','257653',4903902,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257654',4903903,'2360','360',1558507.08,1561286.78,0.00,0.00,2779.70,2129146.00,0.00,0.00,0.00),('1','144','829','257654',4903904,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257655',4903905,'2360','360',1561286.78,1564284.87,0.00,0.00,2998.09,2281521.40,0.00,0.00,0.00),('1','144','829','257655',4903906,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257656',4903907,'2360','360',1564284.87,1569578.21,0.00,0.00,5293.34,3955599.20,0.00,0.00,0.00),('1','144','829','257656',4903908,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257657',4903909,'2360','360',1569578.21,1572305.60,0.00,0.00,2727.39,2069528.20,0.00,0.00,0.00),('1','144','829','257657',4903910,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257658',4903911,'2360','360',1572305.60,1577849.90,0.00,0.00,5544.30,4131013.60,0.00,0.00,0.00),('1','144','829','257658',4903912,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257659',4903913,'2360','360',1577849.90,1577849.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257659',4903914,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257660',4903915,'2360','360',1577849.90,1584402.70,0.00,0.00,6552.80,4887536.00,0.00,0.00,0.00),('1','144','829','257660',4903916,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257661',4903917,'2360','360',1584402.70,1588357.20,0.00,0.00,3954.50,2963034.00,0.00,0.00,0.00),('1','144','829','257661',4903918,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257662',4903919,'2360','360',1588357.20,1591588.56,0.00,0.00,3231.36,2440672.80,0.00,0.00,0.00),('1','144','829','257662',4903920,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257663',4903921,'2360','360',1591588.56,1594537.30,0.00,0.00,2948.74,2232229.20,0.00,0.00,0.00),('1','144','829','257663',4903922,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257664',4903923,'2360','360',1594537.30,1597953.86,0.00,0.00,3416.56,2586096.80,0.00,0.00,0.00),('1','144','829','257664',4903924,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257665',4903925,'2360','360',1597953.86,1602253.90,0.00,0.00,4300.04,3228939.88,0.00,0.00,0.00),('1','144','829','257665',4903926,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257666',4903927,'2360','360',1602253.90,1602253.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257666',4903928,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257667',4903929,'2360','360',1602253.90,1602749.65,0.00,0.00,495.75,308356.50,0.00,0.00,0.00),('1','144','829','257667',4903930,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257668',4903931,'2360','360',1602749.65,1608928.35,0.00,0.00,6178.70,4609541.32,0.00,0.00,0.00),('1','144','829','257668',4903932,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257669',4903933,'2360','360',1608928.35,1611498.12,0.00,0.00,2569.77,1950520.60,0.00,0.00,0.00),('1','144','829','257669',4903934,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257670',4903935,'2360','360',1611498.12,1616114.32,0.00,0.00,4616.20,3457336.00,0.00,0.00,0.00),('1','144','829','257670',4903936,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257671',4903937,'2360','360',1616114.32,1621044.32,0.00,0.00,4930.00,3686320.00,0.00,0.00,0.00),('1','144','829','257671',4903938,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257672',4903939,'2360','360',1621044.32,1623662.94,0.00,0.00,2618.62,1991403.60,0.00,0.00,0.00),('1','144','829','257672',4903940,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257673',4903941,'2360','360',1623662.94,1625031.17,0.00,0.00,1368.23,1053219.40,0.00,0.00,0.00),('1','144','829','257673',4903942,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257674',4903943,'2360','360',1625031.17,1627329.45,0.00,0.00,2298.28,1739698.40,0.00,0.00,0.00),('1','144','829','257674',4903944,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257675',4903945,'2360','360',1627329.45,1627329.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257675',4903946,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257676',4903947,'2360','360',1627329.45,1631349.80,0.00,0.00,4020.35,3014425.00,0.00,0.00,0.00),('1','144','829','257676',4903948,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257677',4903949,'2360','360',1631349.80,1635845.24,0.00,0.00,4495.44,3365239.20,0.00,0.00,0.00),('1','144','829','257677',4903950,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257678',4903951,'2360','360',1635845.24,1638409.93,0.00,0.00,2564.69,1942078.20,0.00,0.00,0.00),('1','144','829','257678',4903952,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257679',4903953,'2360','360',1638409.93,1640607.32,0.00,0.00,2197.39,1663276.20,0.00,0.00,0.00),('1','144','829','257679',4903954,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257680',4903955,'2360','360',1640607.32,1642601.38,0.00,0.00,1994.06,1517966.80,0.00,0.00,0.00),('1','144','829','257680',4903956,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257681',4903957,'2360','360',1642601.38,1648161.52,0.00,0.00,5560.14,4142561.20,0.00,0.00,0.00),('1','144','829','257681',4903958,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257682',4903959,'2360','360',1648161.52,1651962.28,0.00,0.00,3800.76,2862448.80,0.00,0.00,0.00),('1','144','829','257682',4903960,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257683',4903961,'2360','360',1651962.28,1651962.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257683',4903962,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257684',4903963,'2360','360',1651962.28,1657382.18,0.00,0.00,5419.90,4014198.00,0.00,0.00,0.00),('1','144','829','257684',4903964,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257685',4903965,'2360','360',1657382.18,1659517.78,0.00,0.00,2135.60,1595808.00,0.00,0.00,0.00),('1','144','829','257685',4903966,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257686',4903967,'2360','360',1659517.78,1665549.91,0.00,0.00,6032.13,4509012.20,0.00,0.00,0.00),('1','144','829','257686',4903968,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257687',4903969,'2360','360',1665549.91,1669880.68,0.00,0.00,4330.77,3247800.60,0.00,0.00,0.00),('1','144','829','257687',4903970,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257688',4903971,'2360','360',1669880.68,1673844.42,0.00,0.00,3963.74,2970557.20,0.00,0.00,0.00),('1','144','829','257688',4903972,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257689',4903973,'2360','360',1673844.42,1676973.16,0.00,0.00,3128.74,2331732.72,0.00,0.00,0.00),('1','144','829','257689',4903974,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257690',4903975,'2360','360',1676973.16,1676973.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257690',4903976,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257691',4903977,'2360','360',1676973.16,1679180.82,0.00,0.00,2207.66,1652125.68,0.00,0.00,0.00),('1','144','829','257691',4903978,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257692',4903979,'2360','360',1679180.82,1683642.95,0.00,0.00,4462.13,3351393.00,0.00,0.00,0.00),('1','144','829','257692',4903980,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257693',4903981,'2360','360',1683642.95,1686561.61,0.00,0.00,2918.66,2208234.80,0.00,0.00,0.00),('1','144','829','257693',4903982,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257694',4903983,'2360','360',1686561.61,1690936.37,0.00,0.00,4374.76,3288648.00,0.00,0.00,0.00),('1','144','829','257694',4903984,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257695',4903985,'2360','360',1690936.37,1696408.14,0.00,0.00,5471.77,4100811.40,0.00,0.00,0.00),('1','144','829','257695',4903986,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257696',4903987,'2360','360',1696408.14,1698428.02,0.00,0.00,2019.88,1545311.60,0.00,0.00,0.00),('1','144','829','257696',4903988,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257697',4903989,'2360','360',1698428.02,1699522.13,0.00,0.00,1094.11,853405.80,0.00,0.00,0.00),('1','144','829','257697',4903990,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257698',4903991,'2360','360',1699522.13,1700920.83,0.00,0.00,1398.70,1090986.00,0.00,0.00,0.00),('1','144','829','257698',4903992,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257699',4903993,'2360','360',1700920.83,1701555.04,0.00,0.00,634.21,494683.80,0.00,0.00,0.00),('1','144','829','257699',4903994,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257700',4903995,'2360','360',1701555.04,1701555.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257700',4903996,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257701',4903997,'2360','360',1701555.04,1703983.21,0.00,0.00,2428.17,1819127.00,0.00,0.00,0.00),('1','144','829','257701',4903998,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257702',4903999,'2360','360',1703983.21,1709660.07,0.00,0.00,5676.86,4268530.80,0.00,0.00,0.00),('1','144','829','257702',4904000,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257703',4904001,'2360','360',1709660.07,1713078.77,0.00,0.00,3418.70,2589986.40,0.00,0.00,0.00),('1','144','829','257703',4904002,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257704',4904003,'2360','360',1713078.77,1716027.59,0.00,0.00,2948.82,2235471.60,0.00,0.00,0.00),('1','144','829','257704',4904004,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257705',4904005,'2360','360',1716027.59,1719707.07,0.00,0.00,3679.48,2784165.60,0.00,0.00,0.00),('1','144','829','257705',4904006,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257706',4904007,'2360','360',1719707.07,1725819.60,0.00,0.00,6112.53,4610856.60,0.00,0.00,0.00),('1','144','829','257706',4904008,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257707',4904009,'2360','360',1725819.60,1726233.10,0.00,0.00,413.50,321530.00,0.00,0.00,0.00),('1','144','829','257707',4904010,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257708',4904011,'2360','360',1726233.10,1726233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257708',4904012,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257709',4904013,'2360','360',1726233.10,1729337.08,0.00,0.00,3103.98,2358984.40,0.00,0.00,0.00),('1','144','829','257709',4904014,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257710',4904015,'2360','360',1729337.08,1731954.93,0.00,0.00,2617.85,2006781.00,0.00,0.00,0.00),('1','144','829','257710',4904016,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257711',4904017,'2360','360',1731954.93,1736611.02,0.00,0.00,4656.09,3508650.20,0.00,0.00,0.00),('1','144','829','257711',4904018,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257712',4904019,'2360','360',1736611.02,1741143.91,0.00,0.00,4532.89,3407770.60,0.00,0.00,0.00),('1','144','829','257712',4904020,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257713',4904021,'2360','360',1741143.91,1744664.53,0.00,0.00,3520.62,2659863.92,0.00,0.00,0.00),('1','144','829','257713',4904022,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257714',4904023,'2360','360',1744664.53,1747646.14,0.00,0.00,2981.61,2259149.40,0.00,0.00,0.00),('1','144','829','257714',4904024,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257715',4904025,'2360','360',1747646.14,1750484.35,0.00,0.00,2838.21,2161643.80,0.00,0.00,0.00),('1','144','829','257715',4904026,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257716',4904027,'2360','360',1750484.35,1751185.07,0.00,0.00,700.72,536615.60,0.00,0.00,0.00),('1','144','829','257716',4904028,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257717',4904029,'2360','360',1751185.07,1753421.57,0.00,0.00,2236.50,1678670.00,0.00,0.00,0.00),('1','144','829','257717',4904030,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257718',4904031,'2360','360',1753421.57,1756781.82,0.00,0.00,3360.25,2532795.00,0.00,0.00,0.00),('1','144','829','257718',4904032,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257719',4904033,'2360','360',1756781.82,1759348.06,0.00,0.00,2566.24,1937867.20,0.00,0.00,0.00),('1','144','829','257719',4904034,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257720',4904035,'2360','360',1759348.06,1761436.42,0.00,0.00,2088.36,1617721.20,0.00,0.00,0.00),('1','144','829','257720',4904036,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257721',4904037,'2360','360',1761436.42,1764760.61,0.00,0.00,3324.19,2529028.20,0.00,0.00,0.00),('1','144','829','257721',4904038,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257722',4904039,'2360','360',1764760.61,1767291.24,0.00,0.00,2530.63,1922271.40,0.00,0.00,0.00),('1','144','829','257722',4904040,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257723',4904041,'2360','360',1767291.24,1769933.83,0.00,0.00,2642.59,2014863.00,0.00,0.00,0.00),('1','144','829','257723',4904042,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257724',4904043,'2360','360',1769933.83,1773369.68,0.00,0.00,3435.85,2585562.20,0.00,0.00,0.00),('1','144','829','257724',4904044,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257725',4904045,'2360','360',1773369.68,1775381.46,0.00,0.00,2011.78,1531188.40,0.00,0.00,0.00),('1','144','829','257725',4904046,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257726',4904047,'2360','360',1775381.46,1776088.95,0.00,0.00,707.49,534442.20,0.00,0.00,0.00),('1','144','829','257726',4904048,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257727',4904049,'2360','360',1776088.95,1776088.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257727',4904050,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257728',4904051,'2360','360',1776088.95,1777577.98,0.00,0.00,1489.03,1142243.40,0.00,0.00,0.00),('1','144','829','257728',4904052,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257729',4904053,'2360','360',1777577.98,1780355.19,0.00,0.00,2777.21,2104763.80,0.00,0.00,0.00),('1','144','829','257729',4904054,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257730',4904055,'2360','360',1780355.19,1783718.03,0.00,0.00,3362.84,2537794.00,0.00,0.00,0.00),('1','144','829','257730',4904056,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257731',4904057,'2360','360',1783718.03,1786394.51,0.00,0.00,2676.48,2036134.40,0.00,0.00,0.00),('1','144','829','257731',4904058,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257732',4904059,'2360','360',1786394.51,1789141.98,0.00,0.00,2747.47,2110475.40,0.00,0.00,0.00),('1','144','829','257732',4904060,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257733',4904061,'2360','360',1789141.98,1793173.19,0.00,0.00,4031.21,3039063.40,0.00,0.00,0.00),('1','144','829','257733',4904062,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257734',4904063,'2360','360',1793173.19,1795978.26,0.00,0.00,2805.07,2132192.20,0.00,0.00,0.00),('1','144','829','257734',4904064,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257735',4904065,'2360','360',1795978.26,1799780.70,0.00,0.00,3802.44,2869192.00,0.00,0.00,0.00),('1','144','829','257735',4904066,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257736',4904067,'2360','360',1799780.70,1800936.13,0.00,0.00,1155.43,882405.40,0.00,0.00,0.00),('1','144','829','257736',4904068,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257737',4904069,'2360','360',1800936.13,1800936.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257737',4904070,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257738',4904071,'2360','360',1800936.13,1803234.86,0.00,0.00,2298.73,1738289.40,0.00,0.00,0.00),('1','144','829','257738',4904072,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257739',4904073,'2360','360',1803234.86,1806288.33,0.00,0.00,3053.47,2318237.00,0.00,0.00,0.00),('1','144','829','257739',4904074,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257740',4904075,'2360','360',1806288.33,1811599.23,0.00,0.00,5310.90,4000086.00,0.00,0.00,0.00),('1','144','829','257740',4904076,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257741',4904077,'2360','360',1811599.23,1814423.73,0.00,0.00,2824.50,2166220.00,0.00,0.00,0.00),('1','144','829','257741',4904078,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257742',4904079,'2360','360',1814423.73,1817983.09,0.00,0.00,3559.36,2687757.60,0.00,0.00,0.00),('1','144','829','257742',4904080,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257743',4904081,'2360','360',1817983.09,1820027.78,0.00,0.00,2044.69,1557898.20,0.00,0.00,0.00),('1','144','829','257743',4904082,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257744',4904083,'2360','360',1820027.78,1822396.00,0.00,0.00,2368.22,1802455.20,0.00,0.00,0.00),('1','144','829','257744',4904084,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257745',4904085,'2360','360',1822396.00,1824812.49,0.00,0.00,2416.49,1835262.20,0.00,0.00,0.00),('1','144','829','257745',4904086,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257746',4904087,'2360','360',1824812.49,1825702.78,0.00,0.00,890.29,677826.20,0.00,0.00,0.00),('1','144','829','257746',4904088,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257747',4904089,'2360','360',1825702.78,1825702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257747',4904090,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257748',4904091,'2360','360',1825702.78,1827761.08,0.00,0.00,2058.30,1533968.50,0.00,0.00,0.00),('1','144','829','257748',4904092,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257749',4904093,'2360','360',1827761.08,1830289.33,0.00,0.00,2528.25,1911397.50,0.00,0.00,0.00),('1','144','829','257749',4904094,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257750',4904095,'2360','360',1830289.33,1834280.50,0.00,0.00,3991.17,2978566.65,0.00,0.00,0.00),('1','144','829','257750',4904096,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257751',4904097,'2360','360',1834280.50,1837206.96,0.00,0.00,2926.46,2201769.20,0.00,0.00,0.00),('1','144','829','257751',4904098,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257752',4904099,'2360','360',1837206.96,1841303.99,0.00,0.00,4097.03,3054632.05,0.00,0.00,0.00),('1','144','829','257752',4904100,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257753',4904101,'2360','360',1841303.99,1844325.40,0.00,0.00,3021.41,2256650.70,0.00,0.00,0.00),('1','144','829','257753',4904102,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257754',4904103,'2360','360',1844325.40,1846066.92,0.00,0.00,1741.52,1312175.40,0.00,0.00,0.00),('1','144','829','257754',4904104,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257755',4904105,'2360','360',1846066.92,1848947.70,0.00,0.00,2880.78,2152782.80,0.00,0.00,0.00),('1','144','829','257755',4904106,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257756',4904107,'2360','360',1848947.70,1850322.44,0.00,0.00,1374.74,1031737.00,0.00,0.00,0.00),('1','144','829','257756',4904108,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257757',4904109,'2360','360',1850322.44,1850322.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257757',4904110,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257758',4904111,'2360','360',1850322.44,1853666.69,0.00,0.00,3344.25,2470910.95,0.00,0.00,0.00),('1','144','829','257758',4904112,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257759',4904113,'2360','360',1853666.69,1855802.61,0.00,0.00,2135.92,1628558.40,0.00,0.00,0.00),('1','144','829','257759',4904114,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257760',4904115,'2360','360',1855802.61,1858755.72,0.00,0.00,2953.11,2218411.80,0.00,0.00,0.00),('1','144','829','257760',4904116,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257761',4904117,'2360','360',1858755.72,1863981.11,0.00,0.00,5225.39,3886347.60,0.00,0.00,0.00),('1','144','829','257761',4904118,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257762',4904119,'2360','360',1863981.11,1866520.45,0.00,0.00,2539.34,1912979.25,0.00,0.00,0.00),('1','144','829','257762',4904120,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257763',4904121,'2360','360',1866520.45,1869547.44,0.00,0.00,3026.99,2267823.35,0.00,0.00,0.00),('1','144','829','257763',4904122,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257764',4904123,'2360','360',1869547.44,1872204.89,0.00,0.00,2657.45,1988168.45,0.00,0.00,0.00),('1','144','829','257764',4904124,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257765',4904125,'2360','360',1872204.89,1874896.06,0.00,0.00,2691.17,2016420.20,0.00,0.00,0.00),('1','144','829','257765',4904126,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257766',4904127,'2360','360',1874896.06,1874896.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257766',4904128,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257767',4904129,'2360','360',1874896.06,1875865.11,0.00,0.00,969.05,735493.50,0.00,0.00,0.00),('1','144','829','257767',4904130,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257768',4904131,'2360','360',1875865.11,1878981.02,0.00,0.00,3115.91,2359040.70,0.00,0.00,0.00),('1','144','829','257768',4904132,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257769',4904133,'2360','360',1878981.02,1883430.75,0.00,0.00,4449.73,3318783.76,0.00,0.00,0.00),('1','144','829','257769',4904134,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257770',4904135,'2360','360',1883430.75,1887547.04,0.00,0.00,4116.29,3085724.00,0.00,0.00,0.00),('1','144','829','257770',4904136,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257771',4904137,'2360','360',1887547.04,1890749.12,0.00,0.00,3202.08,2407359.85,0.00,0.00,0.00),('1','144','829','257771',4904138,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257772',4904139,'2360','360',1890749.12,1895205.82,0.00,0.00,4456.70,3322548.30,0.00,0.00,0.00),('1','144','829','257772',4904140,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257773',4904141,'2360','360',1895205.82,1899048.01,0.00,0.00,3842.19,2870746.30,0.00,0.00,0.00),('1','144','829','257773',4904142,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257774',4904143,'2360','360',1899048.01,1899814.97,0.00,0.00,766.96,581809.20,0.00,0.00,0.00),('1','144','829','257774',4904144,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257775',4904145,'2360','360',1899814.97,1899814.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257775',4904146,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257776',4904147,'2360','360',1899814.97,1902716.84,0.00,0.00,2901.87,2177176.25,0.00,0.00,0.00),('1','144','829','257776',4904148,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257777',4904149,'2360','360',1902716.84,1905345.37,0.00,0.00,2628.53,1995593.10,0.00,0.00,0.00),('1','144','829','257777',4904150,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257778',4904151,'2360','360',1905345.37,1909994.36,0.00,0.00,4648.99,3472275.30,0.00,0.00,0.00),('1','144','829','257778',4904152,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257779',4904153,'2360','360',1909994.36,1912626.06,0.00,0.00,2631.70,1982620.50,0.00,0.00,0.00),('1','144','829','257779',4904154,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257780',4904155,'2360','360',1912626.06,1916657.86,0.00,0.00,4031.80,3001076.50,0.00,0.00,0.00),('1','144','829','257780',4904156,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257781',4904157,'2360','360',1916657.86,1918678.68,0.00,0.00,2020.82,1533166.40,0.00,0.00,0.00),('1','144','829','257781',4904158,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257782',4904159,'2360','360',1918678.68,1920412.88,0.00,0.00,1734.20,1313884.00,0.00,0.00,0.00),('1','144','829','257782',4904160,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257783',4904161,'2360','360',1920412.88,1923638.52,0.00,0.00,3225.64,2417099.80,0.00,0.00,0.00),('1','144','829','257783',4904162,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257784',4904163,'2360','360',1923638.52,1924811.99,0.00,0.00,1173.47,900071.90,0.00,0.00,0.00),('1','144','829','257784',4904164,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257785',4904165,'2360','360',1924811.99,1924811.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257785',4904166,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257786',4904167,'2360','360',1924811.99,1925580.51,0.00,0.00,768.52,582210.40,0.00,0.00,0.00),('1','144','829','257786',4904168,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257787',4904169,'2360','360',1925580.51,1928027.96,0.00,0.00,2447.45,1845037.15,0.00,0.00,0.00),('1','144','829','257787',4904170,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257788',4904171,'2360','360',1928027.96,1930373.10,0.00,0.00,2345.14,1762627.90,0.00,0.00,0.00),('1','144','829','257788',4904172,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257789',4904173,'2360','360',1930373.10,1932688.84,0.00,0.00,2315.74,1758799.80,0.00,0.00,0.00),('1','144','829','257789',4904174,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257790',4904175,'2360','360',1932688.84,1936147.32,0.00,0.00,3458.48,2578225.60,0.00,0.00,0.00),('1','144','829','257790',4904176,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257791',4904177,'2360','360',1936147.32,1938469.03,0.00,0.00,2321.71,1746416.70,0.00,0.00,0.00),('1','144','829','257791',4904178,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257792',4904179,'2360','360',1938469.03,1940719.82,0.00,0.00,2250.79,1697414.29,0.00,0.00,0.00),('1','144','829','257792',4904180,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257793',4904181,'2360','360',1940719.82,1945697.61,0.00,0.00,4977.79,3705607.75,0.00,0.00,0.00),('1','144','829','257793',4904182,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257794',4904183,'2360','360',1945697.61,1947856.18,0.00,0.00,2158.57,1638727.75,0.00,0.00,0.00),('1','144','829','257794',4904184,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257795',4904185,'2360','360',1947856.18,1949555.17,0.00,0.00,1698.99,1308222.30,0.00,0.00,0.00),('1','144','829','257795',4904186,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257796',4904187,'2360','360',1949555.17,1949555.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257796',4904188,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257797',4904189,'2360','360',1949555.17,1952755.02,0.00,0.00,3199.85,2415922.50,0.00,0.00,0.00),('1','144','829','257797',4904190,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257798',4904191,'2360','360',1952755.02,1956323.79,0.00,0.00,3568.77,2689152.90,0.00,0.00,0.00),('1','144','829','257798',4904192,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257799',4904193,'2360','360',1956323.79,1958362.32,0.00,0.00,2038.53,1552358.98,0.00,0.00,0.00),('1','144','829','257799',4904194,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257800',4904195,'2360','360',1958362.32,1962376.55,0.00,0.00,4014.23,3016719.10,0.00,0.00,0.00),('1','144','829','257800',4904196,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257801',4904197,'2360','360',1962376.55,1964870.29,0.00,0.00,2493.74,1890673.55,0.00,0.00,0.00),('1','144','829','257801',4904198,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257802',4904199,'2360','360',1964870.29,1967130.22,0.00,0.00,2259.93,1740146.10,0.00,0.00,0.00),('1','144','829','257802',4904200,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257803',4904201,'2360','360',1967130.22,1968479.78,0.00,0.00,1349.56,1039161.20,0.00,0.00,0.00),('1','144','829','257803',4904202,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257804',4904203,'2360','360',1968479.78,1971090.79,0.00,0.00,2611.01,1986827.70,0.00,0.00,0.00),('1','144','829','257804',4904204,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257805',4904205,'2360','360',1971090.79,1974514.10,0.00,0.00,3423.31,2576075.70,0.00,0.00,0.00),('1','144','829','257805',4904206,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257806',4904207,'2360','360',1974514.10,1975082.37,0.00,0.00,568.27,437567.90,0.00,0.00,0.00),('1','144','829','257806',4904208,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257807',4904209,'2360','360',1975082.37,1976528.71,0.00,0.00,1446.34,1102431.80,0.00,0.00,0.00),('1','144','829','257807',4904210,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257808',4904211,'2360','360',1976528.71,1980360.32,0.00,0.00,3831.61,2911136.95,0.00,0.00,0.00),('1','144','829','257808',4904212,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257809',4904213,'2360','360',1980360.32,1983894.86,0.00,0.00,3534.54,2677845.80,0.00,0.00,0.00),('1','144','829','257809',4904214,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257810',4904215,'2360','360',1983894.86,1987106.15,0.00,0.00,3211.29,2430243.30,0.00,0.00,0.00),('1','144','829','257810',4904216,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257811',4904217,'2360','360',1987106.15,1991581.99,0.00,0.00,4475.84,3373061.05,0.00,0.00,0.00),('1','144','829','257811',4904218,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257812',4904219,'2360','360',1991581.99,1993834.51,0.00,0.00,2252.52,1734440.40,0.00,0.00,0.00),('1','144','829','257812',4904220,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257813',4904221,'2360','360',1993834.51,1998293.06,0.00,0.00,4458.55,3374121.00,0.00,0.00,0.00),('1','144','829','257813',4904222,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257814',4904223,'2360','360',1998293.06,1999810.49,0.00,0.00,1517.43,1158871.10,0.00,0.00,0.00),('1','144','829','257814',4904224,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257815',4904225,'2360','360',1999810.49,1999810.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257815',4904226,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257816',4904227,'2360','360',1999810.49,2001142.32,0.00,0.00,1331.83,1023274.10,0.00,0.00,0.00),('1','144','829','257816',4904228,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257817',4904229,'2360','360',2001142.32,2006044.81,0.00,0.00,4902.49,3749390.55,0.00,0.00,0.00),('1','144','829','257817',4904230,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257818',4904231,'2360','360',2006044.81,2008877.90,0.00,0.00,2833.09,2173624.55,0.00,0.00,0.00),('1','144','829','257818',4904232,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257819',4904233,'2360','360',2008877.90,2011947.97,0.00,0.00,3070.07,2350826.40,0.00,0.00,0.00),('1','144','829','257819',4904234,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257820',4904235,'2360','360',2011947.97,2014140.19,0.00,0.00,2192.22,1681876.90,0.00,0.00,0.00),('1','144','829','257820',4904236,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257821',4904237,'2360','360',2014140.19,2016160.26,0.00,0.00,2020.07,1551318.60,0.00,0.00,0.00),('1','144','829','257821',4904238,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257822',4904239,'2360','360',2016160.26,2019317.84,0.00,0.00,3157.58,2422176.60,0.00,0.00,0.00),('1','144','829','257822',4904240,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257823',4904241,'2360','360',2019317.84,2022287.11,0.00,0.00,2969.27,2279537.90,0.00,0.00,0.00),('1','144','829','257823',4904242,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257824',4904243,'2360','360',2022287.11,2024665.59,0.00,0.00,2378.48,1825537.20,0.00,0.00,0.00),('1','144','829','257824',4904244,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257825',4904245,'2360','360',2024665.59,2024665.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257825',4904246,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257826',4904247,'2360','360',2024665.59,2029259.37,0.00,0.00,4593.78,3515051.75,0.00,0.00,0.00),('1','144','829','257826',4904248,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257827',4904249,'2360','360',2029259.37,2031921.54,0.00,0.00,2662.17,2043320.90,0.00,0.00,0.00),('1','144','829','257827',4904250,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257828',4904251,'2360','360',2031921.54,2034754.78,0.00,0.00,2833.24,2170301.16,0.00,0.00,0.00),('1','144','829','257828',4904252,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257829',4904253,'2360','360',2034754.78,2035897.47,0.00,0.00,1142.69,879196.30,0.00,0.00,0.00),('1','144','829','257829',4904254,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257830',4904255,'2360','360',2035897.47,2037552.07,0.00,0.00,1654.60,1272217.00,0.00,0.00,0.00),('1','144','829','257830',4904256,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257831',4904257,'2360','360',2037552.07,2039641.66,0.00,0.00,2089.59,1591635.70,0.00,0.00,0.00),('1','144','829','257831',4904258,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257832',4904259,'2360','360',2039641.66,2042125.43,0.00,0.00,2483.77,1875752.00,0.00,0.00,0.00),('1','144','829','257832',4904260,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257833',4904261,'2360','360',2042125.43,2045296.82,0.00,0.00,3171.39,2382120.30,0.00,0.00,0.00),('1','144','829','257833',4904262,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257834',4904263,'2360','360',2045296.82,2047475.30,0.00,0.00,2178.48,1644312.90,0.00,0.00,0.00),('1','144','829','257834',4904264,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257835',4904265,'2360','360',2047475.30,2049580.29,0.00,0.00,2104.99,1578362.30,0.00,0.00,0.00),('1','144','829','257835',4904266,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257836',4904267,'2360','360',2049580.29,2049580.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257836',4904268,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257837',4904269,'2360','360',2049580.29,2050354.78,0.00,0.00,774.49,587657.30,0.00,0.00,0.00),('1','144','829','257837',4904270,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257838',4904271,'2360','360',2050354.78,2052435.52,0.00,0.00,2080.74,1579789.80,0.00,0.00,0.00),('1','144','829','257838',4904272,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257839',4904273,'2360','360',2052435.52,2055414.73,0.00,0.00,2979.21,2252201.70,0.00,0.00,0.00),('1','144','829','257839',4904274,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257840',4904275,'2360','360',2055414.73,2058791.98,0.00,0.00,3377.25,2559832.50,0.00,0.00,0.00),('1','144','829','257840',4904276,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257841',4904277,'2360','360',2058791.98,2060942.63,0.00,0.00,2150.65,1634250.50,0.00,0.00,0.00),('1','144','829','257841',4904278,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257842',4904279,'2360','360',2060942.63,2064220.43,0.00,0.00,3277.80,2482866.00,0.00,0.00,0.00),('1','144','829','257842',4904280,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257843',4904281,'2360','360',2064220.43,2069124.10,0.00,0.00,4903.67,3694975.90,0.00,0.00,0.00),('1','144','829','257843',4904282,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257844',4904283,'2360','360',2069124.10,2073167.76,0.00,0.00,4043.66,3061418.20,0.00,0.00,0.00),('1','144','829','257844',4904284,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257845',4904285,'2360','360',2073167.76,2074328.93,0.00,0.00,1161.17,878500.90,0.00,0.00,0.00),('1','144','829','257845',4904286,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257846',4904287,'2360','360',2074328.93,2074328.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257846',4904288,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257847',4904289,'2360','360',2074328.93,2075966.86,0.00,0.00,1637.93,1248456.10,0.00,0.00,0.00),('1','144','829','257847',4904290,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257848',4904291,'2360','360',2075966.86,2080039.11,0.00,0.00,4072.25,3062731.00,0.00,0.00,0.00),('1','144','829','257848',4904292,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257849',4904293,'2360','360',2080039.11,2082243.56,0.00,0.00,2204.45,1679216.50,0.00,0.00,0.00),('1','144','829','257849',4904294,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257850',4904295,'2360','360',2082243.56,2085266.37,0.00,0.00,3022.81,2284933.70,0.00,0.00,0.00),('1','144','829','257850',4904296,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257851',4904297,'2360','360',2085266.37,2088278.17,0.00,0.00,3011.80,2268536.00,0.00,0.00,0.00),('1','144','829','257851',4904298,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257852',4904299,'2360','360',2088278.17,2090536.84,0.00,0.00,2258.67,1705545.90,0.00,0.00,0.00),('1','144','829','257852',4904300,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257853',4904301,'2360','360',2090536.84,2092875.47,0.00,0.00,2338.63,1773805.10,0.00,0.00,0.00),('1','144','829','257853',4904302,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257854',4904303,'2360','360',2092875.47,2094957.34,0.00,0.00,2081.87,1572769.90,0.00,0.00,0.00),('1','144','829','257854',4904304,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257855',4904305,'2360','360',2094957.34,2097703.90,0.00,0.00,2746.56,2076961.20,0.00,0.00,0.00),('1','144','829','257855',4904306,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257856',4904307,'2360','360',2097703.90,2099021.46,0.00,0.00,1317.56,991631.20,0.00,0.00,0.00),('1','144','829','257856',4904308,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257857',4904309,'2360','360',2099021.46,2099021.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257857',4904310,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257858',4904311,'2360','360',2099021.46,2100494.71,0.00,0.00,1473.25,1123022.90,0.00,0.00,0.00),('1','144','829','257858',4904312,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257859',4904313,'2360','360',2100494.71,2103794.86,0.00,0.00,3300.15,2476375.50,0.00,0.00,0.00),('1','144','829','257859',4904314,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257860',4904315,'2360','360',2103794.86,2105643.21,0.00,0.00,1848.35,1409099.50,0.00,0.00,0.00),('1','144','829','257860',4904316,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257861',4904317,'2360','360',2105643.21,2108625.92,0.00,0.00,2982.71,2237376.70,0.00,0.00,0.00),('1','144','829','257861',4904318,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257862',4904319,'2360','360',2108625.92,2111270.07,0.00,0.00,2644.15,1991385.50,0.00,0.00,0.00),('1','144','829','257862',4904320,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257863',4904321,'2360','360',2111270.07,2113376.41,0.00,0.00,2106.34,1593006.80,0.00,0.00,0.00),('1','144','829','257863',4904322,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257864',4904323,'2360','360',2113376.41,2116471.89,0.00,0.00,3095.48,2325093.10,0.00,0.00,0.00),('1','144','829','257864',4904324,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257865',4904325,'2360','360',2116471.89,2119113.51,0.00,0.00,2641.62,2003597.40,0.00,0.00,0.00),('1','144','829','257865',4904326,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257866',4904327,'2360','360',2119113.51,2123214.26,0.00,0.00,4100.75,3068920.00,0.00,0.00,0.00),('1','144','829','257866',4904328,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257867',4904329,'2360','360',2123214.26,2123585.55,0.00,0.00,371.29,274754.60,0.00,0.00,0.00),('1','144','829','257867',4904330,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257868',4904331,'2360','360',2123585.55,2123585.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257868',4904332,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257869',4904333,'2360','360',2123585.55,2125932.09,0.00,0.00,2346.54,1774975.80,0.00,0.00,0.00),('1','144','829','257869',4904334,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257870',4904335,'2360','360',2125932.09,2128526.61,0.00,0.00,2594.52,1969430.40,0.00,0.00,0.00),('1','144','829','257870',4904336,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257871',4904337,'2360','360',2128526.61,2131040.39,0.00,0.00,2513.78,1905471.40,0.00,0.00,0.00),('1','144','829','257871',4904338,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257872',4904339,'2360','360',2131040.39,2136268.66,0.00,0.00,5228.27,3921397.90,0.00,0.00,0.00),('1','144','829','257872',4904340,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257873',4904341,'2360','360',2136268.66,2140145.41,0.00,0.00,3876.75,2941777.50,0.00,0.00,0.00),('1','144','829','257873',4904342,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257874',4904343,'2360','360',2140145.41,2142017.20,0.00,0.00,1871.79,1429278.30,0.00,0.00,0.00),('1','144','829','257874',4904344,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257875',4904345,'2360','360',2142017.20,2145372.85,0.00,0.00,3355.65,2531500.50,0.00,0.00,0.00),('1','144','829','257875',4904346,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257876',4904347,'2360','360',2145372.85,2147466.45,0.00,0.00,2093.60,1585072.00,0.00,0.00,0.00),('1','144','829','257876',4904348,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257877',4904349,'2360','360',2147466.45,2148240.67,0.00,0.00,774.22,590149.40,0.00,0.00,0.00),('1','144','829','257877',4904350,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257878',4904351,'2360','360',2148240.67,2148240.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257878',4904352,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257879',4904353,'2360','360',2148240.67,2149188.30,0.00,0.00,947.63,717075.10,0.00,0.00,0.00),('1','144','829','257879',4904354,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257880',4904355,'2360','360',2149188.30,2152288.17,0.00,0.00,3099.87,2340866.10,0.00,0.00,0.00),('1','144','829','257880',4904356,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257881',4904357,'2360','360',2152288.17,2155370.03,0.00,0.00,3081.86,2313032.20,0.00,0.00,0.00),('1','144','829','257881',4904358,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257882',4904359,'2360','360',2155370.03,2157702.74,0.00,0.00,2332.71,1770837.60,0.00,0.00,0.00),('1','144','829','257882',4904360,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257883',4904361,'2360','360',2157702.74,2159627.54,0.00,0.00,1924.80,1464096.00,0.00,0.00,0.00),('1','144','829','257883',4904362,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257884',4904363,'2360','360',2159627.54,2161867.36,0.00,0.00,2239.82,1693431.40,0.00,0.00,0.00),('1','144','829','257884',4904364,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257885',4904365,'2360','360',2161867.36,2164659.22,0.00,0.00,2791.86,2101657.20,0.00,0.00,0.00),('1','144','829','257885',4904366,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257886',4904367,'2360','360',2164659.22,2167139.01,0.00,0.00,2479.79,1871758.30,0.00,0.00,0.00),('1','144','829','257886',4904368,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257887',4904369,'2360','360',2167139.01,2168818.73,0.00,0.00,1679.72,1277064.40,0.00,0.00,0.00),('1','144','829','257887',4904370,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257888',4904371,'2360','360',2168818.73,2170818.31,0.00,0.00,1999.58,1509736.60,0.00,0.00,0.00),('1','144','829','257888',4904372,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257889',4904373,'2360','360',2170818.31,2172993.17,0.00,0.00,2174.86,1636197.50,0.00,0.00,0.00),('1','144','829','257889',4904374,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257890',4904375,'2360','360',2172993.17,2172993.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257890',4904376,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257891',4904377,'2360','360',2172993.17,2174932.94,0.00,0.00,1939.77,1451172.90,0.00,0.00,0.00),('1','144','829','257891',4904378,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257892',4904379,'2360','360',2174932.94,2177618.63,0.00,0.00,2685.69,2042436.90,0.00,0.00,0.00),('1','144','829','257892',4904380,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257893',4904381,'2360','360',2177618.63,2180747.40,0.00,0.00,3128.77,2358936.20,0.00,0.00,0.00),('1','144','829','257893',4904382,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257894',4904383,'2360','360',2180747.40,2183388.37,0.00,0.00,2640.97,2005676.90,0.00,0.00,0.00),('1','144','829','257894',4904384,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257895',4904385,'2360','360',2183388.37,2185948.06,0.00,0.00,2559.69,1933971.30,0.00,0.00,0.00),('1','144','829','257895',4904386,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257896',4904387,'2360','360',2185948.06,2188184.90,0.00,0.00,2236.84,1695339.20,0.00,0.00,0.00),('1','144','829','257896',4904388,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257897',4904389,'2360','360',2188184.90,2190811.91,0.00,0.00,2627.01,1980947.70,0.00,0.00,0.00),('1','144','829','257897',4904390,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257898',4904391,'2360','360',2190811.91,2196105.02,0.00,0.00,5293.11,3963029.70,0.00,0.00,0.00),('1','144','829','257898',4904392,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257899',4904393,'2360','360',2196105.02,2197553.77,0.00,0.00,1448.75,1098137.50,0.00,0.00,0.00),('1','144','829','257899',4904394,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257900',4904395,'2360','360',2197553.77,2197553.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257900',4904396,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257901',4904397,'2360','360',2197553.77,2198912.58,0.00,0.00,1358.81,1031583.70,0.00,0.00,0.00),('1','144','829','257901',4904398,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257902',4904399,'2360','360',2198912.58,2201296.02,0.00,0.00,2383.44,1805908.80,0.00,0.00,0.00),('1','144','829','257902',4904400,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257903',4904401,'2360','360',2201296.02,2204490.14,0.00,0.00,3194.12,2406642.40,0.00,0.00,0.00),('1','144','829','257903',4904402,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257904',4904403,'2360','360',2204490.14,2208775.16,0.00,0.00,4285.02,3211091.40,0.00,0.00,0.00),('1','144','829','257904',4904404,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257905',4904405,'2360','360',2208775.16,2211831.90,0.00,0.00,3056.74,2305539.80,0.00,0.00,0.00),('1','144','829','257905',4904406,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257906',4904407,'2360','360',2211831.90,2214890.55,0.00,0.00,3058.65,2299222.50,0.00,0.00,0.00),('1','144','829','257906',4904408,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257907',4904409,'2360','360',2214890.55,2217057.52,0.00,0.00,2166.97,1643553.50,0.00,0.00,0.00),('1','144','829','257907',4904410,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257908',4904411,'2360','360',2217057.52,2219845.01,0.00,0.00,2787.49,2116463.60,0.00,0.00,0.00),('1','144','829','257908',4904412,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257909',4904413,'2360','360',2219845.01,2222045.90,0.00,0.00,2200.89,1658085.30,0.00,0.00,0.00),('1','144','829','257909',4904414,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257910',4904415,'2360','360',2222045.90,2222045.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257910',4904416,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257911',4904417,'2360','360',2222045.90,2222698.63,0.00,0.00,652.73,499272.10,0.00,0.00,0.00),('1','144','829','257911',4904418,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257912',4904419,'2360','360',2222698.63,2225301.92,0.00,0.00,2603.29,1969762.40,0.00,0.00,0.00),('1','144','829','257912',4904420,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257913',4904421,'2360','360',2225301.92,2228022.79,0.00,0.00,2720.87,2052803.20,0.00,0.00,0.00),('1','144','829','257913',4904422,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257914',4904423,'2360','360',2228022.79,2232982.17,0.00,0.00,4959.38,3712040.20,0.00,0.00,0.00),('1','144','829','257914',4904424,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257915',4904425,'2360','360',2232982.17,2235442.02,0.00,0.00,2459.85,1857406.50,0.00,0.00,0.00),('1','144','829','257915',4904426,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257916',4904427,'2360','360',2235442.02,2238267.88,0.00,0.00,2825.86,2140662.20,0.00,0.00,0.00),('1','144','829','257916',4904428,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257917',4904429,'2360','360',2238267.88,2240408.37,0.00,0.00,2140.49,1630477.30,0.00,0.00,0.00),('1','144','829','257917',4904430,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257918',4904431,'2360','360',2240408.37,2242971.83,0.00,0.00,2563.46,1931564.20,0.00,0.00,0.00),('1','144','829','257918',4904432,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257919',4904433,'2360','360',2242971.83,2245613.42,0.00,0.00,2641.59,1997004.30,0.00,0.00,0.00),('1','144','829','257919',4904434,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257920',4904435,'2360','360',2245613.42,2246583.58,0.00,0.00,970.16,721662.70,0.00,0.00,0.00),('1','144','829','257920',4904436,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257921',4904437,'2360','360',2246583.58,2246583.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257921',4904438,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257922',4904439,'2360','360',2246583.58,2248707.40,0.00,0.00,2123.82,1603440.90,0.00,0.00,0.00),('1','144','829','257922',4904440,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257923',4904441,'2360','360',2248707.40,2251631.26,0.00,0.00,2923.86,2200552.20,0.00,0.00,0.00),('1','144','829','257923',4904442,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257924',4904443,'2360','360',2251631.26,2255380.28,0.00,0.00,3749.02,2818489.40,0.00,0.00,0.00),('1','144','829','257924',4904444,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257925',4904445,'2360','360',2255380.28,2259071.05,0.00,0.00,3690.77,2782132.90,0.00,0.00,0.00),('1','144','829','257925',4904446,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257926',4904447,'2360','360',2259071.05,2262315.83,0.00,0.00,3244.78,2469975.20,0.00,0.00,0.00),('1','144','829','257926',4904448,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257927',4904449,'2360','360',2262315.83,2264832.85,0.00,0.00,2517.02,1907505.40,0.00,0.00,0.00),('1','144','829','257927',4904450,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257928',4904451,'2360','360',2264832.85,2267361.39,0.00,0.00,2528.54,1916726.80,0.00,0.00,0.00),('1','144','829','257928',4904452,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257929',4904453,'2360','360',2267361.39,2270541.60,0.00,0.00,3180.21,2403281.70,0.00,0.00,0.00),('1','144','829','257929',4904454,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257930',4904455,'2360','360',2270541.60,2271076.90,0.00,0.00,535.30,402431.00,0.00,0.00,0.00),('1','144','829','257930',4904456,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257931',4904457,'2360','360',2271076.90,2271076.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257931',4904458,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257932',4904459,'2360','360',2271076.90,2273566.72,0.00,0.00,2489.82,1881431.40,0.00,0.00,0.00),('1','144','829','257932',4904460,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257933',4904461,'2360','360',2273566.72,2279879.45,0.00,0.00,6312.73,4711738.40,0.00,0.00,0.00),('1','144','829','257933',4904462,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257934',4904463,'2360','360',2279879.45,2282793.88,0.00,0.00,2914.43,2200274.50,0.00,0.00,0.00),('1','144','829','257934',4904464,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257935',4904465,'2360','360',2282793.88,2285299.18,0.00,0.00,2505.30,1908665.70,0.00,0.00,0.00),('1','144','829','257935',4904466,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257936',4904467,'2360','360',2285299.18,2287784.29,0.00,0.00,2485.11,1877607.30,0.00,0.00,0.00),('1','144','829','257936',4904468,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257937',4904469,'2360','360',2287784.29,2290274.30,0.00,0.00,2490.01,1871887.70,0.00,0.00,0.00),('1','144','829','257937',4904470,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257938',4904471,'2360','360',2290274.30,2293350.41,0.00,0.00,3076.11,2307128.40,0.00,0.00,0.00),('1','144','829','257938',4904472,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257939',4904473,'2360','360',2293350.41,2294427.41,0.00,0.00,1077.00,811783.50,0.00,0.00,0.00),('1','144','829','257939',4904474,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257940',4904475,'2360','360',2294427.41,2294427.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257940',4904476,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257941',4904477,'2360','360',2294427.41,2295581.93,0.00,0.00,1154.52,875582.70,0.00,0.00,0.00),('1','144','829','257941',4904478,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257942',4904479,'2360','360',2295581.93,2297179.69,0.00,0.00,1597.76,1204295.20,0.00,0.00,0.00),('1','144','829','257942',4904480,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257943',4904481,'2360','360',2297179.69,2299651.60,0.00,0.00,2471.91,1866363.00,0.00,0.00,0.00),('1','144','829','257943',4904482,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257944',4904483,'2360','360',2299651.60,2301941.22,0.00,0.00,2289.62,1746882.40,0.00,0.00,0.00),('1','144','829','257944',4904484,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257945',4904485,'2360','360',2301941.22,2304153.26,0.00,0.00,2212.04,1667885.80,0.00,0.00,0.00),('1','144','829','257945',4904486,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257946',4904487,'2360','360',2304153.26,2306133.96,0.00,0.00,1980.70,1502728.40,0.00,0.00,0.00),('1','144','829','257946',4904488,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257947',4904489,'2360','360',2306133.96,2308936.45,0.00,0.00,2802.49,2111762.30,0.00,0.00,0.00),('1','144','829','257947',4904490,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257948',4904491,'2360','360',2308936.45,2311621.48,0.00,0.00,2685.03,2037773.10,0.00,0.00,0.00),('1','144','829','257948',4904492,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257949',4904493,'2360','360',2311621.48,2315087.81,0.00,0.00,3466.33,2627899.10,0.00,0.00,0.00),('1','144','829','257949',4904494,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257950',4904495,'2360','360',2315087.81,2318694.84,0.00,0.00,3607.03,2751913.10,0.00,0.00,0.00),('1','144','829','257950',4904496,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257951',4904497,'2360','360',2318694.84,2318944.22,0.00,0.00,249.38,188211.70,0.00,0.00,0.00),('1','144','829','257951',4904498,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257952',4904499,'2360','360',2318944.22,2318944.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257952',4904500,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257953',4904501,'2360','360',2318944.22,2322072.14,0.00,0.00,3127.92,2362538.40,0.00,0.00,0.00),('1','144','829','257953',4904502,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257954',4904503,'2360','360',2322072.14,2324922.69,0.00,0.00,2850.55,2149512.50,0.00,0.00,0.00),('1','144','829','257954',4904504,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257955',4904505,'2360','360',2324922.69,2327098.68,0.00,0.00,2175.99,1639542.30,0.00,0.00,0.00),('1','144','829','257955',4904506,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257956',4904507,'2360','360',2327098.68,2328880.63,0.00,0.00,1781.95,1355350.10,0.00,0.00,0.00),('1','144','829','257956',4904508,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257957',4904509,'2360','360',2328880.63,2331140.49,0.00,0.00,2259.86,1713076.90,0.00,0.00,0.00),('1','144','829','257957',4904510,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257958',4904511,'2360','360',2331140.49,2333423.54,0.00,0.00,2283.05,1736333.50,0.00,0.00,0.00),('1','144','829','257958',4904512,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257959',4904513,'2360','360',2333423.54,2335788.29,0.00,0.00,2364.75,1803247.50,0.00,0.00,0.00),('1','144','829','257959',4904514,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257960',4904515,'2360','360',2335788.29,2338556.09,0.00,0.00,2767.80,2092386.00,0.00,0.00,0.00),('1','144','829','257960',4904516,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257961',4904517,'2360','360',2338556.09,2342023.50,0.00,0.00,3467.41,2607115.70,0.00,0.00,0.00),('1','144','829','257961',4904518,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257962',4904519,'2360','360',2342023.50,2342614.69,0.00,0.00,591.19,440516.60,0.00,0.00,0.00),('1','144','829','257962',4904520,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257963',4904521,'2360','360',2342614.69,2342614.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257963',4904522,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257964',4904523,'2360','360',2342614.69,2345354.21,0.00,0.00,2739.52,1986481.70,0.00,0.00,0.00),('1','144','829','257964',4904524,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257965',4904525,'2360','360',2345354.21,2348570.35,0.00,0.00,3216.14,2329198.60,0.00,0.00,0.00),('1','144','829','257965',4904526,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257966',4904527,'2360','360',2348570.35,2351104.83,0.00,0.00,2534.48,1845515.20,0.00,0.00,0.00),('1','144','829','257966',4904528,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257967',4904529,'2360','360',2351104.83,2355636.18,0.00,0.00,4531.35,3253470.90,0.00,0.00,0.00),('1','144','829','257967',4904530,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257968',4904531,'2360','360',2355636.18,2358350.07,0.00,0.00,2713.89,1969581.30,0.00,0.00,0.00),('1','144','829','257968',4904532,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257969',4904533,'2360','360',2358350.07,2361241.14,0.00,0.00,2891.07,2087379.00,0.00,0.00,0.00),('1','144','829','257969',4904534,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257970',4904535,'2360','360',2361241.14,2363600.09,0.00,0.00,2358.95,1722292.00,0.00,0.00,0.00),('1','144','829','257970',4904536,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257971',4904537,'2360','360',2363600.09,2366273.63,0.00,0.00,2673.54,1939002.60,0.00,0.00,0.00),('1','144','829','257971',4904538,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257972',4904539,'2360','360',2366273.63,2366946.22,0.00,0.00,672.59,481366.60,0.00,0.00,0.00),('1','144','829','257972',4904540,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257973',4904541,'2360','360',2366946.22,2366946.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','829','257973',4904542,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257974',4904543,'2360','360',2366946.22,2371103.46,0.00,0.00,4157.24,3032874.10,0.00,0.00,0.00),('1','144','829','257974',4904544,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','144','828','257975',4904545,'2360','360',2371103.46,2373864.20,0.00,0.00,2760.74,2007822.40,0.00,0.00,0.00),('1','144','829','257975',4904546,'2361','360',722402.22,722402.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730120 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','144','157104','360',222.00,280.00,0.00,921.40,204550.80,248672.00,44121.20,468376),('1','144','160790','360',222.00,280.00,0.00,819.60,181951.20,219888.00,37936.80,478004),('1','144','160796','360',222.00,0.00,0.00,990.00,219780.00,265490.00,45710.00,478020),('1','144','160802','360',222.00,280.00,0.00,719.80,159795.60,195744.00,35948.40,478036),('1','144','160807','360',222.00,280.00,0.00,1133.50,251637.00,304380.00,52743.00,478047),('1','144','160809','360',222.00,280.00,0.00,521.30,115728.60,144964.00,29235.40,478049),('1','144','160812','360',222.00,280.00,0.00,1189.60,264091.20,317088.00,52996.80,478056),('1','144','160814','360',222.00,280.00,0.00,1251.40,277810.80,339392.00,61581.20,478060),('1','144','160827','360',222.00,280.00,0.00,1586.50,352203.00,415320.00,63117.00,478089),('1','144','160833','360',222.00,280.00,0.00,751.80,166899.60,202004.00,35104.40,478101),('1','144','160849','360',222.00,280.00,0.00,1086.90,241291.80,287332.00,46040.20,478141),('1','144','160857','360',222.00,280.00,0.00,6623.10,1470328.20,1564764.00,94435.80,478161),('1','144','160909','360',222.00,280.00,0.00,1904.50,422799.00,483720.00,60921.00,478280),('1','144','160914','360',222.00,280.00,0.00,1834.40,407236.80,471532.00,64295.20,478293),('1','144','160921','360',222.00,280.00,0.00,728.40,161704.80,192052.00,30347.20,478310),('1','144','161534','360',222.00,280.00,0.00,763.50,169497.00,196780.00,27283.00,479897),('1','144','161537','360',222.00,280.00,0.00,3023.80,671283.60,755804.00,84520.40,479905),('1','144','161540','360',222.00,280.00,0.00,1633.90,362725.80,438367.00,75641.20,479912),('1','144','161550','360',222.00,280.00,0.00,3015.80,669507.60,774524.00,105016.40,479937),('1','144','161556','360',222.00,280.00,0.00,2321.00,515262.00,601380.00,86118.00,479953),('1','144','161559','360',222.00,280.00,0.00,8279.00,1837938.00,1988480.00,150542.00,479959),('1','144','162310','360',222.00,280.00,0.00,1200.60,266533.20,298168.00,31634.80,481904),('1','144','162320','360',222.00,280.00,0.00,2550.00,566100.00,656200.00,90100.00,481927),('1','144','162341','360',222.00,280.00,0.00,1210.90,268819.80,322052.00,53232.20,481985),('1','144','162346','360',222.00,280.00,0.00,1666.80,370029.60,446304.00,76274.40,481996),('1','144','162348','360',222.00,280.00,0.00,2150.30,477366.60,553884.00,76517.40,482000),('1','144','162432','360',222.00,280.00,0.00,3162.30,702030.60,793944.00,91913.40,482229),('1','144','162435','360',222.00,280.00,0.00,1926.70,427727.40,510372.00,82644.60,482234),('1','144','162510','360',222.00,280.00,0.00,10039.00,2228658.00,2434166.00,205508.00,482411),('1','144','162533','360',222.00,280.00,0.00,1771.40,393250.80,470492.00,77241.20,482465),('1','144','162535','360',222.00,280.00,0.00,3225.00,715950.00,816502.00,100552.00,482469),('1','144','162540','360',222.00,280.00,0.00,1924.10,427150.20,505088.00,77937.80,482482),('1','144','162545','360',222.00,280.00,0.00,1961.50,435453.00,507120.00,71667.00,482493),('1','144','162551','360',222.00,280.00,0.00,3539.20,785702.40,896676.00,110973.60,482507),('1','144','162555','360',222.00,280.00,0.00,2241.70,497657.40,578776.00,81118.60,482518),('1','144','162558','360',222.00,280.00,0.00,8007.30,1777620.60,1963534.00,185913.40,482523),('1','144','162782','360',222.00,280.00,0.00,3430.40,761548.80,872812.00,111263.20,483124),('1','144','162785','360',222.00,280.00,0.00,13546.00,3007212.00,3287535.00,280323.00,483131),('1','144','162969','360',222.00,280.00,0.00,1804.60,400621.20,478088.00,77466.80,483618),('1','144','162973','360',222.00,280.00,0.00,2315.40,514018.80,596512.00,82493.20,483625),('1','144','163022','360',222.00,280.00,0.00,1584.10,351670.20,392648.00,40977.80,483736),('1','144','163027','360',222.00,280.00,0.00,1817.50,403485.00,477450.00,73965.00,483743),('1','144','163644','360',222.00,280.00,0.00,1852.50,411255.00,486400.00,75145.00,485354),('1','144','163646','360',222.00,280.00,0.00,2591.50,575313.00,678971.60,103658.60,485358),('1','144','163648','360',222.00,280.00,0.00,7777.70,1726649.40,1924256.00,197606.60,485362),('1','144','163665','360',222.00,280.00,0.00,2976.50,660783.00,765878.00,105095.00,485409),('1','144','163907','360',222.00,280.00,0.00,3807.00,845154.00,966660.00,121506.00,486030),('1','144','164092','360',222.00,280.00,0.00,1772.30,393450.60,470744.00,77293.40,486512),('1','144','164094','360',222.00,300.00,0.00,383.10,85048.20,114930.00,29881.80,486514),('1','144','164309','360',222.00,300.00,0.00,2692.00,597624.00,752250.00,154626.00,487086),('1','144','164808','360',222.00,300.00,0.00,2142.70,475679.40,601260.00,125580.60,488440),('1','144','164812','360',222.00,300.00,0.00,2816.00,625152.00,789300.00,164148.00,488448),('1','144','164813','360',222.00,300.00,0.00,4709.90,1045597.80,1292070.00,246472.20,488449),('1','144','165069','360',222.00,300.00,0.00,6865.70,1524185.40,1856739.00,332553.60,489102),('1','144','165091','360',250.00,300.00,0.00,2657.30,664325.00,741495.00,77170.00,489159),('1','144','165169','360',250.00,320.00,0.00,1598.20,399550.00,498424.00,98874.00,489358),('1','144','165380','360',250.00,320.00,0.00,1573.00,393250.00,490110.00,96860.00,489903),('1','144','165516','360',250.00,320.00,0.00,1415.40,353850.00,442678.00,88828.00,490260),('1','144','166116','360',250.00,320.00,0.00,1795.20,448800.00,551764.00,102964.00,491868),('1','144','166123','360',250.00,320.00,0.00,1013.90,253475.00,324448.00,70973.00,491885),('1','144','166154','360',250.00,320.00,0.00,950.70,237675.00,304224.00,66549.00,491946),('1','144','166155','360',250.00,320.00,0.00,1226.60,306650.00,388012.00,81362.00,491947),('1','144','166384','360',250.00,320.00,0.00,1192.40,298100.00,375568.00,77468.00,492569),('1','144','166591','360',250.00,320.00,0.00,1292.80,323200.00,401896.00,78696.00,493131),('1','144','166739','360',250.00,320.00,0.00,2088.30,522075.00,639370.00,117295.00,493518),('1','144','167501','360',250.00,320.00,0.00,1142.10,285525.00,359272.00,73747.00,495581),('1','144','167548','360',250.00,320.00,0.00,1491.10,372775.00,467352.00,94577.00,495704),('1','144','167631','360',250.00,320.00,0.00,1863.90,465975.00,572323.00,106348.00,495913),('1','144','167637','360',250.00,320.00,0.00,500.00,125000.00,150000.00,25000.00,495929),('1','144','167642','360',250.00,320.00,0.00,11961.90,3277560.60,3462498.00,184937.40,495940),('1','144','167693','360',274.00,320.00,0.00,1351.50,370311.00,422630.00,52319.00,496080),('1','144','167781','360',274.00,320.00,0.00,1301.40,356583.60,403523.00,46939.40,496293),('1','144','168145','360',274.00,320.00,0.00,1306.80,358063.20,414756.00,56692.80,497260),('1','144','168147','360',274.00,320.00,0.00,1105.50,302907.00,343760.00,40853.00,497263),('1','144','168481','360',274.00,320.00,0.00,1440.70,394751.80,446774.00,52022.20,498175),('1','144','168485','360',274.00,320.00,0.00,2447.40,670587.60,744568.00,73980.40,498185),('1','144','168627','360',274.00,320.00,0.00,1416.40,388093.60,436435.50,48341.90,498543),('1','144','168961','360',274.00,320.00,0.00,1815.30,497392.20,556661.00,59268.80,499431),('1','144','168963','360',274.00,320.00,0.00,1978.30,542054.20,590536.00,48481.80,499435),('1','144','169152','360',274.00,320.00,0.00,2505.00,686370.00,762030.00,75660.00,499914),('1','144','169945','360',274.00,320.00,0.00,1675.00,458950.00,518250.00,59300.00,502004),('1','144','169948','360',274.00,320.00,0.00,2207.60,604882.40,676212.00,71329.60,502011),('1','144','169949','360',274.00,320.00,0.00,1975.60,541314.40,605892.00,64577.60,502012),('1','144','169953','360',274.00,320.00,0.00,0.00,0.00,0.00,0.00,502022),('1','144','169954','360',274.00,320.00,0.00,1616.10,442811.40,495884.00,53072.60,502023),('1','144','169968','360',274.00,320.00,0.00,0.00,0.00,0.00,0.00,502060),('1','144','169979','360',274.00,320.00,0.00,1978.30,542054.20,590536.00,48481.80,502087),('1','144','169986','360',274.00,320.00,0.00,1616.10,442811.40,495884.00,53072.60,502102),('1','144','170155','360',274.00,320.00,0.00,1319.50,361543.00,405590.00,44047.00,502530),('1','144','170944','360',274.00,320.00,0.00,1258.60,344856.40,391502.00,46645.60,504619),('1','144','170952','360',274.00,320.00,0.00,1669.00,457306.00,510880.00,53574.00,504639),('1','144','170955','360',274.00,320.00,0.00,4582.60,1255632.40,1309716.00,54083.60,504646),('1','144','170964','360',274.00,320.00,0.00,3302.10,904775.40,972728.00,67952.60,504671),('1','144','171075','360',274.00,320.00,0.00,1078.10,295399.40,334492.00,39092.60,504960),('1','144','171087','360',274.00,320.00,0.00,1937.40,530847.60,588030.50,57182.90,504991),('1','144','171192','360',274.00,320.00,0.00,1937.40,530847.60,588030.50,57182.90,505285),('1','144','171194','360',274.00,320.00,0.00,754.70,206787.80,377841.50,171053.70,505289),('1','144','171339','360',274.00,320.00,0.00,2327.10,637625.40,688672.00,51046.60,505669),('1','144','171986','360',274.00,320.00,0.00,2182.40,597977.60,652105.00,54127.40,507374),('1','144','171988','360',274.00,320.00,0.00,7317.10,2004885.40,2112572.00,107686.60,507378),('1','144','171992','360',274.00,320.00,0.00,3199.40,876635.60,936658.00,60022.40,507388),('1','144','171994','360',274.00,320.00,0.00,1988.10,544739.40,573958.50,29219.10,507390),('1','144','171997','360',274.00,320.00,0.00,814.40,223145.60,249691.50,26545.90,507397),('1','144','172350','360',274.00,320.00,0.00,1977.90,541944.60,599328.00,57383.40,508348),('1','144','172352','360',274.00,320.00,0.00,1890.70,518051.80,564896.50,46844.70,508352),('1','144','172514','360',274.00,320.00,0.00,1924.40,527285.60,576608.00,49322.40,508780),('1','144','172704','360',274.00,320.00,0.00,9140.50,2504497.00,2633844.00,129347.00,509274),('1','144','172878','360',274.00,320.00,0.00,1804.10,494323.40,539288.00,44964.60,509733),('1','144','173064','360',274.00,0.00,0.00,4141.20,1134688.80,1208284.00,73595.20,510231),('1','144','173225','360',274.00,320.00,0.00,3246.80,889623.20,951476.00,61852.80,510656),('1','144','173300','360',281.00,320.00,0.00,158.00,44398.00,50560.00,6162.00,510856),('1','144','173393','360',281.00,320.00,0.00,2716.30,763280.30,812936.00,49655.70,511093),('1','144','173672','360',281.00,320.00,0.00,2180.90,612832.90,653333.00,40500.10,511846),('1','144','173770','360',281.00,320.00,0.00,7799.00,2191519.00,2253305.00,61786.00,512098),('1','144','173950','360',281.00,320.00,0.00,2899.80,814843.80,852721.00,37877.20,512573),('1','144','174134','360',281.00,320.00,0.00,2972.10,835160.10,879864.50,44704.40,513055),('1','144','174326','360',281.00,320.00,0.00,2456.70,690332.70,735331.00,44998.30,513567),('1','144','174515','360',281.00,320.00,0.00,3281.20,922017.20,939734.00,17716.80,514047),('1','144','174527','360',285.00,300.00,0.00,1629.60,464436.00,488880.00,24444.00,514080),('1','144','174648','360',285.00,300.00,0.00,5422.40,1545384.00,1626720.00,81336.00,514375),('1','144','174856','360',285.00,320.00,0.00,3604.90,1027396.50,1088570.00,61173.50,514933),('1','144','175245','360',285.00,352.00,0.00,7643.90,2178511.50,2411466.80,232955.30,515960),('1','144','175247','360',285.00,352.00,0.00,4903.80,1397583.00,1560198.60,162615.60,515962),('1','144','175424','360',285.00,352.00,0.00,1375.40,391989.00,452960.30,60971.30,516427),('1','144','175426','360',281.00,352.00,0.00,188.00,52828.00,64226.00,11398.00,516431),('1','144','175969','360',281.00,352.00,0.00,1711.50,480931.50,572628.00,91696.50,517864),('1','144','175971','360',281.00,352.00,0.00,2265.10,636493.10,746915.20,110422.10,517868),('1','144','175978','360',281.00,352.00,0.00,2566.90,721298.90,843971.80,122672.90,517882),('1','144','176150','360',281.00,352.00,0.00,9210.00,2588010.00,2917092.00,329082.00,518309),('1','144','176571','360',281.00,352.00,0.00,1752.10,492340.10,570539.20,78199.10,519401),('1','144','176575','360',281.00,352.00,0.00,2841.00,798321.00,911328.00,113007.00,519409),('1','144','176845','360',281.00,352.00,0.00,4051.40,1138443.40,1300202.00,161758.60,520146),('1','144','178163','360',301.00,352.00,0.00,1856.80,558896.80,594793.60,35896.80,523640),('1','144','178173','360',301.00,352.00,0.00,10889.90,3277859.90,3424044.80,146184.90,523663),('1','144','178186','360',301.00,352.00,0.00,1710.90,514980.90,575956.80,60975.90,523695),('1','144','178198','360',301.00,352.00,0.00,2678.00,806078.00,894056.00,87978.00,523726),('1','144','178261','360',301.00,352.00,0.00,2114.50,636464.50,699304.00,62839.50,523899),('1','144','178265','360',301.00,0.00,0.00,3309.00,996009.00,1076568.00,80559.00,523908),('1','144','178305','360',301.00,352.00,0.00,1990.90,599260.90,654511.60,55250.70,523991),('1','144','178315','360',302.00,352.00,0.00,2452.40,740624.80,803844.80,63220.00,524019),('1','144','178682','360',302.00,352.00,0.00,11669.90,3524309.80,3674432.80,150123.00,524997),('1','144','178738','360',302.00,352.00,0.00,2501.30,755392.60,842157.60,86765.00,525126),('1','144','179514','360',302.00,352.00,0.00,2109.60,637099.20,722579.20,85480.00,527195),('1','144','179515','360',302.00,352.00,0.00,2303.80,695747.60,781817.60,86070.00,527196),('1','144','179517','360',302.00,352.00,0.00,1680.90,507631.80,574446.80,66815.00,527200),('1','144','179796','360',302.00,352.00,0.00,1880.10,567790.20,625793.20,58003.00,527928),('1','144','180352','360',320.00,352.00,0.00,1494.90,478368.00,508964.80,30596.80,529370),('1','144','180355','360',320.00,352.00,0.00,4350.60,1392192.00,1460411.20,68219.20,529377),('1','144','180361','360',320.00,352.00,0.00,1163.80,372416.00,398407.60,25991.60,529387),('1','144','180365','360',320.00,352.00,0.00,7162.40,2291968.00,2394364.80,102396.80,529397),('1','144','180367','360',320.00,352.00,0.00,2068.20,661824.00,709006.40,47182.40,529401),('1','144','180616','360',320.00,352.00,0.00,2477.70,792864.00,838950.40,46086.40,530073),('1','144','180956','360',320.00,352.00,0.00,1543.30,493856.00,528241.60,34385.60,530988),('1','144','181365','360',320.00,352.00,0.00,2477.70,792864.00,838950.40,46086.40,532064),('1','144','181373','360',320.00,352.00,0.00,1543.30,493856.00,528241.60,34385.60,532086),('1','144','181382','360',320.00,352.00,0.00,1263.20,404224.00,433526.40,29302.40,532106),('1','144','181386','360',320.00,352.00,0.00,1822.30,583136.00,625609.60,42473.60,532115),('1','144','181389','360',320.00,352.00,0.00,1131.10,361952.00,387547.20,25595.20,532120),('1','144','181414','360',322.00,352.00,0.00,838.40,269964.80,283116.80,13152.00,532188),('1','144','181581','360',322.00,352.00,0.00,2345.10,755122.20,793475.20,38353.00,532629),('1','144','181847','360',322.00,352.00,0.00,4716.80,1518809.60,1579416.60,60607.00,533353),('1','144','182082','360',322.00,352.00,0.00,1788.60,575929.20,610987.20,35058.00,533989),('1','144','182204','360',322.00,352.00,0.00,2061.50,663803.00,700148.00,36345.00,534297),('1','144','182602','360',322.00,352.00,0.00,1846.10,594444.20,629817.20,35373.00,535346),('1','144','182614','360',322.00,352.00,0.00,5264.40,1695136.80,1756318.80,61182.00,535380),('1','144','183212','360',322.00,352.00,0.00,1400.00,464800.00,479800.00,15000.00,536964),('1','144','184004','360',332.00,352.00,0.00,2836.00,941552.00,960532.00,18980.00,539053),('1','144','184011','360',332.00,352.00,0.00,1273.10,422669.20,426131.20,3462.00,539071),('1','144','184013','360',332.00,352.00,0.00,869.30,280783.90,299993.60,19209.70,539075),('1','144','184192','360',323.00,352.00,0.00,3547.70,1145907.10,1187099.40,41192.30,539553),('1','144','184199','360',323.00,352.00,0.00,1590.60,513763.80,544891.20,31127.40,539570),('1','144','184203','360',323.00,352.00,0.00,5275.30,1703921.90,1758955.60,55033.70,539580),('1','144','184415','360',323.00,352.00,0.00,2485.40,802784.20,843790.80,41006.60,540138),('1','144','184417','360',323.00,352.00,0.00,1681.30,543059.90,572267.60,29207.70,540141),('1','144','184418','360',323.00,352.00,0.00,3453.60,1115512.80,1155767.20,40254.40,540142),('1','144','184834','360',323.00,352.00,0.00,1825.40,589604.20,618140.80,28536.60,541263),('1','144','184836','360',323.00,352.00,0.00,2470.50,797971.50,831966.00,33994.50,541267),('1','144','185040','360',323.00,352.00,0.00,2470.50,797971.50,831966.00,33994.50,541798),('1','144','185049','360',323.00,352.00,0.00,300.90,97190.70,101916.80,4726.10,541823),('1','144','186489','360',322.00,352.00,0.00,1037.00,333914.00,353024.00,19110.00,545605),('1','144','186883','360',322.00,352.00,0.00,1955.40,629638.80,662420.80,32782.00,546624),('1','144','186897','360',322.00,352.00,0.00,3369.00,1084818.00,1126613.00,41795.00,546651),('1','144','186902','360',322.00,352.00,0.00,849.30,273474.60,294433.60,20959.00,546663),('1','144','186912','360',322.00,352.00,0.00,4082.10,1314436.20,1363449.20,49013.00,546681),('1','144','186920','360',322.00,352.00,0.00,2156.30,694328.60,730017.60,35689.00,546702),('1','144','186925','360',322.00,352.00,0.00,1192.70,384049.40,411330.40,27281.00,546716),('1','144','186927','360',322.00,352.00,0.00,1999.30,643774.60,680503.60,36729.00,546720),('1','144','186928','360',322.00,352.00,0.00,1221.90,393451.80,418858.80,25407.00,546721),('1','144','186929','360',322.00,352.00,0.00,1463.40,471214.80,500126.80,28912.00,546722),('1','144','186930','360',322.00,352.00,0.00,2419.90,779207.80,815254.80,36047.00,546723),('1','144','186971','360',322.00,352.00,0.00,1524.10,490760.20,526483.20,35723.00,546825),('1','144','187147','360',322.00,352.00,0.00,1073.00,345506.00,371696.00,26190.00,547306),('1','144','187273','360',322.00,352.00,0.00,883.60,284519.20,300027.20,15508.00,547629),('1','144','187334','360',322.00,352.00,0.00,1396.70,449737.40,485638.40,35901.00,547794),('1','144','187558','360',322.00,352.00,0.00,1610.30,518516.60,552575.60,34059.00,548387),('1','144','187782','360',322.00,352.00,0.00,1692.60,545017.20,577695.20,32678.00,548981),('1','144','188000','360',322.00,352.00,0.00,1958.90,630765.80,669778.80,39013.00,549544),('1','144','188195','360',322.00,352.00,0.00,1351.20,435086.40,462622.40,27536.00,550060),('1','144','188406','360',322.00,352.00,0.00,1197.90,385723.80,411660.80,25937.00,550604),('1','144','188593','360',322.00,352.00,0.00,7755.90,2497399.80,2580076.80,82677.00,551075),('1','144','188792','360',322.00,352.00,0.00,5537.00,1782914.00,1835684.00,52770.00,551606),('1','144','188991','360',322.00,352.00,0.00,3057.50,984515.00,1028440.00,43925.00,552125),('1','144','189189','360',322.00,352.00,0.00,1815.40,584558.80,621820.80,37262.00,552646),('1','144','189406','360',322.00,352.00,0.00,1901.60,612315.20,647613.20,35298.00,553216),('1','144','189604','360',322.00,352.00,0.00,1962.40,631892.80,665964.80,34072.00,553725),('1','144','189816','360',322.00,352.00,0.00,4743.70,1527471.40,1579442.40,51971.00,554259),('1','144','190023','360',322.00,352.00,0.00,3431.30,1104878.60,1154417.60,49539.00,554814),('1','144','190211','360',322.00,352.00,0.00,2934.50,944909.00,997144.00,52235.00,555298),('1','144','190421','360',322.00,352.00,0.00,3412.90,1098953.80,1157040.80,58087.00,555855),('1','144','190660','360',322.00,352.00,0.00,3430.00,1104460.00,1166760.00,62300.00,556495),('1','144','190877','360',322.00,352.00,0.00,3901.90,1256411.80,1311198.80,54787.00,557061),('1','144','191066','360',322.00,352.00,0.00,3785.60,1218963.20,1268831.20,49868.00,557549),('1','144','191277','360',322.00,352.00,0.00,3390.20,1091644.40,1138290.40,46646.00,558110),('1','144','191486','360',322.00,352.00,0.00,2934.70,944973.40,985014.40,40041.00,558663),('1','144','191710','360',322.00,352.00,0.00,1612.90,519353.80,549740.80,30387.00,559250),('1','144','191922','360',322.00,352.00,0.00,3662.80,1179421.60,1226805.60,47384.00,559830),('1','144','192124','360',322.00,352.00,0.00,1539.10,495590.20,525513.20,29923.00,560359),('1','144','192329','360',322.00,352.00,0.00,2385.90,768259.80,807980.80,39721.00,560894),('1','144','192650','360',315.50,352.00,0.00,2840.60,896209.30,958041.20,61831.90,561725),('1','144','192747','360',315.50,352.00,0.00,3502.20,1104944.10,1173832.40,68888.30,561990),('1','144','192950','360',315.50,352.00,0.00,4902.80,1546833.40,1653843.60,107010.20,562514),('1','144','193164','360',315.50,352.00,0.00,1599.40,504610.70,553988.80,49378.10,563079),('1','144','193394','360',315.50,352.00,0.00,1709.30,539284.15,586673.60,47389.45,563693),('1','144','193618','360',315.50,352.00,0.00,5807.90,1832392.45,1940780.80,108388.35,564275),('1','144','193842','360',315.50,352.00,0.00,4242.00,1339426.00,1416025.00,76599.00,564832),('1','144','194069','360',315.50,348.00,0.00,2830.20,892928.10,945045.60,52117.50,565398),('1','144','194276','360',315.50,348.00,0.00,5262.90,1660444.95,1742379.20,81934.25,565947),('1','144','194470','360',315.50,348.00,0.00,1711.50,539978.25,586602.00,46623.75,566429),('1','144','194657','360',315.50,348.00,0.00,16562.20,5404811.00,5338861.60,-65949.40,566906),('1','144','194897','360',312.50,348.00,0.00,1946.20,608187.50,659277.60,51090.10,567528),('1','144','195067','360',312.50,348.00,0.00,3117.70,974281.25,1056559.60,82278.35,567984),('1','144','195290','360',312.50,348.00,0.00,4069.00,1271562.50,1372412.00,100849.50,568563),('1','144','195506','360',312.50,348.00,0.00,2207.30,689781.25,751140.40,61359.15,569116),('1','144','195762','360',312.50,348.00,0.00,3357.50,1049218.75,1124910.00,75691.25,569749),('1','144','195995','360',312.50,348.00,0.00,4581.90,1431843.75,1511863.20,80019.45,570340),('1','144','196211','360',312.50,348.00,0.00,2486.60,777062.50,841836.80,64774.30,570877),('1','144','196524','360',312.50,348.00,0.00,2835.60,886125.00,952288.80,66163.80,571679),('1','144','196650','360',312.50,348.00,0.00,2610.50,815781.25,896454.00,80672.75,572015),('1','144','196866','360',312.50,348.00,0.00,1430.70,447093.75,485383.60,38289.85,572579),('1','144','197014','360',312.50,348.00,0.00,2657.80,830562.50,893414.40,62851.90,572964),('1','144','197327','360',312.50,348.00,0.00,2429.00,759062.50,813842.00,54779.50,573783),('1','144','197422','360',312.50,348.00,0.00,13660.56,4268925.00,4451054.88,182129.88,573940),('1','144','197504','360',312.50,348.00,0.00,3721.10,1162843.75,1240338.80,77495.05,574143),('1','144','197858','360',312.50,348.00,0.00,4725.60,1476750.00,1579808.80,103058.80,575089),('1','144','198105','360',312.50,348.00,0.00,2721.90,850593.75,927121.20,76527.45,575728),('1','144','198337','360',312.50,348.00,0.00,2772.60,866437.50,946864.80,80427.30,576331),('1','144','198554','360',312.50,348.00,0.00,2983.10,932218.75,1019918.80,87700.05,576902),('1','144','198770','360',312.50,348.00,0.00,2080.10,650031.25,718874.80,68843.55,577423),('1','144','198973','360',312.50,348.00,0.00,4295.60,1342375.00,1442968.80,100593.80,577956),('1','144','199409','360',312.50,348.00,0.00,1000.00,312500.00,326000.00,13500.00,579033),('1','144','199632','360',312.00,280.00,0.00,0.00,0.00,0.00,0.00,579608),('1','144','199634','360',312.00,280.00,0.00,0.00,0.00,0.00,0.00,579612),('1','144','199636','360',312.00,280.00,0.00,0.00,0.00,0.00,0.00,579616),('1','144','199640','360',312.00,280.00,0.00,0.00,0.00,0.00,0.00,579624),('1','144','199644','360',312.00,280.00,0.00,0.00,0.00,0.00,0.00,579632),('1','144','199647','360',312.00,300.00,0.00,0.00,0.00,0.00,0.00,579635),('1','144','199650','360',312.00,320.00,0.00,0.00,0.00,0.00,0.00,579640),('1','144','199655','360',312.00,320.00,0.00,0.00,0.00,0.00,0.00,579650),('1','144','199656','360',312.00,320.00,0.00,0.00,0.00,0.00,0.00,579651),('1','144','199658','360',312.00,320.00,0.00,0.00,0.00,0.00,0.00,579655),('1','144','199662','360',312.00,320.00,0.00,0.00,0.00,0.00,0.00,579659),('1','144','199665','360',312.00,320.00,0.00,0.00,0.00,0.00,0.00,579664),('1','144','199668','360',312.00,320.00,0.00,0.00,0.00,0.00,0.00,579669),('1','144','199673','360',312.00,352.00,0.00,0.00,0.00,0.00,0.00,579678),('1','144','199676','360',312.00,316.00,0.00,0.00,0.00,0.00,0.00,579682),('1','144','199678','360',312.00,332.00,0.00,0.00,0.00,0.00,0.00,579684),('1','144','199679','360',312.00,352.00,0.00,0.00,0.00,0.00,0.00,579685),('1','144','199684','360',312.00,352.00,0.00,0.00,0.00,0.00,0.00,579695),('1','144','199689','360',312.00,348.00,0.00,0.00,0.00,0.00,0.00,579708),('1','144','199695','360',312.00,352.00,0.00,0.00,0.00,0.00,0.00,579723),('1','144','199697','360',312.00,352.00,0.00,0.00,0.00,0.00,0.00,579727),('1','144','199701','360',312.00,352.00,0.00,0.00,0.00,0.00,0.00,579737),('1','144','199703','360',312.00,352.00,0.00,0.00,0.00,0.00,0.00,579741),('1','144','199706','360',312.00,352.00,0.00,0.00,0.00,0.00,0.00,579748),('1','144','199707','360',312.00,352.00,0.00,0.00,0.00,0.00,0.00,579749),('1','144','199715','360',312.00,348.00,0.00,0.00,0.00,0.00,0.00,579771),('1','144','199722','360',312.00,348.00,0.00,0.00,0.00,0.00,0.00,579787),('1','144','199728','360',312.00,348.00,0.00,0.00,0.00,0.00,0.00,579801),('1','144','199732','360',312.00,348.00,0.00,0.00,0.00,0.00,0.00,579811),('1','144','200889','360',312.00,348.00,0.00,4948.00,1543776.00,1650744.00,106968.00,582829),('1','144','200892','360',312.00,348.00,0.00,1522.00,474864.00,522656.00,47792.00,582836),('1','144','200893','360',312.00,348.00,0.00,6817.00,2126904.00,2264306.00,137402.00,582837),('1','144','200894','360',312.00,348.00,0.00,2328.00,726336.00,794344.00,68008.00,582838),('1','144','200896','360',312.00,348.00,0.00,2747.00,857064.00,931956.00,74892.00,582842),('1','144','200898','360',312.00,348.00,0.00,3191.00,995592.00,1084468.00,88876.00,582846),('1','144','200899','360',312.00,348.00,0.00,2703.00,843336.00,910944.00,67608.00,582847),('1','144','200907','360',312.00,348.00,0.00,0.00,0.00,0.00,0.00,582865),('1','144','200908','360',312.00,348.00,0.00,878.00,273936.00,300244.00,26308.00,582866),('1','144','200947','360',312.00,348.00,0.00,3191.40,995716.80,1081257.20,85540.40,582945),('1','144','201098','360',312.00,348.00,0.00,6872.00,2144064.00,2278956.00,134892.00,583351),('1','144','201298','360',312.00,348.00,0.00,1956.70,610490.40,673931.60,63441.20,583865),('1','144','201488','360',312.00,348.00,0.00,9263.90,2890336.80,3045687.20,155350.40,584363),('1','144','201757','360',312.00,348.00,0.00,2071.00,646152.00,695688.00,49536.00,585074),('1','144','202017','360',312.00,348.00,0.00,0.00,0.00,0.00,0.00,585763),('1','144','202108','360',312.00,360.00,0.00,3623.00,1130376.00,1259880.00,129504.00,585988),('1','144','202207','360',312.00,360.00,0.00,3995.10,1246471.20,1378236.00,131764.80,586244),('1','144','202416','360',312.00,360.00,0.00,2089.00,651768.00,732940.00,81172.00,586780),('1','144','202633','360',312.00,360.00,0.00,5540.00,1728480.00,1881812.00,153332.00,587337),('1','144','202846','360',312.00,360.00,0.00,1617.00,504504.00,564520.00,60016.00,587884),('1','144','203106','360',312.00,360.00,0.00,4732.00,1476384.00,1608480.00,132096.00,588558),('1','144','203294','360',312.00,360.00,0.00,2685.00,837720.00,924690.00,86970.00,589063),('1','144','203552','360',312.00,360.00,0.00,0.00,0.00,0.00,0.00,589701),('1','144','203564','360',318.00,360.00,0.00,3103.00,986754.00,1084774.00,98020.00,589730),('1','144','203717','360',318.00,360.00,0.00,3260.50,1036839.00,1127280.00,90441.00,590141),('1','144','203952','360',318.00,360.00,0.00,2411.00,766698.00,836360.00,69662.00,590746),('1','144','204185','360',318.00,360.00,0.00,6938.00,2206284.00,2356200.00,149916.00,591358),('1','144','204391','360',318.00,360.00,0.00,3081.00,979758.00,1067300.00,87542.00,591887),('1','144','204618','360',318.00,360.00,0.00,5051.50,1606377.00,1707880.00,101503.00,592465),('1','144','204797','360',318.00,360.00,0.00,0.00,0.00,0.00,0.00,592934),('1','144','204798','360',312.00,280.00,0.00,0.00,0.00,0.00,0.00,592935),('1','144','204799','360',312.00,280.00,0.00,0.00,0.00,0.00,0.00,592936),('1','144','204800','360',312.00,280.00,0.00,0.00,0.00,0.00,0.00,592937),('1','144','204801','360',312.00,280.00,0.00,0.00,0.00,0.00,0.00,592938),('1','144','204802','360',312.00,320.00,0.00,0.00,0.00,0.00,0.00,592939),('1','144','204803','360',312.00,320.00,0.00,0.00,0.00,0.00,0.00,592940),('1','144','204804','360',312.00,285.00,0.00,0.00,0.00,0.00,0.00,592941),('1','144','204806','360',312.00,320.00,0.00,0.00,0.00,0.00,0.00,592944),('1','144','204807','360',312.00,320.00,0.00,0.00,0.00,0.00,0.00,592945),('1','144','204808','360',312.00,352.00,0.00,0.00,0.00,0.00,0.00,592946),('1','144','204809','360',312.00,352.00,0.00,0.00,0.00,0.00,0.00,592947),('1','144','204810','360',312.00,352.00,0.00,0.00,0.00,0.00,0.00,592948),('1','144','204811','360',312.00,332.00,0.00,0.00,0.00,0.00,0.00,592949),('1','144','204812','360',312.00,330.00,0.00,0.00,0.00,0.00,0.00,592950),('1','144','204814','360',312.00,332.00,0.00,0.00,0.00,0.00,0.00,592954),('1','144','204815','360',312.00,352.00,0.00,0.00,0.00,0.00,0.00,592955),('1','144','204816','360',312.00,352.00,0.00,0.00,0.00,0.00,0.00,592956),('1','144','204817','360',312.00,352.00,0.00,0.00,0.00,0.00,0.00,592957),('1','144','204818','360',312.00,352.00,0.00,0.00,0.00,0.00,0.00,592958),('1','144','204819','360',312.00,326.00,0.00,0.00,0.00,0.00,0.00,592959),('1','144','204820','360',312.00,326.00,0.00,0.00,0.00,0.00,0.00,592960),('1','144','204821','360',312.00,348.00,0.00,0.00,0.00,0.00,0.00,592961),('1','144','204822','360',312.00,285.00,0.00,0.00,0.00,0.00,0.00,592962),('1','144','204918','360',312.00,360.00,0.00,0.00,0.00,0.00,0.00,593197),('1','144','204938','360',318.00,360.00,0.00,5131.00,1631658.00,1735460.00,103802.00,593246),('1','144','205134','360',318.00,360.00,0.00,5393.00,1714974.00,1835840.00,120866.00,593754),('1','144','205224','360',318.00,360.00,0.00,2542.60,808546.80,885737.60,77190.80,593996),('1','144','205472','360',318.00,360.00,0.00,3017.00,959406.00,1039720.00,80314.00,594625),('1','144','205716','360',318.00,360.00,0.00,2488.00,791184.00,862000.00,70816.00,595270),('1','144','205940','360',318.00,360.00,0.00,3951.00,1256418.00,1351600.00,95182.00,595842),('1','144','206222','360',318.00,360.00,0.00,1567.00,498306.00,537320.00,39014.00,596562),('1','144','206384','360',318.00,360.00,0.00,0.00,0.00,0.00,0.00,596964),('1','144','206387','360',318.00,360.00,0.00,6431.00,2045058.00,2185392.00,140334.00,596971),('1','144','206570','360',318.00,360.00,0.00,6837.00,2174166.00,2344232.00,170066.00,597448),('1','144','206795','360',318.00,360.00,0.00,2674.00,850332.00,929040.00,78708.00,598030),('1','144','207015','360',318.00,360.00,0.00,5876.00,1868568.00,1990200.00,121632.00,598605),('1','144','207346','360',318.00,360.00,0.00,0.00,0.00,0.00,0.00,599449),('1','144','207350','360',322.00,360.00,0.00,4437.00,1428714.00,1516932.00,88218.00,599455),('1','144','207472','360',322.00,360.00,0.00,4406.00,1418732.00,1510960.00,92228.00,599786),('1','144','207794','360',322.00,360.00,0.00,5129.00,1651538.00,1786336.00,134798.00,600589),('1','144','207900','360',322.00,384.00,0.00,4131.00,1330182.00,1501508.00,171326.00,600869),('1','144','208103','360',322.00,384.00,0.00,5031.50,1620143.00,1829971.00,209828.00,601391),('1','144','208430','360',322.00,384.00,0.00,0.00,0.00,0.00,0.00,602226),('1','144','208446','360',334.00,384.00,0.00,4858.00,1622572.00,1711572.00,89000.00,602266),('1','144','208571','360',334.00,384.00,0.00,2682.00,895788.00,989088.00,93300.00,602579),('1','144','208747','360',334.00,384.00,0.00,12048.00,4024032.00,4215834.00,191802.00,603052),('1','144','208992','360',334.00,384.00,0.00,3505.10,1170703.40,1299982.00,129278.60,603663),('1','144','209212','360',334.00,400.00,0.00,1151.20,384500.80,447080.00,62579.20,604225),('1','144','209402','360',334.00,400.00,0.00,0.00,0.00,0.00,0.00,604714),('1','144','209432','360',345.00,400.00,0.00,5418.00,1869210.00,2060740.00,191530.00,604779),('1','144','209633','360',345.00,400.00,0.00,3453.40,1191423.00,1342000.00,150577.00,605303),('1','144','209867','360',345.00,420.00,0.00,2340.30,807403.50,948026.00,140622.50,605899),('1','144','210103','360',345.00,420.00,0.00,2350.94,811074.30,947090.80,136016.50,606518),('1','144','210308','360',345.00,420.00,0.00,5938.64,2048830.80,2320500.80,271670.00,607045),('1','144','210521','360',345.00,420.00,0.00,4555.20,1571544.00,1791614.00,220070.00,607605),('1','144','210808','360',345.00,420.00,0.00,0.00,0.00,0.00,0.00,608357),('1','144','210812','360',370.00,420.00,0.00,2650.30,980611.00,1068610.00,87999.00,608365),('1','144','210958','360',370.00,420.00,0.00,14058.06,5201482.20,5435839.20,234357.00,608740),('1','144','211183','360',370.00,440.00,0.00,3389.60,1254152.00,1430074.00,175922.00,609312),('1','144','211374','360',370.00,440.00,0.00,3464.40,1281828.00,1469436.00,187608.00,609816),('1','144','211600','360',370.00,440.00,0.00,628.70,232619.00,258628.00,26009.00,610411),('1','144','211701','360',370.00,440.00,0.00,0.00,0.00,0.00,0.00,610654),('1','144','211709','360',370.00,440.00,0.00,6069.60,2245752.00,2408479.00,162727.00,610676),('1','144','211779','360',370.00,440.00,0.00,5577.40,2063638.00,2242536.00,178898.00,610856),('1','144','211987','360',370.00,440.00,0.00,2260.62,836429.40,945307.80,108878.40,611396),('1','144','212226','360',370.00,440.00,0.00,3023.94,1118857.80,1256555.10,137697.30,612024),('1','144','212452','360',370.00,440.00,0.00,6821.25,2523862.50,2759875.00,236012.50,612624),('1','144','212824','360',370.00,440.00,0.00,516.70,191179.00,216098.00,24919.00,613607),('1','144','212827','360',370.00,440.00,0.00,0.00,0.00,0.00,0.00,613614),('1','144','212950','360',386.00,440.00,0.00,6617.97,2554536.42,2742066.80,187530.38,613925),('1','144','213127','360',386.00,440.00,0.00,3125.75,1206539.50,1329730.00,123190.50,614395),('1','144','213397','360',386.00,440.00,0.00,4626.52,1785836.72,1926708.80,140872.08,615078),('1','144','213632','360',386.00,440.00,0.00,3671.27,1417110.22,1551858.80,134748.58,615712),('1','144','213880','360',386.00,440.00,0.00,1936.85,747624.10,832714.00,85089.90,616362),('1','144','214086','360',386.00,440.00,0.00,4030.40,1555734.40,1661076.00,105341.60,616901),('1','144','214158','360',386.00,440.00,0.00,0.00,0.00,0.00,0.00,617076),('1','144','214165','360',386.00,440.00,0.00,2492.51,962108.86,1051204.40,89095.54,617093),('1','144','214327','360',386.00,440.00,0.00,6828.96,2635978.56,2842502.40,206523.84,617527),('1','144','214518','360',386.00,440.00,0.00,3786.60,1461627.60,1601104.00,139476.40,618018),('1','144','214769','360',386.00,440.00,0.00,6477.90,2500469.40,2700711.00,200241.60,618673),('1','144','214991','360',386.00,440.00,0.00,3310.10,1277698.60,1411444.00,133745.40,619254),('1','144','215250','360',386.00,440.00,0.00,700.00,270200.00,285600.00,15400.00,619904),('1','144','215406','360',386.00,440.00,0.00,0.00,0.00,0.00,0.00,620321),('1','144','215439','360',386.00,440.00,0.00,8021.24,3096198.64,3325710.60,229511.96,620400),('1','144','215674','360',386.00,440.00,0.00,2883.60,1113069.60,1233394.00,120324.40,621010),('1','144','215904','360',386.00,440.00,0.00,4881.06,1884089.16,2056416.40,172327.24,621592),('1','144','216096','360',386.00,440.00,0.00,9078.43,3515818.98,3759857.20,244038.22,622098),('1','144','216550','360',396.00,440.00,0.00,0.00,0.00,0.00,0.00,623287),('1','144','217008','360',429.00,480.00,0.00,10214.41,4381981.89,4540756.80,158774.91,624491),('1','144','217265','360',429.00,480.00,0.00,2971.95,1274966.55,1359436.00,84469.45,625171),('1','144','217500','360',429.00,480.00,0.00,5800.80,2488543.20,2604884.00,116340.80,625782),('1','144','217703','360',429.00,480.00,0.00,5481.73,2351662.17,2440728.40,89066.23,626311),('1','144','218171','360',429.00,480.00,0.00,0.00,0.00,0.00,0.00,627542),('1','144','218321','360',425.00,480.00,0.00,5011.04,2129692.00,2241773.20,112081.20,627933),('1','144','218444','360',425.00,480.00,0.00,6274.03,2666462.75,2813786.40,147323.65,628257),('1','144','218685','360',425.00,480.00,0.00,3287.30,1397102.50,1478916.00,81813.50,628876),('1','144','218908','360',425.00,480.00,0.00,7804.60,3316955.00,3466952.00,149997.00,629461),('1','144','219148','360',425.00,480.00,0.00,2051.60,871930.00,946768.00,74838.00,630078),('1','144','219306','360',425.00,480.00,0.00,0.00,0.00,0.00,0.00,630512),('1','144','219339','360',425.00,480.00,0.00,7577.81,3220569.25,3368668.80,148099.55,630584),('1','144','219603','360',425.00,480.00,0.00,2790.86,1186115.50,1275772.80,89657.30,631279),('1','144','219798','360',425.00,480.00,0.00,2953.03,1255037.75,1352078.40,97040.65,631801),('1','144','220028','360',425.00,480.00,0.00,8563.38,3639436.50,3817862.40,178425.90,632418),('1','144','220232','360',425.00,480.00,0.00,2722.40,1157020.00,1209882.00,52862.00,632951),('1','144','220445','360',425.00,480.00,0.00,0.00,0.00,0.00,0.00,633515),('1','144','220457','360',425.00,480.00,0.00,10135.30,4307502.50,4495453.00,187950.50,633542),('1','144','220686','360',425.00,480.00,0.00,3804.80,1617040.00,1745744.00,128704.00,634128),('1','144','220919','360',425.00,480.00,0.00,4480.50,1904212.50,2025160.00,120947.50,634731),('1','144','221129','360',425.00,480.00,0.00,6227.44,2646662.00,2778109.20,131447.20,635287),('1','144','221358','360',425.00,480.00,0.00,0.00,0.00,0.00,0.00,635886),('1','144','221384','360',425.00,480.00,0.00,6161.00,2618425.00,2757580.00,139155.00,635950),('1','144','221604','360',425.00,480.00,0.00,7559.20,3212660.00,3384818.00,172158.00,636532),('1','144','221817','360',425.00,480.00,0.00,5311.70,2257472.50,2403136.00,145663.50,637087),('1','144','222050','360',425.00,480.00,0.00,5555.70,2361172.50,2464236.00,103063.50,637693),('1','144','222246','360',425.00,480.00,0.00,0.00,0.00,0.00,0.00,638188),('1','144','222362','360',429.00,480.00,0.00,3980.00,1707420.00,1768460.00,61040.00,638479),('1','144','222477','360',429.00,480.00,0.00,7731.20,3316684.80,3443226.00,126541.20,638782),('1','144','222719','360',429.00,480.00,0.00,3811.40,1635090.60,1733772.00,98681.40,639424),('1','144','223050','360',429.00,480.00,0.00,5548.30,2380220.70,2478828.00,98607.30,640302),('1','144','223162','360',429.00,480.00,0.00,3510.70,1569244.30,1613214.40,43970.10,640595),('1','144','223369','360',449.00,496.00,0.00,0.00,0.00,0.00,0.00,641098),('1','144','223405','360',449.00,496.00,0.00,9022.20,4050967.80,4146604.80,95637.00,641188),('1','144','223631','360',449.00,496.00,0.00,11060.80,4966299.20,5157689.60,191390.40,641760),('1','144','223865','360',449.00,496.00,0.00,4467.30,2005817.70,2096755.60,90937.90,642362),('1','144','224029','360',449.00,496.00,0.00,0.00,0.00,0.00,0.00,642789),('1','144','224084','360',449.00,496.00,0.00,5575.60,2503444.40,2622395.20,118950.80,642926),('1','144','224298','360',449.00,520.00,0.00,8220.50,3691004.50,3903322.00,212317.50,643487),('1','144','224520','360',449.00,520.00,0.00,4282.80,1922977.20,2144896.00,221918.80,644080),('1','144','224766','360',449.00,520.00,0.00,5186.70,2328828.30,2588640.00,259811.70,644706),('1','144','225005','360',449.00,520.00,0.00,1327.00,595823.00,660500.00,64677.00,645318),('1','144','225238','360',449.00,500.00,0.00,0.00,0.00,0.00,0.00,645928),('1','144','225308','360',449.00,500.00,0.00,5288.00,2543528.00,2613254.40,69726.40,646074),('1','144','225482','360',481.00,500.00,0.00,5691.60,2737659.60,2815868.00,78208.40,646540),('1','144','225695','360',481.00,500.00,0.00,2852.00,1371812.00,1411580.00,39768.00,647092),('1','144','225962','360',481.00,500.00,0.00,7178.60,3452906.60,3543299.20,90392.60,647798),('1','144','226430','360',481.00,500.00,0.00,3308.00,1591148.00,1635640.00,44492.00,649023),('1','144','226435','360',481.00,500.00,0.00,0.00,0.00,0.00,0.00,649035),('1','144','226718','360',484.00,500.00,0.00,8790.70,4254698.80,4337290.00,82591.20,649751),('1','144','226941','360',484.00,500.00,0.00,6209.70,3005494.80,3071598.00,66103.20,650337),('1','144','227174','360',484.00,500.00,0.00,7372.00,3568048.00,3645100.00,77052.00,650936),('1','144','227576','360',484.00,500.00,0.00,2202.50,1066010.00,1095530.00,29520.00,651979),('1','144','227579','360',484.00,500.00,0.00,0.00,0.00,0.00,0.00,651986),('1','144','227614','360',486.00,520.00,0.00,4640.20,2255137.20,2370294.00,115156.80,652056),('1','144','227875','360',486.00,520.00,0.00,5115.70,2486230.20,2612040.00,125809.80,652729),('1','144','228126','360',486.00,520.00,0.00,4285.50,2082753.00,2191560.00,108807.00,653401),('1','144','228343','360',486.00,520.00,0.00,6180.70,3003820.20,3183484.00,179663.80,653971),('1','144','228536','360',486.00,560.00,0.00,4343.00,2110698.00,2250580.00,139882.00,654449),('1','144','228723','360',486.00,560.00,0.00,0.00,0.00,0.00,0.00,654948),('1','144','228775','360',486.00,560.00,0.00,6830.40,3442521.60,3587804.00,145282.40,655061),('1','144','228952','360',504.00,560.00,0.00,4714.40,2376057.60,2487064.00,111006.40,655508),('1','144','229194','360',504.00,560.00,0.00,3767.50,1898820.00,2008000.00,109180.00,656147),('1','144','229486','360',504.00,568.00,0.00,4300.30,2167351.20,2267852.00,100500.80,656897),('1','144','229637','360',504.00,568.00,0.00,0.00,0.00,0.00,0.00,657306),('1','144','230021','360',524.00,568.00,0.00,9125.60,4781814.40,4903548.80,121734.40,658285),('1','144','230102','360',524.00,568.00,0.00,4900.80,2568019.20,2682220.40,114201.20,658476),('1','144','230274','360',524.00,568.00,0.00,3588.70,1880478.80,1974621.60,94142.80,658937),('1','144','230515','360',524.00,568.00,0.00,6433.44,3371122.56,3490933.92,119811.36,659561),('1','144','230760','360',524.00,568.00,0.00,0.00,0.00,0.00,0.00,660207),('1','144','230770','360',529.00,568.00,0.00,3431.80,1815422.20,1933851.20,118429.00,660228),('1','144','231060','360',529.00,584.00,0.00,3522.71,1863513.59,1988513.04,124999.45,660988),('1','144','231370','360',529.00,584.00,0.00,7680.40,4062931.60,4301393.60,238462.00,661818),('1','144','231625','360',529.00,584.00,0.00,3390.80,1793733.20,1910347.20,116614.00,662492),('1','144','231889','360',529.00,584.00,0.00,5685.70,3007735.30,3193828.80,186093.50,663201),('1','144','232097','360',529.00,584.00,0.00,901.60,476946.40,512374.40,35428.00,663756),('1','144','232299','360',529.00,584.00,0.00,0.00,0.00,0.00,0.00,664284),('1','144','232323','360',545.00,584.00,0.00,5104.10,2781734.50,2875050.40,93315.90,664335),('1','144','232575','360',545.00,584.00,0.00,6161.90,3358235.50,3456441.60,98206.10,665012),('1','144','232874','360',545.00,584.00,0.00,4004.10,2182234.50,2258454.40,76219.90,665780),('1','144','233103','360',545.00,584.00,0.00,3071.80,1674131.00,1721871.20,47740.20,666393),('1','144','233360','360',545.00,624.00,0.00,6300.00,3433500.00,3589683.00,156183.00,667071),('1','144','233562','360',545.00,624.00,0.00,0.00,0.00,0.00,0.00,667601),('1','144','233584','360',578.00,624.00,0.00,4618.00,2669204.00,2677095.00,7891.00,667660),('1','144','233827','360',578.00,624.00,0.00,6598.60,3813990.80,3946676.40,132685.60,668296),('1','144','234045','360',578.00,624.00,0.00,3320.50,1919249.00,2002737.00,83488.00,668863),('1','144','234295','360',578.00,624.00,0.00,3617.40,2090857.20,2175037.60,84180.40,669532),('1','144','234602','360',578.00,624.00,0.00,2565.91,1483095.98,1553441.64,70345.66,670326),('1','144','234811','360',578.00,624.00,0.00,3863.50,2233103.00,2311851.00,78748.00,670900),('1','144','235026','360',578.00,624.00,0.00,0.00,0.00,0.00,0.00,671489),('1','144','235052','360',578.00,624.00,0.00,5918.40,3420835.20,3533186.60,112351.40,671557),('1','144','235314','360',578.00,624.00,0.00,4165.30,2407543.40,2510137.20,102593.80,672221),('1','144','235544','360',578.00,624.00,0.00,5667.40,3275757.20,3395959.60,120202.40,672808),('1','144','235750','360',578.00,624.00,0.00,2366.70,1367952.60,1431620.80,63668.20,673348),('1','144','236425','360',578.00,624.00,0.00,3808.20,2201139.60,2288166.80,87027.20,675140),('1','144','236431','360',578.00,624.00,0.00,2646.10,1529445.80,1603692.60,74246.80,675159),('1','144','236450','360',578.00,624.00,0.00,0.00,0.00,0.00,0.00,675212),('1','144','236491','360',598.00,624.00,0.00,9381.20,5609957.60,5589712.60,-20245.00,675314),('1','144','236716','360',598.00,624.00,0.00,4665.20,2789789.60,2809859.70,20070.10,675897),('1','144','236942','360',598.00,640.00,0.00,6703.60,4008752.80,4133936.00,125183.20,676479),('1','144','237160','360',598.00,640.00,0.00,3811.90,2279516.20,2366336.00,86819.80,677037),('1','144','237339','360',598.00,640.00,0.00,0.00,0.00,0.00,0.00,677501),('1','144','237376','360',598.00,640.00,0.00,8077.50,4830345.00,4950662.00,120317.00,677583),('1','144','237605','360',598.00,640.00,0.00,4473.69,2675266.62,2835225.60,159958.98,678182),('1','144','237859','360',598.00,672.00,0.00,6643.18,3972621.64,4311451.56,338829.92,678852),('1','144','238099','360',598.00,672.00,0.00,5329.96,3187316.08,3487467.12,300151.04,679482),('1','144','238308','360',598.00,672.00,0.00,0.00,0.00,0.00,0.00,680005),('1','144','238340','360',598.00,672.00,0.00,3334.80,1994210.40,2182145.60,187935.20,680087),('1','144','238588','360',598.00,672.00,0.00,6026.00,3603548.00,3918752.00,315204.00,680752),('1','144','238814','360',598.00,672.00,0.00,2368.40,1416303.20,1567061.80,150758.60,681327),('1','144','239088','360',598.00,672.00,0.00,5764.21,3446997.58,3735131.94,288134.36,682015),('1','144','239309','360',598.00,672.00,0.00,5060.71,3026304.58,3283481.12,257176.54,682593),('1','144','239521','360',598.00,672.00,0.00,1818.37,1087385.26,1195944.64,108559.38,683162),('1','144','239719','360',598.00,672.00,0.00,0.00,0.00,0.00,0.00,683678),('1','144','239769','360',608.00,672.00,0.00,7707.51,4686166.08,4980136.72,293970.64,683805),('1','144','239988','360',608.00,672.00,0.00,4929.80,2997318.40,3193125.60,195807.20,684374),('1','144','240191','360',608.00,672.00,0.00,1758.90,1069411.20,1155460.80,86049.60,684899),('1','144','240448','360',608.00,672.00,0.00,1946.33,1183368.64,1283493.76,100125.12,685566),('1','144','240688','360',608.00,672.00,0.00,4546.57,2764314.56,2887971.20,123656.64,686146),('1','144','240966','360',608.00,656.00,0.00,3670.20,2231481.60,2332301.20,100819.60,686896),('1','144','241170','360',608.00,656.00,0.00,0.00,0.00,0.00,0.00,687438),('1','144','241217','360',608.00,656.00,0.00,4188.80,2546790.40,2662912.80,116122.40,687552),('1','144','241585','360',608.00,656.00,0.00,2401.15,1459899.20,1546554.40,86655.20,688520),('1','144','241721','360',608.00,656.00,0.00,4117.80,2503622.40,2608376.80,104754.40,688884),('1','144','241982','360',608.00,656.00,0.00,2424.90,1474339.20,1559694.40,85355.20,689563),('1','144','242187','360',608.00,656.00,0.00,6572.18,3995885.44,4164029.68,168144.24,690105),('1','144','242425','360',608.00,656.00,0.00,2371.60,1441932.80,1524725.60,82792.80,690706),('1','144','242654','360',608.00,656.00,0.00,2260.30,1374262.40,1449996.80,75734.40,691312),('1','144','242859','360',608.00,656.00,0.00,0.00,0.00,0.00,0.00,691844),('1','144','242913','360',602.00,656.00,0.00,6274.30,3777128.60,3957628.80,180500.20,691986),('1','144','243122','360',602.00,656.00,0.00,5445.30,3278070.60,3446496.80,168426.20,692538),('1','144','243361','360',602.00,656.00,0.00,2060.50,1240421.00,1324648.00,84227.00,693164),('1','144','243594','360',602.00,640.00,0.00,2173.90,1308687.80,1365496.00,56808.20,693756),('1','144','243824','360',602.00,640.00,0.00,2506.47,1508894.94,1571567.70,62672.76,694357),('1','144','244046','360',602.00,640.00,0.00,1899.54,1143523.08,1193955.60,50432.52,694918),('1','144','244293','360',602.00,640.00,0.00,4308.10,2593476.20,2651609.00,58132.80,695570),('1','144','244468','360',602.00,640.00,0.00,0.00,0.00,0.00,0.00,696027),('1','144','244518','360',598.00,640.00,0.00,2255.00,1348490.00,1409750.00,61260.00,696151),('1','144','244748','360',598.00,640.00,0.00,3400.70,2033618.60,2099948.00,66329.40,696753),('1','144','244971','360',598.00,640.00,0.00,1909.10,1141641.80,1187804.00,46162.20,697337),('1','144','245216','360',598.00,640.00,0.00,6204.20,3710111.60,3801988.00,91876.40,697964),('1','144','245430','360',598.00,640.00,0.00,2017.80,1206644.40,1272192.00,65547.60,698517),('1','144','245676','360',598.00,640.00,0.00,4801.30,2871177.40,2959202.00,88024.60,699149),('1','144','245982','360',598.00,640.00,0.00,4010.10,2398039.80,2375821.60,-22218.20,699943),('1','144','246139','360',598.00,616.00,0.00,0.00,0.00,0.00,0.00,700359),('1','144','246183','360',560.00,616.00,0.00,3802.40,2129344.00,2234878.40,105534.40,700465),('1','144','246452','360',560.00,616.00,0.00,5332.30,2986088.00,3115296.80,129208.80,701176),('1','144','246696','360',560.00,616.00,0.00,1598.30,895048.00,965832.80,70784.80,701822),('1','144','246930','360',560.00,616.00,0.00,7273.50,4073160.00,4236196.00,163036.00,702421),('1','144','247164','360',560.00,616.00,0.00,2682.50,1502200.00,1602740.00,100540.00,703028),('1','144','247391','360',560.00,616.00,0.00,4189.30,2346008.00,2470008.80,124000.80,703602),('1','144','247604','360',560.00,616.00,0.00,0.00,0.00,0.00,0.00,704164),('1','144','247661','360',560.00,616.00,0.00,2523.80,1413328.00,1506780.80,93452.80,704314),('1','144','247910','360',560.00,616.00,0.00,4756.10,2663416.00,2795857.60,132441.60,704950),('1','144','248149','360',560.00,616.00,0.00,2759.20,1545152.00,1651931.20,106779.20,705571),('1','144','248393','360',560.00,616.00,0.00,6805.90,3811304.00,3993234.40,181930.40,706204),('1','144','248635','360',560.00,616.00,0.00,2291.10,1283016.00,1373067.60,90051.60,706822),('1','144','248864','360',560.00,616.00,0.00,5538.17,3101375.20,3135158.00,33782.80,707403),('1','144','249055','360',560.00,600.00,0.00,0.00,0.00,0.00,0.00,707910),('1','144','249103','360',542.00,600.00,0.00,2853.00,1546326.00,1638037.60,91711.60,708026),('1','144','249338','360',542.00,600.00,0.00,2633.40,1427302.80,1519256.00,91953.20,708622),('1','144','249583','360',542.00,600.00,0.00,4193.70,2272985.40,2378860.00,105874.60,709247),('1','144','249849','360',542.00,600.00,0.00,4779.20,2590326.40,2710560.00,120233.60,709930),('1','144','250093','360',542.00,600.00,0.00,2104.20,1140476.40,1221520.00,81043.60,710555),('1','144','250330','360',542.00,600.00,0.00,2577.40,1396950.80,1492840.00,95889.20,711159),('1','144','250559','360',542.00,600.00,0.00,5523.40,2993682.80,3137040.00,143357.20,711738),('1','144','250745','360',542.00,600.00,0.00,0.00,0.00,0.00,0.00,712237),('1','144','250792','360',542.00,600.00,0.00,2400.90,1301287.80,1394540.00,93252.20,712350),('1','144','251032','360',542.00,600.00,0.00,3109.70,1685457.40,1786500.00,101042.60,712957),('1','144','251267','360',542.00,600.00,0.00,2500.95,1355514.90,1453356.00,97841.10,713579),('1','144','251513','360',542.00,600.00,0.00,2247.90,1166668.20,1302740.00,136071.80,714222),('1','144','251753','360',518.00,600.00,0.00,5297.80,2744260.40,2999740.00,255479.60,714856),('1','144','251985','360',518.00,600.00,0.00,2572.90,1332762.20,1487240.00,154477.80,715468),('1','144','252233','360',518.00,600.00,0.00,3537.00,1832166.00,2030600.00,198434.00,716114),('1','144','252474','360',518.00,600.00,0.00,2866.18,1484681.24,1657948.00,173266.76,716732),('1','144','252661','360',518.00,600.00,0.00,0.00,0.00,0.00,0.00,717221),('1','144','252708','360',518.00,600.00,0.00,3246.07,1681464.26,1874122.00,192657.74,717342),('1','144','252963','360',518.00,600.00,0.00,4725.10,2447601.80,2684200.00,236598.20,718001),('1','144','253195','360',523.00,600.00,0.00,5848.93,3058990.39,3320758.00,261767.61,718622),('1','144','253492','360',523.00,600.00,0.00,1902.60,995059.80,1109960.00,114900.20,719369),('1','144','253708','360',523.00,600.00,0.00,2567.50,1342802.50,1491320.00,148517.50,719940),('1','144','253961','360',523.00,600.00,0.00,6280.10,3284492.30,3564540.00,280047.70,720585),('1','144','254150','360',523.00,600.00,0.00,0.00,0.00,0.00,0.00,721093),('1','144','254193','360',523.00,600.00,0.00,3966.30,2074374.90,2256220.00,181845.10,721198),('1','144','254448','360',523.00,600.00,0.00,3471.80,1815751.40,1994840.00,179088.60,721858),('1','144','254756','360',523.00,600.00,0.00,3161.80,1653621.40,1816112.00,162490.60,722609),('1','144','254953','360',523.00,600.00,0.00,9185.90,4804225.70,5155336.00,351110.30,723133),('1','144','255196','360',523.00,600.00,0.00,2465.50,1289456.50,1424700.00,135243.50,723763),('1','144','255467','360',523.00,600.00,0.00,2344.70,1226278.10,1361220.00,134941.90,724432),('1','144','255667','360',523.00,600.00,0.00,0.00,0.00,0.00,0.00,724928),('1','144','255710','360',523.00,600.00,0.00,2410.40,1260639.20,1401840.00,141200.80,725039),('1','144','255952','360',523.00,600.00,0.00,6486.50,3392439.50,3643000.00,250560.50,725649),('1','144','256382','360',523.00,600.00,0.00,3081.64,1611697.72,1750544.00,138846.28,726733),('1','144','256492','360',523.00,600.00,0.00,4416.75,2309960.25,2514386.00,204425.75,727021),('1','144','256730','360',523.00,600.00,0.00,7660.74,4006567.02,4346988.40,340421.38,727631),('1','144','256916','360',523.00,600.00,0.00,0.00,0.00,0.00,0.00,728130),('1','144','256969','360',523.00,600.00,0.00,3280.70,1715806.10,1885964.00,170157.90,728262),('1','144','257243','360',523.00,600.00,0.00,3021.50,1580244.50,1756372.00,176127.50,728973),('1','144','257499','360',523.00,600.00,0.00,2867.98,1499953.54,1678256.80,178303.26,729643),('1','144','257500','360',523.00,600.00,0.00,3230.64,1689624.72,1852420.40,162795.68,729644),('1','144','257501','360',523.00,600.00,0.00,6661.90,3484173.70,3774820.00,290646.30,729645),('1','144','257502','360',523.00,600.00,0.00,3068.60,1604877.80,1770280.00,165402.20,729646),('1','144','257503','360',523.00,600.00,0.00,2463.25,1288279.75,1440350.00,152070.25,729647),('1','144','257504','360',523.00,600.00,0.00,0.00,0.00,0.00,0.00,729648),('1','144','257505','360',523.00,600.00,0.00,8168.10,4271916.30,4591288.00,319371.70,729649),('1','144','257506','360',523.00,600.00,0.00,3186.60,1666591.80,1845960.00,179368.20,729650),('1','144','257507','360',523.00,600.00,0.00,5313.90,2779169.70,3024740.00,245570.30,729651),('1','144','257508','360',523.00,600.00,0.00,2823.80,1476847.40,1626680.00,149832.60,729652),('1','144','257509','360',523.00,600.00,0.00,5160.00,2698680.00,2928180.40,229500.40,729653),('1','144','257510','360',523.00,600.00,0.00,0.00,0.00,0.00,0.00,729654),('1','144','257511','360',523.00,600.00,0.00,1958.60,1024347.80,1140420.00,116072.20,729655),('1','144','257512','360',523.00,600.00,0.00,2802.40,1465655.20,1605240.00,139584.80,729656),('1','144','257513','360',523.00,600.00,0.00,1998.00,1044954.00,1161520.00,116566.00,729657),('1','144','257514','360',523.00,600.00,0.00,5489.00,2870747.00,3113220.00,242473.00,729658),('1','144','257515','360',523.00,600.00,0.00,5673.90,2967449.70,3216030.00,248580.30,729659),('1','144','257516','360',523.00,600.00,0.00,2012.90,1052746.70,1172140.00,119393.30,729660),('1','144','257517','360',523.00,600.00,0.00,4711.50,2464114.50,2669100.00,204985.50,729661),('1','144','257518','360',523.00,600.00,0.00,0.00,0.00,0.00,0.00,729662),('1','144','257519','360',523.00,600.00,0.00,3683.99,1926726.77,2094597.24,167870.47,729663),('1','144','257520','360',523.00,600.00,0.00,4867.40,2545650.20,2759760.00,214109.80,729664),('1','144','257521','360',523.00,600.00,0.00,1434.15,750060.45,836890.00,86829.55,729665),('1','144','257522','360',523.00,580.00,0.00,2920.80,1527578.40,1637664.00,110085.60,729666),('1','144','257523','360',523.00,580.00,0.00,5419.30,2834293.90,3003644.00,169350.10,729667),('1','144','257524','360',523.00,580.00,0.00,2440.70,1276486.10,1377716.00,101229.90,729668),('1','144','257525','360',523.00,580.00,0.00,3821.70,1998749.10,2127286.00,128536.90,729669),('1','144','257526','360',523.00,580.00,0.00,0.00,0.00,0.00,0.00,729670),('1','144','257527','360',523.00,580.00,0.00,2178.50,1139355.50,1231130.00,91774.50,729671),('1','144','257528','360',523.00,580.00,0.00,1617.40,845900.20,923092.00,77191.80,729672),('1','144','257529','360',523.00,580.00,0.00,2203.20,1152273.60,1245186.00,92912.40,729673),('1','144','257530','360',523.00,580.00,0.00,4659.50,2436918.50,2586635.00,149716.50,729674),('1','144','257531','360',523.00,580.00,0.00,2150.80,1146376.40,1232267.20,85890.80,729675),('1','144','257532','360',533.00,584.00,0.00,1954.70,1041855.10,1119424.80,77569.70,729676),('1','144','257533','360',533.00,584.00,0.00,5509.60,2936616.80,3076646.40,140029.60,729677),('1','144','257534','360',533.00,584.00,0.00,4235.60,2257574.80,2379570.40,121995.60,729678),('1','144','257535','360',533.00,584.00,0.00,0.00,0.00,0.00,0.00,729679),('1','144','257536','360',533.00,584.00,0.00,3029.20,1614563.60,1714540.80,99977.20,729680),('1','144','257537','360',533.00,584.00,0.00,2867.60,1528430.80,1629878.40,101447.60,729681),('1','144','257538','360',533.00,584.00,0.00,5064.20,2699218.60,2840932.80,141714.20,729682),('1','144','257539','360',533.00,584.00,0.00,2932.20,1562862.60,1675892.80,113030.20,729683),('1','144','257540','360',533.00,584.00,0.00,3264.90,1740191.70,1843301.60,103109.90,729684),('1','144','257541','360',533.00,584.00,0.00,7206.20,3840904.60,4019580.80,178676.20,729685),('1','144','257542','360',533.00,584.00,0.00,0.00,0.00,0.00,0.00,729686),('1','144','257543','360',533.00,584.00,0.00,1863.61,993304.13,1170193.98,176889.85,729687),('1','144','257544','360',533.00,650.00,0.00,1318.10,702547.30,849765.00,147217.70,729688),('1','144','257545','360',533.00,650.00,0.00,2574.60,1372261.80,1644490.00,272228.20,729689),('1','144','257546','360',533.00,650.00,0.00,3181.90,1695952.70,2022355.00,326402.30,729690),('1','144','257547','360',533.00,650.00,0.00,2491.20,1327809.60,1595180.00,267370.40,729691),('1','144','257548','360',533.00,650.00,0.00,1882.35,1003292.55,1211950.50,208657.95,729692),('1','144','257549','360',630.00,680.00,0.00,6517.30,4105899.00,4158524.00,52625.00,729693),('1','144','257550','360',630.00,680.00,0.00,4748.70,2991681.00,3106316.00,114635.00,729694),('1','144','257551','360',630.00,680.00,0.00,0.00,0.00,0.00,0.00,729695),('1','144','257552','360',630.00,680.00,0.00,2474.50,1558935.00,1635760.00,76825.00,729696),('1','144','257553','360',630.00,680.00,0.00,4101.40,2583882.00,2687682.00,103800.00,729697),('1','144','257554','360',630.00,680.00,0.00,1807.50,1138725.00,1209600.00,70875.00,729698),('1','144','257555','360',630.00,680.00,0.00,2935.60,1849428.00,1959233.00,109805.00,729699),('1','144','257556','360',620.00,680.00,0.00,2797.50,1734450.00,1844500.00,110050.00,729700),('1','144','257557','360',620.00,680.00,0.00,7687.70,4766374.00,4939986.00,173612.00,729701),('1','144','257558','360',620.00,680.00,0.00,2672.37,1656869.40,1748736.80,91867.40,729702),('1','144','257559','360',620.00,680.00,0.00,440.68,273221.60,299662.40,26440.80,729703),('1','144','257560','360',620.00,660.00,0.00,1973.60,1223632.00,1283091.00,59459.00,729704),('1','144','257561','360',620.00,660.00,0.00,1940.20,1202924.00,1257732.00,54808.00,729705),('1','144','257562','360',620.00,660.00,0.00,1973.10,1223322.00,1284246.00,60924.00,729706),('1','144','257563','360',620.00,660.00,0.00,8358.60,5182332.00,5293276.00,110944.00,729707),('1','144','257564','360',632.00,670.00,0.00,2277.20,1439190.40,1504124.00,64933.60,729708),('1','144','257565','360',632.00,670.00,0.00,2857.90,1806192.80,1874993.00,68800.20,729709),('1','144','257566','360',632.00,670.00,0.00,4494.90,2840776.80,2942983.00,102206.20,729710),('1','144','257567','360',632.00,670.00,0.00,0.00,0.00,0.00,0.00,729711),('1','144','257568','360',632.00,670.00,0.00,5379.90,3400096.80,3535313.00,135216.20,729712),('1','144','257569','360',632.00,670.00,0.00,4978.60,3146475.20,3296164.00,149688.80,729713),('1','144','257570','360',632.00,670.00,0.00,6361.30,4020341.60,4169011.00,148669.40,729714),('1','144','257571','360',632.00,670.00,0.00,7900.90,4993368.80,5137203.00,143834.20,729715),('1','144','257572','360',632.00,670.00,0.00,0.00,0.00,0.00,0.00,729716),('1','144','257573','360',632.00,670.00,0.00,3575.06,2259437.92,2342360.20,82922.28,729717),('1','144','257574','360',632.00,670.00,0.00,2304.75,1456602.00,1523348.50,66746.50,729718),('1','144','257575','360',632.00,670.00,0.00,7374.50,4660684.00,4795395.00,134711.00,729719),('1','144','257576','360',632.00,670.00,0.00,2556.10,1615455.20,1683841.00,68385.80,729720),('1','144','257577','360',632.00,670.00,0.00,2625.44,1659278.08,1732019.84,72741.76,729721),('1','144','257578','360',632.00,670.00,0.00,4999.00,3159368.00,3268290.00,108922.00,729722),('1','144','257579','360',632.00,670.00,0.00,961.44,607630.08,632964.80,25334.72,729723),('1','144','257580','360',632.00,670.00,0.00,0.00,0.00,0.00,0.00,729724),('1','144','257581','360',632.00,670.00,0.00,5623.90,3554304.80,3648713.00,94408.20,729725),('1','144','257582','360',632.00,670.00,0.00,2102.80,1328969.60,1383562.00,54592.40,729726),('1','144','257583','360',632.00,670.00,0.00,2894.70,1829450.40,1901229.00,71778.60,729727),('1','144','257584','360',632.00,670.00,0.00,3814.90,2411016.80,2495183.00,84166.20,729728),('1','144','257585','360',632.00,670.00,0.00,2082.11,1315893.52,1372880.66,56987.14,729729),('1','144','257586','360',632.00,670.00,0.00,5328.60,3367675.20,3476142.00,108466.80,729730),('1','144','257587','360',632.00,670.00,0.00,2739.80,1704155.60,1803716.00,99560.40,729731),('1','144','257588','360',622.00,670.00,0.00,0.00,0.00,0.00,0.00,729732),('1','144','257589','360',622.00,670.00,0.00,1366.70,850087.40,906549.00,56461.60,729733),('1','144','257590','360',622.00,670.00,0.00,1502.79,934735.38,995629.30,60893.92,729734),('1','144','257591','360',622.00,670.00,0.00,5561.00,3458942.00,3626000.00,167058.00,729735),('1','144','257592','360',622.00,670.00,0.00,1666.20,1036376.40,1104354.00,67977.60,729736),('1','144','257593','360',622.00,670.00,0.00,4881.30,3036168.60,3180031.00,143862.40,729737),('1','144','257594','360',622.00,670.00,0.00,2038.80,1268133.60,1351396.00,83262.40,729738),('1','144','257595','360',622.00,670.00,0.00,2426.57,1509326.54,1599091.90,89765.36,729739),('1','144','257596','360',622.00,670.00,0.00,3242.18,2016635.96,2117200.60,100564.64,729740),('1','144','257597','360',622.00,670.00,0.00,2004.70,1246923.40,1313909.00,66985.60,729741),('1','144','257598','360',622.00,670.00,0.00,0.00,0.00,0.00,0.00,729742),('1','144','257599','360',622.00,670.00,0.00,2599.40,1616826.80,1715998.00,99171.20,729743),('1','144','257600','360',622.00,670.00,0.00,6346.77,3947690.94,4134159.90,186468.96,729744),('1','144','257601','360',622.00,670.00,0.00,2884.97,1794451.34,1903529.90,109078.56,729745),('1','144','257602','360',622.00,670.00,0.00,3151.40,1960170.80,2078806.00,118635.20,729746),('1','144','257603','360',622.00,670.00,0.00,4948.93,3078234.46,3222563.10,144328.64,729747),('1','144','257604','360',622.00,670.00,0.00,2003.13,1245946.86,1328097.10,82150.24,729748),('1','144','257605','360',622.00,670.00,0.00,2659.99,1654513.78,1747240.30,92726.52,729749),('1','144','257606','360',622.00,670.00,0.00,0.00,0.00,0.00,0.00,729750),('1','144','257607','360',622.00,670.00,0.00,3140.06,1953117.32,2055448.20,102330.88,729751),('1','144','257608','360',622.00,670.00,0.00,4844.44,3013241.68,3165200.80,151959.12,729752),('1','144','257609','360',622.00,670.00,0.00,6023.62,3746691.64,3929925.40,183233.76,729753),('1','144','257610','360',622.00,670.00,0.00,3340.40,2077728.80,2212748.00,135019.20,729754),('1','144','257611','360',622.00,670.00,0.00,3837.22,2386750.84,2519737.40,132986.56,729755),('1','144','257612','360',622.00,670.00,0.00,3437.48,2138112.56,2265117.40,127004.84,729756),('1','144','257613','360',622.00,670.00,0.00,0.00,0.00,0.00,0.00,729757),('1','144','257614','360',622.00,670.00,0.00,2801.83,1742738.26,1839063.30,96325.04,729758),('1','144','257615','360',622.00,670.00,0.00,7990.96,4970377.12,5194483.20,224106.08,729759),('1','144','257616','360',622.00,670.00,0.00,2640.60,1642453.20,1733102.00,90648.80,729760),('1','144','257617','360',622.00,670.00,0.00,4711.54,2930577.88,3075018.76,144440.88,729761),('1','144','257618','360',622.00,670.00,0.00,1299.10,808040.20,930155.60,122115.40,729762),('1','144','257619','360',622.00,716.00,0.00,2028.50,1261727.00,1370806.00,109079.00,729763),('1','144','257620','360',622.00,716.00,0.00,1064.60,662181.20,731673.60,69492.40,729764),('1','144','257621','360',622.00,716.00,0.00,118.50,73707.00,84846.00,11139.00,729765),('1','144','257622','360',622.00,716.00,0.00,0.00,0.00,0.00,0.00,729766),('1','144','257623','360',622.00,716.00,0.00,890.00,553580.00,553580.00,0.00,729767),('1','144','257624','360',692.00,750.00,0.00,6069.10,4199817.20,4390465.00,190647.80,729768),('1','144','257625','360',692.00,750.00,0.00,5937.03,4108424.76,4299662.50,191237.74,729769),('1','144','257626','360',692.00,750.00,0.00,3698.98,2559694.16,2698095.00,138400.84,729770),('1','144','257627','360',692.00,750.00,0.00,3124.55,2162188.60,2291962.50,129773.90,729771),('1','144','257628','360',692.00,750.00,0.00,5342.04,3696691.68,3878630.00,181938.32,729772),('1','144','257629','360',692.00,750.00,0.00,0.00,0.00,0.00,0.00,729773),('1','144','257630','360',692.00,750.00,0.00,3698.98,2559694.16,2693429.00,133734.84,729774),('1','144','257631','360',692.00,750.00,0.00,3364.17,2328005.64,2464157.50,136151.86,729775),('1','144','257632','360',692.00,750.00,0.00,3469.94,2401198.48,2539195.00,137996.52,729776),('1','144','257633','360',692.00,750.00,0.00,4396.13,3042121.96,3205000.70,162878.74,729777),('1','144','257634','360',692.00,750.00,0.00,3750.78,2595539.76,2750735.00,155195.24,729778),('1','144','257635','360',692.00,750.00,0.00,5971.90,4132554.80,4325371.00,192816.20,729779),('1','144','257636','360',692.00,750.00,0.00,0.00,0.00,0.00,0.00,729780),('1','144','257637','360',692.00,750.00,0.00,4396.13,3042121.96,3187683.50,145561.54,729781),('1','144','257638','360',692.00,750.00,0.00,1751.16,1211802.72,1292370.00,80567.28,729782),('1','144','257639','360',692.00,750.00,0.00,5400.03,3736820.76,3902384.50,165563.74,729783),('1','144','257640','360',692.00,780.00,0.00,2567.82,1776931.44,1929499.60,152568.16,729784),('1','144','257641','360',692.00,780.00,0.00,2305.74,1595572.08,1745537.20,149965.12,729785),('1','144','257642','360',692.00,780.00,0.00,3721.05,2574966.60,2797939.00,222972.40,729786),('1','144','257643','360',692.00,780.00,0.00,4289.51,2968340.92,3219297.80,250956.88,729787),('1','144','257644','360',692.00,780.00,0.00,0.00,0.00,0.00,0.00,729788),('1','144','257645','360',692.00,780.00,0.00,6498.59,4497024.28,4834674.60,337650.32,729789),('1','144','257646','360',692.00,780.00,0.00,2212.52,1531063.84,1664965.60,133901.76,729790),('1','144','257647','360',692.00,780.00,0.00,2816.15,1948775.80,2123013.00,174237.20,729791),('1','144','257648','360',692.00,780.00,0.00,2344.66,1622504.72,1791654.80,169150.08,729792),('1','144','257649','360',692.00,780.00,0.00,2867.60,1984379.20,2168648.00,184268.80,729793),('1','144','257650','360',692.00,780.00,0.00,2762.00,1911304.00,2096780.00,185476.00,729794),('1','144','257651','360',692.00,780.00,0.00,5100.00,3529200.00,3802956.00,273756.00,729795),('1','144','257652','360',692.00,780.00,0.00,0.00,0.00,0.00,0.00,729796),('1','144','257653','360',692.00,780.00,0.00,5030.73,3481265.16,3758770.52,277505.36,729797),('1','144','257654','360',692.00,780.00,0.00,2779.70,1923552.40,2129146.00,205593.60,729798),('1','144','257655','360',692.00,780.00,0.00,2998.09,2074678.28,2281521.40,206843.12,729799),('1','144','257656','360',692.00,780.00,0.00,5293.34,3662991.28,3955599.20,292607.92,729800),('1','144','257657','360',692.00,780.00,0.00,2727.39,1887353.88,2069528.20,182174.32,729801),('1','144','257658','360',692.00,780.00,0.00,5544.30,3836655.60,4131013.60,294358.00,729802),('1','144','257659','360',692.00,780.00,0.00,0.00,0.00,0.00,0.00,729803),('1','144','257660','360',692.00,780.00,0.00,6552.80,4534537.60,4887536.00,352998.40,729804),('1','144','257661','360',692.00,780.00,0.00,3954.50,2736514.00,2963034.00,226520.00,729805),('1','144','257662','360',692.00,780.00,0.00,3231.36,2236101.12,2440672.80,204571.68,729806),('1','144','257663','360',692.00,780.00,0.00,2948.74,2040528.08,2232229.20,191701.12,729807),('1','144','257664','360',692.00,780.00,0.00,3416.56,2364259.52,2586096.80,221837.28,729808),('1','144','257665','360',692.00,780.00,0.00,4300.04,2975627.68,3228939.88,253312.20,729809),('1','144','257666','360',692.00,780.00,0.00,0.00,0.00,0.00,0.00,729810),('1','144','257667','360',692.00,780.00,0.00,495.75,343059.00,308356.50,-34702.50,729811),('1','144','257668','360',692.00,780.00,0.00,6178.70,4275660.40,4609541.32,333880.92,729812),('1','144','257669','360',692.00,780.00,0.00,2569.77,1778280.84,1950520.60,172239.76,729813),('1','144','257670','360',692.00,780.00,0.00,4616.20,3194410.40,3457336.00,262925.60,729814),('1','144','257671','360',692.00,780.00,0.00,4930.00,3411560.00,3686320.00,274760.00,729815),('1','144','257672','360',692.00,780.00,0.00,2618.62,1812085.04,1991403.60,179318.56,729816),('1','144','257673','360',692.00,780.00,0.00,1368.23,946815.16,1053219.40,106404.24,729817),('1','144','257674','360',692.00,780.00,0.00,2298.28,1590409.76,1739698.40,149288.64,729818),('1','144','257675','360',692.00,780.00,0.00,0.00,0.00,0.00,0.00,729819),('1','144','257676','360',692.00,780.00,0.00,4020.35,2782082.20,3014425.00,232342.80,729820),('1','144','257677','360',692.00,780.00,0.00,4495.44,3110844.48,3365239.20,254394.72,729821),('1','144','257678','360',692.00,780.00,0.00,2564.69,1774765.48,1942078.20,167312.72,729822),('1','144','257679','360',692.00,780.00,0.00,2197.39,1520593.88,1663276.20,142682.32,729823),('1','144','257680','360',692.00,780.00,0.00,1994.06,1379889.52,1517966.80,138077.28,729824),('1','144','257681','360',692.00,780.00,0.00,5560.14,3847616.88,4142561.20,294944.32,729825),('1','144','257682','360',692.00,780.00,0.00,3800.76,2630125.92,2862448.80,232322.88,729826),('1','144','257683','360',692.00,780.00,0.00,0.00,0.00,0.00,0.00,729827),('1','144','257684','360',692.00,780.00,0.00,5419.90,3750570.80,4014198.00,263627.20,729828),('1','144','257685','360',692.00,780.00,0.00,2135.60,1477835.20,1595808.00,117972.80,729829),('1','144','257686','360',692.00,780.00,0.00,6032.13,4174233.96,4509012.20,334778.24,729830),('1','144','257687','360',692.00,780.00,0.00,4330.77,2996892.84,3247800.60,250907.76,729831),('1','144','257688','360',692.00,780.00,0.00,3963.74,2742908.08,2970557.20,227649.12,729832),('1','144','257689','360',692.00,780.00,0.00,3128.74,2165088.08,2331732.72,166644.64,729833),('1','144','257690','360',692.00,692.00,0.00,0.00,0.00,0.00,0.00,729834),('1','144','257691','360',692.00,780.00,0.00,2207.66,1527700.72,1652125.68,124424.96,729835),('1','144','257692','360',692.00,780.00,0.00,4462.13,3087793.96,3351393.00,263599.04,729836),('1','144','257693','360',692.00,780.00,0.00,2918.66,2019712.72,2208234.80,188522.08,729837),('1','144','257694','360',692.00,780.00,0.00,4374.76,3027333.92,3288648.00,261314.08,729838),('1','144','257695','360',692.00,780.00,0.00,5471.77,3786464.84,4100811.40,314346.56,729839),('1','144','257696','360',692.00,780.00,0.00,2019.88,1397756.96,1545311.60,147554.64,729840),('1','144','257697','360',692.00,780.00,0.00,1094.11,757124.12,853405.80,96281.68,729841),('1','144','257698','360',692.00,780.00,0.00,1398.70,967900.40,1090986.00,123085.60,729842),('1','144','257699','360',692.00,780.00,0.00,634.21,438873.32,494683.80,55810.48,729843),('1','144','257700','360',692.00,780.00,0.00,0.00,0.00,0.00,0.00,729844),('1','144','257701','360',709.00,780.00,0.00,2428.17,1721572.53,1819127.00,97554.47,729845),('1','144','257702','360',709.00,780.00,0.00,5676.86,4024893.74,4268530.80,243637.06,729846),('1','144','257703','360',709.00,780.00,0.00,3418.70,2423858.30,2589986.40,166128.10,729847),('1','144','257704','360',709.00,780.00,0.00,2948.82,2090713.38,2235471.60,144758.22,729848),('1','144','257705','360',709.00,780.00,0.00,3679.48,2608751.32,2784165.60,175414.28,729849),('1','144','257706','360',709.00,780.00,0.00,6112.53,4333783.77,4610856.60,277072.83,729850),('1','144','257707','360',709.00,780.00,0.00,413.50,293171.50,321530.00,28358.50,729851),('1','144','257708','360',709.00,780.00,0.00,0.00,0.00,0.00,0.00,729852),('1','144','257709','360',709.00,780.00,0.00,3103.98,2200721.82,2358984.40,158262.58,729853),('1','144','257710','360',709.00,780.00,0.00,2617.85,1856055.65,2006781.00,150725.35,729854),('1','144','257711','360',709.00,780.00,0.00,4656.09,3301167.81,3508650.20,207482.39,729855),('1','144','257712','360',709.00,780.00,0.00,4532.89,3213819.01,3407770.60,193951.59,729856),('1','144','257713','360',709.00,780.00,0.00,3520.62,2496119.58,2659863.92,163744.34,729857),('1','144','257714','360',709.00,780.00,0.00,2981.61,2113961.49,2259149.40,145187.91,729858),('1','144','257715','360',709.00,780.00,0.00,2838.21,2012290.89,2161643.80,149352.91,729859),('1','144','257716','360',709.00,780.00,0.00,700.72,496810.48,536615.60,39805.12,729860),('1','144','257717','360',709.00,780.00,0.00,2236.50,1585678.50,1678670.00,92991.50,729861),('1','144','257718','360',709.00,780.00,0.00,3360.25,2382417.25,2532795.00,150377.75,729862),('1','144','257719','360',709.00,780.00,0.00,2566.24,1819464.16,1937867.20,118403.04,729863),('1','144','257720','360',709.00,780.00,0.00,2088.36,1480647.24,1617721.20,137073.96,729864),('1','144','257721','360',709.00,780.00,0.00,3324.19,2356850.71,2529028.20,172177.49,729865),('1','144','257722','360',709.00,780.00,0.00,2530.63,1794216.67,1922271.40,128054.73,729866),('1','144','257723','360',709.00,780.00,0.00,2642.59,1873596.31,2014863.00,141266.69,729867),('1','144','257724','360',709.00,780.00,0.00,3435.85,2436017.65,2585562.20,149544.55,729868),('1','144','257725','360',709.00,780.00,0.00,2011.78,1426352.02,1531188.40,104836.38,729869),('1','144','257726','360',709.00,780.00,0.00,707.49,501610.41,534442.20,32831.79,729870),('1','144','257727','360',709.00,780.00,0.00,0.00,0.00,0.00,0.00,729871),('1','144','257728','360',709.00,780.00,0.00,1489.03,1055722.27,1142243.40,86521.13,729872),('1','144','257729','360',709.00,780.00,0.00,2777.21,1969041.89,2104763.80,135721.91,729873),('1','144','257730','360',709.00,780.00,0.00,3362.84,2384253.56,2537794.00,153540.44,729874),('1','144','257731','360',709.00,780.00,0.00,2676.48,1897624.32,2036134.40,138510.08,729875),('1','144','257732','360',709.00,780.00,0.00,2747.47,1947956.23,2110475.40,162519.17,729876),('1','144','257733','360',709.00,780.00,0.00,4031.21,2858127.89,3039063.40,180935.51,729877),('1','144','257734','360',709.00,780.00,0.00,2805.07,1988794.63,2132192.20,143397.57,729878),('1','144','257735','360',709.00,780.00,0.00,3802.44,2695929.96,2869192.00,173262.04,729879),('1','144','257736','360',709.00,780.00,0.00,1155.43,819199.87,882405.40,63205.53,729880),('1','144','257737','360',709.00,780.00,0.00,0.00,0.00,0.00,0.00,729881),('1','144','257738','360',691.00,780.00,0.00,2298.73,1588422.43,1738289.40,149866.97,729882),('1','144','257739','360',691.00,780.00,0.00,3053.47,2109947.77,2318237.00,208289.23,729883),('1','144','257740','360',691.00,780.00,0.00,5310.90,3669831.90,4000086.00,330254.10,729884),('1','144','257741','360',691.00,780.00,0.00,2824.50,1951729.50,2166220.00,214490.50,729885),('1','144','257742','360',691.00,780.00,0.00,3559.36,2459517.76,2687757.60,228239.84,729886),('1','144','257743','360',691.00,780.00,0.00,2044.69,1412880.79,1557898.20,145017.41,729887),('1','144','257744','360',691.00,780.00,0.00,2368.22,1636440.02,1802455.20,166015.18,729888),('1','144','257745','360',691.00,780.00,0.00,2416.49,1669794.59,1835262.20,165467.61,729889),('1','144','257746','360',691.00,780.00,0.00,890.29,615190.39,677826.20,62635.81,729890),('1','144','257747','360',691.00,780.00,0.00,0.00,0.00,0.00,0.00,729891),('1','144','257748','360',691.00,770.00,0.00,2058.30,1422285.30,1533968.50,111683.20,729892),('1','144','257749','360',691.00,770.00,0.00,2528.25,1747020.75,1911397.50,164376.75,729893),('1','144','257750','360',691.00,770.00,0.00,3991.17,2757898.47,2978566.65,220668.18,729894),('1','144','257751','360',691.00,770.00,0.00,2926.46,2022183.86,2201769.20,179585.34,729895),('1','144','257752','360',691.00,770.00,0.00,4097.03,2831047.73,3054632.05,223584.32,729896),('1','144','257753','360',691.00,770.00,0.00,3021.41,2087794.31,2256650.70,168856.39,729897),('1','144','257754','360',691.00,770.00,0.00,1741.52,1203390.32,1312175.40,108785.08,729898),('1','144','257755','360',691.00,770.00,0.00,2880.78,1990618.98,2152782.80,162163.82,729899),('1','144','257756','360',691.00,770.00,0.00,1374.74,949945.34,1031737.00,81791.66,729900),('1','144','257757','360',691.00,770.00,0.00,0.00,0.00,0.00,0.00,729901),('1','144','257758','360',704.00,770.00,0.00,3344.25,2354352.00,2470910.95,116558.95,729902),('1','144','257759','360',704.00,770.00,0.00,2135.92,1503687.68,1628558.40,124870.72,729903),('1','144','257760','360',704.00,770.00,0.00,2953.11,2078989.44,2218411.80,139422.36,729904),('1','144','257761','360',704.00,770.00,0.00,5225.39,3678674.56,3886347.60,207673.04,729905),('1','144','257762','360',704.00,770.00,0.00,2539.34,1787695.36,1912979.25,125283.89,729906),('1','144','257763','360',704.00,770.00,0.00,3026.99,2131000.96,2267823.35,136822.39,729907),('1','144','257764','360',704.00,770.00,0.00,2657.45,1870844.80,1988168.45,117323.65,729908),('1','144','257765','360',704.00,770.00,0.00,2691.17,1894583.68,2016420.20,121836.52,729909),('1','144','257766','360',704.00,770.00,0.00,0.00,0.00,0.00,0.00,729910),('1','144','257767','360',691.00,770.00,0.00,969.05,669613.55,735493.50,65879.95,729911),('1','144','257768','360',691.00,770.00,0.00,3115.91,2153093.81,2359040.70,205946.89,729912),('1','144','257769','360',691.00,770.00,0.00,4449.73,3074763.43,3318783.76,244020.33,729913),('1','144','257770','360',691.00,770.00,0.00,4116.29,2844356.39,3085724.00,241367.61,729914),('1','144','257771','360',691.00,770.00,0.00,3202.08,2212637.28,2407359.85,194722.57,729915),('1','144','257772','360',691.00,770.00,0.00,4456.70,3079579.70,3322548.30,242968.60,729916),('1','144','257773','360',691.00,770.00,0.00,3842.19,2654953.29,2870746.30,215793.01,729917),('1','144','257774','360',691.00,770.00,0.00,766.96,529969.36,581809.20,51839.84,729918),('1','144','257775','360',691.00,770.00,0.00,0.00,0.00,0.00,0.00,729919),('1','144','257776','360',709.00,770.00,0.00,2901.87,2057425.83,2177176.25,119750.42,729920),('1','144','257777','360',709.00,770.00,0.00,2628.53,1863627.77,1995593.10,131965.33,729921),('1','144','257778','360',709.00,770.00,0.00,4648.99,3296133.91,3472275.30,176141.39,729922),('1','144','257779','360',709.00,770.00,0.00,2631.70,1865875.30,1982620.50,116745.20,729923),('1','144','257780','360',709.00,770.00,0.00,4031.80,2858546.20,3001076.50,142530.30,729924),('1','144','257781','360',709.00,770.00,0.00,2020.82,1432761.38,1533166.40,100405.02,729925),('1','144','257782','360',709.00,770.00,0.00,1734.20,1229547.80,1313884.00,84336.20,729926),('1','144','257783','360',709.00,770.00,0.00,3225.64,2286978.76,2417099.80,130121.04,729927),('1','144','257784','360',709.00,770.00,0.00,1173.47,831990.23,900071.90,68081.67,729928),('1','144','257785','360',709.00,770.00,0.00,0.00,0.00,0.00,0.00,729929),('1','144','257786','360',691.00,770.00,0.00,768.52,531047.32,582210.40,51163.08,729930),('1','144','257787','360',691.00,770.00,0.00,2447.45,1691187.95,1845037.15,153849.20,729931),('1','144','257788','360',691.00,770.00,0.00,2345.14,1620491.74,1762627.90,142136.16,729932),('1','144','257789','360',691.00,770.00,0.00,2315.74,1600176.34,1758799.80,158623.46,729933),('1','144','257790','360',691.00,770.00,0.00,3458.48,2389809.68,2578225.60,188415.92,729934),('1','144','257791','360',691.00,770.00,0.00,2321.71,1604301.61,1746416.70,142115.09,729935),('1','144','257792','360',691.00,770.00,0.00,2250.79,1555295.89,1697414.29,142118.40,729936),('1','144','257793','360',691.00,770.00,0.00,4977.79,3439652.89,3705607.75,265954.86,729937),('1','144','257794','360',691.00,770.00,0.00,2158.57,1491571.87,1638727.75,147155.88,729938),('1','144','257795','360',691.00,770.00,0.00,1698.99,1174002.09,1308222.30,134220.21,729939),('1','144','257796','360',691.00,770.00,0.00,0.00,0.00,0.00,0.00,729940),('1','144','257797','360',709.00,770.00,0.00,3199.85,2268693.65,2415922.50,147228.85,729941),('1','144','257798','360',709.00,770.00,0.00,3568.77,2530257.93,2689152.90,158894.97,729942),('1','144','257799','360',709.00,770.00,0.00,2038.53,1445317.77,1552358.98,107041.21,729943),('1','144','257800','360',709.00,770.00,0.00,4014.23,2846089.07,3016719.10,170630.03,729944),('1','144','257801','360',709.00,770.00,0.00,2493.74,1768061.66,1890673.55,122611.89,729945),('1','144','257802','360',709.00,770.00,0.00,2259.93,1602290.37,1740146.10,137855.73,729946),('1','144','257803','360',709.00,770.00,0.00,1349.56,956838.04,1039161.20,82323.16,729947),('1','144','257804','360',709.00,770.00,0.00,2611.01,1851206.09,1986827.70,135621.61,729948),('1','144','257805','360',709.00,770.00,0.00,3423.31,2427126.79,2576075.70,148948.91,729949),('1','144','257806','360',709.00,770.00,0.00,568.27,402903.43,437567.90,34664.47,729950),('1','144','257807','360',709.00,770.00,0.00,1446.34,1025455.06,1102431.80,76976.74,729951),('1','144','257808','360',709.00,770.00,0.00,3831.61,2716611.49,2911136.95,194525.46,729952),('1','144','257809','360',709.00,770.00,0.00,3534.54,2505988.86,2677845.80,171856.94,729953),('1','144','257810','360',709.00,770.00,0.00,3211.29,2276804.61,2430243.30,153438.69,729954),('1','144','257811','360',709.00,770.00,0.00,4475.84,3173370.56,3373061.05,199690.49,729955),('1','144','257812','360',709.00,770.00,0.00,2252.52,1597036.68,1734440.40,137403.72,729956),('1','144','257813','360',709.00,770.00,0.00,4458.55,3161111.95,3374121.00,213009.05,729957),('1','144','257814','360',709.00,770.00,0.00,1517.43,1075857.87,1158871.10,83013.23,729958),('1','144','257815','360',709.00,770.00,0.00,0.00,0.00,0.00,0.00,729959),('1','144','257816','360',709.00,770.00,0.00,1331.83,944267.47,1023274.10,79006.63,729960),('1','144','257817','360',709.00,770.00,0.00,4902.49,3475865.41,3749390.55,273525.14,729961),('1','144','257818','360',709.00,770.00,0.00,2833.09,2008660.81,2173624.55,164963.74,729962),('1','144','257819','360',709.00,770.00,0.00,3070.07,2176679.63,2350826.40,174146.77,729963),('1','144','257820','360',709.00,770.00,0.00,2192.22,1554283.98,1681876.90,127592.92,729964),('1','144','257821','360',709.00,770.00,0.00,2020.07,1432229.63,1551318.60,119088.97,729965),('1','144','257822','360',709.00,770.00,0.00,3157.58,2238724.22,2422176.60,183452.38,729966),('1','144','257823','360',709.00,770.00,0.00,2969.27,2105212.43,2279537.90,174325.47,729967),('1','144','257824','360',709.00,770.00,0.00,2378.48,1686342.32,1825537.20,139194.88,729968),('1','144','257825','360',709.00,770.00,0.00,0.00,0.00,0.00,0.00,729969),('1','144','257826','360',691.00,770.00,0.00,4593.78,3174301.98,3515051.75,340749.77,729970),('1','144','257827','360',691.00,770.00,0.00,2662.17,1839559.47,2043320.90,203761.43,729971),('1','144','257828','360',691.00,770.00,0.00,2833.24,1957768.84,2170301.16,212532.32,729972),('1','144','257829','360',691.00,770.00,0.00,1142.69,789598.79,879196.30,89597.51,729973),('1','144','257830','360',691.00,770.00,0.00,1654.60,1143328.60,1272217.00,128888.40,729974),('1','144','257831','360',691.00,770.00,0.00,2089.59,1443906.69,1591635.70,147729.01,729975),('1','144','257832','360',691.00,770.00,0.00,2483.77,1716285.07,1875752.00,159466.93,729976),('1','144','257833','360',691.00,770.00,0.00,3171.39,2191430.49,2382120.30,190689.81,729977),('1','144','257834','360',691.00,770.00,0.00,2178.48,1505329.68,1644312.90,138983.22,729978),('1','144','257835','360',691.00,770.00,0.00,2104.99,1454548.09,1578362.30,123814.21,729979),('1','144','257836','360',691.00,770.00,0.00,0.00,0.00,0.00,0.00,729980),('1','144','257837','360',691.00,770.00,0.00,774.49,535172.59,587657.30,52484.71,729981),('1','144','257838','360',691.00,770.00,0.00,2080.74,1437791.34,1579789.80,141998.46,729982),('1','144','257839','360',691.00,770.00,0.00,2979.21,2058634.11,2252201.70,193567.59,729983),('1','144','257840','360',691.00,770.00,0.00,3377.25,2333679.75,2559832.50,226152.75,729984),('1','144','257841','360',691.00,770.00,0.00,2150.65,1486099.15,1634250.50,148151.35,729985),('1','144','257842','360',691.00,770.00,0.00,3277.80,2264959.80,2482866.00,217906.20,729986),('1','144','257843','360',691.00,770.00,0.00,4903.67,3388435.97,3694975.90,306539.93,729987),('1','144','257844','360',691.00,770.00,0.00,4043.66,2794169.06,3061418.20,267249.14,729988),('1','144','257845','360',691.00,770.00,0.00,1161.17,802368.47,878500.90,76132.43,729989),('1','144','257846','360',691.00,770.00,0.00,0.00,0.00,0.00,0.00,729990),('1','144','257847','360',702.00,770.00,0.00,1637.93,1149826.86,1248456.10,98629.24,729991),('1','144','257848','360',702.00,770.00,0.00,4072.25,2858719.50,3062731.00,204011.50,729992),('1','144','257849','360',702.00,770.00,0.00,2204.45,1547523.90,1679216.50,131692.60,729993),('1','144','257850','360',702.00,770.00,0.00,3022.81,2122012.62,2284933.70,162921.08,729994),('1','144','257851','360',702.00,770.00,0.00,3011.80,2114283.60,2268536.00,154252.40,729995),('1','144','257852','360',702.00,770.00,0.00,2258.67,1585586.34,1705545.90,119959.56,729996),('1','144','257853','360',702.00,770.00,0.00,2338.63,1641718.26,1773805.10,132086.84,729997),('1','144','257854','360',702.00,770.00,0.00,2081.87,1461472.74,1572769.90,111297.16,729998),('1','144','257855','360',702.00,770.00,0.00,2746.56,1928085.12,2076961.20,148876.08,729999),('1','144','257856','360',702.00,770.00,0.00,1317.56,924927.12,991631.20,66704.08,730000),('1','144','257857','360',702.00,770.00,0.00,0.00,0.00,0.00,0.00,730001),('1','144','257858','360',698.00,770.00,0.00,1473.25,1028328.50,1123022.90,94694.40,730002),('1','144','257859','360',698.00,770.00,0.00,3300.15,2303504.70,2476375.50,172870.80,730003),('1','144','257860','360',698.00,770.00,0.00,1848.35,1290148.30,1409099.50,118951.20,730004),('1','144','257861','360',698.00,770.00,0.00,2982.71,2081931.58,2237376.70,155445.12,730005),('1','144','257862','360',698.00,770.00,0.00,2644.15,1845616.70,1991385.50,145768.80,730006),('1','144','257863','360',698.00,770.00,0.00,2106.34,1470225.32,1593006.80,122781.48,730007),('1','144','257864','360',698.00,770.00,0.00,3095.48,2160645.04,2325093.10,164448.06,730008),('1','144','257865','360',698.00,770.00,0.00,2641.62,1843850.76,2003597.40,159746.64,730009),('1','144','257866','360',698.00,770.00,0.00,4100.75,2862323.50,3068920.00,206596.50,730010),('1','144','257867','360',698.00,770.00,0.00,371.29,259160.42,274754.60,15594.18,730011),('1','144','257868','360',698.00,770.00,0.00,0.00,0.00,0.00,0.00,730012),('1','144','257869','360',698.00,770.00,0.00,2346.54,1637884.92,1774975.80,137090.88,730013),('1','144','257870','360',698.00,770.00,0.00,2594.52,1810974.96,1969430.40,158455.44,730014),('1','144','257871','360',698.00,770.00,0.00,2513.78,1754618.44,1905471.40,150852.96,730015),('1','144','257872','360',698.00,770.00,0.00,5228.27,3649332.46,3921397.90,272065.44,730016),('1','144','257873','360',698.00,770.00,0.00,3876.75,2705971.50,2941777.50,235806.00,730017),('1','144','257874','360',698.00,770.00,0.00,1871.79,1306509.42,1429278.30,122768.88,730018),('1','144','257875','360',698.00,770.00,0.00,3355.65,2342243.70,2531500.50,189256.80,730019),('1','144','257876','360',698.00,770.00,0.00,2093.60,1461332.80,1585072.00,123739.20,730020),('1','144','257877','360',698.00,770.00,0.00,774.22,540405.56,590149.40,49743.84,730021),('1','144','257878','360',698.00,770.00,0.00,0.00,0.00,0.00,0.00,730022),('1','144','257879','360',698.00,770.00,0.00,947.63,661445.74,717075.10,55629.36,730023),('1','144','257880','360',698.00,770.00,0.00,3099.87,2163709.26,2340866.10,177156.84,730024),('1','144','257881','360',698.00,770.00,0.00,3081.86,2151138.28,2313032.20,161893.92,730025),('1','144','257882','360',698.00,770.00,0.00,2332.71,1628231.58,1770837.60,142606.02,730026),('1','144','257883','360',698.00,770.00,0.00,1924.80,1343510.40,1464096.00,120585.60,730027),('1','144','257884','360',698.00,770.00,0.00,2239.82,1563394.36,1693431.40,130037.04,730028),('1','144','257885','360',698.00,770.00,0.00,2791.86,1948718.28,2101657.20,152938.92,730029),('1','144','257886','360',698.00,770.00,0.00,2479.79,1730893.42,1871758.30,140864.88,730030),('1','144','257887','360',698.00,770.00,0.00,1679.72,1172444.56,1277064.40,104619.84,730031),('1','144','257888','360',698.00,770.00,0.00,1999.58,1395706.84,1509736.60,114029.76,730032),('1','144','257889','360',698.00,770.00,0.00,2174.86,1518052.28,1636197.50,118145.22,730033),('1','144','257890','360',698.00,770.00,0.00,0.00,0.00,0.00,0.00,730034),('1','144','257891','360',698.00,770.00,0.00,1939.77,1353959.46,1451172.90,97213.44,730035),('1','144','257892','360',698.00,770.00,0.00,2685.69,1874611.62,2042436.90,167825.28,730036),('1','144','257893','360',698.00,770.00,0.00,3128.77,2183881.46,2358936.20,175054.74,730037),('1','144','257894','360',698.00,770.00,0.00,2640.97,1843397.06,2005676.90,162279.84,730038),('1','144','257895','360',698.00,770.00,0.00,2559.69,1786663.62,1933971.30,147307.68,730039),('1','144','257896','360',698.00,770.00,0.00,2236.84,1561314.32,1695339.20,134024.88,730040),('1','144','257897','360',698.00,770.00,0.00,2627.01,1833652.98,1980947.70,147294.72,730041),('1','144','257898','360',698.00,770.00,0.00,5293.11,3694590.78,3963029.70,268438.92,730042),('1','144','257899','360',698.00,770.00,0.00,1448.75,1011227.50,1098137.50,86910.00,730043),('1','144','257900','360',698.00,770.00,0.00,0.00,0.00,0.00,0.00,730044),('1','144','257901','360',698.00,770.00,0.00,1358.81,948449.38,1031583.70,83134.32,730045),('1','144','257902','360',698.00,770.00,0.00,2383.44,1663641.12,1805908.80,142267.68,730046),('1','144','257903','360',698.00,770.00,0.00,3194.12,2229495.76,2406642.40,177146.64,730047),('1','144','257904','360',698.00,770.00,0.00,4285.02,2990943.96,3211091.40,220147.44,730048),('1','144','257905','360',698.00,770.00,0.00,3056.74,2133604.52,2305539.80,171935.28,730049),('1','144','257906','360',698.00,770.00,0.00,3058.65,2134937.70,2299222.50,164284.80,730050),('1','144','257907','360',698.00,770.00,0.00,2166.97,1512545.06,1643553.50,131008.44,730051),('1','144','257908','360',698.00,770.00,0.00,2787.49,1945668.02,2116463.60,170795.58,730052),('1','144','257909','360',698.00,770.00,0.00,2200.89,1536221.22,1658085.30,121864.08,730053),('1','144','257910','360',698.00,770.00,0.00,0.00,0.00,0.00,0.00,730054),('1','144','257911','360',655.00,770.00,0.00,652.73,427538.15,499272.10,71733.95,730055),('1','144','257912','360',655.00,770.00,0.00,2603.29,1705154.95,1969762.40,264607.45,730056),('1','144','257913','360',655.00,770.00,0.00,2720.87,1782169.85,2052803.20,270633.35,730057),('1','144','257914','360',655.00,770.00,0.00,4959.38,3248393.90,3712040.20,463646.30,730058),('1','144','257915','360',655.00,770.00,0.00,2459.85,1611201.75,1857406.50,246204.75,730059),('1','144','257916','360',655.00,770.00,0.00,2825.86,1850938.30,2140662.20,289723.90,730060),('1','144','257917','360',655.00,770.00,0.00,2140.49,1402020.95,1630477.30,228456.35,730061),('1','144','257918','360',655.00,770.00,0.00,2563.46,1679066.30,1931564.20,252497.90,730062),('1','144','257919','360',655.00,770.00,0.00,2641.59,1730241.45,1997004.30,266762.85,730063),('1','144','257920','360',655.00,770.00,0.00,970.16,635454.80,721662.70,86207.90,730064),('1','144','257921','360',655.00,770.00,0.00,0.00,0.00,0.00,0.00,730065),('1','144','257922','360',683.00,770.00,0.00,2123.82,1450569.06,1603440.90,152871.84,730066),('1','144','257923','360',683.00,770.00,0.00,2923.86,1996996.38,2200552.20,203555.82,730067),('1','144','257924','360',683.00,770.00,0.00,3749.02,2560580.66,2818489.40,257908.74,730068),('1','144','257925','360',683.00,770.00,0.00,3690.77,2520795.91,2782132.90,261336.99,730069),('1','144','257926','360',683.00,770.00,0.00,3244.78,2216184.74,2469975.20,253790.46,730070),('1','144','257927','360',683.00,770.00,0.00,2517.02,1719124.66,1907505.40,188380.74,730071),('1','144','257928','360',683.00,770.00,0.00,2528.54,1726992.82,1916726.80,189733.98,730072),('1','144','257929','360',683.00,770.00,0.00,3180.21,2172083.43,2403281.70,231198.27,730073),('1','144','257930','360',683.00,770.00,0.00,535.30,365609.90,402431.00,36821.10,730074),('1','144','257931','360',683.00,770.00,0.00,0.00,0.00,0.00,0.00,730075),('1','144','257932','360',655.00,770.00,0.00,2489.82,1630832.10,1881431.40,250599.30,730076),('1','144','257933','360',655.00,770.00,0.00,6312.73,4134838.15,4711738.40,576900.25,730077),('1','144','257934','360',655.00,770.00,0.00,2914.43,1908951.65,2200274.50,291322.85,730078),('1','144','257935','360',655.00,770.00,0.00,2505.30,1640971.50,1908665.70,267694.20,730079),('1','144','257936','360',655.00,770.00,0.00,2485.11,1627747.05,1877607.30,249860.25,730080),('1','144','257937','360',655.00,770.00,0.00,2490.01,1630956.55,1871887.70,240931.15,730081),('1','144','257938','360',655.00,770.00,0.00,3076.11,2014852.05,2307128.40,292276.35,730082),('1','144','257939','360',655.00,770.00,0.00,1077.00,705435.00,811783.50,106348.50,730083),('1','144','257940','360',655.00,770.00,0.00,0.00,0.00,0.00,0.00,730084),('1','144','257941','360',655.00,770.00,0.00,1154.52,756210.60,875582.70,119372.10,730085),('1','144','257942','360',655.00,770.00,0.00,1597.76,1046532.80,1204295.20,157762.40,730086),('1','144','257943','360',655.00,770.00,0.00,2471.91,1619101.05,1866363.00,247261.95,730087),('1','144','257944','360',655.00,770.00,0.00,2289.62,1499701.10,1746882.40,247181.30,730088),('1','144','257945','360',655.00,770.00,0.00,2212.04,1448886.20,1667885.80,218999.60,730089),('1','144','257946','360',655.00,770.00,0.00,1980.70,1297358.50,1502728.40,205369.90,730090),('1','144','257947','360',655.00,770.00,0.00,2802.49,1835630.95,2111762.30,276131.35,730091),('1','144','257948','360',655.00,770.00,0.00,2685.03,1758694.65,2037773.10,279078.45,730092),('1','144','257949','360',655.00,770.00,0.00,3466.33,2270446.15,2627899.10,357452.95,730093),('1','144','257950','360',655.00,770.00,0.00,3607.03,2362604.65,2751913.10,389308.45,730094),('1','144','257951','360',655.00,770.00,0.00,249.38,163343.90,188211.70,24867.80,730095),('1','144','257952','360',655.00,770.00,0.00,0.00,0.00,0.00,0.00,730096),('1','144','257953','360',655.00,770.00,0.00,3127.92,2048787.60,2362538.40,313750.80,730097),('1','144','257954','360',655.00,770.00,0.00,2850.55,1867110.25,2149512.50,282402.25,730098),('1','144','257955','360',655.00,770.00,0.00,2175.99,1425273.45,1639542.30,214268.85,730099),('1','144','257956','360',655.00,770.00,0.00,1781.95,1167177.25,1355350.10,188172.85,730100),('1','144','257957','360',655.00,770.00,0.00,2259.86,1480208.30,1713076.90,232868.60,730101),('1','144','257958','360',655.00,770.00,0.00,2283.05,1495397.75,1736333.50,240935.75,730102),('1','144','257959','360',655.00,770.00,0.00,2364.75,1548911.25,1803247.50,254336.25,730103),('1','144','257960','360',655.00,770.00,0.00,2767.80,1812909.00,2092386.00,279477.00,730104),('1','144','257961','360',655.00,770.00,0.00,3467.41,2271153.55,2607115.70,335962.15,730105),('1','144','257962','360',655.00,770.00,0.00,591.19,387229.45,440516.60,53287.15,730106),('1','144','257963','360',655.00,770.00,0.00,0.00,0.00,0.00,0.00,730107),('1','144','257964','360',655.00,740.00,0.00,2739.52,1794385.60,1986481.70,192096.10,730108),('1','144','257965','360',655.00,740.00,0.00,3216.14,2106571.70,2329198.60,222626.90,730109),('1','144','257966','360',655.00,740.00,0.00,2534.48,1660084.40,1845515.20,185430.80,730110),('1','144','257967','360',655.00,740.00,0.00,4531.35,2968034.25,3253470.90,285436.65,730111),('1','144','257968','360',655.00,740.00,0.00,2713.89,1777597.95,1969581.30,191983.35,730112),('1','144','257969','360',655.00,740.00,0.00,2891.07,1893650.85,2087379.00,193728.15,730113),('1','144','257970','360',655.00,740.00,0.00,2358.95,1545112.25,1722292.00,177179.75,730114),('1','144','257971','360',655.00,740.00,0.00,2673.54,1751168.70,1939002.60,187833.90,730115),('1','144','257972','360',655.00,740.00,0.00,672.59,440546.45,481366.60,40820.15,730116),('1','144','257973','360',655.00,740.00,0.00,0.00,0.00,0.00,0.00,730117),('1','144','257974','360',655.00,740.00,0.00,4157.24,2722992.20,3032874.10,309881.90,730118),('1','144','257975','360',655.00,740.00,0.00,2760.74,1808284.70,2007822.40,199537.70,730119);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=329 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',328,'144','PRODUCT TANKS','TANKS CONTAINING LPG PRODUCTS.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=830 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','144','328',828,1,'360','LPG TANK 1',22000.00,1.00,1142.97,'THANK CONTAINING  LPG','479','2020-10-11 12:11:22','2020-10-11 12:11:22','479',5,1),('1','144','328',829,1,'360','LPG TANK 2',22000.00,1.00,14787.24,'THANK CONTAINING  LPG','479','2020-10-11 12:13:12','2020-10-11 12:13:12','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','144',828,13081.93,'2023-03-20 18:49:36'),(2,'1','144',829,0.00,'2023-03-20 18:49:00');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2741448 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2107788,'1','144','828',360,'Retail Sale Id 1253917',997.12,0.00,0.00,0.00,82.08,'2021-12-01 05:48:38','',''),(2107789,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 05:48:38','',''),(2107823,'1','144','828',360,'Retail Sale Id 1253936',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 05:55:57','',''),(2107824,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 05:55:57','',''),(2107942,'1','144','828',360,'Retail Sale Id 1253991',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 06:08:19','',''),(2107943,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 06:08:19','',''),(2107976,'1','144','828',360,'Retail Sale Id 1254009',1312.00,0.00,0.00,0.00,108.00,'2021-12-01 06:11:21','',''),(2107977,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 06:11:21','',''),(2108119,'1','144','828',360,'Retail Sale Id 1254078',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 06:25:36','',''),(2108120,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:25:36','',''),(2108154,'1','144','828',360,'Retail Sale Id 1254099',1312.00,0.00,0.00,0.00,108.00,'2021-12-01 06:28:15','',''),(2108155,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 06:28:15','',''),(2108293,'1','144','828',360,'Retail Sale Id 1254161',2499.36,0.00,0.00,0.00,205.74,'2021-12-01 06:36:29','',''),(2108294,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-01 06:36:29','',''),(2108317,'1','144','828',360,'Retail Sale Id 1254176',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 06:38:31','',''),(2108318,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 06:38:31','',''),(2108329,'1','144','828',360,'Retail Sale Id 1254181',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 06:39:32','',''),(2108330,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 06:39:32','',''),(2108345,'1','144','828',360,'Retail Sale Id 1254192',2997.92,0.00,0.00,0.00,246.78,'2021-12-01 06:40:53','',''),(2108346,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-01 06:40:53','',''),(2108375,'1','144','828',360,'Retail Sale Id 1254206',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 06:43:58','',''),(2108376,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 06:43:58','',''),(2108474,'1','144','828',360,'Retail Sale Id 1254251',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 06:51:14','',''),(2108475,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 06:51:14','',''),(2109378,'1','144','828',360,'Retail Sale Id 1254651',12136.00,0.00,0.00,0.00,999.00,'2021-12-01 07:34:18','',''),(2109379,'1','144','828',360,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-01 07:34:18','',''),(2109572,'1','144','828',360,'Retail Sale Id 1254738',12136.00,0.00,0.00,0.00,999.00,'2021-12-01 07:42:01','',''),(2109573,'1','144','828',360,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-01 07:42:01','',''),(2109709,'1','144','828',360,'Retail Sale Id 1254796',5248.00,0.00,0.00,0.00,432.00,'2021-12-01 07:47:26','',''),(2109710,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 07:47:26','',''),(2110304,'1','144','828',360,'Retail Sale Id 1255087',1443.20,0.00,0.00,0.00,118.80,'2021-12-01 08:19:11','',''),(2110305,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.20,0.00,'2021-12-01 08:19:11','',''),(2110397,'1','144','828',360,'Retail Sale Id 1255135',2492.80,0.00,0.00,0.00,205.20,'2021-12-01 08:24:14','',''),(2110398,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.80,0.00,'2021-12-01 08:24:14','',''),(2111172,'1','144','828',360,'Retail Sale Id 1255523',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 09:10:31','',''),(2111173,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:10:31','',''),(2111198,'1','144','828',360,'Retail Sale Id 1255539',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 09:12:03','',''),(2111199,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:12:03','',''),(2111218,'1','144','828',360,'Retail Sale Id 1255550',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 09:13:26','',''),(2111219,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:13:26','',''),(2111236,'1','144','828',360,'Retail Sale Id 1255560',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 09:14:32','',''),(2111237,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:14:32','',''),(2111270,'1','144','828',360,'Retail Sale Id 1255580',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 09:16:09','',''),(2111271,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:16:09','',''),(2111292,'1','144','828',360,'Retail Sale Id 1255592',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 09:17:17','',''),(2111293,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:17:17','',''),(2111301,'1','144','828',360,'Retail Sale Id 1255600',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 09:18:06','',''),(2111302,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:18:06','',''),(2111318,'1','144','828',360,'Retail Sale Id 1255611',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 09:19:08','',''),(2111319,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:19:08','',''),(2111516,'1','144','828',360,'Retail Sale Id 1255707',4592.00,0.00,0.00,0.00,378.00,'2021-12-01 09:31:34','',''),(2111517,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 09:31:34','',''),(2111559,'1','144','828',360,'Retail Sale Id 1255732',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 09:34:56','',''),(2111560,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:34:56','',''),(2111569,'1','144','828',360,'Retail Sale Id 1255737',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 09:35:37','',''),(2111570,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:35:37','',''),(2111593,'1','144','828',360,'Retail Sale Id 1255751',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 09:36:50','',''),(2111594,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:36:50','',''),(2111613,'1','144','828',360,'Retail Sale Id 1255760',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 09:37:48','',''),(2111614,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:37:48','',''),(2111629,'1','144','828',360,'Retail Sale Id 1255769',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 09:38:29','',''),(2111630,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:38:29','',''),(2111646,'1','144','828',360,'Retail Sale Id 1255780',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 09:39:19','',''),(2111647,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:39:19','',''),(2111758,'1','144','828',360,'Retail Sale Id 1255843',4592.00,0.00,0.00,0.00,378.00,'2021-12-01 09:48:15','',''),(2111759,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 09:48:15','',''),(2111853,'1','144','828',360,'Retail Sale Id 1255887',2997.92,0.00,0.00,0.00,246.78,'2021-12-01 09:55:18','',''),(2111854,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-01 09:55:18','',''),(2111874,'1','144','828',360,'Retail Sale Id 1255895',7216.00,0.00,0.00,0.00,594.00,'2021-12-01 09:56:24','',''),(2111875,'1','144','828',360,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-01 09:56:24','',''),(2111913,'1','144','828',360,'Retail Sale Id 1255910',656.00,0.00,0.00,0.00,54.00,'2021-12-01 09:58:28','',''),(2111914,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 09:58:28','',''),(2112102,'1','144','828',360,'Retail Sale Id 1256005',3608.00,0.00,0.00,0.00,297.00,'2021-12-01 10:11:46','',''),(2112103,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-01 10:11:46','',''),(2112321,'1','144','828',360,'Retail Sale Id 1256106',5904.00,0.00,0.00,0.00,486.00,'2021-12-01 10:27:20','',''),(2112322,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-01 10:27:20','',''),(2112542,'1','144','828',360,'Retail Sale Id 1256217',4493.60,0.00,0.00,0.00,369.90,'2021-12-01 10:44:25','',''),(2112543,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.85,0.00,'2021-12-01 10:44:25','',''),(2112596,'1','144','828',360,'Retail Sale Id 1256245',31500.00,0.00,0.00,0.00,1400.00,'2021-12-01 10:48:35','',''),(2112597,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 10:48:35','',''),(2113154,'1','144','828',360,'Retail Sale Id 1256513',126000.00,0.00,0.00,0.00,5600.00,'2021-12-01 11:26:34','',''),(2113155,'1','144','828',360,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-01 11:26:34','',''),(2113589,'1','144','828',360,'Retail Sale Id 1256746',997.12,0.00,0.00,0.00,82.08,'2021-12-01 12:01:13','',''),(2113590,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 12:01:13','',''),(2113605,'1','144','828',360,'Retail Sale Id 1256753',5904.00,0.00,0.00,0.00,486.00,'2021-12-01 12:04:09','',''),(2113606,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-01 12:04:09','',''),(2113649,'1','144','828',360,'Retail Sale Id 1256777',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 12:09:18','',''),(2113650,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 12:09:18','',''),(2113663,'1','144','828',360,'Retail Sale Id 1256785',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 12:10:12','',''),(2113664,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 12:10:12','',''),(2113711,'1','144','828',360,'Retail Sale Id 1256812',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 12:13:06','',''),(2113712,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 12:13:06','',''),(2113719,'1','144','828',360,'Retail Sale Id 1256816',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 12:13:50','',''),(2113720,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 12:13:50','',''),(2113727,'1','144','828',360,'Retail Sale Id 1256822',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 12:14:40','',''),(2113728,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 12:14:40','',''),(2113737,'1','144','828',360,'Retail Sale Id 1256825',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 12:15:19','',''),(2113738,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 12:15:19','',''),(2113749,'1','144','828',360,'Retail Sale Id 1256830',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 12:16:07','',''),(2113750,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 12:16:07','',''),(2113769,'1','144','828',360,'Retail Sale Id 1256841',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 12:17:18','',''),(2113770,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 12:17:18','',''),(2113775,'1','144','828',360,'Retail Sale Id 1256843',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 12:18:03','',''),(2113776,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 12:18:03','',''),(2113803,'1','144','828',360,'Retail Sale Id 1256856',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 12:19:37','',''),(2113804,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:19:37','',''),(2113813,'1','144','828',360,'Retail Sale Id 1256863',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 12:20:14','',''),(2113814,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:20:14','',''),(2113831,'1','144','828',360,'Retail Sale Id 1256871',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 12:20:55','',''),(2113832,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:20:55','',''),(2113841,'1','144','828',360,'Retail Sale Id 1256877',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 12:21:38','',''),(2113842,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:21:38','',''),(2113859,'1','144','828',360,'Retail Sale Id 1256886',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 12:22:19','',''),(2113860,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:22:19','',''),(2113869,'1','144','828',360,'Retail Sale Id 1256890',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 12:22:57','',''),(2113870,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:22:57','',''),(2113881,'1','144','828',360,'Retail Sale Id 1256896',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 12:23:36','',''),(2113882,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:23:36','',''),(2113899,'1','144','828',360,'Retail Sale Id 1256905',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 12:25:33','',''),(2113900,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:25:33','',''),(2113909,'1','144','828',360,'Retail Sale Id 1256909',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 12:26:31','',''),(2113910,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:26:31','',''),(2113931,'1','144','828',360,'Retail Sale Id 1256921',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 12:28:07','',''),(2113932,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:28:07','',''),(2114707,'1','144','828',360,'Retail Sale Id 1257346',12136.00,0.00,0.00,0.00,999.00,'2021-12-01 13:35:06','',''),(2114708,'1','144','828',360,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-01 13:35:06','',''),(2115200,'1','144','828',360,'Retail Sale Id 1257532',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 14:00:43','',''),(2115201,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:00:43','',''),(2115220,'1','144','828',360,'Retail Sale Id 1257537',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 14:01:36','',''),(2115221,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:01:36','',''),(2115271,'1','144','828',360,'Retail Sale Id 1257564',63000.00,0.00,0.00,0.00,2800.00,'2021-12-01 14:04:18','',''),(2115272,'1','144','828',360,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-01 14:04:18','',''),(2115285,'1','144','828',360,'Retail Sale Id 1257570',7872.00,0.00,0.00,0.00,648.00,'2021-12-01 14:05:13','',''),(2115286,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-01 14:05:13','',''),(2115375,'1','144','828',360,'Retail Sale Id 1257627',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 14:11:27','',''),(2115376,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:11:27','',''),(2115387,'1','144','828',360,'Retail Sale Id 1257631',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 14:12:10','',''),(2115388,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:12:10','',''),(2115401,'1','144','828',360,'Retail Sale Id 1257638',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 14:12:50','',''),(2115402,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:12:50','',''),(2115409,'1','144','828',360,'Retail Sale Id 1257642',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 14:13:29','',''),(2115410,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:13:29','',''),(2115419,'1','144','828',360,'Retail Sale Id 1257650',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 14:14:09','',''),(2115420,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:14:09','',''),(2115443,'1','144','828',360,'Retail Sale Id 1257661',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 14:15:57','',''),(2115444,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:15:57','',''),(2115776,'1','144','828',360,'Retail Sale Id 1257830',5904.00,0.00,0.00,0.00,486.00,'2021-12-01 14:39:17','',''),(2115777,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-01 14:39:17','',''),(2116265,'1','144','828',360,'Retail Sale Id 1258044',997.12,0.00,0.00,0.00,82.08,'2021-12-01 15:13:08','',''),(2116266,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 15:13:08','',''),(2116475,'1','144','828',360,'Retail Sale Id 1258139',70560.00,0.00,0.00,0.00,3136.00,'2021-12-01 15:24:52','',''),(2116476,'1','144','828',360,'Retail sales',0.00,0.00,0.00,112.00,0.00,'2021-12-01 15:24:52','',''),(2116547,'1','144','828',360,'Retail Sale Id 1258174',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 15:29:26','',''),(2116548,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:29:26','',''),(2116557,'1','144','828',360,'Retail Sale Id 1258179',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 15:30:18','',''),(2116558,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:30:18','',''),(2116654,'1','144','828',360,'Retail Sale Id 1258230',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 15:37:08','',''),(2116655,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:37:08','',''),(2116702,'1','144','828',360,'Retail Sale Id 1258255',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 15:40:20','',''),(2116703,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:40:20','',''),(2116712,'1','144','828',360,'Retail Sale Id 1258259',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 15:40:56','',''),(2116713,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:40:56','',''),(2116720,'1','144','828',360,'Retail Sale Id 1258262',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 15:41:52','',''),(2116721,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:41:52','',''),(2116740,'1','144','828',360,'Retail Sale Id 1258271',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 15:42:49','',''),(2116741,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:42:49','',''),(2116758,'1','144','828',360,'Retail Sale Id 1258276',1640.00,0.00,0.00,0.00,135.00,'2021-12-01 15:43:42','',''),(2116759,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-01 15:43:42','',''),(2116888,'1','144','828',360,'Retail Sale Id 1258336',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 15:49:13','',''),(2116889,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:49:13','',''),(2117113,'1','144','828',360,'Retail Sale Id 1258445',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 15:58:28','',''),(2117114,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:58:28','',''),(2117143,'1','144','828',360,'Retail Sale Id 1258460',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 15:59:55','',''),(2117144,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:59:55','',''),(2117169,'1','144','828',360,'Retail Sale Id 1258474',1312.00,0.00,0.00,0.00,108.00,'2021-12-01 16:00:39','',''),(2117170,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 16:00:39','',''),(2117203,'1','144','828',360,'Retail Sale Id 1258492',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 16:02:50','',''),(2117204,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:02:50','',''),(2117227,'1','144','828',360,'Retail Sale Id 1258503',5248.00,0.00,0.00,0.00,432.00,'2021-12-01 16:03:41','',''),(2117228,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 16:03:41','',''),(2117255,'1','144','828',360,'Retail Sale Id 1258518',1312.00,0.00,0.00,0.00,108.00,'2021-12-01 16:04:54','',''),(2117256,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 16:04:54','',''),(2117281,'1','144','828',360,'Retail Sale Id 1258530',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:05:51','',''),(2117282,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:05:51','',''),(2117316,'1','144','828',360,'Retail Sale Id 1258538',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:07:06','',''),(2117317,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:07:06','',''),(2117446,'1','144','828',360,'Retail Sale Id 1258590',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:12:21','',''),(2117447,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:12:21','',''),(2117454,'1','144','828',360,'Retail Sale Id 1258599',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:13:06','',''),(2117455,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:13:06','',''),(2117521,'1','144','828',360,'Retail Sale Id 1258618',63000.00,0.00,0.00,0.00,2800.00,'2021-12-01 16:15:07','',''),(2117522,'1','144','828',360,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-01 16:15:07','',''),(2117547,'1','144','828',360,'Retail Sale Id 1258637',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:16:08','',''),(2117548,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:16:08','',''),(2117581,'1','144','828',360,'Retail Sale Id 1258654',997.12,0.00,0.00,0.00,82.08,'2021-12-01 16:17:30','',''),(2117582,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 16:17:30','',''),(2117591,'1','144','828',360,'Retail Sale Id 1258660',1312.00,0.00,0.00,0.00,108.00,'2021-12-01 16:18:21','',''),(2117592,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 16:18:21','',''),(2117792,'1','144','828',360,'Retail Sale Id 1258781',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:27:03','',''),(2117793,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:27:03','',''),(2117812,'1','144','828',360,'Retail Sale Id 1258790',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 16:27:48','',''),(2117813,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:27:48','',''),(2117850,'1','144','828',360,'Retail Sale Id 1258808',1312.00,0.00,0.00,0.00,108.00,'2021-12-01 16:29:20','',''),(2117851,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 16:29:20','',''),(2117916,'1','144','828',360,'Retail Sale Id 1258841',5904.00,0.00,0.00,0.00,486.00,'2021-12-01 16:32:46','',''),(2117917,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-01 16:32:46','',''),(2117944,'1','144','828',360,'Retail Sale Id 1258860',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 16:34:11','',''),(2117945,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:34:11','',''),(2117968,'1','144','828',360,'Retail Sale Id 1258871',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 16:35:15','',''),(2117969,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:35:15','',''),(2118076,'1','144','828',360,'Retail Sale Id 1258927',1312.00,0.00,0.00,0.00,108.00,'2021-12-01 16:40:40','',''),(2118077,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 16:40:40','',''),(2118120,'1','144','828',360,'Retail Sale Id 1258955',7872.00,0.00,0.00,0.00,648.00,'2021-12-01 16:43:06','',''),(2118121,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-01 16:43:06','',''),(2118144,'1','144','828',360,'Retail Sale Id 1258965',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 16:44:03','',''),(2118145,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:44:03','',''),(2118172,'1','144','828',360,'Retail Sale Id 1258981',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:45:22','',''),(2118173,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:45:22','',''),(2118204,'1','144','828',360,'Retail Sale Id 1258995',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:47:18','',''),(2118205,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:47:18','',''),(2118226,'1','144','828',360,'Retail Sale Id 1259008',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:48:16','',''),(2118227,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:48:16','',''),(2118240,'1','144','828',360,'Retail Sale Id 1259017',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 16:49:07','',''),(2118241,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:49:07','',''),(2118256,'1','144','828',360,'Retail Sale Id 1259024',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 16:49:48','',''),(2118257,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:49:48','',''),(2118268,'1','144','828',360,'Retail Sale Id 1259031',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 16:50:38','',''),(2118269,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:50:38','',''),(2118399,'1','144','828',360,'Retail Sale Id 1259091',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 16:55:41','',''),(2118400,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:55:41','',''),(2118500,'1','144','828',360,'Retail Sale Id 1259143',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 16:59:53','',''),(2118501,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:59:53','',''),(2119288,'1','144','828',360,'Retail Sale Id 1259534',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 17:52:31','',''),(2119289,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:52:31','',''),(2119300,'1','144','828',360,'Retail Sale Id 1259541',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 17:53:26','',''),(2119301,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 17:53:26','',''),(2119309,'1','144','828',360,'Retail Sale Id 1259546',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 17:54:51','',''),(2119310,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 17:54:51','',''),(2119319,'1','144','828',360,'Retail Sale Id 1259551',2624.00,0.00,0.00,0.00,216.00,'2021-12-01 17:55:54','',''),(2119320,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 17:55:54','',''),(2119336,'1','144','828',360,'Retail Sale Id 1259559',1312.00,0.00,0.00,0.00,108.00,'2021-12-01 17:58:00','',''),(2119337,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 17:58:00','',''),(2119619,'1','144','828',360,'Retail Sale Id 1259687',228891.52,0.00,0.00,0.00,18841.68,'2021-12-01 18:36:14','',''),(2119620,'1','144','828',360,'Retail sales',0.00,0.00,0.00,348.92,0.00,'2021-12-01 18:36:14','',''),(2119630,'1','144','828',360,'Retail Sale Id 1259692',1746540.00,0.00,0.00,0.00,66960.00,'2021-12-01 18:37:32','',''),(2119631,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2790.00,0.00,'2021-12-01 18:37:32','',''),(2119632,'1','144','828',360,'Retail Sale Id 1259694',813800.00,0.00,0.00,0.00,31200.00,'2021-12-01 18:38:29','',''),(2119633,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1300.00,0.00,'2021-12-01 18:38:29','',''),(2119640,'1','144','828',360,'Retail Sale Id 1259701',438200.00,0.00,0.00,0.00,16800.00,'2021-12-01 18:41:01','',''),(2119641,'1','144','828',360,'Retail sales',0.00,0.00,0.00,700.00,0.00,'2021-12-01 18:41:01','',''),(2120297,'1','144','828',360,'Retail Sale Id 1259802',4592.00,0.00,0.00,0.00,378.00,'2021-12-02 05:53:23','',''),(2120298,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 05:53:23','',''),(2120555,'1','144','828',360,'Retail Sale Id 1259928',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 06:17:55','',''),(2120556,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 06:17:55','',''),(2120579,'1','144','828',360,'Retail Sale Id 1259940',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 06:19:40','',''),(2120580,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 06:19:40','',''),(2120592,'1','144','828',360,'Retail Sale Id 1259943',7872.00,0.00,0.00,0.00,648.00,'2021-12-02 06:20:26','',''),(2120593,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 06:20:26','',''),(2120660,'1','144','828',360,'Retail Sale Id 1259978',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 06:25:57','',''),(2120661,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 06:25:57','',''),(2120794,'1','144','828',360,'Retail Sale Id 1260050',5904.00,0.00,0.00,0.00,486.00,'2021-12-02 06:35:58','',''),(2120795,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 06:35:58','',''),(2120843,'1','144','828',360,'Retail Sale Id 1260064',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 06:38:13','',''),(2120844,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 06:38:13','',''),(2120900,'1','144','828',360,'Retail Sale Id 1260075',2624.00,0.00,0.00,0.00,216.00,'2021-12-02 06:40:04','',''),(2120901,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 06:40:04','',''),(2120925,'1','144','828',360,'Retail Sale Id 1260083',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 06:41:21','',''),(2120926,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 06:41:21','',''),(2121040,'1','144','828',360,'Retail Sale Id 1260122',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 06:47:08','',''),(2121041,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 06:47:08','',''),(2121086,'1','144','828',360,'Retail Sale Id 1260146',997.12,0.00,0.00,0.00,82.08,'2021-12-02 06:49:14','',''),(2121087,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 06:49:14','',''),(2121190,'1','144','828',360,'Retail Sale Id 1260200',2997.92,0.00,0.00,0.00,246.78,'2021-12-02 06:56:10','',''),(2121191,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-02 06:56:10','',''),(2121360,'1','144','828',360,'Retail Sale Id 1260277',94500.00,0.00,0.00,0.00,4200.00,'2021-12-02 07:05:33','',''),(2121361,'1','144','828',360,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-02 07:05:33','',''),(2121615,'1','144','828',360,'Retail Sale Id 1260388',5904.00,0.00,0.00,0.00,486.00,'2021-12-02 07:17:46','',''),(2121616,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 07:17:46','',''),(2121667,'1','144','828',360,'Retail Sale Id 1260413',5248.00,0.00,0.00,0.00,432.00,'2021-12-02 07:20:19','',''),(2121668,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-02 07:20:19','',''),(2122397,'1','144','828',360,'Retail Sale Id 1260786',5248.00,0.00,0.00,0.00,432.00,'2021-12-02 07:54:33','',''),(2122398,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-02 07:54:33','',''),(2123749,'1','144','828',360,'Retail Sale Id 1261427',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:01:26','',''),(2123750,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:01:26','',''),(2123759,'1','144','828',360,'Retail Sale Id 1261438',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:02:12','',''),(2123760,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:02:12','',''),(2123771,'1','144','828',360,'Retail Sale Id 1261460',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:02:58','',''),(2123772,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:02:58','',''),(2123788,'1','144','828',360,'Retail Sale Id 1261467',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:03:54','',''),(2123789,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:03:54','',''),(2123837,'1','144','828',360,'Retail Sale Id 1261491',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:06:08','',''),(2123838,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:06:08','',''),(2123855,'1','144','828',360,'Retail Sale Id 1261503',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:07:01','',''),(2123856,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:07:01','',''),(2123893,'1','144','828',360,'Retail Sale Id 1261522',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:08:31','',''),(2123894,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:08:31','',''),(2123931,'1','144','828',360,'Retail Sale Id 1261540',63000.00,0.00,0.00,0.00,2800.00,'2021-12-02 09:10:44','',''),(2123932,'1','144','828',360,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-02 09:10:44','',''),(2124013,'1','144','828',360,'Retail Sale Id 1261576',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 09:14:16','',''),(2124014,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:14:16','',''),(2124033,'1','144','828',360,'Retail Sale Id 1261583',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 09:15:05','',''),(2124034,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:15:05','',''),(2124054,'1','144','828',360,'Retail Sale Id 1261588',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 09:15:49','',''),(2124055,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:15:49','',''),(2124082,'1','144','828',360,'Retail Sale Id 1261595',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 09:16:29','',''),(2124083,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:16:29','',''),(2124108,'1','144','828',360,'Retail Sale Id 1261604',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 09:17:37','',''),(2124109,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:17:37','',''),(2124126,'1','144','828',360,'Retail Sale Id 1261609',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 09:18:18','',''),(2124127,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:18:18','',''),(2124138,'1','144','828',360,'Retail Sale Id 1261619',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 09:19:00','',''),(2124139,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:19:01','',''),(2124166,'1','144','828',360,'Retail Sale Id 1261632',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:20:31','',''),(2124167,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:20:31','',''),(2124178,'1','144','828',360,'Retail Sale Id 1261638',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:21:34','',''),(2124179,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:21:34','',''),(2124192,'1','144','828',360,'Retail Sale Id 1261646',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:22:21','',''),(2124193,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:22:21','',''),(2124214,'1','144','828',360,'Retail Sale Id 1261663',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:23:47','',''),(2124215,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:23:47','',''),(2124236,'1','144','828',360,'Retail Sale Id 1261671',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:24:33','',''),(2124237,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:24:33','',''),(2124268,'1','144','828',360,'Retail Sale Id 1261686',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:26:42','',''),(2124269,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:26:42','',''),(2124288,'1','144','828',360,'Retail Sale Id 1261695',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:28:05','',''),(2124289,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:28:05','',''),(2124308,'1','144','828',360,'Retail Sale Id 1261704',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:28:54','',''),(2124309,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:28:54','',''),(2124330,'1','144','828',360,'Retail Sale Id 1261714',7216.00,0.00,0.00,0.00,594.00,'2021-12-02 09:30:37','',''),(2124331,'1','144','828',360,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-02 09:30:37','',''),(2124469,'1','144','828',360,'Retail Sale Id 1261789',7478.40,0.00,0.00,0.00,615.60,'2021-12-02 09:40:43','',''),(2124470,'1','144','828',360,'Retail sales',0.00,0.00,0.00,11.40,0.00,'2021-12-02 09:40:43','',''),(2124533,'1','144','828',360,'Retail Sale Id 1261816',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 09:43:54','',''),(2124534,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:43:54','',''),(2124560,'1','144','828',360,'Retail Sale Id 1261830',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 09:45:04','',''),(2124561,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:45:04','',''),(2124582,'1','144','828',360,'Retail Sale Id 1261840',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 09:46:02','',''),(2124583,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:46:02','',''),(2124586,'1','144','828',360,'Retail Sale Id 1261844',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 09:46:45','',''),(2124587,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:46:45','',''),(2124612,'1','144','828',360,'Retail Sale Id 1261857',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 09:48:25','',''),(2124613,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:48:25','',''),(2124627,'1','144','828',360,'Retail Sale Id 1261863',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 09:49:08','',''),(2124628,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:49:08','',''),(2124657,'1','144','828',360,'Retail Sale Id 1261877',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 09:50:23','',''),(2124658,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:50:23','',''),(2124691,'1','144','828',360,'Retail Sale Id 1261903',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 09:51:53','',''),(2124692,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:51:53','',''),(2124719,'1','144','828',360,'Retail Sale Id 1261919',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 09:52:47','',''),(2124720,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:52:47','',''),(2124733,'1','144','828',360,'Retail Sale Id 1261925',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 09:53:38','',''),(2124734,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:53:38','',''),(2124817,'1','144','828',360,'Retail Sale Id 1261971',94500.00,0.00,0.00,0.00,4200.00,'2021-12-02 09:57:54','',''),(2124818,'1','144','828',360,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-02 09:57:54','',''),(2124935,'1','144','828',360,'Retail Sale Id 1262026',997.12,0.00,0.00,0.00,82.08,'2021-12-02 10:03:45','',''),(2124936,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 10:03:45','',''),(2124971,'1','144','828',360,'Retail Sale Id 1262044',4592.00,0.00,0.00,0.00,378.00,'2021-12-02 10:06:29','',''),(2124972,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 10:06:29','',''),(2124983,'1','144','828',360,'Retail Sale Id 1262054',94500.00,0.00,0.00,0.00,4200.00,'2021-12-02 10:07:49','',''),(2124984,'1','144','828',360,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-02 10:07:49','',''),(2125023,'1','144','828',360,'Retail Sale Id 1262078',7872.00,0.00,0.00,0.00,648.00,'2021-12-02 10:10:27','',''),(2125024,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 10:10:27','',''),(2125049,'1','144','828',360,'Retail Sale Id 1262088',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 10:11:46','',''),(2125050,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:11:46','',''),(2125069,'1','144','828',360,'Retail Sale Id 1262098',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 10:12:35','',''),(2125070,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:12:35','',''),(2125088,'1','144','828',360,'Retail Sale Id 1262108',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 10:13:31','',''),(2125089,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:13:31','',''),(2125106,'1','144','828',360,'Retail Sale Id 1262118',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 10:14:45','',''),(2125107,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:14:45','',''),(2125112,'1','144','828',360,'Retail Sale Id 1262122',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 10:15:21','',''),(2125113,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:15:21','',''),(2125126,'1','144','828',360,'Retail Sale Id 1262130',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 10:16:04','',''),(2125127,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:16:04','',''),(2125142,'1','144','828',360,'Retail Sale Id 1262137',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 10:16:48','',''),(2125143,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:16:48','',''),(2125164,'1','144','828',360,'Retail Sale Id 1262148',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 10:18:06','',''),(2125165,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:18:06','',''),(2125180,'1','144','828',360,'Retail Sale Id 1262158',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 10:19:01','',''),(2125181,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:19:01','',''),(2125470,'1','144','828',360,'Retail Sale Id 1262296',1443.20,0.00,0.00,0.00,118.80,'2021-12-02 10:35:32','',''),(2125471,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.20,0.00,'2021-12-02 10:35:32','',''),(2125594,'1','144','828',360,'Retail Sale Id 1262356',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 10:43:10','',''),(2125595,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:43:10','',''),(2125616,'1','144','828',360,'Retail Sale Id 1262367',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 10:44:12','',''),(2125617,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:44:12','',''),(2125626,'1','144','828',360,'Retail Sale Id 1262373',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 10:44:53','',''),(2125627,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:44:53','',''),(2125642,'1','144','828',360,'Retail Sale Id 1262382',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 10:45:33','',''),(2125643,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:45:33','',''),(2125662,'1','144','828',360,'Retail Sale Id 1262391',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 10:46:40','',''),(2125663,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:46:40','',''),(2125812,'1','144','828',360,'Retail Sale Id 1262461',63000.00,0.00,0.00,0.00,2800.00,'2021-12-02 10:57:23','',''),(2125813,'1','144','828',360,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-02 10:57:23','',''),(2125828,'1','144','828',360,'Retail Sale Id 1262472',4998.72,0.00,0.00,0.00,411.48,'2021-12-02 10:58:49','',''),(2125829,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-02 10:58:49','',''),(2125894,'1','144','828',360,'Retail Sale Id 1262506',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 11:02:40','',''),(2125895,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:02:40','',''),(2125906,'1','144','828',360,'Retail Sale Id 1262513',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 11:03:27','',''),(2125907,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:03:27','',''),(2125940,'1','144','828',360,'Retail Sale Id 1262536',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 11:05:52','',''),(2125941,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:05:52','',''),(2125956,'1','144','828',360,'Retail Sale Id 1262542',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 11:06:42','',''),(2125957,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:06:42','',''),(2126092,'1','144','828',360,'Retail Sale Id 1262618',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 11:15:14','',''),(2126093,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:15:14','',''),(2126154,'1','144','828',360,'Retail Sale Id 1262654',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 11:18:31','',''),(2126155,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:18:31','',''),(2126176,'1','144','828',360,'Retail Sale Id 1262662',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 11:19:24','',''),(2126177,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:19:24','',''),(2126212,'1','144','828',360,'Retail Sale Id 1262680',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 11:21:22','',''),(2126213,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:21:22','',''),(2126286,'1','144','828',360,'Retail Sale Id 1262718',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 11:26:15','',''),(2126287,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:26:15','',''),(2126296,'1','144','828',360,'Retail Sale Id 1262724',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 11:27:00','',''),(2126297,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:27:00','',''),(2126326,'1','144','828',360,'Retail Sale Id 1262740',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 11:28:11','',''),(2126327,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:28:11','',''),(2126354,'1','144','828',360,'Retail Sale Id 1262754',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 11:29:26','',''),(2126355,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:29:26','',''),(2126376,'1','144','828',360,'Retail Sale Id 1262761',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 11:30:15','',''),(2126377,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:30:15','',''),(2126394,'1','144','828',360,'Retail Sale Id 1262769',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 11:31:01','',''),(2126395,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:31:01','',''),(2126439,'1','144','828',360,'Retail Sale Id 1262786',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 11:33:02','',''),(2126440,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:33:02','',''),(2126501,'1','144','828',360,'Retail Sale Id 1262805',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 11:36:03','',''),(2126502,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:36:03','',''),(2126530,'1','144','828',360,'Retail Sale Id 1262817',12136.00,0.00,0.00,0.00,999.00,'2021-12-02 11:36:50','',''),(2126531,'1','144','828',360,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-02 11:36:50','',''),(2126565,'1','144','828',360,'Retail Sale Id 1262831',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 11:38:44','',''),(2126566,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:38:44','',''),(2126583,'1','144','828',360,'Retail Sale Id 1262840',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 11:39:37','',''),(2126584,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:39:37','',''),(2126594,'1','144','828',360,'Retail Sale Id 1262845',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 11:40:17','',''),(2126595,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:40:17','',''),(2126615,'1','144','828',360,'Retail Sale Id 1262854',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 11:41:34','',''),(2126616,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:41:34','',''),(2126637,'1','144','828',360,'Retail Sale Id 1262867',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 11:43:13','',''),(2126638,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:43:13','',''),(2126687,'1','144','828',360,'Retail Sale Id 1262888',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 11:48:23','',''),(2126688,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:48:23','',''),(2126705,'1','144','828',360,'Retail Sale Id 1262900',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 11:49:25','',''),(2126706,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:49:25','',''),(2126715,'1','144','828',360,'Retail Sale Id 1262906',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 11:50:15','',''),(2126716,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:50:15','',''),(2126759,'1','144','828',360,'Retail Sale Id 1262915',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 11:54:04','',''),(2126760,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:54:04','',''),(2126789,'1','144','828',360,'Retail Sale Id 1262948',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 11:55:43','',''),(2126790,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:55:43','',''),(2126824,'1','144','828',360,'Retail Sale Id 1262961',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 11:58:29','',''),(2126825,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:58:29','',''),(2126841,'1','144','828',360,'Retail Sale Id 1262973',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 11:59:46','',''),(2126842,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:59:46','',''),(2126950,'1','144','828',360,'Retail Sale Id 1263028',28350.00,0.00,0.00,0.00,1260.00,'2021-12-02 12:09:41','',''),(2126951,'1','144','828',360,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-02 12:09:41','',''),(2127040,'1','144','828',360,'Retail Sale Id 1263071',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 12:18:56','',''),(2127041,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:18:56','',''),(2127058,'1','144','828',360,'Retail Sale Id 1263084',1443.20,0.00,0.00,0.00,118.80,'2021-12-02 12:20:31','',''),(2127059,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.20,0.00,'2021-12-02 12:20:31','',''),(2127080,'1','144','828',360,'Retail Sale Id 1263094',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 12:21:51','',''),(2127081,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:21:51','',''),(2127092,'1','144','828',360,'Retail Sale Id 1263100',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 12:22:35','',''),(2127093,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:22:35','',''),(2127528,'1','144','828',360,'Retail Sale Id 1263328',997.12,0.00,0.00,0.00,82.08,'2021-12-02 12:54:51','',''),(2127529,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 12:54:51','',''),(2127829,'1','144','828',360,'Retail Sale Id 1263472',2997.92,0.00,0.00,0.00,246.78,'2021-12-02 13:15:52','',''),(2127830,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-02 13:15:52','',''),(2127881,'1','144','828',360,'Retail Sale Id 1263488',3608.00,0.00,0.00,0.00,297.00,'2021-12-02 13:18:10','',''),(2127882,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-02 13:18:10','',''),(2128206,'1','144','828',360,'Retail Sale Id 1263618',997.12,0.00,0.00,0.00,82.08,'2021-12-02 13:41:04','',''),(2128207,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 13:41:04','',''),(2128294,'1','144','828',360,'Retail Sale Id 1263665',997.12,0.00,0.00,0.00,82.08,'2021-12-02 13:46:49','',''),(2128295,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 13:46:49','',''),(2128493,'1','144','828',360,'Retail Sale Id 1263751',7216.00,0.00,0.00,0.00,594.00,'2021-12-02 13:56:45','',''),(2128494,'1','144','828',360,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-02 13:56:45','',''),(2128527,'1','144','828',360,'Retail Sale Id 1263766',14104.00,0.00,0.00,0.00,1161.00,'2021-12-02 13:58:40','',''),(2128528,'1','144','828',360,'Retail sales',0.00,0.00,0.00,21.50,0.00,'2021-12-02 13:58:40','',''),(2129001,'1','144','828',360,'Retail Sale Id 1263974',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 14:24:59','',''),(2129002,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:24:59','',''),(2129025,'1','144','828',360,'Retail Sale Id 1263986',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 14:26:03','',''),(2129026,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:26:03','',''),(2129057,'1','144','828',360,'Retail Sale Id 1263991',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 14:26:45','',''),(2129058,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:26:45','',''),(2129100,'1','144','828',360,'Retail Sale Id 1264002',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 14:28:09','',''),(2129101,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:28:09','',''),(2129132,'1','144','828',360,'Retail Sale Id 1264013',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 14:29:32','',''),(2129133,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:29:32','',''),(2129154,'1','144','828',360,'Retail Sale Id 1264030',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 14:30:32','',''),(2129155,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:30:32','',''),(2129166,'1','144','828',360,'Retail Sale Id 1264036',2997.92,0.00,0.00,0.00,246.78,'2021-12-02 14:31:20','',''),(2129167,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-02 14:31:20','',''),(2129224,'1','144','828',360,'Retail Sale Id 1264052',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 14:33:55','',''),(2129225,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:33:55','',''),(2129585,'1','144','828',360,'Retail Sale Id 1264217',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 14:52:25','',''),(2129586,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:52:25','',''),(2129737,'1','144','828',360,'Retail Sale Id 1264295',997.12,0.00,0.00,0.00,82.08,'2021-12-02 15:00:37','',''),(2129738,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 15:00:37','',''),(2129823,'1','144','828',360,'Retail Sale Id 1264340',5904.00,0.00,0.00,0.00,486.00,'2021-12-02 15:08:26','',''),(2129824,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 15:08:26','',''),(2130273,'1','144','828',360,'Retail Sale Id 1264558',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 15:30:45','',''),(2130274,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 15:30:45','',''),(2130524,'1','144','828',360,'Retail Sale Id 1264685',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 15:42:15','',''),(2130525,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:42:15','',''),(2130550,'1','144','828',360,'Retail Sale Id 1264704',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 15:43:47','',''),(2130551,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:43:47','',''),(2130712,'1','144','828',360,'Retail Sale Id 1264793',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 15:51:10','',''),(2130713,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:51:10','',''),(2130736,'1','144','828',360,'Retail Sale Id 1264805',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 15:52:05','',''),(2130737,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:52:05','',''),(2130894,'1','144','828',360,'Retail Sale Id 1264887',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 15:58:51','',''),(2130895,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:58:51','',''),(2130972,'1','144','828',360,'Retail Sale Id 1264918',4592.00,0.00,0.00,0.00,378.00,'2021-12-02 16:01:57','',''),(2130973,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 16:01:57','',''),(2131000,'1','144','828',360,'Retail Sale Id 1264937',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 16:03:11','',''),(2131001,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:03:11','',''),(2131033,'1','144','828',360,'Retail Sale Id 1264950',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 16:04:52','',''),(2131034,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:04:52','',''),(2131132,'1','144','828',360,'Retail Sale Id 1264992',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 16:08:44','',''),(2131133,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:08:44','',''),(2131287,'1','144','828',360,'Retail Sale Id 1265071',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 16:16:16','',''),(2131288,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:16:16','',''),(2131331,'1','144','828',360,'Retail Sale Id 1265095',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 16:18:37','',''),(2131332,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:18:37','',''),(2131349,'1','144','828',360,'Retail Sale Id 1265106',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 16:19:24','',''),(2131350,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:19:24','',''),(2131432,'1','144','828',360,'Retail Sale Id 1265146',2997.92,0.00,0.00,0.00,246.78,'2021-12-02 16:23:51','',''),(2131433,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-02 16:23:51','',''),(2131474,'1','144','828',360,'Retail Sale Id 1265168',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 16:25:55','',''),(2131475,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:25:55','',''),(2131606,'1','144','828',360,'Retail Sale Id 1265222',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 16:29:58','',''),(2131607,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:29:58','',''),(2131682,'1','144','828',360,'Retail Sale Id 1265262',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 16:33:12','',''),(2131683,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:33:12','',''),(2132743,'1','144','828',360,'Retail Sale Id 1265768',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 17:40:06','',''),(2132744,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 17:40:06','',''),(2132761,'1','144','828',360,'Retail Sale Id 1265776',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 17:41:22','',''),(2132762,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 17:41:22','',''),(2132781,'1','144','828',360,'Retail Sale Id 1265786',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 17:43:38','',''),(2132782,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 17:43:38','',''),(2132783,'1','144','828',360,'Retail Sale Id 1265789',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 17:45:02','',''),(2132784,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 17:45:02','',''),(2132802,'1','144','828',360,'Retail Sale Id 1265800',2624.00,0.00,0.00,0.00,216.00,'2021-12-02 17:46:21','',''),(2132803,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 17:46:21','',''),(2132842,'1','144','828',360,'Retail Sale Id 1265814',1312.00,0.00,0.00,0.00,108.00,'2021-12-02 17:49:37','',''),(2132843,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 17:49:37','',''),(2132852,'1','144','828',360,'Retail Sale Id 1265819',6560.00,0.00,0.00,0.00,540.00,'2021-12-02 17:50:36','',''),(2132853,'1','144','828',360,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 17:50:36','',''),(2132884,'1','144','828',360,'Retail Sale Id 1265830',239754.88,0.00,0.00,0.00,19735.92,'2021-12-02 17:53:56','',''),(2132885,'1','144','828',360,'Retail sales',0.00,0.00,0.00,365.48,0.00,'2021-12-02 17:53:56','',''),(2132892,'1','144','828',360,'Retail Sale Id 1265834',2244210.00,0.00,0.00,0.00,86040.00,'2021-12-02 17:55:03','',''),(2132893,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3585.00,0.00,'2021-12-02 17:55:03','',''),(2133853,'1','144','828',360,'Retail Sale Id 1266070',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 05:52:01','',''),(2133854,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 05:52:01','',''),(2133862,'1','144','828',360,'Retail Sale Id 1266071',1312.00,0.00,0.00,0.00,108.00,'2021-12-03 05:52:52','',''),(2133863,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 05:52:52','',''),(2133938,'1','144','828',360,'Retail Sale Id 1266099',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 06:07:50','',''),(2133939,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:07:50','',''),(2134071,'1','144','828',360,'Retail Sale Id 1266132',1312.00,0.00,0.00,0.00,108.00,'2021-12-03 06:17:21','',''),(2134072,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 06:17:21','',''),(2134079,'1','144','828',360,'Retail Sale Id 1266135',2997.92,0.00,0.00,0.00,246.78,'2021-12-03 06:18:25','',''),(2134080,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 06:18:25','',''),(2134103,'1','144','828',360,'Retail Sale Id 1266149',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 06:22:23','',''),(2134104,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 06:22:23','',''),(2134184,'1','144','828',360,'Retail Sale Id 1266190',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 06:30:41','',''),(2134185,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 06:30:41','',''),(2134342,'1','144','828',360,'Retail Sale Id 1266259',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 06:38:56','',''),(2134343,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 06:38:56','',''),(2134383,'1','144','828',360,'Retail Sale Id 1266280',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 06:41:43','',''),(2134384,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 06:41:43','',''),(2134705,'1','144','828',360,'Retail Sale Id 1266437',5248.00,0.00,0.00,0.00,432.00,'2021-12-03 06:58:23','',''),(2134706,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 06:58:23','',''),(2134963,'1','144','828',360,'Retail Sale Id 1266563',997.12,0.00,0.00,0.00,82.08,'2021-12-03 07:13:22','',''),(2134965,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 07:13:22','',''),(2134972,'1','144','828',360,'Retail Sale Id 1266570',997.12,0.00,0.00,0.00,82.08,'2021-12-03 07:14:05','',''),(2134973,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 07:14:05','',''),(2135083,'1','144','828',360,'Retail Sale Id 1266624',32800.00,0.00,0.00,0.00,2700.00,'2021-12-03 07:20:07','',''),(2135084,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 07:20:07','',''),(2135771,'1','144','828',360,'Retail Sale Id 1266947',1443.20,0.00,0.00,0.00,118.80,'2021-12-03 07:58:08','',''),(2135772,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.20,0.00,'2021-12-03 07:58:08','',''),(2135839,'1','144','828',360,'Retail Sale Id 1266970',31500.00,0.00,0.00,0.00,1400.00,'2021-12-03 08:01:08','',''),(2135840,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 08:01:08','',''),(2136132,'1','144','828',360,'Retail Sale Id 1267103',2492.80,0.00,0.00,0.00,205.20,'2021-12-03 08:13:10','',''),(2136133,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.80,0.00,'2021-12-03 08:13:10','',''),(2136146,'1','144','828',360,'Retail Sale Id 1267109',2492.80,0.00,0.00,0.00,205.20,'2021-12-03 08:13:51','',''),(2136147,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.80,0.00,'2021-12-03 08:13:51','',''),(2136390,'1','144','828',360,'Retail Sale Id 1267233',4998.72,0.00,0.00,0.00,411.48,'2021-12-03 08:27:50','',''),(2136391,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-03 08:27:50','',''),(2136798,'1','144','828',360,'Retail Sale Id 1267355',94500.00,0.00,0.00,0.00,4200.00,'2021-12-03 08:44:32','',''),(2136799,'1','144','828',360,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-03 08:44:32','',''),(2137142,'1','144','828',360,'Retail Sale Id 1267539',997.12,0.00,0.00,0.00,82.08,'2021-12-03 09:04:11','',''),(2137143,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 09:04:11','',''),(2137679,'1','144','828',360,'Retail Sale Id 1267846',997.12,0.00,0.00,0.00,82.08,'2021-12-03 09:33:51','',''),(2137680,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 09:33:51','',''),(2137693,'1','144','828',360,'Retail Sale Id 1267856',7872.00,0.00,0.00,0.00,648.00,'2021-12-03 09:34:49','',''),(2137694,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-03 09:34:49','',''),(2137785,'1','144','828',360,'Retail Sale Id 1267909',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 09:40:47','',''),(2137786,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 09:40:47','',''),(2137799,'1','144','828',360,'Retail Sale Id 1267915',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 09:41:53','',''),(2137800,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 09:41:53','',''),(2137811,'1','144','828',360,'Retail Sale Id 1267920',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 09:42:33','',''),(2137812,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 09:42:33','',''),(2137825,'1','144','828',360,'Retail Sale Id 1267929',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 09:43:20','',''),(2137826,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 09:43:20','',''),(2137847,'1','144','828',360,'Retail Sale Id 1267936',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 09:44:28','',''),(2137848,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 09:44:28','',''),(2137861,'1','144','828',360,'Retail Sale Id 1267944',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 09:45:18','',''),(2137862,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 09:45:18','',''),(2137887,'1','144','828',360,'Retail Sale Id 1267957',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 09:46:38','',''),(2137888,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 09:46:38','',''),(2137894,'1','144','828',360,'Retail Sale Id 1267960',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 09:47:16','',''),(2137895,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 09:47:16','',''),(2137940,'1','144','828',360,'Retail Sale Id 1267979',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 09:49:37','',''),(2137941,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 09:49:37','',''),(2137950,'1','144','828',360,'Retail Sale Id 1267986',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 09:50:23','',''),(2137951,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 09:50:23','',''),(2137960,'1','144','828',360,'Retail Sale Id 1267992',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 09:51:03','',''),(2137961,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 09:51:03','',''),(2138004,'1','144','828',360,'Retail Sale Id 1268014',997.12,0.00,0.00,0.00,82.08,'2021-12-03 09:53:48','',''),(2138005,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 09:53:48','',''),(2138018,'1','144','828',360,'Retail Sale Id 1268020',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 09:55:05','',''),(2138019,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 09:55:05','',''),(2138032,'1','144','828',360,'Retail Sale Id 1268026',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 09:55:46','',''),(2138033,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 09:55:46','',''),(2138044,'1','144','828',360,'Retail Sale Id 1268033',7872.00,0.00,0.00,0.00,648.00,'2021-12-03 09:56:42','',''),(2138045,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-03 09:56:42','',''),(2138066,'1','144','828',360,'Retail Sale Id 1268044',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 09:58:03','',''),(2138067,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 09:58:03','',''),(2138132,'1','144','828',360,'Retail Sale Id 1268075',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 10:01:52','',''),(2138133,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 10:01:52','',''),(2138146,'1','144','828',360,'Retail Sale Id 1268084',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 10:02:42','',''),(2138147,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 10:02:42','',''),(2138163,'1','144','828',360,'Retail Sale Id 1268092',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 10:03:49','',''),(2138164,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 10:03:49','',''),(2138177,'1','144','828',360,'Retail Sale Id 1268100',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 10:04:33','',''),(2138178,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 10:04:33','',''),(2138185,'1','144','828',360,'Retail Sale Id 1268104',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 10:05:17','',''),(2138186,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 10:05:17','',''),(2138195,'1','144','828',360,'Retail Sale Id 1268109',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 10:05:59','',''),(2138196,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 10:05:59','',''),(2138344,'1','144','828',360,'Retail Sale Id 1268183',4998.72,0.00,0.00,0.00,411.48,'2021-12-03 10:12:49','',''),(2138345,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-03 10:12:49','',''),(2138468,'1','144','828',360,'Retail Sale Id 1268242',2492.80,0.00,0.00,0.00,205.20,'2021-12-03 10:20:24','',''),(2138469,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.80,0.00,'2021-12-03 10:20:24','',''),(2138592,'1','144','828',360,'Retail Sale Id 1268305',31500.00,0.00,0.00,0.00,1400.00,'2021-12-03 10:27:37','',''),(2138593,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 10:27:37','',''),(2138618,'1','144','828',360,'Retail Sale Id 1268316',5248.00,0.00,0.00,0.00,432.00,'2021-12-03 10:29:34','',''),(2138619,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 10:29:34','',''),(2138755,'1','144','828',360,'Retail Sale Id 1268379',997.12,0.00,0.00,0.00,82.08,'2021-12-03 10:37:32','',''),(2138756,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 10:37:32','',''),(2138969,'1','144','828',360,'Retail Sale Id 1268499',41000.00,0.00,0.00,0.00,3375.00,'2021-12-03 10:53:40','',''),(2138970,'1','144','828',360,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-03 10:53:40','',''),(2139021,'1','144','828',360,'Retail Sale Id 1268523',3608.00,0.00,0.00,0.00,297.00,'2021-12-03 10:58:39','',''),(2139022,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-03 10:58:39','',''),(2139046,'1','144','828',360,'Retail Sale Id 1268538',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 11:00:27','',''),(2139047,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 11:00:27','',''),(2139069,'1','144','828',360,'Retail Sale Id 1268547',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 11:02:00','',''),(2139070,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 11:02:00','',''),(2139083,'1','144','828',360,'Retail Sale Id 1268553',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 11:02:50','',''),(2139084,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 11:02:50','',''),(2139097,'1','144','828',360,'Retail Sale Id 1268564',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 11:04:06','',''),(2139098,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 11:04:06','',''),(2139147,'1','144','828',360,'Retail Sale Id 1268592',997.12,0.00,0.00,0.00,82.08,'2021-12-03 11:08:15','',''),(2139148,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 11:08:15','',''),(2139229,'1','144','828',360,'Retail Sale Id 1268631',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 11:14:00','',''),(2139230,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 11:14:00','',''),(2139237,'1','144','828',360,'Retail Sale Id 1268639',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 11:14:51','',''),(2139238,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 11:14:51','',''),(2139271,'1','144','828',360,'Retail Sale Id 1268655',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 11:16:16','',''),(2139272,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 11:16:16','',''),(2139279,'1','144','828',360,'Retail Sale Id 1268659',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 11:16:56','',''),(2139280,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 11:16:56','',''),(2139630,'1','144','828',360,'Retail Sale Id 1268850',997.12,0.00,0.00,0.00,82.08,'2021-12-03 11:45:19','',''),(2139631,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 11:45:19','',''),(2139650,'1','144','828',360,'Retail Sale Id 1268863',2997.92,0.00,0.00,0.00,246.78,'2021-12-03 11:46:50','',''),(2139651,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 11:46:50','',''),(2139865,'1','144','828',360,'Retail Sale Id 1268980',997.12,0.00,0.00,0.00,82.08,'2021-12-03 12:02:45','',''),(2139866,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 12:02:45','',''),(2139897,'1','144','828',360,'Retail Sale Id 1269002',31500.00,0.00,0.00,0.00,1400.00,'2021-12-03 12:04:09','',''),(2139898,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 12:04:09','',''),(2139986,'1','144','828',360,'Retail Sale Id 1269063',7872.00,0.00,0.00,0.00,648.00,'2021-12-03 12:10:06','',''),(2139987,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-03 12:10:06','',''),(2140210,'1','144','828',360,'Retail Sale Id 1269180',1443.20,0.00,0.00,0.00,118.80,'2021-12-03 12:30:58','',''),(2140211,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.20,0.00,'2021-12-03 12:30:58','',''),(2140624,'1','144','828',360,'Retail Sale Id 1269386',4592.00,0.00,0.00,0.00,378.00,'2021-12-03 13:01:32','',''),(2140625,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-03 13:01:32','',''),(2140656,'1','144','828',360,'Retail Sale Id 1269404',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 13:04:19','',''),(2140657,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 13:04:19','',''),(2140660,'1','144','828',360,'Retail Sale Id 1269406',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 13:04:56','',''),(2140661,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 13:04:56','',''),(2140679,'1','144','828',360,'Retail Sale Id 1269413',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 13:05:47','',''),(2140680,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 13:05:47','',''),(2140693,'1','144','828',360,'Retail Sale Id 1269421',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 13:06:57','',''),(2140694,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 13:06:57','',''),(2140699,'1','144','828',360,'Retail Sale Id 1269422',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 13:07:37','',''),(2140700,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 13:07:37','',''),(2140713,'1','144','828',360,'Retail Sale Id 1269428',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 13:08:43','',''),(2140714,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 13:08:43','',''),(2140719,'1','144','828',360,'Retail Sale Id 1269432',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 13:09:45','',''),(2140720,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 13:09:45','',''),(2141073,'1','144','828',360,'Retail Sale Id 1269598',2997.92,0.00,0.00,0.00,246.78,'2021-12-03 13:36:50','',''),(2141074,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 13:36:50','',''),(2141110,'1','144','828',360,'Retail Sale Id 1269620',4592.00,0.00,0.00,0.00,378.00,'2021-12-03 13:38:45','',''),(2141111,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-03 13:38:45','',''),(2141150,'1','144','828',360,'Retail Sale Id 1269635',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 13:41:17','',''),(2141151,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 13:41:17','',''),(2141166,'1','144','828',360,'Retail Sale Id 1269643',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 13:42:06','',''),(2141167,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 13:42:06','',''),(2141188,'1','144','828',360,'Retail Sale Id 1269648',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 13:43:06','',''),(2141189,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 13:43:06','',''),(2141228,'1','144','828',360,'Retail Sale Id 1269666',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 13:44:46','',''),(2141229,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 13:44:46','',''),(2141499,'1','144','828',360,'Retail Sale Id 1269759',31500.00,0.00,0.00,0.00,1400.00,'2021-12-03 13:55:10','',''),(2141500,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 13:55:10','',''),(2141576,'1','144','828',360,'Retail Sale Id 1269797',997.12,0.00,0.00,0.00,82.08,'2021-12-03 14:01:32','',''),(2141577,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 14:01:32','',''),(2141618,'1','144','828',360,'Retail Sale Id 1269814',2997.92,0.00,0.00,0.00,246.78,'2021-12-03 14:03:55','',''),(2141619,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 14:03:55','',''),(2141858,'1','144','828',360,'Retail Sale Id 1269914',7872.00,0.00,0.00,0.00,648.00,'2021-12-03 14:18:37','',''),(2141859,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-03 14:18:37','',''),(2141987,'1','144','828',360,'Retail Sale Id 1269955',31500.00,0.00,0.00,0.00,1400.00,'2021-12-03 14:25:05','',''),(2141988,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 14:25:05','',''),(2142048,'1','144','828',360,'Retail Sale Id 1269986',997.12,0.00,0.00,0.00,82.08,'2021-12-03 14:29:12','',''),(2142049,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 14:29:12','',''),(2142077,'1','144','828',360,'Retail Sale Id 1269998',14760.00,0.00,0.00,0.00,1215.00,'2021-12-03 14:30:53','',''),(2142078,'1','144','828',360,'Retail sales',0.00,0.00,0.00,22.50,0.00,'2021-12-03 14:30:53','',''),(2142691,'1','144','828',360,'Retail Sale Id 1270253',997.12,0.00,0.00,0.00,82.08,'2021-12-03 14:59:16','',''),(2142692,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 14:59:16','',''),(2142708,'1','144','828',360,'Retail Sale Id 1270263',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 15:00:25','',''),(2142709,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:00:25','',''),(2142730,'1','144','828',360,'Retail Sale Id 1270273',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 15:01:43','',''),(2142731,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:01:43','',''),(2142759,'1','144','828',360,'Retail Sale Id 1270287',25200.00,0.00,0.00,0.00,1120.00,'2021-12-03 15:03:59','',''),(2142760,'1','144','828',360,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-03 15:03:59','',''),(2142842,'1','144','828',360,'Retail Sale Id 1270328',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 15:09:21','',''),(2142843,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:09:21','',''),(2142860,'1','144','828',360,'Retail Sale Id 1270341',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 15:10:11','',''),(2142861,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:10:11','',''),(2142874,'1','144','828',360,'Retail Sale Id 1270351',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 15:10:58','',''),(2142875,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:10:58','',''),(2142904,'1','144','828',360,'Retail Sale Id 1270361',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 15:11:50','',''),(2142905,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:11:50','',''),(2142940,'1','144','828',360,'Retail Sale Id 1270376',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 15:13:48','',''),(2142941,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:13:48','',''),(2142964,'1','144','828',360,'Retail Sale Id 1270390',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 15:14:37','',''),(2142965,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:14:37','',''),(2142998,'1','144','828',360,'Retail Sale Id 1270416',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 15:16:14','',''),(2142999,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:16:14','',''),(2143024,'1','144','828',360,'Retail Sale Id 1270433',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 15:17:26','',''),(2143027,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:17:26','',''),(2143041,'1','144','828',360,'Retail Sale Id 1270442',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 15:18:32','',''),(2143042,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:18:32','',''),(2143061,'1','144','828',360,'Retail Sale Id 1270454',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 15:19:26','',''),(2143062,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:19:26','',''),(2143080,'1','144','828',360,'Retail Sale Id 1270467',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 15:20:16','',''),(2143081,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:20:16','',''),(2143107,'1','144','828',360,'Retail Sale Id 1270479',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 15:21:21','',''),(2143108,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:21:21','',''),(2143117,'1','144','828',360,'Retail Sale Id 1270486',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 15:22:13','',''),(2143118,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:22:13','',''),(2143257,'1','144','828',360,'Retail Sale Id 1270553',656.00,0.00,0.00,0.00,54.00,'2021-12-03 15:29:30','',''),(2143258,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 15:29:30','',''),(2143279,'1','144','828',360,'Retail Sale Id 1270565',2997.92,0.00,0.00,0.00,246.78,'2021-12-03 15:30:37','',''),(2143280,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 15:30:37','',''),(2143379,'1','144','828',360,'Retail Sale Id 1270609',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 15:34:46','',''),(2143380,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:34:46','',''),(2143399,'1','144','828',360,'Retail Sale Id 1270617',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 15:35:58','',''),(2143400,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:35:58','',''),(2143460,'1','144','828',360,'Retail Sale Id 1270653',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 15:38:07','',''),(2143461,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:38:07','',''),(2143508,'1','144','828',360,'Retail Sale Id 1270680',1640.00,0.00,0.00,0.00,135.00,'2021-12-03 15:39:58','',''),(2143509,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-03 15:39:58','',''),(2143542,'1','144','828',360,'Retail Sale Id 1270696',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 15:41:32','',''),(2143543,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:41:32','',''),(2143576,'1','144','828',360,'Retail Sale Id 1270706',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 15:42:40','',''),(2143577,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:42:40','',''),(2143606,'1','144','828',360,'Retail Sale Id 1270725',2997.92,0.00,0.00,0.00,246.78,'2021-12-03 15:44:16','',''),(2143607,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 15:44:16','',''),(2143792,'1','144','828',360,'Retail Sale Id 1270817',2997.92,0.00,0.00,0.00,246.78,'2021-12-03 15:51:42','',''),(2143793,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 15:51:43','',''),(2143917,'1','144','828',360,'Retail Sale Id 1270882',1640.00,0.00,0.00,0.00,135.00,'2021-12-03 15:58:10','',''),(2143918,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-03 15:58:10','',''),(2143981,'1','144','828',360,'Retail Sale Id 1270910',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 16:00:43','',''),(2143982,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 16:00:43','',''),(2143993,'1','144','828',360,'Retail Sale Id 1270916',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 16:01:24','',''),(2143994,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:01:24','',''),(2144017,'1','144','828',360,'Retail Sale Id 1270925',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 16:02:13','',''),(2144018,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:02:13','',''),(2144057,'1','144','828',360,'Retail Sale Id 1270947',997.12,0.00,0.00,0.00,82.08,'2021-12-03 16:03:50','',''),(2144058,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 16:03:50','',''),(2144083,'1','144','828',360,'Retail Sale Id 1270964',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 16:05:24','',''),(2144084,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:05:24','',''),(2144117,'1','144','828',360,'Retail Sale Id 1270975',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 16:06:11','',''),(2144118,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:06:11','',''),(2144198,'1','144','828',360,'Retail Sale Id 1271019',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 16:09:56','',''),(2144199,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:09:56','',''),(2144220,'1','144','828',360,'Retail Sale Id 1271027',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 16:10:55','',''),(2144221,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 16:10:55','',''),(2144408,'1','144','828',360,'Retail Sale Id 1271124',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 16:21:13','',''),(2144409,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:21:13','',''),(2144444,'1','144','828',360,'Retail Sale Id 1271143',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 16:22:57','',''),(2144445,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:22:57','',''),(2144570,'1','144','828',360,'Retail Sale Id 1271209',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 16:30:20','',''),(2144571,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 16:30:20','',''),(2144596,'1','144','828',360,'Retail Sale Id 1271219',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 16:31:05','',''),(2144597,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:31:05','',''),(2144610,'1','144','828',360,'Retail Sale Id 1271225',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 16:31:53','',''),(2144611,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:31:53','',''),(2144633,'1','144','828',360,'Retail Sale Id 1271237',2997.92,0.00,0.00,0.00,246.78,'2021-12-03 16:32:59','',''),(2144634,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 16:32:59','',''),(2144691,'1','144','828',360,'Retail Sale Id 1271267',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 16:36:07','',''),(2144692,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:36:07','',''),(2144803,'1','144','828',360,'Retail Sale Id 1271328',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 16:41:27','',''),(2144804,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:41:27','',''),(2144830,'1','144','828',360,'Retail Sale Id 1271335',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 16:42:16','',''),(2144831,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 16:42:16','',''),(2144850,'1','144','828',360,'Retail Sale Id 1271345',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 16:43:08','',''),(2144851,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:43:08','',''),(2144864,'1','144','828',360,'Retail Sale Id 1271354',997.12,0.00,0.00,0.00,82.08,'2021-12-03 16:44:13','',''),(2144865,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 16:44:13','',''),(2144959,'1','144','828',360,'Retail Sale Id 1271403',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 16:49:46','',''),(2144960,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:49:46','',''),(2145791,'1','144','828',360,'Retail Sale Id 1271783',177198.72,0.00,0.00,0.00,14586.48,'2021-12-03 18:10:43','',''),(2145792,'1','144','828',360,'Retail sales',0.00,0.00,0.00,270.12,0.00,'2021-12-03 18:10:43','',''),(2145804,'1','144','828',360,'Retail Sale Id 1271789',378000.00,0.00,0.00,0.00,16800.00,'2021-12-03 18:11:57','',''),(2145805,'1','144','828',360,'Retail sales',0.00,0.00,0.00,600.00,0.00,'2021-12-03 18:11:57','',''),(2146023,'1','144',NULL,360,'Reception corrector for bridging 126111',0.00,0.00,0.00,5000.00,0.00,'2021-12-03 18:41:34','',''),(2146024,'1','144','828',360,'Received from bridging 126111',0.00,0.00,5000.00,0.00,0.00,'2021-12-03 18:41:34','',''),(2146489,'1','144','828',360,'Retail Sale Id 1271947',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 05:40:08','',''),(2146490,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 05:40:08','',''),(2146491,'1','144','828',360,'Retail Sale Id 1271948',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 05:41:26','',''),(2146492,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 05:41:26','',''),(2146493,'1','144','828',360,'Retail Sale Id 1271949',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 05:42:52','',''),(2146494,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 05:42:52','',''),(2146497,'1','144','828',360,'Retail Sale Id 1271951',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 05:45:01','',''),(2146498,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 05:45:01','',''),(2146507,'1','144','828',360,'Retail Sale Id 1271955',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 05:49:35','',''),(2146508,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 05:49:35','',''),(2146532,'1','144','828',360,'Retail Sale Id 1271962',2560.00,0.00,0.00,0.00,152.00,'2021-12-04 05:50:37','',''),(2146533,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 05:50:37','',''),(2146537,'1','144','828',360,'Retail Sale Id 1271965',1280.00,0.00,0.00,0.00,76.00,'2021-12-04 05:52:00','',''),(2146538,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 05:52:00','',''),(2146573,'1','144','828',360,'Retail Sale Id 1271976',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 05:55:58','',''),(2146574,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 05:55:58','',''),(2146606,'1','144','828',360,'Retail Sale Id 1271981',6400.00,0.00,0.00,0.00,380.00,'2021-12-04 05:59:05','',''),(2146607,'1','144','828',360,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 05:59:05','',''),(2146693,'1','144','828',360,'Retail Sale Id 1272017',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 06:14:13','',''),(2146694,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 06:14:13','',''),(2146809,'1','144','828',360,'Retail Sale Id 1272054',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 06:22:01','',''),(2146810,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 06:22:01','',''),(2146847,'1','144','828',360,'Retail Sale Id 1272067',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 06:23:37','',''),(2146848,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 06:23:37','',''),(2146875,'1','144','828',360,'Retail Sale Id 1272077',998.40,0.00,0.00,0.00,59.28,'2021-12-04 06:25:05','',''),(2146876,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 06:25:05','',''),(2146904,'1','144','828',360,'Retail Sale Id 1272084',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 06:26:19','',''),(2146905,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:26:19','',''),(2146929,'1','144','828',360,'Retail Sale Id 1272096',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 06:27:34','',''),(2146930,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 06:27:34','',''),(2146976,'1','144','828',360,'Retail Sale Id 1272105',998.40,0.00,0.00,0.00,59.28,'2021-12-04 06:28:38','',''),(2146977,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 06:28:38','',''),(2147042,'1','144','828',360,'Retail Sale Id 1272136',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 06:32:36','',''),(2147043,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 06:32:36','',''),(2147050,'1','144','828',360,'Retail Sale Id 1272141',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 06:33:36','',''),(2147051,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 06:33:36','',''),(2147078,'1','144','828',360,'Retail Sale Id 1272154',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 06:35:13','',''),(2147079,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:35:13','',''),(2147266,'1','144','828',360,'Retail Sale Id 1272234',11840.00,0.00,0.00,0.00,703.00,'2021-12-04 06:44:55','',''),(2147267,'1','144','828',360,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-04 06:44:55','',''),(2147452,'1','144','828',360,'Retail Sale Id 1272320',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 06:54:54','',''),(2147453,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 06:54:54','',''),(2147508,'1','144','828',360,'Retail Sale Id 1272345',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 06:57:03','',''),(2147509,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 06:57:03','',''),(2147609,'1','144','828',360,'Retail Sale Id 1272385',2560.00,0.00,0.00,0.00,152.00,'2021-12-04 07:02:05','',''),(2147610,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 07:02:05','',''),(2147809,'1','144','828',360,'Retail Sale Id 1272495',16000.00,0.00,0.00,0.00,950.00,'2021-12-04 07:14:20','',''),(2147810,'1','144','828',360,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 07:14:20','',''),(2147833,'1','144','828',360,'Retail Sale Id 1272508',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 07:15:21','',''),(2147834,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:15:21','',''),(2147849,'1','144','828',360,'Retail Sale Id 1272528',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 07:16:11','',''),(2147850,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:16:11','',''),(2147884,'1','144','828',360,'Retail Sale Id 1272542',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 07:17:37','',''),(2147885,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:17:37','',''),(2147972,'1','144','828',360,'Retail Sale Id 1272586',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 07:22:02','',''),(2147973,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 07:22:02','',''),(2148078,'1','144','828',360,'Retail Sale Id 1272642',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 07:27:35','',''),(2148079,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 07:27:35','',''),(2148351,'1','144','828',360,'Retail Sale Id 1272796',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 07:40:12','',''),(2148352,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 07:40:12','',''),(2148420,'1','144','828',360,'Retail Sale Id 1272865',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 07:44:01','',''),(2148421,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:44:01','',''),(2148448,'1','144','828',360,'Retail Sale Id 1272892',7040.00,0.00,0.00,0.00,418.00,'2021-12-04 07:45:47','',''),(2148449,'1','144','828',360,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-04 07:45:47','',''),(2148681,'1','144','828',360,'Retail Sale Id 1273039',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 07:59:38','',''),(2148682,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:59:38','',''),(2148767,'1','144','828',360,'Retail Sale Id 1273079',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 08:03:17','',''),(2148768,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:03:17','',''),(2148827,'1','144','828',360,'Retail Sale Id 1273108',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 08:05:38','',''),(2148828,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:05:38','',''),(2148866,'1','144','828',360,'Retail Sale Id 1273127',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 08:07:09','',''),(2148867,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:07:09','',''),(2148886,'1','144','828',360,'Retail Sale Id 1273141',20160.00,0.00,0.00,0.00,1197.00,'2021-12-04 08:08:13','',''),(2148887,'1','144','828',360,'Retail sales',0.00,0.00,0.00,31.50,0.00,'2021-12-04 08:08:13','',''),(2148974,'1','144','828',360,'Retail Sale Id 1273199',11200.00,0.00,0.00,0.00,665.00,'2021-12-04 08:12:23','',''),(2148975,'1','144','828',360,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-04 08:12:23','',''),(2149358,'1','144','828',360,'Retail Sale Id 1273439',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 08:28:17','',''),(2149359,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:28:17','',''),(2149378,'1','144','828',360,'Retail Sale Id 1273450',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 08:29:10','',''),(2149379,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:29:10','',''),(2150111,'1','144','828',360,'Retail Sale Id 1273843',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 08:59:04','',''),(2150112,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:59:04','',''),(2150157,'1','144','828',360,'Retail Sale Id 1273867',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 09:01:20','',''),(2150158,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:01:20','',''),(2150688,'1','144','828',360,'Retail Sale Id 1274146',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 09:27:26','',''),(2150689,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 09:27:26','',''),(2150820,'1','144','828',360,'Retail Sale Id 1274221',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 09:34:07','',''),(2150821,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:34:07','',''),(2152418,'1','144','828',360,'Retail Sale Id 1274375',30500.00,0.00,0.00,0.00,400.00,'2021-12-04 10:30:27','',''),(2152419,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 10:30:27','',''),(2152492,'1','144','828',360,'Retail Sale Id 1274403',61000.00,0.00,0.00,0.00,800.00,'2021-12-04 10:36:08','',''),(2152493,'1','144','828',360,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-04 10:36:08','',''),(2152662,'1','144','828',360,'Retail Sale Id 1274466',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 10:48:08','',''),(2152663,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 10:48:08','',''),(2152706,'1','144','828',360,'Retail Sale Id 1274487',152500.00,0.00,0.00,0.00,2000.00,'2021-12-04 10:50:26','',''),(2152707,'1','144','828',360,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-04 10:50:26','',''),(2152726,'1','144','828',360,'Retail Sale Id 1274491',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 10:51:30','',''),(2152727,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 10:51:30','',''),(2152827,'1','144','828',360,'Retail Sale Id 1274531',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 10:56:40','',''),(2152828,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 10:56:40','',''),(2152916,'1','144','828',360,'Retail Sale Id 1274576',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 11:01:54','',''),(2152917,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:01:54','',''),(2153002,'1','144','828',360,'Retail Sale Id 1274617',7680.00,0.00,0.00,0.00,456.00,'2021-12-04 11:06:09','',''),(2153003,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 11:06:09','',''),(2153145,'1','144','828',360,'Retail Sale Id 1274686',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 11:13:05','',''),(2153146,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 11:13:05','',''),(2153207,'1','144','828',360,'Retail Sale Id 1274722',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 11:16:11','',''),(2153208,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 11:16:11','',''),(2153817,'1','144','828',360,'Retail Sale Id 1275012',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 11:48:35','',''),(2153818,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 11:48:35','',''),(2154190,'1','144','828',360,'Retail Sale Id 1275125',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 12:05:26','',''),(2154191,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 12:05:26','',''),(2154210,'1','144','828',360,'Retail Sale Id 1275134',1004.80,0.00,0.00,0.00,59.66,'2021-12-04 12:06:33','',''),(2154211,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.57,0.00,'2021-12-04 12:06:33','',''),(2154377,'1','144','828',360,'Retail Sale Id 1275221',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 12:17:04','',''),(2154378,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 12:17:04','',''),(2154431,'1','144','828',360,'Retail Sale Id 1275252',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 12:21:31','',''),(2154432,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 12:21:31','',''),(2154457,'1','144','828',360,'Retail Sale Id 1275265',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 12:23:22','',''),(2154458,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:23:22','',''),(2154479,'1','144','828',360,'Retail Sale Id 1275276',4998.40,0.00,0.00,0.00,296.78,'2021-12-04 12:24:36','',''),(2154480,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-04 12:24:36','',''),(2154495,'1','144','828',360,'Retail Sale Id 1275283',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 12:25:29','',''),(2154496,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 12:25:29','',''),(2154529,'1','144','828',360,'Retail Sale Id 1275298',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 12:26:59','',''),(2154530,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 12:26:59','',''),(2154549,'1','144','828',360,'Retail Sale Id 1275307',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 12:27:58','',''),(2154550,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 12:27:58','',''),(2154593,'1','144','828',360,'Retail Sale Id 1275329',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 12:30:18','',''),(2154594,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 12:30:18','',''),(2154621,'1','144','828',360,'Retail Sale Id 1275345',4480.00,0.00,0.00,0.00,266.00,'2021-12-04 12:32:01','',''),(2154622,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 12:32:01','',''),(2154645,'1','144','828',360,'Retail Sale Id 1275354',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 12:33:01','',''),(2154646,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 12:33:01','',''),(2154715,'1','144','828',360,'Retail Sale Id 1275391',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 12:37:44','',''),(2154716,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:37:44','',''),(2154748,'1','144','828',360,'Retail Sale Id 1275406',5996.80,0.00,0.00,0.00,356.06,'2021-12-04 12:39:43','',''),(2154749,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.37,0.00,'2021-12-04 12:39:43','',''),(2154764,'1','144','828',360,'Retail Sale Id 1275416',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 12:40:49','',''),(2154765,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 12:40:49','',''),(2154782,'1','144','828',360,'Retail Sale Id 1275426',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 12:42:34','',''),(2154783,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 12:42:34','',''),(2154823,'1','144','828',360,'Retail Sale Id 1275446',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 12:46:40','',''),(2154824,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 12:46:40','',''),(2154929,'1','144','828',360,'Retail Sale Id 1275483',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 12:52:23','',''),(2154930,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:52:23','',''),(2155133,'1','144','828',360,'Retail Sale Id 1275800',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 13:12:17','',''),(2155134,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 13:12:17','',''),(2155153,'1','144','828',360,'Retail Sale Id 1275805',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 13:13:44','',''),(2155154,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:13:44','',''),(2155224,'1','144','828',360,'Retail Sale Id 1275838',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 13:18:27','',''),(2155225,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 13:18:27','',''),(2155258,'1','144','828',360,'Retail Sale Id 1275850',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 13:20:17','',''),(2155259,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 13:20:17','',''),(2155309,'1','144','828',360,'Retail Sale Id 1275869',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 13:22:50','',''),(2155310,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 13:22:50','',''),(2155323,'1','144','828',360,'Retail Sale Id 1275875',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 13:23:44','',''),(2155324,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 13:23:44','',''),(2155349,'1','144','828',360,'Retail Sale Id 1275881',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 13:24:51','',''),(2155350,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 13:24:51','',''),(2155435,'1','144','828',360,'Retail Sale Id 1275905',998.40,0.00,0.00,0.00,59.28,'2021-12-04 13:27:12','',''),(2155436,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 13:27:12','',''),(2155462,'1','144','828',360,'Retail Sale Id 1275916',366000.00,0.00,0.00,0.00,4800.00,'2021-12-04 13:28:49','',''),(2155463,'1','144','828',360,'Retail sales',0.00,0.00,0.00,600.00,0.00,'2021-12-04 13:28:49','',''),(2155520,'1','144','828',360,'Return of Retail Sale Id 1275916',0.00,366000.00,600.00,0.00,-4800.00,'2021-12-04 13:31:55','',''),(2155543,'1','144','828',360,'Retail Sale Id 1275960',36600.00,0.00,0.00,0.00,480.00,'2021-12-04 13:33:35','',''),(2155544,'1','144','828',360,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-04 13:33:35','',''),(2155551,'1','144','828',360,'Retail Sale Id 1275964',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 13:34:07','',''),(2155552,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 13:34:07','',''),(2155575,'1','144','828',360,'Retail Sale Id 1275974',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 13:35:21','',''),(2155576,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 13:35:21','',''),(2155602,'1','144','828',360,'Retail Sale Id 1275983',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 13:36:49','',''),(2155603,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 13:36:49','',''),(2155698,'1','144','828',360,'Retail Sale Id 1276033',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 13:42:17','',''),(2155699,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 13:42:17','',''),(2155718,'1','144','828',360,'Retail Sale Id 1276044',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 13:43:12','',''),(2155719,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 13:43:12','',''),(2155742,'1','144','828',360,'Retail Sale Id 1276058',10560.00,0.00,0.00,0.00,627.00,'2021-12-04 13:44:50','',''),(2155743,'1','144','828',360,'Retail sales',0.00,0.00,0.00,16.50,0.00,'2021-12-04 13:44:50','',''),(2155774,'1','144','828',360,'Retail Sale Id 1276072',8000.00,0.00,0.00,0.00,475.00,'2021-12-04 13:46:40','',''),(2155775,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:46:40','',''),(2155822,'1','144','828',360,'Retail Sale Id 1276092',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 13:48:29','',''),(2155823,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 13:48:29','',''),(2155880,'1','144','828',360,'Retail Sale Id 1276101',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 13:50:11','',''),(2155881,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 13:50:11','',''),(2155906,'1','144','828',360,'Retail Sale Id 1276121',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 13:52:08','',''),(2155907,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 13:52:08','',''),(2155930,'1','144','828',360,'Retail Sale Id 1276134',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 13:53:03','',''),(2155931,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 13:53:03','',''),(2155942,'1','144','828',360,'Retail Sale Id 1276140',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 13:54:06','',''),(2155943,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 13:54:06','',''),(2156013,'1','144','828',360,'Retail Sale Id 1276172',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 13:57:34','',''),(2156014,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 13:57:34','',''),(2156023,'1','144','828',360,'Retail Sale Id 1276178',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 13:58:12','',''),(2156024,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 13:58:12','',''),(2156210,'1','144','828',360,'Retail Sale Id 1276242',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 14:05:06','',''),(2156211,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 14:05:06','',''),(2156273,'1','144','828',360,'Retail Sale Id 1276277',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 14:08:07','',''),(2156274,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 14:08:07','',''),(2156329,'1','144','828',360,'Retail Sale Id 1276311',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 14:11:10','',''),(2156330,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:11:10','',''),(2156351,'1','144','828',360,'Retail Sale Id 1276326',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 14:12:16','',''),(2156352,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:12:16','',''),(2156408,'1','144','828',360,'Retail Sale Id 1276334',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 14:14:07','',''),(2156410,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:14:07','',''),(2156428,'1','144','828',360,'Retail Sale Id 1276356',5120.00,0.00,0.00,0.00,304.00,'2021-12-04 14:15:11','',''),(2156429,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 14:15:11','',''),(2156460,'1','144','828',360,'Retail Sale Id 1276369',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 14:16:33','',''),(2156461,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:16:33','',''),(2156530,'1','144','828',360,'Retail Sale Id 1276411',91500.00,0.00,0.00,0.00,1200.00,'2021-12-04 14:19:47','',''),(2156531,'1','144','828',360,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-04 14:19:47','',''),(2156570,'1','144','828',360,'Retail Sale Id 1276432',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 14:22:07','',''),(2156571,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 14:22:07','',''),(2156723,'1','144','828',360,'Retail Sale Id 1276505',2995.20,0.00,0.00,0.00,177.84,'2021-12-04 14:31:24','',''),(2156724,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.68,0.00,'2021-12-04 14:31:24','',''),(2156745,'1','144','828',360,'Retail Sale Id 1276520',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 14:32:42','',''),(2156746,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 14:32:42','',''),(2156756,'1','144','828',360,'Retail Sale Id 1276524',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 14:33:35','',''),(2156757,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:33:35','',''),(2157092,'1','144','828',360,'Retail Sale Id 1276643',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 14:48:59','',''),(2157093,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:48:59','',''),(2157116,'1','144','828',360,'Retail Sale Id 1276655',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 14:50:13','',''),(2157117,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:50:13','',''),(2157169,'1','144','828',360,'Retail Sale Id 1276682',998.40,0.00,0.00,0.00,59.28,'2021-12-04 14:53:42','',''),(2157170,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 14:53:42','',''),(2157198,'1','144','828',360,'Retail Sale Id 1276692',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 14:55:00','',''),(2157199,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 14:55:00','',''),(2157240,'1','144','828',360,'Retail Sale Id 1276700',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 14:56:23','',''),(2157241,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 14:56:23','',''),(2157254,'1','144','828',360,'Retail Sale Id 1276709',4000.00,0.00,0.00,0.00,237.50,'2021-12-04 14:57:31','',''),(2157255,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 14:57:31','',''),(2157289,'1','144','828',360,'Retail Sale Id 1276722',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 14:58:42','',''),(2157290,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 14:58:42','',''),(2157308,'1','144','828',360,'Retail Sale Id 1276729',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 14:59:25','',''),(2157309,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:59:25','',''),(2157363,'1','144','828',360,'Retail Sale Id 1276754',2496.00,0.00,0.00,0.00,148.20,'2021-12-04 15:02:38','',''),(2157364,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.90,0.00,'2021-12-04 15:02:38','',''),(2157406,'1','144','828',360,'Retail Sale Id 1276770',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 15:04:48','',''),(2157407,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:04:48','',''),(2157426,'1','144','828',360,'Retail Sale Id 1276783',998.40,0.00,0.00,0.00,59.28,'2021-12-04 15:05:47','',''),(2157427,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 15:05:47','',''),(2157432,'1','144','828',360,'Retail Sale Id 1276788',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 15:06:30','',''),(2157433,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:06:30','',''),(2157454,'1','144','828',360,'Retail Sale Id 1276795',5120.00,0.00,0.00,0.00,304.00,'2021-12-04 15:08:09','',''),(2157455,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 15:08:09','',''),(2157466,'1','144','828',360,'Retail Sale Id 1276807',998.40,0.00,0.00,0.00,59.28,'2021-12-04 15:09:02','',''),(2157467,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 15:09:02','',''),(2157476,'1','144','828',360,'Retail Sale Id 1276813',30500.00,0.00,0.00,0.00,400.00,'2021-12-04 15:10:00','',''),(2157477,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 15:10:00','',''),(2157506,'1','144','828',360,'Retail Sale Id 1276827',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 15:12:10','',''),(2157507,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:12:10','',''),(2157524,'1','144','828',360,'Retail Sale Id 1276836',998.40,0.00,0.00,0.00,59.28,'2021-12-04 15:12:56','',''),(2157525,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 15:12:56','',''),(2157570,'1','144','828',360,'Retail Sale Id 1276854',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 15:14:32','',''),(2157571,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:14:32','',''),(2157678,'1','144','828',360,'Retail Sale Id 1276891',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 15:19:35','',''),(2157679,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:19:35','',''),(2157796,'1','144','828',360,'Retail Sale Id 1276916',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 15:24:58','',''),(2157797,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:24:58','',''),(2157812,'1','144','828',360,'Retail Sale Id 1276952',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 15:25:44','',''),(2157813,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:25:44','',''),(2157856,'1','144','828',360,'Retail Sale Id 1276973',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 15:27:10','',''),(2157857,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:27:10','',''),(2157893,'1','144','828',360,'Retail Sale Id 1276989',4480.00,0.00,0.00,0.00,266.00,'2021-12-04 15:28:37','',''),(2157894,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 15:28:37','',''),(2158100,'1','144','828',360,'Retail Sale Id 1277090',8320.00,0.00,0.00,0.00,494.00,'2021-12-04 15:39:13','',''),(2158101,'1','144','828',360,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-04 15:39:13','',''),(2158146,'1','144','828',360,'Retail Sale Id 1277112',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 15:41:27','',''),(2158147,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:41:27','',''),(2158201,'1','144','828',360,'Retail Sale Id 1277139',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 15:44:04','',''),(2158202,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:44:04','',''),(2158226,'1','144','828',360,'Retail Sale Id 1277149',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 15:44:49','',''),(2158227,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:44:49','',''),(2158346,'1','144','828',360,'Retail Sale Id 1277203',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 15:50:41','',''),(2158347,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:50:41','',''),(2158406,'1','144','828',360,'Retail Sale Id 1277232',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 15:53:31','',''),(2158407,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:53:31','',''),(2158446,'1','144','828',360,'Retail Sale Id 1277256',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 15:55:30','',''),(2158447,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:55:30','',''),(2158510,'1','144','828',360,'Retail Sale Id 1277301',2995.20,0.00,0.00,0.00,177.84,'2021-12-04 15:58:45','',''),(2158511,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.68,0.00,'2021-12-04 15:58:45','',''),(2158539,'1','144','828',360,'Retail Sale Id 1277317',3520.00,0.00,0.00,0.00,209.00,'2021-12-04 15:59:43','',''),(2158540,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-04 15:59:43','',''),(2158571,'1','144','828',360,'Retail Sale Id 1277333',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 16:01:11','',''),(2158572,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:01:11','',''),(2158622,'1','144','828',360,'Retail Sale Id 1277356',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 16:04:16','',''),(2158623,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:04:16','',''),(2158656,'1','144','828',360,'Retail Sale Id 1277376',998.40,0.00,0.00,0.00,59.28,'2021-12-04 16:06:08','',''),(2158657,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 16:06:08','',''),(2158682,'1','144','828',360,'Retail Sale Id 1277388',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 16:07:33','',''),(2158683,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:07:33','',''),(2158855,'1','144','828',360,'Retail Sale Id 1277480',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 16:15:05','',''),(2158856,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:15:05','',''),(2158885,'1','144','828',360,'Retail Sale Id 1277496',2400.00,0.00,0.00,0.00,142.50,'2021-12-04 16:16:17','',''),(2158886,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.75,0.00,'2021-12-04 16:16:17','',''),(2158903,'1','144','828',360,'Retail Sale Id 1277505',1280.00,0.00,0.00,0.00,76.00,'2021-12-04 16:17:31','',''),(2158904,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 16:17:31','',''),(2158927,'1','144','828',360,'Retail Sale Id 1277516',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 16:18:32','',''),(2158928,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:18:32','',''),(2158973,'1','144','828',360,'Retail Sale Id 1277540',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 16:20:53','',''),(2158974,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:20:53','',''),(2159057,'1','144','828',360,'Retail Sale Id 1277587',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 16:24:28','',''),(2159058,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:24:28','',''),(2159087,'1','144','828',360,'Retail Sale Id 1277604',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 16:25:51','',''),(2159088,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:25:51','',''),(2159127,'1','144','828',360,'Retail Sale Id 1277622',1280.00,0.00,0.00,0.00,76.00,'2021-12-04 16:27:16','',''),(2159128,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 16:27:16','',''),(2159350,'1','144','828',360,'Retail Sale Id 1277735',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 16:38:30','',''),(2159351,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:38:30','',''),(2159433,'1','144','828',360,'Retail Sale Id 1277757',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 16:40:37','',''),(2159434,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:40:37','',''),(2159463,'1','144','828',360,'Retail Sale Id 1277767',1280.00,0.00,0.00,0.00,76.00,'2021-12-04 16:41:22','',''),(2159464,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 16:41:22','',''),(2159544,'1','144','828',360,'Retail Sale Id 1277854',1280.00,0.00,0.00,0.00,76.00,'2021-12-04 16:46:21','',''),(2159545,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 16:46:21','',''),(2160471,'1','144','828',360,'Retail Sale Id 1278271',3840.00,0.00,0.00,0.00,228.00,'2021-12-04 17:41:02','',''),(2160472,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 17:41:02','',''),(2160511,'1','144','828',360,'Retail Sale Id 1278278',1920.00,0.00,0.00,0.00,114.00,'2021-12-04 17:42:07','',''),(2160512,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 17:42:07','',''),(2160590,'1','144','828',360,'Retail Sale Id 1278294',3200.00,0.00,0.00,0.00,190.00,'2021-12-04 17:44:40','',''),(2160591,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 17:44:40','',''),(2160618,'1','144','828',360,'Retail Sale Id 1278310',1280.00,0.00,0.00,0.00,76.00,'2021-12-04 17:46:35','',''),(2160619,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 17:46:35','',''),(2160664,'1','144','828',360,'Retail Sale Id 1278320',254982.40,0.00,0.00,0.00,15139.58,'2021-12-04 17:49:13','',''),(2160665,'1','144','828',360,'Retail sales',0.00,0.00,0.00,398.41,0.00,'2021-12-04 17:49:13','',''),(2160675,'1','144','828',360,'Retail Sale Id 1278325',122000.00,0.00,0.00,0.00,1600.00,'2021-12-04 17:50:28','',''),(2160676,'1','144','828',360,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-04 17:50:28','',''),(2161937,'1','144','828',360,'Retail Sale Id 1278609',998.40,0.00,0.00,0.00,59.28,'2021-12-05 05:55:13','',''),(2161938,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 05:55:13','',''),(2161949,'1','144','828',360,'Retail Sale Id 1278614',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 05:59:04','',''),(2161950,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 05:59:04','',''),(2162257,'1','144','828',360,'Retail Sale Id 1278763',998.40,0.00,0.00,0.00,59.28,'2021-12-05 06:33:47','',''),(2162258,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 06:33:47','',''),(2162764,'1','144','828',360,'Retail Sale Id 1279003',30500.00,0.00,0.00,0.00,400.00,'2021-12-05 07:03:32','',''),(2162765,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 07:03:32','',''),(2162873,'1','144','828',360,'Retail Sale Id 1279054',4697.60,0.00,0.00,0.00,278.92,'2021-12-05 07:09:02','',''),(2162874,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.34,0.00,'2021-12-05 07:09:02','',''),(2162899,'1','144','828',360,'Retail Sale Id 1279071',998.40,0.00,0.00,0.00,59.28,'2021-12-05 07:10:23','',''),(2162900,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 07:10:23','',''),(2163397,'1','144','828',360,'Retail Sale Id 1279382',1696.00,0.00,0.00,0.00,100.70,'2021-12-05 07:39:30','',''),(2163398,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.65,0.00,'2021-12-05 07:39:30','',''),(2163544,'1','144','828',360,'Retail Sale Id 1279462',5120.00,0.00,0.00,0.00,304.00,'2021-12-05 07:48:17','',''),(2163545,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 07:48:17','',''),(2163766,'1','144','828',360,'Retail Sale Id 1279568',58419.70,0.00,0.00,0.00,766.16,'2021-12-05 08:00:21','',''),(2163767,'1','144','828',360,'Retail sales',0.00,0.00,0.00,95.77,0.00,'2021-12-05 08:00:21','',''),(2163802,'1','144','828',360,'Retail Sale Id 1279586',2240.00,0.00,0.00,0.00,133.00,'2021-12-05 08:02:15','',''),(2163803,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-05 08:02:15','',''),(2163858,'1','144','828',360,'Retail Sale Id 1279622',91500.00,0.00,0.00,0.00,1200.00,'2021-12-05 08:05:17','',''),(2163859,'1','144','828',360,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-05 08:05:17','',''),(2164144,'1','144','828',360,'Retail Sale Id 1279788',1497.60,0.00,0.00,0.00,88.92,'2021-12-05 08:19:47','',''),(2164145,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 08:19:47','',''),(2164254,'1','144','828',360,'Retail Sale Id 1279836',1280.00,0.00,0.00,0.00,76.00,'2021-12-05 08:23:56','',''),(2164255,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 08:23:56','',''),(2164282,'1','144','828',360,'Retail Sale Id 1279852',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 08:25:24','',''),(2164284,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 08:25:24','',''),(2164306,'1','144','828',360,'Retail Sale Id 1279871',7040.00,0.00,0.00,0.00,418.00,'2021-12-05 08:26:38','',''),(2164307,'1','144','828',360,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-05 08:26:38','',''),(2164376,'1','144','828',360,'Retail Sale Id 1279899',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 08:30:08','',''),(2164377,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:30:08','',''),(2164390,'1','144','828',360,'Retail Sale Id 1279921',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 08:30:57','',''),(2164391,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 08:30:57','',''),(2164418,'1','144','828',360,'Retail Sale Id 1279930',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 08:32:07','',''),(2164419,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 08:32:07','',''),(2164440,'1','144','828',360,'Retail Sale Id 1279941',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 08:32:57','',''),(2164441,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:32:57','',''),(2164468,'1','144','828',360,'Retail Sale Id 1279958',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 08:34:35','',''),(2164469,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:34:35','',''),(2164486,'1','144','828',360,'Retail Sale Id 1279971',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 08:35:22','',''),(2164487,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 08:35:22','',''),(2164500,'1','144','828',360,'Retail Sale Id 1279979',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 08:36:15','',''),(2164501,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 08:36:15','',''),(2164516,'1','144','828',360,'Retail Sale Id 1279988',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 08:37:04','',''),(2164517,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:37:04','',''),(2164536,'1','144','828',360,'Retail Sale Id 1279998',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 08:37:56','',''),(2164537,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:37:56','',''),(2164546,'1','144','828',360,'Retail Sale Id 1280004',4480.00,0.00,0.00,0.00,266.00,'2021-12-05 08:38:56','',''),(2164547,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 08:38:56','',''),(2164628,'1','144','828',360,'Retail Sale Id 1280033',3417.60,0.00,0.00,0.00,202.92,'2021-12-05 08:43:12','',''),(2164629,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-05 08:43:12','',''),(2164701,'1','144','828',360,'Retail Sale Id 1280063',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 08:47:19','',''),(2164702,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:47:19','',''),(2164719,'1','144','828',360,'Retail Sale Id 1280072',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 08:48:04','',''),(2164720,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 08:48:04','',''),(2164733,'1','144','828',360,'Retail Sale Id 1280080',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 08:48:48','',''),(2164734,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:48:48','',''),(2164763,'1','144','828',360,'Retail Sale Id 1280096',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 08:50:43','',''),(2164764,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 08:50:43','',''),(2164789,'1','144','828',360,'Retail Sale Id 1280110',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 08:51:51','',''),(2164790,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 08:51:51','',''),(2164864,'1','144','828',360,'Retail Sale Id 1280157',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 08:56:38','',''),(2164865,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 08:56:38','',''),(2164888,'1','144','828',360,'Retail Sale Id 1280173',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 08:57:49','',''),(2164889,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 08:57:49','',''),(2164967,'1','144','828',360,'Retail Sale Id 1280210',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 09:02:17','',''),(2164968,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 09:02:17','',''),(2164983,'1','144','828',360,'Retail Sale Id 1280217',2560.00,0.00,0.00,0.00,152.00,'2021-12-05 09:03:12','',''),(2164984,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 09:03:12','',''),(2165005,'1','144','828',360,'Retail Sale Id 1280227',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 09:04:07','',''),(2165006,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 09:04:07','',''),(2165023,'1','144','828',360,'Retail Sale Id 1280238',1280.00,0.00,0.00,0.00,76.00,'2021-12-05 09:05:13','',''),(2165024,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 09:05:13','',''),(2165039,'1','144','828',360,'Retail Sale Id 1280246',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 09:06:06','',''),(2165040,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 09:06:06','',''),(2165071,'1','144','828',360,'Retail Sale Id 1280264',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 09:07:41','',''),(2165072,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 09:07:41','',''),(2165199,'1','144','828',360,'Retail Sale Id 1280333',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 09:13:17','',''),(2165200,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 09:13:17','',''),(2165298,'1','144','828',360,'Retail Sale Id 1280414',61000.00,0.00,0.00,0.00,800.00,'2021-12-05 09:20:06','',''),(2165299,'1','144','828',360,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-05 09:20:06','',''),(2165372,'1','144','828',360,'Retail Sale Id 1280455',1196.80,0.00,0.00,0.00,71.06,'2021-12-05 09:24:52','',''),(2165373,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.87,0.00,'2021-12-05 09:24:52','',''),(2165458,'1','144','828',360,'Retail Sale Id 1280507',5120.00,0.00,0.00,0.00,304.00,'2021-12-05 09:29:14','',''),(2165459,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 09:29:14','',''),(2165492,'1','144','828',360,'Retail Sale Id 1280523',152500.00,0.00,0.00,0.00,2000.00,'2021-12-05 09:30:39','',''),(2165493,'1','144','828',360,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-05 09:30:39','',''),(2165582,'1','144','828',360,'Retail Sale Id 1280575',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 09:35:21','',''),(2165583,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 09:35:21','',''),(2166051,'1','144','828',360,'Retail Sale Id 1280779',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 09:56:26','',''),(2166052,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 09:56:26','',''),(2166069,'1','144','828',360,'Retail Sale Id 1280793',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 09:57:43','',''),(2166070,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 09:57:43','',''),(2166093,'1','144','828',360,'Retail Sale Id 1280806',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 09:59:07','',''),(2166094,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 09:59:07','',''),(2166142,'1','144','828',360,'Retail Sale Id 1280833',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 10:02:12','',''),(2166143,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:02:12','',''),(2166169,'1','144','828',360,'Retail Sale Id 1280845',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 10:03:48','',''),(2166170,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:03:48','',''),(2166189,'1','144','828',360,'Retail Sale Id 1280855',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 10:05:03','',''),(2166190,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:05:03','',''),(2166333,'1','144','828',360,'Retail Sale Id 1280927',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 10:14:57','',''),(2166334,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:14:57','',''),(2166349,'1','144','828',360,'Retail Sale Id 1280942',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 10:16:24','',''),(2166350,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:16:24','',''),(2166492,'1','144','828',360,'Retail Sale Id 1281010',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 10:25:32','',''),(2166493,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:25:32','',''),(2166510,'1','144','828',360,'Retail Sale Id 1281021',3520.00,0.00,0.00,0.00,209.00,'2021-12-05 10:26:57','',''),(2166511,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-05 10:26:57','',''),(2166612,'1','144','828',360,'Retail Sale Id 1281073',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 10:32:27','',''),(2166613,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:32:27','',''),(2166668,'1','144','828',360,'Retail Sale Id 1281101',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 10:36:11','',''),(2166669,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:36:11','',''),(2166680,'1','144','828',360,'Retail Sale Id 1281112',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 10:36:52','',''),(2166681,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:36:52','',''),(2166706,'1','144','828',360,'Retail Sale Id 1281121',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 10:38:11','',''),(2166707,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:38:11','',''),(2166720,'1','144','828',360,'Retail Sale Id 1281128',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 10:38:52','',''),(2166721,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:38:52','',''),(2166736,'1','144','828',360,'Retail Sale Id 1281136',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 10:40:01','',''),(2166737,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:40:01','',''),(2166756,'1','144','828',360,'Retail Sale Id 1281143',11200.00,0.00,0.00,0.00,665.00,'2021-12-05 10:41:16','',''),(2166757,'1','144','828',360,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-05 10:41:16','',''),(2166764,'1','144','828',360,'Retail Sale Id 1281150',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 10:42:14','',''),(2166765,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:42:14','',''),(2166790,'1','144','828',360,'Retail Sale Id 1281163',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 10:43:51','',''),(2166791,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:43:51','',''),(2166808,'1','144','828',360,'Retail Sale Id 1281171',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 10:44:31','',''),(2166809,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:44:31','',''),(2166835,'1','144','828',360,'Retail Sale Id 1281189',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 10:45:51','',''),(2166836,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:45:51','',''),(2166847,'1','144','828',360,'Retail Sale Id 1281196',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 10:46:33','',''),(2166848,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:46:33','',''),(2166865,'1','144','828',360,'Retail Sale Id 1281205',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 10:47:22','',''),(2166866,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:47:22','',''),(2166883,'1','144','828',360,'Retail Sale Id 1281216',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 10:48:09','',''),(2166884,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:48:09','',''),(2167114,'1','144','828',360,'Retail Sale Id 1281332',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 11:00:59','',''),(2167115,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 11:00:59','',''),(2167130,'1','144','828',360,'Retail Sale Id 1281339',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 11:01:44','',''),(2167131,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 11:01:44','',''),(2167168,'1','144','828',360,'Retail Sale Id 1281353',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 11:04:53','',''),(2167169,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 11:04:53','',''),(2167182,'1','144','828',360,'Retail Sale Id 1281365',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 11:05:38','',''),(2167183,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 11:05:38','',''),(2167194,'1','144','828',360,'Retail Sale Id 1281370',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 11:06:18','',''),(2167195,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:06:18','',''),(2167212,'1','144','828',360,'Retail Sale Id 1281385',998.40,0.00,0.00,0.00,59.28,'2021-12-05 11:07:25','',''),(2167213,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 11:07:25','',''),(2167571,'1','144','828',360,'Retail Sale Id 1281571',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 11:28:44','',''),(2167572,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:28:44','',''),(2167607,'1','144','828',360,'Retail Sale Id 1281587',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 11:29:41','',''),(2167608,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:29:41','',''),(2167623,'1','144','828',360,'Retail Sale Id 1281597',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 11:30:58','',''),(2167624,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:30:58','',''),(2167643,'1','144','828',360,'Retail Sale Id 1281608',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 11:31:54','',''),(2167644,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:31:54','',''),(2167691,'1','144','828',360,'Retail Sale Id 1281627',998.40,0.00,0.00,0.00,59.28,'2021-12-05 11:33:35','',''),(2167692,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 11:33:35','',''),(2167833,'1','144','828',360,'Retail Sale Id 1281740',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 11:43:31','',''),(2167834,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:43:31','',''),(2167869,'1','144','828',360,'Retail Sale Id 1281753',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 11:45:53','',''),(2167870,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:45:53','',''),(2167889,'1','144','828',360,'Retail Sale Id 1281770',4998.40,0.00,0.00,0.00,296.78,'2021-12-05 11:46:41','',''),(2167890,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 11:46:41','',''),(2167931,'1','144','828',360,'Retail Sale Id 1281796',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 11:49:19','',''),(2167932,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:49:19','',''),(2167947,'1','144','828',360,'Retail Sale Id 1281809',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 11:50:15','',''),(2167948,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:50:15','',''),(2167959,'1','144','828',360,'Retail Sale Id 1281818',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 11:50:56','',''),(2167960,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:50:56','',''),(2167969,'1','144','828',360,'Retail Sale Id 1281821',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 11:51:35','',''),(2167970,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:51:35','',''),(2167984,'1','144','828',360,'Retail Sale Id 1281830',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 11:52:15','',''),(2167985,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:52:15','',''),(2168044,'1','144','828',360,'Retail Sale Id 1281858',5760.00,0.00,0.00,0.00,342.00,'2021-12-05 11:55:49','',''),(2168045,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-05 11:55:49','',''),(2168096,'1','144','828',360,'Retail Sale Id 1281884',5760.00,0.00,0.00,0.00,342.00,'2021-12-05 11:58:25','',''),(2168097,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-05 11:58:25','',''),(2168130,'1','144','828',360,'Retail Sale Id 1281901',5760.00,0.00,0.00,0.00,342.00,'2021-12-05 12:00:28','',''),(2168131,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-05 12:00:28','',''),(2168160,'1','144','828',360,'Retail Sale Id 1281914',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:02:01','',''),(2168161,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:02:01','',''),(2168196,'1','144','828',360,'Retail Sale Id 1281936',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:04:37','',''),(2168197,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:04:37','',''),(2168236,'1','144','828',360,'Retail Sale Id 1281952',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:06:14','',''),(2168237,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:06:14','',''),(2168248,'1','144','828',360,'Retail Sale Id 1281966',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:06:58','',''),(2168249,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:06:58','',''),(2168267,'1','144','828',360,'Retail Sale Id 1281977',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:07:51','',''),(2168268,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:07:51','',''),(2168283,'1','144','828',360,'Retail Sale Id 1281984',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:08:37','',''),(2168284,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:08:37','',''),(2168307,'1','144','828',360,'Retail Sale Id 1281997',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:10:07','',''),(2168308,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:10:07','',''),(2168320,'1','144','828',360,'Retail Sale Id 1282005',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:10:54','',''),(2168321,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:10:54','',''),(2168340,'1','144','828',360,'Retail Sale Id 1282014',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:11:45','',''),(2168341,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:11:45','',''),(2168360,'1','144','828',360,'Retail Sale Id 1282023',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:12:54','',''),(2168361,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:12:54','',''),(2168428,'1','144','828',360,'Retail Sale Id 1282050',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:14:48','',''),(2168429,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:14:48','',''),(2168468,'1','144','828',360,'Retail Sale Id 1282072',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 12:16:47','',''),(2168469,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:16:47','',''),(2168486,'1','144','828',360,'Retail Sale Id 1282077',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 12:17:27','',''),(2168487,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:17:27','',''),(2168502,'1','144','828',360,'Retail Sale Id 1282089',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 12:18:14','',''),(2168503,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:18:14','',''),(2168534,'1','144','828',360,'Retail Sale Id 1282102',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 12:19:28','',''),(2168535,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:19:28','',''),(2168621,'1','144','828',360,'Retail Sale Id 1282146',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 12:23:21','',''),(2168622,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:23:21','',''),(2168664,'1','144','828',360,'Retail Sale Id 1282166',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 12:24:37','',''),(2168665,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:24:37','',''),(2168692,'1','144','828',360,'Retail Sale Id 1282181',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 12:26:00','',''),(2168693,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:26:00','',''),(2168732,'1','144','828',360,'Retail Sale Id 1282200',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 12:27:18','',''),(2168733,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:27:18','',''),(2168756,'1','144','828',360,'Retail Sale Id 1282210',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 12:28:09','',''),(2168757,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:28:09','',''),(2168784,'1','144','828',360,'Retail Sale Id 1282231',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 12:29:46','',''),(2168785,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:29:46','',''),(2168842,'1','144','828',360,'Retail Sale Id 1282249',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 12:32:38','',''),(2168843,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:32:38','',''),(2168874,'1','144','828',360,'Retail Sale Id 1282276',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 12:34:24','',''),(2168875,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:34:24','',''),(2168902,'1','144','828',360,'Retail Sale Id 1282290',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 12:35:56','',''),(2168903,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:35:56','',''),(2168912,'1','144','828',360,'Retail Sale Id 1282297',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:36:46','',''),(2168913,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:36:46','',''),(2168983,'1','144','828',360,'Retail Sale Id 1282335',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:40:24','',''),(2168984,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:40:24','',''),(2169003,'1','144','828',360,'Retail Sale Id 1282345',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:41:18','',''),(2169004,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:41:18','',''),(2169031,'1','144','828',360,'Retail Sale Id 1282360',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:43:07','',''),(2169032,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:43:07','',''),(2169049,'1','144','828',360,'Retail Sale Id 1282371',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:43:49','',''),(2169050,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:43:49','',''),(2169067,'1','144','828',360,'Retail Sale Id 1282379',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:44:36','',''),(2169068,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:44:36','',''),(2169093,'1','144','828',360,'Retail Sale Id 1282396',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:46:13','',''),(2169094,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:46:13','',''),(2169101,'1','144','828',360,'Retail Sale Id 1282401',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 12:46:54','',''),(2169102,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:46:54','',''),(2169123,'1','144','828',360,'Retail Sale Id 1282422',5120.00,0.00,0.00,0.00,304.00,'2021-12-05 12:49:01','',''),(2169124,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 12:49:01','',''),(2169351,'1','144','828',360,'Retail Sale Id 1282538',640.00,0.00,0.00,0.00,38.00,'2021-12-05 13:01:08','',''),(2169352,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-05 13:01:08','',''),(2169385,'1','144','828',360,'Retail Sale Id 1282555',4480.00,0.00,0.00,0.00,266.00,'2021-12-05 13:02:45','',''),(2169386,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 13:02:45','',''),(2169429,'1','144','828',360,'Retail Sale Id 1282573',5760.00,0.00,0.00,0.00,342.00,'2021-12-05 13:04:40','',''),(2169430,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-05 13:04:40','',''),(2169471,'1','144','828',360,'Retail Sale Id 1282624',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 13:07:23','',''),(2169472,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:07:23','',''),(2169497,'1','144','828',360,'Retail Sale Id 1282634',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 13:08:28','',''),(2169498,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:08:28','',''),(2169516,'1','144','828',360,'Retail Sale Id 1282642',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 13:09:59','',''),(2169517,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:09:59','',''),(2169548,'1','144','828',360,'Retail Sale Id 1282660',7040.00,0.00,0.00,0.00,418.00,'2021-12-05 13:11:33','',''),(2169549,'1','144','828',360,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-05 13:11:33','',''),(2169586,'1','144','828',360,'Retail Sale Id 1282680',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 13:13:58','',''),(2169587,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:13:58','',''),(2169598,'1','144','828',360,'Retail Sale Id 1282687',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 13:14:47','',''),(2169599,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:14:47','',''),(2169694,'1','144','828',360,'Retail Sale Id 1282729',24000.00,0.00,0.00,0.00,1425.00,'2021-12-05 13:20:40','',''),(2169695,'1','144','828',360,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-05 13:20:40','',''),(2170202,'1','144','828',360,'Retail Sale Id 1282944',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 13:46:31','',''),(2170203,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 13:46:31','',''),(2170212,'1','144','828',360,'Retail Sale Id 1282952',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 13:47:23','',''),(2170213,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 13:47:23','',''),(2170231,'1','144','828',360,'Retail Sale Id 1282957',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 13:48:10','',''),(2170232,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 13:48:10','',''),(2170245,'1','144','828',360,'Retail Sale Id 1282965',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 13:49:29','',''),(2170246,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 13:49:29','',''),(2170259,'1','144','828',360,'Retail Sale Id 1282971',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 13:50:10','',''),(2170260,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 13:50:10','',''),(2170642,'1','144','828',360,'Retail Sale Id 1283141',4998.40,0.00,0.00,0.00,296.78,'2021-12-05 14:11:29','',''),(2170643,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-05 14:11:29','',''),(2170737,'1','144','828',360,'Retail Sale Id 1283179',1472.00,0.00,0.00,0.00,87.40,'2021-12-05 14:15:29','',''),(2170738,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.30,0.00,'2021-12-05 14:15:29','',''),(2170834,'1','144','828',360,'Retail Sale Id 1283206',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 14:18:29','',''),(2170835,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 14:18:29','',''),(2170861,'1','144','828',360,'Retail Sale Id 1283221',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 14:20:02','',''),(2170862,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 14:20:02','',''),(2170873,'1','144','828',360,'Retail Sale Id 1283226',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 14:20:42','',''),(2170874,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 14:20:42','',''),(2170881,'1','144','828',360,'Retail Sale Id 1283231',3200.00,0.00,0.00,0.00,190.00,'2021-12-05 14:21:23','',''),(2170882,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 14:21:23','',''),(2170893,'1','144','828',360,'Retail Sale Id 1283238',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 14:22:51','',''),(2170894,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:22:51','',''),(2170909,'1','144','828',360,'Retail Sale Id 1283242',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 14:23:33','',''),(2170910,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:23:33','',''),(2170989,'1','144','828',360,'Retail Sale Id 1283284',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 14:29:00','',''),(2170990,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:29:00','',''),(2171005,'1','144','828',360,'Retail Sale Id 1283291',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 14:29:38','',''),(2171006,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:29:38','',''),(2171023,'1','144','828',360,'Retail Sale Id 1283299',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 14:30:26','',''),(2171024,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:30:26','',''),(2171211,'1','144','828',360,'Retail Sale Id 1283351',1497.60,0.00,0.00,0.00,88.92,'2021-12-05 14:38:27','',''),(2171212,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 14:38:27','',''),(2171241,'1','144','828',360,'Retail Sale Id 1283365',4480.00,0.00,0.00,0.00,266.00,'2021-12-05 14:40:40','',''),(2171242,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 14:40:40','',''),(2171421,'1','144','828',360,'Retail Sale Id 1283436',1996.80,0.00,0.00,0.00,118.56,'2021-12-05 14:51:12','',''),(2171422,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.12,0.00,'2021-12-05 14:51:12','',''),(2171435,'1','144','828',360,'Retail Sale Id 1283442',1600.00,0.00,0.00,0.00,95.00,'2021-12-05 14:51:54','',''),(2171436,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-05 14:51:54','',''),(2171459,'1','144','828',360,'Retail Sale Id 1283451',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 14:53:25','',''),(2171460,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:53:25','',''),(2171469,'1','144','828',360,'Retail Sale Id 1283462',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 14:54:15','',''),(2171470,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:54:15','',''),(2171477,'1','144','828',360,'Retail Sale Id 1283467',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 14:54:52','',''),(2171478,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:54:52','',''),(2171483,'1','144','828',360,'Retail Sale Id 1283469',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 14:55:32','',''),(2171484,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:55:32','',''),(2171497,'1','144','828',360,'Retail Sale Id 1283475',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 14:56:18','',''),(2171498,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:56:18','',''),(2171507,'1','144','828',360,'Retail Sale Id 1283480',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 14:57:07','',''),(2171508,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:57:07','',''),(2171517,'1','144','828',360,'Retail Sale Id 1283485',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 14:57:47','',''),(2171518,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:57:47','',''),(2171525,'1','144','828',360,'Retail Sale Id 1283489',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 14:58:41','',''),(2171526,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:58:41','',''),(2171539,'1','144','828',360,'Retail Sale Id 1283497',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 14:59:21','',''),(2171540,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:59:21','',''),(2171557,'1','144','828',360,'Retail Sale Id 1283506',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 15:00:59','',''),(2171558,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:00:59','',''),(2171563,'1','144','828',360,'Retail Sale Id 1283508',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 15:01:44','',''),(2171564,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:01:44','',''),(2171661,'1','144','828',360,'Retail Sale Id 1283558',6400.00,0.00,0.00,0.00,380.00,'2021-12-05 15:09:26','',''),(2171662,'1','144','828',360,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 15:09:26','',''),(2171800,'1','144','828',360,'Retail Sale Id 1283628',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 15:20:07','',''),(2171801,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:20:07','',''),(2171812,'1','144','828',360,'Retail Sale Id 1283631',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 15:20:56','',''),(2171813,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:20:56','',''),(2171822,'1','144','828',360,'Retail Sale Id 1283638',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 15:21:37','',''),(2171823,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:21:37','',''),(2171832,'1','144','828',360,'Retail Sale Id 1283643',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 15:22:16','',''),(2171833,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:22:16','',''),(2171844,'1','144','828',360,'Retail Sale Id 1283650',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 15:22:58','',''),(2171845,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:22:58','',''),(2172072,'1','144','828',360,'Retail Sale Id 1283756',1600.00,0.00,0.00,0.00,95.00,'2021-12-05 15:36:00','',''),(2172073,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-05 15:36:00','',''),(2172106,'1','144','828',360,'Retail Sale Id 1283776',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 15:37:53','',''),(2172107,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:37:53','',''),(2172125,'1','144','828',360,'Retail Sale Id 1283784',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 15:39:05','',''),(2172126,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:39:05','',''),(2172147,'1','144','828',360,'Retail Sale Id 1283796',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 15:40:02','',''),(2172148,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:40:02','',''),(2172175,'1','144','828',360,'Retail Sale Id 1283813',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 15:41:11','',''),(2172176,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:41:11','',''),(2172197,'1','144','828',360,'Retail Sale Id 1283819',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 15:42:05','',''),(2172198,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:42:05','',''),(2172219,'1','144','828',360,'Retail Sale Id 1283831',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 15:42:44','',''),(2172220,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:42:44','',''),(2172311,'1','144','828',360,'Retail Sale Id 1283882',16000.00,0.00,0.00,0.00,950.00,'2021-12-05 15:47:02','',''),(2172312,'1','144','828',360,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 15:47:02','',''),(2172371,'1','144','828',360,'Retail Sale Id 1283916',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 15:50:20','',''),(2172372,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:50:20','',''),(2172395,'1','144','828',360,'Retail Sale Id 1283930',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 15:51:49','',''),(2172396,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:51:49','',''),(2172422,'1','144','828',360,'Retail Sale Id 1283945',6400.00,0.00,0.00,0.00,380.00,'2021-12-05 15:53:31','',''),(2172423,'1','144','828',360,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 15:53:31','',''),(2172440,'1','144','828',360,'Retail Sale Id 1283956',1920.00,0.00,0.00,0.00,114.00,'2021-12-05 15:54:56','',''),(2172441,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:54:56','',''),(2172460,'1','144','828',360,'Retail Sale Id 1283965',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 15:55:47','',''),(2172461,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:55:47','',''),(2172492,'1','144','828',360,'Retail Sale Id 1283982',9920.00,0.00,0.00,0.00,589.00,'2021-12-05 15:58:04','',''),(2172493,'1','144','828',360,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-05 15:58:04','',''),(2172608,'1','144','828',360,'Retail Sale Id 1284036',3840.00,0.00,0.00,0.00,228.00,'2021-12-05 16:04:40','',''),(2172609,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 16:04:40','',''),(2172622,'1','144','828',360,'Retail Sale Id 1284049',4480.00,0.00,0.00,0.00,266.00,'2021-12-05 16:05:46','',''),(2172623,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-05 16:05:46','',''),(2172658,'1','144','828',360,'Retail Sale Id 1284067',24400.00,0.00,0.00,0.00,320.00,'2021-12-05 16:08:03','',''),(2172659,'1','144','828',360,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-05 16:08:03','',''),(2172694,'1','144','828',360,'Retail Sale Id 1284086',2995.20,0.00,0.00,0.00,177.84,'2021-12-05 16:09:52','',''),(2172695,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.68,0.00,'2021-12-05 16:09:52','',''),(2172788,'1','144','828',360,'Retail Sale Id 1284132',8000.00,0.00,0.00,0.00,475.00,'2021-12-05 16:16:22','',''),(2172789,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:16:22','',''),(2172800,'1','144','828',360,'Retail Sale Id 1284137',7680.00,0.00,0.00,0.00,456.00,'2021-12-05 16:17:18','',''),(2172801,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-05 16:17:18','',''),(2172866,'1','144','828',360,'Retail Sale Id 1284177',998.40,0.00,0.00,0.00,59.28,'2021-12-05 16:21:26','',''),(2172867,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 16:21:26','',''),(2172878,'1','144','828',360,'Retail Sale Id 1284184',998.40,0.00,0.00,0.00,59.28,'2021-12-05 16:22:12','',''),(2172879,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 16:22:12','',''),(2172963,'1','144','828',360,'Retail Sale Id 1284231',244000.00,0.00,0.00,0.00,3200.00,'2021-12-05 16:27:38','',''),(2172964,'1','144','828',360,'Retail sales',0.00,0.00,0.00,400.00,0.00,'2021-12-05 16:27:38','',''),(2172977,'1','144','828',360,'Retail Sale Id 1284243',2995.20,0.00,0.00,0.00,177.84,'2021-12-05 16:28:38','',''),(2172978,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.68,0.00,'2021-12-05 16:28:38','',''),(2173862,'1','144','828',360,'Retail Sale Id 1284678',234560.00,0.00,0.00,0.00,13927.00,'2021-12-05 17:29:03','',''),(2173863,'1','144','828',360,'Retail sales',0.00,0.00,0.00,366.50,0.00,'2021-12-05 17:29:03','',''),(2174768,'1','144','828',360,'Retail Sale Id 1284892',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 05:47:32','',''),(2174769,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 05:47:32','',''),(2174772,'1','144','828',360,'Retail Sale Id 1284894',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 05:50:30','',''),(2174773,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 05:50:30','',''),(2174802,'1','144','828',360,'Retail Sale Id 1284908',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 06:02:54','',''),(2174803,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 06:02:54','',''),(2174817,'1','144','828',360,'Retail Sale Id 1284915',6400.00,0.00,0.00,0.00,380.00,'2021-12-06 06:08:58','',''),(2174818,'1','144','828',360,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 06:08:58','',''),(2174827,'1','144','828',360,'Retail Sale Id 1284920',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 06:10:50','',''),(2174828,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 06:10:50','',''),(2174856,'1','144','828',360,'Retail Sale Id 1284932',2560.00,0.00,0.00,0.00,152.00,'2021-12-06 06:14:26','',''),(2174857,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 06:14:26','',''),(2174929,'1','144','828',360,'Retail Sale Id 1284972',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 06:25:58','',''),(2174930,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 06:25:58','',''),(2175009,'1','144','828',360,'Retail Sale Id 1284990',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 06:32:11','',''),(2175010,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 06:32:11','',''),(2175048,'1','144','828',360,'Retail Sale Id 1285002',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 06:34:37','',''),(2175049,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:34:37','',''),(2175069,'1','144','828',360,'Retail Sale Id 1285012',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 06:37:44','',''),(2175070,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:37:44','',''),(2175083,'1','144','828',360,'Retail Sale Id 1285018',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 06:38:58','',''),(2175084,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:38:58','',''),(2175139,'1','144','828',360,'Retail Sale Id 1285045',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 06:45:34','',''),(2175140,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:45:34','',''),(2175159,'1','144','828',360,'Retail Sale Id 1285056',61000.00,0.00,0.00,0.00,800.00,'2021-12-06 06:47:05','',''),(2175160,'1','144','828',360,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 06:47:05','',''),(2175230,'1','144','828',360,'Retail Sale Id 1285095',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 06:52:41','',''),(2175231,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 06:52:41','',''),(2175246,'1','144','828',360,'Retail Sale Id 1285104',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 06:53:35','',''),(2175247,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 06:53:35','',''),(2175324,'1','144','828',360,'Retail Sale Id 1285135',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 06:57:58','',''),(2175325,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 06:57:58','',''),(2175347,'1','144','828',360,'Retail Sale Id 1285145',5760.00,0.00,0.00,0.00,342.00,'2021-12-06 06:59:02','',''),(2175348,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-06 06:59:02','',''),(2175507,'1','144','828',360,'Retail Sale Id 1285206',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 07:09:54','',''),(2175508,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:09:54','',''),(2175567,'1','144','828',360,'Retail Sale Id 1285234',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:14:01','',''),(2175568,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:14:01','',''),(2175578,'1','144','828',360,'Retail Sale Id 1285241',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:14:42','',''),(2175579,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:14:42','',''),(2175596,'1','144','828',360,'Retail Sale Id 1285250',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:15:39','',''),(2175597,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:15:39','',''),(2175616,'1','144','828',360,'Retail Sale Id 1285265',4480.00,0.00,0.00,0.00,266.00,'2021-12-06 07:16:47','',''),(2175617,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 07:16:47','',''),(2175764,'1','144','828',360,'Retail Sale Id 1285341',2944.00,0.00,0.00,0.00,174.80,'2021-12-06 07:25:20','',''),(2175765,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.60,0.00,'2021-12-06 07:25:20','',''),(2175870,'1','144','828',360,'Retail Sale Id 1285391',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 07:32:13','',''),(2175871,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:32:13','',''),(2175893,'1','144','828',360,'Retail Sale Id 1285400',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 07:33:17','',''),(2175894,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:33:17','',''),(2175913,'1','144','828',360,'Retail Sale Id 1285411',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 07:34:15','',''),(2175914,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:34:15','',''),(2175923,'1','144','828',360,'Retail Sale Id 1285418',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 07:34:55','',''),(2175924,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:34:55','',''),(2175935,'1','144','828',360,'Retail Sale Id 1285428',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 07:35:51','',''),(2175936,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:35:51','',''),(2175959,'1','144','828',360,'Retail Sale Id 1285438',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 07:37:10','',''),(2175960,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:37:10','',''),(2175991,'1','144','828',360,'Retail Sale Id 1285446',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 07:38:46','',''),(2175992,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:38:46','',''),(2176019,'1','144','828',360,'Retail Sale Id 1285466',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 07:40:35','',''),(2176020,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:40:35','',''),(2176035,'1','144','828',360,'Retail Sale Id 1285474',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 07:41:17','',''),(2176036,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:41:17','',''),(2176082,'1','144','828',360,'Retail Sale Id 1285495',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 07:42:41','',''),(2176083,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:42:41','',''),(2176097,'1','144','828',360,'Retail Sale Id 1285500',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 07:43:41','',''),(2176098,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:43:41','',''),(2176137,'1','144','828',360,'Retail Sale Id 1285525',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:45:23','',''),(2176138,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:45:23','',''),(2176172,'1','144','828',360,'Retail Sale Id 1285541',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:46:36','',''),(2176173,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:46:36','',''),(2176186,'1','144','828',360,'Retail Sale Id 1285549',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:47:19','',''),(2176187,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:47:19','',''),(2176198,'1','144','828',360,'Retail Sale Id 1285555',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:47:56','',''),(2176199,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:47:56','',''),(2176210,'1','144','828',360,'Retail Sale Id 1285561',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:48:34','',''),(2176211,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:48:34','',''),(2176227,'1','144','828',360,'Retail Sale Id 1285568',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:49:13','',''),(2176228,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:49:13','',''),(2176239,'1','144','828',360,'Retail Sale Id 1285573',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:50:03','',''),(2176240,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:50:03','',''),(2176284,'1','144','828',360,'Retail Sale Id 1285593',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:51:49','',''),(2176285,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:51:49','',''),(2176353,'1','144','828',360,'Retail Sale Id 1285614',11840.00,0.00,0.00,0.00,703.00,'2021-12-06 07:54:32','',''),(2176354,'1','144','828',360,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-06 07:54:32','',''),(2176391,'1','144','828',360,'Retail Sale Id 1285627',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:55:51','',''),(2176392,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:55:51','',''),(2176404,'1','144','828',360,'Retail Sale Id 1285636',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:56:39','',''),(2176405,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:56:39','',''),(2176458,'1','144','828',360,'Retail Sale Id 1285661',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:58:56','',''),(2176459,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:58:56','',''),(2176471,'1','144','828',360,'Retail Sale Id 1285670',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 07:59:57','',''),(2176472,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:59:57','',''),(2176501,'1','144','828',360,'Retail Sale Id 1285687',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 08:01:30','',''),(2176502,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 08:01:30','',''),(2176513,'1','144','828',360,'Retail Sale Id 1285697',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 08:02:19','',''),(2176514,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 08:02:19','',''),(2176527,'1','144','828',360,'Retail Sale Id 1285705',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 08:03:07','',''),(2176528,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 08:03:07','',''),(2176545,'1','144','828',360,'Retail Sale Id 1285718',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 08:04:06','',''),(2176546,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 08:04:06','',''),(2176556,'1','144','828',360,'Retail Sale Id 1285723',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 08:04:55','',''),(2176557,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 08:04:55','',''),(2176572,'1','144','828',360,'Retail Sale Id 1285730',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 08:05:37','',''),(2176573,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 08:05:37','',''),(2176602,'1','144','828',360,'Retail Sale Id 1285746',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 08:07:05','',''),(2176603,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 08:07:05','',''),(2176628,'1','144','828',360,'Retail Sale Id 1285753',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 08:07:44','',''),(2176629,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 08:07:44','',''),(2176636,'1','144','828',360,'Retail Sale Id 1285757',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 08:08:24','',''),(2176637,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 08:08:24','',''),(2176644,'1','144','828',360,'Retail Sale Id 1285760',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 08:09:09','',''),(2176645,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 08:09:09','',''),(2177321,'1','144','828',360,'Retail Sale Id 1286101',11840.00,0.00,0.00,0.00,703.00,'2021-12-06 09:01:31','',''),(2177322,'1','144','828',360,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-06 09:01:31','',''),(2177337,'1','144','828',360,'Retail Sale Id 1286110',998.40,0.00,0.00,0.00,59.28,'2021-12-06 09:02:50','',''),(2177338,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 09:02:50','',''),(2177522,'1','144','828',360,'Retail Sale Id 1286192',4480.00,0.00,0.00,0.00,266.00,'2021-12-06 09:15:27','',''),(2177523,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 09:15:27','',''),(2177572,'1','144','828',360,'Retail Sale Id 1286212',5760.00,0.00,0.00,0.00,342.00,'2021-12-06 09:19:02','',''),(2177573,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-06 09:19:02','',''),(2177641,'1','144','828',360,'Retail Sale Id 1286249',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 09:23:48','',''),(2177642,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:23:48','',''),(2177658,'1','144','828',360,'Retail Sale Id 1286258',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 09:24:50','',''),(2177659,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:24:50','',''),(2177674,'1','144','828',360,'Retail Sale Id 1286264',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 09:25:29','',''),(2177675,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:25:29','',''),(2177692,'1','144','828',360,'Retail Sale Id 1286274',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 09:26:16','',''),(2177693,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:26:16','',''),(2177715,'1','144','828',360,'Retail Sale Id 1286285',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 09:27:38','',''),(2177716,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:27:38','',''),(2177744,'1','144','828',360,'Retail Sale Id 1286298',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 09:29:19','',''),(2177745,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:29:19','',''),(2178026,'1','144','828',360,'Retail Sale Id 1286403',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 09:43:59','',''),(2178027,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:43:59','',''),(2178034,'1','144','828',360,'Retail Sale Id 1286407',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 09:44:38','',''),(2178035,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:44:38','',''),(2178048,'1','144','828',360,'Retail Sale Id 1286415',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 09:45:20','',''),(2178049,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:45:20','',''),(2178058,'1','144','828',360,'Retail Sale Id 1286420',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 09:46:18','',''),(2178059,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:46:18','',''),(2178070,'1','144','828',360,'Retail Sale Id 1286426',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 09:47:22','',''),(2178071,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:47:22','',''),(2178088,'1','144','828',360,'Retail Sale Id 1286436',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 09:48:09','',''),(2178089,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:48:09','',''),(2178232,'1','144','828',360,'Retail Sale Id 1286516',9920.00,0.00,0.00,0.00,589.00,'2021-12-06 09:59:27','',''),(2178233,'1','144','828',360,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-06 09:59:27','',''),(2178960,'1','144','828',360,'Retail Sale Id 1286882',4480.00,0.00,0.00,0.00,266.00,'2021-12-06 10:45:42','',''),(2178961,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 10:45:42','',''),(2179076,'1','144','828',360,'Retail Sale Id 1286953',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 10:52:06','',''),(2179077,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:52:06','',''),(2179094,'1','144','828',360,'Retail Sale Id 1286965',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 10:53:28','',''),(2179095,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:53:28','',''),(2179108,'1','144','828',360,'Retail Sale Id 1286972',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 10:54:08','',''),(2179109,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:54:08','',''),(2179130,'1','144','828',360,'Retail Sale Id 1286982',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 10:55:37','',''),(2179131,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:55:37','',''),(2179145,'1','144','828',360,'Retail Sale Id 1286992',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 10:56:23','',''),(2179146,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:56:23','',''),(2179159,'1','144','828',360,'Retail Sale Id 1287003',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 10:57:11','',''),(2179160,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:57:11','',''),(2179179,'1','144','828',360,'Retail Sale Id 1287017',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 10:58:30','',''),(2179180,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:58:30','',''),(2179203,'1','144','828',360,'Retail Sale Id 1287030',998.40,0.00,0.00,0.00,59.28,'2021-12-06 10:59:47','',''),(2179204,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 10:59:47','',''),(2179221,'1','144','828',360,'Retail Sale Id 1287040',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 11:01:06','',''),(2179222,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 11:01:06','',''),(2179231,'1','144','828',360,'Retail Sale Id 1287044',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 11:01:45','',''),(2179232,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 11:01:45','',''),(2179245,'1','144','828',360,'Retail Sale Id 1287047',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 11:02:52','',''),(2179246,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 11:02:52','',''),(2179267,'1','144','828',360,'Retail Sale Id 1287067',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 11:04:16','',''),(2179268,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 11:04:16','',''),(2179299,'1','144','828',360,'Retail Sale Id 1287082',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 11:06:09','',''),(2179300,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 11:06:09','',''),(2179313,'1','144','828',360,'Retail Sale Id 1287093',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 11:06:54','',''),(2179314,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 11:06:54','',''),(2179337,'1','144','828',360,'Retail Sale Id 1287106',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 11:07:47','',''),(2179338,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 11:07:47','',''),(2179345,'1','144','828',360,'Retail Sale Id 1287109',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 11:08:44','',''),(2179346,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 11:08:44','',''),(2179391,'1','144','828',360,'Retail Sale Id 1287138',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 11:12:13','',''),(2179392,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 11:12:13','',''),(2179431,'1','144','828',360,'Retail Sale Id 1287149',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 11:13:47','',''),(2179432,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 11:13:47','',''),(2179443,'1','144','828',360,'Retail Sale Id 1287155',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 11:14:29','',''),(2179444,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 11:14:29','',''),(2179453,'1','144','828',360,'Retail Sale Id 1287159',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 11:15:10','',''),(2179454,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 11:15:10','',''),(2179463,'1','144','828',360,'Retail Sale Id 1287166',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 11:15:50','',''),(2179464,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 11:15:50','',''),(2179487,'1','144','828',360,'Retail Sale Id 1287181',998.40,0.00,0.00,0.00,59.28,'2021-12-06 11:17:05','',''),(2179488,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 11:17:05','',''),(2179547,'1','144','828',360,'Retail Sale Id 1287216',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 11:20:37','',''),(2179548,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 11:20:37','',''),(2179575,'1','144','828',360,'Retail Sale Id 1287233',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 11:22:12','',''),(2179576,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 11:22:12','',''),(2179599,'1','144','828',360,'Retail Sale Id 1287250',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 11:23:49','',''),(2179600,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 11:23:49','',''),(2179615,'1','144','828',360,'Retail Sale Id 1287259',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 11:25:23','',''),(2179616,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 11:25:23','',''),(2179621,'1','144','828',360,'Retail Sale Id 1287263',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 11:26:03','',''),(2179622,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 11:26:03','',''),(2179649,'1','144','828',360,'Retail Sale Id 1287277',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 11:27:49','',''),(2179650,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 11:27:49','',''),(2179671,'1','144','828',360,'Retail Sale Id 1287288',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 11:29:12','',''),(2179672,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 11:29:12','',''),(2179681,'1','144','828',360,'Retail Sale Id 1287294',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 11:30:19','',''),(2179682,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 11:30:19','',''),(2179693,'1','144','828',360,'Retail Sale Id 1287299',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 11:30:57','',''),(2179694,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 11:30:57','',''),(2179701,'1','144','828',360,'Retail Sale Id 1287303',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 11:31:39','',''),(2179702,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 11:31:39','',''),(2179716,'1','144','828',360,'Retail Sale Id 1287312',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 11:32:16','',''),(2179717,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 11:32:16','',''),(2179952,'1','144','828',360,'Retail Sale Id 1287494',972.80,0.00,0.00,0.00,57.76,'2021-12-06 11:51:14','',''),(2179953,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 11:51:14','',''),(2179996,'1','144','828',360,'Retail Sale Id 1287517',4480.00,0.00,0.00,0.00,266.00,'2021-12-06 11:55:05','',''),(2179997,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 11:55:05','',''),(2180790,'1','144','828',360,'Retail Sale Id 1287937',16000.00,0.00,0.00,0.00,950.00,'2021-12-06 12:43:36','',''),(2180791,'1','144','828',360,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 12:43:36','',''),(2180844,'1','144','828',360,'Retail Sale Id 1287969',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 12:46:52','',''),(2180845,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:46:52','',''),(2180854,'1','144','828',360,'Retail Sale Id 1287971',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 12:47:29','',''),(2180855,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:47:29','',''),(2180886,'1','144','828',360,'Retail Sale Id 1287987',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 12:49:33','',''),(2180887,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:49:33','',''),(2180900,'1','144','828',360,'Retail Sale Id 1287997',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 12:50:17','',''),(2180901,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:50:17','',''),(2180912,'1','144','828',360,'Retail Sale Id 1288004',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 12:50:54','',''),(2180913,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:50:54','',''),(2180933,'1','144','828',360,'Retail Sale Id 1288015',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 12:52:03','',''),(2180934,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:52:03','',''),(2180968,'1','144','828',360,'Retail Sale Id 1288034',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 12:54:19','',''),(2180969,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:54:19','',''),(2180980,'1','144','828',360,'Retail Sale Id 1288038',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 12:54:59','',''),(2180981,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:54:59','',''),(2180998,'1','144','828',360,'Retail Sale Id 1288048',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 12:55:59','',''),(2180999,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:55:59','',''),(2181012,'1','144','828',360,'Retail Sale Id 1288054',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 12:56:41','',''),(2181013,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:56:41','',''),(2181014,'1','144','828',360,'Retail Sale Id 1288058',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 12:57:19','',''),(2181015,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:57:19','',''),(2181026,'1','144','828',360,'Retail Sale Id 1288068',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 12:57:57','',''),(2181027,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:57:57','',''),(2181051,'1','144','828',360,'Retail Sale Id 1288076',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 12:58:37','',''),(2181052,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:58:37','',''),(2181061,'1','144','828',360,'Retail Sale Id 1288081',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 12:59:21','',''),(2181062,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:59:21','',''),(2181116,'1','144','828',360,'Retail Sale Id 1288103',972.80,0.00,0.00,0.00,57.76,'2021-12-06 13:01:35','',''),(2181117,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 13:01:35','',''),(2181379,'1','144','828',360,'Retail Sale Id 1288239',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 13:16:07','',''),(2181380,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 13:16:07','',''),(2181396,'1','144','828',360,'Retail Sale Id 1288242',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 13:17:14','',''),(2181397,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 13:17:14','',''),(2181423,'1','144','828',360,'Retail Sale Id 1288247',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 13:18:04','',''),(2181424,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 13:18:04','',''),(2181439,'1','144','828',360,'Retail Sale Id 1288255',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 13:19:03','',''),(2181440,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 13:19:03','',''),(2181963,'1','144','828',360,'Retail Sale Id 1288487',15250.00,0.00,0.00,0.00,200.00,'2021-12-06 13:48:39','',''),(2181964,'1','144','828',360,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 13:48:39','',''),(2182555,'1','144','828',360,'Retail Sale Id 1288751',30500.00,0.00,0.00,0.00,400.00,'2021-12-06 14:15:47','',''),(2182556,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 14:15:47','',''),(2182591,'1','144','828',360,'Retail Sale Id 1288764',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 14:16:51','',''),(2182592,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:16:51','',''),(2182611,'1','144','828',360,'Retail Sale Id 1288775',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 14:18:02','',''),(2182612,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:18:02','',''),(2182622,'1','144','828',360,'Retail Sale Id 1288782',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 14:18:43','',''),(2182623,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:18:43','',''),(2182664,'1','144','828',360,'Retail Sale Id 1288797',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 14:20:45','',''),(2182665,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:20:45','',''),(2182688,'1','144','828',360,'Retail Sale Id 1288815',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 14:22:04','',''),(2182689,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:22:04','',''),(2182704,'1','144','828',360,'Retail Sale Id 1288822',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 14:22:53','',''),(2182705,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:22:53','',''),(2182804,'1','144','828',360,'Retail Sale Id 1288872',91500.00,0.00,0.00,0.00,1200.00,'2021-12-06 14:28:38','',''),(2182805,'1','144','828',360,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-06 14:28:38','',''),(2182887,'1','144','828',360,'Retail Sale Id 1288916',61000.00,0.00,0.00,0.00,800.00,'2021-12-06 14:33:15','',''),(2182888,'1','144','828',360,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 14:33:15','',''),(2183097,'1','144','828',360,'Retail Sale Id 1289003',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 14:43:42','',''),(2183098,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 14:43:42','',''),(2183119,'1','144','828',360,'Retail Sale Id 1289010',6400.00,0.00,0.00,0.00,380.00,'2021-12-06 14:44:29','',''),(2183120,'1','144','828',360,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 14:44:29','',''),(2183131,'1','144','828',360,'Retail Sale Id 1289016',1984.00,0.00,0.00,0.00,117.80,'2021-12-06 14:45:25','',''),(2183132,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.10,0.00,'2021-12-06 14:45:25','',''),(2183153,'1','144','828',360,'Retail Sale Id 1289028',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 14:47:05','',''),(2183154,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 14:47:05','',''),(2183244,'1','144','828',360,'Retail Sale Id 1289064',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 14:51:12','',''),(2183245,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:51:12','',''),(2183264,'1','144','828',360,'Retail Sale Id 1289077',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 14:51:57','',''),(2183265,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:51:57','',''),(2183295,'1','144','828',360,'Retail Sale Id 1289086',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 14:53:20','',''),(2183296,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:53:20','',''),(2183309,'1','144','828',360,'Retail Sale Id 1289096',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 14:54:01','',''),(2183310,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:54:01','',''),(2183333,'1','144','828',360,'Retail Sale Id 1289107',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 14:55:07','',''),(2183334,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 14:55:07','',''),(2183351,'1','144','828',360,'Retail Sale Id 1289115',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 14:55:55','',''),(2183352,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 14:55:55','',''),(2183539,'1','144','828',360,'Retail Sale Id 1289213',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 15:06:39','',''),(2183540,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:06:39','',''),(2183564,'1','144','828',360,'Retail Sale Id 1289226',1472.00,0.00,0.00,0.00,87.40,'2021-12-06 15:08:05','',''),(2183565,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.30,0.00,'2021-12-06 15:08:05','',''),(2183639,'1','144','828',360,'Retail Sale Id 1289253',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 15:12:31','',''),(2183640,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:12:31','',''),(2183714,'1','144','828',360,'Retail Sale Id 1289285',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 15:16:27','',''),(2183715,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:16:27','',''),(2183891,'1','144','828',360,'Retail Sale Id 1289357',23040.00,0.00,0.00,0.00,1368.00,'2021-12-06 15:23:44','',''),(2183892,'1','144','828',360,'Retail sales',0.00,0.00,0.00,36.00,0.00,'2021-12-06 15:23:44','',''),(2183931,'1','144','828',360,'Retail Sale Id 1289383',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 15:25:21','',''),(2183932,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:25:21','',''),(2184000,'1','144','828',360,'Retail Sale Id 1289419',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 15:29:05','',''),(2184001,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:29:05','',''),(2184121,'1','144','828',360,'Retail Sale Id 1289480',640.00,0.00,0.00,0.00,38.00,'2021-12-06 15:35:59','',''),(2184122,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-06 15:35:59','',''),(2184165,'1','144','828',360,'Retail Sale Id 1289501',6400.00,0.00,0.00,0.00,380.00,'2021-12-06 15:37:56','',''),(2184166,'1','144','828',360,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 15:37:56','',''),(2184353,'1','144','828',360,'Retail Sale Id 1289554',1472.00,0.00,0.00,0.00,87.40,'2021-12-06 15:43:38','',''),(2184354,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.30,0.00,'2021-12-06 15:43:38','',''),(2184373,'1','144','828',360,'Retail Sale Id 1289564',7680.00,0.00,0.00,0.00,456.00,'2021-12-06 15:44:28','',''),(2184374,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-06 15:44:28','',''),(2184395,'1','144','828',360,'Retail Sale Id 1289572',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 15:45:20','',''),(2184396,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:45:20','',''),(2184420,'1','144','828',360,'Retail Sale Id 1289581',5120.00,0.00,0.00,0.00,304.00,'2021-12-06 15:46:07','',''),(2184421,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-06 15:46:07','',''),(2184450,'1','144','828',360,'Retail Sale Id 1289588',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 15:47:03','',''),(2184451,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:47:03','',''),(2184528,'1','144','828',360,'Retail Sale Id 1289626',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 15:51:15','',''),(2184529,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:51:15','',''),(2184546,'1','144','828',360,'Retail Sale Id 1289635',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 15:52:18','',''),(2184547,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:52:18','',''),(2184568,'1','144','828',360,'Retail Sale Id 1289646',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 15:53:37','',''),(2184569,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:53:37','',''),(2184618,'1','144','828',360,'Retail Sale Id 1289669',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 15:56:01','',''),(2184619,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:56:01','',''),(2184735,'1','144','828',360,'Retail Sale Id 1289725',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 16:02:51','',''),(2184736,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 16:02:51','',''),(2184752,'1','144','828',360,'Retail Sale Id 1289735',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 16:03:50','',''),(2184753,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 16:03:50','',''),(2184769,'1','144','828',360,'Retail Sale Id 1289739',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 16:04:57','',''),(2184770,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:04:57','',''),(2184808,'1','144','828',360,'Retail Sale Id 1289756',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 16:06:43','',''),(2184809,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 16:06:43','',''),(2184847,'1','144','828',360,'Retail Sale Id 1289775',4480.00,0.00,0.00,0.00,266.00,'2021-12-06 16:10:01','',''),(2184848,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 16:10:01','',''),(2184859,'1','144','828',360,'Retail Sale Id 1289781',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 16:11:01','',''),(2184860,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:11:01','',''),(2184938,'1','144','828',360,'Retail Sale Id 1289816',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 16:16:08','',''),(2184939,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:16:08','',''),(2184954,'1','144','828',360,'Retail Sale Id 1289824',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 16:17:01','',''),(2184955,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 16:17:01','',''),(2184978,'1','144','828',360,'Retail Sale Id 1289835',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 16:18:09','',''),(2184979,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 16:18:09','',''),(2184997,'1','144','828',360,'Retail Sale Id 1289844',1280.00,0.00,0.00,0.00,76.00,'2021-12-06 16:19:06','',''),(2184998,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 16:19:06','',''),(2185022,'1','144','828',360,'Retail Sale Id 1289859',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 16:20:16','',''),(2185023,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:20:16','',''),(2185045,'1','144','828',360,'Retail Sale Id 1289871',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 16:21:32','',''),(2185046,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:21:32','',''),(2185151,'1','144','828',360,'Retail Sale Id 1289921',972.80,0.00,0.00,0.00,57.76,'2021-12-06 16:26:48','',''),(2185152,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 16:26:48','',''),(2185159,'1','144','828',360,'Retail Sale Id 1289925',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 16:27:33','',''),(2185160,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:27:33','',''),(2185214,'1','144','828',360,'Retail Sale Id 1289955',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 16:30:11','',''),(2185215,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 16:30:11','',''),(2185287,'1','144','828',360,'Retail Sale Id 1289989',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 16:33:29','',''),(2185288,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 16:33:29','',''),(2185350,'1','144','828',360,'Retail Sale Id 1290020',8000.00,0.00,0.00,0.00,475.00,'2021-12-06 16:36:56','',''),(2185351,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:36:56','',''),(2185421,'1','144','828',360,'Retail Sale Id 1290047',3840.00,0.00,0.00,0.00,228.00,'2021-12-06 16:40:24','',''),(2185422,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:40:24','',''),(2185505,'1','144','828',360,'Retail Sale Id 1290092',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 16:46:39','',''),(2185506,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:46:39','',''),(2185535,'1','144','828',360,'Retail Sale Id 1290106',1920.00,0.00,0.00,0.00,114.00,'2021-12-06 16:47:28','',''),(2185536,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:47:28','',''),(2185557,'1','144','828',360,'Retail Sale Id 1290115',3200.00,0.00,0.00,0.00,190.00,'2021-12-06 16:48:09','',''),(2185558,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 16:48:09','',''),(2186118,'1','144','828',360,'Retail Sale Id 1290414',21120.00,0.00,0.00,0.00,1254.00,'2021-12-06 17:27:46','',''),(2186119,'1','144','828',360,'Retail sales',0.00,0.00,0.00,33.00,0.00,'2021-12-06 17:27:46','',''),(2186137,'1','144','828',360,'Retail Sale Id 1290424',183000.00,0.00,0.00,0.00,2400.00,'2021-12-06 17:30:01','',''),(2186138,'1','144','828',360,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-06 17:30:01','',''),(2187160,'1','144','828',360,'Retail Sale Id 1290668',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 06:01:40','',''),(2187161,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:01:40','',''),(2187176,'1','144','828',360,'Retail Sale Id 1290674',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 06:03:25','',''),(2187177,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 06:03:25','',''),(2187186,'1','144','828',360,'Retail Sale Id 1290682',4000.00,0.00,0.00,0.00,237.50,'2021-12-07 06:04:30','',''),(2187187,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 06:04:30','',''),(2187202,'1','144','828',360,'Retail Sale Id 1290688',1280.00,0.00,0.00,0.00,76.00,'2021-12-07 06:05:37','',''),(2187203,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 06:05:37','',''),(2187246,'1','144','828',360,'Retail Sale Id 1290710',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 06:10:00','',''),(2187247,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 06:10:00','',''),(2187264,'1','144','828',360,'Retail Sale Id 1290719',3200.00,0.00,0.00,0.00,190.00,'2021-12-07 06:11:33','',''),(2187265,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 06:11:33','',''),(2187318,'1','144','828',360,'Retail Sale Id 1290741',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 06:16:52','',''),(2187319,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:16:52','',''),(2187358,'1','144','828',360,'Retail Sale Id 1290763',2560.00,0.00,0.00,0.00,152.00,'2021-12-07 06:20:28','',''),(2187359,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 06:20:28','',''),(2187376,'1','144','828',360,'Retail Sale Id 1290771',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 06:22:09','',''),(2187377,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:22:09','',''),(2187400,'1','144','828',360,'Retail Sale Id 1290783',6400.00,0.00,0.00,0.00,380.00,'2021-12-07 06:23:29','',''),(2187401,'1','144','828',360,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 06:23:29','',''),(2187487,'1','144','828',360,'Retail Sale Id 1290826',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 06:30:52','',''),(2187488,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 06:30:52','',''),(2187543,'1','144','828',360,'Retail Sale Id 1290855',3200.00,0.00,0.00,0.00,190.00,'2021-12-07 06:35:35','',''),(2187544,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 06:35:35','',''),(2187625,'1','144','828',360,'Retail Sale Id 1290900',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 06:40:55','',''),(2187626,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 06:40:55','',''),(2187679,'1','144','828',360,'Retail Sale Id 1290931',998.40,0.00,0.00,0.00,59.28,'2021-12-07 06:44:22','',''),(2187680,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 06:44:22','',''),(2187701,'1','144','828',360,'Retail Sale Id 1290944',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 06:46:21','',''),(2187702,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:46:21','',''),(2187813,'1','144','828',360,'Retail Sale Id 1290980',91500.00,0.00,0.00,0.00,1200.00,'2021-12-07 06:52:30','',''),(2187814,'1','144','828',360,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-07 06:52:30','',''),(2187879,'1','144','828',360,'Retail Sale Id 1291011',3200.00,0.00,0.00,0.00,190.00,'2021-12-07 06:57:11','',''),(2187880,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 06:57:11','',''),(2187891,'1','144','828',360,'Retail Sale Id 1291020',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 06:58:11','',''),(2187892,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 06:58:11','',''),(2187916,'1','144','828',360,'Retail Sale Id 1291031',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 06:59:23','',''),(2187917,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:59:23','',''),(2187936,'1','144','828',360,'Retail Sale Id 1291041',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 07:00:16','',''),(2187937,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:00:16','',''),(2188140,'1','144','828',360,'Retail Sale Id 1291145',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 07:10:16','',''),(2188141,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:10:16','',''),(2188156,'1','144','828',360,'Retail Sale Id 1291156',1280.00,0.00,0.00,0.00,76.00,'2021-12-07 07:11:03','',''),(2188157,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 07:11:03','',''),(2188224,'1','144','828',360,'Retail Sale Id 1291185',3200.00,0.00,0.00,0.00,190.00,'2021-12-07 07:14:10','',''),(2188225,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 07:14:10','',''),(2188278,'1','144','828',360,'Retail Sale Id 1291207',9280.00,0.00,0.00,0.00,551.00,'2021-12-07 07:16:32','',''),(2188279,'1','144','828',360,'Retail sales',0.00,0.00,0.00,14.50,0.00,'2021-12-07 07:16:32','',''),(2188307,'1','144','828',360,'Retail Sale Id 1291225',3200.00,0.00,0.00,0.00,190.00,'2021-12-07 07:18:00','',''),(2188309,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 07:18:00','',''),(2189391,'1','144','828',360,'Retail Sale Id 1291782',1600.00,0.00,0.00,0.00,95.00,'2021-12-07 08:13:55','',''),(2189392,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 08:13:55','',''),(2190086,'1','144','828',360,'Retail Sale Id 1292087',972.80,0.00,0.00,0.00,57.76,'2021-12-07 08:50:43','',''),(2190087,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 08:50:43','',''),(2190150,'1','144','828',360,'Retail Sale Id 1292115',5120.00,0.00,0.00,0.00,304.00,'2021-12-07 08:54:13','',''),(2190151,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-07 08:54:13','',''),(2190395,'1','144','828',360,'Retail Sale Id 1292235',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 09:09:41','',''),(2190396,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:09:41','',''),(2190407,'1','144','828',360,'Retail Sale Id 1292242',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 09:10:23','',''),(2190408,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:10:23','',''),(2190425,'1','144','828',360,'Retail Sale Id 1292253',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 09:11:33','',''),(2190426,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:11:33','',''),(2190441,'1','144','828',360,'Retail Sale Id 1292259',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 09:12:24','',''),(2190442,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:12:24','',''),(2190459,'1','144','828',360,'Retail Sale Id 1292271',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 09:13:03','',''),(2190460,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:13:03','',''),(2190467,'1','144','828',360,'Retail Sale Id 1292275',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 09:13:43','',''),(2190468,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:13:43','',''),(2190485,'1','144','828',360,'Retail Sale Id 1292283',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 09:14:36','',''),(2190486,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:14:36','',''),(2190507,'1','144','828',360,'Retail Sale Id 1292297',7040.00,0.00,0.00,0.00,418.00,'2021-12-07 09:15:24','',''),(2190508,'1','144','828',360,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-07 09:15:24','',''),(2190537,'1','144','828',360,'Retail Sale Id 1292312',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 09:17:16','',''),(2190538,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:17:16','',''),(2190571,'1','144','828',360,'Retail Sale Id 1292327',9600.00,0.00,0.00,0.00,570.00,'2021-12-07 09:19:21','',''),(2190572,'1','144','828',360,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-07 09:19:21','',''),(2190593,'1','144','828',360,'Retail Sale Id 1292338',30500.00,0.00,0.00,0.00,400.00,'2021-12-07 09:20:25','',''),(2190594,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 09:20:25','',''),(2190621,'1','144','828',360,'Retail Sale Id 1292350',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 09:21:53','',''),(2190622,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:21:53','',''),(2190649,'1','144','828',360,'Retail Sale Id 1292361',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 09:23:32','',''),(2190650,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:23:32','',''),(2190727,'1','144','828',360,'Retail Sale Id 1292399',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 09:27:21','',''),(2190728,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:27:21','',''),(2190750,'1','144','828',360,'Retail Sale Id 1292405',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 09:28:07','',''),(2190751,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:28:07','',''),(2190770,'1','144','828',360,'Retail Sale Id 1292416',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 09:28:55','',''),(2190771,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:28:55','',''),(2190796,'1','144','828',360,'Retail Sale Id 1292431',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 09:29:52','',''),(2190797,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:29:52','',''),(2190972,'1','144','828',360,'Retail Sale Id 1292517',5120.00,0.00,0.00,0.00,304.00,'2021-12-07 09:39:25','',''),(2190973,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-07 09:39:25','',''),(2191022,'1','144','828',360,'Retail Sale Id 1292545',7625.00,0.00,0.00,0.00,100.00,'2021-12-07 09:41:59','',''),(2191023,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:41:59','',''),(2191050,'1','144','828',360,'Retail Sale Id 1292560',640.00,0.00,0.00,0.00,38.00,'2021-12-07 09:43:37','',''),(2191051,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 09:43:37','',''),(2191429,'1','144','828',360,'Retail Sale Id 1292753',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:10:30','',''),(2191430,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:10:30','',''),(2191449,'1','144','828',360,'Retail Sale Id 1292768',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:11:35','',''),(2191450,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:11:35','',''),(2191465,'1','144','828',360,'Retail Sale Id 1292777',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:12:26','',''),(2191466,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:12:26','',''),(2191473,'1','144','828',360,'Retail Sale Id 1292783',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:13:15','',''),(2191474,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:13:15','',''),(2191490,'1','144','828',360,'Retail Sale Id 1292788',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:14:35','',''),(2191491,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:14:35','',''),(2191505,'1','144','828',360,'Retail Sale Id 1292799',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:15:21','',''),(2191506,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:15:21','',''),(2191797,'1','144','828',360,'Retail Sale Id 1292949',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:37:55','',''),(2191798,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:37:55','',''),(2191815,'1','144','828',360,'Retail Sale Id 1292958',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:38:49','',''),(2191816,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:38:49','',''),(2191829,'1','144','828',360,'Retail Sale Id 1292965',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:39:44','',''),(2191830,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:39:44','',''),(2191842,'1','144','828',360,'Retail Sale Id 1292971',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:40:31','',''),(2191844,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:40:31','',''),(2191853,'1','144','828',360,'Retail Sale Id 1292982',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:41:18','',''),(2191854,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:41:18','',''),(2191887,'1','144','828',360,'Retail Sale Id 1292993',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:43:03','',''),(2191888,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:43:03','',''),(2191901,'1','144','828',360,'Retail Sale Id 1293001',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:44:03','',''),(2191902,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:44:03','',''),(2191925,'1','144','828',360,'Retail Sale Id 1293009',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:44:43','',''),(2191926,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:44:43','',''),(2191937,'1','144','828',360,'Retail Sale Id 1293015',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:45:23','',''),(2191938,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:45:23','',''),(2191963,'1','144','828',360,'Retail Sale Id 1293025',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 10:46:20','',''),(2191964,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:46:20','',''),(2191988,'1','144','828',360,'Retail Sale Id 1293033',1472.00,0.00,0.00,0.00,87.40,'2021-12-07 10:47:30','',''),(2191989,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.30,0.00,'2021-12-07 10:47:30','',''),(2192058,'1','144','828',360,'Retail Sale Id 1293058',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 10:51:22','',''),(2192059,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:51:22','',''),(2192078,'1','144','828',360,'Retail Sale Id 1293079',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 10:52:04','',''),(2192079,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:52:04','',''),(2192116,'1','144','828',360,'Retail Sale Id 1293098',30500.00,0.00,0.00,0.00,400.00,'2021-12-07 10:54:03','',''),(2192117,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 10:54:03','',''),(2192137,'1','144','828',360,'Retail Sale Id 1293110',1472.00,0.00,0.00,0.00,87.40,'2021-12-07 10:55:21','',''),(2192138,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.30,0.00,'2021-12-07 10:55:21','',''),(2192163,'1','144','828',360,'Retail Sale Id 1293121',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 10:56:49','',''),(2192164,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:56:49','',''),(2192195,'1','144','828',360,'Retail Sale Id 1293135',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 10:58:49','',''),(2192196,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:58:49','',''),(2192213,'1','144','828',360,'Retail Sale Id 1293147',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 10:59:32','',''),(2192214,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:59:32','',''),(2192219,'1','144','828',360,'Retail Sale Id 1293151',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 11:00:12','',''),(2192220,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:00:12','',''),(2192240,'1','144','828',360,'Retail Sale Id 1293156',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 11:01:03','',''),(2192241,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:01:03','',''),(2192246,'1','144','828',360,'Retail Sale Id 1293159',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 11:01:48','',''),(2192247,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:01:48','',''),(2192282,'1','144','828',360,'Retail Sale Id 1293165',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 11:02:23','',''),(2192283,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:02:23','',''),(2192294,'1','144','828',360,'Retail Sale Id 1293172',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 11:03:00','',''),(2192295,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:03:00','',''),(2192304,'1','144','828',360,'Retail Sale Id 1293180',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 11:03:44','',''),(2192306,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:03:44','',''),(2192322,'1','144','828',360,'Retail Sale Id 1293187',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 11:04:33','',''),(2192323,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:04:33','',''),(2192402,'1','144','828',360,'Retail Sale Id 1293226',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 11:08:37','',''),(2192403,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:08:37','',''),(2192414,'1','144','828',360,'Retail Sale Id 1293231',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 11:09:24','',''),(2192415,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:09:24','',''),(2192434,'1','144','828',360,'Retail Sale Id 1293241',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 11:10:07','',''),(2192435,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:10:07','',''),(2192454,'1','144','828',360,'Retail Sale Id 1293256',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 11:10:58','',''),(2192455,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:10:58','',''),(2192476,'1','144','828',360,'Retail Sale Id 1293267',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 11:11:57','',''),(2192477,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:11:57','',''),(2192594,'1','144','828',360,'Retail Sale Id 1293350',1472.00,0.00,0.00,0.00,87.40,'2021-12-07 11:20:23','',''),(2192595,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.30,0.00,'2021-12-07 11:20:23','',''),(2192664,'1','144','828',360,'Retail Sale Id 1293397',972.80,0.00,0.00,0.00,57.76,'2021-12-07 11:26:06','',''),(2192665,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 11:26:06','',''),(2193019,'1','144','828',360,'Retail Sale Id 1293563',61000.00,0.00,0.00,0.00,800.00,'2021-12-07 11:50:50','',''),(2193020,'1','144','828',360,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-07 11:50:50','',''),(2193085,'1','144','828',360,'Retail Sale Id 1293605',152500.00,0.00,0.00,0.00,2000.00,'2021-12-07 11:56:55','',''),(2193086,'1','144','828',360,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-07 11:56:55','',''),(2193107,'1','144','828',360,'Retail Sale Id 1293614',41600.00,0.00,0.00,0.00,2470.00,'2021-12-07 11:58:50','',''),(2193108,'1','144','828',360,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-07 11:58:50','',''),(2193383,'1','144','828',360,'Retail Sale Id 1293775',972.80,0.00,0.00,0.00,57.76,'2021-12-07 12:25:08','',''),(2193384,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 12:25:08','',''),(2194031,'1','144','828',360,'Retail Sale Id 1294112',3968.00,0.00,0.00,0.00,235.60,'2021-12-07 13:11:40','',''),(2194032,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.20,0.00,'2021-12-07 13:11:40','',''),(2194258,'1','144','828',360,'Retail Sale Id 1294286',972.80,0.00,0.00,0.00,57.76,'2021-12-07 13:25:29','',''),(2194259,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 13:25:29','',''),(2194311,'1','144','828',360,'Retail Sale Id 1294330',1472.00,0.00,0.00,0.00,87.40,'2021-12-07 13:27:27','',''),(2194312,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.30,0.00,'2021-12-07 13:27:27','',''),(2194524,'1','144','828',360,'Retail Sale Id 1294409',972.80,0.00,0.00,0.00,57.76,'2021-12-07 13:38:15','',''),(2194525,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 13:38:15','',''),(2194837,'1','144','828',360,'Retail Sale Id 1294552',9920.00,0.00,0.00,0.00,589.00,'2021-12-07 13:57:48','',''),(2194838,'1','144','828',360,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-07 13:57:48','',''),(2194853,'1','144','828',360,'Retail Sale Id 1294561',972.80,0.00,0.00,0.00,57.76,'2021-12-07 13:59:01','',''),(2194854,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 13:59:01','',''),(2194951,'1','144','828',360,'Retail Sale Id 1294613',972.80,0.00,0.00,0.00,57.76,'2021-12-07 14:06:13','',''),(2194952,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 14:06:13','',''),(2195462,'1','144','828',360,'Retail Sale Id 1294827',7040.00,0.00,0.00,0.00,418.00,'2021-12-07 14:33:16','',''),(2195463,'1','144','828',360,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-07 14:33:16','',''),(2195493,'1','144','828',360,'Retail Sale Id 1294850',4480.00,0.00,0.00,0.00,266.00,'2021-12-07 14:34:52','',''),(2195494,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 14:34:52','',''),(2195776,'1','144','828',360,'Retail Sale Id 1295005',1472.00,0.00,0.00,0.00,87.40,'2021-12-07 14:49:54','',''),(2195777,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.30,0.00,'2021-12-07 14:49:54','',''),(2195834,'1','144','828',360,'Retail Sale Id 1295033',4992.00,0.00,0.00,0.00,296.40,'2021-12-07 14:52:03','',''),(2195835,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.80,0.00,'2021-12-07 14:52:03','',''),(2196080,'1','144','828',360,'Retail Sale Id 1295152',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 15:07:16','',''),(2196081,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:07:16','',''),(2196090,'1','144','828',360,'Retail Sale Id 1295158',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 15:08:06','',''),(2196091,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:08:06','',''),(2196106,'1','144','828',360,'Retail Sale Id 1295167',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 15:08:51','',''),(2196107,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:08:51','',''),(2196126,'1','144','828',360,'Retail Sale Id 1295180',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 15:09:41','',''),(2196127,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:09:41','',''),(2196148,'1','144','828',360,'Retail Sale Id 1295190',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 15:10:54','',''),(2196149,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:10:54','',''),(2196182,'1','144','828',360,'Retail Sale Id 1295205',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 15:12:08','',''),(2196183,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:12:08','',''),(2196204,'1','144','828',360,'Retail Sale Id 1295217',1984.00,0.00,0.00,0.00,117.80,'2021-12-07 15:13:25','',''),(2196205,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.10,0.00,'2021-12-07 15:13:25','',''),(2196340,'1','144','828',360,'Retail Sale Id 1295281',972.80,0.00,0.00,0.00,57.76,'2021-12-07 15:20:46','',''),(2196341,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 15:20:46','',''),(2196380,'1','144','828',360,'Retail Sale Id 1295310',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 15:23:10','',''),(2196381,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:23:10','',''),(2196392,'1','144','828',360,'Retail Sale Id 1295317',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 15:24:05','',''),(2196393,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:24:05','',''),(2196430,'1','144','828',360,'Retail Sale Id 1295334',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 15:25:32','',''),(2196431,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:25:32','',''),(2196470,'1','144','828',360,'Retail Sale Id 1295352',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 15:27:14','',''),(2196471,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:27:14','',''),(2196484,'1','144','828',360,'Retail Sale Id 1295362',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 15:27:54','',''),(2196485,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:27:54','',''),(2196500,'1','144','828',360,'Retail Sale Id 1295370',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 15:28:34','',''),(2196501,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:28:34','',''),(2196720,'1','144','828',360,'Retail Sale Id 1295477',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 15:39:11','',''),(2196721,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:39:11','',''),(2196829,'1','144','828',360,'Retail Sale Id 1295525',2240.00,0.00,0.00,0.00,133.00,'2021-12-07 15:44:14','',''),(2196830,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-07 15:44:14','',''),(2196988,'1','144','828',360,'Retail Sale Id 1295608',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 15:51:46','',''),(2196989,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:51:46','',''),(2197147,'1','144','828',360,'Retail Sale Id 1295689',16000.00,0.00,0.00,0.00,950.00,'2021-12-07 15:58:55','',''),(2197148,'1','144','828',360,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 15:58:55','',''),(2197263,'1','144','828',360,'Retail Sale Id 1295747',972.80,0.00,0.00,0.00,57.76,'2021-12-07 16:05:04','',''),(2197264,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 16:05:04','',''),(2197362,'1','144','828',360,'Retail Sale Id 1295798',5760.00,0.00,0.00,0.00,342.00,'2021-12-07 16:09:15','',''),(2197363,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-07 16:09:15','',''),(2197376,'1','144','828',360,'Retail Sale Id 1295806',1984.00,0.00,0.00,0.00,117.80,'2021-12-07 16:10:13','',''),(2197377,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.10,0.00,'2021-12-07 16:10:13','',''),(2197412,'1','144','828',360,'Retail Sale Id 1295824',4480.00,0.00,0.00,0.00,266.00,'2021-12-07 16:12:15','',''),(2197413,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 16:12:15','',''),(2197430,'1','144','828',360,'Retail Sale Id 1295836',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 16:13:01','',''),(2197431,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:13:01','',''),(2197470,'1','144','828',360,'Retail Sale Id 1295859',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 16:15:21','',''),(2197471,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:15:21','',''),(2197576,'1','144','828',360,'Retail Sale Id 1295919',7680.00,0.00,0.00,0.00,456.00,'2021-12-07 16:19:19','',''),(2197577,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 16:19:19','',''),(2197737,'1','144','828',360,'Retail Sale Id 1296000',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 16:27:12','',''),(2197738,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:27:12','',''),(2197761,'1','144','828',360,'Retail Sale Id 1296011',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 16:28:16','',''),(2197762,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:28:16','',''),(2197839,'1','144','828',360,'Retail Sale Id 1296056',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 16:31:49','',''),(2197840,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:31:49','',''),(2197868,'1','144','828',360,'Retail Sale Id 1296071',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 16:33:15','',''),(2197869,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:33:15','',''),(2198022,'1','144','828',360,'Retail Sale Id 1296155',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 16:43:05','',''),(2198023,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:43:05','',''),(2198035,'1','144','828',360,'Retail Sale Id 1296159',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 16:43:59','',''),(2198036,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:43:59','',''),(2199194,'1','144','828',360,'Retail Sale Id 1296714',8000.00,0.00,0.00,0.00,475.00,'2021-12-07 18:41:32','',''),(2199195,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 18:41:32','',''),(2199196,'1','144','828',360,'Retail Sale Id 1296715',3840.00,0.00,0.00,0.00,228.00,'2021-12-07 18:43:05','',''),(2199197,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 18:43:05','',''),(2199200,'1','144','828',360,'Retail Sale Id 1296718',3200.00,0.00,0.00,0.00,190.00,'2021-12-07 18:44:28','',''),(2199201,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 18:44:28','',''),(2199204,'1','144','828',360,'Retail Sale Id 1296719',1280.00,0.00,0.00,0.00,76.00,'2021-12-07 18:45:45','',''),(2199205,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 18:45:45','',''),(2199210,'1','144','828',360,'Retail Sale Id 1296723',1920.00,0.00,0.00,0.00,114.00,'2021-12-07 18:47:36','',''),(2199211,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 18:47:36','',''),(2199216,'1','144','828',360,'Retail Sale Id 1296725',2560.00,0.00,0.00,0.00,152.00,'2021-12-07 18:49:35','',''),(2199217,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 18:49:35','',''),(2199230,'1','144','828',360,'Retail Sale Id 1296729',235782.40,0.00,0.00,0.00,13999.58,'2021-12-07 18:54:13','',''),(2199231,'1','144','828',360,'Retail sales',0.00,0.00,0.00,368.41,0.00,'2021-12-07 18:54:13','',''),(2199232,'1','144','828',360,'Retail Sale Id 1296730',183000.00,0.00,0.00,0.00,2400.00,'2021-12-07 18:55:14','',''),(2199233,'1','144','828',360,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-07 18:55:14','',''),(2199234,'1','144','828',360,'Retail Sale Id 1296731',1393800.00,0.00,0.00,0.00,9200.00,'2021-12-07 18:56:17','',''),(2199235,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2300.00,0.00,'2021-12-07 18:56:17','',''),(2199283,'1','144','828',360,'Distributed to OPERATIONAL LOSS for sales id:337855',200201.12,0.00,0.00,332.56,0.00,'2021-12-07 19:19:22','',''),(2199302,'1','144',NULL,360,'Purchased from A.A RANO NIGERIA LIMITED',0.00,14950000.00,25000.00,0.00,0.00,'2021-12-07 19:24:41','',''),(2199309,'1','144',NULL,360,'Reception corrector for bridging 126524',0.00,0.00,0.00,20000.00,0.00,'2021-12-07 19:26:06','',''),(2199310,'1','144','828',360,'Received from bridging 126524',0.00,0.00,20000.00,0.00,0.00,'2021-12-07 19:26:06','',''),(2199725,'1','144','828',360,'Retail Sale Id 1296779',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 05:56:50','',''),(2199726,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 05:56:50','',''),(2199737,'1','144','828',360,'Retail Sale Id 1296785',8000.00,0.00,0.00,0.00,525.00,'2021-12-08 06:02:30','',''),(2199738,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:02:30','',''),(2199745,'1','144','828',360,'Retail Sale Id 1296790',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 06:03:46','',''),(2199746,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 06:03:46','',''),(2199761,'1','144','828',360,'Retail Sale Id 1296798',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 06:08:08','',''),(2199762,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 06:08:08','',''),(2199801,'1','144','828',360,'Retail Sale Id 1296810',2560.00,0.00,0.00,0.00,168.00,'2021-12-08 06:13:53','',''),(2199802,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 06:13:53','',''),(2199811,'1','144','828',360,'Retail Sale Id 1296815',3200.00,0.00,0.00,0.00,210.00,'2021-12-08 06:16:01','',''),(2199812,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 06:16:01','',''),(2199878,'1','144','828',360,'Retail Sale Id 1296841',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 06:23:17','',''),(2199879,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 06:23:17','',''),(2199892,'1','144','828',360,'Retail Sale Id 1296847',1280.00,0.00,0.00,0.00,84.00,'2021-12-08 06:24:47','',''),(2199893,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 06:24:47','',''),(2199930,'1','144','828',360,'Retail Sale Id 1296866',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 06:29:42','',''),(2199931,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 06:29:42','',''),(2200119,'1','144','828',360,'Retail Sale Id 1296950',5120.00,0.00,0.00,0.00,336.00,'2021-12-08 06:44:22','',''),(2200120,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-08 06:44:22','',''),(2200184,'1','144','828',360,'Retail Sale Id 1296970',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 06:46:36','',''),(2200185,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 06:46:36','',''),(2200198,'1','144','828',360,'Retail Sale Id 1296976',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 06:47:40','',''),(2200199,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 06:47:40','',''),(2200240,'1','144','828',360,'Retail Sale Id 1296985',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 06:48:54','',''),(2200241,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 06:48:54','',''),(2200284,'1','144','828',360,'Retail Sale Id 1296998',1497.60,0.00,0.00,0.00,98.28,'2021-12-08 06:51:26','',''),(2200285,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 06:51:26','',''),(2200314,'1','144','828',360,'Retail Sale Id 1297019',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 06:54:22','',''),(2200315,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 06:54:22','',''),(2200417,'1','144','828',360,'Retail Sale Id 1297063',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 06:59:04','',''),(2200418,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 06:59:04','',''),(2200453,'1','144','828',360,'Retail Sale Id 1297079',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 07:00:38','',''),(2200454,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 07:00:38','',''),(2200503,'1','144','828',360,'Retail Sale Id 1297105',3968.00,0.00,0.00,0.00,260.40,'2021-12-08 07:04:05','',''),(2200504,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.20,0.00,'2021-12-08 07:04:05','',''),(2200511,'1','144','828',360,'Retail Sale Id 1297110',2560.00,0.00,0.00,0.00,168.00,'2021-12-08 07:04:54','',''),(2200512,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 07:04:54','',''),(2200541,'1','144','828',360,'Retail Sale Id 1297124',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 07:06:22','',''),(2200542,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 07:06:22','',''),(2200721,'1','144','828',360,'Retail Sale Id 1297209',3200.00,0.00,0.00,0.00,210.00,'2021-12-08 07:18:13','',''),(2200722,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 07:18:13','',''),(2200749,'1','144','828',360,'Retail Sale Id 1297222',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 07:19:12','',''),(2200750,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 07:19:12','',''),(2200776,'1','144','828',360,'Retail Sale Id 1297230',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 07:20:09','',''),(2200777,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 07:20:09','',''),(2200989,'1','144','828',360,'Retail Sale Id 1297330',8000.00,0.00,0.00,0.00,525.00,'2021-12-08 07:32:17','',''),(2200990,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:32:17','',''),(2201009,'1','144','828',360,'Retail Sale Id 1297341',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 07:33:22','',''),(2201010,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 07:33:22','',''),(2201033,'1','144','828',360,'Retail Sale Id 1297352',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 07:34:08','',''),(2201034,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 07:34:08','',''),(2201154,'1','144','828',360,'Retail Sale Id 1297403',8000.00,0.00,0.00,0.00,525.00,'2021-12-08 07:39:55','',''),(2201155,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:39:55','',''),(2201180,'1','144','828',360,'Retail Sale Id 1297415',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 07:41:34','',''),(2201181,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 07:41:34','',''),(2201194,'1','144','828',360,'Retail Sale Id 1297422',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 07:42:20','',''),(2201195,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 07:42:20','',''),(2201208,'1','144','828',360,'Retail Sale Id 1297431',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 07:43:16','',''),(2201209,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 07:43:16','',''),(2201489,'1','144','828',360,'Retail Sale Id 1297553',972.80,0.00,0.00,0.00,63.84,'2021-12-08 07:57:16','',''),(2201490,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-08 07:57:16','',''),(2201583,'1','144','828',360,'Retail Sale Id 1297600',4992.00,0.00,0.00,0.00,327.60,'2021-12-08 08:02:11','',''),(2201584,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.80,0.00,'2021-12-08 08:02:11','',''),(2201635,'1','144','828',360,'Retail Sale Id 1297618',30500.00,0.00,0.00,0.00,600.00,'2021-12-08 08:04:20','',''),(2201636,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 08:04:20','',''),(2201667,'1','144','828',360,'Retail Sale Id 1297634',100650.00,0.00,0.00,0.00,1980.00,'2021-12-08 08:05:51','',''),(2201668,'1','144','828',360,'Retail sales',0.00,0.00,0.00,165.00,0.00,'2021-12-08 08:05:51','',''),(2201782,'1','144','828',360,'Retail Sale Id 1297697',1984.00,0.00,0.00,0.00,130.20,'2021-12-08 08:14:46','',''),(2201783,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.10,0.00,'2021-12-08 08:14:46','',''),(2202032,'1','144','828',360,'Retail Sale Id 1297821',32000.00,0.00,0.00,0.00,2100.00,'2021-12-08 08:30:34','',''),(2202033,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 08:30:34','',''),(2202407,'1','144','828',360,'Retail Sale Id 1297957',24400.00,0.00,0.00,0.00,480.00,'2021-12-08 08:48:04','',''),(2202408,'1','144','828',360,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-08 08:48:04','',''),(2203015,'1','144','828',360,'Retail Sale Id 1298244',61000.00,0.00,0.00,0.00,1200.00,'2021-12-08 09:23:19','',''),(2203016,'1','144','828',360,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-08 09:23:19','',''),(2203105,'1','144','828',360,'Retail Sale Id 1298289',4480.00,0.00,0.00,0.00,294.00,'2021-12-08 09:32:26','',''),(2203106,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 09:32:26','',''),(2203239,'1','144','828',360,'Retail Sale Id 1298356',40000.00,0.00,0.00,0.00,2625.00,'2021-12-08 09:43:25','',''),(2203240,'1','144','828',360,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-08 09:43:25','',''),(2203757,'1','144','828',360,'Retail Sale Id 1298593',7680.00,0.00,0.00,0.00,504.00,'2021-12-08 10:18:27','',''),(2203758,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-08 10:18:27','',''),(2203815,'1','144','828',360,'Retail Sale Id 1298630',4480.00,0.00,0.00,0.00,294.00,'2021-12-08 10:22:24','',''),(2203816,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 10:22:24','',''),(2203848,'1','144','828',360,'Retail Sale Id 1298640',4992.00,0.00,0.00,0.00,327.60,'2021-12-08 10:23:54','',''),(2203849,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.80,0.00,'2021-12-08 10:23:54','',''),(2203891,'1','144','828',360,'Retail Sale Id 1298658',5760.00,0.00,0.00,0.00,378.00,'2021-12-08 10:26:10','',''),(2203892,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-08 10:26:10','',''),(2203959,'1','144','828',360,'Retail Sale Id 1298684',4480.00,0.00,0.00,0.00,294.00,'2021-12-08 10:30:16','',''),(2203960,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 10:30:16','',''),(2204013,'1','144','828',360,'Retail Sale Id 1298710',5120.00,0.00,0.00,0.00,336.00,'2021-12-08 10:33:38','',''),(2204014,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-08 10:33:38','',''),(2204093,'1','144','828',360,'Retail Sale Id 1298752',1248.00,0.00,0.00,0.00,81.90,'2021-12-08 10:40:17','',''),(2204094,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.95,0.00,'2021-12-08 10:40:17','',''),(2204196,'1','144','828',360,'Retail Sale Id 1298803',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 10:50:02','',''),(2204197,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:50:02','',''),(2204206,'1','144','828',360,'Retail Sale Id 1298809',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 10:50:41','',''),(2204207,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:50:41','',''),(2204216,'1','144','828',360,'Retail Sale Id 1298814',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 10:51:30','',''),(2204217,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:51:30','',''),(2204222,'1','144','828',360,'Retail Sale Id 1298817',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 10:52:12','',''),(2204223,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:52:12','',''),(2204230,'1','144','828',360,'Retail Sale Id 1298820',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 10:52:58','',''),(2204231,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:52:58','',''),(2204238,'1','144','828',360,'Retail Sale Id 1298824',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 10:53:36','',''),(2204239,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:53:36','',''),(2204246,'1','144','828',360,'Retail Sale Id 1298828',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 10:54:13','',''),(2204247,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:54:13','',''),(2204258,'1','144','828',360,'Retail Sale Id 1298835',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 10:55:06','',''),(2204259,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:55:06','',''),(2204264,'1','144','828',360,'Retail Sale Id 1298839',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 10:55:47','',''),(2204265,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:55:47','',''),(2204284,'1','144','828',360,'Retail Sale Id 1298847',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 10:56:49','',''),(2204285,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:56:49','',''),(2204294,'1','144','828',360,'Retail Sale Id 1298852',1472.00,0.00,0.00,0.00,96.60,'2021-12-08 10:57:33','',''),(2204295,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.30,0.00,'2021-12-08 10:57:33','',''),(2204314,'1','144','828',360,'Retail Sale Id 1298862',7680.00,0.00,0.00,0.00,504.00,'2021-12-08 10:59:01','',''),(2204315,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-08 10:59:01','',''),(2204404,'1','144','828',360,'Retail Sale Id 1298907',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 11:06:50','',''),(2204405,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:06:50','',''),(2204428,'1','144','828',360,'Retail Sale Id 1298921',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 11:07:51','',''),(2204429,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:07:51','',''),(2204444,'1','144','828',360,'Retail Sale Id 1298930',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 11:08:29','',''),(2204445,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:08:29','',''),(2204458,'1','144','828',360,'Retail Sale Id 1298936',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 11:09:14','',''),(2204459,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:09:14','',''),(2204466,'1','144','828',360,'Retail Sale Id 1298941',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 11:10:00','',''),(2204467,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:10:00','',''),(2204486,'1','144','828',360,'Retail Sale Id 1298952',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 11:10:38','',''),(2204487,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:10:38','',''),(2204498,'1','144','828',360,'Retail Sale Id 1298959',972.80,0.00,0.00,0.00,63.84,'2021-12-08 11:11:22','',''),(2204499,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-08 11:11:22','',''),(2204534,'1','144','828',360,'Retail Sale Id 1298979',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 11:14:04','',''),(2204535,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:14:04','',''),(2204544,'1','144','828',360,'Retail Sale Id 1298984',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 11:14:52','',''),(2204545,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:14:52','',''),(2204552,'1','144','828',360,'Retail Sale Id 1298987',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 11:15:32','',''),(2204553,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:15:32','',''),(2204562,'1','144','828',360,'Retail Sale Id 1298993',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 11:16:23','',''),(2204563,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:16:23','',''),(2204570,'1','144','828',360,'Retail Sale Id 1298998',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 11:17:29','',''),(2204571,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:17:29','',''),(2204580,'1','144','828',360,'Retail Sale Id 1299003',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 11:18:08','',''),(2204581,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:18:08','',''),(2205086,'1','144','828',360,'Retail Sale Id 1299259',972.80,0.00,0.00,0.00,63.84,'2021-12-08 11:52:20','',''),(2205087,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-08 11:52:20','',''),(2205104,'1','144','828',360,'Retail Sale Id 1299267',1600.00,0.00,0.00,0.00,105.00,'2021-12-08 11:53:15','',''),(2205105,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-08 11:53:15','',''),(2205554,'1','144','828',360,'Retail Sale Id 1299475',36600.00,0.00,0.00,0.00,720.00,'2021-12-08 12:29:18','',''),(2205555,'1','144','828',360,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-08 12:29:18','',''),(2206369,'1','144','828',360,'Retail Sale Id 1299842',4480.00,0.00,0.00,0.00,294.00,'2021-12-08 13:22:53','',''),(2206370,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 13:22:53','',''),(2206415,'1','144','828',360,'Retail Sale Id 1299865',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 13:26:20','',''),(2206416,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:26:20','',''),(2206429,'1','144','828',360,'Retail Sale Id 1299871',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 13:27:03','',''),(2206430,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 13:27:03','',''),(2206447,'1','144','828',360,'Retail Sale Id 1299880',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 13:28:10','',''),(2206448,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:28:10','',''),(2206453,'1','144','828',360,'Retail Sale Id 1299883',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 13:28:49','',''),(2206454,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:28:49','',''),(2206463,'1','144','828',360,'Retail Sale Id 1299888',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 13:29:31','',''),(2206464,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:29:31','',''),(2206497,'1','144','828',360,'Retail Sale Id 1299900',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 13:30:14','',''),(2206498,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:30:14','',''),(2206718,'1','144','828',360,'Retail Sale Id 1299985',4480.00,0.00,0.00,0.00,294.00,'2021-12-08 13:42:52','',''),(2206719,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 13:42:52','',''),(2206755,'1','144','828',360,'Retail Sale Id 1299997',972.80,0.00,0.00,0.00,63.84,'2021-12-08 13:44:08','',''),(2206756,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-08 13:44:08','',''),(2206900,'1','144','828',360,'Retail Sale Id 1300053',2176.00,0.00,0.00,0.00,142.80,'2021-12-08 13:52:28','',''),(2206901,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.40,0.00,'2021-12-08 13:52:28','',''),(2207261,'1','144','828',360,'Retail Sale Id 1300212',152500.00,0.00,0.00,0.00,3000.00,'2021-12-08 14:16:12','',''),(2207262,'1','144','828',360,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-08 14:16:12','',''),(2207627,'1','144','828',360,'Retail Sale Id 1300378',972.80,0.00,0.00,0.00,63.84,'2021-12-08 14:33:07','',''),(2207628,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-08 14:33:07','',''),(2208045,'1','144','828',360,'Retail Sale Id 1300595',972.80,0.00,0.00,0.00,63.84,'2021-12-08 14:58:15','',''),(2208046,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-08 14:58:15','',''),(2208205,'1','144','828',360,'Retail Sale Id 1300660',972.80,0.00,0.00,0.00,63.84,'2021-12-08 15:09:06','',''),(2208206,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-08 15:09:06','',''),(2208371,'1','144','828',360,'Retail Sale Id 1300740',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 15:18:16','',''),(2208372,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:18:16','',''),(2208391,'1','144','828',360,'Retail Sale Id 1300751',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 15:19:05','',''),(2208392,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:19:05','',''),(2208458,'1','144','828',360,'Retail Sale Id 1300778',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 15:22:16','',''),(2208459,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:22:16','',''),(2208478,'1','144','828',360,'Retail Sale Id 1300790',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 15:23:28','',''),(2208479,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:23:28','',''),(2208526,'1','144','828',360,'Retail Sale Id 1300813',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 15:25:55','',''),(2208527,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:25:55','',''),(2208550,'1','144','828',360,'Retail Sale Id 1300826',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 15:26:59','',''),(2208551,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:26:59','',''),(2208689,'1','144','828',360,'Retail Sale Id 1300893',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 15:33:54','',''),(2208690,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:33:54','',''),(2208703,'1','144','828',360,'Retail Sale Id 1300909',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 15:34:56','',''),(2208704,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:34:56','',''),(2208785,'1','144','828',360,'Retail Sale Id 1300950',13760.00,0.00,0.00,0.00,903.00,'2021-12-08 15:38:51','',''),(2208786,'1','144','828',360,'Retail sales',0.00,0.00,0.00,21.50,0.00,'2021-12-08 15:38:51','',''),(2208931,'1','144','828',360,'Retail Sale Id 1301029',4160.00,0.00,0.00,0.00,273.00,'2021-12-08 15:46:42','',''),(2208933,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-08 15:46:42','',''),(2208983,'1','144','828',360,'Retail Sale Id 1301052',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 15:49:15','',''),(2208984,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 15:49:15','',''),(2209025,'1','144','828',360,'Retail Sale Id 1301070',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 15:52:40','',''),(2209026,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 15:52:40','',''),(2209093,'1','144','828',360,'Retail Sale Id 1301100',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 15:55:48','',''),(2209094,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 15:55:48','',''),(2209119,'1','144','828',360,'Retail Sale Id 1301113',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 15:57:24','',''),(2209120,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 15:57:24','',''),(2209171,'1','144','828',360,'Retail Sale Id 1301139',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 15:59:58','',''),(2209172,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:59:58','',''),(2209199,'1','144','828',360,'Retail Sale Id 1301152',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 16:01:06','',''),(2209200,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:01:06','',''),(2209221,'1','144','828',360,'Retail Sale Id 1301167',640.00,0.00,0.00,0.00,42.00,'2021-12-08 16:02:02','',''),(2209222,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 16:02:02','',''),(2209229,'1','144','828',360,'Retail Sale Id 1301171',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 16:02:45','',''),(2209230,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:02:45','',''),(2209293,'1','144','828',360,'Retail Sale Id 1301202',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 16:05:47','',''),(2209294,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:05:47','',''),(2209396,'1','144','828',360,'Retail Sale Id 1301244',8000.00,0.00,0.00,0.00,525.00,'2021-12-08 16:10:08','',''),(2209397,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:10:08','',''),(2209422,'1','144','828',360,'Retail Sale Id 1301258',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 16:11:04','',''),(2209423,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:11:04','',''),(2209456,'1','144','828',360,'Retail Sale Id 1301277',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 16:12:07','',''),(2209457,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:12:07','',''),(2209532,'1','144','828',360,'Retail Sale Id 1301311',5760.00,0.00,0.00,0.00,378.00,'2021-12-08 16:15:27','',''),(2209533,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-08 16:15:27','',''),(2209588,'1','144','828',360,'Retail Sale Id 1301330',640.00,0.00,0.00,0.00,42.00,'2021-12-08 16:16:48','',''),(2209589,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 16:16:48','',''),(2209696,'1','144','828',360,'Retail Sale Id 1301383',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 16:22:21','',''),(2209697,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:22:21','',''),(2209741,'1','144','828',360,'Retail Sale Id 1301411',8000.00,0.00,0.00,0.00,525.00,'2021-12-08 16:24:21','',''),(2209742,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:24:21','',''),(2209854,'1','144','828',360,'Retail Sale Id 1301581',8000.00,0.00,0.00,0.00,525.00,'2021-12-08 16:31:11','',''),(2209855,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:31:11','',''),(2209879,'1','144','828',360,'Retail Sale Id 1301590',5120.00,0.00,0.00,0.00,336.00,'2021-12-08 16:32:39','',''),(2209880,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-08 16:32:39','',''),(2209913,'1','144','828',360,'Retail Sale Id 1301606',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 16:34:03','',''),(2209914,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:34:03','',''),(2209929,'1','144','828',360,'Retail Sale Id 1301616',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 16:34:56','',''),(2209930,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:34:56','',''),(2209967,'1','144','828',360,'Retail Sale Id 1301633',5760.00,0.00,0.00,0.00,378.00,'2021-12-08 16:36:11','',''),(2209968,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-08 16:36:11','',''),(2209979,'1','144','828',360,'Retail Sale Id 1301640',8000.00,0.00,0.00,0.00,525.00,'2021-12-08 16:36:58','',''),(2209980,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:36:58','',''),(2210001,'1','144','828',360,'Retail Sale Id 1301652',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 16:38:08','',''),(2210002,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:38:08','',''),(2210029,'1','144','828',360,'Retail Sale Id 1301664',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 16:39:16','',''),(2210030,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:39:16','',''),(2210051,'1','144','828',360,'Retail Sale Id 1301675',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 16:40:01','',''),(2210052,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:40:01','',''),(2210079,'1','144','828',360,'Retail Sale Id 1301688',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 16:41:19','',''),(2210080,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:41:19','',''),(2210954,'1','144','828',360,'Retail Sale Id 1302132',8000.00,0.00,0.00,0.00,525.00,'2021-12-08 17:56:48','',''),(2210955,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 17:56:48','',''),(2210962,'1','144','828',360,'Retail Sale Id 1302137',3840.00,0.00,0.00,0.00,252.00,'2021-12-08 17:57:56','',''),(2210963,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 17:57:56','',''),(2210978,'1','144','828',360,'Retail Sale Id 1302142',3200.00,0.00,0.00,0.00,210.00,'2021-12-08 17:59:58','',''),(2210979,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 17:59:58','',''),(2210980,'1','144','828',360,'Retail Sale Id 1302144',1920.00,0.00,0.00,0.00,126.00,'2021-12-08 18:00:56','',''),(2210981,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 18:00:56','',''),(2210991,'1','144','828',360,'Retail Sale Id 1302145',1280.00,0.00,0.00,0.00,84.00,'2021-12-08 18:03:25','',''),(2210992,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 18:03:25','',''),(2211000,'1','144','828',360,'Retail Sale Id 1302147',2560.00,0.00,0.00,0.00,168.00,'2021-12-08 18:05:43','',''),(2211001,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 18:05:43','',''),(2211004,'1','144','828',360,'Retail Sale Id 1302149',6400.00,0.00,0.00,0.00,420.00,'2021-12-08 18:06:59','',''),(2211005,'1','144','828',360,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 18:06:59','',''),(2211023,'1','144','828',360,'Retail Sale Id 1302157',245420.80,0.00,0.00,0.00,16105.74,'2021-12-08 18:11:37','',''),(2211024,'1','144','828',360,'Retail sales',0.00,0.00,0.00,383.47,0.00,'2021-12-08 18:11:37','',''),(2211027,'1','144','828',360,'Retail Sale Id 1302160',274500.00,0.00,0.00,0.00,5400.00,'2021-12-08 18:12:31','',''),(2211028,'1','144','828',360,'Retail sales',0.00,0.00,0.00,450.00,0.00,'2021-12-08 18:12:31','',''),(2211861,'1','144','828',360,'Retail Sale Id 1302305',3840.00,0.00,0.00,0.00,252.00,'2021-12-09 05:56:27','',''),(2211862,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 05:56:27','',''),(2211877,'1','144','828',360,'Retail Sale Id 1302315',9920.00,0.00,0.00,0.00,651.00,'2021-12-09 05:58:17','',''),(2211878,'1','144','828',360,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-09 05:58:17','',''),(2211910,'1','144','828',360,'Retail Sale Id 1302331',1497.60,0.00,0.00,0.00,98.28,'2021-12-09 06:01:40','',''),(2211911,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 06:01:40','',''),(2211944,'1','144','828',360,'Retail Sale Id 1302345',8000.00,0.00,0.00,0.00,525.00,'2021-12-09 06:05:14','',''),(2211945,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 06:05:14','',''),(2211976,'1','144','828',360,'Retail Sale Id 1302361',5120.00,0.00,0.00,0.00,336.00,'2021-12-09 06:09:00','',''),(2211977,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-09 06:09:00','',''),(2212000,'1','144','828',360,'Retail Sale Id 1302374',3840.00,0.00,0.00,0.00,252.00,'2021-12-09 06:11:44','',''),(2212001,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 06:11:44','',''),(2212018,'1','144','828',360,'Retail Sale Id 1302384',4480.00,0.00,0.00,0.00,294.00,'2021-12-09 06:12:41','',''),(2212019,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-09 06:12:41','',''),(2213582,'1','144','828',360,'Retail Sale Id 1303066',61000.00,0.00,0.00,0.00,1200.00,'2021-12-09 07:35:14','',''),(2213583,'1','144','828',360,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-09 07:35:14','',''),(2213860,'1','144','828',360,'Retail Sale Id 1303224',1920.00,0.00,0.00,0.00,126.00,'2021-12-09 07:49:27','',''),(2213861,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 07:49:27','',''),(2224214,'1','144','828',360,'Retail Sale Id 1308181',8000.00,0.00,0.00,0.00,525.00,'2021-12-09 17:51:27','',''),(2224215,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 17:51:27','',''),(2224228,'1','144','828',360,'Retail Sale Id 1308186',3840.00,0.00,0.00,0.00,252.00,'2021-12-09 17:53:43','',''),(2224229,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 17:53:43','',''),(2224239,'1','144','828',360,'Retail Sale Id 1308192',1920.00,0.00,0.00,0.00,126.00,'2021-12-09 17:55:41','',''),(2224240,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 17:55:41','',''),(2224267,'1','144','828',360,'Retail Sale Id 1308197',3200.00,0.00,0.00,0.00,210.00,'2021-12-09 17:58:15','',''),(2224268,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 17:58:15','',''),(2224279,'1','144','828',360,'Retail Sale Id 1308204',1280.00,0.00,0.00,0.00,84.00,'2021-12-09 18:00:25','',''),(2224280,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 18:00:25','',''),(2224286,'1','144','828',360,'Retail Sale Id 1308206',2560.00,0.00,0.00,0.00,168.00,'2021-12-09 18:01:46','',''),(2224287,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 18:01:46','',''),(2224298,'1','144','828',360,'Retail Sale Id 1308212',6400.00,0.00,0.00,0.00,420.00,'2021-12-09 18:03:18','',''),(2224299,'1','144','828',360,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 18:03:18','',''),(2224325,'1','144','828',360,'Retail Sale Id 1308221',606630.40,0.00,0.00,0.00,39810.12,'2021-12-09 18:07:58','',''),(2224326,'1','144','828',360,'Retail sales',0.00,0.00,0.00,947.86,0.00,'2021-12-09 18:07:58','',''),(2224333,'1','144','828',360,'Retail Sale Id 1308227',457500.00,0.00,0.00,0.00,9000.00,'2021-12-09 18:09:21','',''),(2224334,'1','144','828',360,'Retail sales',0.00,0.00,0.00,750.00,0.00,'2021-12-09 18:09:21','',''),(2224339,'1','144','828',360,'Retail Sale Id 1308230',909000.00,0.00,0.00,0.00,12000.00,'2021-12-09 18:11:35','',''),(2224340,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1500.00,0.00,'2021-12-09 18:11:35','',''),(2225049,'1','144','828',360,'Retail Sale Id 1308344',3200.00,0.00,0.00,0.00,210.00,'2021-12-10 05:58:15','',''),(2225050,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 05:58:15','',''),(2225168,'1','144','828',360,'Retail Sale Id 1308392',7616.00,0.00,0.00,0.00,499.80,'2021-12-10 06:13:11','',''),(2225169,'1','144','828',360,'Retail sales',0.00,0.00,0.00,11.90,0.00,'2021-12-10 06:13:11','',''),(2225268,'1','144','828',360,'Retail Sale Id 1308431',1280.00,0.00,0.00,0.00,84.00,'2021-12-10 06:23:24','',''),(2225269,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 06:23:24','',''),(2225397,'1','144','828',360,'Retail Sale Id 1308499',7680.00,0.00,0.00,0.00,504.00,'2021-12-10 06:34:25','',''),(2225398,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-10 06:34:25','',''),(2225409,'1','144','828',360,'Retail Sale Id 1308506',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 06:35:35','',''),(2225410,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 06:35:35','',''),(2225446,'1','144','828',360,'Retail Sale Id 1308521',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 06:37:34','',''),(2225447,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 06:37:34','',''),(2225487,'1','144','828',360,'Retail Sale Id 1308533',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 06:40:12','',''),(2225488,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 06:40:12','',''),(2225499,'1','144','828',360,'Retail Sale Id 1308540',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 06:41:30','',''),(2225500,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 06:41:30','',''),(2225533,'1','144','828',360,'Retail Sale Id 1308555',2995.20,0.00,0.00,0.00,196.56,'2021-12-10 06:44:01','',''),(2225534,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.68,0.00,'2021-12-10 06:44:01','',''),(2225543,'1','144','828',360,'Retail Sale Id 1308563',1280.00,0.00,0.00,0.00,84.00,'2021-12-10 06:45:08','',''),(2225544,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 06:45:08','',''),(2225834,'1','144','828',360,'Retail Sale Id 1308711',4480.00,0.00,0.00,0.00,294.00,'2021-12-10 07:04:58','',''),(2225835,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-10 07:04:58','',''),(2225882,'1','144','828',360,'Retail Sale Id 1308736',972.80,0.00,0.00,0.00,63.84,'2021-12-10 07:08:19','',''),(2225883,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-10 07:08:19','',''),(2226769,'1','144','828',360,'Retail Sale Id 1309166',24400.00,0.00,0.00,0.00,480.00,'2021-12-10 07:56:25','',''),(2226770,'1','144','828',360,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-10 07:56:25','',''),(2227475,'1','144','828',360,'Retail Sale Id 1309437',972.80,0.00,0.00,0.00,63.84,'2021-12-10 08:28:23','',''),(2227476,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-10 08:28:23','',''),(2227501,'1','144','828',360,'Retail Sale Id 1309455',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 08:29:38','',''),(2227502,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:29:38','',''),(2227519,'1','144','828',360,'Retail Sale Id 1309471',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 08:30:29','',''),(2227520,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:30:29','',''),(2227557,'1','144','828',360,'Retail Sale Id 1309489',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 08:32:28','',''),(2227558,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:32:28','',''),(2227579,'1','144','828',360,'Retail Sale Id 1309499',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 08:33:26','',''),(2227580,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:33:26','',''),(2227613,'1','144','828',360,'Retail Sale Id 1309512',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 08:35:05','',''),(2227614,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:35:05','',''),(2227682,'1','144','828',360,'Retail Sale Id 1309546',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 08:39:29','',''),(2227683,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:39:29','',''),(2227696,'1','144','828',360,'Retail Sale Id 1309560',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 08:40:16','',''),(2227697,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:40:16','',''),(2227738,'1','144','828',360,'Retail Sale Id 1309576',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 08:42:51','',''),(2227739,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:42:51','',''),(2227764,'1','144','828',360,'Retail Sale Id 1309591',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 08:43:45','',''),(2227765,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:43:45','',''),(2227808,'1','144','828',360,'Retail Sale Id 1309606',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 08:45:32','',''),(2227809,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:45:32','',''),(2227868,'1','144','828',360,'Retail Sale Id 1309630',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 08:47:05','',''),(2227869,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:47:05','',''),(2227912,'1','144','828',360,'Retail Sale Id 1309650',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 08:48:38','',''),(2227913,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:48:38','',''),(2227932,'1','144','828',360,'Retail Sale Id 1309660',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 08:49:30','',''),(2227933,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:49:30','',''),(2227952,'1','144','828',360,'Retail Sale Id 1309670',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 08:50:34','',''),(2227953,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:50:34','',''),(2227972,'1','144','828',360,'Retail Sale Id 1309681',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 08:51:29','',''),(2227973,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:51:29','',''),(2227992,'1','144','828',360,'Retail Sale Id 1309691',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 08:52:30','',''),(2227993,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:52:30','',''),(2228059,'1','144','828',360,'Retail Sale Id 1309720',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 08:55:39','',''),(2228060,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:55:39','',''),(2229379,'1','144','828',360,'Retail Sale Id 1310345',5760.00,0.00,0.00,0.00,378.00,'2021-12-10 10:10:08','',''),(2229380,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-10 10:10:08','',''),(2229921,'1','144','828',360,'Retail Sale Id 1310600',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 10:39:36','',''),(2229922,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:39:36','',''),(2229965,'1','144','828',360,'Retail Sale Id 1310622',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 10:42:56','',''),(2229966,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:42:56','',''),(2230031,'1','144','828',360,'Retail Sale Id 1310651',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 10:46:06','',''),(2230032,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:46:06','',''),(2230053,'1','144','828',360,'Retail Sale Id 1310662',4480.00,0.00,0.00,0.00,294.00,'2021-12-10 10:47:53','',''),(2230054,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-10 10:47:53','',''),(2230095,'1','144','828',360,'Retail Sale Id 1310670',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 10:49:22','',''),(2230096,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:49:22','',''),(2230116,'1','144','828',360,'Retail Sale Id 1310686',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 10:50:21','',''),(2230117,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:50:21','',''),(2230149,'1','144','828',360,'Retail Sale Id 1310700',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 10:51:51','',''),(2230150,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:51:51','',''),(2230168,'1','144','828',360,'Retail Sale Id 1310705',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 10:52:53','',''),(2230169,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:52:53','',''),(2230200,'1','144','828',360,'Retail Sale Id 1310720',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 10:54:22','',''),(2230201,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:54:22','',''),(2230838,'1','144','828',360,'Retail Sale Id 1310999',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 11:33:16','',''),(2230839,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:33:16','',''),(2230885,'1','144','828',360,'Retail Sale Id 1311025',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 11:35:42','',''),(2230886,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:35:42','',''),(2230949,'1','144','828',360,'Retail Sale Id 1311057',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 11:39:56','',''),(2230950,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:39:56','',''),(2230955,'1','144','828',360,'Retail Sale Id 1311063',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 11:40:51','',''),(2230956,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:40:51','',''),(2230965,'1','144','828',360,'Retail Sale Id 1311065',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 11:42:08','',''),(2230966,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:42:08','',''),(2230975,'1','144','828',360,'Retail Sale Id 1311072',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 11:43:05','',''),(2230976,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:43:05','',''),(2231431,'1','144','828',360,'Retail Sale Id 1311307',30500.00,0.00,0.00,0.00,600.00,'2021-12-10 12:17:08','',''),(2231432,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 12:17:08','',''),(2231614,'1','144','828',360,'Retail Sale Id 1311404',87840.00,0.00,0.00,0.00,1728.00,'2021-12-10 12:34:46','',''),(2231615,'1','144','828',360,'Retail sales',0.00,0.00,0.00,144.00,0.00,'2021-12-10 12:34:46','',''),(2232244,'1','144','828',360,'Retail Sale Id 1311702',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 13:17:51','',''),(2232245,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 13:17:51','',''),(2232272,'1','144','828',360,'Retail Sale Id 1311714',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 13:19:09','',''),(2232273,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 13:19:09','',''),(2232308,'1','144','828',360,'Retail Sale Id 1311731',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 13:21:15','',''),(2232309,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 13:21:15','',''),(2232611,'1','144','828',360,'Retail Sale Id 1311884',11200.00,0.00,0.00,0.00,735.00,'2021-12-10 13:39:17','',''),(2232612,'1','144','828',360,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-10 13:39:17','',''),(2232711,'1','144','828',360,'Retail Sale Id 1311919',3200.00,0.00,0.00,0.00,210.00,'2021-12-10 13:43:51','',''),(2232712,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 13:43:51','',''),(2232749,'1','144','828',360,'Retail Sale Id 1311941',3200.00,0.00,0.00,0.00,210.00,'2021-12-10 13:45:19','',''),(2232750,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 13:45:19','',''),(2232775,'1','144','828',360,'Retail Sale Id 1311949',3200.00,0.00,0.00,0.00,210.00,'2021-12-10 13:46:50','',''),(2232776,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 13:46:50','',''),(2232817,'1','144','828',360,'Retail Sale Id 1311973',3200.00,0.00,0.00,0.00,210.00,'2021-12-10 13:48:15','',''),(2232818,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 13:48:15','',''),(2232841,'1','144','828',360,'Retail Sale Id 1311981',1280.00,0.00,0.00,0.00,84.00,'2021-12-10 13:49:55','',''),(2232842,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 13:49:55','',''),(2232867,'1','144','828',360,'Retail Sale Id 1311990',1280.00,0.00,0.00,0.00,84.00,'2021-12-10 13:51:00','',''),(2232868,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 13:51:00','',''),(2232905,'1','144','828',360,'Retail Sale Id 1312003',1280.00,0.00,0.00,0.00,84.00,'2021-12-10 13:53:15','',''),(2232906,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 13:53:15','',''),(2232941,'1','144','828',360,'Retail Sale Id 1312025',1280.00,0.00,0.00,0.00,84.00,'2021-12-10 13:54:41','',''),(2232942,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 13:54:41','',''),(2232965,'1','144','828',360,'Retail Sale Id 1312035',1280.00,0.00,0.00,0.00,84.00,'2021-12-10 13:56:08','',''),(2232966,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 13:56:08','',''),(2233025,'1','144','828',360,'Retail Sale Id 1312063',16000.00,0.00,0.00,0.00,1050.00,'2021-12-10 13:58:45','',''),(2233026,'1','144','828',360,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 13:58:45','',''),(2233152,'1','144','828',360,'Retail Sale Id 1312099',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 14:03:00','',''),(2233153,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:03:00','',''),(2233173,'1','144','828',360,'Retail Sale Id 1312106',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 14:03:44','',''),(2233174,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:03:44','',''),(2233207,'1','144','828',360,'Retail Sale Id 1312123',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 14:05:17','',''),(2233208,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:05:17','',''),(2233217,'1','144','828',360,'Retail Sale Id 1312128',61000.00,0.00,0.00,0.00,1200.00,'2021-12-10 14:06:08','',''),(2233218,'1','144','828',360,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 14:06:08','',''),(2233701,'1','144','828',360,'Retail Sale Id 1312334',3200.00,0.00,0.00,0.00,210.00,'2021-12-10 14:29:58','',''),(2233702,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 14:29:58','',''),(2233731,'1','144','828',360,'Retail Sale Id 1312353',3200.00,0.00,0.00,0.00,210.00,'2021-12-10 14:31:32','',''),(2233732,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 14:31:32','',''),(2234051,'1','144','828',360,'Retail Sale Id 1312495',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 14:44:36','',''),(2234052,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:44:36','',''),(2234069,'1','144','828',360,'Retail Sale Id 1312506',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 14:45:31','',''),(2234070,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:45:31','',''),(2234117,'1','144','828',360,'Retail Sale Id 1312516',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 14:46:27','',''),(2234118,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:46:27','',''),(2234217,'1','144','828',360,'Retail Sale Id 1312534',11200.00,0.00,0.00,0.00,735.00,'2021-12-10 14:50:42','',''),(2234218,'1','144','828',360,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-10 14:50:42','',''),(2234270,'1','144','828',360,'Retail Sale Id 1312591',1280.00,0.00,0.00,0.00,84.00,'2021-12-10 14:53:26','',''),(2234271,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 14:53:26','',''),(2234282,'1','144','828',360,'Retail Sale Id 1312598',1280.00,0.00,0.00,0.00,84.00,'2021-12-10 14:54:14','',''),(2234283,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 14:54:14','',''),(2234548,'1','144','828',360,'Retail Sale Id 1312730',972.80,0.00,0.00,0.00,63.84,'2021-12-10 15:09:22','',''),(2234549,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-10 15:09:22','',''),(2234767,'1','144','828',360,'Retail Sale Id 1312828',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 15:18:34','',''),(2234768,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:18:34','',''),(2234866,'1','144','828',360,'Retail Sale Id 1312875',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 15:22:10','',''),(2234867,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:22:10','',''),(2234930,'1','144','828',360,'Retail Sale Id 1312927',1280.00,0.00,0.00,0.00,84.00,'2021-12-10 15:24:30','',''),(2234931,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 15:24:30','',''),(2234964,'1','144','828',360,'Retail Sale Id 1312944',1280.00,0.00,0.00,0.00,84.00,'2021-12-10 15:25:32','',''),(2234965,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 15:25:32','',''),(2234994,'1','144','828',360,'Retail Sale Id 1312959',1280.00,0.00,0.00,0.00,84.00,'2021-12-10 15:27:02','',''),(2234995,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 15:27:02','',''),(2235471,'1','144','828',360,'Retail Sale Id 1313175',3200.00,0.00,0.00,0.00,210.00,'2021-12-10 15:45:54','',''),(2235472,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 15:45:54','',''),(2235597,'1','144','828',360,'Retail Sale Id 1313254',1280.00,0.00,0.00,0.00,84.00,'2021-12-10 15:52:52','',''),(2235598,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 15:52:52','',''),(2235636,'1','144','828',360,'Retail Sale Id 1313277',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 15:54:45','',''),(2235637,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:54:45','',''),(2235668,'1','144','828',360,'Retail Sale Id 1313285',3200.00,0.00,0.00,0.00,210.00,'2021-12-10 15:55:54','',''),(2235669,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 15:55:54','',''),(2235698,'1','144','828',360,'Retail Sale Id 1313297',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 15:57:11','',''),(2235699,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:57:11','',''),(2235716,'1','144','828',360,'Retail Sale Id 1313312',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 15:58:14','',''),(2235717,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:58:14','',''),(2235896,'1','144','828',360,'Retail Sale Id 1313394',3200.00,0.00,0.00,0.00,210.00,'2021-12-10 16:06:02','',''),(2235897,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 16:06:02','',''),(2235916,'1','144','828',360,'Retail Sale Id 1313400',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 16:06:56','',''),(2235917,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 16:06:56','',''),(2236035,'1','144','828',360,'Retail Sale Id 1313456',91500.00,0.00,0.00,0.00,1800.00,'2021-12-10 16:12:21','',''),(2236036,'1','144','828',360,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-10 16:12:21','',''),(2236116,'1','144','828',360,'Retail Sale Id 1313503',1280.00,0.00,0.00,0.00,84.00,'2021-12-10 16:16:08','',''),(2236117,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 16:16:08','',''),(2236184,'1','144','828',360,'Retail Sale Id 1313543',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 16:19:40','',''),(2236185,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 16:19:40','',''),(2236546,'1','144','828',360,'Retail Sale Id 1313723',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 16:35:47','',''),(2236547,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:35:47','',''),(2236575,'1','144','828',360,'Retail Sale Id 1313735',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 16:37:12','',''),(2236576,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:37:12','',''),(2236645,'1','144','828',360,'Retail Sale Id 1313759',1280.00,0.00,0.00,0.00,84.00,'2021-12-10 16:40:07','',''),(2236646,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 16:40:07','',''),(2236674,'1','144','828',360,'Retail Sale Id 1313773',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 16:41:44','',''),(2236675,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 16:41:44','',''),(2237424,'1','144','828',360,'Retail Sale Id 1314121',8000.00,0.00,0.00,0.00,525.00,'2021-12-10 17:36:39','',''),(2237425,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 17:36:39','',''),(2237436,'1','144','828',360,'Retail Sale Id 1314126',3840.00,0.00,0.00,0.00,252.00,'2021-12-10 17:37:34','',''),(2237437,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 17:37:34','',''),(2237445,'1','144','828',360,'Retail Sale Id 1314130',3200.00,0.00,0.00,0.00,210.00,'2021-12-10 17:38:39','',''),(2237446,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 17:38:39','',''),(2237465,'1','144','828',360,'Retail Sale Id 1314136',1920.00,0.00,0.00,0.00,126.00,'2021-12-10 17:39:45','',''),(2237466,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 17:39:45','',''),(2237496,'1','144','828',360,'Retail Sale Id 1314151',1280.00,0.00,0.00,0.00,84.00,'2021-12-10 17:42:40','',''),(2237497,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 17:42:40','',''),(2237506,'1','144','828',360,'Retail Sale Id 1314161',200614.40,0.00,0.00,0.00,13165.32,'2021-12-10 17:44:46','',''),(2237507,'1','144','828',360,'Retail sales',0.00,0.00,0.00,313.46,0.00,'2021-12-10 17:44:46','',''),(2237520,'1','144','828',360,'Retail Sale Id 1314174',396500.00,0.00,0.00,0.00,7800.00,'2021-12-10 17:46:42','',''),(2237521,'1','144','828',360,'Retail sales',0.00,0.00,0.00,650.00,0.00,'2021-12-10 17:46:42','',''),(2238424,'1','144','828',360,'Retail Sale Id 1314434',1280.00,0.00,0.00,0.00,84.00,'2021-12-11 06:02:13','',''),(2238425,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 06:02:13','',''),(2238457,'1','144','828',360,'Retail Sale Id 1314444',85400.00,0.00,0.00,0.00,1680.00,'2021-12-11 06:06:39','',''),(2238458,'1','144','828',360,'Retail sales',0.00,0.00,0.00,140.00,0.00,'2021-12-11 06:06:39','',''),(2238508,'1','144','828',360,'Retail Sale Id 1314451',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 06:09:16','',''),(2238509,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 06:09:16','',''),(2238536,'1','144','828',360,'Retail Sale Id 1314457',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 06:10:26','',''),(2238537,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 06:10:26','',''),(2238614,'1','144','828',360,'Retail Sale Id 1314492',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 06:19:09','',''),(2238615,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 06:19:09','',''),(2238682,'1','144','828',360,'Retail Sale Id 1314527',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 06:24:47','',''),(2238683,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 06:24:47','',''),(2238709,'1','144','828',360,'Retail Sale Id 1314541',1280.00,0.00,0.00,0.00,84.00,'2021-12-11 06:26:16','',''),(2238710,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 06:26:16','',''),(2238721,'1','144','828',360,'Retail Sale Id 1314547',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 06:27:24','',''),(2238722,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 06:27:24','',''),(2238774,'1','144','828',360,'Retail Sale Id 1314574',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 06:31:41','',''),(2238775,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 06:31:41','',''),(2238870,'1','144','828',360,'Retail Sale Id 1314606',1280.00,0.00,0.00,0.00,84.00,'2021-12-11 06:36:47','',''),(2238871,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 06:36:47','',''),(2238934,'1','144','828',360,'Retail Sale Id 1314641',30500.00,0.00,0.00,0.00,600.00,'2021-12-11 06:41:18','',''),(2238935,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 06:41:18','',''),(2238986,'1','144','828',360,'Retail Sale Id 1314668',998.40,0.00,0.00,0.00,65.52,'2021-12-11 06:45:52','',''),(2238987,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-11 06:45:52','',''),(2238994,'1','144','828',360,'Retail Sale Id 1314672',3200.00,0.00,0.00,0.00,210.00,'2021-12-11 06:46:33','',''),(2238995,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 06:46:33','',''),(2239058,'1','144','828',360,'Retail Sale Id 1314710',998.40,0.00,0.00,0.00,65.52,'2021-12-11 06:51:16','',''),(2239059,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-11 06:51:16','',''),(2239074,'1','144','828',360,'Retail Sale Id 1314716',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 06:52:14','',''),(2239075,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 06:52:14','',''),(2239114,'1','144','828',360,'Retail Sale Id 1314733',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 06:54:18','',''),(2239115,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 06:54:18','',''),(2239130,'1','144','828',360,'Retail Sale Id 1314744',1280.00,0.00,0.00,0.00,84.00,'2021-12-11 06:55:14','',''),(2239131,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 06:55:14','',''),(2239144,'1','144','828',360,'Retail Sale Id 1314750',1280.00,0.00,0.00,0.00,84.00,'2021-12-11 06:56:05','',''),(2239145,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 06:56:05','',''),(2239192,'1','144','828',360,'Retail Sale Id 1314768',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 06:58:36','',''),(2239193,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 06:58:36','',''),(2239242,'1','144','828',360,'Retail Sale Id 1314806',8000.00,0.00,0.00,0.00,525.00,'2021-12-11 07:01:54','',''),(2239243,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:01:54','',''),(2239334,'1','144','828',360,'Retail Sale Id 1314851',5120.00,0.00,0.00,0.00,336.00,'2021-12-11 07:07:07','',''),(2239335,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-11 07:07:07','',''),(2239348,'1','144','828',360,'Retail Sale Id 1314859',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 07:07:44','',''),(2239349,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 07:07:44','',''),(2239402,'1','144','828',360,'Retail Sale Id 1314884',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 07:11:03','',''),(2239403,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 07:11:03','',''),(2239422,'1','144','828',360,'Retail Sale Id 1314895',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 07:12:36','',''),(2239423,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 07:12:36','',''),(2239448,'1','144','828',360,'Retail Sale Id 1314911',1996.80,0.00,0.00,0.00,131.04,'2021-12-11 07:14:25','',''),(2239449,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.12,0.00,'2021-12-11 07:14:25','',''),(2239507,'1','144','828',360,'Retail Sale Id 1314943',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 07:18:04','',''),(2239508,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 07:18:04','',''),(2239561,'1','144','828',360,'Retail Sale Id 1314975',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 07:21:31','',''),(2239562,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 07:21:31','',''),(2239632,'1','144','828',360,'Retail Sale Id 1315024',3200.00,0.00,0.00,0.00,210.00,'2021-12-11 07:25:12','',''),(2239633,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 07:25:12','',''),(2239646,'1','144','828',360,'Retail Sale Id 1315032',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 07:26:04','',''),(2239647,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 07:26:04','',''),(2239686,'1','144','828',360,'Retail Sale Id 1315051',14720.00,0.00,0.00,0.00,966.00,'2021-12-11 07:27:28','',''),(2239687,'1','144','828',360,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-11 07:27:28','',''),(2239728,'1','144','828',360,'Retail Sale Id 1315076',8000.00,0.00,0.00,0.00,525.00,'2021-12-11 07:31:05','',''),(2239729,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:31:05','',''),(2239776,'1','144','828',360,'Retail Sale Id 1315092',1996.80,0.00,0.00,0.00,131.04,'2021-12-11 07:32:31','',''),(2239777,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.12,0.00,'2021-12-11 07:32:31','',''),(2239805,'1','144','828',360,'Retail Sale Id 1315106',30500.00,0.00,0.00,0.00,600.00,'2021-12-11 07:33:50','',''),(2239806,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 07:33:50','',''),(2239907,'1','144','828',360,'Retail Sale Id 1315170',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 07:39:11','',''),(2239908,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 07:39:11','',''),(2239961,'1','144','828',360,'Retail Sale Id 1315194',998.40,0.00,0.00,0.00,65.52,'2021-12-11 07:42:07','',''),(2239962,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-11 07:42:07','',''),(2240178,'1','144','828',360,'Retail Sale Id 1315289',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 07:50:17','',''),(2240179,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 07:50:17','',''),(2240238,'1','144','828',360,'Retail Sale Id 1315322',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 07:53:38','',''),(2240239,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 07:53:38','',''),(2240416,'1','144','828',360,'Retail Sale Id 1315407',1600.00,0.00,0.00,0.00,105.00,'2021-12-11 08:00:50','',''),(2240417,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-11 08:00:50','',''),(2240842,'1','144','828',360,'Retail Sale Id 1315591',2496.00,0.00,0.00,0.00,163.80,'2021-12-11 08:20:06','',''),(2240843,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.90,0.00,'2021-12-11 08:20:06','',''),(2240997,'1','144','828',360,'Retail Sale Id 1315674',1996.80,0.00,0.00,0.00,131.04,'2021-12-11 08:29:01','',''),(2240998,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.12,0.00,'2021-12-11 08:29:01','',''),(2241421,'1','144','828',360,'Retail Sale Id 1315858',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 08:48:23','',''),(2241422,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 08:48:23','',''),(2241449,'1','144','828',360,'Retail Sale Id 1315870',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 08:49:56','',''),(2241450,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 08:49:56','',''),(2241471,'1','144','828',360,'Retail Sale Id 1315883',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 08:50:55','',''),(2241472,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 08:50:55','',''),(2241618,'1','144','828',360,'Retail Sale Id 1315940',1996.80,0.00,0.00,0.00,131.04,'2021-12-11 08:57:16','',''),(2241619,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.12,0.00,'2021-12-11 08:57:16','',''),(2241644,'1','144','828',360,'Retail Sale Id 1315954',4480.00,0.00,0.00,0.00,294.00,'2021-12-11 08:58:25','',''),(2241645,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-11 08:58:25','',''),(2241796,'1','144','828',360,'Retail Sale Id 1316033',4480.00,0.00,0.00,0.00,294.00,'2021-12-11 09:04:50','',''),(2241797,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-11 09:04:50','',''),(2241947,'1','144','828',360,'Retail Sale Id 1316104',998.40,0.00,0.00,0.00,65.52,'2021-12-11 09:11:35','',''),(2241948,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-11 09:11:35','',''),(2242269,'1','144','828',360,'Retail Sale Id 1316254',61000.00,0.00,0.00,0.00,1200.00,'2021-12-11 09:26:33','',''),(2242270,'1','144','828',360,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-11 09:26:33','',''),(2242546,'1','144','828',360,'Retail Sale Id 1316402',7680.00,0.00,0.00,0.00,504.00,'2021-12-11 09:40:13','',''),(2242547,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-11 09:40:13','',''),(2242706,'1','144','828',360,'Retail Sale Id 1316479',1600.00,0.00,0.00,0.00,105.00,'2021-12-11 09:47:15','',''),(2242707,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-11 09:47:15','',''),(2242768,'1','144','828',360,'Retail Sale Id 1316508',4480.00,0.00,0.00,0.00,294.00,'2021-12-11 09:50:09','',''),(2242769,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-11 09:50:09','',''),(2242812,'1','144','828',360,'Retail Sale Id 1316533',640.00,0.00,0.00,0.00,42.00,'2021-12-11 09:52:14','',''),(2242813,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-11 09:52:14','',''),(2242937,'1','144','828',360,'Retail Sale Id 1316581',7680.00,0.00,0.00,0.00,504.00,'2021-12-11 09:59:21','',''),(2242938,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-11 09:59:21','',''),(2243305,'1','144','828',360,'Retail Sale Id 1316742',5120.00,0.00,0.00,0.00,336.00,'2021-12-11 10:15:50','',''),(2243306,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-11 10:15:50','',''),(2243758,'1','144','828',360,'Retail Sale Id 1316956',10240.00,0.00,0.00,0.00,672.00,'2021-12-11 10:39:31','',''),(2243759,'1','144','828',360,'Retail sales',0.00,0.00,0.00,16.00,0.00,'2021-12-11 10:39:31','',''),(2243874,'1','144','828',360,'Retail Sale Id 1317015',1497.60,0.00,0.00,0.00,98.28,'2021-12-11 10:45:31','',''),(2243875,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-11 10:45:31','',''),(2244365,'1','144','828',360,'Retail Sale Id 1317246',1497.60,0.00,0.00,0.00,98.28,'2021-12-11 11:10:27','',''),(2244366,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-11 11:10:27','',''),(2244377,'1','144','828',360,'Retail Sale Id 1317254',6720.00,0.00,0.00,0.00,441.00,'2021-12-11 11:11:14','',''),(2244378,'1','144','828',360,'Retail sales',0.00,0.00,0.00,10.50,0.00,'2021-12-11 11:11:14','',''),(2244415,'1','144','828',360,'Retail Sale Id 1317269',1497.60,0.00,0.00,0.00,98.28,'2021-12-11 11:13:25','',''),(2244416,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-11 11:13:25','',''),(2244595,'1','144','828',360,'Retail Sale Id 1317360',30500.00,0.00,0.00,0.00,600.00,'2021-12-11 11:22:29','',''),(2244596,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 11:22:29','',''),(2245288,'1','144','828',360,'Retail Sale Id 1317716',1497.60,0.00,0.00,0.00,98.28,'2021-12-11 12:02:43','',''),(2245289,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-11 12:02:43','',''),(2245349,'1','144','828',360,'Retail Sale Id 1317758',5120.00,0.00,0.00,0.00,336.00,'2021-12-11 12:08:28','',''),(2245350,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-11 12:08:28','',''),(2245419,'1','144','828',360,'Retail Sale Id 1317825',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 12:12:31','',''),(2245420,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 12:12:31','',''),(2245429,'1','144','828',360,'Retail Sale Id 1317832',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 12:13:10','',''),(2245430,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 12:13:10','',''),(2245443,'1','144','828',360,'Retail Sale Id 1317842',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 12:13:56','',''),(2245444,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 12:13:56','',''),(2245457,'1','144','828',360,'Retail Sale Id 1317852',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 12:14:49','',''),(2245458,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 12:14:49','',''),(2245465,'1','144','828',360,'Retail Sale Id 1317859',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 12:15:31','',''),(2245466,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 12:15:31','',''),(2245483,'1','144','828',360,'Retail Sale Id 1317864',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 12:16:17','',''),(2245484,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 12:16:17','',''),(2245495,'1','144','828',360,'Retail Sale Id 1317872',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 12:16:57','',''),(2245496,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 12:16:57','',''),(2245554,'1','144','828',360,'Retail Sale Id 1317905',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 12:19:46','',''),(2245555,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 12:19:46','',''),(2245589,'1','144','828',360,'Retail Sale Id 1317917',61000.00,0.00,0.00,0.00,1200.00,'2021-12-11 12:21:43','',''),(2245590,'1','144','828',360,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-11 12:21:43','',''),(2245782,'1','144','828',360,'Retail Sale Id 1318003',1996.80,0.00,0.00,0.00,131.04,'2021-12-11 12:32:53','',''),(2245783,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.12,0.00,'2021-12-11 12:32:53','',''),(2245866,'1','144','828',360,'Retail Sale Id 1318053',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 12:38:31','',''),(2245867,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 12:38:31','',''),(2245886,'1','144','828',360,'Retail Sale Id 1318063',2944.00,0.00,0.00,0.00,193.20,'2021-12-11 12:39:26','',''),(2245887,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.60,0.00,'2021-12-11 12:39:26','',''),(2246114,'1','144','828',360,'Retail Sale Id 1318174',998.40,0.00,0.00,0.00,65.52,'2021-12-11 12:55:18','',''),(2246115,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-11 12:55:18','',''),(2246190,'1','144','828',360,'Retail Sale Id 1318220',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 13:01:02','',''),(2246191,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 13:01:02','',''),(2246401,'1','144','828',360,'Retail Sale Id 1318329',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 13:18:24','',''),(2246402,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 13:18:24','',''),(2246417,'1','144','828',360,'Retail Sale Id 1318335',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 13:19:43','',''),(2246418,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 13:19:43','',''),(2246535,'1','144','828',360,'Retail Sale Id 1318384',8896.00,0.00,0.00,0.00,583.80,'2021-12-11 13:25:27','',''),(2246536,'1','144','828',360,'Retail sales',0.00,0.00,0.00,13.90,0.00,'2021-12-11 13:25:27','',''),(2246682,'1','144','828',360,'Retail Sale Id 1318439',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 13:34:01','',''),(2246683,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 13:34:01','',''),(2246711,'1','144','828',360,'Retail Sale Id 1318450',7680.00,0.00,0.00,0.00,504.00,'2021-12-11 13:35:21','',''),(2246712,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-11 13:35:21','',''),(2246727,'1','144','828',360,'Retail Sale Id 1318458',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 13:36:50','',''),(2246728,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 13:36:50','',''),(2246749,'1','144','828',360,'Retail Sale Id 1318464',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 13:37:27','',''),(2246750,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 13:37:27','',''),(2246761,'1','144','828',360,'Retail Sale Id 1318472',2995.20,0.00,0.00,0.00,196.56,'2021-12-11 13:38:51','',''),(2246762,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.68,0.00,'2021-12-11 13:38:51','',''),(2246771,'1','144','828',360,'Retail Sale Id 1318477',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 13:39:34','',''),(2246772,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 13:39:34','',''),(2246804,'1','144','828',360,'Retail Sale Id 1318491',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 13:42:51','',''),(2246805,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 13:42:51','',''),(2246824,'1','144','828',360,'Retail Sale Id 1318502',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 13:44:09','',''),(2246825,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 13:44:09','',''),(2246865,'1','144','828',360,'Retail Sale Id 1318523',16000.00,0.00,0.00,0.00,1050.00,'2021-12-11 13:48:14','',''),(2246866,'1','144','828',360,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-11 13:48:14','',''),(2247008,'1','144','828',360,'Retail Sale Id 1318593',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 13:56:38','',''),(2247009,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 13:56:38','',''),(2247081,'1','144','828',360,'Retail Sale Id 1318625',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 14:00:42','',''),(2247082,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 14:00:42','',''),(2247133,'1','144','828',360,'Retail Sale Id 1318660',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 14:04:47','',''),(2247134,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 14:04:47','',''),(2247162,'1','144','828',360,'Retail Sale Id 1318674',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 14:06:52','',''),(2247163,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:06:52','',''),(2247180,'1','144','828',360,'Retail Sale Id 1318683',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 14:08:03','',''),(2247181,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:08:03','',''),(2247212,'1','144','828',360,'Retail Sale Id 1318694',5120.00,0.00,0.00,0.00,336.00,'2021-12-11 14:09:29','',''),(2247213,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-11 14:09:29','',''),(2247248,'1','144','828',360,'Retail Sale Id 1318706',10240.00,0.00,0.00,0.00,672.00,'2021-12-11 14:10:48','',''),(2247249,'1','144','828',360,'Retail sales',0.00,0.00,0.00,16.00,0.00,'2021-12-11 14:10:48','',''),(2247276,'1','144','828',360,'Retail Sale Id 1318726',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 14:12:12','',''),(2247277,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:12:12','',''),(2247333,'1','144','828',360,'Retail Sale Id 1318752',5760.00,0.00,0.00,0.00,378.00,'2021-12-11 14:15:41','',''),(2247334,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-11 14:15:41','',''),(2247349,'1','144','828',360,'Retail Sale Id 1318763',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 14:16:33','',''),(2247350,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:16:33','',''),(2247382,'1','144','828',360,'Retail Sale Id 1318778',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 14:18:30','',''),(2247383,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:18:30','',''),(2247716,'1','144','828',360,'Retail Sale Id 1318952',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 14:41:29','',''),(2247717,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:41:29','',''),(2247728,'1','144','828',360,'Retail Sale Id 1318966',1280.00,0.00,0.00,0.00,84.00,'2021-12-11 14:42:27','',''),(2247729,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 14:42:27','',''),(2247770,'1','144','828',360,'Retail Sale Id 1318986',1280.00,0.00,0.00,0.00,84.00,'2021-12-11 14:44:58','',''),(2247771,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 14:44:58','',''),(2247984,'1','144','828',360,'Retail Sale Id 1319099',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 14:57:00','',''),(2247985,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:57:00','',''),(2248025,'1','144','828',360,'Retail Sale Id 1319116',2560.00,0.00,0.00,0.00,168.00,'2021-12-11 14:59:07','',''),(2248026,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 14:59:07','',''),(2248126,'1','144','828',360,'Retail Sale Id 1319170',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 15:06:20','',''),(2248127,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 15:06:20','',''),(2248267,'1','144','828',360,'Retail Sale Id 1319205',29440.00,0.00,0.00,0.00,1932.00,'2021-12-11 15:10:33','',''),(2248268,'1','144','828',360,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-11 15:10:33','',''),(2248388,'1','144','828',360,'Retail Sale Id 1319263',3200.00,0.00,0.00,0.00,210.00,'2021-12-11 15:16:21','',''),(2248389,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 15:16:21','',''),(2248514,'1','144','828',360,'Retail Sale Id 1319333',122610.00,0.00,0.00,0.00,2412.00,'2021-12-11 15:23:29','',''),(2248515,'1','144','828',360,'Retail sales',0.00,0.00,0.00,201.00,0.00,'2021-12-11 15:23:29','',''),(2248542,'1','144','828',360,'Retail Sale Id 1319349',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 15:24:51','',''),(2248543,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 15:24:51','',''),(2248612,'1','144','828',360,'Retail Sale Id 1319387',8000.00,0.00,0.00,0.00,525.00,'2021-12-11 15:28:41','',''),(2248613,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 15:28:41','',''),(2248638,'1','144','828',360,'Retail Sale Id 1319403',8000.00,0.00,0.00,0.00,525.00,'2021-12-11 15:30:17','',''),(2248639,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 15:30:17','',''),(2248656,'1','144','828',360,'Retail Sale Id 1319415',3200.00,0.00,0.00,0.00,210.00,'2021-12-11 15:31:28','',''),(2248657,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 15:31:28','',''),(2248690,'1','144','828',360,'Retail Sale Id 1319427',8000.00,0.00,0.00,0.00,525.00,'2021-12-11 15:32:54','',''),(2248691,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 15:32:54','',''),(2248720,'1','144','828',360,'Retail Sale Id 1319448',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 15:34:38','',''),(2248721,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 15:34:38','',''),(2248772,'1','144','828',360,'Retail Sale Id 1319473',6400.00,0.00,0.00,0.00,420.00,'2021-12-11 15:36:53','',''),(2248773,'1','144','828',360,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 15:36:53','',''),(2248808,'1','144','828',360,'Retail Sale Id 1319495',4480.00,0.00,0.00,0.00,294.00,'2021-12-11 15:39:12','',''),(2248809,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-11 15:39:12','',''),(2248888,'1','144','828',360,'Retail Sale Id 1319538',6400.00,0.00,0.00,0.00,420.00,'2021-12-11 15:44:07','',''),(2248889,'1','144','828',360,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 15:44:07','',''),(2248930,'1','144','828',360,'Retail Sale Id 1319563',1497.60,0.00,0.00,0.00,98.28,'2021-12-11 15:46:50','',''),(2248931,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-11 15:46:50','',''),(2248995,'1','144','828',360,'Retail Sale Id 1319583',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 15:48:24','',''),(2248996,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 15:48:24','',''),(2249035,'1','144','828',360,'Retail Sale Id 1319608',1280000.00,0.00,0.00,0.00,84000.00,'2021-12-11 15:50:28','',''),(2249036,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2000.00,0.00,'2021-12-11 15:50:28','',''),(2249197,'1','144','828',360,'Return of Retail Sale Id 1319608',0.00,1280000.00,2000.00,0.00,-84000.00,'2021-12-11 15:55:56','',''),(2249289,'1','144','828',360,'Retail Sale Id 1319705',7680.00,0.00,0.00,0.00,504.00,'2021-12-11 15:59:25','',''),(2249290,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-11 15:59:25','',''),(2249317,'1','144','828',360,'Retail Sale Id 1319717',2560.00,0.00,0.00,0.00,168.00,'2021-12-11 16:00:41','',''),(2249318,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 16:00:41','',''),(2249361,'1','144','828',360,'Retail Sale Id 1319739',1280.00,0.00,0.00,0.00,84.00,'2021-12-11 16:02:18','',''),(2249362,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 16:02:18','',''),(2249411,'1','144','828',360,'Retail Sale Id 1319763',1196.80,0.00,0.00,0.00,78.54,'2021-12-11 16:04:16','',''),(2249412,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.87,0.00,'2021-12-11 16:04:16','',''),(2249441,'1','144','828',360,'Retail Sale Id 1319778',1280.00,0.00,0.00,0.00,84.00,'2021-12-11 16:05:51','',''),(2249442,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 16:05:51','',''),(2249460,'1','144','828',360,'Retail Sale Id 1319789',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 16:07:05','',''),(2249461,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:07:05','',''),(2249508,'1','144','828',360,'Retail Sale Id 1319806',8000.00,0.00,0.00,0.00,525.00,'2021-12-11 16:08:38','',''),(2249509,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:08:38','',''),(2249594,'1','144','828',360,'Retail Sale Id 1319895',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 16:13:42','',''),(2249595,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:13:42','',''),(2249629,'1','144','828',360,'Retail Sale Id 1319919',8000.00,0.00,0.00,0.00,525.00,'2021-12-11 16:15:12','',''),(2249630,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:15:12','',''),(2249660,'1','144','828',360,'Return of Retail Sale Id 1319333',0.00,122610.00,201.00,0.00,-2412.00,'2021-12-11 16:17:25','',''),(2249707,'1','144','828',360,'Retail Sale Id 1319959',8640.00,0.00,0.00,0.00,567.00,'2021-12-11 16:20:22','',''),(2249708,'1','144','828',360,'Retail sales',0.00,0.00,0.00,13.50,0.00,'2021-12-11 16:20:22','',''),(2249772,'1','144','828',360,'Retail Sale Id 1319987',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 16:23:36','',''),(2249773,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:23:36','',''),(2249808,'1','144','828',360,'Retail Sale Id 1320003',39104.00,0.00,0.00,0.00,2566.20,'2021-12-11 16:25:50','',''),(2249809,'1','144','828',360,'Retail sales',0.00,0.00,0.00,61.10,0.00,'2021-12-11 16:25:50','',''),(2249827,'1','144','828',360,'Retail Sale Id 1320016',8000.00,0.00,0.00,0.00,525.00,'2021-12-11 16:27:28','',''),(2249828,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:27:28','',''),(2249852,'1','144','828',360,'Retail Sale Id 1320027',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 16:28:49','',''),(2249853,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:28:49','',''),(2249882,'1','144','828',360,'Retail Sale Id 1320037',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 16:30:10','',''),(2249883,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:30:10','',''),(2249929,'1','144','828',360,'Retail Sale Id 1320057',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 16:32:59','',''),(2249930,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:32:59','',''),(2250018,'1','144','828',360,'Retail Sale Id 1320093',128100.00,0.00,0.00,0.00,2520.00,'2021-12-11 16:36:14','',''),(2250019,'1','144','828',360,'Retail sales',0.00,0.00,0.00,210.00,0.00,'2021-12-11 16:36:14','',''),(2250075,'1','144','828',360,'Retail Sale Id 1320107',12160.00,0.00,0.00,0.00,798.00,'2021-12-11 16:37:52','',''),(2250076,'1','144','828',360,'Retail sales',0.00,0.00,0.00,19.00,0.00,'2021-12-11 16:37:52','',''),(2250111,'1','144','828',360,'Retail Sale Id 1320123',30500.00,0.00,0.00,0.00,600.00,'2021-12-11 16:40:33','',''),(2250112,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 16:40:33','',''),(2250152,'1','144','828',360,'Retail Sale Id 1320140',998.40,0.00,0.00,0.00,65.52,'2021-12-11 16:42:23','',''),(2250153,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-11 16:42:23','',''),(2250174,'1','144','828',360,'Retail Sale Id 1320148',8000.00,0.00,0.00,0.00,525.00,'2021-12-11 16:44:03','',''),(2250175,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:44:03','',''),(2250382,'1','144','828',360,'Retail Sale Id 1320233',5120.00,0.00,0.00,0.00,336.00,'2021-12-11 16:56:16','',''),(2250383,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-11 16:56:16','',''),(2250424,'1','144','828',360,'Return of Retail Sale Id 1318694',0.00,5120.00,8.00,0.00,-336.00,'2021-12-11 16:58:43','',''),(2251361,'1','144','828',360,'Retail Sale Id 1320675',3840.00,0.00,0.00,0.00,252.00,'2021-12-11 18:20:50','',''),(2251362,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 18:20:50','',''),(2251372,'1','144','828',360,'Retail Sale Id 1320679',1920.00,0.00,0.00,0.00,126.00,'2021-12-11 18:22:30','',''),(2251373,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 18:22:30','',''),(2251376,'1','144','828',360,'Retail Sale Id 1320681',3200.00,0.00,0.00,0.00,210.00,'2021-12-11 18:23:22','',''),(2251377,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 18:23:22','',''),(2251396,'1','144','828',360,'Retail Sale Id 1320689',186233.60,0.00,0.00,0.00,12221.58,'2021-12-11 18:28:02','',''),(2251397,'1','144','828',360,'Retail sales',0.00,0.00,0.00,290.99,0.00,'2021-12-11 18:28:02','',''),(2251408,'1','144','828',360,'Retail Sale Id 1320695',1999800.00,0.00,0.00,0.00,26400.00,'2021-12-11 18:30:37','',''),(2251409,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3300.00,0.00,'2021-12-11 18:30:37','',''),(2251411,'1','144','828',360,'Retail Sale Id 1320697',606000.00,0.00,0.00,0.00,8000.00,'2021-12-11 18:31:27','',''),(2251412,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1000.00,0.00,'2021-12-11 18:31:27','',''),(2251942,'1','144','828',360,'Retail Sale Id 1320793',8000.00,0.00,0.00,0.00,525.00,'2021-12-12 05:45:38','',''),(2251943,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 05:45:38','',''),(2251964,'1','144','828',360,'Retail Sale Id 1320802',1280.00,0.00,0.00,0.00,84.00,'2021-12-12 05:55:15','',''),(2251965,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 05:55:15','',''),(2251985,'1','144','828',360,'Retail Sale Id 1320804',4480.00,0.00,0.00,0.00,294.00,'2021-12-12 05:58:46','',''),(2251986,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-12 05:58:46','',''),(2251989,'1','144','828',360,'Retail Sale Id 1320806',3200.00,0.00,0.00,0.00,210.00,'2021-12-12 05:59:47','',''),(2251990,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 05:59:47','',''),(2252056,'1','144','828',360,'Retail Sale Id 1320819',2560.00,0.00,0.00,0.00,168.00,'2021-12-12 06:06:33','',''),(2252057,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 06:06:33','',''),(2252092,'1','144','828',360,'Retail Sale Id 1320836',1280.00,0.00,0.00,0.00,84.00,'2021-12-12 06:12:15','',''),(2252093,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 06:12:15','',''),(2252689,'1','144','828',360,'Retail Sale Id 1321072',3200.00,0.00,0.00,0.00,210.00,'2021-12-12 06:57:43','',''),(2252690,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 06:57:43','',''),(2252715,'1','144','828',360,'Retail Sale Id 1321089',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 06:59:23','',''),(2252716,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 06:59:23','',''),(2252735,'1','144','828',360,'Retail Sale Id 1321099',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 07:01:36','',''),(2252736,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 07:01:36','',''),(2252853,'1','144','828',360,'Retail Sale Id 1321161',8000.00,0.00,0.00,0.00,525.00,'2021-12-12 07:10:48','',''),(2252854,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 07:10:48','',''),(2252880,'1','144','828',360,'Retail Sale Id 1321174',12160.00,0.00,0.00,0.00,798.00,'2021-12-12 07:12:51','',''),(2252881,'1','144','828',360,'Retail sales',0.00,0.00,0.00,19.00,0.00,'2021-12-12 07:12:51','',''),(2252936,'1','144','828',360,'Retail Sale Id 1321204',640.00,0.00,0.00,0.00,42.00,'2021-12-12 07:16:38','',''),(2252937,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 07:16:38','',''),(2252992,'1','144','828',360,'Retail Sale Id 1321233',6720.00,0.00,0.00,0.00,441.00,'2021-12-12 07:21:10','',''),(2252993,'1','144','828',360,'Retail sales',0.00,0.00,0.00,10.50,0.00,'2021-12-12 07:21:10','',''),(2253012,'1','144','828',360,'Retail Sale Id 1321243',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 07:22:17','',''),(2253013,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 07:22:17','',''),(2253026,'1','144','828',360,'Retail Sale Id 1321252',1280.00,0.00,0.00,0.00,84.00,'2021-12-12 07:23:20','',''),(2253027,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 07:23:20','',''),(2253412,'1','144','828',360,'Retail Sale Id 1321474',4480.00,0.00,0.00,0.00,294.00,'2021-12-12 07:48:21','',''),(2253413,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-12 07:48:21','',''),(2253819,'1','144','828',360,'Retail Sale Id 1321678',998.40,0.00,0.00,0.00,65.52,'2021-12-12 08:14:14','',''),(2253820,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-12 08:14:14','',''),(2253873,'1','144','828',360,'Retail Sale Id 1321702',36600.00,0.00,0.00,0.00,720.00,'2021-12-12 08:18:03','',''),(2253874,'1','144','828',360,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-12 08:18:03','',''),(2253905,'1','144','828',360,'Retail Sale Id 1321718',5120.00,0.00,0.00,0.00,336.00,'2021-12-12 08:20:11','',''),(2253906,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-12 08:20:11','',''),(2253973,'1','144','828',360,'Retail Sale Id 1321740',152500.00,0.00,0.00,0.00,3000.00,'2021-12-12 08:24:30','',''),(2253974,'1','144','828',360,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-12 08:24:30','',''),(2254017,'1','144','828',360,'Retail Sale Id 1321773',152500.00,0.00,0.00,0.00,3000.00,'2021-12-12 08:28:05','',''),(2254018,'1','144','828',360,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-12 08:28:06','',''),(2254031,'1','144','828',360,'Retail Sale Id 1321781',7680.00,0.00,0.00,0.00,504.00,'2021-12-12 08:28:59','',''),(2254032,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-12 08:28:59','',''),(2254194,'1','144','828',360,'Retail Sale Id 1321841',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 08:39:30','',''),(2254195,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 08:39:30','',''),(2254210,'1','144','828',360,'Retail Sale Id 1321874',4480.00,0.00,0.00,0.00,294.00,'2021-12-12 08:40:31','',''),(2254211,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-12 08:40:31','',''),(2254438,'1','144','828',360,'Retail Sale Id 1321974',998.40,0.00,0.00,0.00,65.52,'2021-12-12 08:52:20','',''),(2254439,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-12 08:52:20','',''),(2254483,'1','144','828',360,'Retail Sale Id 1321996',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 08:55:28','',''),(2254484,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 08:55:28','',''),(2254493,'1','144','828',360,'Retail Sale Id 1322002',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 08:56:10','',''),(2254494,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 08:56:10','',''),(2254516,'1','144','828',360,'Retail Sale Id 1322012',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 08:57:25','',''),(2254517,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 08:57:25','',''),(2254530,'1','144','828',360,'Retail Sale Id 1322019',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 08:58:08','',''),(2254531,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 08:58:08','',''),(2254544,'1','144','828',360,'Retail Sale Id 1322026',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 08:58:58','',''),(2254545,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 08:58:58','',''),(2254560,'1','144','828',360,'Retail Sale Id 1322033',1600.00,0.00,0.00,0.00,105.00,'2021-12-12 08:59:52','',''),(2254561,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-12 08:59:52','',''),(2254649,'1','144','828',360,'Retail Sale Id 1322078',24000.00,0.00,0.00,0.00,1575.00,'2021-12-12 09:04:51','',''),(2254650,'1','144','828',360,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-12 09:04:51','',''),(2254675,'1','144','828',360,'Retail Sale Id 1322095',4480.00,0.00,0.00,0.00,294.00,'2021-12-12 09:06:12','',''),(2254676,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-12 09:06:12','',''),(2254691,'1','144','828',360,'Retail Sale Id 1322105',10240.00,0.00,0.00,0.00,672.00,'2021-12-12 09:07:03','',''),(2254692,'1','144','828',360,'Retail sales',0.00,0.00,0.00,16.00,0.00,'2021-12-12 09:07:03','',''),(2254837,'1','144','828',360,'Retail Sale Id 1322169',1497.60,0.00,0.00,0.00,98.28,'2021-12-12 09:14:27','',''),(2254838,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-12 09:14:27','',''),(2255148,'1','144','828',360,'Retail Sale Id 1322326',1497.60,0.00,0.00,0.00,98.28,'2021-12-12 09:32:43','',''),(2255149,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-12 09:32:43','',''),(2255165,'1','144','828',360,'Retail Sale Id 1322336',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 09:33:32','',''),(2255166,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 09:33:32','',''),(2255197,'1','144','828',360,'Retail Sale Id 1322349',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 09:34:58','',''),(2255198,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 09:34:58','',''),(2255227,'1','144','828',360,'Retail Sale Id 1322358',998.40,0.00,0.00,0.00,65.52,'2021-12-12 09:36:58','',''),(2255228,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-12 09:36:58','',''),(2255275,'1','144','828',360,'Retail Sale Id 1322392',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 09:41:27','',''),(2255276,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 09:41:27','',''),(2255291,'1','144','828',360,'Retail Sale Id 1322401',24400.00,0.00,0.00,0.00,480.00,'2021-12-12 09:42:36','',''),(2255292,'1','144','828',360,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-12 09:42:36','',''),(2255409,'1','144','828',360,'Retail Sale Id 1322454',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 09:48:47','',''),(2255410,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 09:48:47','',''),(2255423,'1','144','828',360,'Retail Sale Id 1322462',998.40,0.00,0.00,0.00,65.52,'2021-12-12 09:49:25','',''),(2255424,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-12 09:49:25','',''),(2255751,'1','144','828',360,'Retail Sale Id 1322603',24400.00,0.00,0.00,0.00,480.00,'2021-12-12 10:03:41','',''),(2255752,'1','144','828',360,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-12 10:03:41','',''),(2255803,'1','144','828',360,'Retail Sale Id 1322633',998.40,0.00,0.00,0.00,65.52,'2021-12-12 10:05:50','',''),(2255804,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-12 10:05:50','',''),(2256463,'1','144','828',360,'Retail Sale Id 1322989',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 10:41:27','',''),(2256464,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:41:27','',''),(2256485,'1','144','828',360,'Retail Sale Id 1323000',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 10:42:07','',''),(2256486,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:42:07','',''),(2256508,'1','144','828',360,'Retail Sale Id 1323005',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 10:42:58','',''),(2256509,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:42:58','',''),(2256544,'1','144','828',360,'Retail Sale Id 1323020',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 10:44:26','',''),(2256545,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:44:26','',''),(2256556,'1','144','828',360,'Retail Sale Id 1323027',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 10:45:07','',''),(2256557,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:45:07','',''),(2256572,'1','144','828',360,'Retail Sale Id 1323034',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 10:45:56','',''),(2256573,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:45:56','',''),(2256596,'1','144','828',360,'Retail Sale Id 1323046',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 10:46:57','',''),(2256597,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:46:57','',''),(2256638,'1','144','828',360,'Retail Sale Id 1323070',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 10:49:21','',''),(2256639,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:49:21','',''),(2256664,'1','144','828',360,'Retail Sale Id 1323084',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 10:50:25','',''),(2256665,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:50:25','',''),(2256678,'1','144','828',360,'Retail Sale Id 1323091',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 10:51:09','',''),(2256679,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:51:09','',''),(2256695,'1','144','828',360,'Retail Sale Id 1323099',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 10:51:53','',''),(2256696,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:51:53','',''),(2256731,'1','144','828',360,'Retail Sale Id 1323119',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 10:53:23','',''),(2256732,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:53:23','',''),(2256773,'1','144','828',360,'Retail Sale Id 1323139',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 10:55:39','',''),(2256774,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:55:39','',''),(2256794,'1','144','828',360,'Retail Sale Id 1323150',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 10:56:24','',''),(2256795,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:56:24','',''),(2256820,'1','144','828',360,'Retail Sale Id 1323167',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 10:57:32','',''),(2256821,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:57:32','',''),(2257056,'1','144','828',360,'Retail Sale Id 1323281',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 11:06:52','',''),(2257057,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 11:06:52','',''),(2257098,'1','144','828',360,'Retail Sale Id 1323298',998.40,0.00,0.00,0.00,65.52,'2021-12-12 11:08:32','',''),(2257099,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-12 11:08:32','',''),(2257156,'1','144','828',360,'Retail Sale Id 1323331',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 11:10:25','',''),(2257157,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 11:10:25','',''),(2257178,'1','144','828',360,'Retail Sale Id 1323340',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 11:11:54','',''),(2257179,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 11:11:54','',''),(2257215,'1','144','828',360,'Retail Sale Id 1323361',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 11:13:28','',''),(2257216,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 11:13:28','',''),(2257249,'1','144','828',360,'Retail Sale Id 1323377',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 11:15:07','',''),(2257250,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 11:15:07','',''),(2257439,'1','144','828',360,'Retail Sale Id 1323470',8000.00,0.00,0.00,0.00,525.00,'2021-12-12 11:22:09','',''),(2257440,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:22:09','',''),(2257532,'1','144','828',360,'Retail Sale Id 1323513',8000.00,0.00,0.00,0.00,525.00,'2021-12-12 11:26:35','',''),(2257533,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:26:35','',''),(2257552,'1','144','828',360,'Retail Sale Id 1323525',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 11:27:39','',''),(2257553,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 11:27:40','',''),(2257586,'1','144','828',360,'Retail Sale Id 1323560',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 11:29:10','',''),(2257587,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 11:29:10','',''),(2257608,'1','144','828',360,'Retail Sale Id 1323569',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 11:30:20','',''),(2257609,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 11:30:20','',''),(2257674,'1','144','828',360,'Retail Sale Id 1323598',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 11:33:39','',''),(2257675,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 11:33:39','',''),(2257701,'1','144','828',360,'Retail Sale Id 1323616',4480.00,0.00,0.00,0.00,294.00,'2021-12-12 11:35:02','',''),(2257702,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-12 11:35:02','',''),(2257789,'1','144','828',360,'Retail Sale Id 1323657',998.40,0.00,0.00,0.00,65.52,'2021-12-12 11:39:37','',''),(2257790,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-12 11:39:37','',''),(2257879,'1','144','828',360,'Retail Sale Id 1323697',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 11:43:09','',''),(2257880,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 11:43:09','',''),(2258267,'1','144','828',360,'Retail Sale Id 1323880',11840.00,0.00,0.00,0.00,777.00,'2021-12-12 12:01:34','',''),(2258268,'1','144','828',360,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-12 12:01:34','',''),(2258288,'1','144','828',360,'Retail Sale Id 1323893',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 12:02:54','',''),(2258289,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:02:54','',''),(2258300,'1','144','828',360,'Retail Sale Id 1323898',1280.00,0.00,0.00,0.00,84.00,'2021-12-12 12:03:53','',''),(2258301,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 12:03:53','',''),(2258330,'1','144','828',360,'Retail Sale Id 1323913',5120.00,0.00,0.00,0.00,336.00,'2021-12-12 12:05:38','',''),(2258331,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-12 12:05:38','',''),(2258340,'1','144','828',360,'Retail Sale Id 1323919',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 12:06:36','',''),(2258341,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:06:36','',''),(2258354,'1','144','828',360,'Retail Sale Id 1323926',9920.00,0.00,0.00,0.00,651.00,'2021-12-12 12:07:42','',''),(2258355,'1','144','828',360,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-12 12:07:42','',''),(2258434,'1','144','828',360,'Retail Sale Id 1323965',1280.00,0.00,0.00,0.00,84.00,'2021-12-12 12:11:57','',''),(2258435,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 12:11:57','',''),(2258502,'1','144','828',360,'Retail Sale Id 1323995',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 12:15:15','',''),(2258503,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:15:15','',''),(2258526,'1','144','828',360,'Retail Sale Id 1324006',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 12:16:11','',''),(2258527,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:16:11','',''),(2258556,'1','144','828',360,'Retail Sale Id 1324021',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 12:17:23','',''),(2258557,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:17:23','',''),(2258570,'1','144','828',360,'Retail Sale Id 1324029',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 12:18:04','',''),(2258571,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:18:04','',''),(2258590,'1','144','828',360,'Retail Sale Id 1324036',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 12:18:59','',''),(2258591,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:18:59','',''),(2258616,'1','144','828',360,'Retail Sale Id 1324052',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 12:20:06','',''),(2258617,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:20:06','',''),(2258624,'1','144','828',360,'Retail Sale Id 1324056',8000.00,0.00,0.00,0.00,525.00,'2021-12-12 12:20:46','',''),(2258625,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:20:46','',''),(2258678,'1','144','828',360,'Retail Sale Id 1324084',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 12:23:45','',''),(2258679,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:23:45','',''),(2258702,'1','144','828',360,'Retail Sale Id 1324096',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 12:24:59','',''),(2258703,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:24:59','',''),(2258718,'1','144','828',360,'Retail Sale Id 1324106',1280.00,0.00,0.00,0.00,84.00,'2021-12-12 12:25:46','',''),(2258719,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 12:25:46','',''),(2258764,'1','144','828',360,'Retail Sale Id 1324119',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 12:27:19','',''),(2258765,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:27:19','',''),(2258811,'1','144','828',360,'Retail Sale Id 1324137',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 12:28:49','',''),(2258812,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:28:49','',''),(2258830,'1','144','828',360,'Retail Sale Id 1324146',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 12:29:51','',''),(2258831,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 12:29:51','',''),(2258848,'1','144','828',360,'Retail Sale Id 1324157',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 12:30:38','',''),(2258849,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 12:30:38','',''),(2258972,'1','144','828',360,'Retail Sale Id 1324179',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 12:35:45','',''),(2258973,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:35:45','',''),(2259005,'1','144','828',360,'Retail Sale Id 1324235',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 12:37:20','',''),(2259006,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:37:20','',''),(2259046,'1','144','828',360,'Retail Sale Id 1324255',32000.00,0.00,0.00,0.00,2100.00,'2021-12-12 12:38:51','',''),(2259047,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 12:38:51','',''),(2259074,'1','144','828',360,'Retail Sale Id 1324271',998.40,0.00,0.00,0.00,65.52,'2021-12-12 12:40:11','',''),(2259075,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-12 12:40:11','',''),(2259091,'1','144','828',360,'Retail Sale Id 1324277',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 12:41:07','',''),(2259092,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:41:07','',''),(2259147,'1','144','828',360,'Retail Sale Id 1324304',8000.00,0.00,0.00,0.00,525.00,'2021-12-12 12:44:21','',''),(2259148,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:44:21','',''),(2259174,'1','144','828',360,'Retail Sale Id 1324314',8000.00,0.00,0.00,0.00,525.00,'2021-12-12 12:45:09','',''),(2259175,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:45:09','',''),(2259192,'1','144','828',360,'Retail Sale Id 1324324',8000.00,0.00,0.00,0.00,525.00,'2021-12-12 12:45:57','',''),(2259193,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:45:57','',''),(2259210,'1','144','828',360,'Retail Sale Id 1324331',8000.00,0.00,0.00,0.00,525.00,'2021-12-12 12:46:59','',''),(2259211,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:46:59','',''),(2259250,'1','144','828',360,'Retail Sale Id 1324351',1280.00,0.00,0.00,0.00,84.00,'2021-12-12 12:48:21','',''),(2259251,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 12:48:21','',''),(2259280,'1','144','828',360,'Retail Sale Id 1324369',8000.00,0.00,0.00,0.00,525.00,'2021-12-12 12:49:54','',''),(2259281,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:49:54','',''),(2259318,'1','144','828',360,'Retail Sale Id 1324384',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 12:51:53','',''),(2259319,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 12:51:53','',''),(2259330,'1','144','828',360,'Retail Sale Id 1324393',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 12:52:34','',''),(2259331,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 12:52:34','',''),(2259348,'1','144','828',360,'Retail Sale Id 1324401',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 12:53:33','',''),(2259349,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 12:53:33','',''),(2259370,'1','144','828',360,'Retail Sale Id 1324407',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 12:54:20','',''),(2259371,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 12:54:20','',''),(2259397,'1','144','828',360,'Retail Sale Id 1324420',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 12:55:21','',''),(2259398,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 12:55:21','',''),(2259417,'1','144','828',360,'Retail Sale Id 1324431',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 12:56:25','',''),(2259418,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 12:56:25','',''),(2259441,'1','144','828',360,'Retail Sale Id 1324442',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 12:57:31','',''),(2259442,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 12:57:31','',''),(2259455,'1','144','828',360,'Retail Sale Id 1324449',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 12:58:41','',''),(2259456,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 12:58:41','',''),(2259493,'1','144','828',360,'Retail Sale Id 1324469',1280.00,0.00,0.00,0.00,84.00,'2021-12-12 13:00:35','',''),(2259494,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 13:00:35','',''),(2259501,'1','144','828',360,'Retail Sale Id 1324472',8000.00,0.00,0.00,0.00,525.00,'2021-12-12 13:01:26','',''),(2259502,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 13:01:26','',''),(2259515,'1','144','828',360,'Retail Sale Id 1324478',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 13:02:10','',''),(2259516,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 13:02:10','',''),(2259527,'1','144','828',360,'Retail Sale Id 1324485',3200.00,0.00,0.00,0.00,210.00,'2021-12-12 13:03:03','',''),(2259528,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 13:03:03','',''),(2259772,'1','144','828',360,'Retail Sale Id 1324614',3200.00,0.00,0.00,0.00,210.00,'2021-12-12 13:16:30','',''),(2259773,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 13:16:30','',''),(2260093,'1','144','828',360,'Return of Retail Sale Id 1321773',0.00,152500.00,250.00,0.00,-3000.00,'2021-12-12 13:30:29','',''),(2260651,'1','144','828',360,'Retail Sale Id 1324993',8000.00,0.00,0.00,0.00,525.00,'2021-12-12 13:58:13','',''),(2260652,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 13:58:13','',''),(2260868,'1','144','828',360,'Retail Sale Id 1325057',5120.00,0.00,0.00,0.00,336.00,'2021-12-12 14:06:40','',''),(2260869,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-12 14:06:40','',''),(2261003,'1','144','828',360,'Retail Sale Id 1325116',30500.00,0.00,0.00,0.00,600.00,'2021-12-12 14:12:52','',''),(2261004,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 14:12:52','',''),(2261089,'1','144','828',360,'Retail Sale Id 1325158',1996.80,0.00,0.00,0.00,131.04,'2021-12-12 14:17:59','',''),(2261090,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.12,0.00,'2021-12-12 14:17:59','',''),(2261369,'1','144','828',360,'Retail Sale Id 1325249',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 14:29:19','',''),(2261370,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 14:29:19','',''),(2261404,'1','144','828',360,'Retail Sale Id 1325258',3200.00,0.00,0.00,0.00,210.00,'2021-12-12 14:30:46','',''),(2261405,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 14:30:46','',''),(2261681,'1','144','828',360,'Retail Sale Id 1325389',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 14:47:27','',''),(2261682,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 14:47:27','',''),(2261716,'1','144','828',360,'Retail Sale Id 1325401',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 14:49:35','',''),(2261717,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 14:49:35','',''),(2261749,'1','144','828',360,'Retail Sale Id 1325420',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 14:50:28','',''),(2261750,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 14:50:28','',''),(2261793,'1','144','828',360,'Retail Sale Id 1325439',2995.20,0.00,0.00,0.00,196.56,'2021-12-12 14:52:38','',''),(2261794,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.68,0.00,'2021-12-12 14:52:38','',''),(2261803,'1','144','828',360,'Retail Sale Id 1325446',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 14:53:44','',''),(2261804,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 14:53:44','',''),(2261995,'1','144','828',360,'Retail Sale Id 1325521',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 15:03:39','',''),(2261996,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 15:03:39','',''),(2262046,'1','144','828',360,'Retail Sale Id 1325531',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 15:05:39','',''),(2262047,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 15:05:39','',''),(2262064,'1','144','828',360,'Retail Sale Id 1325543',1478.40,0.00,0.00,0.00,97.02,'2021-12-12 15:06:53','',''),(2262065,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.31,0.00,'2021-12-12 15:06:53','',''),(2262104,'1','144','828',360,'Retail Sale Id 1325559',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 15:08:57','',''),(2262105,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 15:08:57','',''),(2262121,'1','144','828',360,'Retail Sale Id 1325569',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 15:09:55','',''),(2262122,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 15:09:55','',''),(2262139,'1','144','828',360,'Retail Sale Id 1325578',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 15:11:14','',''),(2262140,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 15:11:14','',''),(2262163,'1','144','828',360,'Retail Sale Id 1325590',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 15:12:43','',''),(2262164,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 15:12:43','',''),(2262195,'1','144','828',360,'Retail Sale Id 1325607',1280.00,0.00,0.00,0.00,84.00,'2021-12-12 15:14:51','',''),(2262196,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 15:14:51','',''),(2262246,'1','144','828',360,'Retail Sale Id 1325634',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 15:17:18','',''),(2262247,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 15:17:18','',''),(2262285,'1','144','828',360,'Retail Sale Id 1325648',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 15:19:09','',''),(2262286,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 15:19:09','',''),(2262299,'1','144','828',360,'Retail Sale Id 1325654',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 15:20:12','',''),(2262300,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 15:20:12','',''),(2262321,'1','144','828',360,'Retail Sale Id 1325665',2995.20,0.00,0.00,0.00,196.56,'2021-12-12 15:22:17','',''),(2262322,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.68,0.00,'2021-12-12 15:22:17','',''),(2262341,'1','144','828',360,'Retail Sale Id 1325676',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 15:23:27','',''),(2262342,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 15:23:27','',''),(2262365,'1','144','828',360,'Retail Sale Id 1325687',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 15:24:38','',''),(2262366,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 15:24:38','',''),(2262404,'1','144','828',360,'Retail Sale Id 1325702',998.40,0.00,0.00,0.00,65.52,'2021-12-12 15:26:34','',''),(2262405,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-12 15:26:34','',''),(2262473,'1','144','828',360,'Retail Sale Id 1325737',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 15:30:47','',''),(2262474,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 15:30:47','',''),(2262499,'1','144','828',360,'Retail Sale Id 1325752',2496.00,0.00,0.00,0.00,163.80,'2021-12-12 15:31:56','',''),(2262500,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.90,0.00,'2021-12-12 15:31:56','',''),(2262522,'1','144','828',360,'Retail Sale Id 1325762',3200.00,0.00,0.00,0.00,210.00,'2021-12-12 15:33:24','',''),(2262523,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 15:33:24','',''),(2262532,'1','144','828',360,'Retail Sale Id 1325767',5760.00,0.00,0.00,0.00,378.00,'2021-12-12 15:34:39','',''),(2262533,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-12 15:34:39','',''),(2262620,'1','144','828',360,'Retail Sale Id 1325805',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 15:38:54','',''),(2262621,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 15:38:54','',''),(2262654,'1','144','828',360,'Retail Sale Id 1325819',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 15:40:34','',''),(2262655,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 15:40:34','',''),(2262708,'1','144','828',360,'Retail Sale Id 1325845',8000.00,0.00,0.00,0.00,525.00,'2021-12-12 15:42:57','',''),(2262709,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 15:42:57','',''),(2262750,'1','144','828',360,'Retail Sale Id 1325864',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 15:44:30','',''),(2262751,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 15:44:30','',''),(2262776,'1','144','828',360,'Retail Sale Id 1325873',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 15:46:45','',''),(2262777,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 15:46:45','',''),(2262808,'1','144','828',360,'Retail Sale Id 1325891',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 15:48:32','',''),(2262809,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 15:48:32','',''),(2262828,'1','144','828',360,'Return of Retail Sale Id 1325845',0.00,8000.00,12.50,0.00,-525.00,'2021-12-12 15:49:49','',''),(2262927,'1','144','828',360,'Retail Sale Id 1325951',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 15:57:18','',''),(2262928,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 15:57:18','',''),(2262939,'1','144','828',360,'Retail Sale Id 1325958',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 15:58:09','',''),(2262940,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 15:58:09','',''),(2263013,'1','144','828',360,'Retail Sale Id 1325995',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 16:03:00','',''),(2263014,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 16:03:00','',''),(2263119,'1','144','828',360,'Retail Sale Id 1326052',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 16:10:47','',''),(2263120,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 16:10:47','',''),(2263198,'1','144','828',360,'Retail Sale Id 1326085',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 16:16:31','',''),(2263199,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 16:16:31','',''),(2263254,'1','144','828',360,'Retail Sale Id 1326114',1280.00,0.00,0.00,0.00,84.00,'2021-12-12 16:19:47','',''),(2263255,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 16:19:47','',''),(2263274,'1','144','828',360,'Retail Sale Id 1326122',1497.60,0.00,0.00,0.00,98.28,'2021-12-12 16:20:54','',''),(2263275,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-12 16:20:54','',''),(2263286,'1','144','828',360,'Retail Sale Id 1326129',1280.00,0.00,0.00,0.00,84.00,'2021-12-12 16:21:59','',''),(2263287,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 16:21:59','',''),(2263296,'1','144','828',360,'Retail Sale Id 1326134',998.40,0.00,0.00,0.00,65.52,'2021-12-12 16:22:54','',''),(2263297,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-12 16:22:54','',''),(2263328,'1','144','828',360,'Retail Sale Id 1326140',1280.00,0.00,0.00,0.00,84.00,'2021-12-12 16:24:01','',''),(2263329,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 16:24:01','',''),(2263382,'1','144','828',360,'Retail Sale Id 1326153',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 16:25:33','',''),(2263383,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 16:25:33','',''),(2263411,'1','144','828',360,'Retail Sale Id 1326163',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 16:26:58','',''),(2263412,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 16:26:58','',''),(2263419,'1','144','828',360,'Retail Sale Id 1326169',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 16:28:18','',''),(2263420,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 16:28:18','',''),(2263439,'1','144','828',360,'Retail Sale Id 1326178',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 16:29:20','',''),(2263440,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 16:29:20','',''),(2263484,'1','144','828',360,'Retail Sale Id 1326205',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 16:32:38','',''),(2263485,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 16:32:38','',''),(2263502,'1','144','828',360,'Retail Sale Id 1326215',1280.00,0.00,0.00,0.00,84.00,'2021-12-12 16:33:36','',''),(2263503,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 16:33:36','',''),(2263542,'1','144','828',360,'Retail Sale Id 1326232',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 16:35:18','',''),(2263543,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 16:35:18','',''),(2263572,'1','144','828',360,'Retail Sale Id 1326250',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 16:37:21','',''),(2263573,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 16:37:21','',''),(2263663,'1','144','828',360,'Retail Sale Id 1326286',3200.00,0.00,0.00,0.00,210.00,'2021-12-12 16:42:57','',''),(2263664,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 16:42:57','',''),(2263691,'1','144','828',360,'Retail Sale Id 1326299',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 16:44:38','',''),(2263692,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 16:44:38','',''),(2263703,'1','144','828',360,'Retail Sale Id 1326305',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 16:45:56','',''),(2263704,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 16:45:56','',''),(2263727,'1','144','828',360,'Retail Sale Id 1326314',1280.00,0.00,0.00,0.00,84.00,'2021-12-12 16:47:03','',''),(2263728,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 16:47:03','',''),(2263753,'1','144','828',360,'Retail Sale Id 1326332',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 16:48:22','',''),(2263754,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 16:48:22','',''),(2263785,'1','144','828',360,'Retail Sale Id 1326342',3200.00,0.00,0.00,0.00,210.00,'2021-12-12 16:49:33','',''),(2263786,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 16:49:33','',''),(2263803,'1','144','828',360,'Retail Sale Id 1326352',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 16:50:36','',''),(2263804,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 16:50:36','',''),(2263827,'1','144','828',360,'Retail Sale Id 1326362',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 16:51:37','',''),(2263828,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 16:51:37','',''),(2263878,'1','144','828',360,'Retail Sale Id 1326386',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 16:54:38','',''),(2263879,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 16:54:38','',''),(2264477,'1','144','828',360,'Retail Sale Id 1326657',8000.00,0.00,0.00,0.00,525.00,'2021-12-12 18:02:36','',''),(2264478,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 18:02:36','',''),(2264534,'1','144','828',360,'Retail Sale Id 1326672',3840.00,0.00,0.00,0.00,252.00,'2021-12-12 18:12:00','',''),(2264535,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 18:12:00','',''),(2264548,'1','144','828',360,'Retail Sale Id 1326675',3200.00,0.00,0.00,0.00,210.00,'2021-12-12 18:14:31','',''),(2264549,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 18:14:31','',''),(2264554,'1','144','828',360,'Retail Sale Id 1326680',1920.00,0.00,0.00,0.00,126.00,'2021-12-12 18:15:39','',''),(2264555,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 18:15:39','',''),(2264558,'1','144','828',360,'Retail Sale Id 1326682',1280.00,0.00,0.00,0.00,84.00,'2021-12-12 18:16:42','',''),(2264559,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 18:16:42','',''),(2264562,'1','144','828',360,'Retail Sale Id 1326684',2560.00,0.00,0.00,0.00,168.00,'2021-12-12 18:17:47','',''),(2264563,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 18:17:47','',''),(2264594,'1','144','828',360,'Retail Sale Id 1326701',246073.60,0.00,0.00,0.00,16148.58,'2021-12-12 18:30:01','',''),(2264595,'1','144','828',360,'Retail sales',0.00,0.00,0.00,384.49,0.00,'2021-12-12 18:30:01','',''),(2264596,'1','144','828',360,'Retail Sale Id 1326703',122000.00,0.00,0.00,0.00,2400.00,'2021-12-12 18:30:58','',''),(2264597,'1','144','828',360,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-12 18:30:58','',''),(2265270,'1','144','828',360,'Retail Sale Id 1326775',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 05:48:08','',''),(2265271,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 05:48:08','',''),(2265276,'1','144','828',360,'Retail Sale Id 1326776',3200.00,0.00,0.00,0.00,210.00,'2021-12-13 05:49:43','',''),(2265277,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 05:49:43','',''),(2265309,'1','144','828',360,'Retail Sale Id 1326786',8000.00,0.00,0.00,0.00,525.00,'2021-12-13 06:00:46','',''),(2265310,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 06:00:46','',''),(2265313,'1','144','828',360,'Retail Sale Id 1326788',3200.00,0.00,0.00,0.00,210.00,'2021-12-13 06:01:45','',''),(2265314,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 06:01:45','',''),(2265333,'1','144','828',360,'Retail Sale Id 1326795',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 06:08:24','',''),(2265334,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 06:08:24','',''),(2265377,'1','144','828',360,'Retail Sale Id 1326816',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 06:17:17','',''),(2265378,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 06:17:17','',''),(2265383,'1','144','828',360,'Retail Sale Id 1326818',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 06:17:53','',''),(2265384,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 06:17:53','',''),(2265401,'1','144','828',360,'Retail Sale Id 1326827',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 06:20:05','',''),(2265402,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 06:20:05','',''),(2265492,'1','144','828',360,'Retail Sale Id 1326865',998.40,0.00,0.00,0.00,65.52,'2021-12-13 06:32:40','',''),(2265493,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-13 06:32:40','',''),(2265508,'1','144','828',360,'Retail Sale Id 1326875',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 06:34:46','',''),(2265509,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 06:34:46','',''),(2265514,'1','144','828',360,'Retail Sale Id 1326876',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 06:35:38','',''),(2265515,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 06:35:38','',''),(2265937,'1','144','828',360,'Retail Sale Id 1327096',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 07:09:43','',''),(2265938,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 07:09:43','',''),(2265965,'1','144','828',360,'Retail Sale Id 1327110',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 07:11:47','',''),(2265966,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 07:11:47','',''),(2265981,'1','144','828',360,'Retail Sale Id 1327120',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 07:12:47','',''),(2265982,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 07:12:47','',''),(2266013,'1','144','828',360,'Retail Sale Id 1327138',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 07:15:13','',''),(2266014,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 07:15:13','',''),(2266041,'1','144','828',360,'Retail Sale Id 1327147',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 07:16:56','',''),(2266042,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 07:16:56','',''),(2266061,'1','144','828',360,'Retail Sale Id 1327164',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 07:18:33','',''),(2266062,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 07:18:33','',''),(2266107,'1','144','828',360,'Retail Sale Id 1327185',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 07:21:06','',''),(2266108,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:21:06','',''),(2266115,'1','144','828',360,'Retail Sale Id 1327191',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 07:21:58','',''),(2266116,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:21:58','',''),(2266238,'1','144','828',360,'Retail Sale Id 1327247',61000.00,0.00,0.00,0.00,1200.00,'2021-12-13 07:30:16','',''),(2266239,'1','144','828',360,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-13 07:30:16','',''),(2266303,'1','144','828',360,'Retail Sale Id 1327277',640.00,0.00,0.00,0.00,42.00,'2021-12-13 07:33:47','',''),(2266304,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-13 07:33:47','',''),(2266357,'1','144','828',360,'Retail Sale Id 1327308',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 07:37:45','',''),(2266358,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:37:45','',''),(2266373,'1','144','828',360,'Retail Sale Id 1327315',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 07:38:43','',''),(2266374,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:38:43','',''),(2266387,'1','144','828',360,'Retail Sale Id 1327320',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 07:39:32','',''),(2266388,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:39:32','',''),(2266415,'1','144','828',360,'Retail Sale Id 1327338',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 07:40:57','',''),(2266416,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:40:57','',''),(2266445,'1','144','828',360,'Retail Sale Id 1327346',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 07:42:30','',''),(2266446,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:42:30','',''),(2266468,'1','144','828',360,'Retail Sale Id 1327356',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 07:43:52','',''),(2266469,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:43:52','',''),(2266484,'1','144','828',360,'Retail Sale Id 1327367',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 07:44:50','',''),(2266485,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:44:50','',''),(2266526,'1','144','828',360,'Retail Sale Id 1327380',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 07:47:01','',''),(2266527,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:47:01','',''),(2266548,'1','144','828',360,'Retail Sale Id 1327393',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 07:48:26','',''),(2266549,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:48:26','',''),(2266583,'1','144','828',360,'Retail Sale Id 1327411',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 07:49:59','',''),(2266584,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:49:59','',''),(2266604,'1','144','828',360,'Retail Sale Id 1327421',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 07:51:41','',''),(2266605,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:51:41','',''),(2266763,'1','144','828',360,'Retail Sale Id 1327495',27450.00,0.00,0.00,0.00,540.00,'2021-12-13 08:00:20','',''),(2266764,'1','144','828',360,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-13 08:00:20','',''),(2267296,'1','144','828',360,'Retail Sale Id 1327686',7040.00,0.00,0.00,0.00,462.00,'2021-12-13 08:23:57','',''),(2267297,'1','144','828',360,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-13 08:23:57','',''),(2267356,'1','144','828',360,'Retail Sale Id 1327720',14400.00,0.00,0.00,0.00,945.00,'2021-12-13 08:27:52','',''),(2267357,'1','144','828',360,'Retail sales',0.00,0.00,0.00,22.50,0.00,'2021-12-13 08:27:52','',''),(2267627,'1','144','828',360,'Retail Sale Id 1327850',30500.00,0.00,0.00,0.00,600.00,'2021-12-13 08:39:58','',''),(2267628,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 08:39:58','',''),(2268418,'1','144','828',360,'Retail Sale Id 1328174',4160.00,0.00,0.00,0.00,273.00,'2021-12-13 09:23:44','',''),(2268419,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-13 09:23:44','',''),(2268560,'1','144','828',360,'Retail Sale Id 1328255',7040.00,0.00,0.00,0.00,462.00,'2021-12-13 09:32:48','',''),(2268561,'1','144','828',360,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-13 09:32:48','',''),(2268736,'1','144','828',360,'Retail Sale Id 1328347',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 09:45:56','',''),(2268737,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 09:45:56','',''),(2268761,'1','144','828',360,'Retail Sale Id 1328360',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 09:47:23','',''),(2268762,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 09:47:23','',''),(2268791,'1','144','828',360,'Retail Sale Id 1328374',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 09:48:37','',''),(2268792,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 09:48:37','',''),(2268853,'1','144','828',360,'Retail Sale Id 1328390',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 09:52:24','',''),(2268854,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 09:52:24','',''),(2268871,'1','144','828',360,'Retail Sale Id 1328409',6400.00,0.00,0.00,0.00,420.00,'2021-12-13 09:53:49','',''),(2268872,'1','144','828',360,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 09:53:49','',''),(2268911,'1','144','828',360,'Retail Sale Id 1328434',6400.00,0.00,0.00,0.00,420.00,'2021-12-13 09:56:17','',''),(2268912,'1','144','828',360,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 09:56:17','',''),(2268969,'1','144','828',360,'Retail Sale Id 1328449',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 09:59:17','',''),(2268970,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 09:59:17','',''),(2268997,'1','144','828',360,'Retail Sale Id 1328469',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:00:17','',''),(2268998,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:00:17','',''),(2269011,'1','144','828',360,'Retail Sale Id 1328474',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:01:09','',''),(2269012,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:01:09','',''),(2269021,'1','144','828',360,'Retail Sale Id 1328478',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:02:05','',''),(2269022,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:02:05','',''),(2269029,'1','144','828',360,'Retail Sale Id 1328484',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:02:50','',''),(2269030,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:02:50','',''),(2269045,'1','144','828',360,'Retail Sale Id 1328493',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:03:41','',''),(2269046,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:03:41','',''),(2269051,'1','144','828',360,'Retail Sale Id 1328498',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:04:44','',''),(2269052,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:04:44','',''),(2269199,'1','144','828',360,'Retail Sale Id 1328589',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:15:59','',''),(2269200,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:15:59','',''),(2269209,'1','144','828',360,'Retail Sale Id 1328596',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:17:02','',''),(2269210,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:17:02','',''),(2269225,'1','144','828',360,'Retail Sale Id 1328605',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:17:51','',''),(2269226,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:17:51','',''),(2269255,'1','144','828',360,'Retail Sale Id 1328619',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:19:47','',''),(2269256,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:19:47','',''),(2269263,'1','144','828',360,'Retail Sale Id 1328624',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:20:31','',''),(2269264,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:20:31','',''),(2269279,'1','144','828',360,'Retail Sale Id 1328630',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:21:33','',''),(2269280,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:21:33','',''),(2269301,'1','144','828',360,'Retail Sale Id 1328643',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:23:27','',''),(2269302,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:23:27','',''),(2269315,'1','144','828',360,'Retail Sale Id 1328650',9920.00,0.00,0.00,0.00,651.00,'2021-12-13 10:24:46','',''),(2269316,'1','144','828',360,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-13 10:24:46','',''),(2269387,'1','144','828',360,'Retail Sale Id 1328680',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:30:06','',''),(2269388,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:30:06','',''),(2269407,'1','144','828',360,'Retail Sale Id 1328691',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:31:04','',''),(2269408,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:31:04','',''),(2269427,'1','144','828',360,'Retail Sale Id 1328702',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:32:05','',''),(2269428,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:32:05','',''),(2269439,'1','144','828',360,'Retail Sale Id 1328709',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:33:02','',''),(2269440,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:33:02','',''),(2269467,'1','144','828',360,'Retail Sale Id 1328716',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:34:14','',''),(2269468,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:34:14','',''),(2269499,'1','144','828',360,'Retail Sale Id 1328733',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:35:44','',''),(2269500,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:35:44','',''),(2269521,'1','144','828',360,'Retail Sale Id 1328741',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:37:13','',''),(2269522,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:37:13','',''),(2269539,'1','144','828',360,'Retail Sale Id 1328752',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:38:34','',''),(2269540,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:38:34','',''),(2269554,'1','144','828',360,'Retail Sale Id 1328758',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:39:13','',''),(2269555,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:39:13','',''),(2269566,'1','144','828',360,'Retail Sale Id 1328765',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:40:12','',''),(2269567,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:40:12','',''),(2269582,'1','144','828',360,'Retail Sale Id 1328771',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:40:59','',''),(2269583,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:40:59','',''),(2269596,'1','144','828',360,'Retail Sale Id 1328779',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:41:38','',''),(2269597,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:41:38','',''),(2269620,'1','144','828',360,'Retail Sale Id 1328790',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:42:51','',''),(2269621,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:42:51','',''),(2269628,'1','144','828',360,'Retail Sale Id 1328793',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:43:45','',''),(2269629,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:43:45','',''),(2269646,'1','144','828',360,'Retail Sale Id 1328801',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:44:57','',''),(2269647,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:44:57','',''),(2269678,'1','144','828',360,'Retail Sale Id 1328809',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:46:22','',''),(2269679,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:46:22','',''),(2269708,'1','144','828',360,'Retail Sale Id 1328830',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:48:16','',''),(2269709,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:48:16','',''),(2269730,'1','144','828',360,'Retail Sale Id 1328842',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:49:18','',''),(2269731,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:49:18','',''),(2269736,'1','144','828',360,'Retail Sale Id 1328856',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:50:03','',''),(2269737,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:50:03','',''),(2269754,'1','144','828',360,'Retail Sale Id 1328862',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:50:42','',''),(2269755,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:50:42','',''),(2269780,'1','144','828',360,'Retail Sale Id 1328870',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 10:51:31','',''),(2269781,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:51:31','',''),(2269812,'1','144','828',360,'Retail Sale Id 1328886',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 10:53:08','',''),(2269813,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 10:53:08','',''),(2269818,'1','144','828',360,'Retail Sale Id 1328889',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 10:53:52','',''),(2269819,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 10:53:52','',''),(2269822,'1','144','828',360,'Retail Sale Id 1328892',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 10:54:34','',''),(2269823,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 10:54:34','',''),(2269844,'1','144','828',360,'Retail Sale Id 1328903',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 10:56:01','',''),(2269845,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 10:56:01','',''),(2269860,'1','144','828',360,'Retail Sale Id 1328910',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 10:57:28','',''),(2269861,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 10:57:28','',''),(2269882,'1','144','828',360,'Retail Sale Id 1328919',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 10:58:36','',''),(2269883,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 10:58:36','',''),(2269904,'1','144','828',360,'Retail Sale Id 1328928',6400.00,0.00,0.00,0.00,420.00,'2021-12-13 10:59:44','',''),(2269905,'1','144','828',360,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 10:59:44','',''),(2270524,'1','144','828',360,'Retail Sale Id 1329226',32000.00,0.00,0.00,0.00,2100.00,'2021-12-13 11:47:03','',''),(2270525,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 11:47:03','',''),(2270542,'1','144','828',360,'Retail Sale Id 1329233',30500.00,0.00,0.00,0.00,600.00,'2021-12-13 11:48:19','',''),(2270543,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 11:48:19','',''),(2270633,'1','144','828',360,'Retail Sale Id 1329276',16000.00,0.00,0.00,0.00,1050.00,'2021-12-13 11:57:44','',''),(2270634,'1','144','828',360,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-13 11:57:44','',''),(2270729,'1','144','828',360,'Retail Sale Id 1329328',7680.00,0.00,0.00,0.00,504.00,'2021-12-13 12:05:49','',''),(2270730,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-13 12:05:49','',''),(2270755,'1','144','828',360,'Retail Sale Id 1329345',8000.00,0.00,0.00,0.00,525.00,'2021-12-13 12:09:05','',''),(2270756,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:09:05','',''),(2270787,'1','144','828',360,'Retail Sale Id 1329366',8000.00,0.00,0.00,0.00,525.00,'2021-12-13 12:11:26','',''),(2270788,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:11:26','',''),(2270831,'1','144','828',360,'Retail Sale Id 1329389',8000.00,0.00,0.00,0.00,525.00,'2021-12-13 12:14:37','',''),(2270832,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:14:37','',''),(2270905,'1','144','828',360,'Retail Sale Id 1329433',8000.00,0.00,0.00,0.00,525.00,'2021-12-13 12:19:49','',''),(2270906,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:19:49','',''),(2270937,'1','144','828',360,'Retail Sale Id 1329446',8000.00,0.00,0.00,0.00,525.00,'2021-12-13 12:21:10','',''),(2270938,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:21:10','',''),(2270951,'1','144','828',360,'Retail Sale Id 1329453',5120.00,0.00,0.00,0.00,336.00,'2021-12-13 12:22:11','',''),(2270952,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-13 12:22:11','',''),(2271002,'1','144','828',360,'Retail Sale Id 1329480',5120.00,0.00,0.00,0.00,336.00,'2021-12-13 12:26:41','',''),(2271003,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-13 12:26:41','',''),(2271050,'1','144','828',360,'Retail Sale Id 1329510',8000.00,0.00,0.00,0.00,525.00,'2021-12-13 12:31:04','',''),(2271051,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:31:04','',''),(2271074,'1','144','828',360,'Retail Sale Id 1329530',3200.00,0.00,0.00,0.00,210.00,'2021-12-13 12:33:05','',''),(2271075,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 12:33:05','',''),(2271092,'1','144','828',360,'Retail Sale Id 1329539',3200.00,0.00,0.00,0.00,210.00,'2021-12-13 12:34:20','',''),(2271093,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 12:34:20','',''),(2271112,'1','144','828',360,'Retail Sale Id 1329550',3200.00,0.00,0.00,0.00,210.00,'2021-12-13 12:35:16','',''),(2271113,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 12:35:16','',''),(2271124,'1','144','828',360,'Retail Sale Id 1329555',3200.00,0.00,0.00,0.00,210.00,'2021-12-13 12:36:23','',''),(2271125,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 12:36:23','',''),(2271170,'1','144','828',360,'Retail Sale Id 1329583',95160.00,0.00,0.00,0.00,1872.00,'2021-12-13 12:39:49','',''),(2271171,'1','144','828',360,'Retail sales',0.00,0.00,0.00,156.00,0.00,'2021-12-13 12:39:49','',''),(2271215,'1','144','828',360,'Retail Sale Id 1329608',8000.00,0.00,0.00,0.00,525.00,'2021-12-13 12:42:33','',''),(2271216,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:42:33','',''),(2271231,'1','144','828',360,'Retail Sale Id 1329615',8000.00,0.00,0.00,0.00,525.00,'2021-12-13 12:43:52','',''),(2271232,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:43:52','',''),(2271247,'1','144','828',360,'Retail Sale Id 1329624',8000.00,0.00,0.00,0.00,525.00,'2021-12-13 12:44:43','',''),(2271248,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:44:43','',''),(2271283,'1','144','828',360,'Retail Sale Id 1329641',3200.00,0.00,0.00,0.00,210.00,'2021-12-13 12:47:00','',''),(2271284,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 12:47:00','',''),(2271309,'1','144','828',360,'Retail Sale Id 1329656',3200.00,0.00,0.00,0.00,210.00,'2021-12-13 12:49:13','',''),(2271310,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 12:49:13','',''),(2271328,'1','144','828',360,'Retail Sale Id 1329663',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 12:50:19','',''),(2271329,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 12:50:19','',''),(2271338,'1','144','828',360,'Retail Sale Id 1329670',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 12:51:20','',''),(2271339,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 12:51:20','',''),(2271366,'1','144','828',360,'Retail Sale Id 1329685',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 12:52:49','',''),(2271367,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 12:52:49','',''),(2271788,'1','144','828',360,'Retail Sale Id 1329884',2944.00,0.00,0.00,0.00,193.20,'2021-12-13 13:17:20','',''),(2271789,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.60,0.00,'2021-12-13 13:17:20','',''),(2271862,'1','144','828',360,'Retail Sale Id 1329914',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 13:21:47','',''),(2271863,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 13:21:47','',''),(2271919,'1','144','828',360,'Retail Sale Id 1329926',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 13:24:01','',''),(2271920,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 13:24:01','',''),(2271968,'1','144','828',360,'Retail Sale Id 1329940',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 13:25:49','',''),(2271969,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 13:25:49','',''),(2272010,'1','144','828',360,'Retail Sale Id 1329961',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 13:28:15','',''),(2272011,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 13:28:15','',''),(2272025,'1','144','828',360,'Retail Sale Id 1329969',4480.00,0.00,0.00,0.00,294.00,'2021-12-13 13:29:19','',''),(2272026,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-13 13:29:19','',''),(2272059,'1','144','828',360,'Retail Sale Id 1329981',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 13:31:20','',''),(2272060,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 13:31:20','',''),(2272078,'1','144','828',360,'Retail Sale Id 1329993',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 13:33:11','',''),(2272079,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 13:33:11','',''),(2272116,'1','144','828',360,'Retail Sale Id 1330008',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 13:34:34','',''),(2272117,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 13:34:34','',''),(2272160,'1','144','828',360,'Retail Sale Id 1330020',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 13:36:24','',''),(2272161,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 13:36:24','',''),(2272174,'1','144','828',360,'Retail Sale Id 1330025',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 13:37:27','',''),(2272175,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 13:37:27','',''),(2272216,'1','144','828',360,'Retail Sale Id 1330029',30500.00,0.00,0.00,0.00,600.00,'2021-12-13 13:40:37','',''),(2272217,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 13:40:37','',''),(2272238,'1','144','828',360,'Retail Sale Id 1330055',972.80,0.00,0.00,0.00,63.84,'2021-12-13 13:42:00','',''),(2272239,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-13 13:42:00','',''),(2272254,'1','144','828',360,'Retail Sale Id 1330063',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 13:43:33','',''),(2272255,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 13:43:33','',''),(2272270,'1','144','828',360,'Retail Sale Id 1330070',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 13:44:43','',''),(2272271,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 13:44:43','',''),(2272298,'1','144','828',360,'Retail Sale Id 1330082',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 13:45:54','',''),(2272299,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 13:45:54','',''),(2272307,'1','144','828',360,'Retail Sale Id 1330090',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 13:47:19','',''),(2272308,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 13:47:19','',''),(2272349,'1','144','828',360,'Retail Sale Id 1330100',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 13:48:47','',''),(2272350,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 13:48:47','',''),(2272392,'1','144','828',360,'Retail Sale Id 1330114',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 13:50:41','',''),(2272393,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 13:50:41','',''),(2272430,'1','144','828',360,'Retail Sale Id 1330132',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 13:52:13','',''),(2272431,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 13:52:13','',''),(2272450,'1','144','828',360,'Retail Sale Id 1330147',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 13:53:57','',''),(2272451,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 13:53:57','',''),(2272483,'1','144','828',360,'Retail Sale Id 1330155',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 13:54:52','',''),(2272484,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 13:54:52','',''),(2272501,'1','144','828',360,'Retail Sale Id 1330163',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 13:55:44','',''),(2272502,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 13:55:44','',''),(2272531,'1','144','828',360,'Retail Sale Id 1330175',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 13:56:40','',''),(2272532,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 13:56:40','',''),(2272546,'1','144','828',360,'Retail Sale Id 1330180',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 13:57:27','',''),(2272547,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 13:57:27','',''),(2272564,'1','144','828',360,'Retail Sale Id 1330191',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 13:58:47','',''),(2272565,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 13:58:47','',''),(2272588,'1','144','828',360,'Retail Sale Id 1330204',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 14:00:22','',''),(2272589,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:00:22','',''),(2272618,'1','144','828',360,'Retail Sale Id 1330219',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 14:02:26','',''),(2272619,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:02:26','',''),(2272628,'1','144','828',360,'Retail Sale Id 1330225',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 14:03:11','',''),(2272629,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:03:11','',''),(2272643,'1','144','828',360,'Retail Sale Id 1330228',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 14:03:56','',''),(2272644,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:03:56','',''),(2272662,'1','144','828',360,'Retail Sale Id 1330239',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 14:05:10','',''),(2272663,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:05:10','',''),(2272672,'1','144','828',360,'Retail Sale Id 1330243',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 14:06:31','',''),(2272673,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:06:31','',''),(2272684,'1','144','828',360,'Retail Sale Id 1330249',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 14:07:33','',''),(2272685,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:07:33','',''),(2272718,'1','144','828',360,'Retail Sale Id 1330264',2944.00,0.00,0.00,0.00,193.20,'2021-12-13 14:09:33','',''),(2272719,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.60,0.00,'2021-12-13 14:09:33','',''),(2272734,'1','144','828',360,'Retail Sale Id 1330269',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 14:10:35','',''),(2272735,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:10:35','',''),(2272754,'1','144','828',360,'Retail Sale Id 1330283',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 14:11:40','',''),(2272755,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:11:40','',''),(2272774,'1','144','828',360,'Retail Sale Id 1330295',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 14:12:32','',''),(2272775,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:12:32','',''),(2272796,'1','144','828',360,'Retail Sale Id 1330320',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 14:14:40','',''),(2272797,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:14:40','',''),(2272849,'1','144','828',360,'Retail Sale Id 1330407',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 14:16:28','',''),(2272850,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:16:28','',''),(2273172,'1','144','828',360,'Retail Sale Id 1330541',4480.00,0.00,0.00,0.00,294.00,'2021-12-13 14:35:01','',''),(2273173,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-13 14:35:01','',''),(2273453,'1','144','828',360,'Retail Sale Id 1330679',972.80,0.00,0.00,0.00,63.84,'2021-12-13 14:53:00','',''),(2273454,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-13 14:53:00','',''),(2273635,'1','144','828',360,'Retail Sale Id 1330785',972.80,0.00,0.00,0.00,63.84,'2021-12-13 15:06:56','',''),(2273636,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-13 15:06:56','',''),(2274121,'1','144','828',360,'Retail Sale Id 1330993',8000.00,0.00,0.00,0.00,525.00,'2021-12-13 15:30:40','',''),(2274122,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 15:30:40','',''),(2274194,'1','144','828',360,'Retail Sale Id 1331019',5760.00,0.00,0.00,0.00,378.00,'2021-12-13 15:32:58','',''),(2274195,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-13 15:32:58','',''),(2274208,'1','144','828',360,'Retail Sale Id 1331030',5120.00,0.00,0.00,0.00,336.00,'2021-12-13 15:33:46','',''),(2274209,'1','144','828',360,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-13 15:33:46','',''),(2274301,'1','144','828',360,'Retail Sale Id 1331070',6400.00,0.00,0.00,0.00,420.00,'2021-12-13 15:37:39','',''),(2274302,'1','144','828',360,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 15:37:39','',''),(2274411,'1','144','828',360,'Retail Sale Id 1331127',972.80,0.00,0.00,0.00,63.84,'2021-12-13 15:42:23','',''),(2274412,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-13 15:42:23','',''),(2274483,'1','144','828',360,'Retail Sale Id 1331166',4480.00,0.00,0.00,0.00,294.00,'2021-12-13 15:45:43','',''),(2274484,'1','144','828',360,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-13 15:45:43','',''),(2274579,'1','144','828',360,'Retail Sale Id 1331212',30500.00,0.00,0.00,0.00,600.00,'2021-12-13 15:50:53','',''),(2274580,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 15:50:53','',''),(2274754,'1','144','828',360,'Retail Sale Id 1331308',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 16:00:38','',''),(2274755,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 16:00:38','',''),(2274791,'1','144','828',360,'Retail Sale Id 1331329',8000.00,0.00,0.00,0.00,525.00,'2021-12-13 16:02:43','',''),(2274792,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:02:43','',''),(2274887,'1','144','828',360,'Retail Sale Id 1331375',8000.00,0.00,0.00,0.00,525.00,'2021-12-13 16:08:12','',''),(2274888,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:08:12','',''),(2274905,'1','144','828',360,'Retail Sale Id 1331383',3200.00,0.00,0.00,0.00,210.00,'2021-12-13 16:09:01','',''),(2274906,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 16:09:01','',''),(2274919,'1','144','828',360,'Retail Sale Id 1331393',3200.00,0.00,0.00,0.00,210.00,'2021-12-13 16:10:19','',''),(2274920,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 16:10:19','',''),(2274941,'1','144','828',360,'Retail Sale Id 1331403',3200.00,0.00,0.00,0.00,210.00,'2021-12-13 16:11:14','',''),(2274942,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 16:11:14','',''),(2274959,'1','144','828',360,'Retail Sale Id 1331410',3200.00,0.00,0.00,0.00,210.00,'2021-12-13 16:12:01','',''),(2274960,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 16:12:01','',''),(2274994,'1','144','828',360,'Retail Sale Id 1331431',8000.00,0.00,0.00,0.00,525.00,'2021-12-13 16:14:08','',''),(2274995,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:14:08','',''),(2275018,'1','144','828',360,'Retail Sale Id 1331441',5760.00,0.00,0.00,0.00,378.00,'2021-12-13 16:14:57','',''),(2275021,'1','144','828',360,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-13 16:14:57','',''),(2275072,'1','144','828',360,'Retail Sale Id 1331467',3200.00,0.00,0.00,0.00,210.00,'2021-12-13 16:17:43','',''),(2275073,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 16:17:43','',''),(2275113,'1','144','828',360,'Retail Sale Id 1331489',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 16:19:56','',''),(2275114,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 16:19:56','',''),(2275157,'1','144','828',360,'Retail Sale Id 1331507',8000.00,0.00,0.00,0.00,525.00,'2021-12-13 16:21:38','',''),(2275158,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:21:38','',''),(2275167,'1','144','828',360,'Retail Sale Id 1331514',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 16:22:24','',''),(2275168,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 16:22:24','',''),(2275194,'1','144','828',360,'Retail Sale Id 1331529',8000.00,0.00,0.00,0.00,525.00,'2021-12-13 16:23:31','',''),(2275195,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:23:31','',''),(2275303,'1','144','828',360,'Retail Sale Id 1331583',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 16:29:35','',''),(2275304,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 16:29:35','',''),(2275334,'1','144','828',360,'Retail Sale Id 1331599',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 16:31:38','',''),(2275335,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 16:31:38','',''),(2275366,'1','144','828',360,'Retail Sale Id 1331614',3200.00,0.00,0.00,0.00,210.00,'2021-12-13 16:33:27','',''),(2275367,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 16:33:27','',''),(2275387,'1','144','828',360,'Retail Sale Id 1331626',3200.00,0.00,0.00,0.00,210.00,'2021-12-13 16:34:30','',''),(2275388,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 16:34:30','',''),(2275407,'1','144','828',360,'Retail Sale Id 1331637',8000.00,0.00,0.00,0.00,525.00,'2021-12-13 16:35:41','',''),(2275408,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:35:41','',''),(2275427,'1','144','828',360,'Retail Sale Id 1331647',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 16:36:38','',''),(2275428,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 16:36:38','',''),(2275435,'1','144','828',360,'Retail Sale Id 1331652',1280.00,0.00,0.00,0.00,84.00,'2021-12-13 16:37:15','',''),(2275436,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 16:37:15','',''),(2275453,'1','144','828',360,'Retail Sale Id 1331662',16000.00,0.00,0.00,0.00,1050.00,'2021-12-13 16:38:15','',''),(2275454,'1','144','828',360,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-13 16:38:15','',''),(2275472,'1','144','828',360,'Retail Sale Id 1331672',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 16:39:40','',''),(2275473,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 16:39:40','',''),(2275520,'1','144','828',360,'Retail Sale Id 1331698',2560.00,0.00,0.00,0.00,168.00,'2021-12-13 16:42:23','',''),(2275521,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 16:42:23','',''),(2275548,'1','144','828',360,'Retail Sale Id 1331713',8000.00,0.00,0.00,0.00,525.00,'2021-12-13 16:43:49','',''),(2275549,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:43:49','',''),(2276376,'1','144','828',360,'Retail Sale Id 1332061',8000.00,0.00,0.00,0.00,525.00,'2021-12-13 18:23:59','',''),(2276377,'1','144','828',360,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 18:23:59','',''),(2276378,'1','144','828',360,'Retail Sale Id 1332062',3840.00,0.00,0.00,0.00,252.00,'2021-12-13 18:24:55','',''),(2276379,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 18:24:55','',''),(2276383,'1','144','828',360,'Retail Sale Id 1332063',3200.00,0.00,0.00,0.00,210.00,'2021-12-13 18:25:59','',''),(2276384,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 18:25:59','',''),(2276387,'1','144','828',360,'Retail Sale Id 1332064',1920.00,0.00,0.00,0.00,126.00,'2021-12-13 18:26:52','',''),(2276388,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 18:26:52','',''),(2276411,'1','144','828',360,'Retail Sale Id 1332065',2560.00,0.00,0.00,0.00,168.00,'2021-12-13 18:29:14','',''),(2276412,'1','144','828',360,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 18:29:14','',''),(2276413,'1','144','828',360,'Retail Sale Id 1332066',1280.00,0.00,0.00,0.00,84.00,'2021-12-13 18:30:06','',''),(2276414,'1','144','828',360,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 18:30:06','',''),(2276420,'1','144','828',360,'Retail Sale Id 1332069',184614.40,0.00,0.00,0.00,12115.32,'2021-12-13 18:31:41','',''),(2276421,'1','144','828',360,'Retail sales',0.00,0.00,0.00,288.46,0.00,'2021-12-13 18:31:41','',''),(2276422,'1','144','828',360,'Retail Sale Id 1332070',1121100.00,0.00,0.00,0.00,14800.00,'2021-12-13 18:32:50','',''),(2276423,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1850.00,0.00,'2021-12-13 18:32:50','',''),(2276426,'1','144',NULL,360,'Reception corrector for bridging 127274',0.00,0.00,0.00,5000.00,0.00,'2021-12-13 18:35:41','',''),(2276427,'1','144','828',360,'Received from bridging 127274',0.00,0.00,5000.00,0.00,0.00,'2021-12-13 18:35:41','',''),(2276431,'1','144','828',360,'Retail Sale Id 1332072',636300.00,0.00,0.00,0.00,8400.00,'2021-12-13 18:36:28','',''),(2276432,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1050.00,0.00,'2021-12-13 18:36:28','',''),(2278398,'1','144','828',360,'Retail Sale Id 1332786',12196.80,0.00,0.00,0.00,356.40,'2021-12-14 07:41:14','',''),(2278399,'1','144','828',360,'Retail sales',0.00,0.00,0.00,19.80,0.00,'2021-12-14 07:41:14','',''),(2278598,'1','144','828',360,'Retail Sale Id 1333002',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 07:54:17','',''),(2278599,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 07:54:17','',''),(2278614,'1','144','828',360,'Retail Sale Id 1333012',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 07:55:16','',''),(2278615,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 07:55:16','',''),(2278638,'1','144','828',360,'Retail Sale Id 1333021',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 07:56:27','',''),(2278639,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 07:56:27','',''),(2278668,'1','144','828',360,'Retail Sale Id 1333038',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 07:58:00','',''),(2278669,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 07:58:00','',''),(2278754,'1','144','828',360,'Retail Sale Id 1333083',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 08:02:08','',''),(2278755,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 08:02:08','',''),(2278800,'1','144','828',360,'Retail Sale Id 1333094',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 08:03:08','',''),(2278801,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 08:03:08','',''),(2278824,'1','144','828',360,'Retail Sale Id 1333106',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 08:04:16','',''),(2278825,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 08:04:16','',''),(2278838,'1','144','828',360,'Retail Sale Id 1333112',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 08:05:27','',''),(2278839,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 08:05:27','',''),(2278850,'1','144','828',360,'Retail Sale Id 1333118',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 08:06:16','',''),(2278851,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 08:06:16','',''),(2278866,'1','144','828',360,'Retail Sale Id 1333127',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 08:07:19','',''),(2278867,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 08:07:19','',''),(2279047,'1','144','828',360,'Retail Sale Id 1333218',985.60,0.00,0.00,0.00,28.80,'2021-12-14 08:16:24','',''),(2279048,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-14 08:16:24','',''),(2279131,'1','144','828',360,'Retail Sale Id 1333279',985.60,0.00,0.00,0.00,28.80,'2021-12-14 08:21:24','',''),(2279132,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-14 08:21:24','',''),(2279540,'1','144','828',360,'Retail Sale Id 1333497',985.60,0.00,0.00,0.00,28.80,'2021-12-14 08:43:59','',''),(2279541,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-14 08:43:59','',''),(2279780,'1','144','828',360,'Retail Sale Id 1333601',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 08:55:46','',''),(2279781,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 08:55:46','',''),(2279802,'1','144','828',360,'Retail Sale Id 1333610',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 08:56:40','',''),(2279803,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 08:56:40','',''),(2279827,'1','144','828',360,'Retail Sale Id 1333619',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 08:57:43','',''),(2279828,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 08:57:43','',''),(2280039,'1','144','828',360,'Retail Sale Id 1333718',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 09:06:58','',''),(2280040,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 09:06:58','',''),(2280088,'1','144','828',360,'Retail Sale Id 1333730',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 09:08:47','',''),(2280089,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 09:08:47','',''),(2280129,'1','144','828',360,'Retail Sale Id 1333747',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 09:10:14','',''),(2280130,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 09:10:14','',''),(2280169,'1','144','828',360,'Retail Sale Id 1333768',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 09:12:37','',''),(2280172,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 09:12:37','',''),(2280199,'1','144','828',360,'Retail Sale Id 1333780',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 09:14:01','',''),(2280200,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 09:14:01','',''),(2280221,'1','144','828',360,'Retail Sale Id 1333791',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 09:14:59','',''),(2280222,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 09:14:59','',''),(2280246,'1','144','828',360,'Retail Sale Id 1333797',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 09:16:12','',''),(2280247,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 09:16:12','',''),(2280285,'1','144','828',360,'Retail Sale Id 1333812',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 09:17:43','',''),(2280286,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 09:17:43','',''),(2280313,'1','144','828',360,'Retail Sale Id 1333825',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 09:19:46','',''),(2280314,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 09:19:46','',''),(2280331,'1','144','828',360,'Retail Sale Id 1333834',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 09:20:59','',''),(2280332,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 09:20:59','',''),(2280362,'1','144','828',360,'Retail Sale Id 1333846',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 09:21:51','',''),(2280363,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 09:21:51','',''),(2280528,'1','144','828',360,'Retail Sale Id 1333916',862.40,0.00,0.00,0.00,25.20,'2021-12-14 09:29:56','',''),(2280529,'1','144','828',360,'Retail sales',0.00,0.00,0.00,1.40,0.00,'2021-12-14 09:29:56','',''),(2281027,'1','144','828',360,'Retail Sale Id 1334177',3080.00,0.00,0.00,0.00,90.00,'2021-12-14 10:00:23','',''),(2281028,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 10:00:23','',''),(2281067,'1','144','828',360,'Retail Sale Id 1334193',58000.00,0.00,0.00,0.00,-1800.00,'2021-12-14 10:02:10','',''),(2281068,'1','144','828',360,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-14 10:02:10','',''),(2281086,'1','144','828',360,'Retail Sale Id 1334207',3080.00,0.00,0.00,0.00,90.00,'2021-12-14 10:03:28','',''),(2281087,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 10:03:28','',''),(2281125,'1','144','828',360,'Retail Sale Id 1334229',6776.00,0.00,0.00,0.00,198.00,'2021-12-14 10:06:12','',''),(2281126,'1','144','828',360,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-14 10:06:12','',''),(2281220,'1','144','828',360,'Retail Sale Id 1334246',3696.00,0.00,0.00,0.00,108.00,'2021-12-14 10:11:13','',''),(2281221,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 10:11:13','',''),(2281267,'1','144','828',360,'Retail Sale Id 1334299',3696.00,0.00,0.00,0.00,108.00,'2021-12-14 10:13:34','',''),(2281268,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 10:13:34','',''),(2281309,'1','144','828',360,'Retail Sale Id 1334320',3696.00,0.00,0.00,0.00,108.00,'2021-12-14 10:15:33','',''),(2281310,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 10:15:33','',''),(2281340,'1','144','828',360,'Retail Sale Id 1334339',6776.00,0.00,0.00,0.00,198.00,'2021-12-14 10:16:54','',''),(2281341,'1','144','828',360,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-14 10:16:54','',''),(2281430,'1','144','828',360,'Retail Sale Id 1334373',3696.00,0.00,0.00,0.00,108.00,'2021-12-14 10:20:04','',''),(2281431,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 10:20:04','',''),(2281460,'1','144','828',360,'Retail Sale Id 1334385',3696.00,0.00,0.00,0.00,108.00,'2021-12-14 10:21:16','',''),(2281461,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 10:21:16','',''),(2281479,'1','144','828',360,'Retail Sale Id 1334396',3696.00,0.00,0.00,0.00,108.00,'2021-12-14 10:22:11','',''),(2281480,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 10:22:11','',''),(2281505,'1','144','828',360,'Retail Sale Id 1334407',3696.00,0.00,0.00,0.00,108.00,'2021-12-14 10:23:25','',''),(2281506,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 10:23:25','',''),(2281549,'1','144','828',360,'Retail Sale Id 1334430',3696.00,0.00,0.00,0.00,108.00,'2021-12-14 10:25:58','',''),(2281550,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 10:25:58','',''),(2281572,'1','144','828',360,'Retail Sale Id 1334442',3696.00,0.00,0.00,0.00,108.00,'2021-12-14 10:27:41','',''),(2281573,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 10:27:41','',''),(2281610,'1','144','828',360,'Retail Sale Id 1334475',3696.00,0.00,0.00,0.00,108.00,'2021-12-14 10:29:59','',''),(2281611,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 10:29:59','',''),(2281636,'1','144','828',360,'Retail Sale Id 1334528',3696.00,0.00,0.00,0.00,108.00,'2021-12-14 10:31:46','',''),(2281637,'1','144','828',360,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 10:31:46','',''),(2281700,'1','144','828',360,'Retail Sale Id 1334565',3080.00,0.00,0.00,0.00,90.00,'2021-12-14 10:34:50','',''),(2281701,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 10:34:50','',''),(2281750,'1','144','828',360,'Retail Sale Id 1334586',3080.00,0.00,0.00,0.00,90.00,'2021-12-14 10:37:15','',''),(2281751,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 10:37:15','',''),(2281772,'1','144','828',360,'Retail Sale Id 1334605',3080.00,0.00,0.00,0.00,90.00,'2021-12-14 10:38:51','',''),(2281773,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 10:38:51','',''),(2281797,'1','144','828',360,'Retail Sale Id 1334617',3080.00,0.00,0.00,0.00,90.00,'2021-12-14 10:40:12','',''),(2281798,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 10:40:12','',''),(2281812,'1','144','828',360,'Retail Sale Id 1334624',3080.00,0.00,0.00,0.00,90.00,'2021-12-14 10:41:04','',''),(2281813,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 10:41:04','',''),(2281838,'1','144','828',360,'Retail Sale Id 1334637',3080.00,0.00,0.00,0.00,90.00,'2021-12-14 10:42:13','',''),(2281839,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 10:42:13','',''),(2281850,'1','144','828',360,'Retail Sale Id 1334648',3080.00,0.00,0.00,0.00,90.00,'2021-12-14 10:43:12','',''),(2281851,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 10:43:12','',''),(2281892,'1','144','828',360,'Retail Sale Id 1334663',3080.00,0.00,0.00,0.00,90.00,'2021-12-14 10:44:34','',''),(2281893,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 10:44:34','',''),(2281905,'1','144','828',360,'Retail Sale Id 1334670',3080.00,0.00,0.00,0.00,90.00,'2021-12-14 10:45:29','',''),(2281906,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 10:45:29','',''),(2281935,'1','144','828',360,'Retail Sale Id 1334687',30800.00,0.00,0.00,0.00,900.00,'2021-12-14 10:48:01','',''),(2281936,'1','144','828',360,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-14 10:48:01','',''),(2281971,'1','144','828',360,'Retail Sale Id 1334705',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 10:50:04','',''),(2281972,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 10:50:04','',''),(2282006,'1','144','828',360,'Retail Sale Id 1334724',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 10:52:08','',''),(2282007,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 10:52:08','',''),(2282026,'1','144','828',360,'Retail Sale Id 1334735',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 10:53:37','',''),(2282027,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 10:53:37','',''),(2282066,'1','144','828',360,'Retail Sale Id 1334750',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 10:55:52','',''),(2282067,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 10:55:52','',''),(2282115,'1','144','828',360,'Retail Sale Id 1334794',3080.00,0.00,0.00,0.00,90.00,'2021-12-14 10:59:42','',''),(2282116,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 10:59:42','',''),(2282152,'1','144','828',360,'Retail Sale Id 1334808',3080.00,0.00,0.00,0.00,90.00,'2021-12-14 11:02:16','',''),(2282153,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 11:02:16','',''),(2282210,'1','144','828',360,'Retail Sale Id 1334832',3080.00,0.00,0.00,0.00,90.00,'2021-12-14 11:04:46','',''),(2282211,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 11:04:46','',''),(2282228,'1','144','828',360,'Retail Sale Id 1334843',3080.00,0.00,0.00,0.00,90.00,'2021-12-14 11:06:06','',''),(2282229,'1','144','828',360,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 11:06:06','',''),(2282294,'1','144','828',360,'Retail Sale Id 1334876',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 11:10:02','',''),(2282295,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 11:10:02','',''),(2282328,'1','144','828',360,'Retail Sale Id 1334894',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 11:11:41','',''),(2282329,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 11:11:41','',''),(2282345,'1','144','828',360,'Retail Sale Id 1334902',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 11:12:40','',''),(2282346,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 11:12:40','',''),(2282385,'1','144','828',360,'Retail Sale Id 1334922',1848.00,0.00,0.00,0.00,54.00,'2021-12-14 11:14:50','',''),(2282386,'1','144','828',360,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 11:14:50','',''),(2282444,'1','144','828',360,'Retail Sale Id 1335321',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 12:16:44','',''),(2282448,'1','144','828',360,'Retail Sale Id 1335326',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 12:18:24','',''),(2282456,'1','144','828',360,'Retail Sale Id 1335335',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 12:20:51','',''),(2282458,'1','144','828',360,'Retail Sale Id 1335338',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 12:21:51','',''),(2282464,'1','144','828',360,'Retail Sale Id 1335346',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 12:22:44','',''),(2282470,'1','144','828',360,'Retail Sale Id 1335352',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 12:24:41','',''),(2282474,'1','144','828',360,'Retail Sale Id 1335356',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 12:26:15','',''),(2282476,'1','144','828',360,'Retail Sale Id 1335359',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 12:26:54','',''),(2282479,'1','144','828',360,'Retail Sale Id 1335364',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 12:27:53','',''),(2282487,'1','144','828',360,'Retail Sale Id 1335372',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 12:29:13','',''),(2282489,'1','144','828',360,'Retail Sale Id 1335375',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 12:30:01','',''),(2282496,'1','144','828',360,'Retail Sale Id 1335385',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 12:31:11','',''),(2282514,'1','144','828',360,'Retail Sale Id 1335401',9301.60,0.00,0.00,15.10,271.80,'2021-12-14 12:33:56','',''),(2282521,'1','144','828',360,'Retail Sale Id 1335416',29000.00,0.00,0.00,50.00,-900.00,'2021-12-14 12:35:16','',''),(2282547,'1','144','828',360,'Retail Sale Id 1335426',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 12:36:37','',''),(2282560,'1','144','828',360,'Retail Sale Id 1335440',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 12:38:16','',''),(2282570,'1','144','828',360,'Retail Sale Id 1335453',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 12:39:32','',''),(2282574,'1','144','828',360,'Retail Sale Id 1335457',30800.00,0.00,0.00,50.00,900.00,'2021-12-14 12:40:35','',''),(2282617,'1','144','828',360,'Retail Sale Id 1335490',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 12:45:18','',''),(2282637,'1','144','828',360,'Retail Sale Id 1335502',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 12:46:59','',''),(2282647,'1','144','828',360,'Retail Sale Id 1335513',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 12:48:52','',''),(2282669,'1','144','828',360,'Retail Sale Id 1335521',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 12:50:07','',''),(2282680,'1','144','828',360,'Retail Sale Id 1335532',30800.00,0.00,0.00,50.00,900.00,'2021-12-14 12:51:40','',''),(2282683,'1','144','828',360,'Retail Sale Id 1335539',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 12:52:54','',''),(2282694,'1','144','828',360,'Retail Sale Id 1335549',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 12:54:25','',''),(2282699,'1','144','828',360,'Retail Sale Id 1335558',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 12:55:29','',''),(2282708,'1','144','828',360,'Retail Sale Id 1335564',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 12:56:42','',''),(2282727,'1','144','828',360,'Retail Sale Id 1335571',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 12:58:18','',''),(2282733,'1','144','828',360,'Retail Sale Id 1335577',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 12:59:19','',''),(2282742,'1','144','828',360,'Retail Sale Id 1335588',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 13:00:23','',''),(2282748,'1','144','828',360,'Retail Sale Id 1335594',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 13:01:15','',''),(2282762,'1','144','828',360,'Retail Sale Id 1335608',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 13:03:27','',''),(2282769,'1','144','828',360,'Retail Sale Id 1335615',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 13:04:30','',''),(2282777,'1','144','828',360,'Retail Sale Id 1335624',7700.00,0.00,0.00,12.50,225.00,'2021-12-14 13:05:36','',''),(2282797,'1','144','828',360,'Retail Sale Id 1335639',7700.00,0.00,0.00,12.50,225.00,'2021-12-14 13:07:14','',''),(2282807,'1','144','828',360,'Retail Sale Id 1335649',7700.00,0.00,0.00,12.50,225.00,'2021-12-14 13:08:45','',''),(2282814,'1','144','828',360,'Retail Sale Id 1335655',7700.00,0.00,0.00,12.50,225.00,'2021-12-14 13:10:28','',''),(2282859,'1','144','828',360,'Retail Sale Id 1335703',7700.00,0.00,0.00,12.50,225.00,'2021-12-14 13:17:14','',''),(2282871,'1','144','828',360,'Retail Sale Id 1335714',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 13:18:57','',''),(2282881,'1','144','828',360,'Retail Sale Id 1335727',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 13:21:03','',''),(2282922,'1','144','828',360,'Retail Sale Id 1335740',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 13:24:09','',''),(2282935,'1','144','828',360,'Retail Sale Id 1335764',29000.00,0.00,0.00,50.00,-900.00,'2021-12-14 13:25:36','',''),(2282946,'1','144','828',360,'Retail Sale Id 1335772',7392.00,0.00,0.00,12.00,216.00,'2021-12-14 13:26:54','',''),(2282980,'1','144','828',360,'Retail Sale Id 1335794',15400.00,0.00,0.00,25.00,450.00,'2021-12-14 13:31:07','',''),(2283005,'1','144','828',360,'Retail Sale Id 1335812',7700.00,0.00,0.00,12.50,225.00,'2021-12-14 13:34:02','',''),(2283011,'1','144','828',360,'Retail Sale Id 1335822',7700.00,0.00,0.00,12.50,225.00,'2021-12-14 13:35:04','',''),(2283126,'1','144','828',360,'Retail Sale Id 1335890',29000.00,0.00,0.00,50.00,-900.00,'2021-12-14 13:46:47','',''),(2283279,'1','144','828',360,'Retail Sale Id 1335975',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 14:03:00','',''),(2283288,'1','144','828',360,'Retail Sale Id 1336001',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 14:04:02','',''),(2283294,'1','144','828',360,'Retail Sale Id 1336007',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 14:05:19','',''),(2283360,'1','144','828',360,'Retail Sale Id 1336025',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 14:08:14','',''),(2283406,'1','144','828',360,'Retail Sale Id 1336066',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 14:14:27','',''),(2283417,'1','144','828',360,'Retail Sale Id 1336076',3942.40,0.00,0.00,6.40,115.20,'2021-12-14 14:15:34','',''),(2283426,'1','144','828',360,'Retail Sale Id 1336090',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 14:16:50','',''),(2283431,'1','144','828',360,'Retail Sale Id 1336096',3942.40,0.00,0.00,6.40,115.20,'2021-12-14 14:17:39','',''),(2283451,'1','144','828',360,'Retail Sale Id 1336109',7700.00,0.00,0.00,12.50,225.00,'2021-12-14 14:19:13','',''),(2283480,'1','144','828',360,'Retail Sale Id 1336131',7700.00,0.00,0.00,12.50,225.00,'2021-12-14 14:22:32','',''),(2283503,'1','144','828',360,'Retail Sale Id 1336150',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 14:25:42','',''),(2283513,'1','144','828',360,'Retail Sale Id 1336165',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 14:26:56','',''),(2283520,'1','144','828',360,'Retail Sale Id 1336172',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 14:27:39','',''),(2283542,'1','144','828',360,'Retail Sale Id 1336188',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 14:29:46','',''),(2283584,'1','144','828',360,'Retail Sale Id 1336204',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 14:32:15','',''),(2283602,'1','144','828',360,'Retail Sale Id 1336213',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 14:33:10','',''),(2283610,'1','144','828',360,'Retail Sale Id 1336220',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 14:34:43','',''),(2283626,'1','144','828',360,'Retail Sale Id 1336234',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 14:37:15','',''),(2283636,'1','144','828',360,'Retail Sale Id 1336243',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 14:38:16','',''),(2283669,'1','144','828',360,'Retail Sale Id 1336272',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 14:43:33','',''),(2283679,'1','144','828',360,'Retail Sale Id 1336279',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 14:44:21','',''),(2283700,'1','144','828',360,'Retail Sale Id 1336291',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 14:46:06','',''),(2283834,'1','144','828',360,'Retail Sale Id 1336393',145000.00,0.00,0.00,250.00,-4500.00,'2021-12-14 15:02:57','',''),(2283863,'1','144','828',360,'Retail Sale Id 1336427',7700.00,0.00,0.00,12.50,225.00,'2021-12-14 15:08:40','',''),(2283871,'1','144','828',360,'Retail Sale Id 1336436',7700.00,0.00,0.00,12.50,225.00,'2021-12-14 15:10:55','',''),(2283887,'1','144','828',360,'Retail Sale Id 1336451',7700.00,0.00,0.00,12.50,225.00,'2021-12-14 15:13:39','',''),(2283898,'1','144','828',360,'Retail Sale Id 1336462',7700.00,0.00,0.00,12.50,225.00,'2021-12-14 15:14:41','',''),(2283904,'1','144','828',360,'Retail Sale Id 1336467',3080.00,0.00,0.00,5.00,90.00,'2021-12-14 15:16:10','',''),(2283906,'1','144','828',360,'Retail Sale Id 1336470',3080.00,0.00,0.00,5.00,90.00,'2021-12-14 15:16:56','',''),(2283915,'1','144','828',360,'Retail Sale Id 1336477',3080.00,0.00,0.00,5.00,90.00,'2021-12-14 15:18:17','',''),(2284082,'1','144','828',360,'Retail Sale Id 1336598',985.60,0.00,0.00,1.60,28.80,'2021-12-14 15:36:32','',''),(2284335,'1','144','828',360,'Retail Sale Id 1336754',985.60,0.00,0.00,1.60,28.80,'2021-12-14 15:56:43','',''),(2284363,'1','144','828',360,'Retail Sale Id 1336770',3942.40,0.00,0.00,6.40,115.20,'2021-12-14 15:58:33','',''),(2284430,'1','144','828',360,'Retail Sale Id 1336819',116000.00,0.00,0.00,200.00,-3600.00,'2021-12-14 16:04:03','',''),(2284445,'1','144','828',360,'Retail Sale Id 1336837',2956.80,0.00,0.00,4.80,86.40,'2021-12-14 16:05:59','',''),(2284522,'1','144','828',360,'Retail Sale Id 1336912',1232.00,0.00,0.00,2.00,36.00,'2021-12-14 16:14:45','',''),(2284534,'1','144','828',360,'Retail Sale Id 1336929',1232.00,0.00,0.00,2.00,36.00,'2021-12-14 16:16:30','',''),(2284547,'1','144','828',360,'Retail Sale Id 1336941',7700.00,0.00,0.00,12.50,225.00,'2021-12-14 16:18:06','',''),(2284557,'1','144','828',360,'Retail Sale Id 1336951',1232.00,0.00,0.00,2.00,36.00,'2021-12-14 16:19:11','',''),(2284588,'1','144','828',360,'Retail Sale Id 1336982',1232.00,0.00,0.00,2.00,36.00,'2021-12-14 16:23:07','',''),(2284642,'1','144','828',360,'Retail Sale Id 1337024',3080.00,0.00,0.00,5.00,90.00,'2021-12-14 16:26:28','',''),(2284656,'1','144','828',360,'Retail Sale Id 1337035',3080.00,0.00,0.00,5.00,90.00,'2021-12-14 16:27:22','',''),(2284747,'1','144','828',360,'Retail Sale Id 1337113',7700.00,0.00,0.00,12.50,225.00,'2021-12-14 16:34:44','',''),(2284761,'1','144','828',360,'Retail Sale Id 1337129',7700.00,0.00,0.00,12.50,225.00,'2021-12-14 16:35:48','',''),(2284792,'1','144','828',360,'Retail Sale Id 1337144',1694.00,0.00,0.00,2.75,49.50,'2021-12-14 16:37:41','',''),(2284804,'1','144','828',360,'Retail Sale Id 1337155',3080.00,0.00,0.00,5.00,90.00,'2021-12-14 16:38:55','',''),(2284815,'1','144','828',360,'Retail Sale Id 1337166',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 16:40:18','',''),(2284826,'1','144','828',360,'Retail Sale Id 1337177',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 16:41:50','',''),(2285309,'1','144','828',360,'Retail Sale Id 1337575',7700.00,0.00,0.00,12.50,225.00,'2021-12-14 18:11:27','',''),(2285311,'1','144','828',360,'Retail Sale Id 1337577',3696.00,0.00,0.00,6.00,108.00,'2021-12-14 18:12:16','',''),(2285312,'1','144','828',360,'Retail Sale Id 1337578',3080.00,0.00,0.00,5.00,90.00,'2021-12-14 18:13:17','',''),(2285314,'1','144','828',360,'Retail Sale Id 1337579',1848.00,0.00,0.00,3.00,54.00,'2021-12-14 18:15:26','',''),(2285317,'1','144','828',360,'Retail Sale Id 1337582',1232.00,0.00,0.00,2.00,36.00,'2021-12-14 18:16:31','',''),(2285318,'1','144','828',360,'Retail Sale Id 1337584',2464.00,0.00,0.00,4.00,72.00,'2021-12-14 18:17:27','',''),(2285320,'1','144','828',360,'Retail Sale Id 1337586',6160.00,0.00,0.00,10.00,180.00,'2021-12-14 18:18:25','',''),(2285323,'1','144','828',360,'Retail Sale Id 1337589',350842.80,0.00,0.00,569.55,10251.90,'2021-12-14 18:20:30','',''),(2285327,'1','144','828',360,'Retail Sale Id 1337591',996480.00,0.00,0.00,1730.00,-38060.00,'2021-12-14 18:22:05','',''),(2285348,'1','144','828',360,'Distributed to OPERATIONAL LOSS for sales id:339683',240276.40,0.00,0.00,401.80,0.00,'2021-12-14 18:41:43','',''),(2285351,'1','144',NULL,360,'Purchased from A.A RANO NIGERIA LIMITED',0.00,14112000.00,25200.00,0.00,0.00,'2021-12-14 18:46:57','',''),(2285353,'1','144',NULL,360,'Reception corrector for bridging 127401',0.00,0.00,0.00,20000.00,0.00,'2021-12-14 18:50:36','',''),(2285354,'1','144','828',360,'Received from bridging 127401',0.00,0.00,20000.00,0.00,0.00,'2021-12-14 18:50:36','',''),(2285769,'1','144','828',360,'Retail Sale Id 1337655',3696.00,0.00,0.00,6.00,336.00,'2021-12-15 05:46:37','',''),(2285772,'1','144','828',360,'Retail Sale Id 1337658',3696.00,0.00,0.00,6.00,336.00,'2021-12-15 05:48:54','',''),(2285773,'1','144','828',360,'Retail Sale Id 1337659',3696.00,0.00,0.00,6.00,336.00,'2021-12-15 05:50:01','',''),(2285775,'1','144','828',360,'Retail Sale Id 1337662',3696.00,0.00,0.00,6.00,336.00,'2021-12-15 05:51:00','',''),(2285777,'1','144','828',360,'Retail Sale Id 1337664',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 05:51:58','',''),(2285793,'1','144','828',360,'Retail Sale Id 1337668',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 05:57:25','',''),(2285795,'1','144','828',360,'Retail Sale Id 1337671',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 05:58:12','',''),(2286062,'1','144','828',360,'Retail Sale Id 1337765',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 06:25:55','',''),(2286067,'1','144','828',360,'Retail Sale Id 1337769',3696.00,0.00,0.00,6.00,336.00,'2021-12-15 06:27:04','',''),(2286074,'1','144','828',360,'Retail Sale Id 1337776',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 06:28:01','',''),(2286200,'1','144','828',360,'Retail Sale Id 1337868',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 06:44:31','',''),(2286225,'1','144','828',360,'Retail Sale Id 1337888',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 06:46:35','',''),(2286238,'1','144','828',360,'Retail Sale Id 1337892',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 06:48:56','',''),(2286241,'1','144','828',360,'Retail Sale Id 1337907',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 06:49:54','',''),(2286280,'1','144','828',360,'Retail Sale Id 1337953',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 06:56:55','',''),(2286321,'1','144','828',360,'Retail Sale Id 1337977',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 07:00:50','',''),(2286337,'1','144','828',360,'Retail Sale Id 1337992',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 07:03:03','',''),(2286393,'1','144','828',360,'Retail Sale Id 1338044',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 07:07:30','',''),(2286406,'1','144','828',360,'Retail Sale Id 1338055',985.60,0.00,0.00,1.60,89.60,'2021-12-15 07:08:37','',''),(2286416,'1','144','828',360,'Retail Sale Id 1338072',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 07:10:03','',''),(2286426,'1','144','828',360,'Retail Sale Id 1338082',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 07:11:17','',''),(2286449,'1','144','828',360,'Retail Sale Id 1338110',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 07:15:42','',''),(2286466,'1','144','828',360,'Retail Sale Id 1338133',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 07:18:06','',''),(2286481,'1','144','828',360,'Retail Sale Id 1338146',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 07:19:41','',''),(2286512,'1','144','828',360,'Retail Sale Id 1338155',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 07:24:47','',''),(2286516,'1','144','828',360,'Retail Sale Id 1338186',145000.00,0.00,0.00,250.00,5000.00,'2021-12-15 07:25:47','',''),(2286617,'1','144','828',360,'Retail Sale Id 1338265',29000.00,0.00,0.00,50.00,1000.00,'2021-12-15 07:34:51','',''),(2286632,'1','144','828',360,'Retail Sale Id 1338282',3942.40,0.00,0.00,6.40,358.40,'2021-12-15 07:35:56','',''),(2286688,'1','144','828',360,'Retail Sale Id 1338338',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 07:42:27','',''),(2286696,'1','144','828',360,'Retail Sale Id 1338348',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 07:43:21','',''),(2286701,'1','144','828',360,'Retail Sale Id 1338351',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 07:44:03','',''),(2286709,'1','144','828',360,'Retail Sale Id 1338353',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 07:44:45','',''),(2286735,'1','144','828',360,'Retail Sale Id 1338369',1848.00,0.00,0.00,3.00,168.00,'2021-12-15 07:46:58','',''),(2286744,'1','144','828',360