-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_143
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_143`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_143` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_143`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3209 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2904,400321,'',0,'2','1','143','DANKANO-EBILLS(ZNB:1014717618)','','2020-10-29 13:38:21',5,0.00,0.00,'','489','2020-10-29 13:38:21','489',0,1),(3070,20041,'',0,'22','1','143','PURCHASES','','2020-12-23 13:00:40',5,0.00,0.00,'2020-12-23','479','2020-12-23 13:06:57','479',0,1),(3071,20041,'',0,'20','1','143','SALES','','2020-12-23 13:07:52',5,0.00,0.00,'','479','2020-12-23 13:07:52','479',0,1),(3072,40041,'',0,'6.1','1','143','CASH','','2020-12-23 13:08:20',5,0.00,0.00,'','479','2020-12-23 13:08:20','479',0,1),(3073,400255,'',0,'24','1','143','SALARIES & WAGES','','2020-12-23 13:09:05',5,0.00,0.00,'','479','2020-12-23 13:09:05','479',0,1),(3074,400256,'',0,'24','1','143','PURCHASES','','2020-12-23 13:09:23',5,0.00,0.00,'','479','2020-12-23 13:09:23','479',0,1),(3206,400485,'',0,'2','1','143','FID POS COLLECTION-5620141491','','2021-02-26 16:00:17',5,0.00,0.00,'','489','2021-02-26 16:00:17','489',0,1),(3207,400486,'',0,'2','1','143','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:33:05',5,0.00,0.00,'','792','2023-02-20 14:33:05','792',0,0),(3208,400487,'',0,'2','1','143','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:36:40',5,0.00,0.00,'2023-03-15','792','2023-03-17 13:51:41','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4084 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1752,'','1','143','OPERATIONAL LOSS','HAFIZ NURA','08069129774','hafiz@aaranonigeria.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-10-29 13:37:58',5,'489','2020-10-29 13:37:58','489'),(1931,'','1','143','ALL DEALERS','SHAMSUDDEEN ALIYU','09061349661','shamsuddeenaliyu202@gmail.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-12-24 11:52:47',5,'563','2020-12-24 11:52:47','563'),(2067,'','1','143','DEALER','SOKOTO','080000000','shamsuddeenaliyu202@gmail.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-19 14:12:30',5,'563','2021-02-19 14:12:30','563'),(2565,'','1','143','COLLINS GAS','SOKOTO','08034472201','ginigas@yahoo.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-15 14:23:58',5,'563','2021-04-15 14:23:58','563'),(2577,'','1','143','DOGON YARO GAS','KEBBI','08169209494','joshchonoko@gmail.com','BIRNIN KEBBI','KEBBI','ZURU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-19 12:37:23',5,'563','2021-04-19 12:37:23','563'),(2586,'','1','143','TOBEST GASES','TOCHUKWU OKENWA','08037461018','tobestgases@gmail.com','SOKOTO','SOKOTOT0BEST','NO 1 ABDULLAHI FODIO ROAD SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-21 15:22:22',5,'563','2021-04-21 15:22:22','563'),(2601,'','1','143','MAJI GAS','SOKOTO','08161163030','majigas@yahoo.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-24 07:07:58',5,'563','2021-04-24 07:07:58','563'),(2612,'','1','143','BARAZANA','SOKOTO','07038683897','barazana@gmail.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-26 09:25:34',5,'563','2021-04-26 09:25:34','563'),(2615,'','1','143','magic flame','SOKOTO','09063128033','magicflame@gmail.com','SOKOTO','SOKOTO','guiwa','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-27 07:56:09',5,'563','2021-04-27 07:56:09','563'),(2629,'','1','143','OLUCHI GAS','oluchi gas','08036033015','oluchi@gmail.com','SOKOTO','SOKOTO','sokoto','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-30 15:00:45',5,'563','2021-04-30 15:00:45','563'),(2631,'','1','143','Adarawa houes gas','SOKOTO','08035899232','kabirucika001@gmail.com','SOKOTO','SOKOTO','sokoto\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-30 16:02:10',5,'563','2021-04-30 16:02:10','563'),(2633,'','1','143',' nasrullah gas','SOKOTO','09065039708','nasrullahgas@gmail.com','SOKOTO','SOKOTO','ARQILLA SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-01 08:04:44',5,'563','2021-05-01 08:04:44','563'),(2636,'','1','143','IKE GAS','IKE','07031261248','ikegas@gmail.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-02 08:49:54',5,'563','2021-05-02 08:49:54','563'),(2640,'','1','143','HIKIMA GAS','HIKIMA','08145961401','hikima@gmail.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-02 12:27:55',5,'563','2021-05-02 12:27:55','563'),(2647,'','1','143','RA AFA GAS','RA AFA','08062617690','raafa@gmal.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-03 12:11:52',5,'563','2021-05-03 12:11:52','563'),(2652,'','1','143','bandi gas','mohd bandi','08035804463','bandi1@yahoo.com','SOKOTO','SOKOTO','abdullahi fodio road sokoto','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-05 12:38:14',5,'563','2021-05-05 12:38:14','563'),(2657,'','1','143','t/mafara gas','mafara','08081890626','mafara@gmail.com','mafara','zamfara','mafara\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-07 10:04:03',5,'563','2021-05-07 10:04:03','563'),(2668,'','1','143','Ike  gas','ike','07031261248','ikegas@gmail.com','SOKOTO','SOKOTO','sokoto\r\n\r\n\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-11 08:30:17',5,'563','2021-05-11 08:37:48','563'),(2677,'','1','143','MORIKI GAS','ZAYYANU ABUBAKAR','08169336747','zayyanuabubakar02@gmail.com','SOKOTO','SOKOTO','sokoto','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-16 11:41:35',5,'563','2021-05-16 11:41:35','563'),(2698,'','1','143','MAINASARA GAS','MAINASARA','08180442299','mainasara@gmail.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-21 11:40:14',5,'563','2021-05-21 11:40:14','563'),(2705,'','1','143','A K A GAS','SOKOTO','08065289557','akagaz@gmail.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-25 16:16:36',5,'563','2021-05-25 16:16:36','563'),(2734,'','1','143','NUHU GAZ','SOKOTO','08030894000','nuhugaz@gmail.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-09 15:39:51',5,'563','2021-06-09 15:39:51','563'),(2755,'','1','143','YAWURI GAS','BIRNIN KEBBI','08035917287','yawurigas@gmail.com','BIRNIN KEBBI','KEBBI','YAWURI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-17 16:18:51',5,'563','2021-06-17 16:18:51','563'),(2784,'','1','143','VICTOR ZURU GAS','KEBBI','07065543340','victor@gmail.com','BIRNIN KEBBI','KEBBI','ZURU KEBBI STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-20 15:55:11',5,'563','2021-08-04 17:01:03','563'),(2852,'','1','143','DENKO GAZ','KEBBI','08038760668','denkozuru@gmail.com','BIRNIN KEBBI','KEBBI','ZURU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-27 16:15:41',5,'563','2021-06-27 16:15:41','563'),(2890,'','1','143','NURA ZURU','NURA ZURU','08066771202','nurazuru@gmail.com','BIRNIN KEBBI','KEBBI','ZURU BIRNIN KEBBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-04 13:10:04',5,'563','2021-07-04 13:10:04','563'),(3005,'','1','143','NURA MAFARA GAS','ZAMFARA','08062550404','nuramafara@gmail.com','GUSAU','zamfara','TALATAR MAFARA ZAMFARA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-01 11:26:39',5,'563','2021-08-01 11:26:39','563'),(3006,'','1','143','MALACHY MAYAMMA GAS','KEBBI','08032816086','malachygas@gmail.com','BIRNIN KEBBI','KEBBI','MAYAMMAH LOCAL GOVERNMENT KEBBI STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-01 17:36:32',5,'563','2021-08-01 17:36:32','563'),(3024,'','1','143','MAINA GAZ','SOKOTO','08031810324','mainagaz@gmail.com','SOKOTO','SOKOTO','Gwadabawa','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-06 10:44:08',5,'563','2021-08-06 10:44:08','563'),(3169,'','1','143','EMMASON GAS','EMANUEL','00767937554','emanuel@gmail.com','SOKOTO','SOKOTO','SOKOTO ILELA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-30 13:36:54',5,'563','2021-08-30 13:36:54','563'),(3199,'','1','143','BUKYUM LGA','ABDULBASIR','08105203033','abdulbasiru@gmail.com','GUSAU','ZAMFARA','BUKYUM LGA ZAMFARA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-08 10:44:58',5,'563','2021-09-08 10:44:58','563'),(3214,'','1','143','ZANGINA GAZ','KEBBI','07034598884','zanginagaz@gmail.com','ARGUNGU','KEBBI','KEBBI STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-09 16:05:25',5,'563','2021-09-09 16:05:25','563'),(3317,'','1','143','BLUEFLAME GAZ','SOKOTO','08038414073','blueflamegas@gmail.com','SOKOTO','SOKOTO','ALU FLYOVER SOKOTO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-18 16:14:13',5,'563','2021-09-18 16:14:13','563'),(3352,'','1','143','ALHERI GAZ','SOKOTO','08104453073','alherigaz@gmail.com','SOKOTO','SOKOTO','KALANBAINA ROAD SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-24 12:32:08',5,'563','2021-09-24 12:32:08','563'),(3362,'','1','143','TONY GAS','TONY','08067933545','tonygas@gmail.com','SOKOTO','SOKOTO','ILELA SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-25 14:27:51',5,'563','2021-09-25 14:27:51','563'),(3406,'','1','143','GANDI GAS','KABIRU MUAZJU','08050463273','maazuk76@gmail.com','SOKOTO','SOKOTO','RABA LGA GANDI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-06 07:55:48',5,'563','2021-10-06 07:55:48','563'),(3423,'','1','143','GWADABAWA GAZ','SOKOTO','08035349313','gwadabawagas@gmail.com','SOKOTO','SOKOTO','GWADABAWA LOCAL GOVERNMENT','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-08 12:12:00',5,'563','2021-10-08 12:12:00','563'),(3434,'','1','143','ALPHA GAS','JEGA KEBBI','08133236406','alphagaz@gmail.com','BIRNIN KEBBI','KEBBI','JEGA BIRNIN KEBBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-11 06:50:40',5,'563','2021-10-11 06:50:40','563'),(3752,'','1','143','BUSHARA M A D','MUSTAPHA ABUBAKAR','07032540300','dagubafarawa11@gmail.com','SOKOTO','SOKOTO','KADUNA ROAD OPP ONDO LOW COST','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-14 13:32:33',5,'563','2021-11-14 13:32:33','563'),(3762,'','1','143','EZEAFAKAEGO','SOKOTO','07036730488','sokotolpgplant@aaranonigeria.c','SOKOTO','SOKOTO','BAUCHI ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-15 13:41:57',5,'563','2021-11-15 13:41:57','563'),(3842,'','1','143','S BLUE GATE GAS','SOKOTO','08135001118','sokotolsblue@gmail.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-24 12:12:22',5,'563','2021-11-24 12:12:22','563'),(3844,'','1','143','KOKO GAZ','KEBBI','08068585279','koko1@gmail.com','BIRNIN KEBBI','KEBBI','KEBBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-24 15:13:37',5,'563','2021-11-24 15:13:37','563'),(4047,'','1','143','MUSBAHU GAS','MUSBAHU','07063814322','musba@gmail.com','SOKOTO','SOKOTO','GWIWA LOCUS AREA NEAR JAREDE PLAZA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-18 12:31:01',5,'563','2021-12-18 12:31:01','563'),(4048,'','1','143','TANGALE GAS INESTMENT','KABIRU ABUBAKAR SHAGARI','08038503285','shagarikabir@gmail.com','SOKOTO','SOKOTO','SOKOTO JEGGA ROAD SHAGARI LGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-23 16:02:47',5,'563','2022-02-23 16:02:47','563'),(4049,'','1','143','DAN KARAMI GAS','CUSTOMER','08060565153','amsaif9@gmail.com','SOKOTO','SOKOTO','GWARANYO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-26 14:33:02',5,'563','2022-08-26 14:33:02','563'),(4050,'','1','143','KYAMARI GAS','CUSTOMER','08060565153','amsaif9@gmail.com','SOKOTO','SOKOTO','KYAMARI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-26 14:38:43',5,'563','2022-08-26 14:38:43','563'),(4051,'','1','143','NURA GUMMI','GMMI','08064644044','sokotolpgplant@aaranonigeria.c','GUMMI','ZAMFARA','GUMMI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-08 13:38:05',5,'563','2022-09-08 13:38:05','563'),(4052,'','1','143','SALWAS INVSMT','SALWAS INVSMT','08141725606','amsaif9@gmail.com','BODINGA','SOKOTO','SHIYA SARKI BODINGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-17 09:27:52',5,'563','2022-10-17 09:27:52','563'),(4053,'','1','143','ALHERI GAS','ALHERI GAS','08067823032','amsaif9@gmail.com','SOKOTO','SOKOTO','ARKILLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-17 10:37:25',5,'563','2022-10-17 10:37:25','563'),(4054,'','1','143','JAMACO GAS','JAMACO GAS','09031465088','amsaif9@gmail.com','SOKOTO','SOKOTO','GWIWA LOW COST','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-17 12:29:23',5,'563','2022-10-17 12:29:23','563'),(4055,'','1','143','ALKANJI GAS','ALKANJI GAS','07038831230','amsaif9@gmail.com','KEBBI','KEBBI','ARGUNGU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-17 12:42:47',5,'563','2022-10-17 12:42:47','563'),(4056,'','1','143','PRECIOUS 7 GAS','PRECIOUS 7GAS','08162957201','amsaif9@gmail.com','SOKOTO','SOKOTO','TAMAJE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-17 17:59:53',5,'563','2022-10-17 17:59:53','563'),(4057,'','1','143','sabon birni gas','sabon birni gas','09017864279','amsaif9@gmail.com','SOKOTO','SOKOTO','sabon birni','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-19 08:59:36',5,'563','2022-10-19 08:59:36','563'),(4058,'','1','143','UGO GAS ','UGO GAS','08100145916','amsaif9@gmail.com','SOKOTO','SOKOTO','OPPA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-19 10:30:49',5,'563','2022-10-19 11:01:58','563'),(4059,'','1','143','ISAH GAS','ISAH GAS','08141725606','amsaif9@gmail.com','ISAH','SOKOTO','ISAH LOVT','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-19 12:49:06',5,'563','2022-10-19 12:49:06','563'),(4060,'','1','143','MK GAS','MK GAS','08109553180','amsaif9@gmail.com','SOKOTO','SOKOTO','UGUWAR ROGO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-19 13:13:58',5,'563','2022-10-19 13:13:58','563'),(4061,'','1','143','AL UMMA GAS','SDSS','08039114758','amsaif(@gmail.com','SOKOTO','SOKOTO','RFGHS','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-20 17:34:41',5,'563','2022-10-20 17:34:41','563'),(4062,'','1','143','dauda gas','dauda gas','08141725606','amsaif9@gmail.com','SOKOTO','SOKOTO','front of belshams','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-21 09:45:16',5,'563','2022-10-21 09:45:16','563'),(4063,'','1','143','A & D GAS','A & D GAS','08138513271','amsaif9@gmail.com','SOKOTO','SOKOTO','NAKASARI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-21 11:01:38',5,'563','2022-10-21 11:01:38','563'),(4064,'','1','143','obosco blessed gas','dambuwa barrack','08105985049','amsaif9@gmail.com','SOKOTO','SOKOTO','dambuwa barrack sokoto','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-22 11:21:01',5,'563','2022-10-22 11:21:01','563'),(4065,'','1','143','BAKIN KUSU','BAKIN KUSU','08162148644','rano@gmail.com','SOKOTO','SOKOTO','BAKIN KUSU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-23 09:50:59',5,'563','2022-10-23 09:50:59','563'),(4066,'','1','143','ALIYU  GAZ','ALIYU GAZ','07030793669','aiyyugaz@gmail.com','SOKOTO ','SOKOTO','SOKOTO NIGERIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-23 11:19:18',5,'563','2022-10-23 11:19:18','563'),(4067,'','1','143','christolight gas','skt','08105768221','amsa@gmai.com','sokoto','sokoto','nakasari','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-24 14:50:30',5,'563','2022-10-24 14:50:30','563'),(4068,'','1','143','KCOOL GAS','KCOOL GAS','07046874426','amsaif9@gmail.com','SOKOTO','SOKOTO','BADO ALU QUATERS','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-25 13:48:21',5,'563','2022-10-25 13:48:21','563'),(4069,'','1','143','OPLET GAS','OPLET GAS','07031021201','amsaif9@gmail.com','SOKOTO','SOKOTO','NAKASARI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-25 14:55:43',5,'563','2022-10-25 14:55:43','563'),(4070,'','1','143','USMANIYYA GAS','USMANIYYA GAS','07036822073','amsaif9@gmail.com','SOKOTO','SOKOTO','GWIWA EKA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-25 15:31:24',5,'563','2022-10-25 15:31:24','563'),(4071,'','1','143','Ezealor  GAS','Ezealor Gas','07082424713','amsaif9@gmail.com','SOKOTO','SOKOTO','dambuwa','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-29 12:20:22',5,'563','2022-10-29 12:20:22','563'),(4072,'','1','143','reliance mark','reliance mark','08034339169','amsaif9@gmail.com','SOKOTO','SOKOTO','tamaje','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-29 12:57:07',5,'563','2022-10-29 12:57:07','563'),(4073,'','1','143','Akawo gas','Akawa gas','08060752308','amsaif9@gmail.com','SOKOTO','SOKOTO','gwiwa low-cost','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-07 12:52:54',5,'563','2022-11-07 12:52:54','563'),(4074,'','1','143','SILAME GAS','SILAME GAS','07068334328','amsaif9@gmail.com','SILAME','SOKOTO','SILAME','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-11 13:39:41',5,'563','2022-11-11 13:39:41','563'),(4075,'','1','143','Abdullahi gas','abdullahi gas','08066166897','amsaif9@gmail.com','SOKOTO','SOKOTO','state low-cost','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-11 15:50:11',5,'563','2022-11-11 15:50:11','563'),(4076,'','1','143','ABBAS A.GAZ NIG','ABBAS A.GAZ NIG','08036937286','rano@gmail.com','SOKOTO','SOKOTO','SOKOTO NIG','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-14 12:10:10',5,'563','2022-11-14 12:10:10','563'),(4077,'','1','143','s/ rufa\'i gas','s/rufa\'i gas','09034224198','amsaif9@gmail.com','SOKOTO','SOKOTO','b/ estate','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-17 10:00:33',5,'563','2022-11-17 10:00:33','563'),(4078,'','1','143','Goronyo gas','Goronyo gas','07060694721','goronyo@gmail.com','goronyo','sokoto','goronyo','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-21 11:06:02',5,'563','2022-11-21 11:06:02','563'),(4079,'','1','143','kebscool','badu qtrs','08037576527','amdhj@gmai.com','sokoto','sokoto','badu qtrs','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-24 12:21:05',5,'563','2022-11-24 12:21:05','563'),(4080,'','1','143','Rahimat gas','Rahimat gas','08118324696','amsaif9@gmail.com','kware','sokoto','kware','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-28 17:56:15',5,'563','2022-11-28 17:56:15','563'),(4081,'','1','143','obosco gas','dambuwa','08105985049','amdjh@gmail,com','sokoto','sokoto','dambuwa','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-29 17:25:41',5,'563','2022-11-29 17:25:41','563'),(4082,'','1','143','GG GAS','GG GAS','08130933689','amsaif9@gmail.com','sokoto','sokoto','kalambaina wammako junction','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-06 13:34:08',5,'563','2023-03-10 11:40:27','563'),(4083,'','1','143','Referral tech ','Referral tech','08063950893','amsaif9@gmail.com','sokoto','sokoto','rijiyar dorawa','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-08 10:09:02',5,'563','2023-02-08 10:09:02','563');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16868 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','143',16867,'865',1644.42,1.00,'2021-10-19','new','2021-10-19 15:13:09','483','483',2021,'483','2021-10-19 15:13:09',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2520 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','143','865',2516,'5','LPG NOZZLE 1',179483.83,'LPG DISPENSER','',NULL,NULL,'',5,'2022-02-11 06:59:15','483'),('1','143','866',2517,'5','LPG NOZZLE 4',158682.73,'LPG DISPENSER','',NULL,NULL,'',5,'2022-02-11 07:00:02','483'),('1','143','865',2518,'5','LPG NOZZLE 2',155910.82,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-02-11 07:00:38','483'),('1','143','866',2519,'5','LPG NOZZLE 3',165433.70,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-02-11 07:01:19','483');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257962 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','143',169016,'DAILY SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'563',0.00,0.00,'563','2020-12-24 11:56:13','563','2020-12-24 11:56:39',10,0),('1','143',169220,'DAILY SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'563',0.00,0.00,'563','2020-12-25 14:37:58','563','2020-12-25 14:38:20',10,0),('1','143',169328,'DAILY SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'563',0.00,0.00,'563','2020-12-26 10:48:07','563','2020-12-26 10:48:37',10,0),('1','143',169505,'DAILY SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'563',0.00,0.00,'563','2020-12-27 11:58:37','563','2020-12-27 11:59:03',10,0),('1','143',169745,'DAILY SHIFT','2020-12-27','2020-12-27 00:00:00',NULL,'563',0.00,0.00,'563','2020-12-28 16:01:21','563','2020-12-28 16:02:03',10,0),('1','143',169889,'DAILY SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'563',0.00,0.00,'563','2020-12-29 14:59:53','563','2020-12-29 15:00:28',10,0),('1','143',170082,'DAILY SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'563',0.00,0.00,'563','2020-12-30 15:42:34','563','2020-12-30 15:43:04',10,0),('1','143',170188,'DAILY SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'563',0.00,0.00,'563','2020-12-31 09:36:04','563','2020-12-31 09:36:38',10,0),('1','143',170392,'DAILY SHIFT','2020-01-31','2020-01-31 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-01 10:55:24','563','2021-01-01 10:55:50',10,0),('1','143',170523,'DAILY SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-02 08:34:26','563','2021-01-02 08:34:49',10,0),('1','143',170702,'DAILY SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-03 09:42:29','563','2021-01-03 09:43:05',10,0),('1','143',170893,'DAILY SHIFT','2021-01-03','2021-01-03 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-04 12:08:45','563','2021-01-04 12:09:07',10,0),('1','143',171058,'DAILY SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-05 09:37:48','563','2021-01-05 09:38:15',10,0),('1','143',171223,'DAILY SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-06 07:25:29','563','2021-01-06 07:25:54',10,0),('1','143',171427,'DAILY SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-07 09:50:56','563','2021-01-07 09:51:23',10,0),('1','143',171550,'DAILY SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-07 16:07:01','563','2021-01-07 16:07:24',10,0),('1','143',171560,'DAILY SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-08 20:53:08','563','2021-01-08 20:53:31',10,0),('1','143',171776,'DAILY SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-08 21:03:02','563','2021-01-08 21:03:48',10,0),('1','143',171779,'DAILY SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-08 21:39:28','563','2021-01-08 21:40:08',10,0),('1','143',171953,'DAILY SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-09 21:25:05','563','2021-01-09 21:25:42',10,0),('1','143',172087,'DAILY SHIFT','2021-01-10','2021-01-10 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-10 19:53:03','563','2021-01-10 19:53:39',10,0),('1','143',172281,'DAILY SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-11 20:08:47','563','2021-01-11 20:09:11',10,0),('1','143',172506,'DAILY SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-13 07:00:33','563','2021-01-13 07:01:04',10,0),('1','143',172788,'DAILY SHIFT','2021-01-13','2021-01-13 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-14 14:18:15','563','2021-01-14 14:18:57',10,0),('1','143',172881,'DAILY SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-15 07:05:09','563','2021-01-15 07:05:35',10,0),('1','143',173068,'DAILY SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-16 06:44:43','563','2021-01-16 06:45:03',10,0),('1','143',173069,'DAILY SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-16 07:02:27','563','2021-01-16 07:02:56',10,0),('1','143',173228,'DAILY SHIFT','2021-01-16','2021-01-16 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-17 07:12:56','563','2021-01-17 07:13:14',10,0),('1','143',173439,'DAILY SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-18 09:29:00','563','2021-01-18 09:29:19',10,0),('1','143',173587,'DAILY SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-18 19:56:18','563','2021-01-18 19:59:23',10,0),('1','143',173763,'DAILY SHIFT','2021-01-19','2021-01-19 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-19 19:58:32','563','2021-01-19 19:59:55',10,0),('1','143',173942,'DAILY SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-20 20:11:47','563','2021-01-20 20:12:28',10,0),('1','143',174126,'DAILY SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-21 20:10:03','563','2021-01-21 20:10:40',10,0),('1','143',174163,'DAILY SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-22 09:11:54','563','2021-01-22 09:12:31',10,0),('1','143',174323,'DAILY SHIFT','2021-01-22','2021-01-22 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-22 20:30:34','563','2021-01-22 20:31:20',10,0),('1','143',174497,'DAILY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-24 06:47:10','563','2021-01-24 06:47:49',10,0),('1','143',174500,'DAILY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-24 07:21:31','563','2021-01-24 07:21:56',10,0),('1','143',174649,'DAILY SHIFT','2021-01-24','2021-01-24 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-25 05:39:51','563','2021-01-25 05:40:21',10,0),('1','143',174847,'DAILY SHIFT','2021-01-25','2021-01-25 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-26 05:54:45','563','2021-01-26 05:55:12',10,0),('1','143',175056,'DAILY SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-27 06:55:29','563','2021-01-27 06:56:03',10,0),('1','143',175246,'DAILY SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-28 05:43:16','563','2021-01-28 05:44:27',10,0),('1','143',175421,'DAILY SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-29 06:30:39','563','2021-01-29 06:31:34',10,0),('1','143',175601,'DAILY SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-30 06:07:37','563','2021-01-30 06:08:22',10,0),('1','143',175762,'DAILY SHIFT','2021-01-30','2021-01-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-01-31 06:55:45','563','2021-01-31 06:56:07',10,0),('1','143',175957,'DAILY SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-01 10:01:27','563','2021-02-01 10:05:41',10,0),('1','143',175977,'DAILY SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-01 10:11:44','563','2021-02-01 10:12:27',10,0),('1','143',175992,'DAILY SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-01 10:41:03','563','2021-02-01 10:41:32',10,0),('1','143',176143,'DAILY SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-01 20:24:58','563','2021-02-01 20:25:24',10,0),('1','143',176347,'DAILY SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-03 07:23:39','563','2021-02-03 07:25:42',10,0),('1','143',176564,'DAILY SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-04 07:17:43','563','2021-02-04 07:18:07',10,0),('1','143',176789,'DAILY SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-05 07:17:04','563','2021-02-05 07:17:37',10,0),('1','143',176991,'DAILY SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-06 06:06:09','563','2021-02-06 06:06:52',10,0),('1','143',177231,'DAILY SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-07 06:08:32','563','2021-02-07 06:09:01',10,0),('1','143',177428,'DAILY SHIFT','2021-02-07','2021-02-07 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-08 05:46:45','563','2021-02-08 05:47:09',10,0),('1','143',177620,'DAILY SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-08 20:55:30','563','2021-02-08 20:56:05',10,0),('1','143',177621,'DAILY SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-08 21:06:13','563','2021-02-08 21:06:45',10,0),('1','143',177819,'DAILY SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-09 16:09:47','563','2021-02-09 16:10:10',10,0),('1','143',177892,'DAILY SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-10 07:51:16','563','2021-02-10 07:51:43',10,0),('1','143',178081,'DAILY SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-11 07:07:53','563','2021-02-11 07:08:17',10,0),('1','143',178291,'DAILY SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-12 06:19:02','563','2021-02-12 06:20:12',10,0),('1','143',178496,'DAILY SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-13 07:22:01','563','2021-02-13 07:22:30',10,0),('1','143',178737,'DAILY SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-14 07:24:00','563','2021-02-14 07:24:28',10,0),('1','143',178877,'DAILY SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-14 18:52:24','563','2021-02-14 18:52:54',10,0),('1','143',178909,'DAILY SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-16 06:53:56','563','2021-02-16 06:54:34',10,0),('1','143',179371,'DAILY SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-17 07:22:07','563','2021-02-17 07:23:14',10,0),('1','143',179577,'DAILY SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-18 07:18:22','563','2021-02-18 07:18:47',10,0),('1','143',179767,'DAILY SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-19 05:54:54','563','2021-02-19 05:55:24',10,0),('1','143',179775,'DAILY SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-19 18:52:43','563','2021-02-19 18:53:09',10,0),('1','143',179993,'DAILY SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-20 15:05:05','563','2021-02-20 15:05:30',10,0),('1','143',180117,'DAILY SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-20 18:34:21','563','2021-02-20 18:34:45',10,0),('1','143',180186,'DAILY SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-21 17:53:45','563','2021-02-21 17:54:11',10,0),('1','143',180304,'DAILY SHIFT','2021-02-21','2021-02-21 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-21 18:31:59','563','2021-02-21 18:32:31',10,0),('1','143',180356,'DAILY SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-22 18:20:09','563','2021-02-22 18:20:53',10,0),('1','143',180556,'DAILY SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-23 17:36:48','563','2021-02-23 17:37:10',10,0),('1','143',180743,'DAILY SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-24 17:41:40','563','2021-02-24 17:42:04',10,0),('1','143',180966,'DAILY SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-25 17:40:10','563','2021-02-25 17:40:34',10,0),('1','143',181139,'DAILY SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-26 17:20:16','563','2021-02-26 17:20:49',10,0),('1','143',181342,'DAILY SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-27 19:48:42','563','2021-02-27 19:49:42',10,0),('1','143',181528,'DAILY SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'563',0.00,0.00,'563','2021-02-28 17:45:39','563','2021-02-28 17:46:05',10,0),('1','143',181716,'DAILY SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-01 07:20:41','563','2021-03-01 07:21:10',10,0),('1','143',181722,'DAILY SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-01 13:49:38','563','2021-03-01 13:50:06',10,0),('1','143',181805,'DAILY SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-01 18:36:48','563','2021-03-01 18:37:16',10,0),('1','143',181916,'DAILY SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-02 07:43:34','563','2021-03-02 07:44:19',10,0),('1','143',181922,'DAILY SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-02 18:12:22','563','2021-03-02 18:12:49',10,0),('1','143',182115,'DAILY SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-03 18:03:00','563','2021-03-03 18:03:25',10,0),('1','143',182317,'DAILY SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-04 17:43:14','563','2021-03-04 17:43:32',10,0),('1','143',182507,'DAILY SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-05 18:01:28','563','2021-03-05 18:01:56',10,0),('1','143',182691,'DAILY SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-06 17:29:44','563','2021-03-06 17:30:08',10,0),('1','143',182848,'DAILY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-07 17:35:50','563','2021-03-07 17:36:30',10,0),('1','143',182988,'DAILY SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-08 17:51:01','563','2021-03-08 17:51:37',10,0),('1','143',183219,'DAILY SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-09 17:48:17','563','2021-03-09 17:49:04',10,0),('1','143',183431,'DAILY SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-10 17:30:01','563','2021-03-10 17:30:29',10,0),('1','143',183630,'DAILY SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-10 21:39:07','563','2021-03-10 21:39:42',10,0),('1','143',183650,'DAILY SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-11 12:56:21','563','2021-03-11 12:56:51',10,0),('1','143',183759,'DAILY SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-11 17:27:47','563','2021-03-11 17:37:07',10,0),('1','143',183922,'DAILY SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-12 17:35:41','563','2021-03-12 17:36:28',10,0),('1','143',184055,'DAILY SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-12 17:47:29','563','2021-03-12 17:47:53',10,0),('1','143',184100,'DAILY SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-13 17:29:28','563','2021-03-13 17:29:54',10,0),('1','143',184274,'DAILY SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-14 17:19:56','563','2021-03-14 17:20:24',10,0),('1','143',184473,'DAILY SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-15 17:25:30','563','2021-03-15 17:26:00',10,0),('1','143',184698,'DAILY SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-16 17:34:08','563','2021-03-16 17:34:39',10,0),('1','143',184888,'DAILY SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-17 17:28:45','563','2021-03-17 17:29:11',10,0),('1','143',185108,'DAILY SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-18 17:26:37','563','2021-03-18 17:27:08',10,0),('1','143',185261,'DAILY SHIFT','2021-03-19','2021-03-19 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-19 17:41:40','563','2021-03-19 17:42:08',10,0),('1','143',185470,'DAILY SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-20 17:13:09','563','2021-03-20 17:13:42',10,0),('1','143',185676,'DAILY SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-21 17:19:04','563','2021-03-21 17:19:34',10,0),('1','143',185876,'DAILY SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-22 17:30:03','563','2021-03-22 17:30:31',10,0),('1','143',186106,'DAILY SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-23 17:18:04','563','2021-03-23 17:18:31',10,0),('1','143',186320,'DAILY SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-24 17:09:55','563','2021-03-24 17:10:25',10,0),('1','143',186539,'DAILY SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-25 17:20:49','563','2021-03-25 17:21:19',10,0),('1','143',186761,'DAILY SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-26 17:25:15','563','2021-03-26 17:25:52',10,0),('1','143',187168,'DAILY SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-28 12:35:12','563','2021-03-28 12:35:41',10,0),('1','143',187253,'DAILY SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-28 17:18:44','563','2021-03-28 17:19:06',10,0),('1','143',187354,'DAILY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-29 17:27:14','563','2021-03-29 17:27:47',10,0),('1','143',187613,'DAILY SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-30 17:34:57','563','2021-03-30 17:35:37',10,0),('1','143',187817,'DAILY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'563',0.00,0.00,'563','2021-03-31 17:44:19','563','2021-03-31 17:44:50',10,0),('1','143',188021,'DAILY SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-01 18:39:17','563','2021-04-01 18:39:43',10,0),('1','143',188219,'DAILY SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-02 21:04:08','563','2021-04-02 21:05:07',10,0),('1','143',188430,'DAILY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-03 18:00:04','563','2021-04-03 18:01:00',10,0),('1','143',188608,'DAILY SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-04 17:45:46','563','2021-04-04 17:46:16',10,0),('1','143',188782,'DAILY SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-04 20:45:49','563','2021-04-04 20:46:25',10,0),('1','143',188808,'DAILY SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-05 14:08:29','563','2021-04-05 14:08:54',10,0),('1','143',188922,'DAILY SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-05 18:14:02','563','2021-04-05 18:14:42',10,0),('1','143',189016,'DAILY SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-06 17:49:36','563','2021-04-06 17:50:05',10,0),('1','143',189208,'DAILY SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-07 17:42:53','563','2021-04-07 17:43:20',10,0),('1','143',189430,'DAILY SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-08 17:15:12','563','2021-04-08 17:15:38',10,0),('1','143',189637,'DAILY SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-09 19:42:25','563','2021-04-09 19:42:50',10,0),('1','143',189820,'DAILY SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-10 17:35:56','563','2021-04-10 17:36:30',10,0),('1','143',190032,'DAILY SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-11 19:46:20','563','2021-04-11 19:46:50',10,0),('1','143',190224,'DAILY SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-12 17:24:19','563','2021-04-12 17:24:49',10,0),('1','143',190441,'DAILY SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-13 13:09:38','563','2021-04-13 13:10:58',10,0),('1','143',190564,'DAILY SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-13 21:38:41','563','2021-04-13 21:39:06',10,0),('1','143',190682,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-14 16:51:52','563','2021-04-14 16:52:18',10,0),('1','143',190852,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-14 16:54:49','563','2021-04-14 16:55:09',10,0),('1','143',190905,'DAILY SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-15 16:58:20','563','2021-04-15 16:58:48',10,0),('1','143',191089,'DAILY SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-16 16:55:44','563','2021-04-16 16:56:15',10,0),('1','143',191318,'DAILY SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-17 20:02:31','563','2021-04-17 20:03:00',10,0),('1','143',191504,'DAILY SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-18 16:55:59','563','2021-04-18 16:56:46',10,0),('1','143',191725,'DAILY SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-19 16:59:29','563','2021-04-19 16:59:55',10,0),('1','143',191946,'DAILY SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-20 12:20:33','563','2021-04-20 12:20:57',10,0),('1','143',192034,'DAILY SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-20 17:06:51','563','2021-04-20 17:07:13',10,0),('1','143',192139,'DAILY SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-21 16:50:30','563','2021-04-21 16:51:09',10,0),('1','143',192347,'DAILY SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-23 07:41:46','563','2021-04-23 07:50:36',10,0),('1','143',192593,'DAILY SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-23 17:16:43','563','2021-04-23 17:17:11',10,0),('1','143',192760,'DAILY SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-24 16:51:20','563','2021-04-24 16:51:48',10,0),('1','143',192983,'DAILY SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-25 16:59:10','563','2021-04-25 16:59:35',10,0),('1','143',193183,'DAILY SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-26 17:12:52','563','2021-04-26 17:14:01',10,0),('1','143',193417,'DAILY SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-27 17:01:48','563','2021-04-27 17:02:10',10,0),('1','143',193632,'DAILY SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-28 17:07:31','563','2021-04-28 17:08:29',10,0),('1','143',193868,'DAILY SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-29 16:54:49','563','2021-04-29 16:55:16',10,0),('1','143',194088,'DAILY SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-04-30 17:03:50','563','2021-04-30 17:04:27',10,0),('1','143',194296,'DAILY SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-01 16:53:32','563','2021-05-01 16:54:06',10,0),('1','143',194490,'DAILY SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-02 17:01:43','563','2021-05-02 17:02:18',10,0),('1','143',194689,'DAILY SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-03 16:50:24','563','2021-05-03 16:51:07',10,0),('1','143',194872,'DAILY SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-04 16:48:18','563','2021-05-04 16:49:02',10,0),('1','143',195090,'DAILY SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-05 14:16:02','563','2021-05-05 14:18:36',10,0),('1','143',195245,'DAILY SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-05 21:50:29','563','2021-05-05 21:50:57',10,0),('1','143',195313,'DAILY SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-06 16:47:27','563','2021-05-06 16:47:53',10,0),('1','143',195527,'DAILY SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-07 17:14:08','563','2021-05-07 17:16:07',10,0),('1','143',195792,'DAILY SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-08 17:07:41','563','2021-05-08 17:08:35',10,0),('1','143',196017,'DAILY SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-09 16:49:47','563','2021-05-09 16:50:30',10,0),('1','143',196242,'DAILY SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-10 17:29:38','563','2021-05-10 17:30:05',10,0),('1','143',196485,'DAILY SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-11 17:14:25','563','2021-05-11 17:15:21',10,0),('1','143',196676,'DAILY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-13 14:23:14','563','2021-05-13 14:23:42',10,0),('1','143',196956,'DAILY SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-13 17:38:15','563','2021-05-13 17:38:37',10,0),('1','143',197043,'DAILY SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-14 17:16:33','563','2021-05-14 17:17:08',10,0),('1','143',197300,'DAILY SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-16 10:41:17','563','2021-05-16 10:41:34',10,0),('1','143',197306,'DAILY SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-16 17:30:33','563','2021-05-16 17:30:56',10,0),('1','143',197528,'DAILY SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-17 17:42:07','563','2021-05-17 17:42:28',10,0),('1','143',197888,'DAILY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-18 12:26:48','563','2021-05-18 12:28:08',10,0),('1','143',197999,'DAILY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-18 17:18:49','563','2021-05-18 17:19:11',10,0),('1','143',198122,'DAILY SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-19 17:03:43','563','2021-05-19 17:04:14',10,0),('1','143',198370,'DAILY SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-20 17:07:33','563','2021-05-20 17:07:59',10,0),('1','143',198583,'DAILY SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-21 17:12:53','563','2021-05-21 17:14:04',10,0),('1','143',198814,'DAILY SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-22 17:26:22','563','2021-05-22 17:26:43',10,0),('1','143',198994,'DAILY SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-24 07:10:36','563','2021-05-24 07:11:08',10,0),('1','143',199229,'DAILY SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-24 17:34:34','563','2021-05-24 17:34:59',10,0),('1','143',199448,'DAILY SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-25 17:04:43','563','2021-05-25 17:05:20',10,0),('1','143',199677,'DAILY SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-26 16:46:52','563','2021-05-26 16:47:28',10,0),('1','143',199830,'DAILY SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-26 17:41:41','563','2021-05-26 17:42:35',10,0),('1','143',199900,'DAILY SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-27 17:09:46','563','2021-05-27 17:10:17',10,0),('1','143',200110,'DAILY SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-28 17:36:35','563','2021-05-28 17:36:59',10,0),('1','143',200307,'DAILY SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-29 17:36:31','563','2021-05-29 17:37:03',10,0),('1','143',200507,'DAILY SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-30 17:31:30','563','2021-05-30 17:31:56',10,0),('1','143',200746,'DAILY SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'563',0.00,0.00,'563','2021-05-31 18:04:42','563','2021-05-31 18:05:09',10,0),('1','143',200937,'DAILY SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-01 17:59:42','563','2021-06-01 18:00:24',10,0),('1','143',201125,'DAILY SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-02 18:02:53','563','2021-06-02 18:03:22',10,0),('1','143',201322,'DAILY SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-03 17:45:21','563','2021-06-03 17:45:39',10,0),('1','143',201504,'DAILY SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-04 17:45:17','563','2021-06-04 17:45:39',10,0),('1','143',201769,'DAILY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-05 17:39:47','563','2021-06-05 17:40:25',10,0),('1','143',202040,'DAILY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-06 17:47:51','563','2021-06-06 17:48:14',10,0),('1','143',202225,'DAILY SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-07 12:11:19','563','2021-06-07 12:12:26',10,0),('1','143',202327,'DAILY SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-07 18:21:02','563','2021-06-07 18:21:34',10,0),('1','143',202457,'DAILY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-08 08:39:54','563','2021-06-08 08:40:24',10,0),('1','143',202473,'DAILY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-08 17:46:13','563','2021-06-08 17:46:43',10,0),('1','143',202658,'DAILY SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-09 17:56:57','563','2021-06-09 17:57:23',10,0),('1','143',202865,'DAILY SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-10 18:00:13','563','2021-06-10 18:00:44',10,0),('1','143',203122,'DAILY SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-11 17:55:32','563','2021-06-11 17:56:02',10,0),('1','143',203314,'DAILY SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-12 17:44:14','563','2021-06-12 17:44:37',10,0),('1','143',203530,'DAILY SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-13 17:43:08','563','2021-06-13 17:43:32',10,0),('1','143',203744,'DAILY SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-14 17:50:51','563','2021-06-14 17:51:14',10,0),('1','143',203972,'DAILY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-15 18:11:46','563','2021-06-15 18:12:04',10,0),('1','143',204202,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-16 17:53:34','563','2021-06-16 17:54:06',10,0),('1','143',204413,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-17 17:35:55','563','2021-06-17 17:36:18',10,0),('1','143',204576,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-17 18:05:45','563','2021-06-17 18:06:04',10,0),('1','143',204634,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-18 06:52:45','563','2021-06-18 06:53:13',10,0),('1','143',204635,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-18 18:01:22','563','2021-06-18 18:01:40',10,0),('1','143',204861,'DAILY SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-19 17:54:06','563','2021-06-19 17:54:35',10,0),('1','143',205045,'DAILY SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-20 17:59:33','563','2021-06-20 18:00:03',10,0),('1','143',205250,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-21 17:58:48','563','2021-06-21 17:59:23',10,0),('1','143',205487,'DAILY SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-22 18:02:56','563','2021-06-22 18:03:44',10,0),('1','143',205737,'DAILY SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-23 18:02:40','563','2021-06-23 18:03:04',10,0),('1','143',205952,'DAILY SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-24 21:31:26','563','2021-06-24 21:31:58',10,0),('1','143',206164,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-25 17:47:50','563','2021-06-25 17:48:11',10,0),('1','143',206368,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-26 17:46:10','563','2021-06-26 17:46:35',10,0),('1','143',206578,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-27 14:36:51','563','2021-06-27 14:37:17',10,0),('1','143',206709,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-27 18:08:00','563','2021-06-27 18:08:41',10,0),('1','143',206910,'DAILY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-28 18:09:12','563','2021-06-28 18:09:52',10,0),('1','143',207035,'DAILY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-29 18:08:25','563','2021-06-29 18:10:03',10,0),('1','143',207261,'DAILY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-06-30 17:53:47','563','2021-06-30 17:54:30',10,0),('1','143',207508,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-01 18:29:54','563','2021-07-01 18:30:25',10,0),('1','143',207665,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-01 18:35:42','563','2021-07-01 18:36:13',10,0),('1','143',207776,'DAILY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-02 18:27:53','563','2021-07-02 18:28:48',10,0),('1','143',207913,'DAILY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-03 18:12:59','563','2021-07-03 18:13:28',10,0),('1','143',208132,'DAILY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-04 18:51:15','563','2021-07-04 18:51:33',10,0),('1','143',208341,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-05 18:43:09','563','2021-07-05 18:43:39',10,0),('1','143',208544,'DAILY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-06 18:33:01','563','2021-07-06 18:34:31',10,0),('1','143',208765,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-07 20:08:55','563','2021-07-07 20:09:31',10,0),('1','143',209004,'DAILY SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-08 20:16:34','563','2021-07-08 20:17:16',10,0),('1','143',209219,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-09 19:17:29','563','2021-07-09 19:18:12',10,0),('1','143',209428,'DAILY SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-10 19:49:18','563','2021-07-10 19:49:46',10,0),('1','143',209639,'DAILY SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-11 19:55:36','563','2021-07-11 19:56:03',10,0),('1','143',209848,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-12 19:19:24','563','2021-07-12 19:19:44',10,0),('1','143',210072,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-12 19:37:45','563','2021-07-12 19:38:19',10,0),('1','143',210177,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-13 19:15:00','563','2021-07-13 19:15:22',10,0),('1','143',210301,'DAILY SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-14 20:50:24','563','2021-07-14 20:50:51',10,0),('1','143',210500,'DAILY SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-15 19:14:19','563','2021-07-15 19:14:47',10,0),('1','143',210817,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-17 06:47:40','563','2021-07-17 06:48:09',10,0),('1','143',210979,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-18 07:38:47','563','2021-07-18 07:39:18',10,0),('1','143',211190,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-18 20:30:31','563','2021-07-18 20:34:32',10,0),('1','143',211509,'DAILY SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-19 19:10:31','563','2021-07-19 19:10:52',10,0),('1','143',211575,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-19 19:31:16','563','2021-07-19 19:31:40',10,0),('1','143',211610,'DAILY SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-20 17:35:37','563','2021-07-20 17:36:09',10,0),('1','143',211799,'DAILY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-21 17:49:37','563','2021-07-21 17:50:02',10,0),('1','143',212030,'DAILY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-22 18:27:21','563','2021-07-22 18:27:52',10,0),('1','143',212195,'DAILY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-22 19:28:43','563','2021-07-22 19:29:20',10,0),('1','143',212247,'DAILY SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-23 17:59:51','563','2021-07-23 18:02:00',10,0),('1','143',212473,'DAILY SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-24 17:50:13','563','2021-07-24 17:51:13',10,0),('1','143',212734,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-25 17:56:58','563','2021-07-25 18:06:13',10,0),('1','143',212883,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-26 16:57:44','563','2021-07-26 17:01:29',10,0),('1','143',213146,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-27 17:57:41','563','2021-07-27 18:13:53',10,0),('1','143',213406,'DAILY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-28 18:34:17','563','2021-07-28 18:38:17',10,0),('1','143',213646,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-29 16:28:40','563','2021-07-29 16:30:08',10,0),('1','143',213821,'DAILY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-29 16:40:09','563','2021-07-29 16:40:35',10,0),('1','143',213826,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-29 17:01:56','563','2021-07-29 17:02:26',10,0),('1','143',213829,'DAILY SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-29 17:10:04','563','2021-07-29 17:10:28',10,0),('1','143',213831,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-29 17:16:35','563','2021-07-29 17:17:00',10,0),('1','143',213832,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-29 18:15:49','563','2021-07-29 18:16:43',10,0),('1','143',213947,'DAILY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-30 17:59:24','563','2021-07-30 17:59:53',10,0),('1','143',214163,'DAILY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'563',0.00,0.00,'563','2021-07-31 18:25:24','563','2021-07-31 18:25:52',10,0),('1','143',214344,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-01 18:21:30','563','2021-08-01 18:22:06',10,0),('1','143',214552,'DAILY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-02 18:22:35','563','2021-08-02 18:23:00',10,0),('1','143',214795,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-03 18:42:00','563','2021-08-03 18:42:26',10,0),('1','143',215013,'DAILY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-04 17:33:26','563','2021-08-04 17:36:23',10,0),('1','143',215232,'DAILY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-05 17:59:51','563','2021-08-05 18:01:03',10,0),('1','143',215407,'DAILY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-05 18:10:22','563','2021-08-05 18:10:46',10,0),('1','143',215452,'DAILY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-06 18:15:54','563','2021-08-06 18:17:06',10,0),('1','143',215689,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-07 18:23:30','563','2021-08-07 18:24:58',10,0),('1','143',215971,'DAILY SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-08 14:39:00','563','2021-08-08 14:39:28',10,0),('1','143',216026,'DAILY SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-08 17:56:08','563','2021-08-08 17:56:57',10,0),('1','143',216112,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-09 18:02:12','563','2021-08-09 18:03:18',10,0),('1','143',216335,'DAILY SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-10 17:32:57','563','2021-08-10 17:34:11',10,0),('1','143',216576,'DAILY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-11 18:07:41','563','2021-08-11 18:08:17',10,0),('1','143',216795,'DAILY SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-12 17:38:10','563','2021-08-12 17:39:03',10,0),('1','143',217203,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-13 15:15:20','563','2021-08-13 15:15:46',10,0),('1','143',217204,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-13 18:13:28','563','2021-08-13 18:13:53',10,0),('1','143',217361,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-14 18:35:35','563','2021-08-14 18:36:05',10,0),('1','143',217509,'DAILY SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-15 20:45:45','563','2021-08-15 20:46:38',10,0),('1','143',217714,'DAILY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-16 17:47:04','563','2021-08-16 17:48:55',10,0),('1','143',218079,'DAILY SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-17 20:34:14','563','2021-08-17 20:35:20',10,0),('1','143',218234,'DAILY SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-18 18:01:46','563','2021-08-18 18:02:26',10,0),('1','143',218461,'DAILY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-19 17:49:33','563','2021-08-19 17:50:14',10,0),('1','143',218700,'DAILY SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-20 17:49:56','563','2021-08-20 17:50:19',10,0),('1','143',218913,'DAILY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-21 17:48:33','563','2021-08-21 17:49:06',10,0),('1','143',219077,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-21 17:56:03','563','2021-08-21 17:56:27',10,0),('1','143',219118,'DAILY SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-22 06:13:19','563','2021-08-22 06:13:39',10,0),('1','143',219135,'DAILY SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-22 18:08:22','563','2021-08-23 07:35:01',10,0),('1','143',219402,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-23 14:48:52','563','2021-08-23 14:53:54',10,0),('1','143',219517,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-23 17:21:42','563','2021-08-23 18:05:51',10,0),('1','143',219611,'DAILY SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-26 11:15:35','563','2021-08-26 11:16:08',10,0),('1','143',220134,'DAILY SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-26 11:30:24','563','2021-08-26 11:30:49',10,0),('1','143',220138,'DAILY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-26 17:53:43','563','2021-08-26 17:54:30',10,0),('1','143',220267,'DAILY SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-27 17:59:52','563','2021-08-27 18:00:17',10,0),('1','143',220519,'DAILY SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-28 17:53:03','563','2021-08-28 17:54:07',10,0),('1','143',220793,'DAILY SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-29 18:03:47','563','2021-08-29 18:04:17',10,0),('1','143',220999,'DAILY SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-08-30 17:59:27','563','2021-08-31 09:05:11',10,0),('1','143',221215,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-01 07:41:49','563','2021-09-01 07:42:29',10,0),('1','143',221453,'DAILY SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-01 18:05:41','563','2021-09-01 18:07:04',10,0),('1','143',221739,'DAILY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-02 17:58:29','563','2021-09-02 18:02:53',10,0),('1','143',221870,'DAILY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-03 17:48:08','563','2021-09-03 17:48:49',10,0),('1','143',222087,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-04 18:25:11','563','2021-09-05 05:31:30',10,0),('1','143',222281,'DAILY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-05 11:04:32','563','2021-09-05 11:05:09',10,0),('1','143',222353,'DAILY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-05 17:59:44','563','2021-09-05 18:00:21',10,0),('1','143',222535,'DAILY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-06 18:06:42','563','2021-09-06 18:07:18',10,0),('1','143',222775,'DAILY SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-07 18:09:59','563','2021-09-07 18:10:42',10,0),('1','143',222948,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-08 18:01:46','563','2021-09-08 18:02:56',10,0),('1','143',223208,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-09 18:01:57','563','2021-09-09 18:02:24',10,0),('1','143',223433,'DAILY SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-10 17:43:18','563','2021-09-10 17:43:59',10,0),('1','143',223661,'DAILY SHIFT                                +','2021-09-11','2021-09-11 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-11 18:09:51','563','2021-09-11 18:16:48',10,0),('1','143',223894,'DAILY SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-12 17:40:14','563','2021-09-12 17:41:03',10,0),('1','143',224134,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-13 17:37:21','563','2021-09-13 17:38:51',10,0),('1','143',224275,'DAILY SHIFT                               ','2021-09-13','2021-09-13 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-13 18:00:33','563','2021-09-13 18:01:41',10,0),('1','143',224323,'DAILY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-14 18:33:33','563','2021-09-14 18:34:25',10,0),('1','143',224618,'DAILY SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-15 18:05:32','563','2021-09-15 18:06:28',10,0),('1','143',224798,'DAILY SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-16 18:01:35','563','2021-09-17 07:10:02',10,0),('1','143',225037,'DAILY SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-17 18:00:52','563','2021-09-17 18:01:44',10,0),('1','143',225283,'DAILY SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-18 18:05:23','563','2021-09-18 18:06:36',10,0),('1','143',225489,'DAILY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-19 18:00:19','563','2021-09-19 18:01:12',10,0),('1','143',225792,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-21 06:56:05','563','2021-09-21 06:56:45',10,0),('1','143',225997,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-21 18:08:13','563','2021-09-21 19:40:10',10,0),('1','143',226216,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-21 20:02:46','563','2021-09-21 20:03:26',10,0),('1','143',226218,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-21 20:07:06','563','2021-09-21 20:07:29',10,0),('1','143',226264,'DAILY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-22 15:22:19','563','2021-09-22 15:23:55',10,0),('1','143',226410,'DAILY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-22 17:35:50','563','2021-09-22 17:36:40',10,0),('1','143',226447,'DAILY SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-22 19:51:07','563','2021-09-22 19:51:39',10,0),('1','143',226451,'DAILY SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-22 20:22:03','563','2021-09-22 20:22:32',10,0),('1','143',226452,'DAILY SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-22 20:32:52','563','2021-09-22 20:34:38',10,0),('1','143',226454,'DAILY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-22 20:52:02','563','2021-09-22 20:52:36',10,0),('1','143',226480,'DAILY SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-23 06:46:46','563','2021-09-23 06:47:11',10,0),('1','143',226483,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-23 06:52:58','563','2021-09-23 06:53:33',10,0),('1','143',226485,'DAILY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-23 06:59:43','563','2021-09-23 07:00:10',10,0),('1','143',226520,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-23 17:19:19','563','2021-09-23 17:24:23',10,0),('1','143',226685,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-23 17:41:02','563','2021-09-23 17:41:37',10,0),('1','143',226693,'DAILY SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-23 18:30:46','563','2021-09-23 18:31:05',10,0),('1','143',226694,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-23 18:35:11','563','2021-09-23 18:35:36',10,0),('1','143',226695,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-23 18:39:44','563','2021-09-23 18:40:06',10,0),('1','143',226696,'DAILY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-23 18:44:38','563','2021-09-23 18:46:10',10,0),('1','143',226794,'DAILY SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-24 17:42:44','563','2021-09-24 17:43:42',10,0),('1','143',227001,'DAILY SHIFT                                ','2021-09-25','2021-09-25 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-25 18:00:44','563','2021-09-25 18:01:26',10,0),('1','143',227208,'DAILY SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-26 18:01:10','563','2021-09-26 18:02:25',10,0),('1','143',227405,'DAILY SHIFT                                ','2021-09-27','2021-09-27 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-27 17:45:51','563','2021-09-27 17:46:29',10,0),('1','143',227622,'DAILY SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-28 17:53:32','563','2021-09-28 17:55:31',10,0),('1','143',227867,'DAILY SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-29 16:54:54','563','2021-09-29 16:55:21',10,0),('1','143',228068,'DAILY SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'563',0.00,0.00,'563','2021-09-29 18:00:10','563','2021-09-29 18:00:34',10,0),('1','143',228137,'DAILY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-01 07:36:55','563','2021-10-01 07:38:12',10,0),('1','143',228373,'DAILY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-01 19:02:55','563','2021-10-01 19:03:39',10,0),('1','143',228537,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-02 18:21:21','563','2021-10-02 18:22:20',10,0),('1','143',228786,'DAILY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-03 18:38:04','563','2021-10-03 18:38:32',10,0),('1','143',228970,'DAILY SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-04 17:41:52','563','2021-10-04 17:42:55',10,0),('1','143',229178,'DAILY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-05 18:00:02','563','2021-10-05 18:00:49',10,0),('1','143',229374,'DAILY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-05 18:08:53','563','2021-10-05 18:11:22',10,0),('1','143',229431,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-06 13:44:53','563','2021-10-06 13:49:32',10,0),('1','143',229583,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-06 18:09:46','563','2021-10-06 18:10:21',10,0),('1','143',229693,'DAILY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-07 08:20:37','563','2021-10-07 08:21:05',10,0),('1','143',229697,'DAILY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-07 18:47:50','563','2021-10-07 18:53:34',10,0),('1','143',229891,'DAILY SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-08 17:59:41','563','2021-10-08 18:03:54',10,0),('1','143',230092,'DAILY SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-09 17:12:53','563','2021-10-09 17:13:39',10,0),('1','143',230303,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-10 17:39:56','563','2021-10-10 17:43:03',10,0),('1','143',230533,'DAILY SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-11 18:02:22','563','2021-10-11 18:08:28',10,0),('1','143',230795,'DAILY SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-13 18:07:19','563','2021-10-13 18:07:54',10,0),('1','143',231337,'DAILY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-13 18:45:04','563','2021-10-13 18:45:41',10,0),('1','143',231384,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-14 17:38:09','563','2021-10-14 17:38:47',10,0),('1','143',231647,'DAILY SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-15 17:41:21','563','2021-10-15 17:41:57',10,0),('1','143',231909,'DAILY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-16 17:53:02','563','2021-10-16 17:57:51',10,0),('1','143',232107,'DAILY SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-17 17:52:05','563','2021-10-17 17:53:30',10,0),('1','143',232348,'DAILY SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-18 17:32:54','563','2021-10-18 17:33:39',10,0),('1','143',232600,'DAILY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-19 16:20:18','563','2021-10-19 16:21:47',10,0),('1','143',233209,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-21 17:35:35','563','2021-10-21 17:36:39',10,0),('1','143',233382,'DAILY SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-22 17:46:57','563','2021-10-22 17:47:45',10,0),('1','143',233618,'DAILY SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-23 17:26:19','563','2021-10-23 17:27:50',10,0),('1','143',233854,'DAILY SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-24 17:49:22','563','2021-10-24 17:50:22',10,0),('1','143',234067,'DAILY SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-25 17:34:55','563','2021-10-25 17:35:40',10,0),('1','143',234323,'DAILY SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-26 17:42:53','563','2021-10-26 17:43:59',10,0),('1','143',234574,'DAILY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-27 17:40:45','563','2021-10-27 17:41:40',10,0),('1','143',234842,'DAILY SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-28 17:35:20','563','2021-10-28 17:51:02',10,0),('1','143',235095,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-29 17:25:30','563','2021-10-29 17:26:31',10,0),('1','143',235312,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-30 15:52:26','563','2021-10-30 15:53:47',10,0),('1','143',235467,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-31 06:51:31','563','2021-10-31 06:52:50',10,0),('1','143',235551,'DAILY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'563',0.00,0.00,'563','2021-10-31 17:42:08','563','2021-10-31 17:43:05',10,0),('1','143',235776,'DAILY SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-01 19:04:43','563','2021-11-02 06:16:55',10,0),('1','143',236033,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-02 17:40:07','563','2021-11-02 17:45:13',10,0),('1','143',236248,'DAILY SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-03 17:15:13','563','2021-11-03 17:19:42',10,0),('1','143',236528,'DAILY SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-04 17:37:59','563','2021-11-04 17:38:33',10,0),('1','143',236752,'DAILY SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-05 17:31:15','563','2021-11-05 17:31:42',10,0),('1','143',236979,'DAILY SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-06 11:38:12','563','2021-11-06 11:38:38',10,0),('1','143',237051,'DAILY SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-06 17:04:24','563','2021-11-06 17:05:03',10,0),('1','143',237183,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-07 17:13:14','563','2021-11-07 17:13:56',10,0),('1','143',237395,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-08 17:21:57','563','2021-11-08 17:26:47',10,0),('1','143',237637,'DAILY SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-09 17:38:03','563','2021-11-09 17:38:37',10,0),('1','143',237912,'DAILY SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-10 17:23:33','563','2021-11-10 17:25:29',10,0),('1','143',238137,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-11 17:15:20','563','2021-11-11 17:15:52',10,0),('1','143',238379,'DAILY SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-12 17:05:27','563','2021-11-12 17:05:49',10,0),('1','143',238626,'DAILY SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-13 17:33:07','563','2021-11-13 17:33:37',10,0),('1','143',238850,'DAILY SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-14 17:52:41','563','2021-11-14 17:53:30',10,0),('1','143',239079,'DAILY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-15 06:39:50','563','2021-11-15 06:40:13',10,0),('1','143',239092,'DAILY SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-15 17:28:51','563','2021-11-15 17:29:13',10,0),('1','143',239316,'DAILY SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-17 06:39:20','563','2021-11-17 06:41:48',10,0),('1','143',239545,'DAILY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-17 17:13:21','563','2021-11-17 17:13:53',10,0),('1','143',239783,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-18 11:32:55','563','2021-11-18 11:33:20',10,0),('1','143',239874,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-18 17:18:53','563','2021-11-18 17:19:22',10,0),('1','143',240013,'DAILY SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-19 20:27:16','563','2021-11-19 20:27:51',10,0),('1','143',240226,'DAILY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-20 17:12:57','563','2021-11-20 17:13:46',10,0),('1','143',240468,'DAILY SHIFT ','2021-11-21','2021-11-21 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-21 17:13:13','563','2021-11-21 17:13:55',10,0),('1','143',240711,'DAILY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-22 18:38:22','563','2021-11-22 18:38:51',10,0),('1','143',240988,'DAILY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-23 17:26:50','563','2021-11-23 17:28:11',10,0),('1','143',241259,'DAILY SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-24 17:14:03','563','2021-11-24 17:14:32',10,0),('1','143',241512,'DAILY SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-25 18:24:07','563','2021-11-25 18:24:37',10,0),('1','143',241760,'DAILY SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-26 17:22:14','563','2021-11-26 17:23:55',10,0),('1','143',241996,'DAILY SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-27 18:14:43','563','2021-11-27 18:15:19',10,0),('1','143',242231,'DAILY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-28 17:25:42','563','2021-11-28 17:26:25',10,0),('1','143',242454,'DAILY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-29 18:47:33','563','2021-11-29 18:49:24',10,0),('1','143',242705,'DAILY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-11-30 18:03:30','563','2021-11-30 18:04:02',10,0),('1','143',242938,'DAILY SHIFT ','2021-12-01','2021-12-01 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-01 18:37:21','563','2021-12-01 18:39:35',10,0),('1','143',243167,'DAILY SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-02 12:28:58','563','2021-12-02 12:29:24',10,0),('1','143',243247,'DAILY SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-02 18:38:36','563','2021-12-02 18:39:29',10,0),('1','143',243389,'DAILY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-03 18:51:18','563','2021-12-03 18:52:23',10,0),('1','143',243616,'DAILY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-04 19:31:09','563','2021-12-04 19:31:57',10,0),('1','143',243863,'DAILY SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-05 19:01:15','563','2021-12-05 19:02:45',10,0),('1','143',244083,'DAILY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-06 18:53:35','563','2021-12-06 18:55:49',10,0),('1','143',244327,'DAILY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-07 19:11:33','563','2021-12-07 19:12:10',10,0),('1','143',244543,'DAILY SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-08 21:09:30','563','2021-12-08 21:16:41',10,0),('1','143',244762,'DAILY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-09 17:26:38','563','2021-12-09 17:27:24',10,0),('1','143',245006,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-10 15:03:39','563','2021-12-10 15:04:13',10,0),('1','143',245129,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-10 17:39:31','563','2021-12-10 17:44:10',10,0),('1','143',245256,'DAILY SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-11 17:07:19','563','2021-12-11 17:08:18',10,0),('1','143',245455,'DAILY SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-12 17:12:22','563','2021-12-12 17:12:50',10,0),('1','143',245698,'DAILY SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-13 17:34:08','563','2021-12-13 17:34:40',10,0),('1','143',245962,'DAILY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-14 17:22:00','563','2021-12-14 17:22:29',10,0),('1','143',246214,'DAILY SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-15 17:20:34','563','2021-12-15 17:21:06',10,0),('1','143',246483,'DAILY SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-16 17:28:59','563','2021-12-16 17:29:28',10,0),('1','143',246719,'DAILY SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-17 17:32:55','563','2021-12-17 17:33:36',10,0),('1','143',246963,'DAILY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-18 17:20:48','563','2021-12-18 17:21:56',10,0),('1','143',247187,'DAILY SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-19 17:30:30','563','2021-12-19 17:32:22',10,0),('1','143',247430,'DAILY SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-20 17:23:06','563','2021-12-20 17:23:39',10,0),('1','143',247694,'DAILY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-21 17:07:39','563','2021-12-21 17:08:16',10,0),('1','143',247935,'DAILY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-22 11:56:10','563','2021-12-22 11:57:19',10,0),('1','143',248021,'DAILY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-22 18:47:55','563','2021-12-22 18:48:45',10,0),('1','143',248198,'DAILY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-23 16:58:11','563','2021-12-23 16:58:37',10,0),('1','143',248329,'DAILY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-23 17:19:02','563','2021-12-23 17:19:28',10,0),('1','143',248430,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-24 17:35:07','563','2021-12-24 17:36:09',10,0),('1','143',248673,'DAILY SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-25 17:30:57','563','2021-12-25 17:31:57',10,0),('1','143',248901,'DAILY SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-26 17:07:07','563','2021-12-26 17:07:43',10,0),('1','143',249116,'DAILY SHIFT ','2021-12-27','2021-12-27 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-27 17:40:49','563','2021-12-27 17:42:07',10,0),('1','143',249368,'DAILY SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-28 17:37:50','563','2021-12-28 17:38:21',10,0),('1','143',249617,'DAILY SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-29 17:42:02','563','2021-12-29 17:42:30',10,0),('1','143',249879,'DAILY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-30 14:31:58','563','2021-12-30 14:32:26',10,0),('1','143',250011,'DAILY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-30 17:38:59','563','2021-12-30 17:39:38',10,0),('1','143',250039,'DAILY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-30 18:58:03','563','2021-12-30 18:58:24',10,0),('1','143',250042,'DAILY SHIFT                                +','2021-12-30','2021-12-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-30 19:03:52','563','2021-12-30 19:04:20',10,0),('1','143',250045,'DAILY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-30 19:08:12','563','2021-12-30 19:08:33',10,0),('1','143',250047,'DAILY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-30 19:17:04','563','2021-12-30 19:17:31',10,0),('1','143',250048,'DAILY SHIFT                                +','2021-12-30','2021-12-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-30 19:21:24','563','2021-12-30 19:21:47',10,0),('1','143',250049,'DAILY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-30 19:25:52','563','2021-12-30 19:26:18',10,0),('1','143',250115,'DAILY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'563',0.00,0.00,'563','2021-12-31 19:44:56','563','2021-12-31 19:45:40',10,0),('1','143',250342,'DAILY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-01 07:42:03','563','2022-01-01 07:42:27',10,0),('1','143',250374,'DAILY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-01 18:02:15','563','2022-01-01 18:02:45',10,0),('1','143',250575,'DAILY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-02 17:40:27','563','2022-01-02 17:40:53',10,0),('1','143',250819,'DAILY SHIFT ','2022-01-03','2022-01-03 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-03 17:10:19','563','2022-01-03 17:10:58',10,0),('1','143',251039,'DAILY SHIFT ','2022-01-04','2022-01-04 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-04 18:24:31','563','2022-01-04 18:25:03',10,0),('1','143',251287,'DAILY SHIFT ','2022-01-05','2022-01-05 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-05 18:26:01','563','2022-01-05 18:26:29',10,0),('1','143',251535,'DAILY SHIFT ','2022-01-06','2022-01-06 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-06 18:27:51','563','2022-01-06 18:28:45',10,0),('1','143',251793,'DAILY SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-07 18:25:54','563','2022-01-07 18:26:36',10,0),('1','143',252023,'DAILY SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-08 19:29:38','563','2022-01-08 19:31:01',10,0),('1','143',252262,'DAILY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-09 20:17:10','563','2022-01-09 20:17:55',10,0),('1','143',252498,'DAILY SHIFT ','2022-01-10','2022-01-10 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-10 18:59:11','563','2022-01-10 19:00:04',10,0),('1','143',252735,'DAILY SHIFT ','2022-01-11','2022-01-11 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-11 18:36:11','563','2022-01-11 18:36:42',10,0),('1','143',252993,'DAILY SHIFT ','2022-01-12','2022-01-12 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-12 20:30:10','563','2022-01-12 20:30:43',10,0),('1','143',253224,'DAILY SHIFT ','2022-01-13','2022-01-13 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-13 11:00:04','563','2022-01-13 11:00:26',10,0),('1','143',253306,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-13 21:04:16','563','2022-01-13 21:06:28',10,0),('1','143',253497,'DAILY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-14 18:43:13','563','2022-01-14 18:44:01',10,0),('1','143',253734,'DAILY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-15 18:35:30','563','2022-01-15 18:36:05',10,0),('1','143',253983,'DAILY SHIFT ','2022-01-16','2022-01-16 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-16 18:41:43','563','2022-01-16 18:43:00',10,0),('1','143',254226,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-17 18:51:11','563','2022-01-17 18:51:56',10,0),('1','143',254463,'DAILY SHIFT ','2022-01-18','2022-01-18 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-18 19:27:07','563','2022-01-18 19:28:10',10,0),('1','143',254728,'DAILY SHIFT ','2022-01-19','2022-01-19 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-19 18:52:29','563','2022-01-19 18:52:55',10,0),('1','143',254979,'DAILY SHIFT ','2022-01-20','2022-01-20 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-20 18:24:25','563','2022-01-20 18:25:47',10,0),('1','143',255224,'DAILY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-21 19:12:37','563','2022-01-21 19:15:57',10,0),('1','143',255490,'DAILY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-22 19:39:10','563','2022-01-22 19:43:37',10,0),('1','143',255730,'DAILY SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-23 18:44:53','563','2022-01-23 18:45:29',10,0),('1','143',255991,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-24 13:20:55','563','2022-01-24 13:22:14',10,0),('1','143',256075,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-24 19:56:09','563','2022-01-24 19:58:48',10,0),('1','143',256232,'DAILY SHIFT ','2022-01-25','2022-01-25 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-25 18:23:40','563','2022-01-25 18:24:52',10,0),('1','143',256513,'DAILY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-26 18:13:55','563','2022-01-26 20:11:50',10,0),('1','143',256754,'DAILY SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-27 18:14:31','563','2022-01-27 18:16:11',10,0),('1','143',256992,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-28 18:30:12','563','2022-01-28 18:31:15',10,0),('1','143',257252,'DAILY SHIFT ','2022-01-29','2022-01-29 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-29 18:27:05','563','2022-01-29 18:27:54',10,0),('1','143',257417,'DAILY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-29 18:36:18','563','2022-01-29 18:36:52',10,0),('1','143',257441,'DAILY SHIFT ','2022-01-29','2022-01-29 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-29 20:42:04','563','2022-01-29 20:42:30',10,0),('1','143',257514,'DAILY SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-30 18:40:42','563','2022-01-30 18:41:23',10,0),('1','143',257515,'DAILY SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'563',0.00,0.00,'563','2022-01-31 18:27:40','563','2022-01-31 18:28:06',10,0),('1','143',257516,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-01 13:55:40','563','2022-02-01 13:56:32',10,0),('1','143',257517,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-01 18:43:46','563','2022-02-01 18:44:04',10,0),('1','143',257518,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-02 11:59:10','563','2022-02-02 11:59:50',10,0),('1','143',257519,'DAILY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-05 19:20:02','563','2022-02-05 19:20:24',10,0),('1','143',257520,'DAILY SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-06 19:03:44','563','2022-02-06 19:04:06',10,0),('1','143',257521,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-07 18:56:09','563','2022-02-07 18:56:32',10,0),('1','143',257522,'DAILY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-08 22:04:37','563','2022-02-08 22:06:14',10,0),('1','143',257523,'DAILY SHIFT ','2022-02-09','2022-02-09 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-09 18:58:40','563','2022-02-09 18:59:19',10,0),('1','143',257524,'DAILY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-10 18:54:57','563','2022-02-10 18:55:17',10,0),('1','143',257525,'DAILY SHIFT ','2022-02-11','2022-02-11 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-11 19:31:00','563','2022-02-11 19:31:22',10,0),('1','143',257526,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-12 21:09:25','563','2022-02-12 21:10:07',10,0),('1','143',257527,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-13 19:09:36','563','2022-02-13 19:09:59',10,0),('1','143',257528,'DAILY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-14 09:12:14','563','2022-02-14 09:12:55',10,0),('1','143',257529,'DAILY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-14 19:10:33','563','2022-02-14 19:10:56',10,0),('1','143',257530,'DAILY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-15 18:45:59','563','2022-02-15 18:46:30',10,0),('1','143',257531,'DAILY SHIFT79189','2022-02-16','2022-02-16 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-16 19:20:08','563','2022-02-16 19:20:30',10,0),('1','143',257532,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-17 21:22:45','563','2022-02-17 21:23:03',10,0),('1','143',257533,'DAILY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-18 18:47:43','563','2022-02-18 18:48:26',10,0),('1','143',257534,'DAILY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-19 18:08:06','563','2022-02-19 18:08:34',10,0),('1','143',257535,'DAILY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-19 18:16:56','563','2022-02-19 18:17:17',10,0),('1','143',257536,'DAILY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-19 18:30:42','563','2022-02-19 18:31:01',10,0),('1','143',257537,'DAILY SHIFT                                ','2022-02-20','2022-02-20 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-20 18:36:16','563','2022-02-20 18:36:52',10,0),('1','143',257538,'DAILY SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'563',0.00,0.00,'563','2022-02-21 18:27:05','563','2022-02-21 18:27:24',10,0),('1','143',257539,'DAILY SHIFT','2022-02-22','2022-02-22 08:09:32','2022-02-23 08:09:32','563',0.00,0.00,'563','2022-02-22 18:46:25','563','2022-02-22 18:47:01',10,0),('1','143',257540,'DAILY SHIFT','2022-02-23','2022-02-23 08:25:58','2022-02-24 08:25:58','563',0.00,0.00,'563','2022-02-23 18:25:32','563','2022-02-23 18:26:12',10,0),('1','143',257541,'DAILY SHIFT','2022-02-24','2022-02-24 08:10:06','2022-02-25 08:10:06','563',0.00,0.00,'563','2022-02-24 18:45:39','563','2022-02-24 18:45:58',10,0),('1','143',257542,'DAILY SHIFT ','2022-02-25','2022-02-25 08:01:39','2022-02-26 08:01:39','563',0.00,0.00,'563','2022-02-25 18:21:22','563','2022-02-25 18:21:52',10,0),('1','143',257543,'DAILY SHIFT','2022-02-26','2022-02-26 08:07:36','2022-02-27 08:07:36','563',0.00,0.00,'563','2022-02-26 18:29:14','563','2022-02-26 18:29:38',10,0),('1','143',257544,'DAILY SHIFT','2022-02-27','2022-02-27 08:24:53','2022-02-28 08:24:53','563',0.00,0.00,'563','2022-02-27 19:00:32','563','2022-02-27 19:01:01',10,0),('1','143',257545,'DAILY SHIFT','2022-02-28','2022-02-28 08:19:48','2022-03-01 08:19:48','563',0.00,0.00,'563','2022-02-28 18:31:10','563','2022-02-28 18:31:32',10,0),('1','143',257546,'Daily shift ','2022-03-01','2022-03-01 08:25:17','2022-03-02 08:25:17','563',0.00,0.00,'563','2022-03-01 18:55:16','563','2022-03-01 19:03:48',10,0),('1','143',257547,'DAILY SHIFT','2022-03-02','2022-03-02 08:24:14','2022-03-03 08:24:14','563',0.00,0.00,'563','2022-03-02 21:55:22','563','2022-03-02 21:55:48',10,0),('1','143',257548,'DAILY SHIFT','2022-03-03','2022-03-03 08:20:48','2022-03-04 08:20:48','563',0.00,0.00,'563','2022-03-03 11:31:55','563','2022-03-03 11:32:11',10,0),('1','143',257549,'DAILY SHIFT','2022-03-03','2022-03-03 11:32:38','2022-03-04 11:32:38','563',0.00,0.00,'563','2022-03-03 18:27:33','563','2022-03-03 18:29:51',10,0),('1','143',257550,'DAILY SHIFT','2022-03-04','2022-03-04 08:01:24','2022-03-05 08:01:24','563',0.00,0.00,'563','2022-03-04 18:49:45','563','2022-03-04 18:50:41',10,0),('1','143',257551,'DAILY SHIFT','2022-03-05','2022-03-05 08:29:47','2022-03-06 08:29:47','563',0.00,0.00,'563','2022-03-05 18:48:03','563','2022-03-05 18:48:26',10,0),('1','143',257552,'DAILY SHIFT','2022-03-06','2022-03-06 08:04:55','2022-03-07 08:04:55','563',0.00,0.00,'563','2022-03-06 18:48:56','563','2022-03-06 18:49:53',10,0),('1','143',257553,'DAILY SHIFT ','2022-03-06','2022-03-06 23:17:00','2022-03-07 23:17:00','563',0.00,0.00,'563','2022-03-06 23:28:24','563','2022-03-06 23:28:44',10,0),('1','143',257554,'DAILY SHIFT','2022-03-07','2022-03-07 08:26:13','2022-03-08 08:26:13','563',0.00,0.00,'563','2022-03-07 18:19:28','563','2022-03-07 18:21:08',10,0),('1','143',257555,'DAILY SHIFT','2022-03-08','2022-03-08 08:07:20','2022-03-09 08:07:20','563',0.00,0.00,'563','2022-03-08 18:21:57','563','2022-03-08 18:22:31',10,0),('1','143',257556,'DAILY SHIFT ','2022-03-09','2022-03-09 07:30:56','2022-03-10 07:30:56','563',0.00,0.00,'563','2022-03-09 18:47:58','563','2022-03-09 18:48:22',10,0),('1','143',257557,'DAILY SHIFT','2022-03-10','2022-03-10 08:03:43','2022-03-11 08:03:43','563',0.00,0.00,'563','2022-03-10 18:25:39','563','2022-03-10 18:26:10',10,0),('1','143',257558,'DAILY SHIFT','2022-03-11','2022-03-11 08:24:30','2022-03-12 08:24:30','563',0.00,0.00,'563','2022-03-11 18:58:23','563','2022-03-11 18:58:50',10,0),('1','143',257559,'DAILY SHIFT','2022-03-12','2022-03-12 08:02:12','2022-03-13 08:02:12','563',0.00,0.00,'563','2022-03-12 21:09:57','563','2022-03-12 21:10:17',10,0),('1','143',257560,'DAILY SHIFT','2022-03-13','2022-03-13 08:06:49','2022-03-14 08:06:49','563',0.00,0.00,'563','2022-03-13 18:41:14','563','2022-03-13 18:41:37',10,0),('1','143',257561,'DAILY SHIFT ','2022-03-14','2022-03-14 08:00:44','2022-03-15 08:00:44','563',0.00,0.00,'563','2022-03-14 18:54:02','563','2022-03-14 18:54:58',10,0),('1','143',257562,'DAILY SHIFT','2022-03-15','2022-03-15 08:19:18','2022-03-16 08:19:18','563',0.00,0.00,'563','2022-03-15 18:47:51','563','2022-03-15 18:48:14',10,0),('1','143',257563,'DAILY SHIFT','2022-03-16','2022-03-16 08:13:19','2022-03-17 08:13:19','563',0.00,0.00,'563','2022-03-16 20:49:48','563','2022-03-16 20:50:06',10,0),('1','143',257564,'DAILY SHIFT ','2022-03-17','2022-03-17 08:01:32','2022-03-18 08:01:32','563',0.00,0.00,'563','2022-03-17 18:39:04','563','2022-03-17 18:39:30',10,0),('1','143',257565,'DAILY SHIFT','2022-03-18','2022-03-18 08:10:42','2022-03-19 08:10:42','563',0.00,0.00,'563','2022-03-18 18:39:08','563','2022-03-18 18:39:29',10,0),('1','143',257566,'DAILY SHIFT ','2022-03-19','2022-03-19 07:55:04','2022-03-20 07:55:04','563',0.00,0.00,'563','2022-03-19 18:47:36','563','2022-03-19 18:47:58',10,0),('1','143',257567,'DAILY SHIFT','2022-03-20','2022-03-20 08:16:17','2022-03-21 08:16:17','563',0.00,0.00,'563','2022-03-20 21:28:51','563','2022-03-20 21:29:08',10,0),('1','143',257568,'DAILY SHIFT','2022-03-21','2022-03-21 08:13:22','2022-03-22 08:13:22','563',0.00,0.00,'563','2022-03-21 18:32:24','563','2022-03-21 18:32:44',10,0),('1','143',257569,'DAILY SHIFT','2022-03-22','2022-03-22 07:57:53','2022-03-23 07:57:53','563',0.00,0.00,'563','2022-03-22 18:39:30','563','2022-03-22 18:39:50',10,0),('1','143',257570,'DAILY SHIFT ','2022-03-23','2022-03-23 08:02:32','2022-03-24 08:02:32','563',0.00,0.00,'563','2022-03-23 12:54:30','563','2022-03-23 12:54:53',10,0),('1','143',257571,'DAILY SHIFT','2022-03-23','2022-03-23 12:55:19','2022-03-24 12:55:19','563',0.00,0.00,'563','2022-03-23 18:33:12','563','2022-03-23 18:33:37',10,0),('1','143',257572,'DAILY SHIFT','2022-03-24','2022-03-24 07:54:03','2022-03-25 07:54:03','563',0.00,0.00,'563','2022-03-24 10:08:55','563','2022-03-24 10:09:23',10,0),('1','143',257573,'DAILY SHIFT','2022-03-24','2022-03-24 10:09:58','2022-03-25 10:09:58','563',0.00,0.00,'563','2022-03-24 18:59:08','563','2022-03-24 18:59:28',10,0),('1','143',257574,'DAILY SHIFT','2022-03-25','2022-03-25 08:19:47','2022-03-26 08:19:47','563',0.00,0.00,'563','2022-03-25 18:39:18','563','2022-03-25 18:39:44',10,0),('1','143',257575,'DAILY SHIFT','2022-03-26','2022-03-26 08:14:44','2022-03-27 08:14:44','563',0.00,0.00,'563','2022-03-26 18:37:50','563','2022-03-26 18:38:20',10,0),('1','143',257576,'DAILY SHIFT','2022-03-27','2022-03-27 08:02:07','2022-03-28 08:02:07','563',0.00,0.00,'563','2022-03-27 18:30:13','563','2022-03-27 18:30:34',10,0),('1','143',257577,'DAILY SHIFT','2022-03-28','2022-03-28 08:38:04','2022-03-29 08:38:04','563',0.00,0.00,'563','2022-03-28 18:39:52','563','2022-03-28 18:40:13',10,0),('1','143',257578,'DAILY SHIFT','2022-03-29','2022-03-29 08:05:07','2022-03-30 08:05:07','563',0.00,0.00,'563','2022-03-29 18:48:52','563','2022-03-29 18:49:13',10,0),('1','143',257579,'DAILY SHIFT ','2022-03-30','2022-03-30 07:53:39','2022-03-31 07:53:39','563',0.00,0.00,'563','2022-03-30 18:55:15','563','2022-03-30 18:55:37',10,0),('1','143',257580,'DAILY SHIFT ','2022-03-31','2022-03-31 08:09:59','2022-04-01 08:09:59','563',0.00,0.00,'563','2022-03-31 19:20:30','563','2022-03-31 19:20:47',10,0),('1','143',257581,'DAILY SHIFT ','2022-04-01','2022-04-01 07:45:59','2022-04-02 07:45:59','563',0.00,0.00,'563','2022-04-01 19:54:54','563','2022-04-01 19:55:17',10,0),('1','143',257582,'DAILY SHIFT','2022-04-02','2022-04-02 08:13:52','2022-04-03 08:13:52','563',0.00,0.00,'563','2022-04-02 11:01:53','563','2022-04-02 11:02:17',10,0),('1','143',257583,'DAILY SHIFT','2022-04-02','2022-04-02 11:03:37','2022-04-03 11:03:37','563',0.00,0.00,'563','2022-04-02 15:33:09','563','2022-04-02 15:33:31',10,0),('1','143',257584,'DAILY SHIFT','2022-04-08','2022-04-08 12:41:10','2022-04-09 12:41:10','563',0.00,0.00,'563','2022-04-08 12:41:37','563','2022-04-08 12:42:08',10,0),('1','143',257585,'DAILY SHIFT','2022-04-08','2022-04-08 12:42:43','2022-04-09 12:42:43','563',0.00,0.00,'563','2022-04-08 19:07:51','563','2022-04-08 19:08:07',10,0),('1','143',257586,'DAILY SHIFT','2022-04-09','2022-04-09 08:57:24','2022-04-10 08:57:24','563',0.00,0.00,'563','2022-04-09 18:18:19','563','2022-04-09 18:18:43',10,0),('1','143',257587,'DAILY SHIFT ','2022-04-10','2022-04-10 08:55:10','2022-04-11 08:55:10','563',0.00,0.00,'563','2022-04-10 13:37:21','563','2022-04-10 13:37:44',10,0),('1','143',257588,'DAILY SHIFT','2022-04-10','2022-04-10 13:38:06','2022-04-11 13:38:06','563',0.00,0.00,'563','2022-04-10 18:17:35','563','2022-04-10 18:17:56',10,0),('1','143',257589,'DAILY SHIFT','2022-04-11','2022-04-11 09:51:04','2022-04-12 09:51:04','563',0.00,0.00,'563','2022-04-11 18:00:00','563','2022-04-11 18:00:23',10,0),('1','143',257590,'DAILY SHIFT','2022-04-12','2022-04-12 09:13:14','2022-04-13 09:13:14','563',0.00,0.00,'563','2022-04-12 18:27:07','563','2022-04-12 18:27:28',10,0),('1','143',257591,'DAILY SHIFT','2022-04-13','2022-04-13 09:51:18','2022-04-14 09:51:18','563',0.00,0.00,'563','2022-04-13 17:57:30','563','2022-04-13 17:57:46',10,0),('1','143',257592,'DAILY SHIFT ','2022-04-14','2022-04-14 09:51:12','2022-04-15 09:51:12','563',0.00,0.00,'563','2022-04-14 18:23:11','563','2022-04-14 18:23:36',10,0),('1','143',257593,'DAILY SHIFT','2022-04-15','2022-04-15 09:52:15','2022-04-16 09:52:15','563',0.00,0.00,'563','2022-04-15 18:05:37','563','2022-04-15 18:05:57',10,0),('1','143',257594,'DAILY SHIFT','2022-04-16','2022-04-16 09:36:16','2022-04-17 09:36:16','563',0.00,0.00,'563','2022-04-16 17:49:51','563','2022-04-16 17:50:08',10,0),('1','143',257595,'DAILY SHIFT','2022-04-17','2022-04-17 09:16:22','2022-04-18 09:16:22','563',0.00,0.00,'563','2022-04-17 18:24:56','563','2022-04-17 18:26:23',10,0),('1','143',257596,'DAILY SHIFT','2022-04-18','2022-04-18 09:02:28','2022-04-19 09:02:28','563',0.00,0.00,'563','2022-04-18 18:52:23','563','2022-04-18 18:52:42',10,0),('1','143',257597,'DAILY SHIFT','2022-04-19','2022-04-19 11:00:26','2022-04-20 11:00:26','563',0.00,0.00,'563','2022-04-19 15:22:46','563','2022-04-19 15:23:04',10,0),('1','143',257598,'DAILY SHIFT','2022-04-19','2022-04-19 15:23:24','2022-04-20 15:23:24','563',0.00,0.00,'563','2022-04-19 21:45:39','563','2022-04-19 21:46:02',10,0),('1','143',257599,'DAILY SHIFT','2022-04-20','2022-04-20 08:57:43','2022-04-21 08:57:43','563',0.00,0.00,'563','2022-04-20 18:19:53','563','2022-04-20 18:20:10',10,0),('1','143',257600,'DAILY SHIFT ','2022-04-21','2022-04-21 09:51:02','2022-04-22 09:51:02','563',0.00,0.00,'563','2022-04-21 18:05:40','563','2022-04-21 18:05:59',10,0),('1','143',257601,'DAILY SHIFT','2022-04-22','2022-04-22 08:53:29','2022-04-23 08:53:29','563',0.00,0.00,'563','2022-04-22 18:35:40','563','2022-04-22 18:36:01',10,0),('1','143',257602,'DAILY SHIFT','2022-04-23','2022-04-23 08:50:24','2022-04-24 08:50:24','563',0.00,0.00,'563','2022-04-23 18:38:54','563','2022-04-23 18:39:13',10,0),('1','143',257603,'DAILY SHIFT','2022-04-24','2022-04-24 10:29:55','2022-04-25 10:29:55','563',0.00,0.00,'563','2022-04-24 18:05:42','563','2022-04-24 18:05:59',10,0),('1','143',257604,'DAILY SHIFT','2022-04-25','2022-04-25 09:29:00','2022-04-26 09:29:00','563',0.00,0.00,'563','2022-04-25 18:25:15','563','2022-04-25 18:25:33',10,0),('1','143',257605,'DAILY SHIFT','2022-04-26','2022-04-26 09:13:25','2022-04-27 09:13:25','563',0.00,0.00,'563','2022-04-26 18:13:35','563','2022-04-26 18:13:56',10,0),('1','143',257606,'DAILY SHIFT','2022-04-27','2022-04-27 09:03:51','2022-04-28 09:03:51','563',0.00,0.00,'563','2022-04-27 18:13:00','563','2022-04-27 18:13:19',10,0),('1','143',257607,'DAILY SHIFT','2022-04-28','2022-04-28 09:26:42','2022-04-29 09:26:42','563',0.00,0.00,'563','2022-04-28 18:01:33','563','2022-04-28 18:01:53',10,0),('1','143',257608,'DAILY SHIFT','2022-04-29','2022-04-29 09:19:16','2022-04-30 09:19:16','563',0.00,0.00,'563','2022-04-29 18:26:41','563','2022-04-29 18:27:02',10,0),('1','143',257609,'DAILY SHIFT','2022-04-30','2022-04-30 10:03:48','2022-05-01 10:03:48','563',0.00,0.00,'563','2022-04-30 18:44:02','563','2022-04-30 18:44:33',10,0),('1','143',257610,'DAILY SHIFT','2022-05-01','2022-05-01 09:37:38','2022-05-02 09:37:38','563',0.00,0.00,'563','2022-05-01 18:39:07','563','2022-05-01 18:39:44',10,0),('1','143',257611,'DAILY SHIFT','2022-05-02','2022-05-02 12:12:05','2022-05-03 12:12:05','563',0.00,0.00,'563','2022-05-02 20:52:44','563','2022-05-02 20:53:06',10,0),('1','143',257612,'DAILY SHIFT','2022-05-03','2022-05-03 09:09:14','2022-05-04 09:09:14','563',0.00,0.00,'563','2022-05-03 18:28:29','563','2022-05-03 18:28:52',10,0),('1','143',257613,'DAILY SHIFT','2022-05-04','2022-05-04 09:05:25','2022-05-05 09:05:25','563',0.00,0.00,'563','2022-05-04 18:29:02','563','2022-05-04 18:29:28',10,0),('1','143',257614,'DAILY SHIFT','2022-05-05','2022-05-05 08:58:55','2022-05-06 08:58:55','563',0.00,0.00,'563','2022-05-05 20:01:33','563','2022-05-05 20:01:51',10,0),('1','143',257615,'DAILY SHIFT','2022-05-06','2022-05-06 08:28:21','2022-05-07 08:28:21','563',0.00,0.00,'563','2022-05-06 11:20:02','563','2022-05-06 11:20:34',10,0),('1','143',257616,'DAILY SHIFT','2022-05-06','2022-05-06 11:21:00','2022-05-07 11:21:00','563',0.00,0.00,'563','2022-05-06 17:50:25','563','2022-05-06 17:50:42',10,0),('1','143',257617,'DAILY SHIFT','2022-05-07','2022-05-07 08:35:17','2022-05-08 08:35:17','563',0.00,0.00,'563','2022-05-08 07:45:47','563','2022-05-08 07:46:05',10,0),('1','143',257618,'DAILY SHIFT','2022-05-08','2022-05-08 07:46:42','2022-05-09 07:46:42','563',0.00,0.00,'563','2022-05-08 18:26:43','563','2022-05-08 18:27:08',10,0),('1','143',257619,'DAILY SHIFT ','2022-05-09','2022-05-09 07:53:22','2022-05-10 07:53:22','563',0.00,0.00,'563','2022-05-09 18:18:16','563','2022-05-09 18:18:33',10,0),('1','143',257620,'DAILY SHIFT ','2022-05-10','2022-05-10 07:25:04','2022-05-11 07:25:04','563',0.00,0.00,'563','2022-05-10 19:49:12','563','2022-05-10 19:49:30',10,0),('1','143',257621,'DAILY SHIFT','2022-05-11','2022-05-11 07:30:35','2022-05-12 07:30:35','563',0.00,0.00,'563','2022-05-11 18:42:05','563','2022-05-11 18:42:34',10,0),('1','143',257622,'DAILY SHIFT ','2022-05-12','2022-05-12 07:20:56','2022-05-13 07:20:56','563',0.00,0.00,'563','2022-05-12 18:34:06','563','2022-05-12 18:34:44',10,0),('1','143',257623,'DAILY SHIFT','2022-05-13','2022-05-13 07:44:05','2022-05-14 07:44:05','563',0.00,0.00,'563','2022-05-13 18:37:55','563','2022-05-13 18:38:14',10,0),('1','143',257624,'DAILY SHIFT ','2022-05-14','2022-05-14 07:41:47','2022-05-15 07:41:47','563',0.00,0.00,'563','2022-05-14 17:42:52','563','2022-05-14 17:43:27',10,0),('1','143',257625,'DAILY SHIFT','2022-05-16','2022-05-16 10:52:33','2022-05-17 10:52:33','563',0.00,0.00,'563','2022-05-16 18:03:04','563','2022-05-16 18:03:46',10,0),('1','143',257626,'DAILY SHIFT','2022-05-17','2022-05-17 07:54:53','2022-05-18 07:54:53','563',0.00,0.00,'563','2022-05-17 11:56:18','563','2022-05-17 11:56:38',10,0),('1','143',257627,'DAILY SHIFT','2022-05-17','2022-05-17 11:57:09','2022-05-18 11:57:09','563',0.00,0.00,'563','2022-05-17 21:48:03','563','2022-05-17 21:48:25',10,0),('1','143',257628,'DAILY SHIFT','2022-05-18','2022-05-18 07:47:57','2022-05-19 07:47:57','563',0.00,0.00,'563','2022-05-18 18:28:56','563','2022-05-18 18:29:12',10,0),('1','143',257629,'DAILY SHIFT ','2022-05-19','2022-05-19 08:06:09','2022-05-20 08:06:09','563',0.00,0.00,'563','2022-05-19 18:24:35','563','2022-05-19 18:24:56',10,0),('1','143',257630,'DAILY SHIFT','2022-05-20','2022-05-20 08:50:21','2022-05-21 08:50:21','563',0.00,0.00,'563','2022-05-21 06:44:05','563','2022-05-21 06:45:06',10,0),('1','143',257631,'DAILY SHIFT ','2022-05-21','2022-05-21 08:17:12','2022-05-22 08:17:12','563',0.00,0.00,'563','2022-05-21 20:20:05','563','2022-05-21 20:20:25',10,0),('1','143',257632,'DAILY SHIFT','2022-05-22','2022-05-22 07:40:22','2022-05-23 07:40:22','563',0.00,0.00,'563','2022-05-22 18:23:08','563','2022-05-22 18:23:34',10,0),('1','143',257633,'DAILY SHIFT','2022-05-23','2022-05-23 08:04:12','2022-05-24 08:04:12','563',0.00,0.00,'563','2022-05-23 18:56:43','563','2022-05-23 18:57:03',10,0),('1','143',257634,'DAILY SHIFT','2022-05-24','2022-05-24 08:04:49','2022-05-25 08:04:49','563',0.00,0.00,'563','2022-05-24 18:45:26','563','2022-05-24 18:45:43',10,0),('1','143',257635,'DAILY SHIFT ','2022-05-25','2022-05-25 07:50:39','2022-05-26 07:50:39','563',0.00,0.00,'563','2022-05-25 20:14:49','563','2022-05-25 20:15:19',10,0),('1','143',257636,'DAILY SHIFT ','2022-05-26','2022-05-26 07:37:42','2022-05-27 07:37:42','563',0.00,0.00,'563','2022-05-26 18:19:11','563','2022-05-26 18:19:53',10,0),('1','143',257637,'DAILY SHIFT ','2022-05-27','2022-05-27 07:44:12','2022-05-28 07:44:12','563',0.00,0.00,'563','2022-05-27 18:30:59','563','2022-05-27 18:31:17',10,0),('1','143',257638,'DAILY SHIFT ','2022-05-28','2022-05-28 07:53:18','2022-05-29 07:53:18','563',0.00,0.00,'563','2022-05-28 18:07:08','563','2022-05-28 18:07:43',10,0),('1','143',257639,'DAILY SHIFT','2022-05-29','2022-05-29 08:10:12','2022-05-30 08:10:12','563',0.00,0.00,'563','2022-05-29 18:45:21','563','2022-05-29 18:45:45',10,0),('1','143',257640,'DAILY SHIFT ','2022-05-30','2022-05-30 07:40:15','2022-05-31 07:40:15','563',0.00,0.00,'563','2022-05-30 17:59:33','563','2022-05-30 17:59:55',10,0),('1','143',257641,'DAILY SHIFT','2022-05-31','2022-05-31 07:53:12','2022-06-01 07:53:12','563',0.00,0.00,'563','2022-05-31 09:50:08','563','2022-05-31 09:50:27',10,0),('1','143',257642,'DAILY SHIFT','2022-05-31','2022-05-31 09:50:49','2022-06-01 09:50:49','563',0.00,0.00,'563','2022-05-31 18:29:02','563','2022-05-31 18:29:31',10,0),('1','143',257643,'DAILY SHIFT ','2022-06-01','2022-06-01 07:30:32','2022-06-02 07:30:32','563',0.00,0.00,'563','2022-06-01 19:21:59','563','2022-06-01 19:22:39',10,0),('1','143',257644,'DAILY SHIFT','2022-06-02','2022-06-02 07:38:11','2022-06-03 07:38:11','563',0.00,0.00,'563','2022-06-02 19:01:30','563','2022-06-02 19:02:00',10,0),('1','143',257645,'DAILY SHIFT ','2022-06-03','2022-06-03 07:33:51','2022-06-04 07:33:51','563',0.00,0.00,'563','2022-06-03 19:01:14','563','2022-06-03 19:01:36',10,0),('1','143',257646,'DAILY SHIFT ','2022-06-04','2022-06-04 07:36:25','2022-06-05 07:36:25','563',0.00,0.00,'563','2022-06-04 18:04:44','563','2022-06-04 18:05:00',10,0),('1','143',257647,'DAILY SHIFT ','2022-06-05','2022-06-05 07:57:30','2022-06-06 07:57:30','563',0.00,0.00,'563','2022-06-05 19:25:35','563','2022-06-05 19:25:55',10,0),('1','143',257648,'DAILY SHIFT ','2022-06-06','2022-06-06 07:34:22','2022-06-07 07:34:22','563',0.00,0.00,'563','2022-06-06 19:15:51','563','2022-06-06 19:16:16',10,0),('1','143',257649,'DAILY SHIFT ','2022-06-07','2022-06-07 08:02:01','2022-06-08 08:02:01','563',0.00,0.00,'563','2022-06-07 18:59:54','563','2022-06-07 19:00:20',10,0),('1','143',257650,'DAILY SHIFT                                +','2022-06-08','2022-06-08 07:58:30','2022-06-09 07:58:30','563',0.00,0.00,'563','2022-06-08 18:47:23','563','2022-06-08 18:47:46',10,0),('1','143',257651,'DAILY SHIFT','2022-06-09','2022-06-09 07:41:53','2022-06-10 07:41:53','563',0.00,0.00,'563','2022-06-09 19:24:25','563','2022-06-09 19:24:45',10,0),('1','143',257652,'DAILY SHIFT','2022-06-10','2022-06-10 07:50:17','2022-06-11 07:50:17','563',0.00,0.00,'563','2022-06-10 18:34:07','563','2022-06-10 18:34:28',10,0),('1','143',257653,'DAILY SHIFT                                ','2022-06-11','2022-06-11 08:18:29','2022-06-12 08:18:29','563',0.00,0.00,'563','2022-06-11 19:09:19','563','2022-06-11 19:10:11',10,0),('1','143',257654,'DAILY SHIFT                                +','2022-06-12','2022-06-12 08:22:30','2022-06-13 08:22:30','563',0.00,0.00,'563','2022-06-12 17:50:56','563','2022-06-12 17:51:21',10,0),('1','143',257655,'DAILY SHIFT                                ','2022-06-13','2022-06-13 08:02:18','2022-06-14 08:02:18','563',0.00,0.00,'563','2022-06-13 15:05:26','563','2022-06-13 15:05:48',10,0),('1','143',257656,'DAILY SHIFT','2022-06-13','2022-06-13 15:06:34','2022-06-14 15:06:34','563',0.00,0.00,'563','2022-06-13 18:59:30','563','2022-06-14 07:48:54',10,0),('1','143',257657,'DAILY SHIFT                                +','2022-06-14','2022-06-14 07:49:21','2022-06-15 07:49:21','563',0.00,0.00,'563','2022-06-14 18:57:55','563','2022-06-14 18:58:12',10,0),('1','143',257658,'DAILY SHIFT','2022-06-15','2022-06-15 07:51:16','2022-06-16 07:51:16','563',0.00,0.00,'563','2022-06-15 18:31:36','563','2022-06-15 18:32:01',10,0),('1','143',257659,'DAILY SHIFT                                +','2022-06-16','2022-06-16 08:20:34','2022-06-17 08:20:34','563',0.00,0.00,'563','2022-06-16 14:58:08','563','2022-06-16 14:58:43',10,0),('1','143',257660,'DAILY SHIFT','2022-06-16','2022-06-16 14:59:18','2022-06-17 14:59:18','563',0.00,0.00,'563','2022-06-16 18:37:34','563','2022-06-16 18:38:03',10,0),('1','143',257661,'DAILY SHIFT','2022-06-17','2022-06-17 08:08:45','2022-06-18 08:08:45','563',0.00,0.00,'563','2022-06-17 18:08:02','563','2022-06-17 18:09:05',10,0),('1','143',257662,'DAILY SHIFT','2022-06-18','2022-06-18 08:23:48','2022-06-19 08:23:48','563',0.00,0.00,'563','2022-06-18 19:01:45','563','2022-06-18 19:02:09',10,0),('1','143',257663,'DAILY SHIFT','2022-06-19','2022-06-19 07:57:58','2022-06-20 07:57:58','563',0.00,0.00,'563','2022-06-19 18:52:25','563','2022-06-19 18:52:49',10,0),('1','143',257664,'DAILY SHIFT','2022-06-20','2022-06-20 08:06:29','2022-06-21 08:06:29','563',0.00,0.00,'563','2022-06-20 18:42:47','563','2022-06-20 18:43:08',10,0),('1','143',257665,'DAILY SHIFT','2022-06-21','2022-06-21 08:05:58','2022-06-22 08:05:58','563',0.00,0.00,'563','2022-06-21 18:10:00','563','2022-06-21 18:10:21',10,0),('1','143',257666,'DAILY SHIFT','2022-06-22','2022-06-22 07:53:35','2022-06-23 07:53:35','563',0.00,0.00,'563','2022-06-22 18:37:00','563','2022-06-22 18:37:22',10,0),('1','143',257667,'DAILY SHIFT','2022-06-23','2022-06-23 07:32:37','2022-06-24 07:32:37','563',0.00,0.00,'563','2022-06-23 16:43:44','563','2022-06-23 16:45:36',10,0),('1','143',257668,'DAILY SHIFT','2022-06-23','2022-06-23 16:47:36','2022-06-24 16:47:36','563',0.00,0.00,'563','2022-06-23 18:51:57','563','2022-06-23 18:52:16',10,0),('1','143',257669,'DAILY SHIFT','2022-06-24','2022-06-24 08:08:42','2022-06-25 08:08:42','563',0.00,0.00,'563','2022-06-24 18:52:16','563','2022-06-24 18:52:36',10,0),('1','143',257670,'DAILY SHIFT','2022-06-25','2022-06-25 08:00:03','2022-06-26 08:00:03','563',0.00,0.00,'563','2022-06-25 18:42:47','563','2022-06-25 20:02:31',10,0),('1','143',257671,'DAILY SHIFT','2022-06-26','2022-06-26 08:20:41','2022-06-27 08:20:41','563',0.00,0.00,'563','2022-06-26 18:22:44','563','2022-06-26 18:23:12',10,0),('1','143',257672,'DAILY SHIFT','2022-06-27','2022-06-27 08:12:42','2022-06-28 08:12:42','563',0.00,0.00,'563','2022-06-27 18:39:02','563','2022-06-27 18:39:19',10,0),('1','143',257673,'DAILY SHIFT','2022-06-28','2022-06-28 07:43:02','2022-06-29 07:43:02','563',0.00,0.00,'563','2022-06-28 18:36:54','563','2022-06-28 18:37:19',10,0),('1','143',257674,'DAILY SHIFT','2022-06-29','2022-06-29 08:08:14','2022-06-30 08:08:14','563',0.00,0.00,'563','2022-06-29 18:48:21','563','2022-06-29 18:48:40',10,0),('1','143',257675,'DAILY SHIFT','2022-06-30','2022-06-30 08:09:49','2022-07-01 08:09:49','563',0.00,0.00,'563','2022-06-30 19:08:13','563','2022-06-30 19:08:35',10,0),('1','143',257676,'DAILY SHIFT','2022-07-01','2022-07-01 08:11:28','2022-07-02 08:11:28','563',0.00,0.00,'563','2022-07-01 19:00:00','563','2022-07-01 19:00:22',10,0),('1','143',257677,'DAILY SHIFT ','2022-07-02','2022-07-02 08:01:08','2022-07-03 08:01:08','563',0.00,0.00,'563','2022-07-02 19:16:51','563','2022-07-02 19:17:12',10,0),('1','143',257678,'DAILY SHIFT ','2022-07-03','2022-07-03 07:49:56','2022-07-04 07:49:56','563',0.00,0.00,'563','2022-07-03 19:22:37','563','2022-07-03 19:23:02',10,0),('1','143',257679,'DAILY SHIFT ','2022-07-04','2022-07-04 07:45:39','2022-07-05 07:45:39','563',0.00,0.00,'563','2022-07-04 19:51:35','563','2022-07-04 19:52:00',10,0),('1','143',257680,'DAILY SHIFT','2022-07-05','2022-07-05 08:16:38','2022-07-06 08:16:38','563',0.00,0.00,'563','2022-07-05 19:27:16','563','2022-07-05 19:27:37',10,0),('1','143',257681,'DAILY SHIFT','2022-07-06','2022-07-06 08:10:31','2022-07-07 08:10:31','563',0.00,0.00,'563','2022-07-06 20:01:08','563','2022-07-06 20:01:28',10,0),('1','143',257682,'DAILY SHIFT','2022-07-07','2022-07-07 08:52:38','2022-07-08 08:52:38','563',0.00,0.00,'563','2022-07-07 20:01:33','563','2022-07-07 20:01:54',10,0),('1','143',257683,'DAILY SHIFT','2022-07-08','2022-07-08 08:19:09','2022-07-09 08:19:09','563',0.00,0.00,'563','2022-07-08 19:46:52','563','2022-07-08 19:47:19',10,0),('1','143',257684,'DAILY SHIFT','2022-07-09','2022-07-09 10:57:43','2022-07-10 10:57:43','563',0.00,0.00,'563','2022-07-09 17:48:59','563','2022-07-09 17:49:25',10,0),('1','143',257685,'DAILY SHIFT','2022-07-10','2022-07-10 08:09:10','2022-07-11 08:09:10','563',0.00,0.00,'563','2022-07-10 18:40:06','563','2022-07-10 18:40:32',10,0),('1','143',257686,'DAILY SHIFT','2022-07-11','2022-07-11 08:03:31','2022-07-12 08:03:31','563',0.00,0.00,'563','2022-07-11 18:33:57','563','2022-07-11 18:34:13',10,0),('1','143',257687,'DAILY SHIFT','2022-07-12','2022-07-12 08:01:51','2022-07-13 08:01:51','563',0.00,0.00,'563','2022-07-12 18:40:35','563','2022-07-12 18:40:53',10,0),('1','143',257688,'DAILY SHIFT','2022-07-13','2022-07-13 09:00:16','2022-07-14 09:00:16','563',0.00,0.00,'563','2022-07-13 19:18:13','563','2022-07-13 19:18:33',10,0),('1','143',257689,'DAILY SHIFT','2022-07-14','2022-07-14 07:51:26','2022-07-15 07:51:26','563',0.00,0.00,'563','2022-07-14 15:42:05','563','2022-07-14 15:42:38',10,0),('1','143',257690,'DAILY SHIFT','2022-07-14','2022-07-14 16:05:26','2022-07-15 16:05:26','563',0.00,0.00,'563','2022-07-14 18:11:29','563','2022-07-14 18:11:48',10,0),('1','143',257691,'DAILY SHIFT','2022-07-15','2022-07-15 07:36:28','2022-07-16 07:36:28','563',0.00,0.00,'563','2022-07-15 18:49:23','563','2022-07-15 18:49:46',10,0),('1','143',257692,'DAILY SHIFT','2022-07-16','2022-07-16 07:55:29','2022-07-17 07:55:29','563',0.00,0.00,'563','2022-07-16 18:45:56','563','2022-07-16 18:47:15',10,0),('1','143',257693,'DAILY SHIFT','2022-07-17','2022-07-17 08:15:17','2022-07-18 08:15:17','563',0.00,0.00,'563','2022-07-17 18:35:00','563','2022-07-17 18:35:33',10,0),('1','143',257694,'DAILY SHIFT ','2022-07-18','2022-07-18 07:46:24','2022-07-19 07:46:24','563',0.00,0.00,'563','2022-07-18 18:38:59','563','2022-07-18 18:39:16',10,0),('1','143',257695,'DAILY SHIFT','2022-07-19','2022-07-19 07:37:40','2022-07-20 07:37:40','563',0.00,0.00,'563','2022-07-19 18:50:19','563','2022-07-19 18:50:37',10,0),('1','143',257696,'DAILY SHIFT','2022-07-20','2022-07-20 07:53:05','2022-07-21 07:53:05','563',0.00,0.00,'563','2022-07-20 18:51:38','563','2022-07-20 18:53:08',10,0),('1','143',257697,'DAILY SHIFT ','2022-07-21','2022-07-21 08:38:32','2022-07-22 08:38:32','563',0.00,0.00,'563','2022-07-21 19:09:08','563','2022-07-21 19:09:26',10,0),('1','143',257698,'DAILY SHIFT ','2022-07-22','2022-07-22 07:38:31','2022-07-23 07:38:31','563',0.00,0.00,'563','2022-07-22 18:26:16','563','2022-07-22 18:26:38',10,0),('1','143',257699,'DAILY SHIFT ','2022-07-23','2022-07-23 08:03:34','2022-07-24 08:03:34','563',0.00,0.00,'563','2022-07-24 07:35:45','563','2022-07-24 07:36:05',10,0),('1','143',257700,'DAILY SHIFT ','2022-07-24','2022-07-24 07:36:36','2022-07-25 07:36:36','563',0.00,0.00,'563','2022-07-24 18:23:06','563','2022-07-24 18:23:32',10,0),('1','143',257701,'DAILY SHIFT','2022-07-25','2022-07-25 07:10:54','2022-07-26 07:10:54','563',0.00,0.00,'563','2022-07-25 18:41:11','563','2022-07-25 18:41:46',10,0),('1','143',257702,'DAILY SHIFT ','2022-07-26','2022-07-26 07:40:46','2022-07-27 07:40:46','563',0.00,0.00,'563','2022-07-26 19:33:33','563','2022-07-26 19:34:43',10,0),('1','143',257703,'DAILY SHIFT','2022-07-27','2022-07-27 07:59:51','2022-07-28 07:59:51','563',0.00,0.00,'563','2022-07-28 08:50:34','563','2022-07-28 08:51:10',10,0),('1','143',257704,'DAILY SHIFT','2022-07-28','2022-07-28 08:51:47','2022-07-29 08:51:47','563',0.00,0.00,'563','2022-07-28 17:00:54','563','2022-07-28 17:01:25',10,0),('1','143',257705,'DAILY SHIFT','2022-07-28','2022-07-28 17:03:41','2022-07-29 17:03:41','563',0.00,0.00,'563','2022-07-28 21:32:35','563','2022-07-28 21:33:05',10,0),('1','143',257706,'DAILY SHIFT','2022-07-29','2022-07-29 07:43:24','2022-07-30 07:43:24','563',0.00,0.00,'563','2022-07-29 19:36:48','563','2022-07-29 19:37:41',10,0),('1','143',257707,'DAILY SHIFT','2022-07-30','2022-07-30 07:34:18','2022-07-31 07:34:18','563',0.00,0.00,'563','2022-07-30 18:48:29','563','2022-07-30 18:53:16',10,0),('1','143',257708,'DAILY SHIFT','2022-07-31','2022-07-31 07:47:10','2022-08-01 07:47:10','563',0.00,0.00,'563','2022-07-31 07:49:19','563','2022-07-31 07:51:21',10,0),('1','143',257709,'DAILY SHIFT','2022-07-31','2022-07-31 07:52:00','2022-08-01 07:52:00','563',0.00,0.00,'563','2022-07-31 19:46:54','563','2022-07-31 19:49:57',10,0),('1','143',257710,'DAILY SHIFT','2022-08-01','2022-08-01 07:56:41','2022-08-02 07:56:41','563',0.00,0.00,'563','2022-08-01 18:54:50','563','2022-08-01 18:56:07',10,0),('1','143',257711,'DAILY SHIFT','2022-08-02','2022-08-02 08:17:25','2022-08-03 08:17:25','563',0.00,0.00,'563','2022-08-02 23:17:20','563','2022-08-02 23:18:20',10,0),('1','143',257712,'DAILY SHIFT','2022-08-03','2022-08-03 06:57:51','2022-08-04 06:57:51','563',0.00,0.00,'563','2022-08-04 11:12:18','563','2022-08-04 11:12:50',10,0),('1','143',257713,'DAILY SHIFT','2022-08-04','2022-08-04 11:13:22','2022-08-05 11:13:22','563',0.00,0.00,'563','2022-08-05 07:16:33','563','2022-08-05 07:17:22',10,0),('1','143',257714,'DAILY SHIFT','2022-08-05','2022-08-05 07:18:16','2022-08-06 07:18:16','563',0.00,0.00,'563','2022-08-05 19:16:49','563','2022-08-05 19:17:29',10,0),('1','143',257715,'DAILY SHIFT','2022-08-06','2022-08-06 07:49:31','2022-08-07 07:49:31','563',0.00,0.00,'563','2022-08-06 20:01:07','563','2022-08-06 20:03:42',10,0),('1','143',257716,'DAILY SHIFT','2022-08-07','2022-08-07 07:42:05','2022-08-08 07:42:05','563',0.00,0.00,'563','2022-08-07 19:29:14','563','2022-08-07 19:29:46',10,0),('1','143',257717,'DAILY SHIFT','2022-08-08','2022-08-08 07:20:16','2022-08-09 07:20:16','563',0.00,0.00,'563','2022-08-08 19:15:47','563','2022-08-08 19:16:52',10,0),('1','143',257718,'DAILY SHIFT','2022-08-09','2022-08-09 07:22:46','2022-08-10 07:22:46','563',0.00,0.00,'563','2022-08-09 19:46:41','563','2022-08-09 19:47:37',10,0),('1','143',257719,'DAILY SHIFT','2022-08-10','2022-08-10 07:57:06','2022-08-11 07:57:06','563',0.00,0.00,'563','2022-08-10 18:59:07','563','2022-08-10 18:59:43',10,0),('1','143',257720,'DAILY SHIFT','2022-08-11','2022-08-11 07:48:46','2022-08-12 07:48:46','563',0.00,0.00,'563','2022-08-11 19:02:02','563','2022-08-11 19:02:24',10,0),('1','143',257721,'DAILY SHIFT','2022-08-12','2022-08-12 07:30:59','2022-08-13 07:30:59','563',0.00,0.00,'563','2022-08-12 18:54:25','563','2022-08-12 18:54:50',10,0),('1','143',257722,'DAILY SHIFT','2022-08-13','2022-08-13 07:47:51','2022-08-14 07:47:51','563',0.00,0.00,'563','2022-08-13 18:50:26','563','2022-08-13 18:50:48',10,0),('1','143',257723,'DAILY SHIFT','2022-08-14','2022-08-14 08:23:34','2022-08-15 08:23:34','563',0.00,0.00,'563','2022-08-14 21:28:26','563','2022-08-14 21:29:17',10,0),('1','143',257724,'DAILY SHIFT','2022-08-15','2022-08-15 07:42:49','2022-08-16 07:42:49','563',0.00,0.00,'563','2022-08-15 19:05:12','563','2022-08-15 19:05:37',10,0),('1','143',257725,'DAILY SHIFT','2022-08-16','2022-08-16 08:27:29','2022-08-17 08:27:29','563',0.00,0.00,'563','2022-08-16 18:50:54','563','2022-08-16 18:51:23',10,0),('1','143',257726,'DAILY SHIFT','2022-08-17','2022-08-17 10:21:27','2022-08-18 10:21:27','563',0.00,0.00,'563','2022-08-17 19:28:13','563','2022-08-17 19:28:42',10,0),('1','143',257727,'DAILY SHIFT','2022-08-18','2022-08-18 07:11:19','2022-08-19 07:11:19','563',0.00,0.00,'563','2022-08-18 18:21:21','563','2022-08-18 18:23:03',10,0),('1','143',257728,'DAILY SHIFT','2022-08-18','2022-08-18 18:59:00','2022-08-19 18:59:00','563',0.00,0.00,'563','2022-08-18 19:05:42','563','2022-08-18 19:06:15',10,0),('1','143',257729,'DAILY SHIFT','2022-08-19','2022-08-19 08:18:49','2022-08-20 08:18:49','563',0.00,0.00,'563','2022-08-20 07:16:33','563','2022-08-20 07:17:10',10,0),('1','143',257730,'DAILY SHIFT','2022-08-20','2022-08-20 07:17:43','2022-08-21 07:17:43','563',0.00,0.00,'563','2022-08-20 18:50:20','563','2022-08-20 18:50:43',10,0),('1','143',257731,'DAILY SHIFT','2022-08-21','2022-08-21 08:30:20','2022-08-22 08:30:20','563',0.00,0.00,'563','2022-08-21 18:32:23','563','2022-08-21 18:32:57',10,0),('1','143',257732,'DAILY SHIFT','2022-08-22','2022-08-22 08:09:37','2022-08-23 08:09:37','563',0.00,0.00,'563','2022-08-22 18:37:04','563','2022-08-22 18:37:27',10,0),('1','143',257733,'DAILY SHIFT','2022-08-23','2022-08-23 08:22:35','2022-08-24 08:22:35','563',0.00,0.00,'563','2022-08-23 18:34:50','563','2022-08-23 18:35:08',10,0),('1','143',257734,'DAILY SHIFT','2022-08-24','2022-08-24 08:14:00','2022-08-25 08:14:00','563',0.00,0.00,'563','2022-08-24 18:39:12','563','2022-08-24 18:39:33',10,0),('1','143',257735,'DAILY SHIFT','2022-08-25','2022-08-25 08:21:01','2022-08-26 08:21:01','563',0.00,0.00,'563','2022-08-25 19:09:11','563','2022-08-25 19:09:37',10,0),('1','143',257736,'DAILY SHIFT','2022-08-26','2022-08-26 08:53:20','2022-08-27 08:53:20','563',0.00,0.00,'563','2022-08-26 18:36:12','563','2022-08-26 18:36:36',10,0),('1','143',257737,'DAILY SHIFT','2022-08-27','2022-08-27 07:26:53','2022-08-28 07:26:53','563',0.00,0.00,'563','2022-08-27 18:45:27','563','2022-08-27 18:55:34',10,0),('1','143',257738,'DAILY SHIFT','2022-08-28','2022-08-28 08:05:20','2022-08-29 08:05:20','563',0.00,0.00,'563','2022-08-28 19:24:36','563','2022-08-28 19:24:57',10,0),('1','143',257739,'DAILY SHIFT','2022-08-29','2022-08-29 08:14:04','2022-08-30 08:14:04','563',0.00,0.00,'563','2022-08-29 18:53:14','563','2022-08-30 08:55:33',10,0),('1','143',257740,'DAILY SHIFT','2022-08-30','2022-08-30 08:55:55','2022-08-31 08:55:55','563',0.00,0.00,'563','2022-08-30 19:27:03','563','2022-08-30 19:27:27',10,0),('1','143',257741,'DAILY SHIFT','2022-08-31','2022-08-31 09:32:54','2022-09-01 09:32:54','563',0.00,0.00,'563','2022-08-31 18:57:31','563','2022-08-31 18:57:54',10,0),('1','143',257742,'DAILY SHIFT','2022-09-01','2022-09-01 08:31:50','2022-09-02 08:31:50','563',0.00,0.00,'563','2022-09-01 18:54:26','563','2022-09-01 18:55:02',10,0),('1','143',257743,'DAILY SHIFT','2022-09-02','2022-09-02 08:34:08','2022-09-03 08:34:08','563',0.00,0.00,'563','2022-09-02 11:23:07','563','2022-09-02 11:23:26',10,0),('1','143',257744,'DAILY SHIFT','2022-09-02','2022-09-02 11:23:44','2022-09-03 11:23:44','563',0.00,0.00,'563','2022-09-02 19:32:13','563','2022-09-02 19:32:50',10,0),('1','143',257745,'DAILY SHIFT','2022-09-03','2022-09-03 08:23:39','2022-09-04 08:23:39','563',0.00,0.00,'563','2022-09-03 19:29:04','563','2022-09-03 19:29:29',10,0),('1','143',257746,'DAILY SHIFT','2022-09-04','2022-09-04 08:10:00','2022-09-05 08:10:00','563',0.00,0.00,'563','2022-09-04 18:59:20','563','2022-09-04 19:00:18',10,0),('1','143',257747,'DAILY SHIFT','2022-09-05','2022-09-05 08:15:32','2022-09-06 08:15:32','563',0.00,0.00,'563','2022-09-05 18:58:34','563','2022-09-05 18:59:16',10,0),('1','143',257748,'DAILY SHIFT','2022-09-06','2022-09-06 08:56:08','2022-09-07 08:56:08','563',0.00,0.00,'563','2022-09-06 18:49:17','563','2022-09-06 18:49:37',10,0),('1','143',257749,'DAILY SHIFT','2022-09-07','2022-09-07 08:40:26','2022-09-08 08:40:26','563',0.00,0.00,'563','2022-09-07 19:21:11','563','2022-09-07 19:21:48',10,0),('1','143',257750,'DAILY SHIFT','2022-09-08','2022-09-08 08:25:59','2022-09-09 08:25:59','563',0.00,0.00,'563','2022-09-08 18:57:39','563','2022-09-08 18:58:08',10,0),('1','143',257751,'DAILY SHIFT','2022-09-09','2022-09-09 09:37:55','2022-09-10 09:37:55','563',0.00,0.00,'563','2022-09-09 19:17:24','563','2022-09-09 19:18:14',10,0),('1','143',257752,'DAILY SHIFT','2022-09-10','2022-09-10 08:30:46','2022-09-11 08:30:46','563',0.00,0.00,'563','2022-09-10 18:41:40','563','2022-09-10 18:42:00',10,0),('1','143',257753,'DAILY SHIFT','2022-09-11','2022-09-11 08:34:01','2022-09-12 08:34:01','563',0.00,0.00,'563','2022-09-11 19:00:49','563','2022-09-11 19:03:28',10,0),('1','143',257754,'daily shift','2022-09-12','2022-09-12 08:23:48','2022-09-13 08:23:48','563',0.00,0.00,'563','2022-09-12 18:51:24','563','2022-09-12 18:51:46',10,0),('1','143',257755,'DAILY SHIFT','2022-09-13','2022-09-13 08:12:18','2022-09-14 08:12:18','563',0.00,0.00,'563','2022-09-13 18:30:33','563','2022-09-13 20:19:20',10,0),('1','143',257756,'daily shift','2022-09-14','2022-09-14 08:25:13','2022-09-15 08:25:13','563',0.00,0.00,'563','2022-09-14 12:14:28','563','2022-09-14 12:21:37',10,0),('1','143',257757,'DAILY SHIFT','2022-09-14','2022-09-14 12:22:16','2022-09-15 12:22:16','563',0.00,0.00,'563','2022-09-14 18:56:07','563','2022-09-14 18:56:55',10,0),('1','143',257758,'DAILY SHIFT','2022-09-15','2022-09-15 13:38:52','2022-09-16 13:38:52','563',0.00,0.00,'563','2022-09-15 18:19:10','563','2022-09-15 18:25:49',10,0),('1','143',257759,'DAILY SHIFT','2022-09-16','2022-09-16 10:26:52','2022-09-17 10:26:52','563',0.00,0.00,'563','2022-09-16 18:54:27','563','2022-09-16 18:55:03',10,0),('1','143',257760,'DAILY SHIFT','2022-09-17','2022-09-17 08:38:29','2022-09-18 08:38:29','563',0.00,0.00,'563','2022-09-17 18:42:51','563','2022-09-17 18:43:31',10,0),('1','143',257761,'DAILY SHIFT','2022-09-18','2022-09-18 08:36:01','2022-09-19 08:36:01','563',0.00,0.00,'563','2022-09-18 18:45:01','563','2022-09-18 18:58:33',10,0),('1','143',257762,'DAILY SHIFT','2022-09-19','2022-09-19 08:42:43','2022-09-20 08:42:43','563',0.00,0.00,'563','2022-09-19 20:41:53','563','2022-09-19 20:42:14',10,0),('1','143',257763,'daily shift','2022-09-20','2022-09-20 08:25:28','2022-09-21 08:25:28','563',0.00,0.00,'563','2022-09-20 19:01:25','563','2022-09-20 19:03:24',10,0),('1','143',257764,'DAILY SHIFT','2022-09-21','2022-09-21 10:47:15','2022-09-22 10:47:15','563',0.00,0.00,'563','2022-09-21 18:36:20','563','2022-09-21 18:36:46',10,0),('1','143',257765,'DAILY SHIFT','2022-09-22','2022-09-22 10:13:05','2022-09-23 10:13:05','563',0.00,0.00,'563','2022-09-22 18:59:06','563','2022-09-22 18:59:31',10,0),('1','143',257766,'DAILY SHIFT','2022-09-23','2022-09-23 08:58:08','2022-09-24 08:58:08','563',0.00,0.00,'563','2022-09-23 19:21:10','563','2022-09-23 19:21:32',10,0),('1','143',257767,'DAILY SHIFT','2022-09-24','2022-09-24 08:58:23','2022-09-25 08:58:23','563',0.00,0.00,'563','2022-09-24 18:29:45','563','2022-09-24 18:30:07',10,0),('1','143',257768,'DAILY SHIFT','2022-09-25','2022-09-25 09:36:12','2022-09-26 09:36:12','563',0.00,0.00,'563','2022-09-25 18:38:58','563','2022-09-25 18:52:10',10,0),('1','143',257769,'DAILY SHIFT','2022-09-26','2022-09-26 08:24:51','2022-09-27 08:24:51','563',0.00,0.00,'563','2022-09-26 18:36:03','563','2022-09-26 18:36:25',10,0),('1','143',257770,'DAILY SHIFT','2022-09-27','2022-09-27 11:32:56','2022-09-28 11:32:56','563',0.00,0.00,'563','2022-09-28 09:54:00','563','2022-09-28 09:54:22',10,0),('1','143',257771,'DAILY SHIFT','2022-09-28','2022-09-28 09:54:48','2022-09-29 09:54:48','563',0.00,0.00,'563','2022-09-28 15:21:39','563','2022-09-28 15:22:03',10,0),('1','143',257772,'DAILY SHIFT','2022-09-28','2022-09-28 15:22:29','2022-09-29 15:22:29','563',0.00,0.00,'563','2022-09-28 18:53:07','563','2022-09-28 18:53:27',10,0),('1','143',257773,'DAILY SHIFT','2022-09-29','2022-09-29 08:11:59','2022-09-30 08:11:59','563',0.00,0.00,'563','2022-09-29 18:46:27','563','2022-09-29 18:46:51',10,0),('1','143',257774,'DAILY SHIFT','2022-09-30','2022-09-30 08:32:56','2022-10-01 08:32:56','563',0.00,0.00,'563','2022-09-30 18:42:45','563','2022-09-30 18:43:09',10,0),('1','143',257775,'DAILY SHIFT','2022-09-30','2022-09-30 19:54:48','2022-10-01 19:54:48','563',0.00,0.00,'563','2022-09-30 20:02:35','563','2022-09-30 20:03:01',10,0),('1','143',257776,'daily shift','2022-10-01','2022-10-01 09:08:24','2022-10-02 09:08:24','563',0.00,0.00,'563','2022-10-01 18:55:27','563','2022-10-01 18:55:58',10,0),('1','143',257777,'daily shift','2022-10-02','2022-10-02 08:47:50','2022-10-03 08:47:50','563',0.00,0.00,'563','2022-10-02 18:33:53','563','2022-10-02 18:34:23',10,0),('1','143',257778,'DAILY SHIFT','2022-10-03','2022-10-03 18:16:56','2022-10-04 18:16:56','563',0.00,0.00,'563','2022-10-03 18:57:39','563','2022-10-03 18:58:13',10,0),('1','143',257779,'DAILY SALE','2022-10-04','2022-10-04 16:24:56','2022-10-05 16:24:56','563',0.00,0.00,'563','2022-10-04 18:34:12','563','2022-10-04 18:34:41',10,0),('1','143',257780,'DAILY SALE','2022-10-05','2022-10-05 11:37:50','2022-10-06 11:37:50','563',0.00,0.00,'563','2022-10-05 18:41:39','563','2022-10-05 18:42:12',10,0),('1','143',257781,'DAILY SALE','2022-10-06','2022-10-06 08:30:19','2022-10-07 08:30:19','563',0.00,0.00,'563','2022-10-06 18:51:40','563','2022-10-06 18:52:15',10,0),('1','143',257782,'DAILY SALE','2022-10-07','2022-10-07 08:35:39','2022-10-08 08:35:39','563',0.00,0.00,'563','2022-10-07 18:55:23','563','2022-10-07 18:56:13',10,0),('1','143',257783,'DAILY SALE','2022-10-08','2022-10-08 08:44:02','2022-10-09 08:44:02','563',0.00,0.00,'563','2022-10-08 18:26:47','563','2022-10-08 18:27:07',10,0),('1','143',257784,'DAILY SALE','2022-10-09','2022-10-09 08:36:14','2022-10-10 08:36:14','563',0.00,0.00,'563','2022-10-09 18:24:09','563','2022-10-09 18:28:15',10,0),('1','143',257785,'DAILY SALE','2022-10-10','2022-10-10 08:15:12','2022-10-11 08:15:12','563',0.00,0.00,'563','2022-10-10 18:24:53','563','2022-10-10 18:25:14',10,0),('1','143',257786,'DAILY SALE','2022-10-11','2022-10-11 08:21:24','2022-10-12 08:21:24','563',0.00,0.00,'563','2022-10-11 12:59:54','563','2022-10-11 13:00:15',10,0),('1','143',257787,'DAILY SALE','2022-10-11','2022-10-11 13:03:15','2022-10-12 13:03:15','563',0.00,0.00,'563','2022-10-11 18:23:31','563','2022-10-11 18:23:58',10,0),('1','143',257788,'DAILY SALE','2022-10-12','2022-10-12 10:13:42','2022-10-13 10:13:42','563',0.00,0.00,'563','2022-10-12 18:26:26','563','2022-10-12 18:26:51',10,0),('1','143',257789,'DAILY SALE','2022-10-13','2022-10-13 08:31:21','2022-10-14 08:31:21','563',0.00,0.00,'563','2022-10-13 19:10:57','563','2022-10-13 19:11:20',10,0),('1','143',257790,'DAILY SHIFT','2022-10-14','2022-10-14 05:53:33','2022-10-15 05:53:33','563',0.00,0.00,'563','2022-10-14 06:00:01','563','2022-10-14 06:00:23',10,0),('1','143',257791,'DAILY SALE','2022-10-14','2022-10-14 08:26:29','2022-10-15 08:26:29','563',0.00,0.00,'563','2022-10-15 08:43:29','563','2022-10-15 08:43:54',10,0),('1','143',257792,'DAILY SALE','2022-10-15','2022-10-15 08:44:28','2022-10-16 08:44:28','563',0.00,0.00,'563','2022-10-15 20:24:03','563','2022-10-15 20:25:21',10,0),('1','143',257793,'DAILY SALE','2022-10-16','2022-10-16 08:26:36','2022-10-17 08:26:36','563',0.00,0.00,'563','2022-10-16 18:47:18','563','2022-10-16 18:48:20',10,0),('1','143',257794,'DAILY SALE','2022-10-17','2022-10-17 08:33:52','2022-10-18 08:33:52','563',0.00,0.00,'563','2022-10-17 18:55:18','563','2022-10-17 18:55:41',10,0),('1','143',257795,'DAILY SALE','2022-10-18','2022-10-18 08:36:17','2022-10-19 08:36:17','563',0.00,0.00,'563','2022-10-19 02:59:39','563','2022-10-19 03:00:05',10,0),('1','143',257796,'DAILY SALE','2022-10-19','2022-10-19 08:16:34','2022-10-20 08:16:34','563',0.00,0.00,'563','2022-10-19 18:33:03','563','2022-10-19 18:33:24',10,0),('1','143',257797,'DAILY SALE','2022-10-20','2022-10-20 08:12:21','2022-10-21 08:12:21','563',0.00,0.00,'563','2022-10-20 19:45:04','563','2022-10-20 19:45:57',10,0),('1','143',257798,'DAILY SALE','2022-10-21','2022-10-21 08:12:03','2022-10-22 08:12:03','563',0.00,0.00,'563','2022-10-21 18:36:21','563','2022-10-21 18:36:41',10,0),('1','143',257799,'DAILY SALE','2022-10-22','2022-10-22 08:09:53','2022-10-23 08:09:53','563',0.00,0.00,'563','2022-10-22 10:02:38','563','2022-10-22 10:02:54',10,0),('1','143',257800,'DAILY SALE','2022-10-22','2022-10-22 10:03:23','2022-10-23 10:03:23','563',0.00,0.00,'563','2022-10-22 19:29:11','563','2022-10-22 19:30:18',10,0),('1','143',257801,'DAILY SHIFT','2022-10-23','2022-10-23 06:02:29','2022-10-24 06:02:29','563',0.00,0.00,'563','2022-10-23 06:08:53','563','2022-10-23 06:09:20',10,0),('1','143',257802,'DAILY SALE','2022-10-23','2022-10-23 08:05:39','2022-10-24 08:05:39','563',0.00,0.00,'563','2022-10-23 18:51:33','563','2022-10-23 18:51:51',10,0),('1','143',257803,'DAILY SALE','2022-10-24','2022-10-24 08:18:41','2022-10-25 08:18:41','563',0.00,0.00,'563','2022-10-24 18:57:54','563','2022-10-24 18:58:19',10,0),('1','143',257804,'DAILY SALE','2022-10-25','2022-10-25 08:09:44','2022-10-26 08:09:44','563',0.00,0.00,'563','2022-10-25 19:24:42','563','2022-10-25 19:25:02',10,0),('1','143',257805,'DAILY SALE','2022-10-26','2022-10-26 08:12:40','2022-10-27 08:12:40','563',0.00,0.00,'563','2022-10-26 11:12:07','563','2022-10-26 11:12:31',10,0),('1','143',257806,'DAILY SALE','2022-10-26','2022-10-26 11:13:19','2022-10-27 11:13:19','563',0.00,0.00,'563','2022-10-26 19:24:53','563','2022-10-26 19:25:55',10,0),('1','143',257807,'DAILY SHIFT','2022-10-26','2022-10-26 21:10:06','2022-10-27 21:10:06','563',0.00,0.00,'563','2022-10-26 21:17:37','563','2022-10-26 21:17:59',10,0),('1','143',257808,'DAILY SALE','2022-10-27','2022-10-27 08:25:53','2022-10-28 08:25:53','563',0.00,0.00,'563','2022-10-27 18:49:12','563','2022-10-27 18:49:31',10,0),('1','143',257809,'DAILY SALE','2022-10-28','2022-10-28 08:48:42','2022-10-29 08:48:42','563',0.00,0.00,'563','2022-10-29 00:25:10','563','2022-10-29 00:26:26',10,0),('1','143',257810,'DAILY SALE','2022-10-29','2022-10-29 08:19:55','2022-10-30 08:19:55','563',0.00,0.00,'563','2022-10-29 18:29:08','563','2022-10-29 18:29:29',10,0),('1','143',257811,'DAILY SALE','2022-10-30','2022-10-30 08:20:48','2022-10-31 08:20:48','563',0.00,0.00,'563','2022-10-30 19:36:23','563','2022-10-30 19:37:11',10,0),('1','143',257812,'DAILY SALE','2022-10-31','2022-10-31 08:43:31','2022-11-01 08:43:31','563',0.00,0.00,'563','2022-10-31 18:47:30','563','2022-10-31 18:47:50',10,0),('1','143',257813,'DAILY SHIFT','2022-11-04','2022-11-04 20:56:37','2022-11-05 20:56:37','563',0.00,0.00,'563','2022-11-04 21:06:22','563','2022-11-04 21:07:07',10,0),('1','143',257814,'DAILY SALE','2022-11-05','2022-11-05 08:03:48','2022-11-06 08:03:48','563',0.00,0.00,'563','2022-11-05 18:48:29','563','2022-11-05 18:48:59',10,0),('1','143',257815,'DAILY SALE','2022-11-06','2022-11-06 08:23:19','2022-11-07 08:23:19','563',0.00,0.00,'563','2022-11-06 18:15:27','563','2022-11-06 18:15:47',10,0),('1','143',257816,'DAILY SALE','2022-11-07','2022-11-07 08:25:20','2022-11-08 08:25:20','563',0.00,0.00,'563','2022-11-07 18:35:57','563','2022-11-07 18:36:52',10,0),('1','143',257817,'DAILY SALE','2022-11-08','2022-11-08 08:20:10','2022-11-09 08:20:10','563',0.00,0.00,'563','2022-11-08 18:22:08','563','2022-11-08 18:23:50',10,0),('1','143',257818,'DAILY SALE','2022-11-09','2022-11-09 08:07:59','2022-11-10 08:07:59','563',0.00,0.00,'563','2022-11-09 18:28:03','563','2022-11-09 18:29:33',10,0),('1','143',257819,'DAILY SALE','2022-11-10','2022-11-10 08:09:14','2022-11-11 08:09:14','563',0.00,0.00,'563','2022-11-10 18:37:11','563','2022-11-10 18:37:38',10,0),('1','143',257820,'DAILY SALE','2022-11-11','2022-11-11 08:26:25','2022-11-12 08:26:25','563',0.00,0.00,'563','2022-11-11 18:18:12','563','2022-11-11 18:18:41',10,0),('1','143',257821,'DAILY SALE','2022-11-12','2022-11-12 08:40:36','2022-11-13 08:40:36','563',0.00,0.00,'563','2022-11-12 18:22:43','563','2022-11-12 18:23:00',10,0),('1','143',257822,'DAILY SHIFT','2022-11-13','2022-11-13 08:51:11','2022-11-14 08:51:11','563',0.00,0.00,'563','2022-11-13 18:59:53','563','2022-11-13 19:00:12',10,0),('1','143',257823,'DAILY SALE','2022-11-14','2022-11-14 07:26:11','2022-11-15 07:26:11','563',0.00,0.00,'563','2022-11-14 18:30:45','563','2022-11-14 18:31:02',10,0),('1','143',257824,'DAILY SALE','2022-11-15','2022-11-15 08:14:38','2022-11-16 08:14:38','563',0.00,0.00,'563','2022-11-15 19:02:12','563','2022-11-15 19:02:55',10,0),('1','143',257825,'DAILY SALE','2022-11-16','2022-11-16 08:14:46','2022-11-17 08:14:46','563',0.00,0.00,'563','2022-11-16 18:47:14','563','2022-11-16 18:48:06',10,0),('1','143',257826,'DAILY SALE','2022-11-16','2022-11-16 18:55:42','2022-11-17 18:55:42','563',0.00,0.00,'563','2022-11-16 19:27:09','563','2022-11-16 19:27:35',10,0),('1','143',257827,'DAILY SALE','2022-11-17','2022-11-17 08:07:09','2022-11-18 08:07:09','563',0.00,0.00,'563','2022-11-17 18:31:30','563','2022-11-17 18:31:55',10,0),('1','143',257828,'DAILY SALE','2022-11-18','2022-11-18 08:13:25','2022-11-19 08:13:25','563',0.00,0.00,'563','2022-11-18 18:18:17','563','2022-11-18 18:20:42',10,0),('1','143',257829,'DAILY SALE','2022-11-19','2022-11-19 08:18:44','2022-11-20 08:18:44','563',0.00,0.00,'563','2022-11-19 18:39:19','563','2022-11-19 18:40:06',10,0),('1','143',257830,'DAILY SALE','2022-11-20','2022-11-20 08:01:56','2022-11-21 08:01:56','563',0.00,0.00,'563','2022-11-20 19:53:51','563','2022-11-20 19:54:12',10,0),('1','143',257831,'DAILY SALE','2022-11-21','2022-11-21 08:08:33','2022-11-22 08:08:33','563',0.00,0.00,'563','2022-11-21 08:39:05','563','2022-11-21 08:39:32',10,0),('1','143',257832,'DAILY SALE','2022-11-21','2022-11-21 08:41:15','2022-11-22 08:41:15','563',0.00,0.00,'563','2022-11-21 18:32:15','563','2022-11-21 18:32:43',10,0),('1','143',257833,'DAILY SHIFT','2022-11-22','2022-11-22 06:06:03','2022-11-23 06:06:03','563',0.00,0.00,'563','2022-11-22 06:14:31','563','2022-11-22 06:14:51',10,0),('1','143',257834,'DAILY SALE','2022-11-22','2022-11-22 08:12:30','2022-11-23 08:12:30','563',0.00,0.00,'563','2022-11-22 18:31:16','563','2022-11-22 18:31:36',10,0),('1','143',257835,'DAILY SALE','2022-11-23','2022-11-23 08:33:41','2022-11-24 08:33:41','563',0.00,0.00,'563','2022-11-23 18:38:49','563','2022-11-23 18:39:37',10,0),('1','143',257836,'DAILY SALE','2022-11-24','2022-11-24 08:08:48','2022-11-25 08:08:48','563',0.00,0.00,'563','2022-11-24 18:19:08','563','2022-11-24 18:19:36',10,0),('1','143',257837,'DAILY SALE','2022-11-25','2022-11-25 08:08:36','2022-11-26 08:08:36','563',0.00,0.00,'563','2022-11-25 18:34:15','563','2022-11-25 18:37:15',10,0),('1','143',257838,'DAILY SALE','2022-11-26','2022-11-26 08:01:37','2022-11-27 08:01:37','563',0.00,0.00,'563','2022-11-26 18:30:50','563','2022-11-26 19:55:56',10,0),('1','143',257839,'DAILY SALE','2022-11-27','2022-11-27 08:10:50','2022-11-28 08:10:50','563',0.00,0.00,'563','2022-11-27 18:50:31','563','2022-11-27 18:50:54',10,0),('1','143',257840,'DAILY SALE','2022-11-28','2022-11-28 08:13:18','2022-11-29 08:13:18','563',0.00,0.00,'563','2022-11-28 18:40:37','563','2022-11-28 18:41:00',10,0),('1','143',257841,'DAILY SALE','2022-11-29','2022-11-29 08:01:25','2022-11-30 08:01:25','563',0.00,0.00,'563','2022-11-29 08:48:28','563','2022-11-29 08:48:46',10,0),('1','143',257842,'DAILY SALE','2022-11-29','2022-11-29 08:49:12','2022-11-30 08:49:12','563',0.00,0.00,'563','2022-11-29 18:49:44','563','2022-11-29 18:52:29',10,0),('1','143',257843,'DAILY SALE','2022-11-30','2022-11-30 10:41:32','2022-12-01 10:41:32','563',0.00,0.00,'563','2022-11-30 18:36:21','563','2022-11-30 18:36:46',10,0),('1','143',257844,'DAILY SHIFT','2022-11-30','2022-11-30 19:48:58','2022-12-01 19:48:58','563',0.00,0.00,'563','2022-11-30 19:52:55','563','2022-11-30 19:53:22',10,0),('1','143',257845,'DAILY SALE','2022-12-01','2022-12-01 08:03:32','2022-12-02 08:03:32','563',0.00,0.00,'563','2022-12-01 16:16:05','563','2022-12-01 16:17:29',10,0),('1','143',257846,'DAILY SALE','2022-12-01','2022-12-01 16:17:55','2022-12-02 16:17:55','563',0.00,0.00,'563','2022-12-01 18:54:42','563','2022-12-01 18:58:46',10,0),('1','143',257847,'DAILY SALE','2022-12-02','2022-12-02 08:10:59','2022-12-03 08:10:59','563',0.00,0.00,'563','2022-12-02 18:45:31','563','2022-12-02 18:45:50',10,0),('1','143',257848,'DAILY SALE','2022-12-03','2022-12-03 08:13:02','2022-12-04 08:13:02','563',0.00,0.00,'563','2022-12-03 18:20:43','563','2022-12-03 18:21:54',10,0),('1','143',257849,'DAILY SALE','2022-12-04','2022-12-04 07:58:31','2022-12-05 07:58:31','563',0.00,0.00,'563','2022-12-04 18:11:10','563','2022-12-04 18:11:31',10,0),('1','143',257850,'DAILY SALE','2022-12-05','2022-12-05 08:16:06','2022-12-06 08:16:06','563',0.00,0.00,'563','2022-12-05 18:41:14','563','2022-12-05 18:42:37',10,0),('1','143',257851,'DAILY SALE','2022-12-06','2022-12-06 08:00:11','2022-12-07 08:00:11','563',0.00,0.00,'563','2022-12-06 18:18:35','563','2022-12-06 18:19:20',10,0),('1','143',257852,'DAILY SALE','2022-12-07','2022-12-07 08:18:23','2022-12-08 08:18:23','563',0.00,0.00,'563','2022-12-07 18:35:57','563','2022-12-07 18:36:19',10,0),('1','143',257853,'DAILY SALE','2022-12-08','2022-12-08 07:57:51','2022-12-09 07:57:51','563',0.00,0.00,'563','2022-12-08 17:00:14','563','2022-12-08 17:00:51',10,0),('1','143',257854,'DAILY SALE','2022-12-08','2022-12-08 17:01:12','2022-12-09 17:01:12','563',0.00,0.00,'563','2022-12-08 18:10:14','563','2022-12-08 18:10:38',10,0),('1','143',257855,'DAILY SALE','2022-12-09','2022-12-09 08:09:29','2022-12-10 08:09:29','563',0.00,0.00,'563','2022-12-09 18:29:04','563','2022-12-09 18:29:38',10,0),('1','143',257856,'DAILY SHIFT','2022-12-09','2022-12-09 20:41:10','2022-12-10 20:41:10','563',0.00,0.00,'563','2022-12-09 20:45:39','563','2022-12-09 20:45:58',10,0),('1','143',257857,'DAILY SALE','2022-12-10','2022-12-10 08:27:19','2022-12-11 08:27:19','563',0.00,0.00,'563','2022-12-10 18:02:00','563','2022-12-10 18:02:20',10,0),('1','143',257858,'DAILY SALE','2022-12-11','2022-12-11 08:02:33','2022-12-12 08:02:33','563',0.00,0.00,'563','2022-12-11 18:20:16','563','2022-12-11 18:20:34',10,0),('1','143',257859,'DAILY SALE','2022-12-12','2022-12-12 08:01:42','2022-12-13 08:01:42','563',0.00,0.00,'563','2022-12-12 18:32:53','563','2022-12-12 18:33:22',10,0),('1','143',257860,'DAILY SALE','2022-12-13','2022-12-13 08:37:12','2022-12-14 08:37:12','563',0.00,0.00,'563','2022-12-13 18:35:29','563','2022-12-13 18:35:52',10,0),('1','143',257861,'DAILY SALE','2022-12-14','2022-12-14 08:02:09','2022-12-15 08:02:09','563',0.00,0.00,'563','2022-12-14 18:27:26','563','2022-12-14 18:27:52',10,0),('1','143',257862,'DAILY SALE','2022-12-15','2022-12-15 08:22:34','2022-12-16 08:22:34','563',0.00,0.00,'563','2022-12-15 18:37:31','563','2022-12-15 18:37:53',10,0),('1','143',257863,'DAILY SHIFT','2022-12-16','2022-12-16 08:00:54','2022-12-17 08:00:54','563',0.00,0.00,'563','2022-12-16 18:17:33','563','2022-12-16 18:18:32',10,0),('1','143',257864,'DAILY SHIFT','2022-12-17','2022-12-17 07:54:46','2022-12-18 07:54:46','563',0.00,0.00,'563','2022-12-17 18:25:32','563','2022-12-17 18:26:25',10,0),('1','143',257865,'DAILY SHIFT','2022-12-18','2022-12-18 08:22:34','2022-12-19 08:22:34','563',0.00,0.00,'563','2022-12-18 18:34:21','563','2022-12-18 18:34:49',10,0),('1','143',257866,'DAILY SHIFT','2022-12-19','2022-12-19 07:56:02','2022-12-20 07:56:02','563',0.00,0.00,'563','2022-12-19 18:27:35','563','2022-12-19 18:27:57',10,0),('1','143',257867,'DAILY SHIFT','2022-12-20','2022-12-20 08:03:07','2022-12-21 08:03:07','563',0.00,0.00,'563','2022-12-20 18:22:29','563','2022-12-20 18:22:55',10,0),('1','143',257868,'DAILY SHIFT','2022-12-21','2022-12-21 07:57:40','2022-12-22 07:57:40','563',0.00,0.00,'563','2022-12-21 18:21:26','563','2022-12-21 18:21:56',10,0),('1','143',257869,'DAILY SHIFT','2022-12-22','2022-12-22 08:03:29','2022-12-23 08:03:29','563',0.00,0.00,'563','2022-12-22 18:35:40','563','2022-12-22 18:37:04',10,0),('1','143',257870,'DAILY SHIFT','2022-12-23','2022-12-23 08:04:17','2022-12-24 08:04:17','563',0.00,0.00,'563','2022-12-23 18:27:25','563','2022-12-23 18:28:26',10,0),('1','143',257871,'DAILY SHIFT','2022-12-24','2022-12-24 08:12:20','2022-12-25 08:12:20','563',0.00,0.00,'563','2022-12-25 08:04:37','563','2022-12-25 08:05:25',10,0),('1','143',257872,'DAILY SHIFT','2022-12-25','2022-12-25 08:08:14','2022-12-26 08:08:14','563',0.00,0.00,'563','2022-12-25 19:36:08','563','2022-12-25 19:36:45',10,0),('1','143',257873,'DAILY SHIFT','2022-12-26','2022-12-26 08:18:38','2022-12-27 08:18:38','563',0.00,0.00,'563','2022-12-26 18:29:40','563','2022-12-26 18:30:17',10,0),('1','143',257874,'DAILY SHIFT','2022-12-27','2022-12-27 08:43:50','2022-12-28 08:43:50','563',0.00,0.00,'563','2022-12-27 18:15:51','563','2022-12-27 18:17:31',10,0),('1','143',257875,'DAILY SHIFT','2022-12-28','2022-12-28 08:14:41','2022-12-29 08:14:41','563',0.00,0.00,'563','2022-12-28 18:09:25','563','2022-12-28 18:09:50',10,0),('1','143',257876,'DAILY SHIFT','2022-12-29','2022-12-29 08:07:35','2022-12-30 08:07:35','563',0.00,0.00,'563','2022-12-29 18:57:14','563','2022-12-29 18:57:31',10,0),('1','143',257877,'DAILY SHIFT','2022-12-30','2022-12-30 08:13:20','2022-12-31 08:13:20','563',0.00,0.00,'563','2022-12-30 17:58:50','563','2022-12-30 17:59:58',10,0),('1','143',257878,'DAILY SHIFT','2022-12-31','2022-12-31 08:16:42','2023-01-01 08:16:42','563',0.00,0.00,'563','2022-12-31 18:31:37','563','2022-12-31 18:32:01',10,0),('1','143',257879,'DAILY SHIFT','2023-01-01','2023-01-01 08:39:02','2023-01-02 08:39:02','563',0.00,0.00,'563','2023-01-01 18:32:58','563','2023-01-01 18:33:20',10,0),('1','143',257880,'DAILY SHIFT','2023-01-02','2023-01-02 08:21:06','2023-01-03 08:21:06','563',0.00,0.00,'563','2023-01-02 18:29:53','563','2023-01-02 18:30:19',10,0),('1','143',257881,'DAILY SHIFT','2023-01-03','2023-01-03 08:27:04','2023-01-04 08:27:04','563',0.00,0.00,'563','2023-01-03 18:24:38','563','2023-01-03 18:41:13',10,0),('1','143',257882,'DAILY SHIFT','2023-01-04','2023-01-04 08:36:32','2023-01-05 08:36:32','563',0.00,0.00,'563','2023-01-04 18:31:58','563','2023-01-04 18:32:25',10,0),('1','143',257883,'DAILY SHIFT','2023-01-05','2023-01-05 10:29:19','2023-01-06 10:29:19','563',0.00,0.00,'563','2023-01-05 18:40:19','563','2023-01-05 18:40:37',10,0),('1','143',257884,'DAILY SHIFT','2023-01-06','2023-01-06 08:02:52','2023-01-07 08:02:52','563',0.00,0.00,'563','2023-01-06 18:38:04','563','2023-01-06 18:38:28',10,0),('1','143',257885,'DAILY SHIFT','2023-01-07','2023-01-07 08:11:36','2023-01-08 08:11:36','563',0.00,0.00,'563','2023-01-08 08:01:44','563','2023-01-08 08:02:37',10,0),('1','143',257886,'DAILY SHIFT','2023-01-08','2023-01-08 08:03:04','2023-01-09 08:03:04','563',0.00,0.00,'563','2023-01-08 14:24:50','563','2023-01-08 14:25:17',10,0),('1','143',257887,'DAILY SHIFT','2023-01-08','2023-01-08 14:25:44','2023-01-09 14:25:43','563',0.00,0.00,'563','2023-01-08 18:26:49','563','2023-01-08 18:27:15',10,0),('1','143',257888,'DAILY SHIFT','2023-01-09','2023-01-09 07:55:40','2023-01-10 07:55:40','563',0.00,0.00,'563','2023-01-09 18:42:34','563','2023-01-09 18:43:04',10,0),('1','143',257889,'DAILY SHIFT','2023-01-10','2023-01-10 07:58:53','2023-01-11 07:58:53','563',0.00,0.00,'563','2023-01-10 18:22:11','563','2023-01-10 18:22:35',10,0),('1','143',257890,'DAILY SHIFT','2023-01-11','2023-01-11 08:06:16','2023-01-12 08:06:16','563',0.00,0.00,'563','2023-01-11 18:27:25','563','2023-01-11 18:28:32',10,0),('1','143',257891,'DAILY SHIFT','2023-01-12','2023-01-12 08:11:26','2023-01-13 08:11:26','563',0.00,0.00,'563','2023-01-12 18:43:13','563','2023-01-12 18:44:49',10,0),('1','143',257892,'DAILY SHIFT','2023-01-13','2023-01-13 08:04:20','2023-01-14 08:04:20','563',0.00,0.00,'563','2023-01-13 18:15:07','563','2023-01-13 18:15:42',10,0),('1','143',257893,'DAILY SHIFT','2023-01-14','2023-01-14 08:15:29','2023-01-15 08:15:29','563',0.00,0.00,'563','2023-01-14 18:23:20','563','2023-01-14 18:23:42',10,0),('1','143',257894,'DAILY SHIFT','2023-01-15','2023-01-15 07:54:23','2023-01-16 07:54:23','563',0.00,0.00,'563','2023-01-15 18:39:38','563','2023-01-15 18:39:54',10,0),('1','143',257895,'DAILY SHIFT','2023-01-16','2023-01-16 08:14:18','2023-01-17 08:14:18','563',0.00,0.00,'563','2023-01-16 18:38:23','563','2023-01-16 18:38:56',10,0),('1','143',257896,'DAILY SHIFT','2023-01-17','2023-01-17 07:59:45','2023-01-18 07:59:45','563',0.00,0.00,'563','2023-01-17 18:59:59','563','2023-01-17 19:01:58',10,0),('1','143',257897,'DAILY SHIFT','2023-01-18','2023-01-18 08:08:47','2023-01-19 08:08:47','563',0.00,0.00,'563','2023-01-18 18:22:58','563','2023-01-18 18:24:22',10,0),('1','143',257898,'DAILY SHIFT','2023-01-18','2023-01-18 20:24:57','2023-01-19 20:24:57','563',0.00,0.00,'563','2023-01-18 20:29:23','563','2023-01-18 20:29:47',10,0),('1','143',257899,'DAILY SHIFT','2023-01-19','2023-01-19 08:09:13','2023-01-20 08:09:13','563',0.00,0.00,'563','2023-01-19 19:05:00','563','2023-01-19 19:08:43',10,0),('1','143',257900,'DAILY SHIFT','2023-01-20','2023-01-20 07:59:16','2023-01-21 07:59:16','563',0.00,0.00,'563','2023-01-20 18:51:43','563','2023-01-20 18:53:00',10,0),('1','143',257901,'DAILY SHIFT','2023-01-21','2023-01-21 08:12:06','2023-01-22 08:12:06','563',0.00,0.00,'563','2023-01-22 08:01:28','563','2023-01-22 08:01:51',10,0),('1','143',257902,'DAILY SHIFT','2023-01-22','2023-01-22 08:02:23','2023-01-23 08:02:23','563',0.00,0.00,'563','2023-01-22 18:51:37','563','2023-01-22 18:51:56',10,0),('1','143',257903,'DAILY SHIFT','2023-01-23','2023-01-23 08:08:45','2023-01-24 08:08:45','563',0.00,0.00,'563','2023-01-23 18:52:35','563','2023-01-23 18:53:11',10,0),('1','143',257904,'DAILY SHIFT','2023-01-24','2023-01-24 08:05:21','2023-01-25 08:05:21','563',0.00,0.00,'563','2023-01-24 18:58:03','563','2023-01-24 18:59:34',10,0),('1','143',257905,'DAILY SHIFT','2023-01-25','2023-01-25 08:04:05','2023-01-26 08:04:05','563',0.00,0.00,'563','2023-01-25 18:58:39','563','2023-01-25 18:59:37',10,0),('1','143',257906,'DAILY SHIFT','2023-01-26','2023-01-26 08:07:41','2023-01-27 08:07:41','563',0.00,0.00,'563','2023-01-26 19:19:25','563','2023-01-26 19:19:46',10,0),('1','143',257907,'DAILY SHIFT','2023-01-27','2023-01-27 08:14:37','2023-01-28 08:14:37','563',0.00,0.00,'563','2023-01-27 18:53:49','563','2023-01-27 18:54:45',10,0),('1','143',257908,'DAILY SHIFT','2023-01-28','2023-01-28 08:21:05','2023-01-29 08:21:05','563',0.00,0.00,'563','2023-01-28 18:57:09','563','2023-01-28 18:57:44',10,0),('1','143',257909,'DAILY SHIFT','2023-01-29','2023-01-29 08:02:30','2023-01-30 08:02:30','563',0.00,0.00,'563','2023-01-29 18:36:30','563','2023-01-29 18:45:33',10,0),('1','143',257910,'DAILY SHIFT','2023-01-30','2023-01-30 08:17:06','2023-01-31 08:17:06','563',0.00,0.00,'563','2023-01-30 18:32:03','563','2023-01-30 18:32:36',10,0),('1','143',257911,'DAILY SHIFT','2023-01-30','2023-01-30 20:03:54','2023-01-31 20:03:54','563',0.00,0.00,'563','2023-01-30 20:07:18','563','2023-01-30 20:07:39',10,0),('1','143',257912,'DAILY SHIFT','2023-01-31','2023-01-31 08:18:58','2023-02-01 08:18:58','563',0.00,0.00,'563','2023-01-31 19:11:02','563','2023-01-31 19:11:49',10,0),('1','143',257913,'DAILY SHIFT','2023-02-01','2023-02-01 08:07:40','2023-02-02 08:07:40','563',0.00,0.00,'563','2023-02-01 19:01:31','563','2023-02-01 19:03:34',10,0),('1','143',257914,'DAILY SHIFT','2023-02-02','2023-02-02 08:11:29','2023-02-03 08:11:29','563',0.00,0.00,'563','2023-02-02 18:50:18','563','2023-02-02 19:27:33',10,0),('1','143',257915,'DAILY SHIFT','2023-02-03','2023-02-03 08:17:30','2023-02-04 08:17:30','563',0.00,0.00,'563','2023-02-03 18:29:24','563','2023-02-03 18:29:58',10,0),('1','143',257916,'DAILY SHIFT','2023-02-04','2023-02-04 07:55:14','2023-02-05 07:55:14','563',0.00,0.00,'563','2023-02-04 18:51:00','563','2023-02-04 18:53:30',10,0),('1','143',257917,'DAILY SHIFT','2023-02-05','2023-02-05 08:15:07','2023-02-06 08:15:07','563',0.00,0.00,'563','2023-02-05 19:07:13','563','2023-02-05 19:07:34',10,0),('1','143',257918,'DAILY SHIFT','2023-02-06','2023-02-06 07:59:42','2023-02-07 07:59:42','563',0.00,0.00,'563','2023-02-06 19:28:29','563','2023-02-06 19:29:07',10,0),('1','143',257919,'DAILY SHIFT','2023-02-07','2023-02-07 08:05:40','2023-02-08 08:05:40','563',0.00,0.00,'563','2023-02-07 18:47:41','563','2023-02-07 18:48:37',10,0),('1','143',257920,'DAILY SHIFT','2023-02-08','2023-02-08 08:10:30','2023-02-09 08:10:30','563',0.00,0.00,'563','2023-02-08 19:04:20','563','2023-02-08 19:05:25',10,0),('1','143',257921,'DAILY SHIFT','2023-02-09','2023-02-09 08:01:41','2023-02-10 08:01:41','563',0.00,0.00,'563','2023-02-10 08:13:10','563','2023-02-10 08:13:37',10,0),('1','143',257922,'DAILY SHIFT','2023-02-10','2023-02-10 08:14:04','2023-02-11 08:14:04','563',0.00,0.00,'563','2023-02-10 09:53:51','563','2023-02-10 09:54:31',10,0),('1','143',257923,'DAILY SHIFT','2023-02-10','2023-02-10 09:55:05','2023-02-11 09:55:05','563',0.00,0.00,'563','2023-02-10 19:00:24','563','2023-02-10 19:01:08',10,0),('1','143',257924,'DAILY SHIFT','2023-02-11','2023-02-11 08:22:15','2023-02-12 08:22:15','563',0.00,0.00,'563','2023-02-11 19:10:11','563','2023-02-11 19:11:25',10,0),('1','143',257925,'DAILY SHIFT','2023-02-12','2023-02-12 07:44:47','2023-02-13 07:44:47','563',0.00,0.00,'563','2023-02-12 19:15:05','563','2023-02-12 19:15:32',10,0),('1','143',257926,'DAILY SHIFT','2023-02-13','2023-02-13 08:22:38','2023-02-14 08:22:38','563',0.00,0.00,'563','2023-02-13 18:56:26','563','2023-02-13 18:59:58',10,0),('1','143',257927,'DAILY SHIFT','2023-02-14','2023-02-14 08:37:46','2023-02-15 08:37:46','563',0.00,0.00,'563','2023-02-15 08:11:49','563','2023-02-15 08:12:50',10,0),('1','143',257928,'DAILY SHIFT','2023-02-15','2023-02-15 08:30:13','2023-02-16 08:30:13','563',0.00,0.00,'563','2023-02-15 18:52:55','563','2023-02-15 18:53:38',10,0),('1','143',257929,'DAILY SHIFT','2023-02-16','2023-02-16 08:16:45','2023-02-17 08:16:45','563',0.00,0.00,'563','2023-02-16 18:46:27','563','2023-02-16 18:47:56',10,0),('1','143',257930,'DAILY SHIFT','2023-02-17','2023-02-17 08:31:19','2023-02-18 08:31:19','563',0.00,0.00,'563','2023-02-17 19:15:01','563','2023-02-17 19:15:41',10,0),('1','143',257931,'DAILY SHIFT','2023-02-18','2023-02-18 08:25:24','2023-02-19 08:25:24','563',0.00,0.00,'563','2023-02-18 19:09:53','563','2023-02-18 19:10:57',10,0),('1','143',257932,'DAILY SHIFT','2023-02-19','2023-02-19 08:26:19','2023-02-20 08:26:19','563',0.00,0.00,'563','2023-02-19 18:56:20','563','2023-02-19 18:56:49',10,0),('1','143',257933,'DAILY SHIFT','2023-02-20','2023-02-20 08:14:15','2023-02-21 08:14:15','563',0.00,0.00,'563','2023-02-20 19:20:16','563','2023-02-20 19:20:49',10,0),('1','143',257934,'DAILY SHIFT','2023-02-21','2023-02-21 08:12:06','2023-02-22 08:12:06','563',0.00,0.00,'563','2023-02-21 19:10:16','563','2023-02-21 19:12:28',10,0),('1','143',257935,'DAILY SHIFT','2023-02-22','2023-02-22 08:25:26','2023-02-23 08:25:26','563',0.00,0.00,'563','2023-02-22 19:49:42','563','2023-02-22 19:50:46',10,0),('1','143',257936,'DAILY SHIFT','2023-02-23','2023-02-23 08:15:52','2023-02-24 08:15:52','563',0.00,0.00,'563','2023-02-23 19:27:16','563','2023-02-23 19:28:33',10,0),('1','143',257937,'DAILY SHIFT','2023-02-24','2023-02-24 08:00:51','2023-02-25 08:00:51','563',0.00,0.00,'563','2023-02-24 19:55:27','563','2023-02-24 19:56:08',10,0),('1','143',257938,'DAILY SHIFT','2023-02-26','2023-02-26 08:24:26','2023-02-27 08:24:26','563',0.00,0.00,'563','2023-02-27 08:47:51','563','2023-02-27 08:48:50',10,0),('1','143',257939,'DAILY SHIFT','2023-02-27','2023-02-27 08:49:14','2023-02-28 08:49:14','563',0.00,0.00,'563','2023-02-27 19:00:14','563','2023-02-27 19:00:45',10,0),('1','143',257940,'DAILY SHIFT','2023-02-28','2023-02-28 08:13:13','2023-03-01 08:13:13','563',0.00,0.00,'563','2023-02-28 18:53:49','563','2023-02-28 18:57:58',10,0),('1','143',257941,'DAILY SHIFT','2023-03-01','2023-03-01 08:25:33','2023-03-02 08:25:33','563',0.00,0.00,'563','2023-03-01 19:11:41','563','2023-03-01 19:12:27',10,0),('1','143',257942,'DAILY SHIFT','2023-03-02','2023-03-02 08:56:53','2023-03-03 08:56:53','563',0.00,0.00,'563','2023-03-02 19:37:56','563','2023-03-02 19:38:19',10,0),('1','143',257943,'DAILY SHIFT','2023-03-03','2023-03-03 08:07:05','2023-03-04 08:07:05','563',0.00,0.00,'563','2023-03-03 19:03:08','563','2023-03-03 19:03:43',10,0),('1','143',257944,'DAILY SHIFT','2023-03-04','2023-03-04 08:10:46','2023-03-05 08:10:46','563',0.00,0.00,'563','2023-03-04 19:15:07','563','2023-03-04 19:16:20',10,0),('1','143',257945,'DAILY SHIFT','2023-03-05','2023-03-05 08:15:57','2023-03-06 08:15:57','563',0.00,0.00,'563','2023-03-05 18:54:12','563','2023-03-05 18:55:02',10,0),('1','143',257946,'DAILY SHIFT','2023-03-06','2023-03-06 08:22:25','2023-03-07 08:22:25','563',0.00,0.00,'563','2023-03-06 19:42:14','563','2023-03-06 19:42:38',10,0),('1','143',257947,'DAILY SHIFT','2023-03-07','2023-03-07 08:09:44','2023-03-08 08:09:44','563',0.00,0.00,'563','2023-03-07 19:16:28','563','2023-03-07 19:17:12',10,0),('1','143',257948,'DAILY SHIFT','2023-03-08','2023-03-08 08:18:33','2023-03-09 08:18:33','563',0.00,0.00,'563','2023-03-08 18:36:23','563','2023-03-08 18:36:45',10,0),('1','143',257949,'DAILY SHIFT','2023-03-09','2023-03-09 08:14:25','2023-03-10 08:14:25','563',0.00,0.00,'563','2023-03-09 18:50:52','563','2023-03-09 18:52:01',10,0),('1','143',257950,'DAILY SHIFT','2023-03-10','2023-03-10 08:16:57','2023-03-11 08:16:57','563',0.00,0.00,'563','2023-03-10 13:07:41','563','2023-03-10 13:08:27',10,0),('1','143',257951,'DAILY SHIFT','2023-03-10','2023-03-10 13:12:35','2023-03-11 13:12:35','563',0.00,0.00,'563','2023-03-11 08:28:11','563','2023-03-11 08:34:36',10,0),('1','143',257952,'DAILY SHIFT','2023-03-11','2023-03-11 08:35:04','2023-03-12 08:35:04','563',0.00,0.00,'563','2023-03-11 19:03:34','563','2023-03-11 19:05:04',10,0),('1','143',257953,'DAILY SHIFT','2023-03-11','2023-03-11 19:21:24','2023-03-12 19:21:24','563',0.00,0.00,'563','2023-03-11 19:24:51','563','2023-03-11 19:25:13',10,0),('1','143',257954,'DAILY SHIFT','2023-03-12','2023-03-12 08:18:26','2023-03-13 08:18:26','563',0.00,0.00,'563','2023-03-12 19:01:10','563','2023-03-12 19:01:40',10,0),('1','143',257955,'DAILY SHIFT','2023-03-13','2023-03-13 08:10:57','2023-03-14 08:10:57','563',0.00,0.00,'563','2023-03-13 19:04:20','563','2023-03-13 19:05:06',10,0),('1','143',257956,'DAILY SHIFT','2023-03-14','2023-03-14 08:13:24','2023-03-15 08:13:24','563',0.00,0.00,'563','2023-03-15 08:19:04','563','2023-03-15 08:19:29',10,0),('1','143',257957,'DAILY SHIFT','2023-03-15','2023-03-15 08:20:05','2023-03-16 08:20:05','563',0.00,0.00,'563','2023-03-15 19:29:10','563','2023-03-15 19:30:32',10,0),('1','143',257958,'DAILY SHIFT','2023-03-16','2023-03-16 08:32:01','2023-03-17 08:32:01','563',0.00,0.00,'563','2023-03-16 19:03:38','563','2023-03-16 19:04:15',10,0),('1','143',257959,'DAILY SHIFT','2023-03-17','2023-03-17 08:17:08','2023-03-18 08:17:08','563',0.00,0.00,'563','2023-03-17 20:25:59','563','2023-03-17 20:26:23',10,0),('1','143',257960,'DAILY SHIFT','2023-03-19','2023-03-19 08:17:43','2023-03-20 08:17:43','563',0.00,0.00,'563','2023-03-19 18:46:40','563','2023-03-19 18:47:21',10,0),('1','143',257961,'DAILY SHIFT','2023-03-20','2023-03-20 08:32:14','2023-03-21 08:32:14','563',0.00,0.00,'563','2023-03-20 19:36:27','563','2023-03-20 19:36:52',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4905522 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','143','865','169016',3333842,'2516','382',0.00,3238.10,0.00,0.00,3238.10,975219.20,0.00,0.00,0.00),('1','143','866','169016',3333843,'2517','382',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','169220',3337591,'2516','382',3238.10,8038.90,0.00,0.00,4800.80,1421619.60,0.00,0.00,0.00),('1','143','866','169220',3337592,'2517','382',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','169328',3339598,'2516','382',8038.90,10254.50,0.00,0.00,2215.60,659169.20,0.00,0.00,0.00),('1','143','866','169328',3339599,'2517','382',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','169505',3343194,'2516','382',10254.50,12788.70,0.00,0.00,2534.20,752016.40,0.00,0.00,0.00),('1','143','866','169505',3343195,'2517','382',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','169745',3347837,'2516','382',12788.70,17307.70,0.00,0.00,4519.00,1329914.00,0.00,0.00,0.00),('1','143','866','169745',3347838,'2517','382',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','169889',3350630,'2516','382',17307.70,20264.30,0.00,0.00,2956.60,881649.20,0.00,0.00,0.00),('1','143','866','169889',3350631,'2517','382',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','170082',3354073,'2516','382',20264.30,21706.20,0.00,0.00,1441.90,442942.80,0.00,0.00,0.00),('1','143','866','170082',3354074,'2517','382',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','170188',3355673,'2516','382',21706.20,21706.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','170188',3355674,'2517','382',0.00,2844.10,0.00,0.00,2844.10,836550.00,0.00,0.00,0.00),('1','143','865','170392',3359204,'2516','382',21706.20,21706.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','170392',3359205,'2517','382',2844.10,5447.00,0.00,0.00,2602.90,767470.00,0.00,0.00,0.00),('1','143','865','170523',3361510,'2516','382',21706.20,21706.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','170523',3361511,'2517','382',5447.00,8316.10,0.00,0.00,2869.10,842470.00,0.00,0.00,0.00),('1','143','865','170702',3364736,'2516','382',21706.20,21706.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','170702',3364737,'2517','382',8316.10,11084.00,0.00,0.00,2767.90,813530.00,0.00,0.00,0.00),('1','143','865','170893',3368114,'2516','382',21706.20,21706.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','170893',3368115,'2517','382',11084.00,13394.10,0.00,0.00,2310.10,676470.00,0.00,0.00,0.00),('1','143','865','171058',3371110,'2516','382',21706.20,21706.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','171058',3371111,'2517','382',13394.10,15453.70,0.00,0.00,2059.60,608775.00,0.00,0.00,0.00),('1','143','865','171223',3374275,'2516','382',21706.20,21706.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','171223',3374276,'2517','382',15453.70,19370.80,0.00,0.00,3917.10,1145178.00,0.00,0.00,0.00),('1','143','865','171427',3377928,'2516','382',21706.20,21706.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','171427',3377929,'2517','382',19370.80,22548.80,0.00,0.00,3178.00,928070.00,0.00,0.00,0.00),('1','143','865','171550',3380270,'2516','382',21706.20,21706.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','171550',3380271,'2517','382',22548.80,22548.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','171560',3380460,'2516','382',21706.20,21706.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','171560',3380461,'2517','382',22548.80,22548.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','171776',3384183,'2516','382',21706.20,24177.20,0.00,0.00,2471.00,726226.00,0.00,0.00,0.00),('1','143','866','171776',3384184,'2517','382',22548.80,22548.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','171779',3384189,'2516','382',24177.20,25872.50,0.00,0.00,1695.30,502075.00,0.00,0.00,0.00),('1','143','866','171779',3384190,'2517','382',22548.80,22548.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','171953',3387397,'2516','382',25872.50,29969.10,0.00,0.00,4096.60,1197890.00,0.00,0.00,0.00),('1','143','866','171953',3387398,'2517','382',22548.80,22548.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','172087',3389812,'2516','382',29969.10,32434.50,0.00,0.00,2465.40,728165.00,0.00,0.00,0.00),('1','143','866','172087',3389813,'2517','382',22548.80,22548.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','172281',3393381,'2516','382',32434.50,35807.00,0.00,0.00,3372.50,989700.00,0.00,0.00,0.00),('1','143','866','172281',3393382,'2517','382',22548.80,22548.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','172506',3397518,'2516','382',35807.00,38063.70,0.00,0.00,2256.70,670300.00,0.00,0.00,0.00),('1','143','866','172506',3397519,'2517','382',22548.80,22548.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','172788',3402656,'2516','382',38063.70,42380.30,0.00,0.00,4316.60,1258118.00,0.00,0.00,0.00),('1','143','866','172788',3402657,'2517','382',22548.80,22548.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','172881',3404322,'2516','382',42380.30,45297.80,0.00,0.00,2917.50,861290.00,0.00,0.00,0.00),('1','143','866','172881',3404323,'2517','382',22548.80,22548.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','173068',3407859,'2516','382',45297.80,45297.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','173068',3407860,'2517','382',22548.80,23530.60,0.00,0.00,981.80,301456.00,0.00,0.00,0.00),('1','143','865','173069',3407861,'2516','382',45297.80,46034.00,0.00,0.00,736.20,219345.00,0.00,0.00,0.00),('1','143','866','173069',3407862,'2517','382',23530.60,23530.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','173228',3411097,'2516','382',46034.00,46034.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','173228',3411098,'2517','382',23530.60,25921.60,0.00,0.00,2391.00,747120.00,0.00,0.00,0.00),('1','143','865','173439',3414776,'2516','382',46034.00,46034.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','173439',3414777,'2517','382',25921.60,30580.00,0.00,0.00,4658.40,1385040.00,0.00,0.00,0.00),('1','143','865','173587',3417714,'2516','382',46034.00,46034.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','173587',3417715,'2517','382',30580.00,32741.40,0.00,0.00,2161.40,669838.00,0.00,0.00,0.00),('1','143','865','173763',3420796,'2516','382',46034.00,46034.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','173763',3420797,'2517','382',32741.40,35346.00,0.00,0.00,2604.60,793262.00,0.00,0.00,0.00),('1','143','865','173942',3424081,'2516','382',46034.00,46034.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','173942',3424082,'2517','382',35346.00,37849.80,0.00,0.00,2503.80,771526.00,0.00,0.00,0.00),('1','143','865','174126',3427329,'2516','382',46034.00,46034.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','174126',3427330,'2517','382',37849.80,40057.60,0.00,0.00,2207.80,684167.60,0.00,0.00,0.00),('1','143','865','174163',3427775,'2516','382',46034.00,46034.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','174163',3427776,'2517','382',40057.60,40057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','174323',3430965,'2516','382',46034.00,46034.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','174323',3430966,'2517','382',40057.60,45630.70,0.00,0.00,5573.10,1639989.80,0.00,0.00,0.00),('1','143','865','174497',3433848,'2516','382',46034.00,46623.00,0.00,0.00,589.00,170810.00,0.00,0.00,0.00),('1','143','866','174497',3433849,'2517','382',45630.70,46654.90,0.00,0.00,1024.20,315453.60,0.00,0.00,0.00),('1','143','865','174500',3433874,'2516','382',46623.00,47917.20,0.00,0.00,1294.20,390519.60,0.00,0.00,0.00),('1','143','866','174500',3433875,'2517','382',46654.90,46654.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','174649',3436491,'2516','382',47917.20,53050.70,0.00,0.00,5133.50,1524161.00,0.00,0.00,0.00),('1','143','866','174649',3436492,'2517','382',46654.90,46654.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','174847',3440186,'2516','382',53050.70,56344.40,0.00,0.00,3293.70,984807.60,0.00,0.00,0.00),('1','143','866','174847',3440187,'2517','382',46654.90,46654.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','175056',3444149,'2516','382',56344.40,58457.60,0.00,0.00,2113.20,700115.20,0.00,0.00,0.00),('1','143','866','175056',3444150,'2517','382',46654.90,46654.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','175246',3447529,'2516','382',58457.60,60519.00,0.00,0.00,2061.40,684010.40,0.00,0.00,0.00),('1','143','866','175246',3447530,'2517','382',46654.90,46654.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','175421',3450761,'2516','382',60519.00,62462.80,0.00,0.00,1943.80,648636.80,0.00,0.00,0.00),('1','143','866','175421',3450762,'2517','382',46654.90,46654.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','175601',3454033,'2516','382',62462.80,64618.30,0.00,0.00,2155.50,718488.00,0.00,0.00,0.00),('1','143','866','175601',3454034,'2517','382',46654.90,46654.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','175762',3457081,'2516','382',64618.30,68505.90,0.00,0.00,3887.60,1207532.00,0.00,0.00,0.00),('1','143','866','175762',3457082,'2517','382',46654.90,46654.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','175957',3460475,'2516','382',68505.90,68505.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','175957',3460476,'2517','382',46654.90,46654.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','175977',3460898,'2516','382',68505.90,71330.60,0.00,0.00,2824.70,883104.00,0.00,0.00,0.00),('1','143','866','175977',3460899,'2517','382',46654.90,46654.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','175992',3461243,'2516','382',71330.60,71330.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','175992',3461244,'2517','382',46654.90,46993.20,0.00,0.00,338.30,106256.00,0.00,0.00,0.00),('1','143','865','176143',3463886,'2516','382',71330.60,71330.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','176143',3463887,'2517','382',46993.20,52560.30,0.00,0.00,5567.10,1715652.00,0.00,0.00,0.00),('1','143','865','176347',3467582,'2516','382',71330.60,71330.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','176347',3467583,'2517','382',52560.30,55577.90,0.00,0.00,3017.60,937512.00,0.00,0.00,0.00),('1','143','865','176564',3471721,'2516','382',71330.60,71330.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','176564',3471722,'2517','382',55577.90,59416.40,0.00,0.00,3838.50,1199868.00,0.00,0.00,0.00),('1','143','865','176789',3475803,'2516','382',71330.60,71330.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','176789',3475804,'2517','382',59416.40,62153.10,0.00,0.00,2736.70,881809.40,0.00,0.00,0.00),('1','143','865','176991',3479449,'2516','382',71330.60,71330.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','176991',3479450,'2517','382',62153.10,64612.90,0.00,0.00,2459.80,806295.40,0.00,0.00,0.00),('1','143','865','177231',3484272,'2516','382',71330.60,71330.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','177231',3484273,'2517','382',64612.90,67717.30,0.00,0.00,3104.40,1003165.20,0.00,0.00,0.00),('1','143','865','177428',3488234,'2516','382',71330.60,71330.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','177428',3488235,'2517','382',67717.30,69800.80,0.00,0.00,2083.50,686645.50,0.00,0.00,0.00),('1','143','865','177620',3492278,'2516','382',71330.60,71330.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','177620',3492279,'2517','382',69800.80,70809.60,0.00,0.00,1008.80,327152.40,0.00,0.00,0.00),('1','143','865','177621',3492280,'2516','382',71330.60,73079.50,0.00,0.00,1748.90,565751.70,0.00,0.00,0.00),('1','143','866','177621',3492281,'2517','382',70809.60,70809.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','177819',3495794,'2516','382',73079.50,73079.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','177819',3495795,'2517','382',70809.60,70809.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','177892',3496960,'2516','382',73079.50,75065.90,0.00,0.00,1986.40,647443.20,0.00,0.00,0.00),('1','143','866','177892',3496961,'2517','382',70809.60,70809.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','178081',3500799,'2516','382',75065.90,76673.30,0.00,0.00,1607.40,524764.20,0.00,0.00,0.00),('1','143','866','178081',3500800,'2517','382',70809.60,70809.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','178291',3504617,'2516','382',76673.30,78593.30,0.00,0.00,1920.00,619032.00,0.00,0.00,0.00),('1','143','866','178291',3504618,'2517','382',70809.60,70809.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','178496',3508388,'2516','382',78593.30,80050.50,0.00,0.00,1457.20,479850.60,0.00,0.00,0.00),('1','143','866','178496',3508389,'2517','382',70809.60,70809.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','178737',3512786,'2516','382',80050.50,81413.30,0.00,0.00,1362.80,466163.20,0.00,0.00,0.00),('1','143','866','178737',3512787,'2517','382',70809.60,70809.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','178877',3515422,'2516','382',81413.30,82698.40,0.00,0.00,1285.10,442074.40,0.00,0.00,0.00),('1','143','866','178877',3515423,'2517','382',70809.60,70809.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','178909',3515853,'2516','382',82698.40,84241.20,0.00,0.00,1542.80,523139.20,0.00,0.00,0.00),('1','143','866','178909',3515854,'2517','382',70809.60,70809.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','179371',3524726,'2516','382',84241.20,86107.70,0.00,0.00,1866.50,629973.60,0.00,0.00,0.00),('1','143','866','179371',3524727,'2517','382',70809.60,70809.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','179577',3528505,'2516','382',86107.70,88961.10,0.00,0.00,2853.40,952913.60,0.00,0.00,0.00),('1','143','866','179577',3528506,'2517','382',70809.60,70809.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','179767',3532375,'2516','382',88961.10,91177.70,0.00,0.00,2216.60,749222.40,0.00,0.00,0.00),('1','143','866','179767',3532376,'2517','382',70809.60,70809.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','179775',3532474,'2516','382',91177.70,93042.43,0.00,0.00,1864.73,633771.12,0.00,0.00,0.00),('1','143','866','179775',3532475,'2517','382',70809.60,70809.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','179993',3536419,'2516','382',93042.43,95274.98,0.00,0.00,2232.55,748733.20,0.00,0.00,0.00),('1','143','866','179993',3536420,'2517','382',70809.60,70809.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','180117',3538676,'2516','382',95274.98,95274.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','180117',3538677,'2517','382',70809.60,71444.40,0.00,0.00,634.80,214131.20,0.00,0.00,0.00),('1','143','865','180186',3540027,'2516','382',95274.98,95274.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','180186',3540028,'2517','382',71444.40,73983.91,0.00,0.00,2539.51,851943.44,0.00,0.00,0.00),('1','143','865','180304',3542251,'2516','382',95274.98,95625.78,0.00,0.00,350.80,117667.20,0.00,0.00,0.00),('1','143','866','180304',3542252,'2517','382',73983.91,73983.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','180356',3543060,'2516','382',95625.78,95637.78,0.00,0.00,12.00,4128.00,0.00,0.00,0.00),('1','143','866','180356',3543061,'2517','382',73983.91,77144.41,0.00,0.00,3160.50,1054165.60,0.00,0.00,0.00),('1','143','865','180556',3546706,'2516','382',95637.78,95637.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','180556',3546707,'2517','382',77144.41,80835.51,0.00,0.00,3691.10,1229914.40,0.00,0.00,0.00),('1','143','865','180743',3550081,'2516','382',95637.78,95637.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','180743',3550082,'2517','382',80835.51,83387.11,0.00,0.00,2551.60,860926.40,0.00,0.00,0.00),('1','143','865','180966',3554441,'2516','382',95637.78,95637.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','180966',3554442,'2517','382',83387.11,86293.42,0.00,0.00,2906.31,980430.64,0.00,0.00,0.00),('1','143','865','181139',3557677,'2516','382',95637.78,95637.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','181139',3557678,'2517','382',86293.42,87862.88,0.00,0.00,1569.46,536502.24,0.00,0.00,0.00),('1','143','865','181342',3561768,'2516','382',95637.78,95637.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','181342',3561769,'2517','382',87862.88,89985.87,0.00,0.00,2122.99,720436.56,0.00,0.00,0.00),('1','143','865','181528',3565103,'2516','382',95637.78,95637.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','181528',3565104,'2517','382',89985.87,93568.19,0.00,0.00,3582.32,1199474.08,0.00,0.00,0.00),('1','143','865','181716',3568228,'2516','382',95637.78,95637.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','181716',3568229,'2517','382',93568.19,93568.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','181722',3568302,'2516','382',95637.78,95637.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','181722',3568303,'2517','382',93568.19,95000.62,0.00,0.00,1432.43,476215.92,0.00,0.00,0.00),('1','143','865','181805',3569871,'2516','382',95637.78,97176.78,0.00,0.00,1539.00,515688.00,0.00,0.00,0.00),('1','143','866','181805',3569872,'2517','382',95000.62,95118.07,0.00,0.00,117.45,39602.80,0.00,0.00,0.00),('1','143','865','181916',3571678,'2516','382',97176.78,97176.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','181916',3571679,'2517','382',95118.07,95329.57,0.00,0.00,211.50,70056.00,0.00,0.00,0.00),('1','143','865','181922',3571772,'2516','382',97176.78,99788.61,0.00,0.00,2611.83,877469.52,0.00,0.00,0.00),('1','143','866','181922',3571773,'2517','382',95329.57,95329.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','182115',3575552,'2516','382',99788.61,102067.26,0.00,0.00,2278.65,771263.60,0.00,0.00,0.00),('1','143','866','182115',3575553,'2517','382',95329.57,95329.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','182317',3578974,'2516','382',102067.26,105207.73,0.00,0.00,3140.47,1052237.68,0.00,0.00,0.00),('1','143','866','182317',3578975,'2517','382',95329.57,95329.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','182507',3582414,'2516','382',105207.73,109646.43,0.00,0.00,4438.70,1493772.80,0.00,0.00,0.00),('1','143','866','182507',3582415,'2517','382',95329.57,95335.57,0.00,0.00,6.00,2064.00,0.00,0.00,0.00),('1','143','865','182691',3585899,'2516','382',109646.43,111952.56,0.00,0.00,2306.13,781844.72,0.00,0.00,0.00),('1','143','866','182691',3585900,'2517','382',95335.57,95341.57,0.00,0.00,6.00,2064.00,0.00,0.00,0.00),('1','143','865','182848',3588876,'2516','382',111952.56,113714.05,0.00,0.00,1761.49,599352.56,0.00,0.00,0.00),('1','143','866','182848',3588877,'2517','382',95341.57,95341.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','182988',3591451,'2516','382',113714.05,116125.95,0.00,0.00,2411.90,807149.60,0.00,0.00,0.00),('1','143','866','182988',3591452,'2517','382',95341.57,95341.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','183219',3595654,'2516','382',116125.95,117607.31,0.00,0.00,1481.36,506451.84,0.00,0.00,0.00),('1','143','866','183219',3595655,'2517','382',95341.57,95341.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','183431',3599430,'2516','382',117607.31,119167.62,0.00,0.00,1560.31,532122.64,0.00,0.00,0.00),('1','143','866','183431',3599431,'2517','382',95341.57,95341.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','183630',3603190,'2516','382',119167.62,119167.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','183630',3603191,'2517','382',95341.57,95341.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','183650',3603385,'2516','382',119167.62,119568.97,0.00,0.00,401.35,138064.40,0.00,0.00,0.00),('1','143','866','183650',3603386,'2517','382',95341.57,95941.45,0.00,0.00,599.88,198558.72,0.00,0.00,0.00),('1','143','865','183759',3605440,'2516','382',119568.97,119590.47,0.00,0.00,21.50,7396.00,0.00,0.00,0.00),('1','143','866','183759',3605441,'2517','382',95941.45,97240.25,0.00,0.00,1298.80,436003.20,0.00,0.00,0.00),('1','143','865','183922',3608361,'2516','382',119590.47,119596.27,0.00,0.00,5.80,1995.20,0.00,0.00,0.00),('1','143','866','183922',3608362,'2517','382',97240.25,98091.27,0.00,0.00,851.02,290446.88,0.00,0.00,0.00),('1','143','865','184055',3610853,'2516','382',119596.27,119730.67,0.00,0.00,134.40,46233.60,0.00,0.00,0.00),('1','143','866','184055',3610854,'2517','382',98091.27,98091.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','184100',3611606,'2516','382',119730.67,119730.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','184100',3611607,'2517','382',98091.27,99068.52,0.00,0.00,977.25,335974.00,0.00,0.00,0.00),('1','143','865','184274',3614635,'2516','382',119730.67,119733.67,0.00,0.00,3.00,1032.00,0.00,0.00,0.00),('1','143','866','184274',3614636,'2517','382',99068.52,100973.30,0.00,0.00,1904.78,647028.32,0.00,0.00,0.00),('1','143','865','184473',3618128,'2516','382',119733.67,119738.67,0.00,0.00,5.00,1720.00,0.00,0.00,0.00),('1','143','866','184473',3618129,'2517','382',100973.30,102392.68,0.00,0.00,1419.38,486283.20,0.00,0.00,0.00),('1','143','865','184698',3622276,'2516','382',119738.67,119738.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','184698',3622277,'2517','382',102392.68,103703.18,0.00,0.00,1310.50,449972.00,0.00,0.00,0.00),('1','143','865','184888',3625763,'2516','382',119738.67,119738.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','184888',3625764,'2517','382',103703.18,105170.61,0.00,0.00,1467.43,501865.92,0.00,0.00,0.00),('1','143','865','185108',3629491,'2516','382',119738.67,119738.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','185108',3629492,'2517','382',105170.61,106618.55,0.00,0.00,1447.94,489923.36,0.00,0.00,0.00),('1','143','865','185261',3631895,'2516','382',119738.67,119738.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','185261',3631896,'2517','382',106618.55,108570.32,0.00,0.00,1951.77,658960.88,0.00,0.00,0.00),('1','143','865','185470',3635813,'2516','382',119738.67,119738.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','185470',3635814,'2517','382',108570.32,110571.96,0.00,0.00,2001.64,676476.16,0.00,0.00,0.00),('1','143','865','185676',3639531,'2516','382',119738.67,119738.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','185676',3639532,'2517','382',110571.96,112148.87,0.00,0.00,1576.91,534157.04,0.00,0.00,0.00),('1','143','865','185876',3643091,'2516','382',119738.67,119738.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','185876',3643092,'2517','382',112148.87,113202.18,0.00,0.00,1053.31,360713.04,0.00,0.00,0.00),('1','143','865','186106',3647195,'2516','382',119738.67,119738.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','186106',3647196,'2517','382',113202.18,114660.20,0.00,0.00,1458.02,496438.88,0.00,0.00,0.00),('1','143','865','186320',3650711,'2516','382',119738.67,119738.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','186320',3650712,'2517','382',114660.20,115999.96,0.00,0.00,1339.76,453640.64,0.00,0.00,0.00),('1','143','865','186539',3654466,'2516','382',119738.67,119738.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','186539',3654467,'2517','382',115999.96,116988.56,0.00,0.00,988.60,337454.40,0.00,0.00,0.00),('1','143','865','186761',3658242,'2516','382',119738.67,119738.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','186761',3658243,'2517','382',116988.56,118300.20,0.00,0.00,1311.64,441996.16,0.00,0.00,0.00),('1','143','865','187168',3665069,'2516','382',119738.67,119738.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','187168',3665070,'2517','382',118300.20,119954.53,0.00,0.00,1654.33,553443.12,0.00,0.00,0.00),('1','143','865','187253',3666595,'2516','382',119738.67,120399.52,0.00,0.00,660.85,227332.40,0.00,0.00,0.00),('1','143','866','187253',3666596,'2517','382',119954.53,119965.53,0.00,0.00,11.00,3784.00,0.00,0.00,0.00),('1','143','865','187354',3668557,'2516','382',120399.52,122376.80,0.00,0.00,1977.28,670118.32,0.00,0.00,0.00),('1','143','866','187354',3668558,'2517','382',119965.53,119965.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','187613',3673073,'2516','382',122376.80,124266.17,0.00,0.00,1889.37,642807.28,0.00,0.00,0.00),('1','143','866','187613',3673074,'2517','382',119965.53,119978.03,0.00,0.00,12.50,4300.00,0.00,0.00,0.00),('1','143','865','187817',3676681,'2516','382',124266.17,126864.76,0.00,0.00,2598.59,874252.96,0.00,0.00,0.00),('1','143','866','187817',3676682,'2517','382',119978.03,119978.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','188021',3680271,'2516','382',126864.76,130128.88,0.00,0.00,3264.12,1103965.28,0.00,0.00,0.00),('1','143','866','188021',3680272,'2517','382',119978.03,119978.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','188219',3683685,'2516','382',130128.88,134405.09,0.00,0.00,4276.21,1441628.24,0.00,0.00,0.00),('1','143','866','188219',3683686,'2517','382',119978.03,119978.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','188430',3687276,'2516','382',134405.09,138060.46,0.00,0.00,3655.37,1222519.28,0.00,0.00,0.00),('1','143','866','188430',3687277,'2517','382',119978.03,119978.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','188608',3690408,'2516','382',138060.46,142444.60,0.00,0.00,4384.14,1454288.16,0.00,0.00,0.00),('1','143','866','188608',3690409,'2517','382',119978.03,119978.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','188782',3693654,'2516','382',142444.60,142444.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','188782',3693655,'2517','382',119978.03,119978.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','188808',3693958,'2516','382',142444.60,144490.16,0.00,0.00,2045.56,685612.64,0.00,0.00,0.00),('1','143','866','188808',3693959,'2517','382',119978.03,119978.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','188922',3696039,'2516','382',144490.16,144548.07,0.00,0.00,57.91,19921.04,0.00,0.00,0.00),('1','143','866','188922',3696040,'2517','382',119978.03,123483.90,0.00,0.00,3505.87,1161719.28,0.00,0.00,0.00),('1','143','865','189016',3697742,'2516','382',144548.07,144548.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','189016',3697743,'2517','382',123483.90,127322.87,0.00,0.00,3838.97,1274019.68,0.00,0.00,0.00),('1','143','865','189208',3701106,'2516','382',144548.07,144549.47,0.00,0.00,1.40,481.60,0.00,0.00,0.00),('1','143','866','189208',3701107,'2517','382',127322.87,130370.62,0.00,0.00,3047.75,1016502.00,0.00,0.00,0.00),('1','143','865','189430',3705138,'2516','382',144549.47,144549.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','189430',3705139,'2517','382',130370.62,132030.19,0.00,0.00,1659.57,563052.08,0.00,0.00,0.00),('1','143','865','189637',3708680,'2516','382',144549.47,144549.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','189637',3708681,'2517','382',132030.19,134697.79,0.00,0.00,2667.60,891736.40,0.00,0.00,0.00),('1','143','865','189820',3711967,'2516','382',144549.47,144549.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','189820',3711968,'2517','382',134697.79,136773.17,0.00,0.00,2075.38,701314.72,0.00,0.00,0.00),('1','143','865','190032',3716238,'2516','382',144549.47,144549.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','190032',3716239,'2517','382',136773.17,139791.21,0.00,0.00,3018.04,1014293.76,0.00,0.00,0.00),('1','143','865','190224',3719819,'2516','382',144549.47,144549.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','190224',3719820,'2517','382',139791.21,143452.02,0.00,0.00,3660.81,1222362.64,0.00,0.00,0.00),('1','143','865','190441',3723829,'2516','382',144549.47,144549.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','190441',3723830,'2517','382',143452.02,144408.92,0.00,0.00,956.90,321973.60,0.00,0.00,0.00),('1','143','865','190564',3726005,'2516','382',144549.47,148632.55,0.00,0.00,4083.08,1368530.52,0.00,0.00,0.00),('1','143','866','190564',3726006,'2517','382',144408.92,144437.52,0.00,0.00,28.60,9838.40,0.00,0.00,0.00),('1','143','865','190682',3728294,'2516','382',148632.55,154091.83,0.00,0.00,5459.28,1808396.32,0.00,0.00,0.00),('1','143','866','190682',3728295,'2517','382',144437.52,144556.02,0.00,0.00,118.50,39836.00,0.00,0.00,0.00),('1','143','865','190852',3731641,'2516','382',154091.83,154091.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','190852',3731642,'2517','382',144556.02,144585.02,0.00,0.00,29.00,9976.00,0.00,0.00,0.00),('1','143','865','190905',3732350,'2516','382',154091.83,156908.18,0.00,0.00,2816.35,936826.40,0.00,0.00,0.00),('1','143','866','190905',3732351,'2517','382',144585.02,144604.28,0.00,0.00,19.26,6625.44,0.00,0.00,0.00),('1','143','865','191089',3735620,'2516','382',156908.18,158017.48,0.00,0.00,1109.30,376799.20,0.00,0.00,0.00),('1','143','866','191089',3735621,'2517','382',144604.28,144604.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','191318',3739583,'2516','382',158017.48,159567.82,0.00,0.00,1550.34,520780.96,0.00,0.00,0.00),('1','143','866','191318',3739584,'2517','382',144604.28,144604.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','191504',3743012,'2516','382',159567.82,161005.83,0.00,0.00,1438.01,486579.44,0.00,0.00,0.00),('1','143','866','191504',3743013,'2517','382',144604.28,144610.28,0.00,0.00,6.00,2064.00,0.00,0.00,0.00),('1','143','865','191725',3747338,'2516','382',161005.83,162610.15,0.00,0.00,1604.32,539834.08,0.00,0.00,0.00),('1','143','866','191725',3747339,'2517','382',144610.28,144616.38,0.00,0.00,6.10,2098.40,0.00,0.00,0.00),('1','143','865','191946',3751659,'2516','382',162610.15,164039.66,0.00,0.00,1429.51,472121.44,0.00,0.00,0.00),('1','143','866','191946',3751660,'2517','382',144616.38,144616.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','192034',3753167,'2516','382',164039.66,164042.56,0.00,0.00,2.90,997.60,0.00,0.00,0.00),('1','143','866','192034',3753168,'2517','382',144616.38,145380.46,0.00,0.00,764.08,258057.52,0.00,0.00,0.00),('1','143','865','192139',3754990,'2516','382',164042.56,164067.56,0.00,0.00,25.00,8600.00,0.00,0.00,0.00),('1','143','866','192139',3754991,'2517','382',145380.46,147027.52,0.00,0.00,1647.06,555608.64,0.00,0.00,0.00),('1','143','865','192347',3758924,'2516','382',164067.56,164067.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','192347',3758925,'2517','382',147027.52,148077.32,0.00,0.00,1049.80,357547.20,0.00,0.00,0.00),('1','143','865','192593',3763217,'2516','382',164067.56,164067.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','192593',3763218,'2517','382',148077.32,149387.67,0.00,0.00,1310.35,441352.40,0.00,0.00,0.00),('1','143','865','192760',3766295,'2516','382',164067.56,164067.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','192760',3766296,'2517','382',149387.67,150878.08,0.00,0.00,1490.41,501975.04,0.00,0.00,0.00),('1','143','865','192983',3770327,'2516','382',164067.56,164067.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','192983',3770328,'2517','382',150878.08,151862.13,0.00,0.00,984.05,337713.20,0.00,0.00,0.00),('1','143','865','193183',3774170,'2516','382',164067.56,164067.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','193183',3774171,'2517','382',151862.13,153070.97,0.00,0.00,1208.84,408820.96,0.00,0.00,0.00),('1','143','865','193417',3778915,'2516','382',164067.56,164067.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','193417',3778916,'2517','382',153070.97,154185.05,0.00,0.00,1114.08,378843.52,0.00,0.00,0.00),('1','143','865','193632',3782921,'2516','382',164067.56,164067.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','193632',3782922,'2517','382',154185.05,155438.95,0.00,0.00,1253.90,424281.60,0.00,0.00,0.00),('1','143','865','193868',3787034,'2516','382',164067.56,164067.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','193868',3787035,'2517','382',155438.95,157185.81,0.00,0.00,1746.86,585575.84,0.00,0.00,0.00),('1','143','865','194088',3790973,'2516','382',164067.56,164067.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','194088',3790974,'2517','382',157185.81,159406.58,0.00,0.00,2220.77,732418.88,0.00,0.00,0.00),('1','143','865','194296',3794872,'2516','382',164067.56,164067.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','194296',3794873,'2517','382',159406.58,161667.66,0.00,0.00,2261.08,767383.52,0.00,0.00,0.00),('1','143','865','194490',3798344,'2516','382',164067.56,164067.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','194490',3798345,'2517','382',161667.66,163377.28,0.00,0.00,1709.62,573655.28,0.00,0.00,0.00),('1','143','865','194689',3801799,'2516','382',164067.56,164067.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','194689',3801800,'2517','382',163377.28,165161.20,0.00,0.00,1783.92,600292.48,0.00,0.00,0.00),('1','143','865','194872',3805751,'2516','382',164067.56,164067.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','194872',3805752,'2517','382',165161.20,167674.96,0.00,0.00,2513.76,833537.44,0.00,0.00,0.00),('1','143','865','195090',3809480,'2516','382',164067.56,164067.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','195090',3809481,'2517','382',167674.96,169298.69,0.00,0.00,1623.73,535837.12,0.00,0.00,0.00),('1','143','865','195245',3812312,'2516','382',164067.56,165366.68,0.00,0.00,1299.12,428197.28,0.00,0.00,0.00),('1','143','866','195245',3812313,'2517','382',169298.69,169298.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','195313',3813421,'2516','382',165366.68,167183.79,0.00,0.00,1817.11,612919.84,0.00,0.00,0.00),('1','143','866','195313',3813422,'2517','382',169298.69,169346.19,0.00,0.00,47.50,16340.00,0.00,0.00,0.00),('1','143','865','195527',3817244,'2516','382',167183.79,168863.84,0.00,0.00,1680.05,564835.76,0.00,0.00,0.00),('1','143','866','195527',3817245,'2517','382',169346.19,169352.19,0.00,0.00,6.00,2064.00,0.00,0.00,0.00),('1','143','865','195792',3821553,'2516','382',168863.84,171467.28,0.00,0.00,2603.44,863804.36,0.00,0.00,0.00),('1','143','866','195792',3821554,'2517','382',169352.19,169352.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','196017',3825756,'2516','382',171467.28,172508.70,0.00,0.00,1041.42,354970.48,0.00,0.00,0.00),('1','143','866','196017',3825757,'2517','382',169352.19,169364.69,0.00,0.00,12.50,4300.00,0.00,0.00,0.00),('1','143','865','196242',3830068,'2516','382',172508.70,174877.78,0.00,0.00,2369.08,787067.52,0.00,0.00,0.00),('1','143','866','196242',3830069,'2517','382',169364.69,169364.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','196485',3834340,'2516','382',174877.78,177548.35,0.00,0.00,2670.57,894916.08,0.00,0.00,0.00),('1','143','866','196485',3834341,'2517','382',169364.69,169364.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','196676',3837810,'2516','382',177548.35,180234.42,0.00,0.00,2686.07,891844.08,0.00,0.00,0.00),('1','143','866','196676',3837811,'2517','382',169364.69,169364.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','196956',3842835,'2516','382',180234.42,180462.12,0.00,0.00,227.70,78328.80,0.00,0.00,0.00),('1','143','866','196956',3842836,'2517','382',169364.69,169364.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','197043',3844363,'2516','382',180462.12,181847.73,0.00,0.00,1385.61,461183.84,0.00,0.00,0.00),('1','143','866','197043',3844364,'2517','382',169364.69,169364.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','197300',3849477,'2516','382',181847.73,183341.33,0.00,0.00,1493.60,498574.40,0.00,0.00,0.00),('1','143','866','197300',3849478,'2517','382',169364.69,169364.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','197306',3849571,'2516','382',183341.33,185125.56,0.00,0.00,1784.23,591225.12,0.00,0.00,0.00),('1','143','866','197306',3849572,'2517','382',169364.69,169364.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','197528',3852590,'2516','382',185125.56,187666.17,0.00,0.00,2540.61,839330.84,0.00,0.00,0.00),('1','143','866','197528',3852591,'2517','382',169364.69,169379.51,0.00,0.00,14.82,5098.08,0.00,0.00,0.00),('1','143','865','197888',3859049,'2516','382',187666.17,188532.79,0.00,0.00,866.62,287689.28,0.00,0.00,0.00),('1','143','866','197888',3859050,'2517','382',169379.51,169379.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','197999',3861112,'2516','382',188532.79,188535.79,0.00,0.00,3.00,1032.00,0.00,0.00,0.00),('1','143','866','197999',3861113,'2517','382',169379.51,170027.06,0.00,0.00,647.55,220502.20,0.00,0.00,0.00),('1','143','865','198122',3863158,'2516','382',188535.79,188535.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','198122',3863159,'2517','382',170027.06,171515.67,0.00,0.00,1488.61,496791.84,0.00,0.00,0.00),('1','143','865','198370',3867257,'2516','382',188535.79,188535.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','198370',3867258,'2517','382',171515.67,173189.63,0.00,0.00,1673.96,558484.24,0.00,0.00,0.00),('1','143','865','198583',3870945,'2516','382',188535.79,188535.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','198583',3870946,'2517','382',173189.63,174929.12,0.00,0.00,1739.49,574954.56,0.00,0.00,0.00),('1','143','865','198814',3874774,'2516','382',188535.79,188535.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','198814',3874775,'2517','382',174929.12,176502.22,0.00,0.00,1573.10,527220.40,0.00,0.00,0.00),('1','143','865','198994',3878040,'2516','382',188535.79,188535.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','198994',3878041,'2517','382',176502.22,177807.91,0.00,0.00,1305.69,443085.36,0.00,0.00,0.00),('1','143','865','199229',3882145,'2516','382',188535.79,188535.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','199229',3882146,'2517','382',177807.91,180301.59,0.00,0.00,2493.68,830127.92,0.00,0.00,0.00),('1','143','865','199448',3885599,'2516','382',188535.79,188535.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','199448',3885600,'2517','382',180301.59,182753.16,0.00,0.00,2451.57,810912.08,0.00,0.00,0.00),('1','143','865','199677',3889423,'2516','382',188535.79,188535.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','199677',3889424,'2517','382',182753.16,183785.49,0.00,0.00,1032.33,345375.52,0.00,0.00,0.00),('1','143','865','199830',3891953,'2516','382',188535.79,189087.39,0.00,0.00,551.60,185350.40,0.00,0.00,0.00),('1','143','866','199830',3891954,'2517','382',183785.49,183798.99,0.00,0.00,13.50,4644.00,0.00,0.00,0.00),('1','143','865','199900',3892943,'2516','382',189087.39,190713.72,0.00,0.00,1626.33,541527.52,0.00,0.00,0.00),('1','143','866','199900',3892944,'2517','382',183798.99,183829.99,0.00,0.00,31.00,10664.00,0.00,0.00,0.00),('1','143','865','200110',3896875,'2516','382',190713.72,192920.64,0.00,0.00,2206.92,742152.48,0.00,0.00,0.00),('1','143','866','200110',3896876,'2517','382',183829.99,183835.99,0.00,0.00,6.00,2064.00,0.00,0.00,0.00),('1','143','865','200307',3900377,'2516','382',192920.64,195374.35,0.00,0.00,2453.71,822318.24,0.00,0.00,0.00),('1','143','866','200307',3900378,'2517','382',183835.99,183841.99,0.00,0.00,6.00,2064.00,0.00,0.00,0.00),('1','143','865','200507',3904143,'2516','382',195374.35,197412.31,0.00,0.00,2037.96,692148.24,0.00,0.00,0.00),('1','143','866','200507',3904144,'2517','382',183841.99,183841.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','200746',3908311,'2516','382',197412.31,199410.10,0.00,0.00,1997.79,671663.76,0.00,0.00,0.00),('1','143','866','200746',3908312,'2517','382',183841.99,183841.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','200937',3911680,'2516','382',199410.10,201843.44,0.00,0.00,2433.34,811152.96,0.00,0.00,0.00),('1','143','866','200937',3911681,'2517','382',183841.99,183841.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','201125',3914708,'2516','382',201843.44,203928.67,0.00,0.00,2085.23,699389.12,0.00,0.00,0.00),('1','143','866','201125',3914709,'2517','382',183841.99,183841.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','201322',3918151,'2516','382',203928.67,206482.00,0.00,0.00,2553.33,847677.52,0.00,0.00,0.00),('1','143','866','201322',3918152,'2517','382',183841.99,183841.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','201504',3921549,'2516','382',206482.00,209060.03,0.00,0.00,2578.03,856988.32,0.00,0.00,0.00),('1','143','866','201504',3921550,'2517','382',183841.99,183841.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','201769',3926682,'2516','382',209060.03,210541.15,0.00,0.00,1481.12,504929.28,0.00,0.00,0.00),('1','143','866','201769',3926683,'2517','382',183841.99,183844.99,0.00,0.00,3.00,1032.00,0.00,0.00,0.00),('1','143','865','202040',3931727,'2516','382',210541.15,211900.00,0.00,0.00,1358.85,467444.40,0.00,0.00,0.00),('1','143','866','202040',3931728,'2517','382',183844.99,183844.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','202225',3934853,'2516','382',211900.00,212591.87,0.00,0.00,691.87,235803.28,0.00,0.00,0.00),('1','143','866','202225',3934854,'2517','382',183844.99,183844.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','202327',3936578,'2516','382',212591.87,212808.37,0.00,0.00,216.50,73266.00,0.00,0.00,0.00),('1','143','866','202327',3936579,'2517','382',183844.99,185142.31,0.00,0.00,1297.32,432902.08,0.00,0.00,0.00),('1','143','865','202457',3938775,'2516','382',212808.37,213138.77,0.00,0.00,330.40,108157.60,0.00,0.00,0.00),('1','143','866','202457',3938776,'2517','382',185142.31,185142.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','202473',3939093,'2516','382',213138.77,213153.77,0.00,0.00,15.00,5160.00,0.00,0.00,0.00),('1','143','866','202473',3939094,'2517','382',185142.31,187780.15,0.00,0.00,2637.84,868003.96,0.00,0.00,0.00),('1','143','865','202658',3942327,'2516','382',213153.77,213153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','202658',3942328,'2517','382',187780.15,190838.96,0.00,0.00,3058.81,1004325.64,0.00,0.00,0.00),('1','143','865','202865',3946059,'2516','382',213153.77,213153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','202865',3946060,'2517','382',190838.96,192393.80,0.00,0.00,1554.84,526922.96,0.00,0.00,0.00),('1','143','865','203122',3950944,'2516','382',213153.77,213153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','203122',3950945,'2517','382',192393.80,194660.23,0.00,0.00,2266.43,757497.92,0.00,0.00,0.00),('1','143','865','203314',3954566,'2516','382',213153.77,213153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','203314',3954567,'2517','382',194660.23,195894.46,0.00,0.00,1234.23,420769.12,0.00,0.00,0.00),('1','143','865','203530',3958379,'2516','382',213153.77,213153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','203530',3958380,'2517','382',195894.46,198468.10,0.00,0.00,2573.64,860824.16,0.00,0.00,0.00),('1','143','865','203744',3962180,'2516','382',213153.77,213153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','203744',3962181,'2517','382',198468.10,200870.00,0.00,0.00,2401.90,817070.00,0.00,0.00,0.00),('1','143','865','203972',3966207,'2516','382',213153.77,213153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','203972',3966208,'2517','382',200870.00,203586.24,0.00,0.00,2716.24,906216.40,0.00,0.00,0.00),('1','143','865','204202',3970447,'2516','382',213153.77,213153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','204202',3970448,'2517','382',203586.24,205065.57,0.00,0.00,1479.33,525718.80,0.00,0.00,0.00),('1','143','865','204413',3974177,'2516','382',213153.77,213153.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','204413',3974178,'2517','382',205065.57,208167.09,0.00,0.00,3101.52,1024169.20,0.00,0.00,0.00),('1','143','865','204576',3977472,'2516','382',213153.77,213512.80,0.00,0.00,359.03,127958.80,0.00,0.00,0.00),('1','143','866','204576',3977473,'2517','382',208167.09,208167.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','204634',3978214,'2516','382',213512.80,213512.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','204634',3978215,'2517','382',208167.09,208340.09,0.00,0.00,173.00,60380.00,0.00,0.00,0.00),('1','143','865','204635',3978216,'2516','382',213512.80,214298.86,0.00,0.00,786.06,278725.60,0.00,0.00,0.00),('1','143','866','204635',3978217,'2517','382',208340.09,208361.09,0.00,0.00,21.00,7560.00,0.00,0.00,0.00),('1','143','865','204861',3981890,'2516','382',214298.86,216552.18,0.00,0.00,2253.32,777875.20,0.00,0.00,0.00),('1','143','866','204861',3981891,'2517','382',208361.09,208361.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','205045',3985241,'2516','382',216552.18,218330.79,0.00,0.00,1778.61,619026.60,0.00,0.00,0.00),('1','143','866','205045',3985242,'2517','382',208361.09,208361.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','205250',3988913,'2516','382',218330.79,220150.01,0.00,0.00,1819.22,632729.20,0.00,0.00,0.00),('1','143','866','205250',3988914,'2517','382',208361.09,208373.59,0.00,0.00,12.50,4500.00,0.00,0.00,0.00),('1','143','865','205487',3993218,'2516','382',220150.01,222135.79,0.00,0.00,1985.78,686236.80,0.00,0.00,0.00),('1','143','866','205487',3993219,'2517','382',208373.59,208373.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','205737',3997802,'2516','382',222135.79,224306.17,0.00,0.00,2170.38,745196.80,0.00,0.00,0.00),('1','143','866','205737',3997803,'2517','382',208373.59,208373.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','205952',4001666,'2516','382',224306.17,226234.86,0.00,0.00,1928.69,658556.40,0.00,0.00,0.00),('1','143','866','205952',4001667,'2517','382',208373.59,208373.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','206164',4005432,'2516','382',226234.86,228633.70,0.00,0.00,2398.84,827042.40,0.00,0.00,0.00),('1','143','866','206164',4005433,'2517','382',208373.59,208379.92,0.00,0.00,6.33,2278.80,0.00,0.00,0.00),('1','143','865','206368',4008970,'2516','382',228633.70,230534.53,0.00,0.00,1900.83,666098.80,0.00,0.00,0.00),('1','143','866','206368',4008971,'2517','382',208379.92,208379.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','206578',4012591,'2516','382',230534.53,232238.68,0.00,0.00,1704.15,579997.00,0.00,0.00,0.00),('1','143','866','206578',4012592,'2517','382',208379.92,208379.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','206709',4014996,'2516','382',232238.68,232361.40,0.00,0.00,122.72,44179.20,0.00,0.00,0.00),('1','143','866','206709',4014997,'2517','382',208379.92,209102.61,0.00,0.00,722.69,249468.40,0.00,0.00,0.00),('1','143','865','206910',4018468,'2516','382',232361.40,232361.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','206910',4018469,'2517','382',209102.61,211318.06,0.00,0.00,2215.45,755186.00,0.00,0.00,0.00),('1','143','865','207035',4020769,'2516','382',232361.40,232361.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','207035',4020770,'2517','382',211318.06,212625.70,0.00,0.00,1307.64,462686.40,0.00,0.00,0.00),('1','143','865','207261',4024816,'2516','382',232361.40,232385.40,0.00,0.00,24.00,8640.00,0.00,0.00,0.00),('1','143','866','207261',4024817,'2517','382',212625.70,214851.65,0.00,0.00,2225.95,772642.00,0.00,0.00,0.00),('1','143','865','207508',4029313,'2516','382',232385.40,232385.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','207508',4029314,'2517','382',214851.65,217495.88,0.00,0.00,2644.23,920308.80,0.00,0.00,0.00),('1','143','865','207665',4031994,'2516','382',232385.40,232936.81,0.00,0.00,551.41,182907.60,0.00,0.00,0.00),('1','143','866','207665',4031995,'2517','382',217495.88,217495.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','207776',4033706,'2516','382',232936.81,232936.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','207776',4033707,'2517','382',217495.88,219508.29,0.00,0.00,2012.41,755965.80,0.00,0.00,0.00),('1','143','865','207913',4036107,'2516','382',232936.81,232936.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','207913',4036108,'2517','382',219508.29,222410.52,0.00,0.00,2902.23,1071372.40,0.00,0.00,0.00),('1','143','865','208132',4039942,'2516','382',232936.81,232959.21,0.00,0.00,22.40,8512.00,0.00,0.00,0.00),('1','143','866','208132',4039943,'2517','382',222410.52,226809.35,0.00,0.00,4398.83,1602198.40,0.00,0.00,0.00),('1','143','865','208341',4043733,'2516','382',232959.21,235381.95,0.00,0.00,2422.74,893291.20,0.00,0.00,0.00),('1','143','866','208341',4043734,'2517','382',226809.35,226866.24,0.00,0.00,56.89,21618.20,0.00,0.00,0.00),('1','143','865','208544',4047408,'2516','382',235381.95,237073.38,0.00,0.00,1691.43,630105.90,0.00,0.00,0.00),('1','143','866','208544',4047409,'2517','382',226866.24,226875.24,0.00,0.00,9.00,3420.00,0.00,0.00,0.00),('1','143','865','208765',4051133,'2516','382',237073.38,239796.73,0.00,0.00,2723.35,1006298.00,0.00,0.00,0.00),('1','143','866','208765',4051134,'2517','382',226875.24,226875.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','209004',4055209,'2516','382',239796.73,243151.68,0.00,0.00,3354.95,1317284.00,0.00,0.00,0.00),('1','143','866','209004',4055210,'2517','382',226875.24,226875.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','209219',4059032,'2516','382',243151.68,245415.28,0.00,0.00,2263.60,882808.00,0.00,0.00,0.00),('1','143','866','209219',4059033,'2517','382',226875.24,226875.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','209428',4062807,'2516','382',245415.28,248318.03,0.00,0.00,2902.75,1126040.80,0.00,0.00,0.00),('1','143','866','209428',4062808,'2517','382',226875.24,226875.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','209639',4066550,'2516','382',248318.03,250308.83,0.00,0.00,1990.80,788304.00,0.00,0.00,0.00),('1','143','866','209639',4066551,'2517','382',226875.24,226875.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','209848',4070318,'2516','382',250308.83,252204.17,0.00,0.00,1895.34,759634.80,0.00,0.00,0.00),('1','143','866','209848',4070319,'2517','382',226875.24,226875.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','210072',4074279,'2516','382',252204.17,252204.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','210072',4074280,'2517','382',226875.24,227856.34,0.00,0.00,981.10,398562.00,0.00,0.00,0.00),('1','143','865','210177',4075925,'2516','382',252204.17,252327.17,0.00,0.00,123.00,51660.00,0.00,0.00,0.00),('1','143','866','210177',4075926,'2517','382',227856.34,230544.08,0.00,0.00,2687.74,1067146.80,0.00,0.00,0.00),('1','143','865','210301',4078272,'2516','382',252327.17,252386.17,0.00,0.00,59.00,24780.00,0.00,0.00,0.00),('1','143','866','210301',4078273,'2517','382',230544.08,233270.30,0.00,0.00,2726.22,1091254.40,0.00,0.00,0.00),('1','143','865','210500',4082056,'2516','382',252386.17,252395.17,0.00,0.00,9.00,3780.00,0.00,0.00,0.00),('1','143','866','210500',4082057,'2517','382',233270.30,235854.78,0.00,0.00,2584.48,1030727.60,0.00,0.00,0.00),('1','143','865','210817',4087421,'2516','382',252395.17,252395.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','210817',4087422,'2517','382',235854.78,239531.03,0.00,0.00,3676.25,1448713.00,0.00,0.00,0.00),('1','143','865','210979',4089985,'2516','382',252395.17,252405.17,0.00,0.00,10.00,4200.00,0.00,0.00,0.00),('1','143','866','210979',4089986,'2517','382',239531.03,241900.01,0.00,0.00,2368.98,965863.60,0.00,0.00,0.00),('1','143','865','211190',4093811,'2516','382',252405.17,252405.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','211190',4093812,'2517','382',241900.01,244057.95,0.00,0.00,2157.94,902476.56,0.00,0.00,0.00),('1','143','865','211509',4099496,'2516','382',252405.17,252405.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','211509',4099497,'2517','382',244057.95,247754.78,0.00,0.00,3696.83,1513539.92,0.00,0.00,0.00),('1','143','865','211575',4100870,'2516','382',252405.17,252617.47,0.00,0.00,212.30,86810.00,0.00,0.00,0.00),('1','143','866','211575',4100871,'2517','382',247754.78,247754.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','211610',4101371,'2516','382',252617.47,252617.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','211610',4101372,'2517','382',247754.78,248718.02,0.00,0.00,963.24,397886.76,0.00,0.00,0.00),('1','143','865','211799',4104349,'2516','382',252617.47,252617.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','211799',4104350,'2517','382',248718.02,250005.80,0.00,0.00,1287.78,533074.72,0.00,0.00,0.00),('1','143','865','212030',4108514,'2516','382',252617.47,252617.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','212030',4108515,'2517','382',250005.80,251077.15,0.00,0.00,1071.35,434068.40,0.00,0.00,0.00),('1','143','865','212195',4111594,'2516','382',252617.47,252906.38,0.00,0.00,288.91,121192.84,0.00,0.00,0.00),('1','143','866','212195',4111595,'2517','382',251077.15,251077.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','212247',4112320,'2516','382',252906.38,256100.13,0.00,0.00,3193.75,1287674.50,0.00,0.00,0.00),('1','143','866','212247',4112321,'2517','382',251077.15,251081.87,0.00,0.00,4.72,2001.28,0.00,0.00,0.00),('1','143','865','212473',4116510,'2516','382',256100.13,257602.18,0.00,0.00,1502.05,618083.20,0.00,0.00,0.00),('1','143','866','212473',4116511,'2517','382',251081.87,251088.87,0.00,0.00,7.00,2968.00,0.00,0.00,0.00),('1','143','865','212734',4121125,'2516','382',257602.18,258849.70,0.00,0.00,1247.52,521698.48,0.00,0.00,0.00),('1','143','866','212734',4121126,'2517','382',251088.87,251107.87,0.00,0.00,19.00,8056.00,0.00,0.00,0.00),('1','143','865','212883',4123789,'2516','382',258849.70,260050.21,0.00,0.00,1200.51,503303.24,0.00,0.00,0.00),('1','143','866','212883',4123790,'2517','382',251107.87,251113.87,0.00,0.00,6.00,2544.00,0.00,0.00,0.00),('1','143','865','213146',4128322,'2516','382',260050.21,262514.18,0.00,0.00,2463.97,1013274.28,0.00,0.00,0.00),('1','143','866','213146',4128323,'2517','382',251113.87,251129.37,0.00,0.00,15.50,6572.00,0.00,0.00,0.00),('1','143','865','213406',4132544,'2516','382',262514.18,265132.66,0.00,0.00,2618.48,1062270.52,0.00,0.00,0.00),('1','143','866','213406',4132545,'2517','382',251129.37,251129.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','213646',4136606,'2516','382',265132.66,267164.10,0.00,0.00,2031.44,818325.56,0.00,0.00,0.00),('1','143','866','213646',4136607,'2517','382',251129.37,251129.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','213821',4139627,'2516','382',267164.10,267164.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','213821',4139628,'2517','382',251129.37,251129.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','213826',4139704,'2516','382',267164.10,267164.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','213826',4139705,'2517','382',251129.37,251129.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','213829',4139735,'2516','382',267164.10,267164.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','213829',4139736,'2517','382',251129.37,251129.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','213831',4139791,'2516','382',267164.10,267164.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','213831',4139792,'2517','382',251129.37,251129.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','213832',4139793,'2516','382',267164.10,267173.10,0.00,0.00,9.00,3816.00,0.00,0.00,0.00),('1','143','866','213832',4139794,'2517','382',251129.37,252261.87,0.00,0.00,1132.50,466430.00,0.00,0.00,0.00),('1','143','865','213947',4141483,'2516','382',267173.10,267195.46,0.00,0.00,22.36,9480.64,0.00,0.00,0.00),('1','143','866','213947',4141484,'2517','382',252261.87,255128.67,0.00,0.00,2866.80,1168713.20,0.00,0.00,0.00),('1','143','865','214163',4145169,'2516','382',267195.46,267201.46,0.00,0.00,6.00,2544.00,0.00,0.00,0.00),('1','143','866','214163',4145170,'2517','382',255128.67,256844.11,0.00,0.00,1715.44,717866.56,0.00,0.00,0.00),('1','143','865','214344',4148422,'2516','382',267201.46,267219.96,0.00,0.00,18.50,7844.00,0.00,0.00,0.00),('1','143','866','214344',4148423,'2517','382',256844.11,260034.87,0.00,0.00,3190.76,1311528.24,0.00,0.00,0.00),('1','143','865','214552',4151784,'2516','382',267219.96,267225.96,0.00,0.00,6.00,2544.00,0.00,0.00,0.00),('1','143','866','214552',4151785,'2517','382',260034.87,261500.23,0.00,0.00,1465.36,616272.64,0.00,0.00,0.00),('1','143','865','214795',4156064,'2516','382',267225.96,267225.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','214795',4156065,'2517','382',261500.23,264477.33,0.00,0.00,2977.10,1227742.40,0.00,0.00,0.00),('1','143','865','215013',4159761,'2516','382',267225.96,267225.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','215013',4159762,'2517','382',264477.33,268082.14,0.00,0.00,3604.81,1464191.44,0.00,0.00,0.00),('1','143','865','215232',4163566,'2516','382',267225.96,267225.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','215232',4163567,'2517','382',268082.14,269668.52,0.00,0.00,1586.38,669361.12,0.00,0.00,0.00),('1','143','865','215407',4166570,'2516','382',267225.96,267797.76,0.00,0.00,571.80,228427.50,0.00,0.00,0.00),('1','143','866','215407',4166571,'2517','382',269668.52,269668.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','215452',4167136,'2516','382',267797.76,267797.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','215452',4167137,'2517','382',269668.52,272054.77,0.00,0.00,2386.25,996086.00,0.00,0.00,0.00),('1','143','865','215689',4171231,'2516','382',267797.76,267797.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','215689',4171232,'2517','382',272054.77,274459.46,0.00,0.00,2404.69,992256.56,0.00,0.00,0.00),('1','143','865','215971',4176083,'2516','382',267797.76,267797.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','215971',4176084,'2517','382',274459.46,275084.29,0.00,0.00,624.83,252447.92,0.00,0.00,0.00),('1','143','865','216026',4177089,'2516','382',267797.76,268147.28,0.00,0.00,349.52,147596.48,0.00,0.00,0.00),('1','143','866','216026',4177090,'2517','382',275084.29,275169.29,0.00,0.00,85.00,36040.00,0.00,0.00,0.00),('1','143','865','216112',4178604,'2516','382',268147.28,270491.91,0.00,0.00,2344.63,966979.12,0.00,0.00,0.00),('1','143','866','216112',4178605,'2517','382',275169.29,275228.55,0.00,0.00,59.26,25126.24,0.00,0.00,0.00),('1','143','865','216335',4182413,'2516','382',270491.91,271873.66,0.00,0.00,1381.75,583462.00,0.00,0.00,0.00),('1','143','866','216335',4182414,'2517','382',275228.55,275241.05,0.00,0.00,12.50,5300.00,0.00,0.00,0.00),('1','143','865','216576',4186485,'2516','382',271873.66,274424.05,0.00,0.00,2550.39,1049389.36,0.00,0.00,0.00),('1','143','866','216576',4186486,'2517','382',275241.05,275241.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','216795',4190555,'2516','382',274424.05,276709.84,0.00,0.00,2285.79,943042.96,0.00,0.00,0.00),('1','143','866','216795',4190556,'2517','382',275241.05,275243.05,0.00,0.00,2.00,848.00,0.00,0.00,0.00),('1','143','865','217203',4197996,'2516','382',276709.84,277081.74,0.00,0.00,371.90,178512.00,0.00,0.00,0.00),('1','143','866','217203',4197997,'2517','382',275243.05,275243.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','217204',4197998,'2516','382',277081.74,277153.43,0.00,0.00,71.69,34411.20,0.00,0.00,0.00),('1','143','866','217204',4197999,'2517','382',275243.05,277355.40,0.00,0.00,2112.35,951113.00,0.00,0.00,0.00),('1','143','865','217361',4200656,'2516','382',277153.43,277165.93,0.00,0.00,12.50,6000.00,0.00,0.00,0.00),('1','143','866','217361',4200657,'2517','382',277355.40,279404.84,0.00,0.00,2049.44,957551.20,0.00,0.00,0.00),('1','143','865','217509',4203290,'2516','382',277165.93,277165.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','217509',4203291,'2517','382',279404.84,281161.09,0.00,0.00,1756.25,820100.00,0.00,0.00,0.00),('1','143','865','217714',4206712,'2516','382',277165.93,277165.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','217714',4206713,'2517','382',281161.09,283113.82,0.00,0.00,1952.73,897950.40,0.00,0.00,0.00),('1','143','865','218079',4213232,'2516','382',277165.93,277165.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','218079',4213233,'2517','382',283113.82,284717.19,0.00,0.00,1603.37,764217.60,0.00,0.00,0.00),('1','143','865','218234',4215974,'2516','382',277165.93,277165.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','218234',4215975,'2517','382',284717.19,286244.73,0.00,0.00,1527.54,722819.20,0.00,0.00,0.00),('1','143','865','218461',4219922,'2516','382',277165.93,277165.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','218461',4219923,'2517','382',286244.73,287610.57,0.00,0.00,1365.84,649603.20,0.00,0.00,0.00),('1','143','865','218700',4224219,'2516','382',277165.93,277165.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','218700',4224220,'2517','382',287610.57,289729.21,0.00,0.00,2118.64,977497.20,0.00,0.00,0.00),('1','143','865','218913',4228020,'2516','382',277165.93,277165.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','218913',4228021,'2517','382',289729.21,291038.99,0.00,0.00,1309.78,615734.40,0.00,0.00,0.00),('1','143','865','219077',4230918,'2516','382',277165.93,277542.93,0.00,0.00,377.00,180960.00,0.00,0.00,0.00),('1','143','866','219077',4230919,'2517','382',291038.99,291038.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','219118',4231566,'2516','382',277542.93,277542.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','219118',4231567,'2517','382',291038.99,291038.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','219135',4231756,'2516','382',277542.93,277542.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','219135',4231757,'2517','382',291038.99,294157.20,0.00,0.00,3118.21,1423258.30,0.00,0.00,0.00),('1','143','865','219402',4236344,'2516','382',277542.93,277542.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','219402',4236345,'2517','382',294157.20,294790.20,0.00,0.00,633.00,296400.00,0.00,0.00,0.00),('1','143','865','219517',4238560,'2516','382',277542.93,278305.49,0.00,0.00,762.56,355428.80,0.00,0.00,0.00),('1','143','866','219517',4238561,'2517','382',294790.20,294790.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','219611',4239910,'2516','382',278305.49,279943.19,0.00,0.00,1637.70,767296.00,0.00,0.00,0.00),('1','143','866','219611',4239911,'2517','382',294790.20,294790.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','220134',4249466,'2516','382',279943.19,281482.19,0.00,0.00,1539.00,725640.00,0.00,0.00,0.00),('1','143','866','220134',4249467,'2517','382',294790.20,294790.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','220138',4249547,'2516','382',281482.19,282670.74,0.00,0.00,1188.55,568104.00,0.00,0.00,0.00),('1','143','866','220138',4249548,'2517','382',294790.20,294790.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','220267',4251679,'2516','382',282670.74,284415.11,0.00,0.00,1744.37,835497.60,0.00,0.00,0.00),('1','143','866','220267',4251680,'2517','382',294790.20,294790.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','220519',4256237,'2516','382',284415.11,286839.20,0.00,0.00,2424.09,1111403.20,0.00,0.00,0.00),('1','143','866','220519',4256238,'2517','382',294790.20,294790.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','220793',4260948,'2516','382',286839.20,288375.55,0.00,0.00,1536.35,721048.00,0.00,0.00,0.00),('1','143','866','220793',4260949,'2517','382',294790.20,294790.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','220999',4264759,'2516','382',288375.55,290218.84,0.00,0.00,1843.29,858819.20,0.00,0.00,0.00),('1','143','866','220999',4264760,'2517','382',294790.20,294790.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','221215',4268478,'2516','382',290218.84,293061.38,0.00,0.00,2842.54,1306869.20,0.00,0.00,0.00),('1','143','866','221215',4268479,'2517','382',294790.20,294790.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','221453',4272769,'2516','382',293061.38,295256.22,0.00,0.00,2194.84,1006658.20,0.00,0.00,0.00),('1','143','866','221453',4272770,'2517','382',294790.20,294790.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','221739',4278186,'2516','382',295256.22,297698.60,0.00,0.00,2442.38,1129102.40,0.00,0.00,0.00),('1','143','866','221739',4278187,'2517','382',294790.20,294795.20,0.00,0.00,5.00,2400.00,0.00,0.00,0.00),('1','143','865','221870',4280322,'2516','382',297698.60,299309.43,0.00,0.00,1610.83,764678.40,0.00,0.00,0.00),('1','143','866','221870',4280323,'2517','382',294795.20,294795.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','222087',4284316,'2516','382',299309.43,301841.92,0.00,0.00,2532.49,1153555.20,0.00,0.00,0.00),('1','143','866','222087',4284317,'2517','382',294795.20,294801.20,0.00,0.00,6.00,2880.00,0.00,0.00,0.00),('1','143','865','222281',4287610,'2516','382',301841.92,302178.46,0.00,0.00,336.54,159139.20,0.00,0.00,0.00),('1','143','866','222281',4287611,'2517','382',294801.20,294801.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','222353',4288780,'2516','382',302178.46,302233.96,0.00,0.00,55.50,26640.00,0.00,0.00,0.00),('1','143','866','222353',4288781,'2517','382',294801.20,297472.35,0.00,0.00,2671.15,1224152.00,0.00,0.00,0.00),('1','143','865','222535',4291900,'2516','382',302233.96,303416.58,0.00,0.00,1182.62,567657.60,0.00,0.00,0.00),('1','143','866','222535',4291901,'2517','382',297472.35,297970.73,0.00,0.00,498.38,222022.40,0.00,0.00,0.00),('1','143','865','222775',4296367,'2516','382',303416.58,303416.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','222775',4296368,'2517','382',297970.73,300708.70,0.00,0.00,2737.97,1254993.60,0.00,0.00,0.00),('1','143','865','222948',4299810,'2516','382',303416.58,303449.58,0.00,0.00,33.00,15840.00,0.00,0.00,0.00),('1','143','866','222948',4299811,'2517','382',300708.70,302578.36,0.00,0.00,1869.66,873916.80,0.00,0.00,0.00),('1','143','865','223208',4304045,'2516','382',303449.58,303449.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','223208',4304046,'2517','382',302578.36,306221.04,0.00,0.00,3642.68,1643147.40,0.00,0.00,0.00),('1','143','865','223433',4308069,'2516','382',303449.58,303449.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','223433',4308070,'2517','382',306221.04,307638.84,0.00,0.00,1417.80,676544.00,0.00,0.00,0.00),('1','143','865','223661',4312321,'2516','382',303449.58,303449.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','223661',4312322,'2517','382',307638.84,310448.41,0.00,0.00,2809.57,1323851.60,0.00,0.00,0.00),('1','143','865','223894',4316632,'2516','382',303449.58,303449.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','223894',4316633,'2517','382',310448.41,312193.25,0.00,0.00,1744.84,835723.20,0.00,0.00,0.00),('1','143','865','224134',4320709,'2516','382',303449.58,303449.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','224134',4320710,'2517','382',312193.25,313190.09,0.00,0.00,996.84,469951.20,0.00,0.00,0.00),('1','143','865','224275',4323631,'2516','382',303449.58,303449.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','224275',4323632,'2517','382',313190.09,314237.68,0.00,0.00,1047.59,495967.20,0.00,0.00,0.00),('1','143','865','224323',4324232,'2516','382',303449.58,303457.58,0.00,0.00,8.00,4320.00,0.00,0.00,0.00),('1','143','866','224323',4324233,'2517','382',314237.68,317012.07,0.00,0.00,2774.39,1423834.60,0.00,0.00,0.00),('1','143','865','224618',4329367,'2516','382',303457.58,303457.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','224618',4329368,'2517','382',317012.07,318685.92,0.00,0.00,1673.85,882079.00,0.00,0.00,0.00),('1','143','865','224798',4332383,'2516','382',303457.58,303457.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','224798',4332384,'2517','382',318685.92,320619.06,0.00,0.00,1933.14,1010175.60,0.00,0.00,0.00),('1','143','865','225037',4336726,'2516','382',303457.58,303457.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','225037',4336727,'2517','382',320619.06,321933.28,0.00,0.00,1314.22,701358.80,0.00,0.00,0.00),('1','143','865','225283',4341237,'2516','382',303457.58,303457.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','225283',4341238,'2517','382',321933.28,324664.54,0.00,0.00,2731.26,1410640.40,0.00,0.00,0.00),('1','143','865','225489',4345139,'2516','382',303457.58,303457.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','225489',4345140,'2517','382',324664.54,326939.16,0.00,0.00,2274.62,1208014.80,0.00,0.00,0.00),('1','143','865','225792',4350250,'2516','382',303457.58,303457.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','225792',4350251,'2517','382',326939.16,329001.22,0.00,0.00,2062.06,1074852.40,0.00,0.00,0.00),('1','143','865','225997',4353727,'2516','382',303457.58,303457.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','225997',4353728,'2517','382',329001.22,330691.68,0.00,0.00,1690.46,886348.40,0.00,0.00,0.00),('1','143','865','226216',4358167,'2516','382',303457.58,303457.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','226216',4358168,'2517','382',330691.68,330691.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','226218',4358201,'2516','382',303457.58,303457.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','226218',4358202,'2517','382',330691.68,330691.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','226264',4358770,'2516','382',303457.58,303457.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','226264',4358771,'2517','382',330691.68,331846.17,0.00,0.00,1154.49,609384.60,0.00,0.00,0.00),('1','143','865','226410',4361492,'2516','382',303457.58,303713.53,0.00,0.00,255.95,138213.00,0.00,0.00,0.00),('1','143','866','226410',4361493,'2517','382',331846.17,331867.67,0.00,0.00,21.50,11610.00,0.00,0.00,0.00),('1','143','865','226447',4362225,'2516','382',303713.53,303713.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','226447',4362226,'2517','382',331867.67,331867.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','226451',4362277,'2516','382',303713.53,303713.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','226451',4362278,'2517','382',331867.67,331867.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','226452',4362279,'2516','382',303713.53,303713.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','226452',4362280,'2517','382',331867.67,331867.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','226454',4362315,'2516','382',303713.53,303713.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','226454',4362316,'2517','382',331867.67,331867.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','226480',4362578,'2516','382',303713.53,303713.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','226480',4362579,'2517','382',331867.67,331867.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','226483',4362631,'2516','382',303713.53,303713.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','226483',4362632,'2517','382',331867.67,331867.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','226485',4362634,'2516','382',303713.53,303713.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','226485',4362635,'2517','382',331867.67,331867.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','226520',4363205,'2516','382',303713.53,305262.15,0.00,0.00,1548.62,814854.80,0.00,0.00,0.00),('1','143','866','226520',4363206,'2517','382',331867.67,331915.04,0.00,0.00,47.37,25579.80,0.00,0.00,0.00),('1','143','865','226685',4366486,'2516','382',305262.15,305262.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','226685',4366487,'2517','382',331915.04,331974.64,0.00,0.00,59.60,32184.00,0.00,0.00,0.00),('1','143','865','226693',4366639,'2516','382',305262.15,305262.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','226693',4366640,'2517','382',331974.64,331974.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','226694',4366641,'2516','382',305262.15,305262.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','226694',4366642,'2517','382',331974.64,331974.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','226695',4366643,'2516','382',305262.15,305262.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','226695',4366644,'2517','382',331974.64,331974.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','226696',4366645,'2516','382',305262.15,305262.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','226696',4366646,'2517','382',331974.64,331974.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','226794',4368165,'2516','382',305262.15,307303.92,0.00,0.00,2041.77,1058155.80,0.00,0.00,0.00),('1','143','866','226794',4368166,'2517','382',331974.64,331978.64,0.00,0.00,4.00,2160.00,0.00,0.00,0.00),('1','143','865','227001',4371864,'2516','382',307303.92,309323.38,0.00,0.00,2019.46,1055908.40,0.00,0.00,0.00),('1','143','866','227001',4371865,'2517','382',331978.64,331978.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','227208',4375495,'2516','382',309323.38,311162.77,0.00,0.00,1839.39,979830.60,0.00,0.00,0.00),('1','143','866','227208',4375496,'2517','382',331978.64,331987.90,0.00,0.00,9.26,5000.40,0.00,0.00,0.00),('1','143','865','227405',4378963,'2516','382',311162.77,312320.44,0.00,0.00,1157.67,587221.80,0.00,0.00,0.00),('1','143','866','227405',4378964,'2517','382',331987.90,333060.40,0.00,0.00,1072.50,577150.00,0.00,0.00,0.00),('1','143','865','227622',4382725,'2516','382',312320.44,314320.92,0.00,0.00,2000.48,1048259.20,0.00,0.00,0.00),('1','143','866','227622',4382726,'2517','382',333060.40,333060.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','227867',4387148,'2516','382',314320.92,315600.44,0.00,0.00,1279.52,655500.80,0.00,0.00,0.00),('1','143','866','227867',4387149,'2517','382',333060.40,333073.10,0.00,0.00,12.70,6858.00,0.00,0.00,0.00),('1','143','865','228068',4391228,'2516','382',315600.44,315600.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','228068',4391229,'2517','382',333073.10,334322.60,0.00,0.00,1249.50,655322.00,0.00,0.00,0.00),('1','143','865','228137',4392259,'2516','382',315600.44,315659.44,0.00,0.00,59.00,29860.00,0.00,0.00,0.00),('1','143','866','228137',4392260,'2517','382',334322.60,336796.71,0.00,0.00,2474.11,1293519.40,0.00,0.00,0.00),('1','143','865','228373',4396860,'2516','382',315659.44,315927.94,0.00,0.00,268.50,139860.00,0.00,0.00,0.00),('1','143','866','228373',4396861,'2517','382',336796.71,339594.37,0.00,0.00,2797.66,1508794.40,0.00,0.00,0.00),('1','143','865','228537',4399891,'2516','382',315927.94,315927.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','228537',4399892,'2517','382',339594.37,342913.04,0.00,0.00,3318.67,1771977.20,0.00,0.00,0.00),('1','143','865','228786',4404484,'2516','382',315927.94,315927.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','228786',4404485,'2517','382',342913.04,345347.89,0.00,0.00,2434.85,1322734.00,0.00,0.00,0.00),('1','143','865','228970',4407820,'2516','382',315927.94,315987.94,0.00,0.00,60.00,31080.00,0.00,0.00,0.00),('1','143','866','228970',4407821,'2517','382',345347.89,347074.23,0.00,0.00,1726.34,942474.40,0.00,0.00,0.00),('1','143','865','229178',4412058,'2516','382',315987.94,315987.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','229178',4412059,'2517','382',347074.23,349646.20,0.00,0.00,2571.97,1405401.20,0.00,0.00,0.00),('1','143','865','229374',4415729,'2516','382',315987.94,316189.44,0.00,0.00,201.50,100750.00,0.00,0.00,0.00),('1','143','866','229374',4415730,'2517','382',349646.20,349646.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','229431',4416492,'2516','382',316189.44,316199.44,0.00,0.00,10.00,5840.00,0.00,0.00,0.00),('1','143','866','229431',4416493,'2517','382',349646.20,350781.82,0.00,0.00,1135.62,639224.08,0.00,0.00,0.00),('1','143','865','229583',4419655,'2516','382',316199.44,317411.50,0.00,0.00,1212.06,697268.04,0.00,0.00,0.00),('1','143','866','229583',4419656,'2517','382',350781.82,350823.32,0.00,0.00,41.50,24236.00,0.00,0.00,0.00),('1','143','865','229693',4421603,'2516','382',317411.50,317411.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','229693',4421604,'2517','382',350823.32,352076.91,0.00,0.00,1253.59,667739.82,0.00,0.00,0.00),('1','143','865','229697',4421685,'2516','382',317411.50,319192.81,0.00,0.00,1781.31,985898.78,0.00,0.00,0.00),('1','143','866','229697',4421686,'2517','382',352076.91,353076.26,0.00,0.00,999.35,559368.40,0.00,0.00,0.00),('1','143','865','229891',4425691,'2516','382',319192.81,320996.12,0.00,0.00,1803.31,1027283.04,0.00,0.00,0.00),('1','143','866','229891',4425692,'2517','382',353076.26,353138.39,0.00,0.00,62.13,36283.92,0.00,0.00,0.00),('1','143','865','230092',4429364,'2516','382',320996.12,323445.42,0.00,0.00,2449.30,1372067.96,0.00,0.00,0.00),('1','143','866','230092',4429365,'2517','382',353138.39,353172.89,0.00,0.00,34.50,20148.00,0.00,0.00,0.00),('1','143','865','230303',4433302,'2516','382',323445.42,324950.73,0.00,0.00,1505.31,874666.59,0.00,0.00,0.00),('1','143','866','230303',4433303,'2517','382',353172.89,353186.31,0.00,0.00,13.42,7837.28,0.00,0.00,0.00),('1','143','865','230533',4437641,'2516','382',324950.73,328541.65,0.00,0.00,3590.92,1992119.28,0.00,0.00,0.00),('1','143','866','230533',4437642,'2517','382',353186.31,353196.58,0.00,0.00,10.27,5997.68,0.00,0.00,0.00),('1','143','865','230795',4442203,'2516','382',328541.65,329776.75,0.00,0.00,1235.10,707292.40,0.00,0.00,0.00),('1','143','866','230795',4442204,'2517','382',353196.58,353202.58,0.00,0.00,6.00,3504.00,0.00,0.00,0.00),('1','143','865','231337',4451408,'2516','382',329776.75,329776.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','231337',4451409,'2517','382',353202.58,354775.68,0.00,0.00,1573.10,904684.40,0.00,0.00,0.00),('1','143','865','231384',4451922,'2516','382',329776.75,329878.75,0.00,0.00,102.00,59568.00,0.00,0.00,0.00),('1','143','866','231384',4451923,'2517','382',354775.68,357280.36,0.00,0.00,2504.68,1405440.12,0.00,0.00,0.00),('1','143','865','231647',4456495,'2516','382',329878.75,329949.38,0.00,0.00,70.63,41247.92,0.00,0.00,0.00),('1','143','866','231647',4456496,'2517','382',357280.36,359083.69,0.00,0.00,1803.33,1025414.72,0.00,0.00,0.00),('1','143','865','231909',4461236,'2516','382',329949.38,329957.88,0.00,0.00,8.50,4964.00,0.00,0.00,0.00),('1','143','866','231909',4461237,'2517','382',359083.69,360722.48,0.00,0.00,1638.79,944551.36,0.00,0.00,0.00),('1','143','865','232107',4464966,'2516','382',329957.88,329959.88,0.00,0.00,2.00,1168.00,0.00,0.00,0.00),('1','143','866','232107',4464967,'2517','382',360722.48,362603.81,0.00,0.00,1881.33,1084596.72,0.00,0.00,0.00),('1','143','865','232348',4469114,'2516','382',329959.88,329972.38,0.00,0.00,12.50,7300.00,0.00,0.00,0.00),('1','143','866','232348',4469115,'2517','382',362603.81,365547.65,0.00,0.00,2943.84,1639335.56,0.00,0.00,0.00),('1','143','865','232600',4473764,'2516','382',329972.38,329972.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','232600',4473765,'2517','382',365547.65,367109.37,0.00,0.00,1561.72,880131.48,0.00,0.00,0.00),('1','143','865','233209',4484726,'2516','382',329972.38,331978.52,0.00,0.00,2006.14,1114623.76,0.00,0.00,0.00),('1','143','866','233209',4484727,'2517','382',367109.37,367785.33,0.00,0.00,675.96,365360.64,0.00,0.00,0.00),('1','143','865','233382',4487878,'2516','382',331978.52,333503.55,0.00,0.00,1525.03,948900.36,0.00,0.00,0.00),('1','143','866','233382',4487879,'2517','382',367785.33,367835.29,0.00,0.00,49.96,31175.04,0.00,0.00,0.00),('1','143','865','233618',4492165,'2516','382',333503.55,335746.13,0.00,0.00,2242.58,1389469.92,0.00,0.00,0.00),('1','143','866','233618',4492166,'2517','382',367835.29,367835.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','233854',4496316,'2516','382',335746.13,338077.11,0.00,0.00,2330.98,1430894.28,0.00,0.00,0.00),('1','143','866','233854',4496317,'2517','382',367835.29,367835.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','234067',4500130,'2516','382',338077.11,340385.94,0.00,0.00,2308.83,1396567.44,0.00,0.00,0.00),('1','143','866','234067',4500131,'2517','382',367835.29,367835.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','234323',4504789,'2516','382',340385.94,341815.36,0.00,0.00,1429.42,878314.08,0.00,0.00,0.00),('1','143','866','234323',4504790,'2517','382',367835.29,367835.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','234574',4509321,'2516','382',341815.36,345358.45,0.00,0.00,3543.09,2118512.16,0.00,0.00,0.00),('1','143','866','234574',4509322,'2517','382',367835.29,367835.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','234842',4514037,'2516','382',345358.45,347205.51,0.00,0.00,1847.06,1125205.44,0.00,0.00,0.00),('1','143','866','234842',4514038,'2517','382',367835.29,367835.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','235095',4518561,'2516','382',347205.51,349212.02,0.00,0.00,2006.51,1222542.24,0.00,0.00,0.00),('1','143','866','235095',4518562,'2517','382',367835.29,367835.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','235312',4522291,'2516','382',349212.02,350601.64,0.00,0.00,1389.62,853421.28,0.00,0.00,0.00),('1','143','866','235312',4522292,'2517','382',367835.29,367835.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','235467',4525229,'2516','382',350601.64,350901.87,0.00,0.00,300.23,187343.52,0.00,0.00,0.00),('1','143','866','235467',4525230,'2517','382',367835.29,367890.72,0.00,0.00,55.43,33688.32,0.00,0.00,0.00),('1','143','865','235551',4526462,'2516','382',350901.87,351550.28,0.00,0.00,648.41,404607.84,0.00,0.00,0.00),('1','143','866','235551',4526463,'2517','382',367890.72,368698.11,0.00,0.00,807.39,496683.36,0.00,0.00,0.00),('1','143','865','235776',4530439,'2516','382',351550.28,351561.28,0.00,0.00,11.00,6864.00,0.00,0.00,0.00),('1','143','866','235776',4530440,'2517','382',368698.11,370186.95,0.00,0.00,1488.84,919712.16,0.00,0.00,0.00),('1','143','865','236033',4534899,'2516','382',351561.28,351582.18,0.00,0.00,20.90,13041.60,0.00,0.00,0.00),('1','143','866','236033',4534900,'2517','382',370186.95,372768.55,0.00,0.00,2581.60,1567974.40,0.00,0.00,0.00),('1','143','865','236248',4538788,'2516','382',351582.18,351594.68,0.00,0.00,12.50,7800.00,0.00,0.00,0.00),('1','143','866','236248',4538789,'2517','382',372768.55,376349.26,0.00,0.00,3580.71,2157629.04,0.00,0.00,0.00),('1','143','865','236528',4543715,'2516','382',351594.68,351638.31,0.00,0.00,43.63,27923.20,0.00,0.00,0.00),('1','143','866','236528',4543716,'2517','382',376349.26,378384.96,0.00,0.00,2035.70,1294208.00,0.00,0.00,0.00),('1','143','865','236752',4547441,'2516','382',351638.31,351638.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','236752',4547442,'2517','382',378384.96,380355.10,0.00,0.00,1970.14,1241081.60,0.00,0.00,0.00),('1','143','865','236979',4551539,'2516','382',351638.31,351638.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','236979',4551540,'2517','382',380355.10,381197.53,0.00,0.00,842.43,527155.20,0.00,0.00,0.00),('1','143','865','237051',4552772,'2516','382',351638.31,352256.84,0.00,0.00,618.53,395059.20,0.00,0.00,0.00),('1','143','866','237051',4552773,'2517','382',381197.53,381240.31,0.00,0.00,42.78,27379.20,0.00,0.00,0.00),('1','143','865','237183',4555084,'2516','382',352256.84,352467.90,0.00,0.00,211.06,135078.40,0.00,0.00,0.00),('1','143','866','237183',4555085,'2517','382',381240.31,382850.13,0.00,0.00,1609.82,1014732.80,0.00,0.00,0.00),('1','143','865','237395',4559047,'2516','382',352467.90,353037.63,0.00,0.00,569.73,364627.20,0.00,0.00,0.00),('1','143','866','237395',4559048,'2517','382',382850.13,384074.08,0.00,0.00,1223.95,769888.00,0.00,0.00,0.00),('1','143','865','237637',4563194,'2516','382',353037.63,354864.12,0.00,0.00,1826.49,1152836.32,0.00,0.00,0.00),('1','143','866','237637',4563195,'2517','382',384074.08,384962.52,0.00,0.00,888.44,566037.52,0.00,0.00,0.00),('1','143','865','237912',4567679,'2516','382',354864.12,357874.05,0.00,0.00,3009.93,1896367.20,0.00,0.00,0.00),('1','143','866','237912',4567680,'2517','382',384962.52,384979.52,0.00,0.00,17.00,10880.00,0.00,0.00,0.00),('1','143','865','238137',4571301,'2516','382',357874.05,359312.00,0.00,0.00,1437.95,912848.00,0.00,0.00,0.00),('1','143','866','238137',4571302,'2517','382',384979.52,384979.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','238379',4575620,'2516','382',359312.00,360974.65,0.00,0.00,1662.65,1055856.00,0.00,0.00,0.00),('1','143','866','238379',4575621,'2517','382',384979.52,384979.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','238626',4579674,'2516','382',360974.65,364411.92,0.00,0.00,3437.27,2177708.80,0.00,0.00,0.00),('1','143','866','238626',4579675,'2517','382',384979.52,384992.02,0.00,0.00,12.50,8000.00,0.00,0.00,0.00),('1','143','865','238850',4583653,'2516','382',364411.92,366455.46,0.00,0.00,2043.54,1301906.56,0.00,0.00,0.00),('1','143','866','238850',4583654,'2517','382',384992.02,384992.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','239079',4587775,'2516','382',366455.46,366526.96,0.00,0.00,71.50,41756.00,0.00,0.00,0.00),('1','143','866','239079',4587776,'2517','382',384992.02,384992.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','239092',4588006,'2516','382',366526.96,369137.63,0.00,0.00,2610.67,1659068.80,0.00,0.00,0.00),('1','143','866','239092',4588007,'2517','382',384992.02,384992.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','239316',4591843,'2516','382',369137.63,370475.69,0.00,0.00,1338.06,855238.40,0.00,0.00,0.00),('1','143','866','239316',4591844,'2517','382',384992.02,384998.27,0.00,0.00,6.25,4000.00,0.00,0.00,0.00),('1','143','865','239545',4595669,'2516','382',370475.69,372203.01,0.00,0.00,1727.32,1093161.76,0.00,0.00,0.00),('1','143','866','239545',4595670,'2517','382',384998.27,384998.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','239783',4599929,'2516','382',372203.01,372659.47,0.00,0.00,456.46,299437.76,0.00,0.00,0.00),('1','143','866','239783',4599930,'2517','382',384998.27,384998.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','239874',4601575,'2516','382',372659.47,372670.47,0.00,0.00,11.00,7216.00,0.00,0.00,0.00),('1','143','866','239874',4601576,'2517','382',384998.27,386081.99,0.00,0.00,1083.72,699376.32,0.00,0.00,0.00),('1','143','865','240013',4603861,'2516','382',372670.47,372670.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','240013',4603862,'2517','382',386081.99,388064.86,0.00,0.00,1982.87,1278532.72,0.00,0.00,0.00),('1','143','865','240226',4607624,'2516','382',372670.47,372670.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','240226',4607625,'2517','382',388064.86,389738.45,0.00,0.00,1673.59,1085265.04,0.00,0.00,0.00),('1','143','865','240468',4611451,'2516','382',372670.47,372670.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','240468',4611452,'2517','382',389738.45,391534.01,0.00,0.00,1795.56,1164887.36,0.00,0.00,0.00),('1','143','865','240711',4615228,'2516','382',372670.47,372670.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','240711',4615229,'2517','382',391534.01,393535.76,0.00,0.00,2001.75,1290294.00,0.00,0.00,0.00),('1','143','865','240988',4620129,'2516','382',372670.47,372670.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','240988',4620130,'2517','382',393535.76,395366.36,0.00,0.00,1830.60,1182673.60,0.00,0.00,0.00),('1','143','865','241259',4624972,'2516','382',372670.47,372670.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','241259',4624973,'2517','382',395366.36,397322.33,0.00,0.00,1955.97,1259274.32,0.00,0.00,0.00),('1','143','865','241512',4629273,'2516','382',372670.47,372670.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','241512',4629274,'2517','382',397322.33,399025.07,0.00,0.00,1702.74,1101397.44,0.00,0.00,0.00),('1','143','865','241760',4633680,'2516','382',372670.47,372670.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','241760',4633681,'2517','382',399025.07,400266.39,0.00,0.00,1241.32,810405.92,0.00,0.00,0.00),('1','143','865','241996',4637668,'2516','382',372670.47,372676.47,0.00,0.00,6.00,3936.00,0.00,0.00,0.00),('1','143','866','241996',4637669,'2517','382',400266.39,401568.04,0.00,0.00,1301.65,852478.40,0.00,0.00,0.00),('1','143','865','242231',4641864,'2516','382',372676.47,372676.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','242231',4641865,'2517','382',401568.04,403269.14,0.00,0.00,1701.10,1109421.60,0.00,0.00,0.00),('1','143','865','242454',4645688,'2516','382',372676.47,372679.47,0.00,0.00,3.00,1968.00,0.00,0.00,0.00),('1','143','866','242454',4645689,'2517','382',403269.14,404813.33,0.00,0.00,1544.19,1003888.64,0.00,0.00,0.00),('1','143','865','242705',4650205,'2516','382',372679.47,372708.47,0.00,0.00,29.00,19024.00,0.00,0.00,0.00),('1','143','866','242705',4650206,'2517','382',404813.33,406442.24,0.00,0.00,1628.91,1059828.96,0.00,0.00,0.00),('1','143','865','242938',4654117,'2516','382',372708.47,372718.81,0.00,0.00,10.34,6783.04,0.00,0.00,0.00),('1','143','866','242938',4654118,'2517','382',406442.24,408169.86,0.00,0.00,1727.62,1122918.72,0.00,0.00,0.00),('1','143','865','243167',4658090,'2516','382',372718.81,372718.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','243167',4658091,'2517','382',408169.86,409000.20,0.00,0.00,830.34,535603.04,0.00,0.00,0.00),('1','143','865','243247',4659676,'2516','382',372718.81,373450.09,0.00,0.00,731.28,478679.68,0.00,0.00,0.00),('1','143','866','243247',4659677,'2517','382',409000.20,409014.01,0.00,0.00,13.81,9059.36,0.00,0.00,0.00),('1','143','865','243389',4662113,'2516','382',373450.09,374640.65,0.00,0.00,1190.56,779102.86,0.00,0.00,0.00),('1','143','866','243389',4662114,'2517','382',409014.01,409017.06,0.00,0.00,3.05,2000.80,0.00,0.00,0.00),('1','143','865','243616',4665964,'2516','382',374640.65,376792.99,0.00,0.00,2152.34,1392468.06,0.00,0.00,0.00),('1','143','866','243616',4665965,'2517','382',409017.06,409017.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','243863',4670299,'2516','382',376792.99,378574.33,0.00,0.00,1781.34,1159199.04,0.00,0.00,0.00),('1','143','866','243863',4670300,'2517','382',409017.06,409017.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','244083',4674221,'2516','382',378574.33,380381.75,0.00,0.00,1807.42,1172043.52,0.00,0.00,0.00),('1','143','866','244083',4674222,'2517','382',409017.06,409017.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','244327',4678168,'2516','382',380381.75,382428.24,0.00,0.00,2046.49,1328457.44,0.00,0.00,0.00),('1','143','866','244327',4678169,'2517','382',409017.06,409019.06,0.00,0.00,2.00,1312.00,0.00,0.00,0.00),('1','143','865','244543',4682025,'2516','382',382428.24,383952.18,0.00,0.00,1523.94,999704.64,0.00,0.00,0.00),('1','143','866','244543',4682026,'2517','382',409019.06,409019.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','244762',4685698,'2516','382',383952.18,385680.00,0.00,0.00,1727.82,1118109.92,0.00,0.00,0.00),('1','143','866','244762',4685699,'2517','382',409019.06,409019.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','245006',4689968,'2516','382',385680.00,386697.63,0.00,0.00,1017.63,634041.12,0.00,0.00,0.00),('1','143','866','245006',4689969,'2517','382',409019.06,409019.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','245129',4692368,'2516','382',386697.63,386816.25,0.00,0.00,118.62,74018.88,0.00,0.00,0.00),('1','143','866','245129',4692369,'2517','382',409019.06,409150.16,0.00,0.00,131.10,81806.40,0.00,0.00,0.00),('1','143','865','245256',4694358,'2516','382',386816.25,387101.40,0.00,0.00,285.15,177933.60,0.00,0.00,0.00),('1','143','866','245256',4694359,'2517','382',409150.16,410227.22,0.00,0.00,1077.06,666589.44,0.00,0.00,0.00),('1','143','865','245455',4697854,'2516','382',387101.40,387101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','245455',4697855,'2517','382',410227.22,412473.41,0.00,0.00,2246.19,1377382.56,0.00,0.00,0.00),('1','143','865','245698',4702067,'2516','382',387101.40,387101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','245698',4702068,'2517','382',412473.41,413908.96,0.00,0.00,1435.55,884983.20,0.00,0.00,0.00),('1','143','865','245962',4706139,'2516','382',387101.40,387101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','245962',4706140,'2517','382',413908.96,415306.37,0.00,0.00,1397.41,849304.56,0.00,0.00,0.00),('1','143','865','246214',4710388,'2516','382',387101.40,387101.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','246214',4710389,'2517','382',415306.37,416603.34,0.00,0.00,1296.97,790699.52,0.00,0.00,0.00),('1','143','865','246483',4714955,'2516','382',387101.40,387107.40,0.00,0.00,6.00,3696.00,0.00,0.00,0.00),('1','143','866','246483',4714956,'2517','382',416603.34,417732.47,0.00,0.00,1129.13,691404.08,0.00,0.00,0.00),('1','143','865','246719',4718947,'2516','382',387107.40,387110.40,0.00,0.00,3.00,1848.00,0.00,0.00,0.00),('1','143','866','246719',4718948,'2517','382',417732.47,419208.65,0.00,0.00,1476.18,897182.88,0.00,0.00,0.00),('1','143','865','246963',4723284,'2516','382',387110.40,387127.90,0.00,0.00,17.50,10780.00,0.00,0.00,0.00),('1','143','866','246963',4723285,'2517','382',419208.65,421474.07,0.00,0.00,2265.42,1349282.52,0.00,0.00,0.00),('1','143','865','247187',4727050,'2516','382',387127.90,387133.90,0.00,0.00,6.00,3696.00,0.00,0.00,0.00),('1','143','866','247187',4727051,'2517','382',421474.07,423157.95,0.00,0.00,1683.88,1015190.08,0.00,0.00,0.00),('1','143','865','247430',4731435,'2516','382',387133.90,387133.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','247430',4731436,'2517','382',423157.95,424618.19,0.00,0.00,1460.24,880003.84,0.00,0.00,0.00),('1','143','865','247694',4735857,'2516','382',387133.90,387138.90,0.00,0.00,5.00,3080.00,0.00,0.00,0.00),('1','143','866','247694',4735858,'2517','382',424618.19,425769.81,0.00,0.00,1151.62,702267.92,0.00,0.00,0.00),('1','143','865','247935',4739845,'2516','382',387138.90,387138.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','247935',4739846,'2517','382',425769.81,426263.15,0.00,0.00,493.34,303897.44,0.00,0.00,0.00),('1','143','865','248021',4741403,'2516','382',387138.90,387615.18,0.00,0.00,476.28,283176.48,0.00,0.00,0.00),('1','143','866','248021',4741404,'2517','382',426263.15,426516.64,0.00,0.00,253.49,153849.84,0.00,0.00,0.00),('1','143','865','248198',4744454,'2516','382',387615.18,388978.13,0.00,0.00,1362.95,802317.20,0.00,0.00,0.00),('1','143','866','248198',4744455,'2517','382',426516.64,426565.76,0.00,0.00,49.12,30257.92,0.00,0.00,0.00),('1','143','865','248329',4746890,'2516','382',388978.13,388978.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','248329',4746891,'2517','382',426565.76,427083.36,0.00,0.00,517.60,311205.60,0.00,0.00,0.00),('1','143','865','248430',4748309,'2516','382',388978.13,391097.80,0.00,0.00,2119.67,1255254.72,0.00,0.00,0.00),('1','143','866','248430',4748310,'2517','382',427083.36,427149.86,0.00,0.00,66.50,40964.00,0.00,0.00,0.00),('1','143','865','248673',4752319,'2516','382',391097.80,392486.93,0.00,0.00,1389.13,848804.08,0.00,0.00,0.00),('1','143','866','248673',4752320,'2517','382',427149.86,427181.86,0.00,0.00,32.00,19712.00,0.00,0.00,0.00),('1','143','865','248901',4756339,'2516','382',392486.93,393835.38,0.00,0.00,1348.45,798270.00,0.00,0.00,0.00),('1','143','866','248901',4756340,'2517','382',427181.86,427181.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','249116',4759909,'2516','382',393835.38,395419.57,0.00,0.00,1584.19,938914.00,0.00,0.00,0.00),('1','143','866','249116',4759910,'2517','382',427181.86,427190.86,0.00,0.00,9.00,5400.00,0.00,0.00,0.00),('1','143','865','249368',4764222,'2516','382',395419.57,397871.88,0.00,0.00,2452.31,1423686.00,0.00,0.00,0.00),('1','143','866','249368',4764223,'2517','382',427190.86,427190.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','249617',4768382,'2516','382',397871.88,399505.54,0.00,0.00,1633.66,956596.00,0.00,0.00,0.00),('1','143','866','249617',4768383,'2517','382',427190.86,427190.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','249879',4772820,'2516','382',399505.54,400589.04,0.00,0.00,1083.50,632100.00,0.00,0.00,0.00),('1','143','866','249879',4772821,'2517','382',427190.86,427194.53,0.00,0.00,3.67,2202.00,0.00,0.00,0.00),('1','143','865','250011',4775272,'2516','382',400589.04,400736.54,0.00,0.00,147.50,86500.00,0.00,0.00,0.00),('1','143','866','250011',4775273,'2517','382',427194.53,427474.70,0.00,0.00,280.17,168102.00,0.00,0.00,0.00),('1','143','865','250039',4775779,'2516','382',400736.54,400736.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','250039',4775780,'2517','382',427474.70,427474.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','250042',4775803,'2516','382',400736.54,400736.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','250042',4775804,'2517','382',427474.70,427474.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','250045',4775849,'2516','382',400736.54,400736.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','250045',4775850,'2517','382',427474.70,427474.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','250047',4775879,'2516','382',400736.54,400736.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','250047',4775880,'2517','382',427474.70,427474.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','250048',4775881,'2516','382',400736.54,400736.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','250048',4775882,'2517','382',427474.70,427474.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','250049',4775883,'2516','382',400736.54,400736.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','250049',4775884,'2517','382',427474.70,427474.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','250115',4776747,'2516','382',400736.54,400783.04,0.00,0.00,46.50,27900.00,0.00,0.00,0.00),('1','143','866','250115',4776748,'2517','382',427474.70,429247.95,0.00,0.00,1773.25,1041390.00,0.00,0.00,0.00),('1','143','865','250342',4780692,'2516','382',400783.04,400807.04,0.00,0.00,24.00,14400.00,0.00,0.00,0.00),('1','143','866','250342',4780693,'2517','382',429247.95,429247.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','250374',4781064,'2516','382',400807.04,400807.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','250374',4781065,'2517','382',429247.95,431438.62,0.00,0.00,2190.67,1286602.00,0.00,0.00,0.00),('1','143','865','250575',4784464,'2516','382',400807.04,400815.04,0.00,0.00,8.00,4800.00,0.00,0.00,0.00),('1','143','866','250575',4784465,'2517','382',431438.62,433270.62,0.00,0.00,1832.00,1075600.00,0.00,0.00,0.00),('1','143','865','250819',4788675,'2516','382',400815.04,400866.54,0.00,0.00,51.50,30900.00,0.00,0.00,0.00),('1','143','866','250819',4788676,'2517','382',433270.62,434967.27,0.00,0.00,1696.65,999990.00,0.00,0.00,0.00),('1','143','865','251039',4792736,'2516','382',400866.54,400883.54,0.00,0.00,17.00,10200.00,0.00,0.00,0.00),('1','143','866','251039',4792737,'2517','382',434967.27,436285.92,0.00,0.00,1318.65,786790.00,0.00,0.00,0.00),('1','143','865','251287',4796933,'2516','382',400883.54,401070.04,0.00,0.00,186.50,104940.00,0.00,0.00,0.00),('1','143','866','251287',4796934,'2517','382',436285.92,437742.83,0.00,0.00,1456.91,853746.00,0.00,0.00,0.00),('1','143','865','251535',4801133,'2516','382',401070.04,401070.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','251535',4801134,'2517','382',437742.83,439521.31,0.00,0.00,1778.48,1045488.00,0.00,0.00,0.00),('1','143','865','251793',4805774,'2516','382',401070.04,401082.71,0.00,0.00,12.67,7602.00,0.00,0.00,0.00),('1','143','866','251793',4805775,'2517','382',439521.31,442217.82,0.00,0.00,2696.51,1545311.00,0.00,0.00,0.00),('1','143','865','252023',4809667,'2516','382',401082.71,401082.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','252023',4809668,'2517','382',442217.82,443409.66,0.00,0.00,1191.84,713104.00,0.00,0.00,0.00),('1','143','865','252262',4813840,'2516','382',401082.71,401082.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','252262',4813841,'2517','382',443409.66,444936.65,0.00,0.00,1526.99,895074.00,0.00,0.00,0.00),('1','143','865','252498',4818137,'2516','382',401082.71,401122.71,0.00,0.00,40.00,22400.00,0.00,0.00,0.00),('1','143','866','252498',4818138,'2517','382',444936.65,446766.49,0.00,0.00,1829.84,1075104.00,0.00,0.00,0.00),('1','143','865','252735',4822262,'2516','382',401122.71,401128.71,0.00,0.00,6.00,3600.00,0.00,0.00,0.00),('1','143','866','252735',4822263,'2517','382',446766.49,448595.33,0.00,0.00,1828.84,1065224.00,0.00,0.00,0.00),('1','143','865','252993',4826370,'2516','382',401128.71,401128.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','252993',4826371,'2517','382',448595.33,449459.94,0.00,0.00,864.61,518766.00,0.00,0.00,0.00),('1','143','865','253224',4830349,'2516','382',401128.71,401128.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','253224',4830350,'2517','382',449459.94,449749.27,0.00,0.00,289.33,171598.00,0.00,0.00,0.00),('1','143','865','253306',4831777,'2516','382',401128.71,402269.38,0.00,0.00,1140.67,656202.00,0.00,0.00,0.00),('1','143','866','253306',4831778,'2517','382',449749.27,449963.11,0.00,0.00,213.84,128304.00,0.00,0.00,0.00),('1','143','865','253497',4834945,'2516','382',402269.38,404562.52,0.00,0.00,2293.14,1315888.00,0.00,0.00,0.00),('1','143','866','253497',4834946,'2517','382',449963.11,449992.28,0.00,0.00,29.17,17502.00,0.00,0.00,0.00),('1','143','865','253734',4838971,'2516','382',404562.52,405822.02,0.00,0.00,1259.50,743620.00,0.00,0.00,0.00),('1','143','866','253734',4838972,'2517','382',449992.28,450002.28,0.00,0.00,10.00,6000.00,0.00,0.00,0.00),('1','143','865','253983',4843338,'2516','382',405822.02,407174.51,0.00,0.00,1352.49,797494.00,0.00,0.00,0.00),('1','143','866','253983',4843339,'2517','382',450002.28,450005.28,0.00,0.00,3.00,1800.00,0.00,0.00,0.00),('1','143','865','254226',4847744,'2516','382',407174.51,409111.93,0.00,0.00,1937.42,1130452.00,0.00,0.00,0.00),('1','143','866','254226',4847745,'2517','382',450005.28,450007.28,0.00,0.00,2.00,1200.00,0.00,0.00,0.00),('1','143','865','254463',4851820,'2516','382',409111.93,410742.07,0.00,0.00,1630.14,965524.00,0.00,0.00,0.00),('1','143','866','254463',4851821,'2517','382',450007.28,450018.28,0.00,0.00,11.00,6600.00,0.00,0.00,0.00),('1','143','865','254728',4856398,'2516','382',410742.07,412288.19,0.00,0.00,1546.12,908107.60,0.00,0.00,0.00),('1','143','866','254728',4856399,'2517','382',450018.28,450018.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','254979',4860697,'2516','382',412288.19,414200.18,0.00,0.00,1911.99,1107594.00,0.00,0.00,0.00),('1','143','866','254979',4860698,'2517','382',450018.28,450018.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','255224',4864861,'2516','382',414200.18,415644.68,0.00,0.00,1444.50,850060.00,0.00,0.00,0.00),('1','143','866','255224',4864862,'2517','382',450018.28,450027.28,0.00,0.00,9.00,5400.00,0.00,0.00,0.00),('1','143','865','255490',4869420,'2516','382',415644.68,417035.39,0.00,0.00,1390.71,830826.00,0.00,0.00,0.00),('1','143','866','255490',4869421,'2517','382',450027.28,450027.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','255730',4873448,'2516','382',417035.39,418404.96,0.00,0.00,1369.57,806542.00,0.00,0.00,0.00),('1','143','866','255730',4873449,'2517','382',450027.28,450057.45,0.00,0.00,30.17,18102.00,0.00,0.00,0.00),('1','143','865','255991',4877664,'2516','382',418404.96,419577.13,0.00,0.00,1172.17,679942.00,0.00,0.00,0.00),('1','143','866','255991',4877665,'2517','382',450057.45,450057.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','256075',4879278,'2516','382',419577.13,419620.46,0.00,0.00,43.33,25998.00,0.00,0.00,0.00),('1','143','866','256075',4879279,'2517','382',450057.45,450964.86,0.00,0.00,907.41,537446.00,0.00,0.00,0.00),('1','143','865','256232',4881447,'2516','382',419620.46,419634.46,0.00,0.00,14.00,8400.00,0.00,0.00,0.00),('1','143','866','256232',4881448,'2517','382',450964.86,452122.96,0.00,0.00,1158.10,684060.00,0.00,0.00,0.00),('1','143','865','256513',4886398,'2516','382',419634.46,419659.29,0.00,0.00,24.83,14898.00,0.00,0.00,0.00),('1','143','866','256513',4886399,'2517','382',452122.96,453023.10,0.00,0.00,900.14,536084.00,0.00,0.00,0.00),('1','143','865','256754',4890275,'2516','382',419659.29,420087.46,0.00,0.00,428.17,249102.00,0.00,0.00,0.00),('1','143','866','256754',4890276,'2517','382',453023.10,455291.74,0.00,0.00,2268.64,1302309.00,0.00,0.00,0.00),('1','143','865','256992',4894474,'2516','382',420087.46,420096.46,0.00,0.00,9.00,5400.00,0.00,0.00,0.00),('1','143','866','256992',4894475,'2517','382',455291.74,456895.73,0.00,0.00,1603.99,945134.00,0.00,0.00,0.00),('1','143','865','257252',4899264,'2516','382',420096.46,420107.29,0.00,0.00,10.83,6498.00,0.00,0.00,0.00),('1','143','866','257252',4899265,'2517','382',456895.73,458929.40,0.00,0.00,2033.67,1182642.00,0.00,0.00,0.00),('1','143','865','257417',4902485,'2516','382',420107.29,420107.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257417',4902486,'2517','382',458929.40,458929.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257441',4902911,'2516','382',420107.29,420107.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257441',4902912,'2517','382',458929.40,458929.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257514',4903752,'2516','382',420107.29,420107.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257514',4903753,'2517','382',458929.40,460647.68,0.00,0.00,1718.28,1015368.00,0.00,0.00,0.00),('1','143','865','257515',4903754,'2516','382',420107.29,420119.79,0.00,0.00,12.50,7500.00,0.00,0.00,0.00),('1','143','866','257515',4903755,'2517','382',460647.68,461930.85,0.00,0.00,1283.17,767902.00,0.00,0.00,0.00),('1','143','865','257516',4903756,'2516','382',420119.79,420129.79,0.00,0.00,10.00,6000.00,0.00,0.00,0.00),('1','143','866','257516',4903757,'2517','382',461930.85,462811.01,0.00,0.00,880.16,519256.00,0.00,0.00,0.00),('1','143','865','257517',4903758,'2516','382',420129.79,420818.95,0.00,0.00,689.16,411896.00,0.00,0.00,0.00),('1','143','866','257517',4903759,'2517','382',462811.01,462852.18,0.00,0.00,41.17,24702.00,0.00,0.00,0.00),('1','143','865','257518',4903760,'2516','382',420818.95,420848.95,0.00,0.00,30.00,18000.00,0.00,0.00,0.00),('1','143','866','257518',4903761,'2517','382',462852.18,462913.18,0.00,0.00,61.00,36600.00,0.00,0.00,0.00),('1','143','865','257519',4903762,'2516','382',420848.95,420866.95,0.00,0.00,18.00,10800.00,0.00,0.00,0.00),('1','143','866','257519',4903763,'2517','382',462913.18,464801.20,0.00,0.00,1888.02,1119252.00,0.00,0.00,0.00),('1','143','865','257520',4903764,'2516','382',420866.95,421857.62,0.00,0.00,990.67,551337.00,0.00,0.00,0.00),('1','143','866','257520',4903765,'2517','382',464801.20,466432.53,0.00,0.00,1631.33,976798.00,0.00,0.00,0.00),('1','143','865','257521',4903766,'2516','382',421857.62,421857.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257521',4903767,'2517','382',466432.53,467110.35,0.00,0.00,677.82,406692.00,0.00,0.00,0.00),('1','143','865','257522',4903768,'2516','382',421857.62,421875.12,0.00,0.00,17.50,10500.00,0.00,0.00,0.00),('1','143','866','257522',4903769,'2517','382',467110.35,468473.68,0.00,0.00,1363.33,810678.00,0.00,0.00,0.00),('1','143','865','257523',4903770,'2516','382',421875.12,421900.29,0.00,0.00,25.17,15102.00,0.00,0.00,0.00),('1','143','866','257523',4903771,'2517','382',468473.68,469795.19,0.00,0.00,1321.51,785946.00,0.00,0.00,0.00),('1','143','865','257524',4903772,'2516','382',421900.29,421906.29,0.00,0.00,6.00,3600.00,0.00,0.00,0.00),('1','143','866','257524',4903773,'2517','382',469795.19,471616.79,0.00,0.00,1821.60,1066960.00,0.00,0.00,0.00),('1','143','865','257525',4903774,'2516','382',2028.78,2346.50,0.00,0.00,317.72,190632.00,0.00,0.00,0.00),('1','143','866','257525',4903775,'2517','382',1007.80,1157.80,0.00,0.00,150.00,84000.00,0.00,0.00,0.00),('1','143','865','257525',4903776,'2518','382',1322.16,1536.83,0.00,0.00,214.67,128802.00,0.00,0.00,0.00),('1','143','866','257525',4903777,'2519','382',879.74,1285.68,0.00,0.00,405.94,243564.00,0.00,0.00,0.00),('1','143','865','257526',4903778,'2516','382',2346.50,2346.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257526',4903779,'2517','382',1157.80,1497.80,0.00,0.00,340.00,190400.00,0.00,0.00,0.00),('1','143','865','257526',4903780,'2518','382',1536.83,2067.84,0.00,0.00,531.01,318606.00,0.00,0.00,0.00),('1','143','866','257526',4903781,'2519','382',1285.68,1786.68,0.00,0.00,501.00,300600.00,0.00,0.00,0.00),('1','143','865','257527',4903782,'2516','382',2346.50,2817.84,0.00,0.00,471.34,282804.00,0.00,0.00,0.00),('1','143','866','257527',4903783,'2517','382',1497.80,1579.23,0.00,0.00,81.43,45600.80,0.00,0.00,0.00),('1','143','865','257527',4903784,'2518','382',2067.84,2067.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257527',4903785,'2519','382',1786.68,2444.29,0.00,0.00,657.61,394566.00,0.00,0.00,0.00),('1','143','865','257528',4903786,'2516','382',2817.84,2817.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257528',4903787,'2517','382',1579.23,1579.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257528',4903788,'2518','382',2067.84,2135.34,0.00,0.00,67.50,38340.00,0.00,0.00,0.00),('1','143','866','257528',4903789,'2519','382',2444.29,2512.29,0.00,0.00,68.00,38624.00,0.00,0.00,0.00),('1','143','865','257529',4903790,'2516','382',2817.84,2817.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257529',4903791,'2518','382',2135.34,2526.83,0.00,0.00,391.49,222366.32,0.00,0.00,0.00),('1','143','866','257529',4903792,'2519','382',2512.29,3108.41,0.00,0.00,596.12,338596.16,0.00,0.00,0.00),('1','143','866','257529',4903793,'2517','382',1579.23,1679.23,0.00,0.00,100.00,54400.00,0.00,0.00,0.00),('1','143','865','257530',4903794,'2516','382',2817.84,3293.36,0.00,0.00,475.52,270095.36,0.00,0.00,0.00),('1','143','866','257530',4903795,'2517','382',1679.23,1929.23,0.00,0.00,250.00,136000.00,0.00,0.00,0.00),('1','143','865','257530',4903796,'2518','382',2526.83,2526.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257530',4903797,'2519','382',3108.41,3556.85,0.00,0.00,448.44,254713.92,0.00,0.00,0.00),('1','143','865','257531',4903798,'2516','382',3293.36,4118.07,0.00,0.00,824.71,468435.28,0.00,0.00,0.00),('1','143','866','257531',4903799,'2517','382',1929.23,2283.23,0.00,0.00,354.00,192576.00,0.00,0.00,0.00),('1','143','865','257531',4903800,'2518','382',2526.83,2526.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257531',4903801,'2519','382',3556.85,4408.59,0.00,0.00,851.74,483788.32,0.00,0.00,0.00),('1','143','865','257532',4903802,'2516','382',4118.07,4486.29,0.00,0.00,368.22,209148.96,0.00,0.00,0.00),('1','143','866','257532',4903803,'2517','382',2283.23,2761.53,0.00,0.00,478.30,260195.20,0.00,0.00,0.00),('1','143','865','257532',4903804,'2518','382',2526.83,2526.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257532',4903805,'2519','382',4408.59,5404.65,0.00,0.00,996.06,565762.08,0.00,0.00,0.00),('1','143','865','257533',4903806,'2516','382',4486.29,5323.31,0.00,0.00,837.02,475427.36,0.00,0.00,0.00),('1','143','866','257533',4903807,'2517','382',2761.53,2911.53,0.00,0.00,150.00,81600.00,0.00,0.00,0.00),('1','143','865','257533',4903808,'2518','382',2526.83,2526.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257533',4903809,'2519','382',5404.65,6090.77,0.00,0.00,686.12,389716.16,0.00,0.00,0.00),('1','143','865','257534',4903810,'2516','382',5323.31,5896.05,0.00,0.00,572.74,325316.32,0.00,0.00,0.00),('1','143','865','257534',4903811,'2518','382',2526.83,2902.68,0.00,0.00,375.85,213482.80,0.00,0.00,0.00),('1','143','866','257534',4903812,'2519','382',6090.77,6090.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257534',4903813,'2517','382',2911.53,3386.53,0.00,0.00,475.00,258400.00,0.00,0.00,0.00),('1','143','865','257535',4903814,'2516','382',5896.05,5896.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257535',4903815,'2517','382',3386.53,3386.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257535',4903816,'2518','382',2902.68,2902.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257535',4903817,'2519','382',6090.77,6090.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257536',4903818,'2516','382',5896.05,5896.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257536',4903819,'2517','382',3386.53,3386.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257536',4903820,'2518','382',2902.68,2902.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257536',4903821,'2519','382',6090.77,6090.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257537',4903822,'2516','382',5896.05,5896.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257537',4903823,'2517','382',3386.53,3534.53,0.00,0.00,148.00,80512.00,0.00,0.00,0.00),('1','143','865','257537',4903824,'2518','382',2902.68,3415.21,0.00,0.00,512.53,291117.04,0.00,0.00,0.00),('1','143','866','257537',4903825,'2519','382',6090.77,6601.46,0.00,0.00,510.69,290071.92,0.00,0.00,0.00),('1','143','865','257538',4903826,'2516','382',5896.05,6583.28,0.00,0.00,687.23,390346.64,0.00,0.00,0.00),('1','143','866','257538',4903827,'2517','382',3534.53,3659.53,0.00,0.00,125.00,68000.00,0.00,0.00,0.00),('1','143','865','257538',4903828,'2518','382',3415.21,3415.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257538',4903829,'2519','382',6601.46,6861.29,0.00,0.00,259.83,147583.44,0.00,0.00,0.00),('1','143','865','257539',4903830,'2516','382',6583.28,7021.58,0.00,0.00,438.30,248954.40,0.00,0.00,0.00),('1','143','866','257539',4903831,'2517','382',3659.53,4159.53,0.00,0.00,500.00,272000.00,0.00,0.00,0.00),('1','143','865','257539',4903832,'2518','382',3415.21,3843.12,0.00,0.00,427.91,243052.88,0.00,0.00,0.00),('1','143','866','257539',4903833,'2519','382',6861.29,6861.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257540',4903834,'2516','382',7021.58,7046.58,0.00,0.00,25.00,14200.00,0.00,0.00,0.00),('1','143','866','257540',4903835,'2517','382',4159.53,4409.53,0.00,0.00,250.00,136000.00,0.00,0.00,0.00),('1','143','865','257540',4903836,'2518','382',3843.12,4438.63,0.00,0.00,595.51,338249.68,0.00,0.00,0.00),('1','143','866','257540',4903837,'2519','382',6861.29,7149.30,0.00,0.00,288.01,163589.68,0.00,0.00,0.00),('1','143','865','257541',4903838,'2516','382',7046.58,7051.58,0.00,0.00,5.00,2840.00,0.00,0.00,0.00),('1','143','866','257541',4903839,'2517','382',4409.53,4733.53,0.00,0.00,324.00,176256.00,0.00,0.00,0.00),('1','143','865','257541',4903840,'2518','382',4438.63,5147.81,0.00,0.00,709.18,402814.24,0.00,0.00,0.00),('1','143','866','257541',4903841,'2519','382',7149.30,7549.43,0.00,0.00,400.13,227273.84,0.00,0.00,0.00),('1','143','865','257542',4903842,'2516','382',7051.58,7682.97,0.00,0.00,631.39,358629.52,0.00,0.00,0.00),('1','143','866','257542',4903843,'2517','382',4733.53,4833.53,0.00,0.00,100.00,54400.00,0.00,0.00,0.00),('1','143','865','257542',4903844,'2518','382',5147.81,5471.53,0.00,0.00,323.72,183872.96,0.00,0.00,0.00),('1','143','866','257542',4903845,'2519','382',7549.43,7549.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257543',4903846,'2516','382',7682.97,7682.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257543',4903847,'2517','382',4833.53,4933.53,0.00,0.00,100.00,54400.00,0.00,0.00,0.00),('1','143','865','257543',4903848,'2518','382',5471.53,6102.38,0.00,0.00,630.85,358322.80,0.00,0.00,0.00),('1','143','866','257543',4903849,'2519','382',7549.43,7977.68,0.00,0.00,428.25,243246.00,0.00,0.00,0.00),('1','143','865','257544',4903850,'2516','382',7682.97,8346.47,0.00,0.00,663.50,376868.00,0.00,0.00,0.00),('1','143','866','257544',4903851,'2517','382',4933.53,5253.53,0.00,0.00,320.00,174080.00,0.00,0.00,0.00),('1','143','865','257544',4903852,'2518','382',6102.38,6579.71,0.00,0.00,477.33,271123.44,0.00,0.00,0.00),('1','143','866','257544',4903853,'2519','382',7977.68,7977.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257545',4903854,'2516','382',8346.47,8346.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257545',4903855,'2517','382',5253.53,5255.29,0.00,0.00,1.76,999.68,0.00,0.00,0.00),('1','143','865','257545',4903856,'2518','382',6579.71,7342.44,0.00,0.00,762.73,433230.64,0.00,0.00,0.00),('1','143','866','257545',4903857,'2519','382',7977.68,8460.87,0.00,0.00,483.19,274451.92,0.00,0.00,0.00),('1','143','865','257546',4903858,'2516','382',8346.47,9014.78,0.00,0.00,668.31,379600.08,0.00,0.00,0.00),('1','143','866','257546',4903859,'2517','382',5255.29,5452.29,0.00,0.00,197.00,107168.00,0.00,0.00,0.00),('1','143','865','257546',4903860,'2518','382',7342.44,7497.46,0.00,0.00,155.02,88051.36,0.00,0.00,0.00),('1','143','866','257546',4903861,'2519','382',8460.87,8949.93,0.00,0.00,489.06,277786.08,0.00,0.00,0.00),('1','143','865','257547',4903862,'2516','382',9014.78,9366.32,0.00,0.00,351.54,199674.72,0.00,0.00,0.00),('1','143','866','257547',4903863,'2517','382',5452.29,5517.29,0.00,0.00,65.00,35360.00,0.00,0.00,0.00),('1','143','865','257547',4903864,'2518','382',7497.46,8359.31,0.00,0.00,861.85,489530.80,0.00,0.00,0.00),('1','143','866','257547',4903865,'2519','382',8949.93,9050.13,0.00,0.00,100.20,56913.60,0.00,0.00,0.00),('1','143','865','257548',4903866,'2516','382',9366.32,9465.52,0.00,0.00,99.20,56345.60,0.00,0.00,0.00),('1','143','866','257548',4903867,'2517','382',5517.29,5517.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257548',4903868,'2518','382',8359.31,8489.33,0.00,0.00,130.02,73851.36,0.00,0.00,0.00),('1','143','866','257548',4903869,'2519','382',9050.13,9050.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257549',4903870,'2516','382',9465.52,9940.28,0.00,0.00,474.76,269663.68,0.00,0.00,0.00),('1','143','865','257549',4903871,'2518','382',8489.33,8853.41,0.00,0.00,364.08,206797.44,0.00,0.00,0.00),('1','143','866','257549',4903872,'2519','382',9050.13,9050.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257549',4903873,'2517','382',5517.29,5881.29,0.00,0.00,364.00,198016.00,0.00,0.00,0.00),('1','143','865','257550',4903874,'2516','382',9940.28,10536.79,0.00,0.00,596.51,338817.68,0.00,0.00,0.00),('1','143','866','257550',4903875,'2517','382',5881.29,5956.29,0.00,0.00,75.00,40800.00,0.00,0.00,0.00),('1','143','865','257550',4903876,'2518','382',8853.41,8856.41,0.00,0.00,3.00,1704.00,0.00,0.00,0.00),('1','143','866','257550',4903877,'2519','382',9050.13,9820.65,0.00,0.00,770.52,437655.36,0.00,0.00,0.00),('1','143','865','257551',4903878,'2516','382',10536.79,10536.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257551',4903879,'2517','382',5956.29,6031.29,0.00,0.00,75.00,40800.00,0.00,0.00,0.00),('1','143','865','257551',4903880,'2518','382',8856.41,9568.55,0.00,0.00,712.14,404495.52,0.00,0.00,0.00),('1','143','866','257551',4903881,'2519','382',9820.65,10492.52,0.00,0.00,671.87,381622.16,0.00,0.00,0.00),('1','143','865','257552',4903882,'2516','382',10536.79,10536.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257552',4903883,'2517','382',6031.29,6441.29,0.00,0.00,410.00,223040.00,0.00,0.00,0.00),('1','143','865','257552',4903884,'2518','382',9568.55,10308.76,0.00,0.00,740.21,420439.28,0.00,0.00,0.00),('1','143','866','257552',4903885,'2519','382',10492.52,11127.70,0.00,0.00,635.18,360782.24,0.00,0.00,0.00),('1','143','865','257553',4903886,'2516','382',10536.79,10536.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257553',4903887,'2517','382',6441.29,6441.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257553',4903888,'2518','382',10308.76,10308.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257553',4903889,'2519','382',11127.70,11127.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257554',4903890,'2516','382',10536.79,11184.44,0.00,0.00,647.65,367865.20,0.00,0.00,0.00),('1','143','866','257554',4903891,'2517','382',6441.29,6796.06,0.00,0.00,354.77,192994.88,0.00,0.00,0.00),('1','143','865','257554',4903892,'2518','382',10308.76,10972.61,0.00,0.00,663.85,377066.80,0.00,0.00,0.00),('1','143','866','257554',4903893,'2519','382',11127.70,11127.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257555',4903894,'2516','382',11184.44,11195.44,0.00,0.00,11.00,6248.00,0.00,0.00,0.00),('1','143','866','257555',4903895,'2517','382',6796.06,6896.06,0.00,0.00,100.00,54400.00,0.00,0.00,0.00),('1','143','865','257555',4903896,'2518','382',10972.61,11649.37,0.00,0.00,676.76,384399.68,0.00,0.00,0.00),('1','143','866','257555',4903897,'2519','382',11127.70,11621.87,0.00,0.00,494.17,280688.56,0.00,0.00,0.00),('1','143','865','257556',4903898,'2516','382',11195.44,11691.82,0.00,0.00,496.38,317683.20,0.00,0.00,0.00),('1','143','866','257556',4903899,'2517','382',6896.06,7016.06,0.00,0.00,120.00,74400.00,0.00,0.00,0.00),('1','143','865','257556',4903900,'2518','382',11649.37,11667.87,0.00,0.00,18.50,11840.00,0.00,0.00,0.00),('1','143','866','257556',4903901,'2519','382',11621.87,12170.73,0.00,0.00,548.86,351270.40,0.00,0.00,0.00),('1','143','865','257557',4903902,'2516','382',11691.82,12344.33,0.00,0.00,652.51,417606.40,0.00,0.00,0.00),('1','143','866','257557',4903903,'2517','382',7016.06,7066.06,0.00,0.00,50.00,31000.00,0.00,0.00,0.00),('1','143','865','257557',4903904,'2518','382',11667.87,11667.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257557',4903905,'2519','382',12170.73,12805.12,0.00,0.00,634.39,406009.60,0.00,0.00,0.00),('1','143','865','257558',4903906,'2516','382',12344.33,12841.64,0.00,0.00,497.31,318278.40,0.00,0.00,0.00),('1','143','866','257558',4903907,'2517','382',7066.06,7416.06,0.00,0.00,350.00,217000.00,0.00,0.00,0.00),('1','143','865','257558',4903908,'2518','382',11667.87,12141.71,0.00,0.00,473.84,303257.60,0.00,0.00,0.00),('1','143','866','257558',4903909,'2519','382',12805.12,12805.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257559',4903910,'2516','382',12841.64,12844.64,0.00,0.00,3.00,1920.00,0.00,0.00,0.00),('1','143','866','257559',4903911,'2517','382',7416.06,7416.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257559',4903912,'2518','382',12141.71,12773.08,0.00,0.00,631.37,404076.80,0.00,0.00,0.00),('1','143','866','257559',4903913,'2519','382',12805.12,14059.97,0.00,0.00,1254.85,803104.00,0.00,0.00,0.00),('1','143','865','257560',4903914,'2516','382',12844.64,12844.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257560',4903915,'2517','382',7416.06,7965.06,0.00,0.00,549.00,340380.00,0.00,0.00,0.00),('1','143','865','257560',4903916,'2518','382',12773.08,13501.86,0.00,0.00,728.78,466419.20,0.00,0.00,0.00),('1','143','866','257560',4903917,'2519','382',14059.97,14597.38,0.00,0.00,537.41,343942.40,0.00,0.00,0.00),('1','143','865','257561',4903918,'2516','382',12844.64,13694.80,0.00,0.00,850.16,544102.40,0.00,0.00,0.00),('1','143','866','257561',4903919,'2517','382',7965.06,8239.06,0.00,0.00,274.00,169880.00,0.00,0.00,0.00),('1','143','865','257561',4903920,'2518','382',13501.86,14308.59,0.00,0.00,806.73,516307.20,0.00,0.00,0.00),('1','143','866','257561',4903921,'2519','382',14597.38,14597.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257562',4903922,'2516','382',13694.80,13694.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257562',4903923,'2517','382',8239.06,8923.50,0.00,0.00,684.44,438041.60,0.00,0.00,0.00),('1','143','865','257562',4903924,'2518','382',14308.59,14909.06,0.00,0.00,600.47,408319.60,0.00,0.00,0.00),('1','143','866','257562',4903925,'2519','382',14597.38,15216.57,0.00,0.00,619.19,421049.20,0.00,0.00,0.00),('1','143','865','257563',4903926,'2516','382',13694.80,14333.64,0.00,0.00,638.84,434411.20,0.00,0.00,0.00),('1','143','866','257563',4903927,'2517','382',8923.50,8947.50,0.00,0.00,24.00,15360.00,0.00,0.00,0.00),('1','143','865','257563',4903928,'2518','382',14909.06,14909.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257563',4903929,'2519','382',15216.57,15755.46,0.00,0.00,538.89,366445.20,0.00,0.00,0.00),('1','143','865','257564',4903930,'2516','382',14333.64,14717.31,0.00,0.00,383.67,260895.60,0.00,0.00,0.00),('1','143','866','257564',4903931,'2517','382',8947.50,9127.50,0.00,0.00,180.00,115200.00,0.00,0.00,0.00),('1','143','865','257564',4903932,'2518','382',14909.06,14909.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257564',4903933,'2519','382',15755.46,16237.83,0.00,0.00,482.37,328011.60,0.00,0.00,0.00),('1','143','865','257565',4903934,'2516','382',14717.31,15193.44,0.00,0.00,476.13,323768.40,0.00,0.00,0.00),('1','143','866','257565',4903935,'2517','382',9127.50,9266.50,0.00,0.00,139.00,88960.00,0.00,0.00,0.00),('1','143','865','257565',4903936,'2518','382',14909.06,15335.96,0.00,0.00,426.90,290292.00,0.00,0.00,0.00),('1','143','866','257565',4903937,'2519','382',16237.83,16237.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257566',4903938,'2516','382',15193.44,15435.33,0.00,0.00,241.89,164485.20,0.00,0.00,0.00),('1','143','866','257566',4903939,'2517','382',9266.50,9706.50,0.00,0.00,440.00,281600.00,0.00,0.00,0.00),('1','143','865','257566',4903940,'2518','382',15335.96,15335.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257566',4903941,'2519','382',16237.83,16544.16,0.00,0.00,306.33,208304.40,0.00,0.00,0.00),('1','143','865','257567',4903942,'2516','382',15435.33,15847.66,0.00,0.00,412.33,280384.40,0.00,0.00,0.00),('1','143','866','257567',4903943,'2517','382',9706.50,10119.00,0.00,0.00,412.50,264000.00,0.00,0.00,0.00),('1','143','865','257567',4903944,'2518','382',15335.96,15756.97,0.00,0.00,421.01,286286.80,0.00,0.00,0.00),('1','143','866','257567',4903945,'2519','382',16544.16,16544.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257568',4903946,'2516','382',15847.66,16308.89,0.00,0.00,461.23,313636.40,0.00,0.00,0.00),('1','143','866','257568',4903947,'2517','382',10119.00,11014.95,0.00,0.00,895.95,573408.00,0.00,0.00,0.00),('1','143','865','257568',4903948,'2518','382',15756.97,16085.89,0.00,0.00,328.92,223665.60,0.00,0.00,0.00),('1','143','866','257568',4903949,'2519','382',16544.16,16567.66,0.00,0.00,23.50,15980.00,0.00,0.00,0.00),('1','143','865','257569',4903950,'2516','382',16308.89,16820.64,0.00,0.00,511.75,347990.00,0.00,0.00,0.00),('1','143','866','257569',4903951,'2517','382',11014.95,11364.95,0.00,0.00,350.00,224000.00,0.00,0.00,0.00),('1','143','865','257569',4903952,'2518','382',16085.89,16085.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257569',4903953,'2519','382',16567.66,16952.22,0.00,0.00,384.56,261500.80,0.00,0.00,0.00),('1','143','865','257570',4903954,'2516','382',16820.64,16959.48,0.00,0.00,138.84,94411.20,0.00,0.00,0.00),('1','143','866','257570',4903955,'2517','382',11364.95,11514.95,0.00,0.00,150.00,96000.00,0.00,0.00,0.00),('1','143','865','257570',4903956,'2518','382',16085.89,16085.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257570',4903957,'2519','382',16952.22,17127.45,0.00,0.00,175.23,119156.40,0.00,0.00,0.00),('1','143','865','257571',4903958,'2516','382',16959.48,17354.76,0.00,0.00,395.28,268790.40,0.00,0.00,0.00),('1','143','865','257571',4903959,'2518','382',16085.89,16085.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257571',4903960,'2519','382',17127.45,17289.44,0.00,0.00,161.99,110153.20,0.00,0.00,0.00),('1','143','866','257571',4903961,'2517','382',11514.95,11664.95,0.00,0.00,150.00,96000.00,0.00,0.00,0.00),('1','143','865','257572',4903962,'2516','382',17354.76,17412.27,0.00,0.00,57.51,39106.80,0.00,0.00,0.00),('1','143','866','257572',4903963,'2517','382',11664.95,11846.95,0.00,0.00,182.00,116480.00,0.00,0.00,0.00),('1','143','865','257572',4903964,'2518','382',16085.89,16148.83,0.00,0.00,62.94,42799.20,0.00,0.00,0.00),('1','143','866','257572',4903965,'2519','382',17289.44,17289.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257573',4903966,'2516','382',17412.27,17926.60,0.00,0.00,514.33,349744.40,0.00,0.00,0.00),('1','143','865','257573',4903967,'2518','382',16148.83,16688.41,0.00,0.00,539.58,366914.40,0.00,0.00,0.00),('1','143','866','257573',4903968,'2519','382',17289.44,17289.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257573',4903969,'2517','382',11846.95,11929.95,0.00,0.00,83.00,53120.00,0.00,0.00,0.00),('1','143','865','257574',4903970,'2516','382',17926.60,17926.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257574',4903971,'2517','382',11929.95,12079.95,0.00,0.00,150.00,96000.00,0.00,0.00,0.00),('1','143','865','257574',4903972,'2518','382',16688.41,16976.28,0.00,0.00,287.87,195751.60,0.00,0.00,0.00),('1','143','866','257574',4903973,'2519','382',17289.44,17742.52,0.00,0.00,453.08,308094.40,0.00,0.00,0.00),('1','143','865','257575',4903974,'2516','382',17926.60,18436.70,0.00,0.00,510.10,346868.00,0.00,0.00,0.00),('1','143','866','257575',4903975,'2517','382',12079.95,12260.58,0.00,0.00,180.63,115603.20,0.00,0.00,0.00),('1','143','865','257575',4903976,'2518','382',16976.28,16976.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257575',4903977,'2519','382',17742.52,18165.99,0.00,0.00,423.47,287959.60,0.00,0.00,0.00),('1','143','865','257576',4903978,'2516','382',18436.70,18910.69,0.00,0.00,473.99,322313.20,0.00,0.00,0.00),('1','143','866','257576',4903979,'2517','382',12260.58,12260.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257576',4903980,'2518','382',16976.28,16976.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257576',4903981,'2519','382',18165.99,18883.14,0.00,0.00,717.15,487662.00,0.00,0.00,0.00),('1','143','865','257577',4903982,'2516','382',18910.69,18910.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257577',4903983,'2517','382',12260.58,12434.58,0.00,0.00,174.00,111708.00,0.00,0.00,0.00),('1','143','865','257577',4903984,'2518','382',16976.28,17467.79,0.00,0.00,491.51,334226.80,0.00,0.00,0.00),('1','143','866','257577',4903985,'2519','382',18883.14,19320.92,0.00,0.00,437.78,297690.40,0.00,0.00,0.00),('1','143','865','257578',4903986,'2516','382',18910.69,18910.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257578',4903987,'2517','382',12434.58,12824.58,0.00,0.00,390.00,250380.00,0.00,0.00,0.00),('1','143','865','257578',4903988,'2518','382',17467.79,18130.91,0.00,0.00,663.12,450921.60,0.00,0.00,0.00),('1','143','866','257578',4903989,'2519','382',19320.92,20104.90,0.00,0.00,783.98,533106.40,0.00,0.00,0.00),('1','143','865','257579',4903990,'2516','382',18910.69,19431.78,0.00,0.00,521.09,354341.20,0.00,0.00,0.00),('1','143','866','257579',4903991,'2517','382',12824.58,13289.88,0.00,0.00,465.30,298722.60,0.00,0.00,0.00),('1','143','865','257579',4903992,'2518','382',18130.91,18181.64,0.00,0.00,50.73,34496.40,0.00,0.00,0.00),('1','143','866','257579',4903993,'2519','382',20104.90,20617.81,0.00,0.00,512.91,348778.80,0.00,0.00,0.00),('1','143','865','257580',4903994,'2516','382',19431.78,20406.33,0.00,0.00,974.55,662694.00,0.00,0.00,0.00),('1','143','866','257580',4903995,'2517','382',13289.88,13389.88,0.00,0.00,100.00,64200.00,0.00,0.00,0.00),('1','143','865','257580',4903996,'2518','382',18181.64,19110.33,0.00,0.00,928.69,631509.20,0.00,0.00,0.00),('1','143','866','257580',4903997,'2519','382',20617.81,20617.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257581',4903998,'2516','382',20406.33,20430.05,0.00,0.00,23.72,15418.00,0.00,0.00,0.00),('1','143','866','257581',4903999,'2517','382',13389.88,13757.86,0.00,0.00,367.98,228297.60,0.00,0.00,0.00),('1','143','865','257581',4904000,'2518','382',19110.33,20048.30,0.00,0.00,937.97,609680.50,0.00,0.00,0.00),('1','143','866','257581',4904001,'2519','382',20617.81,21630.99,0.00,0.00,1013.18,658567.00,0.00,0.00,0.00),('1','143','865','257582',4904002,'2516','382',20430.05,20566.94,0.00,0.00,136.89,88978.50,0.00,0.00,0.00),('1','143','866','257582',4904003,'2517','382',13757.86,13757.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257582',4904004,'2518','382',20048.30,20159.05,0.00,0.00,110.75,71987.50,0.00,0.00,0.00),('1','143','866','257582',4904005,'2519','382',21630.99,21630.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257583',4904006,'2516','382',20566.94,20581.94,0.00,0.00,15.00,9750.00,0.00,0.00,0.00),('1','143','866','257583',4904007,'2517','382',13757.86,13757.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257583',4904008,'2518','382',20159.05,20183.41,0.00,0.00,24.36,15834.00,0.00,0.00,0.00),('1','143','866','257583',4904009,'2519','382',21630.99,21630.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257584',4904010,'2516','382',20581.94,20581.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257584',4904011,'2517','382',13757.86,13757.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257584',4904012,'2518','382',20183.41,20183.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257584',4904013,'2519','382',21630.99,21630.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257585',4904014,'2516','382',20581.94,21142.00,0.00,0.00,560.06,364039.00,0.00,0.00,0.00),('1','143','865','257585',4904015,'2518','382',20183.41,20244.24,0.00,0.00,60.83,39539.50,0.00,0.00,0.00),('1','143','866','257585',4904016,'2519','382',21630.99,22129.47,0.00,0.00,498.48,324012.00,0.00,0.00,0.00),('1','143','866','257585',4904017,'2517','382',13757.86,13807.86,0.00,0.00,50.00,31000.00,0.00,0.00,0.00),('1','143','865','257586',4904018,'2516','382',21142.00,22102.05,0.00,0.00,960.05,624032.50,0.00,0.00,0.00),('1','143','866','257586',4904019,'2517','382',13807.86,13957.86,0.00,0.00,150.00,93000.00,0.00,0.00,0.00),('1','143','865','257586',4904020,'2518','382',20244.24,20244.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257586',4904021,'2519','382',22129.47,22908.12,0.00,0.00,778.65,506122.50,0.00,0.00,0.00),('1','143','865','257587',4904022,'2516','382',22102.05,22326.18,0.00,0.00,224.13,145684.50,0.00,0.00,0.00),('1','143','866','257587',4904023,'2517','382',13957.86,14220.36,0.00,0.00,262.50,162750.00,0.00,0.00,0.00),('1','143','865','257587',4904024,'2518','382',20244.24,20244.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257587',4904025,'2519','382',22908.12,23090.43,0.00,0.00,182.31,118501.50,0.00,0.00,0.00),('1','143','865','257588',4904026,'2516','382',22326.18,22548.81,0.00,0.00,222.63,144709.50,0.00,0.00,0.00),('1','143','865','257588',4904027,'2518','382',20244.24,20244.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257588',4904028,'2519','382',23090.43,23430.11,0.00,0.00,339.68,220792.00,0.00,0.00,0.00),('1','143','866','257588',4904029,'2517','382',14220.36,14428.08,0.00,0.00,207.72,128786.40,0.00,0.00,0.00),('1','143','865','257589',4904030,'2516','382',22548.81,23192.92,0.00,0.00,644.11,418671.50,0.00,0.00,0.00),('1','143','866','257589',4904031,'2517','382',14428.08,14488.08,0.00,0.00,60.00,37200.00,0.00,0.00,0.00),('1','143','865','257589',4904032,'2518','382',20244.24,20244.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257589',4904033,'2519','382',23430.11,24140.62,0.00,0.00,710.51,461831.50,0.00,0.00,0.00),('1','143','865','257590',4904034,'2516','382',23192.92,23463.98,0.00,0.00,271.06,176189.00,0.00,0.00,0.00),('1','143','866','257590',4904035,'2517','382',14488.08,14538.08,0.00,0.00,50.00,31000.00,0.00,0.00,0.00),('1','143','865','257590',4904036,'2518','382',20244.24,20244.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257590',4904037,'2519','382',24140.62,24923.39,0.00,0.00,782.77,508800.50,0.00,0.00,0.00),('1','143','865','257591',4904038,'2516','382',23463.98,23820.96,0.00,0.00,356.98,232037.00,0.00,0.00,0.00),('1','143','866','257591',4904039,'2517','382',14538.08,14580.58,0.00,0.00,42.50,26350.00,0.00,0.00,0.00),('1','143','865','257591',4904040,'2518','382',20244.24,20244.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257591',4904041,'2519','382',24923.39,25387.59,0.00,0.00,464.20,301730.00,0.00,0.00,0.00),('1','143','865','257592',4904042,'2516','382',23820.96,24350.98,0.00,0.00,530.02,344513.00,0.00,0.00,0.00),('1','143','866','257592',4904043,'2517','382',14580.58,14658.00,0.00,0.00,77.42,48000.40,0.00,0.00,0.00),('1','143','865','257592',4904044,'2518','382',20244.24,20244.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257592',4904045,'2519','382',25387.59,25832.09,0.00,0.00,444.50,288925.00,0.00,0.00,0.00),('1','143','865','257593',4904046,'2516','382',24350.98,24872.24,0.00,0.00,521.26,338819.00,0.00,0.00,0.00),('1','143','866','257593',4904047,'2517','382',14658.00,14768.00,0.00,0.00,110.00,68200.00,0.00,0.00,0.00),('1','143','865','257593',4904048,'2518','382',20244.24,20244.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257593',4904049,'2519','382',25832.09,26118.65,0.00,0.00,286.56,186264.00,0.00,0.00,0.00),('1','143','865','257594',4904050,'2516','382',24872.24,25412.29,0.00,0.00,540.05,351032.50,0.00,0.00,0.00),('1','143','866','257594',4904051,'2517','382',14768.00,14942.00,0.00,0.00,174.00,107880.00,0.00,0.00,0.00),('1','143','865','257594',4904052,'2518','382',20244.24,20244.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257594',4904053,'2519','382',26118.65,26551.84,0.00,0.00,433.19,281573.50,0.00,0.00,0.00),('1','143','865','257595',4904054,'2516','382',25412.29,25412.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257595',4904055,'2517','382',14942.00,14942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257595',4904056,'2518','382',20244.24,20598.64,0.00,0.00,354.40,230360.00,0.00,0.00,0.00),('1','143','866','257595',4904057,'2519','382',26551.84,26912.96,0.00,0.00,361.12,234728.00,0.00,0.00,0.00),('1','143','865','257596',4904058,'2516','382',25412.29,25412.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257596',4904059,'2517','382',14942.00,15292.00,0.00,0.00,350.00,217000.00,0.00,0.00,0.00),('1','143','865','257596',4904060,'2518','382',20598.64,21115.64,0.00,0.00,517.00,336050.00,0.00,0.00,0.00),('1','143','866','257596',4904061,'2519','382',26912.96,27370.11,0.00,0.00,457.15,297147.50,0.00,0.00,0.00),('1','143','865','257597',4904062,'2516','382',25412.29,25604.62,0.00,0.00,192.33,125014.50,0.00,0.00,0.00),('1','143','866','257597',4904063,'2517','382',15292.00,16456.53,0.00,0.00,1164.53,718605.01,0.00,0.00,0.00),('1','143','865','257597',4904064,'2518','382',21115.64,21115.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257597',4904065,'2519','382',27370.11,27636.18,0.00,0.00,266.07,172945.50,0.00,0.00,0.00),('1','143','865','257598',4904066,'2516','382',25604.62,25691.63,0.00,0.00,87.01,56556.50,0.00,0.00,0.00),('1','143','865','257598',4904067,'2518','382',21115.64,21115.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257598',4904068,'2519','382',27636.18,27845.21,0.00,0.00,209.03,135869.50,0.00,0.00,0.00),('1','143','866','257598',4904069,'2517','382',16456.53,16867.00,0.00,0.00,410.47,253259.99,0.00,0.00,0.00),('1','143','865','257599',4904070,'2516','382',25691.63,25935.22,0.00,0.00,243.59,158333.50,0.00,0.00,0.00),('1','143','866','257599',4904071,'2517','382',16867.00,16867.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257599',4904072,'2518','382',21115.64,21474.91,0.00,0.00,359.27,233525.50,0.00,0.00,0.00),('1','143','866','257599',4904073,'2519','382',27845.21,28009.10,0.00,0.00,163.89,106528.50,0.00,0.00,0.00),('1','143','865','257600',4904074,'2516','382',25935.22,26512.48,0.00,0.00,577.26,375219.00,0.00,0.00,0.00),('1','143','866','257600',4904075,'2517','382',16867.00,17067.00,0.00,0.00,200.00,124000.00,0.00,0.00,0.00),('1','143','865','257600',4904076,'2518','382',21474.91,21474.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257600',4904077,'2519','382',28009.10,28220.57,0.00,0.00,211.47,137455.50,0.00,0.00,0.00),('1','143','865','257601',4904078,'2516','382',26512.48,26823.11,0.00,0.00,310.63,201909.50,0.00,0.00,0.00),('1','143','866','257601',4904079,'2517','382',17067.00,17354.00,0.00,0.00,287.00,177940.00,0.00,0.00,0.00),('1','143','865','257601',4904080,'2518','382',21474.91,21474.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257601',4904081,'2519','382',28220.57,28808.34,0.00,0.00,587.77,382050.50,0.00,0.00,0.00),('1','143','865','257602',4904082,'2516','382',26823.11,27429.33,0.00,0.00,606.22,394043.00,0.00,0.00,0.00),('1','143','866','257602',4904083,'2517','382',17354.00,17354.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257602',4904084,'2518','382',21474.91,21474.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257602',4904085,'2519','382',28808.34,29413.61,0.00,0.00,605.27,393425.50,0.00,0.00,0.00),('1','143','865','257603',4904086,'2516','382',27429.33,27894.14,0.00,0.00,464.81,302126.50,0.00,0.00,0.00),('1','143','866','257603',4904087,'2517','382',17354.00,17404.00,0.00,0.00,50.00,31000.00,0.00,0.00,0.00),('1','143','865','257603',4904088,'2518','382',21474.91,21474.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257603',4904089,'2519','382',29413.61,30004.65,0.00,0.00,591.04,384176.00,0.00,0.00,0.00),('1','143','865','257604',4904090,'2516','382',27894.14,28244.55,0.00,0.00,350.41,227766.50,0.00,0.00,0.00),('1','143','866','257604',4904091,'2517','382',17404.00,17852.50,0.00,0.00,448.50,278070.00,0.00,0.00,0.00),('1','143','865','257604',4904092,'2518','382',21474.91,21863.71,0.00,0.00,388.80,252720.00,0.00,0.00,0.00),('1','143','866','257604',4904093,'2519','382',30004.65,30004.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257605',4904094,'2516','382',28244.55,28611.68,0.00,0.00,367.13,238634.50,0.00,0.00,0.00),('1','143','866','257605',4904095,'2517','382',17852.50,18152.50,0.00,0.00,300.00,186000.00,0.00,0.00,0.00),('1','143','865','257605',4904096,'2518','382',21863.71,21863.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257605',4904097,'2519','382',30004.65,30423.62,0.00,0.00,418.97,272330.50,0.00,0.00,0.00),('1','143','865','257606',4904098,'2516','382',28611.68,28611.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257606',4904099,'2517','382',18152.50,18365.00,0.00,0.00,212.50,131750.00,0.00,0.00,0.00),('1','143','865','257606',4904100,'2518','382',21863.71,22189.11,0.00,0.00,325.40,211510.00,0.00,0.00,0.00),('1','143','866','257606',4904101,'2519','382',30423.62,30871.35,0.00,0.00,447.73,291024.50,0.00,0.00,0.00),('1','143','865','257607',4904102,'2516','382',28611.68,28983.14,0.00,0.00,371.46,241449.00,0.00,0.00,0.00),('1','143','866','257607',4904103,'2517','382',18365.00,18808.99,0.00,0.00,443.99,275273.80,0.00,0.00,0.00),('1','143','865','257607',4904104,'2518','382',22189.11,22608.09,0.00,0.00,418.98,272337.00,0.00,0.00,0.00),('1','143','866','257607',4904105,'2519','382',30871.35,30871.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257608',4904106,'2516','382',28983.14,28983.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257608',4904107,'2517','382',18808.99,19328.21,0.00,0.00,519.22,321916.40,0.00,0.00,0.00),('1','143','865','257608',4904108,'2518','382',22608.09,23153.64,0.00,0.00,545.55,354607.50,0.00,0.00,0.00),('1','143','866','257608',4904109,'2519','382',30871.35,31271.90,0.00,0.00,400.55,260357.50,0.00,0.00,0.00),('1','143','865','257609',4904110,'2516','382',28983.14,29606.49,0.00,0.00,623.35,405177.50,0.00,0.00,0.00),('1','143','866','257609',4904111,'2517','382',19328.21,21133.21,0.00,0.00,1805.00,1115272.00,0.00,0.00,0.00),('1','143','865','257609',4904112,'2518','382',23153.64,23913.69,0.00,0.00,760.05,494032.50,0.00,0.00,0.00),('1','143','866','257609',4904113,'2519','382',31271.90,31276.21,0.00,0.00,4.31,2801.50,0.00,0.00,0.00),('1','143','865','257610',4904114,'2516','382',29606.49,29606.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257610',4904115,'2517','382',21133.21,21531.99,0.00,0.00,398.78,247483.60,0.00,0.00,0.00),('1','143','865','257610',4904116,'2518','382',23913.69,24507.72,0.00,0.00,594.03,386119.50,0.00,0.00,0.00),('1','143','866','257610',4904117,'2519','382',31276.21,31756.64,0.00,0.00,480.43,312279.50,0.00,0.00,0.00),('1','143','865','257611',4904118,'2516','382',29606.49,29606.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257611',4904119,'2517','382',21531.99,21531.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257611',4904120,'2518','382',24507.72,24521.57,0.00,0.00,13.85,9002.50,0.00,0.00,0.00),('1','143','866','257611',4904121,'2519','382',31756.64,31925.60,0.00,0.00,168.96,109824.00,0.00,0.00,0.00),('1','143','865','257612',4904122,'2516','382',29606.49,30234.31,0.00,0.00,627.82,408083.00,0.00,0.00,0.00),('1','143','866','257612',4904123,'2517','382',21531.99,21531.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257612',4904124,'2518','382',24521.57,24521.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257612',4904125,'2519','382',31925.60,31925.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257613',4904126,'2516','382',30234.31,30319.47,0.00,0.00,85.16,55354.00,0.00,0.00,0.00),('1','143','866','257613',4904127,'2517','382',21531.99,21744.43,0.00,0.00,212.44,131712.80,0.00,0.00,0.00),('1','143','865','257613',4904128,'2518','382',24521.57,24959.38,0.00,0.00,437.81,284576.50,0.00,0.00,0.00),('1','143','866','257613',4904129,'2519','382',31925.60,31925.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257614',4904130,'2516','382',30319.47,30505.70,0.00,0.00,186.23,121049.50,0.00,0.00,0.00),('1','143','866','257614',4904131,'2517','382',21744.43,21953.43,0.00,0.00,209.00,129580.00,0.00,0.00,0.00),('1','143','865','257614',4904132,'2518','382',24959.38,24959.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257614',4904133,'2519','382',31925.60,32491.51,0.00,0.00,565.91,367841.50,0.00,0.00,0.00),('1','143','865','257615',4904134,'2516','382',30505.70,30505.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257615',4904135,'2517','382',21953.43,22003.43,0.00,0.00,50.00,31000.00,0.00,0.00,0.00),('1','143','865','257615',4904136,'2518','382',24959.38,25195.76,0.00,0.00,236.38,153647.00,0.00,0.00,0.00),('1','143','866','257615',4904137,'2519','382',32491.51,32497.51,0.00,0.00,6.00,3900.00,0.00,0.00,0.00),('1','143','865','257616',4904138,'2516','382',30505.70,30505.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257616',4904139,'2517','382',22003.43,22372.81,0.00,0.00,369.38,229015.60,0.00,0.00,0.00),('1','143','865','257616',4904140,'2518','382',25195.76,25362.68,0.00,0.00,166.92,108498.00,0.00,0.00,0.00),('1','143','866','257616',4904141,'2519','382',32497.51,32679.15,0.00,0.00,181.64,118066.00,0.00,0.00,0.00),('1','143','865','257617',4904142,'2516','382',30505.70,30505.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257617',4904143,'2517','382',22372.81,22505.81,0.00,0.00,133.00,82460.00,0.00,0.00,0.00),('1','143','865','257617',4904144,'2518','382',25362.68,25750.96,0.00,0.00,388.28,252382.00,0.00,0.00,0.00),('1','143','866','257617',4904145,'2519','382',32679.15,33099.45,0.00,0.00,420.30,273195.00,0.00,0.00,0.00),('1','143','865','257618',4904146,'2516','382',30505.70,31238.51,0.00,0.00,732.81,476326.50,0.00,0.00,0.00),('1','143','866','257618',4904147,'2517','382',22505.81,22655.81,0.00,0.00,150.00,93000.00,0.00,0.00,0.00),('1','143','865','257618',4904148,'2518','382',25750.96,25750.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257618',4904149,'2519','382',33099.45,33215.38,0.00,0.00,115.93,75354.50,0.00,0.00,0.00),('1','143','865','257619',4904150,'2516','382',31238.51,32103.49,0.00,0.00,864.98,562237.00,0.00,0.00,0.00),('1','143','866','257619',4904151,'2517','382',22655.81,22655.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257619',4904152,'2518','382',25750.96,25750.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257619',4904153,'2519','382',33215.38,33336.42,0.00,0.00,121.04,78676.00,0.00,0.00,0.00),('1','143','865','257620',4904154,'2516','382',32103.49,32742.09,0.00,0.00,638.60,415090.00,0.00,0.00,0.00),('1','143','866','257620',4904155,'2517','382',22655.81,23347.81,0.00,0.00,692.00,429040.00,0.00,0.00,0.00),('1','143','865','257620',4904156,'2518','382',25750.96,26276.28,0.00,0.00,525.32,341458.00,0.00,0.00,0.00),('1','143','866','257620',4904157,'2519','382',33336.42,33336.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257621',4904158,'2516','382',32742.09,32742.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257621',4904159,'2517','382',23347.81,23734.81,0.00,0.00,387.00,239940.00,0.00,0.00,0.00),('1','143','865','257621',4904160,'2518','382',26276.28,26959.65,0.00,0.00,683.37,444190.50,0.00,0.00,0.00),('1','143','866','257621',4904161,'2519','382',33336.42,34136.42,0.00,0.00,800.00,520000.00,0.00,0.00,0.00),('1','143','865','257622',4904162,'2516','382',32742.09,33452.88,0.00,0.00,710.79,462013.50,0.00,0.00,0.00),('1','143','866','257622',4904163,'2517','382',23734.81,23834.81,0.00,0.00,100.00,62000.00,0.00,0.00,0.00),('1','143','865','257622',4904164,'2518','382',26959.65,26959.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257622',4904165,'2519','382',34136.42,34875.49,0.00,0.00,739.07,480395.50,0.00,0.00,0.00),('1','143','865','257623',4904166,'2516','382',33452.88,34129.97,0.00,0.00,677.09,440108.50,0.00,0.00,0.00),('1','143','866','257623',4904167,'2517','382',23834.81,23942.31,0.00,0.00,107.50,66650.00,0.00,0.00,0.00),('1','143','865','257623',4904168,'2518','382',26959.65,27587.87,0.00,0.00,628.22,408343.00,0.00,0.00,0.00),('1','143','866','257623',4904169,'2519','382',34875.49,34875.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257624',4904170,'2516','382',34129.97,34752.44,0.00,0.00,622.47,404605.50,0.00,0.00,0.00),('1','143','866','257624',4904171,'2517','382',23942.31,24042.31,0.00,0.00,100.00,62000.00,0.00,0.00,0.00),('1','143','865','257624',4904172,'2518','382',27587.87,27587.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257624',4904173,'2519','382',34875.49,35571.16,0.00,0.00,695.67,452185.50,0.00,0.00,0.00),('1','143','865','257625',4904174,'2516','382',34752.44,35578.95,0.00,0.00,826.51,575250.96,0.00,0.00,0.00),('1','143','866','257625',4904175,'2517','382',24042.31,24392.31,0.00,0.00,350.00,228200.00,0.00,0.00,0.00),('1','143','865','257625',4904176,'2518','382',27587.87,27592.87,0.00,0.00,5.00,3480.00,0.00,0.00,0.00),('1','143','866','257625',4904177,'2519','382',35571.16,36346.16,0.00,0.00,775.00,539400.00,0.00,0.00,0.00),('1','143','865','257626',4904178,'2516','382',35578.95,35832.27,0.00,0.00,253.32,176310.72,0.00,0.00,0.00),('1','143','866','257626',4904179,'2517','382',24392.31,24441.74,0.00,0.00,49.43,32228.36,0.00,0.00,0.00),('1','143','865','257626',4904180,'2518','382',27592.87,27592.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257626',4904181,'2519','382',36346.16,36657.12,0.00,0.00,310.96,216428.16,0.00,0.00,0.00),('1','143','865','257627',4904182,'2516','382',35832.27,36395.33,0.00,0.00,563.06,391889.76,0.00,0.00,0.00),('1','143','865','257627',4904183,'2518','382',27592.87,27779.93,0.00,0.00,187.06,130193.76,0.00,0.00,0.00),('1','143','866','257627',4904184,'2519','382',36657.12,37138.90,0.00,0.00,481.78,335318.88,0.00,0.00,0.00),('1','143','866','257627',4904185,'2517','382',24441.74,24601.74,0.00,0.00,160.00,104320.00,0.00,0.00,0.00),('1','143','865','257628',4904186,'2516','382',36395.33,37228.11,0.00,0.00,832.78,579614.88,0.00,0.00,0.00),('1','143','866','257628',4904187,'2517','382',24601.74,25050.59,0.00,0.00,448.85,292650.20,0.00,0.00,0.00),('1','143','865','257628',4904188,'2518','382',27779.93,27779.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257628',4904189,'2519','382',37138.90,37876.93,0.00,0.00,738.03,513668.88,0.00,0.00,0.00),('1','143','865','257629',4904190,'2516','382',37228.11,37228.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257629',4904191,'2517','382',25050.59,25157.59,0.00,0.00,107.00,69764.00,0.00,0.00,0.00),('1','143','865','257629',4904192,'2518','382',27779.93,28473.83,0.00,0.00,693.90,482954.40,0.00,0.00,0.00),('1','143','866','257629',4904193,'2519','382',37876.93,38676.32,0.00,0.00,799.39,556375.44,0.00,0.00,0.00),('1','143','865','257630',4904194,'2516','382',37228.11,38122.72,0.00,0.00,894.61,622648.56,0.00,0.00,0.00),('1','143','866','257630',4904195,'2517','382',25157.59,25157.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257630',4904196,'2518','382',28473.83,29076.49,0.00,0.00,602.66,419451.36,0.00,0.00,0.00),('1','143','866','257630',4904197,'2519','382',38676.32,38676.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257631',4904198,'2516','382',38122.72,39179.40,0.00,0.00,1056.68,735449.28,0.00,0.00,0.00),('1','143','866','257631',4904199,'2517','382',25157.59,25157.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257631',4904200,'2518','382',29076.49,30052.83,0.00,0.00,976.34,679532.64,0.00,0.00,0.00),('1','143','866','257631',4904201,'2519','382',38676.32,38676.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257632',4904202,'2516','382',39179.40,39823.34,0.00,0.00,643.94,448182.24,0.00,0.00,0.00),('1','143','866','257632',4904203,'2517','382',25157.59,25157.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257632',4904204,'2518','382',30052.83,30631.04,0.00,0.00,578.21,402434.16,0.00,0.00,0.00),('1','143','866','257632',4904205,'2519','382',38676.32,38676.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257633',4904206,'2516','382',39823.34,40443.73,0.00,0.00,620.39,431791.44,0.00,0.00,0.00),('1','143','866','257633',4904207,'2517','382',25157.59,25157.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257633',4904208,'2518','382',30631.04,31287.21,0.00,0.00,656.17,456694.32,0.00,0.00,0.00),('1','143','866','257633',4904209,'2519','382',38676.32,38676.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257634',4904210,'2516','382',40443.73,41085.35,0.00,0.00,641.62,446567.52,0.00,0.00,0.00),('1','143','866','257634',4904211,'2517','382',25157.59,25157.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257634',4904212,'2518','382',31287.21,31964.59,0.00,0.00,677.38,471456.48,0.00,0.00,0.00),('1','143','866','257634',4904213,'2519','382',38676.32,38676.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257635',4904214,'2516','382',41085.35,41688.14,0.00,0.00,602.79,446064.60,0.00,0.00,0.00),('1','143','866','257635',4904215,'2517','382',25157.59,27832.40,0.00,0.00,2674.81,1752776.12,0.00,0.00,0.00),('1','143','865','257635',4904216,'2518','382',31964.59,32279.96,0.00,0.00,315.37,233373.80,0.00,0.00,0.00),('1','143','866','257635',4904217,'2519','382',38676.32,38688.82,0.00,0.00,12.50,8700.00,0.00,0.00,0.00),('1','143','865','257636',4904218,'2516','382',41688.14,42339.37,0.00,0.00,651.23,481910.20,0.00,0.00,0.00),('1','143','866','257636',4904219,'2517','382',27832.40,28144.90,0.00,0.00,312.50,217500.00,0.00,0.00,0.00),('1','143','865','257636',4904220,'2518','382',32279.96,32317.78,0.00,0.00,37.82,27986.80,0.00,0.00,0.00),('1','143','866','257636',4904221,'2519','382',38688.82,39036.28,0.00,0.00,347.46,257120.40,0.00,0.00,0.00),('1','143','865','257637',4904222,'2516','382',42339.37,42785.73,0.00,0.00,446.36,330306.40,0.00,0.00,0.00),('1','143','866','257637',4904223,'2517','382',28144.90,28587.90,0.00,0.00,443.00,308328.00,0.00,0.00,0.00),('1','143','865','257637',4904224,'2518','382',32317.78,32323.78,0.00,0.00,6.00,4440.00,0.00,0.00,0.00),('1','143','866','257637',4904225,'2519','382',39036.28,39488.61,0.00,0.00,452.33,334724.20,0.00,0.00,0.00),('1','143','865','257638',4904226,'2516','382',42785.73,42785.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257638',4904227,'2517','382',28587.90,28761.90,0.00,0.00,174.00,121104.00,0.00,0.00,0.00),('1','143','865','257638',4904228,'2518','382',32323.78,32955.83,0.00,0.00,632.05,467717.00,0.00,0.00,0.00),('1','143','866','257638',4904229,'2519','382',39488.61,40424.42,0.00,0.00,935.81,692499.40,0.00,0.00,0.00),('1','143','865','257639',4904230,'2516','382',42785.73,42785.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257639',4904231,'2517','382',28761.90,29213.57,0.00,0.00,451.67,314362.32,0.00,0.00,0.00),('1','143','865','257639',4904232,'2518','382',32955.83,33668.70,0.00,0.00,712.87,527523.80,0.00,0.00,0.00),('1','143','866','257639',4904233,'2519','382',40424.42,41090.67,0.00,0.00,666.25,493025.00,0.00,0.00,0.00),('1','143','865','257640',4904234,'2516','382',42785.73,43347.32,0.00,0.00,561.59,415576.60,0.00,0.00,0.00),('1','143','866','257640',4904235,'2517','382',29213.57,29327.57,0.00,0.00,114.00,79344.00,0.00,0.00,0.00),('1','143','865','257640',4904236,'2518','382',33668.70,33668.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257640',4904237,'2519','382',41090.67,41686.36,0.00,0.00,595.69,440810.60,0.00,0.00,0.00),('1','143','865','257641',4904238,'2516','382',43347.32,43433.44,0.00,0.00,86.12,63728.80,0.00,0.00,0.00),('1','143','866','257641',4904239,'2517','382',29327.57,29327.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257641',4904240,'2518','382',33668.70,33737.60,0.00,0.00,68.90,50986.00,0.00,0.00,0.00),('1','143','866','257641',4904241,'2519','382',41686.36,41686.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257642',4904242,'2516','382',43433.44,43966.65,0.00,0.00,533.21,394575.40,0.00,0.00,0.00),('1','143','865','257642',4904243,'2518','382',33737.60,34240.63,0.00,0.00,503.03,372242.20,0.00,0.00,0.00),('1','143','866','257642',4904244,'2519','382',41686.36,41686.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257642',4904245,'2517','382',29327.57,29614.07,0.00,0.00,286.50,199404.00,0.00,0.00,0.00),('1','143','865','257643',4904246,'2516','382',43966.65,44552.91,0.00,0.00,586.26,433832.40,0.00,0.00,0.00),('1','143','866','257643',4904247,'2517','382',29614.07,29954.07,0.00,0.00,340.00,236640.00,0.00,0.00,0.00),('1','143','865','257643',4904248,'2518','382',34240.63,34240.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257643',4904249,'2519','382',41686.36,42628.28,0.00,0.00,941.92,697020.80,0.00,0.00,0.00),('1','143','865','257644',4904250,'2516','382',44552.91,44552.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257644',4904251,'2517','382',29954.07,30562.07,0.00,0.00,608.00,423168.00,0.00,0.00,0.00),('1','143','865','257644',4904252,'2518','382',34240.63,34732.49,0.00,0.00,491.86,363976.40,0.00,0.00,0.00),('1','143','866','257644',4904253,'2519','382',42628.28,43272.40,0.00,0.00,644.12,476648.80,0.00,0.00,0.00),('1','143','865','257645',4904254,'2516','382',44552.91,45401.22,0.00,0.00,848.31,627749.40,0.00,0.00,0.00),('1','143','866','257645',4904255,'2517','382',30562.07,31227.57,0.00,0.00,665.50,463188.00,0.00,0.00,0.00),('1','143','865','257645',4904256,'2518','382',34732.49,35637.64,0.00,0.00,905.15,669811.00,0.00,0.00,0.00),('1','143','866','257645',4904257,'2519','382',43272.40,43272.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257646',4904258,'2516','382',45401.22,45401.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257646',4904259,'2517','382',31227.57,31702.57,0.00,0.00,475.00,330600.00,0.00,0.00,0.00),('1','143','865','257646',4904260,'2518','382',35637.64,36331.91,0.00,0.00,694.27,513759.80,0.00,0.00,0.00),('1','143','866','257646',4904261,'2519','382',43272.40,43798.60,0.00,0.00,526.20,389388.00,0.00,0.00,0.00),('1','143','865','257647',4904262,'2516','382',45401.22,46138.62,0.00,0.00,737.40,545676.00,0.00,0.00,0.00),('1','143','866','257647',4904263,'2517','382',31702.57,31796.57,0.00,0.00,94.00,65424.00,0.00,0.00,0.00),('1','143','865','257647',4904264,'2518','382',36331.91,36331.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257647',4904265,'2519','382',43798.60,44685.17,0.00,0.00,886.57,656061.80,0.00,0.00,0.00),('1','143','865','257648',4904266,'2516','382',46138.62,46138.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257648',4904267,'2517','382',31796.57,32446.57,0.00,0.00,650.00,452400.00,0.00,0.00,0.00),('1','143','865','257648',4904268,'2518','382',36331.91,37219.06,0.00,0.00,887.15,656491.00,0.00,0.00,0.00),('1','143','866','257648',4904269,'2519','382',44685.17,45398.03,0.00,0.00,712.86,527516.40,0.00,0.00,0.00),('1','143','865','257649',4904270,'2516','382',46138.62,46911.93,0.00,0.00,773.31,572249.40,0.00,0.00,0.00),('1','143','866','257649',4904271,'2517','382',32446.57,33008.97,0.00,0.00,562.40,391430.40,0.00,0.00,0.00),('1','143','865','257649',4904272,'2518','382',37219.06,37219.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257649',4904273,'2519','382',45398.03,46265.50,0.00,0.00,867.47,641927.80,0.00,0.00,0.00),('1','143','865','257650',4904274,'2516','382',46911.93,46911.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257650',4904275,'2517','382',33008.97,33307.47,0.00,0.00,298.50,207756.00,0.00,0.00,0.00),('1','143','865','257650',4904276,'2518','382',37219.06,37713.42,0.00,0.00,494.36,365826.40,0.00,0.00,0.00),('1','143','866','257650',4904277,'2519','382',46265.50,47060.15,0.00,0.00,794.65,588041.00,0.00,0.00,0.00),('1','143','865','257651',4904278,'2516','382',46911.93,47494.95,0.00,0.00,583.02,431434.80,0.00,0.00,0.00),('1','143','866','257651',4904279,'2517','382',33307.47,33736.21,0.00,0.00,428.74,298403.04,0.00,0.00,0.00),('1','143','865','257651',4904280,'2518','382',37713.42,38222.59,0.00,0.00,509.17,376785.80,0.00,0.00,0.00),('1','143','866','257651',4904281,'2519','382',47060.15,47060.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257652',4904282,'2516','382',47494.95,48243.58,0.00,0.00,748.63,576445.10,0.00,0.00,0.00),('1','143','866','257652',4904283,'2517','382',33736.21,33736.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257652',4904284,'2518','382',38222.59,38837.17,0.00,0.00,614.58,473226.60,0.00,0.00,0.00),('1','143','866','257652',4904285,'2519','382',47060.15,47060.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257653',4904286,'2516','382',48243.58,48852.31,0.00,0.00,608.73,468722.10,0.00,0.00,0.00),('1','143','866','257653',4904287,'2517','382',33736.21,34299.73,0.00,0.00,563.52,405910.40,0.00,0.00,0.00),('1','143','865','257653',4904288,'2518','382',38837.17,39453.59,0.00,0.00,616.42,474643.40,0.00,0.00,0.00),('1','143','866','257653',4904289,'2519','382',47060.15,47060.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257654',4904290,'2516','382',48852.31,49500.57,0.00,0.00,648.26,499160.20,0.00,0.00,0.00),('1','143','866','257654',4904291,'2517','382',34299.73,34481.00,0.00,0.00,181.27,130514.40,0.00,0.00,0.00),('1','143','865','257654',4904292,'2518','382',39453.59,39953.13,0.00,0.00,499.54,384645.80,0.00,0.00,0.00),('1','143','866','257654',4904293,'2519','382',47060.15,47060.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257655',4904294,'2516','382',49500.57,49808.61,0.00,0.00,308.04,237190.80,0.00,0.00,0.00),('1','143','866','257655',4904295,'2517','382',34481.00,34751.45,0.00,0.00,270.45,194724.00,0.00,0.00,0.00),('1','143','865','257655',4904296,'2518','382',39953.13,40209.86,0.00,0.00,256.73,197682.10,0.00,0.00,0.00),('1','143','866','257655',4904297,'2519','382',47060.15,47060.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257656',4904298,'2516','382',49808.61,49909.20,0.00,0.00,100.59,77454.30,0.00,0.00,0.00),('1','143','866','257656',4904299,'2517','382',34751.45,35051.45,0.00,0.00,300.00,216000.00,0.00,0.00,0.00),('1','143','865','257656',4904300,'2518','382',40209.86,40393.25,0.00,0.00,183.39,141210.30,0.00,0.00,0.00),('1','143','866','257656',4904301,'2519','382',47060.15,47060.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257657',4904302,'2516','382',49909.20,50641.39,0.00,0.00,732.19,563786.30,0.00,0.00,0.00),('1','143','865','257657',4904303,'2518','382',40393.25,40891.75,0.00,0.00,498.50,383845.00,0.00,0.00,0.00),('1','143','866','257657',4904304,'2519','382',47060.15,47060.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257657',4904305,'2517','382',35051.45,35280.45,0.00,0.00,229.00,164880.00,0.00,0.00,0.00),('1','143','865','257658',4904306,'2516','382',50641.39,51347.13,0.00,0.00,705.74,543419.80,0.00,0.00,0.00),('1','143','866','257658',4904307,'2517','382',35280.45,35504.45,0.00,0.00,224.00,161280.00,0.00,0.00,0.00),('1','143','865','257658',4904308,'2518','382',40891.75,41381.34,0.00,0.00,489.59,376984.30,0.00,0.00,0.00),('1','143','866','257658',4904309,'2519','382',47060.15,47060.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257659',4904310,'2516','382',51347.13,51767.11,0.00,0.00,419.98,323384.60,0.00,0.00,0.00),('1','143','866','257659',4904311,'2517','382',35504.45,35504.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257659',4904312,'2518','382',41381.34,41381.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257659',4904313,'2519','382',47060.15,47354.01,0.00,0.00,293.86,226272.20,0.00,0.00,0.00),('1','143','865','257660',4904314,'2516','382',51767.11,52113.54,0.00,0.00,346.43,266751.10,0.00,0.00,0.00),('1','143','866','257660',4904315,'2517','382',35504.45,35992.45,0.00,0.00,488.00,351360.00,0.00,0.00,0.00),('1','143','865','257660',4904316,'2518','382',41381.34,41381.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257660',4904317,'2519','382',47354.01,47500.89,0.00,0.00,146.88,113097.60,0.00,0.00,0.00),('1','143','865','257661',4904318,'2516','382',52113.54,52113.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257661',4904319,'2517','382',35992.45,36052.45,0.00,0.00,60.00,43200.00,0.00,0.00,0.00),('1','143','865','257661',4904320,'2518','382',41381.34,42119.34,0.00,0.00,738.00,568260.00,0.00,0.00,0.00),('1','143','866','257661',4904321,'2519','382',47500.89,48144.06,0.00,0.00,643.17,495240.90,0.00,0.00,0.00),('1','143','865','257662',4904322,'2516','382',52113.54,52889.54,0.00,0.00,776.00,597520.00,0.00,0.00,0.00),('1','143','866','257662',4904323,'2517','382',36052.45,36432.45,0.00,0.00,380.00,273600.00,0.00,0.00,0.00),('1','143','865','257662',4904324,'2518','382',42119.34,42119.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257662',4904325,'2519','382',48144.06,48749.59,0.00,0.00,605.53,466258.10,0.00,0.00,0.00),('1','143','865','257663',4904326,'2516','382',52889.54,53758.21,0.00,0.00,868.67,668875.90,0.00,0.00,0.00),('1','143','866','257663',4904327,'2517','382',36432.45,36462.45,0.00,0.00,30.00,21600.00,0.00,0.00,0.00),('1','143','865','257663',4904328,'2518','382',42119.34,42689.19,0.00,0.00,569.85,438784.50,0.00,0.00,0.00),('1','143','866','257663',4904329,'2519','382',48749.59,48754.59,0.00,0.00,5.00,3850.00,0.00,0.00,0.00),('1','143','865','257664',4904330,'2516','382',53758.21,53758.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257664',4904331,'2517','382',36462.45,36843.45,0.00,0.00,381.00,274320.00,0.00,0.00,0.00),('1','143','865','257664',4904332,'2518','382',42689.19,43318.85,0.00,0.00,629.66,484838.20,0.00,0.00,0.00),('1','143','866','257664',4904333,'2519','382',48754.59,49551.84,0.00,0.00,797.25,613882.50,0.00,0.00,0.00),('1','143','865','257665',4904334,'2516','382',53758.21,54347.65,0.00,0.00,589.44,453868.80,0.00,0.00,0.00),('1','143','866','257665',4904335,'2517','382',36843.45,36843.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257665',4904336,'2518','382',43318.85,43318.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257665',4904337,'2519','382',49551.84,50388.67,0.00,0.00,836.83,644359.10,0.00,0.00,0.00),('1','143','865','257666',4904338,'2516','382',54347.65,55107.00,0.00,0.00,759.35,584699.50,0.00,0.00,0.00),('1','143','866','257666',4904339,'2517','382',36843.45,37093.45,0.00,0.00,250.00,180000.00,0.00,0.00,0.00),('1','143','865','257666',4904340,'2518','382',43318.85,43726.86,0.00,0.00,408.01,314167.70,0.00,0.00,0.00),('1','143','866','257666',4904341,'2519','382',50388.67,50388.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257667',4904342,'2516','382',55107.00,55697.86,0.00,0.00,590.86,454962.20,0.00,0.00,0.00),('1','143','866','257667',4904343,'2517','382',37093.45,37263.45,0.00,0.00,170.00,122400.00,0.00,0.00,0.00),('1','143','865','257667',4904344,'2518','382',43726.86,43726.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257667',4904345,'2519','382',50388.67,51062.09,0.00,0.00,673.42,518533.40,0.00,0.00,0.00),('1','143','865','257668',4904346,'2516','382',55697.86,55851.93,0.00,0.00,154.07,118633.90,0.00,0.00,0.00),('1','143','866','257668',4904347,'2517','382',37263.45,37263.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257668',4904348,'2518','382',43726.86,43726.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257668',4904349,'2519','382',51062.09,51158.56,0.00,0.00,96.47,74281.90,0.00,0.00,0.00),('1','143','865','257669',4904350,'2516','382',55851.93,55870.43,0.00,0.00,18.50,14245.00,0.00,0.00,0.00),('1','143','866','257669',4904351,'2517','382',37263.45,37665.95,0.00,0.00,402.50,289800.00,0.00,0.00,0.00),('1','143','865','257669',4904352,'2518','382',43726.86,44422.85,0.00,0.00,695.99,535912.30,0.00,0.00,0.00),('1','143','866','257669',4904353,'2519','382',51158.56,51458.10,0.00,0.00,299.54,230645.80,0.00,0.00,0.00),('1','143','865','257670',4904354,'2516','382',55870.43,56734.63,0.00,0.00,864.20,665434.00,0.00,0.00,0.00),('1','143','866','257670',4904355,'2517','382',37665.95,38256.45,0.00,0.00,590.50,425160.00,0.00,0.00,0.00),('1','143','865','257670',4904356,'2518','382',44422.85,44422.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257670',4904357,'2519','382',51458.10,51996.32,0.00,0.00,538.22,414429.40,0.00,0.00,0.00),('1','143','865','257671',4904358,'2516','382',56734.63,57231.15,0.00,0.00,496.52,382320.40,0.00,0.00,0.00),('1','143','866','257671',4904359,'2517','382',38256.45,38676.95,0.00,0.00,420.50,302760.00,0.00,0.00,0.00),('1','143','865','257671',4904360,'2518','382',44422.85,44422.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257671',4904361,'2519','382',51996.32,52629.55,0.00,0.00,633.23,487587.10,0.00,0.00,0.00),('1','143','865','257672',4904362,'2516','382',57231.15,57802.47,0.00,0.00,571.32,439916.40,0.00,0.00,0.00),('1','143','866','257672',4904363,'2517','382',38676.95,39026.95,0.00,0.00,350.00,252000.00,0.00,0.00,0.00),('1','143','865','257672',4904364,'2518','382',44422.85,44422.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257672',4904365,'2519','382',52629.55,53102.82,0.00,0.00,473.27,364417.90,0.00,0.00,0.00),('1','143','865','257673',4904366,'2516','382',57802.47,58424.83,0.00,0.00,622.36,479217.20,0.00,0.00,0.00),('1','143','866','257673',4904367,'2517','382',39026.95,39519.95,0.00,0.00,493.00,354960.00,0.00,0.00,0.00),('1','143','865','257673',4904368,'2518','382',44422.85,45016.07,0.00,0.00,593.22,456779.40,0.00,0.00,0.00),('1','143','866','257673',4904369,'2519','382',53102.82,53102.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257674',4904370,'2516','382',58424.83,59072.69,0.00,0.00,647.86,498852.20,0.00,0.00,0.00),('1','143','866','257674',4904371,'2517','382',39519.95,40035.01,0.00,0.00,515.06,370843.20,0.00,0.00,0.00),('1','143','865','257674',4904372,'2518','382',45016.07,45680.37,0.00,0.00,664.30,511511.00,0.00,0.00,0.00),('1','143','866','257674',4904373,'2519','382',53102.82,53102.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257675',4904374,'2516','382',59072.69,59836.24,0.00,0.00,763.55,587933.50,0.00,0.00,0.00),('1','143','866','257675',4904375,'2517','382',40035.01,40556.67,0.00,0.00,521.66,375595.20,0.00,0.00,0.00),('1','143','865','257675',4904376,'2518','382',45680.37,45680.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257675',4904377,'2519','382',53102.82,53896.80,0.00,0.00,793.98,611364.60,0.00,0.00,0.00),('1','143','865','257676',4904378,'2516','382',59836.24,59836.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257676',4904379,'2517','382',40556.67,41072.67,0.00,0.00,516.00,371520.00,0.00,0.00,0.00),('1','143','865','257676',4904380,'2518','382',45680.37,46268.48,0.00,0.00,588.11,452844.70,0.00,0.00,0.00),('1','143','866','257676',4904381,'2519','382',53896.80,54566.04,0.00,0.00,669.24,515314.80,0.00,0.00,0.00),('1','143','865','257677',4904382,'2516','382',59836.24,60507.54,0.00,0.00,671.30,516901.00,0.00,0.00,0.00),('1','143','866','257677',4904383,'2517','382',41072.67,41716.97,0.00,0.00,644.30,463896.00,0.00,0.00,0.00),('1','143','865','257677',4904384,'2518','382',46268.48,46984.49,0.00,0.00,716.01,551327.70,0.00,0.00,0.00),('1','143','866','257677',4904385,'2519','382',54566.04,54566.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257678',4904386,'2516','382',60507.54,60507.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257678',4904387,'2517','382',41716.97,42248.37,0.00,0.00,531.40,382608.00,0.00,0.00,0.00),('1','143','865','257678',4904388,'2518','382',46984.49,47733.09,0.00,0.00,748.60,576422.00,0.00,0.00,0.00),('1','143','866','257678',4904389,'2519','382',54566.04,55215.75,0.00,0.00,649.71,500276.70,0.00,0.00,0.00),('1','143','865','257679',4904390,'2516','382',60507.54,61484.68,0.00,0.00,977.14,752397.80,0.00,0.00,0.00),('1','143','866','257679',4904391,'2517','382',42248.37,42510.37,0.00,0.00,262.00,188640.00,0.00,0.00,0.00),('1','143','865','257679',4904392,'2518','382',47733.09,47733.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257679',4904393,'2519','382',55215.75,56221.85,0.00,0.00,1006.10,774697.00,0.00,0.00,0.00),('1','143','865','257680',4904394,'2516','382',61484.68,62754.73,0.00,0.00,1270.05,977938.50,0.00,0.00,0.00),('1','143','866','257680',4904395,'2517','382',42510.37,42908.01,0.00,0.00,397.64,286300.80,0.00,0.00,0.00),('1','143','865','257680',4904396,'2518','382',47733.09,48741.14,0.00,0.00,1008.05,776198.50,0.00,0.00,0.00),('1','143','866','257680',4904397,'2519','382',56221.85,56221.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257681',4904398,'2516','382',62754.73,64159.25,0.00,0.00,1404.52,1081480.40,0.00,0.00,0.00),('1','143','866','257681',4904399,'2517','382',42908.01,43127.01,0.00,0.00,219.00,157680.00,0.00,0.00,0.00),('1','143','865','257681',4904400,'2518','382',48741.14,49789.97,0.00,0.00,1048.83,807599.10,0.00,0.00,0.00),('1','143','866','257681',4904401,'2519','382',56221.85,56221.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257682',4904402,'2516','382',64159.25,64159.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257682',4904403,'2517','382',43127.01,44198.51,0.00,0.00,1071.50,771480.00,0.00,0.00,0.00),('1','143','865','257682',4904404,'2518','382',49789.97,50873.09,0.00,0.00,1083.12,834002.40,0.00,0.00,0.00),('1','143','866','257682',4904405,'2519','382',56221.85,57285.55,0.00,0.00,1063.70,819049.00,0.00,0.00,0.00),('1','143','865','257683',4904406,'2516','382',64159.25,65386.36,0.00,0.00,1227.11,944874.70,0.00,0.00,0.00),('1','143','866','257683',4904407,'2517','382',44198.51,44723.90,0.00,0.00,525.39,378280.80,0.00,0.00,0.00),('1','143','865','257683',4904408,'2518','382',50873.09,50873.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257683',4904409,'2519','382',57285.55,58306.44,0.00,0.00,1020.89,786085.30,0.00,0.00,0.00),('1','143','865','257684',4904410,'2516','382',65386.36,65386.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257684',4904411,'2517','382',44723.90,45350.90,0.00,0.00,627.00,451440.00,0.00,0.00,0.00),('1','143','865','257684',4904412,'2518','382',50873.09,50873.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257684',4904413,'2519','382',58306.44,58635.19,0.00,0.00,328.75,253137.50,0.00,0.00,0.00),('1','143','865','257685',4904414,'2516','382',65386.36,65649.80,0.00,0.00,263.44,202848.80,0.00,0.00,0.00),('1','143','866','257685',4904415,'2517','382',45350.90,45809.31,0.00,0.00,458.41,330055.20,0.00,0.00,0.00),('1','143','865','257685',4904416,'2518','382',50873.09,50873.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257685',4904417,'2519','382',58635.19,58821.46,0.00,0.00,186.27,143427.90,0.00,0.00,0.00),('1','143','865','257686',4904418,'2516','382',65649.80,65649.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257686',4904419,'2517','382',45809.31,46376.31,0.00,0.00,567.00,408240.00,0.00,0.00,0.00),('1','143','865','257686',4904420,'2518','382',50873.09,51146.85,0.00,0.00,273.76,210795.20,0.00,0.00,0.00),('1','143','866','257686',4904421,'2519','382',58821.46,59176.48,0.00,0.00,355.02,273365.40,0.00,0.00,0.00),('1','143','865','257687',4904422,'2516','382',65649.80,65794.25,0.00,0.00,144.45,111226.50,0.00,0.00,0.00),('1','143','866','257687',4904423,'2517','382',46376.31,46979.53,0.00,0.00,603.22,434318.40,0.00,0.00,0.00),('1','143','865','257687',4904424,'2518','382',51146.85,51397.82,0.00,0.00,250.97,193246.90,0.00,0.00,0.00),('1','143','866','257687',4904425,'2519','382',59176.48,59398.62,0.00,0.00,222.14,171047.80,0.00,0.00,0.00),('1','143','865','257688',4904426,'2516','382',65794.25,65794.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257688',4904427,'2517','382',46979.53,47572.23,0.00,0.00,592.70,426744.00,0.00,0.00,0.00),('1','143','865','257688',4904428,'2518','382',51397.82,51442.81,0.00,0.00,44.99,34642.30,0.00,0.00,0.00),('1','143','866','257688',4904429,'2519','382',59398.62,59996.70,0.00,0.00,598.08,460521.60,0.00,0.00,0.00),('1','143','865','257689',4904430,'2516','382',65794.25,65969.40,0.00,0.00,175.15,134865.50,0.00,0.00,0.00),('1','143','866','257689',4904431,'2517','382',47572.23,47785.26,0.00,0.00,213.03,153381.60,0.00,0.00,0.00),('1','143','865','257689',4904432,'2518','382',51442.81,51442.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257689',4904433,'2519','382',59996.70,60310.03,0.00,0.00,313.33,241264.10,0.00,0.00,0.00),('1','143','865','257690',4904434,'2516','382',65969.40,66081.34,0.00,0.00,111.94,86193.80,0.00,0.00,0.00),('1','143','866','257690',4904435,'2517','382',47785.26,47936.26,0.00,0.00,151.00,108720.00,0.00,0.00,0.00),('1','143','865','257690',4904436,'2518','382',51442.81,51442.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257690',4904437,'2519','382',60310.03,60422.57,0.00,0.00,112.54,86655.80,0.00,0.00,0.00),('1','143','865','257691',4904438,'2516','382',66081.34,66081.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257691',4904439,'2517','382',47936.26,48551.26,0.00,0.00,615.00,442800.00,0.00,0.00,0.00),('1','143','865','257691',4904440,'2518','382',51442.81,51657.18,0.00,0.00,214.37,165064.90,0.00,0.00,0.00),('1','143','866','257691',4904441,'2519','382',60422.57,60893.79,0.00,0.00,471.22,362839.40,0.00,0.00,0.00),('1','143','865','257692',4904442,'2516','382',66081.34,66345.63,0.00,0.00,264.29,203503.30,0.00,0.00,0.00),('1','143','866','257692',4904443,'2517','382',48551.26,48871.69,0.00,0.00,320.43,230709.60,0.00,0.00,0.00),('1','143','865','257692',4904444,'2518','382',51657.18,51657.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257692',4904445,'2519','382',60893.79,61272.69,0.00,0.00,378.90,291753.00,0.00,0.00,0.00),('1','143','865','257693',4904446,'2516','382',66345.63,66345.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257693',4904447,'2517','382',48871.69,49309.19,0.00,0.00,437.50,315000.00,0.00,0.00,0.00),('1','143','865','257693',4904448,'2518','382',51657.18,52003.44,0.00,0.00,346.26,266620.20,0.00,0.00,0.00),('1','143','866','257693',4904449,'2519','382',61272.69,61748.68,0.00,0.00,475.99,366512.30,0.00,0.00,0.00),('1','143','865','257694',4904450,'2516','382',66345.63,66803.09,0.00,0.00,457.46,352244.20,0.00,0.00,0.00),('1','143','866','257694',4904451,'2517','382',49309.19,49585.19,0.00,0.00,276.00,198720.00,0.00,0.00,0.00),('1','143','865','257694',4904452,'2518','382',52003.44,52003.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257694',4904453,'2519','382',61748.68,62147.26,0.00,0.00,398.58,306906.60,0.00,0.00,0.00),('1','143','865','257695',4904454,'2516','382',66803.09,67391.12,0.00,0.00,588.03,452783.10,0.00,0.00,0.00),('1','143','866','257695',4904455,'2517','382',49585.19,49685.19,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','143','865','257695',4904456,'2518','382',52003.44,52823.13,0.00,0.00,819.69,631161.30,0.00,0.00,0.00),('1','143','866','257695',4904457,'2519','382',62147.26,62147.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257696',4904458,'2516','382',67391.12,67391.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257696',4904459,'2517','382',49685.19,50083.69,0.00,0.00,398.50,286920.00,0.00,0.00,0.00),('1','143','865','257696',4904460,'2518','382',52823.13,53367.52,0.00,0.00,544.39,419180.30,0.00,0.00,0.00),('1','143','866','257696',4904461,'2519','382',62147.26,62695.68,0.00,0.00,548.42,422283.40,0.00,0.00,0.00),('1','143','865','257697',4904462,'2516','382',67391.12,68143.24,0.00,0.00,752.12,579132.40,0.00,0.00,0.00),('1','143','866','257697',4904463,'2517','382',50083.69,50264.69,0.00,0.00,181.00,130320.00,0.00,0.00,0.00),('1','143','865','257697',4904464,'2518','382',53367.52,53911.52,0.00,0.00,544.00,418880.00,0.00,0.00,0.00),('1','143','866','257697',4904465,'2519','382',62695.68,62695.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257698',4904466,'2516','382',68143.24,68401.83,0.00,0.00,258.59,199114.30,0.00,0.00,0.00),('1','143','866','257698',4904467,'2517','382',50264.69,50452.69,0.00,0.00,188.00,135360.00,0.00,0.00,0.00),('1','143','865','257698',4904468,'2518','382',53911.52,53911.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257698',4904469,'2519','382',62695.68,63639.59,0.00,0.00,943.91,726810.70,0.00,0.00,0.00),('1','143','865','257699',4904470,'2516','382',68401.83,68401.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257699',4904471,'2517','382',50452.69,50502.69,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','143','865','257699',4904472,'2518','382',53911.52,53919.52,0.00,0.00,8.00,6160.00,0.00,0.00,0.00),('1','143','866','257699',4904473,'2519','382',63639.59,64910.87,0.00,0.00,1271.28,978885.60,0.00,0.00,0.00),('1','143','865','257700',4904474,'2516','382',68401.83,68401.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257700',4904475,'2517','382',50502.69,50502.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257700',4904476,'2518','382',53919.52,53919.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257700',4904477,'2519','382',64910.87,66206.94,0.00,0.00,1296.07,997973.90,0.00,0.00,0.00),('1','143','865','257701',4904478,'2516','382',68401.83,68401.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257701',4904479,'2517','382',50502.69,50602.69,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','143','865','257701',4904480,'2518','382',53919.52,53919.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257701',4904481,'2519','382',66206.94,67441.07,0.00,0.00,1234.13,950280.10,0.00,0.00,0.00),('1','143','865','257702',4904482,'2516','382',68401.83,68401.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257702',4904483,'2517','382',50602.69,50602.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257702',4904484,'2518','382',53919.52,54549.82,0.00,0.00,630.30,485331.00,0.00,0.00,0.00),('1','143','866','257702',4904485,'2519','382',67441.07,68491.29,0.00,0.00,1050.22,808669.40,0.00,0.00,0.00),('1','143','865','257703',4904486,'2516','382',68401.83,69037.58,0.00,0.00,635.75,489527.50,0.00,0.00,0.00),('1','143','866','257703',4904487,'2517','382',50602.69,50652.69,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','143','865','257703',4904488,'2518','382',54549.82,55173.64,0.00,0.00,623.82,480341.40,0.00,0.00,0.00),('1','143','866','257703',4904489,'2519','382',68491.29,68491.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257704',4904490,'2516','382',69037.58,69037.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257704',4904491,'2518','382',55173.64,55669.84,0.00,0.00,496.20,382074.00,0.00,0.00,0.00),('1','143','866','257704',4904492,'2519','382',68491.29,68936.78,0.00,0.00,445.49,343027.30,0.00,0.00,0.00),('1','143','866','257704',4904493,'2517','382',50652.69,50652.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257705',4904494,'2516','382',69037.58,69037.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257705',4904495,'2517','382',50652.69,50652.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257705',4904496,'2518','382',55669.84,55790.84,0.00,0.00,121.00,93170.00,0.00,0.00,0.00),('1','143','866','257705',4904497,'2519','382',68936.78,69112.99,0.00,0.00,176.21,135681.70,0.00,0.00,0.00),('1','143','865','257706',4904498,'2516','382',69037.58,69037.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257706',4904499,'2518','382',55790.84,56644.60,0.00,0.00,853.76,657395.20,0.00,0.00,0.00),('1','143','866','257706',4904500,'2519','382',69112.99,69790.31,0.00,0.00,677.32,521536.40,0.00,0.00,0.00),('1','143','866','257706',4904501,'2517','382',50652.69,50742.69,0.00,0.00,90.00,64800.00,0.00,0.00,0.00),('1','143','865','257707',4904502,'2516','382',69037.58,69793.23,0.00,0.00,755.65,581850.50,0.00,0.00,0.00),('1','143','866','257707',4904503,'2517','382',50742.69,50800.19,0.00,0.00,57.50,41400.00,0.00,0.00,0.00),('1','143','865','257707',4904504,'2518','382',56644.60,56644.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257707',4904505,'2519','382',69790.31,70494.72,0.00,0.00,704.41,542395.70,0.00,0.00,0.00),('1','143','865','257708',4904506,'2516','382',69793.23,69793.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257708',4904507,'2517','382',50800.19,50800.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257708',4904508,'2518','382',56644.60,56644.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257708',4904509,'2519','382',70494.72,70494.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257709',4904510,'2516','382',69793.23,70565.98,0.00,0.00,772.75,595017.50,0.00,0.00,0.00),('1','143','866','257709',4904511,'2517','382',50800.19,50800.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257709',4904512,'2518','382',56644.60,56644.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257709',4904513,'2519','382',70494.72,71378.49,0.00,0.00,883.77,680502.90,0.00,0.00,0.00),('1','143','865','257710',4904514,'2516','382',70565.98,71280.67,0.00,0.00,714.69,550311.30,0.00,0.00,0.00),('1','143','866','257710',4904515,'2517','382',50800.19,50800.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257710',4904516,'2518','382',56644.60,56644.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257710',4904517,'2519','382',71378.49,72560.02,0.00,0.00,1181.53,909778.10,0.00,0.00,0.00),('1','143','865','257711',4904518,'2516','382',71280.67,71280.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257711',4904519,'2517','382',50800.19,50800.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257711',4904520,'2518','382',56644.60,57494.54,0.00,0.00,849.94,654453.80,0.00,0.00,0.00),('1','143','866','257711',4904521,'2519','382',72560.02,73406.81,0.00,0.00,846.79,652028.30,0.00,0.00,0.00),('1','143','865','257712',4904522,'2516','382',71280.67,71971.23,0.00,0.00,690.56,531731.20,0.00,0.00,0.00),('1','143','866','257712',4904523,'2517','382',50800.19,50800.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257712',4904524,'2518','382',57494.54,57494.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257712',4904525,'2519','382',73406.81,74458.94,0.00,0.00,1052.13,810140.10,0.00,0.00,0.00),('1','143','865','257713',4904526,'2516','382',71971.23,72827.73,0.00,0.00,856.50,659505.00,0.00,0.00,0.00),('1','143','866','257713',4904527,'2517','382',50800.19,50800.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257713',4904528,'2518','382',57494.54,58403.38,0.00,0.00,908.84,699806.80,0.00,0.00,0.00),('1','143','866','257713',4904529,'2519','382',74458.94,74458.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257714',4904530,'2516','382',72827.73,73952.19,0.00,0.00,1124.46,865834.20,0.00,0.00,0.00),('1','143','866','257714',4904531,'2517','382',50800.19,50800.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257714',4904532,'2518','382',58403.38,58403.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257714',4904533,'2519','382',74458.94,75422.55,0.00,0.00,963.61,741979.70,0.00,0.00,0.00),('1','143','865','257715',4904534,'2516','382',73952.19,73952.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257715',4904535,'2517','382',50800.19,50850.19,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','143','865','257715',4904536,'2518','382',58403.38,59548.80,0.00,0.00,1145.42,881973.40,0.00,0.00,0.00),('1','143','866','257715',4904537,'2519','382',75422.55,76450.82,0.00,0.00,1028.27,791767.90,0.00,0.00,0.00),('1','143','865','257716',4904538,'2516','382',73952.19,74962.95,0.00,0.00,1010.76,778285.20,0.00,0.00,0.00),('1','143','866','257716',4904539,'2517','382',50850.19,50950.19,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','143','865','257716',4904540,'2518','382',59548.80,59548.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257716',4904541,'2519','382',76450.82,77364.95,0.00,0.00,914.13,703880.10,0.00,0.00,0.00),('1','143','865','257717',4904542,'2516','382',74962.95,75788.14,0.00,0.00,825.19,635396.30,0.00,0.00,0.00),('1','143','866','257717',4904543,'2517','382',50950.19,50950.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257717',4904544,'2518','382',59548.80,59548.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257717',4904545,'2519','382',77364.95,78173.38,0.00,0.00,808.43,622491.10,0.00,0.00,0.00),('1','143','865','257718',4904546,'2516','382',75788.14,75788.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257718',4904547,'2517','382',50950.19,50950.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257718',4904548,'2518','382',59548.80,60589.40,0.00,0.00,1040.60,801262.00,0.00,0.00,0.00),('1','143','866','257718',4904549,'2519','382',78173.38,79145.53,0.00,0.00,972.15,748555.50,0.00,0.00,0.00),('1','143','865','257719',4904550,'2516','382',75788.14,76485.49,0.00,0.00,697.35,536959.50,0.00,0.00,0.00),('1','143','866','257719',4904551,'2517','382',50950.19,50950.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257719',4904552,'2518','382',60589.40,60589.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257719',4904553,'2519','382',79145.53,79874.37,0.00,0.00,728.84,561206.80,0.00,0.00,0.00),('1','143','865','257720',4904554,'2516','382',76485.49,76485.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257720',4904555,'2517','382',50950.19,51195.69,0.00,0.00,245.50,176760.00,0.00,0.00,0.00),('1','143','865','257720',4904556,'2518','382',60589.40,61434.05,0.00,0.00,844.65,650380.50,0.00,0.00,0.00),('1','143','866','257720',4904557,'2519','382',79874.37,80626.67,0.00,0.00,752.30,579271.00,0.00,0.00,0.00),('1','143','865','257721',4904558,'2516','382',76485.49,77372.36,0.00,0.00,886.87,682889.90,0.00,0.00,0.00),('1','143','866','257721',4904559,'2517','382',51195.69,51219.69,0.00,0.00,24.00,17280.00,0.00,0.00,0.00),('1','143','865','257721',4904560,'2518','382',61434.05,61434.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257721',4904561,'2519','382',80626.67,81193.47,0.00,0.00,566.80,436436.00,0.00,0.00,0.00),('1','143','865','257722',4904562,'2516','382',77372.36,78337.18,0.00,0.00,964.82,742911.40,0.00,0.00,0.00),('1','143','866','257722',4904563,'2517','382',51219.69,51219.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257722',4904564,'2518','382',61434.05,61434.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257722',4904565,'2519','382',81193.47,82119.26,0.00,0.00,925.79,712858.30,0.00,0.00,0.00),('1','143','865','257723',4904566,'2516','382',78337.18,78357.44,0.00,0.00,20.26,15600.20,0.00,0.00,0.00),('1','143','866','257723',4904567,'2517','382',51219.69,51277.19,0.00,0.00,57.50,41400.00,0.00,0.00,0.00),('1','143','865','257723',4904568,'2518','382',61434.05,62187.82,0.00,0.00,753.77,580402.90,0.00,0.00,0.00),('1','143','866','257723',4904569,'2519','382',82119.26,82878.42,0.00,0.00,759.16,584553.20,0.00,0.00,0.00),('1','143','865','257724',4904570,'2516','382',78357.44,79218.60,0.00,0.00,861.16,663093.20,0.00,0.00,0.00),('1','143','866','257724',4904571,'2517','382',51277.19,51427.19,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','143','865','257724',4904572,'2518','382',62187.82,62187.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257724',4904573,'2519','382',82878.42,83623.71,0.00,0.00,745.29,573873.30,0.00,0.00,0.00),('1','143','865','257725',4904574,'2516','382',79218.60,79218.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257725',4904575,'2517','382',51427.19,51427.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257725',4904576,'2518','382',62187.82,63167.25,0.00,0.00,979.43,754161.10,0.00,0.00,0.00),('1','143','866','257725',4904577,'2519','382',83623.71,84507.06,0.00,0.00,883.35,680179.50,0.00,0.00,0.00),('1','143','865','257726',4904578,'2516','382',79218.60,80251.51,0.00,0.00,1032.91,795340.70,0.00,0.00,0.00),('1','143','866','257726',4904579,'2517','382',51427.19,51477.19,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','143','865','257726',4904580,'2518','382',63167.25,64270.54,0.00,0.00,1103.29,849533.30,0.00,0.00,0.00),('1','143','866','257726',4904581,'2519','382',84507.06,84507.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257727',4904582,'2516','382',80251.51,80845.18,0.00,0.00,593.67,457125.90,0.00,0.00,0.00),('1','143','866','257727',4904583,'2517','382',51477.19,51477.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257727',4904584,'2518','382',64270.54,64970.31,0.00,0.00,699.77,538822.90,0.00,0.00,0.00),('1','143','866','257727',4904585,'2519','382',84507.06,84507.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257728',4904586,'2516','382',80845.18,80903.68,0.00,0.00,58.50,45045.00,0.00,0.00,0.00),('1','143','866','257728',4904587,'2517','382',51477.19,51477.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257728',4904588,'2518','382',64970.31,64980.71,0.00,0.00,10.40,8008.00,0.00,0.00,0.00),('1','143','866','257728',4904589,'2519','382',84507.06,84507.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257729',4904590,'2516','382',80903.68,81426.15,0.00,0.00,522.47,402301.90,0.00,0.00,0.00),('1','143','866','257729',4904591,'2517','382',51477.19,51577.19,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','143','865','257729',4904592,'2518','382',64980.71,65398.88,0.00,0.00,418.17,321990.90,0.00,0.00,0.00),('1','143','866','257729',4904593,'2519','382',84507.06,84507.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257730',4904594,'2516','382',81426.15,81987.04,0.00,0.00,560.89,431885.30,0.00,0.00,0.00),('1','143','866','257730',4904595,'2517','382',51577.19,51727.43,0.00,0.00,150.24,108172.80,0.00,0.00,0.00),('1','143','865','257730',4904596,'2518','382',65398.88,65398.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257730',4904597,'2519','382',84507.06,85492.61,0.00,0.00,985.55,758873.50,0.00,0.00,0.00),('1','143','865','257731',4904598,'2516','382',81987.04,81987.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257731',4904599,'2517','382',51727.43,51784.93,0.00,0.00,57.50,41400.00,0.00,0.00,0.00),('1','143','865','257731',4904600,'2518','382',65398.88,66024.53,0.00,0.00,625.65,481750.50,0.00,0.00,0.00),('1','143','866','257731',4904601,'2519','382',85492.61,86183.95,0.00,0.00,691.34,532331.80,0.00,0.00,0.00),('1','143','865','257732',4904602,'2516','382',81987.04,81987.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257732',4904603,'2517','382',51784.93,51784.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257732',4904604,'2518','382',66024.53,66604.62,0.00,0.00,580.09,446669.30,0.00,0.00,0.00),('1','143','866','257732',4904605,'2519','382',86183.95,86622.72,0.00,0.00,438.77,337852.90,0.00,0.00,0.00),('1','143','865','257733',4904606,'2516','382',81987.04,81987.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257733',4904607,'2517','382',51784.93,51844.93,0.00,0.00,60.00,43200.00,0.00,0.00,0.00),('1','143','865','257733',4904608,'2518','382',66604.62,67349.57,0.00,0.00,744.95,573611.50,0.00,0.00,0.00),('1','143','866','257733',4904609,'2519','382',86622.72,87122.08,0.00,0.00,499.36,384507.20,0.00,0.00,0.00),('1','143','865','257734',4904610,'2516','382',81987.04,82591.50,0.00,0.00,604.46,465434.20,0.00,0.00,0.00),('1','143','866','257734',4904611,'2517','382',51844.93,51902.93,0.00,0.00,58.00,41760.00,0.00,0.00,0.00),('1','143','865','257734',4904612,'2518','382',67349.57,67349.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257734',4904613,'2519','382',87122.08,87474.15,0.00,0.00,352.07,271093.90,0.00,0.00,0.00),('1','143','865','257735',4904614,'2516','382',82591.50,82591.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257735',4904615,'2517','382',51902.93,51962.93,0.00,0.00,60.00,43200.00,0.00,0.00,0.00),('1','143','865','257735',4904616,'2518','382',67349.57,67853.97,0.00,0.00,504.40,388388.00,0.00,0.00,0.00),('1','143','866','257735',4904617,'2519','382',87474.15,88262.79,0.00,0.00,788.64,607252.80,0.00,0.00,0.00),('1','143','865','257736',4904618,'2516','382',82591.50,82600.40,0.00,0.00,8.90,6853.00,0.00,0.00,0.00),('1','143','866','257736',4904619,'2517','382',51962.93,52358.93,0.00,0.00,396.00,285120.00,0.00,0.00,0.00),('1','143','865','257736',4904620,'2518','382',67853.97,67995.57,0.00,0.00,141.60,109032.00,0.00,0.00,0.00),('1','143','866','257736',4904621,'2519','382',88262.79,89187.65,0.00,0.00,924.86,712142.20,0.00,0.00,0.00),('1','143','865','257737',4904622,'2516','382',82600.40,82600.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257737',4904623,'2517','382',52358.93,52546.93,0.00,0.00,188.00,135360.00,0.00,0.00,0.00),('1','143','865','257737',4904624,'2518','382',67995.57,68416.57,0.00,0.00,421.00,324170.00,0.00,0.00,0.00),('1','143','866','257737',4904625,'2519','382',89187.65,90099.14,0.00,0.00,911.49,701847.30,0.00,0.00,0.00),('1','143','865','257738',4904626,'2516','382',82600.40,82600.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257738',4904627,'2517','382',52546.93,52546.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257738',4904628,'2518','382',68416.57,68472.30,0.00,0.00,55.73,42912.10,0.00,0.00,0.00),('1','143','866','257738',4904629,'2519','382',90099.14,91671.50,0.00,0.00,1572.36,1210717.20,0.00,0.00,0.00),('1','143','865','257739',4904630,'2516','382',82600.40,83191.49,0.00,0.00,591.09,455139.30,0.00,0.00,0.00),('1','143','866','257739',4904631,'2517','382',52546.93,52720.93,0.00,0.00,174.00,125280.00,0.00,0.00,0.00),('1','143','865','257739',4904632,'2518','382',68472.30,68472.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257739',4904633,'2519','382',91671.50,92234.94,0.00,0.00,563.44,433848.80,0.00,0.00,0.00),('1','143','865','257740',4904634,'2516','382',83191.49,83203.83,0.00,0.00,12.34,9501.80,0.00,0.00,0.00),('1','143','866','257740',4904635,'2517','382',52720.93,52836.93,0.00,0.00,116.00,83520.00,0.00,0.00,0.00),('1','143','865','257740',4904636,'2518','382',68472.30,69079.68,0.00,0.00,607.38,467682.60,0.00,0.00,0.00),('1','143','866','257740',4904637,'2519','382',92234.94,93231.16,0.00,0.00,996.22,767089.40,0.00,0.00,0.00),('1','143','865','257741',4904638,'2516','382',83203.83,83598.37,0.00,0.00,394.54,303795.80,0.00,0.00,0.00),('1','143','866','257741',4904639,'2517','382',52836.93,52836.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257741',4904640,'2518','382',69079.68,69557.30,0.00,0.00,477.62,367767.40,0.00,0.00,0.00),('1','143','866','257741',4904641,'2519','382',93231.16,93813.09,0.00,0.00,581.93,448086.10,0.00,0.00,0.00),('1','143','865','257742',4904642,'2516','382',83598.37,83598.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257742',4904643,'2517','382',52836.93,52894.43,0.00,0.00,57.50,41400.00,0.00,0.00,0.00),('1','143','865','257742',4904644,'2518','382',69557.30,70529.39,0.00,0.00,972.09,748509.30,0.00,0.00,0.00),('1','143','866','257742',4904645,'2519','382',93813.09,94901.47,0.00,0.00,1088.38,838052.60,0.00,0.00,0.00),('1','143','865','257743',4904646,'2516','382',83598.37,83715.07,0.00,0.00,116.70,89859.00,0.00,0.00,0.00),('1','143','866','257743',4904647,'2517','382',52894.43,52946.68,0.00,0.00,52.25,37620.00,0.00,0.00,0.00),('1','143','865','257743',4904648,'2518','382',70529.39,70529.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257743',4904649,'2519','382',94901.47,95130.06,0.00,0.00,228.59,176014.30,0.00,0.00,0.00),('1','143','865','257744',4904650,'2516','382',83715.07,84385.09,0.00,0.00,670.02,515915.40,0.00,0.00,0.00),('1','143','866','257744',4904651,'2517','382',52946.68,53047.12,0.00,0.00,100.44,72316.80,0.00,0.00,0.00),('1','143','865','257744',4904652,'2518','382',70529.39,70721.28,0.00,0.00,191.89,147755.30,0.00,0.00,0.00),('1','143','866','257744',4904653,'2519','382',95130.06,95523.13,0.00,0.00,393.07,302663.90,0.00,0.00,0.00),('1','143','865','257745',4904654,'2516','382',84385.09,84385.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257745',4904655,'2517','382',53047.12,53320.10,0.00,0.00,272.98,198394.60,0.00,0.00,0.00),('1','143','865','257745',4904656,'2518','382',70721.28,71785.79,0.00,0.00,1064.51,819672.70,0.00,0.00,0.00),('1','143','866','257745',4904657,'2519','382',95523.13,96574.53,0.00,0.00,1051.40,809578.00,0.00,0.00,0.00),('1','143','865','257746',4904658,'2516','382',84385.09,85506.19,0.00,0.00,1121.10,863247.00,0.00,0.00,0.00),('1','143','866','257746',4904659,'2517','382',53320.10,53332.60,0.00,0.00,12.50,9000.00,0.00,0.00,0.00),('1','143','865','257746',4904660,'2518','382',71785.79,71785.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257746',4904661,'2519','382',96574.53,97385.94,0.00,0.00,811.41,624785.70,0.00,0.00,0.00),('1','143','865','257747',4904662,'2516','382',85506.19,85506.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257747',4904663,'2517','382',53332.60,53450.60,0.00,0.00,118.00,84960.00,0.00,0.00,0.00),('1','143','865','257747',4904664,'2518','382',71785.79,72502.53,0.00,0.00,716.74,551889.80,0.00,0.00,0.00),('1','143','866','257747',4904665,'2519','382',97385.94,97986.39,0.00,0.00,600.45,462346.50,0.00,0.00,0.00),('1','143','865','257748',4904666,'2516','382',85506.19,86250.86,0.00,0.00,744.67,573395.90,0.00,0.00,0.00),('1','143','866','257748',4904667,'2517','382',53450.60,53716.60,0.00,0.00,266.00,191520.00,0.00,0.00,0.00),('1','143','865','257748',4904668,'2518','382',72502.53,72502.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257748',4904669,'2519','382',97986.39,98716.93,0.00,0.00,730.54,562515.80,0.00,0.00,0.00),('1','143','865','257749',4904670,'2516','382',86250.86,86827.59,0.00,0.00,576.73,444082.10,0.00,0.00,0.00),('1','143','866','257749',4904671,'2517','382',53716.60,53774.60,0.00,0.00,58.00,41760.00,0.00,0.00,0.00),('1','143','865','257749',4904672,'2518','382',72502.53,72502.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257749',4904673,'2519','382',98716.93,99332.62,0.00,0.00,615.69,474081.30,0.00,0.00,0.00),('1','143','865','257750',4904674,'2516','382',86827.59,86827.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257750',4904675,'2517','382',53774.60,53950.10,0.00,0.00,175.50,126360.00,0.00,0.00,0.00),('1','143','865','257750',4904676,'2518','382',72502.53,73174.45,0.00,0.00,671.92,517378.40,0.00,0.00,0.00),('1','143','866','257750',4904677,'2519','382',99332.62,100067.13,0.00,0.00,734.51,565572.70,0.00,0.00,0.00),('1','143','865','257751',4904678,'2516','382',86827.59,87529.17,0.00,0.00,701.58,540216.60,0.00,0.00,0.00),('1','143','866','257751',4904679,'2517','382',53950.10,53950.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257751',4904680,'2518','382',73174.45,73174.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257751',4904681,'2519','382',100067.13,100907.57,0.00,0.00,840.44,647138.80,0.00,0.00,0.00),('1','143','865','257752',4904682,'2516','382',87529.17,87529.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257752',4904683,'2517','382',53950.10,53950.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257752',4904684,'2518','382',73174.45,73820.17,0.00,0.00,645.72,497204.40,0.00,0.00,0.00),('1','143','866','257752',4904685,'2519','382',100907.57,101532.33,0.00,0.00,624.76,481065.20,0.00,0.00,0.00),('1','143','865','257753',4904686,'2516','382',87529.17,87529.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257753',4904687,'2517','382',53950.10,54100.10,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','143','865','257753',4904688,'2518','382',73820.17,74546.50,0.00,0.00,726.33,559274.10,0.00,0.00,0.00),('1','143','866','257753',4904689,'2519','382',101532.33,102160.60,0.00,0.00,628.27,483767.90,0.00,0.00,0.00),('1','143','865','257754',4904690,'2516','382',87529.17,88138.71,0.00,0.00,609.54,469345.80,0.00,0.00,0.00),('1','143','866','257754',4904691,'2517','382',54100.10,54155.70,0.00,0.00,55.60,40032.00,0.00,0.00,0.00),('1','143','865','257754',4904692,'2518','382',74546.50,74546.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257754',4904693,'2519','382',102160.60,102790.76,0.00,0.00,630.16,485223.20,0.00,0.00,0.00),('1','143','865','257755',4904694,'2516','382',88138.71,88138.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257755',4904695,'2517','382',54155.70,54155.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257755',4904696,'2518','382',74546.50,75039.89,0.00,0.00,493.39,379910.30,0.00,0.00,0.00),('1','143','866','257755',4904697,'2519','382',102790.76,103281.06,0.00,0.00,490.30,377531.00,0.00,0.00,0.00),('1','143','865','257756',4904698,'2516','382',88138.71,88350.42,0.00,0.00,211.71,163016.70,0.00,0.00,0.00),('1','143','866','257756',4904699,'2517','382',54155.70,54155.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257756',4904700,'2518','382',75039.89,75039.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257756',4904701,'2519','382',103281.06,103511.68,0.00,0.00,230.62,177577.40,0.00,0.00,0.00),('1','143','865','257757',4904702,'2516','382',88350.42,88679.30,0.00,0.00,328.88,253237.60,0.00,0.00,0.00),('1','143','866','257757',4904703,'2517','382',54155.70,54155.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257757',4904704,'2518','382',75039.89,75039.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257757',4904705,'2519','382',103511.68,103851.36,0.00,0.00,339.68,261553.60,0.00,0.00,0.00),('1','143','865','257758',4904706,'2516','382',88679.30,88679.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257758',4904707,'2517','382',54155.70,54343.70,0.00,0.00,188.00,135360.00,0.00,0.00,0.00),('1','143','865','257758',4904708,'2518','382',75039.89,75500.33,0.00,0.00,460.44,354538.80,0.00,0.00,0.00),('1','143','866','257758',4904709,'2519','382',103851.36,104247.01,0.00,0.00,395.65,304650.50,0.00,0.00,0.00),('1','143','865','257759',4904710,'2516','382',88679.30,89292.10,0.00,0.00,612.80,471856.00,0.00,0.00,0.00),('1','143','866','257759',4904711,'2517','382',54343.70,54549.70,0.00,0.00,206.00,148320.00,0.00,0.00,0.00),('1','143','865','257759',4904712,'2518','382',75500.33,75500.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257759',4904713,'2519','382',104247.01,104769.68,0.00,0.00,522.67,402455.90,0.00,0.00,0.00),('1','143','865','257760',4904714,'2516','382',89292.10,89292.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257760',4904715,'2517','382',54549.70,54607.20,0.00,0.00,57.50,41400.00,0.00,0.00,0.00),('1','143','865','257760',4904716,'2518','382',75500.33,76231.23,0.00,0.00,730.90,562793.00,0.00,0.00,0.00),('1','143','866','257760',4904717,'2519','382',104769.68,105403.29,0.00,0.00,633.61,487879.70,0.00,0.00,0.00),('1','143','865','257761',4904718,'2516','382',89292.10,89956.54,0.00,0.00,664.44,511618.80,0.00,0.00,0.00),('1','143','866','257761',4904719,'2517','382',54607.20,54607.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257761',4904720,'2518','382',76231.23,76231.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257761',4904721,'2519','382',105403.29,106155.84,0.00,0.00,752.55,579463.50,0.00,0.00,0.00),('1','143','865','257762',4904722,'2516','382',89956.54,90635.08,0.00,0.00,678.54,522475.80,0.00,0.00,0.00),('1','143','866','257762',4904723,'2517','382',54607.20,54607.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257762',4904724,'2518','382',76231.23,76231.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257762',4904725,'2519','382',106155.84,106721.91,0.00,0.00,566.07,435873.90,0.00,0.00,0.00),('1','143','865','257763',4904726,'2516','382',90635.08,90635.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257763',4904727,'2517','382',54607.20,54607.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257763',4904728,'2518','382',76231.23,76986.17,0.00,0.00,754.94,581303.80,0.00,0.00,0.00),('1','143','866','257763',4904729,'2519','382',106721.91,107328.84,0.00,0.00,606.93,467336.10,0.00,0.00,0.00),('1','143','865','257764',4904730,'2516','382',90635.08,91279.24,0.00,0.00,644.16,496003.20,0.00,0.00,0.00),('1','143','866','257764',4904731,'2517','382',54607.20,54607.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257764',4904732,'2518','382',76986.17,76986.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257764',4904733,'2519','382',107328.84,107989.28,0.00,0.00,660.44,508538.80,0.00,0.00,0.00),('1','143','865','257765',4904734,'2516','382',91279.24,91279.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257765',4904735,'2517','382',54607.20,54797.20,0.00,0.00,190.00,136800.00,0.00,0.00,0.00),('1','143','865','257765',4904736,'2518','382',76986.17,77460.47,0.00,0.00,474.30,365211.00,0.00,0.00,0.00),('1','143','866','257765',4904737,'2519','382',107989.28,108521.40,0.00,0.00,532.12,409732.40,0.00,0.00,0.00),('1','143','865','257766',4904738,'2516','382',91279.24,91855.96,0.00,0.00,576.72,444074.40,0.00,0.00,0.00),('1','143','866','257766',4904739,'2517','382',54797.20,55047.24,0.00,0.00,250.04,180030.80,0.00,0.00,0.00),('1','143','865','257766',4904740,'2518','382',77460.47,77460.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257766',4904741,'2519','382',108521.40,109054.44,0.00,0.00,533.04,410440.80,0.00,0.00,0.00),('1','143','865','257767',4904742,'2516','382',91855.96,91855.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257767',4904743,'2517','382',55047.24,55087.24,0.00,0.00,40.00,28800.00,0.00,0.00,0.00),('1','143','865','257767',4904744,'2518','382',77460.47,78220.32,0.00,0.00,759.85,585084.50,0.00,0.00,0.00),('1','143','866','257767',4904745,'2519','382',109054.44,109706.19,0.00,0.00,651.75,501847.50,0.00,0.00,0.00),('1','143','865','257768',4904746,'2516','382',91855.96,92814.23,0.00,0.00,958.27,737867.90,0.00,0.00,0.00),('1','143','866','257768',4904747,'2517','382',55087.24,55237.24,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','143','865','257768',4904748,'2518','382',78220.32,78220.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257768',4904749,'2519','382',109706.19,110366.55,0.00,0.00,660.36,508477.20,0.00,0.00,0.00),('1','143','865','257769',4904750,'2516','382',92814.23,92814.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257769',4904751,'2517','382',55237.24,55387.24,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','143','865','257769',4904752,'2518','382',78220.32,78679.32,0.00,0.00,459.00,353430.00,0.00,0.00,0.00),('1','143','866','257769',4904753,'2519','382',110366.55,110939.58,0.00,0.00,573.03,441233.10,0.00,0.00,0.00),('1','143','865','257770',4904754,'2516','382',92814.23,93454.54,0.00,0.00,640.31,493038.70,0.00,0.00,0.00),('1','143','866','257770',4904755,'2517','382',55387.24,55594.74,0.00,0.00,207.50,149400.00,0.00,0.00,0.00),('1','143','865','257770',4904756,'2518','382',78679.32,78679.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257770',4904757,'2519','382',110939.58,111526.91,0.00,0.00,587.33,452244.10,0.00,0.00,0.00),('1','143','865','257771',4904758,'2516','382',93454.54,93778.89,0.00,0.00,324.35,249749.50,0.00,0.00,0.00),('1','143','866','257771',4904759,'2517','382',55594.74,55594.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257771',4904760,'2518','382',78679.32,78679.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257771',4904761,'2519','382',111526.91,111851.39,0.00,0.00,324.48,249849.60,0.00,0.00,0.00),('1','143','865','257772',4904762,'2516','382',93778.89,94019.37,0.00,0.00,240.48,185169.60,0.00,0.00,0.00),('1','143','866','257772',4904763,'2517','382',55594.74,55594.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257772',4904764,'2518','382',78679.32,78679.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257772',4904765,'2519','382',111851.39,112061.11,0.00,0.00,209.72,161484.40,0.00,0.00,0.00),('1','143','865','257773',4904766,'2516','382',94019.37,94019.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257773',4904767,'2517','382',55594.74,55744.74,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','143','865','257773',4904768,'2518','382',78679.32,79144.74,0.00,0.00,465.42,358373.40,0.00,0.00,0.00),('1','143','866','257773',4904769,'2519','382',112061.11,112538.96,0.00,0.00,477.85,367944.50,0.00,0.00,0.00),('1','143','865','257774',4904770,'2516','382',94019.37,94792.22,0.00,0.00,772.85,595094.50,0.00,0.00,0.00),('1','143','866','257774',4904771,'2517','382',55744.74,55744.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257774',4904772,'2518','382',79144.74,79144.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257774',4904773,'2519','382',112538.96,113168.92,0.00,0.00,629.96,485069.20,0.00,0.00,0.00),('1','143','865','257775',4904774,'2516','382',94792.22,94792.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257775',4904775,'2517','382',55744.74,55744.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257775',4904776,'2518','382',79144.74,79144.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257775',4904777,'2519','382',113168.92,113168.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257776',4904778,'2516','382',94792.22,94792.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257776',4904779,'2517','382',55744.74,55744.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257776',4904780,'2518','382',79144.74,80013.60,0.00,0.00,868.86,669022.20,0.00,0.00,0.00),('1','143','866','257776',4904781,'2519','382',113168.92,113899.43,0.00,0.00,730.51,562492.70,0.00,0.00,0.00),('1','143','865','257777',4904782,'2516','382',94792.22,95569.10,0.00,0.00,776.88,598197.60,0.00,0.00,0.00),('1','143','866','257777',4904783,'2517','382',55744.74,55744.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257777',4904784,'2518','382',80013.60,80013.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257777',4904785,'2519','382',113899.43,114549.98,0.00,0.00,650.55,500923.50,0.00,0.00,0.00),('1','143','865','257778',4904786,'2516','382',95569.10,95569.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257778',4904787,'2517','382',55744.74,55744.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257778',4904788,'2518','382',80013.60,80690.54,0.00,0.00,676.94,521243.80,0.00,0.00,0.00),('1','143','866','257778',4904789,'2519','382',114549.98,115279.96,0.00,0.00,729.98,562084.60,0.00,0.00,0.00),('1','143','865','257779',4904790,'2516','382',95569.10,96057.96,0.00,0.00,488.86,376422.20,0.00,0.00,0.00),('1','143','866','257779',4904791,'2517','382',55744.74,55802.24,0.00,0.00,57.50,41400.00,0.00,0.00,0.00),('1','143','865','257779',4904792,'2518','382',80690.54,80690.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257779',4904793,'2519','382',115279.96,115999.81,0.00,0.00,719.85,554284.50,0.00,0.00,0.00),('1','143','865','257780',4904794,'2516','382',96057.96,96057.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257780',4904795,'2517','382',55802.24,55952.24,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','143','865','257780',4904796,'2518','382',80690.54,81221.88,0.00,0.00,531.34,409131.80,0.00,0.00,0.00),('1','143','866','257780',4904797,'2519','382',115999.81,116707.54,0.00,0.00,707.73,544952.10,0.00,0.00,0.00),('1','143','865','257781',4904798,'2516','382',96057.96,96704.02,0.00,0.00,646.06,497466.20,0.00,0.00,0.00),('1','143','866','257781',4904799,'2517','382',55952.24,56140.24,0.00,0.00,188.00,135360.00,0.00,0.00,0.00),('1','143','865','257781',4904800,'2518','382',81221.88,81221.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257781',4904801,'2519','382',116707.54,117327.81,0.00,0.00,620.27,477607.90,0.00,0.00,0.00),('1','143','865','257782',4904802,'2516','382',96704.02,96704.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257782',4904803,'2518','382',81221.88,81858.43,0.00,0.00,636.55,490143.50,0.00,0.00,0.00),('1','143','866','257782',4904804,'2519','382',117327.81,117910.93,0.00,0.00,583.12,449002.40,0.00,0.00,0.00),('1','143','866','257782',4904805,'2517','382',56140.24,56140.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257783',4904806,'2516','382',96704.02,97427.00,0.00,0.00,722.98,556694.60,0.00,0.00,0.00),('1','143','866','257783',4904807,'2517','382',56140.24,56290.24,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','143','865','257783',4904808,'2518','382',81858.43,81858.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257783',4904809,'2519','382',117910.93,118875.74,0.00,0.00,964.81,742903.70,0.00,0.00,0.00),('1','143','865','257784',4904810,'2516','382',97427.00,97427.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257784',4904811,'2517','382',56290.24,56351.42,0.00,0.00,61.18,44049.60,0.00,0.00,0.00),('1','143','865','257784',4904812,'2518','382',81858.43,82542.49,0.00,0.00,684.06,526726.20,0.00,0.00,0.00),('1','143','866','257784',4904813,'2519','382',118875.74,119847.42,0.00,0.00,971.68,748193.60,0.00,0.00,0.00),('1','143','865','257785',4904814,'2516','382',97427.00,98123.98,0.00,0.00,696.98,536674.60,0.00,0.00,0.00),('1','143','866','257785',4904815,'2517','382',56351.42,56401.42,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','143','865','257785',4904816,'2518','382',82542.49,82542.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257785',4904817,'2519','382',119847.42,120582.49,0.00,0.00,735.07,566003.90,0.00,0.00,0.00),('1','143','865','257786',4904818,'2516','382',98123.98,98410.04,0.00,0.00,286.06,220266.20,0.00,0.00,0.00),('1','143','866','257786',4904819,'2517','382',56401.42,56401.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257786',4904820,'2518','382',82542.49,82542.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257786',4904821,'2519','382',120582.49,120849.77,0.00,0.00,267.28,205805.60,0.00,0.00,0.00),('1','143','865','257787',4904822,'2516','382',98410.04,98625.19,0.00,0.00,215.15,165665.50,0.00,0.00,0.00),('1','143','866','257787',4904823,'2517','382',56401.42,56421.42,0.00,0.00,20.00,14400.00,0.00,0.00,0.00),('1','143','865','257787',4904824,'2518','382',82542.49,82542.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257787',4904825,'2519','382',120849.77,121273.01,0.00,0.00,423.24,325894.80,0.00,0.00,0.00),('1','143','865','257788',4904826,'2516','382',98625.19,99055.24,0.00,0.00,430.05,331138.50,0.00,0.00,0.00),('1','143','866','257788',4904827,'2517','382',56421.42,56446.42,0.00,0.00,25.00,18000.00,0.00,0.00,0.00),('1','143','865','257788',4904828,'2518','382',82542.49,82989.13,0.00,0.00,446.64,343912.80,0.00,0.00,0.00),('1','143','866','257788',4904829,'2519','382',121273.01,121480.64,0.00,0.00,207.63,159875.10,0.00,0.00,0.00),('1','143','865','257789',4904830,'2516','382',99055.24,99606.36,0.00,0.00,551.12,424362.40,0.00,0.00,0.00),('1','143','866','257789',4904831,'2517','382',56446.42,56716.42,0.00,0.00,270.00,194400.00,0.00,0.00,0.00),('1','143','865','257789',4904832,'2518','382',82989.13,83598.78,0.00,0.00,609.65,469430.50,0.00,0.00,0.00),('1','143','866','257789',4904833,'2519','382',121480.64,121514.41,0.00,0.00,33.77,26002.90,0.00,0.00,0.00),('1','143','865','257790',4904834,'2516','382',99606.36,99606.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257790',4904835,'2517','382',56716.42,56716.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257790',4904836,'2518','382',83598.78,83598.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257790',4904837,'2519','382',121514.41,121514.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257791',4904838,'2516','382',99606.36,99618.36,0.00,0.00,12.00,9240.00,0.00,0.00,0.00),('1','143','866','257791',4904839,'2517','382',56716.42,57541.42,0.00,0.00,825.00,594000.00,0.00,0.00,0.00),('1','143','865','257791',4904840,'2518','382',83598.78,84138.65,0.00,0.00,539.87,415699.90,0.00,0.00,0.00),('1','143','866','257791',4904841,'2519','382',121514.41,122160.53,0.00,0.00,646.12,497512.40,0.00,0.00,0.00),('1','143','865','257792',4904842,'2516','382',99618.36,100117.33,0.00,0.00,498.97,384206.90,0.00,0.00,0.00),('1','143','866','257792',4904843,'2517','382',57541.42,58526.42,0.00,0.00,985.00,709200.00,0.00,0.00,0.00),('1','143','865','257792',4904844,'2518','382',84138.65,84147.65,0.00,0.00,9.00,6930.00,0.00,0.00,0.00),('1','143','866','257792',4904845,'2519','382',122160.53,122838.67,0.00,0.00,678.14,522167.80,0.00,0.00,0.00),('1','143','865','257793',4904846,'2516','382',100117.33,100884.85,0.00,0.00,767.52,590990.40,0.00,0.00,0.00),('1','143','866','257793',4904847,'2517','382',58526.42,58986.42,0.00,0.00,460.00,331200.00,0.00,0.00,0.00),('1','143','865','257793',4904848,'2518','382',84147.65,84409.23,0.00,0.00,261.58,201416.60,0.00,0.00,0.00),('1','143','866','257793',4904849,'2519','382',122838.67,123218.73,0.00,0.00,380.06,292646.20,0.00,0.00,0.00),('1','143','865','257794',4904850,'2516','382',100884.85,101298.07,0.00,0.00,413.22,318179.40,0.00,0.00,0.00),('1','143','866','257794',4904851,'2517','382',58986.42,61176.04,0.00,0.00,2189.62,1576526.40,0.00,0.00,0.00),('1','143','865','257794',4904852,'2518','382',84409.23,85166.64,0.00,0.00,757.41,583205.70,0.00,0.00,0.00),('1','143','866','257794',4904853,'2519','382',123218.73,123218.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257795',4904854,'2516','382',101298.07,102624.37,0.00,0.00,1326.30,1021251.00,0.00,0.00,0.00),('1','143','866','257795',4904855,'2517','382',61176.04,62760.04,0.00,0.00,1584.00,1138480.00,0.00,0.00,0.00),('1','143','865','257795',4904856,'2518','382',85166.64,85876.64,0.00,0.00,710.00,511200.00,0.00,0.00,0.00),('1','143','866','257795',4904857,'2519','382',123218.73,123218.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257796',4904858,'2516','382',102624.37,103969.52,0.00,0.00,1345.15,1035765.50,0.00,0.00,0.00),('1','143','866','257796',4904859,'2517','382',62760.04,63355.04,0.00,0.00,595.00,428400.00,0.00,0.00,0.00),('1','143','865','257796',4904860,'2518','382',85876.64,86076.66,0.00,0.00,200.02,144015.40,0.00,0.00,0.00),('1','143','866','257796',4904861,'2519','382',123218.73,123218.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257797',4904862,'2516','382',103969.52,105411.56,0.00,0.00,1442.04,1110370.80,0.00,0.00,0.00),('1','143','866','257797',4904863,'2517','382',63355.04,65060.04,0.00,0.00,1705.00,1227600.00,0.00,0.00,0.00),('1','143','865','257797',4904864,'2518','382',86076.66,86076.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257797',4904865,'2519','382',123218.73,123218.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257798',4904866,'2516','382',105411.56,106625.53,0.00,0.00,1213.97,934756.90,0.00,0.00,0.00),('1','143','866','257798',4904867,'2517','382',65060.04,65710.58,0.00,0.00,650.54,468388.80,0.00,0.00,0.00),('1','143','865','257798',4904868,'2518','382',86076.66,86234.66,0.00,0.00,158.00,113760.00,0.00,0.00,0.00),('1','143','866','257798',4904869,'2519','382',123218.73,123218.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257799',4904870,'2516','382',106625.53,106696.33,0.00,0.00,70.80,54516.00,0.00,0.00,0.00),('1','143','866','257799',4904871,'2517','382',65710.58,65929.58,0.00,0.00,219.00,157680.00,0.00,0.00,0.00),('1','143','865','257799',4904872,'2518','382',86234.66,86234.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257799',4904873,'2519','382',123218.73,123218.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257800',4904874,'2516','382',106696.33,108029.47,0.00,0.00,1333.14,1026517.80,0.00,0.00,0.00),('1','143','866','257800',4904875,'2517','382',65929.58,67532.80,0.00,0.00,1603.22,1154318.40,0.00,0.00,0.00),('1','143','865','257800',4904876,'2518','382',86234.66,87079.99,0.00,0.00,845.33,608637.60,0.00,0.00,0.00),('1','143','866','257800',4904877,'2519','382',123218.73,123218.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257801',4904878,'2516','382',108029.47,108029.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257801',4904879,'2518','382',87079.99,87079.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257801',4904880,'2519','382',123218.73,123218.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257801',4904881,'2517','382',67532.80,67532.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257802',4904882,'2516','382',108029.47,109555.87,0.00,0.00,1526.40,1175328.00,0.00,0.00,0.00),('1','143','866','257802',4904883,'2517','382',67532.80,68789.12,0.00,0.00,1256.32,904550.40,0.00,0.00,0.00),('1','143','865','257802',4904884,'2518','382',87079.99,87241.86,0.00,0.00,161.87,124639.90,0.00,0.00,0.00),('1','143','866','257802',4904885,'2519','382',123218.73,123218.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257803',4904886,'2516','382',109555.87,110843.50,0.00,0.00,1287.63,991475.10,0.00,0.00,0.00),('1','143','866','257803',4904887,'2517','382',68789.12,71284.25,0.00,0.00,2495.13,1794293.60,0.00,0.00,0.00),('1','143','865','257803',4904888,'2518','382',87241.86,88496.86,0.00,0.00,1255.00,903600.00,0.00,0.00,0.00),('1','143','866','257803',4904889,'2519','382',123218.73,123218.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257804',4904890,'2516','382',110843.50,112371.91,0.00,0.00,1528.41,1176875.70,0.00,0.00,0.00),('1','143','866','257804',4904891,'2517','382',71284.25,74151.51,0.00,0.00,2867.26,2064427.20,0.00,0.00,0.00),('1','143','865','257804',4904892,'2518','382',88496.86,89337.97,0.00,0.00,841.11,605599.20,0.00,0.00,0.00),('1','143','866','257804',4904893,'2519','382',123218.73,123296.69,0.00,0.00,77.96,60029.20,0.00,0.00,0.00),('1','143','865','257805',4904894,'2516','382',112371.91,112737.92,0.00,0.00,366.01,281827.70,0.00,0.00,0.00),('1','143','866','257805',4904895,'2517','382',74151.51,74790.51,0.00,0.00,639.00,460080.00,0.00,0.00,0.00),('1','143','865','257805',4904896,'2518','382',89337.97,89850.22,0.00,0.00,512.25,368820.00,0.00,0.00,0.00),('1','143','866','257805',4904897,'2519','382',123296.69,123296.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257806',4904898,'2516','382',112737.92,113877.61,0.00,0.00,1139.69,888513.50,0.00,0.00,0.00),('1','143','866','257806',4904899,'2517','382',74790.51,75720.91,0.00,0.00,930.40,677036.00,0.00,0.00,0.00),('1','143','865','257806',4904900,'2518','382',89850.22,90337.97,0.00,0.00,487.75,359180.00,0.00,0.00,0.00),('1','143','866','257806',4904901,'2519','382',123296.69,123296.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257807',4904902,'2516','382',113877.61,113877.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257807',4904903,'2517','382',75720.91,75720.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257807',4904904,'2518','382',90337.97,90337.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257807',4904905,'2519','382',123296.69,123296.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257808',4904906,'2516','382',113877.61,115337.12,0.00,0.00,1459.51,1153012.90,0.00,0.00,0.00),('1','143','866','257808',4904907,'2517','382',75720.91,78291.73,0.00,0.00,2570.82,1902406.80,0.00,0.00,0.00),('1','143','865','257808',4904908,'2518','382',90337.97,90637.97,0.00,0.00,300.00,222000.00,0.00,0.00,0.00),('1','143','866','257808',4904909,'2519','382',123296.69,123330.21,0.00,0.00,33.52,26480.80,0.00,0.00,0.00),('1','143','865','257809',4904910,'2516','382',115337.12,116542.22,0.00,0.00,1205.10,952029.00,0.00,0.00,0.00),('1','143','866','257809',4904911,'2517','382',78291.73,79173.23,0.00,0.00,881.50,652310.00,0.00,0.00,0.00),('1','143','865','257809',4904912,'2518','382',90637.97,91357.62,0.00,0.00,719.65,532541.00,0.00,0.00,0.00),('1','143','866','257809',4904913,'2519','382',123330.21,123411.59,0.00,0.00,81.38,64290.20,0.00,0.00,0.00),('1','143','865','257810',4904914,'2516','382',116542.22,117676.05,0.00,0.00,1133.83,895725.70,0.00,0.00,0.00),('1','143','866','257810',4904915,'2517','382',79173.23,79768.23,0.00,0.00,595.00,440300.00,0.00,0.00,0.00),('1','143','865','257810',4904916,'2518','382',91357.62,91887.56,0.00,0.00,529.94,392155.60,0.00,0.00,0.00),('1','143','866','257810',4904917,'2519','382',123411.59,124042.12,0.00,0.00,630.53,498118.70,0.00,0.00,0.00),('1','143','865','257811',4904918,'2516','382',117676.05,118827.97,0.00,0.00,1151.92,910016.80,0.00,0.00,0.00),('1','143','866','257811',4904919,'2517','382',79768.23,80470.53,0.00,0.00,702.30,519702.00,0.00,0.00,0.00),('1','143','865','257811',4904920,'2518','382',91887.56,92897.97,0.00,0.00,1010.41,798223.90,0.00,0.00,0.00),('1','143','866','257811',4904921,'2519','382',124042.12,124992.12,0.00,0.00,950.00,703000.00,0.00,0.00,0.00),('1','143','865','257812',4904922,'2516','382',118827.97,120031.37,0.00,0.00,1203.40,950686.00,0.00,0.00,0.00),('1','143','866','257812',4904923,'2517','382',80470.53,80470.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257812',4904924,'2518','382',92897.97,93607.83,0.00,0.00,709.86,560789.40,0.00,0.00,0.00),('1','143','866','257812',4904925,'2519','382',124992.12,124992.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257813',4904926,'2516','382',120031.37,120031.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257813',4904927,'2517','382',80470.53,80710.75,0.00,0.00,240.22,177762.80,0.00,0.00,0.00),('1','143','865','257813',4904928,'2518','382',93607.83,93607.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257813',4904929,'2519','382',124992.12,125092.26,0.00,0.00,100.14,74103.60,0.00,0.00,0.00),('1','143','865','257814',4904930,'2516','382',120031.37,120962.69,0.00,0.00,931.32,735742.80,0.00,0.00,0.00),('1','143','866','257814',4904931,'2517','382',80710.75,81426.75,0.00,0.00,716.00,529990.00,0.00,0.00,0.00),('1','143','865','257814',4904932,'2518','382',93607.83,94519.72,0.00,0.00,911.89,720393.10,0.00,0.00,0.00),('1','143','866','257814',4904933,'2519','382',125092.26,125092.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257815',4904934,'2516','382',120962.69,121993.09,0.00,0.00,1030.40,814016.00,0.00,0.00,0.00),('1','143','866','257815',4904935,'2517','382',81426.75,82021.75,0.00,0.00,595.00,440300.00,0.00,0.00,0.00),('1','143','865','257815',4904936,'2518','382',94519.72,95239.65,0.00,0.00,719.93,568744.70,0.00,0.00,0.00),('1','143','866','257815',4904937,'2519','382',125092.26,125092.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257816',4904938,'2516','382',121993.09,122849.76,0.00,0.00,856.67,676769.30,0.00,0.00,0.00),('1','143','866','257816',4904939,'2517','382',82021.75,82956.18,0.00,0.00,934.43,691478.20,0.00,0.00,0.00),('1','143','865','257816',4904940,'2518','382',95239.65,95919.89,0.00,0.00,680.24,537389.60,0.00,0.00,0.00),('1','143','866','257816',4904941,'2519','382',125092.26,125856.76,0.00,0.00,764.50,565730.00,0.00,0.00,0.00),('1','143','865','257817',4904942,'2516','382',122849.76,123686.96,0.00,0.00,837.20,661388.00,0.00,0.00,0.00),('1','143','866','257817',4904943,'2517','382',82956.18,83456.18,0.00,0.00,500.00,370000.00,0.00,0.00,0.00),('1','143','865','257817',4904944,'2518','382',95919.89,96664.21,0.00,0.00,744.32,588012.80,0.00,0.00,0.00),('1','143','866','257817',4904945,'2519','382',125856.76,126172.26,0.00,0.00,315.50,233470.00,0.00,0.00,0.00),('1','143','865','257818',4904946,'2516','382',123686.96,124397.74,0.00,0.00,710.78,561516.20,0.00,0.00,0.00),('1','143','865','257818',4904947,'2518','382',96664.21,97434.27,0.00,0.00,770.06,608347.40,0.00,0.00,0.00),('1','143','866','257818',4904948,'2519','382',126172.26,126584.26,0.00,0.00,412.00,304880.00,0.00,0.00,0.00),('1','143','866','257818',4904949,'2517','382',83456.18,83616.18,0.00,0.00,160.00,118400.00,0.00,0.00,0.00),('1','143','865','257819',4904950,'2516','382',124397.74,125041.15,0.00,0.00,643.41,508293.90,0.00,0.00,0.00),('1','143','866','257819',4904951,'2517','382',83616.18,83931.97,0.00,0.00,315.79,233684.60,0.00,0.00,0.00),('1','143','865','257819',4904952,'2518','382',97434.27,97945.14,0.00,0.00,510.87,403587.30,0.00,0.00,0.00),('1','143','866','257819',4904953,'2519','382',126584.26,126834.26,0.00,0.00,250.00,185000.00,0.00,0.00,0.00),('1','143','865','257820',4904954,'2516','382',125041.15,125712.22,0.00,0.00,671.07,530145.30,0.00,0.00,0.00),('1','143','866','257820',4904955,'2517','382',83931.97,84231.97,0.00,0.00,300.00,222000.00,0.00,0.00,0.00),('1','143','865','257820',4904956,'2518','382',97945.14,98502.70,0.00,0.00,557.56,440472.40,0.00,0.00,0.00),('1','143','866','257820',4904957,'2519','382',126834.26,127396.76,0.00,0.00,562.50,416250.00,0.00,0.00,0.00),('1','143','865','257821',4904958,'2516','382',125712.22,126488.90,0.00,0.00,776.68,613577.20,0.00,0.00,0.00),('1','143','866','257821',4904959,'2517','382',84231.97,84231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257821',4904960,'2518','382',98502.70,99275.12,0.00,0.00,772.42,610211.80,0.00,0.00,0.00),('1','143','866','257821',4904961,'2519','382',127396.76,128146.76,0.00,0.00,750.00,555000.00,0.00,0.00,0.00),('1','143','865','257822',4904962,'2516','382',126488.90,127158.96,0.00,0.00,670.06,529347.40,0.00,0.00,0.00),('1','143','866','257822',4904963,'2517','382',84231.97,84231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257822',4904964,'2518','382',99275.12,99912.67,0.00,0.00,637.55,503664.50,0.00,0.00,0.00),('1','143','866','257822',4904965,'2519','382',128146.76,128296.76,0.00,0.00,150.00,111000.00,0.00,0.00,0.00),('1','143','865','257823',4904966,'2516','382',127158.96,127887.82,0.00,0.00,728.86,575799.40,0.00,0.00,0.00),('1','143','865','257823',4904967,'2518','382',99912.67,100499.76,0.00,0.00,587.09,463801.10,0.00,0.00,0.00),('1','143','866','257823',4904968,'2519','382',128296.76,128924.26,0.00,0.00,627.50,464350.00,0.00,0.00,0.00),('1','143','866','257823',4904969,'2517','382',84231.97,84231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257824',4904970,'2516','382',127887.82,128633.76,0.00,0.00,745.94,589292.60,0.00,0.00,0.00),('1','143','865','257824',4904971,'2518','382',100499.76,101243.39,0.00,0.00,743.63,587467.70,0.00,0.00,0.00),('1','143','866','257824',4904972,'2519','382',128924.26,129466.26,0.00,0.00,542.00,401080.00,0.00,0.00,0.00),('1','143','866','257824',4904973,'2517','382',84231.97,84782.00,0.00,0.00,550.03,407022.20,0.00,0.00,0.00),('1','143','865','257825',4904974,'2516','382',128633.76,129426.49,0.00,0.00,792.73,626256.70,0.00,0.00,0.00),('1','143','866','257825',4904975,'2517','382',84782.00,86174.97,0.00,0.00,1392.97,1029797.80,0.00,0.00,0.00),('1','143','865','257825',4904976,'2518','382',101243.39,101778.22,0.00,0.00,534.83,422515.70,0.00,0.00,0.00),('1','143','866','257825',4904977,'2519','382',129466.26,131335.76,0.00,0.00,1869.50,1382430.00,0.00,0.00,0.00),('1','143','865','257826',4904978,'2516','382',129426.49,129426.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257826',4904979,'2517','382',86174.97,86174.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257826',4904980,'2518','382',101778.22,101778.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257826',4904981,'2519','382',131335.76,131335.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257827',4904982,'2516','382',129426.49,130147.58,0.00,0.00,721.09,569661.10,0.00,0.00,0.00),('1','143','865','257827',4904983,'2518','382',101778.22,102543.92,0.00,0.00,765.70,604903.00,0.00,0.00,0.00),('1','143','866','257827',4904984,'2519','382',131335.76,131678.76,0.00,0.00,343.00,253820.00,0.00,0.00,0.00),('1','143','866','257827',4904985,'2517','382',86174.97,86529.97,0.00,0.00,355.00,262700.00,0.00,0.00,0.00),('1','143','865','257828',4904986,'2516','382',130147.58,130717.76,0.00,0.00,570.18,450442.20,0.00,0.00,0.00),('1','143','866','257828',4904987,'2517','382',86529.97,87379.97,0.00,0.00,850.00,629000.00,0.00,0.00,0.00),('1','143','865','257828',4904988,'2518','382',102543.92,103007.10,0.00,0.00,463.18,365912.20,0.00,0.00,0.00),('1','143','866','257828',4904989,'2519','382',131678.76,131936.76,0.00,0.00,258.00,190920.00,0.00,0.00,0.00),('1','143','865','257829',4904990,'2516','382',130717.76,131318.59,0.00,0.00,600.83,474655.70,0.00,0.00,0.00),('1','143','866','257829',4904991,'2517','382',87379.97,87520.24,0.00,0.00,140.27,103799.80,0.00,0.00,0.00),('1','143','865','257829',4904992,'2518','382',103007.10,103552.42,0.00,0.00,545.32,430802.80,0.00,0.00,0.00),('1','143','866','257829',4904993,'2519','382',131936.76,132304.28,0.00,0.00,367.52,271964.80,0.00,0.00,0.00),('1','143','865','257830',4904994,'2516','382',131318.59,132099.90,0.00,0.00,781.31,617234.90,0.00,0.00,0.00),('1','143','866','257830',4904995,'2517','382',87520.24,87620.24,0.00,0.00,100.00,74000.00,0.00,0.00,0.00),('1','143','865','257830',4904996,'2518','382',103552.42,104272.18,0.00,0.00,719.76,568610.40,0.00,0.00,0.00),('1','143','866','257830',4904997,'2519','382',132304.28,132980.61,0.00,0.00,676.33,500484.20,0.00,0.00,0.00),('1','143','865','257831',4904998,'2516','382',132099.90,132158.12,0.00,0.00,58.22,45993.80,0.00,0.00,0.00),('1','143','865','257831',4904999,'2518','382',104272.18,104301.58,0.00,0.00,29.40,23226.00,0.00,0.00,0.00),('1','143','866','257831',4905000,'2519','382',132980.61,132980.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257831',4905001,'2517','382',87620.24,87682.91,0.00,0.00,62.67,46375.80,0.00,0.00,0.00),('1','143','865','257832',4905002,'2516','382',132158.12,132687.55,0.00,0.00,529.43,418249.70,0.00,0.00,0.00),('1','143','865','257832',4905003,'2518','382',104301.58,104802.78,0.00,0.00,501.20,395948.00,0.00,0.00,0.00),('1','143','866','257832',4905004,'2519','382',132980.61,133815.11,0.00,0.00,834.50,617530.00,0.00,0.00,0.00),('1','143','866','257832',4905005,'2517','382',87682.91,88189.91,0.00,0.00,507.00,375180.00,0.00,0.00,0.00),('1','143','865','257833',4905006,'2516','382',132687.55,132687.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257833',4905007,'2518','382',104802.78,104802.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257833',4905008,'2519','382',133815.11,133815.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257833',4905009,'2517','382',88189.91,88189.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257834',4905010,'2516','382',132687.55,133419.26,0.00,0.00,731.71,578050.90,0.00,0.00,0.00),('1','143','866','257834',4905011,'2517','382',88189.91,88631.91,0.00,0.00,442.00,327080.00,0.00,0.00,0.00),('1','143','865','257834',4905012,'2518','382',104802.78,105251.50,0.00,0.00,448.72,354488.80,0.00,0.00,0.00),('1','143','866','257834',4905013,'2519','382',133815.11,134205.11,0.00,0.00,390.00,288600.00,0.00,0.00,0.00),('1','143','865','257835',4905014,'2516','382',133419.26,134124.19,0.00,0.00,704.93,556894.70,0.00,0.00,0.00),('1','143','865','257835',4905015,'2518','382',105251.50,105940.05,0.00,0.00,688.55,543954.50,0.00,0.00,0.00),('1','143','866','257835',4905016,'2519','382',134205.11,134915.11,0.00,0.00,710.00,525400.00,0.00,0.00,0.00),('1','143','866','257835',4905017,'2517','382',88631.91,89223.91,0.00,0.00,592.00,438080.00,0.00,0.00,0.00),('1','143','865','257836',4905018,'2516','382',134124.19,134824.75,0.00,0.00,700.56,553442.40,0.00,0.00,0.00),('1','143','866','257836',4905019,'2517','382',89223.91,89578.91,0.00,0.00,355.00,262700.00,0.00,0.00,0.00),('1','143','865','257836',4905020,'2518','382',105940.05,106462.68,0.00,0.00,522.63,412877.70,0.00,0.00,0.00),('1','143','866','257836',4905021,'2519','382',134915.11,135355.11,0.00,0.00,440.00,325600.00,0.00,0.00,0.00),('1','143','865','257837',4905022,'2516','382',134824.75,135660.57,0.00,0.00,835.82,660297.80,0.00,0.00,0.00),('1','143','865','257837',4905023,'2518','382',106462.68,107178.46,0.00,0.00,715.78,565466.20,0.00,0.00,0.00),('1','143','866','257837',4905024,'2519','382',135355.11,135620.11,0.00,0.00,265.00,196100.00,0.00,0.00,0.00),('1','143','866','257837',4905025,'2517','382',89578.91,90014.41,0.00,0.00,435.50,322270.00,0.00,0.00,0.00),('1','143','865','257838',4905026,'2516','382',135660.57,136490.42,0.00,0.00,829.85,655581.50,0.00,0.00,0.00),('1','143','866','257838',4905027,'2517','382',90014.41,90014.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257838',4905028,'2518','382',107178.46,107915.19,0.00,0.00,736.73,582016.70,0.00,0.00,0.00),('1','143','866','257838',4905029,'2519','382',135620.11,135865.11,0.00,0.00,245.00,181300.00,0.00,0.00,0.00),('1','143','865','257839',4905030,'2516','382',136490.42,137359.67,0.00,0.00,869.25,686707.50,0.00,0.00,0.00),('1','143','866','257839',4905031,'2517','382',90014.41,90014.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257839',4905032,'2518','382',107915.19,108532.21,0.00,0.00,617.02,487445.80,0.00,0.00,0.00),('1','143','866','257839',4905033,'2519','382',135865.11,136335.11,0.00,0.00,470.00,347800.00,0.00,0.00,0.00),('1','143','865','257840',4905034,'2516','382',137359.67,138073.19,0.00,0.00,713.52,563680.80,0.00,0.00,0.00),('1','143','866','257840',4905035,'2517','382',90014.41,90183.89,0.00,0.00,169.48,125415.20,0.00,0.00,0.00),('1','143','865','257840',4905036,'2518','382',108532.21,109191.45,0.00,0.00,659.24,520799.60,0.00,0.00,0.00),('1','143','866','257840',4905037,'2519','382',136335.11,136755.11,0.00,0.00,420.00,310800.00,0.00,0.00,0.00),('1','143','865','257841',4905038,'2516','382',138073.19,138142.13,0.00,0.00,68.94,54462.60,0.00,0.00,0.00),('1','143','866','257841',4905039,'2517','382',90183.89,90183.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257841',4905040,'2518','382',109191.45,109191.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257841',4905041,'2519','382',136755.11,136755.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257842',4905042,'2516','382',138142.13,138859.81,0.00,0.00,717.68,566967.20,0.00,0.00,0.00),('1','143','866','257842',4905043,'2517','382',90183.89,90183.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257842',4905044,'2518','382',109191.45,109802.21,0.00,0.00,610.76,482500.40,0.00,0.00,0.00),('1','143','866','257842',4905045,'2519','382',136755.11,137480.11,0.00,0.00,725.00,536500.00,0.00,0.00,0.00),('1','143','865','257843',4905046,'2516','382',138859.81,139679.16,0.00,0.00,819.35,647286.50,0.00,0.00,0.00),('1','143','865','257843',4905047,'2518','382',109802.21,110568.45,0.00,0.00,766.24,605329.60,0.00,0.00,0.00),('1','143','866','257843',4905048,'2519','382',137480.11,137670.11,0.00,0.00,190.00,140600.00,0.00,0.00,0.00),('1','143','866','257843',4905049,'2517','382',90183.89,90293.89,0.00,0.00,110.00,81400.00,0.00,0.00,0.00),('1','143','865','257844',4905050,'2516','382',139679.16,139679.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257844',4905051,'2517','382',90293.89,90293.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257844',4905052,'2518','382',110568.45,110568.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257844',4905053,'2519','382',137670.11,137670.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257845',4905054,'2516','382',139679.16,140202.56,0.00,0.00,523.40,413486.00,0.00,0.00,0.00),('1','143','866','257845',4905055,'2517','382',90293.89,90293.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257845',4905056,'2518','382',110568.45,111215.95,0.00,0.00,647.50,511525.00,0.00,0.00,0.00),('1','143','866','257845',4905057,'2519','382',137670.11,137732.11,0.00,0.00,62.00,45880.00,0.00,0.00,0.00),('1','143','865','257846',4905058,'2516','382',140202.56,140334.80,0.00,0.00,132.24,104469.60,0.00,0.00,0.00),('1','143','866','257846',4905059,'2517','382',90293.89,90293.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257846',4905060,'2518','382',111215.95,111385.12,0.00,0.00,169.17,133644.30,0.00,0.00,0.00),('1','143','866','257846',4905061,'2519','382',137732.11,137839.61,0.00,0.00,107.50,79550.00,0.00,0.00,0.00),('1','143','865','257847',4905062,'2516','382',140334.80,141233.42,0.00,0.00,898.62,709909.80,0.00,0.00,0.00),('1','143','866','257847',4905063,'2517','382',90293.89,90410.89,0.00,0.00,117.00,86580.00,0.00,0.00,0.00),('1','143','865','257847',4905064,'2518','382',111385.12,112118.52,0.00,0.00,733.40,579386.00,0.00,0.00,0.00),('1','143','866','257847',4905065,'2519','382',137839.61,138114.61,0.00,0.00,275.00,203500.00,0.00,0.00,0.00),('1','143','865','257848',4905066,'2516','382',141233.42,142117.93,0.00,0.00,884.51,698762.90,0.00,0.00,0.00),('1','143','866','257848',4905067,'2517','382',90410.89,90778.39,0.00,0.00,367.50,271950.00,0.00,0.00,0.00),('1','143','865','257848',4905068,'2518','382',112118.52,112822.68,0.00,0.00,704.16,556286.40,0.00,0.00,0.00),('1','143','866','257848',4905069,'2519','382',138114.61,138194.61,0.00,0.00,80.00,59200.00,0.00,0.00,0.00),('1','143','865','257849',4905070,'2516','382',142117.93,142944.85,0.00,0.00,826.92,653266.80,0.00,0.00,0.00),('1','143','866','257849',4905071,'2517','382',90778.39,90778.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257849',4905072,'2518','382',112822.68,113729.57,0.00,0.00,906.89,716443.10,0.00,0.00,0.00),('1','143','866','257849',4905073,'2519','382',138194.61,138455.61,0.00,0.00,261.00,193140.00,0.00,0.00,0.00),('1','143','865','257850',4905074,'2516','382',142944.85,143508.50,0.00,0.00,563.65,445283.50,0.00,0.00,0.00),('1','143','865','257850',4905075,'2518','382',113729.57,114974.46,0.00,0.00,1244.89,983463.10,0.00,0.00,0.00),('1','143','866','257850',4905076,'2519','382',138455.61,138738.61,0.00,0.00,283.00,209420.00,0.00,0.00,0.00),('1','143','866','257850',4905077,'2517','382',90778.39,90878.39,0.00,0.00,100.00,74000.00,0.00,0.00,0.00),('1','143','865','257851',4905078,'2516','382',143508.50,144296.84,0.00,0.00,788.34,622788.60,0.00,0.00,0.00),('1','143','866','257851',4905079,'2517','382',90878.39,90878.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257851',4905080,'2518','382',114974.46,115660.84,0.00,0.00,686.38,542240.20,0.00,0.00,0.00),('1','143','866','257851',4905081,'2519','382',138738.61,139333.61,0.00,0.00,595.00,440300.00,0.00,0.00,0.00),('1','143','865','257852',4905082,'2516','382',144296.84,144951.26,0.00,0.00,654.42,516991.80,0.00,0.00,0.00),('1','143','865','257852',4905083,'2518','382',115660.84,116330.88,0.00,0.00,670.04,529331.60,0.00,0.00,0.00),('1','143','866','257852',4905084,'2519','382',139333.61,139666.61,0.00,0.00,333.00,246420.00,0.00,0.00,0.00),('1','143','866','257852',4905085,'2517','382',90878.39,91044.39,0.00,0.00,166.00,122840.00,0.00,0.00,0.00),('1','143','865','257853',4905086,'2516','382',144951.26,145551.34,0.00,0.00,600.08,474063.20,0.00,0.00,0.00),('1','143','866','257853',4905087,'2517','382',91044.39,91044.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257853',4905088,'2518','382',116330.88,117004.14,0.00,0.00,673.26,531875.40,0.00,0.00,0.00),('1','143','866','257853',4905089,'2519','382',139666.61,140028.33,0.00,0.00,361.72,267672.80,0.00,0.00,0.00),('1','143','865','257854',4905090,'2516','382',145551.34,145641.94,0.00,0.00,90.60,71574.00,0.00,0.00,0.00),('1','143','866','257854',4905091,'2517','382',91044.39,91044.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257854',4905092,'2518','382',117004.14,117102.06,0.00,0.00,97.92,77356.80,0.00,0.00,0.00),('1','143','866','257854',4905093,'2519','382',140028.33,140028.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257855',4905094,'2516','382',145641.94,146244.94,0.00,0.00,603.00,476370.00,0.00,0.00,0.00),('1','143','866','257855',4905095,'2517','382',91044.39,91351.89,0.00,0.00,307.50,227550.00,0.00,0.00,0.00),('1','143','865','257855',4905096,'2518','382',117102.06,117803.95,0.00,0.00,701.89,554493.10,0.00,0.00,0.00),('1','143','866','257855',4905097,'2519','382',140028.33,140243.33,0.00,0.00,215.00,159100.00,0.00,0.00,0.00),('1','143','865','257856',4905098,'2516','382',146244.94,146244.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257856',4905099,'2517','382',91351.89,91351.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257856',4905100,'2518','382',117803.95,117803.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257856',4905101,'2519','382',140243.33,140243.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257857',4905102,'2516','382',146244.94,146751.16,0.00,0.00,506.22,399913.80,0.00,0.00,0.00),('1','143','866','257857',4905103,'2517','382',91351.89,91351.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257857',4905104,'2518','382',117803.95,118795.18,0.00,0.00,991.23,783071.70,0.00,0.00,0.00),('1','143','866','257857',4905105,'2519','382',140243.33,140940.33,0.00,0.00,697.00,515780.00,0.00,0.00,0.00),('1','143','865','257858',4905106,'2516','382',146751.16,147120.56,0.00,0.00,369.40,291826.00,0.00,0.00,0.00),('1','143','866','257858',4905107,'2517','382',91351.89,91351.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257858',4905108,'2518','382',118795.18,119689.33,0.00,0.00,894.15,706378.50,0.00,0.00,0.00),('1','143','866','257858',4905109,'2519','382',140940.33,141045.94,0.00,0.00,105.61,78151.40,0.00,0.00,0.00),('1','143','865','257859',4905110,'2516','382',147120.56,147120.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257859',4905111,'2517','382',91351.89,91959.78,0.00,0.00,607.89,480233.10,0.00,0.00,0.00),('1','143','865','257859',4905112,'2518','382',119689.33,120461.54,0.00,0.00,772.21,610045.90,0.00,0.00,0.00),('1','143','866','257859',4905113,'2519','382',141045.94,141365.94,0.00,0.00,320.00,236800.00,0.00,0.00,0.00),('1','143','865','257860',4905114,'2516','382',147120.56,147607.56,0.00,0.00,487.00,350640.00,0.00,0.00,0.00),('1','143','866','257860',4905115,'2517','382',91959.78,92397.64,0.00,0.00,437.86,337152.20,0.00,0.00,0.00),('1','143','865','257860',4905116,'2518','382',120461.54,121143.33,0.00,0.00,681.79,524978.30,0.00,0.00,0.00),('1','143','866','257860',4905117,'2519','382',141365.94,141365.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257861',4905118,'2516','382',147607.56,147607.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257861',4905119,'2517','382',92397.64,93072.34,0.00,0.00,674.70,519519.00,0.00,0.00,0.00),('1','143','865','257861',4905120,'2518','382',121143.33,121718.98,0.00,0.00,575.65,443250.50,0.00,0.00,0.00),('1','143','866','257861',4905121,'2519','382',141365.94,141904.62,0.00,0.00,538.68,387849.60,0.00,0.00,0.00),('1','143','865','257862',4905122,'2516','382',147607.56,148120.56,0.00,0.00,513.00,369660.00,0.00,0.00,0.00),('1','143','866','257862',4905123,'2517','382',93072.34,93410.03,0.00,0.00,337.69,260021.30,0.00,0.00,0.00),('1','143','865','257862',4905124,'2518','382',121718.98,122305.21,0.00,0.00,586.23,451397.10,0.00,0.00,0.00),('1','143','866','257862',4905125,'2519','382',141904.62,142170.62,0.00,0.00,266.00,191520.00,0.00,0.00,0.00),('1','143','865','257863',4905126,'2516','382',148120.56,148120.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257863',4905127,'2517','382',93410.03,93912.36,0.00,0.00,502.33,386794.10,0.00,0.00,0.00),('1','143','865','257863',4905128,'2518','382',122305.21,122983.84,0.00,0.00,678.63,522545.10,0.00,0.00,0.00),('1','143','866','257863',4905129,'2519','382',142170.62,142658.32,0.00,0.00,487.70,351294.00,0.00,0.00,0.00),('1','143','865','257864',4905130,'2516','382',148120.56,148120.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257864',4905131,'2517','382',93912.36,94573.82,0.00,0.00,661.46,509324.20,0.00,0.00,0.00),('1','143','865','257864',4905132,'2518','382',122983.84,123490.39,0.00,0.00,506.55,390043.50,0.00,0.00,0.00),('1','143','866','257864',4905133,'2519','382',142658.32,143104.32,0.00,0.00,446.00,321120.00,0.00,0.00,0.00),('1','143','865','257865',4905134,'2516','382',148120.56,148120.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257865',4905135,'2517','382',94573.82,95259.87,0.00,0.00,686.05,528258.50,0.00,0.00,0.00),('1','143','865','257865',4905136,'2518','382',123490.39,124139.30,0.00,0.00,648.91,499660.70,0.00,0.00,0.00),('1','143','866','257865',4905137,'2519','382',143104.32,143396.32,0.00,0.00,292.00,210240.00,0.00,0.00,0.00),('1','143','865','257866',4905138,'2516','382',148120.56,148120.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257866',4905139,'2517','382',95259.87,95718.63,0.00,0.00,458.76,353245.20,0.00,0.00,0.00),('1','143','865','257866',4905140,'2518','382',124139.30,124877.30,0.00,0.00,738.00,568260.00,0.00,0.00,0.00),('1','143','866','257866',4905141,'2519','382',143396.32,144158.32,0.00,0.00,762.00,548640.00,0.00,0.00,0.00),('1','143','865','257867',4905142,'2516','382',148120.56,148220.56,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','143','866','257867',4905143,'2517','382',95718.63,96214.88,0.00,0.00,496.25,382112.50,0.00,0.00,0.00),('1','143','865','257867',4905144,'2518','382',124877.30,125657.13,0.00,0.00,779.83,600469.10,0.00,0.00,0.00),('1','143','866','257867',4905145,'2519','382',144158.32,144415.82,0.00,0.00,257.50,185400.00,0.00,0.00,0.00),('1','143','865','257868',4905146,'2516','382',148220.56,148220.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257868',4905147,'2517','382',96214.88,96822.44,0.00,0.00,607.56,467821.20,0.00,0.00,0.00),('1','143','865','257868',4905148,'2518','382',125657.13,126261.14,0.00,0.00,604.01,465087.70,0.00,0.00,0.00),('1','143','866','257868',4905149,'2519','382',144415.82,144663.82,0.00,0.00,248.00,178560.00,0.00,0.00,0.00),('1','143','865','257869',4905150,'2516','382',148220.56,148220.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257869',4905151,'2517','382',96822.44,97375.91,0.00,0.00,553.47,426171.90,0.00,0.00,0.00),('1','143','865','257869',4905152,'2518','382',126261.14,126919.59,0.00,0.00,658.45,507006.50,0.00,0.00,0.00),('1','143','866','257869',4905153,'2519','382',144663.82,145106.32,0.00,0.00,442.50,318600.00,0.00,0.00,0.00),('1','143','865','257870',4905154,'2516','382',148220.56,148320.56,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','143','866','257870',4905155,'2517','382',97375.91,98429.32,0.00,0.00,1053.41,811125.70,0.00,0.00,0.00),('1','143','865','257870',4905156,'2518','382',126919.59,126919.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257870',4905157,'2519','382',145106.32,145449.58,0.00,0.00,343.26,264310.20,0.00,0.00,0.00),('1','143','865','257871',4905158,'2516','382',148320.56,148420.56,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','143','866','257871',4905159,'2517','382',98429.32,99053.36,0.00,0.00,624.04,480510.80,0.00,0.00,0.00),('1','143','865','257871',4905160,'2518','382',126919.59,128089.40,0.00,0.00,1169.81,900753.70,0.00,0.00,0.00),('1','143','866','257871',4905161,'2519','382',145449.58,146086.58,0.00,0.00,637.00,458640.00,0.00,0.00,0.00),('1','143','865','257872',4905162,'2516','382',148420.56,148420.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257872',4905163,'2517','382',99053.36,99714.15,0.00,0.00,660.79,508808.30,0.00,0.00,0.00),('1','143','865','257872',4905164,'2518','382',128089.40,128915.37,0.00,0.00,825.97,635996.90,0.00,0.00,0.00),('1','143','866','257872',4905165,'2519','382',146086.58,146884.73,0.00,0.00,798.15,574668.00,0.00,0.00,0.00),('1','143','865','257873',4905166,'2516','382',148420.56,148620.56,0.00,0.00,200.00,144000.00,0.00,0.00,0.00),('1','143','866','257873',4905167,'2517','382',99714.15,99979.89,0.00,0.00,265.74,204619.80,0.00,0.00,0.00),('1','143','865','257873',4905168,'2518','382',128915.37,130123.33,0.00,0.00,1207.96,930129.20,0.00,0.00,0.00),('1','143','866','257873',4905169,'2519','382',146884.73,146884.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257874',4905170,'2516','382',148620.56,149121.56,0.00,0.00,501.00,360720.00,0.00,0.00,0.00),('1','143','866','257874',4905171,'2517','382',99979.89,100620.17,0.00,0.00,640.28,493015.60,0.00,0.00,0.00),('1','143','865','257874',4905172,'2518','382',130123.33,130864.09,0.00,0.00,740.76,570385.20,0.00,0.00,0.00),('1','143','866','257874',4905173,'2519','382',146884.73,146884.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257875',4905174,'2516','382',149121.56,149121.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257875',4905175,'2517','382',100620.17,100832.38,0.00,0.00,212.21,163401.70,0.00,0.00,0.00),('1','143','865','257875',4905176,'2518','382',130864.09,132126.13,0.00,0.00,1262.04,971770.80,0.00,0.00,0.00),('1','143','866','257875',4905177,'2519','382',146884.73,147292.23,0.00,0.00,407.50,293400.00,0.00,0.00,0.00),('1','143','865','257876',4905178,'2516','382',149121.56,149526.56,0.00,0.00,405.00,291600.00,0.00,0.00,0.00),('1','143','866','257876',4905179,'2517','382',100832.38,100832.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257876',4905180,'2518','382',132126.13,133467.62,0.00,0.00,1341.49,1032947.30,0.00,0.00,0.00),('1','143','866','257876',4905181,'2519','382',147292.23,147292.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257877',4905182,'2516','382',149526.56,149526.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257877',4905183,'2517','382',100832.38,101343.17,0.00,0.00,510.79,393308.30,0.00,0.00,0.00),('1','143','865','257877',4905184,'2518','382',133467.62,134040.25,0.00,0.00,572.63,440925.10,0.00,0.00,0.00),('1','143','866','257877',4905185,'2519','382',147292.23,147787.23,0.00,0.00,495.00,356400.00,0.00,0.00,0.00),('1','143','865','257878',4905186,'2516','382',149526.56,149526.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257878',4905187,'2518','382',134040.25,134784.98,0.00,0.00,744.73,573442.10,0.00,0.00,0.00),('1','143','866','257878',4905188,'2519','382',147787.23,148087.23,0.00,0.00,300.00,216000.00,0.00,0.00,0.00),('1','143','866','257878',4905189,'2517','382',101343.17,101936.21,0.00,0.00,593.04,456640.80,0.00,0.00,0.00),('1','143','865','257879',4905190,'2516','382',149526.56,149526.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257879',4905191,'2517','382',101936.21,102058.21,0.00,0.00,122.00,93940.00,0.00,0.00,0.00),('1','143','865','257879',4905192,'2518','382',134784.98,135912.53,0.00,0.00,1127.55,868213.50,0.00,0.00,0.00),('1','143','866','257879',4905193,'2519','382',148087.23,148262.23,0.00,0.00,175.00,126000.00,0.00,0.00,0.00),('1','143','865','257880',4905194,'2516','382',149526.56,149526.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257880',4905195,'2517','382',102058.21,102781.69,0.00,0.00,723.48,557079.60,0.00,0.00,0.00),('1','143','865','257880',4905196,'2518','382',135912.53,136550.06,0.00,0.00,637.53,490898.10,0.00,0.00,0.00),('1','143','866','257880',4905197,'2519','382',148262.23,148767.23,0.00,0.00,505.00,363600.00,0.00,0.00,0.00),('1','143','865','257881',4905198,'2516','382',149526.56,149891.56,0.00,0.00,365.00,262800.00,0.00,0.00,0.00),('1','143','866','257881',4905199,'2517','382',102781.69,103230.74,0.00,0.00,449.05,345768.50,0.00,0.00,0.00),('1','143','865','257881',4905200,'2518','382',136550.06,137720.13,0.00,0.00,1170.07,900953.90,0.00,0.00,0.00),('1','143','866','257881',4905201,'2519','382',148767.23,148767.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257882',4905202,'2516','382',149891.56,150065.56,0.00,0.00,174.00,125280.00,0.00,0.00,0.00),('1','143','866','257882',4905203,'2517','382',103230.74,104063.14,0.00,0.00,832.40,640948.00,0.00,0.00,0.00),('1','143','865','257882',4905204,'2518','382',137720.13,138461.51,0.00,0.00,741.38,570862.60,0.00,0.00,0.00),('1','143','866','257882',4905205,'2519','382',148767.23,148991.23,0.00,0.00,224.00,161280.00,0.00,0.00,0.00),('1','143','865','257883',4905206,'2516','382',150065.56,150065.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257883',4905207,'2517','382',104063.14,104318.71,0.00,0.00,255.57,196788.90,0.00,0.00,0.00),('1','143','865','257883',4905208,'2518','382',138461.51,139576.60,0.00,0.00,1115.09,858619.30,0.00,0.00,0.00),('1','143','866','257883',4905209,'2519','382',148991.23,149206.23,0.00,0.00,215.00,154800.00,0.00,0.00,0.00),('1','143','865','257884',4905210,'2516','382',150065.56,150065.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257884',4905211,'2517','382',104318.71,105167.93,0.00,0.00,849.22,653899.40,0.00,0.00,0.00),('1','143','865','257884',4905212,'2518','382',139576.60,140514.50,0.00,0.00,937.90,722183.00,0.00,0.00,0.00),('1','143','866','257884',4905213,'2519','382',149206.23,149655.23,0.00,0.00,449.00,323280.00,0.00,0.00,0.00),('1','143','865','257885',4905214,'2516','382',150065.56,150065.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257885',4905215,'2517','382',105167.93,105676.86,0.00,0.00,508.93,391876.10,0.00,0.00,0.00),('1','143','865','257885',4905216,'2518','382',140514.50,141563.09,0.00,0.00,1048.59,807414.30,0.00,0.00,0.00),('1','143','866','257885',4905217,'2519','382',149655.23,150159.23,0.00,0.00,504.00,362880.00,0.00,0.00,0.00),('1','143','865','257886',4905218,'2516','382',150065.56,150315.56,0.00,0.00,250.00,182500.00,0.00,0.00,0.00),('1','143','865','257886',4905219,'2518','382',141563.09,142168.01,0.00,0.00,604.92,465788.40,0.00,0.00,0.00),('1','143','866','257886',4905220,'2519','382',150159.23,150249.23,0.00,0.00,90.00,64800.00,0.00,0.00,0.00),('1','143','866','257886',4905221,'2517','382',105676.86,105930.41,0.00,0.00,253.55,195233.50,0.00,0.00,0.00),('1','143','865','257887',4905222,'2516','382',150315.56,150345.56,0.00,0.00,30.00,21600.00,0.00,0.00,0.00),('1','143','866','257887',4905223,'2517','382',105930.41,106202.72,0.00,0.00,272.31,209678.70,0.00,0.00,0.00),('1','143','865','257887',4905224,'2518','382',142168.01,142600.18,0.00,0.00,432.17,332770.90,0.00,0.00,0.00),('1','143','866','257887',4905225,'2519','382',150249.23,150499.23,0.00,0.00,250.00,180000.00,0.00,0.00,0.00),('1','143','865','257888',4905226,'2516','382',150345.56,150345.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257888',4905227,'2517','382',106202.72,106957.01,0.00,0.00,754.29,580803.30,0.00,0.00,0.00),('1','143','865','257888',4905228,'2518','382',142600.18,143500.28,0.00,0.00,900.10,693077.00,0.00,0.00,0.00),('1','143','866','257888',4905229,'2519','382',150499.23,151371.60,0.00,0.00,872.37,628106.40,0.00,0.00,0.00),('1','143','865','257889',4905230,'2516','382',150345.56,150385.56,0.00,0.00,40.00,28800.00,0.00,0.00,0.00),('1','143','866','257889',4905231,'2517','382',106957.01,107106.81,0.00,0.00,149.80,115346.00,0.00,0.00,0.00),('1','143','865','257889',4905232,'2518','382',143500.28,144700.99,0.00,0.00,1200.71,924546.70,0.00,0.00,0.00),('1','143','866','257889',4905233,'2519','382',151371.60,152369.98,0.00,0.00,998.38,718833.60,0.00,0.00,0.00),('1','143','865','257890',4905234,'2516','382',150385.56,150385.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257890',4905235,'2517','382',107106.81,107784.07,0.00,0.00,677.26,521490.20,0.00,0.00,0.00),('1','143','865','257890',4905236,'2518','382',144700.99,145473.06,0.00,0.00,772.07,594493.90,0.00,0.00,0.00),('1','143','866','257890',4905237,'2519','382',152369.98,152937.98,0.00,0.00,568.00,408960.00,0.00,0.00,0.00),('1','143','865','257891',4905238,'2516','382',150385.56,150385.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257891',4905239,'2517','382',107784.07,108369.87,0.00,0.00,585.80,451066.00,0.00,0.00,0.00),('1','143','865','257891',4905240,'2518','382',145473.06,146143.12,0.00,0.00,670.06,515946.20,0.00,0.00,0.00),('1','143','866','257891',4905241,'2519','382',152937.98,153425.20,0.00,0.00,487.22,350798.40,0.00,0.00,0.00),('1','143','865','257892',4905242,'2516','382',150385.56,150385.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257892',4905243,'2517','382',108369.87,109228.49,0.00,0.00,858.62,661137.40,0.00,0.00,0.00),('1','143','865','257892',4905244,'2518','382',146143.12,146776.83,0.00,0.00,633.71,487956.70,0.00,0.00,0.00),('1','143','866','257892',4905245,'2519','382',153425.20,153663.20,0.00,0.00,238.00,171360.00,0.00,0.00,0.00),('1','143','865','257893',4905246,'2516','382',150385.56,150601.56,0.00,0.00,216.00,155520.00,0.00,0.00,0.00),('1','143','866','257893',4905247,'2517','382',109228.49,110130.01,0.00,0.00,901.52,694170.40,0.00,0.00,0.00),('1','143','865','257893',4905248,'2518','382',146776.83,147425.96,0.00,0.00,649.13,499830.10,0.00,0.00,0.00),('1','143','866','257893',4905249,'2519','382',153663.20,153963.20,0.00,0.00,300.00,216000.00,0.00,0.00,0.00),('1','143','865','257894',4905250,'2516','382',150601.56,150730.51,0.00,0.00,128.95,92844.00,0.00,0.00,0.00),('1','143','866','257894',4905251,'2517','382',110130.01,110866.07,0.00,0.00,736.06,566766.20,0.00,0.00,0.00),('1','143','865','257894',4905252,'2518','382',147425.96,148135.41,0.00,0.00,709.45,546276.50,0.00,0.00,0.00),('1','143','866','257894',4905253,'2519','382',153963.20,154148.20,0.00,0.00,185.00,133200.00,0.00,0.00,0.00),('1','143','865','257895',4905254,'2516','382',150730.51,151004.51,0.00,0.00,274.00,197280.00,0.00,0.00,0.00),('1','143','866','257895',4905255,'2517','382',110866.07,111774.53,0.00,0.00,908.46,699514.20,0.00,0.00,0.00),('1','143','865','257895',4905256,'2518','382',148135.41,148722.11,0.00,0.00,586.70,451759.00,0.00,0.00,0.00),('1','143','866','257895',4905257,'2519','382',154148.20,154293.20,0.00,0.00,145.00,104400.00,0.00,0.00,0.00),('1','143','865','257896',4905258,'2516','382',151004.51,151004.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257896',4905259,'2517','382',111774.53,112681.95,0.00,0.00,907.42,698713.40,0.00,0.00,0.00),('1','143','865','257896',4905260,'2518','382',148722.11,149429.35,0.00,0.00,707.24,544574.80,0.00,0.00,0.00),('1','143','866','257896',4905261,'2519','382',154293.20,154383.14,0.00,0.00,89.94,64756.80,0.00,0.00,0.00),('1','143','865','257897',4905262,'2516','382',151004.51,151004.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257897',4905263,'2518','382',149429.35,149992.48,0.00,0.00,563.13,433610.10,0.00,0.00,0.00),('1','143','866','257897',4905264,'2519','382',154383.14,154790.14,0.00,0.00,407.00,293040.00,0.00,0.00,0.00),('1','143','866','257897',4905265,'2517','382',112681.95,113668.88,0.00,0.00,986.93,759936.10,0.00,0.00,0.00),('1','143','865','257898',4905266,'2516','382',151004.51,151004.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257898',4905267,'2517','382',113668.88,113668.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257898',4905268,'2518','382',149992.48,149992.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257898',4905269,'2519','382',154790.14,154790.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257899',4905270,'2516','382',151004.51,151109.51,0.00,0.00,105.00,75600.00,0.00,0.00,0.00),('1','143','866','257899',4905271,'2517','382',113668.88,114342.62,0.00,0.00,673.74,518779.80,0.00,0.00,0.00),('1','143','865','257899',4905272,'2518','382',149992.48,150650.45,0.00,0.00,657.97,506636.90,0.00,0.00,0.00),('1','143','866','257899',4905273,'2519','382',154790.14,155293.75,0.00,0.00,503.61,362599.20,0.00,0.00,0.00),('1','143','865','257900',4905274,'2516','382',151109.51,151449.51,0.00,0.00,340.00,244800.00,0.00,0.00,0.00),('1','143','865','257900',4905275,'2518','382',150650.45,151185.97,0.00,0.00,535.52,412350.40,0.00,0.00,0.00),('1','143','866','257900',4905276,'2519','382',155293.75,155842.36,0.00,0.00,548.61,394999.20,0.00,0.00,0.00),('1','143','866','257900',4905277,'2517','382',114342.62,115198.90,0.00,0.00,856.28,659335.60,0.00,0.00,0.00),('1','143','865','257901',4905278,'2516','382',151449.51,151449.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257901',4905279,'2517','382',115198.90,116050.18,0.00,0.00,851.28,655485.60,0.00,0.00,0.00),('1','143','865','257901',4905280,'2518','382',151185.97,152102.01,0.00,0.00,916.04,705350.80,0.00,0.00,0.00),('1','143','866','257901',4905281,'2519','382',155842.36,156175.98,0.00,0.00,333.62,240206.40,0.00,0.00,0.00),('1','143','865','257902',4905282,'2516','382',151449.51,151449.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257902',4905283,'2517','382',116050.18,116896.36,0.00,0.00,846.18,651558.60,0.00,0.00,0.00),('1','143','865','257902',4905284,'2518','382',152102.01,153130.62,0.00,0.00,1028.61,792029.70,0.00,0.00,0.00),('1','143','866','257902',4905285,'2519','382',156175.98,156255.98,0.00,0.00,80.00,57600.00,0.00,0.00,0.00),('1','143','865','257903',4905286,'2516','382',151449.51,152119.45,0.00,0.00,669.94,482356.80,0.00,0.00,0.00),('1','143','866','257903',4905287,'2517','382',116896.36,117832.01,0.00,0.00,935.65,720450.50,0.00,0.00,0.00),('1','143','865','257903',4905288,'2518','382',153130.62,153592.30,0.00,0.00,461.68,355493.60,0.00,0.00,0.00),('1','143','866','257903',4905289,'2519','382',156255.98,156850.89,0.00,0.00,594.91,428335.20,0.00,0.00,0.00),('1','143','865','257904',4905290,'2516','382',152119.45,152119.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257904',4905291,'2517','382',117832.01,118559.01,0.00,0.00,727.00,559790.00,0.00,0.00,0.00),('1','143','865','257904',4905292,'2518','382',153592.30,154136.35,0.00,0.00,544.05,418918.50,0.00,0.00,0.00),('1','143','866','257904',4905293,'2519','382',156850.89,157090.89,0.00,0.00,240.00,172800.00,0.00,0.00,0.00),('1','143','865','257905',4905294,'2516','382',152119.45,152302.45,0.00,0.00,183.00,131760.00,0.00,0.00,0.00),('1','143','865','257905',4905295,'2518','382',154136.35,154580.28,0.00,0.00,443.93,341826.10,0.00,0.00,0.00),('1','143','866','257905',4905296,'2519','382',157090.89,157100.89,0.00,0.00,10.00,7200.00,0.00,0.00,0.00),('1','143','866','257905',4905297,'2517','382',118559.01,119315.96,0.00,0.00,756.95,582851.50,0.00,0.00,0.00),('1','143','865','257906',4905298,'2516','382',152302.45,152302.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257906',4905299,'2517','382',119315.96,120658.48,0.00,0.00,1342.52,1033740.40,0.00,0.00,0.00),('1','143','865','257906',4905300,'2518','382',154580.28,154599.38,0.00,0.00,19.10,14707.00,0.00,0.00,0.00),('1','143','866','257906',4905301,'2519','382',157100.89,157550.89,0.00,0.00,450.00,324000.00,0.00,0.00,0.00),('1','143','865','257907',4905302,'2516','382',152302.45,152302.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257907',4905303,'2518','382',154599.38,154609.97,0.00,0.00,10.59,8154.30,0.00,0.00,0.00),('1','143','866','257907',4905304,'2519','382',157550.89,157826.00,0.00,0.00,275.11,198079.20,0.00,0.00,0.00),('1','143','866','257907',4905305,'2517','382',120658.48,121731.45,0.00,0.00,1072.97,826186.90,0.00,0.00,0.00),('1','143','865','257908',4905306,'2516','382',152302.45,152343.04,0.00,0.00,40.59,31254.30,0.00,0.00,0.00),('1','143','866','257908',4905307,'2517','382',121731.45,122852.90,0.00,0.00,1121.45,863516.50,0.00,0.00,0.00),('1','143','865','257908',4905308,'2518','382',154609.97,154609.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257908',4905309,'2519','382',157826.00,157976.00,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','143','865','257909',4905310,'2516','382',152343.04,152792.74,0.00,0.00,449.70,346269.00,0.00,0.00,0.00),('1','143','866','257909',4905311,'2517','382',122852.90,123864.10,0.00,0.00,1011.20,778624.00,0.00,0.00,0.00),('1','143','865','257909',4905312,'2518','382',154609.97,154615.97,0.00,0.00,6.00,4620.00,0.00,0.00,0.00),('1','143','866','257909',4905313,'2519','382',157976.00,158156.26,0.00,0.00,180.26,129787.20,0.00,0.00,0.00),('1','143','865','257910',4905314,'2516','382',152792.74,153163.57,0.00,0.00,370.83,285539.10,0.00,0.00,0.00),('1','143','866','257910',4905315,'2517','382',123864.10,124536.08,0.00,0.00,671.98,517424.60,0.00,0.00,0.00),('1','143','865','257910',4905316,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257910',4905317,'2519','382',158156.26,158206.26,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','143','865','257911',4905318,'2516','382',153163.57,153163.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257911',4905319,'2517','382',124536.08,124536.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257911',4905320,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257911',4905321,'2519','382',158206.26,158206.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257912',4905322,'2516','382',153163.57,153460.67,0.00,0.00,297.10,228767.00,0.00,0.00,0.00),('1','143','866','257912',4905323,'2517','382',124536.08,125419.20,0.00,0.00,883.12,680002.40,0.00,0.00,0.00),('1','143','865','257912',4905324,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257912',4905325,'2519','382',158206.26,158366.26,0.00,0.00,160.00,115200.00,0.00,0.00,0.00),('1','143','865','257913',4905326,'2516','382',153460.67,154042.49,0.00,0.00,581.82,448001.40,0.00,0.00,0.00),('1','143','866','257913',4905327,'2517','382',125419.20,126073.21,0.00,0.00,654.01,503587.70,0.00,0.00,0.00),('1','143','865','257913',4905328,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257913',4905329,'2519','382',158366.26,158431.26,0.00,0.00,65.00,46800.00,0.00,0.00,0.00),('1','143','865','257914',4905330,'2516','382',154042.49,154545.40,0.00,0.00,502.91,387240.70,0.00,0.00,0.00),('1','143','866','257914',4905331,'2517','382',126073.21,126992.80,0.00,0.00,919.59,708084.30,0.00,0.00,0.00),('1','143','865','257914',4905332,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257914',4905333,'2519','382',158431.26,158521.26,0.00,0.00,90.00,64800.00,0.00,0.00,0.00),('1','143','865','257915',4905334,'2516','382',154545.40,155040.51,0.00,0.00,495.11,381234.70,0.00,0.00,0.00),('1','143','865','257915',4905335,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257915',4905336,'2519','382',158521.26,158593.26,0.00,0.00,72.00,51840.00,0.00,0.00,0.00),('1','143','866','257915',4905337,'2517','382',126992.80,127747.62,0.00,0.00,754.82,581211.40,0.00,0.00,0.00),('1','143','865','257916',4905338,'2516','382',155040.51,155527.11,0.00,0.00,486.60,374682.00,0.00,0.00,0.00),('1','143','866','257916',4905339,'2517','382',127747.62,128714.44,0.00,0.00,966.82,744451.40,0.00,0.00,0.00),('1','143','865','257916',4905340,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257916',4905341,'2519','382',158593.26,158851.26,0.00,0.00,258.00,185760.00,0.00,0.00,0.00),('1','143','865','257917',4905342,'2516','382',155527.11,156068.11,0.00,0.00,541.00,416570.00,0.00,0.00,0.00),('1','143','866','257917',4905343,'2517','382',128714.44,129714.47,0.00,0.00,1000.03,770023.10,0.00,0.00,0.00),('1','143','865','257917',4905344,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257917',4905345,'2519','382',158851.26,159051.26,0.00,0.00,200.00,144000.00,0.00,0.00,0.00),('1','143','865','257918',4905346,'2516','382',156068.11,156531.01,0.00,0.00,462.90,356433.00,0.00,0.00,0.00),('1','143','866','257918',4905347,'2517','382',129714.47,130634.89,0.00,0.00,920.42,708723.40,0.00,0.00,0.00),('1','143','865','257918',4905348,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257918',4905349,'2519','382',159051.26,159176.26,0.00,0.00,125.00,90000.00,0.00,0.00,0.00),('1','143','865','257919',4905350,'2516','382',156531.01,157273.89,0.00,0.00,742.88,572017.60,0.00,0.00,0.00),('1','143','866','257919',4905351,'2517','382',130634.89,131100.15,0.00,0.00,465.26,358250.20,0.00,0.00,0.00),('1','143','865','257919',4905352,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257919',4905353,'2519','382',159176.26,159259.26,0.00,0.00,83.00,59760.00,0.00,0.00,0.00),('1','143','865','257920',4905354,'2516','382',157273.89,157643.72,0.00,0.00,369.83,284769.10,0.00,0.00,0.00),('1','143','865','257920',4905355,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257920',4905356,'2519','382',159259.26,159595.26,0.00,0.00,336.00,241920.00,0.00,0.00,0.00),('1','143','866','257920',4905357,'2517','382',131100.15,131785.96,0.00,0.00,685.81,528073.70,0.00,0.00,0.00),('1','143','865','257921',4905358,'2516','382',157643.72,158369.33,0.00,0.00,725.61,558719.70,0.00,0.00,0.00),('1','143','866','257921',4905359,'2517','382',131785.96,132566.64,0.00,0.00,780.68,601123.60,0.00,0.00,0.00),('1','143','865','257921',4905360,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257921',4905361,'2519','382',159595.26,159635.26,0.00,0.00,40.00,28800.00,0.00,0.00,0.00),('1','143','865','257922',4905362,'2516','382',158369.33,158437.46,0.00,0.00,68.13,52460.10,0.00,0.00,0.00),('1','143','865','257922',4905363,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257922',4905364,'2519','382',159635.26,159700.26,0.00,0.00,65.00,46800.00,0.00,0.00,0.00),('1','143','866','257922',4905365,'2517','382',132566.64,132636.97,0.00,0.00,70.33,54154.10,0.00,0.00,0.00),('1','143','865','257923',4905366,'2516','382',158437.46,158966.04,0.00,0.00,528.58,407006.60,0.00,0.00,0.00),('1','143','866','257923',4905367,'2517','382',132636.97,133385.33,0.00,0.00,748.36,576237.20,0.00,0.00,0.00),('1','143','865','257923',4905368,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257923',4905369,'2519','382',159700.26,159874.76,0.00,0.00,174.50,125640.00,0.00,0.00,0.00),('1','143','865','257924',4905370,'2516','382',158966.04,159469.67,0.00,0.00,503.63,387795.10,0.00,0.00,0.00),('1','143','866','257924',4905371,'2517','382',133385.33,134175.77,0.00,0.00,790.44,608638.80,0.00,0.00,0.00),('1','143','865','257924',4905372,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257924',4905373,'2519','382',159874.76,159973.76,0.00,0.00,99.00,71280.00,0.00,0.00,0.00),('1','143','865','257925',4905374,'2516','382',159469.67,160022.85,0.00,0.00,553.18,425948.60,0.00,0.00,0.00),('1','143','866','257925',4905375,'2517','382',134175.77,134987.42,0.00,0.00,811.65,624970.50,0.00,0.00,0.00),('1','143','865','257925',4905376,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257925',4905377,'2519','382',159973.76,160022.76,0.00,0.00,49.00,35280.00,0.00,0.00,0.00),('1','143','865','257926',4905378,'2516','382',160022.85,160379.27,0.00,0.00,356.42,274443.40,0.00,0.00,0.00),('1','143','866','257926',4905379,'2517','382',134987.42,135866.11,0.00,0.00,878.69,676591.30,0.00,0.00,0.00),('1','143','865','257926',4905380,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257926',4905381,'2519','382',160022.76,160069.76,0.00,0.00,47.00,33840.00,0.00,0.00,0.00),('1','143','865','257927',4905382,'2516','382',160379.27,161082.68,0.00,0.00,703.41,541625.70,0.00,0.00,0.00),('1','143','866','257927',4905383,'2517','382',135866.11,136485.81,0.00,0.00,619.70,477169.00,0.00,0.00,0.00),('1','143','865','257927',4905384,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257927',4905385,'2519','382',160069.76,160166.99,0.00,0.00,97.23,70005.60,0.00,0.00,0.00),('1','143','865','257928',4905386,'2516','382',161082.68,161472.58,0.00,0.00,389.90,300223.00,0.00,0.00,0.00),('1','143','865','257928',4905387,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257928',4905388,'2519','382',160166.99,160364.99,0.00,0.00,198.00,142560.00,0.00,0.00,0.00),('1','143','866','257928',4905389,'2517','382',136485.81,137147.73,0.00,0.00,661.92,509678.40,0.00,0.00,0.00),('1','143','865','257929',4905390,'2516','382',161472.58,162105.36,0.00,0.00,632.78,487240.60,0.00,0.00,0.00),('1','143','866','257929',4905391,'2517','382',137147.73,137708.43,0.00,0.00,560.70,431739.00,0.00,0.00,0.00),('1','143','865','257929',4905392,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257929',4905393,'2519','382',160364.99,160414.99,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','143','865','257930',4905394,'2516','382',162105.36,162551.34,0.00,0.00,445.98,343404.60,0.00,0.00,0.00),('1','143','866','257930',4905395,'2517','382',137708.43,138377.14,0.00,0.00,668.71,514906.70,0.00,0.00,0.00),('1','143','865','257930',4905396,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257930',4905397,'2519','382',160414.99,160493.99,0.00,0.00,79.00,56880.00,0.00,0.00,0.00),('1','143','865','257931',4905398,'2516','382',162551.34,163232.21,0.00,0.00,680.87,524269.90,0.00,0.00,0.00),('1','143','866','257931',4905399,'2517','382',138377.14,138802.53,0.00,0.00,425.39,327550.30,0.00,0.00,0.00),('1','143','865','257931',4905400,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257931',4905401,'2519','382',160493.99,160703.99,0.00,0.00,210.00,151200.00,0.00,0.00,0.00),('1','143','865','257932',4905402,'2516','382',163232.21,163838.95,0.00,0.00,606.74,467189.80,0.00,0.00,0.00),('1','143','866','257932',4905403,'2517','382',138802.53,139425.63,0.00,0.00,623.10,479787.00,0.00,0.00,0.00),('1','143','865','257932',4905404,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257932',4905405,'2519','382',160703.99,160890.43,0.00,0.00,186.44,134236.80,0.00,0.00,0.00),('1','143','865','257933',4905406,'2516','382',163838.95,164274.35,0.00,0.00,435.40,335258.00,0.00,0.00,0.00),('1','143','865','257933',4905407,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257933',4905408,'2519','382',160890.43,161110.43,0.00,0.00,220.00,158400.00,0.00,0.00,0.00),('1','143','866','257933',4905409,'2517','382',139425.63,140054.93,0.00,0.00,629.30,484561.00,0.00,0.00,0.00),('1','143','865','257934',4905410,'2516','382',164274.35,164753.54,0.00,0.00,479.19,368976.30,0.00,0.00,0.00),('1','143','866','257934',4905411,'2517','382',140054.93,140790.41,0.00,0.00,735.48,566319.60,0.00,0.00,0.00),('1','143','865','257934',4905412,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257934',4905413,'2519','382',161110.43,161150.43,0.00,0.00,40.00,28800.00,0.00,0.00,0.00),('1','143','865','257935',4905414,'2516','382',164753.54,165332.83,0.00,0.00,579.29,446053.30,0.00,0.00,0.00),('1','143','866','257935',4905415,'2517','382',140790.41,141494.18,0.00,0.00,703.77,541902.90,0.00,0.00,0.00),('1','143','865','257935',4905416,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257935',4905417,'2519','382',161150.43,161357.80,0.00,0.00,207.37,149306.40,0.00,0.00,0.00),('1','143','865','257936',4905418,'2516','382',165332.83,165991.54,0.00,0.00,658.71,507206.70,0.00,0.00,0.00),('1','143','866','257936',4905419,'2517','382',141494.18,142256.55,0.00,0.00,762.37,587024.90,0.00,0.00,0.00),('1','143','865','257936',4905420,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257936',4905421,'2519','382',161357.80,161487.80,0.00,0.00,130.00,93600.00,0.00,0.00,0.00),('1','143','865','257937',4905422,'2516','382',165991.54,166709.19,0.00,0.00,717.65,552590.50,0.00,0.00,0.00),('1','143','866','257937',4905423,'2517','382',142256.55,142929.26,0.00,0.00,672.71,517986.70,0.00,0.00,0.00),('1','143','865','257937',4905424,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257937',4905425,'2519','382',161487.80,161627.80,0.00,0.00,140.00,100800.00,0.00,0.00,0.00),('1','143','865','257938',4905426,'2516','382',166709.19,167417.97,0.00,0.00,708.78,545760.60,0.00,0.00,0.00),('1','143','866','257938',4905427,'2517','382',142929.26,143388.69,0.00,0.00,459.43,353761.10,0.00,0.00,0.00),('1','143','865','257938',4905428,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257938',4905429,'2519','382',161627.80,161692.80,0.00,0.00,65.00,46800.00,0.00,0.00,0.00),('1','143','865','257939',4905430,'2516','382',167417.97,167990.21,0.00,0.00,572.24,440624.80,0.00,0.00,0.00),('1','143','865','257939',4905431,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257939',4905432,'2519','382',161692.80,161832.80,0.00,0.00,140.00,100800.00,0.00,0.00,0.00),('1','143','866','257939',4905433,'2517','382',143388.69,144344.31,0.00,0.00,955.62,735827.40,0.00,0.00,0.00),('1','143','865','257940',4905434,'2516','382',167990.21,168635.43,0.00,0.00,645.22,496819.40,0.00,0.00,0.00),('1','143','866','257940',4905435,'2517','382',144344.31,145032.41,0.00,0.00,688.10,529837.00,0.00,0.00,0.00),('1','143','865','257940',4905436,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257940',4905437,'2519','382',161832.80,161832.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257941',4905438,'2516','382',168635.43,169221.12,0.00,0.00,585.69,450981.30,0.00,0.00,0.00),('1','143','865','257941',4905439,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257941',4905440,'2519','382',161832.80,161975.52,0.00,0.00,142.72,102758.40,0.00,0.00,0.00),('1','143','866','257941',4905441,'2517','382',145032.41,145627.46,0.00,0.00,595.05,458188.50,0.00,0.00,0.00),('1','143','865','257942',4905442,'2516','382',169221.12,169881.82,0.00,0.00,660.70,508739.00,0.00,0.00,0.00),('1','143','866','257942',4905443,'2517','382',145627.46,146311.01,0.00,0.00,683.55,526333.50,0.00,0.00,0.00),('1','143','865','257942',4905444,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257942',4905445,'2519','382',161975.52,162325.52,0.00,0.00,350.00,252000.00,0.00,0.00,0.00),('1','143','865','257943',4905446,'2516','382',169881.82,170477.73,0.00,0.00,595.91,458850.70,0.00,0.00,0.00),('1','143','866','257943',4905447,'2517','382',146311.01,147027.67,0.00,0.00,716.66,551828.20,0.00,0.00,0.00),('1','143','865','257943',4905448,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257943',4905449,'2519','382',162325.52,162425.52,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','143','865','257944',4905450,'2516','382',170477.73,171334.22,0.00,0.00,856.49,659497.30,0.00,0.00,0.00),('1','143','866','257944',4905451,'2517','382',147027.67,147657.85,0.00,0.00,630.18,485238.60,0.00,0.00,0.00),('1','143','865','257944',4905452,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257944',4905453,'2519','382',162425.52,162697.52,0.00,0.00,272.00,195840.00,0.00,0.00,0.00),('1','143','865','257945',4905454,'2516','382',171334.22,172044.17,0.00,0.00,709.95,546661.50,0.00,0.00,0.00),('1','143','866','257945',4905455,'2517','382',147657.85,148472.73,0.00,0.00,814.88,627457.60,0.00,0.00,0.00),('1','143','865','257945',4905456,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257945',4905457,'2519','382',162697.52,162882.52,0.00,0.00,185.00,133200.00,0.00,0.00,0.00),('1','143','865','257946',4905458,'2516','382',172044.17,172664.88,0.00,0.00,620.71,477946.70,0.00,0.00,0.00),('1','143','866','257946',4905459,'2517','382',148472.73,149161.80,0.00,0.00,689.07,530583.90,0.00,0.00,0.00),('1','143','865','257946',4905460,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257946',4905461,'2519','382',162882.52,162996.20,0.00,0.00,113.68,81849.60,0.00,0.00,0.00),('1','143','865','257947',4905462,'2516','382',172664.88,173323.26,0.00,0.00,658.38,506952.60,0.00,0.00,0.00),('1','143','865','257947',4905463,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257947',4905464,'2519','382',162996.20,163228.20,0.00,0.00,232.00,167040.00,0.00,0.00,0.00),('1','143','866','257947',4905465,'2517','382',149161.80,149799.42,0.00,0.00,637.62,490967.40,0.00,0.00,0.00),('1','143','865','257948',4905466,'2516','382',173323.26,173850.21,0.00,0.00,526.95,405751.50,0.00,0.00,0.00),('1','143','865','257948',4905467,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257948',4905468,'2519','382',163228.20,163318.20,0.00,0.00,90.00,64800.00,0.00,0.00,0.00),('1','143','866','257948',4905469,'2517','382',149799.42,150386.31,0.00,0.00,586.89,451905.30,0.00,0.00,0.00),('1','143','865','257949',4905470,'2516','382',173850.21,174472.47,0.00,0.00,622.26,479140.20,0.00,0.00,0.00),('1','143','866','257949',4905471,'2517','382',150386.31,151138.92,0.00,0.00,752.61,579509.70,0.00,0.00,0.00),('1','143','865','257949',4905472,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257949',4905473,'2519','382',163318.20,163318.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257950',4905474,'2516','382',174472.47,174733.97,0.00,0.00,261.50,201355.00,0.00,0.00,0.00),('1','143','866','257950',4905475,'2517','382',151138.92,151498.66,0.00,0.00,359.74,276999.80,0.00,0.00,0.00),('1','143','865','257950',4905476,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257950',4905477,'2519','382',163318.20,163400.20,0.00,0.00,82.00,59040.00,0.00,0.00,0.00),('1','143','865','257951',4905478,'2516','382',174733.97,175024.98,0.00,0.00,291.01,224077.70,0.00,0.00,0.00),('1','143','866','257951',4905479,'2517','382',151498.66,151690.35,0.00,0.00,191.69,147601.30,0.00,0.00,0.00),('1','143','865','257951',4905480,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257951',4905481,'2519','382',163400.20,163450.20,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','143','865','257952',4905482,'2516','382',175024.98,175782.59,0.00,0.00,757.61,583359.70,0.00,0.00,0.00),('1','143','866','257952',4905483,'2517','382',151690.35,152335.65,0.00,0.00,645.30,496881.00,0.00,0.00,0.00),('1','143','865','257952',4905484,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257952',4905485,'2519','382',163450.20,163650.70,0.00,0.00,200.50,144360.00,0.00,0.00,0.00),('1','143','865','257953',4905486,'2516','382',175782.59,175782.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257953',4905487,'2517','382',152335.65,152335.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257953',4905488,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257953',4905489,'2519','382',163650.70,163650.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','865','257954',4905490,'2516','382',175782.59,176480.29,0.00,0.00,697.70,537229.00,0.00,0.00,0.00),('1','143','866','257954',4905491,'2517','382',152335.65,152894.02,0.00,0.00,558.37,429944.90,0.00,0.00,0.00),('1','143','865','257954',4905492,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257954',4905493,'2519','382',163650.70,164020.70,0.00,0.00,370.00,266400.00,0.00,0.00,0.00),('1','143','865','257955',4905494,'2516','382',176480.29,177030.19,0.00,0.00,549.90,423423.00,0.00,0.00,0.00),('1','143','866','257955',4905495,'2517','382',152894.02,153378.72,0.00,0.00,484.70,373219.00,0.00,0.00,0.00),('1','143','865','257955',4905496,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257955',4905497,'2519','382',164020.70,164435.70,0.00,0.00,415.00,298800.00,0.00,0.00,0.00),('1','143','865','257956',4905498,'2516','382',177030.19,177659.95,0.00,0.00,629.76,484915.20,0.00,0.00,0.00),('1','143','866','257956',4905499,'2517','382',153378.72,154049.83,0.00,0.00,671.11,516754.70,0.00,0.00,0.00),('1','143','865','257956',4905500,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257956',4905501,'2519','382',164435.70,164491.70,0.00,0.00,56.00,40320.00,0.00,0.00,0.00),('1','143','865','257957',4905502,'2516','382',177659.95,178396.71,0.00,0.00,736.76,567305.20,0.00,0.00,0.00),('1','143','866','257957',4905503,'2517','382',154049.83,154753.29,0.00,0.00,703.46,541664.20,0.00,0.00,0.00),('1','143','865','257957',4905504,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257957',4905505,'2519','382',164491.70,164645.70,0.00,0.00,154.00,110880.00,0.00,0.00,0.00),('1','143','865','257958',4905506,'2516','382',178396.71,179046.59,0.00,0.00,649.88,500407.60,0.00,0.00,0.00),('1','143','865','257958',4905507,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257958',4905508,'2519','382',164645.70,164745.70,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','143','866','257958',4905509,'2517','382',154753.29,155420.96,0.00,0.00,667.67,514105.90,0.00,0.00,0.00),('1','143','865','257959',4905510,'2516','382',179046.59,179483.83,0.00,0.00,437.24,336674.80,0.00,0.00,0.00),('1','143','865','257959',4905511,'2518','382',154615.97,154615.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257959',4905512,'2519','382',164745.70,165045.70,0.00,0.00,300.00,216000.00,0.00,0.00,0.00),('1','143','866','257959',4905513,'2517','382',155420.96,156582.06,0.00,0.00,1161.10,894047.00,0.00,0.00,0.00),('1','143','865','257960',4905514,'2516','382',179483.83,179483.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257960',4905515,'2517','382',156582.06,157745.37,0.00,0.00,1163.31,895748.70,0.00,0.00,0.00),('1','143','865','257960',4905516,'2518','382',154615.97,155267.14,0.00,0.00,651.17,501400.90,0.00,0.00,0.00),('1','143','866','257960',4905517,'2519','382',165045.70,165295.70,0.00,0.00,250.00,180000.00,0.00,0.00,0.00),('1','143','865','257961',4905518,'2516','382',179483.83,179483.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','143','866','257961',4905519,'2517','382',157745.37,158682.73,0.00,0.00,937.36,721767.20,0.00,0.00,0.00),('1','143','865','257961',4905520,'2518','382',155267.14,155910.82,0.00,0.00,643.68,495633.60,0.00,0.00,0.00),('1','143','866','257961',4905521,'2519','382',165295.70,165433.70,0.00,0.00,138.00,99360.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730124 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','143','169016','382',266.00,312.00,0.00,3238.10,861334.60,975219.20,113884.60,499573),('1','143','169220','382',266.00,312.00,0.00,4800.80,1277012.80,1421619.60,144606.80,500101),('1','143','169328','382',266.00,312.00,0.00,2215.60,589349.60,659169.20,69819.60,500363),('1','143','169505','382',266.00,312.00,0.00,2534.20,674097.20,752016.40,77919.20,500822),('1','143','169745','382',266.00,312.00,0.00,4519.00,1202054.00,1329914.00,127860.00,501473),('1','143','169889','382',266.00,312.00,0.00,2956.60,786455.60,881649.20,95193.60,501869),('1','143','170082','382',266.00,312.00,0.00,1441.90,383545.40,442942.80,59397.40,502363),('1','143','170188','382',266.00,300.00,0.00,2844.10,756530.60,836550.00,80019.40,502612),('1','143','170392','382',266.00,300.00,0.00,2602.90,692371.40,767470.00,75098.60,503161),('1','143','170523','382',266.00,300.00,0.00,2869.10,763180.60,842470.00,79289.40,503499),('1','143','170702','382',266.00,300.00,0.00,2767.90,736261.40,813530.00,77268.60,503967),('1','143','170893','382',266.00,300.00,0.00,2310.10,614486.60,676470.00,61983.40,504475),('1','143','171058','382',266.00,300.00,0.00,2059.60,547853.60,608775.00,60921.40,504910),('1','143','171223','382',266.00,300.00,0.00,3917.10,1041948.60,1145178.00,103229.40,505354),('1','143','171427','382',266.00,300.00,0.00,3178.00,845348.00,928070.00,82722.00,505893),('1','143','171550','382',266.00,300.00,0.00,0.00,0.00,0.00,0.00,506236),('1','143','171560','382',266.00,300.00,0.00,0.00,0.00,0.00,0.00,506262),('1','143','171776','382',278.00,300.00,0.00,2471.00,686938.00,726226.00,39288.00,506818),('1','143','171779','382',278.00,300.00,0.00,1695.30,471293.40,502075.00,30781.60,506821),('1','143','171953','382',278.00,300.00,0.00,4096.60,1138854.80,1197890.00,59035.20,507291),('1','143','172087','382',278.00,300.00,0.00,2465.40,685381.20,728165.00,42783.80,507638),('1','143','172281','382',278.00,300.00,0.00,3372.50,937555.00,989700.00,52145.00,508162),('1','143','172506','382',278.00,300.00,0.00,2256.70,627362.60,670300.00,42937.40,508760),('1','143','172788','382',278.00,300.00,0.00,4316.60,1200014.80,1258118.00,58103.20,509505),('1','143','172881','382',278.00,300.00,0.00,2917.50,811065.00,861290.00,50225.00,509740),('1','143','173068','382',286.00,320.00,0.00,981.80,280794.80,301456.00,20661.20,510241),('1','143','173069','382',286.00,300.00,0.00,736.20,210553.20,219345.00,8791.80,510242),('1','143','173228','382',286.00,320.00,0.00,2391.00,683826.00,747120.00,63294.00,510663),('1','143','173439','382',286.00,320.00,0.00,4658.40,1332302.40,1385040.00,52737.60,511225),('1','143','173587','382',286.00,320.00,0.00,2161.40,618160.40,669838.00,51677.60,511631),('1','143','173763','382',286.00,320.00,0.00,2604.60,744915.60,793262.00,48346.40,512083),('1','143','173942','382',286.00,320.00,0.00,2503.80,716086.80,771526.00,55439.20,512555),('1','143','174126','382',286.00,320.00,0.00,2207.80,631430.80,684167.60,52736.80,513045),('1','143','174163','382',286.00,320.00,0.00,0.00,0.00,0.00,0.00,513134),('1','143','174323','382',286.00,308.00,0.00,5573.10,1593906.60,1639989.80,46083.20,513562),('1','143','174497','382',278.00,308.00,0.00,1613.20,448469.60,486263.60,37794.00,513999),('1','143','174500','382',278.00,308.00,0.00,1294.20,359787.60,390519.60,30732.00,514006),('1','143','174649','382',278.00,308.00,0.00,5133.50,1427113.00,1524161.00,97048.00,514376),('1','143','174847','382',278.00,308.00,0.00,3293.70,915648.60,984807.60,69159.00,514912),('1','143','175056','382',278.00,336.00,0.00,2113.20,587469.60,700115.20,112645.60,515465),('1','143','175246','382',278.00,336.00,0.00,2061.40,573069.20,684010.40,110941.20,515961),('1','143','175421','382',278.00,336.00,0.00,1943.80,540376.40,648636.80,108260.40,516420),('1','143','175601','382',278.00,336.00,0.00,2155.50,599229.00,718488.00,119259.00,516892),('1','143','175762','382',278.00,320.00,0.00,3887.60,1080752.80,1207532.00,126779.20,517321),('1','143','175957','382',278.00,320.00,0.00,0.00,0.00,0.00,0.00,517832),('1','143','175977','382',278.00,320.00,0.00,2824.70,785266.60,883104.00,97837.40,517881),('1','143','175992','382',278.00,320.00,0.00,338.30,94047.40,106256.00,12208.60,517919),('1','143','176143','382',278.00,320.00,0.00,5567.10,1547653.80,1715652.00,167998.20,518298),('1','143','176347','382',278.00,320.00,0.00,3017.60,838892.80,937512.00,98619.20,518812),('1','143','176564','382',278.00,320.00,0.00,3838.50,1067103.00,1199868.00,132765.00,519382),('1','143','176789','382',278.00,333.00,0.00,2736.70,760802.60,881809.40,121006.80,519997),('1','143','176991','382',278.00,333.00,0.00,2459.80,683824.40,806295.40,122471.00,520530),('1','143','177231','382',278.00,333.00,0.00,3104.40,863023.20,1003165.20,140142.00,521153),('1','143','177428','382',278.00,333.00,0.00,2083.50,579213.00,686645.50,107432.50,521668),('1','143','177620','382',303.00,333.00,0.00,1008.80,305666.40,327152.40,21486.00,522194),('1','143','177621','382',303.00,333.00,0.00,1748.90,529916.70,565751.70,35835.00,522195),('1','143','177819','382',303.00,333.00,0.00,0.00,0.00,0.00,0.00,522746),('1','143','177892','382',298.00,333.00,0.00,1986.40,591947.20,647443.20,55496.00,522909),('1','143','178081','382',298.00,333.00,0.00,1607.40,479005.20,524764.20,45759.00,523420),('1','143','178291','382',298.00,333.00,0.00,1920.00,572160.00,619032.00,46872.00,523957),('1','143','178496','382',298.00,333.00,0.00,1457.20,434245.60,479850.60,45605.00,524495),('1','143','178737','382',298.00,344.00,0.00,1362.80,406114.40,466163.20,60048.80,525125),('1','143','178877','382',298.00,344.00,0.00,1285.10,382959.80,442074.40,59114.60,525507),('1','143','178909','382',0.00,344.00,0.00,1542.80,0.00,523139.20,523139.20,525574),('1','143','179371','382',0.00,344.00,0.00,1866.50,0.00,629973.60,629973.60,526808),('1','143','179577','382',0.00,344.00,0.00,2853.40,0.00,952913.60,952913.60,527346),('1','143','179767','382',0.00,344.00,0.00,2216.60,0.00,749222.40,749222.40,527869),('1','143','179775','382',0.00,344.00,0.00,1864.73,0.00,633771.12,633771.12,527883),('1','143','179993','382',0.00,344.00,0.00,2232.55,0.00,748733.20,748733.20,528448),('1','143','180117','382',0.00,344.00,0.00,634.80,0.00,214131.20,214131.20,528780),('1','143','180186','382',0.00,344.00,0.00,2539.51,0.00,851943.44,851943.44,528948),('1','143','180304','382',0.00,344.00,0.00,350.80,0.00,117667.20,117667.20,529257),('1','143','180356','382',0.00,344.00,0.00,3172.50,0.00,1058293.60,1058293.60,529378),('1','143','180556','382',0.00,344.00,0.00,3691.10,0.00,1229914.40,1229914.40,529914),('1','143','180743','382',0.00,344.00,0.00,2551.60,0.00,860926.40,860926.40,530401),('1','143','180966','382',0.00,344.00,0.00,2906.31,0.00,980430.64,980430.64,531004),('1','143','181139','382',0.00,344.00,0.00,1569.46,0.00,536502.24,536502.24,531452),('1','143','181342','382',0.00,344.00,0.00,2122.99,0.00,720436.56,720436.56,532009),('1','143','181528','382',0.00,344.00,0.00,3582.32,0.00,1199474.08,1199474.08,532493),('1','143','181716','382',0.00,344.00,0.00,0.00,0.00,0.00,0.00,532980),('1','143','181722','382',318.00,344.00,0.00,1432.43,455512.74,476215.92,20703.18,532992),('1','143','181805','382',318.00,344.00,0.00,1656.45,526751.10,555290.80,28539.70,533229),('1','143','181916','382',318.00,344.00,0.00,211.50,67257.00,70056.00,2799.00,533528),('1','143','181922','382',318.00,344.00,0.00,2611.83,830561.94,877469.52,46907.58,533544),('1','143','182115','382',318.00,344.00,0.00,2278.65,724610.70,771263.60,46652.90,534059),('1','143','182317','382',318.00,344.00,0.00,3140.47,998669.46,1052237.68,53568.22,534574),('1','143','182507','382',318.00,344.00,0.00,4444.70,1413414.60,1495836.80,82422.20,535086),('1','143','182691','382',318.00,344.00,0.00,2312.13,735257.34,783908.72,48651.38,535576),('1','143','182848','382',318.00,344.00,0.00,1761.49,560153.82,599352.56,39198.74,536005),('1','143','182988','382',318.00,344.00,0.00,2411.90,766984.20,807149.60,40165.40,536393),('1','143','183219','382',318.00,344.00,0.00,1481.36,471072.48,506451.84,35379.36,536977),('1','143','183431','382',318.00,344.00,0.00,1560.31,496178.58,532122.64,35944.06,537524),('1','143','183630','382',318.00,344.00,0.00,0.00,0.00,0.00,0.00,538069),('1','143','183650','382',318.00,344.00,0.00,1001.23,318391.14,336623.12,18231.98,538109),('1','143','183759','382',318.00,344.00,0.00,1320.30,419855.40,443399.20,23543.80,538400),('1','143','183922','382',318.00,344.00,0.00,856.82,272468.76,292442.08,19973.32,538829),('1','143','184055','382',318.00,344.00,0.00,134.40,42739.20,46233.60,3494.40,539195),('1','143','184100','382',318.00,344.00,0.00,977.25,310765.50,335974.00,25208.50,539304),('1','143','184274','382',0.00,344.00,0.00,1907.78,0.00,648060.32,648060.32,539766),('1','143','184473','382',0.00,344.00,0.00,1424.38,0.00,488003.20,488003.20,540271),('1','143','184698','382',0.00,344.00,0.00,1310.50,0.00,449972.00,449972.00,540887),('1','143','184888','382',0.00,344.00,0.00,1467.43,0.00,501865.92,501865.92,541399),('1','143','185108','382',0.00,344.00,0.00,1447.94,0.00,489923.36,489923.36,541961),('1','143','185261','382',0.00,344.00,0.00,1951.77,0.00,658960.88,658960.88,542338),('1','143','185470','382',0.00,344.00,0.00,2001.64,0.00,676476.16,676476.16,542891),('1','143','185676','382',0.00,344.00,0.00,1576.91,0.00,534157.04,534157.04,543444),('1','143','185876','382',0.00,344.00,0.00,1053.31,0.00,360713.04,360713.04,543977),('1','143','186106','382',0.00,344.00,0.00,1458.02,0.00,496438.88,496438.88,544579),('1','143','186320','382',0.00,344.00,0.00,1339.76,0.00,453640.64,453640.64,545141),('1','143','186539','382',0.00,344.00,0.00,988.60,0.00,337454.40,337454.40,545723),('1','143','186761','382',0.00,344.00,0.00,1311.64,0.00,441996.16,441996.16,546293),('1','143','187168','382',0.00,344.00,0.00,1654.33,0.00,553443.12,553443.12,547344),('1','143','187253','382',315.00,344.00,0.00,671.85,211632.75,231116.40,19483.65,547573),('1','143','187354','382',315.00,344.00,0.00,1977.28,622843.20,670118.32,47275.12,547839),('1','143','187613','382',315.00,344.00,0.00,1901.87,599089.05,647107.28,48018.23,548514),('1','143','187817','382',315.00,344.00,0.00,2598.59,818555.85,874252.96,55697.11,549059),('1','143','188021','382',315.00,344.00,0.00,3264.12,1028197.80,1103965.28,75767.48,549590),('1','143','188219','382',315.00,344.00,0.00,4276.21,1347006.15,1441628.24,94622.09,550106),('1','143','188430','382',315.00,344.00,0.00,3655.37,1151441.55,1222519.28,71077.73,550654),('1','143','188608','382',315.00,344.00,0.00,4384.14,1381004.10,1454288.16,73284.06,551104),('1','143','188782','382',315.00,344.00,0.00,0.00,0.00,0.00,0.00,551580),('1','143','188808','382',315.00,344.00,0.00,2045.56,644351.40,685612.64,41261.24,551632),('1','143','188922','382',315.00,344.00,0.00,3563.78,1122590.70,1181640.32,59049.62,551940),('1','143','189016','382',315.00,344.00,0.00,3838.97,1209275.55,1274019.68,64744.13,552181),('1','143','189208','382',315.00,344.00,0.00,3049.15,960482.25,1016983.60,56501.35,552683),('1','143','189430','382',315.00,344.00,0.00,1659.57,522764.55,563052.08,40287.53,553264),('1','143','189637','382',315.00,344.00,0.00,2667.60,840294.00,891736.40,51442.40,553793),('1','143','189820','382',315.00,344.00,0.00,2075.38,653744.70,701314.72,47570.02,554265),('1','143','190032','382',315.00,344.00,0.00,3018.04,950682.60,1014293.76,63611.16,554829),('1','143','190224','382',315.00,344.00,0.00,3660.81,1153155.15,1222362.64,69207.49,555324),('1','143','190441','382',315.00,344.00,0.00,956.90,300142.50,321973.60,21831.10,555891),('1','143','190564','382',313.00,344.00,0.00,4111.68,1286955.84,1378368.92,91413.08,556233),('1','143','190682','382',313.00,344.00,0.00,5577.78,1745845.14,1848232.32,102387.18,556529),('1','143','190852','382',313.00,344.00,0.00,29.00,9077.00,9976.00,899.00,556998),('1','143','190905','382',313.00,344.00,0.00,2835.61,887545.93,943451.84,55905.91,557117),('1','143','191089','382',313.00,344.00,0.00,1109.30,347210.90,376799.20,29588.30,557597),('1','143','191318','382',313.00,344.00,0.00,1550.34,485256.42,520780.96,35524.54,558199),('1','143','191504','382',313.00,344.00,0.00,1444.01,451975.13,488643.44,36668.31,558693),('1','143','191725','382',313.00,344.00,0.00,1610.42,504061.46,541932.48,37871.02,559276),('1','143','191946','382',313.00,344.00,0.00,1429.51,447436.63,472121.44,24684.81,559877),('1','143','192034','382',315.00,344.00,0.00,766.98,241598.70,259055.12,17456.42,560115),('1','143','192139','382',315.00,344.00,0.00,1672.06,526698.90,564208.64,37509.74,560386),('1','143','192347','382',315.00,344.00,0.00,1049.80,330687.00,357547.20,26860.20,560930),('1','143','192593','382',315.00,344.00,0.00,1310.35,412760.25,441352.40,28592.15,561568),('1','143','192760','382',315.00,344.00,0.00,1490.41,469479.15,501975.04,32495.89,562010),('1','143','192983','382',315.00,344.00,0.00,984.05,309975.75,337713.20,27737.45,562589),('1','143','193183','382',315.00,344.00,0.00,1208.84,380784.60,408820.96,28036.36,563121),('1','143','193417','382',315.00,344.00,0.00,1114.08,350935.20,378843.52,27908.32,563734),('1','143','193632','382',315.00,344.00,0.00,1253.90,394978.50,424281.60,29303.10,564299),('1','143','193868','382',315.00,344.00,0.00,1746.86,550260.90,585575.84,35314.94,564879),('1','143','194088','382',315.00,344.00,0.00,2220.77,0.00,732418.88,732418.88,565432),('1','143','194296','382',0.00,344.00,0.00,2261.08,0.00,767383.52,767383.52,565979),('1','143','194490','382',0.00,344.00,0.00,1709.62,0.00,573655.28,573655.28,566468),('1','143','194689','382',0.00,344.00,0.00,1783.92,0.00,600292.48,600292.48,566966),('1','143','194872','382',0.00,344.00,0.00,2513.76,0.00,833537.44,833537.44,567471),('1','143','195090','382',0.00,344.00,0.00,1623.73,0.00,535837.12,535837.12,568026),('1','143','195245','382',309.50,344.00,0.00,1299.12,402077.65,428197.28,26119.65,568443),('1','143','195313','382',309.50,344.00,0.00,1864.61,577096.83,629259.84,52163.08,568602),('1','143','195527','382',309.50,344.00,0.00,1686.05,521832.48,566899.76,45067.29,569156),('1','143','195792','382',309.50,344.00,0.00,2603.44,805764.69,863804.36,58039.70,569809),('1','143','196017','382',309.50,344.00,0.00,1053.92,326188.26,359270.48,33082.26,570386),('1','143','196242','382',309.50,344.00,0.00,2369.08,733230.29,787067.52,53837.29,570949),('1','143','196485','382',309.50,344.00,0.00,2670.57,826541.44,894916.08,68374.70,571576),('1','143','196676','382',309.50,344.00,0.00,2686.07,831338.70,891844.08,60505.44,572064),('1','143','196956','382',309.50,344.00,0.00,227.70,70473.15,78328.80,7855.65,572802),('1','143','197043','382',309.50,344.00,0.00,1385.61,428846.30,461183.84,32337.55,573020),('1','143','197300','382',309.50,344.00,0.00,1493.60,462269.20,498574.40,36305.20,573720),('1','143','197306','382',309.50,344.00,0.00,1784.23,552219.21,591225.12,39005.96,573732),('1','143','197528','382',309.50,344.00,0.00,2555.43,790905.60,844428.92,53523.35,574188),('1','143','197888','382',309.50,344.00,0.00,866.62,268218.90,287689.28,19470.40,575160),('1','143','197999','382',309.50,344.00,0.00,650.55,201345.24,221534.20,20188.99,575456),('1','143','198122','382',309.50,344.00,0.00,1488.61,460724.80,496791.84,36067.05,575763),('1','143','198370','382',309.50,344.00,0.00,1673.96,518090.64,558484.24,40393.64,576396),('1','143','198583','382',309.50,344.00,0.00,1739.49,538372.17,574954.56,36582.42,576956),('1','143','198814','382',309.50,344.00,0.00,1573.10,486874.46,527220.40,40345.96,577518),('1','143','198994','382',309.50,344.00,0.00,1305.69,404111.11,443085.36,38974.36,578000),('1','143','199229','382',309.50,344.00,0.00,2493.68,771793.96,830127.92,58333.96,578582),('1','143','199448','382',309.50,344.00,0.00,2451.57,758760.93,810912.08,52151.18,579119),('1','143','199677','382',309.50,344.00,0.00,1032.33,319506.15,345375.52,25869.40,579683),('1','143','199830','382',309.50,344.00,0.00,565.10,174898.45,189994.40,15095.95,580073),('1','143','199900','382',309.50,344.00,0.00,1657.33,512943.66,552191.52,39247.91,580233),('1','143','200110','382',309.50,344.00,0.00,2212.92,684898.76,744216.48,59317.76,580786),('1','143','200307','382',309.50,344.00,0.00,2459.71,761280.30,824382.24,63102.05,581303),('1','143','200507','382',309.50,344.00,0.00,2037.96,630748.68,692148.24,61399.68,581820),('1','143','200746','382',309.50,344.00,0.00,1997.79,618316.05,671663.76,53347.80,582446),('1','143','200937','382',309.50,344.00,0.00,2433.34,753118.78,811152.96,58034.28,582927),('1','143','201125','382',309.50,344.00,0.00,2085.23,645378.72,699389.12,54010.47,583401),('1','143','201322','382',309.50,344.00,0.00,2553.33,790255.69,847677.52,57421.94,583920),('1','143','201504','382',309.50,344.00,0.00,2578.03,797900.30,856988.32,59088.05,584395),('1','143','201769','382',309.50,344.00,0.00,1484.12,459335.20,505961.28,46626.20,585099),('1','143','202040','382',309.50,344.00,0.00,1358.85,420564.11,467444.40,46880.36,585812),('1','143','202225','382',309.50,344.00,0.00,691.87,214133.78,235803.28,21669.53,586284),('1','143','202327','382',309.50,344.00,0.00,1513.82,468527.31,506168.08,37640.81,586548),('1','143','202457','382',309.50,344.00,0.00,330.40,102258.80,108157.60,5898.80,586872),('1','143','202473','382',309.50,344.00,0.00,2652.84,821053.99,873163.96,52109.99,586918),('1','143','202658','382',309.50,344.00,0.00,3058.81,946701.71,1004325.64,57623.96,587393),('1','143','202865','382',309.50,344.00,0.00,1554.84,481223.01,526922.96,45700.01,587926),('1','143','203122','382',309.50,344.00,0.00,2266.43,701460.11,757497.92,56037.86,588592),('1','143','203314','382',309.50,344.00,0.00,1234.23,381994.24,420769.12,38774.99,589109),('1','143','203530','382',309.50,344.00,0.00,2573.64,796541.63,860824.16,64282.63,589647),('1','143','203744','382',309.50,360.00,0.00,2401.90,0.00,817070.00,817070.00,590199),('1','143','203972','382',0.00,360.00,0.00,2716.24,0.00,906216.40,906216.40,590786),('1','143','204202','382',0.00,360.00,0.00,1479.33,0.00,525718.80,525718.80,591390),('1','143','204413','382',0.00,360.00,0.00,3101.52,0.00,1024169.20,1024169.20,591934),('1','143','204576','382',309.50,360.00,0.00,359.03,111119.79,127958.80,16839.02,592366),('1','143','204634','382',309.50,360.00,0.00,173.00,53543.50,60380.00,6836.50,592498),('1','143','204635','382',309.50,360.00,0.00,807.06,4642.50,286285.60,281643.10,592499),('1','143','204861','382',0.00,360.00,0.00,2253.32,0.00,777875.20,777875.20,593047),('1','143','205045','382',0.00,360.00,0.00,1778.61,0.00,619026.60,619026.60,593519),('1','143','205250','382',0.00,360.00,0.00,1831.72,0.00,637229.20,637229.20,594053),('1','143','205487','382',0.00,360.00,0.00,1985.78,0.00,686236.80,686236.80,594650),('1','143','205737','382',0.00,360.00,0.00,2170.38,0.00,745196.80,745196.80,595312),('1','143','205952','382',0.00,360.00,0.00,1928.69,0.00,658556.40,658556.40,595868),('1','143','206164','382',0.00,360.00,0.00,2405.17,0.00,829321.20,829321.20,596407),('1','143','206368','382',0.00,360.00,0.00,1900.83,0.00,666098.80,666098.80,596928),('1','143','206578','382',0.00,360.00,0.00,1704.15,0.00,579997.00,579997.00,597460),('1','143','206709','382',0.00,360.00,0.00,845.41,220911.42,293647.60,72736.18,597808),('1','143','206910','382',318.00,360.00,0.00,2215.45,704513.10,755186.00,50672.90,598325),('1','143','207035','382',318.00,360.00,0.00,1307.64,415829.52,462686.40,46856.88,598645),('1','143','207261','382',318.00,360.00,0.00,2249.95,715484.10,781282.00,65797.90,599228),('1','143','207508','382',318.00,360.00,0.00,2644.23,840865.14,920308.80,79443.66,599872),('1','143','207665','382',318.00,360.00,0.00,551.41,175348.38,182907.60,7559.22,600271),('1','143','207776','382',0.00,380.00,0.00,2012.41,0.00,755965.80,755965.80,600541),('1','143','207913','382',0.00,380.00,0.00,2902.23,0.00,1071372.40,1071372.40,600892),('1','143','208132','382',0.00,380.00,0.00,4421.23,576343.20,1610710.40,1034367.20,601457),('1','143','208341','382',318.00,380.00,0.00,2479.63,788522.34,914909.40,126387.06,601995),('1','143','208544','382',318.00,380.00,0.00,1700.43,540736.74,633525.90,92789.16,602524),('1','143','208765','382',318.00,380.00,0.00,2723.35,866025.30,1006298.00,140272.70,603086),('1','143','209004','382',400.00,400.00,0.00,3354.95,1341980.00,1317284.00,-24696.00,603685),('1','143','209219','382',400.00,400.00,0.00,2263.60,905440.00,882808.00,-22632.00,604241),('1','143','209428','382',400.00,400.00,0.00,2902.75,1161100.00,1126040.80,-35059.20,604775),('1','143','209639','382',400.00,400.00,0.00,1990.80,796320.00,788304.00,-8016.00,605314),('1','143','209848','382',420.00,420.00,0.00,1895.34,796042.80,759634.80,-36408.00,605866),('1','143','210072','382',420.00,420.00,0.00,981.10,412062.00,398562.00,-13500.00,606445),('1','143','210177','382',420.00,420.00,0.00,2810.74,1012332.00,1118806.80,106474.80,606705),('1','143','210301','382',360.00,420.00,0.00,2785.22,1002679.20,1116034.40,113355.20,607035),('1','143','210500','382',360.00,420.00,0.00,2593.48,933652.80,1034507.60,100854.80,607561),('1','143','210817','382',360.00,420.00,0.00,3676.25,1323450.00,1448713.00,125263.00,608378),('1','143','210979','382',360.00,420.00,0.00,2378.98,856432.80,970063.60,113630.80,608784),('1','143','211190','382',360.00,420.00,0.00,2157.94,14940.00,902476.56,887536.56,609325),('1','143','211509','382',0.00,420.00,0.00,3696.83,0.00,1513539.92,1513539.92,610170),('1','143','211575','382',0.00,424.00,0.00,212.30,0.00,86810.00,86810.00,610350),('1','143','211610','382',0.00,420.00,0.00,963.24,0.00,397886.76,397886.76,610433),('1','143','211799','382',0.00,424.00,0.00,1287.78,0.00,533074.72,533074.72,610900),('1','143','212030','382',0.00,424.00,0.00,1071.35,209412.00,434068.40,224656.40,611503),('1','143','212195','382',360.00,424.00,0.00,288.91,104007.60,121192.84,17185.24,611955),('1','143','212247','382',360.00,424.00,0.00,3198.47,1151449.20,1289675.78,138226.58,612069),('1','143','212473','382',360.00,424.00,0.00,1509.05,543258.00,621051.20,77793.20,612668),('1','143','212734','382',360.00,424.00,0.00,1266.52,455947.20,529754.48,73807.28,613361),('1','143','212883','382',360.00,424.00,0.00,1206.51,434343.60,505847.24,71503.64,613746),('1','143','213146','382',360.00,424.00,0.00,2479.47,892609.20,1019846.28,127237.08,614432),('1','143','213406','382',360.00,424.00,0.00,2618.48,942652.80,1062270.52,119617.72,615095),('1','143','213646','382',360.00,424.00,0.00,2031.44,731318.40,818325.56,87007.16,615741),('1','143','213821','382',360.00,424.00,0.00,0.00,0.00,0.00,0.00,616214),('1','143','213826','382',360.00,424.00,0.00,0.00,0.00,0.00,0.00,616228),('1','143','213829','382',360.00,424.00,0.00,0.00,0.00,0.00,0.00,616235),('1','143','213831','382',360.00,424.00,0.00,0.00,0.00,0.00,0.00,616239),('1','143','213832','382',360.00,424.00,0.00,1141.50,436053.00,470246.00,34193.00,616240),('1','143','213947','382',0.00,424.00,0.00,2889.16,0.00,1178193.84,1178193.84,616531),('1','143','214163','382',0.00,424.00,0.00,1721.44,0.00,720410.56,720410.56,617089),('1','143','214344','382',0.00,424.00,0.00,3209.26,0.00,1319372.24,1319372.24,617559),('1','143','214552','382',0.00,424.00,0.00,1471.36,0.00,618816.64,618816.64,618090),('1','143','214795','382',0.00,424.00,0.00,2977.10,0.00,1227742.40,1227742.40,618725),('1','143','215013','382',0.00,424.00,0.00,3604.81,0.00,1464191.44,1464191.44,619301),('1','143','215232','382',0.00,424.00,0.00,1586.38,0.00,669361.12,669361.12,619859),('1','143','215407','382',0.00,424.00,0.00,571.80,0.00,228427.50,228427.50,620322),('1','143','215452','382',0.00,424.00,0.00,2386.25,0.00,996086.00,996086.00,620420),('1','143','215689','382',0.00,424.00,0.00,2404.69,0.00,992256.56,992256.56,621038),('1','143','215971','382',382.00,424.00,0.00,624.83,238685.06,252447.92,13762.86,621768),('1','143','216026','382',382.00,424.00,0.00,434.52,165986.64,183636.48,17649.84,621915),('1','143','216112','382',382.00,424.00,0.00,2403.89,918285.98,992105.36,73819.38,622132),('1','143','216335','382',382.00,424.00,0.00,1394.25,532603.50,588762.00,56158.50,622708),('1','143','216576','382',382.00,424.00,0.00,2550.39,974248.98,1049389.36,75140.38,623343),('1','143','216795','382',382.00,424.00,0.00,2287.79,873935.78,943890.96,69955.18,623925),('1','143','217203','382',0.00,480.00,0.00,371.90,0.00,178512.00,178512.00,625010),('1','143','217204','382',0.00,480.00,0.00,2184.04,0.00,985524.20,985524.20,625011),('1','143','217361','382',0.00,480.00,0.00,2061.94,0.00,963551.20,963551.20,625414),('1','143','217509','382',0.00,480.00,0.00,1756.25,0.00,820100.00,820100.00,625797),('1','143','217714','382',0.00,480.00,0.00,1952.73,0.00,897950.40,897950.40,626325),('1','143','218079','382',0.00,480.00,0.00,1603.37,0.00,764217.60,764217.60,627290),('1','143','218234','382',0.00,480.00,0.00,1527.54,0.00,722819.20,722819.20,627698),('1','143','218461','382',0.00,480.00,0.00,1365.84,0.00,649603.20,649603.20,628288),('1','143','218700','382',0.00,480.00,0.00,2118.64,0.00,977497.20,977497.20,628905),('1','143','218913','382',0.00,480.00,0.00,1309.78,0.00,615734.40,615734.40,629470),('1','143','219077','382',0.00,480.00,0.00,377.00,0.00,180960.00,180960.00,629905),('1','143','219118','382',0.00,480.00,0.00,0.00,0.00,0.00,0.00,630005),('1','143','219135','382',382.00,480.00,0.00,3118.21,1191156.22,1423258.30,232102.08,630046),('1','143','219402','382',382.00,480.00,0.00,633.00,241806.00,296400.00,54594.00,630745),('1','143','219517','382',382.00,480.00,0.00,762.56,291297.92,355428.80,64130.88,631062),('1','143','219611','382',382.00,480.00,0.00,1637.70,625601.40,767296.00,141694.60,631291),('1','143','220134','382',382.00,480.00,0.00,1539.00,587898.00,725640.00,137742.00,632689),('1','143','220138','382',382.00,480.00,0.00,1188.55,454026.10,568104.00,114077.90,632698),('1','143','220267','382',382.00,480.00,0.00,1744.37,666349.34,835497.60,169148.26,633029),('1','143','220519','382',382.00,480.00,0.00,2424.09,926002.38,1111403.20,185400.82,633692),('1','143','220793','382',382.00,480.00,0.00,1536.35,586885.70,721048.00,134162.30,634401),('1','143','220999','382',382.00,480.00,0.00,1843.29,704136.78,858819.20,154682.42,634951),('1','143','221215','382',382.00,480.00,0.00,2842.54,1085850.28,1306869.20,221018.92,635496),('1','143','221453','382',382.00,480.00,0.00,2194.84,838428.88,1006658.20,168229.32,636123),('1','143','221739','382',382.00,480.00,0.00,2447.38,934899.16,1131502.40,196603.24,636877),('1','143','221870','382',382.00,480.00,0.00,1610.83,615337.06,764678.40,149341.34,637200),('1','143','222087','382',382.00,480.00,0.00,2538.49,969703.18,1156435.20,186732.02,637772),('1','143','222281','382',382.00,480.00,0.00,336.54,128558.28,159139.20,30580.92,638266),('1','143','222353','382',425.00,480.00,0.00,2726.65,1158826.25,1250792.00,91965.75,638457),('1','143','222535','382',425.00,480.00,0.00,1681.00,714425.00,789680.00,75255.00,638915),('1','143','222775','382',425.00,480.00,0.00,2737.97,1163637.25,1254993.60,91356.35,639551),('1','143','222948','382',425.00,480.00,0.00,1902.66,808630.50,889756.80,81126.30,640030),('1','143','223208','382',425.00,480.00,0.00,3642.68,1548139.00,1643147.40,95008.40,640686),('1','143','223433','382',425.00,480.00,0.00,1417.80,7968.75,676544.00,668575.25,641238),('1','143','223661','382',0.00,480.00,0.00,2809.57,0.00,1323851.60,1323851.60,641823),('1','143','223894','382',0.00,480.00,0.00,1744.84,0.00,835723.20,835723.20,642425),('1','143','224134','382',0.00,480.00,0.00,996.84,3462.97,469951.20,466488.23,643049),('1','143','224275','382',427.00,480.00,0.00,1047.59,447320.93,495967.20,48646.27,643434),('1','143','224323','382',0.00,540.00,0.00,2782.39,0.00,1428154.60,1428154.60,643536),('1','143','224618','382',0.00,540.00,0.00,1673.85,0.00,882079.00,882079.00,644320),('1','143','224798','382',0.00,540.00,0.00,1933.14,0.00,1010175.60,1010175.60,644760),('1','143','225037','382',0.00,540.00,0.00,1314.22,0.00,701358.80,701358.80,645379),('1','143','225283','382',0.00,540.00,0.00,2731.26,0.00,1410640.40,1410640.40,646008),('1','143','225489','382',0.00,540.00,0.00,2274.62,0.00,1208014.80,1208014.80,646553),('1','143','225792','382',0.00,540.00,0.00,2062.06,0.00,1074852.40,1074852.40,647350),('1','143','225997','382',0.00,540.00,0.00,1690.46,0.00,886348.40,886348.40,647872),('1','143','226216','382',0.00,540.00,0.00,0.00,0.00,0.00,0.00,648465),('1','143','226218','382',0.00,540.00,0.00,0.00,0.00,0.00,0.00,648468),('1','143','226264','382',0.00,540.00,0.00,1154.49,0.00,609384.60,609384.60,648576),('1','143','226410','382',0.00,540.00,0.00,277.45,0.00,149823.00,149823.00,648970),('1','143','226447','382',0.00,540.00,0.00,0.00,0.00,0.00,0.00,649063),('1','143','226451','382',0.00,540.00,0.00,0.00,0.00,0.00,0.00,649071),('1','143','226452','382',0.00,540.00,0.00,0.00,0.00,0.00,0.00,649072),('1','143','226454','382',0.00,540.00,0.00,0.00,0.00,0.00,0.00,649076),('1','143','226480','382',0.00,540.00,0.00,0.00,0.00,0.00,0.00,649121),('1','143','226483','382',0.00,540.00,0.00,0.00,0.00,0.00,0.00,649126),('1','143','226485','382',0.00,540.00,0.00,0.00,0.00,0.00,0.00,649128),('1','143','226520','382',0.00,540.00,0.00,1595.99,0.00,840434.60,840434.60,649215),('1','143','226685','382',0.00,540.00,0.00,59.60,0.00,32184.00,32184.00,649670),('1','143','226693','382',0.00,540.00,0.00,0.00,0.00,0.00,0.00,649689),('1','143','226694','382',0.00,540.00,0.00,0.00,0.00,0.00,0.00,649690),('1','143','226695','382',0.00,540.00,0.00,0.00,0.00,0.00,0.00,649691),('1','143','226696','382',0.00,540.00,0.00,0.00,0.00,0.00,0.00,649692),('1','143','226794','382',0.00,540.00,0.00,2045.77,0.00,1060315.80,1060315.80,649932),('1','143','227001','382',0.00,540.00,0.00,2019.46,0.00,1055908.40,1055908.40,650475),('1','143','227208','382',0.00,540.00,0.00,1848.65,0.00,984831.00,984831.00,651012),('1','143','227405','382',0.00,540.00,0.00,2230.17,0.00,1164371.80,1164371.80,651515),('1','143','227622','382',0.00,540.00,0.00,2000.48,0.00,1048259.20,1048259.20,652072),('1','143','227867','382',0.00,540.00,0.00,1292.22,337330.00,662358.80,325028.80,652711),('1','143','228068','382',427.00,540.00,0.00,1249.50,533536.50,655322.00,121785.50,653262),('1','143','228137','382',427.00,540.00,0.00,2533.11,1081637.97,1323379.40,241741.43,653426),('1','143','228373','382',427.00,540.00,0.00,3066.16,88862.97,1648654.40,1559791.43,654035),('1','143','228537','382',0.00,560.00,0.00,3318.67,0.00,1771977.20,1771977.20,654450),('1','143','228786','382',0.00,560.00,0.00,2434.85,0.00,1322734.00,1322734.00,655086),('1','143','228970','382',0.00,560.00,0.00,1786.34,0.00,973554.40,973554.40,655553),('1','143','229178','382',0.00,560.00,0.00,2571.97,0.00,1405401.20,1405401.20,656108),('1','143','229374','382',0.00,560.00,0.00,201.50,0.00,100750.00,100750.00,656631),('1','143','229431','382',0.00,584.00,0.00,1145.62,138006.24,645064.08,507057.84,656760),('1','143','229583','382',482.00,584.00,0.00,1253.56,604215.92,721504.04,117288.12,657164),('1','143','229693','382',482.00,584.00,0.00,1253.59,604230.38,667739.82,63509.44,657427),('1','143','229697','382',482.00,584.00,0.00,2780.66,1340278.12,1545267.18,204989.06,657435),('1','143','229891','382',482.00,584.00,0.00,1865.44,899142.08,1063566.96,164424.88,657939),('1','143','230092','382',482.00,584.00,0.00,2483.80,1197191.60,1392215.96,195024.36,658456),('1','143','230303','382',482.00,584.00,0.00,1518.73,732027.86,882503.87,150476.01,658998),('1','143','230533','382',482.00,584.00,0.00,3601.19,1735773.58,1998116.96,262343.38,659596),('1','143','230795','382',482.00,584.00,0.00,1241.10,640470.60,710796.40,70325.80,660270),('1','143','231337','382',522.00,584.00,0.00,1573.10,821158.20,904684.40,83526.20,661744),('1','143','231384','382',522.00,584.00,0.00,2606.68,1360686.96,1465008.12,104321.16,661848),('1','143','231647','382',522.00,584.00,0.00,1873.96,978207.12,1066662.64,88455.52,662532),('1','143','231909','382',522.00,584.00,0.00,1647.29,859885.38,949515.36,89629.98,663245),('1','143','232107','382',522.00,584.00,0.00,1883.33,983098.26,1085764.72,102666.46,663776),('1','143','232348','382',522.00,584.00,0.00,2956.34,1543209.48,1646635.56,103426.08,664392),('1','143','232600','382',522.00,584.00,0.00,1561.72,815217.84,880131.48,64913.64,665062),('1','143','233209','382',567.00,584.00,0.00,2682.10,1520750.70,1479984.40,-40766.30,666669),('1','143','233382','382',624.00,624.00,0.00,1574.99,982793.76,980075.40,-2718.36,667121),('1','143','233618','382',624.00,624.00,0.00,2242.58,1399369.92,1389469.92,-9900.00,667734),('1','143','233854','382',624.00,624.00,0.00,2330.98,1454531.52,1430894.28,-23637.24,668349),('1','143','234067','382',624.00,624.00,0.00,2308.83,1440709.92,1396567.44,-44142.48,668914),('1','143','234323','382',624.00,624.00,0.00,1429.42,891958.08,878314.08,-13644.00,669587),('1','143','234574','382',624.00,624.00,0.00,3543.09,2210888.16,2118512.16,-92376.00,670262),('1','143','234842','382',567.00,624.00,0.00,1847.06,1047283.02,1125205.44,77922.42,670967),('1','143','235095','382',567.00,624.00,0.00,2006.51,1137691.17,1222542.24,84851.07,671654),('1','143','235312','382',567.00,624.00,0.00,1389.62,788892.89,853421.28,64528.39,672217),('1','143','235467','382',572.00,624.00,0.00,355.66,203437.52,221031.84,17594.32,672627),('1','143','235551','382',572.00,624.00,0.00,1455.80,832717.60,901291.20,68573.60,672823),('1','143','235776','382',572.00,624.00,0.00,1499.84,857908.48,926576.16,68667.68,673407),('1','143','236033','382',572.00,624.00,0.00,2602.50,1488630.00,1581016.00,92386.00,674089),('1','143','236248','382',572.00,624.00,0.00,3593.21,2055316.12,2165429.04,110112.92,674653),('1','143','236528','382',572.00,624.00,0.00,2079.33,1189376.76,1322131.20,132754.44,675395),('1','143','236752','382',572.00,640.00,0.00,1970.14,1126920.08,1241081.60,114161.52,675967),('1','143','236979','382',592.00,640.00,0.00,842.43,498718.56,527155.20,28436.64,676560),('1','143','237051','382',592.00,640.00,0.00,661.31,391495.52,422438.40,30942.88,676744),('1','143','237183','382',592.00,640.00,0.00,1820.88,1077960.96,1149811.20,71850.24,677079),('1','143','237395','382',592.00,640.00,0.00,1793.68,1061858.56,1134515.20,72656.64,677629),('1','143','237637','382',592.00,664.00,0.00,2714.93,1607238.56,1718873.84,111635.28,678258),('1','143','237912','382',592.00,640.00,0.00,3026.93,1791942.56,1907247.20,115304.64,678965),('1','143','238137','382',592.00,640.00,0.00,1437.95,851266.40,912848.00,61581.60,679558),('1','143','238379','382',592.00,640.00,0.00,1662.65,984288.80,1055856.00,71567.20,680174),('1','143','238626','382',592.00,640.00,0.00,3449.77,2042263.84,2185708.80,143444.96,680825),('1','143','238850','382',592.00,640.00,0.00,2043.54,1209775.68,1301906.56,92130.88,681404),('1','143','239079','382',592.00,640.00,0.00,71.50,42328.00,41756.00,-572.00,681995),('1','143','239092','382',592.00,640.00,0.00,2610.67,1545516.64,1659068.80,113552.16,682023),('1','143','239316','382',592.00,640.00,0.00,1344.31,795831.52,859238.40,63406.88,682611),('1','143','239545','382',592.00,640.00,0.00,1727.32,1022573.44,1093161.76,70588.32,683207),('1','143','239783','382',592.00,656.00,0.00,456.46,270224.32,299437.76,29213.44,683833),('1','143','239874','382',592.00,656.00,0.00,1094.72,658169.34,706592.32,48422.98,684072),('1','143','240013','382',602.00,656.00,0.00,1982.87,1193687.74,1278532.72,84844.98,684421),('1','143','240226','382',602.00,656.00,0.00,1673.59,1007501.18,1085265.04,77763.86,684974),('1','143','240468','382',602.00,656.00,0.00,1795.56,1080927.12,1164887.36,83960.24,685609),('1','143','240711','382',602.00,656.00,0.00,2001.75,1205053.50,1290294.00,85240.50,686197),('1','143','240988','382',602.00,656.00,0.00,1830.60,1102021.20,1182673.60,80652.40,686937),('1','143','241259','382',602.00,656.00,0.00,1955.97,1177493.94,1259274.32,81780.38,687643),('1','143','241512','382',602.00,656.00,0.00,1702.74,1025049.48,1101397.44,76347.96,688325),('1','143','241760','382',602.00,656.00,0.00,1241.32,747274.64,810405.92,63131.28,688985),('1','143','241996','382',602.00,656.00,0.00,1307.65,787205.30,856414.40,69209.10,689596),('1','143','242231','382',602.00,656.00,0.00,1701.10,1024062.20,1109421.60,85359.40,690207),('1','143','242454','382',602.00,656.00,0.00,1547.19,931408.38,1005856.64,74448.26,690771),('1','143','242705','382',602.00,656.00,0.00,1657.91,998061.82,1078852.96,80791.14,691425),('1','143','242938','382',602.00,656.00,0.00,1737.96,1046251.92,1129701.76,83449.84,692039),('1','143','243167','382',602.00,656.00,0.00,830.34,499864.68,535603.04,35738.36,692633),('1','143','243247','382',602.00,656.00,0.00,745.09,448544.18,487739.04,39194.86,692849),('1','143','243389','382',602.00,656.00,0.00,1193.61,718553.22,781103.66,62550.44,693224),('1','143','243616','382',602.00,656.00,0.00,2152.34,1295708.68,1392468.06,96759.38,693805),('1','143','243863','382',602.00,656.00,0.00,1781.34,1072366.68,1159199.04,86832.36,694449),('1','143','244083','382',602.00,656.00,0.00,1807.42,1088066.84,1172043.52,83976.68,695011),('1','143','244327','382',602.00,656.00,0.00,2048.49,1233190.98,1329769.44,96578.46,695646),('1','143','244543','382',602.00,656.00,0.00,1523.94,917411.88,999704.64,82292.76,696206),('1','143','244762','382',602.00,656.00,0.00,1727.82,1040147.64,1118109.92,77962.28,696786),('1','143','245006','382',602.00,624.00,0.00,1017.63,612613.26,634041.12,21427.86,697411),('1','143','245129','382',602.00,624.00,0.00,249.72,150331.44,155825.28,5493.84,697740),('1','143','245256','382',592.00,624.00,0.00,1362.21,806428.32,844523.04,38094.72,698052),('1','143','245455','382',592.00,624.00,0.00,2246.19,1329744.48,1377382.56,47638.08,698568),('1','143','245698','382',592.00,624.00,0.00,1435.55,849845.60,884983.20,35137.60,699193),('1','143','245962','382',592.00,624.00,0.00,1397.41,827266.72,849304.56,22037.84,699895),('1','143','246214','382',592.00,616.00,0.00,1296.97,767806.24,790699.52,22893.28,700531),('1','143','246483','382',592.00,616.00,0.00,1135.13,671996.96,695100.08,23103.12,701246),('1','143','246719','382',592.00,616.00,0.00,1479.18,875674.56,899030.88,23356.32,701866),('1','143','246963','382',592.00,616.00,0.00,2282.92,1351488.64,1360062.52,8573.88,702487),('1','143','247187','382',592.00,616.00,0.00,1689.88,1000408.96,1018886.08,18477.12,703070),('1','143','247430','382',592.00,616.00,0.00,1460.24,864462.08,880003.84,15541.76,703683),('1','143','247694','382',592.00,616.00,0.00,1156.62,684719.04,705347.92,20628.88,704386),('1','143','247935','382',592.00,616.00,0.00,493.34,292057.28,303897.44,11840.16,704999),('1','143','248021','382',592.00,616.00,0.00,729.77,432023.84,437026.32,5002.48,705222),('1','143','248198','382',592.00,616.00,0.00,1412.07,835945.44,832575.12,-3370.32,705685),('1','143','248329','382',592.00,616.00,0.00,517.60,306419.20,311205.60,4786.40,706041),('1','143','248430','382',592.00,616.00,0.00,2186.17,1294212.64,1296218.72,2006.08,706281),('1','143','248673','382',592.00,616.00,0.00,1421.13,841308.96,868516.08,27207.12,706899),('1','143','248901','382',590.00,600.00,0.00,1348.45,795585.50,798270.00,2684.50,707493),('1','143','249116','382',590.00,600.00,0.00,1593.19,939982.10,944314.00,4331.90,708045),('1','143','249368','382',590.00,600.00,0.00,2452.31,1446862.90,1423686.00,-23176.90,708680),('1','143','249617','382',590.00,600.00,0.00,1633.66,963859.40,956596.00,-7263.40,709318),('1','143','249879','382',590.00,600.00,0.00,1087.17,629433.58,634302.00,4868.42,709995),('1','143','250011','382',532.00,600.00,0.00,427.67,227520.44,254602.00,27081.56,710349),('1','143','250039','382',532.00,600.00,0.00,0.00,0.00,0.00,0.00,710425),('1','143','250042','382',532.00,600.00,0.00,0.00,0.00,0.00,0.00,710433),('1','143','250045','382',532.00,600.00,0.00,0.00,0.00,0.00,0.00,710440),('1','143','250047','382',532.00,600.00,0.00,0.00,0.00,0.00,0.00,710444),('1','143','250048','382',532.00,600.00,0.00,0.00,0.00,0.00,0.00,710445),('1','143','250049','382',532.00,600.00,0.00,0.00,0.00,0.00,0.00,710446),('1','143','250115','382',532.00,600.00,0.00,1819.75,968107.00,1069290.00,101183.00,710598),('1','143','250342','382',532.00,600.00,0.00,24.00,12768.00,14400.00,1632.00,711179),('1','143','250374','382',532.00,600.00,0.00,2190.67,1165436.44,1286602.00,121165.56,711247),('1','143','250575','382',530.00,600.00,0.00,1840.00,975200.00,1080400.00,105200.00,711766),('1','143','250819','382',530.00,600.00,0.00,1748.15,926519.50,1030890.00,104370.50,712398),('1','143','251039','382',530.00,600.00,0.00,1335.65,707894.50,796990.00,89095.50,712974),('1','143','251287','382',530.00,600.00,0.00,1643.41,871007.30,958686.00,87678.70,713617),('1','143','251535','382',530.00,600.00,0.00,1778.48,942594.40,1045488.00,102893.60,714264),('1','143','251793','382',530.00,600.00,0.00,2709.18,1435865.40,1552913.00,117047.60,714939),('1','143','252023','382',530.00,600.00,0.00,1191.84,631675.20,713104.00,81428.80,715539),('1','143','252262','382',530.00,600.00,0.00,1526.99,809304.70,895074.00,85769.30,716169),('1','143','252498','382',530.00,600.00,0.00,1869.84,991015.20,1097504.00,106488.80,716773),('1','143','252735','382',530.00,600.00,0.00,1834.84,972465.20,1068824.00,96358.80,717395),('1','143','252993','382',530.00,600.00,0.00,864.61,458243.30,518766.00,60522.70,718060),('1','143','253224','382',530.00,600.00,0.00,289.33,153344.90,171598.00,18253.10,718672),('1','143','253306','382',530.00,600.00,0.00,1354.51,717890.30,784506.00,66615.70,718886),('1','143','253497','382',530.00,600.00,0.00,2322.31,1230824.30,1333390.00,102565.70,719374),('1','143','253734','382',530.00,600.00,0.00,1269.50,672835.00,749620.00,76785.00,719983),('1','143','253983','382',530.00,600.00,0.00,1355.49,715649.73,799294.00,83644.27,720634),('1','143','254226','382',527.00,600.00,0.00,1939.42,1022074.34,1131652.00,109577.66,721264),('1','143','254463','382',527.00,600.00,0.00,1641.14,864880.78,972124.00,107243.22,721882),('1','143','254728','382',527.00,600.00,0.00,1546.12,814805.24,908107.60,93302.36,722550),('1','143','254979','382',527.00,600.00,0.00,1911.99,1007618.73,1107594.00,99975.27,723189),('1','143','255224','382',527.00,600.00,0.00,1453.50,765994.50,855460.00,89465.50,723815),('1','143','255490','382',527.00,600.00,0.00,1390.71,732904.17,830826.00,97921.83,724475),('1','143','255730','382',527.00,600.00,0.00,1399.74,737662.98,824644.00,86981.02,725083),('1','143','255991','382',527.00,600.00,0.00,1172.17,617733.59,679942.00,62208.41,725742),('1','143','256075','382',527.00,600.00,0.00,950.74,501039.98,563444.00,62404.02,725958),('1','143','256232','382',527.00,600.00,0.00,1172.10,617696.70,692460.00,74763.30,726329),('1','143','256513','382',527.00,600.00,0.00,924.97,487459.19,550982.00,63522.81,727068),('1','143','256754','382',527.00,600.00,0.00,2696.81,1421218.87,1551411.00,130192.13,727679),('1','143','256992','382',527.00,600.00,0.00,1612.99,850045.73,950534.00,100488.27,728309),('1','143','257252','382',527.00,600.00,0.00,2044.50,1077451.50,1189140.00,111688.50,728989),('1','143','257417','382',527.00,600.00,0.00,0.00,0.00,0.00,0.00,729432),('1','143','257441','382',527.00,600.00,0.00,0.00,0.00,0.00,0.00,729500),('1','143','257514','382',527.00,600.00,0.00,1718.28,905533.56,1015368.00,109834.44,729676),('1','143','257515','382',527.00,600.00,0.00,1295.67,682818.09,775402.00,92583.91,729677),('1','143','257516','382',527.00,600.00,0.00,890.16,469114.32,525256.00,56141.68,729678),('1','143','257517','382',527.00,600.00,0.00,730.33,384883.91,436598.00,51714.09,729679),('1','143','257518','382',527.00,600.00,0.00,91.00,47957.00,54600.00,6643.00,729680),('1','143','257519','382',527.00,600.00,0.00,1906.02,1004472.54,1130052.00,125579.46,729681),('1','143','257520','382',512.00,600.00,0.00,2622.00,1342464.00,1528135.00,185671.00,729682),('1','143','257521','382',512.00,600.00,0.00,677.82,347043.84,406692.00,59648.16,729683),('1','143','257522','382',512.00,600.00,0.00,1380.83,706984.96,821178.00,114193.04,729684),('1','143','257523','382',512.00,600.00,0.00,1346.68,689500.16,801048.00,111547.84,729685),('1','143','257524','382',512.00,600.00,0.00,1827.60,935731.20,1070560.00,134828.80,729686),('1','143','257525','382',512.00,600.00,0.00,1088.33,557224.96,646998.00,89773.04,729687),('1','143','257526','382',512.00,600.00,0.00,1372.01,702469.12,809606.00,107136.88,729688),('1','143','257527','382',512.00,600.00,0.00,1210.38,619714.56,722970.80,103256.24,729689),('1','143','257528','382',512.00,600.00,0.00,135.50,71544.00,76964.00,5420.00,729690),('1','143','257529','382',528.00,568.00,0.00,1087.61,574258.08,615362.48,41104.40,729691),('1','143','257530','382',528.00,568.00,0.00,1173.96,619850.88,660809.28,40958.40,729692),('1','143','257531','382',528.00,568.00,0.00,2030.45,1072077.60,1144799.60,72722.00,729693),('1','143','257532','382',528.00,568.00,0.00,1842.58,972882.24,1035106.24,62224.00,729694),('1','143','257533','382',528.00,568.00,0.00,1673.14,883417.92,946743.52,63325.60,729695),('1','143','257534','382',528.00,568.00,0.00,1423.59,748242.55,797199.12,48956.57,729696),('1','143','257535','382',517.00,568.00,0.00,0.00,0.00,0.00,0.00,729697),('1','143','257536','382',517.00,568.00,0.00,0.00,0.00,0.00,0.00,729698),('1','143','257537','382',517.00,568.00,0.00,1171.22,605520.74,661700.96,56180.22,729699),('1','143','257538','382',517.00,568.00,0.00,1072.06,554255.02,605930.08,51675.06,729700),('1','143','257539','382',517.00,568.00,0.00,1366.21,706330.57,764007.28,57676.71,729701),('1','143','257540','382',517.00,568.00,0.00,1158.52,598954.84,652039.36,53084.52,729702),('1','143','257541','382',517.00,568.00,0.00,1438.31,743606.27,809184.08,65577.81,729703),('1','143','257542','382',517.00,568.00,0.00,1055.11,545491.87,596902.48,51410.61,729704),('1','143','257543','382',517.00,568.00,0.00,1159.10,599254.70,655968.80,56714.10,729705),('1','143','257544','382',517.00,568.00,0.00,1460.83,755249.11,822071.44,66822.33,729706),('1','143','257545','382',517.00,568.00,0.00,1247.68,645050.56,708682.24,63631.68,729707),('1','143','257546','382',517.00,568.00,0.00,1509.39,780354.63,852605.52,72250.89,729708),('1','143','257547','382',517.00,568.00,0.00,1378.59,712731.03,781479.12,68748.09,729709),('1','143','257548','382',517.00,568.00,0.00,229.22,118506.74,130196.96,11690.22,729710),('1','143','257549','382',517.00,568.00,0.00,1202.84,621868.28,674477.12,52608.84,729711),('1','143','257550','382',517.00,568.00,0.00,1445.03,747080.51,818977.04,71896.53,729712),('1','143','257551','382',517.00,568.00,0.00,1459.01,754308.17,826917.68,72609.51,729713),('1','143','257552','382',517.00,568.00,0.00,1785.39,923046.63,1004261.52,81214.89,729714),('1','143','257553','382',517.00,568.00,0.00,0.00,0.00,0.00,0.00,729715),('1','143','257554','382',517.00,568.00,0.00,1666.27,861461.59,937926.88,76465.29,729716),('1','143','257555','382',517.00,568.00,0.00,1281.93,662757.81,725736.24,62978.43,729717),('1','143','257556','382',517.00,568.00,0.00,1183.74,611993.58,755193.60,143200.02,729718),('1','143','257557','382',517.00,640.00,0.00,1336.90,691177.30,854616.00,163438.70,729719),('1','143','257558','382',517.00,640.00,0.00,1321.15,683034.55,838536.00,155501.45,729720),('1','143','257559','382',517.00,640.00,0.00,1889.22,976726.74,1209100.80,232374.06,729721),('1','143','257560','382',517.00,640.00,0.00,1815.19,938453.23,1150741.60,212288.37,729722),('1','143','257561','382',517.00,640.00,0.00,1930.89,998270.13,1230289.60,232019.47,729723),('1','143','257562','382',517.00,680.00,0.00,1904.10,984419.70,1267410.40,282990.70,729724),('1','143','257563','382',517.00,680.00,0.00,1201.73,621294.41,816216.40,194921.99,729725),('1','143','257564','382',517.00,680.00,0.00,1046.04,540802.68,704107.20,163304.52,729726),('1','143','257565','382',517.00,680.00,0.00,1042.03,538729.51,703020.40,164290.89,729727),('1','143','257566','382',517.00,680.00,0.00,988.22,510909.74,654389.60,143479.86,729728),('1','143','257567','382',517.00,680.00,0.00,1245.84,644099.28,830671.20,186571.92,729729),('1','143','257568','382',517.00,680.00,0.00,1709.60,883863.20,1126690.00,242826.80,729730),('1','143','257569','382',517.00,680.00,0.00,1246.31,644342.27,833490.80,189148.53,729731),('1','143','257570','382',517.00,680.00,0.00,464.07,239924.19,309567.60,69643.41,729732),('1','143','257571','382',517.00,680.00,0.00,707.27,365658.59,474943.60,109285.01,729733),('1','143','257572','382',517.00,680.00,0.00,302.45,156366.65,198386.00,42019.35,729734),('1','143','257573','382',612.00,680.00,0.00,1136.91,695788.92,769778.80,73989.88,729735),('1','143','257574','382',612.00,680.00,0.00,890.95,545261.40,599846.00,54584.60,729736),('1','143','257575','382',612.00,680.00,0.00,1114.20,681890.40,750430.80,68540.40,729737),('1','143','257576','382',612.00,680.00,0.00,1191.14,728977.68,809975.20,80997.52,729738),('1','143','257577','382',612.00,680.00,0.00,1103.29,675213.48,743625.20,68411.72,729739),('1','143','257578','382',612.00,680.00,0.00,1837.10,1124305.20,1234408.00,110102.80,729740),('1','143','257579','382',612.00,680.00,0.00,1550.03,948618.36,1036339.00,87720.64,729741),('1','143','257580','382',612.00,680.00,0.00,2003.24,1225982.88,1358403.20,132420.32,729742),('1','143','257581','382',612.00,650.00,0.00,2342.85,1433824.20,1511963.10,78138.90,729743),('1','143','257582','382',612.00,650.00,0.00,247.64,151555.68,160966.00,9410.32,729744),('1','143','257583','382',612.00,650.00,0.00,39.36,24088.32,25584.00,1495.68,729745),('1','143','257584','382',612.00,650.00,0.00,0.00,0.00,0.00,0.00,729746),('1','143','257585','382',612.00,650.00,0.00,1169.37,715654.44,758590.50,42936.06,729747),('1','143','257586','382',612.00,650.00,0.00,1888.70,1155884.40,1223155.00,67270.60,729748),('1','143','257587','382',612.00,650.00,0.00,668.94,409391.28,426936.00,17544.72,729749),('1','143','257588','382',612.00,650.00,0.00,770.03,471258.36,494287.90,23029.54,729750),('1','143','257589','382',612.00,650.00,0.00,1414.62,865747.44,917703.00,51955.56,729751),('1','143','257590','382',612.00,650.00,0.00,1103.83,675543.96,715989.50,40445.54,729752),('1','143','257591','382',612.00,650.00,0.00,863.68,528572.16,560117.00,31544.84,729753),('1','143','257592','382',612.00,650.00,0.00,1051.94,643787.28,681438.40,37651.12,729754),('1','143','257593','382',612.00,650.00,0.00,917.82,561705.84,593283.00,31577.16,729755),('1','143','257594','382',612.00,650.00,0.00,1147.24,702110.88,740486.00,38375.12,729756),('1','143','257595','382',612.00,650.00,0.00,715.52,437898.24,465088.00,27189.76,729757),('1','143','257596','382',612.00,650.00,0.00,1324.15,810379.80,850197.50,39817.70,729758),('1','143','257597','382',612.00,650.00,0.00,1622.93,993233.16,1016565.01,23331.85,729759),('1','143','257598','382',612.00,650.00,0.00,706.51,432384.12,445685.99,13301.87,729760),('1','143','257599','382',612.00,650.00,0.00,766.75,469251.00,498387.50,29136.50,729761),('1','143','257600','382',612.00,650.00,0.00,988.73,605102.76,636674.50,31571.74,729762),('1','143','257601','382',612.00,650.00,0.00,1185.40,725464.80,761900.00,36435.20,729763),('1','143','257602','382',612.00,650.00,0.00,1211.49,741431.88,787468.50,46036.62,729764),('1','143','257603','382',612.00,650.00,0.00,1105.85,676780.20,717302.50,40522.30,729765),('1','143','257604','382',612.00,650.00,0.00,1187.71,726878.52,758556.50,31677.98,729766),('1','143','257605','382',612.00,650.00,0.00,1086.10,664693.20,696965.00,32271.80,729767),('1','143','257606','382',612.00,650.00,0.00,985.63,599497.56,634284.50,34786.94,729768),('1','143','257607','382',602.00,650.00,0.00,1234.43,743126.86,789059.80,45932.94,729769),('1','143','257608','382',602.00,650.00,0.00,1465.32,882122.64,936881.40,54758.76,729770),('1','143','257609','382',602.00,650.00,0.00,3192.71,1922011.42,2017283.50,95272.08,729771),('1','143','257610','382',602.00,650.00,0.00,1473.24,886890.48,945882.60,58992.12,729772),('1','143','257611','382',602.00,650.00,0.00,182.81,110051.62,118826.50,8774.88,729773),('1','143','257612','382',602.00,650.00,0.00,627.82,377947.64,408083.00,30135.36,729774),('1','143','257613','382',602.00,650.00,0.00,735.41,442716.82,471643.30,28926.48,729775),('1','143','257614','382',602.00,650.00,0.00,961.14,578606.28,618471.00,39864.72,729776),('1','143','257615','382',602.00,650.00,0.00,292.38,176012.76,188547.00,12534.24,729777),('1','143','257616','382',602.00,650.00,0.00,717.94,432199.88,455579.60,23379.72,729778),('1','143','257617','382',602.00,650.00,0.00,941.58,566831.16,608037.00,41205.84,729779),('1','143','257618','382',602.00,650.00,0.00,998.74,601241.48,644681.00,43439.52,729780),('1','143','257619','382',602.00,650.00,0.00,986.02,593584.04,640913.00,47328.96,729781),('1','143','257620','382',602.00,650.00,0.00,1855.92,1117263.84,1185588.00,68324.16,729782),('1','143','257621','382',602.00,650.00,0.00,1870.37,1125962.74,1204130.50,78167.76,729783),('1','143','257622','382',602.00,650.00,0.00,1549.86,933015.72,1004409.00,71393.28,729784),('1','143','257623','382',602.00,650.00,0.00,1412.81,850511.62,915101.50,64589.88,729785),('1','143','257624','382',602.00,650.00,0.00,1418.14,853720.28,918791.00,65070.72,729786),('1','143','257625','382',602.00,696.00,0.00,1956.51,1177819.02,1346330.96,168511.94,729787),('1','143','257626','382',602.00,696.00,0.00,613.71,369453.42,424967.24,55513.82,729788),('1','143','257627','382',602.00,696.00,0.00,1391.90,837923.80,961722.40,123798.60,729789),('1','143','257628','382',602.00,696.00,0.00,2019.66,1215835.32,1385933.96,170098.64,729790),('1','143','257629','382',602.00,696.00,0.00,1600.29,963374.58,1109093.84,145719.26,729791),('1','143','257630','382',602.00,696.00,0.00,1497.27,901356.54,1042099.92,140743.38,729792),('1','143','257631','382',602.00,696.00,0.00,2033.02,1223878.04,1414981.92,191103.88,729793),('1','143','257632','382',602.00,696.00,0.00,1222.15,735734.30,850616.40,114882.10,729794),('1','143','257633','382',602.00,696.00,0.00,1276.56,768489.12,888485.76,119996.64,729795),('1','143','257634','382',602.00,696.00,0.00,1319.00,794038.00,918024.00,123986.00,729796),('1','143','257635','382',602.00,696.00,0.00,3605.47,2370048.24,2440914.52,70866.28,729797),('1','143','257636','382',672.00,740.00,0.00,1349.01,906534.72,984517.40,77982.68,729798),('1','143','257637','382',672.00,740.00,0.00,1347.69,905647.68,977798.60,72150.92,729799),('1','143','257638','382',672.00,740.00,0.00,1741.86,1170529.92,1281320.40,110790.48,729800),('1','143','257639','382',672.00,740.00,0.00,1830.79,1230290.88,1334911.12,104620.24,729801),('1','143','257640','382',672.00,740.00,0.00,1271.28,854300.16,935731.20,81431.04,729802),('1','143','257641','382',672.00,740.00,0.00,155.02,104173.44,114714.80,10541.36,729803),('1','143','257642','382',672.00,740.00,0.00,1322.74,888881.28,966221.60,77340.32,729804),('1','143','257643','382',672.00,740.00,0.00,1868.18,1255416.96,1367493.20,112076.24,729805),('1','143','257644','382',672.00,740.00,0.00,1743.98,1171954.56,1263793.20,91838.64,729806),('1','143','257645','382',672.00,740.00,0.00,2418.96,1625541.12,1760748.40,135207.28,729807),('1','143','257646','382',672.00,740.00,0.00,1695.47,1139355.84,1233747.80,94391.96,729808),('1','143','257647','382',672.00,740.00,0.00,1717.97,1154475.84,1267161.80,112685.96,729809),('1','143','257648','382',672.00,740.00,0.00,2250.01,1505752.92,1636407.40,130654.48,729810),('1','143','257649','382',662.00,740.00,0.00,2203.18,1458505.16,1605607.60,147102.44,729811),('1','143','257650','382',662.00,740.00,0.00,1587.51,1050931.62,1161623.40,110691.78,729812),('1','143','257651','382',662.00,740.00,0.00,1520.93,1006855.66,1106623.64,99767.98,729813),('1','143','257652','382',662.00,740.00,0.00,1363.21,902445.02,1049671.70,147226.68,729814),('1','143','257653','382',662.00,770.00,0.00,1788.67,1184099.54,1349275.90,165176.36,729815),('1','143','257654','382',662.00,770.00,0.00,1329.07,879844.34,1014320.40,134476.06,729816),('1','143','257655','382',662.00,770.00,0.00,835.22,552915.64,629596.90,76681.26,729817),('1','143','257656','382',662.00,770.00,0.00,583.98,386594.76,434664.60,48069.84,729818),('1','143','257657','382',662.00,770.00,0.00,1459.69,966314.78,1112511.30,146196.52,729819),('1','143','257658','382',662.00,770.00,0.00,1419.33,939596.46,1081684.10,142087.64,729820),('1','143','257659','382',662.00,770.00,0.00,713.84,472562.08,549656.80,77094.72,729821),('1','143','257660','382',662.00,770.00,0.00,981.31,649627.22,731208.70,81581.48,729822),('1','143','257661','382',662.00,770.00,0.00,1441.17,954054.54,1106700.90,152646.36,729823),('1','143','257662','382',662.00,770.00,0.00,1761.53,1181378.56,1337378.10,155999.54,729824),('1','143','257663','382',692.00,770.00,0.00,1473.52,1019675.84,1133110.40,113434.56,729825),('1','143','257664','382',692.00,770.00,0.00,1807.91,1251073.72,1373040.70,121966.98,729826),('1','143','257665','382',692.00,770.00,0.00,1426.27,986978.84,1098227.90,111249.06,729827),('1','143','257666','382',692.00,770.00,0.00,1417.36,980813.12,1078867.20,98054.08,729828),('1','143','257667','382',692.00,770.00,0.00,1434.28,992521.76,1095895.60,103373.84,729829),('1','143','257668','382',692.00,770.00,0.00,250.54,173373.68,192915.80,19542.12,729830),('1','143','257669','382',692.00,770.00,0.00,1416.53,980238.76,1070603.10,90364.34,729831),('1','143','257670','382',692.00,770.00,0.00,1992.92,1379100.64,1505023.40,125922.76,729832),('1','143','257671','382',692.00,770.00,0.00,1550.25,1072773.00,1172667.50,99894.50,729833),('1','143','257672','382',692.00,770.00,0.00,1394.59,965056.28,1056334.30,91278.02,729834),('1','143','257673','382',692.00,770.00,0.00,1708.58,1182337.36,1290956.60,108619.24,729835),('1','143','257674','382',692.00,770.00,0.00,1827.22,1264436.24,1381206.40,116770.16,729836),('1','143','257675','382',692.00,770.00,0.00,2079.19,1438799.48,1574893.30,136093.82,729837),('1','143','257676','382',692.00,770.00,0.00,1773.35,1227158.20,1339679.50,112521.30,729838),('1','143','257677','382',692.00,770.00,0.00,2031.61,1405874.12,1532124.70,126250.58,729839),('1','143','257678','382',692.00,770.00,0.00,1929.71,1335359.32,1459306.70,123947.38,729840),('1','143','257679','382',692.00,770.00,0.00,2245.24,1553706.08,1715734.80,162028.72,729841),('1','143','257680','382',692.00,770.00,0.00,2675.74,1851612.08,2040437.80,188825.72,729842),('1','143','257681','382',692.00,770.00,0.00,2672.35,1849266.20,2046759.50,197493.30,729843),('1','143','257682','382',692.00,770.00,0.00,3218.32,2227077.44,2424531.40,197453.96,729844),('1','143','257683','382',692.00,770.00,0.00,2773.39,1919185.88,2109240.80,190054.92,729845),('1','143','257684','382',692.00,770.00,0.00,955.75,661379.00,704577.50,43198.50,729846),('1','143','257685','382',692.00,770.00,0.00,908.12,628419.04,676331.90,47912.86,729847),('1','143','257686','382',692.00,770.00,0.00,1195.78,827479.76,892400.60,64920.84,729848),('1','143','257687','382',692.00,770.00,0.00,1220.78,844779.76,909839.60,65059.84,729849),('1','143','257688','382',692.00,770.00,0.00,1235.77,855152.84,921907.90,66755.06,729850),('1','143','257689','382',692.00,770.00,0.00,701.51,485444.92,529511.20,44066.28,729851),('1','143','257690','382',692.00,770.00,0.00,375.48,259832.16,281569.60,21737.44,729852),('1','143','257691','382',692.00,770.00,0.00,1300.59,900008.28,970704.30,70696.02,729853),('1','143','257692','382',692.00,770.00,0.00,963.62,666825.04,725965.90,59140.86,729854),('1','143','257693','382',692.00,770.00,0.00,1259.75,871747.00,948132.50,76385.50,729855),('1','143','257694','382',692.00,770.00,0.00,1132.04,783371.68,857870.80,74499.12,729856),('1','143','257695','382',692.00,770.00,0.00,1507.72,1043342.24,1155944.40,112602.16,729857),('1','143','257696','382',692.00,770.00,0.00,1491.31,1031986.52,1128383.70,96397.18,729858),('1','143','257697','382',692.00,770.00,0.00,1477.12,1022167.04,1128332.40,106165.36,729859),('1','143','257698','382',692.00,770.00,0.00,1390.50,962226.00,1061285.00,99059.00,729860),('1','143','257699','382',692.00,770.00,0.00,1329.28,919861.76,1021045.60,101183.84,729861),('1','143','257700','382',692.00,770.00,0.00,1296.07,896880.44,997973.90,101093.46,729862),('1','143','257701','382',692.00,770.00,0.00,1334.13,923217.96,1022280.10,99062.14,729863),('1','143','257702','382',692.00,770.00,0.00,1680.52,1162919.84,1294000.40,131080.56,729864),('1','143','257703','382',692.00,770.00,0.00,1309.57,906222.44,1005868.90,99646.46,729865),('1','143','257704','382',692.00,770.00,0.00,941.69,651649.48,725101.30,73451.82,729866),('1','143','257705','382',692.00,770.00,0.00,297.21,205669.32,228851.70,23182.38,729867),('1','143','257706','382',692.00,770.00,0.00,1621.08,1121787.36,1243731.60,121944.24,729868),('1','143','257707','382',692.00,770.00,0.00,1517.56,1050151.52,1165646.20,115494.68,729869),('1','143','257708','382',692.00,770.00,0.00,0.00,0.00,0.00,0.00,729870),('1','143','257709','382',692.00,770.00,0.00,1656.52,1146311.84,1275520.40,129208.56,729871),('1','143','257710','382',692.00,770.00,0.00,1896.22,1312184.24,1460089.40,147905.16,729872),('1','143','257711','382',692.00,770.00,0.00,1696.73,1174137.16,1306482.10,132344.94,729873),('1','143','257712','382',692.00,770.00,0.00,1742.69,1205941.48,1341871.30,135929.82,729874),('1','143','257713','382',692.00,770.00,0.00,1765.34,1221615.28,1359311.80,137696.52,729875),('1','143','257714','382',692.00,770.00,0.00,2088.07,1444944.44,1607813.90,162869.46,729876),('1','143','257715','382',692.00,770.00,0.00,2223.69,1538793.48,1709741.30,170947.82,729877),('1','143','257716','382',692.00,770.00,0.00,2024.89,1401223.88,1554165.30,152941.42,729878),('1','143','257717','382',692.00,770.00,0.00,1633.62,1130465.04,1257887.40,127422.36,729879),('1','143','257718','382',692.00,770.00,0.00,2012.75,1392823.00,1549817.50,156994.50,729880),('1','143','257719','382',692.00,770.00,0.00,1426.19,986923.48,1098166.30,111242.82,729881),('1','143','257720','382',692.00,770.00,0.00,1842.45,1274975.40,1406411.50,131436.10,729882),('1','143','257721','382',692.00,770.00,0.00,1477.67,1022547.64,1136605.90,114058.26,729883),('1','143','257722','382',692.00,770.00,0.00,1890.61,1308302.12,1455769.70,147467.58,729884),('1','143','257723','382',692.00,770.00,0.00,1590.69,1100757.48,1221956.30,121198.82,729885),('1','143','257724','382',692.00,770.00,0.00,1756.45,1215463.40,1344966.50,129503.10,729886),('1','143','257725','382',692.00,770.00,0.00,1862.78,1289043.76,1434340.60,145296.84,729887),('1','143','257726','382',692.00,770.00,0.00,2186.20,1512850.40,1680874.00,168023.60,729888),('1','143','257727','382',692.00,770.00,0.00,1293.44,895060.48,995948.80,100888.32,729889),('1','143','257728','382',692.00,770.00,0.00,68.90,47678.80,53053.00,5374.20,729890),('1','143','257729','382',685.00,770.00,0.00,1040.64,712838.40,796292.80,83454.40,729891),('1','143','257730','382',685.00,770.00,0.00,1696.68,1162225.80,1298931.60,136705.80,729892),('1','143','257731','382',685.00,770.00,0.00,1374.49,941525.65,1055482.30,113956.65,729893),('1','143','257732','382',685.00,770.00,0.00,1018.86,697919.10,784522.20,86603.10,729894),('1','143','257733','382',685.00,770.00,0.00,1304.31,893452.35,1001318.70,107866.35,729895),('1','143','257734','382',685.00,770.00,0.00,1014.53,694953.05,778288.10,83335.05,729896),('1','143','257735','382',685.00,770.00,0.00,1353.04,926832.40,1038840.80,112008.40,729897),('1','143','257736','382',685.00,770.00,0.00,1471.36,1007881.60,1113147.20,105265.60,729898),('1','143','257737','382',685.00,770.00,0.00,1520.49,1041535.65,1161377.30,119841.65,729899),('1','143','257738','382',685.00,770.00,0.00,1628.09,1115241.65,1253629.30,138387.65,729900),('1','143','257739','382',685.00,770.00,0.00,1328.53,910043.05,1014268.10,104225.05,729901),('1','143','257740','382',685.00,770.00,0.00,1731.94,1186378.90,1327793.80,141414.90,729902),('1','143','257741','382',685.00,770.00,0.00,1454.09,996051.65,1119649.30,123597.65,729903),('1','143','257742','382',685.00,770.00,0.00,2117.97,1450809.45,1627961.90,177152.45,729904),('1','143','257743','382',685.00,770.00,0.00,397.54,272314.90,303493.30,31178.40,729905),('1','143','257744','382',685.00,770.00,0.00,1355.42,928462.70,1038651.40,110188.70,729906),('1','143','257745','382',685.00,770.00,0.00,2388.89,1636389.65,1827645.30,191255.65,729907),('1','143','257746','382',685.00,770.00,0.00,1945.01,1332331.85,1497032.70,164700.85,729908),('1','143','257747','382',685.00,770.00,0.00,1435.19,983105.15,1099196.30,116091.15,729909),('1','143','257748','382',685.00,770.00,0.00,1741.21,1192728.85,1327431.70,134702.85,729910),('1','143','257749','382',685.00,770.00,0.00,1250.42,856537.70,959923.40,103385.70,729911),('1','143','257750','382',685.00,770.00,0.00,1581.93,1083622.05,1209311.10,125689.05,729912),('1','143','257751','382',685.00,770.00,0.00,1542.02,1056283.70,1187355.40,131071.70,729913),('1','143','257752','382',685.00,770.00,0.00,1270.48,870278.80,978269.60,107990.80,729914),('1','143','257753','382',685.00,770.00,0.00,1504.60,1030651.00,1151042.00,120391.00,729915),('1','143','257754','382',685.00,770.00,0.00,1295.30,887280.50,994601.00,107320.50,729916),('1','143','257755','382',685.00,770.00,0.00,983.69,673827.65,757441.30,83613.65,729917),('1','143','257756','382',685.00,770.00,0.00,442.33,302996.05,340594.10,37598.05,729918),('1','143','257757','382',685.00,770.00,0.00,668.56,457963.60,514791.20,56827.60,729919),('1','143','257758','382',685.00,770.00,0.00,1044.09,715201.65,794549.30,79347.65,729920),('1','143','257759','382',685.00,770.00,0.00,1341.47,918906.95,1022631.90,103724.95,729921),('1','143','257760','382',685.00,770.00,0.00,1422.01,974076.85,1092072.70,117995.85,729922),('1','143','257761','382',685.00,770.00,0.00,1416.99,970638.15,1091082.30,120444.15,729923),('1','143','257762','382',685.00,770.00,0.00,1244.61,852557.85,958349.70,105791.85,729924),('1','143','257763','382',685.00,770.00,0.00,1361.87,932880.95,1048639.90,115758.95,729925),('1','143','257764','382',685.00,770.00,0.00,1304.60,893651.00,1004542.00,110891.00,729926),('1','143','257765','382',685.00,770.00,0.00,1196.42,819547.70,911743.40,92195.70,729927),('1','143','257766','382',685.00,770.00,0.00,1359.80,931463.00,1034546.00,103083.00,729928),('1','143','257767','382',685.00,770.00,0.00,1451.60,994346.00,1115732.00,121386.00,729929),('1','143','257768','382',685.00,770.00,0.00,1768.63,1211511.55,1354345.10,142833.55,729930),('1','143','257769','382',685.00,770.00,0.00,1182.03,804650.95,902663.10,98012.15,729931),('1','143','257770','382',677.00,770.00,0.00,1435.14,971589.78,1094682.80,123093.02,729932),('1','143','257771','382',677.00,770.00,0.00,648.83,439257.91,499599.10,60341.19,729933),('1','143','257772','382',677.00,770.00,0.00,450.20,304785.40,346654.00,41868.60,729934),('1','143','257773','382',677.00,770.00,0.00,1093.27,740143.79,834317.90,94174.11,729935),('1','143','257774','382',677.00,770.00,0.00,1402.81,949702.37,1080163.70,130461.33,729936),('1','143','257775','382',677.00,720.00,0.00,0.00,0.00,0.00,0.00,729937),('1','143','257776','382',677.00,770.00,0.00,1599.37,1082773.49,1231514.90,148741.41,729938),('1','143','257777','382',677.00,770.00,0.00,1427.43,966370.11,1099121.10,132750.99,729939),('1','143','257778','382',677.00,770.00,0.00,1406.92,952484.84,1083328.40,130843.56,729940),('1','143','257779','382',677.00,770.00,0.00,1266.21,857224.17,972106.70,114882.53,729941),('1','143','257780','382',677.00,770.00,0.00,1389.07,940400.39,1062083.90,121683.51,729942),('1','143','257781','382',677.00,770.00,0.00,1454.33,984581.41,1110434.10,125852.69,729943),('1','143','257782','382',677.00,770.00,0.00,1219.67,825716.59,939145.90,113429.31,729944),('1','143','257783','382',677.00,770.00,0.00,1837.79,1244183.83,1407598.30,163414.47,729945),('1','143','257784','382',677.00,770.00,0.00,1716.92,1162354.84,1318969.40,156614.56,729946),('1','143','257785','382',677.00,770.00,0.00,1482.05,1003347.85,1138678.50,135330.65,729947),('1','143','257786','382',677.00,770.00,0.00,553.34,374611.18,426071.80,51460.62,729948),('1','143','257787','382',677.00,770.00,0.00,658.39,445730.03,505960.30,60230.27,729949),('1','143','257788','382',677.00,770.00,0.00,1109.32,751009.64,852926.40,101916.76,729950),('1','143','257789','382',677.00,770.00,0.00,1464.54,991493.58,1114195.80,122702.22,729951),('1','143','257790','382',677.00,720.00,0.00,0.00,0.00,0.00,0.00,729952),('1','143','257791','382',677.00,770.00,0.00,2022.99,1369564.23,1516452.30,146888.07,729953),('1','143','257792','382',677.00,770.00,0.00,2171.11,1469841.47,1622504.70,152663.23,729954),('1','143','257793','382',677.00,770.00,0.00,1869.16,1265421.32,1416253.20,150831.88,729955),('1','143','257794','382',677.00,770.00,0.00,3360.25,2274889.25,2477911.50,203022.25,729956),('1','143','257795','382',677.00,770.00,0.00,3620.30,2450943.10,2670931.00,219987.90,729957),('1','143','257796','382',677.00,770.00,0.00,2140.17,1448895.09,1608180.90,159285.81,729958),('1','143','257797','382',677.00,770.00,0.00,3147.04,2130546.08,2337970.80,207424.72,729959),('1','143','257798','382',677.00,770.00,0.00,2022.51,1369239.27,1516905.70,147666.43,729960),('1','143','257799','382',677.00,770.00,0.00,289.80,196194.60,212196.00,16001.40,729961),('1','143','257800','382',677.00,770.00,0.00,3781.69,2560204.13,2789473.80,229269.67,729962),('1','143','257801','382',677.00,718.00,0.00,0.00,0.00,0.00,0.00,729963),('1','143','257802','382',677.00,770.00,0.00,2944.59,1993487.43,2204518.30,211030.87,729964),('1','143','257803','382',677.00,770.00,0.00,5037.76,3410563.52,3689368.70,278805.18,729965),('1','143','257804','382',677.00,770.00,0.00,5314.74,3598078.98,3906931.30,308852.32,729966),('1','143','257805','382',677.00,770.00,0.00,1517.26,1027185.02,1110727.70,83542.68,729967),('1','143','257806','382',677.00,770.00,0.00,2557.84,1741857.76,1924729.50,182871.74,729968),('1','143','257807','382',685.00,718.00,0.00,0.00,0.00,0.00,0.00,729969),('1','143','257808','382',685.00,790.00,0.00,4363.85,2989237.25,3303900.50,314663.25,729970),('1','143','257809','382',685.00,790.00,0.00,2887.63,1978026.55,2201170.20,223143.65,729971),('1','143','257810','382',685.00,790.00,0.00,2889.30,1979170.50,2226300.00,247129.50,729972),('1','143','257811','382',685.00,790.00,0.00,3814.63,2613021.55,2930942.70,317921.15,729973),('1','143','257812','382',685.00,790.00,0.00,1913.26,1310583.10,1511475.40,200892.30,729974),('1','143','257813','382',685.00,790.00,0.00,340.36,233146.60,251866.40,18719.80,729975),('1','143','257814','382',685.00,790.00,0.00,2559.21,1753058.85,1986125.90,233067.05,729976),('1','143','257815','382',685.00,790.00,0.00,2345.33,1606551.05,1823060.70,216509.65,729977),('1','143','257816','382',685.00,790.00,0.00,3235.84,2216550.40,2471367.10,254816.70,729978),('1','143','257817','382',685.00,790.00,0.00,2397.02,1641958.70,1852870.80,210912.10,729979),('1','143','257818','382',685.00,790.00,0.00,2052.84,1406195.40,1593143.60,186948.20,729980),('1','143','257819','382',685.00,790.00,0.00,1720.07,1178247.95,1330565.80,152317.85,729981),('1','143','257820','382',685.00,790.00,0.00,2091.13,1432424.05,1608867.70,176443.65,729982),('1','143','257821','382',685.00,790.00,0.00,2299.10,1574883.50,1778789.00,203905.50,729983),('1','143','257822','382',685.00,790.00,0.00,1457.61,998462.85,1144011.90,145549.05,729984),('1','143','257823','382',685.00,790.00,0.00,1943.45,1331263.25,1503950.50,172687.25,729985),('1','143','257824','382',685.00,790.00,0.00,2581.60,1768396.00,1984862.50,216466.50,729986),('1','143','257825','382',685.00,790.00,0.00,4590.03,3144170.55,3461000.20,316829.65,729987),('1','143','257826','382',685.00,738.00,0.00,0.00,0.00,0.00,0.00,729988),('1','143','257827','382',685.00,790.00,0.00,2184.79,1496581.15,1691084.10,194502.95,729989),('1','143','257828','382',685.00,790.00,0.00,2141.36,1464698.72,1636274.40,171575.68,729990),('1','143','257829','382',682.00,790.00,0.00,1653.94,1127987.08,1281223.10,153236.02,729991),('1','143','257830','382',682.00,790.00,0.00,2277.40,1553186.80,1760329.50,207142.70,729992),('1','143','257831','382',682.00,790.00,0.00,150.29,102497.78,115595.60,13097.82,729993),('1','143','257832','382',682.00,790.00,0.00,2372.13,1617792.66,1806907.70,189115.04,729994),('1','143','257833','382',682.00,738.00,0.00,0.00,0.00,0.00,0.00,729995),('1','143','257834','382',682.00,790.00,0.00,2012.43,1372477.26,1548219.70,175742.44,729996),('1','143','257835','382',682.00,790.00,0.00,2695.48,1838317.36,2064329.20,226011.84,729997),('1','143','257836','382',682.00,790.00,0.00,2018.19,1376405.58,1554620.10,178214.52,729998),('1','143','257837','382',682.00,790.00,0.00,2252.10,1535932.20,1744134.00,208201.80,729999),('1','143','257838','382',682.00,790.00,0.00,1811.58,1235497.56,1418898.20,183400.64,730000),('1','143','257839','382',682.00,790.00,0.00,1956.27,1334176.14,1521953.30,187777.16,730001),('1','143','257840','382',682.00,790.00,0.00,1962.24,1338247.68,1520695.60,182447.92,730002),('1','143','257841','382',682.00,790.00,0.00,68.94,47017.08,54462.60,7445.52,730003),('1','143','257842','382',682.00,790.00,0.00,2053.44,1400446.08,1585967.60,185521.52,730004),('1','143','257843','382',682.00,790.00,0.00,1885.59,1285972.38,1474616.10,188643.72,730005),('1','143','257844','382',682.00,738.00,0.00,0.00,0.00,0.00,0.00,730006),('1','143','257845','382',682.00,790.00,0.00,1232.90,840837.80,970891.00,130053.20,730007),('1','143','257846','382',682.00,790.00,0.00,408.91,278876.62,317663.90,38787.28,730008),('1','143','257847','382',682.00,790.00,0.00,2024.02,1380381.64,1579375.80,198994.16,730009),('1','143','257848','382',682.00,790.00,0.00,2036.17,1388667.94,1586199.30,197531.36,730010),('1','143','257849','382',682.00,790.00,0.00,1994.81,1360460.42,1562849.90,202389.48,730011),('1','143','257850','382',682.00,790.00,0.00,2191.54,1494630.28,1712166.60,217536.32,730012),('1','143','257851','382',682.00,790.00,0.00,2069.72,1411549.04,1605328.80,193779.76,730013),('1','143','257852','382',682.00,790.00,0.00,1823.46,1243599.72,1415583.40,171983.68,730014),('1','143','257853','382',682.00,790.00,0.00,1635.06,1115110.92,1273611.40,158500.48,730015),('1','143','257854','382',682.00,790.00,0.00,188.52,128570.64,148930.80,20360.16,730016),('1','143','257855','382',682.00,790.00,0.00,1827.39,1246279.98,1417513.10,171233.12,730017),('1','143','257856','382',682.00,738.00,0.00,0.00,0.00,0.00,0.00,730018),('1','143','257857','382',682.00,790.00,0.00,2194.45,1496614.90,1698765.50,202150.60,730019),('1','143','257858','382',682.00,790.00,0.00,1369.16,933767.12,1076355.90,142588.78,730020),('1','143','257859','382',682.00,790.00,0.00,1700.10,1159468.20,1327079.00,167610.80,730021),('1','143','257860','382',682.00,770.00,0.00,1606.65,1095735.30,1212770.50,117035.20,730022),('1','143','257861','382',682.00,770.00,0.00,1789.03,1220118.46,1350619.10,130500.64,730023),('1','143','257862','382',682.00,770.00,0.00,1702.92,1161391.44,1272598.40,111206.96,730024),('1','143','257863','382',682.00,770.00,0.00,1668.66,1138026.12,1260633.20,122607.08,730025),('1','143','257864','382',682.00,770.00,0.00,1614.01,1100754.82,1220487.70,119732.88,730026),('1','143','257865','382',682.00,770.00,0.00,1626.96,1109586.72,1238159.20,128572.48,730027),('1','143','257866','382',682.00,770.00,0.00,1958.76,1335874.32,1470145.20,134270.88,730028),('1','143','257867','382',682.00,770.00,0.00,1633.58,1114101.56,1239981.60,125880.04,730029),('1','143','257868','382',682.00,770.00,0.00,1459.57,995426.74,1111468.90,116042.16,730030),('1','143','257869','382',682.00,770.00,0.00,1654.42,1128314.44,1251778.40,123463.96,730031),('1','143','257870','382',682.00,770.00,0.00,1496.67,1020728.94,1147435.90,126706.96,730032),('1','143','257871','382',682.00,770.00,0.00,2530.85,1726039.70,1911904.50,185864.80,730033),('1','143','257872','382',682.00,770.00,0.00,2284.91,1558308.62,1719473.20,161164.58,730034),('1','143','257873','382',682.00,770.00,0.00,1673.70,1141463.40,1278749.00,137285.60,730035),('1','143','257874','382',682.00,770.00,0.00,1882.04,1283551.28,1424120.80,140569.52,730036),('1','143','257875','382',682.00,770.00,0.00,1881.75,1283353.50,1428572.50,145219.00,730037),('1','143','257876','382',682.00,770.00,0.00,1746.49,1191106.18,1324547.30,133441.12,730038),('1','143','257877','382',682.00,770.00,0.00,1578.42,1076482.44,1190633.40,114150.96,730039),('1','143','257878','382',682.00,770.00,0.00,1637.77,1116959.14,1246082.90,129123.76,730040),('1','143','257879','382',682.00,770.00,0.00,1424.55,971543.10,1088153.50,116610.40,730041),('1','143','257880','382',682.00,770.00,0.00,1866.01,1272618.82,1411577.70,138958.88,730042),('1','143','257881','382',682.00,770.00,0.00,1984.12,1353169.84,1509522.40,156352.56,730043),('1','143','257882','382',682.00,770.00,0.00,1971.78,1344753.96,1498370.60,153616.64,730044),('1','143','257883','382',682.00,770.00,0.00,1585.66,1081420.12,1210208.20,128788.08,730045),('1','143','257884','382',676.00,770.00,0.00,2236.12,1511617.12,1699362.40,187745.28,730046),('1','143','257885','382',676.00,770.00,0.00,2061.52,1393587.52,1562170.40,168582.88,730047),('1','143','257886','382',676.00,770.00,0.00,1198.47,810165.72,908321.90,98156.18,730048),('1','143','257887','382',676.00,770.00,0.00,984.48,665508.48,744049.60,78541.12,730049),('1','143','257888','382',676.00,770.00,0.00,2526.76,1708089.76,1901986.70,193896.94,730050),('1','143','257889','382',676.00,770.00,0.00,2388.89,1614889.64,1787526.30,172636.66,730051),('1','143','257890','382',676.00,770.00,0.00,2017.33,1363715.08,1524944.10,161229.02,730052),('1','143','257891','382',676.00,770.00,0.00,1743.08,1178322.08,1317810.60,139488.52,730053),('1','143','257892','382',676.00,770.00,0.00,1730.33,1169703.08,1320454.10,150751.02,730054),('1','143','257893','382',676.00,770.00,0.00,2066.65,1397055.40,1565520.50,168465.10,730055),('1','143','257894','382',676.00,770.00,0.00,1759.46,1189394.96,1339086.70,149691.74,730056),('1','143','257895','382',676.00,770.00,0.00,1914.16,1293972.16,1452953.20,158981.04,730057),('1','143','257896','382',676.00,770.00,0.00,1704.60,1152309.60,1308045.00,155735.40,730058),('1','143','257897','382',676.00,770.00,0.00,1957.06,1322972.56,1486586.20,163613.64,730059),('1','143','257898','382',676.00,716.00,0.00,0.00,0.00,0.00,0.00,730060),('1','143','257899','382',676.00,770.00,0.00,1940.32,1311656.32,1463615.90,151959.58,730061),('1','143','257900','382',676.00,770.00,0.00,2280.41,1541557.16,1711485.20,169928.04,730062),('1','143','257901','382',676.00,770.00,0.00,2100.94,1420235.44,1601042.80,180807.36,730063),('1','143','257902','382',676.00,770.00,0.00,1954.79,1321438.04,1501188.30,179750.26,730064),('1','143','257903','382',676.00,770.00,0.00,2662.18,1799633.68,1986636.10,187002.42,730065),('1','143','257904','382',676.00,770.00,0.00,1511.05,1021469.80,1151508.50,130038.70,730066),('1','143','257905','382',676.00,770.00,0.00,1393.88,942262.88,1063637.60,121374.72,730067),('1','143','257906','382',676.00,770.00,0.00,1811.62,1224655.12,1372447.40,147792.28,730068),('1','143','257907','382',676.00,770.00,0.00,1358.67,918460.92,1032420.40,113959.48,730069),('1','143','257908','382',676.00,770.00,0.00,1312.04,886939.04,1002770.80,115831.76,730070),('1','143','257909','382',676.00,770.00,0.00,1647.16,1113480.16,1259300.20,145820.04,730071),('1','143','257910','382',676.00,770.00,0.00,1092.81,738739.56,838963.70,100224.14,730072),('1','143','257911','382',676.00,716.00,0.00,0.00,0.00,0.00,0.00,730073),('1','143','257912','382',676.00,770.00,0.00,1340.22,905988.72,1023969.40,117980.68,730074),('1','143','257913','382',676.00,770.00,0.00,1300.83,879361.08,998389.10,119028.02,730075),('1','143','257914','382',676.00,770.00,0.00,1512.50,1022450.00,1160125.00,137675.00,730076),('1','143','257915','382',676.00,770.00,0.00,1321.93,893624.68,1014286.10,120661.42,730077),('1','143','257916','382',676.00,770.00,0.00,1711.42,1156919.92,1304893.40,147973.48,730078),('1','143','257917','382',676.00,770.00,0.00,1741.03,1176936.28,1330593.10,153656.82,730079),('1','143','257918','382',676.00,770.00,0.00,1508.32,1019624.32,1155156.40,135532.08,730080),('1','143','257919','382',676.00,770.00,0.00,1291.14,872810.64,990027.80,117217.16,730081),('1','143','257920','382',676.00,770.00,0.00,1391.64,940748.64,1054762.80,114014.16,730082),('1','143','257921','382',676.00,770.00,0.00,1546.29,1045292.04,1188643.30,143351.26,730083),('1','143','257922','382',676.00,770.00,0.00,203.46,137538.96,153414.20,15875.24,730084),('1','143','257923','382',676.00,770.00,0.00,1451.44,981173.44,1108883.80,127710.36,730085),('1','143','257924','382',676.00,770.00,0.00,1393.07,941715.32,1067713.90,125998.58,730086),('1','143','257925','382',676.00,770.00,0.00,1413.83,955749.08,1086199.10,130450.02,730087),('1','143','257926','382',676.00,770.00,0.00,1282.11,866706.36,984874.70,118168.34,730088),('1','143','257927','382',676.00,770.00,0.00,1420.34,960149.84,1088800.30,128650.46,730089),('1','143','257928','382',676.00,770.00,0.00,1249.82,844878.32,952461.40,107583.08,730090),('1','143','257929','382',676.00,770.00,0.00,1243.48,840592.48,954979.60,114387.12,730091),('1','143','257930','382',676.00,770.00,0.00,1193.69,806934.44,915191.30,108256.86,730092),('1','143','257931','382',676.00,770.00,0.00,1316.26,889791.76,1003020.20,113228.44,730093),('1','143','257932','382',676.00,770.00,0.00,1416.28,957405.28,1081213.60,123808.32,730094),('1','143','257933','382',676.00,770.00,0.00,1284.70,868457.20,978219.00,109761.80,730095),('1','143','257934','382',676.00,770.00,0.00,1254.67,848156.92,964095.90,115938.98,730096),('1','143','257935','382',676.00,770.00,0.00,1490.43,1007530.68,1137262.60,129731.92,730097),('1','143','257936','382',676.00,770.00,0.00,1551.08,1048530.08,1187831.60,139301.52,730098),('1','143','257937','382',676.00,770.00,0.00,1530.36,1034523.36,1171377.20,136853.84,730099),('1','143','257938','382',676.00,770.00,0.00,1233.21,833649.96,946321.70,112671.74,730100),('1','143','257939','382',676.00,770.00,0.00,1667.86,1127473.36,1277252.20,149778.84,730101),('1','143','257940','382',676.00,770.00,0.00,1333.32,901324.32,1026656.40,125332.08,730102),('1','143','257941','382',676.00,770.00,0.00,1323.46,894658.96,1011928.20,117269.24,730103),('1','143','257942','382',676.00,770.00,0.00,1694.25,1088195.80,1287072.50,198876.70,730104),('1','143','257943','382',620.00,770.00,0.00,1412.57,875793.40,1082678.90,206885.50,730105),('1','143','257944','382',620.00,770.00,0.00,1758.67,1090375.40,1340575.90,250200.50,730106),('1','143','257945','382',620.00,770.00,0.00,1709.83,1060094.60,1307319.10,247224.50,730107),('1','143','257946','382',620.00,770.00,0.00,1423.46,882545.20,1090380.20,207835.00,730108),('1','143','257947','382',620.00,770.00,0.00,1528.00,947360.00,1164960.00,217600.00,730109),('1','143','257948','382',620.00,770.00,0.00,1203.84,746380.80,922456.80,176076.00,730110),('1','143','257949','382',620.00,770.00,0.00,1374.87,852419.40,1058649.90,206230.50,730111),('1','143','257950','382',620.00,770.00,0.00,703.24,436008.80,537394.80,101386.00,730112),('1','143','257951','382',620.00,770.00,0.00,532.70,330274.00,407679.00,77405.00,730113),('1','143','257952','382',620.00,770.00,0.00,1603.41,994114.20,1224600.70,230486.50,730114),('1','143','257953','382',620.00,718.00,0.00,0.00,0.00,0.00,0.00,730115),('1','143','257954','382',620.00,770.00,0.00,1626.07,1008163.40,1233573.90,225410.50,730116),('1','143','257955','382',620.00,770.00,0.00,1449.60,898752.00,1095442.00,196690.00,730117),('1','143','257956','382',620.00,770.00,0.00,1356.87,841259.40,1041989.90,200730.50,730118),('1','143','257957','382',620.00,770.00,0.00,1594.22,988416.40,1219849.40,231433.00,730119),('1','143','257958','382',620.00,770.00,0.00,1417.55,878881.00,1086513.50,207632.50,730120),('1','143','257959','382',620.00,770.00,0.00,1898.34,1176970.80,1446721.80,269751.00,730121),('1','143','257960','382',620.00,770.00,0.00,2064.48,1279977.60,1577149.60,297172.00,730122),('1','143','257961','382',620.00,770.00,0.00,1719.04,1065804.80,1316760.80,250956.00,730123);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=352 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',351,'143','PRODUCT TANKS','TANK CONTAINIG LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=867 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','143','351',865,1,'382','LPG TANK 1',27000.00,1.00,1534.41,'TANK CONTAINING LPG PRODUCT.','479','2020-12-23 12:53:29','2020-12-23 12:53:29','479',5,1),('1','143','351',866,1,'382','LPG TANK 2',27000.00,1.00,20456.80,'TANK CONTAINING LPG PRODUCT.','479','2020-12-23 12:56:03','2020-12-23 12:56:03','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','143',865,14584.81,'2023-03-20 19:12:59'),(2,'1','143',866,17892.15,'2023-03-20 19:14:47');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2727747 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2108858,'1','143','866',382,'Retail Sale Id 1254428',4001.60,0.00,0.00,0.00,329.40,'2021-12-01 07:09:13','',''),(2108859,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-01 07:09:13','',''),(2108913,'1','143','866',382,'Retail Sale Id 1254442',10168.00,0.00,0.00,0.00,837.00,'2021-12-01 07:10:47','',''),(2108914,'1','143','866',382,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-01 07:10:47','',''),(2108957,'1','143','866',382,'Retail Sale Id 1254459',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 07:12:40','',''),(2108958,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 07:12:40','',''),(2108995,'1','143','866',382,'Retail Sale Id 1254474',6560.00,0.00,0.00,0.00,540.00,'2021-12-01 07:14:23','',''),(2108996,'1','143','866',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 07:14:23','',''),(2109009,'1','143','866',382,'Retail Sale Id 1254485',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 07:15:27','',''),(2109010,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 07:15:27','',''),(2109069,'1','143','866',382,'Retail Sale Id 1254515',13120.00,0.00,0.00,0.00,1080.00,'2021-12-01 07:18:48','',''),(2109070,'1','143','866',382,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-01 07:18:48','',''),(2109087,'1','143','866',382,'Retail Sale Id 1254528',1312.00,0.00,0.00,0.00,108.00,'2021-12-01 07:19:58','',''),(2109088,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 07:19:58','',''),(2109129,'1','143','866',382,'Retail Sale Id 1254541',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 07:21:21','',''),(2109130,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 07:21:21','',''),(2109150,'1','143','866',382,'Retail Sale Id 1254553',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 07:22:19','',''),(2109151,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 07:22:19','',''),(2109209,'1','143','866',382,'Retail Sale Id 1254565',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 07:23:52','',''),(2109210,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 07:23:52','',''),(2109225,'1','143','866',382,'Retail Sale Id 1254572',6999.52,0.00,0.00,0.00,576.18,'2021-12-01 07:24:54','',''),(2109226,'1','143','866',382,'Retail sales',0.00,0.00,0.00,10.67,0.00,'2021-12-01 07:24:54','',''),(2109386,'1','143','866',382,'Retail Sale Id 1254655',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 07:34:28','',''),(2109387,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:34:28','',''),(2109434,'1','143','866',382,'Retail Sale Id 1254680',2000.80,0.00,0.00,0.00,164.70,'2021-12-01 07:36:32','',''),(2109435,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 07:36:32','',''),(2109490,'1','143','866',382,'Retail Sale Id 1254706',9184.00,0.00,0.00,0.00,756.00,'2021-12-01 07:39:06','',''),(2109491,'1','143','866',382,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-01 07:39:06','',''),(2109598,'1','143','866',382,'Retail Sale Id 1254751',2000.80,0.00,0.00,0.00,164.70,'2021-12-01 07:43:11','',''),(2109599,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 07:43:11','',''),(2109616,'1','143','866',382,'Retail Sale Id 1254763',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 07:44:36','',''),(2109617,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 07:44:36','',''),(2109732,'1','143','866',382,'Retail Sale Id 1254808',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 07:48:08','',''),(2109733,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 07:48:08','',''),(2109790,'1','143','866',382,'Retail Sale Id 1254836',16400.00,0.00,0.00,0.00,1350.00,'2021-12-01 07:51:04','',''),(2109791,'1','143','866',382,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 07:51:04','',''),(2109839,'1','143','866',382,'Retail Sale Id 1254857',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 07:53:30','',''),(2109840,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:53:30','',''),(2110110,'1','143','866',382,'Retail Sale Id 1254991',1849.92,0.00,0.00,0.00,152.28,'2021-12-01 08:07:50','',''),(2110111,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.82,0.00,'2021-12-01 08:07:50','',''),(2110124,'1','143','866',382,'Retail Sale Id 1254998',2997.92,0.00,0.00,0.00,246.78,'2021-12-01 08:09:13','',''),(2110125,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-01 08:09:13','',''),(2110284,'1','143','866',382,'Retail Sale Id 1255077',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 08:18:02','',''),(2110285,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:18:02','',''),(2110388,'1','143','866',382,'Retail Sale Id 1255129',2997.92,0.00,0.00,0.00,246.78,'2021-12-01 08:23:41','',''),(2110389,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-01 08:23:41','',''),(2110417,'1','143','866',382,'Retail Sale Id 1255146',7872.00,0.00,0.00,0.00,648.00,'2021-12-01 08:25:50','',''),(2110418,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-01 08:25:50','',''),(2110552,'1','143','866',382,'Retail Sale Id 1255210',2000.80,0.00,0.00,0.00,164.70,'2021-12-01 08:33:46','',''),(2110553,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 08:33:46','',''),(2110583,'1','143','866',382,'Retail Sale Id 1255223',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 08:35:43','',''),(2110584,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:35:43','',''),(2110596,'1','143','866',382,'Retail Sale Id 1255232',2000.80,0.00,0.00,0.00,164.70,'2021-12-01 08:37:07','',''),(2110597,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 08:37:07','',''),(2110744,'1','143','866',382,'Retail Sale Id 1255299',2624.00,0.00,0.00,0.00,216.00,'2021-12-01 08:44:19','',''),(2110745,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 08:44:19','',''),(2110824,'1','143','866',382,'Retail Sale Id 1255350',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 08:49:21','',''),(2110825,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:49:21','',''),(2110973,'1','143','866',382,'Retail Sale Id 1255429',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 08:58:44','',''),(2110974,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 08:58:44','',''),(2111138,'1','143','866',382,'Retail Sale Id 1255508',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 09:08:39','',''),(2111139,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 09:08:39','',''),(2111162,'1','143','866',382,'Retail Sale Id 1255518',4001.60,0.00,0.00,0.00,329.40,'2021-12-01 09:09:43','',''),(2111163,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-01 09:09:43','',''),(2111178,'1','143','866',382,'Retail Sale Id 1255525',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 09:10:40','',''),(2111179,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 09:10:40','',''),(2111577,'1','143','866',382,'Retail Sale Id 1255741',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 09:36:02','',''),(2111578,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:36:02','',''),(2111623,'1','143','866',382,'Retail Sale Id 1255765',7216.00,0.00,0.00,0.00,594.00,'2021-12-01 09:38:19','',''),(2111624,'1','143','866',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-01 09:38:19','',''),(2111650,'1','143','866',382,'Retail Sale Id 1255782',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 09:39:38','',''),(2111651,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:39:38','',''),(2111740,'1','143','866',382,'Retail Sale Id 1255830',2624.00,0.00,0.00,0.00,216.00,'2021-12-01 09:46:34','',''),(2111741,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 09:46:34','',''),(2111790,'1','143','866',382,'Retail Sale Id 1255859',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 09:50:28','',''),(2111791,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 09:50:28','',''),(2111936,'1','143','866',382,'Retail Sale Id 1255921',2624.00,0.00,0.00,0.00,216.00,'2021-12-01 10:00:03','',''),(2111937,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 10:00:03','',''),(2111977,'1','143','866',382,'Retail Sale Id 1255939',214200.00,0.00,0.00,0.00,9520.00,'2021-12-01 10:01:47','',''),(2111978,'1','143','866',382,'Retail sales',0.00,0.00,0.00,340.00,0.00,'2021-12-01 10:01:47','',''),(2112013,'1','143','866',382,'Retail Sale Id 1255956',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 10:04:44','',''),(2112014,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 10:04:44','',''),(2112037,'1','143','866',382,'Retail Sale Id 1255969',5248.00,0.00,0.00,0.00,432.00,'2021-12-01 10:07:06','',''),(2112038,'1','143','866',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 10:07:06','',''),(2112057,'1','143','866',382,'Retail Sale Id 1255979',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 10:08:45','',''),(2112058,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 10:08:45','',''),(2112088,'1','143','866',382,'Retail Sale Id 1255994',1502.24,0.00,0.00,0.00,123.66,'2021-12-01 10:11:03','',''),(2112089,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-01 10:11:03','',''),(2112116,'1','143','866',382,'Retail Sale Id 1256013',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 10:12:32','',''),(2112117,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 10:12:32','',''),(2112200,'1','143','866',382,'Retail Sale Id 1256050',2000.80,0.00,0.00,0.00,164.70,'2021-12-01 10:16:46','',''),(2112201,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 10:16:46','',''),(2112319,'1','143','866',382,'Retail Sale Id 1256103',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 10:27:20','',''),(2112320,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:27:20','',''),(2112333,'1','143','866',382,'Retail Sale Id 1256112',2997.92,0.00,0.00,0.00,246.78,'2021-12-01 10:28:24','',''),(2112334,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-01 10:28:24','',''),(2112381,'1','143','866',382,'Retail Sale Id 1256134',997.12,0.00,0.00,0.00,82.08,'2021-12-01 10:31:43','',''),(2112382,'1','143','866',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 10:31:43','',''),(2112423,'1','143','866',382,'Retail Sale Id 1256162',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 10:35:02','',''),(2112424,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:35:02','',''),(2112447,'1','143','866',382,'Retail Sale Id 1256171',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 10:36:22','',''),(2112448,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 10:36:22','',''),(2112501,'1','143','866',382,'Retail Sale Id 1256197',2624.00,0.00,0.00,0.00,216.00,'2021-12-01 10:40:01','',''),(2112502,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 10:40:01','',''),(2112509,'1','143','866',382,'Retail Sale Id 1256202',2624.00,0.00,0.00,0.00,216.00,'2021-12-01 10:41:25','',''),(2112510,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 10:41:25','',''),(2112536,'1','143','866',382,'Retail Sale Id 1256214',2000.80,0.00,0.00,0.00,164.70,'2021-12-01 10:44:13','',''),(2112537,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 10:44:13','',''),(2112610,'1','143','866',382,'Retail Sale Id 1256253',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 10:49:43','',''),(2112611,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:49:43','',''),(2112664,'1','143','866',382,'Retail Sale Id 1256284',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 10:55:55','',''),(2112665,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 10:55:55','',''),(2112684,'1','143','866',382,'Retail Sale Id 1256295',2624.00,0.00,0.00,0.00,216.00,'2021-12-01 10:57:40','',''),(2112685,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 10:57:40','',''),(2112700,'1','143','866',382,'Retail Sale Id 1256301',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 10:58:56','',''),(2112701,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:58:56','',''),(2112724,'1','143','866',382,'Retail Sale Id 1256315',8003.20,0.00,0.00,0.00,658.80,'2021-12-01 11:00:21','',''),(2112725,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-01 11:00:21','',''),(2112790,'1','143','866',382,'Retail Sale Id 1256346',4592.00,0.00,0.00,0.00,378.00,'2021-12-01 11:06:01','',''),(2112791,'1','143','866',382,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 11:06:01','',''),(2112808,'1','143','866',382,'Retail Sale Id 1256360',2000.80,0.00,0.00,0.00,164.70,'2021-12-01 11:07:19','',''),(2112809,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 11:07:19','',''),(2112842,'1','143','866',382,'Retail Sale Id 1256374',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 11:08:54','',''),(2112843,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:08:54','',''),(2112876,'1','143','866',382,'Retail Sale Id 1256394',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 11:11:33','',''),(2112877,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 11:11:33','',''),(2113034,'1','143','866',382,'Retail Sale Id 1256455',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 11:19:30','',''),(2113035,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:19:30','',''),(2113094,'1','143','866',382,'Retail Sale Id 1256488',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 11:23:53','',''),(2113095,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:23:53','',''),(2113190,'1','143','866',382,'Retail Sale Id 1256531',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 11:28:48','',''),(2113191,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 11:28:48','',''),(2113206,'1','143','865',382,'Retail Sale Id 1256539',3503.04,0.00,0.00,0.00,288.36,'2021-12-01 11:30:32','',''),(2113207,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-01 11:30:32','',''),(2113234,'1','143','866',382,'Retail Sale Id 1256552',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 11:33:02','',''),(2113235,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 11:33:02','',''),(2113256,'1','143','866',382,'Retail Sale Id 1256567',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 11:34:52','',''),(2113257,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 11:34:52','',''),(2113367,'1','143','866',382,'Retail Sale Id 1256627',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 11:43:01','',''),(2113368,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:43:01','',''),(2113392,'1','143','866',382,'Retail Sale Id 1256639',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 11:44:38','',''),(2113393,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:44:38','',''),(2113469,'1','143','866',382,'Retail Sale Id 1256674',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 11:50:20','',''),(2113470,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:50:20','',''),(2113533,'1','143','866',382,'Retail Sale Id 1256709',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 11:55:39','',''),(2113534,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 11:55:39','',''),(2113563,'1','143','866',382,'Retail Sale Id 1256728',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 11:58:27','',''),(2113564,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 11:58:27','',''),(2113683,'1','143','866',382,'Retail Sale Id 1256795',656.00,0.00,0.00,0.00,54.00,'2021-12-01 12:11:56','',''),(2113684,'1','143','866',382,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 12:11:56','',''),(2113791,'1','143','866',382,'Retail Sale Id 1256850',10496.00,0.00,0.00,0.00,864.00,'2021-12-01 12:18:59','',''),(2113792,'1','143','866',382,'Retail sales',0.00,0.00,0.00,16.00,0.00,'2021-12-01 12:18:59','',''),(2113855,'1','143','866',382,'Retail Sale Id 1256883',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 12:22:11','',''),(2113856,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:22:11','',''),(2113879,'1','143','866',382,'Retail Sale Id 1256895',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 12:23:28','',''),(2113880,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:23:28','',''),(2113955,'1','143','866',382,'Retail Sale Id 1256933',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 12:29:26','',''),(2113956,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:29:26','',''),(2113985,'1','143','866',382,'Retail Sale Id 1256949',14760.00,0.00,0.00,0.00,1215.00,'2021-12-01 12:32:33','',''),(2113986,'1','143','866',382,'Retail sales',0.00,0.00,0.00,22.50,0.00,'2021-12-01 12:32:33','',''),(2114001,'1','143','866',382,'Retail Sale Id 1256956',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 12:33:50','',''),(2114002,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 12:33:50','',''),(2114011,'1','143','866',382,'Retail Sale Id 1256961',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 12:34:51','',''),(2114012,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:34:51','',''),(2114270,'1','143','866',382,'Retail Sale Id 1257092',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 13:02:50','',''),(2114271,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:02:50','',''),(2114348,'1','143','866',382,'Retail Sale Id 1257117',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 13:07:15','',''),(2114349,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 13:07:15','',''),(2114372,'1','143','866',382,'Retail Sale Id 1257125',4001.60,0.00,0.00,0.00,329.40,'2021-12-01 13:08:54','',''),(2114373,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-01 13:08:54','',''),(2114382,'1','143','866',382,'Retail Sale Id 1257143',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 13:10:26','',''),(2114383,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 13:10:26','',''),(2114398,'1','143','866',382,'Retail Sale Id 1257188',997.12,0.00,0.00,0.00,82.08,'2021-12-01 13:11:32','',''),(2114399,'1','143','866',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 13:11:32','',''),(2114432,'1','143','866',382,'Retail Sale Id 1257201',16400.00,0.00,0.00,0.00,1350.00,'2021-12-01 13:13:05','',''),(2114433,'1','143','866',382,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 13:13:05','',''),(2114454,'1','143','866',382,'Retail Sale Id 1257217',2997.92,0.00,0.00,0.00,246.78,'2021-12-01 13:14:21','',''),(2114455,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-01 13:14:21','',''),(2114472,'1','143','866',382,'Retail Sale Id 1257227',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 13:15:24','',''),(2114473,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:15:24','',''),(2114500,'1','143','866',382,'Retail Sale Id 1257240',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 13:17:18','',''),(2114501,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:17:18','',''),(2114526,'1','143','866',382,'Retail Sale Id 1257253',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 13:19:52','',''),(2114527,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 13:19:52','',''),(2114544,'1','143','866',382,'Retail Sale Id 1257265',4001.60,0.00,0.00,0.00,329.40,'2021-12-01 13:21:22','',''),(2114545,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-01 13:21:22','',''),(2114556,'1','143','866',382,'Retail Sale Id 1257270',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 13:22:16','',''),(2114557,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 13:22:16','',''),(2114615,'1','143','866',382,'Retail Sale Id 1257300',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 13:27:01','',''),(2114616,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:27:01','',''),(2114639,'1','143','866',382,'Retail Sale Id 1257310',1502.24,0.00,0.00,0.00,123.66,'2021-12-01 13:29:17','',''),(2114640,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-01 13:29:17','',''),(2114657,'1','143','866',382,'Retail Sale Id 1257319',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 13:30:27','',''),(2114658,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:30:27','',''),(2114715,'1','143','866',382,'Retail Sale Id 1257348',997.12,0.00,0.00,0.00,82.08,'2021-12-01 13:35:26','',''),(2114716,'1','143','866',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 13:35:26','',''),(2114746,'1','143','866',382,'Retail Sale Id 1257359',3503.04,0.00,0.00,0.00,288.36,'2021-12-01 13:36:59','',''),(2114747,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-01 13:36:59','',''),(2114808,'1','143','866',382,'Retail Sale Id 1257373',2000.80,0.00,0.00,0.00,164.70,'2021-12-01 13:39:53','',''),(2114809,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 13:39:53','',''),(2114866,'1','143','866',382,'Retail Sale Id 1257386',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 13:42:21','',''),(2114867,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 13:42:21','',''),(2114913,'1','143','866',382,'Retail Sale Id 1257402',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 13:44:58','',''),(2114914,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:44:58','',''),(2114944,'1','143','866',382,'Retail Sale Id 1257414',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 13:46:20','',''),(2114945,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:46:20','',''),(2114956,'1','143','866',382,'Retail Sale Id 1257419',2000.80,0.00,0.00,0.00,164.70,'2021-12-01 13:47:55','',''),(2114957,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 13:47:55','',''),(2115004,'1','143','866',382,'Retail Sale Id 1257437',4998.72,0.00,0.00,0.00,411.48,'2021-12-01 13:50:26','',''),(2115005,'1','143','866',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-01 13:50:26','',''),(2115029,'1','143','866',382,'Retail Sale Id 1257447',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 13:52:07','',''),(2115030,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:52:07','',''),(2115068,'1','143','866',382,'Retail Sale Id 1257463',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 13:53:27','',''),(2115069,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 13:53:27','',''),(2115094,'1','143','866',382,'Retail Sale Id 1257477',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 13:55:02','',''),(2115095,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:55:02','',''),(2115118,'1','143','866',382,'Retail Sale Id 1257492',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 13:56:33','',''),(2115119,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:56:33','',''),(2115164,'1','143','866',382,'Retail Sale Id 1257512',2624.00,0.00,0.00,0.00,216.00,'2021-12-01 13:58:37','',''),(2115165,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 13:58:37','',''),(2115605,'1','143','866',382,'Retail Sale Id 1257746',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 14:27:24','',''),(2115606,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 14:27:24','',''),(2115642,'1','143','866',382,'Retail Sale Id 1257764',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 14:30:09','',''),(2115643,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 14:30:09','',''),(2115756,'1','143','866',382,'Retail Sale Id 1257816',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 14:38:11','',''),(2115757,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 14:38:11','',''),(2115796,'1','143','866',382,'Retail Sale Id 1257839',7872.00,0.00,0.00,0.00,648.00,'2021-12-01 14:41:14','',''),(2115797,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-01 14:41:14','',''),(2115831,'1','143','866',382,'Retail Sale Id 1257858',6560.00,0.00,0.00,0.00,540.00,'2021-12-01 14:45:20','',''),(2115832,'1','143','866',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 14:45:20','',''),(2115879,'1','143','866',382,'Retail Sale Id 1257879',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 14:48:35','',''),(2115880,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 14:48:35','',''),(2115951,'1','143','866',382,'Retail Sale Id 1257904',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 14:51:48','',''),(2115952,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:51:48','',''),(2116088,'1','143','866',382,'Retail Sale Id 1257951',2624.00,0.00,0.00,0.00,216.00,'2021-12-01 14:58:31','',''),(2116089,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 14:58:31','',''),(2116112,'1','143','866',382,'Retail Sale Id 1257964',1312.00,0.00,0.00,0.00,108.00,'2021-12-01 15:00:28','',''),(2116113,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 15:00:28','',''),(2116126,'1','143','866',382,'Retail Sale Id 1257971',6560.00,0.00,0.00,0.00,540.00,'2021-12-01 15:01:33','',''),(2116127,'1','143','866',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 15:01:33','',''),(2116152,'1','143','866',382,'Retail Sale Id 1257984',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 15:03:19','',''),(2116153,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:03:19','',''),(2116190,'1','143','866',382,'Retail Sale Id 1258004',6560.00,0.00,0.00,0.00,540.00,'2021-12-01 15:06:12','',''),(2116191,'1','143','866',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 15:06:12','',''),(2116233,'1','143','866',382,'Retail Sale Id 1258028',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 15:10:51','',''),(2116234,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:10:51','',''),(2116342,'1','143','866',382,'Retail Sale Id 1258080',997.12,0.00,0.00,0.00,82.08,'2021-12-01 15:17:21','',''),(2116343,'1','143','866',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 15:17:21','',''),(2116398,'1','143','866',382,'Retail Sale Id 1258106',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 15:20:34','',''),(2116399,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:20:34','',''),(2116477,'1','143','866',382,'Retail Sale Id 1258138',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 15:24:57','',''),(2116478,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:24:57','',''),(2116513,'1','143','866',382,'Retail Sale Id 1258155',2000.80,0.00,0.00,0.00,164.70,'2021-12-01 15:27:37','',''),(2116514,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 15:27:37','',''),(2116549,'1','143','866',382,'Retail Sale Id 1258170',2000.80,0.00,0.00,0.00,164.70,'2021-12-01 15:29:33','',''),(2116550,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 15:29:33','',''),(2116616,'1','143','866',382,'Retail Sale Id 1258209',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 15:34:34','',''),(2116617,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:34:34','',''),(2116686,'1','143','866',382,'Retail Sale Id 1258245',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 15:39:20','',''),(2116687,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:39:20','',''),(2116750,'1','143','866',382,'Retail Sale Id 1258274',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 15:43:26','',''),(2116751,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:43:26','',''),(2116792,'1','143','866',382,'Retail Sale Id 1258288',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 15:45:03','',''),(2116793,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:45:03','',''),(2116832,'1','143','866',382,'Retail Sale Id 1258307',4998.72,0.00,0.00,0.00,411.48,'2021-12-01 15:46:47','',''),(2116833,'1','143','866',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-01 15:46:47','',''),(2116890,'1','143','866',382,'Retail Sale Id 1258339',1797.44,0.00,0.00,0.00,147.96,'2021-12-01 15:49:16','',''),(2116891,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.74,0.00,'2021-12-01 15:49:16','',''),(2116917,'1','143','866',382,'Retail Sale Id 1258353',997.12,0.00,0.00,0.00,82.08,'2021-12-01 15:50:29','',''),(2116918,'1','143','866',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 15:50:29','',''),(2116998,'1','143','866',382,'Retail Sale Id 1258390',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 15:53:18','',''),(2116999,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:53:18','',''),(2117060,'1','143','866',382,'Retail Sale Id 1258419',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 15:56:01','',''),(2117061,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 15:56:01','',''),(2117088,'1','143','866',382,'Retail Sale Id 1258432',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 15:57:36','',''),(2117089,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:57:36','',''),(2117121,'1','143','866',382,'Retail Sale Id 1258448',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 15:59:06','',''),(2117122,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:59:06','',''),(2117155,'1','143','866',382,'Retail Sale Id 1258468',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:00:22','',''),(2117156,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:00:22','',''),(2117199,'1','143','866',382,'Retail Sale Id 1258488',5904.00,0.00,0.00,0.00,486.00,'2021-12-01 16:02:24','',''),(2117200,'1','143','866',382,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-01 16:02:24','',''),(2117231,'1','143','866',382,'Retail Sale Id 1258501',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 16:03:56','',''),(2117232,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:03:56','',''),(2117265,'1','143','866',382,'Retail Sale Id 1258520',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:05:31','',''),(2117266,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:05:31','',''),(2117378,'1','143','866',382,'Retail Sale Id 1258563',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:09:28','',''),(2117379,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:09:28','',''),(2117405,'1','143','866',382,'Retail Sale Id 1258575',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:10:28','',''),(2117406,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:10:28','',''),(2117569,'1','143','866',382,'Retail Sale Id 1258644',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 16:16:57','',''),(2117570,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:16:57','',''),(2117601,'1','143','866',382,'Retail Sale Id 1258666',1902.40,0.00,0.00,0.00,156.60,'2021-12-01 16:18:36','',''),(2117602,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-01 16:18:36','',''),(2117674,'1','143','865',382,'Retail Sale Id 1258700',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 16:21:26','',''),(2117675,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:21:26','',''),(2117710,'1','143','866',382,'Retail Sale Id 1258719',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 16:22:54','',''),(2117711,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:22:54','',''),(2117740,'1','143','866',382,'Retail Sale Id 1258738',7872.00,0.00,0.00,0.00,648.00,'2021-12-01 16:24:14','',''),(2117741,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-01 16:24:14','',''),(2117762,'1','143','866',382,'Retail Sale Id 1258750',1312.00,0.00,0.00,0.00,108.00,'2021-12-01 16:25:20','',''),(2117763,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 16:25:20','',''),(2117778,'1','143','866',382,'Retail Sale Id 1258765',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 16:26:15','',''),(2117779,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:26:15','',''),(2117818,'1','143','866',382,'Retail Sale Id 1258793',10168.00,0.00,0.00,0.00,837.00,'2021-12-01 16:28:05','',''),(2117819,'1','143','866',382,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-01 16:28:05','',''),(2117846,'1','143','866',382,'Retail Sale Id 1258805',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:29:06','',''),(2117847,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:29:06','',''),(2117868,'1','143','866',382,'Retail Sale Id 1258816',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 16:30:14','',''),(2117869,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:30:14','',''),(2117908,'1','143','866',382,'Retail Sale Id 1258833',10758.40,0.00,0.00,0.00,885.60,'2021-12-01 16:32:02','',''),(2117909,'1','143','866',382,'Retail sales',0.00,0.00,0.00,16.40,0.00,'2021-12-01 16:32:02','',''),(2117970,'1','143','866',382,'Retail Sale Id 1258873',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 16:35:36','',''),(2117971,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:35:36','',''),(2118016,'1','143','866',382,'Retail Sale Id 1258894',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:37:45','',''),(2118017,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:37:45','',''),(2118036,'1','143','866',382,'Retail Sale Id 1258907',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 16:38:40','',''),(2118037,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:38:40','',''),(2118062,'1','143','866',382,'Retail Sale Id 1258920',4592.00,0.00,0.00,0.00,378.00,'2021-12-01 16:39:59','',''),(2118063,'1','143','866',382,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 16:39:59','',''),(2118098,'1','143','866',382,'Retail Sale Id 1258937',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 16:41:17','',''),(2118099,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:41:17','',''),(2118134,'1','143','866',382,'Retail Sale Id 1258954',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 16:43:29','',''),(2118135,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:43:29','',''),(2118154,'1','143','866',382,'Retail Sale Id 1258968',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 16:44:30','',''),(2118155,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:44:30','',''),(2118218,'1','143','866',382,'Retail Sale Id 1259004',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 16:48:05','',''),(2118219,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:48:05','',''),(2118258,'1','143','866',382,'Retail Sale Id 1259026',1312.00,0.00,0.00,0.00,108.00,'2021-12-01 16:50:14','',''),(2118259,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 16:50:14','',''),(2118302,'1','143','866',382,'Retail Sale Id 1259044',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 16:52:03','',''),(2118303,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:52:03','',''),(2118318,'1','143','866',382,'Retail Sale Id 1259056',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:52:56','',''),(2118319,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:52:56','',''),(2118371,'1','143','866',382,'Retail Sale Id 1259075',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 16:54:17','',''),(2118372,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:54:17','',''),(2118391,'1','143','866',382,'Retail Sale Id 1259089',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 16:55:35','',''),(2118392,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:55:35','',''),(2118496,'1','143','866',382,'Retail Sale Id 1259126',88494.40,0.00,0.00,0.00,7284.60,'2021-12-01 16:59:48','',''),(2118497,'1','143','866',382,'Retail sales',0.00,0.00,0.00,134.90,0.00,'2021-12-01 16:59:48','',''),(2118830,'1','143','866',382,'Retail Sale Id 1259309',37800.00,0.00,0.00,0.00,1680.00,'2021-12-01 17:17:11','',''),(2118831,'1','143','866',382,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-01 17:17:11','',''),(2121316,'1','143','866',382,'Retail Sale Id 1260252',4001.60,0.00,0.00,0.00,329.40,'2021-12-02 07:03:25','',''),(2121317,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-02 07:03:25','',''),(2121332,'1','143','866',382,'Retail Sale Id 1260261',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 07:04:17','',''),(2121333,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 07:04:17','',''),(2121356,'1','143','866',382,'Retail Sale Id 1260274',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 07:05:21','',''),(2121357,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 07:05:21','',''),(2121402,'1','143','866',382,'Retail Sale Id 1260299',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 07:07:58','',''),(2121403,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 07:07:58','',''),(2121449,'1','143','866',382,'Retail Sale Id 1260316',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 07:10:14','',''),(2121450,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 07:10:14','',''),(2121510,'1','143','866',382,'Retail Sale Id 1260333',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 07:12:08','',''),(2121511,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:12:08','',''),(2121528,'1','143','866',382,'Retail Sale Id 1260341',4998.72,0.00,0.00,0.00,411.48,'2021-12-02 07:13:17','',''),(2121529,'1','143','866',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-02 07:13:17','',''),(2121609,'1','143','866',382,'Retail Sale Id 1260385',4001.60,0.00,0.00,0.00,329.40,'2021-12-02 07:17:30','',''),(2121610,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-02 07:17:30','',''),(2121649,'1','143','866',382,'Retail Sale Id 1260405',4001.60,0.00,0.00,0.00,329.40,'2021-12-02 07:19:21','',''),(2121650,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-02 07:19:21','',''),(2121663,'1','143','866',382,'Retail Sale Id 1260411',2997.92,0.00,0.00,0.00,246.78,'2021-12-02 07:20:18','',''),(2121664,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-02 07:20:18','',''),(2121737,'1','143','866',382,'Retail Sale Id 1260442',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 07:23:49','',''),(2121738,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:23:49','',''),(2121923,'1','143','866',382,'Retail Sale Id 1260553',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 07:34:03','',''),(2121924,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 07:34:03','',''),(2121991,'1','143','866',382,'Retail Sale Id 1260589',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 07:37:44','',''),(2121992,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:37:44','',''),(2122021,'1','143','866',382,'Retail Sale Id 1260607',3699.84,0.00,0.00,0.00,304.56,'2021-12-02 07:38:49','',''),(2122022,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.64,0.00,'2021-12-02 07:38:49','',''),(2122205,'1','143','866',382,'Retail Sale Id 1260702',7216.00,0.00,0.00,0.00,594.00,'2021-12-02 07:47:32','',''),(2122206,'1','143','866',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-02 07:47:32','',''),(2122243,'1','143','866',382,'Retail Sale Id 1260724',4001.60,0.00,0.00,0.00,329.40,'2021-12-02 07:49:11','',''),(2122244,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-02 07:49:11','',''),(2122434,'1','143','866',382,'Retail Sale Id 1260802',2597.76,0.00,0.00,0.00,213.84,'2021-12-02 07:55:57','',''),(2122435,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-02 07:55:57','',''),(2122478,'1','143','866',382,'Retail Sale Id 1260826',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 07:57:53','',''),(2122479,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:57:53','',''),(2122709,'1','143','866',382,'Retail Sale Id 1260922',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 08:07:07','',''),(2122710,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:07:07','',''),(2122785,'1','143','866',382,'Retail Sale Id 1260966',997.12,0.00,0.00,0.00,82.08,'2021-12-02 08:11:26','',''),(2122786,'1','143','866',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 08:11:26','',''),(2122829,'1','143','866',382,'Retail Sale Id 1260990',997.12,0.00,0.00,0.00,82.08,'2021-12-02 08:13:45','',''),(2122830,'1','143','866',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 08:13:45','',''),(2122870,'1','143','866',382,'Retail Sale Id 1261013',2624.00,0.00,0.00,0.00,216.00,'2021-12-02 08:16:24','',''),(2122871,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 08:16:24','',''),(2122926,'1','143','866',382,'Retail Sale Id 1261042',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 08:19:17','',''),(2122927,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:19:17','',''),(2122998,'1','143','866',382,'Retail Sale Id 1261082',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 08:22:44','',''),(2122999,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:22:44','',''),(2123221,'1','143','866',382,'Retail Sale Id 1261191',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 08:34:20','',''),(2123222,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 08:34:20','',''),(2123425,'1','143','866',382,'Retail Sale Id 1261271',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 08:43:29','',''),(2123426,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:43:29','',''),(2123539,'1','143','866',382,'Retail Sale Id 1261330',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 08:51:12','',''),(2123540,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 08:51:12','',''),(2123581,'1','143','866',382,'Retail Sale Id 1261348',2624.00,0.00,0.00,0.00,216.00,'2021-12-02 08:52:46','',''),(2123582,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 08:52:46','',''),(2123705,'1','143','866',382,'Retail Sale Id 1261410',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 08:59:18','',''),(2123706,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 08:59:18','',''),(2123927,'1','143','866',382,'Retail Sale Id 1261538',8003.20,0.00,0.00,0.00,658.80,'2021-12-02 09:10:27','',''),(2123928,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-02 09:10:27','',''),(2124144,'1','143','866',382,'Retail Sale Id 1261615',1312.00,0.00,0.00,0.00,108.00,'2021-12-02 09:19:14','',''),(2124145,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 09:19:14','',''),(2124168,'1','143','866',382,'Retail Sale Id 1261630',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 09:20:46','',''),(2124169,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:20:46','',''),(2124182,'1','143','866',382,'Retail Sale Id 1261639',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 09:21:41','',''),(2124183,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 09:21:41','',''),(2124216,'1','143','866',382,'Retail Sale Id 1261660',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 09:23:49','',''),(2124217,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:23:49','',''),(2124393,'1','143','866',382,'Retail Sale Id 1261748',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 09:34:36','',''),(2124394,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:34:36','',''),(2124415,'1','143','866',382,'Retail Sale Id 1261760',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:35:53','',''),(2124416,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:35:53','',''),(2124437,'1','143','866',382,'Retail Sale Id 1261769',1312.00,0.00,0.00,0.00,108.00,'2021-12-02 09:38:14','',''),(2124438,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 09:38:14','',''),(2124453,'1','143','866',382,'Retail Sale Id 1261778',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 09:39:40','',''),(2124454,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:39:40','',''),(2124475,'1','143','866',382,'Retail Sale Id 1261790',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:40:57','',''),(2124476,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:40:57','',''),(2124487,'1','143','866',382,'Retail Sale Id 1261797',1312.00,0.00,0.00,0.00,108.00,'2021-12-02 09:41:49','',''),(2124488,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 09:41:49','',''),(2124509,'1','143','866',382,'Retail Sale Id 1261808',997.12,0.00,0.00,0.00,82.08,'2021-12-02 09:42:55','',''),(2124510,'1','143','866',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 09:42:55','',''),(2124543,'1','143','866',382,'Retail Sale Id 1261823',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 09:44:14','',''),(2124544,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:44:14','',''),(2124576,'1','143','866',382,'Retail Sale Id 1261837',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 09:45:43','',''),(2124577,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:45:43','',''),(2124608,'1','143','866',382,'Retail Sale Id 1261852',6560.00,0.00,0.00,0.00,540.00,'2021-12-02 09:48:05','',''),(2124609,'1','143','866',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 09:48:05','',''),(2124633,'1','143','866',382,'Retail Sale Id 1261866',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 09:49:24','',''),(2124634,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:49:24','',''),(2124803,'1','143','866',382,'Retail Sale Id 1261962',220500.00,0.00,0.00,0.00,9800.00,'2021-12-02 09:57:26','',''),(2124804,'1','143','866',382,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-02 09:57:26','',''),(2124839,'1','143','866',382,'Retail Sale Id 1261982',4998.72,0.00,0.00,0.00,411.48,'2021-12-02 09:58:49','',''),(2124840,'1','143','866',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-02 09:58:49','',''),(2124863,'1','143','866',382,'Retail Sale Id 1261994',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 10:00:06','',''),(2124864,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:00:06','',''),(2124900,'1','143','866',382,'Retail Sale Id 1262006',997.12,0.00,0.00,0.00,82.08,'2021-12-02 10:02:25','',''),(2124901,'1','143','866',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 10:02:25','',''),(2124963,'1','143','866',382,'Retail Sale Id 1262040',10168.00,0.00,0.00,0.00,837.00,'2021-12-02 10:05:37','',''),(2124964,'1','143','866',382,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-02 10:05:37','',''),(2125005,'1','143','866',382,'Retail Sale Id 1262068',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 10:09:05','',''),(2125006,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:09:05','',''),(2125668,'1','143','866',382,'Retail Sale Id 1262393',6560.00,0.00,0.00,0.00,540.00,'2021-12-02 10:46:56','',''),(2125669,'1','143','866',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 10:46:56','',''),(2125718,'1','143','866',382,'Retail Sale Id 1262386',6560.00,0.00,0.00,0.00,540.00,'2021-12-02 10:50:41','',''),(2125719,'1','143','866',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 10:50:41','',''),(2125734,'1','143','866',382,'Retail Sale Id 1262419',1640.00,0.00,0.00,0.00,135.00,'2021-12-02 10:51:37','',''),(2125735,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-02 10:51:37','',''),(2126330,'1','143','866',382,'Retail Sale Id 1262741',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 11:28:28','',''),(2126331,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 11:28:28','',''),(2126511,'1','143','866',382,'Retail Sale Id 1262811',13120.00,0.00,0.00,0.00,1080.00,'2021-12-02 11:36:28','',''),(2126512,'1','143','866',382,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-02 11:36:28','',''),(2126581,'1','143','866',382,'Retail Sale Id 1262838',1312.00,0.00,0.00,0.00,108.00,'2021-12-02 11:39:36','',''),(2126582,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 11:39:36','',''),(2126607,'1','143','866',382,'Retail Sale Id 1262850',4001.60,0.00,0.00,0.00,329.40,'2021-12-02 11:41:02','',''),(2126608,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-02 11:41:02','',''),(2126629,'1','143','866',382,'Retail Sale Id 1262862',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 11:42:42','',''),(2126630,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 11:42:42','',''),(2126685,'1','143','866',382,'Retail Sale Id 1262889',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 11:48:17','',''),(2126686,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 11:48:17','',''),(2126717,'1','143','866',382,'Retail Sale Id 1262904',7872.00,0.00,0.00,0.00,648.00,'2021-12-02 11:50:17','',''),(2126718,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 11:50:17','',''),(2126745,'1','143','866',382,'Retail Sale Id 1262922',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 11:52:27','',''),(2126746,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 11:52:27','',''),(2126769,'1','143','866',382,'Retail Sale Id 1262937',2499.36,0.00,0.00,0.00,205.74,'2021-12-02 11:54:36','',''),(2126770,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-02 11:54:36','',''),(2126787,'1','143','866',382,'Retail Sale Id 1262946',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 11:55:29','',''),(2126788,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 11:55:29','',''),(2126811,'1','143','866',382,'Retail Sale Id 1262958',4001.60,0.00,0.00,0.00,329.40,'2021-12-02 11:57:19','',''),(2126812,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-02 11:57:19','',''),(2126845,'1','143','866',382,'Retail Sale Id 1262974',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 12:00:01','',''),(2126846,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 12:00:01','',''),(2126867,'1','143','866',382,'Retail Sale Id 1262986',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 12:02:09','',''),(2126868,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:02:09','',''),(2126928,'1','143','866',382,'Retail Sale Id 1263018',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 12:07:50','',''),(2126929,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 12:07:50','',''),(2126962,'1','143','866',382,'Retail Sale Id 1263034',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 12:10:37','',''),(2126963,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:10:37','',''),(2126976,'1','143','866',382,'Retail Sale Id 1263041',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 12:12:02','',''),(2126977,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 12:12:02','',''),(2126995,'1','143','866',382,'Retail Sale Id 1263049',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 12:14:10','',''),(2126996,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:14:10','',''),(2127021,'1','143','866',382,'Retail Sale Id 1263064',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 12:16:45','',''),(2127022,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:16:45','',''),(2127050,'1','143','866',382,'Retail Sale Id 1263077',3503.04,0.00,0.00,0.00,288.36,'2021-12-02 12:20:02','',''),(2127051,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-02 12:20:02','',''),(2127214,'1','143','865',382,'Retail Sale Id 1263180',3798.24,0.00,0.00,0.00,312.66,'2021-12-02 12:31:04','',''),(2127215,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.79,0.00,'2021-12-02 12:31:04','',''),(2127228,'1','143','865',382,'Retail Sale Id 1263188',1502.24,0.00,0.00,0.00,123.66,'2021-12-02 12:32:04','',''),(2127229,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 12:32:04','',''),(2127274,'1','143','865',382,'Retail Sale Id 1263211',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 12:35:44','',''),(2127275,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:35:44','',''),(2127376,'1','143','865',382,'Retail Sale Id 1263266',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 12:44:27','',''),(2127377,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:44:27','',''),(2127410,'1','143','865',382,'Retail Sale Id 1263277',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 12:46:54','',''),(2127411,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:46:54','',''),(2127443,'1','143','865',382,'Retail Sale Id 1263286',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 12:48:10','',''),(2127444,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 12:48:10','',''),(2127467,'1','143','865',382,'Retail Sale Id 1263298',4001.60,0.00,0.00,0.00,329.40,'2021-12-02 12:50:01','',''),(2127468,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-02 12:50:01','',''),(2127510,'1','143','865',382,'Retail Sale Id 1263319',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 12:53:32','',''),(2127511,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 12:53:32','',''),(2127530,'1','143','865',382,'Retail Sale Id 1263329',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 12:55:13','',''),(2127531,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 12:55:13','',''),(2127602,'1','143','865',382,'Retail Sale Id 1263361',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 13:00:46','',''),(2127603,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 13:00:46','',''),(2127632,'1','143','865',382,'Retail Sale Id 1263379',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 13:01:57','',''),(2127633,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 13:01:57','',''),(2127670,'1','143','865',382,'Retail Sale Id 1263401',997.12,0.00,0.00,0.00,82.08,'2021-12-02 13:05:01','',''),(2127671,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 13:05:01','',''),(2127786,'1','143','865',382,'Retail Sale Id 1263454',4001.60,0.00,0.00,0.00,329.40,'2021-12-02 13:13:57','',''),(2127787,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-02 13:13:57','',''),(2127866,'1','143','865',382,'Retail Sale Id 1263483',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 13:17:22','',''),(2127867,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:17:22','',''),(2127889,'1','143','865',382,'Retail Sale Id 1263491',5248.00,0.00,0.00,0.00,432.00,'2021-12-02 13:18:53','',''),(2127890,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-02 13:18:53','',''),(2127909,'1','143','865',382,'Retail Sale Id 1263503',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 13:20:43','',''),(2127910,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:20:43','',''),(2127927,'1','143','865',382,'Retail Sale Id 1263510',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 13:22:07','',''),(2127928,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 13:22:07','',''),(2127949,'1','143','865',382,'Retail Sale Id 1263521',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 13:24:04','',''),(2127950,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 13:24:04','',''),(2128115,'1','143','866',382,'Retail Sale Id 1263587',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 13:35:46','',''),(2128116,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 13:35:46','',''),(2128144,'1','143','865',382,'Retail Sale Id 1263597',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 13:38:04','',''),(2128145,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:38:04','',''),(2128180,'1','143','865',382,'Retail Sale Id 1263606',1298.88,0.00,0.00,0.00,106.92,'2021-12-02 13:39:21','',''),(2128181,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.98,0.00,'2021-12-02 13:39:21','',''),(2128216,'1','143','865',382,'Retail Sale Id 1263623',2624.00,0.00,0.00,0.00,216.00,'2021-12-02 13:41:54','',''),(2128217,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 13:41:54','',''),(2128284,'1','143','865',382,'Retail Sale Id 1263657',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 13:46:08','',''),(2128285,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 13:46:08','',''),(2128344,'1','143','865',382,'Retail Sale Id 1263687',2997.92,0.00,0.00,0.00,246.78,'2021-12-02 13:48:56','',''),(2128345,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-02 13:48:56','',''),(2128405,'1','143','866',382,'Retail Sale Id 1263720',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 13:53:18','',''),(2128406,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 13:53:18','',''),(2128442,'1','143','866',382,'Retail Sale Id 1263732',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 13:54:50','',''),(2128443,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 13:54:50','',''),(2128479,'1','143','866',382,'Retail Sale Id 1263743',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 13:55:56','',''),(2128480,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 13:55:56','',''),(2128509,'1','143','866',382,'Retail Sale Id 1263756',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 13:57:20','',''),(2128510,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:57:20','',''),(2128562,'1','143','866',382,'Retail Sale Id 1263776',5904.00,0.00,0.00,0.00,486.00,'2021-12-02 14:01:07','',''),(2128563,'1','143','866',382,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 14:01:07','',''),(2128572,'1','143','866',382,'Retail Sale Id 1263786',2499.36,0.00,0.00,0.00,205.74,'2021-12-02 14:02:25','',''),(2128573,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-02 14:02:25','',''),(2128678,'1','143','866',382,'Retail Sale Id 1263839',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 14:08:44','',''),(2128679,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:08:44','',''),(2128734,'1','143','865',382,'Retail Sale Id 1263861',997.12,0.00,0.00,0.00,82.08,'2021-12-02 14:11:43','',''),(2128735,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 14:11:43','',''),(2128757,'1','143','866',382,'Return of Retail Sale Id 1263839',0.00,1968.00,3.00,0.00,-162.00,'2021-12-02 14:12:46','',''),(2128768,'1','143','865',382,'Retail Sale Id 1263872',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 14:13:49','',''),(2128769,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:13:49','',''),(2128794,'1','143','866',382,'Retail Sale Id 1263883',4500.16,0.00,0.00,0.00,370.44,'2021-12-02 14:15:44','',''),(2128795,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.86,0.00,'2021-12-02 14:15:44','',''),(2128814,'1','143','865',382,'Retail Sale Id 1263895',4500.16,0.00,0.00,0.00,370.44,'2021-12-02 14:16:51','',''),(2128815,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.86,0.00,'2021-12-02 14:16:51','',''),(2128836,'1','143','866',382,'Return of Retail Sale Id 1263883',0.00,4500.16,6.86,0.00,-370.44,'2021-12-02 14:17:41','',''),(2128857,'1','143','866',382,'Return of Retail Sale Id 1263587',0.00,2000.80,3.05,0.00,-164.70,'2021-12-02 14:18:47','',''),(2128884,'1','143','866',382,'Return of Retail Sale Id 1263720',0.00,2000.80,3.05,0.00,-164.70,'2021-12-02 14:20:04','',''),(2128903,'1','143','866',382,'Return of Retail Sale Id 1263732',0.00,2000.80,3.05,0.00,-164.70,'2021-12-02 14:20:48','',''),(2128926,'1','143','866',382,'Return of Retail Sale Id 1263743',0.00,3936.00,6.00,0.00,-324.00,'2021-12-02 14:22:12','',''),(2128947,'1','143','866',382,'Return of Retail Sale Id 1263756',0.00,8200.00,12.50,0.00,-675.00,'2021-12-02 14:22:43','',''),(2128954,'1','143','866',382,'Return of Retail Sale Id 1263786',0.00,2499.36,3.81,0.00,-205.74,'2021-12-02 14:23:16','',''),(2128959,'1','143','866',382,'Return of Retail Sale Id 1263776',0.00,5904.00,9.00,0.00,-486.00,'2021-12-02 14:23:41','',''),(2128999,'1','143','865',382,'Retail Sale Id 1263971',4998.72,0.00,0.00,0.00,411.48,'2021-12-02 14:24:47','',''),(2129000,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-02 14:24:47','',''),(2129021,'1','143','866',382,'Retail Sale Id 1263985',2624.00,0.00,0.00,0.00,216.00,'2021-12-02 14:26:01','',''),(2129022,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 14:26:01','',''),(2129073,'1','143','865',382,'Retail Sale Id 1263993',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 14:26:59','',''),(2129074,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:26:59','',''),(2129122,'1','143','866',382,'Retail Sale Id 1264015',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 14:29:02','',''),(2129123,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:29:02','',''),(2129144,'1','143','865',382,'Retail Sale Id 1264026',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 14:30:17','',''),(2129145,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:30:17','',''),(2129214,'1','143','866',382,'Retail Sale Id 1264048',2499.36,0.00,0.00,0.00,205.74,'2021-12-02 14:33:23','',''),(2129215,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-02 14:33:23','',''),(2129240,'1','143','865',382,'Retail Sale Id 1264061',1502.24,0.00,0.00,0.00,123.66,'2021-12-02 14:34:55','',''),(2129241,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 14:34:55','',''),(2129258,'1','143','865',382,'Retail Sale Id 1264069',3503.04,0.00,0.00,0.00,288.36,'2021-12-02 14:36:01','',''),(2129259,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-02 14:36:01','',''),(2129280,'1','143','865',382,'Retail Sale Id 1264078',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 14:37:14','',''),(2129281,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:37:14','',''),(2129323,'1','143','865',382,'Retail Sale Id 1264095',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 14:38:53','',''),(2129324,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:38:53','',''),(2129376,'1','143','865',382,'Retail Sale Id 1264111',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 14:40:12','',''),(2129377,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:40:12','',''),(2129441,'1','143','865',382,'Retail Sale Id 1264140',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 14:43:04','',''),(2129442,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 14:43:04','',''),(2129479,'1','143','865',382,'Retail Sale Id 1264158',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 14:46:19','',''),(2129480,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 14:46:19','',''),(2129501,'1','143','865',382,'Retail Sale Id 1264172',1312.00,0.00,0.00,0.00,108.00,'2021-12-02 14:47:43','',''),(2129502,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 14:47:43','',''),(2129535,'1','143','865',382,'Retail Sale Id 1264191',1312.00,0.00,0.00,0.00,108.00,'2021-12-02 14:49:03','',''),(2129536,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 14:49:03','',''),(2129559,'1','143','865',382,'Retail Sale Id 1264203',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 14:50:30','',''),(2129560,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 14:50:30','',''),(2129581,'1','143','865',382,'Retail Sale Id 1264215',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 14:51:58','',''),(2129582,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:51:58','',''),(2129612,'1','143','865',382,'Retail Sale Id 1264230',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 14:53:51','',''),(2129613,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:53:51','',''),(2129636,'1','143','865',382,'Retail Sale Id 1264242',800.32,0.00,0.00,0.00,65.88,'2021-12-02 14:55:32','',''),(2129637,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.22,0.00,'2021-12-02 14:55:32','',''),(2129661,'1','143','865',382,'Retail Sale Id 1264257',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 14:56:34','',''),(2129662,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:56:34','',''),(2129705,'1','143','865',382,'Retail Sale Id 1264280',30176.00,0.00,0.00,0.00,2484.00,'2021-12-02 14:58:28','',''),(2129706,'1','143','865',382,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-02 14:58:28','',''),(2129743,'1','143','865',382,'Retail Sale Id 1264298',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 15:02:13','',''),(2129744,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 15:02:13','',''),(2129759,'1','143','865',382,'Retail Sale Id 1264306',1502.24,0.00,0.00,0.00,123.66,'2021-12-02 15:03:34','',''),(2129760,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 15:03:34','',''),(2129777,'1','143','865',382,'Retail Sale Id 1264315',1312.00,0.00,0.00,0.00,108.00,'2021-12-02 15:05:16','',''),(2129778,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 15:05:16','',''),(2129795,'1','143','865',382,'Retail Sale Id 1264326',1502.24,0.00,0.00,0.00,123.66,'2021-12-02 15:06:11','',''),(2129796,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 15:06:11','',''),(2129870,'1','143','865',382,'Retail Sale Id 1264354',5904.00,0.00,0.00,0.00,486.00,'2021-12-02 15:11:12','',''),(2129871,'1','143','865',382,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 15:11:12','',''),(2129972,'1','143','865',382,'Retail Sale Id 1264414',25200.00,0.00,0.00,0.00,1120.00,'2021-12-02 15:16:21','',''),(2129973,'1','143','865',382,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-02 15:16:21','',''),(2130044,'1','143','865',382,'Retail Sale Id 1264451',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 15:20:38','',''),(2130045,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:20:38','',''),(2130100,'1','143','865',382,'Retail Sale Id 1264482',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 15:23:54','',''),(2130101,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:23:54','',''),(2130410,'1','143','865',382,'Retail Sale Id 1264625',17384.00,0.00,0.00,0.00,1431.00,'2021-12-02 15:36:53','',''),(2130411,'1','143','865',382,'Retail sales',0.00,0.00,0.00,26.50,0.00,'2021-12-02 15:36:53','',''),(2130434,'1','143','865',382,'Retail Sale Id 1264636',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 15:38:31','',''),(2130435,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:38:31','',''),(2130522,'1','143','865',382,'Retail Sale Id 1264683',2997.92,0.00,0.00,0.00,246.78,'2021-12-02 15:42:12','',''),(2130523,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-02 15:42:12','',''),(2130558,'1','143','865',382,'Retail Sale Id 1264707',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 15:43:59','',''),(2130559,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 15:43:59','',''),(2130590,'1','143','865',382,'Retail Sale Id 1264727',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 15:45:17','',''),(2130591,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 15:45:17','',''),(2130624,'1','143','865',382,'Retail Sale Id 1264744',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 15:46:53','',''),(2130625,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:46:53','',''),(2130666,'1','143','865',382,'Retail Sale Id 1264765',1699.04,0.00,0.00,0.00,139.86,'2021-12-02 15:48:43','',''),(2130667,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.59,0.00,'2021-12-02 15:48:43','',''),(2130716,'1','143','865',382,'Retail Sale Id 1264795',32800.00,0.00,0.00,0.00,2700.00,'2021-12-02 15:51:15','',''),(2130717,'1','143','865',382,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 15:51:15','',''),(2130768,'1','143','865',382,'Retail Sale Id 1264820',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 15:53:24','',''),(2130769,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:53:24','',''),(2130830,'1','143','865',382,'Retail Sale Id 1264854',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 15:55:30','',''),(2130831,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 15:55:30','',''),(2131198,'1','143','865',382,'Retail Sale Id 1265024',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 16:11:46','',''),(2131199,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:11:46','',''),(2131218,'1','143','865',382,'Retail Sale Id 1265039',2997.92,0.00,0.00,0.00,246.78,'2021-12-02 16:13:02','',''),(2131219,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-02 16:13:02','',''),(2131271,'1','143','865',382,'Retail Sale Id 1265062',1502.24,0.00,0.00,0.00,123.66,'2021-12-02 16:15:17','',''),(2131272,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 16:15:17','',''),(2131325,'1','143','865',382,'Retail Sale Id 1265091',1312.00,0.00,0.00,0.00,108.00,'2021-12-02 16:18:26','',''),(2131326,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 16:18:26','',''),(2131482,'1','143','865',382,'Retail Sale Id 1265169',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 16:26:00','',''),(2131483,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:26:00','',''),(2131530,'1','143','865',382,'Retail Sale Id 1265197',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 16:28:28','',''),(2131531,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:28:28','',''),(2131654,'1','143','865',382,'Retail Sale Id 1265243',2624.00,0.00,0.00,0.00,216.00,'2021-12-02 16:31:44','',''),(2131655,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 16:31:44','',''),(2131690,'1','143','865',382,'Retail Sale Id 1265259',1502.24,0.00,0.00,0.00,123.66,'2021-12-02 16:33:27','',''),(2131691,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 16:33:27','',''),(2131730,'1','143','865',382,'Retail Sale Id 1265286',7872.00,0.00,0.00,0.00,648.00,'2021-12-02 16:35:25','',''),(2131732,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 16:35:25','',''),(2131758,'1','143','865',382,'Retail Sale Id 1265297',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 16:37:26','',''),(2131759,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:37:26','',''),(2131820,'1','143','865',382,'Retail Sale Id 1265328',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 16:40:52','',''),(2131821,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:40:52','',''),(2131849,'1','143','865',382,'Retail Sale Id 1265344',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 16:42:24','',''),(2131850,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:42:24','',''),(2131873,'1','143','865',382,'Retail Sale Id 1265353',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 16:43:23','',''),(2131874,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:43:23','',''),(2131909,'1','143','865',382,'Retail Sale Id 1265369',2624.00,0.00,0.00,0.00,216.00,'2021-12-02 16:44:48','',''),(2131910,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 16:44:48','',''),(2131936,'1','143','865',382,'Retail Sale Id 1265386',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 16:46:04','',''),(2131937,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:46:04','',''),(2131972,'1','143','865',382,'Retail Sale Id 1265405',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 16:48:05','',''),(2131973,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:48:05','',''),(2132006,'1','143','865',382,'Retail Sale Id 1265422',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 16:50:13','',''),(2132007,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:50:13','',''),(2132048,'1','143','865',382,'Retail Sale Id 1265449',4001.60,0.00,0.00,0.00,329.40,'2021-12-02 16:52:42','',''),(2132049,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-02 16:52:42','',''),(2132066,'1','143','865',382,'Retail Sale Id 1265458',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 16:53:45','',''),(2132067,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:53:45','',''),(2132084,'1','143','865',382,'Retail Sale Id 1265465',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 16:54:50','',''),(2132085,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:54:50','',''),(2132120,'1','143','865',382,'Retail Sale Id 1265485',1502.24,0.00,0.00,0.00,123.66,'2021-12-02 16:57:33','',''),(2132121,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 16:57:33','',''),(2132148,'1','143','865',382,'Retail Sale Id 1265499',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 16:59:01','',''),(2132149,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:59:01','',''),(2132183,'1','143','865',382,'Retail Sale Id 1265511',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 17:01:17','',''),(2132184,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 17:01:17','',''),(2132215,'1','143','865',382,'Retail Sale Id 1265526',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 17:02:39','',''),(2132216,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 17:02:39','',''),(2132667,'1','143','865',382,'Retail Sale Id 1265731',62976.00,0.00,0.00,0.00,5184.00,'2021-12-02 17:32:38','',''),(2132668,'1','143','865',382,'Retail sales',0.00,0.00,0.00,96.00,0.00,'2021-12-02 17:32:38','',''),(2134783,'1','143','865',382,'Retail Sale Id 1266476',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 07:03:15','',''),(2134784,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 07:03:15','',''),(2134799,'1','143','865',382,'Retail Sale Id 1266484',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 07:04:23','',''),(2134800,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:04:23','',''),(2134817,'1','143','865',382,'Retail Sale Id 1266494',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 07:05:28','',''),(2134818,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:05:28','',''),(2134841,'1','143','865',382,'Retail Sale Id 1266512',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 07:06:54','',''),(2134842,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 07:06:54','',''),(2134861,'1','143','865',382,'Retail Sale Id 1266524',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 07:08:00','',''),(2134862,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:08:00','',''),(2134976,'1','143','865',382,'Retail Sale Id 1266571',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 07:14:16','',''),(2134977,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:14:16','',''),(2135024,'1','143','865',382,'Retail Sale Id 1266598',7216.00,0.00,0.00,0.00,594.00,'2021-12-03 07:16:52','',''),(2135025,'1','143','865',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-03 07:16:52','',''),(2135046,'1','143','865',382,'Retail Sale Id 1266607',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 07:18:04','',''),(2135047,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 07:18:04','',''),(2135052,'1','143','865',382,'Retail Sale Id 1266612',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 07:18:52','',''),(2135053,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 07:18:52','',''),(2135079,'1','143','865',382,'Retail Sale Id 1266619',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 07:19:47','',''),(2135080,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 07:19:47','',''),(2135216,'1','143','865',382,'Retail Sale Id 1266688',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 07:27:47','',''),(2135217,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:27:47','',''),(2135343,'1','143','865',382,'Retail Sale Id 1266753',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 07:35:21','',''),(2135344,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:35:21','',''),(2135398,'1','143','865',382,'Retail Sale Id 1266771',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 07:37:49','',''),(2135399,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:37:49','',''),(2135504,'1','143','865',382,'Retail Sale Id 1266824',14760.00,0.00,0.00,0.00,1215.00,'2021-12-03 07:44:09','',''),(2135505,'1','143','865',382,'Retail sales',0.00,0.00,0.00,22.50,0.00,'2021-12-03 07:44:09','',''),(2135761,'1','143','865',382,'Retail Sale Id 1266942',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 07:57:37','',''),(2135762,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 07:57:37','',''),(2135781,'1','143','865',382,'Retail Sale Id 1266953',1312.00,0.00,0.00,0.00,108.00,'2021-12-03 07:58:59','',''),(2135782,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 07:58:59','',''),(2135812,'1','143','865',382,'Retail Sale Id 1266965',6002.40,0.00,0.00,0.00,494.10,'2021-12-03 08:00:27','',''),(2135813,'1','143','865',382,'Retail sales',0.00,0.00,0.00,9.15,0.00,'2021-12-03 08:00:27','',''),(2135939,'1','143','865',382,'Retail Sale Id 1267003',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 08:04:10','',''),(2135940,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 08:04:10','',''),(2136128,'1','143','865',382,'Retail Sale Id 1267101',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 08:13:05','',''),(2136129,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:13:05','',''),(2136261,'1','143','866',382,'Retail Sale Id 1267173',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 08:20:19','',''),(2136262,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 08:20:19','',''),(2136344,'1','143','865',382,'Retail Sale Id 1267209',1502.24,0.00,0.00,0.00,123.66,'2021-12-03 08:24:58','',''),(2136345,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-03 08:24:58','',''),(2136374,'1','143','865',382,'Retail Sale Id 1267225',1502.24,0.00,0.00,0.00,123.66,'2021-12-03 08:26:38','',''),(2136375,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-03 08:26:38','',''),(2136416,'1','143','865',382,'Retail Sale Id 1267245',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 08:30:04','',''),(2136417,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:30:04','',''),(2136574,'1','143','865',382,'Retail Sale Id 1267286',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 08:37:03','',''),(2136575,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 08:37:03','',''),(2136696,'1','143','865',382,'Retail Sale Id 1267316',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 08:40:34','',''),(2136697,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:40:34','',''),(2136750,'1','143','865',382,'Retail Sale Id 1267328',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 08:42:07','',''),(2136751,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 08:42:07','',''),(2136770,'1','143','865',382,'Retail Sale Id 1267345',2499.36,0.00,0.00,0.00,205.74,'2021-12-03 08:43:23','',''),(2136771,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-03 08:43:23','',''),(2136794,'1','143','865',382,'Retail Sale Id 1267353',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 08:44:22','',''),(2136795,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 08:44:22','',''),(2136814,'1','143','865',382,'Retail Sale Id 1267364',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 08:46:01','',''),(2136815,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 08:46:01','',''),(2136838,'1','143','865',382,'Retail Sale Id 1267377',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 08:47:26','',''),(2136839,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:47:26','',''),(2136994,'1','143','865',382,'Retail Sale Id 1267460',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 08:56:57','',''),(2136995,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 08:56:57','',''),(2137011,'1','143','865',382,'Retail Sale Id 1267467',1502.24,0.00,0.00,0.00,123.66,'2021-12-03 08:57:54','',''),(2137012,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-03 08:57:54','',''),(2137086,'1','143','865',382,'Retail Sale Id 1267498',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 09:01:42','',''),(2137087,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:01:42','',''),(2137205,'1','143','865',382,'Retail Sale Id 1267571',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 09:07:17','',''),(2137206,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 09:07:17','',''),(2137277,'1','143','865',382,'Retail Sale Id 1267628',12136.00,0.00,0.00,0.00,999.00,'2021-12-03 09:11:02','',''),(2137278,'1','143','865',382,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-03 09:11:02','',''),(2137310,'1','143','865',382,'Retail Sale Id 1267643',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 09:12:42','',''),(2137311,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 09:12:42','',''),(2137605,'1','143','865',382,'Retail Sale Id 1267808',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 09:29:27','',''),(2137606,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 09:29:27','',''),(2137639,'1','143','865',382,'Retail Sale Id 1267822',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 09:31:27','',''),(2137640,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 09:31:27','',''),(2137757,'1','143','865',382,'Retail Sale Id 1267890',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 09:38:57','',''),(2137758,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:38:57','',''),(2137877,'1','143','865',382,'Retail Sale Id 1267952',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 09:46:06','',''),(2137878,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 09:46:06','',''),(2138070,'1','143','865',382,'Retail Sale Id 1268040',1502.24,0.00,0.00,0.00,123.66,'2021-12-03 09:58:14','',''),(2138071,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-03 09:58:14','',''),(2138235,'1','143','865',382,'Retail Sale Id 1268130',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 10:07:39','',''),(2138236,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 10:07:39','',''),(2138269,'1','143','865',382,'Retail Sale Id 1268146',1600.64,0.00,0.00,0.00,131.76,'2021-12-03 10:09:08','',''),(2138270,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-03 10:09:08','',''),(2138318,'1','143','865',382,'Retail Sale Id 1268167',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 10:11:42','',''),(2138320,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 10:11:42','',''),(2138348,'1','143','865',382,'Retail Sale Id 1268186',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 10:13:10','',''),(2138349,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 10:13:10','',''),(2138657,'1','143','865',382,'Retail Sale Id 1268332',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 10:31:19','',''),(2138658,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 10:31:19','',''),(2138682,'1','143','865',382,'Retail Sale Id 1268349',8856.00,0.00,0.00,0.00,729.00,'2021-12-03 10:33:31','',''),(2138683,'1','143','865',382,'Retail sales',0.00,0.00,0.00,13.50,0.00,'2021-12-03 10:33:31','',''),(2138723,'1','143','865',382,'Retail Sale Id 1268369',2997.92,0.00,0.00,0.00,246.78,'2021-12-03 10:36:31','',''),(2138724,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 10:36:31','',''),(2138793,'1','143','865',382,'Retail Sale Id 1268399',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 10:39:43','',''),(2138794,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 10:39:43','',''),(2138874,'1','143','865',382,'Retail Sale Id 1268450',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 10:46:09','',''),(2138875,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 10:46:09','',''),(2138923,'1','143','865',382,'Retail Sale Id 1268474',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 10:50:13','',''),(2138924,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 10:50:13','',''),(2139028,'1','143','865',382,'Retail Sale Id 1268528',1502.24,0.00,0.00,0.00,123.66,'2021-12-03 10:59:02','',''),(2139029,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-03 10:59:02','',''),(2139089,'1','143','865',382,'Retail Sale Id 1268552',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 11:03:00','',''),(2139090,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 11:03:00','',''),(2139099,'1','143','865',382,'Retail Sale Id 1268562',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 11:04:08','',''),(2139100,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 11:04:08','',''),(2139119,'1','143','865',382,'Retail Sale Id 1268571',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 11:05:20','',''),(2139120,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 11:05:20','',''),(2139131,'1','143','865',382,'Retail Sale Id 1268580',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 11:06:16','',''),(2139132,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 11:06:16','',''),(2139167,'1','143','865',382,'Retail Sale Id 1268601',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 11:09:33','',''),(2139168,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 11:09:33','',''),(2139185,'1','143','865',382,'Retail Sale Id 1268611',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 11:11:10','',''),(2139186,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 11:11:10','',''),(2139215,'1','143','865',382,'Retail Sale Id 1268626',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 11:13:42','',''),(2139216,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 11:13:42','',''),(2139259,'1','143','865',382,'Retail Sale Id 1268650',4998.72,0.00,0.00,0.00,411.48,'2021-12-03 11:15:50','',''),(2139260,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-03 11:15:50','',''),(2139312,'1','143','865',382,'Retail Sale Id 1268671',1502.24,0.00,0.00,0.00,123.66,'2021-12-03 11:18:25','',''),(2139313,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-03 11:18:25','',''),(2139338,'1','143','865',382,'Retail Sale Id 1268683',2997.92,0.00,0.00,0.00,246.78,'2021-12-03 11:20:36','',''),(2139339,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 11:20:36','',''),(2139352,'1','143','865',382,'Retail Sale Id 1268692',4998.72,0.00,0.00,0.00,411.48,'2021-12-03 11:21:54','',''),(2139353,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-03 11:21:54','',''),(2139384,'1','143','865',382,'Retail Sale Id 1268712',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 11:25:44','',''),(2139385,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:25:44','',''),(2139500,'1','143','865',382,'Retail Sale Id 1268774',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 11:34:56','',''),(2139501,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:34:56','',''),(2139512,'1','143','865',382,'Retail Sale Id 1268782',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 11:36:04','',''),(2139513,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 11:36:04','',''),(2139532,'1','143','865',382,'Retail Sale Id 1268790',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 11:37:54','',''),(2139533,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 11:37:54','',''),(2139558,'1','143','865',382,'Retail Sale Id 1268810',4998.72,0.00,0.00,0.00,411.48,'2021-12-03 11:40:32','',''),(2139559,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-03 11:40:32','',''),(2139636,'1','143','865',382,'Retail Sale Id 1268857',4500.16,0.00,0.00,0.00,370.44,'2021-12-03 11:46:11','',''),(2139637,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.86,0.00,'2021-12-03 11:46:11','',''),(2139676,'1','143','865',382,'Retail Sale Id 1268875',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 11:48:34','',''),(2139677,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 11:48:34','',''),(2139733,'1','143','865',382,'Retail Sale Id 1268910',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 11:53:00','',''),(2139734,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:53:00','',''),(2139765,'1','143','865',382,'Retail Sale Id 1268926',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 11:55:35','',''),(2139766,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 11:55:35','',''),(2139849,'1','143','865',382,'Retail Sale Id 1268971',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 12:01:53','',''),(2139850,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 12:01:53','',''),(2139877,'1','143','865',382,'Retail Sale Id 1268990',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 12:03:35','',''),(2139878,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 12:03:35','',''),(2139921,'1','143','865',382,'Retail Sale Id 1269014',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 12:05:50','',''),(2139922,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 12:05:50','',''),(2139957,'1','143','865',382,'Retail Sale Id 1269047',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 12:08:19','',''),(2139958,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 12:08:19','',''),(2139982,'1','143','865',382,'Retail Sale Id 1269059',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 12:09:40','',''),(2139983,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 12:09:40','',''),(2140008,'1','143','865',382,'Retail Sale Id 1269072',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 12:12:01','',''),(2140009,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 12:12:01','',''),(2140072,'1','143','865',382,'Retail Sale Id 1269105',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 12:19:29','',''),(2140073,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 12:19:29','',''),(2140228,'1','143','865',382,'Retail Sale Id 1269193',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 12:32:16','',''),(2140229,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 12:32:16','',''),(2140256,'1','143','865',382,'Retail Sale Id 1269212',2997.92,0.00,0.00,0.00,246.78,'2021-12-03 12:34:32','',''),(2140257,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 12:34:32','',''),(2140573,'1','143','865',382,'Retail Sale Id 1269366',5904.00,0.00,0.00,0.00,486.00,'2021-12-03 12:56:38','',''),(2140574,'1','143','865',382,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-03 12:56:38','',''),(2140685,'1','143','865',382,'Retail Sale Id 1269415',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 13:06:15','',''),(2140686,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 13:06:15','',''),(2140715,'1','143','865',382,'Retail Sale Id 1269430',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 13:08:54','',''),(2140716,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 13:08:54','',''),(2140958,'1','143','865',382,'Retail Sale Id 1269538',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 13:28:45','',''),(2140959,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 13:28:45','',''),(2140990,'1','143','865',382,'Retail Sale Id 1269550',34650.00,0.00,0.00,0.00,1540.00,'2021-12-03 13:31:00','',''),(2140991,'1','143','865',382,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-03 13:31:00','',''),(2141023,'1','143','865',382,'Retail Sale Id 1269572',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 13:33:24','',''),(2141024,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:33:24','',''),(2141067,'1','143','865',382,'Retail Sale Id 1269593',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 13:36:14','',''),(2141068,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:36:14','',''),(2141194,'1','143','865',382,'Retail Sale Id 1269649',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 13:43:14','',''),(2141195,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:43:14','',''),(2141349,'1','143','865',382,'Retail Sale Id 1269703',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 13:48:31','',''),(2141350,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 13:48:31','',''),(2141522,'1','143','865',382,'Retail Sale Id 1269769',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 13:56:38','',''),(2141523,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:56:38','',''),(2141562,'1','143','865',382,'Retail Sale Id 1269789',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 14:00:13','',''),(2141563,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:00:13','',''),(2141684,'1','143','865',382,'Retail Sale Id 1269836',2997.92,0.00,0.00,0.00,246.78,'2021-12-03 14:07:08','',''),(2141685,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 14:07:08','',''),(2141780,'1','143','865',382,'Retail Sale Id 1269881',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 14:13:08','',''),(2141781,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:13:08','',''),(2141965,'1','143','865',382,'Retail Sale Id 1269944',6232.00,0.00,0.00,0.00,513.00,'2021-12-03 14:24:03','',''),(2141966,'1','143','865',382,'Retail sales',0.00,0.00,0.00,9.50,0.00,'2021-12-03 14:24:03','',''),(2142109,'1','143','865',382,'Retail Sale Id 1270014',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 14:33:29','',''),(2142111,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:33:29','',''),(2142152,'1','143','865',382,'Retail Sale Id 1270024',1312.00,0.00,0.00,0.00,108.00,'2021-12-03 14:35:01','',''),(2142153,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 14:35:01','',''),(2142361,'1','143','865',382,'Retail Sale Id 1270095',2624.00,0.00,0.00,0.00,216.00,'2021-12-03 14:44:08','',''),(2142362,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 14:44:08','',''),(2142421,'1','143','865',382,'Retail Sale Id 1270128',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 14:46:44','',''),(2142422,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 14:46:44','',''),(2142453,'1','143','865',382,'Retail Sale Id 1270143',997.12,0.00,0.00,0.00,82.08,'2021-12-03 14:47:58','',''),(2142454,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 14:47:58','',''),(2142503,'1','143','865',382,'Retail Sale Id 1270170',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 14:50:13','',''),(2142504,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:50:13','',''),(2142543,'1','143','865',382,'Retail Sale Id 1270191',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 14:52:11','',''),(2142544,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 14:52:11','',''),(2142602,'1','143','865',382,'Retail Sale Id 1270215',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 14:54:58','',''),(2142603,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 14:54:58','',''),(2142659,'1','143','865',382,'Retail Sale Id 1270234',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 14:56:57','',''),(2142660,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 14:56:57','',''),(2142681,'1','143','865',382,'Retail Sale Id 1270244',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 14:58:39','',''),(2142682,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:58:39','',''),(2142722,'1','143','865',382,'Retail Sale Id 1270270',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 15:01:15','',''),(2142723,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 15:01:15','',''),(2142798,'1','143','865',382,'Retail Sale Id 1270304',5248.00,0.00,0.00,0.00,432.00,'2021-12-03 15:07:03','',''),(2142799,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 15:07:03','',''),(2142864,'1','143','865',382,'Retail Sale Id 1270343',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 15:10:22','',''),(2142865,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:10:22','',''),(2142962,'1','143','865',382,'Retail Sale Id 1270389',8003.20,0.00,0.00,0.00,658.80,'2021-12-03 15:14:35','',''),(2142963,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-03 15:14:35','',''),(2143014,'1','143','865',382,'Retail Sale Id 1270423',6500.96,0.00,0.00,0.00,535.14,'2021-12-03 15:17:04','',''),(2143015,'1','143','865',382,'Retail sales',0.00,0.00,0.00,9.91,0.00,'2021-12-03 15:17:04','',''),(2143043,'1','143','865',382,'Retail Sale Id 1270443',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 15:18:34','',''),(2143044,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:18:34','',''),(2143099,'1','143','865',382,'Retail Sale Id 1270475',8003.20,0.00,0.00,0.00,658.80,'2021-12-03 15:21:06','',''),(2143100,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-03 15:21:06','',''),(2143151,'1','143','865',382,'Retail Sale Id 1270504',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 15:24:09','',''),(2143152,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 15:24:09','',''),(2143198,'1','143','865',382,'Retail Sale Id 1270525',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 15:27:00','',''),(2143199,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 15:27:00','',''),(2143267,'1','143','865',382,'Retail Sale Id 1270555',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 15:30:00','',''),(2143268,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:30:00','',''),(2143285,'1','143','865',382,'Retail Sale Id 1270567',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 15:30:47','',''),(2143286,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 15:30:47','',''),(2143345,'1','143','865',382,'Retail Sale Id 1270602',4998.72,0.00,0.00,0.00,411.48,'2021-12-03 15:34:07','',''),(2143346,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-03 15:34:07','',''),(2143403,'1','143','865',382,'Retail Sale Id 1270618',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 15:36:03','',''),(2143404,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 15:36:03','',''),(2143438,'1','143','865',382,'Retail Sale Id 1270641',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 15:37:19','',''),(2143439,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 15:37:19','',''),(2143474,'1','143','865',382,'Retail Sale Id 1270663',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 15:38:57','',''),(2143475,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 15:38:57','',''),(2143628,'1','143','865',382,'Retail Sale Id 1270735',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 15:45:05','',''),(2143629,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 15:45:05','',''),(2143668,'1','143','865',382,'Retail Sale Id 1270754',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 15:46:29','',''),(2143669,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 15:46:29','',''),(2143718,'1','143','865',382,'Retail Sale Id 1270777',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 15:48:06','',''),(2143719,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 15:48:06','',''),(2143754,'1','143','865',382,'Retail Sale Id 1270794',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 15:49:34','',''),(2143755,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 15:49:34','',''),(2143776,'1','143','865',382,'Retail Sale Id 1270810',3503.04,0.00,0.00,0.00,288.36,'2021-12-03 15:51:05','',''),(2143777,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-03 15:51:05','',''),(2143814,'1','143','865',382,'Retail Sale Id 1270827',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 15:52:36','',''),(2143815,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:52:36','',''),(2143863,'1','143','865',382,'Retail Sale Id 1270854',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 15:55:08','',''),(2143864,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 15:55:08','',''),(2143881,'1','143','865',382,'Retail Sale Id 1270864',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 15:56:07','',''),(2143882,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 15:56:07','',''),(2143919,'1','143','865',382,'Retail Sale Id 1270880',1502.24,0.00,0.00,0.00,123.66,'2021-12-03 15:58:11','',''),(2143920,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-03 15:58:11','',''),(2143989,'1','143','865',382,'Retail Sale Id 1270911',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 16:01:04','',''),(2143990,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:01:04','',''),(2144033,'1','143','865',382,'Retail Sale Id 1270932',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 16:02:53','',''),(2144034,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:02:53','',''),(2144067,'1','143','865',382,'Retail Sale Id 1270953',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 16:04:35','',''),(2144068,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:04:35','',''),(2144119,'1','143','865',382,'Retail Sale Id 1270976',997.12,0.00,0.00,0.00,82.08,'2021-12-03 16:06:16','',''),(2144120,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 16:06:16','',''),(2144155,'1','143','865',382,'Retail Sale Id 1270992',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 16:07:49','',''),(2144156,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:07:49','',''),(2144178,'1','143','865',382,'Retail Sale Id 1271004',2197.60,0.00,0.00,0.00,180.90,'2021-12-03 16:08:57','',''),(2144179,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.35,0.00,'2021-12-03 16:08:57','',''),(2144216,'1','143','865',382,'Retail Sale Id 1271025',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 16:10:34','',''),(2144217,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:10:34','',''),(2144240,'1','143','865',382,'Retail Sale Id 1271036',2997.92,0.00,0.00,0.00,246.78,'2021-12-03 16:11:56','',''),(2144241,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 16:11:56','',''),(2144270,'1','143','865',382,'Retail Sale Id 1271055',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 16:13:53','',''),(2144271,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:13:53','',''),(2144304,'1','143','865',382,'Retail Sale Id 1271074',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 16:16:09','',''),(2144305,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:16:09','',''),(2144336,'1','143','865',382,'Retail Sale Id 1271091',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 16:17:55','',''),(2144337,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:17:55','',''),(2144374,'1','143','865',382,'Retail Sale Id 1271109',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 16:19:26','',''),(2144375,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:19:26','',''),(2144412,'1','143','865',382,'Retail Sale Id 1271128',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 16:21:16','',''),(2144413,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:21:16','',''),(2144434,'1','143','865',382,'Retail Sale Id 1271139',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 16:22:35','',''),(2144435,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:22:35','',''),(2144464,'1','143','865',382,'Retail Sale Id 1271154',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 16:24:04','',''),(2144465,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:24:04','',''),(2144542,'1','143','865',382,'Retail Sale Id 1271192',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 16:28:35','',''),(2144543,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:28:35','',''),(2144578,'1','143','865',382,'Retail Sale Id 1271207',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 16:30:32','',''),(2144579,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 16:30:32','',''),(2144616,'1','143','865',382,'Retail Sale Id 1271229',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 16:32:15','',''),(2144617,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:32:15','',''),(2144651,'1','143','865',382,'Retail Sale Id 1271245',11497.50,0.00,0.00,0.00,511.00,'2021-12-03 16:34:00','',''),(2144652,'1','143','865',382,'Retail sales',0.00,0.00,0.00,18.25,0.00,'2021-12-03 16:34:00','',''),(2144673,'1','143','865',382,'Retail Sale Id 1271257',8396.80,0.00,0.00,0.00,691.20,'2021-12-03 16:35:23','',''),(2144674,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.80,0.00,'2021-12-03 16:35:23','',''),(2144706,'1','143','865',382,'Retail Sale Id 1271275',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 16:36:47','',''),(2144707,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:36:47','',''),(2144765,'1','143','865',382,'Retail Sale Id 1271307',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 16:39:34','',''),(2144766,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:39:34','',''),(2145105,'1','143','865',382,'Retail Sale Id 1271453',65600.00,0.00,0.00,0.00,5400.00,'2021-12-03 16:55:27','',''),(2145106,'1','143','865',382,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-03 16:55:27','',''),(2145250,'1','143','865',382,'Retail Sale Id 1271516',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 17:03:12','',''),(2145251,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 17:03:12','',''),(2145302,'1','143','865',382,'Retail Sale Id 1271545',7872.00,0.00,0.00,0.00,648.00,'2021-12-03 17:06:40','',''),(2145303,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-03 17:06:40','',''),(2145324,'1','143','865',382,'Retail Sale Id 1271559',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 17:08:48','',''),(2145325,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 17:08:48','',''),(2147518,'1','143','865',382,'Retail Sale Id 1272349',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 06:57:29','',''),(2147519,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 06:57:29','',''),(2147532,'1','143','865',382,'Retail Sale Id 1272355',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 06:58:21','',''),(2147533,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 06:58:21','',''),(2147548,'1','143','865',382,'Retail Sale Id 1272364',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 06:59:14','',''),(2147549,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 06:59:14','',''),(2147679,'1','143','865',382,'Retail Sale Id 1272424',4001.60,0.00,0.00,0.00,329.40,'2021-12-04 07:06:15','',''),(2147680,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 07:06:15','',''),(2147705,'1','143','865',382,'Retail Sale Id 1272436',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 07:07:42','',''),(2147706,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:07:42','',''),(2147831,'1','143','865',382,'Retail Sale Id 1272507',32800.00,0.00,0.00,0.00,2700.00,'2021-12-04 07:15:16','',''),(2147832,'1','143','865',382,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 07:15:16','',''),(2147858,'1','143','865',382,'Retail Sale Id 1272530',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 07:16:34','',''),(2147859,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 07:16:34','',''),(2148012,'1','143','865',382,'Retail Sale Id 1272606',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 07:24:44','',''),(2148013,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:24:44','',''),(2148254,'1','143','865',382,'Retail Sale Id 1272735',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 07:35:37','',''),(2148255,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 07:35:37','',''),(2148317,'1','143','865',382,'Retail Sale Id 1272771',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 07:38:47','',''),(2148318,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 07:38:47','',''),(2148440,'1','143','865',382,'Retail Sale Id 1272882',2624.00,0.00,0.00,0.00,216.00,'2021-12-04 07:45:12','',''),(2148441,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 07:45:12','',''),(2148456,'1','143','865',382,'Retail Sale Id 1272896',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 07:46:20','',''),(2148457,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 07:46:20','',''),(2148474,'1','143','865',382,'Retail Sale Id 1272907',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 07:47:32','',''),(2148475,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 07:47:32','',''),(2148556,'1','143','865',382,'Retail Sale Id 1272957',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 07:52:18','',''),(2148557,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:52:18','',''),(2148592,'1','143','865',382,'Retail Sale Id 1272975',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 07:54:39','',''),(2148593,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 07:54:39','',''),(2148636,'1','143','865',382,'Retail Sale Id 1273012',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 07:57:32','',''),(2148637,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 07:57:32','',''),(2148677,'1','143','865',382,'Retail Sale Id 1273037',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 07:59:30','',''),(2148678,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:59:30','',''),(2148751,'1','143','865',382,'Retail Sale Id 1273069',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 08:02:37','',''),(2148752,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:02:37','',''),(2148771,'1','143','865',382,'Retail Sale Id 1273080',10824.00,0.00,0.00,0.00,891.00,'2021-12-04 08:03:42','',''),(2148772,'1','143','865',382,'Retail sales',0.00,0.00,0.00,16.50,0.00,'2021-12-04 08:03:42','',''),(2148858,'1','143','865',382,'Retail Sale Id 1273124',1312.00,0.00,0.00,0.00,108.00,'2021-12-04 08:06:53','',''),(2148859,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 08:06:53','',''),(2148878,'1','143','865',382,'Retail Sale Id 1273138',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 08:07:46','',''),(2148879,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:07:46','',''),(2148984,'1','143','865',382,'Retail Sale Id 1273201',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 08:12:42','',''),(2148985,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:12:42','',''),(2149198,'1','143','865',382,'Retail Sale Id 1273300',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 08:21:12','',''),(2149199,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:21:12','',''),(2149223,'1','143','865',382,'Retail Sale Id 1273338',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 08:22:36','',''),(2149224,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 08:22:36','',''),(2149253,'1','143','865',382,'Retail Sale Id 1273384',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 08:23:47','',''),(2149254,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 08:23:47','',''),(2149314,'1','143','865',382,'Retail Sale Id 1273417',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 08:26:32','',''),(2149315,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:26:32','',''),(2149364,'1','143','865',382,'Retail Sale Id 1273443',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 08:28:37','',''),(2149365,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:28:37','',''),(2149386,'1','143','865',382,'Retail Sale Id 1273453',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 08:29:30','',''),(2149387,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:29:31','',''),(2149493,'1','143','865',382,'Retail Sale Id 1273528',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 08:32:24','',''),(2149494,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:32:24','',''),(2149570,'1','143','865',382,'Retail Sale Id 1273567',3503.04,0.00,0.00,0.00,288.36,'2021-12-04 08:35:28','',''),(2149571,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-04 08:35:28','',''),(2149652,'1','143','865',382,'Retail Sale Id 1273601',6560.00,0.00,0.00,0.00,540.00,'2021-12-04 08:38:08','',''),(2149653,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 08:38:08','',''),(2149680,'1','143','865',382,'Retail Sale Id 1273614',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 08:39:57','',''),(2149681,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:39:57','',''),(2149743,'1','143','865',382,'Retail Sale Id 1273645',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 08:43:05','',''),(2149744,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:43:05','',''),(2149788,'1','143','865',382,'Retail Sale Id 1273669',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 08:44:32','',''),(2149789,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:44:32','',''),(2149824,'1','143','865',382,'Retail Sale Id 1273689',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 08:45:52','',''),(2149825,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 08:45:52','',''),(2149916,'1','143','865',382,'Retail Sale Id 1273736',2997.92,0.00,0.00,0.00,246.78,'2021-12-04 08:49:56','',''),(2149917,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-04 08:49:56','',''),(2149966,'1','143','865',382,'Retail Sale Id 1273764',4001.60,0.00,0.00,0.00,329.40,'2021-12-04 08:52:29','',''),(2149967,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 08:52:29','',''),(2149998,'1','143','865',382,'Retail Sale Id 1273785',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 08:53:50','',''),(2149999,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:53:50','',''),(2150093,'1','143','865',382,'Retail Sale Id 1273835',12136.00,0.00,0.00,0.00,999.00,'2021-12-04 08:58:26','',''),(2150094,'1','143','865',382,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-04 08:58:26','',''),(2150141,'1','143','865',382,'Retail Sale Id 1273856',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 09:00:16','',''),(2150142,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 09:00:16','',''),(2150163,'1','143','865',382,'Retail Sale Id 1273869',2624.00,0.00,0.00,0.00,216.00,'2021-12-04 09:01:35','',''),(2150164,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 09:01:35','',''),(2150473,'1','143','865',382,'Retail Sale Id 1274032',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 09:17:26','',''),(2150474,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:17:26','',''),(2150619,'1','143','865',382,'Retail Sale Id 1274111',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 09:23:26','',''),(2150620,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:23:26','',''),(2150673,'1','143','865',382,'Retail Sale Id 1274139',5248.00,0.00,0.00,0.00,432.00,'2021-12-04 09:26:26','',''),(2150674,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 09:26:26','',''),(2150698,'1','143','865',382,'Retail Sale Id 1274151',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 09:27:56','',''),(2150699,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:27:56','',''),(2152480,'1','143','865',382,'Retail Sale Id 1274366',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 10:34:51','',''),(2152481,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:34:51','',''),(2152523,'1','143','865',382,'Retail Sale Id 1274420',157500.00,0.00,0.00,0.00,7000.00,'2021-12-04 10:39:07','',''),(2152524,'1','143','865',382,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-04 10:39:07','',''),(2152543,'1','143','865',382,'Retail Sale Id 1274428',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 10:40:58','',''),(2152544,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 10:40:58','',''),(2152559,'1','143','865',382,'Retail Sale Id 1274433',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 10:42:25','',''),(2152560,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 10:42:25','',''),(2152604,'1','143','865',382,'Retail Sale Id 1274444',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 10:44:18','',''),(2152605,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 10:44:18','',''),(2152616,'1','143','865',382,'Retail Sale Id 1274451',4001.60,0.00,0.00,0.00,329.40,'2021-12-04 10:45:27','',''),(2152617,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 10:45:27','',''),(2152650,'1','143','865',382,'Retail Sale Id 1274459',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 10:47:03','',''),(2152651,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 10:47:03','',''),(2152676,'1','143','865',382,'Retail Sale Id 1274472',656.00,0.00,0.00,0.00,54.00,'2021-12-04 10:48:57','',''),(2152677,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-04 10:48:57','',''),(2152744,'1','143','865',382,'Retail Sale Id 1274502',5248.00,0.00,0.00,0.00,432.00,'2021-12-04 10:52:27','',''),(2152745,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 10:52:27','',''),(2152873,'1','143','865',382,'Retail Sale Id 1274555',5248.00,0.00,0.00,0.00,432.00,'2021-12-04 10:59:27','',''),(2152874,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 10:59:27','',''),(2153924,'1','143','865',382,'Retail Sale Id 1275055',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 11:54:26','',''),(2153925,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 11:54:26','',''),(2153978,'1','143','865',382,'Retail Sale Id 1275077',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 11:58:02','',''),(2153979,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 11:58:02','',''),(2154033,'1','143','865',382,'Retail Sale Id 1275086',11480.00,0.00,0.00,0.00,945.00,'2021-12-04 11:59:37','',''),(2154034,'1','143','865',382,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-04 11:59:37','',''),(2154069,'1','143','865',382,'Retail Sale Id 1275097',2997.92,0.00,0.00,0.00,246.78,'2021-12-04 12:01:11','',''),(2154070,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-04 12:01:11','',''),(2154137,'1','143','865',382,'Retail Sale Id 1275114',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 12:03:15','',''),(2154138,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:03:15','',''),(2154523,'1','143','865',382,'Retail Sale Id 1275295',15999.84,0.00,0.00,0.00,1317.06,'2021-12-04 12:26:44','',''),(2154524,'1','143','865',382,'Retail sales',0.00,0.00,0.00,24.39,0.00,'2021-12-04 12:26:44','',''),(2154547,'1','143','865',382,'Retail Sale Id 1275306',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 12:27:52','',''),(2154548,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 12:27:52','',''),(2154563,'1','143','865',382,'Retail Sale Id 1275315',4001.60,0.00,0.00,0.00,329.40,'2021-12-04 12:29:06','',''),(2154564,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 12:29:06','',''),(2154591,'1','143','865',382,'Retail Sale Id 1275330',4001.60,0.00,0.00,0.00,329.40,'2021-12-04 12:30:16','',''),(2154592,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 12:30:16','',''),(2154615,'1','143','865',382,'Retail Sale Id 1275343',2650.24,0.00,0.00,0.00,218.16,'2021-12-04 12:31:43','',''),(2154616,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.04,0.00,'2021-12-04 12:31:43','',''),(2154627,'1','143','865',382,'Retail Sale Id 1275348',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 12:32:31','',''),(2154628,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 12:32:31','',''),(2154665,'1','143','865',382,'Retail Sale Id 1275366',1797.44,0.00,0.00,0.00,147.96,'2021-12-04 12:34:20','',''),(2154666,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.74,0.00,'2021-12-04 12:34:20','',''),(2154701,'1','143','865',382,'Retail Sale Id 1275383',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 12:36:55','',''),(2154702,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 12:36:55','',''),(2154827,'1','143','865',382,'Retail Sale Id 1275445',8528.00,0.00,0.00,0.00,702.00,'2021-12-04 12:46:46','',''),(2154828,'1','143','865',382,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-04 12:46:46','',''),(2154848,'1','143','865',382,'Retail Sale Id 1275458',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 12:48:30','',''),(2154849,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 12:48:30','',''),(2154872,'1','143','865',382,'Retail Sale Id 1275466',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 12:49:32','',''),(2154873,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 12:49:32','',''),(2154900,'1','143','865',382,'Retail Sale Id 1275476',6560.00,0.00,0.00,0.00,540.00,'2021-12-04 12:50:47','',''),(2154901,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 12:50:47','',''),(2154950,'1','143','865',382,'Retail Sale Id 1275493',2624.00,0.00,0.00,0.00,216.00,'2021-12-04 12:53:38','',''),(2154951,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 12:53:38','',''),(2155040,'1','143','865',382,'Retail Sale Id 1275744',36999.90,0.00,0.00,0.00,1644.44,'2021-12-04 13:06:28','',''),(2155041,'1','143','865',382,'Retail sales',0.00,0.00,0.00,58.73,0.00,'2021-12-04 13:06:28','',''),(2155292,'1','143','865',382,'Retail Sale Id 1275863',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 13:21:57','',''),(2155293,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 13:21:57','',''),(2155374,'1','143','865',382,'Retail Sale Id 1275889',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 13:25:25','',''),(2155375,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:25:25','',''),(2155451,'1','143','865',382,'Retail Sale Id 1275910',7216.00,0.00,0.00,0.00,594.00,'2021-12-04 13:28:17','',''),(2155452,'1','143','865',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-04 13:28:17','',''),(2155478,'1','143','865',382,'Retail Sale Id 1275926',2997.92,0.00,0.00,0.00,246.78,'2021-12-04 13:29:55','',''),(2155479,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-04 13:29:55','',''),(2155518,'1','143','865',382,'Retail Sale Id 1275945',4001.60,0.00,0.00,0.00,329.40,'2021-12-04 13:31:53','',''),(2155519,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 13:31:53','',''),(2155622,'1','143','865',382,'Retail Sale Id 1275994',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 13:37:57','',''),(2155623,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 13:37:57','',''),(2155788,'1','143','865',382,'Retail Sale Id 1276078',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 13:46:57','',''),(2155789,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:46:57','',''),(2155810,'1','143','865',382,'Retail Sale Id 1276087',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 13:47:57','',''),(2155811,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 13:47:57','',''),(2156027,'1','143','865',382,'Retail Sale Id 1276181',4264.00,0.00,0.00,0.00,351.00,'2021-12-04 13:58:27','',''),(2156028,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-04 13:58:27','',''),(2156045,'1','143','865',382,'Retail Sale Id 1276188',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 13:59:28','',''),(2156046,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 13:59:28','',''),(2156072,'1','143','865',382,'Retail Sale Id 1276199',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 14:00:29','',''),(2156073,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:00:29','',''),(2156106,'1','143','865',382,'Retail Sale Id 1276210',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 14:01:44','',''),(2156107,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:01:44','',''),(2156245,'1','143','865',382,'Retail Sale Id 1276265',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 14:06:27','',''),(2156246,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:06:27','',''),(2156309,'1','143','865',382,'Retail Sale Id 1276301',8003.20,0.00,0.00,0.00,658.80,'2021-12-04 14:09:54','',''),(2156310,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-04 14:09:54','',''),(2156438,'1','143','865',382,'Retail Sale Id 1276361',4001.60,0.00,0.00,0.00,329.40,'2021-12-04 14:15:29','',''),(2156439,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 14:15:29','',''),(2156488,'1','143','865',382,'Retail Sale Id 1276387',4001.60,0.00,0.00,0.00,329.40,'2021-12-04 14:17:53','',''),(2156489,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 14:17:53','',''),(2156522,'1','143','865',382,'Retail Sale Id 1276407',997.12,0.00,0.00,0.00,82.08,'2021-12-04 14:19:36','',''),(2156523,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-04 14:19:36','',''),(2156550,'1','143','865',382,'Retail Sale Id 1276421',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 14:21:02','',''),(2156551,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:21:02','',''),(2156590,'1','143','865',382,'Retail Sale Id 1276446',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 14:23:10','',''),(2156591,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:23:10','',''),(2156643,'1','143','865',382,'Retail Sale Id 1276463',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 14:26:16','',''),(2156644,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:26:16','',''),(2156663,'1','143','865',382,'Retail Sale Id 1276474',5202.08,0.00,0.00,0.00,428.22,'2021-12-04 14:27:34','',''),(2156664,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.93,0.00,'2021-12-04 14:27:34','',''),(2156683,'1','143','865',382,'Retail Sale Id 1276486',4001.60,0.00,0.00,0.00,329.40,'2021-12-04 14:28:59','',''),(2156684,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 14:28:59','',''),(2156754,'1','143','865',382,'Retail Sale Id 1276522',4001.60,0.00,0.00,0.00,329.40,'2021-12-04 14:33:22','',''),(2156755,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 14:33:22','',''),(2156796,'1','143','865',382,'Retail Sale Id 1276539',6560.00,0.00,0.00,0.00,540.00,'2021-12-04 14:35:01','',''),(2156797,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 14:35:01','',''),(2156812,'1','143','865',382,'Retail Sale Id 1276547',4001.60,0.00,0.00,0.00,329.40,'2021-12-04 14:36:05','',''),(2156813,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 14:36:05','',''),(2156830,'1','143','865',382,'Retail Sale Id 1276558',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 14:36:58','',''),(2156831,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 14:36:58','',''),(2156961,'1','143','865',382,'Retail Sale Id 1276604',4001.60,0.00,0.00,0.00,329.40,'2021-12-04 14:44:00','',''),(2156962,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 14:44:00','',''),(2156987,'1','143','865',382,'Retail Sale Id 1276612',4001.60,0.00,0.00,0.00,329.40,'2021-12-04 14:44:58','',''),(2156988,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 14:44:58','',''),(2157042,'1','143','865',382,'Retail Sale Id 1276631',5497.28,0.00,0.00,0.00,452.52,'2021-12-04 14:46:49','',''),(2157043,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.38,0.00,'2021-12-04 14:46:49','',''),(2157159,'1','143','865',382,'Retail Sale Id 1276678',8003.20,0.00,0.00,0.00,658.80,'2021-12-04 14:53:18','',''),(2157160,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-04 14:53:18','',''),(2157202,'1','143','865',382,'Retail Sale Id 1276693',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 14:55:18','',''),(2157203,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 14:55:18','',''),(2157244,'1','143','865',382,'Retail Sale Id 1276706',4001.60,0.00,0.00,0.00,329.40,'2021-12-04 14:56:35','',''),(2157245,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 14:56:35','',''),(2157275,'1','143','865',382,'Retail Sale Id 1276712',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 14:57:52','',''),(2157276,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:57:52','',''),(2157420,'1','143','865',382,'Retail Sale Id 1276780',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 15:05:45','',''),(2157421,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:05:45','',''),(2157460,'1','143','865',382,'Retail Sale Id 1276805',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 15:08:52','',''),(2157461,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 15:08:52','',''),(2157482,'1','143','865',382,'Retail Sale Id 1276816',997.12,0.00,0.00,0.00,82.08,'2021-12-04 15:10:28','',''),(2157483,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-04 15:10:28','',''),(2157586,'1','143','865',382,'Retail Sale Id 1276860',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 15:15:23','',''),(2157587,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:15:23','',''),(2157632,'1','143','865',382,'Retail Sale Id 1276885',1502.24,0.00,0.00,0.00,123.66,'2021-12-04 15:18:09','',''),(2157633,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-04 15:18:09','',''),(2157726,'1','143','865',382,'Retail Sale Id 1276912',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 15:21:43','',''),(2157727,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:21:43','',''),(2157742,'1','143','865',382,'Retail Sale Id 1276923',997.12,0.00,0.00,0.00,82.08,'2021-12-04 15:22:46','',''),(2157743,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-04 15:22:46','',''),(2157824,'1','143','865',382,'Retail Sale Id 1276955',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 15:26:13','',''),(2157825,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:26:13','',''),(2157891,'1','143','865',382,'Retail Sale Id 1276988',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 15:28:36','',''),(2157892,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:28:36','',''),(2158034,'1','143','865',382,'Retail Sale Id 1277057',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 15:35:39','',''),(2158035,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:35:39','',''),(2158068,'1','143','865',382,'Retail Sale Id 1277076',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 15:37:01','',''),(2158069,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:37:01','',''),(2158092,'1','143','865',382,'Retail Sale Id 1277087',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 15:38:33','',''),(2158093,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:38:33','',''),(2158110,'1','143','865',382,'Retail Sale Id 1277097',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 15:39:46','',''),(2158111,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 15:39:46','',''),(2158140,'1','143','865',382,'Retail Sale Id 1277108',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 15:41:08','',''),(2158141,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 15:41:08','',''),(2158162,'1','143','865',382,'Retail Sale Id 1277121',2997.92,0.00,0.00,0.00,246.78,'2021-12-04 15:42:09','',''),(2158163,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-04 15:42:09','',''),(2158185,'1','143','865',382,'Retail Sale Id 1277131',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 15:43:14','',''),(2158186,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 15:43:14','',''),(2158220,'1','143','865',382,'Retail Sale Id 1277146',997.12,0.00,0.00,0.00,82.08,'2021-12-04 15:44:26','',''),(2158221,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-04 15:44:26','',''),(2158240,'1','143','865',382,'Retail Sale Id 1277157',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 15:45:25','',''),(2158241,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:45:25','',''),(2158354,'1','143','865',382,'Retail Sale Id 1277206',4998.72,0.00,0.00,0.00,411.48,'2021-12-04 15:51:04','',''),(2158355,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-04 15:51:04','',''),(2158380,'1','143','865',382,'Retail Sale Id 1277219',656.00,0.00,0.00,0.00,54.00,'2021-12-04 15:52:25','',''),(2158381,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-04 15:52:25','',''),(2158428,'1','143','865',382,'Retail Sale Id 1277244',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 15:54:39','',''),(2158429,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:54:39','',''),(2158573,'1','143','865',382,'Retail Sale Id 1277334',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 16:01:21','',''),(2158574,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:01:21','',''),(2158620,'1','143','865',382,'Retail Sale Id 1277355',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 16:04:00','',''),(2158621,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:04:00','',''),(2158654,'1','143','865',382,'Retail Sale Id 1277374',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 16:06:08','',''),(2158655,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:06:08','',''),(2158745,'1','143','865',382,'Retail Sale Id 1277420',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 16:10:07','',''),(2158746,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:10:07','',''),(2158775,'1','143','865',382,'Retail Sale Id 1277437',25200.00,0.00,0.00,0.00,1120.00,'2021-12-04 16:11:20','',''),(2158776,'1','143','865',382,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-04 16:11:20','',''),(2158805,'1','143','865',382,'Retail Sale Id 1277452',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 16:12:52','',''),(2158806,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:12:52','',''),(2158869,'1','143','865',382,'Retail Sale Id 1277487',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 16:15:31','',''),(2158870,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:15:31','',''),(2158915,'1','143','865',382,'Retail Sale Id 1277512',4001.60,0.00,0.00,0.00,329.40,'2021-12-04 16:17:44','',''),(2158916,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 16:17:44','',''),(2158947,'1','143','865',382,'Retail Sale Id 1277526',3949.12,0.00,0.00,0.00,325.08,'2021-12-04 16:19:17','',''),(2158948,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 16:19:17','',''),(2158967,'1','143','865',382,'Retail Sale Id 1277537',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 16:20:38','',''),(2158968,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:20:38','',''),(2159001,'1','143','865',382,'Retail Sale Id 1277554',701.92,0.00,0.00,0.00,57.78,'2021-12-04 16:21:53','',''),(2159002,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.07,0.00,'2021-12-04 16:21:53','',''),(2159037,'1','143','865',382,'Retail Sale Id 1277574',7216.00,0.00,0.00,0.00,594.00,'2021-12-04 16:23:35','',''),(2159038,'1','143','865',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-04 16:23:35','',''),(2159063,'1','143','865',382,'Retail Sale Id 1277590',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 16:24:39','',''),(2159064,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:24:39','',''),(2159107,'1','143','865',382,'Retail Sale Id 1277615',997.12,0.00,0.00,0.00,82.08,'2021-12-04 16:26:44','',''),(2159108,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-04 16:26:44','',''),(2159149,'1','143','865',382,'Retail Sale Id 1277634',1981.12,0.00,0.00,0.00,163.08,'2021-12-04 16:28:06','',''),(2159150,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.02,0.00,'2021-12-04 16:28:06','',''),(2159191,'1','143','865',382,'Retail Sale Id 1277659',2997.92,0.00,0.00,0.00,246.78,'2021-12-04 16:30:03','',''),(2159192,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-04 16:30:03','',''),(2159217,'1','143','865',382,'Retail Sale Id 1277670',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 16:31:19','',''),(2159218,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:31:19','',''),(2159265,'1','143','865',382,'Retail Sale Id 1277691',5497.28,0.00,0.00,0.00,452.52,'2021-12-04 16:34:04','',''),(2159266,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.38,0.00,'2021-12-04 16:34:04','',''),(2159295,'1','143','865',382,'Retail Sale Id 1277707',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 16:35:54','',''),(2159296,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:35:54','',''),(2159352,'1','143','865',382,'Retail Sale Id 1277734',2499.36,0.00,0.00,0.00,205.74,'2021-12-04 16:38:33','',''),(2159353,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-04 16:38:33','',''),(2159403,'1','143','865',382,'Retail Sale Id 1277746',1502.24,0.00,0.00,0.00,123.66,'2021-12-04 16:39:23','',''),(2159404,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-04 16:39:23','',''),(2159447,'1','143','865',382,'Retail Sale Id 1277761',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 16:41:03','',''),(2159448,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:41:03','',''),(2159493,'1','143','865',382,'Retail Sale Id 1277807',11480.00,0.00,0.00,0.00,945.00,'2021-12-04 16:44:16','',''),(2159494,'1','143','865',382,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-04 16:44:16','',''),(2159542,'1','143','865',382,'Retail Sale Id 1277852',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 16:46:19','',''),(2159543,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:46:19','',''),(2159585,'1','143','865',382,'Retail Sale Id 1277871',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 16:48:24','',''),(2159586,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:48:24','',''),(2159626,'1','143','865',382,'Retail Sale Id 1277889',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 16:50:19','',''),(2159627,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:50:19','',''),(2159652,'1','143','865',382,'Retail Sale Id 1277900',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 16:51:05','',''),(2159653,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:51:05','',''),(2159668,'1','143','865',382,'Retail Sale Id 1277909',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 16:51:48','',''),(2159669,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:51:48','',''),(2159785,'1','143','865',382,'Retail Sale Id 1277967',157500.00,0.00,0.00,0.00,7000.00,'2021-12-04 16:59:04','',''),(2159786,'1','143','865',382,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-04 16:59:04','',''),(2159867,'1','143','865',382,'Retail Sale Id 1278004',126000.00,0.00,0.00,0.00,5600.00,'2021-12-04 17:03:08','',''),(2159868,'1','143','865',382,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-04 17:03:08','',''),(2159889,'1','143','865',382,'Retail Sale Id 1278017',31500.00,0.00,0.00,0.00,1400.00,'2021-12-04 17:04:53','',''),(2159890,'1','143','865',382,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 17:04:53','',''),(2159954,'1','143','865',382,'Retail Sale Id 1278050',43755.20,0.00,0.00,0.00,3601.80,'2021-12-04 17:08:55','',''),(2159955,'1','143','865',382,'Retail sales',0.00,0.00,0.00,66.70,0.00,'2021-12-04 17:08:55','',''),(2160796,'1','143','865',382,'Retail Sale Id 1278387',213423.04,0.00,0.00,0.00,17568.36,'2021-12-04 18:03:10','',''),(2160797,'1','143','865',382,'Retail sales',0.00,0.00,0.00,325.34,0.00,'2021-12-04 18:03:10','',''),(2160885,'1','143','865',382,'Return of Retail Sale Id 1278387',0.00,213423.04,325.34,0.00,-17568.36,'2021-12-04 18:13:43','',''),(2160978,'1','143','865',382,'Retail Sale Id 1278477',97350.40,0.00,0.00,0.00,8013.60,'2021-12-04 18:28:43','',''),(2160979,'1','143','865',382,'Retail sales',0.00,0.00,0.00,148.40,0.00,'2021-12-04 18:28:43','',''),(2160986,'1','143','865',382,'Return of Retail Sale Id 1278004',0.00,126000.00,200.00,0.00,-5600.00,'2021-12-04 18:30:17','',''),(2160990,'1','143','865',382,'Retail Sale Id 1278482',63000.00,0.00,0.00,0.00,2800.00,'2021-12-04 18:31:20','',''),(2160991,'1','143','865',382,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-04 18:31:20','',''),(2161047,'1','143','865',382,'Retail Sale Id 1278509',100951.84,0.00,0.00,0.00,8310.06,'2021-12-04 18:42:15','',''),(2161048,'1','143','865',382,'Retail sales',0.00,0.00,0.00,153.89,0.00,'2021-12-04 18:42:15','',''),(2163645,'1','143','865',382,'Retail Sale Id 1279505',2000.80,0.00,0.00,0.00,164.70,'2021-12-05 07:53:00','',''),(2163646,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 07:53:00','',''),(2163681,'1','143','865',382,'Retail Sale Id 1279526',2997.92,0.00,0.00,0.00,246.78,'2021-12-05 07:55:11','',''),(2163682,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-05 07:55:11','',''),(2163788,'1','143','865',382,'Retail Sale Id 1279580',2000.80,0.00,0.00,0.00,164.70,'2021-12-05 08:01:30','',''),(2163789,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 08:01:30','',''),(2163828,'1','143','865',382,'Retail Sale Id 1279603',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 08:03:40','',''),(2163829,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:03:40','',''),(2163846,'1','143','865',382,'Retail Sale Id 1279616',4001.60,0.00,0.00,0.00,329.40,'2021-12-05 08:04:48','',''),(2163847,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-05 08:04:48','',''),(2164044,'1','143','865',382,'Retail Sale Id 1279740',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 08:14:55','',''),(2164045,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:14:55','',''),(2164112,'1','143','865',382,'Retail Sale Id 1279769',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 08:18:18','',''),(2164113,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:18:18','',''),(2164188,'1','143','865',382,'Retail Sale Id 1279814',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 08:22:01','',''),(2164189,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:22:01','',''),(2164310,'1','143','865',382,'Retail Sale Id 1279875',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 08:26:52','',''),(2164311,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:26:52','',''),(2164504,'1','143','865',382,'Retail Sale Id 1279976',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 08:36:20','',''),(2164505,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:36:20','',''),(2164645,'1','143','865',382,'Retail Sale Id 1280039',2000.80,0.00,0.00,0.00,164.70,'2021-12-05 08:44:28','',''),(2164646,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 08:44:28','',''),(2164874,'1','143','865',382,'Retail Sale Id 1280159',2499.36,0.00,0.00,0.00,205.74,'2021-12-05 08:56:48','',''),(2164875,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-05 08:56:48','',''),(2164896,'1','143','865',382,'Retail Sale Id 1280175',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 08:58:07','',''),(2164897,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:58:07','',''),(2164939,'1','143','865',382,'Retail Sale Id 1280196',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 09:00:31','',''),(2164940,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 09:00:31','',''),(2164979,'1','143','865',382,'Retail Sale Id 1280215',4264.00,0.00,0.00,0.00,351.00,'2021-12-05 09:02:59','',''),(2164980,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-05 09:02:59','',''),(2165003,'1','143','865',382,'Retail Sale Id 1280226',1502.24,0.00,0.00,0.00,123.66,'2021-12-05 09:04:04','',''),(2165004,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-05 09:04:04','',''),(2165031,'1','143','865',382,'Retail Sale Id 1280240',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 09:05:33','',''),(2165032,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 09:05:33','',''),(2165067,'1','143','865',382,'Retail Sale Id 1280262',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 09:07:22','',''),(2165068,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:07:22','',''),(2165091,'1','143','865',382,'Retail Sale Id 1280277',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 09:08:31','',''),(2165092,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 09:08:31','',''),(2165115,'1','143','865',382,'Retail Sale Id 1280293',2000.80,0.00,0.00,0.00,164.70,'2021-12-05 09:09:39','',''),(2165116,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 09:09:39','',''),(2165156,'1','143','865',382,'Retail Sale Id 1280311',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 09:11:04','',''),(2165157,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 09:11:04','',''),(2165191,'1','143','865',382,'Retail Sale Id 1280328',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 09:13:07','',''),(2165192,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:13:07','',''),(2165242,'1','143','865',382,'Retail Sale Id 1280378',7498.08,0.00,0.00,0.00,617.22,'2021-12-05 09:17:12','',''),(2165243,'1','143','865',382,'Retail sales',0.00,0.00,0.00,11.43,0.00,'2021-12-05 09:17:12','',''),(2165278,'1','143','865',382,'Retail Sale Id 1280402',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 09:18:50','',''),(2165279,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:18:50','',''),(2165352,'1','143','865',382,'Retail Sale Id 1280448',2000.80,0.00,0.00,0.00,164.70,'2021-12-05 09:23:53','',''),(2165353,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 09:23:53','',''),(2165378,'1','143','865',382,'Retail Sale Id 1280457',4001.60,0.00,0.00,0.00,329.40,'2021-12-05 09:25:02','',''),(2165379,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-05 09:25:02','',''),(2165410,'1','143','865',382,'Retail Sale Id 1280479',4001.60,0.00,0.00,0.00,329.40,'2021-12-05 09:26:31','',''),(2165411,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-05 09:26:31','',''),(2165466,'1','143','865',382,'Retail Sale Id 1280510',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 09:29:24','',''),(2165467,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 09:29:24','',''),(2165508,'1','143','865',382,'Retail Sale Id 1280536',4001.60,0.00,0.00,0.00,329.40,'2021-12-05 09:31:15','',''),(2165509,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-05 09:31:15','',''),(2165540,'1','143','865',382,'Retail Sale Id 1280554',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 09:33:01','',''),(2165541,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 09:33:01','',''),(2165694,'1','143','865',382,'Retail Sale Id 1280630',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 09:41:08','',''),(2165695,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 09:41:08','',''),(2165742,'1','143','865',382,'Retail Sale Id 1280653',4001.60,0.00,0.00,0.00,329.40,'2021-12-05 09:43:08','',''),(2165743,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-05 09:43:08','',''),(2165822,'1','143','865',382,'Retail Sale Id 1280679',5248.00,0.00,0.00,0.00,432.00,'2021-12-05 09:45:24','',''),(2165823,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 09:45:24','',''),(2165882,'1','143','865',382,'Retail Sale Id 1280700',1200.48,0.00,0.00,0.00,98.82,'2021-12-05 09:47:09','',''),(2165883,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.83,0.00,'2021-12-05 09:47:09','',''),(2165937,'1','143','865',382,'Retail Sale Id 1280722',6560.00,0.00,0.00,0.00,540.00,'2021-12-05 09:49:35','',''),(2165938,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 09:49:35','',''),(2166398,'1','143','865',382,'Retail Sale Id 1280960',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 10:19:13','',''),(2166400,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:19:13','',''),(2166437,'1','143','865',382,'Retail Sale Id 1280984',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 10:21:29','',''),(2166438,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:21:29','',''),(2166457,'1','143','865',382,'Retail Sale Id 1280993',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 10:22:39','',''),(2166458,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:22:39','',''),(2166473,'1','143','865',382,'Retail Sale Id 1281001',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 10:24:20','',''),(2166474,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:24:20','',''),(2166532,'1','143','865',382,'Retail Sale Id 1281029',2000.80,0.00,0.00,0.00,164.70,'2021-12-05 10:27:49','',''),(2166533,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 10:27:49','',''),(2166592,'1','143','865',382,'Retail Sale Id 1281062',4998.72,0.00,0.00,0.00,411.48,'2021-12-05 10:31:22','',''),(2166593,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-05 10:31:22','',''),(2166608,'1','143','865',382,'Retail Sale Id 1281071',2000.80,0.00,0.00,0.00,164.70,'2021-12-05 10:32:19','',''),(2166609,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 10:32:19','',''),(2166624,'1','143','865',382,'Retail Sale Id 1281079',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 10:33:38','',''),(2166625,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:33:38','',''),(2166654,'1','143','865',382,'Retail Sale Id 1281095',2997.92,0.00,0.00,0.00,246.78,'2021-12-05 10:35:30','',''),(2166655,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-05 10:35:30','',''),(2166692,'1','143','865',382,'Retail Sale Id 1281110',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 10:37:12','',''),(2166693,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:37:12','',''),(2166714,'1','143','865',382,'Retail Sale Id 1281125',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 10:38:46','',''),(2166715,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:38:46','',''),(2166734,'1','143','865',382,'Retail Sale Id 1281135',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 10:39:57','',''),(2166735,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:39:57','',''),(2166776,'1','143','865',382,'Retail Sale Id 1281158',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 10:43:24','',''),(2166777,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:43:24','',''),(2166873,'1','143','865',382,'Retail Sale Id 1281211',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 10:47:52','',''),(2166874,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:47:52','',''),(2166927,'1','143','865',382,'Retail Sale Id 1281238',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 10:49:52','',''),(2166928,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:49:52','',''),(2167043,'1','143','865',382,'Retail Sale Id 1281300',207900.00,0.00,0.00,0.00,9240.00,'2021-12-05 10:57:17','',''),(2167044,'1','143','865',382,'Retail sales',0.00,0.00,0.00,330.00,0.00,'2021-12-05 10:57:17','',''),(2167123,'1','143','865',382,'Retail Sale Id 1281336',2499.36,0.00,0.00,0.00,205.74,'2021-12-05 11:01:15','',''),(2167124,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-05 11:01:15','',''),(2167228,'1','143','865',382,'Retail Sale Id 1281403',984.00,0.00,0.00,0.00,81.00,'2021-12-05 11:08:13','',''),(2167229,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.50,0.00,'2021-12-05 11:08:13','',''),(2167272,'1','143','865',382,'Retail Sale Id 1281431',1640.00,0.00,0.00,0.00,135.00,'2021-12-05 11:10:31','',''),(2167273,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-05 11:10:31','',''),(2167312,'1','143','865',382,'Retail Sale Id 1281449',3352.16,0.00,0.00,0.00,275.94,'2021-12-05 11:13:10','',''),(2167313,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.11,0.00,'2021-12-05 11:13:10','',''),(2167346,'1','143','865',382,'Retail Sale Id 1281465',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 11:15:18','',''),(2167347,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:15:18','',''),(2167498,'1','143','865',382,'Retail Sale Id 1281531',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 11:24:24','',''),(2167499,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:24:24','',''),(2167651,'1','143','865',382,'Retail Sale Id 1281609',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 11:31:59','',''),(2167652,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:31:59','',''),(2167741,'1','143','865',382,'Retail Sale Id 1281650',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 11:36:54','',''),(2167742,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:36:54','',''),(2167755,'1','143','865',382,'Retail Sale Id 1281657',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 11:38:02','',''),(2167756,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:38:02','',''),(2167800,'1','143','865',382,'Retail Sale Id 1281702',1312.00,0.00,0.00,0.00,108.00,'2021-12-05 11:41:53','',''),(2167801,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 11:41:53','',''),(2167867,'1','143','865',382,'Retail Sale Id 1281760',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 11:45:46','',''),(2167868,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:45:46','',''),(2167905,'1','143','865',382,'Retail Sale Id 1281778',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 11:47:34','',''),(2167906,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:47:34','',''),(2167919,'1','143','865',382,'Retail Sale Id 1281785',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 11:48:35','',''),(2167920,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 11:48:35','',''),(2168182,'1','143','865',382,'Retail Sale Id 1281924',6560.00,0.00,0.00,0.00,540.00,'2021-12-05 12:03:43','',''),(2168183,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 12:03:43','',''),(2168939,'1','143','865',382,'Retail Sale Id 1282308',11480.00,0.00,0.00,0.00,945.00,'2021-12-05 12:38:03','',''),(2168940,'1','143','865',382,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-05 12:38:03','',''),(2169039,'1','143','865',382,'Retail Sale Id 1282362',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 12:43:20','',''),(2169040,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:43:20','',''),(2169061,'1','143','865',382,'Retail Sale Id 1282377',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 12:44:24','',''),(2169062,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:44:24','',''),(2169109,'1','143','865',382,'Retail Sale Id 1282405',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 12:47:33','',''),(2169110,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:47:33','',''),(2169125,'1','143','865',382,'Retail Sale Id 1282421',8003.20,0.00,0.00,0.00,658.80,'2021-12-05 12:49:03','',''),(2169126,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-05 12:49:03','',''),(2169247,'1','143','865',382,'Retail Sale Id 1282487',2624.00,0.00,0.00,0.00,216.00,'2021-12-05 12:56:06','',''),(2169248,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 12:56:06','',''),(2169299,'1','143','865',382,'Retail Sale Id 1282515',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 12:59:00','',''),(2169300,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:59:00','',''),(2169395,'1','143','865',382,'Retail Sale Id 1282552',16400.00,0.00,0.00,0.00,1350.00,'2021-12-05 13:03:04','',''),(2169396,'1','143','865',382,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 13:03:04','',''),(2169461,'1','143','865',382,'Retail Sale Id 1282619',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 13:06:53','',''),(2169462,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 13:06:53','',''),(2169478,'1','143','865',382,'Retail Sale Id 1282627',2000.80,0.00,0.00,0.00,164.70,'2021-12-05 13:07:57','',''),(2169479,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 13:07:57','',''),(2169520,'1','143','865',382,'Retail Sale Id 1282644',997.12,0.00,0.00,0.00,82.08,'2021-12-05 13:10:04','',''),(2169521,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-05 13:10:04','',''),(2169558,'1','143','865',382,'Retail Sale Id 1282664',2624.00,0.00,0.00,0.00,216.00,'2021-12-05 13:12:06','',''),(2169559,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 13:12:06','',''),(2169596,'1','143','865',382,'Retail Sale Id 1282684',2000.80,0.00,0.00,0.00,164.70,'2021-12-05 13:14:44','',''),(2169597,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 13:14:44','',''),(2169654,'1','143','865',382,'Retail Sale Id 1282704',1312.00,0.00,0.00,0.00,108.00,'2021-12-05 13:18:09','',''),(2169655,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 13:18:09','',''),(2169678,'1','143','865',382,'Retail Sale Id 1282719',2000.80,0.00,0.00,0.00,164.70,'2021-12-05 13:19:25','',''),(2169679,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 13:19:25','',''),(2169742,'1','143','865',382,'Retail Sale Id 1282755',8003.20,0.00,0.00,0.00,658.80,'2021-12-05 13:23:52','',''),(2169743,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-05 13:23:52','',''),(2169766,'1','143','865',382,'Retail Sale Id 1282770',8003.20,0.00,0.00,0.00,658.80,'2021-12-05 13:25:14','',''),(2169767,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-05 13:25:14','',''),(2169788,'1','143','865',382,'Retail Sale Id 1282784',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 13:26:47','',''),(2169789,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 13:26:47','',''),(2169838,'1','143','865',382,'Retail Sale Id 1282802',3201.28,0.00,0.00,0.00,263.52,'2021-12-05 13:28:59','',''),(2169839,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.88,0.00,'2021-12-05 13:28:59','',''),(2169931,'1','143','865',382,'Retail Sale Id 1282842',4001.60,0.00,0.00,0.00,329.40,'2021-12-05 13:33:56','',''),(2169932,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-05 13:33:56','',''),(2170065,'1','143','865',382,'Retail Sale Id 1282900',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 13:40:16','',''),(2170066,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:40:16','',''),(2170101,'1','143','865',382,'Retail Sale Id 1282908',4998.72,0.00,0.00,0.00,411.48,'2021-12-05 13:41:50','',''),(2170102,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-05 13:41:50','',''),(2170153,'1','143','865',382,'Retail Sale Id 1282921',2997.92,0.00,0.00,0.00,246.78,'2021-12-05 13:43:24','',''),(2170154,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-05 13:43:24','',''),(2170229,'1','143','865',382,'Retail Sale Id 1282956',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 13:48:02','',''),(2170230,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 13:48:02','',''),(2170249,'1','143','865',382,'Retail Sale Id 1282964',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 13:49:42','',''),(2170250,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 13:49:42','',''),(2170324,'1','143','865',382,'Retail Sale Id 1282995',8003.20,0.00,0.00,0.00,658.80,'2021-12-05 13:53:02','',''),(2170325,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-05 13:53:02','',''),(2170342,'1','143','865',382,'Retail Sale Id 1283004',3201.28,0.00,0.00,0.00,263.52,'2021-12-05 13:54:12','',''),(2170343,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.88,0.00,'2021-12-05 13:54:12','',''),(2170364,'1','143','865',382,'Retail Sale Id 1283013',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 13:55:19','',''),(2170365,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 13:55:19','',''),(2170394,'1','143','865',382,'Retail Sale Id 1283026',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 13:56:56','',''),(2170395,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 13:56:56','',''),(2170441,'1','143','865',382,'Retail Sale Id 1283043',4500.16,0.00,0.00,0.00,370.44,'2021-12-05 13:58:39','',''),(2170442,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.86,0.00,'2021-12-05 13:58:39','',''),(2170477,'1','143','865',382,'Retail Sale Id 1283060',997.12,0.00,0.00,0.00,82.08,'2021-12-05 14:00:43','',''),(2170478,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-05 14:00:43','',''),(2170539,'1','143','865',382,'Retail Sale Id 1283093',997.12,0.00,0.00,0.00,82.08,'2021-12-05 14:04:54','',''),(2170540,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-05 14:04:54','',''),(2170699,'1','143','865',382,'Retail Sale Id 1283161',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 14:13:50','',''),(2170700,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:13:50','',''),(2170721,'1','143','865',382,'Retail Sale Id 1283167',997.12,0.00,0.00,0.00,82.08,'2021-12-05 14:15:11','',''),(2170722,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-05 14:15:11','',''),(2171001,'1','143','865',382,'Retail Sale Id 1283286',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 14:29:26','',''),(2171002,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:29:26','',''),(2171129,'1','143','865',382,'Retail Sale Id 1283324',5248.00,0.00,0.00,0.00,432.00,'2021-12-05 14:34:04','',''),(2171130,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 14:34:04','',''),(2171197,'1','143','865',382,'Retail Sale Id 1283342',7872.00,0.00,0.00,0.00,648.00,'2021-12-05 14:37:06','',''),(2171198,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-05 14:37:06','',''),(2171217,'1','143','865',382,'Retail Sale Id 1283353',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 14:38:40','',''),(2171218,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 14:38:40','',''),(2171263,'1','143','865',382,'Retail Sale Id 1283375',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 14:42:14','',''),(2171264,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:42:14','',''),(2171365,'1','143','865',382,'Retail Sale Id 1283407',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 14:47:39','',''),(2171366,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:47:39','',''),(2171433,'1','143','865',382,'Retail Sale Id 1283441',6888.00,0.00,0.00,0.00,567.00,'2021-12-05 14:51:52','',''),(2171434,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.50,0.00,'2021-12-05 14:51:52','',''),(2171452,'1','143','865',382,'Retail Sale Id 1283452',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 14:52:45','',''),(2171454,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:52:45','',''),(2171481,'1','143','865',382,'Retail Sale Id 1283468',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 14:55:17','',''),(2171482,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:55:17','',''),(2171519,'1','143','865',382,'Retail Sale Id 1283486',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 14:57:57','',''),(2171520,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:57:57','',''),(2171559,'1','143','865',382,'Retail Sale Id 1283505',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 15:01:02','',''),(2171560,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:01:02','',''),(2171567,'1','143','865',382,'Retail Sale Id 1283510',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 15:02:08','',''),(2171568,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:02:08','',''),(2171850,'1','143','865',382,'Retail Sale Id 1283652',2997.92,0.00,0.00,0.00,246.78,'2021-12-05 15:23:27','',''),(2171851,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-05 15:23:27','',''),(2171874,'1','143','865',382,'Retail Sale Id 1283666',4998.72,0.00,0.00,0.00,411.48,'2021-12-05 15:25:12','',''),(2171875,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-05 15:25:12','',''),(2171936,'1','143','865',382,'Retail Sale Id 1283701',170560.00,0.00,0.00,0.00,14040.00,'2021-12-05 15:30:02','',''),(2171937,'1','143','865',382,'Retail sales',0.00,0.00,0.00,260.00,0.00,'2021-12-05 15:30:02','',''),(2172118,'1','143','865',382,'Retail Sale Id 1283779',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 15:38:32','',''),(2172119,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:38:32','',''),(2172167,'1','143','865',382,'Retail Sale Id 1283804',6999.52,0.00,0.00,0.00,576.18,'2021-12-05 15:40:54','',''),(2172168,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.67,0.00,'2021-12-05 15:40:54','',''),(2172203,'1','143','865',382,'Retail Sale Id 1283822',9840.00,0.00,0.00,0.00,810.00,'2021-12-05 15:42:15','',''),(2172204,'1','143','865',382,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-05 15:42:15','',''),(2172264,'1','143','865',382,'Retail Sale Id 1283848',5904.00,0.00,0.00,0.00,486.00,'2021-12-05 15:45:18','',''),(2172266,'1','143','865',382,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-05 15:45:18','',''),(2172341,'1','143','865',382,'Retail Sale Id 1283899',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 15:48:43','',''),(2172342,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:48:43','',''),(2172365,'1','143','865',382,'Retail Sale Id 1283909',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 15:49:56','',''),(2172366,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:49:56','',''),(2172383,'1','143','865',382,'Retail Sale Id 1283924',997.12,0.00,0.00,0.00,82.08,'2021-12-05 15:51:08','',''),(2172384,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-05 15:51:08','',''),(2172399,'1','143','865',382,'Retail Sale Id 1283932',2000.80,0.00,0.00,0.00,164.70,'2021-12-05 15:52:10','',''),(2172400,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 15:52:10','',''),(2172424,'1','143','865',382,'Retail Sale Id 1283946',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 15:53:43','',''),(2172425,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:53:43','',''),(2172480,'1','143','865',382,'Retail Sale Id 1283974',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 15:57:17','',''),(2172481,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:57:17','',''),(2172496,'1','143','865',382,'Retail Sale Id 1283983',997.12,0.00,0.00,0.00,82.08,'2021-12-05 15:58:13','',''),(2172497,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-05 15:58:13','',''),(2172518,'1','143','865',382,'Retail Sale Id 1283995',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 15:59:18','',''),(2172519,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:59:18','',''),(2172620,'1','143','865',382,'Retail Sale Id 1284048',7216.00,0.00,0.00,0.00,594.00,'2021-12-05 16:05:36','',''),(2172621,'1','143','865',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-05 16:05:36','',''),(2172646,'1','143','865',382,'Retail Sale Id 1284063',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 16:07:20','',''),(2172647,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 16:07:20','',''),(2172664,'1','143','865',382,'Retail Sale Id 1284072',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 16:08:22','',''),(2172665,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 16:08:22','',''),(2172716,'1','143','865',382,'Retail Sale Id 1284097',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 16:11:29','',''),(2172717,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 16:11:29','',''),(2172750,'1','143','865',382,'Retail Sale Id 1284113',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 16:13:38','',''),(2172751,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:13:38','',''),(2172764,'1','143','865',382,'Retail Sale Id 1284118',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 16:14:33','',''),(2172765,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:14:33','',''),(2172808,'1','143','865',382,'Retail Sale Id 1284140',5248.00,0.00,0.00,0.00,432.00,'2021-12-05 16:17:30','',''),(2172809,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 16:17:30','',''),(2172844,'1','143','865',382,'Retail Sale Id 1284159',5248.00,0.00,0.00,0.00,432.00,'2021-12-05 16:20:09','',''),(2172845,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 16:20:09','',''),(2172880,'1','143','865',382,'Retail Sale Id 1284185',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 16:22:21','',''),(2172881,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:22:21','',''),(2172902,'1','143','865',382,'Retail Sale Id 1284197',6232.00,0.00,0.00,0.00,513.00,'2021-12-05 16:23:31','',''),(2172903,'1','143','865',382,'Retail sales',0.00,0.00,0.00,9.50,0.00,'2021-12-05 16:23:31','',''),(2172938,'1','143','865',382,'Retail Sale Id 1284211',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 16:25:29','',''),(2172939,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 16:25:29','',''),(2172955,'1','143','865',382,'Retail Sale Id 1284226',6999.52,0.00,0.00,0.00,576.18,'2021-12-05 16:27:07','',''),(2172956,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.67,0.00,'2021-12-05 16:27:07','',''),(2172981,'1','143','865',382,'Retail Sale Id 1284242',3503.04,0.00,0.00,0.00,288.36,'2021-12-05 16:28:54','',''),(2172982,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-05 16:28:54','',''),(2172999,'1','143','865',382,'Retail Sale Id 1284253',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 16:30:00','',''),(2173000,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 16:30:00','',''),(2173007,'1','143','865',382,'Retail Sale Id 1284258',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 16:31:18','',''),(2173008,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 16:31:18','',''),(2173029,'1','143','865',382,'Retail Sale Id 1284268',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 16:32:14','',''),(2173030,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 16:32:14','',''),(2173077,'1','143','865',382,'Retail Sale Id 1284290',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 16:34:37','',''),(2173078,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:34:37','',''),(2173091,'1','143','865',382,'Retail Sale Id 1284296',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 16:35:23','',''),(2173092,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:35:23','',''),(2173117,'1','143','865',382,'Retail Sale Id 1284310',5248.00,0.00,0.00,0.00,432.00,'2021-12-05 16:36:36','',''),(2173118,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 16:36:36','',''),(2173131,'1','143','865',382,'Retail Sale Id 1284317',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 16:37:22','',''),(2173132,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:37:22','',''),(2173155,'1','143','865',382,'Retail Sale Id 1284330',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 16:38:44','',''),(2173156,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 16:38:44','',''),(2173181,'1','143','865',382,'Retail Sale Id 1284340',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 16:40:09','',''),(2173182,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:40:09','',''),(2173197,'1','143','865',382,'Retail Sale Id 1284352',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 16:41:07','',''),(2173198,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 16:41:07','',''),(2173205,'1','143','865',382,'Retail Sale Id 1284356',2499.36,0.00,0.00,0.00,205.74,'2021-12-05 16:41:53','',''),(2173206,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-05 16:41:53','',''),(2173223,'1','143','865',382,'Retail Sale Id 1284363',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 16:42:46','',''),(2173224,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 16:42:46','',''),(2173241,'1','143','865',382,'Retail Sale Id 1284375',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 16:43:58','',''),(2173242,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 16:43:58','',''),(2173253,'1','143','865',382,'Retail Sale Id 1284380',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 16:44:49','',''),(2173254,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 16:44:49','',''),(2173273,'1','143','865',382,'Retail Sale Id 1284388',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 16:45:43','',''),(2173274,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:45:43','',''),(2173281,'1','143','865',382,'Retail Sale Id 1284396',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 16:46:28','',''),(2173282,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 16:46:28','',''),(2173295,'1','143','865',382,'Retail Sale Id 1284404',8003.20,0.00,0.00,0.00,658.80,'2021-12-05 16:47:40','',''),(2173296,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-05 16:47:40','',''),(2173311,'1','143','865',382,'Retail Sale Id 1284411',1600.64,0.00,0.00,0.00,131.76,'2021-12-05 16:48:26','',''),(2173312,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-05 16:48:26','',''),(2173333,'1','143','865',382,'Retail Sale Id 1284422',5248.00,0.00,0.00,0.00,432.00,'2021-12-05 16:49:46','',''),(2173334,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 16:49:46','',''),(2173365,'1','143','865',382,'Retail Sale Id 1284437',5248.00,0.00,0.00,0.00,432.00,'2021-12-05 16:51:26','',''),(2173366,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 16:51:26','',''),(2173377,'1','143','865',382,'Retail Sale Id 1284444',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 16:52:28','',''),(2173378,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 16:52:28','',''),(2173395,'1','143','865',382,'Retail Sale Id 1284454',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 16:53:27','',''),(2173396,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 16:53:27','',''),(2173407,'1','143','865',382,'Retail Sale Id 1284461',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 16:54:21','',''),(2173408,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:54:21','',''),(2173419,'1','143','865',382,'Retail Sale Id 1284466',1640.00,0.00,0.00,0.00,135.00,'2021-12-05 16:55:18','',''),(2173420,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-05 16:55:18','',''),(2173427,'1','143','865',382,'Retail Sale Id 1284469',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 16:56:11','',''),(2173428,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:56:11','',''),(2173451,'1','143','865',382,'Retail Sale Id 1284483',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 16:57:02','',''),(2173452,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 16:57:02','',''),(2173496,'1','143','865',382,'Retail Sale Id 1284506',4001.60,0.00,0.00,0.00,329.40,'2021-12-05 17:00:26','',''),(2173497,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-05 17:00:26','',''),(2173522,'1','143','865',382,'Retail Sale Id 1284519',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 17:02:02','',''),(2173523,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 17:02:02','',''),(2173549,'1','143','865',382,'Retail Sale Id 1284530',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 17:04:06','',''),(2173550,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 17:04:06','',''),(2173612,'1','143','865',382,'Retail Sale Id 1284553',18900.00,0.00,0.00,0.00,840.00,'2021-12-05 17:07:31','',''),(2173613,'1','143','865',382,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-05 17:07:31','',''),(2173638,'1','143','865',382,'Retail Sale Id 1284565',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 17:09:35','',''),(2173639,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:09:35','',''),(2173668,'1','143','865',382,'Retail Sale Id 1284577',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 17:11:23','',''),(2173669,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 17:11:23','',''),(2173676,'1','143','865',382,'Retail Sale Id 1284581',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 17:12:11','',''),(2173677,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 17:12:11','',''),(2173758,'1','143','865',382,'Retail Sale Id 1284623',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 17:20:12','',''),(2173759,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 17:20:12','',''),(2175586,'1','143','865',382,'Retail Sale Id 1285244',5904.00,0.00,0.00,0.00,486.00,'2021-12-06 07:15:12','',''),(2175587,'1','143','865',382,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-06 07:15:12','',''),(2175610,'1','143','865',382,'Retail Sale Id 1285262',2000.80,0.00,0.00,0.00,164.70,'2021-12-06 07:16:33','',''),(2175611,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 07:16:33','',''),(2175634,'1','143','865',382,'Retail Sale Id 1285273',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 07:17:46','',''),(2175635,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:17:46','',''),(2175652,'1','143','865',382,'Retail Sale Id 1285282',2997.92,0.00,0.00,0.00,246.78,'2021-12-06 07:18:55','',''),(2175653,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-06 07:18:55','',''),(2175868,'1','143','865',382,'Retail Sale Id 1285390',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 07:32:09','',''),(2175869,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 07:32:09','',''),(2175905,'1','143','865',382,'Retail Sale Id 1285408',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 07:33:58','',''),(2175906,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 07:33:58','',''),(2175957,'1','143','865',382,'Retail Sale Id 1285435',5904.00,0.00,0.00,0.00,486.00,'2021-12-06 07:37:04','',''),(2175958,'1','143','865',382,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-06 07:37:04','',''),(2175995,'1','143','865',382,'Retail Sale Id 1285453',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 07:38:58','',''),(2175996,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 07:38:58','',''),(2176037,'1','143','865',382,'Retail Sale Id 1285473',4998.72,0.00,0.00,0.00,411.48,'2021-12-06 07:41:17','',''),(2176038,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-06 07:41:17','',''),(2176078,'1','143','865',382,'Retail Sale Id 1285490',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 07:42:27','',''),(2176079,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:42:27','',''),(2176099,'1','143','865',382,'Retail Sale Id 1285499',5248.00,0.00,0.00,0.00,432.00,'2021-12-06 07:43:42','',''),(2176100,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-06 07:43:42','',''),(2176117,'1','143','865',382,'Retail Sale Id 1285514',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 07:44:46','',''),(2176118,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 07:44:46','',''),(2176495,'1','143','865',382,'Retail Sale Id 1285685',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 08:00:49','',''),(2176496,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 08:00:49','',''),(2176529,'1','143','865',382,'Retail Sale Id 1285704',6560.00,0.00,0.00,0.00,540.00,'2021-12-06 08:03:07','',''),(2176530,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 08:03:07','',''),(2176574,'1','143','865',382,'Retail Sale Id 1285725',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 08:05:40','',''),(2176575,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 08:05:40','',''),(2176814,'1','143','865',382,'Retail Sale Id 1285852',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 08:21:56','',''),(2176815,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 08:21:56','',''),(2176849,'1','143','865',382,'Retail Sale Id 1285873',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 08:26:05','',''),(2176850,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 08:26:05','',''),(2176903,'1','143','865',382,'Retail Sale Id 1285903',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 08:31:18','',''),(2176904,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:31:18','',''),(2176927,'1','143','865',382,'Retail Sale Id 1285915',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 08:32:42','',''),(2176928,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:32:42','',''),(2176941,'1','143','865',382,'Retail Sale Id 1285921',997.12,0.00,0.00,0.00,82.08,'2021-12-06 08:33:45','',''),(2176942,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 08:33:45','',''),(2177019,'1','143','865',382,'Retail Sale Id 1285953',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 08:39:37','',''),(2177020,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:39:37','',''),(2177031,'1','143','865',382,'Retail Sale Id 1285961',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 08:40:44','',''),(2177032,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:40:44','',''),(2177041,'1','143','865',382,'Retail Sale Id 1285966',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 08:41:45','',''),(2177042,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:41:45','',''),(2177060,'1','143','865',382,'Retail Sale Id 1285973',997.12,0.00,0.00,0.00,82.08,'2021-12-06 08:42:31','',''),(2177061,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 08:42:31','',''),(2177090,'1','143','865',382,'Retail Sale Id 1285989',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 08:44:52','',''),(2177091,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:44:52','',''),(2177173,'1','143','865',382,'Retail Sale Id 1286028',4001.60,0.00,0.00,0.00,329.40,'2021-12-06 08:50:33','',''),(2177174,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-06 08:50:33','',''),(2177217,'1','143','865',382,'Retail Sale Id 1286054',1502.24,0.00,0.00,0.00,123.66,'2021-12-06 08:54:10','',''),(2177218,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-06 08:54:10','',''),(2177227,'1','143','865',382,'Retail Sale Id 1286058',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 08:55:08','',''),(2177228,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:55:08','',''),(2177301,'1','143','865',382,'Retail Sale Id 1286092',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 09:00:06','',''),(2177302,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:00:06','',''),(2177331,'1','143','865',382,'Retail Sale Id 1286106',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 09:02:18','',''),(2177332,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:02:18','',''),(2177347,'1','143','865',382,'Retail Sale Id 1286117',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 09:04:23','',''),(2177348,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:04:23','',''),(2177538,'1','143','865',382,'Retail Sale Id 1286200',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 09:16:46','',''),(2177539,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 09:16:46','',''),(2177620,'1','143','865',382,'Retail Sale Id 1286234',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 09:21:36','',''),(2177621,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 09:21:36','',''),(2177636,'1','143','865',382,'Retail Sale Id 1286248',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 09:23:12','',''),(2177637,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:23:12','',''),(2177676,'1','143','865',382,'Retail Sale Id 1286265',6002.40,0.00,0.00,0.00,494.10,'2021-12-06 09:25:33','',''),(2177677,'1','143','865',382,'Retail sales',0.00,0.00,0.00,9.15,0.00,'2021-12-06 09:25:33','',''),(2177752,'1','143','865',382,'Retail Sale Id 1286301',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 09:29:43','',''),(2177753,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:29:43','',''),(2177770,'1','143','865',382,'Retail Sale Id 1286308',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 09:30:50','',''),(2177771,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:30:50','',''),(2177792,'1','143','865',382,'Retail Sale Id 1286320',189000.00,0.00,0.00,0.00,8400.00,'2021-12-06 09:32:16','',''),(2177793,'1','143','865',382,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-06 09:32:16','',''),(2177825,'1','143','865',382,'Retail Sale Id 1286331',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 09:33:23','',''),(2177826,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 09:33:23','',''),(2177891,'1','143','865',382,'Retail Sale Id 1286354',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 09:37:13','',''),(2177892,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 09:37:13','',''),(2177972,'1','143','865',382,'Retail Sale Id 1286383',1600.64,0.00,0.00,0.00,131.76,'2021-12-06 09:41:10','',''),(2177973,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-06 09:41:10','',''),(2177998,'1','143','865',382,'Retail Sale Id 1286392',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 09:42:29','',''),(2177999,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 09:42:29','',''),(2178018,'1','143','865',382,'Retail Sale Id 1286400',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 09:43:44','',''),(2178019,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:43:44','',''),(2178185,'1','143','865',382,'Retail Sale Id 1286485',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 09:54:53','',''),(2178186,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 09:54:53','',''),(2178284,'1','143','865',382,'Retail Sale Id 1286539',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 10:02:45','',''),(2178285,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:02:45','',''),(2178326,'1','143','865',382,'Retail Sale Id 1286560',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 10:04:53','',''),(2178327,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 10:04:53','',''),(2178370,'1','143','865',382,'Retail Sale Id 1286574',31500.00,0.00,0.00,0.00,1400.00,'2021-12-06 10:06:46','',''),(2178371,'1','143','865',382,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 10:06:46','',''),(2178435,'1','143','865',382,'Retail Sale Id 1286599',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 10:09:29','',''),(2178436,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:09:29','',''),(2178465,'1','143','865',382,'Retail Sale Id 1286618',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 10:11:21','',''),(2178466,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:11:21','',''),(2178561,'1','143','865',382,'Retail Sale Id 1286668',11499.68,0.00,0.00,0.00,946.62,'2021-12-06 10:18:02','',''),(2178562,'1','143','865',382,'Retail sales',0.00,0.00,0.00,17.53,0.00,'2021-12-06 10:18:02','',''),(2178623,'1','143','865',382,'Retail Sale Id 1286704',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 10:22:33','',''),(2178624,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:22:33','',''),(2178665,'1','143','865',382,'Retail Sale Id 1286725',8528.00,0.00,0.00,0.00,702.00,'2021-12-06 10:26:20','',''),(2178666,'1','143','865',382,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-06 10:26:20','',''),(2178695,'1','143','865',382,'Retail Sale Id 1286738',2997.92,0.00,0.00,0.00,246.78,'2021-12-06 10:27:47','',''),(2178696,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-06 10:27:47','',''),(2178729,'1','143','865',382,'Retail Sale Id 1286756',6560.00,0.00,0.00,0.00,540.00,'2021-12-06 10:30:05','',''),(2178730,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 10:30:05','',''),(2178784,'1','143','865',382,'Retail Sale Id 1286780',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 10:33:19','',''),(2178785,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:33:19','',''),(2178806,'1','143','865',382,'Retail Sale Id 1286794',2000.80,0.00,0.00,0.00,164.70,'2021-12-06 10:35:27','',''),(2178807,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 10:35:27','',''),(2178830,'1','143','865',382,'Retail Sale Id 1286805',2624.00,0.00,0.00,0.00,216.00,'2021-12-06 10:37:06','',''),(2178831,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 10:37:06','',''),(2178862,'1','143','865',382,'Retail Sale Id 1286831',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 10:39:37','',''),(2178863,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:39:37','',''),(2178896,'1','143','865',382,'Retail Sale Id 1286848',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 10:42:10','',''),(2178897,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 10:42:10','',''),(2178970,'1','143','865',382,'Retail Sale Id 1286889',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 10:46:05','',''),(2178971,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 10:46:05','',''),(2179004,'1','143','865',382,'Retail Sale Id 1286905',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 10:47:55','',''),(2179005,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:47:55','',''),(2179034,'1','143','865',382,'Retail Sale Id 1286923',1699.04,0.00,0.00,0.00,139.86,'2021-12-06 10:49:46','',''),(2179035,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.59,0.00,'2021-12-06 10:49:46','',''),(2179058,'1','143','865',382,'Retail Sale Id 1286943',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 10:50:48','',''),(2179059,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 10:50:48','',''),(2179082,'1','143','865',382,'Retail Sale Id 1286957',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 10:52:27','',''),(2179083,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:52:27','',''),(2179110,'1','143','865',382,'Retail Sale Id 1286973',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 10:54:11','',''),(2179111,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 10:54:11','',''),(2179128,'1','143','865',382,'Retail Sale Id 1286983',2000.80,0.00,0.00,0.00,164.70,'2021-12-06 10:55:15','',''),(2179129,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 10:55:15','',''),(2179155,'1','143','865',382,'Retail Sale Id 1286997',4001.60,0.00,0.00,0.00,329.40,'2021-12-06 10:56:53','',''),(2179156,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-06 10:56:53','',''),(2179177,'1','143','865',382,'Retail Sale Id 1287016',1298.88,0.00,0.00,0.00,106.92,'2021-12-06 10:58:28','',''),(2179178,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.98,0.00,'2021-12-06 10:58:28','',''),(2179257,'1','143','865',382,'Retail Sale Id 1287056',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 11:03:49','',''),(2179258,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 11:03:49','',''),(2179321,'1','143','865',382,'Retail Sale Id 1287097',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 11:07:09','',''),(2179322,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 11:07:09','',''),(2179726,'1','143','865',382,'Retail Sale Id 1287315',10168.00,0.00,0.00,0.00,837.00,'2021-12-06 11:33:21','',''),(2179727,'1','143','865',382,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-06 11:33:21','',''),(2179810,'1','143','865',382,'Retail Sale Id 1287362',6560.00,0.00,0.00,0.00,540.00,'2021-12-06 11:41:28','',''),(2179811,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 11:41:28','',''),(2180016,'1','143','865',382,'Retail Sale Id 1287524',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 11:55:26','',''),(2180017,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:55:26','',''),(2180114,'1','143','865',382,'Retail Sale Id 1287575',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 12:02:06','',''),(2180115,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:02:06','',''),(2180142,'1','143','865',382,'Retail Sale Id 1287587',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 12:03:46','',''),(2180143,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:03:46','',''),(2180328,'1','143','865',382,'Retail Sale Id 1287699',1502.24,0.00,0.00,0.00,123.66,'2021-12-06 12:14:26','',''),(2180329,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-06 12:14:26','',''),(2180354,'1','143','865',382,'Retail Sale Id 1287713',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 12:15:56','',''),(2180355,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:15:56','',''),(2180384,'1','143','865',382,'Retail Sale Id 1287731',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 12:17:30','',''),(2180385,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:17:30','',''),(2180428,'1','143','865',382,'Retail Sale Id 1287752',2499.36,0.00,0.00,0.00,205.74,'2021-12-06 12:20:12','',''),(2180429,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-06 12:20:12','',''),(2180444,'1','143','865',382,'Retail Sale Id 1287760',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 12:21:29','',''),(2180445,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:21:29','',''),(2180464,'1','143','865',382,'Retail Sale Id 1287770',109620.00,0.00,0.00,0.00,4872.00,'2021-12-06 12:23:01','',''),(2180465,'1','143','865',382,'Retail sales',0.00,0.00,0.00,174.00,0.00,'2021-12-06 12:23:01','',''),(2180484,'1','143','865',382,'Retail Sale Id 1287781',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 12:24:32','',''),(2180485,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:24:32','',''),(2180500,'1','143','865',382,'Retail Sale Id 1287791',2000.80,0.00,0.00,0.00,164.70,'2021-12-06 12:25:44','',''),(2180501,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 12:25:44','',''),(2180522,'1','143','865',382,'Retail Sale Id 1287801',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 12:27:14','',''),(2180523,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:27:14','',''),(2180558,'1','143','865',382,'Retail Sale Id 1287821',14760.00,0.00,0.00,0.00,1215.00,'2021-12-06 12:29:31','',''),(2180559,'1','143','865',382,'Retail sales',0.00,0.00,0.00,22.50,0.00,'2021-12-06 12:29:31','',''),(2180582,'1','143','865',382,'Retail Sale Id 1287834',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 12:31:03','',''),(2180583,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:31:03','',''),(2180621,'1','143','865',382,'Retail Sale Id 1287852',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 12:33:02','',''),(2180622,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:33:02','',''),(2180645,'1','143','865',382,'Retail Sale Id 1287864',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 12:34:19','',''),(2180646,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:34:19','',''),(2180658,'1','143','865',382,'Retail Sale Id 1287871',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 12:35:16','',''),(2180659,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:35:16','',''),(2180686,'1','143','865',382,'Retail Sale Id 1287887',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 12:36:40','',''),(2180687,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:36:40','',''),(2180730,'1','143','865',382,'Retail Sale Id 1287908',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 12:39:06','',''),(2180731,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:39:06','',''),(2180802,'1','143','865',382,'Retail Sale Id 1287944',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 12:44:15','',''),(2180803,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:44:15','',''),(2180939,'1','143','865',382,'Retail Sale Id 1288016',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 12:52:30','',''),(2180940,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:52:30','',''),(2181049,'1','143','865',382,'Retail Sale Id 1288075',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 12:58:33','',''),(2181050,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:58:33','',''),(2181080,'1','143','865',382,'Retail Sale Id 1288088',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 12:59:57','',''),(2181081,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:59:57','',''),(2181120,'1','143','865',382,'Retail Sale Id 1288105',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 13:01:55','',''),(2181121,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:01:55','',''),(2181196,'1','143','865',382,'Retail Sale Id 1288140',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 13:07:10','',''),(2181197,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:07:10','',''),(2181228,'1','143','865',382,'Retail Sale Id 1288161',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 13:09:11','',''),(2181229,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 13:09:11','',''),(2181258,'1','143','865',382,'Retail Sale Id 1288182',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 13:10:33','',''),(2181259,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 13:10:33','',''),(2181377,'1','143','865',382,'Retail Sale Id 1288238',2000.80,0.00,0.00,0.00,164.70,'2021-12-06 13:16:04','',''),(2181378,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 13:16:04','',''),(2181427,'1','143','865',382,'Retail Sale Id 1288250',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 13:18:21','',''),(2181428,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:18:21','',''),(2181606,'1','143','865',382,'Retail Sale Id 1288336',4998.72,0.00,0.00,0.00,411.48,'2021-12-06 13:31:25','',''),(2181607,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-06 13:31:25','',''),(2181696,'1','143','865',382,'Retail Sale Id 1288361',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 13:35:33','',''),(2181697,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 13:35:33','',''),(2181862,'1','143','865',382,'Retail Sale Id 1288439',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 13:43:06','',''),(2181863,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 13:43:06','',''),(2182021,'1','143','865',382,'Retail Sale Id 1288515',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 13:51:33','',''),(2182022,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 13:51:33','',''),(2182345,'1','143','865',382,'Retail Sale Id 1288662',997.12,0.00,0.00,0.00,82.08,'2021-12-06 14:06:31','',''),(2182346,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 14:06:31','',''),(2182463,'1','143','865',382,'Retail Sale Id 1288711',25000.16,0.00,0.00,0.00,2057.94,'2021-12-06 14:11:45','',''),(2182464,'1','143','865',382,'Retail sales',0.00,0.00,0.00,38.11,0.00,'2021-12-06 14:11:45','',''),(2182573,'1','143','865',382,'Retail Sale Id 1288757',4001.60,0.00,0.00,0.00,329.40,'2021-12-06 14:16:20','',''),(2182574,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-06 14:16:20','',''),(2182615,'1','143','865',382,'Retail Sale Id 1288777',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 14:18:16','',''),(2182616,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:18:16','',''),(2182678,'1','143','865',382,'Retail Sale Id 1288807',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 14:21:41','',''),(2182679,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:21:41','',''),(2183087,'1','143','865',382,'Retail Sale Id 1288994',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 14:43:01','',''),(2183088,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:43:01','',''),(2183192,'1','143','865',382,'Retail Sale Id 1289040',2000.80,0.00,0.00,0.00,164.70,'2021-12-06 14:48:15','',''),(2183193,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 14:48:15','',''),(2183214,'1','143','865',382,'Retail Sale Id 1289049',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 14:49:32','',''),(2183215,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:49:32','',''),(2183236,'1','143','865',382,'Retail Sale Id 1289061',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 14:50:42','',''),(2183237,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 14:50:42','',''),(2183262,'1','143','865',382,'Retail Sale Id 1289076',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 14:51:57','',''),(2183263,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:51:57','',''),(2183293,'1','143','865',382,'Retail Sale Id 1289088',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 14:53:12','',''),(2183294,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:53:12','',''),(2183407,'1','143','865',382,'Retail Sale Id 1289143',1502.24,0.00,0.00,0.00,123.66,'2021-12-06 14:59:10','',''),(2183408,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-06 14:59:10','',''),(2183423,'1','143','865',382,'Retail Sale Id 1289151',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 15:00:05','',''),(2183424,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:00:05','',''),(2183451,'1','143','865',382,'Retail Sale Id 1289166',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 15:01:35','',''),(2183452,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:01:35','',''),(2183467,'1','143','865',382,'Retail Sale Id 1289177',1312.00,0.00,0.00,0.00,108.00,'2021-12-06 15:02:29','',''),(2183468,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:02:29','',''),(2183495,'1','143','865',382,'Retail Sale Id 1289193',16400.00,0.00,0.00,0.00,1350.00,'2021-12-06 15:04:00','',''),(2183496,'1','143','865',382,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 15:04:00','',''),(2183519,'1','143','865',382,'Retail Sale Id 1289199',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 15:05:09','',''),(2183520,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:05:09','',''),(2183572,'1','143','865',382,'Retail Sale Id 1289225',1312.00,0.00,0.00,0.00,108.00,'2021-12-06 15:08:29','',''),(2183573,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:08:29','',''),(2183597,'1','143','865',382,'Retail Sale Id 1289238',1312.00,0.00,0.00,0.00,108.00,'2021-12-06 15:09:57','',''),(2183598,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:09:57','',''),(2183657,'1','143','865',382,'Retail Sale Id 1289257',2624.00,0.00,0.00,0.00,216.00,'2021-12-06 15:13:11','',''),(2183658,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 15:13:11','',''),(2183822,'1','143','865',382,'Retail Sale Id 1289334',2997.92,0.00,0.00,0.00,246.78,'2021-12-06 15:21:13','',''),(2183823,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-06 15:21:13','',''),(2183883,'1','143','865',382,'Retail Sale Id 1289356',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 15:23:23','',''),(2183884,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:23:23','',''),(2183907,'1','143','865',382,'Retail Sale Id 1289373',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 15:24:21','',''),(2183908,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:24:21','',''),(2183963,'1','143','865',382,'Retail Sale Id 1289399',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 15:26:57','',''),(2183964,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:26:57','',''),(2183984,'1','143','865',382,'Retail Sale Id 1289412',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 15:28:14','',''),(2183985,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:28:14','',''),(2184017,'1','143','865',382,'Retail Sale Id 1289427',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 15:29:56','',''),(2184018,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:29:56','',''),(2184053,'1','143','865',382,'Retail Sale Id 1289446',2624.00,0.00,0.00,0.00,216.00,'2021-12-06 15:32:03','',''),(2184054,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 15:32:03','',''),(2184185,'1','143','865',382,'Retail Sale Id 1289510',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 15:38:42','',''),(2184186,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:38:42','',''),(2184241,'1','143','865',382,'Retail Sale Id 1289522',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 15:40:19','',''),(2184242,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:40:19','',''),(2184280,'1','143','865',382,'Retail Sale Id 1289534',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 15:41:27','',''),(2184281,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:41:27','',''),(2184375,'1','143','865',382,'Retail Sale Id 1289563',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 15:44:32','',''),(2184376,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:44:32','',''),(2184434,'1','143','865',382,'Retail Sale Id 1289582',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 15:46:27','',''),(2184435,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:46:27','',''),(2184484,'1','143','865',382,'Retail Sale Id 1289605',2000.80,0.00,0.00,0.00,164.70,'2021-12-06 15:49:13','',''),(2184485,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 15:49:13','',''),(2184516,'1','143','865',382,'Retail Sale Id 1289619',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 15:50:59','',''),(2184517,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:51:00','',''),(2184544,'1','143','865',382,'Retail Sale Id 1289634',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 15:52:05','',''),(2184545,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:52:05','',''),(2184561,'1','143','865',382,'Retail Sale Id 1289643',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 15:53:21','',''),(2184562,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:53:21','',''),(2184582,'1','143','865',382,'Retail Sale Id 1289653',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 15:54:16','',''),(2184583,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:54:16','',''),(2184616,'1','143','865',382,'Retail Sale Id 1289668',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 15:55:55','',''),(2184617,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:55:55','',''),(2184644,'1','143','865',382,'Retail Sale Id 1289681',2997.92,0.00,0.00,0.00,246.78,'2021-12-06 15:57:35','',''),(2184645,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-06 15:57:35','',''),(2184687,'1','143','865',382,'Retail Sale Id 1289695',4001.60,0.00,0.00,0.00,329.40,'2021-12-06 16:00:08','',''),(2184688,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-06 16:00:08','',''),(2184714,'1','143','865',382,'Retail Sale Id 1289716',2000.80,0.00,0.00,0.00,164.70,'2021-12-06 16:01:24','',''),(2184715,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 16:01:24','',''),(2184777,'1','143','865',382,'Retail Sale Id 1289742',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 16:05:08','',''),(2184778,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:05:08','',''),(2184795,'1','143','865',382,'Retail Sale Id 1289750',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 16:06:06','',''),(2184796,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 16:06:06','',''),(2184830,'1','143','865',382,'Retail Sale Id 1289766',2997.92,0.00,0.00,0.00,246.78,'2021-12-06 16:08:31','',''),(2184831,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-06 16:08:31','',''),(2184841,'1','143','865',382,'Retail Sale Id 1289772',6560.00,0.00,0.00,0.00,540.00,'2021-12-06 16:09:45','',''),(2184842,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 16:09:45','',''),(2184857,'1','143','865',382,'Retail Sale Id 1289779',2000.80,0.00,0.00,0.00,164.70,'2021-12-06 16:10:37','',''),(2184858,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 16:10:37','',''),(2184875,'1','143','865',382,'Retail Sale Id 1289789',4592.00,0.00,0.00,0.00,378.00,'2021-12-06 16:11:56','',''),(2184877,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 16:11:56','',''),(2184897,'1','143','865',382,'Retail Sale Id 1289798',4001.60,0.00,0.00,0.00,329.40,'2021-12-06 16:13:27','',''),(2184898,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-06 16:13:27','',''),(2184912,'1','143','865',382,'Retail Sale Id 1289804',4001.60,0.00,0.00,0.00,329.40,'2021-12-06 16:14:30','',''),(2184913,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-06 16:14:30','',''),(2184940,'1','143','865',382,'Retail Sale Id 1289817',4001.60,0.00,0.00,0.00,329.40,'2021-12-06 16:16:11','',''),(2184941,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-06 16:16:11','',''),(2184980,'1','143','865',382,'Retail Sale Id 1289834',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 16:18:16','',''),(2184981,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:18:16','',''),(2185027,'1','143','865',382,'Retail Sale Id 1289861',4001.60,0.00,0.00,0.00,329.40,'2021-12-06 16:20:37','',''),(2185028,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-06 16:20:37','',''),(2185054,'1','143','865',382,'Retail Sale Id 1289872',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 16:21:43','',''),(2185055,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:21:43','',''),(2185100,'1','143','865',382,'Retail Sale Id 1289895',1502.24,0.00,0.00,0.00,123.66,'2021-12-06 16:23:52','',''),(2185101,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-06 16:23:52','',''),(2185124,'1','143','865',382,'Retail Sale Id 1289907',4592.00,0.00,0.00,0.00,378.00,'2021-12-06 16:25:09','',''),(2185125,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 16:25:09','',''),(2185141,'1','143','865',382,'Retail Sale Id 1289914',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 16:26:23','',''),(2185142,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:26:23','',''),(2185157,'1','143','865',382,'Retail Sale Id 1289923',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 16:27:32','',''),(2185158,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 16:27:32','',''),(2185177,'1','143','865',382,'Retail Sale Id 1289934',13120.00,0.00,0.00,0.00,1080.00,'2021-12-06 16:28:24','',''),(2185178,'1','143','865',382,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-06 16:28:24','',''),(2185222,'1','143','865',382,'Retail Sale Id 1289958',4998.72,0.00,0.00,0.00,411.48,'2021-12-06 16:30:24','',''),(2185223,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-06 16:30:24','',''),(2185248,'1','143','865',382,'Retail Sale Id 1289972',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 16:31:47','',''),(2185249,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:31:47','',''),(2185270,'1','143','865',382,'Retail Sale Id 1289983',6560.00,0.00,0.00,0.00,540.00,'2021-12-06 16:32:46','',''),(2185271,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 16:32:46','',''),(2185297,'1','143','865',382,'Retail Sale Id 1289996',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 16:33:45','',''),(2185298,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:33:45','',''),(2185310,'1','143','865',382,'Retail Sale Id 1290000',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 16:34:45','',''),(2185311,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:34:45','',''),(2185334,'1','143','865',382,'Retail Sale Id 1290012',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 16:36:08','',''),(2185335,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:36:08','',''),(2185360,'1','143','865',382,'Retail Sale Id 1290024',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 16:37:26','',''),(2185361,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:37:26','',''),(2185377,'1','143','865',382,'Retail Sale Id 1290032',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 16:38:21','',''),(2185378,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:38:21','',''),(2185393,'1','143','865',382,'Retail Sale Id 1290039',1640.00,0.00,0.00,0.00,135.00,'2021-12-06 16:39:25','',''),(2185394,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 16:39:25','',''),(2185423,'1','143','865',382,'Retail Sale Id 1290048',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 16:40:25','',''),(2185424,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:40:25','',''),(2185436,'1','143','865',382,'Retail Sale Id 1290055',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 16:41:24','',''),(2185437,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:41:24','',''),(2185450,'1','143','865',382,'Retail Sale Id 1290063',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 16:42:23','',''),(2185451,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:42:23','',''),(2185468,'1','143','865',382,'Retail Sale Id 1290072',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 16:43:45','',''),(2185469,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:43:45','',''),(2185486,'1','143','865',382,'Retail Sale Id 1290081',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 16:45:13','',''),(2185487,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:45:13','',''),(2185513,'1','143','865',382,'Retail Sale Id 1290090',2499.36,0.00,0.00,0.00,205.74,'2021-12-06 16:46:49','',''),(2185514,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-06 16:46:49','',''),(2185545,'1','143','865',382,'Retail Sale Id 1290110',997.12,0.00,0.00,0.00,82.08,'2021-12-06 16:47:49','',''),(2185546,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 16:47:49','',''),(2185593,'1','143','865',382,'Retail Sale Id 1290133',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 16:49:46','',''),(2185594,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:49:46','',''),(2185629,'1','143','865',382,'Retail Sale Id 1290155',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 16:51:37','',''),(2185630,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:51:37','',''),(2185674,'1','143','865',382,'Retail Sale Id 1290175',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 16:53:58','',''),(2185675,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:53:58','',''),(2185752,'1','143','865',382,'Retail Sale Id 1290219',39884.80,0.00,0.00,0.00,3283.20,'2021-12-06 16:59:23','',''),(2185753,'1','143','865',382,'Retail sales',0.00,0.00,0.00,60.80,0.00,'2021-12-06 16:59:23','',''),(2188382,'1','143','865',382,'Retail Sale Id 1291223',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 07:21:09','',''),(2188383,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 07:21:09','',''),(2188414,'1','143','865',382,'Retail Sale Id 1291283',1312.00,0.00,0.00,0.00,108.00,'2021-12-07 07:23:23','',''),(2188415,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 07:23:23','',''),(2188444,'1','143','865',382,'Retail Sale Id 1291299',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 07:24:39','',''),(2188445,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:24:39','',''),(2188486,'1','143','865',382,'Retail Sale Id 1291316',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 07:26:52','',''),(2188487,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 07:26:52','',''),(2188664,'1','143','865',382,'Retail Sale Id 1291409',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 07:34:40','',''),(2188665,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:34:40','',''),(2188702,'1','143','865',382,'Retail Sale Id 1291428',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 07:36:36','',''),(2188703,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:36:36','',''),(2188724,'1','143','865',382,'Retail Sale Id 1291439',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 07:37:37','',''),(2188725,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 07:37:37','',''),(2188748,'1','143','865',382,'Retail Sale Id 1291450',2624.00,0.00,0.00,0.00,216.00,'2021-12-07 07:38:44','',''),(2188749,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 07:38:44','',''),(2188782,'1','143','865',382,'Retail Sale Id 1291468',5576.00,0.00,0.00,0.00,459.00,'2021-12-07 07:40:32','',''),(2188783,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.50,0.00,'2021-12-07 07:40:32','',''),(2188818,'1','143','865',382,'Retail Sale Id 1291484',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 07:42:04','',''),(2188819,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 07:42:04','',''),(2188838,'1','143','865',382,'Retail Sale Id 1291496',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 07:43:20','',''),(2188839,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 07:43:20','',''),(2188864,'1','143','865',382,'Retail Sale Id 1291526',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 07:45:03','',''),(2188865,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 07:45:03','',''),(2188922,'1','143','865',382,'Retail Sale Id 1291568',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 07:48:05','',''),(2188923,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 07:48:05','',''),(2188998,'1','143','865',382,'Retail Sale Id 1291600',98400.00,0.00,0.00,0.00,8100.00,'2021-12-07 07:52:28','',''),(2188999,'1','143','865',382,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-07 07:52:28','',''),(2189025,'1','143','865',382,'Retail Sale Id 1291611',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 07:53:46','',''),(2189026,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:53:46','',''),(2189081,'1','143','865',382,'Retail Sale Id 1291637',997.12,0.00,0.00,0.00,82.08,'2021-12-07 07:56:54','',''),(2189082,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 07:56:54','',''),(2189175,'1','143','865',382,'Retail Sale Id 1291681',997.12,0.00,0.00,0.00,82.08,'2021-12-07 08:02:18','',''),(2189176,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 08:02:18','',''),(2189251,'1','143','865',382,'Retail Sale Id 1291725',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 08:07:16','',''),(2189252,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 08:07:16','',''),(2189287,'1','143','865',382,'Retail Sale Id 1291736',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 08:08:25','',''),(2189288,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 08:08:25','',''),(2189317,'1','143','865',382,'Retail Sale Id 1291743',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 08:09:38','',''),(2189318,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 08:09:38','',''),(2189452,'1','143','865',382,'Retail Sale Id 1291815',15744.00,0.00,0.00,0.00,1296.00,'2021-12-07 08:17:36','',''),(2189455,'1','143','865',382,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-07 08:17:36','',''),(2189475,'1','143','865',382,'Retail Sale Id 1291823',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 08:18:53','',''),(2189476,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:18:53','',''),(2189523,'1','143','865',382,'Retail Sale Id 1291849',7872.00,0.00,0.00,0.00,648.00,'2021-12-07 08:22:03','',''),(2189524,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 08:22:03','',''),(2189591,'1','143','865',382,'Retail Sale Id 1291878',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 08:25:35','',''),(2189592,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:25:35','',''),(2189613,'1','143','865',382,'Retail Sale Id 1291890',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 08:27:22','',''),(2189614,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 08:27:22','',''),(2189635,'1','143','865',382,'Retail Sale Id 1291902',2000.80,0.00,0.00,0.00,164.70,'2021-12-07 08:29:27','',''),(2189636,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 08:29:27','',''),(2189824,'1','143','865',382,'Retail Sale Id 1291971',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 08:37:50','',''),(2189825,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 08:37:50','',''),(2189886,'1','143','865',382,'Retail Sale Id 1291997',12136.00,0.00,0.00,0.00,999.00,'2021-12-07 08:41:49','',''),(2189887,'1','143','865',382,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-07 08:41:49','',''),(2189914,'1','143','865',382,'Retail Sale Id 1292011',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 08:42:59','',''),(2189915,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 08:43:00','',''),(2189938,'1','143','865',382,'Retail Sale Id 1292020',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 08:44:32','',''),(2189939,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:44:32','',''),(2190007,'1','143','865',382,'Retail Sale Id 1292051',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 08:47:19','',''),(2190008,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 08:47:19','',''),(2190059,'1','143','865',382,'Retail Sale Id 1292079',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 08:50:08','',''),(2190060,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 08:50:08','',''),(2190186,'1','143','865',382,'Retail Sale Id 1292134',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 08:56:11','',''),(2190187,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 08:56:11','',''),(2190212,'1','143','865',382,'Retail Sale Id 1292148',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 08:58:40','',''),(2190213,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 08:58:40','',''),(2190224,'1','143','865',382,'Retail Sale Id 1292153',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 08:59:40','',''),(2190225,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 08:59:40','',''),(2190242,'1','143','865',382,'Retail Sale Id 1292162',3398.08,0.00,0.00,0.00,279.72,'2021-12-07 09:01:03','',''),(2190243,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.18,0.00,'2021-12-07 09:01:03','',''),(2190260,'1','143','865',382,'Retail Sale Id 1292173',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 09:02:22','',''),(2190261,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:02:22','',''),(2190325,'1','143','865',382,'Retail Sale Id 1292200',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 09:06:12','',''),(2190326,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 09:06:12','',''),(2190349,'1','143','865',382,'Retail Sale Id 1292211',7216.00,0.00,0.00,0.00,594.00,'2021-12-07 09:07:34','',''),(2190350,'1','143','865',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-07 09:07:34','',''),(2190461,'1','143','865',382,'Retail Sale Id 1292270',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 09:13:08','',''),(2190462,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:13:08','',''),(2190491,'1','143','865',382,'Retail Sale Id 1292289',1312.00,0.00,0.00,0.00,108.00,'2021-12-07 09:14:51','',''),(2190492,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 09:14:52','',''),(2190521,'1','143','865',382,'Retail Sale Id 1292305',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 09:16:39','',''),(2190522,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:16:39','',''),(2190555,'1','143','865',382,'Retail Sale Id 1292321',6560.00,0.00,0.00,0.00,540.00,'2021-12-07 09:18:09','',''),(2190556,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 09:18:09','',''),(2190589,'1','143','865',382,'Retail Sale Id 1292337',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 09:20:13','',''),(2190590,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:20:13','',''),(2190653,'1','143','865',382,'Retail Sale Id 1292364',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 09:23:42','',''),(2190654,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 09:23:42','',''),(2190675,'1','143','865',382,'Retail Sale Id 1292375',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 09:24:43','',''),(2190676,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 09:24:43','',''),(2190704,'1','143','865',382,'Retail Sale Id 1292391',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 09:26:33','',''),(2190705,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 09:26:33','',''),(2190729,'1','143','865',382,'Retail Sale Id 1292398',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 09:27:22','',''),(2190730,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 09:27:22','',''),(2190780,'1','143','865',382,'Retail Sale Id 1292415',5904.00,0.00,0.00,0.00,486.00,'2021-12-07 09:29:12','',''),(2190781,'1','143','865',382,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-07 09:29:12','',''),(2190810,'1','143','865',382,'Retail Sale Id 1292435',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 09:30:16','',''),(2190811,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 09:30:16','',''),(2190830,'1','143','865',382,'Retail Sale Id 1292444',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 09:31:44','',''),(2190831,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 09:31:44','',''),(2190938,'1','143','865',382,'Retail Sale Id 1292498',2624.00,0.00,0.00,0.00,216.00,'2021-12-07 09:36:52','',''),(2190939,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 09:36:52','',''),(2191002,'1','143','865',382,'Retail Sale Id 1292534',1640.00,0.00,0.00,0.00,135.00,'2021-12-07 09:40:38','',''),(2191003,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 09:40:38','',''),(2191048,'1','143','865',382,'Retail Sale Id 1292557',4592.00,0.00,0.00,0.00,378.00,'2021-12-07 09:43:24','',''),(2191049,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 09:43:24','',''),(2191082,'1','143','865',382,'Retail Sale Id 1292576',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 09:45:45','',''),(2191083,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:45:45','',''),(2191102,'1','143','865',382,'Retail Sale Id 1292586',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 09:48:25','',''),(2191103,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 09:48:25','',''),(2191126,'1','143','865',382,'Retail Sale Id 1292600',4998.72,0.00,0.00,0.00,411.48,'2021-12-07 09:50:10','',''),(2191127,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-07 09:50:10','',''),(2191170,'1','143','865',382,'Retail Sale Id 1292623',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 09:52:43','',''),(2191171,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:52:43','',''),(2191190,'1','143','865',382,'Retail Sale Id 1292630',5248.00,0.00,0.00,0.00,432.00,'2021-12-07 09:54:05','',''),(2191191,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-07 09:54:05','',''),(2191204,'1','143','865',382,'Retail Sale Id 1292645',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 09:55:17','',''),(2191205,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:55:17','',''),(2191283,'1','143','865',382,'Retail Sale Id 1292681',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 10:00:56','',''),(2191284,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:00:56','',''),(2191317,'1','143','865',382,'Retail Sale Id 1292704',997.12,0.00,0.00,0.00,82.08,'2021-12-07 10:03:02','',''),(2191318,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 10:03:02','',''),(2191337,'1','143','865',382,'Retail Sale Id 1292710',4998.72,0.00,0.00,0.00,411.48,'2021-12-07 10:04:18','',''),(2191338,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-07 10:04:18','',''),(2191355,'1','143','865',382,'Retail Sale Id 1292720',3503.04,0.00,0.00,0.00,288.36,'2021-12-07 10:05:30','',''),(2191356,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-07 10:05:30','',''),(2191531,'1','143','865',382,'Retail Sale Id 1292814',26240.00,0.00,0.00,0.00,2160.00,'2021-12-07 10:16:41','',''),(2191532,'1','143','865',382,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-07 10:16:41','',''),(2191569,'1','143','865',382,'Retail Sale Id 1292832',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 10:19:44','',''),(2191570,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:19:44','',''),(2191591,'1','143','865',382,'Retail Sale Id 1292842',25000.16,0.00,0.00,0.00,2057.94,'2021-12-07 10:21:11','',''),(2191592,'1','143','865',382,'Retail sales',0.00,0.00,0.00,38.11,0.00,'2021-12-07 10:21:11','',''),(2191623,'1','143','865',382,'Retail Sale Id 1292860',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 10:23:45','',''),(2191624,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:23:45','',''),(2191678,'1','143','865',382,'Retail Sale Id 1292884',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 10:27:55','',''),(2191679,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:27:55','',''),(2191690,'1','143','865',382,'Retail Sale Id 1292891',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 10:29:22','',''),(2191691,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:29:22','',''),(2191735,'1','143','865',382,'Retail Sale Id 1292913',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 10:33:45','',''),(2191736,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:33:45','',''),(2191861,'1','143','865',382,'Retail Sale Id 1292979',2000.80,0.00,0.00,0.00,164.70,'2021-12-07 10:41:22','',''),(2191862,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 10:41:22','',''),(2191881,'1','143','865',382,'Retail Sale Id 1292991',997.12,0.00,0.00,0.00,82.08,'2021-12-07 10:42:39','',''),(2191882,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 10:42:39','',''),(2191905,'1','143','865',382,'Retail Sale Id 1293003',1312.00,0.00,0.00,0.00,108.00,'2021-12-07 10:44:17','',''),(2191906,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 10:44:17','',''),(2191996,'1','143','865',382,'Retail Sale Id 1293036',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 10:48:02','',''),(2191997,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:48:02','',''),(2192042,'1','143','865',382,'Retail Sale Id 1293062',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 10:50:23','',''),(2192043,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:50:23','',''),(2192290,'1','143','865',382,'Retail Sale Id 1293170',2000.80,0.00,0.00,0.00,164.70,'2021-12-07 11:02:51','',''),(2192291,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 11:02:51','',''),(2192426,'1','143','866',382,'Retail Sale Id 1293237',1312.00,0.00,0.00,0.00,108.00,'2021-12-07 11:09:43','',''),(2192427,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 11:09:43','',''),(2192520,'1','143','865',382,'Retail Sale Id 1293296',4001.60,0.00,0.00,0.00,329.40,'2021-12-07 11:15:17','',''),(2192521,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-07 11:15:17','',''),(2192572,'1','143','865',382,'Retail Sale Id 1293323',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 11:18:47','',''),(2192573,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 11:18:47','',''),(2192596,'1','143','865',382,'Retail Sale Id 1293347',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 11:20:32','',''),(2192597,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 11:20:32','',''),(2192608,'1','143','865',382,'Retail Sale Id 1293358',2000.80,0.00,0.00,0.00,164.70,'2021-12-07 11:21:40','',''),(2192609,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 11:21:40','',''),(2192670,'1','143','865',382,'Retail Sale Id 1293399',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 11:26:40','',''),(2192671,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 11:26:40','',''),(2192724,'1','143','865',382,'Retail Sale Id 1293428',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 11:30:07','',''),(2192725,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:30:07','',''),(2192753,'1','143','865',382,'Retail Sale Id 1293438',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 11:31:34','',''),(2192754,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 11:31:34','',''),(2192765,'1','143','865',382,'Retail Sale Id 1293443',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 11:32:56','',''),(2192766,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:32:56','',''),(2192851,'1','143','865',382,'Retail Sale Id 1293490',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 11:39:49','',''),(2192852,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 11:39:49','',''),(2192875,'1','143','865',382,'Retail Sale Id 1293503',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 11:41:20','',''),(2192876,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:41:20','',''),(2192897,'1','143','865',382,'Retail Sale Id 1293516',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 11:42:36','',''),(2192898,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 11:42:36','',''),(2192953,'1','143','865',382,'Retail Sale Id 1293530',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 11:44:45','',''),(2192954,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 11:44:45','',''),(2192977,'1','143','865',382,'Retail Sale Id 1293542',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 11:46:30','',''),(2192978,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 11:46:30','',''),(2193177,'1','143','865',382,'Retail Sale Id 1293655',2000.80,0.00,0.00,0.00,164.70,'2021-12-07 12:05:53','',''),(2193178,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 12:05:53','',''),(2193259,'1','143','865',382,'Retail Sale Id 1293697',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 12:12:44','',''),(2193260,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 12:12:44','',''),(2193275,'1','143','865',382,'Retail Sale Id 1293707',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 12:13:47','',''),(2193276,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:13:47','',''),(2193285,'1','143','865',382,'Retail Sale Id 1293714',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 12:14:57','',''),(2193286,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:14:57','',''),(2193499,'1','143','865',382,'Retail Sale Id 1293827',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 12:34:16','',''),(2193500,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 12:34:16','',''),(2193579,'1','143','865',382,'Retail Sale Id 1293874',997.12,0.00,0.00,0.00,82.08,'2021-12-07 12:40:38','',''),(2193580,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 12:40:38','',''),(2193640,'1','143','865',382,'Retail Sale Id 1293904',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 12:46:20','',''),(2193641,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 12:46:20','',''),(2193666,'1','143','865',382,'Retail Sale Id 1293933',9840.00,0.00,0.00,0.00,810.00,'2021-12-07 12:47:45','',''),(2193667,'1','143','865',382,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-07 12:47:45','',''),(2193806,'1','143','865',382,'Retail Sale Id 1294001',5202.08,0.00,0.00,0.00,428.22,'2021-12-07 12:57:00','',''),(2193807,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.93,0.00,'2021-12-07 12:57:00','',''),(2193853,'1','143','865',382,'Retail Sale Id 1294031',2997.92,0.00,0.00,0.00,246.78,'2021-12-07 12:59:15','',''),(2193854,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 12:59:15','',''),(2193946,'1','143','865',382,'Retail Sale Id 1294069',2997.92,0.00,0.00,0.00,246.78,'2021-12-07 13:05:14','',''),(2193947,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 13:05:14','',''),(2193974,'1','143','865',382,'Retail Sale Id 1294082',1298.88,0.00,0.00,0.00,106.92,'2021-12-07 13:07:23','',''),(2193975,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.98,0.00,'2021-12-07 13:07:23','',''),(2194053,'1','143','865',382,'Retail Sale Id 1294118',1902.40,0.00,0.00,0.00,156.60,'2021-12-07 13:12:31','',''),(2194054,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-07 13:12:31','',''),(2194107,'1','143','865',382,'Retail Sale Id 1294154',8003.20,0.00,0.00,0.00,658.80,'2021-12-07 13:16:10','',''),(2194108,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-07 13:16:10','',''),(2194137,'1','143','865',382,'Retail Sale Id 1294169',1312.00,0.00,0.00,0.00,108.00,'2021-12-07 13:18:03','',''),(2194138,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 13:18:03','',''),(2194161,'1','143','865',382,'Retail Sale Id 1294179',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 13:19:22','',''),(2194162,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 13:19:22','',''),(2194180,'1','143','865',382,'Retail Sale Id 1294188',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 13:20:31','',''),(2194181,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 13:20:31','',''),(2194221,'1','143','865',382,'Retail Sale Id 1294270',2000.80,0.00,0.00,0.00,164.70,'2021-12-07 13:24:20','',''),(2194222,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 13:24:20','',''),(2194274,'1','143','865',382,'Retail Sale Id 1294289',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 13:25:46','',''),(2194275,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 13:25:46','',''),(2194321,'1','143','865',382,'Retail Sale Id 1294335',2000.80,0.00,0.00,0.00,164.70,'2021-12-07 13:27:53','',''),(2194322,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 13:27:53','',''),(2194359,'1','143','865',382,'Retail Sale Id 1294348',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 13:29:27','',''),(2194360,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:29:27','',''),(2194410,'1','143','865',382,'Retail Sale Id 1294364',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 13:31:58','',''),(2194411,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:31:58','',''),(2194514,'1','143','865',382,'Retail Sale Id 1294403',6560.00,0.00,0.00,0.00,540.00,'2021-12-07 13:37:38','',''),(2194515,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 13:37:38','',''),(2194817,'1','143','865',382,'Retail Sale Id 1294544',41000.00,0.00,0.00,0.00,3375.00,'2021-12-07 13:56:40','',''),(2194818,'1','143','865',382,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-07 13:56:40','',''),(2194917,'1','143','865',382,'Retail Sale Id 1294594',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 14:03:27','',''),(2194918,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:03:27','',''),(2194935,'1','143','865',382,'Retail Sale Id 1294605',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 14:04:40','',''),(2194936,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 14:04:40','',''),(2194943,'1','143','865',382,'Retail Sale Id 1294608',6560.00,0.00,0.00,0.00,540.00,'2021-12-07 14:05:37','',''),(2194944,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 14:05:37','',''),(2194965,'1','143','865',382,'Retail Sale Id 1294621',1298.88,0.00,0.00,0.00,106.92,'2021-12-07 14:07:09','',''),(2194966,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.98,0.00,'2021-12-07 14:07:09','',''),(2194997,'1','143','865',382,'Retail Sale Id 1294639',5248.00,0.00,0.00,0.00,432.00,'2021-12-07 14:08:55','',''),(2194998,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-07 14:08:55','',''),(2195033,'1','143','865',382,'Retail Sale Id 1294653',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 14:10:18','',''),(2195034,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 14:10:18','',''),(2195065,'1','143','865',382,'Retail Sale Id 1294663',5248.00,0.00,0.00,0.00,432.00,'2021-12-07 14:11:36','',''),(2195066,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-07 14:11:36','',''),(2195083,'1','143','865',382,'Retail Sale Id 1294669',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 14:12:27','',''),(2195084,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 14:12:27','',''),(2195105,'1','143','865',382,'Retail Sale Id 1294676',1312.00,0.00,0.00,0.00,108.00,'2021-12-07 14:13:19','',''),(2195106,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 14:13:19','',''),(2195258,'1','143','865',382,'Retail Sale Id 1294731',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 14:21:58','',''),(2195259,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:21:58','',''),(2195304,'1','143','865',382,'Retail Sale Id 1294758',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 14:24:12','',''),(2195305,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 14:24:12','',''),(2195334,'1','143','865',382,'Retail Sale Id 1294772',12136.00,0.00,0.00,0.00,999.00,'2021-12-07 14:25:40','',''),(2195335,'1','143','865',382,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-07 14:25:40','',''),(2195364,'1','143','865',382,'Retail Sale Id 1294787',997.12,0.00,0.00,0.00,82.08,'2021-12-07 14:27:03','',''),(2195365,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 14:27:03','',''),(2195388,'1','143','865',382,'Retail Sale Id 1294799',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 14:28:18','',''),(2195389,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:28:18','',''),(2195499,'1','143','865',382,'Retail Sale Id 1294854',2624.00,0.00,0.00,0.00,216.00,'2021-12-07 14:35:05','',''),(2195500,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 14:35:05','',''),(2195613,'1','143','865',382,'Retail Sale Id 1294915',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 14:41:50','',''),(2195614,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 14:41:50','',''),(2195732,'1','143','865',382,'Retail Sale Id 1294979',2997.92,0.00,0.00,0.00,246.78,'2021-12-07 14:47:38','',''),(2195733,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 14:47:38','',''),(2195770,'1','143','865',382,'Retail Sale Id 1295000',37800.00,0.00,0.00,0.00,1680.00,'2021-12-07 14:49:37','',''),(2195771,'1','143','865',382,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-07 14:49:37','',''),(2195814,'1','143','865',382,'Retail Sale Id 1295024',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 14:51:11','',''),(2195815,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 14:51:11','',''),(2195874,'1','143','865',382,'Retail Sale Id 1295059',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 14:54:30','',''),(2195875,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:54:30','',''),(2195940,'1','143','865',382,'Retail Sale Id 1295091',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 14:59:04','',''),(2195941,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:59:04','',''),(2195964,'1','143','865',382,'Retail Sale Id 1295103',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 15:00:49','',''),(2195965,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:00:49','',''),(2196036,'1','143','865',382,'Retail Sale Id 1295131',12136.00,0.00,0.00,0.00,999.00,'2021-12-07 15:04:24','',''),(2196037,'1','143','865',382,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-07 15:04:24','',''),(2196072,'1','143','865',382,'Retail Sale Id 1295147',1312.00,0.00,0.00,0.00,108.00,'2021-12-07 15:06:58','',''),(2196073,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 15:06:58','',''),(2196102,'1','143','865',382,'Retail Sale Id 1295163',10168.00,0.00,0.00,0.00,837.00,'2021-12-07 15:08:41','',''),(2196103,'1','143','865',382,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-07 15:08:41','',''),(2196130,'1','143','865',382,'Retail Sale Id 1295177',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 15:09:43','',''),(2196131,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:09:43','',''),(2196202,'1','143','865',382,'Retail Sale Id 1295215',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 15:13:18','',''),(2196203,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:13:18','',''),(2196552,'1','143','865',382,'Retail Sale Id 1295394',2997.92,0.00,0.00,0.00,246.78,'2021-12-07 15:31:05','',''),(2196553,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 15:31:05','',''),(2196588,'1','143','865',382,'Retail Sale Id 1295411',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 15:32:55','',''),(2196589,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:32:55','',''),(2196656,'1','143','865',382,'Retail Sale Id 1295447',94500.00,0.00,0.00,0.00,4200.00,'2021-12-07 15:36:39','',''),(2196657,'1','143','865',382,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-07 15:36:39','',''),(2196691,'1','143','865',382,'Retail Sale Id 1295459',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 15:38:02','',''),(2196692,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:38:02','',''),(2196777,'1','143','865',382,'Retail Sale Id 1295500',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 15:41:20','',''),(2196778,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:41:20','',''),(2196801,'1','143','865',382,'Retail Sale Id 1295512',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 15:42:57','',''),(2196802,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:42:57','',''),(2196833,'1','143','865',382,'Retail Sale Id 1295527',1312.00,0.00,0.00,0.00,108.00,'2021-12-07 15:44:19','',''),(2196834,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 15:44:19','',''),(2196849,'1','143','865',382,'Retail Sale Id 1295536',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 15:45:17','',''),(2196850,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:45:17','',''),(2196885,'1','143','865',382,'Retail Sale Id 1295548',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 15:46:23','',''),(2196886,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:46:23','',''),(2196903,'1','143','865',382,'Retail Sale Id 1295563',2000.80,0.00,0.00,0.00,164.70,'2021-12-07 15:47:21','',''),(2196904,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 15:47:21','',''),(2197024,'1','143','865',382,'Retail Sale Id 1295627',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 15:53:08','',''),(2197025,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:53:08','',''),(2197048,'1','143','865',382,'Retail Sale Id 1295640',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 15:54:16','',''),(2197049,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:54:16','',''),(2197080,'1','143','865',382,'Retail Sale Id 1295657',7216.00,0.00,0.00,0.00,594.00,'2021-12-07 15:56:04','',''),(2197081,'1','143','865',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-07 15:56:04','',''),(2197109,'1','143','865',382,'Retail Sale Id 1295671',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 15:57:14','',''),(2197110,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:57:14','',''),(2197131,'1','143','865',382,'Retail Sale Id 1295680',7216.00,0.00,0.00,0.00,594.00,'2021-12-07 15:58:15','',''),(2197132,'1','143','865',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-07 15:58:15','',''),(2197162,'1','143','865',382,'Retail Sale Id 1295697',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 16:00:07','',''),(2197163,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:00:07','',''),(2197197,'1','143','865',382,'Retail Sale Id 1295717',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 16:01:31','',''),(2197198,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:01:31','',''),(2197215,'1','143','865',382,'Retail Sale Id 1295729',2000.80,0.00,0.00,0.00,164.70,'2021-12-07 16:02:27','',''),(2197216,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 16:02:27','',''),(2197320,'1','143','865',382,'Retail Sale Id 1295781',4998.72,0.00,0.00,0.00,411.48,'2021-12-07 16:07:24','',''),(2197321,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-07 16:07:24','',''),(2197354,'1','143','865',382,'Retail Sale Id 1295794',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 16:08:47','',''),(2197355,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 16:08:47','',''),(2197368,'1','143','865',382,'Retail Sale Id 1295801',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 16:09:55','',''),(2197369,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 16:09:55','',''),(2197398,'1','143','865',382,'Retail Sale Id 1295819',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 16:11:45','',''),(2197399,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:11:45','',''),(2197426,'1','143','865',382,'Retail Sale Id 1295834',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 16:12:57','',''),(2197427,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:12:57','',''),(2197542,'1','143','865',382,'Retail Sale Id 1295901',5248.00,0.00,0.00,0.00,432.00,'2021-12-07 16:18:08','',''),(2197543,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-07 16:18:08','',''),(2197578,'1','143','865',382,'Retail Sale Id 1295920',1502.24,0.00,0.00,0.00,123.66,'2021-12-07 16:19:21','',''),(2197579,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-07 16:19:21','',''),(2197603,'1','143','865',382,'Retail Sale Id 1295933',1312.00,0.00,0.00,0.00,108.00,'2021-12-07 16:20:26','',''),(2197604,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 16:20:26','',''),(2197631,'1','143','865',382,'Retail Sale Id 1295947',8003.20,0.00,0.00,0.00,658.80,'2021-12-07 16:21:26','',''),(2197632,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-07 16:21:26','',''),(2197691,'1','143','865',382,'Retail Sale Id 1295979',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 16:24:56','',''),(2197692,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:24:56','',''),(2197741,'1','143','865',382,'Retail Sale Id 1296003',4592.00,0.00,0.00,0.00,378.00,'2021-12-07 16:27:22','',''),(2197742,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 16:27:22','',''),(2197771,'1','143','865',382,'Retail Sale Id 1296020',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 16:28:33','',''),(2197772,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:28:33','',''),(2197791,'1','143','865',382,'Retail Sale Id 1296031',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 16:29:34','',''),(2197792,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:29:34','',''),(2197821,'1','143','865',382,'Retail Sale Id 1296044',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 16:30:48','',''),(2197822,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:30:48','',''),(2197850,'1','143','865',382,'Retail Sale Id 1296060',1298.88,0.00,0.00,0.00,106.92,'2021-12-07 16:32:04','',''),(2197851,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.98,0.00,'2021-12-07 16:32:04','',''),(2197873,'1','143','865',382,'Retail Sale Id 1296070',1312.00,0.00,0.00,0.00,108.00,'2021-12-07 16:33:43','',''),(2197874,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 16:33:43','',''),(2197895,'1','143','865',382,'Retail Sale Id 1296085',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 16:34:30','',''),(2197896,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:34:30','',''),(2197912,'1','143','865',382,'Retail Sale Id 1296093',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 16:35:37','',''),(2197913,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:35:37','',''),(2197944,'1','143','865',382,'Retail Sale Id 1296110',207900.00,0.00,0.00,0.00,9240.00,'2021-12-07 16:37:54','',''),(2197945,'1','143','865',382,'Retail sales',0.00,0.00,0.00,330.00,0.00,'2021-12-07 16:37:54','',''),(2197956,'1','143','865',382,'Retail Sale Id 1296119',1312.00,0.00,0.00,0.00,108.00,'2021-12-07 16:38:43','',''),(2197957,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 16:38:43','',''),(2197974,'1','143','865',382,'Retail Sale Id 1296131',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 16:39:48','',''),(2197975,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:39:48','',''),(2198018,'1','143','865',382,'Retail Sale Id 1296150',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 16:42:58','',''),(2198019,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:42:58','',''),(2198045,'1','143','865',382,'Retail Sale Id 1296169',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 16:44:34','',''),(2198046,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:44:34','',''),(2198077,'1','143','865',382,'Retail Sale Id 1296184',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 16:46:12','',''),(2198078,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 16:46:12','',''),(2198094,'1','143','865',382,'Retail Sale Id 1296192',997.12,0.00,0.00,0.00,82.08,'2021-12-07 16:47:38','',''),(2198095,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 16:47:38','',''),(2198120,'1','143','865',382,'Retail Sale Id 1296205',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 16:48:56','',''),(2198121,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:48:56','',''),(2198141,'1','143','865',382,'Retail Sale Id 1296215',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 16:50:13','',''),(2198142,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:50:13','',''),(2198156,'1','143','865',382,'Retail Sale Id 1296223',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 16:51:17','',''),(2198157,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:51:17','',''),(2198186,'1','143','865',382,'Retail Sale Id 1296237',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 16:52:59','',''),(2198187,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:52:59','',''),(2198234,'1','143','865',382,'Retail Sale Id 1296262',16400.00,0.00,0.00,0.00,1350.00,'2021-12-07 16:54:57','',''),(2198235,'1','143','865',382,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 16:54:57','',''),(2198256,'1','143','865',382,'Retail Sale Id 1296273',2997.92,0.00,0.00,0.00,246.78,'2021-12-07 16:56:02','',''),(2198257,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 16:56:02','',''),(2198294,'1','143','865',382,'Retail Sale Id 1296295',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 16:57:49','',''),(2198295,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 16:57:49','',''),(2198318,'1','143','865',382,'Retail Sale Id 1296305',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 16:58:48','',''),(2198319,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:58:48','',''),(2198351,'1','143','865',382,'Retail Sale Id 1296325',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 17:01:05','',''),(2198352,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 17:01:05','',''),(2200729,'1','143','865',382,'Retail Sale Id 1297213',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 07:18:27','',''),(2200730,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:18:27','',''),(2200856,'1','143','865',382,'Retail Sale Id 1297271',3280.00,0.00,0.00,0.00,270.00,'2021-12-08 07:24:24','',''),(2200857,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 07:24:24','',''),(2200961,'1','143','865',382,'Retail Sale Id 1297317',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 07:30:20','',''),(2200962,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 07:30:21','',''),(2201047,'1','143','865',382,'Retail Sale Id 1297353',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 07:34:33','',''),(2201048,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:34:33','',''),(2201162,'1','143','865',382,'Retail Sale Id 1297407',13120.00,0.00,0.00,0.00,1080.00,'2021-12-08 07:40:33','',''),(2201163,'1','143','865',382,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-08 07:40:33','',''),(2201264,'1','143','865',382,'Retail Sale Id 1297458',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 07:47:27','',''),(2201265,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:47:27','',''),(2201385,'1','143','865',382,'Retail Sale Id 1297519',4998.72,0.00,0.00,0.00,411.48,'2021-12-08 07:53:03','',''),(2201386,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-08 07:53:03','',''),(2201786,'1','143','865',382,'Retail Sale Id 1297693',2997.92,0.00,0.00,0.00,246.78,'2021-12-08 08:15:06','',''),(2201787,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-08 08:15:06','',''),(2201825,'1','143','865',382,'Retail Sale Id 1297721',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 08:17:16','',''),(2201826,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 08:17:16','',''),(2201853,'1','143','865',382,'Retail Sale Id 1297733',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 08:19:09','',''),(2201854,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 08:19:09','',''),(2201881,'1','143','865',382,'Retail Sale Id 1297750',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 08:21:16','',''),(2201882,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:21:16','',''),(2201969,'1','143','865',382,'Retail Sale Id 1297794',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 08:26:34','',''),(2201970,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 08:26:34','',''),(2202062,'1','143','865',382,'Retail Sale Id 1297833',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 08:32:13','',''),(2202063,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 08:32:13','',''),(2202082,'1','143','865',382,'Retail Sale Id 1297840',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 08:33:57','',''),(2202083,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:33:57','',''),(2202096,'1','143','865',382,'Retail Sale Id 1297854',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 08:35:06','',''),(2202097,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 08:35:06','',''),(2202168,'1','143','865',382,'Retail Sale Id 1297882',2000.80,0.00,0.00,0.00,164.70,'2021-12-08 08:39:01','',''),(2202169,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 08:39:01','',''),(2202190,'1','143','865',382,'Retail Sale Id 1297896',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 08:40:12','',''),(2202191,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 08:40:12','',''),(2202275,'1','143','865',382,'Retail Sale Id 1297917',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 08:42:54','',''),(2202276,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 08:42:54','',''),(2202362,'1','143','865',382,'Retail Sale Id 1297942',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 08:46:37','',''),(2202363,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:46:37','',''),(2202388,'1','143','865',382,'Retail Sale Id 1297954',16400.00,0.00,0.00,0.00,1350.00,'2021-12-08 08:47:33','',''),(2202389,'1','143','865',382,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 08:47:33','',''),(2202518,'1','143','865',382,'Retail Sale Id 1298001',1312.00,0.00,0.00,0.00,108.00,'2021-12-08 08:53:51','',''),(2202519,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 08:53:51','',''),(2202538,'1','143','865',382,'Retail Sale Id 1298011',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 08:54:54','',''),(2202539,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:54:54','',''),(2202582,'1','143','865',382,'Retail Sale Id 1298027',2997.92,0.00,0.00,0.00,246.78,'2021-12-08 08:56:43','',''),(2202583,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-08 08:56:43','',''),(2202608,'1','143','865',382,'Retail Sale Id 1298037',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 08:58:25','',''),(2202609,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 08:58:25','',''),(2202626,'1','143','865',382,'Retail Sale Id 1298050',2997.92,0.00,0.00,0.00,246.78,'2021-12-08 09:00:15','',''),(2202627,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-08 09:00:15','',''),(2202672,'1','143','865',382,'Retail Sale Id 1298068',1640.00,0.00,0.00,0.00,135.00,'2021-12-08 09:03:07','',''),(2202673,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-08 09:03:07','',''),(2202720,'1','143','865',382,'Retail Sale Id 1298083',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 09:05:35','',''),(2202721,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 09:05:35','',''),(2202797,'1','143','865',382,'Retail Sale Id 1298145',3280.00,0.00,0.00,0.00,270.00,'2021-12-08 09:10:30','',''),(2202798,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 09:10:30','',''),(2202858,'1','143','865',382,'Retail Sale Id 1298169',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 09:13:26','',''),(2202859,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 09:13:26','',''),(2202918,'1','143','865',382,'Retail Sale Id 1298185',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 09:16:51','',''),(2202919,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 09:16:52','',''),(2202946,'1','143','865',382,'Retail Sale Id 1298209',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 09:18:47','',''),(2202947,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 09:18:47','',''),(2204804,'1','143','865',382,'Retail Sale Id 1299118',12136.00,0.00,0.00,0.00,999.00,'2021-12-08 11:34:36','',''),(2204805,'1','143','865',382,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-08 11:34:36','',''),(2204826,'1','143','865',382,'Retail Sale Id 1299126',4100.00,0.00,0.00,0.00,337.50,'2021-12-08 11:35:38','',''),(2204827,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 11:35:38','',''),(2204850,'1','143','865',382,'Retail Sale Id 1299139',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 11:36:55','',''),(2204851,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:36:55','',''),(2204883,'1','143','865',382,'Retail Sale Id 1299159',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 11:38:47','',''),(2204885,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:38:47','',''),(2204918,'1','143','865',382,'Retail Sale Id 1299175',3280.00,0.00,0.00,0.00,270.00,'2021-12-08 11:40:12','',''),(2204919,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 11:40:12','',''),(2204936,'1','143','865',382,'Retail Sale Id 1299187',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 11:41:11','',''),(2204937,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:41:11','',''),(2204958,'1','143','865',382,'Retail Sale Id 1299197',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 11:42:25','',''),(2204959,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:42:25','',''),(2204988,'1','143','865',382,'Retail Sale Id 1299212',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 11:43:50','',''),(2204989,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:43:50','',''),(2205006,'1','143','865',382,'Retail Sale Id 1299217',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 11:44:57','',''),(2205007,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:44:57','',''),(2205022,'1','143','865',382,'Retail Sale Id 1299230',1312.00,0.00,0.00,0.00,108.00,'2021-12-08 11:46:26','',''),(2205023,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 11:46:26','',''),(2205094,'1','143','865',382,'Retail Sale Id 1299258',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 11:52:40','',''),(2205095,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:52:40','',''),(2205166,'1','143','865',382,'Retail Sale Id 1299297',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 11:58:18','',''),(2205167,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:58:18','',''),(2205210,'1','143','865',382,'Retail Sale Id 1299321',656.00,0.00,0.00,0.00,54.00,'2021-12-08 12:01:14','',''),(2205211,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 12:01:14','',''),(2205228,'1','143','865',382,'Retail Sale Id 1299329',1312.00,0.00,0.00,0.00,108.00,'2021-12-08 12:02:30','',''),(2205229,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 12:02:30','',''),(2205375,'1','143','865',382,'Retail Sale Id 1299384',1502.24,0.00,0.00,0.00,123.66,'2021-12-08 12:13:05','',''),(2205376,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-08 12:13:05','',''),(2205393,'1','143','865',382,'Retail Sale Id 1299393',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 12:15:08','',''),(2205394,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:15:08','',''),(2205409,'1','143','865',382,'Retail Sale Id 1299401',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 12:16:33','',''),(2205410,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:16:33','',''),(2205429,'1','143','865',382,'Retail Sale Id 1299409',2624.00,0.00,0.00,0.00,216.00,'2021-12-08 12:17:39','',''),(2205430,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 12:17:39','',''),(2205447,'1','143','865',382,'Retail Sale Id 1299416',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 12:18:56','',''),(2205448,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 12:18:56','',''),(2205536,'1','143','865',382,'Retail Sale Id 1299464',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 12:26:24','',''),(2205537,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 12:26:24','',''),(2205544,'1','143','865',382,'Retail Sale Id 1299467',3280.00,0.00,0.00,0.00,270.00,'2021-12-08 12:27:31','',''),(2205545,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 12:27:31','',''),(2205578,'1','143','865',382,'Retail Sale Id 1299486',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 12:30:20','',''),(2205579,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 12:30:20','',''),(2205604,'1','143','865',382,'Retail Sale Id 1299495',5904.00,0.00,0.00,0.00,486.00,'2021-12-08 12:32:33','',''),(2205605,'1','143','865',382,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-08 12:32:33','',''),(2205715,'1','143','865',382,'Retail Sale Id 1299547',3280.00,0.00,0.00,0.00,270.00,'2021-12-08 12:39:50','',''),(2205716,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 12:39:50','',''),(2205746,'1','143','865',382,'Retail Sale Id 1299563',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 12:41:45','',''),(2205747,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 12:41:45','',''),(2205760,'1','143','865',382,'Retail Sale Id 1299569',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 12:42:47','',''),(2205761,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 12:42:47','',''),(2205860,'1','143','865',382,'Retail Sale Id 1299611',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 12:48:34','',''),(2205861,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 12:48:34','',''),(2205903,'1','143','865',382,'Retail Sale Id 1299624',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 12:49:45','',''),(2205904,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 12:49:45','',''),(2205951,'1','143','865',382,'Retail Sale Id 1299642',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 12:52:09','',''),(2205952,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 12:52:09','',''),(2205958,'1','143','865',382,'Retail Sale Id 1299647',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 12:53:04','',''),(2205959,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 12:53:04','',''),(2206009,'1','143','865',382,'Retail Sale Id 1299670',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 12:57:25','',''),(2206010,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 12:57:25','',''),(2206076,'1','143','865',382,'Retail Sale Id 1299697',7216.00,0.00,0.00,0.00,594.00,'2021-12-08 13:02:44','',''),(2206077,'1','143','865',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-08 13:02:44','',''),(2206122,'1','143','865',382,'Retail Sale Id 1299721',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 13:06:01','',''),(2206123,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:06:01','',''),(2206166,'1','143','865',382,'Retail Sale Id 1299744',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 13:09:29','',''),(2206167,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 13:09:29','',''),(2206187,'1','143','865',382,'Retail Sale Id 1299752',6002.40,0.00,0.00,0.00,494.10,'2021-12-08 13:10:27','',''),(2206188,'1','143','865',382,'Retail sales',0.00,0.00,0.00,9.15,0.00,'2021-12-08 13:10:27','',''),(2206239,'1','143','865',382,'Retail Sale Id 1299777',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 13:13:59','',''),(2206240,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:13:59','',''),(2206381,'1','143','865',382,'Retail Sale Id 1299848',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 13:23:53','',''),(2206382,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:23:53','',''),(2206409,'1','143','865',382,'Retail Sale Id 1299861',2499.36,0.00,0.00,0.00,205.74,'2021-12-08 13:25:52','',''),(2206410,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-08 13:25:52','',''),(2206550,'1','143','865',382,'Retail Sale Id 1299909',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 13:32:45','',''),(2206551,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:32:45','',''),(2206572,'1','143','865',382,'Retail Sale Id 1299922',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 13:34:18','',''),(2206573,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:34:18','',''),(2206580,'1','143','865',382,'Retail Sale Id 1299927',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 13:35:16','',''),(2206581,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 13:35:16','',''),(2206610,'1','143','865',382,'Retail Sale Id 1299944',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 13:37:38','',''),(2206611,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:37:38','',''),(2206645,'1','143','865',382,'Retail Sale Id 1299954',2624.00,0.00,0.00,0.00,216.00,'2021-12-08 13:39:01','',''),(2206646,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 13:39:01','',''),(2206666,'1','143','865',382,'Retail Sale Id 1299966',3280.00,0.00,0.00,0.00,270.00,'2021-12-08 13:40:36','',''),(2206667,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 13:40:36','',''),(2206716,'1','143','865',382,'Retail Sale Id 1299982',2624.00,0.00,0.00,0.00,216.00,'2021-12-08 13:42:35','',''),(2206717,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 13:42:35','',''),(2206816,'1','143','865',382,'Retail Sale Id 1300017',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 13:46:51','',''),(2206817,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:46:51','',''),(2206858,'1','143','865',382,'Retail Sale Id 1300034',1312.00,0.00,0.00,0.00,108.00,'2021-12-08 13:49:53','',''),(2206859,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 13:49:53','',''),(2206882,'1','143','865',382,'Retail Sale Id 1300046',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 13:51:28','',''),(2206883,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:51:28','',''),(2206898,'1','143','865',382,'Retail Sale Id 1300052',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 13:52:27','',''),(2206899,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:52:27','',''),(2206949,'1','143','865',382,'Retail Sale Id 1300068',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 13:54:53','',''),(2206950,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 13:54:53','',''),(2206981,'1','143','865',382,'Retail Sale Id 1300080',20336.00,0.00,0.00,0.00,1674.00,'2021-12-08 13:56:58','',''),(2206982,'1','143','865',382,'Retail sales',0.00,0.00,0.00,31.00,0.00,'2021-12-08 13:56:58','',''),(2207012,'1','143','865',382,'Retail Sale Id 1300101',3280.00,0.00,0.00,0.00,270.00,'2021-12-08 13:58:59','',''),(2207013,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 13:58:59','',''),(2207033,'1','143','865',382,'Retail Sale Id 1300111',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 14:00:53','',''),(2207034,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:00:53','',''),(2207059,'1','143','865',382,'Retail Sale Id 1300120',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 14:02:42','',''),(2207060,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:02:42','',''),(2207076,'1','143','865',382,'Retail Sale Id 1300126',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 14:03:35','',''),(2207077,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:03:35','',''),(2207144,'1','143','865',382,'Retail Sale Id 1300154',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 14:08:00','',''),(2207145,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:08:00','',''),(2207167,'1','143','865',382,'Retail Sale Id 1300162',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 14:09:26','',''),(2207168,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:09:26','',''),(2207203,'1','143','865',382,'Retail Sale Id 1300177',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 14:11:27','',''),(2207204,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:11:27','',''),(2207241,'1','143','865',382,'Retail Sale Id 1300197',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 14:15:07','',''),(2207242,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:15:07','',''),(2207283,'1','143','865',382,'Retail Sale Id 1300223',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 14:16:51','',''),(2207284,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:16:51','',''),(2207301,'1','143','865',382,'Retail Sale Id 1300230',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 14:17:55','',''),(2207302,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:17:55','',''),(2207319,'1','143','865',382,'Retail Sale Id 1300242',5248.00,0.00,0.00,0.00,432.00,'2021-12-08 14:19:27','',''),(2207320,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-08 14:19:27','',''),(2207615,'1','143','865',382,'Retail Sale Id 1300370',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 14:32:35','',''),(2207616,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:32:35','',''),(2207657,'1','143','865',382,'Retail Sale Id 1300387',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 14:34:59','',''),(2207658,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:34:59','',''),(2207688,'1','143','865',382,'Retail Sale Id 1300406',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 14:36:09','',''),(2207689,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:36:09','',''),(2207706,'1','143','865',382,'Retail Sale Id 1300417',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 14:37:20','',''),(2207707,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:37:20','',''),(2207740,'1','143','865',382,'Retail Sale Id 1300434',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 14:39:16','',''),(2207741,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:39:16','',''),(2207786,'1','143','865',382,'Retail Sale Id 1300460',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 14:42:26','',''),(2207787,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:42:26','',''),(2207822,'1','143','865',382,'Retail Sale Id 1300479',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 14:43:43','',''),(2207823,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:43:43','',''),(2207857,'1','143','865',382,'Retail Sale Id 1300497',2000.80,0.00,0.00,0.00,164.70,'2021-12-08 14:46:09','',''),(2207858,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 14:46:09','',''),(2207871,'1','143','865',382,'Retail Sale Id 1300509',3280.00,0.00,0.00,0.00,270.00,'2021-12-08 14:47:05','',''),(2207872,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 14:47:05','',''),(2207917,'1','143','865',382,'Retail Sale Id 1300533',2997.92,0.00,0.00,0.00,246.78,'2021-12-08 14:49:18','',''),(2207918,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-08 14:49:18','',''),(2208015,'1','143','865',382,'Retail Sale Id 1300579',1502.24,0.00,0.00,0.00,123.66,'2021-12-08 14:55:56','',''),(2208016,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-08 14:55:56','',''),(2208039,'1','143','865',382,'Retail Sale Id 1300592',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 14:57:25','',''),(2208040,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:57:25','',''),(2208053,'1','143','865',382,'Retail Sale Id 1300597',7216.00,0.00,0.00,0.00,594.00,'2021-12-08 14:58:59','',''),(2208054,'1','143','865',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-08 14:58:59','',''),(2208071,'1','143','865',382,'Retail Sale Id 1300605',2624.00,0.00,0.00,0.00,216.00,'2021-12-08 15:00:19','',''),(2208072,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 15:00:19','',''),(2208102,'1','143','865',382,'Retail Sale Id 1300621',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 15:03:01','',''),(2208103,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:03:01','',''),(2208227,'1','143','865',382,'Retail Sale Id 1300671',6002.40,0.00,0.00,0.00,494.10,'2021-12-08 15:10:30','',''),(2208228,'1','143','865',382,'Retail sales',0.00,0.00,0.00,9.15,0.00,'2021-12-08 15:10:30','',''),(2208265,'1','143','865',382,'Retail Sale Id 1300687',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 15:12:17','',''),(2208266,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:12:17','',''),(2208299,'1','143','865',382,'Retail Sale Id 1300707',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 15:14:23','',''),(2208300,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:14:23','',''),(2208349,'1','143','865',382,'Retail Sale Id 1300730',997.12,0.00,0.00,0.00,82.08,'2021-12-08 15:17:40','',''),(2208350,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-08 15:17:40','',''),(2208393,'1','143','865',382,'Retail Sale Id 1300752',8003.20,0.00,0.00,0.00,658.80,'2021-12-08 15:19:20','',''),(2208394,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-08 15:19:20','',''),(2208421,'1','143','865',382,'Retail Sale Id 1300761',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 15:20:39','',''),(2208422,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:20:39','',''),(2208488,'1','143','865',382,'Retail Sale Id 1300786',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 15:24:04','',''),(2208489,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:24:04','',''),(2208570,'1','143','865',382,'Retail Sale Id 1300832',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 15:28:28','',''),(2208571,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:28:28','',''),(2208717,'1','143','865',382,'Retail Sale Id 1300871',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 15:35:38','',''),(2208718,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:35:38','',''),(2208749,'1','143','865',382,'Retail Sale Id 1300931',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 15:36:55','',''),(2208750,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:36:55','',''),(2208773,'1','143','865',382,'Retail Sale Id 1300941',3280.00,0.00,0.00,0.00,270.00,'2021-12-08 15:38:17','',''),(2208774,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 15:38:17','',''),(2209073,'1','143','865',382,'Retail Sale Id 1301087',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 15:54:37','',''),(2209074,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:54:37','',''),(2209109,'1','143','865',382,'Retail Sale Id 1301105',2000.80,0.00,0.00,0.00,164.70,'2021-12-08 15:57:03','',''),(2209110,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 15:57:03','',''),(2209201,'1','143','865',382,'Retail Sale Id 1301154',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 16:01:10','',''),(2209202,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:01:10','',''),(2209267,'1','143','865',382,'Retail Sale Id 1301191',7216.00,0.00,0.00,0.00,594.00,'2021-12-08 16:04:36','',''),(2209268,'1','143','865',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-08 16:04:36','',''),(2209327,'1','143','865',382,'Retail Sale Id 1301204',1312.00,0.00,0.00,0.00,108.00,'2021-12-08 16:07:17','',''),(2209328,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 16:07:17','',''),(2209363,'1','143','865',382,'Retail Sale Id 1301228',2997.92,0.00,0.00,0.00,246.78,'2021-12-08 16:08:53','',''),(2209364,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-08 16:08:53','',''),(2209400,'1','143','865',382,'Retail Sale Id 1301247',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 16:10:24','',''),(2209401,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:10:24','',''),(2209484,'1','143','865',382,'Retail Sale Id 1301291',2000.80,0.00,0.00,0.00,164.70,'2021-12-08 16:13:19','',''),(2209485,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 16:13:19','',''),(2209506,'1','143','865',382,'Retail Sale Id 1301302',3936.00,0.00,0.00,0.00,324.00,'2021-12-08 16:14:37','',''),(2209507,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:14:37','',''),(2209541,'1','143','865',382,'Retail Sale Id 1301314',2000.80,0.00,0.00,0.00,164.70,'2021-12-08 16:15:56','',''),(2209542,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 16:15:56','',''),(2209600,'1','143','865',382,'Retail Sale Id 1301333',3280.00,0.00,0.00,0.00,270.00,'2021-12-08 16:17:22','',''),(2209601,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:17:22','',''),(2209638,'1','143','865',382,'Retail Sale Id 1301352',3280.00,0.00,0.00,0.00,270.00,'2021-12-08 16:19:13','',''),(2209639,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:19:13','',''),(2209682,'1','143','865',382,'Retail Sale Id 1301374',1312.00,0.00,0.00,0.00,108.00,'2021-12-08 16:21:29','',''),(2209683,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 16:21:29','',''),(2209712,'1','143','865',382,'Retail Sale Id 1301385',6560.00,0.00,0.00,0.00,540.00,'2021-12-08 16:22:59','',''),(2209713,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 16:22:59','',''),(2209763,'1','143','865',382,'Retail Sale Id 1301417',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 16:25:27','',''),(2209764,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:25:27','',''),(2209788,'1','143','865',382,'Retail Sale Id 1301483',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 16:28:30','',''),(2209789,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:28:30','',''),(2209901,'1','143','865',382,'Retail Sale Id 1301568',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 16:33:39','',''),(2209902,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:33:39','',''),(2209971,'1','143','865',382,'Retail Sale Id 1301637',3201.28,0.00,0.00,0.00,263.52,'2021-12-08 16:36:33','',''),(2209972,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.88,0.00,'2021-12-08 16:36:33','',''),(2209999,'1','143','865',382,'Retail Sale Id 1301651',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 16:38:06','',''),(2210000,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:38:06','',''),(2210025,'1','143','865',382,'Retail Sale Id 1301661',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 16:39:12','',''),(2210026,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:39:12','',''),(2210095,'1','143','865',382,'Retail Sale Id 1301697',3280.00,0.00,0.00,0.00,270.00,'2021-12-08 16:42:18','',''),(2210096,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:42:18','',''),(2210131,'1','143','865',382,'Retail Sale Id 1301719',3280.00,0.00,0.00,0.00,270.00,'2021-12-08 16:44:07','',''),(2210132,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:44:07','',''),(2210165,'1','143','865',382,'Retail Sale Id 1301733',7216.00,0.00,0.00,0.00,594.00,'2021-12-08 16:45:30','',''),(2210166,'1','143','865',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-08 16:45:30','',''),(2210173,'1','143','865',382,'Retail Sale Id 1301739',5248.00,0.00,0.00,0.00,432.00,'2021-12-08 16:46:09','',''),(2210174,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-08 16:46:09','',''),(2210191,'1','143','865',382,'Retail Sale Id 1301747',1968.00,0.00,0.00,0.00,162.00,'2021-12-08 16:47:18','',''),(2210192,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:47:18','',''),(2210265,'1','143','865',382,'Retail Sale Id 1301784',898.72,0.00,0.00,0.00,73.98,'2021-12-08 16:50:56','',''),(2210266,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.37,0.00,'2021-12-08 16:50:56','',''),(2210332,'1','143','865',382,'Retail Sale Id 1301816',2499.36,0.00,0.00,0.00,205.74,'2021-12-08 16:54:52','',''),(2210333,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-08 16:54:52','',''),(2210440,'1','143','865',382,'Retail Sale Id 1301879',70848.00,0.00,0.00,0.00,5832.00,'2021-12-08 17:02:30','',''),(2210441,'1','143','865',382,'Retail sales',0.00,0.00,0.00,108.00,0.00,'2021-12-08 17:02:30','',''),(2210696,'1','143','865',382,'Retail Sale Id 1302029',263056.00,0.00,0.00,0.00,21654.00,'2021-12-08 17:28:17','',''),(2210697,'1','143','865',382,'Retail sales',0.00,0.00,0.00,401.00,0.00,'2021-12-08 17:28:17','',''),(2210722,'1','143','865',382,'Retail Sale Id 1302043',5248.00,0.00,0.00,0.00,432.00,'2021-12-08 17:30:08','',''),(2210723,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-08 17:30:08','',''),(2212563,'1','143','865',382,'Retail Sale Id 1302617',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 06:45:14','',''),(2212564,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 06:45:14','',''),(2212658,'1','143','865',382,'Retail Sale Id 1302667',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 06:50:15','',''),(2212659,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 06:50:15','',''),(2213104,'1','143','865',382,'Retail Sale Id 1302865',16400.00,0.00,0.00,0.00,1350.00,'2021-12-09 07:14:55','',''),(2213105,'1','143','865',382,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 07:14:55','',''),(2213141,'1','143','865',382,'Retail Sale Id 1302885',3601.44,0.00,0.00,0.00,296.46,'2021-12-09 07:16:01','',''),(2213142,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.49,0.00,'2021-12-09 07:16:01','',''),(2213226,'1','143','865',382,'Retail Sale Id 1302922',2624.00,0.00,0.00,0.00,216.00,'2021-12-09 07:19:22','',''),(2213227,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 07:19:22','',''),(2213328,'1','143','865',382,'Retail Sale Id 1302968',1699.04,0.00,0.00,0.00,139.86,'2021-12-09 07:23:30','',''),(2213329,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.59,0.00,'2021-12-09 07:23:30','',''),(2213392,'1','143','865',382,'Retail Sale Id 1303003',2000.80,0.00,0.00,0.00,164.70,'2021-12-09 07:26:15','',''),(2213393,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 07:26:15','',''),(2213412,'1','143','865',382,'Retail Sale Id 1303014',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 07:27:45','',''),(2213413,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:27:45','',''),(2213642,'1','143','865',382,'Retail Sale Id 1303126',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 07:38:34','',''),(2213643,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:38:34','',''),(2213684,'1','143','865',382,'Retail Sale Id 1303148',1994.24,0.00,0.00,0.00,164.16,'2021-12-09 07:40:58','',''),(2213685,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.04,0.00,'2021-12-09 07:40:58','',''),(2213806,'1','143','865',382,'Retail Sale Id 1303199',5904.00,0.00,0.00,0.00,486.00,'2021-12-09 07:46:27','',''),(2213807,'1','143','865',382,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-09 07:46:27','',''),(2213838,'1','143','865',382,'Retail Sale Id 1303217',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 07:48:03','',''),(2213839,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 07:48:03','',''),(2213914,'1','143','865',382,'Retail Sale Id 1303252',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 07:52:37','',''),(2213915,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:52:37','',''),(2214040,'1','143','865',382,'Retail Sale Id 1303318',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 07:59:49','',''),(2214041,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 07:59:49','',''),(2214068,'1','143','865',382,'Retail Sale Id 1303335',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 08:01:31','',''),(2214069,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:01:31','',''),(2214140,'1','143','865',382,'Retail Sale Id 1303372',997.12,0.00,0.00,0.00,82.08,'2021-12-09 08:05:33','',''),(2214141,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-09 08:05:33','',''),(2214228,'1','143','865',382,'Retail Sale Id 1303416',2624.00,0.00,0.00,0.00,216.00,'2021-12-09 08:10:00','',''),(2214229,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 08:10:00','',''),(2214304,'1','143','865',382,'Retail Sale Id 1303457',4998.72,0.00,0.00,0.00,411.48,'2021-12-09 08:14:25','',''),(2214305,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-09 08:14:25','',''),(2214356,'1','143','865',382,'Retail Sale Id 1303484',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 08:16:32','',''),(2214357,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 08:16:32','',''),(2214488,'1','143','865',382,'Retail Sale Id 1303532',6560.00,0.00,0.00,0.00,540.00,'2021-12-09 08:22:39','',''),(2214489,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 08:22:39','',''),(2214563,'1','143','865',382,'Retail Sale Id 1303563',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 08:25:36','',''),(2214564,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 08:25:36','',''),(2214604,'1','143','865',382,'Retail Sale Id 1303577',2624.00,0.00,0.00,0.00,216.00,'2021-12-09 08:27:18','',''),(2214605,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 08:27:18','',''),(2214647,'1','143','865',382,'Retail Sale Id 1303593',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 08:28:56','',''),(2214648,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 08:28:56','',''),(2214732,'1','143','865',382,'Retail Sale Id 1303633',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 08:33:16','',''),(2214733,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:33:16','',''),(2214776,'1','143','865',382,'Retail Sale Id 1303660',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 08:35:42','',''),(2214777,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 08:35:42','',''),(2214801,'1','143','865',382,'Retail Sale Id 1303673',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 08:37:15','',''),(2214802,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 08:37:15','',''),(2214931,'1','143','865',382,'Retail Sale Id 1303734',5248.00,0.00,0.00,0.00,432.00,'2021-12-09 08:42:40','',''),(2214932,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-09 08:42:40','',''),(2215024,'1','143','865',382,'Retail Sale Id 1303773',16400.00,0.00,0.00,0.00,1350.00,'2021-12-09 08:47:04','',''),(2215025,'1','143','865',382,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 08:47:04','',''),(2215144,'1','143','865',382,'Retail Sale Id 1303834',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 08:54:51','',''),(2215145,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 08:54:51','',''),(2215180,'1','143','865',382,'Retail Sale Id 1303854',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 08:57:22','',''),(2215181,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 08:57:22','',''),(2215313,'1','143','865',382,'Retail Sale Id 1303918',220500.00,0.00,0.00,0.00,9800.00,'2021-12-09 09:04:29','',''),(2215314,'1','143','865',382,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-09 09:04:29','',''),(2215434,'1','143','865',382,'Retail Sale Id 1303983',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 09:12:14','',''),(2215435,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 09:12:14','',''),(2215466,'1','143','865',382,'Retail Sale Id 1303999',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 09:14:44','',''),(2215467,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:14:44','',''),(2215549,'1','143','865',382,'Retail Sale Id 1304040',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 09:19:43','',''),(2215550,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 09:19:43','',''),(2215579,'1','143','865',382,'Retail Sale Id 1304056',1312.00,0.00,0.00,0.00,108.00,'2021-12-09 09:21:16','',''),(2215580,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 09:21:16','',''),(2215732,'1','143','865',382,'Retail Sale Id 1304132',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 09:29:10','',''),(2215733,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 09:29:10','',''),(2215774,'1','143','865',382,'Retail Sale Id 1304157',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 09:31:49','',''),(2215775,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:31:49','',''),(2215917,'1','143','865',382,'Retail Sale Id 1304212',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 09:37:23','',''),(2215918,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 09:37:23','',''),(2215949,'1','143','865',382,'Retail Sale Id 1304230',2499.36,0.00,0.00,0.00,205.74,'2021-12-09 09:39:27','',''),(2215950,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-09 09:39:27','',''),(2216020,'1','143','865',382,'Retail Sale Id 1304251',25200.00,0.00,0.00,0.00,1120.00,'2021-12-09 09:42:13','',''),(2216021,'1','143','865',382,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-09 09:42:13','',''),(2216201,'1','143','865',382,'Retail Sale Id 1304320',63000.00,0.00,0.00,0.00,2800.00,'2021-12-09 09:51:26','',''),(2216202,'1','143','865',382,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-09 09:51:26','',''),(2216271,'1','143','865',382,'Retail Sale Id 1304347',3995.04,0.00,0.00,0.00,328.86,'2021-12-09 09:54:24','',''),(2216272,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-09 09:54:24','',''),(2216358,'1','143','865',382,'Retail Sale Id 1304392',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 09:58:04','',''),(2216359,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 09:58:04','',''),(2216414,'1','143','865',382,'Retail Sale Id 1304415',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 10:00:44','',''),(2216415,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 10:00:44','',''),(2216447,'1','143','865',382,'Retail Sale Id 1304429',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 10:02:55','',''),(2216448,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 10:02:55','',''),(2216481,'1','143','865',382,'Retail Sale Id 1304448',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 10:05:04','',''),(2216482,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 10:05:04','',''),(2216529,'1','143','865',382,'Retail Sale Id 1304472',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 10:07:14','',''),(2216530,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:07:14','',''),(2216583,'1','143','865',382,'Retail Sale Id 1304500',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 10:11:17','',''),(2216584,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:11:17','',''),(2216619,'1','143','865',382,'Retail Sale Id 1304520',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 10:13:22','',''),(2216620,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 10:13:22','',''),(2216651,'1','143','865',382,'Retail Sale Id 1304540',7872.00,0.00,0.00,0.00,648.00,'2021-12-09 10:16:28','',''),(2216652,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-09 10:16:28','',''),(2216737,'1','143','865',382,'Retail Sale Id 1304588',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 10:22:23','',''),(2216738,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 10:22:23','',''),(2216773,'1','143','865',382,'Retail Sale Id 1304604',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 10:23:52','',''),(2216774,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 10:23:52','',''),(2216795,'1','143','865',382,'Retail Sale Id 1304616',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 10:25:39','',''),(2216796,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 10:25:39','',''),(2216823,'1','143','865',382,'Retail Sale Id 1304634',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 10:27:10','',''),(2216824,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:27:10','',''),(2216857,'1','143','865',382,'Retail Sale Id 1304650',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 10:29:02','',''),(2216858,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 10:29:02','',''),(2216901,'1','143','865',382,'Retail Sale Id 1304672',2624.00,0.00,0.00,0.00,216.00,'2021-12-09 10:31:48','',''),(2216902,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 10:31:48','',''),(2216947,'1','143','865',382,'Retail Sale Id 1304691',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 10:35:31','',''),(2216948,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 10:35:31','',''),(2216988,'1','143','865',382,'Retail Sale Id 1304717',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 10:38:35','',''),(2216989,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:38:35','',''),(2217042,'1','143','865',382,'Retail Sale Id 1304742',7872.00,0.00,0.00,0.00,648.00,'2021-12-09 10:42:17','',''),(2217043,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-09 10:42:17','',''),(2217068,'1','143','865',382,'Retail Sale Id 1304760',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 10:43:42','',''),(2217069,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 10:43:42','',''),(2217222,'1','143','865',382,'Retail Sale Id 1304829',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 10:53:19','',''),(2217223,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 10:53:19','',''),(2217266,'1','143','865',382,'Retail Sale Id 1304857',1312.00,0.00,0.00,0.00,108.00,'2021-12-09 10:56:46','',''),(2217267,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 10:56:46','',''),(2217414,'1','143','865',382,'Retail Sale Id 1304936',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 11:06:47','',''),(2217415,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:06:47','',''),(2217442,'1','143','865',382,'Retail Sale Id 1304949',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 11:08:42','',''),(2217443,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 11:08:42','',''),(2217510,'1','143','865',382,'Retail Sale Id 1304981',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 11:14:14','',''),(2217511,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 11:14:14','',''),(2217652,'1','143','865',382,'Retail Sale Id 1305047',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 11:22:25','',''),(2217653,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 11:22:25','',''),(2217708,'1','143','865',382,'Retail Sale Id 1305072',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 11:24:56','',''),(2217709,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:24:56','',''),(2217722,'1','143','865',382,'Retail Sale Id 1305080',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 11:26:09','',''),(2217723,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 11:26:09','',''),(2217749,'1','143','865',382,'Retail Sale Id 1305094',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 11:28:23','',''),(2217750,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:28:23','',''),(2217811,'1','143','865',382,'Retail Sale Id 1305126',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 11:31:07','',''),(2217812,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 11:31:07','',''),(2217866,'1','143','865',382,'Retail Sale Id 1305151',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 11:34:47','',''),(2217867,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:34:47','',''),(2217889,'1','143','865',382,'Retail Sale Id 1305163',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 11:36:14','',''),(2217890,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:36:14','',''),(2217909,'1','143','865',382,'Retail Sale Id 1305170',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 11:37:47','',''),(2217910,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 11:37:47','',''),(2218090,'1','143','865',382,'Retail Sale Id 1305251',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 11:48:57','',''),(2218091,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:48:57','',''),(2218234,'1','143','865',382,'Retail Sale Id 1305335',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 11:58:23','',''),(2218235,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 11:58:23','',''),(2218256,'1','143','865',382,'Retail Sale Id 1305347',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 11:59:42','',''),(2218257,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:59:42','',''),(2218298,'1','143','865',382,'Retail Sale Id 1305370',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 12:02:13','',''),(2218299,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 12:02:13','',''),(2218322,'1','143','865',382,'Retail Sale Id 1305383',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 12:04:19','',''),(2218323,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 12:04:19','',''),(2218373,'1','143','865',382,'Retail Sale Id 1305406',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 12:07:59','',''),(2218374,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 12:08:00','',''),(2218385,'1','143','865',382,'Retail Sale Id 1305412',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 12:09:05','',''),(2218386,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 12:09:05','',''),(2218419,'1','143','865',382,'Retail Sale Id 1305433',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 12:11:29','',''),(2218420,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 12:11:29','',''),(2218467,'1','143','865',382,'Retail Sale Id 1305451',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 12:13:04','',''),(2218468,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 12:13:04','',''),(2218548,'1','143','865',382,'Retail Sale Id 1305490',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 12:18:24','',''),(2218549,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 12:18:24','',''),(2218604,'1','143','865',382,'Retail Sale Id 1305520',2624.00,0.00,0.00,0.00,216.00,'2021-12-09 12:22:09','',''),(2218605,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 12:22:09','',''),(2218632,'1','143','865',382,'Retail Sale Id 1305535',1312.00,0.00,0.00,0.00,108.00,'2021-12-09 12:24:15','',''),(2218633,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 12:24:15','',''),(2218650,'1','143','865',382,'Retail Sale Id 1305553',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 12:25:31','',''),(2218651,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 12:25:31','',''),(2218686,'1','143','865',382,'Retail Sale Id 1305573',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 12:28:03','',''),(2218687,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 12:28:03','',''),(2218772,'1','143','865',382,'Retail Sale Id 1305621',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 12:33:30','',''),(2218773,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 12:33:30','',''),(2218982,'1','143','865',382,'Retail Sale Id 1305723',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 12:45:10','',''),(2218983,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 12:45:10','',''),(2219025,'1','143','865',382,'Retail Sale Id 1305746',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 12:47:33','',''),(2219026,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 12:47:33','',''),(2219089,'1','143','865',382,'Retail Sale Id 1305771',997.12,0.00,0.00,0.00,82.08,'2021-12-09 12:50:02','',''),(2219090,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-09 12:50:02','',''),(2219267,'1','143','865',382,'Retail Sale Id 1305857',1502.24,0.00,0.00,0.00,123.66,'2021-12-09 12:59:46','',''),(2219268,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-09 12:59:46','',''),(2219305,'1','143','865',382,'Retail Sale Id 1305877',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 13:02:10','',''),(2219306,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 13:02:10','',''),(2219462,'1','143','865',382,'Retail Sale Id 1305959',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 13:12:57','',''),(2219463,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 13:12:57','',''),(2219674,'1','143','865',382,'Retail Sale Id 1306048',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 13:28:19','',''),(2219675,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 13:28:19','',''),(2220040,'1','143','865',382,'Retail Sale Id 1306178',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 13:45:53','',''),(2220041,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 13:45:53','',''),(2220146,'1','143','865',382,'Retail Sale Id 1306229',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 13:53:12','',''),(2220147,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 13:53:12','',''),(2220242,'1','143','865',382,'Retail Sale Id 1306278',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 13:59:55','',''),(2220243,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 13:59:55','',''),(2220262,'1','143','865',382,'Retail Sale Id 1306286',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 14:01:55','',''),(2220263,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 14:01:55','',''),(2220334,'1','143','865',382,'Retail Sale Id 1306315',12136.00,0.00,0.00,0.00,999.00,'2021-12-09 14:06:32','',''),(2220335,'1','143','865',382,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-09 14:06:32','',''),(2220352,'1','143','865',382,'Retail Sale Id 1306325',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 14:08:06','',''),(2220353,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 14:08:06','',''),(2220518,'1','143','865',382,'Retail Sale Id 1306433',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 14:17:21','',''),(2220519,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:17:21','',''),(2220598,'1','143','865',382,'Retail Sale Id 1306478',4592.00,0.00,0.00,0.00,378.00,'2021-12-09 14:22:11','',''),(2220599,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-09 14:22:11','',''),(2220684,'1','143','865',382,'Retail Sale Id 1306520',4985.60,0.00,0.00,0.00,410.40,'2021-12-09 14:26:25','',''),(2220685,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.60,0.00,'2021-12-09 14:26:25','',''),(2220738,'1','143','865',382,'Retail Sale Id 1306546',7872.00,0.00,0.00,0.00,648.00,'2021-12-09 14:28:36','',''),(2220739,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-09 14:28:36','',''),(2220776,'1','143','865',382,'Retail Sale Id 1306561',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 14:30:38','',''),(2220777,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 14:30:38','',''),(2220827,'1','143','865',382,'Retail Sale Id 1306587',9997.44,0.00,0.00,0.00,822.96,'2021-12-09 14:33:06','',''),(2220828,'1','143','865',382,'Retail sales',0.00,0.00,0.00,15.24,0.00,'2021-12-09 14:33:06','',''),(2220889,'1','143','865',382,'Retail Sale Id 1306608',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 14:35:20','',''),(2220890,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 14:35:20','',''),(2220933,'1','143','865',382,'Retail Sale Id 1306623',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 14:36:41','',''),(2220934,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:36:41','',''),(2220974,'1','143','865',382,'Retail Sale Id 1306640',1312.00,0.00,0.00,0.00,108.00,'2021-12-09 14:38:09','',''),(2220975,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 14:38:09','',''),(2221006,'1','143','865',382,'Retail Sale Id 1306667',1312.00,0.00,0.00,0.00,108.00,'2021-12-09 14:39:54','',''),(2221007,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 14:39:54','',''),(2221040,'1','143','865',382,'Retail Sale Id 1306682',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 14:41:25','',''),(2221041,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 14:41:25','',''),(2221137,'1','143','865',382,'Retail Sale Id 1306722',5248.00,0.00,0.00,0.00,432.00,'2021-12-09 14:45:17','',''),(2221138,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-09 14:45:17','',''),(2221180,'1','143','865',382,'Retail Sale Id 1306743',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 14:47:00','',''),(2221181,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 14:47:00','',''),(2221369,'1','143','865',382,'Retail Sale Id 1306803',63000.00,0.00,0.00,0.00,2800.00,'2021-12-09 14:54:05','',''),(2221370,'1','143','865',382,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-09 14:54:05','',''),(2221420,'1','143','865',382,'Retail Sale Id 1306815',8003.20,0.00,0.00,0.00,658.80,'2021-12-09 14:55:33','',''),(2221421,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-09 14:55:33','',''),(2221444,'1','143','865',382,'Retail Sale Id 1306828',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 14:57:13','',''),(2221445,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 14:57:13','',''),(2221478,'1','143','865',382,'Retail Sale Id 1306845',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 14:59:08','',''),(2221479,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 14:59:08','',''),(2221502,'1','143','865',382,'Retail Sale Id 1306858',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 15:00:48','',''),(2221503,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:00:48','',''),(2221530,'1','143','865',382,'Retail Sale Id 1306872',3503.04,0.00,0.00,0.00,288.36,'2021-12-09 15:02:47','',''),(2221531,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-09 15:02:47','',''),(2221556,'1','143','865',382,'Retail Sale Id 1306887',2499.36,0.00,0.00,0.00,205.74,'2021-12-09 15:04:06','',''),(2221557,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-09 15:04:06','',''),(2221670,'1','143','865',382,'Retail Sale Id 1306948',997.12,0.00,0.00,0.00,82.08,'2021-12-09 15:09:19','',''),(2221671,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-09 15:09:19','',''),(2221695,'1','143','865',382,'Retail Sale Id 1306963',1902.40,0.00,0.00,0.00,156.60,'2021-12-09 15:10:17','',''),(2221696,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-09 15:10:17','',''),(2221715,'1','143','865',382,'Retail Sale Id 1306975',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 15:11:19','',''),(2221716,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:11:19','',''),(2221749,'1','143','865',382,'Retail Sale Id 1306991',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 15:13:10','',''),(2221750,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 15:13:10','',''),(2221777,'1','143','865',382,'Retail Sale Id 1307005',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 15:14:50','',''),(2221778,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:14:50','',''),(2221813,'1','143','865',382,'Retail Sale Id 1307028',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 15:16:33','',''),(2221814,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:16:33','',''),(2221833,'1','143','865',382,'Retail Sale Id 1307037',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 15:17:36','',''),(2221834,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 15:17:36','',''),(2221903,'1','143','865',382,'Retail Sale Id 1307072',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 15:21:11','',''),(2221904,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:21:11','',''),(2221969,'1','143','865',382,'Retail Sale Id 1307096',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 15:24:24','',''),(2221970,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 15:24:24','',''),(2222021,'1','143','865',382,'Retail Sale Id 1307130',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 15:27:00','',''),(2222022,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:27:00','',''),(2222059,'1','143','865',382,'Retail Sale Id 1307154',1994.24,0.00,0.00,0.00,164.16,'2021-12-09 15:28:37','',''),(2222060,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.04,0.00,'2021-12-09 15:28:37','',''),(2222101,'1','143','865',382,'Retail Sale Id 1307172',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 15:30:42','',''),(2222102,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:30:42','',''),(2222138,'1','143','865',382,'Retail Sale Id 1307186',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 15:32:15','',''),(2222139,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:32:15','',''),(2222172,'1','143','865',382,'Retail Sale Id 1307205',1994.24,0.00,0.00,0.00,164.16,'2021-12-09 15:34:10','',''),(2222173,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.04,0.00,'2021-12-09 15:34:10','',''),(2222202,'1','143','865',382,'Retail Sale Id 1307220',1312.00,0.00,0.00,0.00,108.00,'2021-12-09 15:35:55','',''),(2222203,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 15:35:55','',''),(2222252,'1','143','865',382,'Retail Sale Id 1307239',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 15:38:27','',''),(2222253,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 15:38:27','',''),(2222300,'1','143','865',382,'Retail Sale Id 1307265',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 15:40:24','',''),(2222301,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 15:40:24','',''),(2222340,'1','143','865',382,'Retail Sale Id 1307289',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 15:43:12','',''),(2222341,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:43:12','',''),(2222384,'1','143','865',382,'Retail Sale Id 1307310',4998.72,0.00,0.00,0.00,411.48,'2021-12-09 15:45:44','',''),(2222385,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-09 15:45:44','',''),(2222429,'1','143','865',382,'Retail Sale Id 1307331',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 15:48:34','',''),(2222430,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:48:34','',''),(2222457,'1','143','865',382,'Retail Sale Id 1307344',4001.60,0.00,0.00,0.00,329.40,'2021-12-09 15:50:15','',''),(2222458,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-09 15:50:15','',''),(2222489,'1','143','865',382,'Retail Sale Id 1307362',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 15:52:27','',''),(2222490,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 15:52:27','',''),(2222539,'1','143','865',382,'Retail Sale Id 1307385',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 15:54:29','',''),(2222540,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 15:54:29','',''),(2222586,'1','143','865',382,'Retail Sale Id 1307408',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 15:56:29','',''),(2222587,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:56:29','',''),(2222600,'1','143','865',382,'Retail Sale Id 1307415',1312.00,0.00,0.00,0.00,108.00,'2021-12-09 15:57:36','',''),(2222601,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 15:57:36','',''),(2222646,'1','143','865',382,'Retail Sale Id 1307437',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 16:00:14','',''),(2222647,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 16:00:14','',''),(2222674,'1','143','865',382,'Retail Sale Id 1307450',7498.08,0.00,0.00,0.00,617.22,'2021-12-09 16:01:36','',''),(2222675,'1','143','865',382,'Retail sales',0.00,0.00,0.00,11.43,0.00,'2021-12-09 16:01:36','',''),(2222696,'1','143','865',382,'Retail Sale Id 1307462',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 16:03:02','',''),(2222697,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:03:02','',''),(2222735,'1','143','865',382,'Retail Sale Id 1307480',2624.00,0.00,0.00,0.00,216.00,'2021-12-09 16:04:48','',''),(2222736,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 16:04:48','',''),(2222785,'1','143','865',382,'Retail Sale Id 1307506',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 16:07:24','',''),(2222786,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:07:24','',''),(2222809,'1','143','865',382,'Retail Sale Id 1307519',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 16:08:51','',''),(2222810,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 16:08:51','',''),(2222835,'1','143','865',382,'Retail Sale Id 1307533',1502.24,0.00,0.00,0.00,123.66,'2021-12-09 16:09:50','',''),(2222836,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-09 16:09:50','',''),(2222855,'1','143','865',382,'Retail Sale Id 1307544',1312.00,0.00,0.00,0.00,108.00,'2021-12-09 16:10:48','',''),(2222856,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 16:10:48','',''),(2222877,'1','143','865',382,'Retail Sale Id 1307555',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 16:11:59','',''),(2222878,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 16:11:59','',''),(2222895,'1','143','865',382,'Retail Sale Id 1307564',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 16:13:12','',''),(2222896,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 16:13:12','',''),(2222927,'1','143','865',382,'Retail Sale Id 1307578',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 16:14:55','',''),(2222928,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:14:55','',''),(2223059,'1','143','865',382,'Retail Sale Id 1307642',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 16:21:48','',''),(2223060,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:21:48','',''),(2223087,'1','143','865',382,'Retail Sale Id 1307653',4592.00,0.00,0.00,0.00,378.00,'2021-12-09 16:23:29','',''),(2223088,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-09 16:23:29','',''),(2223103,'1','143','865',382,'Retail Sale Id 1307665',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 16:25:09','',''),(2223104,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:25:09','',''),(2223141,'1','143','865',382,'Retail Sale Id 1307676',6560.00,0.00,0.00,0.00,540.00,'2021-12-09 16:26:07','',''),(2223142,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 16:26:07','',''),(2223176,'1','143','865',382,'Retail Sale Id 1307694',997.12,0.00,0.00,0.00,82.08,'2021-12-09 16:28:04','',''),(2223177,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-09 16:28:04','',''),(2223270,'1','143','865',382,'Retail Sale Id 1307741',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 16:33:21','',''),(2223271,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 16:33:21','',''),(2223322,'1','143','865',382,'Retail Sale Id 1307764',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 16:35:42','',''),(2223323,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:35:42','',''),(2223340,'1','143','865',382,'Retail Sale Id 1307773',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 16:36:55','',''),(2223341,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 16:36:55','',''),(2223374,'1','143','865',382,'Retail Sale Id 1307784',9840.00,0.00,0.00,0.00,810.00,'2021-12-09 16:38:58','',''),(2223375,'1','143','865',382,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-09 16:38:58','',''),(2223411,'1','143','865',382,'Retail Sale Id 1307798',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 16:40:51','',''),(2223412,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:40:51','',''),(2223457,'1','143','865',382,'Retail Sale Id 1307815',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 16:42:48','',''),(2223458,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 16:42:48','',''),(2223488,'1','143','865',382,'Retail Sale Id 1307824',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 16:43:49','',''),(2223489,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 16:43:49','',''),(2223507,'1','143','865',382,'Retail Sale Id 1307832',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 16:45:02','',''),(2223508,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 16:45:02','',''),(2223526,'1','143','865',382,'Retail Sale Id 1307839',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 16:46:03','',''),(2223527,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:46:03','',''),(2223679,'1','143','865',382,'Retail Sale Id 1307900',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 16:55:11','',''),(2223680,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:55:11','',''),(2223701,'1','143','865',382,'Retail Sale Id 1307919',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 16:56:09','',''),(2223702,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:56:09','',''),(2223715,'1','143','865',382,'Retail Sale Id 1307925',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 16:57:11','',''),(2223716,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:57:11','',''),(2223725,'1','143','865',382,'Retail Sale Id 1307930',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 16:58:19','',''),(2223726,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:58:19','',''),(2223776,'1','143','865',382,'Retail Sale Id 1307957',6002.40,0.00,0.00,0.00,494.10,'2021-12-09 17:01:14','',''),(2223777,'1','143','865',382,'Retail sales',0.00,0.00,0.00,9.15,0.00,'2021-12-09 17:01:14','',''),(2223800,'1','143','865',382,'Retail Sale Id 1307967',13120.00,0.00,0.00,0.00,1080.00,'2021-12-09 17:02:44','',''),(2223801,'1','143','865',382,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-09 17:02:44','',''),(2223865,'1','143','865',382,'Retail Sale Id 1307996',3936.00,0.00,0.00,0.00,324.00,'2021-12-09 17:05:57','',''),(2223866,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 17:05:57','',''),(2223887,'1','143','865',382,'Retail Sale Id 1308007',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 17:07:51','',''),(2223888,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 17:07:51','',''),(2225678,'1','143','865',382,'Retail Sale Id 1308628',4992.00,0.00,0.00,0.00,176.00,'2021-12-10 06:53:23','',''),(2225679,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-10 06:53:23','',''),(2225698,'1','143','865',382,'Retail Sale Id 1308640',6240.00,0.00,0.00,0.00,220.00,'2021-12-10 06:55:14','',''),(2225699,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 06:55:14','',''),(2225769,'1','143','865',382,'Retail Sale Id 1308679',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 07:00:39','',''),(2225770,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:00:39','',''),(2225910,'1','143','865',382,'Retail Sale Id 1308749',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 07:09:39','',''),(2225911,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:09:39','',''),(2225980,'1','143','865',382,'Retail Sale Id 1308787',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 07:14:12','',''),(2225981,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:14:12','',''),(2226074,'1','143','865',382,'Retail Sale Id 1308838',5928.00,0.00,0.00,0.00,209.00,'2021-12-10 07:19:02','',''),(2226075,'1','143','865',382,'Retail sales',0.00,0.00,0.00,9.50,0.00,'2021-12-10 07:19:02','',''),(2226104,'1','143','865',382,'Retail Sale Id 1308856',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 07:20:33','',''),(2226105,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:20:33','',''),(2226198,'1','143','865',382,'Retail Sale Id 1308902',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 07:25:54','',''),(2226199,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:25:54','',''),(2226455,'1','143','865',382,'Retail Sale Id 1309017',3120.00,0.00,0.00,0.00,110.00,'2021-12-10 07:39:30','',''),(2226456,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 07:39:30','',''),(2226503,'1','143','865',382,'Retail Sale Id 1309042',2003.04,0.00,0.00,0.00,70.62,'2021-12-10 07:41:54','',''),(2226504,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 07:41:54','',''),(2226531,'1','143','865',382,'Retail Sale Id 1309055',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 07:43:32','',''),(2226532,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:43:32','',''),(2226639,'1','143','865',382,'Retail Sale Id 1309110',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 07:49:51','',''),(2226640,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 07:49:51','',''),(2226895,'1','143','865',382,'Retail Sale Id 1309198',3120.00,0.00,0.00,0.00,110.00,'2021-12-10 08:01:01','',''),(2226896,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 08:01:01','',''),(2226921,'1','143','865',382,'Retail Sale Id 1309207',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 08:02:40','',''),(2226922,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:02:40','',''),(2226966,'1','143','865',382,'Retail Sale Id 1309230',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 08:04:28','',''),(2226967,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:04:28','',''),(2227243,'1','143','865',382,'Retail Sale Id 1309348',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 08:18:15','',''),(2227244,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:18:15','',''),(2227295,'1','143','865',382,'Retail Sale Id 1309377',3120.00,0.00,0.00,0.00,110.00,'2021-12-10 08:21:05','',''),(2227296,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 08:21:05','',''),(2227393,'1','143','865',382,'Retail Sale Id 1309405',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 08:23:56','',''),(2227394,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 08:23:56','',''),(2227461,'1','143','865',382,'Retail Sale Id 1309428',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 08:27:27','',''),(2227462,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:27:27','',''),(2227511,'1','143','865',382,'Retail Sale Id 1309457',3120.00,0.00,0.00,0.00,110.00,'2021-12-10 08:30:10','',''),(2227512,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 08:30:10','',''),(2227585,'1','143','865',382,'Retail Sale Id 1309501',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 08:33:43','',''),(2227586,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:33:43','',''),(2227649,'1','143','865',382,'Retail Sale Id 1309532',11232.00,0.00,0.00,0.00,396.00,'2021-12-10 08:37:05','',''),(2227650,'1','143','865',382,'Retail sales',0.00,0.00,0.00,18.00,0.00,'2021-12-10 08:37:05','',''),(2227698,'1','143','865',382,'Retail Sale Id 1309561',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 08:40:22','',''),(2227699,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 08:40:22','',''),(2227732,'1','143','865',382,'Retail Sale Id 1309575',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 08:42:25','',''),(2227733,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:42:25','',''),(2227966,'1','143','865',382,'Retail Sale Id 1309677',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 08:51:13','',''),(2227967,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:51:13','',''),(2228037,'1','143','865',382,'Retail Sale Id 1309708',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 08:53:59','',''),(2228038,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:53:59','',''),(2228067,'1','143','865',382,'Retail Sale Id 1309722',2496.00,0.00,0.00,0.00,88.00,'2021-12-10 08:56:08','',''),(2228068,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 08:56:08','',''),(2228100,'1','143','865',382,'Retail Sale Id 1309742',1996.80,0.00,0.00,0.00,70.40,'2021-12-10 08:57:47','',''),(2228101,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.20,0.00,'2021-12-10 08:57:47','',''),(2228148,'1','143','865',382,'Retail Sale Id 1309770',8498.88,0.00,0.00,0.00,299.64,'2021-12-10 08:59:46','',''),(2228149,'1','143','865',382,'Retail sales',0.00,0.00,0.00,13.62,0.00,'2021-12-10 08:59:46','',''),(2228190,'1','143','865',382,'Retail Sale Id 1309786',2496.00,0.00,0.00,0.00,88.00,'2021-12-10 09:01:01','',''),(2228191,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 09:01:01','',''),(2228223,'1','143','865',382,'Retail Sale Id 1309798',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 09:02:03','',''),(2228224,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 09:02:03','',''),(2228304,'1','143','865',382,'Retail Sale Id 1309843',15600.00,0.00,0.00,0.00,550.00,'2021-12-10 09:06:40','',''),(2228305,'1','143','865',382,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 09:06:40','',''),(2228326,'1','143','865',382,'Retail Sale Id 1309854',998.40,0.00,0.00,0.00,35.20,'2021-12-10 09:08:19','',''),(2228327,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 09:08:19','',''),(2228407,'1','143','865',382,'Retail Sale Id 1309891',2995.20,0.00,0.00,0.00,105.60,'2021-12-10 09:12:45','',''),(2228408,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.80,0.00,'2021-12-10 09:12:45','',''),(2228668,'1','143','865',382,'Retail Sale Id 1310010',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 09:28:51','',''),(2228669,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 09:28:51','',''),(2228686,'1','143','865',382,'Retail Sale Id 1310023',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 09:30:14','',''),(2228687,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 09:30:14','',''),(2228714,'1','143','865',382,'Retail Sale Id 1310036',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 09:32:33','',''),(2228715,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 09:32:33','',''),(2228793,'1','143','865',382,'Retail Sale Id 1310068',3120.00,0.00,0.00,0.00,110.00,'2021-12-10 09:35:16','',''),(2228794,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 09:35:16','',''),(2228813,'1','143','865',382,'Retail Sale Id 1310079',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 09:36:41','',''),(2228814,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 09:36:41','',''),(2228849,'1','143','865',382,'Retail Sale Id 1310095',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 09:38:59','',''),(2228850,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 09:38:59','',''),(2228883,'1','143','865',382,'Retail Sale Id 1310113',1996.80,0.00,0.00,0.00,70.40,'2021-12-10 09:40:58','',''),(2228884,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.20,0.00,'2021-12-10 09:40:58','',''),(2228963,'1','143','865',382,'Retail Sale Id 1310148',1116.96,0.00,0.00,0.00,39.38,'2021-12-10 09:45:04','',''),(2228964,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.79,0.00,'2021-12-10 09:45:04','',''),(2228999,'1','143','865',382,'Retail Sale Id 1310180',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 09:47:56','',''),(2229000,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 09:47:56','',''),(2229017,'1','143','865',382,'Retail Sale Id 1310188',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 09:49:01','',''),(2229018,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 09:49:01','',''),(2229057,'1','143','865',382,'Retail Sale Id 1310203',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 09:50:53','',''),(2229058,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 09:50:53','',''),(2229101,'1','143','865',382,'Retail Sale Id 1310227',3120.00,0.00,0.00,0.00,110.00,'2021-12-10 09:53:27','',''),(2229102,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 09:53:27','',''),(2229133,'1','143','865',382,'Retail Sale Id 1310241',998.40,0.00,0.00,0.00,35.20,'2021-12-10 09:54:59','',''),(2229134,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 09:54:59','',''),(2229225,'1','143','865',382,'Retail Sale Id 1310282',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 10:01:07','',''),(2229226,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:01:07','',''),(2229255,'1','143','865',382,'Retail Sale Id 1310299',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 10:03:09','',''),(2229256,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:03:09','',''),(2229292,'1','143','865',382,'Retail Sale Id 1310310',1697.28,0.00,0.00,0.00,59.84,'2021-12-10 10:04:51','',''),(2229293,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.72,0.00,'2021-12-10 10:04:51','',''),(2229337,'1','143','865',382,'Retail Sale Id 1310329',1560.00,0.00,0.00,0.00,55.00,'2021-12-10 10:07:31','',''),(2229338,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-10 10:07:31','',''),(2229363,'1','143','865',382,'Retail Sale Id 1310343',2496.00,0.00,0.00,0.00,88.00,'2021-12-10 10:09:02','',''),(2229364,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 10:09:02','',''),(2229393,'1','143','865',382,'Retail Sale Id 1310359',998.40,0.00,0.00,0.00,35.20,'2021-12-10 10:10:48','',''),(2229394,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 10:10:48','',''),(2229423,'1','143','865',382,'Retail Sale Id 1310374',6995.04,0.00,0.00,0.00,246.62,'2021-12-10 10:11:51','',''),(2229424,'1','143','865',382,'Retail sales',0.00,0.00,0.00,11.21,0.00,'2021-12-10 10:11:51','',''),(2229453,'1','143','865',382,'Retail Sale Id 1310389',1597.44,0.00,0.00,0.00,56.32,'2021-12-10 10:13:49','',''),(2229454,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.56,0.00,'2021-12-10 10:13:49','',''),(2229508,'1','143','865',382,'Retail Sale Id 1310408',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 10:15:40','',''),(2229509,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 10:15:40','',''),(2229547,'1','143','865',382,'Retail Sale Id 1310426',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 10:17:50','',''),(2229548,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:17:50','',''),(2229581,'1','143','865',382,'Retail Sale Id 1310444',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 10:20:04','',''),(2229582,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:20:04','',''),(2229701,'1','143','865',382,'Retail Sale Id 1310500',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 10:25:59','',''),(2229702,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 10:25:59','',''),(2229743,'1','143','865',382,'Retail Sale Id 1310516',3120.00,0.00,0.00,0.00,110.00,'2021-12-10 10:28:40','',''),(2229744,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 10:28:40','',''),(2229765,'1','143','865',382,'Retail Sale Id 1310531',1497.60,0.00,0.00,0.00,52.80,'2021-12-10 10:30:16','',''),(2229766,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-10 10:30:16','',''),(2230079,'1','143','865',382,'Retail Sale Id 1310665',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 10:48:40','',''),(2230080,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:48:40','',''),(2230114,'1','143','865',382,'Retail Sale Id 1310684',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 10:50:19','',''),(2230115,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 10:50:19','',''),(2230151,'1','143','865',382,'Retail Sale Id 1310697',1248.00,0.00,0.00,0.00,44.00,'2021-12-10 10:51:58','',''),(2230152,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 10:51:58','',''),(2230202,'1','143','865',382,'Retail Sale Id 1310715',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 10:54:24','',''),(2230203,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:54:24','',''),(2230226,'1','143','865',382,'Retail Sale Id 1310730',4992.00,0.00,0.00,0.00,176.00,'2021-12-10 10:56:30','',''),(2230227,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-10 10:56:30','',''),(2230260,'1','143','865',382,'Retail Sale Id 1310754',9360.00,0.00,0.00,0.00,330.00,'2021-12-10 10:59:00','',''),(2230261,'1','143','865',382,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-10 10:59:01','',''),(2230300,'1','143','865',382,'Retail Sale Id 1310773',1497.60,0.00,0.00,0.00,52.80,'2021-12-10 11:01:08','',''),(2230301,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-10 11:01:08','',''),(2230338,'1','143','865',382,'Retail Sale Id 1310790',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 11:03:08','',''),(2230339,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 11:03:08','',''),(2230400,'1','143','865',382,'Retail Sale Id 1310816',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 11:05:49','',''),(2230401,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 11:05:49','',''),(2230416,'1','143','865',382,'Retail Sale Id 1310824',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 11:07:14','',''),(2230417,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:07:14','',''),(2230475,'1','143','865',382,'Retail Sale Id 1310837',6864.00,0.00,0.00,0.00,242.00,'2021-12-10 11:09:32','',''),(2230476,'1','143','865',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-10 11:09:32','',''),(2230496,'1','143','865',382,'Retail Sale Id 1310847',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 11:11:12','',''),(2230497,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:11:12','',''),(2230522,'1','143','865',382,'Retail Sale Id 1310859',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 11:13:19','',''),(2230523,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:13:19','',''),(2230554,'1','143','865',382,'Retail Sale Id 1310879',3120.00,0.00,0.00,0.00,110.00,'2021-12-10 11:15:33','',''),(2230555,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 11:15:33','',''),(2230594,'1','143','865',382,'Retail Sale Id 1310895',6240.00,0.00,0.00,0.00,220.00,'2021-12-10 11:17:52','',''),(2230595,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 11:17:52','',''),(2230676,'1','143','865',382,'Retail Sale Id 1310919',5616.00,0.00,0.00,0.00,198.00,'2021-12-10 11:20:46','',''),(2230677,'1','143','865',382,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-10 11:20:46','',''),(2230709,'1','143','865',382,'Retail Sale Id 1310927',2496.00,0.00,0.00,0.00,88.00,'2021-12-10 11:23:19','',''),(2230710,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 11:23:19','',''),(2230723,'1','143','865',382,'Retail Sale Id 1310937',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 11:24:38','',''),(2230724,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:24:38','',''),(2230761,'1','143','865',382,'Retail Sale Id 1310956',13728.00,0.00,0.00,0.00,484.00,'2021-12-10 11:27:16','',''),(2230762,'1','143','865',382,'Retail sales',0.00,0.00,0.00,22.00,0.00,'2021-12-10 11:27:16','',''),(2230779,'1','143','865',382,'Retail Sale Id 1310965',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 11:29:04','',''),(2230780,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 11:29:04','',''),(2230799,'1','143','865',382,'Retail Sale Id 1310979',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 11:30:47','',''),(2230800,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 11:30:47','',''),(2230819,'1','143','865',382,'Retail Sale Id 1310989',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 11:32:12','',''),(2230820,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:32:12','',''),(2230854,'1','143','865',382,'Retail Sale Id 1311008',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 11:33:48','',''),(2230855,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:33:48','',''),(2230913,'1','143','865',382,'Retail Sale Id 1311024',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 11:37:35','',''),(2230914,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 11:37:35','',''),(2230933,'1','143','865',382,'Retail Sale Id 1311050',1248.00,0.00,0.00,0.00,44.00,'2021-12-10 11:39:03','',''),(2230934,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 11:39:03','',''),(2230969,'1','143','865',382,'Retail Sale Id 1311062',4368.00,0.00,0.00,0.00,154.00,'2021-12-10 11:42:37','',''),(2230970,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-10 11:42:37','',''),(2231019,'1','143','865',382,'Retail Sale Id 1311082',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 11:47:07','',''),(2231020,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 11:47:07','',''),(2231055,'1','143','865',382,'Retail Sale Id 1311116',2003.04,0.00,0.00,0.00,70.62,'2021-12-10 11:48:56','',''),(2231056,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 11:48:56','',''),(2231067,'1','143','865',382,'Retail Sale Id 1311123',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 11:50:03','',''),(2231068,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 11:50:03','',''),(2231075,'1','143','865',382,'Retail Sale Id 1311127',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 11:51:21','',''),(2231076,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 11:51:21','',''),(2231095,'1','143','865',382,'Retail Sale Id 1311137',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 11:53:03','',''),(2231096,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:53:03','',''),(2231122,'1','143','865',382,'Retail Sale Id 1311150',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 11:54:49','',''),(2231123,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 11:54:49','',''),(2231154,'1','143','865',382,'Retail Sale Id 1311164',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 11:56:17','',''),(2231155,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 11:56:17','',''),(2231185,'1','143','865',382,'Retail Sale Id 1311179',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 11:58:02','',''),(2231186,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 11:58:02','',''),(2231240,'1','143','865',382,'Retail Sale Id 1311205',24000.00,0.00,0.00,0.00,-80.00,'2021-12-10 12:02:36','',''),(2231241,'1','143','865',382,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-10 12:02:36','',''),(2231276,'1','143','865',382,'Retail Sale Id 1311227',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 12:05:41','',''),(2231277,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 12:05:41','',''),(2231316,'1','143','865',382,'Retail Sale Id 1311247',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 12:07:46','',''),(2231317,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 12:07:46','',''),(2231381,'1','143','865',382,'Retail Sale Id 1311273',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 12:12:30','',''),(2231382,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 12:12:30','',''),(2231401,'1','143','865',382,'Retail Sale Id 1311283',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 12:14:12','',''),(2231402,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 12:14:12','',''),(2231413,'1','143','865',382,'Retail Sale Id 1311291',3120.00,0.00,0.00,0.00,110.00,'2021-12-10 12:15:38','',''),(2231414,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 12:15:38','',''),(2231503,'1','143','865',382,'Retail Sale Id 1311343',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 12:23:28','',''),(2231504,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 12:23:28','',''),(2231664,'1','143','865',382,'Retail Sale Id 1311438',4368.00,0.00,0.00,0.00,154.00,'2021-12-10 12:39:23','',''),(2231665,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-10 12:39:23','',''),(2231698,'1','143','865',382,'Retail Sale Id 1311448',3120.00,0.00,0.00,0.00,110.00,'2021-12-10 12:42:25','',''),(2231699,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 12:42:25','',''),(2231710,'1','143','865',382,'Retail Sale Id 1311464',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 12:43:52','',''),(2231711,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 12:43:52','',''),(2231767,'1','143','865',382,'Retail Sale Id 1311485',2995.20,0.00,0.00,0.00,105.60,'2021-12-10 12:47:48','',''),(2231768,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.80,0.00,'2021-12-10 12:47:48','',''),(2232026,'1','143','865',382,'Retail Sale Id 1311615',2496.00,0.00,0.00,0.00,88.00,'2021-12-10 13:05:41','',''),(2232027,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 13:05:41','',''),(2232054,'1','143','865',382,'Retail Sale Id 1311633',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 13:07:25','',''),(2232055,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 13:07:25','',''),(2232079,'1','143','865',382,'Retail Sale Id 1311644',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 13:09:13','',''),(2232080,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:09:13','',''),(2232373,'1','143','865',382,'Retail Sale Id 1311754',2502.24,0.00,0.00,0.00,88.22,'2021-12-10 13:24:34','',''),(2232374,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-10 13:24:34','',''),(2232497,'1','143','865',382,'Retail Sale Id 1311834',4992.00,0.00,0.00,0.00,176.00,'2021-12-10 13:34:12','',''),(2232498,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-10 13:34:12','',''),(2232537,'1','143','865',382,'Retail Sale Id 1311858',6240.00,0.00,0.00,0.00,220.00,'2021-12-10 13:36:03','',''),(2232538,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 13:36:03','',''),(2232585,'1','143','865',382,'Retail Sale Id 1311870',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 13:37:54','',''),(2232586,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 13:37:54','',''),(2232605,'1','143','865',382,'Retail Sale Id 1311882',4368.00,0.00,0.00,0.00,154.00,'2021-12-10 13:39:02','',''),(2232606,'1','143','865',382,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-10 13:39:02','',''),(2232642,'1','143','865',382,'Retail Sale Id 1311897',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 13:40:51','',''),(2232643,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:40:51','',''),(2232671,'1','143','865',382,'Retail Sale Id 1311909',6240.00,0.00,0.00,0.00,220.00,'2021-12-10 13:41:43','',''),(2232672,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 13:41:43','',''),(2232703,'1','143','865',382,'Retail Sale Id 1311924',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 13:43:37','',''),(2232704,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 13:43:37','',''),(2232809,'1','143','865',382,'Retail Sale Id 1311964',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 13:47:47','',''),(2232810,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:47:47','',''),(2232839,'1','143','865',382,'Retail Sale Id 1311982',998.40,0.00,0.00,0.00,35.20,'2021-12-10 13:49:55','',''),(2232840,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 13:49:55','',''),(2232923,'1','143','865',382,'Retail Sale Id 1312016',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 13:53:48','',''),(2232924,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 13:53:48','',''),(2232953,'1','143','865',382,'Retail Sale Id 1312031',998.40,0.00,0.00,0.00,35.20,'2021-12-10 13:55:29','',''),(2232954,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 13:55:29','',''),(2232979,'1','143','865',382,'Retail Sale Id 1312043',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 13:56:45','',''),(2232980,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:56:45','',''),(2233043,'1','143','865',382,'Retail Sale Id 1312073',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 13:59:29','',''),(2233044,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 13:59:29','',''),(2233079,'1','143','865',382,'Retail Sale Id 1312084',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 14:01:04','',''),(2233080,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 14:01:04','',''),(2233148,'1','143','865',382,'Retail Sale Id 1312100',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 14:02:52','',''),(2233149,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:02:52','',''),(2233193,'1','143','865',382,'Retail Sale Id 1312117',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 14:04:35','',''),(2233194,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:04:35','',''),(2233221,'1','143','865',382,'Retail Sale Id 1312129',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 14:06:23','',''),(2233222,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 14:06:23','',''),(2233305,'1','143','865',382,'Retail Sale Id 1312162',7488.00,0.00,0.00,0.00,264.00,'2021-12-10 14:12:43','',''),(2233306,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-10 14:12:43','',''),(2233411,'1','143','865',382,'Retail Sale Id 1312221',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 14:17:41','',''),(2233412,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:17:41','',''),(2233437,'1','143','865',382,'Retail Sale Id 1312232',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 14:19:23','',''),(2233438,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:19:23','',''),(2233471,'1','143','865',382,'Retail Sale Id 1312251',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 14:21:00','',''),(2233472,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:21:00','',''),(2233502,'1','143','865',382,'Retail Sale Id 1312262',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 14:22:12','',''),(2233503,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:22:12','',''),(2233547,'1','143','865',382,'Retail Sale Id 1312281',3120.00,0.00,0.00,0.00,110.00,'2021-12-10 14:24:24','',''),(2233548,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 14:24:24','',''),(2233699,'1','143','865',382,'Retail Sale Id 1312339',1996.80,0.00,0.00,0.00,70.40,'2021-12-10 14:29:55','',''),(2233700,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.20,0.00,'2021-12-10 14:29:55','',''),(2233733,'1','143','865',382,'Retail Sale Id 1312356',2995.20,0.00,0.00,0.00,105.60,'2021-12-10 14:31:38','',''),(2233734,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.80,0.00,'2021-12-10 14:31:38','',''),(2233803,'1','143','865',382,'Retail Sale Id 1312386',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 14:34:40','',''),(2233804,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:34:40','',''),(2233866,'1','143','865',382,'Retail Sale Id 1312413',6864.00,0.00,0.00,0.00,242.00,'2021-12-10 14:37:13','',''),(2233867,'1','143','865',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-10 14:37:13','',''),(2233904,'1','143','865',382,'Retail Sale Id 1312428',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 14:38:53','',''),(2233905,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:38:53','',''),(2233935,'1','143','865',382,'Retail Sale Id 1312439',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 14:40:08','',''),(2233936,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:40:08','',''),(2233995,'1','143','865',382,'Retail Sale Id 1312464',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 14:42:15','',''),(2233996,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:42:15','',''),(2234031,'1','143','865',382,'Retail Sale Id 1312483',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 14:43:36','',''),(2234032,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 14:43:36','',''),(2234061,'1','143','865',382,'Retail Sale Id 1312501',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 14:45:04','',''),(2234062,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:45:04','',''),(2234121,'1','143','865',382,'Retail Sale Id 1312519',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 14:46:57','',''),(2234122,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:46:57','',''),(2234167,'1','143','865',382,'Retail Sale Id 1312545',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 14:48:48','',''),(2234168,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 14:48:48','',''),(2234219,'1','143','865',382,'Retail Sale Id 1312568',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 14:50:54','',''),(2234220,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 14:50:54','',''),(2234250,'1','143','865',382,'Retail Sale Id 1312582',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 14:52:23','',''),(2234251,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:52:23','',''),(2234298,'1','143','865',382,'Retail Sale Id 1312605',3120.00,0.00,0.00,0.00,110.00,'2021-12-10 14:54:48','',''),(2234299,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 14:54:48','',''),(2234472,'1','143','865',382,'Retail Sale Id 1312697',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 15:05:35','',''),(2234473,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:05:35','',''),(2234528,'1','143','865',382,'Retail Sale Id 1312719',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 15:07:51','',''),(2234529,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:07:51','',''),(2234554,'1','143','865',382,'Retail Sale Id 1312734',2496.00,0.00,0.00,0.00,88.00,'2021-12-10 15:09:33','',''),(2234555,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 15:09:33','',''),(2234659,'1','143','865',382,'Retail Sale Id 1312778',6864.00,0.00,0.00,0.00,242.00,'2021-12-10 15:13:35','',''),(2234660,'1','143','865',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-10 15:13:35','',''),(2234725,'1','143','866',382,'Retail Sale Id 1312812',998.40,0.00,0.00,0.00,35.20,'2021-12-10 15:16:25','',''),(2234726,'1','143','866',382,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 15:16:25','',''),(2234843,'1','143','866',382,'Retail Sale Id 1312876',1497.60,0.00,0.00,0.00,52.80,'2021-12-10 15:21:31','',''),(2234844,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-10 15:21:31','',''),(2234914,'1','143','865',382,'Retail Sale Id 1312912',1191.84,0.00,0.00,0.00,42.02,'2021-12-10 15:24:15','',''),(2234915,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.91,0.00,'2021-12-10 15:24:15','',''),(2234954,'1','143','865',382,'Retail Sale Id 1312938',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 15:25:22','',''),(2234955,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:25:22','',''),(2235157,'1','143','866',382,'Retail Sale Id 1313019',1248.00,0.00,0.00,0.00,44.00,'2021-12-10 15:32:38','',''),(2235158,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 15:32:38','',''),(2235199,'1','143','866',382,'Retail Sale Id 1313041',6864.00,0.00,0.00,0.00,242.00,'2021-12-10 15:34:10','',''),(2235200,'1','143','866',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-10 15:34:10','',''),(2235237,'1','143','865',382,'Retail Sale Id 1313055',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 15:36:10','',''),(2235238,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 15:36:10','',''),(2235265,'1','143','865',382,'Retail Sale Id 1313071',3120.00,0.00,0.00,0.00,110.00,'2021-12-10 15:37:15','',''),(2235266,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 15:37:15','',''),(2235331,'1','143','865',382,'Retail Sale Id 1313101',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 15:40:13','',''),(2235332,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 15:40:13','',''),(2235367,'1','143','865',382,'Retail Sale Id 1313115',1248.00,0.00,0.00,0.00,44.00,'2021-12-10 15:41:41','',''),(2235368,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 15:41:41','',''),(2235427,'1','143','866',382,'Retail Sale Id 1313147',6240.00,0.00,0.00,0.00,220.00,'2021-12-10 15:43:54','',''),(2235428,'1','143','866',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 15:43:54','',''),(2235517,'1','143','866',382,'Retail Sale Id 1313204',998.40,0.00,0.00,0.00,35.20,'2021-12-10 15:48:30','',''),(2235518,'1','143','866',382,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 15:48:30','',''),(2235542,'1','143','866',382,'Retail Sale Id 1313221',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 15:49:55','',''),(2235543,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:49:55','',''),(2235620,'1','143','866',382,'Retail Sale Id 1313260',3120.00,0.00,0.00,0.00,110.00,'2021-12-10 15:54:01','',''),(2235621,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 15:54:01','',''),(2235652,'1','143','866',382,'Retail Sale Id 1313283',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 15:55:19','',''),(2235653,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:55:19','',''),(2235688,'1','143','866',382,'Retail Sale Id 1313296',1248.00,0.00,0.00,0.00,44.00,'2021-12-10 15:56:52','',''),(2235689,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 15:56:52','',''),(2235739,'1','143','866',382,'Retail Sale Id 1313314',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 15:59:17','',''),(2235740,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:59:17','',''),(2235788,'1','143','866',382,'Retail Sale Id 1313349',4992.00,0.00,0.00,0.00,176.00,'2021-12-10 16:01:06','',''),(2235789,'1','143','866',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-10 16:01:06','',''),(2235812,'1','143','866',382,'Retail Sale Id 1313364',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 16:02:43','',''),(2235813,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:02:43','',''),(2235889,'1','143','866',382,'Retail Sale Id 1313389',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 16:05:39','',''),(2235890,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:05:39','',''),(2235918,'1','143','866',382,'Retail Sale Id 1313403',7488.00,0.00,0.00,0.00,264.00,'2021-12-10 16:07:05','',''),(2235919,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-10 16:07:05','',''),(2236047,'1','143','866',382,'Retail Sale Id 1313462',15600.00,0.00,0.00,0.00,550.00,'2021-12-10 16:12:47','',''),(2236050,'1','143','866',382,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 16:12:47','',''),(2236081,'1','143','866',382,'Retail Sale Id 1313485',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 16:14:28','',''),(2236082,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 16:14:28','',''),(2236112,'1','143','866',382,'Retail Sale Id 1313502',2496.00,0.00,0.00,0.00,88.00,'2021-12-10 16:16:05','',''),(2236113,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 16:16:05','',''),(2236195,'1','143','866',382,'Retail Sale Id 1313544',1248.00,0.00,0.00,0.00,44.00,'2021-12-10 16:19:47','',''),(2236196,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 16:19:47','',''),(2236284,'1','143','866',382,'Retail Sale Id 1313601',1248.00,0.00,0.00,0.00,44.00,'2021-12-10 16:23:32','',''),(2236285,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 16:23:32','',''),(2236363,'1','143','866',382,'Retail Sale Id 1313626',1248.00,0.00,0.00,0.00,44.00,'2021-12-10 16:26:45','',''),(2236364,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 16:26:45','',''),(2236399,'1','143','866',382,'Retail Sale Id 1313654',2496.00,0.00,0.00,0.00,88.00,'2021-12-10 16:28:21','',''),(2236400,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 16:28:21','',''),(2236441,'1','143','865',382,'Retail Sale Id 1313673',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 16:30:34','',''),(2236442,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 16:30:34','',''),(2236471,'1','143','865',382,'Retail Sale Id 1313690',1872.00,0.00,0.00,0.00,66.00,'2021-12-10 16:31:47','',''),(2236472,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:31:47','',''),(2236497,'1','143','865',382,'Retail Sale Id 1313704',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 16:33:06','',''),(2236498,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:33:06','',''),(2236528,'1','143','865',382,'Retail Sale Id 1313715',2496.00,0.00,0.00,0.00,88.00,'2021-12-10 16:34:41','',''),(2236529,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 16:34:41','',''),(2236555,'1','143','865',382,'Retail Sale Id 1313726',2496.00,0.00,0.00,0.00,88.00,'2021-12-10 16:36:01','',''),(2236556,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 16:36:01','',''),(2236571,'1','143','865',382,'Retail Sale Id 1313733',3744.00,0.00,0.00,0.00,132.00,'2021-12-10 16:36:56','',''),(2236572,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 16:36:56','',''),(2236612,'1','143','865',382,'Retail Sale Id 1313749',2003.04,0.00,0.00,0.00,70.62,'2021-12-10 16:38:42','',''),(2236613,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 16:38:42','',''),(2236698,'1','143','865',382,'Retail Sale Id 1313780',1248.00,0.00,0.00,0.00,44.00,'2021-12-10 16:43:04','',''),(2236699,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 16:43:04','',''),(2236746,'1','143','865',382,'Retail Sale Id 1313809',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 16:45:56','',''),(2236747,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:45:56','',''),(2236768,'1','143','865',382,'Retail Sale Id 1313824',7800.00,0.00,0.00,0.00,275.00,'2021-12-10 16:47:06','',''),(2236769,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:47:06','',''),(2236802,'1','143','865',382,'Retail Sale Id 1313838',11544.00,0.00,0.00,0.00,407.00,'2021-12-10 16:49:43','',''),(2236803,'1','143','865',382,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-10 16:49:43','',''),(2236840,'1','143','865',382,'Retail Sale Id 1313860',3120.00,0.00,0.00,0.00,110.00,'2021-12-10 16:51:52','',''),(2236841,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 16:51:52','',''),(2237429,'1','143','865',382,'Return of Retail Sale Id 1313838',0.00,11544.00,18.50,0.00,-407.00,'2021-12-10 17:36:56','',''),(2240125,'1','143',NULL,382,'Purchased from AA RANO NIGERIA LIMITED',0.00,11538080.00,19490.00,0.00,0.00,'2021-12-11 07:49:26','',''),(2240272,'1','143',NULL,382,'Reception corrector for bridging 126983',0.00,0.00,0.00,19490.00,0.00,'2021-12-11 07:54:51','',''),(2240273,'1','143','866',382,'Received from bridging 126983',0.00,0.00,19490.00,0.00,0.00,'2021-12-11 07:54:51','',''),(2240333,'1','143','866',382,'Retail Sale Id 1315367',3120.00,0.00,0.00,0.00,160.00,'2021-12-11 07:57:24','',''),(2240334,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 07:57:24','',''),(2240679,'1','143','865',382,'Retail Sale Id 1315501',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 08:12:09','',''),(2240680,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 08:12:09','',''),(2240715,'1','143','865',382,'Retail Sale Id 1315516',998.40,0.00,0.00,0.00,51.20,'2021-12-11 08:13:51','',''),(2240716,'1','143','865',382,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 08:13:51','',''),(2240737,'1','143','865',382,'Retail Sale Id 1315531',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 08:14:55','',''),(2240738,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 08:14:55','',''),(2240771,'1','143','865',382,'Retail Sale Id 1315551',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 08:16:23','',''),(2240772,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 08:16:23','',''),(2240797,'1','143','866',382,'Retail Sale Id 1315567',59592.00,0.00,0.00,0.00,3056.00,'2021-12-11 08:17:46','',''),(2240798,'1','143','866',382,'Retail sales',0.00,0.00,0.00,95.50,0.00,'2021-12-11 08:17:46','',''),(2240862,'1','143','865',382,'Retail Sale Id 1315604',7488.00,0.00,0.00,0.00,384.00,'2021-12-11 08:20:47','',''),(2240863,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-11 08:20:47','',''),(2240896,'1','143','865',382,'Retail Sale Id 1315624',1248.00,0.00,0.00,0.00,64.00,'2021-12-11 08:22:23','',''),(2240897,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 08:22:23','',''),(2241042,'1','143','865',382,'Retail Sale Id 1315694',3001.44,0.00,0.00,0.00,153.92,'2021-12-11 08:30:34','',''),(2241043,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-11 08:30:34','',''),(2241459,'1','143','865',382,'Retail Sale Id 1315876',2496.00,0.00,0.00,0.00,128.00,'2021-12-11 08:50:16','',''),(2241460,'1','143','865',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 08:50:16','',''),(2241573,'1','143','865',382,'Retail Sale Id 1315925',6240.00,0.00,0.00,0.00,320.00,'2021-12-11 08:56:08','',''),(2241574,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 08:56:08','',''),(2241652,'1','143','865',382,'Retail Sale Id 1315957',6240.00,0.00,0.00,0.00,320.00,'2021-12-11 08:58:55','',''),(2241653,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 08:58:55','',''),(2241939,'1','143','865',382,'Retail Sale Id 1316098',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 09:11:10','',''),(2241940,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 09:11:10','',''),(2242062,'1','143','865',382,'Retail Sale Id 1316149',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 09:15:54','',''),(2242063,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 09:15:54','',''),(2242088,'1','143','865',382,'Retail Sale Id 1316177',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 09:17:23','',''),(2242089,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 09:17:23','',''),(2242118,'1','143','865',382,'Retail Sale Id 1316189',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 09:18:41','',''),(2242119,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:18:41','',''),(2242166,'1','143','865',382,'Retail Sale Id 1316206',3999.84,0.00,0.00,0.00,205.12,'2021-12-11 09:20:58','',''),(2242167,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-11 09:20:58','',''),(2242205,'1','143','865',382,'Retail Sale Id 1316217',3120.00,0.00,0.00,0.00,160.00,'2021-12-11 09:22:40','',''),(2242206,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 09:22:40','',''),(2242271,'1','143','865',382,'Retail Sale Id 1316253',3120.00,0.00,0.00,0.00,160.00,'2021-12-11 09:26:33','',''),(2242272,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 09:26:33','',''),(2242335,'1','143','866',382,'Retail Sale Id 1316284',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 09:30:46','',''),(2242336,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 09:30:46','',''),(2242490,'1','143','866',382,'Retail Sale Id 1316366',2496.00,0.00,0.00,0.00,128.00,'2021-12-11 09:37:40','',''),(2242491,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 09:37:40','',''),(2242626,'1','143','866',382,'Retail Sale Id 1316439',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 09:44:02','',''),(2242627,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 09:44:02','',''),(2242666,'1','143','866',382,'Retail Sale Id 1316457',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 09:45:30','',''),(2242667,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 09:45:30','',''),(2242726,'1','143','866',382,'Retail Sale Id 1316488',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 09:48:27','',''),(2242727,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 09:48:27','',''),(2242912,'1','143','866',382,'Retail Sale Id 1316574',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 09:58:11','',''),(2242913,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 09:58:11','',''),(2242971,'1','143','866',382,'Retail Sale Id 1316606',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 10:00:58','',''),(2242972,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 10:00:58','',''),(2243021,'1','143','866',382,'Retail Sale Id 1316630',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 10:03:28','',''),(2243022,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 10:03:28','',''),(2243070,'1','143','866',382,'Retail Sale Id 1316652',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 10:06:33','',''),(2243071,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 10:06:33','',''),(2243180,'1','143','866',382,'Retail Sale Id 1316687',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 10:10:31','',''),(2243181,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 10:10:31','',''),(2243327,'1','143','865',382,'Retail Sale Id 1316752',6552.00,0.00,0.00,0.00,336.00,'2021-12-11 10:16:44','',''),(2243328,'1','143','865',382,'Retail sales',0.00,0.00,0.00,10.50,0.00,'2021-12-11 10:16:44','',''),(2243451,'1','143','865',382,'Retail Sale Id 1316790',2003.04,0.00,0.00,0.00,102.72,'2021-12-11 10:23:11','',''),(2243452,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-11 10:23:11','',''),(2243475,'1','143','866',382,'Retail Sale Id 1316817',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 10:24:15','',''),(2243476,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 10:24:15','',''),(2243535,'1','143','865',382,'Retail Sale Id 1316850',10608.00,0.00,0.00,0.00,544.00,'2021-12-11 10:27:13','',''),(2243536,'1','143','865',382,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-11 10:27:13','',''),(2243601,'1','143','865',382,'Retail Sale Id 1316880',9672.00,0.00,0.00,0.00,496.00,'2021-12-11 10:30:10','',''),(2243602,'1','143','865',382,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-11 10:30:10','',''),(2243619,'1','143','865',382,'Retail Sale Id 1316889',2003.04,0.00,0.00,0.00,102.72,'2021-12-11 10:31:33','',''),(2243620,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-11 10:31:33','',''),(2243647,'1','143','865',382,'Retail Sale Id 1316902',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 10:33:21','',''),(2243648,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 10:33:21','',''),(2243671,'1','143','865',382,'Retail Sale Id 1316914',6864.00,0.00,0.00,0.00,352.00,'2021-12-11 10:34:50','',''),(2243672,'1','143','865',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-11 10:34:50','',''),(2243699,'1','143','865',382,'Retail Sale Id 1316930',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 10:36:22','',''),(2243700,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 10:36:22','',''),(2243736,'1','143','865',382,'Retail Sale Id 1316944',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 10:38:06','',''),(2243737,'1','143','865',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 10:38:06','',''),(2243744,'1','143','865',382,'Retail Sale Id 1316948',7488.00,0.00,0.00,0.00,384.00,'2021-12-11 10:39:00','',''),(2243745,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-11 10:39:00','',''),(2243784,'1','143','865',382,'Retail Sale Id 1316965',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 10:40:46','',''),(2243785,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 10:40:46','',''),(2243796,'1','143','866',382,'Retail Sale Id 1316976',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 10:41:43','',''),(2243797,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 10:41:43','',''),(2243834,'1','143','866',382,'Retail Sale Id 1316994',5616.00,0.00,0.00,0.00,288.00,'2021-12-11 10:43:06','',''),(2243835,'1','143','866',382,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-11 10:43:06','',''),(2243928,'1','143','866',382,'Retail Sale Id 1317045',10501.92,0.00,0.00,0.00,538.56,'2021-12-11 10:48:40','',''),(2243929,'1','143','866',382,'Retail sales',0.00,0.00,0.00,16.83,0.00,'2021-12-11 10:48:41','',''),(2244016,'1','143','865',382,'Retail Sale Id 1317089',6864.00,0.00,0.00,0.00,352.00,'2021-12-11 10:54:02','',''),(2244017,'1','143','865',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-11 10:54:02','',''),(2244058,'1','143','865',382,'Retail Sale Id 1317107',3120.00,0.00,0.00,0.00,160.00,'2021-12-11 10:56:21','',''),(2244059,'1','143','865',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 10:56:21','',''),(2244074,'1','143','866',382,'Retail Sale Id 1317119',6864.00,0.00,0.00,0.00,352.00,'2021-12-11 10:57:15','',''),(2244075,'1','143','866',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-11 10:57:15','',''),(2244098,'1','143','865',382,'Retail Sale Id 1317128',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 10:58:25','',''),(2244099,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 10:58:25','',''),(2244136,'1','143','866',382,'Retail Sale Id 1317140',6864.00,0.00,0.00,0.00,352.00,'2021-12-11 10:59:47','',''),(2244137,'1','143','866',382,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-11 10:59:47','',''),(2244172,'1','143','865',382,'Retail Sale Id 1317155',4992.00,0.00,0.00,0.00,256.00,'2021-12-11 11:01:13','',''),(2244173,'1','143','865',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-11 11:01:13','',''),(2244203,'1','143','866',382,'Retail Sale Id 1317165',3001.44,0.00,0.00,0.00,153.92,'2021-12-11 11:02:39','',''),(2244204,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-11 11:02:39','',''),(2244257,'1','143','865',382,'Retail Sale Id 1317191',1248.00,0.00,0.00,0.00,64.00,'2021-12-11 11:04:54','',''),(2244258,'1','143','865',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 11:04:54','',''),(2244277,'1','143','865',382,'Retail Sale Id 1317203',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 11:06:07','',''),(2244278,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 11:06:07','',''),(2244307,'1','143','866',382,'Retail Sale Id 1317217',9672.00,0.00,0.00,0.00,496.00,'2021-12-11 11:07:42','',''),(2244308,'1','143','866',382,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-11 11:07:42','',''),(2244345,'1','143','865',382,'Retail Sale Id 1317236',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 11:09:28','',''),(2244346,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 11:09:28','',''),(2244391,'1','143','866',382,'Retail Sale Id 1317264',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 11:11:56','',''),(2244392,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:11:56','',''),(2244474,'1','143','866',382,'Retail Sale Id 1317297',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 11:16:14','',''),(2244475,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 11:16:14','',''),(2244734,'1','143','866',382,'Retail Sale Id 1317420',998.40,0.00,0.00,0.00,51.20,'2021-12-11 11:28:38','',''),(2244735,'1','143','866',382,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 11:28:38','',''),(2245329,'1','143','865',382,'Retail Sale Id 1317736',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 12:05:57','',''),(2245330,'1','143','865',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 12:05:57','',''),(2245959,'1','143','865',382,'Retail Sale Id 1318096',3999.84,0.00,0.00,0.00,205.12,'2021-12-11 12:44:10','',''),(2245960,'1','143','865',382,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-11 12:44:10','',''),(2245989,'1','143','866',382,'Retail Sale Id 1318112',1248.00,0.00,0.00,0.00,64.00,'2021-12-11 12:45:47','',''),(2245990,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 12:45:47','',''),(2246120,'1','143','866',382,'Retail Sale Id 1318179',1248.00,0.00,0.00,0.00,64.00,'2021-12-11 12:55:57','',''),(2246121,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 12:55:57','',''),(2246146,'1','143','866',382,'Retail Sale Id 1318189',102600.00,0.00,0.00,0.00,1368.00,'2021-12-11 12:57:35','',''),(2246147,'1','143','866',382,'Retail sales',0.00,0.00,0.00,171.00,0.00,'2021-12-11 12:57:35','',''),(2246901,'1','143','866',382,'Retail Sale Id 1318539',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 13:50:37','',''),(2246902,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 13:50:37','',''),(2246949,'1','143','866',382,'Retail Sale Id 1318558',998.40,0.00,0.00,0.00,51.20,'2021-12-11 13:52:59','',''),(2246950,'1','143','866',382,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 13:52:59','',''),(2246968,'1','143','866',382,'Retail Sale Id 1318567',2003.04,0.00,0.00,0.00,102.72,'2021-12-11 13:54:19','',''),(2246969,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-11 13:54:19','',''),(2247184,'1','143','866',382,'Retail Sale Id 1318686',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 14:08:17','',''),(2247185,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 14:08:17','',''),(2247319,'1','143','866',382,'Retail Sale Id 1318747',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 14:14:59','',''),(2247320,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 14:14:59','',''),(2247410,'1','143','866',382,'Retail Sale Id 1318797',3120.00,0.00,0.00,0.00,160.00,'2021-12-11 14:21:46','',''),(2247411,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 14:21:46','',''),(2247470,'1','143','866',382,'Retail Sale Id 1318821',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 14:25:21','',''),(2247471,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:25:21','',''),(2247504,'1','143','866',382,'Retail Sale Id 1318831',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 14:26:53','',''),(2247505,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 14:26:53','',''),(2247562,'1','143','866',382,'Retail Sale Id 1318871',31200.00,0.00,0.00,0.00,1600.00,'2021-12-11 14:31:53','',''),(2247563,'1','143','866',382,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 14:31:53','',''),(2247578,'1','143','866',382,'Retail Sale Id 1318881',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 14:33:23','',''),(2247579,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 14:33:23','',''),(2247598,'1','143','866',382,'Retail Sale Id 1318894',1248.00,0.00,0.00,0.00,64.00,'2021-12-11 14:34:45','',''),(2247599,'1','143','866',382,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 14:34:45','',''),(2247626,'1','143','866',382,'Retail Sale Id 1318902',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 14:36:28','',''),(2247627,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 14:36:28','',''),(2247668,'1','143','866',382,'Retail Sale Id 1318933',3120.00,0.00,0.00,0.00,160.00,'2021-12-11 14:38:29','',''),(2247669,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 14:38:29','',''),(2247790,'1','143','866',382,'Retail Sale Id 1318997',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 14:46:14','',''),(2247791,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 14:46:14','',''),(2247918,'1','143','866',382,'Retail Sale Id 1319066',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 14:53:41','',''),(2247919,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 14:53:41','',''),(2247954,'1','143','866',382,'Retail Sale Id 1319080',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 14:55:36','',''),(2247955,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 14:55:36','',''),(2247976,'1','143','866',382,'Retail Sale Id 1319094',998.40,0.00,0.00,0.00,51.20,'2021-12-11 14:56:38','',''),(2247977,'1','143','866',382,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 14:56:38','',''),(2248011,'1','143','866',382,'Retail Sale Id 1319110',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 14:58:26','',''),(2248012,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:58:27','',''),(2248059,'1','143','866',382,'Retail Sale Id 1319138',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 15:01:40','',''),(2248060,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 15:01:40','',''),(2248079,'1','143','866',382,'Retail Sale Id 1319147',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 15:02:52','',''),(2248080,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 15:02:52','',''),(2248091,'1','143','866',382,'Retail Sale Id 1319153',7488.00,0.00,0.00,0.00,384.00,'2021-12-11 15:04:21','',''),(2248092,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-11 15:04:21','',''),(2248136,'1','143','866',382,'Retail Sale Id 1319171',3120.00,0.00,0.00,0.00,160.00,'2021-12-11 15:06:23','',''),(2248137,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 15:06:23','',''),(2248418,'1','143','866',382,'Retail Sale Id 1319279',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 15:17:52','',''),(2248419,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 15:17:52','',''),(2248450,'1','143','866',382,'Retail Sale Id 1319299',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 15:19:43','',''),(2248451,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 15:19:43','',''),(2248476,'1','143','866',382,'Retail Sale Id 1319312',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 15:21:21','',''),(2248477,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 15:21:21','',''),(2248604,'1','143','866',382,'Retail Sale Id 1319385',34800.00,0.00,0.00,0.00,464.00,'2021-12-11 15:28:21','',''),(2248605,'1','143','866',382,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-11 15:28:21','',''),(2248632,'1','143','866',382,'Retail Sale Id 1319400',1996.80,0.00,0.00,0.00,102.40,'2021-12-11 15:30:05','',''),(2248633,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.20,0.00,'2021-12-11 15:30:05','',''),(2248662,'1','143','866',382,'Retail Sale Id 1319418',998.40,0.00,0.00,0.00,51.20,'2021-12-11 15:31:51','',''),(2248663,'1','143','866',382,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 15:31:51','',''),(2248698,'1','143','866',382,'Retail Sale Id 1319430',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 15:33:25','',''),(2248699,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 15:33:25','',''),(2248740,'1','143','866',382,'Retail Sale Id 1319458',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 15:35:46','',''),(2248741,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 15:35:46','',''),(2248784,'1','143','866',382,'Retail Sale Id 1319478',16224.00,0.00,0.00,0.00,832.00,'2021-12-11 15:37:52','',''),(2248785,'1','143','866',382,'Retail sales',0.00,0.00,0.00,26.00,0.00,'2021-12-11 15:37:52','',''),(2248866,'1','143','866',382,'Retail Sale Id 1319529',4998.24,0.00,0.00,0.00,256.32,'2021-12-11 15:43:08','',''),(2248867,'1','143','866',382,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-11 15:43:08','',''),(2248938,'1','143','866',382,'Retail Sale Id 1319570',4368.00,0.00,0.00,0.00,224.00,'2021-12-11 15:47:12','',''),(2248939,'1','143','866',382,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-11 15:47:12','',''),(2249007,'1','143','866',382,'Retail Sale Id 1319593',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 15:49:10','',''),(2249008,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 15:49:10','',''),(2249031,'1','143','866',382,'Retail Sale Id 1319606',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 15:50:13','',''),(2249032,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 15:50:13','',''),(2249218,'1','143','866',382,'Retail Sale Id 1319672',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 15:56:47','',''),(2249219,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 15:56:47','',''),(2249269,'1','143','866',382,'Retail Sale Id 1319696',3120.00,0.00,0.00,0.00,160.00,'2021-12-11 15:58:29','',''),(2249270,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 15:58:29','',''),(2249323,'1','143','866',382,'Retail Sale Id 1319719',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 16:00:55','',''),(2249324,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:00:55','',''),(2249375,'1','143','866',382,'Retail Sale Id 1319748',4992.00,0.00,0.00,0.00,256.00,'2021-12-11 16:02:52','',''),(2249376,'1','143','866',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-11 16:02:52','',''),(2249454,'1','143','866',382,'Retail Sale Id 1319787',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 16:06:38','',''),(2249455,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:06:38','',''),(2249520,'1','143','866',382,'Retail Sale Id 1319803',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 16:09:06','',''),(2249521,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:09:06','',''),(2249573,'1','143','866',382,'Retail Sale Id 1319843',3120.00,0.00,0.00,0.00,160.00,'2021-12-11 16:12:02','',''),(2249574,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 16:12:02','',''),(2249598,'1','143','866',382,'Retail Sale Id 1319904',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 16:13:56','',''),(2249599,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:13:56','',''),(2249645,'1','143','866',382,'Retail Sale Id 1319928',3120.00,0.00,0.00,0.00,160.00,'2021-12-11 16:16:16','',''),(2249646,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 16:16:16','',''),(2249691,'1','143','866',382,'Retail Sale Id 1319950',4992.00,0.00,0.00,0.00,256.00,'2021-12-11 16:19:29','',''),(2249692,'1','143','866',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-11 16:19:29','',''),(2249717,'1','143','866',382,'Retail Sale Id 1319964',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 16:20:59','',''),(2249718,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:20:59','',''),(2249766,'1','143','866',382,'Retail Sale Id 1319979',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 16:23:12','',''),(2249767,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:23:12','',''),(2249780,'1','143','866',382,'Retail Sale Id 1319991',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 16:24:36','',''),(2249781,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:24:36','',''),(2249811,'1','143','866',382,'Retail Sale Id 1320008',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 16:26:17','',''),(2249812,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:26:17','',''),(2249831,'1','143','866',382,'Retail Sale Id 1320018',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 16:27:35','',''),(2249832,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:27:35','',''),(2249931,'1','143','866',382,'Retail Sale Id 1320058',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 16:33:03','',''),(2249932,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:33:03','',''),(2249965,'1','143','866',382,'Retail Sale Id 1320079',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 16:34:19','',''),(2249966,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:34:19','',''),(2250010,'1','143','866',382,'Retail Sale Id 1320094',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 16:36:04','',''),(2250011,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:36:04','',''),(2250038,'1','143','866',382,'Retail Sale Id 1320103',4992.00,0.00,0.00,0.00,256.00,'2021-12-11 16:37:07','',''),(2250039,'1','143','866',382,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-11 16:37:07','',''),(2250546,'1','143','866',382,'Retail Sale Id 1320312',118934.40,0.00,0.00,0.00,6099.20,'2021-12-11 17:05:02','',''),(2250547,'1','143','866',382,'Retail sales',0.00,0.00,0.00,190.60,0.00,'2021-12-11 17:05:02','',''),(2253160,'1','143','866',382,'Retail Sale Id 1321321',7800.00,0.00,0.00,0.00,400.00,'2021-12-12 07:30:45','',''),(2253161,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 07:30:45','',''),(2253194,'1','143','866',382,'Retail Sale Id 1321335',998.40,0.00,0.00,0.00,51.20,'2021-12-12 07:32:45','',''),(2253195,'1','143','866',382,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-12 07:32:45','',''),(2253699,'1','143','866',382,'Retail Sale Id 1321606',3120.00,0.00,0.00,0.00,160.00,'2021-12-12 08:06:14','',''),(2253700,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 08:06:14','',''),(2253733,'1','143','866',382,'Retail Sale Id 1321623',7800.00,0.00,0.00,0.00,400.00,'2021-12-12 08:08:23','',''),(2253734,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 08:08:23','',''),(2253782,'1','143','866',382,'Retail Sale Id 1321660',7800.00,0.00,0.00,0.00,400.00,'2021-12-12 08:12:16','',''),(2253783,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 08:12:16','',''),(2253891,'1','143','866',382,'Retail Sale Id 1321711',4368.00,0.00,0.00,0.00,224.00,'2021-12-12 08:19:31','',''),(2253892,'1','143','866',382,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-12 08:19:31','',''),(2253932,'1','143','866',382,'Retail Sale Id 1321727',3744.00,0.00,0.00,0.00,192.00,'2021-12-12 08:21:34','',''),(2253933,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 08:21:34','',''),(2253997,'1','143','866',382,'Retail Sale Id 1321759',3744.00,0.00,0.00,0.00,192.00,'2021-12-12 08:25:54','',''),(2253998,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 08:25:54','',''),(2254077,'1','143','866',382,'Retail Sale Id 1321808',1872.00,0.00,0.00,0.00,96.00,'2021-12-12 08:33:06','',''),(2254078,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 08:33:06','',''),(2254108,'1','143','866',382,'Retail Sale Id 1321820',7800.00,0.00,0.00,0.00,400.00,'2021-12-12 08:34:30','',''),(2254109,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 08:34:30','',''),(2254126,'1','143','866',382,'Retail Sale Id 1321829',2496.00,0.00,0.00,0.00,128.00,'2021-12-12 08:35:49','',''),(2254127,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 08:35:49','',''),(2254158,'1','143','866',382,'Retail Sale Id 1321850',7800.00,0.00,0.00,0.00,400.00,'2021-12-12 08:37:50','',''),(2254159,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 08:37:50','',''),(2254223,'1','143','866',382,'Retail Sale Id 1321880',1872.00,0.00,0.00,0.00,96.00,'2021-12-12 08:41:01','',''),(2254224,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 08:41:01','',''),(2254271,'1','143','866',382,'Retail Sale Id 1321897',13416.00,0.00,0.00,0.00,688.00,'2021-12-12 08:43:18','',''),(2254272,'1','143','866',382,'Retail sales',0.00,0.00,0.00,21.50,0.00,'2021-12-12 08:43:18','',''),(2254306,'1','143','866',382,'Retail Sale Id 1321913',3744.00,0.00,0.00,0.00,192.00,'2021-12-12 08:45:18','',''),(2254307,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 08:45:18','',''),(2254340,'1','143','866',382,'Retail Sale Id 1321932',3744.00,0.00,0.00,0.00,192.00,'2021-12-12 08:47:10','',''),(2254341,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 08:47:10','',''),(2254377,'1','143','866',382,'Retail Sale Id 1321948',9672.00,0.00,0.00,0.00,496.00,'2021-12-12 08:49:14','',''),(2254378,'1','143','866',382,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-12 08:49:14','',''),(2254474,'1','143','866',382,'Retail Sale Id 1321992',1872.00,0.00,0.00,0.00,96.00,'2021-12-12 08:54:51','',''),(2254475,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 08:54:51','',''),(2254600,'1','143','866',382,'Retail Sale Id 1322053',312000.00,0.00,0.00,0.00,4160.00,'2021-12-12 09:02:08','',''),(2254601,'1','143','866',382,'Retail sales',0.00,0.00,0.00,520.00,0.00,'2021-12-12 09:02:08','',''),(2254624,'1','143','866',382,'Retail Sale Id 1322068',1872.00,0.00,0.00,0.00,96.00,'2021-12-12 09:03:38','',''),(2254625,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 09:03:38','',''),(2254667,'1','143','866',382,'Retail Sale Id 1322089',7800.00,0.00,0.00,0.00,400.00,'2021-12-12 09:05:42','',''),(2254668,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:05:42','',''),(2254711,'1','143','866',382,'Retail Sale Id 1322112',3744.00,0.00,0.00,0.00,192.00,'2021-12-12 09:08:27','',''),(2254712,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 09:08:27','',''),(2254841,'1','143','866',382,'Retail Sale Id 1322178',1872.00,0.00,0.00,0.00,96.00,'2021-12-12 09:14:48','',''),(2254842,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 09:14:48','',''),(2254917,'1','143','866',382,'Retail Sale Id 1322214',7800.00,0.00,0.00,0.00,400.00,'2021-12-12 09:18:49','',''),(2254918,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:18:49','',''),(2254939,'1','143','866',382,'Retail Sale Id 1322229',3744.00,0.00,0.00,0.00,192.00,'2021-12-12 09:20:21','',''),(2254940,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 09:20:21','',''),(2254973,'1','143','866',382,'Retail Sale Id 1322245',1872.00,0.00,0.00,0.00,96.00,'2021-12-12 09:22:08','',''),(2254974,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 09:22:08','',''),(2255022,'1','143','866',382,'Retail Sale Id 1322266',24000.00,0.00,0.00,0.00,320.00,'2021-12-12 09:25:13','',''),(2255023,'1','143','866',382,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-12 09:25:13','',''),(2255122,'1','143','866',382,'Retail Sale Id 1322318',1872.00,0.00,0.00,0.00,96.00,'2021-12-12 09:31:23','',''),(2255123,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 09:31:23','',''),(2255158,'1','143','866',382,'Retail Sale Id 1322329',3744.00,0.00,0.00,0.00,192.00,'2021-12-12 09:32:53','',''),(2255159,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 09:32:53','',''),(2255411,'1','143','866',382,'Retail Sale Id 1322455',3744.00,0.00,0.00,0.00,192.00,'2021-12-12 09:48:53','',''),(2255412,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 09:48:53','',''),(2255698,'1','143','866',382,'Retail Sale Id 1322585',1872.00,0.00,0.00,0.00,96.00,'2021-12-12 10:01:32','',''),(2255699,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 10:01:32','',''),(2255739,'1','143','866',382,'Retail Sale Id 1322599',2496.00,0.00,0.00,0.00,128.00,'2021-12-12 10:03:10','',''),(2255740,'1','143','866',382,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 10:03:10','',''),(2255763,'1','143','866',382,'Retail Sale Id 1322607',3744.00,0.00,0.00,0.00,192.00,'2021-12-12 10:04:13','',''),(2255764,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:04:13','',''),(2255805,'1','143','866',382,'Retail Sale Id 1322634',7800.00,0.00,0.00,0.00,400.00,'2021-12-12 10:05:57','',''),(2255806,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:05:57','',''),(2255851,'1','143','866',382,'Retail Sale Id 1322661',7800.00,0.00,0.00,0.00,400.00,'2021-12-12 10:08:16','',''),(2255852,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:08:16','',''),(2256161,'1','143','866',382,'Retail Sale Id 1322818',1872.00,0.00,0.00,0.00,96.00,'2021-12-12 10:25:45','',''),(2256162,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 10:25:45','',''),(2256303,'1','143','866',382,'Retail Sale Id 1322902',998.40,0.00,0.00,0.00,51.20,'2021-12-12 10:33:22','',''),(2256304,'1','143','866',382,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-12 10:33:22','',''),(2256459,'1','143','866',382,'Retail Sale Id 1322983',3744.00,0.00,0.00,0.00,192.00,'2021-12-12 10:41:04','',''),(2256460,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:41:04','',''),(2256542,'1','143','866',382,'Retail Sale Id 1323019',3744.00,0.00,0.00,0.00,192.00,'2021-12-12 10:44:26','',''),(2256543,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:44:26','',''),(2256594,'1','143','866',382,'Retail Sale Id 1323043',7800.00,0.00,0.00,0.00,400.00,'2021-12-12 10:46:51','',''),(2256595,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:46:51','',''),(2256656,'1','143','866',382,'Retail Sale Id 1323075',31200.00,0.00,0.00,0.00,1600.00,'2021-12-12 10:49:59','',''),(2256657,'1','143','866',382,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 10:49:59','',''),(2256676,'1','143','866',382,'Retail Sale Id 1323090',3744.00,0.00,0.00,0.00,192.00,'2021-12-12 10:51:08','',''),(2256677,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:51:08','',''),(2256701,'1','143','866',382,'Retail Sale Id 1323106',3744.00,0.00,0.00,0.00,192.00,'2021-12-12 10:52:18','',''),(2256702,'1','143','866',382,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:52:18','',''),(2256737,'1','143','866',382,'Retail Sale Id 1323121',1872.00,0.00,0.00,0.00,96.00,'2021-12-12 10:53:30','',''),(2256738,'1','143','866',382,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 10:53:30','',''),(2256784,'1','143','866',382,'Retail Sale Id 1323146',3120.00,0.00,0.00,0.00,160.00,'2021-12-12 10:56:01','',''),(2256785,'1','143','866',382,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 10:56:01','',''),(2256883,'1','143','866',382,'Retail Sale Id 1323194',7800.00,0.00,0.00,0.00,400.00,'2021-12-12 11:00:02','',''),(2256884,'1','143','866',382,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:00:02','',''),(2256952,'1','143','866',382,'Retail Sale Id 1323226',11544.00,0.00,0.00,0.00