-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_142
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_142`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_142` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_142`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3208 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2683,20016,'',0,'22','1','142','PURCHASES','','2020-08-31 17:32:01',5,0.00,0.00,'','479','2020-08-31 17:32:01','479',0,1),(2684,20025,'',0,'20','1','142','SALES','','2020-08-31 17:32:24',5,0.00,0.00,'','479','2020-08-31 17:32:24','479',0,1),(2685,40024,'',0,'6.1','1','142','CASH','','2020-08-31 17:32:43',5,0.00,0.00,'','479','2020-08-31 17:32:43','479',0,1),(2686,400115,'',0,'24','1','142','SALARIES & WAGES','','2020-08-31 17:33:05',5,0.00,0.00,'','479','2020-08-31 17:33:05','479',0,1),(2687,400116,'',0,'24','1','142','PURCHASES','','2020-08-31 17:33:39',5,0.00,0.00,'','479','2020-08-31 17:33:39','479',0,1),(2688,400255,'',0,'2','1','142','ZBN(POS):1015965368','','2020-08-31 17:34:09',5,0.00,0.00,'','479','2020-08-31 17:34:09','479',0,1),(2689,400256,'',0,'2','1','142','ZB-IBAL(E-BILLS:1015372548)','','2020-08-31 17:34:34',5,0.00,0.00,'','479','2020-08-31 17:34:34','479',0,1),(2903,400320,'',0,'2','1','142','DANKANO-EBILLS(ZNB:1014717618)','','2020-10-29 13:37:08',5,0.00,0.00,'','489','2020-10-29 13:37:08','489',0,1),(3205,400484,'',0,'2','1','142','FID POS COLLECTION-5620141491','','2021-02-26 15:59:42',5,0.00,0.00,'','489','2021-02-26 15:59:42','489',0,1),(3206,400485,'',0,'2','1','142','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:31:23',5,0.00,0.00,'','792','2023-02-20 14:31:23','792',0,0),(3207,400486,'',0,'2','1','142','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:35:31',5,0.00,0.00,'2023-03-15','792','2023-03-17 13:50:07','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4181 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1645,'','1','142','MAINAGARTA GAS','ALH. USMAN','08036593569','kaahya83@gmail.com','BIRNIN KEBBI','KEBBI STATE','BIRNIN KEBBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-09-01 11:42:12',5,'521','2020-09-01 11:42:12','521'),(1646,'','1','142','ALL DEALERS','KEBBI','08035500750','kaahya83@gmail.com','BIRNIN KEBBI','KEBBI STATE','BIRNIN KEBBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-09-01 11:49:05',5,'521','2020-09-01 11:49:05','521'),(1647,'','1','142','END USERS','KABIRU','08035500750','kaahya83@gmail.com','BIRNIN KEBBI','KEBBI STATE','BIRNIN KEBBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-09-01 11:50:29',5,'521','2020-09-01 11:50:29','521'),(1751,'','1','142','OPERATIONAL LOSS','HAFIZ NURA','08069129774','hafiz@aaranonigeria.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-10-29 13:36:38',5,'489','2020-10-29 13:36:38','489'),(1808,'','1','142','C0LLINS GAS','MR. C0LLINS','08034472201','kaahya83@gmail.com','SOKOTO','SOKOTO','OLD AIRPORT','Nigeria',1000000.00,0.00,0.00,'0000-00-00','2020-11-18 17:43:41',5,'521','2020-11-18 17:43:41','521'),(2013,'','1','142','ALFAH  GAS','KEBBI JEGA','08133236406','kaahya83@gmail.com','BIRNIN KEBBI','KEBBI STATE','JEGA BIRNIN KEBBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-16 07:56:14',5,'521','2021-02-16 07:56:14','521'),(2014,'','1','142','DEALER','KEBBI','0800000000','kaahya83@gmail.com','BIRNIN KEBBI','KEBBI STATE','KEBBI STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-16 07:57:53',5,'521','2021-02-16 07:57:53','521'),(2095,'','1','142','HASSAN KAKALE','HASSAN ','07033279053','nil@gmail','TAMBUWAL','KEBBI STATE','TAMBUWAL','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 08:07:22',5,'521','2021-02-21 08:07:22','521'),(2096,'','1','142','ZANGINA GAS','SAFIYANU AMBURSA','07034598884','argungu@gmail','KEBBI','KEBBI STATE','ARGUNGU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 08:14:16',5,'521','2021-02-21 08:14:16','521'),(2098,'','1','142','KO BA SHAYI','LAWALI','08061694061','argungu@gmail','KEBBI','KEBBI STATE','ARGUNGU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 08:21:12',5,'521','2021-02-21 08:21:12','521'),(2099,'','1','142','A.Y OIL & GAS','ALIYU','08036453240','koko@gmail','KEBBI','KEBBI STATE','KOKO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 08:22:55',5,'521','2021-02-21 08:22:55','521'),(2100,'','1','142','MADAM JASPAE','MADAM JASPAE','09030281155','madam,@gmail','KEBBI','KEBBI STATE','JEGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 08:24:36',5,'521','2021-02-21 08:24:36','521'),(2102,'','1','142','OLA GAS','OLA','0813538313','ola@gmail','KEBBI','KEBBI STATE','JEGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 08:34:31',5,'521','2021-02-21 08:34:31','521'),(2103,'','1','142','LOVING HEARTH','MR LOVING HEARTH','08035599095','mr@gmail','KEBBI','KEBBI STATE','KEBBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 08:37:08',5,'521','2021-02-21 08:37:08','521'),(2104,'','1','142','DOZIE GAS','CHIDOZIEM MALACHY','08065476664','malachychidoziem@gmail .com','KEBBI','KEBBI STATE','KEBBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 08:38:29',5,'521','2021-08-03 11:28:52','521'),(2105,'','1','142','TONNY GAS','ANTHONY','08066428609','tonny@','NIGER','NIGER STATE','KONTAGORA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 08:42:16',5,'521','2021-02-21 08:42:16','521'),(2106,'','1','142','DAKIN-GARI GAS','ABDULLATEEF','07068512303','dakingari@gmail.com','KEBBI','KEBBI STATE','DAKIN GARI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 08:43:40',5,'521','2021-09-24 07:55:50','521'),(2107,'','1','142','ABUSON GAS','ABUSON','08034059060','abu@','KEBBI','KEBBI STATE','BADARIYYA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 08:45:28',5,'521','2021-02-21 08:45:28','521'),(2108,'','1','142','AHMAD GAS','AHMAD','08100944471','ahmad@','KEBBI','KEBBI STATE','BIRNIN KEBBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 08:56:50',5,'521','2021-02-21 08:56:50','521'),(2109,'','1','142','HARUNA GAS','HARUNA','08163199866','haruna@','KEBBI','KEBBI STATE','JEGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 09:00:11',5,'521','2021-02-21 09:00:11','521'),(2114,'','1','142','MUSTY GAS','MUSTAPHA','0800000000','musty@','BIRNIN KEBBI','KEBBI STATE','BADARIYYA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 10:53:58',5,'521','2021-02-21 10:53:58','521'),(2122,'','1','142','GABREIL GAS','GABREIL','07069784183','mr@gmail','BIRNIN KEBBI','KEBBI STATE','BIRNIN-KEBBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 13:05:35',5,'521','2021-02-21 13:05:35','521'),(2123,'','1','142','VITA KAMBA','PETTER','08034175132','mr@gmail','KEBBI','KEBBI STATE','KAMBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-21 13:38:04',5,'521','2021-02-21 13:38:04','521'),(2138,'','1','142','KENNETH GAS','KENNETH','08166520863','mr@gmail','KEBBI','KEBBI STATE','HALLIRU ABDU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 09:29:13',5,'521','2021-02-22 09:29:13','521'),(2139,'','1','142','SUCCESS HENCHUNS GAS','MR HENCHENS','08036310515','mr@gmail','KEBBI','KEBBI STATE','BIRNIN KEBBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 09:38:54',5,'521','2021-04-28 09:08:35','521'),(2155,'','1','142','ABDULJALIL BUNZA','ABDULJALIL','08162316229','mr@gmail','KEBBI','KEBBI STATE','BUNZA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-22 15:48:40',5,'521','2021-02-22 15:48:40','521'),(2165,'','1','142','D PRINCE GAS','NELSON NGENE','08052742716','mr@gmail','KONTAGORA','NIGER STATE','KONTAGORA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-23 10:25:21',5,'521','2021-02-23 10:25:21','521'),(2166,'','1','142','MOBI INVESTMENT','CYTHIAN','08133311283','mr@gmail','KONTAGORA','NIGER STATE','KONTAGORA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-23 10:26:52',5,'521','2021-02-23 10:26:52','521'),(2221,'','1','142','MALACHY GAS','MALACHY    MM.','08032816086','mr@gmail','KEBBI','KEBBI STATE','MAYAMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-02-27 11:02:57',5,'521','2021-02-27 11:02:57','521'),(2237,'','1','142','OKALA','OKALA GWANDU','07061371314','kaahya83@gmail.com','BIRNIN KEBBI','KEBBI STATE','BELLO WAY GWANDU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-01 07:54:54',5,'521','2021-03-01 07:54:54','521'),(2272,'','1','142','BIG JOB','BIG JOB GAS','08141824027','mr@gmail','KEBBI','KEBBI STATE','BADARYA BESIDE ABI SCHLL','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-04 08:44:45',5,'521','2021-03-04 08:44:45','521'),(2274,'','1','142','CHIDOM GAS','CHIDI STANLEYNGENE','08062365388','mr@gmail','NIGER','NIGER STATE','KONTAGORA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-04 11:42:52',5,'521','2021-03-04 11:42:52','521'),(2285,'','1','142','BLESSES GAS','BLESSES','08143041568','mr@gmail','BIRNIN KEBBI','KEBBI STATE','OPP. ENGINEERING GATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-05 09:47:55',5,'521','2021-03-05 09:47:55','521'),(2295,'','1','142','DOMINION GAS','DOMINION','08168018804','mr@gmail','KEBBI','KEBBI STATE','BIRNIN KEBBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-06 16:42:17',5,'521','2021-03-06 16:42:17','521'),(2363,'','1','142','GLOSSY GAS','MADAM GLOSSY','08069402055','mr@gmail','BIRNIN KEBBI','KEBBI STATE','ALONG CID OFFICE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-19 12:19:53',5,'521','2021-03-19 12:19:53','521'),(2369,'','1','142','SUNDAY GAS','MR SUNDAY','09060025139','mr@gmail','KEBBI','KEBBI STATE','BUNZA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-21 15:57:05',5,'521','2021-03-21 15:57:05','521'),(2463,'','1','142','AMINCHI GAS','MUHD ARGUNGU','07066776665','argungu@gmail','KEBBI','KEBBI STATE','ARGUNGU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-01 08:15:44',5,'521','2021-04-01 08:15:44','521'),(2487,'','1','142','ALHERI GAS','SALISU','07089681523','argungu@gmail','KEBBI','KEBBI STATE','ARGUNGU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-03 10:06:41',5,'521','2021-04-03 10:06:41','521'),(2518,'','1','142','SURAJ GAS','SURAJO HASHIM ABDULLAHI','08038726749','daddyhasheem@gmail.com','KEBBI','KEBBI STATE','YAWURI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-07 07:49:33',5,'521','2021-04-07 07:49:33','521'),(2617,'','1','142','MUSLIM GAS','MUSLIM','07064863156','mr@gmail','BIRNIN KEBBI','KEBBI STATE','BADARIYA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-04-27 09:14:26',5,'521','2021-04-27 09:14:26','521'),(2715,'','1','142','BI IZNILLH GAS','BI IZNILLH GAS','07037021224','yunusa@gmail.com','BIRNIN KEBBI','KEBBI STATE NIGERIA.','BADARIYA OPPOSITE ALI BAGUDO JUCTION.','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-31 13:42:52',5,'521','2021-05-31 13:42:52','521'),(2717,'','1','142','DAN QASA MULTEPERPUS','ANAS ABDULLHI DAN QASA','08038237171','dankasajegaone@yahoo.com','KEBBI','KEBBI STATE','0PP0SITE COLLEGE OF HEALTH SCIENCE JEGA SOKKOTO ROAD.','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-01 10:36:14',5,'521','2021-06-01 10:36:14','521'),(2898,'','1','142','JOEL GAS','JOEL ISHAYA GOVO','08062420650','auwala28@gmail.com','SURU LGA','KEBBI STATE','C0PPERS LOGUE SURU LGA KEBBI STATE.','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-05 13:20:36',5,'521','2021-07-05 13:20:36','521'),(2926,'','1','142','AKANJI GAS','AKANJI GAS','07038831230','akanji@gmail.com','KEBBI','KEBBI STATE','ARGUNGU LGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-10 10:21:08',5,'521','2021-07-10 10:21:08','521'),(2990,'','1','142','SAMAILA ABDULLAHI','MAL HAMZA','08066638765','samailaabdullahikmb@gmail.com','KEBBI','KEBBI STATE','KAMBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-28 11:26:43',5,'521','2021-07-28 11:26:43','521'),(3017,'','1','142','JINSON GAS','MR  DAVID','08062825702','greatdavid4u@gmail.com','KEBBI','KEBBI STATE','SURU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-05 16:34:02',5,'521','2021-08-05 16:34:02','521'),(3179,'','1','142','NYSC','MUSTAPHA  USMAN','08034421290','kaahya83@gmail.com','KEBBI','KEBBI STATE','DAKIN GARI NYSC CAMP','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-01 14:21:10',5,'521','2021-09-01 14:21:10','521'),(3189,'','1','142','ZAGA GAS','FARUQ ZAGA','08168093583','mr@gmail','KEBBI','KEBBI STATE','ZAGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-05 12:45:37',5,'521','2021-09-05 12:45:37','521'),(3320,'','1','142','HAMMEED NURADDEN','HAMMED GAS','0803408091','abuaish12@gmail.com','KEBBI','KEBBI STATE','BADARIYA AREA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-19 07:52:06',5,'521','2021-09-19 07:52:06','521'),(3329,'','1','142','RAFEE AT GAS','RAFEE AT GAS','08067296504','kaahya83@gmail.com','KEBBI','KEBBI STATE','NOM 1. BADARIYA AREA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-20 09:41:56',5,'521','2021-09-20 09:41:56','521'),(3638,'','1','142','IHSAN  GAS','ABDULRAHMAN AUTA','08130711543','argungu@gmail','KEBBI','KEBBI STATE','ARGUNGU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-31 10:19:08',5,'521','2021-10-31 10:19:08','521'),(3663,'','1','142','ANAS GAS','ANAS ALTINE','08142511654','anasaltine23@gmail.com','ARGUNGU','KEBBI STATE','GWAZANJE POLICE STATION, ARGUNGU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-03 12:23:11',5,'521','2021-11-03 12:23:11','521'),(3963,'','1','142','UG0 BEST','UGO BEST GAS','08035803263','ugobest4christ7@gmail.com','YAURI  LOCOLGOVERNMENT','KEBBI STATE NIGERIA.','YAURI ALONG NEW CURT ROAD NOM 122 YAURI.','Nigeria',700.00,0.00,0.00,'0000-00-00','2021-12-07 06:45:58',5,'521','2021-12-07 06:45:58','521'),(4173,'','1','142','DUETIME  KALGO','KALGO','08105147624','wealthyguyang@gmail.com','BIRNIN KEBBI','KEBBI STATE NIGERIA.','kalgo  gwandu viller','Nigeria',50.00,0.00,0.00,'0000-00-00','2022-01-14 11:56:43',5,'521','2022-01-14 11:56:43','521'),(4174,'','1','142','A.J.R VENTURES.','ADIMOLA ABAYOMI','08158513771','ademolaabayemi043@gmail.com','B/KEBBI','B/KEBBI','BAGUDO','Nigeria',100.00,0.00,0.00,'0000-00-00','2022-05-20 12:42:03',5,'521','2022-05-20 12:42:03','521'),(4175,'','1','142','ABBA','AB GAS','08038432659','ademolaabayemi043@gmail.com','KANO','KANO','KANO','Nigeria',100.00,0.00,0.00,'0000-00-00','2022-06-05 13:58:02',5,'521','2022-06-05 13:58:02','521'),(4176,'','1','142','JIMSON GAS','OGUNJIMI DAVID','08062825702','greatdavid4u@gmail.com','BIRNIN KEBBI','KEBBI STATE','BIRNIN KEBBI,KEBBI STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-10 22:15:14',5,'521','2022-08-10 22:15:14','521'),(4177,'','1','142','MASLAHA GA','ABUBAKAR ALFA','07030709294','abubakaralfa92@gmail.com','BIRNIN KEBBI','KEBBI STATE','BAKIN SABUWAR KASUWA BIRININ KEBBI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-14 18:00:35',5,'521','2022-08-14 18:00:35','521'),(4178,'','1','142','SAUKI GAS ','YAZID IBRAHIM','07044113471','yazidibrahim421@gmail.com','B/KEBBI','KEBBI STATE','ALERU MALLAMAWA BESIDE LOCAL GOVRENMENT ','Nigeria',100.00,0.00,0.00,'0000-00-00','2022-12-12 09:45:05',5,'521','2022-12-12 09:45:05','521'),(4179,'','1','142','JAZZ GAS','JAZZ GAS','07068934889','gistwith@gmail.com','B/KEBBI','KEBBI STATE','ALEIRU','Nigeria',55.00,0.00,0.00,'0000-00-00','2023-01-16 10:18:28',5,'521','2023-01-16 10:18:28','521'),(4180,'','1','142','DANGAMA GAS  NIG LTD','Alh.DANGAMA','09082865400','shamkhas070@mail.com','Birnin Kebbi','kebbi state','Branch@Birnin kebbi,Kebbi state Nigeria ','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-02-06 20:49:58',5,'521','2023-02-06 20:49:58','521');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16372 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','142',16367,'798',16088.46,11797.00,'2021-09-09','new','2021-09-09 07:27:32','483','483',2021,'483','2021-09-09 07:27:32',5),('1','142',16368,'799',3356.67,1.00,'2021-09-09','new','2021-09-09 07:27:53','483','483',2021,'483','2021-09-09 07:27:53',5),('1','142',16369,'798',11797.00,11397.00,'2021-09-09','new','2021-09-09 07:29:28','483','483',2021,'483','2021-09-09 07:29:28',5),('1','142',16370,'799',8870.11,9000.00,'2022-05-08','','2022-05-08 22:59:43','483','483',2022,'483','2022-05-08 22:59:43',5),('1','142',16371,'798',19515.93,8712.00,'2022-05-09','','2022-05-09 06:53:57','483','483',2022,'483','2022-05-09 06:53:57',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2235 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','142','798',2231,'5','LPG NOZZLE 1',213301.92,'LPG DISPENSER','',NULL,NULL,'',5,'2022-02-11 06:49:50','483'),('1','142','799',2232,'5','LPG NOZZLE 4',260648.83,'LPG DISPENSER','',NULL,NULL,'',5,'2022-02-11 06:54:11','483'),('1','142','798',2233,'5','LPG NOZZLE 2.',223719.08,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-02-11 06:52:11','483'),('1','142','799',2234,'5','LPG NOZZLE 3',260662.61,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-02-11 06:52:55','483');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257975 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','142',149918,'DAILY SALES','2020-08-31','2020-08-31 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-01 11:55:06','521','2020-09-01 11:55:37',10,0),('1','142',150025,'DAILY SALES','2020-09-01','2020-09-01 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-02 08:31:41','521','2020-09-02 08:32:13',10,0),('1','142',150209,'DAILY SALES','2020-09-02','2020-09-02 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-03 09:45:31','521','2020-09-03 09:46:00',10,0),('1','142',150491,'DAILY SALES','2020-09-03','2020-09-03 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-04 14:02:37','521','2020-09-04 14:03:14',10,0),('1','142',150529,'DAILY SALES','2020-09-04','2020-09-04 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-04 17:58:51','521','2020-09-04 17:59:35',10,0),('1','142',150701,'DAILY SALES','2020-09-05','2020-09-05 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-05 18:07:13','521','2020-09-05 18:07:38',10,0),('1','142',150827,'DAILY SALES','2020-09-06','2020-09-06 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-06 17:57:48','521','2020-09-06 17:58:19',10,0),('1','142',150937,'DAILY SALES','2020-09-07','2020-09-07 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-07 17:53:11','521','2020-09-07 17:53:40',10,0),('1','142',151090,'DAILY SALES','2020-09-08','2020-09-08 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-08 17:30:09','521','2020-09-08 17:31:03',10,0),('1','142',151252,'DAILY SALES','2020-09-09','2020-09-09 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-09 18:03:12','521','2020-09-09 18:03:54',10,0),('1','142',151351,'DAILY SALES','2020-09-10','2020-09-10 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-10 18:10:06','521','2020-09-10 18:12:07',10,0),('1','142',151577,'DAILY SALES','2020-09-11','2020-09-11 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-11 17:59:44','521','2020-09-11 18:00:20',10,0),('1','142',151689,'DAILY SALES','2020-09-12','2020-09-12 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-12 18:08:33','521','2020-09-12 18:08:56',10,0),('1','142',151779,'DAILY SALES','2020-09-13','2020-09-13 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-13 17:30:22','521','2020-09-13 17:31:03',10,0),('1','142',151886,'DAILY SALES','2020-09-14','2020-09-14 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-14 17:13:15','521','2020-09-14 17:13:40',10,0),('1','142',152040,'DAILY SALES','2020-09-15','2020-09-15 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-15 17:33:21','521','2020-09-15 17:34:25',10,0),('1','142',152200,'DAILY SALES','2020-09-16','2020-09-16 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-16 17:01:21','521','2020-09-16 17:01:48',10,0),('1','142',152357,'DAILY SALES','2020-09-17','2020-09-17 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-17 17:31:20','521','2020-09-17 17:31:47',10,0),('1','142',152544,'DAILY SALES','2020-09-18','2020-09-18 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-18 17:14:47','521','2020-09-18 17:15:25',10,0),('1','142',152657,'DAILY SALES','2020-09-19','2020-09-19 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-19 17:12:09','521','2020-09-19 17:12:39',10,0),('1','142',152903,'DAILY SALES','2020-09-20','2020-09-20 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-20 22:57:57','521','2020-09-20 23:01:28',10,0),('1','142',152989,'DAILY SALES','2020-09-21','2020-09-21 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-21 13:36:17','521','2020-09-21 13:36:42',10,0),('1','142',153069,'DAILY SALES','2020-09-21','2020-09-21 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-21 17:48:51','521','2020-09-21 17:49:23',10,0),('1','142',153153,'DAILY SALES','2020-09-22','2020-09-22 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-22 17:15:57','521','2020-09-22 17:16:29',10,0),('1','142',153461,'DAILY SALES','2020-09-23','2020-09-23 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-23 17:55:42','521','2020-09-23 17:56:07',10,0),('1','142',153592,'DAILY SALES','2020-09-24','2020-09-24 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-24 18:02:18','521','2020-09-24 18:03:52',10,0),('1','142',153702,'DAILY SALES','2020-09-25','2020-09-25 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-25 17:20:11','521','2020-09-25 17:20:46',10,0),('1','142',153834,'DAILY SALES','2020-09-26','2020-09-26 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-26 17:23:20','521','2020-09-26 17:24:17',10,0),('1','142',154044,'DAILY SALES','2020-09-27','2020-09-27 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-27 17:17:52','521','2020-09-27 17:18:29',10,0),('1','142',154226,'DAILY SALES','2020-09-28','2020-09-28 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-28 20:53:37','521','2020-09-28 20:54:11',10,0),('1','142',154306,'DAILY SALES','2020-09-29','2020-09-29 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-29 17:19:55','521','2020-09-29 17:20:20',10,0),('1','142',154469,'DAILY SALES','2020-09-30','2020-09-30 00:00:00',NULL,'521',0.00,0.00,'521','2020-09-30 17:44:40','521','2020-09-30 17:45:06',10,0),('1','142',154630,'DAILY SALES','2020-10-01','2020-10-01 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-01 11:06:16','521','2020-10-01 11:07:13',10,0),('1','142',154697,'DAILY SALES','2020-10-01','2020-10-01 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-01 17:36:13','521','2020-10-01 17:36:42',10,0),('1','142',154856,'DAILY SALES','2020-10-02','2020-10-02 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-02 17:41:39','521','2020-10-02 17:42:05',10,0),('1','142',155006,'DAILY SALES','2020-10-03','2020-10-03 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-03 17:40:26','521','2020-10-03 17:40:49',10,0),('1','142',155122,'DAILY SALES','2020-10-04','2020-10-04 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-04 17:48:25','521','2020-10-04 17:48:53',10,0),('1','142',155304,'DAILY SALES','2020-10-05','2020-10-05 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-05 20:45:03','521','2020-10-05 20:46:19',10,0),('1','142',155424,'DAILY SALES','2020-10-06','2020-10-06 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-06 18:08:42','521','2020-10-06 18:14:14',10,0),('1','142',155620,'DAILY SALES','2020-10-07','2020-10-07 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-07 17:57:02','521','2020-10-07 17:57:35',10,0),('1','142',155711,'DAILY SALES','2020-10-08','2020-10-08 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-08 13:46:08','521','2020-10-08 13:47:00',10,0),('1','142',155912,'DAILY SALES','2020-10-09','2020-10-09 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-09 17:30:29','521','2020-10-09 17:30:58',10,0),('1','142',156065,'DAILY SALES','2020-10-10','2020-10-10 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-10 17:28:02','521','2020-10-10 17:28:34',10,0),('1','142',156188,'DAILY SALES','2020-10-11','2020-10-11 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-11 17:37:07','521','2020-10-11 17:37:30',10,0),('1','142',156401,'DAILY SALES','2020-10-12','2020-10-12 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-12 17:44:55','521','2020-10-12 17:45:26',10,0),('1','142',156578,'DAILY SALES','2020-10-13','2020-10-13 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-13 20:47:23','521','2020-10-13 20:47:53',10,0),('1','142',156721,'DAILY SALES','2020-10-14','2020-10-14 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-14 17:28:51','521','2020-10-14 17:29:18',10,0),('1','142',156888,'DAILY SALES','2020-10-15','2020-10-15 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-15 17:45:38','521','2020-10-15 17:46:24',10,0),('1','142',157056,'DAILY SALES','2020-10-16','2020-10-16 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-16 17:26:35','521','2020-10-16 17:27:58',10,0),('1','142',157252,'DAILY SALES','2020-10-17','2020-10-17 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-17 17:15:59','521','2020-10-17 17:16:33',10,0),('1','142',157430,'DAILY SALES','2020-10-18','2020-10-18 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-18 17:00:29','521','2020-10-18 17:00:56',10,0),('1','142',157573,'DAILY SALES','2020-10-19','2020-10-19 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-19 14:23:24','521','2020-10-19 14:23:51',10,0),('1','142',157637,'DAILY SALES','2020-10-19','2020-10-19 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-19 17:39:28','521','2020-10-19 17:39:51',10,0),('1','142',157773,'DAILY SALES','2020-10-20','2020-10-20 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-20 17:55:26','521','2020-10-20 17:55:54',10,0),('1','142',157936,'DAILY SALES','2020-10-21','2020-10-21 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-21 16:54:48','521','2020-10-21 16:55:11',10,0),('1','142',158068,'DAILY SALES','2020-10-22','2020-10-22 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-22 17:25:07','521','2020-10-22 17:25:34',10,0),('1','142',158240,'DAILY SALES','2020-10-23','2020-10-23 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-23 17:08:09','521','2020-10-23 17:09:12',10,0),('1','142',158410,'DAILY SALES','2020-10-24','2020-10-24 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-24 17:20:06','521','2020-10-24 17:20:34',10,0),('1','142',158559,'DAILY SALES','2020-10-25','2020-10-25 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-25 17:35:48','521','2020-10-25 17:36:14',10,0),('1','142',158729,'DAILY SALES','2020-10-26','2020-10-26 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-26 16:49:10','521','2020-10-26 16:49:39',10,0),('1','142',159242,'DAILY SALES','2020-10-29','2020-10-29 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-29 15:43:58','521','2020-10-29 15:44:45',10,0),('1','142',159441,'DAILY SALES','2020-10-30','2020-10-30 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-30 17:38:02','521','2020-10-30 17:38:41',10,0),('1','142',159619,'DAILY SALES','2020-10-31','2020-10-31 00:00:00',NULL,'521',0.00,0.00,'521','2020-10-31 17:47:51','521','2020-10-31 17:48:33',10,0),('1','142',159725,'DAILY SALES','2020-11-01','2020-11-01 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-01 18:00:32','521','2020-11-01 18:01:05',10,0),('1','142',159921,'DAILY SALES','2020-11-02','2020-11-02 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-02 17:45:23','521','2020-11-02 17:45:47',10,0),('1','142',160110,'DAILY SALES','2020-11-03','2020-11-03 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-03 17:06:28','521','2020-11-03 17:06:59',10,0),('1','142',160301,'DAILY SALES','2020-11-04','2020-11-04 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-04 17:40:04','521','2020-11-04 17:40:27',10,0),('1','142',160378,'DAILY SALES','2020-11-05','2020-11-05 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-05 11:29:06','521','2020-11-05 11:29:55',10,0),('1','142',160450,'DAILY SALES','2020-11-05','2020-11-05 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-05 18:08:20','521','2020-11-05 18:08:42',10,0),('1','142',160585,'DAILY SALES','2020-11-06','2020-11-06 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-06 17:31:22','521','2020-11-06 17:32:08',10,0),('1','142',160733,'DAILY SALES','2020-11-07','2020-11-07 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-07 17:45:50','521','2020-11-07 17:46:52',10,0),('1','142',160880,'DAILY SALES','2020-11-08','2020-11-08 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-08 16:54:56','521','2020-11-08 16:55:28',10,0),('1','142',161080,'DAILY SALES','2020-11-09','2020-11-09 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-09 17:39:40','521','2020-11-09 17:41:08',10,0),('1','142',161262,'DAILY SALES','2020-11-10','2020-11-10 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-10 18:29:21','521','2020-11-10 18:29:49',10,0),('1','142',161473,'DAILY SALES','2020-11-11','2020-11-11 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-11 19:50:17','521','2020-11-11 19:50:56',10,0),('1','142',161851,'DAILY SALES','2020-11-12','2020-11-12 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-13 17:42:18','521','2020-11-13 17:42:45',10,0),('1','142',161866,'DAILY SALES','2020-11-13','2020-11-13 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-13 18:20:27','521','2020-11-13 18:20:52',10,0),('1','142',162035,'DAILY SALES','2020-11-14','2020-11-14 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-14 17:51:37','521','2020-11-14 17:52:00',10,0),('1','142',162224,'DAILY SALES','2020-11-15','2020-11-15 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-15 18:01:52','521','2020-11-15 18:02:14',10,0),('1','142',162445,'DAILY SALES','2020-11-16','2020-11-16 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-16 17:50:45','521','2020-11-16 17:51:11',10,0),('1','142',162663,'DAILY SALES','2020-11-18','2020-11-18 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-18 07:33:42','521','2020-11-18 07:34:08',10,0),('1','142',162664,'DAILY SALES','2020-11-17','2020-11-17 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-18 07:42:24','521','2020-11-18 07:42:53',10,0),('1','142',162799,'DAILY SALES','2020-11-18','2020-11-18 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-18 17:49:39','521','2020-11-18 17:50:02',10,0),('1','142',163023,'DAILY SALES','2020-11-19','2020-11-19 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-20 07:29:21','521','2020-11-20 07:29:50',10,0),('1','142',163025,'DAILY SALES','2020-11-19','2020-11-19 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-20 07:46:20','521','2020-11-20 07:46:51',10,0),('1','142',163197,'DAILY SALES','2020-11-20','2020-11-20 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-20 17:59:45','521','2020-11-20 18:00:32',10,0),('1','142',163363,'DAILY SALES','2020-11-21','2020-11-21 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-21 17:44:42','521','2020-11-21 17:45:07',10,0),('1','142',163569,'DAILY SALES','2020-11-22','2020-11-22 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-23 08:02:31','521','2020-11-23 08:03:01',10,0),('1','142',163728,'DAILY SALES','2020-11-23','2020-11-23 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-24 08:42:59','521','2020-11-24 08:43:24',10,0),('1','142',163760,'DAILY SALES','2020-11-23','2020-11-23 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-24 08:58:52','521','2020-11-24 08:59:17',10,0),('1','142',163915,'DAILY SALES','2020-11-24','2020-11-24 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-25 07:48:29','521','2020-11-25 07:48:57',10,0),('1','142',164101,'DAILY SALES','2020-11-25','2020-11-25 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-26 07:40:33','521','2020-11-26 07:41:06',10,0),('1','142',164297,'DAILY SALES','2020-11-26','2020-11-26 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-27 07:43:10','521','2020-11-27 07:43:44',10,0),('1','142',164480,'DAILY SALES','2020-11-27','2020-11-27 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-28 09:18:26','521','2020-11-28 09:18:56',10,0),('1','142',164627,'DAILY SALES','2020-11-28','2020-11-28 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-29 08:31:21','521','2020-11-29 08:32:05',10,0),('1','142',164780,'DAILY SALES','2020-11-29','2020-11-29 00:00:00',NULL,'521',0.00,0.00,'521','2020-11-30 07:35:50','521','2020-11-30 07:36:23',10,0),('1','142',165007,'DAILY SALES','2020-11-30','2020-11-30 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-01 09:36:51','521','2020-12-01 09:37:17',10,0),('1','142',165170,'DAILY SALES','2020-12-01','2020-12-01 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-02 09:43:54','521','2020-12-02 09:44:20',10,0),('1','142',165339,'DAILY SALES','2020-12-02','2020-12-02 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-03 09:05:51','521','2020-12-03 09:06:34',10,0),('1','142',165467,'DAILY SALES','2020-12-03','2020-12-03 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-04 07:31:25','521','2020-12-04 07:31:49',10,0),('1','142',165654,'DAILY SALES','2020-12-04','2020-12-04 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-05 08:20:10','521','2020-12-05 08:20:35',10,0),('1','142',165814,'DAILY SALES','2020-12-05','2020-12-05 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-06 08:21:12','521','2020-12-06 08:21:42',10,0),('1','142',165996,'DAILY SALES','2020-12-06','2020-12-06 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-07 09:24:04','521','2020-12-07 09:24:29',10,0),('1','142',166174,'DAILY SALES','2020-12-07','2020-12-07 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-08 08:34:57','521','2020-12-08 08:35:31',10,0),('1','142',166550,'DAILY SALES','2020-12-08','2020-12-08 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-10 09:48:10','521','2020-12-10 09:49:01',10,0),('1','142',166556,'DAILY SALES','2020-12-09','2020-12-09 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-10 09:59:32','521','2020-12-10 09:59:56',10,0),('1','142',166686,'DAILY SALES','2020-12-10','2020-12-10 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-10 17:45:05','521','2020-12-10 17:45:32',10,0),('1','142',166914,'DAILY SALES','2020-12-11','2020-12-11 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-12 08:20:41','521','2020-12-12 08:21:10',10,0),('1','142',167063,'DAILY SALES','2020-12-12','2020-12-12 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-13 07:55:28','521','2020-12-13 07:56:05',10,0),('1','142',167172,'DAILY SALES','2020-12-13','2020-12-13 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-13 17:45:37','521','2020-12-13 17:46:01',10,0),('1','142',167362,'DAILY SALES','2020-12-14','2020-12-14 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-14 17:58:20','521','2020-12-14 17:58:47',10,0),('1','142',167558,'DAILY SALES','2020-12-15','2020-12-15 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-15 17:34:29','521','2020-12-15 17:34:53',10,0),('1','142',167759,'DAILY SALES','2020-12-16','2020-12-16 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-17 07:34:07','521','2020-12-17 07:34:33',10,0),('1','142',167760,'DAILY SALES','2020-12-16','2020-12-16 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-17 07:42:24','521','2020-12-17 07:42:54',10,0),('1','142',167918,'DAILY SALES','2020-12-17','2020-12-17 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-17 19:12:26','521','2020-12-17 19:12:52',10,0),('1','142',168100,'DAILY SALES','2020-12-18','2020-12-18 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-18 17:48:00','521','2020-12-18 17:48:44',10,0),('1','142',168284,'DAILY SALES','2020-12-19','2020-12-19 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-19 18:27:12','521','2020-12-19 18:28:01',10,0),('1','142',168435,'DAILY SALES','2020-12-20','2020-12-20 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-21 07:10:50','521','2020-12-21 07:11:18',10,0),('1','142',168599,'DAILY SALES','2020-12-21','2020-12-21 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-21 18:32:59','521','2020-12-21 18:33:25',10,0),('1','142',168764,'DAILY SALES','2020-12-22','2020-12-22 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-22 17:59:30','521','2020-12-22 17:59:54',10,0),('1','142',168925,'DAILY SALES','2020-12-23','2020-12-23 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-23 17:52:55','521','2020-12-23 17:53:17',10,0),('1','142',169140,'DAILY SALES','2020-12-24','2020-12-24 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-25 09:10:31','521','2020-12-25 09:10:56',10,0),('1','142',169142,'DAILY SALES','2020-12-24','2020-12-24 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-25 09:34:58','521','2020-12-25 09:35:31',10,0),('1','142',169295,'DAILY SALES','2020-12-25','2020-12-25 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-26 08:09:50','521','2020-12-26 08:10:18',10,0),('1','142',169462,'DAILY SALES','2020-12-26','2020-12-26 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-27 07:51:35','521','2020-12-27 07:52:04',10,0),('1','142',169563,'DAILY SALES','2020-12-27','2020-12-27 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-27 18:09:30','521','2020-12-27 18:09:55',10,0),('1','142',169760,'DAILY SALES','2020-12-28','2020-12-28 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-28 17:48:53','521','2020-12-28 17:49:17',10,0),('1','142',169915,'DAILY SALES','2020-12-29','2020-12-29 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-29 17:40:03','521','2020-12-29 17:40:32',10,0),('1','142',170121,'DAILY SALES','2020-12-30','2020-12-30 00:00:00',NULL,'521',0.00,0.00,'521','2020-12-30 17:57:12','521','2020-12-30 17:57:34',10,0),('1','142',170399,'DAILY SALES','2020-12-31','2020-12-31 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-01 11:20:15','521','2021-01-01 11:20:49',10,0),('1','142',170483,'DAILY SALES','2021-01-01','2021-01-01 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-01 18:16:57','521','2021-01-01 18:17:19',10,0),('1','142',170720,'DAILY SALES','2021-01-02','2021-01-02 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-03 10:44:42','521','2021-01-03 10:47:12',10,0),('1','142',170826,'DAILY SALES','2021-01-03','2021-01-03 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-04 07:38:33','521','2021-01-04 07:38:59',10,0),('1','142',170969,'DAILY SALES','2021-01-04','2021-01-04 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-04 17:27:49','521','2021-01-04 17:28:19',10,0),('1','142',171249,'DAILY SALES','2021-01-05','2021-01-05 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-06 09:21:52','521','2021-01-06 09:22:18',10,0),('1','142',171356,'DAILY SALES','2021-01-06','2021-01-06 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-06 17:36:52','521','2021-01-06 17:37:14',10,0),('1','142',171586,'DAILY SALES','2021-01-07','2021-01-07 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-07 21:17:56','521','2021-01-07 21:18:27',10,0),('1','142',171763,'DAILY SALES','2021-01-08','2021-01-08 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-08 19:10:28','521','2021-01-08 19:10:49',10,0),('1','142',171944,'DAILY SALES','2021-01-09','2021-01-09 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-09 19:04:30','521','2021-01-09 19:04:57',10,0),('1','142',172103,'DAILY SALES','2021-01-10','2021-01-10 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-11 07:30:29','521','2021-01-11 07:30:59',10,0),('1','142',172286,'DAILY SALES','2021-01-11','2021-01-11 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-11 20:25:12','521','2021-01-11 20:25:39',10,0),('1','142',172287,'DAILY SALES','2021-01-11','2021-01-11 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-11 20:29:07','521','2021-01-11 20:29:32',10,0),('1','142',172495,'DAILY SALES','2021-01-12','2021-01-12 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-12 19:05:53','521','2021-01-12 19:06:17',10,0),('1','142',172699,'DAILY SALES','2021-01-13','2021-01-13 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-13 20:31:29','521','2021-01-13 20:33:16',10,0),('1','142',172876,'DAILY SALES','2021-01-14','2021-01-14 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-14 20:07:58','521','2021-01-14 20:08:37',10,0),('1','142',173045,'DAILY SALES','2021-01-15','2021-01-15 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-15 18:42:44','521','2021-01-15 18:43:08',10,0),('1','142',173245,'DAILY SALES','2021-01-17','2021-01-17 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-17 08:36:59','521','2021-01-17 08:37:28',10,0),('1','142',173375,'DAILY SALES','2021-01-17','2021-01-17 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-17 19:27:34','521','2021-01-17 19:27:59',10,0),('1','142',173586,'DAILY SALES','2021-01-18','2021-01-18 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-18 19:40:02','521','2021-01-18 19:40:38',10,0),('1','142',173759,'DAILY SALES','2021-01-19','2021-01-19 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-19 19:24:32','521','2021-01-19 19:25:00',10,0),('1','142',173915,'DAILY SALES','2021-01-20','2021-01-20 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-20 16:26:22','521','2021-01-20 16:26:46',10,0),('1','142',173916,'DAILY SALES','2021-01-20','2021-01-20 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-20 19:29:21','521','2021-01-20 19:29:55',10,0),('1','142',174139,'DAILY SALES','2021-01-21','2021-01-21 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-22 07:12:32','521','2021-01-22 07:13:16',10,0),('1','142',174298,'DAILY SALES','2021-01-22','2021-01-22 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-22 17:51:47','521','2021-01-22 17:52:13',10,0),('1','142',174599,'DAILY SALES','2021-01-23','2021-01-23 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-24 16:23:17','521','2021-01-24 16:23:53',10,0),('1','142',174613,'DAILY SALES','2021-01-24','2021-01-24 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-24 17:57:14','521','2021-01-24 17:57:38',10,0),('1','142',174858,'DAILY SALES','2021-01-25','2021-01-25 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-26 07:52:45','521','2021-01-26 07:53:07',10,0),('1','142',175065,'DAILY SALES','2021-01-27','2021-01-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-27 07:26:34','521','2021-01-27 07:26:57',10,0),('1','142',175066,'DAILY SALES','2021-01-26','2021-01-26 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-27 07:32:23','521','2021-01-27 07:32:51',10,0),('1','142',175258,'DAILY SALES','2021-01-27','2021-01-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-28 08:13:20','521','2021-01-28 08:13:45',10,0),('1','142',175402,'DAILY SALES','2021-01-28','2021-01-28 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-28 18:45:37','521','2021-01-28 18:46:00',10,0),('1','142',175609,'DAILY SALES','2021-01-29','2021-01-29 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-30 08:20:48','521','2021-01-30 08:21:13',10,0),('1','142',175794,'DAILY SALES','2021-01-30','2021-01-30 00:00:00',NULL,'521',0.00,0.00,'521','2021-01-31 09:53:17','521','2021-01-31 09:53:43',10,0),('1','142',175924,'DAILY SALES','2021-01-31','2021-01-31 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-01 08:03:09','521','2021-02-01 08:03:31',10,0),('1','142',176159,'DAILY SALES','2021-02-01','2021-02-01 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-02 07:49:38','521','2021-02-02 07:50:04',10,0),('1','142',176352,'DAILY SALES','2021-02-02','2021-02-02 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-03 08:03:20','521','2021-02-03 08:03:58',10,0),('1','142',176574,'DAILY SALES','2021-02-03','2021-02-03 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-04 07:55:08','521','2021-02-04 07:55:38',10,0),('1','142',176647,'DAILY SALES','2021-02-04','2021-02-04 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-04 13:46:35','521','2021-02-04 13:47:23',10,0),('1','142',176774,'DAILY SALES','2021-02-04','2021-02-04 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-04 21:02:14','521','2021-02-04 21:02:45',10,0),('1','142',177029,'DAILY SALES','2021-02-05','2021-02-05 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-06 09:27:32','521','2021-02-06 09:28:09',10,0),('1','142',177298,'DAILY SALES','2021-02-06','2021-02-06 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-09 16:43:28','521','2021-02-09 16:43:58',10,0),('1','142',177846,'DAILY SALES','2021-02-05','2021-02-05 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-12 11:16:04','521','2021-02-12 11:16:48',10,0),('1','142',178457,'DAILY SALES','2021-02-09','2021-02-09 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-12 17:33:43','521','2021-02-12 17:34:11',10,0),('1','142',178460,'DAILY SALES','2021-02-10','2021-02-10 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-12 17:48:29','521','2021-02-12 17:48:58',10,0),('1','142',178513,'DAILY SALES','2021-02-11','2021-02-11 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-13 08:04:00','521','2021-02-13 08:04:33',10,0),('1','142',178518,'DAILY SALES','2021-02-11','2021-02-11 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-13 08:28:37','521','2021-02-13 08:29:14',10,0),('1','142',178526,'DAILY SALES','2021-02-12','2021-02-12 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-13 08:38:56','521','2021-02-13 08:39:25',10,0),('1','142',178848,'DAILY SALES','2021-02-13','2021-02-13 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-14 15:34:07','521','2021-02-14 15:34:35',10,0),('1','142',178870,'DAILY SALES','2021-02-14','2021-02-14 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-14 18:23:16','521','2021-02-14 18:23:41',10,0),('1','142',179046,'DAILY SALES','2021-02-15','2021-02-15 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-16 07:15:46','521','2021-02-16 07:16:11',10,0),('1','142',179148,'DAILY SALES','2021-02-16','2021-02-16 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-16 19:10:55','521','2021-02-16 19:11:21',10,0),('1','142',179379,'DAILY SALES','2021-02-17','2021-02-17 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-17 18:58:16','521','2021-02-17 19:02:21',10,0),('1','142',179579,'DAILY SALES','2021-02-18','2021-02-18 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-18 17:09:06','521','2021-02-18 17:11:03',10,0),('1','142',179777,'DAILY SALES','2021-02-19','2021-02-19 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-19 18:02:54','521','2021-02-19 18:03:22',10,0),('1','142',179997,'DAILY SALES','2021-02-20','2021-02-20 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-20 18:21:08','521','2021-02-20 18:27:46',10,0),('1','142',180190,'DAILY SALES','2021-02-21','2021-02-21 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-21 17:25:51','521','2021-02-21 17:28:02',10,0),('1','142',180342,'DAILY SALES','2021-02-22','2021-02-22 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-22 10:25:11','521','2021-02-22 10:26:37',10,0),('1','142',180410,'DAILY SALES','2021-02-22','2021-02-22 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-22 18:00:30','521','2021-02-22 18:01:04',10,0),('1','142',180554,'DAILY SALES','2021-02-23','2021-02-23 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-23 17:28:24','521','2021-02-23 17:32:25',10,0),('1','142',180767,'DAILY SALES','2021-02-24','2021-02-24 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-24 17:09:57','521','2021-02-24 17:19:12',10,0),('1','142',180968,'DAILY SALES','2021-02-25','2021-02-25 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-25 17:45:10','521','2021-02-25 17:46:43',10,0),('1','142',181137,'DAILY SALES','2021-02-26','2021-02-26 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-26 16:35:29','521','2021-02-26 16:39:14',10,0),('1','142',181338,'DAILY SALES','2021-02-27','2021-02-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-27 15:47:56','521','2021-02-27 15:49:55',10,0),('1','142',181471,'DAILY SALES','2021-02-27','2021-02-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-27 17:48:57','521','2021-02-27 17:51:19',10,0),('1','142',181530,'DAILY SALES','2021-02-28','2021-02-28 00:00:00',NULL,'521',0.00,0.00,'521','2021-02-28 18:46:17','521','2021-02-28 19:02:15',10,0),('1','142',181714,'DAILY SALES','2021-03-01','2021-03-01 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-01 17:19:26','521','2021-03-01 17:22:24',10,0),('1','142',181913,'DAILY SALES','2021-03-02','2021-03-02 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-02 17:28:58','521','2021-03-02 17:37:09',10,0),('1','142',182117,'DAILY SALES','2021-03-03','2021-03-03 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-03 17:42:29','521','2021-03-03 18:14:40',10,0),('1','142',182319,'DAILY SALES','2021-03-04','2021-03-04 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-04 18:28:49','521','2021-03-04 18:37:04',10,0),('1','142',182533,'DAILY SALES','2021-03-05','2021-03-05 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-05 17:52:52','521','2021-03-05 17:53:49',10,0),('1','142',182667,'DAILY SALES','2021-03-05','2021-03-05 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-05 18:27:28','521','2021-03-05 18:34:10',10,0),('1','142',182695,'DAILY SALES','2021-03-06','2021-03-06 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-06 17:12:09','521','2021-03-06 17:13:04',10,0),('1','142',182850,'DAILY SALES','2021-03-07','2021-03-07 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-07 18:07:56','521','2021-03-07 18:11:52',10,0),('1','142',182990,'DAILY SALES','2021-03-08','2021-03-08 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-08 18:52:08','521','2021-03-08 18:55:16',10,0),('1','142',183216,'DAILY SALES','2021-03-09','2021-03-09 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-09 17:13:41','521','2021-03-09 17:14:15',10,0),('1','142',183436,'DAILY SALES','2021-03-10','2021-03-10 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-10 17:47:11','521','2021-03-10 18:05:25',10,0),('1','142',183653,'DAILY SALES','2021-03-11','2021-03-11 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-11 07:15:46','521','2021-03-11 07:16:24',10,0),('1','142',183654,'DAILY SALES','2021-03-11','2021-03-11 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-11 18:40:06','521','2021-03-11 18:42:10',10,0),('1','142',183912,'DAILY SALES','2021-03-12','2021-03-12 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-12 18:06:03','521','2021-03-12 18:09:55',10,0),('1','142',184104,'DAILY SALES','2021-03-13','2021-03-13 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-13 17:09:20','521','2021-03-13 17:09:53',10,0),('1','142',184286,'DAILY SALES','2021-03-14','2021-03-14 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-14 17:26:25','521','2021-03-14 17:27:27',10,0),('1','142',184478,'DAILY SALES','2021-03-15','2021-03-15 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-15 17:07:23','521','2021-03-15 17:20:51',10,0),('1','142',184706,'DAILY SALES','2021-03-16','2021-03-16 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-16 17:01:44','521','2021-03-16 17:02:12',10,0),('1','142',184843,'DAILY SALES','2021-03-16','2021-03-16 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-16 17:44:20','521','2021-03-16 17:44:52',10,0),('1','142',184906,'DAILY SALES','2021-03-17','2021-03-17 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-17 17:07:09','521','2021-03-17 17:08:32',10,0),('1','142',185119,'DAILY SALES','2021-03-18','2021-03-18 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-18 17:20:05','521','2021-03-18 17:21:31',10,0),('1','142',185268,'DAILY SALES','2021-03-19','2021-03-19 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-19 17:05:22','521','2021-03-19 17:06:28',10,0),('1','142',185471,'DAILY SALES','2021-03-20','2021-03-20 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-20 17:08:25','521','2021-03-20 17:09:34',10,0),('1','142',185688,'DAILY SALES','2021-03-21','2021-03-21 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-21 17:36:35','521','2021-03-21 17:39:23',10,0),('1','142',185886,'DAILY SALES','2021-03-22','2021-03-22 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-22 17:32:34','521','2021-03-22 17:41:46',10,0),('1','142',186098,'DAILY SALES','2021-03-23','2021-03-23 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-23 17:09:30','521','2021-03-23 17:10:54',10,0),('1','142',186333,'DAILY SALES','2021-03-24','2021-03-24 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-24 17:28:26','521','2021-03-24 17:30:07',10,0),('1','142',186541,'DAILY SALES','2021-03-25','2021-03-25 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-25 17:48:49','521','2021-03-25 17:49:32',10,0),('1','142',186759,'DAILY SALES','2021-03-26','2021-03-26 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-26 17:36:10','521','2021-03-26 17:38:12',10,0),('1','142',187002,'DAILY SALES','2021-03-27','2021-03-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-27 10:11:55','521','2021-03-27 10:14:41',10,0),('1','142',187026,'DAILY SALES','2021-03-27','2021-03-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-27 17:38:03','521','2021-03-27 17:38:46',10,0),('1','142',187176,'DAILY SALES','2021-03-28','2021-03-28 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-28 17:33:21','521','2021-03-28 17:34:49',10,0),('1','142',187380,'DAILY SALES','2021-03-29','2021-03-29 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-29 17:28:14','521','2021-03-29 17:29:19',10,0),('1','142',187587,'DAILY SALES','2021-03-30','2021-03-30 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-30 17:40:30','521','2021-03-30 17:41:11',10,0),('1','142',187816,'DAILY SALES','2021-03-31','2021-03-31 00:00:00',NULL,'521',0.00,0.00,'521','2021-03-31 17:36:31','521','2021-03-31 17:37:36',10,0),('1','142',188023,'DAILY SALES','2021-04-01','2021-04-01 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-01 17:31:08','521','2021-04-01 17:32:06',10,0),('1','142',188239,'DAILY SALES','2021-04-02','2021-04-02 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-02 17:45:53','521','2021-04-02 17:46:56',10,0),('1','142',188437,'DAILY SALES','2021-04-03','2021-04-03 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-03 15:14:07','521','2021-04-03 15:16:53',10,0),('1','142',188539,'DAILY SALES','2021-04-03','2021-04-03 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-03 17:31:16','521','2021-04-03 17:36:14',10,0),('1','142',188615,'DAILY SALES','2021-04-04','2021-04-04 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-04 17:27:50','521','2021-04-04 17:28:46',10,0),('1','142',188834,'DAILY SALES','2021-04-05','2021-04-05 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-05 17:08:48','521','2021-04-05 17:09:41',10,0),('1','142',189085,'DAILY SALES','2021-04-06','2021-04-06 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-06 18:07:52','521','2021-04-06 18:09:45',10,0),('1','142',189218,'DAILY SALES','2021-04-07','2021-04-07 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-07 18:41:23','521','2021-04-07 18:42:11',10,0),('1','142',189426,'DAILY SALES','2021-04-08','2021-04-08 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-09 08:00:58','521','2021-04-09 08:01:29',10,0),('1','142',189643,'DAILY SALES','2021-04-09','2021-04-09 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-09 18:08:36','521','2021-04-09 18:09:30',10,0),('1','142',189840,'DAILY SALES','2021-04-10','2021-04-10 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-10 17:26:40','521','2021-04-10 17:28:31',10,0),('1','142',190036,'DAILY SALES','2021-04-11','2021-04-11 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-11 17:46:33','521','2021-04-11 17:47:42',10,0),('1','142',190227,'DAILY SALES','2021-04-12','2021-04-12 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-12 17:52:55','521','2021-04-12 17:54:36',10,0),('1','142',190440,'DAILY SALES','2021-04-13','2021-04-13 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-13 10:18:53','521','2021-04-13 10:19:22',10,0),('1','142',190505,'DAILY SALES','2021-04-13','2021-04-13 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-13 17:36:33','521','2021-04-13 17:37:40',10,0),('1','142',190676,'DAILY SALES','2021-04-14','2021-04-14 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-14 16:40:01','521','2021-04-14 16:40:40',10,0),('1','142',190909,'DAILY SALES','2021-04-15','2021-04-15 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-15 16:46:24','521','2021-04-15 16:47:13',10,0),('1','142',191096,'DAILY SALES','2021-04-16','2021-04-16 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-16 16:49:36','521','2021-04-16 16:50:29',10,0),('1','142',191327,'DAILY SALES','2021-04-17','2021-04-17 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-17 16:46:40','521','2021-04-17 16:49:14',10,0),('1','142',191531,'DAILY SALES','2021-04-18','2021-04-18 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-18 16:14:43','521','2021-04-18 16:21:39',10,0),('1','142',191729,'DAILY SALES','2021-04-19','2021-04-19 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-19 17:05:26','521','2021-04-19 17:06:43',10,0),('1','142',191943,'DAILY SALES','2021-04-20','2021-04-20 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-20 17:00:27','521','2021-04-20 17:01:37',10,0),('1','142',192158,'DAILY SALES','2021-04-21','2021-04-21 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-21 11:05:38','521','2021-04-21 11:08:17',10,0),('1','142',192222,'DAILY SALES','2021-04-21','2021-04-21 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-21 17:29:22','521','2021-04-21 17:29:57',10,0),('1','142',192356,'DAILY SALES','2021-04-22','2021-04-22 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-22 16:51:06','521','2021-04-22 16:56:49',10,0),('1','142',192587,'DAILY SALES','2021-04-23','2021-04-23 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-23 18:37:52','521','2021-04-23 18:38:47',10,0),('1','142',192763,'DAILY SALES','2021-04-24','2021-04-24 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-24 16:48:32','521','2021-04-24 16:49:58',10,0),('1','142',192960,'DAILY SALES','2021-04-25','2021-04-25 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-25 16:19:38','521','2021-04-25 16:20:58',10,0),('1','142',193176,'DAILY SALES','2021-04-26','2021-04-26 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-26 16:56:52','521','2021-04-26 17:02:54',10,0),('1','142',193420,'DAILY SALES','2021-04-27','2021-04-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-27 16:38:07','521','2021-04-27 16:40:01',10,0),('1','142',193633,'DAILY SALES','2021-04-28','2021-04-28 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-28 22:46:40','521','2021-04-28 22:47:19',10,0),('1','142',193866,'DAILY SALES','2021-04-29','2021-04-29 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-29 16:46:50','521','2021-04-29 16:48:00',10,0),('1','142',194094,'DAILY SALES','2021-04-30','2021-04-30 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-30 07:59:24','521','2021-04-30 07:59:55',10,0),('1','142',194113,'DAILY SALES','2021-04-30','2021-04-30 00:00:00',NULL,'521',0.00,0.00,'521','2021-04-30 17:38:24','521','2021-04-30 17:39:26',10,0),('1','142',194298,'DAILY SALES','2021-05-01','2021-05-01 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-01 16:56:25','521','2021-05-01 17:00:50',10,0),('1','142',194493,'DAILY SALES','2021-05-02','2021-05-02 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-02 18:32:22','521','2021-05-02 18:32:47',10,0),('1','142',194714,'DAILY SALES','2021-05-03','2021-05-03 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-03 16:30:29','521','2021-05-03 16:32:21',10,0),('1','142',194945,'DAILY SALES','2021-05-04','2021-05-04 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-04 16:51:03','521','2021-05-04 16:51:39',10,0),('1','142',195091,'DAILY SALES','2021-05-05','2021-05-05 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-05 17:12:34','521','2021-05-05 17:13:03',10,0),('1','142',195311,'DAILY SALES','2021-05-06','2021-05-06 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-06 16:44:08','521','2021-05-06 16:45:58',10,0),('1','142',195544,'DAILY SALES','2021-05-07','2021-05-07 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-07 17:18:29','521','2021-05-07 17:19:31',10,0),('1','142',195794,'DAILY SALES','2021-05-08','2021-05-08 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-08 07:50:50','521','2021-05-08 07:51:28',10,0),('1','142',195812,'DAILY SALES','2021-05-08','2021-05-08 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-08 19:55:41','521','2021-05-08 19:56:09',10,0),('1','142',196015,'DAILY SALES','2021-05-09','2021-05-09 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-09 16:42:31','521','2021-05-09 16:43:02',10,0),('1','142',196240,'DAILY SALES','2021-05-10','2021-05-10 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-10 20:29:34','521','2021-05-10 20:30:13',10,0),('1','142',196470,'DAILY SALES','2021-05-11','2021-05-11 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-11 18:15:25','521','2021-05-11 18:16:57',10,0),('1','142',196672,'DAILY SALES','2021-05-12','2021-05-12 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-13 09:14:44','521','2021-05-13 09:16:21',10,0),('1','142',196889,'DAILY SALES','2021-05-13','2021-05-13 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-13 19:23:38','521','2021-05-13 19:24:02',10,0),('1','142',197056,'DAILY SALES','2021-05-14','2021-05-14 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-14 17:37:01','521','2021-05-14 17:37:53',10,0),('1','142',197334,'DAILY SALES','2021-05-15','2021-05-15 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-16 12:21:46','521','2021-05-16 12:22:50',10,0),('1','142',197340,'DAILY SALES','2021-05-16','2021-05-16 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-16 17:51:59','521','2021-05-16 17:52:33',10,0),('1','142',197521,'DAILY SALES','2021-05-17','2021-05-17 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-17 17:47:05','521','2021-05-17 17:47:33',10,0),('1','142',197894,'DAILY SALES','2021-05-18','2021-05-18 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-18 17:11:45','521','2021-05-18 17:12:07',10,0),('1','142',198128,'DAILY SALES','2021-05-19','2021-05-19 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-19 17:36:00','521','2021-05-19 17:36:37',10,0),('1','142',198367,'DAILY SALES','2021-05-20','2021-05-20 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-20 17:55:27','521','2021-05-20 18:02:15',10,0),('1','142',198590,'DAILY SALES','2021-05-21','2021-05-21 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-21 18:04:41','521','2021-05-21 18:05:19',10,0),('1','142',198795,'DAILY SALES','2021-05-22','2021-05-22 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-22 17:55:43','521','2021-05-22 17:56:13',10,0),('1','142',198985,'DAILY SALES','2021-05-23','2021-05-23 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-23 15:09:45','521','2021-05-23 15:10:09',10,0),('1','142',199143,'DAILY SALES','2021-05-23','2021-05-23 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-23 17:19:11','521','2021-05-23 17:19:49',10,0),('1','142',199225,'DAILY SALES','2021-05-24','2021-05-24 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-24 17:38:33','521','2021-05-24 17:38:57',10,0),('1','142',199452,'DAILY SALES','2021-05-25','2021-05-25 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-25 17:33:43','521','2021-05-25 17:34:14',10,0),('1','142',199664,'DAILY SALES','2021-05-26','2021-05-26 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-26 17:23:47','521','2021-05-26 17:24:20',10,0),('1','142',199883,'DAILY SALES','2021-05-27','2021-05-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-27 17:32:38','521','2021-05-27 17:35:22',10,0),('1','142',200104,'DAILY SALES','2021-05-28','2021-05-28 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-28 17:32:53','521','2021-05-28 17:33:36',10,0),('1','142',200304,'DAILY SALES','2021-05-29','2021-05-29 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-29 17:20:55','521','2021-05-29 17:22:07',10,0),('1','142',200502,'DAILY SALES','2021-05-30','2021-05-30 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-30 17:34:48','521','2021-05-30 17:37:36',10,0),('1','142',200714,'DAILY SALES','2021-05-31','2021-05-31 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-31 07:51:54','521','2021-05-31 07:52:17',10,0),('1','142',200728,'DAILY SALES','2021-05-31','2021-05-31 00:00:00',NULL,'521',0.00,0.00,'521','2021-05-31 17:36:08','521','2021-05-31 17:37:33',10,0),('1','142',200939,'DAILY SALES','2021-06-01','2021-06-01 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-01 17:38:06','521','2021-06-01 17:39:16',10,0),('1','142',201131,'DAILY SALES','2021-06-02','2021-06-02 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-02 17:58:06','521','2021-06-02 17:58:29',10,0),('1','142',201331,'DAILY SALES','2021-06-03','2021-06-03 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-03 17:34:33','521','2021-06-03 17:35:04',10,0),('1','142',201512,'DAILY SALES','2021-06-04','2021-06-04 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-04 17:16:52','521','2021-06-04 17:17:21',10,0),('1','142',201783,'DAILY SALES','2021-06-05','2021-06-05 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-05 17:40:05','521','2021-06-05 17:40:50',10,0),('1','142',202044,'DAILY SALES','2021-06-06','2021-06-06 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-06 18:19:29','521','2021-06-06 18:19:57',10,0),('1','142',202266,'DAILY SALES','2021-06-07','2021-06-07 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-07 10:26:10','521','2021-06-07 10:26:52',10,0),('1','142',202304,'DAILY SALES','2021-06-07','2021-06-07 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-07 17:48:52','521','2021-06-07 17:52:08',10,0),('1','142',202444,'DAILY SALES','2021-06-08','2021-06-08 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-08 17:58:40','521','2021-06-08 17:59:10',10,0),('1','142',202663,'DAILY SALES','2021-06-09','2021-06-09 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-09 17:46:09','521','2021-06-09 17:46:51',10,0),('1','142',202879,'DAILY SALES','2021-06-10','2021-06-10 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-10 18:06:49','521','2021-06-10 18:07:26',10,0),('1','142',203127,'DAILY SALES','2021-06-11','2021-06-11 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-11 17:29:44','521','2021-06-11 17:30:39',10,0),('1','142',203320,'DAILY SALES','2021-06-12','2021-06-12 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-12 17:21:59','521','2021-06-12 17:23:47',10,0),('1','142',203537,'DAILY SALES','2021-06-13','2021-06-13 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-13 17:37:47','521','2021-06-13 17:39:10',10,0),('1','142',203746,'DAILY SALES','2021-06-14','2021-06-14 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-14 17:35:06','521','2021-06-14 17:35:36',10,0),('1','142',203983,'DAILY SALES','2021-06-15','2021-06-15 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-15 17:37:49','521','2021-06-15 17:38:12',10,0),('1','142',204143,'DAILY SALES','2021-06-15','2021-06-15 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-15 18:53:45','521','2021-06-15 18:54:15',10,0),('1','142',204206,'DAILY SALES','2021-06-16','2021-06-16 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-16 17:58:57','521','2021-06-16 17:59:28',10,0),('1','142',204421,'DAILY SALES','2021-06-17','2021-06-17 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-17 17:01:25','521','2021-06-17 17:02:03',10,0),('1','142',204640,'DAILY SALES','2021-06-18','2021-06-18 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-18 17:21:59','521','2021-06-18 17:22:22',10,0),('1','142',204857,'DAILY SALES','2021-06-19','2021-06-19 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-19 17:25:36','521','2021-06-19 17:30:22',10,0),('1','142',205057,'DAILY SALES','2021-06-20','2021-06-20 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-20 17:21:47','521','2021-06-20 17:22:54',10,0),('1','142',205249,'DAILY SALES','2021-06-21','2021-06-21 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-21 17:05:35','521','2021-06-21 17:06:20',10,0),('1','142',205486,'DAILY SALES','2021-06-22','2021-06-22 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-22 17:08:36','521','2021-06-22 17:09:03',10,0),('1','142',205745,'DAILY SALES','2021-06-23','2021-06-23 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-23 17:15:29','521','2021-06-23 17:16:22',10,0),('1','142',205965,'DAILY SALES','2021-06-24','2021-06-24 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-24 08:18:09','521','2021-06-24 08:18:54',10,0),('1','142',205992,'DAILY SALES','2021-06-24','2021-06-24 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-24 17:22:07','521','2021-06-24 17:22:46',10,0),('1','142',206171,'DAILY SALES','2021-06-25','2021-06-25 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-25 22:08:18','521','2021-06-25 22:09:05',10,0),('1','142',206370,'DAILY SALES','2021-06-26','2021-06-26 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-26 17:20:12','521','2021-06-26 17:20:47',10,0),('1','142',206587,'DAILY SALES','2021-06-27','2021-06-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-27 17:21:03','521','2021-06-27 17:21:54',10,0),('1','142',206840,'DAILY SALES','2021-06-28','2021-06-28 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-28 17:08:32','521','2021-06-28 17:09:12',10,0),('1','142',207051,'DAILY SALES','2021-06-29','2021-06-29 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-29 17:31:24','521','2021-06-29 17:32:54',10,0),('1','142',207273,'DAILY SALES','2021-06-30','2021-06-30 00:00:00',NULL,'521',0.00,0.00,'521','2021-06-30 17:28:05','521','2021-06-30 17:28:46',10,0),('1','142',207617,'DAILY SALES','2021-07-01','2021-07-01 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-01 17:23:14','521','2021-07-01 17:24:11',10,0),('1','142',208302,'DAILY SALES','2021-07-01','2021-07-01 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-04 21:10:06','521','2021-07-04 21:10:41',10,0),('1','142',208303,'DAILY SALES','2021-07-02','2021-07-02 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-04 21:22:24','521','2021-07-04 21:22:53',10,0),('1','142',208305,'DAILY SALES','2021-07-03','2021-07-03 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-04 21:42:47','521','2021-07-04 21:43:13',10,0),('1','142',208306,'DAILY SALES','2021-07-04','2021-07-04 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-05 07:13:53','521','2021-07-05 07:14:17',10,0),('1','142',208352,'DAILY SALES','2021-07-05','2021-07-05 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-05 17:58:45','521','2021-07-05 18:01:54',10,0),('1','142',208579,'DAILY SALES','2021-07-06','2021-07-06 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-06 17:18:46','521','2021-07-06 17:19:32',10,0),('1','142',208772,'DAILY SALES','2021-07-07','2021-07-07 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-07 17:26:38','521','2021-07-07 17:27:11',10,0),('1','142',209011,'DAILY SALES','2021-07-08','2021-07-08 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-08 15:07:56','521','2021-07-08 15:09:36',10,0),('1','142',209147,'DAILY SALES','2021-07-08','2021-07-08 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-08 17:38:56','521','2021-07-08 17:39:30',10,0),('1','142',209233,'DAILY SALES','2021-07-09','2021-07-09 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-09 17:33:57','521','2021-07-09 17:34:34',10,0),('1','142',209453,'DAILY SALES','2021-07-10','2021-07-10 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-10 17:11:16','521','2021-07-10 17:11:51',10,0),('1','142',209655,'DAILY SALES','2021-07-11','2021-07-11 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-11 17:30:25','521','2021-07-11 17:31:12',10,0),('1','142',209881,'DAILY SALES','2021-07-12','2021-07-12 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-12 17:27:19','521','2021-07-12 17:28:02',10,0),('1','142',210114,'DAILY SALES','2021-07-13','2021-07-13 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-13 17:35:48','521','2021-07-13 17:36:27',10,0),('1','142',210324,'DAILY SALES','2021-07-14','2021-07-14 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-14 16:57:00','521','2021-07-14 16:57:27',10,0),('1','142',210525,'DAILY SALES','2021-07-15','2021-07-15 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-15 18:10:43','521','2021-07-15 18:11:29',10,0),('1','142',210742,'DAILY SALES','2021-07-16','2021-07-16 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-16 10:03:25','521','2021-07-16 10:03:50',10,0),('1','142',210809,'DAILY SALES','2021-07-16','2021-07-16 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-16 17:55:26','521','2021-07-16 17:55:51',10,0),('1','142',210977,'DAILY SALES','2021-07-17','2021-07-17 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-17 17:26:04','521','2021-07-17 17:26:38',10,0),('1','142',211185,'DAILY SALES','2021-07-18','2021-07-18 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-18 17:53:14','521','2021-07-18 17:54:21',10,0),('1','142',211397,'DAILY SALES','2021-07-19','2021-07-19 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-19 19:08:05','521','2021-07-19 19:09:12',10,0),('1','142',211614,'DAILY SALES','2021-07-20','2021-07-20 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-20 12:24:00','521','2021-07-20 12:24:30',10,0),('1','142',211663,'DAILY SALES','2021-07-20','2021-07-20 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-20 18:17:51','521','2021-07-20 18:18:25',10,0),('1','142',211803,'DAILY SALES','2021-07-21','2021-07-21 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-21 17:06:53','521','2021-07-21 17:07:35',10,0),('1','142',212009,'DAILY SALES','2021-07-22','2021-07-22 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-22 17:18:06','521','2021-07-22 17:18:37',10,0),('1','142',212252,'DAILY SALES','2021-07-23','2021-07-23 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-23 17:52:47','521','2021-07-23 17:53:57',10,0),('1','142',212476,'DAILY SALES','2021-07-24','2021-07-24 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-24 18:08:56','521','2021-07-24 18:09:42',10,0),('1','142',212682,'DAILY SALES','2021-07-25','2021-07-25 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-25 18:10:22','521','2021-07-25 18:11:07',10,0),('1','142',212895,'DAILY SALES','2021-07-26','2021-07-26 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-26 17:35:30','521','2021-07-26 17:36:01',10,0),('1','142',213157,'DAILY SALES','2021-07-27','2021-07-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-27 18:02:47','521','2021-07-27 18:03:39',10,0),('1','142',213413,'DAILY SALES','2021-07-28','2021-07-28 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-28 17:22:20','521','2021-07-28 17:22:52',10,0),('1','142',213589,'DAILY SALES','2021-07-28','2021-07-28 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-28 17:41:46','521','2021-07-28 17:42:24',10,0),('1','142',213657,'DAILY SALES','2021-07-29','2021-07-29 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-29 17:46:55','521','2021-07-29 17:48:54',10,0),('1','142',213906,'DAILY SALES','2021-07-30','2021-07-30 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-30 17:40:37','521','2021-07-30 17:42:27',10,0),('1','142',214113,'DAILY SALES','2021-07-31','2021-07-31 00:00:00',NULL,'521',0.00,0.00,'521','2021-07-31 17:07:39','521','2021-07-31 17:08:29',10,0),('1','142',214361,'DAILY SALES','2021-08-01','2021-08-01 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-01 17:55:42','521','2021-08-01 17:56:12',10,0),('1','142',214544,'DAILY SALES','2021-08-02','2021-08-02 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-02 17:10:09','521','2021-08-02 17:11:22',10,0),('1','142',214821,'DAILY SALES','2021-08-03','2021-08-03 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-03 17:51:02','521','2021-08-03 17:51:52',10,0),('1','142',215033,'DAILY SALES','2021-08-04','2021-08-04 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-04 18:00:26','521','2021-08-04 18:02:24',10,0),('1','142',215240,'DAILY SALES','2021-08-05','2021-08-05 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-05 17:31:09','521','2021-08-05 17:32:05',10,0),('1','142',215457,'DAILY SALES','2021-08-06','2021-08-06 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-06 17:03:48','521','2021-08-06 17:04:23',10,0),('1','142',215692,'DAILY SALES','2021-08-06','2021-08-06 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-07 07:42:33','521','2021-08-07 07:42:56',10,0),('1','142',215695,'DAILY SALES','2021-08-07','2021-08-07 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-07 17:18:59','521','2021-08-07 17:20:17',10,0),('1','142',215927,'DAILY SALES','2021-08-08','2021-08-08 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-08 17:26:17','521','2021-08-08 17:27:11',10,0),('1','142',216122,'DAILY SALES','2021-08-09','2021-08-09 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-09 17:08:12','521','2021-08-09 17:08:41',10,0),('1','142',216349,'DAILY SALES','2021-08-10','2021-08-10 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-10 17:42:13','521','2021-08-10 17:42:44',10,0),('1','142',216736,'DAILY SALES','2021-08-11','2021-08-11 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-11 17:29:36','521','2021-08-11 17:30:09',10,0),('1','142',216803,'DAILY SALES','2021-08-12','2021-08-12 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-12 17:12:45','521','2021-08-12 17:13:34',10,0),('1','142',217056,'DAILY SALES','2021-08-13','2021-08-13 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-13 15:26:31','521','2021-08-13 15:28:31',10,0),('1','142',217211,'DAILY SALES','2021-08-13','2021-08-13 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-14 07:25:34','521','2021-08-14 07:26:18',10,0),('1','142',217304,'DAILY SALES','2021-08-14','2021-08-14 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-14 17:31:02','521','2021-08-14 17:32:03',10,0),('1','142',217517,'DAILY SALES','2021-08-15','2021-08-15 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-15 17:06:02','521','2021-08-15 17:07:09',10,0),('1','142',217760,'DAILY SALES','2021-08-16','2021-08-16 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-16 17:42:47','521','2021-08-16 17:44:13',10,0),('1','142',217990,'DAILY SALES','2021-08-17','2021-08-17 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-17 17:00:41','521','2021-08-17 17:01:58',10,0),('1','142',218243,'DAILY SALES','2021-08-18','2021-08-18 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-18 17:25:09','521','2021-08-18 17:34:25',10,0),('1','142',218488,'DAILY SALES','2021-08-19','2021-08-19 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-19 17:16:26','521','2021-08-19 17:17:30',10,0),('1','142',218703,'DAILY SALES','2021-08-20','2021-08-20 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-20 17:17:59','521','2021-08-20 17:18:40',10,0),('1','142',218928,'DAILY SALES','2021-08-21','2021-08-21 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-21 17:24:58','521','2021-08-21 17:25:30',10,0),('1','142',219140,'DAILY SALES','2021-08-22','2021-08-22 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-22 07:43:58','521','2021-08-22 07:44:49',10,0),('1','142',219144,'DAILY SALES','2021-08-22','2021-08-22 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-22 17:02:51','521','2021-08-22 17:04:41',10,0),('1','142',219382,'DAILY SALES','2021-08-23','2021-08-23 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-23 17:03:20','521','2021-08-23 17:04:14',10,0),('1','142',219632,'DAILY SALES','2021-08-24','2021-08-24 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-24 17:07:29','521','2021-08-24 17:08:15',10,0),('1','142',219835,'DAILY SALES','2021-08-25','2021-08-25 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-25 17:17:25','521','2021-08-25 17:19:18',10,0),('1','142',220073,'DAILY SALES','2021-08-26','2021-08-26 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-26 17:38:17','521','2021-08-26 17:40:41',10,0),('1','142',220269,'DAILY SALES','2021-08-27','2021-08-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-27 17:21:54','521','2021-08-27 17:23:28',10,0),('1','142',220478,'DAILY SALES','2021-08-28','2021-08-28 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-28 17:51:01','521','2021-08-28 17:53:10',10,0),('1','142',220702,'DAILY SALES','2021-08-29','2021-08-29 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-29 17:15:19','521','2021-08-29 17:16:16',10,0),('1','142',220931,'DAILY SALES','2021-08-30','2021-08-30 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-30 09:55:17','521','2021-08-30 09:56:00',10,0),('1','142',221004,'DAILY SALES','2021-08-30','2021-08-30 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-30 17:04:23','521','2021-08-30 17:07:12',10,0),('1','142',221167,'DAILY SALES','2021-08-31','2021-08-31 00:00:00',NULL,'521',0.00,0.00,'521','2021-08-31 17:27:15','521','2021-08-31 17:29:12',10,0),('1','142',221400,'DAILY SALES','2021-09-01','2021-09-01 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-01 17:47:11','521','2021-09-01 17:49:04',10,0),('1','142',221669,'DAILY SALES','2021-09-02','2021-09-02 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-02 17:29:56','521','2021-09-02 17:33:53',10,0),('1','142',221845,'DAILY SALES','2021-09-03','2021-09-03 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-03 18:12:15','521','2021-09-03 18:21:54',10,0),('1','142',222080,'DAILY SALES','2021-09-04','2021-09-04 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-04 14:29:01','521','2021-09-04 14:30:46',10,0),('1','142',222195,'DAILY SALES','2021-09-04','2021-09-04 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-04 17:11:18','521','2021-09-04 17:14:33',10,0),('1','142',222292,'DAILY SALES','2021-09-05','2021-09-05 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-05 16:51:46','521','2021-09-05 16:52:40',10,0),('1','142',222525,'DAILY SALES','2021-09-06','2021-09-06 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-06 17:29:51','521','2021-09-06 17:30:56',10,0),('1','142',222783,'DAILY SALES','2021-09-07','2021-09-07 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-07 18:11:21','521','2021-09-07 18:12:12',10,0),('1','142',222984,'DAILY SALES','2021-09-07','2021-09-07 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-08 08:59:53','521','2021-09-08 09:00:57',10,0),('1','142',222989,'DAILY SALES','2021-09-08','2021-09-08 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-08 18:26:26','521','2021-09-08 18:27:21',10,0),('1','142',223193,'DAILY SALES','2021-09-09','2021-09-09 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-09 18:55:12','521','2021-09-09 18:55:53',10,0),('1','142',223436,'DAILY SALES','2021-09-10','2021-09-10 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-10 17:49:23','521','2021-09-10 17:50:35',10,0),('1','142',223658,'DAILY SALES','2021-09-11','2021-09-11 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-11 10:22:36','521','2021-09-11 10:23:59',10,0),('1','142',223722,'DAILY SALES','2021-09-11','2021-09-11 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-11 17:52:29','521','2021-09-11 17:56:18',10,0),('1','142',223883,'DAILY SALES','2021-09-12','2021-09-12 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-12 17:46:50','521','2021-09-12 17:48:30',10,0),('1','142',224114,'DAILY SALES','2021-09-13','2021-09-13 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-13 17:42:41','521','2021-09-13 17:46:31',10,0),('1','142',224321,'DAILY SALES','2021-09-14','2021-09-14 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-14 18:27:44','521','2021-09-14 18:30:09',10,0),('1','142',224559,'DAILY SALES','2021-09-15','2021-09-15 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-15 17:26:47','521','2021-09-15 17:29:14',10,0),('1','142',224795,'DAILY SALES','2021-09-16','2021-09-16 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-16 17:37:30','521','2021-09-16 17:40:10',10,0),('1','142',225042,'DAILY SALES','2021-09-17','2021-09-17 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-17 17:48:00','521','2021-09-17 17:52:02',10,0),('1','142',225290,'DAILY SALES','2021-09-18','2021-09-18 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-18 18:04:49','521','2021-09-18 18:06:18',10,0),('1','142',225500,'DAILY SALES','2021-09-19','2021-09-19 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-19 16:26:12','521','2021-09-19 16:26:56',10,0),('1','142',225641,'DAILY SALES','2021-09-19','2021-09-19 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-19 17:21:39','521','2021-09-19 17:22:13',10,0),('1','142',225721,'DAILY SALES','2021-09-20','2021-09-20 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-21 07:14:12','521','2021-09-21 07:15:16',10,0),('1','142',225995,'DAILY SALES','2021-09-21','2021-09-21 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-21 17:41:51','521','2021-09-21 17:43:45',10,0),('1','142',226257,'DAILY SALES','2021-09-22','2021-09-22 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-22 17:57:04','521','2021-09-22 17:57:35',10,0),('1','142',226501,'DAILY SALES','2021-09-23','2021-09-23 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-23 17:52:09','521','2021-09-23 17:53:34',10,0),('1','142',226761,'DAILY SALES','2021-09-24','2021-09-24 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-24 17:52:30','521','2021-09-24 17:53:59',10,0),('1','142',226982,'DAILY SALES','2021-09-25','2021-09-25 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-25 17:49:17','521','2021-09-25 17:51:31',10,0),('1','142',227197,'DAILY SALES','2021-09-26','2021-09-26 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-26 17:33:21','521','2021-09-26 17:35:10',10,0),('1','142',227392,'DAILY SALES','2021-09-27','2021-09-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-27 09:38:25','521','2021-09-27 09:38:52',10,0),('1','142',227455,'DAILY SALES','2021-09-27','2021-09-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-27 18:02:47','521','2021-09-27 18:03:41',10,0),('1','142',227625,'DAILY SALES','2021-09-28','2021-09-28 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-28 17:37:49','521','2021-09-28 17:40:28',10,0),('1','142',228097,'Daily Sales','2021-09-29','2021-09-29 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-29 20:15:52','521','2021-09-29 20:16:29',10,0),('1','142',228329,'Daily Sales','2021-09-30','2021-09-30 00:00:00',NULL,'521',0.00,0.00,'521','2021-09-30 20:29:51','521','2021-09-30 20:31:00',10,0),('1','142',228509,'Daily Sales','2021-10-01','2021-10-01 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-01 20:10:34','521','2021-10-01 20:11:41',10,0),('1','142',228735,'Daily Sales','2021-10-02','2021-10-02 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-02 21:39:16','521','2021-10-02 21:39:51',10,0),('1','142',228959,'Daily Sales','2021-10-03','2021-10-03 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-04 07:19:50','521','2021-10-04 07:20:22',10,0),('1','142',229210,'Daily Sales','2021-10-04','2021-10-04 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-05 08:44:04','521','2021-10-05 08:45:36',10,0),('1','142',229216,'Daily Sales','2021-10-04','2021-10-04 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-05 16:06:14','521','2021-10-05 16:07:14',10,0),('1','142',229436,'Daily Sales','2021-10-05','2021-10-05 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-06 07:36:17','521','2021-10-06 07:36:58',10,0),('1','142',229644,'Daily Sales','2021-10-06','2021-10-06 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-06 20:52:59','521','2021-10-06 20:53:37',10,0),('1','142',229869,'Daily Sales','2021-10-07','2021-10-07 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-07 21:42:18','521','2021-10-07 21:43:20',10,0),('1','142',229972,'Daily Sales','2021-10-08','2021-10-08 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-08 19:58:35','521','2021-10-08 19:59:07',10,0),('1','142',230259,'Daily Sales','2021-10-09','2021-10-09 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-09 19:42:57','521','2021-10-09 19:44:02',10,0),('1','142',230450,'DAILY SALES','2021-10-10','2021-10-10 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-11 06:55:59','521','2021-10-11 06:57:04',10,0),('1','142',230792,'Daily Sales','2021-10-11','2021-10-11 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-12 06:53:58','521','2021-10-12 06:55:02',10,0),('1','142',231123,'DAILY SALES','2021-10-12','2021-10-12 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-13 09:08:30','521','2021-10-13 09:14:50',10,0),('1','142',231125,'DAILY SALES','2021-10-12','2021-10-12 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-13 09:20:18','521','2021-10-13 09:21:03',10,0),('1','142',231348,'DAILY SALES','2021-10-13','2021-10-13 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-13 21:09:33','521','2021-10-13 21:10:15',10,0),('1','142',231613,'DAILY SALES','2021-10-14','2021-10-14 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-14 21:15:13','521','2021-10-14 21:15:43',10,0),('1','142',232041,'DAILY SALES','2021-10-15','2021-10-15 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-16 16:34:27','521','2021-10-16 16:35:06',10,0),('1','142',232138,'DAILY SALES','2021-10-16','2021-10-16 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-17 08:32:37','521','2021-10-17 08:36:14',10,0),('1','142',232313,'DAILY SALES','2021-10-17','2021-10-17 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-17 22:00:32','521','2021-10-17 22:01:01',10,0),('1','142',232675,'DAILY SALES','2021-10-19','2021-10-19 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-19 09:57:08','521','2021-10-19 09:57:59',10,0),('1','142',232677,'DAILY SALES','2021-10-18','2021-10-18 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-19 10:08:21','521','2021-10-19 10:11:12',10,0),('1','142',232979,'DAILY SALES','2021-10-19','2021-10-19 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-20 12:23:40','521','2021-10-20 12:35:40',10,0),('1','142',233028,'DAILY SALES','2021-10-20','2021-10-20 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-20 14:48:44','521','2021-10-20 14:49:18',10,0),('1','142',233106,'DAILY SALES','2021-10-20','2021-10-20 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-21 05:56:35','521','2021-10-21 05:57:07',10,0),('1','142',233288,'DAILY SALES','2021-10-21','2021-10-21 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-21 17:40:29','521','2021-10-21 17:42:11',10,0),('1','142',233400,'DAILY SALES','2021-10-22','2021-10-22 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-22 17:24:25','521','2021-10-22 17:26:10',10,0),('1','142',233632,'DAILY SALES','2021-10-23','2021-10-23 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-23 17:41:04','521','2021-10-23 19:32:12',10,0),('1','142',233875,'DAILY SALES','2021-10-24','2021-10-24 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-24 17:50:28','521','2021-10-24 17:57:04',10,0),('1','142',234081,'DAILY SALES','2021-10-25','2021-10-25 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-25 17:58:07','521','2021-10-25 18:01:51',10,0),('1','142',234331,'DAILY SALES','2021-10-26','2021-10-26 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-26 17:18:34','521','2021-10-26 17:20:47',10,0),('1','142',234600,'DAILY SALES','2021-10-27','2021-10-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-27 17:45:48','521','2021-10-27 17:49:05',10,0),('1','142',234869,'DAILY SALES','2021-10-28','2021-10-28 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-29 06:42:24','521','2021-10-29 06:47:37',10,0),('1','142',235096,'DAILY SALES','2021-10-29','2021-10-29 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-29 16:35:25','521','2021-10-29 16:36:47',10,0),('1','142',235242,'DAILY SALES','2021-10-29','2021-10-29 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-29 17:50:18','521','2021-10-29 17:52:00',10,0),('1','142',235333,'DAILY SALES','2021-10-30','2021-10-30 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-30 17:56:43','521','2021-10-30 17:58:44',10,0),('1','142',235557,'DAILY SALES','2021-10-31','2021-10-31 00:00:00',NULL,'521',0.00,0.00,'521','2021-10-31 21:09:13','521','2021-10-31 21:13:08',10,0),('1','142',235791,'DAILY SALES','2021-11-01','2021-11-01 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-01 17:45:06','521','2021-11-01 17:54:56',10,0),('1','142',236064,'DAILY SALES','2021-11-02','2021-11-02 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-02 17:23:08','521','2021-11-02 17:36:45',10,0),('1','142',236256,'DAILY SALES','2021-11-03','2021-11-03 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-04 07:41:40','521','2021-11-04 07:44:48',10,0),('1','142',236561,'DAILY SALES','2021-11-04','2021-11-04 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-04 08:16:43','521','2021-11-04 08:17:16',10,0),('1','142',236570,'DAILY SALES','2021-11-03','2021-11-03 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-04 08:21:55','521','2021-11-04 08:22:56',10,0),('1','142',236573,'DAILY SALES','2021-11-04','2021-11-04 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-04 17:37:07','521','2021-11-04 17:40:12',10,0),('1','142',236768,'DAILY SALES','2021-11-05','2021-11-05 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-05 17:39:23','521','2021-11-05 17:40:03',10,0),('1','142',236991,'DAILY SALES','2021-11-06','2021-11-06 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-06 17:05:27','521','2021-11-06 17:05:51',10,0),('1','142',237187,'DAILY SALES','2021-11-07','2021-11-07 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-07 16:37:42','521','2021-11-07 16:38:05',10,0),('1','142',237323,'DAILY SALES','2021-11-07','2021-11-07 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-07 19:39:42','521','2021-11-07 19:40:19',10,0),('1','142',237423,'DAILY SALES','2021-11-08','2021-11-08 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-08 17:49:22','521','2021-11-08 17:49:51',10,0),('1','142',237641,'DAILY SALES','2021-11-09','2021-11-09 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-09 17:35:12','521','2021-11-09 17:35:45',10,0),('1','142',237891,'DAILY SALES','2021-11-10','2021-11-10 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-10 17:48:44','521','2021-11-10 17:49:30',10,0),('1','142',238157,'DAILY SALES','2021-11-11','2021-11-11 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-11 17:24:52','521','2021-11-11 17:25:22',10,0),('1','142',238388,'DAILY SALES','2021-11-12','2021-11-12 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-12 17:31:44','521','2021-11-12 17:32:09',10,0),('1','142',238642,'DAILY SALES','2021-11-13','2021-11-13 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-13 18:07:29','521','2021-11-13 18:09:07',10,0),('1','142',238859,'DAILY SALES','2021-11-14','2021-11-14 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-14 17:17:35','521','2021-11-14 17:17:59',10,0),('1','142',239089,'DAILY SALES','2021-11-15','2021-11-15 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-15 17:30:57','521','2021-11-15 17:31:32',10,0),('1','142',239326,'DAILY SALES','2021-11-16','2021-11-16 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-16 07:32:59','521','2021-11-16 07:33:42',10,0),('1','142',239335,'DAILY SALES','2021-11-16','2021-11-16 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-16 17:25:37','521','2021-11-16 17:26:39',10,0),('1','142',239553,'DAILY SALES','2021-11-17','2021-11-17 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-17 17:50:31','521','2021-11-17 17:54:15',10,0),('1','142',239762,'DAILY SALES','2021-11-18','2021-11-18 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-18 17:30:33','521','2021-11-18 17:31:51',10,0),('1','142',240010,'DAILY SALES','2021-11-19','2021-11-19 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-19 17:21:38','521','2021-11-19 17:22:25',10,0),('1','142',240210,'DAILY SALES','2021-11-20','2021-11-20 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-20 17:34:47','521','2021-11-20 17:35:27',10,0),('1','142',240458,'DAILY SALES','2021-11-21','2021-11-21 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-21 18:00:26','521','2021-11-21 18:01:18',10,0),('1','142',240634,'DAILY SALES','2020-09-28','2020-09-28 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-21 22:19:14','521','2021-11-21 22:19:34',10,0),('1','142',240636,'DAILY SALES','2020-12-07','2020-12-07 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-21 22:25:48','521','2021-11-21 22:26:10',10,0),('1','142',240638,'DAILY SALES','2020-12-16','2020-12-16 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-21 22:30:06','521','2021-11-21 22:30:44',10,0),('1','142',240640,'DAILY SALES','2020-12-24','2020-12-24 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-21 22:40:11','521','2021-11-21 22:40:46',10,0),('1','142',240641,'DAILY SALES','2021-01-03','2021-01-03 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-21 22:47:24','521','2021-11-21 22:47:52',10,0),('1','142',240642,'DAILY SALES','2021-01-20','2021-01-20 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-21 22:57:10','521','2021-11-21 22:58:06',10,0),('1','142',240643,'DAILY SALES','2021-01-27','2021-01-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-21 23:05:05','521','2021-11-21 23:05:38',10,0),('1','142',240644,'DAILY SALES','2021-02-11','2021-02-11 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-21 23:11:09','521','2021-11-21 23:11:33',10,0),('1','142',240645,'DAILY SALES','2021-02-27','2021-02-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-21 23:17:15','521','2021-11-21 23:17:42',10,0),('1','142',240646,'DAILY SALES','2021-03-05','2021-03-05 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-21 23:23:13','521','2021-11-21 23:23:44',10,0),('1','142',240647,'DAILY SALES','2021-03-16','2021-03-16 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-21 23:28:53','521','2021-11-21 23:29:16',10,0),('1','142',240648,'DAILY SALES','2021-03-27','2021-03-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-21 23:45:49','521','2021-11-21 23:46:10',10,0),('1','142',240649,'DAILY SALES','2021-03-27','2021-03-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-22 00:00:37','521','2021-11-22 00:01:00',10,0),('1','142',240650,'DAILY SALES79594','2021-11-22','2021-11-22 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-22 00:40:17','521','2021-11-22 00:40:39',10,0),('1','142',240652,'DAILY SALES','2021-04-13','2021-04-13 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-22 00:46:27','521','2021-11-22 00:46:46',10,0),('1','142',240653,'DAILY SALES','2021-04-21','2021-04-21 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-22 00:50:36','521','2021-11-22 00:51:35',10,0),('1','142',240654,'DAILY SALES','2021-04-30','2021-04-30 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-22 00:59:14','521','2021-11-22 00:59:40',10,0),('1','142',240655,'DAILY SALES','2021-04-15','2021-04-15 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-22 01:05:44','521','2021-11-22 01:06:14',10,0),('1','142',240656,'DAILY SALES','2021-05-23','2021-05-23 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-22 01:12:19','521','2021-11-22 01:12:46',10,0),('1','142',240657,'DAILY SALES','2021-05-31','2021-05-31 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-22 01:20:35','521','2021-11-22 01:20:56',10,0),('1','142',240658,'DAILY SALES','2021-06-07','2021-06-07 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-22 01:28:01','521','2021-11-22 01:28:23',10,0),('1','142',240659,'DAILY SALES','2021-11-01','2021-11-01 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-22 01:38:04','521','2021-11-22 01:38:29',10,0),('1','142',240660,'DAILY SALES','2021-07-20','2021-07-20 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-22 01:43:37','521','2021-11-22 01:44:03',10,0),('1','142',240661,'DAILY SALES','2021-07-27','2021-07-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-22 01:48:47','521','2021-11-22 01:49:05',10,0),('1','142',240662,'DAILY SALES','2021-11-22','2021-11-22 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-22 01:54:21','521','2021-11-22 01:54:45',10,0),('1','142',240692,'DAILY SALES','2021-10-12','2021-10-12 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-22 06:18:16','521','2021-11-22 06:18:35',10,0),('1','142',240698,'DAILY SALES7','2021-10-20','2021-10-20 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-22 06:23:53','521','2021-11-22 06:24:55',10,0),('1','142',240702,'DAILY SALES','2021-11-07','2021-11-07 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-22 06:29:50','521','2021-11-22 06:30:12',10,0),('1','142',240719,'DAILY SALES','2021-11-22','2021-11-22 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-22 17:29:47','521','2021-11-22 17:35:37',10,0),('1','142',240977,'DAILY SALES','2021-11-23','2021-11-23 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-23 17:26:35','521','2021-11-23 17:27:33',10,0),('1','142',241248,'DAILY SALES','2021-11-24','2021-11-24 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-24 18:07:08','521','2021-11-24 18:07:56',10,0),('1','142',241511,'DAILY SALES','2021-11-25','2021-11-25 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-25 17:51:47','521','2021-11-25 17:52:44',10,0),('1','142',241754,'DAILY SALES','2021-11-26','2021-11-26 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-26 17:32:08','521','2021-11-26 17:33:31',10,0),('1','142',241991,'DAILY SALES','2021-11-27','2021-11-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-27 17:33:18','521','2021-11-27 17:35:04',10,0),('1','142',242230,'DAILY SALES','2021-11-28','2021-11-28 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-28 18:54:45','521','2021-11-28 18:57:55',10,0),('1','142',242469,'DAILY SALES','2021-11-29','2021-11-29 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-29 18:24:42','521','2021-11-29 18:26:21',10,0),('1','142',242714,'DAILY SALES','2021-11-30','2021-11-30 00:00:00',NULL,'521',0.00,0.00,'521','2021-11-30 18:05:40','521','2021-12-01 06:38:56',10,0),('1','142',242936,'DAILY SALES','2021-12-01','2021-12-01 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-01 12:40:04','521','2021-12-01 12:40:42',10,0),('1','142',243022,'DAILY SALES','2021-12-01','2021-12-01 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-01 18:39:13','521','2021-12-01 18:43:00',10,0),('1','142',243152,'DAILY SALES','2021-12-02','2021-12-02 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-02 17:41:49','521','2021-12-02 17:44:12',10,0),('1','142',243442,'DAILY SALES','2021-12-03','2021-12-03 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-03 17:37:29','521','2021-12-03 17:40:49',10,0),('1','142',243641,'DAILY SALES','2021-12-04','2021-12-04 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-04 18:26:58','521','2021-12-04 18:27:40',10,0),('1','142',243879,'DAILY SALES','2021-12-05','2021-12-05 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-05 17:50:07','521','2021-12-05 17:52:14',10,0),('1','142',244072,'DAILY SALES','2021-12-06','2021-12-06 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-06 17:55:44','521','2021-12-06 17:57:06',10,0),('1','142',244307,'DAILY SALES','2021-12-07','2021-12-07 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-07 18:18:59','521','2021-12-07 18:24:49',10,0),('1','142',244529,'DAILY SALES','2021-12-08','2021-12-08 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-08 19:31:36','521','2021-12-08 19:39:05',10,0),('1','142',244812,'DAILY SALES','2021-12-09','2021-12-09 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-09 19:06:36','521','2021-12-09 19:07:50',10,0),('1','142',244993,'DAILY SALES','2021-12-10','2021-12-10 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-10 18:44:40','521','2021-12-10 18:47:13',10,0),('1','142',245255,'DAILY SALES','2021-12-11','2021-12-11 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-11 12:02:08','521','2021-12-11 12:02:57',10,0),('1','142',245334,'DAILY SALES','2021-12-11','2021-12-11 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-11 19:33:04','521','2021-12-11 19:33:51',10,0),('1','142',245453,'DAILY SALES','2021-12-12','2021-12-12 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-12 18:52:28','521','2021-12-12 18:53:33',10,0),('1','142',245704,'DAILY SALES','2021-12-13','2021-12-13 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-13 18:22:20','521','2021-12-13 18:23:07',10,0),('1','142',245990,'DAILY SALES','2021-12-14','2021-12-14 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-14 18:42:16','521','2021-12-14 18:43:14',10,0),('1','142',246208,'DAILY SALES','2021-12-15','2021-12-15 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-15 18:05:52','521','2021-12-15 18:06:45',10,0),('1','142',246456,'DAILY SALES','2021-12-16','2021-12-16 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-16 17:57:57','521','2021-12-16 18:14:52',10,0),('1','142',246708,'DAILY SALES','2021-12-17','2021-12-17 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-17 18:40:22','521','2021-12-17 18:41:09',10,0),('1','142',246954,'DAILY SALES','2021-12-18','2021-12-18 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-18 19:47:46','521','2021-12-18 19:48:12',10,0),('1','142',247185,'DAILY SALES','2021-12-19','2021-12-19 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-19 18:33:44','521','2021-12-19 18:34:27',10,0),('1','142',247415,'DAILY SALES','2021-12-20','2021-12-20 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-20 17:52:05','521','2021-12-20 17:53:05',10,0),('1','142',247675,'DAILY SALES','2021-12-21','2021-12-21 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-21 18:59:32','521','2021-12-21 19:00:46',10,0),('1','142',247934,'DAILY SALES','2021-12-22','2021-12-22 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-22 19:57:27','521','2021-12-22 19:58:23',10,0),('1','142',248190,'DAILY SALES','2021-12-23','2021-12-23 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-23 19:54:11','521','2021-12-23 19:55:16',10,0),('1','142',248421,'DAILY SALES','2021-12-24','2021-12-24 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-24 19:47:08','521','2021-12-24 19:47:51',10,0),('1','142',248658,'DAILY SALES','2021-12-25','2021-12-25 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-25 19:04:10','521','2021-12-25 19:06:11',10,0),('1','142',248889,'DAILY SALES','2021-12-26','2021-12-26 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-26 18:03:28','521','2021-12-26 18:04:22',10,0),('1','142',249136,'DAILY SALES','2021-12-27','2021-12-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-27 16:47:39','521','2021-12-27 16:48:06',10,0),('1','142',249271,'DAILY SALES','2021-12-27','2021-12-27 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-27 18:21:05','521','2021-12-27 18:21:52',10,0),('1','142',249352,'DAILY SALES','2021-12-28','2021-12-28 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-28 17:53:29','521','2021-12-28 17:54:00',10,0),('1','142',249615,'DAILY SALES','2021-12-29','2021-12-29 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-29 17:59:00','521','2021-12-29 17:59:38',10,0),('1','142',249883,'DAILY SALES','2021-12-30','2021-12-30 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-30 18:20:58','521','2021-12-30 18:21:48',10,0),('1','142',250110,'DAILY SALES','2021-12-31','2021-12-31 00:00:00',NULL,'521',0.00,0.00,'521','2021-12-31 17:39:26','521','2021-12-31 17:40:29',10,0),('1','142',250343,'DAILY SALES','2022-01-01','2022-01-01 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-01 19:15:26','521','2022-01-01 19:16:01',10,0),('1','142',250570,'DAILY SALES','2022-01-02','2022-01-02 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-02 17:45:47','521','2022-01-02 17:46:26',10,0),('1','142',250808,'DAILY SALES','2022-01-03','2022-01-03 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-04 06:25:12','521','2022-01-04 06:25:40',10,0),('1','142',251030,'DAILY SALES','2022-01-04','2022-01-04 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-04 17:44:30','521','2022-01-04 17:47:34',10,0),('1','142',251279,'DAILY SALES','2022-01-05','2022-01-05 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-05 10:19:06','521','2022-01-05 10:19:48',10,0),('1','142',251373,'DAILY SALES','2022-01-05','2022-01-05 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-05 19:22:50','521','2022-01-05 19:23:30',10,0),('1','142',251557,'DAILY SALES','2022-01-06','2022-01-06 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-06 20:19:37','521','2022-01-06 20:21:18',10,0),('1','142',251777,'DAILY SALES','2022-01-07','2022-01-07 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-07 19:50:41','521','2022-01-07 19:52:03',10,0),('1','142',252015,'DAILY SALES','2022-01-08','2022-01-08 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-08 20:43:06','521','2022-01-08 20:43:46',10,0),('1','142',252273,'DAILY SALES','2022-01-09','2022-01-09 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-09 19:13:40','521','2022-01-09 19:25:32',10,0),('1','142',252511,'DAILY SALES','2022-01-10','2022-01-10 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-10 19:44:01','521','2022-01-10 19:45:02',10,0),('1','142',252748,'DAILY SALES','2022-01-11','2022-01-11 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-12 08:04:49','521','2022-01-12 08:05:25',10,0),('1','142',252997,'DAILY SALES','2022-01-12','2022-01-12 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-12 19:10:57','521','2022-01-12 19:12:55',10,0),('1','142',253223,'DAILY SALES','2022-01-13','2022-01-13 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-13 19:27:42','521','2022-01-13 19:28:25',10,0),('1','142',253501,'DAILY SALES','2022-01-14','2022-01-14 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-14 14:18:31','521','2022-01-14 14:20:10',10,0),('1','142',253919,'DAILY SALES','2022-01-15','2022-01-15 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-15 21:57:01','521','2022-01-15 21:57:28',10,0),('1','142',254322,'DAILY SALES','2022-01-17','2022-01-17 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-17 19:27:44','521','2022-01-17 19:29:29',10,0),('1','142',254460,'DAILY SALES','2022-01-18','2022-01-18 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-18 18:33:59','521','2022-01-18 18:34:54',10,0),('1','142',254741,'DAILY SALES','2022-01-19','2022-01-19 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-19 19:19:45','521','2022-01-19 19:20:59',10,0),('1','142',254983,'DAILY SALES','2022-01-20','2022-01-20 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-20 19:08:52','521','2022-01-20 19:12:48',10,0),('1','142',255205,'DAILY SALES','2022-01-21','2022-01-21 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-21 19:12:06','521','2022-01-21 19:13:42',10,0),('1','142',255474,'DAILY SALES','2022-01-22','2022-01-22 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-22 19:08:15','521','2022-01-22 19:10:00',10,0),('1','142',255742,'DAILY SALES','2022-01-23','2022-01-23 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-23 19:28:12','521','2022-01-23 19:31:12',10,0),('1','142',255979,'DAILY SALES','2022-01-24','2022-01-24 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-24 19:48:54','521','2022-01-24 19:49:33',10,0),('1','142',256233,'DAILY SALES','2022-01-25','2022-01-25 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-25 18:57:06','521','2022-01-25 18:59:00',10,0),('1','142',256570,'DAILY SALES','2022-01-26','2022-01-26 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-26 11:19:16','521','2022-01-26 11:21:08',10,0),('1','142',256580,'DAILY SALES','2022-01-26','2022-01-26 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-26 19:35:45','521','2022-01-26 19:59:45',10,0),('1','142',256742,'DAILY SALES','2022-01-27','2022-01-27 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-27 22:42:12','521','2022-01-27 22:43:25',10,0),('1','142',256970,'DAILY SALES','2022-01-28','2022-01-28 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-28 19:14:27','521','2022-01-28 19:18:31',10,0),('1','142',257259,'DAILY SALES','2022-01-29','2022-01-29 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-29 20:02:51','521','2022-01-30 07:54:52',10,0),('1','142',257510,'DAILY SALES','2022-01-30','2022-01-30 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-30 19:11:30','521','2022-01-30 19:12:14',10,0),('1','142',257511,'DAILY SALES','2022-01-31','2022-01-31 00:00:00',NULL,'521',0.00,0.00,'521','2022-01-31 19:14:16','521','2022-01-31 19:14:48',10,0),('1','142',257512,'DAILY SALES','2022-02-01','2022-02-01 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-01 19:53:14','521','2022-02-01 19:53:59',10,0),('1','142',257513,'DAILY SALES','2022-02-02','2022-02-02 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-02 19:35:07','521','2022-02-02 19:35:44',10,0),('1','142',257514,'DAILY SALES','2022-02-03','2022-02-03 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-03 19:51:28','521','2022-02-03 19:52:31',10,0),('1','142',257515,'DAILY SALES','2022-02-04','2022-02-04 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-04 18:30:40','521','2022-02-04 18:30:57',10,0),('1','142',257516,'DAILY SALES','2022-02-05','2022-02-05 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-05 13:34:03','521','2022-02-05 13:38:48',10,0),('1','142',257517,'DAILY SALES','2022-02-05','2022-02-05 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-05 19:02:33','521','2022-02-05 19:03:28',10,0),('1','142',257518,'DAILY SALES','2022-02-06','2022-02-06 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-06 20:09:52','521','2022-02-06 20:10:30',10,0),('1','142',257519,'DAILY SALES','2022-02-07','2022-02-07 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-07 19:27:50','521','2022-02-07 19:28:37',10,0),('1','142',257520,'DAILY SALES','2022-02-08','2022-02-08 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-08 20:34:47','521','2022-02-08 20:35:10',10,0),('1','142',257521,'DAILY SALES','2022-02-09','2022-02-09 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-10 07:28:31','521','2022-02-10 07:29:05',10,0),('1','142',257522,'DAILY SALES','2022-02-10','2022-02-10 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-10 20:56:17','521','2022-02-10 20:56:47',10,0),('1','142',257523,'DAILY SALES','2022-02-11','2022-02-11 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-12 07:26:41','521','2022-02-12 07:27:12',10,0),('1','142',257524,'DAILY SALES','2022-02-12','2022-02-12 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-12 20:24:56','521','2022-02-12 20:25:18',10,0),('1','142',257525,'DAILY SALES','2022-02-13','2022-02-13 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-13 20:43:07','521','2022-02-13 20:43:50',10,0),('1','142',257526,'DAILY SALES','2022-02-14','2022-02-14 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-14 20:16:48','521','2022-02-14 20:17:59',10,0),('1','142',257527,'DAILY SALES','2022-02-15','2022-02-15 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-16 07:25:22','521','2022-02-16 07:25:49',10,0),('1','142',257528,'DAILY SALES','2022-02-16','2022-02-16 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-17 07:44:25','521','2022-02-17 07:44:46',10,0),('1','142',257529,'DAILY SALES','2022-02-17','2022-02-17 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-18 08:05:22','521','2022-02-18 08:05:41',10,0),('1','142',257530,'DAILY SALES','2022-02-18','2022-02-18 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-19 00:57:21','521','2022-02-19 00:57:50',10,0),('1','142',257531,'DAILY SALES','2022-02-19','2022-02-19 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-19 19:58:04','521','2022-02-19 19:58:22',10,0),('1','142',257532,'DAILY SALES','2022-02-20','2022-02-20 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-20 19:50:05','521','2022-02-20 19:50:25',10,0),('1','142',257533,'DAILY SALES','2022-02-21','2022-02-21 00:00:00',NULL,'521',0.00,0.00,'521','2022-02-22 08:01:46','521','2022-02-22 08:02:09',10,0),('1','142',257534,'DAILY SALES','2022-02-22','2022-02-22 08:22:01','2022-02-23 08:22:01','521',0.00,0.00,'521','2022-02-22 21:08:36','521','2022-02-22 21:09:09',10,0),('1','142',257535,'DAILY SALES','2022-02-23','2022-02-23 08:31:04','2022-02-24 08:31:04','521',0.00,0.00,'521','2022-02-23 19:40:07','521','2022-02-23 19:40:45',10,0),('1','142',257536,'DAILY SALES','2022-02-24','2022-02-24 08:14:54','2022-02-25 08:14:54','521',0.00,0.00,'521','2022-02-24 19:52:20','521','2022-02-24 19:52:42',10,0),('1','142',257537,'DAILY SALES','2022-02-25','2022-02-25 07:34:12','2022-02-26 07:34:12','521',0.00,0.00,'521','2022-02-25 20:03:25','521','2022-02-25 20:03:43',10,0),('1','142',257538,'DAILY SALES','2022-02-26','2022-02-26 09:06:10','2022-02-27 09:06:10','521',0.00,0.00,'521','2022-02-26 20:07:59','521','2022-02-26 20:08:15',10,0),('1','142',257539,'DAILY SALES','2022-02-27','2022-02-27 07:29:23','2022-02-28 07:29:23','521',0.00,0.00,'521','2022-02-27 20:12:20','521','2022-02-27 20:12:45',10,0),('1','142',257540,'DAILY SALES','2022-02-27','2022-02-27 22:33:43','2022-02-28 22:33:43','521',0.00,0.00,'521','2022-02-27 22:40:41','521','2022-02-27 22:41:04',10,0),('1','142',257541,'DAILY SALES','2022-02-28','2022-02-28 07:47:03','2022-03-01 07:47:03','521',0.00,0.00,'521','2022-02-28 21:39:42','521','2022-02-28 21:40:12',10,0),('1','142',257542,'DAILY SALES','2022-03-01','2022-03-01 07:35:50','2022-03-02 07:35:50','521',0.00,0.00,'521','2022-03-01 19:27:34','521','2022-03-01 19:27:55',10,0),('1','142',257543,'DAILY SALES','2022-03-02','2022-03-02 08:10:46','2022-03-03 08:10:46','521',0.00,0.00,'521','2022-03-02 19:29:53','521','2022-03-02 19:30:14',10,0),('1','142',257544,'DAILY SALES','2022-03-03','2022-03-03 07:57:12','2022-03-04 07:57:12','521',0.00,0.00,'521','2022-03-03 19:16:16','521','2022-03-03 19:17:15',10,0),('1','142',257545,'DAILY SALES','2022-03-04','2022-03-04 07:56:58','2022-03-05 07:56:58','521',0.00,0.00,'521','2022-03-04 19:59:17','521','2022-03-04 19:59:39',10,0),('1','142',257546,'DAILY SALES','2022-03-05','2022-03-05 08:05:07','2022-03-06 08:05:07','521',0.00,0.00,'521','2022-03-06 10:42:16','521','2022-03-06 10:42:39',10,0),('1','142',257547,'DAILY SALES','2022-03-06','2022-03-06 10:45:08','2022-03-07 10:45:08','521',0.00,0.00,'521','2022-03-06 19:49:02','521','2022-03-06 19:50:15',10,0),('1','142',257548,'DAILY SALES','2022-03-07','2022-03-07 08:07:48','2022-03-08 08:07:48','521',0.00,0.00,'521','2022-03-07 20:11:37','521','2022-03-07 20:12:05',10,0),('1','142',257549,'ABBA DAILY SALES','2022-03-08','2022-03-08 08:29:59','2022-03-09 08:29:59','521',0.00,0.00,'521','2022-03-08 19:32:14','521','2022-03-09 08:41:45',10,0),('1','142',257550,'ABBA DAILY SALES','2022-03-09','2022-03-09 08:42:09','2022-03-10 08:42:09','521',0.00,0.00,'521','2022-03-09 09:26:36','521','2022-03-09 09:26:58',10,0),('1','142',257551,' DAILY SALES','2022-03-09','2022-03-09 09:27:44','2022-03-10 09:27:44','521',0.00,0.00,'521','2022-03-09 14:44:15','521','2022-03-09 14:47:12',10,0),('1','142',257552,'ABBA DAILY SALES','2022-03-12','2022-03-12 14:14:18','2022-03-13 14:14:18','521',0.00,0.00,'521','2022-03-12 14:16:17','521','2022-03-12 14:16:35',10,0),('1','142',257553,' DAILY SALES','2022-03-12','2022-03-12 14:16:52','2022-03-13 14:16:52','521',0.00,0.00,'521','2022-03-12 22:50:34','521','2022-03-12 22:51:37',10,0),('1','142',257554,'ABBA DAILY SALES','2022-03-13','2022-03-13 08:06:11','2022-03-14 08:06:11','521',0.00,0.00,'521','2022-03-13 19:53:37','521','2022-03-13 19:54:00',10,0),('1','142',257555,' DAILY SALES','2022-03-14','2022-03-14 09:20:50','2022-03-15 09:20:50','521',0.00,0.00,'521','2022-03-14 19:24:07','521','2022-03-14 19:24:30',10,0),('1','142',257556,' DAILY SALES','2022-03-15','2022-03-15 07:35:08','2022-03-16 07:35:08','521',0.00,0.00,'521','2022-03-15 21:57:36','521','2022-03-15 21:58:04',10,0),('1','142',257557,' DAILY SALES','2022-03-16','2022-03-16 09:08:46','2022-03-17 09:08:46','521',0.00,0.00,'521','2022-03-16 21:50:36','521','2022-03-16 21:51:03',10,0),('1','142',257558,' DAILY SALES','2022-03-17','2022-03-17 09:02:50','2022-03-18 09:02:50','521',0.00,0.00,'521','2022-03-17 22:33:11','521','2022-03-17 22:36:02',10,0),('1','142',257559,' DAILY SALES','2022-03-18','2022-03-18 07:30:17','2022-03-19 07:30:17','521',0.00,0.00,'521','2022-03-18 23:10:22','521','2022-03-18 23:10:55',10,0),('1','142',257560,' DAILY SALES','2022-03-19','2022-03-19 07:39:33','2022-03-20 07:39:33','521',0.00,0.00,'521','2022-03-19 19:59:27','521','2022-03-19 19:59:43',10,0),('1','142',257561,' DAILY SALES','2022-03-20','2022-03-20 07:41:58','2022-03-21 07:41:58','521',0.00,0.00,'521','2022-03-20 20:04:50','521','2022-03-20 20:05:14',10,0),('1','142',257562,' DAILY SALES','2022-03-21','2022-03-21 07:44:19','2022-03-22 07:44:19','521',0.00,0.00,'521','2022-03-21 21:22:39','521','2022-03-21 21:23:07',10,0),('1','142',257563,' DAILY SALES','2022-03-22','2022-03-22 07:32:34','2022-03-23 07:32:34','521',0.00,0.00,'521','2022-03-22 20:08:12','521','2022-03-22 20:08:34',10,0),('1','142',257564,' DAILY SALES','2022-03-23','2022-03-23 08:21:40','2022-03-24 08:21:40','521',0.00,0.00,'521','2022-03-23 22:39:23','521','2022-03-23 22:39:49',10,0),('1','142',257565,' DAILY SALES','2022-03-24','2022-03-24 07:39:00','2022-03-25 07:39:00','521',0.00,0.00,'521','2022-03-24 22:40:26','521','2022-03-24 22:41:13',10,0),('1','142',257566,' DAILY SALES','2022-03-25','2022-03-25 07:48:51','2022-03-26 07:48:51','521',0.00,0.00,'521','2022-03-25 21:07:58','521','2022-03-25 21:08:24',10,0),('1','142',257567,' DAILY SALES','2022-03-26','2022-03-26 08:13:29','2022-03-27 08:13:29','521',0.00,0.00,'521','2022-03-26 20:23:19','521','2022-03-26 20:23:41',10,0),('1','142',257568,' DAILY SALES','2022-03-27','2022-03-27 07:04:22','2022-03-28 07:04:22','521',0.00,0.00,'521','2022-03-27 20:33:55','521','2022-03-27 20:34:29',10,0),('1','142',257569,' DAILY SALES','2022-03-28','2022-03-28 08:55:43','2022-03-29 08:55:43','521',0.00,0.00,'521','2022-03-28 20:39:30','521','2022-03-28 20:48:47',10,0),('1','142',257570,' DAILY SALES','2022-03-29','2022-03-29 10:00:31','2022-03-30 10:00:31','521',0.00,0.00,'521','2022-03-29 23:33:38','521','2022-03-29 23:40:31',10,0),('1','142',257571,' DAILY SALES','2022-03-30','2022-03-30 08:16:36','2022-03-31 08:16:36','521',0.00,0.00,'521','2022-03-30 20:23:12','521','2022-03-30 20:23:43',10,0),('1','142',257572,' DAILY SALES','2022-03-31','2022-03-31 09:42:02','2022-04-01 09:42:02','521',0.00,0.00,'521','2022-03-31 19:49:38','521','2022-03-31 19:50:01',10,0),('1','142',257573,' DAILY SALES','2022-04-01','2022-04-01 10:48:07','2022-04-02 10:48:07','521',0.00,0.00,'521','2022-04-01 21:47:00','521','2022-04-01 21:47:21',10,0),('1','142',257574,' DAILY SALES','2022-04-02','2022-04-02 08:17:45','2022-04-03 08:17:45','521',0.00,0.00,'521','2022-04-02 22:40:50','521','2022-04-02 22:43:11',10,0),('1','142',257575,' DAILY SALES','2022-04-03','2022-04-03 08:06:33','2022-04-04 08:06:33','521',0.00,0.00,'521','2022-04-03 19:54:34','521','2022-04-03 19:54:52',10,0),('1','142',257576,' DAILY SALES','2022-04-04','2022-04-04 07:44:07','2022-04-05 07:44:07','521',0.00,0.00,'521','2022-04-04 19:04:10','521','2022-04-04 19:04:56',10,0),('1','142',257577,' DAILY SALES','2022-04-05','2022-04-05 07:25:32','2022-04-06 07:25:32','521',0.00,0.00,'521','2022-04-05 19:06:19','521','2022-04-05 19:06:40',10,0),('1','142',257578,' DAILY SALES','2022-04-06','2022-04-06 07:50:42','2022-04-07 07:50:42','521',0.00,0.00,'521','2022-04-06 19:19:04','521','2022-04-06 19:19:27',10,0),('1','142',257579,' DAILY SALES','2022-04-07','2022-04-07 08:18:35','2022-04-08 08:18:35','521',0.00,0.00,'521','2022-04-07 21:13:33','521','2022-04-07 21:14:09',10,0),('1','142',257580,' DAILY SALES','2022-04-08','2022-04-08 07:59:06','2022-04-09 07:59:06','521',0.00,0.00,'521','2022-04-08 20:16:37','521','2022-04-08 20:16:56',10,0),('1','142',257581,' DAILY SALES','2022-04-09','2022-04-09 06:55:08','2022-04-10 06:55:08','521',0.00,0.00,'521','2022-04-09 20:33:14','521','2022-04-09 20:33:33',10,0),('1','142',257582,' DAILY SALES','2022-04-10','2022-04-10 07:40:02','2022-04-11 07:40:02','521',0.00,0.00,'521','2022-04-10 20:27:06','521','2022-04-10 20:27:34',10,0),('1','142',257583,' DAILY SALES','2022-04-11','2022-04-11 08:39:05','2022-04-12 08:39:05','521',0.00,0.00,'521','2022-04-11 20:20:33','521','2022-04-11 20:21:05',10,0),('1','142',257584,' DAILY SALES','2022-04-12','2022-04-12 08:22:33','2022-04-13 08:22:33','521',0.00,0.00,'521','2022-04-12 18:07:41','521','2022-04-12 18:07:59',10,0),('1','142',257585,' DAILY SALES','2022-04-13','2022-04-13 07:53:23','2022-04-14 07:53:23','521',0.00,0.00,'521','2022-04-13 19:38:04','521','2022-04-13 19:38:28',10,0),('1','142',257586,' DAILY SALES','2022-04-14','2022-04-14 10:24:55','2022-04-15 10:24:55','521',0.00,0.00,'521','2022-04-14 19:07:05','521','2022-04-14 19:07:28',10,0),('1','142',257587,' DAILY SALES','2022-04-15','2022-04-15 10:04:19','2022-04-16 10:04:19','521',0.00,0.00,'521','2022-04-15 20:14:14','521','2022-04-15 20:14:39',10,0),('1','142',257588,' DAILY SALES','2022-04-16','2022-04-16 08:57:00','2022-04-17 08:57:00','521',0.00,0.00,'521','2022-04-16 20:38:22','521','2022-04-16 20:39:25',10,0),('1','142',257589,' DAILY SALES','2022-04-17','2022-04-17 08:03:08','2022-04-18 08:03:08','521',0.00,0.00,'521','2022-04-17 20:23:41','521','2022-04-17 20:24:16',10,0),('1','142',257590,' DAILY SALES','2022-04-18','2022-04-18 07:42:02','2022-04-19 07:42:02','521',0.00,0.00,'521','2022-04-18 21:37:22','521','2022-04-18 21:37:52',10,0),('1','142',257591,' DAILY SALES','2022-04-19','2022-04-19 08:25:26','2022-04-20 08:25:26','521',0.00,0.00,'521','2022-04-19 19:55:29','521','2022-04-19 19:56:18',10,0),('1','142',257592,' DAILY SALES','2022-04-20','2022-04-20 07:50:45','2022-04-21 07:50:45','521',0.00,0.00,'521','2022-04-20 19:44:17','521','2022-04-20 19:44:48',10,0),('1','142',257593,' DAILY SALES','2022-04-21','2022-04-21 08:40:16','2022-04-22 08:40:16','521',0.00,0.00,'521','2022-04-21 19:54:28','521','2022-04-21 19:55:12',10,0),('1','142',257594,'ABBA DAILY SALES','2022-04-22','2022-04-22 08:34:53','2022-04-23 08:34:53','521',0.00,0.00,'521','2022-04-22 23:01:28','521','2022-04-22 23:01:58',10,0),('1','142',257595,' DAILY SALES','2022-04-23','2022-04-23 07:20:25','2022-04-24 07:20:25','521',0.00,0.00,'521','2022-04-23 22:07:37','521','2022-04-23 22:08:17',10,0),('1','142',257596,' DAILY SALES','2022-04-24','2022-04-24 08:22:32','2022-04-25 08:22:32','521',0.00,0.00,'521','2022-04-24 21:31:01','521','2022-04-24 21:31:42',10,0),('1','142',257597,' DAILY SALES','2022-04-25','2022-04-25 09:50:26','2022-04-26 09:50:26','521',0.00,0.00,'521','2022-04-25 23:42:40','521','2022-04-25 23:43:18',10,0),('1','142',257598,' DAILY SALES','2022-04-26','2022-04-26 08:05:10','2022-04-27 08:05:10','521',0.00,0.00,'521','2022-04-26 19:48:17','521','2022-04-26 19:48:42',10,0),('1','142',257599,' DAILY SALES','2022-04-27','2022-04-27 07:12:54','2022-04-28 07:12:54','521',0.00,0.00,'521','2022-04-27 19:55:38','521','2022-04-28 08:15:35',10,0),('1','142',257600,' DAILY SALES','2022-04-28','2022-04-28 08:15:55','2022-04-29 08:15:55','521',0.00,0.00,'521','2022-04-28 20:04:52','521','2022-04-28 20:05:11',10,0),('1','142',257601,' DAILY SALES','2022-04-29','2022-04-29 08:26:07','2022-04-30 08:26:07','521',0.00,0.00,'521','2022-04-29 11:23:44','521','2022-04-29 11:24:05',10,0),('1','142',257602,' DAILY SALES','2022-04-29','2022-04-29 13:11:04','2022-04-30 13:11:04','521',0.00,0.00,'521','2022-04-29 20:15:37','521','2022-04-29 20:15:55',10,0),('1','142',257603,' DAILY SALES','2022-04-30','2022-04-30 07:43:21','2022-05-01 07:43:21','521',0.00,0.00,'521','2022-04-30 23:29:26','521','2022-04-30 23:30:18',10,0),('1','142',257604,' DAILY SALES','2022-05-01','2022-05-01 08:47:11','2022-05-02 08:47:11','521',0.00,0.00,'521','2022-05-01 20:47:44','521','2022-05-01 20:48:38',10,0),('1','142',257605,' DAILY SALES','2022-05-02','2022-05-02 10:04:37','2022-05-03 10:04:37','521',0.00,0.00,'521','2022-05-02 19:13:42','521','2022-05-02 19:14:14',10,0),('1','142',257606,' DAILY SALES','2022-05-03','2022-05-03 10:04:52','2022-05-04 10:04:52','521',0.00,0.00,'521','2022-05-03 19:32:43','521','2022-05-03 19:33:01',10,0),('1','142',257607,' DAILY SALES','2022-05-04','2022-05-04 08:22:02','2022-05-05 08:22:02','521',0.00,0.00,'521','2022-05-04 19:40:24','521','2022-05-04 19:40:50',10,0),('1','142',257608,' DAILY SALES','2022-05-05','2022-05-05 07:58:04','2022-05-06 07:58:04','521',0.00,0.00,'521','2022-05-05 20:07:07','521','2022-05-05 20:07:28',10,0),('1','142',257609,' DAILY SALES','2022-05-06','2022-05-06 07:43:20','2022-05-07 07:43:20','521',0.00,0.00,'521','2022-05-06 18:56:40','521','2022-05-06 18:57:05',10,0),('1','142',257610,' DAILY SALES','2022-05-07','2022-05-07 08:17:42','2022-05-08 08:17:42','521',0.00,0.00,'521','2022-05-07 23:16:19','521','2022-05-07 23:20:21',10,0),('1','142',257611,' DAILY SALES','2022-05-08','2022-05-08 07:49:28','2022-05-09 07:49:28','521',0.00,0.00,'521','2022-05-08 11:33:45','521','2022-05-08 11:34:01',10,0),('1','142',257612,' DAILY SALES','2022-05-08','2022-05-08 23:34:35','2022-05-09 23:34:35','521',0.00,0.00,'521','2022-05-08 23:48:27','521','2022-05-08 23:49:00',10,0),('1','142',257613,' DAILY SALES','2022-05-09','2022-05-09 06:58:20','2022-05-10 06:58:20','521',0.00,0.00,'521','2022-05-09 19:22:48','521','2022-05-09 19:23:05',10,0),('1','142',257614,' DAILY SALES','2022-05-10','2022-05-10 08:08:50','2022-05-11 08:08:50','521',0.00,0.00,'521','2022-05-10 21:43:14','521','2022-05-10 21:43:42',10,0),('1','142',257615,' DAILY SALES','2022-05-11','2022-05-11 06:41:52','2022-05-12 06:41:52','521',0.00,0.00,'521','2022-05-12 06:27:34','521','2022-05-12 06:28:04',10,0),('1','142',257616,' DAILY SALES','2022-05-12','2022-05-12 06:55:52','2022-05-13 06:55:52','521',0.00,0.00,'521','2022-05-12 22:42:47','521','2022-05-12 22:43:22',10,0),('1','142',257617,' DAILY SALES','2022-05-13','2022-05-13 08:23:45','2022-05-14 08:23:45','521',0.00,0.00,'521','2022-05-13 20:57:07','521','2022-05-13 20:57:31',10,0),('1','142',257618,' DAILY SALES','2022-05-14','2022-05-14 07:31:53','2022-05-15 07:31:53','521',0.00,0.00,'521','2022-05-14 23:53:58','521','2022-05-14 23:54:57',10,0),('1','142',257619,' DAILY SALES','2022-05-15','2022-05-15 07:15:28','2022-05-16 07:15:28','521',0.00,0.00,'521','2022-05-15 20:44:44','521','2022-05-15 20:45:11',10,0),('1','142',257620,' DAILY SALES','2022-05-16','2022-05-16 07:56:27','2022-05-17 07:56:27','521',0.00,0.00,'521','2022-05-16 23:00:26','521','2022-05-16 23:01:05',10,0),('1','142',257621,' DAILY SALES','2022-05-17','2022-05-17 07:54:08','2022-05-18 07:54:08','521',0.00,0.00,'521','2022-05-17 21:05:49','521','2022-05-17 21:06:32',10,0),('1','142',257622,' DAILY SALES','2022-05-18','2022-05-18 07:18:27','2022-05-19 07:18:27','521',0.00,0.00,'521','2022-05-18 20:45:26','521','2022-05-18 20:46:09',10,0),('1','142',257623,' DAILY SALES','2022-05-19','2022-05-19 07:25:08','2022-05-20 07:25:08','521',0.00,0.00,'521','2022-05-19 19:26:13','521','2022-05-19 19:26:41',10,0),('1','142',257624,' DAILY SALES','2022-05-20','2022-05-20 07:58:06','2022-05-21 07:58:06','521',0.00,0.00,'521','2022-05-20 20:42:56','521','2022-05-20 20:43:56',10,0),('1','142',257625,' DAILY SALES','2022-05-21','2022-05-21 07:02:38','2022-05-22 07:02:38','521',0.00,0.00,'521','2022-05-21 21:20:38','521','2022-05-21 21:21:37',10,0),('1','142',257626,' DAILY SALES','2022-05-22','2022-05-22 07:18:54','2022-05-23 07:18:54','521',0.00,0.00,'521','2022-05-22 23:20:59','521','2022-05-22 23:21:55',10,0),('1','142',257627,' DAILY SALES','2022-05-23','2022-05-23 08:44:43','2022-05-24 08:44:43','521',0.00,0.00,'521','2022-05-23 17:08:35','521','2022-05-23 17:10:11',10,0),('1','142',257628,' DAILY SALES','2022-05-24','2022-05-24 12:41:54','2022-05-25 12:41:54','521',0.00,0.00,'521','2022-05-24 14:17:31','521','2022-05-24 14:17:50',10,0),('1','142',257629,' DAILY SALES','2022-05-24','2022-05-24 14:18:28','2022-05-25 14:18:28','521',0.00,0.00,'521','2022-05-24 20:58:32','521','2022-05-24 20:59:02',10,0),('1','142',257630,' DAILY SALES','2022-05-25','2022-05-25 07:22:04','2022-05-26 07:22:04','521',0.00,0.00,'521','2022-05-25 21:50:40','521','2022-05-25 21:51:23',10,0),('1','142',257631,' DAILY SALES','2022-05-26','2022-05-26 07:19:19','2022-05-27 07:19:19','521',0.00,0.00,'521','2022-05-26 20:02:41','521','2022-05-26 20:03:01',10,0),('1','142',257632,' DAILY SALES','2022-05-27','2022-05-27 07:51:47','2022-05-28 07:51:47','521',0.00,0.00,'521','2022-05-27 19:50:20','521','2022-05-27 19:51:02',10,0),('1','142',257633,' DAILY SALES','2022-05-28','2022-05-28 07:50:38','2022-05-29 07:50:38','521',0.00,0.00,'521','2022-05-28 20:33:06','521','2022-05-28 20:33:37',10,0),('1','142',257634,' DAILY SALES','2022-05-29','2022-05-29 10:30:34','2022-05-30 10:30:34','521',0.00,0.00,'521','2022-05-29 20:41:03','521','2022-05-29 20:42:19',10,0),('1','142',257635,' DAILY SALES','2022-05-30','2022-05-30 08:17:27','2022-05-31 08:17:27','521',0.00,0.00,'521','2022-05-31 00:08:32','521','2022-05-31 00:09:22',10,0),('1','142',257636,' DAILY SALES','2022-05-31','2022-05-31 08:45:52','2022-06-01 08:45:52','521',0.00,0.00,'521','2022-05-31 19:47:19','521','2022-05-31 19:47:45',10,0),('1','142',257637,' DAILY SALES','2022-06-01','2022-06-01 07:34:46','2022-06-02 07:34:46','521',0.00,0.00,'521','2022-06-01 17:41:33','521','2022-06-01 17:41:59',10,0),('1','142',257638,' DAILY SALES','2022-06-03','2022-06-03 15:15:28','2022-06-04 15:15:28','521',0.00,0.00,'521','2022-06-03 19:55:17','521','2022-06-03 19:56:30',10,0),('1','142',257639,' DAILY SALES','2022-06-04','2022-06-04 08:19:01','2022-06-05 08:19:01','521',0.00,0.00,'521','2022-06-04 19:35:15','521','2022-06-04 19:35:40',10,0),('1','142',257640,' DAILY SALES','2022-06-05','2022-06-05 07:43:02','2022-06-06 07:43:02','521',0.00,0.00,'521','2022-06-05 19:23:50','521','2022-06-05 19:24:07',10,0),('1','142',257641,' DAILY SALES','2022-06-06','2022-06-06 08:55:19','2022-06-07 08:55:19','521',0.00,0.00,'521','2022-06-06 20:55:17','521','2022-06-06 20:55:40',10,0),('1','142',257642,'ABBA DAILY SALES','2022-06-07','2022-06-07 07:37:02','2022-06-08 07:37:02','521',0.00,0.00,'521','2022-06-07 19:43:52','521','2022-06-07 19:44:13',10,0),('1','142',257643,' DAILY SALES','2022-06-08','2022-06-08 06:17:33','2022-06-09 06:17:33','521',0.00,0.00,'521','2022-06-08 16:44:56','521','2022-06-08 16:45:16',10,0),('1','142',257644,' DAILY SALES','2022-06-09','2022-06-09 11:22:19','2022-06-10 11:22:19','521',0.00,0.00,'521','2022-06-09 20:12:38','521','2022-06-09 20:12:56',10,0),('1','142',257645,' DAILY SALES','2022-06-10','2022-06-10 07:54:51','2022-06-11 07:54:51','521',0.00,0.00,'521','2022-06-10 21:11:25','521','2022-06-10 21:11:44',10,0),('1','142',257646,' DAILY SALES','2022-06-11','2022-06-11 08:34:10','2022-06-12 08:34:10','521',0.00,0.00,'521','2022-06-11 19:15:48','521','2022-06-11 19:16:25',10,0),('1','142',257647,' DAILY SALES','2022-06-12','2022-06-12 07:51:58','2022-06-13 07:51:58','521',0.00,0.00,'521','2022-06-12 21:29:35','521','2022-06-12 21:30:02',10,0),('1','142',257648,'ABBA DAILY SALES','2022-06-13','2022-06-13 07:41:39','2022-06-14 07:41:39','521',0.00,0.00,'521','2022-06-13 20:00:35','521','2022-06-13 20:00:56',10,0),('1','142',257649,'IBRAHIM DEAILY SALES','2022-06-14','2022-06-14 07:49:52','2022-06-15 07:49:52','521',0.00,0.00,'521','2022-06-14 19:37:49','521','2022-06-14 19:38:13',10,0),('1','142',257650,'ABBA DAILY SALES','2022-06-15','2022-06-15 07:55:52','2022-06-16 07:55:52','521',0.00,0.00,'521','2022-06-15 19:57:41','521','2022-06-15 19:58:25',10,0),('1','142',257651,'DAILY SALES','2022-06-16','2022-06-16 07:52:07','2022-06-17 07:52:07','521',0.00,0.00,'521','2022-06-16 20:17:32','521','2022-06-16 20:17:51',10,0),('1','142',257652,'ABBA DAILY SALES','2022-06-17','2022-06-17 08:04:14','2022-06-18 08:04:14','521',0.00,0.00,'521','2022-06-17 20:13:36','521','2022-06-17 20:14:00',10,0),('1','142',257653,'IBRAHIM DEAILY SALES','2022-06-18','2022-06-18 06:46:16','2022-06-19 06:46:16','521',0.00,0.00,'521','2022-06-18 20:12:30','521','2022-06-18 20:12:56',10,0),('1','142',257654,'ABBA DAILY SALES','2022-06-19','2022-06-19 07:02:45','2022-06-20 07:02:45','521',0.00,0.00,'521','2022-06-19 07:26:12','521','2022-06-19 07:27:51',10,0),('1','142',257655,'ABBA DAILY SALES','2022-06-19','2022-06-19 07:28:31','2022-06-20 07:28:31','521',0.00,0.00,'521','2022-06-19 19:40:17','521','2022-06-19 19:40:39',10,0),('1','142',257656,'IBRAHIM DEAILY SALES','2022-06-20','2022-06-20 07:22:15','2022-06-21 07:22:15','521',0.00,0.00,'521','2022-06-21 05:46:23','521','2022-06-21 05:46:49',10,0),('1','142',257657,'ABBA DAILY SALES','2022-06-21','2022-06-21 07:42:09','2022-06-22 07:42:09','521',0.00,0.00,'521','2022-06-21 19:38:42','521','2022-06-21 19:39:07',10,0),('1','142',257658,'IBRAHIM DEAILY SALES','2022-06-22','2022-06-22 06:54:19','2022-06-23 06:54:19','521',0.00,0.00,'521','2022-06-22 20:21:55','521','2022-06-22 20:22:28',10,0),('1','142',257659,'ABBA DAILY SALES','2022-06-23','2022-06-23 07:44:29','2022-06-24 07:44:29','521',0.00,0.00,'521','2022-06-23 19:39:45','521','2022-06-23 19:40:25',10,0),('1','142',257660,'IBRAHIM DEAILY SALES','2022-06-24','2022-06-24 07:45:00','2022-06-25 07:45:00','521',0.00,0.00,'521','2022-06-24 23:54:52','521','2022-06-24 23:55:20',10,0),('1','142',257661,'ABBA DAILY SALES','2022-06-25','2022-06-25 08:31:20','2022-06-26 08:31:20','521',0.00,0.00,'521','2022-06-25 19:22:18','521','2022-06-25 19:22:36',10,0),('1','142',257662,'IBRAHIM DEAILY SALES','2022-06-26','2022-06-26 07:53:25','2022-06-27 07:53:25','521',0.00,0.00,'521','2022-06-26 20:08:27','521','2022-06-26 20:08:57',10,0),('1','142',257663,'ABBA DAILY SALES','2022-06-27','2022-06-27 07:49:58','2022-06-28 07:49:58','521',0.00,0.00,'521','2022-06-27 19:28:54','521','2022-06-27 19:29:11',10,0),('1','142',257664,'IBRAHIM DEAILY SALES','2022-06-28','2022-06-28 07:39:12','2022-06-29 07:39:12','521',0.00,0.00,'521','2022-06-28 19:44:19','521','2022-06-28 19:44:42',10,0),('1','142',257665,'ABBA DAILY SALES','2022-06-29','2022-06-29 08:02:32','2022-06-30 08:02:32','521',0.00,0.00,'521','2022-06-29 20:03:42','521','2022-06-29 20:04:07',10,0),('1','142',257666,'CASHIER 2  DAILY SALES','2022-06-30','2022-06-30 07:05:05','2022-07-01 07:05:05','521',0.00,0.00,'521','2022-06-30 20:24:34','521','2022-06-30 20:24:54',10,0),('1','142',257667,'ABBA DAILY SALES','2022-07-01','2022-07-01 07:47:52','2022-07-02 07:47:52','521',0.00,0.00,'521','2022-07-01 19:21:25','521','2022-07-01 19:21:50',10,0),('1','142',257668,'CASHIER 2  DAILY SALES','2022-07-02','2022-07-02 07:15:31','2022-07-03 07:15:31','521',0.00,0.00,'521','2022-07-02 20:48:04','521','2022-07-02 20:48:53',10,0),('1','142',257669,'C1, DAILY SALES.','2022-07-03','2022-07-03 08:54:23','2022-07-04 08:54:23','521',0.00,0.00,'521','2022-07-04 00:01:28','521','2022-07-04 00:02:22',10,0),('1','142',257670,'CASHIER 2  DAILY SALES','2022-07-04','2022-07-04 08:10:32','2022-07-05 08:10:32','521',0.00,0.00,'521','2022-07-04 19:36:11','521','2022-07-04 19:36:35',10,0),('1','142',257671,'CASHIER 2  DAILY SALES','2022-07-05','2022-07-05 07:54:50','2022-07-06 07:54:50','521',0.00,0.00,'521','2022-07-06 06:16:40','521','2022-07-06 06:17:04',10,0),('1','142',257672,'CASHIER 2  DAILY SALES','2022-07-06','2022-07-06 07:40:07','2022-07-07 07:40:07','521',0.00,0.00,'521','2022-07-06 20:23:04','521','2022-07-06 20:23:35',10,0),('1','142',257673,'CASHIER 2  DAILY SALES','2022-07-07','2022-07-07 08:18:46','2022-07-08 08:18:46','521',0.00,0.00,'521','2022-07-07 20:33:33','521','2022-07-07 20:34:04',10,0),('1','142',257674,'CASHIER 2  DAILY SALES','2022-07-08','2022-07-08 07:39:11','2022-07-09 07:39:11','521',0.00,0.00,'521','2022-07-09 07:14:44','521','2022-07-09 07:15:40',10,0),('1','142',257675,'CASHIER 2  DAILY SALES','2022-07-09','2022-07-09 07:16:07','2022-07-10 07:16:07','521',0.00,0.00,'521','2022-07-09 20:22:20','521','2022-07-09 20:23:06',10,0),('1','142',257676,'CASHIER 2  DAILY SALES','2022-07-10','2022-07-10 08:52:16','2022-07-11 08:52:16','521',0.00,0.00,'521','2022-07-10 19:27:35','521','2022-07-10 19:28:14',10,0),('1','142',257677,'CASHIER 2  DAILY SALES','2022-07-11','2022-07-11 08:13:40','2022-07-12 08:13:40','521',0.00,0.00,'521','2022-07-11 20:47:28','521','2022-07-11 20:48:03',10,0),('1','142',257678,'CASHIER 2  DAILY SALES','2022-07-12','2022-07-12 07:44:08','2022-07-13 07:44:08','521',0.00,0.00,'521','2022-07-12 20:33:44','521','2022-07-12 20:34:07',10,0),('1','142',257679,'CASHIER 2  DAILY SALES','2022-07-13','2022-07-13 07:54:39','2022-07-14 07:54:39','521',0.00,0.00,'521','2022-07-13 20:06:35','521','2022-07-13 20:06:58',10,0),('1','142',257680,'CASHIER 2  DAILY SALES','2022-07-14','2022-07-14 07:30:19','2022-07-15 07:30:19','521',0.00,0.00,'521','2022-07-14 19:49:49','521','2022-07-14 19:50:12',10,0),('1','142',257681,'CASHIER 2  DAILY SALES','2022-07-15','2022-07-15 07:21:16','2022-07-16 07:21:16','521',0.00,0.00,'521','2022-07-15 19:50:00','521','2022-07-15 19:50:48',10,0),('1','142',257682,'CASHIER 2  DAILY SALES','2022-07-16','2022-07-16 09:04:13','2022-07-17 09:04:13','521',0.00,0.00,'521','2022-07-16 20:31:22','521','2022-07-16 20:31:50',10,0),('1','142',257683,'CASHIER 2  DAILY SALES','2022-07-17','2022-07-17 06:23:09','2022-07-18 06:23:09','521',0.00,0.00,'521','2022-07-17 20:14:23','521','2022-07-17 20:14:59',10,0),('1','142',257684,'CASHIER 2  DAILY SALES','2022-07-18','2022-07-18 07:34:00','2022-07-19 07:34:00','521',0.00,0.00,'521','2022-07-18 19:50:41','521','2022-07-18 19:51:11',10,0),('1','142',257685,'CASHIER 2  DAILY SALES','2022-07-19','2022-07-19 07:52:31','2022-07-20 07:52:31','521',0.00,0.00,'521','2022-07-19 19:53:09','521','2022-07-19 19:53:43',10,0),('1','142',257686,'CASHIER 2  DAILY SALES','2022-07-20','2022-07-20 08:23:47','2022-07-21 08:23:47','521',0.00,0.00,'521','2022-07-20 20:16:14','521','2022-07-20 20:16:43',10,0),('1','142',257687,'CASHIER 2  DAILY SALES','2022-07-21','2022-07-21 07:38:02','2022-07-22 07:38:02','521',0.00,0.00,'521','2022-07-21 19:26:13','521','2022-07-21 19:26:41',10,0),('1','142',257688,'CASHIER 2  DAILY SALES','2022-07-22','2022-07-22 07:42:46','2022-07-23 07:42:46','521',0.00,0.00,'521','2022-07-22 20:15:52','521','2022-07-22 20:16:46',10,0),('1','142',257689,'CASHIER 2  DAILY SALES','2022-07-23','2022-07-23 07:36:07','2022-07-24 07:36:07','521',0.00,0.00,'521','2022-07-23 19:50:18','521','2022-07-23 19:50:51',10,0),('1','142',257690,'CASHIER 2  DAILY SALES','2022-07-24','2022-07-24 08:02:53','2022-07-25 08:02:53','521',0.00,0.00,'521','2022-07-24 20:04:02','521','2022-07-24 20:04:27',10,0),('1','142',257691,'C1, DAILY SALES.','2022-07-25','2022-07-25 07:51:36','2022-07-26 07:51:36','521',0.00,0.00,'521','2022-07-25 20:03:38','521','2022-07-25 20:08:15',10,0),('1','142',257692,'CASHIER 2  DAILY SALES','2022-07-26','2022-07-26 08:27:15','2022-07-27 08:27:15','521',0.00,0.00,'521','2022-07-26 22:01:03','521','2022-07-26 22:01:38',10,0),('1','142',257693,'C1, DAILY SALES.','2022-07-27','2022-07-27 07:32:47','2022-07-28 07:32:47','521',0.00,0.00,'521','2022-07-27 19:51:36','521','2022-07-27 19:52:15',10,0),('1','142',257694,'CASHIER 2  DAILY SALES','2022-07-28','2022-07-28 07:40:53','2022-07-29 07:40:53','521',0.00,0.00,'521','2022-07-28 19:27:07','521','2022-07-28 19:27:29',10,0),('1','142',257695,'CASHIER 2  DAILY SALES','2022-07-29','2022-07-29 07:15:05','2022-07-30 07:15:05','521',0.00,0.00,'521','2022-07-29 19:50:03','521','2022-07-29 19:50:53',10,0),('1','142',257696,'C1, DAILY SALES.','2022-07-30','2022-07-30 08:27:15','2022-07-31 08:27:15','521',0.00,0.00,'521','2022-07-30 19:50:03','521','2022-07-30 19:51:09',10,0),('1','142',257697,'C1, DAILY SALES.','2022-07-31','2022-07-31 07:53:16','2022-08-01 07:53:16','521',0.00,0.00,'521','2022-07-31 19:37:23','521','2022-07-31 19:37:50',10,0),('1','142',257698,'CASHIER 2  DAILY SALES','2022-08-01','2022-08-01 08:02:11','2022-08-02 08:02:11','521',0.00,0.00,'521','2022-08-01 20:01:32','521','2022-08-01 20:02:00',10,0),('1','142',257699,'CASHIER 2  DAILY SALES','2022-08-02','2022-08-02 06:54:16','2022-08-03 06:54:16','521',0.00,0.00,'521','2022-08-02 19:46:53','521','2022-08-02 19:47:30',10,0),('1','142',257700,'C1, DAILY SALES.','2022-08-03','2022-08-03 07:47:08','2022-08-04 07:47:08','521',0.00,0.00,'521','2022-08-03 23:09:14','521','2022-08-03 23:10:19',10,0),('1','142',257701,'MANAGER SALES','2022-08-04','2022-08-04 07:57:05','2022-08-05 07:57:05','521',0.00,0.00,'521','2022-08-04 20:30:25','521','2022-08-04 20:31:10',10,0),('1','142',257702,'MANAGER SALES','2022-08-05','2022-08-05 07:49:56','2022-08-06 07:49:56','521',0.00,0.00,'521','2022-08-05 20:03:06','521','2022-08-05 20:04:25',10,0),('1','142',257703,'MANAGER SALES','2022-08-06','2022-08-06 07:38:43','2022-08-07 07:38:43','521',0.00,0.00,'521','2022-08-06 20:53:06','521','2022-08-06 20:53:40',10,0),('1','142',257704,'CASHIER 2  DAILY SALES','2022-08-07','2022-08-07 07:41:28','2022-08-08 07:41:28','521',0.00,0.00,'521','2022-08-07 19:52:15','521','2022-08-07 19:52:39',10,0),('1','142',257705,'C1, DAILY SALES.','2022-08-08','2022-08-08 07:53:07','2022-08-09 07:53:07','521',0.00,0.00,'521','2022-08-08 19:42:24','521','2022-08-08 19:42:52',10,0),('1','142',257706,'MANAGER SALES','2022-08-09','2022-08-09 09:18:56','2022-08-10 09:18:56','521',0.00,0.00,'521','2022-08-09 20:08:35','521','2022-08-09 20:13:26',10,0),('1','142',257707,'CASHIER 1 DAILY SALES','2022-08-10','2022-08-10 08:36:42','2022-08-11 08:36:42','521',0.00,0.00,'521','2022-08-10 19:45:58','521','2022-08-10 19:46:26',10,0),('1','142',257708,'C1, DAILY SALES.','2022-08-11','2022-08-11 08:15:55','2022-08-12 08:15:55','521',0.00,0.00,'521','2022-08-11 19:05:06','521','2022-08-11 19:51:13',10,0),('1','142',257709,'CASHIER 2  DAILY SALES','2022-08-12','2022-08-12 08:01:26','2022-08-13 08:01:26','521',0.00,0.00,'521','2022-08-13 06:44:02','521','2022-08-13 06:44:31',10,0),('1','142',257710,'CASHIER 1 DAILY SALES','2022-08-13','2022-08-13 06:45:22','2022-08-14 06:45:22','521',0.00,0.00,'521','2022-08-13 19:21:41','521','2022-08-13 19:22:08',10,0),('1','142',257711,'CASHIER 2  DAILY SALES','2022-08-14','2022-08-14 07:57:01','2022-08-15 07:57:01','521',0.00,0.00,'521','2022-08-14 21:02:21','521','2022-08-14 21:03:01',10,0),('1','142',257712,'C1, DAILY SALES.','2022-08-15','2022-08-15 07:36:05','2022-08-16 07:36:05','521',0.00,0.00,'521','2022-08-15 21:55:53','521','2022-08-15 21:56:21',10,0),('1','142',257713,'CASHIER 2  DAILY SALES','2022-08-16','2022-08-16 07:47:06','2022-08-17 07:47:06','521',0.00,0.00,'521','2022-08-16 19:32:13','521','2022-08-16 19:32:40',10,0),('1','142',257714,'C1, DAILY SALES.','2022-08-17','2022-08-17 07:37:11','2022-08-18 07:37:11','521',0.00,0.00,'521','2022-08-17 20:41:27','521','2022-08-17 20:41:48',10,0),('1','142',257715,'CASHIER 2  DAILY SALES','2022-08-18','2022-08-18 08:01:11','2022-08-19 08:01:11','521',0.00,0.00,'521','2022-08-18 21:09:50','521','2022-08-18 21:10:24',10,0),('1','142',257716,'C1, DAILY SALES.','2022-08-19','2022-08-19 08:13:46','2022-08-20 08:13:46','521',0.00,0.00,'521','2022-08-19 19:11:46','521','2022-08-20 06:19:02',10,0),('1','142',257717,'CASHIER 2  DAILY SALES','2022-08-20','2022-08-20 07:38:36','2022-08-21 07:38:36','521',0.00,0.00,'521','2022-08-20 20:40:55','521','2022-08-20 20:44:07',10,0),('1','142',257718,'C1, DAILY SALES.','2022-08-21','2022-08-21 07:12:58','2022-08-22 07:12:58','521',0.00,0.00,'521','2022-08-21 19:12:24','521','2022-08-22 04:56:33',10,0),('1','142',257719,'OPERATIONAL LOSS','2022-08-22','2022-08-22 05:10:10','2022-08-23 05:10:10','521',0.00,0.00,'521','2022-08-22 05:17:11','521','2022-08-22 05:17:33',10,0),('1','142',257720,'OPERATIONAL LOSS','2022-08-22','2022-08-22 05:24:04','2022-08-23 05:24:04','521',0.00,0.00,'521','2022-08-22 05:32:57','521','2022-08-22 05:33:29',10,0),('1','142',257721,'OPERATIONAL LOSS','2022-08-22','2022-08-22 05:37:55','2022-08-23 05:37:55','521',0.00,0.00,'521','2022-08-22 05:58:49','521','2022-08-22 05:59:12',10,0),('1','142',257722,'OPERATIONAL LOSS','2022-08-22','2022-08-22 05:59:44','2022-08-23 05:59:44','521',0.00,0.00,'521','2022-08-22 06:06:08','521','2022-08-22 06:06:41',10,0),('1','142',257723,'OPERATIONAL LOSS','2022-08-22','2022-08-22 06:14:35','2022-08-23 06:14:35','521',0.00,0.00,'521','2022-08-22 06:19:57','521','2022-08-22 06:20:24',10,0),('1','142',257724,'OPERATIONAL LOSS','2022-08-22','2022-08-22 06:36:50','2022-08-23 06:36:50','521',0.00,0.00,'521','2022-08-22 06:44:06','521','2022-08-22 06:44:54',10,0),('1','142',257725,'OPERATIONAL LOSS','2022-08-22','2022-08-22 07:41:45','2022-08-23 07:41:45','521',0.00,0.00,'521','2022-08-22 07:46:53','521','2022-08-22 07:47:13',10,0),('1','142',257726,'OPERATIONAL LOSS','2022-08-22','2022-08-22 07:48:02','2022-08-23 07:48:02','521',0.00,0.00,'521','2022-08-22 07:53:48','521','2022-08-22 07:54:09',10,0),('1','142',257727,'OPERATIONAL LOSS','2022-08-22','2022-08-22 07:54:36','2022-08-23 07:54:36','521',0.00,0.00,'521','2022-08-22 07:58:27','521','2022-08-22 07:58:53',10,0),('1','142',257728,'OPERATIONAL LOSS','2022-08-22','2022-08-22 07:59:29','2022-08-23 07:59:29','521',0.00,0.00,'521','2022-08-22 08:09:08','521','2022-08-22 08:09:29',10,0),('1','142',257729,'OPERATIONAL LOSS','2022-08-22','2022-08-22 08:10:48','2022-08-23 08:10:48','521',0.00,0.00,'521','2022-08-22 08:13:26','521','2022-08-22 08:14:22',10,0),('1','142',257730,'OPERATIONAL LOSS','2022-08-22','2022-08-22 08:16:15','2022-08-23 08:16:15','521',0.00,0.00,'521','2022-08-22 08:23:58','521','2022-08-22 08:24:22',10,0),('1','142',257731,'OPERATIONAL LOSS','2022-08-22','2022-08-22 08:24:49','2022-08-23 08:24:49','521',0.00,0.00,'521','2022-08-22 08:28:52','521','2022-08-22 08:29:11',10,0),('1','142',257732,'CASHIER 2  DAILY SALES','2022-08-22','2022-08-22 08:39:36','2022-08-23 08:39:36','521',0.00,0.00,'521','2022-08-22 21:13:54','521','2022-08-22 21:14:21',10,0),('1','142',257733,' DAILY SALES','2022-08-23','2022-08-23 07:50:30','2022-08-24 07:50:30','521',0.00,0.00,'521','2022-08-23 19:39:22','521','2022-08-23 19:40:00',10,0),('1','142',257734,'CASHIER 2  DAILY SALES','2022-08-24','2022-08-24 08:01:06','2022-08-25 08:01:06','521',0.00,0.00,'521','2022-08-24 19:40:23','521','2022-08-24 19:40:52',10,0),('1','142',257735,'C1, DAILY SALES.','2022-08-25','2022-08-25 08:09:38','2022-08-26 08:09:38','521',0.00,0.00,'521','2022-08-25 19:38:39','521','2022-08-25 20:03:58',10,0),('1','142',257736,'CASHIER 2  DAILY SALES','2022-08-26','2022-08-26 07:29:47','2022-08-27 07:29:47','521',0.00,0.00,'521','2022-08-26 19:46:56','521','2022-08-26 19:47:28',10,0),('1','142',257737,'C1, DAILY SALES.','2022-08-27','2022-08-27 07:12:44','2022-08-28 07:12:44','521',0.00,0.00,'521','2022-08-27 19:25:18','521','2022-08-27 19:28:58',10,0),('1','142',257738,'CASHIER 2  DAILY SALES','2022-08-28','2022-08-28 08:01:17','2022-08-29 08:01:17','521',0.00,0.00,'521','2022-08-28 19:07:47','521','2022-08-28 19:08:13',10,0),('1','142',257739,'C1, DAILY SALES.','2022-08-29','2022-08-29 08:09:05','2022-08-30 08:09:05','521',0.00,0.00,'521','2022-08-29 19:53:15','521','2022-08-29 19:53:37',10,0),('1','142',257740,'CASHIER 2  DAILY SALES','2022-08-30','2022-08-30 07:52:31','2022-08-31 07:52:31','521',0.00,0.00,'521','2022-08-30 20:10:49','521','2022-08-30 20:11:11',10,0),('1','142',257741,'C1, DAILY SALES.','2022-08-31','2022-08-31 07:47:53','2022-09-01 07:47:53','521',0.00,0.00,'521','2022-08-31 19:36:44','521','2022-08-31 19:37:06',10,0),('1','142',257742,'CASHIER 2 DAILY SALES','2022-09-01','2022-09-01 08:47:44','2022-09-02 08:47:44','521',0.00,0.00,'521','2022-09-01 20:26:24','521','2022-09-01 20:26:53',10,0),('1','142',257743,'C1, DAILY SALES.','2022-09-02','2022-09-02 07:51:22','2022-09-03 07:51:22','521',0.00,0.00,'521','2022-09-02 19:46:08','521','2022-09-02 19:47:57',10,0),('1','142',257744,'CASHIER 2  DAILY SALES','2022-09-03','2022-09-03 08:04:10','2022-09-04 08:04:10','521',0.00,0.00,'521','2022-09-03 14:41:22','521','2022-09-03 14:42:36',10,0),('1','142',257745,'CASHIER 2  DAILY SALES','2022-09-03','2022-09-03 14:46:30','2022-09-04 14:46:30','521',0.00,0.00,'521','2022-09-04 08:00:20','521','2022-09-04 08:00:43',10,0),('1','142',257746,'C1, DAILY SALES.','2022-09-04','2022-09-04 11:28:21','2022-09-05 11:28:21','521',0.00,0.00,'521','2022-09-04 19:20:25','521','2022-09-04 19:21:44',10,0),('1','142',257747,'OPERATIONAL LOSS','2022-09-03','2022-09-05 01:04:14','2022-09-06 01:04:14','521',0.00,0.00,'521','2022-09-05 01:13:56','521','2022-09-05 01:14:18',10,0),('1','142',257748,'CASHIER 2  DAILY SALES','2022-09-05','2022-09-05 07:27:56','2022-09-06 07:27:56','521',0.00,0.00,'521','2022-09-05 07:51:16','521','2022-09-05 07:58:32',10,0),('1','142',257749,'CASHIER 2  DAILY SALES','2022-09-05','2022-09-05 07:59:05','2022-09-06 07:59:05','521',0.00,0.00,'521','2022-09-05 20:53:08','521','2022-09-05 20:53:40',10,0),('1','142',257750,'C1, DAILY SALES.','2022-09-06','2022-09-06 08:18:35','2022-09-07 08:18:35','521',0.00,0.00,'521','2022-09-06 19:40:09','521','2022-09-06 19:40:30',10,0),('1','142',257751,'CASHIER 2  DAILY SALES','2022-09-07','2022-09-07 07:39:18','2022-09-08 07:39:18','521',0.00,0.00,'521','2022-09-07 20:21:51','521','2022-09-07 20:22:12',10,0),('1','142',257752,'C1, DAILY SALES.','2022-09-08','2022-09-08 08:31:02','2022-09-09 08:31:02','521',0.00,0.00,'521','2022-09-08 18:59:51','521','2022-09-08 19:00:12',10,0),('1','142',257753,'CASHIER 2  DAILY SALES','2022-09-09','2022-09-09 08:15:27','2022-09-10 08:15:27','521',0.00,0.00,'521','2022-09-09 19:52:32','521','2022-09-09 19:54:47',10,0),('1','142',257754,'C1, DAILY SALES.','2022-09-10','2022-09-10 07:09:43','2022-09-11 07:09:43','521',0.00,0.00,'521','2022-09-10 19:30:56','521','2022-09-10 19:31:52',10,0),('1','142',257755,'CASHIER 2  DAILY SALES','2022-09-11','2022-09-11 07:40:18','2022-09-12 07:40:18','521',0.00,0.00,'521','2022-09-11 20:11:20','521','2022-09-11 20:11:52',10,0),('1','142',257756,'C1, DAILY SALES.','2022-09-12','2022-09-12 08:25:17','2022-09-13 08:25:17','521',0.00,0.00,'521','2022-09-12 19:18:57','521','2022-09-12 19:21:40',10,0),('1','142',257757,'CASHIER 2  DAILY SALES','2022-09-13','2022-09-13 07:44:55','2022-09-14 07:44:55','521',0.00,0.00,'521','2022-09-13 19:17:13','521','2022-09-13 19:17:40',10,0),('1','142',257758,'C1, DAILY SALES.','2022-09-14','2022-09-14 07:16:15','2022-09-15 07:16:15','521',0.00,0.00,'521','2022-09-14 19:26:35','521','2022-09-14 19:27:10',10,0),('1','142',257759,'CASHIER 2  DAILY SALES','2022-09-15','2022-09-15 07:32:48','2022-09-16 07:32:48','521',0.00,0.00,'521','2022-09-15 20:02:40','521','2022-09-15 20:03:13',10,0),('1','142',257760,'C1, DAILY SALES.','2022-09-16','2022-09-16 07:31:52','2022-09-17 07:31:52','521',0.00,0.00,'521','2022-09-16 19:43:40','521','2022-09-16 19:44:03',10,0),('1','142',257761,'CASHIER 2  DAILY SALES','2022-09-17','2022-09-17 07:55:12','2022-09-18 07:55:12','521',0.00,0.00,'521','2022-09-17 20:08:26','521','2022-09-17 20:08:57',10,0),('1','142',257762,'C1, DAILY SALES.','2022-09-18','2022-09-18 07:14:51','2022-09-19 07:14:51','521',0.00,0.00,'521','2022-09-18 19:34:56','521','2022-09-18 19:35:25',10,0),('1','142',257763,'CASHIER 2  DAILY SALES','2022-09-19','2022-09-19 07:48:54','2022-09-20 07:48:54','521',0.00,0.00,'521','2022-09-20 04:36:24','521','2022-09-20 04:36:50',10,0),('1','142',257764,'C1, DAILY SALES.','2022-09-20','2022-09-20 07:19:10','2022-09-21 07:19:10','521',0.00,0.00,'521','2022-09-20 20:24:27','521','2022-09-20 20:25:05',10,0),('1','142',257765,'CASHIER 2  DAILY SALES','2022-09-21','2022-09-21 08:11:17','2022-09-22 08:11:17','521',0.00,0.00,'521','2022-09-21 20:16:19','521','2022-09-21 20:16:52',10,0),('1','142',257766,'C1, DAILY SALES.','2022-09-22','2022-09-22 07:16:41','2022-09-23 07:16:41','521',0.00,0.00,'521','2022-09-22 19:55:37','521','2022-09-23 08:00:56',10,0),('1','142',257767,'CASHIER 2  DAILY SALES','2022-09-23','2022-09-23 08:01:37','2022-09-24 08:01:37','521',0.00,0.00,'521','2022-09-23 19:45:00','521','2022-09-23 20:01:43',10,0),('1','142',257768,'C1, DAILY SALES.','2022-09-24','2022-09-24 07:47:27','2022-09-25 07:47:27','521',0.00,0.00,'521','2022-09-24 21:27:45','521','2022-09-24 21:28:25',10,0),('1','142',257769,'CASHIER 2  DAILY SALES','2022-09-25','2022-09-25 08:01:14','2022-09-26 08:01:14','521',0.00,0.00,'521','2022-09-25 20:26:55','521','2022-09-25 20:27:17',10,0),('1','142',257770,'C1, DAILY SALES.','2022-09-26','2022-09-26 07:29:49','2022-09-27 07:29:49','521',0.00,0.00,'521','2022-09-26 19:55:41','521','2022-09-26 19:56:25',10,0),('1','142',257771,'CASHIER 2  DAILY SALES','2022-09-27','2022-09-27 07:43:22','2022-09-28 07:43:22','521',0.00,0.00,'521','2022-09-27 20:42:36','521','2022-09-27 20:43:16',10,0),('1','142',257772,'C1, DAILY SALES.','2022-09-28','2022-09-28 07:43:08','2022-09-29 07:43:08','521',0.00,0.00,'521','2022-09-28 19:36:07','521','2022-09-28 19:36:56',10,0),('1','142',257773,'CASHIER 2  DAILY SALES','2022-09-29','2022-09-29 07:41:49','2022-09-30 07:41:49','521',0.00,0.00,'521','2022-09-29 19:43:42','521','2022-09-29 19:44:05',10,0),('1','142',257774,'C1, DAILY SALES.','2022-09-30','2022-09-30 07:39:04','2022-10-01 07:39:04','521',0.00,0.00,'521','2022-09-30 20:40:16','521','2022-09-30 20:41:08',10,0),('1','142',257775,'CASHIER 2  DAILY SALES','2022-10-01','2022-10-01 07:37:40','2022-10-02 07:37:40','521',0.00,0.00,'521','2022-10-01 21:21:06','521','2022-10-01 21:21:28',10,0),('1','142',257776,'C1, DAILY SALES.','2022-10-02','2022-10-02 06:59:54','2022-10-03 06:59:54','521',0.00,0.00,'521','2022-10-02 20:29:04','521','2022-10-02 20:29:50',10,0),('1','142',257777,'MANAGER  SALES','2022-10-03','2022-10-03 18:18:44','2022-10-04 18:18:44','521',0.00,0.00,'521','2022-10-03 18:31:17','521','2022-10-03 18:31:48',10,0),('1','142',257778,'CASHIER SALES','2022-10-04','2022-10-04 11:00:44','2022-10-05 11:00:44','521',0.00,0.00,'521','2022-10-04 20:41:52','521','2022-10-04 20:53:37',10,0),('1','142',257779,'CASHIER 2  DAILY SALES','2022-10-05','2022-10-05 10:01:01','2022-10-06 10:01:01','521',0.00,0.00,'521','2022-10-06 01:29:27','521','2022-10-06 01:32:00',10,0),('1','142',257780,'C1, DAILY SALES.','2022-10-06','2022-10-06 07:47:06','2022-10-07 07:47:06','521',0.00,0.00,'521','2022-10-06 23:15:21','521','2022-10-07 07:28:27',10,0),('1','142',257781,'CASHIER 2  DAILY SALES','2022-10-07','2022-10-07 07:46:57','2022-10-08 07:46:57','521',0.00,0.00,'521','2022-10-07 19:33:08','521','2022-10-08 08:34:34',10,0),('1','142',257782,'CASHIER 2  DAILY SALES','2022-10-08','2022-10-08 08:35:42','2022-10-09 08:35:42','521',0.00,0.00,'521','2022-10-08 23:27:39','521','2022-10-09 07:44:30',10,0),('1','142',257783,' DAILY SALES','2022-10-09','2022-10-09 07:45:33','2022-10-10 07:45:33','521',0.00,0.00,'521','2022-10-09 20:45:04','521','2022-10-09 20:45:43',10,0),('1','142',257784,'C1, DAILY SALES.','2022-10-10','2022-10-10 07:40:25','2022-10-11 07:40:25','521',0.00,0.00,'521','2022-10-10 20:36:44','521','2022-10-11 02:40:43',10,0),('1','142',257785,'C1, DAILY SALES.','2022-10-11','2022-10-11 08:07:24','2022-10-12 08:07:24','521',0.00,0.00,'521','2022-10-11 10:43:32','521','2022-10-11 10:44:12',10,0),('1','142',257786,'CASHIER 1  DAILY SALES','2022-10-11','2022-10-11 13:30:15','2022-10-12 13:30:15','521',0.00,0.00,'521','2022-10-11 20:18:35','521','2022-10-11 20:19:00',10,0),('1','142',257787,'CASHIER 2  DAILY SALES','2022-10-12','2022-10-12 10:41:02','2022-10-13 10:41:02','521',0.00,0.00,'521','2022-10-12 22:07:18','521','2022-10-12 22:07:53',10,0),('1','142',257788,'CASHIER 2  DAILY SALES','2022-10-13','2022-10-13 09:28:03','2022-10-14 09:28:03','521',0.00,0.00,'521','2022-10-13 21:28:58','521','2022-10-13 21:30:40',10,0),('1','142',257789,'C1, DAILY SALES.','2022-10-14','2022-10-14 08:19:27','2022-10-15 08:19:27','521',0.00,0.00,'521','2022-10-14 19:35:33','521','2022-10-14 19:36:05',10,0),('1','142',257790,'C1, DAILY SALES.','2022-10-15','2022-10-15 08:14:10','2022-10-16 08:14:10','521',0.00,0.00,'521','2022-10-15 19:57:59','521','2022-10-15 20:01:29',10,0),('1','142',257791,'CASHIER 2  DAILY SALES','2022-10-16','2022-10-16 07:40:18','2022-10-17 07:40:18','521',0.00,0.00,'521','2022-10-16 18:41:52','521','2022-10-16 18:42:22',10,0),('1','142',257792,'CASHIER 2  DAILY SALES','2022-10-17','2022-10-17 07:28:23','2022-10-18 07:28:23','521',0.00,0.00,'521','2022-10-17 19:36:36','521','2022-10-17 19:37:43',10,0),('1','142',257793,'C1, DAILY SALES.','2022-10-18','2022-10-18 07:30:49','2022-10-19 07:30:49','521',0.00,0.00,'521','2022-10-18 19:38:49','521','2022-10-18 19:39:12',10,0),('1','142',257794,'C1, DAILY SALES.','2022-10-19','2022-10-19 07:38:16','2022-10-20 07:38:16','521',0.00,0.00,'521','2022-10-19 19:18:35','521','2022-10-19 19:19:15',10,0),('1','142',257795,'C1, DAILY SALES.','2022-10-20','2022-10-20 07:23:58','2022-10-21 07:23:58','521',0.00,0.00,'521','2022-10-20 14:12:52','521','2022-10-20 14:15:33',10,0),('1','142',257796,'C1, DAILY SALES.','2022-10-20','2022-10-20 14:16:41','2022-10-21 14:16:41','521',0.00,0.00,'521','2022-10-20 19:13:00','521','2022-10-20 19:15:19',10,0),('1','142',257797,'Operational loss','2022-10-20','2022-10-21 00:08:21','2022-10-22 00:08:21','521',0.00,0.00,'521','2022-10-21 00:17:38','521','2022-10-21 00:18:04',10,0),('1','142',257798,'Operational loss','2022-10-21','2022-10-21 00:19:37','2022-10-22 00:19:37','521',0.00,0.00,'521','2022-10-21 00:27:50','521','2022-10-21 00:28:36',10,0),('1','142',257799,'Operational loss','2022-10-21','2022-10-21 00:30:22','2022-10-22 00:30:22','521',0.00,0.00,'521','2022-10-21 00:39:24','521','2022-10-21 00:39:45',10,0),('1','142',257800,'Operational loss','2022-10-20','2022-10-21 00:40:33','2022-10-22 00:40:33','521',0.00,0.00,'521','2022-10-21 00:49:09','521','2022-10-21 00:49:55',10,0),('1','142',257801,'Operational loss','2022-10-20','2022-10-21 00:55:05','2022-10-22 00:55:05','521',0.00,0.00,'521','2022-10-21 01:02:44','521','2022-10-21 01:03:09',10,0),('1','142',257802,'CASHIER 2  DAILY SALES','2022-10-21','2022-10-21 07:41:18','2022-10-22 07:41:18','521',0.00,0.00,'521','2022-10-21 19:09:51','521','2022-10-21 19:10:43',10,0),('1','142',257803,'CASHIER 2  DAILY SALES','2022-10-22','2022-10-22 07:56:47','2022-10-23 07:56:47','521',0.00,0.00,'521','2022-10-22 19:44:43','521','2022-10-22 19:45:20',10,0),('1','142',257804,'CASHIER 2  DAILY SALES','2022-10-23','2022-10-23 07:59:50','2022-10-24 07:59:50','521',0.00,0.00,'521','2022-10-23 19:22:38','521','2022-10-23 19:23:36',10,0),('1','142',257805,'C1, DAILY SALES.','2022-10-24','2022-10-24 07:22:18','2022-10-25 07:22:18','521',0.00,0.00,'521','2022-10-24 19:29:18','521','2022-10-24 19:30:24',10,0),('1','142',257806,'C1, DAILY SALES.','2022-10-25','2022-10-25 07:37:51','2022-10-26 07:37:51','521',0.00,0.00,'521','2022-10-25 19:52:36','521','2022-10-25 19:53:47',10,0),('1','142',257807,'CASHIER 2  DAILY SALES','2022-10-26','2022-10-26 07:58:49','2022-10-27 07:58:49','521',0.00,0.00,'521','2022-10-26 20:06:22','521','2022-10-26 20:07:10',10,0),('1','142',257808,'Cashier 2 Daily salles','2022-10-27','2022-10-27 13:56:24','2022-10-28 13:56:24','521',0.00,0.00,'521','2022-10-27 20:10:47','521','2022-10-27 20:12:11',10,0),('1','142',257809,' C1,DAILY SALES.','2022-10-28','2022-10-28 08:08:30','2022-10-29 08:08:30','521',0.00,0.00,'521','2022-10-28 19:54:28','521','2022-10-28 19:55:51',10,0),('1','142',257810,'C1, DAILY SALES.','2022-10-29','2022-10-29 07:52:40','2022-10-30 07:52:40','521',0.00,0.00,'521','2022-10-29 19:31:46','521','2022-10-29 19:32:30',10,0),('1','142',257811,'CASHIER 2  DAILY SALES','2022-10-30','2022-10-30 07:18:17','2022-10-31 07:18:17','521',0.00,0.00,'521','2022-10-30 19:16:00','521','2022-10-30 19:16:36',10,0),('1','142',257812,'CASHIER 2  DAILY SALES','2022-10-31','2022-10-31 07:35:34','2022-11-01 07:35:34','521',0.00,0.00,'521','2022-10-31 19:43:35','521','2022-10-31 19:44:54',10,0),('1','142',257813,'C1, DAILY SALES.','2022-11-01','2022-11-01 08:06:32','2022-11-02 08:06:32','521',0.00,0.00,'521','2022-11-01 19:00:18','521','2022-11-01 19:03:04',10,0),('1','142',257814,'C1, DAILY SALES.','2022-11-02','2022-11-02 07:47:50','2022-11-03 07:47:50','521',0.00,0.00,'521','2022-11-02 19:50:34','521','2022-11-02 19:54:07',10,0),('1','142',257815,'CASHIER 2  DAILY SALES','2022-11-03','2022-11-03 08:34:07','2022-11-04 08:34:07','521',0.00,0.00,'521','2022-11-03 19:00:37','521','2022-11-03 19:01:00',10,0),('1','142',257816,'CASHIER 2  DAILY SALES','2022-11-04','2022-11-04 07:53:31','2022-11-05 07:53:31','521',0.00,0.00,'521','2022-11-04 20:06:58','521','2022-11-04 20:07:28',10,0),('1','142',257817,'C1, DAILY SALES.','2022-11-05','2022-11-05 10:03:14','2022-11-06 10:03:14','521',0.00,0.00,'521','2022-11-06 08:04:20','521','2022-11-06 08:04:50',10,0),('1','142',257818,'C1, DAILY SALES.','2022-11-06','2022-11-06 08:05:36','2022-11-07 08:05:36','521',0.00,0.00,'521','2022-11-06 19:21:08','521','2022-11-06 19:22:16',10,0),('1','142',257819,'C1, DAILY SALES.','2022-11-07','2022-11-07 07:46:29','2022-11-08 07:46:29','521',0.00,0.00,'521','2022-11-07 19:29:16','521','2022-11-07 19:29:42',10,0),('1','142',257820,'C1, DAILY SALES.','2022-11-08','2022-11-08 07:50:39','2022-11-09 07:50:39','521',0.00,0.00,'521','2022-11-08 19:12:39','521','2022-11-08 19:13:17',10,0),('1','142',257821,'C1, DAILY SALES.','2022-11-09','2022-11-09 07:26:58','2022-11-10 07:26:58','521',0.00,0.00,'521','2022-11-09 19:17:22','521','2022-11-09 19:17:51',10,0),('1','142',257822,'C1, DAILY SALES.','2022-11-10','2022-11-10 10:45:20','2022-11-11 10:45:20','521',0.00,0.00,'521','2022-11-10 19:04:29','521','2022-11-10 19:06:12',10,0),('1','142',257823,'C1, DAILY SALES.','2022-11-11','2022-11-11 07:48:38','2022-11-12 07:48:38','521',0.00,0.00,'521','2022-11-11 18:53:58','521','2022-11-11 18:54:26',10,0),('1','142',257824,'C1, DAILY SALES.','2022-11-12','2022-11-12 08:04:25','2022-11-13 08:04:25','521',0.00,0.00,'521','2022-11-12 17:04:30','521','2022-11-12 17:05:00',10,0),('1','142',257825,'C1, DAILY SALES.','2022-11-13','2022-11-13 08:05:40','2022-11-14 08:05:40','521',0.00,0.00,'521','2022-11-13 18:21:48','521','2022-11-13 18:22:08',10,0),('1','142',257826,'C1, DAILY SALES.','2022-11-13','2022-11-13 19:23:49','2022-11-14 19:23:49','521',0.00,0.00,'521','2022-11-13 21:44:32','521','2022-11-13 21:45:14',10,0),('1','142',257827,'C1, DAILY SALES.','2022-11-14','2022-11-14 08:06:02','2022-11-15 08:06:02','521',0.00,0.00,'521','2022-11-14 18:56:04','521','2022-11-14 18:56:31',10,0),('1','142',257828,'C1, DAILY SALES.','2022-11-15','2022-11-15 08:38:31','2022-11-16 08:38:31','521',0.00,0.00,'521','2022-11-15 19:06:41','521','2022-11-15 19:07:02',10,0),('1','142',257829,'C1, DAILY SALES.','2022-11-16','2022-11-16 08:08:46','2022-11-17 08:08:46','521',0.00,0.00,'521','2022-11-16 19:01:08','521','2022-11-16 19:01:50',10,0),('1','142',257830,'C1, DAILY SALES.','2022-11-17','2022-11-17 08:46:48','2022-11-18 08:46:48','521',0.00,0.00,'521','2022-11-17 19:35:59','521','2022-11-17 19:36:51',10,0),('1','142',257831,'C1, DAILY SALES.','2022-11-18','2022-11-18 07:54:01','2022-11-19 07:54:01','521',0.00,0.00,'521','2022-11-18 19:03:18','521','2022-11-18 19:04:42',10,0),('1','142',257832,'C1, DAILY SALES.','2022-11-19','2022-11-19 07:52:30','2022-11-20 07:52:30','521',0.00,0.00,'521','2022-11-19 18:56:39','521','2022-11-19 18:56:59',10,0),('1','142',257833,'C1, DAILY SALES.','2022-11-20','2022-11-20 07:27:27','2022-11-21 07:27:27','521',0.00,0.00,'521','2022-11-20 21:46:28','521','2022-11-20 21:48:30',10,0),('1','142',257834,'C1, DAILY SALES.','2022-11-21','2022-11-21 09:03:47','2022-11-22 09:03:47','521',0.00,0.00,'521','2022-11-21 20:54:42','521','2022-11-21 20:55:08',10,0),('1','142',257835,'C1, DAILY SALES.','2022-11-22','2022-11-22 08:15:31','2022-11-23 08:15:31','521',0.00,0.00,'521','2022-11-22 23:38:26','521','2022-11-22 23:39:00',10,0),('1','142',257836,'C1,DAILY SALES.','2022-11-23','2022-11-23 10:36:32','2022-11-24 10:36:32','521',0.00,0.00,'521','2022-11-23 18:55:45','521','2022-11-23 18:56:13',10,0),('1','142',257837,'C1,DAILY SALES','2022-11-24','2022-11-24 10:48:28','2022-11-25 10:48:28','521',0.00,0.00,'521','2022-11-24 19:11:46','521','2022-11-24 19:12:09',10,0),('1','142',257838,'C1,DAILY SALES.','2022-11-25','2022-11-25 08:15:22','2022-11-26 08:15:22','521',0.00,0.00,'521','2022-11-25 23:24:14','521','2022-11-25 23:24:35',10,0),('1','142',257839,'C1, DAILY SALES.','2022-11-26','2022-11-26 07:51:20','2022-11-27 07:51:20','521',0.00,0.00,'521','2022-11-26 19:10:42','521','2022-11-26 19:11:19',10,0),('1','142',257840,'CASHIER 2 DAIY SALES','2022-11-27','2022-11-27 07:38:30','2022-11-28 07:38:30','521',0.00,0.00,'521','2022-11-27 19:31:26','521','2022-11-27 19:31:57',10,0),('1','142',257841,'C1,DAILY SALES.','2022-11-28','2022-11-28 07:56:19','2022-11-29 07:56:19','521',0.00,0.00,'521','2022-11-28 19:20:42','521','2022-11-28 19:21:06',10,0),('1','142',257842,'CAHIIER 2 DAILY SALES','2022-11-29','2022-11-29 07:47:43','2022-11-30 07:47:43','521',0.00,0.00,'521','2022-11-29 12:30:34','521','2022-11-29 12:30:54',10,0),('1','142',257843,'CASHIER 2 DILY SALES','2022-11-29','2022-11-29 12:31:36','2022-11-30 12:31:36','521',0.00,0.00,'521','2022-11-29 19:50:58','521','2022-11-29 19:51:19',10,0),('1','142',257844,'OPERATIONAL LOSS','2022-11-30','2022-11-30 07:30:14','2022-12-01 07:30:14','521',0.00,0.00,'521','2022-11-30 07:36:30','521','2022-11-30 07:36:55',10,0),('1','142',257845,'OPERATIONAL LOSS','2022-11-30','2022-11-30 07:37:27','2022-12-01 07:37:27','521',0.00,0.00,'521','2022-11-30 07:51:26','521','2022-11-30 07:51:53',10,0),('1','142',257846,'OPERATIONAL LOSS','2022-11-30','2022-11-30 07:52:35','2022-12-01 07:52:35','521',0.00,0.00,'521','2022-11-30 07:59:45','521','2022-11-30 08:00:16',10,0),('1','142',257847,'OPERATIONAL LOSS','2022-11-30','2022-11-30 08:01:13','2022-12-01 08:01:13','521',0.00,0.00,'521','2022-11-30 08:08:47','521','2022-11-30 08:09:11',10,0),('1','142',257848,'OPERATIONAL LOSS','2022-11-30','2022-11-30 08:09:52','2022-12-01 08:09:52','521',0.00,0.00,'521','2022-11-30 08:13:15','521','2022-11-30 08:13:50',10,0),('1','142',257849,'CASHIER 2 DAILY SALES','2022-11-30','2022-11-30 08:14:31','2022-12-01 08:14:31','521',0.00,0.00,'521','2022-11-30 19:00:41','521','2022-11-30 19:01:10',10,0),('1','142',257850,'CASHIER 2 DAILY SALES','2022-12-01','2022-12-01 07:42:46','2022-12-02 07:42:46','521',0.00,0.00,'521','2022-12-01 19:09:33','521','2022-12-01 19:10:06',10,0),('1','142',257851,'CASHIIER 2 DAILY SALES','2022-12-02','2022-12-02 07:42:05','2022-12-03 07:42:05','521',0.00,0.00,'521','2022-12-02 19:07:46','521','2022-12-02 19:08:13',10,0),('1','142',257852,'CASHIER 2  DAILY SALES','2022-12-03','2022-12-03 08:14:11','2022-12-04 08:14:11','521',0.00,0.00,'521','2022-12-03 20:29:19','521','2022-12-03 20:29:44',10,0),('1','142',257853,'cashier 2 daily sales','2022-12-04','2022-12-04 12:26:33','2022-12-05 12:26:33','521',0.00,0.00,'521','2022-12-04 19:51:23','521','2022-12-04 20:15:06',10,0),('1','142',257854,'CASHIER 2  DAILY SALES','2022-12-05','2022-12-05 09:20:16','2022-12-06 09:20:16','521',0.00,0.00,'521','2022-12-05 22:35:08','521','2022-12-05 22:35:30',10,0),('1','142',257855,'CASHIER 2  DAILY SALES','2022-12-06','2022-12-06 08:10:36','2022-12-07 08:10:36','521',0.00,0.00,'521','2022-12-06 13:04:41','521','2022-12-06 13:05:01',10,0),('1','142',257856,'OPERATIONAL LOSS','2022-12-06','2022-12-06 16:28:48','2022-12-07 16:28:48','521',0.00,0.00,'521','2022-12-06 16:36:49','521','2022-12-06 16:37:13',10,0),('1','142',257857,'CASHIER 2 DAILY SALES','2022-12-06','2022-12-06 16:47:33','2022-12-07 16:47:33','521',0.00,0.00,'521','2022-12-06 20:02:36','521','2022-12-06 20:02:55',10,0),('1','142',257858,'CASHIER 2  DAILY SALES','2022-12-07','2022-12-07 07:44:49','2022-12-08 07:44:49','521',0.00,0.00,'521','2022-12-07 07:49:31','521','2022-12-07 07:49:54',10,0),('1','142',257859,'CASHIER 2  DAILY SALES','2022-12-07','2022-12-07 08:01:06','2022-12-08 08:01:06','521',0.00,0.00,'521','2022-12-08 08:53:02','521','2022-12-08 08:53:43',10,0),('1','142',257860,'CASHIER 2  DAILY SALES','2022-12-08','2022-12-08 08:55:42','2022-12-09 08:55:42','521',0.00,0.00,'521','2022-12-08 19:06:57','521','2022-12-08 19:07:45',10,0),('1','142',257861,'CASHIER 2  DAILY SALES','2022-12-09','2022-12-09 08:11:03','2022-12-10 08:11:03','521',0.00,0.00,'521','2022-12-09 19:09:09','521','2022-12-09 20:21:23',10,0),('1','142',257862,'CASHIER 2  DAILY SALES','2022-12-10','2022-12-10 09:06:40','2022-12-11 09:06:40','521',0.00,0.00,'521','2022-12-10 18:58:31','521','2022-12-10 19:00:39',10,0),('1','142',257863,'CASHIER 2  DAILY SALES','2022-12-11','2022-12-11 08:22:38','2022-12-12 08:22:38','521',0.00,0.00,'521','2022-12-11 19:10:31','521','2022-12-11 19:11:09',10,0),('1','142',257864,'CASHIER 2  DAILY SALES','2022-12-12','2022-12-12 07:44:40','2022-12-13 07:44:40','521',0.00,0.00,'521','2022-12-12 20:31:01','521','2022-12-12 20:31:40',10,0),('1','142',257865,'CASHIER 2  DAILY SALES','2022-12-13','2022-12-13 08:43:14','2022-12-14 08:43:14','521',0.00,0.00,'521','2022-12-13 19:59:30','521','2022-12-13 20:00:10',10,0),('1','142',257866,'C1,DAILY SALES.','2022-12-14','2022-12-14 08:24:54','2022-12-15 08:24:54','521',0.00,0.00,'521','2022-12-14 12:39:30','521','2022-12-14 12:41:05',10,0),('1','142',257867,'OPERATIONAL LOSS','2022-12-14','2022-12-14 12:44:00','2022-12-15 12:44:00','521',0.00,0.00,'521','2022-12-14 12:48:22','521','2022-12-14 12:48:51',10,0),('1','142',257868,'C1, DAILY SALES.','2022-12-14','2022-12-14 12:58:16','2022-12-15 12:58:16','521',0.00,0.00,'521','2022-12-14 19:23:59','521','2022-12-14 19:24:42',10,0),('1','142',257869,'C1, DAILY SALES.','2022-12-15','2022-12-15 07:55:40','2022-12-16 07:55:40','521',0.00,0.00,'521','2022-12-15 19:31:51','521','2022-12-15 19:32:27',10,0),('1','142',257870,'CASHIER 2  DAILY SALES','2022-12-16','2022-12-16 07:42:36','2022-12-17 07:42:36','521',0.00,0.00,'521','2022-12-16 19:38:14','521','2022-12-16 19:38:56',10,0),('1','142',257871,'CASHIER 2  DAILY SALES','2022-12-17','2022-12-17 07:53:41','2022-12-18 07:53:41','521',0.00,0.00,'521','2022-12-17 18:54:26','521','2022-12-17 18:55:06',10,0),('1','142',257872,'C1, DAILY SALES. ','2022-12-18','2022-12-18 08:02:00','2022-12-19 08:02:00','521',0.00,0.00,'521','2022-12-18 19:09:00','521','2022-12-18 19:40:10',10,0),('1','142',257873,'C1, DAILY SALES.','2022-12-19','2022-12-19 08:09:41','2022-12-20 08:09:41','521',0.00,0.00,'521','2022-12-19 20:20:27','521','2022-12-19 20:20:51',10,0),('1','142',257874,'CASHIER 2  DAILY SALES','2022-12-20','2022-12-20 07:54:25','2022-12-21 07:54:25','521',0.00,0.00,'521','2022-12-20 18:55:44','521','2022-12-20 18:56:27',10,0),('1','142',257875,'CASHIER 2  DAILY SALES','2022-12-21','2022-12-21 07:58:57','2022-12-22 07:58:57','521',0.00,0.00,'521','2022-12-21 19:44:51','521','2022-12-21 19:45:18',10,0),('1','142',257876,'C1, DAILY SALES.','2022-12-22','2022-12-22 08:08:29','2022-12-23 08:08:29','521',0.00,0.00,'521','2022-12-22 18:56:42','521','2022-12-22 18:57:23',10,0),('1','142',257877,'C1, DAILY SALES.','2022-12-23','2022-12-23 07:53:39','2022-12-24 07:53:39','521',0.00,0.00,'521','2022-12-23 19:15:21','521','2022-12-23 19:16:53',10,0),('1','142',257878,'C1, DAILY SALES.','2022-12-24','2022-12-24 08:44:36','2022-12-25 08:44:36','521',0.00,0.00,'521','2022-12-24 20:00:55','521','2022-12-24 20:01:22',10,0),('1','142',257879,'C1, DAILY SALES.','2022-12-25','2022-12-25 08:41:24','2022-12-26 08:41:24','521',0.00,0.00,'521','2022-12-25 19:07:30','521','2022-12-25 19:07:51',10,0),('1','142',257880,'CASHIER 2  DAILY SALES','2022-12-26','2022-12-26 08:17:24','2022-12-27 08:17:24','521',0.00,0.00,'521','2022-12-26 18:57:56','521','2022-12-26 18:58:26',10,0),('1','142',257881,'CASHIER 2  DAILY SALES','2022-12-27','2022-12-27 07:46:43','2022-12-28 07:46:43','521',0.00,0.00,'521','2022-12-27 18:56:01','521','2022-12-27 18:56:42',10,0),('1','142',257882,'C1, DAILY SALES.','2022-12-28','2022-12-28 08:55:48','2022-12-29 08:55:48','521',0.00,0.00,'521','2022-12-28 19:01:29','521','2022-12-28 19:01:50',10,0),('1','142',257883,'C1, DAILY SALES. ','2022-12-29','2022-12-29 07:58:19','2022-12-30 07:58:19','521',0.00,0.00,'521','2022-12-29 19:28:15','521','2022-12-29 19:28:37',10,0),('1','142',257884,'CASHIER 2  DAILY SALES','2022-12-30','2022-12-30 08:42:39','2022-12-31 08:42:39','521',0.00,0.00,'521','2022-12-30 19:03:36','521','2022-12-30 19:04:05',10,0),('1','142',257885,'CASHIER 2  DAILY SALES','2022-12-31','2022-12-31 08:24:25','2023-01-01 08:24:25','521',0.00,0.00,'521','2022-12-31 19:03:18','521','2022-12-31 19:03:39',10,0),('1','142',257886,'CASHIER 2  DAILY SALES','2023-01-01','2023-01-01 08:33:37','2023-01-02 08:33:37','521',0.00,0.00,'521','2023-01-01 19:00:18','521','2023-01-01 19:00:43',10,0),('1','142',257887,'C1, DAILY SALES. ','2023-01-02','2023-01-02 10:00:46','2023-01-03 10:00:46','521',0.00,0.00,'521','2023-01-02 19:30:34','521','2023-01-02 19:35:44',10,0),('1','142',257888,'C1, DAILY SALES.','2023-01-03','2023-01-03 08:32:45','2023-01-04 08:32:45','521',0.00,0.00,'521','2023-01-03 19:21:26','521','2023-01-03 19:25:27',10,0),('1','142',257889,'CASHIER 2  DAILY SALES','2023-01-04','2023-01-04 09:08:32','2023-01-05 09:08:32','521',0.00,0.00,'521','2023-01-04 19:21:37','521','2023-01-04 19:22:03',10,0),('1','142',257890,'C1, DAILY SALES.','2023-01-05','2023-01-05 08:28:53','2023-01-06 08:28:53','521',0.00,0.00,'521','2023-01-05 19:46:37','521','2023-01-05 20:30:46',10,0),('1','142',257891,'C1, DAILY SALES.','2023-01-06','2023-01-06 09:03:29','2023-01-07 09:03:29','521',0.00,0.00,'521','2023-01-06 19:13:00','521','2023-01-06 19:13:31',10,0),('1','142',257892,'C1, DAILY SALES.','2023-01-07','2023-01-07 08:11:14','2023-01-08 08:11:14','521',0.00,0.00,'521','2023-01-07 19:11:13','521','2023-01-07 19:12:00',10,0),('1','142',257893,'C1, DAILY SALES.','2023-01-08','2023-01-08 08:26:35','2023-01-09 08:26:35','521',0.00,0.00,'521','2023-01-08 21:49:27','521','2023-01-08 21:50:08',10,0),('1','142',257894,'CASHIER 2  DAILY SALES','2023-01-09','2023-01-09 07:50:19','2023-01-10 07:50:19','521',0.00,0.00,'521','2023-01-09 15:29:21','521','2023-01-09 15:29:42',10,0),('1','142',257895,'OPERATIONAL LOSS','2023-01-09','2023-01-09 15:36:37','2023-01-10 15:36:37','521',0.00,0.00,'521','2023-01-09 15:42:14','521','2023-01-09 15:44:13',10,0),('1','142',257896,'OPERATIONAL LOSS','2023-01-09','2023-01-09 15:45:07','2023-01-10 15:45:07','521',0.00,0.00,'521','2023-01-09 15:49:52','521','2023-01-09 15:50:32',10,0),('1','142',257897,'OPERATIONAL LOSS','2023-01-09','2023-01-09 15:51:05','2023-01-10 15:51:05','521',0.00,0.00,'521','2023-01-09 15:55:00','521','2023-01-09 15:55:21',10,0),('1','142',257898,'CASHIER 2  DAILY SALES','2023-01-09','2023-01-09 15:57:43','2023-01-10 15:57:43','521',0.00,0.00,'521','2023-01-09 20:02:39','521','2023-01-09 20:02:59',10,0),('1','142',257899,'CASHIER 2  DAILY SALES','2023-01-10','2023-01-10 08:29:48','2023-01-11 08:29:48','521',0.00,0.00,'521','2023-01-10 19:41:00','521','2023-01-10 19:41:23',10,0),('1','142',257900,'C1, DAILY SALES.','2023-01-11','2023-01-11 09:06:38','2023-01-12 09:06:38','521',0.00,0.00,'521','2023-01-11 19:19:51','521','2023-01-12 07:54:53',10,0),('1','142',257901,'C1, DAILY SALES. ','2023-01-12','2023-01-12 07:55:19','2023-01-13 07:55:19','521',0.00,0.00,'521','2023-01-12 19:54:40','521','2023-01-12 19:55:07',10,0),('1','142',257902,'CASHIER 2  DAILY SALES','2023-01-13','2023-01-13 08:59:28','2023-01-14 08:59:28','521',0.00,0.00,'521','2023-01-13 19:18:15','521','2023-01-13 19:18:47',10,0),('1','142',257903,'CASHIER 2  DAILY SALES','2023-01-14','2023-01-14 08:27:10','2023-01-15 08:27:10','521',0.00,0.00,'521','2023-01-14 18:47:46','521','2023-01-14 18:48:13',10,0),('1','142',257904,'C1, DAILY SALES.','2023-01-15','2023-01-15 08:28:42','2023-01-16 08:28:42','521',0.00,0.00,'521','2023-01-15 19:17:00','521','2023-01-15 19:17:20',10,0),('1','142',257905,'C1, DAILY SALES.','2023-01-16','2023-01-16 08:12:33','2023-01-17 08:12:33','521',0.00,0.00,'521','2023-01-16 19:27:36','521','2023-01-16 19:28:02',10,0),('1','142',257906,'CASHIER 2  DAILY SALES','2023-01-17','2023-01-17 07:38:57','2023-01-18 07:38:57','521',0.00,0.00,'521','2023-01-17 12:50:56','521','2023-01-17 12:51:15',10,0),('1','142',257907,'OPERATIONAL LOSS','2023-01-17','2023-01-17 12:59:22','2023-01-18 12:59:22','521',0.00,0.00,'521','2023-01-17 13:05:10','521','2023-01-17 13:05:34',10,0),('1','142',257908,'CASHIER 2  DAILY SALES','2023-01-17','2023-01-17 13:06:13','2023-01-18 13:06:13','521',0.00,0.00,'521','2023-01-17 19:56:57','521','2023-01-17 19:58:03',10,0),('1','142',257909,'CASHIER 2  DAILY SALES','2023-01-18','2023-01-18 08:25:36','2023-01-19 08:25:36','521',0.00,0.00,'521','2023-01-18 22:21:43','521','2023-01-18 22:27:28',10,0),('1','142',257910,'C1, DAILY SALES.','2023-01-19','2023-01-19 08:17:31','2023-01-20 08:17:31','521',0.00,0.00,'521','2023-01-19 19:50:42','521','2023-01-19 19:51:13',10,0),('1','142',257911,'C1, DAILY SALES.','2023-01-20','2023-01-20 08:53:53','2023-01-21 08:53:53','521',0.00,0.00,'521','2023-01-20 19:44:38','521','2023-01-20 19:46:27',10,0),('1','142',257912,'CASHIER 2  DAILY SALES','2023-01-21','2023-01-21 07:39:18','2023-01-22 07:39:18','521',0.00,0.00,'521','2023-01-21 18:31:50','521','2023-01-21 18:33:34',10,0),('1','142',257913,'CASHIER 2  DAILY SALES','2023-01-22','2023-01-22 08:29:47','2023-01-23 08:29:47','521',0.00,0.00,'521','2023-01-22 18:33:56','521','2023-01-22 18:34:28',10,0),('1','142',257914,'C1, DAILY SALES.','2023-01-23','2023-01-23 08:06:48','2023-01-24 08:06:48','521',0.00,0.00,'521','2023-01-23 19:09:51','521','2023-01-23 19:10:15',10,0),('1','142',257915,'C1, DAILY SALES.','2023-01-24','2023-01-24 08:26:38','2023-01-25 08:26:38','521',0.00,0.00,'521','2023-01-24 19:21:37','521','2023-01-24 19:22:41',10,0),('1','142',257916,'CASHIER 2  DAILY SALES','2023-01-25','2023-01-25 08:12:25','2023-01-26 08:12:25','521',0.00,0.00,'521','2023-01-25 15:06:12','521','2023-01-25 15:06:43',10,0),('1','142',257917,'OPERATIONAL LOSS','2023-01-25','2023-01-25 15:15:40','2023-01-26 15:15:40','521',0.00,0.00,'521','2023-01-25 15:19:27','521','2023-01-25 15:19:50',10,0),('1','142',257918,'CASHIER 2  DAILY SALES','2023-01-25','2023-01-25 15:21:31','2023-01-26 15:21:31','521',0.00,0.00,'521','2023-01-25 20:36:59','521','2023-01-25 20:37:40',10,0),('1','142',257919,'CASHIER 2  DAILY SALES','2023-01-26','2023-01-26 08:05:13','2023-01-27 08:05:13','521',0.00,0.00,'521','2023-01-26 19:49:48','521','2023-01-26 19:50:17',10,0),('1','142',257920,'C1, DAILY SALES.','2023-01-27','2023-01-27 08:31:32','2023-01-28 08:31:32','521',0.00,0.00,'521','2023-01-27 19:31:01','521','2023-01-27 19:31:47',10,0),('1','142',257921,'C1, DAILY SALES.','2023-01-28','2023-01-28 08:47:16','2023-01-29 08:47:16','521',0.00,0.00,'521','2023-01-28 19:18:19','521','2023-01-28 19:18:51',10,0),('1','142',257922,'CASHIER 2  DAILY SALES','2023-01-29','2023-01-29 08:38:44','2023-01-30 08:38:44','521',0.00,0.00,'521','2023-01-29 18:48:44','521','2023-01-29 22:38:40',10,0),('1','142',257923,'CASHIER 2  DAILY SALES','2023-01-30','2023-01-30 08:15:24','2023-01-31 08:15:24','521',0.00,0.00,'521','2023-01-30 23:58:48','521','2023-01-31 00:03:16',10,0),('1','142',257924,'C1, DAILY SALES.','2023-01-31','2023-01-31 08:31:20','2023-02-01 08:31:20','521',0.00,0.00,'521','2023-01-31 18:28:55','521','2023-01-31 18:30:18',10,0),('1','142',257925,'C1, DAILY SALES.','2023-02-01','2023-02-01 08:16:22','2023-02-02 08:16:22','521',0.00,0.00,'521','2023-02-02 08:08:24','521','2023-02-02 08:09:14',10,0),('1','142',257926,'CASHIER 2  DAILY SALES','2023-02-02','2023-02-02 08:09:47','2023-02-03 08:09:47','521',0.00,0.00,'521','2023-02-02 23:38:57','521','2023-02-02 23:39:21',10,0),('1','142',257927,'CASHIER 2  DAILY SALES','2023-02-03','2023-02-03 08:04:36','2023-02-04 08:04:36','521',0.00,0.00,'521','2023-02-03 20:33:50','521','2023-02-03 20:34:21',10,0),('1','142',257928,'C1, DAILY SALES.','2023-02-04','2023-02-04 08:55:47','2023-02-05 08:55:47','521',0.00,0.00,'521','2023-02-04 19:44:40','521','2023-02-04 19:45:31',10,0),('1','142',257929,'OPERATIONAL LOSS','2023-02-04','2023-02-04 19:47:10','2023-02-05 19:47:10','521',0.00,0.00,'521','2023-02-04 19:54:27','521','2023-02-04 19:55:08',10,0),('1','142',257930,'MANAGER SALES','2023-02-04','2023-02-04 23:20:32','2023-02-05 23:20:32','521',0.00,0.00,'521','2023-02-04 23:49:32','521','2023-02-04 23:50:23',10,0),('1','142',257931,'C1, DAILY SALES.','2023-02-05','2023-02-05 08:18:05','2023-02-06 08:18:05','521',0.00,0.00,'521','2023-02-05 19:22:53','521','2023-02-05 19:23:48',10,0),('1','142',257932,'CASHIER 2  DAILY SALES','2023-02-06','2023-02-06 08:05:20','2023-02-07 08:05:20','521',0.00,0.00,'521','2023-02-06 20:57:03','521','2023-02-06 20:57:39',10,0),('1','142',257933,'CASHIER 2  DAILY SALES','2023-02-07','2023-02-07 08:14:33','2023-02-08 08:14:33','521',0.00,0.00,'521','2023-02-07 19:30:28','521','2023-02-08 08:11:02',10,0),('1','142',257934,'C1, DAILY SALES.','2023-02-08','2023-02-08 08:11:28','2023-02-09 08:11:28','521',0.00,0.00,'521','2023-02-08 19:21:29','521','2023-02-08 19:26:34',10,0),('1','142',257935,'C1, DAILY SALES.','2023-02-09','2023-02-09 08:20:22','2023-02-10 08:20:22','521',0.00,0.00,'521','2023-02-09 18:58:03','521','2023-02-09 18:58:56',10,0),('1','142',257936,'C1, DAILY SALES.','2023-02-10','2023-02-10 08:48:57','2023-02-11 08:48:57','521',0.00,0.00,'521','2023-02-10 19:52:12','521','2023-02-10 19:52:54',10,0),('1','142',257937,'C1, DAILY SALES.','2023-02-11','2023-02-11 07:42:34','2023-02-12 07:42:34','521',0.00,0.00,'521','2023-02-11 19:02:25','521','2023-02-11 19:02:53',10,0),('1','142',257938,'C1, DAILY SALES.','2023-02-12','2023-02-12 07:49:33','2023-02-13 07:49:33','521',0.00,0.00,'521','2023-02-12 19:28:41','521','2023-02-12 19:29:16',10,0),('1','142',257939,'CASHIER 2  DAILY SALES','2023-02-13','2023-02-13 07:41:03','2023-02-14 07:41:03','521',0.00,0.00,'521','2023-02-13 20:48:17','521','2023-02-13 20:48:49',10,0),('1','142',257940,'C1, DAILY SALES.','2023-02-14','2023-02-14 07:50:04','2023-02-15 07:50:04','521',0.00,0.00,'521','2023-02-14 20:26:46','521','2023-02-15 08:08:25',10,0),('1','142',257941,'C1, DAILY SALES.','2023-02-15','2023-02-15 08:10:02','2023-02-16 08:10:02','521',0.00,0.00,'521','2023-02-15 21:31:24','521','2023-02-16 08:06:18',10,0),('1','142',257942,'CASHIER 2  DAILY SALES','2023-02-16','2023-02-16 08:06:59','2023-02-17 08:06:59','521',0.00,0.00,'521','2023-02-16 19:41:21','521','2023-02-16 19:42:06',10,0),('1','142',257943,'CASHIER 2  DAILY SALES','2023-02-17','2023-02-17 07:56:36','2023-02-18 07:56:36','521',0.00,0.00,'521','2023-02-17 20:10:00','521','2023-02-17 20:14:08',10,0),('1','142',257944,'C1, DAILY SALES.','2023-02-18','2023-02-18 08:13:22','2023-02-19 08:13:22','521',0.00,0.00,'521','2023-02-18 20:50:44','521','2023-02-18 20:51:09',10,0),('1','142',257945,'C1, DAILY SALES.','2023-02-19','2023-02-19 08:14:01','2023-02-20 08:14:01','521',0.00,0.00,'521','2023-02-19 20:28:50','521','2023-02-19 20:29:20',10,0),('1','142',257946,'CASHIER 2  DAILY SALES','2023-02-20','2023-02-20 07:56:28','2023-02-21 07:56:28','521',0.00,0.00,'521','2023-02-20 19:53:58','521','2023-02-20 19:54:54',10,0),('1','142',257947,'CASHIER 2  DAILY SALES','2023-02-21','2023-02-21 07:59:15','2023-02-22 07:59:15','521',0.00,0.00,'521','2023-02-21 19:55:42','521','2023-02-21 19:56:46',10,0),('1','142',257948,'CASHIER 2  DAILY SALES','2023-02-22','2023-02-22 07:36:21','2023-02-23 07:36:21','521',0.00,0.00,'521','2023-02-22 20:14:05','521','2023-02-22 20:14:49',10,0),('1','142',257949,'CASHIER 2  DAILY SALES','2023-02-23','2023-02-23 08:04:14','2023-02-24 08:04:14','521',0.00,0.00,'521','2023-02-23 19:56:39','521','2023-02-23 19:58:27',10,0),('1','142',257950,'CASHIER 2  DAILY SALES','2023-02-24','2023-02-24 07:53:13','2023-02-25 07:53:13','521',0.00,0.00,'521','2023-02-24 20:19:25','521','2023-02-24 20:20:50',10,0),('1','142',257951,'CASHIER 2  DAILY SALES','2023-02-26','2023-02-26 08:04:56','2023-02-27 08:04:56','521',0.00,0.00,'521','2023-02-26 20:24:11','521','2023-02-26 20:24:39',10,0),('1','142',257952,'CASHIER 2  DAILY SALES','2023-02-27','2023-02-27 08:10:01','2023-02-28 08:10:01','521',0.00,0.00,'521','2023-02-27 10:05:35','521','2023-02-27 10:06:16',10,0),('1','142',257953,'CASHIER 2  DAILY SALES','2023-02-27','2023-02-27 10:07:42','2023-02-28 10:07:42','521',0.00,0.00,'521','2023-02-27 20:29:27','521','2023-02-27 20:30:28',10,0),('1','142',257954,'CASHIER 2  DAILY SALES','2023-02-28','2023-02-28 07:48:12','2023-03-01 07:48:12','521',0.00,0.00,'521','2023-02-28 21:09:30','521','2023-02-28 21:09:57',10,0),('1','142',257955,'CASHIER 2  DAILY SALES','2023-03-01','2023-03-01 07:51:42','2023-03-02 07:51:42','521',0.00,0.00,'521','2023-03-01 19:44:54','521','2023-03-01 19:53:19',10,0),('1','142',257956,'CASHIER 2  DAILY SALES','2023-03-02','2023-03-02 08:06:19','2023-03-03 08:06:19','521',0.00,0.00,'521','2023-03-02 20:40:45','521','2023-03-02 20:41:28',10,0),('1','142',257957,'CASHIER 2  DAILY SALES','2023-03-03','2023-03-03 08:03:55','2023-03-04 08:03:55','521',0.00,0.00,'521','2023-03-03 20:12:25','521','2023-03-03 20:19:15',10,0),('1','142',257958,'CASHIER 2  DAILY SALES','2023-03-04','2023-03-04 08:01:45','2023-03-05 08:01:45','521',0.00,0.00,'521','2023-03-04 20:16:29','521','2023-03-04 20:17:10',10,0),('1','142',257959,'CASHIER 2  DAILY SALES','2023-03-05','2023-03-05 08:03:55','2023-03-06 08:03:55','521',0.00,0.00,'521','2023-03-05 20:12:45','521','2023-03-05 20:13:18',10,0),('1','142',257960,'CASHIER 2  DAILY SALES','2023-03-06','2023-03-06 07:59:05','2023-03-07 07:59:05','521',0.00,0.00,'521','2023-03-07 00:54:08','521','2023-03-07 00:54:49',10,0),('1','142',257961,'CASHIER 2  DAILY SALES','2023-03-07','2023-03-07 08:15:44','2023-03-08 08:15:44','521',0.00,0.00,'521','2023-03-07 19:51:13','521','2023-03-07 20:11:21',10,0),('1','142',257962,'CASHIER 2  DAILY SALES','2023-03-08','2023-03-08 08:03:39','2023-03-09 08:03:39','521',0.00,0.00,'521','2023-03-08 20:11:34','521','2023-03-08 20:12:00',10,0),('1','142',257963,'CASHIER 2  DAILY SALES','2023-03-09','2023-03-09 07:44:34','2023-03-10 07:44:34','521',0.00,0.00,'521','2023-03-09 19:45:40','521','2023-03-09 19:46:24',10,0),('1','142',257964,'CASHIER 2  DAILY SALES','2023-03-10','2023-03-10 07:55:50','2023-03-11 07:55:50','521',0.00,0.00,'521','2023-03-10 20:02:21','521','2023-03-10 20:03:31',10,0),('1','142',257965,'CASHIER 2  DAILY SALES','2023-03-11','2023-03-11 07:55:01','2023-03-12 07:55:01','521',0.00,0.00,'521','2023-03-11 20:45:06','521','2023-03-11 20:47:09',10,0),('1','142',257966,'ABBA DAILY SALES','2023-03-12','2023-03-12 08:10:38','2023-03-13 08:10:38','521',0.00,0.00,'521','2023-03-12 19:53:00','521','2023-03-12 19:53:24',10,0),('1','142',257967,'C1, DAILY SALES.','2023-03-13','2023-03-13 08:27:59','2023-03-14 08:27:59','521',0.00,0.00,'521','2023-03-13 19:57:02','521','2023-03-13 19:58:32',10,0),('1','142',257968,'C1, DAILY SALES.','2023-03-14','2023-03-14 08:59:57','2023-03-15 08:59:57','521',0.00,0.00,'521','2023-03-14 19:53:03','521','2023-03-14 19:53:28',10,0),('1','142',257969,'C1, DAILY SALES.','2023-03-15','2023-03-15 08:09:14','2023-03-16 08:09:14','521',0.00,0.00,'521','2023-03-15 19:39:25','521','2023-03-15 19:42:26',10,0),('1','142',257970,'C1, DAILY SALES.','2023-03-16','2023-03-16 08:21:25','2023-03-17 08:21:25','521',0.00,0.00,'521','2023-03-16 20:04:33','521','2023-03-16 20:05:25',10,0),('1','142',257971,'C1, DAILY SALES.','2023-03-17','2023-03-17 08:13:02','2023-03-18 08:13:02','521',0.00,0.00,'521','2023-03-17 20:02:25','521','2023-03-17 20:02:51',10,0),('1','142',257972,'C1, DAILY SALES.','2023-03-19','2023-03-19 10:25:22','2023-03-20 10:25:22','521',0.00,0.00,'521','2023-03-20 08:06:57','521','2023-03-20 08:07:18',10,0),('1','142',257973,'C1, DAILY SALES.','2023-03-20','2023-03-20 08:08:00','2023-03-21 08:08:00','521',0.00,0.00,'521','2023-03-20 17:21:10','521','2023-03-20 17:21:47',10,0),('1','142',257974,'C1, DAILY SALES.','2023-03-20','2023-03-20 19:40:43','2023-03-21 19:40:43','521',0.00,0.00,'521','2023-03-20 20:06:44','521','2023-03-20 20:07:16',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4905531 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','142','798','149918',2989974,'2231','342',0.00,3473.30,0.00,0.00,3473.30,774644.00,0.00,0.00,0.00),('1','142','799','149918',2989975,'2232','342',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','150025',2992016,'2231','342',3473.30,5194.10,0.00,0.00,1720.80,404674.00,0.00,0.00,0.00),('1','142','799','150025',2992017,'2232','342',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','150209',2995580,'2231','342',5194.10,6929.80,0.00,0.00,1735.70,416546.00,0.00,0.00,0.00),('1','142','799','150209',2995581,'2232','342',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','150491',3000712,'2231','342',6929.80,8252.15,0.00,0.00,1322.35,316733.00,0.00,0.00,0.00),('1','142','799','150491',3000713,'2232','342',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','150529',3001500,'2231','342',8252.15,9609.35,0.00,0.00,1357.20,324616.00,0.00,0.00,0.00),('1','142','799','150529',3001501,'2232','342',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','150701',3005007,'2231','342',9609.35,15182.95,0.00,0.00,5573.60,1273053.00,0.00,0.00,0.00),('1','142','799','150701',3005008,'2232','342',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','150827',3007319,'2231','342',15182.95,16397.45,0.00,0.00,1214.50,297060.00,0.00,0.00,0.00),('1','142','799','150827',3007320,'2232','342',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','150937',3009232,'2231','342',16397.45,18265.95,0.00,0.00,1868.50,442195.00,0.00,0.00,0.00),('1','142','799','150937',3009233,'2232','342',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','151090',3011992,'2231','342',18265.95,19289.35,0.00,0.00,1023.40,253927.00,0.00,0.00,0.00),('1','142','799','151090',3011993,'2232','342',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','151252',3015124,'2231','342',19289.35,20953.45,0.00,0.00,1664.10,396827.60,0.00,0.00,0.00),('1','142','799','151252',3015125,'2232','342',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','151351',3016857,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','151351',3016858,'2232','342',0.00,2610.00,0.00,0.00,2610.00,622495.40,0.00,0.00,0.00),('1','142','798','151577',3021138,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','151577',3021139,'2232','342',2610.00,5241.80,0.00,0.00,2631.80,620729.00,0.00,0.00,0.00),('1','142','798','151689',3023154,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','151689',3023155,'2232','342',5241.80,6760.40,0.00,0.00,1518.60,367508.00,0.00,0.00,0.00),('1','142','798','151779',3024641,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','151779',3024642,'2232','342',6760.40,7332.90,0.00,0.00,572.50,154525.00,0.00,0.00,0.00),('1','142','798','151886',3026719,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','151886',3026720,'2232','342',7332.90,11099.10,0.00,0.00,3766.20,849536.00,0.00,0.00,0.00),('1','142','798','152040',3029654,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','152040',3029655,'2232','342',11099.10,12232.30,0.00,0.00,1133.20,275020.00,0.00,0.00,0.00),('1','142','798','152200',3032686,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','152200',3032687,'2232','342',12232.30,12798.70,0.00,0.00,566.40,151156.00,0.00,0.00,0.00),('1','142','798','152357',3035620,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','152357',3035621,'2232','342',12798.70,14272.50,0.00,0.00,1473.80,359222.00,0.00,0.00,0.00),('1','142','798','152544',3038981,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','152544',3038982,'2232','342',14272.50,18714.00,0.00,0.00,4441.50,1034788.00,0.00,0.00,0.00),('1','142','798','152657',3040981,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','152657',3040982,'2232','342',18714.00,19302.00,0.00,0.00,588.00,154240.00,0.00,0.00,0.00),('1','142','798','152903',3045407,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','152903',3045408,'2232','342',19302.00,20839.90,0.00,0.00,1537.90,370292.00,0.00,0.00,0.00),('1','142','798','152989',3047012,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','152989',3047013,'2232','342',20839.90,22647.20,0.00,0.00,1807.30,405186.00,0.00,0.00,0.00),('1','142','798','153069',3048431,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','153069',3048432,'2232','342',22647.20,26681.60,0.00,0.00,4034.40,924536.00,0.00,0.00,0.00),('1','142','798','153153',3049900,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','153153',3049901,'2232','342',26681.60,27200.10,0.00,0.00,518.50,139980.00,0.00,0.00,0.00),('1','142','798','153461',3055614,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','153461',3055615,'2232','342',27200.10,27969.10,0.00,0.00,769.00,194468.00,0.00,0.00,0.00),('1','142','798','153592',3057972,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','153592',3057973,'2232','342',27969.10,30849.80,0.00,0.00,2880.70,678164.00,0.00,0.00,0.00),('1','142','798','153702',3059889,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','153702',3059890,'2232','342',30849.80,31541.40,0.00,0.00,691.60,182728.00,0.00,0.00,0.00),('1','142','798','153834',3062219,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','153834',3062220,'2232','342',31541.40,33525.40,0.00,0.00,1984.00,478768.00,0.00,0.00,0.00),('1','142','798','154044',3065944,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','154044',3065945,'2232','342',33525.40,36010.10,0.00,0.00,2484.70,595876.00,0.00,0.00,0.00),('1','142','798','154226',3069129,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','154226',3069130,'2232','342',36010.10,37995.00,0.00,0.00,1984.90,478526.00,0.00,0.00,0.00),('1','142','798','154306',3070517,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','154306',3070518,'2232','342',37995.00,41607.20,0.00,0.00,3612.20,850866.00,0.00,0.00,0.00),('1','142','798','154469',3073681,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','154469',3073682,'2232','342',41607.20,43800.30,0.00,0.00,2193.10,525682.00,0.00,0.00,0.00),('1','142','798','154630',3076657,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','154630',3076658,'2232','342',43800.30,44856.30,0.00,0.00,1056.00,237312.00,0.00,0.00,0.00),('1','142','798','154697',3078115,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','154697',3078116,'2232','342',44856.30,46207.00,0.00,0.00,1350.70,319464.00,0.00,0.00,0.00),('1','142','798','154856',3080984,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','154856',3080985,'2232','342',46207.00,47098.90,0.00,0.00,891.90,229712.00,0.00,0.00,0.00),('1','142','798','155006',3083854,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','155006',3083855,'2232','342',47098.90,51183.30,0.00,0.00,4084.40,947536.00,0.00,0.00,0.00),('1','142','798','155122',3086020,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','155122',3086021,'2232','342',51183.30,54016.60,0.00,0.00,2833.30,675084.00,0.00,0.00,0.00),('1','142','798','155304',3089331,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','155304',3089332,'2232','342',54016.60,59141.50,0.00,0.00,5124.90,1188186.00,0.00,0.00,0.00),('1','142','798','155424',3091723,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','155424',3091724,'2232','342',59141.50,63369.70,0.00,0.00,4228.20,970794.00,0.00,0.00,0.00),('1','142','798','155620',3095302,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','155620',3095303,'2232','342',63369.70,65920.20,0.00,0.00,2550.50,624258.00,0.00,0.00,0.00),('1','142','798','155711',3096805,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','155711',3096806,'2232','342',65920.20,67286.90,0.00,0.00,1366.70,309496.00,0.00,0.00,0.00),('1','142','798','155912',3100360,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','155912',3100361,'2232','342',67286.90,69055.80,0.00,0.00,1768.90,424806.00,0.00,0.00,0.00),('1','142','798','156065',3103286,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','156065',3103287,'2232','342',69055.80,72591.80,0.00,0.00,3536.00,806894.00,0.00,0.00,0.00),('1','142','798','156188',3105433,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','156188',3105434,'2232','342',72591.80,73384.30,0.00,0.00,792.50,201880.00,0.00,0.00,0.00),('1','142','798','156401',3109291,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','156401',3109292,'2232','342',73384.30,77812.80,0.00,0.00,4428.50,1000320.00,0.00,0.00,0.00),('1','142','798','156578',3112647,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','156578',3112648,'2232','342',77812.80,82189.40,0.00,0.00,4376.60,1014658.00,0.00,0.00,0.00),('1','142','798','156721',3115279,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','156721',3115280,'2232','342',82189.40,83423.30,0.00,0.00,1233.90,293206.00,0.00,0.00,0.00),('1','142','798','156888',3118306,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','156888',3118307,'2232','342',83423.30,85255.30,0.00,0.00,1832.00,434700.00,0.00,0.00,0.00),('1','142','798','157056',3121382,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','157056',3121383,'2232','342',85255.30,86383.20,0.00,0.00,1127.90,263092.00,0.00,0.00,0.00),('1','142','798','157252',3124881,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','157252',3124882,'2232','342',86383.20,88203.20,0.00,0.00,1820.00,420444.00,0.00,0.00,0.00),('1','142','798','157430',3127786,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','157430',3127787,'2232','342',88203.20,89269.00,0.00,0.00,1065.80,266054.00,0.00,0.00,0.00),('1','142','798','157573',3130147,'2231','342',20953.45,20953.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','157573',3130148,'2232','342',89269.00,90066.00,0.00,0.00,797.00,183458.00,0.00,0.00,0.00),('1','142','798','157637',3131525,'2231','342',20953.45,22047.45,0.00,0.00,1094.00,274134.00,0.00,0.00,0.00),('1','142','799','157637',3131526,'2232','342',90066.00,90066.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','157773',3133977,'2231','342',22047.45,25826.05,0.00,0.00,3778.60,873180.00,0.00,0.00,0.00),('1','142','799','157773',3133978,'2232','342',90066.00,90066.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','157936',3137079,'2231','342',25826.05,28526.25,0.00,0.00,2700.20,618174.00,0.00,0.00,0.00),('1','142','799','157936',3137080,'2232','342',90066.00,90066.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','158068',3139526,'2231','342',28526.25,29544.65,0.00,0.00,1018.40,250338.00,0.00,0.00,0.00),('1','142','799','158068',3139527,'2232','342',90066.00,90066.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','158240',3142757,'2231','342',29544.65,35352.05,0.00,0.00,5807.40,1321662.40,0.00,0.00,0.00),('1','142','799','158240',3142758,'2232','342',90066.00,90066.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','158410',3146020,'2231','342',35352.05,37844.55,0.00,0.00,2492.50,571308.00,0.00,0.00,0.00),('1','142','799','158410',3146021,'2232','342',90066.00,90066.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','158559',3148578,'2231','342',37844.55,40781.65,0.00,0.00,2937.10,698965.00,0.00,0.00,0.00),('1','142','799','158559',3148579,'2232','342',90066.00,90066.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','158729',3151746,'2231','342',40781.65,43226.65,0.00,0.00,2445.00,550986.00,0.00,0.00,0.00),('1','142','799','158729',3151747,'2232','342',90066.00,90066.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','159242',3160872,'2231','342',43226.65,43226.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','159242',3160873,'2232','342',90066.00,93907.60,0.00,0.00,3841.60,902012.00,0.00,0.00,0.00),('1','142','798','159441',3163954,'2231','342',43226.65,43226.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','159441',3163955,'2232','342',93907.60,97845.20,0.00,0.00,3937.60,933016.00,0.00,0.00,0.00),('1','142','798','159619',3167233,'2231','342',43226.65,43226.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','159619',3167234,'2232','342',97845.20,101311.70,0.00,0.00,3466.50,822960.00,0.00,0.00,0.00),('1','142','798','159725',3168970,'2231','342',43226.65,43226.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','159725',3168971,'2232','342',101311.70,103900.90,0.00,0.00,2589.20,607796.00,0.00,0.00,0.00),('1','142','798','159921',3172417,'2231','342',43226.65,43226.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','159921',3172418,'2232','342',103900.90,107779.60,0.00,0.00,3878.70,912356.00,0.00,0.00,0.00),('1','142','798','160110',3176016,'2231','342',43226.65,43226.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','160110',3176017,'2232','342',107779.60,108553.80,0.00,0.00,774.20,197016.00,0.00,0.00,0.00),('1','142','798','160301',3179345,'2231','342',43226.65,43226.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','160301',3179346,'2232','342',108553.80,111159.20,0.00,0.00,2605.40,609826.40,0.00,0.00,0.00),('1','142','798','160378',3180734,'2231','342',43226.65,43226.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','160378',3180735,'2232','342',111159.20,111349.20,0.00,0.00,190.00,48000.00,0.00,0.00,0.00),('1','142','798','160450',3182073,'2231','342',43226.65,44062.15,0.00,0.00,835.50,214765.60,0.00,0.00,0.00),('1','142','799','160450',3182074,'2232','342',111349.20,111349.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','160585',3184560,'2231','342',44062.15,45327.05,0.00,0.00,1264.90,325444.00,0.00,0.00,0.00),('1','142','799','160585',3184561,'2232','342',111349.20,111349.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','160733',3186948,'2231','342',45327.05,48100.35,0.00,0.00,2773.30,687090.00,0.00,0.00,0.00),('1','142','799','160733',3186949,'2232','342',111349.20,111349.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','160880',3189415,'2231','342',48100.35,50462.25,0.00,0.00,2361.90,584960.00,0.00,0.00,0.00),('1','142','799','160880',3189416,'2232','342',111349.20,111349.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','161080',3193077,'2231','342',50462.25,54078.05,0.00,0.00,3615.80,896588.40,0.00,0.00,0.00),('1','142','799','161080',3193078,'2232','342',111349.20,111349.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','161262',3196478,'2231','342',54078.05,54578.55,0.00,0.00,500.50,124120.00,0.00,0.00,0.00),('1','142','799','161262',3196479,'2232','342',111349.20,111349.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','161473',3199623,'2231','342',54578.55,62002.35,0.00,0.00,7423.80,1807972.40,0.00,0.00,0.00),('1','142','799','161473',3199624,'2232','342',111349.20,111349.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','161851',3206258,'2231','342',62002.35,65747.45,0.00,0.00,3745.10,952501.80,0.00,0.00,0.00),('1','142','799','161851',3206259,'2232','342',111349.20,111349.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','161866',3206458,'2231','342',65747.45,68987.75,0.00,0.00,3240.30,822359.80,0.00,0.00,0.00),('1','142','799','161866',3206459,'2232','342',111349.20,111349.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','162035',3209655,'2231','342',68987.75,69872.35,0.00,0.00,884.60,238293.20,0.00,0.00,0.00),('1','142','799','162035',3209656,'2232','342',111349.20,111349.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','162224',3212857,'2231','342',69872.35,70973.25,0.00,0.00,1100.90,297576.20,0.00,0.00,0.00),('1','142','799','162224',3212858,'2232','342',111349.20,111349.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','162445',3216600,'2231','342',70973.25,73622.75,0.00,0.00,2649.50,682777.80,0.00,0.00,0.00),('1','142','799','162445',3216601,'2232','342',111349.20,111349.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','162663',3219989,'2231','342',73622.75,73622.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','162663',3219990,'2232','342',111349.20,111349.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','162664',3219991,'2231','342',73622.75,80443.65,0.00,0.00,6820.90,1727292.20,0.00,0.00,0.00),('1','142','799','162664',3219992,'2232','342',111349.20,111349.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','162799',3222644,'2231','342',80443.65,82703.85,0.00,0.00,2260.20,585069.60,0.00,0.00,0.00),('1','142','799','162799',3222645,'2232','342',111349.20,111349.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','163023',3226477,'2231','342',82703.85,83067.75,0.00,0.00,363.90,98060.60,0.00,0.00,0.00),('1','142','799','163023',3226478,'2232','342',111349.20,111349.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','163025',3226502,'2231','342',83067.75,83067.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','163025',3226503,'2232','342',111349.20,112081.20,0.00,0.00,732.00,203528.00,0.00,0.00,0.00),('1','142','798','163197',3229697,'2231','342',83067.75,83067.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','163197',3229698,'2232','342',112081.20,114395.60,0.00,0.00,2314.40,614930.80,0.00,0.00,0.00),('1','142','798','163363',3232631,'2231','342',83067.75,83795.05,0.00,0.00,727.30,212630.20,0.00,0.00,0.00),('1','142','799','163363',3232632,'2232','342',114395.60,114395.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','163569',3236295,'2231','342',83795.05,85660.15,0.00,0.00,1865.10,504237.00,0.00,0.00,0.00),('1','142','799','163569',3236296,'2232','342',114395.60,114395.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','163728',3239231,'2231','342',85660.15,88323.95,0.00,0.00,2663.80,681594.40,0.00,0.00,0.00),('1','142','799','163728',3239232,'2232','342',114395.60,114395.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','163760',3239697,'2231','342',88323.95,88323.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','163760',3239698,'2232','342',114395.60,122058.60,0.00,0.00,7663.00,1935429.40,0.00,0.00,0.00),('1','142','798','163915',3242475,'2231','342',88323.95,90853.15,0.00,0.00,2529.20,678339.40,0.00,0.00,0.00),('1','142','799','163915',3242476,'2232','342',122058.60,122058.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','164101',3245773,'2231','342',90853.15,90853.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','164101',3245774,'2232','342',122058.60,123110.20,0.00,0.00,1051.60,300589.60,0.00,0.00,0.00),('1','142','798','164297',3249370,'2231','342',90853.15,90853.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','164297',3249371,'2232','342',123110.20,124714.00,0.00,0.00,1603.80,441348.80,0.00,0.00,0.00),('1','142','798','164480',3252776,'2231','342',90853.15,90853.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','164480',3252777,'2232','342',124714.00,131383.90,0.00,0.00,6669.90,1822430.20,0.00,0.00,0.00),('1','142','798','164627',3255369,'2231','342',90853.15,90853.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','164627',3255370,'2232','342',131383.90,134705.70,0.00,0.00,3321.80,917740.40,0.00,0.00,0.00),('1','142','798','164780',3258285,'2231','342',90853.15,92662.25,0.00,0.00,1809.10,510386.60,0.00,0.00,0.00),('1','142','799','164780',3258286,'2232','342',134705.70,134705.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','165007',3262136,'2231','342',92662.25,92662.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','165007',3262137,'2232','342',134705.70,140421.30,0.00,0.00,5715.60,1569464.80,0.00,0.00,0.00),('1','142','798','165170',3265058,'2231','342',92662.25,96906.85,0.00,0.00,4244.60,1265543.00,0.00,0.00,0.00),('1','142','799','165170',3265059,'2232','342',140421.30,140421.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','165339',3267988,'2231','342',96906.85,98845.85,0.00,0.00,1939.00,594296.00,0.00,0.00,0.00),('1','142','799','165339',3267989,'2232','342',140421.30,140421.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','165467',3270246,'2231','342',98845.85,101774.45,0.00,0.00,2928.60,884071.20,0.00,0.00,0.00),('1','142','799','165467',3270247,'2232','342',140421.30,140421.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','165654',3273575,'2231','342',101774.45,103515.85,0.00,0.00,1741.40,531488.80,0.00,0.00,0.00),('1','142','799','165654',3273576,'2232','342',140421.30,140421.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','165814',3276662,'2231','342',103515.85,106058.25,0.00,0.00,2542.40,572800.80,0.00,0.00,0.00),('1','142','799','165814',3276663,'2232','342',140421.30,140421.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','165996',3279678,'2231','342',106058.25,107565.85,0.00,0.00,1507.60,468749.20,0.00,0.00,0.00),('1','142','799','165996',3279679,'2232','342',140421.30,140421.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','166174',3282853,'2231','342',107565.85,111692.45,0.00,0.00,4126.60,1231444.40,0.00,0.00,0.00),('1','142','799','166174',3282854,'2232','342',140421.30,140421.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','166550',3289768,'2231','342',111692.45,113942.55,0.00,0.00,2250.10,678365.20,0.00,0.00,0.00),('1','142','799','166550',3289769,'2232','342',140421.30,140421.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','166556',3289844,'2231','342',113942.55,113942.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','166556',3289845,'2232','342',140421.30,143496.40,0.00,0.00,3075.10,924606.80,0.00,0.00,0.00),('1','142','798','166686',3292239,'2231','342',113942.55,113942.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','166686',3292240,'2232','342',143496.40,144271.40,0.00,0.00,775.00,244642.40,0.00,0.00,0.00),('1','142','798','166914',3295922,'2231','342',113942.55,113942.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','166914',3295923,'2232','342',144271.40,146411.80,0.00,0.00,2140.40,648520.00,0.00,0.00,0.00),('1','142','798','167063',3298795,'2231','342',113942.55,113942.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','167063',3298796,'2232','342',146411.80,148417.80,0.00,0.00,2006.00,609352.00,0.00,0.00,0.00),('1','142','798','167172',3300766,'2231','342',113942.55,113942.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','167172',3300767,'2232','342',148417.80,149201.60,0.00,0.00,783.80,246522.40,0.00,0.00,0.00),('1','142','798','167362',3304178,'2231','342',113942.55,113942.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','167362',3304179,'2232','342',149201.60,153283.20,0.00,0.00,4081.60,1212833.60,0.00,0.00,0.00),('1','142','798','167558',3307785,'2231','342',113942.55,113942.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','167558',3307786,'2232','342',153283.20,154851.40,0.00,0.00,1568.20,475806.00,0.00,0.00,0.00),('1','142','798','167759',3311059,'2231','342',113942.55,113942.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','167759',3311060,'2232','342',154851.40,158059.60,0.00,0.00,3208.20,952851.50,0.00,0.00,0.00),('1','142','798','167760',3311061,'2231','342',113942.55,115759.75,0.00,0.00,1817.20,544740.80,0.00,0.00,0.00),('1','142','799','167760',3311062,'2232','342',158059.60,158059.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','167918',3313900,'2231','342',115759.75,115759.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','167918',3313901,'2232','342',158059.60,160177.70,0.00,0.00,2118.10,637791.50,0.00,0.00,0.00),('1','142','798','168100',3317576,'2231','342',115759.75,116668.35,0.00,0.00,908.60,286578.40,0.00,0.00,0.00),('1','142','799','168100',3317577,'2232','342',160177.70,160177.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','168284',3320892,'2231','342',116668.35,119962.55,0.00,0.00,3294.20,993124.00,0.00,0.00,0.00),('1','142','799','168284',3320893,'2232','342',160177.70,160177.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','168435',3323543,'2231','342',119962.55,120668.25,0.00,0.00,705.70,221936.00,0.00,0.00,0.00),('1','142','799','168435',3323544,'2232','342',160177.70,160177.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','168599',3326478,'2231','342',120668.25,123806.05,0.00,0.00,3137.80,946751.50,0.00,0.00,0.00),('1','142','799','168599',3326479,'2232','342',160177.70,160177.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','168764',3329622,'2231','342',123806.05,127226.65,0.00,0.00,3420.60,1020859.50,0.00,0.00,0.00),('1','142','799','168764',3329623,'2232','342',160177.70,160177.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','168925',3332286,'2231','342',127226.65,128307.95,0.00,0.00,1081.30,342416.00,0.00,0.00,0.00),('1','142','799','168925',3332287,'2232','342',160177.70,160177.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','169140',3336018,'2231','342',128307.95,134432.65,0.00,0.00,6124.70,1835744.80,0.00,0.00,0.00),('1','142','799','169140',3336019,'2232','342',160177.70,160177.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','169142',3336060,'2231','342',134432.65,134432.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','169142',3336061,'2232','342',160177.70,161104.90,0.00,0.00,927.20,281087.20,0.00,0.00,0.00),('1','142','798','169295',3338946,'2231','342',134432.65,134432.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','169295',3338947,'2232','342',161104.90,162238.80,0.00,0.00,1133.90,356650.00,0.00,0.00,0.00),('1','142','798','169462',3342315,'2231','342',134432.65,134432.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','169462',3342316,'2232','342',162238.80,165890.20,0.00,0.00,3651.40,1096556.30,0.00,0.00,0.00),('1','142','798','169563',3344427,'2231','342',134432.65,137208.65,0.00,0.00,2776.00,832320.00,0.00,0.00,0.00),('1','142','799','169563',3344428,'2232','342',165890.20,165890.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','169760',3348034,'2231','342',137208.65,140025.35,0.00,0.00,2816.70,847852.00,0.00,0.00,0.00),('1','142','799','169760',3348035,'2232','342',165890.20,165890.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','169915',3351098,'2231','342',140025.35,140025.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','169915',3351099,'2232','342',165890.20,168589.20,0.00,0.00,2699.00,816040.00,0.00,0.00,0.00),('1','142','798','170121',3354610,'2231','342',140025.35,140025.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','170121',3354611,'2232','342',168589.20,171150.30,0.00,0.00,2561.10,777981.40,0.00,0.00,0.00),('1','142','798','170399',3359376,'2231','342',140025.35,140025.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','170399',3359377,'2232','342',171150.30,172634.50,0.00,0.00,1484.20,459824.00,0.00,0.00,0.00),('1','142','798','170483',3360822,'2231','342',140025.35,140025.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','170483',3360823,'2232','342',172634.50,178904.90,0.00,0.00,6270.40,1857874.00,0.00,0.00,0.00),('1','142','798','170720',3365091,'2231','342',140025.35,140025.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','170720',3365092,'2232','342',178904.90,179446.20,0.00,0.00,541.30,171776.00,0.00,0.00,0.00),('1','142','798','170826',3366914,'2231','342',140025.35,140025.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','170826',3366915,'2232','342',179446.20,181524.20,0.00,0.00,2078.00,642640.00,0.00,0.00,0.00),('1','142','798','170969',3369523,'2231','342',140025.35,143170.05,0.00,0.00,3144.70,963004.70,0.00,0.00,0.00),('1','142','799','170969',3369524,'2232','342',181524.20,181524.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','171249',3374706,'2231','342',143170.05,144340.85,0.00,0.00,1170.80,367625.60,0.00,0.00,0.00),('1','142','799','171249',3374707,'2232','342',181524.20,181524.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','171356',3376819,'2231','342',144340.85,145082.85,0.00,0.00,742.00,235280.00,0.00,0.00,0.00),('1','142','799','171356',3376820,'2232','342',181524.20,181524.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','171586',3380887,'2231','342',145082.85,149257.05,0.00,0.00,4174.20,1282588.80,0.00,0.00,0.00),('1','142','799','171586',3380888,'2232','342',181524.20,181524.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','171763',3384037,'2231','342',149257.05,152461.75,0.00,0.00,3204.70,986555.20,0.00,0.00,0.00),('1','142','799','171763',3384038,'2232','342',181524.20,181524.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','171944',3387251,'2231','342',152461.75,154431.95,0.00,0.00,1970.20,606651.20,0.00,0.00,0.00),('1','142','799','171944',3387252,'2232','342',181524.20,181524.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','172103',3390021,'2231','342',154431.95,158024.15,0.00,0.00,3592.20,1096109.20,0.00,0.00,0.00),('1','142','799','172103',3390022,'2232','342',181524.20,181524.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','172286',3393467,'2231','342',158024.15,158958.35,0.00,0.00,934.20,287228.80,0.00,0.00,0.00),('1','142','799','172286',3393468,'2232','342',181524.20,181524.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','172287',3393469,'2231','342',158958.35,158958.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','172287',3393470,'2232','342',181524.20,184909.60,0.00,0.00,3385.40,1038430.40,0.00,0.00,0.00),('1','142','798','172495',3397272,'2231','342',158958.35,158958.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','172495',3397273,'2232','342',184909.60,186826.80,0.00,0.00,1917.20,593144.00,0.00,0.00,0.00),('1','142','798','172699',3401004,'2231','342',158958.35,158958.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','172699',3401005,'2232','342',186826.80,189436.30,0.00,0.00,2609.50,803719.80,0.00,0.00,0.00),('1','142','798','172876',3404278,'2231','342',158958.35,158958.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','172876',3404279,'2232','342',189436.30,190519.30,0.00,0.00,1083.00,340512.00,0.00,0.00,0.00),('1','142','798','173045',3407439,'2231','342',158958.35,158958.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','173045',3407440,'2232','342',190519.30,192559.50,0.00,0.00,2040.20,627643.20,0.00,0.00,0.00),('1','142','798','173245',3411310,'2231','342',158958.35,158958.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','173245',3411311,'2232','342',192559.50,194215.90,0.00,0.00,1656.40,513313.60,0.00,0.00,0.00),('1','142','798','173375',3413727,'2231','342',158958.35,158958.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','173375',3413728,'2232','342',194215.90,198453.30,0.00,0.00,4237.40,1300104.00,0.00,0.00,0.00),('1','142','798','173586',3417712,'2231','342',158958.35,158958.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','173586',3417713,'2232','342',198453.30,201834.20,0.00,0.00,3380.90,1042360.00,0.00,0.00,0.00),('1','142','798','173759',3420739,'2231','342',158958.35,158958.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','173759',3420740,'2232','342',201834.20,204988.40,0.00,0.00,3154.20,971288.00,0.00,0.00,0.00),('1','142','798','173915',3423713,'2231','342',158958.35,158958.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','173915',3423714,'2232','342',204988.40,206650.20,0.00,0.00,1661.80,509372.80,0.00,0.00,0.00),('1','142','798','173916',3423715,'2231','342',158958.35,160586.35,0.00,0.00,1628.00,501115.20,0.00,0.00,0.00),('1','142','799','173916',3423716,'2232','342',206650.20,206650.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','174139',3427420,'2231','342',160586.35,162678.15,0.00,0.00,2091.80,644672.00,0.00,0.00,0.00),('1','142','799','174139',3427421,'2232','342',206650.20,206650.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','174298',3430530,'2231','342',162678.15,162678.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','174298',3430531,'2232','342',206650.20,208477.10,0.00,0.00,1826.90,566582.80,0.00,0.00,0.00),('1','142','798','174599',3435713,'2231','342',162678.15,162678.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','174599',3435714,'2232','342',208477.10,211906.00,0.00,0.00,3428.90,1055259.20,0.00,0.00,0.00),('1','142','798','174613',3435878,'2231','342',162678.15,162678.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','174613',3435879,'2232','342',211906.00,214456.30,0.00,0.00,2550.30,784134.40,0.00,0.00,0.00),('1','142','798','174858',3440331,'2231','342',162678.15,162678.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','174858',3440332,'2232','342',214456.30,217798.80,0.00,0.00,3342.50,1029533.00,0.00,0.00,0.00),('1','142','798','175065',3444247,'2231','342',162678.15,162678.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','175065',3444248,'2232','342',217798.80,217798.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','175066',3444249,'2231','342',162678.15,162678.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','175066',3444250,'2232','342',217798.80,221029.70,0.00,0.00,3230.90,1038096.80,0.00,0.00,0.00),('1','142','798','175258',3447713,'2231','342',162678.15,162678.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','175258',3447714,'2232','342',221029.70,226581.40,0.00,0.00,5551.70,1771541.40,0.00,0.00,0.00),('1','142','798','175402',3450560,'2231','342',162678.15,165030.95,0.00,0.00,2352.80,772347.20,0.00,0.00,0.00),('1','142','799','175402',3450561,'2232','342',226581.40,226581.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','175609',3454163,'2231','342',165030.95,167872.95,0.00,0.00,2842.00,914989.00,0.00,0.00,0.00),('1','142','799','175609',3454164,'2232','342',226581.40,226581.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','175794',3457525,'2231','342',167872.95,170390.15,0.00,0.00,2517.20,823713.40,0.00,0.00,0.00),('1','142','799','175794',3457526,'2232','342',226581.40,226581.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','175924',3459871,'2231','342',170390.15,174844.55,0.00,0.00,4454.40,1422648.80,0.00,0.00,0.00),('1','142','799','175924',3459872,'2232','342',226581.40,226581.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','176159',3464020,'2231','342',174844.55,177152.95,0.00,0.00,2308.40,748458.80,0.00,0.00,0.00),('1','142','799','176159',3464021,'2232','342',226581.40,226581.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','176352',3467689,'2231','342',177152.95,179026.35,0.00,0.00,1873.40,613776.40,0.00,0.00,0.00),('1','142','799','176352',3467690,'2232','342',226581.40,226581.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','176574',3471880,'2231','342',179026.35,181360.15,0.00,0.00,2333.80,771594.00,0.00,0.00,0.00),('1','142','799','176574',3471881,'2232','342',226581.40,226581.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','176647',3473341,'2231','342',181360.15,183761.15,0.00,0.00,2401.00,756546.20,0.00,0.00,0.00),('1','142','799','176647',3473342,'2232','342',226581.40,226581.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','176774',3475630,'2231','342',183761.15,183761.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','176774',3475631,'2232','342',226581.40,229716.40,0.00,0.00,3135.00,1001419.20,0.00,0.00,0.00),('1','142','798','177029',3480064,'2231','342',183761.15,183761.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','177029',3480065,'2232','342',229716.40,233124.80,0.00,0.00,3408.40,1101814.40,0.00,0.00,0.00),('1','142','798','177298',3485562,'2231','342',183761.15,183761.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','177298',3485563,'2232','342',233124.80,244634.40,0.00,0.00,11509.60,3699134.60,0.00,0.00,0.00),('1','142','798','177846',3496266,'2231','342',183761.15,183761.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','177846',3496267,'2232','342',244634.40,244634.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','178457',3507838,'2231','342',183761.15,183761.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','178457',3507839,'2232','342',244634.40,246612.30,0.00,0.00,1977.90,644094.20,0.00,0.00,0.00),('1','142','798','178460',3507858,'2231','342',183761.15,183761.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','178460',3507859,'2232','342',246612.30,249977.60,0.00,0.00,3365.30,1080552.40,0.00,0.00,0.00),('1','142','798','178513',3508754,'2231','342',183761.15,183761.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','178513',3508755,'2232','342',249977.60,251383.20,0.00,0.00,1405.60,454996.30,0.00,0.00,0.00),('1','142','798','178518',3508848,'2231','342',183761.15,186271.15,0.00,0.00,2510.00,795832.90,0.00,0.00,0.00),('1','142','799','178518',3508849,'2232','342',251383.20,251383.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','178526',3508973,'2231','342',186271.15,187869.15,0.00,0.00,1598.00,528778.60,0.00,0.00,0.00),('1','142','799','178526',3508974,'2232','342',251383.20,251383.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','178848',3514953,'2231','342',187869.15,192660.45,0.00,0.00,4791.30,1587516.80,0.00,0.00,0.00),('1','142','799','178848',3514954,'2232','342',251383.20,251383.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','178870',3515347,'2231','342',192660.45,193922.65,0.00,0.00,1262.20,429718.80,0.00,0.00,0.00),('1','142','799','178870',3515348,'2232','342',251383.20,251383.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','179046',3518410,'2231','342',193922.65,193922.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','179046',3518411,'2232','342',251383.20,254301.40,0.00,0.00,2918.20,966645.90,0.00,0.00,0.00),('1','142','798','179148',3520291,'2231','342',193922.65,193922.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','179148',3520292,'2232','342',254301.40,256626.40,0.00,0.00,2325.00,774522.88,0.00,0.00,0.00),('1','142','798','179379',3524764,'2231','342',193922.65,195886.91,0.00,0.00,1964.26,664674.40,0.00,0.00,0.00),('1','142','799','179379',3524765,'2232','342',256626.40,256626.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','179579',3528523,'2231','342',195886.91,197484.28,0.00,0.00,1597.37,542385.20,0.00,0.00,0.00),('1','142','799','179579',3528524,'2232','342',256626.40,256626.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','179777',3532477,'2231','342',197484.28,199975.45,0.00,0.00,2491.17,828755.60,0.00,0.00,0.00),('1','142','799','179777',3532478,'2232','342',256626.40,256626.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','179997',3536469,'2231','342',199975.45,205512.82,0.00,0.00,5537.37,1816581.94,0.00,0.00,0.00),('1','142','799','179997',3536470,'2232','342',256626.40,256626.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','180190',3540070,'2231','342',205512.82,207444.02,0.00,0.00,1931.20,648942.40,0.00,0.00,0.00),('1','142','799','180190',3540071,'2232','342',256626.40,256626.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','180342',3542811,'2231','342',207444.02,208232.98,0.00,0.00,788.96,262886.00,0.00,0.00,0.00),('1','142','799','180342',3542812,'2232','342',256626.40,256626.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','180410',3544086,'2231','342',208232.98,208232.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','180410',3544087,'2232','342',256626.40,260246.47,0.00,0.00,3620.07,1193933.12,0.00,0.00,0.00),('1','142','798','180554',3546703,'2231','342',208232.98,208232.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','180554',3546704,'2232','342',260246.47,266174.55,0.00,0.00,5928.08,1929995.26,0.00,0.00,0.00),('1','142','798','180767',3550526,'2231','342',208232.98,208232.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','180767',3550527,'2232','342',266174.55,269190.45,0.00,0.00,3015.90,997350.16,0.00,0.00,0.00),('1','142','798','180968',3554459,'2231','342',208232.98,208232.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','180968',3554460,'2232','342',269190.45,270447.93,0.00,0.00,1257.48,434496.96,0.00,0.00,0.00),('1','142','798','181137',3557673,'2231','342',208232.98,208232.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','181137',3557674,'2232','342',270447.93,272035.55,0.00,0.00,1587.62,533002.24,0.00,0.00,0.00),('1','142','798','181338',3561730,'2231','342',208232.98,208232.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','181338',3561731,'2232','342',272035.55,276428.84,0.00,0.00,4393.29,1454052.96,0.00,0.00,0.00),('1','142','798','181471',3564207,'2231','342',208232.98,210410.65,0.00,0.00,2177.67,711093.04,0.00,0.00,0.00),('1','142','799','181471',3564208,'2232','342',276428.84,276428.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','181530',3565106,'2231','342',210410.65,214559.68,0.00,0.00,4149.03,1379396.68,0.00,0.00,0.00),('1','142','799','181530',3565107,'2232','342',276428.84,276428.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','181714',3568203,'2231','342',214559.68,217206.13,0.00,0.00,2646.45,884922.48,0.00,0.00,0.00),('1','142','799','181714',3568204,'2232','342',276428.84,276428.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','181913',3571639,'2231','342',217206.13,220551.91,0.00,0.00,3345.78,1106359.20,0.00,0.00,0.00),('1','142','799','181913',3571640,'2232','342',276428.84,276428.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','182117',3575555,'2231','342',220551.91,223211.66,0.00,0.00,2659.75,903272.00,0.00,0.00,0.00),('1','142','799','182117',3575556,'2232','342',276428.84,276428.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','182319',3578977,'2231','342',223211.66,225085.19,0.00,0.00,1873.53,623355.06,0.00,0.00,0.00),('1','142','799','182319',3578978,'2232','342',276428.84,276428.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','182533',3582840,'2231','342',225085.19,233019.00,0.00,0.00,7933.81,2590785.38,0.00,0.00,0.00),('1','142','799','182533',3582841,'2232','342',276428.84,276428.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','182667',3585644,'2231','342',233019.00,233019.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','182667',3585645,'2232','342',276428.84,278953.29,0.00,0.00,2524.45,837320.92,0.00,0.00,0.00),('1','142','798','182695',3585935,'2231','342',233019.00,233019.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','182695',3585936,'2232','342',278953.29,281153.76,0.00,0.00,2200.47,771892.20,0.00,0.00,0.00),('1','142','798','182850',3588898,'2231','342',233019.00,233019.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','182850',3588899,'2232','342',281153.76,283810.72,0.00,0.00,2656.96,919885.60,0.00,0.00,0.00),('1','142','798','182990',3591454,'2231','342',233019.00,233019.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','182990',3591455,'2232','342',283810.72,287786.65,0.00,0.00,3975.93,1359520.80,0.00,0.00,0.00),('1','142','798','183216',3595634,'2231','342',233019.00,233019.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','183216',3595635,'2232','342',287786.65,289311.91,0.00,0.00,1525.26,533012.60,0.00,0.00,0.00),('1','142','798','183436',3599459,'2231','342',233019.00,233019.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','183436',3599460,'2232','342',289311.91,290906.18,0.00,0.00,1594.27,557942.20,0.00,0.00,0.00),('1','142','798','183653',3603390,'2231','342',233019.00,233019.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','183653',3603391,'2232','342',290906.18,290906.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','183654',3603392,'2231','342',233019.00,233019.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','183654',3603393,'2232','342',290906.18,294175.87,0.00,0.00,3269.69,1121068.40,0.00,0.00,0.00),('1','142','798','183912',3608267,'2231','342',233019.00,233019.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','183912',3608268,'2232','342',294175.87,295659.95,0.00,0.00,1484.08,519664.20,0.00,0.00,0.00),('1','142','798','184104',3611680,'2231','342',233019.00,233019.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','184104',3611681,'2232','342',295659.95,297275.53,0.00,0.00,1615.58,562848.80,0.00,0.00,0.00),('1','142','798','184286',3614852,'2231','342',233019.00,233019.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','184286',3614853,'2232','342',297275.53,298809.97,0.00,0.00,1534.44,534943.80,0.00,0.00,0.00),('1','142','798','184478',3618192,'2231','342',233019.00,233019.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','184478',3618193,'2232','342',298809.97,300188.62,0.00,0.00,1378.65,476864.00,0.00,0.00,0.00),('1','142','798','184706',3622379,'2231','342',233019.00,233019.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','184706',3622380,'2232','342',300188.62,301305.92,0.00,0.00,1117.30,389928.30,0.00,0.00,0.00),('1','142','798','184843',3625041,'2231','342',233019.00,234307.89,0.00,0.00,1288.89,432459.90,0.00,0.00,0.00),('1','142','799','184843',3625042,'2232','342',301305.92,301305.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','184906',3626003,'2231','342',234307.89,235219.01,0.00,0.00,911.12,321823.20,0.00,0.00,0.00),('1','142','799','184906',3626004,'2232','342',301305.92,301305.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','185119',3629621,'2231','342',235219.01,237774.67,0.00,0.00,2555.66,858300.60,0.00,0.00,0.00),('1','142','799','185119',3629622,'2232','342',301305.92,301305.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','185268',3631973,'2231','342',237774.67,241545.87,0.00,0.00,3771.20,1259922.00,0.00,0.00,0.00),('1','142','799','185268',3631974,'2232','342',301305.92,301305.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','185471',3635815,'2231','342',241545.87,245219.16,0.00,0.00,3673.29,1229135.70,0.00,0.00,0.00),('1','142','799','185471',3635816,'2232','342',301305.92,301305.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','185688',3639700,'2231','342',245219.16,246692.88,0.00,0.00,1473.72,507300.80,0.00,0.00,0.00),('1','142','799','185688',3639701,'2232','342',301305.92,301305.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','185886',3643241,'2231','342',246692.88,250795.18,0.00,0.00,4102.30,1363776.90,0.00,0.00,0.00),('1','142','799','185886',3643242,'2232','342',301305.92,301305.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','186098',3647111,'2231','342',250795.18,251471.84,0.00,0.00,676.66,238143.00,0.00,0.00,0.00),('1','142','799','186098',3647112,'2232','342',301305.92,301305.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','186333',3650895,'2231','342',251471.84,254779.29,0.00,0.00,3307.45,1110289.40,0.00,0.00,0.00),('1','142','799','186333',3650896,'2232','342',301305.92,301305.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','186541',3654469,'2231','342',254779.29,255749.53,0.00,0.00,970.24,337286.40,0.00,0.00,0.00),('1','142','799','186541',3654470,'2232','342',301305.92,301305.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','186759',3658210,'2231','342',255749.53,257621.56,0.00,0.00,1872.03,631038.20,0.00,0.00,0.00),('1','142','799','186759',3658211,'2232','342',301305.92,301305.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','187002',3662237,'2231','342',257621.56,257773.30,0.00,0.00,151.74,54626.40,0.00,0.00,0.00),('1','142','799','187002',3662238,'2232','342',301305.92,301305.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','187026',3662554,'2231','342',257773.30,257773.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','187026',3662555,'2232','342',301305.92,303491.80,0.00,0.00,2185.88,733622.30,0.00,0.00,0.00),('1','142','798','187176',3665194,'2231','342',257773.30,257773.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','187176',3665195,'2232','342',303491.80,304992.54,0.00,0.00,1500.74,514733.60,0.00,0.00,0.00),('1','142','798','187380',3668912,'2231','342',257773.30,260732.21,0.00,0.00,2958.91,991212.30,0.00,0.00,0.00),('1','142','799','187380',3668913,'2232','342',304992.54,304992.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','187587',3672600,'2231','342',260732.21,264179.78,0.00,0.00,3447.57,1168824.50,0.00,0.00,0.00),('1','142','799','187587',3672601,'2232','342',304992.54,304992.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','187816',3676679,'2231','342',264179.78,267139.23,0.00,0.00,2959.45,1017281.20,0.00,0.00,0.00),('1','142','799','187816',3676680,'2232','342',304992.54,304992.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','188023',3680303,'2231','342',267139.23,274988.32,0.00,0.00,7849.09,2615681.10,0.00,0.00,0.00),('1','142','799','188023',3680304,'2232','342',304992.54,304992.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','188239',3683975,'2231','342',274988.32,278408.90,0.00,0.00,3420.58,1156864.20,0.00,0.00,0.00),('1','142','799','188239',3683976,'2232','342',304992.54,304992.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','188437',3687341,'2231','342',278408.90,281380.47,0.00,0.00,2971.57,1001098.20,0.00,0.00,0.00),('1','142','799','188437',3687342,'2232','342',304992.54,304992.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','188539',3689294,'2231','342',281380.47,281380.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','188539',3689295,'2232','342',304992.54,305490.10,0.00,0.00,497.56,169839.90,0.00,0.00,0.00),('1','142','798','188615',3690490,'2231','342',281380.47,281380.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','188615',3690491,'2232','342',305490.10,306870.57,0.00,0.00,1380.47,480550.20,0.00,0.00,0.00),('1','142','798','188834',3694332,'2231','342',281380.47,281380.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','188834',3694333,'2232','342',306870.57,311453.56,0.00,0.00,4582.99,1531426.40,0.00,0.00,0.00),('1','142','798','189085',3698861,'2231','342',281380.47,281380.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','189085',3698862,'2232','342',311453.56,313678.55,0.00,0.00,2224.99,759186.40,0.00,0.00,0.00),('1','142','798','189218',3701173,'2231','342',281380.47,281380.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','189218',3701174,'2232','342',313678.55,317452.81,0.00,0.00,3774.26,1268813.60,0.00,0.00,0.00),('1','142','798','189426',3705121,'2231','342',281380.47,281380.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','189426',3705122,'2232','342',317452.81,321583.23,0.00,0.00,4130.42,1356251.20,0.00,0.00,0.00),('1','142','798','189643',3708775,'2231','342',281380.47,281380.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','189643',3708776,'2232','342',321583.23,325315.31,0.00,0.00,3732.08,1257998.80,0.00,0.00,0.00),('1','142','798','189840',3712236,'2231','342',281380.47,281380.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','189840',3712237,'2232','342',325315.31,327685.68,0.00,0.00,2370.37,810056.20,0.00,0.00,0.00),('1','142','798','190036',3716262,'2231','342',281380.47,281380.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','190036',3716263,'2232','342',327685.68,330396.99,0.00,0.00,2711.31,921364.60,0.00,0.00,0.00),('1','142','798','190227',3719856,'2231','342',281380.47,281380.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','190227',3719857,'2232','342',330396.99,336791.18,0.00,0.00,6394.19,2146315.80,0.00,0.00,0.00),('1','142','798','190440',3723827,'2231','342',281380.47,281380.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','190440',3723828,'2232','342',336791.18,341202.69,0.00,0.00,4411.51,1462756.60,0.00,0.00,0.00),('1','142','798','190505',3724856,'2231','342',281380.47,283665.90,0.00,0.00,2285.43,786852.20,0.00,0.00,0.00),('1','142','799','190505',3724857,'2232','342',341202.69,341202.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','190676',3728188,'2231','342',283665.90,290006.70,0.00,0.00,6340.80,2118539.20,0.00,0.00,0.00),('1','142','799','190676',3728189,'2232','342',341202.69,341202.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','190909',3732387,'2231','342',290006.70,292919.73,0.00,0.00,2913.03,970111.40,0.00,0.00,0.00),('1','142','799','190909',3732388,'2232','342',341202.69,341202.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','191096',3735686,'2231','342',292919.73,294667.78,0.00,0.00,1748.05,591858.00,0.00,0.00,0.00),('1','142','799','191096',3735687,'2232','342',341202.69,341202.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','191327',3739664,'2231','342',294667.78,296856.41,0.00,0.00,2188.63,734726.80,0.00,0.00,0.00),('1','142','799','191327',3739665,'2232','342',341202.69,341202.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','191531',3743359,'2231','342',296856.41,299096.04,0.00,0.00,2239.63,751461.80,0.00,0.00,0.00),('1','142','799','191531',3743360,'2232','342',341202.69,341202.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','191729',3747376,'2231','342',299096.04,302888.32,0.00,0.00,3792.28,1272026.80,0.00,0.00,0.00),('1','142','799','191729',3747377,'2232','342',341202.69,341202.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','191943',3751643,'2231','342',302888.32,305327.65,0.00,0.00,2439.33,818985.80,0.00,0.00,0.00),('1','142','799','191943',3751644,'2232','342',341202.69,341202.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','192158',3755336,'2231','342',305327.65,306081.33,0.00,0.00,753.68,254005.80,0.00,0.00,0.00),('1','142','799','192158',3755337,'2232','342',341202.69,341202.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','192222',3756537,'2231','342',306081.33,306081.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','192222',3756538,'2232','342',341202.69,344452.88,0.00,0.00,3250.19,1079987.40,0.00,0.00,0.00),('1','142','798','192356',3759038,'2231','342',306081.33,306081.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','192356',3759039,'2232','342',344452.88,347136.51,0.00,0.00,2683.63,900747.80,0.00,0.00,0.00),('1','142','798','192587',3763123,'2231','342',306081.33,306081.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','192587',3763124,'2232','342',347136.51,348653.63,0.00,0.00,1517.12,513193.20,0.00,0.00,0.00),('1','142','798','192763',3766337,'2231','342',306081.33,306081.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','192763',3766338,'2232','342',348653.63,351119.53,0.00,0.00,2465.90,828449.00,0.00,0.00,0.00),('1','142','798','192960',3769962,'2231','342',306081.33,306081.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','192960',3769963,'2232','342',351119.53,353667.01,0.00,0.00,2547.48,853342.80,0.00,0.00,0.00),('1','142','798','193176',3774075,'2231','342',306081.33,306081.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','193176',3774076,'2232','342',353667.01,354580.71,0.00,0.00,913.70,314813.00,0.00,0.00,0.00),('1','142','798','193420',3778924,'2231','342',306081.33,306081.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','193420',3778925,'2232','342',354580.71,355703.09,0.00,0.00,1122.38,382966.80,0.00,0.00,0.00),('1','142','798','193633',3782923,'2231','342',306081.33,306081.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','193633',3782924,'2232','342',355703.09,362819.47,0.00,0.00,7116.38,2366211.80,0.00,0.00,0.00),('1','142','798','193866',3787017,'2231','342',306081.33,306081.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','193866',3787018,'2232','342',362819.47,365507.39,0.00,0.00,2687.92,903666.60,0.00,0.00,0.00),('1','142','798','194094',3791014,'2231','342',306081.33,306081.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','194094',3791015,'2232','342',365507.39,365957.44,0.00,0.00,450.05,149181.60,0.00,0.00,0.00),('1','142','798','194113',3791247,'2231','342',306081.33,309342.66,0.00,0.00,3261.33,1085092.50,0.00,0.00,0.00),('1','142','799','194113',3791248,'2232','342',365957.44,365957.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','194298',3794890,'2231','342',309342.66,310711.11,0.00,0.00,1368.45,467339.00,0.00,0.00,0.00),('1','142','799','194298',3794891,'2232','342',365957.44,365957.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','194493',3798366,'2231','342',310711.11,314413.30,0.00,0.00,3702.19,1228958.85,0.00,0.00,0.00),('1','142','799','194493',3798367,'2232','342',365957.44,365957.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','194714',3802253,'2231','342',314413.30,318462.98,0.00,0.00,4049.68,1354029.80,0.00,0.00,0.00),('1','142','799','194714',3802254,'2232','342',365957.44,365957.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','194945',3807074,'2231','342',318462.98,321693.12,0.00,0.00,3230.14,1085436.40,0.00,0.00,0.00),('1','142','799','194945',3807075,'2232','342',365957.44,365957.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','195091',3809482,'2231','342',321693.12,327496.53,0.00,0.00,5803.41,1915797.60,0.00,0.00,0.00),('1','142','799','195091',3809483,'2232','342',365957.44,365957.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','195311',3813417,'2231','342',327496.53,328801.17,0.00,0.00,1304.64,450493.20,0.00,0.00,0.00),('1','142','799','195311',3813418,'2232','342',365957.44,365957.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','195544',3817464,'2231','342',328801.17,330548.22,0.00,0.00,1747.05,600338.00,0.00,0.00,0.00),('1','142','799','195544',3817465,'2232','342',365957.44,365957.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','195794',3821559,'2231','342',330548.22,330599.72,0.00,0.00,51.50,18540.00,0.00,0.00,0.00),('1','142','799','195794',3821560,'2232','342',365957.44,365957.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','195812',3821952,'2231','342',330599.72,331349.72,0.00,0.00,750.00,246000.00,0.00,0.00,0.00),('1','142','799','195812',3821953,'2232','342',365957.44,368586.79,0.00,0.00,2629.35,876036.00,0.00,0.00,0.00),('1','142','798','196015',3825748,'2231','342',331349.72,331349.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','196015',3825749,'2232','342',368586.79,370370.34,0.00,0.00,1783.55,607643.00,0.00,0.00,0.00),('1','142','798','196240',3830050,'2231','342',331349.72,331349.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','196240',3830051,'2232','342',370370.34,372773.68,0.00,0.00,2403.34,813792.40,0.00,0.00,0.00),('1','142','798','196470',3834079,'2231','342',331349.72,331349.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','196470',3834080,'2232','342',372773.68,378681.33,0.00,0.00,5907.65,1964729.00,0.00,0.00,0.00),('1','142','798','196672',3837756,'2231','342',331349.72,331349.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','196672',3837757,'2232','342',378681.33,384157.01,0.00,0.00,5475.68,1841074.80,0.00,0.00,0.00),('1','142','798','196889',3841648,'2231','342',331349.72,331349.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','196889',3841649,'2232','342',384157.01,384973.67,0.00,0.00,816.66,277632.30,0.00,0.00,0.00),('1','142','798','197056',3844574,'2231','342',331349.72,331349.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','197056',3844575,'2232','342',384973.67,386857.86,0.00,0.00,1884.19,633804.00,0.00,0.00,0.00),('1','142','798','197334',3850024,'2231','342',331349.72,331349.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','197334',3850025,'2232','342',386857.86,389925.18,0.00,0.00,3067.32,1039293.60,0.00,0.00,0.00),('1','142','798','197340',3850100,'2231','342',331349.72,334221.00,0.00,0.00,2871.28,964219.40,0.00,0.00,0.00),('1','142','799','197340',3850101,'2232','342',389925.18,389925.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','197521',3852517,'2231','342',334221.00,339377.61,0.00,0.00,5156.61,1721184.20,0.00,0.00,0.00),('1','142','799','197521',3852518,'2232','342',389925.18,389925.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','197894',3859109,'2231','342',339377.61,341224.37,0.00,0.00,1846.76,626558.50,0.00,0.00,0.00),('1','142','799','197894',3859110,'2232','342',389925.18,389925.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','198128',3863217,'2231','342',341224.37,344470.34,0.00,0.00,3245.97,1087140.20,0.00,0.00,0.00),('1','142','799','198128',3863218,'2232','342',389925.18,389925.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','198367',3867234,'2231','342',344470.34,347153.43,0.00,0.00,2683.09,907013.40,0.00,0.00,0.00),('1','142','799','198367',3867235,'2232','342',389925.18,389925.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','198590',3871060,'2231','342',347153.43,350614.34,0.00,0.00,3460.91,1162724.10,0.00,0.00,0.00),('1','142','799','198590',3871061,'2232','342',389925.18,389925.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','198795',3874498,'2231','342',350614.34,352714.90,0.00,0.00,2100.56,716181.60,0.00,0.00,0.00),('1','142','799','198795',3874499,'2232','342',389925.18,389925.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','198985',3877920,'2231','342',352714.90,356254.28,0.00,0.00,3539.38,1177736.80,0.00,0.00,0.00),('1','142','799','198985',3877921,'2232','342',389925.18,389925.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','199143',3881028,'2231','342',356254.28,356254.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','199143',3881029,'2232','342',389925.18,391122.74,0.00,0.00,1197.56,402211.60,0.00,0.00,0.00),('1','142','798','199225',3882109,'2231','342',356254.28,356254.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','199225',3882110,'2232','342',391122.74,393185.28,0.00,0.00,2062.54,699854.40,0.00,0.00,0.00),('1','142','798','199452',3885649,'2231','342',356254.28,356254.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','199452',3885650,'2232','342',393185.28,397504.87,0.00,0.00,4319.59,1438452.40,0.00,0.00,0.00),('1','142','798','199664',3889333,'2231','342',356254.28,356254.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','199664',3889334,'2232','342',397504.87,400629.67,0.00,0.00,3124.80,1055347.40,0.00,0.00,0.00),('1','142','798','199883',3892697,'2231','342',356254.28,356254.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','199883',3892698,'2232','342',400629.67,402851.97,0.00,0.00,2222.30,763878.00,0.00,0.00,0.00),('1','142','798','200104',3896848,'2231','342',356254.28,356254.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','200104',3896849,'2232','342',402851.97,409879.48,0.00,0.00,7027.51,2327609.20,0.00,0.00,0.00),('1','142','798','200304',3900322,'2231','342',356254.28,356254.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','200304',3900323,'2232','342',409879.48,411716.04,0.00,0.00,1836.56,636267.20,0.00,0.00,0.00),('1','142','798','200502',3904068,'2231','342',356254.28,356254.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','200502',3904069,'2232','342',411716.04,414569.24,0.00,0.00,2853.20,967027.60,0.00,0.00,0.00),('1','142','798','200714',3907791,'2231','342',356254.28,356254.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','200714',3907792,'2232','342',414569.24,414815.85,0.00,0.00,246.61,85779.60,0.00,0.00,0.00),('1','142','798','200728',3907974,'2231','342',356254.28,359118.95,0.00,0.00,2864.67,970741.20,0.00,0.00,0.00),('1','142','799','200728',3907975,'2232','342',414815.85,414820.85,0.00,0.00,5.00,1800.00,0.00,0.00,0.00),('1','142','798','200939',3911683,'2231','342',359118.95,363233.43,0.00,0.00,4114.48,1383772.80,0.00,0.00,0.00),('1','142','799','200939',3911684,'2232','342',414820.85,414820.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','201131',3914796,'2231','342',363233.43,368904.50,0.00,0.00,5671.07,1898723.10,0.00,0.00,0.00),('1','142','799','201131',3914797,'2232','342',414820.85,414820.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','201331',3918249,'2231','342',368904.50,371320.65,0.00,0.00,2416.15,826916.10,0.00,0.00,0.00),('1','142','799','201331',3918250,'2232','342',414820.85,414820.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','201512',3921609,'2231','342',371320.65,372911.34,0.00,0.00,1590.69,550938.40,0.00,0.00,0.00),('1','142','799','201512',3921610,'2232','342',414820.85,414820.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','201783',3926859,'2231','342',372911.34,375100.08,0.00,0.00,2188.74,749417.40,0.00,0.00,0.00),('1','142','799','201783',3926860,'2232','342',414820.85,414820.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','202044',3931763,'2231','342',375100.08,379963.24,0.00,0.00,4863.16,1682221.52,0.00,0.00,0.00),('1','142','799','202044',3931764,'2232','342',414820.85,414820.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','202266',3935427,'2231','342',379963.24,381010.28,0.00,0.00,1047.04,366991.54,0.00,0.00,0.00),('1','142','799','202266',3935428,'2232','342',414820.85,414820.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','202304',3936212,'2231','342',381010.28,381010.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','202304',3936213,'2232','342',414820.85,419547.24,0.00,0.00,4726.39,1646991.12,0.00,0.00,0.00),('1','142','798','202444',3938592,'2231','342',381010.28,381010.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','202444',3938593,'2232','342',419547.24,421116.58,0.00,0.00,1569.34,561747.88,0.00,0.00,0.00),('1','142','798','202663',3942408,'2231','342',381010.28,381010.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','202663',3942409,'2232','342',421116.58,425304.68,0.00,0.00,4188.10,1462353.54,0.00,0.00,0.00),('1','142','798','202879',3946231,'2231','342',381010.28,381010.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','202879',3946232,'2232','342',425304.68,428759.97,0.00,0.00,3455.29,1216191.54,0.00,0.00,0.00),('1','142','798','203127',3951035,'2231','342',381010.28,381010.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','203127',3951036,'2232','342',428759.97,431018.11,0.00,0.00,2258.14,799994.66,0.00,0.00,0.00),('1','142','798','203320',3954583,'2231','342',381010.28,381010.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','203320',3954584,'2232','342',431018.11,432448.73,0.00,0.00,1430.62,508801.62,0.00,0.00,0.00),('1','142','798','203537',3958458,'2231','342',381010.28,381010.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','203537',3958459,'2232','342',432448.73,434527.27,0.00,0.00,2078.54,737241.18,0.00,0.00,0.00),('1','142','798','203746',3962184,'2231','342',381010.28,381010.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','203746',3962185,'2232','342',434527.27,437081.02,0.00,0.00,2553.75,893592.72,0.00,0.00,0.00),('1','142','798','203983',3966289,'2231','342',381010.28,381010.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','203983',3966290,'2232','342',437081.02,439389.23,0.00,0.00,2308.21,810660.30,0.00,0.00,0.00),('1','142','798','204143',3969596,'2231','342',381010.28,382110.28,0.00,0.00,1100.00,378160.00,0.00,0.00,0.00),('1','142','799','204143',3969597,'2232','342',439389.23,439389.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','204206',3970513,'2231','342',382110.28,386547.44,0.00,0.00,4437.16,1537462.86,0.00,0.00,0.00),('1','142','799','204206',3970514,'2232','342',439389.23,439389.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','204421',3974276,'2231','342',386547.44,388231.21,0.00,0.00,1683.77,594693.56,0.00,0.00,0.00),('1','142','799','204421',3974277,'2232','342',439389.23,439389.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','204640',3978272,'2231','342',388231.21,389751.38,0.00,0.00,1520.17,542498.40,0.00,0.00,0.00),('1','142','799','204640',3978273,'2232','342',439389.23,439403.73,0.00,0.00,14.50,5336.00,0.00,0.00,0.00),('1','142','798','204857',3981828,'2231','342',389751.38,390993.44,0.00,0.00,1242.06,448827.78,0.00,0.00,0.00),('1','142','799','204857',3981829,'2232','342',439403.73,439403.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','205057',3985339,'2231','342',390993.44,394244.13,0.00,0.00,3250.69,1135173.04,0.00,0.00,0.00),('1','142','799','205057',3985340,'2232','342',439403.73,439403.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','205249',3988911,'2231','342',394244.13,398048.12,0.00,0.00,3803.99,1327261.64,0.00,0.00,0.00),('1','142','799','205249',3988912,'2232','342',439403.73,439403.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','205486',3993216,'2231','342',398048.12,399911.93,0.00,0.00,1863.81,661337.82,0.00,0.00,0.00),('1','142','799','205486',3993217,'2232','342',439403.73,439403.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','205745',3997871,'2231','342',399911.93,403362.71,0.00,0.00,3450.78,1207031.60,0.00,0.00,0.00),('1','142','799','205745',3997872,'2232','342',439403.73,439403.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','205965',4001822,'2231','342',403362.71,405120.18,0.00,0.00,1757.47,608461.04,0.00,0.00,0.00),('1','142','799','205965',4001823,'2232','342',439403.73,439403.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','205992',4002359,'2231','342',405120.18,405120.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','205992',4002360,'2232','342',439403.73,442553.60,0.00,0.00,3149.87,1100545.86,0.00,0.00,0.00),('1','142','798','206171',4005580,'2231','342',405120.18,405120.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','206171',4005581,'2232','342',442553.60,445872.31,0.00,0.00,3318.71,1169855.48,0.00,0.00,0.00),('1','142','798','206370',4008974,'2231','342',405120.18,405120.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','206370',4008975,'2232','342',445872.31,451141.82,0.00,0.00,5269.51,1836665.68,0.00,0.00,0.00),('1','142','798','206587',4012700,'2231','342',405120.18,405120.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','206587',4012701,'2232','342',451141.82,453582.72,0.00,0.00,2440.90,862459.00,0.00,0.00,0.00),('1','142','798','206840',4017132,'2231','342',405120.18,405120.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','206840',4017133,'2232','342',453582.72,456201.37,0.00,0.00,2618.65,917537.50,0.00,0.00,0.00),('1','142','798','207051',4020980,'2231','342',405120.18,405120.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','207051',4020981,'2232','342',456201.37,458116.41,0.00,0.00,1915.04,674423.72,0.00,0.00,0.00),('1','142','798','207273',4024974,'2231','342',405120.18,405120.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','207273',4024975,'2232','342',458116.41,462089.06,0.00,0.00,3972.65,1393787.12,0.00,0.00,0.00),('1','142','798','207617',4031203,'2231','342',405120.18,405120.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','207617',4031204,'2232','342',462089.06,463975.30,0.00,0.00,1886.24,667173.46,0.00,0.00,0.00),('1','142','798','208302',4043280,'2231','342',405120.18,405120.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','208302',4043281,'2232','342',463975.30,464103.30,0.00,0.00,128.00,47104.00,0.00,0.00,0.00),('1','142','798','208303',4043282,'2231','342',405120.18,405120.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','208303',4043283,'2232','342',464103.30,467770.20,0.00,0.00,3666.90,1333847.00,0.00,0.00,0.00),('1','142','798','208305',4043294,'2231','342',405120.18,410200.98,0.00,0.00,5080.80,1825929.00,0.00,0.00,0.00),('1','142','799','208305',4043295,'2232','342',467770.20,467770.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','208306',4043296,'2231','342',410200.98,413666.58,0.00,0.00,3465.60,1252706.00,0.00,0.00,0.00),('1','142','799','208306',4043297,'2232','342',467770.20,467770.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','208352',4043914,'2231','342',413666.58,416026.04,0.00,0.00,2359.46,861079.05,0.00,0.00,0.00),('1','142','799','208352',4043915,'2232','342',467770.20,467770.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','208579',4047818,'2231','342',416026.04,419538.62,0.00,0.00,3512.58,1253480.40,0.00,0.00,0.00),('1','142','799','208579',4047819,'2232','342',467770.20,467770.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','208772',4051211,'2231','342',419538.62,421939.72,0.00,0.00,2401.10,860902.05,0.00,0.00,0.00),('1','142','799','208772',4051212,'2232','342',467770.20,467770.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','209011',4055257,'2231','342',421939.72,426089.28,0.00,0.00,4149.56,1566483.08,0.00,0.00,0.00),('1','142','799','209011',4055258,'2232','342',467770.20,467770.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','209147',4057712,'2231','342',426089.28,426089.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','209147',4057713,'2232','342',467770.20,468840.55,0.00,0.00,1070.35,405900.00,0.00,0.00,0.00),('1','142','798','209233',4059168,'2231','342',426089.28,426091.78,0.00,0.00,2.50,1000.00,0.00,0.00,0.00),('1','142','799','209233',4059169,'2232','342',468840.55,472059.91,0.00,0.00,3219.36,1222553.36,0.00,0.00,0.00),('1','142','798','209453',4063071,'2231','342',426091.78,426091.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','209453',4063072,'2232','342',472059.91,475346.35,0.00,0.00,3286.44,1258020.80,0.00,0.00,0.00),('1','142','798','209655',4066730,'2231','342',426091.78,426091.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','209655',4066731,'2232','342',475346.35,479791.10,0.00,0.00,4444.75,1678965.12,0.00,0.00,0.00),('1','142','798','209881',4070661,'2231','342',426091.78,426091.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','209881',4070662,'2232','342',479791.10,482693.64,0.00,0.00,2902.54,1137699.88,0.00,0.00,0.00),('1','142','798','210114',4074860,'2231','342',426091.78,426091.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','210114',4074861,'2232','342',482693.64,485801.32,0.00,0.00,3107.68,1219472.60,0.00,0.00,0.00),('1','142','798','210324',4078570,'2231','342',426091.78,426091.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','210324',4078571,'2232','342',485801.32,487068.33,0.00,0.00,1267.01,521740.26,0.00,0.00,0.00),('1','142','798','210525',4082298,'2231','342',426091.78,426091.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','210525',4082299,'2232','342',487068.33,489730.64,0.00,0.00,2662.31,1035848.20,0.00,0.00,0.00),('1','142','798','210742',4086105,'2231','342',426091.78,426091.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','210742',4086106,'2232','342',489730.64,491226.64,0.00,0.00,1496.00,577510.56,0.00,0.00,0.00),('1','142','798','210809',4087268,'2231','342',426091.78,428098.31,0.00,0.00,2006.53,808257.12,0.00,0.00,0.00),('1','142','799','210809',4087269,'2232','342',491226.64,491231.64,0.00,0.00,5.00,2100.00,0.00,0.00,0.00),('1','142','798','210977',4089982,'2231','342',428098.31,433765.40,0.00,0.00,5667.09,2188547.00,0.00,0.00,0.00),('1','142','799','210977',4089983,'2232','342',491231.64,491231.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','211185',4093728,'2231','342',433765.40,440386.35,0.00,0.00,6620.95,2580466.72,0.00,0.00,0.00),('1','142','799','211185',4093729,'2232','342',491231.64,491231.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','211397',4097581,'2231','342',440386.35,449327.46,0.00,0.00,8941.11,3554135.00,0.00,0.00,0.00),('1','142','799','211397',4097582,'2232','342',491231.64,491231.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','211614',4101399,'2231','342',449327.46,450846.41,0.00,0.00,1518.95,600230.20,0.00,0.00,0.00),('1','142','799','211614',4101400,'2232','342',491231.64,491231.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','211663',4102203,'2231','342',450846.41,450846.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','211663',4102204,'2232','342',491231.64,491788.85,0.00,0.00,557.21,223386.64,0.00,0.00,0.00),('1','142','798','211803',4104448,'2231','342',450846.41,450846.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','211803',4104449,'2232','342',491788.85,493564.25,0.00,0.00,1775.40,712416.60,0.00,0.00,0.00),('1','142','798','212009',4108149,'2231','342',450846.41,450846.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','212009',4108150,'2232','342',493564.25,497739.56,0.00,0.00,4175.31,1665104.44,0.00,0.00,0.00),('1','142','798','212252',4112415,'2231','342',450846.41,450846.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','212252',4112416,'2232','342',497739.56,500241.94,0.00,0.00,2502.38,1005846.10,0.00,0.00,0.00),('1','142','798','212476',4116550,'2231','342',450846.41,450846.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','212476',4116551,'2232','342',500241.94,504637.47,0.00,0.00,4395.53,1759691.73,0.00,0.00,0.00),('1','142','798','212682',4120247,'2231','342',450846.41,450846.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','212682',4120248,'2232','342',504637.47,508092.44,0.00,0.00,3454.97,1387390.38,0.00,0.00,0.00),('1','142','798','212895',4123973,'2231','342',450846.41,450846.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','212895',4123974,'2232','342',508092.44,510802.66,0.00,0.00,2710.22,1092812.10,0.00,0.00,0.00),('1','142','798','213157',4128494,'2231','342',450846.41,450846.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','213157',4128495,'2232','342',510802.66,515659.91,0.00,0.00,4857.25,1933137.00,0.00,0.00,0.00),('1','142','798','213413',4132664,'2231','342',450846.41,450846.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','213413',4132665,'2232','342',515659.91,517149.67,0.00,0.00,1489.76,605322.56,0.00,0.00,0.00),('1','142','798','213589',4135696,'2231','342',450846.41,456616.36,0.00,0.00,5769.95,2324887.95,0.00,0.00,0.00),('1','142','799','213589',4135697,'2232','342',517149.67,517149.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','213657',4136771,'2231','342',456616.36,460029.92,0.00,0.00,3413.56,1403363.25,0.00,0.00,0.00),('1','142','799','213657',4136772,'2232','342',517149.67,517149.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','213906',4140833,'2231','342',460029.92,461822.68,0.00,0.00,1792.76,737480.29,0.00,0.00,0.00),('1','142','799','213906',4140834,'2232','342',517149.67,517149.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','214113',4144319,'2231','342',461822.68,468597.24,0.00,0.00,6774.56,2735800.22,0.00,0.00,0.00),('1','142','799','214113',4144320,'2232','342',517149.67,517149.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','214361',4148622,'2231','342',468597.24,475530.11,0.00,0.00,6932.87,2756924.97,0.00,0.00,0.00),('1','142','799','214361',4148623,'2232','342',517149.67,517149.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','214544',4151727,'2231','342',475530.11,475530.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','214544',4151728,'2232','342',517149.67,520686.53,0.00,0.00,3536.86,1451760.43,0.00,0.00,0.00),('1','142','798','214821',4156606,'2231','342',475530.11,475530.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','214821',4156607,'2232','342',520686.53,526546.51,0.00,0.00,5859.98,2363725.77,0.00,0.00,0.00),('1','142','798','215033',4160041,'2231','342',475530.11,475530.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','215033',4160042,'2232','342',526546.51,531133.52,0.00,0.00,4587.01,1857280.31,0.00,0.00,0.00),('1','142','798','215240',4163646,'2231','342',475530.11,475530.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','215240',4163647,'2232','342',531133.52,536396.91,0.00,0.00,5263.39,2135987.53,0.00,0.00,0.00),('1','142','798','215457',4167175,'2231','342',475530.11,475530.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','215457',4167176,'2232','342',536396.91,541435.50,0.00,0.00,5038.59,2013637.43,0.00,0.00,0.00),('1','142','798','215692',4171261,'2231','342',475530.11,477556.21,0.00,0.00,2026.10,827842.10,0.00,0.00,0.00),('1','142','799','215692',4171262,'2232','342',541435.50,541435.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','215695',4171302,'2231','342',477556.21,480383.25,0.00,0.00,2827.04,1172055.27,0.00,0.00,0.00),('1','142','799','215695',4171303,'2232','342',541435.50,541435.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','215927',4175326,'2231','342',480383.25,482238.14,0.00,0.00,1854.89,772364.19,0.00,0.00,0.00),('1','142','799','215927',4175327,'2232','342',541435.50,541435.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','216122',4178678,'2231','342',482238.14,484557.70,0.00,0.00,2319.56,982883.36,0.00,0.00,0.00),('1','142','799','216122',4178679,'2232','342',541435.50,541435.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','216349',4182599,'2231','342',484557.70,490050.46,0.00,0.00,5492.76,2304400.49,0.00,0.00,0.00),('1','142','799','216349',4182600,'2232','342',541435.50,541435.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','216736',4189622,'2231','342',490050.46,490327.96,0.00,0.00,277.50,120665.00,0.00,0.00,0.00),('1','142','799','216736',4189623,'2232','342',541435.50,541435.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','216803',4190651,'2231','342',490327.96,495373.19,0.00,0.00,5045.23,2126415.93,0.00,0.00,0.00),('1','142','799','216803',4190652,'2232','342',541435.50,541435.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','217056',4194932,'2231','342',495373.19,499880.50,0.00,0.00,4507.31,1925842.80,0.00,0.00,0.00),('1','142','799','217056',4194933,'2232','342',541435.50,541435.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','217211',4198176,'2231','342',499880.50,499880.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','217211',4198177,'2232','342',541435.50,541830.42,0.00,0.00,394.92,181281.60,0.00,0.00,0.00),('1','142','798','217304',4199713,'2231','342',499880.50,499880.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','217304',4199714,'2232','342',541830.42,544725.15,0.00,0.00,2894.73,1306404.80,0.00,0.00,0.00),('1','142','798','217517',4203384,'2231','342',499880.50,499880.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','217517',4203385,'2232','342',544725.15,547777.89,0.00,0.00,3052.74,1378959.20,0.00,0.00,0.00),('1','142','798','217760',4207503,'2231','342',499880.50,499880.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','217760',4207504,'2232','342',547777.89,550856.15,0.00,0.00,3078.26,1403157.60,0.00,0.00,0.00),('1','142','798','217990',4211791,'2231','342',499880.50,499880.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','217990',4211792,'2232','342',550856.15,553659.18,0.00,0.00,2803.03,1265696.40,0.00,0.00,0.00),('1','142','798','218243',4216076,'2231','342',499880.50,499880.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','218243',4216077,'2232','342',553659.18,555860.71,0.00,0.00,2201.53,1003626.40,0.00,0.00,0.00),('1','142','798','218488',4220335,'2231','342',499880.50,499880.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','218488',4220336,'2232','342',555860.71,558802.59,0.00,0.00,2941.88,1326673.60,0.00,0.00,0.00),('1','142','798','218703',4224237,'2231','342',499880.50,499880.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','218703',4224238,'2232','342',558802.59,562855.57,0.00,0.00,4052.98,1817263.20,0.00,0.00,0.00),('1','142','798','218928',4228227,'2231','342',499880.50,499880.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','218928',4228228,'2232','342',562855.57,565936.06,0.00,0.00,3080.49,1396420.80,0.00,0.00,0.00),('1','142','798','219140',4231813,'2231','342',499880.50,499880.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','219140',4231814,'2232','342',565936.06,566742.36,0.00,0.00,806.30,353858.10,0.00,0.00,0.00),('1','142','798','219144',4231867,'2231','342',499880.50,502091.95,0.00,0.00,2211.45,1008519.70,0.00,0.00,0.00),('1','142','799','219144',4231868,'2232','342',566742.36,566742.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','219382',4235933,'2231','342',502091.95,504314.11,0.00,0.00,2222.16,1010863.60,0.00,0.00,0.00),('1','142','799','219382',4235934,'2232','342',566742.36,566742.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','219632',4240260,'2231','342',504314.11,505780.08,0.00,0.00,1465.97,678365.60,0.00,0.00,0.00),('1','142','799','219632',4240261,'2232','342',566742.36,566742.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','219835',4243999,'2231','342',505780.08,508025.24,0.00,0.00,2245.16,1020138.40,0.00,0.00,0.00),('1','142','799','219835',4244000,'2232','342',566742.36,566742.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','220073',4248300,'2231','342',508025.24,513424.49,0.00,0.00,5399.25,2416150.80,0.00,0.00,0.00),('1','142','799','220073',4248301,'2232','342',566742.36,566744.44,0.00,0.00,2.08,998.40,0.00,0.00,0.00),('1','142','798','220269',4251695,'2231','342',513424.49,515768.36,0.00,0.00,2343.87,1081259.20,0.00,0.00,0.00),('1','142','799','220269',4251696,'2232','342',566744.44,566744.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','220478',4255643,'2231','342',515768.36,519173.23,0.00,0.00,3404.87,1545123.60,0.00,0.00,0.00),('1','142','799','220478',4255644,'2232','342',566744.44,566744.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','220702',4259444,'2231','342',519173.23,521369.59,0.00,0.00,2196.36,1007628.80,0.00,0.00,0.00),('1','142','799','220702',4259445,'2232','342',566744.44,566744.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','220931',4263499,'2231','342',521369.59,524342.86,0.00,0.00,2973.27,1315885.60,0.00,0.00,0.00),('1','142','799','220931',4263500,'2232','342',566744.44,566744.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','221004',4264831,'2231','342',524342.86,524342.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','221004',4264832,'2232','342',566744.44,568745.89,0.00,0.00,2001.45,913000.00,0.00,0.00,0.00),('1','142','798','221167',4267629,'2231','342',524342.86,524344.94,0.00,0.00,2.08,998.40,0.00,0.00,0.00),('1','142','799','221167',4267630,'2232','342',568745.89,573247.33,0.00,0.00,4501.44,2014423.60,0.00,0.00,0.00),('1','142','798','221400',4271885,'2231','342',524344.94,524344.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','221400',4271886,'2232','342',573247.33,579291.38,0.00,0.00,6044.05,2711075.60,0.00,0.00,0.00),('1','142','798','221669',4276856,'2231','342',524344.94,524344.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','221669',4276857,'2232','342',579291.38,582612.75,0.00,0.00,3321.37,1508216.60,0.00,0.00,0.00),('1','142','798','221845',4279890,'2231','342',524344.94,524344.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','221845',4279891,'2232','342',582612.75,588113.01,0.00,0.00,5500.26,2470905.90,0.00,0.00,0.00),('1','142','798','222080',4284228,'2231','342',524344.94,524344.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','222080',4284229,'2232','342',588113.01,591413.06,0.00,0.00,3300.05,1489399.20,0.00,0.00,0.00),('1','142','798','222195',4286266,'2231','342',524344.94,526429.16,0.00,0.00,2084.22,921822.60,0.00,0.00,0.00),('1','142','799','222195',4286267,'2232','342',591413.06,591419.06,0.00,0.00,6.00,2880.00,0.00,0.00,0.00),('1','142','798','222292',4287719,'2231','342',526429.16,528649.77,0.00,0.00,2220.61,1016487.20,0.00,0.00,0.00),('1','142','799','222292',4287720,'2232','342',591419.06,591419.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','222525',4291702,'2231','342',528649.77,530459.25,0.00,0.00,1809.48,833094.40,0.00,0.00,0.00),('1','142','799','222525',4291703,'2232','342',591419.06,591419.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','222783',4296471,'2231','342',530459.25,530577.72,0.00,0.00,118.47,56865.60,0.00,0.00,0.00),('1','142','799','222783',4296472,'2232','342',591419.06,591419.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','222984',4300452,'2231','342',530577.72,536112.36,0.00,0.00,5534.64,2472903.20,0.00,0.00,0.00),('1','142','799','222984',4300453,'2232','342',591419.06,591419.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','222989',4300525,'2231','342',536112.36,537942.25,0.00,0.00,1829.89,840547.20,0.00,0.00,0.00),('1','142','799','222989',4300526,'2232','342',591419.06,591419.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','223193',4303865,'2231','342',537942.25,543841.95,0.00,0.00,5899.70,2626529.12,0.00,0.00,0.00),('1','142','799','223193',4303866,'2232','342',591419.06,591419.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','223436',4308096,'2231','342',543841.95,548906.62,0.00,0.00,5064.67,2366191.72,0.00,0.00,0.00),('1','142','799','223436',4308097,'2232','342',591419.06,591419.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','223658',4312263,'2231','342',548906.62,549337.24,0.00,0.00,430.62,209847.52,0.00,0.00,0.00),('1','142','799','223658',4312264,'2232','342',591419.06,591419.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','223722',4313408,'2231','342',549337.24,549337.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','223722',4313409,'2232','342',591419.06,593197.16,0.00,0.00,1778.10,838989.74,0.00,0.00,0.00),('1','142','798','223883',4316472,'2231','342',549337.24,549337.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','223883',4316473,'2232','342',593197.16,594881.56,0.00,0.00,1684.40,813702.68,0.00,0.00,0.00),('1','142','798','224114',4320436,'2231','342',549337.24,549337.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','224114',4320437,'2232','342',594881.56,597677.99,0.00,0.00,2796.43,1331777.28,0.00,0.00,0.00),('1','142','798','224321',4324222,'2231','342',549337.24,549337.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','224321',4324223,'2232','342',597677.99,601325.47,0.00,0.00,3647.48,1881235.20,0.00,0.00,0.00),('1','142','798','224559',4328276,'2231','342',549337.24,549339.09,0.00,0.00,1.85,999.00,0.00,0.00,0.00),('1','142','799','224559',4328277,'2232','342',601325.47,602969.22,0.00,0.00,1643.75,858465.00,0.00,0.00,0.00),('1','142','798','224795',4332379,'2231','342',549339.09,549339.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','224795',4332380,'2232','342',602969.22,605552.31,0.00,0.00,2583.09,1338784.60,0.00,0.00,0.00),('1','142','798','225042',4336799,'2231','342',549339.09,549339.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','225042',4336800,'2232','342',605552.31,610200.39,0.00,0.00,4648.08,2356007.20,0.00,0.00,0.00),('1','142','798','225290',4341336,'2231','342',549339.09,549339.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','225290',4341337,'2232','342',610200.39,613325.66,0.00,0.00,3125.27,1588455.80,0.00,0.00,0.00),('1','142','798','225500',4345240,'2231','342',549339.09,549339.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','225500',4345241,'2232','342',613325.66,616216.99,0.00,0.00,2891.33,1467690.20,0.00,0.00,0.00),('1','142','798','225641',4347992,'2231','342',549339.09,549456.35,0.00,0.00,117.26,63320.40,0.00,0.00,0.00),('1','142','799','225641',4347993,'2232','342',616216.99,616216.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','225721',4348966,'2231','342',549456.35,551201.01,0.00,0.00,1744.66,902532.40,0.00,0.00,0.00),('1','142','799','225721',4348967,'2232','342',616216.99,616222.55,0.00,0.00,5.56,3002.40,0.00,0.00,0.00),('1','142','798','225995',4353724,'2231','342',551201.01,558064.85,0.00,0.00,6863.84,3470853.60,0.00,0.00,0.00),('1','142','799','225995',4353725,'2232','342',616222.55,616222.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','226257',4358680,'2231','342',558064.85,559917.30,0.00,0.00,1852.45,958179.00,0.00,0.00,0.00),('1','142','799','226257',4358681,'2232','342',616222.55,616222.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','226501',4362876,'2231','342',559917.30,565255.74,0.00,0.00,5338.44,2714027.60,0.00,0.00,0.00),('1','142','799','226501',4362877,'2232','342',616222.55,616222.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','226761',4367633,'2231','342',565255.74,568377.67,0.00,0.00,3121.93,1596560.20,0.00,0.00,0.00),('1','142','799','226761',4367634,'2232','342',616222.55,616222.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','226982',4371552,'2231','342',568377.67,571361.29,0.00,0.00,2983.62,1529034.80,0.00,0.00,0.00),('1','142','799','226982',4371553,'2232','342',616222.55,616222.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','227197',4375365,'2231','342',571361.29,572723.47,0.00,0.00,1362.18,719627.20,0.00,0.00,0.00),('1','142','799','227197',4375366,'2232','342',616222.55,616222.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','227392',4378761,'2231','342',572723.47,574055.97,0.00,0.00,1332.50,671166.00,0.00,0.00,0.00),('1','142','799','227392',4378762,'2232','342',616222.55,616222.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','227455',4380021,'2231','342',574055.97,574055.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','227455',4380022,'2232','342',616222.55,618999.19,0.00,0.00,2776.64,1413441.60,0.00,0.00,0.00),('1','142','798','227625',4382770,'2231','342',574055.97,574055.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','227625',4382771,'2232','342',618999.19,620862.49,0.00,0.00,1863.30,970232.00,0.00,0.00,0.00),('1','142','798','228097',4391807,'2231','342',574055.97,574055.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','228097',4391808,'2232','342',620862.49,623430.09,0.00,0.00,2567.60,1315724.00,0.00,0.00,0.00),('1','142','798','228329',4396235,'2231','342',574055.97,574055.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','228329',4396236,'2232','342',623430.09,625773.89,0.00,0.00,2343.80,1217068.00,0.00,0.00,0.00),('1','142','798','228509',4399591,'2231','342',574055.97,574055.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','228509',4399592,'2232','342',625773.89,631413.89,0.00,0.00,5640.00,2890421.40,0.00,0.00,0.00),('1','142','798','228735',4403903,'2231','342',574055.97,574055.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','228735',4403904,'2232','342',631413.89,634381.09,0.00,0.00,2967.20,1582576.60,0.00,0.00,0.00),('1','142','798','228959',4407632,'2231','342',574055.97,574055.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','228959',4407633,'2232','342',634381.09,636848.99,0.00,0.00,2467.90,1315824.00,0.00,0.00,0.00),('1','142','798','229210',4412579,'2231','342',574055.97,574055.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','229210',4412580,'2232','342',636848.99,640928.99,0.00,0.00,4080.00,2139854.40,0.00,0.00,0.00),('1','142','798','229216',4412719,'2231','342',574055.97,574847.77,0.00,0.00,791.80,422542.40,0.00,0.00,0.00),('1','142','799','229216',4412720,'2232','342',640928.99,640928.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','229436',4416536,'2231','342',574847.77,577544.47,0.00,0.00,2696.70,1438607.00,0.00,0.00,0.00),('1','142','799','229436',4416537,'2232','342',640928.99,640928.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','229644',4421028,'2231','342',577544.47,579779.97,0.00,0.00,2235.50,1244814.30,0.00,0.00,0.00),('1','142','799','229644',4421029,'2232','342',640928.99,640928.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','229869',4425539,'2231','342',579779.97,586416.07,0.00,0.00,6636.10,3603322.40,0.00,0.00,0.00),('1','142','799','229869',4425540,'2232','342',640928.99,640928.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','229972',4427108,'2231','342',586416.07,589575.77,0.00,0.00,3159.70,1727927.10,0.00,0.00,0.00),('1','142','799','229972',4427109,'2232','342',640928.99,640928.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','230259',4432780,'2231','342',589575.77,591451.57,0.00,0.00,1875.80,1040267.20,0.00,0.00,0.00),('1','142','799','230259',4432781,'2232','342',640928.99,640928.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','230450',4436397,'2231','342',591451.57,593324.47,0.00,0.00,1872.90,1044423.60,0.00,0.00,0.00),('1','142','799','230450',4436398,'2232','342',640928.99,640928.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','230792',4442181,'2231','342',593324.47,597332.57,0.00,0.00,4008.10,2190200.40,0.00,0.00,0.00),('1','142','799','230792',4442182,'2232','342',640928.99,640928.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','231123',4447940,'2231','342',597332.57,598672.98,0.00,0.00,1340.41,735999.44,0.00,0.00,0.00),('1','142','799','231123',4447941,'2232','342',640928.99,640928.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','231125',4447962,'2231','342',598672.98,598672.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','231125',4447963,'2232','342',640928.99,641648.88,0.00,0.00,719.89,406268.76,0.00,0.00,0.00),('1','142','798','231348',4451588,'2231','342',598672.98,598672.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','231348',4451589,'2232','342',641648.88,646250.48,0.00,0.00,4601.60,2502511.40,0.00,0.00,0.00),('1','142','798','231613',4456184,'2231','342',598672.98,598672.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','231613',4456185,'2232','342',646250.48,647963.28,0.00,0.00,1712.80,953965.20,0.00,0.00,0.00),('1','142','798','232041',4463938,'2231','342',598672.98,598672.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','232041',4463939,'2232','342',647963.28,650801.18,0.00,0.00,2837.90,1557441.80,0.00,0.00,0.00),('1','142','798','232138',4465409,'2231','342',598672.98,598672.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','232138',4465410,'2232','342',650801.18,652510.38,0.00,0.00,1709.20,950882.10,0.00,0.00,0.00),('1','142','798','232313',4468744,'2231','342',598672.98,598672.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','232313',4468745,'2232','342',652510.38,656641.28,0.00,0.00,4130.90,2250953.40,0.00,0.00,0.00),('1','142','798','232675',4475284,'2231','342',598672.98,598672.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','232675',4475285,'2232','342',656641.28,656641.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','232677',4475298,'2231','342',598672.98,598672.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','232677',4475299,'2232','342',656641.28,661605.68,0.00,0.00,4964.40,2699659.60,0.00,0.00,0.00),('1','142','798','232979',4480650,'2231','342',598672.98,598672.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','232979',4480651,'2232','342',661605.68,664584.68,0.00,0.00,2979.00,1641816.00,0.00,0.00,0.00),('1','142','798','233028',4481568,'2231','342',598672.98,598672.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','233028',4481569,'2232','342',664584.68,665615.99,0.00,0.00,1031.31,561389.15,0.00,0.00,0.00),('1','142','798','233106',4482964,'2231','342',598672.98,600022.07,0.00,0.00,1349.09,748173.46,0.00,0.00,0.00),('1','142','799','233106',4482965,'2232','342',665615.99,665615.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','233288',4486340,'2231','342',600022.07,601142.39,0.00,0.00,1120.32,648539.88,0.00,0.00,0.00),('1','142','799','233288',4486341,'2232','342',665615.99,665615.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','233400',4488136,'2231','342',601142.39,602744.08,0.00,0.00,1601.69,971238.84,0.00,0.00,0.00),('1','142','799','233400',4488137,'2232','342',665615.99,665615.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','233632',4492287,'2231','342',602744.08,607904.54,0.00,0.00,5160.46,3062075.32,0.00,0.00,0.00),('1','142','799','233632',4492288,'2232','342',665615.99,665615.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','233875',4496692,'2231','342',607904.54,609812.50,0.00,0.00,1907.96,1162875.72,0.00,0.00,0.00),('1','142','799','233875',4496693,'2232','342',665615.99,665615.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','234081',4500373,'2231','342',609812.50,612395.86,0.00,0.00,2583.36,1540118.64,0.00,0.00,0.00),('1','142','799','234081',4500374,'2232','342',665615.99,665615.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','234331',4504937,'2231','342',612395.86,614826.86,0.00,0.00,2431.00,1452105.60,0.00,0.00,0.00),('1','142','799','234331',4504938,'2232','342',665615.99,665615.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','234600',4509715,'2231','342',614826.86,617336.03,0.00,0.00,2509.17,1493956.52,0.00,0.00,0.00),('1','142','799','234600',4509716,'2232','342',665615.99,665615.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','234869',4514546,'2231','342',617336.03,619073.33,0.00,0.00,1737.30,1050315.20,0.00,0.00,0.00),('1','142','799','234869',4514547,'2232','342',665615.99,665615.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','235096',4518563,'2231','342',619073.33,622631.31,0.00,0.00,3557.98,2102845.20,0.00,0.00,0.00),('1','142','799','235096',4518564,'2232','342',665615.99,665621.99,0.00,0.00,6.00,3744.00,0.00,0.00,0.00),('1','142','798','235242',4521130,'2231','342',622631.31,622631.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','235242',4521131,'2232','342',665621.99,666036.29,0.00,0.00,414.30,253687.20,0.00,0.00,0.00),('1','142','798','235333',4522667,'2231','342',622631.31,622631.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','235333',4522668,'2232','342',666036.29,667631.89,0.00,0.00,1595.60,966836.04,0.00,0.00,0.00),('1','142','798','235557',4526535,'2231','342',622631.31,622631.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','235557',4526536,'2232','342',667631.89,670924.75,0.00,0.00,3292.86,1957567.72,0.00,0.00,0.00),('1','142','798','235791',4530703,'2231','342',622631.31,622631.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','235791',4530704,'2232','342',670924.75,672719.46,0.00,0.00,1794.71,1081379.04,0.00,0.00,0.00),('1','142','798','236064',4535427,'2231','342',622631.31,622631.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','236064',4535428,'2232','342',672719.46,674279.59,0.00,0.00,1560.13,945531.12,0.00,0.00,0.00),('1','142','798','236256',4538867,'2231','342',622631.31,622631.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','236256',4538868,'2232','342',674279.59,678701.68,0.00,0.00,4422.09,2609914.16,0.00,0.00,0.00),('1','142','798','236561',4544204,'2231','342',622631.31,622631.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','236561',4544205,'2232','342',678701.68,678701.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','236570',4544436,'2231','342',622631.31,622631.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','236570',4544437,'2232','342',678701.68,679972.28,0.00,0.00,1270.60,754838.40,0.00,0.00,0.00),('1','142','798','236573',4544482,'2231','342',622631.31,622635.44,0.00,0.00,4.13,2643.20,0.00,0.00,0.00),('1','142','799','236573',4544483,'2232','342',679972.28,683963.64,0.00,0.00,3991.36,2419225.40,0.00,0.00,0.00),('1','142','798','236768',4547673,'2231','342',622635.44,622635.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','236768',4547674,'2232','342',683963.64,686021.11,0.00,0.00,2057.47,1276950.80,0.00,0.00,0.00),('1','142','798','236991',4551696,'2231','342',622635.44,622635.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','236991',4551697,'2232','342',686021.11,687971.35,0.00,0.00,1950.24,1205878.60,0.00,0.00,0.00),('1','142','798','237187',4555098,'2231','342',622635.44,622635.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','237187',4555099,'2232','342',687971.35,690232.83,0.00,0.00,2261.48,1394324.20,0.00,0.00,0.00),('1','142','798','237323',4557856,'2231','342',622635.44,623866.19,0.00,0.00,1230.75,752608.00,0.00,0.00,0.00),('1','142','799','237323',4557857,'2232','342',690232.83,690232.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','237423',4559517,'2231','342',623866.19,627905.00,0.00,0.00,4038.81,2466340.40,0.00,0.00,0.00),('1','142','799','237423',4559518,'2232','342',690232.83,690232.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','237641',4563278,'2231','342',627905.00,633569.70,0.00,0.00,5664.70,3494573.80,0.00,0.00,0.00),('1','142','799','237641',4563279,'2232','342',690232.83,690232.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','237891',4567350,'2231','342',633569.70,635271.81,0.00,0.00,1702.11,1077322.40,0.00,0.00,0.00),('1','142','799','237891',4567351,'2232','342',690232.83,690232.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','238157',4571626,'2231','342',635271.81,637785.44,0.00,0.00,2513.63,1582355.20,0.00,0.00,0.00),('1','142','799','238157',4571627,'2232','342',690232.83,690232.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','238388',4575748,'2231','342',637785.44,639639.38,0.00,0.00,1853.94,1168122.60,0.00,0.00,0.00),('1','142','799','238388',4575749,'2232','342',690232.83,690232.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','238642',4579928,'2231','342',639639.38,640913.89,0.00,0.00,1274.51,811206.40,0.00,0.00,0.00),('1','142','799','238642',4579929,'2232','342',690232.83,690232.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','238859',4583791,'2231','342',640913.89,643015.52,0.00,0.00,2101.63,1321047.20,0.00,0.00,0.00),('1','142','799','238859',4583792,'2232','342',690232.83,690232.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','239089',4587923,'2231','342',643015.52,645794.17,0.00,0.00,2778.65,1743724.80,0.00,0.00,0.00),('1','142','799','239089',4587924,'2232','342',690232.83,690232.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','239326',4592019,'2231','342',645794.17,647003.54,0.00,0.00,1209.37,752976.80,0.00,0.00,0.00),('1','142','799','239326',4592020,'2232','342',690232.83,690232.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','239335',4592227,'2231','342',647003.54,647006.54,0.00,0.00,3.00,1920.00,0.00,0.00,0.00),('1','142','799','239335',4592228,'2232','342',690232.83,694092.22,0.00,0.00,3859.39,2420019.60,0.00,0.00,0.00),('1','142','798','239553',4595812,'2231','342',647006.54,647008.10,0.00,0.00,1.56,998.40,0.00,0.00,0.00),('1','142','799','239553',4595813,'2232','342',694092.22,696663.41,0.00,0.00,2571.19,1615601.60,0.00,0.00,0.00),('1','142','798','239762',4599621,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','239762',4599622,'2232','342',696663.41,698222.11,0.00,0.00,1558.70,1005034.42,0.00,0.00,0.00),('1','142','798','240010',4603807,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240010',4603808,'2232','342',698222.11,699467.14,0.00,0.00,1245.03,807233.68,0.00,0.00,0.00),('1','142','798','240210',4607370,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240210',4607371,'2232','342',699467.14,702454.48,0.00,0.00,2987.34,1905436.62,0.00,0.00,0.00),('1','142','798','240458',4611359,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240458',4611360,'2232','342',702454.48,705613.67,0.00,0.00,3159.19,2004240.64,0.00,0.00,0.00),('1','142','798','240634',4614525,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240634',4614526,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240636',4614593,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240636',4614594,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240638',4614601,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240638',4614602,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240640',4614617,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240640',4614618,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240641',4614619,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240641',4614620,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240642',4614621,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240642',4614622,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240643',4614623,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240643',4614624,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240644',4614625,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240644',4614626,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240645',4614627,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240645',4614628,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240646',4614629,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240646',4614630,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240647',4614631,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240647',4614632,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240648',4614633,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240648',4614634,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240649',4614635,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240649',4614636,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240650',4614637,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240650',4614638,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240652',4614643,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240652',4614644,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240653',4614645,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240653',4614646,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240654',4614647,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240654',4614648,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240655',4614649,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240655',4614650,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240656',4614651,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240656',4614652,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240657',4614653,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240657',4614654,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240658',4614655,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240658',4614656,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240659',4614657,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240659',4614658,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240660',4614659,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240660',4614660,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240661',4614661,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240661',4614662,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240662',4614663,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240662',4614664,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240692',4615014,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240692',4615015,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240698',4615099,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240698',4615100,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240702',4615130,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240702',4615131,'2232','342',705613.67,705613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','240719',4615371,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240719',4615372,'2232','342',705613.67,707136.90,0.00,0.00,1523.23,978894.14,0.00,0.00,0.00),('1','142','798','240977',4620020,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','240977',4620021,'2232','342',707136.90,709277.57,0.00,0.00,2140.67,1368272.92,0.00,0.00,0.00),('1','142','798','241248',4624835,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','241248',4624836,'2232','342',709277.57,712500.67,0.00,0.00,3223.10,2043626.60,0.00,0.00,0.00),('1','142','798','241511',4629271,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','241511',4629272,'2232','342',712500.67,715766.72,0.00,0.00,3266.05,2069297.80,0.00,0.00,0.00),('1','142','798','241754',4633589,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','241754',4633590,'2232','342',715766.72,718090.25,0.00,0.00,2323.53,1483449.68,0.00,0.00,0.00),('1','142','798','241991',4637604,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','241991',4637605,'2232','342',718090.25,721017.44,0.00,0.00,2927.19,1865911.40,0.00,0.00,0.00),('1','142','798','242230',4641862,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','242230',4641863,'2232','342',721017.44,723282.74,0.00,0.00,2265.30,1447415.20,0.00,0.00,0.00),('1','142','798','242469',4645997,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','242469',4645998,'2232','342',723282.74,725573.99,0.00,0.00,2291.25,1466255.84,0.00,0.00,0.00),('1','142','798','242714',4650349,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','242714',4650350,'2232','342',725573.99,728258.34,0.00,0.00,2684.35,1714840.14,0.00,0.00,0.00),('1','142','798','242936',4654089,'2231','342',647008.10,647008.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','242936',4654090,'2232','342',728258.34,730060.97,0.00,0.00,1802.63,1144783.28,0.00,0.00,0.00),('1','142','798','243022',4655629,'2231','342',647008.10,648171.30,0.00,0.00,1163.20,743205.20,0.00,0.00,0.00),('1','142','799','243022',4655630,'2232','342',730060.97,730060.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','243152',4657850,'2231','342',648171.30,650724.64,0.00,0.00,2553.34,1633346.04,0.00,0.00,0.00),('1','142','799','243152',4657851,'2232','342',730060.97,730060.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','243442',4663083,'2231','342',650724.64,652520.36,0.00,0.00,1795.72,1152730.12,0.00,0.00,0.00),('1','142','799','243442',4663084,'2232','342',730060.97,730060.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','243641',4666376,'2231','342',652520.36,655284.21,0.00,0.00,2763.85,1761987.60,0.00,0.00,0.00),('1','142','799','243641',4666377,'2232','342',730060.97,730060.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','243879',4670601,'2231','342',655284.21,656841.47,0.00,0.00,1557.26,1004757.56,0.00,0.00,0.00),('1','142','799','243879',4670602,'2232','342',730060.97,730060.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','244072',4673997,'2231','342',656841.47,659489.49,0.00,0.00,2648.02,1690767.30,0.00,0.00,0.00),('1','142','799','244072',4673998,'2232','342',730060.97,730060.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','244307',4677860,'2231','342',659489.49,663286.11,0.00,0.00,3796.62,2411127.22,0.00,0.00,0.00),('1','142','799','244307',4677861,'2232','342',730060.97,730060.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','244529',4681822,'2231','342',663286.11,667411.00,0.00,0.00,4124.89,2621653.84,0.00,0.00,0.00),('1','142','799','244529',4681823,'2232','342',730060.97,730060.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','244812',4686725,'2231','342',667411.00,669488.30,0.00,0.00,2077.30,1330696.80,0.00,0.00,0.00),('1','142','799','244812',4686726,'2232','342',730060.97,730067.06,0.00,0.00,6.09,3995.04,0.00,0.00,0.00),('1','142','798','244993',4689823,'2231','342',669488.30,671390.94,0.00,0.00,1902.64,1164255.36,0.00,0.00,0.00),('1','142','799','244993',4689824,'2232','342',730067.06,730073.07,0.00,0.00,6.01,3750.24,0.00,0.00,0.00),('1','142','798','245255',4694356,'2231','342',671390.94,671615.65,0.00,0.00,224.71,139715.04,0.00,0.00,0.00),('1','142','799','245255',4694357,'2232','342',730073.07,730073.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','245334',4695935,'2231','342',671615.65,671615.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','245334',4695936,'2232','342',730073.07,734766.34,0.00,0.00,4693.27,2829888.48,0.00,0.00,0.00),('1','142','798','245453',4697826,'2231','342',671615.65,671615.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','245453',4697827,'2232','342',734766.34,736265.07,0.00,0.00,1498.73,918431.52,0.00,0.00,0.00),('1','142','798','245704',4702156,'2231','342',671615.65,671615.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','245704',4702157,'2232','342',736265.07,738272.33,0.00,0.00,2007.26,1221642.24,0.00,0.00,0.00),('1','142','798','245990',4706585,'2231','342',671615.65,671615.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','245990',4706586,'2232','342',738272.33,739344.46,0.00,0.00,1072.13,653302.08,0.00,0.00,0.00),('1','142','798','246208',4710306,'2231','342',671615.65,671627.65,0.00,0.00,12.00,7392.00,0.00,0.00,0.00),('1','142','799','246208',4710307,'2232','342',739344.46,744369.79,0.00,0.00,5025.33,2899896.28,0.00,0.00,0.00),('1','142','798','246456',4714532,'2231','342',671627.65,671646.15,0.00,0.00,18.50,11396.00,0.00,0.00,0.00),('1','142','799','246456',4714533,'2232','342',744369.79,746103.13,0.00,0.00,1733.34,1022657.44,0.00,0.00,0.00),('1','142','798','246708',4718831,'2231','342',671646.15,671646.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','246708',4718832,'2232','342',746103.13,747380.98,0.00,0.00,1277.85,768433.60,0.00,0.00,0.00),('1','142','798','246954',4723226,'2231','342',671646.15,671646.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','246954',4723227,'2232','342',747380.98,750682.90,0.00,0.00,3301.92,1924410.72,0.00,0.00,0.00),('1','142','798','247185',4727046,'2231','342',671646.15,671646.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','247185',4727047,'2232','342',750682.90,751751.31,0.00,0.00,1068.41,646410.56,0.00,0.00,0.00),('1','142','798','247415',4731199,'2231','342',671646.15,671646.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','247415',4731200,'2232','342',751751.31,754306.49,0.00,0.00,2555.18,1478448.88,0.00,0.00,0.00),('1','142','798','247675',4735578,'2231','342',671646.15,671646.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','247675',4735579,'2232','342',754306.49,758936.93,0.00,0.00,4630.44,2690753.04,0.00,0.00,0.00),('1','142','798','247934',4739843,'2231','342',671646.15,671651.15,0.00,0.00,5.00,3080.00,0.00,0.00,0.00),('1','142','799','247934',4739844,'2232','342',758936.93,763550.97,0.00,0.00,4614.04,2700039.64,0.00,0.00,0.00),('1','142','798','248190',4744301,'2231','342',671651.15,671663.65,0.00,0.00,12.50,7700.00,0.00,0.00,0.00),('1','142','799','248190',4744302,'2232','342',763550.97,766970.75,0.00,0.00,3419.78,2016240.48,0.00,0.00,0.00),('1','142','798','248421',4748178,'2231','342',671663.65,671667.71,0.00,0.00,4.06,2500.96,0.00,0.00,0.00),('1','142','799','248421',4748179,'2232','342',766970.75,771544.53,0.00,0.00,4573.78,2672456.48,0.00,0.00,0.00),('1','142','798','248658',4752093,'2231','342',671667.71,671667.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','248658',4752094,'2232','342',771544.53,774684.91,0.00,0.00,3140.38,1844774.08,0.00,0.00,0.00),('1','142','798','248889',4756189,'2231','342',671667.71,671669.38,0.00,0.00,1.67,1002.00,0.00,0.00,0.00),('1','142','799','248889',4756190,'2232','342',774684.91,776269.63,0.00,0.00,1584.72,916072.00,0.00,0.00,0.00),('1','142','798','249136',4760141,'2231','342',671669.38,671672.71,0.00,0.00,3.33,1998.00,0.00,0.00,0.00),('1','142','799','249136',4760142,'2232','342',776269.63,777529.72,0.00,0.00,1260.09,733132.40,0.00,0.00,0.00),('1','142','798','249271',4762766,'2231','342',671672.71,671909.54,0.00,0.00,236.83,141378.00,0.00,0.00,0.00),('1','142','799','249271',4762767,'2232','342',777529.72,777529.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','249352',4764014,'2231','342',671909.54,674444.11,0.00,0.00,2534.57,1452742.00,0.00,0.00,0.00),('1','142','799','249352',4764015,'2232','342',777529.72,777529.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','249615',4768362,'2231','342',674444.11,676392.10,0.00,0.00,1947.99,1122914.00,0.00,0.00,0.00),('1','142','799','249615',4768363,'2232','342',777529.72,777532.72,0.00,0.00,3.00,1800.00,0.00,0.00,0.00),('1','142','798','249883',4772854,'2231','342',676392.10,678891.52,0.00,0.00,2499.42,1442052.00,0.00,0.00,0.00),('1','142','799','249883',4772855,'2232','342',777532.72,777532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','250110',4776696,'2231','342',678891.52,683006.44,0.00,0.00,4114.92,2342452.00,0.00,0.00,0.00),('1','142','799','250110',4776697,'2232','342',777532.72,777532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','250343',4780694,'2231','342',683006.44,684486.13,0.00,0.00,1479.69,873614.00,0.00,0.00,0.00),('1','142','799','250343',4780695,'2232','342',777532.72,777532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','250570',4784427,'2231','342',684486.13,685798.99,0.00,0.00,1312.86,773844.40,0.00,0.00,0.00),('1','142','799','250570',4784428,'2232','342',777532.72,777532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','250808',4788551,'2231','342',685798.99,691713.50,0.00,0.00,5914.51,3365046.00,0.00,0.00,0.00),('1','142','799','250808',4788552,'2232','342',777532.72,777532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','251030',4792619,'2231','342',691713.50,695802.14,0.00,0.00,4088.64,2333704.00,0.00,0.00,0.00),('1','142','799','251030',4792620,'2232','342',777532.72,777532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','251279',4796835,'2231','342',695802.14,696205.81,0.00,0.00,403.67,229202.00,0.00,0.00,0.00),('1','142','799','251279',4796836,'2232','342',777532.72,777532.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','251373',4798506,'2231','342',696205.81,696205.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','251373',4798507,'2232','342',777532.72,778565.69,0.00,0.00,1032.97,615062.00,0.00,0.00,0.00),('1','142','798','251557',4801440,'2231','342',696205.81,696205.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','251557',4801441,'2232','342',778565.69,782200.55,0.00,0.00,3634.86,2069356.00,0.00,0.00,0.00),('1','142','798','251777',4805530,'2231','342',696205.81,696205.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','251777',4805531,'2232','342',782200.55,784147.69,0.00,0.00,1947.14,1123444.00,0.00,0.00,0.00),('1','142','798','252015',4809558,'2231','342',696205.81,696205.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','252015',4809559,'2232','342',784147.69,785886.18,0.00,0.00,1738.49,1006494.00,0.00,0.00,0.00),('1','142','798','252273',4814009,'2231','342',696205.81,696205.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','252273',4814010,'2232','342',785886.18,788486.25,0.00,0.00,2600.07,1494396.40,0.00,0.00,0.00),('1','142','798','252511',4818308,'2231','342',696205.81,696205.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','252511',4818309,'2232','342',788486.25,790685.40,0.00,0.00,2199.15,1272490.00,0.00,0.00,0.00),('1','142','798','252748',4822439,'2231','342',696205.81,696205.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','252748',4822440,'2232','342',790685.40,793954.16,0.00,0.00,3268.76,1869338.80,0.00,0.00,0.00),('1','142','798','252997',4826422,'2231','342',696205.81,696205.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','252997',4826423,'2232','342',793954.16,796152.20,0.00,0.00,2198.04,1267904.00,0.00,0.00,0.00),('1','142','798','253223',4830347,'2231','342',696205.81,696205.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','253223',4830348,'2232','342',796152.20,798899.86,0.00,0.00,2747.66,1575496.00,0.00,0.00,0.00),('1','142','798','253501',4834999,'2231','342',696205.81,696205.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','253501',4835000,'2232','342',798899.86,801781.40,0.00,0.00,2881.54,1632428.00,0.00,0.00,0.00),('1','142','798','253919',4842670,'2231','342',696205.81,696205.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','253919',4842671,'2232','342',801781.40,801882.40,0.00,0.00,101.00,56560.00,0.00,0.00,0.00),('1','142','798','254322',4849544,'2231','342',696205.81,700090.93,0.00,0.00,3885.12,2210152.00,0.00,0.00,0.00),('1','142','799','254322',4849545,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','254460',4851783,'2231','342',700090.93,703097.79,0.00,0.00,3006.86,1727996.00,0.00,0.00,0.00),('1','142','799','254460',4851784,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','254741',4856580,'2231','342',703097.79,705075.57,0.00,0.00,1977.78,1147468.00,0.00,0.00,0.00),('1','142','799','254741',4856581,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','254983',4860726,'2231','342',705075.57,707486.26,0.00,0.00,2410.69,1386214.00,0.00,0.00,0.00),('1','142','799','254983',4860727,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','255205',4864573,'2231','342',707486.26,709041.59,0.00,0.00,1555.33,907398.00,0.00,0.00,0.00),('1','142','799','255205',4864574,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','255474',4869242,'2231','342',709041.59,712825.22,0.00,0.00,3783.63,2149318.00,0.00,0.00,0.00),('1','142','799','255474',4869243,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','255742',4873618,'2231','342',712825.22,715246.67,0.00,0.00,2421.45,1418655.60,0.00,0.00,0.00),('1','142','799','255742',4873619,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','255979',4877460,'2231','342',715246.67,717781.23,0.00,0.00,2534.56,1464696.00,0.00,0.00,0.00),('1','142','799','255979',4877461,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','256233',4881449,'2231','342',717781.23,719822.91,0.00,0.00,2041.68,1183928.00,0.00,0.00,0.00),('1','142','799','256233',4881450,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','256570',4887375,'2231','342',719822.91,719927.01,0.00,0.00,104.10,59675.60,0.00,0.00,0.00),('1','142','799','256570',4887376,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','256580',4887632,'2231','342',719927.01,721325.60,0.00,0.00,1398.59,814154.00,0.00,0.00,0.00),('1','142','799','256580',4887633,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','256742',4890120,'2231','342',721325.60,725233.31,0.00,0.00,3907.71,2229946.00,0.00,0.00,0.00),('1','142','799','256742',4890121,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','256970',4894163,'2231','342',725233.31,726803.26,0.00,0.00,1569.95,925730.00,0.00,0.00,0.00),('1','142','799','256970',4894164,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257259',4899367,'2231','342',726803.26,729089.65,0.00,0.00,2286.39,1317834.00,0.00,0.00,0.00),('1','142','799','257259',4899368,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257510',4903697,'2231','342',729089.65,731609.55,0.00,0.00,2519.90,1453380.00,0.00,0.00,0.00),('1','142','799','257510',4903698,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257511',4903699,'2231','342',731609.55,733942.36,0.00,0.00,2332.81,1354326.00,0.00,0.00,0.00),('1','142','799','257511',4903700,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257512',4903701,'2231','342',733942.36,737232.84,0.00,0.00,3290.48,1880768.00,0.00,0.00,0.00),('1','142','799','257512',4903702,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257513',4903703,'2231','342',737232.84,739867.38,0.00,0.00,2634.54,1523844.00,0.00,0.00,0.00),('1','142','799','257513',4903704,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257514',4903705,'2231','342',739867.38,742004.58,0.00,0.00,2137.20,1255040.00,0.00,0.00,0.00),('1','142','799','257514',4903706,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257515',4903707,'2231','342',742004.58,744230.39,0.00,0.00,2225.81,1280126.00,0.00,0.00,0.00),('1','142','799','257515',4903708,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257516',4903709,'2231','342',744230.39,744268.39,0.00,0.00,38.00,21400.00,0.00,0.00,0.00),('1','142','799','257516',4903710,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257517',4903711,'2231','342',744268.39,745745.00,0.00,0.00,1476.61,850446.00,0.00,0.00,0.00),('1','142','799','257517',4903712,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257518',4903713,'2231','342',745745.00,750446.76,0.00,0.00,4701.76,2681456.00,0.00,0.00,0.00),('1','142','799','257518',4903714,'2232','342',801882.40,801882.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257519',4903715,'2231','342',750446.76,752241.36,0.00,0.00,1794.60,1047288.00,0.00,0.00,0.00),('1','142','799','257519',4903716,'2232','342',801882.40,801888.40,0.00,0.00,6.00,3600.00,0.00,0.00,0.00),('1','142','798','257520',4903717,'2231','342',752241.36,753932.56,0.00,0.00,1691.20,983320.00,0.00,0.00,0.00),('1','142','799','257520',4903718,'2232','342',801888.40,801888.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257521',4903719,'2231','342',753932.56,756763.32,0.00,0.00,2830.76,1624656.00,0.00,0.00,0.00),('1','142','799','257521',4903720,'2232','342',801888.40,801888.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257522',4903721,'2231','342',756763.32,758302.16,0.00,0.00,1538.84,898676.40,0.00,0.00,0.00),('1','142','799','257522',4903722,'2232','342',801888.40,801888.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257523',4903723,'2231','342',1033.03,1463.82,0.00,0.00,430.79,258474.00,0.00,0.00,0.00),('1','142','799','257523',4903724,'2232','342',1171.57,1677.50,0.00,0.00,505.93,283320.80,0.00,0.00,0.00),('1','142','798','257523',4903725,'2233','342',1145.10,1580.89,0.00,0.00,435.79,261474.00,0.00,0.00,0.00),('1','142','799','257523',4903726,'2234','342',1324.03,1616.30,0.00,0.00,292.27,163671.20,0.00,0.00,0.00),('1','142','798','257524',4903727,'2231','342',1463.82,1906.48,0.00,0.00,442.66,265596.00,0.00,0.00,0.00),('1','142','799','257524',4903728,'2232','342',1677.50,2445.73,0.00,0.00,768.23,430208.80,0.00,0.00,0.00),('1','142','798','257524',4903729,'2233','342',1580.89,1983.17,0.00,0.00,402.28,241368.00,0.00,0.00,0.00),('1','142','799','257524',4903730,'2234','342',1616.30,2397.92,0.00,0.00,781.62,437707.20,0.00,0.00,0.00),('1','142','798','257525',4903731,'2231','342',1906.48,2425.92,0.00,0.00,519.44,311664.00,0.00,0.00,0.00),('1','142','799','257525',4903732,'2232','342',2445.73,2959.79,0.00,0.00,514.06,287873.60,0.00,0.00,0.00),('1','142','798','257525',4903733,'2233','342',1983.17,2392.49,0.00,0.00,409.32,245592.00,0.00,0.00,0.00),('1','142','799','257525',4903734,'2234','342',2397.92,2915.61,0.00,0.00,517.69,289906.40,0.00,0.00,0.00),('1','142','798','257526',4903735,'2231','342',2425.92,2875.22,0.00,0.00,449.30,269580.00,0.00,0.00,0.00),('1','142','799','257526',4903736,'2232','342',2959.79,3220.89,0.00,0.00,261.10,146216.00,0.00,0.00,0.00),('1','142','798','257526',4903737,'2233','342',2392.49,2825.72,0.00,0.00,433.23,259938.00,0.00,0.00,0.00),('1','142','799','257526',4903738,'2234','342',2915.61,3264.69,0.00,0.00,349.08,195484.80,0.00,0.00,0.00),('1','142','798','257527',4903739,'2231','342',2875.22,3398.78,0.00,0.00,523.56,314136.00,0.00,0.00,0.00),('1','142','799','257527',4903740,'2232','342',3220.89,3417.59,0.00,0.00,196.70,110152.00,0.00,0.00,0.00),('1','142','798','257527',4903741,'2233','342',2825.72,3240.88,0.00,0.00,415.16,249096.00,0.00,0.00,0.00),('1','142','799','257527',4903742,'2234','342',3264.69,3412.69,0.00,0.00,148.00,82880.00,0.00,0.00,0.00),('1','142','798','257528',4903743,'2231','342',3398.78,3885.09,0.00,0.00,486.31,291786.00,0.00,0.00,0.00),('1','142','798','257528',4903744,'2233','342',3240.88,3613.59,0.00,0.00,372.71,223626.00,0.00,0.00,0.00),('1','142','799','257528',4903745,'2234','342',3412.69,4697.72,0.00,0.00,1285.03,719616.80,0.00,0.00,0.00),('1','142','799','257528',4903746,'2232','342',3417.59,4592.88,0.00,0.00,1175.29,658162.40,0.00,0.00,0.00),('1','142','798','257529',4903747,'2231','342',3885.09,4282.18,0.00,0.00,397.09,225547.12,0.00,0.00,0.00),('1','142','799','257529',4903748,'2232','342',4592.88,5491.88,0.00,0.00,899.00,489056.00,0.00,0.00,0.00),('1','142','798','257529',4903749,'2233','342',3613.59,4117.08,0.00,0.00,503.49,285982.32,0.00,0.00,0.00),('1','142','799','257529',4903750,'2234','342',4697.72,5699.19,0.00,0.00,1001.47,544799.68,0.00,0.00,0.00),('1','142','798','257530',4903751,'2231','342',4282.18,4661.50,0.00,0.00,379.32,215453.76,0.00,0.00,0.00),('1','142','799','257530',4903752,'2232','342',5491.88,6547.19,0.00,0.00,1055.31,574096.08,0.00,0.00,0.00),('1','142','798','257530',4903753,'2233','342',4117.08,4446.95,0.00,0.00,329.87,187366.16,0.00,0.00,0.00),('1','142','799','257530',4903754,'2234','342',5699.19,6479.66,0.00,0.00,780.47,424575.68,0.00,0.00,0.00),('1','142','798','257531',4903755,'2231','342',4661.50,5226.49,0.00,0.00,564.99,320914.32,0.00,0.00,0.00),('1','142','799','257531',4903756,'2232','342',6547.19,7315.42,0.00,0.00,768.23,417917.12,0.00,0.00,0.00),('1','142','798','257531',4903757,'2233','342',4446.95,4978.77,0.00,0.00,531.82,302073.76,0.00,0.00,0.00),('1','142','799','257531',4903758,'2234','342',6479.66,7486.38,0.00,0.00,1006.72,547655.68,0.00,0.00,0.00),('1','142','798','257532',4903759,'2231','342',5226.49,5690.53,0.00,0.00,464.04,263574.72,0.00,0.00,0.00),('1','142','799','257532',4903760,'2232','342',7315.42,7754.26,0.00,0.00,438.84,238728.96,0.00,0.00,0.00),('1','142','798','257532',4903761,'2233','342',4978.77,5328.37,0.00,0.00,349.60,198572.80,0.00,0.00,0.00),('1','142','799','257532',4903762,'2234','342',7486.38,8000.19,0.00,0.00,513.81,279512.64,0.00,0.00,0.00),('1','142','798','257533',4903763,'2231','342',5690.53,6063.51,0.00,0.00,372.98,211852.64,0.00,0.00,0.00),('1','142','799','257533',4903764,'2232','342',7754.26,8129.10,0.00,0.00,374.84,203912.96,0.00,0.00,0.00),('1','142','798','257533',4903765,'2233','342',5328.37,5711.40,0.00,0.00,383.03,217561.04,0.00,0.00,0.00),('1','142','799','257533',4903766,'2234','342',8000.19,8490.87,0.00,0.00,490.68,266929.92,0.00,0.00,0.00),('1','142','798','257534',4903767,'2231','342',6063.51,6446.54,0.00,0.00,383.03,217561.04,0.00,0.00,0.00),('1','142','799','257534',4903768,'2232','342',8129.10,8371.08,0.00,0.00,241.98,131637.12,0.00,0.00,0.00),('1','142','798','257534',4903769,'2233','342',5711.40,6087.01,0.00,0.00,375.61,213346.48,0.00,0.00,0.00),('1','142','799','257534',4903770,'2234','342',8490.87,8676.87,0.00,0.00,186.00,101184.00,0.00,0.00,0.00),('1','142','798','257535',4903771,'2231','342',6446.54,6870.84,0.00,0.00,424.30,241002.40,0.00,0.00,0.00),('1','142','799','257535',4903772,'2232','342',8371.08,8873.92,0.00,0.00,502.84,273565.12,0.00,0.00,0.00),('1','142','798','257535',4903773,'2233','342',6087.01,6512.68,0.00,0.00,425.67,241780.56,0.00,0.00,0.00),('1','142','799','257535',4903774,'2234','342',8676.87,9314.58,0.00,0.00,637.71,346914.24,0.00,0.00,0.00),('1','142','798','257536',4903775,'2231','342',6870.84,7290.59,0.00,0.00,419.75,238418.00,0.00,0.00,0.00),('1','142','799','257536',4903776,'2232','342',8873.92,9028.92,0.00,0.00,155.00,84320.00,0.00,0.00,0.00),('1','142','798','257536',4903777,'2233','342',6512.68,6913.67,0.00,0.00,400.99,227762.32,0.00,0.00,0.00),('1','142','799','257536',4903778,'2234','342',9314.58,9400.58,0.00,0.00,86.00,46784.00,0.00,0.00,0.00),('1','142','798','257537',4903779,'2231','342',7290.59,7646.73,0.00,0.00,356.14,202287.52,0.00,0.00,0.00),('1','142','799','257537',4903780,'2232','342',9028.92,9699.55,0.00,0.00,670.63,364822.72,0.00,0.00,0.00),('1','142','798','257537',4903781,'2233','342',6913.67,7333.59,0.00,0.00,419.92,238514.56,0.00,0.00,0.00),('1','142','799','257537',4903782,'2234','342',9400.58,10111.03,0.00,0.00,710.45,386484.80,0.00,0.00,0.00),('1','142','798','257538',4903783,'2231','342',7646.73,8021.76,0.00,0.00,375.03,213017.04,0.00,0.00,0.00),('1','142','799','257538',4903784,'2232','342',9699.55,10007.65,0.00,0.00,308.10,167606.40,0.00,0.00,0.00),('1','142','798','257538',4903785,'2233','342',7333.59,7775.41,0.00,0.00,441.82,250953.76,0.00,0.00,0.00),('1','142','799','257538',4903786,'2234','342',10111.03,10608.32,0.00,0.00,497.29,270532.72,0.00,0.00,0.00),('1','142','798','257539',4903787,'2231','342',8021.76,8470.51,0.00,0.00,448.75,254890.00,0.00,0.00,0.00),('1','142','799','257539',4903788,'2232','342',10007.65,11446.93,0.00,0.00,1439.28,782968.32,0.00,0.00,0.00),('1','142','798','257539',4903789,'2233','342',7775.41,8254.92,0.00,0.00,479.51,272361.68,0.00,0.00,0.00),('1','142','799','257539',4903790,'2234','342',10608.32,11845.03,0.00,0.00,1236.71,672770.24,0.00,0.00,0.00),('1','142','798','257540',4903791,'2231','342',8470.51,8550.86,0.00,0.00,80.35,45638.80,0.00,0.00,0.00),('1','142','799','257540',4903792,'2232','342',11446.93,11788.85,0.00,0.00,341.92,186004.48,0.00,0.00,0.00),('1','142','798','257540',4903793,'2233','342',8254.92,8318.80,0.00,0.00,63.88,36283.84,0.00,0.00,0.00),('1','142','799','257540',4903794,'2234','342',11845.03,12147.02,0.00,0.00,301.99,164282.56,0.00,0.00,0.00),('1','142','798','257541',4903795,'2231','342',8550.86,9268.34,0.00,0.00,717.48,407528.64,0.00,0.00,0.00),('1','142','799','257541',4903796,'2232','342',11788.85,12395.70,0.00,0.00,606.85,330126.40,0.00,0.00,0.00),('1','142','798','257541',4903797,'2233','342',8318.80,9051.49,0.00,0.00,732.69,416167.92,0.00,0.00,0.00),('1','142','799','257541',4903798,'2234','342',12147.02,12828.96,0.00,0.00,681.94,370975.36,0.00,0.00,0.00),('1','142','798','257542',4903799,'2231','342',9268.34,9689.04,0.00,0.00,420.70,238957.60,0.00,0.00,0.00),('1','142','799','257542',4903800,'2232','342',12395.70,13002.70,0.00,0.00,607.00,330208.00,0.00,0.00,0.00),('1','142','798','257542',4903801,'2233','342',9051.49,9495.92,0.00,0.00,444.43,252436.24,0.00,0.00,0.00),('1','142','799','257542',4903802,'2234','342',12828.96,13337.34,0.00,0.00,508.38,276567.84,0.00,0.00,0.00),('1','142','798','257543',4903803,'2231','342',9689.04,10063.87,0.00,0.00,374.83,212903.44,0.00,0.00,0.00),('1','142','799','257543',4903804,'2232','342',13002.70,13456.70,0.00,0.00,454.00,246976.00,0.00,0.00,0.00),('1','142','798','257543',4903805,'2233','342',9495.92,9963.97,0.00,0.00,468.05,265852.40,0.00,0.00,0.00),('1','142','799','257543',4903806,'2234','342',13337.34,13747.84,0.00,0.00,410.50,223312.00,0.00,0.00,0.00),('1','142','798','257544',4903807,'2231','342',10063.87,10606.58,0.00,0.00,542.71,308259.28,0.00,0.00,0.00),('1','142','799','257544',4903808,'2232','342',13456.70,13844.68,0.00,0.00,387.98,211061.12,0.00,0.00,0.00),('1','142','798','257544',4903809,'2233','342',9963.97,10398.70,0.00,0.00,434.73,246926.64,0.00,0.00,0.00),('1','142','799','257544',4903810,'2234','342',13747.84,14130.84,0.00,0.00,383.00,208352.00,0.00,0.00,0.00),('1','142','798','257545',4903811,'2231','342',10606.58,11116.13,0.00,0.00,509.55,289424.40,0.00,0.00,0.00),('1','142','799','257545',4903812,'2232','342',13844.68,15558.03,0.00,0.00,1713.35,935590.40,0.00,0.00,0.00),('1','142','798','257545',4903813,'2233','342',10398.70,11111.67,0.00,0.00,712.97,404966.96,0.00,0.00,0.00),('1','142','799','257545',4903814,'2234','342',14130.84,15283.64,0.00,0.00,1152.80,629331.20,0.00,0.00,0.00),('1','142','798','257546',4903815,'2231','342',11116.13,11656.13,0.00,0.00,540.00,306720.00,0.00,0.00,0.00),('1','142','799','257546',4903816,'2232','342',15558.03,15930.03,0.00,0.00,372.00,202368.00,0.00,0.00,0.00),('1','142','798','257546',4903817,'2233','342',11111.67,11734.30,0.00,0.00,622.63,353653.84,0.00,0.00,0.00),('1','142','799','257546',4903818,'2234','342',15283.64,15595.56,0.00,0.00,311.92,169684.48,0.00,0.00,0.00),('1','142','798','257547',4903819,'2231','342',11656.13,12223.16,0.00,0.00,567.03,322073.04,0.00,0.00,0.00),('1','142','799','257547',4903820,'2232','342',15930.03,17749.31,0.00,0.00,1819.28,989688.32,0.00,0.00,0.00),('1','142','798','257547',4903821,'2233','342',11734.30,12336.37,0.00,0.00,602.07,341975.76,0.00,0.00,0.00),('1','142','799','257547',4903822,'2234','342',15595.56,17030.52,0.00,0.00,1434.96,780618.24,0.00,0.00,0.00),('1','142','798','257548',4903823,'2231','342',12223.16,12773.95,0.00,0.00,550.79,312848.72,0.00,0.00,0.00),('1','142','798','257548',4903824,'2233','342',12336.37,12968.74,0.00,0.00,632.37,359186.16,0.00,0.00,0.00),('1','142','799','257548',4903825,'2234','342',17030.52,17240.52,0.00,0.00,210.00,114240.00,0.00,0.00,0.00),('1','142','799','257548',4903826,'2232','342',17749.31,17886.31,0.00,0.00,137.00,74528.00,0.00,0.00,0.00),('1','142','798','257549',4903827,'2231','342',12773.95,13267.73,0.00,0.00,493.78,280467.04,0.00,0.00,0.00),('1','142','799','257549',4903828,'2232','342',17886.31,19016.48,0.00,0.00,1130.17,614812.48,0.00,0.00,0.00),('1','142','798','257549',4903829,'2233','342',12968.74,13359.15,0.00,0.00,390.41,221752.88,0.00,0.00,0.00),('1','142','799','257549',4903830,'2234','342',17240.52,17963.55,0.00,0.00,723.03,393328.32,0.00,0.00,0.00),('1','142','798','257550',4903831,'2231','342',13267.73,13335.71,0.00,0.00,67.98,38612.64,0.00,0.00,0.00),('1','142','799','257550',4903832,'2232','342',19016.48,19016.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257550',4903833,'2233','342',13359.15,13412.60,0.00,0.00,53.45,30359.60,0.00,0.00,0.00),('1','142','799','257550',4903834,'2234','342',17963.55,17963.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257551',4903835,'2231','342',13335.71,13461.34,0.00,0.00,125.63,80403.20,0.00,0.00,0.00),('1','142','799','257551',4903836,'2232','342',19016.48,19429.51,0.00,0.00,413.03,256078.60,0.00,0.00,0.00),('1','142','798','257551',4903837,'2233','342',13412.60,13540.59,0.00,0.00,127.99,81913.60,0.00,0.00,0.00),('1','142','799','257551',4903838,'2234','342',17963.55,18381.03,0.00,0.00,417.48,258837.60,0.00,0.00,0.00),('1','142','798','257552',4903839,'2231','342',13461.34,13461.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257552',4903840,'2232','342',19429.51,19429.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257552',4903841,'2233','342',13540.59,13540.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257552',4903842,'2234','342',18381.03,18444.02,0.00,0.00,62.99,39053.80,0.00,0.00,0.00),('1','142','798','257553',4903843,'2231','342',13461.34,13835.10,0.00,0.00,373.76,239206.40,0.00,0.00,0.00),('1','142','798','257553',4903844,'2233','342',13540.59,13831.17,0.00,0.00,290.58,185971.20,0.00,0.00,0.00),('1','142','799','257553',4903845,'2234','342',18444.02,20367.02,0.00,0.00,1923.00,1192260.00,0.00,0.00,0.00),('1','142','799','257553',4903846,'2232','342',19429.51,21539.89,0.00,0.00,2110.38,1308435.60,0.00,0.00,0.00),('1','142','798','257554',4903847,'2231','342',13835.10,14712.23,0.00,0.00,877.13,561363.20,0.00,0.00,0.00),('1','142','799','257554',4903848,'2232','342',21539.89,22510.89,0.00,0.00,971.00,602020.00,0.00,0.00,0.00),('1','142','798','257554',4903849,'2233','342',13831.17,13831.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257554',4903850,'2234','342',20367.02,20567.02,0.00,0.00,200.00,124000.00,0.00,0.00,0.00),('1','142','798','257555',4903851,'2231','342',14712.23,14816.56,0.00,0.00,104.33,66771.20,0.00,0.00,0.00),('1','142','799','257555',4903852,'2232','342',22510.89,23213.94,0.00,0.00,703.05,436031.60,0.00,0.00,0.00),('1','142','798','257555',4903853,'2233','342',13831.17,14509.11,0.00,0.00,677.94,433881.60,0.00,0.00,0.00),('1','142','799','257555',4903854,'2234','342',20567.02,21913.52,0.00,0.00,1346.50,834830.00,0.00,0.00,0.00),('1','142','798','257556',4903855,'2231','342',14816.56,15161.05,0.00,0.00,344.49,234253.20,0.00,0.00,0.00),('1','142','799','257556',4903856,'2232','342',23213.94,23486.94,0.00,0.00,273.00,174720.00,0.00,0.00,0.00),('1','142','798','257556',4903857,'2233','342',14509.11,14814.58,0.00,0.00,305.47,207719.60,0.00,0.00,0.00),('1','142','799','257556',4903858,'2234','342',21913.52,22130.52,0.00,0.00,217.00,138880.00,0.00,0.00,0.00),('1','142','798','257557',4903859,'2231','342',15161.05,15637.36,0.00,0.00,476.31,323890.80,0.00,0.00,0.00),('1','142','799','257557',4903860,'2232','342',23486.94,23866.94,0.00,0.00,380.00,243200.00,0.00,0.00,0.00),('1','142','798','257557',4903861,'2233','342',14814.58,15325.58,0.00,0.00,511.00,347480.00,0.00,0.00,0.00),('1','142','799','257557',4903862,'2234','342',22130.52,22290.01,0.00,0.00,159.49,102073.60,0.00,0.00,0.00),('1','142','798','257558',4903863,'2231','342',15637.36,16092.45,0.00,0.00,455.09,309461.20,0.00,0.00,0.00),('1','142','799','257558',4903864,'2232','342',23866.94,24458.45,0.00,0.00,591.51,378566.40,0.00,0.00,0.00),('1','142','798','257558',4903865,'2233','342',15325.58,15775.46,0.00,0.00,449.88,305918.40,0.00,0.00,0.00),('1','142','799','257558',4903866,'2234','342',22290.01,22934.26,0.00,0.00,644.25,412320.00,0.00,0.00,0.00),('1','142','798','257559',4903867,'2231','342',16092.45,16562.07,0.00,0.00,469.62,319341.60,0.00,0.00,0.00),('1','142','799','257559',4903868,'2232','342',24458.45,24738.45,0.00,0.00,280.00,179200.00,0.00,0.00,0.00),('1','142','798','257559',4903869,'2233','342',15775.46,16191.92,0.00,0.00,416.46,283192.80,0.00,0.00,0.00),('1','142','799','257559',4903870,'2234','342',22934.26,23236.02,0.00,0.00,301.76,193126.40,0.00,0.00,0.00),('1','142','798','257560',4903871,'2231','342',16562.07,16997.58,0.00,0.00,435.51,296146.80,0.00,0.00,0.00),('1','142','799','257560',4903872,'2232','342',24738.45,25481.45,0.00,0.00,743.00,475520.00,0.00,0.00,0.00),('1','142','798','257560',4903873,'2233','342',16191.92,16631.09,0.00,0.00,439.17,298635.60,0.00,0.00,0.00),('1','142','799','257560',4903874,'2234','342',23236.02,23923.02,0.00,0.00,687.00,439680.00,0.00,0.00,0.00),('1','142','798','257561',4903875,'2231','342',16997.58,17581.86,0.00,0.00,584.28,397310.40,0.00,0.00,0.00),('1','142','799','257561',4903876,'2232','342',25481.45,26039.58,0.00,0.00,558.13,357203.20,0.00,0.00,0.00),('1','142','798','257561',4903877,'2233','342',16631.09,17064.58,0.00,0.00,433.49,294773.20,0.00,0.00,0.00),('1','142','799','257561',4903878,'2234','342',23923.02,24599.79,0.00,0.00,676.77,433132.80,0.00,0.00,0.00),('1','142','798','257562',4903879,'2231','342',17581.86,18079.35,0.00,0.00,497.49,338293.20,0.00,0.00,0.00),('1','142','799','257562',4903880,'2232','342',26039.58,26524.51,0.00,0.00,484.93,310355.20,0.00,0.00,0.00),('1','142','798','257562',4903881,'2233','342',17064.58,17534.59,0.00,0.00,470.01,319606.80,0.00,0.00,0.00),('1','142','799','257562',4903882,'2234','342',24599.79,25015.79,0.00,0.00,416.00,266240.00,0.00,0.00,0.00),('1','142','798','257563',4903883,'2231','342',18079.35,18576.20,0.00,0.00,496.85,337858.00,0.00,0.00,0.00),('1','142','799','257563',4903884,'2232','342',26524.51,27223.28,0.00,0.00,698.77,447212.80,0.00,0.00,0.00),('1','142','798','257563',4903885,'2233','342',17534.59,18002.24,0.00,0.00,467.65,318002.00,0.00,0.00,0.00),('1','142','799','257563',4903886,'2234','342',25015.79,25846.07,0.00,0.00,830.28,531379.20,0.00,0.00,0.00),('1','142','798','257564',4903887,'2231','342',18576.20,19458.16,0.00,0.00,881.96,599732.80,0.00,0.00,0.00),('1','142','799','257564',4903888,'2232','342',27223.28,28877.56,0.00,0.00,1654.28,1066579.20,0.00,0.00,0.00),('1','142','798','257564',4903889,'2233','342',18002.24,18002.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257564',4903890,'2234','342',25846.07,27066.22,0.00,0.00,1220.15,780896.00,0.00,0.00,0.00),('1','142','798','257565',4903891,'2231','342',19458.16,19913.92,0.00,0.00,455.76,309916.80,0.00,0.00,0.00),('1','142','799','257565',4903892,'2232','342',28877.56,29262.56,0.00,0.00,385.00,246400.00,0.00,0.00,0.00),('1','142','798','257565',4903893,'2233','342',18002.24,18468.07,0.00,0.00,465.83,316764.40,0.00,0.00,0.00),('1','142','799','257565',4903894,'2234','342',27066.22,27354.61,0.00,0.00,288.39,184569.60,0.00,0.00,0.00),('1','142','798','257566',4903895,'2231','342',19913.92,20579.20,0.00,0.00,665.28,452390.40,0.00,0.00,0.00),('1','142','799','257566',4903896,'2232','342',29262.56,29549.44,0.00,0.00,286.88,183603.20,0.00,0.00,0.00),('1','142','798','257566',4903897,'2233','342',18468.07,18655.47,0.00,0.00,187.40,127432.00,0.00,0.00,0.00),('1','142','799','257566',4903898,'2234','342',27354.61,27702.42,0.00,0.00,347.81,222598.40,0.00,0.00,0.00),('1','142','798','257567',4903899,'2231','342',20579.20,21096.16,0.00,0.00,516.96,351532.80,0.00,0.00,0.00),('1','142','799','257567',4903900,'2232','342',29549.44,31835.47,0.00,0.00,2286.03,1463559.20,0.00,0.00,0.00),('1','142','798','257567',4903901,'2233','342',18655.47,19074.06,0.00,0.00,418.59,284641.20,0.00,0.00,0.00),('1','142','799','257567',4903902,'2234','342',27702.42,29690.29,0.00,0.00,1987.87,1272236.80,0.00,0.00,0.00),('1','142','798','257568',4903903,'2231','342',21096.16,21503.75,0.00,0.00,407.59,277161.20,0.00,0.00,0.00),('1','142','799','257568',4903904,'2232','342',31835.47,31925.07,0.00,0.00,89.60,57546.00,0.00,0.00,0.00),('1','142','798','257568',4903905,'2233','342',19074.06,19462.54,0.00,0.00,388.48,264166.40,0.00,0.00,0.00),('1','142','799','257568',4903906,'2234','342',29690.29,29845.79,0.00,0.00,155.50,99831.00,0.00,0.00,0.00),('1','142','798','257569',4903907,'2231','342',21503.75,22025.73,0.00,0.00,521.98,354946.40,0.00,0.00,0.00),('1','142','799','257569',4903908,'2232','342',31925.07,32397.89,0.00,0.00,472.82,303550.44,0.00,0.00,0.00),('1','142','798','257569',4903909,'2233','342',19462.54,20229.07,0.00,0.00,766.53,521240.40,0.00,0.00,0.00),('1','142','799','257569',4903910,'2234','342',29845.79,30257.90,0.00,0.00,412.11,264574.62,0.00,0.00,0.00),('1','142','798','257570',4903911,'2231','342',22025.73,22638.51,0.00,0.00,612.78,416690.40,0.00,0.00,0.00),('1','142','799','257570',4903912,'2232','342',32397.89,33800.96,0.00,0.00,1403.07,900770.94,0.00,0.00,0.00),('1','142','798','257570',4903913,'2233','342',20229.07,20917.17,0.00,0.00,688.10,467908.00,0.00,0.00,0.00),('1','142','799','257570',4903914,'2234','342',30257.90,31486.56,0.00,0.00,1228.66,788799.72,0.00,0.00,0.00),('1','142','798','257571',4903915,'2231','342',22638.51,23311.67,0.00,0.00,673.16,457748.80,0.00,0.00,0.00),('1','142','798','257571',4903916,'2233','342',20917.17,21635.15,0.00,0.00,717.98,488226.40,0.00,0.00,0.00),('1','142','799','257571',4903917,'2234','342',31486.56,31827.56,0.00,0.00,341.00,218922.00,0.00,0.00,0.00),('1','142','799','257571',4903918,'2232','342',33800.96,34147.37,0.00,0.00,346.41,222395.22,0.00,0.00,0.00),('1','142','798','257572',4903919,'2231','342',23311.67,24048.17,0.00,0.00,736.50,500820.00,0.00,0.00,0.00),('1','142','799','257572',4903920,'2232','342',34147.37,34930.54,0.00,0.00,783.17,502795.14,0.00,0.00,0.00),('1','142','798','257572',4903921,'2233','342',21635.15,22434.67,0.00,0.00,799.52,543673.60,0.00,0.00,0.00),('1','142','799','257572',4903922,'2234','342',31827.56,32447.39,0.00,0.00,619.83,397930.86,0.00,0.00,0.00),('1','142','798','257573',4903923,'2231','342',24048.17,25376.66,0.00,0.00,1328.49,863518.50,0.00,0.00,0.00),('1','142','798','257573',4903924,'2233','342',22434.67,23487.72,0.00,0.00,1053.05,684482.50,0.00,0.00,0.00),('1','142','799','257573',4903925,'2234','342',32447.39,33665.76,0.00,0.00,1218.37,755389.40,0.00,0.00,0.00),('1','142','799','257573',4903926,'2232','342',34930.54,35924.58,0.00,0.00,994.04,616337.20,0.00,0.00,0.00),('1','142','798','257574',4903927,'2231','342',25376.66,26732.24,0.00,0.00,1355.58,881127.00,0.00,0.00,0.00),('1','142','799','257574',4903928,'2232','342',35924.58,37059.38,0.00,0.00,1134.80,703906.00,0.00,0.00,0.00),('1','142','798','257574',4903929,'2233','342',23487.72,24694.08,0.00,0.00,1206.36,784134.00,0.00,0.00,0.00),('1','142','799','257574',4903930,'2234','342',33665.76,34857.90,0.00,0.00,1192.14,741556.80,0.00,0.00,0.00),('1','142','798','257575',4903931,'2231','342',26732.24,27347.60,0.00,0.00,615.36,399984.00,0.00,0.00,0.00),('1','142','799','257575',4903932,'2232','342',37059.38,38767.93,0.00,0.00,1708.55,1059301.00,0.00,0.00,0.00),('1','142','798','257575',4903933,'2233','342',24694.08,25582.54,0.00,0.00,888.46,577499.00,0.00,0.00,0.00),('1','142','799','257575',4903934,'2234','342',34857.90,36779.13,0.00,0.00,1921.23,1191162.60,0.00,0.00,0.00),('1','142','798','257576',4903935,'2231','342',27347.60,28538.83,0.00,0.00,1191.23,774299.50,0.00,0.00,0.00),('1','142','799','257576',4903936,'2232','342',38767.93,39293.46,0.00,0.00,525.53,325844.50,0.00,0.00,0.00),('1','142','798','257576',4903937,'2233','342',25582.54,25720.78,0.00,0.00,138.24,89856.00,0.00,0.00,0.00),('1','142','799','257576',4903938,'2234','342',36779.13,37445.65,0.00,0.00,666.52,413243.00,0.00,0.00,0.00),('1','142','798','257577',4903939,'2231','342',28538.83,29220.30,0.00,0.00,681.47,442955.50,0.00,0.00,0.00),('1','142','799','257577',4903940,'2232','342',39293.46,41059.73,0.00,0.00,1766.27,1095087.40,0.00,0.00,0.00),('1','142','798','257577',4903941,'2233','342',25720.78,26194.52,0.00,0.00,473.74,307931.00,0.00,0.00,0.00),('1','142','799','257577',4903942,'2234','342',37445.65,38829.57,0.00,0.00,1383.92,858030.40,0.00,0.00,0.00),('1','142','798','257578',4903943,'2231','342',29220.30,29777.72,0.00,0.00,557.42,362323.00,0.00,0.00,0.00),('1','142','799','257578',4903944,'2232','342',41059.73,41649.40,0.00,0.00,589.67,365595.40,0.00,0.00,0.00),('1','142','798','257578',4903945,'2233','342',26194.52,26632.66,0.00,0.00,438.14,284791.00,0.00,0.00,0.00),('1','142','799','257578',4903946,'2234','342',38829.57,39431.56,0.00,0.00,601.99,373233.80,0.00,0.00,0.00),('1','142','798','257579',4903947,'2231','342',29777.72,29870.05,0.00,0.00,92.33,60014.50,0.00,0.00,0.00),('1','142','799','257579',4903948,'2232','342',41649.40,42561.47,0.00,0.00,912.07,565573.40,0.00,0.00,0.00),('1','142','798','257579',4903949,'2233','342',26632.66,26938.79,0.00,0.00,306.13,198984.50,0.00,0.00,0.00),('1','142','799','257579',4903950,'2234','342',39431.56,40361.77,0.00,0.00,930.21,576730.20,0.00,0.00,0.00),('1','142','798','257580',4903951,'2231','342',29870.05,30482.09,0.00,0.00,612.04,397826.00,0.00,0.00,0.00),('1','142','799','257580',4903952,'2232','342',42561.47,42714.47,0.00,0.00,153.00,94860.00,0.00,0.00,0.00),('1','142','798','257580',4903953,'2233','342',26938.79,27536.93,0.00,0.00,598.14,388791.00,0.00,0.00,0.00),('1','142','799','257580',4903954,'2234','342',40361.77,40590.77,0.00,0.00,229.00,141980.00,0.00,0.00,0.00),('1','142','798','257581',4903955,'2231','342',30482.09,31135.91,0.00,0.00,653.82,424983.00,0.00,0.00,0.00),('1','142','799','257581',4903956,'2232','342',42714.47,43989.32,0.00,0.00,1274.85,790407.00,0.00,0.00,0.00),('1','142','798','257581',4903957,'2233','342',27536.93,28058.01,0.00,0.00,521.08,338702.00,0.00,0.00,0.00),('1','142','799','257581',4903958,'2234','342',40590.77,41633.77,0.00,0.00,1043.00,646836.70,0.00,0.00,0.00),('1','142','798','257582',4903959,'2231','342',31135.91,31734.67,0.00,0.00,598.76,389194.00,0.00,0.00,0.00),('1','142','799','257582',4903960,'2232','342',43989.32,44419.32,0.00,0.00,430.00,266600.00,0.00,0.00,0.00),('1','142','798','257582',4903961,'2233','342',28058.01,28427.65,0.00,0.00,369.64,240266.00,0.00,0.00,0.00),('1','142','799','257582',4903962,'2234','342',41633.77,42063.77,0.00,0.00,430.00,266692.40,0.00,0.00,0.00),('1','142','798','257583',4903963,'2231','342',31734.67,32114.56,0.00,0.00,379.89,246928.50,0.00,0.00,0.00),('1','142','799','257583',4903964,'2232','342',44419.32,44617.32,0.00,0.00,198.00,122760.00,0.00,0.00,0.00),('1','142','798','257583',4903965,'2233','342',28427.65,28801.27,0.00,0.00,373.62,242853.00,0.00,0.00,0.00),('1','142','799','257583',4903966,'2234','342',42063.77,42756.79,0.00,0.00,693.02,429672.40,0.00,0.00,0.00),('1','142','798','257584',4903967,'2231','342',32114.56,32505.90,0.00,0.00,391.34,254371.00,0.00,0.00,0.00),('1','142','799','257584',4903968,'2232','342',44617.32,44767.32,0.00,0.00,150.00,93000.00,0.00,0.00,0.00),('1','142','798','257584',4903969,'2233','342',28801.27,29129.95,0.00,0.00,328.68,213642.00,0.00,0.00,0.00),('1','142','799','257584',4903970,'2234','342',42756.79,42861.79,0.00,0.00,105.00,65100.00,0.00,0.00,0.00),('1','142','798','257585',4903971,'2231','342',32505.90,32796.30,0.00,0.00,290.40,188760.00,0.00,0.00,0.00),('1','142','799','257585',4903972,'2232','342',44767.32,45349.32,0.00,0.00,582.00,361001.40,0.00,0.00,0.00),('1','142','798','257585',4903973,'2233','342',29129.95,29441.73,0.00,0.00,311.78,202657.00,0.00,0.00,0.00),('1','142','799','257585',4903974,'2234','342',42861.79,43458.75,0.00,0.00,596.96,370115.20,0.00,0.00,0.00),('1','142','798','257586',4903975,'2231','342',32796.30,33163.84,0.00,0.00,367.54,238901.00,0.00,0.00,0.00),('1','142','799','257586',4903976,'2232','342',45349.32,46747.33,0.00,0.00,1398.01,866766.20,0.00,0.00,0.00),('1','142','798','257586',4903977,'2233','342',29441.73,29760.63,0.00,0.00,318.90,207285.00,0.00,0.00,0.00),('1','142','799','257586',4903978,'2234','342',43458.75,44676.49,0.00,0.00,1217.74,754998.80,0.00,0.00,0.00),('1','142','798','257587',4903979,'2231','342',33163.84,33554.30,0.00,0.00,390.46,253799.00,0.00,0.00,0.00),('1','142','799','257587',4903980,'2232','342',46747.33,47430.73,0.00,0.00,683.40,423708.00,0.00,0.00,0.00),('1','142','798','257587',4903981,'2233','342',29760.63,30128.86,0.00,0.00,368.23,239349.50,0.00,0.00,0.00),('1','142','799','257587',4903982,'2234','342',44676.49,45696.51,0.00,0.00,1020.02,632412.40,0.00,0.00,0.00),('1','142','798','257588',4903983,'2231','342',33554.30,34028.28,0.00,0.00,473.98,308087.00,0.00,0.00,0.00),('1','142','799','257588',4903984,'2232','342',47430.73,48779.13,0.00,0.00,1348.40,836008.00,0.00,0.00,0.00),('1','142','798','257588',4903985,'2233','342',30128.86,30568.77,0.00,0.00,439.91,285941.50,0.00,0.00,0.00),('1','142','799','257588',4903986,'2234','342',45696.51,46362.22,0.00,0.00,665.71,412740.50,0.00,0.00,0.00),('1','142','798','257589',4903987,'2231','342',34028.28,34315.74,0.00,0.00,287.46,186849.00,0.00,0.00,0.00),('1','142','799','257589',4903988,'2232','342',48779.13,49004.13,0.00,0.00,225.00,139569.30,0.00,0.00,0.00),('1','142','798','257589',4903989,'2233','342',30568.77,30914.22,0.00,0.00,345.45,224542.50,0.00,0.00,0.00),('1','142','799','257589',4903990,'2234','342',46362.22,46712.96,0.00,0.00,350.74,217458.80,0.00,0.00,0.00),('1','142','798','257590',4903991,'2231','342',34315.74,34730.53,0.00,0.00,414.79,269613.50,0.00,0.00,0.00),('1','142','799','257590',4903992,'2232','342',49004.13,49756.30,0.00,0.00,752.17,466345.40,0.00,0.00,0.00),('1','142','798','257590',4903993,'2233','342',30914.22,31280.50,0.00,0.00,366.28,238082.00,0.00,0.00,0.00),('1','142','799','257590',4903994,'2234','342',46712.96,47521.90,0.00,0.00,808.94,501542.80,0.00,0.00,0.00),('1','142','798','257591',4903995,'2231','342',34730.53,35183.04,0.00,0.00,452.51,294131.50,0.00,0.00,0.00),('1','142','799','257591',4903996,'2232','342',49756.30,51064.39,0.00,0.00,1308.09,811015.80,0.00,0.00,0.00),('1','142','798','257591',4903997,'2233','342',31280.50,31485.08,0.00,0.00,204.58,132977.00,0.00,0.00,0.00),('1','142','799','257591',4903998,'2234','342',47521.90,48329.66,0.00,0.00,807.76,500811.20,0.00,0.00,0.00),('1','142','798','257592',4903999,'2231','342',35183.04,35657.03,0.00,0.00,473.99,308093.50,0.00,0.00,0.00),('1','142','798','257592',4904000,'2233','342',31485.08,31732.02,0.00,0.00,246.94,160511.00,0.00,0.00,0.00),('1','142','799','257592',4904001,'2234','342',48329.66,48652.86,0.00,0.00,323.20,200384.00,0.00,0.00,0.00),('1','142','799','257592',4904002,'2232','342',51064.39,51420.39,0.00,0.00,356.00,220720.00,0.00,0.00,0.00),('1','142','798','257593',4904003,'2231','342',35657.03,36048.52,0.00,0.00,391.49,254468.50,0.00,0.00,0.00),('1','142','799','257593',4904004,'2232','342',51420.39,52225.14,0.00,0.00,804.75,498945.00,0.00,0.00,0.00),('1','142','798','257593',4904005,'2233','342',31732.02,32112.88,0.00,0.00,380.86,247559.00,0.00,0.00,0.00),('1','142','799','257593',4904006,'2234','342',48652.86,49383.93,0.00,0.00,731.07,453263.40,0.00,0.00,0.00),('1','142','798','257594',4904007,'2231','342',36048.52,36448.78,0.00,0.00,400.26,260169.00,0.00,0.00,0.00),('1','142','799','257594',4904008,'2232','342',52225.14,52914.64,0.00,0.00,689.50,427642.40,0.00,0.00,0.00),('1','142','798','257594',4904009,'2233','342',32112.88,32473.29,0.00,0.00,360.41,234266.50,0.00,0.00,0.00),('1','142','799','257594',4904010,'2234','342',49383.93,49990.14,0.00,0.00,606.21,375850.20,0.00,0.00,0.00),('1','142','798','257595',4904011,'2231','342',36448.78,36846.14,0.00,0.00,397.36,258284.00,0.00,0.00,0.00),('1','142','799','257595',4904012,'2232','342',52914.64,53097.58,0.00,0.00,182.94,113844.00,0.00,0.00,0.00),('1','142','798','257595',4904013,'2233','342',32473.29,33009.43,0.00,0.00,536.14,348491.00,0.00,0.00,0.00),('1','142','799','257595',4904014,'2234','342',49990.14,50090.14,0.00,0.00,100.00,62000.00,0.00,0.00,0.00),('1','142','798','257596',4904015,'2231','342',36846.14,37277.71,0.00,0.00,431.57,280520.50,0.00,0.00,0.00),('1','142','799','257596',4904016,'2232','342',53097.58,54301.67,0.00,0.00,1204.09,744915.62,0.00,0.00,0.00),('1','142','798','257596',4904017,'2233','342',33009.43,33413.36,0.00,0.00,403.93,262554.50,0.00,0.00,0.00),('1','142','799','257596',4904018,'2234','342',50090.14,51561.56,0.00,0.00,1471.42,910031.56,0.00,0.00,0.00),('1','142','798','257597',4904019,'2231','342',37277.71,37883.25,0.00,0.00,605.54,393601.00,0.00,0.00,0.00),('1','142','799','257597',4904020,'2232','342',54301.67,55045.88,0.00,0.00,744.21,461710.20,0.00,0.00,0.00),('1','142','798','257597',4904021,'2233','342',33413.36,33870.10,0.00,0.00,456.74,296881.00,0.00,0.00,0.00),('1','142','799','257597',4904022,'2234','342',51561.56,52543.50,0.00,0.00,981.94,608978.30,0.00,0.00,0.00),('1','142','798','257598',4904023,'2231','342',37883.25,38413.24,0.00,0.00,529.99,344493.50,0.00,0.00,0.00),('1','142','799','257598',4904024,'2232','342',55045.88,56181.72,0.00,0.00,1135.84,704400.80,0.00,0.00,0.00),('1','142','798','257598',4904025,'2233','342',33870.10,34242.96,0.00,0.00,372.86,242359.00,0.00,0.00,0.00),('1','142','799','257598',4904026,'2234','342',52543.50,53606.50,0.00,0.00,1063.00,659060.00,0.00,0.00,0.00),('1','142','798','257599',4904027,'2231','342',38413.24,38959.55,0.00,0.00,546.31,355101.50,0.00,0.00,0.00),('1','142','799','257599',4904028,'2232','342',56181.72,57730.04,0.00,0.00,1548.32,959958.40,0.00,0.00,0.00),('1','142','798','257599',4904029,'2233','342',34242.96,34687.27,0.00,0.00,444.31,288801.50,0.00,0.00,0.00),('1','142','799','257599',4904030,'2234','342',53606.50,55071.50,0.00,0.00,1465.00,908300.00,0.00,0.00,0.00),('1','142','798','257600',4904031,'2231','342',38959.55,39644.55,0.00,0.00,685.00,445250.00,0.00,0.00,0.00),('1','142','798','257600',4904032,'2233','342',34687.27,35070.46,0.00,0.00,383.19,249073.50,0.00,0.00,0.00),('1','142','799','257600',4904033,'2234','342',55071.50,55837.84,0.00,0.00,766.34,475130.80,0.00,0.00,0.00),('1','142','799','257600',4904034,'2232','342',57730.04,58178.04,0.00,0.00,448.00,277806.20,0.00,0.00,0.00),('1','142','798','257601',4904035,'2231','342',39644.55,39751.00,0.00,0.00,106.45,69192.50,0.00,0.00,0.00),('1','142','799','257601',4904036,'2232','342',58178.04,58178.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257601',4904037,'2233','342',35070.46,35077.06,0.00,0.00,6.60,4290.00,0.00,0.00,0.00),('1','142','799','257601',4904038,'2234','342',55837.84,55917.84,0.00,0.00,80.00,49600.00,0.00,0.00,0.00),('1','142','798','257602',4904039,'2231','342',39751.00,40342.08,0.00,0.00,591.08,384202.00,0.00,0.00,0.00),('1','142','798','257602',4904040,'2233','342',35077.06,35216.03,0.00,0.00,138.97,90330.50,0.00,0.00,0.00),('1','142','799','257602',4904041,'2234','342',55917.84,56902.97,0.00,0.00,985.13,610780.60,0.00,0.00,0.00),('1','142','799','257602',4904042,'2232','342',58178.04,59141.30,0.00,0.00,963.26,597221.20,0.00,0.00,0.00),('1','142','798','257603',4904043,'2231','342',40342.08,41196.36,0.00,0.00,854.28,555282.00,0.00,0.00,0.00),('1','142','799','257603',4904044,'2232','342',59141.30,60906.06,0.00,0.00,1764.76,1094151.20,0.00,0.00,0.00),('1','142','798','257603',4904045,'2233','342',35216.03,36232.72,0.00,0.00,1016.69,660848.50,0.00,0.00,0.00),('1','142','799','257603',4904046,'2234','342',56902.97,58700.55,0.00,0.00,1797.58,1114499.60,0.00,0.00,0.00),('1','142','798','257604',4904047,'2231','342',41196.36,41605.58,0.00,0.00,409.22,265993.00,0.00,0.00,0.00),('1','142','799','257604',4904048,'2232','342',60906.06,61687.33,0.00,0.00,781.27,484387.40,0.00,0.00,0.00),('1','142','798','257604',4904049,'2233','342',36232.72,36846.86,0.00,0.00,614.14,399191.00,0.00,0.00,0.00),('1','142','799','257604',4904050,'2234','342',58700.55,59487.26,0.00,0.00,786.71,487760.20,0.00,0.00,0.00),('1','142','798','257605',4904051,'2231','342',41605.58,41627.97,0.00,0.00,22.39,14553.50,0.00,0.00,0.00),('1','142','799','257605',4904052,'2232','342',61687.33,61687.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257605',4904053,'2233','342',36846.86,36960.15,0.00,0.00,113.29,73638.50,0.00,0.00,0.00),('1','142','799','257605',4904054,'2234','342',59487.26,59819.73,0.00,0.00,332.47,206131.40,0.00,0.00,0.00),('1','142','798','257606',4904055,'2231','342',41627.97,41883.57,0.00,0.00,255.60,166140.00,0.00,0.00,0.00),('1','142','799','257606',4904056,'2232','342',61687.33,62337.83,0.00,0.00,650.50,403310.00,0.00,0.00,0.00),('1','142','798','257606',4904057,'2233','342',36960.15,37179.34,0.00,0.00,219.19,142473.50,0.00,0.00,0.00),('1','142','799','257606',4904058,'2234','342',59819.73,60301.24,0.00,0.00,481.51,298536.20,0.00,0.00,0.00),('1','142','798','257607',4904059,'2231','342',41883.57,42197.45,0.00,0.00,313.88,204022.00,0.00,0.00,0.00),('1','142','799','257607',4904060,'2232','342',62337.83,63237.47,0.00,0.00,899.64,557776.80,0.00,0.00,0.00),('1','142','798','257607',4904061,'2233','342',37179.34,37687.53,0.00,0.00,508.19,330323.50,0.00,0.00,0.00),('1','142','799','257607',4904062,'2234','342',60301.24,61195.39,0.00,0.00,894.15,554373.00,0.00,0.00,0.00),('1','142','798','257608',4904063,'2231','342',42197.45,42734.26,0.00,0.00,536.81,348926.50,0.00,0.00,0.00),('1','142','799','257608',4904064,'2232','342',63237.47,64384.41,0.00,0.00,1146.94,711102.80,0.00,0.00,0.00),('1','142','798','257608',4904065,'2233','342',37687.53,37963.35,0.00,0.00,275.82,179283.00,0.00,0.00,0.00),('1','142','799','257608',4904066,'2234','342',61195.39,62230.91,0.00,0.00,1035.52,642022.40,0.00,0.00,0.00),('1','142','798','257609',4904067,'2231','342',42734.26,43351.29,0.00,0.00,617.03,401069.50,0.00,0.00,0.00),('1','142','799','257609',4904068,'2232','342',64384.41,65845.11,0.00,0.00,1460.70,905726.40,0.00,0.00,0.00),('1','142','798','257609',4904069,'2233','342',37963.35,38398.41,0.00,0.00,435.06,282789.00,0.00,0.00,0.00),('1','142','799','257609',4904070,'2234','342',62230.91,63395.46,0.00,0.00,1164.55,722021.00,0.00,0.00,0.00),('1','142','798','257610',4904071,'2231','342',43351.29,43733.17,0.00,0.00,381.88,248222.00,0.00,0.00,0.00),('1','142','799','257610',4904072,'2232','342',65845.11,66420.11,0.00,0.00,575.00,356500.00,0.00,0.00,0.00),('1','142','798','257610',4904073,'2233','342',38398.41,38762.79,0.00,0.00,364.38,236847.00,0.00,0.00,0.00),('1','142','799','257610',4904074,'2234','342',63395.46,64341.98,0.00,0.00,946.52,586842.40,0.00,0.00,0.00),('1','142','798','257611',4904075,'2231','342',43733.17,43803.76,0.00,0.00,70.59,45883.50,0.00,0.00,0.00),('1','142','799','257611',4904076,'2232','342',66420.11,66420.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257611',4904077,'2233','342',38762.79,38787.91,0.00,0.00,25.12,16328.00,0.00,0.00,0.00),('1','142','799','257611',4904078,'2234','342',64341.98,64396.71,0.00,0.00,54.73,33932.60,0.00,0.00,0.00),('1','142','798','257612',4904079,'2231','342',43803.76,43958.40,0.00,0.00,154.64,100516.00,0.00,0.00,0.00),('1','142','798','257612',4904080,'2233','342',38787.91,38920.89,0.00,0.00,132.98,86437.00,0.00,0.00,0.00),('1','142','799','257612',4904081,'2234','342',64396.71,64396.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257612',4904082,'2232','342',66420.11,66420.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257613',4904083,'2231','342',43958.40,44829.89,0.00,0.00,871.49,566468.50,0.00,0.00,0.00),('1','142','798','257613',4904084,'2233','342',38920.89,39722.59,0.00,0.00,801.70,509105.00,0.00,0.00,0.00),('1','142','799','257613',4904085,'2234','342',64396.71,64396.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257613',4904086,'2232','342',66420.11,66420.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257614',4904087,'2231','342',44829.89,45716.08,0.00,0.00,886.19,576023.50,0.00,0.00,0.00),('1','142','799','257614',4904088,'2232','342',66420.11,66420.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257614',4904089,'2233','342',39722.59,42065.56,0.00,0.00,2342.97,1456900.50,0.00,0.00,0.00),('1','142','799','257614',4904090,'2234','342',64396.71,64396.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257615',4904091,'2231','342',45716.08,46767.58,0.00,0.00,1051.50,683475.00,0.00,0.00,0.00),('1','142','799','257615',4904092,'2232','342',66420.11,66420.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257615',4904093,'2233','342',42065.56,44546.84,0.00,0.00,2481.28,1544807.00,0.00,0.00,0.00),('1','142','799','257615',4904094,'2234','342',64396.71,64396.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257616',4904095,'2231','342',46767.58,47479.86,0.00,0.00,712.28,462982.00,0.00,0.00,0.00),('1','142','799','257616',4904096,'2232','342',66420.11,66420.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257616',4904097,'2233','342',44546.84,46196.08,0.00,0.00,1649.24,1029466.00,0.00,0.00,0.00),('1','142','799','257616',4904098,'2234','342',64396.71,64396.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257617',4904099,'2231','342',47479.86,48019.40,0.00,0.00,539.54,350701.00,0.00,0.00,0.00),('1','142','799','257617',4904100,'2232','342',66420.11,67215.10,0.00,0.00,794.99,492893.80,0.00,0.00,0.00),('1','142','798','257617',4904101,'2233','342',46196.08,46708.46,0.00,0.00,512.38,331547.00,0.00,0.00,0.00),('1','142','799','257617',4904102,'2234','342',64396.71,64838.21,0.00,0.00,441.50,273730.00,0.00,0.00,0.00),('1','142','798','257618',4904103,'2231','342',48019.40,48550.80,0.00,0.00,531.40,345410.00,0.00,0.00,0.00),('1','142','799','257618',4904104,'2232','342',67215.10,69044.62,0.00,0.00,1829.52,1134302.40,0.00,0.00,0.00),('1','142','798','257618',4904105,'2233','342',46708.46,47046.45,0.00,0.00,337.99,219693.50,0.00,0.00,0.00),('1','142','799','257618',4904106,'2234','342',64838.21,66416.52,0.00,0.00,1578.31,978552.20,0.00,0.00,0.00),('1','142','798','257619',4904107,'2231','342',48550.80,49194.36,0.00,0.00,643.56,447917.76,0.00,0.00,0.00),('1','142','799','257619',4904108,'2232','342',69044.62,69118.42,0.00,0.00,73.80,48117.60,0.00,0.00,0.00),('1','142','798','257619',4904109,'2233','342',47046.45,47584.99,0.00,0.00,538.54,374823.84,0.00,0.00,0.00),('1','142','799','257619',4904110,'2234','342',66416.52,66661.00,0.00,0.00,244.48,159400.96,0.00,0.00,0.00),('1','142','798','257620',4904111,'2231','342',49194.36,49957.67,0.00,0.00,763.31,531263.76,0.00,0.00,0.00),('1','142','799','257620',4904112,'2232','342',69118.42,70373.43,0.00,0.00,1255.01,818266.52,0.00,0.00,0.00),('1','142','798','257620',4904113,'2233','342',47584.99,48100.38,0.00,0.00,515.39,358711.44,0.00,0.00,0.00),('1','142','799','257620',4904114,'2234','342',66661.00,67543.30,0.00,0.00,882.30,575259.60,0.00,0.00,0.00),('1','142','798','257621',4904115,'2231','342',49957.67,50663.80,0.00,0.00,706.13,491466.48,0.00,0.00,0.00),('1','142','799','257621',4904116,'2232','342',70373.43,71451.66,0.00,0.00,1078.23,703687.96,0.00,0.00,0.00),('1','142','798','257621',4904117,'2233','342',48100.38,48641.23,0.00,0.00,540.85,376431.60,0.00,0.00,0.00),('1','142','799','257621',4904118,'2234','342',67543.30,68316.83,0.00,0.00,773.53,504354.76,0.00,0.00,0.00),('1','142','798','257622',4904119,'2231','342',50663.80,51524.97,0.00,0.00,861.17,599374.32,0.00,0.00,0.00),('1','142','799','257622',4904120,'2232','342',71451.66,72115.82,0.00,0.00,664.16,433032.32,0.00,0.00,0.00),('1','142','798','257622',4904121,'2233','342',48641.23,49028.83,0.00,0.00,387.60,269769.60,0.00,0.00,0.00),('1','142','799','257622',4904122,'2234','342',68316.83,68730.02,0.00,0.00,413.19,269399.88,0.00,0.00,0.00),('1','142','798','257623',4904123,'2231','342',51524.97,52094.86,0.00,0.00,569.89,396643.44,0.00,0.00,0.00),('1','142','799','257623',4904124,'2232','342',72115.82,73325.46,0.00,0.00,1209.64,788938.28,0.00,0.00,0.00),('1','142','798','257623',4904125,'2233','342',49028.83,49445.99,0.00,0.00,417.16,290343.36,0.00,0.00,0.00),('1','142','799','257623',4904126,'2234','342',68730.02,69550.02,0.00,0.00,820.00,534640.00,0.00,0.00,0.00),('1','142','798','257624',4904127,'2231','342',52094.86,52633.66,0.00,0.00,538.80,375004.80,0.00,0.00,0.00),('1','142','799','257624',4904128,'2232','342',73325.46,73716.50,0.00,0.00,391.04,254958.08,0.00,0.00,0.00),('1','142','798','257624',4904129,'2233','342',49445.99,49779.30,0.00,0.00,333.31,231983.76,0.00,0.00,0.00),('1','142','799','257624',4904130,'2234','342',69550.02,69855.84,0.00,0.00,305.82,199394.64,0.00,0.00,0.00),('1','142','798','257625',4904131,'2231','342',52633.66,53406.65,0.00,0.00,772.99,538001.04,0.00,0.00,0.00),('1','142','799','257625',4904132,'2232','342',73716.50,73866.50,0.00,0.00,150.00,97800.00,0.00,0.00,0.00),('1','142','798','257625',4904133,'2233','342',49779.30,50394.69,0.00,0.00,615.39,428311.44,0.00,0.00,0.00),('1','142','799','257625',4904134,'2234','342',69855.84,70005.84,0.00,0.00,150.00,97800.00,0.00,0.00,0.00),('1','142','798','257626',4904135,'2231','342',53406.65,54109.63,0.00,0.00,702.98,489274.08,0.00,0.00,0.00),('1','142','799','257626',4904136,'2232','342',73866.50,74533.94,0.00,0.00,667.44,435435.32,0.00,0.00,0.00),('1','142','798','257626',4904137,'2233','342',50394.69,50857.13,0.00,0.00,462.44,321858.24,0.00,0.00,0.00),('1','142','799','257626',4904138,'2234','342',70005.84,70409.39,0.00,0.00,403.55,263114.60,0.00,0.00,0.00),('1','142','798','257627',4904139,'2231','342',54109.63,54413.13,0.00,0.00,303.50,211236.00,0.00,0.00,0.00),('1','142','799','257627',4904140,'2232','342',74533.94,75783.86,0.00,0.00,1249.92,814947.84,0.00,0.00,0.00),('1','142','798','257627',4904141,'2233','342',50857.13,51218.16,0.00,0.00,361.03,251276.88,0.00,0.00,0.00),('1','142','799','257627',4904142,'2234','342',70409.39,71101.02,0.00,0.00,691.63,450942.76,0.00,0.00,0.00),('1','142','798','257628',4904143,'2231','342',54413.13,54759.98,0.00,0.00,346.85,241407.60,0.00,0.00,0.00),('1','142','799','257628',4904144,'2232','342',75783.86,76405.74,0.00,0.00,621.88,405465.76,0.00,0.00,0.00),('1','142','798','257628',4904145,'2233','342',51218.16,51392.19,0.00,0.00,174.03,121124.88,0.00,0.00,0.00),('1','142','799','257628',4904146,'2234','342',71101.02,71883.06,0.00,0.00,782.04,509890.08,0.00,0.00,0.00),('1','142','798','257629',4904147,'2231','342',54759.98,55265.77,0.00,0.00,505.79,352029.84,0.00,0.00,0.00),('1','142','798','257629',4904148,'2233','342',51392.19,51781.29,0.00,0.00,389.10,270813.60,0.00,0.00,0.00),('1','142','799','257629',4904149,'2234','342',71883.06,72927.14,0.00,0.00,1044.08,680740.16,0.00,0.00,0.00),('1','142','799','257629',4904150,'2232','342',76405.74,77260.99,0.00,0.00,855.25,557623.00,0.00,0.00,0.00),('1','142','798','257630',4904151,'2231','342',55265.77,55683.15,0.00,0.00,417.38,308861.20,0.00,0.00,0.00),('1','142','799','257630',4904152,'2232','342',77260.99,77646.69,0.00,0.00,385.70,268447.20,0.00,0.00,0.00),('1','142','798','257630',4904153,'2233','342',51781.29,52399.14,0.00,0.00,617.85,457209.00,0.00,0.00,0.00),('1','142','799','257630',4904154,'2234','342',72927.14,73302.14,0.00,0.00,375.00,261000.00,0.00,0.00,0.00),('1','142','798','257631',4904155,'2231','342',55683.15,56231.50,0.00,0.00,548.35,405779.00,0.00,0.00,0.00),('1','142','799','257631',4904156,'2232','342',77646.69,77851.69,0.00,0.00,205.00,142680.00,0.00,0.00,0.00),('1','142','798','257631',4904157,'2233','342',52399.14,53034.80,0.00,0.00,635.66,470388.40,0.00,0.00,0.00),('1','142','799','257631',4904158,'2234','342',73302.14,73512.00,0.00,0.00,209.86,146062.56,0.00,0.00,0.00),('1','142','798','257632',4904159,'2231','342',56231.50,56748.60,0.00,0.00,517.10,382654.00,0.00,0.00,0.00),('1','142','799','257632',4904160,'2232','342',77851.69,78303.69,0.00,0.00,452.00,314592.00,0.00,0.00,0.00),('1','142','798','257632',4904161,'2233','342',53034.80,53740.22,0.00,0.00,705.42,522010.80,0.00,0.00,0.00),('1','142','799','257632',4904162,'2234','342',73512.00,73860.00,0.00,0.00,348.00,242208.00,0.00,0.00,0.00),('1','142','798','257633',4904163,'2231','342',56748.60,57617.78,0.00,0.00,869.18,643193.20,0.00,0.00,0.00),('1','142','799','257633',4904164,'2232','342',78303.69,78354.69,0.00,0.00,51.00,35496.00,0.00,0.00,0.00),('1','142','798','257633',4904165,'2233','342',53740.22,54388.84,0.00,0.00,648.62,479978.80,0.00,0.00,0.00),('1','142','799','257633',4904166,'2234','342',73860.00,73955.00,0.00,0.00,95.00,66120.00,0.00,0.00,0.00),('1','142','798','257634',4904167,'2231','342',57617.78,58623.20,0.00,0.00,1005.42,744010.80,0.00,0.00,0.00),('1','142','799','257634',4904168,'2232','342',78354.69,79365.23,0.00,0.00,1010.54,703335.84,0.00,0.00,0.00),('1','142','798','257634',4904169,'2233','342',54388.84,55271.86,0.00,0.00,883.02,653434.80,0.00,0.00,0.00),('1','142','799','257634',4904170,'2234','342',73955.00,74780.00,0.00,0.00,825.00,574200.00,0.00,0.00,0.00),('1','142','798','257635',4904171,'2231','342',58623.20,59598.50,0.00,0.00,975.30,721722.00,0.00,0.00,0.00),('1','142','799','257635',4904172,'2232','342',79365.23,81143.30,0.00,0.00,1778.07,1237536.72,0.00,0.00,0.00),('1','142','798','257635',4904173,'2233','342',55271.86,55945.28,0.00,0.00,673.42,498330.80,0.00,0.00,0.00),('1','142','799','257635',4904174,'2234','342',74780.00,76202.68,0.00,0.00,1422.68,990185.28,0.00,0.00,0.00),('1','142','798','257636',4904175,'2231','342',59598.50,60319.41,0.00,0.00,720.91,533473.40,0.00,0.00,0.00),('1','142','799','257636',4904176,'2232','342',81143.30,81446.30,0.00,0.00,303.00,210888.00,0.00,0.00,0.00),('1','142','798','257636',4904177,'2233','342',55945.28,56445.36,0.00,0.00,500.08,370059.20,0.00,0.00,0.00),('1','142','799','257636',4904178,'2234','342',76202.68,76260.18,0.00,0.00,57.50,40020.00,0.00,0.00,0.00),('1','142','798','257637',4904179,'2231','342',60319.41,60888.81,0.00,0.00,569.40,421356.00,0.00,0.00,0.00),('1','142','799','257637',4904180,'2232','342',81446.30,82495.37,0.00,0.00,1049.07,730372.72,0.00,0.00,0.00),('1','142','798','257637',4904181,'2233','342',56445.36,56850.90,0.00,0.00,405.54,300099.60,0.00,0.00,0.00),('1','142','799','257637',4904182,'2234','342',76260.18,77113.39,0.00,0.00,853.21,593834.16,0.00,0.00,0.00),('1','142','798','257638',4904183,'2231','342',60888.81,61359.67,0.00,0.00,470.86,348436.40,0.00,0.00,0.00),('1','142','799','257638',4904184,'2232','342',82495.37,83783.59,0.00,0.00,1288.22,897017.36,0.00,0.00,0.00),('1','142','798','257638',4904185,'2233','342',56850.90,57435.60,0.00,0.00,584.70,432678.00,0.00,0.00,0.00),('1','142','799','257638',4904186,'2234','342',77113.39,78304.17,0.00,0.00,1190.78,828782.88,0.00,0.00,0.00),('1','142','798','257639',4904187,'2231','342',61359.67,62289.05,0.00,0.00,929.38,687741.20,0.00,0.00,0.00),('1','142','799','257639',4904188,'2232','342',83783.59,84687.33,0.00,0.00,903.74,629003.04,0.00,0.00,0.00),('1','142','798','257639',4904189,'2233','342',57435.60,58045.14,0.00,0.00,609.54,451059.60,0.00,0.00,0.00),('1','142','799','257639',4904190,'2234','342',78304.17,78789.17,0.00,0.00,485.00,337560.00,0.00,0.00,0.00),('1','142','798','257640',4904191,'2231','342',62289.05,63090.22,0.00,0.00,801.17,592865.80,0.00,0.00,0.00),('1','142','799','257640',4904192,'2232','342',84687.33,85321.33,0.00,0.00,634.00,441264.00,0.00,0.00,0.00),('1','142','798','257640',4904193,'2233','342',58045.14,58654.39,0.00,0.00,609.25,450845.00,0.00,0.00,0.00),('1','142','799','257640',4904194,'2234','342',78789.17,79028.17,0.00,0.00,239.00,166344.00,0.00,0.00,0.00),('1','142','798','257641',4904195,'2231','342',63090.22,63733.56,0.00,0.00,643.34,476071.60,0.00,0.00,0.00),('1','142','799','257641',4904196,'2232','342',85321.33,87041.79,0.00,0.00,1720.46,1197440.16,0.00,0.00,0.00),('1','142','798','257641',4904197,'2233','342',58654.39,59183.07,0.00,0.00,528.68,391223.20,0.00,0.00,0.00),('1','142','799','257641',4904198,'2234','342',79028.17,79929.47,0.00,0.00,901.30,627304.80,0.00,0.00,0.00),('1','142','798','257642',4904199,'2231','342',63733.56,64430.66,0.00,0.00,697.10,515854.00,0.00,0.00,0.00),('1','142','799','257642',4904200,'2232','342',87041.79,87206.79,0.00,0.00,165.00,114840.00,0.00,0.00,0.00),('1','142','798','257642',4904201,'2233','342',59183.07,59838.14,0.00,0.00,655.07,484751.80,0.00,0.00,0.00),('1','142','799','257642',4904202,'2234','342',79929.47,80089.47,0.00,0.00,160.00,111360.00,0.00,0.00,0.00),('1','142','798','257643',4904203,'2231','342',64430.66,64523.32,0.00,0.00,92.66,68568.40,0.00,0.00,0.00),('1','142','798','257643',4904204,'2233','342',59838.14,60017.34,0.00,0.00,179.20,132608.00,0.00,0.00,0.00),('1','142','799','257643',4904205,'2234','342',80089.47,80199.47,0.00,0.00,110.00,76560.00,0.00,0.00,0.00),('1','142','799','257643',4904206,'2232','342',87206.79,87356.79,0.00,0.00,150.00,106600.00,0.00,0.00,0.00),('1','142','798','257644',4904207,'2231','342',64523.32,65029.27,0.00,0.00,505.95,389581.50,0.00,0.00,0.00),('1','142','799','257644',4904208,'2232','342',87356.79,87616.79,0.00,0.00,260.00,187200.00,0.00,0.00,0.00),('1','142','798','257644',4904209,'2233','342',60017.34,60426.17,0.00,0.00,408.83,314799.10,0.00,0.00,0.00),('1','142','799','257644',4904210,'2234','342',80199.47,80420.80,0.00,0.00,221.33,159357.60,0.00,0.00,0.00),('1','142','798','257645',4904211,'2231','342',65029.27,65630.28,0.00,0.00,601.01,462777.70,0.00,0.00,0.00),('1','142','799','257645',4904212,'2232','342',87616.79,87616.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257645',4904213,'2233','342',60426.17,60833.85,0.00,0.00,407.68,313913.60,0.00,0.00,0.00),('1','142','799','257645',4904214,'2234','342',80420.80,80479.80,0.00,0.00,59.00,42480.00,0.00,0.00,0.00),('1','142','798','257646',4904215,'2231','342',65630.28,66114.61,0.00,0.00,484.33,372934.10,0.00,0.00,0.00),('1','142','799','257646',4904216,'2232','342',87616.79,87616.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257646',4904217,'2233','342',60833.85,61485.19,0.00,0.00,651.34,501531.80,0.00,0.00,0.00),('1','142','799','257646',4904218,'2234','342',80479.80,80529.80,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','142','798','257647',4904219,'2231','342',66114.61,66483.17,0.00,0.00,368.56,283791.20,0.00,0.00,0.00),('1','142','798','257647',4904220,'2233','342',61485.19,62103.48,0.00,0.00,618.29,476083.30,0.00,0.00,0.00),('1','142','799','257647',4904221,'2234','342',80529.80,80529.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257647',4904222,'2232','342',87616.79,87766.79,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','142','798','257648',4904223,'2231','342',66483.17,67069.88,0.00,0.00,586.71,451766.70,0.00,0.00,0.00),('1','142','799','257648',4904224,'2232','342',87766.79,88521.79,0.00,0.00,755.00,541485.00,0.00,0.00,0.00),('1','142','798','257648',4904225,'2233','342',62103.48,62602.33,0.00,0.00,498.85,384114.50,0.00,0.00,0.00),('1','142','799','257648',4904226,'2234','342',80529.80,81122.30,0.00,0.00,592.50,424822.50,0.00,0.00,0.00),('1','142','798','257649',4904227,'2231','342',67069.88,67616.25,0.00,0.00,546.37,420704.90,0.00,0.00,0.00),('1','142','799','257649',4904228,'2232','342',88521.79,88521.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257649',4904229,'2233','342',62602.33,63215.84,0.00,0.00,613.51,472402.70,0.00,0.00,0.00),('1','142','799','257649',4904230,'2234','342',81122.30,81122.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257650',4904231,'2231','342',67616.25,68267.77,0.00,0.00,651.52,501670.40,0.00,0.00,0.00),('1','142','799','257650',4904232,'2232','342',88521.79,88521.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257650',4904233,'2233','342',63215.84,63913.06,0.00,0.00,697.22,536859.40,0.00,0.00,0.00),('1','142','799','257650',4904234,'2234','342',81122.30,81122.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257651',4904235,'2231','342',68267.77,69029.37,0.00,0.00,761.60,586432.00,0.00,0.00,0.00),('1','142','798','257651',4904236,'2233','342',63913.06,64665.81,0.00,0.00,752.75,579617.50,0.00,0.00,0.00),('1','142','799','257651',4904237,'2234','342',81122.30,81283.30,0.00,0.00,161.00,115920.00,0.00,0.00,0.00),('1','142','799','257651',4904238,'2232','342',88521.79,88729.79,0.00,0.00,208.00,149760.00,0.00,0.00,0.00),('1','142','798','257652',4904239,'2231','342',69029.37,69583.85,0.00,0.00,554.48,426949.60,0.00,0.00,0.00),('1','142','799','257652',4904240,'2232','342',88729.79,89277.01,0.00,0.00,547.22,392498.40,0.00,0.00,0.00),('1','142','798','257652',4904241,'2233','342',64665.81,65218.64,0.00,0.00,552.83,425679.10,0.00,0.00,0.00),('1','142','799','257652',4904242,'2234','342',81283.30,81783.30,0.00,0.00,500.00,358500.00,0.00,0.00,0.00),('1','142','798','257653',4904243,'2231','342',69583.85,70382.18,0.00,0.00,798.33,614714.10,0.00,0.00,0.00),('1','142','799','257653',4904244,'2232','342',89277.01,89322.01,0.00,0.00,45.00,32400.00,0.00,0.00,0.00),('1','142','798','257653',4904245,'2233','342',65218.64,65890.16,0.00,0.00,671.52,517070.40,0.00,0.00,0.00),('1','142','799','257653',4904246,'2234','342',81783.30,81828.30,0.00,0.00,45.00,32400.00,0.00,0.00,0.00),('1','142','798','257654',4904247,'2231','342',70382.18,70382.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257654',4904248,'2232','342',89322.01,89322.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257654',4904249,'2233','342',65890.16,65890.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257654',4904250,'2234','342',81828.30,81828.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257655',4904251,'2231','342',70382.18,70975.23,0.00,0.00,593.05,456648.50,0.00,0.00,0.00),('1','142','799','257655',4904252,'2232','342',89322.01,89322.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257655',4904253,'2233','342',65890.16,66421.83,0.00,0.00,531.67,409385.90,0.00,0.00,0.00),('1','142','799','257655',4904254,'2234','342',81828.30,81828.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257656',4904255,'2231','342',70975.23,71497.01,0.00,0.00,521.78,401770.60,0.00,0.00,0.00),('1','142','799','257656',4904256,'2232','342',89322.01,89322.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257656',4904257,'2233','342',66421.83,66826.33,0.00,0.00,404.50,311465.00,0.00,0.00,0.00),('1','142','799','257656',4904258,'2234','342',81828.30,81828.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257657',4904259,'2231','342',71497.01,72011.49,0.00,0.00,514.48,396149.60,0.00,0.00,0.00),('1','142','799','257657',4904260,'2232','342',89322.01,89627.01,0.00,0.00,305.00,219600.00,0.00,0.00,0.00),('1','142','798','257657',4904261,'2233','342',66826.33,67501.33,0.00,0.00,675.00,519750.00,0.00,0.00,0.00),('1','142','799','257657',4904262,'2234','342',81828.30,81883.30,0.00,0.00,55.00,39600.00,0.00,0.00,0.00),('1','142','798','257658',4904263,'2231','342',72011.49,72773.75,0.00,0.00,762.26,586940.20,0.00,0.00,0.00),('1','142','799','257658',4904264,'2232','342',89627.01,89968.16,0.00,0.00,341.15,245091.80,0.00,0.00,0.00),('1','142','798','257658',4904265,'2233','342',67501.33,68235.58,0.00,0.00,734.25,565372.50,0.00,0.00,0.00),('1','142','799','257658',4904266,'2234','342',81883.30,82302.96,0.00,0.00,419.66,301076.22,0.00,0.00,0.00),('1','142','798','257659',4904267,'2231','342',72773.75,73350.15,0.00,0.00,576.40,443828.00,0.00,0.00,0.00),('1','142','798','257659',4904268,'2233','342',68235.58,68829.35,0.00,0.00,593.77,457202.90,0.00,0.00,0.00),('1','142','799','257659',4904269,'2234','342',82302.96,82302.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257659',4904270,'2232','342',89968.16,90073.16,0.00,0.00,105.00,75600.00,0.00,0.00,0.00),('1','142','798','257660',4904271,'2231','342',73350.15,74014.31,0.00,0.00,664.16,511403.20,0.00,0.00,0.00),('1','142','799','257660',4904272,'2232','342',90073.16,90073.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257660',4904273,'2233','342',68829.35,69254.83,0.00,0.00,425.48,327619.60,0.00,0.00,0.00),('1','142','799','257660',4904274,'2234','342',82302.96,82302.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257661',4904275,'2231','342',74014.31,74549.13,0.00,0.00,534.82,411811.40,0.00,0.00,0.00),('1','142','799','257661',4904276,'2232','342',90073.16,90073.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257661',4904277,'2233','342',69254.83,69793.69,0.00,0.00,538.86,414922.20,0.00,0.00,0.00),('1','142','799','257661',4904278,'2234','342',82302.96,82302.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257662',4904279,'2231','342',74549.13,75173.27,0.00,0.00,624.14,480587.80,0.00,0.00,0.00),('1','142','799','257662',4904280,'2232','342',90073.16,90073.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257662',4904281,'2233','342',69793.69,70306.44,0.00,0.00,512.75,394817.50,0.00,0.00,0.00),('1','142','799','257662',4904282,'2234','342',82302.96,82302.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257663',4904283,'2231','342',75173.27,75731.78,0.00,0.00,558.51,430052.70,0.00,0.00,0.00),('1','142','799','257663',4904284,'2232','342',90073.16,90174.20,0.00,0.00,101.04,72748.80,0.00,0.00,0.00),('1','142','798','257663',4904285,'2233','342',70306.44,70789.23,0.00,0.00,482.79,371748.30,0.00,0.00,0.00),('1','142','799','257663',4904286,'2234','342',82302.96,82382.96,0.00,0.00,80.00,57600.00,0.00,0.00,0.00),('1','142','798','257664',4904287,'2231','342',75731.78,76371.31,0.00,0.00,639.53,492438.10,0.00,0.00,0.00),('1','142','799','257664',4904288,'2232','342',90174.20,90441.42,0.00,0.00,267.22,192398.40,0.00,0.00,0.00),('1','142','798','257664',4904289,'2233','342',70789.23,71510.31,0.00,0.00,721.08,555231.60,0.00,0.00,0.00),('1','142','799','257664',4904290,'2234','342',82382.96,82657.96,0.00,0.00,275.00,198000.00,0.00,0.00,0.00),('1','142','798','257665',4904291,'2231','342',76371.31,77166.07,0.00,0.00,794.76,611965.20,0.00,0.00,0.00),('1','142','799','257665',4904292,'2232','342',90441.42,90948.40,0.00,0.00,506.98,364069.66,0.00,0.00,0.00),('1','142','798','257665',4904293,'2233','342',71510.31,72262.40,0.00,0.00,752.09,579109.30,0.00,0.00,0.00),('1','142','799','257665',4904294,'2234','342',82657.96,83045.98,0.00,0.00,388.02,278210.34,0.00,0.00,0.00),('1','142','798','257666',4904295,'2231','342',77166.07,77939.86,0.00,0.00,773.79,595818.30,0.00,0.00,0.00),('1','142','798','257666',4904296,'2233','342',72262.40,72877.32,0.00,0.00,614.92,473488.40,0.00,0.00,0.00),('1','142','799','257666',4904297,'2234','342',83045.98,83145.98,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','142','799','257666',4904298,'2232','342',90948.40,91028.40,0.00,0.00,80.00,57600.00,0.00,0.00,0.00),('1','142','798','257667',4904299,'2231','342',77939.86,78728.24,0.00,0.00,788.38,607052.60,0.00,0.00,0.00),('1','142','799','257667',4904300,'2232','342',91028.40,91099.40,0.00,0.00,71.00,51120.00,0.00,0.00,0.00),('1','142','798','257667',4904301,'2233','342',72877.32,73842.44,0.00,0.00,965.12,743142.40,0.00,0.00,0.00),('1','142','799','257667',4904302,'2234','342',83145.98,83145.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257668',4904303,'2231','342',78728.24,79427.92,0.00,0.00,699.68,538753.60,0.00,0.00,0.00),('1','142','799','257668',4904304,'2232','342',91099.40,91099.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257668',4904305,'2233','342',73842.44,74718.87,0.00,0.00,876.43,674851.10,0.00,0.00,0.00),('1','142','799','257668',4904306,'2234','342',83145.98,83194.83,0.00,0.00,48.85,35172.00,0.00,0.00,0.00),('1','142','798','257669',4904307,'2231','342',79427.92,80308.38,0.00,0.00,880.46,677954.20,0.00,0.00,0.00),('1','142','799','257669',4904308,'2232','342',91099.40,91559.12,0.00,0.00,459.72,329675.40,0.00,0.00,0.00),('1','142','798','257669',4904309,'2233','342',74718.87,75180.87,0.00,0.00,462.00,355740.00,0.00,0.00,0.00),('1','142','799','257669',4904310,'2234','342',83194.83,83844.83,0.00,0.00,650.00,466050.00,0.00,0.00,0.00),('1','142','798','257670',4904311,'2231','342',80308.38,80963.64,0.00,0.00,655.26,504550.20,0.00,0.00,0.00),('1','142','799','257670',4904312,'2232','342',91559.12,91844.12,0.00,0.00,285.00,205200.00,0.00,0.00,0.00),('1','142','798','257670',4904313,'2233','342',75180.87,75632.27,0.00,0.00,451.40,347578.00,0.00,0.00,0.00),('1','142','799','257670',4904314,'2234','342',83844.83,84164.83,0.00,0.00,320.00,230400.00,0.00,0.00,0.00),('1','142','798','257671',4904315,'2231','342',80963.64,81661.73,0.00,0.00,698.09,537529.30,0.00,0.00,0.00),('1','142','799','257671',4904316,'2232','342',91844.12,91986.88,0.00,0.00,142.76,102814.20,0.00,0.00,0.00),('1','142','798','257671',4904317,'2233','342',75632.27,76168.13,0.00,0.00,535.86,412612.20,0.00,0.00,0.00),('1','142','799','257671',4904318,'2234','342',84164.83,84174.55,0.00,0.00,9.72,6998.40,0.00,0.00,0.00),('1','142','798','257672',4904319,'2231','342',81661.73,82590.14,0.00,0.00,928.41,714875.70,0.00,0.00,0.00),('1','142','799','257672',4904320,'2232','342',91986.88,92295.88,0.00,0.00,309.00,222480.00,0.00,0.00,0.00),('1','142','798','257672',4904321,'2233','342',76168.13,76805.27,0.00,0.00,637.14,490597.80,0.00,0.00,0.00),('1','142','799','257672',4904322,'2234','342',84174.55,84304.55,0.00,0.00,130.00,93600.00,0.00,0.00,0.00),('1','142','798','257673',4904323,'2231','342',82590.14,83688.55,0.00,0.00,1098.41,845775.70,0.00,0.00,0.00),('1','142','799','257673',4904324,'2232','342',92295.88,92515.88,0.00,0.00,220.00,158400.00,0.00,0.00,0.00),('1','142','798','257673',4904325,'2233','342',76805.27,77831.15,0.00,0.00,1025.88,789927.60,0.00,0.00,0.00),('1','142','799','257673',4904326,'2234','342',84304.55,84459.55,0.00,0.00,155.00,111600.00,0.00,0.00,0.00),('1','142','798','257674',4904327,'2231','342',83688.55,84863.53,0.00,0.00,1174.98,904734.60,0.00,0.00,0.00),('1','142','799','257674',4904328,'2232','342',92515.88,93973.68,0.00,0.00,1457.80,1049616.00,0.00,0.00,0.00),('1','142','798','257674',4904329,'2233','342',77831.15,79055.19,0.00,0.00,1224.04,942510.80,0.00,0.00,0.00),('1','142','799','257674',4904330,'2234','342',84459.55,85992.33,0.00,0.00,1532.78,1103601.60,0.00,0.00,0.00),('1','142','798','257675',4904331,'2231','342',84863.53,84975.61,0.00,0.00,112.08,86301.60,0.00,0.00,0.00),('1','142','798','257675',4904332,'2233','342',79055.19,79189.98,0.00,0.00,134.79,103788.30,0.00,0.00,0.00),('1','142','799','257675',4904333,'2234','342',85992.33,86052.32,0.00,0.00,59.99,43192.80,0.00,0.00,0.00),('1','142','799','257675',4904334,'2232','342',93973.68,94035.68,0.00,0.00,62.00,44640.00,0.00,0.00,0.00),('1','142','798','257676',4904335,'2231','342',84975.61,84975.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257676',4904336,'2232','342',94035.68,94713.59,0.00,0.00,677.91,488095.20,0.00,0.00,0.00),('1','142','798','257676',4904337,'2233','342',79189.98,79869.90,0.00,0.00,679.92,523538.40,0.00,0.00,0.00),('1','142','799','257676',4904338,'2234','342',86052.32,86585.41,0.00,0.00,533.09,383824.80,0.00,0.00,0.00),('1','142','798','257677',4904339,'2231','342',84975.61,85890.65,0.00,0.00,915.04,704580.80,0.00,0.00,0.00),('1','142','799','257677',4904340,'2232','342',94713.59,95529.03,0.00,0.00,815.44,587116.80,0.00,0.00,0.00),('1','142','798','257677',4904341,'2233','342',79869.90,79872.90,0.00,0.00,3.00,2310.00,0.00,0.00,0.00),('1','142','799','257677',4904342,'2234','342',86585.41,87734.57,0.00,0.00,1149.16,827398.20,0.00,0.00,0.00),('1','142','798','257678',4904343,'2231','342',85890.65,86451.47,0.00,0.00,560.82,431831.40,0.00,0.00,0.00),('1','142','799','257678',4904344,'2232','342',95529.03,95838.85,0.00,0.00,309.82,225546.40,0.00,0.00,0.00),('1','142','798','257678',4904345,'2233','342',79872.90,80496.02,0.00,0.00,623.12,479802.40,0.00,0.00,0.00),('1','142','799','257678',4904346,'2234','342',87734.57,88034.25,0.00,0.00,299.68,220753.60,0.00,0.00,0.00),('1','142','798','257679',4904347,'2231','342',86451.47,87103.25,0.00,0.00,651.78,501870.60,0.00,0.00,0.00),('1','142','799','257679',4904348,'2232','342',95838.85,96180.85,0.00,0.00,342.00,246240.00,0.00,0.00,0.00),('1','142','798','257679',4904349,'2233','342',80496.02,81230.62,0.00,0.00,734.60,565642.00,0.00,0.00,0.00),('1','142','799','257679',4904350,'2234','342',88034.25,88606.25,0.00,0.00,572.00,411840.00,0.00,0.00,0.00),('1','142','798','257680',4904351,'2231','342',87103.25,87722.09,0.00,0.00,618.84,476506.80,0.00,0.00,0.00),('1','142','799','257680',4904352,'2232','342',96180.85,96380.85,0.00,0.00,200.00,144000.00,0.00,0.00,0.00),('1','142','798','257680',4904353,'2233','342',81230.62,81761.95,0.00,0.00,531.33,409124.10,0.00,0.00,0.00),('1','142','799','257680',4904354,'2234','342',88606.25,89041.75,0.00,0.00,435.50,313560.00,0.00,0.00,0.00),('1','142','798','257681',4904355,'2231','342',87722.09,88301.45,0.00,0.00,579.36,446107.20,0.00,0.00,0.00),('1','142','799','257681',4904356,'2232','342',96380.85,96634.15,0.00,0.00,253.30,183058.00,0.00,0.00,0.00),('1','142','798','257681',4904357,'2233','342',81761.95,82217.08,0.00,0.00,455.13,350450.10,0.00,0.00,0.00),('1','142','799','257681',4904358,'2234','342',89041.75,89370.96,0.00,0.00,329.21,237778.20,0.00,0.00,0.00),('1','142','798','257682',4904359,'2231','342',88301.45,88973.52,0.00,0.00,672.07,517493.90,0.00,0.00,0.00),('1','142','799','257682',4904360,'2232','342',96634.15,96646.49,0.00,0.00,12.34,8884.80,0.00,0.00,0.00),('1','142','798','257682',4904361,'2233','342',82217.08,82955.91,0.00,0.00,738.83,568899.10,0.00,0.00,0.00),('1','142','799','257682',4904362,'2234','342',89370.96,89370.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257683',4904363,'2231','342',88973.52,89648.02,0.00,0.00,674.50,519365.00,0.00,0.00,0.00),('1','142','799','257683',4904364,'2232','342',96646.49,97146.51,0.00,0.00,500.02,359014.36,0.00,0.00,0.00),('1','142','798','257683',4904365,'2233','342',82955.91,83713.18,0.00,0.00,757.27,583097.90,0.00,0.00,0.00),('1','142','799','257683',4904366,'2234','342',89370.96,89889.08,0.00,0.00,518.12,372010.16,0.00,0.00,0.00),('1','142','798','257684',4904367,'2231','342',89648.02,90332.00,0.00,0.00,683.98,526664.60,0.00,0.00,0.00),('1','142','799','257684',4904368,'2232','342',97146.51,97186.51,0.00,0.00,40.00,28800.00,0.00,0.00,0.00),('1','142','798','257684',4904369,'2233','342',83713.18,84448.68,0.00,0.00,735.50,566335.00,0.00,0.00,0.00),('1','142','799','257684',4904370,'2234','342',89889.08,89967.58,0.00,0.00,78.50,56520.00,0.00,0.00,0.00),('1','142','798','257685',4904371,'2231','342',90332.00,90904.64,0.00,0.00,572.64,440932.80,0.00,0.00,0.00),('1','142','799','257685',4904372,'2232','342',97186.51,97406.51,0.00,0.00,220.00,158400.00,0.00,0.00,0.00),('1','142','798','257685',4904373,'2233','342',84448.68,85107.45,0.00,0.00,658.77,507252.90,0.00,0.00,0.00),('1','142','799','257685',4904374,'2234','342',89967.58,90351.87,0.00,0.00,384.29,276688.80,0.00,0.00,0.00),('1','142','798','257686',4904375,'2231','342',90904.64,91829.46,0.00,0.00,924.82,712111.40,0.00,0.00,0.00),('1','142','799','257686',4904376,'2232','342',97406.51,97406.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257686',4904377,'2233','342',85107.45,85674.35,0.00,0.00,566.90,436513.00,0.00,0.00,0.00),('1','142','799','257686',4904378,'2234','342',90351.87,90447.70,0.00,0.00,95.83,68997.60,0.00,0.00,0.00),('1','142','798','257687',4904379,'2231','342',91829.46,92885.69,0.00,0.00,1056.23,813297.10,0.00,0.00,0.00),('1','142','799','257687',4904380,'2232','342',97406.51,97451.51,0.00,0.00,45.00,32400.00,0.00,0.00,0.00),('1','142','798','257687',4904381,'2233','342',85674.35,85674.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257687',4904382,'2234','342',90447.70,90458.81,0.00,0.00,11.11,7999.20,0.00,0.00,0.00),('1','142','798','257688',4904383,'2231','342',92885.69,93324.30,0.00,0.00,438.61,337729.70,0.00,0.00,0.00),('1','142','799','257688',4904384,'2232','342',97451.51,97551.51,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','142','798','257688',4904385,'2233','342',85674.35,86168.26,0.00,0.00,493.91,380310.70,0.00,0.00,0.00),('1','142','799','257688',4904386,'2234','342',90458.81,90496.31,0.00,0.00,37.50,27000.00,0.00,0.00,0.00),('1','142','798','257689',4904387,'2231','342',93324.30,93324.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257689',4904388,'2232','342',97551.51,97759.51,0.00,0.00,208.00,149760.00,0.00,0.00,0.00),('1','142','798','257689',4904389,'2233','342',86168.26,87427.04,0.00,0.00,1258.78,969260.60,0.00,0.00,0.00),('1','142','799','257689',4904390,'2234','342',90496.31,90908.81,0.00,0.00,412.50,297000.00,0.00,0.00,0.00),('1','142','798','257690',4904391,'2231','342',93324.30,94198.51,0.00,0.00,874.21,673141.70,0.00,0.00,0.00),('1','142','799','257690',4904392,'2232','342',97759.51,98112.51,0.00,0.00,353.00,254160.00,0.00,0.00,0.00),('1','142','798','257690',4904393,'2233','342',87427.04,88165.83,0.00,0.00,738.79,568868.30,0.00,0.00,0.00),('1','142','799','257690',4904394,'2234','342',90908.81,91108.81,0.00,0.00,200.00,144000.00,0.00,0.00,0.00),('1','142','798','257691',4904395,'2231','342',94198.51,94946.03,0.00,0.00,747.52,575590.40,0.00,0.00,0.00),('1','142','799','257691',4904396,'2232','342',98112.51,98437.41,0.00,0.00,324.90,233928.00,0.00,0.00,0.00),('1','142','798','257691',4904397,'2233','342',88165.83,88515.13,0.00,0.00,349.30,268961.00,0.00,0.00,0.00),('1','142','799','257691',4904398,'2234','342',91108.81,91248.81,0.00,0.00,140.00,100800.00,0.00,0.00,0.00),('1','142','798','257692',4904399,'2231','342',94946.03,95580.17,0.00,0.00,634.14,488287.80,0.00,0.00,0.00),('1','142','799','257692',4904400,'2232','342',98437.41,98687.41,0.00,0.00,250.00,180000.00,0.00,0.00,0.00),('1','142','798','257692',4904401,'2233','342',88515.13,89439.26,0.00,0.00,924.13,711580.10,0.00,0.00,0.00),('1','142','799','257692',4904402,'2234','342',91248.81,91528.81,0.00,0.00,280.00,201600.00,0.00,0.00,0.00),('1','142','798','257693',4904403,'2231','342',95580.17,96678.50,0.00,0.00,1098.33,845714.10,0.00,0.00,0.00),('1','142','799','257693',4904404,'2232','342',98687.41,98887.41,0.00,0.00,200.00,144000.00,0.00,0.00,0.00),('1','142','798','257693',4904405,'2233','342',89439.26,89439.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257693',4904406,'2234','342',91528.81,91778.84,0.00,0.00,250.03,180021.60,0.00,0.00,0.00),('1','142','798','257694',4904407,'2231','342',96678.50,97303.43,0.00,0.00,624.93,481196.10,0.00,0.00,0.00),('1','142','799','257694',4904408,'2232','342',98887.41,99236.41,0.00,0.00,349.00,251280.00,0.00,0.00,0.00),('1','142','798','257694',4904409,'2233','342',89439.26,90043.63,0.00,0.00,604.37,465364.90,0.00,0.00,0.00),('1','142','799','257694',4904410,'2234','342',91778.84,92243.84,0.00,0.00,465.00,334800.00,0.00,0.00,0.00),('1','142','798','257695',4904411,'2231','342',97303.43,97691.66,0.00,0.00,388.23,298937.10,0.00,0.00,0.00),('1','142','799','257695',4904412,'2232','342',99236.41,99261.41,0.00,0.00,25.00,18000.00,0.00,0.00,0.00),('1','142','798','257695',4904413,'2233','342',90043.63,91074.47,0.00,0.00,1030.84,793746.80,0.00,0.00,0.00),('1','142','799','257695',4904414,'2234','342',92243.84,92293.84,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','142','798','257696',4904415,'2231','342',97691.66,98279.77,0.00,0.00,588.11,452844.70,0.00,0.00,0.00),('1','142','799','257696',4904416,'2232','342',99261.41,99261.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257696',4904417,'2233','342',91074.47,91699.83,0.00,0.00,625.36,481527.20,0.00,0.00,0.00),('1','142','799','257696',4904418,'2234','342',92293.84,92404.23,0.00,0.00,110.39,79480.80,0.00,0.00,0.00),('1','142','798','257697',4904419,'2231','342',98279.77,99003.60,0.00,0.00,723.83,557349.10,0.00,0.00,0.00),('1','142','799','257697',4904420,'2232','342',99261.41,99761.41,0.00,0.00,500.00,360000.00,0.00,0.00,0.00),('1','142','798','257697',4904421,'2233','342',91699.83,92515.33,0.00,0.00,815.50,627935.00,0.00,0.00,0.00),('1','142','799','257697',4904422,'2234','342',92404.23,92904.23,0.00,0.00,500.00,360000.00,0.00,0.00,0.00),('1','142','798','257698',4904423,'2231','342',99003.60,99994.07,0.00,0.00,990.47,762661.90,0.00,0.00,0.00),('1','142','799','257698',4904424,'2232','342',99761.41,99761.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257698',4904425,'2233','342',92515.33,93276.66,0.00,0.00,761.33,586224.10,0.00,0.00,0.00),('1','142','799','257698',4904426,'2234','342',92904.23,92933.29,0.00,0.00,29.06,20923.20,0.00,0.00,0.00),('1','142','798','257699',4904427,'2231','342',99994.07,100828.51,0.00,0.00,834.44,642518.80,0.00,0.00,0.00),('1','142','799','257699',4904428,'2232','342',99761.41,99765.41,0.00,0.00,4.00,2880.00,0.00,0.00,0.00),('1','142','798','257699',4904429,'2233','342',93276.66,94012.56,0.00,0.00,735.90,566643.00,0.00,0.00,0.00),('1','142','799','257699',4904430,'2234','342',92933.29,92978.29,0.00,0.00,45.00,32400.00,0.00,0.00,0.00),('1','142','798','257700',4904431,'2231','342',100828.51,101661.31,0.00,0.00,832.80,641256.00,0.00,0.00,0.00),('1','142','799','257700',4904432,'2232','342',99765.41,99865.41,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','142','798','257700',4904433,'2233','342',94012.56,94166.14,0.00,0.00,153.58,118256.60,0.00,0.00,0.00),('1','142','799','257700',4904434,'2234','342',92978.29,93343.10,0.00,0.00,364.81,276528.70,0.00,0.00,0.00),('1','142','798','257701',4904435,'2231','342',101661.31,102501.00,0.00,0.00,839.69,646561.30,0.00,0.00,0.00),('1','142','799','257701',4904436,'2232','342',99865.41,99915.41,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','142','798','257701',4904437,'2233','342',94166.14,94633.76,0.00,0.00,467.62,360067.40,0.00,0.00,0.00),('1','142','799','257701',4904438,'2234','342',93343.10,94214.32,0.00,0.00,871.22,670839.40,0.00,0.00,0.00),('1','142','798','257702',4904439,'2231','342',102501.00,103367.57,0.00,0.00,866.57,667258.90,0.00,0.00,0.00),('1','142','799','257702',4904440,'2232','342',99915.41,100606.41,0.00,0.00,691.00,497520.00,0.00,0.00,0.00),('1','142','798','257702',4904441,'2233','342',94633.76,94734.16,0.00,0.00,100.40,77308.00,0.00,0.00,0.00),('1','142','799','257702',4904442,'2234','342',94214.32,94953.27,0.00,0.00,738.95,568991.50,0.00,0.00,0.00),('1','142','798','257703',4904443,'2231','342',103367.57,103534.46,0.00,0.00,166.89,120161.30,0.00,0.00,0.00),('1','142','799','257703',4904444,'2232','342',100606.41,101414.76,0.00,0.00,808.35,622429.50,0.00,0.00,0.00),('1','142','798','257703',4904445,'2233','342',94734.16,94884.16,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','142','799','257703',4904446,'2234','342',94953.27,95598.54,0.00,0.00,645.27,496857.90,0.00,0.00,0.00),('1','142','798','257704',4904447,'2231','342',103534.46,103534.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257704',4904448,'2232','342',101414.76,102054.74,0.00,0.00,639.98,492784.60,0.00,0.00,0.00),('1','142','798','257704',4904449,'2233','342',94884.16,94948.17,0.00,0.00,64.01,49287.70,0.00,0.00,0.00),('1','142','799','257704',4904450,'2234','342',95598.54,96190.69,0.00,0.00,592.15,455955.50,0.00,0.00,0.00),('1','142','798','257705',4904451,'2231','342',103534.46,103579.46,0.00,0.00,45.00,32400.00,0.00,0.00,0.00),('1','142','799','257705',4904452,'2232','342',102054.74,102724.25,0.00,0.00,669.51,515522.70,0.00,0.00,0.00),('1','142','798','257705',4904453,'2233','342',94948.17,94948.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257705',4904454,'2234','342',96190.69,96790.63,0.00,0.00,599.94,461953.80,0.00,0.00,0.00),('1','142','798','257706',4904455,'2231','342',103579.46,103679.46,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','142','799','257706',4904456,'2232','342',102724.25,103097.67,0.00,0.00,373.42,287533.40,0.00,0.00,0.00),('1','142','798','257706',4904457,'2233','342',94948.17,95592.98,0.00,0.00,644.81,496503.70,0.00,0.00,0.00),('1','142','799','257706',4904458,'2234','342',96790.63,97282.81,0.00,0.00,492.18,378978.60,0.00,0.00,0.00),('1','142','798','257707',4904459,'2231','342',103679.46,103929.46,0.00,0.00,250.00,180000.00,0.00,0.00,0.00),('1','142','799','257707',4904460,'2232','342',103097.67,103631.18,0.00,0.00,533.51,410802.70,0.00,0.00,0.00),('1','142','798','257707',4904461,'2233','342',95592.98,95684.47,0.00,0.00,91.49,70447.30,0.00,0.00,0.00),('1','142','799','257707',4904462,'2234','342',97282.81,97942.07,0.00,0.00,659.26,507630.20,0.00,0.00,0.00),('1','142','798','257708',4904463,'2231','342',103929.46,104610.08,0.00,0.00,680.62,524077.40,0.00,0.00,0.00),('1','142','799','257708',4904464,'2232','342',103631.18,103643.18,0.00,0.00,12.00,8640.00,0.00,0.00,0.00),('1','142','798','257708',4904465,'2233','342',95684.47,96363.64,0.00,0.00,679.17,522960.90,0.00,0.00,0.00),('1','142','799','257708',4904466,'2234','342',97942.07,98042.07,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','142','798','257709',4904467,'2231','342',104610.08,105359.30,0.00,0.00,749.22,576899.40,0.00,0.00,0.00),('1','142','799','257709',4904468,'2232','342',103643.18,103817.07,0.00,0.00,173.89,125200.80,0.00,0.00,0.00),('1','142','798','257709',4904469,'2233','342',96363.64,97078.16,0.00,0.00,714.52,550180.40,0.00,0.00,0.00),('1','142','799','257709',4904470,'2234','342',98042.07,98192.07,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','142','798','257710',4904471,'2231','342',105359.30,106472.52,0.00,0.00,1113.22,857179.40,0.00,0.00,0.00),('1','142','798','257710',4904472,'2233','342',97078.16,97150.43,0.00,0.00,72.27,55647.90,0.00,0.00,0.00),('1','142','799','257710',4904473,'2234','342',98192.07,98217.07,0.00,0.00,25.00,18000.00,0.00,0.00,0.00),('1','142','799','257710',4904474,'2232','342',103817.07,104022.06,0.00,0.00,204.99,147833.30,0.00,0.00,0.00),('1','142','798','257711',4904475,'2231','342',106472.52,107101.81,0.00,0.00,629.29,484553.30,0.00,0.00,0.00),('1','142','799','257711',4904476,'2232','342',104022.06,104716.44,0.00,0.00,694.38,499953.60,0.00,0.00,0.00),('1','142','798','257711',4904477,'2233','342',97150.43,97713.95,0.00,0.00,563.52,433910.40,0.00,0.00,0.00),('1','142','799','257711',4904478,'2234','342',98217.07,98942.08,0.00,0.00,725.01,522007.70,0.00,0.00,0.00),('1','142','798','257712',4904479,'2231','342',107101.81,107750.25,0.00,0.00,648.44,499298.80,0.00,0.00,0.00),('1','142','799','257712',4904480,'2232','342',104716.44,104962.44,0.00,0.00,246.00,177120.00,0.00,0.00,0.00),('1','142','798','257712',4904481,'2233','342',97713.95,98322.03,0.00,0.00,608.08,468221.60,0.00,0.00,0.00),('1','142','799','257712',4904482,'2234','342',98942.08,99095.64,0.00,0.00,153.56,110563.20,0.00,0.00,0.00),('1','142','798','257713',4904483,'2231','342',107750.25,108692.33,0.00,0.00,942.08,725401.60,0.00,0.00,0.00),('1','142','799','257713',4904484,'2232','342',104962.44,104962.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257713',4904485,'2233','342',98322.03,99221.17,0.00,0.00,899.14,692337.80,0.00,0.00,0.00),('1','142','799','257713',4904486,'2234','342',99095.64,99145.64,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','142','798','257714',4904487,'2231','342',108692.33,109472.47,0.00,0.00,780.14,600707.80,0.00,0.00,0.00),('1','142','799','257714',4904488,'2232','342',104962.44,105526.99,0.00,0.00,564.55,406776.00,0.00,0.00,0.00),('1','142','798','257714',4904489,'2233','342',99221.17,99773.96,0.00,0.00,552.79,425648.30,0.00,0.00,0.00),('1','142','799','257714',4904490,'2234','342',99145.64,99805.59,0.00,0.00,659.95,475164.00,0.00,0.00,0.00),('1','142','798','257715',4904491,'2231','342',109472.47,110170.60,0.00,0.00,698.13,537560.10,0.00,0.00,0.00),('1','142','799','257715',4904492,'2232','342',105526.99,105526.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257715',4904493,'2233','342',99773.96,100432.39,0.00,0.00,658.43,506991.10,0.00,0.00,0.00),('1','142','799','257715',4904494,'2234','342',99805.59,99849.75,0.00,0.00,44.16,31796.20,0.00,0.00,0.00),('1','142','798','257716',4904495,'2231','342',110170.60,110641.58,0.00,0.00,470.98,362654.60,0.00,0.00,0.00),('1','142','799','257716',4904496,'2232','342',105526.99,105576.99,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','142','798','257716',4904497,'2233','342',100432.39,100925.98,0.00,0.00,493.59,380064.30,0.00,0.00,0.00),('1','142','799','257716',4904498,'2234','342',99849.75,99937.25,0.00,0.00,87.50,63625.00,0.00,0.00,0.00),('1','142','798','257717',4904499,'2231','342',110641.58,111148.12,0.00,0.00,506.54,390035.80,0.00,0.00,0.00),('1','142','799','257717',4904500,'2232','342',105576.99,105576.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257717',4904501,'2233','342',100925.98,101549.82,0.00,0.00,623.84,480356.80,0.00,0.00,0.00),('1','142','799','257717',4904502,'2234','342',99937.25,99937.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257718',4904503,'2231','342',111148.12,111716.98,0.00,0.00,568.86,438022.20,0.00,0.00,0.00),('1','142','799','257718',4904504,'2232','342',105576.99,105625.46,0.00,0.00,48.47,34898.40,0.00,0.00,0.00),('1','142','798','257718',4904505,'2233','342',101549.82,102123.46,0.00,0.00,573.64,441702.80,0.00,0.00,0.00),('1','142','799','257718',4904506,'2234','342',99937.25,99937.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257719',4904507,'2231','342',111716.98,111716.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257719',4904508,'2233','342',102123.46,102123.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257719',4904509,'2234','342',99937.25,99937.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257719',4904510,'2232','342',105625.46,105625.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257720',4904511,'2231','342',111716.98,111716.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257720',4904512,'2233','342',102123.46,102123.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257720',4904513,'2234','342',99937.25,99937.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257720',4904514,'2232','342',105625.46,105625.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257721',4904515,'2231','342',111716.98,111716.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257721',4904516,'2233','342',102123.46,102123.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257721',4904517,'2234','342',99937.25,99937.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257721',4904518,'2232','342',105625.46,105625.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257722',4904519,'2231','342',111716.98,111716.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257722',4904520,'2233','342',102123.46,102123.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257722',4904521,'2234','342',99937.25,99937.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257722',4904522,'2232','342',105625.46,105625.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257723',4904523,'2231','342',111716.98,111716.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257723',4904524,'2233','342',102123.46,102123.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257723',4904525,'2234','342',99937.25,99937.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257723',4904526,'2232','342',105625.46,105625.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257724',4904527,'2231','342',111716.98,111716.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257724',4904528,'2232','342',105625.46,105625.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257724',4904529,'2233','342',102123.46,102123.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257724',4904530,'2234','342',99937.25,99937.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257725',4904531,'2231','342',111716.98,111716.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257725',4904532,'2232','342',105625.46,105625.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257725',4904533,'2233','342',102123.46,102123.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257725',4904534,'2234','342',99937.25,99937.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257726',4904535,'2231','342',111716.98,111716.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257726',4904536,'2233','342',102123.46,102123.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257726',4904537,'2234','342',99937.25,99937.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257726',4904538,'2232','342',105625.46,105625.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257727',4904539,'2231','342',111716.98,111716.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257727',4904540,'2233','342',102123.46,102123.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257727',4904541,'2234','342',99937.25,99937.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257727',4904542,'2232','342',105625.46,105625.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257728',4904543,'2231','342',111716.98,111716.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257728',4904544,'2233','342',102123.46,102123.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257728',4904545,'2234','342',99937.25,99937.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257728',4904546,'2232','342',105625.46,105625.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257729',4904547,'2231','342',111716.98,111716.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257729',4904548,'2232','342',105625.46,105625.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257729',4904549,'2233','342',102123.46,102123.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257729',4904550,'2234','342',99937.25,99937.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257730',4904551,'2231','342',111716.98,111716.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257730',4904552,'2232','342',105625.46,105625.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257730',4904553,'2233','342',102123.46,102123.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257730',4904554,'2234','342',99937.25,99937.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257731',4904555,'2231','342',111716.98,111716.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257731',4904556,'2233','342',102123.46,102123.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257731',4904557,'2234','342',99937.25,99937.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257731',4904558,'2232','342',105625.46,105625.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257732',4904559,'2231','342',111716.98,112233.16,0.00,0.00,516.18,397458.60,0.00,0.00,0.00),('1','142','799','257732',4904560,'2232','342',105625.46,105725.37,0.00,0.00,99.91,71935.20,0.00,0.00,0.00),('1','142','798','257732',4904561,'2233','342',102123.46,102524.79,0.00,0.00,401.33,309024.10,0.00,0.00,0.00),('1','142','799','257732',4904562,'2234','342',99937.25,99989.25,0.00,0.00,52.00,37440.00,0.00,0.00,0.00),('1','142','798','257733',4904563,'2231','342',112233.16,112918.94,0.00,0.00,685.78,528050.60,0.00,0.00,0.00),('1','142','799','257733',4904564,'2232','342',105725.37,105800.37,0.00,0.00,75.00,54000.00,0.00,0.00,0.00),('1','142','798','257733',4904565,'2233','342',102524.79,103127.14,0.00,0.00,602.35,463809.50,0.00,0.00,0.00),('1','142','799','257733',4904566,'2234','342',99989.25,99989.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257734',4904567,'2231','342',112918.94,113428.00,0.00,0.00,509.06,391976.20,0.00,0.00,0.00),('1','142','799','257734',4904568,'2232','342',105800.37,106052.37,0.00,0.00,252.00,181440.00,0.00,0.00,0.00),('1','142','798','257734',4904569,'2233','342',103127.14,103685.87,0.00,0.00,558.73,430222.10,0.00,0.00,0.00),('1','142','799','257734',4904570,'2234','342',99989.25,100296.25,0.00,0.00,307.00,221040.00,0.00,0.00,0.00),('1','142','798','257735',4904571,'2231','342',113428.00,113998.05,0.00,0.00,570.05,438938.50,0.00,0.00,0.00),('1','142','799','257735',4904572,'2232','342',106052.37,106301.37,0.00,0.00,249.00,179280.00,0.00,0.00,0.00),('1','142','798','257735',4904573,'2233','342',103685.87,104209.01,0.00,0.00,523.14,402817.80,0.00,0.00,0.00),('1','142','799','257735',4904574,'2234','342',100296.25,100495.25,0.00,0.00,199.00,143280.00,0.00,0.00,0.00),('1','142','798','257736',4904575,'2231','342',113998.05,114372.05,0.00,0.00,374.00,287980.00,0.00,0.00,0.00),('1','142','799','257736',4904576,'2232','342',106301.37,106351.37,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','142','798','257736',4904577,'2233','342',104209.01,104826.83,0.00,0.00,617.82,475721.40,0.00,0.00,0.00),('1','142','799','257736',4904578,'2234','342',100495.25,100747.25,0.00,0.00,252.00,181440.00,0.00,0.00,0.00),('1','142','798','257737',4904579,'2231','342',114372.05,115176.89,0.00,0.00,804.84,619726.80,0.00,0.00,0.00),('1','142','799','257737',4904580,'2232','342',106351.37,106730.19,0.00,0.00,378.82,272750.40,0.00,0.00,0.00),('1','142','798','257737',4904581,'2233','342',104826.83,105537.37,0.00,0.00,710.54,547115.80,0.00,0.00,0.00),('1','142','799','257737',4904582,'2234','342',100747.25,101006.25,0.00,0.00,259.00,186480.00,0.00,0.00,0.00),('1','142','798','257738',4904583,'2231','342',115176.89,116029.34,0.00,0.00,852.45,656386.50,0.00,0.00,0.00),('1','142','799','257738',4904584,'2232','342',106730.19,106929.15,0.00,0.00,198.96,143251.20,0.00,0.00,0.00),('1','142','798','257738',4904585,'2233','342',105537.37,106353.23,0.00,0.00,815.86,628212.20,0.00,0.00,0.00),('1','142','799','257738',4904586,'2234','342',101006.25,101349.42,0.00,0.00,343.17,247082.40,0.00,0.00,0.00),('1','142','798','257739',4904587,'2231','342',116029.34,116712.58,0.00,0.00,683.24,526094.80,0.00,0.00,0.00),('1','142','799','257739',4904588,'2232','342',106929.15,107238.97,0.00,0.00,309.82,223070.40,0.00,0.00,0.00),('1','142','798','257739',4904589,'2233','342',106353.23,106836.93,0.00,0.00,483.70,372449.00,0.00,0.00,0.00),('1','142','799','257739',4904590,'2234','342',101349.42,101649.41,0.00,0.00,299.99,216057.80,0.00,0.00,0.00),('1','142','798','257740',4904591,'2231','342',116712.58,117449.06,0.00,0.00,736.48,567089.60,0.00,0.00,0.00),('1','142','799','257740',4904592,'2232','342',107238.97,107548.97,0.00,0.00,310.00,223349.50,0.00,0.00,0.00),('1','142','798','257740',4904593,'2233','342',106836.93,107593.68,0.00,0.00,756.75,582697.50,0.00,0.00,0.00),('1','142','799','257740',4904594,'2234','342',101649.41,102189.83,0.00,0.00,540.42,389109.40,0.00,0.00,0.00),('1','142','798','257741',4904595,'2231','342',117449.06,118266.01,0.00,0.00,816.95,629051.50,0.00,0.00,0.00),('1','142','799','257741',4904596,'2232','342',107548.97,108031.97,0.00,0.00,483.00,347760.00,0.00,0.00,0.00),('1','142','798','257741',4904597,'2233','342',107593.68,108229.09,0.00,0.00,635.41,489265.70,0.00,0.00,0.00),('1','142','799','257741',4904598,'2234','342',102189.83,102388.83,0.00,0.00,199.00,143280.00,0.00,0.00,0.00),('1','142','798','257742',4904599,'2231','342',118266.01,118977.87,0.00,0.00,711.86,548132.20,0.00,0.00,0.00),('1','142','798','257742',4904600,'2233','342',108229.09,109091.04,0.00,0.00,861.95,663701.50,0.00,0.00,0.00),('1','142','799','257742',4904601,'2234','342',102388.83,103405.45,0.00,0.00,1016.62,731966.40,0.00,0.00,0.00),('1','142','799','257742',4904602,'2232','342',108031.97,108904.16,0.00,0.00,872.19,627976.80,0.00,0.00,0.00),('1','142','798','257743',4904603,'2231','342',118977.87,119644.79,0.00,0.00,666.92,513528.40,0.00,0.00,0.00),('1','142','799','257743',4904604,'2232','342',108904.16,109357.23,0.00,0.00,453.07,326210.40,0.00,0.00,0.00),('1','142','798','257743',4904605,'2233','342',109091.04,109745.54,0.00,0.00,654.50,503965.00,0.00,0.00,0.00),('1','142','799','257743',4904606,'2234','342',103405.45,104154.89,0.00,0.00,749.44,539596.80,0.00,0.00,0.00),('1','142','798','257744',4904607,'2231','342',119644.79,120006.28,0.00,0.00,361.49,278347.30,0.00,0.00,0.00),('1','142','799','257744',4904608,'2232','342',109357.23,109357.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257744',4904609,'2233','342',109745.54,110209.41,0.00,0.00,463.87,346554.90,0.00,0.00,0.00),('1','142','799','257744',4904610,'2234','342',104154.89,104204.89,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','142','798','257745',4904611,'2231','342',120006.28,120409.11,0.00,0.00,402.83,310179.10,0.00,0.00,0.00),('1','142','799','257745',4904612,'2232','342',109357.23,109357.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257745',4904613,'2233','342',110209.41,110209.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257745',4904614,'2234','342',104204.89,104204.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257746',4904615,'2231','342',120409.11,121058.39,0.00,0.00,649.28,499945.60,0.00,0.00,0.00),('1','142','799','257746',4904616,'2232','342',109357.23,109810.60,0.00,0.00,453.37,326426.40,0.00,0.00,0.00),('1','142','798','257746',4904617,'2233','342',110209.41,111428.06,0.00,0.00,1218.65,938360.50,0.00,0.00,0.00),('1','142','799','257746',4904618,'2234','342',104204.89,104784.02,0.00,0.00,579.13,416973.60,0.00,0.00,0.00),('1','142','798','257747',4904619,'2231','342',121058.39,121058.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257747',4904620,'2233','342',111428.06,111428.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257747',4904621,'2234','342',104784.02,104784.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257747',4904622,'2232','342',109810.60,109810.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257748',4904623,'2231','342',121058.39,121058.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257748',4904624,'2232','342',109810.60,109810.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257748',4904625,'2233','342',111428.06,111428.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257748',4904626,'2234','342',104784.02,104784.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257749',4904627,'2231','342',121058.39,121731.60,0.00,0.00,673.21,518371.70,0.00,0.00,0.00),('1','142','799','257749',4904628,'2232','342',109810.60,109810.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257749',4904629,'2233','342',111428.06,112093.41,0.00,0.00,665.35,512319.50,0.00,0.00,0.00),('1','142','799','257749',4904630,'2234','342',104784.02,104834.02,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','142','798','257750',4904631,'2231','342',121731.60,122432.27,0.00,0.00,700.67,539515.90,0.00,0.00,0.00),('1','142','799','257750',4904632,'2232','342',109810.60,109918.00,0.00,0.00,107.40,77328.00,0.00,0.00,0.00),('1','142','798','257750',4904633,'2233','342',112093.41,112526.35,0.00,0.00,432.94,333363.80,0.00,0.00,0.00),('1','142','799','257750',4904634,'2234','342',104834.02,104942.73,0.00,0.00,108.71,78271.20,0.00,0.00,0.00),('1','142','798','257751',4904635,'2231','342',122432.27,122986.73,0.00,0.00,554.46,426934.20,0.00,0.00,0.00),('1','142','799','257751',4904636,'2232','342',109918.00,109918.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257751',4904637,'2233','342',112526.35,113263.02,0.00,0.00,736.67,567235.90,0.00,0.00,0.00),('1','142','799','257751',4904638,'2234','342',104942.73,104942.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257752',4904639,'2231','342',122986.73,123620.88,0.00,0.00,634.15,488295.50,0.00,0.00,0.00),('1','142','799','257752',4904640,'2232','342',109918.00,109968.00,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','142','798','257752',4904641,'2233','342',113263.02,113976.25,0.00,0.00,713.23,549187.10,0.00,0.00,0.00),('1','142','799','257752',4904642,'2234','342',104942.73,104942.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257753',4904643,'2231','342',123620.88,124356.80,0.00,0.00,735.92,566658.40,0.00,0.00,0.00),('1','142','799','257753',4904644,'2232','342',109968.00,110020.00,0.00,0.00,52.00,37557.00,0.00,0.00,0.00),('1','142','798','257753',4904645,'2233','342',113976.25,114678.44,0.00,0.00,702.19,540686.30,0.00,0.00,0.00),('1','142','799','257753',4904646,'2234','342',104942.73,105067.73,0.00,0.00,125.00,90000.00,0.00,0.00,0.00),('1','142','798','257754',4904647,'2231','342',124356.80,125075.50,0.00,0.00,718.70,553399.00,0.00,0.00,0.00),('1','142','799','257754',4904648,'2232','342',110020.00,110190.00,0.00,0.00,170.00,122400.00,0.00,0.00,0.00),('1','142','798','257754',4904649,'2233','342',114678.44,115201.15,0.00,0.00,522.71,402486.70,0.00,0.00,0.00),('1','142','799','257754',4904650,'2234','342',105067.73,105197.73,0.00,0.00,130.00,93600.00,0.00,0.00,0.00),('1','142','798','257755',4904651,'2231','342',125075.50,125767.34,0.00,0.00,691.84,532716.80,0.00,0.00,0.00),('1','142','799','257755',4904652,'2232','342',110190.00,110790.00,0.00,0.00,600.00,430200.00,0.00,0.00,0.00),('1','142','798','257755',4904653,'2233','342',115201.15,115590.28,0.00,0.00,389.13,299630.10,0.00,0.00,0.00),('1','142','799','257755',4904654,'2234','342',105197.73,105852.73,0.00,0.00,655.00,469950.00,0.00,0.00,0.00),('1','142','798','257756',4904655,'2231','342',125767.34,126203.83,0.00,0.00,436.49,336097.30,0.00,0.00,0.00),('1','142','799','257756',4904656,'2232','342',110790.00,111026.53,0.00,0.00,236.53,170301.60,0.00,0.00,0.00),('1','142','798','257756',4904657,'2233','342',115590.28,115904.73,0.00,0.00,314.45,242126.50,0.00,0.00,0.00),('1','142','799','257756',4904658,'2234','342',105852.73,106235.74,0.00,0.00,383.01,275767.20,0.00,0.00,0.00),('1','142','798','257757',4904659,'2231','342',126203.83,126833.74,0.00,0.00,629.91,485030.70,0.00,0.00,0.00),('1','142','799','257757',4904660,'2232','342',111026.53,111223.53,0.00,0.00,197.00,141990.00,0.00,0.00,0.00),('1','142','798','257757',4904661,'2233','342',115904.73,116376.95,0.00,0.00,472.22,363609.40,0.00,0.00,0.00),('1','142','799','257757',4904662,'2234','342',106235.74,106484.74,0.00,0.00,249.00,179280.00,0.00,0.00,0.00),('1','142','798','257758',4904663,'2231','342',126833.74,127350.12,0.00,0.00,516.38,397612.60,0.00,0.00,0.00),('1','142','799','257758',4904664,'2232','342',111223.53,111487.54,0.00,0.00,264.01,190087.20,0.00,0.00,0.00),('1','142','798','257758',4904665,'2233','342',116376.95,116845.59,0.00,0.00,468.64,360852.80,0.00,0.00,0.00),('1','142','799','257758',4904666,'2234','342',106484.74,106798.83,0.00,0.00,314.09,226144.80,0.00,0.00,0.00),('1','142','798','257759',4904667,'2231','342',127350.12,127991.32,0.00,0.00,641.20,493724.00,0.00,0.00,0.00),('1','142','799','257759',4904668,'2232','342',111487.54,111686.41,0.00,0.00,198.87,143186.40,0.00,0.00,0.00),('1','142','798','257759',4904669,'2233','342',116845.59,117392.35,0.00,0.00,546.76,421005.20,0.00,0.00,0.00),('1','142','799','257759',4904670,'2234','342',106798.83,107217.42,0.00,0.00,418.59,301384.80,0.00,0.00,0.00),('1','142','798','257760',4904671,'2231','342',127991.32,128515.47,0.00,0.00,524.15,403595.50,0.00,0.00,0.00),('1','142','799','257760',4904672,'2232','342',111686.41,111716.41,0.00,0.00,30.00,21600.00,0.00,0.00,0.00),('1','142','798','257760',4904673,'2233','342',117392.35,117848.71,0.00,0.00,456.36,351397.20,0.00,0.00,0.00),('1','142','799','257760',4904674,'2234','342',107217.42,107242.58,0.00,0.00,25.16,18115.20,0.00,0.00,0.00),('1','142','798','257761',4904675,'2231','342',128515.47,129024.29,0.00,0.00,508.82,391791.40,0.00,0.00,0.00),('1','142','799','257761',4904676,'2232','342',111716.41,111716.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257761',4904677,'2233','342',117848.71,118461.00,0.00,0.00,612.29,471463.30,0.00,0.00,0.00),('1','142','799','257761',4904678,'2234','342',107242.58,107535.15,0.00,0.00,292.57,210650.40,0.00,0.00,0.00),('1','142','798','257762',4904679,'2231','342',129024.29,129038.09,0.00,0.00,13.80,10626.00,0.00,0.00,0.00),('1','142','799','257762',4904680,'2232','342',111716.41,111893.19,0.00,0.00,176.78,127281.60,0.00,0.00,0.00),('1','142','798','257762',4904681,'2233','342',118461.00,118691.05,0.00,0.00,230.05,177138.50,0.00,0.00,0.00),('1','142','799','257762',4904682,'2234','342',107535.15,108124.02,0.00,0.00,588.87,453429.90,0.00,0.00,0.00),('1','142','798','257763',4904683,'2231','342',129038.09,129053.99,0.00,0.00,15.90,12243.00,0.00,0.00,0.00),('1','142','798','257763',4904684,'2233','342',118691.05,118975.85,0.00,0.00,284.80,219296.00,0.00,0.00,0.00),('1','142','799','257763',4904685,'2234','342',108124.02,108453.45,0.00,0.00,329.43,253661.10,0.00,0.00,0.00),('1','142','799','257763',4904686,'2232','342',111893.19,112168.47,0.00,0.00,275.28,198201.60,0.00,0.00,0.00),('1','142','798','257764',4904687,'2231','342',129053.99,129165.94,0.00,0.00,111.95,86201.50,0.00,0.00,0.00),('1','142','799','257764',4904688,'2232','342',112168.47,112805.30,0.00,0.00,636.83,458517.60,0.00,0.00,0.00),('1','142','798','257764',4904689,'2233','342',118975.85,119504.62,0.00,0.00,528.77,407152.90,0.00,0.00,0.00),('1','142','799','257764',4904690,'2234','342',108453.45,109117.11,0.00,0.00,663.66,511018.20,0.00,0.00,0.00),('1','142','798','257765',4904691,'2231','342',129165.94,129218.96,0.00,0.00,53.02,40825.40,0.00,0.00,0.00),('1','142','799','257765',4904692,'2232','342',112805.30,113400.30,0.00,0.00,595.00,428400.00,0.00,0.00,0.00),('1','142','798','257765',4904693,'2233','342',119504.62,120135.46,0.00,0.00,630.84,485746.80,0.00,0.00,0.00),('1','142','799','257765',4904694,'2234','342',109117.11,109609.26,0.00,0.00,492.15,376455.50,0.00,0.00,0.00),('1','142','798','257766',4904695,'2231','342',129218.96,129288.20,0.00,0.00,69.24,53314.80,0.00,0.00,0.00),('1','142','799','257766',4904696,'2232','342',113400.30,114891.04,0.00,0.00,1490.74,1073332.80,0.00,0.00,0.00),('1','142','798','257766',4904697,'2233','342',120135.46,120837.05,0.00,0.00,701.59,540224.30,0.00,0.00,0.00),('1','142','799','257766',4904698,'2234','342',109609.26,109870.48,0.00,0.00,261.22,201139.40,0.00,0.00,0.00),('1','142','798','257767',4904699,'2231','342',129288.20,129634.26,0.00,0.00,346.06,266466.20,0.00,0.00,0.00),('1','142','799','257767',4904700,'2232','342',114891.04,115736.20,0.00,0.00,845.16,608515.20,0.00,0.00,0.00),('1','142','798','257767',4904701,'2233','342',120837.05,121235.17,0.00,0.00,398.12,306552.40,0.00,0.00,0.00),('1','142','799','257767',4904702,'2234','342',109870.48,110120.08,0.00,0.00,249.60,192192.00,0.00,0.00,0.00),('1','142','798','257768',4904703,'2231','342',129634.26,130143.99,0.00,0.00,509.73,392492.10,0.00,0.00,0.00),('1','142','799','257768',4904704,'2232','342',115736.20,118018.41,0.00,0.00,2282.21,1643191.20,0.00,0.00,0.00),('1','142','798','257768',4904705,'2233','342',121235.17,122035.99,0.00,0.00,800.82,601631.40,0.00,0.00,0.00),('1','142','799','257768',4904706,'2234','342',110120.08,110262.08,0.00,0.00,142.00,109340.00,0.00,0.00,0.00),('1','142','798','257769',4904707,'2231','342',130143.99,130616.05,0.00,0.00,472.06,363486.20,0.00,0.00,0.00),('1','142','799','257769',4904708,'2232','342',118018.41,118652.08,0.00,0.00,633.67,456242.40,0.00,0.00,0.00),('1','142','798','257769',4904709,'2233','342',122035.99,122425.09,0.00,0.00,389.10,299607.00,0.00,0.00,0.00),('1','142','799','257769',4904710,'2234','342',110262.08,110303.71,0.00,0.00,41.63,32055.10,0.00,0.00,0.00),('1','142','798','257770',4904711,'2231','342',130616.05,131088.54,0.00,0.00,472.49,363817.30,0.00,0.00,0.00),('1','142','799','257770',4904712,'2232','342',118652.08,119657.89,0.00,0.00,1005.81,724475.20,0.00,0.00,0.00),('1','142','798','257770',4904713,'2233','342',122425.09,122917.91,0.00,0.00,492.82,379471.40,0.00,0.00,0.00),('1','142','799','257770',4904714,'2234','342',110303.71,110790.18,0.00,0.00,486.47,374581.90,0.00,0.00,0.00),('1','142','798','257771',4904715,'2231','342',131088.54,131094.54,0.00,0.00,6.00,4620.00,0.00,0.00,0.00),('1','142','799','257771',4904716,'2232','342',119657.89,120143.90,0.00,0.00,486.01,349927.70,0.00,0.00,0.00),('1','142','798','257771',4904717,'2233','342',122917.91,123531.18,0.00,0.00,613.27,472217.90,0.00,0.00,0.00),('1','142','799','257771',4904718,'2234','342',110790.18,111353.66,0.00,0.00,563.48,433879.60,0.00,0.00,0.00),('1','142','798','257772',4904719,'2231','342',131094.54,131590.73,0.00,0.00,496.19,382066.30,0.00,0.00,0.00),('1','142','799','257772',4904720,'2232','342',120143.90,120885.90,0.00,0.00,742.00,534540.00,0.00,0.00,0.00),('1','142','798','257772',4904721,'2233','342',123531.18,123598.91,0.00,0.00,67.73,52152.10,0.00,0.00,0.00),('1','142','799','257772',4904722,'2234','342',111353.66,111745.67,0.00,0.00,392.01,301847.70,0.00,0.00,0.00),('1','142','798','257773',4904723,'2231','342',131590.73,132238.14,0.00,0.00,647.41,498505.70,0.00,0.00,0.00),('1','142','799','257773',4904724,'2232','342',120885.90,121085.90,0.00,0.00,200.00,144000.00,0.00,0.00,0.00),('1','142','798','257773',4904725,'2233','342',123598.91,123608.91,0.00,0.00,10.00,7700.00,0.00,0.00,0.00),('1','142','799','257773',4904726,'2234','342',111745.67,112495.36,0.00,0.00,749.69,577261.30,0.00,0.00,0.00),('1','142','798','257774',4904727,'2231','342',132238.14,132854.48,0.00,0.00,616.34,474581.80,0.00,0.00,0.00),('1','142','799','257774',4904728,'2232','342',121085.90,121910.67,0.00,0.00,824.77,593834.40,0.00,0.00,0.00),('1','142','798','257774',4904729,'2233','342',123608.91,123673.41,0.00,0.00,64.50,49665.00,0.00,0.00,0.00),('1','142','799','257774',4904730,'2234','342',112495.36,113117.82,0.00,0.00,622.46,479294.20,0.00,0.00,0.00),('1','142','798','257775',4904731,'2231','342',132854.48,132859.97,0.00,0.00,5.49,4227.30,0.00,0.00,0.00),('1','142','799','257775',4904732,'2232','342',121910.67,122669.29,0.00,0.00,758.62,546206.40,0.00,0.00,0.00),('1','142','798','257775',4904733,'2233','342',123673.41,124175.85,0.00,0.00,502.44,386878.80,0.00,0.00,0.00),('1','142','799','257775',4904734,'2234','342',113117.82,113644.72,0.00,0.00,526.90,405713.00,0.00,0.00,0.00),('1','142','798','257776',4904735,'2231','342',132859.97,133598.88,0.00,0.00,738.91,568960.70,0.00,0.00,0.00),('1','142','799','257776',4904736,'2232','342',122669.29,123733.36,0.00,0.00,1064.07,766130.40,0.00,0.00,0.00),('1','142','798','257776',4904737,'2233','342',124175.85,124220.39,0.00,0.00,44.54,34295.80,0.00,0.00,0.00),('1','142','799','257776',4904738,'2234','342',113644.72,114400.08,0.00,0.00,755.36,581627.20,0.00,0.00,0.00),('1','142','798','257777',4904739,'2231','342',133598.88,133598.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257777',4904740,'2232','342',123733.36,123953.36,0.00,0.00,220.00,158400.00,0.00,0.00,0.00),('1','142','798','257777',4904741,'2233','342',124220.39,124220.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257777',4904742,'2234','342',114400.08,114400.63,0.00,0.00,0.55,396.00,0.00,0.00,0.00),('1','142','798','257778',4904743,'2231','342',133598.88,134385.71,0.00,0.00,786.83,605859.10,0.00,0.00,0.00),('1','142','799','257778',4904744,'2232','342',123953.36,124941.23,0.00,0.00,987.87,711266.40,0.00,0.00,0.00),('1','142','798','257778',4904745,'2233','342',124220.39,124908.72,0.00,0.00,688.33,530014.10,0.00,0.00,0.00),('1','142','799','257778',4904746,'2234','342',114400.63,115792.34,0.00,0.00,1391.71,1009590.20,0.00,0.00,0.00),('1','142','798','257779',4904747,'2231','342',134385.71,135073.87,0.00,0.00,688.16,529883.20,0.00,0.00,0.00),('1','142','799','257779',4904748,'2232','342',124941.23,125983.55,0.00,0.00,1042.32,750470.40,0.00,0.00,0.00),('1','142','798','257779',4904749,'2233','342',124908.72,125445.23,0.00,0.00,536.51,413112.70,0.00,0.00,0.00),('1','142','799','257779',4904750,'2234','342',115792.34,116777.95,0.00,0.00,985.61,709639.20,0.00,0.00,0.00),('1','142','798','257780',4904751,'2231','342',135073.87,135534.62,0.00,0.00,460.75,354777.50,0.00,0.00,0.00),('1','142','799','257780',4904752,'2232','342',125983.55,128394.55,0.00,0.00,2411.00,1735920.00,0.00,0.00,0.00),('1','142','798','257780',4904753,'2233','342',125445.23,125576.37,0.00,0.00,131.14,100977.80,0.00,0.00,0.00),('1','142','799','257780',4904754,'2234','342',116777.95,117692.77,0.00,0.00,914.82,663224.40,0.00,0.00,0.00),('1','142','798','257781',4904755,'2231','342',135534.62,135537.22,0.00,0.00,2.60,2002.00,0.00,0.00,0.00),('1','142','799','257781',4904756,'2232','342',128394.55,129454.26,0.00,0.00,1059.71,762991.20,0.00,0.00,0.00),('1','142','798','257781',4904757,'2233','342',125576.37,126143.16,0.00,0.00,566.79,436428.30,0.00,0.00,0.00),('1','142','799','257781',4904758,'2234','342',117692.77,118362.65,0.00,0.00,669.88,515807.60,0.00,0.00,0.00),('1','142','798','257782',4904759,'2231','342',135537.22,135721.99,0.00,0.00,184.77,142272.90,0.00,0.00,0.00),('1','142','799','257782',4904760,'2232','342',129454.26,130491.28,0.00,0.00,1037.02,746654.40,0.00,0.00,0.00),('1','142','798','257782',4904761,'2233','342',126143.16,126200.47,0.00,0.00,57.31,44128.70,0.00,0.00,0.00),('1','142','799','257782',4904762,'2234','342',118362.65,119157.79,0.00,0.00,795.14,572585.30,0.00,0.00,0.00),('1','142','798','257783',4904763,'2231','342',135721.99,136121.92,0.00,0.00,399.93,310676.10,0.00,0.00,0.00),('1','142','799','257783',4904764,'2232','342',130491.28,130646.28,0.00,0.00,155.00,111600.00,0.00,0.00,0.00),('1','142','798','257783',4904765,'2233','342',126200.47,126478.22,0.00,0.00,277.75,213867.50,0.00,0.00,0.00),('1','142','799','257783',4904766,'2234','342',119157.79,119263.54,0.00,0.00,105.75,81427.50,0.00,0.00,0.00),('1','142','798','257784',4904767,'2231','342',136121.92,136203.85,0.00,0.00,81.93,63086.10,0.00,0.00,0.00),('1','142','799','257784',4904768,'2232','342',130646.28,130646.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257784',4904769,'2233','342',126478.22,126952.65,0.00,0.00,474.43,365311.10,0.00,0.00,0.00),('1','142','799','257784',4904770,'2234','342',119263.54,119263.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257785',4904771,'2231','342',136203.85,136207.80,0.00,0.00,3.95,3041.50,0.00,0.00,0.00),('1','142','799','257785',4904772,'2232','342',130646.28,130646.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257785',4904773,'2233','342',126952.65,127012.12,0.00,0.00,59.47,45791.90,0.00,0.00,0.00),('1','142','799','257785',4904774,'2234','342',119263.54,119263.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257786',4904775,'2231','342',136207.80,136631.80,0.00,0.00,424.00,326480.00,0.00,0.00,0.00),('1','142','799','257786',4904776,'2232','342',130646.28,132569.25,0.00,0.00,1922.97,1384538.40,0.00,0.00,0.00),('1','142','798','257786',4904777,'2233','342',127012.12,127428.71,0.00,0.00,416.59,320774.30,0.00,0.00,0.00),('1','142','799','257786',4904778,'2234','342',119263.54,121538.91,0.00,0.00,2275.37,1638266.40,0.00,0.00,0.00),('1','142','798','257787',4904779,'2231','342',136631.80,137113.10,0.00,0.00,481.30,370601.00,0.00,0.00,0.00),('1','142','799','257787',4904780,'2232','342',132569.25,132691.75,0.00,0.00,122.50,88200.00,0.00,0.00,0.00),('1','142','798','257787',4904781,'2233','342',127428.71,127991.77,0.00,0.00,563.06,433556.20,0.00,0.00,0.00),('1','142','799','257787',4904782,'2234','342',121538.91,121743.91,0.00,0.00,205.00,147600.00,0.00,0.00,0.00),('1','142','798','257788',4904783,'2231','342',137113.10,137577.30,0.00,0.00,464.20,357434.00,0.00,0.00,0.00),('1','142','799','257788',4904784,'2232','342',132691.75,133396.75,0.00,0.00,705.00,507600.00,0.00,0.00,0.00),('1','142','798','257788',4904785,'2233','342',127991.77,128578.45,0.00,0.00,586.68,451743.60,0.00,0.00,0.00),('1','142','799','257788',4904786,'2234','342',121743.91,122243.91,0.00,0.00,500.00,360000.00,0.00,0.00,0.00),('1','142','798','257789',4904787,'2231','342',137577.30,138028.72,0.00,0.00,451.42,347593.40,0.00,0.00,0.00),('1','142','799','257789',4904788,'2232','342',133396.75,134776.91,0.00,0.00,1380.16,993715.20,0.00,0.00,0.00),('1','142','798','257789',4904789,'2233','342',128578.45,129251.73,0.00,0.00,673.28,518425.60,0.00,0.00,0.00),('1','142','799','257789',4904790,'2234','342',122243.91,123354.26,0.00,0.00,1110.35,799452.00,0.00,0.00,0.00),('1','142','798','257790',4904791,'2231','342',138028.72,138510.93,0.00,0.00,482.21,371301.70,0.00,0.00,0.00),('1','142','799','257790',4904792,'2232','342',134776.91,136407.73,0.00,0.00,1630.82,1174190.40,0.00,0.00,0.00),('1','142','798','257790',4904793,'2233','342',129251.73,129979.81,0.00,0.00,728.08,560621.60,0.00,0.00,0.00),('1','142','799','257790',4904794,'2234','342',123354.26,124958.04,0.00,0.00,1603.78,1154721.60,0.00,0.00,0.00),('1','142','798','257791',4904795,'2231','342',138510.93,138930.34,0.00,0.00,419.41,322945.70,0.00,0.00,0.00),('1','142','799','257791',4904796,'2232','342',136407.73,136754.73,0.00,0.00,347.00,249840.00,0.00,0.00,0.00),('1','142','798','257791',4904797,'2233','342',129979.81,130517.64,0.00,0.00,537.83,414129.10,0.00,0.00,0.00),('1','142','799','257791',4904798,'2234','342',124958.04,125308.04,0.00,0.00,350.00,252000.00,0.00,0.00,0.00),('1','142','798','257792',4904799,'2231','342',138930.34,139494.40,0.00,0.00,564.06,434326.20,0.00,0.00,0.00),('1','142','799','257792',4904800,'2232','342',136754.73,137005.01,0.00,0.00,250.28,180201.60,0.00,0.00,0.00),('1','142','798','257792',4904801,'2233','342',130517.64,131082.75,0.00,0.00,565.11,435134.70,0.00,0.00,0.00),('1','142','799','257792',4904802,'2234','342',125308.04,125526.09,0.00,0.00,218.05,156996.00,0.00,0.00,0.00),('1','142','798','257793',4904803,'2231','342',139494.40,140017.29,0.00,0.00,522.89,402625.30,0.00,0.00,0.00),('1','142','799','257793',4904804,'2232','342',137005.01,137555.01,0.00,0.00,550.00,396000.00,0.00,0.00,0.00),('1','142','798','257793',4904805,'2233','342',131082.75,131676.78,0.00,0.00,594.03,457403.10,0.00,0.00,0.00),('1','142','799','257793',4904806,'2234','342',125526.09,126175.79,0.00,0.00,649.70,467784.00,0.00,0.00,0.00),('1','142','798','257794',4904807,'2231','342',140017.29,140561.45,0.00,0.00,544.16,419003.20,0.00,0.00,0.00),('1','142','799','257794',4904808,'2232','342',137555.01,138614.32,0.00,0.00,1059.31,762703.20,0.00,0.00,0.00),('1','142','798','257794',4904809,'2233','342',131676.78,132212.08,0.00,0.00,535.30,412181.00,0.00,0.00,0.00),('1','142','799','257794',4904810,'2234','342',126175.79,127304.79,0.00,0.00,1129.00,812880.00,0.00,0.00,0.00),('1','142','798','257795',4904811,'2231','342',140561.45,140576.27,0.00,0.00,14.82,11411.40,0.00,0.00,0.00),('1','142','799','257795',4904812,'2232','342',138614.32,139346.83,0.00,0.00,732.51,527407.20,0.00,0.00,0.00),('1','142','798','257795',4904813,'2233','342',132212.08,132284.16,0.00,0.00,72.08,55501.60,0.00,0.00,0.00),('1','142','799','257795',4904814,'2234','342',127304.79,128010.01,0.00,0.00,705.22,507758.40,0.00,0.00,0.00),('1','142','798','257796',4904815,'2231','342',140576.27,140953.09,0.00,0.00,376.82,290151.40,0.00,0.00,0.00),('1','142','799','257796',4904816,'2232','342',139346.83,140321.70,0.00,0.00,974.87,701906.40,0.00,0.00,0.00),('1','142','798','257796',4904817,'2233','342',132284.16,132782.15,0.00,0.00,497.99,383452.30,0.00,0.00,0.00),('1','142','799','257796',4904818,'2234','342',128010.01,129230.01,0.00,0.00,1220.00,878400.00,0.00,0.00,0.00),('1','142','798','257797',4904819,'2231','342',140953.09,140953.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257797',4904820,'2233','342',132782.15,132782.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257797',4904821,'2234','342',129230.01,129230.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257797',4904822,'2232','342',140321.70,140321.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257798',4904823,'2231','342',140953.09,140953.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257798',4904824,'2233','342',132782.15,132782.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257798',4904825,'2234','342',129230.01,129230.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257798',4904826,'2232','342',140321.70,140321.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257799',4904827,'2231','342',140953.09,140953.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257799',4904828,'2233','342',132782.15,132782.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257799',4904829,'2234','342',129230.01,129230.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257799',4904830,'2232','342',140321.70,140321.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257800',4904831,'2231','342',140953.09,140953.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257800',4904832,'2233','342',132782.15,132782.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257800',4904833,'2234','342',129230.01,129230.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257800',4904834,'2232','342',140321.70,140321.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257801',4904835,'2231','342',140953.09,140953.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257801',4904836,'2233','342',132782.15,132782.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257801',4904837,'2234','342',129230.01,129230.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257801',4904838,'2232','342',140321.70,140321.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257802',4904839,'2231','342',140953.09,141448.83,0.00,0.00,495.74,386677.20,0.00,0.00,0.00),('1','142','799','257802',4904840,'2232','342',140321.70,140619.70,0.00,0.00,298.00,220760.00,0.00,0.00,0.00),('1','142','798','257802',4904841,'2233','342',132782.15,133383.58,0.00,0.00,601.43,469115.40,0.00,0.00,0.00),('1','142','799','257802',4904842,'2234','342',129230.01,129617.21,0.00,0.00,387.20,286528.00,0.00,0.00,0.00),('1','142','798','257803',4904843,'2231','342',141448.83,141891.37,0.00,0.00,442.54,345181.20,0.00,0.00,0.00),('1','142','799','257803',4904844,'2232','342',140619.70,141067.70,0.00,0.00,448.00,331520.00,0.00,0.00,0.00),('1','142','798','257803',4904845,'2233','342',133383.58,133878.81,0.00,0.00,495.23,386279.40,0.00,0.00,0.00),('1','142','799','257803',4904846,'2234','342',129617.21,130065.21,0.00,0.00,448.00,331520.00,0.00,0.00,0.00),('1','142','798','257804',4904847,'2231','342',141891.37,142528.73,0.00,0.00,637.36,497140.80,0.00,0.00,0.00),('1','142','799','257804',4904848,'2232','342',141067.70,141522.70,0.00,0.00,455.00,336700.00,0.00,0.00,0.00),('1','142','798','257804',4904849,'2233','342',133878.81,134350.78,0.00,0.00,471.97,368136.60,0.00,0.00,0.00),('1','142','799','257804',4904850,'2234','342',130065.21,130565.21,0.00,0.00,500.00,370000.00,0.00,0.00,0.00),('1','142','798','257805',4904851,'2231','342',142528.73,142993.20,0.00,0.00,464.47,362286.60,0.00,0.00,0.00),('1','142','799','257805',4904852,'2232','342',141522.70,142480.56,0.00,0.00,957.86,708816.40,0.00,0.00,0.00),('1','142','798','257805',4904853,'2233','342',134350.78,134965.69,0.00,0.00,614.91,479629.80,0.00,0.00,0.00),('1','142','799','257805',4904854,'2234','342',130565.21,131405.75,0.00,0.00,840.54,621999.60,0.00,0.00,0.00),('1','142','798','257806',4904855,'2231','342',142993.20,143554.49,0.00,0.00,561.29,437806.20,0.00,0.00,0.00),('1','142','799','257806',4904856,'2232','342',142480.56,143181.56,0.00,0.00,701.00,518740.00,0.00,0.00,0.00),('1','142','798','257806',4904857,'2233','342',134965.69,135376.24,0.00,0.00,410.55,320229.00,0.00,0.00,0.00),('1','142','799','257806',4904858,'2234','342',131405.75,131963.75,0.00,0.00,558.00,412920.00,0.00,0.00,0.00),('1','142','798','257807',4904859,'2231','342',143554.49,143980.74,0.00,0.00,426.25,332475.00,0.00,0.00,0.00),('1','142','799','257807',4904860,'2232','342',143181.56,144991.69,0.00,0.00,1810.13,1339496.20,0.00,0.00,0.00),('1','142','798','257807',4904861,'2233','342',135376.24,135874.32,0.00,0.00,498.08,388502.40,0.00,0.00,0.00),('1','142','799','257807',4904862,'2234','342',131963.75,133762.38,0.00,0.00,1798.63,1330986.20,0.00,0.00,0.00),('1','142','798','257808',4904863,'2231','342',143980.74,144590.88,0.00,0.00,610.14,475909.20,0.00,0.00,0.00),('1','142','799','257808',4904864,'2232','342',144991.69,145979.34,0.00,0.00,987.65,730861.00,0.00,0.00,0.00),('1','142','798','257808',4904865,'2233','342',135874.32,136408.16,0.00,0.00,533.84,416395.20,0.00,0.00,0.00),('1','142','799','257808',4904866,'2234','342',133762.38,135067.38,0.00,0.00,1305.00,965700.00,0.00,0.00,0.00),('1','142','798','257809',4904867,'2231','342',144590.88,145182.12,0.00,0.00,591.24,461167.20,0.00,0.00,0.00),('1','142','799','257809',4904868,'2232','342',145979.34,146728.34,0.00,0.00,749.00,554260.00,0.00,0.00,0.00),('1','142','798','257809',4904869,'2233','342',136408.16,136999.29,0.00,0.00,591.13,461081.40,0.00,0.00,0.00),('1','142','799','257809',4904870,'2234','342',135067.38,135830.57,0.00,0.00,763.19,565148.60,0.00,0.00,0.00),('1','142','798','257810',4904871,'2231','342',145182.12,145746.44,0.00,0.00,564.32,440169.60,0.00,0.00,0.00),('1','142','799','257810',4904872,'2232','342',146728.34,148135.54,0.00,0.00,1407.20,1041328.00,0.00,0.00,0.00),('1','142','798','257810',4904873,'2233','342',136999.29,137777.73,0.00,0.00,778.44,607183.20,0.00,0.00,0.00),('1','142','799','257810',4904874,'2234','342',135830.57,137313.37,0.00,0.00,1482.80,1097272.00,0.00,0.00,0.00),('1','142','798','257811',4904875,'2231','342',145746.44,146348.29,0.00,0.00,601.85,469443.00,0.00,0.00,0.00),('1','142','799','257811',4904876,'2232','342',148135.54,148435.54,0.00,0.00,300.00,222000.00,0.00,0.00,0.00),('1','142','798','257811',4904877,'2233','342',137777.73,138432.03,0.00,0.00,654.30,510354.00,0.00,0.00,0.00),('1','142','799','257811',4904878,'2234','342',137313.37,137513.37,0.00,0.00,200.00,148000.00,0.00,0.00,0.00),('1','142','798','257812',4904879,'2231','342',146348.29,147038.31,0.00,0.00,690.02,538215.60,0.00,0.00,0.00),('1','142','799','257812',4904880,'2232','342',148435.54,149430.54,0.00,0.00,995.00,736300.00,0.00,0.00,0.00),('1','142','798','257812',4904881,'2233','342',138432.03,139147.07,0.00,0.00,715.04,557731.20,0.00,0.00,0.00),('1','142','799','257812',4904882,'2234','342',137513.37,138584.37,0.00,0.00,1071.00,792540.00,0.00,0.00,0.00),('1','142','798','257813',4904883,'2231','342',147038.31,147582.36,0.00,0.00,544.05,424359.00,0.00,0.00,0.00),('1','142','799','257813',4904884,'2232','342',149430.54,150204.54,0.00,0.00,774.00,572760.00,0.00,0.00,0.00),('1','142','798','257813',4904885,'2233','342',139147.07,139702.10,0.00,0.00,555.03,432923.40,0.00,0.00,0.00),('1','142','799','257813',4904886,'2234','342',138584.37,139106.87,0.00,0.00,522.50,386650.00,0.00,0.00,0.00),('1','142','798','257814',4904887,'2231','342',147582.36,148294.76,0.00,0.00,712.40,555672.00,0.00,0.00,0.00),('1','142','799','257814',4904888,'2232','342',150204.54,151002.54,0.00,0.00,798.00,592520.00,0.00,0.00,0.00),('1','142','798','257814',4904889,'2233','342',139702.10,140388.73,0.00,0.00,686.63,535571.40,0.00,0.00,0.00),('1','142','799','257814',4904890,'2234','342',139106.87,139736.19,0.00,0.00,629.32,465696.80,0.00,0.00,0.00),('1','142','798','257815',4904891,'2231','342',148294.76,149126.15,0.00,0.00,831.39,648484.20,0.00,0.00,0.00),('1','142','799','257815',4904892,'2232','342',151002.54,152399.17,0.00,0.00,1396.63,1033506.20,0.00,0.00,0.00),('1','142','798','257815',4904893,'2233','342',140388.73,141030.16,0.00,0.00,641.43,500315.40,0.00,0.00,0.00),('1','142','799','257815',4904894,'2234','342',139736.19,141374.19,0.00,0.00,1638.00,1212402.00,0.00,0.00,0.00),('1','142','798','257816',4904895,'2231','342',149126.15,149772.30,0.00,0.00,646.15,503997.00,0.00,0.00,0.00),('1','142','799','257816',4904896,'2232','342',152399.17,152703.17,0.00,0.00,304.00,224960.00,0.00,0.00,0.00),('1','142','798','257816',4904897,'2233','342',141030.16,141655.48,0.00,0.00,625.32,487749.60,0.00,0.00,0.00),('1','142','799','257816',4904898,'2234','342',141374.19,141815.46,0.00,0.00,441.27,334190.60,0.00,0.00,0.00),('1','142','798','257817',4904899,'2231','342',149772.30,150397.00,0.00,0.00,624.70,487266.00,0.00,0.00,0.00),('1','142','799','257817',4904900,'2232','342',152703.17,154088.17,0.00,0.00,1385.00,1024900.00,0.00,0.00,0.00),('1','142','798','257817',4904901,'2233','342',141655.48,142284.01,0.00,0.00,628.53,490253.40,0.00,0.00,0.00),('1','142','799','257817',4904902,'2234','342',141815.46,142891.65,0.00,0.00,1076.19,796380.60,0.00,0.00,0.00),('1','142','798','257818',4904903,'2231','342',150397.00,151086.34,0.00,0.00,689.34,537685.20,0.00,0.00,0.00),('1','142','799','257818',4904904,'2232','342',154088.17,154615.21,0.00,0.00,527.04,390009.60,0.00,0.00,0.00),('1','142','798','257818',4904905,'2233','342',142284.01,142791.07,0.00,0.00,507.06,395506.80,0.00,0.00,0.00),('1','142','799','257818',4904906,'2234','342',142891.65,143472.30,0.00,0.00,580.65,429681.00,0.00,0.00,0.00),('1','142','798','257819',4904907,'2231','342',151086.34,151599.07,0.00,0.00,512.73,399929.40,0.00,0.00,0.00),('1','142','799','257819',4904908,'2232','342',154615.21,156368.71,0.00,0.00,1753.50,1297590.00,0.00,0.00,0.00),('1','142','798','257819',4904909,'2233','342',142791.07,143308.54,0.00,0.00,517.47,403626.60,0.00,0.00,0.00),('1','142','799','257819',4904910,'2234','342',143472.30,145362.30,0.00,0.00,1890.00,1398600.00,0.00,0.00,0.00),('1','142','798','257820',4904911,'2231','342',151599.07,152006.33,0.00,0.00,407.26,317662.80,0.00,0.00,0.00),('1','142','799','257820',4904912,'2232','342',156368.71,156964.71,0.00,0.00,596.00,441040.00,0.00,0.00,0.00),('1','142','798','257820',4904913,'2233','342',143308.54,143859.42,0.00,0.00,550.88,429686.40,0.00,0.00,0.00),('1','142','799','257820',4904914,'2234','342',145362.30,145912.30,0.00,0.00,550.00,407000.00,0.00,0.00,0.00),('1','142','798','257821',4904915,'2231','342',152006.33,152550.86,0.00,0.00,544.53,424733.40,0.00,0.00,0.00),('1','142','799','257821',4904916,'2232','342',156964.71,158513.83,0.00,0.00,1549.12,1146348.80,0.00,0.00,0.00),('1','142','798','257821',4904917,'2233','342',143859.42,144257.21,0.00,0.00,397.79,310276.20,0.00,0.00,0.00),('1','142','799','257821',4904918,'2234','342',145912.30,147212.30,0.00,0.00,1300.00,962000.00,0.00,0.00,0.00),('1','142','798','257822',4904919,'2231','342',152550.86,153104.92,0.00,0.00,554.06,432166.80,0.00,0.00,0.00),('1','142','799','257822',4904920,'2232','342',158513.83,159349.66,0.00,0.00,835.83,618642.60,0.00,0.00,0.00),('1','142','798','257822',4904921,'2233','342',144257.21,144790.00,0.00,0.00,532.79,415576.20,0.00,0.00,0.00),('1','142','799','257822',4904922,'2234','342',147212.30,147823.30,0.00,0.00,611.00,452140.00,0.00,0.00,0.00),('1','142','798','257823',4904923,'2231','342',153104.92,153426.86,0.00,0.00,321.94,251113.20,0.00,0.00,0.00),('1','142','799','257823',4904924,'2232','342',159349.66,160783.12,0.00,0.00,1433.46,1060760.40,0.00,0.00,0.00),('1','142','798','257823',4904925,'2233','342',144790.00,145315.34,0.00,0.00,525.34,409765.20,0.00,0.00,0.00),('1','142','799','257823',4904926,'2234','342',147823.30,148976.58,0.00,0.00,1153.28,853427.20,0.00,0.00,0.00),('1','142','798','257824',4904927,'2231','342',153426.86,153623.77,0.00,0.00,196.91,153589.80,0.00,0.00,0.00),('1','142','799','257824',4904928,'2232','342',160783.12,161583.13,0.00,0.00,800.01,592007.40,0.00,0.00,0.00),('1','142','798','257824',4904929,'2233','342',145315.34,145498.57,0.00,0.00,183.23,142919.40,0.00,0.00,0.00),('1','142','799','257824',4904930,'2234','342',148976.58,149691.58,0.00,0.00,715.00,529100.00,0.00,0.00,0.00),('1','142','798','257825',4904931,'2231','342',153623.77,154136.49,0.00,0.00,512.72,399921.60,0.00,0.00,0.00),('1','142','799','257825',4904932,'2232','342',161583.13,162503.13,0.00,0.00,920.00,686800.00,0.00,0.00,0.00),('1','142','798','257825',4904933,'2233','342',145498.57,145851.03,0.00,0.00,352.46,274918.80,0.00,0.00,0.00),('1','142','799','257825',4904934,'2234','342',149691.58,150642.32,0.00,0.00,950.74,703547.60,0.00,0.00,0.00),('1','142','798','257826',4904935,'2231','342',154136.49,154382.50,0.00,0.00,246.01,191887.80,0.00,0.00,0.00),('1','142','799','257826',4904936,'2232','342',162503.13,163368.13,0.00,0.00,865.00,640100.00,0.00,0.00,0.00),('1','142','798','257826',4904937,'2233','342',145851.03,146017.18,0.00,0.00,166.15,129597.00,0.00,0.00,0.00),('1','142','799','257826',4904938,'2234','342',150642.32,151355.36,0.00,0.00,713.04,527649.60,0.00,0.00,0.00),('1','142','798','257827',4904939,'2231','342',154382.50,154906.82,0.00,0.00,524.32,408969.60,0.00,0.00,0.00),('1','142','799','257827',4904940,'2232','342',163368.13,164141.13,0.00,0.00,773.00,572020.00,0.00,0.00,0.00),('1','142','798','257827',4904941,'2233','342',146017.18,146524.30,0.00,0.00,507.12,395553.60,0.00,0.00,0.00),('1','142','799','257827',4904942,'2234','342',151355.36,152042.92,0.00,0.00,687.56,508794.40,0.00,0.00,0.00),('1','142','798','257828',4904943,'2231','342',154906.82,155423.20,0.00,0.00,516.38,402776.40,0.00,0.00,0.00),('1','142','799','257828',4904944,'2232','342',164141.13,165811.13,0.00,0.00,1670.00,1232790.28,0.00,0.00,0.00),('1','142','798','257828',4904945,'2233','342',146524.30,147010.99,0.00,0.00,486.69,379618.20,0.00,0.00,0.00),('1','142','799','257828',4904946,'2234','342',152042.92,153553.95,0.00,0.00,1511.03,1115333.20,0.00,0.00,0.00),('1','142','798','257829',4904947,'2231','342',155423.20,155929.74,0.00,0.00,506.54,395101.20,0.00,0.00,0.00),('1','142','799','257829',4904948,'2232','342',165811.13,166619.32,0.00,0.00,808.19,598060.60,0.00,0.00,0.00),('1','142','798','257829',4904949,'2233','342',147010.99,147392.65,0.00,0.00,381.66,297694.80,0.00,0.00,0.00),('1','142','799','257829',4904950,'2234','342',153553.95,154124.95,0.00,0.00,571.00,422540.00,0.00,0.00,0.00),('1','142','798','257830',4904951,'2231','342',155929.74,156524.06,0.00,0.00,594.32,463569.60,0.00,0.00,0.00),('1','142','799','257830',4904952,'2232','342',166619.32,168192.84,0.00,0.00,1573.52,1164404.80,0.00,0.00,0.00),('1','142','798','257830',4904953,'2233','342',147392.65,147905.39,0.00,0.00,512.74,399937.20,0.00,0.00,0.00),('1','142','799','257830',4904954,'2234','342',154124.95,155555.69,0.00,0.00,1430.74,1058747.60,0.00,0.00,0.00),('1','142','798','257831',4904955,'2231','342',156524.06,157137.08,0.00,0.00,613.02,478155.60,0.00,0.00,0.00),('1','142','799','257831',4904956,'2232','342',168192.84,169002.79,0.00,0.00,809.95,599363.00,0.00,0.00,0.00),('1','142','798','257831',4904957,'2233','342',147905.39,148505.59,0.00,0.00,600.20,468156.00,0.00,0.00,0.00),('1','142','799','257831',4904958,'2234','342',155555.69,156220.69,0.00,0.00,665.00,492202.40,0.00,0.00,0.00),('1','142','798','257832',4904959,'2231','342',157137.08,157666.02,0.00,0.00,528.94,412573.20,0.00,0.00,0.00),('1','142','799','257832',4904960,'2232','342',169002.79,170043.44,0.00,0.00,1040.65,770081.00,0.00,0.00,0.00),('1','142','798','257832',4904961,'2233','342',148505.59,149100.54,0.00,0.00,594.95,464061.00,0.00,0.00,0.00),('1','142','799','257832',4904962,'2234','342',156220.69,157109.91,0.00,0.00,889.22,658022.80,0.00,0.00,0.00),('1','142','798','257833',4904963,'2231','342',157666.02,158282.09,0.00,0.00,616.07,480534.60,0.00,0.00,0.00),('1','142','799','257833',4904964,'2232','342',170043.44,172096.54,0.00,0.00,2053.10,1519294.00,0.00,0.00,0.00),('1','142','798','257833',4904965,'2233','342',149100.54,149631.07,0.00,0.00,530.53,413813.40,0.00,0.00,0.00),('1','142','799','257833',4904966,'2234','342',157109.91,158969.91,0.00,0.00,1860.00,1376400.00,0.00,0.00,0.00),('1','142','798','257834',4904967,'2231','342',158282.09,158837.41,0.00,0.00,555.32,433149.60,0.00,0.00,0.00),('1','142','799','257834',4904968,'2232','342',172096.54,172939.83,0.00,0.00,843.29,624034.60,0.00,0.00,0.00),('1','142','798','257834',4904969,'2233','342',149631.07,150242.97,0.00,0.00,611.90,477282.00,0.00,0.00,0.00),('1','142','799','257834',4904970,'2234','342',158969.91,159586.32,0.00,0.00,616.41,456143.40,0.00,0.00,0.00),('1','142','798','257835',4904971,'2231','342',158837.41,159236.20,0.00,0.00,398.79,311056.20,0.00,0.00,0.00),('1','142','799','257835',4904972,'2232','342',172939.83,173829.83,0.00,0.00,890.00,658600.00,0.00,0.00,0.00),('1','142','798','257835',4904973,'2233','342',150242.97,150685.38,0.00,0.00,442.41,345079.80,0.00,0.00,0.00),('1','142','799','257835',4904974,'2234','342',159586.32,160490.21,0.00,0.00,903.89,668878.60,0.00,0.00,0.00),('1','142','798','257836',4904975,'2231','342',159236.20,159722.43,0.00,0.00,486.23,379259.40,0.00,0.00,0.00),('1','142','799','257836',4904976,'2232','342',173829.83,174779.51,0.00,0.00,949.68,702763.20,0.00,0.00,0.00),('1','142','798','257836',4904977,'2233','342',150685.38,151238.14,0.00,0.00,552.76,431152.80,0.00,0.00,0.00),('1','142','799','257836',4904978,'2234','342',160490.21,161141.47,0.00,0.00,651.26,481932.40,0.00,0.00,0.00),('1','142','798','257837',4904979,'2231','342',159722.43,160303.10,0.00,0.00,580.67,452922.60,0.00,0.00,0.00),('1','142','799','257837',4904980,'2232','342',174779.51,175396.01,0.00,0.00,616.50,456210.00,0.00,0.00,0.00),('1','142','798','257837',4904981,'2233','342',151238.14,151779.21,0.00,0.00,541.07,422034.60,0.00,0.00,0.00),('1','142','799','257837',4904982,'2234','342',161141.47,161930.65,0.00,0.00,789.18,583993.20,0.00,0.00,0.00),('1','142','798','257838',4904983,'2231','342',160303.10,160671.74,0.00,0.00,368.64,296559.20,0.00,0.00,0.00),('1','142','799','257838',4904984,'2232','342',175396.01,176805.39,0.00,0.00,1409.38,1042941.20,0.00,0.00,0.00),('1','142','798','257838',4904985,'2233','342',151779.21,152231.66,0.00,0.00,452.45,352911.00,0.00,0.00,0.00),('1','142','799','257838',4904986,'2234','342',161930.65,163625.54,0.00,0.00,1694.89,1254218.60,0.00,0.00,0.00),('1','142','798','257839',4904987,'2231','342',160671.74,161214.75,0.00,0.00,543.01,423547.80,0.00,0.00,0.00),('1','142','799','257839',4904988,'2232','342',176805.39,177428.06,0.00,0.00,622.67,460775.80,0.00,0.00,0.00),('1','142','798','257839',4904989,'2233','342',152231.66,152979.92,0.00,0.00,748.26,583642.80,0.00,0.00,0.00),('1','142','799','257839',4904990,'2234','342',163625.54,164220.76,0.00,0.00,595.22,440462.80,0.00,0.00,0.00),('1','142','798','257840',4904991,'2231','342',161214.75,161839.02,0.00,0.00,624.27,486930.60,0.00,0.00,0.00),('1','142','799','257840',4904992,'2232','342',177428.06,178226.06,0.00,0.00,798.00,590520.00,0.00,0.00,0.00),('1','142','798','257840',4904993,'2233','342',152979.92,153542.22,0.00,0.00,562.30,438594.00,0.00,0.00,0.00),('1','142','799','257840',4904994,'2234','342',164220.76,164973.32,0.00,0.00,752.56,556971.20,0.00,0.00,0.00),('1','142','798','257841',4904995,'2231','342',161839.02,162443.05,0.00,0.00,604.03,471143.40,0.00,0.00,0.00),('1','142','799','257841',4904996,'2232','342',178226.06,179463.68,0.00,0.00,1237.62,915838.80,0.00,0.00,0.00),('1','142','798','257841',4904997,'2233','342',153542.22,154090.18,0.00,0.00,547.96,427408.80,0.00,0.00,0.00),('1','142','799','257841',4904998,'2234','342',164973.32,165976.59,0.00,0.00,1003.27,742419.80,0.00,0.00,0.00),('1','142','798','257842',4904999,'2231','342',162443.05,162568.64,0.00,0.00,125.59,97960.20,0.00,0.00,0.00),('1','142','799','257842',4905000,'2232','342',179463.68,179581.29,0.00,0.00,117.61,87031.40,0.00,0.00,0.00),('1','142','798','257842',4905001,'2233','342',154090.18,154201.18,0.00,0.00,111.00,86580.00,0.00,0.00,0.00),('1','142','799','257842',4905002,'2234','342',165976.59,166109.55,0.00,0.00,132.96,98390.40,0.00,0.00,0.00),('1','142','798','257843',4905003,'2231','342',162568.64,163192.12,0.00,0.00,623.48,486314.40,0.00,0.00,0.00),('1','142','799','257843',4905004,'2232','342',179581.29,180185.09,0.00,0.00,603.80,446812.00,0.00,0.00,0.00),('1','142','798','257843',4905005,'2233','342',154201.18,154783.50,0.00,0.00,582.32,454209.60,0.00,0.00,0.00),('1','142','799','257843',4905006,'2234','342',166109.55,166872.75,0.00,0.00,763.20,564768.00,0.00,0.00,0.00),('1','142','798','257844',4905007,'2231','342',163192.12,163192.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257844',4905008,'2232','342',180185.09,180185.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257844',4905009,'2233','342',154783.50,154783.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257844',4905010,'2234','342',166872.75,166872.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257845',4905011,'2231','342',163192.12,163192.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257845',4905012,'2232','342',180185.09,180185.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257845',4905013,'2233','342',154783.50,154783.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257845',4905014,'2234','342',166872.75,166872.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257846',4905015,'2231','342',163192.12,163192.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257846',4905016,'2232','342',180185.09,180185.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257846',4905017,'2233','342',154783.50,154783.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257846',4905018,'2234','342',166872.75,166872.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257847',4905019,'2231','342',163192.12,163192.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257847',4905020,'2232','342',180185.09,180185.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257847',4905021,'2233','342',154783.50,154783.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257847',4905022,'2234','342',166872.75,166872.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257848',4905023,'2231','342',163192.12,163192.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257848',4905024,'2233','342',154783.50,154783.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257848',4905025,'2234','342',166872.75,166872.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257848',4905026,'2232','342',180185.09,180185.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257849',4905027,'2231','342',163192.12,163939.20,0.00,0.00,747.08,582722.40,0.00,0.00,0.00),('1','142','798','257849',4905028,'2233','342',154783.50,155508.72,0.00,0.00,725.22,565671.60,0.00,0.00,0.00),('1','142','799','257849',4905029,'2234','342',166872.75,168158.69,0.00,0.00,1285.94,951595.60,0.00,0.00,0.00),('1','142','799','257849',4905030,'2232','342',180185.09,181815.09,0.00,0.00,1630.00,1206240.00,0.00,0.00,0.00),('1','142','798','257850',4905031,'2231','342',163939.20,164766.28,0.00,0.00,827.08,645122.40,0.00,0.00,0.00),('1','142','799','257850',4905032,'2232','342',181815.09,183545.90,0.00,0.00,1730.81,1280799.40,0.00,0.00,0.00),('1','142','798','257850',4905033,'2233','342',155508.72,156407.39,0.00,0.00,898.67,700962.60,0.00,0.00,0.00),('1','142','799','257850',4905034,'2234','342',168158.69,169533.49,0.00,0.00,1374.80,1017352.00,0.00,0.00,0.00),('1','142','798','257851',4905035,'2231','342',164766.28,165441.49,0.00,0.00,675.21,526663.80,0.00,0.00,0.00),('1','142','799','257851',4905036,'2232','342',183545.90,183946.90,0.00,0.00,401.00,296740.00,0.00,0.00,0.00),('1','142','798','257851',4905037,'2233','342',156407.39,157262.04,0.00,0.00,854.65,666627.00,0.00,0.00,0.00),('1','142','799','257851',4905038,'2234','342',169533.49,170102.49,0.00,0.00,569.00,421178.00,0.00,0.00,0.00),('1','142','798','257852',4905039,'2231','342',165441.49,166193.34,0.00,0.00,751.85,586443.00,0.00,0.00,0.00),('1','142','799','257852',4905040,'2232','342',183946.90,185181.81,0.00,0.00,1234.91,913833.40,0.00,0.00,0.00),('1','142','798','257852',4905041,'2233','342',157262.04,157958.63,0.00,0.00,696.59,543340.20,0.00,0.00,0.00),('1','142','799','257852',4905042,'2234','342',170102.49,171308.22,0.00,0.00,1205.73,892240.20,0.00,0.00,0.00),('1','142','798','257853',4905043,'2231','342',166193.34,166515.83,0.00,0.00,322.49,238642.60,0.00,0.00,0.00),('1','142','799','257853',4905044,'2232','342',185181.81,185546.88,0.00,0.00,365.07,284754.60,0.00,0.00,0.00),('1','142','798','257853',4905045,'2233','342',157958.63,158711.20,0.00,0.00,752.57,556901.80,0.00,0.00,0.00),('1','142','799','257853',4905046,'2234','342',171308.22,171621.39,0.00,0.00,313.17,244272.60,0.00,0.00,0.00),('1','142','798','257854',4905047,'2231','342',166515.83,168026.66,0.00,0.00,1510.83,1118014.20,0.00,0.00,0.00),('1','142','799','257854',4905048,'2232','342',185546.88,186418.27,0.00,0.00,871.39,679684.20,0.00,0.00,0.00),('1','142','798','257854',4905049,'2233','342',158711.20,159676.30,0.00,0.00,965.10,714174.00,0.00,0.00,0.00),('1','142','799','257854',4905050,'2234','342',171621.39,172560.06,0.00,0.00,938.67,732162.60,0.00,0.00,0.00),('1','142','798','257855',4905051,'2231','342',168026.66,168096.51,0.00,0.00,69.85,54483.00,0.00,0.00,0.00),('1','142','799','257855',4905052,'2232','342',186418.27,186485.89,0.00,0.00,67.62,52743.60,0.00,0.00,0.00),('1','142','798','257855',4905053,'2233','342',159676.30,159767.64,0.00,0.00,91.34,71245.20,0.00,0.00,0.00),('1','142','799','257855',4905054,'2234','342',172560.06,172633.93,0.00,0.00,73.87,57618.60,0.00,0.00,0.00),('1','142','798','257856',4905055,'2231','342',168096.51,168096.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257856',4905056,'2232','342',186485.89,186485.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257856',4905057,'2233','342',159767.64,159767.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257856',4905058,'2234','342',172633.93,172633.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257857',4905059,'2231','342',168096.51,168296.51,0.00,0.00,200.00,148000.00,0.00,0.00,0.00),('1','142','799','257857',4905060,'2232','342',186485.89,186728.22,0.00,0.00,242.33,189017.40,0.00,0.00,0.00),('1','142','798','257857',4905061,'2233','342',159767.64,159967.64,0.00,0.00,200.00,148000.00,0.00,0.00,0.00),('1','142','799','257857',4905062,'2234','342',172633.93,172881.26,0.00,0.00,247.33,192917.40,0.00,0.00,0.00),('1','142','798','257858',4905063,'2231','342',168296.51,168296.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257858',4905064,'2232','342',186728.22,187451.72,0.00,0.00,723.50,533219.50,0.00,0.00,0.00),('1','142','798','257858',4905065,'2233','342',159967.64,159967.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257858',4905066,'2234','342',172881.26,173543.76,0.00,0.00,662.50,488262.50,0.00,0.00,0.00),('1','142','798','257859',4905067,'2231','342',168296.51,169624.61,0.00,0.00,1328.10,982794.00,0.00,0.00,0.00),('1','142','799','257859',4905068,'2232','342',187451.72,188027.30,0.00,0.00,575.58,448952.40,0.00,0.00,0.00),('1','142','798','257859',4905069,'2233','342',159967.64,160889.64,0.00,0.00,922.00,682280.00,0.00,0.00,0.00),('1','142','799','257859',4905070,'2234','342',173543.76,174185.01,0.00,0.00,641.25,500175.00,0.00,0.00,0.00),('1','142','798','257860',4905071,'2231','342',169624.61,170725.74,0.00,0.00,1101.13,815316.20,0.00,0.00,0.00),('1','142','799','257860',4905072,'2232','342',188027.30,188593.40,0.00,0.00,566.10,441558.00,0.00,0.00,0.00),('1','142','798','257860',4905073,'2233','342',160889.64,161689.64,0.00,0.00,800.00,592445.20,0.00,0.00,0.00),('1','142','799','257860',4905074,'2234','342',174185.01,174712.73,0.00,0.00,527.72,411621.60,0.00,0.00,0.00),('1','142','798','257861',4905075,'2231','342',170725.74,170725.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257861',4905076,'2233','342',161689.64,161689.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257861',4905077,'2234','342',174712.73,175979.08,0.00,0.00,1266.35,987753.00,0.00,0.00,0.00),('1','142','799','257861',4905078,'2232','342',188593.40,189480.90,0.00,0.00,887.50,656750.00,0.00,0.00,0.00),('1','142','798','257862',4905079,'2231','342',170725.74,170725.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257862',4905080,'2232','342',189480.90,191955.50,0.00,0.00,2474.60,1831204.00,0.00,0.00,0.00),('1','142','798','257862',4905081,'2233','342',161689.64,162135.03,0.00,0.00,445.39,347404.20,0.00,0.00,0.00),('1','142','799','257862',4905082,'2234','342',175979.08,176893.71,0.00,0.00,914.63,713411.40,0.00,0.00,0.00),('1','142','798','257863',4905083,'2231','342',170725.74,170727.02,0.00,0.00,1.28,998.40,0.00,0.00,0.00),('1','142','799','257863',4905084,'2232','342',191955.50,193725.50,0.00,0.00,1770.00,1309800.00,0.00,0.00,0.00),('1','142','798','257863',4905085,'2233','342',162135.03,162686.17,0.00,0.00,551.14,429889.20,0.00,0.00,0.00),('1','142','799','257863',4905086,'2234','342',176893.71,177395.42,0.00,0.00,501.71,391333.80,0.00,0.00,0.00),('1','142','798','257864',4905087,'2231','342',170727.02,170781.74,0.00,0.00,54.72,42681.60,0.00,0.00,0.00),('1','142','799','257864',4905088,'2232','342',193725.50,196100.50,0.00,0.00,2375.00,1757500.00,0.00,0.00,0.00),('1','142','798','257864',4905089,'2233','342',162686.17,163375.41,0.00,0.00,689.24,537607.20,0.00,0.00,0.00),('1','142','799','257864',4905090,'2234','342',177395.42,177652.28,0.00,0.00,256.86,200350.80,0.00,0.00,0.00),('1','142','798','257865',4905091,'2231','342',170781.74,171381.19,0.00,0.00,599.45,467571.00,0.00,0.00,0.00),('1','142','799','257865',4905092,'2232','342',196100.50,196100.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257865',4905093,'2233','342',163375.41,163875.93,0.00,0.00,500.52,390405.60,0.00,0.00,0.00),('1','142','799','257865',4905094,'2234','342',177652.28,177657.41,0.00,0.00,5.13,4001.40,0.00,0.00,0.00),('1','142','798','257866',4905095,'2231','342',171381.19,171385.68,0.00,0.00,4.49,3502.20,0.00,0.00,0.00),('1','142','799','257866',4905096,'2232','342',196100.50,197308.79,0.00,0.00,1208.29,894134.60,0.00,0.00,0.00),('1','142','798','257866',4905097,'2233','342',163875.93,164039.84,0.00,0.00,163.91,127849.80,0.00,0.00,0.00),('1','142','799','257866',4905098,'2234','342',177657.41,178709.41,0.00,0.00,1052.00,778480.00,0.00,0.00,0.00),('1','142','798','257867',4905099,'2231','342',171385.68,171385.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257867',4905100,'2233','342',164039.84,164039.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257867',4905101,'2234','342',178709.41,178709.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257867',4905102,'2232','342',197308.79,197308.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257868',4905103,'2231','342',171385.68,171912.94,0.00,0.00,527.26,411262.80,0.00,0.00,0.00),('1','142','799','257868',4905104,'2232','342',197308.79,197623.79,0.00,0.00,315.00,233100.00,0.00,0.00,0.00),('1','142','798','257868',4905105,'2233','342',164039.84,164307.80,0.00,0.00,267.96,209008.80,0.00,0.00,0.00),('1','142','799','257868',4905106,'2234','342',178709.41,179104.09,0.00,0.00,394.68,292063.20,0.00,0.00,0.00),('1','142','798','257869',4905107,'2231','342',171912.94,172979.54,0.00,0.00,1066.60,789724.00,0.00,0.00,0.00),('1','142','799','257869',4905108,'2232','342',197623.79,198323.02,0.00,0.00,699.23,545399.40,0.00,0.00,0.00),('1','142','798','257869',4905109,'2233','342',164307.80,164941.66,0.00,0.00,633.86,494410.80,0.00,0.00,0.00),('1','142','799','257869',4905110,'2234','342',179104.09,179914.09,0.00,0.00,810.00,599400.00,0.00,0.00,0.00),('1','142','798','257870',4905111,'2231','342',172979.54,173882.82,0.00,0.00,903.28,668427.20,0.00,0.00,0.00),('1','142','799','257870',4905112,'2232','342',198323.02,198851.17,0.00,0.00,528.15,411957.00,0.00,0.00,0.00),('1','142','798','257870',4905113,'2233','342',164941.66,165516.32,0.00,0.00,574.66,448234.80,0.00,0.00,0.00),('1','142','799','257870',4905114,'2234','342',179914.09,180658.54,0.00,0.00,744.45,550893.00,0.00,0.00,0.00),('1','142','798','257871',4905115,'2231','342',173882.82,174544.82,0.00,0.00,662.00,489880.00,0.00,0.00,0.00),('1','142','799','257871',4905116,'2232','342',198851.17,199466.39,0.00,0.00,615.22,479871.60,0.00,0.00,0.00),('1','142','798','257871',4905117,'2233','342',165516.32,165966.04,0.00,0.00,449.72,350781.60,0.00,0.00,0.00),('1','142','799','257871',4905118,'2234','342',180658.54,181695.02,0.00,0.00,1036.48,766995.20,0.00,0.00,0.00),('1','142','798','257872',4905119,'2231','342',174544.82,174928.87,0.00,0.00,384.05,284197.00,0.00,0.00,0.00),('1','142','799','257872',4905120,'2232','342',199466.39,199912.80,0.00,0.00,446.41,348199.80,0.00,0.00,0.00),('1','142','798','257872',4905121,'2233','342',165966.04,166534.30,0.00,0.00,568.26,443242.80,0.00,0.00,0.00),('1','142','799','257872',4905122,'2234','342',181695.02,182195.02,0.00,0.00,500.00,370000.00,0.00,0.00,0.00),('1','142','798','257873',4905123,'2231','342',174928.87,175803.99,0.00,0.00,875.12,647588.80,0.00,0.00,0.00),('1','142','799','257873',4905124,'2232','342',199912.80,200560.63,0.00,0.00,647.83,505307.40,0.00,0.00,0.00),('1','142','798','257873',4905125,'2233','342',166534.30,166886.01,0.00,0.00,351.71,274333.80,0.00,0.00,0.00),('1','142','799','257873',4905126,'2234','342',182195.02,183080.02,0.00,0.00,885.00,654900.00,0.00,0.00,0.00),('1','142','798','257874',4905127,'2231','342',175803.99,176539.99,0.00,0.00,736.00,544640.00,0.00,0.00,0.00),('1','142','799','257874',4905128,'2232','342',200560.63,201317.84,0.00,0.00,757.21,590623.80,0.00,0.00,0.00),('1','142','798','257874',4905129,'2233','342',166886.01,167689.73,0.00,0.00,803.72,626901.60,0.00,0.00,0.00),('1','142','799','257874',4905130,'2234','342',183080.02,183995.04,0.00,0.00,915.02,677114.80,0.00,0.00,0.00),('1','142','798','257875',4905131,'2231','342',176539.99,177226.99,0.00,0.00,687.00,508380.00,0.00,0.00,0.00),('1','142','799','257875',4905132,'2232','342',201317.84,201655.98,0.00,0.00,338.14,263749.20,0.00,0.00,0.00),('1','142','798','257875',4905133,'2233','342',167689.73,168497.53,0.00,0.00,807.80,630084.00,0.00,0.00,0.00),('1','142','799','257875',4905134,'2234','342',183995.04,184095.04,0.00,0.00,100.00,74000.00,0.00,0.00,0.00),('1','142','798','257876',4905135,'2231','342',177226.99,178285.99,0.00,0.00,1059.00,783660.00,0.00,0.00,0.00),('1','142','799','257876',4905136,'2232','342',201655.98,201661.98,0.00,0.00,6.00,4680.00,0.00,0.00,0.00),('1','142','798','257876',4905137,'2233','342',168497.53,169433.70,0.00,0.00,936.17,730212.60,0.00,0.00,0.00),('1','142','799','257876',4905138,'2234','342',184095.04,184095.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257877',4905139,'2231','342',178285.99,178895.29,0.00,0.00,609.30,451282.00,0.00,0.00,0.00),('1','142','799','257877',4905140,'2232','342',201661.98,201661.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257877',4905141,'2233','342',169433.70,170132.85,0.00,0.00,699.15,545337.00,0.00,0.00,0.00),('1','142','799','257877',4905142,'2234','342',184095.04,184095.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257878',4905143,'2231','342',178895.29,179195.29,0.00,0.00,300.00,222000.00,0.00,0.00,0.00),('1','142','799','257878',4905144,'2232','342',201661.98,201918.81,0.00,0.00,256.83,200327.40,0.00,0.00,0.00),('1','142','798','257878',4905145,'2233','342',170132.85,170948.77,0.00,0.00,815.92,636417.60,0.00,0.00,0.00),('1','142','799','257878',4905146,'2234','342',184095.04,187272.06,0.00,0.00,3177.02,2351494.80,0.00,0.00,0.00),('1','142','798','257879',4905147,'2231','342',179195.29,179795.29,0.00,0.00,600.00,444000.00,0.00,0.00,0.00),('1','142','799','257879',4905148,'2232','342',201918.81,204349.61,0.00,0.00,2430.80,1896024.00,0.00,0.00,0.00),('1','142','798','257879',4905149,'2233','342',170948.77,171435.05,0.00,0.00,486.28,379298.40,0.00,0.00,0.00),('1','142','799','257879',4905150,'2234','342',187272.06,188274.36,0.00,0.00,1002.30,741702.00,0.00,0.00,0.00),('1','142','798','257880',4905151,'2231','342',179795.29,181372.34,0.00,0.00,1577.05,1167017.00,0.00,0.00,0.00),('1','142','799','257880',4905152,'2232','342',204349.61,205161.92,0.00,0.00,812.31,633601.80,0.00,0.00,0.00),('1','142','798','257880',4905153,'2233','342',171435.05,171959.28,0.00,0.00,524.23,408899.40,0.00,0.00,0.00),('1','142','799','257880',4905154,'2234','342',188274.36,189411.86,0.00,0.00,1137.50,841750.00,0.00,0.00,0.00),('1','142','798','257881',4905155,'2231','342',181372.34,182632.17,0.00,0.00,1259.83,932274.20,0.00,0.00,0.00),('1','142','799','257881',4905156,'2232','342',205161.92,205921.78,0.00,0.00,759.86,592690.80,0.00,0.00,0.00),('1','142','798','257881',4905157,'2233','342',171959.28,172248.22,0.00,0.00,288.94,225373.20,0.00,0.00,0.00),('1','142','799','257881',4905158,'2234','342',189411.86,190711.86,0.00,0.00,1300.00,962000.00,0.00,0.00,0.00),('1','142','798','257882',4905159,'2231','342',182632.17,182930.18,0.00,0.00,298.01,220527.40,0.00,0.00,0.00),('1','142','799','257882',4905160,'2232','342',205921.78,206518.57,0.00,0.00,596.79,465496.20,0.00,0.00,0.00),('1','142','798','257882',4905161,'2233','342',172248.22,172831.45,0.00,0.00,583.23,454919.40,0.00,0.00,0.00),('1','142','799','257882',4905162,'2234','342',190711.86,191225.51,0.00,0.00,513.65,380101.00,0.00,0.00,0.00),('1','142','798','257883',4905163,'2231','342',182930.18,183017.48,0.00,0.00,87.30,64602.00,0.00,0.00,0.00),('1','142','799','257883',4905164,'2232','342',206518.57,207267.23,0.00,0.00,748.66,583954.80,0.00,0.00,0.00),('1','142','798','257883',4905165,'2233','342',172831.45,173557.51,0.00,0.00,726.06,566326.80,0.00,0.00,0.00),('1','142','799','257883',4905166,'2234','342',191225.51,191755.51,0.00,0.00,530.00,392200.00,0.00,0.00,0.00),('1','142','798','257884',4905167,'2231','342',183017.48,183536.48,0.00,0.00,519.00,384060.00,0.00,0.00,0.00),('1','142','799','257884',4905168,'2232','342',207267.23,207951.65,0.00,0.00,684.42,533847.60,0.00,0.00,0.00),('1','142','798','257884',4905169,'2233','342',173557.51,174071.10,0.00,0.00,513.59,400600.20,0.00,0.00,0.00),('1','142','799','257884',4905170,'2234','342',191755.51,191821.51,0.00,0.00,66.00,48840.00,0.00,0.00,0.00),('1','142','798','257885',4905171,'2231','342',183536.48,184510.80,0.00,0.00,974.32,721360.80,0.00,0.00,0.00),('1','142','799','257885',4905172,'2232','342',207951.65,208647.11,0.00,0.00,695.46,542458.80,0.00,0.00,0.00),('1','142','798','257885',4905173,'2233','342',174071.10,174556.71,0.00,0.00,485.61,378775.80,0.00,0.00,0.00),('1','142','799','257885',4905174,'2234','342',191821.51,192557.42,0.00,0.00,735.91,544573.40,0.00,0.00,0.00),('1','142','798','257886',4905175,'2231','342',184510.80,184864.80,0.00,0.00,354.00,261960.00,0.00,0.00,0.00),('1','142','799','257886',4905176,'2232','342',208647.11,209366.10,0.00,0.00,718.99,560812.20,0.00,0.00,0.00),('1','142','798','257886',4905177,'2233','342',174556.71,175171.17,0.00,0.00,614.46,479278.80,0.00,0.00,0.00),('1','142','799','257886',4905178,'2234','342',192557.42,193648.06,0.00,0.00,1090.64,812222.00,0.00,0.00,0.00),('1','142','798','257887',4905179,'2231','342',184864.80,184919.29,0.00,0.00,54.49,40451.00,0.00,0.00,0.00),('1','142','799','257887',4905180,'2232','342',209366.10,210074.75,0.00,0.00,708.65,552747.00,0.00,0.00,0.00),('1','142','798','257887',4905181,'2233','342',175171.17,175804.39,0.00,0.00,633.22,493911.60,0.00,0.00,0.00),('1','142','799','257887',4905182,'2234','342',193648.06,194332.95,0.00,0.00,684.89,506818.60,0.00,0.00,0.00),('1','142','798','257888',4905183,'2231','342',184919.29,185229.29,0.00,0.00,310.00,229400.00,0.00,0.00,0.00),('1','142','799','257888',4905184,'2232','342',210074.75,210721.86,0.00,0.00,647.11,504745.80,0.00,0.00,0.00),('1','142','798','257888',4905185,'2233','342',175804.39,176464.63,0.00,0.00,660.24,514987.20,0.00,0.00,0.00),('1','142','799','257888',4905186,'2234','342',194332.95,195509.53,0.00,0.00,1176.58,870669.20,0.00,0.00,0.00),('1','142','798','257889',4905187,'2231','342',185229.29,185840.29,0.00,0.00,611.00,452140.00,0.00,0.00,0.00),('1','142','799','257889',4905188,'2232','342',210721.86,211273.50,0.00,0.00,551.64,430279.20,0.00,0.00,0.00),('1','142','798','257889',4905189,'2233','342',176464.63,177422.59,0.00,0.00,957.96,747208.80,0.00,0.00,0.00),('1','142','799','257889',4905190,'2234','342',195509.53,196699.53,0.00,0.00,1190.00,880600.00,0.00,0.00,0.00),('1','142','798','257890',4905191,'2231','342',185840.29,186090.29,0.00,0.00,250.00,185000.00,0.00,0.00,0.00),('1','142','799','257890',4905192,'2232','342',211273.50,212290.59,0.00,0.00,1017.09,793330.20,0.00,0.00,0.00),('1','142','798','257890',4905193,'2233','342',177422.59,177645.21,0.00,0.00,222.62,173643.60,0.00,0.00,0.00),('1','142','799','257890',4905194,'2234','342',196699.53,198300.00,0.00,0.00,1600.47,1184347.80,0.00,0.00,0.00),('1','142','798','257891',4905195,'2231','342',186090.29,186390.29,0.00,0.00,300.00,222179.60,0.00,0.00,0.00),('1','142','799','257891',4905196,'2232','342',212290.59,212921.69,0.00,0.00,631.10,492258.00,0.00,0.00,0.00),('1','142','798','257891',4905197,'2233','342',177645.21,178335.40,0.00,0.00,690.19,538348.20,0.00,0.00,0.00),('1','142','799','257891',4905198,'2234','342',198300.00,199300.65,0.00,0.00,1000.65,740481.00,0.00,0.00,0.00),('1','142','798','257892',4905199,'2231','342',186390.29,186445.29,0.00,0.00,55.00,41200.00,0.00,0.00,0.00),('1','142','799','257892',4905200,'2232','342',212921.69,213464.69,0.00,0.00,543.00,423540.00,0.00,0.00,0.00),('1','142','798','257892',4905201,'2233','342',178335.40,179082.92,0.00,0.00,747.52,583065.60,0.00,0.00,0.00),('1','142','799','257892',4905202,'2234','342',199300.65,200705.65,0.00,0.00,1405.00,1039700.00,0.00,0.00,0.00),('1','142','798','257893',4905203,'2231','342',186445.29,187513.79,0.00,0.00,1068.50,780505.00,0.00,0.00,0.00),('1','142','799','257893',4905204,'2232','342',213464.69,214299.70,0.00,0.00,835.01,651307.80,0.00,0.00,0.00),('1','142','798','257893',4905205,'2233','342',179082.92,179747.81,0.00,0.00,664.89,518614.20,0.00,0.00,0.00),('1','142','799','257893',4905206,'2234','342',200705.65,202097.26,0.00,0.00,1391.61,1026286.40,0.00,0.00,0.00),('1','142','798','257894',4905207,'2231','342',187513.79,187562.43,0.00,0.00,48.64,35993.60,0.00,0.00,0.00),('1','142','799','257894',4905208,'2232','342',214299.70,214628.51,0.00,0.00,328.81,256471.80,0.00,0.00,0.00),('1','142','798','257894',4905209,'2233','342',179747.81,180026.97,0.00,0.00,279.16,217744.80,0.00,0.00,0.00),('1','142','799','257894',4905210,'2234','342',202097.26,203307.26,0.00,0.00,1210.00,885400.00,0.00,0.00,0.00),('1','142','798','257895',4905211,'2231','342',187562.43,187562.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257895',4905212,'2232','342',214628.51,214628.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257895',4905213,'2233','342',180026.97,180026.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257895',4905214,'2234','342',203307.26,203307.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257896',4905215,'2231','342',187562.43,187562.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257896',4905216,'2232','342',214628.51,214628.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257896',4905217,'2233','342',180026.97,180026.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257896',4905218,'2234','342',203307.26,203307.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257897',4905219,'2231','342',187562.43,187562.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257897',4905220,'2232','342',214628.51,214628.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257897',4905221,'2233','342',180026.97,180026.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257897',4905222,'2234','342',203307.26,203307.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257898',4905223,'2231','342',187562.43,188019.00,0.00,0.00,456.57,337861.80,0.00,0.00,0.00),('1','142','799','257898',4905224,'2232','342',214628.51,215161.84,0.00,0.00,533.33,396197.40,0.00,0.00,0.00),('1','142','798','257898',4905225,'2233','342',180026.97,180346.57,0.00,0.00,319.60,249288.00,0.00,0.00,0.00),('1','142','799','257898',4905226,'2234','342',203307.26,204903.68,0.00,0.00,1596.42,1181350.80,0.00,0.00,0.00),('1','142','798','257899',4905227,'2231','342',188019.00,188619.00,0.00,0.00,600.00,444307.60,0.00,0.00,0.00),('1','142','799','257899',4905228,'2232','342',215161.84,215912.41,0.00,0.00,750.57,585444.60,0.00,0.00,0.00),('1','142','798','257899',4905229,'2233','342',180346.57,180987.28,0.00,0.00,640.71,499753.80,0.00,0.00,0.00),('1','142','799','257899',4905230,'2234','342',204903.68,205978.68,0.00,0.00,1075.00,795500.00,0.00,0.00,0.00),('1','142','798','257900',4905231,'2231','342',188619.00,189587.00,0.00,0.00,968.00,716320.00,0.00,0.00,0.00),('1','142','799','257900',4905232,'2232','342',215912.41,216671.56,0.00,0.00,759.15,592137.00,0.00,0.00,0.00),('1','142','798','257900',4905233,'2233','342',180987.28,181576.06,0.00,0.00,588.78,459248.40,0.00,0.00,0.00),('1','142','799','257900',4905234,'2234','342',205978.68,208108.68,0.00,0.00,2130.00,1576200.00,0.00,0.00,0.00),('1','142','798','257901',4905235,'2231','342',189587.00,189642.00,0.00,0.00,55.00,40700.00,0.00,0.00,0.00),('1','142','799','257901',4905236,'2232','342',216671.56,217351.43,0.00,0.00,679.87,530298.60,0.00,0.00,0.00),('1','142','798','257901',4905237,'2233','342',181576.06,182261.66,0.00,0.00,685.60,534768.00,0.00,0.00,0.00),('1','142','799','257901',4905238,'2234','342',208108.68,209250.68,0.00,0.00,1142.00,845080.00,0.00,0.00,0.00),('1','142','798','257902',4905239,'2231','342',189642.00,189980.00,0.00,0.00,338.00,250120.00,0.00,0.00,0.00),('1','142','799','257902',4905240,'2232','342',217351.43,218184.68,0.00,0.00,833.25,649935.00,0.00,0.00,0.00),('1','142','798','257902',4905241,'2233','342',182261.66,182968.54,0.00,0.00,706.88,551366.40,0.00,0.00,0.00),('1','142','799','257902',4905242,'2234','342',209250.68,210384.97,0.00,0.00,1134.29,839374.60,0.00,0.00,0.00),('1','142','798','257903',4905243,'2231','342',189980.00,190237.00,0.00,0.00,257.00,190180.00,0.00,0.00,0.00),('1','142','799','257903',4905244,'2232','342',218184.68,218880.46,0.00,0.00,695.78,542708.40,0.00,0.00,0.00),('1','142','798','257903',4905245,'2233','342',182968.54,183684.63,0.00,0.00,716.09,558550.20,0.00,0.00,0.00),('1','142','799','257903',4905246,'2234','342',210384.97,211519.97,0.00,0.00,1135.00,839900.00,0.00,0.00,0.00),('1','142','798','257904',4905247,'2231','342',190237.00,190337.00,0.00,0.00,100.00,74000.00,0.00,0.00,0.00),('1','142','799','257904',4905248,'2232','342',218880.46,219552.74,0.00,0.00,672.28,524378.40,0.00,0.00,0.00),('1','142','798','257904',4905249,'2233','342',183684.63,184439.56,0.00,0.00,754.93,588845.40,0.00,0.00,0.00),('1','142','799','257904',4905250,'2234','342',211519.97,212482.47,0.00,0.00,962.50,712250.00,0.00,0.00,0.00),('1','142','798','257905',4905251,'2231','342',190337.00,190942.00,0.00,0.00,605.00,447700.00,0.00,0.00,0.00),('1','142','799','257905',4905252,'2232','342',219552.74,220011.19,0.00,0.00,458.45,357591.00,0.00,0.00,0.00),('1','142','798','257905',4905253,'2233','342',184439.56,185009.67,0.00,0.00,570.11,444685.80,0.00,0.00,0.00),('1','142','799','257905',4905254,'2234','342',212482.47,213946.47,0.00,0.00,1464.00,1083360.00,0.00,0.00,0.00),('1','142','798','257906',4905255,'2231','342',190942.00,191097.00,0.00,0.00,155.00,114700.00,0.00,0.00,0.00),('1','142','799','257906',4905256,'2232','342',220011.19,220012.47,0.00,0.00,1.28,998.40,0.00,0.00,0.00),('1','142','798','257906',4905257,'2233','342',185009.67,185439.66,0.00,0.00,429.99,335392.20,0.00,0.00,0.00),('1','142','799','257906',4905258,'2234','342',213946.47,213946.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257907',4905259,'2231','342',191097.00,191097.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257907',4905260,'2232','342',220012.47,220012.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257907',4905261,'2233','342',185439.66,185439.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257907',4905262,'2234','342',213946.47,213946.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257908',4905263,'2231','342',191097.00,191927.53,0.00,0.00,830.53,614592.20,0.00,0.00,0.00),('1','142','799','257908',4905264,'2232','342',220012.47,221320.22,0.00,0.00,1307.75,1020045.00,0.00,0.00,0.00),('1','142','798','257908',4905265,'2233','342',185439.66,185619.52,0.00,0.00,179.86,140290.80,0.00,0.00,0.00),('1','142','799','257908',4905266,'2234','342',213946.47,215601.30,0.00,0.00,1654.83,1208025.90,0.00,0.00,0.00),('1','142','798','257909',4905267,'2231','342',191927.53,192666.35,0.00,0.00,738.82,546726.80,0.00,0.00,0.00),('1','142','799','257909',4905268,'2232','342',221320.22,222200.03,0.00,0.00,879.81,685251.80,0.00,0.00,0.00),('1','142','798','257909',4905269,'2233','342',185619.52,186070.31,0.00,0.00,450.79,351616.20,0.00,0.00,0.00),('1','142','799','257909',4905270,'2234','342',215601.30,216926.21,0.00,0.00,1324.91,980433.40,0.00,0.00,0.00),('1','142','798','257910',4905271,'2231','342',192666.35,192776.35,0.00,0.00,110.00,81400.00,0.00,0.00,0.00),('1','142','799','257910',4905272,'2232','342',222200.03,222830.89,0.00,0.00,630.86,492070.80,0.00,0.00,0.00),('1','142','798','257910',4905273,'2233','342',186070.31,186783.00,0.00,0.00,712.69,555898.20,0.00,0.00,0.00),('1','142','799','257910',4905274,'2234','342',216926.21,217690.21,0.00,0.00,764.00,565360.00,0.00,0.00,0.00),('1','142','798','257911',4905275,'2231','342',192776.35,193589.35,0.00,0.00,813.00,600120.00,0.00,0.00,0.00),('1','142','799','257911',4905276,'2232','342',222830.89,223606.05,0.00,0.00,775.16,604624.80,0.00,0.00,0.00),('1','142','798','257911',4905277,'2233','342',186783.00,187282.77,0.00,0.00,499.77,389820.60,0.00,0.00,0.00),('1','142','799','257911',4905278,'2234','342',217690.21,218861.20,0.00,0.00,1170.99,864732.60,0.00,0.00,0.00),('1','142','798','257912',4905279,'2231','342',193589.35,194342.74,0.00,0.00,753.39,557508.60,0.00,0.00,0.00),('1','142','798','257912',4905280,'2233','342',187282.77,187869.36,0.00,0.00,586.59,457540.20,0.00,0.00,0.00),('1','142','799','257912',4905281,'2234','342',218861.20,220573.20,0.00,0.00,1712.00,1266880.00,0.00,0.00,0.00),('1','142','799','257912',4905282,'2232','342',223606.05,224371.82,0.00,0.00,765.77,597300.60,0.00,0.00,0.00),('1','142','798','257913',4905283,'2231','342',194342.74,194622.74,0.00,0.00,280.00,207200.00,0.00,0.00,0.00),('1','142','799','257913',4905284,'2232','342',224371.82,224986.47,0.00,0.00,614.65,479427.00,0.00,0.00,0.00),('1','142','798','257913',4905285,'2233','342',187869.36,188637.61,0.00,0.00,768.25,599235.00,0.00,0.00,0.00),('1','142','799','257913',4905286,'2234','342',220573.20,221372.25,0.00,0.00,799.05,591297.00,0.00,0.00,0.00),('1','142','798','257914',4905287,'2231','342',194622.74,194882.74,0.00,0.00,260.00,192400.00,0.00,0.00,0.00),('1','142','799','257914',4905288,'2232','342',224986.47,225749.47,0.00,0.00,763.00,595140.00,0.00,0.00,0.00),('1','142','798','257914',4905289,'2233','342',188637.61,189190.79,0.00,0.00,553.18,431480.40,0.00,0.00,0.00),('1','142','799','257914',4905290,'2234','342',221372.25,222147.39,0.00,0.00,775.14,573603.60,0.00,0.00,0.00),('1','142','798','257915',4905291,'2231','342',194882.74,195136.79,0.00,0.00,254.05,187997.00,0.00,0.00,0.00),('1','142','799','257915',4905292,'2232','342',225749.47,226410.31,0.00,0.00,660.84,515455.20,0.00,0.00,0.00),('1','142','798','257915',4905293,'2233','342',189190.79,189799.87,0.00,0.00,609.08,475082.40,0.00,0.00,0.00),('1','142','799','257915',4905294,'2234','342',222147.39,223133.39,0.00,0.00,986.00,729640.00,0.00,0.00,0.00),('1','142','798','257916',4905295,'2231','342',195136.79,195536.79,0.00,0.00,400.00,296000.00,0.00,0.00,0.00),('1','142','799','257916',4905296,'2232','342',226410.31,226459.35,0.00,0.00,49.04,38251.20,0.00,0.00,0.00),('1','142','798','257916',4905297,'2233','342',189799.87,189864.84,0.00,0.00,64.97,50676.60,0.00,0.00,0.00),('1','142','799','257916',4905298,'2234','342',223133.39,223333.39,0.00,0.00,200.00,148000.00,0.00,0.00,0.00),('1','142','798','257917',4905299,'2231','342',195536.79,195536.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257917',4905300,'2232','342',226459.35,226459.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257917',4905301,'2233','342',189864.84,189864.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257917',4905302,'2234','342',223333.39,223333.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257918',4905303,'2231','342',195536.79,195990.25,0.00,0.00,453.46,335560.40,0.00,0.00,0.00),('1','142','799','257918',4905304,'2232','342',226459.35,227012.05,0.00,0.00,552.70,431106.00,0.00,0.00,0.00),('1','142','798','257918',4905305,'2233','342',189864.84,190348.34,0.00,0.00,483.50,377130.00,0.00,0.00,0.00),('1','142','799','257918',4905306,'2234','342',223333.39,224308.39,0.00,0.00,975.00,721500.00,0.00,0.00,0.00),('1','142','798','257919',4905307,'2231','342',195990.25,196450.25,0.00,0.00,460.00,354400.00,0.00,0.00,0.00),('1','142','799','257919',4905308,'2232','342',227012.05,227445.61,0.00,0.00,433.56,338176.80,0.00,0.00,0.00),('1','142','798','257919',4905309,'2233','342',190348.34,190915.44,0.00,0.00,567.10,442338.00,0.00,0.00,0.00),('1','142','799','257919',4905310,'2234','342',224308.39,225646.76,0.00,0.00,1338.37,990393.80,0.00,0.00,0.00),('1','142','798','257920',4905311,'2231','342',196450.25,196700.25,0.00,0.00,250.00,185000.00,0.00,0.00,0.00),('1','142','799','257920',4905312,'2232','342',227445.61,227869.60,0.00,0.00,423.99,330712.20,0.00,0.00,0.00),('1','142','798','257920',4905313,'2233','342',190915.44,191487.35,0.00,0.00,571.91,446089.80,0.00,0.00,0.00),('1','142','799','257920',4905314,'2234','342',225646.76,227120.00,0.00,0.00,1473.24,1090197.60,0.00,0.00,0.00),('1','142','798','257921',4905315,'2231','342',196700.25,196800.25,0.00,0.00,100.00,74000.00,0.00,0.00,0.00),('1','142','799','257921',4905316,'2232','342',227869.60,228442.49,0.00,0.00,572.89,446854.20,0.00,0.00,0.00),('1','142','798','257921',4905317,'2233','342',191487.35,192127.07,0.00,0.00,639.72,498981.60,0.00,0.00,0.00),('1','142','799','257921',4905318,'2234','342',227120.00,227596.41,0.00,0.00,476.41,352543.40,0.00,0.00,0.00),('1','142','798','257922',4905319,'2231','342',196800.25,196937.25,0.00,0.00,137.00,101380.00,0.00,0.00,0.00),('1','142','799','257922',4905320,'2232','342',228442.49,228994.10,0.00,0.00,551.61,430255.80,0.00,0.00,0.00),('1','142','798','257922',4905321,'2233','342',192127.07,192870.62,0.00,0.00,743.55,579969.00,0.00,0.00,0.00),('1','142','799','257922',4905322,'2234','342',227596.41,228002.41,0.00,0.00,406.00,300440.00,0.00,0.00,0.00),('1','142','798','257923',4905323,'2231','342',196937.25,197737.25,0.00,0.00,800.00,592000.00,0.00,0.00,0.00),('1','142','799','257923',4905324,'2232','342',228994.10,229630.49,0.00,0.00,636.39,496384.20,0.00,0.00,0.00),('1','142','798','257923',4905325,'2233','342',192870.62,193330.21,0.00,0.00,459.59,358480.20,0.00,0.00,0.00),('1','142','799','257923',4905326,'2234','342',228002.41,228913.35,0.00,0.00,910.94,674095.60,0.00,0.00,0.00),('1','142','798','257924',4905327,'2231','342',197737.25,198408.73,0.00,0.00,671.48,496895.20,0.00,0.00,0.00),('1','142','799','257924',4905328,'2232','342',229630.49,230314.46,0.00,0.00,683.97,533496.60,0.00,0.00,0.00),('1','142','798','257924',4905329,'2233','342',193330.21,193893.09,0.00,0.00,562.88,439046.40,0.00,0.00,0.00),('1','142','799','257924',4905330,'2234','342',228913.35,229937.01,0.00,0.00,1023.66,757508.40,0.00,0.00,0.00),('1','142','798','257925',4905331,'2231','342',198408.73,198528.73,0.00,0.00,120.00,88800.00,0.00,0.00,0.00),('1','142','799','257925',4905332,'2232','342',230314.46,230435.81,0.00,0.00,121.35,94653.00,0.00,0.00,0.00),('1','142','798','257925',4905333,'2233','342',193893.09,194518.67,0.00,0.00,625.58,487952.40,0.00,0.00,0.00),('1','142','799','257925',4905334,'2234','342',229937.01,230102.01,0.00,0.00,165.00,122100.00,0.00,0.00,0.00),('1','142','798','257926',4905335,'2231','342',198528.73,199086.51,0.00,0.00,557.78,412757.20,0.00,0.00,0.00),('1','142','799','257926',4905336,'2232','342',230435.81,231457.20,0.00,0.00,1021.39,796684.20,0.00,0.00,0.00),('1','142','798','257926',4905337,'2233','342',194518.67,195004.74,0.00,0.00,486.07,379134.60,0.00,0.00,0.00),('1','142','799','257926',4905338,'2234','342',230102.01,231067.98,0.00,0.00,965.97,714817.80,0.00,0.00,0.00),('1','142','798','257927',4905339,'2231','342',199086.51,199136.51,0.00,0.00,50.00,37000.00,0.00,0.00,0.00),('1','142','799','257927',4905340,'2232','342',231457.20,231978.45,0.00,0.00,521.25,406575.00,0.00,0.00,0.00),('1','142','798','257927',4905341,'2233','342',195004.74,195665.00,0.00,0.00,660.26,515002.80,0.00,0.00,0.00),('1','142','799','257927',4905342,'2234','342',231067.98,231387.98,0.00,0.00,320.00,236800.00,0.00,0.00,0.00),('1','142','798','257928',4905343,'2231','342',199136.51,200315.27,0.00,0.00,1178.76,872282.40,0.00,0.00,0.00),('1','142','799','257928',4905344,'2232','342',231978.45,232150.61,0.00,0.00,172.16,134284.80,0.00,0.00,0.00),('1','142','798','257928',4905345,'2233','342',195665.00,195914.13,0.00,0.00,249.13,194321.40,0.00,0.00,0.00),('1','142','799','257928',4905346,'2234','342',231387.98,231387.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257929',4905347,'2231','342',200315.27,200315.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257929',4905348,'2232','342',232150.61,232150.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257929',4905349,'2233','342',195914.13,195914.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257929',4905350,'2234','342',231387.98,231387.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257930',4905351,'2231','342',200315.27,200621.27,0.00,0.00,306.00,226440.00,0.00,0.00,0.00),('1','142','798','257930',4905352,'2233','342',195914.13,196087.20,0.00,0.00,173.07,134994.60,0.00,0.00,0.00),('1','142','799','257930',4905353,'2234','342',231387.98,234050.47,0.00,0.00,2662.49,1943617.70,0.00,0.00,0.00),('1','142','799','257930',4905354,'2232','342',232150.61,232520.04,0.00,0.00,369.43,288155.40,0.00,0.00,0.00),('1','142','798','257931',4905355,'2231','342',200621.27,200621.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257931',4905356,'2232','342',232520.04,233146.21,0.00,0.00,626.17,488412.60,0.00,0.00,0.00),('1','142','798','257931',4905357,'2233','342',196087.20,196675.11,0.00,0.00,587.91,458569.80,0.00,0.00,0.00),('1','142','799','257931',4905358,'2234','342',234050.47,234250.47,0.00,0.00,200.00,148000.00,0.00,0.00,0.00),('1','142','798','257932',4905359,'2231','342',200621.27,200935.29,0.00,0.00,314.02,226094.40,0.00,0.00,0.00),('1','142','799','257932',4905360,'2232','342',233146.21,233672.02,0.00,0.00,525.81,399615.60,0.00,0.00,0.00),('1','142','798','257932',4905361,'2233','342',196675.11,197217.62,0.00,0.00,542.51,412307.60,0.00,0.00,0.00),('1','142','799','257932',4905362,'2234','342',234250.47,235260.36,0.00,0.00,1009.89,727120.80,0.00,0.00,0.00),('1','142','798','257933',4905363,'2231','342',200935.29,201135.29,0.00,0.00,200.00,144000.00,0.00,0.00,0.00),('1','142','799','257933',4905364,'2232','342',233672.02,234438.42,0.00,0.00,766.40,582464.00,0.00,0.00,0.00),('1','142','798','257933',4905365,'2233','342',197217.62,197940.09,0.00,0.00,722.47,549077.20,0.00,0.00,0.00),('1','142','799','257933',4905366,'2234','342',235260.36,236065.36,0.00,0.00,805.00,579600.00,0.00,0.00,0.00),('1','142','798','257934',4905367,'2231','342',201135.29,201295.29,0.00,0.00,160.00,115200.00,0.00,0.00,0.00),('1','142','799','257934',4905368,'2232','342',234438.42,235171.29,0.00,0.00,732.87,556981.20,0.00,0.00,0.00),('1','142','798','257934',4905369,'2233','342',197940.09,198542.13,0.00,0.00,602.04,457550.40,0.00,0.00,0.00),('1','142','799','257934',4905370,'2234','342',236065.36,237250.14,0.00,0.00,1184.78,853041.60,0.00,0.00,0.00),('1','142','798','257935',4905371,'2231','342',201295.29,201395.29,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','142','799','257935',4905372,'2232','342',235171.29,235733.04,0.00,0.00,561.75,426930.00,0.00,0.00,0.00),('1','142','798','257935',4905373,'2233','342',198542.13,199159.90,0.00,0.00,617.77,469505.20,0.00,0.00,0.00),('1','142','799','257935',4905374,'2234','342',237250.14,238120.11,0.00,0.00,869.97,626378.40,0.00,0.00,0.00),('1','142','798','257936',4905375,'2231','342',201395.29,201495.29,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','142','799','257936',4905376,'2232','342',235733.04,236337.06,0.00,0.00,604.02,459055.20,0.00,0.00,0.00),('1','142','798','257936',4905377,'2233','342',199159.90,199823.05,0.00,0.00,663.15,503994.00,0.00,0.00,0.00),('1','142','799','257936',4905378,'2234','342',238120.11,239030.11,0.00,0.00,910.00,655200.00,0.00,0.00,0.00),('1','142','798','257937',4905379,'2231','342',201495.29,201800.29,0.00,0.00,305.00,219600.00,0.00,0.00,0.00),('1','142','799','257937',4905380,'2232','342',236337.06,236802.60,0.00,0.00,465.54,353810.40,0.00,0.00,0.00),('1','142','798','257937',4905381,'2233','342',199823.05,200265.59,0.00,0.00,442.54,336330.40,0.00,0.00,0.00),('1','142','799','257937',4905382,'2234','342',239030.11,239949.93,0.00,0.00,919.82,662270.40,0.00,0.00,0.00),('1','142','798','257938',4905383,'2231','342',201800.29,202055.29,0.00,0.00,255.00,183600.00,0.00,0.00,0.00),('1','142','799','257938',4905384,'2232','342',236802.60,237531.17,0.00,0.00,728.57,553713.20,0.00,0.00,0.00),('1','142','798','257938',4905385,'2233','342',200265.59,200886.15,0.00,0.00,620.56,471625.60,0.00,0.00,0.00),('1','142','799','257938',4905386,'2234','342',239949.93,241384.94,0.00,0.00,1435.01,1033207.20,0.00,0.00,0.00),('1','142','798','257939',4905387,'2231','342',202055.29,202715.29,0.00,0.00,660.00,475200.00,0.00,0.00,0.00),('1','142','799','257939',4905388,'2232','342',237531.17,238103.64,0.00,0.00,572.47,435077.20,0.00,0.00,0.00),('1','142','798','257939',4905389,'2233','342',200886.15,201368.32,0.00,0.00,482.17,366449.20,0.00,0.00,0.00),('1','142','799','257939',4905390,'2234','342',241384.94,242384.85,0.00,0.00,999.91,719935.20,0.00,0.00,0.00),('1','142','798','257940',4905391,'2231','342',202715.29,203040.29,0.00,0.00,325.00,234000.00,0.00,0.00,0.00),('1','142','799','257940',4905392,'2232','342',238103.64,238469.44,0.00,0.00,365.80,278008.00,0.00,0.00,0.00),('1','142','798','257940',4905393,'2233','342',201368.32,201881.71,0.00,0.00,513.39,390176.40,0.00,0.00,0.00),('1','142','799','257940',4905394,'2234','342',242384.85,242534.85,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','142','798','257941',4905395,'2231','342',203040.29,203240.13,0.00,0.00,199.84,143884.80,0.00,0.00,0.00),('1','142','799','257941',4905396,'2232','342',238469.44,238876.56,0.00,0.00,407.12,309411.20,0.00,0.00,0.00),('1','142','798','257941',4905397,'2233','342',201881.71,202495.48,0.00,0.00,613.77,466465.20,0.00,0.00,0.00),('1','142','799','257941',4905398,'2234','342',242534.85,242884.94,0.00,0.00,350.09,252068.40,0.00,0.00,0.00),('1','142','798','257942',4905399,'2231','342',203240.13,203606.13,0.00,0.00,366.00,263520.00,0.00,0.00,0.00),('1','142','799','257942',4905400,'2232','342',238876.56,239480.58,0.00,0.00,604.02,459055.20,0.00,0.00,0.00),('1','142','798','257942',4905401,'2233','342',202495.48,203195.73,0.00,0.00,700.25,532190.00,0.00,0.00,0.00),('1','142','799','257942',4905402,'2234','342',242884.94,243640.94,0.00,0.00,756.00,544320.00,0.00,0.00,0.00),('1','142','798','257943',4905403,'2231','342',203606.13,203614.13,0.00,0.00,8.00,5760.00,0.00,0.00,0.00),('1','142','799','257943',4905404,'2232','342',239480.58,240051.91,0.00,0.00,571.33,434210.80,0.00,0.00,0.00),('1','142','798','257943',4905405,'2233','342',203195.73,203800.71,0.00,0.00,604.98,459784.80,0.00,0.00,0.00),('1','142','799','257943',4905406,'2234','342',243640.94,243640.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257944',4905407,'2231','342',203614.13,203819.13,0.00,0.00,205.00,147600.00,0.00,0.00,0.00),('1','142','799','257944',4905408,'2232','342',240051.91,240453.82,0.00,0.00,401.91,305451.60,0.00,0.00,0.00),('1','142','798','257944',4905409,'2233','342',203800.71,204229.18,0.00,0.00,428.47,325637.20,0.00,0.00,0.00),('1','142','799','257944',4905410,'2234','342',243640.94,244178.38,0.00,0.00,537.44,386956.80,0.00,0.00,0.00),('1','142','798','257945',4905411,'2231','342',203819.13,203819.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257945',4905412,'2232','342',240453.82,241173.95,0.00,0.00,720.13,547298.80,0.00,0.00,0.00),('1','142','798','257945',4905413,'2233','342',204229.18,205010.75,0.00,0.00,781.57,593993.20,0.00,0.00,0.00),('1','142','799','257945',4905414,'2234','342',244178.38,244378.38,0.00,0.00,200.00,144000.00,0.00,0.00,0.00),('1','142','798','257946',4905415,'2231','342',203819.13,204644.13,0.00,0.00,825.00,594000.00,0.00,0.00,0.00),('1','142','799','257946',4905416,'2232','342',241173.95,241692.80,0.00,0.00,518.85,394326.00,0.00,0.00,0.00),('1','142','798','257946',4905417,'2233','342',205010.75,205401.48,0.00,0.00,390.73,296954.80,0.00,0.00,0.00),('1','142','799','257946',4905418,'2234','342',244378.38,244528.38,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','142','798','257947',4905419,'2231','342',204644.13,204874.13,0.00,0.00,230.00,165600.00,0.00,0.00,0.00),('1','142','799','257947',4905420,'2232','342',241692.80,242328.30,0.00,0.00,635.50,482980.00,0.00,0.00,0.00),('1','142','798','257947',4905421,'2233','342',205401.48,206053.23,0.00,0.00,651.75,495330.00,0.00,0.00,0.00),('1','142','799','257947',4905422,'2234','342',244528.38,244528.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257948',4905423,'2231','342',204874.13,205148.13,0.00,0.00,274.00,197332.80,0.00,0.00,0.00),('1','142','799','257948',4905424,'2232','342',242328.30,242727.66,0.00,0.00,399.36,303513.60,0.00,0.00,0.00),('1','142','798','257948',4905425,'2233','342',206053.23,206933.77,0.00,0.00,880.54,669210.40,0.00,0.00,0.00),('1','142','799','257948',4905426,'2234','342',244528.38,246178.38,0.00,0.00,1650.00,1183050.00,0.00,0.00,0.00),('1','142','798','257949',4905427,'2231','342',205148.13,205598.13,0.00,0.00,450.00,324002.40,0.00,0.00,0.00),('1','142','799','257949',4905428,'2232','342',242727.66,243491.14,0.00,0.00,763.48,580244.80,0.00,0.00,0.00),('1','142','798','257949',4905429,'2233','342',206933.77,207635.28,0.00,0.00,701.51,533147.60,0.00,0.00,0.00),('1','142','799','257949',4905430,'2234','342',246178.38,246398.38,0.00,0.00,220.00,158400.00,0.00,0.00,0.00),('1','142','798','257950',4905431,'2231','342',205598.13,206148.13,0.00,0.00,550.00,396263.20,0.00,0.00,0.00),('1','142','799','257950',4905432,'2232','342',243491.14,244481.66,0.00,0.00,990.52,752795.20,0.00,0.00,0.00),('1','142','798','257950',4905433,'2233','342',207635.28,208208.21,0.00,0.00,572.93,435426.80,0.00,0.00,0.00),('1','142','799','257950',4905434,'2234','342',246398.38,246598.38,0.00,0.00,200.00,144000.00,0.00,0.00,0.00),('1','142','798','257951',4905435,'2231','342',206148.13,206248.13,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','142','799','257951',4905436,'2232','342',244481.66,245321.01,0.00,0.00,839.35,637906.00,0.00,0.00,0.00),('1','142','798','257951',4905437,'2233','342',208208.21,209051.90,0.00,0.00,843.69,641204.40,0.00,0.00,0.00),('1','142','799','257951',4905438,'2234','342',246598.38,247148.38,0.00,0.00,550.00,396000.00,0.00,0.00,0.00),('1','142','798','257952',4905439,'2231','342',206248.13,206248.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257952',4905440,'2232','342',245321.01,245411.32,0.00,0.00,90.31,68635.60,0.00,0.00,0.00),('1','142','798','257952',4905441,'2233','342',209051.90,209059.14,0.00,0.00,7.24,5502.40,0.00,0.00,0.00),('1','142','799','257952',4905442,'2234','342',247148.38,247148.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257953',4905443,'2231','342',206248.13,206698.13,0.00,0.00,450.00,324000.00,0.00,0.00,0.00),('1','142','799','257953',4905444,'2232','342',245411.32,246220.84,0.00,0.00,809.52,615235.20,0.00,0.00,0.00),('1','142','798','257953',4905445,'2233','342',209059.14,209837.99,0.00,0.00,778.85,591926.00,0.00,0.00,0.00),('1','142','799','257953',4905446,'2234','342',247148.38,247748.38,0.00,0.00,600.00,432480.00,0.00,0.00,0.00),('1','142','798','257954',4905447,'2231','342',206698.13,207549.13,0.00,0.00,851.00,604450.00,0.00,0.00,0.00),('1','142','799','257954',4905448,'2232','342',246220.84,247208.89,0.00,0.00,988.05,741037.50,0.00,0.00,0.00),('1','142','798','257954',4905449,'2233','342',209837.99,210548.34,0.00,0.00,710.35,532762.50,0.00,0.00,0.00),('1','142','799','257954',4905450,'2234','342',247748.38,249128.37,0.00,0.00,1379.99,979792.90,0.00,0.00,0.00),('1','142','798','257955',4905451,'2231','342',207549.13,207649.13,0.00,0.00,100.00,71000.00,0.00,0.00,0.00),('1','142','799','257955',4905452,'2232','342',247208.89,247910.80,0.00,0.00,701.91,526432.50,0.00,0.00,0.00),('1','142','798','257955',4905453,'2233','342',210548.34,211276.97,0.00,0.00,728.63,546472.50,0.00,0.00,0.00),('1','142','799','257955',4905454,'2234','342',249128.37,249128.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257956',4905455,'2231','342',207649.13,207984.82,0.00,0.00,335.69,238339.90,0.00,0.00,0.00),('1','142','799','257956',4905456,'2232','342',247910.80,248576.46,0.00,0.00,665.66,499245.00,0.00,0.00,0.00),('1','142','798','257956',4905457,'2233','342',211276.97,212013.55,0.00,0.00,736.58,552435.00,0.00,0.00,0.00),('1','142','799','257956',4905458,'2234','342',249128.37,249778.37,0.00,0.00,650.00,461500.00,0.00,0.00,0.00),('1','142','798','257957',4905459,'2231','342',207984.82,207984.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257957',4905460,'2232','342',248576.46,249150.54,0.00,0.00,574.08,430560.00,0.00,0.00,0.00),('1','142','798','257957',4905461,'2233','342',212013.55,212526.99,0.00,0.00,513.44,385080.00,0.00,0.00,0.00),('1','142','799','257957',4905462,'2234','342',249778.37,250228.37,0.00,0.00,450.00,319500.00,0.00,0.00,0.00),('1','142','798','257958',4905463,'2231','342',207984.82,208584.82,0.00,0.00,600.00,426000.00,0.00,0.00,0.00),('1','142','799','257958',4905464,'2232','342',249150.54,249916.94,0.00,0.00,766.40,574800.00,0.00,0.00,0.00),('1','142','798','257958',4905465,'2233','342',212526.99,213105.85,0.00,0.00,578.86,434145.00,0.00,0.00,0.00),('1','142','799','257958',4905466,'2234','342',250228.37,250503.37,0.00,0.00,275.00,195250.00,0.00,0.00,0.00),('1','142','798','257959',4905467,'2231','342',208584.82,208784.82,0.00,0.00,200.00,142000.00,0.00,0.00,0.00),('1','142','799','257959',4905468,'2232','342',249916.94,250584.87,0.00,0.00,667.93,500947.50,0.00,0.00,0.00),('1','142','798','257959',4905469,'2233','342',213105.85,213837.74,0.00,0.00,731.89,548917.50,0.00,0.00,0.00),('1','142','799','257959',4905470,'2234','342',250503.37,250853.37,0.00,0.00,350.00,248500.00,0.00,0.00,0.00),('1','142','798','257960',4905471,'2231','342',208784.82,208834.82,0.00,0.00,50.00,35500.00,0.00,0.00,0.00),('1','142','799','257960',4905472,'2232','342',250584.87,251145.96,0.00,0.00,561.09,420817.50,0.00,0.00,0.00),('1','142','798','257960',4905473,'2233','342',213837.74,214450.53,0.00,0.00,612.79,459592.50,0.00,0.00,0.00),('1','142','799','257960',4905474,'2234','342',250853.37,251156.37,0.00,0.00,303.00,215250.00,0.00,0.00,0.00),('1','142','798','257961',4905475,'2231','342',208834.82,208934.82,0.00,0.00,100.00,71000.00,0.00,0.00,0.00),('1','142','799','257961',4905476,'2232','342',251145.96,251820.91,0.00,0.00,674.95,506212.50,0.00,0.00,0.00),('1','142','798','257961',4905477,'2233','342',214450.53,215127.68,0.00,0.00,677.15,507862.50,0.00,0.00,0.00),('1','142','799','257961',4905478,'2234','342',251156.37,251353.40,0.00,0.00,197.03,139891.30,0.00,0.00,0.00),('1','142','798','257962',4905479,'2231','342',208934.82,209984.82,0.00,0.00,1050.00,745500.00,0.00,0.00,0.00),('1','142','799','257962',4905480,'2232','342',251820.91,252647.18,0.00,0.00,826.27,619702.50,0.00,0.00,0.00),('1','142','798','257962',4905481,'2233','342',215127.68,215729.91,0.00,0.00,602.23,451672.50,0.00,0.00,0.00),('1','142','799','257962',4905482,'2234','342',251353.40,252153.40,0.00,0.00,800.00,568000.00,0.00,0.00,0.00),('1','142','798','257963',4905483,'2231','342',209984.82,210234.82,0.00,0.00,250.00,177500.00,0.00,0.00,0.00),('1','142','799','257963',4905484,'2232','342',252647.18,253323.01,0.00,0.00,675.83,506872.50,0.00,0.00,0.00),('1','142','798','257963',4905485,'2233','342',215729.91,216369.36,0.00,0.00,639.45,479587.50,0.00,0.00,0.00),('1','142','799','257963',4905486,'2234','342',252153.40,252618.40,0.00,0.00,465.00,330150.00,0.00,0.00,0.00),('1','142','798','257964',4905487,'2231','342',210234.82,210584.82,0.00,0.00,350.00,248500.00,0.00,0.00,0.00),('1','142','799','257964',4905488,'2232','342',253323.01,253920.18,0.00,0.00,597.17,447877.50,0.00,0.00,0.00),('1','142','798','257964',4905489,'2233','342',216369.36,217019.17,0.00,0.00,649.81,487357.50,0.00,0.00,0.00),('1','142','799','257964',4905490,'2234','342',252618.40,252618.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','798','257965',4905491,'2231','342',210584.82,210763.79,0.00,0.00,178.97,127068.70,0.00,0.00,0.00),('1','142','799','257965',4905492,'2232','342',253920.18,254485.98,0.00,0.00,565.80,424350.00,0.00,0.00,0.00),('1','142','798','257965',4905493,'2233','342',217019.17,217767.06,0.00,0.00,747.89,560917.50,0.00,0.00,0.00),('1','142','799','257965',4905494,'2234','342',252618.40,252896.40,0.00,0.00,278.00,197380.00,0.00,0.00,0.00),('1','142','798','257966',4905495,'2231','342',210763.79,210772.23,0.00,0.00,8.44,6072.40,0.00,0.00,0.00),('1','142','799','257966',4905496,'2232','342',254485.98,255223.06,0.00,0.00,737.08,552810.00,0.00,0.00,0.00),('1','142','798','257966',4905497,'2233','342',217767.06,218255.06,0.00,0.00,488.00,366000.00,0.00,0.00,0.00),('1','142','799','257966',4905498,'2234','342',252896.40,253671.40,0.00,0.00,775.00,550250.00,0.00,0.00,0.00),('1','142','798','257967',4905499,'2231','342',210772.23,210881.92,0.00,0.00,109.69,77879.90,0.00,0.00,0.00),('1','142','799','257967',4905500,'2232','342',255223.06,255775.35,0.00,0.00,552.29,414217.50,0.00,0.00,0.00),('1','142','798','257967',4905501,'2233','342',218255.06,219025.63,0.00,0.00,770.57,577927.50,0.00,0.00,0.00),('1','142','799','257967',4905502,'2234','342',253671.40,253820.91,0.00,0.00,149.51,106152.10,0.00,0.00,0.00),('1','142','798','257968',4905503,'2231','342',210881.92,210881.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257968',4905504,'2232','342',255775.35,256372.71,0.00,0.00,597.36,448020.00,0.00,0.00,0.00),('1','142','798','257968',4905505,'2233','342',219025.63,219695.76,0.00,0.00,670.13,502597.50,0.00,0.00,0.00),('1','142','799','257968',4905506,'2234','342',253820.91,255271.61,0.00,0.00,1450.70,1029997.00,0.00,0.00,0.00),('1','142','798','257969',4905507,'2231','342',210881.92,211156.92,0.00,0.00,275.00,195250.00,0.00,0.00,0.00),('1','142','799','257969',4905508,'2232','342',256372.71,257007.76,0.00,0.00,635.05,476287.50,0.00,0.00,0.00),('1','142','798','257969',4905509,'2233','342',219695.76,220324.13,0.00,0.00,628.37,471277.50,0.00,0.00,0.00),('1','142','799','257969',4905510,'2234','342',255271.61,255621.61,0.00,0.00,350.00,248500.00,0.00,0.00,0.00),('1','142','798','257970',4905511,'2231','342',211156.92,212111.92,0.00,0.00,955.00,678050.00,0.00,0.00,0.00),('1','142','799','257970',4905512,'2232','342',257007.76,257882.89,0.00,0.00,875.13,656347.50,0.00,0.00,0.00),('1','142','798','257970',4905513,'2233','342',220324.13,221039.27,0.00,0.00,715.14,536355.00,0.00,0.00,0.00),('1','142','799','257970',4905514,'2234','342',255621.61,256856.61,0.00,0.00,1235.00,876850.00,0.00,0.00,0.00),('1','142','798','257971',4905515,'2231','342',212111.92,212271.92,0.00,0.00,160.00,113600.00,0.00,0.00,0.00),('1','142','799','257971',4905516,'2232','342',257882.89,258626.50,0.00,0.00,743.61,557707.50,0.00,0.00,0.00),('1','142','798','257971',4905517,'2233','342',221039.27,221923.92,0.00,0.00,884.65,663487.50,0.00,0.00,0.00),('1','142','799','257971',4905518,'2234','342',256856.61,257627.61,0.00,0.00,771.00,547623.20,0.00,0.00,0.00),('1','142','798','257972',4905519,'2231','342',212271.92,212566.92,0.00,0.00,295.00,209450.00,0.00,0.00,0.00),('1','142','799','257972',4905520,'2232','342',258626.50,259622.12,0.00,0.00,995.62,746715.00,0.00,0.00,0.00),('1','142','798','257972',4905521,'2233','342',221923.92,222937.62,0.00,0.00,1013.70,760275.00,0.00,0.00,0.00),('1','142','799','257972',4905522,'2234','342',257627.61,259221.61,0.00,0.00,1594.00,1131740.00,0.00,0.00,0.00),('1','142','798','257973',4905523,'2231','342',212566.92,213301.92,0.00,0.00,735.00,521850.00,0.00,0.00,0.00),('1','142','799','257973',4905524,'2232','342',259622.12,260198.36,0.00,0.00,576.24,432180.00,0.00,0.00,0.00),('1','142','798','257973',4905525,'2233','342',222937.62,223343.87,0.00,0.00,406.25,304687.50,0.00,0.00,0.00),('1','142','799','257973',4905526,'2234','342',259221.61,260436.61,0.00,0.00,1215.00,862650.00,0.00,0.00,0.00),('1','142','798','257974',4905527,'2231','342',213301.92,213301.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','142','799','257974',4905528,'2232','342',260198.36,260648.83,0.00,0.00,450.47,337852.50,0.00,0.00,0.00),('1','142','798','257974',4905529,'2233','342',223343.87,223719.08,0.00,0.00,375.21,281407.50,0.00,0.00,0.00),('1','142','799','257974',4905530,'2234','342',260436.61,260662.61,0.00,0.00,226.00,160460.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730131 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','142','149918','342',213.00,280.00,0.00,3473.30,739812.90,774644.00,34831.10,449123),('1','142','150025','342',213.00,280.00,0.00,1720.80,366530.40,404674.00,38143.60,449402),('1','142','150209','342',213.00,280.00,0.00,1735.70,369704.10,416546.00,46841.90,449899),('1','142','150491','342',213.00,280.00,0.00,1322.35,281660.55,316733.00,35072.45,450643),('1','142','150529','342',213.00,280.00,0.00,1357.20,289083.60,324616.00,35532.40,450747),('1','142','150701','342',213.00,280.00,0.00,5573.60,1187176.80,1273053.00,85876.20,451197),('1','142','150827','342',213.00,280.00,0.00,1214.50,258688.50,297060.00,38371.50,451532),('1','142','150937','342',213.00,280.00,0.00,1868.50,397990.50,442195.00,44204.50,451815),('1','142','151090','342',213.00,280.00,0.00,1023.40,217984.20,253927.00,35942.80,452225),('1','142','151252','342',213.00,280.00,0.00,1664.10,354453.30,396827.60,42374.30,452681),('1','142','151351','342',213.00,280.00,0.00,2610.00,555930.00,622495.40,66565.40,452938),('1','142','151577','342',213.00,280.00,0.00,2631.80,560573.40,620729.00,60155.60,453562),('1','142','151689','342',213.00,280.00,0.00,1518.60,323461.80,367508.00,44046.20,453869),('1','142','151779','342',213.00,280.00,0.00,572.50,121942.50,154525.00,32582.50,454098),('1','142','151886','342',213.00,280.00,0.00,3766.20,802200.60,849536.00,47335.40,454375),('1','142','152040','342',213.00,280.00,0.00,1133.20,241371.60,275020.00,33648.40,454790),('1','142','152200','342',213.00,280.00,0.00,566.40,120643.20,151156.00,30512.80,455207),('1','142','152357','342',213.00,280.00,0.00,1473.80,313919.40,359222.00,45302.60,455631),('1','142','152544','342',213.00,280.00,0.00,4441.50,946039.50,1034788.00,88748.50,456144),('1','142','152657','342',213.00,280.00,0.00,588.00,125244.00,154240.00,28996.00,456427),('1','142','152903','342',213.00,280.00,0.00,1537.90,327572.70,370292.00,42719.30,457098),('1','142','152989','342',213.00,280.00,0.00,1807.30,384954.90,405186.00,20231.10,457347),('1','142','153069','342',213.00,280.00,0.00,4034.40,859327.20,924536.00,65208.80,457551),('1','142','153153','342',213.00,280.00,0.00,518.50,110440.50,139980.00,29539.50,457778),('1','142','153461','342',213.00,280.00,0.00,769.00,163797.00,194468.00,30671.00,458639),('1','142','153592','342',213.00,280.00,0.00,2880.70,613589.10,678164.00,64574.90,458978),('1','142','153702','342',213.00,280.00,0.00,691.60,147310.80,182728.00,35417.20,459266),('1','142','153834','342',213.00,280.00,0.00,1984.00,422592.00,478768.00,56176.00,459622),('1','142','154044','342',213.00,280.00,0.00,2484.70,529241.10,595876.00,66634.90,460167),('1','142','154226','342',213.00,280.00,0.00,1984.90,422783.70,478526.00,55742.30,460667),('1','142','154306','342',213.00,280.00,0.00,3612.20,769398.60,850866.00,81467.40,460862),('1','142','154469','342',213.00,280.00,0.00,2193.10,467130.30,525682.00,58551.70,461308),('1','142','154630','342',213.00,280.00,0.00,1056.00,224928.00,237312.00,12384.00,461747),('1','142','154697','342',213.00,280.00,0.00,1350.70,287699.10,319464.00,31764.90,461936),('1','142','154856','342',213.00,280.00,0.00,891.90,189974.70,229712.00,39737.30,462378),('1','142','155006','342',213.00,280.00,0.00,4084.40,869977.20,947536.00,77558.80,462778),('1','142','155122','342',213.00,280.00,0.00,2833.30,603492.90,675084.00,71591.10,463095),('1','142','155304','342',213.00,280.00,0.00,5124.90,1091603.70,1188186.00,96582.30,463572),('1','142','155424','342',213.00,0.00,0.00,4228.20,900606.60,970794.00,70187.40,463905),('1','142','155620','342',213.00,280.00,0.00,2550.50,543256.50,624258.00,81001.50,464437),('1','142','155711','342',213.00,280.00,0.00,1366.70,291107.10,309496.00,18388.90,464680),('1','142','155912','342',213.00,280.00,0.00,1768.90,376775.70,424806.00,48030.30,465206),('1','142','156065','342',213.00,280.00,0.00,3536.00,753168.00,806894.00,53726.00,465619),('1','142','156188','342',213.00,280.00,0.00,792.50,168802.50,201880.00,33077.50,465935),('1','142','156401','342',213.00,280.00,0.00,4428.50,943270.50,1000320.00,57049.50,466499),('1','142','156578','342',213.00,280.00,0.00,4376.60,932215.80,1014658.00,82442.20,466967),('1','142','156721','342',213.00,280.00,0.00,1233.90,262820.70,293206.00,30385.30,467375),('1','142','156888','342',213.00,280.00,0.00,1832.00,390216.00,434700.00,44484.00,467828),('1','142','157056','342',213.00,280.00,0.00,1127.90,240242.70,263092.00,22849.30,468280),('1','142','157252','342',213.00,280.00,0.00,1820.00,387660.00,420444.00,32784.00,468771),('1','142','157430','342',213.00,280.00,0.00,1065.80,227015.40,266054.00,39038.60,469228),('1','142','157573','342',213.00,280.00,0.00,797.00,169761.00,183458.00,13697.00,469588),('1','142','157637','342',213.00,280.00,0.00,1094.00,233022.00,274134.00,41112.00,469770),('1','142','157773','342',213.00,280.00,0.00,3778.60,804841.80,873180.00,68338.20,470136),('1','142','157936','342',213.00,280.00,0.00,2700.20,575142.60,618174.00,43031.40,470572),('1','142','158068','342',213.00,280.00,0.00,1018.40,216919.20,250338.00,33418.80,470913),('1','142','158240','342',213.00,0.00,0.00,5807.40,1236976.20,1321662.40,84686.20,471370),('1','142','158410','342',213.00,280.00,0.00,2492.50,530902.50,571308.00,40405.50,471820),('1','142','158559','342',213.00,280.00,0.00,2937.10,625602.30,698965.00,73362.70,472201),('1','142','158729','342',213.00,280.00,0.00,2445.00,520785.00,550986.00,30201.00,472659),('1','142','159242','342',213.00,280.00,0.00,3841.60,818260.80,902012.00,83751.20,474025),('1','142','159441','342',213.00,280.00,0.00,3937.60,838708.80,933016.00,94307.20,474512),('1','142','159619','342',213.00,280.00,0.00,3466.50,738364.50,822960.00,84595.50,474992),('1','142','159725','342',213.00,280.00,0.00,2589.20,551499.60,607796.00,56296.40,475243),('1','142','159921','342',213.00,280.00,0.00,3878.70,826163.10,912356.00,86192.90,475754),('1','142','160110','342',213.00,280.00,0.00,774.20,164904.60,197016.00,32111.40,476242),('1','142','160301','342',213.00,280.00,0.00,2605.40,554950.20,609826.40,54876.20,476740),('1','142','160378','342',213.00,280.00,0.00,190.00,40470.00,48000.00,7530.00,476938),('1','142','160450','342',213.00,280.00,0.00,835.50,177961.50,214765.60,36804.10,477131),('1','142','160585','342',213.00,280.00,0.00,1264.90,269423.70,325444.00,56020.30,477490),('1','142','160733','342',213.00,280.00,0.00,2773.30,590712.90,687090.00,96377.10,477868),('1','142','160880','342',213.00,280.00,0.00,2361.90,503084.70,584960.00,81875.30,478220),('1','142','161080','342',213.00,280.00,0.00,3615.80,770165.40,896588.40,126423.00,478764),('1','142','161262','342',213.00,298.00,0.00,500.50,106606.50,124120.00,17513.50,479234),('1','142','161473','342',213.00,298.00,0.00,7423.80,1581269.40,1807972.40,226703.00,479739),('1','142','161851','342',213.00,298.00,0.00,3745.10,797706.30,952501.80,154795.50,480714),('1','142','161866','342',213.00,298.00,0.00,3240.30,690183.90,822359.80,132175.90,480748),('1','142','162035','342',213.00,298.00,0.00,884.60,188419.80,238293.20,49873.40,481212),('1','142','162224','342',213.00,298.00,0.00,1100.90,234491.70,297576.20,63084.50,481686),('1','142','162445','342',213.00,298.00,0.00,2649.50,564343.50,682777.80,118434.30,482260),('1','142','162663','342',213.00,298.00,0.00,0.00,0.00,0.00,0.00,482789),('1','142','162664','342',213.00,298.00,0.00,6820.90,1452851.70,1727292.20,274440.50,482790),('1','142','162799','342',213.00,298.00,0.00,2260.20,481422.60,585069.60,103647.00,483164),('1','142','163023','342',213.00,298.00,0.00,363.90,77510.70,98060.60,20549.90,483737),('1','142','163025','342',213.00,298.00,0.00,732.00,155916.00,203528.00,47612.00,483741),('1','142','163197','342',213.00,298.00,0.00,2314.40,492967.20,614930.80,121963.60,484189),('1','142','163363','342',213.00,298.00,0.00,727.30,154914.90,212630.20,57715.30,484622),('1','142','163569','342',213.00,298.00,0.00,1865.10,397266.30,504237.00,106970.70,485151),('1','142','163728','342',213.00,298.00,0.00,2663.80,567389.40,681594.40,114205.00,485586),('1','142','163760','342',213.00,298.00,0.00,7663.00,1632219.00,1935429.40,303210.40,485652),('1','142','163915','342',213.00,298.00,0.00,2529.20,538719.60,678339.40,139619.80,486048),('1','142','164101','342',213.00,298.00,0.00,1051.60,223990.80,300589.60,76598.80,486533),('1','142','164297','342',213.00,298.00,0.00,1603.80,341609.40,441348.80,99739.40,487052),('1','142','164480','342',213.00,298.00,0.00,6669.90,1420688.70,1822430.20,401741.50,487555),('1','142','164627','342',213.00,298.00,0.00,3321.80,707543.40,917740.40,210197.00,487948),('1','142','164780','342',213.00,298.00,0.00,1809.10,385338.30,510386.60,125048.30,488366),('1','142','165007','342',245.00,298.00,0.00,5715.60,1400322.00,1569464.80,169142.80,488930),('1','142','165170','342',245.00,320.00,0.00,4244.60,1039927.00,1265543.00,225616.00,489359),('1','142','165339','342',245.00,320.00,0.00,1939.00,475055.00,594296.00,119241.00,489792),('1','142','165467','342',245.00,320.00,0.00,2928.60,717507.00,884071.20,166564.20,490127),('1','142','165654','342',245.00,320.00,0.00,1741.40,426643.00,531488.80,104845.80,490629),('1','142','165814','342',245.00,320.00,0.00,2542.40,622888.00,572800.80,-50087.20,491060),('1','142','165996','342',245.00,320.00,0.00,1507.60,369362.00,468749.20,99387.20,491539),('1','142','166174','342',245.00,320.00,0.00,4126.60,1011017.00,1231444.40,220427.40,491996),('1','142','166550','342',270.00,320.00,0.00,2250.10,607527.00,678365.20,70838.20,493019),('1','142','166556','342',270.00,320.00,0.00,3075.10,830277.00,924606.80,94329.80,493033),('1','142','166686','342',270.00,320.00,0.00,775.00,209250.00,244642.40,35392.40,493392),('1','142','166914','342',270.00,320.00,0.00,2140.40,577908.00,648520.00,70612.00,493995),('1','142','167063','342',270.00,320.00,0.00,2006.00,541620.00,609352.00,67732.00,494397),('1','142','167172','342',270.00,320.00,0.00,783.80,211626.00,246522.40,34896.40,494699),('1','142','167362','342',270.00,320.00,0.00,4081.60,1102032.00,1212833.60,110801.60,495214),('1','142','167558','342',270.00,320.00,0.00,1568.20,423414.00,475806.00,52392.00,495725),('1','142','167759','342',270.00,320.00,0.00,3208.20,866214.00,952851.50,86637.50,496237),('1','142','167760','342',270.00,320.00,0.00,1817.20,490644.00,544740.80,54096.80,496238),('1','142','167918','342',270.00,320.00,0.00,2118.10,571887.00,637791.50,65904.50,496659),('1','142','168100','342',270.00,320.00,0.00,908.60,245322.00,286578.40,41256.40,497162),('1','142','168284','342',270.00,320.00,0.00,3294.20,889434.00,993124.00,103690.00,497643),('1','142','168435','342',270.00,320.00,0.00,705.70,190539.00,221936.00,31397.00,498048),('1','142','168599','342',270.00,320.00,0.00,3137.80,847206.00,946751.50,99545.50,498478),('1','142','168764','342',270.00,320.00,0.00,3420.60,923562.00,1020859.50,97297.50,498926),('1','142','168925','342',270.00,320.00,0.00,1081.30,291951.00,342416.00,50465.00,499347),('1','142','169140','342',270.00,320.00,0.00,6124.70,1653669.00,1835744.80,182075.80,499886),('1','142','169142','342',270.00,320.00,0.00,927.20,250344.00,281087.20,30743.20,499890),('1','142','169295','342',270.00,320.00,0.00,1133.90,306153.00,356650.00,50497.00,500270),('1','142','169462','342',270.00,320.00,0.00,3651.40,985878.00,1096556.30,110678.30,500703),('1','142','169563','342',270.00,320.00,0.00,2776.00,749520.00,832320.00,82800.00,500981),('1','142','169760','342',270.00,320.00,0.00,2816.70,760509.00,847852.00,87343.00,501514),('1','142','169915','342',270.00,320.00,0.00,2699.00,728730.00,816040.00,87310.00,501942),('1','142','170121','342',270.00,320.00,0.00,2561.10,691497.00,777981.40,86484.40,502451),('1','142','170399','342',270.00,320.00,0.00,1484.20,400734.00,459824.00,59090.00,503180),('1','142','170483','342',270.00,320.00,0.00,6270.40,1693008.00,1857874.00,164866.00,503403),('1','142','170720','342',270.00,320.00,0.00,541.30,146151.00,171776.00,25625.00,504019),('1','142','170826','342',270.00,320.00,0.00,2078.00,561060.00,642640.00,81580.00,504281),('1','142','170969','342',270.00,320.00,0.00,3144.70,849069.00,963004.70,113935.70,504680),('1','142','171249','342',270.00,320.00,0.00,1170.80,316116.00,367625.60,51509.60,505425),('1','142','171356','342',270.00,320.00,0.00,742.00,200340.00,235280.00,34940.00,505712),('1','142','171586','342',270.00,320.00,0.00,4174.20,1127034.00,1282588.80,155554.80,506324),('1','142','171763','342',270.00,320.00,0.00,3204.70,865269.00,986555.20,121286.20,506793),('1','142','171944','342',270.00,320.00,0.00,1970.20,531954.00,606651.20,74697.20,507272),('1','142','172103','342',270.00,320.00,0.00,3592.20,969894.00,1096109.20,126215.20,507670),('1','142','172286','342',270.00,320.00,0.00,934.20,252234.00,287228.80,34994.80,508171),('1','142','172287','342',270.00,320.00,0.00,3385.40,914058.00,1038430.40,124372.40,508172),('1','142','172495','342',270.00,320.00,0.00,1917.20,517644.00,593144.00,75500.00,508732),('1','142','172699','342',270.00,320.00,0.00,2609.50,704565.00,803719.80,99154.80,509267),('1','142','172876','342',270.00,320.00,0.00,1083.00,292410.00,340512.00,48102.00,509731),('1','142','173045','342',270.00,320.00,0.00,2040.20,550854.00,627643.20,76789.20,510186),('1','142','173245','342',270.00,320.00,0.00,1656.40,447228.00,513313.60,66085.60,510706),('1','142','173375','342',270.00,0.00,0.00,4237.40,1144098.00,1300104.00,156006.00,511057),('1','142','173586','342',281.00,320.00,0.00,3380.90,950032.90,1042360.00,92327.10,511630),('1','142','173759','342',281.00,320.00,0.00,3154.20,886330.20,971288.00,84957.80,512076),('1','142','173915','342',281.00,320.00,0.00,1661.80,466965.80,509372.80,42407.00,512498),('1','142','173916','342',281.00,320.00,0.00,1628.00,457468.00,501115.20,43647.20,512499),('1','142','174139','342',281.00,320.00,0.00,2091.80,587795.80,644672.00,56876.20,513066),('1','142','174298','342',276.00,320.00,0.00,1826.90,504224.40,566582.80,62358.40,513503),('1','142','174599','342',276.00,320.00,0.00,3428.90,946376.40,1055259.20,108882.80,514269),('1','142','174613','342',276.00,320.00,0.00,2550.30,703882.80,784134.40,80251.60,514297),('1','142','174858','342',276.00,320.00,0.00,3342.50,922530.00,1029533.00,107003.00,514937),('1','142','175065','342',276.00,352.00,0.00,0.00,0.00,0.00,0.00,515487),('1','142','175066','342',276.00,352.00,0.00,3230.90,891728.40,1038096.80,146368.40,515488),('1','142','175258','342',276.00,352.00,0.00,5551.70,1532269.20,1771541.40,239272.20,515991),('1','142','175402','342',276.00,352.00,0.00,2352.80,649372.80,772347.20,122974.40,516385),('1','142','175609','342',276.00,352.00,0.00,2842.00,784392.00,914989.00,130597.00,516914),('1','142','175794','342',276.00,352.00,0.00,2517.20,694747.20,823713.40,128966.20,517402),('1','142','175924','342',276.00,352.00,0.00,4454.40,1229414.40,1422648.80,193234.40,517738),('1','142','176159','342',298.00,352.00,0.00,2308.40,687903.20,748458.80,60555.60,518328),('1','142','176352','342',298.00,352.00,0.00,1873.40,558273.20,613776.40,55503.20,518825),('1','142','176574','342',298.00,352.00,0.00,2333.80,695472.40,771594.00,76121.60,519408),('1','142','176647','342',298.00,352.00,0.00,2401.00,715498.00,756546.20,41048.20,519616),('1','142','176774','342',298.00,352.00,0.00,3135.00,934230.00,1001419.20,67189.20,519963),('1','142','177029','342',298.00,352.00,0.00,3408.40,1015703.20,1101814.40,86111.20,520629),('1','142','177298','342',298.00,352.00,0.00,11509.60,3429860.80,3699134.60,269273.80,521330),('1','142','177846','342',298.00,352.00,0.00,0.00,0.00,0.00,0.00,522811),('1','142','178457','342',298.00,352.00,0.00,1977.90,589414.20,644094.20,54680.00,524413),('1','142','178460','342',298.00,352.00,0.00,3365.30,1002859.40,1080552.40,77693.00,524418),('1','142','178513','342',298.00,352.00,0.00,1405.60,418868.80,454996.30,36127.50,524542),('1','142','178518','342',298.00,352.00,0.00,2510.00,747980.00,795832.90,47852.90,524555),('1','142','178526','342',298.00,352.00,0.00,1598.00,476204.00,528778.60,52574.60,524575),('1','142','178848','342',298.00,352.00,0.00,4791.30,1427807.40,1587516.80,159709.40,525437),('1','142','178870','342',298.00,352.00,0.00,1262.20,376135.60,429718.80,53583.20,525490),('1','142','179046','342',0.00,352.00,0.00,2918.20,865898.60,966645.90,100747.30,525935),('1','142','179148','342',298.00,352.00,0.00,2325.00,692850.00,774522.88,81672.88,526198),('1','142','179379','342',298.00,352.00,0.00,1964.26,585349.48,664674.40,79324.92,526820),('1','142','179579','342',298.00,352.00,0.00,1597.37,476016.26,542385.20,66368.94,527350),('1','142','179777','342',298.00,352.00,0.00,2491.17,742368.66,828755.60,86386.94,527885),('1','142','179997','342',298.00,352.00,0.00,5537.37,1650136.26,1816581.94,166445.68,528455),('1','142','180190','342',298.00,352.00,0.00,1931.20,575497.60,648942.40,73444.80,528956),('1','142','180342','342',298.00,352.00,0.00,788.96,196602.52,262886.00,66283.48,529349),('1','142','180410','342',0.00,352.00,0.00,3620.07,0.00,1193933.12,1193933.12,529524),('1','142','180554','342',0.00,352.00,0.00,5928.08,369323.32,1929995.26,1560671.94,529912),('1','142','180767','342',298.00,352.00,0.00,3015.90,898738.20,997350.16,98611.96,530464),('1','142','180968','342',298.00,352.00,0.00,1257.48,374729.04,434496.96,59767.92,531008),('1','142','181137','342',298.00,352.00,0.00,1587.62,473110.76,533002.24,59891.48,531450),('1','142','181338','342',298.00,352.00,0.00,4393.29,1309200.42,1454052.96,144852.54,532001),('1','142','181471','342',298.00,352.00,0.00,2177.67,648945.66,711093.04,62147.38,532351),('1','142','181530','342',298.00,352.00,0.00,4149.03,1236410.94,1379396.68,142985.74,532495),('1','142','181714','342',298.00,352.00,0.00,2646.45,788642.10,884922.48,96280.38,532976),('1','142','181913','342',298.00,352.00,0.00,3345.78,997042.44,1106359.20,109316.76,533521),('1','142','182117','342',298.00,352.00,0.00,2659.75,792605.50,903272.00,110666.50,534061),('1','142','182319','342',298.00,352.00,0.00,1873.53,553378.34,623355.06,69976.72,534576),('1','142','182533','342',218.00,352.00,0.00,7933.81,1729570.58,2590785.38,861214.80,535156),('1','142','182667','342',218.00,360.00,0.00,2524.45,497332.12,837320.92,339988.80,535525),('1','142','182695','342',0.00,360.00,0.00,2200.47,0.00,771892.20,771892.20,535584),('1','142','182850','342',0.00,360.00,0.00,2656.96,0.00,919885.60,919885.60,536009),('1','142','182990','342',0.00,360.00,0.00,3975.93,0.00,1359520.80,1359520.80,536395),('1','142','183216','342',0.00,360.00,0.00,1525.26,0.00,533012.60,533012.60,536972),('1','142','183436','342',0.00,360.00,0.00,1594.27,0.00,557942.20,557942.20,537531),('1','142','183653','342',0.00,360.00,0.00,0.00,0.00,0.00,0.00,538112),('1','142','183654','342',0.00,360.00,0.00,3269.69,0.00,1121068.40,1121068.40,538113),('1','142','183912','342',0.00,360.00,0.00,1484.08,104002.74,519664.20,415661.46,538805),('1','142','184104','342',223.00,360.00,0.00,1615.58,360274.34,562848.80,202574.46,539313),('1','142','184286','342',223.00,360.00,0.00,1534.44,342180.12,534943.80,192763.68,539796),('1','142','184478','342',223.00,360.00,0.00,1378.65,307438.95,476864.00,169425.05,540284),('1','142','184706','342',223.00,360.00,0.00,1117.30,249157.90,389928.30,140770.40,540907),('1','142','184843','342',223.00,360.00,0.00,1288.89,287422.47,432459.90,145037.43,541287),('1','142','184906','342',223.00,360.00,0.00,911.12,203179.76,321823.20,118643.44,541440),('1','142','185119','342',223.00,360.00,0.00,2555.66,569912.18,858300.60,288388.42,541986),('1','142','185268','342',223.00,360.00,0.00,3771.20,840977.60,1259922.00,418944.40,542351),('1','142','185471','342',223.00,360.00,0.00,3673.29,819143.67,1229135.70,409992.03,542892),('1','142','185688','342',223.00,360.00,0.00,1473.72,328639.56,507300.80,178661.24,543474),('1','142','185886','342',223.00,360.00,0.00,4102.30,961124.78,1363776.90,402652.12,544000),('1','142','186098','342',315.00,360.00,0.00,676.66,213147.90,238143.00,24995.10,544561),('1','142','186333','342',315.00,360.00,0.00,3307.45,1041846.75,1110289.40,68442.65,545172),('1','142','186541','342',315.00,360.00,0.00,970.24,305625.60,337286.40,31660.80,545725),('1','142','186759','342',315.00,360.00,0.00,1872.03,589689.45,631038.20,41348.75,546289),('1','142','187002','342',315.00,360.00,0.00,151.74,47798.10,54626.40,6828.30,546899),('1','142','187026','342',315.00,360.00,0.00,2185.88,688552.20,733622.30,45070.10,546960),('1','142','187176','342',315.00,360.00,0.00,1500.74,472733.10,514733.60,42000.50,547364),('1','142','187380','342',315.00,360.00,0.00,2958.91,932056.65,991212.30,59155.65,547900),('1','142','187587','342',315.00,360.00,0.00,3447.57,1085984.55,1168824.50,82839.95,548448),('1','142','187816','342',315.00,360.00,0.00,2959.45,932226.75,1017281.20,85054.45,549058),('1','142','188023','342',315.00,360.00,0.00,7849.09,2472463.35,2615681.10,143217.75,549594),('1','142','188239','342',315.00,360.00,0.00,3420.58,1077482.70,1156864.20,79381.50,550155),('1','142','188437','342',315.00,360.00,0.00,2971.57,936044.55,1001098.20,65053.65,550665),('1','142','188539','342',315.00,360.00,0.00,497.56,156731.40,169839.90,13108.50,550932),('1','142','188615','342',315.00,360.00,0.00,1380.47,434848.05,480550.20,45702.15,551116),('1','142','188834','342',315.00,360.00,0.00,4582.99,1443641.85,1531426.40,87784.55,551700),('1','142','189085','342',315.00,360.00,0.00,2224.99,700871.85,759186.40,58314.55,552361),('1','142','189218','342',315.00,360.00,0.00,3774.26,1188891.90,1268813.60,79921.70,552700),('1','142','189426','342',315.00,360.00,0.00,4130.42,1301082.30,1356251.20,55168.90,553258),('1','142','189643','342',315.00,360.00,0.00,3732.08,1175605.20,1257998.80,82393.60,553809),('1','142','189840','342',315.00,360.00,0.00,2370.37,746666.55,810056.20,63389.65,554312),('1','142','190036','342',315.00,360.00,0.00,2711.31,854062.65,921364.60,67301.95,554835),('1','142','190227','342',315.00,360.00,0.00,6394.19,2014169.85,2146315.80,132145.95,555329),('1','142','190440','342',315.00,360.00,0.00,4411.51,1389625.65,1462756.60,73130.95,555890),('1','142','190505','342',315.00,360.00,0.00,2285.43,719910.45,786852.20,66941.75,556062),('1','142','190676','342',315.00,360.00,0.00,6340.80,1997352.00,2118539.20,121187.20,556515),('1','142','190909','342',315.00,360.00,0.00,2913.03,917604.45,970111.40,52506.95,557125),('1','142','191096','342',315.00,360.00,0.00,1748.05,550635.75,591858.00,41222.25,557612),('1','142','191327','342',315.00,360.00,0.00,2188.63,689418.45,734726.80,45308.35,558222),('1','142','191531','342',315.00,360.00,0.00,2239.63,705483.45,751461.80,45978.35,558759),('1','142','191729','342',315.00,360.00,0.00,3792.28,1194568.20,1272026.80,77458.60,559286),('1','142','191943','342',315.00,360.00,0.00,2439.33,768388.95,818985.80,50596.85,559872),('1','142','192158','342',315.00,360.00,0.00,753.68,237409.20,254005.80,16596.60,560434),('1','142','192222','342',315.00,360.00,0.00,3250.19,1023809.85,1079987.40,56177.55,560608),('1','142','192356','342',315.00,360.00,0.00,2683.63,845343.45,900747.80,55404.35,560951),('1','142','192587','342',315.00,360.00,0.00,1517.12,477892.80,513193.20,35300.40,561552),('1','142','192763','342',315.00,360.00,0.00,2465.90,776758.50,828449.00,51690.50,562016),('1','142','192960','342',315.00,360.00,0.00,2547.48,802456.20,853342.80,50886.60,562530),('1','142','193176','342',315.00,360.00,0.00,913.70,287815.50,314813.00,26997.50,563104),('1','142','193420','342',315.00,360.00,0.00,1122.38,353549.70,382966.80,29417.10,563739),('1','142','193633','342',315.00,360.00,0.00,7116.38,2241659.70,2366211.80,124552.10,564300),('1','142','193866','342',315.00,360.00,0.00,2687.92,846694.80,903666.60,56971.80,564875),('1','142','194094','342',315.00,360.00,0.00,450.05,141765.75,149181.60,7415.85,565440),('1','142','194113','342',315.00,360.00,0.00,3261.33,1027318.95,1085092.50,57773.55,565492),('1','142','194298','342',312.00,360.00,0.00,1368.45,426956.40,467339.00,40382.60,565983),('1','142','194493','342',312.00,360.00,0.00,3702.19,1155083.28,1228958.85,73875.57,566474),('1','142','194714','342',312.00,360.00,0.00,4049.68,1263500.16,1354029.80,90529.64,567035),('1','142','194945','342',312.00,360.00,0.00,3230.14,1007803.68,1085436.40,77632.72,567659),('1','142','195091','342',312.00,360.00,0.00,5803.41,1810663.92,1915797.60,105133.68,568027),('1','142','195311','342',312.00,360.00,0.00,1304.64,407047.68,450493.20,43445.52,568600),('1','142','195544','342',312.00,360.00,0.00,1747.05,545079.60,600338.00,55258.40,569192),('1','142','195794','342',312.00,360.00,0.00,51.50,16068.00,18540.00,2472.00,569811),('1','142','195812','342',312.00,360.00,0.00,3379.35,1054357.20,1122036.00,67678.80,569859),('1','142','196015','342',312.00,360.00,0.00,1783.55,556467.60,607643.00,51175.40,570382),('1','142','196240','342',312.00,360.00,0.00,2403.34,749842.08,813792.40,63950.32,570945),('1','142','196470','342',312.00,360.00,0.00,5907.65,1843186.80,1964729.00,121542.20,571538),('1','142','196672','342',312.00,360.00,0.00,5475.68,1708412.16,1841074.80,132662.64,572054),('1','142','196889','342',312.00,360.00,0.00,816.66,254797.92,277632.30,22834.38,572636),('1','142','197056','342',312.00,360.00,0.00,1884.19,587867.28,633804.00,45936.72,573053),('1','142','197334','342',312.00,360.00,0.00,3067.32,957003.84,1039293.60,82289.76,573799),('1','142','197340','342',312.00,360.00,0.00,2871.28,895839.36,964219.40,68380.04,573811),('1','142','197521','342',312.00,360.00,0.00,5156.61,1608862.32,1721184.20,112321.88,574176),('1','142','197894','342',312.00,360.00,0.00,1846.76,576189.12,626558.50,50369.38,575172),('1','142','198128','342',312.00,360.00,0.00,3245.97,1012742.64,1087140.20,74397.56,575775),('1','142','198367','342',312.00,360.00,0.00,2683.09,837124.08,907013.40,69889.32,576389),('1','142','198590','342',312.00,360.00,0.00,3460.91,1079803.92,1162724.10,82920.18,576972),('1','142','198795','342',312.00,360.00,0.00,2100.56,655374.72,716181.60,60806.88,577473),('1','142','198985','342',312.00,360.00,0.00,3539.38,1104286.56,1177736.80,73450.24,577982),('1','142','199143','342',312.00,360.00,0.00,1197.56,373638.72,402211.60,28572.88,578404),('1','142','199225','342',312.00,360.00,0.00,2062.54,643512.48,699854.40,56341.92,578574),('1','142','199452','342',312.00,360.00,0.00,4319.59,1344856.94,1438452.40,93595.53,579129),('1','142','199664','342',309.50,360.00,0.00,3124.80,967125.63,1055347.40,88221.83,579663),('1','142','199883','342',309.50,360.00,0.00,2222.30,687801.97,763878.00,76076.27,580192),('1','142','200104','342',309.50,360.00,0.00,7027.51,2175014.39,2327609.20,152594.90,580777),('1','142','200304','342',309.50,360.00,0.00,1836.56,568415.43,636267.20,67851.99,581296),('1','142','200502','342',309.50,360.00,0.00,2853.20,883065.46,967027.60,83962.26,581808),('1','142','200714','342',309.50,360.00,0.00,246.61,76325.80,85779.60,9453.81,582364),('1','142','200728','342',309.50,360.00,0.00,2869.67,888162.93,972541.20,84378.40,582399),('1','142','200939','342',309.50,360.00,0.00,4114.48,1273431.61,1383772.80,110341.29,582929),('1','142','201131','342',309.50,360.00,0.00,5671.07,1755196.25,1898723.10,143527.02,583415),('1','142','201331','342',309.50,360.00,0.00,2416.15,747798.50,826916.10,79117.75,583937),('1','142','201512','342',309.50,360.00,0.00,1590.69,492318.63,550938.40,58619.92,584412),('1','142','201783','342',309.50,360.00,0.00,2188.74,677415.10,749417.40,72002.44,585130),('1','142','202044','342',309.50,360.00,0.00,4863.16,563884.32,1682221.52,1118337.36,585820),('1','142','202266','342',0.00,368.00,0.00,1047.04,0.00,366991.54,366991.54,586384),('1','142','202304','342',0.00,368.00,0.00,4726.39,0.00,1646991.12,1646991.12,586490),('1','142','202444','342',0.00,368.00,0.00,1569.34,0.00,561747.88,561747.88,586844),('1','142','202663','342',0.00,368.00,0.00,4188.10,418705.65,1462353.54,1043648.00,587404),('1','142','202879','342',324.50,368.00,0.00,3455.29,1121241.75,1216191.54,94950.08,587954),('1','142','203127','342',324.50,368.00,0.00,2258.14,732766.53,799994.66,67228.33,588604),('1','142','203320','342',324.50,368.00,0.00,1430.62,464236.24,508801.62,44565.48,589117),('1','142','203537','342',324.50,368.00,0.00,2078.54,674486.36,737241.18,62755.08,589663),('1','142','203746','342',324.50,368.00,0.00,2553.75,828691.95,893592.72,64900.92,590201),('1','142','203983','342',324.50,368.00,0.00,2308.21,749014.16,810660.30,61646.17,590808),('1','142','204143','342',324.50,368.00,0.00,1100.00,356950.00,378160.00,21210.00,591252),('1','142','204206','342',324.50,368.00,0.00,4437.16,1439858.52,1537462.86,97604.54,591400),('1','142','204421','342',324.50,368.00,0.00,1683.77,546383.41,594693.56,48310.24,591951),('1','142','204640','342',324.50,368.00,0.00,1534.67,498000.49,547834.40,49834.06,592508),('1','142','204857','342',324.50,368.00,0.00,1242.06,400124.40,448827.78,48703.39,593037),('1','142','205057','342',322.00,368.00,0.00,3250.69,1046722.18,1135173.04,88450.86,593542),('1','142','205249','342',322.00,368.00,0.00,3803.99,1224884.78,1327261.64,102376.86,594052),('1','142','205486','342',322.00,368.00,0.00,1863.81,600146.82,661337.82,61191.00,594649),('1','142','205745','342',322.00,368.00,0.00,3450.78,1111151.16,1207031.60,95880.44,595328),('1','142','205965','342',322.00,368.00,0.00,1757.47,565905.34,608461.04,42555.70,595899),('1','142','205992','342',322.00,368.00,0.00,3149.87,1014258.14,1100545.86,86287.72,595971),('1','142','206171','342',322.00,368.00,0.00,3318.71,1068624.62,1169855.48,101230.86,596426),('1','142','206370','342',322.00,368.00,0.00,5269.51,1696782.22,1836665.68,139883.46,596930),('1','142','206587','342',322.00,368.00,0.00,2440.90,785969.80,862459.00,76489.20,597482),('1','142','206840','342',322.00,368.00,0.00,2618.65,843205.30,917537.50,74332.20,598133),('1','142','207051','342',322.00,368.00,0.00,1915.04,616642.88,674423.72,57780.84,598681),('1','142','207273','342',322.00,368.00,0.00,3972.65,1279193.30,1393787.12,114593.82,599257),('1','142','207617','342',322.00,368.00,0.00,1886.24,607369.28,667173.46,59804.18,600148),('1','142','208302','342',332.00,368.00,0.00,128.00,42496.00,47104.00,4608.00,601911),('1','142','208303','342',0.00,380.00,0.00,3666.90,0.00,1333847.00,1333847.00,601912),('1','142','208305','342',0.00,380.00,0.00,5080.80,0.00,1825929.00,1825929.00,601916),('1','142','208306','342',0.00,380.00,0.00,3465.60,0.00,1252706.00,1252706.00,601917),('1','142','208352','342',0.00,380.00,0.00,2359.46,0.00,861079.05,861079.05,602022),('1','142','208579','342',0.00,380.00,0.00,3512.58,0.00,1253480.40,1253480.40,602601),('1','142','208772','342',0.00,380.00,0.00,2401.10,0.00,860902.05,860902.05,603101),('1','142','209011','342',0.00,400.00,0.00,4149.56,1400650.40,1566483.08,165832.68,603696),('1','142','209147','342',340.00,400.00,0.00,1070.35,363919.00,405900.00,41981.00,604051),('1','142','209233','342',340.00,400.00,0.00,3221.86,1095432.40,1223553.36,128120.96,604271),('1','142','209453','342',340.00,400.00,0.00,3286.44,1117389.60,1258020.80,140631.20,604825),('1','142','209655','342',340.00,400.00,0.00,4444.75,1511215.00,1678965.12,167750.12,605346),('1','142','209881','342',0.00,420.00,0.00,2902.54,0.00,1137699.88,1137699.88,605930),('1','142','210114','342',0.00,420.00,0.00,3107.68,0.00,1219472.60,1219472.60,606540),('1','142','210324','342',0.00,420.00,0.00,1267.01,0.00,521740.26,521740.26,607083),('1','142','210525','342',0.00,420.00,0.00,2662.31,0.00,1035848.20,1035848.20,607614),('1','142','210742','342',0.00,420.00,0.00,1496.00,117108.64,577510.56,460401.92,608186),('1','142','210809','342',368.00,420.00,0.00,2011.53,740243.04,810357.12,70114.08,608358),('1','142','210977','342',368.00,420.00,0.00,5667.09,2085489.12,2188547.00,103057.88,608782),('1','142','211185','342',368.00,420.00,0.00,6620.95,2461171.16,2580466.72,119295.56,609314),('1','142','211397','342',382.00,424.00,0.00,8941.11,3415504.02,3554135.00,138630.98,609873),('1','142','211614','342',382.00,424.00,0.00,1518.95,580238.90,600230.20,19991.30,610441),('1','142','211663','342',382.00,424.00,0.00,557.21,212854.22,223386.64,10532.42,610561),('1','142','211803','342',382.00,424.00,0.00,1775.40,678202.80,712416.60,34213.80,610910),('1','142','212009','342',382.00,424.00,0.00,4175.31,1594968.42,1665104.44,70136.02,611446),('1','142','212252','342',382.00,424.00,0.00,2502.38,955909.16,1005846.10,49936.94,612080),('1','142','212476','342',382.00,424.00,0.00,4395.53,1679092.46,1759691.73,80599.27,612675),('1','142','212682','342',382.00,424.00,0.00,3454.97,1319798.54,1387390.38,67591.84,613223),('1','142','212895','342',382.00,424.00,0.00,2710.22,1035304.04,1092812.10,57508.06,613774),('1','142','213157','342',382.00,424.00,0.00,4857.25,1855469.50,1933137.00,77667.50,614461),('1','142','213413','342',0.00,431.00,0.00,1489.76,0.00,605322.56,605322.56,615111),('1','142','213589','342',0.00,431.00,0.00,5769.95,0.00,2324887.95,2324887.95,615604),('1','142','213657','342',0.00,431.00,0.00,3413.56,0.00,1403363.25,1403363.25,615766),('1','142','213906','342',0.00,431.00,0.00,1792.76,0.00,737480.29,737480.29,616420),('1','142','214113','342',0.00,431.00,0.00,6774.56,0.00,2735800.22,2735800.22,616955),('1','142','214361','342',0.00,431.00,0.00,6932.87,0.00,2756924.97,2756924.97,617602),('1','142','214544','342',382.00,431.00,0.00,3536.86,1351080.52,1451760.43,100679.91,618076),('1','142','214821','342',382.00,431.00,0.00,5859.98,2238512.36,2363725.77,125213.41,618799),('1','142','215033','342',382.00,431.00,0.00,4587.01,1752237.82,1857280.31,105042.49,619354),('1','142','215240','342',382.00,431.00,0.00,5263.39,2010614.98,2135987.53,125372.55,619876),('1','142','215457','342',382.00,431.00,0.00,5038.59,1924741.38,2013637.43,88896.05,620429),('1','142','215692','342',382.00,431.00,0.00,2026.10,773970.20,827842.10,53871.90,621045),('1','142','215695','342',382.00,431.00,0.00,2827.04,1079929.28,1172055.27,92125.99,621051),('1','142','215927','342',382.00,431.00,0.00,1854.89,708567.98,772364.19,63796.21,621645),('1','142','216122','342',382.00,431.00,0.00,2319.56,250729.52,982883.36,732153.84,622152),('1','142','216349','342',0.00,446.00,0.00,5492.76,0.00,2304400.49,2304400.49,622739),('1','142','216736','342',0.00,446.00,0.00,277.50,0.00,120665.00,120665.00,623782),('1','142','216803','342',0.00,446.00,0.00,5045.23,1933764.72,2126415.93,192651.21,623942),('1','142','217056','342',402.00,446.00,0.00,4507.31,0.00,1925842.80,1925842.80,624602),('1','142','217211','342',0.00,480.00,0.00,394.92,0.00,181281.60,181281.60,625028),('1','142','217304','342',0.00,480.00,0.00,2894.73,0.00,1306404.80,1306404.80,625254),('1','142','217517','342',0.00,480.00,0.00,3052.74,0.00,1378959.20,1378959.20,625814),('1','142','217760','342',0.00,480.00,0.00,3078.26,0.00,1403157.60,1403157.60,626444),('1','142','217990','342',0.00,480.00,0.00,2803.03,0.00,1265696.40,1265696.40,627055),('1','142','218243','342',0.00,480.00,0.00,2201.53,790752.76,1003626.40,212873.64,627716),('1','142','218488','342',427.00,480.00,0.00,2941.88,1256182.76,1326673.60,70490.84,628356),('1','142','218703','342',427.00,480.00,0.00,4052.98,1730622.46,1817263.20,86640.74,628909),('1','142','218928','342',427.00,480.00,0.00,3080.49,1315369.23,1396420.80,81051.57,629507),('1','142','219140','342',427.00,480.00,0.00,806.30,344290.10,353858.10,9568.00,630058),('1','142','219144','342',427.00,480.00,0.00,2211.45,944289.15,1008519.70,64230.55,630068),('1','142','219382','342',427.00,480.00,0.00,2222.16,948862.32,1010863.60,62001.28,630689),('1','142','219632','342',427.00,480.00,0.00,1465.97,625969.19,678365.60,52396.41,631349),('1','142','219835','342',427.00,480.00,0.00,2245.16,958683.32,1020138.40,61455.08,631880),('1','142','220073','342',427.00,480.00,0.00,5401.33,2306367.91,2417149.20,110781.29,632516),('1','142','220269','342',427.00,480.00,0.00,2343.87,1000832.49,1081259.20,80426.71,633032),('1','142','220478','342',427.00,480.00,0.00,3404.87,1453879.49,1545123.60,91244.11,633580),('1','142','220702','342',427.00,480.00,0.00,2196.36,937845.72,1007628.80,69783.08,634162),('1','142','220931','342',427.00,480.00,0.00,2973.27,1269586.29,1315885.60,46299.31,634758),('1','142','221004','342',427.00,480.00,0.00,2001.45,854619.15,913000.00,58380.85,634961),('1','142','221167','342',427.00,480.00,0.00,4503.52,1923003.04,2015422.00,92418.96,635363),('1','142','221400','342',427.00,480.00,0.00,6044.05,2580809.35,2711075.60,130266.25,635981),('1','142','221669','342',427.00,480.00,0.00,3321.37,1418224.99,1508216.60,89991.61,636686),('1','142','221845','342',427.00,480.00,0.00,5500.26,2348611.02,2470905.90,122294.88,637138),('1','142','222080','342',427.00,480.00,0.00,3300.05,1409121.35,1489399.20,80277.85,637755),('1','142','222195','342',427.00,480.00,0.00,2090.22,892523.94,924702.60,32178.66,638053),('1','142','222292','342',427.00,480.00,0.00,2220.61,948200.47,1016487.20,68286.73,638291),('1','142','222525','342',427.00,480.00,0.00,1809.48,772647.96,833094.40,60446.44,638887),('1','142','222783','342',427.00,480.00,0.00,118.47,50586.69,56865.60,6278.91,639574),('1','142','222984','342',427.00,480.00,0.00,5534.64,2363291.28,2472903.20,109611.92,640127),('1','142','222989','342',427.00,480.00,0.00,1829.89,781363.03,840547.20,59184.17,640140),('1','142','223193','342',427.00,480.00,0.00,5899.70,1984751.51,2626529.12,641777.61,640649),('1','142','223436','342',0.00,496.00,0.00,5064.67,2282459.31,2366191.72,83732.41,641243),('1','142','223658','342',477.00,496.00,0.00,430.62,205405.74,209847.52,4441.78,641816),('1','142','223722','342',477.00,496.00,0.00,1778.10,848153.70,838989.74,-9163.96,641986),('1','142','223883','342',477.00,496.00,0.00,1684.40,803458.80,813702.68,10243.88,642397),('1','142','224114','342',477.00,496.00,0.00,2796.43,1333897.11,1331777.28,-2119.83,642996),('1','142','224321','342',0.00,540.00,0.00,3647.48,0.00,1881235.20,1881235.20,643532),('1','142','224559','342',0.00,540.00,0.00,1645.60,0.00,859464.00,859464.00,644161),('1','142','224795','342',0.00,540.00,0.00,2583.09,0.00,1338784.60,1338784.60,644757),('1','142','225042','342',485.00,540.00,0.00,4648.08,2254318.80,2356007.20,101688.40,645390),('1','142','225290','342',485.00,540.00,0.00,3125.27,1515755.95,1588455.80,72699.85,646025),('1','142','225500','342',485.00,540.00,0.00,2891.33,1402295.05,1467690.20,65395.15,646577),('1','142','225641','342',485.00,540.00,0.00,117.26,56871.10,63320.40,6449.30,646961),('1','142','225721','342',485.00,540.00,0.00,1750.22,848856.70,905534.80,56678.10,647153),('1','142','225995','342',485.00,540.00,0.00,6863.84,3328962.40,3470853.60,141891.20,647870),('1','142','226257','342',485.00,540.00,0.00,1852.45,898438.25,958179.00,59740.75,648557),('1','142','226501','342',485.00,540.00,0.00,5338.44,2589143.40,2714027.60,124884.20,649164),('1','142','226761','342',485.00,540.00,0.00,3121.93,1514136.05,1596560.20,82424.15,649842),('1','142','226982','342',485.00,540.00,0.00,2983.62,1447055.70,1529034.80,81979.10,650431),('1','142','227197','342',485.00,540.00,0.00,1362.18,660657.30,719627.20,58969.90,650984),('1','142','227392','342',485.00,540.00,0.00,1332.50,646262.50,671166.00,24903.50,651479),('1','142','227455','342',485.00,540.00,0.00,2776.64,1346670.40,1413441.60,66771.20,651648),('1','142','227625','342',485.00,540.00,0.00,1863.30,903700.50,970232.00,66531.50,652079),('1','142','228097','342',482.00,540.00,0.00,2567.60,1237583.20,1315724.00,78140.80,653347),('1','142','228329','342',482.00,540.00,0.00,2343.80,1129711.60,1217068.00,87356.40,653944),('1','142','228509','342',482.00,540.00,0.00,5640.00,2718480.00,2890421.40,171941.40,654400),('1','142','228735','342',0.00,560.00,0.00,2967.20,0.00,1582576.60,1582576.60,654978),('1','142','228959','342',0.00,560.00,0.00,2467.90,0.00,1315824.00,1315824.00,655523),('1','142','229210','342',0.00,560.00,0.00,4080.00,0.00,2139854.40,2139854.40,656186),('1','142','229216','342',0.00,560.00,0.00,791.80,0.00,422542.40,422542.40,656200),('1','142','229436','342',0.00,560.00,0.00,2696.70,0.00,1438607.00,1438607.00,656769),('1','142','229644','342',0.00,584.00,0.00,2235.50,0.00,1244814.30,1244814.30,657324),('1','142','229869','342',0.00,584.00,0.00,6636.10,0.00,3603322.40,3603322.40,657903),('1','142','229972','342',0.00,584.00,0.00,3159.70,0.00,1727927.10,1727927.10,658148),('1','142','230259','342',0.00,584.00,0.00,1875.80,0.00,1040267.20,1040267.20,658908),('1','142','230450','342',0.00,584.00,0.00,1872.90,0.00,1044423.60,1044423.60,659398),('1','142','230792','342',0.00,584.00,0.00,4008.10,0.00,2190200.40,2190200.40,660265),('1','142','231123','342',0.00,584.00,0.00,1340.41,0.00,735999.44,735999.44,661149),('1','142','231125','342',0.00,584.00,0.00,719.89,0.00,406268.76,406268.76,661153),('1','142','231348','342',0.00,584.00,0.00,4601.60,0.00,2502511.40,2502511.40,661772),('1','142','231613','342',0.00,584.00,0.00,1712.80,0.00,953965.20,953965.20,662467),('1','142','232041','342',0.00,584.00,0.00,2837.90,0.00,1557441.80,1557441.80,663608),('1','142','232138','342',0.00,584.00,0.00,1709.20,0.00,950882.10,950882.10,663849),('1','142','232313','342',0.00,584.00,0.00,4130.90,0.00,2250953.40,2250953.40,664317),('1','142','232675','342',0.00,584.00,0.00,0.00,0.00,0.00,0.00,665265),('1','142','232677','342',0.00,584.00,0.00,4964.40,0.00,2699659.60,2699659.60,665269),('1','142','232979','342',0.00,584.00,0.00,2979.00,0.00,1641816.00,1641816.00,666077),('1','142','233028','342',543.00,584.00,0.00,1031.31,560001.33,561389.15,1387.82,666203),('1','142','233106','342',543.00,584.00,0.00,1349.09,732555.87,748173.46,15617.59,666400),('1','142','233288','342',543.00,584.00,0.00,1120.32,608333.76,648539.88,40206.12,666882),('1','142','233400','342',0.00,624.00,0.00,1601.69,0.00,971238.84,971238.84,667164),('1','142','233632','342',0.00,624.00,0.00,5160.46,0.00,3062075.32,3062075.32,667762),('1','142','233875','342',0.00,624.00,0.00,1907.96,0.00,1162875.72,1162875.72,668402),('1','142','234081','342',0.00,624.00,0.00,2583.36,0.00,1540118.64,1540118.64,668950),('1','142','234331','342',0.00,624.00,0.00,2431.00,0.00,1452105.60,1452105.60,669605),('1','142','234600','342',0.00,624.00,0.00,2509.17,650364.00,1493956.52,843592.52,670322),('1','142','234869','342',572.00,624.00,0.00,1737.30,993735.60,1050315.20,56579.60,671033),('1','142','235096','342',572.00,624.00,0.00,3563.98,2038596.56,2106589.20,67992.64,671655),('1','142','235242','342',572.00,624.00,0.00,414.30,236979.60,253687.20,16707.60,672042),('1','142','235333','342',572.00,624.00,0.00,1595.60,912683.20,966836.04,54152.84,672265),('1','142','235557','342',572.00,624.00,0.00,3292.86,1883515.92,1957567.72,74051.80,672840),('1','142','235791','342',572.00,624.00,0.00,1794.71,1026574.12,1081379.04,54804.92,673443),('1','142','236064','342',572.00,624.00,0.00,1560.13,892394.36,945531.12,53136.76,674167),('1','142','236256','342',572.00,624.00,0.00,4422.09,2529435.48,2609914.16,80478.68,674671),('1','142','236561','342',572.00,624.00,0.00,0.00,0.00,0.00,0.00,675477),('1','142','236570','342',572.00,624.00,0.00,1270.60,726783.20,754838.40,28055.20,675500),('1','142','236573','342',0.00,640.00,0.00,3995.49,1638182.40,2421868.60,783686.20,675507),('1','142','236768','342',592.00,640.00,0.00,2057.47,1218022.24,1276950.80,58928.56,676007),('1','142','236991','342',592.00,640.00,0.00,1950.24,1154542.08,1205878.60,51336.52,676583),('1','142','237187','342',592.00,640.00,0.00,2261.48,1338796.16,1394324.20,55528.04,677085),('1','142','237323','342',592.00,640.00,0.00,1230.75,728604.00,752608.00,24004.00,677455),('1','142','237423','342',592.00,640.00,0.00,4038.81,2390975.52,2466340.40,75364.88,677697),('1','142','237641','342',0.00,664.00,0.00,5664.70,0.00,3494573.80,3494573.80,678267),('1','142','237891','342',0.00,640.00,0.00,1702.11,0.00,1077322.40,1077322.40,678914),('1','142','238157','342',0.00,640.00,0.00,2513.63,0.00,1582355.20,1582355.20,679607),('1','142','238388','342',0.00,640.00,0.00,1853.94,0.00,1168122.60,1168122.60,680193),('1','142','238642','342',0.00,640.00,0.00,1274.51,0.00,811206.40,811206.40,680866),('1','142','238859','342',0.00,640.00,0.00,2101.63,0.00,1321047.20,1321047.20,681423),('1','142','239089','342',0.00,640.00,0.00,2778.65,0.00,1743724.80,1743724.80,682016),('1','142','239326','342',0.00,640.00,0.00,1209.37,0.00,752976.80,752976.80,682638),('1','142','239335','342',0.00,640.00,0.00,3862.39,2288157.30,2421939.60,133782.30,682662),('1','142','239553','342',598.00,640.00,0.00,2572.75,1538504.50,1616600.00,78095.50,683229),('1','142','239762','342',0.00,656.00,0.00,1558.70,0.00,1005034.42,1005034.42,683791),('1','142','240010','342',0.00,656.00,0.00,1245.03,0.00,807233.68,807233.68,684416),('1','142','240210','342',0.00,656.00,0.00,2987.34,0.00,1905436.62,1905436.62,684937),('1','142','240458','342',0.00,656.00,0.00,3159.19,0.00,2004240.64,2004240.64,685588),('1','142','240634','342',0.00,278.00,0.00,0.00,0.00,0.00,0.00,686061),('1','142','240636','342',0.00,291.00,0.00,0.00,0.00,0.00,0.00,686065),('1','142','240638','342',0.00,291.00,0.00,0.00,0.00,0.00,0.00,686069),('1','142','240640','342',0.00,291.00,0.00,0.00,0.00,0.00,0.00,686074),('1','142','240641','342',0.00,291.00,0.00,0.00,0.00,0.00,0.00,686075),('1','142','240642','342',0.00,299.00,0.00,0.00,0.00,0.00,0.00,686076),('1','142','240643','342',0.00,309.00,0.00,0.00,0.00,0.00,0.00,686077),('1','142','240644','342',0.00,309.00,0.00,0.00,0.00,0.00,0.00,686078),('1','142','240645','342',0.00,328.00,0.00,0.00,0.00,0.00,0.00,686079),('1','142','240646','342',0.00,326.00,0.00,0.00,0.00,0.00,0.00,686080),('1','142','240647','342',0.00,323.00,0.00,0.00,0.00,0.00,0.00,686081),('1','142','240648','342',0.00,325.00,0.00,0.00,0.00,0.00,0.00,686082),('1','142','240649','342',0.00,325.00,0.00,0.00,0.00,0.00,0.00,686083),('1','142','240650','342',0.00,325.00,0.00,0.00,0.00,0.00,0.00,686084),('1','142','240652','342',0.00,328.00,0.00,0.00,0.00,0.00,0.00,686086),('1','142','240653','342',0.00,328.00,0.00,0.00,0.00,0.00,0.00,686087),('1','142','240654','342',0.00,328.00,0.00,0.00,0.00,0.00,0.00,686088),('1','142','240655','342',0.00,328.00,0.00,0.00,0.00,0.00,0.00,686089),('1','142','240656','342',0.00,328.00,0.00,0.00,0.00,0.00,0.00,686090),('1','142','240657','342',0.00,328.00,0.00,0.00,0.00,0.00,0.00,686091),('1','142','240658','342',0.00,328.00,0.00,0.00,0.00,0.00,0.00,686092),('1','142','240659','342',0.00,328.00,0.00,0.00,0.00,0.00,0.00,686093),('1','142','240660','342',0.00,393.00,0.00,0.00,0.00,0.00,0.00,686094),('1','142','240661','342',0.00,393.00,0.00,0.00,0.00,0.00,0.00,686095),('1','142','240662','342',0.00,393.00,0.00,0.00,0.00,0.00,0.00,686096),('1','142','240692','342',0.00,535.00,0.00,0.00,0.00,0.00,0.00,686154),('1','142','240698','342',0.00,534.00,0.00,0.00,0.00,0.00,0.00,686168),('1','142','240702','342',0.00,605.00,0.00,0.00,0.00,0.00,0.00,686176),('1','142','240719','342',598.00,656.00,0.00,1523.23,910891.54,978894.14,68002.60,686216),('1','142','240977','342',598.00,656.00,0.00,2140.67,1280120.66,1368272.92,88152.26,686917),('1','142','241248','342',598.00,656.00,0.00,3223.10,1927413.80,2043626.60,116212.80,687617),('1','142','241511','342',598.00,656.00,0.00,3266.05,1953097.90,2069297.80,116199.90,688324),('1','142','241754','342',598.00,656.00,0.00,2323.53,1389470.94,1483449.68,93978.74,688968),('1','142','241991','342',598.00,656.00,0.00,2927.19,1750459.62,1865911.40,115451.78,689585),('1','142','242230','342',598.00,656.00,0.00,2265.30,1354649.40,1447415.20,92765.80,690206),('1','142','242469','342',598.00,656.00,0.00,2291.25,1370167.50,1466255.84,96088.34,690811),('1','142','242714','342',598.00,656.00,0.00,2684.35,1605241.30,1714840.14,109598.84,691450),('1','142','242936','342',598.00,656.00,0.00,1802.63,1077972.74,1144783.28,66810.54,692035),('1','142','243022','342',598.00,656.00,0.00,1163.20,688689.40,743205.20,54515.80,692262),('1','142','243152','342',592.00,656.00,0.00,2553.34,1511577.28,1633346.04,121768.76,692600),('1','142','243442','342',592.00,656.00,0.00,1795.72,1063066.24,1152730.12,89663.88,693354),('1','142','243641','342',592.00,656.00,0.00,2763.85,1636199.20,1761987.60,125788.40,693867),('1','142','243879','342',592.00,656.00,0.00,1557.26,921897.92,1004757.56,82859.64,694492),('1','142','244072','342',592.00,656.00,0.00,2648.02,1567627.84,1690767.30,123139.46,694981),('1','142','244307','342',592.00,656.00,0.00,3796.62,2247599.04,2411127.22,163528.18,695599),('1','142','244529','342',592.00,656.00,0.00,4124.89,2441934.88,2621653.84,179718.96,696173),('1','142','244812','342',592.00,656.00,0.00,2083.39,1233366.88,1334691.84,101324.96,696912),('1','142','244993','342',0.00,624.00,0.00,1908.65,0.00,1168005.60,1168005.60,697384),('1','142','245255','342',0.00,624.00,0.00,224.71,0.00,139715.04,139715.04,698051),('1','142','245334','342',592.00,624.00,0.00,4693.27,2778415.84,2829888.48,51472.64,698264),('1','142','245453','342',592.00,624.00,0.00,1498.73,887248.16,918431.52,31183.36,698564),('1','142','245704','342',592.00,624.00,0.00,2007.26,1188297.92,1221642.24,33344.32,699206),('1','142','245990','342',0.00,616.00,0.00,1072.13,0.00,653302.08,653302.08,699961),('1','142','246208','342',0.00,616.00,0.00,5037.33,0.00,2907288.28,2907288.28,700517),('1','142','246456','342',0.00,616.00,0.00,1751.84,0.00,1034053.44,1034053.44,701184),('1','142','246708','342',0.00,616.00,0.00,1277.85,0.00,768433.60,768433.60,701843),('1','142','246954','342',0.00,616.00,0.00,3301.92,0.00,1924410.72,1924410.72,702472),('1','142','247185','342',0.00,616.00,0.00,1068.41,0.00,646410.56,646410.56,703068),('1','142','247415','342',0.00,616.00,0.00,2555.18,0.00,1478448.88,1478448.88,703647),('1','142','247675','342',552.00,616.00,0.00,4630.44,2556002.88,2690753.04,134750.16,704338),('1','142','247934','342',552.00,616.00,0.00,4619.04,2549710.08,2703119.64,153409.56,704998),('1','142','248190','342',552.00,616.00,0.00,3432.28,1894618.56,2023940.48,129321.92,705665),('1','142','248421','342',552.00,616.00,0.00,4577.84,2526967.68,2674957.44,147989.76,706261),('1','142','248658','342',552.00,616.00,0.00,3140.38,1733489.76,1844774.08,111284.32,706859),('1','142','248889','342',552.00,616.00,0.00,1586.39,0.00,917074.00,917074.00,707464),('1','142','249136','342',0.00,600.00,0.00,1263.42,0.00,735130.40,735130.40,708085),('1','142','249271','342',530.00,600.00,0.00,236.83,125519.90,141378.00,15858.10,708449),('1','142','249352','342',530.00,600.00,0.00,2534.57,1343322.10,1452742.00,109419.90,708646),('1','142','249615','342',530.00,600.00,0.00,1950.99,1034024.70,1124714.00,90689.30,709315),('1','142','249883','342',530.00,600.00,0.00,2499.42,1324692.60,1442052.00,117359.40,710003),('1','142','250110','342',530.00,600.00,0.00,4114.92,2180907.60,2342452.00,161544.40,710590),('1','142','250343','342',530.00,600.00,0.00,1479.69,784235.70,873614.00,89378.30,711180),('1','142','250570','342',530.00,600.00,0.00,1312.86,695815.80,773844.40,78028.60,711757),('1','142','250808','342',530.00,600.00,0.00,5914.51,3134690.30,3365046.00,230355.70,712380),('1','142','251030','342',530.00,600.00,0.00,4088.64,2166979.20,2333704.00,166724.80,712953),('1','142','251279','342',530.00,600.00,0.00,403.67,213945.10,229202.00,15256.90,713599),('1','142','251373','342',527.00,600.00,0.00,1032.97,544375.19,615062.00,70686.81,713846),('1','142','251557','342',527.00,600.00,0.00,3634.86,1915571.22,2069356.00,153784.78,714320),('1','142','251777','342',527.00,600.00,0.00,1947.14,1026142.78,1123444.00,97301.22,714902),('1','142','252015','342',527.00,600.00,0.00,1738.49,916184.23,1006494.00,90309.77,715523),('1','142','252273','342',527.00,600.00,0.00,2600.07,1370236.89,1494396.40,124159.51,716194),('1','142','252511','342',527.00,600.00,0.00,2199.15,1158952.05,1272490.00,113537.95,716799),('1','142','252748','342',527.00,600.00,0.00,3268.76,1722636.52,1869338.80,146702.28,717421),('1','142','252997','342',527.00,600.00,0.00,2198.04,1158367.08,1267904.00,109536.92,718071),('1','142','253223','342',527.00,600.00,0.00,2747.66,1448016.82,1575496.00,127479.18,718671),('1','142','253501','342',527.00,600.00,0.00,2881.54,1518571.58,1632428.00,113856.42,719381),('1','142','253919','342',527.00,600.00,0.00,101.00,53227.00,56560.00,3333.00,720495),('1','142','254322','342',527.00,600.00,0.00,3885.12,2047458.24,2210152.00,162693.76,721523),('1','142','254460','342',527.00,600.00,0.00,3006.86,1584615.22,1727996.00,143380.78,721875),('1','142','254741','342',527.00,600.00,0.00,1977.78,1042290.06,1147468.00,105177.94,722579),('1','142','254983','342',527.00,600.00,0.00,2410.69,1270433.63,1386214.00,115780.37,723195),('1','142','255205','342',527.00,600.00,0.00,1555.33,819658.91,907398.00,87739.09,723774),('1','142','255474','342',527.00,600.00,0.00,3783.63,1993973.01,2149318.00,155344.99,724446),('1','142','255742','342',527.00,600.00,0.00,2421.45,1276104.15,1418655.60,142551.45,725111),('1','142','255979','342',527.00,600.00,0.00,2534.56,1335713.12,1464696.00,128982.88,725712),('1','142','256233','342',527.00,600.00,0.00,2041.68,1075965.36,1183928.00,107962.64,726330),('1','142','256570','342',527.00,600.00,0.00,104.10,54860.70,59675.60,4814.90,727213),('1','142','256580','342',527.00,600.00,0.00,1398.59,737056.93,814154.00,77097.07,727239),('1','142','256742','342',527.00,600.00,0.00,3907.71,2059363.17,2229946.00,170582.83,727654),('1','142','256970','342',527.00,600.00,0.00,1569.95,827363.65,925730.00,98366.35,728263),('1','142','257259','342',527.00,600.00,0.00,2286.39,1204927.53,1317834.00,112906.47,729006),('1','142','257510','342',527.00,600.00,0.00,2519.90,1327987.30,1453380.00,125392.70,729666),('1','142','257511','342',527.00,600.00,0.00,2332.81,1229390.87,1354326.00,124935.13,729667),('1','142','257512','342',527.00,600.00,0.00,3290.48,1734082.96,1880768.00,146685.04,729668),('1','142','257513','342',527.00,600.00,0.00,2634.54,1388402.58,1523844.00,135441.42,729669),('1','142','257514','342',527.00,600.00,0.00,2137.20,1126304.40,1255040.00,128735.60,729670),('1','142','257515','342',527.00,600.00,0.00,2225.81,1173001.87,1280126.00,107124.13,729671),('1','142','257516','342',527.00,600.00,0.00,38.00,20026.00,21400.00,1374.00,729672),('1','142','257517','342',527.00,600.00,0.00,1476.61,778173.47,850446.00,72272.53,729673),('1','142','257518','342',527.00,600.00,0.00,4701.76,2477827.52,2681456.00,203628.48,729674),('1','142','257519','342',527.00,600.00,0.00,1800.60,948916.20,1050888.00,101971.80,729675),('1','142','257520','342',527.00,600.00,0.00,1691.20,891262.40,983320.00,92057.60,729676),('1','142','257521','342',527.00,600.00,0.00,2830.76,1491810.52,1624656.00,132845.48,729677),('1','142','257522','342',527.00,600.00,0.00,1538.84,810968.68,898676.40,87707.72,729678),('1','142','257523','342',527.00,600.00,0.00,1664.78,877339.06,966940.00,89600.94,729679),('1','142','257524','342',527.00,600.00,0.00,2394.79,1262054.33,1374880.00,112825.67,729680),('1','142','257525','342',527.00,600.00,0.00,1960.51,1033188.77,1135036.00,101847.23,729681),('1','142','257526','342',527.00,600.00,0.00,1492.71,786658.17,871218.80,84560.63,729682),('1','142','257527','342',527.00,600.00,0.00,1283.42,676362.34,756264.00,79901.66,729683),('1','142','257528','342',527.00,600.00,0.00,3319.34,1749292.18,1893191.20,143899.02,729684),('1','142','257529','342',0.00,568.00,0.00,2801.05,0.00,1545385.12,1545385.12,729685),('1','142','257530','342',0.00,568.00,0.00,2544.97,0.00,1401491.68,1401491.68,729686),('1','142','257531','342',0.00,568.00,0.00,2871.76,1190537.26,1588560.88,398023.62,729687),('1','142','257532','342',517.00,568.00,0.00,1766.29,913171.93,980389.12,67217.19,729688),('1','142','257533','342',517.00,568.00,0.00,1621.53,838331.01,900256.56,61925.55,729689),('1','142','257534','342',517.00,568.00,0.00,1186.62,613482.54,663728.64,50246.10,729690),('1','142','257535','342',517.00,568.00,0.00,1990.52,1029098.84,1103262.32,74163.48,729691),('1','142','257536','342',517.00,568.00,0.00,1061.74,548919.58,597284.32,48364.74,729692),('1','142','257537','342',517.00,568.00,0.00,2157.14,1115241.38,1192109.60,76868.22,729693),('1','142','257538','342',517.00,568.00,0.00,1622.24,838698.08,902109.92,63411.84,729694),('1','142','257539','342',517.00,568.00,0.00,3604.25,1863397.25,1982990.24,119592.99,729695),('1','142','257540','342',517.00,568.00,0.00,788.14,407468.38,432209.68,24741.30,729696),('1','142','257541','342',517.00,568.00,0.00,2738.96,1416042.32,1524798.32,108756.00,729697),('1','142','257542','342',517.00,568.00,0.00,1980.51,1023923.67,1098169.68,74246.01,729698),('1','142','257543','342',517.00,568.00,0.00,1707.38,882715.46,949043.84,66328.38,729699),('1','142','257544','342',517.00,568.00,0.00,1748.42,903933.14,974599.04,70665.90,729700),('1','142','257545','342',517.00,568.00,0.00,4088.67,2113842.39,2259312.96,145470.57,729701),('1','142','257546','342',517.00,568.00,0.00,1846.55,954666.35,1032426.32,77759.97,729702),('1','142','257547','342',517.00,568.00,0.00,4423.34,2286866.78,2434355.36,147488.58,729703),('1','142','257548','342',517.00,568.00,0.00,1530.16,791092.72,860802.88,69710.16,729704),('1','142','257549','342',517.00,568.00,0.00,2737.39,1415230.63,1510360.72,95130.09,729705),('1','142','257550','342',517.00,568.00,0.00,121.43,51948.16,68972.24,17024.08,729706),('1','142','257551','342',0.00,640.00,0.00,1084.13,0.00,677233.00,677233.00,729707),('1','142','257552','342',0.00,640.00,0.00,62.99,0.00,39053.80,39053.80,729708),('1','142','257553','342',0.00,640.00,0.00,4697.72,0.00,2925873.20,2925873.20,729709),('1','142','257554','342',0.00,640.00,0.00,2048.13,0.00,1287383.20,1287383.20,729710),('1','142','257555','342',0.00,640.00,0.00,2831.82,1720589.04,1771514.40,50925.36,729711),('1','142','257556','342',0.00,680.00,0.00,1139.96,0.00,755572.80,755572.80,729712),('1','142','257557','342',0.00,680.00,0.00,1526.80,0.00,1016644.40,1016644.40,729713),('1','142','257558','342',0.00,680.00,0.00,2140.73,0.00,1406266.00,1406266.00,729714),('1','142','257559','342',0.00,680.00,0.00,1467.84,0.00,974860.80,974860.80,729715),('1','142','257560','342',0.00,680.00,0.00,2304.68,0.00,1509982.40,1509982.40,729716),('1','142','257561','342',0.00,680.00,0.00,2252.67,0.00,1482419.60,1482419.60,729717),('1','142','257562','342',0.00,680.00,0.00,1868.43,0.00,1234495.20,1234495.20,729718),('1','142','257563','342',0.00,680.00,0.00,2493.55,0.00,1634452.00,1634452.00,729719),('1','142','257564','342',0.00,680.00,0.00,3756.39,666027.36,2447208.00,1781180.64,729720),('1','142','257565','342',612.00,680.00,0.00,1594.98,976127.76,1057650.80,81523.04,729721),('1','142','257566','342',612.00,680.00,0.00,1487.37,910270.44,986024.00,75753.56,729722),('1','142','257567','342',612.00,680.00,0.00,5209.45,3188183.40,3371970.00,183786.60,729723),('1','142','257568','342',612.00,680.00,0.00,1041.17,637196.04,698704.60,61508.56,729724),('1','142','257569','342',612.00,680.00,0.00,2173.44,1330145.28,1444311.86,114166.58,729725),('1','142','257570','342',612.00,680.00,0.00,3932.61,2406757.32,2574169.06,167411.74,729726),('1','142','257571','342',612.00,680.00,0.00,2078.55,1272072.60,1387292.42,115219.82,729727),('1','142','257572','342',612.00,680.00,0.00,2939.02,1798680.24,1945219.60,146539.36,729728),('1','142','257573','342',612.00,650.00,0.00,4593.95,2811497.40,2919727.60,108230.20,729729),('1','142','257574','342',612.00,650.00,0.00,4888.88,2991994.56,3110723.80,118729.24,729730),('1','142','257575','342',612.00,650.00,0.00,5133.60,3141763.20,3227946.60,86183.40,729731),('1','142','257576','342',612.00,650.00,0.00,2521.52,1543170.24,1603243.00,60072.76,729732),('1','142','257577','342',612.00,650.00,0.00,4305.40,2634904.80,2704004.30,69099.50,729733),('1','142','257578','342',612.00,650.00,0.00,2187.22,1338578.64,1385943.20,47364.56,729734),('1','142','257579','342',612.00,650.00,0.00,2240.74,1371332.88,1401302.60,29969.72,729735),('1','142','257580','342',612.00,650.00,0.00,1592.18,974414.16,1023457.00,49042.84,729736),('1','142','257581','342',612.00,650.00,0.00,3492.75,2137563.00,2200928.70,63365.70,729737),('1','142','257582','342',612.00,650.00,0.00,1828.40,1118980.80,1162752.40,43771.60,729738),('1','142','257583','342',612.00,650.00,0.00,1644.53,1006452.36,1042213.90,35761.54,729739),('1','142','257584','342',612.00,650.00,0.00,975.02,596712.24,626113.00,29400.76,729740),('1','142','257585','342',612.00,650.00,0.00,1781.14,1090057.68,1122533.60,32475.92,729741),('1','142','257586','342',612.00,650.00,0.00,3302.19,2020940.28,2067951.00,47010.72,729742),('1','142','257587','342',612.00,650.00,0.00,2462.11,1506811.32,1549268.90,42457.58,729743),('1','142','257588','342',612.00,650.00,0.00,2928.00,1791936.00,1842777.00,50841.00,729744),('1','142','257589','342',612.00,650.00,0.00,1208.65,739693.80,768419.60,28725.80,729745),('1','142','257590','342',612.00,650.00,0.00,2342.18,1433414.16,1475583.70,42169.54,729746),('1','142','257591','342',612.00,650.00,0.00,2772.94,1671745.48,1738935.50,67190.02,729747),('1','142','257592','342',602.00,650.00,0.00,1400.13,842878.26,889708.50,46830.24,729748),('1','142','257593','342',602.00,650.00,0.00,2308.17,1389518.34,1454235.90,64717.56,729749),('1','142','257594','342',602.00,650.00,0.00,2056.38,1237940.76,1297928.10,59987.34,729750),('1','142','257595','342',602.00,650.00,0.00,1216.44,732296.88,782619.00,50322.12,729751),('1','142','257596','342',602.00,650.00,0.00,3511.01,2113628.02,2198022.18,84394.16,729752),('1','142','257597','342',602.00,650.00,0.00,2788.43,1678634.86,1761170.50,82535.64,729753),('1','142','257598','342',602.00,650.00,0.00,3101.69,1867217.38,1950313.30,83095.92,729754),('1','142','257599','342',602.00,650.00,0.00,4003.94,2410371.88,2512161.40,101789.52,729755),('1','142','257600','342',602.00,650.00,0.00,2282.53,1374083.06,1447260.50,73177.44,729756),('1','142','257601','342',602.00,650.00,0.00,193.05,116216.10,123082.50,6866.40,729757),('1','142','257602','342',602.00,650.00,0.00,2678.44,1612420.88,1682534.30,70113.42,729758),('1','142','257603','342',602.00,650.00,0.00,5433.31,3270852.62,3424781.30,153928.68,729759),('1','142','257604','342',602.00,650.00,0.00,2591.34,1559986.68,1637331.60,77344.92,729760),('1','142','257605','342',602.00,650.00,0.00,468.15,281826.30,294323.40,12497.10,729761),('1','142','257606','342',602.00,650.00,0.00,1606.80,967293.60,1010459.70,43166.10,729762),('1','142','257607','342',602.00,650.00,0.00,2615.86,1574747.72,1646495.30,71747.58,729763),('1','142','257608','342',602.00,650.00,0.00,2995.09,1803044.18,1881334.70,78290.52,729764),('1','142','257609','342',602.00,650.00,0.00,3677.34,2213758.68,2311605.90,97847.22,729765),('1','142','257610','342',602.00,650.00,0.00,2267.78,1365203.56,1428411.40,63207.84,729766),('1','142','257611','342',602.00,650.00,0.00,150.44,90564.88,96144.10,5579.22,729767),('1','142','257612','342',570.00,650.00,0.00,287.62,163943.40,186953.00,23009.60,729768),('1','142','257613','342',570.00,650.00,0.00,1673.19,953718.30,1075573.50,121855.20,729769),('1','142','257614','342',570.00,650.00,0.00,3229.16,1840621.20,2032924.00,192302.80,729770),('1','142','257615','342',570.00,650.00,0.00,3532.78,2013684.60,2228282.00,214597.40,729771),('1','142','257616','342',570.00,650.00,0.00,2361.52,1346066.40,1492448.00,146381.60,729772),('1','142','257617','342',570.00,650.00,0.00,2288.41,1304393.70,1448871.80,144478.10,729773),('1','142','257618','342',570.00,650.00,0.00,4277.22,2438015.40,2677958.10,239942.70,729774),('1','142','257619','342',570.00,650.00,0.00,1500.38,0.00,1030260.16,1030260.16,729775),('1','142','257620','342',0.00,696.00,0.00,3416.01,658089.72,2283501.32,1625411.60,729776),('1','142','257621','342',612.00,696.00,0.00,3098.74,1896428.88,2075940.80,179511.92,729777),('1','142','257622','342',612.00,696.00,0.00,2326.12,1423585.44,1571576.12,147990.68,729778),('1','142','257623','342',612.00,696.00,0.00,3016.69,1846214.28,2010565.08,164350.80,729779),('1','142','257624','342',612.00,696.00,0.00,1568.97,960209.64,1061341.28,101131.64,729780),('1','142','257625','342',612.00,696.00,0.00,1688.38,1033288.56,1161912.48,128623.92,729781),('1','142','257626','342',612.00,696.00,0.00,2236.41,1368682.92,1509682.24,140999.32,729782),('1','142','257627','342',612.00,696.00,0.00,2606.08,1594920.96,1728403.48,133482.52,729783),('1','142','257628','342',600.00,696.00,0.00,1924.80,1154880.00,1277888.32,123008.32,729784),('1','142','257629','342',600.00,696.00,0.00,2794.22,1676532.00,1861206.60,184674.60,729785),('1','142','257630','342',600.00,740.00,0.00,1795.93,1077558.00,1295517.40,217959.40,729786),('1','142','257631','342',600.00,740.00,0.00,1598.87,959322.00,1164909.96,205587.96,729787),('1','142','257632','342',600.00,740.00,0.00,2022.52,1213512.00,1461464.80,247952.80,729788),('1','142','257633','342',600.00,740.00,0.00,1663.80,998280.00,1224788.00,226508.00,729789),('1','142','257634','342',600.00,740.00,0.00,3723.98,2234388.00,2674981.44,440593.44,729790),('1','142','257635','342',600.00,740.00,0.00,4849.47,2909682.00,3447774.80,538092.80,729791),('1','142','257636','342',600.00,740.00,0.00,1581.49,948894.00,1154440.60,205546.60,729792),('1','142','257637','342',600.00,740.00,0.00,2877.22,1726332.00,2045662.48,319330.48,729793),('1','142','257638','342',662.00,740.00,0.00,3534.56,2339878.72,2506914.64,167035.92,729794),('1','142','257639','342',662.00,740.00,0.00,2927.66,1938110.92,2105363.84,167252.92,729795),('1','142','257640','342',662.00,740.00,0.00,2283.42,1511624.04,1651318.80,139694.76,729796),('1','142','257641','342',662.00,740.00,0.00,3793.78,2511482.36,2692039.76,180557.40,729797),('1','142','257642','342',662.00,740.00,0.00,1677.17,1110286.54,1226805.80,116519.26,729798),('1','142','257643','342',662.00,740.00,0.00,531.86,352091.32,384336.40,32245.08,729799),('1','142','257644','342',0.00,770.00,0.00,1396.11,0.00,1050938.20,1050938.20,729800),('1','142','257645','342',0.00,770.00,0.00,1067.69,0.00,819171.30,819171.30,729801),('1','142','257646','342',0.00,770.00,0.00,1185.67,0.00,910465.90,910465.90,729802),('1','142','257647','342',0.00,770.00,0.00,1136.85,325320.82,867874.50,542553.68,729803),('1','142','257648','342',682.00,770.00,0.00,2433.06,1659346.92,1802188.70,142841.78,729804),('1','142','257649','342',682.00,770.00,0.00,1159.88,791038.16,893107.60,102069.44,729805),('1','142','257650','342',682.00,770.00,0.00,1348.74,919840.68,1038529.80,118689.12,729806),('1','142','257651','342',682.00,770.00,0.00,1883.35,1284444.70,1431729.50,147284.80,729807),('1','142','257652','342',682.00,770.00,0.00,2154.53,1469389.46,1603627.10,134237.64,729808),('1','142','257653','342',682.00,770.00,0.00,1559.85,1063817.70,1196584.50,132766.80,729809),('1','142','257654','342',682.00,770.00,0.00,0.00,0.00,0.00,0.00,729810),('1','142','257655','342',682.00,770.00,0.00,1124.72,767059.04,866034.40,98975.36,729811),('1','142','257656','342',682.00,770.00,0.00,926.28,631722.96,713235.60,81512.64,729812),('1','142','257657','342',682.00,770.00,0.00,1549.48,1056745.36,1175099.60,118354.24,729813),('1','142','257658','342',682.00,770.00,0.00,2257.32,1539492.24,1698480.72,158988.48,729814),('1','142','257659','342',682.00,770.00,0.00,1275.17,869665.94,976630.90,106964.96,729815),('1','142','257660','342',682.00,770.00,0.00,1089.64,743134.48,839022.80,95888.32,729816),('1','142','257661','342',682.00,770.00,0.00,1073.68,732249.76,826733.60,94483.84,729817),('1','142','257662','342',682.00,770.00,0.00,1136.89,775358.98,875405.30,100046.32,729818),('1','142','257663','342',682.00,770.00,0.00,1222.34,833635.88,932149.80,98513.92,729819),('1','142','257664','342',682.00,770.00,0.00,1902.83,1297730.06,1438068.10,140338.04,729820),('1','142','257665','342',682.00,770.00,0.00,2441.85,1687009.60,1833354.50,146344.90,729821),('1','142','257666','342',692.00,770.00,0.00,1568.71,1085547.32,1198906.70,113359.38,729822),('1','142','257667','342',692.00,770.00,0.00,1824.50,1262554.00,1401315.00,138761.00,729823),('1','142','257668','342',692.00,770.00,0.00,1624.96,1124472.32,1248776.70,124304.38,729824),('1','142','257669','342',692.00,770.00,0.00,2452.18,1696908.56,1829419.60,132511.04,729825),('1','142','257670','342',692.00,770.00,0.00,1711.66,1184468.72,1287728.20,103259.48,729826),('1','142','257671','342',692.00,770.00,0.00,1386.43,959409.56,1059954.10,100544.54,729827),('1','142','257672','342',692.00,770.00,0.00,2004.55,1387148.60,1521553.50,134404.90,729828),('1','142','257673','342',692.00,770.00,0.00,2499.29,1729508.68,1905703.30,176194.62,729829),('1','142','257674','342',692.00,770.00,0.00,5389.60,3729603.20,4000463.00,270859.80,729830),('1','142','257675','342',692.00,770.00,0.00,368.86,255251.12,277922.70,22671.58,729831),('1','142','257676','342',692.00,770.00,0.00,1890.92,1308516.64,1395458.40,86941.76,729832),('1','142','257677','342',692.00,770.00,0.00,2882.64,1994786.88,2121405.80,126618.92,729833),('1','142','257678','342',692.00,770.00,0.00,1793.44,1241060.48,1357933.80,116873.32,729834),('1','142','257679','342',692.00,770.00,0.00,2300.38,1591862.96,1725592.60,133729.64,729835),('1','142','257680','342',692.00,770.00,0.00,1785.67,1235683.64,1343190.90,107507.26,729836),('1','142','257681','342',692.00,770.00,0.00,1617.00,1118964.00,1217393.50,98429.50,729837),('1','142','257682','342',692.00,770.00,0.00,1423.24,984882.08,1095277.80,110395.72,729838),('1','142','257683','342',692.00,770.00,0.00,2449.91,1695337.72,1833487.42,138149.70,729839),('1','142','257684','342',692.00,770.00,0.00,1537.98,1064282.16,1178319.60,114037.44,729840),('1','142','257685','342',692.00,770.00,0.00,1835.70,1270304.40,1383274.50,112970.10,729841),('1','142','257686','342',692.00,770.00,0.00,1587.55,1098584.60,1217622.00,119037.40,729842),('1','142','257687','342',692.00,770.00,0.00,1112.34,769739.28,853696.30,83957.02,729843),('1','142','257688','342',692.00,770.00,0.00,1070.02,740453.84,817040.40,76586.56,729844),('1','142','257689','342',692.00,770.00,0.00,1879.28,1300461.76,1416020.60,115558.84,729845),('1','142','257690','342',692.00,770.00,0.00,2166.00,1498872.00,1640170.00,141298.00,729846),('1','142','257691','342',692.00,770.00,0.00,1561.72,1080710.24,1179279.40,98569.16,729847),('1','142','257692','342',692.00,770.00,0.00,2088.27,1445082.84,1581467.90,136385.06,729848),('1','142','257693','342',692.00,770.00,0.00,1548.36,1071465.12,1169735.70,98270.58,729849),('1','142','257694','342',692.00,770.00,0.00,2043.30,1413963.60,1532641.00,118677.40,729850),('1','142','257695','342',692.00,770.00,0.00,1494.07,1033896.44,1146683.90,112787.46,729851),('1','142','257696','342',692.00,770.00,0.00,1323.86,916111.12,1013852.70,97741.58,729852),('1','142','257697','342',692.00,770.00,0.00,2539.33,1757216.36,1905284.10,148067.74,729853),('1','142','257698','342',692.00,770.00,0.00,1780.86,1232355.12,1369809.20,137454.08,729854),('1','142','257699','342',692.00,770.00,0.00,1619.34,1120583.28,1244441.80,123858.52,729855),('1','142','257700','342',692.00,770.00,0.00,1451.19,1004223.48,1108041.30,103817.82,729856),('1','142','257701','342',692.00,770.00,0.00,2228.53,1542142.76,1713468.10,171325.34,729857),('1','142','257702','342',692.00,770.00,0.00,2396.92,1658668.64,1811078.40,152409.76,729858),('1','142','257703','342',692.00,770.00,0.00,1770.51,1225192.92,1347448.70,122255.78,729859),('1','142','257704','342',692.00,770.00,0.00,1296.14,896928.88,998027.80,101098.92,729860),('1','142','257705','342',692.00,770.00,0.00,1314.45,909599.40,1009876.50,100277.10,729861),('1','142','257706','342',692.00,770.00,0.00,1610.41,1114403.72,1235015.70,120611.98,729862),('1','142','257707','342',692.00,770.00,0.00,1534.26,1061707.92,1168880.20,107172.28,729863),('1','142','257708','342',692.00,770.00,0.00,1471.79,1018478.68,1127678.30,109199.62,729864),('1','142','257709','342',692.00,770.00,0.00,1787.63,1237039.96,1360280.60,123240.64,729865),('1','142','257710','342',692.00,770.00,0.00,1415.48,979512.16,1078660.60,99148.44,729866),('1','142','257711','342',692.00,770.00,0.00,2612.20,1807642.40,1940425.00,132782.60,729867),('1','142','257712','342',692.00,770.00,0.00,1656.08,1146007.36,1255203.60,109196.24,729868),('1','142','257713','342',692.00,770.00,0.00,1891.22,1308724.24,1453739.40,145015.16,729869),('1','142','257714','342',692.00,770.00,0.00,2557.43,1769741.56,1908296.10,138554.54,729870),('1','142','257715','342',692.00,770.00,0.00,1400.72,969298.24,1076347.40,107049.16,729871),('1','142','257716','342',692.00,770.00,0.00,1102.07,762632.44,842343.90,79711.46,729872),('1','142','257717','342',692.00,770.00,0.00,1130.38,782222.96,870392.60,88169.64,729873),('1','142','257718','342',692.00,770.00,0.00,1190.97,824151.24,914623.40,90472.16,729874),('1','142','257719','342',692.00,770.00,0.00,0.00,0.00,0.00,0.00,729875),('1','142','257720','342',692.00,770.00,0.00,0.00,0.00,0.00,0.00,729876),('1','142','257721','342',692.00,770.00,0.00,0.00,0.00,0.00,0.00,729877),('1','142','257722','342',692.00,770.00,0.00,0.00,0.00,0.00,0.00,729878),('1','142','257723','342',692.00,770.00,0.00,0.00,0.00,0.00,0.00,729879),('1','142','257724','342',692.00,770.00,0.00,0.00,0.00,0.00,0.00,729880),('1','142','257725','342',692.00,770.00,0.00,0.00,0.00,0.00,0.00,729881),('1','142','257726','342',692.00,770.00,0.00,0.00,0.00,0.00,0.00,729882),('1','142','257727','342',692.00,770.00,0.00,0.00,0.00,0.00,0.00,729883),('1','142','257728','342',692.00,770.00,0.00,0.00,0.00,0.00,0.00,729884),('1','142','257729','342',692.00,770.00,0.00,0.00,0.00,0.00,0.00,729885),('1','142','257730','342',692.00,770.00,0.00,0.00,0.00,0.00,0.00,729886),('1','142','257731','342',692.00,770.00,0.00,0.00,0.00,0.00,0.00,729887),('1','142','257732','342',685.00,770.00,0.00,1069.42,732552.70,815857.90,83305.20,729888),('1','142','257733','342',685.00,770.00,0.00,1363.13,933744.05,1045860.10,112116.05,729889),('1','142','257734','342',685.00,770.00,0.00,1626.79,1114351.15,1224678.30,110327.15,729890),('1','142','257735','342',685.00,770.00,0.00,1541.19,1055715.15,1164316.30,108601.15,729891),('1','142','257736','342',685.00,770.00,0.00,1293.82,886266.70,981141.40,94874.70,729892),('1','142','257737','342',685.00,770.00,0.00,2153.20,1474942.00,1626073.00,151131.00,729893),('1','142','257738','342',685.00,770.00,0.00,2210.44,1514151.40,1674932.30,160780.90,729894),('1','142','257739','342',685.00,770.00,0.00,1776.75,1217073.75,1337672.00,120598.25,729895),('1','142','257740','342',685.00,770.00,0.00,2343.65,1605400.25,1762246.00,156845.75,729896),('1','142','257741','342',685.00,770.00,0.00,2134.36,1462036.60,1609357.20,147320.60,729897),('1','142','257742','342',685.00,770.00,0.00,3462.62,2371894.70,2571776.90,199882.20,729898),('1','142','257743','342',685.00,770.00,0.00,2523.93,1728892.05,1883300.60,154408.55,729899),('1','142','257744','342',685.00,770.00,0.00,875.36,599621.60,660902.20,61280.60,729900),('1','142','257745','342',685.00,770.00,0.00,402.83,275938.55,310179.10,34240.55,729901),('1','142','257746','342',685.00,770.00,0.00,2900.43,1986794.55,2181706.10,194911.55,729902),('1','142','257747','342',685.00,770.00,0.00,0.00,0.00,0.00,0.00,729903),('1','142','257748','342',685.00,770.00,0.00,0.00,0.00,0.00,0.00,729904),('1','142','257749','342',685.00,770.00,0.00,1388.56,951163.60,1066691.20,115527.60,729905),('1','142','257750','342',685.00,770.00,0.00,1349.72,924558.20,1028478.90,103920.70,729906),('1','142','257751','342',685.00,770.00,0.00,1291.13,884424.05,994170.10,109746.05,729907),('1','142','257752','342',685.00,770.00,0.00,1397.38,957205.30,1073482.60,116277.30,729908),('1','142','257753','342',685.00,770.00,0.00,1615.11,1106350.35,1234901.70,128551.35,729909),('1','142','257754','342',685.00,770.00,0.00,1541.41,1055865.85,1171885.70,116019.85,729910),('1','142','257755','342',685.00,770.00,0.00,2335.97,1600139.45,1732496.90,132357.45,729911),('1','142','257756','342',685.00,770.00,0.00,1370.48,938778.80,1024292.60,85513.80,729912),('1','142','257757','342',685.00,770.00,0.00,1548.13,1060469.05,1169910.10,109441.05,729913),('1','142','257758','342',685.00,770.00,0.00,1563.12,1070737.20,1174697.40,103960.20,729914),('1','142','257759','342',685.00,770.00,0.00,1805.42,1236712.70,1359300.40,122587.70,729915),('1','142','257760','342',685.00,770.00,0.00,1035.67,709433.95,794707.90,85273.95,729916),('1','142','257761','342',685.00,770.00,0.00,1413.68,968370.80,1073905.10,105534.30,729917),('1','142','257762','342',685.00,770.00,0.00,1009.50,691507.50,768476.00,76968.50,729918),('1','142','257763','342',685.00,770.00,0.00,905.41,620205.85,683401.70,63195.85,729919),('1','142','257764','342',685.00,770.00,0.00,1941.21,1329728.85,1462890.20,133161.35,729920),('1','142','257765','342',685.00,770.00,0.00,1771.01,1213141.85,1331427.70,118285.85,729921),('1','142','257766','342',685.00,770.00,0.00,2522.79,1728111.15,1868011.30,139900.15,729922),('1','142','257767','342',685.00,770.00,0.00,1838.94,1259673.90,1373725.80,114051.90,729923),('1','142','257768','342',685.00,770.00,0.00,3734.76,2558310.60,2746654.70,188344.10,729924),('1','142','257769','342',685.00,770.00,0.00,1536.46,1052475.10,1151390.70,98915.60,729925),('1','142','257770','342',685.00,770.00,0.00,2457.59,1683449.15,1842345.80,158896.65,729926),('1','142','257771','342',685.00,770.00,0.00,1668.76,1143100.60,1260645.20,117544.60,729927),('1','142','257772','342',685.00,770.00,0.00,1697.93,1163082.05,1270606.10,107524.05,729928),('1','142','257773','342',685.00,770.00,0.00,1607.10,1100863.50,1227467.00,126603.50,729929),('1','142','257774','342',685.00,770.00,0.00,2128.07,1457727.95,1597375.40,139647.45,729930),('1','142','257775','342',685.00,770.00,0.00,1793.45,1220944.69,1343025.50,122080.81,729931),('1','142','257776','342',677.00,770.00,0.00,2602.88,1762149.76,1951014.10,188864.34,729932),('1','142','257777','342',677.00,770.00,0.00,220.55,149312.35,158796.00,9483.65,729933),('1','142','257778','342',677.00,770.00,0.00,3854.74,2609658.98,2856729.80,247070.82,729934),('1','142','257779','342',677.00,770.00,0.00,3252.60,2202010.20,2403105.50,201095.30,729935),('1','142','257780','342',677.00,770.00,0.00,3917.71,2652289.67,2854899.70,202610.03,729936),('1','142','257781','342',677.00,770.00,0.00,2298.98,1556409.46,1717229.10,160819.64,729937),('1','142','257782','342',677.00,770.00,0.00,2074.24,1404260.48,1505641.30,101380.82,729938),('1','142','257783','342',677.00,770.00,0.00,938.43,635317.11,717571.10,82253.99,729939),('1','142','257784','342',677.00,770.00,0.00,556.36,376655.72,428397.20,51741.48,729940),('1','142','257785','342',677.00,770.00,0.00,63.42,42935.34,48833.40,5898.06,729941),('1','142','257786','342',677.00,770.00,0.00,5038.93,3411355.61,3670059.10,258703.49,729942),('1','142','257787','342',677.00,770.00,0.00,1371.86,928749.22,1039957.20,111207.98,729943),('1','142','257788','342',677.00,770.00,0.00,2255.88,1527230.76,1676777.60,149546.84,729944),('1','142','257789','342',677.00,770.00,0.00,3615.21,2447497.17,2659186.20,211689.03,729945),('1','142','257790','342',677.00,770.00,0.00,4444.89,3009190.53,3260835.30,251644.77,729946),('1','142','257791','342',677.00,770.00,0.00,1654.24,1119920.48,1238914.80,118994.32,729947),('1','142','257792','342',677.00,770.00,0.00,1597.50,1081507.50,1206658.50,125151.00,729948),('1','142','257793','342',677.00,770.00,0.00,2316.62,1568351.74,1723812.40,155460.66,729949),('1','142','257794','342',677.00,770.00,0.00,3267.77,2212280.29,2406767.40,194487.11,729950),('1','142','257795','342',677.00,770.00,0.00,1524.63,1032174.51,1102078.60,69904.09,729951),('1','142','257796','342',677.00,770.00,0.00,3069.68,2078173.36,2253910.10,175736.74,729952),('1','142','257797','342',677.00,770.00,0.00,0.00,0.00,0.00,0.00,729953),('1','142','257798','342',677.00,770.00,0.00,0.00,0.00,0.00,0.00,729954),('1','142','257799','342',677.00,770.00,0.00,0.00,0.00,0.00,0.00,729955),('1','142','257800','342',677.00,770.00,0.00,0.00,0.00,0.00,0.00,729956),('1','142','257801','342',677.00,770.00,0.00,0.00,0.00,0.00,0.00,729957),('1','142','257802','342',677.00,770.00,0.00,1782.37,1390248.60,1363080.60,-27168.00,729958),('1','142','257803','342',780.00,780.00,0.00,1833.77,1430340.60,1394500.60,-35840.00,729959),('1','142','257804','342',780.00,780.00,0.00,2064.33,1610177.40,1571977.40,-38200.00,729960),('1','142','257805','342',780.00,780.00,0.00,2877.78,2244668.40,2172732.40,-71936.00,729961),('1','142','257806','342',780.00,780.00,0.00,2230.84,1740055.20,1689695.20,-50360.00,729962),('1','142','257807','342',780.00,780.00,0.00,4533.09,3535810.20,3391459.80,-144350.40,729963),('1','142','257808','342',780.00,780.00,0.00,3436.63,2680571.40,2588865.40,-91706.00,729964),('1','142','257809','342',780.00,780.00,0.00,2694.56,1987202.00,2041657.20,54455.20,729965),('1','142','257810','342',685.00,780.00,0.00,4232.76,2899440.60,3185952.80,286512.20,729966),('1','142','257811','342',685.00,780.00,0.00,1756.15,1202962.75,1349797.00,146834.25,729967),('1','142','257812','342',685.00,780.00,0.00,3471.06,2377676.10,2624786.80,247110.70,729968),('1','142','257813','342',685.00,780.00,0.00,2395.58,1640972.30,1816692.40,175720.10,729969),('1','142','257814','342',685.00,780.00,0.00,2826.35,1936049.75,2149460.20,213410.45,729970),('1','142','257815','342',685.00,780.00,0.00,4507.45,3087603.25,3394707.80,307104.55,729971),('1','142','257816','342',685.00,780.00,0.00,2016.74,1381466.90,1550897.20,169430.30,729972),('1','142','257817','342',685.00,780.00,0.00,3714.42,2544377.70,2798800.00,254422.30,729973),('1','142','257818','342',685.00,780.00,0.00,2304.09,1578301.65,1752882.60,174580.95,729974),('1','142','257819','342',685.00,780.00,0.00,4673.70,3201484.50,3499746.00,298261.50,729975),('1','142','257820','342',685.00,780.00,0.00,2104.14,1441335.90,1595389.20,154053.30,729976),('1','142','257821','342',685.00,780.00,0.00,3791.44,2597136.40,2843358.40,246222.00,729977),('1','142','257822','342',685.00,780.00,0.00,2533.68,1735570.80,1918525.60,182954.80,729978),('1','142','257823','342',685.00,780.00,0.00,3434.02,2352303.70,2575066.00,222762.30,729979),('1','142','257824','342',685.00,780.00,0.00,1895.15,1298177.75,1417616.60,119438.85,729980),('1','142','257825','342',685.00,780.00,0.00,2735.92,1874105.20,2065188.00,191082.80,729981),('1','142','257826','342',685.00,780.00,0.00,1990.20,1363287.00,1489234.40,125947.40,729982),('1','142','257827','342',685.00,780.00,0.00,2492.00,1707020.00,1885337.60,178317.60,729983),('1','142','257828','342',685.00,780.00,0.00,4184.10,2866108.50,3130518.08,264409.58,729984),('1','142','257829','342',685.00,780.00,0.00,2267.39,1553162.15,1713396.60,160234.45,729985),('1','142','257830','342',685.00,780.00,0.00,4111.32,2816254.20,3086659.20,270405.00,729986),('1','142','257831','342',685.00,780.00,0.00,2688.17,1841396.45,2037877.00,196480.55,729987),('1','142','257832','342',685.00,780.00,0.00,3053.76,2091825.60,2304738.00,212912.40,729988),('1','142','257833','342',685.00,780.00,0.00,5059.70,3465894.50,3790042.00,324147.50,729989),('1','142','257834','342',685.00,780.00,0.00,2626.92,1799440.20,1990609.60,191169.40,729990),('1','142','257835','342',685.00,780.00,0.00,2635.09,1805036.65,1983614.60,178577.95,729991),('1','142','257836','342',685.00,780.00,0.00,2639.93,1808352.05,1995107.80,186755.75,729992),('1','142','257837','342',685.00,780.00,0.00,2527.42,1731282.70,1915160.40,183877.70,729993),('1','142','257838','342',685.00,780.00,0.00,3925.36,2688871.60,2946630.00,257758.40,729994),('1','142','257839','342',685.00,780.00,0.00,2509.16,1718774.60,1908429.20,189654.60,729995),('1','142','257840','342',685.00,780.00,0.00,2737.13,1874934.05,2073015.80,198081.75,729996),('1','142','257841','342',685.00,780.00,0.00,3392.88,2324122.80,2556810.80,232688.00,729997),('1','142','257842','342',685.00,780.00,0.00,487.16,333704.60,369962.00,36257.40,729998),('1','142','257843','342',685.00,780.00,0.00,2572.80,1762368.00,1952104.00,189736.00,729999),('1','142','257844','342',685.00,780.00,0.00,0.00,0.00,0.00,0.00,730000),('1','142','257845','342',685.00,780.00,0.00,0.00,0.00,0.00,0.00,730001),('1','142','257846','342',685.00,780.00,0.00,0.00,0.00,0.00,0.00,730002),('1','142','257847','342',685.00,780.00,0.00,0.00,0.00,0.00,0.00,730003),('1','142','257848','342',685.00,780.00,0.00,0.00,0.00,0.00,0.00,730004),('1','142','257849','342',685.00,780.00,0.00,4388.24,3005944.40,3306229.60,300285.20,730005),('1','142','257850','342',685.00,780.00,0.00,4831.36,3309481.60,3644236.40,334754.80,730006),('1','142','257851','342',685.00,780.00,0.00,2499.86,1712404.10,1911208.80,198804.70,730007),('1','142','257852','342',685.00,780.00,0.00,3889.08,2664019.80,2935856.80,271837.00,730008),('1','142','257853','342',685.00,780.00,0.00,1753.30,1201010.50,1324571.60,123561.10,730009),('1','142','257854','342',685.00,780.00,0.00,4285.99,2935903.15,3244035.00,308131.85,730010),('1','142','257855','342',685.00,780.00,0.00,302.68,207335.80,236090.40,28754.60,730011),('1','142','257856','342',685.00,780.00,0.00,0.00,0.00,0.00,0.00,730012),('1','142','257857','342',676.00,780.00,0.00,889.66,601410.16,677934.80,76524.64,730013),('1','142','257858','342',676.00,780.00,0.00,1386.00,936936.00,1021482.00,84546.00,730014),('1','142','257859','342',676.00,780.00,0.00,3466.93,2343644.68,2614201.40,270556.72,730015),('1','142','257860','342',676.00,780.00,0.00,2994.95,2024586.20,2260941.00,236354.80,730016),('1','142','257861','342',676.00,780.00,0.00,2153.85,1456002.60,1644503.00,188500.40,730017),('1','142','257862','342',676.00,780.00,0.00,3834.62,2592203.12,2892019.60,299816.48,730018),('1','142','257863','342',676.00,780.00,0.00,2824.13,1909111.88,2132021.40,222909.52,730019),('1','142','257864','342',676.00,780.00,0.00,3375.82,2282054.32,2538139.60,256085.28,730020),('1','142','257865','342',676.00,780.00,0.00,1105.10,747047.60,861978.00,114930.40,730021),('1','142','257866','342',676.00,780.00,0.00,2428.69,1641794.44,1803966.60,162172.16,730022),('1','142','257867','342',676.00,780.00,0.00,0.00,0.00,0.00,0.00,730023),('1','142','257868','342',676.00,780.00,0.00,1504.90,1017312.40,1145434.80,128122.40,730024),('1','142','257869','342',676.00,780.00,0.00,3209.69,2169750.44,2428934.20,259183.76,730025),('1','142','257870','342',676.00,780.00,0.00,2750.54,1859365.04,2079512.00,220146.96,730026),('1','142','257871','342',676.00,780.00,0.00,2763.42,1868071.92,2087528.40,219456.48,730027),('1','142','257872','342',676.00,780.00,0.00,1898.72,1283534.72,1445639.60,162104.88,730028),('1','142','257873','342',676.00,780.00,0.00,2759.66,1865530.16,2082130.00,216599.84,730029),('1','142','257874','342',676.00,780.00,0.00,3211.95,2171278.20,2439280.20,268002.00,730030),('1','142','257875','342',676.00,780.00,0.00,1932.94,1306667.44,1476213.20,169545.76,730031),('1','142','257876','342',676.00,780.00,0.00,2001.17,1352790.92,1518552.60,165761.68,730032),('1','142','257877','342',676.00,780.00,0.00,1308.45,884512.20,996619.00,112106.80,730033),('1','142','257878','342',676.00,780.00,0.00,4549.77,3075644.52,3410239.80,334595.28,730034),('1','142','257879','342',676.00,780.00,0.00,4519.38,3055100.88,3461024.40,405923.52,730035),('1','142','257880','342',676.00,780.00,0.00,4051.09,2738536.84,3051268.20,312731.36,730036),('1','142','257881','342',676.00,780.00,0.00,3608.63,2439433.88,2712338.20,272904.32,730037),('1','142','257882','342',676.00,780.00,0.00,1991.68,1346375.68,1521044.00,174668.32,730038),('1','142','257883','342',676.00,780.00,0.00,2092.02,1414205.52,1607083.60,192878.08,730039),('1','142','257884','342',676.00,780.00,0.00,1783.01,1205314.76,1367347.80,162033.04,730040),('1','142','257885','342',676.00,780.00,0.00,2891.30,1954518.80,2187168.80,232650.00,730041),('1','142','257886','342',676.00,780.00,0.00,2778.09,1877988.84,2114273.00,236284.16,730042),('1','142','257887','342',676.00,780.00,0.00,2081.25,1406925.00,1593928.20,187003.20,730043),('1','142','257888','342',676.00,780.00,0.00,2793.93,1888696.68,2119802.20,231105.52,730044),('1','142','257889','342',676.00,780.00,0.00,3310.60,2237965.60,2510228.00,272262.40,730045),('1','142','257890','342',676.00,780.00,0.00,3090.18,2088961.68,2336321.60,247359.92,730046),('1','142','257891','342',676.00,780.00,0.00,2621.94,1772431.44,1993266.80,220835.36,730047),('1','142','257892','342',676.00,780.00,0.00,2750.52,1859351.52,2087505.60,228154.08,730048),('1','142','257893','342',676.00,780.00,0.00,3960.01,2676966.76,2976713.40,299746.64,730049),('1','142','257894','342',676.00,780.00,0.00,1866.61,1261828.36,1395610.20,133781.84,730050),('1','142','257895','342',676.00,780.00,0.00,0.00,0.00,0.00,0.00,730051),('1','142','257896','342',676.00,780.00,0.00,0.00,0.00,0.00,0.00,730052),('1','142','257897','342',676.00,780.00,0.00,0.00,0.00,0.00,0.00,730053),('1','142','257898','342',676.00,780.00,0.00,2905.92,1964401.92,2164698.00,200296.08,730054),('1','142','257899','342',676.00,780.00,0.00,3066.28,2072805.28,2325006.00,252200.72,730055),('1','142','257900','342',676.00,780.00,0.00,4445.93,3005448.68,3343905.40,338456.72,730056),('1','142','257901','342',676.00,780.00,0.00,2562.47,1732229.72,1950846.60,218616.88,730057),('1','142','257902','342',676.00,780.00,0.00,3012.42,2036395.92,2290796.00,254400.08,730058),('1','142','257903','342',676.00,780.00,0.00,2803.87,1895416.12,2131338.60,235922.48,730059),('1','142','257904','342',676.00,780.00,0.00,2489.71,1683043.96,1899473.80,216429.84,730060),('1','142','257905','342',676.00,780.00,0.00,3097.56,2093950.56,2333336.80,239386.24,730061),('1','142','257906','342',676.00,780.00,0.00,586.27,396318.52,451090.60,54772.08,730062),('1','142','257907','342',676.00,780.00,0.00,0.00,0.00,0.00,0.00,730063),('1','142','257908','342',676.00,780.00,0.00,3972.97,2685727.72,2982953.90,297226.18,730064),('1','142','257909','342',676.00,780.00,0.00,3394.33,2294567.08,2564028.20,269461.12,730065),('1','142','257910','342',676.00,780.00,0.00,2217.55,1499063.80,1694729.00,195665.20,730066),('1','142','257911','342',676.00,780.00,0.00,3258.92,2203029.92,2459298.00,256268.08,730067),('1','142','257912','342',676.00,780.00,0.00,3817.75,2580799.00,2879229.40,298430.40,730068),('1','142','257913','342',676.00,780.00,0.00,2461.95,1664278.20,1877159.00,212880.80,730069),('1','142','257914','342',676.00,780.00,0.00,2351.32,1589492.32,1792624.00,203131.68,730070),('1','142','257915','342',676.00,780.00,0.00,2509.97,1696739.72,1908174.60,211434.88,730071),('1','142','257916','342',676.00,780.00,0.00,714.01,482670.76,532927.80,50257.04,730072),('1','142','257917','342',676.00,780.00,0.00,0.00,0.00,0.00,0.00,730073),('1','142','257918','342',676.00,780.00,0.00,2464.66,1666110.16,1865296.40,199186.24,730074),('1','142','257919','342',676.00,780.00,0.00,2799.03,1892144.28,2125308.60,233164.32,730075),('1','142','257920','342',676.00,780.00,0.00,2719.14,1838138.64,2051999.60,213860.96,730076),('1','142','257921','342',676.00,780.00,0.00,1789.02,1209377.52,1372379.20,163001.68,730077),('1','142','257922','342',676.00,780.00,0.00,1838.16,1242596.16,1412044.80,169448.64,730078),('1','142','257923','342',676.00,780.00,0.00,2806.92,1897477.92,2120960.00,223482.08,730079),('1','142','257924','342',676.00,780.00,0.00,2941.99,1988785.24,2226946.60,238161.36,730080),('1','142','257925','342',676.00,780.00,0.00,1031.93,697584.68,793505.40,95920.72,730081),('1','142','257926','342',676.00,780.00,0.00,3031.21,2049097.96,2303393.80,254295.84,730082),('1','142','257927','342',676.00,780.00,0.00,1551.51,1048820.76,1195377.80,146557.04,730083),('1','142','257928','342',676.00,780.00,0.00,1600.05,1059664.80,1200888.60,141223.80,730084),('1','142','257929','342',651.00,780.00,0.00,0.00,0.00,0.00,0.00,730085),('1','142','257930','342',651.00,780.00,0.00,3510.99,2285654.49,2593207.70,307553.21,730086),('1','142','257931','342',651.00,780.00,0.00,1414.08,920566.08,1094982.40,174416.32,730087),('1','142','257932','342',760.00,760.00,0.00,2392.23,1818094.80,1765138.40,-52956.40,730088),('1','142','257933','342',760.00,760.00,0.00,2493.87,1895341.20,1855141.20,-40200.00,730089),('1','142','257934','342',760.00,760.00,0.00,2679.69,2036564.40,1982773.20,-53791.20,730090),('1','142','257935','342',760.00,760.00,0.00,2149.49,1633612.40,1594813.60,-38798.80,730091),('1','142','257936','342',760.00,760.00,0.00,2277.17,1730649.20,1690249.20,-40400.00,730092),('1','142','257937','342',760.00,760.00,0.00,2132.90,1621004.00,1572011.20,-48992.80,730093),('1','142','257938','342',760.00,760.00,0.00,3039.14,2309746.40,2242146.00,-67600.40,730094),('1','142','257939','342',760.00,760.00,0.00,2714.55,1929005.07,1996661.60,67656.53,730095),('1','142','257940','342',661.00,760.00,0.00,1354.19,895119.59,1010184.40,115064.81,730096),('1','142','257941','342',661.00,760.00,0.00,1570.82,1038312.02,1171829.60,133517.58,730097),('1','142','257942','342',661.00,760.00,0.00,2426.27,1603764.47,1799085.20,195320.73,730098),('1','142','257943','342',661.00,760.00,0.00,1184.31,782828.91,899755.60,116926.69,730099),('1','142','257944','342',661.00,760.00,0.00,1572.82,1039634.02,1165645.60,126011.58,730100),('1','142','257945','342',661.00,760.00,0.00,1701.70,1124823.70,1285292.00,160468.30,730101),('1','142','257946','342',661.00,760.00,0.00,1884.58,1245707.38,1393280.80,147573.42,730102),('1','142','257947','342',661.00,760.00,0.00,1517.25,1002902.25,1143910.00,141007.75,730103),('1','142','257948','342',661.00,760.00,0.00,3203.90,2117777.90,2353106.80,235328.90,730104),('1','142','257949','342',661.00,760.00,0.00,2134.99,1411228.39,1595794.80,184566.41,730105),('1','142','257950','342',661.00,760.00,0.00,2313.45,1529190.45,1728485.20,199294.75,730106),('1','142','257951','342',661.00,760.00,0.00,2333.04,1542139.44,1747110.40,204970.96,730107),('1','142','257952','342',661.00,760.00,0.00,97.55,64480.55,74138.00,9657.45,730108),('1','142','257953','342',661.00,760.00,0.00,2638.37,1743962.57,1963641.20,219678.63,730109),('1','142','257954','342',661.00,750.00,0.00,3929.39,2597326.79,2858042.90,260716.11,730110),('1','142','257955','342',661.00,750.00,0.00,1530.54,1011686.94,1143905.00,132218.06,730111),('1','142','257956','342',661.00,750.00,0.00,2387.93,1578421.73,1751519.90,173098.17,730112),('1','142','257957','342',661.00,750.00,0.00,1537.52,1016300.72,1135140.00,118839.28,730113),('1','142','257958','342',661.00,750.00,0.00,2220.26,1467591.86,1630195.00,162603.14,730114),('1','142','257959','342',661.00,750.00,0.00,1949.82,1288831.02,1440365.00,151533.98,730115),('1','142','257960','342',661.00,750.00,0.00,1526.88,1009267.68,1131160.00,121892.32,730116),('1','142','257961','342',661.00,750.00,0.00,1649.13,1090074.93,1224966.30,134891.37,730117),('1','142','257962','342',661.00,750.00,0.00,3278.50,2167088.50,2384875.00,217786.50,730118),('1','142','257963','342',661.00,750.00,0.00,2030.28,1342015.08,1494110.00,152094.92,730119),('1','142','257964','342',661.00,750.00,0.00,1596.98,1055603.78,1183735.00,128131.22,730120),('1','142','257965','342',661.00,750.00,0.00,1770.66,1152899.56,1309716.20,156816.64,730121),('1','142','257966','342',651.00,750.00,0.00,2008.52,1307546.52,1475132.40,167585.88,730122),('1','142','257967','342',651.00,750.00,0.00,1582.06,1029921.06,1176177.00,146255.94,730123),('1','142','257968','342',651.00,750.00,0.00,2718.19,1769541.69,1980614.50,211072.81,730124),('1','142','257969','342',651.00,750.00,0.00,1888.42,1229361.42,1391315.00,161953.58,730125),('1','142','257970','342',651.00,750.00,0.00,3780.27,2460955.77,2747602.50,286646.73,730126),('1','142','257971','342',651.00,750.00,0.00,2559.26,1666078.26,1882418.20,216339.94,730127),('1','142','257972','342',651.00,750.00,0.00,3898.32,2537806.32,2848180.00,310373.68,730128),('1','142','257973','342',651.00,750.00,0.00,2932.49,1909050.99,2121367.50,212316.51,730129),('1','142','257974','342',646.00,750.00,0.00,1051.68,679385.28,779720.00,100334.72,730130);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=318 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',317,'142','PRODUCT TANKS','TANKS CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=800 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','142','317',798,1,'342','LPG TANK 1',20000.00,1.00,14583.18,'TANK CONTAINING LPG PRODUCT.','479','2020-08-31 17:26:15','2020-08-31 17:26:15','479',5,1),('1','142','317',799,1,'342','LPG TANK 2',20000.00,1.00,3356.67,'TANK CONTAINING LPG PRODUCT.','479','2020-08-31 17:27:35','2020-08-31 17:27:35','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','142',798,6368.02,'2023-03-20 19:50:50'),(2,'1','142',799,4827.15,'2023-03-20 19:51:18');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2720921 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2108420,'1','142','799',342,'Retail Sale Id 1254226',8200.00,0.00,0.00,0.00,725.00,'2021-12-01 06:47:45','',''),(2108421,'1','142','799',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:47:45','',''),(2108499,'1','142','799',342,'Retail Sale Id 1254261',4001.60,0.00,0.00,0.00,353.80,'2021-12-01 06:52:11','',''),(2108500,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-01 06:52:11','',''),(2108585,'1','142','799',342,'Retail Sale Id 1254289',500001.15,0.00,0.00,0.00,23126.05,'2021-12-01 06:56:00','',''),(2108586,'1','142','799',342,'Retail sales',0.00,0.00,0.00,797.45,0.00,'2021-12-01 06:56:00','',''),(2108658,'1','142','799',342,'Retail Sale Id 1254336',3936.00,0.00,0.00,0.00,348.00,'2021-12-01 06:59:10','',''),(2108659,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 06:59:10','',''),(2108817,'1','142','799',342,'Retail Sale Id 1254405',3936.00,0.00,0.00,0.00,348.00,'2021-12-01 07:06:45','',''),(2108818,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 07:06:45','',''),(2108905,'1','142','799',342,'Retail Sale Id 1254437',2997.92,0.00,0.00,0.00,265.06,'2021-12-01 07:10:33','',''),(2108906,'1','142','799',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-01 07:10:33','',''),(2109110,'1','142','799',342,'Retail Sale Id 1254534',1318.56,0.00,0.00,0.00,116.58,'2021-12-01 07:20:52','',''),(2109111,'1','142','799',342,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-01 07:20:52','',''),(2109368,'1','142','799',342,'Retail Sale Id 1254641',4001.60,0.00,0.00,0.00,353.80,'2021-12-01 07:33:19','',''),(2109369,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-01 07:33:19','',''),(2109582,'1','142','799',342,'Retail Sale Id 1254744',656.00,0.00,0.00,0.00,58.00,'2021-12-01 07:42:23','',''),(2109583,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 07:42:23','',''),(2109631,'1','142','799',342,'Retail Sale Id 1254768',1968.00,0.00,0.00,0.00,174.00,'2021-12-01 07:45:02','',''),(2109632,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 07:45:02','',''),(2109685,'1','142','799',342,'Retail Sale Id 1254787',3280.00,0.00,0.00,0.00,290.00,'2021-12-01 07:46:26','',''),(2109686,'1','142','799',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 07:46:26','',''),(2109730,'1','142','799',342,'Retail Sale Id 1254806',1968.00,0.00,0.00,0.00,174.00,'2021-12-01 07:48:05','',''),(2109731,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 07:48:05','',''),(2109794,'1','142','799',342,'Retail Sale Id 1254838',997.12,0.00,0.00,0.00,88.16,'2021-12-01 07:51:27','',''),(2109795,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 07:51:27','',''),(2109796,'1','142','799',342,'Retail Sale Id 1254838',997.12,0.00,0.00,0.00,88.16,'2021-12-01 07:51:27','',''),(2109797,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 07:51:27','',''),(2109835,'1','142','799',342,'Retail Sale Id 1254853',8200.00,0.00,0.00,0.00,725.00,'2021-12-01 07:53:24','',''),(2109836,'1','142','799',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:53:24','',''),(2109897,'1','142','799',342,'Retail Sale Id 1254894',8200.00,0.00,0.00,0.00,725.00,'2021-12-01 07:56:54','',''),(2109898,'1','142','799',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:56:54','',''),(2109979,'1','142','799',342,'Retail Sale Id 1254930',4001.60,0.00,0.00,0.00,353.80,'2021-12-01 08:01:33','',''),(2109980,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-01 08:01:33','',''),(2110021,'1','142','799',342,'Retail Sale Id 1254951',4001.60,0.00,0.00,0.00,353.80,'2021-12-01 08:03:20','',''),(2110022,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-01 08:03:20','',''),(2110190,'1','142','799',342,'Retail Sale Id 1255029',24600.00,0.00,0.00,0.00,2175.00,'2021-12-01 08:13:05','',''),(2110191,'1','142','799',342,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-01 08:13:05','',''),(2110228,'1','142','799',342,'Retail Sale Id 1255048',3280.00,0.00,0.00,0.00,290.00,'2021-12-01 08:15:11','',''),(2110229,'1','142','799',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:15:11','',''),(2110276,'1','142','799',342,'Retail Sale Id 1255073',3936.00,0.00,0.00,0.00,348.00,'2021-12-01 08:17:38','',''),(2110277,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:17:38','',''),(2110328,'1','142','799',342,'Retail Sale Id 1255102',3936.00,0.00,0.00,0.00,348.00,'2021-12-01 08:20:17','',''),(2110329,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:20:17','',''),(2110330,'1','142','799',342,'Retail Sale Id 1255102',8200.00,0.00,0.00,0.00,725.00,'2021-12-01 08:20:17','',''),(2110331,'1','142','799',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:20:17','',''),(2110453,'1','142','799',342,'Retail Sale Id 1255166',32948.85,0.00,0.00,0.00,1523.95,'2021-12-01 08:28:42','',''),(2110454,'1','142','799',342,'Retail sales',0.00,0.00,0.00,52.55,0.00,'2021-12-01 08:28:42','',''),(2110477,'1','142','799',342,'Retail Sale Id 1255178',4001.60,0.00,0.00,0.00,353.80,'2021-12-01 08:30:12','',''),(2110478,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-01 08:30:12','',''),(2110509,'1','142','799',342,'Retail Sale Id 1255194',6002.40,0.00,0.00,0.00,530.70,'2021-12-01 08:32:04','',''),(2110510,'1','142','799',342,'Retail sales',0.00,0.00,0.00,9.15,0.00,'2021-12-01 08:32:04','',''),(2110550,'1','142','799',342,'Retail Sale Id 1255208',3936.00,0.00,0.00,0.00,348.00,'2021-12-01 08:33:45','',''),(2110551,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:33:45','',''),(2110609,'1','142','799',342,'Retail Sale Id 1255234',2499.36,0.00,0.00,0.00,220.98,'2021-12-01 08:37:32','',''),(2110610,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-01 08:37:32','',''),(2110671,'1','142','799',342,'Retail Sale Id 1255259',4998.72,0.00,0.00,0.00,441.96,'2021-12-01 08:40:40','',''),(2110672,'1','142','799',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-01 08:40:40','',''),(2110720,'1','142','799',342,'Retail Sale Id 1255288',997.12,0.00,0.00,0.00,88.16,'2021-12-01 08:43:03','',''),(2110721,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 08:43:03','',''),(2110722,'1','142','799',342,'Retail Sale Id 1255288',997.12,0.00,0.00,0.00,88.16,'2021-12-01 08:43:03','',''),(2110723,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 08:43:03','',''),(2110900,'1','142','799',342,'Retail Sale Id 1255390',4001.60,0.00,0.00,0.00,353.80,'2021-12-01 08:54:11','',''),(2110901,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-01 08:54:11','',''),(2111090,'1','142','799',342,'Retail Sale Id 1255485',3936.00,0.00,0.00,0.00,348.00,'2021-12-01 09:04:58','',''),(2111091,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 09:04:58','',''),(2111543,'1','142','799',342,'Retail Sale Id 1255725',997.12,0.00,0.00,0.00,88.16,'2021-12-01 09:33:55','',''),(2111544,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 09:33:55','',''),(2111589,'1','142','799',342,'Retail Sale Id 1255744',41131.20,0.00,0.00,0.00,3636.60,'2021-12-01 09:36:36','',''),(2111590,'1','142','799',342,'Retail sales',0.00,0.00,0.00,62.70,0.00,'2021-12-01 09:36:36','',''),(2111617,'1','142','799',342,'Retail Sale Id 1255762',173250.00,0.00,0.00,0.00,8800.00,'2021-12-01 09:37:52','',''),(2111618,'1','142','799',342,'Retail sales',0.00,0.00,0.00,275.00,0.00,'2021-12-01 09:37:52','',''),(2111688,'1','142','799',342,'Retail Sale Id 1255799',2000.80,0.00,0.00,0.00,176.90,'2021-12-01 09:43:05','',''),(2111689,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 09:43:05','',''),(2111770,'1','142','799',342,'Retail Sale Id 1255849',8200.00,0.00,0.00,0.00,725.00,'2021-12-01 09:48:47','',''),(2111771,'1','142','799',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:48:47','',''),(2111802,'1','142','799',342,'Retail Sale Id 1255865',3936.00,0.00,0.00,0.00,348.00,'2021-12-01 09:51:35','',''),(2111803,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 09:51:35','',''),(2111892,'1','142','799',342,'Retail Sale Id 1255904',997.12,0.00,0.00,0.00,88.16,'2021-12-01 09:57:50','',''),(2111893,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 09:57:50','',''),(2111949,'1','142','799',342,'Retail Sale Id 1255924',3936.00,0.00,0.00,0.00,348.00,'2021-12-01 10:00:46','',''),(2111950,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 10:00:46','',''),(2111995,'1','142','799',342,'Retail Sale Id 1255949',5904.00,0.00,0.00,0.00,522.00,'2021-12-01 10:02:56','',''),(2111996,'1','142','799',342,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-01 10:02:56','',''),(2112049,'1','142','799',342,'Retail Sale Id 1255976',18900.00,0.00,0.00,0.00,960.00,'2021-12-01 10:08:30','',''),(2112050,'1','142','799',342,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-01 10:08:30','',''),(2112146,'1','142','799',342,'Retail Sale Id 1256028',1502.24,0.00,0.00,0.00,132.82,'2021-12-01 10:14:33','',''),(2112147,'1','142','799',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-01 10:14:33','',''),(2112164,'1','142','799',342,'Retail Sale Id 1256036',1968.00,0.00,0.00,0.00,174.00,'2021-12-01 10:15:32','',''),(2112165,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 10:15:32','',''),(2112219,'1','142','799',342,'Retail Sale Id 1256059',3280.00,0.00,0.00,0.00,290.00,'2021-12-01 10:18:13','',''),(2112220,'1','142','799',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 10:18:13','',''),(2112233,'1','142','799',342,'Retail Sale Id 1256065',3936.00,0.00,0.00,0.00,348.00,'2021-12-01 10:19:18','',''),(2112234,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 10:19:18','',''),(2112269,'1','142','799',342,'Retail Sale Id 1256088',4998.72,0.00,0.00,0.00,441.96,'2021-12-01 10:22:57','',''),(2112270,'1','142','799',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-01 10:22:57','',''),(2112337,'1','142','799',342,'Retail Sale Id 1256114',7872.00,0.00,0.00,0.00,696.00,'2021-12-01 10:28:33','',''),(2112338,'1','142','799',342,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-01 10:28:33','',''),(2112377,'1','142','799',342,'Retail Sale Id 1256133',4001.60,0.00,0.00,0.00,353.80,'2021-12-01 10:31:36','',''),(2112378,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-01 10:31:36','',''),(2112395,'1','142','799',342,'Retail Sale Id 1256146',1968.00,0.00,0.00,0.00,174.00,'2021-12-01 10:32:51','',''),(2112396,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 10:32:51','',''),(2112415,'1','142','799',342,'Retail Sale Id 1256156',2499.36,0.00,0.00,0.00,220.98,'2021-12-01 10:34:11','',''),(2112416,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-01 10:34:11','',''),(2112483,'1','142','799',342,'Retail Sale Id 1256187',1968.00,0.00,0.00,0.00,174.00,'2021-12-01 10:38:46','',''),(2112484,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 10:38:46','',''),(2112608,'1','142','799',342,'Retail Sale Id 1256252',1968.00,0.00,0.00,0.00,174.00,'2021-12-01 10:49:33','',''),(2112609,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 10:49:33','',''),(2112618,'1','142','799',342,'Retail Sale Id 1256257',1502.24,0.00,0.00,0.00,132.82,'2021-12-01 10:50:37','',''),(2112619,'1','142','799',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-01 10:50:37','',''),(2112682,'1','142','799',342,'Retail Sale Id 1256293',4001.60,0.00,0.00,0.00,353.80,'2021-12-01 10:57:30','',''),(2112683,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-01 10:57:30','',''),(2112704,'1','142','799',342,'Retail Sale Id 1256305',1968.00,0.00,0.00,0.00,174.00,'2021-12-01 10:59:04','',''),(2112705,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 10:59:04','',''),(2112757,'1','142','799',342,'Retail Sale Id 1256330',3936.00,0.00,0.00,0.00,348.00,'2021-12-01 11:03:12','',''),(2112758,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 11:03:12','',''),(2112796,'1','142','799',342,'Retail Sale Id 1256352',2000.80,0.00,0.00,0.00,176.90,'2021-12-01 11:06:08','',''),(2112797,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 11:06:08','',''),(2112832,'1','142','799',342,'Retail Sale Id 1256368',2499.36,0.00,0.00,0.00,220.98,'2021-12-01 11:08:21','',''),(2112833,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-01 11:08:21','',''),(2112915,'1','142','799',342,'Retail Sale Id 1256406',4001.60,0.00,0.00,0.00,353.80,'2021-12-01 11:13:12','',''),(2112916,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-01 11:13:12','',''),(2112931,'1','142','799',342,'Retail Sale Id 1256413',1968.00,0.00,0.00,0.00,174.00,'2021-12-01 11:14:31','',''),(2112932,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 11:14:31','',''),(2113046,'1','142','799',342,'Retail Sale Id 1256456',1502.24,0.00,0.00,0.00,132.82,'2021-12-01 11:19:54','',''),(2113047,'1','142','799',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-01 11:19:54','',''),(2113058,'1','142','799',342,'Retail Sale Id 1256468',997.12,0.00,0.00,0.00,88.16,'2021-12-01 11:21:15','',''),(2113059,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 11:21:15','',''),(2113090,'1','142','799',342,'Retail Sale Id 1256486',2997.92,0.00,0.00,0.00,265.06,'2021-12-01 11:23:46','',''),(2113091,'1','142','799',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-01 11:23:46','',''),(2113216,'1','142','799',342,'Retail Sale Id 1256545',2499.36,0.00,0.00,0.00,220.98,'2021-12-01 11:31:09','',''),(2113217,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-01 11:31:09','',''),(2113230,'1','142','799',342,'Retail Sale Id 1256551',8200.00,0.00,0.00,0.00,725.00,'2021-12-01 11:32:25','',''),(2113231,'1','142','799',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:32:25','',''),(2113331,'1','142','799',342,'Retail Sale Id 1256606',3280.00,0.00,0.00,0.00,290.00,'2021-12-01 11:39:50','',''),(2113332,'1','142','799',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 11:39:50','',''),(2113423,'1','142','799',342,'Retail Sale Id 1256657',1312.00,0.00,0.00,0.00,116.00,'2021-12-01 11:47:27','',''),(2113424,'1','142','799',342,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 11:47:27','',''),(2113443,'1','142','799',342,'Retail Sale Id 1256665',1502.24,0.00,0.00,0.00,132.82,'2021-12-01 11:48:58','',''),(2113444,'1','142','799',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-01 11:48:58','',''),(2113477,'1','142','799',342,'Retail Sale Id 1256683',3503.04,0.00,0.00,0.00,309.72,'2021-12-01 11:51:52','',''),(2113478,'1','142','799',342,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-01 11:51:52','',''),(2113497,'1','142','799',342,'Retail Sale Id 1256691',2000.80,0.00,0.00,0.00,176.90,'2021-12-01 11:53:08','',''),(2113498,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 11:53:08','',''),(2113529,'1','142','799',342,'Retail Sale Id 1256712',1200.48,0.00,0.00,0.00,106.14,'2021-12-01 11:55:31','',''),(2113530,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.83,0.00,'2021-12-01 11:55:31','',''),(2113547,'1','142','799',342,'Retail Sale Id 1256718',656.00,0.00,0.00,0.00,58.00,'2021-12-01 11:57:02','',''),(2113548,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 11:57:02','',''),(2113609,'1','142','799',342,'Retail Sale Id 1256758',2000.80,0.00,0.00,0.00,176.90,'2021-12-01 12:04:35','',''),(2113610,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 12:04:35','',''),(2113795,'1','142','799',342,'Retail Sale Id 1256853',3942.56,0.00,0.00,0.00,348.58,'2021-12-01 12:19:15','',''),(2113796,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 12:19:15','',''),(2113829,'1','142','799',342,'Retail Sale Id 1256870',2997.92,0.00,0.00,0.00,265.06,'2021-12-01 12:20:53','',''),(2113830,'1','142','799',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-01 12:20:53','',''),(2114009,'1','142','799',342,'Retail Sale Id 1256960',6560.00,0.00,0.00,0.00,580.00,'2021-12-01 12:34:30','',''),(2114010,'1','142','799',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 12:34:30','',''),(2114027,'1','142','799',342,'Retail Sale Id 1256969',111606.00,0.00,0.00,0.00,5162.00,'2021-12-01 12:35:55','',''),(2114028,'1','142','799',342,'Retail sales',0.00,0.00,0.00,178.00,0.00,'2021-12-01 12:35:55','',''),(2114097,'1','142','798',342,'Retail Sale Id 1257005',8200.00,0.00,0.00,0.00,725.00,'2021-12-01 12:44:15','',''),(2114098,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:44:15','',''),(2115067,'1','142',NULL,342,'Purchased from AA RANO NIGERIA LIMITED',0.00,14817760.00,25030.00,0.00,0.00,'2021-12-01 13:53:25','',''),(2115174,'1','142',NULL,342,'Reception corrector for bridging 125851',0.00,0.00,0.00,17030.00,0.00,'2021-12-01 13:59:32','',''),(2115175,'1','142','798',342,'Received from bridging 125851',0.00,0.00,17030.00,0.00,0.00,'2021-12-01 13:59:32','',''),(2115855,'1','142','798',342,'Retail Sale Id 1257870',3936.00,0.00,0.00,0.00,384.00,'2021-12-01 14:47:25','',''),(2115857,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 14:47:25','',''),(2115885,'1','142','798',342,'Retail Sale Id 1257884',1968.00,0.00,0.00,0.00,192.00,'2021-12-01 14:48:41','',''),(2115886,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:48:41','',''),(2115918,'1','142','798',342,'Retail Sale Id 1257896',1968.00,0.00,0.00,0.00,192.00,'2021-12-01 14:50:11','',''),(2115919,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:50:11','',''),(2115935,'1','142','799',342,'Retail Sale Id 1257901',1968.00,0.00,0.00,0.00,192.00,'2021-12-01 14:51:04','',''),(2115936,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:51:04','',''),(2115957,'1','142','799',342,'Retail Sale Id 1257907',2624.00,0.00,0.00,0.00,256.00,'2021-12-01 14:51:59','',''),(2115958,'1','142','799',342,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 14:51:59','',''),(2115998,'1','142','798',342,'Retail Sale Id 1257914',3942.56,0.00,0.00,0.00,384.64,'2021-12-01 14:52:56','',''),(2115999,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 14:52:56','',''),(2116026,'1','142','798',342,'Retail Sale Id 1257921',2499.36,0.00,0.00,0.00,243.84,'2021-12-01 14:53:51','',''),(2116027,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-01 14:53:51','',''),(2116042,'1','142','798',342,'Retail Sale Id 1257929',3942.56,0.00,0.00,0.00,384.64,'2021-12-01 14:54:53','',''),(2116043,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 14:54:53','',''),(2116092,'1','142','798',342,'Retail Sale Id 1257953',157000.00,0.00,0.00,0.00,9000.00,'2021-12-01 14:59:05','',''),(2116093,'1','142','798',342,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-01 14:59:05','',''),(2116140,'1','142','798',342,'Retail Sale Id 1257980',4100.00,0.00,0.00,0.00,400.00,'2021-12-01 15:02:48','',''),(2116141,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 15:02:48','',''),(2116199,'1','142','799',342,'Retail Sale Id 1258010',1968.00,0.00,0.00,0.00,192.00,'2021-12-01 15:07:15','',''),(2116200,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:07:15','',''),(2116221,'1','142','798',342,'Retail Sale Id 1258021',25200.00,0.00,0.00,0.00,1520.00,'2021-12-01 15:09:43','',''),(2116222,'1','142','798',342,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-01 15:09:43','',''),(2116235,'1','142','798',342,'Retail Sale Id 1258029',3780.00,0.00,0.00,0.00,228.00,'2021-12-01 15:10:55','',''),(2116236,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:10:55','',''),(2116263,'1','142','798',342,'Retail Sale Id 1258043',8200.00,0.00,0.00,0.00,800.00,'2021-12-01 15:13:08','',''),(2116264,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:13:08','',''),(2116300,'1','142','798',342,'Retail Sale Id 1258058',2000.80,0.00,0.00,0.00,195.20,'2021-12-01 15:14:38','',''),(2116301,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 15:14:38','',''),(2116322,'1','142','798',342,'Retail Sale Id 1258072',1797.44,0.00,0.00,0.00,175.36,'2021-12-01 15:16:01','',''),(2116323,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.74,0.00,'2021-12-01 15:16:01','',''),(2116354,'1','142','798',342,'Retail Sale Id 1258086',1968.00,0.00,0.00,0.00,192.00,'2021-12-01 15:18:10','',''),(2116355,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:18:10','',''),(2116366,'1','142','798',342,'Retail Sale Id 1258093',1968.00,0.00,0.00,0.00,192.00,'2021-12-01 15:19:00','',''),(2116367,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:19:00','',''),(2116428,'1','142','798',342,'Retail Sale Id 1258118',2499.36,0.00,0.00,0.00,243.84,'2021-12-01 15:22:21','',''),(2116429,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-01 15:22:21','',''),(2116620,'1','142','798',342,'Retail Sale Id 1258211',32800.00,0.00,0.00,0.00,3200.00,'2021-12-01 15:35:11','',''),(2116621,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 15:35:11','',''),(2116642,'1','142','798',342,'Retail Sale Id 1258226',4500.16,0.00,0.00,0.00,439.04,'2021-12-01 15:36:30','',''),(2116643,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.86,0.00,'2021-12-01 15:36:30','',''),(2116662,'1','142','798',342,'Retail Sale Id 1258235',3936.00,0.00,0.00,0.00,384.00,'2021-12-01 15:37:54','',''),(2116663,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:37:54','',''),(2116706,'1','142','798',342,'Retail Sale Id 1258252',1968.00,0.00,0.00,0.00,192.00,'2021-12-01 15:40:30','',''),(2116707,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:40:30','',''),(2116734,'1','142','798',342,'Retail Sale Id 1258268',2997.92,0.00,0.00,0.00,292.48,'2021-12-01 15:42:34','',''),(2116735,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-01 15:42:34','',''),(2116796,'1','142','798',342,'Retail Sale Id 1258290',242550.00,0.00,0.00,0.00,14630.00,'2021-12-01 15:45:16','',''),(2116797,'1','142','798',342,'Retail sales',0.00,0.00,0.00,385.00,0.00,'2021-12-01 15:45:16','',''),(2116836,'1','142','798',342,'Retail Sale Id 1258311',2000.80,0.00,0.00,0.00,195.20,'2021-12-01 15:46:55','',''),(2116837,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 15:46:55','',''),(2116856,'1','142','798',342,'Retail Sale Id 1258324',1968.00,0.00,0.00,0.00,192.00,'2021-12-01 15:47:50','',''),(2116857,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:47:50','',''),(2116886,'1','142','798',342,'Retail Sale Id 1258337',8003.20,0.00,0.00,0.00,780.80,'2021-12-01 15:49:04','',''),(2116887,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-01 15:49:04','',''),(2116909,'1','142','798',342,'Retail Sale Id 1258350',2997.92,0.00,0.00,0.00,292.48,'2021-12-01 15:50:09','',''),(2116910,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-01 15:50:09','',''),(2116938,'1','142','798',342,'Retail Sale Id 1258363',4001.60,0.00,0.00,0.00,390.40,'2021-12-01 15:51:14','',''),(2116939,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-01 15:51:14','',''),(2116972,'1','142','798',342,'Retail Sale Id 1258378',2000.80,0.00,0.00,0.00,195.20,'2021-12-01 15:52:26','',''),(2116973,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 15:52:26','',''),(2117016,'1','142','798',342,'Retail Sale Id 1258400',2624.00,0.00,0.00,0.00,256.00,'2021-12-01 15:54:15','',''),(2117017,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 15:54:15','',''),(2117175,'1','142','798',342,'Retail Sale Id 1258476',4100.00,0.00,0.00,0.00,400.00,'2021-12-01 16:00:58','',''),(2117176,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 16:00:58','',''),(2117207,'1','142','798',342,'Retail Sale Id 1258490',3280.00,0.00,0.00,0.00,320.00,'2021-12-01 16:02:50','',''),(2117208,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:02:51','',''),(2117358,'1','142','798',342,'Retail Sale Id 1258554',3936.00,0.00,0.00,0.00,384.00,'2021-12-01 16:08:32','',''),(2117359,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:08:32','',''),(2117360,'1','142','798',342,'Retail Sale Id 1258554',8200.00,0.00,0.00,0.00,800.00,'2021-12-01 16:08:32','',''),(2117361,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:08:32','',''),(2117434,'1','142','799',342,'Retail Sale Id 1258584',1699.04,0.00,0.00,0.00,165.76,'2021-12-01 16:11:41','',''),(2117435,'1','142','799',342,'Retail sales',0.00,0.00,0.00,2.59,0.00,'2021-12-01 16:11:41','',''),(2117527,'1','142','798',342,'Retail Sale Id 1258622',7498.08,0.00,0.00,0.00,731.52,'2021-12-01 16:15:23','',''),(2117528,'1','142','798',342,'Retail sales',0.00,0.00,0.00,11.43,0.00,'2021-12-01 16:15:23','',''),(2117559,'1','142','798',342,'Retail Sale Id 1258641',1968.00,0.00,0.00,0.00,192.00,'2021-12-01 16:16:36','',''),(2117560,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:16:36','',''),(2117595,'1','142','798',342,'Retail Sale Id 1258661',3936.00,0.00,0.00,0.00,384.00,'2021-12-01 16:18:26','',''),(2117596,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:18:26','',''),(2117660,'1','142','798',342,'Retail Sale Id 1258692',3936.00,0.00,0.00,0.00,384.00,'2021-12-01 16:20:50','',''),(2117661,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:20:50','',''),(2117688,'1','142','798',342,'Retail Sale Id 1258708',3503.04,0.00,0.00,0.00,341.76,'2021-12-01 16:21:58','',''),(2117689,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-01 16:21:58','',''),(2117720,'1','142','798',342,'Retail Sale Id 1258727',3280.00,0.00,0.00,0.00,320.00,'2021-12-01 16:23:12','',''),(2117721,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:23:12','',''),(2117764,'1','142','798',342,'Retail Sale Id 1258751',6560.00,0.00,0.00,0.00,640.00,'2021-12-01 16:25:39','',''),(2117765,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 16:25:39','',''),(2117808,'1','142','798',342,'Retail Sale Id 1258788',3936.00,0.00,0.00,0.00,384.00,'2021-12-01 16:27:36','',''),(2117809,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:27:36','',''),(2117856,'1','142','798',342,'Retail Sale Id 1258809',1968.00,0.00,0.00,0.00,192.00,'2021-12-01 16:29:43','',''),(2117857,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:29:43','',''),(2117890,'1','142','798',342,'Retail Sale Id 1258830',2997.92,0.00,0.00,0.00,292.48,'2021-12-01 16:31:38','',''),(2117891,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-01 16:31:38','',''),(2117926,'1','142','798',342,'Retail Sale Id 1258845',4001.60,0.00,0.00,0.00,390.40,'2021-12-01 16:32:57','',''),(2117927,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-01 16:32:57','',''),(2117996,'1','142','798',342,'Retail Sale Id 1258885',31500.00,0.00,0.00,0.00,1900.00,'2021-12-01 16:37:03','',''),(2117997,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 16:37:03','',''),(2118042,'1','142','798',342,'Retail Sale Id 1258910',1968.00,0.00,0.00,0.00,192.00,'2021-12-01 16:38:57','',''),(2118043,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:38:57','',''),(2118118,'1','142','798',342,'Retail Sale Id 1258949',4998.72,0.00,0.00,0.00,487.68,'2021-12-01 16:42:50','',''),(2118119,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-01 16:42:50','',''),(2118162,'1','142','798',342,'Retail Sale Id 1258976',1312.00,0.00,0.00,0.00,128.00,'2021-12-01 16:45:08','',''),(2118163,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 16:45:09','',''),(2118222,'1','142','798',342,'Retail Sale Id 1259007',2997.92,0.00,0.00,0.00,292.48,'2021-12-01 16:48:14','',''),(2118223,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-01 16:48:14','',''),(2118248,'1','142','798',342,'Retail Sale Id 1259022',1502.24,0.00,0.00,0.00,146.56,'2021-12-01 16:49:37','',''),(2118249,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-01 16:49:37','',''),(2118320,'1','142','798',342,'Retail Sale Id 1259055',3936.00,0.00,0.00,0.00,384.00,'2021-12-01 16:52:58','',''),(2118321,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:52:58','',''),(2118361,'1','142','798',342,'Retail Sale Id 1259068',6560.00,0.00,0.00,0.00,640.00,'2021-12-01 16:53:44','',''),(2118362,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 16:53:44','',''),(2118377,'1','142','798',342,'Retail Sale Id 1259078',997.12,0.00,0.00,0.00,97.28,'2021-12-01 16:54:52','',''),(2118378,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 16:54:52','',''),(2118403,'1','142','798',342,'Retail Sale Id 1259093',1502.24,0.00,0.00,0.00,146.56,'2021-12-01 16:55:49','',''),(2118404,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-01 16:55:49','',''),(2118420,'1','142','798',342,'Retail Sale Id 1259101',8200.00,0.00,0.00,0.00,800.00,'2021-12-01 16:56:33','',''),(2118421,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:56:33','',''),(2118436,'1','142','798',342,'Retail Sale Id 1259110',2499.36,0.00,0.00,0.00,243.84,'2021-12-01 16:57:22','',''),(2118437,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-01 16:57:22','',''),(2118450,'1','142','798',342,'Retail Sale Id 1259118',997.12,0.00,0.00,0.00,97.28,'2021-12-01 16:58:05','',''),(2118451,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 16:58:05','',''),(2118474,'1','142','798',342,'Retail Sale Id 1259130',1968.00,0.00,0.00,0.00,192.00,'2021-12-01 16:58:49','',''),(2118475,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:58:49','',''),(2118498,'1','142','798',342,'Retail Sale Id 1259140',8200.00,0.00,0.00,0.00,800.00,'2021-12-01 16:59:48','',''),(2118499,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:59:48','',''),(2118520,'1','142','798',342,'Retail Sale Id 1259153',3280.00,0.00,0.00,0.00,320.00,'2021-12-01 17:00:50','',''),(2118521,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 17:00:50','',''),(2118558,'1','142','798',342,'Retail Sale Id 1259174',1600.64,0.00,0.00,0.00,156.16,'2021-12-01 17:02:41','',''),(2118559,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-01 17:02:41','',''),(2118580,'1','142','798',342,'Retail Sale Id 1259184',3280.00,0.00,0.00,0.00,320.00,'2021-12-01 17:03:48','',''),(2118581,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 17:03:48','',''),(2118606,'1','142','798',342,'Retail Sale Id 1259195',3942.56,0.00,0.00,0.00,384.64,'2021-12-01 17:04:55','',''),(2118607,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 17:04:55','',''),(2118632,'1','142','798',342,'Retail Sale Id 1259202',4592.00,0.00,0.00,0.00,448.00,'2021-12-01 17:06:03','',''),(2118633,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 17:06:03','',''),(2118678,'1','142','798',342,'Retail Sale Id 1259228',4500.16,0.00,0.00,0.00,439.04,'2021-12-01 17:08:22','',''),(2118679,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.86,0.00,'2021-12-01 17:08:22','',''),(2118854,'1','142','798',342,'Retail Sale Id 1259318',1968.00,0.00,0.00,0.00,192.00,'2021-12-01 17:18:35','',''),(2118855,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 17:18:35','',''),(2119047,'1','142','798',342,'Retail Sale Id 1259413',1968.00,0.00,0.00,0.00,192.00,'2021-12-01 17:31:46','',''),(2119048,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 17:31:46','',''),(2119191,'1','142','798',342,'Retail Sale Id 1259488',12792.00,0.00,0.00,0.00,1248.00,'2021-12-01 17:42:28','',''),(2119192,'1','142','798',342,'Retail sales',0.00,0.00,0.00,19.50,0.00,'2021-12-01 17:42:28','',''),(2119349,'1','142','798',342,'Retail Sale Id 1259563',7524.00,0.00,0.00,0.00,420.00,'2021-12-01 17:59:39','',''),(2119350,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-01 17:59:39','',''),(2119373,'1','142','799',342,'Return of Retail Sale Id 1257901',0.00,1968.00,3.00,0.00,-192.00,'2021-12-01 18:03:45','',''),(2119384,'1','142','799',342,'Return of Retail Sale Id 1257907',0.00,2624.00,4.00,0.00,-256.00,'2021-12-01 18:05:23','',''),(2119391,'1','142','799',342,'Return of Retail Sale Id 1258584',0.00,1699.04,2.59,0.00,-165.76,'2021-12-01 18:06:48','',''),(2119408,'1','142','799',342,'Return of Retail Sale Id 1258010',0.00,1968.00,3.00,0.00,-192.00,'2021-12-01 18:08:47','',''),(2119427,'1','142','798',342,'Retail Sale Id 1259607',8200.00,0.00,0.00,0.00,800.00,'2021-12-01 18:11:25','',''),(2119428,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 18:11:25','',''),(2120820,'1','142','798',342,'Retail Sale Id 1260049',3936.00,0.00,0.00,0.00,384.00,'2021-12-02 06:37:46','',''),(2120821,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 06:37:46','',''),(2121542,'1','142','798',342,'Retail Sale Id 1260350',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 07:14:09','',''),(2121543,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 07:14:09','',''),(2121623,'1','142','798',342,'Retail Sale Id 1260391',4001.60,0.00,0.00,0.00,390.40,'2021-12-02 07:18:05','',''),(2121624,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-02 07:18:05','',''),(2121698,'1','142','798',342,'Retail Sale Id 1260419',4998.72,0.00,0.00,0.00,487.68,'2021-12-02 07:21:45','',''),(2121699,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-02 07:21:45','',''),(2121747,'1','142','798',342,'Retail Sale Id 1260449',3949.12,0.00,0.00,0.00,385.28,'2021-12-02 07:24:16','',''),(2121748,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 07:24:16','',''),(2121815,'1','142','798',342,'Retail Sale Id 1260485',3949.12,0.00,0.00,0.00,385.28,'2021-12-02 07:27:36','',''),(2121816,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 07:27:36','',''),(2121847,'1','142','798',342,'Retail Sale Id 1260505',8200.00,0.00,0.00,0.00,800.00,'2021-12-02 07:29:05','',''),(2121848,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:29:05','',''),(2121905,'1','142','798',342,'Retail Sale Id 1260548',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 07:33:15','',''),(2121906,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 07:33:15','',''),(2122367,'1','142','798',342,'Retail Sale Id 1260770',3949.12,0.00,0.00,0.00,385.28,'2021-12-02 07:52:50','',''),(2122368,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 07:52:50','',''),(2122506,'1','142','798',342,'Retail Sale Id 1260836',6500.96,0.00,0.00,0.00,634.24,'2021-12-02 07:58:22','',''),(2122507,'1','142','798',342,'Retail sales',0.00,0.00,0.00,9.91,0.00,'2021-12-02 07:58:22','',''),(2122508,'1','142','798',342,'Retail Sale Id 1260836',8003.20,0.00,0.00,0.00,780.80,'2021-12-02 07:58:22','',''),(2122509,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-02 07:58:22','',''),(2122580,'1','142','798',342,'Retail Sale Id 1260859',997.12,0.00,0.00,0.00,97.28,'2021-12-02 08:00:35','',''),(2122581,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 08:00:35','',''),(2122619,'1','142','798',342,'Retail Sale Id 1260880',3949.12,0.00,0.00,0.00,385.28,'2021-12-02 08:02:52','',''),(2122620,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 08:02:52','',''),(2122833,'1','142','798',342,'Retail Sale Id 1260991',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 08:13:49','',''),(2122834,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 08:13:49','',''),(2122914,'1','142','798',342,'Retail Sale Id 1261035',30723.00,0.00,0.00,0.00,1715.00,'2021-12-02 08:18:33','',''),(2122915,'1','142','798',342,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-02 08:18:33','',''),(2123029,'1','142','798',342,'Retail Sale Id 1261080',3280.00,0.00,0.00,0.00,320.00,'2021-12-02 08:23:41','',''),(2123030,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:23:41','',''),(2123073,'1','142','798',342,'Retail Sale Id 1261115',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 08:25:57','',''),(2123074,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 08:25:57','',''),(2123105,'1','142','798',342,'Retail Sale Id 1261130',1502.24,0.00,0.00,0.00,146.56,'2021-12-02 08:28:00','',''),(2123106,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 08:28:00','',''),(2123107,'1','142','798',342,'Retail Sale Id 1261130',1502.24,0.00,0.00,0.00,146.56,'2021-12-02 08:28:00','',''),(2123108,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 08:28:00','',''),(2123177,'1','142','798',342,'Retail Sale Id 1261167',8200.00,0.00,0.00,0.00,800.00,'2021-12-02 08:32:03','',''),(2123178,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:32:03','',''),(2123393,'1','142','798',342,'Retail Sale Id 1261256',3201.28,0.00,0.00,0.00,312.32,'2021-12-02 08:41:47','',''),(2123394,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.88,0.00,'2021-12-02 08:41:47','',''),(2123437,'1','142','798',342,'Retail Sale Id 1261275',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 08:44:05','',''),(2123438,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 08:44:05','',''),(2123477,'1','142','798',342,'Retail Sale Id 1261298',1699.04,0.00,0.00,0.00,165.76,'2021-12-02 08:46:04','',''),(2123478,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.59,0.00,'2021-12-02 08:46:04','',''),(2123577,'1','142','798',342,'Retail Sale Id 1261346',3949.12,0.00,0.00,0.00,385.28,'2021-12-02 08:52:42','',''),(2123578,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 08:52:42','',''),(2123677,'1','142','798',342,'Retail Sale Id 1261395',2997.92,0.00,0.00,0.00,292.48,'2021-12-02 08:57:57','',''),(2123678,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-02 08:57:57','',''),(2123871,'1','142','798',342,'Retail Sale Id 1261511',3503.04,0.00,0.00,0.00,341.76,'2021-12-02 09:07:43','',''),(2123872,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-02 09:07:43','',''),(2123923,'1','142','798',342,'Retail Sale Id 1261533',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 09:10:16','',''),(2123924,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 09:10:16','',''),(2123925,'1','142','798',342,'Retail Sale Id 1261533',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 09:10:16','',''),(2123926,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 09:10:16','',''),(2123973,'1','142','798',342,'Retail Sale Id 1261555',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 09:12:20','',''),(2123974,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 09:12:20','',''),(2124062,'1','142','798',342,'Retail Sale Id 1261591',18900.00,0.00,0.00,0.00,1140.00,'2021-12-02 09:16:11','',''),(2124063,'1','142','798',342,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-02 09:16:11','',''),(2124172,'1','142','798',342,'Retail Sale Id 1261634',1312.00,0.00,0.00,0.00,128.00,'2021-12-02 09:20:59','',''),(2124173,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 09:20:59','',''),(2124190,'1','142','798',342,'Retail Sale Id 1261644',7216.00,0.00,0.00,0.00,704.00,'2021-12-02 09:22:19','',''),(2124191,'1','142','798',342,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-02 09:22:19','',''),(2124252,'1','142','798',342,'Retail Sale Id 1261677',3280.00,0.00,0.00,0.00,320.00,'2021-12-02 09:25:41','',''),(2124253,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:25:41','',''),(2124346,'1','142','798',342,'Retail Sale Id 1261722',8200.00,0.00,0.00,0.00,800.00,'2021-12-02 09:31:21','',''),(2124347,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:31:21','',''),(2124403,'1','142','798',342,'Retail Sale Id 1261751',7216.00,0.00,0.00,0.00,704.00,'2021-12-02 09:35:03','',''),(2124404,'1','142','798',342,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-02 09:35:03','',''),(2124405,'1','142','798',342,'Retail Sale Id 1261751',8200.00,0.00,0.00,0.00,800.00,'2021-12-02 09:35:03','',''),(2124406,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:35:03','',''),(2124481,'1','142','798',342,'Retail Sale Id 1261792',3949.12,0.00,0.00,0.00,385.28,'2021-12-02 09:41:27','',''),(2124482,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 09:41:27','',''),(2124519,'1','142','798',342,'Retail Sale Id 1261811',1502.24,0.00,0.00,0.00,146.56,'2021-12-02 09:43:18','',''),(2124520,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 09:43:18','',''),(2124647,'1','142','798',342,'Retail Sale Id 1261869',3936.00,0.00,0.00,0.00,384.00,'2021-12-02 09:49:44','',''),(2124648,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:49:44','',''),(2124673,'1','142','798',342,'Retail Sale Id 1261880',5904.00,0.00,0.00,0.00,576.00,'2021-12-02 09:50:59','',''),(2124674,'1','142','798',342,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 09:50:59','',''),(2124685,'1','142','798',342,'Retail Sale Id 1261901',6002.40,0.00,0.00,0.00,585.60,'2021-12-02 09:51:47','',''),(2124686,'1','142','798',342,'Retail sales',0.00,0.00,0.00,9.15,0.00,'2021-12-02 09:51:47','',''),(2124729,'1','142','798',342,'Retail Sale Id 1261923',1948.32,0.00,0.00,0.00,190.08,'2021-12-02 09:53:19','',''),(2124730,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-02 09:53:19','',''),(2124766,'1','142','798',342,'Retail Sale Id 1261944',5904.00,0.00,0.00,0.00,576.00,'2021-12-02 09:55:23','',''),(2124767,'1','142','798',342,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 09:55:23','',''),(2124823,'1','142','798',342,'Retail Sale Id 1261970',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 09:58:02','',''),(2124824,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 09:58:02','',''),(2124861,'1','142','798',342,'Retail Sale Id 1261993',4998.72,0.00,0.00,0.00,487.68,'2021-12-02 10:00:00','',''),(2124862,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-02 10:00:00','',''),(2124939,'1','142','798',342,'Retail Sale Id 1262029',4998.72,0.00,0.00,0.00,487.68,'2021-12-02 10:04:10','',''),(2124940,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-02 10:04:10','',''),(2125013,'1','142','798',342,'Retail Sale Id 1262073',1968.00,0.00,0.00,0.00,192.00,'2021-12-02 10:09:44','',''),(2125014,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:09:44','',''),(2125094,'1','142','798',342,'Retail Sale Id 1262110',1968.00,0.00,0.00,0.00,192.00,'2021-12-02 10:13:45','',''),(2125095,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:13:45','',''),(2125156,'1','142','798',342,'Retail Sale Id 1262143',4001.60,0.00,0.00,0.00,390.40,'2021-12-02 10:17:34','',''),(2125157,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-02 10:17:34','',''),(2125228,'1','142','798',342,'Retail Sale Id 1262180',3280.00,0.00,0.00,0.00,320.00,'2021-12-02 10:21:40','',''),(2125229,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 10:21:40','',''),(2125442,'1','142','798',342,'Retail Sale Id 1262284',1502.24,0.00,0.00,0.00,146.56,'2021-12-02 10:34:07','',''),(2125443,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 10:34:07','',''),(2125490,'1','142','798',342,'Retail Sale Id 1262307',3936.00,0.00,0.00,0.00,384.00,'2021-12-02 10:36:46','',''),(2125491,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 10:36:46','',''),(2125900,'1','142','798',342,'Retail Sale Id 1262510',8200.00,0.00,0.00,0.00,800.00,'2021-12-02 11:03:09','',''),(2125901,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:03:09','',''),(2126024,'1','142','798',342,'Retail Sale Id 1262583',1902.40,0.00,0.00,0.00,185.60,'2021-12-02 11:11:01','',''),(2126025,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-02 11:11:01','',''),(2126170,'1','142','798',342,'Retail Sale Id 1262660',3936.00,0.00,0.00,0.00,384.00,'2021-12-02 11:19:20','',''),(2126171,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:19:20','',''),(2126196,'1','142','798',342,'Retail Sale Id 1262676',8200.00,0.00,0.00,0.00,800.00,'2021-12-02 11:20:34','',''),(2126197,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:20:34','',''),(2126282,'1','142','798',342,'Retail Sale Id 1262717',7872.00,0.00,0.00,0.00,768.00,'2021-12-02 11:26:07','',''),(2126283,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 11:26:07','',''),(2126306,'1','142','798',342,'Retail Sale Id 1262730',8003.20,0.00,0.00,0.00,780.80,'2021-12-02 11:27:33','',''),(2126307,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-02 11:27:33','',''),(2126336,'1','142','798',342,'Retail Sale Id 1262743',1968.00,0.00,0.00,0.00,192.00,'2021-12-02 11:28:39','',''),(2126337,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:28:39','',''),(2126356,'1','142','798',342,'Retail Sale Id 1262755',3949.12,0.00,0.00,0.00,385.28,'2021-12-02 11:29:31','',''),(2126357,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 11:29:31','',''),(2126400,'1','142','798',342,'Retail Sale Id 1262772',2997.92,0.00,0.00,0.00,292.48,'2021-12-02 11:31:17','',''),(2126401,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-02 11:31:17','',''),(2126433,'1','142','798',342,'Retail Sale Id 1262784',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 11:32:45','',''),(2126434,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 11:32:45','',''),(2126532,'1','142','798',342,'Retail Sale Id 1262818',63000.00,0.00,0.00,0.00,3800.00,'2021-12-02 11:36:57','',''),(2126533,'1','142','798',342,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-02 11:36:57','',''),(2126569,'1','142','798',342,'Retail Sale Id 1262833',1312.00,0.00,0.00,0.00,128.00,'2021-12-02 11:39:12','',''),(2126570,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 11:39:12','',''),(2126598,'1','142','798',342,'Retail Sale Id 1262847',1502.24,0.00,0.00,0.00,146.56,'2021-12-02 11:40:30','',''),(2126599,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 11:40:30','',''),(2126631,'1','142','798',342,'Retail Sale Id 1262863',31500.00,0.00,0.00,0.00,1900.00,'2021-12-02 11:42:54','',''),(2126632,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 11:42:54','',''),(2126647,'1','142','798',342,'Retail Sale Id 1262870',3280.00,0.00,0.00,0.00,320.00,'2021-12-02 11:44:02','',''),(2126648,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 11:44:02','',''),(2126665,'1','142','798',342,'Retail Sale Id 1262878',1502.24,0.00,0.00,0.00,146.56,'2021-12-02 11:45:46','',''),(2126666,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 11:45:46','',''),(2126707,'1','142','798',342,'Retail Sale Id 1262901',3936.00,0.00,0.00,0.00,384.00,'2021-12-02 11:49:32','',''),(2126708,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:49:32','',''),(2126735,'1','142','798',342,'Retail Sale Id 1262916',2624.00,0.00,0.00,0.00,256.00,'2021-12-02 11:52:03','',''),(2126736,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 11:52:03','',''),(2126767,'1','142','798',342,'Retail Sale Id 1262935',8200.00,0.00,0.00,0.00,800.00,'2021-12-02 11:54:28','',''),(2126768,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:54:28','',''),(2126801,'1','142','798',342,'Retail Sale Id 1262953',31500.00,0.00,0.00,0.00,1900.00,'2021-12-02 11:56:20','',''),(2126802,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 11:56:20','',''),(2126817,'1','142','798',342,'Retail Sale Id 1262963',1502.24,0.00,0.00,0.00,146.56,'2021-12-02 11:57:54','',''),(2126818,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 11:57:54','',''),(2126837,'1','142','798',342,'Retail Sale Id 1262971',4998.72,0.00,0.00,0.00,487.68,'2021-12-02 11:59:31','',''),(2126838,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-02 11:59:31','',''),(2126942,'1','142','798',342,'Retail Sale Id 1263024',1797.44,0.00,0.00,0.00,175.36,'2021-12-02 12:09:16','',''),(2126943,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.74,0.00,'2021-12-02 12:09:16','',''),(2126964,'1','142','798',342,'Retail Sale Id 1263035',1797.44,0.00,0.00,0.00,175.36,'2021-12-02 12:10:45','',''),(2126965,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.74,0.00,'2021-12-02 12:10:45','',''),(2126978,'1','142','798',342,'Retail Sale Id 1263042',8200.00,0.00,0.00,0.00,800.00,'2021-12-02 12:12:14','',''),(2126979,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:12:14','',''),(2127005,'1','142','798',342,'Retail Sale Id 1263055',3280.00,0.00,0.00,0.00,320.00,'2021-12-02 12:14:46','',''),(2127006,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 12:14:46','',''),(2127056,'1','142','798',342,'Retail Sale Id 1263082',2499.36,0.00,0.00,0.00,243.84,'2021-12-02 12:20:28','',''),(2127057,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-02 12:20:28','',''),(2127086,'1','142','798',342,'Retail Sale Id 1263097',8200.00,0.00,0.00,0.00,800.00,'2021-12-02 12:22:12','',''),(2127087,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:22:12','',''),(2127192,'1','142','798',342,'Retail Sale Id 1263150',8200.00,0.00,0.00,0.00,800.00,'2021-12-02 12:29:22','',''),(2127193,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:29:22','',''),(2127212,'1','142','798',342,'Retail Sale Id 1263179',1968.00,0.00,0.00,0.00,192.00,'2021-12-02 12:31:03','',''),(2127213,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 12:31:03','',''),(2127238,'1','142','798',342,'Retail Sale Id 1263193',701.92,0.00,0.00,0.00,68.48,'2021-12-02 12:32:43','',''),(2127239,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.07,0.00,'2021-12-02 12:32:43','',''),(2127330,'1','142','798',342,'Retail Sale Id 1263244',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 12:39:34','',''),(2127331,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 12:39:34','',''),(2127343,'1','142','798',342,'Retail Sale Id 1263251',1502.24,0.00,0.00,0.00,146.56,'2021-12-02 12:40:45','',''),(2127344,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 12:40:45','',''),(2127365,'1','142','798',342,'Retail Sale Id 1263259',2624.00,0.00,0.00,0.00,256.00,'2021-12-02 12:42:59','',''),(2127366,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 12:42:59','',''),(2127378,'1','142','798',342,'Retail Sale Id 1263265',8200.00,0.00,0.00,0.00,800.00,'2021-12-02 12:44:28','',''),(2127379,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:44:28','',''),(2127425,'1','142','798',342,'Retail Sale Id 1263282',1968.00,0.00,0.00,0.00,192.00,'2021-12-02 12:47:31','',''),(2127426,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 12:47:31','',''),(2127469,'1','142','798',342,'Retail Sale Id 1263299',1502.24,0.00,0.00,0.00,146.56,'2021-12-02 12:50:02','',''),(2127470,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 12:50:02','',''),(2127471,'1','142','798',342,'Retail Sale Id 1263299',1968.00,0.00,0.00,0.00,192.00,'2021-12-02 12:50:02','',''),(2127472,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 12:50:02','',''),(2127504,'1','142','798',342,'Retail Sale Id 1263315',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 12:52:52','',''),(2127505,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 12:52:52','',''),(2127518,'1','142','798',342,'Retail Sale Id 1263323',10168.00,0.00,0.00,0.00,992.00,'2021-12-02 12:54:22','',''),(2127519,'1','142','798',342,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-02 12:54:22','',''),(2127556,'1','142','798',342,'Retail Sale Id 1263338',1318.56,0.00,0.00,0.00,128.64,'2021-12-02 12:57:55','',''),(2127557,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-02 12:57:55','',''),(2127628,'1','142','798',342,'Retail Sale Id 1263378',3936.00,0.00,0.00,0.00,384.00,'2021-12-02 13:01:51','',''),(2127629,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 13:01:51','',''),(2127684,'1','142','798',342,'Retail Sale Id 1263406',1968.00,0.00,0.00,0.00,192.00,'2021-12-02 13:06:41','',''),(2127685,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 13:06:41','',''),(2127712,'1','142','798',342,'Retail Sale Id 1263420',1502.24,0.00,0.00,0.00,146.56,'2021-12-02 13:08:34','',''),(2127713,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 13:08:34','',''),(2127730,'1','142','798',342,'Retail Sale Id 1263429',1968.00,0.00,0.00,0.00,192.00,'2021-12-02 13:10:30','',''),(2127731,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 13:10:30','',''),(2127796,'1','142','798',342,'Retail Sale Id 1263458',3280.00,0.00,0.00,0.00,320.00,'2021-12-02 13:14:24','',''),(2127797,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 13:14:24','',''),(2127850,'1','142','798',342,'Retail Sale Id 1263478',1968.00,0.00,0.00,0.00,192.00,'2021-12-02 13:16:22','',''),(2127851,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 13:16:22','',''),(2127879,'1','142','798',342,'Retail Sale Id 1263487',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 13:18:06','',''),(2127880,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 13:18:06','',''),(2127915,'1','142','798',342,'Retail Sale Id 1263505',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 13:21:06','',''),(2127916,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 13:21:06','',''),(2128009,'1','142','798',342,'Retail Sale Id 1263540',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 13:27:09','',''),(2128010,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 13:27:09','',''),(2128011,'1','142','798',342,'Retail Sale Id 1263540',3280.00,0.00,0.00,0.00,320.00,'2021-12-02 13:27:09','',''),(2128012,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 13:27:09','',''),(2128132,'1','142','798',342,'Retail Sale Id 1263593',997.12,0.00,0.00,0.00,97.28,'2021-12-02 13:36:41','',''),(2128133,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 13:36:41','',''),(2128186,'1','142','798',342,'Retail Sale Id 1263610',997.12,0.00,0.00,0.00,97.28,'2021-12-02 13:39:36','',''),(2128187,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 13:39:36','',''),(2128232,'1','142','798',342,'Retail Sale Id 1263632',1502.24,0.00,0.00,0.00,146.56,'2021-12-02 13:43:11','',''),(2128233,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 13:43:11','',''),(2128290,'1','142','798',342,'Retail Sale Id 1263659',3949.12,0.00,0.00,0.00,385.28,'2021-12-02 13:46:36','',''),(2128291,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 13:46:36','',''),(2128364,'1','142','798',342,'Retail Sale Id 1263697',31500.00,0.00,0.00,0.00,1900.00,'2021-12-02 13:50:10','',''),(2128365,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 13:50:10','',''),(2128413,'1','142','798',342,'Retail Sale Id 1263714',3936.00,0.00,0.00,0.00,384.00,'2021-12-02 13:53:31','',''),(2128414,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 13:53:31','',''),(2128440,'1','142','798',342,'Retail Sale Id 1263733',2997.92,0.00,0.00,0.00,292.48,'2021-12-02 13:54:50','',''),(2128441,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-02 13:54:50','',''),(2128491,'1','142','798',342,'Retail Sale Id 1263749',8200.00,0.00,0.00,0.00,800.00,'2021-12-02 13:56:24','',''),(2128492,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:56:24','',''),(2128560,'1','142','798',342,'Retail Sale Id 1263780',997.12,0.00,0.00,0.00,97.28,'2021-12-02 14:01:04','',''),(2128561,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 14:01:04','',''),(2128630,'1','142','798',342,'Retail Sale Id 1263813',3280.00,0.00,0.00,0.00,320.00,'2021-12-02 14:05:23','',''),(2128631,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 14:05:23','',''),(2128658,'1','142','798',342,'Retail Sale Id 1263830',3280.00,0.00,0.00,0.00,320.00,'2021-12-02 14:07:10','',''),(2128659,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 14:07:10','',''),(2128686,'1','142','798',342,'Retail Sale Id 1263843',3280.00,0.00,0.00,0.00,320.00,'2021-12-02 14:09:05','',''),(2128687,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 14:09:05','',''),(2128749,'1','142','798',342,'Retail Sale Id 1263863',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 14:12:10','',''),(2128750,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 14:12:10','',''),(2128764,'1','142','798',342,'Retail Sale Id 1263870',656.00,0.00,0.00,0.00,64.00,'2021-12-02 14:13:33','',''),(2128765,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-02 14:13:33','',''),(2128788,'1','142','798',342,'Retail Sale Id 1263882',997.12,0.00,0.00,0.00,97.28,'2021-12-02 14:15:36','',''),(2128789,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 14:15:36','',''),(2128832,'1','142','798',342,'Retail Sale Id 1263906',3280.00,0.00,0.00,0.00,320.00,'2021-12-02 14:17:29','',''),(2128833,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 14:17:29','',''),(2128860,'1','142','798',342,'Retail Sale Id 1263920',2997.92,0.00,0.00,0.00,292.48,'2021-12-02 14:18:54','',''),(2128861,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-02 14:18:55','',''),(2128893,'1','142','798',342,'Retail Sale Id 1263935',1948.32,0.00,0.00,0.00,190.08,'2021-12-02 14:20:22','',''),(2128894,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-02 14:20:22','',''),(2128924,'1','142','798',342,'Retail Sale Id 1263951',8200.00,0.00,0.00,0.00,800.00,'2021-12-02 14:22:04','',''),(2128925,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:22:04','',''),(2128957,'1','142','798',342,'Retail Sale Id 1263962',3503.04,0.00,0.00,0.00,341.76,'2021-12-02 14:23:37','',''),(2128958,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-02 14:23:37','',''),(2129003,'1','142','798',342,'Retail Sale Id 1263976',997.12,0.00,0.00,0.00,97.28,'2021-12-02 14:25:14','',''),(2129004,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 14:25:14','',''),(2129005,'1','142','798',342,'Retail Sale Id 1263976',997.12,0.00,0.00,0.00,97.28,'2021-12-02 14:25:14','',''),(2129006,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 14:25:14','',''),(2129075,'1','142','798',342,'Retail Sale Id 1263999',1502.24,0.00,0.00,0.00,146.56,'2021-12-02 14:27:07','',''),(2129076,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 14:27:07','',''),(2129331,'1','142','798',342,'Retail Sale Id 1264098',2296.00,0.00,0.00,0.00,224.00,'2021-12-02 14:39:02','',''),(2129332,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-02 14:39:02','',''),(2129333,'1','142','798',342,'Retail Sale Id 1264098',2296.00,0.00,0.00,0.00,224.00,'2021-12-02 14:39:02','',''),(2129334,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-02 14:39:02','',''),(2129431,'1','142','798',342,'Retail Sale Id 1264136',3936.00,0.00,0.00,0.00,384.00,'2021-12-02 14:42:47','',''),(2129432,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:42:47','',''),(2129455,'1','142','798',342,'Retail Sale Id 1264147',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 14:44:13','',''),(2129456,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 14:44:13','',''),(2129473,'1','142','798',342,'Retail Sale Id 1264156',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 14:45:49','',''),(2129474,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 14:45:49','',''),(2129521,'1','142','798',342,'Retail Sale Id 1264184',712272.00,0.00,0.00,0.00,39760.00,'2021-12-02 14:48:32','',''),(2129522,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1136.00,0.00,'2021-12-02 14:48:32','',''),(2129587,'1','142','798',342,'Retail Sale Id 1264213',3280.00,0.00,0.00,0.00,320.00,'2021-12-02 14:52:25','',''),(2129588,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 14:52:25','',''),(2129616,'1','142','798',342,'Retail Sale Id 1264232',8200.00,0.00,0.00,0.00,800.00,'2021-12-02 14:54:25','',''),(2129617,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:54:25','',''),(2129896,'1','142','798',342,'Retail Sale Id 1264374',5904.00,0.00,0.00,0.00,576.00,'2021-12-02 15:12:56','',''),(2129897,'1','142','798',342,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 15:12:56','',''),(2129932,'1','142','798',342,'Retail Sale Id 1264394',2997.92,0.00,0.00,0.00,292.48,'2021-12-02 15:14:30','',''),(2129933,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-02 15:14:30','',''),(2129978,'1','142','798',342,'Retail Sale Id 1264419',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 15:16:57','',''),(2129979,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 15:16:57','',''),(2130006,'1','142','798',342,'Retail Sale Id 1264432',997.12,0.00,0.00,0.00,97.28,'2021-12-02 15:18:05','',''),(2130007,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 15:18:05','',''),(2130032,'1','142','798',342,'Retail Sale Id 1264446',3949.12,0.00,0.00,0.00,385.28,'2021-12-02 15:19:58','',''),(2130033,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 15:19:58','',''),(2130058,'1','142','798',342,'Retail Sale Id 1264459',6232.00,0.00,0.00,0.00,608.00,'2021-12-02 15:21:29','',''),(2130059,'1','142','798',342,'Retail sales',0.00,0.00,0.00,9.50,0.00,'2021-12-02 15:21:29','',''),(2130092,'1','142','798',342,'Retail Sale Id 1264478',6560.00,0.00,0.00,0.00,640.00,'2021-12-02 15:23:30','',''),(2130093,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 15:23:30','',''),(2130156,'1','142','798',342,'Retail Sale Id 1264505',5248.00,0.00,0.00,0.00,512.00,'2021-12-02 15:25:52','',''),(2130157,'1','142','798',342,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-02 15:25:52','',''),(2130176,'1','142','798',342,'Retail Sale Id 1264516',1948.32,0.00,0.00,0.00,190.08,'2021-12-02 15:26:55','',''),(2130177,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-02 15:26:55','',''),(2130211,'1','142','798',342,'Retail Sale Id 1264533',1948.32,0.00,0.00,0.00,190.08,'2021-12-02 15:28:10','',''),(2130212,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-02 15:28:10','',''),(2130235,'1','142','798',342,'Retail Sale Id 1264544',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 15:29:06','',''),(2130236,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 15:29:06','',''),(2130261,'1','142','798',342,'Retail Sale Id 1264554',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 15:30:10','',''),(2130262,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 15:30:10','',''),(2130281,'1','142','798',342,'Retail Sale Id 1264565',3280.00,0.00,0.00,0.00,320.00,'2021-12-02 15:31:06','',''),(2130282,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:31:06','',''),(2130299,'1','142','798',342,'Retail Sale Id 1264573',997.12,0.00,0.00,0.00,97.28,'2021-12-02 15:31:57','',''),(2130300,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 15:31:57','',''),(2130311,'1','142','798',342,'Retail Sale Id 1264580',3280.00,0.00,0.00,0.00,320.00,'2021-12-02 15:32:45','',''),(2130312,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:32:45','',''),(2130356,'1','142','798',342,'Retail Sale Id 1264601',4801.92,0.00,0.00,0.00,468.48,'2021-12-02 15:34:34','',''),(2130357,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.32,0.00,'2021-12-02 15:34:34','',''),(2130404,'1','142','798',342,'Retail Sale Id 1264621',7872.00,0.00,0.00,0.00,768.00,'2021-12-02 15:36:37','',''),(2130405,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 15:36:37','',''),(2130452,'1','142','798',342,'Retail Sale Id 1264646',8003.20,0.00,0.00,0.00,780.80,'2021-12-02 15:39:11','',''),(2130453,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-02 15:39:11','',''),(2130490,'1','142','798',342,'Retail Sale Id 1264661',3949.12,0.00,0.00,0.00,385.28,'2021-12-02 15:41:02','',''),(2130491,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 15:41:02','',''),(2130536,'1','142','798',342,'Retail Sale Id 1264693',1502.24,0.00,0.00,0.00,146.56,'2021-12-02 15:43:00','',''),(2130537,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 15:43:00','',''),(2130584,'1','142','798',342,'Retail Sale Id 1264721',6225.44,0.00,0.00,0.00,607.36,'2021-12-02 15:45:00','',''),(2130585,'1','142','798',342,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-02 15:45:00','',''),(2130610,'1','142','798',342,'Retail Sale Id 1264738',5497.28,0.00,0.00,0.00,536.32,'2021-12-02 15:46:13','',''),(2130611,'1','142','798',342,'Retail sales',0.00,0.00,0.00,8.38,0.00,'2021-12-02 15:46:13','',''),(2130638,'1','142','798',342,'Retail Sale Id 1264751',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 15:47:35','',''),(2130639,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 15:47:35','',''),(2130704,'1','142','798',342,'Retail Sale Id 1264789',1968.00,0.00,0.00,0.00,192.00,'2021-12-02 15:50:59','',''),(2130705,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:50:59','',''),(2130862,'1','142','798',342,'Retail Sale Id 1264870',2624.00,0.00,0.00,0.00,256.00,'2021-12-02 15:56:55','',''),(2130863,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 15:56:55','',''),(2130916,'1','142','798',342,'Retail Sale Id 1264897',3037.28,0.00,0.00,0.00,296.32,'2021-12-02 15:59:47','',''),(2130917,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.63,0.00,'2021-12-02 15:59:47','',''),(2130954,'1','142','798',342,'Retail Sale Id 1264919',898.72,0.00,0.00,0.00,87.68,'2021-12-02 16:01:47','',''),(2130955,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.37,0.00,'2021-12-02 16:01:47','',''),(2131108,'1','142','798',342,'Retail Sale Id 1264983',3798.24,0.00,0.00,0.00,370.56,'2021-12-02 16:07:53','',''),(2131109,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.79,0.00,'2021-12-02 16:07:53','',''),(2131144,'1','142','798',342,'Retail Sale Id 1264996',3936.00,0.00,0.00,0.00,384.00,'2021-12-02 16:09:00','',''),(2131145,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:09:00','',''),(2131200,'1','142','798',342,'Retail Sale Id 1265027',1968.00,0.00,0.00,0.00,192.00,'2021-12-02 16:12:02','',''),(2131201,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:12:02','',''),(2131247,'1','142','798',342,'Retail Sale Id 1265054',3936.00,0.00,0.00,0.00,384.00,'2021-12-02 16:14:18','',''),(2131248,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:14:18','',''),(2131341,'1','142','798',342,'Retail Sale Id 1265100',3280.00,0.00,0.00,0.00,320.00,'2021-12-02 16:18:53','',''),(2131342,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:18:53','',''),(2131369,'1','142','798',342,'Retail Sale Id 1265116',1968.00,0.00,0.00,0.00,192.00,'2021-12-02 16:20:42','',''),(2131370,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:20:42','',''),(2131450,'1','142','798',342,'Retail Sale Id 1265154',1948.32,0.00,0.00,0.00,190.08,'2021-12-02 16:24:41','',''),(2131451,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-02 16:24:41','',''),(2131504,'1','142','798',342,'Retail Sale Id 1265182',1699.04,0.00,0.00,0.00,165.76,'2021-12-02 16:27:19','',''),(2131505,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.59,0.00,'2021-12-02 16:27:19','',''),(2131532,'1','142','798',342,'Retail Sale Id 1265200',2702.72,0.00,0.00,0.00,263.68,'2021-12-02 16:28:37','',''),(2131533,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.12,0.00,'2021-12-02 16:28:37','',''),(2131626,'1','142','798',342,'Retail Sale Id 1265229',8200.00,0.00,0.00,0.00,800.00,'2021-12-02 16:30:26','',''),(2131627,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:30:26','',''),(2131660,'1','142','798',342,'Retail Sale Id 1265245',8200.00,0.00,0.00,0.00,800.00,'2021-12-02 16:31:46','',''),(2131661,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:31:46','',''),(2131706,'1','142','798',342,'Retail Sale Id 1265260',7216.00,0.00,0.00,0.00,704.00,'2021-12-02 16:34:15','',''),(2131707,'1','142','798',342,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-02 16:34:15','',''),(2131764,'1','142','798',342,'Retail Sale Id 1265307',32800.00,0.00,0.00,0.00,3200.00,'2021-12-02 16:38:05','',''),(2131765,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 16:38:05','',''),(2131802,'1','142','798',342,'Retail Sale Id 1265319',701.92,0.00,0.00,0.00,68.48,'2021-12-02 16:40:19','',''),(2131803,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.07,0.00,'2021-12-02 16:40:19','',''),(2131845,'1','142','798',342,'Retail Sale Id 1265342',1502.24,0.00,0.00,0.00,146.56,'2021-12-02 16:42:10','',''),(2131846,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 16:42:10','',''),(2131889,'1','142','798',342,'Retail Sale Id 1265361',8003.20,0.00,0.00,0.00,780.80,'2021-12-02 16:44:05','',''),(2131890,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-02 16:44:05','',''),(2131930,'1','142','798',342,'Retail Sale Id 1265381',1502.24,0.00,0.00,0.00,146.56,'2021-12-02 16:45:28','',''),(2131931,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 16:45:28','',''),(2131962,'1','142','798',342,'Retail Sale Id 1265401',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 16:47:05','',''),(2131963,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 16:47:05','',''),(2131990,'1','142','798',342,'Retail Sale Id 1265415',997.12,0.00,0.00,0.00,97.28,'2021-12-02 16:48:38','',''),(2131991,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 16:48:39','',''),(2132011,'1','142','798',342,'Retail Sale Id 1265432',3280.00,0.00,0.00,0.00,320.00,'2021-12-02 16:50:36','',''),(2132013,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:50:36','',''),(2132068,'1','142','798',342,'Retail Sale Id 1265459',3936.00,0.00,0.00,0.00,384.00,'2021-12-02 16:53:46','',''),(2132069,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:53:46','',''),(2132112,'1','142','798',342,'Retail Sale Id 1265480',1968.00,0.00,0.00,0.00,192.00,'2021-12-02 16:56:41','',''),(2132113,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:56:41','',''),(2132136,'1','142','798',342,'Retail Sale Id 1265493',8003.20,0.00,0.00,0.00,780.80,'2021-12-02 16:58:14','',''),(2132137,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-02 16:58:14','',''),(2132195,'1','142','798',342,'Retail Sale Id 1265520',2997.92,0.00,0.00,0.00,292.48,'2021-12-02 17:01:47','',''),(2132196,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-02 17:01:47','',''),(2132229,'1','142','798',342,'Retail Sale Id 1265531',2000.80,0.00,0.00,0.00,195.20,'2021-12-02 17:03:45','',''),(2132230,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 17:03:45','',''),(2132261,'1','142','798',342,'Retail Sale Id 1265548',1968.00,0.00,0.00,0.00,192.00,'2021-12-02 17:06:02','',''),(2132262,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 17:06:02','',''),(2132329,'1','142','798',342,'Retail Sale Id 1265582',1502.24,0.00,0.00,0.00,146.56,'2021-12-02 17:10:40','',''),(2132330,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 17:10:40','',''),(2132348,'1','142','798',342,'Retail Sale Id 1265591',6999.52,0.00,0.00,0.00,682.88,'2021-12-02 17:11:51','',''),(2132349,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.67,0.00,'2021-12-02 17:11:51','',''),(2132391,'1','142','798',342,'Retail Sale Id 1265619',8200.00,0.00,0.00,0.00,800.00,'2021-12-02 17:14:37','',''),(2132392,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 17:14:37','',''),(2132458,'1','142','798',342,'Retail Sale Id 1265638',3949.12,0.00,0.00,0.00,385.28,'2021-12-02 17:17:40','',''),(2132459,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-02 17:17:40','',''),(2132643,'1','142','798',342,'Retail Sale Id 1265720',997.12,0.00,0.00,0.00,97.28,'2021-12-02 17:30:55','',''),(2132644,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 17:30:55','',''),(2132645,'1','142','798',342,'Retail Sale Id 1265720',1968.00,0.00,0.00,0.00,192.00,'2021-12-02 17:30:55','',''),(2132646,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 17:30:55','',''),(2132647,'1','142','798',342,'Retail Sale Id 1265720',1968.00,0.00,0.00,0.00,192.00,'2021-12-02 17:30:55','',''),(2132648,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 17:30:55','',''),(2132695,'1','142','798',342,'Retail Sale Id 1265745',22435.20,0.00,0.00,0.00,2188.80,'2021-12-02 17:35:25','',''),(2132696,'1','142','798',342,'Retail sales',0.00,0.00,0.00,34.20,0.00,'2021-12-02 17:35:25','',''),(2137613,'1','142','798',342,'Retail Sale Id 1267813',153615.00,0.00,0.00,0.00,8575.00,'2021-12-03 09:30:09','',''),(2137614,'1','142','798',342,'Retail sales',0.00,0.00,0.00,245.00,0.00,'2021-12-03 09:30:09','',''),(2137641,'1','142','798',342,'Retail Sale Id 1267824',31500.00,0.00,0.00,0.00,1900.00,'2021-12-03 09:31:34','',''),(2137642,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 09:31:34','',''),(2137663,'1','142','798',342,'Retail Sale Id 1267838',31500.00,0.00,0.00,0.00,1900.00,'2021-12-03 09:33:12','',''),(2137664,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 09:33:12','',''),(2137715,'1','142','798',342,'Retail Sale Id 1267866',3936.00,0.00,0.00,0.00,384.00,'2021-12-03 09:35:55','',''),(2137716,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 09:35:55','',''),(2137906,'1','142','798',342,'Retail Sale Id 1267966',32800.00,0.00,0.00,0.00,3200.00,'2021-12-03 09:47:46','',''),(2137907,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 09:47:46','',''),(2137922,'1','142','798',342,'Retail Sale Id 1267975',2997.92,0.00,0.00,0.00,292.48,'2021-12-03 09:49:10','',''),(2137923,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 09:49:10','',''),(2137956,'1','142','798',342,'Retail Sale Id 1267988',2000.80,0.00,0.00,0.00,195.20,'2021-12-03 09:50:48','',''),(2137957,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 09:50:48','',''),(2137996,'1','142','798',342,'Retail Sale Id 1268009',3280.00,0.00,0.00,0.00,320.00,'2021-12-03 09:53:19','',''),(2137997,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 09:53:19','',''),(2138104,'1','142','798',342,'Retail Sale Id 1268061',2197.60,0.00,0.00,0.00,214.40,'2021-12-03 10:00:04','',''),(2138105,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.35,0.00,'2021-12-03 10:00:04','',''),(2138253,'1','142','798',342,'Retail Sale Id 1268136',3280.00,0.00,0.00,0.00,320.00,'2021-12-03 10:08:13','',''),(2138254,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 10:08:13','',''),(2138288,'1','142','798',342,'Retail Sale Id 1268155',8200.00,0.00,0.00,0.00,800.00,'2021-12-03 10:10:10','',''),(2138289,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:10:10','',''),(2138393,'1','142','798',342,'Retail Sale Id 1268212',3936.00,0.00,0.00,0.00,384.00,'2021-12-03 10:16:20','',''),(2138394,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 10:16:20','',''),(2138570,'1','142','798',342,'Retail Sale Id 1268297',63000.00,0.00,0.00,0.00,3800.00,'2021-12-03 10:26:38','',''),(2138571,'1','142','798',342,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-03 10:26:38','',''),(2138600,'1','142','798',342,'Retail Sale Id 1268307',997.12,0.00,0.00,0.00,97.28,'2021-12-03 10:28:08','',''),(2138601,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 10:28:08','',''),(2138643,'1','142','798',342,'Retail Sale Id 1268333',3936.00,0.00,0.00,0.00,384.00,'2021-12-03 10:30:48','',''),(2138644,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 10:30:48','',''),(2138705,'1','142','798',342,'Retail Sale Id 1268361',1318.56,0.00,0.00,0.00,128.64,'2021-12-03 10:35:29','',''),(2138706,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-03 10:35:29','',''),(2138751,'1','142','798',342,'Retail Sale Id 1268377',1968.00,0.00,0.00,0.00,192.00,'2021-12-03 10:37:10','',''),(2138752,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 10:37:10','',''),(2138779,'1','142','798',342,'Retail Sale Id 1268394',997.12,0.00,0.00,0.00,97.28,'2021-12-03 10:39:00','',''),(2138780,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 10:39:00','',''),(2138885,'1','142','798',342,'Retail Sale Id 1268455',2499.36,0.00,0.00,0.00,243.84,'2021-12-03 10:47:29','',''),(2138886,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-03 10:47:29','',''),(2138909,'1','142','798',342,'Retail Sale Id 1268468',14104.00,0.00,0.00,0.00,1376.00,'2021-12-03 10:49:16','',''),(2138910,'1','142','798',342,'Retail sales',0.00,0.00,0.00,21.50,0.00,'2021-12-03 10:49:16','',''),(2138937,'1','142','798',342,'Retail Sale Id 1268480',3280.00,0.00,0.00,0.00,320.00,'2021-12-03 10:51:14','',''),(2138938,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 10:51:14','',''),(2138967,'1','142','798',342,'Retail Sale Id 1268497',3936.00,0.00,0.00,0.00,384.00,'2021-12-03 10:53:24','',''),(2138968,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 10:53:24','',''),(2138985,'1','142','798',342,'Retail Sale Id 1268505',3280.00,0.00,0.00,0.00,320.00,'2021-12-03 10:55:15','',''),(2138986,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 10:55:15','',''),(2139007,'1','142','798',342,'Retail Sale Id 1268516',3280.00,0.00,0.00,0.00,320.00,'2021-12-03 10:57:37','',''),(2139008,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 10:57:37','',''),(2139038,'1','142','798',342,'Retail Sale Id 1268533',1797.44,0.00,0.00,0.00,175.36,'2021-12-03 10:59:35','',''),(2139039,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.74,0.00,'2021-12-03 10:59:35','',''),(2139241,'1','142','798',342,'Retail Sale Id 1268636',1948.32,0.00,0.00,0.00,190.08,'2021-12-03 11:14:55','',''),(2139242,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-03 11:14:55','',''),(2139318,'1','142','798',342,'Retail Sale Id 1268673',3936.00,0.00,0.00,0.00,384.00,'2021-12-03 11:18:42','',''),(2139319,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 11:18:42','',''),(2139421,'1','142','798',342,'Retail Sale Id 1268729',25200.00,0.00,0.00,0.00,1520.00,'2021-12-03 11:28:44','',''),(2139422,'1','142','798',342,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-03 11:28:44','',''),(2139461,'1','142','798',342,'Retail Sale Id 1268753',2997.92,0.00,0.00,0.00,292.48,'2021-12-03 11:31:45','',''),(2139462,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 11:31:45','',''),(2139504,'1','142','798',342,'Retail Sale Id 1268777',3503.04,0.00,0.00,0.00,341.76,'2021-12-03 11:35:19','',''),(2139505,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-03 11:35:19','',''),(2139530,'1','142','798',342,'Retail Sale Id 1268788',3280.00,0.00,0.00,0.00,320.00,'2021-12-03 11:37:41','',''),(2139531,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 11:37:41','',''),(2139554,'1','142','798',342,'Retail Sale Id 1268806',2997.92,0.00,0.00,0.00,292.48,'2021-12-03 11:39:51','',''),(2139555,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 11:39:51','',''),(2139598,'1','142','798',342,'Retail Sale Id 1268832',997.12,0.00,0.00,0.00,97.28,'2021-12-03 11:42:52','',''),(2139599,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 11:42:52','',''),(2139652,'1','142','798',342,'Retail Sale Id 1268856',1640.00,0.00,0.00,0.00,160.00,'2021-12-03 11:46:51','',''),(2139653,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-03 11:46:51','',''),(2139694,'1','142','798',342,'Retail Sale Id 1268886',6999.52,0.00,0.00,0.00,682.88,'2021-12-03 11:49:36','',''),(2139695,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.67,0.00,'2021-12-03 11:49:36','',''),(2139711,'1','142','798',342,'Retail Sale Id 1268900',3936.00,0.00,0.00,0.00,384.00,'2021-12-03 11:51:30','',''),(2139712,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 11:51:30','',''),(2139751,'1','142','798',342,'Retail Sale Id 1268920',3936.00,0.00,0.00,0.00,384.00,'2021-12-03 11:54:53','',''),(2139752,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 11:54:53','',''),(2139801,'1','142','798',342,'Retail Sale Id 1268941',2997.92,0.00,0.00,0.00,292.48,'2021-12-03 11:58:16','',''),(2139804,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 11:58:16','',''),(2139831,'1','142','798',342,'Retail Sale Id 1268955',1968.00,0.00,0.00,0.00,192.00,'2021-12-03 12:00:40','',''),(2139832,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 12:00:40','',''),(2139881,'1','142','798',342,'Retail Sale Id 1268985',656.00,0.00,0.00,0.00,64.00,'2021-12-03 12:03:42','',''),(2139882,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 12:03:42','',''),(2139937,'1','142','798',342,'Retail Sale Id 1269035',1502.24,0.00,0.00,0.00,146.56,'2021-12-03 12:06:50','',''),(2139938,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-03 12:06:50','',''),(2140046,'1','142','798',342,'Retail Sale Id 1269089',1968.00,0.00,0.00,0.00,192.00,'2021-12-03 12:16:38','',''),(2140047,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 12:16:38','',''),(2140048,'1','142','798',342,'Retail Sale Id 1269089',1968.00,0.00,0.00,0.00,192.00,'2021-12-03 12:16:38','',''),(2140049,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 12:16:38','',''),(2140170,'1','142','798',342,'Retail Sale Id 1269156',4001.60,0.00,0.00,0.00,390.40,'2021-12-03 12:28:02','',''),(2140171,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 12:28:02','',''),(2140196,'1','142','798',342,'Retail Sale Id 1269173',6002.40,0.00,0.00,0.00,585.60,'2021-12-03 12:30:10','',''),(2140197,'1','142','798',342,'Retail sales',0.00,0.00,0.00,9.15,0.00,'2021-12-03 12:30:10','',''),(2140222,'1','142','798',342,'Retail Sale Id 1269188',3280.00,0.00,0.00,0.00,320.00,'2021-12-03 12:32:05','',''),(2140223,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 12:32:05','',''),(2140282,'1','142','798',342,'Retail Sale Id 1269226',6560.00,0.00,0.00,0.00,640.00,'2021-12-03 12:37:06','',''),(2140283,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 12:37:06','',''),(2140333,'1','142','798',342,'Retail Sale Id 1269251',1968.00,0.00,0.00,0.00,192.00,'2021-12-03 12:40:38','',''),(2140334,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 12:40:38','',''),(2140367,'1','142','798',342,'Retail Sale Id 1269265',2000.80,0.00,0.00,0.00,195.20,'2021-12-03 12:43:08','',''),(2140368,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 12:43:09','',''),(2140411,'1','142','798',342,'Retail Sale Id 1269285',4001.60,0.00,0.00,0.00,390.40,'2021-12-03 12:46:53','',''),(2140412,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 12:46:53','',''),(2140413,'1','142','798',342,'Retail Sale Id 1269285',6560.00,0.00,0.00,0.00,640.00,'2021-12-03 12:46:53','',''),(2140414,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 12:46:53','',''),(2140445,'1','142','798',342,'Retail Sale Id 1269303',3942.56,0.00,0.00,0.00,384.64,'2021-12-03 12:48:51','',''),(2140446,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 12:48:51','',''),(2140447,'1','142','798',342,'Retail Sale Id 1269303',3942.56,0.00,0.00,0.00,384.64,'2021-12-03 12:48:51','',''),(2140448,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 12:48:51','',''),(2140509,'1','142','798',342,'Retail Sale Id 1269333',8200.00,0.00,0.00,0.00,800.00,'2021-12-03 12:52:30','',''),(2140510,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:52:30','',''),(2140543,'1','142','798',342,'Retail Sale Id 1269347',6999.52,0.00,0.00,0.00,682.88,'2021-12-03 12:54:36','',''),(2140544,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.67,0.00,'2021-12-03 12:54:36','',''),(2140877,'1','142','798',342,'Retail Sale Id 1269497',8200.00,0.00,0.00,0.00,800.00,'2021-12-03 13:22:01','',''),(2140878,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:22:01','',''),(2140927,'1','142','798',342,'Retail Sale Id 1269523',2997.92,0.00,0.00,0.00,292.48,'2021-12-03 13:26:34','',''),(2140928,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 13:26:34','',''),(2140952,'1','142','798',342,'Retail Sale Id 1269535',3936.00,0.00,0.00,0.00,384.00,'2021-12-03 13:28:12','',''),(2140953,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 13:28:12','',''),(2140970,'1','142','798',342,'Retail Sale Id 1269546',997.12,0.00,0.00,0.00,97.28,'2021-12-03 13:29:33','',''),(2140971,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 13:29:33','',''),(2141005,'1','142','798',342,'Retail Sale Id 1269565',8200.00,0.00,0.00,0.00,800.00,'2021-12-03 13:32:10','',''),(2141006,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:32:10','',''),(2141033,'1','142','798',342,'Retail Sale Id 1269578',2624.00,0.00,0.00,0.00,256.00,'2021-12-03 13:33:52','',''),(2141034,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 13:33:52','',''),(2141055,'1','142','798',342,'Retail Sale Id 1269587',2499.36,0.00,0.00,0.00,243.84,'2021-12-03 13:35:22','',''),(2141056,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-03 13:35:22','',''),(2141079,'1','142','798',342,'Retail Sale Id 1269601',997.12,0.00,0.00,0.00,97.28,'2021-12-03 13:37:14','',''),(2141080,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 13:37:14','',''),(2141244,'1','142','798',342,'Retail Sale Id 1269674',2997.92,0.00,0.00,0.00,292.48,'2021-12-03 13:45:31','',''),(2141245,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 13:45:31','',''),(2141272,'1','142','798',342,'Retail Sale Id 1269691',2499.36,0.00,0.00,0.00,243.84,'2021-12-03 13:47:08','',''),(2141273,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-03 13:47:08','',''),(2141385,'1','142','798',342,'Retail Sale Id 1269705',1502.24,0.00,0.00,0.00,146.56,'2021-12-03 13:48:58','',''),(2141386,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-03 13:48:58','',''),(2141409,'1','142','798',342,'Retail Sale Id 1269718',1968.00,0.00,0.00,0.00,192.00,'2021-12-03 13:50:42','',''),(2141410,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 13:50:42','',''),(2141834,'1','142','798',342,'Retail Sale Id 1269905',201894.00,0.00,0.00,0.00,11270.00,'2021-12-03 14:17:35','',''),(2141835,'1','142','798',342,'Retail sales',0.00,0.00,0.00,322.00,0.00,'2021-12-03 14:17:35','',''),(2141896,'1','142','798',342,'Retail Sale Id 1269916',8200.00,0.00,0.00,0.00,800.00,'2021-12-03 14:20:40','',''),(2141897,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:20:40','',''),(2141943,'1','142','798',342,'Retail Sale Id 1269937',997.12,0.00,0.00,0.00,97.28,'2021-12-03 14:22:50','',''),(2141944,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 14:22:50','',''),(2141963,'1','142','798',342,'Retail Sale Id 1269945',3280.00,0.00,0.00,0.00,320.00,'2021-12-03 14:24:01','',''),(2141964,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 14:24:01','',''),(2142008,'1','142','798',342,'Retail Sale Id 1269962',1502.24,0.00,0.00,0.00,146.56,'2021-12-03 14:26:11','',''),(2142009,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-03 14:26:11','',''),(2142030,'1','142','798',342,'Retail Sale Id 1269974',3936.00,0.00,0.00,0.00,384.00,'2021-12-03 14:27:50','',''),(2142031,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 14:27:50','',''),(2142075,'1','142','798',342,'Retail Sale Id 1269997',55104.00,0.00,0.00,0.00,5376.00,'2021-12-03 14:30:49','',''),(2142076,'1','142','798',342,'Retail sales',0.00,0.00,0.00,84.00,0.00,'2021-12-03 14:30:49','',''),(2142377,'1','142','798',342,'Retail Sale Id 1270103',2000.80,0.00,0.00,0.00,195.20,'2021-12-03 14:44:54','',''),(2142378,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 14:44:54','',''),(2142413,'1','142','798',342,'Retail Sale Id 1270121',4001.60,0.00,0.00,0.00,390.40,'2021-12-03 14:46:27','',''),(2142414,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 14:46:27','',''),(2142463,'1','142','798',342,'Retail Sale Id 1270149',4001.60,0.00,0.00,0.00,390.40,'2021-12-03 14:48:09','',''),(2142464,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 14:48:09','',''),(2142610,'1','142','799',342,'Retail Sale Id 1270221',2624.00,0.00,0.00,0.00,256.00,'2021-12-03 14:55:32','',''),(2142611,'1','142','799',342,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 14:55:32','',''),(2142687,'1','142','798',342,'Retail Sale Id 1270250',6560.00,0.00,0.00,0.00,640.00,'2021-12-03 14:59:14','',''),(2142688,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 14:59:14','',''),(2142738,'1','142','798',342,'Retail Sale Id 1270276',1968.00,0.00,0.00,0.00,192.00,'2021-12-03 15:02:17','',''),(2142739,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:02:17','',''),(2142755,'1','142','798',342,'Retail Sale Id 1270284',8200.00,0.00,0.00,0.00,800.00,'2021-12-03 15:03:47','',''),(2142756,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:03:47','',''),(2142808,'1','142','798',342,'Retail Sale Id 1270309',3503.04,0.00,0.00,0.00,341.76,'2021-12-03 15:07:33','',''),(2142809,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-03 15:07:33','',''),(2142848,'1','142','798',342,'Retail Sale Id 1270330',1797.44,0.00,0.00,0.00,175.36,'2021-12-03 15:09:47','',''),(2142849,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.74,0.00,'2021-12-03 15:09:47','',''),(2142900,'1','142','798',342,'Retail Sale Id 1270356',6002.40,0.00,0.00,0.00,585.60,'2021-12-03 15:11:39','',''),(2142901,'1','142','798',342,'Retail sales',0.00,0.00,0.00,9.15,0.00,'2021-12-03 15:11:39','',''),(2143065,'1','142','798',342,'Retail Sale Id 1270458',997.12,0.00,0.00,0.00,97.28,'2021-12-03 15:19:34','',''),(2143066,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 15:19:34','',''),(2143169,'1','142','798',342,'Retail Sale Id 1270511',2000.80,0.00,0.00,0.00,195.20,'2021-12-03 15:25:19','',''),(2143170,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 15:25:19','',''),(2143193,'1','142','798',342,'Retail Sale Id 1270523',997.12,0.00,0.00,0.00,97.28,'2021-12-03 15:26:29','',''),(2143194,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 15:26:29','',''),(2143214,'1','142','798',342,'Retail Sale Id 1270533',1502.24,0.00,0.00,0.00,146.56,'2021-12-03 15:27:46','',''),(2143215,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-03 15:27:46','',''),(2143321,'1','142','798',342,'Retail Sale Id 1270583',1968.00,0.00,0.00,0.00,192.00,'2021-12-03 15:32:37','',''),(2143322,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:32:37','',''),(2143371,'1','142','798',342,'Retail Sale Id 1270603',2000.80,0.00,0.00,0.00,195.20,'2021-12-03 15:34:12','',''),(2143372,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 15:34:12','',''),(2143413,'1','142','798',342,'Retail Sale Id 1270630',2000.80,0.00,0.00,0.00,195.20,'2021-12-03 15:36:16','',''),(2143414,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 15:36:16','',''),(2143532,'1','142','798',342,'Retail Sale Id 1270691',30996.00,0.00,0.00,0.00,1869.60,'2021-12-03 15:41:09','',''),(2143533,'1','142','798',342,'Retail sales',0.00,0.00,0.00,49.20,0.00,'2021-12-03 15:41:09','',''),(2143574,'1','142','798',342,'Retail Sale Id 1270710',3949.12,0.00,0.00,0.00,385.28,'2021-12-03 15:42:37','',''),(2143575,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-03 15:42:37','',''),(2143612,'1','142','798',342,'Retail Sale Id 1270727',1968.00,0.00,0.00,0.00,192.00,'2021-12-03 15:44:28','',''),(2143613,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:44:28','',''),(2143684,'1','142','798',342,'Retail Sale Id 1270765',4401.76,0.00,0.00,0.00,429.44,'2021-12-03 15:47:25','',''),(2143685,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.71,0.00,'2021-12-03 15:47:25','',''),(2143760,'1','142','798',342,'Retail Sale Id 1270799',3936.00,0.00,0.00,0.00,384.00,'2021-12-03 15:50:01','',''),(2143761,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:50:01','',''),(2143913,'1','142','798',342,'Retail Sale Id 1270879',1502.24,0.00,0.00,0.00,146.56,'2021-12-03 15:57:55','',''),(2143914,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-03 15:57:55','',''),(2143973,'1','142','798',342,'Retail Sale Id 1270904',2000.80,0.00,0.00,0.00,195.20,'2021-12-03 16:00:28','',''),(2143974,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:00:28','',''),(2144011,'1','142','798',342,'Retail Sale Id 1270923',2000.80,0.00,0.00,0.00,195.20,'2021-12-03 16:01:54','',''),(2144012,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:01:54','',''),(2144065,'1','142','798',342,'Retail Sale Id 1270952',3280.00,0.00,0.00,0.00,320.00,'2021-12-03 16:04:20','',''),(2144066,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:04:20','',''),(2144159,'1','142','798',342,'Retail Sale Id 1270994',2997.92,0.00,0.00,0.00,292.48,'2021-12-03 16:07:59','',''),(2144160,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 16:07:59','',''),(2144186,'1','142','798',342,'Retail Sale Id 1271011',1797.44,0.00,0.00,0.00,175.36,'2021-12-03 16:09:31','',''),(2144187,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.74,0.00,'2021-12-03 16:09:31','',''),(2144228,'1','142','798',342,'Retail Sale Id 1271029',1318.56,0.00,0.00,0.00,128.64,'2021-12-03 16:11:05','',''),(2144229,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-03 16:11:05','',''),(2144268,'1','142','798',342,'Retail Sale Id 1271056',3936.00,0.00,0.00,0.00,384.00,'2021-12-03 16:13:51','',''),(2144269,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 16:13:51','',''),(2144334,'1','142','798',342,'Retail Sale Id 1271089',3798.24,0.00,0.00,0.00,370.56,'2021-12-03 16:17:53','',''),(2144335,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.79,0.00,'2021-12-03 16:17:53','',''),(2144386,'1','142','798',342,'Retail Sale Id 1271115',8200.00,0.00,0.00,0.00,800.00,'2021-12-03 16:19:59','',''),(2144387,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:19:59','',''),(2144590,'1','142','798',342,'Retail Sale Id 1271212',7872.00,0.00,0.00,0.00,768.00,'2021-12-03 16:30:38','',''),(2144591,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-03 16:30:38','',''),(2144667,'1','142','798',342,'Retail Sale Id 1271253',1318.56,0.00,0.00,0.00,128.64,'2021-12-03 16:34:56','',''),(2144668,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-03 16:34:56','',''),(2144722,'1','142','798',342,'Retail Sale Id 1271285',8298.40,0.00,0.00,0.00,809.60,'2021-12-03 16:37:33','',''),(2144723,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.65,0.00,'2021-12-03 16:37:33','',''),(2144761,'1','142','798',342,'Retail Sale Id 1271302',1797.44,0.00,0.00,0.00,175.36,'2021-12-03 16:39:31','',''),(2144762,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.74,0.00,'2021-12-03 16:39:31','',''),(2144873,'1','142','798',342,'Retail Sale Id 1271362',31500.00,0.00,0.00,0.00,1900.00,'2021-12-03 16:44:52','',''),(2144874,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 16:44:52','',''),(2144905,'1','142','798',342,'Retail Sale Id 1271373',4500.16,0.00,0.00,0.00,439.04,'2021-12-03 16:46:19','',''),(2144906,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.86,0.00,'2021-12-03 16:46:19','',''),(2145005,'1','142','798',342,'Retail Sale Id 1271420',2499.36,0.00,0.00,0.00,243.84,'2021-12-03 16:51:34','',''),(2145006,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-03 16:51:34','',''),(2145109,'1','142','798',342,'Retail Sale Id 1271456',2499.36,0.00,0.00,0.00,243.84,'2021-12-03 16:55:45','',''),(2145110,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-03 16:55:45','',''),(2145165,'1','142','798',342,'Retail Sale Id 1271472',11998.24,0.00,0.00,0.00,1170.56,'2021-12-03 16:57:34','',''),(2145166,'1','142','798',342,'Retail sales',0.00,0.00,0.00,18.29,0.00,'2021-12-03 16:57:34','',''),(2145505,'1','142','798',342,'Retail Sale Id 1271648',124377.60,0.00,0.00,0.00,12134.40,'2021-12-03 17:28:27','',''),(2145506,'1','142','798',342,'Retail sales',0.00,0.00,0.00,189.60,0.00,'2021-12-03 17:28:27','',''),(2145543,'1','142','799',342,'Return of Retail Sale Id 1270221',0.00,2624.00,4.00,0.00,-256.00,'2021-12-03 17:34:16','',''),(2145551,'1','142','798',342,'Retail Sale Id 1271672',2624.00,0.00,0.00,0.00,256.00,'2021-12-03 17:35:14','',''),(2145552,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 17:35:14','',''),(2148462,'1','142','798',342,'Retail Sale Id 1272897',1968.00,0.00,0.00,0.00,192.00,'2021-12-04 07:46:49','',''),(2148463,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:46:49','',''),(2148515,'1','142','798',342,'Retail Sale Id 1272928',4998.72,0.00,0.00,0.00,487.68,'2021-12-04 07:49:47','',''),(2148516,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-04 07:49:47','',''),(2148549,'1','142','798',342,'Retail Sale Id 1272951',1968.00,0.00,0.00,0.00,192.00,'2021-12-04 07:52:02','',''),(2148550,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:52:02','',''),(2148618,'1','142','798',342,'Retail Sale Id 1273007',2499.36,0.00,0.00,0.00,243.84,'2021-12-04 07:56:47','',''),(2148619,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-04 07:56:47','',''),(2148667,'1','142','798',342,'Retail Sale Id 1273034',3936.00,0.00,0.00,0.00,384.00,'2021-12-04 07:59:10','',''),(2148668,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:59:10','',''),(2148719,'1','142','798',342,'Retail Sale Id 1273051',2000.80,0.00,0.00,0.00,195.20,'2021-12-04 08:01:10','',''),(2148720,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 08:01:10','',''),(2148765,'1','142','798',342,'Retail Sale Id 1273077',1968.00,0.00,0.00,0.00,192.00,'2021-12-04 08:03:12','',''),(2148766,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:03:12','',''),(2148825,'1','142','798',342,'Retail Sale Id 1273106',1968.00,0.00,0.00,0.00,192.00,'2021-12-04 08:05:38','',''),(2148826,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:05:38','',''),(2148860,'1','142','798',342,'Retail Sale Id 1273126',3280.00,0.00,0.00,0.00,320.00,'2021-12-04 08:07:00','',''),(2148861,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:07:00','',''),(2149241,'1','142','798',342,'Retail Sale Id 1273379',3936.00,0.00,0.00,0.00,384.00,'2021-12-04 08:23:23','',''),(2149242,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:23:23','',''),(2149354,'1','142','798',342,'Retail Sale Id 1273437',2997.92,0.00,0.00,0.00,292.48,'2021-12-04 08:28:10','',''),(2149355,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-04 08:28:10','',''),(2149412,'1','142','798',342,'Retail Sale Id 1273468',8200.00,0.00,0.00,0.00,800.00,'2021-12-04 08:30:28','',''),(2149413,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:30:28','',''),(2149531,'1','142','798',342,'Retail Sale Id 1273546',42840.00,0.00,0.00,0.00,2584.00,'2021-12-04 08:34:04','',''),(2149532,'1','142','798',342,'Retail sales',0.00,0.00,0.00,68.00,0.00,'2021-12-04 08:34:04','',''),(2149568,'1','142','798',342,'Retail Sale Id 1273566',1968.00,0.00,0.00,0.00,192.00,'2021-12-04 08:35:23','',''),(2149569,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:35:23','',''),(2149830,'1','142','798',342,'Retail Sale Id 1273693',3936.00,0.00,0.00,0.00,384.00,'2021-12-04 08:46:02','',''),(2149831,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:46:02','',''),(2149860,'1','142','798',342,'Retail Sale Id 1273707',3503.04,0.00,0.00,0.00,341.76,'2021-12-04 08:47:19','',''),(2149861,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-04 08:47:19','',''),(2149924,'1','142','798',342,'Retail Sale Id 1273744',2997.92,0.00,0.00,0.00,292.48,'2021-12-04 08:50:18','',''),(2149925,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-04 08:50:18','',''),(2149952,'1','142','798',342,'Retail Sale Id 1273758',2997.92,0.00,0.00,0.00,292.48,'2021-12-04 08:51:42','',''),(2149953,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-04 08:51:42','',''),(2150059,'1','142','798',342,'Retail Sale Id 1273817',8200.00,0.00,0.00,0.00,800.00,'2021-12-04 08:56:42','',''),(2150060,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:56:42','',''),(2150095,'1','142','798',342,'Retail Sale Id 1273834',1968.00,0.00,0.00,0.00,192.00,'2021-12-04 08:58:32','',''),(2150096,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:58:32','',''),(2150139,'1','142','798',342,'Retail Sale Id 1273858',997.12,0.00,0.00,0.00,97.28,'2021-12-04 09:00:15','',''),(2150140,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-04 09:00:15','',''),(2150261,'1','142','798',342,'Retail Sale Id 1273928',662.56,0.00,0.00,0.00,64.64,'2021-12-04 09:05:53','',''),(2150262,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.01,0.00,'2021-12-04 09:05:53','',''),(2150391,'1','142','798',342,'Retail Sale Id 1273992',1968.00,0.00,0.00,0.00,192.00,'2021-12-04 09:13:16','',''),(2150392,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 09:13:16','',''),(2150393,'1','142','798',342,'Retail Sale Id 1273992',3936.00,0.00,0.00,0.00,384.00,'2021-12-04 09:13:16','',''),(2150394,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 09:13:16','',''),(2152506,'1','142','798',342,'Retail Sale Id 1274409',2000.80,0.00,0.00,0.00,195.20,'2021-12-04 10:36:52','',''),(2152507,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 10:36:52','',''),(2152573,'1','142','798',342,'Retail Sale Id 1274431',3936.00,0.00,0.00,0.00,384.00,'2021-12-04 10:42:44','',''),(2152574,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 10:42:44','',''),(2152596,'1','142','798',342,'Retail Sale Id 1274440',4998.72,0.00,0.00,0.00,487.68,'2021-12-04 10:43:59','',''),(2152597,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-04 10:43:59','',''),(2152614,'1','142','798',342,'Retail Sale Id 1274450',3280.00,0.00,0.00,0.00,320.00,'2021-12-04 10:45:23','',''),(2152615,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 10:45:23','',''),(2152656,'1','142','798',342,'Retail Sale Id 1274460',16400.00,0.00,0.00,0.00,1600.00,'2021-12-04 10:47:37','',''),(2152657,'1','142','798',342,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 10:47:37','',''),(2152698,'1','142','798',342,'Retail Sale Id 1274482',1968.00,0.00,0.00,0.00,192.00,'2021-12-04 10:49:56','',''),(2152699,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 10:49:56','',''),(2152900,'1','142','798',342,'Retail Sale Id 1274568',2000.80,0.00,0.00,0.00,195.20,'2021-12-04 11:00:59','',''),(2152901,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 11:00:59','',''),(2152972,'1','142','798',342,'Retail Sale Id 1274603',2997.92,0.00,0.00,0.00,292.48,'2021-12-04 11:04:37','',''),(2152973,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-04 11:04:37','',''),(2153018,'1','142','798',342,'Retail Sale Id 1274627',4100.00,0.00,0.00,0.00,400.00,'2021-12-04 11:07:12','',''),(2153019,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 11:07:12','',''),(2153044,'1','142','798',342,'Retail Sale Id 1274639',2997.92,0.00,0.00,0.00,292.48,'2021-12-04 11:08:22','',''),(2153045,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-04 11:08:22','',''),(2153109,'1','142','798',342,'Retail Sale Id 1274671',3936.00,0.00,0.00,0.00,384.00,'2021-12-04 11:11:22','',''),(2153110,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 11:11:22','',''),(2153141,'1','142','798',342,'Retail Sale Id 1274684',2997.92,0.00,0.00,0.00,292.48,'2021-12-04 11:12:50','',''),(2153142,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-04 11:12:50','',''),(2153203,'1','142','798',342,'Retail Sale Id 1274719',8200.00,0.00,0.00,0.00,800.00,'2021-12-04 11:15:55','',''),(2153204,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:15:55','',''),(2153235,'1','142','798',342,'Retail Sale Id 1274737',2000.80,0.00,0.00,0.00,195.20,'2021-12-04 11:17:17','',''),(2153236,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 11:17:17','',''),(2153263,'1','142','798',342,'Retail Sale Id 1274752',997.12,0.00,0.00,0.00,97.28,'2021-12-04 11:18:34','',''),(2153264,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-04 11:18:34','',''),(2153287,'1','142','798',342,'Retail Sale Id 1274766',2000.80,0.00,0.00,0.00,195.20,'2021-12-04 11:20:02','',''),(2153288,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 11:20:02','',''),(2153402,'1','142','798',342,'Retail Sale Id 1274823',2000.80,0.00,0.00,0.00,195.20,'2021-12-04 11:26:45','',''),(2153403,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 11:26:45','',''),(2153497,'1','142','798',342,'Retail Sale Id 1274875',2000.80,0.00,0.00,0.00,195.20,'2021-12-04 11:31:46','',''),(2153498,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 11:31:46','',''),(2153523,'1','142','798',342,'Retail Sale Id 1274886',1502.24,0.00,0.00,0.00,146.56,'2021-12-04 11:32:58','',''),(2153524,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-04 11:32:58','',''),(2153554,'1','142','798',342,'Retail Sale Id 1274900',1502.24,0.00,0.00,0.00,146.56,'2021-12-04 11:34:28','',''),(2153555,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-04 11:34:28','',''),(2153584,'1','142','798',342,'Retail Sale Id 1274915',1502.24,0.00,0.00,0.00,146.56,'2021-12-04 11:36:19','',''),(2153585,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-04 11:36:19','',''),(2153637,'1','142','798',342,'Retail Sale Id 1274933',1968.00,0.00,0.00,0.00,192.00,'2021-12-04 11:38:05','',''),(2153638,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 11:38:05','',''),(2153639,'1','142','798',342,'Retail Sale Id 1274933',6560.00,0.00,0.00,0.00,640.00,'2021-12-04 11:38:05','',''),(2153640,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 11:38:05','',''),(2153680,'1','142','798',342,'Retail Sale Id 1274952',2997.92,0.00,0.00,0.00,292.48,'2021-12-04 11:40:14','',''),(2153681,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-04 11:40:14','',''),(2153705,'1','142','798',342,'Retail Sale Id 1274964',984.00,0.00,0.00,0.00,96.00,'2021-12-04 11:42:00','',''),(2153706,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.50,0.00,'2021-12-04 11:42:00','',''),(2153739,'1','142','798',342,'Retail Sale Id 1274981',1968.00,0.00,0.00,0.00,192.00,'2021-12-04 11:44:35','',''),(2153740,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 11:44:35','',''),(2153772,'1','142','798',342,'Retail Sale Id 1274993',1968.00,0.00,0.00,0.00,192.00,'2021-12-04 11:46:06','',''),(2153773,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 11:46:06','',''),(2153800,'1','142','798',342,'Retail Sale Id 1275007',3936.00,0.00,0.00,0.00,384.00,'2021-12-04 11:47:43','',''),(2153801,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 11:47:43','',''),(2153840,'1','142','798',342,'Retail Sale Id 1275023',2624.00,0.00,0.00,0.00,256.00,'2021-12-04 11:50:10','',''),(2153841,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 11:50:10','',''),(2153934,'1','142','798',342,'Retail Sale Id 1275060',3280.00,0.00,0.00,0.00,320.00,'2021-12-04 11:54:55','',''),(2153935,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 11:54:55','',''),(2155978,'1','142','798',342,'Retail Sale Id 1276161',8200.00,0.00,0.00,0.00,800.00,'2021-12-04 13:56:28','',''),(2155979,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:56:28','',''),(2156132,'1','142','798',342,'Retail Sale Id 1276218',3936.00,0.00,0.00,0.00,384.00,'2021-12-04 14:02:45','',''),(2156133,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:02:45','',''),(2156154,'1','142','798',342,'Retail Sale Id 1276234',13999.04,0.00,0.00,0.00,1365.76,'2021-12-04 14:03:44','',''),(2156155,'1','142','798',342,'Retail sales',0.00,0.00,0.00,21.34,0.00,'2021-12-04 14:03:44','',''),(2156267,'1','142','798',342,'Retail Sale Id 1276280',2997.92,0.00,0.00,0.00,292.48,'2021-12-04 14:07:47','',''),(2156268,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-04 14:07:47','',''),(2156373,'1','142','798',342,'Retail Sale Id 1276337',997.12,0.00,0.00,0.00,97.28,'2021-12-04 14:13:13','',''),(2156374,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-04 14:13:13','',''),(2156538,'1','142','798',342,'Retail Sale Id 1276415',2000.80,0.00,0.00,0.00,195.20,'2021-12-04 14:20:12','',''),(2156539,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 14:20:12','',''),(2156604,'1','142','798',342,'Retail Sale Id 1276452',3280.00,0.00,0.00,0.00,320.00,'2021-12-04 14:23:36','',''),(2156605,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 14:23:36','',''),(2156645,'1','142','798',342,'Retail Sale Id 1276466',997.12,0.00,0.00,0.00,97.28,'2021-12-04 14:26:24','',''),(2156646,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-04 14:26:24','',''),(2156669,'1','142','798',342,'Retail Sale Id 1276478',1502.24,0.00,0.00,0.00,146.56,'2021-12-04 14:28:03','',''),(2156670,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-04 14:28:03','',''),(2156713,'1','142','798',342,'Retail Sale Id 1276502',2000.80,0.00,0.00,0.00,195.20,'2021-12-04 14:30:48','',''),(2156714,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 14:30:48','',''),(2156770,'1','142','798',342,'Retail Sale Id 1276528',997.12,0.00,0.00,0.00,97.28,'2021-12-04 14:34:05','',''),(2156771,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-04 14:34:05','',''),(2156898,'1','142','798',342,'Retail Sale Id 1276590',3936.00,0.00,0.00,0.00,384.00,'2021-12-04 14:41:30','',''),(2156899,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:41:30','',''),(2156900,'1','142','798',342,'Retail Sale Id 1276590',6560.00,0.00,0.00,0.00,640.00,'2021-12-04 14:41:30','',''),(2156901,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 14:41:30','',''),(2156940,'1','142','798',342,'Retail Sale Id 1276600',3936.00,0.00,0.00,0.00,384.00,'2021-12-04 14:43:12','',''),(2156941,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:43:12','',''),(2156963,'1','142','798',342,'Retail Sale Id 1276606',3936.00,0.00,0.00,0.00,384.00,'2021-12-04 14:44:18','',''),(2156964,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:44:18','',''),(2157052,'1','142','798',342,'Retail Sale Id 1276632',2000.80,0.00,0.00,0.00,195.20,'2021-12-04 14:47:03','',''),(2157053,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 14:47:03','',''),(2157076,'1','142','798',342,'Retail Sale Id 1276638',997.12,0.00,0.00,0.00,97.28,'2021-12-04 14:48:24','',''),(2157077,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-04 14:48:24','',''),(2157124,'1','142','798',342,'Retail Sale Id 1276659',3936.00,0.00,0.00,0.00,384.00,'2021-12-04 14:50:58','',''),(2157125,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:50:58','',''),(2157187,'1','142','798',342,'Retail Sale Id 1276689',701.92,0.00,0.00,0.00,68.48,'2021-12-04 14:54:41','',''),(2157188,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.07,0.00,'2021-12-04 14:54:41','',''),(2157326,'1','142','798',342,'Retail Sale Id 1276727',3299.68,0.00,0.00,0.00,321.92,'2021-12-04 15:00:14','',''),(2157327,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-04 15:00:14','',''),(2157353,'1','142','798',342,'Retail Sale Id 1276748',8003.20,0.00,0.00,0.00,780.80,'2021-12-04 15:02:14','',''),(2157354,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-04 15:02:14','',''),(2157402,'1','142','798',342,'Retail Sale Id 1276767',2000.80,0.00,0.00,0.00,195.20,'2021-12-04 15:04:24','',''),(2157403,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 15:04:24','',''),(2157428,'1','142','798',342,'Retail Sale Id 1276784',2000.80,0.00,0.00,0.00,195.20,'2021-12-04 15:06:01','',''),(2157429,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 15:06:01','',''),(2157568,'1','142','798',342,'Retail Sale Id 1276852',1968.00,0.00,0.00,0.00,192.00,'2021-12-04 15:14:31','',''),(2157569,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:14:31','',''),(2157626,'1','142','798',342,'Retail Sale Id 1276881',2997.92,0.00,0.00,0.00,292.48,'2021-12-04 15:17:37','',''),(2157627,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-04 15:17:37','',''),(2157794,'1','142','798',342,'Retail Sale Id 1276943',3936.00,0.00,0.00,0.00,384.00,'2021-12-04 15:24:45','',''),(2157795,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:24:45','',''),(2157844,'1','142','798',342,'Retail Sale Id 1276966',10496.00,0.00,0.00,0.00,1024.00,'2021-12-04 15:26:52','',''),(2157845,'1','142','798',342,'Retail sales',0.00,0.00,0.00,16.00,0.00,'2021-12-04 15:26:52','',''),(2157895,'1','142','798',342,'Retail Sale Id 1276990',1502.24,0.00,0.00,0.00,146.56,'2021-12-04 15:28:43','',''),(2157896,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-04 15:28:43','',''),(2158038,'1','142','798',342,'Retail Sale Id 1277060',2000.80,0.00,0.00,0.00,195.20,'2021-12-04 15:35:50','',''),(2158039,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 15:35:50','',''),(2158080,'1','142','798',342,'Retail Sale Id 1277079',4001.60,0.00,0.00,0.00,390.40,'2021-12-04 15:37:47','',''),(2158081,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 15:37:47','',''),(2158303,'1','142','798',342,'Retail Sale Id 1277179',2000.80,0.00,0.00,0.00,195.20,'2021-12-04 15:48:05','',''),(2158304,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 15:48:05','',''),(2158364,'1','142','798',342,'Retail Sale Id 1277211',346500.00,0.00,0.00,0.00,20900.00,'2021-12-04 15:51:25','',''),(2158365,'1','142','798',342,'Retail sales',0.00,0.00,0.00,550.00,0.00,'2021-12-04 15:51:25','',''),(2158482,'1','142','798',342,'Retail Sale Id 1277278',8200.00,0.00,0.00,0.00,800.00,'2021-12-04 15:57:01','',''),(2158483,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:57:01','',''),(2158642,'1','142','798',342,'Retail Sale Id 1277367',5799.04,0.00,0.00,0.00,565.76,'2021-12-04 16:05:28','',''),(2158643,'1','142','798',342,'Retail sales',0.00,0.00,0.00,8.84,0.00,'2021-12-04 16:05:28','',''),(2158704,'1','142','798',342,'Retail Sale Id 1277399',1968.00,0.00,0.00,0.00,192.00,'2021-12-04 16:08:21','',''),(2158705,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:08:21','',''),(2158741,'1','142','798',342,'Retail Sale Id 1277418',6300.00,0.00,0.00,0.00,380.00,'2021-12-04 16:10:01','',''),(2158742,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 16:10:01','',''),(2158863,'1','142','798',342,'Retail Sale Id 1277488',3280.00,0.00,0.00,0.00,320.00,'2021-12-04 16:15:26','',''),(2158864,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:15:26','',''),(2158901,'1','142','798',342,'Retail Sale Id 1277506',3280.00,0.00,0.00,0.00,320.00,'2021-12-04 16:17:25','',''),(2158902,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:17:25','',''),(2159153,'1','142','798',342,'Retail Sale Id 1277639',3280.00,0.00,0.00,0.00,320.00,'2021-12-04 16:28:27','',''),(2159154,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:28:27','',''),(2159193,'1','142','798',342,'Retail Sale Id 1277662',31500.00,0.00,0.00,0.00,1900.00,'2021-12-04 16:30:11','',''),(2159194,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 16:30:11','',''),(2159245,'1','142','798',342,'Retail Sale Id 1277681',3280.00,0.00,0.00,0.00,320.00,'2021-12-04 16:32:15','',''),(2159246,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:32:15','',''),(2159322,'1','142','798',342,'Retail Sale Id 1277722',4001.60,0.00,0.00,0.00,390.40,'2021-12-04 16:37:15','',''),(2159324,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 16:37:15','',''),(2159348,'1','142','798',342,'Retail Sale Id 1277733',1968.00,0.00,0.00,0.00,192.00,'2021-12-04 16:38:24','',''),(2159349,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:38:24','',''),(2159473,'1','142','798',342,'Retail Sale Id 1277774',3936.00,0.00,0.00,0.00,384.00,'2021-12-04 16:41:57','',''),(2159474,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:41:57','',''),(2159485,'1','142','798',342,'Retail Sale Id 1277804',1797.44,0.00,0.00,0.00,175.36,'2021-12-04 16:44:12','',''),(2159486,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.74,0.00,'2021-12-04 16:44:12','',''),(2159537,'1','142','798',342,'Retail Sale Id 1277851',31500.00,0.00,0.00,0.00,1900.00,'2021-12-04 16:46:06','',''),(2159538,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 16:46:06','',''),(2159594,'1','142','798',342,'Retail Sale Id 1277875',288420.00,0.00,0.00,0.00,16100.00,'2021-12-04 16:48:49','',''),(2159595,'1','142','798',342,'Retail sales',0.00,0.00,0.00,460.00,0.00,'2021-12-04 16:48:49','',''),(2159646,'1','142','798',342,'Retail Sale Id 1277896',1502.24,0.00,0.00,0.00,146.56,'2021-12-04 16:50:58','',''),(2159647,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-04 16:50:58','',''),(2159730,'1','142','798',342,'Retail Sale Id 1277939',6560.00,0.00,0.00,0.00,640.00,'2021-12-04 16:55:26','',''),(2159731,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 16:55:26','',''),(2159767,'1','142','798',342,'Retail Sale Id 1277958',3280.00,0.00,0.00,0.00,320.00,'2021-12-04 16:58:14','',''),(2159768,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:58:15','',''),(2159795,'1','142','798',342,'Retail Sale Id 1277973',997.12,0.00,0.00,0.00,97.28,'2021-12-04 16:59:40','',''),(2159796,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-04 16:59:40','',''),(2159831,'1','142','798',342,'Retail Sale Id 1277986',2997.92,0.00,0.00,0.00,292.48,'2021-12-04 17:01:13','',''),(2159832,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-04 17:01:13','',''),(2160715,'1','142','798',342,'Retail Sale Id 1278345',18900.00,0.00,0.00,0.00,1140.00,'2021-12-04 17:53:55','',''),(2160716,'1','142','798',342,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-04 17:53:55','',''),(2160731,'1','142','798',342,'Retail Sale Id 1278357',31500.00,0.00,0.00,0.00,1900.00,'2021-12-04 17:55:19','',''),(2160732,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 17:55:19','',''),(2160758,'1','142','798',342,'Retail Sale Id 1278368',173250.00,0.00,0.00,0.00,10450.00,'2021-12-04 17:58:34','',''),(2160759,'1','142','798',342,'Retail sales',0.00,0.00,0.00,275.00,0.00,'2021-12-04 17:58:34','',''),(2160764,'1','142','798',342,'Retail Sale Id 1278373',63000.00,0.00,0.00,0.00,3800.00,'2021-12-04 17:59:29','',''),(2160765,'1','142','798',342,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-04 17:59:29','',''),(2160780,'1','142','798',342,'Retail Sale Id 1278380',228812.80,0.00,0.00,0.00,22323.20,'2021-12-04 18:01:40','',''),(2160781,'1','142','798',342,'Retail sales',0.00,0.00,0.00,348.80,0.00,'2021-12-04 18:01:40','',''),(2160843,'1','142','798',342,'Retail Sale Id 1278410',2755.20,0.00,0.00,0.00,268.80,'2021-12-04 18:06:49','',''),(2160844,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.20,0.00,'2021-12-04 18:06:49','',''),(2160915,'1','142','798',342,'Retail Sale Id 1278446',157000.00,0.00,0.00,0.00,9000.00,'2021-12-04 18:18:14','',''),(2160916,'1','142','798',342,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-04 18:18:14','',''),(2163942,'1','142','798',342,'Retail Sale Id 1279673',42049.60,0.00,0.00,0.00,4102.40,'2021-12-05 08:08:58','',''),(2163943,'1','142','798',342,'Retail sales',0.00,0.00,0.00,64.10,0.00,'2021-12-05 08:08:58','',''),(2163988,'1','142','798',342,'Retail Sale Id 1279704',2997.92,0.00,0.00,0.00,292.48,'2021-12-05 08:11:14','',''),(2163989,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-05 08:11:14','',''),(2164050,'1','142','798',342,'Retail Sale Id 1279744',2997.92,0.00,0.00,0.00,292.48,'2021-12-05 08:15:15','',''),(2164051,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-05 08:15:15','',''),(2164220,'1','142','798',342,'Retail Sale Id 1279829',1502.24,0.00,0.00,0.00,146.56,'2021-12-05 08:23:26','',''),(2164221,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-05 08:23:26','',''),(2164294,'1','142','798',342,'Retail Sale Id 1279858',4001.60,0.00,0.00,0.00,390.40,'2021-12-05 08:25:50','',''),(2164295,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-05 08:25:50','',''),(2164432,'1','142','798',342,'Retail Sale Id 1279933',997.12,0.00,0.00,0.00,97.28,'2021-12-05 08:32:48','',''),(2164433,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-05 08:32:48','',''),(2164528,'1','142','798',342,'Retail Sale Id 1279992',3247.20,0.00,0.00,0.00,316.80,'2021-12-05 08:37:50','',''),(2164529,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.95,0.00,'2021-12-05 08:37:50','',''),(2164552,'1','142','798',342,'Retail Sale Id 1280007',4998.72,0.00,0.00,0.00,487.68,'2021-12-05 08:39:33','',''),(2164553,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-05 08:39:33','',''),(2164859,'1','142','798',342,'Retail Sale Id 1280148',1298.88,0.00,0.00,0.00,126.72,'2021-12-05 08:55:41','',''),(2164860,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.98,0.00,'2021-12-05 08:55:41','',''),(2164918,'1','142','798',342,'Retail Sale Id 1280184',8200.00,0.00,0.00,0.00,800.00,'2021-12-05 08:59:19','',''),(2164919,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:59:19','',''),(2164971,'1','142','798',342,'Retail Sale Id 1280209',4998.72,0.00,0.00,0.00,487.68,'2021-12-05 09:02:22','',''),(2164972,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-05 09:02:22','',''),(2165019,'1','142','798',342,'Retail Sale Id 1280232',8200.00,0.00,0.00,0.00,800.00,'2021-12-05 09:05:10','',''),(2165020,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:05:10','',''),(2165292,'1','142','798',342,'Retail Sale Id 1280411',1502.24,0.00,0.00,0.00,146.56,'2021-12-05 09:19:50','',''),(2165293,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-05 09:19:50','',''),(2165370,'1','142','798',342,'Retail Sale Id 1280454',1502.24,0.00,0.00,0.00,146.56,'2021-12-05 09:24:44','',''),(2165371,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-05 09:24:44','',''),(2165400,'1','142','798',342,'Retail Sale Id 1280473',997.12,0.00,0.00,0.00,97.28,'2021-12-05 09:25:51','',''),(2165401,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-05 09:25:51','',''),(2165422,'1','142','798',342,'Retail Sale Id 1280486',8200.00,0.00,0.00,0.00,800.00,'2021-12-05 09:27:17','',''),(2165424,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:27:17','',''),(2165446,'1','142','798',342,'Retail Sale Id 1280498',2000.80,0.00,0.00,0.00,195.20,'2021-12-05 09:28:15','',''),(2165447,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 09:28:15','',''),(2165496,'1','142','798',342,'Retail Sale Id 1280525',1699.04,0.00,0.00,0.00,165.76,'2021-12-05 09:31:01','',''),(2165497,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.59,0.00,'2021-12-05 09:31:01','',''),(2165526,'1','142','798',342,'Retail Sale Id 1280547',153615.00,0.00,0.00,0.00,8575.00,'2021-12-05 09:32:16','',''),(2165527,'1','142','798',342,'Retail sales',0.00,0.00,0.00,245.00,0.00,'2021-12-05 09:32:16','',''),(2165574,'1','142','798',342,'Retail Sale Id 1280572',1502.24,0.00,0.00,0.00,146.56,'2021-12-05 09:34:47','',''),(2165575,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-05 09:34:47','',''),(2167463,'1','142','798',342,'Retail Sale Id 1281513',1397.28,0.00,0.00,0.00,136.32,'2021-12-05 11:22:05','',''),(2167464,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.13,0.00,'2021-12-05 11:22:05','',''),(2167579,'1','142','798',342,'Retail Sale Id 1281575',997.12,0.00,0.00,0.00,97.28,'2021-12-05 11:28:53','',''),(2167580,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-05 11:28:53','',''),(2167703,'1','142','798',342,'Retail Sale Id 1281628',2624.00,0.00,0.00,0.00,256.00,'2021-12-05 11:34:30','',''),(2167704,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 11:34:30','',''),(2167745,'1','142','798',342,'Retail Sale Id 1281651',2000.80,0.00,0.00,0.00,195.20,'2021-12-05 11:37:06','',''),(2167746,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 11:37:06','',''),(2167777,'1','142','798',342,'Retail Sale Id 1281669',3936.00,0.00,0.00,0.00,384.00,'2021-12-05 11:39:13','',''),(2167778,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:39:13','',''),(2167810,'1','142','798',342,'Retail Sale Id 1281725',1640.00,0.00,0.00,0.00,160.00,'2021-12-05 11:41:56','',''),(2167811,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-05 11:41:56','',''),(2167826,'1','142','798',342,'Retail Sale Id 1281737',2997.92,0.00,0.00,0.00,292.48,'2021-12-05 11:43:02','',''),(2167827,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-05 11:43:02','',''),(2167925,'1','142','798',342,'Retail Sale Id 1281790',4001.60,0.00,0.00,0.00,390.40,'2021-12-05 11:48:45','',''),(2167926,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-05 11:48:45','',''),(2167939,'1','142','798',342,'Retail Sale Id 1281803',8200.00,0.00,0.00,0.00,800.00,'2021-12-05 11:49:36','',''),(2167940,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:49:36','',''),(2168063,'1','142','798',342,'Retail Sale Id 1281869',997.12,0.00,0.00,0.00,97.28,'2021-12-05 11:56:40','',''),(2168064,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-05 11:56:40','',''),(2168112,'1','142','798',342,'Retail Sale Id 1281894',1351.36,0.00,0.00,0.00,131.84,'2021-12-05 11:59:26','',''),(2168113,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-05 11:59:26','',''),(2168186,'1','142','798',342,'Retail Sale Id 1281930',3936.00,0.00,0.00,0.00,384.00,'2021-12-05 12:03:59','',''),(2168187,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:03:59','',''),(2168698,'1','142','798',342,'Retail Sale Id 1282174',8003.20,0.00,0.00,0.00,780.80,'2021-12-05 12:26:07','',''),(2168699,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-05 12:26:07','',''),(2168798,'1','142','798',342,'Retail Sale Id 1282237',8200.00,0.00,0.00,0.00,800.00,'2021-12-05 12:30:30','',''),(2168799,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:30:30','',''),(2168860,'1','142','798',342,'Retail Sale Id 1282270',2997.92,0.00,0.00,0.00,292.48,'2021-12-05 12:33:51','',''),(2168861,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-05 12:33:51','',''),(2169065,'1','142','798',342,'Retail Sale Id 1282376',3936.00,0.00,0.00,0.00,384.00,'2021-12-05 12:44:28','',''),(2169066,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:44:28','',''),(2169283,'1','142','798',342,'Retail Sale Id 1282506',2000.80,0.00,0.00,0.00,195.20,'2021-12-05 12:57:32','',''),(2169284,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 12:57:33','',''),(2169377,'1','142','798',342,'Retail Sale Id 1282549',3936.00,0.00,0.00,0.00,384.00,'2021-12-05 13:02:08','',''),(2169378,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 13:02:08','',''),(2169622,'1','142','798',342,'Retail Sale Id 1282696',2000.80,0.00,0.00,0.00,195.20,'2021-12-05 13:16:33','',''),(2169623,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 13:16:33','',''),(2169670,'1','142','798',342,'Retail Sale Id 1282716',8200.00,0.00,0.00,0.00,800.00,'2021-12-05 13:19:10','',''),(2169671,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:19:10','',''),(2169730,'1','142','798',342,'Retail Sale Id 1282749',8200.00,0.00,0.00,0.00,800.00,'2021-12-05 13:22:41','',''),(2169731,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:22:41','',''),(2169758,'1','142','798',342,'Retail Sale Id 1282766',65600.00,0.00,0.00,0.00,6400.00,'2021-12-05 13:24:55','',''),(2169759,'1','142','798',342,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-05 13:24:55','',''),(2169847,'1','142','798',342,'Retail Sale Id 1282805',2997.92,0.00,0.00,0.00,292.48,'2021-12-05 13:29:10','',''),(2169848,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-05 13:29:10','',''),(2170005,'1','142','798',342,'Retail Sale Id 1282877',3936.00,0.00,0.00,0.00,384.00,'2021-12-05 13:36:57','',''),(2170006,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 13:36:57','',''),(2170300,'1','142','798',342,'Retail Sale Id 1282988',6999.52,0.00,0.00,0.00,682.88,'2021-12-05 13:51:48','',''),(2170301,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.67,0.00,'2021-12-05 13:51:48','',''),(2170340,'1','142','798',342,'Retail Sale Id 1283002',2997.92,0.00,0.00,0.00,292.48,'2021-12-05 13:54:10','',''),(2170341,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-05 13:54:10','',''),(2170429,'1','142','798',342,'Retail Sale Id 1283037',3280.00,0.00,0.00,0.00,320.00,'2021-12-05 13:58:05','',''),(2170430,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 13:58:05','',''),(2170479,'1','142','798',342,'Retail Sale Id 1283059',16400.00,0.00,0.00,0.00,1600.00,'2021-12-05 14:00:48','',''),(2170480,'1','142','798',342,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 14:00:48','',''),(2170509,'1','142','798',342,'Retail Sale Id 1283076',2997.92,0.00,0.00,0.00,292.48,'2021-12-05 14:02:58','',''),(2170510,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-05 14:02:58','',''),(2170535,'1','142','798',342,'Retail Sale Id 1283088',1502.24,0.00,0.00,0.00,146.56,'2021-12-05 14:04:49','',''),(2170536,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-05 14:04:49','',''),(2170573,'1','142','798',342,'Retail Sale Id 1283109',3936.00,0.00,0.00,0.00,384.00,'2021-12-05 14:07:41','',''),(2170574,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:07:41','',''),(2170675,'1','142','798',342,'Retail Sale Id 1283142',3936.00,0.00,0.00,0.00,384.00,'2021-12-05 14:12:57','',''),(2170676,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:12:57','',''),(2170717,'1','142','798',342,'Retail Sale Id 1283169',7544.00,0.00,0.00,0.00,736.00,'2021-12-05 14:14:59','',''),(2170718,'1','142','798',342,'Retail sales',0.00,0.00,0.00,11.50,0.00,'2021-12-05 14:14:59','',''),(2170773,'1','142','798',342,'Retail Sale Id 1283186',6560.00,0.00,0.00,0.00,640.00,'2021-12-05 14:16:34','',''),(2170774,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 14:16:34','',''),(2170804,'1','142','798',342,'Retail Sale Id 1283197',2000.80,0.00,0.00,0.00,195.20,'2021-12-05 14:17:42','',''),(2170805,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 14:17:42','',''),(2170849,'1','142','798',342,'Retail Sale Id 1283210',8200.00,0.00,0.00,0.00,800.00,'2021-12-05 14:19:03','',''),(2170850,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:19:03','',''),(2170867,'1','142','798',342,'Retail Sale Id 1283223',4001.60,0.00,0.00,0.00,390.40,'2021-12-05 14:20:15','',''),(2170868,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-05 14:20:15','',''),(2170887,'1','142','798',342,'Retail Sale Id 1283233',701.92,0.00,0.00,0.00,68.48,'2021-12-05 14:21:40','',''),(2170888,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.07,0.00,'2021-12-05 14:21:40','',''),(2170929,'1','142','798',342,'Retail Sale Id 1283253',656.00,0.00,0.00,0.00,64.00,'2021-12-05 14:24:38','',''),(2170930,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-05 14:24:38','',''),(2170963,'1','142','798',342,'Retail Sale Id 1283270',4100.00,0.00,0.00,0.00,400.00,'2021-12-05 14:26:47','',''),(2170964,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 14:26:47','',''),(2170979,'1','142','798',342,'Retail Sale Id 1283279',4001.60,0.00,0.00,0.00,390.40,'2021-12-05 14:28:19','',''),(2170980,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-05 14:28:19','',''),(2171207,'1','142','798',342,'Retail Sale Id 1283346',3280.00,0.00,0.00,0.00,320.00,'2021-12-05 14:38:17','',''),(2171208,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 14:38:17','',''),(2171403,'1','142','798',342,'Retail Sale Id 1283427',3903.20,0.00,0.00,0.00,380.80,'2021-12-05 14:50:04','',''),(2171404,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.95,0.00,'2021-12-05 14:50:04','',''),(2171457,'1','142','798',342,'Retail Sale Id 1283455',6560.00,0.00,0.00,0.00,640.00,'2021-12-05 14:53:11','',''),(2171458,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 14:53:11','',''),(2171838,'1','142','798',342,'Retail Sale Id 1283647',7799.84,0.00,0.00,0.00,760.96,'2021-12-05 15:22:37','',''),(2171839,'1','142','798',342,'Retail sales',0.00,0.00,0.00,11.89,0.00,'2021-12-05 15:22:37','',''),(2171854,'1','142','798',342,'Retail Sale Id 1283654',6002.40,0.00,0.00,0.00,585.60,'2021-12-05 15:23:33','',''),(2171855,'1','142','798',342,'Retail sales',0.00,0.00,0.00,9.15,0.00,'2021-12-05 15:23:33','',''),(2171860,'1','142','798',342,'Retail Sale Id 1283660',3280.00,0.00,0.00,0.00,320.00,'2021-12-05 15:24:32','',''),(2171861,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 15:24:32','',''),(2171888,'1','142','798',342,'Retail Sale Id 1283673',656.00,0.00,0.00,0.00,64.00,'2021-12-05 15:26:42','',''),(2171889,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-05 15:26:42','',''),(2171902,'1','142','798',342,'Retail Sale Id 1283682',3247.20,0.00,0.00,0.00,316.80,'2021-12-05 15:27:41','',''),(2171903,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.95,0.00,'2021-12-05 15:27:41','',''),(2171922,'1','142','798',342,'Retail Sale Id 1283694',1298.88,0.00,0.00,0.00,126.72,'2021-12-05 15:29:09','',''),(2171923,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.98,0.00,'2021-12-05 15:29:09','',''),(2171938,'1','142','798',342,'Retail Sale Id 1283702',1502.24,0.00,0.00,0.00,146.56,'2021-12-05 15:30:03','',''),(2171939,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-05 15:30:03','',''),(2172257,'1','142','798',342,'Retail Sale Id 1283854',997.12,0.00,0.00,0.00,97.28,'2021-12-05 15:45:00','',''),(2172258,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-05 15:45:00','',''),(2172301,'1','142','798',342,'Retail Sale Id 1283879',7872.00,0.00,0.00,0.00,768.00,'2021-12-05 15:46:51','',''),(2172302,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-05 15:46:51','',''),(2172325,'1','142','798',342,'Retail Sale Id 1283891',1502.24,0.00,0.00,0.00,146.56,'2021-12-05 15:47:52','',''),(2172326,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-05 15:47:52','',''),(2172373,'1','142','798',342,'Retail Sale Id 1283918',4001.60,0.00,0.00,0.00,390.40,'2021-12-05 15:50:26','',''),(2172374,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-05 15:50:26','',''),(2172391,'1','142','798',342,'Retail Sale Id 1283928',1502.24,0.00,0.00,0.00,146.56,'2021-12-05 15:51:40','',''),(2172392,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-05 15:51:40','',''),(2172438,'1','142','798',342,'Retail Sale Id 1283951',2000.80,0.00,0.00,0.00,195.20,'2021-12-05 15:54:55','',''),(2172439,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 15:54:55','',''),(2172510,'1','142','798',342,'Retail Sale Id 1283987',188400.00,0.00,0.00,0.00,10800.00,'2021-12-05 15:58:45','',''),(2172511,'1','142','798',342,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-05 15:58:45','',''),(2172568,'1','142','798',342,'Retail Sale Id 1284018',3936.00,0.00,0.00,0.00,384.00,'2021-12-05 16:02:21','',''),(2172569,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 16:02:21','',''),(2172628,'1','142','798',342,'Retail Sale Id 1284054',1968.00,0.00,0.00,0.00,192.00,'2021-12-05 16:06:16','',''),(2172629,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 16:06:16','',''),(2172680,'1','142','798',342,'Retail Sale Id 1284079',3280.00,0.00,0.00,0.00,320.00,'2021-12-05 16:09:11','',''),(2172681,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 16:09:11','',''),(2172736,'1','142','798',342,'Retail Sale Id 1284105',1502.24,0.00,0.00,0.00,146.56,'2021-12-05 16:12:46','',''),(2172737,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-05 16:12:46','',''),(2172806,'1','142','798',342,'Retail Sale Id 1284139',3280.00,0.00,0.00,0.00,320.00,'2021-12-05 16:17:30','',''),(2172807,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 16:17:30','',''),(2172842,'1','142','798',342,'Retail Sale Id 1284161',1653.12,0.00,0.00,0.00,161.28,'2021-12-05 16:19:57','',''),(2172843,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.52,0.00,'2021-12-05 16:19:57','',''),(2172860,'1','142','798',342,'Retail Sale Id 1284175',3936.00,0.00,0.00,0.00,384.00,'2021-12-05 16:21:11','',''),(2172861,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 16:21:11','',''),(2172882,'1','142','798',342,'Retail Sale Id 1284186',7498.08,0.00,0.00,0.00,731.52,'2021-12-05 16:22:28','',''),(2172883,'1','142','798',342,'Retail sales',0.00,0.00,0.00,11.43,0.00,'2021-12-05 16:22:28','',''),(2172900,'1','142','798',342,'Retail Sale Id 1284195',997.12,0.00,0.00,0.00,97.28,'2021-12-05 16:23:22','',''),(2172901,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-05 16:23:22','',''),(2172922,'1','142','798',342,'Retail Sale Id 1284205',1502.24,0.00,0.00,0.00,146.56,'2021-12-05 16:24:10','',''),(2172923,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-05 16:24:10','',''),(2173005,'1','142','798',342,'Retail Sale Id 1284257',17712.00,0.00,0.00,0.00,1728.00,'2021-12-05 16:31:13','',''),(2173006,'1','142','798',342,'Retail sales',0.00,0.00,0.00,27.00,0.00,'2021-12-05 16:31:13','',''),(2173051,'1','142','798',342,'Retail Sale Id 1284276',1902.40,0.00,0.00,0.00,185.60,'2021-12-05 16:33:18','',''),(2173052,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-05 16:33:18','',''),(2173119,'1','142','798',342,'Retail Sale Id 1284311',1902.40,0.00,0.00,0.00,185.60,'2021-12-05 16:36:39','',''),(2173120,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-05 16:36:39','',''),(2173151,'1','142','798',342,'Retail Sale Id 1284327',1298.88,0.00,0.00,0.00,126.72,'2021-12-05 16:38:20','',''),(2173152,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.98,0.00,'2021-12-05 16:38:20','',''),(2173271,'1','142','798',342,'Retail Sale Id 1284391',1502.24,0.00,0.00,0.00,146.56,'2021-12-05 16:45:41','',''),(2173272,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-05 16:45:41','',''),(2173307,'1','142','798',342,'Retail Sale Id 1284407',2000.80,0.00,0.00,0.00,195.20,'2021-12-05 16:48:03','',''),(2173308,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 16:48:03','',''),(2173335,'1','142','798',342,'Retail Sale Id 1284423',4001.60,0.00,0.00,0.00,390.40,'2021-12-05 16:49:53','',''),(2173336,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-05 16:49:53','',''),(2173393,'1','142','798',342,'Retail Sale Id 1284453',8200.00,0.00,0.00,0.00,800.00,'2021-12-05 16:53:22','',''),(2173394,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:53:22','',''),(2173403,'1','142','798',342,'Retail Sale Id 1284457',3280.00,0.00,0.00,0.00,320.00,'2021-12-05 16:54:13','',''),(2173404,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 16:54:13','',''),(2173421,'1','142','798',342,'Retail Sale Id 1284467',701.92,0.00,0.00,0.00,68.48,'2021-12-05 16:55:24','',''),(2173422,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.07,0.00,'2021-12-05 16:55:24','',''),(2173455,'1','142','798',342,'Retail Sale Id 1284486',1902.40,0.00,0.00,0.00,185.60,'2021-12-05 16:57:17','',''),(2173456,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-05 16:57:17','',''),(2173467,'1','142','798',342,'Retail Sale Id 1284495',1502.24,0.00,0.00,0.00,146.56,'2021-12-05 16:58:24','',''),(2173468,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-05 16:58:24','',''),(2173481,'1','142','798',342,'Retail Sale Id 1284500',4500.16,0.00,0.00,0.00,439.04,'2021-12-05 16:59:19','',''),(2173482,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.86,0.00,'2021-12-05 16:59:19','',''),(2173584,'1','142','798',342,'Retail Sale Id 1284541',3280.00,0.00,0.00,0.00,320.00,'2021-12-05 17:05:29','',''),(2173585,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 17:05:29','',''),(2173670,'1','142','798',342,'Retail Sale Id 1284579',31500.00,0.00,0.00,0.00,1900.00,'2021-12-05 17:11:36','',''),(2173671,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 17:11:36','',''),(2173708,'1','142','798',342,'Retail Sale Id 1284598',1968.00,0.00,0.00,0.00,192.00,'2021-12-05 17:15:38','',''),(2173709,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 17:15:38','',''),(2174030,'1','142','798',342,'Retail Sale Id 1284758',153832.00,0.00,0.00,0.00,15008.00,'2021-12-05 17:46:04','',''),(2174031,'1','142','798',342,'Retail sales',0.00,0.00,0.00,234.50,0.00,'2021-12-05 17:46:04','',''),(2175278,'1','142','798',342,'Retail Sale Id 1285119',4998.72,0.00,0.00,0.00,487.68,'2021-12-06 06:56:43','',''),(2175279,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-06 06:56:43','',''),(2175361,'1','142','798',342,'Retail Sale Id 1285152',3280.00,0.00,0.00,0.00,320.00,'2021-12-06 06:59:55','',''),(2175362,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 06:59:55','',''),(2175782,'1','142','798',342,'Retail Sale Id 1285351',4998.72,0.00,0.00,0.00,487.68,'2021-12-06 07:26:14','',''),(2175783,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-06 07:26:14','',''),(2176055,'1','142','798',342,'Retail Sale Id 1285480',8200.00,0.00,0.00,0.00,800.00,'2021-12-06 07:41:43','',''),(2176056,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:41:43','',''),(2176139,'1','142','798',342,'Retail Sale Id 1285527',3936.00,0.00,0.00,0.00,384.00,'2021-12-06 07:45:23','',''),(2176140,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 07:45:23','',''),(2176292,'1','142','798',342,'Retail Sale Id 1285585',8200.00,0.00,0.00,0.00,800.00,'2021-12-06 07:52:13','',''),(2176293,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:52:13','',''),(2176357,'1','142','798',342,'Retail Sale Id 1285612',4001.60,0.00,0.00,0.00,390.40,'2021-12-06 07:54:37','',''),(2176358,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-06 07:54:37','',''),(2176431,'1','142','798',342,'Retail Sale Id 1285648',2000.80,0.00,0.00,0.00,195.20,'2021-12-06 07:57:37','',''),(2176432,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 07:57:37','',''),(2176487,'1','142','798',342,'Retail Sale Id 1285679',2801.12,0.00,0.00,0.00,273.28,'2021-12-06 08:00:35','',''),(2176488,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.27,0.00,'2021-12-06 08:00:35','',''),(2176706,'1','142','798',342,'Retail Sale Id 1285797',3936.00,0.00,0.00,0.00,384.00,'2021-12-06 08:13:46','',''),(2176707,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:13:46','',''),(2177003,'1','142','798',342,'Retail Sale Id 1285947',6999.52,0.00,0.00,0.00,682.88,'2021-12-06 08:38:21','',''),(2177004,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.67,0.00,'2021-12-06 08:38:21','',''),(2177066,'1','142','798',342,'Retail Sale Id 1285976',31500.00,0.00,0.00,0.00,1900.00,'2021-12-06 08:43:19','',''),(2177067,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 08:43:19','',''),(2177116,'1','142','798',342,'Retail Sale Id 1285999',2000.80,0.00,0.00,0.00,195.20,'2021-12-06 08:46:30','',''),(2177117,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 08:46:30','',''),(2177219,'1','142','798',342,'Retail Sale Id 1286055',1502.24,0.00,0.00,0.00,146.56,'2021-12-06 08:54:13','',''),(2177220,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-06 08:54:13','',''),(2177221,'1','142','798',342,'Retail Sale Id 1286055',1502.24,0.00,0.00,0.00,146.56,'2021-12-06 08:54:13','',''),(2177222,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-06 08:54:13','',''),(2177272,'1','142','798',342,'Retail Sale Id 1286078',2624.00,0.00,0.00,0.00,256.00,'2021-12-06 08:58:13','',''),(2177273,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 08:58:13','',''),(2177299,'1','142','798',342,'Retail Sale Id 1286091',1502.24,0.00,0.00,0.00,146.56,'2021-12-06 08:59:44','',''),(2177300,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-06 08:59:44','',''),(2177317,'1','142','798',342,'Retail Sale Id 1286099',3949.12,0.00,0.00,0.00,385.28,'2021-12-06 09:01:12','',''),(2177318,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 09:01:12','',''),(2177333,'1','142','798',342,'Retail Sale Id 1286107',4001.60,0.00,0.00,0.00,390.40,'2021-12-06 09:02:21','',''),(2177334,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-06 09:02:21','',''),(2177345,'1','142','798',342,'Retail Sale Id 1286114',2000.80,0.00,0.00,0.00,195.20,'2021-12-06 09:03:36','',''),(2177346,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 09:03:36','',''),(2177417,'1','142','798',342,'Retail Sale Id 1286144',34650.00,0.00,0.00,0.00,2090.00,'2021-12-06 09:07:35','',''),(2177418,'1','142','798',342,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-06 09:07:35','',''),(2177449,'1','142','798',342,'Retail Sale Id 1286153',4000.50,0.00,0.00,0.00,241.30,'2021-12-06 09:10:02','',''),(2177450,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.35,0.00,'2021-12-06 09:10:02','',''),(2177465,'1','142','798',342,'Retail Sale Id 1286167',2997.92,0.00,0.00,0.00,292.48,'2021-12-06 09:11:09','',''),(2177466,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-06 09:11:09','',''),(2177492,'1','142','798',342,'Retail Sale Id 1286180',4952.80,0.00,0.00,0.00,483.20,'2021-12-06 09:13:43','',''),(2177493,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.55,0.00,'2021-12-06 09:13:43','',''),(2177518,'1','142','798',342,'Retail Sale Id 1286190',4001.60,0.00,0.00,0.00,390.40,'2021-12-06 09:15:02','',''),(2177519,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-06 09:15:02','',''),(2177550,'1','142','798',342,'Retail Sale Id 1286204',1968.00,0.00,0.00,0.00,192.00,'2021-12-06 09:17:47','',''),(2177551,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 09:17:47','',''),(2177626,'1','142','798',342,'Retail Sale Id 1286242',3503.04,0.00,0.00,0.00,341.76,'2021-12-06 09:22:17','',''),(2177627,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-06 09:22:17','',''),(2177646,'1','142','798',342,'Retail Sale Id 1286250',2997.92,0.00,0.00,0.00,292.48,'2021-12-06 09:24:11','',''),(2177647,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-06 09:24:11','',''),(2177688,'1','142','798',342,'Retail Sale Id 1286270',4001.60,0.00,0.00,0.00,390.40,'2021-12-06 09:26:05','',''),(2177689,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-06 09:26:05','',''),(2177756,'1','142','798',342,'Retail Sale Id 1286297',1502.24,0.00,0.00,0.00,146.56,'2021-12-06 09:29:48','',''),(2177757,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-06 09:29:48','',''),(2177758,'1','142','798',342,'Retail Sale Id 1286297',1502.24,0.00,0.00,0.00,146.56,'2021-12-06 09:29:48','',''),(2177759,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-06 09:29:48','',''),(2177780,'1','142','798',342,'Retail Sale Id 1286317',6002.40,0.00,0.00,0.00,585.60,'2021-12-06 09:31:27','',''),(2177781,'1','142','798',342,'Retail sales',0.00,0.00,0.00,9.15,0.00,'2021-12-06 09:31:27','',''),(2177790,'1','142','798',342,'Retail Sale Id 1286321',1902.40,0.00,0.00,0.00,185.60,'2021-12-06 09:32:16','',''),(2177791,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 09:32:16','',''),(2177821,'1','142','798',342,'Retail Sale Id 1286329',6999.52,0.00,0.00,0.00,682.88,'2021-12-06 09:33:22','',''),(2177822,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.67,0.00,'2021-12-06 09:33:22','',''),(2177837,'1','142','798',342,'Retail Sale Id 1286338',1502.24,0.00,0.00,0.00,146.56,'2021-12-06 09:34:22','',''),(2177838,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-06 09:34:22','',''),(2177885,'1','142','798',342,'Retail Sale Id 1286344',6560.00,0.00,0.00,0.00,640.00,'2021-12-06 09:37:02','',''),(2177886,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 09:37:02','',''),(2177937,'1','142','798',342,'Retail Sale Id 1286361',3936.00,0.00,0.00,0.00,384.00,'2021-12-06 09:38:37','',''),(2177938,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 09:38:37','',''),(2178216,'1','142','798',342,'Retail Sale Id 1286504',4998.72,0.00,0.00,0.00,487.68,'2021-12-06 09:57:50','',''),(2178217,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-06 09:57:50','',''),(2178483,'1','142','798',342,'Retail Sale Id 1286620',8200.00,0.00,0.00,0.00,800.00,'2021-12-06 10:12:41','',''),(2178484,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:12:41','',''),(2178523,'1','142','798',342,'Retail Sale Id 1286648',286996.00,0.00,0.00,0.00,16452.00,'2021-12-06 10:15:33','',''),(2178524,'1','142','798',342,'Retail sales',0.00,0.00,0.00,457.00,0.00,'2021-12-06 10:15:33','',''),(2178587,'1','142','798',342,'Retail Sale Id 1286682',2000.80,0.00,0.00,0.00,195.20,'2021-12-06 10:20:16','',''),(2178588,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 10:20:16','',''),(2178633,'1','142','798',342,'Retail Sale Id 1286709',1968.00,0.00,0.00,0.00,192.00,'2021-12-06 10:23:45','',''),(2178634,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 10:23:45','',''),(2178663,'1','142','798',342,'Retail Sale Id 1286724',701.92,0.00,0.00,0.00,68.48,'2021-12-06 10:25:59','',''),(2178664,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.07,0.00,'2021-12-06 10:25:59','',''),(2178697,'1','142','798',342,'Retail Sale Id 1286739',1200.48,0.00,0.00,0.00,117.12,'2021-12-06 10:28:05','',''),(2178698,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.83,0.00,'2021-12-06 10:28:05','',''),(2178798,'1','142','798',342,'Retail Sale Id 1286788',701.92,0.00,0.00,0.00,68.48,'2021-12-06 10:34:33','',''),(2178799,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.07,0.00,'2021-12-06 10:34:33','',''),(2178880,'1','142','798',342,'Retail Sale Id 1286840',656.00,0.00,0.00,0.00,64.00,'2021-12-06 10:41:11','',''),(2178881,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-06 10:41:11','',''),(2178974,'1','142','798',342,'Retail Sale Id 1286888',2197.60,0.00,0.00,0.00,214.40,'2021-12-06 10:46:09','',''),(2178975,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.35,0.00,'2021-12-06 10:46:09','',''),(2178996,'1','142','798',342,'Retail Sale Id 1286899',2997.92,0.00,0.00,0.00,292.48,'2021-12-06 10:47:22','',''),(2178997,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-06 10:47:22','',''),(2179016,'1','142','798',342,'Retail Sale Id 1286917',2000.80,0.00,0.00,0.00,195.20,'2021-12-06 10:48:44','',''),(2179017,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 10:48:44','',''),(2179048,'1','142','798',342,'Retail Sale Id 1286938',997.12,0.00,0.00,0.00,97.28,'2021-12-06 10:50:23','',''),(2179049,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 10:50:23','',''),(2179092,'1','142','798',342,'Retail Sale Id 1286961',2000.80,0.00,0.00,0.00,195.20,'2021-12-06 10:53:18','',''),(2179093,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 10:53:18','',''),(2179249,'1','142','798',342,'Retail Sale Id 1287054',2000.80,0.00,0.00,0.00,195.20,'2021-12-06 11:03:23','',''),(2179250,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 11:03:23','',''),(2179287,'1','142','798',342,'Retail Sale Id 1287075',3299.68,0.00,0.00,0.00,321.92,'2021-12-06 11:05:19','',''),(2179288,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-06 11:05:19','',''),(2179375,'1','142','798',342,'Retail Sale Id 1287126',2499.36,0.00,0.00,0.00,243.84,'2021-12-06 11:10:49','',''),(2179376,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-06 11:10:49','',''),(2179467,'1','142','798',342,'Retail Sale Id 1287165',2000.80,0.00,0.00,0.00,195.20,'2021-12-06 11:15:53','',''),(2179468,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 11:15:53','',''),(2179607,'1','142','798',342,'Retail Sale Id 1287255',8200.00,0.00,0.00,0.00,800.00,'2021-12-06 11:25:05','',''),(2179608,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:25:05','',''),(2179653,'1','142','798',342,'Retail Sale Id 1287278',8200.00,0.00,0.00,0.00,800.00,'2021-12-06 11:28:11','',''),(2179654,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:28:11','',''),(2179687,'1','142','798',342,'Retail Sale Id 1287295',3968.80,0.00,0.00,0.00,387.20,'2021-12-06 11:30:39','',''),(2179688,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.05,0.00,'2021-12-06 11:30:39','',''),(2179910,'1','142','798',342,'Retail Sale Id 1287469',311850.00,0.00,0.00,0.00,18810.00,'2021-12-06 11:48:41','',''),(2179911,'1','142','798',342,'Retail sales',0.00,0.00,0.00,495.00,0.00,'2021-12-06 11:48:41','',''),(2179948,'1','142','798',342,'Retail Sale Id 1287491',3608.00,0.00,0.00,0.00,352.00,'2021-12-06 11:51:11','',''),(2179949,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-06 11:51:11','',''),(2180032,'1','142','798',342,'Retail Sale Id 1287531',3936.00,0.00,0.00,0.00,384.00,'2021-12-06 11:56:06','',''),(2180033,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 11:56:06','',''),(2180042,'1','142','798',342,'Retail Sale Id 1287539',6560.00,0.00,0.00,0.00,640.00,'2021-12-06 11:57:20','',''),(2180043,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 11:57:20','',''),(2180060,'1','142','798',342,'Retail Sale Id 1287548',3936.00,0.00,0.00,0.00,384.00,'2021-12-06 11:58:32','',''),(2180061,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 11:58:32','',''),(2180082,'1','142','798',342,'Retail Sale Id 1287560',3699.84,0.00,0.00,0.00,360.96,'2021-12-06 11:59:37','',''),(2180083,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.64,0.00,'2021-12-06 11:59:37','',''),(2180090,'1','142','798',342,'Retail Sale Id 1287564',3503.04,0.00,0.00,0.00,341.76,'2021-12-06 12:00:30','',''),(2180091,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-06 12:00:30','',''),(2180106,'1','142','798',342,'Retail Sale Id 1287570',1640.00,0.00,0.00,0.00,160.00,'2021-12-06 12:01:42','',''),(2180107,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 12:01:42','',''),(2180236,'1','142','798',342,'Retail Sale Id 1287638',3936.00,0.00,0.00,0.00,384.00,'2021-12-06 12:09:15','',''),(2180237,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:09:15','',''),(2180310,'1','142','798',342,'Retail Sale Id 1287687',11808.00,0.00,0.00,0.00,1152.00,'2021-12-06 12:13:51','',''),(2180311,'1','142','798',342,'Retail sales',0.00,0.00,0.00,18.00,0.00,'2021-12-06 12:13:51','',''),(2180422,'1','142','798',342,'Retail Sale Id 1287747',3936.00,0.00,0.00,0.00,384.00,'2021-12-06 12:19:34','',''),(2180423,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:19:34','',''),(2180528,'1','142','798',342,'Retail Sale Id 1287804',6560.00,0.00,0.00,0.00,640.00,'2021-12-06 12:27:32','',''),(2180529,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 12:27:32','',''),(2180576,'1','142','798',342,'Retail Sale Id 1287832',8200.00,0.00,0.00,0.00,800.00,'2021-12-06 12:30:38','',''),(2180577,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:30:38','',''),(2180602,'1','142','798',342,'Retail Sale Id 1287844',3936.00,0.00,0.00,0.00,384.00,'2021-12-06 12:32:07','',''),(2180603,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:32:07','',''),(2180619,'1','142','798',342,'Retail Sale Id 1287850',8200.00,0.00,0.00,0.00,800.00,'2021-12-06 12:32:51','',''),(2180620,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:32:51','',''),(2180639,'1','142','798',342,'Retail Sale Id 1287861',31500.00,0.00,0.00,0.00,1900.00,'2021-12-06 12:34:03','',''),(2180640,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 12:34:03','',''),(2180666,'1','142','798',342,'Retail Sale Id 1287874',125400.00,0.00,0.00,0.00,7000.00,'2021-12-06 12:35:37','',''),(2180667,'1','142','798',342,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-06 12:35:37','',''),(2180692,'1','142','798',342,'Retail Sale Id 1287890',7216.00,0.00,0.00,0.00,704.00,'2021-12-06 12:37:03','',''),(2180693,'1','142','798',342,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-06 12:37:03','',''),(2180780,'1','142','798',342,'Retail Sale Id 1287933',6560.00,0.00,0.00,0.00,640.00,'2021-12-06 12:42:48','',''),(2180781,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 12:42:48','',''),(2180918,'1','142','798',342,'Retail Sale Id 1288007',6999.52,0.00,0.00,0.00,682.88,'2021-12-06 12:51:30','',''),(2180919,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.67,0.00,'2021-12-06 12:51:30','',''),(2180941,'1','142','798',342,'Retail Sale Id 1288019',1970.00,0.00,0.00,0.00,1378.00,'2021-12-06 12:52:50','',''),(2180942,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-06 12:52:50','',''),(2180978,'1','142','798',342,'Retail Sale Id 1288037',3280.00,0.00,0.00,0.00,320.00,'2021-12-06 12:54:50','',''),(2180979,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:54:50','',''),(2181042,'1','142','798',342,'Return of Retail Sale Id 1288019',0.00,1970.00,1.00,0.00,-1378.00,'2021-12-06 12:58:26','',''),(2181063,'1','142','798',342,'Retail Sale Id 1288082',1968.00,0.00,0.00,0.00,192.00,'2021-12-06 12:59:27','',''),(2181064,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:59:27','',''),(2181312,'1','142','798',342,'Retail Sale Id 1288211',1502.24,0.00,0.00,0.00,146.56,'2021-12-06 13:13:37','',''),(2181313,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-06 13:13:37','',''),(2181764,'1','142','798',342,'Retail Sale Id 1288399',1968.00,0.00,0.00,0.00,192.00,'2021-12-06 13:39:21','',''),(2181765,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 13:39:21','',''),(2181798,'1','142','798',342,'Retail Sale Id 1288415',8200.00,0.00,0.00,0.00,800.00,'2021-12-06 13:40:29','',''),(2181799,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:40:29','',''),(2181828,'1','142','798',342,'Retail Sale Id 1288426',656.00,0.00,0.00,0.00,64.00,'2021-12-06 13:41:51','',''),(2181829,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-06 13:41:51','',''),(2181850,'1','142','798',342,'Retail Sale Id 1288434',3936.00,0.00,0.00,0.00,384.00,'2021-12-06 13:42:36','',''),(2181851,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 13:42:36','',''),(2181897,'1','142','798',342,'Retail Sale Id 1288454',3936.00,0.00,0.00,0.00,384.00,'2021-12-06 13:44:54','',''),(2181898,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 13:44:54','',''),(2181927,'1','142','798',342,'Retail Sale Id 1288470',3280.00,0.00,0.00,0.00,320.00,'2021-12-06 13:46:48','',''),(2181928,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 13:46:48','',''),(2181979,'1','142','798',342,'Retail Sale Id 1288493',997.12,0.00,0.00,0.00,97.28,'2021-12-06 13:49:05','',''),(2181980,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 13:49:05','',''),(2181981,'1','142','798',342,'Retail Sale Id 1288493',997.12,0.00,0.00,0.00,97.28,'2021-12-06 13:49:05','',''),(2181982,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 13:49:05','',''),(2182031,'1','142','798',342,'Retail Sale Id 1288519',3936.00,0.00,0.00,0.00,384.00,'2021-12-06 13:51:57','',''),(2182032,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 13:51:57','',''),(2182123,'1','142','798',342,'Retail Sale Id 1288566',8200.00,0.00,0.00,0.00,800.00,'2021-12-06 13:56:36','',''),(2182124,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:56:36','',''),(2182249,'1','142','798',342,'Retail Sale Id 1288617',997.12,0.00,0.00,0.00,97.28,'2021-12-06 14:01:46','',''),(2182250,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 14:01:46','',''),(2182279,'1','142','798',342,'Retail Sale Id 1288634',1968.00,0.00,0.00,0.00,192.00,'2021-12-06 14:03:22','',''),(2182280,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:03:22','',''),(2182315,'1','142','798',342,'Retail Sale Id 1288655',4998.72,0.00,0.00,0.00,487.68,'2021-12-06 14:05:24','',''),(2182316,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-06 14:05:24','',''),(2182317,'1','142','798',342,'Retail Sale Id 1288655',4998.72,0.00,0.00,0.00,487.68,'2021-12-06 14:05:24','',''),(2182318,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-06 14:05:24','',''),(2182357,'1','142','798',342,'Retail Sale Id 1288668',8200.00,0.00,0.00,0.00,800.00,'2021-12-06 14:06:56','',''),(2182358,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:06:56','',''),(2182377,'1','142','798',342,'Retail Sale Id 1288679',4001.60,0.00,0.00,0.00,390.40,'2021-12-06 14:08:16','',''),(2182378,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-06 14:08:16','',''),(2182539,'1','142','798',342,'Retail Sale Id 1288743',7698.60,0.00,0.00,0.00,464.36,'2021-12-06 14:15:08','',''),(2182540,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.22,0.00,'2021-12-06 14:15:08','',''),(2182628,'1','142','798',342,'Retail Sale Id 1288786',1968.00,0.00,0.00,0.00,192.00,'2021-12-06 14:19:12','',''),(2182629,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:19:12','',''),(2182698,'1','142','798',342,'Retail Sale Id 1288819',2499.36,0.00,0.00,0.00,243.84,'2021-12-06 14:22:29','',''),(2182699,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-06 14:22:29','',''),(2182768,'1','142','798',342,'Retail Sale Id 1288854',3280.00,0.00,0.00,0.00,320.00,'2021-12-06 14:26:31','',''),(2182769,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 14:26:31','',''),(2182796,'1','142','798',342,'Retail Sale Id 1288870',6560.00,0.00,0.00,0.00,640.00,'2021-12-06 14:28:11','',''),(2182797,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 14:28:11','',''),(2182840,'1','142','798',342,'Retail Sale Id 1288888',8600.16,0.00,0.00,0.00,839.04,'2021-12-06 14:31:00','',''),(2182841,'1','142','798',342,'Retail sales',0.00,0.00,0.00,13.11,0.00,'2021-12-06 14:31:00','',''),(2182862,'1','142','798',342,'Retail Sale Id 1288905',3608.00,0.00,0.00,0.00,352.00,'2021-12-06 14:32:02','',''),(2182863,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-06 14:32:02','',''),(2182883,'1','142','798',342,'Retail Sale Id 1288914',1797.44,0.00,0.00,0.00,175.36,'2021-12-06 14:33:10','',''),(2182884,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.74,0.00,'2021-12-06 14:33:10','',''),(2182909,'1','142','798',342,'Retail Sale Id 1288927',3936.00,0.00,0.00,0.00,384.00,'2021-12-06 14:34:10','',''),(2182910,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:34:10','',''),(2182932,'1','142','798',342,'Retail Sale Id 1288936',10168.00,0.00,0.00,0.00,992.00,'2021-12-06 14:35:28','',''),(2182933,'1','142','798',342,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-06 14:35:28','',''),(2182980,'1','142','798',342,'Retail Sale Id 1288960',800.32,0.00,0.00,0.00,78.08,'2021-12-06 14:38:31','',''),(2182981,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.22,0.00,'2021-12-06 14:38:31','',''),(2183006,'1','142','798',342,'Retail Sale Id 1288976',997.12,0.00,0.00,0.00,97.28,'2021-12-06 14:40:13','',''),(2183007,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 14:40:13','',''),(2183091,'1','142','798',342,'Retail Sale Id 1289001',997.12,0.00,0.00,0.00,97.28,'2021-12-06 14:43:23','',''),(2183092,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 14:43:23','',''),(2183383,'1','142','798',342,'Retail Sale Id 1289132',63000.00,0.00,0.00,0.00,3800.00,'2021-12-06 14:57:49','',''),(2183384,'1','142','798',342,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 14:57:49','',''),(2183391,'1','142','798',342,'Retail Sale Id 1289135',3936.00,0.00,0.00,0.00,384.00,'2021-12-06 14:58:26','',''),(2183392,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:58:26','',''),(2183421,'1','142','798',342,'Retail Sale Id 1289152',1699.04,0.00,0.00,0.00,165.76,'2021-12-06 15:00:04','',''),(2183422,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.59,0.00,'2021-12-06 15:00:04','',''),(2183441,'1','142','798',342,'Retail Sale Id 1289161',5904.00,0.00,0.00,0.00,576.00,'2021-12-06 15:01:17','',''),(2183442,'1','142','798',342,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-06 15:01:17','',''),(2185081,'1','142','798',342,'Retail Sale Id 1289886',5904.00,0.00,0.00,0.00,576.00,'2021-12-06 16:23:07','',''),(2185082,'1','142','798',342,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-06 16:23:07','',''),(2185183,'1','142','798',342,'Retail Sale Id 1289937',153615.00,0.00,0.00,0.00,8575.00,'2021-12-06 16:28:35','',''),(2185184,'1','142','798',342,'Retail sales',0.00,0.00,0.00,245.00,0.00,'2021-12-06 16:28:35','',''),(2185218,'1','142','798',342,'Retail Sale Id 1289956',15750.00,0.00,0.00,0.00,950.00,'2021-12-06 16:30:13','',''),(2185219,'1','142','798',342,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 16:30:13','',''),(2185272,'1','142','798',342,'Retail Sale Id 1289984',3280.00,0.00,0.00,0.00,320.00,'2021-12-06 16:32:50','',''),(2185273,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 16:32:50','',''),(2185312,'1','142','798',342,'Retail Sale Id 1290001',997.12,0.00,0.00,0.00,97.28,'2021-12-06 16:34:49','',''),(2185313,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 16:34:49','',''),(2185364,'1','142','798',342,'Retail Sale Id 1290027',2624.00,0.00,0.00,0.00,256.00,'2021-12-06 16:37:36','',''),(2185365,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 16:37:36','',''),(2185446,'1','142','798',342,'Retail Sale Id 1290061',1298.88,0.00,0.00,0.00,126.72,'2021-12-06 16:42:17','',''),(2185447,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.98,0.00,'2021-12-06 16:42:17','',''),(2185478,'1','142','798',342,'Retail Sale Id 1290080',1502.24,0.00,0.00,0.00,146.56,'2021-12-06 16:44:28','',''),(2185479,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-06 16:44:28','',''),(2185525,'1','142','798',342,'Retail Sale Id 1290102',8200.00,0.00,0.00,0.00,800.00,'2021-12-06 16:47:15','',''),(2185526,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:47:15','',''),(2185555,'1','142','798',342,'Retail Sale Id 1290114',997.12,0.00,0.00,0.00,97.28,'2021-12-06 16:48:03','',''),(2185556,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 16:48:03','',''),(2185575,'1','142','798',342,'Retail Sale Id 1290124',2000.80,0.00,0.00,0.00,195.20,'2021-12-06 16:48:47','',''),(2185576,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 16:48:47','',''),(2185585,'1','142','798',342,'Retail Sale Id 1290130',8200.00,0.00,0.00,0.00,800.00,'2021-12-06 16:49:24','',''),(2185586,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:49:24','',''),(2185601,'1','142','798',342,'Retail Sale Id 1290138',6560.00,0.00,0.00,0.00,640.00,'2021-12-06 16:50:05','',''),(2185602,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 16:50:05','',''),(2185616,'1','142','798',342,'Retail Sale Id 1290145',997.12,0.00,0.00,0.00,97.28,'2021-12-06 16:50:51','',''),(2185617,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 16:50:51','',''),(2185655,'1','142','798',342,'Retail Sale Id 1290163',3280.00,0.00,0.00,0.00,320.00,'2021-12-06 16:52:43','',''),(2185656,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 16:52:43','',''),(2185672,'1','142','798',342,'Retail Sale Id 1290173',3798.24,0.00,0.00,0.00,370.56,'2021-12-06 16:53:47','',''),(2185673,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.79,0.00,'2021-12-06 16:53:47','',''),(2185686,'1','142','798',342,'Retail Sale Id 1290182',997.12,0.00,0.00,0.00,97.28,'2021-12-06 16:54:58','',''),(2185687,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 16:54:58','',''),(2185702,'1','142','798',342,'Retail Sale Id 1290194',2499.36,0.00,0.00,0.00,243.84,'2021-12-06 16:55:56','',''),(2185703,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-06 16:55:56','',''),(2185724,'1','142','798',342,'Retail Sale Id 1290203',1640.00,0.00,0.00,0.00,160.00,'2021-12-06 16:57:23','',''),(2185725,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 16:57:23','',''),(2185762,'1','142','798',342,'Retail Sale Id 1290225',3299.68,0.00,0.00,0.00,321.92,'2021-12-06 17:00:07','',''),(2185763,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-06 17:00:07','',''),(2185782,'1','142','798',342,'Retail Sale Id 1290236',2000.80,0.00,0.00,0.00,195.20,'2021-12-06 17:01:23','',''),(2185783,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 17:01:23','',''),(2185788,'1','142','798',342,'Retail Sale Id 1290241',4920.00,0.00,0.00,0.00,480.00,'2021-12-06 17:02:05','',''),(2185789,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.50,0.00,'2021-12-06 17:02:05','',''),(2185804,'1','142','798',342,'Retail Sale Id 1290249',3903.20,0.00,0.00,0.00,380.80,'2021-12-06 17:03:02','',''),(2185805,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.95,0.00,'2021-12-06 17:03:02','',''),(2185840,'1','142','798',342,'Retail Sale Id 1290269',1298.88,0.00,0.00,0.00,126.72,'2021-12-06 17:05:55','',''),(2185841,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.98,0.00,'2021-12-06 17:05:55','',''),(2185863,'1','142','798',342,'Retail Sale Id 1290278',4001.60,0.00,0.00,0.00,390.40,'2021-12-06 17:07:01','',''),(2185864,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-06 17:07:01','',''),(2185879,'1','142','798',342,'Retail Sale Id 1290287',2899.52,0.00,0.00,0.00,282.88,'2021-12-06 17:08:09','',''),(2185880,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.42,0.00,'2021-12-06 17:08:09','',''),(2185891,'1','142','798',342,'Retail Sale Id 1290292',2997.92,0.00,0.00,0.00,292.48,'2021-12-06 17:09:00','',''),(2185892,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-06 17:09:00','',''),(2185913,'1','142','798',342,'Retail Sale Id 1290305',6500.96,0.00,0.00,0.00,634.24,'2021-12-06 17:10:24','',''),(2185914,'1','142','798',342,'Retail sales',0.00,0.00,0.00,9.91,0.00,'2021-12-06 17:10:24','',''),(2185935,'1','142','798',342,'Retail Sale Id 1290318',3936.00,0.00,0.00,0.00,384.00,'2021-12-06 17:11:55','',''),(2185936,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 17:11:55','',''),(2185963,'1','142','798',342,'Retail Sale Id 1290334',1902.40,0.00,0.00,0.00,185.60,'2021-12-06 17:13:28','',''),(2185964,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 17:13:28','',''),(2185993,'1','142','798',342,'Retail Sale Id 1290349',1902.40,0.00,0.00,0.00,185.60,'2021-12-06 17:16:03','',''),(2185994,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-06 17:16:03','',''),(2186106,'1','142','798',342,'Retail Sale Id 1290407',1502.24,0.00,0.00,0.00,146.56,'2021-12-06 17:27:20','',''),(2186107,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-06 17:27:20','',''),(2186164,'1','142','798',342,'Retail Sale Id 1290429',1502.24,0.00,0.00,0.00,146.56,'2021-12-06 17:31:17','',''),(2186165,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-06 17:31:17','',''),(2186247,'1','142','798',342,'Retail Sale Id 1290471',117227.20,0.00,0.00,0.00,11436.80,'2021-12-06 17:41:11','',''),(2186248,'1','142','798',342,'Retail sales',0.00,0.00,0.00,178.70,0.00,'2021-12-06 17:41:11','',''),(2186273,'1','142','798',342,'Retail Sale Id 1290505',3673.60,0.00,0.00,0.00,358.40,'2021-12-06 17:45:44','',''),(2186274,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.60,0.00,'2021-12-06 17:45:44','',''),(2186504,'1','142',NULL,342,'Reception corrector for bridging 126401',0.00,0.00,0.00,8000.00,0.00,'2021-12-06 18:27:58','',''),(2186505,'1','142','798',342,'Received from bridging 126401',0.00,0.00,8000.00,0.00,0.00,'2021-12-06 18:27:58','',''),(2187724,'1','142','798',342,'Retail Sale Id 1290956',378708.00,0.00,0.00,0.00,21140.00,'2021-12-07 06:48:12','',''),(2187725,'1','142','798',342,'Retail sales',0.00,0.00,0.00,604.00,0.00,'2021-12-07 06:48:12','',''),(2187786,'1','142','798',342,'Retail Sale Id 1290974',832969.50,0.00,0.00,0.00,46497.50,'2021-12-07 06:51:13','',''),(2187787,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1328.50,0.00,'2021-12-07 06:51:13','',''),(2188076,'1','142','798',342,'Retail Sale Id 1291112',6560.00,0.00,0.00,0.00,640.00,'2021-12-07 07:07:16','',''),(2188077,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 07:07:16','',''),(2188316,'1','142','798',342,'Retail Sale Id 1291231',3503.04,0.00,0.00,0.00,341.76,'2021-12-07 07:18:24','',''),(2188317,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-07 07:18:24','',''),(2188364,'1','142','798',342,'Retail Sale Id 1291257',3503.04,0.00,0.00,0.00,341.76,'2021-12-07 07:20:33','',''),(2188365,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-07 07:20:33','',''),(2188410,'1','142','798',342,'Retail Sale Id 1291282',4998.72,0.00,0.00,0.00,487.68,'2021-12-07 07:22:52','',''),(2188411,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-07 07:22:52','',''),(2188536,'1','142','798',342,'Retail Sale Id 1291339',2302.56,0.00,0.00,0.00,224.64,'2021-12-07 07:28:44','',''),(2188537,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.51,0.00,'2021-12-07 07:28:44','',''),(2188628,'1','142','798',342,'Retail Sale Id 1291387',1968.00,0.00,0.00,0.00,192.00,'2021-12-07 07:32:29','',''),(2188629,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:32:29','',''),(2188654,'1','142','798',342,'Retail Sale Id 1291405',997.12,0.00,0.00,0.00,97.28,'2021-12-07 07:34:15','',''),(2188655,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 07:34:15','',''),(2188692,'1','142','798',342,'Retail Sale Id 1291422',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 07:36:06','',''),(2188693,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 07:36:06','',''),(2188738,'1','142','798',342,'Retail Sale Id 1291445',4998.72,0.00,0.00,0.00,487.68,'2021-12-07 07:38:05','',''),(2188739,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-07 07:38:05','',''),(2188794,'1','142','798',342,'Retail Sale Id 1291473',2702.72,0.00,0.00,0.00,263.68,'2021-12-07 07:41:07','',''),(2188795,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.12,0.00,'2021-12-07 07:41:07','',''),(2188872,'1','142','798',342,'Retail Sale Id 1291531',3936.00,0.00,0.00,0.00,384.00,'2021-12-07 07:45:17','',''),(2188873,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 07:45:17','',''),(2188910,'1','142','798',342,'Retail Sale Id 1291557',2997.92,0.00,0.00,0.00,292.48,'2021-12-07 07:47:35','',''),(2188911,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 07:47:35','',''),(2189065,'1','142','798',342,'Retail Sale Id 1291630',2296.00,0.00,0.00,0.00,224.00,'2021-12-07 07:56:03','',''),(2189066,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-07 07:56:03','',''),(2189247,'1','142','798',342,'Retail Sale Id 1291722',4998.72,0.00,0.00,0.00,487.68,'2021-12-07 08:07:02','',''),(2189248,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-07 08:07:02','',''),(2189308,'1','142','798',342,'Retail Sale Id 1291741',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 08:09:08','',''),(2189309,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 08:09:08','',''),(2189353,'1','142','798',342,'Retail Sale Id 1291762',3503.04,0.00,0.00,0.00,341.76,'2021-12-07 08:11:43','',''),(2189354,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-07 08:11:43','',''),(2189527,'1','142','798',342,'Retail Sale Id 1291851',144210.00,0.00,0.00,0.00,8050.00,'2021-12-07 08:22:08','',''),(2189528,'1','142','798',342,'Retail sales',0.00,0.00,0.00,230.00,0.00,'2021-12-07 08:22:08','',''),(2189599,'1','142','798',342,'Retail Sale Id 1291883',2997.92,0.00,0.00,0.00,292.48,'2021-12-07 08:26:39','',''),(2189600,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 08:26:39','',''),(2189687,'1','142','798',342,'Retail Sale Id 1291928',3936.00,0.00,0.00,0.00,384.00,'2021-12-07 08:33:19','',''),(2189688,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 08:33:19','',''),(2189862,'1','142','798',342,'Retail Sale Id 1291984',8003.20,0.00,0.00,0.00,780.80,'2021-12-07 08:40:11','',''),(2189863,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-07 08:40:11','',''),(2190011,'1','142','798',342,'Retail Sale Id 1292044',3280.00,0.00,0.00,0.00,320.00,'2021-12-07 08:47:27','',''),(2190012,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 08:47:27','',''),(2190084,'1','142','798',342,'Retail Sale Id 1292084',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 08:50:34','',''),(2190085,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 08:50:34','',''),(2190230,'1','142','798',342,'Retail Sale Id 1292155',3936.00,0.00,0.00,0.00,384.00,'2021-12-07 08:59:51','',''),(2190231,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 08:59:51','',''),(2190291,'1','142','798',342,'Retail Sale Id 1292188',1968.00,0.00,0.00,0.00,192.00,'2021-12-07 09:04:39','',''),(2190292,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:04:39','',''),(2190375,'1','142','798',342,'Retail Sale Id 1292224',42009.00,0.00,0.00,0.00,2345.00,'2021-12-07 09:08:50','',''),(2190376,'1','142','798',342,'Retail sales',0.00,0.00,0.00,67.00,0.00,'2021-12-07 09:08:50','',''),(2190419,'1','142','798',342,'Retail Sale Id 1292249',2499.36,0.00,0.00,0.00,243.84,'2021-12-07 09:11:07','',''),(2190420,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-07 09:11:07','',''),(2190493,'1','142','798',342,'Retail Sale Id 1292286',3280.00,0.00,0.00,0.00,320.00,'2021-12-07 09:14:53','',''),(2190494,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 09:14:53','',''),(2190607,'1','142','798',342,'Retail Sale Id 1292346',3936.00,0.00,0.00,0.00,384.00,'2021-12-07 09:21:03','',''),(2190608,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 09:21:03','',''),(2190707,'1','142','798',342,'Retail Sale Id 1292389',2997.92,0.00,0.00,0.00,292.48,'2021-12-07 09:26:37','',''),(2190708,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 09:26:37','',''),(2190764,'1','142','798',342,'Retail Sale Id 1292409',1200.48,0.00,0.00,0.00,117.12,'2021-12-07 09:28:43','',''),(2190765,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.83,0.00,'2021-12-07 09:28:43','',''),(2190870,'1','142','798',342,'Retail Sale Id 1292466',8200.00,0.00,0.00,0.00,800.00,'2021-12-07 09:33:22','',''),(2190871,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:33:22','',''),(2190908,'1','142','798',342,'Retail Sale Id 1292483',3280.00,0.00,0.00,0.00,320.00,'2021-12-07 09:35:29','',''),(2190909,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 09:35:29','',''),(2190954,'1','142','798',342,'Retail Sale Id 1292509',3280.00,0.00,0.00,0.00,320.00,'2021-12-07 09:38:28','',''),(2190955,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 09:38:28','',''),(2191012,'1','142','798',342,'Retail Sale Id 1292535',1318.56,0.00,0.00,0.00,128.64,'2021-12-07 09:41:25','',''),(2191013,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-07 09:41:25','',''),(2191044,'1','142','798',342,'Retail Sale Id 1292558',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 09:43:22','',''),(2191045,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 09:43:22','',''),(2191122,'1','142','798',342,'Retail Sale Id 1292599',1968.00,0.00,0.00,0.00,192.00,'2021-12-07 09:49:54','',''),(2191123,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:49:54','',''),(2191156,'1','142','798',342,'Retail Sale Id 1292615',2997.92,0.00,0.00,0.00,292.48,'2021-12-07 09:51:40','',''),(2191157,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 09:51:40','',''),(2191260,'1','142','798',342,'Retail Sale Id 1292669',1968.00,0.00,0.00,0.00,192.00,'2021-12-07 09:59:29','',''),(2191261,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:59:29','',''),(2191345,'1','142','798',342,'Retail Sale Id 1292714',3280.00,0.00,0.00,0.00,320.00,'2021-12-07 10:04:44','',''),(2191346,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 10:04:44','',''),(2191535,'1','142','798',342,'Retail Sale Id 1292815',2997.92,0.00,0.00,0.00,292.48,'2021-12-07 10:17:08','',''),(2191536,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 10:17:08','',''),(2191583,'1','142','798',342,'Retail Sale Id 1292839',8200.00,0.00,0.00,0.00,800.00,'2021-12-07 10:20:55','',''),(2191584,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:20:55','',''),(2191657,'1','142','798',342,'Retail Sale Id 1292876',12600.00,0.00,0.00,0.00,760.00,'2021-12-07 10:26:43','',''),(2191658,'1','142','798',342,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-07 10:26:43','',''),(2191720,'1','142','798',342,'Retail Sale Id 1292906',1968.00,0.00,0.00,0.00,192.00,'2021-12-07 10:32:24','',''),(2191721,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:32:24','',''),(2191745,'1','142','798',342,'Retail Sale Id 1292919',997.12,0.00,0.00,0.00,97.28,'2021-12-07 10:34:22','',''),(2191746,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 10:34:22','',''),(2191847,'1','142','798',342,'Retail Sale Id 1292972',8003.20,0.00,0.00,0.00,780.80,'2021-12-07 10:40:45','',''),(2191848,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-07 10:40:45','',''),(2191875,'1','142','798',342,'Retail Sale Id 1292989',997.12,0.00,0.00,0.00,97.28,'2021-12-07 10:42:29','',''),(2191876,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 10:42:29','',''),(2191927,'1','142','798',342,'Retail Sale Id 1293010',5497.28,0.00,0.00,0.00,536.32,'2021-12-07 10:44:46','',''),(2191928,'1','142','798',342,'Retail sales',0.00,0.00,0.00,8.38,0.00,'2021-12-07 10:44:46','',''),(2191992,'1','142','798',342,'Retail Sale Id 1293030',3280.00,0.00,0.00,0.00,320.00,'2021-12-07 10:47:46','',''),(2191993,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 10:47:46','',''),(2192221,'1','142','798',342,'Retail Sale Id 1293149',3280.00,0.00,0.00,0.00,320.00,'2021-12-07 11:00:16','',''),(2192222,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 11:00:16','',''),(2192284,'1','142','798',342,'Retail Sale Id 1293164',997.12,0.00,0.00,0.00,97.28,'2021-12-07 11:02:26','',''),(2192285,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 11:02:26','',''),(2192542,'1','142','798',342,'Retail Sale Id 1293309',2997.92,0.00,0.00,0.00,292.48,'2021-12-07 11:16:41','',''),(2192543,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 11:16:41','',''),(2192626,'1','142','798',342,'Retail Sale Id 1293373',2997.92,0.00,0.00,0.00,292.48,'2021-12-07 11:23:12','',''),(2192627,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 11:23:12','',''),(2192654,'1','142','798',342,'Retail Sale Id 1293392',3968.80,0.00,0.00,0.00,387.20,'2021-12-07 11:25:20','',''),(2192655,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.05,0.00,'2021-12-07 11:25:20','',''),(2192745,'1','142','798',342,'Retail Sale Id 1293434',2499.36,0.00,0.00,0.00,243.84,'2021-12-07 11:30:40','',''),(2192746,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-07 11:30:40','',''),(2192807,'1','142','798',342,'Retail Sale Id 1293465',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 11:36:35','',''),(2192808,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 11:36:35','',''),(2192839,'1','142','798',342,'Retail Sale Id 1293484',6560.00,0.00,0.00,0.00,640.00,'2021-12-07 11:38:58','',''),(2192840,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 11:38:58','',''),(2192887,'1','142','798',342,'Retail Sale Id 1293512',8200.00,0.00,0.00,0.00,800.00,'2021-12-07 11:41:54','',''),(2192888,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:41:54','',''),(2192959,'1','142','798',342,'Retail Sale Id 1293532',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 11:45:15','',''),(2192960,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 11:45:15','',''),(2193069,'1','142','798',342,'Retail Sale Id 1293598',8200.00,0.00,0.00,0.00,800.00,'2021-12-07 11:55:48','',''),(2193070,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:55:48','',''),(2193109,'1','142','798',342,'Retail Sale Id 1293616',7498.08,0.00,0.00,0.00,731.52,'2021-12-07 11:58:52','',''),(2193110,'1','142','798',342,'Retail sales',0.00,0.00,0.00,11.43,0.00,'2021-12-07 11:58:52','',''),(2193197,'1','142','798',342,'Retail Sale Id 1293670',31500.00,0.00,0.00,0.00,1900.00,'2021-12-07 12:08:54','',''),(2193198,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 12:08:54','',''),(2193239,'1','142','798',342,'Retail Sale Id 1293690',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 12:11:35','',''),(2193240,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 12:11:35','',''),(2193267,'1','142','798',342,'Retail Sale Id 1293704',4001.60,0.00,0.00,0.00,390.40,'2021-12-07 12:13:18','',''),(2193268,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-07 12:13:18','',''),(2193293,'1','142','798',342,'Retail Sale Id 1293718',997.12,0.00,0.00,0.00,97.28,'2021-12-07 12:15:49','',''),(2193294,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 12:15:49','',''),(2193313,'1','142','798',342,'Retail Sale Id 1293730',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 12:17:36','',''),(2193314,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 12:17:36','',''),(2193555,'1','142','798',342,'Retail Sale Id 1293861',656.00,0.00,0.00,0.00,64.00,'2021-12-07 12:38:29','',''),(2193556,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 12:38:29','',''),(2193591,'1','142','798',342,'Retail Sale Id 1293879',4998.72,0.00,0.00,0.00,487.68,'2021-12-07 12:41:50','',''),(2193592,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-07 12:41:50','',''),(2193593,'1','142','798',342,'Retail Sale Id 1293879',4998.72,0.00,0.00,0.00,487.68,'2021-12-07 12:41:50','',''),(2193594,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-07 12:41:50','',''),(2193629,'1','142','798',342,'Retail Sale Id 1293897',31500.00,0.00,0.00,0.00,1900.00,'2021-12-07 12:44:55','',''),(2193630,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 12:44:55','',''),(2193759,'1','142','798',342,'Retail Sale Id 1293979',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 12:52:59','',''),(2193760,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 12:52:59','',''),(2193859,'1','142','798',342,'Retail Sale Id 1294034',997.12,0.00,0.00,0.00,97.28,'2021-12-07 12:59:33','',''),(2193860,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 12:59:33','',''),(2193944,'1','142','798',342,'Retail Sale Id 1294068',31350.00,0.00,0.00,0.00,1750.00,'2021-12-07 13:05:06','',''),(2193945,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 13:05:06','',''),(2194007,'1','142','798',342,'Return of Retail Sale Id 1293897',0.00,31500.00,50.00,0.00,-1900.00,'2021-12-07 13:10:11','',''),(2194025,'1','142','798',342,'Retail Sale Id 1294108',8200.00,0.00,0.00,0.00,800.00,'2021-12-07 13:11:17','',''),(2194026,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:11:17','',''),(2194123,'1','142','798',342,'Retail Sale Id 1294161',2997.92,0.00,0.00,0.00,292.48,'2021-12-07 13:16:43','',''),(2194124,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 13:16:43','',''),(2194204,'1','142','798',342,'Retail Sale Id 1294238',2997.92,0.00,0.00,0.00,292.48,'2021-12-07 13:23:57','',''),(2194205,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 13:23:57','',''),(2194245,'1','142','798',342,'Retail Sale Id 1294283',3936.00,0.00,0.00,0.00,384.00,'2021-12-07 13:25:02','',''),(2194246,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 13:25:02','',''),(2194276,'1','142','798',342,'Retail Sale Id 1294290',701.92,0.00,0.00,0.00,68.48,'2021-12-07 13:25:56','',''),(2194277,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.07,0.00,'2021-12-07 13:25:56','',''),(2194300,'1','142','798',342,'Retail Sale Id 1294299',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 13:27:12','',''),(2194301,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 13:27:12','',''),(2194330,'1','142','798',342,'Retail Sale Id 1294339',3503.04,0.00,0.00,0.00,341.76,'2021-12-07 13:28:23','',''),(2194331,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-07 13:28:23','',''),(2194365,'1','142','798',342,'Retail Sale Id 1294350',4001.60,0.00,0.00,0.00,390.40,'2021-12-07 13:29:42','',''),(2194366,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-07 13:29:42','',''),(2194402,'1','142','798',342,'Retail Sale Id 1294359',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 13:31:04','',''),(2194403,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 13:31:04','',''),(2194423,'1','142','798',342,'Retail Sale Id 1294365',4001.60,0.00,0.00,0.00,390.40,'2021-12-07 13:32:21','',''),(2194424,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-07 13:32:21','',''),(2194441,'1','142','798',342,'Retail Sale Id 1294373',3936.00,0.00,0.00,0.00,384.00,'2021-12-07 13:33:38','',''),(2194442,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 13:33:38','',''),(2194463,'1','142','798',342,'Retail Sale Id 1294383',1502.24,0.00,0.00,0.00,146.56,'2021-12-07 13:34:53','',''),(2194464,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-07 13:34:53','',''),(2194491,'1','142','798',342,'Retail Sale Id 1294397',7498.08,0.00,0.00,0.00,731.52,'2021-12-07 13:36:35','',''),(2194492,'1','142','798',342,'Retail sales',0.00,0.00,0.00,11.43,0.00,'2021-12-07 13:36:35','',''),(2194553,'1','142','798',342,'Retail Sale Id 1294410',1968.00,0.00,0.00,0.00,192.00,'2021-12-07 13:39:22','',''),(2194554,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 13:39:22','',''),(2194583,'1','142','798',342,'Retail Sale Id 1294434',1200.48,0.00,0.00,0.00,117.12,'2021-12-07 13:41:26','',''),(2194584,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.83,0.00,'2021-12-07 13:41:26','',''),(2194829,'1','142','798',342,'Retail Sale Id 1294549',98400.00,0.00,0.00,0.00,9600.00,'2021-12-07 13:57:13','',''),(2194830,'1','142','798',342,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-07 13:57:13','',''),(2194861,'1','142','798',342,'Retail Sale Id 1294565',1312.00,0.00,0.00,0.00,128.00,'2021-12-07 13:59:42','',''),(2194862,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 13:59:42','',''),(2194887,'1','142','798',342,'Retail Sale Id 1294578',17384.00,0.00,0.00,0.00,1696.00,'2021-12-07 14:01:25','',''),(2194888,'1','142','798',342,'Retail sales',0.00,0.00,0.00,26.50,0.00,'2021-12-07 14:01:25','',''),(2194941,'1','142','798',342,'Retail Sale Id 1294609',997.12,0.00,0.00,0.00,97.28,'2021-12-07 14:05:31','',''),(2194942,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 14:05:31','',''),(2195013,'1','142','798',342,'Retail Sale Id 1294642',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 14:09:22','',''),(2195014,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 14:09:22','',''),(2195063,'1','142','798',342,'Retail Sale Id 1294661',1968.00,0.00,0.00,0.00,192.00,'2021-12-07 14:11:35','',''),(2195064,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 14:11:35','',''),(2195101,'1','142','798',342,'Retail Sale Id 1294677',3936.00,0.00,0.00,0.00,384.00,'2021-12-07 14:13:17','',''),(2195102,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 14:13:17','',''),(2195370,'1','142','798',342,'Retail Sale Id 1294788',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 14:27:30','',''),(2195371,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 14:27:30','',''),(2195416,'1','142','798',342,'Retail Sale Id 1294806',3936.00,0.00,0.00,0.00,384.00,'2021-12-07 14:29:30','',''),(2195417,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 14:29:30','',''),(2195515,'1','142','798',342,'Retail Sale Id 1294872',1102.08,0.00,0.00,0.00,107.52,'2021-12-07 14:36:11','',''),(2195516,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.68,0.00,'2021-12-07 14:36:11','',''),(2195543,'1','142','798',342,'Retail Sale Id 1294887',800.32,0.00,0.00,0.00,78.08,'2021-12-07 14:37:45','',''),(2195544,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.22,0.00,'2021-12-07 14:37:45','',''),(2195569,'1','142','798',342,'Retail Sale Id 1294899',3936.00,0.00,0.00,0.00,384.00,'2021-12-07 14:39:26','',''),(2195570,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 14:39:26','',''),(2195589,'1','142','798',342,'Retail Sale Id 1294912',6560.00,0.00,0.00,0.00,640.00,'2021-12-07 14:40:53','',''),(2195590,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 14:40:53','',''),(2195617,'1','142','798',342,'Retail Sale Id 1294924',4001.60,0.00,0.00,0.00,390.40,'2021-12-07 14:42:04','',''),(2195618,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-07 14:42:04','',''),(2195645,'1','142','798',342,'Retail Sale Id 1294939',2997.92,0.00,0.00,0.00,292.48,'2021-12-07 14:43:13','',''),(2195646,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 14:43:13','',''),(2195798,'1','142','798',342,'Retail Sale Id 1295014',8200.00,0.00,0.00,0.00,800.00,'2021-12-07 14:50:19','',''),(2195799,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:50:19','',''),(2195832,'1','142','798',342,'Retail Sale Id 1295032',1502.24,0.00,0.00,0.00,146.56,'2021-12-07 14:51:59','',''),(2195833,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-07 14:51:59','',''),(2195908,'1','142','798',342,'Retail Sale Id 1295076',232360.00,0.00,0.00,0.00,13320.00,'2021-12-07 14:57:01','',''),(2195909,'1','142','798',342,'Retail sales',0.00,0.00,0.00,370.00,0.00,'2021-12-07 14:57:01','',''),(2195974,'1','142','798',342,'Retail Sale Id 1295107',2997.92,0.00,0.00,0.00,292.48,'2021-12-07 15:01:27','',''),(2195975,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 15:01:27','',''),(2196028,'1','142','798',342,'Retail Sale Id 1295125',1397.28,0.00,0.00,0.00,136.32,'2021-12-07 15:04:16','',''),(2196029,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.13,0.00,'2021-12-07 15:04:16','',''),(2196056,'1','142','798',342,'Retail Sale Id 1295141',8200.00,0.00,0.00,0.00,800.00,'2021-12-07 15:06:13','',''),(2196057,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:06:13','',''),(2196078,'1','142','798',342,'Retail Sale Id 1295150',2997.92,0.00,0.00,0.00,292.48,'2021-12-07 15:07:15','',''),(2196079,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 15:07:15','',''),(2196096,'1','142','798',342,'Retail Sale Id 1295161',997.12,0.00,0.00,0.00,97.28,'2021-12-07 15:08:23','',''),(2196097,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 15:08:23','',''),(2196118,'1','142','798',342,'Retail Sale Id 1295172',8200.00,0.00,0.00,0.00,800.00,'2021-12-07 15:09:17','',''),(2196119,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:09:17','',''),(2196132,'1','142','798',342,'Retail Sale Id 1295181',3280.00,0.00,0.00,0.00,320.00,'2021-12-07 15:10:01','',''),(2196133,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 15:10:01','',''),(2196150,'1','142','798',342,'Retail Sale Id 1295191',997.12,0.00,0.00,0.00,97.28,'2021-12-07 15:10:59','',''),(2196151,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 15:10:59','',''),(2196186,'1','142','798',342,'Retail Sale Id 1295207',1200.48,0.00,0.00,0.00,117.12,'2021-12-07 15:12:26','',''),(2196187,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.83,0.00,'2021-12-07 15:12:26','',''),(2196238,'1','142','798',342,'Retail Sale Id 1295231',3936.00,0.00,0.00,0.00,384.00,'2021-12-07 15:15:09','',''),(2196239,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:15:09','',''),(2196240,'1','142','798',342,'Retail Sale Id 1295231',4001.60,0.00,0.00,0.00,390.40,'2021-12-07 15:15:09','',''),(2196241,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-07 15:15:09','',''),(2196312,'1','142','798',342,'Retail Sale Id 1295268',1318.56,0.00,0.00,0.00,128.64,'2021-12-07 15:19:21','',''),(2196313,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-07 15:19:21','',''),(2196330,'1','142','798',342,'Retail Sale Id 1295276',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 15:20:21','',''),(2196331,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 15:20:21','',''),(2196356,'1','142','798',342,'Retail Sale Id 1295290',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 15:21:40','',''),(2196357,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 15:21:40','',''),(2196596,'1','142','798',342,'Retail Sale Id 1295416',1397.28,0.00,0.00,0.00,136.32,'2021-12-07 15:33:22','',''),(2196597,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.13,0.00,'2021-12-07 15:33:22','',''),(2196622,'1','142','798',342,'Retail Sale Id 1295429',997.12,0.00,0.00,0.00,97.28,'2021-12-07 15:35:04','',''),(2196623,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 15:35:04','',''),(2196662,'1','142','798',342,'Retail Sale Id 1295453',1968.00,0.00,0.00,0.00,192.00,'2021-12-07 15:36:58','',''),(2196663,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:36:58','',''),(2196699,'1','142','798',342,'Retail Sale Id 1295466',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 15:38:26','',''),(2196700,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 15:38:26','',''),(2196754,'1','142','798',342,'Return of Retail Sale Id 1295466',0.00,2000.80,3.05,0.00,-195.20,'2021-12-07 15:40:03','',''),(2196763,'1','142','798',342,'Retail Sale Id 1295493',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 15:40:37','',''),(2196764,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 15:40:37','',''),(2196791,'1','142','798',342,'Retail Sale Id 1295507',8200.00,0.00,0.00,0.00,800.00,'2021-12-07 15:42:21','',''),(2196792,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:42:21','',''),(2196815,'1','142','798',342,'Retail Sale Id 1295517',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 15:43:29','',''),(2196816,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 15:43:29','',''),(2196873,'1','142','798',342,'Retail Sale Id 1295546',800.32,0.00,0.00,0.00,78.08,'2021-12-07 15:46:01','',''),(2196874,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.22,0.00,'2021-12-07 15:46:01','',''),(2196933,'1','142','798',342,'Retail Sale Id 1295580',28350.00,0.00,0.00,0.00,1710.00,'2021-12-07 15:49:17','',''),(2196934,'1','142','798',342,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-07 15:49:17','',''),(2196964,'1','142','798',342,'Retail Sale Id 1295595',8200.00,0.00,0.00,0.00,800.00,'2021-12-07 15:50:50','',''),(2196965,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:50:50','',''),(2197068,'1','142','798',342,'Retail Sale Id 1295642',2997.92,0.00,0.00,0.00,292.48,'2021-12-07 15:55:09','',''),(2197069,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 15:55:09','',''),(2197121,'1','142','798',342,'Retail Sale Id 1295675',997.12,0.00,0.00,0.00,97.28,'2021-12-07 15:57:33','',''),(2197122,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 15:57:33','',''),(2197168,'1','142','798',342,'Retail Sale Id 1295700',3949.12,0.00,0.00,0.00,385.28,'2021-12-07 16:00:21','',''),(2197169,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 16:00:21','',''),(2197191,'1','142','798',342,'Retail Sale Id 1295715',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 16:01:20','',''),(2197192,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 16:01:20','',''),(2197229,'1','142','798',342,'Retail Sale Id 1295734',12136.00,0.00,0.00,0.00,1184.00,'2021-12-07 16:03:10','',''),(2197230,'1','142','798',342,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-07 16:03:10','',''),(2197245,'1','142','798',342,'Retail Sale Id 1295740',1200.48,0.00,0.00,0.00,117.12,'2021-12-07 16:04:08','',''),(2197246,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.83,0.00,'2021-12-07 16:04:08','',''),(2197280,'1','142','798',342,'Retail Sale Id 1295756',1502.24,0.00,0.00,0.00,146.56,'2021-12-07 16:05:33','',''),(2197281,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-07 16:05:33','',''),(2197310,'1','142','798',342,'Retail Sale Id 1295776',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 16:06:42','',''),(2197311,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 16:06:42','',''),(2197348,'1','142','798',342,'Retail Sale Id 1295793',4998.72,0.00,0.00,0.00,487.68,'2021-12-07 16:08:33','',''),(2197349,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-07 16:08:33','',''),(2197518,'1','142','798',342,'Retail Sale Id 1295882',3936.00,0.00,0.00,0.00,384.00,'2021-12-07 16:17:11','',''),(2197519,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:17:11','',''),(2197570,'1','142','798',342,'Retail Sale Id 1295916',8200.00,0.00,0.00,0.00,800.00,'2021-12-07 16:19:11','',''),(2197571,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:19:11','',''),(2197625,'1','142','798',342,'Retail Sale Id 1295944',2499.36,0.00,0.00,0.00,243.84,'2021-12-07 16:21:22','',''),(2197626,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-07 16:21:22','',''),(2197659,'1','142','798',342,'Retail Sale Id 1295960',1502.24,0.00,0.00,0.00,146.56,'2021-12-07 16:22:54','',''),(2197660,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-07 16:22:54','',''),(2197699,'1','142','798',342,'Retail Sale Id 1295984',1968.00,0.00,0.00,0.00,192.00,'2021-12-07 16:25:25','',''),(2197700,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:25:25','',''),(2197745,'1','142','798',342,'Retail Sale Id 1296005',1502.24,0.00,0.00,0.00,146.56,'2021-12-07 16:27:26','',''),(2197746,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-07 16:27:26','',''),(2197783,'1','142','798',342,'Retail Sale Id 1296026',1502.24,0.00,0.00,0.00,146.56,'2021-12-07 16:29:13','',''),(2197784,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-07 16:29:13','',''),(2197843,'1','142','798',342,'Retail Sale Id 1296054',1902.40,0.00,0.00,0.00,185.60,'2021-12-07 16:31:51','',''),(2197844,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-07 16:31:51','',''),(2197870,'1','142','798',342,'Retail Sale Id 1296073',1902.40,0.00,0.00,0.00,185.60,'2021-12-07 16:33:24','',''),(2197871,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-07 16:33:24','',''),(2197891,'1','142','798',342,'Retail Sale Id 1296084',4001.60,0.00,0.00,0.00,390.40,'2021-12-07 16:34:28','',''),(2197892,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-07 16:34:28','',''),(2197906,'1','142','798',342,'Retail Sale Id 1296091',4001.60,0.00,0.00,0.00,390.40,'2021-12-07 16:35:31','',''),(2197907,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-07 16:35:31','',''),(2197934,'1','142','798',342,'Retail Sale Id 1296105',1797.44,0.00,0.00,0.00,175.36,'2021-12-07 16:36:44','',''),(2197935,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.74,0.00,'2021-12-07 16:36:44','',''),(2197962,'1','142','798',342,'Retail Sale Id 1296124',3798.24,0.00,0.00,0.00,370.56,'2021-12-07 16:39:01','',''),(2197963,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.79,0.00,'2021-12-07 16:39:01','',''),(2198037,'1','142','798',342,'Retail Sale Id 1296161',8200.00,0.00,0.00,0.00,800.00,'2021-12-07 16:44:04','',''),(2198038,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:44:04','',''),(2198098,'1','142','798',342,'Retail Sale Id 1296194',8101.60,0.00,0.00,0.00,790.40,'2021-12-07 16:47:49','',''),(2198099,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.35,0.00,'2021-12-07 16:47:49','',''),(2198133,'1','142','798',342,'Retail Sale Id 1296211',3798.24,0.00,0.00,0.00,370.56,'2021-12-07 16:49:51','',''),(2198134,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.79,0.00,'2021-12-07 16:49:51','',''),(2198168,'1','142','798',342,'Retail Sale Id 1296227',1797.44,0.00,0.00,0.00,175.36,'2021-12-07 16:51:52','',''),(2198169,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.74,0.00,'2021-12-07 16:51:52','',''),(2198178,'1','142','798',342,'Retail Sale Id 1296233',16400.00,0.00,0.00,0.00,1600.00,'2021-12-07 16:52:43','',''),(2198179,'1','142','798',342,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 16:52:43','',''),(2198216,'1','142','798',342,'Retail Sale Id 1296252',1502.24,0.00,0.00,0.00,146.56,'2021-12-07 16:54:16','',''),(2198217,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-07 16:54:16','',''),(2198218,'1','142','798',342,'Retail Sale Id 1296252',2000.80,0.00,0.00,0.00,195.20,'2021-12-07 16:54:16','',''),(2198219,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 16:54:16','',''),(2198244,'1','142','798',342,'Retail Sale Id 1296266',4500.16,0.00,0.00,0.00,439.04,'2021-12-07 16:55:29','',''),(2198245,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.86,0.00,'2021-12-07 16:55:29','',''),(2198276,'1','142','798',342,'Retail Sale Id 1296288',1968.00,0.00,0.00,0.00,192.00,'2021-12-07 16:57:03','',''),(2198277,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:57:03','',''),(2198353,'1','142','798',342,'Retail Sale Id 1296326',8200.00,0.00,0.00,0.00,800.00,'2021-12-07 17:01:15','',''),(2198354,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:01:15','',''),(2198355,'1','142','798',342,'Retail Sale Id 1296326',8200.00,0.00,0.00,0.00,800.00,'2021-12-07 17:01:15','',''),(2198356,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:01:15','',''),(2198427,'1','142','798',342,'Retail Sale Id 1296356',4598.56,0.00,0.00,0.00,448.64,'2021-12-07 17:05:04','',''),(2198428,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.01,0.00,'2021-12-07 17:05:04','',''),(2198450,'1','142','798',342,'Retail Sale Id 1296368',3280.00,0.00,0.00,0.00,320.00,'2021-12-07 17:06:19','',''),(2198451,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 17:06:19','',''),(2198459,'1','142','798',342,'Retail Sale Id 1296372',997.12,0.00,0.00,0.00,97.28,'2021-12-07 17:07:14','',''),(2198460,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 17:07:14','',''),(2198482,'1','142','798',342,'Retail Sale Id 1296383',997.12,0.00,0.00,0.00,97.28,'2021-12-07 17:08:20','',''),(2198483,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 17:08:20','',''),(2198617,'1','142','798',342,'Retail Sale Id 1296473',16072.00,0.00,0.00,0.00,1568.00,'2021-12-07 17:18:46','',''),(2198618,'1','142','798',342,'Retail sales',0.00,0.00,0.00,24.50,0.00,'2021-12-07 17:18:46','',''),(2198635,'1','142','798',342,'Retail Sale Id 1296482',8200.00,0.00,0.00,0.00,800.00,'2021-12-07 17:20:39','',''),(2198636,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:20:39','',''),(2199924,'1','142','798',342,'Retail Sale Id 1296863',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 06:29:09','',''),(2199925,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 06:29:09','',''),(2200469,'1','142','798',342,'Retail Sale Id 1297088',4001.60,0.00,0.00,0.00,390.40,'2021-12-08 07:02:09','',''),(2200470,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-08 07:02:09','',''),(2200854,'1','142','798',342,'Retail Sale Id 1297270',4998.72,0.00,0.00,0.00,487.68,'2021-12-08 07:24:22','',''),(2200855,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-08 07:24:22','',''),(2200977,'1','142','798',342,'Retail Sale Id 1297324',31500.00,0.00,0.00,0.00,1900.00,'2021-12-08 07:31:22','',''),(2200978,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 07:31:22','',''),(2201001,'1','142','798',342,'Retail Sale Id 1297336',2997.92,0.00,0.00,0.00,292.48,'2021-12-08 07:32:51','',''),(2201002,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-08 07:32:51','',''),(2201029,'1','142','798',342,'Retail Sale Id 1297351',7498.08,0.00,0.00,0.00,731.52,'2021-12-08 07:33:55','',''),(2201030,'1','142','798',342,'Retail sales',0.00,0.00,0.00,11.43,0.00,'2021-12-08 07:33:55','',''),(2201082,'1','142','798',342,'Retail Sale Id 1297367',3280.00,0.00,0.00,0.00,320.00,'2021-12-08 07:35:30','',''),(2201083,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 07:35:30','',''),(2201230,'1','142','798',342,'Retail Sale Id 1297442',6999.52,0.00,0.00,0.00,682.88,'2021-12-08 07:45:05','',''),(2201231,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.67,0.00,'2021-12-08 07:45:05','',''),(2201266,'1','142','798',342,'Retail Sale Id 1297462',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 07:47:42','',''),(2201267,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 07:47:42','',''),(2201268,'1','142','798',342,'Retail Sale Id 1297462',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 07:47:42','',''),(2201269,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 07:47:42','',''),(2201270,'1','142','798',342,'Retail Sale Id 1297462',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 07:47:42','',''),(2201271,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 07:47:42','',''),(2201288,'1','142','798',342,'Retail Sale Id 1297472',1502.24,0.00,0.00,0.00,146.56,'2021-12-08 07:48:49','',''),(2201289,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-08 07:48:49','',''),(2201367,'1','142','798',342,'Retail Sale Id 1297509',4001.60,0.00,0.00,0.00,390.40,'2021-12-08 07:52:24','',''),(2201368,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-08 07:52:24','',''),(2201472,'1','142','798',342,'Retail Sale Id 1297544',8200.00,0.00,0.00,0.00,800.00,'2021-12-08 07:56:02','',''),(2201473,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:56:02','',''),(2201486,'1','142','798',342,'Retail Sale Id 1297551',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 07:56:56','',''),(2201487,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 07:56:56','',''),(2201541,'1','142','798',342,'Retail Sale Id 1297575',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 07:59:42','',''),(2201542,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 07:59:42','',''),(2201563,'1','142','798',342,'Retail Sale Id 1297586',4001.60,0.00,0.00,0.00,390.40,'2021-12-08 08:00:48','',''),(2201564,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-08 08:00:48','',''),(2201611,'1','142','798',342,'Retail Sale Id 1297609',3936.00,0.00,0.00,0.00,384.00,'2021-12-08 08:03:31','',''),(2201612,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 08:03:31','',''),(2201655,'1','142','798',342,'Retail Sale Id 1297627',2997.92,0.00,0.00,0.00,292.48,'2021-12-08 08:05:10','',''),(2201656,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-08 08:05:10','',''),(2201675,'1','142','798',342,'Retail Sale Id 1297638',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 08:06:22','',''),(2201676,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 08:06:22','',''),(2201724,'1','142','798',342,'Retail Sale Id 1297666',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 08:10:39','',''),(2201725,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 08:10:39','',''),(2202104,'1','142','798',342,'Retail Sale Id 1297856',1502.24,0.00,0.00,0.00,146.56,'2021-12-08 08:35:15','',''),(2202105,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-08 08:35:15','',''),(2202118,'1','142','798',342,'Retail Sale Id 1297866',2997.92,0.00,0.00,0.00,292.48,'2021-12-08 08:36:06','',''),(2202119,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-08 08:36:06','',''),(2202134,'1','142','798',342,'Retail Sale Id 1297870',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 08:36:55','',''),(2202135,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 08:36:55','',''),(2202142,'1','142','798',342,'Retail Sale Id 1297875',1502.24,0.00,0.00,0.00,146.56,'2021-12-08 08:37:40','',''),(2202143,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-08 08:37:40','',''),(2202156,'1','142','798',342,'Retail Sale Id 1297881',8200.00,0.00,0.00,0.00,800.00,'2021-12-08 08:38:40','',''),(2202157,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:38:40','',''),(2202174,'1','142','798',342,'Retail Sale Id 1297888',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 08:39:24','',''),(2202175,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 08:39:24','',''),(2202188,'1','142','798',342,'Retail Sale Id 1297895',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 08:40:05','',''),(2202189,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 08:40:05','',''),(2202226,'1','142','798',342,'Retail Sale Id 1297906',8200.00,0.00,0.00,0.00,800.00,'2021-12-08 08:41:18','',''),(2202227,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:41:18','',''),(2202242,'1','142','798',342,'Retail Sale Id 1297910',3280.00,0.00,0.00,0.00,320.00,'2021-12-08 08:42:06','',''),(2202243,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 08:42:06','',''),(2202273,'1','142','798',342,'Retail Sale Id 1297916',8200.00,0.00,0.00,0.00,800.00,'2021-12-08 08:42:49','',''),(2202274,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:42:49','',''),(2202350,'1','142','798',342,'Retail Sale Id 1297938',8200.00,0.00,0.00,0.00,800.00,'2021-12-08 08:46:01','',''),(2202351,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:46:01','',''),(2202352,'1','142','798',342,'Retail Sale Id 1297938',9997.44,0.00,0.00,0.00,975.36,'2021-12-08 08:46:01','',''),(2202353,'1','142','798',342,'Retail sales',0.00,0.00,0.00,15.24,0.00,'2021-12-08 08:46:01','',''),(2202374,'1','142','798',342,'Retail Sale Id 1297947',16400.00,0.00,0.00,0.00,1600.00,'2021-12-08 08:47:05','',''),(2202375,'1','142','798',342,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 08:47:05','',''),(2202494,'1','142','798',342,'Retail Sale Id 1297988',471000.00,0.00,0.00,0.00,27000.00,'2021-12-08 08:52:32','',''),(2202495,'1','142','798',342,'Retail sales',0.00,0.00,0.00,750.00,0.00,'2021-12-08 08:52:32','',''),(2202550,'1','142','798',342,'Retail Sale Id 1298015',2997.92,0.00,0.00,0.00,292.48,'2021-12-08 08:55:21','',''),(2202551,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-08 08:55:21','',''),(2202638,'1','142','798',342,'Retail Sale Id 1298053',1600.64,0.00,0.00,0.00,156.16,'2021-12-08 09:00:51','',''),(2202639,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-08 09:00:51','',''),(2202730,'1','142','798',342,'Retail Sale Id 1298102',31500.00,0.00,0.00,0.00,1900.00,'2021-12-08 09:06:05','',''),(2202731,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 09:06:05','',''),(2202752,'1','142','798',342,'Retail Sale Id 1298120',997.12,0.00,0.00,0.00,97.28,'2021-12-08 09:07:34','',''),(2202753,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-08 09:07:34','',''),(2202771,'1','142','798',342,'Retail Sale Id 1298132',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 09:08:40','',''),(2202772,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 09:08:40','',''),(2202779,'1','142','798',342,'Retail Sale Id 1298138',1200.48,0.00,0.00,0.00,117.12,'2021-12-08 09:09:22','',''),(2202780,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.83,0.00,'2021-12-08 09:09:22','',''),(2202795,'1','142','798',342,'Retail Sale Id 1298146',6999.52,0.00,0.00,0.00,682.88,'2021-12-08 09:10:22','',''),(2202796,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.67,0.00,'2021-12-08 09:10:22','',''),(2202817,'1','142','798',342,'Retail Sale Id 1298155',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 09:11:20','',''),(2202818,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 09:11:20','',''),(2202862,'1','142','798',342,'Retail Sale Id 1298171',8003.20,0.00,0.00,0.00,780.80,'2021-12-08 09:13:42','',''),(2202863,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-08 09:13:42','',''),(2202920,'1','142','798',342,'Retail Sale Id 1298197',6560.00,0.00,0.00,0.00,640.00,'2021-12-08 09:16:53','',''),(2202921,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 09:16:53','',''),(2202922,'1','142','798',342,'Retail Sale Id 1298197',6560.00,0.00,0.00,0.00,640.00,'2021-12-08 09:16:53','',''),(2202923,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 09:16:53','',''),(2202974,'1','142','798',342,'Retail Sale Id 1298222',8200.00,0.00,0.00,0.00,800.00,'2021-12-08 09:19:51','',''),(2202975,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:19:51','',''),(2203043,'1','142','798',342,'Retail Sale Id 1298258',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 09:26:43','',''),(2203044,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 09:26:43','',''),(2203071,'1','142','798',342,'Retail Sale Id 1298271',4998.72,0.00,0.00,0.00,487.68,'2021-12-08 09:29:16','',''),(2203072,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-08 09:29:16','',''),(2203121,'1','142','798',342,'Retail Sale Id 1298298',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 09:33:41','',''),(2203122,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 09:33:41','',''),(2203145,'1','142','798',342,'Retail Sale Id 1298310',4001.60,0.00,0.00,0.00,390.40,'2021-12-08 09:35:39','',''),(2203146,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-08 09:35:39','',''),(2203187,'1','142','798',342,'Retail Sale Id 1298327',8200.00,0.00,0.00,0.00,800.00,'2021-12-08 09:38:13','',''),(2203188,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:38:13','',''),(2203205,'1','142','798',342,'Retail Sale Id 1298337',6999.52,0.00,0.00,0.00,682.88,'2021-12-08 09:39:53','',''),(2203206,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.67,0.00,'2021-12-08 09:39:53','',''),(2203221,'1','142','798',342,'Retail Sale Id 1298346',2997.92,0.00,0.00,0.00,292.48,'2021-12-08 09:41:15','',''),(2203222,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-08 09:41:15','',''),(2203261,'1','142','798',342,'Retail Sale Id 1298369',8200.00,0.00,0.00,0.00,800.00,'2021-12-08 09:44:47','',''),(2203262,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:44:47','',''),(2203283,'1','142','798',342,'Retail Sale Id 1298380',6500.96,0.00,0.00,0.00,634.24,'2021-12-08 09:46:56','',''),(2203284,'1','142','798',342,'Retail sales',0.00,0.00,0.00,9.91,0.00,'2021-12-08 09:46:56','',''),(2203342,'1','142','798',342,'Retail Sale Id 1298399',4001.60,0.00,0.00,0.00,390.40,'2021-12-08 09:49:54','',''),(2203343,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-08 09:49:54','',''),(2203344,'1','142','798',342,'Retail Sale Id 1298399',4001.60,0.00,0.00,0.00,390.40,'2021-12-08 09:49:54','',''),(2203345,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-08 09:49:54','',''),(2203394,'1','142','798',342,'Retail Sale Id 1298428',8495.20,0.00,0.00,0.00,828.80,'2021-12-08 09:54:27','',''),(2203395,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.95,0.00,'2021-12-08 09:54:27','',''),(2203565,'1','142','798',342,'Retail Sale Id 1298505',4998.72,0.00,0.00,0.00,487.68,'2021-12-08 10:06:31','',''),(2203566,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-08 10:06:31','',''),(2203615,'1','142','798',342,'Retail Sale Id 1298525',4998.72,0.00,0.00,0.00,487.68,'2021-12-08 10:09:27','',''),(2203616,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-08 10:09:27','',''),(2203679,'1','142','798',342,'Retail Sale Id 1298554',8200.00,0.00,0.00,0.00,800.00,'2021-12-08 10:13:22','',''),(2203680,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:13:22','',''),(2203873,'1','142','798',342,'Retail Sale Id 1298649',3936.00,0.00,0.00,0.00,384.00,'2021-12-08 10:25:09','',''),(2203874,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 10:25:09','',''),(2203939,'1','142','798',342,'Retail Sale Id 1298677',8200.00,0.00,0.00,0.00,800.00,'2021-12-08 10:28:53','',''),(2203940,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:28:53','',''),(2203951,'1','142','798',342,'Retail Sale Id 1298681',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 10:30:07','',''),(2203952,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 10:30:07','',''),(2204027,'1','142','798',342,'Retail Sale Id 1298714',1134.88,0.00,0.00,0.00,110.72,'2021-12-08 10:34:18','',''),(2204028,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.73,0.00,'2021-12-08 10:34:18','',''),(2204029,'1','142','798',342,'Retail Sale Id 1298714',1968.00,0.00,0.00,0.00,192.00,'2021-12-08 10:34:18','',''),(2204030,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:34:18','',''),(2204049,'1','142','798',342,'Retail Sale Id 1298726',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 10:36:05','',''),(2204050,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 10:36:05','',''),(2204113,'1','142','798',342,'Retail Sale Id 1298763',6999.52,0.00,0.00,0.00,682.88,'2021-12-08 10:41:46','',''),(2204114,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.67,0.00,'2021-12-08 10:41:46','',''),(2204236,'1','142','798',342,'Retail Sale Id 1298823',8200.00,0.00,0.00,0.00,800.00,'2021-12-08 10:53:33','',''),(2204237,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:53:33','',''),(2204250,'1','142','798',342,'Retail Sale Id 1298833',997.12,0.00,0.00,0.00,97.28,'2021-12-08 10:54:55','',''),(2204251,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-08 10:54:55','',''),(2204276,'1','142','798',342,'Retail Sale Id 1298843',2624.00,0.00,0.00,0.00,256.00,'2021-12-08 10:56:28','',''),(2204277,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 10:56:28','',''),(2204327,'1','142','798',342,'Retail Sale Id 1298868',3280.00,0.00,0.00,0.00,320.00,'2021-12-08 11:00:22','',''),(2204328,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 11:00:22','',''),(2204378,'1','142','798',342,'Retail Sale Id 1298893',8200.00,0.00,0.00,0.00,800.00,'2021-12-08 11:04:36','',''),(2204379,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:04:36','',''),(2204420,'1','142','798',342,'Retail Sale Id 1298917',4099410.00,0.00,0.00,0.00,247266.00,'2021-12-08 11:07:35','',''),(2204421,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6507.00,0.00,'2021-12-08 11:07:35','',''),(2204442,'1','142','798',342,'Retail Sale Id 1298927',3936.00,0.00,0.00,0.00,384.00,'2021-12-08 11:08:23','',''),(2204443,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:08:23','',''),(2204468,'1','142','798',342,'Retail Sale Id 1298943',3936.00,0.00,0.00,0.00,384.00,'2021-12-08 11:10:08','',''),(2204469,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:10:08','',''),(2204490,'1','142','798',342,'Retail Sale Id 1298955',3936.00,0.00,0.00,0.00,384.00,'2021-12-08 11:10:54','',''),(2204491,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:10:54','',''),(2204500,'1','142','798',342,'Retail Sale Id 1298960',7202.88,0.00,0.00,0.00,702.72,'2021-12-08 11:11:55','',''),(2204501,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.98,0.00,'2021-12-08 11:11:55','',''),(2204516,'1','142','798',342,'Retail Sale Id 1298970',3280.00,0.00,0.00,0.00,320.00,'2021-12-08 11:13:05','',''),(2204517,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 11:13:05','',''),(2204530,'1','142','798',342,'Retail Sale Id 1298978',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 11:13:59','',''),(2204531,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 11:13:59','',''),(2204550,'1','142','798',342,'Retail Sale Id 1298985',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 11:15:14','',''),(2204551,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 11:15:14','',''),(2204574,'1','142','798',342,'Retail Sale Id 1298999',997.12,0.00,0.00,0.00,97.28,'2021-12-08 11:17:38','',''),(2204575,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-08 11:17:38','',''),(2204592,'1','142','798',342,'Retail Sale Id 1299008',35910.00,0.00,0.00,0.00,2166.00,'2021-12-08 11:19:21','',''),(2204593,'1','142','798',342,'Retail sales',0.00,0.00,0.00,57.00,0.00,'2021-12-08 11:19:21','',''),(2204648,'1','142','798',342,'Retail Sale Id 1299036',63000.00,0.00,0.00,0.00,3800.00,'2021-12-08 11:22:47','',''),(2204649,'1','142','798',342,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-08 11:22:47','',''),(2204668,'1','142','798',342,'Retail Sale Id 1299045',1968.00,0.00,0.00,0.00,192.00,'2021-12-08 11:24:11','',''),(2204669,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:24:11','',''),(2204686,'1','142','798',342,'Retail Sale Id 1299055',1502.24,0.00,0.00,0.00,146.56,'2021-12-08 11:25:35','',''),(2204687,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-08 11:25:35','',''),(2204706,'1','142','798',342,'Retail Sale Id 1299066',1502.24,0.00,0.00,0.00,146.56,'2021-12-08 11:27:21','',''),(2204707,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-08 11:27:21','',''),(2204712,'1','142','798',342,'Retail Sale Id 1299070',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 11:27:55','',''),(2204713,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 11:27:55','',''),(2204782,'1','142','798',342,'Retail Sale Id 1299107',8200.00,0.00,0.00,0.00,800.00,'2021-12-08 11:33:07','',''),(2204783,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:33:07','',''),(2204898,'1','142','798',342,'Retail Sale Id 1299163',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 11:39:11','',''),(2204899,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 11:39:11','',''),(2205030,'1','142','798',342,'Retail Sale Id 1299233',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 11:46:57','',''),(2205031,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 11:46:57','',''),(2205042,'1','142','798',342,'Retail Sale Id 1299239',1968.00,0.00,0.00,0.00,192.00,'2021-12-08 11:47:56','',''),(2205043,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:47:56','',''),(2205120,'1','142','798',342,'Retail Sale Id 1299274',3936.00,0.00,0.00,0.00,384.00,'2021-12-08 11:54:25','',''),(2205121,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:54:25','',''),(2205172,'1','142','798',342,'Retail Sale Id 1299301',1502.24,0.00,0.00,0.00,146.56,'2021-12-08 11:58:53','',''),(2205173,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-08 11:58:53','',''),(2206576,'1','142','798',342,'Retail Sale Id 1299926',6560.00,0.00,0.00,0.00,640.00,'2021-12-08 13:34:33','',''),(2206577,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 13:34:33','',''),(2206600,'1','142','798',342,'Retail Sale Id 1299937',1968.00,0.00,0.00,0.00,192.00,'2021-12-08 13:37:05','',''),(2206601,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:37:05','',''),(2206620,'1','142','798',342,'Retail Sale Id 1299948',1968.00,0.00,0.00,0.00,192.00,'2021-12-08 13:38:04','',''),(2206621,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:38:04','',''),(2206737,'1','142','798',342,'Retail Sale Id 1299989',1968.00,0.00,0.00,0.00,192.00,'2021-12-08 13:43:06','',''),(2206738,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:43:06','',''),(2206824,'1','142','798',342,'Retail Sale Id 1300022',1502.24,0.00,0.00,0.00,146.56,'2021-12-08 13:47:37','',''),(2206825,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-08 13:47:37','',''),(2206854,'1','142','798',342,'Retail Sale Id 1300031',4001.60,0.00,0.00,0.00,390.40,'2021-12-08 13:49:06','',''),(2206855,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-08 13:49:06','',''),(2206860,'1','142','798',342,'Retail Sale Id 1300035',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 13:49:55','',''),(2206861,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 13:49:55','',''),(2206876,'1','142','798',342,'Retail Sale Id 1300042',69470.40,0.00,0.00,0.00,6777.60,'2021-12-08 13:51:14','',''),(2206877,'1','142','798',342,'Retail sales',0.00,0.00,0.00,105.90,0.00,'2021-12-08 13:51:14','',''),(2207154,'1','142','798',342,'Retail Sale Id 1300159',2499.36,0.00,0.00,0.00,243.84,'2021-12-08 14:08:46','',''),(2207155,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-08 14:08:46','',''),(2207453,'1','142','798',342,'Retail Sale Id 1300314',1312.00,0.00,0.00,0.00,128.00,'2021-12-08 14:26:17','',''),(2207454,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 14:26:17','',''),(2207474,'1','142','798',342,'Retail Sale Id 1300322',8200.00,0.00,0.00,0.00,800.00,'2021-12-08 14:27:42','',''),(2207475,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:27:42','',''),(2207496,'1','142','798',342,'Retail Sale Id 1300330',25200.00,0.00,0.00,0.00,1520.00,'2021-12-08 14:28:43','',''),(2207497,'1','142','798',342,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-08 14:28:43','',''),(2207686,'1','142','798',342,'Retail Sale Id 1300404',3936.00,0.00,0.00,0.00,384.00,'2021-12-08 14:36:07','',''),(2207687,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:36:07','',''),(2207716,'1','142','798',342,'Retail Sale Id 1300422',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 14:37:42','',''),(2207717,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 14:37:42','',''),(2207806,'1','142','798',342,'Retail Sale Id 1300470',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 14:43:13','',''),(2207807,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 14:43:13','',''),(2207891,'1','142','798',342,'Retail Sale Id 1300523',1968.00,0.00,0.00,0.00,192.00,'2021-12-08 14:47:57','',''),(2207892,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:47:57','',''),(2207903,'1','142','798',342,'Retail Sale Id 1300526',3936.00,0.00,0.00,0.00,384.00,'2021-12-08 14:48:39','',''),(2207904,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:48:39','',''),(2208093,'1','142','798',342,'Return of Retail Sale Id 1298917',0.00,4099410.00,6507.00,0.00,-247266.00,'2021-12-08 15:02:28','',''),(2208146,'1','142','798',342,'Retail Sale Id 1300639',40950.00,0.00,0.00,0.00,2470.00,'2021-12-08 15:06:00','',''),(2208147,'1','142','798',342,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-08 15:06:00','',''),(2208213,'1','142','798',342,'Retail Sale Id 1300665',1502.24,0.00,0.00,0.00,146.56,'2021-12-08 15:09:51','',''),(2208214,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-08 15:09:51','',''),(2208239,'1','142','798',342,'Retail Sale Id 1300674',66150.00,0.00,0.00,0.00,3990.00,'2021-12-08 15:10:59','',''),(2208240,'1','142','798',342,'Retail sales',0.00,0.00,0.00,105.00,0.00,'2021-12-08 15:10:59','',''),(2208257,'1','142','798',342,'Retail Sale Id 1300681',27880.00,0.00,0.00,0.00,2720.00,'2021-12-08 15:11:54','',''),(2208258,'1','142','798',342,'Retail sales',0.00,0.00,0.00,42.50,0.00,'2021-12-08 15:11:54','',''),(2208347,'1','142','798',342,'Retail Sale Id 1300732',997.12,0.00,0.00,0.00,97.28,'2021-12-08 15:17:39','',''),(2208348,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-08 15:17:39','',''),(2208423,'1','142','798',342,'Retail Sale Id 1300765',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 15:20:47','',''),(2208424,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 15:20:47','',''),(2208466,'1','142','798',342,'Retail Sale Id 1300782',3280.00,0.00,0.00,0.00,320.00,'2021-12-08 15:22:35','',''),(2208467,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 15:22:35','',''),(2208496,'1','142','798',342,'Retail Sale Id 1300798',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 15:24:34','',''),(2208497,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 15:24:34','',''),(2208520,'1','142','798',342,'Retail Sale Id 1300810',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 15:25:38','',''),(2208521,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 15:25:38','',''),(2208596,'1','142','798',342,'Retail Sale Id 1300848',7878.56,0.00,0.00,0.00,768.64,'2021-12-08 15:29:50','',''),(2208597,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.01,0.00,'2021-12-08 15:29:50','',''),(2208639,'1','142','798',342,'Retail Sale Id 1300867',1298.88,0.00,0.00,0.00,126.72,'2021-12-08 15:31:57','',''),(2208640,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.98,0.00,'2021-12-08 15:31:57','',''),(2208641,'1','142','798',342,'Retail Sale Id 1300867',2997.92,0.00,0.00,0.00,292.48,'2021-12-08 15:31:57','',''),(2208642,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-08 15:31:57','',''),(2208681,'1','142','798',342,'Retail Sale Id 1300888',3949.12,0.00,0.00,0.00,385.28,'2021-12-08 15:33:30','',''),(2208682,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 15:33:30','',''),(2208715,'1','142','798',342,'Retail Sale Id 1300914',2302.56,0.00,0.00,0.00,224.64,'2021-12-08 15:35:33','',''),(2208716,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.51,0.00,'2021-12-08 15:35:33','',''),(2208761,'1','142','798',342,'Retail Sale Id 1300937',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 15:37:42','',''),(2208762,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 15:37:42','',''),(2208831,'1','142','798',342,'Retail Sale Id 1300972',4001.60,0.00,0.00,0.00,390.40,'2021-12-08 15:41:22','',''),(2208832,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-08 15:41:22','',''),(2208879,'1','142','798',342,'Retail Sale Id 1300999',8200.00,0.00,0.00,0.00,800.00,'2021-12-08 15:43:35','',''),(2208880,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:43:35','',''),(2208903,'1','142','798',342,'Retail Sale Id 1301011',1502.24,0.00,0.00,0.00,146.56,'2021-12-08 15:44:49','',''),(2208904,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-08 15:44:49','',''),(2208913,'1','142','798',342,'Retail Sale Id 1301018',2997.92,0.00,0.00,0.00,292.48,'2021-12-08 15:45:44','',''),(2208914,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-08 15:45:44','',''),(2208981,'1','142','798',342,'Retail Sale Id 1301050',59850.00,0.00,0.00,0.00,3610.00,'2021-12-08 15:49:13','',''),(2208982,'1','142','798',342,'Retail sales',0.00,0.00,0.00,95.00,0.00,'2021-12-08 15:49:13','',''),(2209133,'1','142','798',342,'Retail Sale Id 1301120',1968.00,0.00,0.00,0.00,192.00,'2021-12-08 15:58:08','',''),(2209134,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 15:58:08','',''),(2209167,'1','142','798',342,'Retail Sale Id 1301138',4001.60,0.00,0.00,0.00,390.40,'2021-12-08 15:59:54','',''),(2209168,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-08 15:59:54','',''),(2209205,'1','142','798',342,'Retail Sale Id 1301158',997.12,0.00,0.00,0.00,97.28,'2021-12-08 16:01:25','',''),(2209206,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-08 16:01:25','',''),(2209207,'1','142','798',342,'Retail Sale Id 1301158',997.12,0.00,0.00,0.00,97.28,'2021-12-08 16:01:25','',''),(2209208,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-08 16:01:25','',''),(2209243,'1','142','798',342,'Retail Sale Id 1301179',4598.56,0.00,0.00,0.00,448.64,'2021-12-08 16:03:09','',''),(2209244,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.01,0.00,'2021-12-08 16:03:09','',''),(2209273,'1','142','798',342,'Retail Sale Id 1301194',1502.24,0.00,0.00,0.00,146.56,'2021-12-08 16:04:45','',''),(2209274,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-08 16:04:45','',''),(2209347,'1','142','798',342,'Retail Sale Id 1301226',1502.24,0.00,0.00,0.00,146.56,'2021-12-08 16:08:23','',''),(2209348,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-08 16:08:23','',''),(2209349,'1','142','798',342,'Retail Sale Id 1301226',2997.92,0.00,0.00,0.00,292.48,'2021-12-08 16:08:23','',''),(2209350,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-08 16:08:23','',''),(2209351,'1','142','798',342,'Retail Sale Id 1301226',3949.12,0.00,0.00,0.00,385.28,'2021-12-08 16:08:23','',''),(2209352,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 16:08:23','',''),(2209353,'1','142','798',342,'Retail Sale Id 1301226',8200.00,0.00,0.00,0.00,800.00,'2021-12-08 16:08:23','',''),(2209354,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:08:23','',''),(2209375,'1','142','798',342,'Retail Sale Id 1301238',3949.12,0.00,0.00,0.00,385.28,'2021-12-08 16:09:14','',''),(2209376,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 16:09:14','',''),(2209466,'1','142','798',342,'Retail Sale Id 1301280',1502.24,0.00,0.00,0.00,146.56,'2021-12-08 16:12:23','',''),(2209467,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-08 16:12:23','',''),(2209504,'1','142','798',342,'Retail Sale Id 1301303',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 16:14:33','',''),(2209505,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 16:14:33','',''),(2209547,'1','142','798',342,'Retail Sale Id 1301320',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 16:16:07','',''),(2209548,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 16:16:07','',''),(2209652,'1','142','798',342,'Retail Sale Id 1301359',8200.00,0.00,0.00,0.00,800.00,'2021-12-08 16:19:31','',''),(2209653,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:19:31','',''),(2209676,'1','142','798',342,'Retail Sale Id 1301371',3942.56,0.00,0.00,0.00,384.64,'2021-12-08 16:21:12','',''),(2209677,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 16:21:12','',''),(2209729,'1','142','798',342,'Retail Sale Id 1301400',1502.24,0.00,0.00,0.00,146.56,'2021-12-08 16:23:43','',''),(2209730,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-08 16:23:43','',''),(2209731,'1','142','798',342,'Retail Sale Id 1301400',8200.00,0.00,0.00,0.00,800.00,'2021-12-08 16:23:43','',''),(2209732,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:23:43','',''),(2209841,'1','142','798',342,'Retail Sale Id 1301527',3949.12,0.00,0.00,0.00,385.28,'2021-12-08 16:30:34','',''),(2209842,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 16:30:34','',''),(2209863,'1','142','798',342,'Retail Sale Id 1301585',3503.04,0.00,0.00,0.00,341.76,'2021-12-08 16:31:39','',''),(2209864,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-08 16:31:40','',''),(2209889,'1','142','798',342,'Retail Sale Id 1301598',1200.48,0.00,0.00,0.00,117.12,'2021-12-08 16:33:23','',''),(2209890,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.83,0.00,'2021-12-08 16:33:23','',''),(2209891,'1','142','798',342,'Retail Sale Id 1301598',1298.88,0.00,0.00,0.00,126.72,'2021-12-08 16:33:23','',''),(2209892,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.98,0.00,'2021-12-08 16:33:23','',''),(2209923,'1','142','798',342,'Retail Sale Id 1301609',3949.12,0.00,0.00,0.00,385.28,'2021-12-08 16:34:29','',''),(2209924,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 16:34:29','',''),(2209955,'1','142','798',342,'Retail Sale Id 1301630',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 16:36:01','',''),(2209956,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 16:36:01','',''),(2209981,'1','142','798',342,'Retail Sale Id 1301643',997.12,0.00,0.00,0.00,97.28,'2021-12-08 16:37:11','',''),(2209982,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-08 16:37:11','',''),(2210013,'1','142','798',342,'Retail Sale Id 1301657',3936.00,0.00,0.00,0.00,384.00,'2021-12-08 16:38:32','',''),(2210014,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:38:32','',''),(2210071,'1','142','798',342,'Retail Sale Id 1301685',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 16:40:56','',''),(2210072,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 16:40:56','',''),(2210217,'1','142','798',342,'Retail Sale Id 1301762',4001.60,0.00,0.00,0.00,390.40,'2021-12-08 16:48:47','',''),(2210218,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-08 16:48:47','',''),(2210253,'1','142','798',342,'Retail Sale Id 1301777',2000.80,0.00,0.00,0.00,195.20,'2021-12-08 16:50:05','',''),(2210254,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 16:50:05','',''),(2210312,'1','142','798',342,'Retail Sale Id 1301810',4500.16,0.00,0.00,0.00,439.04,'2021-12-08 16:53:55','',''),(2210313,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.86,0.00,'2021-12-08 16:53:55','',''),(2210346,'1','142','798',342,'Retail Sale Id 1301827',1502.24,0.00,0.00,0.00,146.56,'2021-12-08 16:55:37','',''),(2210347,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-08 16:55:37','',''),(2210468,'1','142','798',342,'Retail Sale Id 1301895',2624.00,0.00,0.00,0.00,256.00,'2021-12-08 17:05:25','',''),(2210469,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 17:05:25','',''),(2210478,'1','142','798',342,'Retail Sale Id 1301900',8200.00,0.00,0.00,0.00,800.00,'2021-12-08 17:06:08','',''),(2210479,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 17:06:08','',''),(2210527,'1','142','798',342,'Retail Sale Id 1301928',656.00,0.00,0.00,0.00,64.00,'2021-12-08 17:10:55','',''),(2210528,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 17:10:55','',''),(2210539,'1','142','798',342,'Retail Sale Id 1301936',3280.00,0.00,0.00,0.00,320.00,'2021-12-08 17:11:55','',''),(2210540,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 17:11:55','',''),(2210547,'1','142','798',342,'Retail Sale Id 1301942',997.12,0.00,0.00,0.00,97.28,'2021-12-08 17:12:31','',''),(2210548,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-08 17:12:31','',''),(2210555,'1','142','798',342,'Retail Sale Id 1301948',3936.00,0.00,0.00,0.00,384.00,'2021-12-08 17:13:07','',''),(2210556,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 17:13:07','',''),(2210734,'1','142','798',342,'Retail Sale Id 1302048',707256.00,0.00,0.00,0.00,39480.00,'2021-12-08 17:31:09','',''),(2210735,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1128.00,0.00,'2021-12-08 17:31:09','',''),(2210757,'1','142','798',342,'Retail Sale Id 1302060',344850.00,0.00,0.00,0.00,19250.00,'2021-12-08 17:34:36','',''),(2210758,'1','142','798',342,'Retail sales',0.00,0.00,0.00,550.00,0.00,'2021-12-08 17:34:36','',''),(2211290,'1','142','798',342,'Retail Sale Id 1302245',59827.20,0.00,0.00,0.00,5836.80,'2021-12-08 19:23:41','',''),(2211291,'1','142','798',342,'Retail sales',0.00,0.00,0.00,91.20,0.00,'2021-12-08 19:23:41','',''),(2215287,'1','142','798',342,'Retail Sale Id 1303902',2997.92,0.00,0.00,0.00,292.48,'2021-12-09 09:02:50','',''),(2215288,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-09 09:02:50','',''),(2215315,'1','142','798',342,'Retail Sale Id 1303922',2000.80,0.00,0.00,0.00,195.20,'2021-12-09 09:04:39','',''),(2215316,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 09:04:39','',''),(2215338,'1','142','798',342,'Retail Sale Id 1303933',1312.00,0.00,0.00,0.00,128.00,'2021-12-09 09:06:22','',''),(2215339,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 09:06:22','',''),(2215575,'1','142','798',342,'Retail Sale Id 1304054',3936.00,0.00,0.00,0.00,384.00,'2021-12-09 09:21:10','',''),(2215576,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 09:21:10','',''),(2215577,'1','142','798',342,'Retail Sale Id 1304054',3936.00,0.00,0.00,0.00,384.00,'2021-12-09 09:21:10','',''),(2215578,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 09:21:10','',''),(2215613,'1','142','798',342,'Retail Sale Id 1304074',1968.00,0.00,0.00,0.00,192.00,'2021-12-09 09:23:04','',''),(2215614,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 09:23:04','',''),(2215662,'1','142','798',342,'Retail Sale Id 1304096',8200.00,0.00,0.00,0.00,800.00,'2021-12-09 09:24:58','',''),(2215663,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:24:58','',''),(2215714,'1','142','798',342,'Retail Sale Id 1304123',3936.00,0.00,0.00,0.00,384.00,'2021-12-09 09:28:02','',''),(2215715,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 09:28:02','',''),(2215756,'1','142','798',342,'Retail Sale Id 1304144',1200.48,0.00,0.00,0.00,117.12,'2021-12-09 09:30:40','',''),(2215757,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.83,0.00,'2021-12-09 09:30:40','',''),(2215887,'1','142','798',342,'Retail Sale Id 1304195',1502.24,0.00,0.00,0.00,146.56,'2021-12-09 09:36:01','',''),(2215888,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-09 09:36:01','',''),(2215889,'1','142','798',342,'Retail Sale Id 1304195',3503.04,0.00,0.00,0.00,341.76,'2021-12-09 09:36:01','',''),(2215890,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-09 09:36:01','',''),(2215962,'1','142','798',342,'Retail Sale Id 1304236',8200.00,0.00,0.00,0.00,800.00,'2021-12-09 09:40:19','',''),(2215963,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:40:19','',''),(2216139,'1','142','798',342,'Retail Sale Id 1304286',1935.20,0.00,0.00,0.00,188.80,'2021-12-09 09:47:52','',''),(2216140,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.95,0.00,'2021-12-09 09:47:52','',''),(2216191,'1','142','798',342,'Retail Sale Id 1304307',5904.00,0.00,0.00,0.00,576.00,'2021-12-09 09:51:03','',''),(2216192,'1','142','798',342,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-09 09:51:03','',''),(2216239,'1','142','799',342,'Retail Sale Id 1304341',997.12,0.00,0.00,0.00,97.28,'2021-12-09 09:53:31','',''),(2216240,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-09 09:53:31','',''),(2216308,'1','142','798',342,'Retail Sale Id 1304364',8200.00,0.00,0.00,0.00,800.00,'2021-12-09 09:55:42','',''),(2216309,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:55:42','',''),(2216370,'1','142','798',342,'Retail Sale Id 1304400',1968.00,0.00,0.00,0.00,192.00,'2021-12-09 09:58:45','',''),(2216371,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 09:58:45','',''),(2216434,'1','142','798',342,'Retail Sale Id 1304425',3936.00,0.00,0.00,0.00,384.00,'2021-12-09 10:01:45','',''),(2216435,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 10:01:45','',''),(2216465,'1','142','798',342,'Retail Sale Id 1304439',3936.00,0.00,0.00,0.00,384.00,'2021-12-09 10:04:00','',''),(2216466,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 10:04:00','',''),(2216510,'1','142','798',342,'Retail Sale Id 1304455',1968.00,0.00,0.00,0.00,192.00,'2021-12-09 10:06:06','',''),(2216511,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 10:06:06','',''),(2216535,'1','142','798',342,'Retail Sale Id 1304476',1502.24,0.00,0.00,0.00,146.56,'2021-12-09 10:07:29','',''),(2216536,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-09 10:07:29','',''),(2216585,'1','142','798',342,'Retail Sale Id 1304505',2000.80,0.00,0.00,0.00,195.20,'2021-12-09 10:11:19','',''),(2216586,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 10:11:19','',''),(2216815,'1','142','798',342,'Retail Sale Id 1304627',3503.04,0.00,0.00,0.00,341.76,'2021-12-09 10:26:24','',''),(2216816,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-09 10:26:24','',''),(2216851,'1','142','798',342,'Retail Sale Id 1304649',3936.00,0.00,0.00,0.00,384.00,'2021-12-09 10:28:50','',''),(2216852,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 10:28:50','',''),(2216907,'1','142','798',342,'Retail Sale Id 1304676',1968.00,0.00,0.00,0.00,192.00,'2021-12-09 10:32:09','',''),(2216908,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 10:32:09','',''),(2216927,'1','142','798',342,'Retail Sale Id 1304686',2997.92,0.00,0.00,0.00,292.48,'2021-12-09 10:33:50','',''),(2216928,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-09 10:33:50','',''),(2216933,'1','142','798',342,'Retail Sale Id 1304690',701.92,0.00,0.00,0.00,68.48,'2021-12-09 10:34:38','',''),(2216934,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.07,0.00,'2021-12-09 10:34:38','',''),(2216957,'1','142','798',342,'Retail Sale Id 1304702',8200.00,0.00,0.00,0.00,800.00,'2021-12-09 10:35:57','',''),(2216958,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:35:57','',''),(2217004,'1','142','798',342,'Retail Sale Id 1304726',3936.00,0.00,0.00,0.00,384.00,'2021-12-09 10:40:00','',''),(2217005,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 10:40:00','',''),(2217677,'1','142','798',342,'Retail Sale Id 1305062',3503.04,0.00,0.00,0.00,341.76,'2021-12-09 11:23:14','',''),(2217678,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-09 11:23:14','',''),(2217704,'1','142','798',342,'Retail Sale Id 1305074',800.32,0.00,0.00,0.00,78.08,'2021-12-09 11:24:52','',''),(2217705,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.22,0.00,'2021-12-09 11:24:52','',''),(2217706,'1','142','798',342,'Retail Sale Id 1305074',800.32,0.00,0.00,0.00,78.08,'2021-12-09 11:24:52','',''),(2217707,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.22,0.00,'2021-12-09 11:24:52','',''),(2217847,'1','142','798',342,'Retail Sale Id 1305141',5248.00,0.00,0.00,0.00,512.00,'2021-12-09 11:33:11','',''),(2217848,'1','142','798',342,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-09 11:33:11','',''),(2217868,'1','142','798',342,'Retail Sale Id 1305149',1968.00,0.00,0.00,0.00,192.00,'2021-12-09 11:35:10','',''),(2217869,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:35:10','',''),(2217882,'1','142','798',342,'Retail Sale Id 1305159',3936.00,0.00,0.00,0.00,384.00,'2021-12-09 11:35:55','',''),(2217883,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 11:35:55','',''),(2218036,'1','142','798',342,'Retail Sale Id 1305230',346500.00,0.00,0.00,0.00,20900.00,'2021-12-09 11:46:16','',''),(2218037,'1','142','798',342,'Retail sales',0.00,0.00,0.00,550.00,0.00,'2021-12-09 11:46:16','',''),(2218054,'1','142','798',342,'Retail Sale Id 1305237',8200.00,0.00,0.00,0.00,800.00,'2021-12-09 11:47:15','',''),(2218055,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:47:15','',''),(2218110,'1','142','798',342,'Retail Sale Id 1305266',2000.80,0.00,0.00,0.00,195.20,'2021-12-09 11:49:45','',''),(2218111,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 11:49:45','',''),(2218122,'1','142','798',342,'Retail Sale Id 1305275',3936.00,0.00,0.00,0.00,384.00,'2021-12-09 11:50:31','',''),(2218123,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 11:50:31','',''),(2218156,'1','142','798',342,'Retail Sale Id 1305293',2997.92,0.00,0.00,0.00,292.48,'2021-12-09 11:52:54','',''),(2218157,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-09 11:52:54','',''),(2218290,'1','142','798',342,'Retail Sale Id 1305365',1968.00,0.00,0.00,0.00,192.00,'2021-12-09 12:01:58','',''),(2218291,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 12:01:58','',''),(2218375,'1','142','798',342,'Retail Sale Id 1305407',3280.00,0.00,0.00,0.00,320.00,'2021-12-09 12:08:04','',''),(2218376,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 12:08:04','',''),(2218429,'1','142','798',342,'Retail Sale Id 1305438',1968.00,0.00,0.00,0.00,192.00,'2021-12-09 12:11:50','',''),(2218430,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 12:11:50','',''),(2218431,'1','142','798',342,'Retail Sale Id 1305438',1968.00,0.00,0.00,0.00,192.00,'2021-12-09 12:11:50','',''),(2218432,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 12:11:50','',''),(2218481,'1','142','798',342,'Retail Sale Id 1305458',31500.00,0.00,0.00,0.00,1900.00,'2021-12-09 12:13:49','',''),(2218482,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 12:13:49','',''),(2218501,'1','142','798',342,'Retail Sale Id 1305465',2000.80,0.00,0.00,0.00,195.20,'2021-12-09 12:14:56','',''),(2218502,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 12:14:56','',''),(2218570,'1','142','798',342,'Retail Sale Id 1305503',2000.80,0.00,0.00,0.00,195.20,'2021-12-09 12:19:42','',''),(2218571,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 12:19:42','',''),(2218584,'1','142','799',342,'Retail Sale Id 1305512',2997.92,0.00,0.00,0.00,292.48,'2021-12-09 12:21:15','',''),(2218585,'1','142','799',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-09 12:21:15','',''),(2218626,'1','142','798',342,'Retail Sale Id 1305534',1502.24,0.00,0.00,0.00,146.56,'2021-12-09 12:23:59','',''),(2218627,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-09 12:23:59','',''),(2218664,'1','142','798',342,'Retail Sale Id 1305562',144210.00,0.00,0.00,0.00,8050.00,'2021-12-09 12:26:46','',''),(2218665,'1','142','798',342,'Retail sales',0.00,0.00,0.00,230.00,0.00,'2021-12-09 12:26:46','',''),(2218712,'1','142','798',342,'Retail Sale Id 1305589',61446.00,0.00,0.00,0.00,3430.00,'2021-12-09 12:29:39','',''),(2218713,'1','142','798',342,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-09 12:29:39','',''),(2218748,'1','142','798',342,'Retail Sale Id 1305604',8200.00,0.00,0.00,0.00,800.00,'2021-12-09 12:31:58','',''),(2218749,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 12:31:58','',''),(2218784,'1','142','798',342,'Retail Sale Id 1305626',2000.80,0.00,0.00,0.00,195.20,'2021-12-09 12:34:01','',''),(2218785,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 12:34:01','',''),(2218802,'1','142','798',342,'Retail Sale Id 1305639',2997.92,0.00,0.00,0.00,292.48,'2021-12-09 12:35:15','',''),(2218803,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-09 12:35:15','',''),(2218910,'1','142','798',342,'Retail Sale Id 1305686',1502.24,0.00,0.00,0.00,146.56,'2021-12-09 12:41:15','',''),(2218911,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-09 12:41:15','',''),(2218912,'1','142','798',342,'Retail Sale Id 1305686',1502.24,0.00,0.00,0.00,146.56,'2021-12-09 12:41:15','',''),(2218913,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-09 12:41:15','',''),(2219001,'1','142','798',342,'Retail Sale Id 1305734',1968.00,0.00,0.00,0.00,192.00,'2021-12-09 12:46:11','',''),(2219002,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 12:46:11','',''),(2219083,'1','142','798',342,'Retail Sale Id 1305768',4001.60,0.00,0.00,0.00,390.40,'2021-12-09 12:49:41','',''),(2219084,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-09 12:49:41','',''),(2219109,'1','142','798',342,'Retail Sale Id 1305783',2000.80,0.00,0.00,0.00,195.20,'2021-12-09 12:51:04','',''),(2219110,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 12:51:04','',''),(2219129,'1','142','798',342,'Retail Sale Id 1305796',4001.60,0.00,0.00,0.00,390.40,'2021-12-09 12:52:36','',''),(2219130,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-09 12:52:36','',''),(2219180,'1','142','798',342,'Retail Sale Id 1305824',1298.88,0.00,0.00,0.00,126.72,'2021-12-09 12:56:11','',''),(2219181,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.98,0.00,'2021-12-09 12:56:11','',''),(2219231,'1','142','798',342,'Retail Sale Id 1305841',2997.92,0.00,0.00,0.00,292.48,'2021-12-09 12:57:43','',''),(2219232,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-09 12:57:43','',''),(2219253,'1','142','798',342,'Retail Sale Id 1305850',997.12,0.00,0.00,0.00,97.28,'2021-12-09 12:59:03','',''),(2219254,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-09 12:59:03','',''),(2219277,'1','142','798',342,'Retail Sale Id 1305863',3280.00,0.00,0.00,0.00,320.00,'2021-12-09 13:00:45','',''),(2219278,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 13:00:45','',''),(2219325,'1','142','798',342,'Retail Sale Id 1305893',7216.00,0.00,0.00,0.00,704.00,'2021-12-09 13:04:41','',''),(2219326,'1','142','798',342,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-09 13:04:41','',''),(2219359,'1','142','798',342,'Retail Sale Id 1305920',4001.60,0.00,0.00,0.00,390.40,'2021-12-09 13:08:10','',''),(2219360,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-09 13:08:10','',''),(2219571,'1','142','798',342,'Retail Sale Id 1306004',1968.00,0.00,0.00,0.00,192.00,'2021-12-09 13:20:54','',''),(2219572,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 13:20:54','',''),(2219575,'1','142','798',342,'Retail Sale Id 1306010',4998.72,0.00,0.00,0.00,487.68,'2021-12-09 13:22:20','',''),(2219576,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-09 13:22:20','',''),(2219587,'1','142','798',342,'Retail Sale Id 1306016',701.92,0.00,0.00,0.00,68.48,'2021-12-09 13:23:57','',''),(2219588,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.07,0.00,'2021-12-09 13:23:57','',''),(2219599,'1','142','798',342,'Retail Sale Id 1306021',1312.00,0.00,0.00,0.00,128.00,'2021-12-09 13:24:47','',''),(2219600,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 13:24:47','',''),(2219656,'1','142','798',342,'Retail Sale Id 1306045',3936.00,0.00,0.00,0.00,384.00,'2021-12-09 13:27:54','',''),(2219657,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 13:27:54','',''),(2219658,'1','142','798',342,'Retail Sale Id 1306045',6500.96,0.00,0.00,0.00,634.24,'2021-12-09 13:27:54','',''),(2219659,'1','142','798',342,'Retail sales',0.00,0.00,0.00,9.91,0.00,'2021-12-09 13:27:54','',''),(2220018,'1','142','798',342,'Retail Sale Id 1306167',2000.80,0.00,0.00,0.00,195.20,'2021-12-09 13:44:32','',''),(2220019,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 13:44:32','',''),(2220044,'1','142','798',342,'Retail Sale Id 1306179',2000.80,0.00,0.00,0.00,195.20,'2021-12-09 13:46:05','',''),(2220045,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 13:46:05','',''),(2220056,'1','142','798',342,'Retail Sale Id 1306187',1968.00,0.00,0.00,0.00,192.00,'2021-12-09 13:47:10','',''),(2220057,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 13:47:10','',''),(2220104,'1','142','798',342,'Retail Sale Id 1306207',8200.00,0.00,0.00,0.00,800.00,'2021-12-09 13:49:49','',''),(2220105,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 13:49:49','',''),(2220136,'1','142','798',342,'Retail Sale Id 1306224',3936.00,0.00,0.00,0.00,384.00,'2021-12-09 13:51:59','',''),(2220137,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 13:51:59','',''),(2220181,'1','142','798',342,'Retail Sale Id 1306248',1968.00,0.00,0.00,0.00,192.00,'2021-12-09 13:55:17','',''),(2220182,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 13:55:17','',''),(2220207,'1','142','798',342,'Retail Sale Id 1306262',1968.00,0.00,0.00,0.00,192.00,'2021-12-09 13:56:47','',''),(2220208,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 13:56:47','',''),(2220234,'1','142','798',342,'Retail Sale Id 1306277',1502.24,0.00,0.00,0.00,146.56,'2021-12-09 13:59:35','',''),(2220235,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-09 13:59:35','',''),(2220236,'1','142','798',342,'Retail Sale Id 1306277',1502.24,0.00,0.00,0.00,146.56,'2021-12-09 13:59:35','',''),(2220237,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-09 13:59:35','',''),(2220254,'1','142','798',342,'Retail Sale Id 1306282',997.12,0.00,0.00,0.00,97.28,'2021-12-09 14:01:00','',''),(2220255,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-09 14:01:00','',''),(2220266,'1','142','798',342,'Retail Sale Id 1306288',4001.60,0.00,0.00,0.00,390.40,'2021-12-09 14:02:09','',''),(2220267,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-09 14:02:09','',''),(2220294,'1','142','798',342,'Retail Sale Id 1306301',8200.00,0.00,0.00,0.00,800.00,'2021-12-09 14:04:35','',''),(2220295,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:04:35','',''),(2220296,'1','142','798',342,'Retail Sale Id 1306301',8200.00,0.00,0.00,0.00,800.00,'2021-12-09 14:04:35','',''),(2220297,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:04:35','',''),(2220580,'1','142','798',342,'Retail Sale Id 1306469',3936.00,0.00,0.00,0.00,384.00,'2021-12-09 14:21:47','',''),(2220581,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 14:21:47','',''),(2220614,'1','142','798',342,'Retail Sale Id 1306483',4001.60,0.00,0.00,0.00,390.40,'2021-12-09 14:22:26','',''),(2220615,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-09 14:22:26','',''),(2220626,'1','142','798',342,'Retail Sale Id 1306490',3936.00,0.00,0.00,0.00,384.00,'2021-12-09 14:23:16','',''),(2220627,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 14:23:16','',''),(2220716,'1','142','798',342,'Retail Sale Id 1306534',1968.00,0.00,0.00,0.00,192.00,'2021-12-09 14:27:24','',''),(2220717,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 14:27:24','',''),(2220755,'1','142','798',342,'Retail Sale Id 1306555',2000.80,0.00,0.00,0.00,195.20,'2021-12-09 14:29:37','',''),(2220756,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 14:29:37','',''),(2220800,'1','142','798',342,'Retail Sale Id 1306573',2000.80,0.00,0.00,0.00,195.20,'2021-12-09 14:32:05','',''),(2220801,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 14:32:05','',''),(2220895,'1','142','798',342,'Retail Sale Id 1306610',3936.00,0.00,0.00,0.00,384.00,'2021-12-09 14:35:29','',''),(2220896,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 14:35:29','',''),(2220927,'1','142','798',342,'Retail Sale Id 1306620',2000.80,0.00,0.00,0.00,195.20,'2021-12-09 14:36:27','',''),(2220928,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 14:36:27','',''),(2220992,'1','142','798',342,'Retail Sale Id 1306655',3280.00,0.00,0.00,0.00,320.00,'2021-12-09 14:39:08','',''),(2220993,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 14:39:08','',''),(2221022,'1','142','798',342,'Retail Sale Id 1306676',1502.24,0.00,0.00,0.00,146.56,'2021-12-09 14:40:41','',''),(2221023,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-09 14:40:41','',''),(2221051,'1','142','798',342,'Retail Sale Id 1306688',2000.80,0.00,0.00,0.00,195.20,'2021-12-09 14:41:46','',''),(2221052,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 14:41:46','',''),(2221082,'1','142','798',342,'Retail Sale Id 1306700',3280.00,0.00,0.00,0.00,320.00,'2021-12-09 14:43:01','',''),(2221083,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 14:43:01','',''),(2221323,'1','142','798',342,'Retail Sale Id 1306784',8003.20,0.00,0.00,0.00,780.80,'2021-12-09 14:51:46','',''),(2221324,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-09 14:51:46','',''),(2221672,'1','142','798',342,'Retail Sale Id 1306950',1968.00,0.00,0.00,0.00,192.00,'2021-12-09 15:09:22','',''),(2221673,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:09:22','',''),(2221674,'1','142','798',342,'Retail Sale Id 1306950',1968.00,0.00,0.00,0.00,192.00,'2021-12-09 15:09:22','',''),(2221675,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:09:22','',''),(2221705,'1','142','798',342,'Retail Sale Id 1306969',3503.04,0.00,0.00,0.00,341.76,'2021-12-09 15:10:42','',''),(2221706,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-09 15:10:42','',''),(2222739,'1','142','798',342,'Retail Sale Id 1307481',4001.60,0.00,0.00,0.00,390.40,'2021-12-09 16:05:00','',''),(2222740,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-09 16:05:00','',''),(2222773,'1','142','798',342,'Retail Sale Id 1307500',1968.00,0.00,0.00,0.00,192.00,'2021-12-09 16:06:37','',''),(2222774,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:06:37','',''),(2222827,'1','142','798',342,'Retail Sale Id 1307529',8200.00,0.00,0.00,0.00,800.00,'2021-12-09 16:09:16','',''),(2222828,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:09:16','',''),(2223723,'1','142','798',342,'Retail Sale Id 1307872',2000.80,0.00,0.00,0.00,195.20,'2021-12-09 16:57:31','',''),(2223724,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 16:57:31','',''),(2223758,'1','142','798',342,'Retail Sale Id 1307944',6560.00,0.00,0.00,0.00,640.00,'2021-12-09 17:00:02','',''),(2223759,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 17:00:02','',''),(2223790,'1','142','798',342,'Retail Sale Id 1307962',1968.00,0.00,0.00,0.00,192.00,'2021-12-09 17:01:59','',''),(2223791,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 17:01:59','',''),(2223885,'1','142','798',342,'Retail Sale Id 1308006',1502.24,0.00,0.00,0.00,146.56,'2021-12-09 17:07:51','',''),(2223886,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-09 17:07:51','',''),(2224010,'1','142','798',342,'Retail Sale Id 1308073',3936.00,0.00,0.00,0.00,384.00,'2021-12-09 17:20:01','',''),(2224011,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 17:20:01','',''),(2224034,'1','142','798',342,'Retail Sale Id 1308085',997.12,0.00,0.00,0.00,97.28,'2021-12-09 17:22:08','',''),(2224035,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-09 17:22:08','',''),(2224050,'1','142','798',342,'Retail Sale Id 1308092',2000.80,0.00,0.00,0.00,195.20,'2021-12-09 17:23:46','',''),(2224051,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 17:23:46','',''),(2224284,'1','142','798',342,'Retail Sale Id 1308207',31500.00,0.00,0.00,0.00,1900.00,'2021-12-09 18:01:36','',''),(2224285,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 18:01:36','',''),(2224349,'1','142','798',342,'Retail Sale Id 1308235',125600.00,0.00,0.00,0.00,7200.00,'2021-12-09 18:13:14','',''),(2224350,'1','142','798',342,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-09 18:13:14','',''),(2224473,'1','142','798',342,'Retail Sale Id 1308283',246328.00,0.00,0.00,0.00,24032.00,'2021-12-09 18:40:14','',''),(2224474,'1','142','798',342,'Retail sales',0.00,0.00,0.00,375.50,0.00,'2021-12-09 18:40:14','',''),(2225727,'1','142','798',342,'Retail Sale Id 1308657',2003.04,0.00,0.00,0.00,2003.04,'2021-12-10 06:57:04','',''),(2225728,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 06:57:04','',''),(2225916,'1','142','798',342,'Retail Sale Id 1308752',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 07:10:08','',''),(2225917,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:10:08','',''),(2226024,'1','142','798',342,'Retail Sale Id 1308811',6002.88,0.00,0.00,0.00,6002.88,'2021-12-10 07:16:32','',''),(2226025,'1','142','798',342,'Retail sales',0.00,0.00,0.00,9.62,0.00,'2021-12-10 07:16:32','',''),(2226257,'1','142','798',342,'Retail Sale Id 1308928',3120.00,0.00,0.00,0.00,3120.00,'2021-12-10 07:28:06','',''),(2226258,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 07:28:06','',''),(2226322,'1','142','798',342,'Retail Sale Id 1308960',3120.00,0.00,0.00,0.00,3120.00,'2021-12-10 07:32:33','',''),(2226323,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 07:32:33','',''),(2226415,'1','142','798',342,'Retail Sale Id 1308998',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 07:37:13','',''),(2226416,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:37:13','',''),(2226505,'1','142','798',342,'Retail Sale Id 1309043',3120.00,0.00,0.00,0.00,3120.00,'2021-12-10 07:42:15','',''),(2226506,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 07:42:15','',''),(2226507,'1','142','798',342,'Retail Sale Id 1309043',3120.00,0.00,0.00,0.00,3120.00,'2021-12-10 07:42:15','',''),(2226508,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 07:42:15','',''),(2226585,'1','142','798',342,'Retail Sale Id 1309083',3999.84,0.00,0.00,0.00,3999.84,'2021-12-10 07:47:37','',''),(2226586,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-10 07:47:37','',''),(2226783,'1','142','798',342,'Retail Sale Id 1309172',998.40,0.00,0.00,0.00,998.40,'2021-12-10 07:57:27','',''),(2226784,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 07:57:27','',''),(2226861,'1','142','798',342,'Retail Sale Id 1309184',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 07:59:24','',''),(2226862,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:59:24','',''),(2227074,'1','142','798',342,'Retail Sale Id 1309268',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 08:09:03','',''),(2227075,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:09:03','',''),(2227166,'1','142','798',342,'Retail Sale Id 1309300',998.40,0.00,0.00,0.00,998.40,'2021-12-10 08:14:10','',''),(2227167,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 08:14:10','',''),(2227279,'1','142','798',342,'Retail Sale Id 1309357',147000.00,0.00,0.00,0.00,147000.00,'2021-12-10 08:20:09','',''),(2227280,'1','142','798',342,'Retail sales',0.00,0.00,0.00,245.00,0.00,'2021-12-10 08:20:09','',''),(2227311,'1','142','798',342,'Retail Sale Id 1309387',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 08:21:40','',''),(2227312,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:21:40','',''),(2227358,'1','142','798',342,'Retail Sale Id 1309398',1497.60,0.00,0.00,0.00,1497.60,'2021-12-10 08:23:16','',''),(2227359,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-10 08:23:16','',''),(2227499,'1','142','798',342,'Retail Sale Id 1309456',1248.00,0.00,0.00,0.00,1248.00,'2021-12-10 08:29:34','',''),(2227500,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 08:29:34','',''),(2227615,'1','142','798',342,'Retail Sale Id 1309520',3120.00,0.00,0.00,0.00,3120.00,'2021-12-10 08:35:17','',''),(2227616,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 08:35:17','',''),(2227645,'1','142','798',342,'Retail Sale Id 1309536',3744.00,0.00,0.00,0.00,3744.00,'2021-12-10 08:36:57','',''),(2227646,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 08:36:57','',''),(2227810,'1','142','798',342,'Retail Sale Id 1309615',998.40,0.00,0.00,0.00,998.40,'2021-12-10 08:45:33','',''),(2227811,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 08:45:33','',''),(2227962,'1','142','798',342,'Retail Sale Id 1309676',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 08:51:00','',''),(2227963,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:51:00','',''),(2228130,'1','142','798',342,'Retail Sale Id 1309756',19000.80,0.00,0.00,0.00,19000.80,'2021-12-10 08:58:53','',''),(2228131,'1','142','798',342,'Retail sales',0.00,0.00,0.00,30.45,0.00,'2021-12-10 08:58:53','',''),(2228198,'1','142','798',342,'Retail Sale Id 1309792',1497.60,0.00,0.00,0.00,1497.60,'2021-12-10 09:01:34','',''),(2228199,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-10 09:01:34','',''),(2228200,'1','142','798',342,'Retail Sale Id 1309792',1497.60,0.00,0.00,0.00,1497.60,'2021-12-10 09:01:34','',''),(2228201,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-10 09:01:34','',''),(2228280,'1','142','798',342,'Retail Sale Id 1309832',1872.00,0.00,0.00,0.00,1872.00,'2021-12-10 09:05:16','',''),(2228281,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 09:05:16','',''),(2228282,'1','142','798',342,'Retail Sale Id 1309832',3744.00,0.00,0.00,0.00,3744.00,'2021-12-10 09:05:16','',''),(2228283,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 09:05:16','',''),(2228531,'1','142','798',342,'Retail Sale Id 1309945',3500.64,0.00,0.00,0.00,3500.64,'2021-12-10 09:19:56','',''),(2228532,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.61,0.00,'2021-12-10 09:19:56','',''),(2228549,'1','142','798',342,'Retail Sale Id 1309958',998.40,0.00,0.00,0.00,998.40,'2021-12-10 09:21:33','',''),(2228550,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 09:21:33','',''),(2228589,'1','142','798',342,'Retail Sale Id 1309971',3120.00,0.00,0.00,0.00,3120.00,'2021-12-10 09:23:55','',''),(2228590,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 09:23:55','',''),(2228644,'1','142','798',342,'Retail Sale Id 1310001',3750.24,0.00,0.00,0.00,3750.24,'2021-12-10 09:27:51','',''),(2228645,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 09:27:51','',''),(2228695,'1','142','798',342,'Retail Sale Id 1310026',3120.00,0.00,0.00,0.00,3120.00,'2021-12-10 09:30:47','',''),(2228696,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 09:30:47','',''),(2228710,'1','142','798',342,'Retail Sale Id 1310034',1248.00,0.00,0.00,0.00,1248.00,'2021-12-10 09:32:13','',''),(2228711,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 09:32:13','',''),(2228781,'1','142','798',342,'Retail Sale Id 1310063',1896.96,0.00,0.00,0.00,1896.96,'2021-12-10 09:34:50','',''),(2228782,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.04,0.00,'2021-12-10 09:34:50','',''),(2228867,'1','142','798',342,'Retail Sale Id 1310107',1872.00,0.00,0.00,0.00,1872.00,'2021-12-10 09:40:26','',''),(2228868,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 09:40:26','',''),(2228891,'1','142','798',342,'Retail Sale Id 1310118',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 09:41:32','',''),(2228892,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 09:41:32','',''),(2228909,'1','142','798',342,'Retail Sale Id 1310131',3999.84,0.00,0.00,0.00,3999.84,'2021-12-10 09:42:50','',''),(2228910,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-10 09:42:50','',''),(2229013,'1','142','798',342,'Retail Sale Id 1310185',1872.00,0.00,0.00,0.00,1872.00,'2021-12-10 09:48:38','',''),(2229014,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 09:48:38','',''),(2229047,'1','142','798',342,'Retail Sale Id 1310197',6240.00,0.00,0.00,0.00,6240.00,'2021-12-10 09:50:11','',''),(2229048,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 09:50:11','',''),(2229073,'1','142','798',342,'Retail Sale Id 1310212',2003.04,0.00,0.00,0.00,2003.04,'2021-12-10 09:52:14','',''),(2229074,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 09:52:14','',''),(2229123,'1','142','798',342,'Retail Sale Id 1310238',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 09:54:28','',''),(2229124,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 09:54:28','',''),(2229149,'1','142','798',342,'Retail Sale Id 1310251',2003.04,0.00,0.00,0.00,2003.04,'2021-12-10 09:56:19','',''),(2229150,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 09:56:19','',''),(2229243,'1','142','798',342,'Retail Sale Id 1310292',2502.24,0.00,0.00,0.00,2502.24,'2021-12-10 10:01:50','',''),(2229244,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-10 10:01:50','',''),(2229257,'1','142','798',342,'Retail Sale Id 1310298',7500.48,0.00,0.00,0.00,7500.48,'2021-12-10 10:03:16','',''),(2229258,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.02,0.00,'2021-12-10 10:03:16','',''),(2229294,'1','142','798',342,'Retail Sale Id 1310311',1697.28,0.00,0.00,0.00,1697.28,'2021-12-10 10:04:57','',''),(2229295,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.72,0.00,'2021-12-10 10:04:57','',''),(2229329,'1','142','798',342,'Retail Sale Id 1310327',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 10:07:12','',''),(2229330,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 10:07:12','',''),(2229353,'1','142','798',342,'Retail Sale Id 1310335',1872.00,0.00,0.00,0.00,1872.00,'2021-12-10 10:08:27','',''),(2229354,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 10:08:27','',''),(2229381,'1','142','798',342,'Retail Sale Id 1310355',3744.00,0.00,0.00,0.00,3744.00,'2021-12-10 10:10:14','',''),(2229382,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:10:14','',''),(2229411,'1','142','798',342,'Retail Sale Id 1310368',24000.00,0.00,0.00,0.00,24000.00,'2021-12-10 10:11:21','',''),(2229412,'1','142','798',342,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-10 10:11:21','',''),(2229451,'1','142','798',342,'Retail Sale Id 1310391',4998.24,0.00,0.00,0.00,4998.24,'2021-12-10 10:13:47','',''),(2229452,'1','142','798',342,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-10 10:13:47','',''),(2229487,'1','142','798',342,'Retail Sale Id 1310402',6240.00,0.00,0.00,0.00,6240.00,'2021-12-10 10:15:04','',''),(2229488,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 10:15:04','',''),(2229609,'1','142','798',342,'Retail Sale Id 1310459',1872.00,0.00,0.00,0.00,1872.00,'2021-12-10 10:21:20','',''),(2229610,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 10:21:20','',''),(2229735,'1','142','798',342,'Retail Sale Id 1310519',3744.00,0.00,0.00,0.00,3744.00,'2021-12-10 10:28:14','',''),(2229736,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:28:14','',''),(2229759,'1','142','798',342,'Retail Sale Id 1310529',1497.60,0.00,0.00,0.00,1497.60,'2021-12-10 10:29:41','',''),(2229760,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-10 10:29:41','',''),(2229801,'1','142','798',342,'Retail Sale Id 1310552',1872.00,0.00,0.00,0.00,1872.00,'2021-12-10 10:33:13','',''),(2229802,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 10:33:13','',''),(2229850,'1','142','798',342,'Retail Sale Id 1310568',2003.04,0.00,0.00,0.00,2003.04,'2021-12-10 10:35:24','',''),(2229851,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 10:35:24','',''),(2230017,'1','142','798',342,'Retail Sale Id 1310639',30000.00,0.00,0.00,0.00,30000.00,'2021-12-10 10:45:43','',''),(2230018,'1','142','798',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 10:45:43','',''),(2230184,'1','142','798',342,'Retail Sale Id 1310712',3744.00,0.00,0.00,0.00,3744.00,'2021-12-10 10:53:32','',''),(2230185,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:53:32','',''),(2230194,'1','142','798',342,'Retail Sale Id 1310718',1248.00,0.00,0.00,0.00,1248.00,'2021-12-10 10:54:10','',''),(2230195,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 10:54:10','',''),(2230210,'1','142','798',342,'Retail Sale Id 1310723',3744.00,0.00,0.00,0.00,3744.00,'2021-12-10 10:54:55','',''),(2230211,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:54:55','',''),(2230222,'1','142','798',342,'Retail Sale Id 1310731',3744.00,0.00,0.00,0.00,3744.00,'2021-12-10 10:56:27','',''),(2230223,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:56:27','',''),(2230295,'1','142','798',342,'Retail Sale Id 1310772',2502.24,0.00,0.00,0.00,2502.24,'2021-12-10 11:00:41','',''),(2230296,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-10 11:00:41','',''),(2230548,'1','142','798',342,'Retail Sale Id 1310876',3744.00,0.00,0.00,0.00,3744.00,'2021-12-10 11:15:14','',''),(2230549,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 11:15:14','',''),(2230580,'1','142','798',342,'Retail Sale Id 1310897',3999.84,0.00,0.00,0.00,3999.84,'2021-12-10 11:17:29','',''),(2230581,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-10 11:17:29','',''),(2230672,'1','142','798',342,'Retail Sale Id 1310920',4998.24,0.00,0.00,0.00,4998.24,'2021-12-10 11:20:43','',''),(2230673,'1','142','798',342,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-10 11:20:43','',''),(2230721,'1','142','798',342,'Retail Sale Id 1310939',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 11:24:34','',''),(2230722,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 11:24:34','',''),(2231023,'1','142','798',342,'Retail Sale Id 1311099',1797.12,0.00,0.00,0.00,1797.12,'2021-12-10 11:47:15','',''),(2231024,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.88,0.00,'2021-12-10 11:47:15','',''),(2231057,'1','142','798',342,'Retail Sale Id 1311118',3120.00,0.00,0.00,0.00,3120.00,'2021-12-10 11:48:58','',''),(2231058,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 11:48:58','',''),(2231077,'1','142','798',342,'Retail Sale Id 1311129',4998.24,0.00,0.00,0.00,4998.24,'2021-12-10 11:51:25','',''),(2231078,'1','142','798',342,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-10 11:51:25','',''),(2231135,'1','142','798',342,'Retail Sale Id 1311159',1497.60,0.00,0.00,0.00,1497.60,'2021-12-10 11:55:27','',''),(2231136,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-10 11:55:27','',''),(2231175,'1','142','798',342,'Retail Sale Id 1311173',1248.00,0.00,0.00,0.00,1248.00,'2021-12-10 11:56:50','',''),(2231176,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 11:56:50','',''),(2231397,'1','142','798',342,'Retail Sale Id 1311282',3750.24,0.00,0.00,0.00,3750.24,'2021-12-10 12:14:05','',''),(2231398,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 12:14:05','',''),(2231411,'1','142','798',342,'Retail Sale Id 1311293',3001.44,0.00,0.00,0.00,3001.44,'2021-12-10 12:15:37','',''),(2231412,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-10 12:15:37','',''),(2231515,'1','142','798',342,'Retail Sale Id 1311348',4998.24,0.00,0.00,0.00,4998.24,'2021-12-10 12:24:23','',''),(2231516,'1','142','798',342,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-10 12:24:23','',''),(2231535,'1','142','798',342,'Retail Sale Id 1311359',998.40,0.00,0.00,0.00,998.40,'2021-12-10 12:25:35','',''),(2231536,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 12:25:35','',''),(2231644,'1','142','798',342,'Retail Sale Id 1311418',3750.24,0.00,0.00,0.00,3750.24,'2021-12-10 12:37:29','',''),(2231645,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 12:37:29','',''),(2231660,'1','142','798',342,'Retail Sale Id 1311440',2502.24,0.00,0.00,0.00,2502.24,'2021-12-10 12:39:18','',''),(2231661,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-10 12:39:18','',''),(2231920,'1','142','798',342,'Retail Sale Id 1311563',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 12:57:55','',''),(2231921,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 12:57:55','',''),(2231950,'1','142','798',342,'Retail Sale Id 1311579',1198.08,0.00,0.00,0.00,1198.08,'2021-12-10 12:59:57','',''),(2231951,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.92,0.00,'2021-12-10 12:59:57','',''),(2231980,'1','142','798',342,'Retail Sale Id 1311589',2003.04,0.00,0.00,0.00,2003.04,'2021-12-10 13:02:14','',''),(2231981,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 13:02:14','',''),(2231982,'1','142','798',342,'Retail Sale Id 1311589',2003.04,0.00,0.00,0.00,2003.04,'2021-12-10 13:02:14','',''),(2231983,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 13:02:14','',''),(2232195,'1','142','798',342,'Retail Sale Id 1311687',3132.48,0.00,0.00,0.00,3132.48,'2021-12-10 13:15:30','',''),(2232196,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.02,0.00,'2021-12-10 13:15:30','',''),(2232525,'1','142','798',342,'Retail Sale Id 1311852',1872.00,0.00,0.00,0.00,1872.00,'2021-12-10 13:35:27','',''),(2232526,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 13:35:27','',''),(2232695,'1','142','798',342,'Retail Sale Id 1311923',1497.60,0.00,0.00,0.00,1497.60,'2021-12-10 13:43:29','',''),(2232696,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-10 13:43:29','',''),(2232743,'1','142','798',342,'Retail Sale Id 1311938',2003.04,0.00,0.00,0.00,2003.04,'2021-12-10 13:45:07','',''),(2232744,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 13:45:07','',''),(2232779,'1','142','798',342,'Retail Sale Id 1311951',165000.00,0.00,0.00,0.00,165000.00,'2021-12-10 13:46:52','',''),(2232780,'1','142','798',342,'Retail sales',0.00,0.00,0.00,275.00,0.00,'2021-12-10 13:46:52','',''),(2232811,'1','142','798',342,'Retail Sale Id 1311965',1872.00,0.00,0.00,0.00,1872.00,'2021-12-10 13:47:50','',''),(2232812,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 13:47:50','',''),(2232943,'1','142','798',342,'Retail Sale Id 1312027',4992.00,0.00,0.00,0.00,4992.00,'2021-12-10 13:55:03','',''),(2232944,'1','142','798',342,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-10 13:55:03','',''),(2232983,'1','142','798',342,'Retail Sale Id 1312045',998.40,0.00,0.00,0.00,998.40,'2021-12-10 13:56:50','',''),(2232984,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 13:56:50','',''),(2233031,'1','142','798',342,'Retail Sale Id 1312065',1872.00,0.00,0.00,0.00,1872.00,'2021-12-10 13:59:02','',''),(2233032,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 13:59:02','',''),(2233335,'1','142','798',342,'Retail Sale Id 1312185',1872.00,0.00,0.00,0.00,1872.00,'2021-12-10 14:13:54','',''),(2233336,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 14:13:54','',''),(2233361,'1','142','798',342,'Retail Sale Id 1312199',1872.00,0.00,0.00,0.00,1872.00,'2021-12-10 14:15:13','',''),(2233362,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 14:15:13','',''),(2233405,'1','142','798',342,'Retail Sale Id 1312215',4992.00,0.00,0.00,0.00,4992.00,'2021-12-10 14:17:20','',''),(2233406,'1','142','798',342,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-10 14:17:20','',''),(2233481,'1','142','798',342,'Retail Sale Id 1312257',3999.84,0.00,0.00,0.00,3999.84,'2021-12-10 14:21:52','',''),(2233482,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-10 14:21:52','',''),(2233535,'1','142','798',342,'Retail Sale Id 1312274',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 14:23:31','',''),(2233536,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:23:31','',''),(2233663,'1','142','798',342,'Retail Sale Id 1312317',1497.60,0.00,0.00,0.00,1497.60,'2021-12-10 14:28:24','',''),(2233664,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-10 14:28:24','',''),(2233713,'1','142','798',342,'Retail Sale Id 1312345',998.40,0.00,0.00,0.00,998.40,'2021-12-10 14:30:22','',''),(2233714,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 14:30:22','',''),(2233743,'1','142','798',342,'Retail Sale Id 1312361',1797.12,0.00,0.00,0.00,1797.12,'2021-12-10 14:31:58','',''),(2233744,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.88,0.00,'2021-12-10 14:31:58','',''),(2233847,'1','142','798',342,'Retail Sale Id 1312406',2502.24,0.00,0.00,0.00,2502.24,'2021-12-10 14:36:33','',''),(2233848,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-10 14:36:33','',''),(2233906,'1','142','798',342,'Retail Sale Id 1312430',998.40,0.00,0.00,0.00,998.40,'2021-12-10 14:39:04','',''),(2233907,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 14:39:04','',''),(2233952,'1','142','798',342,'Retail Sale Id 1312446',6240.00,0.00,0.00,0.00,6240.00,'2021-12-10 14:40:34','',''),(2233953,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 14:40:34','',''),(2233998,'1','142','798',342,'Retail Sale Id 1312466',998.40,0.00,0.00,0.00,998.40,'2021-12-10 14:42:20','',''),(2233999,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 14:42:20','',''),(2234107,'1','142','798',342,'Retail Sale Id 1312512',3744.00,0.00,0.00,0.00,3744.00,'2021-12-10 14:46:03','',''),(2234108,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:46:03','',''),(2234201,'1','142','798',342,'Retail Sale Id 1312560',8736.00,0.00,0.00,0.00,8736.00,'2021-12-10 14:49:54','',''),(2234202,'1','142','798',342,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-10 14:49:54','',''),(2234258,'1','142','798',342,'Retail Sale Id 1312585',1872.00,0.00,0.00,0.00,1872.00,'2021-12-10 14:52:56','',''),(2234259,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 14:52:56','',''),(2234284,'1','142','798',342,'Retail Sale Id 1312597',998.40,0.00,0.00,0.00,998.40,'2021-12-10 14:54:16','',''),(2234285,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 14:54:16','',''),(2234328,'1','142','798',342,'Retail Sale Id 1312619',3744.00,0.00,0.00,0.00,3744.00,'2021-12-10 14:56:37','',''),(2234329,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:56:37','',''),(2234352,'1','142','798',342,'Retail Sale Id 1312632',1497.60,0.00,0.00,0.00,1497.60,'2021-12-10 14:58:02','',''),(2234353,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-10 14:58:02','',''),(2234354,'1','142','798',342,'Retail Sale Id 1312634',4998.24,0.00,0.00,0.00,4998.24,'2021-12-10 14:58:43','',''),(2234355,'1','142','798',342,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-10 14:58:43','',''),(2234376,'1','142','798',342,'Retail Sale Id 1312644',43800.00,0.00,0.00,0.00,43800.00,'2021-12-10 14:59:51','',''),(2234377,'1','142','798',342,'Retail sales',0.00,0.00,0.00,73.00,0.00,'2021-12-10 14:59:51','',''),(2234390,'1','142','798',342,'Retail Sale Id 1312653',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 15:00:36','',''),(2234391,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:00:36','',''),(2234432,'1','142','798',342,'Retail Sale Id 1312674',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 15:03:03','',''),(2234433,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:03:03','',''),(2234462,'1','142','798',342,'Retail Sale Id 1312689',2808.00,0.00,0.00,0.00,2808.00,'2021-12-10 15:05:12','',''),(2234463,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-10 15:05:12','',''),(2234484,'1','142','798',342,'Retail Sale Id 1312702',1872.00,0.00,0.00,0.00,1872.00,'2021-12-10 15:06:22','',''),(2234485,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 15:06:22','',''),(2234514,'1','142','798',342,'Retail Sale Id 1312712',1497.60,0.00,0.00,0.00,1497.60,'2021-12-10 15:07:19','',''),(2234515,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-10 15:07:19','',''),(2234556,'1','142','798',342,'Retail Sale Id 1312731',3999.84,0.00,0.00,0.00,3999.84,'2021-12-10 15:09:34','',''),(2234557,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-10 15:09:34','',''),(2234655,'1','142','798',342,'Retail Sale Id 1312777',3120.00,0.00,0.00,0.00,3120.00,'2021-12-10 15:13:30','',''),(2234656,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 15:13:30','',''),(2234677,'1','142','798',342,'Retail Sale Id 1312787',698.88,0.00,0.00,0.00,698.88,'2021-12-10 15:14:21','',''),(2234678,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.12,0.00,'2021-12-10 15:14:21','',''),(2234713,'1','142','798',342,'Retail Sale Id 1312806',11544.00,0.00,0.00,0.00,11544.00,'2021-12-10 15:16:00','',''),(2234714,'1','142','798',342,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-10 15:16:00','',''),(2234733,'1','142','798',342,'Retail Sale Id 1312818',3744.00,0.00,0.00,0.00,3744.00,'2021-12-10 15:16:50','',''),(2234734,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:16:50','',''),(2234753,'1','142','798',342,'Retail Sale Id 1312830',998.40,0.00,0.00,0.00,998.40,'2021-12-10 15:17:49','',''),(2234754,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 15:17:49','',''),(2234789,'1','142','798',342,'Retail Sale Id 1312850',2003.04,0.00,0.00,0.00,2003.04,'2021-12-10 15:19:15','',''),(2234790,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 15:19:15','',''),(2234813,'1','142','798',342,'Retail Sale Id 1312861',3120.00,0.00,0.00,0.00,3120.00,'2021-12-10 15:20:22','',''),(2234814,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 15:20:22','',''),(2234839,'1','142','798',342,'Retail Sale Id 1312870',998.40,0.00,0.00,0.00,998.40,'2021-12-10 15:21:23','',''),(2234840,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 15:21:23','',''),(2234868,'1','142','798',342,'Retail Sale Id 1312890',2003.04,0.00,0.00,0.00,2003.04,'2021-12-10 15:22:13','',''),(2234869,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 15:22:13','',''),(2234890,'1','142','798',342,'Retail Sale Id 1312904',2003.04,0.00,0.00,0.00,2003.04,'2021-12-10 15:22:59','',''),(2234891,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 15:22:59','',''),(2234928,'1','142','798',342,'Retail Sale Id 1312929',2003.04,0.00,0.00,0.00,2003.04,'2021-12-10 15:24:30','',''),(2234929,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 15:24:30','',''),(2234966,'1','142','798',342,'Retail Sale Id 1312946',3120.00,0.00,0.00,0.00,3120.00,'2021-12-10 15:25:33','',''),(2234967,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 15:25:33','',''),(2234986,'1','142','798',342,'Retail Sale Id 1312955',1248.00,0.00,0.00,0.00,1248.00,'2021-12-10 15:26:36','',''),(2234987,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 15:26:36','',''),(2235397,'1','142','798',342,'Retail Sale Id 1313130',3744.00,0.00,0.00,0.00,3744.00,'2021-12-10 15:42:31','',''),(2235398,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:42:31','',''),(2235409,'1','142','798',342,'Retail Sale Id 1313138',3001.44,0.00,0.00,0.00,3001.44,'2021-12-10 15:43:09','',''),(2235410,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-10 15:43:09','',''),(2235429,'1','142','798',342,'Retail Sale Id 1313150',6002.88,0.00,0.00,0.00,6002.88,'2021-12-10 15:43:55','',''),(2235430,'1','142','798',342,'Retail sales',0.00,0.00,0.00,9.62,0.00,'2021-12-10 15:43:55','',''),(2235449,'1','142','798',342,'Retail Sale Id 1313160',3001.44,0.00,0.00,0.00,3001.44,'2021-12-10 15:44:46','',''),(2235450,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-10 15:44:46','',''),(2235459,'1','142','798',342,'Retail Sale Id 1313168',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 15:45:28','',''),(2235460,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:45:28','',''),(2235552,'1','142','798',342,'Retail Sale Id 1313228',998.40,0.00,0.00,0.00,998.40,'2021-12-10 15:50:19','',''),(2235553,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 15:50:19','',''),(2235634,'1','142','798',342,'Retail Sale Id 1313270',1248.00,0.00,0.00,0.00,1248.00,'2021-12-10 15:54:34','',''),(2235635,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 15:54:34','',''),(2235678,'1','142','798',342,'Retail Sale Id 1313293',998.40,0.00,0.00,0.00,998.40,'2021-12-10 15:56:16','',''),(2235679,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 15:56:16','',''),(2235706,'1','142','798',342,'Retail Sale Id 1313305',3750.24,0.00,0.00,0.00,3750.24,'2021-12-10 15:57:41','',''),(2235707,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 15:57:41','',''),(2235731,'1','142','798',342,'Retail Sale Id 1313320',2003.04,0.00,0.00,0.00,2003.04,'2021-12-10 15:58:56','',''),(2235732,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 15:58:56','',''),(2235780,'1','142','798',342,'Retail Sale Id 1313345',3101.28,0.00,0.00,0.00,3101.28,'2021-12-10 16:00:29','',''),(2235781,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.97,0.00,'2021-12-10 16:00:29','',''),(2235802,'1','142','798',342,'Retail Sale Id 1313359',3744.00,0.00,0.00,0.00,3744.00,'2021-12-10 16:01:51','',''),(2235803,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 16:01:51','',''),(2235824,'1','142','798',342,'Retail Sale Id 1313368',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 16:03:09','',''),(2235825,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:03:09','',''),(2235837,'1','142','798',342,'Retail Sale Id 1313376',2003.04,0.00,0.00,0.00,2003.04,'2021-12-10 16:04:13','',''),(2235838,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 16:04:13','',''),(2235894,'1','142','798',342,'Retail Sale Id 1313391',3750.24,0.00,0.00,0.00,3750.24,'2021-12-10 16:06:02','',''),(2235895,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 16:06:02','',''),(2235920,'1','142','798',342,'Retail Sale Id 1313399',6240.00,0.00,0.00,0.00,6240.00,'2021-12-10 16:07:17','',''),(2235921,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 16:07:17','',''),(2235948,'1','142','798',342,'Retail Sale Id 1313415',2003.04,0.00,0.00,0.00,2003.04,'2021-12-10 16:08:35','',''),(2235949,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 16:08:35','',''),(2235970,'1','142','798',342,'Retail Sale Id 1313425',3001.44,0.00,0.00,0.00,3001.44,'2021-12-10 16:09:35','',''),(2235971,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-10 16:09:35','',''),(2236005,'1','142','798',342,'Retail Sale Id 1313440',798.72,0.00,0.00,0.00,798.72,'2021-12-10 16:10:51','',''),(2236006,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.28,0.00,'2021-12-10 16:10:51','',''),(2236033,'1','142','798',342,'Retail Sale Id 1313455',5497.44,0.00,0.00,0.00,5497.44,'2021-12-10 16:12:16','',''),(2236034,'1','142','798',342,'Retail sales',0.00,0.00,0.00,8.81,0.00,'2021-12-10 16:12:16','',''),(2236063,'1','142','798',342,'Retail Sale Id 1313477',1872.00,0.00,0.00,0.00,1872.00,'2021-12-10 16:13:46','',''),(2236064,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:13:46','',''),(2236105,'1','142','798',342,'Retail Sale Id 1313500',998.40,0.00,0.00,0.00,998.40,'2021-12-10 16:15:45','',''),(2236106,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 16:15:45','',''),(2236136,'1','142','798',342,'Retail Sale Id 1313517',1872.00,0.00,0.00,0.00,1872.00,'2021-12-10 16:17:41','',''),(2236137,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:17:41','',''),(2236138,'1','142','798',342,'Retail Sale Id 1313517',1872.00,0.00,0.00,0.00,1872.00,'2021-12-10 16:17:41','',''),(2236139,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:17:41','',''),(2236172,'1','142','798',342,'Retail Sale Id 1313536',1497.60,0.00,0.00,0.00,1497.60,'2021-12-10 16:18:56','',''),(2236173,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-10 16:18:56','',''),(2236205,'1','142','798',342,'Retail Sale Id 1313558',3120.00,0.00,0.00,0.00,3120.00,'2021-12-10 16:20:21','',''),(2236206,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 16:20:21','',''),(2236258,'1','142','798',342,'Retail Sale Id 1313588',2003.04,0.00,0.00,0.00,2003.04,'2021-12-10 16:22:26','',''),(2236259,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 16:22:26','',''),(2236302,'1','142','798',342,'Retail Sale Id 1313609',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 16:24:13','',''),(2236303,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:24:13','',''),(2236439,'1','142','799',342,'Retail Sale Id 1313674',3750.24,0.00,0.00,0.00,3750.24,'2021-12-10 16:30:33','',''),(2236440,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 16:30:33','',''),(2236618,'1','142','798',342,'Retail Sale Id 1313752',4499.04,0.00,0.00,0.00,4499.04,'2021-12-10 16:39:08','',''),(2236619,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.21,0.00,'2021-12-10 16:39:08','',''),(2236666,'1','142','798',342,'Retail Sale Id 1313767',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 16:41:11','',''),(2236667,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:41:11','',''),(2236728,'1','142','798',342,'Retail Sale Id 1313802',1248.00,0.00,0.00,0.00,1248.00,'2021-12-10 16:45:00','',''),(2236729,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 16:45:00','',''),(2236750,'1','142','798',342,'Retail Sale Id 1313814',1248.00,0.00,0.00,0.00,1248.00,'2021-12-10 16:46:15','',''),(2236751,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 16:46:15','',''),(2236808,'1','142','798',342,'Retail Sale Id 1313844',7500.48,0.00,0.00,0.00,7500.48,'2021-12-10 16:49:54','',''),(2236809,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.02,0.00,'2021-12-10 16:49:54','',''),(2236842,'1','142','798',342,'Retail Sale Id 1313861',998.40,0.00,0.00,0.00,998.40,'2021-12-10 16:51:57','',''),(2236843,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 16:51:57','',''),(2236886,'1','142','798',342,'Retail Sale Id 1313876',1198.08,0.00,0.00,0.00,1198.08,'2021-12-10 16:53:52','',''),(2236887,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.92,0.00,'2021-12-10 16:53:52','',''),(2236896,'1','142','798',342,'Retail Sale Id 1313882',4998.24,0.00,0.00,0.00,4998.24,'2021-12-10 16:54:39','',''),(2236897,'1','142','798',342,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-10 16:54:39','',''),(2236907,'1','142','798',342,'Retail Sale Id 1313889',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 16:55:18','',''),(2236908,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:55:18','',''),(2236917,'1','142','798',342,'Retail Sale Id 1313896',2003.04,0.00,0.00,0.00,2003.04,'2021-12-10 16:56:20','',''),(2236918,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 16:56:20','',''),(2236933,'1','142','798',342,'Retail Sale Id 1313903',3750.24,0.00,0.00,0.00,3750.24,'2021-12-10 16:57:29','',''),(2236934,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 16:57:29','',''),(2237112,'1','142','798',342,'Retail Sale Id 1313994',165000.00,0.00,0.00,0.00,165000.00,'2021-12-10 17:09:12','',''),(2237113,'1','142','798',342,'Retail sales',0.00,0.00,0.00,275.00,0.00,'2021-12-10 17:09:12','',''),(2237138,'1','142','798',342,'Retail Sale Id 1314008',998.40,0.00,0.00,0.00,998.40,'2021-12-10 17:12:02','',''),(2237139,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 17:12:02','',''),(2237140,'1','142','798',342,'Retail Sale Id 1314008',1497.60,0.00,0.00,0.00,1497.60,'2021-12-10 17:12:02','',''),(2237141,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-10 17:12:02','',''),(2237142,'1','142','798',342,'Retail Sale Id 1314008',3001.44,0.00,0.00,0.00,3001.44,'2021-12-10 17:12:02','',''),(2237143,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-10 17:12:02','',''),(2237144,'1','142','798',342,'Retail Sale Id 1314008',3750.24,0.00,0.00,0.00,3750.24,'2021-12-10 17:12:02','',''),(2237145,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 17:12:02','',''),(2237252,'1','142','798',342,'Retail Sale Id 1314065',7800.00,0.00,0.00,0.00,7800.00,'2021-12-10 17:21:46','',''),(2237253,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 17:21:46','',''),(2237558,'1','142','798',342,'Retail Sale Id 1314215',4742.40,0.00,0.00,0.00,4742.40,'2021-12-10 17:51:27','',''),(2237559,'1','142','798',342,'Retail sales',0.00,0.00,0.00,7.60,0.00,'2021-12-10 17:51:27','',''),(2237748,'1','142','798',342,'Retail Sale Id 1314311',1060.80,0.00,0.00,0.00,1060.80,'2021-12-10 18:31:36','',''),(2237749,'1','142','798',342,'Retail sales',0.00,0.00,0.00,1.70,0.00,'2021-12-10 18:31:36','',''),(2240549,'1','142','798',342,'Retail Sale Id 1315449',3744.00,0.00,0.00,0.00,3744.00,'2021-12-11 08:06:30','',''),(2240550,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 08:06:30','',''),(2240820,'1','142','798',342,'Retail Sale Id 1315580',2502.24,0.00,0.00,0.00,2502.24,'2021-12-11 08:18:36','',''),(2240821,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-11 08:18:36','',''),(2240876,'1','142','798',342,'Retail Sale Id 1315614',1872.00,0.00,0.00,0.00,1872.00,'2021-12-11 08:21:48','',''),(2240877,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 08:21:48','',''),(2241152,'1','142','798',342,'Retail Sale Id 1315746',3744.00,0.00,0.00,0.00,3744.00,'2021-12-11 08:36:10','',''),(2241153,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 08:36:10','',''),(2241172,'1','142','798',342,'Retail Sale Id 1315755',3744.00,0.00,0.00,0.00,3744.00,'2021-12-11 08:37:04','',''),(2241173,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 08:37:04','',''),(2241233,'1','142','798',342,'Retail Sale Id 1315779',2502.24,0.00,0.00,0.00,2502.24,'2021-12-11 08:40:06','',''),(2241234,'1','142','798',342,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-11 08:40:06','',''),(2241274,'1','142','798',342,'Retail Sale Id 1315791',3201.12,0.00,0.00,0.00,3201.12,'2021-12-11 08:42:15','',''),(2241275,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.13,0.00,'2021-12-11 08:42:15','',''),(2241319,'1','142','798',342,'Retail Sale Id 1315814',3120.00,0.00,0.00,0.00,3120.00,'2021-12-11 08:44:00','',''),(2241320,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 08:44:00','',''),(2241354,'1','142','798',342,'Retail Sale Id 1315831',3750.24,0.00,0.00,0.00,3750.24,'2021-12-11 08:45:32','',''),(2241355,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 08:45:32','',''),(2241398,'1','142','798',342,'Retail Sale Id 1315853',7800.00,0.00,0.00,0.00,7800.00,'2021-12-11 08:47:49','',''),(2241399,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 08:47:49','',''),(2241443,'1','142','798',342,'Retail Sale Id 1315866',3750.24,0.00,0.00,0.00,3750.24,'2021-12-11 08:49:46','',''),(2241444,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 08:49:46','',''),(2241620,'1','142','798',342,'Retail Sale Id 1315941',3750.24,0.00,0.00,0.00,3750.24,'2021-12-11 08:57:22','',''),(2241621,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 08:57:22','',''),(2241676,'1','142','798',342,'Retail Sale Id 1315965',7800.00,0.00,0.00,0.00,7800.00,'2021-12-11 08:59:36','',''),(2241677,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 08:59:36','',''),(2241836,'1','142','798',342,'Retail Sale Id 1316049',2202.72,0.00,0.00,0.00,2202.72,'2021-12-11 09:06:28','',''),(2241837,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.53,0.00,'2021-12-11 09:06:28','',''),(2241914,'1','142','798',342,'Retail Sale Id 1316086',6240.00,0.00,0.00,0.00,6240.00,'2021-12-11 09:09:55','',''),(2241915,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 09:09:55','',''),(2242022,'1','142','798',342,'Retail Sale Id 1316141',3744.00,0.00,0.00,0.00,3744.00,'2021-12-11 09:14:21','',''),(2242023,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 09:14:21','',''),(2242096,'1','142','798',342,'Retail Sale Id 1316182',3744.00,0.00,0.00,0.00,3744.00,'2021-12-11 09:17:48','',''),(2242097,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 09:17:48','',''),(2242162,'1','142','798',342,'Retail Sale Id 1316205',7800.00,0.00,0.00,0.00,7800.00,'2021-12-11 09:20:50','',''),(2242163,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:20:50','',''),(2242191,'1','142','798',342,'Retail Sale Id 1316219',3744.00,0.00,0.00,0.00,3744.00,'2021-12-11 09:22:08','',''),(2242192,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 09:22:08','',''),(2242243,'1','142','798',342,'Retail Sale Id 1316241',1872.00,0.00,0.00,0.00,1872.00,'2021-12-11 09:24:33','',''),(2242244,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 09:24:33','',''),(2242289,'1','142','798',342,'Retail Sale Id 1316265',3744.00,0.00,0.00,0.00,3744.00,'2021-12-11 09:27:55','',''),(2242290,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 09:27:55','',''),(2242315,'1','142','798',342,'Retail Sale Id 1316277',1872.00,0.00,0.00,0.00,1872.00,'2021-12-11 09:29:27','',''),(2242316,'1','142','798',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 09:29:27','',''),(2242370,'1','142','798',342,'Retail Sale Id 1316308',1248.00,0.00,0.00,0.00,1248.00,'2021-12-11 09:32:19','',''),(2242371,'1','142','798',342,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 09:32:19','',''),(2242474,'1','142','798',342,'Retail Sale Id 1316363',3744.00,0.00,0.00,0.00,3744.00,'2021-12-11 09:37:13','',''),(2242475,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 09:37:13','',''),(2242582,'1','142','798',342,'Retail Sale Id 1316420',7800.00,0.00,0.00,0.00,7800.00,'2021-12-11 09:41:46','',''),(2242583,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:41:46','',''),(2242682,'1','142','798',342,'Retail Sale Id 1316465',3744.00,0.00,0.00,0.00,3744.00,'2021-12-11 09:46:03','',''),(2242683,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 09:46:03','',''),(2242722,'1','142','798',342,'Retail Sale Id 1316486',3120.00,0.00,0.00,0.00,3120.00,'2021-12-11 09:48:20','',''),(2242723,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 09:48:20','',''),(2242764,'1','142','798',342,'Retail Sale Id 1316509',6240.00,0.00,0.00,0.00,6240.00,'2021-12-11 09:50:07','',''),(2242765,'1','142','798',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 09:50:07','',''),(2242926,'1','142','798',342,'Return of Retail Sale Id 1316486',0.00,3120.00,5.00,0.00,-3120.00,'2021-12-11 09:58:50','',''),(2243033,'1','142','798',342,'Retail Sale Id 1316637',3744.00,0.00,0.00,0.00,3744.00,'2021-12-11 10:04:26','',''),(2243034,'1','142','798',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 10:04:26','',''),(2244924,'1','142','798',342,'Return of Retail Sale Id 1316509',0.00,6240.00,10.00,0.00,-6240.00,'2021-12-11 11:40:26','',''),(2245188,'1','142','798',342,'Retail Sale Id 1317666',20592.00,0.00,0.00,0.00,20592.00,'2021-12-11 11:56:18','',''),(2245189,'1','142','798',342,'Retail sales',0.00,0.00,0.00,33.00,0.00,'2021-12-11 11:56:18','',''),(2245217,'1','142','798',342,'Retail Sale Id 1317679',12600.00,0.00,0.00,0.00,12600.00,'2021-12-11 11:58:07','',''),(2245218,'1','142','798',342,'Retail sales',0.00,0.00,0.00,21.00,0.00,'2021-12-11 11:58:07','',''),(2246710,'1','142',NULL,342,'Purchased from AA RANO NIGERIA LIMITED',0.00,14823680.00,25040.00,0.00,0.00,'2021-12-11 13:35:17','',''),(2246892,'1','142',NULL,342,'Reception corrector for bridging 127019',0.00,0.00,0.00,18040.00,0.00,'2021-12-11 13:49:51','',''),(2246893,'1','142','799',342,'Received from bridging 127019',0.00,0.00,18040.00,0.00,0.00,'2021-12-11 13:49:51','',''),(2246962,'1','142','799',342,'Retail Sale Id 1318563',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 13:53:59','',''),(2246963,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 13:53:59','',''),(2246964,'1','142','799',342,'Retail Sale Id 1318563',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 13:53:59','',''),(2246965,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 13:53:59','',''),(2246994,'1','142','799',342,'Retail Sale Id 1318588',1297.92,0.00,0.00,0.00,66.56,'2021-12-11 13:55:39','',''),(2246995,'1','142','799',342,'Retail sales',0.00,0.00,0.00,2.08,0.00,'2021-12-11 13:55:39','',''),(2247010,'1','142','799',342,'Retail Sale Id 1318596',998.40,0.00,0.00,0.00,51.20,'2021-12-11 13:56:41','',''),(2247011,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 13:56:41','',''),(2247042,'1','142','799',342,'Retail Sale Id 1318612',370800.00,0.00,0.00,0.00,4944.00,'2021-12-11 13:58:26','',''),(2247043,'1','142','799',342,'Retail sales',0.00,0.00,0.00,618.00,0.00,'2021-12-11 13:58:26','',''),(2247061,'1','142','799',342,'Retail Sale Id 1318622',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 13:59:49','',''),(2247062,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 13:59:49','',''),(2247097,'1','142','799',342,'Retail Sale Id 1318643',3999.84,0.00,0.00,0.00,205.12,'2021-12-11 14:01:56','',''),(2247098,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-11 14:01:56','',''),(2247113,'1','142','799',342,'Retail Sale Id 1318652',1497.60,0.00,0.00,0.00,76.80,'2021-12-11 14:03:30','',''),(2247114,'1','142','799',342,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-11 14:03:30','',''),(2247182,'1','142','799',342,'Retail Sale Id 1318684',1797.12,0.00,0.00,0.00,92.16,'2021-12-11 14:08:10','',''),(2247183,'1','142','799',342,'Retail sales',0.00,0.00,0.00,2.88,0.00,'2021-12-11 14:08:10','',''),(2247242,'1','142','799',342,'Retail Sale Id 1318701',998.40,0.00,0.00,0.00,51.20,'2021-12-11 14:10:21','',''),(2247243,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 14:10:21','',''),(2247274,'1','142','799',342,'Retail Sale Id 1318725',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 14:12:10','',''),(2247275,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:12:10','',''),(2247462,'1','142','799',342,'Retail Sale Id 1318816',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 14:24:37','',''),(2247463,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 14:24:37','',''),(2247506,'1','142','799',342,'Retail Sale Id 1318830',2003.04,0.00,0.00,0.00,102.72,'2021-12-11 14:26:55','',''),(2247507,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-11 14:26:55','',''),(2247680,'1','142','799',342,'Retail Sale Id 1318943',3999.84,0.00,0.00,0.00,205.12,'2021-12-11 14:39:07','',''),(2247681,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-11 14:39:07','',''),(2247718,'1','142','799',342,'Retail Sale Id 1318962',998.40,0.00,0.00,0.00,51.20,'2021-12-11 14:41:33','',''),(2247719,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 14:41:33','',''),(2247774,'1','142','799',342,'Retail Sale Id 1318990',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 14:45:14','',''),(2247775,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 14:45:14','',''),(2247850,'1','142','799',342,'Retail Sale Id 1319027',11200.80,0.00,0.00,0.00,574.40,'2021-12-11 14:49:21','',''),(2247851,'1','142','799',342,'Retail sales',0.00,0.00,0.00,17.95,0.00,'2021-12-11 14:49:21','',''),(2247898,'1','142','799',342,'Retail Sale Id 1319050',2502.24,0.00,0.00,0.00,128.32,'2021-12-11 14:52:30','',''),(2247899,'1','142','799',342,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-11 14:52:30','',''),(2247920,'1','142','799',342,'Retail Sale Id 1319065',2502.24,0.00,0.00,0.00,128.32,'2021-12-11 14:53:44','',''),(2247921,'1','142','799',342,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-11 14:53:44','',''),(2247962,'1','142','799',342,'Retail Sale Id 1319085',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 14:55:55','',''),(2247963,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:55:55','',''),(2248087,'1','142','799',342,'Retail Sale Id 1319151',4992.00,0.00,0.00,0.00,256.00,'2021-12-11 15:04:01','',''),(2248088,'1','142','799',342,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-11 15:04:01','',''),(2248103,'1','142','799',342,'Retail Sale Id 1319158',3120.00,0.00,0.00,0.00,160.00,'2021-12-11 15:04:41','',''),(2248104,'1','142','799',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 15:04:41','',''),(2248117,'1','142','799',342,'Retail Sale Id 1319166',3001.44,0.00,0.00,0.00,153.92,'2021-12-11 15:05:47','',''),(2248118,'1','142','799',342,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-11 15:05:47','',''),(2248336,'1','142','799',342,'Retail Sale Id 1319237',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 15:13:41','',''),(2248337,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 15:13:41','',''),(2248432,'1','142','799',342,'Retail Sale Id 1319287',7488.00,0.00,0.00,0.00,384.00,'2021-12-11 15:18:21','',''),(2248433,'1','142','799',342,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-11 15:18:21','',''),(2248552,'1','142','799',342,'Retail Sale Id 1319354',3999.84,0.00,0.00,0.00,205.12,'2021-12-11 15:25:23','',''),(2248553,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-11 15:25:23','',''),(2248598,'1','142','799',342,'Retail Sale Id 1319381',2003.04,0.00,0.00,0.00,102.72,'2021-12-11 15:27:58','',''),(2248599,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-11 15:27:58','',''),(2248636,'1','142','799',342,'Retail Sale Id 1319402',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 15:30:09','',''),(2248637,'1','142','799',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 15:30:09','',''),(2248674,'1','142','799',342,'Retail Sale Id 1319424',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 15:32:27','',''),(2248675,'1','142','799',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 15:32:27','',''),(2248745,'1','142','799',342,'Retail Sale Id 1319463',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 15:36:08','',''),(2248746,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 15:36:08','',''),(2248812,'1','142','799',342,'Retail Sale Id 1319498',3001.44,0.00,0.00,0.00,153.92,'2021-12-11 15:39:23','',''),(2248813,'1','142','799',342,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-11 15:39:23','',''),(2248834,'1','142','799',342,'Retail Sale Id 1319510',1497.60,0.00,0.00,0.00,76.80,'2021-12-11 15:41:00','',''),(2248835,'1','142','799',342,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-11 15:41:00','',''),(2248886,'1','142','799',342,'Retail Sale Id 1319542',1497.60,0.00,0.00,0.00,76.80,'2021-12-11 15:44:06','',''),(2248887,'1','142','799',342,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-11 15:44:06','',''),(2248981,'1','142','799',342,'Retail Sale Id 1319575',2003.04,0.00,0.00,0.00,102.72,'2021-12-11 15:47:30','',''),(2248982,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-11 15:47:30','',''),(2249019,'1','142','799',342,'Retail Sale Id 1319599',360000.00,0.00,0.00,0.00,4800.00,'2021-12-11 15:49:39','',''),(2249020,'1','142','799',342,'Retail sales',0.00,0.00,0.00,600.00,0.00,'2021-12-11 15:49:39','',''),(2249090,'1','142','799',342,'Retail Sale Id 1319636',390000.00,0.00,0.00,0.00,5200.00,'2021-12-11 15:52:48','',''),(2249091,'1','142','799',342,'Retail sales',0.00,0.00,0.00,650.00,0.00,'2021-12-11 15:52:48','',''),(2249141,'1','142','799',342,'Retail Sale Id 1319653',180000.00,0.00,0.00,0.00,2400.00,'2021-12-11 15:54:19','',''),(2249142,'1','142','799',342,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-11 15:54:19','',''),(2249193,'1','142','799',342,'Retail Sale Id 1319668',3999.84,0.00,0.00,0.00,205.12,'2021-12-11 15:55:44','',''),(2249194,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-11 15:55:44','',''),(2249216,'1','142','799',342,'Retail Sale Id 1319682',6240.00,0.00,0.00,0.00,320.00,'2021-12-11 15:56:46','',''),(2249217,'1','142','799',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 15:56:46','',''),(2249377,'1','142','798',342,'Retail Sale Id 1319746',3120.00,0.00,0.00,0.00,160.00,'2021-12-11 16:02:56','',''),(2249378,'1','142','798',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 16:02:56','',''),(2249415,'1','142','798',342,'Retail Sale Id 1319766',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 16:04:25','',''),(2249416,'1','142','798',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:04:25','',''),(2249458,'1','142','799',342,'Retail Sale Id 1319790',31200.00,0.00,0.00,0.00,1600.00,'2021-12-11 16:06:57','',''),(2249459,'1','142','799',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 16:06:57','',''),(2249478,'1','142','799',342,'Retail Sale Id 1319798',648.96,0.00,0.00,0.00,33.28,'2021-12-11 16:07:46','',''),(2249479,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.04,0.00,'2021-12-11 16:07:46','',''),(2249512,'1','142','799',342,'Retail Sale Id 1319813',3744.00,0.00,0.00,0.00,192.00,'2021-12-11 16:08:45','',''),(2249513,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:08:45','',''),(2249538,'1','142','799',342,'Retail Sale Id 1319828',3750.24,0.00,0.00,0.00,192.32,'2021-12-11 16:10:01','',''),(2249539,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 16:10:01','',''),(2249563,'1','142','799',342,'Retail Sale Id 1319839',3001.44,0.00,0.00,0.00,153.92,'2021-12-11 16:11:38','',''),(2249564,'1','142','799',342,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-11 16:11:38','',''),(2249613,'1','142','799',342,'Retail Sale Id 1319911',1497.60,0.00,0.00,0.00,76.80,'2021-12-11 16:14:46','',''),(2249614,'1','142','799',342,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-11 16:14:46','',''),(2249652,'1','142','799',342,'Retail Sale Id 1319931',3750.24,0.00,0.00,0.00,192.32,'2021-12-11 16:16:40','',''),(2249653,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 16:16:40','',''),(2249675,'1','142','799',342,'Retail Sale Id 1319939',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 16:17:49','',''),(2249676,'1','142','799',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:17:49','',''),(2249687,'1','142','799',342,'Retail Sale Id 1319949',297000.00,0.00,0.00,0.00,3960.00,'2021-12-11 16:19:07','',''),(2249688,'1','142','799',342,'Retail sales',0.00,0.00,0.00,495.00,0.00,'2021-12-11 16:19:07','',''),(2249705,'1','142','799',342,'Retail Sale Id 1319958',3750.24,0.00,0.00,0.00,192.32,'2021-12-11 16:20:03','',''),(2249706,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 16:20:03','',''),(2249741,'1','142','799',342,'Retail Sale Id 1319976',998.40,0.00,0.00,0.00,51.20,'2021-12-11 16:22:15','',''),(2249742,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 16:22:15','',''),(2249774,'1','142','799',342,'Retail Sale Id 1319989',3750.24,0.00,0.00,0.00,192.32,'2021-12-11 16:23:38','',''),(2249775,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 16:23:38','',''),(2249782,'1','142','799',342,'Retail Sale Id 1319993',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 16:24:37','',''),(2249783,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:24:37','',''),(2249800,'1','142','799',342,'Retail Sale Id 1320004',3120.00,0.00,0.00,0.00,160.00,'2021-12-11 16:25:42','',''),(2249801,'1','142','799',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 16:25:42','',''),(2249825,'1','142','799',342,'Retail Sale Id 1320015',998.40,0.00,0.00,0.00,51.20,'2021-12-11 16:27:20','',''),(2249826,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 16:27:20','',''),(2249955,'1','142','799',342,'Retail Sale Id 1320062',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 16:33:26','',''),(2249956,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:33:26','',''),(2250012,'1','142','799',342,'Retail Sale Id 1320090',3750.24,0.00,0.00,0.00,192.32,'2021-12-11 16:36:06','',''),(2250013,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 16:36:06','',''),(2250390,'1','142','799',342,'Retail Sale Id 1320235',1198.08,0.00,0.00,0.00,61.44,'2021-12-11 16:56:41','',''),(2250391,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.92,0.00,'2021-12-11 16:56:41','',''),(2250416,'1','142','799',342,'Retail Sale Id 1320252',1872.00,0.00,0.00,0.00,96.00,'2021-12-11 16:58:10','',''),(2250417,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:58:10','',''),(2250520,'1','142','799',342,'Retail Sale Id 1320291',3999.84,0.00,0.00,0.00,205.12,'2021-12-11 17:03:44','',''),(2250521,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-11 17:03:44','',''),(2250548,'1','142','799',342,'Retail Sale Id 1320315',690000.00,0.00,0.00,0.00,9200.00,'2021-12-11 17:05:20','',''),(2250549,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1150.00,0.00,'2021-12-11 17:05:20','',''),(2250564,'1','142','799',342,'Retail Sale Id 1320322',1497.60,0.00,0.00,0.00,76.80,'2021-12-11 17:06:25','',''),(2250565,'1','142','799',342,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-11 17:06:25','',''),(2250570,'1','142','799',342,'Retail Sale Id 1320325',3120.00,0.00,0.00,0.00,160.00,'2021-12-11 17:07:10','',''),(2250571,'1','142','799',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 17:07:10','',''),(2250584,'1','142','799',342,'Retail Sale Id 1320332',1878.24,0.00,0.00,0.00,96.32,'2021-12-11 17:08:22','',''),(2250585,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 17:08:22','',''),(2250604,'1','142','799',342,'Retail Sale Id 1320342',4998.24,0.00,0.00,0.00,256.32,'2021-12-11 17:09:49','',''),(2250605,'1','142','799',342,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-11 17:09:49','',''),(2250688,'1','142','799',342,'Retail Sale Id 1320390',6240.00,0.00,0.00,0.00,320.00,'2021-12-11 17:19:10','',''),(2250689,'1','142','799',342,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 17:19:10','',''),(2250770,'1','142','799',342,'Retail Sale Id 1320430',3120.00,0.00,0.00,0.00,160.00,'2021-12-11 17:26:04','',''),(2250771,'1','142','799',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 17:26:04','',''),(2250874,'1','142','799',342,'Retail Sale Id 1320484',30000.00,0.00,0.00,0.00,400.00,'2021-12-11 17:33:24','',''),(2250875,'1','142','799',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 17:33:24','',''),(2250890,'1','142','799',342,'Retail Sale Id 1320492',30000.00,0.00,0.00,0.00,400.00,'2021-12-11 17:35:08','',''),(2250891,'1','142','799',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 17:35:08','',''),(2250919,'1','142','799',342,'Retail Sale Id 1320501',30000.00,0.00,0.00,0.00,400.00,'2021-12-11 17:37:46','',''),(2250920,'1','142','799',342,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 17:37:46','',''),(2251010,'1','142','799',342,'Retail Sale Id 1320538',90000.00,0.00,0.00,0.00,1200.00,'2021-12-11 17:44:15','',''),(2251011,'1','142','799',342,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-11 17:44:15','',''),(2251413,'1','142','799',342,'Retail Sale Id 1320698',133036.80,0.00,0.00,0.00,6822.40,'2021-12-11 18:31:38','',''),(2251414,'1','142','799',342,'Retail sales',0.00,0.00,0.00,213.20,0.00,'2021-12-11 18:31:38','',''),(2251429,'1','142','798',342,'Return of Retail Sale Id 1319766',0.00,7800.00,12.50,0.00,-400.00,'2021-12-11 18:34:22','',''),(2251438,'1','142','798',342,'Return of Retail Sale Id 1319746',0.00,3120.00,5.00,0.00,-160.00,'2021-12-11 18:36:04','',''),(2251447,'1','142','799',342,'Retail Sale Id 1320721',3120.00,0.00,0.00,0.00,160.00,'2021-12-11 18:37:52','',''),(2251448,'1','142','799',342,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 18:37:52','',''),(2251449,'1','142','799',342,'Retail Sale Id 1320721',7800.00,0.00,0.00,0.00,400.00,'2021-12-11 18:37:52','',''),(2251450,'1','142','799',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 18:37:52','',''),(2253172,'1','142','799',342,'Retail Sale Id 1321325',798.72,0.00,0.00,0.00,40.96,'2021-12-12 07:31:24','',''),(2253173,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.28,0.00,'2021-12-12 07:31:24','',''),(2253206,'1','142','799',342,'Retail Sale Id 1321347',3500.64,0.00,0.00,0.00,179.52,'2021-12-12 07:34:11','',''),(2253207,'1','142','799',342,'Retail sales',0.00,0.00,0.00,5.61,0.00,'2021-12-12 07:34:11','',''),(2253434,'1','142','799',342,'Retail Sale Id 1321482',1497.60,0.00,0.00,0.00,76.80,'2021-12-12 07:49:29','',''),(2253435,'1','142','799',342,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-12 07:49:29','',''),(2253529,'1','142','799',342,'Retail Sale Id 1321536',1297.92,0.00,0.00,0.00,66.56,'2021-12-12 07:56:54','',''),(2253530,'1','142','799',342,'Retail sales',0.00,0.00,0.00,2.08,0.00,'2021-12-12 07:56:54','',''),(2253577,'1','142','799',342,'Retail Sale Id 1321551',3744.00,0.00,0.00,0.00,192.00,'2021-12-12 07:58:44','',''),(2253578,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 07:58:44','',''),(2253744,'1','142','799',342,'Retail Sale Id 1321632',1872.00,0.00,0.00,0.00,96.00,'2021-12-12 08:09:20','',''),(2253745,'1','142','799',342,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 08:09:20','',''),(2253975,'1','142','799',342,'Retail Sale Id 1321748',1497.60,0.00,0.00,0.00,76.80,'2021-12-12 08:24:38','',''),(2253976,'1','142','799',342,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-12 08:24:38','',''),(2254454,'1','142','799',342,'Retail Sale Id 1321981',998.40,0.00,0.00,0.00,51.20,'2021-12-12 08:53:26','',''),(2254455,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-12 08:53:26','',''),(2254550,'1','142','799',342,'Retail Sale Id 1322028',998.40,0.00,0.00,0.00,51.20,'2021-12-12 08:59:16','',''),(2254551,'1','142','799',342,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-12 08:59:16','',''),(2254602,'1','142','799',342,'Retail Sale Id 1322054',7800.00,0.00,0.00,0.00,400.00,'2021-12-12 09:02:15','',''),(2254603,'1','142','799',342,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:02:15','',''),(2254671,'1','142','799',342,'Retail Sale Id 1322091',3750.24,0.00,0.00,0.00,192.32,'2021-12-12 09:06:06','',''),(2254672,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 09:06:06','',''),(2254733,'1','142','799',342,'Retail Sale Id 1322125',3744.00,0.00,0.00,0.00,192.00,'2021-12-12 09:09:38','',''),(2254734,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 09:09:38','',''),(2254827,'1','142','799',342,'Retail Sale Id 1322166',3001.44,0.00,0.00,0.00,153.92,'2021-12-12 09:13:51','',''),(2254828,'1','142','799',342,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-12 09:13:51','',''),(2254867,'1','142','799',342,'Retail Sale Id 1322194',3744.00,0.00,0.00,0.00,192.00,'2021-12-12 09:16:29','',''),(2254868,'1','142','799',342,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 09:16:29','',''),(2254903,'1','142','799',342,'Retail Sale Id 1322211',1497.60,0.00,0.00,0.00,76.80,'2021-12-12 09:18:10','',''),(2254904,'1','142','799',342,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-12 09:18:10','',''),(2255006,'1','142','799',342,'Retail Sale Id 1322262',1297.92,0.00,0.00,0.00,66.56,'2021-12-12 09:24:22','',''),(2255007,'1','142','799',342,'Retail sales',0.00,0.00,0.00,2.08,0.00,'2021-12-1