-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_141
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_141`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_141` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_141`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3207 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2556,20012,'',0,'20','1','141','SALES','','2020-07-25 22:55:17',5,0.00,0.00,'','479','2020-07-25 22:55:17','479',0,1),(2557,40011,'',0,'6.1','1','141','CASH','','2020-07-25 22:55:38',5,0.00,0.00,'','479','2020-07-25 22:55:38','479',0,1),(2558,20004,'',0,'22','1','141','PURCHASES','','2020-07-25 22:56:39',5,0.00,0.00,'','479','2020-07-25 22:56:39','479',0,1),(2559,400080,'',0,'24','1','141','SALARIES & WAGES','','2020-07-25 22:57:09',5,0.00,0.00,'','479','2020-07-25 22:57:09','479',0,1),(2560,400209,'',0,'2','1','141','ZBN(POS):1015965368','','2020-07-25 22:58:00',5,0.00,0.00,'','479','2020-07-25 22:58:00','479',0,1),(2561,400210,'',0,'2','1','141','ZB(E-BILL)1015372548','','2020-07-25 23:00:21',5,0.00,0.00,'','479','2020-07-25 23:00:21','479',0,1),(2562,400081,'',0,'24','1','141','PURCHASES','','2020-07-25 23:02:32',5,0.00,0.00,'','479','2020-07-25 23:02:32','479',0,1),(2902,400319,'',0,'2','1','141','DANKANO-EBILLS(ZNB:1014717618)','','2020-10-29 13:35:36',5,0.00,0.00,'','489','2020-10-29 13:35:36','489',0,1),(3204,400483,'',0,'2','1','141','FID POS COLLECTION-5620141491','','2021-02-26 15:58:45',5,0.00,0.00,'','489','2021-02-26 15:58:45','489',0,1),(3205,400484,'',0,'2','1','141','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:45:33',5,0.00,0.00,'','792','2023-02-20 14:45:33','792',0,0),(3206,400485,'',0,'2','1','141','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:47:39',5,0.00,0.00,'2023-03-15','792','2023-03-17 14:05:10','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3541 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1579,'','1','141','END USER','0000','07032953864','hassyhusny@gmail.com','WARRI','DELTA','0000','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-07-27 15:22:03',5,'499','2020-07-27 15:22:03','499'),(1580,'','1','141','DEALER','0000','07032953864','hassyhusny@gmail.com','WARRI','DELTA','0000','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-07-27 15:23:45',5,'499','2022-11-19 12:08:10','499'),(1750,'','1','141','OPERATIONAL LOSS','HAFIZ NURA','08069129774','hafiz@aaranonigeria.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-10-29 13:34:59',5,'489','2020-10-29 13:34:59','489'),(3432,'','1','141','USAINI GAS','USAINI','08140430132','warri@gmail.com','WARRI','DELTA','WARRI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-10 16:27:19',5,'499','2021-10-10 16:27:19','499'),(3476,'','1','141','PEAKTON GLOBAL','PEAKTON GLOBAL','09019085329','warri@gmail.com','WARRI','DELTA','WARRI ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-16 13:33:00',5,'499','2021-10-16 13:33:00','499'),(3477,'','1','141','RHEMA ','RHEMA','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',2.00,0.00,0.00,'0000-00-00','2022-08-16 10:28:52',5,'499','2022-08-16 10:28:52','499'),(3478,'','1','141','BABA ABRAKA GAS','BABA ABRAKA','07032953864','hassyhusny@yahoo.com','ABRAKA','DELTA','ABRAKA','Nigeria',1500.00,0.00,0.00,'0000-00-00','2022-11-19 07:31:51',5,'499','2022-11-19 07:31:51','499'),(3479,'','1','141','O GAS','O GAS','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',700.00,0.00,0.00,'0000-00-00','2022-11-19 07:33:08',5,'499','2022-11-19 07:33:08','499'),(3480,'','1','141','EBUBE GAS','EBUBE GAS','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',800.00,0.00,0.00,'0000-00-00','2022-11-19 07:34:57',5,'499','2022-11-19 07:34:57','499'),(3481,'','1','141','VINCO GAS','VINCO','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',300.00,0.00,0.00,'0000-00-00','2022-11-19 07:37:12',5,'499','2022-11-19 07:37:12','499'),(3482,'','1','141','OCHUKO GAS','OCHUKO','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',250.00,0.00,0.00,'0000-00-00','2022-11-19 07:38:14',5,'499','2022-11-19 07:38:14','499'),(3483,'','1','141','JAY JAY GAS','J J','07032953864','hassyhusny@yahoo.com','SAPELE','DELTA','SAPELE','Nigeria',900.00,0.00,0.00,'0000-00-00','2022-11-19 07:39:38',5,'499','2022-11-19 07:39:38','499'),(3484,'','1','141','AYO GAS','AYO','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',300.00,0.00,0.00,'0000-00-00','2022-11-19 07:40:45',5,'499','2022-11-19 07:40:45','499'),(3485,'','1','141','ZAZZAU GAS','MANSUR','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','ADEJE','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-11-19 07:41:43',5,'499','2022-11-19 07:41:43','499'),(3486,'','1','141','REX GAS','REX','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',300.00,0.00,0.00,'0000-00-00','2022-11-19 07:42:49',5,'499','2022-11-19 07:42:49','499'),(3487,'','1','141','SILAS GAS','SILAS','07032953864','hassyhusny@yahoo.com','ABRAKA','DELTA','ABRAKA','Nigeria',750.00,0.00,0.00,'0000-00-00','2022-11-19 07:46:21',5,'499','2022-11-19 07:46:21','499'),(3488,'','1','141','EMILAX','EMILAX','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',540.00,0.00,0.00,'0000-00-00','2022-11-19 07:47:32',5,'499','2022-11-19 07:47:32','499'),(3489,'','1','141','GRACE TOP','GRACE','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI\r\n','Nigeria',1600.00,0.00,0.00,'0000-00-00','2022-11-19 07:48:41',5,'499','2022-11-19 07:48:41','499'),(3490,'','1','141','ABIFEM GAS ','FEMI','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',250.00,0.00,0.00,'0000-00-00','2022-11-19 07:49:38',5,'499','2022-11-19 07:49:38','499'),(3491,'','1','141','AUSTIN GAS ','AUSTN','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',400.00,0.00,0.00,'0000-00-00','2022-11-19 07:52:03',5,'499','2022-11-19 07:52:03','499'),(3492,'','1','141','AUTOSKI GAS','AUTOSKI','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',600.00,0.00,0.00,'0000-00-00','2022-11-19 07:54:54',5,'499','2022-11-19 07:54:54','499'),(3493,'','1','141','UFOSKI GAS','UFOMA','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',500.00,0.00,0.00,'0000-00-00','2022-11-19 07:57:58',5,'499','2022-11-19 07:57:58','499'),(3494,'','1','141','CHIEF GAS','CHIEF GAS','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',150.00,0.00,0.00,'0000-00-00','2022-11-19 08:00:10',5,'499','2022-11-19 08:00:10','499'),(3495,'','1','141','IDREES GAS','IDREES','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',250.00,0.00,0.00,'0000-00-00','2022-11-19 08:01:26',5,'499','2022-11-19 08:01:26','499'),(3496,'','1','141','LADY JAY GAS','LADY JAY ','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',300.00,0.00,0.00,'0000-00-00','2022-11-19 08:03:31',5,'499','2022-11-19 08:03:31','499'),(3497,'','1','141','CHIGOBEST GAS','CHIGO','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-11-19 08:05:28',5,'499','2022-11-19 08:05:28','499'),(3498,'','1','141','FRANK OCEAN GAS','FRANK','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',300.00,0.00,0.00,'0000-00-00','2022-11-19 08:07:14',5,'499','2022-11-19 08:07:14','499'),(3499,'','1','141','GACO GAS','PHILIP','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',1500.00,0.00,0.00,'0000-00-00','2022-11-19 08:08:54',5,'499','2022-11-19 08:08:54','499'),(3500,'','1','141','BISCO GAS','BISI','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',300.00,0.00,0.00,'0000-00-00','2022-11-19 08:10:08',5,'499','2022-11-19 08:10:08','499'),(3501,'','1','141','MIKI GAS','MIKI','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',250.00,0.00,0.00,'0000-00-00','2022-11-19 08:15:59',5,'499','2022-11-19 08:15:59','499'),(3502,'','1','141','MADAM  BEAUTY GAS','BEAUTY','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',300.00,0.00,0.00,'0000-00-00','2022-11-19 08:18:33',5,'499','2022-11-19 08:18:33','499'),(3503,'','1','141','OGA JUDE GAS','JUDE','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',400.00,0.00,0.00,'0000-00-00','2022-11-19 08:19:28',5,'499','2022-11-19 08:19:28','499'),(3504,'','1','141','D AGMITTED GAS','PASTOR','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',800.00,0.00,0.00,'0000-00-00','2022-11-19 08:20:58',5,'499','2022-11-19 08:20:58','499'),(3505,'','1','141','TIMEYIN GAS','TIMI','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',550.00,0.00,0.00,'0000-00-00','2022-11-19 08:21:46',5,'499','2022-11-19 08:21:46','499'),(3506,'','1','141','FAMOUS GAS','FAMOUS','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',1200.00,0.00,0.00,'0000-00-00','2022-11-19 08:24:46',5,'499','2022-11-19 08:24:46','499'),(3507,'','1','141','LEGIT GAS','BOYIS','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',300.00,0.00,0.00,'0000-00-00','2022-11-19 08:25:47',5,'499','2022-11-19 08:25:47','499'),(3508,'','1','141','GODS SON','EKEREKE','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',300.00,0.00,0.00,'0000-00-00','2022-11-19 08:29:17',5,'499','2022-11-19 08:29:17','499'),(3509,'','1','141','JAHBES GAS','JAH','07032953864','hassyhusny@yahoo.com','OGARA','DELTA','OGARA','Nigeria',800.00,0.00,0.00,'0000-00-00','2022-11-19 08:31:05',5,'499','2022-11-19 08:31:05','499'),(3510,'','1','141','CITY GAS','DAVID','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',950.00,0.00,0.00,'0000-00-00','2022-11-19 08:32:18',5,'499','2022-11-19 08:32:18','499'),(3511,'','1','141','FESTUS GAS','FESTUS','07032953864','hassyhusny@yahoo.com','OGARA','DELTA','OGARA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-11-19 08:33:15',5,'499','2022-11-19 08:33:15','499'),(3512,'','1','141','ACTION GAS','ACTION','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',350.00,0.00,0.00,'0000-00-00','2022-11-19 08:34:34',5,'499','2022-11-19 08:34:34','499'),(3513,'','1','141','PATRICIA GAS','MADAM PAT','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',1500.00,0.00,0.00,'0000-00-00','2022-11-19 08:36:13',5,'499','2022-11-19 08:36:13','499'),(3514,'','1','141','UDUAK GAS','MADAM UDUAK','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',650.00,0.00,0.00,'0000-00-00','2022-11-19 08:37:28',5,'499','2022-11-19 08:37:28','499'),(3515,'','1','141','FELIX GAS','OGA FELIX','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',300.00,0.00,0.00,'0000-00-00','2022-11-19 08:38:53',5,'499','2022-11-19 08:38:53','499'),(3516,'','1','141','GAS UNION CHIRMAN','UNION ','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI ','Nigeria',450.00,0.00,0.00,'0000-00-00','2022-11-19 08:42:29',5,'499','2022-11-19 08:42:29','499'),(3517,'','1','141','LAWANI GAS ','LAWAN','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',750.00,0.00,0.00,'0000-00-00','2022-11-19 08:47:44',5,'499','2022-11-19 08:47:44','499'),(3518,'','1','141','MICOS GAS','MIKE','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',500.00,0.00,0.00,'0000-00-00','2022-11-19 08:48:46',5,'499','2022-11-19 08:48:46','499'),(3519,'','1','141','KOFI GAS','KOFI','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',100.00,0.00,0.00,'0000-00-00','2022-11-19 08:50:59',5,'499','2022-11-19 08:50:59','499'),(3520,'','1','141','EMMA GREAT','EMMANUEL','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-11-19 08:51:55',5,'499','2022-11-19 08:51:55','499'),(3521,'','1','141','MUNACHI GAS','MUN','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI ','Nigeria',350.00,0.00,0.00,'0000-00-00','2022-11-19 09:00:01',5,'499','2022-11-19 09:00:01','499'),(3522,'','1','141','EMY GAS','EMEKA','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI ','Nigeria',270.00,0.00,0.00,'0000-00-00','2022-11-19 09:01:10',5,'499','2022-11-19 09:01:10','499'),(3523,'','1','141','HENNAK GAS','HENNAK','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',300.00,0.00,0.00,'0000-00-00','2022-11-19 09:02:53',5,'499','2022-11-19 09:02:53','499'),(3524,'','1','141','VICTOR GAS','VIKKI','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',250.00,0.00,0.00,'0000-00-00','2022-11-19 09:04:32',5,'499','2022-11-19 09:04:32','499'),(3525,'','1','141','PETEK GAS','PETER OKOYE','08033386518','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',600.00,0.00,0.00,'0000-00-00','2022-11-19 09:07:38',5,'499','2022-11-19 09:07:38','499'),(3526,'','1','141','MOSES RIVER','MOSES','07032953864','hassyhusny@yahoo.com','YANAGUA','DELTA','BAYELSA','Nigeria',480.00,0.00,0.00,'0000-00-00','2022-11-19 09:15:03',5,'499','2022-11-19 09:15:03','499'),(3527,'','1','141','ANDERSON','FREE','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',300.00,0.00,0.00,'0000-00-00','2022-11-19 09:16:45',5,'499','2022-11-19 09:16:45','499'),(3528,'','1','141','EDERSON GAS','EDER','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',370.00,0.00,0.00,'0000-00-00','2022-11-19 09:18:06',5,'499','2022-11-19 09:18:06','499'),(3529,'','1','141','UWACEL GAS','UWACEL','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',400.00,0.00,0.00,'0000-00-00','2022-11-19 09:20:14',5,'499','2022-11-19 09:20:14','499'),(3530,'','1','141','I K GAS','OGA I K','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI ','Nigeria',120.00,0.00,0.00,'0000-00-00','2022-11-19 09:21:27',5,'499','2022-11-19 09:21:27','499'),(3531,'','1','141','BAYO GAS','OGA BAYO','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',470.00,0.00,0.00,'0000-00-00','2022-11-19 09:22:49',5,'499','2022-11-19 09:22:49','499'),(3532,'','1','141','USMAN GAS','USMAN','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',300.00,0.00,0.00,'0000-00-00','2022-11-19 09:24:04',5,'499','2022-11-19 09:24:04','499'),(3533,'','1','141','FURTUNE GAS','SIR FURTUNE','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',150.00,0.00,0.00,'0000-00-00','2022-11-19 09:26:45',5,'499','2022-11-19 09:26:45','499'),(3534,'','1','141','GABRIEL GAS','OSE','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',350.00,0.00,0.00,'0000-00-00','2022-11-19 09:28:52',5,'499','2022-11-19 09:28:52','499'),(3535,'','1','141','BEMON GAS','LADY BEMON','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',600.00,0.00,0.00,'0000-00-00','2022-11-19 09:40:17',5,'499','2022-11-19 09:40:17','499'),(3536,'','1','141','JAY GAS','UBEJI','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',150.00,0.00,0.00,'0000-00-00','2022-11-19 09:42:02',5,'499','2022-11-19 09:42:02','499'),(3537,'','1','141','DELL GAS','DELE','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',220.00,0.00,0.00,'0000-00-00','2022-11-19 09:44:32',5,'499','2022-11-19 09:44:32','499'),(3538,'','1','141','MOSES OMETAN','MOSE','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',175.00,0.00,0.00,'0000-00-00','2022-11-19 09:45:38',5,'499','2022-11-19 09:45:38','499'),(3539,'','1','141','MADAM UFOMA GAS','UFOMA','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-11-19 09:46:37',5,'499','2022-11-19 09:46:37','499'),(3540,'','1','141','EBIYOR GAS','ABI','07032953864','hassyhusny@yahoo.com','WARRI','DELTA','WARRI','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-11-19 12:01:01',5,'499','2022-11-19 12:01:01','499');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16355 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','141',16166,'764',23846.38,2.00,'2021-08-24','NEW DIPPING','2021-08-24 11:34:37','483','483',2021,'483','2021-08-24 11:34:37',5),('1','141',16353,'764',14770.20,7966.00,'2021-09-08','new dipping','2021-09-08 17:43:49','483','483',2021,'483','2021-09-08 17:43:49',5),('1','141',16354,'764',7966.00,7966.00,'2021-09-08','new dipping','2021-09-08 17:43:49','483','483',2021,'483','2021-09-08 17:43:49',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2143 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','141','764',2135,'5','LPG NOZZLE ',5900694.63,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','141','764',2136,'5','LPG NOZZLE 2',173410.96,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','141','764',2137,'5','LPG NOZZLE 3',92.00,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','141','764',2138,'5','LPG NOZZLE 4',195477.77,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','141','764',2139,'5','LPG NOZZLE 5',200444.68,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','141','764',2140,'5','LPG NOZZLE 6',172442.44,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','141','764',2141,'5','LPG NOZZLE 7',12080.69,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','141','764',2142,'5','LPG NOZZLE 8',62928.85,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258106 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','141',144948,'DAILY SHIFT','2020-07-03','2020-07-03 00:00:00',NULL,'499',0.00,0.00,'499','2020-07-27 15:44:54','499','2020-07-27 15:45:34',10,0),('1','141',145032,'DAILY SHIFT','2020-07-04','2020-07-04 00:00:00',NULL,'499',0.00,0.00,'499','2020-07-28 11:27:01','499','2020-07-28 11:28:14',10,0),('1','141',145043,'DAILY SHIFT','2020-07-06','2020-07-06 00:00:00',NULL,'499',0.00,0.00,'499','2020-07-28 11:58:03','499','2020-07-28 11:58:32',10,0),('1','141',145057,'DAILY SHIFT','2020-07-07','2020-07-07 00:00:00',NULL,'499',0.00,0.00,'499','2020-07-28 13:00:57','499','2020-07-28 13:33:12',10,0),('1','141',145072,'DAILY SHIFT','2020-07-07','2020-07-07 00:00:00',NULL,'499',0.00,0.00,'499','2020-07-28 13:40:32','499','2020-07-28 13:41:06',10,0),('1','141',145081,'DAILY SHIFT','2020-07-08','2020-07-08 00:00:00',NULL,'499',0.00,0.00,'499','2020-07-28 14:32:06','499','2020-07-28 14:32:36',10,0),('1','141',145124,'DAILY SHIFT','2020-07-09','2020-07-09 00:00:00',NULL,'499',0.00,0.00,'499','2020-07-29 05:16:44','499','2020-07-29 05:17:20',10,0),('1','141',145125,'DAILY SHIFT','2020-07-10','2020-07-10 00:00:00',NULL,'499',0.00,0.00,'499','2020-07-29 05:32:11','499','2020-07-29 05:32:41',10,0),('1','141',145126,'DAILY SHIFT','2020-07-11','2020-07-11 00:00:00',NULL,'499',0.00,0.00,'499','2020-07-29 06:01:16','499','2020-07-29 06:01:46',10,0),('1','141',145626,'DAILY SHIFT','2020-07-13','2020-07-13 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-03 10:48:23','499','2020-08-03 10:51:43',10,0),('1','141',145630,'DAILY SHIFT','2020-07-14','2020-07-14 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-03 11:04:23','499','2020-08-03 11:05:14',10,0),('1','141',145638,'DAILY SHIFT','2020-07-15','2020-07-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-03 11:35:01','499','2020-08-03 11:35:39',10,0),('1','141',145642,'DAILY SHIFT','2020-07-16','2020-07-16 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-03 11:45:54','499','2020-08-03 11:46:46',10,0),('1','141',145645,'DAILY SHIFT','2020-07-17','2020-07-17 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-03 12:04:14','499','2020-08-03 12:04:42',10,0),('1','141',145647,'DAILY SHIFT','2020-07-18','2020-07-18 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-03 12:15:22','499','2020-08-03 12:15:53',10,0),('1','141',145654,'DAILY SHIFT','2020-07-20','2020-07-20 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-03 12:58:59','499','2020-08-03 12:59:30',10,0),('1','141',145655,'DAILY SHIFT','2020-07-21','2020-07-21 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-03 13:31:51','499','2020-08-03 13:32:16',10,0),('1','141',145714,'DAILY SHIFT','2020-07-23','2020-07-23 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-03 17:19:10','499','2020-08-03 17:19:36',10,0),('1','141',145719,'DAILY SHIFT','2020-07-23','2020-07-23 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-03 17:33:46','499','2020-08-03 17:34:16',10,0),('1','141',145720,'DAILY SHIFT','2020-07-25','2020-07-25 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-03 17:48:27','499','2020-08-03 17:48:55',10,0),('1','141',145724,'DAILY SHIFT','2020-07-27','2020-07-27 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-03 18:21:56','499','2020-08-03 18:23:13',10,0),('1','141',147954,'DAILY SHIFT','2020-07-28','2020-07-28 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-18 15:15:27','499','2020-08-18 15:16:14',10,0),('1','141',147971,'DAILY SHIFT','2020-07-29','2020-07-29 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-18 16:37:12','499','2020-08-18 16:37:43',10,0),('1','141',148093,'DAILY SHIFT','2020-07-30','2020-07-30 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-19 17:04:48','499','2020-08-19 17:10:44',10,0),('1','141',148198,'DAILY SHIFT','2020-08-01','2020-08-01 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-20 13:07:14','499','2020-08-20 13:15:05',10,0),('1','141',148209,'DAILY SHIFT','2020-08-03','2020-08-03 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-20 13:41:24','499','2020-08-20 13:42:01',10,0),('1','141',148215,'DAILY SHIFT','2020-08-04','2020-08-04 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-20 13:51:51','499','2020-08-20 13:52:19',10,0),('1','141',148221,'DAILY SHIFT','2020-08-05','2020-08-05 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-20 14:17:32','499','2020-08-20 14:17:59',10,0),('1','141',148245,'DAILY SHIFT','2020-08-06','2020-08-06 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-20 16:09:02','499','2020-08-20 16:10:17',10,0),('1','141',148250,'DAILY SHIFT','2020-08-06','2020-08-06 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-20 16:22:31','499','2020-08-20 16:23:08',10,0),('1','141',148254,'DAILY SHIFT','2020-08-08','2020-08-08 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-20 16:33:41','499','2020-08-20 16:34:08',10,0),('1','141',148256,'DAILY SHIFT','2020-08-10','2020-08-10 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-20 16:56:57','499','2020-08-20 16:57:40',10,0),('1','141',148264,'DAILY SHIFT','2020-08-11','2020-08-11 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-20 17:15:10','499','2020-08-20 17:15:42',10,0),('1','141',148266,'DAILY SHIFT','2020-08-12','2020-08-12 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-20 17:27:02','499','2020-08-20 17:27:30',10,0),('1','141',148267,'DAILY SHIFT','2020-08-13','2020-08-13 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-20 17:49:25','499','2020-08-20 17:49:55',10,0),('1','141',148270,'DAILY SHIFT','2020-08-14','2020-08-14 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-20 17:58:12','499','2020-08-20 17:58:43',10,0),('1','141',148388,'DAILY SHIFT','2020-08-15','2020-08-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-21 17:46:12','499','2020-08-21 17:46:48',10,0),('1','141',148420,'DAILY SHIFT','2020-08-17','2020-08-17 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-21 18:53:26','499','2020-08-21 18:53:55',10,0),('1','141',148425,'DAILY SHIFT','2020-08-18','2020-08-18 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-21 19:17:09','499','2020-08-21 19:17:43',10,0),('1','141',148463,'DAILY SHIFT','2020-08-19','2020-08-19 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-22 10:05:51','499','2020-08-22 10:06:18',10,0),('1','141',148466,'DAILY SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-22 10:21:17','499','2020-08-22 10:21:41',10,0),('1','141',148469,'DAILY SHIFT','2020-08-21','2020-08-21 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-22 10:39:10','499','2020-08-22 10:39:34',10,0),('1','141',148554,'DAILY SHIFT','2020-08-22','2020-08-22 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-22 18:35:56','499','2020-08-22 18:36:39',10,0),('1','141',148815,'DAILY SHIFT','2020-08-24','2020-08-24 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-24 21:33:48','499','2020-08-24 21:35:24',10,0),('1','141',148968,'DAILY SHIFT','2020-08-25','2020-08-25 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-25 19:21:52','499','2020-08-25 19:22:17',10,0),('1','141',149163,'DAILY SHIFT','2020-08-26','2020-08-26 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-27 07:44:39','499','2020-08-27 07:45:07',10,0),('1','141',149305,'DAILY SHIFT','2020-08-27','2020-08-27 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-27 19:27:14','499','2020-08-27 19:27:49',10,0),('1','141',149487,'DAILY SHIFT','2020-08-28','2020-08-28 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-29 07:35:43','499','2020-08-29 07:36:12',10,0),('1','141',149578,'DAILY SHIFT','2020-08-29','2020-08-29 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-29 18:58:00','499','2020-08-29 18:58:33',10,0),('1','141',149738,'DAILY SHIFT','2020-08-31','2020-08-31 00:00:00',NULL,'499',0.00,0.00,'499','2020-08-31 18:31:50','499','2020-08-31 18:32:31',10,0),('1','141',150011,'DAILY SHIFT','2020-09-01','2020-09-01 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-02 08:38:10','499','2020-09-02 08:38:38',10,0),('1','141',150422,'DAILY SHIFT','2020-09-03','2020-09-03 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-04 09:42:32','499','2020-09-04 09:43:01',10,0),('1','141',151025,'DAILY SHIFT','2020-09-04','2020-09-04 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-08 09:14:11','499','2020-09-08 09:14:44',10,0),('1','141',151026,'DAILY SHIFT','2020-09-05','2020-09-05 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-08 09:22:47','499','2020-09-08 09:23:14',10,0),('1','141',151027,'DAILY SHIFT','2020-09-07','2020-09-07 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-08 09:31:14','499','2020-09-08 09:31:44',10,0),('1','141',151180,'DAILY SHIFT','2020-09-08','2020-09-08 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-09 10:26:06','499','2020-09-09 10:26:38',10,0),('1','141',151455,'DAILY SHIFT','2020-09-09','2020-09-09 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-11 08:11:28','499','2020-09-11 08:11:56',10,0),('1','141',151462,'DAILY SHIFT','2020-09-10','2020-09-10 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-11 08:24:24','499','2020-09-11 08:24:49',10,0),('1','141',151607,'DAILY SHIFT','2020-09-11','2020-09-11 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-12 08:23:24','499','2020-09-12 08:24:27',10,0),('1','141',151856,'DAILY SHIFT','2020-09-12','2020-09-12 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-14 09:53:04','499','2020-09-14 09:53:31',10,0),('1','141',152086,'DAILY SHIFT','2020-09-14','2020-09-14 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-15 13:16:36','499','2020-09-15 13:17:04',10,0),('1','141',152153,'DAILY SHIFT','2020-09-15','2020-09-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-15 18:13:14','499','2020-09-15 18:13:50',10,0),('1','141',152290,'DAILY SHIFT','2020-09-16','2020-09-16 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-16 22:06:02','499','2020-09-16 22:07:22',10,0),('1','141',152483,'DAILY SHIFT','2020-09-17','2020-09-17 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-17 20:06:18','499','2020-09-17 20:07:32',10,0),('1','141',152633,'DAILY SHIFT','2020-09-18','2020-09-18 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-19 07:21:40','499','2020-09-19 07:22:58',10,0),('1','141',152804,'DAILY SHIFT','2020-09-19','2020-09-19 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-20 09:48:21','499','2020-09-20 09:48:56',10,0),('1','141',152966,'DAILY SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-21 11:46:20','499','2020-09-21 11:46:45',10,0),('1','141',152968,'DAILY SHIFT','2020-09-21','2020-09-21 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-21 18:59:23','499','2020-09-21 19:04:54',10,0),('1','141',153211,'DAILY SHIFT','2020-09-22','2020-09-22 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-22 18:20:08','499','2020-09-22 18:20:38',10,0),('1','141',153503,'DAILY SHIFT','2020-09-23','2020-09-23 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-24 08:27:09','499','2020-09-24 08:27:35',10,0),('1','141',153621,'DAILY SHIFT','2020-09-24','2020-09-24 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-24 17:44:12','499','2020-09-24 17:45:05',10,0),('1','141',153799,'DAILY SHIFT','2020-09-25','2020-09-25 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-25 19:01:21','499','2020-09-25 19:01:53',10,0),('1','141',153925,'DAILY SHIFT','2020-09-26','2020-09-26 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-26 20:26:08','499','2020-09-26 20:26:31',10,0),('1','141',154199,'DAILY SHIFT','2020-09-28','2020-09-28 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-28 18:14:44','499','2020-09-28 18:15:25',10,0),('1','141',154315,'DAILY SHIFT','2020-09-29','2020-09-29 00:00:00',NULL,'499',0.00,0.00,'499','2020-09-29 19:06:15','499','2020-09-29 19:07:10',10,0),('1','141',154608,'DAILY SHIFT','2020-09-30','2020-09-30 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-01 08:52:29','499','2020-10-01 08:53:03',10,0),('1','141',154757,'DAILY SHIFT','2020-10-01','2020-10-01 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-02 08:51:35','499','2020-10-02 08:57:13',10,0),('1','141',154883,'DAILY SHIFT','2020-10-02','2020-10-02 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-02 22:01:13','499','2020-10-02 22:01:41',10,0),('1','141',155021,'DAILY SHIFT','2020-10-03','2020-10-03 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-03 19:41:57','499','2020-10-03 19:42:25',10,0),('1','141',155310,'DAILY SHIFT','2020-10-05','2020-10-05 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-05 22:16:07','499','2020-10-05 22:16:32',10,0),('1','141',155459,'DAILY SHIFT','2020-10-06','2020-10-06 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-06 21:38:52','499','2020-10-06 21:39:53',10,0),('1','141',155651,'DAILY SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-07 21:34:33','499','2020-10-07 21:35:11',10,0),('1','141',155793,'DAILY SHIFT','2020-10-08','2020-10-08 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-09 05:31:46','499','2020-10-09 05:32:15',10,0),('1','141',155937,'DAILY SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-09 22:15:08','499','2020-10-09 22:15:37',10,0),('1','141',156167,'DAILY SHIFT','2020-10-10','2020-10-10 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-11 14:29:56','499','2020-10-11 14:30:32',10,0),('1','141',156271,'DAILY SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-12 18:21:12','499','2020-10-12 18:22:04',10,0),('1','141',156872,'DAILY SHIFT','2020-10-14','2020-10-14 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-15 16:48:29','499','2020-10-15 16:49:00',10,0),('1','141',156890,'DAILY SHIFT','2020-10-15','2020-10-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-15 18:32:52','499','2020-10-15 18:33:19',10,0),('1','141',156995,'DAILY SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-16 18:56:04','499','2020-10-16 18:56:25',10,0),('1','141',157496,'DAILY SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-19 09:28:27','499','2020-10-19 09:28:56',10,0),('1','141',157497,'DAILY SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-19 09:40:37','499','2020-10-19 09:41:30',10,0),('1','141',157678,'DAILY SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-20 08:13:38','499','2020-10-20 08:14:12',10,0),('1','141',157820,'DAILY SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-20 20:55:00','499','2020-10-20 20:55:30',10,0),('1','141',158077,'DAILY SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-22 18:34:01','499','2020-10-22 18:34:26',10,0),('1','141',158080,'DAILY SHIFT','2020-10-21','2020-10-21 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-22 18:44:09','499','2020-10-22 18:45:10',10,0),('1','141',158573,'DAILY SHIFT','2020-10-25','2020-10-25 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-25 18:40:22','499','2020-10-25 18:40:59',10,0),('1','141',159288,'DAILY SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-30 06:32:18','499','2020-10-30 06:32:46',10,0),('1','141',159464,'DAILY SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'499',0.00,0.00,'499','2020-10-31 06:19:08','499','2020-10-31 06:19:35',10,0),('1','141',159863,'DAILY SHIFT','2020-10-31','2020-10-31 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-02 13:28:32','499','2020-11-02 13:28:58',10,0),('1','141',159865,'DAILY SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-02 13:36:21','499','2020-11-02 13:36:44',10,0),('1','141',159933,'DAILY SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-02 18:27:31','499','2020-11-02 18:27:55',10,0),('1','141',160119,'DAILY SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-03 18:23:19','499','2020-11-03 18:23:40',10,0),('1','141',160304,'DAILY SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-04 18:09:44','499','2020-11-04 18:10:10',10,0),('1','141',160449,'DAILY SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-05 18:05:46','499','2020-11-05 18:07:10',10,0),('1','141',160605,'DAILY SHIFT','2020-11-06','2020-11-06 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-06 20:21:06','499','2020-11-06 20:21:32',10,0),('1','141',160888,'DAILY SHIFT','2020-11-07','2020-11-07 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-08 18:38:16','499','2020-11-08 18:41:52',10,0),('1','141',161088,'DAILY SHIFT','2020-11-09','2020-11-09 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-09 18:23:58','499','2020-11-09 18:24:23',10,0),('1','141',161304,'DAILY SHIFT','2020-11-10','2020-11-10 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-11 07:09:31','499','2020-11-11 07:09:57',10,0),('1','141',161446,'DAILY SHIFT','2020-11-11','2020-11-11 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-11 17:56:44','499','2020-11-11 17:57:44',10,0),('1','141',161697,'DAILY SHIFT','2020-11-12','2020-11-12 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-13 07:07:27','499','2020-11-13 07:08:20',10,0),('1','141',161830,'DAILY SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-13 16:27:55','499','2020-11-13 16:28:25',10,0),('1','141',161834,'DAILY SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-13 16:46:35','499','2020-11-13 16:47:07',10,0),('1','141',161839,'DAILY SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-13 17:02:59','499','2020-11-13 17:03:26',10,0),('1','141',161844,'DAILY SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-13 17:10:35','499','2020-11-13 17:12:50',10,0),('1','141',161847,'DAILY SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-13 17:19:41','499','2020-11-13 17:20:11',10,0),('1','141',161857,'DAILY SHIFT','2020-11-13','2020-11-13 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-14 10:06:14','499','2020-11-14 10:06:37',10,0),('1','141',162107,'DAILY SHIFT','2020-11-14','2020-11-14 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-15 11:15:38','499','2020-11-15 11:16:02',10,0),('1','141',162110,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-15 11:30:59','499','2020-11-15 11:31:20',10,0),('1','141',162112,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-15 11:41:25','499','2020-11-15 11:48:17',10,0),('1','141',162117,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-15 11:55:29','499','2020-11-15 11:55:51',10,0),('1','141',162119,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-15 12:04:33','499','2020-11-15 12:04:54',10,0),('1','141',162120,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-15 12:11:15','499','2020-11-15 12:11:48',10,0),('1','141',162121,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-15 12:35:45','499','2020-11-15 12:36:17',10,0),('1','141',162125,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-15 12:40:45','499','2020-11-15 12:41:09',10,0),('1','141',162139,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-15 13:19:01','499','2020-11-15 13:19:29',10,0),('1','141',162140,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-15 13:27:28','499','2020-11-15 13:27:52',10,0),('1','141',162146,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-15 13:37:07','499','2020-11-15 13:37:31',10,0),('1','141',162155,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-15 13:56:05','499','2020-11-15 13:56:30',10,0),('1','141',162159,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-15 14:00:44','499','2020-11-15 14:01:35',10,0),('1','141',162161,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-15 14:08:52','499','2020-11-15 14:10:50',10,0),('1','141',162165,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-15 14:20:48','499','2020-11-15 14:21:11',10,0),('1','141',162171,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-15 14:40:11','499','2020-11-15 14:41:25',10,0),('1','141',162179,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-15 15:09:23','499','2020-11-15 15:10:06',10,0),('1','141',162185,'DAILY SHIFT','2020-11-15','2020-11-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-16 09:38:03','499','2020-11-16 09:38:44',10,0),('1','141',162299,'DAILY SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-16 09:43:57','499','2020-11-16 09:44:19',10,0),('1','141',162300,'DAILY SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-16 09:51:31','499','2020-11-16 09:51:54',10,0),('1','141',162301,'DAILY SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-16 09:56:37','499','2020-11-16 09:57:19',10,0),('1','141',162302,'DAILY SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-16 10:02:19','499','2020-11-16 10:02:46',10,0),('1','141',162490,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-17 08:18:15','499','2020-11-17 08:18:42',10,0),('1','141',162491,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-17 08:22:49','499','2020-11-17 08:23:11',10,0),('1','141',162492,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-17 08:26:30','499','2020-11-17 08:27:00',10,0),('1','141',162493,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-17 08:31:07','499','2020-11-17 08:32:07',10,0),('1','141',162495,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-17 08:37:53','499','2020-11-17 08:38:10',10,0),('1','141',162496,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-17 08:52:20','499','2020-11-17 08:53:22',10,0),('1','141',162502,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-17 09:02:23','499','2020-11-17 09:02:44',10,0),('1','141',162507,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-17 09:10:08','499','2020-11-17 09:14:23',10,0),('1','141',162511,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-17 09:24:38','499','2020-11-17 09:24:59',10,0),('1','141',162519,'DAILY SHIFT','2020-11-16','2020-11-16 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-17 09:53:32','499','2020-11-17 09:53:58',10,0),('1','141',162636,'DAILY SHIFT','2020-11-17','2020-11-17 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-17 17:55:08','499','2020-11-17 17:55:50',10,0),('1','141',162677,'DAILY SHIFT','2020-11-18','2020-11-18 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-18 08:51:53','499','2020-11-18 08:52:21',10,0),('1','141',162802,'DAILY SHIFT','2020-11-18','2020-11-18 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-18 17:55:47','499','2020-11-18 17:56:18',10,0),('1','141',163026,'DAILY SHIFT','2020-11-19','2020-11-19 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-20 07:57:47','499','2020-11-20 07:58:12',10,0),('1','141',163193,'DAILY SHIFT','2020-11-20','2020-11-20 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-20 17:33:23','499','2020-11-20 17:33:53',10,0),('1','141',163237,'DAILY SHIFT','2020-11-21','2020-11-21 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-22 06:59:44','499','2020-11-22 07:00:37',10,0),('1','141',163581,'DAILY SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-23 08:34:44','499','2020-11-23 08:35:06',10,0),('1','141',163742,'DAILY SHIFT','2020-11-23','2020-11-23 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-23 19:03:35','499','2020-11-23 19:07:18',10,0),('1','141',163791,'DAILY SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-25 09:20:26','499','2020-11-25 09:20:48',10,0),('1','141',163937,'DAILY SHIFT','2020-11-24','2020-11-24 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-25 09:26:17','499','2020-11-25 09:26:41',10,0),('1','141',163939,'DAILY SHIFT','2020-11-25','2020-11-25 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-25 17:52:52','499','2020-11-25 17:53:21',10,0),('1','141',164127,'DAILY SHIFT','2020-11-26','2020-11-26 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-26 17:51:48','499','2020-11-26 17:52:15',10,0),('1','141',164433,'DAILY SHIFT','2020-11-27','2020-11-27 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-27 18:19:40','499','2020-11-27 18:20:08',10,0),('1','141',164797,'DAILY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-30 09:28:56','499','2020-11-30 09:31:02',10,0),('1','141',164809,'DAILY SHIFT','2020-11-28','2020-11-28 00:00:00',NULL,'499',0.00,0.00,'499','2020-11-30 10:04:20','499','2020-11-30 10:05:01',10,0),('1','141',165055,'DAILY SHIFT','2020-11-30','2020-11-30 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-01 14:13:12','499','2020-12-01 14:13:54',10,0),('1','141',165164,'DAILY SHIFT','2020-12-01','2020-12-01 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-02 09:03:44','499','2020-12-02 09:04:25',10,0),('1','141',165343,'DAILY SHIFT','2020-12-03','2020-12-03 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-03 09:51:55','499','2020-12-03 09:52:57',10,0),('1','141',165360,'DAILY SHIFT','2020-12-02','2020-12-02 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-03 10:17:59','499','2020-12-03 10:18:44',10,0),('1','141',165515,'DAILY SHIFT','2020-12-03','2020-12-03 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-04 10:08:25','499','2020-12-04 10:08:57',10,0),('1','141',165675,'DAILY SHIFT','2020-12-04','2020-12-04 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-05 09:36:36','499','2020-12-05 09:37:18',10,0),('1','141',166207,'DAILY SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-08 10:33:13','499','2020-12-08 10:34:39',10,0),('1','141',166219,'DAILY SHIFT','2020-12-07','2020-12-07 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-08 10:53:38','499','2020-12-08 10:54:27',10,0),('1','141',166354,'DAILY SHIFT','2020-12-08','2020-12-08 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-09 09:06:34','499','2020-12-09 09:07:37',10,0),('1','141',166495,'DAILY SHIFT','2020-12-09','2020-12-09 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-09 18:38:05','499','2020-12-09 18:39:07',10,0),('1','141',166737,'DAILY SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-11 08:12:24','499','2020-12-11 08:13:15',10,0),('1','141',166743,'DAILY SHIFT','2020-12-10','2020-12-10 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-11 08:34:38','499','2020-12-11 08:35:30',10,0),('1','141',166915,'DAILY SHIFT','2020-12-11','2020-12-11 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-12 08:33:34','499','2020-12-12 08:34:26',10,0),('1','141',167037,'DAILY SHIFT','2020-12-12','2020-12-12 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-12 18:39:37','499','2020-12-12 18:40:04',10,0),('1','141',167376,'DAILY SHIFT','2020-12-14','2020-12-14 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-14 19:44:25','499','2020-12-14 19:45:07',10,0),('1','141',167569,'DAILY SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-15 19:21:26','499','2020-12-15 19:22:05',10,0),('1','141',167573,'DAILY SHIFT','2020-12-15','2020-12-15 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-15 20:01:00','499','2020-12-15 20:02:27',10,0),('1','141',167738,'DAILY SHIFT','2020-12-16','2020-12-16 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-16 19:45:31','499','2020-12-16 19:46:40',10,0),('1','141',167915,'DAILY SHIFT','2020-12-17','2020-12-17 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-17 19:03:30','499','2020-12-17 19:04:05',10,0),('1','141',168122,'DAILY SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-18 19:15:50','499','2020-12-18 19:16:29',10,0),('1','141',168124,'DAILY SHIFT','2020-12-18','2020-12-18 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-19 19:18:35','499','2020-12-19 19:19:06',10,0),('1','141',168288,'DAILY SHIFT','2020-12-19','2020-12-19 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-19 19:44:04','499','2020-12-19 19:44:50',10,0),('1','141',168613,'DAILY SHIFT','2020-12-21','2020-12-21 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-21 19:08:40','499','2020-12-21 19:09:26',10,0),('1','141',168778,'DAILY SHIFT','2020-12-22','2020-12-22 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-22 20:34:37','499','2020-12-22 20:35:47',10,0),('1','141',168796,'DAILY SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-23 07:28:24','499','2020-12-23 07:28:54',10,0),('1','141',168931,'DAILY SHIFT','2020-12-23','2020-12-23 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-23 18:46:28','499','2020-12-23 18:55:50',10,0),('1','141',169200,'DAILY SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-25 13:25:54','499','2020-12-25 13:26:56',10,0),('1','141',169205,'DAILY SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-25 13:43:59','499','2020-12-25 13:45:28',10,0),('1','141',169245,'DAILY SHIFT','2020-12-24','2020-12-24 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-25 16:39:18','499','2020-12-25 16:39:54',10,0),('1','141',169452,'DAILY SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-26 20:06:46','499','2020-12-26 20:07:15',10,0),('1','141',169453,'DAILY SHIFT','2020-12-25','2020-12-25 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-26 20:22:35','499','2020-12-26 20:23:02',10,0),('1','141',169773,'DAILY SHIFT','2020-12-26','2020-12-26 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-28 20:09:23','499','2020-12-28 20:10:51',10,0),('1','141',169776,'DAILY SHIFT','2020-12-28','2020-12-28 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-30 09:55:31','499','2020-12-30 10:02:46',10,0),('1','141',169990,'DAILY SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-30 10:49:22','499','2020-12-30 10:51:00',10,0),('1','141',169999,'DAILY SHIFT','2020-12-29','2020-12-29 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-30 11:21:01','499','2020-12-30 11:52:49',10,0),('1','141',170229,'DAILY SHIFT','2020-12-30','2020-12-30 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-31 12:19:50','499','2020-12-31 12:21:02',10,0),('1','141',170332,'DAILY SHIFT','2020-12-31','2020-12-31 00:00:00',NULL,'499',0.00,0.00,'499','2020-12-31 19:30:43','499','2020-12-31 19:42:35',10,0),('1','141',170567,'DAILY SHIFT','2021-01-01','2021-01-01 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-02 13:42:07','499','2021-01-02 13:42:31',10,0),('1','141',170587,'DAILY SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-02 14:13:01','499','2021-01-02 14:17:36',10,0),('1','141',170670,'DAILY SHIFT','2021-01-02','2021-01-02 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-02 21:08:55','499','2021-01-02 21:10:05',10,0),('1','141',171000,'DAILY SHIFT','2021-01-04','2021-01-04 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-04 21:01:24','499','2021-01-04 21:15:55',10,0),('1','141',171214,'DAILY SHIFT','2021-01-05','2021-01-05 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-05 20:01:42','499','2021-01-05 20:02:23',10,0),('1','141',171369,'DAILY SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-06 18:58:16','499','2021-01-06 18:58:59',10,0),('1','141',171374,'DAILY SHIFT','2021-01-06','2021-01-06 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-06 19:25:51','499','2021-01-06 19:26:16',10,0),('1','141',171576,'DAILY SHIFT','2021-01-07','2021-01-07 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-07 19:15:42','499','2021-01-07 19:16:42',10,0),('1','141',171760,'DAILY SHIFT','2021-01-08','2021-01-08 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-08 18:33:46','499','2021-01-08 18:34:13',10,0),('1','141',171940,'DAILY SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-09 18:33:50','499','2021-01-09 18:34:54',10,0),('1','141',171942,'DAILY SHIFT','2021-01-09','2021-01-09 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-09 18:46:12','499','2021-01-09 18:46:52',10,0),('1','141',172272,'DAILY SHIFT','2021-01-11','2021-01-11 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-11 19:05:51','499','2021-01-11 19:06:44',10,0),('1','141',172483,'DAILY SHIFT','2021-01-12','2021-01-12 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-12 18:29:50','499','2021-01-12 18:31:38',10,0),('1','141',172741,'DAILY SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-14 09:52:28','499','2021-01-14 09:53:15',10,0),('1','141',172751,'DAILY SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-14 10:08:50','499','2021-01-14 10:09:19',10,0),('1','141',172865,'DAILY SHIFT','2021-01-14','2021-01-14 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-14 18:38:26','499','2021-01-14 18:38:52',10,0),('1','141',173047,'DAILY SHIFT','2021-01-15','2021-01-15 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-15 19:10:38','499','2021-01-15 19:11:01',10,0),('1','141',173363,'DAILY SHIFT','2021-01-17','2021-01-17 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-17 18:26:33','499','2021-01-17 18:26:55',10,0),('1','141',173591,'DAILY SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-18 20:31:01','499','2021-01-18 20:32:05',10,0),('1','141',173595,'DAILY SHIFT','2021-01-18','2021-01-18 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-18 20:42:57','499','2021-01-18 20:44:29',10,0),('1','141',173743,'DAILY SHIFT','2021-01-19','2021-01-19 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-19 17:04:31','499','2021-01-19 17:04:59',10,0),('1','141',173941,'DAILY SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-22 10:55:40','499','2021-01-22 10:56:15',10,0),('1','141',174195,'DAILY SHIFT','2021-01-20','2021-01-20 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-22 12:07:40','499','2021-01-22 12:08:03',10,0),('1','141',174221,'DAILY SHIFT','2021-01-21','2021-01-21 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-22 13:15:27','499','2021-01-22 13:16:03',10,0),('1','141',174366,'DAILY SHIFTING','2021-01-23','2021-01-23 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-23 09:53:52','499','2021-01-23 09:54:16',10,0),('1','141',174491,'DAILY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-24 14:16:21','499','2021-01-24 14:17:06',10,0),('1','141',174580,'DAILY SHIFT','2021-01-23','2021-01-23 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-24 14:38:16','499','2021-01-24 14:38:47',10,0),('1','141',175006,'DAILY SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-26 16:27:44','499','2021-01-26 16:28:12',10,0),('1','141',175039,'DAILY SHIFT','2021-01-26','2021-01-26 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-26 22:15:33','499','2021-01-26 22:16:02',10,0),('1','141',175043,'DAILY SHIFT','2021-01-27','2021-01-27 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-31 07:56:50','499','2021-01-31 07:57:22',10,0),('1','141',175773,'DAILY SHIFT','2021-01-28','2021-01-28 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-31 08:12:12','499','2021-01-31 08:12:37',10,0),('1','141',175779,'DAILY SHIFT','2021-01-29','2021-01-29 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-31 08:22:15','499','2021-01-31 08:22:52',10,0),('1','141',175781,'DAILY SHIFTING','2021-01-30','2021-01-30 00:00:00',NULL,'499',0.00,0.00,'499','2021-01-31 08:34:14','499','2021-01-31 08:34:43',10,0),('1','141',176288,'DAILY SHIFT','2021-02-01','2021-02-01 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-02 16:33:26','499','2021-02-02 16:34:02',10,0),('1','141',176295,'DAILY SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-02 16:48:06','499','2021-02-02 16:48:33',10,0),('1','141',176309,'DAILY SHIFT','2021-02-02','2021-02-02 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-02 18:36:04','499','2021-02-02 18:36:31',10,0),('1','141',176523,'DAILY SHIFT','2021-02-03','2021-02-03 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-03 18:09:16','499','2021-02-03 18:09:41',10,0),('1','141',176751,'DAILY SHIFT','2021-02-04','2021-02-04 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-04 18:34:00','499','2021-02-04 18:34:35',10,0),('1','141',176947,'DAILY SHIFT','2021-02-05','2021-02-05 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-05 17:38:17','499','2021-02-05 17:38:47',10,0),('1','141',177280,'DAILY SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-07 10:52:09','499','2021-02-07 10:53:04',10,0),('1','141',177286,'DAILY SHIFT','2021-02-06','2021-02-06 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-07 11:07:58','499','2021-02-07 11:08:35',10,0),('1','141',177730,'DAILY SHIFT','2021-02-08','2021-02-08 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-09 11:42:09','499','2021-02-09 11:42:39',10,0),('1','141',177930,'DAILY SHIFT','2021-02-09','2021-02-09 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-10 09:59:37','499','2021-02-10 10:00:04',10,0),('1','141',178162,'DAILY SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-11 12:06:11','499','2021-02-11 12:06:37',10,0),('1','141',178168,'DAILY SHIFT','2021-02-10','2021-02-10 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-11 12:23:43','499','2021-02-11 12:24:13',10,0),('1','141',178304,'DAILY SHIFT','2021-02-11','2021-02-11 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-12 07:53:42','499','2021-02-12 07:54:19',10,0),('1','141',178716,'DAILY SHIFT','2021-02-12','2021-02-12 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-14 05:59:44','499','2021-02-14 06:00:15',10,0),('1','141',178720,'DAILY SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-14 06:25:12','499','2021-02-14 06:25:55',10,0),('1','141',178722,'DAILY SHIFT','2021-02-14','2021-02-14 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-16 14:13:49','499','2021-02-16 14:14:20',10,0),('1','141',179284,'DAILY SHIFT','2021-02-13','2021-02-13 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-16 14:28:16','499','2021-02-16 14:28:39',10,0),('1','141',179292,'DAILY SHIFT','2021-02-15','2021-02-15 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-16 14:38:52','499','2021-02-16 14:39:16',10,0),('1','141',179442,'DAILY SHIFT','2021-02-16','2021-02-16 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-17 11:37:07','499','2021-02-17 11:37:44',10,0),('1','141',179558,'DAILY SHIFT','2021-02-17','2021-02-17 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-17 20:03:48','499','2021-02-17 20:04:20',10,0),('1','141',179798,'DAILY SHIFT','2021-02-18','2021-02-18 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-19 08:53:25','499','2021-02-19 08:54:00',10,0),('1','141',179998,'DAILY SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-20 07:39:09','499','2021-02-20 07:39:36',10,0),('1','141',180000,'DAILY SHIFT','2021-02-19','2021-02-19 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-20 07:51:54','499','2021-02-20 07:52:19',10,0),('1','141',180236,'DAILY SHIFT','2021-02-20','2021-02-20 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-21 12:01:55','499','2021-02-21 12:03:46',10,0),('1','141',180566,'DAILY SHIFT','2021-02-22','2021-02-22 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-23 08:30:45','499','2021-02-23 08:31:15',10,0),('1','141',180777,'DAILY SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-24 09:26:10','499','2021-02-24 09:26:33',10,0),('1','141',180846,'DAILY SHIFT','2021-02-23','2021-02-23 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-24 12:12:49','499','2021-02-24 12:13:29',10,0),('1','141',180984,'DAILY SHIFT','2021-02-24','2021-02-24 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-25 08:59:21','499','2021-02-25 09:00:29',10,0),('1','141',180988,'DAILY SHIFT','2021-02-25','2021-02-25 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-25 09:14:33','499','2021-02-25 09:15:14',10,0),('1','141',181511,'DAILY SHIFT','2021-02-26','2021-02-26 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-27 18:53:27','499','2021-02-27 18:53:54',10,0),('1','141',181512,'DAILY SHIFT','2021-02-27','2021-02-27 00:00:00',NULL,'499',0.00,0.00,'499','2021-02-27 19:02:47','499','2021-02-27 19:03:33',10,0),('1','141',182006,'DAILY SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-02 11:53:28','499','2021-03-02 11:53:49',10,0),('1','141',182237,'DAILY SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-03 16:23:48','499','2021-03-03 16:24:33',10,0),('1','141',182276,'DAILY SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-04 07:50:01','499','2021-03-04 07:50:43',10,0),('1','141',182334,'DAILY SHIFT','2021-03-04','2021-03-04 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-05 13:33:18','499','2021-03-05 13:33:47',10,0),('1','141',182665,'DAILY SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-06 06:03:55','499','2021-03-06 06:04:31',10,0),('1','141',182845,'DAILY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-07 17:45:28','499','2021-03-07 17:46:07',10,0),('1','141',182989,'DAILY SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-08 10:56:01','499','2021-03-08 10:56:27',10,0),('1','141',183065,'DAILY SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-08 11:22:55','499','2021-03-08 11:23:15',10,0),('1','141',183074,'DAILY SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-09 08:31:59','499','2021-03-09 08:32:35',10,0),('1','141',183242,'DAILY SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-10 07:16:51','499','2021-03-10 07:20:34',10,0),('1','141',183453,'DAILY SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-10 17:31:52','499','2021-03-10 17:32:20',10,0),('1','141',183689,'DAILY SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-11 18:29:24','499','2021-03-11 18:30:07',10,0),('1','141',183841,'DAILY SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-11 18:47:17','499','2021-03-11 18:48:17',10,0),('1','141',183945,'DAILY SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-12 14:53:26','499','2021-03-12 14:53:47',10,0),('1','141',184089,'DAILY SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-13 10:04:45','499','2021-03-13 10:05:15',10,0),('1','141',184095,'DAILY SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-13 16:55:52','499','2021-03-13 16:56:39',10,0),('1','141',184453,'DAILY SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-15 17:37:50','499','2021-03-15 17:38:16',10,0),('1','141',184780,'DAILY SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-17 11:52:50','499','2021-03-17 12:24:30',10,0),('1','141',184993,'DAILY SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-17 12:36:28','499','2021-03-17 12:36:59',10,0),('1','141',185195,'DAILY SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-18 13:36:07','499','2021-03-18 13:36:33',10,0),('1','141',185204,'DAILY SHIFT','2021-03-18','2021-03-18 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-19 12:21:33','499','2021-03-19 12:22:01',10,0),('1','141',185595,'DAILY SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-20 16:25:44','499','2021-03-20 16:26:40',10,0),('1','141',185618,'DAILY SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-20 18:02:18','499','2021-03-20 18:02:51',10,0),('1','141',186030,'DAILY SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-22 17:21:34','499','2021-03-22 17:21:53',10,0),('1','141',186118,'DAILY SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-23 08:36:51','499','2021-03-23 08:38:56',10,0),('1','141',186158,'DAILY SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-23 17:24:42','499','2021-03-23 17:25:27',10,0),('1','141',186426,'DAILY SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-24 17:28:49','499','2021-03-24 17:29:14',10,0),('1','141',186614,'DAILY SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-25 17:03:11','499','2021-03-25 17:04:12',10,0),('1','141',186863,'DAILY SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-26 14:06:41','499','2021-03-26 14:07:04',10,0),('1','141',187097,'DAILY SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-27 15:18:14','499','2021-03-27 15:18:39',10,0),('1','141',187099,'DAILY SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-27 17:20:51','499','2021-03-27 17:21:39',10,0),('1','141',187364,'DAILY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-29 17:45:01','499','2021-03-29 17:45:31',10,0),('1','141',187605,'DAILY SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-30 16:47:22','499','2021-03-30 16:49:22',10,0),('1','141',187849,'DAILY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-31 09:45:51','499','2021-03-31 09:47:03',10,0),('1','141',187871,'DAILY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'499',0.00,0.00,'499','2021-03-31 17:02:21','499','2021-03-31 17:03:26',10,0),('1','141',188039,'DAILY SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-01 17:24:45','499','2021-04-01 17:25:34',10,0),('1','141',188227,'DAILY SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-02 17:47:21','499','2021-04-02 17:47:57',10,0),('1','141',188444,'DAILY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-03 08:00:40','499','2021-04-03 08:01:13',10,0),('1','141',188456,'DAILY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-03 19:33:36','499','2021-04-03 19:34:29',10,0),('1','141',188813,'DAILY SHIFT','2021-04-05','2021-04-05 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-05 16:42:53','499','2021-04-05 16:43:24',10,0),('1','141',189021,'DAILY SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-06 07:12:17','499','2021-04-06 07:12:40',10,0),('1','141',189024,'DAILY SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-06 17:47:17','499','2021-04-06 17:47:41',10,0),('1','141',189220,'DAILY SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-07 17:14:51','499','2021-04-07 17:15:37',10,0),('1','141',189438,'DAILY SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-08 07:49:59','499','2021-04-08 07:50:26',10,0),('1','141',189444,'DAILY SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-08 17:49:20','499','2021-04-08 17:50:28',10,0),('1','141',189644,'DAILY SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-09 16:27:32','499','2021-04-09 16:29:41',10,0),('1','141',189828,'DAILY SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-10 17:53:34','499','2021-04-10 17:54:14',10,0),('1','141',190143,'DAILY SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-11 15:41:50','499','2021-04-11 15:42:25',10,0),('1','141',190154,'DAILY SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-12 07:42:37','499','2021-04-12 07:43:02',10,0),('1','141',190238,'DAILY SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-12 17:42:43','499','2021-04-12 17:43:09',10,0),('1','141',190450,'DAILY SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-13 16:49:29','499','2021-04-13 16:49:55',10,0),('1','141',190675,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-14 17:07:57','499','2021-04-14 17:09:26',10,0),('1','141',190911,'DAILY SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-15 08:13:44','499','2021-04-15 08:14:05',10,0),('1','141',190919,'DAILY SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-16 05:16:21','499','2021-04-16 05:16:53',10,0),('1','141',191071,'DAILY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-16 05:35:21','499','2021-04-16 05:35:46',10,0),('1','141',191074,'DAILY SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-16 05:48:38','499','2021-04-16 05:49:35',10,0),('1','141',191077,'DAILY SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-17 12:28:52','499','2021-04-17 12:29:24',10,0),('1','141',191752,'DAILY SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-19 09:12:05','499','2021-04-19 09:12:29',10,0),('1','141',191959,'DAILY SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-20 08:17:22','499','2021-04-20 08:17:51',10,0),('1','141',191966,'DAILY SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-20 08:42:18','499','2021-04-20 08:43:00',10,0),('1','141',191973,'DAILY SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-20 21:30:15','499','2021-04-20 21:30:46',10,0),('1','141',192145,'DAILY SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-21 16:45:48','499','2021-04-21 16:46:19',10,0),('1','141',192361,'DAILY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-22 07:55:11','499','2021-04-22 07:55:32',10,0),('1','141',192369,'DAILY SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-22 17:13:39','499','2021-04-22 17:14:04',10,0),('1','141',192609,'DAILY SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-23 09:21:52','499','2021-04-23 09:22:22',10,0),('1','141',192651,'DAILY SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-23 17:18:30','499','2021-04-23 17:18:54',10,0),('1','141',192792,'DAILY SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-24 16:33:53','499','2021-04-24 16:34:43',10,0),('1','141',193187,'DAILY SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-26 19:57:03','499','2021-04-26 19:57:38',10,0),('1','141',193428,'DAILY SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-27 16:32:56','499','2021-04-27 16:33:25',10,0),('1','141',193635,'DAILY SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-28 07:32:31','499','2021-04-28 07:33:17',10,0),('1','141',193639,'DAILY SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-28 17:14:04','499','2021-04-28 17:14:31',10,0),('1','141',193903,'DAILY SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-29 20:56:26','499','2021-04-29 20:56:54',10,0),('1','141',194101,'DAILY SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'499',0.00,0.00,'499','2021-04-30 20:57:53','499','2021-04-30 20:58:20',10,0),('1','141',194315,'DAILY SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-01 14:59:53','499','2021-05-01 15:06:01',10,0),('1','141',194426,'DAILY SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-01 15:18:28','499','2021-05-01 15:18:49',10,0),('1','141',194429,'DAILY SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-02 11:07:41','499','2021-05-02 11:08:46',10,0),('1','141',194713,'DAILY SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-03 17:26:31','499','2021-05-03 17:27:27',10,0),('1','141',194885,'DAILY SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-05 07:58:28','499','2021-05-05 07:59:04',10,0),('1','141',195119,'DAILY SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-05 08:45:50','499','2021-05-05 08:46:24',10,0),('1','141',195131,'DAILY SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-05 16:58:45','499','2021-05-05 17:00:08',10,0),('1','141',195317,'DAILY SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-06 16:29:22','499','2021-05-06 16:29:50',10,0),('1','141',195554,'DAILY SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-07 16:42:32','499','2021-05-07 16:43:07',10,0),('1','141',195811,'DAILY SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-08 20:53:23','499','2021-05-08 20:53:57',10,0),('1','141',196249,'DAILY SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-10 07:18:38','499','2021-05-10 07:18:58',10,0),('1','141',196253,'DAILY SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-10 17:00:13','499','2021-05-10 17:01:05',10,0),('1','141',196479,'DAILY SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-12 07:23:34','499','2021-05-12 07:24:19',10,0),('1','141',196684,'DAILY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-12 15:00:16','499','2021-05-12 15:00:46',10,0),('1','141',197042,'DAILY SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-14 07:06:18','499','2021-05-14 07:06:42',10,0),('1','141',197097,'DAILY SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-14 17:37:36','499','2021-05-14 17:38:00',10,0),('1','141',197722,'DAILY SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-17 13:50:07','499','2021-05-17 13:50:41',10,0),('1','141',197799,'DAILY SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-17 16:51:03','499','2021-05-17 16:51:32',10,0),('1','141',197913,'DAILY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-18 09:02:13','499','2021-05-18 09:02:40',10,0),('1','141',197937,'DAILY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-18 17:50:38','499','2021-05-18 17:51:03',10,0),('1','141',198134,'DAILY SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-19 18:01:05','499','2021-05-19 18:01:27',10,0),('1','141',198375,'DAILY SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-20 18:54:47','499','2021-05-20 18:55:19',10,0),('1','141',198589,'DAILY SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-22 07:32:39','499','2021-05-22 07:33:08',10,0),('1','141',198815,'DAILY SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-22 21:31:29','499','2021-05-22 21:32:03',10,0),('1','141',199245,'DAILY SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-24 07:48:33','499','2021-05-24 07:49:12',10,0),('1','141',199250,'DAILY SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-24 17:55:22','499','2021-05-24 17:55:48',10,0),('1','141',199462,'DAILY SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-25 20:25:25','499','2021-05-25 20:25:55',10,0),('1','141',199683,'DAILY SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-26 17:53:33','499','2021-05-26 17:54:05',10,0),('1','141',199885,'DAILY SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-27 11:41:58','499','2021-05-27 12:55:27',10,0),('1','141',200116,'DAILY SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-28 07:37:38','499','2021-05-28 07:38:12',10,0),('1','141',200121,'DAILY SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-28 16:44:53','499','2021-05-28 16:45:57',10,0),('1','141',200318,'DAILY SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-29 17:55:19','499','2021-05-29 17:55:45',10,0),('1','141',200720,'DAILY SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'499',0.00,0.00,'499','2021-05-31 21:13:08','499','2021-05-31 21:13:43',10,0),('1','141',200944,'DAILY SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-01 07:55:44','499','2021-06-01 07:56:15',10,0),('1','141',200958,'DAILY SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-01 18:11:55','499','2021-06-01 18:12:24',10,0),('1','141',201142,'DAILY SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-02 18:08:54','499','2021-06-02 18:09:18',10,0),('1','141',201333,'DAILY SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-03 18:18:22','499','2021-06-03 18:18:47',10,0),('1','141',201524,'DAILY SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-04 16:16:28','499','2021-06-04 16:17:00',10,0),('1','141',201695,'DAILY SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-04 16:44:41','499','2021-06-04 16:45:03',10,0),('1','141',201703,'DAILY SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-04 19:30:08','499','2021-06-04 19:30:31',10,0),('1','141',201774,'DAILY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-05 19:11:25','499','2021-06-05 19:12:03',10,0),('1','141',202239,'DAILY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-07 07:12:12','499','2021-06-07 07:12:49',10,0),('1','141',202244,'DAILY SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-07 07:25:20','499','2021-06-07 07:25:47',10,0),('1','141',202256,'DAILY SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-07 07:53:36','499','2021-06-07 07:55:16',10,0),('1','141',202261,'DAILY SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-07 18:42:36','499','2021-06-07 18:42:57',10,0),('1','141',202453,'DAILY SHIFT71646','2021-06-08','2021-06-08 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-08 21:17:12','499','2021-06-08 21:18:00',10,0),('1','141',202672,'DAILY SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-09 18:11:53','499','2021-06-09 18:12:20',10,0),('1','141',202811,'DAILY SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-09 18:25:22','499','2021-06-09 18:25:51',10,0),('1','141',202890,'DAILY SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-10 18:15:39','499','2021-06-10 18:16:05',10,0),('1','141',203129,'DAILY SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-11 19:07:46','499','2021-06-11 19:08:23',10,0),('1','141',203378,'DAILY SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-12 10:56:51','499','2021-06-12 10:57:19',10,0),('1','141',203383,'DAILY SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-12 17:24:42','499','2021-06-12 17:26:06',10,0),('1','141',203749,'DAILY SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-14 17:11:07','499','2021-06-14 17:11:38',10,0),('1','141',203989,'DAILY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-15 16:51:04','499','2021-06-15 16:51:35',10,0),('1','141',204211,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-16 07:43:03','499','2021-06-16 07:43:27',10,0),('1','141',204222,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-16 16:46:13','499','2021-06-16 16:46:43',10,0),('1','141',204433,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-18 04:58:32','499','2021-06-18 04:59:09',10,0),('1','141',204643,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-18 07:36:08','499','2021-06-18 07:36:33',10,0),('1','141',204651,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-18 17:19:23','499','2021-06-18 17:19:53',10,0),('1','141',204867,'DAILY SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-19 17:16:48','499','2021-06-19 17:17:20',10,0),('1','141',205270,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-21 21:14:53','499','2021-06-21 21:15:41',10,0),('1','141',205499,'DAILY SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-22 07:30:23','499','2021-06-22 07:30:47',10,0),('1','141',205501,'DAILY SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-22 17:15:32','499','2021-06-22 17:18:29',10,0),('1','141',205743,'DAILY SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-23 17:23:22','499','2021-06-23 17:23:47',10,0),('1','141',205981,'DAILY SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-24 17:15:04','499','2021-06-24 17:15:39',10,0),('1','141',206175,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-25 10:11:13','499','2021-06-25 10:12:05',10,0),('1','141',206244,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-25 10:33:43','499','2021-06-25 10:34:12',10,0),('1','141',206247,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-25 16:45:12','499','2021-06-25 16:45:59',10,0),('1','141',206382,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-26 17:21:03','499','2021-06-26 17:21:42',10,0),('1','141',206851,'DAILY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-28 17:24:29','499','2021-06-28 17:25:17',10,0),('1','141',207054,'DAILY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-29 10:49:23','499','2021-06-29 10:49:53',10,0),('1','141',207119,'DAILY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-29 11:02:09','499','2021-06-29 11:02:35',10,0),('1','141',207127,'DAILY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-29 19:17:39','499','2021-06-29 19:18:26',10,0),('1','141',207294,'DAILY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'499',0.00,0.00,'499','2021-06-30 17:35:10','499','2021-06-30 17:35:38',10,0),('1','141',207639,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-01 15:54:03','499','2021-07-01 15:54:29',10,0),('1','141',207642,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-01 20:06:38','499','2021-07-01 20:07:17',10,0),('1','141',207727,'DAILY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-03 05:22:56','499','2021-07-03 05:23:24',10,0),('1','141',207932,'DAILY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-03 20:57:16','499','2021-07-03 20:57:49',10,0),('1','141',208375,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-05 08:44:11','499','2021-07-05 08:44:33',10,0),('1','141',208391,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-05 08:52:37','499','2021-07-05 08:53:03',10,0),('1','141',208405,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-05 17:13:20','499','2021-07-05 17:14:32',10,0),('1','141',208552,'DAILY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-06 15:20:41','499','2021-07-06 15:28:07',10,0),('1','141',208793,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-07 07:40:11','499','2021-07-07 07:40:41',10,0),('1','141',208798,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-07 20:48:02','499','2021-07-07 20:49:02',10,0),('1','141',209023,'DAILY SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-08 17:06:21','499','2021-07-08 17:06:57',10,0),('1','141',209230,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-09 11:02:18','499','2021-07-09 11:03:22',10,0),('1','141',209308,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-09 11:18:28','499','2021-07-09 11:18:57',10,0),('1','141',209314,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-09 21:17:01','499','2021-07-09 21:19:13',10,0),('1','141',209459,'DAILY SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-10 17:19:47','499','2021-07-10 17:20:20',10,0),('1','141',209884,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-13 05:20:27','499','2021-07-13 05:21:04',10,0),('1','141',210120,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-13 17:25:01','499','2021-07-13 17:25:25',10,0),('1','141',210340,'DAILY SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-14 07:52:18','499','2021-07-14 07:52:40',10,0),('1','141',210346,'DAILY SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-14 17:11:53','499','2021-07-14 17:12:28',10,0),('1','141',210502,'DAILY SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-15 21:17:51','499','2021-07-15 21:18:22',10,0),('1','141',210711,'DAILY SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-15 21:59:59','499','2021-07-15 22:00:36',10,0),('1','141',210746,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-16 16:30:11','499','2021-07-16 16:33:19',10,0),('1','141',210983,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-17 15:18:24','499','2021-07-17 15:18:57',10,0),('1','141',211102,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-17 15:45:35','499','2021-07-17 15:45:55',10,0),('1','141',211414,'DAILY SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-19 17:13:04','499','2021-07-19 17:13:52',10,0),('1','141',211746,'DAILY SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-20 20:46:13','499','2021-07-20 20:46:36',10,0),('1','141',211805,'DAILY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-21 17:28:33','499','2021-07-21 17:29:00',10,0),('1','141',212341,'DAILY SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-23 12:11:17','499','2021-07-23 12:11:42',10,0),('1','141',212351,'DAILY SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-23 17:20:33','499','2021-07-23 17:21:04',10,0),('1','141',212497,'DAILY SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-24 17:04:26','499','2021-07-24 17:05:08',10,0),('1','141',212886,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-26 15:19:09','499','2021-07-26 15:21:02',10,0),('1','141',213056,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-27 06:48:31','499','2021-07-27 06:49:08',10,0),('1','141',213137,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-27 16:42:50','499','2021-07-27 16:43:21',10,0),('1','141',213394,'DAILY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-28 15:55:12','499','2021-07-28 15:55:32',10,0),('1','141',213574,'DAILY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-28 16:07:17','499','2021-07-28 16:08:26',10,0),('1','141',213653,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-29 16:59:49','499','2021-07-29 17:02:18',10,0),('1','141',213901,'DAILY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-30 17:08:30','499','2021-07-30 17:08:58',10,0),('1','141',214106,'DAILY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'499',0.00,0.00,'499','2021-07-31 15:44:04','499','2021-07-31 15:44:51',10,0),('1','141',214609,'DAILY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-02 09:56:30','499','2021-08-02 10:00:23',10,0),('1','141',214615,'DAILY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-02 18:43:02','499','2021-08-02 18:45:19',10,0),('1','141',214791,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-03 16:11:15','499','2021-08-03 16:12:07',10,0),('1','141',214968,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-03 18:27:36','499','2021-08-03 18:28:05',10,0),('1','141',215053,'DAILY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-04 16:58:12','499','2021-08-04 16:58:56',10,0),('1','141',215294,'DAILY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-05 17:10:31','499','2021-08-05 17:11:06',10,0),('1','141',215521,'DAILY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-06 16:53:20','499','2021-08-06 16:55:03',10,0),('1','141',215761,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-07 14:00:23','499','2021-08-07 14:01:00',10,0),('1','141',215814,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-07 15:08:22','499','2021-08-07 15:15:49',10,0),('1','141',215822,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-07 16:58:02','499','2021-08-07 16:58:35',10,0),('1','141',216135,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-09 10:58:02','499','2021-08-09 10:58:32',10,0),('1','141',216201,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-09 17:32:55','499','2021-08-09 17:33:29',10,0),('1','141',216357,'DAILY SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-10 10:53:07','499','2021-08-10 10:53:57',10,0),('1','141',216582,'DAILY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-11 07:52:23','499','2021-08-11 07:52:54',10,0),('1','141',216590,'DAILY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-11 17:26:11','499','2021-08-11 17:26:52',10,0),('1','141',216823,'DAILY SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-12 17:49:57','499','2021-08-12 17:50:36',10,0),('1','141',217081,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-13 16:59:24','499','2021-08-13 17:00:02',10,0),('1','141',217735,'DAILY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-16 07:26:20','499','2021-08-16 07:26:55',10,0),('1','141',217737,'DAILY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-16 17:12:14','499','2021-08-16 17:12:45',10,0),('1','141',217989,'DAILY SHIFTS','2021-08-17','2021-08-17 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-17 16:33:42','499','2021-08-17 17:23:40',10,0),('1','141',218244,'DAILY SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-18 17:16:50','499','2021-08-18 17:17:19',10,0),('1','141',218455,'DAILY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-19 20:59:31','499','2021-08-19 20:59:58',10,0),('1','141',218659,'DAILY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-19 21:13:33','499','2021-08-19 21:13:56',10,0),('1','141',218689,'DAILY SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-20 16:47:41','499','2021-08-20 16:48:30',10,0),('1','141',218962,'DAILY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-21 16:52:23','499','2021-08-21 16:53:46',10,0),('1','141',219418,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-23 14:54:37','499','2021-08-23 14:55:05',10,0),('1','141',219553,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-24 09:33:39','499','2021-08-24 09:34:02',10,0),('1','141',219671,'DAILY SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-24 16:24:57','499','2021-08-24 16:25:30',10,0),('1','141',219819,'DAILY SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-25 17:12:40','499','2021-08-25 17:13:33',10,0),('1','141',220050,'DAILY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-26 16:22:57','499','2021-08-26 16:24:11',10,0),('1','141',220265,'DAILY SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-27 12:01:58','499','2021-08-27 12:02:26',10,0),('1','141',220563,'DAILY SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-28 12:09:23','499','2021-08-28 12:09:49',10,0),('1','141',220565,'DAILY SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-28 18:40:00','499','2021-08-28 18:41:17',10,0),('1','141',220946,'DAILY SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-30 17:04:22','499','2021-08-30 17:05:03',10,0),('1','141',221178,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-31 16:55:24','499','2021-08-31 16:56:12',10,0),('1','141',221338,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-31 17:29:42','499','2021-08-31 17:30:09',10,0),('1','141',221343,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'499',0.00,0.00,'499','2021-08-31 18:03:07','499','2021-08-31 18:03:35',10,0),('1','141',221432,'DAILY SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-01 16:56:35','499','2021-09-01 16:59:35',10,0),('1','141',221711,'DAILY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-02 16:41:03','499','2021-09-02 16:41:52',10,0),('1','141',221866,'DAILY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-03 17:30:33','499','2021-09-03 17:31:44',10,0),('1','141',222094,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-04 14:24:09','499','2021-09-04 14:24:42',10,0),('1','141',222205,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-04 15:19:21','499','2021-09-04 15:19:49',10,0),('1','141',222486,'DAILY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-07 08:19:43','499','2021-09-07 08:22:45',10,0),('1','141',222766,'DAILY SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-08 19:15:49','499','2021-09-08 19:16:16',10,0),('1','141',223149,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-08 19:25:12','499','2021-09-08 19:25:41',10,0),('1','141',223153,'DAILY SHIFT ','2021-09-08','2021-09-08 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-08 20:22:43','499','2021-09-08 20:23:08',10,0),('1','141',223195,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-09 17:18:58','499','2021-09-09 17:20:26',10,0),('1','141',223442,'DAILY SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-10 17:28:05','499','2021-09-10 17:30:00',10,0),('1','141',223664,'DAILY SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-12 09:15:41','499','2021-09-12 09:16:38',10,0),('1','141',224104,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-13 07:58:17','499','2021-09-13 07:59:12',10,0),('1','141',224108,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-13 17:37:59','499','2021-09-13 17:39:11',10,0),('1','141',224377,'DAILY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-14 17:34:39','499','2021-09-14 17:35:12',10,0),('1','141',224548,'DAILY SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-15 17:41:59','499','2021-09-15 17:42:57',10,0),('1','141',224797,'DAILY SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-16 07:18:11','499','2021-09-16 07:20:41',10,0),('1','141',224799,'DAILY SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-16 20:18:36','499','2021-09-16 20:19:35',10,0),('1','141',225050,'DAILY SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-17 17:10:34','499','2021-09-17 17:14:30',10,0),('1','141',225280,'DAILY SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-18 17:31:54','499','2021-09-18 17:32:42',10,0),('1','141',225723,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-21 06:01:43','499','2021-09-21 06:02:30',10,0),('1','141',225993,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-21 17:07:19','499','2021-09-21 17:07:50',10,0),('1','141',226273,'DAILY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-22 09:18:28','499','2021-09-22 09:19:01',10,0),('1','141',226284,'DAILY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-23 05:19:58','499','2021-09-23 05:21:00',10,0),('1','141',226495,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-24 05:29:28','499','2021-09-24 05:33:14',10,0),('1','141',226764,'DAILY SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-25 09:07:38','499','2021-09-25 09:08:42',10,0),('1','141',227148,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-25 17:38:12','499','2021-09-25 17:38:51',10,0),('1','141',227154,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-25 18:08:12','499','2021-09-25 18:08:43',10,0),('1','141',227359,'DAILY SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-27 18:17:49','499','2021-09-27 18:21:34',10,0),('1','141',227628,'DAILY SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-28 18:51:45','499','2021-09-28 19:00:28',10,0),('1','141',227870,'DAILY SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-29 07:09:29','499','2021-09-29 07:09:53',10,0),('1','141',227873,'DAILY SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-29 17:55:02','499','2021-09-29 17:56:13',10,0),('1','141',228142,'DAILY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'499',0.00,0.00,'499','2021-09-30 18:01:59','499','2021-09-30 18:05:08',10,0),('1','141',228389,'DAILY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-01 14:02:57','499','2021-10-01 14:06:58',10,0),('1','141',228580,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-02 10:27:17','499','2021-10-02 10:27:35',10,0),('1','141',228588,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-02 17:37:48','499','2021-10-02 17:39:38',10,0),('1','141',228925,'DAILY SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-04 17:37:32','499','2021-10-04 17:38:44',10,0),('1','141',229187,'DAILY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-05 17:06:58','499','2021-10-05 17:08:07',10,0),('1','141',229449,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-06 13:14:52','499','2021-10-06 13:16:58',10,0),('1','141',229687,'DAILY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-07 07:47:38','499','2021-10-07 07:48:02',10,0),('1','141',229694,'DAILY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-07 17:17:49','499','2021-10-07 17:18:29',10,0),('1','141',229946,'DAILY SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-08 17:22:58','499','2021-10-08 17:24:17',10,0),('1','141',230111,'DAILY SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-09 08:18:24','499','2021-10-09 08:19:00',10,0),('1','141',230462,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-10 15:47:24','499','2021-10-10 15:47:59',10,0),('1','141',230466,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-10 17:01:32','499','2021-10-10 17:02:09',10,0),('1','141',230543,'DAILY SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-11 18:01:11','499','2021-10-11 18:02:13',10,0),('1','141',230800,'DAILY SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-13 07:29:03','499','2021-10-13 07:30:40',10,0),('1','141',231455,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-14 10:04:25','499','2021-10-14 10:07:07',10,0),('1','141',231463,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-14 17:20:28','499','2021-10-14 17:21:56',10,0),('1','141',231664,'DAILY SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-15 17:00:32','499','2021-10-15 17:01:02',10,0),('1','141',231903,'DAILY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-16 06:49:09','499','2021-10-16 06:49:33',10,0),('1','141',231908,'DAILY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-16 17:10:51','499','2021-10-16 17:11:25',10,0),('1','141',232152,'DAILY SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-17 22:18:12','499','2021-10-17 22:18:43',10,0),('1','141',232355,'DAILY SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-18 15:24:49','499','2021-10-18 15:27:12',10,0),('1','141',232613,'DAILY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-19 07:20:59','499','2021-10-19 07:24:49',10,0),('1','141',232617,'DAILY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-19 18:29:39','499','2021-10-19 18:30:21',10,0),('1','141',232873,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-20 20:51:54','499','2021-10-20 20:52:38',10,0),('1','141',233424,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-22 08:20:53','499','2021-10-22 08:21:21',10,0),('1','141',233437,'DAILY SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-22 09:27:33','499','2021-10-22 09:27:58',10,0),('1','141',233448,'DAILY SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-22 20:33:00','499','2021-10-22 20:33:28',10,0),('1','141',233631,'DAILY SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-24 01:32:08','499','2021-10-24 01:33:33',10,0),('1','141',233981,'DAILY SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-24 16:48:07','499','2021-10-24 16:48:52',10,0),('1','141',234084,'DAILY SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-25 20:19:51','499','2021-10-25 20:20:25',10,0),('1','141',234494,'DAILY SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-26 15:28:47','499','2021-10-26 15:29:54',10,0),('1','141',234643,'DAILY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-27 19:28:53','499','2021-10-27 19:29:26',10,0),('1','141',234860,'DAILY SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-28 19:07:52','499','2021-10-28 19:09:11',10,0),('1','141',235111,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-29 20:07:58','499','2021-10-29 20:10:07',10,0),('1','141',235348,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'499',0.00,0.00,'499','2021-10-30 07:47:40','499','2021-10-30 07:48:04',10,0),('1','141',235352,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-01 07:46:33','499','2021-11-01 07:47:27',10,0),('1','141',235812,'DAILY SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-01 19:49:37','499','2021-11-01 19:50:08',10,0),('1','141',236076,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-02 08:03:45','499','2021-11-02 08:04:11',10,0),('1','141',236078,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-02 20:03:51','499','2021-11-02 20:04:20',10,0),('1','141',236261,'DAILY SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-03 19:41:38','499','2021-11-03 19:42:39',10,0),('1','141',236540,'DAILY SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-04 17:24:48','499','2021-11-04 17:25:33',10,0),('1','141',236785,'DAILY SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-05 08:36:13','499','2021-11-05 08:37:07',10,0),('1','141',236808,'DAILY SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-05 18:28:54','499','2021-11-05 18:29:23',10,0),('1','141',236995,'DAILY SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-06 17:37:39','499','2021-11-06 17:38:06',10,0),('1','141',237239,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-07 17:24:32','499','2021-11-07 17:25:04',10,0),('1','141',237624,'DAILY SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-09 06:39:37','499','2021-11-09 06:39:56',10,0),('1','141',237630,'DAILY SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-09 17:16:37','499','2021-11-09 17:17:04',10,0),('1','141',237947,'DAILY SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-10 20:30:55','499','2021-11-10 20:31:25',10,0),('1','141',238162,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-11 07:38:53','499','2021-11-11 07:39:42',10,0),('1','141',238170,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-12 05:18:11','499','2021-11-12 05:18:48',10,0),('1','141',238386,'DAILY SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-12 17:15:44','499','2021-11-12 17:16:11',10,0),('1','141',238641,'DAILY SHIFT ','2021-11-13','2021-11-13 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-13 07:28:17','499','2021-11-13 07:29:01',10,0),('1','141',238646,'DAILY SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-13 20:55:19','499','2021-11-13 20:55:49',10,0),('1','141',238873,'DAILY SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-14 17:52:49','499','2021-11-14 17:53:17',10,0),('1','141',239050,'DAILY SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-15 05:17:38','499','2021-11-15 05:18:04',10,0),('1','141',239053,'DAILY SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-15 21:38:25','499','2021-11-15 21:39:08',10,0),('1','141',239471,'DAILY SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-16 19:14:02','499','2021-11-16 19:14:34',10,0),('1','141',239533,'DAILY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-18 05:25:06','499','2021-11-18 05:25:55',10,0),('1','141',239815,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-18 07:40:03','499','2021-11-18 07:40:31',10,0),('1','141',239823,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-19 05:19:09','499','2021-11-19 05:19:39',10,0),('1','141',239994,'DAILY SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-20 05:11:23','499','2021-11-20 05:12:10',10,0),('1','141',240243,'DAILY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-20 20:49:30','499','2021-11-20 20:49:57',10,0),('1','141',240772,'DAILY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-22 09:33:14','499','2021-11-22 09:33:32',10,0),('1','141',240775,'DAILY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-23 05:22:12','499','2021-11-23 05:22:57',10,0),('1','141',240999,'DAILY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-23 20:03:35','499','2021-11-23 20:04:09',10,0),('1','141',241272,'DAILY SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-25 05:50:44','499','2021-11-25 05:51:30',10,0),('1','141',241801,'DAILY SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-26 08:18:00','499','2021-11-26 08:18:19',10,0),('1','141',241803,'DAILY SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-27 22:23:44','499','2021-11-27 22:24:09',10,0),('1','141',242175,'DAILY SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-27 22:31:56','499','2021-11-27 22:32:26',10,0),('1','141',242501,'DAILY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-29 20:48:13','499','2021-11-29 20:48:42',10,0),('1','141',242840,'DAILY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'499',0.00,0.00,'499','2021-11-30 16:18:59','499','2021-11-30 16:19:38',10,0),('1','141',242843,'DAILY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-01 04:58:53','499','2021-12-01 04:59:27',10,0),('1','141',243038,'DAILY SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-02 05:49:39','499','2021-12-02 05:50:20',10,0),('1','141',243138,'DAILY SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-03 05:34:38','499','2021-12-03 05:35:03',10,0),('1','141',243413,'DAILY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-03 07:54:30','499','2021-12-03 07:54:50',10,0),('1','141',243419,'DAILY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-04 07:27:54','499','2021-12-04 07:28:20',10,0),('1','141',243643,'DAILY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-05 07:11:05','499','2021-12-05 07:12:28',10,0),('1','141',243857,'DAILY SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-05 19:44:44','499','2021-12-05 19:45:08',10,0),('1','141',244128,'DAILY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-06 09:44:33','499','2021-12-06 09:44:56',10,0),('1','141',244146,'DAILY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-06 09:50:52','499','2021-12-06 09:51:30',10,0),('1','141',244153,'DAILY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-06 20:01:00','499','2021-12-06 20:01:26',10,0),('1','141',244506,'DAILY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-08 05:14:49','499','2021-12-08 05:15:14',10,0),('1','141',244784,'DAILY SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-09 07:42:03','499','2021-12-09 07:42:29',10,0),('1','141',244973,'DAILY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-10 05:46:01','499','2021-12-10 05:46:26',10,0),('1','141',244980,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-10 05:58:29','499','2021-12-10 05:59:08',10,0),('1','141',245033,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-11 05:49:32','499','2021-12-11 05:49:54',10,0),('1','141',245523,'DAILY SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-12 11:03:19','499','2021-12-12 11:03:47',10,0),('1','141',245660,'DAILY SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-13 04:57:16','499','2021-12-13 04:57:40',10,0),('1','141',245724,'DAILY SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-14 05:21:48','499','2021-12-14 05:22:25',10,0),('1','141',245927,'DAILY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-15 06:12:44','499','2021-12-15 06:13:24',10,0),('1','141',246234,'DAILY SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-15 07:52:16','499','2021-12-15 07:52:35',10,0),('1','141',246244,'DAILY SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-16 05:46:29','499','2021-12-16 05:47:08',10,0),('1','141',246448,'DAILY SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-17 08:10:09','499','2021-12-17 08:10:37',10,0),('1','141',246754,'DAILY SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-18 07:33:45','499','2021-12-18 07:34:15',10,0),('1','141',246982,'DAILY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-18 07:50:41','499','2021-12-18 07:51:00',10,0),('1','141',246985,'DAILY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-18 19:55:35','499','2021-12-18 19:56:12',10,0),('1','141',247230,'DAILY SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-20 05:11:14','499','2021-12-20 05:11:46',10,0),('1','141',247425,'DAILY SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-20 14:30:20','499','2021-12-20 14:30:44',10,0),('1','141',247708,'DAILY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-21 08:14:27','499','2021-12-21 08:14:47',10,0),('1','141',247713,'DAILY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-21 17:00:47','499','2021-12-21 17:01:37',10,0),('1','141',247956,'DAILY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-22 16:43:56','499','2021-12-22 17:07:12',10,0),('1','141',248203,'DAILY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-23 16:35:25','499','2021-12-23 16:37:35',10,0),('1','141',248384,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-24 05:09:00','499','2021-12-24 05:09:22',10,0),('1','141',248462,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-24 17:38:04','499','2021-12-24 17:39:14',10,0),('1','141',248680,'DAILY SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-25 17:55:39','499','2021-12-25 17:57:50',10,0),('1','141',249108,'DAILY SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-27 06:12:37','499','2021-12-27 06:13:18',10,0),('1','141',249109,'DAILY SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-27 06:17:22','499','2021-12-27 06:17:55',10,0),('1','141',249117,'DAILY SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-27 16:36:44','499','2021-12-27 16:37:06',10,0),('1','141',249381,'DAILY SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-28 16:40:17','499','2021-12-28 16:40:48',10,0),('1','141',249614,'DAILY SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-29 07:07:57','499','2021-12-29 07:08:32',10,0),('1','141',249620,'DAILY SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-29 07:19:19','499','2021-12-29 07:19:45',10,0),('1','141',249630,'DAILY SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-30 06:21:26','499','2021-12-30 06:22:15',10,0),('1','141',249926,'DAILY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-30 20:26:08','499','2021-12-30 20:28:16',10,0),('1','141',250154,'DAILY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'499',0.00,0.00,'499','2021-12-31 20:57:34','499','2021-12-31 20:58:17',10,0),('1','141',250373,'DAILY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-01 07:46:09','499','2022-01-01 07:46:38',10,0),('1','141',250379,'DAILY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-02 06:00:52','499','2022-01-02 06:02:08',10,0),('1','141',250623,'DAILY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-02 20:07:19','499','2022-01-02 20:07:58',10,0),('1','141',250858,'DAILY SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-03 20:10:54','499','2022-01-03 20:12:43',10,0),('1','141',251055,'DAILY SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-04 20:18:39','499','2022-01-04 20:19:39',10,0),('1','141',251374,'DAILY SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-05 12:52:15','499','2022-01-05 12:52:42',10,0),('1','141',251377,'DAILY SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-05 20:48:22','499','2022-01-05 20:49:14',10,0),('1','141',251562,'DAILY SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-07 06:46:44','499','2022-01-07 06:47:29',10,0),('1','141',251804,'DAILY SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-07 19:52:10','499','2022-01-07 19:52:56',10,0),('1','141',252018,'DAILY SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-09 06:21:18','499','2022-01-09 06:22:14',10,0),('1','141',252287,'DAILY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-10 06:59:38','499','2022-01-10 07:00:34',10,0),('1','141',252508,'DAILY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-10 21:58:53','499','2022-01-10 22:01:21',10,0),('1','141',252745,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-11 08:24:27','499','2022-01-11 08:24:47',10,0),('1','141',252754,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-12 06:19:18','499','2022-01-12 06:19:55',10,0),('1','141',253002,'DAILY SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-12 20:32:52','499','2022-01-12 20:33:32',10,0),('1','141',253250,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-13 21:22:43','499','2022-01-13 21:24:12',10,0),('1','141',253494,'DAILY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-14 07:48:48','499','2022-01-14 07:49:19',10,0),('1','141',253499,'DAILY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-14 22:38:13','499','2022-01-14 22:38:51',10,0),('1','141',253755,'DAILY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-15 22:58:36','499','2022-01-15 23:00:50',10,0),('1','141',254027,'DAILY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-16 21:11:02','499','2022-01-16 21:13:45',10,0),('1','141',254194,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-17 07:43:30','499','2022-01-17 07:44:08',10,0),('1','141',254231,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-17 22:07:40','499','2022-01-17 22:09:13',10,0),('1','141',254499,'DAILY SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-18 20:57:29','499','2022-01-18 21:03:51',10,0),('1','141',254731,'DAILY SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-19 15:49:34','499','2022-01-19 15:50:38',10,0),('1','141',254980,'DAILY SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-20 18:33:51','499','2022-01-20 18:34:46',10,0),('1','141',255222,'DAILY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-21 17:50:02','499','2022-01-21 17:50:40',10,0),('1','141',255392,'DAILY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-22 08:18:08','499','2022-01-22 08:18:27',10,0),('1','141',255493,'DAILY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-22 18:38:33','499','2022-01-22 18:43:03',10,0),('1','141',255772,'DAILY SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-24 06:47:26','499','2022-01-24 06:48:05',10,0),('1','141',256003,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-24 08:49:23','499','2022-01-24 08:49:55',10,0),('1','141',256010,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-25 06:52:31','499','2022-01-25 06:54:21',10,0),('1','141',256242,'DAILY SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-26 06:37:04','499','2022-01-26 06:38:11',10,0),('1','141',256541,'DAILY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-27 06:34:25','499','2022-01-27 06:35:01',10,0),('1','141',256721,'DAILY SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-27 06:50:50','499','2022-01-27 06:51:09',10,0),('1','141',256724,'DAILY SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-27 21:17:29','499','2022-01-27 21:17:59',10,0),('1','141',257000,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-28 08:55:01','499','2022-01-28 08:55:21',10,0),('1','141',257013,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-29 06:25:49','499','2022-01-29 06:26:28',10,0),('1','141',257231,'DAILY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-30 06:33:02','499','2022-01-30 06:33:46',10,0),('1','141',257573,'DAILY SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-30 11:40:37','499','2022-01-30 11:41:34',10,0),('1','141',257577,'DAILY SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-31 07:00:27','499','2022-01-31 07:00:55',10,0),('1','141',257578,'DAILY SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'499',0.00,0.00,'499','2022-01-31 21:22:41','499','2022-01-31 21:23:12',10,0),('1','141',257579,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-01 09:34:54','499','2022-02-01 09:35:38',10,0),('1','141',257580,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-02 06:31:40','499','2022-02-02 06:32:46',10,0),('1','141',257581,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-02 22:53:13','499','2022-02-02 22:53:45',10,0),('1','141',257582,'DAILY SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-03 07:16:31','499','2022-02-03 07:16:50',10,0),('1','141',257583,'DAILY SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-04 05:24:05','499','2022-02-04 05:24:30',10,0),('1','141',257584,'DAILY SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-05 06:47:28','499','2022-02-05 06:48:03',10,0),('1','141',257585,'DAILY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-05 07:13:23','499','2022-02-05 07:13:55',10,0),('1','141',257586,'DAILY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-06 09:09:33','499','2022-02-06 09:09:58',10,0),('1','141',257587,'DAILY SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-07 06:22:34','499','2022-02-07 06:23:00',10,0),('1','141',257588,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-07 06:36:36','499','2022-02-07 06:37:03',10,0),('1','141',257589,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-07 19:55:05','499','2022-02-07 19:55:31',10,0),('1','141',257590,'DAILY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-08 20:34:08','499','2022-02-08 20:34:33',10,0),('1','141',257591,'DAILY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-09 08:41:05','499','2022-02-09 08:41:47',10,0),('1','141',257592,'DAILY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-10 06:48:38','499','2022-02-10 06:49:01',10,0),('1','141',257593,'DAILY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-11 06:37:36','499','2022-02-11 06:38:08',10,0),('1','141',257594,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-11 07:59:05','499','2022-02-11 07:59:30',10,0),('1','141',257595,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-12 06:39:41','499','2022-02-12 06:40:05',10,0),('1','141',257596,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-13 07:32:38','499','2022-02-13 07:33:03',10,0),('1','141',257597,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-13 18:40:49','499','2022-02-13 18:41:12',10,0),('1','141',257598,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-14 07:07:40','499','2022-02-14 07:08:20',10,0),('1','141',257599,'DAILY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-14 20:26:23','499','2022-02-14 20:26:50',10,0),('1','141',257600,'DAILY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-16 06:44:59','499','2022-02-16 06:45:24',10,0),('1','141',257601,'DAILY SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-17 08:43:22','499','2022-02-17 08:43:41',10,0),('1','141',257602,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-17 11:49:55','499','2022-02-17 11:50:36',10,0),('1','141',257603,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-17 11:56:30','499','2022-02-17 11:57:04',10,0),('1','141',257604,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-17 18:36:25','499','2022-02-18 08:25:29',10,0),('1','141',257605,'DAILY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-18 18:38:26','499','2022-02-18 18:38:59',10,0),('1','141',257606,'DAILY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-19 17:31:11','499','2022-02-19 17:41:08',10,0),('1','141',257607,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-20 16:07:18','499','2022-02-20 16:07:58',10,0),('1','141',257608,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-20 16:18:42','499','2022-02-20 16:19:17',10,0),('1','141',257609,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-20 17:40:03','499','2022-02-20 17:40:53',10,0),('1','141',257610,'DAILY SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'499',0.00,0.00,'499','2022-02-21 18:34:46','499','2022-02-21 18:35:20',10,0),('1','141',257611,'DAILY SHIFT','2022-02-22','2022-02-22 08:32:44','2022-02-23 08:32:44','499',0.00,0.00,'499','2022-02-22 18:17:56','499','2022-02-22 18:18:26',10,0),('1','141',257612,'DAILY SHIFT','2022-02-23','2022-02-23 08:45:34','2022-02-24 08:45:34','499',0.00,0.00,'499','2022-02-23 14:43:38','499','2022-02-23 14:44:05',10,0),('1','141',257613,'DAILY SHIFT','2022-02-24','2022-02-24 06:13:13','2022-02-25 06:13:13','499',0.00,0.00,'499','2022-02-25 07:44:57','499','2022-02-25 07:45:24',10,0),('1','141',257614,'DAILY SHIFT','2022-02-25','2022-02-25 07:45:54','2022-02-26 07:45:54','499',0.00,0.00,'499','2022-02-25 18:36:36','499','2022-02-25 18:37:04',10,0),('1','141',257615,'DAILY SHIFT','2022-02-26','2022-02-26 08:11:50','2022-02-27 08:11:50','499',0.00,0.00,'499','2022-02-26 18:04:17','499','2022-02-26 18:04:34',10,0),('1','141',257616,'DAILY SHIFT','2022-02-27','2022-02-27 10:05:28','2022-02-28 10:05:28','499',0.00,0.00,'499','2022-02-27 18:35:22','499','2022-02-27 18:35:44',10,0),('1','141',257617,'DAILY SHIFT','2022-02-27','2022-02-27 21:04:29','2022-02-28 21:04:29','499',0.00,0.00,'499','2022-02-27 21:12:12','499','2022-02-27 21:12:44',10,0),('1','141',257618,'DAILY SHIFT','2022-02-28','2022-02-28 08:02:08','2022-03-01 08:02:08','499',0.00,0.00,'499','2022-02-28 18:43:29','499','2022-02-28 18:46:38',10,0),('1','141',257619,'DAILY SHIFT','2022-03-01','2022-03-01 08:24:28','2022-03-02 08:24:28','499',0.00,0.00,'499','2022-03-01 19:25:54','499','2022-03-01 19:26:21',10,0),('1','141',257620,'DAILY SHIFT','2022-03-02','2022-03-02 02:46:05','2022-03-03 02:46:05','499',0.00,0.00,'499','2022-03-02 02:56:58','499','2022-03-02 02:57:39',10,0),('1','141',257621,'DAILY SHIFT','2022-03-02','2022-03-02 08:38:31','2022-03-03 08:38:31','499',0.00,0.00,'499','2022-03-02 18:32:51','499','2022-03-02 18:34:38',10,0),('1','141',257622,'DAILY SHIFT','2022-03-03','2022-03-03 08:08:19','2022-03-04 08:08:19','499',0.00,0.00,'499','2022-03-03 19:14:39','499','2022-03-03 19:15:08',10,0),('1','141',257623,'DAILY SHIFT','2022-03-04','2022-03-04 07:52:56','2022-03-05 07:52:56','499',0.00,0.00,'499','2022-03-04 07:56:58','499','2022-03-04 07:57:31',10,0),('1','141',257624,'DAILY SHIFT','2022-03-04','2022-03-04 08:03:14','2022-03-05 08:03:14','499',0.00,0.00,'499','2022-03-04 18:19:20','499','2022-03-04 18:19:47',10,0),('1','141',257625,'DAILY SHIFT','2022-03-05','2022-03-05 07:41:11','2022-03-06 07:41:11','499',0.00,0.00,'499','2022-03-06 06:45:16','499','2022-03-06 06:45:47',10,0),('1','141',257626,'DAILY SHIFT','2022-03-06','2022-03-06 09:23:22','2022-03-07 09:23:22','499',0.00,0.00,'499','2022-03-07 06:40:18','499','2022-03-07 06:40:49',10,0),('1','141',257627,'DAILY SHIFT','2022-03-07','2022-03-07 06:53:12','2022-03-08 06:53:12','499',0.00,0.00,'499','2022-03-07 08:38:08','499','2022-03-07 08:38:29',10,0),('1','141',257628,'DAILY SHIFT','2022-03-07','2022-03-07 08:39:06','2022-03-08 08:39:06','499',0.00,0.00,'499','2022-03-07 21:31:05','499','2022-03-07 21:31:50',10,0),('1','141',257629,'DAILY SHIFT','2022-03-08','2022-03-08 08:13:14','2022-03-09 08:13:14','499',0.00,0.00,'499','2022-03-08 16:36:29','499','2022-03-08 16:37:13',10,0),('1','141',257630,'DAILY SHIFT','2022-03-11','2022-03-11 06:31:55','2022-03-12 06:31:55','499',0.00,0.00,'499','2022-03-11 06:37:18','499','2022-03-11 06:37:42',10,0),('1','141',257631,'DAILY SHIFT','2022-03-11','2022-03-11 06:43:53','2022-03-12 06:43:53','499',0.00,0.00,'499','2022-03-11 18:14:05','499','2022-03-11 18:39:39',10,0),('1','141',257632,'DAILY SHIFT','2022-03-12','2022-03-12 08:07:22','2022-03-13 08:07:22','499',0.00,0.00,'499','2022-03-12 17:43:46','499','2022-03-12 17:44:22',10,0),('1','141',257633,'DAILY SHIFT','2022-03-13','2022-03-13 10:28:02','2022-03-14 10:28:02','499',0.00,0.00,'499','2022-03-13 16:58:03','499','2022-03-13 16:59:04',10,0),('1','141',257634,'DAILY SHIFT','2022-03-14','2022-03-14 07:07:50','2022-03-15 07:07:50','499',0.00,0.00,'499','2022-03-14 18:40:56','499','2022-03-14 18:41:19',10,0),('1','141',257635,'DAILY SHIFT','2022-03-15','2022-03-15 06:33:04','2022-03-16 06:33:04','499',0.00,0.00,'499','2022-03-15 18:37:57','499','2022-03-15 18:38:21',10,0),('1','141',257636,'DAILY SHIFT','2022-03-15','2022-03-15 22:58:16','2022-03-16 22:58:16','499',0.00,0.00,'499','2022-03-15 23:02:31','499','2022-03-15 23:02:52',10,0),('1','141',257637,'DAILY SHIFT','2022-03-16','2022-03-16 08:16:50','2022-03-17 08:16:50','499',0.00,0.00,'499','2022-03-16 18:29:19','499','2022-03-16 18:29:44',10,0),('1','141',257638,'DAILY SHIFT','2022-03-17','2022-03-17 06:33:19','2022-03-18 06:33:19','499',0.00,0.00,'499','2022-03-17 18:47:07','499','2022-03-17 18:47:28',10,0),('1','141',257639,'DAILY SHIFT','2022-03-18','2022-03-18 08:19:54','2022-03-19 08:19:54','499',0.00,0.00,'499','2022-03-18 18:42:12','499','2022-03-18 18:42:40',10,0),('1','141',257640,'DAILY SHIFT','2022-03-19','2022-03-19 06:37:20','2022-03-20 06:37:20','499',0.00,0.00,'499','2022-03-19 17:35:43','499','2022-03-19 17:36:23',10,0),('1','141',257641,'DAILY SHIFT','2022-03-20','2022-03-20 07:52:09','2022-03-21 07:52:09','499',0.00,0.00,'499','2022-03-21 06:43:13','499','2022-03-21 06:43:48',10,0),('1','141',257642,'DAILY SHIFT','2022-03-21','2022-03-21 07:00:21','2022-03-22 07:00:21','499',0.00,0.00,'499','2022-03-21 07:07:16','499','2022-03-21 07:08:18',10,0),('1','141',257643,'DAILY SHIFT','2022-03-21','2022-03-21 07:12:51','2022-03-22 07:12:51','499',0.00,0.00,'499','2022-03-21 18:16:34','499','2022-03-21 18:17:03',10,0),('1','141',257644,'DAILY SHIFT','2022-03-22','2022-03-22 06:54:01','2022-03-23 06:54:01','499',0.00,0.00,'499','2022-03-22 20:54:17','499','2022-03-22 20:54:45',10,0),('1','141',257645,'DAILY SHIFT','2022-03-23','2022-03-23 13:43:30','2022-03-24 13:43:30','499',0.00,0.00,'499','2022-03-23 13:55:27','499','2022-03-23 13:56:26',10,0),('1','141',257646,'DAILY SHIFT','2022-03-23','2022-03-23 14:02:32','2022-03-24 14:02:32','499',0.00,0.00,'499','2022-03-23 18:57:47','499','2022-03-23 18:58:45',10,0),('1','141',257647,'DAILY SHIFT','2022-03-24','2022-03-24 07:14:29','2022-03-25 07:14:29','499',0.00,0.00,'499','2022-03-24 19:00:57','499','2022-03-24 19:01:50',10,0),('1','141',257648,'DAILY SHIFT','2022-03-25','2022-03-25 07:22:15','2022-03-26 07:22:15','499',0.00,0.00,'499','2022-03-25 18:24:46','499','2022-03-25 18:26:02',10,0),('1','141',257649,'DAILY SHIFT','2022-03-26','2022-03-26 08:06:25','2022-03-27 08:06:25','499',0.00,0.00,'499','2022-03-26 14:20:50','499','2022-03-26 14:21:17',10,0),('1','141',257650,'DAILY SHIFT','2022-03-27','2022-03-27 10:05:26','2022-03-28 10:05:26','499',0.00,0.00,'499','2022-03-27 10:23:32','499','2022-03-27 10:24:13',10,0),('1','141',257651,'DAILY SHIFT','2022-03-27','2022-03-27 10:28:24','2022-03-28 10:28:24','499',0.00,0.00,'499','2022-03-27 17:54:28','499','2022-03-27 17:55:14',10,0),('1','141',257652,'DAILY SHIFT','2022-03-28','2022-03-28 06:47:21','2022-03-29 06:47:21','499',0.00,0.00,'499','2022-03-28 18:33:31','499','2022-03-28 18:34:16',10,0),('1','141',257653,'DAILY SHIFT','2022-03-29','2022-03-29 07:35:43','2022-03-30 07:35:43','499',0.00,0.00,'499','2022-03-29 18:26:18','499','2022-03-29 18:26:40',10,0),('1','141',257654,'DAILY SHIFT ','2022-03-30','2022-03-30 07:34:59','2022-03-31 07:34:59','499',0.00,0.00,'499','2022-03-30 19:02:48','499','2022-03-30 19:03:12',10,0),('1','141',257655,'DAILY SHIFT','2022-03-30','2022-03-30 22:20:36','2022-03-31 22:20:36','499',0.00,0.00,'499','2022-03-30 22:26:32','499','2022-03-30 22:27:01',10,0),('1','141',257656,'DAILY SHIFT ','2022-03-31','2022-03-31 07:55:05','2022-04-01 07:55:05','499',0.00,0.00,'499','2022-03-31 19:01:08','499','2022-03-31 19:01:32',10,0),('1','141',257657,'DAILY SHIFT','2022-04-01','2022-04-01 08:26:33','2022-04-02 08:26:33','499',0.00,0.00,'499','2022-04-01 18:13:41','499','2022-04-01 18:14:19',10,0),('1','141',257658,'DAILY SHIFT','2022-04-02','2022-04-02 08:09:04','2022-04-03 08:09:04','499',0.00,0.00,'499','2022-04-02 17:43:24','499','2022-04-02 17:43:47',10,0),('1','141',257659,'DAILY SHIFT ','2022-04-03','2022-04-03 10:05:09','2022-04-04 10:05:09','499',0.00,0.00,'499','2022-04-03 17:30:02','499','2022-04-03 17:31:02',10,0),('1','141',257660,'DAILY SHIFT','2022-04-04','2022-04-04 06:54:36','2022-04-05 06:54:36','499',0.00,0.00,'499','2022-04-04 14:00:44','499','2022-04-04 14:22:16',10,0),('1','141',257661,'DAILY SHIFT','2022-04-05','2022-04-05 07:07:14','2022-04-06 07:07:14','499',0.00,0.00,'499','2022-04-05 07:10:58','499','2022-04-05 07:11:20',10,0),('1','141',257662,'DAILY SHIFT','2022-04-05','2022-04-05 07:16:56','2022-04-06 07:16:56','499',0.00,0.00,'499','2022-04-05 18:28:25','499','2022-04-05 18:29:13',10,0),('1','141',257663,'DAILY SHIFT','2022-04-06','2022-04-06 08:13:42','2022-04-07 08:13:42','499',0.00,0.00,'499','2022-04-06 18:09:33','499','2022-04-06 18:10:36',10,0),('1','141',257664,'DAILY SHIFT','2022-04-07','2022-04-07 07:02:35','2022-04-08 07:02:35','499',0.00,0.00,'499','2022-04-07 17:55:46','499','2022-04-07 17:56:18',10,0),('1','141',257665,'DAILY SHIFT','2022-04-08','2022-04-08 06:54:08','2022-04-09 06:54:08','499',0.00,0.00,'499','2022-04-08 14:27:05','499','2022-04-08 15:21:07',10,0),('1','141',257666,'DAILY SHIFT','2022-04-08','2022-04-08 21:10:45','2022-04-09 21:10:45','499',0.00,0.00,'499','2022-04-08 21:14:32','499','2022-04-08 21:15:07',10,0),('1','141',257667,'DAILY SHIFT','2022-04-08','2022-04-08 21:37:31','2022-04-09 21:37:31','499',0.00,0.00,'499','2022-04-08 21:54:25','499','2022-04-08 21:54:58',10,0),('1','141',257668,'DAILY SHIFT','2022-04-09','2022-04-09 08:11:09','2022-04-10 08:11:09','499',0.00,0.00,'499','2022-04-09 18:34:15','499','2022-04-09 18:37:11',10,0),('1','141',257669,'DAILY SHIFT','2022-04-10','2022-04-10 08:54:33','2022-04-11 08:54:33','499',0.00,0.00,'499','2022-04-10 17:54:14','499','2022-04-10 17:54:38',10,0),('1','141',257670,'DAILY SHIFT','2022-04-11','2022-04-11 06:35:40','2022-04-12 06:35:40','499',0.00,0.00,'499','2022-04-11 18:24:42','499','2022-04-11 18:25:18',10,0),('1','141',257671,'DAILY SHIFT','2022-04-12','2022-04-12 07:00:43','2022-04-13 07:00:43','499',0.00,0.00,'499','2022-04-12 13:04:11','499','2022-04-12 13:04:58',10,0),('1','141',257672,'DAILY SHIFT','2022-04-13','2022-04-13 08:54:53','2022-04-14 08:54:53','499',0.00,0.00,'499','2022-04-13 09:05:08','499','2022-04-13 09:05:32',10,0),('1','141',257673,'DAILY SHIFT','2022-04-13','2022-04-13 09:13:43','2022-04-14 09:13:43','499',0.00,0.00,'499','2022-04-13 18:32:35','499','2022-04-13 18:34:42',10,0),('1','141',257674,'DAILY SHIFT ','2022-04-14','2022-04-14 06:23:52','2022-04-15 06:23:52','499',0.00,0.00,'499','2022-04-14 18:30:13','499','2022-04-14 18:31:27',10,0),('1','141',257675,'DAILY SHIFT','2022-04-15','2022-04-15 06:10:05','2022-04-16 06:10:05','499',0.00,0.00,'499','2022-04-16 06:48:02','499','2022-04-16 06:51:13',10,0),('1','141',257676,'DAILY SHIFT','2022-04-17','2022-04-17 10:52:02','2022-04-18 10:52:02','499',0.00,0.00,'499','2022-04-17 11:35:30','499','2022-04-17 11:35:51',10,0),('1','141',257677,'DAILY SHIFT','2022-04-17','2022-04-17 11:39:50','2022-04-18 11:39:50','499',0.00,0.00,'499','2022-04-17 17:19:18','499','2022-04-17 18:36:06',10,0),('1','141',257678,'DAILY SHIFT','2022-04-18','2022-04-18 06:29:06','2022-04-19 06:29:06','499',0.00,0.00,'499','2022-04-18 18:15:18','499','2022-04-18 18:16:25',10,0),('1','141',257679,'DAILY SHIFT','2022-04-19','2022-04-19 06:29:43','2022-04-20 06:29:43','499',0.00,0.00,'499','2022-04-19 18:14:58','499','2022-04-19 18:15:29',10,0),('1','141',257680,'DAILY SHIFT','2022-04-20','2022-04-20 08:27:41','2022-04-21 08:27:41','499',0.00,0.00,'499','2022-04-20 17:19:37','499','2022-04-20 17:20:11',10,0),('1','141',257681,'DAILY SHIFT','2022-04-21','2022-04-21 06:27:15','2022-04-22 06:27:15','499',0.00,0.00,'499','2022-04-21 06:35:29','499','2022-04-21 06:35:51',10,0),('1','141',257682,'DAILY SHIFT','2022-04-21','2022-04-21 06:43:44','2022-04-22 06:43:44','499',0.00,0.00,'499','2022-04-21 18:08:03','499','2022-04-21 18:08:29',10,0),('1','141',257683,'DAILY SHIFT','2022-04-22','2022-04-22 06:20:37','2022-04-23 06:20:37','499',0.00,0.00,'499','2022-04-22 18:28:49','499','2022-04-22 18:39:43',10,0),('1','141',257684,'DAILY SHIFT','2022-04-23','2022-04-23 08:02:59','2022-04-24 08:02:59','499',0.00,0.00,'499','2022-04-23 17:56:57','499','2022-04-23 17:57:42',10,0),('1','141',257685,'DAILY SHIFT','2022-04-24','2022-04-24 04:21:27','2022-04-25 04:21:27','499',0.00,0.00,'499','2022-04-24 11:32:00','499','2022-04-24 11:32:24',10,0),('1','141',257686,'DAILY SHIFT','2022-04-24','2022-04-24 11:33:15','2022-04-25 11:33:15','499',0.00,0.00,'499','2022-04-24 17:27:18','499','2022-04-24 17:27:51',10,0),('1','141',257687,'DAILY SHIFT','2022-04-25','2022-04-25 07:53:59','2022-04-26 07:53:59','499',0.00,0.00,'499','2022-04-26 08:39:02','499','2022-04-26 08:39:24',10,0),('1','141',257688,'DAILY SHIFT','2022-04-26','2022-04-26 08:56:50','2022-04-27 08:56:50','499',0.00,0.00,'499','2022-04-26 14:42:25','499','2022-04-26 14:43:41',10,0),('1','141',257689,'DAILY SHIFT','2022-04-26','2022-04-26 14:44:33','2022-04-27 14:44:33','499',0.00,0.00,'499','2022-04-26 18:44:11','499','2022-04-26 18:44:39',10,0),('1','141',257690,'DAILY SHIFT','2022-04-27','2022-04-27 08:10:37','2022-04-28 08:10:37','499',0.00,0.00,'499','2022-04-27 18:27:11','499','2022-04-27 18:32:34',10,0),('1','141',257691,'DAILY SHIFT','2022-04-28','2022-04-28 08:29:10','2022-04-29 08:29:10','499',0.00,0.00,'499','2022-04-28 19:09:44','499','2022-04-28 19:12:25',10,0),('1','141',257692,'DAILY SHIFT ','2022-04-29','2022-04-29 07:25:24','2022-04-30 07:25:24','499',0.00,0.00,'499','2022-04-29 13:05:18','499','2022-04-29 13:06:15',10,0),('1','141',257693,'DAILY SHIFT','2022-04-29','2022-04-29 13:08:57','2022-04-30 13:08:57','499',0.00,0.00,'499','2022-04-30 10:21:18','499','2022-04-30 10:21:39',10,0),('1','141',257694,'DAILY SHIFT','2022-04-30','2022-04-30 10:49:00','2022-05-01 10:49:00','499',0.00,0.00,'499','2022-04-30 18:19:04','499','2022-04-30 18:20:25',10,0),('1','141',257695,'DAILY SHIFT','2022-05-01','2022-05-01 10:18:50','2022-05-02 10:18:50','499',0.00,0.00,'499','2022-05-01 18:23:04','499','2022-05-01 18:24:53',10,0),('1','141',257696,'DAILY SHIFT','2022-05-02','2022-05-02 09:40:07','2022-05-03 09:40:07','499',0.00,0.00,'499','2022-05-02 19:15:29','499','2022-05-02 19:15:59',10,0),('1','141',257697,'DAILY SHIFT','2022-05-03','2022-05-03 05:52:13','2022-05-04 05:52:13','499',0.00,0.00,'499','2022-05-03 12:27:07','499','2022-05-03 12:27:35',10,0),('1','141',257698,'DAILY SHIFT','2022-05-03','2022-05-03 12:45:15','2022-05-04 12:45:15','499',0.00,0.00,'499','2022-05-03 12:56:03','499','2022-05-03 12:56:25',10,0),('1','141',257699,'DAILY SHIFT','2022-05-03','2022-05-03 12:56:52','2022-05-04 12:56:52','499',0.00,0.00,'499','2022-05-03 19:06:31','499','2022-05-03 19:06:56',10,0),('1','141',257700,'DAILY SHIFT','2022-05-04','2022-05-04 07:03:56','2022-05-05 07:03:56','499',0.00,0.00,'499','2022-05-04 18:23:23','499','2022-05-04 18:26:48',10,0),('1','141',257701,'DAILY SHIFT','2022-05-05','2022-05-05 06:43:36','2022-05-06 06:43:36','499',0.00,0.00,'499','2022-05-06 05:41:13','499','2022-05-06 05:41:35',10,0),('1','141',257702,'DAILY SHIFT','2022-05-06','2022-05-06 05:58:21','2022-05-07 05:58:21','499',0.00,0.00,'499','2022-05-06 06:05:57','499','2022-05-06 06:06:20',10,0),('1','141',257703,'DAILY SHIFT','2022-05-06','2022-05-06 07:45:30','2022-05-07 07:45:30','499',0.00,0.00,'499','2022-05-06 18:10:05','499','2022-05-06 18:10:24',10,0),('1','141',257704,'DAILY SHIFT','2022-05-07','2022-05-07 07:59:10','2022-05-08 07:59:10','499',0.00,0.00,'499','2022-05-07 19:14:50','499','2022-05-07 19:15:48',10,0),('1','141',257705,'DAILY SHIFT X','2022-05-08','2022-05-08 09:51:36','2022-05-09 09:51:36','499',0.00,0.00,'499','2022-05-08 18:09:12','499','2022-05-08 18:09:32',10,0),('1','141',257706,'DAILY SHIFT ','2022-05-09','2022-05-09 08:03:54','2022-05-10 08:03:54','499',0.00,0.00,'499','2022-05-09 12:21:01','499','2022-05-09 12:21:49',10,0),('1','141',257707,'DAILY SHIFT','2022-05-09','2022-05-09 12:22:43','2022-05-10 12:22:43','499',0.00,0.00,'499','2022-05-09 12:29:49','499','2022-05-09 12:30:30',10,0),('1','141',257708,'DAILY SHIFT','2022-05-09','2022-05-09 12:38:11','2022-05-10 12:38:11','499',0.00,0.00,'499','2022-05-09 18:13:10','499','2022-05-09 18:16:03',10,0),('1','141',257709,'DAILY SHIFT','2022-05-10','2022-05-10 08:20:06','2022-05-11 08:20:06','499',0.00,0.00,'499','2022-05-11 05:54:18','499','2022-05-11 05:54:42',10,0),('1','141',257710,'DAILY SHIFT','2022-05-11','2022-05-11 08:06:48','2022-05-12 08:06:48','499',0.00,0.00,'499','2022-05-11 14:10:32','499','2022-05-11 14:11:06',10,0),('1','141',257711,'DAILY SHIFT','2022-05-12','2022-05-12 06:05:12','2022-05-13 06:05:12','499',0.00,0.00,'499','2022-05-12 06:29:10','499','2022-05-12 06:30:13',10,0),('1','141',257712,'DAILY SHIFT','2022-05-12','2022-05-12 08:34:04','2022-05-13 08:34:04','499',0.00,0.00,'499','2022-05-13 06:34:22','499','2022-05-13 06:34:43',10,0),('1','141',257713,'DAILY SHIFT','2022-05-13','2022-05-13 08:16:21','2022-05-14 08:16:21','499',0.00,0.00,'499','2022-05-13 17:07:39','499','2022-05-13 17:08:02',10,0),('1','141',257714,'DAILY SHIFT','2022-05-13','2022-05-13 18:20:13','2022-05-14 18:20:13','499',0.00,0.00,'499','2022-05-13 18:25:52','499','2022-05-13 18:26:18',10,0),('1','141',257715,'DAILY SHIFT','2022-05-15','2022-05-15 10:55:33','2022-05-16 10:55:33','499',0.00,0.00,'499','2022-05-16 06:13:35','499','2022-05-16 06:14:03',10,0),('1','141',257716,'DAILY SHIFT','2022-05-16','2022-05-16 06:26:12','2022-05-17 06:26:12','499',0.00,0.00,'499','2022-05-17 06:15:16','499','2022-05-17 06:15:46',10,0),('1','141',257717,'DAILY SHIFT','2022-05-17','2022-05-17 06:26:54','2022-05-18 06:26:54','499',0.00,0.00,'499','2022-05-17 14:56:17','499','2022-05-17 14:56:43',10,0),('1','141',257718,'DAILY SHIFT','2022-05-18','2022-05-18 07:58:15','2022-05-19 07:58:15','499',0.00,0.00,'499','2022-05-18 08:07:11','499','2022-05-18 08:07:45',10,0),('1','141',257719,'DAILY SHIFT','2022-05-18','2022-05-18 08:21:32','2022-05-19 08:21:32','499',0.00,0.00,'499','2022-05-19 07:30:20','499','2022-05-19 07:31:10',10,0),('1','141',257720,'DAILY SHIFT','2022-05-19','2022-05-19 08:02:31','2022-05-20 08:02:31','499',0.00,0.00,'499','2022-05-19 21:14:47','499','2022-05-19 21:18:58',10,0),('1','141',257721,'DAILY SHIFT','2022-05-20','2022-05-20 07:01:33','2022-05-21 07:01:33','499',0.00,0.00,'499','2022-05-20 18:33:14','499','2022-05-20 18:33:36',10,0),('1','141',257722,'DAILY SHIFT','2022-05-21','2022-05-21 07:55:06','2022-05-22 07:55:06','499',0.00,0.00,'499','2022-05-21 10:29:35','499','2022-05-21 10:30:18',10,0),('1','141',257723,'DAILY SHIFT','2022-05-23','2022-05-23 06:30:08','2022-05-24 06:30:08','499',0.00,0.00,'499','2022-05-24 08:18:39','499','2022-05-24 08:19:16',10,0),('1','141',257724,'DAILY SHIFT','2022-05-24','2022-05-24 08:19:41','2022-05-25 08:19:41','499',0.00,0.00,'499','2022-05-25 06:07:55','499','2022-05-25 06:08:22',10,0),('1','141',257725,'DAILY SHIFT','2022-05-25','2022-05-25 06:35:42','2022-05-26 06:35:42','499',0.00,0.00,'499','2022-05-26 06:06:31','499','2022-05-26 06:06:53',10,0),('1','141',257726,'DAILY SHIFT','2022-05-26','2022-05-26 06:15:51','2022-05-27 06:15:51','499',0.00,0.00,'499','2022-05-26 10:15:13','499','2022-05-26 10:15:34',10,0),('1','141',257727,'DAILY SHIFT','2022-05-28','2022-05-28 15:26:06','2022-05-29 15:26:06','499',0.00,0.00,'499','2022-05-28 15:32:36','499','2022-05-28 15:33:59',10,0),('1','141',257728,'DAILY SHIFT','2022-05-28','2022-05-28 15:41:06','2022-05-29 15:41:06','499',0.00,0.00,'499','2022-05-29 07:33:36','499','2022-05-29 07:33:56',10,0),('1','141',257729,'DAILY SHIFT','2022-05-29','2022-05-29 07:34:16','2022-05-30 07:34:16','499',0.00,0.00,'499','2022-05-30 06:09:08','499','2022-05-30 06:09:31',10,0),('1','141',257730,'DAILY SHIFT','2022-05-30','2022-05-30 06:17:42','2022-05-31 06:17:42','499',0.00,0.00,'499','2022-05-30 12:18:19','499','2022-05-30 12:19:03',10,0),('1','141',257731,'DAILY SHIFT','2022-05-30','2022-05-30 12:30:54','2022-05-31 12:30:54','499',0.00,0.00,'499','2022-05-30 12:36:52','499','2022-05-30 12:37:15',10,0),('1','141',257732,'DAILY SHIFT','2022-05-30','2022-05-30 12:45:50','2022-05-31 12:45:50','499',0.00,0.00,'499','2022-05-31 07:25:37','499','2022-05-31 07:26:13',10,0),('1','141',257733,'DAILY SHIFT','2022-05-31','2022-05-31 08:07:06','2022-06-01 08:07:06','499',0.00,0.00,'499','2022-06-01 06:34:19','499','2022-06-01 06:34:44',10,0),('1','141',257734,'DAILY SHIFT','2022-06-01','2022-06-01 06:44:00','2022-06-02 06:44:00','499',0.00,0.00,'499','2022-06-01 13:14:29','499','2022-06-01 13:14:48',10,0),('1','141',257735,'DAILY SHIFT','2022-06-01','2022-06-01 18:32:22','2022-06-02 18:32:22','499',0.00,0.00,'499','2022-06-01 18:42:47','499','2022-06-01 18:43:26',10,0),('1','141',257736,'DAILY SHIFT','2022-06-02','2022-06-02 08:05:18','2022-06-03 08:05:18','499',0.00,0.00,'499','2022-06-03 06:03:52','499','2022-06-03 06:04:19',10,0),('1','141',257737,'DAILY SHIFT','2022-06-03','2022-06-03 06:16:47','2022-06-04 06:16:47','499',0.00,0.00,'499','2022-06-03 17:44:20','499','2022-06-03 17:44:41',10,0),('1','141',257738,'DAILY SHIFT','2022-06-04','2022-06-04 06:14:07','2022-06-05 06:14:07','499',0.00,0.00,'499','2022-06-04 17:42:15','499','2022-06-04 17:42:33',10,0),('1','141',257739,'DAILY SHIFT','2022-06-05','2022-06-05 10:00:23','2022-06-06 10:00:23','499',0.00,0.00,'499','2022-06-06 06:16:13','499','2022-06-06 06:16:35',10,0),('1','141',257740,'DAILY SHIFT','2022-06-06','2022-06-06 08:05:45','2022-06-07 08:05:45','499',0.00,0.00,'499','2022-06-06 09:04:53','499','2022-06-06 09:05:15',10,0),('1','141',257741,'DAILY SHIFT','2022-06-06','2022-06-06 09:10:14','2022-06-07 09:10:14','499',0.00,0.00,'499','2022-06-06 09:16:26','499','2022-06-06 09:16:46',10,0),('1','141',257742,'DAILY SHIFT','2022-06-06','2022-06-06 09:22:19','2022-06-07 09:22:19','499',0.00,0.00,'499','2022-06-07 05:46:17','499','2022-06-07 05:46:54',10,0),('1','141',257743,'DAILY SHIFT','2022-06-07','2022-06-07 08:06:11','2022-06-08 08:06:11','499',0.00,0.00,'499','2022-06-08 06:12:03','499','2022-06-08 06:12:37',10,0),('1','141',257744,'DAILY SHIFT','2022-06-08','2022-06-08 07:57:01','2022-06-09 07:57:01','499',0.00,0.00,'499','2022-06-12 08:16:28','499','2022-06-12 08:16:54',10,0),('1','141',257745,'DAILY SHIFT','2022-06-12','2022-06-12 08:17:22','2022-06-13 08:17:22','499',0.00,0.00,'499','2022-06-12 19:49:07','499','2022-06-12 19:52:21',10,0),('1','141',257746,'DAILY SHIFT','2022-06-12','2022-06-12 20:00:48','2022-06-13 20:00:48','499',0.00,0.00,'499','2022-06-13 07:41:14','499','2022-06-13 07:41:36',10,0),('1','141',257747,'DAILY SHIFT','2022-06-13','2022-06-13 07:42:03','2022-06-14 07:42:03','499',0.00,0.00,'499','2022-06-13 18:10:24','499','2022-06-13 18:10:47',10,0),('1','141',257748,'DAILY SHIFT','2022-06-14','2022-06-14 08:07:24','2022-06-15 08:07:24','499',0.00,0.00,'499','2022-06-14 19:33:21','499','2022-06-14 19:33:54',10,0),('1','141',257749,'DAILY SHIFT','2022-06-15','2022-06-15 08:11:53','2022-06-16 08:11:53','499',0.00,0.00,'499','2022-06-15 20:43:02','499','2022-06-15 20:43:26',10,0),('1','141',257750,'DAILY SHIFT','2022-06-15','2022-06-15 20:59:18','2022-06-16 20:59:18','499',0.00,0.00,'499','2022-06-16 06:59:56','499','2022-06-16 07:00:45',10,0),('1','141',257751,'DAILY SHIFT','2022-06-16','2022-06-16 07:03:57','2022-06-17 07:03:57','499',0.00,0.00,'499','2022-06-16 19:35:09','499','2022-06-16 19:35:31',10,0),('1','141',257752,'DAILY SHIFT','2022-06-17','2022-06-17 08:18:30','2022-06-18 08:18:30','499',0.00,0.00,'499','2022-06-17 17:57:59','499','2022-06-17 17:58:30',10,0),('1','141',257753,'DAILY SHIFT','2022-06-18','2022-06-18 08:05:54','2022-06-19 08:05:54','499',0.00,0.00,'499','2022-06-18 18:03:58','499','2022-06-18 18:04:28',10,0),('1','141',257754,'DAILY SHIFT','2022-06-19','2022-06-19 09:56:05','2022-06-20 09:56:05','499',0.00,0.00,'499','2022-06-19 19:36:43','499','2022-06-19 19:37:07',10,0),('1','141',257755,'DAILY SHIFT','2022-06-20','2022-06-20 08:11:51','2022-06-21 08:11:51','499',0.00,0.00,'499','2022-06-20 12:32:35','499','2022-06-20 12:33:16',10,0),('1','141',257756,'DAILY SHIFT','2022-06-20','2022-06-20 20:27:24','2022-06-21 20:27:24','499',0.00,0.00,'499','2022-06-20 20:32:45','499','2022-06-20 20:33:19',10,0),('1','141',257757,'DAILY SHIFT','2022-06-21','2022-06-21 08:33:17','2022-06-22 08:33:17','499',0.00,0.00,'499','2022-06-21 20:05:00','499','2022-06-21 20:05:24',10,0),('1','141',257758,'DAILY SHIFT','2022-06-22','2022-06-22 07:53:57','2022-06-23 07:53:57','499',0.00,0.00,'499','2022-06-22 21:56:44','499','2022-06-22 21:57:30',10,0),('1','141',257759,'DAILY SHIFT','2022-06-23','2022-06-23 07:09:30','2022-06-24 07:09:30','499',0.00,0.00,'499','2022-06-23 16:41:14','499','2022-06-23 16:41:54',10,0),('1','141',257760,'DAILY SHIFT','2022-06-23','2022-06-23 16:42:45','2022-06-24 16:42:45','499',0.00,0.00,'499','2022-06-23 16:56:25','499','2022-06-23 16:56:42',10,0),('1','141',257761,'DAILY SHIFT','2022-06-23','2022-06-23 16:59:53','2022-06-24 16:59:53','499',0.00,0.00,'499','2022-06-23 23:57:09','499','2022-06-23 23:57:37',10,0),('1','141',257762,'DAILY SHIFT','2022-06-24','2022-06-24 07:07:32','2022-06-25 07:07:32','499',0.00,0.00,'499','2022-06-24 19:01:03','499','2022-06-24 19:01:54',10,0),('1','141',257763,'DAILY SHIFT','2022-06-25','2022-06-25 08:07:39','2022-06-26 08:07:39','499',0.00,0.00,'499','2022-06-25 22:10:29','499','2022-06-25 22:11:08',10,0),('1','141',257764,'DAILY SHIFT','2022-06-26','2022-06-26 10:02:35','2022-06-27 10:02:35','499',0.00,0.00,'499','2022-06-26 19:18:31','499','2022-06-26 19:19:08',10,0),('1','141',257765,'DAILY SHIFT','2022-06-27','2022-06-27 07:45:06','2022-06-28 07:45:06','499',0.00,0.00,'499','2022-06-27 22:38:36','499','2022-06-27 22:38:56',10,0),('1','141',257766,'DAILY SHIFT','2022-06-28','2022-06-28 07:18:44','2022-06-29 07:18:44','499',0.00,0.00,'499','2022-06-28 13:16:40','499','2022-06-28 13:17:02',10,0),('1','141',257767,'DAILY SHIFT','2022-06-28','2022-06-28 13:23:23','2022-06-29 13:23:23','499',0.00,0.00,'499','2022-06-28 13:38:50','499','2022-06-28 13:39:12',10,0),('1','141',257768,'DAILY SHIFT','2022-06-28','2022-06-28 13:40:11','2022-06-29 13:40:11','499',0.00,0.00,'499','2022-06-28 20:59:18','499','2022-06-28 20:59:42',10,0),('1','141',257769,'DAILY SHIFT','2022-06-29','2022-06-29 07:23:55','2022-06-30 07:23:55','499',0.00,0.00,'499','2022-06-29 21:04:15','499','2022-06-29 21:04:54',10,0),('1','141',257770,'DAILY SHIFT','2022-06-30','2022-06-30 07:31:19','2022-07-01 07:31:19','499',0.00,0.00,'499','2022-06-30 21:35:44','499','2022-06-30 21:36:08',10,0),('1','141',257771,'DAILY SHIFT','2022-07-01','2022-07-01 07:31:49','2022-07-02 07:31:49','499',0.00,0.00,'499','2022-07-01 12:43:27','499','2022-07-01 12:45:37',10,0),('1','141',257772,'DAILY SHIFT','2022-07-01','2022-07-01 13:54:55','2022-07-02 13:54:55','499',0.00,0.00,'499','2022-07-01 14:49:11','499','2022-07-01 14:50:19',10,0),('1','141',257773,'DAILY SHIFT ','2022-07-01','2022-07-01 14:51:18','2022-07-02 14:51:18','499',0.00,0.00,'499','2022-07-01 22:17:39','499','2022-07-01 22:18:05',10,0),('1','141',257774,'DAILY SHIFT','2022-07-02','2022-07-02 08:09:27','2022-07-03 08:09:27','499',0.00,0.00,'499','2022-07-02 21:36:24','499','2022-07-02 21:36:53',10,0),('1','141',257775,'DAILY SHIFT','2022-07-03','2022-07-03 10:01:41','2022-07-04 10:01:41','499',0.00,0.00,'499','2022-07-03 21:15:03','499','2022-07-03 21:15:40',10,0),('1','141',257776,'DAILY SHIFT','2022-07-04','2022-07-04 07:28:20','2022-07-05 07:28:20','499',0.00,0.00,'499','2022-07-04 19:44:15','499','2022-07-04 19:44:53',10,0),('1','141',257777,'DAILY SHIFT','2022-07-05','2022-07-05 09:44:34','2022-07-06 09:44:34','499',0.00,0.00,'499','2022-07-05 11:21:54','499','2022-07-05 11:24:03',10,0),('1','141',257778,'DAILY SHIFT','2022-07-07','2022-07-07 10:00:34','2022-07-08 10:00:34','499',0.00,0.00,'499','2022-07-07 21:47:17','499','2022-07-07 21:47:37',10,0),('1','141',257779,'DAILY SHIFT','2022-07-08','2022-07-08 07:09:56','2022-07-09 07:09:56','499',0.00,0.00,'499','2022-07-08 18:47:48','499','2022-07-08 18:50:22',10,0),('1','141',257780,'DAILY SHIFT ','2022-07-09','2022-07-09 10:58:48','2022-07-10 10:58:48','499',0.00,0.00,'499','2022-07-09 20:11:08','499','2022-07-09 20:11:37',10,0),('1','141',257781,'DAILY SHIFT','2022-07-10','2022-07-10 10:07:31','2022-07-11 10:07:31','499',0.00,0.00,'499','2022-07-10 19:44:27','499','2022-07-10 19:45:01',10,0),('1','141',257782,'DAILY SHIFT','2022-07-11','2022-07-11 07:11:00','2022-07-12 07:11:00','499',0.00,0.00,'499','2022-07-11 19:44:21','499','2022-07-11 19:44:41',10,0),('1','141',257783,'DAILY SHIFT ','2022-07-12','2022-07-12 05:37:30','2022-07-13 05:37:30','499',0.00,0.00,'499','2022-07-12 06:59:35','499','2022-07-12 07:00:09',10,0),('1','141',257784,'DAILY SHIFT','2022-07-12','2022-07-12 07:01:30','2022-07-13 07:01:30','499',0.00,0.00,'499','2022-07-12 21:52:08','499','2022-07-12 21:52:38',10,0),('1','141',257785,'DAILY SHIFT','2022-07-13','2022-07-13 07:16:23','2022-07-14 07:16:23','499',0.00,0.00,'499','2022-07-13 21:41:08','499','2022-07-13 21:41:48',10,0),('1','141',257786,'DAILY SHIFT','2022-07-14','2022-07-14 07:22:51','2022-07-15 07:22:51','499',0.00,0.00,'499','2022-07-14 22:07:52','499','2022-07-14 22:09:18',10,0),('1','141',257787,'DAILY SHIFT','2022-07-15','2022-07-15 07:26:50','2022-07-16 07:26:50','499',0.00,0.00,'499','2022-07-15 09:44:19','499','2022-07-15 09:44:57',10,0),('1','141',257788,'DAILY SHIFT ','2022-07-15','2022-07-15 09:45:51','2022-07-16 09:45:51','499',0.00,0.00,'499','2022-07-15 09:55:03','499','2022-07-15 09:55:30',10,0),('1','141',257789,'DAILY SHIFT ','2022-07-15','2022-07-15 09:56:03','2022-07-16 09:56:03','499',0.00,0.00,'499','2022-07-15 21:18:43','499','2022-07-15 21:19:08',10,0),('1','141',257790,'DAILY SHIFT','2022-07-16','2022-07-16 07:21:09','2022-07-17 07:21:09','499',0.00,0.00,'499','2022-07-16 18:40:08','499','2022-07-16 18:40:45',10,0),('1','141',257791,'DAILY SHIFT','2022-07-17','2022-07-17 10:00:01','2022-07-18 10:00:01','499',0.00,0.00,'499','2022-07-17 20:54:52','499','2022-07-17 20:55:11',10,0),('1','141',257792,'DAILY SHIFT','2022-07-18','2022-07-18 07:25:13','2022-07-19 07:25:13','499',0.00,0.00,'499','2022-07-18 10:18:09','499','2022-07-18 10:18:33',10,0),('1','141',257793,'DAILY SHIFT','2022-07-18','2022-07-18 10:19:07','2022-07-19 10:19:07','499',0.00,0.00,'499','2022-07-18 10:25:33','499','2022-07-18 10:25:52',10,0),('1','141',257794,'DAILY SHIFT','2022-07-18','2022-07-18 10:26:49','2022-07-19 10:26:49','499',0.00,0.00,'499','2022-07-18 20:46:55','499','2022-07-18 20:47:18',10,0),('1','141',257795,'DAILY SHIFT','2022-07-19','2022-07-19 07:05:39','2022-07-20 07:05:39','499',0.00,0.00,'499','2022-07-20 06:07:44','499','2022-07-20 06:08:07',10,0),('1','141',257796,'DAILY SHIFT','2022-07-20','2022-07-20 07:12:12','2022-07-21 07:12:12','499',0.00,0.00,'499','2022-07-20 10:49:50','499','2022-07-20 10:50:30',10,0),('1','141',257797,'DAILY SHIFT','2022-07-20','2022-07-20 10:54:34','2022-07-21 10:54:34','499',0.00,0.00,'499','2022-07-20 11:01:53','499','2022-07-20 11:02:28',10,0),('1','141',257798,'DAILY SHIFT','2022-07-20','2022-07-20 11:30:51','2022-07-21 11:30:51','499',0.00,0.00,'499','2022-07-20 21:33:55','499','2022-07-20 21:34:34',10,0),('1','141',257799,'DAILY SHIFT','2022-07-21','2022-07-21 07:21:48','2022-07-22 07:21:48','499',0.00,0.00,'499','2022-07-21 22:09:58','499','2022-07-21 22:10:21',10,0),('1','141',257800,'DAILY SHIFT','2022-07-22','2022-07-22 07:20:24','2022-07-23 07:20:24','499',0.00,0.00,'499','2022-07-22 10:09:06','499','2022-07-22 10:09:52',10,0),('1','141',257801,'DAILY SHIFT','2022-07-22','2022-07-22 10:11:29','2022-07-23 10:11:29','499',0.00,0.00,'499','2022-07-22 10:25:14','499','2022-07-22 10:27:40',10,0),('1','141',257802,'DAILY SHIFT','2022-07-22','2022-07-22 10:36:48','2022-07-23 10:36:48','499',0.00,0.00,'499','2022-07-22 19:00:32','499','2022-07-22 19:04:03',10,0),('1','141',257803,'DAILY SHIFT','2022-07-23','2022-07-23 07:34:52','2022-07-24 07:34:52','499',0.00,0.00,'499','2022-07-23 18:57:06','499','2022-07-23 18:57:40',10,0),('1','141',257804,'DAILY SHIFT','2022-07-24','2022-07-24 10:22:35','2022-07-25 10:22:35','499',0.00,0.00,'499','2022-07-25 02:39:03','499','2022-07-25 02:39:34',10,0),('1','141',257805,'DAILY SHIFT','2022-07-25','2022-07-25 02:49:55','2022-07-26 02:49:55','499',0.00,0.00,'499','2022-07-25 02:55:16','499','2022-07-25 02:55:39',10,0),('1','141',257806,'DAILY SHIFT','2022-07-25','2022-07-25 07:18:18','2022-07-26 07:18:18','499',0.00,0.00,'499','2022-07-25 17:49:37','499','2022-07-25 17:50:05',10,0),('1','141',257807,'DAILY SHIFT','2022-07-26','2022-07-26 07:21:09','2022-07-27 07:21:09','499',0.00,0.00,'499','2022-07-26 18:16:39','499','2022-07-26 18:17:31',10,0),('1','141',257808,'DAILY SHIFT','2022-07-27','2022-07-27 07:26:53','2022-07-28 07:26:53','499',0.00,0.00,'499','2022-07-27 10:24:59','499','2022-07-27 10:25:30',10,0),('1','141',257809,'DAILY SHIFT','2022-07-27','2022-07-27 10:25:56','2022-07-28 10:25:56','499',0.00,0.00,'499','2022-07-27 10:34:45','499','2022-07-27 10:35:14',10,0),('1','141',257810,'DAILY SHIFT','2022-07-27','2022-07-27 10:39:27','2022-07-28 10:39:27','499',0.00,0.00,'499','2022-07-27 17:47:37','499','2022-07-27 17:49:07',10,0),('1','141',257811,'DAILY SHIFT','2022-07-28','2022-07-28 07:15:01','2022-07-29 07:15:01','499',0.00,0.00,'499','2022-07-28 16:45:29','499','2022-07-28 16:46:43',10,0),('1','141',257812,'DAILY SHIFT ','2022-07-30','2022-07-30 02:33:43','2022-07-31 02:33:43','499',0.00,0.00,'499','2022-07-30 02:38:23','499','2022-07-30 02:39:02',10,0),('1','141',257813,'DAILY SHIFT','2022-07-30','2022-07-30 07:28:06','2022-07-31 07:28:06','499',0.00,0.00,'499','2022-07-30 18:31:50','499','2022-07-30 18:32:21',10,0),('1','141',257814,'DAILY SHIFT','2022-07-31','2022-07-31 06:42:35','2022-08-01 06:42:35','499',0.00,0.00,'499','2022-07-31 09:51:07','499','2022-07-31 09:52:08',10,0),('1','141',257815,'DAILY SHIFT','2022-07-31','2022-07-31 09:52:49','2022-08-01 09:52:49','499',0.00,0.00,'499','2022-07-31 21:12:56','499','2022-07-31 21:13:36',10,0),('1','141',257816,'DAILY SHIFT','2022-08-01','2022-08-01 07:29:03','2022-08-02 07:29:03','499',0.00,0.00,'499','2022-08-01 07:32:03','499','2022-08-01 07:32:22',10,0),('1','141',257817,'DAILY SHIFT','2022-08-01','2022-08-01 07:39:10','2022-08-02 07:39:10','499',0.00,0.00,'499','2022-08-01 18:55:51','499','2022-08-01 18:56:25',10,0),('1','141',257818,'DAILY SHIFT','2022-08-02','2022-08-02 07:37:47','2022-08-03 07:37:47','499',0.00,0.00,'499','2022-08-02 12:46:51','499','2022-08-02 12:47:11',10,0),('1','141',257819,'DAILY SHIFT ','2022-08-05','2022-08-05 05:58:30','2022-08-06 05:58:30','499',0.00,0.00,'499','2022-08-05 07:05:50','499','2022-08-05 07:06:11',10,0),('1','141',257820,'DAILY SHIFT','2022-08-05','2022-08-05 07:06:35','2022-08-06 07:06:35','499',0.00,0.00,'499','2022-08-05 19:52:29','499','2022-08-05 19:52:54',10,0),('1','141',257821,'DAILY SHIFT ','2022-08-06','2022-08-06 06:33:04','2022-08-07 06:33:04','499',0.00,0.00,'499','2022-08-06 15:28:03','499','2022-08-06 15:28:37',10,0),('1','141',257822,'DAILY SHIFT','2022-08-09','2022-08-09 10:26:29','2022-08-10 10:26:29','499',0.00,0.00,'499','2022-08-09 10:29:52','499','2022-08-09 10:30:19',10,0),('1','141',257823,'DAILY SHIFT','2022-08-09','2022-08-09 12:14:33','2022-08-10 12:14:33','499',0.00,0.00,'499','2022-08-10 05:49:03','499','2022-08-10 05:49:26',10,0),('1','141',257824,'DAILY SHIFT','2022-08-10','2022-08-10 07:21:37','2022-08-11 07:21:37','499',0.00,0.00,'499','2022-08-10 18:02:32','499','2022-08-10 18:03:39',10,0),('1','141',257825,'DAILY SHIFT','2022-08-11','2022-08-11 07:28:12','2022-08-12 07:28:12','499',0.00,0.00,'499','2022-08-11 20:50:36','499','2022-08-11 20:51:14',10,0),('1','141',257826,'DAILY SHIFT','2022-08-12','2022-08-12 07:27:04','2022-08-13 07:27:04','499',0.00,0.00,'499','2022-08-12 07:34:47','499','2022-08-12 07:35:07',10,0),('1','141',257827,'DAILY SHIFT','2022-08-12','2022-08-12 07:35:31','2022-08-13 07:35:31','499',0.00,0.00,'499','2022-08-12 18:07:21','499','2022-08-12 18:08:20',10,0),('1','141',257828,'DAILY SHIFT ','2022-08-13','2022-08-13 07:03:16','2022-08-14 07:03:16','499',0.00,0.00,'499','2022-08-13 22:08:09','499','2022-08-13 22:08:33',10,0),('1','141',257829,'DAILY SHIFT ','2022-08-14','2022-08-14 09:59:55','2022-08-15 09:59:55','499',0.00,0.00,'499','2022-08-14 19:00:04','499','2022-08-14 19:00:38',10,0),('1','141',257830,'DAILY SHIFT','2022-08-15','2022-08-15 08:01:00','2022-08-16 08:01:00','499',0.00,0.00,'499','2022-08-15 08:09:17','499','2022-08-15 08:09:42',10,0),('1','141',257831,'DAILY SHIFT','2022-08-15','2022-08-15 08:13:34','2022-08-16 08:13:34','499',0.00,0.00,'499','2022-08-15 18:25:17','499','2022-08-15 18:25:49',10,0),('1','141',257832,'DAILY SHIFT','2022-08-16','2022-08-16 07:17:36','2022-08-17 07:17:36','499',0.00,0.00,'499','2022-08-16 17:00:44','499','2022-08-16 17:01:43',10,0),('1','141',257833,'DAILY SHIFT','2022-08-17','2022-08-17 09:15:35','2022-08-18 09:15:35','499',0.00,0.00,'499','2022-08-17 09:25:12','499','2022-08-17 09:25:33',10,0),('1','141',257834,'DAILY SHIFT','2022-08-17','2022-08-17 09:29:44','2022-08-18 09:29:44','499',0.00,0.00,'499','2022-08-17 18:49:52','499','2022-08-17 18:50:53',10,0),('1','141',257835,'DAILY SHIFT','2022-08-18','2022-08-18 07:13:46','2022-08-19 07:13:46','499',0.00,0.00,'499','2022-08-18 20:59:22','499','2022-08-18 20:59:52',10,0),('1','141',257836,'DAILY SHIFT ','2022-08-20','2022-08-20 06:41:23','2022-08-21 06:41:23','499',0.00,0.00,'499','2022-08-20 06:45:47','499','2022-08-20 06:46:10',10,0),('1','141',257837,'DAILY SHIFT ','2022-08-20','2022-08-20 06:54:57','2022-08-21 06:54:57','499',0.00,0.00,'499','2022-08-21 10:42:44','499','2022-08-21 10:43:12',10,0),('1','141',257838,'DAILY SHIFT','2022-08-21','2022-08-21 10:43:39','2022-08-22 10:43:39','499',0.00,0.00,'499','2022-08-21 18:19:11','499','2022-08-21 18:19:42',10,0),('1','141',257839,'DAILY SHIFT ','2022-08-22','2022-08-22 08:05:34','2022-08-23 08:05:34','499',0.00,0.00,'499','2022-08-22 08:10:01','499','2022-08-22 08:10:20',10,0),('1','141',257840,'DAILY SHIFT','2022-08-23','2022-08-23 13:59:09','2022-08-24 13:59:09','499',0.00,0.00,'499','2022-08-23 14:05:08','499','2022-08-23 14:05:29',10,0),('1','141',257841,'DAILY SHIFT','2022-08-23','2022-08-23 14:19:38','2022-08-24 14:19:38','499',0.00,0.00,'499','2022-08-23 19:52:50','499','2022-08-23 19:53:17',10,0),('1','141',257842,'DAILY SHIFT ','2022-08-24','2022-08-24 07:01:06','2022-08-25 07:01:06','499',0.00,0.00,'499','2022-08-24 18:50:24','499','2022-08-24 18:50:46',10,0),('1','141',257843,'DAILY SHIFT ','2022-08-25','2022-08-25 07:08:59','2022-08-26 07:08:59','499',0.00,0.00,'499','2022-08-25 17:58:25','499','2022-08-25 17:58:45',10,0),('1','141',257844,'DAILY SHIFT ','2022-08-26','2022-08-26 07:01:37','2022-08-27 07:01:37','499',0.00,0.00,'499','2022-08-26 12:27:47','499','2022-08-26 12:28:13',10,0),('1','141',257845,'DAILY SHIFT','2022-08-26','2022-08-26 12:30:25','2022-08-27 12:30:25','499',0.00,0.00,'499','2022-08-26 12:33:00','499','2022-08-26 12:33:18',10,0),('1','141',257846,'DAILY SHIFT','2022-08-26','2022-08-26 12:39:47','2022-08-27 12:39:47','499',0.00,0.00,'499','2022-08-26 18:01:34','499','2022-08-26 18:02:18',10,0),('1','141',257847,'DAILY SHIFT','2022-08-27','2022-08-27 06:58:14','2022-08-28 06:58:14','499',0.00,0.00,'499','2022-08-27 18:02:28','499','2022-08-27 18:03:01',10,0),('1','141',257848,'DAILY SHIFT','2022-08-28','2022-08-28 10:17:51','2022-08-29 10:17:51','499',0.00,0.00,'499','2022-08-28 19:42:58','499','2022-08-28 19:43:21',10,0),('1','141',257849,'DAILY SHIFT','2022-08-29','2022-08-29 07:14:33','2022-08-30 07:14:33','499',0.00,0.00,'499','2022-08-29 14:02:55','499','2022-08-29 14:03:29',10,0),('1','141',257850,'DAILY SHIFT','2022-08-29','2022-08-29 14:04:15','2022-08-30 14:04:15','499',0.00,0.00,'499','2022-08-29 14:53:10','499','2022-08-29 14:53:29',10,0),('1','141',257851,'DAILY SHIFT','2022-08-29','2022-08-29 14:57:35','2022-08-30 14:57:35','499',0.00,0.00,'499','2022-08-29 18:26:22','499','2022-08-29 18:26:47',10,0),('1','141',257852,'DAILY SHIFT ','2022-08-30','2022-08-30 06:44:31','2022-08-31 06:44:31','499',0.00,0.00,'499','2022-08-30 18:01:03','499','2022-08-30 18:01:26',10,0),('1','141',257853,'DAILY SHIFT','2022-08-31','2022-08-31 07:19:51','2022-09-01 07:19:51','499',0.00,0.00,'499','2022-08-31 18:09:09','499','2022-08-31 18:09:30',10,0),('1','141',257854,'DAILY SHIFT ','2022-09-01','2022-09-01 07:16:46','2022-09-02 07:16:46','499',0.00,0.00,'499','2022-09-01 11:22:12','499','2022-09-01 11:22:37',10,0),('1','141',257855,'DAILY SHIFT','2022-09-01','2022-09-01 11:29:38','2022-09-02 11:29:38','499',0.00,0.00,'499','2022-09-01 11:32:29','499','2022-09-01 11:32:48',10,0),('1','141',257856,'DAILY SHIFT','2022-09-01','2022-09-01 11:51:57','2022-09-02 11:51:57','499',0.00,0.00,'499','2022-09-01 17:59:09','499','2022-09-01 17:59:27',10,0),('1','141',257857,'DAILY SHIFT','2022-09-02','2022-09-02 06:45:04','2022-09-03 06:45:04','499',0.00,0.00,'499','2022-09-02 18:07:02','499','2022-09-02 18:07:22',10,0),('1','141',257858,'DAILY SHIFT ','2022-09-03','2022-09-03 06:53:53','2022-09-04 06:53:53','499',0.00,0.00,'499','2022-09-03 18:27:04','499','2022-09-03 18:27:29',10,0),('1','141',257859,'DAILY SHIFT','2022-09-04','2022-09-04 10:17:50','2022-09-05 10:17:50','499',0.00,0.00,'499','2022-09-04 10:23:45','499','2022-09-04 10:24:29',10,0),('1','141',257860,'DAILY SHIFT','2022-09-04','2022-09-04 10:30:24','2022-09-05 10:30:24','499',0.00,0.00,'499','2022-09-04 22:37:03','499','2022-09-04 22:44:39',10,0),('1','141',257861,'DAILY SHIFT','2022-09-05','2022-09-05 07:16:11','2022-09-06 07:16:11','499',0.00,0.00,'499','2022-09-05 22:02:41','499','2022-09-05 22:03:20',10,0),('1','141',257862,'DAILY SHIFT ','2022-09-06','2022-09-06 07:01:25','2022-09-07 07:01:25','499',0.00,0.00,'499','2022-09-06 20:44:17','499','2022-09-06 20:44:43',10,0),('1','141',257863,'DAILY SHIFT','2022-09-07','2022-09-07 10:36:53','2022-09-08 10:36:53','499',0.00,0.00,'499','2022-09-07 10:42:19','499','2022-09-07 10:42:42',10,0),('1','141',257864,'DAILY SHIFT','2022-09-07','2022-09-07 11:02:11','2022-09-08 11:02:11','499',0.00,0.00,'499','2022-09-07 21:29:33','499','2022-09-07 21:30:24',10,0),('1','141',257865,'DAILY SHIFT','2022-09-08','2022-09-08 07:10:17','2022-09-09 07:10:17','499',0.00,0.00,'499','2022-09-08 21:30:20','499','2022-09-08 21:30:59',10,0),('1','141',257866,'DAILY SHIFT ','2022-09-09','2022-09-09 07:06:11','2022-09-10 07:06:11','499',0.00,0.00,'499','2022-09-09 13:50:43','499','2022-09-09 13:51:08',10,0),('1','141',257867,'DAILY SHIFT','2022-09-09','2022-09-09 14:06:53','2022-09-10 14:06:53','499',0.00,0.00,'499','2022-09-09 14:14:59','499','2022-09-09 14:15:21',10,0),('1','141',257868,'DAILY SHIFT','2022-09-09','2022-09-09 14:15:48','2022-09-10 14:15:48','499',0.00,0.00,'499','2022-09-09 21:16:16','499','2022-09-09 21:16:51',10,0),('1','141',257869,'DAILY SHIFT','2022-09-10','2022-09-10 07:07:28','2022-09-11 07:07:28','499',0.00,0.00,'499','2022-09-11 07:13:11','499','2022-09-11 07:13:40',10,0),('1','141',257870,'DAILY SHIFT ','2022-09-11','2022-09-11 10:05:50','2022-09-12 10:05:50','499',0.00,0.00,'499','2022-09-11 21:04:52','499','2022-09-11 21:05:15',10,0),('1','141',257871,'DAILY SHIFT ','2022-09-12','2022-09-12 06:54:21','2022-09-13 06:54:21','499',0.00,0.00,'499','2022-09-12 15:28:58','499','2022-09-12 15:29:23',10,0),('1','141',257872,'DAILY SHIFT','2022-09-12','2022-09-12 15:58:04','2022-09-13 15:58:04','499',0.00,0.00,'499','2022-09-12 16:00:24','499','2022-09-12 16:00:44',10,0),('1','141',257873,'DAILY SHIFT','2022-09-12','2022-09-12 16:05:50','2022-09-13 16:05:50','499',0.00,0.00,'499','2022-09-13 05:14:05','499','2022-09-13 05:14:34',10,0),('1','141',257874,'DAILY SHIFT ','2022-09-13','2022-09-13 07:03:56','2022-09-14 07:03:56','499',0.00,0.00,'499','2022-09-14 06:10:39','499','2022-09-14 06:11:17',10,0),('1','141',257875,'DAILY SHIFT','2022-09-14','2022-09-14 07:00:42','2022-09-15 07:00:42','499',0.00,0.00,'499','2022-09-14 20:37:29','499','2022-09-14 20:37:55',10,0),('1','141',257876,'DAILY SHIFT ','2022-09-15','2022-09-15 07:02:25','2022-09-16 07:02:25','499',0.00,0.00,'499','2022-09-15 11:35:05','499','2022-09-15 11:35:26',10,0),('1','141',257877,'DAILY SHIFT ','2022-09-15','2022-09-15 11:38:17','2022-09-16 11:38:17','499',0.00,0.00,'499','2022-09-15 11:44:16','499','2022-09-15 11:44:42',10,0),('1','141',257878,'DAILY SHIFT ','2022-09-15','2022-09-15 11:49:10','2022-09-16 11:49:10','499',0.00,0.00,'499','2022-09-15 22:51:43','499','2022-09-15 22:52:37',10,0),('1','141',257879,'DAILY SHIFT','2022-09-16','2022-09-16 07:04:56','2022-09-17 07:04:56','499',0.00,0.00,'499','2022-09-16 18:41:38','499','2022-09-16 18:42:15',10,0),('1','141',257880,'DAILY SHIFT ','2022-09-17','2022-09-17 07:10:23','2022-09-18 07:10:23','499',0.00,0.00,'499','2022-09-17 18:15:57','499','2022-09-17 18:16:40',10,0),('1','141',257881,'DAILY SHIFT ','2022-09-18','2022-09-18 09:47:34','2022-09-19 09:47:34','499',0.00,0.00,'499','2022-09-19 05:21:04','499','2022-09-19 05:21:27',10,0),('1','141',257882,'DAILY SHIFT','2022-09-19','2022-09-19 05:51:01','2022-09-20 05:51:01','499',0.00,0.00,'499','2022-09-19 05:56:05','499','2022-09-19 05:56:57',10,0),('1','141',257883,'DAILY SHIFT','2022-09-19','2022-09-19 06:02:18','2022-09-20 06:02:18','499',0.00,0.00,'499','2022-09-19 21:06:53','499','2022-09-19 21:07:12',10,0),('1','141',257884,'DAILY SHIFT ','2022-09-20','2022-09-20 07:06:33','2022-09-21 07:06:33','499',0.00,0.00,'499','2022-09-20 19:53:15','499','2022-09-20 19:53:40',10,0),('1','141',257885,'DAILY SHIFT ','2022-09-21','2022-09-21 07:02:08','2022-09-22 07:02:08','499',0.00,0.00,'499','2022-09-21 21:46:22','499','2022-09-21 21:48:41',10,0),('1','141',257886,'DAILY SHIFT ','2022-09-22','2022-09-22 06:40:16','2022-09-23 06:40:16','499',0.00,0.00,'499','2022-09-22 12:14:34','499','2022-09-22 12:15:04',10,0),('1','141',257887,'DAILY SHIFT','2022-09-22','2022-09-22 12:23:04','2022-09-23 12:23:04','499',0.00,0.00,'499','2022-09-22 12:44:16','499','2022-09-22 12:44:41',10,0),('1','141',257888,'DAILY SHIFT','2022-09-22','2022-09-22 12:50:19','2022-09-23 12:50:19','499',0.00,0.00,'499','2022-09-22 22:38:53','499','2022-09-22 22:39:24',10,0),('1','141',257889,'DAILY SHIFT','2022-09-23','2022-09-23 07:15:10','2022-09-24 07:15:10','499',0.00,0.00,'499','2022-09-23 17:27:16','499','2022-09-23 17:27:40',10,0),('1','141',257890,'DAILY SHIFT','2022-09-24','2022-09-24 07:47:29','2022-09-25 07:47:29','499',0.00,0.00,'499','2022-09-24 17:54:42','499','2022-09-24 17:56:42',10,0),('1','141',257891,'DAILY SHIFT','2022-09-25','2022-09-25 10:00:56','2022-09-26 10:00:56','499',0.00,0.00,'499','2022-09-25 15:16:56','499','2022-09-25 15:17:27',10,0),('1','141',257892,'DAILY SHIFT','2022-09-25','2022-09-25 15:34:01','2022-09-26 15:34:01','499',0.00,0.00,'499','2022-09-25 15:36:16','499','2022-09-25 15:36:35',10,0),('1','141',257893,'DAILY SHIFT','2022-09-26','2022-09-26 07:01:43','2022-09-27 07:01:43','499',0.00,0.00,'499','2022-09-26 19:45:01','499','2022-09-26 19:45:21',10,0),('1','141',257894,'DAILY SHIFT ','2022-09-27','2022-09-27 07:10:55','2022-09-28 07:10:55','499',0.00,0.00,'499','2022-09-28 06:03:50','499','2022-09-28 06:04:23',10,0),('1','141',257895,'DAILY SHIFT','2022-09-28','2022-09-28 06:16:11','2022-09-29 06:16:11','499',0.00,0.00,'499','2022-09-28 06:20:59','499','2022-09-28 06:21:31',10,0),('1','141',257896,'DAILY SHIFT','2022-09-28','2022-09-28 06:48:32','2022-09-29 06:48:32','499',0.00,0.00,'499','2022-09-28 21:35:40','499','2022-09-28 21:36:08',10,0),('1','141',257897,'DAILY SHIFT','2022-09-29','2022-09-29 07:13:55','2022-09-30 07:13:55','499',0.00,0.00,'499','2022-09-29 21:56:20','499','2022-09-29 21:56:47',10,0),('1','141',257898,'DAILY SHIFT','2022-09-30','2022-09-30 07:11:06','2022-10-01 07:11:06','499',0.00,0.00,'499','2022-10-02 06:24:54','499','2022-10-02 06:25:32',10,0),('1','141',257899,'DAILY SHIFT ','2022-10-02','2022-10-02 06:31:06','2022-10-03 06:31:06','499',0.00,0.00,'499','2022-10-02 06:36:10','499','2022-10-02 06:36:45',10,0),('1','141',257900,'DAILY SHIFT ','2022-10-02','2022-10-02 09:55:32','2022-10-03 09:55:32','499',0.00,0.00,'499','2022-10-02 19:17:49','499','2022-10-02 19:18:25',10,0),('1','141',257901,'DAILY SHIFT','2022-10-03','2022-10-03 07:15:14','2022-10-04 07:15:14','499',0.00,0.00,'499','2022-10-03 20:57:02','499','2022-10-03 20:59:10',10,0),('1','141',257902,'DAILY SHIFT','2022-10-04','2022-10-04 06:24:20','2022-10-05 06:24:20','499',0.00,0.00,'499','2022-10-04 21:51:03','499','2022-10-04 21:51:42',10,0),('1','141',257903,'DAILY SHIFT','2022-10-05','2022-10-05 07:16:39','2022-10-06 07:16:39','499',0.00,0.00,'499','2022-10-05 07:19:25','499','2022-10-05 07:19:45',10,0),('1','141',257904,'DAILY SHIFT','2022-10-05','2022-10-05 07:27:07','2022-10-06 07:27:07','499',0.00,0.00,'499','2022-10-05 21:29:16','499','2022-10-05 21:29:36',10,0),('1','141',257905,'DAILY SHIFT','2022-10-06','2022-10-06 07:29:50','2022-10-07 07:29:50','499',0.00,0.00,'499','2022-10-06 21:10:53','499','2022-10-06 21:11:19',10,0),('1','141',257906,'DAILY SHIFT','2022-10-07','2022-10-07 07:32:23','2022-10-08 07:32:23','499',0.00,0.00,'499','2022-10-07 14:44:58','499','2022-10-07 14:45:21',10,0),('1','141',257907,'DAILY SHIFT ','2022-10-07','2022-10-07 14:46:05','2022-10-08 14:46:05','499',0.00,0.00,'499','2022-10-07 14:50:56','499','2022-10-07 14:51:35',10,0),('1','141',257908,'DAILY SHIFT ','2022-10-07','2022-10-07 15:25:15','2022-10-08 15:25:15','499',0.00,0.00,'499','2022-10-07 21:15:37','499','2022-10-07 21:16:32',10,0),('1','141',257909,'DAILY SHIFT','2022-10-08','2022-10-08 07:18:43','2022-10-09 07:18:43','499',0.00,0.00,'499','2022-10-08 18:28:46','499','2022-10-08 18:30:03',10,0),('1','141',257910,'DAILY SHIFT','2022-10-09','2022-10-09 10:16:07','2022-10-10 10:16:07','499',0.00,0.00,'499','2022-10-09 21:16:24','499','2022-10-09 21:16:45',10,0),('1','141',257911,'DAILY SHIFT','2022-10-10','2022-10-10 11:12:42','2022-10-11 11:12:42','499',0.00,0.00,'499','2022-10-10 11:17:49','499','2022-10-10 11:18:16',10,0),('1','141',257912,'DAILY SHIFT','2022-10-12','2022-10-12 09:29:12','2022-10-13 09:29:12','499',0.00,0.00,'499','2022-10-12 21:39:48','499','2022-10-12 21:40:22',10,0),('1','141',257913,'DAILY SHIFT','2022-10-13','2022-10-13 07:07:30','2022-10-14 07:07:30','499',0.00,0.00,'499','2022-10-13 21:02:02','499','2022-10-13 21:06:45',10,0),('1','141',257914,'DAILY SHIFT ','2022-10-15','2022-10-15 06:37:58','2022-10-16 06:37:58','499',0.00,0.00,'499','2022-10-15 06:44:40','499','2022-10-15 06:45:01',10,0),('1','141',257915,'DAILY SHIFT ','2022-10-15','2022-10-15 06:46:18','2022-10-16 06:46:18','499',0.00,0.00,'499','2022-10-15 20:47:59','499','2022-10-15 20:48:42',10,0),('1','141',257916,'DAILY SHIFT','2022-10-16','2022-10-16 09:51:06','2022-10-17 09:51:06','499',0.00,0.00,'499','2022-10-16 21:15:40','499','2022-10-16 21:16:22',10,0),('1','141',257917,'DAILY SHIFT','2022-10-17','2022-10-17 07:16:50','2022-10-18 07:16:50','499',0.00,0.00,'499','2022-10-17 22:06:03','499','2022-10-17 22:09:01',10,0),('1','141',257918,'DAILY SHIFT','2022-10-18','2022-10-18 07:13:29','2022-10-19 07:13:29','499',0.00,0.00,'499','2022-10-18 16:22:42','499','2022-10-18 16:23:10',10,0),('1','141',257919,'DAILY SHIFT','2022-10-18','2022-10-18 16:23:44','2022-10-19 16:23:44','499',0.00,0.00,'499','2022-10-18 16:28:54','499','2022-10-18 16:29:17',10,0),('1','141',257920,'DAILY SHIFT','2022-10-19','2022-10-19 12:27:27','2022-10-20 12:27:27','499',0.00,0.00,'499','2022-10-19 21:54:23','499','2022-10-19 21:55:59',10,0),('1','141',257921,'DAILY SHIFT','2022-10-20','2022-10-20 08:18:27','2022-10-21 08:18:27','499',0.00,0.00,'499','2022-10-20 22:58:14','499','2022-10-20 22:58:37',10,0),('1','141',257922,'DAILY SHIFT ','2022-10-21','2022-10-21 06:48:16','2022-10-22 06:48:16','499',0.00,0.00,'499','2022-10-21 15:26:42','499','2022-10-21 15:27:05',10,0),('1','141',257923,'DAILY SHIFT ','2022-10-22','2022-10-22 06:17:38','2022-10-23 06:17:38','499',0.00,0.00,'499','2022-10-22 06:20:18','499','2022-10-22 06:20:39',10,0),('1','141',257924,'DAILY SHIFT ','2022-10-22','2022-10-22 06:25:53','2022-10-23 06:25:53','499',0.00,0.00,'499','2022-10-23 05:02:47','499','2022-10-23 05:03:13',10,0),('1','141',257925,'DAILY SHIFT','2022-10-23','2022-10-23 10:13:32','2022-10-24 10:13:32','499',0.00,0.00,'499','2022-10-23 20:55:35','499','2022-10-23 20:56:20',10,0),('1','141',257926,'DAILY SHIFT','2022-10-24','2022-10-24 07:24:26','2022-10-25 07:24:26','499',0.00,0.00,'499','2022-10-24 20:24:37','499','2022-10-24 20:25:01',10,0),('1','141',257927,'DAILY SHIFT','2022-10-25','2022-10-25 07:08:51','2022-10-26 07:08:51','499',0.00,0.00,'499','2022-10-25 12:45:28','499','2022-10-25 12:45:49',10,0),('1','141',257928,'DAILY SHIFT','2022-10-25','2022-10-25 12:46:25','2022-10-26 12:46:25','499',0.00,0.00,'499','2022-10-25 12:52:50','499','2022-10-25 12:53:33',10,0),('1','141',257929,'DAILY SHIFT','2022-10-25','2022-10-25 13:06:26','2022-10-26 13:06:26','499',0.00,0.00,'499','2022-10-25 20:55:08','499','2022-10-25 20:55:35',10,0),('1','141',257930,'DAILY SHIFT','2022-10-26','2022-10-26 07:05:28','2022-10-27 07:05:28','499',0.00,0.00,'499','2022-10-26 21:18:13','499','2022-10-26 21:19:11',10,0),('1','141',257931,'DAILY SHIFT','2022-10-27','2022-10-27 07:14:54','2022-10-28 07:14:54','499',0.00,0.00,'499','2022-10-27 22:00:05','499','2022-10-27 22:00:47',10,0),('1','141',257932,'DAILY SHIFT ','2022-10-28','2022-10-28 06:57:30','2022-10-29 06:57:30','499',0.00,0.00,'499','2022-10-28 14:04:53','499','2022-10-28 14:05:14',10,0),('1','141',257933,'DAILY SHIFT','2022-10-29','2022-10-29 08:27:03','2022-10-30 08:27:03','499',0.00,0.00,'499','2022-10-29 08:48:21','499','2022-10-29 08:48:50',10,0),('1','141',257934,'DAILY SHIFT','2022-11-01','2022-11-01 07:20:37','2022-11-02 07:20:37','499',0.00,0.00,'499','2022-11-01 18:14:25','499','2022-11-01 18:15:08',10,0),('1','141',257935,'DAILY SHIFT ','2022-11-02','2022-11-02 07:02:05','2022-11-03 07:02:05','499',0.00,0.00,'499','2022-11-02 17:40:27','499','2022-11-02 17:41:00',10,0),('1','141',257936,'DAILY SHIFT','2022-11-03','2022-11-03 07:21:02','2022-11-04 07:21:02','499',0.00,0.00,'499','2022-11-03 18:41:12','499','2022-11-03 18:41:42',10,0),('1','141',257937,'DAILY SHIFT','2022-11-04','2022-11-04 07:20:02','2022-11-05 07:20:02','499',0.00,0.00,'499','2022-11-04 09:46:06','499','2022-11-04 09:46:27',10,0),('1','141',257938,'DAILY SHIFT ','2022-11-04','2022-11-04 10:09:04','2022-11-05 10:09:04','499',0.00,0.00,'499','2022-11-04 10:14:35','499','2022-11-04 10:15:00',10,0),('1','141',257939,'DAILY SHIFT ','2022-11-04','2022-11-04 10:22:53','2022-11-05 10:22:53','499',0.00,0.00,'499','2022-11-04 18:14:24','499','2022-11-04 18:14:51',10,0),('1','141',257940,'DAILY SHIFT','2022-11-05','2022-11-05 07:56:05','2022-11-06 07:56:05','499',0.00,0.00,'499','2022-11-05 18:01:48','499','2022-11-05 18:02:21',10,0),('1','141',257941,'DAILY SHIFT','2022-11-06','2022-11-06 10:05:31','2022-11-07 10:05:31','499',0.00,0.00,'499','2022-11-06 21:34:15','499','2022-11-06 21:36:24',10,0),('1','141',257942,'DAILY SHIFT','2022-11-07','2022-11-07 07:14:17','2022-11-08 07:14:17','499',0.00,0.00,'499','2022-11-08 05:56:25','499','2022-11-08 05:56:55',10,0),('1','141',257943,'DAILY SHIFT','2022-11-08','2022-11-08 07:52:02','2022-11-09 07:52:02','499',0.00,0.00,'499','2022-11-08 21:14:44','499','2022-11-08 21:15:27',10,0),('1','141',257944,'DAILY SHIFT','2022-11-10','2022-11-10 06:55:35','2022-11-11 06:55:35','499',0.00,0.00,'499','2022-11-10 10:00:02','499','2022-11-10 10:00:30',10,0),('1','141',257945,'DAILY SHIFT','2022-11-10','2022-11-10 10:02:41','2022-11-11 10:02:41','499',0.00,0.00,'499','2022-11-10 10:09:25','499','2022-11-10 10:09:46',10,0),('1','141',257946,'DAILY SHIFT','2022-11-10','2022-11-10 10:18:12','2022-11-11 10:18:12','499',0.00,0.00,'499','2022-11-10 17:55:41','499','2022-11-10 17:56:18',10,0),('1','141',257947,'DAILY SHIFT','2022-11-11','2022-11-11 07:10:09','2022-11-12 07:10:09','499',0.00,0.00,'499','2022-11-11 18:00:13','499','2022-11-11 18:01:27',10,0),('1','141',257948,'DAILY SHIFT','2022-11-12','2022-11-12 07:25:03','2022-11-13 07:25:03','499',0.00,0.00,'499','2022-11-12 18:07:51','499','2022-11-12 18:08:13',10,0),('1','141',257949,'DAILY SHIFT','2022-11-13','2022-11-13 09:52:56','2022-11-14 09:52:56','499',0.00,0.00,'499','2022-11-13 20:38:05','499','2022-11-13 20:38:35',10,0),('1','141',257950,'DAILY SHIFT ','2022-11-13','2022-11-13 20:50:05','2022-11-14 20:50:05','499',0.00,0.00,'499','2022-11-13 20:53:22','499','2022-11-13 20:53:42',10,0),('1','141',257951,'DAILY SHIFT','2022-11-14','2022-11-14 07:12:22','2022-11-15 07:12:22','499',0.00,0.00,'499','2022-11-14 18:21:28','499','2022-11-14 18:21:54',10,0),('1','141',257952,'DAILY SHIFT','2022-11-15','2022-11-15 07:16:01','2022-11-16 07:16:01','499',0.00,0.00,'499','2022-11-15 19:24:26','499','2022-11-15 19:24:50',10,0),('1','141',257953,'DAILY SHIFT','2022-11-16','2022-11-16 07:06:26','2022-11-17 07:06:26','499',0.00,0.00,'499','2022-11-16 12:50:17','499','2022-11-16 12:50:39',10,0),('1','141',257954,'DAILY SHIFT','2022-11-16','2022-11-16 12:52:25','2022-11-17 12:52:25','499',0.00,0.00,'499','2022-11-16 12:56:05','499','2022-11-16 12:56:33',10,0),('1','141',257955,'DAILY SHIFT','2022-11-16','2022-11-16 13:01:00','2022-11-17 13:01:00','499',0.00,0.00,'499','2022-11-17 07:23:03','499','2022-11-17 07:23:27',10,0),('1','141',257956,'DAILY SHIFT','2022-11-17','2022-11-17 07:23:51','2022-11-18 07:23:51','499',0.00,0.00,'499','2022-11-17 18:51:48','499','2022-11-17 18:52:09',10,0),('1','141',257957,'DAILY SHIFT','2022-11-18','2022-11-18 08:03:06','2022-11-19 08:03:06','499',0.00,0.00,'499','2022-11-19 07:21:16','499','2022-11-19 07:21:47',10,0),('1','141',257958,'DAILY SHIFT','2022-11-19','2022-11-19 07:22:16','2022-11-20 07:22:16','499',0.00,0.00,'499','2022-11-20 08:09:33','499','2022-11-20 08:10:21',10,0),('1','141',257959,'DAILY SHIFT','2022-11-20','2022-11-20 12:58:51','2022-11-21 12:58:51','499',0.00,0.00,'499','2022-11-20 13:02:47','499','2022-11-20 13:16:42',10,0),('1','141',257960,'DAILY SHIFT','2022-11-21','2022-11-21 07:14:16','2022-11-22 07:14:16','499',0.00,0.00,'499','2022-11-21 21:06:34','499','2022-11-21 21:09:22',10,0),('1','141',257961,'DAILY SHIFT','2022-11-22','2022-11-22 07:10:45','2022-11-23 07:10:45','499',0.00,0.00,'499','2022-11-22 21:21:18','499','2022-11-22 21:21:46',10,0),('1','141',257962,'DAILY SHIFT','2022-11-23','2022-11-23 07:11:08','2022-11-24 07:11:08','499',0.00,0.00,'499','2022-11-23 21:07:02','499','2022-11-23 21:07:33',10,0),('1','141',257963,'DAILY SHIFT','2022-11-23','2022-11-23 21:22:09','2022-11-24 21:22:09','499',0.00,0.00,'499','2022-11-23 21:52:36','499','2022-11-23 21:53:09',10,0),('1','141',257964,'DAILY SHIFT','2022-11-24','2022-11-24 07:14:21','2022-11-25 07:14:21','499',0.00,0.00,'499','2022-11-25 06:00:55','499','2022-11-25 06:01:21',10,0),('1','141',257965,'DAILY SHIFT','2022-11-25','2022-11-25 07:43:05','2022-11-26 07:43:05','499',0.00,0.00,'499','2022-11-25 20:07:29','499','2022-11-25 20:07:59',10,0),('1','141',257966,'DAILY SHIFT','2022-11-26','2022-11-26 07:02:14','2022-11-27 07:02:14','499',0.00,0.00,'499','2022-11-26 21:11:35','499','2022-11-26 21:12:17',10,0),('1','141',257967,'DAILY SHIFT','2022-11-27','2022-11-27 10:04:35','2022-11-28 10:04:35','499',0.00,0.00,'499','2022-11-27 19:31:00','499','2022-11-27 19:31:59',10,0),('1','141',257968,'DAILY SHIFT','2022-11-28','2022-11-28 07:13:44','2022-11-29 07:13:44','499',0.00,0.00,'499','2022-11-28 21:20:08','499','2022-11-28 21:20:48',10,0),('1','141',257969,'DAILY SHIFT','2022-11-29','2022-11-29 08:58:16','2022-11-30 08:58:16','499',0.00,0.00,'499','2022-11-29 09:02:55','499','2022-11-29 09:03:23',10,0),('1','141',257970,'DAILY SHIFT ','2022-11-30','2022-11-30 06:37:35','2022-12-01 06:37:35','499',0.00,0.00,'499','2022-11-30 21:26:05','499','2022-11-30 21:27:07',10,0),('1','141',257971,'DAILY SHIFT','2022-12-01','2022-12-01 07:20:38','2022-12-02 07:20:38','499',0.00,0.00,'499','2022-12-01 21:20:58','499','2022-12-01 21:21:22',10,0),('1','141',257972,'DAILY SHIFT','2022-12-02','2022-12-02 07:11:24','2022-12-03 07:11:24','499',0.00,0.00,'499','2022-12-02 13:24:38','499','2022-12-02 13:25:16',10,0),('1','141',257973,'DAILY SHIFT','2022-12-02','2022-12-02 13:29:18','2022-12-03 13:29:18','499',0.00,0.00,'499','2022-12-02 13:43:12','499','2022-12-02 13:43:45',10,0),('1','141',257974,'DAILY SHIFT','2022-12-02','2022-12-02 13:49:54','2022-12-03 13:49:54','499',0.00,0.00,'499','2022-12-03 08:10:32','499','2022-12-03 08:11:05',10,0),('1','141',257975,'DAILY SHIFT','2022-12-03','2022-12-03 08:36:14','2022-12-04 08:36:14','499',0.00,0.00,'499','2022-12-03 23:21:23','499','2022-12-03 23:21:55',10,0),('1','141',257976,'DAILY SHIFT','2022-12-04','2022-12-04 10:51:34','2022-12-05 10:51:34','499',0.00,0.00,'499','2022-12-04 19:46:35','499','2022-12-04 19:47:01',10,0),('1','141',257977,'DAILY SHIFT','2022-12-05','2022-12-05 07:34:39','2022-12-06 07:34:39','499',0.00,0.00,'499','2022-12-05 23:34:12','499','2022-12-05 23:36:16',10,0),('1','141',257978,'DAILY SHIFT','2022-12-06','2022-12-06 07:18:18','2022-12-07 07:18:18','499',0.00,0.00,'499','2022-12-06 07:25:20','499','2022-12-06 07:26:01',10,0),('1','141',257979,'DAILY SHIFT','2022-12-06','2022-12-06 07:30:13','2022-12-07 07:30:13','499',0.00,0.00,'499','2022-12-06 20:53:39','499','2022-12-06 20:54:08',10,0),('1','141',257980,'DAILY SHIFT','2022-12-07','2022-12-07 07:18:46','2022-12-08 07:18:46','499',0.00,0.00,'499','2022-12-07 21:27:58','499','2022-12-07 21:28:30',10,0),('1','141',257981,'DAILY SHIFT','2022-12-08','2022-12-08 07:20:54','2022-12-09 07:20:54','499',0.00,0.00,'499','2022-12-08 16:47:46','499','2022-12-08 16:48:10',10,0),('1','141',257982,'DAILY SHIFT ','2022-12-09','2022-12-09 06:40:08','2022-12-10 06:40:08','499',0.00,0.00,'499','2022-12-09 06:44:22','499','2022-12-09 06:44:41',10,0),('1','141',257983,'DAILY SHIFT ','2022-12-09','2022-12-09 06:48:25','2022-12-10 06:48:25','499',0.00,0.00,'499','2022-12-09 21:37:14','499','2022-12-09 21:38:07',10,0),('1','141',257984,'DAILY SHIFT','2022-12-10','2022-12-10 07:14:09','2022-12-11 07:14:09','499',0.00,0.00,'499','2022-12-11 05:52:02','499','2022-12-11 05:52:39',10,0),('1','141',257985,'DAILY SHIFT','2022-12-11','2022-12-11 10:06:52','2022-12-12 10:06:52','499',0.00,0.00,'499','2022-12-11 21:35:19','499','2022-12-11 21:36:22',10,0),('1','141',257986,'DAILY SHIFT','2022-12-12','2022-12-12 07:17:20','2022-12-13 07:17:20','499',0.00,0.00,'499','2022-12-12 11:16:59','499','2022-12-12 11:17:24',10,0),('1','141',257987,'DAILY SHIFT','2022-12-12','2022-12-12 11:17:49','2022-12-13 11:17:49','499',0.00,0.00,'499','2022-12-12 11:21:15','499','2022-12-12 11:21:35',10,0),('1','141',257988,'DAILY SHIFT','2022-12-12','2022-12-12 11:24:52','2022-12-13 11:24:52','499',0.00,0.00,'499','2022-12-13 01:28:24','499','2022-12-13 01:28:56',10,0),('1','141',257989,'DAILY SHIFT','2022-12-13','2022-12-13 07:21:56','2022-12-14 07:21:56','499',0.00,0.00,'499','2022-12-13 17:57:50','499','2022-12-13 17:58:09',10,0),('1','141',257990,'DAILY SHIFT','2022-12-14','2022-12-14 08:19:28','2022-12-15 08:19:28','499',0.00,0.00,'499','2022-12-14 23:06:51','499','2022-12-14 23:07:38',10,0),('1','141',257991,'DAILY SHIFT ','2022-12-16','2022-12-16 11:05:02','2022-12-17 11:05:02','499',0.00,0.00,'499','2022-12-16 11:09:48','499','2022-12-16 11:10:10',10,0),('1','141',257992,'DAILY SHIFT ','2022-12-16','2022-12-16 11:35:37','2022-12-17 11:35:37','499',0.00,0.00,'499','2022-12-16 16:52:46','499','2022-12-16 16:53:10',10,0),('1','141',257993,'DAILY SHIFT','2022-12-17','2022-12-17 07:28:17','2022-12-18 07:28:17','499',0.00,0.00,'499','2022-12-17 20:42:53','499','2022-12-17 20:43:50',10,0),('1','141',257994,'DAILY SHIFT','2022-12-18','2022-12-18 10:00:29','2022-12-19 10:00:29','499',0.00,0.00,'499','2022-12-18 20:18:37','499','2022-12-18 20:19:53',10,0),('1','141',257995,'DAILY SHIFT','2022-12-19','2022-12-19 07:11:03','2022-12-20 07:11:03','499',0.00,0.00,'499','2022-12-19 14:43:34','499','2022-12-19 14:43:54',10,0),('1','141',257996,'DAILY SHIFT ','2022-12-20','2022-12-20 10:46:18','2022-12-21 10:46:18','499',0.00,0.00,'499','2022-12-20 10:56:21','499','2022-12-20 10:56:47',10,0),('1','141',257997,'DAILY SHIFT ','2022-12-20','2022-12-20 11:07:11','2022-12-21 11:07:11','499',0.00,0.00,'499','2022-12-21 05:18:15','499','2022-12-21 05:18:40',10,0),('1','141',257998,'DAILY SHIFT','2022-12-21','2022-12-21 07:23:00','2022-12-22 07:23:00','499',0.00,0.00,'499','2022-12-22 06:15:57','499','2022-12-22 06:16:28',10,0),('1','141',257999,'DAILY SHIFT','2022-12-22','2022-12-22 07:01:41','2022-12-23 07:01:41','499',0.00,0.00,'499','2022-12-22 22:14:50','499','2022-12-22 22:15:21',10,0),('1','141',258000,'DAILY SHIFT','2022-12-23','2022-12-23 07:18:51','2022-12-24 07:18:51','499',0.00,0.00,'499','2022-12-23 14:16:56','499','2022-12-23 14:17:36',10,0),('1','141',258001,'DAILY SHIFT ','2022-12-25','2022-12-25 07:14:05','2022-12-26 07:14:05','499',0.00,0.00,'499','2022-12-25 07:17:31','499','2022-12-25 07:17:54',10,0),('1','141',258002,'DAILY SHIFT ','2022-12-25','2022-12-25 07:22:36','2022-12-26 07:22:36','499',0.00,0.00,'499','2022-12-25 23:48:41','499','2022-12-25 23:49:50',10,0),('1','141',258003,'DAILY SHIFT','2022-12-27','2022-12-27 07:29:15','2022-12-28 07:29:15','499',0.00,0.00,'499','2022-12-27 21:56:27','499','2022-12-27 21:57:06',10,0),('1','141',258004,'DAILY SHIFT','2022-12-28','2022-12-28 07:19:35','2022-12-29 07:19:35','499',0.00,0.00,'499','2022-12-28 22:20:53','499','2022-12-28 22:21:28',10,0),('1','141',258005,'DAILY SHIFT','2022-12-28','2022-12-28 23:14:52','2022-12-29 23:14:52','499',0.00,0.00,'499','2022-12-28 23:29:41','499','2022-12-28 23:31:06',10,0),('1','141',258006,'DAILY SHIFT ','2022-12-29','2022-12-29 06:05:14','2022-12-30 06:05:14','499',0.00,0.00,'499','2022-12-29 21:58:20','499','2022-12-29 21:58:51',10,0),('1','141',258007,'DAILY SHIFT','2022-12-30','2022-12-30 07:27:39','2022-12-31 07:27:39','499',0.00,0.00,'499','2022-12-30 22:23:31','499','2022-12-30 22:24:02',10,0),('1','141',258008,'DAILY SHIFT','2022-12-31','2022-12-31 07:17:52','2023-01-01 07:17:52','499',0.00,0.00,'499','2022-12-31 21:19:15','499','2022-12-31 21:20:19',10,0),('1','141',258009,'DAILY SHIFT','2023-01-01','2023-01-01 10:08:24','2023-01-02 10:08:24','499',0.00,0.00,'499','2023-01-01 22:43:26','499','2023-01-01 22:45:06',10,0),('1','141',258010,'DAILY SHIFT','2023-01-01','2023-01-01 23:07:38','2023-01-02 23:07:38','499',0.00,0.00,'499','2023-01-02 07:01:01','499','2023-01-02 07:01:27',10,0),('1','141',258011,'DAILY SHIFT ','2023-01-02','2023-01-02 07:02:22','2023-01-03 07:02:22','499',0.00,0.00,'499','2023-01-02 21:01:14','499','2023-01-02 21:01:44',10,0),('1','141',258012,'DAILY SHIFT','2023-01-03','2023-01-03 07:25:58','2023-01-04 07:25:58','499',0.00,0.00,'499','2023-01-03 22:52:16','499','2023-01-03 22:52:47',10,0),('1','141',258013,'DAILY SHIFT','2023-01-04','2023-01-04 07:16:34','2023-01-05 07:16:34','499',0.00,0.00,'499','2023-01-04 20:42:26','499','2023-01-04 20:42:56',10,0),('1','141',258014,'DAILY SHIFT','2023-01-05','2023-01-05 07:21:04','2023-01-06 07:21:04','499',0.00,0.00,'499','2023-01-05 14:21:56','499','2023-01-05 14:22:19',10,0),('1','141',258015,'DAILY SHIFT','2023-01-05','2023-01-05 22:23:51','2023-01-06 22:23:51','499',0.00,0.00,'499','2023-01-05 22:29:30','499','2023-01-05 22:30:01',10,0),('1','141',258016,'DAILY SHIFT','2023-01-06','2023-01-06 07:24:53','2023-01-07 07:24:53','499',0.00,0.00,'499','2023-01-06 22:17:44','499','2023-01-06 22:18:10',10,0),('1','141',258017,'DAILY SHIFT','2023-01-07','2023-01-07 07:20:49','2023-01-08 07:20:49','499',0.00,0.00,'499','2023-01-07 15:52:48','499','2023-01-07 15:53:12',10,0),('1','141',258018,'DAILY SHIFT','2023-01-08','2023-01-08 10:48:06','2023-01-09 10:48:06','499',0.00,0.00,'499','2023-01-08 21:35:01','499','2023-01-08 21:35:32',10,0),('1','141',258019,'DAILY SHIFT','2023-01-09','2023-01-09 07:25:09','2023-01-10 07:25:09','499',0.00,0.00,'499','2023-01-09 22:51:16','499','2023-01-09 22:53:48',10,0),('1','141',258020,'DAILY SHIFT','2023-01-10','2023-01-10 07:02:38','2023-01-11 07:02:38','499',0.00,0.00,'499','2023-01-10 07:09:05','499','2023-01-10 07:09:47',10,0),('1','141',258021,'DAILY SHIFT','2023-01-10','2023-01-10 07:19:47','2023-01-11 07:19:47','499',0.00,0.00,'499','2023-01-11 06:36:03','499','2023-01-11 06:36:26',10,0),('1','141',258022,'DAILY SHIFT','2023-01-11','2023-01-11 07:21:13','2023-01-12 07:21:13','499',0.00,0.00,'499','2023-01-11 22:08:20','499','2023-01-11 22:08:48',10,0),('1','141',258023,'DAILY SHIFT','2023-01-12','2023-01-12 07:36:52','2023-01-13 07:36:52','499',0.00,0.00,'499','2023-01-12 20:34:36','499','2023-01-12 20:35:00',10,0),('1','141',258024,'DAILY SHIFT','2023-01-13','2023-01-13 07:36:33','2023-01-14 07:36:33','499',0.00,0.00,'499','2023-01-13 21:08:41','499','2023-01-13 21:09:07',10,0),('1','141',258025,'DAILY SHIFT','2023-01-14','2023-01-14 07:07:45','2023-01-15 07:07:45','499',0.00,0.00,'499','2023-01-14 10:54:43','499','2023-01-14 10:56:02',10,0),('1','141',258026,'DAILY SHIFT','2023-01-14','2023-01-14 11:00:08','2023-01-15 11:00:08','499',0.00,0.00,'499','2023-01-14 21:34:54','499','2023-01-14 21:35:28',10,0),('1','141',258027,'DAILY SHIFT','2023-01-15','2023-01-15 10:06:44','2023-01-16 10:06:44','499',0.00,0.00,'499','2023-01-15 21:32:39','499','2023-01-15 21:33:13',10,0),('1','141',258028,'DAILY SHIFT','2023-01-16','2023-01-16 07:27:43','2023-01-17 07:27:43','499',0.00,0.00,'499','2023-01-16 21:07:13','499','2023-01-16 21:07:48',10,0),('1','141',258029,'DAILY SHIFT','2023-01-17','2023-01-17 07:37:28','2023-01-18 07:37:28','499',0.00,0.00,'499','2023-01-17 13:36:26','499','2023-01-17 13:36:46',10,0),('1','141',258030,'DAILY SHIFT ','2023-01-17','2023-01-17 13:37:26','2023-01-18 13:37:26','499',0.00,0.00,'499','2023-01-17 13:44:08','499','2023-01-17 13:44:29',10,0),('1','141',258031,'DAILY SHIFT ','2023-01-17','2023-01-17 13:49:33','2023-01-18 13:49:33','499',0.00,0.00,'499','2023-01-17 19:10:33','499','2023-01-17 19:11:13',10,0),('1','141',258032,'DAILY SHIFT','2023-01-18','2023-01-18 07:25:01','2023-01-19 07:25:01','499',0.00,0.00,'499','2023-01-18 21:22:03','499','2023-01-18 21:23:25',10,0),('1','141',258033,'DAILY SHIFT','2023-01-19','2023-01-19 07:15:29','2023-01-20 07:15:29','499',0.00,0.00,'499','2023-01-19 22:40:54','499','2023-01-19 22:41:59',10,0),('1','141',258034,'DAILY SHIFT','2023-01-19','2023-01-19 22:54:30','2023-01-20 22:54:30','499',0.00,0.00,'499','2023-01-19 23:03:22','499','2023-01-19 23:04:15',10,0),('1','141',258035,'DAILY SHIFT','2023-01-20','2023-01-20 07:26:27','2023-01-21 07:26:27','499',0.00,0.00,'499','2023-01-20 20:37:05','499','2023-01-20 20:37:41',10,0),('1','141',258036,'DAILY SHIFT','2023-01-21','2023-01-21 07:20:33','2023-01-22 07:20:33','499',0.00,0.00,'499','2023-01-21 21:10:21','499','2023-01-21 21:11:09',10,0),('1','141',258037,'DAILY SHIFT','2023-01-22','2023-01-22 10:13:19','2023-01-23 10:13:19','499',0.00,0.00,'499','2023-01-22 21:56:57','499','2023-01-22 21:57:27',10,0),('1','141',258038,'DAILY SHIFT','2023-01-23','2023-01-23 07:24:12','2023-01-24 07:24:12','499',0.00,0.00,'499','2023-01-23 12:02:43','499','2023-01-23 12:03:13',10,0),('1','141',258039,'DAILY SHIFT ','2023-01-23','2023-01-23 12:04:06','2023-01-24 12:04:06','499',0.00,0.00,'499','2023-01-23 12:08:23','499','2023-01-23 12:08:50',10,0),('1','141',258040,'DAILY SHIFT ','2023-01-23','2023-01-23 12:15:44','2023-01-24 12:15:44','499',0.00,0.00,'499','2023-01-24 07:17:35','499','2023-01-24 07:18:00',10,0),('1','141',258041,'DAILY SHIFT','2023-01-24','2023-01-24 07:19:47','2023-01-25 07:19:47','499',0.00,0.00,'499','2023-01-24 21:46:57','499','2023-01-24 21:47:50',10,0),('1','141',258042,'DAILY SHIFT','2023-01-25','2023-01-25 07:18:23','2023-01-26 07:18:23','499',0.00,0.00,'499','2023-01-25 20:49:56','499','2023-01-25 20:50:30',10,0),('1','141',258043,'DAILY SHIFT ','2023-01-27','2023-01-27 20:36:04','2023-01-28 20:36:04','499',0.00,0.00,'499','2023-01-27 20:43:05','499','2023-01-27 20:43:30',10,0),('1','141',258044,'DAILY SHIFT','2023-01-28','2023-01-28 07:13:39','2023-01-29 07:13:39','499',0.00,0.00,'499','2023-01-28 21:20:39','499','2023-01-28 21:21:14',10,0),('1','141',258045,'DAILY SHIFT','2023-01-29','2023-01-29 09:42:31','2023-01-30 09:42:31','499',0.00,0.00,'499','2023-01-29 23:30:07','499','2023-01-29 23:30:49',10,0),('1','141',258046,'DAILY SHIFT','2023-01-30','2023-01-30 07:38:32','2023-01-31 07:38:32','499',0.00,0.00,'499','2023-01-30 22:01:42','499','2023-01-30 22:02:24',10,0),('1','141',258047,'DAILY SHIFT ','2023-01-31','2023-01-31 21:59:04','2023-02-01 21:59:04','499',0.00,0.00,'499','2023-01-31 22:05:20','499','2023-01-31 22:05:40',10,0),('1','141',258048,'DAILY SHIFT','2023-02-01','2023-02-01 07:10:13','2023-02-02 07:10:13','499',0.00,0.00,'499','2023-02-01 21:28:26','499','2023-02-01 21:28:55',10,0),('1','141',258049,'DAILY SHIFT','2023-02-02','2023-02-02 07:15:06','2023-02-03 07:15:06','499',0.00,0.00,'499','2023-02-02 21:27:13','499','2023-02-02 21:27:56',10,0),('1','141',258050,'DAILY SHIFT','2023-02-03','2023-02-03 07:05:22','2023-02-04 07:05:22','499',0.00,0.00,'499','2023-02-03 21:28:04','499','2023-02-03 21:28:34',10,0),('1','141',258051,'DAILY SHIFT','2023-02-04','2023-02-04 07:08:02','2023-02-05 07:08:02','499',0.00,0.00,'499','2023-02-04 20:48:49','499','2023-02-04 20:49:17',10,0),('1','141',258052,'DAILY SHIFT','2023-02-05','2023-02-05 10:09:36','2023-02-06 10:09:36','499',0.00,0.00,'499','2023-02-05 19:41:08','499','2023-02-05 19:42:39',10,0),('1','141',258053,'DAILY SHIFT','2023-02-06','2023-02-06 07:59:23','2023-02-07 07:59:23','499',0.00,0.00,'499','2023-02-06 08:17:59','499','2023-02-06 08:18:22',10,0),('1','141',258054,'DAILY SHIFT','2023-02-06','2023-02-06 08:27:23','2023-02-07 08:27:23','499',0.00,0.00,'499','2023-02-07 05:05:22','499','2023-02-07 05:06:01',10,0),('1','141',258055,'DAILY SHIFT','2023-02-07','2023-02-07 07:43:22','2023-02-08 07:43:22','499',0.00,0.00,'499','2023-02-07 21:31:16','499','2023-02-07 21:31:58',10,0),('1','141',258056,'DAILY SHIFT','2023-02-08','2023-02-08 07:25:20','2023-02-09 07:25:20','499',0.00,0.00,'499','2023-02-08 21:04:23','499','2023-02-08 21:04:56',10,0),('1','141',258057,'DAILY SHIFT','2023-02-09','2023-02-09 07:18:46','2023-02-10 07:18:46','499',0.00,0.00,'499','2023-02-09 20:55:30','499','2023-02-09 20:56:17',10,0),('1','141',258058,'DAILY SHIFT','2023-02-09','2023-02-09 21:07:14','2023-02-10 21:07:14','499',0.00,0.00,'499','2023-02-09 21:11:29','499','2023-02-09 21:12:09',10,0),('1','141',258059,'DAILY SHIFT','2023-02-10','2023-02-10 07:30:42','2023-02-11 07:30:42','499',0.00,0.00,'499','2023-02-10 21:08:32','499','2023-02-10 21:09:07',10,0),('1','141',258060,'DAILY SHIFT','2023-02-11','2023-02-11 07:07:43','2023-02-12 07:07:43','499',0.00,0.00,'499','2023-02-11 21:48:55','499','2023-02-11 21:49:44',10,0),('1','141',258061,'DAILY SHIFT','2023-02-12','2023-02-12 09:57:18','2023-02-13 09:57:18','499',0.00,0.00,'499','2023-02-12 21:21:17','499','2023-02-12 21:21:52',10,0),('1','141',258062,'DAILY SHIFT','2023-02-13','2023-02-13 07:19:41','2023-02-14 07:19:41','499',0.00,0.00,'499','2023-02-13 21:55:40','499','2023-02-13 21:56:07',10,0),('1','141',258063,'DAILY SHIFT','2023-02-14','2023-02-14 07:26:12','2023-02-15 07:26:12','499',0.00,0.00,'499','2023-02-14 21:46:20','499','2023-02-14 21:46:55',10,0),('1','141',258064,'DAILY SHIFT','2023-02-14','2023-02-14 22:24:44','2023-02-15 22:24:44','499',0.00,0.00,'499','2023-02-14 22:28:45','499','2023-02-14 22:29:13',10,0),('1','141',258065,'DAILY SHIFT','2023-02-15','2023-02-15 07:04:08','2023-02-16 07:04:08','499',0.00,0.00,'499','2023-02-15 21:06:28','499','2023-02-15 21:07:00',10,0),('1','141',258066,'DAILY SHIFT','2023-02-16','2023-02-16 07:27:21','2023-02-17 07:27:21','499',0.00,0.00,'499','2023-02-16 21:42:32','499','2023-02-16 21:43:02',10,0),('1','141',258067,'DAILY SHIFT','2023-02-17','2023-02-17 07:48:29','2023-02-18 07:48:29','499',0.00,0.00,'499','2023-02-17 21:15:18','499','2023-02-17 21:15:43',10,0),('1','141',258068,'DAILY SHIFT','2023-02-18','2023-02-18 07:14:40','2023-02-19 07:14:40','499',0.00,0.00,'499','2023-02-19 06:48:24','499','2023-02-19 06:48:48',10,0),('1','141',258069,'DAILY SHIFT','2023-02-19','2023-02-19 07:22:58','2023-02-20 07:22:58','499',0.00,0.00,'499','2023-02-19 07:27:42','499','2023-02-19 07:28:14',10,0),('1','141',258070,'DAILY SHIFT','2023-02-19','2023-02-19 10:14:36','2023-02-20 10:14:36','499',0.00,0.00,'499','2023-02-19 20:28:49','499','2023-02-19 20:29:21',10,0),('1','141',258071,'DAILY SHIFT','2023-02-20','2023-02-20 07:38:06','2023-02-21 07:38:06','499',0.00,0.00,'499','2023-02-20 21:36:39','499','2023-02-20 21:37:12',10,0),('1','141',258072,'DAILY SHIFT','2023-02-21','2023-02-21 07:05:25','2023-02-22 07:05:25','499',0.00,0.00,'499','2023-02-21 21:50:48','499','2023-02-21 21:51:16',10,0),('1','141',258073,'DAILY SHIFT','2023-02-22','2023-02-22 07:33:38','2023-02-23 07:33:38','499',0.00,0.00,'499','2023-02-22 14:52:50','499','2023-02-22 14:53:11',10,0),('1','141',258074,'DAILY SHIFT','2023-02-23','2023-02-23 07:52:09','2023-02-24 07:52:09','499',0.00,0.00,'499','2023-02-23 07:59:03','499','2023-02-23 07:59:38',10,0),('1','141',258075,'DAILY SHIFT','2023-02-23','2023-02-23 08:00:09','2023-02-24 08:00:09','499',0.00,0.00,'499','2023-02-23 18:05:09','499','2023-02-23 18:05:38',10,0),('1','141',258076,'DAILY SHIFT','2023-02-24','2023-02-24 07:24:00','2023-02-25 07:24:00','499',0.00,0.00,'499','2023-02-24 19:02:18','499','2023-02-24 19:03:35',10,0),('1','141',258077,'DAILY SHIFT ','2023-02-27','2023-02-27 07:11:46','2023-02-28 07:11:46','499',0.00,0.00,'499','2023-02-27 11:26:47','499','2023-02-27 11:27:07',10,0),('1','141',258078,'DAILY SHIFT','2023-02-27','2023-02-27 11:32:10','2023-02-28 11:32:10','499',0.00,0.00,'499','2023-02-27 11:35:28','499','2023-02-27 11:36:03',10,0),('1','141',258079,'DAILY SHIFT','2023-02-27','2023-02-27 11:41:35','2023-02-28 11:41:35','499',0.00,0.00,'499','2023-02-27 20:56:29','499','2023-02-27 20:56:56',10,0),('1','141',258080,'DAILY SHIFT ','2023-02-28','2023-02-28 07:09:43','2023-03-01 07:09:43','499',0.00,0.00,'499','2023-02-28 18:12:06','499','2023-02-28 18:12:35',10,0),('1','141',258081,'DAILY SHIFT','2023-03-01','2023-03-01 07:22:03','2023-03-02 07:22:03','499',0.00,0.00,'499','2023-03-01 21:25:56','499','2023-03-01 21:26:32',10,0),('1','141',258082,'DAILY SHIFT','2023-03-01','2023-03-01 21:35:57','2023-03-02 21:35:57','499',0.00,0.00,'499','2023-03-01 21:45:13','499','2023-03-01 21:45:38',10,0),('1','141',258083,'DAILY SHIFT','2023-03-02','2023-03-02 06:52:25','2023-03-03 06:52:25','499',0.00,0.00,'499','2023-03-02 17:55:48','499','2023-03-02 17:56:11',10,0),('1','141',258084,'DAILY SHIFT','2023-03-03','2023-03-03 07:13:06','2023-03-04 07:13:06','499',0.00,0.00,'499','2023-03-03 18:36:59','499','2023-03-03 19:40:07',10,0),('1','141',258085,'DAILY SHIFT','2023-03-04','2023-03-04 07:10:15','2023-03-05 07:10:15','499',0.00,0.00,'499','2023-03-04 17:49:51','499','2023-03-04 17:50:45',10,0),('1','141',258086,'DAILY SHIFT','2023-03-05','2023-03-05 10:03:21','2023-03-06 10:03:21','499',0.00,0.00,'499','2023-03-05 14:19:27','499','2023-03-05 14:19:56',10,0),('1','141',258087,'DAILY SHIFT ','2023-03-05','2023-03-05 22:02:24','2023-03-06 22:02:24','499',0.00,0.00,'499','2023-03-05 22:08:38','499','2023-03-05 22:09:19',10,0),('1','141',258088,'DAILY SHIFT','2023-03-06','2023-03-06 07:08:02','2023-03-07 07:08:02','499',0.00,0.00,'499','2023-03-06 18:41:37','499','2023-03-06 18:43:53',10,0),('1','141',258089,'DAILY SHIFT','2023-03-07','2023-03-07 07:10:13','2023-03-08 07:10:13','499',0.00,0.00,'499','2023-03-07 18:40:12','499','2023-03-07 18:40:37',10,0),('1','141',258090,'DAILY SHIFT','2023-03-08','2023-03-08 07:09:28','2023-03-09 07:09:28','499',0.00,0.00,'499','2023-03-08 18:14:06','499','2023-03-08 18:14:30',10,0),('1','141',258091,'DAILY SHIFT','2023-03-09','2023-03-09 07:14:25','2023-03-10 07:14:25','499',0.00,0.00,'499','2023-03-09 21:27:07','499','2023-03-09 21:27:56',10,0),('1','141',258092,'DAILY SHIFT','2023-03-09','2023-03-09 21:49:10','2023-03-10 21:49:10','499',0.00,0.00,'499','2023-03-10 05:32:51','499','2023-03-10 05:33:40',10,0),('1','141',258093,'DAILY SHIFT','2023-03-10','2023-03-10 07:06:01','2023-03-11 07:06:01','499',0.00,0.00,'499','2023-03-10 18:03:57','499','2023-03-10 18:04:30',10,0),('1','141',258094,'DAILY SHIFT','2023-03-11','2023-03-11 07:16:40','2023-03-12 07:16:40','499',0.00,0.00,'499','2023-03-11 18:40:59','499','2023-03-11 18:41:24',10,0),('1','141',258095,'DAILY SHIFT','2023-03-12','2023-03-12 09:42:16','2023-03-13 09:42:16','499',0.00,0.00,'499','2023-03-12 18:26:29','499','2023-03-12 18:27:24',10,0),('1','141',258096,'DAILY SHIFT','2023-03-13','2023-03-13 07:05:55','2023-03-14 07:05:55','499',0.00,0.00,'499','2023-03-13 17:37:43','499','2023-03-13 17:39:21',10,0),('1','141',258097,'DAILY SHIFT','2023-03-14','2023-03-14 06:32:10','2023-03-15 06:32:10','499',0.00,0.00,'499','2023-03-14 06:37:23','499','2023-03-14 06:37:57',10,0),('1','141',258098,'DAILY SHIFT ','2023-03-14','2023-03-14 22:03:57','2023-03-15 22:03:57','499',0.00,0.00,'499','2023-03-15 06:21:39','499','2023-03-15 06:22:19',10,0),('1','141',258099,'DAILY SHIFT','2023-03-15','2023-03-15 07:10:03','2023-03-16 07:10:03','499',0.00,0.00,'499','2023-03-16 08:30:17','499','2023-03-16 08:30:55',10,0),('1','141',258100,'DAILY SHIFT','2023-03-15','2023-03-16 08:31:28','2023-03-17 08:31:28','499',0.00,0.00,'499','2023-03-16 08:42:25','499','2023-03-16 08:42:59',10,0),('1','141',258101,'DAILY SHIFT','2023-03-16','2023-03-16 09:31:21','2023-03-17 09:31:21','499',0.00,0.00,'499','2023-03-16 18:06:34','499','2023-03-16 18:07:09',10,0),('1','141',258102,'DAILY SHIFT','2023-03-17','2023-03-17 07:20:14','2023-03-18 07:20:14','499',0.00,0.00,'499','2023-03-17 13:13:31','499','2023-03-17 13:13:56',10,0),('1','141',258103,'DAILY SHIFT','2023-03-17','2023-03-17 13:21:41','2023-03-18 13:21:41','499',0.00,0.00,'499','2023-03-17 13:42:53','499','2023-03-17 13:43:24',10,0),('1','141',258104,'DAILY SHIFT','2023-03-17','2023-03-17 13:47:29','2023-03-18 13:47:29','499',0.00,0.00,'499','2023-03-17 18:41:15','499','2023-03-17 18:41:46',10,0),('1','141',258105,'DAILY SHIFT','2023-03-20','2023-03-20 07:03:02','2023-03-21 07:03:02','499',0.00,0.00,'499','2023-03-20 18:05:43','499','2023-03-20 18:10:41',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4906594 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','141','764','144948',2900173,'2135','322',0.00,2844.70,0.00,0.00,2844.70,566062.00,0.00,0.00,0.00),('1','141','764','145032',2901629,'2135','322',2844.70,11945.70,0.00,0.00,9101.00,1806266.00,0.00,0.00,0.00),('1','141','764','145043',2901874,'2135','322',11945.70,22710.00,0.00,0.00,10764.30,2120596.80,0.00,0.00,0.00),('1','141','764','145057',2902148,'2135','322',22710.00,23625.80,0.00,0.00,915.80,188720.00,0.00,0.00,0.00),('1','141','764','145072',2902383,'2135','322',23625.80,27486.80,0.00,0.00,3861.00,810810.00,0.00,0.00,0.00),('1','141','764','145081',2902551,'2135','322',27486.80,31114.60,0.00,0.00,3627.80,772289.00,0.00,0.00,0.00),('1','141','764','145124',2903546,'2135','322',31114.60,35784.90,0.00,0.00,4670.30,991424.00,0.00,0.00,0.00),('1','141','764','145125',2903547,'2135','322',35784.90,42587.60,0.00,0.00,6802.70,1437646.00,0.00,0.00,0.00),('1','141','764','145126',2903548,'2135','322',42587.60,45587.60,0.00,0.00,3000.00,644385.00,0.00,0.00,0.00),('1','141','764','145626',2913391,'2135','322',45587.60,55762.40,0.00,0.00,10174.80,2150253.00,0.00,0.00,0.00),('1','141','764','145630',2913456,'2135','322',55762.40,67732.20,0.00,0.00,11969.80,2525404.00,0.00,0.00,0.00),('1','141','764','145638',2913550,'2135','322',67732.20,70947.20,0.00,0.00,3215.00,682570.00,0.00,0.00,0.00),('1','141','764','145642',2913586,'2135','322',70947.20,79108.80,0.00,0.00,8161.60,1726893.00,0.00,0.00,0.00),('1','141','764','145645',2913627,'2135','322',79108.80,85541.80,0.00,0.00,6433.00,1360100.00,0.00,0.00,0.00),('1','141','764','145647',2913640,'2135','322',85541.80,87213.50,0.00,0.00,1671.70,353507.00,0.00,0.00,0.00),('1','141','764','145654',2913750,'2135','322',87213.50,98929.20,0.00,0.00,11715.70,2472862.00,0.00,0.00,0.00),('1','141','764','145655',2913751,'2135','322',98929.20,106816.00,0.00,0.00,7886.80,1663578.00,0.00,0.00,0.00),('1','141','764','145714',2914916,'2135','322',106816.00,110218.90,0.00,0.00,3402.90,720307.00,0.00,0.00,0.00),('1','141','764','145719',2915012,'2135','322',110218.90,117369.40,0.00,0.00,7150.50,1511650.00,0.00,0.00,0.00),('1','141','764','145720',2915013,'2135','322',117369.40,123250.70,0.00,0.00,5881.30,1249234.00,0.00,0.00,0.00),('1','141','764','145724',2915082,'2135','322',123250.70,126375.90,0.00,0.00,3125.20,656292.00,0.00,0.00,0.00),('1','141','764','147954',2955775,'2135','322',126375.90,139601.10,0.00,0.00,13225.20,2791600.00,0.00,0.00,0.00),('1','141','764','147971',2956132,'2135','322',139601.10,144764.60,0.00,0.00,5163.50,1091580.00,0.00,0.00,0.00),('1','141','764','148093',2958107,'2135','322',144764.60,149050.90,0.00,0.00,4286.30,911008.00,0.00,0.00,0.00),('1','141','764','148198',2960099,'2135','322',149050.90,158076.20,0.00,0.00,9025.30,1904357.00,0.00,0.00,0.00),('1','141','764','148209',2960317,'2135','322',158076.20,165230.60,0.00,0.00,7154.40,1513232.00,0.00,0.00,0.00),('1','141','764','148215',2960432,'2135','322',165230.60,171290.90,0.00,0.00,6060.30,1275827.00,0.00,0.00,0.00),('1','141','764','148221',2960496,'2135','322',171290.90,176340.40,0.00,0.00,5049.50,1068585.00,0.00,0.00,0.00),('1','141','764','148245',2961009,'2135','322',176340.40,181505.50,0.00,0.00,5165.10,1091986.00,0.00,0.00,0.00),('1','141','764','148250',2961052,'2135','322',181505.50,188525.60,0.00,0.00,7020.10,1483748.00,0.00,0.00,0.00),('1','141','764','148254',2961097,'2135','322',188525.60,193913.60,0.00,0.00,5388.00,1140895.00,0.00,0.00,0.00),('1','141','764','148256',2961100,'2135','322',193913.60,199737.50,0.00,0.00,5823.90,1233190.00,0.00,0.00,0.00),('1','141','764','148264',2961218,'2135','322',199737.50,209615.50,0.00,0.00,9878.00,2087820.00,0.00,0.00,0.00),('1','141','764','148266',2961241,'2135','322',209615.50,215588.60,0.00,0.00,5973.10,1262702.00,0.00,0.00,0.00),('1','141','764','148267',2961242,'2135','322',215588.60,229287.20,0.00,0.00,13698.60,2886548.00,0.00,0.00,0.00),('1','141','764','148270',2961283,'2135','322',229287.20,237255.10,0.00,0.00,7967.90,1682667.00,0.00,0.00,0.00),('1','141','764','148388',2963264,'2135','322',237255.10,251214.70,0.00,0.00,13959.60,2941827.00,0.00,0.00,0.00),('1','141','764','148420',2963833,'2135','322',251214.70,259956.50,0.00,0.00,8741.80,1843324.00,0.00,0.00,0.00),('1','141','764','148425',2963926,'2135','322',259956.50,274576.30,0.00,0.00,14619.80,3079986.00,0.00,0.00,0.00),('1','141','764','148463',2964615,'2135','322',274576.30,282626.30,0.00,0.00,8050.00,1704710.00,0.00,0.00,0.00),('1','141','764','148466',2964660,'2135','322',282626.30,288994.00,0.00,0.00,6367.70,1347276.00,0.00,0.00,0.00),('1','141','764','148469',2964692,'2135','322',288994.00,293572.50,0.00,0.00,4578.50,970095.00,0.00,0.00,0.00),('1','141','764','148554',2966162,'2135','322',293572.50,302001.80,0.00,0.00,8429.30,1779204.00,0.00,0.00,0.00),('1','141','764','148815',2970298,'2135','322',302001.80,305499.90,0.00,0.00,3498.10,740859.00,0.00,0.00,0.00),('1','141','764','148968',2973377,'2135','322',305499.90,315718.00,0.00,0.00,10218.10,2155524.00,0.00,0.00,0.00),('1','141','764','149163',2977155,'2135','322',315718.00,320967.60,0.00,0.00,5249.60,1111978.00,0.00,0.00,0.00),('1','141','764','149305',2979626,'2135','322',320967.60,327085.50,0.00,0.00,6117.90,1293187.00,0.00,0.00,0.00),('1','141','764','149487',2982492,'2135','322',327085.50,328226.90,0.00,0.00,1141.40,249158.00,0.00,0.00,0.00),('1','141','764','149578',2984264,'2135','322',328226.90,337271.60,0.00,0.00,9044.70,1908837.00,0.00,0.00,0.00),('1','141','764','149738',2986759,'2135','322',337271.60,347784.90,0.00,0.00,10513.30,2217621.00,0.00,0.00,0.00),('1','141','764','150011',2991927,'2135','322',347784.90,350867.90,0.00,0.00,3083.00,655375.00,0.00,0.00,0.00),('1','141','764','150422',2999329,'2135','322',350867.90,357837.90,0.00,0.00,6970.00,1472240.00,0.00,0.00,0.00),('1','141','764','151025',3010698,'2135','322',357837.90,362600.30,0.00,0.00,4762.40,1010002.00,0.00,0.00,0.00),('1','141','764','151026',3010699,'2135','322',362600.30,367126.30,0.00,0.00,4526.00,961576.00,0.00,0.00,0.00),('1','141','764','151027',3010700,'2135','322',367126.30,373494.80,0.00,0.00,6368.50,1347885.00,0.00,0.00,0.00),('1','141','764','151180',3013541,'2135','322',373494.80,378846.20,0.00,0.00,5351.40,1133370.00,0.00,0.00,0.00),('1','141','764','151455',3018872,'2135','322',378846.20,384779.90,0.00,0.00,5933.70,1255926.00,0.00,0.00,0.00),('1','141','764','151462',3018959,'2135','322',384779.90,389469.90,0.00,0.00,4690.00,992530.00,0.00,0.00,0.00),('1','141','764','151607',3021557,'2135','322',389469.90,394275.00,0.00,0.00,4805.10,1018038.00,0.00,0.00,0.00),('1','141','764','151856',3026128,'2135','322',394275.00,397618.60,0.00,0.00,3343.60,712418.00,0.00,0.00,0.00),('1','141','764','152086',3030474,'2135','322',397618.60,404893.80,0.00,0.00,7275.20,1528700.00,0.00,0.00,0.00),('1','141','764','152153',3031832,'2135','322',404893.80,409619.70,0.00,0.00,4725.90,992700.00,0.00,0.00,0.00),('1','141','764','152290',3034656,'2135','322',409619.70,413141.10,0.00,0.00,3521.40,739838.40,0.00,0.00,0.00),('1','141','764','152483',3037801,'2135','322',413141.10,420285.00,0.00,0.00,7143.90,1495528.80,0.00,0.00,0.00),('1','141','764','152633',3040622,'2135','322',420285.00,423587.90,0.00,0.00,3302.90,695924.00,0.00,0.00,0.00),('1','141','764','152804',3043614,'2135','322',423587.90,428497.30,0.00,0.00,4909.40,1029140.00,0.00,0.00,0.00),('1','141','764','152966',3046654,'2135','322',428497.30,428497.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','152968',3046671,'2135','322',428497.30,436423.20,0.00,0.00,7925.90,1660870.40,0.00,0.00,0.00),('1','141','764','153211',3051016,'2135','322',436423.20,441233.90,0.00,0.00,4810.70,1010324.00,0.00,0.00,0.00),('1','141','764','153503',3056237,'2135','322',441233.90,442769.70,0.00,0.00,1535.80,322456.00,0.00,0.00,0.00),('1','141','764','153621',3058504,'2135','322',442769.70,451984.40,0.00,0.00,9214.70,1945328.00,0.00,0.00,0.00),('1','141','764','153799',3061598,'2135','322',451984.40,458975.10,0.00,0.00,6990.70,1480003.00,0.00,0.00,0.00),('1','141','764','153925',3063903,'2135','322',458975.10,465416.90,0.00,0.00,6441.80,1359792.00,0.00,0.00,0.00),('1','141','764','154199',3068507,'2135','322',465416.90,480900.20,0.00,0.00,15483.30,3263862.00,0.00,0.00,0.00),('1','141','764','154315',3070668,'2135','322',480900.20,489123.60,0.00,0.00,8223.40,1732318.00,0.00,0.00,0.00),('1','141','764','154608',3076263,'2135','322',489123.60,496866.60,0.00,0.00,7743.00,1636026.00,0.00,0.00,0.00),('1','141','764','154757',3079082,'2135','322',496866.60,503880.00,0.00,0.00,7013.40,1480822.00,0.00,0.00,0.00),('1','141','764','154883',3081358,'2135','322',503880.00,511695.80,0.00,0.00,7815.80,1652294.00,0.00,0.00,0.00),('1','141','764','155021',3084040,'2135','322',511695.80,515770.20,0.00,0.00,4074.40,865067.00,0.00,0.00,0.00),('1','141','764','155310',3089470,'2135','322',515770.20,529441.10,0.00,0.00,13670.90,2882229.00,0.00,0.00,0.00),('1','141','764','155459',3092300,'2135','322',529441.10,534038.10,0.00,0.00,4597.00,975415.00,0.00,0.00,0.00),('1','141','764','155651',3095754,'2135','322',534038.10,545971.90,0.00,0.00,11933.80,2516199.00,0.00,0.00,0.00),('1','141','764','155793',3098307,'2135','322',545971.90,556685.40,0.00,0.00,10713.50,2259460.00,0.00,0.00,0.00),('1','141','764','155937',3100827,'2135','322',556685.40,561647.30,0.00,0.00,4961.90,1049517.00,0.00,0.00,0.00),('1','141','764','156167',3104998,'2135','322',561647.30,570079.80,0.00,0.00,8432.50,1781465.00,0.00,0.00,0.00),('1','141','764','156271',3106822,'2135','322',570079.80,580169.80,0.00,0.00,10090.00,2126334.00,0.00,0.00,0.00),('1','141','764','156872',3118046,'2135','322',580169.80,592563.20,0.00,0.00,12393.40,2612232.00,0.00,0.00,0.00),('1','141','764','156890',3118310,'2135','322',592563.20,598829.60,0.00,0.00,6266.40,1326073.00,0.00,0.00,0.00),('1','141','764','156995',3120207,'2135','322',598829.60,603100.30,0.00,0.00,4270.70,904316.00,0.00,0.00,0.00),('1','141','764','157496',3128709,'2135','322',603100.30,603100.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','157497',3128710,'2135','322',603100.30,613386.10,0.00,0.00,10285.80,2172317.00,0.00,0.00,0.00),('1','141','764','157678',3132125,'2135','322',613386.10,619714.60,0.00,0.00,6328.50,1341515.00,0.00,0.00,0.00),('1','141','764','157820',3134749,'2135','322',619714.60,622601.90,0.00,0.00,2887.30,609259.00,0.00,0.00,0.00),('1','141','764','158077',3139640,'2135','322',622601.90,629723.60,0.00,0.00,7121.70,1499932.00,0.00,0.00,0.00),('1','141','764','158080',3139674,'2135','322',629723.60,634620.20,0.00,0.00,4896.60,1038618.00,0.00,0.00,0.00),('1','141','764','158573',3148697,'2135','322',634620.20,645196.60,0.00,0.00,10576.40,2226763.00,0.00,0.00,0.00),('1','141','764','159288',3161507,'2135','322',645196.60,648365.30,0.00,0.00,3168.70,725568.00,0.00,0.00,0.00),('1','141','764','159464',3164230,'2135','322',648365.30,651950.70,0.00,0.00,3585.40,821028.00,0.00,0.00,0.00),('1','141','764','159863',3171239,'2135','322',651950.70,658648.10,0.00,0.00,6697.40,1505448.00,0.00,0.00,0.00),('1','141','764','159865',3171241,'2135','322',658648.10,661401.90,0.00,0.00,2753.80,616851.20,0.00,0.00,0.00),('1','141','764','159933',3172626,'2135','322',661401.90,665245.30,0.00,0.00,3843.40,867115.20,0.00,0.00,0.00),('1','141','764','160119',3176183,'2135','322',665245.30,667704.00,0.00,0.00,2458.70,554484.00,0.00,0.00,0.00),('1','141','764','160304',3179363,'2135','322',667704.00,677856.90,0.00,0.00,10152.90,2279631.20,0.00,0.00,0.00),('1','141','764','160449',3182072,'2135','322',677856.90,686292.20,0.00,0.00,8435.30,1893724.00,0.00,0.00,0.00),('1','141','764','160605',3184724,'2135','322',686292.20,690237.00,0.00,0.00,3944.80,886732.00,0.00,0.00,0.00),('1','141','764','160888',3189529,'2135','322',690237.00,694070.20,0.00,0.00,3833.20,896012.00,0.00,0.00,0.00),('1','141','764','161088',3193157,'2135','322',694070.20,702874.10,0.00,0.00,8803.90,2058509.10,0.00,0.00,0.00),('1','141','764','161304',3196846,'2135','322',702874.10,710258.70,0.00,0.00,7384.60,1727149.50,0.00,0.00,0.00),('1','141','764','161446',3199429,'2135','322',710258.70,712824.50,0.00,0.00,2565.80,600750.10,0.00,0.00,0.00),('1','141','764','161697',3203293,'2135','322',712824.50,726972.70,0.00,0.00,14148.20,3306137.40,0.00,0.00,0.00),('1','141','764','161830',3205952,'2135','322',726972.70,726972.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','161834',3206021,'2135','322',726972.70,726972.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','161839',3206088,'2135','322',726972.70,726972.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','161844',3206175,'2135','322',726972.70,726972.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','161847',3206193,'2135','322',726972.70,726972.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','161857',3206329,'2135','322',726972.70,732750.30,0.00,0.00,5777.60,1351684.50,0.00,0.00,0.00),('1','141','764','162107',3210853,'2135','322',732750.30,735387.40,0.00,0.00,2637.10,617574.50,0.00,0.00,0.00),('1','141','764','162110',3210898,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162112',3210917,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162117',3211010,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162119',3211035,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162120',3211036,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162121',3211037,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162125',3211089,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162139',3211284,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162140',3211285,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162146',3211361,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162155',3211494,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162159',3211539,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162161',3211561,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162165',3211649,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162171',3211791,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162179',3211980,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162185',3212129,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162299',3213953,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162300',3213954,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162301',3213955,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162302',3213956,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162490',3217217,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162491',3217218,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162492',3217219,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162493',3217220,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162495',3217246,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162496',3217247,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162502',3217332,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162507',3217420,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162511',3217476,'2135','322',735387.40,735387.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162519',3217591,'2135','322',735387.40,752714.60,0.00,0.00,17327.20,4045862.10,0.00,0.00,0.00),('1','141','764','162636',3219625,'2135','322',752714.60,757969.60,0.00,0.00,5255.00,1228358.30,0.00,0.00,0.00),('1','141','764','162677',3220231,'2135','322',757969.60,757969.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','162802',3222649,'2135','322',757969.60,764435.30,0.00,0.00,6465.70,1512604.00,0.00,0.00,0.00),('1','141','764','163026',3226504,'2135','322',764435.30,770610.50,0.00,0.00,6175.20,1445011.50,0.00,0.00,0.00),('1','141','764','163193',3229668,'2135','322',770610.50,777453.20,0.00,0.00,6842.70,1599317.00,0.00,0.00,0.00),('1','141','764','163237',3230297,'2135','322',777453.20,779380.70,0.00,0.00,1927.50,452938.00,0.00,0.00,0.00),('1','141','764','163581',3236495,'2135','322',779380.70,779380.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','163742',3239451,'2135','322',779380.70,798922.90,0.00,0.00,19542.20,4560608.20,0.00,0.00,0.00),('1','141','764','163791',3240213,'2135','322',798922.90,798922.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','163937',3242807,'2135','322',798922.90,802781.40,0.00,0.00,3858.50,903331.00,0.00,0.00,0.00),('1','141','764','163939',3242839,'2135','322',802781.40,808664.10,0.00,0.00,5882.70,1474746.00,0.00,0.00,0.00),('1','141','764','164127',3246204,'2135','322',808664.10,815008.50,0.00,0.00,6344.40,1590279.00,0.00,0.00,0.00),('1','141','764','164433',3252172,'2135','322',815008.50,821467.00,0.00,0.00,6458.50,1617970.00,0.00,0.00,0.00),('1','141','764','164797',3258520,'2135','322',821467.00,821467.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','164809',3258754,'2135','322',821467.00,828810.90,0.00,0.00,7343.90,1839182.00,0.00,0.00,0.00),('1','141','764','165055',3263114,'2135','322',828810.90,839845.20,0.00,0.00,11034.30,2762454.00,0.00,0.00,0.00),('1','141','764','165164',3264983,'2135','322',839845.20,843850.90,0.00,0.00,4005.70,1086516.00,0.00,0.00,0.00),('1','141','764','165343',3268021,'2135','322',843850.90,843850.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','165360',3268353,'2135','322',843850.90,853550.30,0.00,0.00,9699.40,2623472.00,0.00,0.00,0.00),('1','141','764','165515',3271004,'2135','322',853550.30,860673.00,0.00,0.00,7122.70,1926069.00,0.00,0.00,0.00),('1','141','764','165675',3273917,'2135','322',860673.00,866396.20,0.00,0.00,5723.20,1549754.50,0.00,0.00,0.00),('1','141','764','166207',3283472,'2135','322',866396.20,866396.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','166219',3283637,'2135','322',866396.20,875247.80,0.00,0.00,8851.60,2394118.00,0.00,0.00,0.00),('1','141','764','166354',3286224,'2135','322',875247.80,881925.50,0.00,0.00,6677.70,1806808.00,0.00,0.00,0.00),('1','141','764','166495',3288942,'2135','322',881925.50,888778.10,0.00,0.00,6852.60,1820203.00,0.00,0.00,0.00),('1','141','764','166737',3292955,'2135','322',888778.10,888778.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','166743',3293035,'2135','322',888778.10,894352.40,0.00,0.00,5574.30,1482609.50,0.00,0.00,0.00),('1','141','764','166915',3295924,'2135','322',894352.40,900010.80,0.00,0.00,5658.40,1505112.00,0.00,0.00,0.00),('1','141','764','167037',3298327,'2135','322',900010.80,905257.30,0.00,0.00,5246.50,1397402.50,0.00,0.00,0.00),('1','141','764','167376',3304290,'2135','322',905257.30,911599.00,0.00,0.00,6341.70,1685754.50,0.00,0.00,0.00),('1','141','764','167569',3307890,'2135','322',911599.00,911599.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','167573',3307914,'2135','322',911599.00,920140.70,0.00,0.00,8541.70,2270058.50,0.00,0.00,0.00),('1','141','764','167738',3310804,'2135','322',920140.70,925932.10,0.00,0.00,5791.40,1539597.00,0.00,0.00,0.00),('1','141','764','167915',3313896,'2135','322',925932.10,931779.40,0.00,0.00,5847.30,1554826.50,0.00,0.00,0.00),('1','141','764','168122',3317919,'2135','322',931779.40,934156.80,0.00,0.00,2377.40,635927.00,0.00,0.00,0.00),('1','141','764','168124',3317942,'2135','322',934156.80,934156.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','168288',3320925,'2135','322',934156.80,941706.90,0.00,0.00,7550.10,2005520.50,0.00,0.00,0.00),('1','141','764','168613',3326808,'2135','322',941706.90,956622.60,0.00,0.00,14915.70,3959088.50,0.00,0.00,0.00),('1','141','764','168778',3329796,'2135','322',956622.60,956622.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','168796',3330018,'2135','322',956622.60,976193.60,0.00,0.00,19571.00,5160756.00,0.00,0.00,0.00),('1','141','764','168931',3332359,'2135','322',976193.60,981135.40,0.00,0.00,4941.80,1386361.50,0.00,0.00,0.00),('1','141','764','169200',3337199,'2135','322',981135.40,981135.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','169205',3337294,'2135','322',981135.40,1005094.90,0.00,0.00,23959.50,6713777.50,0.00,0.00,0.00),('1','141','764','169245',3338182,'2135','322',1005094.90,1005394.90,0.00,0.00,300.00,84000.00,0.00,0.00,0.00),('1','141','764','169452',3342231,'2135','322',1005394.90,1005394.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','169453',3342232,'2135','322',1005394.90,1020137.70,0.00,0.00,14742.80,4131429.00,0.00,0.00,0.00),('1','141','764','169773',3348199,'2135','322',1020137.70,1026557.00,0.00,0.00,6419.30,1800136.50,0.00,0.00,0.00),('1','141','764','169776',3348230,'2135','322',1026557.00,1029663.30,0.00,0.00,3106.30,889747.00,0.00,0.00,0.00),('1','141','764','169990',3352285,'2135','322',1029663.30,1029663.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','169999',3352457,'2135','322',1029663.30,1042146.40,0.00,0.00,12483.10,3574074.90,0.00,0.00,0.00),('1','141','764','170229',3356427,'2135','322',1042146.40,1048647.60,0.00,0.00,6501.20,1862187.50,0.00,0.00,0.00),('1','141','764','170332',3358234,'2135','322',1048647.60,1053991.60,0.00,0.00,5344.00,1531253.00,0.00,0.00,0.00),('1','141','764','170567',3362446,'2135','322',1053991.60,1053991.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','170587',3362732,'2135','322',1053991.60,1060553.30,0.00,0.00,6561.70,1879154.20,0.00,0.00,0.00),('1','141','764','170670',3364322,'2135','322',1060553.30,1066221.50,0.00,0.00,5668.20,1623037.50,0.00,0.00,0.00),('1','141','764','171000',3370132,'2135','322',1066221.50,1074725.40,0.00,0.00,8503.90,2436025.60,0.00,0.00,0.00),('1','141','764','171214',3374175,'2135','322',1074725.40,1078513.20,0.00,0.00,3787.80,1085796.00,0.00,0.00,0.00),('1','141','764','171369',3377002,'2135','322',1078513.20,1078513.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','171374',3377068,'2135','322',1078513.20,1089464.80,0.00,0.00,10951.60,3137116.60,0.00,0.00,0.00),('1','141','764','171576',3380717,'2135','322',1089464.80,1096997.40,0.00,0.00,7532.60,2157796.80,0.00,0.00,0.00),('1','141','764','171760',3384019,'2135','322',1096997.40,1103150.90,0.00,0.00,6153.50,1762722.50,0.00,0.00,0.00),('1','141','764','171940',3387183,'2135','322',1103150.90,1103150.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','171942',3387200,'2135','322',1103150.90,1111064.00,0.00,0.00,7913.10,2266112.50,0.00,0.00,0.00),('1','141','764','172272',3393211,'2135','322',1111064.00,1123273.50,0.00,0.00,12209.50,3495589.70,0.00,0.00,0.00),('1','141','764','172483',3397085,'2135','322',1123273.50,1127444.70,0.00,0.00,4171.20,1195541.50,0.00,0.00,0.00),('1','141','764','172741',3401732,'2135','322',1127444.70,1127444.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','172751',3401914,'2135','322',1127444.70,1138203.60,0.00,0.00,10758.90,3079163.90,0.00,0.00,0.00),('1','141','764','172865',3404035,'2135','322',1138203.60,1140456.50,0.00,0.00,2252.90,646324.40,0.00,0.00,0.00),('1','141','764','173047',3407469,'2135','322',1140456.50,1147997.00,0.00,0.00,7540.50,2159984.00,0.00,0.00,0.00),('1','141','764','173363',3413555,'2135','322',1147997.00,1151837.30,0.00,0.00,3840.30,1102882.00,0.00,0.00,0.00),('1','141','764','173591',3417760,'2135','322',1151837.30,1151837.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','173595',3417783,'2135','322',1151837.30,1170069.10,0.00,0.00,18231.80,5218947.90,0.00,0.00,0.00),('1','141','764','173743',3420544,'2135','322',1170069.10,1176237.00,0.00,0.00,6167.90,1771134.90,0.00,0.00,0.00),('1','141','764','173941',3424080,'2135','322',1176237.00,1176237.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','174195',3428601,'2135','322',1176237.00,1184196.90,0.00,0.00,7959.90,2279886.80,0.00,0.00,0.00),('1','141','764','174221',3429127,'2135','322',1184196.90,1192188.40,0.00,0.00,7991.50,2290009.30,0.00,0.00,0.00),('1','141','764','174366',3431535,'2135','322',1192188.40,1200672.30,0.00,0.00,8483.90,2430345.50,0.00,0.00,0.00),('1','141','764','174491',3433762,'2135','322',1200672.30,1200672.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','174580',3435344,'2135','322',1200672.30,1206836.10,0.00,0.00,6163.80,1767501.80,0.00,0.00,0.00),('1','141','764','175006',3443383,'2135','322',1206836.10,1219050.20,0.00,0.00,12214.10,3497241.60,0.00,0.00,0.00),('1','141','764','175039',3443987,'2135','322',1219050.20,1224893.20,0.00,0.00,5843.00,1717723.60,0.00,0.00,0.00),('1','141','764','175043',3443993,'2135','322',1224893.20,1224893.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','175773',3457226,'2135','322',1224893.20,1230043.00,0.00,0.00,5149.80,1553500.80,0.00,0.00,0.00),('1','141','764','175779',3457301,'2135','322',1230043.00,1237542.20,0.00,0.00,7499.20,2259357.60,0.00,0.00,0.00),('1','141','764','175781',3457314,'2135','322',1237542.20,1244080.10,0.00,0.00,6537.90,1972173.60,0.00,0.00,0.00),('1','141','764','176288',3466672,'2135','322',1244080.10,1249049.20,0.00,0.00,4969.10,1499704.80,0.00,0.00,0.00),('1','141','764','176295',3466823,'2135','322',1249049.20,1249049.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','176309',3467114,'2135','322',1249049.20,1258835.80,0.00,0.00,9786.60,2944303.20,0.00,0.00,0.00),('1','141','764','176523',3471105,'2135','322',1258835.80,1263880.50,0.00,0.00,5044.70,1520653.20,0.00,0.00,0.00),('1','141','764','176751',3475239,'2135','322',1263880.50,1270343.70,0.00,0.00,6463.20,1947927.60,0.00,0.00,0.00),('1','141','764','176947',3478915,'2135','322',1270343.70,1273569.10,0.00,0.00,3225.40,978074.40,0.00,0.00,0.00),('1','141','764','177280',3485192,'2135','322',1273569.10,1273569.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','177286',3485304,'2135','322',1273569.10,1281152.20,0.00,0.00,7583.10,2285380.80,0.00,0.00,0.00),('1','141','764','177730',3494180,'2135','322',1281152.20,1291138.90,0.00,0.00,9986.70,3004671.60,0.00,0.00,0.00),('1','141','764','177930',3497639,'2135','322',1291138.90,1293230.00,0.00,0.00,2091.10,632085.60,0.00,0.00,0.00),('1','141','764','178162',3502352,'2135','322',1293230.00,1293230.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','178168',3502438,'2135','322',1293230.00,1300542.30,0.00,0.00,7312.30,2202542.40,0.00,0.00,0.00),('1','141','764','178304',3504794,'2135','322',1300542.30,1305075.80,0.00,0.00,4533.50,1368636.00,0.00,0.00,0.00),('1','141','764','178716',3512573,'2135','322',1305075.80,1315506.60,0.00,0.00,10430.80,3137214.00,0.00,0.00,0.00),('1','141','764','178720',3512579,'2135','322',1315506.60,1317606.50,0.00,0.00,2099.90,653813.40,0.00,0.00,0.00),('1','141','764','178722',3512582,'2135','322',1317606.50,1317606.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','179284',3523067,'2135','322',1317606.50,1321759.50,0.00,0.00,4153.00,1287430.00,0.00,0.00,0.00),('1','141','764','179292',3523200,'2135','322',1321759.50,1330203.30,0.00,0.00,8443.80,2624600.60,0.00,0.00,0.00),('1','141','764','179442',3525892,'2135','322',1330203.30,1334792.60,0.00,0.00,4589.30,1426499.80,0.00,0.00,0.00),('1','141','764','179558',3528314,'2135','322',1334792.60,1339611.00,0.00,0.00,4818.40,1499616.40,0.00,0.00,0.00),('1','141','764','179798',3532724,'2135','322',1339611.00,1341761.00,0.00,0.00,2150.00,670400.00,0.00,0.00,0.00),('1','141','764','179998',3536471,'2135','322',1341761.00,1341761.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','180000',3536513,'2135','322',1341761.00,1346810.90,0.00,0.00,5049.90,1573139.00,0.00,0.00,0.00),('1','141','764','180236',3540999,'2135','322',1346810.90,1352026.70,0.00,0.00,5215.80,1622732.40,0.00,0.00,0.00),('1','141','764','180566',3546846,'2135','322',1352026.70,1365237.40,0.00,0.00,13210.70,4099118.20,0.00,0.00,0.00),('1','141','764','180777',3550736,'2135','322',1365237.40,1365237.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','180846',3551951,'2135','322',1365237.40,1378576.40,0.00,0.00,13339.00,4142913.40,0.00,0.00,0.00),('1','141','764','180984',3554769,'2135','322',1378576.40,1388587.90,0.00,0.00,10011.50,3109922.00,0.00,0.00,0.00),('1','141','764','180988',3554802,'2135','322',1388587.90,1388587.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','181511',3564998,'2135','322',1388587.90,1394079.90,0.00,0.00,5492.00,1710151.00,0.00,0.00,0.00),('1','141','764','181512',3564999,'2135','322',1394079.90,1403134.20,0.00,0.00,9054.30,2810831.80,0.00,0.00,0.00),('1','141','764','182006',3573471,'2135','322',1403134.20,1412698.20,0.00,0.00,9564.00,2970432.60,0.00,0.00,0.00),('1','141','764','182237',3577799,'2135','322',1412698.20,1424733.40,0.00,0.00,12035.20,3736598.20,0.00,0.00,0.00),('1','141','764','182276',3578483,'2135','322',1424733.40,1430385.50,0.00,0.00,5652.10,1767883.60,0.00,0.00,0.00),('1','141','764','182334',3579199,'2135','322',1430385.50,1437789.19,0.00,0.00,7403.69,2311853.84,0.00,0.00,0.00),('1','141','764','182665',3585619,'2135','322',1437789.19,1446245.39,0.00,0.00,8456.20,2637456.20,0.00,0.00,0.00),('1','141','764','182845',3588854,'2135','322',1446245.39,1457457.01,0.00,0.00,11211.62,3489853.32,0.00,0.00,0.00),('1','141','764','182989',3591453,'2135','322',1457457.01,1462683.01,0.00,0.00,5226.00,1625928.20,0.00,0.00,0.00),('1','141','764','183065',3592961,'2135','322',1462683.01,1462683.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','183074',3593117,'2135','322',1462683.01,1470286.77,0.00,0.00,7603.76,2369925.36,0.00,0.00,0.00),('1','141','764','183242',3595907,'2135','322',1470286.77,1483595.67,0.00,0.00,13308.90,4142201.40,0.00,0.00,0.00),('1','141','764','183453',3599708,'2135','322',1483595.67,1487346.47,0.00,0.00,3750.80,1167006.80,0.00,0.00,0.00),('1','141','764','183689',3603985,'2135','322',1487346.47,1503167.67,0.00,0.00,15821.20,4921139.20,0.00,0.00,0.00),('1','141','764','183841',3607046,'2135','322',1503167.67,1503167.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','183945',3608827,'2135','322',1503167.67,1507343.37,0.00,0.00,4175.70,1338579.20,0.00,0.00,0.00),('1','141','764','184089',3611431,'2135','322',1507343.37,1507343.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','184095',3611532,'2135','322',1507343.37,1519609.97,0.00,0.00,12266.60,3933763.20,0.00,0.00,0.00),('1','141','764','184453',3617885,'2135','322',1519609.97,1531958.57,0.00,0.00,12348.60,3961046.40,0.00,0.00,0.00),('1','141','764','184780',3623817,'2135','322',1531958.57,1531958.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','184993',3627512,'2135','322',1531958.57,1538483.87,0.00,0.00,6525.30,2096622.40,0.00,0.00,0.00),('1','141','764','185195',3631092,'2135','322',1538483.87,1544966.67,0.00,0.00,6482.80,2080180.80,0.00,0.00,0.00),('1','141','764','185204',3631219,'2135','322',1544966.67,1556442.27,0.00,0.00,11475.60,3681025.60,0.00,0.00,0.00),('1','141','764','185595',3638184,'2135','322',1556442.27,1556442.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','185618',3638644,'2135','322',1556442.27,1566945.27,0.00,0.00,10503.00,3371497.60,0.00,0.00,0.00),('1','141','764','186030',3645814,'2135','322',1566945.27,1579135.67,0.00,0.00,12190.40,3910035.20,0.00,0.00,0.00),('1','141','764','186118',3647374,'2135','322',1579135.67,1579135.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','186158',3648003,'2135','322',1579135.67,1587440.62,0.00,0.00,8304.95,2668088.80,0.00,0.00,0.00),('1','141','764','186426',3652415,'2135','322',1587440.62,1595244.01,0.00,0.00,7803.39,2503979.04,0.00,0.00,0.00),('1','141','764','186614',3655807,'2135','322',1595244.01,1601345.18,0.00,0.00,6101.17,1958617.12,0.00,0.00,0.00),('1','141','764','186863',3660153,'2135','322',1601345.18,1603867.48,0.00,0.00,2522.30,810156.80,0.00,0.00,0.00),('1','141','764','187097',3663919,'2135','322',1603867.48,1603867.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','187099',3663944,'2135','322',1603867.48,1612917.28,0.00,0.00,9049.80,2905644.80,0.00,0.00,0.00),('1','141','764','187364',3668682,'2135','322',1612917.28,1623334.32,0.00,0.00,10417.04,3343346.24,0.00,0.00,0.00),('1','141','764','187605',3672904,'2135','322',1623334.32,1627712.31,0.00,0.00,4377.99,1406388.64,0.00,0.00,0.00),('1','141','764','187849',3677169,'2135','322',1627712.31,1627712.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','187871',3677570,'2135','322',1627712.31,1633190.49,0.00,0.00,5478.18,1760052.48,0.00,0.00,0.00),('1','141','764','188039',3680517,'2135','322',1633190.49,1640663.59,0.00,0.00,7473.10,2399561.60,0.00,0.00,0.00),('1','141','764','188227',3683780,'2135','322',1640663.59,1646143.34,0.00,0.00,5479.75,1758940.00,0.00,0.00,0.00),('1','141','764','188444',3687427,'2135','322',1646143.34,1646143.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','188456',3687656,'2135','322',1646143.34,1662312.57,0.00,0.00,16169.23,5183512.48,0.00,0.00,0.00),('1','141','764','188813',3693994,'2135','322',1662312.57,1671351.67,0.00,0.00,9039.10,2899073.60,0.00,0.00,0.00),('1','141','764','189021',3697784,'2135','322',1671351.67,1671351.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','189024',3697824,'2135','322',1671351.67,1689973.67,0.00,0.00,18622.00,5970376.00,0.00,0.00,0.00),('1','141','764','189220',3701187,'2135','322',1689973.67,1696166.61,0.00,0.00,6192.94,1985755.84,0.00,0.00,0.00),('1','141','764','189438',3705239,'2135','322',1696166.61,1696166.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','189444',3705323,'2135','322',1696166.61,1705548.00,0.00,0.00,9381.39,3010601.44,0.00,0.00,0.00),('1','141','764','189644',3708777,'2135','322',1705548.00,1713268.23,0.00,0.00,7720.23,2478509.28,0.00,0.00,0.00),('1','141','764','189828',3712028,'2135','322',1713268.23,1719071.92,0.00,0.00,5803.69,1867710.24,0.00,0.00,0.00),('1','141','764','190143',3718315,'2135','322',1719071.92,1720802.62,0.00,0.00,1730.70,556715.20,0.00,0.00,0.00),('1','141','764','190154',3718536,'2135','322',1720802.62,1720802.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','190238',3720039,'2135','322',1720802.62,1730353.26,0.00,0.00,9550.64,3065183.04,0.00,0.00,0.00),('1','141','764','190450',3723947,'2135','322',1730353.26,1738092.44,0.00,0.00,7739.18,2485116.48,0.00,0.00,0.00),('1','141','764','190675',3728187,'2135','322',1738092.44,1745646.50,0.00,0.00,7554.06,2425096.96,0.00,0.00,0.00),('1','141','764','190911',3732415,'2135','322',1745646.50,1745646.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','190919',3732543,'2135','322',1745646.50,1751551.67,0.00,0.00,5905.17,1898150.72,0.00,0.00,0.00),('1','141','764','191071',3735436,'2135','322',1751551.67,1757031.43,0.00,0.00,5479.76,1758931.20,0.00,0.00,0.00),('1','141','764','191074',3735454,'2135','322',1757031.43,1763224.38,0.00,0.00,6192.95,1985753.60,0.00,0.00,0.00),('1','141','764','191077',3735457,'2135','322',1763224.38,1768959.81,0.00,0.00,5735.43,1843424.48,0.00,0.00,0.00),('1','141','764','191752',3747739,'2135','322',1768959.81,1768959.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','191959',3751813,'2135','322',1768959.81,1768959.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','191966',3751893,'2135','322',1768959.81,1768959.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','191973',3751987,'2135','322',1768959.81,1783671.79,0.00,0.00,14711.98,4716322.88,0.00,0.00,0.00),('1','141','764','192145',3755090,'2135','322',1783671.79,1790913.19,0.00,0.00,7241.40,2325550.40,0.00,0.00,0.00),('1','141','764','192361',3759119,'2135','322',1790913.19,1790913.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','192369',3759195,'2135','322',1790913.19,1793703.72,0.00,0.00,2790.53,895002.08,0.00,0.00,0.00),('1','141','764','192609',3763475,'2135','322',1793703.72,1793703.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','192651',3764229,'2135','322',1793703.72,1799950.92,0.00,0.00,6247.20,2005515.20,0.00,0.00,0.00),('1','141','764','192792',3766687,'2135','322',1799950.92,1804713.13,0.00,0.00,4762.21,1531888.96,0.00,0.00,0.00),('1','141','764','193187',3774214,'2135','322',1804713.13,1814069.17,0.00,0.00,9356.04,3003573.44,0.00,0.00,0.00),('1','141','764','193428',3779052,'2135','322',1814069.17,1818449.44,0.00,0.00,4380.27,1403138.72,0.00,0.00,0.00),('1','141','764','193635',3782929,'2135','322',1818449.44,1818449.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','193639',3782988,'2135','322',1818449.44,1827882.15,0.00,0.00,9432.71,3027820.96,0.00,0.00,0.00),('1','141','764','193903',3787561,'2135','322',1827882.15,1834600.09,0.00,0.00,6717.94,2124558.24,0.00,0.00,0.00),('1','141','764','194101',3791094,'2135','322',1834600.09,1840781.15,0.00,0.00,6181.06,1958192.46,0.00,0.00,0.00),('1','141','764','194315',3795170,'2135','322',1840781.15,1843084.66,0.00,0.00,2303.51,730267.86,0.00,0.00,0.00),('1','141','764','194426',3797233,'2135','322',1843084.66,1843084.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','194429',3797303,'2135','322',1843084.66,1846446.86,0.00,0.00,3362.20,1064036.40,0.00,0.00,0.00),('1','141','764','194713',3802252,'2135','322',1846446.86,1859172.01,0.00,0.00,12725.15,4021151.40,0.00,0.00,0.00),('1','141','764','194885',3805958,'2135','322',1859172.01,1867846.80,0.00,0.00,8674.79,2746172.94,0.00,0.00,0.00),('1','141','764','195119',3810019,'2135','322',1867846.80,1867846.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','195131',3810242,'2135','322',1867846.80,1875275.08,0.00,0.00,7428.28,2351457.78,0.00,0.00,0.00),('1','141','764','195317',3813445,'2135','322',1875275.08,1881765.98,0.00,0.00,6490.90,2056370.40,0.00,0.00,0.00),('1','141','764','195554',3817583,'2135','322',1881765.98,1888661.75,0.00,0.00,6895.77,2184932.82,0.00,0.00,0.00),('1','141','764','195811',3821951,'2135','322',1888661.75,1892620.79,0.00,0.00,3959.04,1253639.94,0.00,0.00,0.00),('1','141','764','196249',3830155,'2135','322',1892620.79,1892620.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','196253',3830183,'2135','322',1892620.79,1904885.47,0.00,0.00,12264.68,3878857.08,0.00,0.00,0.00),('1','141','764','196479',3834244,'2135','322',1904885.47,1914934.73,0.00,0.00,10049.26,3180648.66,0.00,0.00,0.00),('1','141','764','196684',3837907,'2135','322',1914934.73,1917328.83,0.00,0.00,2394.10,758312.10,0.00,0.00,0.00),('1','141','764','197042',3844362,'2135','322',1917328.83,1917328.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','197097',3845292,'2135','322',1917328.83,1926820.05,0.00,0.00,9491.22,3003542.22,0.00,0.00,0.00),('1','141','764','197722',3856036,'2135','322',1926820.05,1934415.25,0.00,0.00,7595.20,2405669.70,0.00,0.00,0.00),('1','141','764','197799',3857545,'2135','322',1934415.25,1941997.75,0.00,0.00,7582.50,2399806.50,0.00,0.00,0.00),('1','141','764','197913',3859463,'2135','322',1941997.75,1941997.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','197937',3859862,'2135','322',1941997.75,1948841.66,0.00,0.00,6843.91,2168650.26,0.00,0.00,0.00),('1','141','764','198134',3863291,'2135','322',1948841.66,1952668.76,0.00,0.00,3827.10,1218180.60,0.00,0.00,0.00),('1','141','764','198375',3867351,'2135','322',1952668.76,1958209.70,0.00,0.00,5540.94,1721125.84,0.00,0.00,0.00),('1','141','764','198589',3871059,'2135','322',1958209.70,1964324.67,0.00,0.00,6114.97,1900915.52,0.00,0.00,0.00),('1','141','764','198815',3874776,'2135','322',1964324.67,1966697.30,0.00,0.00,2372.63,738949.68,0.00,0.00,0.00),('1','141','764','199245',3882422,'2135','322',1966697.30,1966697.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','199250',3882482,'2135','322',1966697.30,1979404.06,0.00,0.00,12706.76,3896116.66,0.00,0.00,0.00),('1','141','764','199462',3885802,'2135','322',1979404.06,1984918.30,0.00,0.00,5514.24,1695599.14,0.00,0.00,0.00),('1','141','764','199683',3889492,'2135','322',1984918.30,1989700.48,0.00,0.00,4782.18,1478611.98,0.00,0.00,0.00),('1','141','764','199885',3892715,'2135','322',1989700.48,1991510.61,0.00,0.00,1810.13,556433.68,0.00,0.00,0.00),('1','141','764','200116',3896973,'2135','322',1991510.61,1991510.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','200121',3897067,'2135','322',1991510.61,2001073.57,0.00,0.00,9562.96,2933289.66,0.00,0.00,0.00),('1','141','764','200318',3900522,'2135','322',2001073.57,2006335.32,0.00,0.00,5261.75,1625304.60,0.00,0.00,0.00),('1','141','764','200720',3907898,'2135','322',2006335.32,2016392.48,0.00,0.00,10057.16,3084575.56,0.00,0.00,0.00),('1','141','764','200944',3911728,'2135','322',2016392.48,2016392.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','200958',3911899,'2135','322',2016392.48,2024307.29,0.00,0.00,7914.81,2434334.76,0.00,0.00,0.00),('1','141','764','201142',3914957,'2135','322',2024307.29,2031905.03,0.00,0.00,7597.74,2337235.64,0.00,0.00,0.00),('1','141','764','201333',3918263,'2135','322',2031905.03,2039892.33,0.00,0.00,7987.30,2456037.80,0.00,0.00,0.00),('1','141','764','201524',3921750,'2135','322',2039892.33,2041022.83,0.00,0.00,1130.50,347096.50,0.00,0.00,0.00),('1','141','764','201695',3925479,'2135','322',2041022.83,2041022.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','201703',3925589,'2135','322',2041022.83,2051442.23,0.00,0.00,10419.40,3196743.30,0.00,0.00,0.00),('1','141','764','201774',3926739,'2135','322',2051442.23,2061583.20,0.00,0.00,10140.97,3112493.92,0.00,0.00,0.00),('1','141','764','202239',3935043,'2135','322',2061583.20,2064663.70,0.00,0.00,3080.50,945737.00,0.00,0.00,0.00),('1','141','764','202244',3935105,'2135','322',2064663.70,2064663.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','202256',3935262,'2135','322',2064663.70,2064663.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','202261',3935334,'2135','322',2064663.70,2076268.00,0.00,0.00,11604.30,3724380.80,0.00,0.00,0.00),('1','141','764','202453',3938752,'2135','322',2076268.00,2086771.20,0.00,0.00,10503.20,3370955.20,0.00,0.00,0.00),('1','141','764','202672',3942522,'2135','322',2086771.20,2089252.50,0.00,0.00,2481.30,796156.80,0.00,0.00,0.00),('1','141','764','202811',3945326,'2135','322',2089252.50,2089252.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','202890',3946416,'2135','322',2089252.50,2105596.00,0.00,0.00,16343.50,5240400.00,0.00,0.00,0.00),('1','141','764','203129',3951038,'2135','322',2105596.00,2113686.30,0.00,0.00,8090.30,2597316.80,0.00,0.00,0.00),('1','141','764','203378',3955691,'2135','322',2113686.30,2113686.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','203383',3955743,'2135','322',2113686.30,2120502.60,0.00,0.00,6816.30,2190588.80,0.00,0.00,0.00),('1','141','764','203749',3962206,'2135','322',2120502.60,2133932.60,0.00,0.00,13430.00,4308561.60,0.00,0.00,0.00),('1','141','764','203989',3966353,'2135','322',2133932.60,2138401.40,0.00,0.00,4468.80,1434284.80,0.00,0.00,0.00),('1','141','764','204211',3970535,'2135','322',2138401.40,2138401.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','204222',3970661,'2135','322',2138401.40,2150130.80,0.00,0.00,11729.40,3763136.00,0.00,0.00,0.00),('1','141','764','204433',3974471,'2135','322',2150130.80,2163015.10,0.00,0.00,12884.30,4130708.80,0.00,0.00,0.00),('1','141','764','204643',3978309,'2135','322',2163015.10,2163015.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','204651',3978423,'2135','322',2163015.10,2166180.64,0.00,0.00,3165.54,1048564.00,0.00,0.00,0.00),('1','141','764','204867',3981949,'2135','322',2166180.64,2174565.32,0.00,0.00,8384.68,2776136.80,0.00,0.00,0.00),('1','141','764','205270',3989225,'2135','322',2174565.32,2187691.23,0.00,0.00,13125.91,4328655.60,0.00,0.00,0.00),('1','141','764','205499',3993384,'2135','322',2187691.23,2187691.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','205501',3993386,'2135','322',2187691.23,2197956.61,0.00,0.00,10265.38,3364778.00,0.00,0.00,0.00),('1','141','764','205743',3997868,'2135','322',2197956.61,2203779.14,0.00,0.00,5822.53,1914554.20,0.00,0.00,0.00),('1','141','764','205981',4002106,'2135','322',2203779.14,2209964.21,0.00,0.00,6185.07,2033998.20,0.00,0.00,0.00),('1','141','764','206175',4005600,'2135','322',2209964.21,2212362.11,0.00,0.00,2397.90,787050.00,0.00,0.00,0.00),('1','141','764','206244',4006846,'2135','322',2212362.11,2212362.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','206247',4006905,'2135','322',2212362.11,2216192.22,0.00,0.00,3830.11,1261016.00,0.00,0.00,0.00),('1','141','764','206382',4009120,'2135','322',2216192.22,2223155.30,0.00,0.00,6963.08,2291655.40,0.00,0.00,0.00),('1','141','764','206851',4017290,'2135','322',2223155.30,2234370.93,0.00,0.00,11215.63,3674568.00,0.00,0.00,0.00),('1','141','764','207054',4021014,'2135','322',2234370.93,2236066.13,0.00,0.00,1695.20,557062.00,0.00,0.00,0.00),('1','141','764','207119',4022217,'2135','322',2236066.13,2236066.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','207127',4022350,'2135','322',2236066.13,2246061.08,0.00,0.00,9994.95,3274260.60,0.00,0.00,0.00),('1','141','764','207294',4025298,'2135','322',2246061.08,2260110.88,0.00,0.00,14049.80,4601025.80,0.00,0.00,0.00),('1','141','764','207639',4031638,'2135','322',2260110.88,2260110.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','207642',4031664,'2135','322',2260110.88,2263423.28,0.00,0.00,3312.40,1111691.00,0.00,0.00,0.00),('1','141','764','207727',4032875,'2135','322',2263423.28,2273435.04,0.00,0.00,10011.76,3426278.24,0.00,0.00,0.00),('1','141','764','207932',4036369,'2135','322',2273435.04,2282541.24,0.00,0.00,9106.20,3128681.20,0.00,0.00,0.00),('1','141','764','208375',4044338,'2135','322',2282541.24,2284786.24,0.00,0.00,2245.00,766358.00,0.00,0.00,0.00),('1','141','764','208391',4044601,'2135','322',2284786.24,2284786.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','208405',4044874,'2135','322',2284786.24,2303362.93,0.00,0.00,18576.69,6349456.96,0.00,0.00,0.00),('1','141','764','208552',4047481,'2135','322',2303362.93,2309475.50,0.00,0.00,6112.57,2087318.88,0.00,0.00,0.00),('1','141','764','208793',4051420,'2135','322',2309475.50,2309475.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','208798',4051472,'2135','322',2309475.50,2321849.22,0.00,0.00,12373.72,4351943.88,0.00,0.00,0.00),('1','141','764','209023',4055386,'2135','322',2321849.22,2332628.33,0.00,0.00,10779.11,3790134.24,0.00,0.00,0.00),('1','141','764','209230',4059146,'2135','322',2332628.33,2334183.41,0.00,0.00,1555.08,549839.72,0.00,0.00,0.00),('1','141','764','209308',4060522,'2135','322',2334183.41,2334183.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','209314',4060584,'2135','322',2334183.41,2337839.57,0.00,0.00,3656.16,1300554.44,0.00,0.00,0.00),('1','141','764','209459',4063124,'2135','322',2337839.57,2345247.59,0.00,0.00,7408.02,2619565.68,0.00,0.00,0.00),('1','141','764','209884',4070685,'2135','322',2345247.59,2356704.54,0.00,0.00,11456.95,4161232.00,0.00,0.00,0.00),('1','141','764','210120',4074912,'2135','322',2356704.54,2358885.04,0.00,0.00,2180.50,799210.00,0.00,0.00,0.00),('1','141','764','210340',4078799,'2135','322',2358885.04,2358885.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','210346',4078876,'2135','322',2358885.04,2374996.77,0.00,0.00,16111.73,5889438.80,0.00,0.00,0.00),('1','141','764','210502',4082060,'2135','322',2374996.77,2383497.77,0.00,0.00,8501.00,3115067.60,0.00,0.00,0.00),('1','141','764','210711',4085735,'2135','322',2383497.77,2383497.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','210746',4086142,'2135','322',2383497.77,2394240.22,0.00,0.00,10742.45,3929150.00,0.00,0.00,0.00),('1','141','764','210983',4090011,'2135','322',2394240.22,2408103.65,0.00,0.00,13863.43,5062618.84,0.00,0.00,0.00),('1','141','764','211102',4092405,'2135','322',2408103.65,2408103.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','211414',4097824,'2135','322',2408103.65,2418486.72,0.00,0.00,10383.07,3961578.10,0.00,0.00,0.00),('1','141','764','211746',4103740,'2135','322',2418486.72,2422345.52,0.00,0.00,3858.80,1470697.50,0.00,0.00,0.00),('1','141','764','211805',4104490,'2135','322',2422345.52,2432687.31,0.00,0.00,10341.79,3944815.80,0.00,0.00,0.00),('1','141','764','212341',4114153,'2135','322',2432687.31,2432687.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','212351',4114293,'2135','322',2432687.31,2441777.19,0.00,0.00,9089.88,3457269.40,0.00,0.00,0.00),('1','141','764','212497',4116916,'2135','322',2441777.19,2453819.69,0.00,0.00,12042.50,4589388.10,0.00,0.00,0.00),('1','141','764','212886',4123837,'2135','322',2453819.69,2457298.19,0.00,0.00,3478.50,1325055.00,0.00,0.00,0.00),('1','141','764','213056',4126879,'2135','322',2457298.19,2457298.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','213137',4128199,'2135','322',2457298.19,2478543.90,0.00,0.00,21245.71,8083870.80,0.00,0.00,0.00),('1','141','764','213394',4132400,'2135','322',2478543.90,2481902.15,0.00,0.00,3358.25,1279101.00,0.00,0.00,0.00),('1','141','764','213574',4135393,'2135','322',2481902.15,2481902.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','213653',4136706,'2135','322',2481902.15,2491698.56,0.00,0.00,9796.41,3739621.00,0.00,0.00,0.00),('1','141','764','213901',4140774,'2135','322',2491698.56,2500156.30,0.00,0.00,8457.74,3228022.80,0.00,0.00,0.00),('1','141','764','214106',4144214,'2135','322',2500156.30,2506498.21,0.00,0.00,6341.91,2418278.70,0.00,0.00,0.00),('1','141','764','214609',4152870,'2135','322',2506498.21,2506498.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','214615',4152938,'2135','322',2506498.21,2520411.10,0.00,0.00,13912.89,5298974.80,0.00,0.00,0.00),('1','141','764','214791',4156036,'2135','322',2520411.10,2529589.85,0.00,0.00,9178.75,3500015.00,0.00,0.00,0.00),('1','141','764','214968',4159178,'2135','322',2529589.85,2529589.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','215053',4160394,'2135','322',2529589.85,2537315.82,0.00,0.00,7725.97,2951536.00,0.00,0.00,0.00),('1','141','764','215294',4164568,'2135','322',2537315.82,2544902.35,0.00,0.00,7586.53,2895980.60,0.00,0.00,0.00),('1','141','764','215521',4168327,'2135','322',2544902.35,2551941.77,0.00,0.00,7039.42,2690896.90,0.00,0.00,0.00),('1','141','764','215761',4172498,'2135','322',2551941.77,2554066.77,0.00,0.00,2125.00,812345.00,0.00,0.00,0.00),('1','141','764','215814',4173576,'2135','322',2554066.77,2554066.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','215822',4173717,'2135','322',2554066.77,2561393.24,0.00,0.00,7326.47,2796615.90,0.00,0.00,0.00),('1','141','764','216135',4178883,'2135','322',2561393.24,2570600.34,0.00,0.00,9207.10,3497961.50,0.00,0.00,0.00),('1','141','764','216201',4180076,'2135','322',2570600.34,2576801.99,0.00,0.00,6201.65,2494006.00,0.00,0.00,0.00),('1','141','764','216357',4182713,'2135','322',2576801.99,2578669.79,0.00,0.00,1867.80,754972.00,0.00,0.00,0.00),('1','141','764','216582',4186553,'2135','322',2578669.79,2578669.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','216590',4186676,'2135','322',2578669.79,2589110.43,0.00,0.00,10440.64,4201881.60,0.00,0.00,0.00),('1','141','764','216823',4190932,'2135','322',2589110.43,2600133.19,0.00,0.00,11022.76,4435970.40,0.00,0.00,0.00),('1','141','764','217081',4195379,'2135','322',2600133.19,2603282.99,0.00,0.00,3149.80,1268800.00,0.00,0.00,0.00),('1','141','764','217735',4207056,'2135','322',2603282.99,2603282.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','217737',4207059,'2135','322',2603282.99,2616244.89,0.00,0.00,12961.90,5546769.40,0.00,0.00,0.00),('1','141','764','217989',4211790,'2135','322',2616244.89,2620929.59,0.00,0.00,4684.70,2023650.20,0.00,0.00,0.00),('1','141','764','218244',4216078,'2135','322',2620929.59,2625051.59,0.00,0.00,4122.00,1779988.00,0.00,0.00,0.00),('1','141','764','218455',4219866,'2135','322',2625051.59,2627707.19,0.00,0.00,2655.60,1139669.60,0.00,0.00,0.00),('1','141','764','218659',4223836,'2135','322',2627707.19,2627707.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','218689',4224074,'2135','322',2627707.19,2638884.85,0.00,0.00,11177.66,4786841.56,0.00,0.00,0.00),('1','141','764','218962',4228747,'2135','322',2638884.85,2645722.37,0.00,0.00,6837.52,2937996.32,0.00,0.00,0.00),('1','141','764','219418',4236641,'2135','322',2645722.37,2652314.63,0.00,0.00,6592.26,2822765.16,0.00,0.00,0.00),('1','141','764','219553',4239247,'2135','322',2652314.63,2652314.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','219671',4240977,'2135','322',2652314.63,2659422.47,0.00,0.00,7107.84,3046781.44,0.00,0.00,0.00),('1','141','764','219819',4243763,'2135','322',2659422.47,2666458.55,0.00,0.00,7036.08,3022737.28,0.00,0.00,0.00),('1','141','764','220050',4247947,'2135','322',2666458.55,2673532.51,0.00,0.00,7073.96,3038329.36,0.00,0.00,0.00),('1','141','764','220265',4251673,'2135','322',2673532.51,2676650.11,0.00,0.00,3117.60,1333673.60,0.00,0.00,0.00),('1','141','764','220563',4257141,'2135','322',2676650.11,2676650.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','220565',4257158,'2135','322',2676650.11,2684809.27,0.00,0.00,8159.16,3501192.56,0.00,0.00,0.00),('1','141','764','220946',4263727,'2135','322',2684809.27,2695558.09,0.00,0.00,10748.82,4604066.12,0.00,0.00,0.00),('1','141','764','221178',4267844,'2135','322',2695558.09,2701253.33,0.00,0.00,5695.24,2369641.84,0.00,0.00,0.00),('1','141','764','221338',4270904,'2135','322',2701253.33,2701253.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','221343',4271029,'2135','322',2701253.33,2701253.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','221432',4272351,'2135','322',2701253.33,2707555.96,0.00,0.00,6302.63,2618939.98,0.00,0.00,0.00),('1','141','764','221711',4277608,'2135','322',2707555.96,2715363.41,0.00,0.00,7807.45,3236387.70,0.00,0.00,0.00),('1','141','764','221866',4280252,'2135','322',2715363.41,2722691.74,0.00,0.00,7328.33,3039163.38,0.00,0.00,0.00),('1','141','764','222094',4284424,'2135','322',2722691.74,2725864.58,0.00,0.00,3172.84,1314575.44,0.00,0.00,0.00),('1','141','764','222205',4286473,'2135','322',2725864.58,2725864.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','222486',4291272,'2135','322',2725864.58,2742897.29,0.00,0.00,17032.71,7348318.86,0.00,0.00,0.00),('1','141','764','222766',4296265,'2135','322',2742897.29,2750469.69,0.00,0.00,7572.40,3269322.40,0.00,0.00,0.00),('1','141','764','223149',4303380,'2135','322',2750469.69,2750469.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','223153',4303440,'2135','322',2750469.69,2758499.19,0.00,0.00,8029.50,3474364.20,0.00,0.00,0.00),('1','141','764','223195',4303868,'2135','322',2758499.19,2763811.92,0.00,0.00,5312.73,2372412.70,0.00,0.00,0.00),('1','141','764','223442',4308221,'2135','322',2763811.92,2770285.48,0.00,0.00,6473.56,2897752.80,0.00,0.00,0.00),('1','141','764','223664',4312347,'2135','322',2770285.48,2775072.38,0.00,0.00,4786.90,2138584.80,0.00,0.00,0.00),('1','141','764','224104',4320222,'2135','322',2775072.38,2775072.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','224108',4320283,'2135','322',2775072.38,2790198.66,0.00,0.00,15126.28,6739060.80,0.00,0.00,0.00),('1','141','764','224377',4325089,'2135','322',2790198.66,2796203.27,0.00,0.00,6004.61,2900847.30,0.00,0.00,0.00),('1','141','764','224548',4328086,'2135','322',2796203.27,2799678.93,0.00,0.00,3475.66,1680888.90,0.00,0.00,0.00),('1','141','764','224797',4332382,'2135','322',2799678.93,2799678.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','224799',4332385,'2135','322',2799678.93,2802927.96,0.00,0.00,3249.03,1578825.30,0.00,0.00,0.00),('1','141','764','225050',4336943,'2135','322',2802927.96,2808584.60,0.00,0.00,5656.64,2732910.30,0.00,0.00,0.00),('1','141','764','225280',4341233,'2135','322',2808584.60,2813795.49,0.00,0.00,5210.89,2533794.90,0.00,0.00,0.00),('1','141','764','225723',4348984,'2135','322',2813795.49,2818785.33,0.00,0.00,4989.84,2413748.40,0.00,0.00,0.00),('1','141','764','225993',4353722,'2135','322',2818785.33,2824302.52,0.00,0.00,5517.19,2657673.90,0.00,0.00,0.00),('1','141','764','226273',4358902,'2135','322',2824302.52,2824302.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','226284',4359029,'2135','322',2824302.52,2833552.44,0.00,0.00,9249.92,4372827.20,0.00,0.00,0.00),('1','141','764','226495',4362730,'2135','322',2833552.44,2841833.97,0.00,0.00,8281.53,3917984.30,0.00,0.00,0.00),('1','141','764','226764',4367699,'2135','322',2841833.97,2848932.88,0.00,0.00,7098.91,3361908.10,0.00,0.00,0.00),('1','141','764','227148',4374761,'2135','322',2848932.88,2848932.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','227154',4374841,'2135','322',2848932.88,2851058.78,0.00,0.00,2125.90,1002465.00,0.00,0.00,0.00),('1','141','764','227359',4378475,'2135','322',2851058.78,2865407.30,0.00,0.00,14348.52,6769185.20,0.00,0.00,0.00),('1','141','764','227628',4382796,'2135','322',2865407.30,2873580.60,0.00,0.00,8173.30,3866787.00,0.00,0.00,0.00),('1','141','764','227870',4387189,'2135','322',2873580.60,2873580.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','227873',4387238,'2135','322',2873580.60,2879211.46,0.00,0.00,5630.86,2807252.30,0.00,0.00,0.00),('1','141','764','228142',4392371,'2135','322',2879211.46,2887988.57,0.00,0.00,8777.11,4364682.80,0.00,0.00,0.00),('1','141','764','228389',4397129,'2135','322',2887988.57,2895139.13,0.00,0.00,7150.56,3545339.30,0.00,0.00,0.00),('1','141','764','228580',4400607,'2135','322',2895139.13,2895139.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','228588',4400751,'2135','322',2895139.13,2901026.43,0.00,0.00,5887.30,2988990.00,0.00,0.00,0.00),('1','141','764','228925',4407297,'2135','322',2901026.43,2911220.77,0.00,0.00,10194.34,5157705.60,0.00,0.00,0.00),('1','141','764','229187',4412181,'2135','322',2911220.77,2916698.53,0.00,0.00,5477.76,2779077.60,0.00,0.00,0.00),('1','141','764','229449',4416782,'2135','322',2916698.53,2919793.83,0.00,0.00,3095.30,1567674.00,0.00,0.00,0.00),('1','141','764','229687',4421506,'2135','322',2919793.83,2919793.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','229694',4421605,'2135','322',2919793.83,2931721.97,0.00,0.00,11928.14,6243815.62,0.00,0.00,0.00),('1','141','764','229946',4426530,'2135','322',2931721.97,2938408.35,0.00,0.00,6686.38,3505221.63,0.00,0.00,0.00),('1','141','764','230111',4429594,'2135','322',2938408.35,2944422.75,0.00,0.00,6014.40,3140101.20,0.00,0.00,0.00),('1','141','764','230462',4436562,'2135','322',2944422.75,2944422.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','230466',4436597,'2135','322',2944422.75,2950887.25,0.00,0.00,6464.50,3386019.60,0.00,0.00,0.00),('1','141','764','230543',4437744,'2135','322',2950887.25,2961841.60,0.00,0.00,10954.35,5736405.70,0.00,0.00,0.00),('1','141','764','230800',4442251,'2135','322',2961841.60,2969071.47,0.00,0.00,7229.87,3778103.37,0.00,0.00,0.00),('1','141','764','231455',4453100,'2135','322',2969071.47,2969071.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','231463',4453209,'2135','322',2969071.47,2979432.69,0.00,0.00,10361.22,5511739.36,0.00,0.00,0.00),('1','141','764','231664',4456723,'2135','322',2979432.69,2993734.50,0.00,0.00,14301.81,7603800.88,0.00,0.00,0.00),('1','141','764','231903',4461197,'2135','322',2993734.50,2993734.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','231908',4461235,'2135','322',2993734.50,3003539.20,0.00,0.00,9804.70,5226720.00,0.00,0.00,0.00),('1','141','764','232152',4465674,'2135','322',3003539.20,3007722.10,0.00,0.00,4182.90,2224841.00,0.00,0.00,0.00),('1','141','764','232355',4469229,'2135','322',3007722.10,3018424.19,0.00,0.00,10702.09,5690332.12,0.00,0.00,0.00),('1','141','764','232613',4473925,'2135','322',3018424.19,3018424.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','232617',4473986,'2135','322',3018424.19,3027135.47,0.00,0.00,8711.28,4646085.64,0.00,0.00,0.00),('1','141','764','232873',4478531,'2135','322',3027135.47,3035888.53,0.00,0.00,8753.06,4671287.28,0.00,0.00,0.00),('1','141','764','233424',4488471,'2135','322',3035888.53,3043059.53,0.00,0.00,7171.00,3824760.00,0.00,0.00,0.00),('1','141','764','233437',4488653,'2135','322',3043059.53,3043059.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','233448',4488929,'2135','322',3043059.53,3045628.03,0.00,0.00,2568.50,1471020.00,0.00,0.00,0.00),('1','141','764','233631',4492286,'2135','322',3045628.03,3052381.94,0.00,0.00,6753.91,3867018.00,0.00,0.00,0.00),('1','141','764','233981',4498802,'2135','322',3052381.94,3057025.94,0.00,0.00,4644.00,2656044.00,0.00,0.00,0.00),('1','141','764','234084',4500398,'2135','322',3057025.94,3067794.75,0.00,0.00,10768.81,6143610.60,0.00,0.00,0.00),('1','141','764','234494',4507953,'2135','322',3067794.75,3067794.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','234643',4510653,'2135','322',3067794.75,3077732.56,0.00,0.00,9937.81,5682825.90,0.00,0.00,0.00),('1','141','764','234860',4514391,'2135','322',3077732.56,3086735.61,0.00,0.00,9003.05,5147634.00,0.00,0.00,0.00),('1','141','764','235111',4518821,'2135','322',3086735.61,3092470.66,0.00,0.00,5735.05,3282102.90,0.00,0.00,0.00),('1','141','764','235348',4522928,'2135','322',3092470.66,3092470.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','235352',4522987,'2135','322',3092470.66,3100279.44,0.00,0.00,7808.78,4469952.00,0.00,0.00,0.00),('1','141','764','235812',4531087,'2135','322',3100279.44,3117126.54,0.00,0.00,16847.10,9610080.00,0.00,0.00,0.00),('1','141','764','236076',4535664,'2135','322',3117126.54,3117126.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','236078',4535699,'2135','322',3117126.54,3126912.34,0.00,0.00,9785.80,5597640.00,0.00,0.00,0.00),('1','141','764','236261',4538922,'2135','322',3126912.34,3133934.04,0.00,0.00,7021.70,4016613.00,0.00,0.00,0.00),('1','141','764','236540',4543845,'2135','322',3133934.04,3141761.14,0.00,0.00,7827.10,4477737.00,0.00,0.00,0.00),('1','141','764','236785',4548084,'2135','322',3141761.14,3141761.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','236808',4548585,'2135','322',3141761.14,3147648.64,0.00,0.00,5887.50,3482385.00,0.00,0.00,0.00),('1','141','764','236995',4551750,'2135','322',3147648.64,3155744.44,0.00,0.00,8095.80,4799518.00,0.00,0.00,0.00),('1','141','764','237239',4556065,'2135','322',3155744.44,3166436.74,0.00,0.00,10692.30,6317637.00,0.00,0.00,0.00),('1','141','764','237624',4563033,'2135','322',3166436.74,3166436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','237630',4563113,'2135','322',3166436.74,3183907.94,0.00,0.00,17471.20,10343736.00,0.00,0.00,0.00),('1','141','764','237947',4568405,'2135','322',3183907.94,3191101.74,0.00,0.00,7193.80,4263082.00,0.00,0.00,0.00),('1','141','764','238162',4571779,'2135','322',3191101.74,3191101.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','238170',4571919,'2135','322',3191101.74,3200300.44,0.00,0.00,9198.70,5449181.00,0.00,0.00,0.00),('1','141','764','238386',4575745,'2135','322',3200300.44,3215724.92,0.00,0.00,15424.48,9136741.60,0.00,0.00,0.00),('1','141','764','238641',4579927,'2135','322',3215724.92,3215724.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','238646',4580011,'2135','322',3215724.92,3229605.22,0.00,0.00,13880.30,8207869.00,0.00,0.00,0.00),('1','141','764','238873',4584201,'2135','322',3229605.22,3240473.52,0.00,0.00,10868.30,6435757.00,0.00,0.00,0.00),('1','141','764','239050',4587474,'2135','322',3240473.52,3240473.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','239053',4587501,'2135','322',3240473.52,3253283.32,0.00,0.00,12809.80,7959005.30,0.00,0.00,0.00),('1','141','764','239471',4594661,'2135','322',3253283.32,3263014.12,0.00,0.00,9730.80,6053274.00,0.00,0.00,0.00),('1','141','764','239533',4595589,'2135','322',3263014.12,3265137.52,0.00,0.00,2123.40,1323102.00,0.00,0.00,0.00),('1','141','764','239815',4600491,'2135','322',3265137.52,3265137.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','239823',4600630,'2135','322',3265137.52,3278137.92,0.00,0.00,13000.40,8093716.00,0.00,0.00,0.00),('1','141','764','239994',4603592,'2135','322',3278137.92,3284796.62,0.00,0.00,6658.70,4145377.00,0.00,0.00,0.00),('1','141','764','240243',4607936,'2135','322',3284796.62,3289781.62,0.00,0.00,4985.00,3101290.00,0.00,0.00,0.00),('1','141','764','240772',4616302,'2135','322',3289781.62,3289781.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','240775',4616375,'2135','322',3289781.62,3297909.70,0.00,0.00,8128.08,5062624.50,0.00,0.00,0.00),('1','141','764','240999',4620335,'2135','322',3297909.70,3304062.50,0.00,0.00,6152.80,3839225.00,0.00,0.00,0.00),('1','141','764','241272',4625199,'2135','322',3304062.50,3314337.50,0.00,0.00,10275.00,6371415.00,0.00,0.00,0.00),('1','141','764','241801',4634408,'2135','322',3314337.50,3314337.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','241803',4634410,'2135','322',3314337.50,3322775.10,0.00,0.00,8437.60,5045870.00,0.00,0.00,0.00),('1','141','764','242175',4641191,'2135','322',3322775.10,3330850.10,0.00,0.00,8075.00,4841145.00,0.00,0.00,0.00),('1','141','764','242501',4646630,'2135','322',3330850.10,3338801.60,0.00,0.00,7951.50,4745316.00,0.00,0.00,0.00),('1','141','764','242840',4652511,'2135','322',3338801.60,3338801.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','242843',4652536,'2135','322',3338801.60,3351121.70,0.00,0.00,12320.10,7363041.50,0.00,0.00,0.00),('1','141','764','243038',4655906,'2135','322',3351121.70,3357498.60,0.00,0.00,6376.90,3826947.50,0.00,0.00,0.00),('1','141','764','243138',4657711,'2135','322',3357498.60,3363453.90,0.00,0.00,5955.30,3555129.50,0.00,0.00,0.00),('1','141','764','243413',4662551,'2135','322',3363453.90,3363453.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','243419',4662657,'2135','322',3363453.90,3368744.70,0.00,0.00,5290.80,3114339.00,0.00,0.00,0.00),('1','141','764','243643',4666395,'2135','322',3368744.70,3373918.30,0.00,0.00,5173.60,3060580.00,0.00,0.00,0.00),('1','141','764','243857',4670224,'2135','322',3373918.30,3375182.30,0.00,0.00,1264.00,749969.00,0.00,0.00,0.00),('1','141','764','244128',4674913,'2135','322',3375182.30,3376303.10,0.00,0.00,1120.80,654838.00,0.00,0.00,0.00),('1','141','764','244146',4675270,'2135','322',3376303.10,3376303.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','244153',4675399,'2135','322',3376303.10,3382495.50,0.00,0.00,6192.40,3640508.00,0.00,0.00,0.00),('1','141','764','244506',4681598,'2135','322',3382495.50,3389250.60,0.00,0.00,6755.10,3963717.00,0.00,0.00,0.00),('1','141','764','244784',4686085,'2135','322',3389250.60,3395911.70,0.00,0.00,6661.10,3898249.00,0.00,0.00,0.00),('1','141','764','244973',4689569,'2135','322',3395911.70,3400904.60,0.00,0.00,4992.90,2912220.00,0.00,0.00,0.00),('1','141','764','244980',4689623,'2135','322',3400904.60,3400904.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','245033',4690438,'2135','322',3400904.60,3407568.00,0.00,0.00,6663.40,3823522.00,0.00,0.00,0.00),('1','141','764','245523',4699063,'2135','322',3407568.00,3415011.90,0.00,0.00,7443.90,4275971.00,0.00,0.00,0.00),('1','141','764','245660',4701753,'2135','322',3415011.90,3417582.10,0.00,0.00,2570.20,1454492.00,0.00,0.00,0.00),('1','141','764','245724',4702614,'2135','322',3417582.10,3423306.93,0.00,0.00,5724.83,3285412.50,0.00,0.00,0.00),('1','141','764','245927',4705758,'2135','322',3423306.93,3425533.78,0.00,0.00,2226.85,1225463.60,0.00,0.00,0.00),('1','141','764','246234',4710710,'2135','322',3425533.78,3425533.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','246244',4710966,'2135','322',3425533.78,3436741.12,0.00,0.00,11207.34,6194777.10,0.00,0.00,0.00),('1','141','764','246448',4714455,'2135','322',3436741.12,3442998.00,0.00,0.00,6256.88,3469990.20,0.00,0.00,0.00),('1','141','764','246754',4719588,'2135','322',3442998.00,3450403.82,0.00,0.00,7405.82,4074746.65,0.00,0.00,0.00),('1','141','764','246982',4723621,'2135','322',3450403.82,3450403.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','246985',4723657,'2135','322',3450403.82,3458619.40,0.00,0.00,8215.58,4550572.70,0.00,0.00,0.00),('1','141','764','247230',4727957,'2135','322',3458619.40,3463652.40,0.00,0.00,5033.00,2715275.00,0.00,0.00,0.00),('1','141','764','247425',4731336,'2135','322',3463652.40,3471381.07,0.00,0.00,7728.67,4167941.00,0.00,0.00,0.00),('1','141','764','247708',4736171,'2135','322',3471381.07,3471381.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','247713',4736266,'2135','322',3471381.07,3480328.63,0.00,0.00,8947.56,4832611.00,0.00,0.00,0.00),('1','141','764','247956',4740204,'2135','322',3480328.63,3487970.10,0.00,0.00,7641.47,4137981.00,0.00,0.00,0.00),('1','141','764','248203',4744551,'2135','322',3487970.10,3496012.72,0.00,0.00,8042.62,4351364.50,0.00,0.00,0.00),('1','141','764','248384',4747833,'2135','322',3496012.72,3496012.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','248462',4748758,'2135','322',3496012.72,3509664.12,0.00,0.00,13651.40,7355648.50,0.00,0.00,0.00),('1','141','764','248680',4752390,'2135','322',3509664.12,3520645.92,0.00,0.00,10981.80,5890102.50,0.00,0.00,0.00),('1','141','764','249108',4759871,'2135','322',3520645.92,3520645.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','249109',4759872,'2135','322',3520645.92,3520645.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','249117',4759911,'2135','322',3520645.92,3537430.92,0.00,0.00,16785.00,8762400.00,0.00,0.00,0.00),('1','141','764','249381',4764372,'2135','322',3537430.92,3545232.22,0.00,0.00,7801.30,4089726.40,0.00,0.00,0.00),('1','141','764','249614',4768361,'2135','322',3545232.22,3545232.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','249620',4768431,'2135','322',3545232.22,3545232.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','249630',4768541,'2135','322',3545232.22,3552835.42,0.00,0.00,7603.20,4001904.00,0.00,0.00,0.00),('1','141','764','249926',4773698,'2135','322',3552835.42,3565806.32,0.00,0.00,12970.90,6792628.00,0.00,0.00,0.00),('1','141','764','250154',4777408,'2135','322',3565806.32,3569837.72,0.00,0.00,4031.40,2126880.00,0.00,0.00,0.00),('1','141','764','250373',4781063,'2135','322',3569837.72,3569837.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','250379',4781181,'2135','322',3569837.72,3576465.84,0.00,0.00,6628.12,3477496.00,0.00,0.00,0.00),('1','141','764','250623',4785226,'2135','322',3576465.84,3578007.31,0.00,0.00,1541.47,817554.00,0.00,0.00,0.00),('1','141','764','250858',4789502,'2135','322',3578007.31,3587174.58,0.00,0.00,9167.27,4799162.00,0.00,0.00,0.00),('1','141','764','251055',4792940,'2135','322',3587174.58,3594517.10,0.00,0.00,7342.52,3837064.00,0.00,0.00,0.00),('1','141','764','251374',4798508,'2135','322',3594517.10,3594517.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','251377',4798528,'2135','322',3594517.10,3598650.50,0.00,0.00,4133.40,2133465.00,0.00,0.00,0.00),('1','141','764','251562',4801499,'2135','322',3598650.50,3605251.40,0.00,0.00,6600.90,3398953.00,0.00,0.00,0.00),('1','141','764','251804',4805918,'2135','322',3605251.40,3608225.00,0.00,0.00,2973.60,1540441.00,0.00,0.00,0.00),('1','141','764','252018',4809621,'2135','322',3608225.00,3612419.84,0.00,0.00,4194.84,2189169.20,0.00,0.00,0.00),('1','141','764','252287',4814244,'2135','322',3612419.84,3615256.69,0.00,0.00,2836.85,1468091.00,0.00,0.00,0.00),('1','141','764','252508',4818304,'2135','322',3615256.69,3619259.60,0.00,0.00,4002.91,2058375.10,0.00,0.00,0.00),('1','141','764','252745',4822421,'2135','322',3619259.60,3619259.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','252754',4822508,'2135','322',3619259.60,3628812.70,0.00,0.00,9553.10,4868648.00,0.00,0.00,0.00),('1','141','764','253002',4826504,'2135','322',3628812.70,3637694.17,0.00,0.00,8881.47,4529900.10,0.00,0.00,0.00),('1','141','764','253250',4830746,'2135','322',3637694.17,3643973.66,0.00,0.00,6279.49,3203114.20,0.00,0.00,0.00),('1','141','764','253494',4834941,'2135','322',3643973.66,3643973.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','253499',4834967,'2135','322',3643973.66,3655064.25,0.00,0.00,11090.59,5636972.20,0.00,0.00,0.00),('1','141','764','253755',4839388,'2135','322',3655064.25,3664896.73,0.00,0.00,9832.48,5008675.90,0.00,0.00,0.00),('1','141','764','254027',4844240,'2135','322',3664896.73,3668616.98,0.00,0.00,3720.25,1891495.00,0.00,0.00,0.00),('1','141','764','254194',4847389,'2135','322',3668616.98,3668616.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','254231',4847811,'2135','322',3668616.98,3678172.06,0.00,0.00,9555.08,4862926.40,0.00,0.00,0.00),('1','141','764','254499',4852425,'2135','322',3678172.06,3688433.11,0.00,0.00,10261.05,5215996.50,0.00,0.00,0.00),('1','141','764','254731',4856418,'2135','322',3688433.11,3693249.98,0.00,0.00,4816.87,2444862.10,0.00,0.00,0.00),('1','141','764','254980',4860699,'2135','322',3693249.98,3709403.48,0.00,0.00,16153.50,8205146.25,0.00,0.00,0.00),('1','141','764','255222',4864847,'2135','322',3709403.48,3717570.75,0.00,0.00,8167.27,4139529.10,0.00,0.00,0.00),('1','141','764','255392',4868087,'2135','322',3717570.75,3717570.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','255493',4869454,'2135','322',3717570.75,3731094.31,0.00,0.00,13523.56,6879644.80,0.00,0.00,0.00),('1','141','764','255772',4874037,'2135','322',3731094.31,3742282.95,0.00,0.00,11188.64,5662371.20,0.00,0.00,0.00),('1','141','764','256003',4877907,'2135','322',3742282.95,3742282.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','256010',4878017,'2135','322',3742282.95,3752806.48,0.00,0.00,10523.53,5350354.90,0.00,0.00,0.00),('1','141','764','256242',4881584,'2135','322',3752806.48,3764813.84,0.00,0.00,12007.36,6092056.30,0.00,0.00,0.00),('1','141','764','256541',4886786,'2135','322',3764813.84,3766948.54,0.00,0.00,2134.70,1078526.00,0.00,0.00,0.00),('1','141','764','256721',4889948,'2135','322',3766948.54,3766948.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','256724',4889968,'2135','322',3766948.54,3791520.05,0.00,0.00,24571.51,12457399.30,0.00,0.00,0.00),('1','141','764','257000',4894599,'2135','322',3791520.05,3791520.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257013',4894778,'2135','322',3791520.05,3802598.31,0.00,0.00,11078.26,5631943.30,0.00,0.00,0.00),('1','141','764','257231',4899034,'2135','322',3802598.31,3816040.93,0.00,0.00,13442.62,6827472.10,0.00,0.00,0.00),('1','141','764','257573',4904804,'2135','322',3816040.93,3816040.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257577',4904847,'2135','322',3816040.93,3822417.12,0.00,0.00,6376.19,3235042.70,0.00,0.00,0.00),('1','141','764','257578',4904848,'2135','322',3822417.12,3840634.23,0.00,0.00,18217.11,9241840.05,0.00,0.00,0.00),('1','141','764','257579',4904849,'2135','322',3840634.23,3840634.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257580',4904850,'2135','322',3840634.23,3850477.89,0.00,0.00,9843.66,5012242.80,0.00,0.00,0.00),('1','141','764','257581',4904851,'2135','322',3850477.89,3865292.16,0.00,0.00,14814.27,7522150.35,0.00,0.00,0.00),('1','141','764','257582',4904852,'2135','322',3865292.16,3865292.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257583',4904853,'2135','322',3865292.16,3877246.79,0.00,0.00,11954.63,6082997.90,0.00,0.00,0.00),('1','141','764','257584',4904854,'2135','322',3877246.79,3889953.16,0.00,0.00,12706.37,6435112.10,0.00,0.00,0.00),('1','141','764','257585',4904855,'2135','322',3889953.16,3889953.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257586',4904856,'2135','322',3889953.16,3903113.34,0.00,0.00,13160.18,6686239.40,0.00,0.00,0.00),('1','141','764','257587',4904857,'2135','322',3903113.34,3914687.44,0.00,0.00,11574.10,5869115.50,0.00,0.00,0.00),('1','141','764','257588',4904858,'2135','322',3914687.44,3914687.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257589',4904859,'2135','322',3914687.44,3927729.34,0.00,0.00,13041.90,6634602.00,0.00,0.00,0.00),('1','141','764','257590',4904860,'2135','322',3927729.34,3939181.93,0.00,0.00,11452.59,5797411.20,0.00,0.00,0.00),('1','141','764','257591',4904861,'2135','322',3939181.93,3939181.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257592',4904862,'2135','322',3939181.93,3954949.41,0.00,0.00,15767.48,7993940.90,0.00,0.00,0.00),('1','141','764','257593',4904863,'2135','322',3954949.41,3964715.16,0.00,0.00,9765.75,4946392.50,0.00,0.00,0.00),('1','141','764','257594',4904864,'2135','322',3964715.16,3964715.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257595',4904865,'2135','322',3964715.16,3973879.98,0.00,0.00,9164.82,4662488.10,0.00,0.00,0.00),('1','141','764','257596',4904866,'2135','322',3973879.98,3984660.64,0.00,0.00,10780.66,5488307.80,0.00,0.00,0.00),('1','141','764','257597',4904867,'2135','322',3984660.64,3989196.44,0.00,0.00,4535.80,2307679.00,0.00,0.00,0.00),('1','141','764','257598',4904868,'2135','322',3989196.44,3989196.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257599',4904869,'2135','322',3989196.44,3993556.48,0.00,0.00,4360.04,2215350.20,0.00,0.00,0.00),('1','141','764','257600',4904870,'2135','322',3993556.48,4005790.75,0.00,0.00,12234.27,6220881.60,0.00,0.00,0.00),('1','141','764','257601',4904871,'2135','322',4005790.75,4012136.38,0.00,0.00,6345.63,3243302.40,0.00,0.00,0.00),('1','141','764','257602',4904872,'2135','322',4012136.38,4013031.88,0.00,0.00,895.50,454515.00,0.00,0.00,0.00),('1','141','764','257603',4904873,'2135','322',4013031.88,4013031.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257604',4904874,'2135','322',4013031.88,4021265.83,0.00,0.00,8233.95,4312028.40,0.00,0.00,0.00),('1','141','764','257605',4904875,'2135','322',4021265.83,4029017.82,0.00,0.00,7751.99,4064253.20,0.00,0.00,0.00),('1','141','764','257606',4904876,'2135','322',4029017.82,4035695.06,0.00,0.00,6677.24,3501903.20,0.00,0.00,0.00),('1','141','764','257607',4904877,'2135','322',4035695.06,4037514.11,0.00,0.00,1819.05,955479.00,0.00,0.00,0.00),('1','141','764','257608',4904878,'2135','322',4037514.11,4037514.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257609',4904879,'2135','322',4037514.11,4040046.19,0.00,0.00,2532.08,1320059.60,0.00,0.00,0.00),('1','141','764','257610',4904880,'2135','322',4040046.19,4047053.63,0.00,0.00,7007.44,3673057.60,0.00,0.00,0.00),('1','141','764','257611',4904881,'2135','322',4047053.63,4054517.33,0.00,0.00,7463.70,3912588.00,0.00,0.00,0.00),('1','141','764','257612',4904882,'2135','322',4054517.33,4062007.40,0.00,0.00,7490.07,3908610.60,0.00,0.00,0.00),('1','141','764','257613',4904883,'2135','322',4062007.40,4062007.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257614',4904884,'2135','322',4062007.40,4070705.04,0.00,0.00,8697.64,4650194.08,0.00,0.00,0.00),('1','141','764','257615',4904885,'2135','322',4070705.04,4077430.33,0.00,0.00,6725.29,3603318.28,0.00,0.00,0.00),('1','141','764','257616',4904886,'2135','322',4077430.33,4086642.02,0.00,0.00,9211.69,4911788.20,0.00,0.00,0.00),('1','141','764','257617',4904887,'2135','322',4086642.02,4086642.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257618',4904888,'2135','322',4086642.02,4096161.95,0.00,0.00,9519.93,5091868.20,0.00,0.00,0.00),('1','141','764','257619',4904889,'2135','322',4096161.95,4111289.96,0.00,0.00,15128.01,8064589.80,0.00,0.00,0.00),('1','141','764','257620',4904890,'2135','322',4111289.96,4111289.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257621',4904891,'2135','322',4111289.96,4119825.41,0.00,0.00,8535.45,4562404.20,0.00,0.00,0.00),('1','141','764','257622',4904892,'2135','322',4119825.41,4135839.07,0.00,0.00,16013.66,8542233.20,0.00,0.00,0.00),('1','141','764','257623',4904893,'2135','322',4135839.07,4135839.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257624',4904894,'2135','322',4135839.07,4142215.47,0.00,0.00,6376.40,3412544.00,0.00,0.00,0.00),('1','141','764','257625',4904895,'2135','322',4142215.47,4153396.46,0.00,0.00,11180.99,5973169.40,0.00,0.00,0.00),('1','141','764','257626',4904896,'2135','322',4153396.46,4160476.74,0.00,0.00,7080.28,3777647.20,0.00,0.00,0.00),('1','141','764','257627',4904897,'2135','322',4160476.74,4160476.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257628',4904898,'2135','322',4160476.74,4177407.95,0.00,0.00,16931.21,9028005.80,0.00,0.00,0.00),('1','141','764','257629',4904899,'2135','322',4177407.95,4185107.05,0.00,0.00,7699.10,4101791.60,0.00,0.00,0.00),('1','141','764','257630',4904900,'2135','322',4185107.05,4185107.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257631',4904901,'2135','322',4185107.05,4191320.06,0.00,0.00,6213.01,3814359.70,0.00,0.00,0.00),('1','141','764','257632',4904902,'2135','322',4191320.06,4195836.45,0.00,0.00,4516.39,2782109.50,0.00,0.00,0.00),('1','141','764','257633',4904903,'2135','322',4195836.45,4199575.63,0.00,0.00,3739.18,2289635.00,0.00,0.00,0.00),('1','141','764','257634',4904904,'2135','322',4199575.63,4203660.07,0.00,0.00,4084.44,2511462.00,0.00,0.00,0.00),('1','141','764','257635',4904905,'2135','322',4203660.07,4209791.71,0.00,0.00,6131.64,3759730.00,0.00,0.00,0.00),('1','141','764','257636',4904906,'2135','322',4209791.71,4209791.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257637',4904907,'2135','322',4209791.71,4213536.46,0.00,0.00,3744.75,2235175.50,0.00,0.00,0.00),('1','141','764','257638',4904908,'2135','322',4213536.46,4220230.69,0.00,0.00,6694.23,3976603.50,0.00,0.00,0.00),('1','141','764','257639',4904909,'2135','322',4220230.69,4225277.86,0.00,0.00,5047.17,3007990.50,0.00,0.00,0.00),('1','141','764','257640',4904910,'2135','322',4225277.86,4231780.45,0.00,0.00,6502.59,3864605.70,0.00,0.00,0.00),('1','141','764','257641',4904911,'2135','322',4231780.45,4234445.92,0.00,0.00,2665.47,1572627.30,0.00,0.00,0.00),('1','141','764','257642',4904912,'2135','322',4234445.92,4234445.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257643',4904913,'2135','322',4234445.92,4248194.06,0.00,0.00,13748.14,8142789.20,0.00,0.00,0.00),('1','141','764','257644',4904914,'2135','322',4248194.06,4259082.87,0.00,0.00,10888.81,6450398.30,0.00,0.00,0.00),('1','141','764','257645',4904915,'2135','322',4259082.87,4259082.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257646',4904916,'2135','322',4259082.87,4264606.40,0.00,0.00,5523.53,3268116.70,0.00,0.00,0.00),('1','141','764','257647',4904917,'2135','322',4264606.40,4274158.45,0.00,0.00,9552.05,5667242.50,0.00,0.00,0.00),('1','141','764','257648',4904918,'2135','322',4274158.45,4279352.84,0.00,0.00,5194.39,3095019.50,0.00,0.00,0.00),('1','141','764','257649',4904919,'2135','322',4279352.84,4283730.30,0.00,0.00,4377.46,2591249.00,0.00,0.00,0.00),('1','141','764','257650',4904920,'2135','322',4283730.30,4283730.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257651',4904921,'2135','322',4283730.30,4288900.90,0.00,0.00,5170.60,3164181.00,0.00,0.00,0.00),('1','141','764','257652',4904922,'2135','322',4288900.90,4295480.11,0.00,0.00,6579.21,4036303.60,0.00,0.00,0.00),('1','141','764','257653',4904923,'2135','322',4295480.11,4302284.54,0.00,0.00,6804.43,4179013.80,0.00,0.00,0.00),('1','141','764','257654',4904924,'2135','322',4302284.54,4308357.73,0.00,0.00,6073.19,3720830.40,0.00,0.00,0.00),('1','141','764','257655',4904925,'2135','322',4308357.73,4308357.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257656',4904926,'2135','322',4308357.73,4315834.24,0.00,0.00,7476.51,4588389.60,0.00,0.00,0.00),('1','141','764','257657',4904927,'2135','322',4315834.24,4321205.10,0.00,0.00,5370.86,3303217.60,0.00,0.00,0.00),('1','141','764','257658',4904928,'2135','322',4321205.10,4327045.49,0.00,0.00,5840.39,3582482.40,0.00,0.00,0.00),('1','141','764','257659',4904929,'2135','322',4327045.49,4330464.47,0.00,0.00,3418.98,2098171.80,0.00,0.00,0.00),('1','141','764','257660',4904930,'2135','322',4330464.47,4332962.59,0.00,0.00,2498.12,1529304.20,0.00,0.00,0.00),('1','141','764','257661',4904931,'2135','322',4332962.59,4332962.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257662',4904932,'2135','322',4332962.59,4343304.34,0.00,0.00,10341.75,6235113.00,0.00,0.00,0.00),('1','141','764','257663',4904933,'2135','322',4343304.34,4348681.02,0.00,0.00,5376.68,3261586.80,0.00,0.00,0.00),('1','141','764','257664',4904934,'2135','322',4348681.02,4354302.84,0.00,0.00,5621.82,3403491.60,0.00,0.00,0.00),('1','141','764','257665',4904935,'2135','322',4354302.84,4357582.16,0.00,0.00,3279.32,1983271.20,0.00,0.00,0.00),('1','141','764','257666',4904936,'2135','322',4357582.16,4357582.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257667',4904937,'2135','322',4357582.16,4361938.16,0.00,0.00,4356.00,2624580.00,0.00,0.00,0.00),('1','141','764','257668',4904938,'2135','322',4361938.16,4366667.19,0.00,0.00,4729.03,2873599.80,0.00,0.00,0.00),('1','141','764','257669',4904939,'2135','322',4366667.19,4374388.87,0.00,0.00,7721.68,4651108.80,0.00,0.00,0.00),('1','141','764','257670',4904940,'2135','322',4374388.87,4377924.24,0.00,0.00,3535.37,2145400.20,0.00,0.00,0.00),('1','141','764','257671',4904941,'2135','322',4377924.24,4382162.44,0.00,0.00,4238.20,2548836.00,0.00,0.00,0.00),('1','141','764','257672',4904942,'2135','322',4382162.44,4382162.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257673',4904943,'2135','322',4382162.44,4393222.87,0.00,0.00,11060.43,6607484.30,0.00,0.00,0.00),('1','141','764','257674',4904944,'2135','322',4393222.87,4400111.74,0.00,0.00,6888.87,4129549.20,0.00,0.00,0.00),('1','141','764','257675',4904945,'2135','322',4400111.74,4406796.42,0.00,0.00,6684.68,4005606.30,0.00,0.00,0.00),('1','141','764','257676',4904946,'2135','322',4406796.42,4406796.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257677',4904947,'2135','322',4406796.42,4413146.87,0.00,0.00,6350.45,3792821.65,0.00,0.00,0.00),('1','141','764','257678',4904948,'2135','322',4413146.87,4418855.95,0.00,0.00,5709.08,3433788.80,0.00,0.00,0.00),('1','141','764','257679',4904949,'2135','322',4418855.95,4426005.04,0.00,0.00,7149.09,4240797.15,0.00,0.00,0.00),('1','141','764','257680',4904950,'2135','322',4426005.04,4431378.61,0.00,0.00,5373.57,3167768.70,0.00,0.00,0.00),('1','141','764','257681',4904951,'2135','322',4431378.61,4431378.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257682',4904952,'2135','322',4431378.61,4441658.65,0.00,0.00,10280.04,6050676.90,0.00,0.00,0.00),('1','141','764','257683',4904953,'2135','322',4441658.65,4452966.60,0.00,0.00,11307.95,6650539.50,0.00,0.00,0.00),('1','141','764','257684',4904954,'2135','322',4452966.60,4455883.99,0.00,0.00,2917.39,1714824.90,0.00,0.00,0.00),('1','141','764','257685',4904955,'2135','322',4455883.99,4455883.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257686',4904956,'2135','322',4455883.99,4463562.85,0.00,0.00,7678.86,4510220.10,0.00,0.00,0.00),('1','141','764','257687',4904957,'2135','322',4463562.85,4475533.01,0.00,0.00,11970.16,7035383.10,0.00,0.00,0.00),('1','141','764','257688',4904958,'2135','322',4475533.01,4475533.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257689',4904959,'2135','322',4475533.01,4478634.64,0.00,0.00,3101.63,1836243.30,0.00,0.00,0.00),('1','141','764','257690',4904960,'2135','322',4478634.64,4488353.66,0.00,0.00,9719.02,5719753.20,0.00,0.00,0.00),('1','141','764','257691',4904961,'2135','322',4488353.66,4498112.70,0.00,0.00,9759.04,5747096.40,0.00,0.00,0.00),('1','141','764','257692',4904962,'2135','322',4498112.70,4500107.10,0.00,0.00,1994.40,1169956.50,0.00,0.00,0.00),('1','141','764','257693',4904963,'2135','322',4500107.10,4500107.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257694',4904964,'2135','322',4500107.10,4514402.76,0.00,0.00,14295.66,8406878.10,0.00,0.00,0.00),('1','141','764','257695',4904965,'2135','322',4514402.76,4519870.58,0.00,0.00,5467.82,3217868.70,0.00,0.00,0.00),('1','141','764','257696',4904966,'2135','322',4519870.58,4521619.60,0.00,0.00,1749.02,1031278.20,0.00,0.00,0.00),('1','141','764','257697',4904967,'2135','322',4521619.60,4524732.95,0.00,0.00,3113.35,1826931.00,0.00,0.00,0.00),('1','141','764','257698',4904968,'2135','322',4524732.95,4524732.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257699',4904969,'2135','322',4524732.95,4534840.45,0.00,0.00,10107.50,5937871.50,0.00,0.00,0.00),('1','141','764','257700',4904970,'2135','322',4534840.45,4541626.17,0.00,0.00,6785.72,4013027.70,0.00,0.00,0.00),('1','141','764','257701',4904971,'2135','322',4541626.17,4549313.42,0.00,0.00,7687.25,4527217.50,0.00,0.00,0.00),('1','141','764','257702',4904972,'2135','322',4549313.42,4549313.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257703',4904973,'2135','322',4549313.42,4556936.92,0.00,0.00,7623.50,4418741.60,0.00,0.00,0.00),('1','141','764','257704',4904974,'2135','322',4556936.92,4568291.67,0.00,0.00,11354.75,6563889.20,0.00,0.00,0.00),('1','141','764','257705',4904975,'2135','322',4568291.67,4572177.63,0.00,0.00,3885.96,2252307.60,0.00,0.00,0.00),('1','141','764','257706',4904976,'2135','322',4572177.63,4573893.54,0.00,0.00,1715.91,992267.40,0.00,0.00,0.00),('1','141','764','257707',4904977,'2135','322',4573893.54,4573893.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257708',4904978,'2135','322',4573893.54,4577721.35,0.00,0.00,3827.81,2211207.80,0.00,0.00,0.00),('1','141','764','257709',4904979,'2135','322',4577721.35,4592909.42,0.00,0.00,15188.07,8768659.40,0.00,0.00,0.00),('1','141','764','257710',4904980,'2135','322',4592909.42,4598416.97,0.00,0.00,5507.55,3184143.00,0.00,0.00,0.00),('1','141','764','257711',4904981,'2135','322',4598416.97,4598461.63,0.00,0.00,44.66,25724.16,0.00,0.00,0.00),('1','141','764','257712',4904982,'2135','322',4598461.63,4616068.21,0.00,0.00,17606.58,10166084.20,0.00,0.00,0.00),('1','141','764','257713',4904983,'2135','322',4616068.21,4618037.83,0.00,0.00,1969.62,1137409.52,0.00,0.00,0.00),('1','141','764','257714',4904984,'2135','322',4618037.83,4618037.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257715',4904985,'2135','322',4618037.83,4623174.45,0.00,0.00,5136.62,3225182.70,0.00,0.00,0.00),('1','141','764','257716',4904986,'2135','322',4623174.45,4635419.94,0.00,0.00,12245.49,7682711.90,0.00,0.00,0.00),('1','141','764','257717',4904987,'2135','322',4635419.94,4642496.19,0.00,0.00,7076.25,4434911.50,0.00,0.00,0.00),('1','141','764','257718',4904988,'2135','322',4642496.19,4642496.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257719',4904989,'2135','322',4642496.19,4648941.50,0.00,0.00,6445.31,4079811.60,0.00,0.00,0.00),('1','141','764','257720',4904990,'2135','322',4648941.50,4656773.49,0.00,0.00,7831.99,4955462.40,0.00,0.00,0.00),('1','141','764','257721',4904991,'2135','322',4656773.49,4664815.55,0.00,0.00,8042.06,5091971.70,0.00,0.00,0.00),('1','141','764','257722',4904992,'2135','322',4664815.55,4667056.67,0.00,0.00,2241.12,1412119.20,0.00,0.00,0.00),('1','141','764','257723',4904993,'2135','322',4667056.67,4667056.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257724',4904994,'2135','322',4667056.67,4678085.47,0.00,0.00,11028.80,7097928.20,0.00,0.00,0.00),('1','141','764','257725',4904995,'2135','322',4678085.47,4690579.06,0.00,0.00,12493.59,8024096.00,0.00,0.00,0.00),('1','141','764','257726',4904996,'2135','322',4690579.06,4691456.80,0.00,0.00,877.74,565723.20,0.00,0.00,0.00),('1','141','764','257727',4904997,'2135','322',4691456.80,4691456.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257728',4904998,'2135','322',4691456.80,4697478.07,0.00,0.00,6021.27,4043583.30,0.00,0.00,0.00),('1','141','764','257729',4904999,'2135','322',4697478.07,4711215.96,0.00,0.00,13737.89,9219259.10,0.00,0.00,0.00),('1','141','764','257730',4905000,'2135','322',4711215.96,4716045.39,0.00,0.00,4829.43,3241476.00,0.00,0.00,0.00),('1','141','764','257731',4905001,'2135','322',4716045.39,4716045.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257732',4905002,'2135','322',4716045.39,4721850.40,0.00,0.00,5805.01,3901777.00,0.00,0.00,0.00),('1','141','764','257733',4905003,'2135','322',4721850.40,4733492.30,0.00,0.00,11641.90,7819167.40,0.00,0.00,0.00),('1','141','764','257734',4905004,'2135','322',4733492.30,4740543.39,0.00,0.00,7051.09,4733446.00,0.00,0.00,0.00),('1','141','764','257735',4905005,'2135','322',4740543.39,4740543.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257736',4905006,'2135','322',4740543.39,4746400.14,0.00,0.00,5856.75,4078466.70,0.00,0.00,0.00),('1','141','764','257737',4905007,'2135','322',4746400.14,4753154.87,0.00,0.00,6754.73,4709047.50,0.00,0.00,0.00),('1','141','764','257738',4905008,'2135','322',4753154.87,4759660.97,0.00,0.00,6506.10,4546675.20,0.00,0.00,0.00),('1','141','764','257739',4905009,'2135','322',4759660.97,4763738.80,0.00,0.00,4077.83,2842033.50,0.00,0.00,0.00),('1','141','764','257740',4905010,'2135','322',4763738.80,4765176.86,0.00,0.00,1438.06,994551.00,0.00,0.00,0.00),('1','141','764','257741',4905011,'2135','322',4765176.86,4765176.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257742',4905012,'2135','322',4765176.86,4772732.27,0.00,0.00,7555.41,5251741.50,0.00,0.00,0.00),('1','141','764','257743',4905013,'2135','322',4772732.27,4781314.93,0.00,0.00,8582.66,5956051.80,0.00,0.00,0.00),('1','141','764','257744',4905014,'2135','322',4781314.93,4781314.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257745',4905015,'2135','322',4781314.93,4789739.27,0.00,0.00,8424.34,5844506.40,0.00,0.00,0.00),('1','141','764','257746',4905016,'2135','322',4789739.27,4789739.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257747',4905017,'2135','322',4789739.27,4795345.28,0.00,0.00,5606.01,3910634.10,0.00,0.00,0.00),('1','141','764','257748',4905018,'2135','322',4795345.28,4807095.96,0.00,0.00,11750.68,8151259.80,0.00,0.00,0.00),('1','141','764','257749',4905019,'2135','322',4807095.96,4814345.89,0.00,0.00,7249.93,5033667.30,0.00,0.00,0.00),('1','141','764','257750',4905020,'2135','322',4814345.89,4814345.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257751',4905021,'2135','322',4814345.89,4818460.10,0.00,0.00,4114.21,2871967.50,0.00,0.00,0.00),('1','141','764','257752',4905022,'2135','322',4818460.10,4825842.47,0.00,0.00,7382.37,5130778.50,0.00,0.00,0.00),('1','141','764','257753',4905023,'2135','322',4825842.47,4832387.55,0.00,0.00,6545.08,4554420.00,0.00,0.00,0.00),('1','141','764','257754',4905024,'2135','322',4832387.55,4836187.63,0.00,0.00,3800.08,2642146.80,0.00,0.00,0.00),('1','141','764','257755',4905025,'2135','322',4836187.63,4838957.91,0.00,0.00,2770.28,1924056.00,0.00,0.00,0.00),('1','141','764','257756',4905026,'2135','322',4838957.91,4838957.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257757',4905027,'2135','322',4838957.91,4843117.91,0.00,0.00,4160.00,2787200.00,0.00,0.00,0.00),('1','141','764','257758',4905028,'2135','322',4843117.91,4859105.21,0.00,0.00,15987.30,10782315.00,0.00,0.00,0.00),('1','141','764','257759',4905029,'2135','322',4859105.21,4862791.32,0.00,0.00,3686.11,2499252.90,0.00,0.00,0.00),('1','141','764','257760',4905030,'2135','322',4862791.32,4862791.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257761',4905031,'2135','322',4862791.32,4864174.69,0.00,0.00,1383.37,937183.50,0.00,0.00,0.00),('1','141','764','257762',4905032,'2135','322',4864174.69,4872345.06,0.00,0.00,8170.37,5520745.50,0.00,0.00,0.00),('1','141','764','257763',4905033,'2135','322',4872345.06,4875795.79,0.00,0.00,3450.73,2345915.50,0.00,0.00,0.00),('1','141','764','257764',4905034,'2135','322',4875795.79,4879641.70,0.00,0.00,3845.91,2610103.70,0.00,0.00,0.00),('1','141','764','257765',4905035,'2135','322',4879641.70,4885892.85,0.00,0.00,6251.15,4219539.30,0.00,0.00,0.00),('1','141','764','257766',4905036,'2135','322',4885892.85,4887259.96,0.00,0.00,1367.11,921056.50,0.00,0.00,0.00),('1','141','764','257767',4905037,'2135','322',4887259.96,4887259.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257768',4905038,'2135','322',4887259.96,4890846.07,0.00,0.00,3586.11,2440073.70,0.00,0.00,0.00),('1','141','764','257769',4905039,'2135','322',4890846.07,4900961.30,0.00,0.00,10115.23,6831013.70,0.00,0.00,0.00),('1','141','764','257770',4905040,'2135','322',4900961.30,4909142.11,0.00,0.00,8180.81,5535491.50,0.00,0.00,0.00),('1','141','764','257771',4905041,'2135','322',4909142.11,4912214.79,0.00,0.00,3072.68,2069518.00,0.00,0.00,0.00),('1','141','764','257772',4905042,'2135','322',4912214.79,4912214.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257773',4905043,'2135','322',4912214.79,4913848.61,0.00,0.00,1633.82,1112979.40,0.00,0.00,0.00),('1','141','764','257774',4905044,'2135','322',4913848.61,4921973.49,0.00,0.00,8124.88,5511319.20,0.00,0.00,0.00),('1','141','764','257775',4905045,'2135','322',4921973.49,4927060.70,0.00,0.00,5087.21,3427154.70,0.00,0.00,0.00),('1','141','764','257776',4905046,'2135','322',4927060.70,4937173.86,0.00,0.00,10113.16,6821766.00,0.00,0.00,0.00),('1','141','764','257777',4905047,'2135','322',4937173.86,4937279.86,0.00,0.00,106.00,71020.00,0.00,0.00,0.00),('1','141','764','257778',4905048,'2135','322',4937279.86,4945327.16,0.00,0.00,8047.30,5427995.00,0.00,0.00,0.00),('1','141','764','257779',4905049,'2135','322',4945327.16,4953576.20,0.00,0.00,8249.04,5591244.00,0.00,0.00,0.00),('1','141','764','257780',4905050,'2135','322',4953576.20,4955047.15,0.00,0.00,1470.95,997196.50,0.00,0.00,0.00),('1','141','764','257781',4905051,'2135','322',4955047.15,4960744.99,0.00,0.00,5697.84,3839217.60,0.00,0.00,0.00),('1','141','764','257782',4905052,'2135','322',4960744.99,4961844.47,0.00,0.00,1099.48,738758.00,0.00,0.00,0.00),('1','141','764','257783',4905053,'2135','322',4961844.47,4961844.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257784',4905054,'2135','322',4961844.47,4970579.32,0.00,0.00,8734.85,5897137.50,0.00,0.00,0.00),('1','141','764','257785',4905055,'2135','322',4970579.32,4977666.35,0.00,0.00,7087.03,4792518.90,0.00,0.00,0.00),('1','141','764','257786',4905056,'2135','322',4977666.35,4986052.24,0.00,0.00,8385.89,5678229.50,0.00,0.00,0.00),('1','141','764','257787',4905057,'2135','322',4986052.24,4986550.26,0.00,0.00,498.02,339955.80,0.00,0.00,0.00),('1','141','764','257788',4905058,'2135','322',4986550.26,4986550.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257789',4905059,'2135','322',4986550.26,4992790.15,0.00,0.00,6239.89,4163538.90,0.00,0.00,0.00),('1','141','764','257790',4905060,'2135','322',4992790.15,5003044.91,0.00,0.00,10254.76,6825518.40,0.00,0.00,0.00),('1','141','764','257791',4905061,'2135','322',5003044.91,5009181.15,0.00,0.00,6136.24,4071643.50,0.00,0.00,0.00),('1','141','764','257792',4905062,'2135','322',5009181.15,5011231.77,0.00,0.00,2050.62,1371780.00,0.00,0.00,0.00),('1','141','764','257793',4905063,'2135','322',5011231.77,5011231.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257794',4905064,'2135','322',5011231.77,5018075.27,0.00,0.00,6843.50,4555842.00,0.00,0.00,0.00),('1','141','764','257795',4905065,'2135','322',5018075.27,5032406.22,0.00,0.00,14330.95,9503643.90,0.00,0.00,0.00),('1','141','764','257796',4905066,'2135','322',5032406.22,5035466.48,0.00,0.00,3060.26,2029671.60,0.00,0.00,0.00),('1','141','764','257797',4905067,'2135','322',5035466.48,5035466.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257798',4905068,'2135','322',5035466.48,5042331.11,0.00,0.00,6864.63,4570731.90,0.00,0.00,0.00),('1','141','764','257799',4905069,'2135','322',5042331.11,5058396.59,0.00,0.00,16065.48,10665315.00,0.00,0.00,0.00),('1','141','764','257800',4905070,'2135','322',5058396.59,5059924.21,0.00,0.00,1527.62,1015359.90,0.00,0.00,0.00),('1','141','764','257801',4905071,'2135','322',5059924.21,5059924.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257802',4905072,'2135','322',5059924.21,5069187.74,0.00,0.00,9263.53,6158562.60,0.00,0.00,0.00),('1','141','764','257803',4905073,'2135','322',5069187.74,5080796.71,0.00,0.00,11608.97,7722172.50,0.00,0.00,0.00),('1','141','764','257804',4905074,'2135','322',5080796.71,5084695.48,0.00,0.00,3898.77,2596514.40,0.00,0.00,0.00),('1','141','764','257805',4905075,'2135','322',5084695.48,5084695.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257806',4905076,'2135','322',5084695.48,5095401.42,0.00,0.00,10705.94,7108494.00,0.00,0.00,0.00),('1','141','764','257807',4905077,'2135','322',5095401.42,5106341.67,0.00,0.00,10940.25,7284802.50,0.00,0.00,0.00),('1','141','764','257808',4905078,'2135','322',5106341.67,5109507.15,0.00,0.00,3165.48,2094334.20,0.00,0.00,0.00),('1','141','764','257809',4905079,'2135','322',5109507.15,5109507.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257810',4905080,'2135','322',5109507.15,5119265.56,0.00,0.00,9758.41,6495501.00,0.00,0.00,0.00),('1','141','764','257811',4905081,'2135','322',5119265.56,5129091.33,0.00,0.00,9825.77,6512399.70,0.00,0.00,0.00),('1','141','764','257812',4905082,'2135','322',5129091.33,5129091.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257813',4905083,'2135','322',5129091.33,5146096.01,0.00,0.00,17004.68,11291443.80,0.00,0.00,0.00),('1','141','764','257814',4905084,'2135','322',5146096.01,5146096.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257815',4905085,'2135','322',5146096.01,5153788.13,0.00,0.00,7692.12,5086701.00,0.00,0.00,0.00),('1','141','764','257816',4905086,'2135','322',5153788.13,5153788.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257817',4905087,'2135','322',5153788.13,5176395.81,0.00,0.00,22607.68,14976068.70,0.00,0.00,0.00),('1','141','764','257818',4905088,'2135','322',5176395.81,5178402.79,0.00,0.00,2006.98,1329164.40,0.00,0.00,0.00),('1','141','764','257819',4905089,'2135','322',5178402.79,5178402.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257820',4905090,'2135','322',5178402.79,5196846.95,0.00,0.00,18444.16,12250498.80,0.00,0.00,0.00),('1','141','764','257821',4905091,'2135','322',5196846.95,5203237.73,0.00,0.00,6390.78,4245910.20,0.00,0.00,0.00),('1','141','764','257822',4905092,'2135','322',5203237.73,5203237.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257823',4905093,'2135','322',5203237.73,5210533.01,0.00,0.00,7295.28,4988754.00,0.00,0.00,0.00),('1','141','764','257824',4905094,'2135','322',5210533.01,5221892.20,0.00,0.00,11359.19,7768088.10,0.00,0.00,0.00),('1','141','764','257825',4905095,'2135','322',5221892.20,5227971.98,0.00,0.00,6079.78,4162060.00,0.00,0.00,0.00),('1','141','764','257826',4905096,'2135','322',5227971.98,5227971.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257827',4905097,'2135','322',5227971.98,5238320.27,0.00,0.00,10348.29,7075426.80,0.00,0.00,0.00),('1','141','764','257828',4905098,'2135','322',5238320.27,5248299.71,0.00,0.00,9979.44,6844029.60,0.00,0.00,0.00),('1','141','764','257829',4905099,'2135','322',5248299.71,5252936.42,0.00,0.00,4636.71,3172081.20,0.00,0.00,0.00),('1','141','764','257830',4905100,'2135','322',5252936.42,5252936.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257831',4905101,'2135','322',5252936.42,5271968.08,0.00,0.00,19031.66,12992213.70,0.00,0.00,0.00),('1','141','764','257832',4905102,'2135','322',5271968.08,5277413.52,0.00,0.00,5445.44,3713848.60,0.00,0.00,0.00),('1','141','764','257833',4905103,'2135','322',5277413.52,5277413.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257834',4905104,'2135','322',5277413.52,5291529.59,0.00,0.00,14116.07,9622295.70,0.00,0.00,0.00),('1','141','764','257835',4905105,'2135','322',5291529.59,5302149.86,0.00,0.00,10620.27,7281154.10,0.00,0.00,0.00),('1','141','764','257836',4905106,'2135','322',5302149.86,5302149.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257837',4905107,'2135','322',5302149.86,5312274.87,0.00,0.00,10125.01,6937045.50,0.00,0.00,0.00),('1','141','764','257838',4905108,'2135','322',5312274.87,5326728.90,0.00,0.00,14454.03,9854825.20,0.00,0.00,0.00),('1','141','764','257839',4905109,'2135','322',5326728.90,5326728.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257840',4905110,'2135','322',5326728.90,5326728.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257841',4905111,'2135','322',5326728.90,5330963.92,0.00,0.00,4235.02,2908917.50,0.00,0.00,0.00),('1','141','764','257842',4905112,'2135','322',5330963.92,5341961.45,0.00,0.00,10997.53,7524557.50,0.00,0.00,0.00),('1','141','764','257843',4905113,'2135','322',5341961.45,5347751.76,0.00,0.00,5790.31,3980085.60,0.00,0.00,0.00),('1','141','764','257844',4905114,'2135','322',5347751.76,5351397.58,0.00,0.00,3645.82,2492701.90,0.00,0.00,0.00),('1','141','764','257845',4905115,'2135','322',5351397.58,5351397.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257846',4905116,'2135','322',5351397.58,5355175.88,0.00,0.00,3778.30,2552846.00,0.00,0.00,0.00),('1','141','764','257847',4905117,'2135','322',5355175.88,5363725.84,0.00,0.00,8549.96,5773065.30,0.00,0.00,0.00),('1','141','764','257848',4905118,'2135','322',5363725.84,5368115.66,0.00,0.00,4389.82,2961492.00,0.00,0.00,0.00),('1','141','764','257849',4905119,'2135','322',5368115.66,5376072.10,0.00,0.00,7956.44,5350200.60,0.00,0.00,0.00),('1','141','764','257850',4905120,'2135','322',5376072.10,5376072.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257851',4905121,'2135','322',5376072.10,5380358.71,0.00,0.00,4286.61,2895465.40,0.00,0.00,0.00),('1','141','764','257852',4905122,'2135','322',5380358.71,5389702.50,0.00,0.00,9343.79,6312824.60,0.00,0.00,0.00),('1','141','764','257853',4905123,'2135','322',5389702.50,5399274.94,0.00,0.00,9572.44,6455488.60,0.00,0.00,0.00),('1','141','764','257854',4905124,'2135','322',5399274.94,5400787.64,0.00,0.00,1512.70,1015909.30,0.00,0.00,0.00),('1','141','764','257855',4905125,'2135','322',5400787.64,5400787.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257856',4905126,'2135','322',5400787.64,5407951.12,0.00,0.00,7163.48,4837825.10,0.00,0.00,0.00),('1','141','764','257857',4905127,'2135','322',5407951.12,5418223.03,0.00,0.00,10271.91,6923712.80,0.00,0.00,0.00),('1','141','764','257858',4905128,'2135','322',5418223.03,5425030.52,0.00,0.00,6807.49,4585642.90,0.00,0.00,0.00),('1','141','764','257859',4905129,'2135','322',5425030.52,5425030.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257860',4905130,'2135','322',5425030.52,5430371.09,0.00,0.00,5340.57,3593448.90,0.00,0.00,0.00),('1','141','764','257861',4905131,'2135','322',5430371.09,5441242.30,0.00,0.00,10871.21,7321480.60,0.00,0.00,0.00),('1','141','764','257862',4905132,'2135','322',5441242.30,5449683.32,0.00,0.00,8441.02,5677998.90,0.00,0.00,0.00),('1','141','764','257863',4905133,'2135','322',5449683.32,5449683.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257864',4905134,'2135','322',5449683.32,5460557.19,0.00,0.00,10873.87,7321104.00,0.00,0.00,0.00),('1','141','764','257865',4905135,'2135','322',5460557.19,5469586.91,0.00,0.00,9029.72,6088910.80,0.00,0.00,0.00),('1','141','764','257866',4905136,'2135','322',5469586.91,5474420.36,0.00,0.00,4833.45,3255044.90,0.00,0.00,0.00),('1','141','764','257867',4905137,'2135','322',5474420.36,5474420.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257868',4905138,'2135','322',5474420.36,5478263.39,0.00,0.00,3843.03,2587180.20,0.00,0.00,0.00),('1','141','764','257869',4905139,'2135','322',5478263.39,5487414.47,0.00,0.00,9151.08,6174921.10,0.00,0.00,0.00),('1','141','764','257870',4905140,'2135','322',5487414.47,5492937.92,0.00,0.00,5523.45,3723955.70,0.00,0.00,0.00),('1','141','764','257871',4905141,'2135','322',5492937.92,5499063.49,0.00,0.00,6125.57,4127367.70,0.00,0.00,0.00),('1','141','764','257872',4905142,'2135','322',5499063.49,5499063.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257873',4905143,'2135','322',5499063.49,5502356.98,0.00,0.00,3293.49,2224738.90,0.00,0.00,0.00),('1','141','764','257874',4905144,'2135','322',5502356.98,5513331.64,0.00,0.00,10974.66,7394452.40,0.00,0.00,0.00),('1','141','764','257875',4905145,'2135','322',5513331.64,5520276.11,0.00,0.00,6944.47,4694829.20,0.00,0.00,0.00),('1','141','764','257876',4905146,'2135','322',5520276.11,5523566.84,0.00,0.00,3290.73,2211525.20,0.00,0.00,0.00),('1','141','764','257877',4905147,'2135','322',5523566.84,5523566.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257878',4905148,'2135','322',5523566.84,5528571.49,0.00,0.00,5004.65,3374023.10,0.00,0.00,0.00),('1','141','764','257879',4905149,'2135','322',5528571.49,5536371.06,0.00,0.00,7799.57,5270233.30,0.00,0.00,0.00),('1','141','764','257880',4905150,'2135','322',5536371.06,5544063.14,0.00,0.00,7692.08,5204570.30,0.00,0.00,0.00),('1','141','764','257881',4905151,'2135','322',5544063.14,5548262.39,0.00,0.00,4199.25,2833399.20,0.00,0.00,0.00),('1','141','764','257882',4905152,'2135','322',5548262.39,5548262.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257883',4905153,'2135','322',5548262.39,5556257.01,0.00,0.00,7994.62,5402884.50,0.00,0.00,0.00),('1','141','764','257884',4905154,'2135','322',5556257.01,5563624.98,0.00,0.00,7367.97,4974870.50,0.00,0.00,0.00),('1','141','764','257885',4905155,'2135','322',5563624.98,5570516.09,0.00,0.00,6891.11,4596095.80,0.00,0.00,0.00),('1','141','764','257886',4905156,'2135','322',5570516.09,5572973.46,0.00,0.00,2457.37,1626651.00,0.00,0.00,0.00),('1','141','764','257887',4905157,'2135','322',5572973.46,5572973.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257888',4905158,'2135','322',5572973.46,5578143.92,0.00,0.00,5170.46,3428977.20,0.00,0.00,0.00),('1','141','764','257889',4905159,'2135','322',5578143.92,5587597.51,0.00,0.00,9453.59,6269374.20,0.00,0.00,0.00),('1','141','764','257890',4905160,'2135','322',5587597.51,5594937.93,0.00,0.00,7340.42,4891335.00,0.00,0.00,0.00),('1','141','764','257891',4905161,'2135','322',5594937.93,5597525.60,0.00,0.00,2587.67,1716410.40,0.00,0.00,0.00),('1','141','764','257892',4905162,'2135','322',5597525.60,5597525.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257893',4905163,'2135','322',5597525.60,5611946.95,0.00,0.00,14421.35,9572823.60,0.00,0.00,0.00),('1','141','764','257894',4905164,'2135','322',5611946.95,5622089.85,0.00,0.00,10142.90,6725296.80,0.00,0.00,0.00),('1','141','764','257895',4905165,'2135','322',5622089.85,5622089.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257896',4905166,'2135','322',5622089.85,5631501.04,0.00,0.00,9411.19,6249366.00,0.00,0.00,0.00),('1','141','764','257897',4905167,'2135','322',5631501.04,5645743.20,0.00,0.00,14242.16,9446657.40,0.00,0.00,0.00),('1','141','764','257898',4905168,'2135','322',5645743.20,5646846.93,0.00,0.00,1103.73,729765.60,0.00,0.00,0.00),('1','141','764','257899',4905169,'2135','322',5646846.93,5646846.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257900',4905170,'2135','322',5646846.93,5654512.57,0.00,0.00,7665.64,5080067.40,0.00,0.00,0.00),('1','141','764','257901',4905171,'2135','322',5654512.57,5664434.58,0.00,0.00,9922.01,6591887.40,0.00,0.00,0.00),('1','141','764','257902',4905172,'2135','322',5664434.58,5671353.60,0.00,0.00,6919.02,4605361.20,0.00,0.00,0.00),('1','141','764','257903',4905173,'2135','322',5671353.60,5671353.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257904',4905174,'2135','322',5671353.60,5680422.89,0.00,0.00,9069.29,6022602.00,0.00,0.00,0.00),('1','141','764','257905',4905175,'2135','322',5680422.89,5689473.30,0.00,0.00,9050.41,5868938.15,0.00,0.00,0.00),('1','141','764','257906',4905176,'2135','322',5689473.30,5695782.81,0.00,0.00,6309.51,4085804.50,0.00,0.00,0.00),('1','141','764','257907',4905177,'2135','322',5695782.81,5695782.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257908',4905178,'2135','322',5695782.81,5701169.77,0.00,0.00,5386.96,3489704.85,0.00,0.00,0.00),('1','141','764','257909',4905179,'2135','322',5701169.77,5711717.98,0.00,0.00,10548.21,6853001.95,0.00,0.00,0.00),('1','141','764','257910',4905180,'2135','322',5711717.98,5720535.88,0.00,0.00,8817.90,5707175.55,0.00,0.00,0.00),('1','141','764','257911',4905181,'2135','322',5720535.88,5720535.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257912',4905182,'2135','322',5720535.88,5734602.94,0.00,0.00,14067.06,9117705.25,0.00,0.00,0.00),('1','141','764','257913',4905183,'2135','322',5734602.94,5745035.62,0.00,0.00,10432.68,6769522.85,0.00,0.00,0.00),('1','141','764','257914',4905184,'2135','322',5745035.62,5745035.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257915',4905185,'2135','322',5745035.62,5750423.48,0.00,0.00,5387.86,3498124.50,0.00,0.00,0.00),('1','141','764','257916',4905186,'2135','322',5750423.48,5758549.10,0.00,0.00,8125.62,5260961.30,0.00,0.00,0.00),('1','141','764','257917',4905187,'2135','322',5758549.10,5768631.20,0.00,0.00,10082.10,6539195.65,0.00,0.00,0.00),('1','141','764','257918',4905188,'2135','322',5768631.20,5769768.30,0.00,0.00,1137.10,734372.20,0.00,0.00,0.00),('1','141','764','257919',4905189,'2135','322',5769768.30,5769768.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257920',4905190,'2135','322',5769768.30,5778531.41,0.00,0.00,8763.11,5675672.25,0.00,0.00,0.00),('1','141','764','257921',4905191,'2135','322',5778531.41,5789978.98,0.00,0.00,11447.57,7582564.60,0.00,0.00,0.00),('1','141','764','257922',4905192,'2135','322',5789978.98,5794408.22,0.00,0.00,4429.24,2934268.00,0.00,0.00,0.00),('1','141','764','257923',4905193,'2135','322',5794408.22,5794408.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257924',4905194,'2135','322',5794408.22,5804305.81,0.00,0.00,9897.59,6569705.80,0.00,0.00,0.00),('1','141','764','257925',4905195,'2135','322',5804305.81,5808480.98,0.00,0.00,4175.17,2766270.60,0.00,0.00,0.00),('1','141','764','257926',4905196,'2135','322',5808480.98,5817434.92,0.00,0.00,8953.94,5937916.40,0.00,0.00,0.00),('1','141','764','257927',4905197,'2135','322',5817434.92,5819002.91,0.00,0.00,1567.99,1039359.40,0.00,0.00,0.00),('1','141','764','257928',4905198,'2135','322',5819002.91,5819002.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257929',4905199,'2135','322',5819002.91,5823880.79,0.00,0.00,4877.88,3331601.60,0.00,0.00,0.00),('1','141','764','257930',4905200,'2135','322',5823880.79,5831503.50,0.00,0.00,7622.71,5208752.00,0.00,0.00,0.00),('1','141','764','257931',4905201,'2135','322',5831503.50,5835599.76,0.00,0.00,4096.26,2816867.20,0.00,0.00,0.00),('1','141','764','257932',4905202,'2135','322',5835599.76,5835972.65,0.00,0.00,372.89,268480.80,0.00,0.00,0.00),('1','141','764','257932',4905203,'2136','322',0.00,742.68,0.00,0.00,742.68,505022.40,0.00,0.00,0.00),('1','141','764','257932',4905204,'2137','322',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257932',4905205,'2138','322',0.00,733.50,0.00,0.00,733.50,498780.00,0.00,0.00,0.00),('1','141','764','257932',4905206,'2139','322',0.00,991.00,0.00,0.00,991.00,673880.00,0.00,0.00,0.00),('1','141','764','257932',4905207,'2140','322',0.00,857.50,0.00,0.00,857.50,583100.00,0.00,0.00,0.00),('1','141','764','257932',4905208,'2141','322',0.00,659.50,0.00,0.00,659.50,448460.00,0.00,0.00,0.00),('1','141','764','257932',4905209,'2142','322',0.00,808.00,0.00,0.00,808.00,554180.00,0.00,0.00,0.00),('1','141','764','257933',4905210,'2135','322',5835972.65,5835972.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257933',4905211,'2136','322',742.68,742.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257933',4905212,'2137','322',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257933',4905213,'2138','322',733.50,733.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257933',4905214,'2139','322',991.00,991.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257933',4905215,'2140','322',857.50,857.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257933',4905216,'2141','322',659.50,659.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257933',4905217,'2142','322',808.00,808.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257934',4905218,'2135','322',5835972.65,5836683.11,0.00,0.00,710.46,511531.20,0.00,0.00,0.00),('1','141','764','257934',4905219,'2136','322',742.68,1997.90,0.00,0.00,1255.22,853549.60,0.00,0.00,0.00),('1','141','764','257934',4905220,'2137','322',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257934',4905221,'2138','322',733.50,2105.00,0.00,0.00,1371.50,932620.00,0.00,0.00,0.00),('1','141','764','257934',4905222,'2139','322',991.00,2393.39,0.00,0.00,1402.39,953625.20,0.00,0.00,0.00),('1','141','764','257934',4905223,'2140','322',857.50,2303.40,0.00,0.00,1445.90,983212.00,0.00,0.00,0.00),('1','141','764','257934',4905224,'2141','322',659.50,2360.50,0.00,0.00,1701.00,1156680.00,0.00,0.00,0.00),('1','141','764','257934',4905225,'2142','322',808.00,2582.30,0.00,0.00,1774.30,1206524.00,0.00,0.00,0.00),('1','141','764','257935',4905226,'2135','322',5836683.11,5837188.78,0.00,0.00,505.67,364082.40,0.00,0.00,0.00),('1','141','764','257935',4905227,'2136','322',1997.90,3197.22,0.00,0.00,1199.32,815660.00,0.00,0.00,0.00),('1','141','764','257935',4905228,'2137','322',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257935',4905229,'2138','322',2105.00,3524.15,0.00,0.00,1419.15,965022.00,0.00,0.00,0.00),('1','141','764','257935',4905230,'2139','322',2393.39,3713.39,0.00,0.00,1320.00,897600.00,0.00,0.00,0.00),('1','141','764','257935',4905231,'2140','322',2303.40,3741.40,0.00,0.00,1438.00,977840.00,0.00,0.00,0.00),('1','141','764','257935',4905232,'2141','322',2360.50,3791.00,0.00,0.00,1430.50,972740.00,0.00,0.00,0.00),('1','141','764','257935',4905233,'2142','322',2582.30,3784.30,0.00,0.00,1202.00,817360.00,0.00,0.00,0.00),('1','141','764','257936',4905234,'2135','322',5837188.78,5837831.03,0.00,0.00,642.25,462420.00,0.00,0.00,0.00),('1','141','764','257936',4905235,'2136','322',3197.22,3924.33,0.00,0.00,727.11,494434.80,0.00,0.00,0.00),('1','141','764','257936',4905236,'2137','322',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257936',4905237,'2138','322',3524.15,4286.38,0.00,0.00,762.23,518538.80,0.00,0.00,0.00),('1','141','764','257936',4905238,'2139','322',3713.39,4584.55,0.00,0.00,871.16,592388.80,0.00,0.00,0.00),('1','141','764','257936',4905239,'2140','322',3741.40,4573.90,0.00,0.00,832.50,566100.00,0.00,0.00,0.00),('1','141','764','257936',4905240,'2141','322',3791.00,4835.00,0.00,0.00,1044.00,709920.00,0.00,0.00,0.00),('1','141','764','257936',4905241,'2142','322',3784.30,4397.30,0.00,0.00,613.00,416840.00,0.00,0.00,0.00),('1','141','764','257937',4905242,'2135','322',5837831.03,5837901.02,0.00,0.00,69.99,50392.80,0.00,0.00,0.00),('1','141','764','257937',4905243,'2136','322',3924.33,3924.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257937',4905244,'2137','322',0.00,3.00,0.00,0.00,3.00,2040.00,0.00,0.00,0.00),('1','141','764','257937',4905245,'2138','322',4286.38,4398.38,0.00,0.00,112.00,76160.00,0.00,0.00,0.00),('1','141','764','257937',4905246,'2139','322',4584.55,4684.55,0.00,0.00,100.00,68000.00,0.00,0.00,0.00),('1','141','764','257937',4905247,'2140','322',4573.90,4632.70,0.00,0.00,58.80,39984.00,0.00,0.00,0.00),('1','141','764','257937',4905248,'2141','322',4835.00,4982.83,0.00,0.00,147.83,100524.40,0.00,0.00,0.00),('1','141','764','257937',4905249,'2142','322',4397.30,4457.59,0.00,0.00,60.29,40997.20,0.00,0.00,0.00),('1','141','764','257938',4905250,'2135','322',5837901.02,5837901.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257938',4905251,'2136','322',3924.33,3924.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257938',4905252,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257938',4905253,'2138','322',4398.38,4398.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257938',4905254,'2139','322',4684.55,4684.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257938',4905255,'2140','322',4632.70,4632.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257938',4905256,'2141','322',4982.83,4982.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257938',4905257,'2142','322',4457.59,4457.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257939',4905258,'2135','322',5837901.02,5838363.90,0.00,0.00,462.88,333273.60,0.00,0.00,0.00),('1','141','764','257939',4905259,'2136','322',3924.33,4608.78,0.00,0.00,684.45,465426.00,0.00,0.00,0.00),('1','141','764','257939',4905260,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257939',4905261,'2138','322',4398.38,5261.38,0.00,0.00,863.00,586840.00,0.00,0.00,0.00),('1','141','764','257939',4905262,'2139','322',4684.55,5445.55,0.00,0.00,761.00,517480.00,0.00,0.00,0.00),('1','141','764','257939',4905263,'2140','322',4632.70,5497.92,0.00,0.00,865.22,588349.60,0.00,0.00,0.00),('1','141','764','257939',4905264,'2141','322',4982.83,5858.00,0.00,0.00,875.17,595115.60,0.00,0.00,0.00),('1','141','764','257939',4905265,'2142','322',4457.59,5212.29,0.00,0.00,754.70,513196.00,0.00,0.00,0.00),('1','141','764','257940',4905266,'2135','322',5838363.90,5839141.12,0.00,0.00,777.22,559598.40,0.00,0.00,0.00),('1','141','764','257940',4905267,'2136','322',4608.78,6000.04,0.00,0.00,1391.26,946796.80,0.00,0.00,0.00),('1','141','764','257940',4905268,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257940',4905269,'2138','322',5261.38,6631.54,0.00,0.00,1370.16,931708.80,0.00,0.00,0.00),('1','141','764','257940',4905270,'2139','322',5445.55,6361.55,0.00,0.00,916.00,622880.00,0.00,0.00,0.00),('1','141','764','257940',4905271,'2140','322',5497.92,6642.42,0.00,0.00,1144.50,778260.00,0.00,0.00,0.00),('1','141','764','257940',4905272,'2141','322',5858.00,7355.50,0.00,0.00,1497.50,1018300.00,0.00,0.00,0.00),('1','141','764','257940',4905273,'2142','322',5212.29,6634.71,0.00,0.00,1422.42,967245.60,0.00,0.00,0.00),('1','141','764','257941',4905274,'2135','322',5839141.12,5839424.21,0.00,0.00,283.09,203824.80,0.00,0.00,0.00),('1','141','764','257941',4905275,'2136','322',6000.04,6891.52,0.00,0.00,891.48,606206.40,0.00,0.00,0.00),('1','141','764','257941',4905276,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257941',4905277,'2138','322',6631.54,7246.04,0.00,0.00,614.50,417860.00,0.00,0.00,0.00),('1','141','764','257941',4905278,'2139','322',6361.55,6935.55,0.00,0.00,574.00,390320.00,0.00,0.00,0.00),('1','141','764','257941',4905279,'2140','322',6642.42,7065.42,0.00,0.00,423.00,287640.00,0.00,0.00,0.00),('1','141','764','257941',4905280,'2141','322',7355.50,8141.00,0.00,0.00,785.50,534140.00,0.00,0.00,0.00),('1','141','764','257941',4905281,'2142','322',6634.71,7066.71,0.00,0.00,432.00,293760.00,0.00,0.00,0.00),('1','141','764','257942',4905282,'2135','322',5839424.21,5839739.14,0.00,0.00,314.93,226749.60,0.00,0.00,0.00),('1','141','764','257942',4905283,'2136','322',6891.52,7417.32,0.00,0.00,525.80,357544.00,0.00,0.00,0.00),('1','141','764','257942',4905284,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257942',4905285,'2138','322',7246.04,7742.54,0.00,0.00,496.50,337620.00,0.00,0.00,0.00),('1','141','764','257942',4905286,'2139','322',6935.55,7385.55,0.00,0.00,450.00,306000.00,0.00,0.00,0.00),('1','141','764','257942',4905287,'2140','322',7065.42,7538.92,0.00,0.00,473.50,321980.00,0.00,0.00,0.00),('1','141','764','257942',4905288,'2141','322',8141.00,8833.00,0.00,0.00,692.00,470560.00,0.00,0.00,0.00),('1','141','764','257942',4905289,'2142','322',7066.71,7673.21,0.00,0.00,606.50,412420.00,0.00,0.00,0.00),('1','141','764','257943',4905290,'2135','322',5839739.14,5839740.53,0.00,0.00,1.39,1000.80,0.00,0.00,0.00),('1','141','764','257943',4905291,'2136','322',7417.32,7417.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257943',4905292,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257943',4905293,'2138','322',7742.54,7742.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257943',4905294,'2139','322',7385.55,7385.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257943',4905295,'2140','322',7538.92,7538.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257943',4905296,'2141','322',8833.00,8883.00,0.00,0.00,50.00,34000.00,0.00,0.00,0.00),('1','141','764','257943',4905297,'2142','322',7673.21,7673.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257944',4905298,'2135','322',5839740.53,5839854.15,0.00,0.00,113.62,81806.40,0.00,0.00,0.00),('1','141','764','257944',4905299,'2136','322',7417.32,8053.38,0.00,0.00,636.06,432643.20,0.00,0.00,0.00),('1','141','764','257944',4905300,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257944',4905301,'2138','322',7742.54,8282.54,0.00,0.00,540.00,367200.00,0.00,0.00,0.00),('1','141','764','257944',4905302,'2139','322',7385.55,7857.55,0.00,0.00,472.00,320960.00,0.00,0.00,0.00),('1','141','764','257944',4905303,'2140','322',7538.92,8022.92,0.00,0.00,484.00,329120.00,0.00,0.00,0.00),('1','141','764','257944',4905304,'2141','322',8883.00,9232.00,0.00,0.00,349.00,237320.00,0.00,0.00,0.00),('1','141','764','257944',4905305,'2142','322',7673.21,8033.21,0.00,0.00,360.00,244800.00,0.00,0.00,0.00),('1','141','764','257945',4905306,'2135','322',5839854.15,5839854.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257945',4905307,'2136','322',8053.38,8053.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257945',4905308,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257945',4905309,'2138','322',8282.54,8282.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257945',4905310,'2139','322',7857.55,7857.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257945',4905311,'2140','322',8022.92,8022.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257945',4905312,'2141','322',9232.00,9232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257945',4905313,'2142','322',8033.21,8033.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257946',4905314,'2135','322',5839854.15,5840424.13,0.00,0.00,569.98,410385.60,0.00,0.00,0.00),('1','141','764','257946',4905315,'2136','322',8053.38,8809.80,0.00,0.00,756.42,514365.60,0.00,0.00,0.00),('1','141','764','257946',4905316,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257946',4905317,'2138','322',8282.54,9006.54,0.00,0.00,724.00,492320.00,0.00,0.00,0.00),('1','141','764','257946',4905318,'2139','322',7857.55,8947.05,0.00,0.00,1089.50,740860.00,0.00,0.00,0.00),('1','141','764','257946',4905319,'2140','322',8022.92,8611.42,0.00,0.00,588.50,400180.00,0.00,0.00,0.00),('1','141','764','257946',4905320,'2141','322',9232.00,10211.00,0.00,0.00,979.00,665720.00,0.00,0.00,0.00),('1','141','764','257946',4905321,'2142','322',8033.21,8997.18,0.00,0.00,963.97,655499.60,0.00,0.00,0.00),('1','141','764','257947',4905322,'2135','322',5840424.13,5841202.89,0.00,0.00,778.76,560707.20,0.00,0.00,0.00),('1','141','764','257947',4905323,'2136','322',8809.80,10166.65,0.00,0.00,1356.85,922658.00,0.00,0.00,0.00),('1','141','764','257947',4905324,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257947',4905325,'2138','322',9006.54,10275.54,0.00,0.00,1269.00,862920.00,0.00,0.00,0.00),('1','141','764','257947',4905326,'2139','322',8947.05,10382.55,0.00,0.00,1435.50,976140.00,0.00,0.00,0.00),('1','141','764','257947',4905327,'2140','322',8611.42,9664.92,0.00,0.00,1053.50,716380.00,0.00,0.00,0.00),('1','141','764','257947',4905328,'2141','322',10211.00,10651.50,0.00,0.00,440.50,299540.00,0.00,0.00,0.00),('1','141','764','257947',4905329,'2142','322',8997.18,9290.18,0.00,0.00,293.00,199240.00,0.00,0.00,0.00),('1','141','764','257948',4905330,'2135','322',5841202.89,5841897.00,0.00,0.00,694.11,499759.20,0.00,0.00,0.00),('1','141','764','257948',4905331,'2136','322',10166.65,11179.15,0.00,0.00,1012.50,688500.00,0.00,0.00,0.00),('1','141','764','257948',4905332,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257948',4905333,'2138','322',10275.54,11497.30,0.00,0.00,1221.76,830796.80,0.00,0.00,0.00),('1','141','764','257948',4905334,'2139','322',10382.55,11533.55,0.00,0.00,1151.00,782680.00,0.00,0.00,0.00),('1','141','764','257948',4905335,'2140','322',9664.92,10964.92,0.00,0.00,1300.00,884000.00,0.00,0.00,0.00),('1','141','764','257948',4905336,'2141','322',10651.50,11109.68,0.00,0.00,458.18,311562.40,0.00,0.00,0.00),('1','141','764','257948',4905337,'2142','322',9290.18,9678.18,0.00,0.00,388.00,263840.00,0.00,0.00,0.00),('1','141','764','257949',4905338,'2135','322',5841897.00,5842228.57,0.00,0.00,331.57,232099.00,0.00,0.00,0.00),('1','141','764','257949',4905339,'2136','322',11179.15,12412.87,0.00,0.00,1233.72,814255.20,0.00,0.00,0.00),('1','141','764','257949',4905340,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257949',4905341,'2138','322',11497.30,13316.80,0.00,0.00,1819.50,1200870.00,0.00,0.00,0.00),('1','141','764','257949',4905342,'2139','322',11533.55,12724.55,0.00,0.00,1191.00,786060.00,0.00,0.00,0.00),('1','141','764','257949',4905343,'2140','322',10964.92,12214.67,0.00,0.00,1249.75,824835.00,0.00,0.00,0.00),('1','141','764','257949',4905344,'2141','322',11109.68,11338.18,0.00,0.00,228.50,150810.00,0.00,0.00,0.00),('1','141','764','257949',4905345,'2142','322',9678.18,9814.18,0.00,0.00,136.00,89760.00,0.00,0.00,0.00),('1','141','764','257950',4905346,'2135','322',5842228.57,5842228.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257950',4905347,'2136','322',12412.87,12412.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257950',4905348,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257950',4905349,'2138','322',13316.80,13316.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257950',4905350,'2139','322',12724.55,12724.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257950',4905351,'2140','322',12214.67,12214.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257950',4905352,'2141','322',11338.18,11338.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257950',4905353,'2142','322',9814.18,9814.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257951',4905354,'2135','322',5842228.57,5843070.27,0.00,0.00,841.70,589190.00,0.00,0.00,0.00),('1','141','764','257951',4905355,'2136','322',12412.87,15093.76,0.00,0.00,2680.89,1769387.40,0.00,0.00,0.00),('1','141','764','257951',4905356,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257951',4905357,'2138','322',13316.80,16653.30,0.00,0.00,3336.50,2202090.00,0.00,0.00,0.00),('1','141','764','257951',4905358,'2139','322',12724.55,15779.05,0.00,0.00,3054.50,2015970.00,0.00,0.00,0.00),('1','141','764','257951',4905359,'2140','322',12214.67,14888.67,0.00,0.00,2674.00,1764840.00,0.00,0.00,0.00),('1','141','764','257951',4905360,'2141','322',11338.18,11571.18,0.00,0.00,233.00,153780.00,0.00,0.00,0.00),('1','141','764','257951',4905361,'2142','322',9814.18,10043.18,0.00,0.00,229.00,151140.00,0.00,0.00,0.00),('1','141','764','257952',4905362,'2135','322',5843070.27,5843633.03,0.00,0.00,562.76,393412.00,0.00,0.00,0.00),('1','141','764','257952',4905363,'2136','322',15093.76,16674.29,0.00,0.00,1580.53,1043149.80,0.00,0.00,0.00),('1','141','764','257952',4905364,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257952',4905365,'2138','322',16653.30,18326.80,0.00,0.00,1673.50,1108510.00,0.00,0.00,0.00),('1','141','764','257952',4905366,'2139','322',15779.05,17408.55,0.00,0.00,1629.50,1075470.00,0.00,0.00,0.00),('1','141','764','257952',4905367,'2140','322',14888.67,16358.87,0.00,0.00,1470.20,970332.00,0.00,0.00,0.00),('1','141','764','257952',4905368,'2141','322',11571.18,11740.18,0.00,0.00,169.00,111540.00,0.00,0.00,0.00),('1','141','764','257952',4905369,'2142','322',10043.18,10061.68,0.00,0.00,18.50,12210.00,0.00,0.00,0.00),('1','141','764','257953',4905370,'2135','322',5843633.03,5843881.83,0.00,0.00,248.80,174160.00,0.00,0.00,0.00),('1','141','764','257953',4905371,'2136','322',16674.29,17670.87,0.00,0.00,996.58,657742.80,0.00,0.00,0.00),('1','141','764','257953',4905372,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257953',4905373,'2138','322',18326.80,19413.30,0.00,0.00,1086.50,717090.00,0.00,0.00,0.00),('1','141','764','257953',4905374,'2139','322',17408.55,18458.55,0.00,0.00,1050.00,693000.00,0.00,0.00,0.00),('1','141','764','257953',4905375,'2140','322',16358.87,17387.37,0.00,0.00,1028.50,678810.00,0.00,0.00,0.00),('1','141','764','257953',4905376,'2141','322',11740.18,11968.68,0.00,0.00,228.50,150810.00,0.00,0.00,0.00),('1','141','764','257953',4905377,'2142','322',10061.68,10091.68,0.00,0.00,30.00,19800.00,0.00,0.00,0.00),('1','141','764','257954',4905378,'2135','322',5843881.83,5843881.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257954',4905379,'2136','322',17670.87,17670.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257954',4905380,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257954',4905381,'2138','322',19413.30,19413.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257954',4905382,'2139','322',18458.55,18458.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257954',4905383,'2140','322',17387.37,17387.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257954',4905384,'2141','322',11968.68,11968.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257954',4905385,'2142','322',10091.68,10091.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257955',4905386,'2135','322',5843881.83,5844059.31,0.00,0.00,177.48,124236.00,0.00,0.00,0.00),('1','141','764','257955',4905387,'2136','322',17670.87,18009.37,0.00,0.00,338.50,223410.00,0.00,0.00,0.00),('1','141','764','257955',4905388,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257955',4905389,'2138','322',19413.30,19983.30,0.00,0.00,570.00,376200.00,0.00,0.00,0.00),('1','141','764','257955',4905390,'2139','322',18458.55,19079.05,0.00,0.00,620.50,409530.00,0.00,0.00,0.00),('1','141','764','257955',4905391,'2140','322',17387.37,18044.37,0.00,0.00,657.00,433620.00,0.00,0.00,0.00),('1','141','764','257955',4905392,'2141','322',11968.68,12049.98,0.00,0.00,81.30,53658.00,0.00,0.00,0.00),('1','141','764','257955',4905393,'2142','322',10091.68,10091.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257956',4905394,'2135','322',5844059.31,5844534.50,0.00,0.00,475.19,332633.00,0.00,0.00,0.00),('1','141','764','257956',4905395,'2136','322',18009.37,19820.37,0.00,0.00,1811.00,1195260.00,0.00,0.00,0.00),('1','141','764','257956',4905396,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257956',4905397,'2138','322',19983.30,21743.09,0.00,0.00,1759.79,1161461.40,0.00,0.00,0.00),('1','141','764','257956',4905398,'2139','322',19079.05,20915.55,0.00,0.00,1836.50,1212090.00,0.00,0.00,0.00),('1','141','764','257956',4905399,'2140','322',18044.37,19316.37,0.00,0.00,1272.00,839520.00,0.00,0.00,0.00),('1','141','764','257956',4905400,'2141','322',12049.98,12076.98,0.00,0.00,27.00,17820.00,0.00,0.00,0.00),('1','141','764','257956',4905401,'2142','322',10091.68,10241.68,0.00,0.00,150.00,99000.00,0.00,0.00,0.00),('1','141','764','257957',4905402,'2135','322',5844534.50,5845034.08,0.00,0.00,499.58,349706.00,0.00,0.00,0.00),('1','141','764','257957',4905403,'2136','322',19820.37,21506.87,0.00,0.00,1686.50,1115290.00,0.00,0.00,0.00),('1','141','764','257957',4905404,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257957',4905405,'2138','322',21743.09,23298.89,0.00,0.00,1555.80,1026828.00,0.00,0.00,0.00),('1','141','764','257957',4905406,'2139','322',20915.55,22989.55,0.00,0.00,2074.00,1368840.00,0.00,0.00,0.00),('1','141','764','257957',4905407,'2140','322',19316.37,21058.37,0.00,0.00,1742.00,1149720.00,0.00,0.00,0.00),('1','141','764','257957',4905408,'2141','322',12076.98,12076.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257957',4905409,'2142','322',10241.68,10376.68,0.00,0.00,135.00,89100.00,0.00,0.00,0.00),('1','141','764','257958',4905410,'2135','322',5845034.08,5845547.25,0.00,0.00,513.17,359219.00,0.00,0.00,0.00),('1','141','764','257958',4905411,'2136','322',21506.87,23104.37,0.00,0.00,1597.50,1054350.00,0.00,0.00,0.00),('1','141','764','257958',4905412,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257958',4905413,'2138','322',23298.89,25326.54,0.00,0.00,2027.65,1338249.00,0.00,0.00,0.00),('1','141','764','257958',4905414,'2139','322',22989.55,24717.05,0.00,0.00,1727.50,1140150.00,0.00,0.00,0.00),('1','141','764','257958',4905415,'2140','322',21058.37,22493.87,0.00,0.00,1435.50,947430.00,0.00,0.00,0.00),('1','141','764','257958',4905416,'2141','322',12076.98,12080.69,0.00,0.00,3.71,2448.60,0.00,0.00,0.00),('1','141','764','257958',4905417,'2142','322',10376.68,10410.82,0.00,0.00,34.14,22532.40,0.00,0.00,0.00),('1','141','764','257959',4905418,'2135','322',5845547.25,5845547.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257959',4905419,'2136','322',23104.37,23104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257959',4905420,'2137','322',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257959',4905421,'2138','322',25326.54,25326.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257959',4905422,'2139','322',24717.05,24717.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257959',4905423,'2140','322',22493.87,22493.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257959',4905424,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257959',4905425,'2142','322',10410.82,10410.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257960',4905426,'2135','322',5845547.25,5846326.67,0.00,0.00,779.42,545594.00,0.00,0.00,0.00),('1','141','764','257960',4905427,'2136','322',23104.37,25605.87,0.00,0.00,2501.50,1650990.00,0.00,0.00,0.00),('1','141','764','257960',4905428,'2137','322',3.00,6.00,0.00,0.00,3.00,1980.00,0.00,0.00,0.00),('1','141','764','257960',4905429,'2138','322',25326.54,27683.54,0.00,0.00,2357.00,1555620.00,0.00,0.00,0.00),('1','141','764','257960',4905430,'2139','322',24717.05,27220.05,0.00,0.00,2503.00,1651980.00,0.00,0.00,0.00),('1','141','764','257960',4905431,'2140','322',22493.87,24557.62,0.00,0.00,2063.75,1362075.00,0.00,0.00,0.00),('1','141','764','257960',4905432,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257960',4905433,'2142','322',10410.82,11310.82,0.00,0.00,900.00,594000.00,0.00,0.00,0.00),('1','141','764','257961',4905434,'2135','322',5846326.67,5846873.19,0.00,0.00,546.52,382564.00,0.00,0.00,0.00),('1','141','764','257961',4905435,'2136','322',25605.87,26837.37,0.00,0.00,1231.50,812790.00,0.00,0.00,0.00),('1','141','764','257961',4905436,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257961',4905437,'2138','322',27683.54,29003.84,0.00,0.00,1320.30,871398.00,0.00,0.00,0.00),('1','141','764','257961',4905438,'2139','322',27220.05,28517.05,0.00,0.00,1297.00,856020.00,0.00,0.00,0.00),('1','141','764','257961',4905439,'2140','322',24557.62,26008.82,0.00,0.00,1451.20,957792.00,0.00,0.00,0.00),('1','141','764','257961',4905440,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257961',4905441,'2142','322',11310.82,11468.07,0.00,0.00,157.25,103785.00,0.00,0.00,0.00),('1','141','764','257962',4905442,'2135','322',5846873.19,5847411.93,0.00,0.00,538.74,377118.00,0.00,0.00,0.00),('1','141','764','257962',4905443,'2136','322',26837.37,28224.05,0.00,0.00,1386.68,915208.80,0.00,0.00,0.00),('1','141','764','257962',4905444,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257962',4905445,'2138','322',29003.84,30791.84,0.00,0.00,1788.00,1180080.00,0.00,0.00,0.00),('1','141','764','257962',4905446,'2139','322',28517.05,30764.40,0.00,0.00,2247.35,1483251.00,0.00,0.00,0.00),('1','141','764','257962',4905447,'2140','322',26008.82,27305.82,0.00,0.00,1297.00,856020.00,0.00,0.00,0.00),('1','141','764','257962',4905448,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257962',4905449,'2142','322',11468.07,11719.57,0.00,0.00,251.50,165990.00,0.00,0.00,0.00),('1','141','764','257963',4905450,'2135','322',5847411.93,5847411.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257963',4905451,'2136','322',28224.05,28224.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257963',4905452,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257963',4905453,'2138','322',30791.84,30791.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257963',4905454,'2139','322',30764.40,30764.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257963',4905455,'2140','322',27305.82,27305.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257963',4905456,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257963',4905457,'2142','322',11719.57,11719.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257964',4905458,'2135','322',5847411.93,5847999.49,0.00,0.00,587.56,411292.00,0.00,0.00,0.00),('1','141','764','257964',4905459,'2136','322',28224.05,29627.55,0.00,0.00,1403.50,926310.00,0.00,0.00,0.00),('1','141','764','257964',4905460,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257964',4905461,'2138','322',30791.84,31964.80,0.00,0.00,1172.96,774153.60,0.00,0.00,0.00),('1','141','764','257964',4905462,'2139','322',30764.40,32150.40,0.00,0.00,1386.00,914760.00,0.00,0.00,0.00),('1','141','764','257964',4905463,'2140','322',27305.82,28379.87,0.00,0.00,1074.05,711873.00,0.00,0.00,0.00),('1','141','764','257964',4905464,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257964',4905465,'2142','322',11719.57,11832.07,0.00,0.00,112.50,74250.00,0.00,0.00,0.00),('1','141','764','257965',4905466,'2135','322',5847999.49,5848513.11,0.00,0.00,513.62,359534.00,0.00,0.00,0.00),('1','141','764','257965',4905467,'2136','322',29627.55,31002.70,0.00,0.00,1375.15,907599.00,0.00,0.00,0.00),('1','141','764','257965',4905468,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257965',4905469,'2138','322',31964.80,33370.93,0.00,0.00,1406.13,928045.80,0.00,0.00,0.00),('1','141','764','257965',4905470,'2139','322',32150.40,33879.40,0.00,0.00,1729.00,1141140.00,0.00,0.00,0.00),('1','141','764','257965',4905471,'2140','322',28379.87,29828.87,0.00,0.00,1449.00,956340.00,0.00,0.00,0.00),('1','141','764','257965',4905472,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257965',4905473,'2142','322',11832.07,12366.57,0.00,0.00,534.50,352770.00,0.00,0.00,0.00),('1','141','764','257966',4905474,'2135','322',5848513.11,5849113.27,0.00,0.00,600.16,420112.00,0.00,0.00,0.00),('1','141','764','257966',4905475,'2136','322',31002.70,31903.15,0.00,0.00,900.45,594297.00,0.00,0.00,0.00),('1','141','764','257966',4905476,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257966',4905477,'2138','322',33370.93,34759.63,0.00,0.00,1388.70,916542.00,0.00,0.00,0.00),('1','141','764','257966',4905478,'2139','322',33879.40,35438.40,0.00,0.00,1559.00,1028940.00,0.00,0.00,0.00),('1','141','764','257966',4905479,'2140','322',29828.87,31116.87,0.00,0.00,1288.00,850080.00,0.00,0.00,0.00),('1','141','764','257966',4905480,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257966',4905481,'2142','322',12366.57,12538.57,0.00,0.00,172.00,113520.00,0.00,0.00,0.00),('1','141','764','257967',4905482,'2135','322',5849113.27,5849431.29,0.00,0.00,318.02,222614.00,0.00,0.00,0.00),('1','141','764','257967',4905483,'2136','322',31903.15,33042.65,0.00,0.00,1139.50,752070.00,0.00,0.00,0.00),('1','141','764','257967',4905484,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257967',4905485,'2138','322',34759.63,35777.13,0.00,0.00,1017.50,671550.00,0.00,0.00,0.00),('1','141','764','257967',4905486,'2139','322',35438.40,36485.63,0.00,0.00,1047.23,691171.80,0.00,0.00,0.00),('1','141','764','257967',4905487,'2140','322',31116.87,32074.37,0.00,0.00,957.50,631950.00,0.00,0.00,0.00),('1','141','764','257967',4905488,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257967',4905489,'2142','322',12538.57,12666.07,0.00,0.00,127.50,84150.00,0.00,0.00,0.00),('1','141','764','257968',4905490,'2135','322',5849431.29,5849571.87,0.00,0.00,140.58,98406.00,0.00,0.00,0.00),('1','141','764','257968',4905491,'2136','322',33042.65,33355.38,0.00,0.00,312.73,206401.80,0.00,0.00,0.00),('1','141','764','257968',4905492,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257968',4905493,'2138','322',35777.13,36220.13,0.00,0.00,443.00,292380.00,0.00,0.00,0.00),('1','141','764','257968',4905494,'2139','322',36485.63,36952.63,0.00,0.00,467.00,308220.00,0.00,0.00,0.00),('1','141','764','257968',4905495,'2140','322',32074.37,32182.37,0.00,0.00,108.00,71280.00,0.00,0.00,0.00),('1','141','764','257968',4905496,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257968',4905497,'2142','322',12666.07,12666.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257969',4905498,'2135','322',5849571.87,5849571.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257969',4905499,'2136','322',33355.38,33355.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257969',4905500,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257969',4905501,'2138','322',36220.13,36220.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257969',4905502,'2139','322',36952.63,36952.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257969',4905503,'2140','322',32182.37,32182.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257969',4905504,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257969',4905505,'2142','322',12666.07,12666.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257970',4905506,'2135','322',5849571.87,5850185.66,0.00,0.00,613.79,429653.00,0.00,0.00,0.00),('1','141','764','257970',4905507,'2136','322',33355.38,35691.38,0.00,0.00,2336.00,1530080.00,0.00,0.00,0.00),('1','141','764','257970',4905508,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257970',4905509,'2138','322',36220.13,38814.13,0.00,0.00,2594.00,1699070.00,0.00,0.00,0.00),('1','141','764','257970',4905510,'2139','322',36952.63,39285.70,0.00,0.00,2333.07,1528160.85,0.00,0.00,0.00),('1','141','764','257970',4905511,'2140','322',32182.37,34650.37,0.00,0.00,2468.00,1616540.00,0.00,0.00,0.00),('1','141','764','257970',4905512,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257970',4905513,'2142','322',12666.07,13805.85,0.00,0.00,1139.78,746555.90,0.00,0.00,0.00),('1','141','764','257971',4905514,'2135','322',5850185.66,5850796.37,0.00,0.00,610.71,427497.00,0.00,0.00,0.00),('1','141','764','257971',4905515,'2136','322',35691.38,36986.88,0.00,0.00,1295.50,848665.00,0.00,0.00,0.00),('1','141','764','257971',4905516,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257971',4905517,'2138','322',38814.13,41173.29,0.00,0.00,2359.16,1545249.80,0.00,0.00,0.00),('1','141','764','257971',4905518,'2139','322',39285.70,41608.70,0.00,0.00,2323.00,1521565.00,0.00,0.00,0.00),('1','141','764','257971',4905519,'2140','322',34650.37,36341.68,0.00,0.00,1691.31,1107808.05,0.00,0.00,0.00),('1','141','764','257971',4905520,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257971',4905521,'2142','322',13805.85,14378.95,0.00,0.00,573.10,375380.50,0.00,0.00,0.00),('1','141','764','257972',4905522,'2135','322',5850796.37,5851002.94,0.00,0.00,206.57,144599.00,0.00,0.00,0.00),('1','141','764','257972',4905523,'2136','322',36986.88,37961.88,0.00,0.00,975.00,638625.00,0.00,0.00,0.00),('1','141','764','257972',4905524,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257972',4905525,'2138','322',41173.29,42084.79,0.00,0.00,911.50,597032.50,0.00,0.00,0.00),('1','141','764','257972',4905526,'2139','322',41608.70,42472.70,0.00,0.00,864.00,565920.00,0.00,0.00,0.00),('1','141','764','257972',4905527,'2140','322',36341.68,37312.44,0.00,0.00,970.76,635847.80,0.00,0.00,0.00),('1','141','764','257972',4905528,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257972',4905529,'2142','322',14378.95,14748.95,0.00,0.00,370.00,242350.00,0.00,0.00,0.00),('1','141','764','257973',4905530,'2135','322',5851002.94,5851002.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257973',4905531,'2136','322',37961.88,37961.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257973',4905532,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257973',4905533,'2138','322',42084.79,42084.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257973',4905534,'2139','322',42472.70,42472.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257973',4905535,'2140','322',37312.44,37312.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257973',4905536,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257973',4905537,'2142','322',14748.95,14748.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257974',4905538,'2135','322',5851002.94,5851183.77,0.00,0.00,180.83,126581.00,0.00,0.00,0.00),('1','141','764','257974',4905539,'2136','322',37961.88,38660.38,0.00,0.00,698.50,457517.50,0.00,0.00,0.00),('1','141','764','257974',4905540,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257974',4905541,'2138','322',42084.79,42706.29,0.00,0.00,621.50,407082.50,0.00,0.00,0.00),('1','141','764','257974',4905542,'2139','322',42472.70,43530.70,0.00,0.00,1058.00,692990.00,0.00,0.00,0.00),('1','141','764','257974',4905543,'2140','322',37312.44,38377.94,0.00,0.00,1065.50,697902.50,0.00,0.00,0.00),('1','141','764','257974',4905544,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257974',4905545,'2142','322',14748.95,15104.95,0.00,0.00,356.00,233180.00,0.00,0.00,0.00),('1','141','764','257975',4905546,'2135','322',5851183.77,5851732.86,0.00,0.00,549.09,384363.00,0.00,0.00,0.00),('1','141','764','257975',4905547,'2136','322',38660.38,40434.21,0.00,0.00,1773.83,1161858.65,0.00,0.00,0.00),('1','141','764','257975',4905548,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257975',4905549,'2138','322',42706.29,44385.44,0.00,0.00,1679.15,1099843.25,0.00,0.00,0.00),('1','141','764','257975',4905550,'2139','322',43530.70,45641.20,0.00,0.00,2110.50,1382377.50,0.00,0.00,0.00),('1','141','764','257975',4905551,'2140','322',38377.94,40213.44,0.00,0.00,1835.50,1202252.50,0.00,0.00,0.00),('1','141','764','257975',4905552,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257975',4905553,'2142','322',15104.95,15585.45,0.00,0.00,480.50,314727.50,0.00,0.00,0.00),('1','141','764','257976',4905554,'2135','322',5851732.86,5852047.44,0.00,0.00,314.58,220206.00,0.00,0.00,0.00),('1','141','764','257976',4905555,'2136','322',40434.21,41289.21,0.00,0.00,855.00,560025.00,0.00,0.00,0.00),('1','141','764','257976',4905556,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257976',4905557,'2138','322',44385.44,45585.44,0.00,0.00,1200.00,786000.00,0.00,0.00,0.00),('1','141','764','257976',4905558,'2139','322',45641.20,46764.52,0.00,0.00,1123.32,737259.60,0.00,0.00,0.00),('1','141','764','257976',4905559,'2140','322',40213.44,41178.94,0.00,0.00,965.50,632402.50,0.00,0.00,0.00),('1','141','764','257976',4905560,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257976',4905561,'2142','322',15585.45,15911.95,0.00,0.00,326.50,213857.50,0.00,0.00,0.00),('1','141','764','257977',4905562,'2135','322',5852047.44,5852508.94,0.00,0.00,461.50,323050.00,0.00,0.00,0.00),('1','141','764','257977',4905563,'2136','322',41289.21,42920.75,0.00,0.00,1631.54,1068658.70,0.00,0.00,0.00),('1','141','764','257977',4905564,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257977',4905565,'2138','322',45585.44,47089.44,0.00,0.00,1504.00,985120.00,0.00,0.00,0.00),('1','141','764','257977',4905566,'2139','322',46764.52,48042.52,0.00,0.00,1278.00,837090.00,0.00,0.00,0.00),('1','141','764','257977',4905567,'2140','322',41178.94,43040.94,0.00,0.00,1862.00,1219610.00,0.00,0.00,0.00),('1','141','764','257977',4905568,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257977',4905569,'2142','322',15911.95,16623.45,0.00,0.00,711.50,466032.50,0.00,0.00,0.00),('1','141','764','257978',4905570,'2135','322',5852508.94,5852508.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257978',4905571,'2136','322',42920.75,42920.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257978',4905572,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257978',4905573,'2138','322',47089.44,47089.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257978',4905574,'2139','322',48042.52,48042.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257978',4905575,'2140','322',43040.94,43040.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257978',4905576,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257978',4905577,'2142','322',16623.45,16623.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257979',4905578,'2135','322',5852508.94,5853260.66,0.00,0.00,751.72,526204.00,0.00,0.00,0.00),('1','141','764','257979',4905579,'2136','322',42920.75,45529.45,0.00,0.00,2608.70,1710048.50,0.00,0.00,0.00),('1','141','764','257979',4905580,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257979',4905581,'2138','322',47089.44,50000.23,0.00,0.00,2910.79,1906567.45,0.00,0.00,0.00),('1','141','764','257979',4905582,'2139','322',48042.52,50659.02,0.00,0.00,2616.50,1713807.50,0.00,0.00,0.00),('1','141','764','257979',4905583,'2140','322',43040.94,45572.44,0.00,0.00,2531.50,1658132.50,0.00,0.00,0.00),('1','141','764','257979',4905584,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257979',4905585,'2142','322',16623.45,17736.58,0.00,0.00,1113.13,729100.15,0.00,0.00,0.00),('1','141','764','257980',4905586,'2135','322',5853260.66,5853852.15,0.00,0.00,591.49,414043.00,0.00,0.00,0.00),('1','141','764','257980',4905587,'2136','322',45529.45,47608.45,0.00,0.00,2079.00,1362307.50,0.00,0.00,0.00),('1','141','764','257980',4905588,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257980',4905589,'2138','322',50000.23,52082.00,0.00,0.00,2081.77,1364121.85,0.00,0.00,0.00),('1','141','764','257980',4905590,'2139','322',50659.02,52406.81,0.00,0.00,1747.79,1145972.45,0.00,0.00,0.00),('1','141','764','257980',4905591,'2140','322',45572.44,47405.94,0.00,0.00,1833.50,1200942.50,0.00,0.00,0.00),('1','141','764','257980',4905592,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257980',4905593,'2142','322',17736.58,18072.87,0.00,0.00,336.29,220832.45,0.00,0.00,0.00),('1','141','764','257981',4905594,'2135','322',5853852.15,5853938.94,0.00,0.00,86.79,60753.00,0.00,0.00,0.00),('1','141','764','257981',4905595,'2136','322',47608.45,48347.45,0.00,0.00,739.00,484045.00,0.00,0.00,0.00),('1','141','764','257981',4905596,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257981',4905597,'2138','322',52082.00,53049.09,0.00,0.00,967.09,633443.95,0.00,0.00,0.00),('1','141','764','257981',4905598,'2139','322',52406.81,53191.81,0.00,0.00,785.00,514175.00,0.00,0.00,0.00),('1','141','764','257981',4905599,'2140','322',47405.94,48272.44,0.00,0.00,866.50,567557.50,0.00,0.00,0.00),('1','141','764','257981',4905600,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257981',4905601,'2142','322',18072.87,18604.87,0.00,0.00,532.00,348460.00,0.00,0.00,0.00),('1','141','764','257982',4905602,'2135','322',5853938.94,5853938.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257982',4905603,'2136','322',48347.45,48347.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257982',4905604,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257982',4905605,'2138','322',53049.09,53049.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257982',4905606,'2139','322',53191.81,53191.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257982',4905607,'2140','322',48272.44,48272.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257982',4905608,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257982',4905609,'2142','322',18604.87,18604.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257983',4905610,'2135','322',5853938.94,5854575.61,0.00,0.00,636.67,445669.00,0.00,0.00,0.00),('1','141','764','257983',4905611,'2136','322',48347.45,50230.67,0.00,0.00,1883.22,1233509.10,0.00,0.00,0.00),('1','141','764','257983',4905612,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257983',4905613,'2138','322',53049.09,55215.96,0.00,0.00,2166.87,1419299.85,0.00,0.00,0.00),('1','141','764','257983',4905614,'2139','322',53191.81,55612.31,0.00,0.00,2420.50,1585427.50,0.00,0.00,0.00),('1','141','764','257983',4905615,'2140','322',48272.44,50760.94,0.00,0.00,2488.50,1629967.50,0.00,0.00,0.00),('1','141','764','257983',4905616,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257983',4905617,'2142','322',18604.87,19564.37,0.00,0.00,959.50,628472.50,0.00,0.00,0.00),('1','141','764','257984',4905618,'2135','322',5854575.61,5855220.46,0.00,0.00,644.85,451395.00,0.00,0.00,0.00),('1','141','764','257984',4905619,'2136','322',50230.67,51288.53,0.00,0.00,1057.86,692898.30,0.00,0.00,0.00),('1','141','764','257984',4905620,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257984',4905621,'2138','322',55215.96,56797.46,0.00,0.00,1581.50,1035882.50,0.00,0.00,0.00),('1','141','764','257984',4905622,'2139','322',55612.31,56857.64,0.00,0.00,1245.33,815691.15,0.00,0.00,0.00),('1','141','764','257984',4905623,'2140','322',50760.94,52051.94,0.00,0.00,1291.00,845605.00,0.00,0.00,0.00),('1','141','764','257984',4905624,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257984',4905625,'2142','322',19564.37,19874.15,0.00,0.00,309.78,202905.90,0.00,0.00,0.00),('1','141','764','257985',4905626,'2135','322',5855220.46,5855450.52,0.00,0.00,230.06,161042.00,0.00,0.00,0.00),('1','141','764','257985',4905627,'2136','322',51288.53,52721.17,0.00,0.00,1432.64,938379.20,0.00,0.00,0.00),('1','141','764','257985',4905628,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257985',4905629,'2138','322',56797.46,57888.46,0.00,0.00,1091.00,714605.00,0.00,0.00,0.00),('1','141','764','257985',4905630,'2139','322',56857.64,58127.20,0.00,0.00,1269.56,831561.80,0.00,0.00,0.00),('1','141','764','257985',4905631,'2140','322',52051.94,53228.66,0.00,0.00,1176.72,770751.60,0.00,0.00,0.00),('1','141','764','257985',4905632,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257985',4905633,'2142','322',19874.15,20182.75,0.00,0.00,308.60,202133.00,0.00,0.00,0.00),('1','141','764','257986',4905634,'2135','322',5855450.52,5855627.03,0.00,0.00,176.51,123557.00,0.00,0.00,0.00),('1','141','764','257986',4905635,'2136','322',52721.17,53176.47,0.00,0.00,455.30,298221.50,0.00,0.00,0.00),('1','141','764','257986',4905636,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257986',4905637,'2138','322',57888.46,58385.46,0.00,0.00,497.00,325535.00,0.00,0.00,0.00),('1','141','764','257986',4905638,'2139','322',58127.20,58707.20,0.00,0.00,580.00,379900.00,0.00,0.00,0.00),('1','141','764','257986',4905639,'2140','322',53228.66,53738.66,0.00,0.00,510.00,334050.00,0.00,0.00,0.00),('1','141','764','257986',4905640,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257986',4905641,'2142','322',20182.75,20262.25,0.00,0.00,79.50,52072.50,0.00,0.00,0.00),('1','141','764','257987',4905642,'2135','322',5855627.03,5855627.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257987',4905643,'2136','322',53176.47,53176.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257987',4905644,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257987',4905645,'2138','322',58385.46,58385.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257987',4905646,'2139','322',58707.20,58707.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257987',4905647,'2140','322',53738.66,53738.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257987',4905648,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257987',4905649,'2142','322',20262.25,20262.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257988',4905650,'2135','322',5855627.03,5856085.15,0.00,0.00,458.12,320684.00,0.00,0.00,0.00),('1','141','764','257988',4905651,'2136','322',53176.47,54600.57,0.00,0.00,1424.10,932785.50,0.00,0.00,0.00),('1','141','764','257988',4905652,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257988',4905653,'2138','322',58385.46,60259.77,0.00,0.00,1874.31,1227673.05,0.00,0.00,0.00),('1','141','764','257988',4905654,'2139','322',58707.20,60163.40,0.00,0.00,1456.20,953811.00,0.00,0.00,0.00),('1','141','764','257988',4905655,'2140','322',53738.66,55069.66,0.00,0.00,1331.00,871805.00,0.00,0.00,0.00),('1','141','764','257988',4905656,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257988',4905657,'2142','322',20262.25,20686.39,0.00,0.00,424.14,277811.70,0.00,0.00,0.00),('1','141','764','257989',4905658,'2135','322',5856085.15,5856666.17,0.00,0.00,581.02,406714.00,0.00,0.00,0.00),('1','141','764','257989',4905659,'2136','322',54600.57,56389.01,0.00,0.00,1788.44,1171518.20,0.00,0.00,0.00),('1','141','764','257989',4905660,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257989',4905661,'2138','322',60259.77,62062.35,0.00,0.00,1802.58,1180689.90,0.00,0.00,0.00),('1','141','764','257989',4905662,'2139','322',60163.40,62112.90,0.00,0.00,1949.50,1276922.50,0.00,0.00,0.00),('1','141','764','257989',4905663,'2140','322',55069.66,56766.64,0.00,0.00,1696.98,1111521.90,0.00,0.00,0.00),('1','141','764','257989',4905664,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257989',4905665,'2142','322',20686.39,21311.03,0.00,0.00,624.64,409139.20,0.00,0.00,0.00),('1','141','764','257990',4905666,'2135','322',5856666.17,5857253.15,0.00,0.00,586.98,410886.00,0.00,0.00,0.00),('1','141','764','257990',4905667,'2136','322',56389.01,58356.01,0.00,0.00,1967.00,1288385.00,0.00,0.00,0.00),('1','141','764','257990',4905668,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257990',4905669,'2138','322',62062.35,64225.17,0.00,0.00,2162.82,1416647.10,0.00,0.00,0.00),('1','141','764','257990',4905670,'2139','322',62112.90,64415.76,0.00,0.00,2302.86,1508373.30,0.00,0.00,0.00),('1','141','764','257990',4905671,'2140','322',56766.64,58286.14,0.00,0.00,1519.50,995272.50,0.00,0.00,0.00),('1','141','764','257990',4905672,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257990',4905673,'2142','322',21311.03,22133.53,0.00,0.00,822.50,538737.50,0.00,0.00,0.00),('1','141','764','257991',4905674,'2135','322',5857253.15,5857253.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257991',4905675,'2136','322',58356.01,58356.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257991',4905676,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257991',4905677,'2138','322',64225.17,64225.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257991',4905678,'2139','322',64415.76,64415.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257991',4905679,'2140','322',58286.14,58286.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257991',4905680,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257991',4905681,'2142','322',22133.53,22133.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257992',4905682,'2135','322',5857253.15,5857383.09,0.00,0.00,129.94,90958.00,0.00,0.00,0.00),('1','141','764','257992',4905683,'2136','322',58356.01,58877.61,0.00,0.00,521.60,341648.00,0.00,0.00,0.00),('1','141','764','257992',4905684,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257992',4905685,'2138','322',64225.17,64896.17,0.00,0.00,671.00,439505.00,0.00,0.00,0.00),('1','141','764','257992',4905686,'2139','322',64415.76,65136.66,0.00,0.00,720.90,472189.50,0.00,0.00,0.00),('1','141','764','257992',4905687,'2140','322',58286.14,59026.14,0.00,0.00,740.00,484700.00,0.00,0.00,0.00),('1','141','764','257992',4905688,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257992',4905689,'2142','322',22133.53,22552.53,0.00,0.00,419.00,274445.00,0.00,0.00,0.00),('1','141','764','257993',4905690,'2135','322',5857383.09,5858070.13,0.00,0.00,687.04,480928.00,0.00,0.00,0.00),('1','141','764','257993',4905691,'2136','322',58877.61,60725.36,0.00,0.00,1847.75,1210861.25,0.00,0.00,0.00),('1','141','764','257993',4905692,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257993',4905693,'2138','322',64896.17,66687.81,0.00,0.00,1791.64,1173524.20,0.00,0.00,0.00),('1','141','764','257993',4905694,'2139','322',65136.66,67170.96,0.00,0.00,2034.30,1332466.50,0.00,0.00,0.00),('1','141','764','257993',4905695,'2140','322',59026.14,60808.52,0.00,0.00,1782.38,1167458.90,0.00,0.00,0.00),('1','141','764','257993',4905696,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257993',4905697,'2142','322',22552.53,23542.41,0.00,0.00,989.88,648371.40,0.00,0.00,0.00),('1','141','764','257994',4905698,'2135','322',5858070.13,5858357.44,0.00,0.00,287.31,201117.00,0.00,0.00,0.00),('1','141','764','257994',4905699,'2136','322',60725.36,62029.75,0.00,0.00,1304.39,854375.45,0.00,0.00,0.00),('1','141','764','257994',4905700,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257994',4905701,'2138','322',66687.81,67959.17,0.00,0.00,1271.36,832740.80,0.00,0.00,0.00),('1','141','764','257994',4905702,'2139','322',67170.96,68501.22,0.00,0.00,1330.26,871320.30,0.00,0.00,0.00),('1','141','764','257994',4905703,'2140','322',60808.52,62188.52,0.00,0.00,1380.00,905025.00,0.00,0.00,0.00),('1','141','764','257994',4905704,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257994',4905705,'2142','322',23542.41,24070.41,0.00,0.00,528.00,348922.50,0.00,0.00,0.00),('1','141','764','257995',4905706,'2135','322',5858357.44,5858743.02,0.00,0.00,385.58,269906.00,0.00,0.00,0.00),('1','141','764','257995',4905707,'2136','322',62029.75,63292.01,0.00,0.00,1262.26,827905.30,0.00,0.00,0.00),('1','141','764','257995',4905708,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257995',4905709,'2138','322',67959.17,69592.53,0.00,0.00,1633.36,1069850.80,0.00,0.00,0.00),('1','141','764','257995',4905710,'2139','322',68501.22,69843.82,0.00,0.00,1342.60,879403.00,0.00,0.00,0.00),('1','141','764','257995',4905711,'2140','322',62188.52,63207.52,0.00,0.00,1019.00,667445.00,0.00,0.00,0.00),('1','141','764','257995',4905712,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257995',4905713,'2142','322',24070.41,24562.27,0.00,0.00,491.86,322168.30,0.00,0.00,0.00),('1','141','764','257996',4905714,'2135','322',5858743.02,5858743.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257996',4905715,'2136','322',63292.01,63292.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257996',4905716,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257996',4905717,'2138','322',69592.53,69592.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257996',4905718,'2139','322',69843.82,69843.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257996',4905719,'2140','322',63207.52,63207.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257996',4905720,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257996',4905721,'2142','322',24562.27,24562.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257997',4905722,'2135','322',5858743.02,5859067.56,0.00,0.00,324.54,227178.00,0.00,0.00,0.00),('1','141','764','257997',4905723,'2136','322',63292.01,64602.88,0.00,0.00,1310.87,858619.85,0.00,0.00,0.00),('1','141','764','257997',4905724,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257997',4905725,'2138','322',69592.53,70902.60,0.00,0.00,1310.07,858095.85,0.00,0.00,0.00),('1','141','764','257997',4905726,'2139','322',69843.82,71088.32,0.00,0.00,1244.50,815147.50,0.00,0.00,0.00),('1','141','764','257997',4905727,'2140','322',63207.52,64574.52,0.00,0.00,1367.00,895385.00,0.00,0.00,0.00),('1','141','764','257997',4905728,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257997',4905729,'2142','322',24562.27,25193.77,0.00,0.00,631.50,416445.00,0.00,0.00,0.00),('1','141','764','257998',4905730,'2135','322',5859067.56,5859697.84,0.00,0.00,630.28,441196.00,0.00,0.00,0.00),('1','141','764','257998',4905731,'2136','322',64602.88,65687.64,0.00,0.00,1084.76,710517.80,0.00,0.00,0.00),('1','141','764','257998',4905732,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257998',4905733,'2138','322',70902.60,72065.94,0.00,0.00,1163.34,761987.70,0.00,0.00,0.00),('1','141','764','257998',4905734,'2139','322',71088.32,72017.67,0.00,0.00,929.35,608724.25,0.00,0.00,0.00),('1','141','764','257998',4905735,'2140','322',64574.52,65661.02,0.00,0.00,1086.50,711657.50,0.00,0.00,0.00),('1','141','764','257998',4905736,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257998',4905737,'2142','322',25193.77,25560.92,0.00,0.00,367.15,240483.25,0.00,0.00,0.00),('1','141','764','257999',4905738,'2135','322',5859697.84,5860269.71,0.00,0.00,571.87,400309.00,0.00,0.00,0.00),('1','141','764','257999',4905739,'2136','322',65687.64,67229.21,0.00,0.00,1541.57,1009728.35,0.00,0.00,0.00),('1','141','764','257999',4905740,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257999',4905741,'2138','322',72065.94,73806.02,0.00,0.00,1740.08,1139752.40,0.00,0.00,0.00),('1','141','764','257999',4905742,'2139','322',72017.67,74029.17,0.00,0.00,2011.50,1317532.50,0.00,0.00,0.00),('1','141','764','257999',4905743,'2140','322',65661.02,67622.17,0.00,0.00,1961.15,1284553.25,0.00,0.00,0.00),('1','141','764','257999',4905744,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','257999',4905745,'2142','322',25560.92,26315.35,0.00,0.00,754.43,494151.65,0.00,0.00,0.00),('1','141','764','258000',4905746,'2135','322',5860269.71,5860578.16,0.00,0.00,308.45,215915.00,0.00,0.00,0.00),('1','141','764','258000',4905747,'2136','322',67229.21,68008.21,0.00,0.00,779.00,510807.50,0.00,0.00,0.00),('1','141','764','258000',4905748,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258000',4905749,'2138','322',73806.02,74966.02,0.00,0.00,1160.00,759800.00,0.00,0.00,0.00),('1','141','764','258000',4905750,'2139','322',74029.17,75360.67,0.00,0.00,1331.50,872132.50,0.00,0.00,0.00),('1','141','764','258000',4905751,'2140','322',67622.17,68362.93,0.00,0.00,740.76,485197.80,0.00,0.00,0.00),('1','141','764','258000',4905752,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258000',4905753,'2142','322',26315.35,26576.85,0.00,0.00,261.50,171282.50,0.00,0.00,0.00),('1','141','764','258001',4905754,'2135','322',5860578.16,5860578.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258001',4905755,'2136','322',68008.21,68008.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258001',4905756,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258001',4905757,'2138','322',74966.02,74966.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258001',4905758,'2139','322',75360.67,75360.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258001',4905759,'2140','322',68362.93,68362.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258001',4905760,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258001',4905761,'2142','322',26576.85,26576.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258002',4905762,'2135','322',5860578.16,5860893.32,0.00,0.00,315.16,220612.00,0.00,0.00,0.00),('1','141','764','258002',4905763,'2136','322',68008.21,70322.31,0.00,0.00,2314.10,1515735.50,0.00,0.00,0.00),('1','141','764','258002',4905764,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258002',4905765,'2138','322',74966.02,77145.52,0.00,0.00,2179.50,1427572.50,0.00,0.00,0.00),('1','141','764','258002',4905766,'2139','322',75360.67,77836.67,0.00,0.00,2476.00,1621780.00,0.00,0.00,0.00),('1','141','764','258002',4905767,'2140','322',68362.93,70625.43,0.00,0.00,2262.50,1481937.50,0.00,0.00,0.00),('1','141','764','258002',4905768,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258002',4905769,'2142','322',26576.85,28183.36,0.00,0.00,1606.51,1052264.05,0.00,0.00,0.00),('1','141','764','258003',4905770,'2135','322',5860893.32,5861448.62,0.00,0.00,555.30,388710.00,0.00,0.00,0.00),('1','141','764','258003',4905771,'2136','322',70322.31,71989.23,0.00,0.00,1666.92,1093458.90,0.00,0.00,0.00),('1','141','764','258003',4905772,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258003',4905773,'2138','322',77145.52,79107.65,0.00,0.00,1962.13,1286005.15,0.00,0.00,0.00),('1','141','764','258003',4905774,'2139','322',77836.67,80124.17,0.00,0.00,2287.50,1498312.50,0.00,0.00,0.00),('1','141','764','258003',4905775,'2140','322',70625.43,72654.01,0.00,0.00,2028.58,1328719.90,0.00,0.00,0.00),('1','141','764','258003',4905776,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258003',4905777,'2142','322',28183.36,29202.95,0.00,0.00,1019.59,667831.45,0.00,0.00,0.00),('1','141','764','258004',4905778,'2135','322',5861448.62,5861787.09,0.00,0.00,338.47,236929.00,0.00,0.00,0.00),('1','141','764','258004',4905779,'2136','322',71989.23,72672.54,0.00,0.00,683.31,448130.55,0.00,0.00,0.00),('1','141','764','258004',4905780,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258004',4905781,'2138','322',79107.65,80190.15,0.00,0.00,1082.50,709037.50,0.00,0.00,0.00),('1','141','764','258004',4905782,'2139','322',80124.17,81154.17,0.00,0.00,1030.00,674650.00,0.00,0.00,0.00),('1','141','764','258004',4905783,'2140','322',72654.01,73354.51,0.00,0.00,700.50,458827.50,0.00,0.00,0.00),('1','141','764','258004',4905784,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258004',4905785,'2142','322',29202.95,29487.66,0.00,0.00,284.71,186485.05,0.00,0.00,0.00),('1','141','764','258005',4905786,'2135','322',5861787.09,5861787.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258005',4905787,'2136','322',72672.54,72672.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258005',4905788,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258005',4905789,'2138','322',80190.15,80190.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258005',4905790,'2139','322',81154.17,81154.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258005',4905791,'2140','322',73354.51,73354.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258005',4905792,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258005',4905793,'2142','322',29487.66,29487.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258006',4905794,'2135','322',5861787.09,5862436.61,0.00,0.00,649.52,454664.00,0.00,0.00,0.00),('1','141','764','258006',4905795,'2136','322',72672.54,73849.34,0.00,0.00,1176.80,771771.50,0.00,0.00,0.00),('1','141','764','258006',4905796,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258006',4905797,'2138','322',80190.15,81724.15,0.00,0.00,1534.00,1004770.00,0.00,0.00,0.00),('1','141','764','258006',4905798,'2139','322',81154.17,82320.22,0.00,0.00,1166.05,763762.75,0.00,0.00,0.00),('1','141','764','258006',4905799,'2140','322',73354.51,74654.51,0.00,0.00,1300.00,851500.00,0.00,0.00,0.00),('1','141','764','258006',4905800,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258006',4905801,'2142','322',29487.66,30181.66,0.00,0.00,694.00,455942.50,0.00,0.00,0.00),('1','141','764','258007',4905802,'2135','322',5862436.61,5863077.12,0.00,0.00,640.51,448357.00,0.00,0.00,0.00),('1','141','764','258007',4905803,'2136','322',73849.34,74863.36,0.00,0.00,1014.02,664183.10,0.00,0.00,0.00),('1','141','764','258007',4905804,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258007',4905805,'2138','322',81724.15,83257.46,0.00,0.00,1533.31,1004318.05,0.00,0.00,0.00),('1','141','764','258007',4905806,'2139','322',82320.22,83721.72,0.00,0.00,1401.50,917982.50,0.00,0.00,0.00),('1','141','764','258007',4905807,'2140','322',74654.51,75820.51,0.00,0.00,1166.00,763730.00,0.00,0.00,0.00),('1','141','764','258007',4905808,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258007',4905809,'2142','322',30181.66,30782.37,0.00,0.00,600.71,394622.00,0.00,0.00,0.00),('1','141','764','258008',4905810,'2135','322',5863077.12,5863933.94,0.00,0.00,856.82,599774.00,0.00,0.00,0.00),('1','141','764','258008',4905811,'2136','322',74863.36,76291.43,0.00,0.00,1428.07,937288.00,0.00,0.00,0.00),('1','141','764','258008',4905812,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258008',4905813,'2138','322',83257.46,84732.46,0.00,0.00,1475.00,966125.00,0.00,0.00,0.00),('1','141','764','258008',4905814,'2139','322',83721.72,85284.22,0.00,0.00,1562.50,1023437.50,0.00,0.00,0.00),('1','141','764','258008',4905815,'2140','322',75820.51,77337.01,0.00,0.00,1516.50,993307.50,0.00,0.00,0.00),('1','141','764','258008',4905816,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258008',4905817,'2142','322',30782.37,31381.37,0.00,0.00,599.00,392345.00,0.00,0.00,0.00),('1','141','764','258009',4905818,'2135','322',5863933.94,5864162.15,0.00,0.00,228.21,159747.00,0.00,0.00,0.00),('1','141','764','258009',4905819,'2136','322',76291.43,77017.66,0.00,0.00,726.23,476243.15,0.00,0.00,0.00),('1','141','764','258009',4905820,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258009',4905821,'2138','322',84732.46,85805.46,0.00,0.00,1073.00,702815.00,0.00,0.00,0.00),('1','141','764','258009',4905822,'2139','322',85284.22,86486.22,0.00,0.00,1202.00,787310.00,0.00,0.00,0.00),('1','141','764','258009',4905823,'2140','322',77337.01,78124.01,0.00,0.00,787.00,518050.00,0.00,0.00,0.00),('1','141','764','258009',4905824,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258009',4905825,'2142','322',31381.37,31666.87,0.00,0.00,285.50,187565.00,0.00,0.00,0.00),('1','141','764','258010',4905826,'2135','322',5864162.15,5864162.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258010',4905827,'2136','322',77017.66,77017.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258010',4905828,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258010',4905829,'2138','322',85805.46,85805.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258010',4905830,'2139','322',86486.22,86486.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258010',4905831,'2140','322',78124.01,78124.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258010',4905832,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258010',4905833,'2142','322',31666.87,31666.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258011',4905834,'2135','322',5864162.15,5864617.62,0.00,0.00,455.47,318829.00,0.00,0.00,0.00),('1','141','764','258011',4905835,'2136','322',77017.66,78508.96,0.00,0.00,1491.30,976801.50,0.00,0.00,0.00),('1','141','764','258011',4905836,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258011',4905837,'2138','322',85805.46,87663.46,0.00,0.00,1858.00,1216990.00,0.00,0.00,0.00),('1','141','764','258011',4905838,'2139','322',86486.22,88311.22,0.00,0.00,1825.00,1195375.00,0.00,0.00,0.00),('1','141','764','258011',4905839,'2140','322',78124.01,79184.51,0.00,0.00,1060.50,694627.50,0.00,0.00,0.00),('1','141','764','258011',4905840,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258011',4905841,'2142','322',31666.87,32144.87,0.00,0.00,478.00,313990.00,0.00,0.00,0.00),('1','141','764','258012',4905842,'2135','322',5864617.62,5865197.15,0.00,0.00,579.53,405671.00,0.00,0.00,0.00),('1','141','764','258012',4905843,'2136','322',78508.96,80001.67,0.00,0.00,1492.71,978400.05,0.00,0.00,0.00),('1','141','764','258012',4905844,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258012',4905845,'2138','322',87663.46,89442.96,0.00,0.00,1779.50,1165572.50,0.00,0.00,0.00),('1','141','764','258012',4905846,'2139','322',88311.22,89910.22,0.00,0.00,1599.00,1047345.00,0.00,0.00,0.00),('1','141','764','258012',4905847,'2140','322',79184.51,80569.25,0.00,0.00,1384.74,907004.70,0.00,0.00,0.00),('1','141','764','258012',4905848,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258012',4905849,'2142','322',32144.87,32665.89,0.00,0.00,521.02,343360.60,0.00,0.00,0.00),('1','141','764','258013',4905850,'2135','322',5865197.15,5865716.47,0.00,0.00,519.32,363524.00,0.00,0.00,0.00),('1','141','764','258013',4905851,'2136','322',80001.67,81079.66,0.00,0.00,1077.99,706645.95,0.00,0.00,0.00),('1','141','764','258013',4905852,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258013',4905853,'2138','322',89442.96,91160.53,0.00,0.00,1717.57,1125008.35,0.00,0.00,0.00),('1','141','764','258013',4905854,'2139','322',89910.22,91243.22,0.00,0.00,1333.00,873115.00,0.00,0.00,0.00),('1','141','764','258013',4905855,'2140','322',80569.25,81681.25,0.00,0.00,1112.00,728360.00,0.00,0.00,0.00),('1','141','764','258013',4905856,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258013',4905857,'2142','322',32665.89,33036.39,0.00,0.00,370.50,243240.00,0.00,0.00,0.00),('1','141','764','258014',4905858,'2135','322',5865716.47,5865977.66,0.00,0.00,261.19,182833.00,0.00,0.00,0.00),('1','141','764','258014',4905859,'2136','322',81079.66,82019.14,0.00,0.00,939.48,615359.40,0.00,0.00,0.00),('1','141','764','258014',4905860,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258014',4905861,'2138','322',91160.53,92115.03,0.00,0.00,954.50,625197.50,0.00,0.00,0.00),('1','141','764','258014',4905862,'2139','322',91243.22,92044.55,0.00,0.00,801.33,524871.15,0.00,0.00,0.00),('1','141','764','258014',4905863,'2140','322',81681.25,82403.75,0.00,0.00,722.50,473237.50,0.00,0.00,0.00),('1','141','764','258014',4905864,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258014',4905865,'2142','322',33036.39,33306.39,0.00,0.00,270.00,176850.00,0.00,0.00,0.00),('1','141','764','258015',4905866,'2135','322',5865977.66,5865977.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258015',4905867,'2136','322',82019.14,82019.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258015',4905868,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258015',4905869,'2138','322',92115.03,92115.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258015',4905870,'2139','322',92044.55,92044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258015',4905871,'2140','322',82403.75,82403.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258015',4905872,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258015',4905873,'2142','322',33306.39,33306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258016',4905874,'2135','322',5865977.66,5866226.08,0.00,0.00,248.42,173894.00,0.00,0.00,0.00),('1','141','764','258016',4905875,'2136','322',82019.14,82883.14,0.00,0.00,864.00,566820.00,0.00,0.00,0.00),('1','141','764','258016',4905876,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258016',4905877,'2138','322',92115.03,93097.03,0.00,0.00,982.00,643210.00,0.00,0.00,0.00),('1','141','764','258016',4905878,'2139','322',92044.55,92958.05,0.00,0.00,913.50,598342.50,0.00,0.00,0.00),('1','141','764','258016',4905879,'2140','322',82403.75,83379.25,0.00,0.00,975.50,638952.50,0.00,0.00,0.00),('1','141','764','258016',4905880,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258016',4905881,'2142','322',33306.39,34293.89,0.00,0.00,987.50,646812.50,0.00,0.00,0.00),('1','141','764','258017',4905882,'2135','322',5866226.08,5866625.05,0.00,0.00,398.97,279279.00,0.00,0.00,0.00),('1','141','764','258017',4905883,'2136','322',82883.14,84229.25,0.00,0.00,1346.11,882827.05,0.00,0.00,0.00),('1','141','764','258017',4905884,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258017',4905885,'2138','322',93097.03,95076.53,0.00,0.00,1979.50,1296572.50,0.00,0.00,0.00),('1','141','764','258017',4905886,'2139','322',92958.05,94786.65,0.00,0.00,1828.60,1204753.00,0.00,0.00,0.00),('1','141','764','258017',4905887,'2140','322',83379.25,84913.25,0.00,0.00,1534.00,1004770.00,0.00,0.00,0.00),('1','141','764','258017',4905888,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258017',4905889,'2142','322',34293.89,34833.76,0.00,0.00,539.87,354611.15,0.00,0.00,0.00),('1','141','764','258018',4905890,'2135','322',5866625.05,5866825.51,0.00,0.00,200.46,140322.00,0.00,0.00,0.00),('1','141','764','258018',4905891,'2136','322',84229.25,85072.11,0.00,0.00,842.86,552073.30,0.00,0.00,0.00),('1','141','764','258018',4905892,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258018',4905893,'2138','322',95076.53,96418.53,0.00,0.00,1342.00,879010.00,0.00,0.00,0.00),('1','141','764','258018',4905894,'2139','322',94786.65,96080.65,0.00,0.00,1294.00,847570.00,0.00,0.00,0.00),('1','141','764','258018',4905895,'2140','322',84913.25,85785.25,0.00,0.00,872.00,571160.00,0.00,0.00,0.00),('1','141','764','258018',4905896,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258018',4905897,'2142','322',34833.76,35297.56,0.00,0.00,463.80,304464.00,0.00,0.00,0.00),('1','141','764','258019',4905898,'2135','322',5866825.51,5867160.25,0.00,0.00,334.74,234318.00,0.00,0.00,0.00),('1','141','764','258019',4905899,'2136','322',85072.11,87137.70,0.00,0.00,2065.59,1355098.95,0.00,0.00,0.00),('1','141','764','258019',4905900,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258019',4905901,'2138','322',96418.53,96773.53,0.00,0.00,355.00,232525.00,0.00,0.00,0.00),('1','141','764','258019',4905902,'2139','322',96080.65,98208.36,0.00,0.00,2127.71,1393650.05,0.00,0.00,0.00),('1','141','764','258019',4905903,'2140','322',85785.25,87549.75,0.00,0.00,1764.50,1155747.50,0.00,0.00,0.00),('1','141','764','258019',4905904,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258019',4905905,'2142','322',35297.56,35823.56,0.00,0.00,526.00,345092.50,0.00,0.00,0.00),('1','141','764','258020',4905906,'2135','322',5867160.25,5867160.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258020',4905907,'2136','322',87137.70,87137.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258020',4905908,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258020',4905909,'2138','322',96773.53,96773.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258020',4905910,'2139','322',98208.36,98208.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258020',4905911,'2140','322',87549.75,87549.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258020',4905912,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258020',4905913,'2142','322',35823.56,35823.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258021',4905914,'2135','322',5867160.25,5867681.02,0.00,0.00,520.77,364539.00,0.00,0.00,0.00),('1','141','764','258021',4905915,'2136','322',87137.70,87980.22,0.00,0.00,842.52,556253.85,0.00,0.00,0.00),('1','141','764','258021',4905916,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258021',4905917,'2138','322',96773.53,97744.53,0.00,0.00,971.00,636005.00,0.00,0.00,0.00),('1','141','764','258021',4905918,'2139','322',98208.36,100105.86,0.00,0.00,1897.50,1242862.50,0.00,0.00,0.00),('1','141','764','258021',4905919,'2140','322',87549.75,88993.15,0.00,0.00,1443.40,945427.00,0.00,0.00,0.00),('1','141','764','258021',4905920,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258021',4905921,'2142','322',35823.56,36078.85,0.00,0.00,255.29,168339.95,0.00,0.00,0.00),('1','141','764','258022',4905922,'2135','322',5867681.02,5868013.07,0.00,0.00,332.05,232435.00,0.00,0.00,0.00),('1','141','764','258022',4905923,'2136','322',87980.22,88690.27,0.00,0.00,710.05,465645.25,0.00,0.00,0.00),('1','141','764','258022',4905924,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258022',4905925,'2138','322',97744.53,99062.13,0.00,0.00,1317.60,865278.00,0.00,0.00,0.00),('1','141','764','258022',4905926,'2139','322',100105.86,101453.86,0.00,0.00,1348.00,882940.00,0.00,0.00,0.00),('1','141','764','258022',4905927,'2140','322',88993.15,90035.42,0.00,0.00,1042.27,682686.85,0.00,0.00,0.00),('1','141','764','258022',4905928,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258022',4905929,'2142','322',36078.85,36731.82,0.00,0.00,652.97,427695.35,0.00,0.00,0.00),('1','141','764','258023',4905930,'2135','322',5868013.07,5868434.74,0.00,0.00,421.67,295169.00,0.00,0.00,0.00),('1','141','764','258023',4905931,'2136','322',88690.27,89999.64,0.00,0.00,1309.37,859752.35,0.00,0.00,0.00),('1','141','764','258023',4905932,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258023',4905933,'2138','322',99062.13,101482.13,0.00,0.00,2420.00,1585100.00,0.00,0.00,0.00),('1','141','764','258023',4905934,'2139','322',101453.86,103731.36,0.00,0.00,2277.50,1491762.50,0.00,0.00,0.00),('1','141','764','258023',4905935,'2140','322',90035.42,92333.92,0.00,0.00,2298.50,1505517.50,0.00,0.00,0.00),('1','141','764','258023',4905936,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258023',4905937,'2142','322',36731.82,37965.18,0.00,0.00,1233.36,807850.80,0.00,0.00,0.00),('1','141','764','258024',4905938,'2135','322',5868434.74,5868668.58,0.00,0.00,233.84,163688.00,0.00,0.00,0.00),('1','141','764','258024',4905939,'2136','322',89999.64,90489.61,0.00,0.00,489.97,324012.85,0.00,0.00,0.00),('1','141','764','258024',4905940,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258024',4905941,'2138','322',101482.13,102422.59,0.00,0.00,940.46,616001.30,0.00,0.00,0.00),('1','141','764','258024',4905942,'2139','322',103731.36,104558.36,0.00,0.00,827.00,541685.00,0.00,0.00,0.00),('1','141','764','258024',4905943,'2140','322',92333.92,92863.92,0.00,0.00,530.00,347150.00,0.00,0.00,0.00),('1','141','764','258024',4905944,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258024',4905945,'2142','322',37965.18,38268.68,0.00,0.00,303.50,199355.00,0.00,0.00,0.00),('1','141','764','258025',4905946,'2135','322',5868668.58,5868668.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258025',4905947,'2136','322',90489.61,90489.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258025',4905948,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258025',4905949,'2138','322',102422.59,102422.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258025',4905950,'2139','322',104558.36,104558.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258025',4905951,'2140','322',92863.92,92863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258025',4905952,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258025',4905953,'2142','322',38268.68,38268.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258026',4905954,'2135','322',5868668.58,5869199.14,0.00,0.00,530.56,371392.00,0.00,0.00,0.00),('1','141','764','258026',4905955,'2136','322',90489.61,92603.31,0.00,0.00,2113.70,1384608.50,0.00,0.00,0.00),('1','141','764','258026',4905956,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258026',4905957,'2138','322',102422.59,104964.09,0.00,0.00,2541.50,1664682.50,0.00,0.00,0.00),('1','141','764','258026',4905958,'2139','322',104558.36,106660.86,0.00,0.00,2102.50,1377137.50,0.00,0.00,0.00),('1','141','764','258026',4905959,'2140','322',92863.92,94220.92,0.00,0.00,1357.00,888835.00,0.00,0.00,0.00),('1','141','764','258026',4905960,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258026',4905961,'2142','322',38268.68,39098.23,0.00,0.00,829.55,544560.35,0.00,0.00,0.00),('1','141','764','258027',4905962,'2135','322',5869199.14,5869485.91,0.00,0.00,286.77,200739.00,0.00,0.00,0.00),('1','141','764','258027',4905963,'2136','322',92603.31,93355.05,0.00,0.00,751.74,493514.70,0.00,0.00,0.00),('1','141','764','258027',4905964,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258027',4905965,'2138','322',104964.09,106523.59,0.00,0.00,1559.50,1021472.50,0.00,0.00,0.00),('1','141','764','258027',4905966,'2139','322',106660.86,108673.36,0.00,0.00,2012.50,1318187.50,0.00,0.00,0.00),('1','141','764','258027',4905967,'2140','322',94220.92,95346.42,0.00,0.00,1125.50,737202.50,0.00,0.00,0.00),('1','141','764','258027',4905968,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258027',4905969,'2142','322',39098.23,39455.24,0.00,0.00,357.01,235384.15,0.00,0.00,0.00),('1','141','764','258028',4905970,'2135','322',5869485.91,5869899.03,0.00,0.00,413.12,289184.00,0.00,0.00,0.00),('1','141','764','258028',4905971,'2136','322',93355.05,94379.26,0.00,0.00,1024.21,671982.55,0.00,0.00,0.00),('1','141','764','258028',4905972,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258028',4905973,'2138','322',106523.59,108258.59,0.00,0.00,1735.00,1136425.00,0.00,0.00,0.00),('1','141','764','258028',4905974,'2139','322',108673.36,110291.76,0.00,0.00,1618.40,1060052.00,0.00,0.00,0.00),('1','141','764','258028',4905975,'2140','322',95346.42,96505.42,0.00,0.00,1159.00,759145.00,0.00,0.00,0.00),('1','141','764','258028',4905976,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258028',4905977,'2142','322',39455.24,39843.11,0.00,0.00,387.87,256484.85,0.00,0.00,0.00),('1','141','764','258029',4905978,'2135','322',5869899.03,5869939.46,0.00,0.00,40.43,28301.00,0.00,0.00,0.00),('1','141','764','258029',4905979,'2136','322',94379.26,94840.12,0.00,0.00,460.86,301863.30,0.00,0.00,0.00),('1','141','764','258029',4905980,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258029',4905981,'2138','322',108258.59,108937.59,0.00,0.00,679.00,444745.00,0.00,0.00,0.00),('1','141','764','258029',4905982,'2139','322',110291.76,110891.76,0.00,0.00,600.00,393000.00,0.00,0.00,0.00),('1','141','764','258029',4905983,'2140','322',96505.42,97229.42,0.00,0.00,724.00,474220.00,0.00,0.00,0.00),('1','141','764','258029',4905984,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258029',4905985,'2142','322',39843.11,40057.61,0.00,0.00,214.50,140497.50,0.00,0.00,0.00),('1','141','764','258030',4905986,'2135','322',5869939.46,5869939.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258030',4905987,'2136','322',94840.12,94840.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258030',4905988,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258030',4905989,'2138','322',108937.59,108937.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258030',4905990,'2139','322',110891.76,110891.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258030',4905991,'2140','322',97229.42,97229.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258030',4905992,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258030',4905993,'2142','322',40057.61,40057.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258031',4905994,'2135','322',5869939.46,5870179.08,0.00,0.00,239.62,167734.00,0.00,0.00,0.00),('1','141','764','258031',4905995,'2136','322',94840.12,96515.54,0.00,0.00,1675.42,1097400.10,0.00,0.00,0.00),('1','141','764','258031',4905996,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258031',4905997,'2138','322',108937.59,110485.09,0.00,0.00,1547.50,1013612.50,0.00,0.00,0.00),('1','141','764','258031',4905998,'2139','322',110891.76,112278.76,0.00,0.00,1387.00,908485.00,0.00,0.00,0.00),('1','141','764','258031',4905999,'2140','322',97229.42,98259.42,0.00,0.00,1030.00,674650.00,0.00,0.00,0.00),('1','141','764','258031',4906000,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258031',4906001,'2142','322',40057.61,40399.71,0.00,0.00,342.10,225200.50,0.00,0.00,0.00),('1','141','764','258032',4906002,'2135','322',5870179.08,5870650.36,0.00,0.00,471.28,329896.00,0.00,0.00,0.00),('1','141','764','258032',4906003,'2136','322',96515.54,97545.55,0.00,0.00,1030.01,674656.55,0.00,0.00,0.00),('1','141','764','258032',4906004,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258032',4906005,'2138','322',110485.09,112375.59,0.00,0.00,1890.50,1243677.50,0.00,0.00,0.00),('1','141','764','258032',4906006,'2139','322',112278.76,114418.26,0.00,0.00,2139.50,1403352.50,0.00,0.00,0.00),('1','141','764','258032',4906007,'2140','322',98259.42,99604.92,0.00,0.00,1345.50,881302.50,0.00,0.00,0.00),('1','141','764','258032',4906008,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258032',4906009,'2142','322',40399.71,40904.90,0.00,0.00,505.19,330899.45,0.00,0.00,0.00),('1','141','764','258033',4906010,'2135','322',5870650.36,5870950.46,0.00,0.00,300.10,210070.00,0.00,0.00,0.00),('1','141','764','258033',4906011,'2136','322',97545.55,99704.05,0.00,0.00,2158.50,1413817.50,0.00,0.00,0.00),('1','141','764','258033',4906012,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258033',4906013,'2138','322',112375.59,114496.09,0.00,0.00,2120.50,1388927.50,0.00,0.00,0.00),('1','141','764','258033',4906014,'2139','322',114418.26,116746.26,0.00,0.00,2328.00,1524840.00,0.00,0.00,0.00),('1','141','764','258033',4906015,'2140','322',99604.92,101637.92,0.00,0.00,2033.00,1331615.00,0.00,0.00,0.00),('1','141','764','258033',4906016,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258033',4906017,'2142','322',40904.90,42995.40,0.00,0.00,2090.50,1369840.00,0.00,0.00,0.00),('1','141','764','258034',4906018,'2135','322',5870950.46,5870950.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258034',4906019,'2136','322',99704.05,99704.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258034',4906020,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258034',4906021,'2138','322',114496.09,114496.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258034',4906022,'2139','322',116746.26,116746.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258034',4906023,'2140','322',101637.92,101637.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258034',4906024,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258034',4906025,'2142','322',42995.40,42995.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258035',4906026,'2135','322',5870950.46,5871560.21,0.00,0.00,609.75,426825.00,0.00,0.00,0.00),('1','141','764','258035',4906027,'2136','322',99704.05,100948.24,0.00,0.00,1244.19,817801.95,0.00,0.00,0.00),('1','141','764','258035',4906028,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258035',4906029,'2138','322',114496.09,116429.14,0.00,0.00,1933.05,1266147.75,0.00,0.00,0.00),('1','141','764','258035',4906030,'2139','322',116746.26,118697.29,0.00,0.00,1951.03,1277924.65,0.00,0.00,0.00),('1','141','764','258035',4906031,'2140','322',101637.92,103212.92,0.00,0.00,1575.00,1031625.00,0.00,0.00,0.00),('1','141','764','258035',4906032,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258035',4906033,'2142','322',42995.40,43545.40,0.00,0.00,550.00,360250.00,0.00,0.00,0.00),('1','141','764','258036',4906034,'2135','322',5871560.21,5871945.73,0.00,0.00,385.52,269864.00,0.00,0.00,0.00),('1','141','764','258036',4906035,'2136','322',100948.24,102374.67,0.00,0.00,1426.43,936603.50,0.00,0.00,0.00),('1','141','764','258036',4906036,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258036',4906037,'2138','322',116429.14,118993.64,0.00,0.00,2564.50,1679747.50,0.00,0.00,0.00),('1','141','764','258036',4906038,'2139','322',118697.29,120694.29,0.00,0.00,1997.00,1308035.00,0.00,0.00,0.00),('1','141','764','258036',4906039,'2140','322',103212.92,104804.92,0.00,0.00,1592.00,1042760.00,0.00,0.00,0.00),('1','141','764','258036',4906040,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258036',4906041,'2142','322',43545.40,43946.90,0.00,0.00,401.50,262982.50,0.00,0.00,0.00),('1','141','764','258037',4906042,'2135','322',5871945.73,5872143.22,0.00,0.00,197.49,138243.00,0.00,0.00,0.00),('1','141','764','258037',4906043,'2136','322',102374.67,103169.34,0.00,0.00,794.67,522128.85,0.00,0.00,0.00),('1','141','764','258037',4906044,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258037',4906045,'2138','322',118993.64,120293.64,0.00,0.00,1300.00,851500.00,0.00,0.00,0.00),('1','141','764','258037',4906046,'2139','322',120694.29,122808.29,0.00,0.00,2114.00,1384670.00,0.00,0.00,0.00),('1','141','764','258037',4906047,'2140','322',104804.92,105757.53,0.00,0.00,952.61,623959.55,0.00,0.00,0.00),('1','141','764','258037',4906048,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258037',4906049,'2142','322',43946.90,44080.40,0.00,0.00,133.50,87442.50,0.00,0.00,0.00),('1','141','764','258038',4906050,'2135','322',5872143.22,5872281.56,0.00,0.00,138.34,96838.00,0.00,0.00,0.00),('1','141','764','258038',4906051,'2136','322',103169.34,103600.34,0.00,0.00,431.00,282440.00,0.00,0.00,0.00),('1','141','764','258038',4906052,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258038',4906053,'2138','322',120293.64,120933.64,0.00,0.00,640.00,419200.00,0.00,0.00,0.00),('1','141','764','258038',4906054,'2139','322',122808.29,123646.29,0.00,0.00,838.00,548890.00,0.00,0.00,0.00),('1','141','764','258038',4906055,'2140','322',105757.53,106443.03,0.00,0.00,685.50,449002.50,0.00,0.00,0.00),('1','141','764','258038',4906056,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258038',4906057,'2142','322',44080.40,44318.77,0.00,0.00,238.37,156132.35,0.00,0.00,0.00),('1','141','764','258039',4906058,'2135','322',5872281.56,5872281.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258039',4906059,'2136','322',103600.34,103600.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258039',4906060,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258039',4906061,'2138','322',120933.64,120933.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258039',4906062,'2139','322',123646.29,123646.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258039',4906063,'2140','322',106443.03,106443.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258039',4906064,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258039',4906065,'2142','322',44318.77,44318.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258040',4906066,'2135','322',5872281.56,5872792.81,0.00,0.00,511.25,357875.00,0.00,0.00,0.00),('1','141','764','258040',4906067,'2136','322',103600.34,104616.34,0.00,0.00,1016.00,666380.00,0.00,0.00,0.00),('1','141','764','258040',4906068,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258040',4906069,'2138','322',120933.64,122600.83,0.00,0.00,1667.19,1092009.45,0.00,0.00,0.00),('1','141','764','258040',4906070,'2139','322',123646.29,125243.79,0.00,0.00,1597.50,1046362.50,0.00,0.00,0.00),('1','141','764','258040',4906071,'2140','322',106443.03,107416.53,0.00,0.00,973.50,637642.50,0.00,0.00,0.00),('1','141','764','258040',4906072,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258040',4906073,'2142','322',44318.77,44712.77,0.00,0.00,394.00,258070.00,0.00,0.00,0.00),('1','141','764','258041',4906074,'2135','322',5872792.81,5873372.61,0.00,0.00,579.80,405860.00,0.00,0.00,0.00),('1','141','764','258041',4906075,'2136','322',104616.34,108091.76,0.00,0.00,3475.42,2276400.10,0.00,0.00,0.00),('1','141','764','258041',4906076,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258041',4906077,'2138','322',122600.83,125995.83,0.00,0.00,3395.00,2223725.00,0.00,0.00,0.00),('1','141','764','258041',4906078,'2139','322',125243.79,128522.29,0.00,0.00,3278.50,2147417.50,0.00,0.00,0.00),('1','141','764','258041',4906079,'2140','322',107416.53,111332.03,0.00,0.00,3915.50,2564652.50,0.00,0.00,0.00),('1','141','764','258041',4906080,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258041',4906081,'2142','322',44712.77,47189.77,0.00,0.00,2477.00,1623560.00,0.00,0.00,0.00),('1','141','764','258042',4906082,'2135','322',5873372.61,5873486.20,0.00,0.00,113.59,79513.00,0.00,0.00,0.00),('1','141','764','258042',4906083,'2136','322',108091.76,108320.76,0.00,0.00,229.00,149995.00,0.00,0.00,0.00),('1','141','764','258042',4906084,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258042',4906085,'2138','322',125995.83,126372.83,0.00,0.00,377.00,246935.00,0.00,0.00,0.00),('1','141','764','258042',4906086,'2139','322',128522.29,128948.29,0.00,0.00,426.00,279030.00,0.00,0.00,0.00),('1','141','764','258042',4906087,'2140','322',111332.03,111533.03,0.00,0.00,201.00,131655.00,0.00,0.00,0.00),('1','141','764','258042',4906088,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258042',4906089,'2142','322',47189.77,47234.77,0.00,0.00,45.00,29475.00,0.00,0.00,0.00),('1','141','764','258043',4906090,'2135','322',5873486.20,5873486.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258043',4906091,'2136','322',108320.76,108320.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258043',4906092,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258043',4906093,'2138','322',126372.83,126372.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258043',4906094,'2139','322',128948.29,128948.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258043',4906095,'2140','322',111533.03,111533.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258043',4906096,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258043',4906097,'2142','322',47234.77,47234.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258044',4906098,'2135','322',5873486.20,5874255.25,0.00,0.00,769.05,538335.00,0.00,0.00,0.00),('1','141','764','258044',4906099,'2136','322',108320.76,110824.04,0.00,0.00,2503.28,1641583.40,0.00,0.00,0.00),('1','141','764','258044',4906100,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258044',4906101,'2138','322',126372.83,128784.33,0.00,0.00,2411.50,1579532.50,0.00,0.00,0.00),('1','141','764','258044',4906102,'2139','322',128948.29,130723.29,0.00,0.00,1775.00,1162625.00,0.00,0.00,0.00),('1','141','764','258044',4906103,'2140','322',111533.03,113626.03,0.00,0.00,2093.00,1370915.00,0.00,0.00,0.00),('1','141','764','258044',4906104,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258044',4906105,'2142','322',47234.77,47922.38,0.00,0.00,687.61,452409.55,0.00,0.00,0.00),('1','141','764','258045',4906106,'2135','322',5874255.25,5874602.93,0.00,0.00,347.68,243376.00,0.00,0.00,0.00),('1','141','764','258045',4906107,'2136','322',110824.04,111870.84,0.00,0.00,1046.80,685654.00,0.00,0.00,0.00),('1','141','764','258045',4906108,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258045',4906109,'2138','322',128784.33,130002.33,0.00,0.00,1218.00,797790.00,0.00,0.00,0.00),('1','141','764','258045',4906110,'2139','322',130723.29,131919.79,0.00,0.00,1196.50,783707.50,0.00,0.00,0.00),('1','141','764','258045',4906111,'2140','322',113626.03,114948.03,0.00,0.00,1322.00,865910.00,0.00,0.00,0.00),('1','141','764','258045',4906112,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258045',4906113,'2142','322',47922.38,48042.88,0.00,0.00,120.50,78927.50,0.00,0.00,0.00),('1','141','764','258046',4906114,'2135','322',5874602.93,5875248.92,0.00,0.00,645.99,452193.00,0.00,0.00,0.00),('1','141','764','258046',4906115,'2136','322',111870.84,113816.34,0.00,0.00,1945.50,1274302.50,0.00,0.00,0.00),('1','141','764','258046',4906116,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258046',4906117,'2138','322',130002.33,131989.33,0.00,0.00,1987.00,1301485.00,0.00,0.00,0.00),('1','141','764','258046',4906118,'2139','322',131919.79,133842.95,0.00,0.00,1923.16,1259669.80,0.00,0.00,0.00),('1','141','764','258046',4906119,'2140','322',114948.03,116976.03,0.00,0.00,2028.00,1328340.00,0.00,0.00,0.00),('1','141','764','258046',4906120,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258046',4906121,'2142','322',48042.88,48578.21,0.00,0.00,535.33,350641.15,0.00,0.00,0.00),('1','141','764','258047',4906122,'2135','322',5875248.92,5875248.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258047',4906123,'2136','322',113816.34,113816.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258047',4906124,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258047',4906125,'2138','322',131989.33,131989.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258047',4906126,'2139','322',133842.95,133842.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258047',4906127,'2140','322',116976.03,116976.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258047',4906128,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258047',4906129,'2142','322',48578.21,48578.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258048',4906130,'2135','322',5875248.92,5875786.17,0.00,0.00,537.25,376075.00,0.00,0.00,0.00),('1','141','764','258048',4906131,'2136','322',113816.34,114799.90,0.00,0.00,983.56,644231.80,0.00,0.00,0.00),('1','141','764','258048',4906132,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258048',4906133,'2138','322',131989.33,133160.33,0.00,0.00,1171.00,767005.00,0.00,0.00,0.00),('1','141','764','258048',4906134,'2139','322',133842.95,135217.95,0.00,0.00,1375.00,900625.00,0.00,0.00,0.00),('1','141','764','258048',4906135,'2140','322',116976.03,117819.25,0.00,0.00,843.22,552309.10,0.00,0.00,0.00),('1','141','764','258048',4906136,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258048',4906137,'2142','322',48578.21,48960.01,0.00,0.00,381.80,250079.00,0.00,0.00,0.00),('1','141','764','258049',4906138,'2135','322',5875786.17,5876230.49,0.00,0.00,444.32,311024.00,0.00,0.00,0.00),('1','141','764','258049',4906139,'2136','322',114799.90,115510.40,0.00,0.00,710.50,465377.50,0.00,0.00,0.00),('1','141','764','258049',4906140,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258049',4906141,'2138','322',133160.33,134521.10,0.00,0.00,1360.77,891304.35,0.00,0.00,0.00),('1','141','764','258049',4906142,'2139','322',135217.95,136298.81,0.00,0.00,1080.86,707963.30,0.00,0.00,0.00),('1','141','764','258049',4906143,'2140','322',117819.25,118646.67,0.00,0.00,827.42,541960.10,0.00,0.00,0.00),('1','141','764','258049',4906144,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258049',4906145,'2142','322',48960.01,49321.51,0.00,0.00,361.50,236782.50,0.00,0.00,0.00),('1','141','764','258050',4906146,'2135','322',5876230.49,5876688.40,0.00,0.00,457.91,320537.00,0.00,0.00,0.00),('1','141','764','258050',4906147,'2136','322',115510.40,116498.97,0.00,0.00,988.57,647648.35,0.00,0.00,0.00),('1','141','764','258050',4906148,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258050',4906149,'2138','322',134521.10,135707.60,0.00,0.00,1186.50,777157.50,0.00,0.00,0.00),('1','141','764','258050',4906150,'2139','322',136298.81,137435.81,0.00,0.00,1137.00,744735.00,0.00,0.00,0.00),('1','141','764','258050',4906151,'2140','322',118646.67,119462.67,0.00,0.00,816.00,534480.00,0.00,0.00,0.00),('1','141','764','258050',4906152,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258050',4906153,'2142','322',49321.51,49447.81,0.00,0.00,126.30,82726.50,0.00,0.00,0.00),('1','141','764','258051',4906154,'2135','322',5876688.40,5877414.58,0.00,0.00,726.18,508326.00,0.00,0.00,0.00),('1','141','764','258051',4906155,'2136','322',116498.97,117668.51,0.00,0.00,1169.54,766048.70,0.00,0.00,0.00),('1','141','764','258051',4906156,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258051',4906157,'2138','322',135707.60,137075.60,0.00,0.00,1368.00,896040.00,0.00,0.00,0.00),('1','141','764','258051',4906158,'2139','322',137435.81,138619.81,0.00,0.00,1184.00,775520.00,0.00,0.00,0.00),('1','141','764','258051',4906159,'2140','322',119462.67,120326.17,0.00,0.00,863.50,565592.50,0.00,0.00,0.00),('1','141','764','258051',4906160,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258051',4906161,'2142','322',49447.81,49731.81,0.00,0.00,284.00,186020.00,0.00,0.00,0.00),('1','141','764','258052',4906162,'2135','322',5877414.58,5877608.40,0.00,0.00,193.82,135674.00,0.00,0.00,0.00),('1','141','764','258052',4906163,'2136','322',117668.51,118168.51,0.00,0.00,500.00,327500.00,0.00,0.00,0.00),('1','141','764','258052',4906164,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258052',4906165,'2138','322',137075.60,138447.04,0.00,0.00,1371.44,898293.20,0.00,0.00,0.00),('1','141','764','258052',4906166,'2139','322',138619.81,139910.81,0.00,0.00,1291.00,845605.00,0.00,0.00,0.00),('1','141','764','258052',4906167,'2140','322',120326.17,121117.17,0.00,0.00,791.00,518105.00,0.00,0.00,0.00),('1','141','764','258052',4906168,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258052',4906169,'2142','322',49731.81,49761.31,0.00,0.00,29.50,19322.50,0.00,0.00,0.00),('1','141','764','258053',4906170,'2135','322',5877608.40,5877608.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258053',4906171,'2136','322',118168.51,118168.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258053',4906172,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258053',4906173,'2138','322',138447.04,138447.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258053',4906174,'2139','322',139910.81,139910.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258053',4906175,'2140','322',121117.17,121117.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258053',4906176,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258053',4906177,'2142','322',49761.31,49761.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258054',4906178,'2135','322',5877608.40,5878196.31,0.00,0.00,587.91,411537.00,0.00,0.00,0.00),('1','141','764','258054',4906179,'2136','322',118168.51,119549.83,0.00,0.00,1381.32,904764.60,0.00,0.00,0.00),('1','141','764','258054',4906180,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258054',4906181,'2138','322',138447.04,139930.54,0.00,0.00,1483.50,971692.50,0.00,0.00,0.00),('1','141','764','258054',4906182,'2139','322',139910.81,141697.62,0.00,0.00,1786.81,1170360.55,0.00,0.00,0.00),('1','141','764','258054',4906183,'2140','322',121117.17,122551.17,0.00,0.00,1434.00,939270.00,0.00,0.00,0.00),('1','141','764','258054',4906184,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258054',4906185,'2142','322',49761.31,50205.75,0.00,0.00,444.44,291108.20,0.00,0.00,0.00),('1','141','764','258055',4906186,'2135','322',5878196.31,5878792.82,0.00,0.00,596.51,417557.00,0.00,0.00,0.00),('1','141','764','258055',4906187,'2136','322',119549.83,120911.83,0.00,0.00,1362.00,893122.50,0.00,0.00,0.00),('1','141','764','258055',4906188,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258055',4906189,'2138','322',139930.54,141397.72,0.00,0.00,1467.18,961002.90,0.00,0.00,0.00),('1','141','764','258055',4906190,'2139','322',141697.62,143152.12,0.00,0.00,1454.50,952697.50,0.00,0.00,0.00),('1','141','764','258055',4906191,'2140','322',122551.17,124002.17,0.00,0.00,1451.00,950405.00,0.00,0.00,0.00),('1','141','764','258055',4906192,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258055',4906193,'2142','322',50205.75,50328.25,0.00,0.00,122.50,80237.50,0.00,0.00,0.00),('1','141','764','258056',4906194,'2135','322',5878792.82,5879387.42,0.00,0.00,594.60,416220.00,0.00,0.00,0.00),('1','141','764','258056',4906195,'2136','322',120911.83,121835.50,0.00,0.00,923.67,605003.85,0.00,0.00,0.00),('1','141','764','258056',4906196,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258056',4906197,'2138','322',141397.72,142753.72,0.00,0.00,1356.00,888180.00,0.00,0.00,0.00),('1','141','764','258056',4906198,'2139','322',143152.12,144750.62,0.00,0.00,1598.50,1047017.50,0.00,0.00,0.00),('1','141','764','258056',4906199,'2140','322',124002.17,125264.17,0.00,0.00,1262.00,826610.00,0.00,0.00,0.00),('1','141','764','258056',4906200,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258056',4906201,'2142','322',50328.25,50343.46,0.00,0.00,15.21,9962.55,0.00,0.00,0.00),('1','141','764','258057',4906202,'2135','322',5879387.42,5879949.85,0.00,0.00,562.43,393701.00,0.00,0.00,0.00),('1','141','764','258057',4906203,'2136','322',121835.50,122724.00,0.00,0.00,888.50,581967.50,0.00,0.00,0.00),('1','141','764','258057',4906204,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258057',4906205,'2138','322',142753.72,143862.22,0.00,0.00,1108.50,726067.50,0.00,0.00,0.00),('1','141','764','258057',4906206,'2139','322',144750.62,145980.12,0.00,0.00,1229.50,805322.50,0.00,0.00,0.00),('1','141','764','258057',4906207,'2140','322',125264.17,126447.17,0.00,0.00,1183.00,774865.00,0.00,0.00,0.00),('1','141','764','258057',4906208,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258057',4906209,'2142','322',50343.46,50675.96,0.00,0.00,332.50,217787.50,0.00,0.00,0.00),('1','141','764','258058',4906210,'2135','322',5879949.85,5879949.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258058',4906211,'2136','322',122724.00,122724.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258058',4906212,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258058',4906213,'2138','322',143862.22,143862.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258058',4906214,'2139','322',145980.12,145980.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258058',4906215,'2140','322',126447.17,126447.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258058',4906216,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258058',4906217,'2142','322',50675.96,50675.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258059',4906218,'2135','322',5879949.85,5880478.91,0.00,0.00,529.06,370342.00,0.00,0.00,0.00),('1','141','764','258059',4906219,'2136','322',122724.00,123973.40,0.00,0.00,1249.40,818357.00,0.00,0.00,0.00),('1','141','764','258059',4906220,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258059',4906221,'2138','322',143862.22,144964.03,0.00,0.00,1101.81,721685.55,0.00,0.00,0.00),('1','141','764','258059',4906222,'2139','322',145980.12,146885.65,0.00,0.00,905.53,593122.15,0.00,0.00,0.00),('1','141','764','258059',4906223,'2140','322',126447.17,127544.67,0.00,0.00,1097.50,718862.50,0.00,0.00,0.00),('1','141','764','258059',4906224,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258059',4906225,'2142','322',50675.96,50845.96,0.00,0.00,170.00,111350.00,0.00,0.00,0.00),('1','141','764','258060',4906226,'2135','322',5880478.91,5881134.75,0.00,0.00,655.84,459088.00,0.00,0.00,0.00),('1','141','764','258060',4906227,'2136','322',123973.40,124839.26,0.00,0.00,865.86,567228.30,0.00,0.00,0.00),('1','141','764','258060',4906228,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258060',4906229,'2138','322',144964.03,146373.93,0.00,0.00,1409.90,923484.50,0.00,0.00,0.00),('1','141','764','258060',4906230,'2139','322',146885.65,148654.05,0.00,0.00,1768.40,1158302.00,0.00,0.00,0.00),('1','141','764','258060',4906231,'2140','322',127544.67,128958.17,0.00,0.00,1413.50,925842.50,0.00,0.00,0.00),('1','141','764','258060',4906232,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258060',4906233,'2142','322',50845.96,50945.46,0.00,0.00,99.50,65172.50,0.00,0.00,0.00),('1','141','764','258061',4906234,'2135','322',5881134.75,5881362.77,0.00,0.00,228.02,159614.00,0.00,0.00,0.00),('1','141','764','258061',4906235,'2136','322',124839.26,125487.17,0.00,0.00,647.91,425236.05,0.00,0.00,0.00),('1','141','764','258061',4906236,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258061',4906237,'2138','322',146373.93,147159.57,0.00,0.00,785.64,514594.20,0.00,0.00,0.00),('1','141','764','258061',4906238,'2139','322',148654.05,149350.55,0.00,0.00,696.50,456207.50,0.00,0.00,0.00),('1','141','764','258061',4906239,'2140','322',128958.17,129728.17,0.00,0.00,770.00,504350.00,0.00,0.00,0.00),('1','141','764','258061',4906240,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258061',4906241,'2142','322',50945.46,51035.46,0.00,0.00,90.00,58950.00,0.00,0.00,0.00),('1','141','764','258062',4906242,'2135','322',5881362.77,5881849.70,0.00,0.00,486.93,340851.00,0.00,0.00,0.00),('1','141','764','258062',4906243,'2136','322',125487.17,126824.31,0.00,0.00,1337.14,875826.70,0.00,0.00,0.00),('1','141','764','258062',4906244,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258062',4906245,'2138','322',147159.57,149040.34,0.00,0.00,1880.77,1231904.35,0.00,0.00,0.00),('1','141','764','258062',4906246,'2139','322',149350.55,150813.55,0.00,0.00,1463.00,958265.00,0.00,0.00,0.00),('1','141','764','258062',4906247,'2140','322',129728.17,130874.67,0.00,0.00,1146.50,750957.50,0.00,0.00,0.00),('1','141','764','258062',4906248,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258062',4906249,'2142','322',51035.46,51192.27,0.00,0.00,156.81,102710.55,0.00,0.00,0.00),('1','141','764','258063',4906250,'2135','322',5881849.70,5882317.44,0.00,0.00,467.74,327418.00,0.00,0.00,0.00),('1','141','764','258063',4906251,'2136','322',126824.31,127440.33,0.00,0.00,616.02,403853.10,0.00,0.00,0.00),('1','141','764','258063',4906252,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258063',4906253,'2138','322',149040.34,149952.84,0.00,0.00,912.50,597687.50,0.00,0.00,0.00),('1','141','764','258063',4906254,'2139','322',150813.55,151671.95,0.00,0.00,858.40,563602.00,0.00,0.00,0.00),('1','141','764','258063',4906255,'2140','322',130874.67,131616.67,0.00,0.00,742.00,486010.00,0.00,0.00,0.00),('1','141','764','258063',4906256,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258063',4906257,'2142','322',51192.27,51367.27,0.00,0.00,175.00,114625.00,0.00,0.00,0.00),('1','141','764','258064',4906258,'2135','322',5882317.44,5882317.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258064',4906259,'2136','322',127440.33,127440.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258064',4906260,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258064',4906261,'2138','322',149952.84,149952.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258064',4906262,'2139','322',151671.95,151671.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258064',4906263,'2140','322',131616.67,131616.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258064',4906264,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258064',4906265,'2142','322',51367.27,51367.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258065',4906266,'2135','322',5882317.44,5882778.08,0.00,0.00,460.64,322448.00,0.00,0.00,0.00),('1','141','764','258065',4906267,'2136','322',127440.33,128560.30,0.00,0.00,1119.97,733580.35,0.00,0.00,0.00),('1','141','764','258065',4906268,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258065',4906269,'2138','322',149952.84,151220.69,0.00,0.00,1267.85,830441.75,0.00,0.00,0.00),('1','141','764','258065',4906270,'2139','322',151671.95,152938.95,0.00,0.00,1267.00,829885.00,0.00,0.00,0.00),('1','141','764','258065',4906271,'2140','322',131616.67,132764.17,0.00,0.00,1147.50,751612.50,0.00,0.00,0.00),('1','141','764','258065',4906272,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258065',4906273,'2142','322',51367.27,51621.77,0.00,0.00,254.50,166697.50,0.00,0.00,0.00),('1','141','764','258066',4906274,'2135','322',5882778.08,5883413.28,0.00,0.00,635.20,444640.00,0.00,0.00,0.00),('1','141','764','258066',4906275,'2136','322',128560.30,129691.30,0.00,0.00,1131.00,743775.00,0.00,0.00,0.00),('1','141','764','258066',4906276,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258066',4906277,'2138','322',151220.69,152987.69,0.00,0.00,1767.00,1157385.00,0.00,0.00,0.00),('1','141','764','258066',4906278,'2139','322',152938.95,154763.95,0.00,0.00,1825.00,1195375.00,0.00,0.00,0.00),('1','141','764','258066',4906279,'2140','322',132764.17,134403.75,0.00,0.00,1639.58,1073924.90,0.00,0.00,0.00),('1','141','764','258066',4906280,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258066',4906281,'2142','322',51621.77,51754.27,0.00,0.00,132.50,87912.50,0.00,0.00,0.00),('1','141','764','258067',4906282,'2135','322',5883413.28,5883912.69,0.00,0.00,499.41,349587.00,0.00,0.00,0.00),('1','141','764','258067',4906283,'2136','322',129691.30,130169.78,0.00,0.00,478.48,309499.60,0.00,0.00,0.00),('1','141','764','258067',4906284,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258067',4906285,'2138','322',152987.69,153823.19,0.00,0.00,835.50,539867.50,0.00,0.00,0.00),('1','141','764','258067',4906286,'2139','322',154763.95,155354.95,0.00,0.00,591.00,382480.00,0.00,0.00,0.00),('1','141','764','258067',4906287,'2140','322',134403.75,134881.25,0.00,0.00,477.50,308717.50,0.00,0.00,0.00),('1','141','764','258067',4906288,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258067',4906289,'2142','322',51754.27,51762.82,0.00,0.00,8.55,5514.75,0.00,0.00,0.00),('1','141','764','258068',4906290,'2135','322',5883912.69,5884527.90,0.00,0.00,615.21,430647.00,0.00,0.00,0.00),('1','141','764','258068',4906291,'2136','322',130169.78,132230.57,0.00,0.00,2060.79,1329209.55,0.00,0.00,0.00),('1','141','764','258068',4906292,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258068',4906293,'2138','322',153823.19,155937.69,0.00,0.00,2114.50,1363852.50,0.00,0.00,0.00),('1','141','764','258068',4906294,'2139','322',155354.95,157722.17,0.00,0.00,2367.22,1526856.90,0.00,0.00,0.00),('1','141','764','258068',4906295,'2140','322',134881.25,136495.75,0.00,0.00,1614.50,1041352.50,0.00,0.00,0.00),('1','141','764','258068',4906296,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258068',4906297,'2142','322',51762.82,52252.08,0.00,0.00,489.26,316947.70,0.00,0.00,0.00),('1','141','764','258069',4906298,'2135','322',5884527.90,5884527.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258069',4906299,'2136','322',132230.57,132230.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258069',4906300,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258069',4906301,'2138','322',155937.69,155937.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258069',4906302,'2139','322',157722.17,157722.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258069',4906303,'2140','322',136495.75,136495.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258069',4906304,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258069',4906305,'2142','322',52252.08,52252.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258070',4906306,'2135','322',5884527.90,5884873.42,0.00,0.00,345.52,241864.00,0.00,0.00,0.00),('1','141','764','258070',4906307,'2136','322',132230.57,133380.09,0.00,0.00,1149.52,743227.90,0.00,0.00,0.00),('1','141','764','258070',4906308,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258070',4906309,'2138','322',155937.69,157355.19,0.00,0.00,1417.50,914287.50,0.00,0.00,0.00),('1','141','764','258070',4906310,'2139','322',157722.17,159140.67,0.00,0.00,1418.50,914932.50,0.00,0.00,0.00),('1','141','764','258070',4906311,'2140','322',136495.75,137497.25,0.00,0.00,1001.50,645967.50,0.00,0.00,0.00),('1','141','764','258070',4906312,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258070',4906313,'2142','322',52252.08,52366.08,0.00,0.00,114.00,73530.00,0.00,0.00,0.00),('1','141','764','258071',4906314,'2135','322',5884873.42,5885621.62,0.00,0.00,748.20,523740.00,0.00,0.00,0.00),('1','141','764','258071',4906315,'2136','322',133380.09,135417.04,0.00,0.00,2036.95,1315207.75,0.00,0.00,0.00),('1','141','764','258071',4906316,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258071',4906317,'2138','322',157355.19,159472.69,0.00,0.00,2117.50,1365787.50,0.00,0.00,0.00),('1','141','764','258071',4906318,'2139','322',159140.67,161228.43,0.00,0.00,2087.76,1346605.20,0.00,0.00,0.00),('1','141','764','258071',4906319,'2140','322',137497.25,139407.75,0.00,0.00,1910.50,1232272.50,0.00,0.00,0.00),('1','141','764','258071',4906320,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258071',4906321,'2142','322',52366.08,52923.87,0.00,0.00,557.79,359774.55,0.00,0.00,0.00),('1','141','764','258072',4906322,'2135','322',5885621.62,5886236.92,0.00,0.00,615.30,430710.00,0.00,0.00,0.00),('1','141','764','258072',4906323,'2136','322',135417.04,136667.04,0.00,0.00,1250.00,806250.00,0.00,0.00,0.00),('1','141','764','258072',4906324,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258072',4906325,'2138','322',159472.69,160593.48,0.00,0.00,1120.79,722909.55,0.00,0.00,0.00),('1','141','764','258072',4906326,'2139','322',161228.43,162762.43,0.00,0.00,1534.00,989430.00,0.00,0.00,0.00),('1','141','764','258072',4906327,'2140','322',139407.75,140626.73,0.00,0.00,1218.98,786242.10,0.00,0.00,0.00),('1','141','764','258072',4906328,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258072',4906329,'2142','322',52923.87,52978.87,0.00,0.00,55.00,35475.00,0.00,0.00,0.00),('1','141','764','258073',4906330,'2135','322',5886236.92,5886538.73,0.00,0.00,301.81,211267.00,0.00,0.00,0.00),('1','141','764','258073',4906331,'2136','322',136667.04,137525.54,0.00,0.00,858.50,553732.50,0.00,0.00,0.00),('1','141','764','258073',4906332,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258073',4906333,'2138','322',160593.48,161438.12,0.00,0.00,844.64,544792.80,0.00,0.00,0.00),('1','141','764','258073',4906334,'2139','322',162762.43,163539.43,0.00,0.00,777.00,501165.00,0.00,0.00,0.00),('1','141','764','258073',4906335,'2140','322',140626.73,141390.14,0.00,0.00,763.41,492399.45,0.00,0.00,0.00),('1','141','764','258073',4906336,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258073',4906337,'2142','322',52978.87,53323.87,0.00,0.00,345.00,222525.00,0.00,0.00,0.00),('1','141','764','258074',4906338,'2135','322',5886538.73,5886538.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258074',4906339,'2136','322',137525.54,137525.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258074',4906340,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258074',4906341,'2138','322',161438.12,161438.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258074',4906342,'2139','322',163539.43,163539.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258074',4906343,'2140','322',141390.14,141390.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258074',4906344,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258074',4906345,'2142','322',53323.87,53323.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258075',4906346,'2135','322',5886538.73,5887532.82,0.00,0.00,994.09,695863.00,0.00,0.00,0.00),('1','141','764','258075',4906347,'2136','322',137525.54,139636.59,0.00,0.00,2111.05,1361627.25,0.00,0.00,0.00),('1','141','764','258075',4906348,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258075',4906349,'2138','322',161438.12,163843.14,0.00,0.00,2405.02,1551237.90,0.00,0.00,0.00),('1','141','764','258075',4906350,'2139','322',163539.43,165398.43,0.00,0.00,1859.00,1204555.00,0.00,0.00,0.00),('1','141','764','258075',4906351,'2140','322',141390.14,143185.14,0.00,0.00,1795.00,1157775.00,0.00,0.00,0.00),('1','141','764','258075',4906352,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258075',4906353,'2142','322',53323.87,53791.87,0.00,0.00,468.00,301860.00,0.00,0.00,0.00),('1','141','764','258076',4906354,'2135','322',5887532.82,5888585.42,0.00,0.00,1052.60,736820.00,0.00,0.00,0.00),('1','141','764','258076',4906355,'2136','322',139636.59,141661.59,0.00,0.00,2025.00,1309150.00,0.00,0.00,0.00),('1','141','764','258076',4906356,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258076',4906357,'2138','322',163843.14,165744.64,0.00,0.00,1901.50,1226467.50,0.00,0.00,0.00),('1','141','764','258076',4906358,'2139','322',165398.43,167293.81,0.00,0.00,1895.38,1222520.10,0.00,0.00,0.00),('1','141','764','258076',4906359,'2140','322',143185.14,145026.14,0.00,0.00,1841.00,1187445.00,0.00,0.00,0.00),('1','141','764','258076',4906360,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258076',4906361,'2142','322',53791.87,54362.37,0.00,0.00,570.50,367972.50,0.00,0.00,0.00),('1','141','764','258077',4906362,'2135','322',5888585.42,5888631.33,0.00,0.00,45.91,32137.00,0.00,0.00,0.00),('1','141','764','258077',4906363,'2136','322',141661.59,143236.29,0.00,0.00,1574.70,1015681.50,0.00,0.00,0.00),('1','141','764','258077',4906364,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258077',4906365,'2138','322',165744.64,167064.64,0.00,0.00,1320.00,851400.00,0.00,0.00,0.00),('1','141','764','258077',4906366,'2139','322',167293.81,168482.31,0.00,0.00,1188.50,766582.50,0.00,0.00,0.00),('1','141','764','258077',4906367,'2140','322',145026.14,146001.64,0.00,0.00,975.50,629197.50,0.00,0.00,0.00),('1','141','764','258077',4906368,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258077',4906369,'2142','322',54362.37,55002.20,0.00,0.00,639.83,412690.35,0.00,0.00,0.00),('1','141','764','258078',4906370,'2135','322',5888631.33,5888631.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258078',4906371,'2136','322',143236.29,143236.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258078',4906372,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258078',4906373,'2138','322',167064.64,167064.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258078',4906374,'2139','322',168482.31,168482.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258078',4906375,'2140','322',146001.64,146001.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258078',4906376,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258078',4906377,'2142','322',55002.20,55002.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258079',4906378,'2135','322',5888631.33,5889377.12,0.00,0.00,745.79,522053.00,0.00,0.00,0.00),('1','141','764','258079',4906379,'2136','322',143236.29,146655.79,0.00,0.00,3419.50,2205577.50,0.00,0.00,0.00),('1','141','764','258079',4906380,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258079',4906381,'2138','322',167064.64,169539.64,0.00,0.00,2475.00,1596375.00,0.00,0.00,0.00),('1','141','764','258079',4906382,'2139','322',168482.31,172340.94,0.00,0.00,3858.63,2488816.35,0.00,0.00,0.00),('1','141','764','258079',4906383,'2140','322',146001.64,148929.64,0.00,0.00,2928.00,1888560.00,0.00,0.00,0.00),('1','141','764','258079',4906384,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258079',4906385,'2142','322',55002.20,57242.20,0.00,0.00,2240.00,1444800.00,0.00,0.00,0.00),('1','141','764','258080',4906386,'2135','322',5889377.12,5889997.06,0.00,0.00,619.94,433958.00,0.00,0.00,0.00),('1','141','764','258080',4906387,'2136','322',146655.79,147954.39,0.00,0.00,1298.60,837832.95,0.00,0.00,0.00),('1','141','764','258080',4906388,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258080',4906389,'2138','322',169539.64,170607.14,0.00,0.00,1067.50,688537.50,0.00,0.00,0.00),('1','141','764','258080',4906390,'2139','322',172340.94,173701.94,0.00,0.00,1361.00,877845.00,0.00,0.00,0.00),('1','141','764','258080',4906391,'2140','322',148929.64,150013.64,0.00,0.00,1084.00,701930.00,0.00,0.00,0.00),('1','141','764','258080',4906392,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258080',4906393,'2142','322',57242.20,57608.70,0.00,0.00,366.50,236392.50,0.00,0.00,0.00),('1','141','764','258081',4906394,'2135','322',5889997.06,5890287.45,0.00,0.00,290.39,203273.00,0.00,0.00,0.00),('1','141','764','258081',4906395,'2136','322',147954.39,148560.39,0.00,0.00,606.00,390870.00,0.00,0.00,0.00),('1','141','764','258081',4906396,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258081',4906397,'2138','322',170607.14,171197.74,0.00,0.00,590.60,380937.00,0.00,0.00,0.00),('1','141','764','258081',4906398,'2139','322',173701.94,174355.51,0.00,0.00,653.57,421552.65,0.00,0.00,0.00),('1','141','764','258081',4906399,'2140','322',150013.64,150896.14,0.00,0.00,882.50,569212.50,0.00,0.00,0.00),('1','141','764','258081',4906400,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258081',4906401,'2142','322',57608.70,57742.20,0.00,0.00,133.50,86107.50,0.00,0.00,0.00),('1','141','764','258082',4906402,'2135','322',5890287.45,5890287.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258082',4906403,'2136','322',148560.39,148560.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258082',4906404,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258082',4906405,'2138','322',171197.74,171197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258082',4906406,'2139','322',174355.51,174355.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258082',4906407,'2140','322',150896.14,150896.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258082',4906408,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258082',4906409,'2142','322',57742.20,57742.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258083',4906410,'2135','322',5890287.45,5890984.67,0.00,0.00,697.22,488054.00,0.00,0.00,0.00),('1','141','764','258083',4906411,'2136','322',148560.39,150305.84,0.00,0.00,1745.45,1125815.25,0.00,0.00,0.00),('1','141','764','258083',4906412,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258083',4906413,'2138','322',171197.74,172525.74,0.00,0.00,1328.00,856560.00,0.00,0.00,0.00),('1','141','764','258083',4906414,'2139','322',174355.51,176053.51,0.00,0.00,1698.00,1095210.00,0.00,0.00,0.00),('1','141','764','258083',4906415,'2140','322',150896.14,152703.14,0.00,0.00,1807.00,1165515.00,0.00,0.00,0.00),('1','141','764','258083',4906416,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258083',4906417,'2142','322',57742.20,58076.71,0.00,0.00,334.51,215758.95,0.00,0.00,0.00),('1','141','764','258084',4906418,'2135','322',5890984.67,5891589.01,0.00,0.00,604.34,423038.00,0.00,0.00,0.00),('1','141','764','258084',4906419,'2136','322',150305.84,151935.34,0.00,0.00,1629.50,1051137.50,0.00,0.00,0.00),('1','141','764','258084',4906420,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258084',4906421,'2138','322',172525.74,174357.24,0.00,0.00,1831.50,1181317.50,0.00,0.00,0.00),('1','141','764','258084',4906422,'2139','322',176053.51,177646.51,0.00,0.00,1593.00,1027485.00,0.00,0.00,0.00),('1','141','764','258084',4906423,'2140','322',152703.14,154136.87,0.00,0.00,1433.73,924755.85,0.00,0.00,0.00),('1','141','764','258084',4906424,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258084',4906425,'2142','322',58076.71,58275.71,0.00,0.00,199.00,128355.00,0.00,0.00,0.00),('1','141','764','258085',4906426,'2135','322',5891589.01,5892267.14,0.00,0.00,678.13,474691.00,0.00,0.00,0.00),('1','141','764','258085',4906427,'2136','322',151935.34,153555.48,0.00,0.00,1620.14,1045155.30,0.00,0.00,0.00),('1','141','764','258085',4906428,'2137','322',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258085',4906429,'2138','322',174357.24,176046.74,0.00,0.00,1689.50,1089727.50,0.00,0.00,0.00),('1','141','764','258085',4906430,'2139','322',177646.51,179552.02,0.00,0.00,1905.51,1229053.95,0.00,0.00,0.00),('1','141','764','258085',4906431,'2140','322',154136.87,155849.37,0.00,0.00,1712.50,1104562.50,0.00,0.00,0.00),('1','141','764','258085',4906432,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258085',4906433,'2142','322',58275.71,58721.35,0.00,0.00,445.64,287437.80,0.00,0.00,0.00),('1','141','764','258086',4906434,'2135','322',5892267.14,5892447.35,0.00,0.00,180.21,126147.00,0.00,0.00,0.00),('1','141','764','258086',4906435,'2136','322',153555.48,153838.69,0.00,0.00,283.21,182670.45,0.00,0.00,0.00),('1','141','764','258086',4906436,'2137','322',6.00,92.00,0.00,0.00,86.00,55470.00,0.00,0.00,0.00),('1','141','764','258086',4906437,'2138','322',176046.74,176146.74,0.00,0.00,100.00,64500.00,0.00,0.00,0.00),('1','141','764','258086',4906438,'2139','322',179552.02,179853.02,0.00,0.00,301.00,194145.00,0.00,0.00,0.00),('1','141','764','258086',4906439,'2140','322',155849.37,156258.87,0.00,0.00,409.50,264127.50,0.00,0.00,0.00),('1','141','764','258086',4906440,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258086',4906441,'2142','322',58721.35,59083.85,0.00,0.00,362.50,233812.50,0.00,0.00,0.00),('1','141','764','258087',4906442,'2135','322',5892447.35,5892447.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258087',4906443,'2136','322',153838.69,153838.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258087',4906444,'2137','322',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258087',4906445,'2138','322',176146.74,176146.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258087',4906446,'2139','322',179853.02,179853.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258087',4906447,'2140','322',156258.87,156258.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258087',4906448,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258087',4906449,'2142','322',59083.85,59083.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258088',4906450,'2135','322',5892447.35,5893092.81,0.00,0.00,645.46,451822.00,0.00,0.00,0.00),('1','141','764','258088',4906451,'2136','322',153838.69,155320.11,0.00,0.00,1481.42,955845.90,0.00,0.00,0.00),('1','141','764','258088',4906452,'2137','322',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258088',4906453,'2138','322',176146.74,177908.63,0.00,0.00,1761.89,1136419.05,0.00,0.00,0.00),('1','141','764','258088',4906454,'2139','322',179853.02,181157.02,0.00,0.00,1304.00,841080.00,0.00,0.00,0.00),('1','141','764','258088',4906455,'2140','322',156258.87,157683.23,0.00,0.00,1424.36,918712.20,0.00,0.00,0.00),('1','141','764','258088',4906456,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258088',4906457,'2142','322',59083.85,59255.85,0.00,0.00,172.00,110940.00,0.00,0.00,0.00),('1','141','764','258089',4906458,'2135','322',5893092.81,5893726.02,0.00,0.00,633.21,443247.00,0.00,0.00,0.00),('1','141','764','258089',4906459,'2136','322',155320.11,156819.58,0.00,0.00,1499.47,967158.15,0.00,0.00,0.00),('1','141','764','258089',4906460,'2137','322',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258089',4906461,'2138','322',177908.63,179542.09,0.00,0.00,1633.46,1053581.70,0.00,0.00,0.00),('1','141','764','258089',4906462,'2139','322',181157.02,183084.02,0.00,0.00,1927.00,1242915.00,0.00,0.00,0.00),('1','141','764','258089',4906463,'2140','322',157683.23,159352.23,0.00,0.00,1669.00,1076505.00,0.00,0.00,0.00),('1','141','764','258089',4906464,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258089',4906465,'2142','322',59255.85,59337.35,0.00,0.00,81.50,52567.50,0.00,0.00,0.00),('1','141','764','258090',4906466,'2135','322',5893726.02,5894306.59,0.00,0.00,580.57,406399.00,0.00,0.00,0.00),('1','141','764','258090',4906467,'2136','322',156819.58,158438.89,0.00,0.00,1619.31,1044454.95,0.00,0.00,0.00),('1','141','764','258090',4906468,'2137','322',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258090',4906469,'2138','322',179542.09,180629.52,0.00,0.00,1087.43,701392.35,0.00,0.00,0.00),('1','141','764','258090',4906470,'2139','322',183084.02,184292.02,0.00,0.00,1208.00,779160.00,0.00,0.00,0.00),('1','141','764','258090',4906471,'2140','322',159352.23,161341.73,0.00,0.00,1989.50,1283227.50,0.00,0.00,0.00),('1','141','764','258090',4906472,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258090',4906473,'2142','322',59337.35,59562.85,0.00,0.00,225.50,145447.50,0.00,0.00,0.00),('1','141','764','258091',4906474,'2135','322',5894306.59,5894700.91,0.00,0.00,394.32,276024.00,0.00,0.00,0.00),('1','141','764','258091',4906475,'2136','322',158438.89,159154.99,0.00,0.00,716.10,461884.50,0.00,0.00,0.00),('1','141','764','258091',4906476,'2137','322',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258091',4906477,'2138','322',180629.52,181242.02,0.00,0.00,612.50,395062.50,0.00,0.00,0.00),('1','141','764','258091',4906478,'2139','322',184292.02,185136.52,0.00,0.00,844.50,544702.50,0.00,0.00,0.00),('1','141','764','258091',4906479,'2140','322',161341.73,162112.91,0.00,0.00,771.18,497411.10,0.00,0.00,0.00),('1','141','764','258091',4906480,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258091',4906481,'2142','322',59562.85,59753.85,0.00,0.00,191.00,123195.00,0.00,0.00,0.00),('1','141','764','258092',4906482,'2135','322',5894700.91,5894700.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258092',4906483,'2136','322',159154.99,159154.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258092',4906484,'2137','322',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258092',4906485,'2138','322',181242.02,181242.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258092',4906486,'2139','322',185136.52,185136.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258092',4906487,'2140','322',162112.91,162112.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258092',4906488,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258092',4906489,'2142','322',59753.85,59753.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258093',4906490,'2135','322',5894700.91,5895446.89,0.00,0.00,745.98,522186.00,0.00,0.00,0.00),('1','141','764','258093',4906491,'2136','322',159154.99,160512.99,0.00,0.00,1358.00,875910.00,0.00,0.00,0.00),('1','141','764','258093',4906492,'2137','322',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258093',4906493,'2138','322',181242.02,182456.02,0.00,0.00,1214.00,783030.00,0.00,0.00,0.00),('1','141','764','258093',4906494,'2139','322',185136.52,186928.52,0.00,0.00,1792.00,1155840.00,0.00,0.00,0.00),('1','141','764','258093',4906495,'2140','322',162112.91,163537.41,0.00,0.00,1424.50,918802.50,0.00,0.00,0.00),('1','141','764','258093',4906496,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258093',4906497,'2142','322',59753.85,59968.67,0.00,0.00,214.82,138558.90,0.00,0.00,0.00),('1','141','764','258094',4906498,'2135','322',5895446.89,5896231.74,0.00,0.00,784.85,549395.00,0.00,0.00,0.00),('1','141','764','258094',4906499,'2136','322',160512.99,161930.67,0.00,0.00,1417.68,914623.60,0.00,0.00,0.00),('1','141','764','258094',4906500,'2137','322',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258094',4906501,'2138','322',182456.02,183848.02,0.00,0.00,1392.00,897840.00,0.00,0.00,0.00),('1','141','764','258094',4906502,'2139','322',186928.52,188246.52,0.00,0.00,1318.00,850110.00,0.00,0.00,0.00),('1','141','764','258094',4906503,'2140','322',163537.41,165219.91,0.00,0.00,1682.50,1085212.50,0.00,0.00,0.00),('1','141','764','258094',4906504,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258094',4906505,'2142','322',59968.67,60290.17,0.00,0.00,321.50,207367.50,0.00,0.00,0.00),('1','141','764','258095',4906506,'2135','322',5896231.74,5896513.67,0.00,0.00,281.93,197351.00,0.00,0.00,0.00),('1','141','764','258095',4906507,'2136','322',161930.67,163226.67,0.00,0.00,1296.00,835920.00,0.00,0.00,0.00),('1','141','764','258095',4906508,'2137','322',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258095',4906509,'2138','322',183848.02,185339.17,0.00,0.00,1491.15,966780.80,0.00,0.00,0.00),('1','141','764','258095',4906510,'2139','322',188246.52,189026.52,0.00,0.00,780.00,503100.00,0.00,0.00,0.00),('1','141','764','258095',4906511,'2140','322',165219.91,166147.12,0.00,0.00,927.21,598050.45,0.00,0.00,0.00),('1','141','764','258095',4906512,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258095',4906513,'2142','322',60290.17,60565.31,0.00,0.00,275.14,177465.30,0.00,0.00,0.00),('1','141','764','258096',4906514,'2135','322',5896513.67,5897043.82,0.00,0.00,530.15,371105.00,0.00,0.00,0.00),('1','141','764','258096',4906515,'2136','322',163226.67,164579.67,0.00,0.00,1353.00,872685.00,0.00,0.00,0.00),('1','141','764','258096',4906516,'2137','322',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258096',4906517,'2138','322',185339.17,186259.17,0.00,0.00,920.00,593400.00,0.00,0.00,0.00),('1','141','764','258096',4906518,'2139','322',189026.52,190593.30,0.00,0.00,1566.78,1010573.10,0.00,0.00,0.00),('1','141','764','258096',4906519,'2140','322',166147.12,167362.12,0.00,0.00,1215.00,783675.00,0.00,0.00,0.00),('1','141','764','258096',4906520,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258096',4906521,'2142','322',60565.31,60844.31,0.00,0.00,279.00,179955.00,0.00,0.00,0.00),('1','141','764','258097',4906522,'2135','322',5897043.82,5897043.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258097',4906523,'2136','322',164579.67,164579.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258097',4906524,'2137','322',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258097',4906525,'2138','322',186259.17,186259.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258097',4906526,'2139','322',190593.30,190593.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258097',4906527,'2140','322',167362.12,167362.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258097',4906528,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258097',4906529,'2142','322',60844.31,60844.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258098',4906530,'2135','322',5897043.82,5897654.61,0.00,0.00,610.79,427553.00,0.00,0.00,0.00),('1','141','764','258098',4906531,'2136','322',164579.67,166198.79,0.00,0.00,1619.12,1044332.40,0.00,0.00,0.00),('1','141','764','258098',4906532,'2137','322',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258098',4906533,'2138','322',186259.17,187513.71,0.00,0.00,1254.54,809178.30,0.00,0.00,0.00),('1','141','764','258098',4906534,'2139','322',190593.30,192661.44,0.00,0.00,2068.14,1333950.30,0.00,0.00,0.00),('1','141','764','258098',4906535,'2140','322',167362.12,168938.40,0.00,0.00,1576.28,1016700.60,0.00,0.00,0.00),('1','141','764','258098',4906536,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258098',4906537,'2142','322',60844.31,60993.31,0.00,0.00,149.00,96105.00,0.00,0.00,0.00),('1','141','764','258099',4906538,'2135','322',5897654.61,5897654.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258099',4906539,'2136','322',166198.79,166198.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258099',4906540,'2137','322',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258099',4906541,'2138','322',187513.71,187513.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258099',4906542,'2139','322',192661.44,192661.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258099',4906543,'2140','322',168938.40,168938.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258099',4906544,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258099',4906545,'2142','322',60993.31,60993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258100',4906546,'2135','322',5897654.61,5898307.21,0.00,0.00,652.60,456820.00,0.00,0.00,0.00),('1','141','764','258100',4906547,'2136','322',166198.79,167147.40,0.00,0.00,948.61,611853.45,0.00,0.00,0.00),('1','141','764','258100',4906548,'2137','322',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258100',4906549,'2138','322',187513.71,188268.71,0.00,0.00,755.00,486975.00,0.00,0.00,0.00),('1','141','764','258100',4906550,'2139','322',192661.44,193943.70,0.00,0.00,1282.26,827057.70,0.00,0.00,0.00),('1','141','764','258100',4906551,'2140','322',168938.40,170001.94,0.00,0.00,1063.54,685983.30,0.00,0.00,0.00),('1','141','764','258100',4906552,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258100',4906553,'2142','322',60993.31,61045.85,0.00,0.00,52.54,33888.30,0.00,0.00,0.00),('1','141','764','258101',4906554,'2135','322',5898307.21,5899047.03,0.00,0.00,739.82,517874.00,0.00,0.00,0.00),('1','141','764','258101',4906555,'2136','322',167147.40,168781.40,0.00,0.00,1634.00,1053930.00,0.00,0.00,0.00),('1','141','764','258101',4906556,'2137','322',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258101',4906557,'2138','322',188268.71,189905.16,0.00,0.00,1636.45,1055510.25,0.00,0.00,0.00),('1','141','764','258101',4906558,'2139','322',193943.70,196226.70,0.00,0.00,2283.00,1472535.00,0.00,0.00,0.00),('1','141','764','258101',4906559,'2140','322',170001.94,171205.44,0.00,0.00,1203.50,776257.50,0.00,0.00,0.00),('1','141','764','258101',4906560,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258101',4906561,'2142','322',61045.85,61613.35,0.00,0.00,567.50,366037.50,0.00,0.00,0.00),('1','141','764','258102',4906562,'2135','322',5899047.03,5899373.14,0.00,0.00,326.11,228277.00,0.00,0.00,0.00),('1','141','764','258102',4906563,'2136','322',168781.40,169693.90,0.00,0.00,912.50,588562.50,0.00,0.00,0.00),('1','141','764','258102',4906564,'2137','322',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258102',4906565,'2138','322',189905.16,190991.66,0.00,0.00,1086.50,700792.50,0.00,0.00,0.00),('1','141','764','258102',4906566,'2139','322',196226.70,197397.18,0.00,0.00,1170.48,754959.60,0.00,0.00,0.00),('1','141','764','258102',4906567,'2140','322',171205.44,172063.44,0.00,0.00,858.00,553410.00,0.00,0.00,0.00),('1','141','764','258102',4906568,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258102',4906569,'2142','322',61613.35,61810.35,0.00,0.00,197.00,127065.00,0.00,0.00,0.00),('1','141','764','258103',4906570,'2135','322',5899373.14,5899373.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258103',4906571,'2136','322',169693.90,169693.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258103',4906572,'2137','322',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258103',4906573,'2138','322',190991.66,190991.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258103',4906574,'2139','322',197397.18,197397.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258103',4906575,'2140','322',172063.44,172063.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258103',4906576,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258103',4906577,'2142','322',61810.35,61810.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258104',4906578,'2135','322',5899373.14,5899766.61,0.00,0.00,393.47,275429.00,0.00,0.00,0.00),('1','141','764','258104',4906579,'2136','322',169693.90,170782.90,0.00,0.00,1089.00,702405.00,0.00,0.00,0.00),('1','141','764','258104',4906580,'2137','322',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258104',4906581,'2138','322',190991.66,192203.27,0.00,0.00,1211.61,781488.45,0.00,0.00,0.00),('1','141','764','258104',4906582,'2139','322',197397.18,198186.68,0.00,0.00,789.50,509227.50,0.00,0.00,0.00),('1','141','764','258104',4906583,'2140','322',172063.44,172442.44,0.00,0.00,379.00,244455.00,0.00,0.00,0.00),('1','141','764','258104',4906584,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258104',4906585,'2142','322',61810.35,62096.35,0.00,0.00,286.00,184470.00,0.00,0.00,0.00),('1','141','764','258105',4906586,'2135','322',5899766.61,5900694.63,0.00,0.00,928.02,649614.00,0.00,0.00,0.00),('1','141','764','258105',4906587,'2136','322',170782.90,173410.96,0.00,0.00,2628.06,1695098.70,0.00,0.00,0.00),('1','141','764','258105',4906588,'2137','322',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258105',4906589,'2138','322',192203.27,195477.77,0.00,0.00,3274.50,2112052.50,0.00,0.00,0.00),('1','141','764','258105',4906590,'2139','322',198186.68,200444.68,0.00,0.00,2258.00,1456410.00,0.00,0.00,0.00),('1','141','764','258105',4906591,'2140','322',172442.44,172442.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258105',4906592,'2141','322',12080.69,12080.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','141','764','258105',4906593,'2142','322',62096.35,62928.85,0.00,0.00,832.50,536962.50,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730363 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','141','144948','322',188.00,210.00,0.00,2844.70,534803.60,566062.00,31258.40,435629),('1','141','145032','322',188.00,210.00,0.00,9101.00,1710988.00,1806266.00,95278.00,435864),('1','141','145043','322',188.00,196.00,0.00,10764.30,2023688.40,2120596.80,96908.40,435895),('1','141','145057','322',188.00,210.00,0.00,915.80,172170.40,188720.00,16549.60,435935),('1','141','145072','322',188.00,210.00,0.00,3861.00,725868.00,810810.00,84942.00,435978),('1','141','145081','322',188.00,210.00,0.00,3627.80,682026.40,772289.00,90262.60,436003),('1','141','145124','322',188.00,210.00,0.00,4670.30,878016.40,991424.00,113407.60,436129),('1','141','145125','322',188.00,210.00,0.00,6802.70,1278907.60,1437646.00,158738.40,436130),('1','141','145126','322',188.00,210.00,0.00,3000.00,564000.00,644385.00,80385.00,436131),('1','141','145626','322',188.00,210.00,0.00,10174.80,1912862.40,2150253.00,237390.60,437570),('1','141','145630','322',188.00,210.00,0.00,11969.80,2250322.40,2525404.00,275081.60,437580),('1','141','145638','322',192.50,210.00,0.00,3215.00,618887.50,682570.00,63682.50,437602),('1','141','145642','322',192.50,210.00,0.00,8161.60,1571108.00,1726893.00,155785.00,437612),('1','141','145645','322',192.50,210.00,0.00,6433.00,1238352.50,1360100.00,121747.50,437619),('1','141','145647','322',192.50,210.00,0.00,1671.70,321802.25,353507.00,31704.75,437623),('1','141','145654','322',192.50,210.00,0.00,11715.70,2255272.25,2472862.00,217589.75,437642),('1','141','145655','322',192.50,210.00,0.00,7886.80,1518209.00,1663578.00,145369.00,437643),('1','141','145714','322',192.50,210.00,0.00,3402.90,655058.25,720307.00,65248.75,437818),('1','141','145719','322',192.50,210.00,0.00,7150.50,1376471.25,1511650.00,135178.75,437831),('1','141','145720','322',192.50,210.00,0.00,5881.30,1132150.25,1249234.00,117083.75,437832),('1','141','145724','322',192.50,210.00,0.00,3125.20,601601.00,656292.00,54691.00,437842),('1','141','147954','322',192.50,210.00,0.00,13225.20,2545851.00,2791600.00,245749.00,443951),('1','141','147971','322',192.50,210.00,0.00,5163.50,993973.75,1091580.00,97606.25,443998),('1','141','148093','322',192.50,210.00,0.00,4286.30,825112.75,911008.00,85895.25,444321),('1','141','148198','322',192.50,210.00,0.00,9025.30,1737370.25,1904357.00,166986.75,444595),('1','141','148209','322',192.50,210.00,0.00,7154.40,1377222.00,1513232.00,136010.00,444626),('1','141','148215','322',192.50,210.00,0.00,6060.30,1166607.75,1275827.00,109219.25,444642),('1','141','148221','322',192.50,210.00,0.00,5049.50,972028.75,1068585.00,96556.25,444656),('1','141','148245','322',192.50,210.00,0.00,5165.10,994281.75,1091986.00,97704.25,444723),('1','141','148250','322',192.50,210.00,0.00,7020.10,1351369.25,1483748.00,132378.75,444733),('1','141','148254','322',192.50,210.00,0.00,5388.00,1037190.00,1140895.00,103705.00,444741),('1','141','148256','322',192.50,210.00,0.00,5823.90,1121100.75,1233190.00,112089.25,444743),('1','141','148264','322',192.50,210.00,0.00,9878.00,1901515.00,2087820.00,186305.00,444761),('1','141','148266','322',192.50,210.00,0.00,5973.10,1149821.75,1262702.00,112880.25,444765),('1','141','148267','322',192.50,210.00,0.00,13698.60,2636980.50,2886548.00,249567.50,444766),('1','141','148270','322',192.50,210.00,0.00,7967.90,1533820.75,1682667.00,148846.25,444773),('1','141','148388','322',192.50,210.00,0.00,13959.60,2687223.00,2941827.00,254604.00,445090),('1','141','148420','322',192.50,210.00,0.00,8741.80,1682796.50,1843324.00,160527.50,445176),('1','141','148425','322',192.50,210.00,0.00,14619.80,2814311.50,3079986.00,265674.50,445189),('1','141','148463','322',192.50,210.00,0.00,8050.00,1549625.00,1704710.00,155085.00,445288),('1','141','148466','322',192.50,210.00,0.00,6367.70,1225782.25,1347276.00,121493.75,445295),('1','141','148469','322',192.50,210.00,0.00,4578.50,881361.25,970095.00,88733.75,445302),('1','141','148554','322',192.50,210.00,0.00,8429.30,1622640.25,1779204.00,156563.75,445526),('1','141','148815','322',192.50,210.00,0.00,3498.10,673384.25,740859.00,67474.75,446181),('1','141','148968','322',192.50,210.00,0.00,10218.10,1966984.25,2155524.00,188539.75,446592),('1','141','149163','322',192.50,210.00,0.00,5249.60,1010548.00,1111978.00,101430.00,447110),('1','141','149305','322',192.50,210.00,0.00,6117.90,1177695.75,1293187.00,115491.25,447482),('1','141','149487','322',192.50,210.00,0.00,1141.40,219719.50,249158.00,29438.50,447974),('1','141','149578','322',190.00,210.00,0.00,9044.70,1718493.00,1908837.00,190344.00,448236),('1','141','149738','322',190.00,210.00,0.00,10513.30,1997527.00,2217621.00,220094.00,448647),('1','141','150011','322',190.00,210.00,0.00,3083.00,585770.00,655375.00,69605.00,449378),('1','141','150422','322',190.00,210.00,0.00,6970.00,1324300.00,1472240.00,147940.00,450444),('1','141','151025','322',190.00,210.00,0.00,4762.40,904856.00,1010002.00,105146.00,452048),('1','141','151026','322',190.00,210.00,0.00,4526.00,859940.00,961576.00,101636.00,452049),('1','141','151027','322',190.00,210.00,0.00,6368.50,1210015.00,1347885.00,137870.00,452050),('1','141','151180','322',190.00,210.00,0.00,5351.40,1016766.00,1133370.00,116604.00,452469),('1','141','151455','322',190.00,210.00,0.00,5933.70,1127403.00,1255926.00,128523.00,453216),('1','141','151462','322',190.00,210.00,0.00,4690.00,891100.00,992530.00,101430.00,453233),('1','141','151607','322',190.00,210.00,0.00,4805.10,912969.00,1018038.00,105069.00,453635),('1','141','151856','322',190.00,210.00,0.00,3343.60,635284.00,712418.00,77134.00,454292),('1','141','152086','322',190.00,210.00,0.00,7275.20,1382288.00,1528700.00,146412.00,454918),('1','141','152153','322',190.00,208.00,0.00,4725.90,897921.00,992700.00,94779.00,455099),('1','141','152290','322',190.00,208.00,0.00,3521.40,669066.00,739838.40,70772.40,455460),('1','141','152483','322',190.00,208.00,0.00,7143.90,1357341.00,1495528.80,138187.80,455969),('1','141','152633','322',190.00,208.00,0.00,3302.90,627551.00,695924.00,68373.00,456365),('1','141','152804','322',190.00,208.00,0.00,4909.40,932786.00,1029140.00,96354.00,456831),('1','141','152966','322',190.00,208.00,0.00,0.00,0.00,0.00,0.00,457284),('1','141','152968','322',190.00,208.00,0.00,7925.90,1505921.00,1660870.40,154949.40,457288),('1','141','153211','322',190.00,208.00,0.00,4810.70,914033.00,1010324.00,96291.00,457944),('1','141','153503','322',190.00,208.00,0.00,1535.80,291802.00,322456.00,30654.00,458733),('1','141','153621','322',190.00,210.00,0.00,9214.70,1750793.00,1945328.00,194535.00,459061),('1','141','153799','322',190.00,210.00,0.00,6990.70,1328233.00,1480003.00,151770.00,459534),('1','141','153925','322',190.00,210.00,0.00,6441.80,1223942.00,1359792.00,135850.00,459858),('1','141','154199','322',190.00,210.00,0.00,15483.30,2941827.00,3263862.00,322035.00,460590),('1','141','154315','322',190.00,210.00,0.00,8223.40,1562446.00,1732318.00,169872.00,460887),('1','141','154608','322',190.00,210.00,0.00,7743.00,1471170.00,1636026.00,164856.00,461687),('1','141','154757','322',190.00,210.00,0.00,7013.40,1332546.00,1480822.00,148276.00,462099),('1','141','154883','322',190.00,210.00,0.00,7815.80,1485002.00,1652294.00,167292.00,462439),('1','141','155021','322',190.00,210.00,0.00,4074.40,774136.00,865067.00,90931.00,462813),('1','141','155310','322',190.00,210.00,0.00,13670.90,2597471.00,2882229.00,284758.00,463582),('1','141','155459','322',190.00,210.00,0.00,4597.00,873430.00,975415.00,101985.00,463983),('1','141','155651','322',190.00,210.00,0.00,11933.80,2267422.00,2516199.00,248777.00,464511),('1','141','155793','322',190.00,210.00,0.00,10713.50,2035565.00,2259460.00,223895.00,464887),('1','141','155937','322',190.00,210.00,0.00,4961.90,942761.00,1049517.00,106756.00,465259),('1','141','156167','322',190.00,210.00,0.00,8432.50,1602175.00,1781465.00,179290.00,465880),('1','141','156271','322',190.00,210.00,0.00,10090.00,1917100.00,2126334.00,209234.00,466150),('1','141','156872','322',190.00,210.00,0.00,12393.40,2354746.00,2612232.00,257486.00,467792),('1','141','156890','322',190.00,210.00,0.00,6266.40,1190616.00,1326073.00,135457.00,467830),('1','141','156995','322',190.00,210.00,0.00,4270.70,811433.00,904316.00,92883.00,468110),('1','141','157496','322',190.00,210.00,0.00,0.00,0.00,0.00,0.00,469380),('1','141','157497','322',190.00,210.00,0.00,10285.80,1954302.00,2172317.00,218015.00,469381),('1','141','157678','322',190.00,210.00,0.00,6328.50,1202415.00,1341515.00,139100.00,469871),('1','141','157820','322',190.00,210.00,0.00,2887.30,548587.00,609259.00,60672.00,470248),('1','141','158077','322',190.00,210.00,0.00,7121.70,1353123.00,1499932.00,146809.00,470934),('1','141','158080','322',190.00,210.00,0.00,4896.60,930354.00,1038618.00,108264.00,470941),('1','141','158573','322',190.00,210.00,0.00,10576.40,2009516.00,2226763.00,217247.00,472229),('1','141','159288','322',190.00,228.00,0.00,3168.70,602053.00,725568.00,123515.00,474122),('1','141','159464','322',190.00,228.00,0.00,3585.40,681226.00,821028.00,139802.00,474555),('1','141','159863','322',190.00,224.00,0.00,6697.40,1272506.00,1505448.00,232942.00,475606),('1','141','159865','322',190.00,224.00,0.00,2753.80,523222.00,616851.20,93629.20,475608),('1','141','159933','322',190.00,224.00,0.00,3843.40,730246.00,867115.20,136869.20,475784),('1','141','160119','322',190.00,224.00,0.00,2458.70,467153.00,554484.00,87331.00,476259),('1','141','160304','322',200.00,224.00,0.00,10152.90,2030580.00,2279631.20,249051.20,476745),('1','141','160449','322',200.00,224.00,0.00,8435.30,1687060.00,1893724.00,206664.00,477130),('1','141','160605','322',200.00,224.00,0.00,3944.80,788960.00,886732.00,97772.00,477521),('1','141','160888','322',200.00,233.00,0.00,3833.20,766640.00,896012.00,129372.00,478238),('1','141','161088','322',200.00,233.00,0.00,8803.90,1760780.00,2058509.10,297729.10,478777),('1','141','161304','322',200.00,233.00,0.00,7384.60,1476920.00,1727149.50,250229.50,479303),('1','141','161446','322',200.00,233.00,0.00,2565.80,513160.00,600750.10,87590.10,479694),('1','141','161697','322',200.00,233.00,0.00,14148.20,2829640.00,3306137.40,476497.40,480305),('1','141','161830','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,480670),('1','141','161834','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,480679),('1','141','161839','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,480691),('1','141','161844','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,480700),('1','141','161847','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,480705),('1','141','161857','322',200.00,233.00,0.00,5777.60,1155520.00,1351684.50,196164.50,480728),('1','141','162107','322',200.00,233.00,0.00,2637.10,527420.00,617574.50,90154.50,481402),('1','141','162110','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481409),('1','141','162112','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481412),('1','141','162117','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481425),('1','141','162119','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481429),('1','141','162120','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481430),('1','141','162121','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481431),('1','141','162125','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481441),('1','141','162139','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481477),('1','141','162140','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481478),('1','141','162146','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481492),('1','141','162155','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481513),('1','141','162159','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481523),('1','141','162161','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481527),('1','141','162165','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481537),('1','141','162171','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481553),('1','141','162179','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481575),('1','141','162185','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481591),('1','141','162299','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481881),('1','141','162300','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481882),('1','141','162301','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481883),('1','141','162302','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,481884),('1','141','162490','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,482369),('1','141','162491','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,482370),('1','141','162492','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,482371),('1','141','162493','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,482372),('1','141','162495','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,482376),('1','141','162496','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,482377),('1','141','162502','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,482393),('1','141','162507','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,482404),('1','141','162511','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,482412),('1','141','162519','322',200.00,233.00,0.00,17327.20,3465440.00,4045862.10,580422.10,482431),('1','141','162636','322',200.00,233.00,0.00,5255.00,1051000.00,1228358.30,177358.30,482729),('1','141','162677','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,482827),('1','141','162802','322',200.00,233.00,0.00,6465.70,1293140.00,1512604.00,219464.00,483167),('1','141','163026','322',200.00,233.00,0.00,6175.20,1235040.00,1445011.50,209971.50,483742),('1','141','163193','322',200.00,233.00,0.00,6842.70,1368540.00,1599317.00,230777.00,484183),('1','141','163237','322',200.00,233.00,0.00,1927.50,385500.00,452938.00,67438.00,484286),('1','141','163581','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,485184),('1','141','163742','322',200.00,233.00,0.00,19542.20,3908440.00,4560608.20,652168.20,485610),('1','141','163791','322',200.00,233.00,0.00,0.00,0.00,0.00,0.00,485731),('1','141','163937','322',228.00,233.00,0.00,3858.50,879738.00,903331.00,23593.00,486104),('1','141','163939','322',228.00,250.00,0.00,5882.70,1341255.60,1474746.00,133490.40,486108),('1','141','164127','322',228.00,250.00,0.00,6344.40,1446523.20,1590279.00,143755.80,486604),('1','141','164433','322',228.00,250.00,0.00,6458.50,1472538.00,1617970.00,145432.00,487437),('1','141','164797','322',228.00,250.00,0.00,0.00,0.00,0.00,0.00,488409),('1','141','164809','322',228.00,250.00,0.00,7343.90,1674409.20,1839182.00,164772.80,488441),('1','141','165055','322',228.00,250.00,0.00,11034.30,2515820.40,2762454.00,246633.60,489065),('1','141','165164','322',228.00,270.00,0.00,4005.70,913299.60,1086516.00,173216.40,489345),('1','141','165343','322',228.00,270.00,0.00,0.00,0.00,0.00,0.00,489800),('1','141','165360','322',253.00,270.00,0.00,9699.40,2453948.20,2623472.00,169523.80,489847),('1','141','165515','322',253.00,270.00,0.00,7122.70,1802043.10,1926069.00,124025.90,490259),('1','141','165675','322',253.00,270.00,0.00,5723.20,1447969.60,1549754.50,101784.90,490688),('1','141','166207','322',253.00,270.00,0.00,0.00,0.00,0.00,0.00,492086),('1','141','166219','322',253.00,270.00,0.00,8851.60,2239454.80,2394118.00,154663.20,492120),('1','141','166354','322',253.00,270.00,0.00,6677.70,1689458.10,1806808.00,117349.90,492488),('1','141','166495','322',253.00,265.00,0.00,6852.60,1733707.80,1820203.00,86495.20,492874),('1','141','166737','322',253.00,265.00,0.00,0.00,0.00,0.00,0.00,493514),('1','141','166743','322',253.00,253.00,0.00,5574.30,1410297.90,1482609.50,72311.60,493528),('1','141','166915','322',253.00,265.00,0.00,5658.40,1431575.20,1505112.00,73536.80,493996),('1','141','167037','322',253.00,265.00,0.00,5246.50,1327364.50,1397402.50,70038.00,494334),('1','141','167376','322',253.00,265.00,0.00,6341.70,1604450.10,1685754.50,81304.40,495240),('1','141','167569','322',253.00,265.00,0.00,0.00,0.00,0.00,0.00,495745),('1','141','167573','322',253.00,265.00,0.00,8541.70,2161050.10,2270058.50,109008.40,495753),('1','141','167738','322',253.00,265.00,0.00,5791.40,1465224.20,1539597.00,74372.80,496187),('1','141','167915','322',253.00,265.00,0.00,5847.30,1479366.90,1554826.50,75459.60,496656),('1','141','168122','322',253.00,265.00,0.00,2377.40,601482.20,635927.00,34444.80,497205),('1','141','168124','322',253.00,265.00,0.00,0.00,0.00,0.00,0.00,497209),('1','141','168288','322',253.00,265.00,0.00,7550.10,1910175.30,2005520.50,95345.20,497649),('1','141','168613','322',253.00,265.00,0.00,14915.70,3773672.10,3959088.50,185416.40,498512),('1','141','168778','322',253.00,265.00,0.00,0.00,0.00,0.00,0.00,498956),('1','141','168796','322',253.00,265.00,0.00,19571.00,4951463.00,5160756.00,209293.00,499000),('1','141','168931','322',253.00,280.00,0.00,4941.80,1250275.40,1386361.50,136086.10,499359),('1','141','169200','322',253.00,280.00,0.00,0.00,0.00,0.00,0.00,500045),('1','141','169205','322',253.00,280.00,0.00,23959.50,6061753.50,6713777.50,652024.00,500058),('1','141','169245','322',253.00,280.00,0.00,300.00,75900.00,84000.00,8100.00,500163),('1','141','169452','322',253.00,280.00,0.00,0.00,0.00,0.00,0.00,500687),('1','141','169453','322',253.00,0.00,0.00,14742.80,3729928.40,4131429.00,401500.60,500688),('1','141','169773','322',253.00,280.00,0.00,6419.30,1624082.90,1800136.50,176053.60,501536),('1','141','169776','322',253.00,286.00,0.00,3106.30,785893.90,889747.00,103853.10,501541),('1','141','169990','322',253.00,286.00,0.00,0.00,0.00,0.00,0.00,502111),('1','141','169999','322',253.00,286.00,0.00,12483.10,3158224.30,3574074.90,415850.60,502136),('1','141','170229','322',253.00,286.00,0.00,6501.20,1644803.60,1862187.50,217383.90,502732),('1','141','170332','322',253.00,286.00,0.00,5344.00,1352032.00,1531253.00,179221.00,503001),('1','141','170567','322',253.00,286.00,0.00,0.00,0.00,0.00,0.00,503619),('1','141','170587','322',253.00,286.00,0.00,6561.70,1660110.10,1879154.20,219044.10,503671),('1','141','170670','322',253.00,286.00,0.00,5668.20,1434054.60,1623037.50,188982.90,503886),('1','141','171000','322',253.00,286.00,0.00,8503.90,2151486.70,2436025.60,284538.90,504754),('1','141','171214','322',253.00,286.00,0.00,3787.80,958313.40,1085796.00,127482.60,505337),('1','141','171369','322',253.00,286.00,0.00,0.00,0.00,0.00,0.00,505739),('1','141','171374','322',253.00,286.00,0.00,10951.60,2770754.80,3137116.60,366361.80,505748),('1','141','171576','322',253.00,286.00,0.00,7532.60,1905747.80,2157796.80,252049.00,506304),('1','141','171760','322',253.00,286.00,0.00,6153.50,1556835.50,1762722.50,205887.00,506788),('1','141','171940','322',253.00,286.00,0.00,0.00,0.00,0.00,0.00,507264),('1','141','171942','322',253.00,286.00,0.00,7913.10,2002014.30,2266112.50,264098.20,507268),('1','141','172272','322',253.00,286.00,0.00,12209.50,3089003.50,3495589.70,406586.20,508141),('1','141','172483','322',253.00,286.00,0.00,4171.20,1055313.60,1195541.50,140227.90,508704),('1','141','172741','322',253.00,286.00,0.00,0.00,0.00,0.00,0.00,509374),('1','141','172751','322',253.00,286.00,0.00,10758.90,2722001.70,3079163.90,357162.20,509400),('1','141','172865','322',253.00,286.00,0.00,2252.90,569983.70,646324.40,76340.70,509710),('1','141','173047','322',253.00,286.00,0.00,7540.50,1907746.50,2159984.00,252237.50,510190),('1','141','173363','322',253.00,286.00,0.00,3840.30,971595.90,1102882.00,131286.10,511023),('1','141','173591','322',253.00,286.00,0.00,0.00,0.00,0.00,0.00,511637),('1','141','173595','322',253.00,286.00,0.00,18231.80,4612645.40,5218947.90,606302.50,511642),('1','141','173743','322',253.00,286.00,0.00,6167.90,1560478.70,1771134.90,210656.20,512045),('1','141','173941','322',253.00,286.00,0.00,0.00,0.00,0.00,0.00,512554),('1','141','174195','322',268.00,286.00,0.00,7959.90,2133253.20,2279886.80,146633.60,513226),('1','141','174221','322',268.00,286.00,0.00,7991.50,2141722.00,2290009.30,148287.30,513297),('1','141','174366','322',268.00,286.00,0.00,8483.90,2273685.20,2430345.50,156660.30,513673),('1','141','174491','322',268.00,286.00,0.00,0.00,0.00,0.00,0.00,513989),('1','141','174580','322',268.00,286.00,0.00,6163.80,1651898.40,1767501.80,115603.40,514219),('1','141','175006','322',268.00,286.00,0.00,12214.10,3273378.80,3497241.60,223862.80,515355),('1','141','175039','322',268.00,292.00,0.00,5843.00,1565924.00,1717723.60,151799.60,515424),('1','141','175043','322',268.00,292.00,0.00,0.00,0.00,0.00,0.00,515428),('1','141','175773','322',280.00,300.00,0.00,5149.80,1441944.00,1553500.80,111556.80,517347),('1','141','175779','322',280.00,300.00,0.00,7499.20,2099776.00,2259357.60,159581.60,517363),('1','141','175781','322',280.00,300.00,0.00,6537.90,1830612.00,1972173.60,141561.60,517367),('1','141','176288','322',280.00,300.00,0.00,4969.10,1391348.00,1499704.80,108356.80,518696),('1','141','176295','322',280.00,300.00,0.00,0.00,0.00,0.00,0.00,518709),('1','141','176309','322',280.00,300.00,0.00,9786.60,2740248.00,2944303.20,204055.20,518736),('1','141','176523','322',280.00,300.00,0.00,5044.70,1412516.00,1520653.20,108137.20,519294),('1','141','176751','322',280.00,300.00,0.00,6463.20,1809696.00,1947927.60,138231.60,519911),('1','141','176947','322',280.00,300.00,0.00,3225.40,903112.00,978074.40,74962.40,520436),('1','141','177280','322',280.00,300.00,0.00,0.00,0.00,0.00,0.00,521287),('1','141','177286','322',280.00,300.00,0.00,7583.10,2123268.00,2285380.80,162112.80,521302),('1','141','177730','322',280.00,300.00,0.00,9986.70,2796276.00,3004671.60,208395.60,522503),('1','141','177930','322',280.00,300.00,0.00,2091.10,585508.00,632085.60,46577.60,523022),('1','141','178162','322',280.00,300.00,0.00,0.00,0.00,0.00,0.00,523639),('1','141','178168','322',280.00,300.00,0.00,7312.30,2047444.00,2202542.40,155098.40,523652),('1','141','178304','322',280.00,0.00,0.00,4533.50,1269380.00,1368636.00,99256.00,523990),('1','141','178716','322',280.00,300.00,0.00,10430.80,2920624.00,3137214.00,216590.00,525080),('1','141','178720','322',280.00,310.00,0.00,2099.90,587972.00,653813.40,65841.40,525084),('1','141','178722','322',280.00,300.00,0.00,0.00,0.00,0.00,0.00,525086),('1','141','179284','322',280.00,310.00,0.00,4153.00,1162840.00,1287430.00,124590.00,526587),('1','141','179292','322',280.00,310.00,0.00,8443.80,2364264.00,2624600.60,260336.60,526608),('1','141','179442','322',280.00,310.00,0.00,4589.30,1285004.00,1426499.80,141495.80,526995),('1','141','179558','322',280.00,310.00,0.00,4818.40,1349152.00,1499616.40,150464.40,527307),('1','141','179798','322',280.00,310.00,0.00,2150.00,602000.00,670400.00,68400.00,527932),('1','141','179998','322',280.00,310.00,0.00,0.00,0.00,0.00,0.00,528456),('1','141','180000','322',280.00,310.00,0.00,5049.90,1413972.00,1573139.00,159167.00,528460),('1','141','180236','322',280.00,310.00,0.00,5215.80,1460424.00,1622732.40,162308.40,529086),('1','141','180566','322',280.00,310.00,0.00,13210.70,3698996.00,4099118.20,400122.20,529940),('1','141','180777','322',280.00,310.00,0.00,0.00,0.00,0.00,0.00,530491),('1','141','180846','322',298.00,310.00,0.00,13339.00,3975022.00,4142913.40,167891.40,530686),('1','141','180984','322',298.00,310.00,0.00,10011.50,2983427.00,3109922.00,126495.00,531051),('1','141','180988','322',298.00,310.00,0.00,0.00,0.00,0.00,0.00,531060),('1','141','181511','322',298.00,310.00,0.00,5492.00,1636616.00,1710151.00,73535.00,532465),('1','141','181512','322',298.00,310.00,0.00,9054.30,2698181.40,2810831.80,112650.40,532466),('1','141','182006','322',298.00,310.00,0.00,9564.00,2850072.00,2970432.60,120360.60,533779),('1','141','182237','322',298.00,310.00,0.00,12035.20,3586489.60,3736598.20,150108.60,534390),('1','141','182276','322',298.00,310.00,0.00,5652.10,1876111.80,1767883.60,-108228.20,534489),('1','141','182334','322',336.00,310.00,0.00,7403.69,2487639.84,2311853.84,-175786.00,534614),('1','141','182665','322',298.00,310.00,0.00,8456.20,2519947.60,2637456.20,117508.60,535521),('1','141','182845','322',298.00,310.00,0.00,11211.62,3341062.76,3489853.32,148790.56,536000),('1','141','182989','322',298.00,310.00,0.00,5226.00,1557348.00,1625928.20,68580.20,536394),('1','141','183065','322',298.00,310.00,0.00,0.00,0.00,0.00,0.00,536605),('1','141','183074','322',298.00,310.00,0.00,7603.76,2265920.48,2369925.36,104004.88,536630),('1','141','183242','322',298.00,310.00,0.00,13308.90,3966052.20,4142201.40,176149.20,537031),('1','141','183453','322',298.00,310.00,0.00,3750.80,1117738.40,1167006.80,49268.40,537575),('1','141','183689','322',298.00,310.00,0.00,15821.20,4714717.60,4921139.20,206421.60,538204),('1','141','183841','322',298.00,310.00,0.00,0.00,0.00,0.00,0.00,538624),('1','141','183945','322',298.00,320.00,0.00,4175.70,1244358.60,1338579.20,94220.60,538890),('1','141','184089','322',298.00,320.00,0.00,0.00,0.00,0.00,0.00,539279),('1','141','184095','322',307.00,320.00,0.00,12266.60,3765846.20,3933763.20,167917.00,539294),('1','141','184453','322',307.00,320.00,0.00,12348.60,3791020.20,3961046.40,170026.20,540227),('1','141','184780','322',307.00,320.00,0.00,0.00,0.00,0.00,0.00,541114),('1','141','184993','322',307.00,320.00,0.00,6525.30,2003267.10,2096622.40,93355.30,541679),('1','141','185195','322',307.00,320.00,0.00,6482.80,1990219.60,2080180.80,89961.20,542191),('1','141','185204','322',307.00,320.00,0.00,11475.60,3523009.20,3681025.60,158016.40,542214),('1','141','185595','322',307.00,320.00,0.00,0.00,0.00,0.00,0.00,543231),('1','141','185618','322',307.00,320.00,0.00,10503.00,3224421.00,3371497.60,147076.60,543294),('1','141','186030','322',307.00,320.00,0.00,12190.40,3742452.80,3910035.20,167582.40,544398),('1','141','186118','322',307.00,320.00,0.00,0.00,0.00,0.00,0.00,544613),('1','141','186158','322',307.00,320.00,0.00,8304.95,2549619.65,2668088.80,118469.15,544719),('1','141','186426','322',307.00,320.00,0.00,7803.39,2395640.73,2503979.04,108338.31,545432),('1','141','186614','322',307.00,336.00,0.00,6101.17,1873059.19,1958617.12,85557.93,545931),('1','141','186863','322',307.00,320.00,0.00,2522.30,774346.10,810156.80,35810.70,546579),('1','141','187097','322',307.00,336.00,0.00,0.00,0.00,0.00,0.00,547170),('1','141','187099','322',307.00,336.00,0.00,9049.80,2778288.60,2905644.80,127356.20,547174),('1','141','187364','322',307.00,336.00,0.00,10417.04,3198031.28,3343346.24,145314.96,547860),('1','141','187605','322',307.00,336.00,0.00,4377.99,1344042.93,1406388.64,62345.71,548494),('1','141','187849','322',307.00,320.00,0.00,0.00,0.00,0.00,0.00,549142),('1','141','187871','322',307.00,336.00,0.00,5478.18,1681801.26,1760052.48,78251.22,549202),('1','141','188039','322',307.00,320.00,0.00,7473.10,2294241.70,2399561.60,105319.90,549632),('1','141','188227','322',307.00,320.00,0.00,5479.75,1682283.25,1758940.00,76656.75,550124),('1','141','188444','322',307.00,320.00,0.00,0.00,0.00,0.00,0.00,550681),('1','141','188456','322',307.00,320.00,0.00,16169.23,4963953.61,5183512.48,219558.87,550711),('1','141','188813','322',307.00,320.00,0.00,9039.10,2775003.70,2899073.60,124069.90,551641),('1','141','189021','322',307.00,320.00,0.00,0.00,0.00,0.00,0.00,552190),('1','141','189024','322',307.00,320.00,0.00,18622.00,5716954.00,5970376.00,253422.00,552197),('1','141','189220','322',307.00,320.00,0.00,6192.94,1901232.58,1985755.84,84523.26,552704),('1','141','189438','322',307.00,320.00,0.00,0.00,0.00,0.00,0.00,553284),('1','141','189444','322',307.00,320.00,0.00,9381.39,2880086.73,3010601.44,130514.71,553296),('1','141','189644','322',307.00,320.00,0.00,7720.23,2370110.61,2478509.28,108398.67,553810),('1','141','189828','322',307.00,320.00,0.00,5803.69,1781732.83,1867710.24,85977.41,554279),('1','141','190143','322',307.00,320.00,0.00,1730.70,531324.90,556715.20,25390.30,555121),('1','141','190154','322',307.00,320.00,0.00,0.00,0.00,0.00,0.00,555151),('1','141','190238','322',307.00,320.00,0.00,9550.64,2932046.48,3065183.04,133136.56,555359),('1','141','190450','322',307.00,320.00,0.00,7739.18,2375928.26,2485116.48,109188.22,555911),('1','141','190675','322',307.00,320.00,0.00,7554.06,2319096.42,2425096.96,106000.54,556514),('1','141','190911','322',307.00,320.00,0.00,0.00,0.00,0.00,0.00,557129),('1','141','190919','322',307.00,320.00,0.00,5905.17,1812887.19,1898150.72,85263.53,557151),('1','141','191071','322',307.00,320.00,0.00,5479.76,1682286.32,1758931.20,76644.88,557561),('1','141','191074','322',307.00,320.00,0.00,6192.95,1901235.65,1985753.60,84517.95,557566),('1','141','191077','322',307.00,320.00,0.00,5735.43,1760777.01,1843424.48,82647.47,557569),('1','141','191752','322',307.00,320.00,0.00,0.00,0.00,0.00,0.00,559350),('1','141','191959','322',307.00,320.00,0.00,0.00,0.00,0.00,0.00,559907),('1','141','191966','322',307.00,320.00,0.00,0.00,0.00,0.00,0.00,559924),('1','141','191973','322',307.00,320.00,0.00,14711.98,4516577.86,4716322.88,199745.02,559943),('1','141','192145','322',307.00,320.00,0.00,7241.40,2223109.80,2325550.40,102440.60,560398),('1','141','192361','322',307.00,320.00,0.00,0.00,0.00,0.00,0.00,560964),('1','141','192369','322',307.00,320.00,0.00,2790.53,856692.71,895002.08,38309.37,560984),('1','141','192609','322',307.00,320.00,0.00,0.00,0.00,0.00,0.00,561614),('1','141','192651','322',303.00,320.00,0.00,6247.20,1892901.60,2005515.20,112613.60,561726),('1','141','192792','322',303.00,320.00,0.00,4762.21,1442949.63,1531888.96,88939.33,562080),('1','141','193187','322',303.00,320.00,0.00,9356.04,2834880.12,3003573.44,168693.32,563129),('1','141','193428','322',303.00,320.00,0.00,4380.27,1327221.81,1403138.72,75916.91,563758),('1','141','193635','322',303.00,320.00,0.00,0.00,0.00,0.00,0.00,564302),('1','141','193639','322',303.00,320.00,0.00,9432.71,2858111.13,3027820.96,169709.83,564310),('1','141','193903','322',303.00,336.00,0.00,6717.94,2035535.82,2124558.24,89022.42,564965),('1','141','194101','322',303.00,315.00,0.00,6181.06,1872861.18,1958192.46,85331.28,565459),('1','141','194315','322',303.00,315.00,0.00,2303.51,697963.53,730267.86,32304.33,566025),('1','141','194426','322',303.00,315.00,0.00,0.00,0.00,0.00,0.00,566314),('1','141','194429','322',303.00,315.00,0.00,3362.20,1018746.60,1064036.40,45289.80,566319),('1','141','194713','322',303.00,315.00,0.00,12725.15,3855720.45,4021151.40,165430.95,567034),('1','141','194885','322',303.00,315.00,0.00,8674.79,2628461.37,2746172.94,117711.57,567502),('1','141','195119','322',303.00,315.00,0.00,0.00,0.00,0.00,0.00,568103),('1','141','195131','322',303.00,315.00,0.00,7428.28,2250768.84,2351457.78,100688.94,568136),('1','141','195317','322',303.00,315.00,0.00,6490.90,1966742.70,2056370.40,89627.70,568610),('1','141','195554','322',303.00,315.00,0.00,6895.77,2089418.31,2184932.82,95514.51,569213),('1','141','195811','322',303.00,315.00,0.00,3959.04,1199589.12,1253639.94,54050.82,569858),('1','141','196249','322',303.00,315.00,0.00,0.00,0.00,0.00,0.00,570964),('1','141','196253','322',303.00,315.00,0.00,12264.68,3716198.04,3878857.08,162659.04,570972),('1','141','196479','322',303.00,315.00,0.00,10049.26,3044925.78,3180648.66,135722.88,571560),('1','141','196684','322',303.00,315.00,0.00,2394.10,725412.30,758312.10,32899.80,572082),('1','141','197042','322',303.00,315.00,0.00,0.00,0.00,0.00,0.00,573019),('1','141','197097','322',303.00,315.00,0.00,9491.22,2875839.66,3003542.22,127702.56,573164),('1','141','197722','322',303.00,315.00,0.00,7595.20,2301345.60,2405669.70,104324.10,574708),('1','141','197799','322',303.00,315.00,0.00,7582.50,2297497.50,2399806.50,102309.00,574929),('1','141','197913','322',303.00,315.00,0.00,0.00,0.00,0.00,0.00,575222),('1','141','197937','322',294.00,315.00,0.00,6843.91,2012109.54,2168650.26,156540.72,575285),('1','141','198134','322',294.00,315.00,0.00,3827.10,1125167.40,1218180.60,93013.20,575787),('1','141','198375','322',294.00,308.00,0.00,5540.94,1629036.36,1721125.84,92089.48,576407),('1','141','198589','322',294.00,308.00,0.00,6114.97,1797801.18,1900915.52,103114.34,576971),('1','141','198815','322',294.00,308.00,0.00,2372.63,697553.22,738949.68,41396.46,577519),('1','141','199245','322',294.00,308.00,0.00,0.00,0.00,0.00,0.00,578626),('1','141','199250','322',294.00,305.00,0.00,12706.76,3735787.44,3896116.66,160329.22,578637),('1','141','199462','322',294.00,305.00,0.00,5514.24,1621186.56,1695599.14,74412.58,579155),('1','141','199683','322',294.00,305.00,0.00,4782.18,1405960.92,1478611.98,72651.06,579694),('1','141','199885','322',294.00,305.00,0.00,1810.13,532178.22,556433.68,24255.46,580196),('1','141','200116','322',294.00,305.00,0.00,0.00,0.00,0.00,0.00,580802),('1','141','200121','322',291.00,305.00,0.00,9562.96,2782821.36,2933289.66,150468.30,580815),('1','141','200318','322',291.00,305.00,0.00,5261.75,1531169.25,1625304.60,94135.35,581331),('1','141','200720','322',291.00,336.00,0.00,10057.16,2926633.56,3084575.56,157942.00,582380),('1','141','200944','322',291.00,336.00,0.00,0.00,0.00,0.00,0.00,582938),('1','141','200958','322',291.00,305.00,0.00,7914.81,2303209.71,2434334.76,131125.05,582972),('1','141','201142','322',291.00,336.00,0.00,7597.74,2210942.34,2337235.64,126293.30,583443),('1','141','201333','322',291.00,336.00,0.00,7987.30,2324304.30,2456037.80,131733.50,583941),('1','141','201524','322',291.00,305.00,0.00,1130.50,328975.50,347096.50,18121.00,584437),('1','141','201695','322',291.00,305.00,0.00,0.00,0.00,0.00,0.00,584921),('1','141','201703','322',290.00,305.00,0.00,10419.40,3021626.00,3196743.30,175117.30,584938),('1','141','201774','322',290.00,336.00,0.00,10140.97,2940881.30,3112493.92,171612.62,585108),('1','141','202239','322',290.00,305.00,0.00,3080.50,893345.00,945737.00,52392.00,586321),('1','141','202244','322',290.00,305.00,0.00,0.00,0.00,0.00,0.00,586333),('1','141','202256','322',300.00,320.00,0.00,0.00,0.00,0.00,0.00,586363),('1','141','202261','322',300.00,336.00,0.00,11604.30,3481290.00,3724380.80,243090.80,586373),('1','141','202453','322',300.00,336.00,0.00,10503.20,3150960.00,3370955.20,219995.20,586865),('1','141','202672','322',300.00,336.00,0.00,2481.30,744390.00,796156.80,51766.80,587426),('1','141','202811','322',300.00,336.00,0.00,0.00,0.00,0.00,0.00,587798),('1','141','202890','322',300.00,336.00,0.00,16343.50,4903050.00,5240400.00,337350.00,587982),('1','141','203129','322',300.00,336.00,0.00,8090.30,2427090.00,2597316.80,170226.80,588606),('1','141','203378','322',300.00,336.00,0.00,0.00,0.00,0.00,0.00,589274),('1','141','203383','322',300.00,336.00,0.00,6816.30,2044890.00,2190588.80,145698.80,589284),('1','141','203749','322',300.00,336.00,0.00,13430.00,4029000.00,4308561.60,279561.60,590206),('1','141','203989','322',300.00,336.00,0.00,4468.80,1340640.00,1434284.80,93644.80,590822),('1','141','204211','322',300.00,336.00,0.00,0.00,0.00,0.00,0.00,591407),('1','141','204222','322',304.00,336.00,0.00,11729.40,3565737.60,3763136.00,197398.40,591435),('1','141','204433','322',304.00,336.00,0.00,12884.30,3916827.20,4130708.80,213881.60,591984),('1','141','204643','322',304.00,336.00,0.00,0.00,0.00,0.00,0.00,592515),('1','141','204651','322',304.00,360.00,0.00,3165.54,974986.32,1048564.00,73577.68,592534),('1','141','204867','322',308.00,360.00,0.00,8384.68,2582481.44,2776136.80,193655.36,593058),('1','141','205270','322',308.00,360.00,0.00,13125.91,4042780.28,4328655.60,285875.32,594105),('1','141','205499','322',308.00,360.00,0.00,0.00,0.00,0.00,0.00,594685),('1','141','205501','322',308.00,360.00,0.00,10265.38,3161737.04,3364778.00,203040.96,594687),('1','141','205743','322',308.00,360.00,0.00,5822.53,1793339.24,1914554.20,121214.96,595326),('1','141','205981','322',308.00,360.00,0.00,6185.07,1905001.56,2033998.20,128996.64,595939),('1','141','206175','322',308.00,360.00,0.00,2397.90,738553.20,787050.00,48496.80,596432),('1','141','206244','322',308.00,360.00,0.00,0.00,0.00,0.00,0.00,596618),('1','141','206247','322',308.00,360.00,0.00,3830.11,1179673.88,1261016.00,81342.12,596625),('1','141','206382','322',308.00,360.00,0.00,6963.08,2144628.64,2291655.40,147026.76,596961),('1','141','206851','322',308.00,360.00,0.00,11215.63,3454414.04,3674568.00,220153.96,598162),('1','141','207054','322',308.00,360.00,0.00,1695.20,522121.60,557062.00,34940.40,598688),('1','141','207119','322',308.00,360.00,0.00,0.00,0.00,0.00,0.00,598865),('1','141','207127','322',308.00,360.00,0.00,9994.95,3078444.60,3274260.60,195816.00,598887),('1','141','207294','322',308.00,360.00,0.00,14049.80,4327338.40,4601025.80,273687.40,599317),('1','141','207639','322',308.00,360.00,0.00,0.00,0.00,0.00,0.00,600211),('1','141','207642','322',325.00,384.00,0.00,3312.40,1076530.00,1111691.00,35161.00,600218),('1','141','207727','322',325.00,384.00,0.00,10011.76,3253822.00,3426278.24,172456.24,600412),('1','141','207932','322',325.00,384.00,0.00,9106.20,2959515.00,3128681.20,169166.20,600941),('1','141','208375','322',325.00,384.00,0.00,2245.00,729625.00,766358.00,36733.00,602082),('1','141','208391','322',325.00,384.00,0.00,0.00,0.00,0.00,0.00,602124),('1','141','208405','322',325.00,384.00,0.00,18576.69,6037424.25,6349456.96,312032.71,602163),('1','141','208552','322',325.00,384.00,0.00,6112.57,1986585.25,2087318.88,100733.63,602538),('1','141','208793','322',325.00,384.00,0.00,0.00,0.00,0.00,0.00,603142),('1','141','208798','322',340.00,384.00,0.00,12373.72,4207064.80,4351943.88,144879.08,603151),('1','141','209023','322',340.00,384.00,0.00,10779.11,3664897.40,3790134.24,125236.84,603722),('1','141','209230','322',340.00,384.00,0.00,1555.08,528727.20,549839.72,21112.52,604264),('1','141','209308','322',340.00,384.00,0.00,0.00,0.00,0.00,0.00,604457),('1','141','209314','322',340.00,384.00,0.00,3656.16,1243094.40,1300554.44,57460.04,604472),('1','141','209459','322',340.00,384.00,0.00,7408.02,2518726.80,2619565.68,100838.88,604838),('1','141','209884','322',340.00,400.00,0.00,11456.95,3895363.00,4161232.00,265869.00,605937),('1','141','210120','322',340.00,400.00,0.00,2180.50,741370.00,799210.00,57840.00,606552),('1','141','210340','322',340.00,400.00,0.00,0.00,0.00,0.00,0.00,607117),('1','141','210346','322',351.00,400.00,0.00,16111.73,5655217.23,5889438.80,234221.57,607130),('1','141','210502','322',351.00,400.00,0.00,8501.00,2983851.00,3115067.60,131216.60,607563),('1','141','210711','322',351.00,400.00,0.00,0.00,0.00,0.00,0.00,608117),('1','141','210746','322',351.00,400.00,0.00,10742.45,3770599.95,3929150.00,158550.05,608194),('1','141','210983','322',351.00,400.00,0.00,13863.43,4866063.93,5062618.84,196554.91,608792),('1','141','211102','322',351.00,400.00,0.00,0.00,0.00,0.00,0.00,609115),('1','141','211414','322',364.00,420.00,0.00,10383.07,3779437.48,3961578.10,182140.62,609918),('1','141','211746','322',364.00,420.00,0.00,3858.80,1404603.20,1470697.50,66094.30,610779),('1','141','211805','322',364.00,420.00,0.00,10341.79,3764411.56,3944815.80,180404.24,610914),('1','141','212341','322',364.00,420.00,0.00,0.00,0.00,0.00,0.00,612329),('1','141','212351','322',364.00,420.00,0.00,9089.88,3308716.32,3457269.40,148553.08,612352),('1','141','212497','322',364.00,420.00,0.00,12042.50,4383470.00,4589388.10,205918.10,612733),('1','141','212886','322',364.00,420.00,0.00,3478.50,1266174.00,1325055.00,58881.00,613753),('1','141','213056','322',364.00,420.00,0.00,0.00,0.00,0.00,0.00,614208),('1','141','213137','322',364.00,420.00,0.00,21245.71,7733438.44,8083870.80,350432.36,614412),('1','141','213394','322',364.00,420.00,0.00,3358.25,1222403.00,1279101.00,56698.00,615072),('1','141','213574','322',364.00,420.00,0.00,0.00,0.00,0.00,0.00,615565),('1','141','213653','322',364.00,420.00,0.00,9796.41,3565893.24,3739621.00,173727.76,615757),('1','141','213901','322',364.00,420.00,0.00,8457.74,3078617.36,3228022.80,149405.44,616409),('1','141','214106','322',364.00,420.00,0.00,6341.91,2308455.24,2418278.70,109823.46,616940),('1','141','214609','322',364.00,420.00,0.00,0.00,0.00,0.00,0.00,618249),('1','141','214615','322',364.00,420.00,0.00,13912.89,5064291.96,5298974.80,234682.84,618262),('1','141','214791','322',364.00,420.00,0.00,9178.75,3341065.00,3500015.00,158950.00,618718),('1','141','214968','322',364.00,420.00,0.00,0.00,0.00,0.00,0.00,619197),('1','141','215053','322',364.00,420.00,0.00,7725.97,2812253.08,2951536.00,139282.92,619409),('1','141','215294','322',364.00,420.00,0.00,7586.53,2761496.92,2895980.60,134483.68,620028),('1','141','215521','322',364.00,420.00,0.00,7039.42,2562348.88,2690896.90,128548.02,620605),('1','141','215761','322',364.00,420.00,0.00,2125.00,773500.00,812345.00,38845.00,621227),('1','141','215814','322',364.00,420.00,0.00,0.00,0.00,0.00,0.00,621366),('1','141','215822','322',364.00,420.00,0.00,7326.47,2666835.08,2796615.90,129780.82,621384),('1','141','216135','322',364.00,420.00,0.00,9207.10,3351384.40,3497961.50,146577.10,622182),('1','141','216201','322',364.00,440.00,0.00,6201.65,2257400.60,2494006.00,236605.40,622364),('1','141','216357','322',364.00,440.00,0.00,1867.80,679879.20,754972.00,75092.80,622760),('1','141','216582','322',364.00,440.00,0.00,0.00,0.00,0.00,0.00,623359),('1','141','216590','322',384.00,440.00,0.00,10440.64,4009205.76,4201881.60,192675.84,623380),('1','141','216823','322',384.00,440.00,0.00,11022.76,4232739.84,4435970.40,203230.56,623992),('1','141','217081','322',384.00,440.00,0.00,3149.80,1209523.20,1268800.00,59276.80,624672),('1','141','217735','322',410.00,466.00,0.00,0.00,0.00,0.00,0.00,626378),('1','141','217737','322',410.00,466.00,0.00,12961.90,5314379.00,5546769.40,232390.40,626380),('1','141','217989','322',410.00,466.00,0.00,4684.70,1920727.00,2023650.20,102923.20,627054),('1','141','218244','322',410.00,466.00,0.00,4122.00,1690020.00,1779988.00,89968.00,627717),('1','141','218455','322',410.00,466.00,0.00,2655.60,1088796.00,1139669.60,50873.60,628276),('1','141','218659','322',410.00,466.00,0.00,0.00,0.00,0.00,0.00,628821),('1','141','218689','322',410.00,466.00,0.00,11177.66,4582840.60,4786841.56,204000.96,628882),('1','141','218962','322',410.00,466.00,0.00,6837.52,2803383.20,2937996.32,134613.12,629597),('1','141','219418','322',410.00,466.00,0.00,6592.26,2702826.60,2822765.16,119938.56,630786),('1','141','219553','322',410.00,466.00,0.00,0.00,0.00,0.00,0.00,631158),('1','141','219671','322',410.00,466.00,0.00,7107.84,2914214.40,3046781.44,132567.04,631456),('1','141','219819','322',410.00,466.00,0.00,7036.08,2884792.80,3022737.28,137944.48,631837),('1','141','220050','322',410.00,466.00,0.00,7073.96,2900323.60,3038329.36,138005.76,632460),('1','141','220265','322',410.00,466.00,0.00,3117.60,1278216.00,1333673.60,55457.60,633026),('1','141','220563','322',410.00,466.00,0.00,0.00,0.00,0.00,0.00,633817),('1','141','220565','322',410.00,466.00,0.00,8159.16,3345255.60,3501192.56,155936.96,633821),('1','141','220946','322',410.00,466.00,0.00,10748.82,4407016.20,4604066.12,197049.92,634799),('1','141','221178','322',410.00,466.00,0.00,5695.24,2335048.40,2369641.84,34593.44,635394),('1','141','221338','322',410.00,466.00,0.00,0.00,0.00,0.00,0.00,635836),('1','141','221343','322',410.00,466.00,0.00,0.00,0.00,0.00,0.00,635846),('1','141','221432','322',395.00,466.00,0.00,6302.63,2489538.85,2618939.98,129401.13,636063),('1','141','221711','322',395.00,466.00,0.00,7807.45,3083942.75,3236387.70,152444.95,636803),('1','141','221866','322',395.00,466.00,0.00,7328.33,2894690.35,3039163.38,144473.03,637190),('1','141','222094','322',395.00,466.00,0.00,3172.84,1253271.80,1314575.44,61303.64,637789),('1','141','222205','322',395.00,466.00,0.00,0.00,0.00,0.00,0.00,638080),('1','141','222486','322',414.00,466.00,0.00,17032.71,7051541.94,7348318.86,296776.92,638798),('1','141','222766','322',414.00,466.00,0.00,7572.40,3134973.60,3269322.40,134348.80,639531),('1','141','223149','322',414.00,466.00,0.00,0.00,0.00,0.00,0.00,640565),('1','141','223153','322',414.00,466.00,0.00,8029.50,3324213.00,3474364.20,150151.20,640573),('1','141','223195','322',414.00,466.00,0.00,5312.73,2199470.22,2372412.70,172942.48,640651),('1','141','223442','322',414.00,480.00,0.00,6473.56,2680053.84,2897752.80,217698.96,641259),('1','141','223664','322',414.00,480.00,0.00,4786.90,1981776.60,2138584.80,156808.20,641828),('1','141','224104','322',414.00,480.00,0.00,0.00,0.00,0.00,0.00,642970),('1','141','224108','322',428.00,480.00,0.00,15126.28,6474047.84,6739060.80,265012.96,642980),('1','141','224377','322',428.00,510.00,0.00,6004.61,2569973.08,2900847.30,330874.22,643678),('1','141','224548','322',428.00,510.00,0.00,3475.66,1487582.48,1680888.90,193306.42,644133),('1','141','224797','322',428.00,510.00,0.00,0.00,0.00,0.00,0.00,644759),('1','141','224799','322',465.00,510.00,0.00,3249.03,1510798.95,1578825.30,68026.35,644761),('1','141','225050','322',465.00,510.00,0.00,5656.64,2630337.60,2732910.30,102572.70,645410),('1','141','225280','322',465.00,510.00,0.00,5210.89,2423063.85,2533794.90,110731.05,646005),('1','141','225723','322',465.00,510.00,0.00,4989.84,2320275.60,2413748.40,93472.80,647157),('1','141','225993','322',465.00,510.00,0.00,5517.19,2565493.35,2657673.90,92180.55,647868),('1','141','226273','322',465.00,510.00,0.00,0.00,0.00,0.00,0.00,648599),('1','141','226284','322',465.00,510.00,0.00,9249.92,4301212.80,4372827.20,71614.40,648622),('1','141','226495','322',465.00,510.00,0.00,8281.53,3850911.45,3917984.30,67072.85,649148),('1','141','226764','322',465.00,510.00,0.00,7098.91,3300993.15,3361908.10,60914.95,649849),('1','141','227148','322',465.00,510.00,0.00,0.00,0.00,0.00,0.00,650873),('1','141','227154','322',465.00,510.00,0.00,2125.90,988543.50,1002465.00,13921.50,650886),('1','141','227359','322',465.00,510.00,0.00,14348.52,6672061.80,6769185.20,97123.40,651411),('1','141','227628','322',465.00,510.00,0.00,8173.30,3800584.50,3866787.00,66202.50,652085),('1','141','227870','322',465.00,510.00,0.00,0.00,0.00,0.00,0.00,652718),('1','141','227873','322',470.00,530.00,0.00,5630.86,2646504.20,2807252.30,160748.10,652725),('1','141','228142','322',470.00,530.00,0.00,8777.11,4125241.70,4364682.80,239441.10,653439),('1','141','228389','322',470.00,530.00,0.00,7150.56,3360763.20,3545339.30,184576.10,654077),('1','141','228580','322',470.00,530.00,0.00,0.00,0.00,0.00,0.00,654562),('1','141','228588','322',470.00,540.00,0.00,5887.30,2767031.00,2988990.00,221959.00,654581),('1','141','228925','322',470.00,540.00,0.00,10194.34,4791339.80,5157705.60,366365.80,655453),('1','141','229187','322',470.00,540.00,0.00,5477.76,2574547.20,2779077.60,204530.40,656129),('1','141','229449','322',470.00,540.00,0.00,3095.30,1454791.00,1567674.00,112883.00,656803),('1','141','229687','322',470.00,540.00,0.00,0.00,0.00,0.00,0.00,657411),('1','141','229694','322',502.00,568.00,0.00,11928.14,5987926.28,6243815.62,255889.34,657428),('1','141','229946','322',502.00,568.00,0.00,6686.38,3356562.76,3505221.63,148658.87,658079),('1','141','230111','322',502.00,568.00,0.00,6014.40,3019228.80,3140101.20,120872.40,658499),('1','141','230462','322',502.00,568.00,0.00,0.00,0.00,0.00,0.00,659431),('1','141','230466','322',502.00,568.00,0.00,6464.50,3245179.00,3386019.60,140840.60,659439),('1','141','230543','322',502.00,568.00,0.00,10954.35,5499083.70,5736405.70,237322.00,659616),('1','141','230800','322',502.00,568.00,0.00,7229.87,3629394.74,3778103.37,148708.63,660279),('1','141','231455','322',502.00,568.00,0.00,0.00,0.00,0.00,0.00,662033),('1','141','231463','322',514.00,568.00,0.00,10361.22,5325667.08,5511739.36,186072.28,662055),('1','141','231664','322',514.00,568.00,0.00,14301.81,7351130.34,7603800.88,252670.54,662576),('1','141','231903','322',514.00,568.00,0.00,0.00,0.00,0.00,0.00,663235),('1','141','231908','322',514.00,568.00,0.00,9804.70,5039615.80,5226720.00,187104.20,663244),('1','141','232152','322',514.00,568.00,0.00,4182.90,2150010.60,2224841.00,74830.40,663883),('1','141','232355','322',514.00,568.00,0.00,10702.09,5500874.26,5690332.12,189457.86,664407),('1','141','232613','322',514.00,568.00,0.00,0.00,0.00,0.00,0.00,665090),('1','141','232617','322',514.00,568.00,0.00,8711.28,4477597.92,4646085.64,168487.72,665099),('1','141','232873','322',514.00,568.00,0.00,8753.06,4499072.84,4671287.28,172214.44,665779),('1','141','233424','322',514.00,568.00,0.00,7171.00,3685894.00,3824760.00,138866.00,667220),('1','141','233437','322',514.00,568.00,0.00,0.00,0.00,0.00,0.00,667256),('1','141','233448','322',550.00,600.00,0.00,2568.50,1412675.00,1471020.00,58345.00,667288),('1','141','233631','322',550.00,600.00,0.00,6753.91,3714650.50,3867018.00,152367.50,667761),('1','141','233981','322',550.00,600.00,0.00,4644.00,2554200.00,2656044.00,101844.00,668696),('1','141','234084','322',550.00,600.00,0.00,10768.81,5922845.50,6143610.60,220765.10,668955),('1','141','234494','322',550.00,600.00,0.00,0.00,0.00,0.00,0.00,670062),('1','141','234643','322',550.00,600.00,0.00,9937.81,5465795.50,5682825.90,217030.40,670441),('1','141','234860','322',550.00,600.00,0.00,9003.05,4951677.50,5147634.00,195956.50,671010),('1','141','235111','322',550.00,600.00,0.00,5735.05,3154277.50,3282102.90,127825.40,671692),('1','141','235348','322',550.00,600.00,0.00,0.00,0.00,0.00,0.00,672304),('1','141','235352','322',550.00,600.00,0.00,7808.78,4294829.00,4469952.00,175123.00,672314),('1','141','235812','322',550.00,600.00,0.00,16847.10,9265905.00,9610080.00,344175.00,673501),('1','141','236076','322',550.00,600.00,0.00,0.00,0.00,0.00,0.00,674198),('1','141','236078','322',550.00,600.00,0.00,9785.80,5382190.00,5597640.00,215450.00,674202),('1','141','236261','322',550.00,600.00,0.00,7021.70,3861935.00,4016613.00,154678.00,674682),('1','141','236540','322',550.00,600.00,0.00,7827.10,4304905.00,4477737.00,172832.00,675419),('1','141','236785','322',550.00,600.00,0.00,0.00,0.00,0.00,0.00,676052),('1','141','236808','322',575.00,630.00,0.00,5887.50,3385312.50,3482385.00,97072.50,676116),('1','141','236995','322',575.00,630.00,0.00,8095.80,4655085.00,4799518.00,144433.00,676593),('1','141','237239','322',575.00,630.00,0.00,10692.30,6148072.50,6317637.00,169564.50,677226),('1','141','237624','322',575.00,630.00,0.00,0.00,0.00,0.00,0.00,678229),('1','141','237630','322',575.00,630.00,0.00,17471.20,10045940.00,10343736.00,297796.00,678240),('1','141','237947','322',575.00,630.00,0.00,7193.80,4136435.00,4263082.00,126647.00,679066),('1','141','238162','322',575.00,630.00,0.00,0.00,0.00,0.00,0.00,679620),('1','141','238170','322',575.00,630.00,0.00,9198.70,5289252.50,5449181.00,159928.50,679637),('1','141','238386','322',575.00,630.00,0.00,15424.48,8869076.00,9136741.60,267665.60,680191),('1','141','238641','322',575.00,630.00,0.00,0.00,0.00,0.00,0.00,680865),('1','141','238646','322',575.00,630.00,0.00,13880.30,7981172.50,8207869.00,226696.50,680876),('1','141','238873','322',575.00,630.00,0.00,10868.30,6249272.50,6435757.00,186484.50,681463),('1','141','239050','322',575.00,630.00,0.00,0.00,0.00,0.00,0.00,681935),('1','141','239053','322',603.00,650.00,0.00,12809.80,7724309.40,7959005.30,234695.90,681940),('1','141','239471','322',603.00,650.00,0.00,9730.80,5867672.40,6053274.00,185601.60,683034),('1','141','239533','322',603.00,650.00,0.00,2123.40,1280410.20,1323102.00,42691.80,683187),('1','141','239815','322',603.00,650.00,0.00,0.00,0.00,0.00,0.00,683918),('1','141','239823','322',603.00,650.00,0.00,13000.40,7839241.20,8093716.00,254474.80,683939),('1','141','239994','322',603.00,650.00,0.00,6658.70,4015196.10,4145377.00,130180.90,684384),('1','141','240243','322',603.00,650.00,0.00,4985.00,3005955.00,3101290.00,95335.00,685018),('1','141','240772','322',603.00,650.00,0.00,0.00,0.00,0.00,0.00,686356),('1','141','240775','322',603.00,650.00,0.00,8128.08,4901232.24,5062624.50,161392.26,686364),('1','141','240999','322',603.00,650.00,0.00,6152.80,3710138.40,3839225.00,129086.60,686966),('1','141','241272','322',603.00,650.00,0.00,10275.00,6195825.00,6371415.00,175590.00,687678),('1','141','241801','322',603.00,650.00,0.00,0.00,0.00,0.00,0.00,689093),('1','141','241803','322',582.00,650.00,0.00,8437.60,4910683.20,5045870.00,135186.80,689095),('1','141','242175','322',582.00,650.00,0.00,8075.00,4699650.00,4841145.00,141495.00,690075),('1','141','242501','322',582.00,650.00,0.00,7951.50,4627773.00,4745316.00,117543.00,690894),('1','141','242840','322',582.00,650.00,0.00,0.00,0.00,0.00,0.00,691798),('1','141','242843','322',582.00,650.00,0.00,12320.10,7170298.20,7363041.50,192743.30,691805),('1','141','243038','322',582.00,650.00,0.00,6376.90,3711355.80,3826947.50,115591.70,692308),('1','141','243138','322',582.00,650.00,0.00,5955.30,3465984.60,3555129.50,89144.90,692572),('1','141','243413','322',582.00,650.00,0.00,0.00,0.00,0.00,0.00,693285),('1','141','243419','322',568.00,650.00,0.00,5290.80,3005174.40,3114339.00,109164.60,693300),('1','141','243643','322',568.00,650.00,0.00,5173.60,2938604.80,3060580.00,121975.20,693871),('1','141','243857','322',568.00,650.00,0.00,1264.00,717952.00,749969.00,32017.00,694432),('1','141','244128','322',568.00,650.00,0.00,1120.80,636614.40,654838.00,18223.60,695125),('1','141','244146','322',568.00,650.00,0.00,0.00,0.00,0.00,0.00,695175),('1','141','244153','322',568.00,650.00,0.00,6192.40,3517283.20,3640508.00,123224.80,695189),('1','141','244506','322',568.00,650.00,0.00,6755.10,3836896.80,3963717.00,126820.20,696127),('1','141','244784','322',568.00,650.00,0.00,6661.10,3783504.80,3898249.00,114744.20,696839),('1','141','244973','322',568.00,650.00,0.00,4992.90,2835967.20,2912220.00,76252.80,697342),('1','141','244980','322',568.00,650.00,0.00,0.00,0.00,0.00,0.00,697355),('1','141','245033','322',548.00,650.00,0.00,6663.40,3651543.20,3823522.00,171978.80,697475),('1','141','245523','322',548.00,650.00,0.00,7443.90,4079257.20,4275971.00,196713.80,698744),('1','141','245660','322',548.00,650.00,0.00,2570.20,1408469.60,1454492.00,46022.40,699125),('1','141','245724','322',548.00,650.00,0.00,5724.83,3137206.84,3285412.50,148205.66,699258),('1','141','245927','322',528.00,640.00,0.00,2226.85,1175776.80,1225463.60,49686.80,699812),('1','141','246234','322',528.00,640.00,0.00,0.00,0.00,0.00,0.00,700582),('1','141','246244','322',528.00,640.00,0.00,11207.34,5917475.52,6194777.10,277301.58,700608),('1','141','246448','322',528.00,640.00,0.00,6256.88,3303632.64,3469990.20,166357.56,701168),('1','141','246754','322',528.00,640.00,0.00,7405.82,3910272.96,4074746.65,164473.69,701953),('1','141','246982','322',528.00,640.00,0.00,0.00,0.00,0.00,0.00,702536),('1','141','246985','322',528.00,640.00,0.00,8215.58,4337826.24,4550572.70,212746.46,702543),('1','141','247230','322',516.00,600.00,0.00,5033.00,2597028.00,2715275.00,118247.00,703186),('1','141','247425','322',516.00,600.00,0.00,7728.67,3987993.72,4167941.00,179947.28,703671),('1','141','247708','322',516.00,600.00,0.00,0.00,0.00,0.00,0.00,704420),('1','141','247713','322',516.00,600.00,0.00,8947.56,4616940.96,4832611.00,215670.04,704433),('1','141','247956','322',516.00,600.00,0.00,7641.47,3942998.52,4137981.00,194982.48,705047),('1','141','248203','322',516.00,600.00,0.00,8042.62,4149991.92,4351364.50,201372.58,705697),('1','141','248384','322',516.00,600.00,0.00,0.00,0.00,0.00,0.00,706189),('1','141','248462','322',516.00,600.00,0.00,13651.40,7044122.40,7355648.50,311526.10,706355),('1','141','248680','322',516.00,600.00,0.00,10981.80,5666608.80,5890102.50,223493.70,706914),('1','141','249108','322',516.00,600.00,0.00,0.00,0.00,0.00,0.00,708033),('1','141','249109','322',516.00,600.00,0.00,0.00,0.00,0.00,0.00,708034),('1','141','249117','322',507.00,600.00,0.00,16785.00,8509995.00,8762400.00,252405.00,708046),('1','141','249381','322',507.00,600.00,0.00,7801.30,3955259.10,4089726.40,134467.30,708709),('1','141','249614','322',507.00,600.00,0.00,0.00,0.00,0.00,0.00,709314),('1','141','249620','322',507.00,600.00,0.00,0.00,0.00,0.00,0.00,709325),('1','141','249630','322',507.00,600.00,0.00,7603.20,3854822.40,4001904.00,147081.60,709348),('1','141','249926','322',507.00,600.00,0.00,12970.90,6576246.30,6792628.00,216381.70,710114),('1','141','250154','322',507.00,600.00,0.00,4031.40,2043919.80,2126880.00,82960.20,710693),('1','141','250373','322',507.00,600.00,0.00,0.00,0.00,0.00,0.00,711246),('1','141','250379','322',507.00,600.00,0.00,6628.12,3360456.84,3477496.00,117039.16,711262),('1','141','250623','322',507.00,600.00,0.00,1541.47,781525.29,817554.00,36028.71,711889),('1','141','250858','322',507.00,600.00,0.00,9167.27,4647805.89,4799162.00,151356.11,712498),('1','141','251055','322',507.00,600.00,0.00,7342.52,3722657.64,3837064.00,114406.36,713012),('1','141','251374','322',507.00,600.00,0.00,0.00,0.00,0.00,0.00,713847),('1','141','251377','322',493.00,580.00,0.00,4133.40,2037766.20,2133465.00,95698.80,713853),('1','141','251562','322',493.00,580.00,0.00,6600.90,3254243.70,3398953.00,144709.30,714330),('1','141','251804','322',493.00,580.00,0.00,2973.60,1465984.80,1540441.00,74456.20,714964),('1','141','252018','322',493.00,580.00,0.00,4194.84,2068056.12,2189169.20,121113.08,715530),('1','141','252287','322',493.00,580.00,0.00,2836.85,1398567.05,1468091.00,69523.95,716229),('1','141','252508','322',493.00,580.00,0.00,4002.91,1973434.63,2058375.10,84940.47,716796),('1','141','252745','322',493.00,580.00,0.00,0.00,0.00,0.00,0.00,717416),('1','141','252754','322',488.00,580.00,0.00,9553.10,4661912.80,4868648.00,206735.20,717433),('1','141','253002','322',488.00,580.00,0.00,8881.47,4334157.36,4529900.10,195742.74,718081),('1','141','253250','322',488.00,580.00,0.00,6279.49,3064391.12,3203114.20,138723.08,718734),('1','141','253494','322',488.00,580.00,0.00,0.00,0.00,0.00,0.00,719371),('1','141','253499','322',488.00,580.00,0.00,11090.59,5412207.92,5636972.20,224764.28,719377),('1','141','253755','322',488.00,580.00,0.00,9832.48,4798250.24,5008675.90,210425.66,720039),('1','141','254027','322',488.00,580.00,0.00,3720.25,1815482.00,1891495.00,76013.00,720748),('1','141','254194','322',488.00,580.00,0.00,0.00,0.00,0.00,0.00,721199),('1','141','254231','322',488.00,580.00,0.00,9555.08,4662879.04,4862926.40,200047.36,721274),('1','141','254499','322',488.00,580.00,0.00,10261.05,5007392.40,5215996.50,208604.10,721970),('1','141','254731','322',488.00,580.00,0.00,4816.87,2350632.56,2444862.10,94229.54,722555),('1','141','254980','322',488.00,580.00,0.00,16153.50,7882908.00,8205146.25,322238.25,723190),('1','141','255222','322',488.00,580.00,0.00,8167.27,3985627.76,4139529.10,153901.34,723811),('1','141','255392','322',488.00,580.00,0.00,0.00,0.00,0.00,0.00,724252),('1','141','255493','322',488.00,580.00,0.00,13523.56,6599497.28,6879644.80,280147.52,724480),('1','141','255772','322',488.00,580.00,0.00,11188.64,5460056.32,5662371.20,202314.88,725178),('1','141','256003','322',488.00,580.00,0.00,0.00,0.00,0.00,0.00,725774),('1','141','256010','322',488.00,580.00,0.00,10523.53,5135482.64,5350354.90,214872.26,725790),('1','141','256242','322',488.00,580.00,0.00,12007.36,5859591.68,6092056.30,232464.62,726350),('1','141','256541','322',488.00,580.00,0.00,2134.70,1041733.60,1078526.00,36792.40,727136),('1','141','256721','322',488.00,580.00,0.00,0.00,0.00,0.00,0.00,727620),('1','141','256724','322',488.00,580.00,0.00,24571.51,11990896.88,12457399.30,466502.42,727625),('1','141','257000','322',488.00,580.00,0.00,0.00,0.00,0.00,0.00,728325),('1','141','257013','322',488.00,580.00,0.00,11078.26,5406190.88,5631943.30,225752.42,728353),('1','141','257231','322',488.00,580.00,0.00,13442.62,6559998.56,6827472.10,267473.54,728949),('1','141','257573','322',488.00,580.00,0.00,0.00,0.00,0.00,0.00,729824),('1','141','257577','322',485.00,580.00,0.00,6376.19,3092452.15,3235042.70,142590.55,729834),('1','141','257578','322',485.00,580.00,0.00,18217.11,8835298.35,9241840.05,406541.70,729835),('1','141','257579','322',485.00,580.00,0.00,0.00,0.00,0.00,0.00,729836),('1','141','257580','322',485.00,580.00,0.00,9843.66,4774175.10,5012242.80,238067.70,729837),('1','141','257581','322',485.00,580.00,0.00,14814.27,7184920.95,7522150.35,337229.40,729838),('1','141','257582','322',485.00,580.00,0.00,0.00,0.00,0.00,0.00,729839),('1','141','257583','322',488.00,580.00,0.00,11954.63,5833859.44,6082997.90,249138.46,729840),('1','141','257584','322',488.00,580.00,0.00,12706.37,6200708.56,6435112.10,234403.54,729841),('1','141','257585','322',488.00,580.00,0.00,0.00,0.00,0.00,0.00,729842),('1','141','257586','322',488.00,580.00,0.00,13160.18,6422167.84,6686239.40,264071.56,729843),('1','141','257587','322',488.00,580.00,0.00,11574.10,5648160.80,5869115.50,220954.70,729844),('1','141','257588','322',488.00,580.00,0.00,0.00,0.00,0.00,0.00,729845),('1','141','257589','322',488.00,580.00,0.00,13041.90,6364447.20,6634602.00,270154.80,729846),('1','141','257590','322',488.00,580.00,0.00,11452.59,5588863.92,5797411.20,208547.28,729847),('1','141','257591','322',488.00,580.00,0.00,0.00,0.00,0.00,0.00,729848),('1','141','257592','322',488.00,580.00,0.00,15767.48,7694530.24,7993940.90,299410.66,729849),('1','141','257593','322',488.00,580.00,0.00,9765.75,4765686.00,4946392.50,180706.50,729850),('1','141','257594','322',488.00,580.00,0.00,0.00,0.00,0.00,0.00,729851),('1','141','257595','322',488.00,580.00,0.00,9164.82,4472432.16,4662488.10,190055.94,729852),('1','141','257596','322',488.00,580.00,0.00,10780.66,5260962.08,5488307.80,227345.72,729853),('1','141','257597','322',488.00,580.00,0.00,4535.80,2213470.40,2307679.00,94208.60,729854),('1','141','257598','322',488.00,580.00,0.00,0.00,0.00,0.00,0.00,729855),('1','141','257599','322',493.00,580.00,0.00,4360.04,2149499.72,2215350.20,65850.48,729856),('1','141','257600','322',493.00,580.00,0.00,12234.27,6031495.11,6220881.60,189386.49,729857),('1','141','257601','322',493.00,580.00,0.00,6345.63,3128395.59,3243302.40,114906.81,729858),('1','141','257602','322',493.00,580.00,0.00,895.50,441481.50,454515.00,13033.50,729859),('1','141','257603','322',493.00,580.00,0.00,0.00,0.00,0.00,0.00,729860),('1','141','257604','322',503.00,580.00,0.00,8233.95,4141676.85,4312028.40,170351.55,729861),('1','141','257605','322',503.00,580.00,0.00,7751.99,3899250.97,4064253.20,165002.23,729862),('1','141','257606','322',503.00,580.00,0.00,6677.24,3358651.72,3501903.20,143251.48,729863),('1','141','257607','322',503.00,580.00,0.00,1819.05,914982.15,955479.00,40496.85,729864),('1','141','257608','322',503.00,580.00,0.00,0.00,0.00,0.00,0.00,729865),('1','141','257609','322',503.00,580.00,0.00,2532.08,1273636.24,1320059.60,46423.36,729866),('1','141','257610','322',503.00,580.00,0.00,7007.44,3524742.32,3673057.60,148315.28,729867),('1','141','257611','322',503.00,580.00,0.00,7463.70,3754241.10,3912588.00,158346.90,729868),('1','141','257612','322',503.00,580.00,0.00,7490.07,3767505.21,3908610.60,141105.39,729869),('1','141','257613','322',503.00,580.00,0.00,0.00,0.00,0.00,0.00,729870),('1','141','257614','322',508.00,580.00,0.00,8697.64,4418401.12,4650194.08,231792.96,729871),('1','141','257615','322',508.00,580.00,0.00,6725.29,3416447.32,3603318.28,186870.96,729872),('1','141','257616','322',508.00,580.00,0.00,9211.69,4679538.52,4911788.20,232249.68,729873),('1','141','257617','322',508.00,580.00,0.00,0.00,0.00,0.00,0.00,729874),('1','141','257618','322',508.00,580.00,0.00,9519.93,4836124.44,5091868.20,255743.76,729875),('1','141','257619','322',508.00,580.00,0.00,15128.01,7685029.08,8064589.80,379560.72,729876),('1','141','257620','322',508.00,580.00,0.00,0.00,0.00,0.00,0.00,729877),('1','141','257621','322',508.00,580.00,0.00,8535.45,4336008.60,4562404.20,226395.60,729878),('1','141','257622','322',508.00,580.00,0.00,16013.66,8134939.28,8542233.20,407293.92,729879),('1','141','257623','322',508.00,580.00,0.00,0.00,0.00,0.00,0.00,729880),('1','141','257624','322',508.00,580.00,0.00,6376.40,3239211.20,3412544.00,173332.80,729881),('1','141','257625','322',508.00,580.00,0.00,11180.99,5679942.92,5973169.40,293226.48,729882),('1','141','257626','322',508.00,580.00,0.00,7080.28,3596782.24,3777647.20,180864.96,729883),('1','141','257627','322',508.00,580.00,0.00,0.00,0.00,0.00,0.00,729884),('1','141','257628','322',515.00,580.00,0.00,16931.21,8719573.15,9028005.80,308432.65,729885),('1','141','257629','322',515.00,580.00,0.00,7699.10,3965036.50,4101791.60,136755.10,729886),('1','141','257630','322',572.00,650.00,0.00,0.00,0.00,0.00,0.00,729887),('1','141','257631','322',572.00,650.00,0.00,6213.01,3553841.72,3814359.70,260517.98,729888),('1','141','257632','322',572.00,650.00,0.00,4516.39,2583375.08,2782109.50,198734.42,729889),('1','141','257633','322',572.00,650.00,0.00,3739.18,2138810.96,2289635.00,150824.04,729890),('1','141','257634','322',572.00,650.00,0.00,4084.44,2336299.68,2511462.00,175162.32,729891),('1','141','257635','322',572.00,650.00,0.00,6131.64,3507298.08,3759730.00,252431.92,729892),('1','141','257636','322',572.00,650.00,0.00,0.00,0.00,0.00,0.00,729893),('1','141','257637','322',568.00,650.00,0.00,3744.75,2127018.00,2235175.50,108157.50,729894),('1','141','257638','322',568.00,650.00,0.00,6694.23,3802322.64,3976603.50,174280.86,729895),('1','141','257639','322',568.00,650.00,0.00,5047.17,2866792.56,3007990.50,141197.94,729896),('1','141','257640','322',568.00,650.00,0.00,6502.59,3693471.12,3864605.70,171134.58,729897),('1','141','257641','322',568.00,650.00,0.00,2665.47,1513986.96,1572627.30,58640.34,729898),('1','141','257642','322',568.00,650.00,0.00,0.00,0.00,0.00,0.00,729899),('1','141','257643','322',568.00,650.00,0.00,13748.14,7808943.52,8142789.20,333845.68,729900),('1','141','257644','322',568.00,650.00,0.00,10888.81,6184844.08,6450398.30,265554.22,729901),('1','141','257645','322',568.00,650.00,0.00,0.00,0.00,0.00,0.00,729902),('1','141','257646','322',568.00,650.00,0.00,5523.53,3137365.04,3268116.70,130751.66,729903),('1','141','257647','322',568.00,650.00,0.00,9552.05,5425564.40,5667242.50,241678.10,729904),('1','141','257648','322',568.00,650.00,0.00,5194.39,2950413.52,3095019.50,144605.98,729905),('1','141','257649','322',568.00,650.00,0.00,4377.46,2486397.28,2591249.00,104851.72,729906),('1','141','257650','322',568.00,650.00,0.00,0.00,0.00,0.00,0.00,729907),('1','141','257651','322',568.00,660.00,0.00,5170.60,2936900.80,3164181.00,227280.20,729908),('1','141','257652','322',568.00,660.00,0.00,6579.21,3736991.28,4036303.60,299312.32,729909),('1','141','257653','322',568.00,660.00,0.00,6804.43,3864916.24,4179013.80,314097.56,729910),('1','141','257654','322',568.00,660.00,0.00,6073.19,3449571.92,3720830.40,271258.48,729911),('1','141','257655','322',568.00,660.00,0.00,0.00,0.00,0.00,0.00,729912),('1','141','257656','322',591.00,660.00,0.00,7476.51,4418617.41,4588389.60,169772.19,729913),('1','141','257657','322',591.00,660.00,0.00,5370.86,3174178.26,3303217.60,129039.34,729914),('1','141','257658','322',591.00,660.00,0.00,5840.39,3451670.49,3582482.40,130811.91,729915),('1','141','257659','322',591.00,660.00,0.00,3418.98,2020617.18,2098171.80,77554.62,729916),('1','141','257660','322',591.00,660.00,0.00,2498.12,1476388.92,1529304.20,52915.28,729917),('1','141','257661','322',591.00,660.00,0.00,0.00,0.00,0.00,0.00,729918),('1','141','257662','322',574.00,660.00,0.00,10341.75,5936164.50,6235113.00,298948.50,729919),('1','141','257663','322',574.00,660.00,0.00,5376.68,3086214.32,3261586.80,175372.48,729920),('1','141','257664','322',574.00,660.00,0.00,5621.82,3226924.68,3403491.60,176566.92,729921),('1','141','257665','322',574.00,660.00,0.00,3279.32,1882329.68,1983271.20,100941.52,729922),('1','141','257666','322',574.00,660.00,0.00,0.00,0.00,0.00,0.00,729923),('1','141','257667','322',578.00,660.00,0.00,4356.00,2517768.00,2624580.00,106812.00,729924),('1','141','257668','322',578.00,660.00,0.00,4729.03,2733379.34,2873599.80,140220.46,729925),('1','141','257669','322',578.00,660.00,0.00,7721.68,4463131.04,4651108.80,187977.76,729926),('1','141','257670','322',578.00,660.00,0.00,3535.37,2043443.86,2145400.20,101956.34,729927),('1','141','257671','322',578.00,660.00,0.00,4238.20,2449679.60,2548836.00,99156.40,729928),('1','141','257672','322',578.00,660.00,0.00,0.00,0.00,0.00,0.00,729929),('1','141','257673','322',578.00,660.00,0.00,11060.43,6392928.54,6607484.30,214555.76,729930),('1','141','257674','322',578.00,660.00,0.00,6888.87,3981766.86,4129549.20,147782.34,729931),('1','141','257675','322',578.00,660.00,0.00,6684.68,3863745.04,4005606.30,141861.26,729932),('1','141','257676','322',578.00,660.00,0.00,0.00,0.00,0.00,0.00,729933),('1','141','257677','322',578.00,660.00,0.00,6350.45,3670560.10,3792821.65,122261.55,729934),('1','141','257678','322',578.00,660.00,0.00,5709.08,3299848.24,3433788.80,133940.56,729935),('1','141','257679','322',578.00,660.00,0.00,7149.09,4132174.02,4240797.15,108623.13,729936),('1','141','257680','322',578.00,660.00,0.00,5373.57,3105923.46,3167768.70,61845.24,729937),('1','141','257681','322',578.00,660.00,0.00,0.00,0.00,0.00,0.00,729938),('1','141','257682','322',566.00,660.00,0.00,10280.04,5818502.64,6050676.90,232174.26,729939),('1','141','257683','322',566.00,660.00,0.00,11307.95,6400299.70,6650539.50,250239.80,729940),('1','141','257684','322',566.00,660.00,0.00,2917.39,1651242.74,1714824.90,63582.16,729941),('1','141','257685','322',566.00,660.00,0.00,0.00,0.00,0.00,0.00,729942),('1','141','257686','322',566.00,660.00,0.00,7678.86,4346234.76,4510220.10,163985.34,729943),('1','141','257687','322',566.00,660.00,0.00,11970.16,6775110.56,7035383.10,260272.54,729944),('1','141','257688','322',566.00,660.00,0.00,0.00,0.00,0.00,0.00,729945),('1','141','257689','322',566.00,660.00,0.00,3101.63,1755522.58,1836243.30,80720.72,729946),('1','141','257690','322',566.00,660.00,0.00,9719.02,5500965.32,5719753.20,218787.88,729947),('1','141','257691','322',566.00,660.00,0.00,9759.04,5523616.64,5747096.40,223479.76,729948),('1','141','257692','322',566.00,660.00,0.00,1994.40,1128830.40,1169956.50,41126.10,729949),('1','141','257693','322',566.00,660.00,0.00,0.00,0.00,0.00,0.00,729950),('1','141','257694','322',566.00,660.00,0.00,14295.66,8091343.56,8406878.10,315534.54,729951),('1','141','257695','322',566.00,660.00,0.00,5467.82,3094786.12,3217868.70,123082.58,729952),('1','141','257696','322',566.00,660.00,0.00,1749.02,989945.32,1031278.20,41332.88,729953),('1','141','257697','322',566.00,660.00,0.00,3113.35,1762156.10,1826931.00,64774.90,729954),('1','141','257698','322',566.00,660.00,0.00,0.00,0.00,0.00,0.00,729955),('1','141','257699','322',566.00,660.00,0.00,10107.50,5720845.00,5937871.50,217026.50,729956),('1','141','257700','322',566.00,660.00,0.00,6785.72,3840717.52,4013027.70,172310.18,729957),('1','141','257701','322',566.00,660.00,0.00,7687.25,4350983.50,4527217.50,176234.00,729958),('1','141','257702','322',566.00,660.00,0.00,0.00,0.00,0.00,0.00,729959),('1','141','257703','322',558.00,620.00,0.00,7623.50,4253913.00,4418741.60,164828.60,729960),('1','141','257704','322',558.00,620.00,0.00,11354.75,6335950.50,6563889.20,227938.70,729961),('1','141','257705','322',558.00,620.00,0.00,3885.96,2168365.68,2252307.60,83941.92,729962),('1','141','257706','322',558.00,620.00,0.00,1715.91,957477.78,992267.40,34789.62,729963),('1','141','257707','322',558.00,620.00,0.00,0.00,0.00,0.00,0.00,729964),('1','141','257708','322',558.00,620.00,0.00,3827.81,2135917.98,2211207.80,75289.82,729965),('1','141','257709','322',558.00,620.00,0.00,15188.07,8474943.06,8768659.40,293716.34,729966),('1','141','257710','322',558.00,620.00,0.00,5507.55,3073212.90,3184143.00,110930.10,729967),('1','141','257711','322',558.00,620.00,0.00,44.66,24920.28,25724.16,803.88,729968),('1','141','257712','322',558.00,620.00,0.00,17606.58,9824471.64,10166084.20,341612.56,729969),('1','141','257713','322',558.00,620.00,0.00,1969.62,1099047.96,1137409.52,38361.56,729970),('1','141','257714','322',558.00,620.00,0.00,0.00,0.00,0.00,0.00,729971),('1','141','257715','322',593.00,660.00,0.00,5136.62,3046015.66,3225182.70,179167.04,729972),('1','141','257716','322',593.00,660.00,0.00,12245.49,7261575.57,7682711.90,421136.33,729973),('1','141','257717','322',593.00,660.00,0.00,7076.25,4196216.25,4434911.50,238695.25,729974),('1','141','257718','322',607.00,660.00,0.00,0.00,0.00,0.00,0.00,729975),('1','141','257719','322',607.00,660.00,0.00,6445.31,3912303.17,4079811.60,167508.43,729976),('1','141','257720','322',607.00,660.00,0.00,7831.99,4754017.93,4955462.40,201444.47,729977),('1','141','257721','322',607.00,660.00,0.00,8042.06,4881530.42,5091971.70,210441.28,729978),('1','141','257722','322',607.00,660.00,0.00,2241.12,1360359.84,1412119.20,51759.36,729979),('1','141','257723','322',607.00,660.00,0.00,0.00,0.00,0.00,0.00,729980),('1','141','257724','322',616.00,660.00,0.00,11028.80,6793740.80,7097928.20,304187.40,729981),('1','141','257725','322',616.00,680.00,0.00,12493.59,7696051.44,8024096.00,328044.56,729982),('1','141','257726','322',616.00,680.00,0.00,877.74,540687.84,565723.20,25035.36,729983),('1','141','257727','322',616.00,680.00,0.00,0.00,0.00,0.00,0.00,729984),('1','141','257728','322',636.00,700.00,0.00,6021.27,3829527.72,4043583.30,214055.58,729985),('1','141','257729','322',636.00,700.00,0.00,13737.89,8737298.04,9219259.10,481961.06,729986),('1','141','257730','322',636.00,700.00,0.00,4829.43,3071517.48,3241476.00,169958.52,729987),('1','141','257731','322',636.00,700.00,0.00,0.00,0.00,0.00,0.00,729988),('1','141','257732','322',636.00,700.00,0.00,5805.01,3691986.36,3901777.00,209790.64,729989),('1','141','257733','322',636.00,700.00,0.00,11641.90,7404248.40,7819167.40,414919.00,729990),('1','141','257734','322',636.00,700.00,0.00,7051.09,4484493.24,4733446.00,248952.76,729991),('1','141','257735','322',636.00,700.00,0.00,0.00,0.00,0.00,0.00,729992),('1','141','257736','322',656.00,750.00,0.00,5856.75,3842028.00,4078466.70,236438.70,729993),('1','141','257737','322',656.00,750.00,0.00,6754.73,4431102.88,4709047.50,277944.62,729994),('1','141','257738','322',656.00,750.00,0.00,6506.10,4268001.60,4546675.20,278673.60,729995),('1','141','257739','322',656.00,750.00,0.00,4077.83,2675056.48,2842033.50,166977.02,729996),('1','141','257740','322',656.00,750.00,0.00,1438.06,943367.36,994551.00,51183.64,729997),('1','141','257741','322',656.00,750.00,0.00,0.00,0.00,0.00,0.00,729998),('1','141','257742','322',656.00,750.00,0.00,7555.41,4956348.96,5251741.50,295392.54,729999),('1','141','257743','322',656.00,750.00,0.00,8582.66,5630224.96,5956051.80,325826.84,730000),('1','141','257744','322',656.00,750.00,0.00,0.00,0.00,0.00,0.00,730001),('1','141','257745','322',656.00,750.00,0.00,8424.34,5526367.04,5844506.40,318139.36,730002),('1','141','257746','322',656.00,750.00,0.00,0.00,0.00,0.00,0.00,730003),('1','141','257747','322',656.00,750.00,0.00,5606.01,3677542.56,3910634.10,233091.54,730004),('1','141','257748','322',656.00,750.00,0.00,11750.68,7708446.08,8151259.80,442813.72,730005),('1','141','257749','322',656.00,750.00,0.00,7249.93,4755954.08,5033667.30,277713.22,730006),('1','141','257750','322',656.00,750.00,0.00,0.00,0.00,0.00,0.00,730007),('1','141','257751','322',656.00,750.00,0.00,4114.21,2698921.76,2871967.50,173045.74,730008),('1','141','257752','322',656.00,750.00,0.00,7382.37,4842834.72,5130778.50,287943.78,730009),('1','141','257753','322',656.00,750.00,0.00,6545.08,4293572.48,4554420.00,260847.52,730010),('1','141','257754','322',656.00,750.00,0.00,3800.08,2492852.48,2642146.80,149294.32,730011),('1','141','257755','322',656.00,750.00,0.00,2770.28,1817303.68,1924056.00,106752.32,730012),('1','141','257756','322',656.00,750.00,0.00,0.00,0.00,0.00,0.00,730013),('1','141','257757','322',656.00,750.00,0.00,4160.00,2728960.00,2787200.00,58240.00,730014),('1','141','257758','322',656.00,750.00,0.00,15987.30,10487668.80,10782315.00,294646.20,730015),('1','141','257759','322',656.00,750.00,0.00,3686.11,2418088.16,2499252.90,81164.74,730016),('1','141','257760','322',656.00,750.00,0.00,0.00,0.00,0.00,0.00,730017),('1','141','257761','322',656.00,750.00,0.00,1383.37,907490.72,937183.50,29692.78,730018),('1','141','257762','322',656.00,750.00,0.00,8170.37,5359762.72,5520745.50,160982.78,730019),('1','141','257763','322',656.00,750.00,0.00,3450.73,2263678.88,2345915.50,82236.62,730020),('1','141','257764','322',656.00,750.00,0.00,3845.91,2522916.96,2610103.70,87186.74,730021),('1','141','257765','322',656.00,750.00,0.00,6251.15,4100754.40,4219539.30,118784.90,730022),('1','141','257766','322',656.00,750.00,0.00,1367.11,896824.16,921056.50,24232.34,730023),('1','141','257767','322',656.00,750.00,0.00,0.00,0.00,0.00,0.00,730024),('1','141','257768','322',656.00,750.00,0.00,3586.11,2352488.16,2440073.70,87585.54,730025),('1','141','257769','322',656.00,750.00,0.00,10115.23,6635590.88,6831013.70,195422.82,730026),('1','141','257770','322',656.00,750.00,0.00,8180.81,5366611.36,5535491.50,168880.14,730027),('1','141','257771','322',656.00,750.00,0.00,3072.68,2015678.08,2069518.00,53839.92,730028),('1','141','257772','322',656.00,750.00,0.00,0.00,0.00,0.00,0.00,730029),('1','141','257773','322',656.00,750.00,0.00,1633.82,1071785.92,1112979.40,41193.48,730030),('1','141','257774','322',656.00,750.00,0.00,8124.88,5329921.28,5511319.20,181397.92,730031),('1','141','257775','322',656.00,750.00,0.00,5087.21,3337209.76,3427154.70,89944.94,730032),('1','141','257776','322',656.00,750.00,0.00,10113.16,6634232.96,6821766.00,187533.04,730033),('1','141','257777','322',656.00,750.00,0.00,106.00,69536.00,71020.00,1484.00,730034),('1','141','257778','322',656.00,750.00,0.00,8047.30,5279028.80,5427995.00,148966.20,730035),('1','141','257779','322',656.00,750.00,0.00,8249.04,5411370.24,5591244.00,179873.76,730036),('1','141','257780','322',656.00,750.00,0.00,1470.95,964943.20,997196.50,32253.30,730037),('1','141','257781','322',656.00,750.00,0.00,5697.84,3737783.04,3839217.60,101434.56,730038),('1','141','257782','322',656.00,750.00,0.00,1099.48,721258.88,738758.00,17499.12,730039),('1','141','257783','322',656.00,750.00,0.00,0.00,0.00,0.00,0.00,730040),('1','141','257784','322',656.00,750.00,0.00,8734.85,5730061.60,5897137.50,167075.90,730041),('1','141','257785','322',656.00,750.00,0.00,7087.03,4649091.68,4792518.90,143427.22,730042),('1','141','257786','322',656.00,750.00,0.00,8385.89,5501143.84,5678229.50,177085.66,730043),('1','141','257787','322',656.00,750.00,0.00,498.02,326701.12,339955.80,13254.68,730044),('1','141','257788','322',656.00,750.00,0.00,0.00,0.00,0.00,0.00,730045),('1','141','257789','322',646.00,750.00,0.00,6239.89,4030968.94,4163538.90,132569.96,730046),('1','141','257790','322',646.00,750.00,0.00,10254.76,6624574.96,6825518.40,200943.44,730047),('1','141','257791','322',646.00,750.00,0.00,6136.24,3964011.04,4071643.50,107632.46,730048),('1','141','257792','322',646.00,750.00,0.00,2050.62,1324700.52,1371780.00,47079.48,730049),('1','141','257793','322',646.00,750.00,0.00,0.00,0.00,0.00,0.00,730050),('1','141','257794','322',646.00,750.00,0.00,6843.50,4420901.00,4555842.00,134941.00,730051),('1','141','257795','322',646.00,750.00,0.00,14330.95,9257793.70,9503643.90,245850.20,730052),('1','141','257796','322',646.00,750.00,0.00,3060.26,1976927.96,2029671.60,52743.64,730053),('1','141','257797','322',646.00,750.00,0.00,0.00,0.00,0.00,0.00,730054),('1','141','257798','322',646.00,750.00,0.00,6864.63,4434550.98,4570731.90,136180.92,730055),('1','141','257799','322',646.00,750.00,0.00,16065.48,10378300.08,10665315.00,287014.92,730056),('1','141','257800','322',646.00,750.00,0.00,1527.62,986842.52,1015359.90,28517.38,730057),('1','141','257801','322',646.00,750.00,0.00,0.00,0.00,0.00,0.00,730058),('1','141','257802','322',646.00,750.00,0.00,9263.53,5984240.38,6158562.60,174322.22,730059),('1','141','257803','322',646.00,750.00,0.00,11608.97,7499394.62,7722172.50,222777.88,730060),('1','141','257804','322',646.00,750.00,0.00,3898.77,2518605.42,2596514.40,77908.98,730061),('1','141','257805','322',646.00,750.00,0.00,0.00,0.00,0.00,0.00,730062),('1','141','257806','322',646.00,750.00,0.00,10705.94,6916037.24,7108494.00,192456.76,730063),('1','141','257807','322',646.00,750.00,0.00,10940.25,7067401.50,7284802.50,217401.00,730064),('1','141','257808','322',646.00,750.00,0.00,3165.48,2044900.08,2094334.20,49434.12,730065),('1','141','257809','322',646.00,750.00,0.00,0.00,0.00,0.00,0.00,730066),('1','141','257810','322',646.00,750.00,0.00,9758.41,6303932.86,6495501.00,191568.14,730067),('1','141','257811','322',646.00,750.00,0.00,9825.77,6347447.42,6512399.70,164952.28,730068),('1','141','257812','322',646.00,750.00,0.00,0.00,0.00,0.00,0.00,730069),('1','141','257813','322',646.00,750.00,0.00,17004.68,10985023.28,11291443.80,306420.52,730070),('1','141','257814','322',646.00,750.00,0.00,0.00,0.00,0.00,0.00,730071),('1','141','257815','322',646.00,750.00,0.00,7692.12,4969109.52,5086701.00,117591.48,730072),('1','141','257816','322',646.00,750.00,0.00,0.00,0.00,0.00,0.00,730073),('1','141','257817','322',646.00,750.00,0.00,22607.68,14604561.28,14976068.70,371507.42,730074),('1','141','257818','322',646.00,750.00,0.00,2006.98,1296509.08,1329164.40,32655.32,730075),('1','141','257819','322',646.00,750.00,0.00,0.00,0.00,0.00,0.00,730076),('1','141','257820','322',646.00,750.00,0.00,18444.16,11914927.36,12250498.80,335571.44,730077),('1','141','257821','322',646.00,750.00,0.00,6390.78,4128443.88,4245910.20,117466.32,730078),('1','141','257822','322',646.00,750.00,0.00,0.00,0.00,0.00,0.00,730079),('1','141','257823','322',655.00,750.00,0.00,7295.28,4778408.40,4988754.00,210345.60,730080),('1','141','257824','322',655.00,750.00,0.00,11359.19,7440269.45,7768088.10,327818.65,730081),('1','141','257825','322',655.00,750.00,0.00,6079.78,3982255.90,4162060.00,179804.10,730082),('1','141','257826','322',655.00,750.00,0.00,0.00,0.00,0.00,0.00,730083),('1','141','257827','322',655.00,750.00,0.00,10348.29,6778129.95,7075426.80,297296.85,730084),('1','141','257828','322',655.00,750.00,0.00,9979.44,6536533.20,6844029.60,307496.40,730085),('1','141','257829','322',655.00,750.00,0.00,4636.71,3037045.05,3172081.20,135036.15,730086),('1','141','257830','322',655.00,750.00,0.00,0.00,0.00,0.00,0.00,730087),('1','141','257831','322',655.00,750.00,0.00,19031.66,12465737.30,12992213.70,526476.40,730088),('1','141','257832','322',655.00,750.00,0.00,5445.44,3566763.20,3713848.60,147085.40,730089),('1','141','257833','322',655.00,750.00,0.00,0.00,0.00,0.00,0.00,730090),('1','141','257834','322',655.00,750.00,0.00,14116.07,9246025.85,9622295.70,376269.85,730091),('1','141','257835','322',655.00,750.00,0.00,10620.27,6956276.85,7281154.10,324877.25,730092),('1','141','257836','322',655.00,750.00,0.00,0.00,0.00,0.00,0.00,730093),('1','141','257837','322',655.00,750.00,0.00,10125.01,6631881.55,6937045.50,305163.95,730094),('1','141','257838','322',655.00,750.00,0.00,14454.03,9467389.65,9854825.20,387435.55,730095),('1','141','257839','322',655.00,750.00,0.00,0.00,0.00,0.00,0.00,730096),('1','141','257840','322',655.00,750.00,0.00,0.00,0.00,0.00,0.00,730097),('1','141','257841','322',640.00,750.00,0.00,4235.02,2710412.80,2908917.50,198504.70,730098),('1','141','257842','322',640.00,750.00,0.00,10997.53,7038419.20,7524557.50,486138.30,730099),('1','141','257843','322',640.00,750.00,0.00,5790.31,3705798.40,3980085.60,274287.20,730100),('1','141','257844','322',640.00,750.00,0.00,3645.82,2333324.80,2492701.90,159377.10,730101),('1','141','257845','322',640.00,750.00,0.00,0.00,0.00,0.00,0.00,730102),('1','141','257846','322',645.00,740.00,0.00,3778.30,2437003.50,2552846.00,115842.50,730103),('1','141','257847','322',645.00,740.00,0.00,8549.96,5514724.20,5773065.30,258341.10,730104),('1','141','257848','322',645.00,740.00,0.00,4389.82,2831433.90,2961492.00,130058.10,730105),('1','141','257849','322',645.00,740.00,0.00,7956.44,5131903.80,5350200.60,218296.80,730106),('1','141','257850','322',645.00,740.00,0.00,0.00,0.00,0.00,0.00,730107),('1','141','257851','322',645.00,740.00,0.00,4286.61,2764863.45,2895465.40,130601.95,730108),('1','141','257852','322',645.00,740.00,0.00,9343.79,6026744.55,6312824.60,286080.05,730109),('1','141','257853','322',645.00,740.00,0.00,9572.44,6174223.80,6455488.60,281264.80,730110),('1','141','257854','322',645.00,740.00,0.00,1512.70,975691.50,1015909.30,40217.80,730111),('1','141','257855','322',645.00,740.00,0.00,0.00,0.00,0.00,0.00,730112),('1','141','257856','322',645.00,740.00,0.00,7163.48,4620444.60,4837825.10,217380.50,730113),('1','141','257857','322',645.00,740.00,0.00,10271.91,6625381.95,6923712.80,298330.85,730114),('1','141','257858','322',645.00,740.00,0.00,6807.49,4390831.05,4585642.90,194811.85,730115),('1','141','257859','322',645.00,740.00,0.00,0.00,0.00,0.00,0.00,730116),('1','141','257860','322',645.00,740.00,0.00,5340.57,3444667.65,3593448.90,148781.25,730117),('1','141','257861','322',645.00,740.00,0.00,10871.21,7011930.45,7321480.60,309550.15,730118),('1','141','257862','322',645.00,740.00,0.00,8441.02,5444457.90,5677998.90,233541.00,730119),('1','141','257863','322',645.00,740.00,0.00,0.00,0.00,0.00,0.00,730120),('1','141','257864','322',645.00,740.00,0.00,10873.87,7013646.15,7321104.00,307457.85,730121),('1','141','257865','322',645.00,740.00,0.00,9029.72,5824169.40,6088910.80,264741.40,730122),('1','141','257866','322',645.00,740.00,0.00,4833.45,3117575.25,3255044.90,137469.65,730123),('1','141','257867','322',645.00,740.00,0.00,0.00,0.00,0.00,0.00,730124),('1','141','257868','322',645.00,740.00,0.00,3843.03,2478754.35,2587180.20,108425.85,730125),('1','141','257869','322',645.00,740.00,0.00,9151.08,5902446.60,6174921.10,272474.50,730126),('1','141','257870','322',645.00,740.00,0.00,5523.45,3562625.25,3723955.70,161330.45,730127),('1','141','257871','322',645.00,740.00,0.00,6125.57,3950992.65,4127367.70,176375.05,730128),('1','141','257872','322',645.00,740.00,0.00,0.00,0.00,0.00,0.00,730129),('1','141','257873','322',645.00,740.00,0.00,3293.49,2124301.05,2224738.90,100437.85,730130),('1','141','257874','322',645.00,740.00,0.00,10974.66,7078655.70,7394452.40,315796.70,730131),('1','141','257875','322',645.00,740.00,0.00,6944.47,4479183.15,4694829.20,215646.05,730132),('1','141','257876','322',645.00,740.00,0.00,3290.73,2122520.85,2211525.20,89004.35,730133),('1','141','257877','322',645.00,740.00,0.00,0.00,0.00,0.00,0.00,730134),('1','141','257878','322',645.00,740.00,0.00,5004.65,3227999.25,3374023.10,146023.85,730135),('1','141','257879','322',645.00,740.00,0.00,7799.57,5030722.65,5270233.30,239510.65,730136),('1','141','257880','322',645.00,740.00,0.00,7692.08,4961391.60,5204570.30,243178.70,730137),('1','141','257881','322',645.00,740.00,0.00,4199.25,2708516.25,2833399.20,124882.95,730138),('1','141','257882','322',645.00,740.00,0.00,0.00,0.00,0.00,0.00,730139),('1','141','257883','322',645.00,740.00,0.00,7994.62,5156529.90,5402884.50,246354.60,730140),('1','141','257884','322',645.00,740.00,0.00,7367.97,4752340.65,4974870.50,222529.85,730141),('1','141','257885','322',645.00,740.00,0.00,6891.11,4444765.95,4596095.80,151329.85,730142),('1','141','257886','322',645.00,720.00,0.00,2457.37,1585003.65,1626651.00,41647.35,730143),('1','141','257887','322',645.00,720.00,0.00,0.00,0.00,0.00,0.00,730144),('1','141','257888','322',645.00,720.00,0.00,5170.46,3334946.70,3428977.20,94030.50,730145),('1','141','257889','322',645.00,720.00,0.00,9453.59,6097565.55,6269374.20,171808.65,730146),('1','141','257890','322',645.00,720.00,0.00,7340.42,4734570.90,4891335.00,156764.10,730147),('1','141','257891','322',645.00,720.00,0.00,2587.67,1669047.15,1716410.40,47363.25,730148),('1','141','257892','322',645.00,720.00,0.00,0.00,0.00,0.00,0.00,730149),('1','141','257893','322',645.00,720.00,0.00,14421.35,9301770.75,9572823.60,271052.85,730150),('1','141','257894','322',645.00,720.00,0.00,10142.90,6542170.50,6725296.80,183126.30,730151),('1','141','257895','322',645.00,720.00,0.00,0.00,0.00,0.00,0.00,730152),('1','141','257896','322',645.00,720.00,0.00,9411.19,6070217.55,6249366.00,179148.45,730153),('1','141','257897','322',645.00,720.00,0.00,14242.16,9186193.20,9446657.40,260464.20,730154),('1','141','257898','322',645.00,720.00,0.00,1103.73,711905.85,729765.60,17859.75,730155),('1','141','257899','322',645.00,720.00,0.00,0.00,0.00,0.00,0.00,730156),('1','141','257900','322',634.00,720.00,0.00,7665.64,4860015.76,5080067.40,220051.64,730157),('1','141','257901','322',634.00,720.00,0.00,9922.01,6290554.34,6591887.40,301333.06,730158),('1','141','257902','322',634.00,720.00,0.00,6919.02,4386658.68,4605361.20,218702.52,730159),('1','141','257903','322',634.00,720.00,0.00,0.00,0.00,0.00,0.00,730160),('1','141','257904','322',634.00,720.00,0.00,9069.29,5749929.86,6022602.00,272672.14,730161),('1','141','257905','322',634.00,700.00,0.00,9050.41,5737959.94,5868938.15,130978.21,730162),('1','141','257906','322',634.00,700.00,0.00,6309.51,4000229.34,4085804.50,85575.16,730163),('1','141','257907','322',634.00,700.00,0.00,0.00,0.00,0.00,0.00,730164),('1','141','257908','322',634.00,700.00,0.00,5386.96,3415332.64,3489704.85,74372.21,730165),('1','141','257909','322',634.00,700.00,0.00,10548.21,6687565.14,6853001.95,165436.81,730166),('1','141','257910','322',634.00,700.00,0.00,8817.90,5590548.60,5707175.55,116626.95,730167),('1','141','257911','322',634.00,700.00,0.00,0.00,0.00,0.00,0.00,730168),('1','141','257912','322',629.00,700.00,0.00,14067.06,8848180.74,9117705.25,269524.51,730169),('1','141','257913','322',629.00,700.00,0.00,10432.68,6562155.72,6769522.85,207367.13,730170),('1','141','257914','322',629.00,700.00,0.00,0.00,0.00,0.00,0.00,730171),('1','141','257915','322',629.00,700.00,0.00,5387.86,3388963.94,3498124.50,109160.56,730172),('1','141','257916','322',629.00,700.00,0.00,8125.62,5111014.98,5260961.30,149946.32,730173),('1','141','257917','322',629.00,700.00,0.00,10082.10,6341640.90,6539195.65,197554.75,730174),('1','141','257918','322',629.00,700.00,0.00,1137.10,715235.90,734372.20,19136.30,730175),('1','141','257919','322',629.00,700.00,0.00,0.00,0.00,0.00,0.00,730176),('1','141','257920','322',629.00,700.00,0.00,8763.11,5511996.19,5675672.25,163676.06,730177),('1','141','257921','322',629.00,700.00,0.00,11447.57,7200521.53,7582564.60,382043.07,730178),('1','141','257922','322',629.00,700.00,0.00,4429.24,2785991.96,2934268.00,148276.04,730179),('1','141','257923','322',629.00,700.00,0.00,0.00,0.00,0.00,0.00,730180),('1','141','257924','322',629.00,700.00,0.00,9897.59,6225584.11,6569705.80,344121.69,730181),('1','141','257925','322',629.00,700.00,0.00,4175.17,2626181.93,2766270.60,140088.67,730182),('1','141','257926','322',629.00,700.00,0.00,8953.94,5632028.26,5937916.40,305888.14,730183),('1','141','257927','322',629.00,700.00,0.00,1567.99,986265.71,1039359.40,53093.69,730184),('1','141','257928','322',629.00,700.00,0.00,0.00,0.00,0.00,0.00,730185),('1','141','257929','322',640.00,720.00,0.00,4877.88,3121843.20,3331601.60,209758.40,730186),('1','141','257930','322',640.00,720.00,0.00,7622.71,4878534.40,5208752.00,330217.60,730187),('1','141','257931','322',640.00,720.00,0.00,7006.33,4484051.20,4796457.60,312406.40,730188),('1','141','257932','322',640.00,720.00,0.00,5165.07,3305644.80,3531903.20,226258.40,730189),('1','141','257933','322',640.00,720.00,0.00,0.00,0.00,0.00,0.00,730190),('1','141','257934','322',640.00,720.00,0.00,9660.77,6182892.80,6597742.00,414849.20,730191),('1','141','257935','322',640.00,720.00,0.00,8514.64,5449369.60,5810304.40,360934.80,730192),('1','141','257936','322',640.00,720.00,0.00,5492.25,3515040.00,3760642.40,245602.40,730193),('1','141','257937','322',640.00,720.00,0.00,551.91,353222.40,378098.40,24876.00,730194),('1','141','257938','322',640.00,720.00,0.00,0.00,0.00,0.00,0.00,730195),('1','141','257939','322',640.00,720.00,0.00,5266.42,3370508.80,3599680.80,229172.00,730196),('1','141','257940','322',640.00,720.00,0.00,8519.06,5452198.40,5824789.60,372591.20,730197),('1','141','257941','322',640.00,720.00,0.00,4003.57,2562284.80,2733751.20,171466.40,730198),('1','141','257942','322',640.00,720.00,0.00,3559.23,2277907.20,2432873.60,154966.40,730199),('1','141','257943','322',640.00,720.00,0.00,51.39,32889.60,35000.80,2111.20,730200),('1','141','257944','322',640.00,720.00,0.00,2954.68,1890995.20,2013849.60,122854.40,730201),('1','141','257945','322',640.00,720.00,0.00,0.00,0.00,0.00,0.00,730202),('1','141','257946','322',640.00,720.00,0.00,5671.37,3629676.80,3879330.80,249654.00,730203),('1','141','257947','322',640.00,720.00,0.00,6627.11,4241350.40,4537585.20,296234.80,730204),('1','141','257948','322',640.00,720.00,0.00,6225.55,3984352.00,4261138.40,276786.40,730205),('1','141','257949','322',640.00,700.00,0.00,6190.04,3961625.60,4098689.20,137063.60,730206),('1','141','257950','322',640.00,700.00,0.00,0.00,0.00,0.00,0.00,730207),('1','141','257951','322',640.00,700.00,0.00,13049.59,8351737.60,8646397.40,294659.80,730208),('1','141','257952','322',640.00,700.00,0.00,7103.99,4546553.60,4714623.80,168070.20,730209),('1','141','257953','322',640.00,700.00,0.00,4668.88,2988083.20,3091412.80,103329.60,730210),('1','141','257954','322',640.00,700.00,0.00,0.00,0.00,0.00,0.00,730211),('1','141','257955','322',640.00,700.00,0.00,2444.78,1564659.20,1620654.00,55994.80,730212),('1','141','257956','322',640.00,700.00,0.00,7331.48,4692147.20,4857784.40,165637.20,730213),('1','141','257957','322',640.00,700.00,0.00,7692.88,4923443.20,5099484.00,176040.80,730214),('1','141','257958','322',640.00,700.00,0.00,7339.17,4697068.80,4864379.00,167310.20,730215),('1','141','257959','322',640.00,700.00,0.00,0.00,0.00,0.00,0.00,730216),('1','141','257960','322',640.00,700.00,0.00,11107.67,7108908.80,7362239.00,253330.20,730217),('1','141','257961','322',640.00,700.00,0.00,6003.77,3842412.80,3984349.00,141936.20,730218),('1','141','257962','322',640.00,700.00,0.00,7509.27,4805932.80,4977667.80,171735.00,730219),('1','141','257963','322',640.00,700.00,0.00,0.00,0.00,0.00,0.00,730220),('1','141','257964','322',640.00,700.00,0.00,5736.57,3671404.80,3812638.60,141233.80,730221),('1','141','257965','322',640.00,700.00,0.00,7007.40,4484736.00,4645428.80,160692.80,730222),('1','141','257966','322',640.00,700.00,0.00,5908.31,3781318.40,3923491.00,142172.60,730223),('1','141','257967','322',640.00,700.00,0.00,4607.25,2948640.00,3053505.80,104865.80,730224),('1','141','257968','322',640.00,700.00,0.00,1471.31,941638.40,976687.80,35049.40,730225),('1','141','257969','322',640.00,700.00,0.00,0.00,0.00,0.00,0.00,730226),('1','141','257970','322',630.00,700.00,0.00,11484.64,7235323.20,7550059.75,314736.55,730227),('1','141','257971','322',630.00,700.00,0.00,8852.78,5577251.40,5826165.35,248913.95,730228),('1','141','257972','322',630.00,700.00,0.00,4297.83,2707632.90,2824374.30,116741.40,730229),('1','141','257973','322',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730230),('1','141','257974','322',630.00,700.00,0.00,3980.33,2507607.90,2615253.50,107645.60,730231),('1','141','257975','322',630.00,700.00,0.00,8428.57,5309999.10,5545422.40,235423.30,730232),('1','141','257976','322',630.00,700.00,0.00,4784.90,3014487.00,3149750.60,135263.60,730233),('1','141','257977','322',630.00,700.00,0.00,7448.54,4692580.20,4899561.20,206981.00,730234),('1','141','257978','322',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730235),('1','141','257979','322',630.00,700.00,0.00,12532.34,7895374.20,8243860.10,348485.90,730236),('1','141','257980','322',630.00,700.00,0.00,8669.84,5461999.20,5708219.75,246220.55,730237),('1','141','257981','322',630.00,700.00,0.00,3976.38,2505119.40,2608434.45,103315.05,730238),('1','141','257982','322',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730239),('1','141','257983','322',630.00,700.00,0.00,10555.26,6649813.80,6942345.45,292531.65,730240),('1','141','257984','322',630.00,700.00,0.00,6130.32,3862101.60,4044377.85,182276.25,730241),('1','141','257985','322',630.00,700.00,0.00,5508.58,3470405.40,3618472.60,148067.20,730242),('1','141','257986','322',630.00,700.00,0.00,2298.31,1447935.30,1513336.00,65400.70,730243),('1','141','257987','322',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730244),('1','141','257988','322',630.00,700.00,0.00,6967.87,4389758.10,4584570.25,194812.15,730245),('1','141','257989','322',630.00,700.00,0.00,8443.16,5319190.80,5556505.70,237314.90,730246),('1','141','257990','322',630.00,700.00,0.00,9361.66,5897845.80,6158301.40,260455.60,730247),('1','141','257991','322',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730248),('1','141','257992','322',634.00,700.00,0.00,3202.44,2030346.96,2103445.50,73098.54,730249),('1','141','257993','322',634.00,700.00,0.00,9132.99,5790315.66,6013610.25,223294.59,730250),('1','141','257994','322',634.00,700.00,0.00,6101.32,3868236.88,4013501.05,145264.17,730251),('1','141','257995','322',634.00,700.00,0.00,6134.66,3889374.44,4036678.40,147303.96,730252),('1','141','257996','322',634.00,700.00,0.00,0.00,0.00,0.00,0.00,730253),('1','141','257997','322',634.00,700.00,0.00,6188.48,3923496.32,4070871.20,147374.88,730254),('1','141','257998','322',634.00,700.00,0.00,5261.38,3335714.92,3474566.50,138851.58,730255),('1','141','257999','322',634.00,700.00,0.00,8580.60,5440100.40,5646027.15,205926.75,730256),('1','141','258000','322',634.00,700.00,0.00,4581.21,2904487.14,3015135.30,110648.16,730257),('1','141','258001','322',634.00,700.00,0.00,0.00,0.00,0.00,0.00,730258),('1','141','258002','322',634.00,700.00,0.00,11153.77,7071490.18,7319901.55,248411.37,730259),('1','141','258003','322',634.00,700.00,0.00,9520.02,6035692.68,6263037.90,227345.22,730260),('1','141','258004','322',634.00,700.00,0.00,4119.49,2611756.66,2714059.60,102302.94,730261),('1','141','258005','322',634.00,700.00,0.00,0.00,0.00,0.00,0.00,730262),('1','141','258006','322',634.00,700.00,0.00,6520.37,4133914.58,4302410.75,168496.17,730263),('1','141','258007','322',634.00,700.00,0.00,6356.05,4029735.70,4193192.65,163456.95,730264),('1','141','258008','322',634.00,700.00,0.00,7437.89,4715622.26,4912277.00,196654.74,730265),('1','141','258009','322',634.00,700.00,0.00,4301.94,2727429.96,2831730.15,104300.19,730266),('1','141','258010','322',634.00,700.00,0.00,0.00,0.00,0.00,0.00,730267),('1','141','258011','322',634.00,700.00,0.00,7168.27,4544683.18,4716613.00,171929.82,730268),('1','141','258012','322',634.00,700.00,0.00,7356.50,4664021.00,4847353.85,183332.85,730269),('1','141','258013','322',634.00,700.00,0.00,6130.38,3886660.92,4039893.30,153232.38,730270),('1','141','258014','322',634.00,700.00,0.00,3949.00,2503666.00,2598348.55,94682.55,730271),('1','141','258015','322',634.00,700.00,0.00,0.00,0.00,0.00,0.00,730272),('1','141','258016','322',634.00,700.00,0.00,4970.92,3151563.28,3268031.50,116468.22,730273),('1','141','258017','322',634.00,700.00,0.00,7627.05,4835549.70,5022812.70,187263.00,730274),('1','141','258018','322',634.00,700.00,0.00,5015.12,3179586.08,3294599.30,115013.22,730275),('1','141','258019','322',634.00,700.00,0.00,7173.54,4548024.36,4716432.00,168407.64,730276),('1','141','258020','322',634.00,700.00,0.00,0.00,0.00,0.00,0.00,730277),('1','141','258021','322',634.00,700.00,0.00,5930.48,3759924.32,3913427.30,153502.98,730278),('1','141','258022','322',634.00,700.00,0.00,5402.94,3425463.96,3556680.45,131216.49,730279),('1','141','258023','322',634.00,700.00,0.00,9960.40,6314893.60,6545152.15,230258.55,730280),('1','141','258024','322',634.00,700.00,0.00,3324.77,2107904.18,2191892.15,83987.97,730281),('1','141','258025','322',634.00,700.00,0.00,0.00,0.00,0.00,0.00,730282),('1','141','258026','322',634.00,700.00,0.00,9474.81,6007029.54,6231215.85,224186.31,730283),('1','141','258027','322',634.00,700.00,0.00,6093.02,3862974.68,4006500.35,143525.67,730284),('1','141','258028','322',634.00,700.00,0.00,6337.60,4018038.40,4173273.40,155235.00,730285),('1','141','258029','322',634.00,700.00,0.00,2718.79,1723712.86,1782626.80,58913.94,730286),('1','141','258030','322',634.00,700.00,0.00,0.00,0.00,0.00,0.00,730287),('1','141','258031','322',634.00,700.00,0.00,6221.64,3944519.76,4087082.10,142562.34,730288),('1','141','258032','322',634.00,700.00,0.00,7381.98,4680175.32,4863784.50,183609.18,730289),('1','141','258033','322',634.00,700.00,0.00,11030.60,6993400.40,7239110.00,245709.60,730290),('1','141','258034','322',634.00,700.00,0.00,0.00,0.00,0.00,0.00,730291),('1','141','258035','322',634.00,700.00,0.00,7863.02,4985154.68,5180574.35,195419.67,730292),('1','141','258036','322',634.00,700.00,0.00,8366.95,5304646.30,5499992.50,195346.20,730293),('1','141','258037','322',634.00,700.00,0.00,5492.27,3482099.18,3607943.90,125844.72,730294),('1','141','258038','322',634.00,700.00,0.00,2971.21,1883747.14,1952502.85,68755.71,730295),('1','141','258039','322',634.00,700.00,0.00,0.00,0.00,0.00,0.00,730296),('1','141','258040','322',601.00,700.00,0.00,6159.44,3701823.44,4058339.45,356516.01,730297),('1','141','258041','322',601.00,700.00,0.00,17121.22,10289853.22,11241615.10,951761.88,730298),('1','141','258042','322',601.00,700.00,0.00,1391.59,836345.59,916603.00,80257.41,730299),('1','141','258043','322',601.00,700.00,0.00,0.00,0.00,0.00,0.00,730300),('1','141','258044','322',619.00,700.00,0.00,10239.44,6338213.36,6745400.45,407187.09,730301),('1','141','258045','322',619.00,700.00,0.00,5251.48,3250666.12,3455365.00,204698.88,730302),('1','141','258046','322',619.00,700.00,0.00,9064.98,5611222.62,5966631.45,355408.83,730303),('1','141','258047','322',619.00,700.00,0.00,0.00,0.00,0.00,0.00,730304),('1','141','258048','322',619.00,700.00,0.00,5291.83,3275642.77,3490324.90,214682.13,730305),('1','141','258049','322',619.00,700.00,0.00,4785.37,2962144.03,3154411.75,192267.72,730306),('1','141','258050','322',619.00,700.00,0.00,4712.28,2916901.32,3107284.35,190383.03,730307),('1','141','258051','322',619.00,700.00,0.00,5595.22,3463441.18,3697547.20,234106.02,730308),('1','141','258052','322',619.00,700.00,0.00,4176.76,2585414.44,2744499.70,159085.26,730309),('1','141','258053','322',619.00,700.00,0.00,0.00,0.00,0.00,0.00,730310),('1','141','258054','322',619.00,700.00,0.00,7117.98,4406029.62,4688732.85,282703.23,730311),('1','141','258055','322',619.00,700.00,0.00,6453.69,3994834.11,4255022.40,260188.29,730312),('1','141','258056','322',619.00,700.00,0.00,5749.98,3559237.62,3792993.90,233756.28,730313),('1','141','258057','322',619.00,700.00,0.00,5304.43,3283442.17,3499711.00,216268.83,730314),('1','141','258058','322',619.00,700.00,0.00,0.00,0.00,0.00,0.00,730315),('1','141','258059','322',619.00,700.00,0.00,5053.30,3127992.70,3333719.20,205726.50,730316),('1','141','258060','322',619.00,700.00,0.00,6213.00,3845847.00,4099117.80,253270.80,730317),('1','141','258061','322',619.00,700.00,0.00,3218.07,1991985.33,2118951.75,126966.42,730318),('1','141','258062','322',619.00,700.00,0.00,6471.15,4005641.85,4260515.10,254873.25,730319),('1','141','258063','322',619.00,700.00,0.00,3771.66,2334657.54,2493195.60,158538.06,730320),('1','141','258064','322',619.00,700.00,0.00,0.00,0.00,0.00,0.00,730321),('1','141','258065','322',619.00,700.00,0.00,5517.46,3415307.74,3634665.10,219357.36,730322),('1','141','258066','322',619.00,700.00,0.00,7130.28,4413643.32,4703012.40,289369.08,730323),('1','141','258067','322',619.00,700.00,0.00,2890.44,1782101.49,1895666.35,113564.86,730324),('1','141','258068','322',616.00,700.00,0.00,9261.48,5705071.68,6008866.15,303794.47,730325),('1','141','258069','322',616.00,700.00,0.00,0.00,0.00,0.00,0.00,730326),('1','141','258070','322',616.00,700.00,0.00,5446.54,3355068.64,3533809.40,178740.76,730327),('1','141','258071','322',616.00,700.00,0.00,9458.70,5826559.20,6143387.50,316828.30,730328),('1','141','258072','322',616.00,700.00,0.00,5794.07,3569147.12,3771016.65,201869.53,730329),('1','141','258073','322',616.00,700.00,0.00,3890.36,2396461.76,2525881.75,129419.99,730330),('1','141','258074','322',616.00,700.00,0.00,0.00,0.00,0.00,0.00,730331),('1','141','258075','322',616.00,700.00,0.00,9632.16,5933410.56,6272918.15,339507.59,730332),('1','141','258076','322',616.00,700.00,0.00,9285.98,5720163.68,6050375.10,330211.42,730333),('1','141','258077','322',616.00,700.00,0.00,5744.44,3538575.04,3707688.85,169113.81,730334),('1','141','258078','322',616.00,700.00,0.00,0.00,0.00,0.00,0.00,730335),('1','141','258079','322',616.00,700.00,0.00,15666.92,9650822.72,10146181.85,495359.13,730336),('1','141','258080','322',616.00,700.00,0.00,5797.54,3571284.64,3776495.95,205211.31,730337),('1','141','258081','322',616.00,700.00,0.00,3156.56,1944440.96,2051952.65,107511.69,730338),('1','141','258082','322',616.00,700.00,0.00,0.00,0.00,0.00,0.00,730339),('1','141','258083','322',616.00,700.00,0.00,7610.18,4687870.88,4946913.20,259042.32,730340),('1','141','258084','322',616.00,700.00,0.00,7291.07,4491299.12,4736088.85,244789.73,730341),('1','141','258085','322',616.00,700.00,0.00,8051.42,4959674.72,5230628.05,270953.33,730342),('1','141','258086','322',616.00,700.00,0.00,1722.42,1061010.72,1120872.45,59861.73,730343),('1','141','258087','322',616.00,700.00,0.00,0.00,0.00,0.00,0.00,730344),('1','141','258088','322',616.00,700.00,0.00,6789.13,4182104.08,4414819.15,232715.07,730345),('1','141','258089','322',616.00,700.00,0.00,7443.64,4585282.24,4835974.35,250692.11,730346),('1','141','258090','322',616.00,700.00,0.00,6710.31,4133550.96,4360081.30,226530.34,730347),('1','141','258091','322',616.00,700.00,0.00,3529.60,2174233.60,2298279.60,124046.00,730348),('1','141','258092','322',616.00,700.00,0.00,0.00,0.00,0.00,0.00,730349),('1','141','258093','322',608.00,700.00,0.00,6749.30,4103574.40,4394327.40,290753.00,730350),('1','141','258094','322',608.00,700.00,0.00,6916.53,4205250.24,4504548.60,299298.36,730351),('1','141','258095','322',608.00,700.00,0.00,5051.43,3071269.44,3278667.55,207398.11,730352),('1','141','258096','322',608.00,700.00,0.00,5863.93,3565269.44,3811393.10,246123.66,730353),('1','141','258097','322',608.00,700.00,0.00,0.00,0.00,0.00,0.00,730354),('1','141','258098','322',608.00,700.00,0.00,7277.87,4424944.96,4727819.60,302874.64,730355),('1','141','258099','322',608.00,700.00,0.00,0.00,0.00,0.00,0.00,730356),('1','141','258100','322',608.00,700.00,0.00,4754.55,2890766.40,3102577.75,211811.35,730357),('1','141','258101','322',608.00,700.00,0.00,8064.27,4903076.16,5242144.25,339068.09,730358),('1','141','258102','322',608.00,700.00,0.00,4550.59,2766758.72,2953066.60,186307.88,730359),('1','141','258103','322',608.00,700.00,0.00,0.00,0.00,0.00,0.00,730360),('1','141','258104','322',608.00,700.00,0.00,4148.58,2522336.64,2697474.95,175138.31,730361),('1','141','258105','322',608.00,700.00,0.00,9921.08,6032016.64,6450137.70,418121.06,730362);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=300 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',299,'141','PRODUCT TANK','TANK CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=765 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','141','299',764,1,'322','LPG TANK',25000.00,1.00,14770.20,'TANK CONTAINING LPG','479','2020-07-25 22:47:34','2020-07-25 22:47:34','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','141',764,10930.14,'2023-03-20 18:02:41');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2716222 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2107723,'1','141','764',322,'Retail Sale Id 1253907',385060.00,0.00,0.00,0.00,40283.20,'2021-12-01 04:54:55','',''),(2107724,'1','141','764',322,'Retail sales',0.00,0.00,0.00,592.40,0.00,'2021-12-01 04:54:55','',''),(2107725,'1','141','764',322,'Retail Sale Id 1253908',6977981.50,0.00,0.00,0.00,152460.10,'2021-12-01 04:57:24','',''),(2107726,'1','141','764',322,'Retail sales',0.00,0.00,0.00,11727.70,0.00,'2021-12-01 04:57:24','',''),(2120264,'1','141','764',322,'Retail Sale Id 1259786',386360.00,0.00,0.00,0.00,40419.20,'2021-12-02 05:44:08','',''),(2120265,'1','141','764',322,'Retail sales',0.00,0.00,0.00,594.40,0.00,'2021-12-02 05:44:08','',''),(2120268,'1','141','764',322,'Retail Sale Id 1259788',3440587.50,0.00,0.00,0.00,75172.50,'2021-12-02 05:45:46','',''),(2120269,'1','141','764',322,'Retail sales',0.00,0.00,0.00,5782.50,0.00,'2021-12-02 05:45:46','',''),(2133778,'1','141','764',322,'Retail Sale Id 1266058',138580.00,0.00,0.00,0.00,14497.60,'2021-12-03 05:22:29','',''),(2133779,'1','141','764',322,'Retail sales',0.00,0.00,0.00,213.20,0.00,'2021-12-03 05:22:29','',''),(2133784,'1','141','764',322,'Retail Sale Id 1266059',3416549.50,0.00,0.00,0.00,74647.30,'2021-12-03 05:24:04','',''),(2133785,'1','141','764',322,'Retail sales',0.00,0.00,0.00,5742.10,0.00,'2021-12-03 05:24:04','',''),(2135696,'1','141','764',322,'Distributed to OPERATIONAL LOSS for sales id:336890',202361.40,0.00,0.00,347.70,0.00,'2021-12-03 07:53:46','',''),(2135758,'1','141',NULL,322,'Purchased from AA RANO NIGERIA LIMITED',0.00,7384000.00,13000.00,0.00,0.00,'2021-12-03 07:57:27','',''),(2135814,'1','141',NULL,322,'Reception corrector for bridging 126030',0.00,0.00,0.00,13000.00,0.00,'2021-12-03 08:00:29','',''),(2135815,'1','141','764',322,'Received from bridging 126030',0.00,0.00,13000.00,0.00,0.00,'2021-12-03 08:00:29','',''),(2147994,'1','141','764',322,'Retail Sale Id 1272597',424125.00,0.00,0.00,0.00,53505.00,'2021-12-04 07:23:30','',''),(2147995,'1','141','764',322,'Retail sales',0.00,0.00,0.00,652.50,0.00,'2021-12-04 07:23:30','',''),(2148066,'1','141','764',322,'Retail Sale Id 1272636',2690214.00,0.00,0.00,0.00,55659.60,'2021-12-04 07:27:06','',''),(2148067,'1','141','764',322,'Retail sales',0.00,0.00,0.00,4638.30,0.00,'2021-12-04 07:27:06','',''),(2162849,'1','141','764',322,'Retail Sale Id 1279041',556140.00,0.00,0.00,0.00,70159.20,'2021-12-05 07:07:42','',''),(2162850,'1','141','764',322,'Retail sales',0.00,0.00,0.00,855.60,0.00,'2021-12-05 07:07:42','',''),(2162885,'1','141','764',322,'Retail Sale Id 1279062',2504440.00,0.00,0.00,0.00,51816.00,'2021-12-05 07:09:27','',''),(2162886,'1','141','764',322,'Retail sales',0.00,0.00,0.00,4318.00,0.00,'2021-12-05 07:09:27','',''),(2174349,'1','141','764',322,'Retail Sale Id 1284867',156455.00,0.00,0.00,0.00,19737.40,'2021-12-05 19:24:15','',''),(2174350,'1','141','764',322,'Retail sales',0.00,0.00,0.00,240.70,0.00,'2021-12-05 19:24:15','',''),(2174353,'1','141','764',322,'Retail Sale Id 1284869',593514.00,0.00,0.00,0.00,12279.60,'2021-12-05 19:26:00','',''),(2174354,'1','141','764',322,'Retail sales',0.00,0.00,0.00,1023.30,0.00,'2021-12-05 19:26:00','',''),(2178000,'1','141','764',322,'Retail Sale Id 1286396',44330.00,0.00,0.00,0.00,5592.40,'2021-12-06 09:42:39','',''),(2178001,'1','141','764',322,'Retail sales',0.00,0.00,0.00,68.20,0.00,'2021-12-06 09:42:39','',''),(2178022,'1','141','764',322,'Retail Sale Id 1286399',610508.00,0.00,0.00,0.00,12631.20,'2021-12-06 09:43:48','',''),(2178024,'1','141','764',322,'Retail sales',0.00,0.00,0.00,1052.60,0.00,'2021-12-06 09:43:48','',''),(2178114,'1','141','764',322,'Distributed to OPERATIONAL LOSS for sales id:337446',85654.40,0.00,0.00,150.80,0.00,'2021-12-06 09:50:15','',''),(2178408,'1','141',NULL,322,'Purchased from AA RANO NIGERIA LIMITED',0.00,14171600.00,24950.00,0.00,0.00,'2021-12-06 10:08:49','',''),(2178455,'1','141',NULL,322,'Reception corrector for bridging 126364',0.00,0.00,0.00,24950.00,0.00,'2021-12-06 10:10:48','',''),(2178456,'1','141','764',322,'Received from bridging 126364',0.00,0.00,24950.00,0.00,0.00,'2021-12-06 10:10:48','',''),(2186631,'1','141','764',322,'Retail Sale Id 1290595',454220.00,0.00,0.00,0.00,57301.60,'2021-12-06 19:55:45','',''),(2186632,'1','141','764',322,'Retail sales',0.00,0.00,0.00,698.80,0.00,'2021-12-06 19:55:45','',''),(2186633,'1','141','764',322,'Retail Sale Id 1290596',3186288.00,0.00,0.00,0.00,65923.20,'2021-12-06 19:57:09','',''),(2186634,'1','141','764',322,'Retail sales',0.00,0.00,0.00,5493.60,0.00,'2021-12-06 19:57:09','',''),(2199592,'1','141','764',322,'Retail Sale Id 1296760',424905.00,0.00,0.00,0.00,53603.40,'2021-12-08 05:12:17','',''),(2199593,'1','141','764',322,'Retail sales',0.00,0.00,0.00,653.70,0.00,'2021-12-08 05:12:17','',''),(2199609,'1','141','764',322,'Retail Sale Id 1296761',3538812.00,0.00,0.00,0.00,73216.80,'2021-12-08 05:13:49','',''),(2199610,'1','141','764',322,'Retail sales',0.00,0.00,0.00,6101.40,0.00,'2021-12-08 05:13:49','',''),(2213610,'1','141','764',322,'Retail Sale Id 1303109',323245.00,0.00,0.00,0.00,40778.60,'2021-12-09 07:36:53','',''),(2213611,'1','141','764',322,'Retail sales',0.00,0.00,0.00,497.30,0.00,'2021-12-09 07:36:53','',''),(2213636,'1','141','764',322,'Retail Sale Id 1303121',3575004.00,0.00,0.00,0.00,73965.60,'2021-12-09 07:38:12','',''),(2213637,'1','141','764',322,'Retail sales',0.00,0.00,0.00,6163.80,0.00,'2021-12-09 07:38:12','',''),(2224998,'1','141','764',322,'Retail Sale Id 1308323',151710.00,0.00,0.00,0.00,19138.80,'2021-12-10 05:41:13','',''),(2224999,'1','141','764',322,'Retail sales',0.00,0.00,0.00,233.40,0.00,'2021-12-10 05:41:13','',''),(2225000,'1','141','764',322,'Retail Sale Id 1308324',2760510.00,0.00,0.00,0.00,57114.00,'2021-12-10 05:43:09','',''),(2225001,'1','141','764',322,'Retail sales',0.00,0.00,0.00,4759.50,0.00,'2021-12-10 05:43:09','',''),(2225048,'1','141','764',322,'Distributed to OPERATIONAL LOSS for sales id:338419',197948.00,0.00,0.00,348.50,0.00,'2021-12-10 05:57:50','',''),(2227004,'1','141',NULL,322,'Purchased from AA RANO NIGERIA LIMITED',0.00,13672600.00,24950.00,0.00,0.00,'2021-12-10 08:05:32','',''),(2227050,'1','141',NULL,322,'Reception corrector for bridging 126838',0.00,0.00,0.00,24950.00,0.00,'2021-12-10 08:08:07','',''),(2227051,'1','141','764',322,'Received from bridging 126838',0.00,0.00,24950.00,0.00,0.00,'2021-12-10 08:08:07','',''),(2238367,'1','141','764',322,'Retail Sale Id 1314411',448890.00,0.00,0.00,0.00,70441.20,'2021-12-11 05:43:17','',''),(2238368,'1','141','764',322,'Retail sales',0.00,0.00,0.00,690.60,0.00,'2021-12-11 05:43:17','',''),(2238371,'1','141','764',322,'Retail Sale Id 1314413',3374632.00,0.00,0.00,0.00,101537.60,'2021-12-11 05:44:42','',''),(2238372,'1','141','764',322,'Retail sales',0.00,0.00,0.00,5972.80,0.00,'2021-12-11 05:44:42','',''),(2256697,'1','141','764',322,'Retail Sale Id 1323103',536575.00,0.00,0.00,0.00,84201.00,'2021-12-12 10:52:08','',''),(2256698,'1','141','764',322,'Retail sales',0.00,0.00,0.00,825.50,0.00,'2021-12-12 10:52:08','',''),(2256924,'1','141','764',322,'Retail Sale Id 1323211',3739396.00,0.00,0.00,0.00,112512.80,'2021-12-12 11:01:17','',''),(2256925,'1','141','764',322,'Retail sales',0.00,0.00,0.00,6618.40,0.00,'2021-12-12 11:01:17','',''),(2265220,'1','141','764',322,'Retail Sale Id 1326758',17810.00,0.00,0.00,0.00,2794.80,'2021-12-13 04:50:34','',''),(2265221,'1','141','764',322,'Retail sales',0.00,0.00,0.00,27.40,0.00,'2021-12-13 04:50:34','',''),(2265222,'1','141','764',322,'Retail Sale Id 1326759',1436682.00,0.00,0.00,0.00,43227.60,'2021-12-13 04:52:31','',''),(2265223,'1','141','764',322,'Retail sales',0.00,0.00,0.00,2542.80,0.00,'2021-12-13 04:52:31','',''),(2267220,'1','141','764',322,'Retail Sale Id 1327645',650.00,0.00,0.00,0.00,102.00,'2021-12-13 08:18:47','',''),(2267221,'1','141','764',322,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-13 08:18:47','',''),(2270683,'1','141','764',322,'Retail Sale Id 1329307',3900.00,0.00,0.00,0.00,612.00,'2021-12-13 12:02:28','',''),(2270684,'1','141','764',322,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 12:02:28','',''),(2270717,'1','141','764',322,'Retail Sale Id 1329324',155375.00,0.00,0.00,0.00,4675.00,'2021-12-13 12:04:36','',''),(2270718,'1','141','764',322,'Retail sales',0.00,0.00,0.00,275.00,0.00,'2021-12-13 12:04:36','',''),(2270745,'1','141','764',322,'Retail Sale Id 1329339',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 12:07:48','',''),(2270746,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 12:07:48','',''),(2270763,'1','141','764',322,'Retail Sale Id 1329349',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 12:09:27','',''),(2270764,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 12:09:27','',''),(2270779,'1','141','764',322,'Retail Sale Id 1329357',1001.00,0.00,0.00,0.00,157.08,'2021-12-13 12:10:38','',''),(2270780,'1','141','764',322,'Retail sales',0.00,0.00,0.00,1.54,0.00,'2021-12-13 12:10:38','',''),(2270791,'1','141','764',322,'Retail Sale Id 1329370',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 12:11:50','',''),(2270792,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 12:11:50','',''),(2270807,'1','141','764',322,'Retail Sale Id 1329377',1001.00,0.00,0.00,0.00,157.08,'2021-12-13 12:13:01','',''),(2270808,'1','141','764',322,'Retail sales',0.00,0.00,0.00,1.54,0.00,'2021-12-13 12:13:01','',''),(2270841,'1','141','764',322,'Retail Sale Id 1329395',650.00,0.00,0.00,0.00,102.00,'2021-12-13 12:15:23','',''),(2270842,'1','141','764',322,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-13 12:15:23','',''),(2270879,'1','141','764',322,'Retail Sale Id 1329417',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 12:17:45','',''),(2270880,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 12:17:45','',''),(2270895,'1','141','764',322,'Retail Sale Id 1329425',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 12:18:36','',''),(2270896,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 12:18:36','',''),(2270901,'1','141','764',322,'Retail Sale Id 1329428',8125.00,0.00,0.00,0.00,1275.00,'2021-12-13 12:19:14','',''),(2270902,'1','141','764',322,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:19:14','',''),(2270933,'1','141','764',322,'Retail Sale Id 1329444',1001.00,0.00,0.00,0.00,157.08,'2021-12-13 12:20:37','',''),(2270934,'1','141','764',322,'Retail sales',0.00,0.00,0.00,1.54,0.00,'2021-12-13 12:20:37','',''),(2270949,'1','141','764',322,'Retail Sale Id 1329454',3900.00,0.00,0.00,0.00,612.00,'2021-12-13 12:22:04','',''),(2270950,'1','141','764',322,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 12:22:04','',''),(2270976,'1','141','764',322,'Retail Sale Id 1329466',3575.00,0.00,0.00,0.00,561.00,'2021-12-13 12:24:54','',''),(2270977,'1','141','764',322,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-13 12:24:54','',''),(2270994,'1','141','764',322,'Retail Sale Id 1329477',11300.00,0.00,0.00,0.00,340.00,'2021-12-13 12:26:14','',''),(2270995,'1','141','764',322,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-13 12:26:14','',''),(2271249,'1','141','764',322,'Retail Sale Id 1329626',28250.00,0.00,0.00,0.00,850.00,'2021-12-13 12:44:49','',''),(2271250,'1','141','764',322,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 12:44:49','',''),(2271300,'1','141','764',322,'Retail Sale Id 1329650',98310.00,0.00,0.00,0.00,2958.00,'2021-12-13 12:48:29','',''),(2271301,'1','141','764',322,'Retail sales',0.00,0.00,0.00,174.00,0.00,'2021-12-13 12:48:29','',''),(2271327,'1','141','764',322,'Return of Retail Sale Id 1329650',0.00,98310.00,174.00,0.00,-2958.00,'2021-12-13 12:50:18','',''),(2271334,'1','141','764',322,'Retail Sale Id 1329668',2600.00,0.00,0.00,0.00,408.00,'2021-12-13 12:51:04','',''),(2271335,'1','141','764',322,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 12:51:04','',''),(2271358,'1','141','764',322,'Retail Sale Id 1329680',1001.00,0.00,0.00,0.00,157.08,'2021-12-13 12:52:25','',''),(2271359,'1','141','764',322,'Retail sales',0.00,0.00,0.00,1.54,0.00,'2021-12-13 12:52:25','',''),(2271400,'1','141','764',322,'Retail Sale Id 1329701',8125.00,0.00,0.00,0.00,1275.00,'2021-12-13 12:54:00','',''),(2271401,'1','141','764',322,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:54:00','',''),(2271483,'1','141','764',322,'Retail Sale Id 1329741',2600.00,0.00,0.00,0.00,408.00,'2021-12-13 12:58:54','',''),(2271484,'1','141','764',322,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 12:58:54','',''),(2271515,'1','141','764',322,'Retail Sale Id 1329755',39550.00,0.00,0.00,0.00,1190.00,'2021-12-13 13:00:23','',''),(2271516,'1','141','764',322,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-13 13:00:23','',''),(2271563,'1','141','764',322,'Retail Sale Id 1329776',1300.00,0.00,0.00,0.00,204.00,'2021-12-13 13:02:58','',''),(2271564,'1','141','764',322,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 13:02:58','',''),(2271613,'1','141','764',322,'Retail Sale Id 1329797',30510.00,0.00,0.00,0.00,918.00,'2021-12-13 13:06:44','',''),(2271614,'1','141','764',322,'Retail sales',0.00,0.00,0.00,54.00,0.00,'2021-12-13 13:06:44','',''),(2271663,'1','141','764',322,'Retail Sale Id 1329825',79665.00,0.00,0.00,0.00,2397.00,'2021-12-13 13:10:11','',''),(2271664,'1','141','764',322,'Retail sales',0.00,0.00,0.00,141.00,0.00,'2021-12-13 13:10:11','',''),(2271721,'1','141','764',322,'Retail Sale Id 1329856',2502.50,0.00,0.00,0.00,392.70,'2021-12-13 13:14:51','',''),(2271722,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.85,0.00,'2021-12-13 13:14:51','',''),(2271754,'1','141','764',322,'Retail Sale Id 1329866',2260.00,0.00,0.00,0.00,68.00,'2021-12-13 13:15:49','',''),(2271755,'1','141','764',322,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 13:15:49','',''),(2271804,'1','141','764',322,'Retail Sale Id 1329890',3003.00,0.00,0.00,0.00,471.24,'2021-12-13 13:17:35','',''),(2271805,'1','141','764',322,'Retail sales',0.00,0.00,0.00,4.62,0.00,'2021-12-13 13:17:35','',''),(2271832,'1','141','764',322,'Retail Sale Id 1329904',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 13:20:33','',''),(2271833,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 13:20:33','',''),(2271933,'1','141','764',322,'Retail Sale Id 1329931',8125.00,0.00,0.00,0.00,1275.00,'2021-12-13 13:24:28','',''),(2271934,'1','141','764',322,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 13:24:28','',''),(2271966,'1','141','764',322,'Retail Sale Id 1329938',5200.00,0.00,0.00,0.00,816.00,'2021-12-13 13:25:41','',''),(2271967,'1','141','764',322,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-13 13:25:41','',''),(2271992,'1','141','764',322,'Retail Sale Id 1329952',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 13:26:58','',''),(2271993,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 13:26:58','',''),(2272008,'1','141','764',322,'Retail Sale Id 1329960',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 13:28:11','',''),(2272009,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 13:28:11','',''),(2272023,'1','141','764',322,'Retail Sale Id 1329968',3900.00,0.00,0.00,0.00,612.00,'2021-12-13 13:29:05','',''),(2272024,'1','141','764',322,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 13:29:05','',''),(2272045,'1','141','764',322,'Retail Sale Id 1329977',3900.00,0.00,0.00,0.00,612.00,'2021-12-13 13:30:16','',''),(2272046,'1','141','764',322,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 13:30:16','',''),(2272063,'1','141','764',322,'Retail Sale Id 1329985',17232.50,0.00,0.00,0.00,518.50,'2021-12-13 13:31:43','',''),(2272064,'1','141','764',322,'Retail sales',0.00,0.00,0.00,30.50,0.00,'2021-12-13 13:31:43','',''),(2272102,'1','141','764',322,'Retail Sale Id 1330001',84750.00,0.00,0.00,0.00,2550.00,'2021-12-13 13:33:49','',''),(2272103,'1','141','764',322,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-13 13:33:49','',''),(2272214,'1','141','764',322,'Retail Sale Id 1330043',2600.00,0.00,0.00,0.00,408.00,'2021-12-13 13:40:33','',''),(2272215,'1','141','764',322,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 13:40:33','',''),(2272230,'1','141','764',322,'Retail Sale Id 1330051',1001.00,0.00,0.00,0.00,157.08,'2021-12-13 13:41:34','',''),(2272231,'1','141','764',322,'Retail sales',0.00,0.00,0.00,1.54,0.00,'2021-12-13 13:41:34','',''),(2272556,'1','141','764',322,'Retail Sale Id 1330182',650.00,0.00,0.00,0.00,102.00,'2021-12-13 13:58:11','',''),(2272557,'1','141','764',322,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-13 13:58:11','',''),(2272574,'1','141','764',322,'Retail Sale Id 1330198',5650.00,0.00,0.00,0.00,170.00,'2021-12-13 13:59:33','',''),(2272575,'1','141','764',322,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 13:59:33','',''),(2272604,'1','141','764',322,'Retail Sale Id 1330213',1300.00,0.00,0.00,0.00,204.00,'2021-12-13 14:01:26','',''),(2272605,'1','141','764',322,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 14:01:26','',''),(2272788,'1','141','764',322,'Retail Sale Id 1330315',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 14:14:26','',''),(2272789,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:14:26','',''),(2272926,'1','141','764',322,'Retail Sale Id 1330433',1001.00,0.00,0.00,0.00,157.08,'2021-12-13 14:21:08','',''),(2272927,'1','141','764',322,'Retail sales',0.00,0.00,0.00,1.54,0.00,'2021-12-13 14:21:08','',''),(2272960,'1','141','764',322,'Retail Sale Id 1330444',84750.00,0.00,0.00,0.00,2550.00,'2021-12-13 14:22:53','',''),(2272961,'1','141','764',322,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-13 14:22:53','',''),(2273046,'1','141','764',322,'Retail Sale Id 1330493',56500.00,0.00,0.00,0.00,1700.00,'2021-12-13 14:28:43','',''),(2273047,'1','141','764',322,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-13 14:28:43','',''),(2273126,'1','141','764',322,'Retail Sale Id 1330530',11300.00,0.00,0.00,0.00,340.00,'2021-12-13 14:33:33','',''),(2273127,'1','141','764',322,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-13 14:33:33','',''),(2273326,'1','141','764',322,'Retail Sale Id 1330607',799.50,0.00,0.00,0.00,125.46,'2021-12-13 14:43:43','',''),(2273327,'1','141','764',322,'Retail sales',0.00,0.00,0.00,1.23,0.00,'2021-12-13 14:43:43','',''),(2273413,'1','141','764',322,'Retail Sale Id 1330659',650.00,0.00,0.00,0.00,102.00,'2021-12-13 14:50:29','',''),(2273414,'1','141','764',322,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-13 14:50:29','',''),(2273421,'1','141','764',322,'Retail Sale Id 1330663',8125.00,0.00,0.00,0.00,1275.00,'2021-12-13 14:51:14','',''),(2273422,'1','141','764',322,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 14:51:14','',''),(2273449,'1','141','764',322,'Retail Sale Id 1330676',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 14:52:44','',''),(2273450,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:52:44','',''),(2273543,'1','141','764',322,'Retail Sale Id 1330727',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 14:59:56','',''),(2273544,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:59:56','',''),(2273597,'1','141','764',322,'Retail Sale Id 1330763',45200.00,0.00,0.00,0.00,1360.00,'2021-12-13 15:04:10','',''),(2273598,'1','141','764',322,'Retail sales',0.00,0.00,0.00,80.00,0.00,'2021-12-13 15:04:10','',''),(2273637,'1','141','764',322,'Retail Sale Id 1330783',2600.00,0.00,0.00,0.00,408.00,'2021-12-13 15:06:58','',''),(2273638,'1','141','764',322,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 15:06:58','',''),(2273657,'1','141','764',322,'Retail Sale Id 1330793',1001.00,0.00,0.00,0.00,157.08,'2021-12-13 15:08:03','',''),(2273658,'1','141','764',322,'Retail sales',0.00,0.00,0.00,1.54,0.00,'2021-12-13 15:08:03','',''),(2273679,'1','141','764',322,'Retail Sale Id 1330804',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 15:08:58','',''),(2273680,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 15:08:58','',''),(2273693,'1','141','764',322,'Retail Sale Id 1330814',1300.00,0.00,0.00,0.00,204.00,'2021-12-13 15:09:56','',''),(2273694,'1','141','764',322,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 15:09:56','',''),(2273724,'1','141','764',322,'Retail Sale Id 1330830',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 15:11:26','',''),(2273725,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 15:11:26','',''),(2273736,'1','141','764',322,'Retail Sale Id 1330835',3250.00,0.00,0.00,0.00,510.00,'2021-12-13 15:12:18','',''),(2273737,'1','141','764',322,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 15:12:18','',''),(2273762,'1','141','764',322,'Retail Sale Id 1330842',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 15:13:14','',''),(2273763,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 15:13:14','',''),(2273863,'1','141','764',322,'Retail Sale Id 1330036',3003.00,0.00,0.00,0.00,471.24,'2021-12-13 15:19:58','',''),(2273864,'1','141','764',322,'Retail sales',0.00,0.00,0.00,4.62,0.00,'2021-12-13 15:19:58','',''),(2273882,'1','141','764',322,'Retail Sale Id 1330894',1300.00,0.00,0.00,0.00,204.00,'2021-12-13 15:20:54','',''),(2273883,'1','141','764',322,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 15:20:54','',''),(2273907,'1','141','764',322,'Retail Sale Id 1330906',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 15:22:01','',''),(2273908,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 15:22:01','',''),(2273947,'1','141','764',322,'Retail Sale Id 1330927',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 15:23:54','',''),(2273948,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 15:23:54','',''),(2274081,'1','141','764',322,'Retail Sale Id 1330973',3250.00,0.00,0.00,0.00,510.00,'2021-12-13 15:28:22','',''),(2274082,'1','141','764',322,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 15:28:22','',''),(2274105,'1','141','764',322,'Retail Sale Id 1330985',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 15:29:39','',''),(2274106,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 15:29:39','',''),(2274198,'1','141','764',322,'Retail Sale Id 1331024',1955860.50,0.00,0.00,0.00,58848.90,'2021-12-13 15:33:18','',''),(2274199,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3461.70,0.00,'2021-12-13 15:33:18','',''),(2274228,'1','141','764',322,'Retail Sale Id 1331038',163345.00,0.00,0.00,0.00,25632.60,'2021-12-13 15:34:34','',''),(2274229,'1','141','764',322,'Retail sales',0.00,0.00,0.00,251.30,0.00,'2021-12-13 15:34:34','',''),(2274244,'1','141','764',322,'Retail Sale Id 1331047',1300.00,0.00,0.00,0.00,204.00,'2021-12-13 15:35:42','',''),(2274245,'1','141','764',322,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 15:35:42','',''),(2274271,'1','141','764',322,'Retail Sale Id 1331059',1625.00,0.00,0.00,0.00,255.00,'2021-12-13 15:36:48','',''),(2274272,'1','141','764',322,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-13 15:36:48','',''),(2274293,'1','141','764',322,'Retail Sale Id 1331066',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 15:37:18','',''),(2274294,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 15:37:18','',''),(2274347,'1','141','764',322,'Retail Sale Id 1331091',1001.00,0.00,0.00,0.00,157.08,'2021-12-13 15:39:29','',''),(2274348,'1','141','764',322,'Retail sales',0.00,0.00,0.00,1.54,0.00,'2021-12-13 15:39:29','',''),(2274407,'1','141','764',322,'Retail Sale Id 1331119',8125.00,0.00,0.00,0.00,1275.00,'2021-12-13 15:42:06','',''),(2274408,'1','141','764',322,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 15:42:06','',''),(2274419,'1','141','764',322,'Retail Sale Id 1331133',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 15:42:33','',''),(2274420,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 15:42:33','',''),(2274447,'1','141','764',322,'Retail Sale Id 1331146',3900.00,0.00,0.00,0.00,612.00,'2021-12-13 15:44:16','',''),(2274448,'1','141','764',322,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 15:44:16','',''),(2274499,'1','141','764',322,'Retail Sale Id 1331171',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 15:46:37','',''),(2274500,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 15:46:37','',''),(2274547,'1','141','764',322,'Retail Sale Id 1331201',58000.00,0.00,0.00,0.00,3200.00,'2021-12-13 15:49:26','',''),(2274548,'1','141','764',322,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-13 15:49:26','',''),(2274561,'1','141','764',322,'Return of Retail Sale Id 1331201',0.00,58000.00,100.00,0.00,-3200.00,'2021-12-13 15:49:53','',''),(2274571,'1','141','764',322,'Retail Sale Id 1331211',56500.00,0.00,0.00,0.00,1700.00,'2021-12-13 15:50:32','',''),(2274572,'1','141','764',322,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-13 15:50:32','',''),(2274585,'1','141','764',322,'Retail Sale Id 1331219',7800.00,0.00,0.00,0.00,1224.00,'2021-12-13 15:51:05','',''),(2274586,'1','141','764',322,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-13 15:51:05','',''),(2274641,'1','141','764',322,'Retail Sale Id 1331252',4998.50,0.00,0.00,0.00,784.38,'2021-12-13 15:54:34','',''),(2274642,'1','141','764',322,'Retail sales',0.00,0.00,0.00,7.69,0.00,'2021-12-13 15:54:34','',''),(2274677,'1','141','764',322,'Retail Sale Id 1331272',73450.00,0.00,0.00,0.00,2210.00,'2021-12-13 15:56:39','',''),(2274678,'1','141','764',322,'Retail sales',0.00,0.00,0.00,130.00,0.00,'2021-12-13 15:56:39','',''),(2274710,'1','141','764',322,'Return of Retail Sale Id 1331272',0.00,73450.00,130.00,0.00,-2210.00,'2021-12-13 15:58:19','',''),(2274731,'1','141','764',322,'Retail Sale Id 1331298',3900.00,0.00,0.00,0.00,612.00,'2021-12-13 15:59:30','',''),(2274732,'1','141','764',322,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 15:59:30','',''),(2274752,'1','141','764',322,'Retail Sale Id 1331307',6500.00,0.00,0.00,0.00,1020.00,'2021-12-13 16:00:36','',''),(2274753,'1','141','764',322,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 16:00:36','',''),(2274799,'1','141','764',322,'Retail Sale Id 1331330',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 16:03:04','',''),(2274800,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 16:03:04','',''),(2274823,'1','141','764',322,'Retail Sale Id 1331343',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 16:04:23','',''),(2274824,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 16:04:23','',''),(2274841,'1','141','764',322,'Retail Sale Id 1331353',3250.00,0.00,0.00,0.00,510.00,'2021-12-13 16:05:32','',''),(2274842,'1','141','764',322,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 16:05:32','',''),(2274879,'1','141','764',322,'Retail Sale Id 1331359',101700.00,0.00,0.00,0.00,3060.00,'2021-12-13 16:07:36','',''),(2274880,'1','141','764',322,'Retail sales',0.00,0.00,0.00,180.00,0.00,'2021-12-13 16:07:36','',''),(2274895,'1','141','764',322,'Retail Sale Id 1331377',3900.00,0.00,0.00,0.00,612.00,'2021-12-13 16:08:44','',''),(2274896,'1','141','764',322,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 16:08:44','',''),(2274945,'1','141','764',322,'Retail Sale Id 1331402',84750.00,0.00,0.00,0.00,2550.00,'2021-12-13 16:11:17','',''),(2274946,'1','141','764',322,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-13 16:11:17','',''),(2275010,'1','141','764',322,'Retail Sale Id 1331432',9997.00,0.00,0.00,0.00,1568.76,'2021-12-13 16:14:23','',''),(2275011,'1','141','764',322,'Retail sales',0.00,0.00,0.00,15.38,0.00,'2021-12-13 16:14:23','',''),(2275056,'1','141','764',322,'Retail Sale Id 1331460',1001.00,0.00,0.00,0.00,157.08,'2021-12-13 16:16:56','',''),(2275057,'1','141','764',322,'Retail sales',0.00,0.00,0.00,1.54,0.00,'2021-12-13 16:16:56','',''),(2275125,'1','141','764',322,'Retail Sale Id 1331495',8125.00,0.00,0.00,0.00,1275.00,'2021-12-13 16:20:26','',''),(2275126,'1','141','764',322,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:20:26','',''),(2275149,'1','141','764',322,'Retail Sale Id 1331503',45200.00,0.00,0.00,0.00,1360.00,'2021-12-13 16:21:17','',''),(2275150,'1','141','764',322,'Retail sales',0.00,0.00,0.00,80.00,0.00,'2021-12-13 16:21:17','',''),(2275159,'1','141','764',322,'Retail Sale Id 1331508',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 16:21:57','',''),(2275160,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 16:21:57','',''),(2275183,'1','141','764',322,'Retail Sale Id 1331522',3900.00,0.00,0.00,0.00,612.00,'2021-12-13 16:22:53','',''),(2275184,'1','141','764',322,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 16:22:53','',''),(2275218,'1','141','764',322,'Retail Sale Id 1331540',1950.00,0.00,0.00,0.00,306.00,'2021-12-13 16:25:03','',''),(2275219,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 16:25:03','',''),(2275263,'1','141','764',322,'Retail Sale Id 1331563',1001.00,0.00,0.00,0.00,157.08,'2021-12-13 16:27:38','',''),(2275264,'1','141','764',322,'Retail sales',0.00,0.00,0.00,1.54,0.00,'2021-12-13 16:27:38','',''),(2275289,'1','141','764',322,'Retail Sale Id 1331576',3250.00,0.00,0.00,0.00,510.00,'2021-12-13 16:29:00','',''),(2275290,'1','141','764',322,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 16:29:00','',''),(2275332,'1','141','764',322,'Retail Sale Id 1331597',2502.50,0.00,0.00,0.00,392.70,'2021-12-13 16:31:14','',''),(2275333,'1','141','764',322,'Retail sales',0.00,0.00,0.00,3.85,0.00,'2021-12-13 16:31:14','',''),(2275356,'1','141','764',322,'Retail Sale Id 1331609',1001.00,0.00,0.00,0.00,157.08,'2021-12-13 16:32:58','',''),(2275357,'1','141','764',322,'Retail sales',0.00,0.00,0.00,1.54,0.00,'2021-12-13 16:32:58','',''),(2275370,'1','141','764',322,'Retail Sale Id 1331618',4998.50,0.00,0.00,0.00,784.38,'2021-12-13 16:33:42','',''),(2275371,'1','141','764',322,'Retail sales',0.00,0.00,0.00,7.69,0.00,'2021-12-13 16:33:42','',''),(2275606,'1','141','764',322,'Return of Retail Sale Id 1331609',0.00,1001.00,1.54,0.00,-157.08,'2021-12-13 16:49:26','',''),(2278109,'1','141','764',322,'Retail Sale Id 1332642',11520.00,0.00,0.00,0.00,2016.00,'2021-12-14 07:24:37','',''),(2278110,'1','141','764',322,'Retail sales',0.00,0.00,0.00,18.00,0.00,'2021-12-14 07:24:37','',''),(2278140,'1','141','764',322,'Retail Sale Id 1332659',5120.00,0.00,0.00,0.00,896.00,'2021-12-14 07:26:27','',''),(2278141,'1','141','764',322,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-14 07:26:27','',''),(2278184,'1','141','764',322,'Retail Sale Id 1332679',29975.00,0.00,0.00,0.00,935.00,'2021-12-14 07:29:45','',''),(2278185,'1','141','764',322,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-14 07:29:45','',''),(2278204,'1','141','764',322,'Retail Sale Id 1332692',149875.00,0.00,0.00,0.00,4675.00,'2021-12-14 07:30:53','',''),(2278205,'1','141','764',322,'Retail sales',0.00,0.00,0.00,275.00,0.00,'2021-12-14 07:30:53','',''),(2278283,'1','141','764',322,'Retail Sale Id 1332728',16000.00,0.00,0.00,0.00,2800.00,'2021-12-14 07:35:44','',''),(2278284,'1','141','764',322,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-14 07:35:44','',''),(2278317,'1','141','764',322,'Retail Sale Id 1332747',111180.00,0.00,0.00,0.00,3468.00,'2021-12-14 07:37:13','',''),(2278318,'1','141','764',322,'Retail sales',0.00,0.00,0.00,204.00,0.00,'2021-12-14 07:37:13','',''),(2278347,'1','141','764',322,'Retail Sale Id 1332764',10003.20,0.00,0.00,0.00,1750.56,'2021-12-14 07:38:45','',''),(2278348,'1','141','764',322,'Retail sales',0.00,0.00,0.00,15.63,0.00,'2021-12-14 07:38:45','',''),(2278418,'1','141','764',322,'Retail Sale Id 1332798',8000.00,0.00,0.00,0.00,1400.00,'2021-12-14 07:42:06','',''),(2278419,'1','141','764',322,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 07:42:06','',''),(2278510,'1','141','764',322,'Retail Sale Id 1332960',119900.00,0.00,0.00,0.00,3740.00,'2021-12-14 07:48:59','',''),(2278511,'1','141','764',322,'Retail sales',0.00,0.00,0.00,220.00,0.00,'2021-12-14 07:48:59','',''),(2278524,'1','141','764',322,'Retail Sale Id 1332966',260510.00,0.00,0.00,0.00,8126.00,'2021-12-14 07:50:11','',''),(2278525,'1','141','764',322,'Retail sales',0.00,0.00,0.00,478.00,0.00,'2021-12-14 07:50:11','',''),(2278558,'1','141','764',322,'Retail Sale Id 1332980',65400.00,0.00,0.00,0.00,2040.00,'2021-12-14 07:51:58','',''),(2278559,'1','141','764',322,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-14 07:51:58','',''),(2278624,'1','141','764',322,'Retail Sale Id 1333017',7630.00,0.00,0.00,0.00,238.00,'2021-12-14 07:55:55','',''),(2278625,'1','141','764',322,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-14 07:55:55','',''),(2278642,'1','141','764',322,'Retail Sale Id 1333029',294300.00,0.00,0.00,0.00,9180.00,'2021-12-14 07:56:47','',''),(2278643,'1','141','764',322,'Retail sales',0.00,0.00,0.00,540.00,0.00,'2021-12-14 07:56:47','',''),(2278726,'1','141','764',322,'Retail Sale Id 1333067',3200.00,0.00,0.00,0.00,560.00,'2021-12-14 08:00:50','',''),(2278727,'1','141','764',322,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 08:00:50','',''),(2278789,'1','141','764',322,'Retail Sale Id 1333089',2725.00,0.00,0.00,0.00,85.00,'2021-12-14 08:02:38','',''),(2278790,'1','141','764',322,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 08:02:38','',''),(2278884,'1','141','764',322,'Retail Sale Id 1333128',32700.00,0.00,0.00,0.00,1020.00,'2021-12-14 08:08:29','',''),(2278885,'1','141','764',322,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-14 08:08:29','',''),(2279403,'1','141','764',322,'Retail Sale Id 1333427',32155.00,0.00,0.00,0.00,1003.00,'2021-12-14 08:37:14','',''),(2279404,'1','141','764',322,'Retail sales',0.00,0.00,0.00,59.00,0.00,'2021-12-14 08:37:14','',''),(2279430,'1','141','764',322,'Retail Sale Id 1333443',129165.00,0.00,0.00,0.00,4029.00,'2021-12-14 08:38:22','',''),(2279431,'1','141','764',322,'Retail sales',0.00,0.00,0.00,237.00,0.00,'2021-12-14 08:38:22','',''),(2279463,'1','141','764',322,'Return of Retail Sale Id 1333443',0.00,129165.00,237.00,0.00,-4029.00,'2021-12-14 08:39:15','',''),(2280697,'1','141','764',322,'Retail Sale Id 1334009',25856.00,0.00,0.00,0.00,4524.80,'2021-12-14 09:40:20','',''),(2280698,'1','141','764',322,'Retail sales',0.00,0.00,0.00,40.40,0.00,'2021-12-14 09:40:20','',''),(2280775,'1','141','764',322,'Retail Sale Id 1334039',39414.40,0.00,0.00,0.00,1229.44,'2021-12-14 09:44:07','',''),(2280776,'1','141','764',322,'Retail sales',0.00,0.00,0.00,72.32,0.00,'2021-12-14 09:44:07','',''),(2286817,'1','141','764',322,'Distributed to OPERATIONAL LOSS for sales id:339733',169392.96,0.00,0.00,320.82,0.00,'2021-12-15 07:51:27','',''),(2286870,'1','141',NULL,322,'Purchased from AA RANO NIGERIA LIMITED',0.00,13200000.00,25000.00,0.00,0.00,'2021-12-15 07:59:06','',''),(2287002,'1','141',NULL,322,'Reception corrector for bridging 127449',0.00,0.00,0.00,25000.00,0.00,'2021-12-15 08:07:57','',''),(2287003,'1','141','764',322,'Received from bridging 127449',0.00,0.00,25000.00,0.00,0.00,'2021-12-15 08:07:57','',''),(2287081,'1','141','764',322,'Retail Sale Id 1338607',998.40,0.00,0.00,1.56,174.72,'2021-12-15 08:16:11','',''),(2287094,'1','141','764',322,'Retail Sale Id 1338619',3840.00,0.00,0.00,6.00,672.00,'2021-12-15 08:17:37','',''),(2287128,'1','141','764',322,'Retail Sale Id 1338647',119900.00,0.00,0.00,220.00,3740.00,'2021-12-15 08:19:42','',''),(2287149,'1','141','764',322,'Retail Sale Id 1338655',62947.50,0.00,0.00,115.50,1963.50,'2021-12-15 08:20:48','',''),(2287160,'1','141','764',322,'Retail Sale Id 1338665',8998.40,0.00,0.00,14.06,1574.72,'2021-12-15 08:22:34','',''),(2287166,'1','141','764',322,'Retail Sale Id 1338671',7040.00,0.00,0.00,11.00,1232.00,'2021-12-15 08:23:39','',''),(2287186,'1','141','764',322,'Retail Sale Id 1338697',33245.00,0.00,0.00,61.00,1037.00,'2021-12-15 08:26:38','',''),(2287204,'1','141','764',322,'Retail Sale Id 1338721',1280.00,0.00,0.00,2.00,224.00,'2021-12-15 08:28:32','',''),(2287211,'1','141','764',322,'Retail Sale Id 1338729',1280.00,0.00,0.00,2.00,224.00,'2021-12-15 08:29:33','',''),(2287218,'1','141','764',322,'Retail Sale Id 1338737',640.00,0.00,0.00,1.00,112.00,'2021-12-15 08:30:37','',''),(2287262,'1','141','764',322,'Retail Sale Id 1338759',3840.00,0.00,0.00,6.00,672.00,'2021-12-15 08:34:06','',''),(2287286,'1','141','764',322,'Retail Sale Id 1338779',1920.00,0.00,0.00,3.00,336.00,'2021-12-15 08:36:33','',''),(2287297,'1','141','764',322,'Retail Sale Id 1338782',3840.00,0.00,0.00,6.00,672.00,'2021-12-15 08:37:38','',''),(2287307,'1','141','764',322,'Retail Sale Id 1338794',113087.50,0.00,0.00,207.50,3527.50,'2021-12-15 08:38:42','',''),(2287337,'1','141','764',322,'Retail Sale Id 1338819',38150.00,0.00,0.00,70.00,1190.00,'2021-12-15 08:41:54','',''),(2287352,'1','141','764',322,'Retail Sale Id 1338834',12800.00,0.00,0.00,20.00,2240.00,'2021-12-15 08:43:54','',''),(2287368,'1','141','764',322,'Retail Sale Id 1338851',94285.00,0.00,0.00,173.00,2941.00,'2021-12-15 08:45:49','',''),(2287419,'1','141','764',322,'Retail Sale Id 1338900',1920.00,0.00,0.00,3.00,336.00,'2021-12-15 08:51:12','',''),(2287428,'1','141','764',322,'Retail Sale Id 1338908',285961.50,0.00,0.00,524.70,8919.90,'2021-12-15 08:52:36','',''),(2287693,'1','141','764',322,'Retail Sale Id 1339111',998.40,0.00,0.00,1.56,174.72,'2021-12-15 09:21:19','',''),(2287703,'1','141','764',322,'Retail Sale Id 1339120',998.40,0.00,0.00,1.56,174.72,'2021-12-15 09:22:49','',''),(2287713,'1','141','764',322,'Retail Sale Id 1339129',1920.00,0.00,0.00,3.00,336.00,'2021-12-15 09:23:40','',''),(2287734,'1','141','764',322,'Retail Sale Id 1339147',1920.00,0.00,0.00,3.00,336.00,'2021-12-15 09:25:52','',''),(2287742,'1','141','764',322,'Retail Sale Id 1339162',59950.00,0.00,0.00,110.00,1870.00,'2021-12-15 09:26:59','',''),(2287811,'1','141','764',322,'Retail Sale Id 1339219',998.40,0.00,0.00,1.56,174.72,'2021-12-15 09:35:29','',''),(2287840,'1','141','764',322,'Retail Sale Id 1339242',60495.00,0.00,0.00,111.00,1887.00,'2021-12-15 09:37:31','',''),(2287856,'1','141','764',322,'Retail Sale Id 1339260',54500.00,0.00,0.00,100.00,1700.00,'2021-12-15 09:40:03','',''),(2287871,'1','141','764',322,'Retail Sale Id 1339275',54500.00,0.00,0.00,100.00,1700.00,'2021-12-15 09:42:24','',''),(2287890,'1','141','764',322,'Retail Sale Id 1339283',32155.00,0.00,0.00,59.00,1003.00,'2021-12-15 09:43:38','',''),(2287930,'1','141','764',322,'Retail Sale Id 1339318',1920.00,0.00,0.00,3.00,336.00,'2021-12-15 09:48:29','',''),(2287945,'1','141','764',322,'Retail Sale Id 1339337',30792.50,0.00,0.00,56.50,960.50,'2021-12-15 09:50:58','',''),(2287965,'1','141','764',322,'Retail Sale Id 1339355',2560.00,0.00,0.00,4.00,448.00,'2021-12-15 09:53:34','',''),(2287992,'1','141','764',322,'Retail Sale Id 1339370',1497.60,0.00,0.00,2.34,262.08,'2021-12-15 09:56:19','',''),(2288010,'1','141','764',322,'Retail Sale Id 1339379',3840.00,0.00,0.00,6.00,672.00,'2021-12-15 09:57:33','',''),(2288030,'1','141','764',322,'Retail Sale Id 1339398',1920.00,0.00,0.00,3.00,336.00,'2021-12-15 10:00:15','',''),(2288035,'1','141','764',322,'Retail Sale Id 1339403',998.40,0.00,0.00,1.56,174.72,'2021-12-15 10:01:20','',''),(2288046,'1','141','764',322,'Retail Sale Id 1339414',74120.00,0.00,0.00,136.00,2312.00,'2021-12-15 10:03:04','',''),(2288075,'1','141','764',322,'Retail Sale Id 1339439',25778.50,0.00,0.00,47.30,804.10,'2021-12-15 10:07:33','',''),(2288105,'1','141','764',322,'Retail Sale Id 1339457',2003.20,0.00,0.00,3.13,350.56,'2021-12-15 10:09:07','',''),(2288116,'1','141','764',322,'Retail Sale Id 1339471',81750.00,0.00,0.00,150.00,2550.00,'2021-12-15 10:11:33','',''),(2288129,'1','141','764',322,'Retail Sale Id 1339482',38150.00,0.00,0.00,70.00,1190.00,'2021-12-15 10:13:53','',''),(2288173,'1','141','764',322,'Retail Sale Id 1339512',1280.00,0.00,0.00,2.00,224.00,'2021-12-15 10:17:52','',''),(2288184,'1','141','764',322,'Retail Sale Id 1339524',1920.00,0.00,0.00,3.00,336.00,'2021-12-15 10:19:10','',''),(2288200,'1','141','764',322,'Retail Sale Id 1339539',1920.00,0.00,0.00,3.00,336.00,'2021-12-15 10:22:57','',''),(2288210,'1','141','764',322,'Retail Sale Id 1339548',32155.00,0.00,0.00,59.00,1003.00,'2021-12-15 10:25:26','',''),(2288230,'1','141','764',322,'Retail Sale Id 1339565',2003.20,0.00,0.00,3.13,350.56,'2021-12-15 10:28:18','',''),(2288240,'1','141','764',322,'Retail Sale Id 1339577',1280.00,0.00,0.00,2.00,224.00,'2021-12-15 10:29:58','',''),(2288249,'1','141','764',322,'Retail Sale Id 1339586',109000.00,0.00,0.00,200.00,3400.00,'2021-12-15 10:31:27','',''),(2288281,'1','141','764',322,'Retail Sale Id 1339615',109000.00,0.00,0.00,200.00,3400.00,'2021-12-15 10:36:36','',''),(2288493,'1','141','764',322,'Retail Sale Id 1339779',1920.00,0.00,0.00,3.00,336.00,'2021-12-15 11:00:12','',''),(2288511,'1','141','764',322,'Retail Sale Id 1339796',3840.00,0.00,0.00,6.00,672.00,'2021-12-15 11:02:39','',''),(2288521,'1','141','764',322,'Retail Sale Id 1339814',8000.00,0.00,0.00,12.50,1400.00,'2021-12-15 11:03:56','',''),(2288532,'1','141','764',322,'Retail Sale Id 1339829',8000.00,0.00,0.00,12.50,1400.00,'2021-12-15 11:05:20','',''),(2288545,'1','141','764',322,'Retail Sale Id 1339840',87745.00,0.00,0.00,161.00,2737.00,'2021-12-15 11:06:27','',''),(2288550,'1','141','764',322,'Retail Sale Id 1339845',640.00,0.00,0.00,1.00,112.00,'2021-12-15 11:07:48','',''),(2288573,'1','141','764',322,'Retail Sale Id 1339868',8000.00,0.00,0.00,12.50,1400.00,'2021-12-15 11:11:06','',''),(2288586,'1','141','764',322,'Retail Sale Id 1339882',298660.00,0.00,0.00,548.00,9316.00,'2021-12-15 11:12:33','',''),(2288602,'1','141','764',322,'Retail Sale Id 1339891',2502.40,0.00,0.00,3.91,437.92,'2021-12-15 11:13:52','',''),(2288609,'1','141','764',322,'Retail Sale Id 1339895',998.40,0.00,0.00,1.56,174.72,'2021-12-15 11:14:55','',''),(2288620,'1','141','764',322,'Retail Sale Id 1339906',38150.00,0.00,0.00,70.00,1190.00,'2021-12-15 11:16:10','',''),(2288641,'1','141','764',322,'Retail Sale Id 1339920',83930.00,0.00,0.00,154.00,2618.00,'2021-12-15 11:18:03','',''),(2288670,'1','141','764',322,'Retail Sale Id 1339948',7680.00,0.00,0.00,12.00,1344.00,'2021-12-15 11:20:31','',''),(2288684,'1','141','764',322,'Retail Sale Id 1339961',11990.00,0.00,0.00,22.00,374.00,'2021-12-15 11:21:56','',''),(2288719,'1','141','764',322,'Retail Sale Id 1339984',4998.40,0.00,0.00,7.81,874.72,'2021-12-15 11:24:51','',''),(2288750,'1','141','764',322,'Retail Sale Id 1340009',998.40,0.00,0.00,1.56,174.72,'2021-12-15 11:28:19','',''),(2288759,'1','141','764',322,'Retail Sale Id 1340018',27250.00,0.00,0.00,50.00,850.00,'2021-12-15 11:29:37','',''),(2288769,'1','141','764',322,'Retail Sale Id 1340028',3001.60,0.00,0.00,4.69,525.28,'2021-12-15 11:31:40','',''),(2288784,'1','141','764',322,'Retail Sale Id 1340035',24525.00,0.00,0.00,45.00,765.00,'2021-12-15 11:32:34','',''),(2288808,'1','141','764',322,'Retail Sale Id 1340061',27250.00,0.00,0.00,50.00,850.00,'2021-12-15 11:35:23','',''),(2288812,'1','141','764',322,'Retail Sale Id 1340066',8000.00,0.00,0.00,12.50,1400.00,'2021-12-15 11:36:33','',''),(2288830,'1','141','764',322,'Retail Sale Id 1340080',77935.00,0.00,0.00,143.00,2431.00,'2021-12-15 11:38:31','',''),(2288849,'1','141','764',322,'Retail Sale Id 1340090',11264.00,0.00,0.00,17.60,1971.20,'2021-12-15 11:41:01','',''),(2288887,'1','141','764',322,'Retail Sale Id 1340144',77390.00,0.00,0.00,142.00,2414.00,'2021-12-15 11:47:47','',''),(2288924,'1','141','764',322,'Retail Sale Id 1340185',109000.00,0.00,0.00,200.00,3400.00,'2021-12-15 11:51:19','',''),(2289384,'1','141','764',322,'Retail Sale Id 1340627',96000.00,0.00,0.00,150.00,16800.00,'2021-12-15 12:59:36','',''),(2289390,'1','141','764',322,'Retail Sale Id 1340633',50752.00,0.00,0.00,79.30,8881.60,'2021-12-15 13:00:13','',''),(2289396,'1','141','764',322,'Retail Sale Id 1340640',1635000.00,0.00,0.00,3000.00,51000.00,'2021-12-15 13:01:20','',''),(2289400,'1','141','764',322,'Retail Sale Id 1340647',611435.50,0.00,0.00,1121.90,19072.30,'2021-12-15 13:01:55','',''),(2289584,'1','141','764',322,'Retail Sale Id 1340767',1856.00,0.00,0.00,2.90,324.80,'2021-12-15 13:20:29','',''),(2289594,'1','141','764',322,'Retail Sale Id 1340773',3200.00,0.00,0.00,5.00,560.00,'2021-12-15 13:21:45','',''),(2289597,'1','141','764',322,'Retail Sale Id 1340777',1920.00,0.00,0.00,3.00,336.00,'2021-12-15 13:22:31','',''),(2289605,'1','141','764',322,'Retail Sale Id 1340784',1472.00,0.00,0.00,2.30,257.60,'2021-12-15 13:23:24','',''),(2289615,'1','141','764',322,'Retail Sale Id 1340794',2496.00,0.00,0.00,3.90,436.80,'2021-12-15 13:24:22','',''),(2289624,'1','141','764',322,'Retail Sale Id 1340802',8512.00,0.00,0.00,13.30,1489.60,'2021-12-15 13:25:41','',''),(2289633,'1','141','764',322,'Retail Sale Id 1340811',4992.00,0.00,0.00,7.80,873.60,'2021-12-15 13:27:21','',''),(2289644,'1','141','764',322,'Retail Sale Id 1340823',8256.00,0.00,0.00,12.90,1444.80,'2021-12-15 13:29:09','',''),(2289659,'1','141','764',322,'Retail Sale Id 1340834',65127.50,0.00,0.00,119.50,2031.50,'2021-12-15 13:30:30','',''),(2289664,'1','141','764',322,'Retail Sale Id 1340839',1280.00,0.00,0.00,2.00,224.00,'2021-12-15 13:31:56','',''),(2289678,'1','141','764',322,'Retail Sale Id 1340850',3840.00,0.00,0.00,6.00,672.00,'2021-12-15 13:33:37','',''),(2289699,'1','141','764',322,'Retail Sale Id 1340872',5120.00,0.00,0.00,8.00,896.00,'2021-12-15 13:36:17','',''),(2289718,'1','141','764',322,'Retail Sale Id 1340880',3840.00,0.00,0.00,6.00,672.00,'2021-12-15 13:37:32','',''),(2289735,'1','141','764',322,'Retail Sale Id 1340892',2560.00,0.00,0.00,4.00,448.00,'2021-12-15 13:39:44','',''),(2289780,'1','141','764',322,'Retail Sale Id 1340922',61040.00,0.00,0.00,112.00,1904.00,'2021-12-15 13:44:02','',''),(2289813,'1','141','764',322,'Retail Sale Id 1340947',3840.00,0.00,0.00,6.00,672.00,'2021-12-15 13:47:04','',''),(2289841,'1','141','764',322,'Retail Sale Id 1340970',144425.00,0.00,0.00,265.00,4505.00,'2021-12-15 13:49:42','',''),(2289852,'1','141','764',322,'Retail Sale Id 1340977',3200.00,0.00,0.00,5.00,560.00,'2021-12-15 13:50:55','',''),(2289868,'1','141','764',322,'Retail Sale Id 1340988',81750.00,0.00,0.00,150.00,2550.00,'2021-12-15 13:53:16','',''),(2289900,'1','141','764',322,'Retail Sale Id 1341018',6003.20,0.00,0.00,9.38,1050.56,'2021-12-15 13:56:51','',''),(2289927,'1','141','764',322,'Retail Sale Id 1341033',27250.00,0.00,0.00,50.00,850.00,'2021-12-15 13:58:43','',''),(2289944,'1','141','764',322,'Retail Sale Id 1341055',1280.00,0.00,0.00,2.00,224.00,'2021-12-15 14:00:45','',''),(2289972,'1','141','764',322,'Retail Sale Id 1341068',1920.00,0.00,0.00,3.00,336.00,'2021-12-15 14:02:16','',''),(2289999,'1','141','764',322,'Retail Sale Id 1341076',8000.00,0.00,0.00,12.50,1400.00,'2021-12-15 14:03:44','',''),(2290056,'1','141','764',322,'Retail Sale Id 1341091',1280.00,0.00,0.00,2.00,224.00,'2021-12-15 14:05:39','',''),(2290070,'1','141','764',322,'Retail Sale Id 1341100',1920.00,0.00,0.00,3.00,336.00,'2021-12-15 14:07:12','',''),(2290096,'1','141','764',322,'Retail Sale Id 1341109',7040.00,0.00,0.00,11.00,1232.00,'2021-12-15 14:08:52','',''),(2290109,'1','141','764',322,'Retail Sale Id 1341122',4000.00,0.00,0.00,6.25,700.00,'2021-12-15 14:10:24','',''),(2290131,'1','141','764',322,'Retail Sale Id 1341133',3200.00,0.00,0.00,5.00,560.00,'2021-12-15 14:11:43','',''),(2290167,'1','141','764',322,'Retail Sale Id 1341143',640.00,0.00,0.00,1.00,112.00,'2021-12-15 14:13:08','',''),(2290181,'1','141','764',322,'Retail Sale Id 1341153',1920.00,0.00,0.00,3.00,336.00,'2021-12-15 14:14:23','',''),(2290202,'1','141','764',322,'Retail Sale Id 1341172',1280.00,0.00,0.00,2.00,224.00,'2021-12-15 14:16:08','',''),(2290234,'1','141','764',322,'Retail Sale Id 1341186',2880.00,0.00,0.00,4.50,504.00,'2021-12-15 14:18:29','',''),(2290251,'1','141','764',322,'Retail Sale Id 1341210',2560.00,0.00,0.00,4.00,448.00,'2021-12-15 14:20:36','',''),(2290435,'1','141','764',322,'Retail Sale Id 1341383',2944.00,0.00,0.00,4.60,515.20,'2021-12-15 14:42:48','',''),(2290441,'1','141','764',322,'Retail Sale Id 1341387',3200.00,0.00,0.00,5.00,560.00,'2021-12-15 14:43:50','',''),(2290459,'1','141','764',322,'Retail Sale Id 1341398',640.00,0.00,0.00,1.00,112.00,'2021-12-15 14:45:43','',''),(2290491,'1','141','764',322,'Retail Sale Id 1341417',3840.00,0.00,0.00,6.00,672.00,'2021-12-15 14:47:51','',''),(2290511,'1','141','764',322,'Retail Sale Id 1341439',54500.00,0.00,0.00,100.00,1700.00,'2021-12-15 14:50:34','',''),(2290557,'1','141','764',322,'Retail Sale Id 1341469',54500.00,0.00,0.00,100.00,1700.00,'2021-12-15 14:53:42','',''),(2290585,'1','141','764',322,'Retail Sale Id 1341494',28340.00,0.00,0.00,52.00,884.00,'2021-12-15 14:56:18','',''),(2290635,'1','141','764',322,'Retail Sale Id 1341527',3840.00,0.00,0.00,6.00,672.00,'2021-12-15 14:59:42','',''),(2290665,'1','141','764',322,'Retail Sale Id 1341545',6720.00,0.00,0.00,10.50,1176.00,'2021-12-15 15:01:31','',''),(2290685,'1','141','764',322,'Retail Sale Id 1341564',1920.00,0.00,0.00,3.00,336.00,'2021-12-15 15:03:38','',''),(2290698,'1','141','764',322,'Retail Sale Id 1341576',1600.00,0.00,0.00,2.50,280.00,'2021-12-15 15:05:20','',''),(2290743,'1','141','764',322,'Retail Sale Id 1341607',81750.00,0.00,0.00,150.00,2550.00,'2021-12-15 15:08:08','',''),(2290768,'1','141','764',322,'Retail Sale Id 1341631',998.40,0.00,0.00,1.56,174.72,'2021-12-15 15:10:47','',''),(2290779,'1','141','764',322,'Retail Sale Id 1341642',2560.00,0.00,0.00,4.00,448.00,'2021-12-15 15:12:33','',''),(2290789,'1','141','764',322,'Retail Sale Id 1341652',2003.20,0.00,0.00,3.13,350.56,'2021-12-15 15:13:56','',''),(2290799,'1','141','764',322,'Retail Sale Id 1341661',1280.00,0.00,0.00,2.00,224.00,'2021-12-15 15:15:08','',''),(2291168,'1','141','764',322,'Retail Sale Id 1341899',2560.00,0.00,0.00,4.00,448.00,'2021-12-15 15:40:08','',''),(2291189,'1','141','764',322,'Retail Sale Id 1341920',3200.00,0.00,0.00,5.00,560.00,'2021-12-15 15:42:56','',''),(2291200,'1','141','764',322,'Retail Sale Id 1341931',2560.00,0.00,0.00,4.00,448.00,'2021-12-15 15:43:54','',''),(2291218,'1','141','764',322,'Retail Sale Id 1341949',81750.00,0.00,0.00,150.00,2550.00,'2021-12-15 15:45:52','',''),(2291243,'1','141','764',322,'Retail Sale Id 1341971',38422.50,0.00,0.00,70.50,1198.50,'2021-12-15 15:48:34','',''),(2291272,'1','141','764',322,'Retail Sale Id 1342000',11840.00,0.00,0.00,18.50,2072.00,'2021-12-15 15:51:15','',''),(2291303,'1','141','764',322,'Retail Sale Id 1342026',33790.00,0.00,0.00,62.00,1054.00,'2021-12-15 15:53:45','',''),(2291333,'1','141','764',322,'Retail Sale Id 1342050',998.40,0.00,0.00,1.56,174.72,'2021-12-15 15:56:01','',''),(2291373,'1','141','764',322,'Retail Sale Id 1342071',8000.00,0.00,0.00,12.50,1400.00,'2021-12-15 15:57:20','',''),(2291387,'1','141','764',322,'Retail Sale Id 1342082',94830.00,0.00,0.00,174.00,2958.00,'2021-12-15 15:58:35','',''),(2291418,'1','141','764',322,'Retail Sale Id 1342113',1920.00,0.00,0.00,3.00,336.00,'2021-12-15 16:02:40','',''),(2291440,'1','141','764',322,'Retail Sale Id 1342132',3251.20,0.00,0.00,5.08,568.96,'2021-12-15 16:04:23','',''),(2291453,'1','141','764',322,'Retail Sale Id 1342149',1497.60,0.00,0.00,2.34,262.08,'2021-12-15 16:05:30','',''),(2291471,'1','141','764',322,'Retail Sale Id 1342171',16000.00,0.00,0.00,25.00,2800.00,'2021-12-15 16:07:30','',''),(2291485,'1','141','764',322,'Retail Sale Id 1342187',4998.40,0.00,0.00,7.81,874.72,'2021-12-15 16:10:01','',''),(2291517,'1','141','764',322,'Retail Sale Id 1342213',3200.00,0.00,0.00,5.00,560.00,'2021-12-15 16:12:11','',''),(2291529,'1','141','764',322,'Retail Sale Id 1342224',3840.00,0.00,0.00,6.00,672.00,'2021-12-15 16:13:37','',''),(2291552,'1','141','764',322,'Retail Sale Id 1342238',1497.60,0.00,0.00,2.34,262.08,'2021-12-15 16:15:17','',''),(2291577,'1','141','764',322,'Retail Sale Id 1342260',11840.00,0.00,0.00,18.50,2072.00,'2021-12-15 16:17:22','',''),(2291629,'1','141','764',322,'Retail Sale Id 1342312',64000.00,0.00,0.00,100.00,11200.00,'2021-12-15 16:21:51','',''),(2291647,'1','141','764',322,'Retail Sale Id 1342332',142517.50,0.00,0.00,261.50,4445.50,'2021-12-15 16:24:08','',''),(2292168,'1','141','764',322,'Retail Sale Id 1342798',16576.00,0.00,0.00,25.90,2900.80,'2021-12-15 17:13:45','',''),(2293699,'1','141','764',322,'Retail Sale Id 1343781',1920.00,0.00,0.00,3.00,336.00,'2021-12-16 07:20:59','',''),(2294418,'1','141','764',322,'Retail Sale Id 1344232',998.40,0.00,0.00,1.56,174.72,'2021-12-16 08:10:45','',''),(2294453,'1','141','764',322,'Retail Sale Id 1344266',136250.00,0.00,0.00,250.00,4250.00,'2021-12-16 08:13:23','',''),(2294526,'1','141','764',322,'Retail Sale Id 1344315',1920.00,0.00,0.00,3.00,336.00,'2021-12-16 08:17:35','',''),(2294598,'1','141','764',322,'Retail Sale Id 1344378',268685.00,0.00,0.00,493.00,8381.00,'2021-12-16 08:23:09','',''),(2294639,'1','141','764',322,'Retail Sale Id 1344399',5450.00,0.00,0.00,10.00,170.00,'2021-12-16 08:25:02','',''),(2294653,'1','141','764',322,'Retail Sale Id 1344412',4480.00,0.00,0.00,7.00,784.00,'2021-12-16 08:27:02','',''),(2294673,'1','141','764',322,'Retail Sale Id 1344430',1798.40,0.00,0.00,2.81,314.72,'2021-12-16 08:28:34','',''),(2294683,'1','141','764',322,'Retail Sale Id 1344439',2560.00,0.00,0.00,4.00,448.00,'2021-12-16 08:29:54','',''),(2294695,'1','141','764',322,'Retail Sale Id 1344452',8000.00,0.00,0.00,12.50,1400.00,'2021-12-16 08:31:21','',''),(2294706,'1','141','764',322,'Retail Sale Id 1344462',4499.20,0.00,0.00,7.03,787.36,'2021-12-16 08:32:35','',''),(2294726,'1','141','764',322,'Retail Sale Id 1344479',16895.00,0.00,0.00,31.00,527.00,'2021-12-16 08:34:00','',''),(2294744,'1','141','764',322,'Retail Sale Id 1344487',13625.00,0.00,0.00,25.00,425.00,'2021-12-16 08:35:03','',''),(2294781,'1','141','764',322,'Retail Sale Id 1344515',5120.00,0.00,0.00,8.00,896.00,'2021-12-16 08:37:57','',''),(2294789,'1','141','764',322,'Retail Sale Id 1344521',3840.00,0.00,0.00,6.00,672.00,'2021-12-16 08:38:42','',''),(2294818,'1','141','764',322,'Retail Sale Id 1344529',27250.00,0.00,0.00,50.00,850.00,'2021-12-16 08:39:32','',''),(2294855,'1','141','764',322,'Retail Sale Id 1344547',10624.00,0.00,0.00,16.60,1859.20,'2021-12-16 08:41:01','',''),(2294862,'1','141','764',322,'Retail Sale Id 1344555',7630.00,0.00,0.00,14.00,238.00,'2021-12-16 08:41:54','',''),(2294895,'1','141','764',322,'Retail Sale Id 1344579',37877.50,0.00,0.00,69.50,1181.50,'2021-12-16 08:44:28','',''),(2294933,'1','141','764',322,'Retail Sale Id 1344604',70032.50,0.00,0.00,128.50,2184.50,'2021-12-16 08:47:30','',''),(2294982,'1','141','764',322,'Retail Sale Id 1344642',63765.00,0.00,0.00,117.00,1989.00,'2021-12-16 08:52:03','',''),(2295022,'1','141','764',322,'Retail Sale Id 1344676',8000.00,0.00,0.00,12.50,1400.00,'2021-12-16 08:55:48','',''),(2295044,'1','141','764',322,'Retail Sale Id 1344690',138103.00,0.00,0.00,253.40,4307.80,'2021-12-16 08:57:45','',''),(2295107,'1','141','764',322,'Retail Sale Id 1344751',998.40,0.00,0.00,1.56,174.72,'2021-12-16 09:03:42','',''),(2295122,'1','141','764',322,'Retail Sale Id 1344768',83385.00,0.00,0.00,153.00,2601.00,'2021-12-16 09:05:11','',''),(2295181,'1','141','764',322,'Retail Sale Id 1344816',70032.50,0.00,0.00,128.50,2184.50,'2021-12-16 09:09:23','',''),(2295237,'1','141','764',322,'Retail Sale Id 1344867',998.40,0.00,0.00,1.56,174.72,'2021-12-16 09:14:44','',''),(2295349,'1','141','764',322,'Retail Sale Id 1344966',640.00,0.00,0.00,1.00,112.00,'2021-12-16 09:25:23','',''),(2295362,'1','141','764',322,'Retail Sale Id 1344982',163500.00,0.00,0.00,300.00,5100.00,'2021-12-16 09:26:44','',''),(2295393,'1','141','764',322,'Retail Sale Id 1345008',8000.00,0.00,0.00,12.50,1400.00,'2021-12-16 09:30:00','',''),(2295406,'1','141','764',322,'Retail Sale Id 1345021',800.00,0.00,0.00,1.25,140.00,'2021-12-16 09:31:20','',''),(2295428,'1','141','764',322,'Retail Sale Id 1345031',3840.00,0.00,0.00,6.00,672.00,'2021-12-16 09:32:28','',''),(2295445,'1','141','764',322,'Retail Sale Id 1345047',5632.00,0.00,0.00,8.80,985.60,'2021-12-16 09:34:07','',''),(2295451,'1','141','764',322,'Retail Sale Id 1345053',54500.00,0.00,0.00,100.00,1700.00,'2021-12-16 09:34:47','',''),(2295471,'1','141','764',322,'Retail Sale Id 1345074',122625.00,0.00,0.00,225.00,3825.00,'2021-12-16 09:37:30','',''),(2295485,'1','141','764',322,'Retail Sale Id 1345082',1280000.00,0.00,0.00,2000.00,224000.00,'2021-12-16 09:38:25','',''),(2295500,'1','141','764',322,'Retail Sale Id 1345097',2003.20,0.00,0.00,3.13,350.56,'2021-12-16 09:39:45','',''),(2295513,'1','141','764',322,'Retail Sale Id 1345110',3840.00,0.00,0.00,6.00,672.00,'2021-12-16 09:41:09','',''),(2295544,'1','141','764',322,'Retail Sale Id 1345129',8000.00,0.00,0.00,12.50,1400.00,'2021-12-16 09:43:49','',''),(2295560,'1','141','764',322,'Retail Sale Id 1345146',104912.50,0.00,0.00,192.50,3272.50,'2021-12-16 09:45:48','',''),(2295602,'1','141','764',322,'Retail Sale Id 1345186',27250.00,0.00,0.00,50.00,850.00,'2021-12-16 09:49:46','',''),(2295616,'1','141','764',322,'Retail Sale Id 1345193',640.00,0.00,0.00,1.00,112.00,'2021-12-16 09:51:05','',''),(2295636,'1','141','764',322,'Retail Sale Id 1345216',3200.00,0.00,0.00,5.00,560.00,'2021-12-16 09:52:55','',''),(2295667,'1','141','764',322,'Retail Sale Id 1345227',5120.00,0.00,0.00,8.00,896.00,'2021-12-16 09:54:15','',''),(2295693,'1','141','764',322,'Retail Sale Id 1345239',13440.00,0.00,0.00,21.00,2352.00,'2021-12-16 09:56:06','',''),(2295697,'1','141','764',322,'Retail Sale Id 1345243',2180.00,0.00,0.00,4.00,68.00,'2021-12-16 09:57:22','',''),(2295717,'1','141','764',322,'Retail Sale Id 1345258',123715.00,0.00,0.00,227.00,3859.00,'2021-12-16 09:59:07','',''),(2295722,'1','141','764',322,'Retail Sale Id 1345263',1280.00,0.00,0.00,2.00,224.00,'2021-12-16 09:59:53','',''),(2295748,'1','141','764',322,'Retail Sale Id 1345276',3001.60,0.00,0.00,4.69,525.28,'2021-12-16 10:01:13','',''),(2295774,'1','141','764',322,'Retail Sale Id 1345283',32700.00,0.00,0.00,60.00,1020.00,'2021-12-16 10:02:10','',''),(2295789,'1','141','764',322,'Retail Sale Id 1345294',13625.00,0.00,0.00,25.00,425.00,'2021-12-16 10:03:49','',''),(2295846,'1','141','764',322,'Retail Sale Id 1345323',34880.00,0.00,0.00,64.00,1088.00,'2021-12-16 10:07:08','',''),(2295903,'1','141','764',322,'Retail Sale Id 1345377',14848.00,0.00,0.00,23.20,2598.40,'2021-12-16 10:13:00','',''),(2295915,'1','141','764',322,'Retail Sale Id 1345385',697.60,0.00,0.00,1.09,122.08,'2021-12-16 10:14:07','',''),(2295925,'1','141','764',322,'Retail Sale Id 1345396',2502.40,0.00,0.00,3.91,437.92,'2021-12-16 10:15:24','',''),(2295936,'1','141','764',322,'Retail Sale Id 1345421',1920.00,0.00,0.00,3.00,336.00,'2021-12-16 10:16:34','',''),(2295944,'1','141','764',322,'Retail Sale Id 1345429',22890.00,0.00,0.00,42.00,714.00,'2021-12-16 10:17:59','',''),(2295950,'1','141','764',322,'Retail Sale Id 1345435',19620.00,0.00,0.00,36.00,612.00,'2021-12-16 10:18:44','',''),(2295966,'1','141','764',322,'Retail Sale Id 1345447',65400.00,0.00,0.00,120.00,2040.00,'2021-12-16 10:20:50','',''),(2295974,'1','141','764',322,'Retail Sale Id 1345453',3840.00,0.00,0.00,6.00,672.00,'2021-12-16 10:21:27','',''),(2295992,'1','141','764',322,'Retail Sale Id 1345471',35425.00,0.00,0.00,65.00,1105.00,'2021-12-16 10:23:18','',''),(2296020,'1','141','764',322,'Retail Sale Id 1345499',67961.50,0.00,0.00,124.70,2119.90,'2021-12-16 10:26:24','',''),(2296034,'1','141','764',322,'Return of Retail Sale Id 1345082',0.00,1280000.00,2000.00,0.00,-224000.00,'2021-12-16 10:27:59','',''),(2296084,'1','141','764',322,'Retail Sale Id 1345560',640.00,0.00,0.00,1.00,112.00,'2021-12-16 10:34:38','',''),(2296103,'1','141','764',322,'Retail Sale Id 1345579',111725.00,0.00,0.00,205.00,3485.00,'2021-12-16 10:37:02','',''),(2296144,'1','141','764',322,'Retail Sale Id 1345620',36787.50,0.00,0.00,67.50,1147.50,'2021-12-16 10:42:22','',''),(2296173,'1','141','764',322,'Retail Sale Id 1345650',8000.00,0.00,0.00,12.50,1400.00,'2021-12-16 10:45:14','',''),(2296178,'1','141','764',322,'Retail Sale Id 1345656',3840.00,0.00,0.00,6.00,672.00,'2021-12-16 10:46:36','',''),(2296201,'1','141','764',322,'Retail Sale Id 1345678',3200.00,0.00,0.00,5.00,560.00,'2021-12-16 10:49:16','',''),(2296227,'1','141','764',322,'Retail Sale Id 1345703',2560.00,0.00,0.00,4.00,448.00,'2021-12-16 10:52:09','',''),(2296272,'1','141','764',322,'Retail Sale Id 1345749',1280.00,0.00,0.00,2.00,224.00,'2021-12-16 10:56:40','',''),(2296287,'1','141','764',322,'Retail Sale Id 1345762',1600.00,0.00,0.00,2.50,280.00,'2021-12-16 10:58:19','',''),(2296317,'1','141','764',322,'Retail Sale Id 1345793',3897.60,0.00,0.00,6.09,682.08,'2021-12-16 11:01:46','',''),(2296330,'1','141','764',322,'Retail Sale Id 1345806',56135.00,0.00,0.00,103.00,1751.00,'2021-12-16 11:03:32','',''),(2296368,'1','141','764',322,'Retail Sale Id 1345847',3001.60,0.00,0.00,4.69,525.28,'2021-12-16 11:08:11','',''),(2296400,'1','141','764',322,'Retail Sale Id 1345869',1920.00,0.00,0.00,3.00,336.00,'2021-12-16 11:10:27','',''),(2296470,'1','141','764',322,'Retail Sale Id 1345932',109000.00,0.00,0.00,200.00,3400.00,'2021-12-16 11:19:00','',''),(2296579,'1','141','764',322,'Retail Sale Id 1346020',5760.00,0.00,0.00,9.00,1008.00,'2021-12-16 11:31:20','',''),(2296620,'1','141','764',322,'Retail Sale Id 1346062',998.40,0.00,0.00,1.56,174.72,'2021-12-16 11:36:23','',''),(2296640,'1','141','764',322,'Retail Sale Id 1346081',71940.00,0.00,0.00,132.00,2244.00,'2021-12-16 11:38:52','',''),(2296729,'1','141','764',322,'Retail Sale Id 1346171',2560.00,0.00,0.00,4.00,448.00,'2021-12-16 11:49:49','',''),(2296759,'1','141','764',322,'Retail Sale Id 1346198',109000.00,0.00,0.00,200.00,3400.00,'2021-12-16 11:52:55','',''),(2296806,'1','141','764',322,'Retail Sale Id 1346245',1280.00,0.00,0.00,2.00,224.00,'2021-12-16 11:59:11','',''),(2296812,'1','141','764',322,'Retail Sale Id 1346250',7040.00,0.00,0.00,11.00,1232.00,'2021-12-16 12:00:23','',''),(2296845,'1','141','764',322,'Retail Sale Id 1346267',960.00,0.00,0.00,1.50,168.00,'2021-12-16 12:02:33','',''),(2296871,'1','141','764',322,'Retail Sale Id 1346294',68125.00,0.00,0.00,125.00,2125.00,'2021-12-16 12:06:20','',''),(2296932,'1','141','764',322,'Retail Sale Id 1346329',998.40,0.00,0.00,1.56,174.72,'2021-12-16 12:11:09','',''),(2296945,'1','141','764',322,'Retail Sale Id 1346339',4000.00,0.00,0.00,6.25,700.00,'2021-12-16 12:12:32','',''),(2296962,'1','141','764',322,'Retail Sale Id 1346354',81750.00,0.00,0.00,150.00,2550.00,'2021-12-16 12:14:29','',''),(2296982,'1','141','764',322,'Retail Sale Id 1346371',3200.00,0.00,0.00,5.00,560.00,'2021-12-16 12:16:57','',''),(2297009,'1','141','764',322,'Retail Sale Id 1346400',16731.50,0.00,0.00,30.70,521.90,'2021-12-16 12:21:10','',''),(2297047,'1','141','764',322,'Retail Sale Id 1346436',1280.00,0.00,0.00,2.00,224.00,'2021-12-16 12:25:43','',''),(2297060,'1','141','764',322,'Retail Sale Id 1346449',27250.00,0.00,0.00,50.00,850.00,'2021-12-16 12:27:22','',''),(2297067,'1','141','764',322,'Retail Sale Id 1346455',3200.00,0.00,0.00,5.00,560.00,'2021-12-16 12:28:31','',''),(2297078,'1','141','764',322,'Retail Sale Id 1346466',3200.00,0.00,0.00,5.00,560.00,'2021-12-16 12:30:07','',''),(2297085,'1','141','764',322,'Retail Sale Id 1346473',78480.00,0.00,0.00,144.00,2448.00,'2021-12-16 12:31:25','',''),(2297113,'1','141','764',322,'Retail Sale Id 1346496',998.40,0.00,0.00,1.56,174.72,'2021-12-16 12:34:39','',''),(2297129,'1','141','764',322,'Retail Sale Id 1346507',59950.00,0.00,0.00,110.00,1870.00,'2021-12-16 12:35:58','',''),(2297154,'1','141','764',322,'Retail Sale Id 1346531',28885.00,0.00,0.00,53.00,901.00,'2021-12-16 12:38:42','',''),(2297225,'1','141','764',322,'Retail Sale Id 1346581',88017.50,0.00,0.00,161.50,2745.50,'2021-12-16 12:45:16','',''),(2297274,'1','141','764',322,'Retail Sale Id 1346630',27250.00,0.00,0.00,50.00,850.00,'2021-12-16 12:50:37','',''),(2297289,'1','141','764',322,'Retail Sale Id 1346641',3840.00,0.00,0.00,6.00,672.00,'2021-12-16 12:52:25','',''),(2297300,'1','141','764',322,'Retail Sale Id 1346652',1920.00,0.00,0.00,3.00,336.00,'2021-12-16 12:53:43','',''),(2297322,'1','141','764',322,'Retail Sale Id 1346663',1280.00,0.00,0.00,2.00,224.00,'2021-12-16 12:55:04','',''),(2297329,'1','141','764',322,'Retail Sale Id 1346671',1920.00,0.00,0.00,3.00,336.00,'2021-12-16 12:56:11','',''),(2297351,'1','141','764',322,'Retail Sale Id 1346685',3840.00,0.00,0.00,6.00,672.00,'2021-12-16 12:58:21','',''),(2297393,'1','141','764',322,'Retail Sale Id 1346723',998.40,0.00,0.00,1.56,174.72,'2021-12-16 13:04:57','',''),(2297439,'1','141','764',322,'Retail Sale Id 1346768',1920.00,0.00,0.00,3.00,336.00,'2021-12-16 13:11:23','',''),(2297504,'1','141','764',322,'Retail Sale Id 1346830',5760.00,0.00,0.00,9.00,1008.00,'2021-12-16 13:18:20','',''),(2297518,'1','141','764',322,'Retail Sale Id 1346847',6400.00,0.00,0.00,10.00,1120.00,'2021-12-16 13:20:16','',''),(2297536,'1','141','764',322,'Retail Sale Id 1346869',3840.00,0.00,0.00,6.00,672.00,'2021-12-16 13:22:20','',''),(2297555,'1','141','764',322,'Retail Sale Id 1346889',3200.00,0.00,0.00,5.00,560.00,'2021-12-16 13:24:15','',''),(2297809,'1','141','764',322,'Retail Sale Id 1347076',1472.00,0.00,0.00,2.30,257.60,'2021-12-16 13:45:54','',''),(2297831,'1','141','764',322,'Retail Sale Id 1347083',27250.00,0.00,0.00,50.00,850.00,'2021-12-16 13:46:53','',''),(2297857,'1','141','764',322,'Retail Sale Id 1347106',1920.00,0.00,0.00,3.00,336.00,'2021-12-16 13:48:47','',''),(2297864,'1','141','764',322,'Retail Sale Id 1347110',640.00,0.00,0.00,1.00,112.00,'2021-12-16 13:49:30','',''),(2297875,'1','141','764',322,'Retail Sale Id 1347122',1280.00,0.00,0.00,2.00,224.00,'2021-12-16 13:50:26','',''),(2297892,'1','141','764',322,'Retail Sale Id 1347140',1920.00,0.00,0.00,3.00,336.00,'2021-12-16 13:52:19','',''),(2297938,'1','141','764',322,'Retail Sale Id 1347182',3840.00,0.00,0.00,6.00,672.00,'2021-12-16 13:57:48','',''),(2297952,'1','141','764',322,'Retail Sale Id 1347192',1280.00,0.00,0.00,2.00,224.00,'2021-12-16 13:58:41','',''),(2297963,'1','141','764',322,'Retail Sale Id 1347201',1920.00,0.00,0.00,3.00,336.00,'2021-12-16 14:00:18','',''),(2297982,'1','141','764',322,'Retail Sale Id 1347213',1280.00,0.00,0.00,2.00,224.00,'2021-12-16 14:02:14','',''),(2298026,'1','141','764',322,'Retail Sale Id 1347242',1280.00,0.00,0.00,2.00,224.00,'2021-12-16 14:06:46','',''),(2298186,'1','141','764',322,'Retail Sale Id 1347371',3001.60,0.00,0.00,4.69,525.28,'2021-12-16 14:20:26','',''),(2298208,'1','141','764',322,'Retail Sale Id 1347386',2560.00,0.00,0.00,4.00,448.00,'2021-12-16 14:21:44','',''),(2298246,'1','141','764',322,'Retail Sale Id 1347421',640.00,0.00,0.00,1.00,112.00,'2021-12-16 14:26:27','',''),(2298355,'1','141','764',322,'Retail Sale Id 1347541',40000.00,0.00,0.00,62.50,7000.00,'2021-12-16 14:39:56','',''),(2298376,'1','141','764',322,'Retail Sale Id 1347553',3001.60,0.00,0.00,4.69,525.28,'2021-12-16 14:41:13','',''),(2298386,'1','141','764',322,'Retail Sale Id 1347562',34062.50,0.00,0.00,62.50,1062.50,'2021-12-16 14:42:35','',''),(2298448,'1','141','764',322,'Retail Sale Id 1347581',1920.00,0.00,0.00,3.00,336.00,'2021-12-16 14:44:48','',''),(2298483,'1','141','764',322,'Retail Sale Id 1347594',998.40,0.00,0.00,1.56,174.72,'2021-12-16 14:45:56','',''),(2298502,'1','141','764',322,'Retail Sale Id 1347604',3001.60,0.00,0.00,4.69,525.28,'2021-12-16 14:46:49','',''),(2298568,'1','141','764',322,'Retail Sale Id 1347635',2502.40,0.00,0.00,3.91,437.92,'2021-12-16 14:50:23','',''),(2298586,'1','141','764',322,'Retail Sale Id 1347646',2502.40,0.00,0.00,3.91,437.92,'2021-12-16 14:51:13','',''),(2298602,'1','141','764',322,'Retail Sale Id 1347662',1280.00,0.00,0.00,2.00,224.00,'2021-12-16 14:53:26','',''),(2298611,'1','141','764',322,'Retail Sale Id 1347667',3200.00,0.00,0.00,5.00,560.00,'2021-12-16 14:54:27','',''),(2298621,'1','141','764',322,'Retail Sale Id 1347680',1920.00,0.00,0.00,3.00,336.00,'2021-12-16 14:55:49','',''),(2298636,'1','141','764',322,'Retail Sale Id 1347692',1920.00,0.00,0.00,3.00,336.00,'2021-12-16 14:58:01','',''),(2298715,'1','141','764',322,'Retail Sale Id 1347767',5760.00,0.00,0.00,9.00,1008.00,'2021-12-16 15:09:02','',''),(2298776,'1','141','764',322,'Retail Sale Id 1347821',1920.00,0.00,0.00,3.00,336.00,'2021-12-16 15:14:51','',''),(2298797,'1','141','764',322,'Retail Sale Id 1347844',1920.00,0.00,0.00,3.00,336.00,'2021-12-16 15:17:24','',''),(2298839,'1','141','764',322,'Retail Sale Id 1347885',76300.00,0.00,0.00,140.00,2380.00,'2021-12-16 15:21:45','',''),(2299030,'1','141','764',322,'Retail Sale Id 1347955',1203.20,0.00,0.00,1.88,210.56,'2021-12-16 15:30:51','',''),(2299042,'1','141','764',322,'Retail Sale Id 1347982',9600.00,0.00,0.00,15.00,1680.00,'2021-12-16 15:32:14','',''),(2299062,'1','141','764',322,'Retail Sale Id 1347999',6400.00,0.00,0.00,10.00,1120.00,'2021-12-16 15:33:54','',''),(2299213,'1','141','764',322,'Retail Sale Id 1348132',2560.00,0.00,0.00,4.00,448.00,'2021-12-16 15:45:32','',''),(2299224,'1','141','764',322,'Retail Sale Id 1348149',32155.00,0.00,0.00,59.00,1003.00,'2021-12-16 15:46:37','',''),(2299272,'1','141','764',322,'Retail Sale Id 1348181',998.40,0.00,0.00,1.56,174.72,'2021-12-16 15:50:24','',''),(2299285,'1','141','764',322,'Retail Sale Id 1348192',17167.50,0.00,0.00,31.50,535.50,'2021-12-16 15:51:38','',''),(2299343,'1','141','764',322,'Retail Sale Id 1348236',640.00,0.00,0.00,1.00,112.00,'2021-12-16 15:55:04','',''),(2299402,'1','141','764',322,'Retail Sale Id 1348258',2003.20,0.00,0.00,3.13,350.56,'2021-12-16 15:57:51','',''),(2299425,'1','141','764',322,'Retail Sale Id 1348277',8000.00,0.00,0.00,12.50,1400.00,'2021-12-16 15:59:21','',''),(2299443,'1','141','764',322,'Retail Sale Id 1348297',6400.00,0.00,0.00,10.00,1120.00,'2021-12-16 16:00:46','',''),(2299489,'1','141','764',322,'Retail Sale Id 1348332',27250.00,0.00,0.00,50.00,850.00,'2021-12-16 16:04:27','',''),(2299516,'1','141','764',322,'Retail Sale Id 1348367',3840.00,0.00,0.00,6.00,672.00,'2021-12-16 16:06:24','',''),(2299529,'1','141','764',322,'Retail Sale Id 1348380',2560.00,0.00,0.00,4.00,448.00,'2021-12-16 16:08:05','',''),(2299591,'1','141','764',322,'Retail Sale Id 1348411',1280.00,0.00,0.00,2.00,224.00,'2021-12-16 16:10:30','',''),(2299670,'1','141','764',322,'Retail Sale Id 1348437',3200.00,0.00,0.00,5.00,560.00,'2021-12-16 16:12:59','',''),(2299690,'1','141','764',322,'Retail Sale Id 1348452',1920.00,0.00,0.00,3.00,336.00,'2021-12-16 16:14:26','',''),(2299753,'1','141','764',322,'Retail Sale Id 1348504',50467.00,0.00,0.00,92.60,1574.20,'2021-12-16 16:20:30','',''),(2299786,'1','141','764',322,'Retail Sale Id 1348547',19264.00,0.00,0.00,30.10,3371.20,'2021-12-16 16:23:47','',''),(2299915,'1','141','764',322,'Retail Sale Id 1348647',64.00,0.00,0.00,0.10,11.20,'2021-12-16 16:34:15','',''),(2302766,'1','141','764',322,'Retail Sale Id 1350622',1920.00,0.00,0.00,3.00,336.00,'2021-12-17 08:39:16','',''),(2302780,'1','141','764',322,'Retail Sale Id 1350637',3840.00,0.00,0.00,6.00,672.00,'2021-12-17 08:40:44','',''),(2302797,'1','141','764',322,'Retail Sale Id 1350653',8000.00,0.00,0.00,12.50,1400.00,'2021-12-17 08:42:36','',''),(2302810,'1','141','764',322,'Retail Sale Id 1350658',27250.00,0.00,0.00,50.00,850.00,'2021-12-17 08:43:50','',''),(2302867,'1','141','764',322,'Retail Sale Id 1350681',9810.00,0.00,0.00,18.00,306.00,'2021-12-17 08:47:03','',''),(2302880,'1','141','764',322,'Retail Sale Id 1350695',3200.00,0.00,0.00,5.00,560.00,'2021-12-17 08:48:27','',''),(2302894,'1','141','764',322,'Retail Sale Id 1350709',640.00,0.00,0.00,1.00,112.00,'2021-12-17 08:49:57','',''),(2302909,'1','141','764',322,'Retail Sale Id 1350719',149875.00,0.00,0.00,275.00,4675.00,'2021-12-17 08:50:56','',''),(2302974,'1','141','764',322,'Retail Sale Id 1350755',155325.00,0.00,0.00,285.00,4845.00,'2021-12-17 08:54:30','',''),(2302991,'1','141','764',322,'Retail Sale Id 1350770',84475.00,0.00,0.00,155.00,2635.00,'2021-12-17 08:56:59','',''),(2303016,'1','141','764',322,'Retail Sale Id 1350794',1280.00,0.00,0.00,2.00,224.00,'2021-12-17 08:59:17','',''),(2303043,'1','141','764',322,'Retail Sale Id 1350802',1920.00,0.00,0.00,3.00,336.00,'2021-12-17 09:00:29','',''),(2303059,'1','141','764',322,'Retail Sale Id 1350820',1920.00,0.00,0.00,3.00,336.00,'2021-12-17 09:02:13','',''),(2303078,'1','141','764',322,'Retail Sale Id 1350835',1280.00,0.00,0.00,2.00,224.00,'2021-12-17 09:03:50','',''),(2303114,'1','141','764',322,'Retail Sale Id 1350871',27250.00,0.00,0.00,50.00,850.00,'2021-12-17 09:07:58','',''),(2303150,'1','141','764',322,'Retail Sale Id 1350889',3840.00,0.00,0.00,6.00,672.00,'2021-12-17 09:10:38','',''),(2303225,'1','141','764',322,'Retail Sale Id 1350908',63220.00,0.00,0.00,116.00,1972.00,'2021-12-17 09:13:45','',''),(2303245,'1','141','764',322,'Retail Sale Id 1350928',2003.20,0.00,0.00,3.13,350.56,'2021-12-17 09:17:04','',''),(2303267,'1','141','764',322,'Retail Sale Id 1350948',104912.50,0.00,0.00,192.50,3272.50,'2021-12-17 09:19:37','',''),(2303373,'1','141','764',322,'Retail Sale Id 1351028',3840.00,0.00,0.00,6.00,672.00,'2021-12-17 09:28:26','',''),(2303387,'1','141','764',322,'Retail Sale Id 1351046',6812.50,0.00,0.00,12.50,212.50,'2021-12-17 09:30:35','',''),(2303408,'1','141','764',322,'Retail Sale Id 1351056',3840.00,0.00,0.00,6.00,672.00,'2021-12-17 09:31:52','',''),(2303420,'1','141','764',322,'Retail Sale Id 1351066',998.40,0.00,0.00,1.56,174.72,'2021-12-17 09:32:46','',''),(2303479,'1','141','764',322,'Retail Sale Id 1351108',32700.00,0.00,0.00,60.00,1020.00,'2021-12-17 09:36:02','',''),(2303579,'1','141','764',322,'Retail Sale Id 1351174',1600.00,0.00,0.00,2.50,280.00,'2021-12-17 09:44:28','',''),(2303603,'1','141','764',322,'Retail Sale Id 1351197',2252.80,0.00,0.00,3.52,394.24,'2021-12-17 09:46:26','',''),(2303611,'1','141','764',322,'Retail Sale Id 1351207',1920.00,0.00,0.00,3.00,336.00,'2021-12-17 09:47:36','',''),(2303617,'1','141','764',322,'Retail Sale Id 1351213',3840.00,0.00,0.00,6.00,672.00,'2021-12-17 09:48:20','',''),(2303628,'1','141','764',322,'Retail Sale Id 1351222',1497.60,0.00,0.00,2.34,262.08,'2021-12-17 09:49:41','',''),(2303642,'1','141','764',322,'Retail Sale Id 1351231',5120.00,0.00,0.00,8.00,896.00,'2021-12-17 09:50:39','',''),(2303677,'1','141','764',322,'Retail Sale Id 1351253',69760.00,0.00,0.00,128.00,2176.00,'2021-12-17 09:53:39','',''),(2303731,'1','141','764',322,'Retail Sale Id 1351299',3840.00,0.00,0.00,6.00,672.00,'2021-12-17 09:59:14','',''),(2303754,'1','141','764',322,'Retail Sale Id 1351321',1920.00,0.00,0.00,3.00,336.00,'2021-12-17 10:01:04','',''),(2303776,'1','141','764',322,'Retail Sale Id 1351343',4480.00,0.00,0.00,7.00,784.00,'2021-12-17 10:03:37','',''),(2303787,'1','141','764',322,'Retail Sale Id 1351396',124260.00,0.00,0.00,228.00,3876.00,'2021-12-17 10:06:08','',''),(2303821,'1','141','764',322,'Retail Sale Id 1351427',41420.00,0.00,0.00,76.00,1292.00,'2021-12-17 10:09:40','',''),(2303874,'1','141','764',322,'Retail Sale Id 1351472',3840.00,0.00,0.00,6.00,672.00,'2021-12-17 10:15:15','',''),(2303900,'1','141','764',322,'Retail Sale Id 1351494',3001.60,0.00,0.00,4.69,525.28,'2021-12-17 10:17:46','',''),(2303909,'1','141','764',322,'Retail Sale Id 1351505',3001.60,0.00,0.00,4.69,525.28,'2021-12-17 10:18:39','',''),(2303922,'1','141','764',322,'Retail Sale Id 1351517',998.40,0.00,0.00,1.56,174.72,'2021-12-17 10:19:40','',''),(2303936,'1','141','764',322,'Retail Sale Id 1351528',1920.00,0.00,0.00,3.00,336.00,'2021-12-17 10:21:45','',''),(2303973,'1','141','764',322,'Retail Sale Id 1351563',6812.50,0.00,0.00,12.50,212.50,'2021-12-17 10:26:16','',''),(2303984,'1','141','764',322,'Retail Sale Id 1351575',4480.00,0.00,0.00,7.00,784.00,'2021-12-17 10:27:42','',''),(2304065,'1','141','764',322,'Retail Sale Id 1351643',30520.00,0.00,0.00,56.00,952.00,'2021-12-17 10:36:41','',''),(2304087,'1','141','764',322,'Retail Sale Id 1351667',30520.00,0.00,0.00,56.00,952.00,'2021-12-17 10:39:40','',''),(2304104,'1','141','764',322,'Retail Sale Id 1351685',998.40,0.00,0.00,1.56,174.72,'2021-12-17 10:41:48','',''),(2304115,'1','141','764',322,'Retail Sale Id 1351696',32700.00,0.00,0.00,60.00,1020.00,'2021-12-17 10:43:07','',''),(2304144,'1','141','764',322,'Retail Sale Id 1351725',65400.00,0.00,0.00,120.00,2040.00,'2021-12-17 10:46:27','',''),(2304172,'1','141','764',322,'Retail Sale Id 1351757',2560.00,0.00,0.00,4.00,448.00,'2021-12-17 10:50:04','',''),(2304218,'1','141','764',322,'Retail Sale Id 1351802',640.00,0.00,0.00,1.00,112.00,'2021-12-17 10:56:10','',''),(2304223,'1','141','764',322,'Retail Sale Id 1351808',998.40,0.00,0.00,1.56,174.72,'2021-12-17 10:57:34','',''),(2304312,'1','141','764',322,'Retail Sale Id 1351886',1280.00,0.00,0.00,2.00,224.00,'2021-12-17 11:05:25','',''),(2304327,'1','141','764',322,'Retail Sale Id 1351900',1798.40,0.00,0.00,2.81,314.72,'2021-12-17 11:06:48','',''),(2304337,'1','141','764',322,'Retail Sale Id 1351910',6400.00,0.00,0.00,10.00,1120.00,'2021-12-17 11:08:17','',''),(2304366,'1','141','764',322,'Retail Sale Id 1351940',89925.00,0.00,0.00,165.00,2805.00,'2021-12-17 11:10:59','',''),(2304391,'1','141','764',322,'Retail Sale Id 1351967',17440.00,0.00,0.00,32.00,544.00,'2021-12-17 11:13:59','',''),(2304422,'1','141','764',322,'Retail Sale Id 1351992',2003.20,0.00,0.00,3.13,350.56,'2021-12-17 11:16:23','',''),(2304557,'1','141','764',322,'Retail Sale Id 1352099',163500.00,0.00,0.00,300.00,5100.00,'2021-12-17 11:26:50','',''),(2304589,'1','141','764',322,'Retail Sale Id 1352120',27250.00,0.00,0.00,50.00,850.00,'2021-12-17 11:29:10','',''),(2304629,'1','141','764',322,'Retail Sale Id 1352173',3840.00,0.00,0.00,6.00,672.00,'2021-12-17 11:33:45','',''),(2304649,'1','141','764',322,'Retail Sale Id 1352189',2003.20,0.00,0.00,3.13,350.56,'2021-12-17 11:35:16','',''),(2304674,'1','141','764',322,'Retail Sale Id 1352213',640.00,0.00,0.00,1.00,112.00,'2021-12-17 11:38:51','',''),(2304686,'1','141','764',322,'Retail Sale Id 1352227',998.40,0.00,0.00,1.56,174.72,'2021-12-17 11:41:08','',''),(2304749,'1','141','764',322,'Retail Sale Id 1352304',626750.00,0.00,0.00,1150.00,19550.00,'2021-12-17 11:48:26','',''),(2304758,'1','141','764',322,'Retail Sale Id 1352308',3840.00,0.00,0.00,6.00,672.00,'2021-12-17 11:49:33','',''),(2304759,'1','141','764',322,'Retail Sale Id 1352311',5120.00,0.00,0.00,8.00,896.00,'2021-12-17 11:50:13','',''),(2304796,'1','141','764',322,'Retail Sale Id 1352339',1497.60,0.00,0.00,2.34,262.08,'2021-12-17 11:54:18','',''),(2304807,'1','141','764',322,'Retail Sale Id 1352348',65400.00,0.00,0.00,120.00,2040.00,'2021-12-17 11:55:23','',''),(2304840,'1','141','764',322,'Retail Sale Id 1352371',78752.50,0.00,0.00,144.50,2456.50,'2021-12-17 11:59:42','',''),(2304911,'1','141','764',322,'Retail Sale Id 1352429',75482.50,0.00,0.00,138.50,2354.50,'2021-12-17 12:06:41','',''),(2304942,'1','141','764',322,'Retail Sale Id 1352455',41965.00,0.00,0.00,77.00,1309.00,'2021-12-17 12:12:18','',''),(2304974,'1','141','764',322,'Retail Sale Id 1352472',89925.00,0.00,0.00,165.00,2805.00,'2021-12-17 12:17:06','',''),(2304997,'1','141','764',322,'Retail Sale Id 1352519',1497.60,0.00,0.00,2.34,262.08,'2021-12-17 12:20:35','',''),(2305024,'1','141','764',322,'Retail Sale Id 1352551',1920.00,0.00,0.00,3.00,336.00,'2021-12-17 12:26:12','',''),(2305038,'1','141','764',322,'Retail Sale Id 1352564',116992.00,0.00,0.00,182.80,20473.60,'2021-12-17 12:28:35','',''),(2305050,'1','141','764',322,'Retail Sale Id 1352574',81750.00,0.00,0.00,150.00,2550.00,'2021-12-17 12:29:36','',''),(2305069,'1','141','764',322,'Retail Sale Id 1352589',69760.00,0.00,0.00,128.00,2176.00,'2021-12-17 12:33:37','',''),(2305146,'1','141','764',322,'Retail Sale Id 1352647',3001.60,0.00,0.00,4.69,525.28,'2021-12-17 12:42:27','',''),(2305174,'1','141','764',322,'Retail Sale Id 1352672',8000.00,0.00,0.00,12.50,1400.00,'2021-12-17 12:46:37','',''),(2305194,'1','141','764',322,'Retail Sale Id 1352692',101097.50,0.00,0.00,185.50,3153.50,'2021-12-17 12:50:15','',''),(2305381,'1','141','764',322,'Retail Sale Id 1352891',640.00,0.00,0.00,1.00,112.00,'2021-12-17 13:19:27','',''),(2305893,'1','141',NULL,322,'Purchased from AA RANO NIGERIA LIMITED',0.00,110880.00,210.00,0.00,0.00,'2021-12-17 14:12:23','',''),(2305913,'1','141',NULL,322,'Reception corrector for bridging 127746',0.00,0.00,0.00,210.00,0.00,'2021-12-17 14:14:56','',''),(2305914,'1','141','764',322,'Received from bridging 127746',0.00,0.00,210.00,0.00,0.00,'2021-12-17 14:14:56','',''),(2306173,'1','141','764',322,'Retail Sale Id 1353476',26880.00,0.00,0.00,42.00,4704.00,'2021-12-17 14:41:58','',''),(2306251,'1','141','764',322,'Retail Sale Id 1353548',907970.00,0.00,0.00,1666.00,28322.00,'2021-12-17 14:46:06','',''),(2309775,'1','141','764',322,'Retail Sale Id 1356058',314884.65,0.00,0.00,577.77,9822.09,'2021-12-18 07:23:44','',''),(2309839,'1','141','764',322,'Return of Retail Sale Id 1353476',0.00,26880.00,42.00,0.00,-4704.00,'2021-12-18 07:29:48','',''),(2309865,'1','141','764',322,'Retail Sale Id 1356129',10969.60,0.00,0.00,17.14,1919.68,'2021-12-18 07:32:25','',''),(2310097,'1','141','764',322,'Distributed to OPERATIONAL LOSS for sales id:340577',179498.88,0.00,0.00,339.96,0.00,'2021-12-18 07:50:05','',''),(2310121,'1','141',NULL,322,'Purchased from AA RANO NIGERIA LIMITED',0.00,11267520.00,21340.00,0.00,0.00,'2021-12-18 07:52:41','',''),(2310140,'1','141',NULL,322,'Reception corrector for bridging 127830',0.00,0.00,0.00,21340.00,0.00,'2021-12-18 07:54:10','',''),(2310141,'1','141','764',322,'Received from bridging 127830',0.00,0.00,21340.00,0.00,0.00,'2021-12-18 07:54:10','',''),(2310258,'1','141','764',322,'Retail Sale Id 1356458',998.40,0.00,0.00,1.56,174.72,'2021-12-18 08:06:07','',''),(2310271,'1','141','764',322,'Retail Sale Id 1356471',3200.00,0.00,0.00,5.00,560.00,'2021-12-18 08:07:02','',''),(2310292,'1','141','764',322,'Retail Sale Id 1356483',3840.00,0.00,0.00,6.00,672.00,'2021-12-18 08:08:03','',''),(2310318,'1','141','764',322,'Retail Sale Id 1356500',4480.00,0.00,0.00,7.00,784.00,'2021-12-18 08:10:33','',''),(2310349,'1','141','764',322,'Retail Sale Id 1356510',2725.00,0.00,0.00,5.00,85.00,'2021-12-18 08:11:50','',''),(2310377,'1','141','764',322,'Retail Sale Id 1356523',8000.00,0.00,0.00,12.50,1400.00,'2021-12-18 08:13:52','',''),(2310414,'1','141','764',322,'Retail Sale Id 1356559',21800.00,0.00,0.00,40.00,680.00,'2021-12-18 08:17:50','',''),(2310457,'1','141','764',322,'Retail Sale Id 1356604',2180.00,0.00,0.00,4.00,68.00,'2021-12-18 08:21:58','',''),(2310475,'1','141','764',322,'Retail Sale Id 1356621',6400.00,0.00,0.00,10.00,1120.00,'2021-12-18 08:23:41','',''),(2310521,'1','141','764',322,'Retail Sale Id 1356635',10240.00,0.00,0.00,16.00,1792.00,'2021-12-18 08:24:59','',''),(2310533,'1','141','764',322,'Retail Sale Id 1356648',6400.00,0.00,0.00,10.00,1120.00,'2021-12-18 08:25:47','',''),(2310543,'1','141','764',322,'Retail Sale Id 1356658',5888.00,0.00,0.00,9.20,1030.40,'2021-12-18 08:26:33','',''),(2310556,'1','141','764',322,'Retail Sale Id 1356670',3840.00,0.00,0.00,6.00,672.00,'2021-12-18 08:27:24','',''),(2310635,'1','141','764',322,'Retail Sale Id 1356727',133525.00,0.00,0.00,245.00,4165.00,'2021-12-18 08:32:48','',''),(2310651,'1','141','764',322,'Retail Sale Id 1356744',8000.00,0.00,0.00,12.50,1400.00,'2021-12-18 08:34:32','',''),(2310663,'1','141','764',322,'Retail Sale Id 1356758',8000.00,0.00,0.00,12.50,1400.00,'2021-12-18 08:35:43','',''),(2310676,'1','141','764',322,'Retail Sale Id 1356771',109000.00,0.00,0.00,200.00,3400.00,'2021-12-18 08:37:05','',''),(2310685,'1','141','764',322,'Retail Sale Id 1356781',640.00,0.00,0.00,1.00,112.00,'2021-12-18 08:38:00','',''),(2310704,'1','141','764',322,'Retail Sale Id 1356800',8000.00,0.00,0.00,12.50,1400.00,'2021-12-18 08:39:21','',''),(2310719,'1','141','764',322,'Retail Sale Id 1356814',5722.50,0.00,0.00,10.50,178.50,'2021-12-18 08:40:30','',''),(2310744,'1','141','764',322,'Retail Sale Id 1356839',129165.00,0.00,0.00,237.00,4029.00,'2021-12-18 08:42:41','',''),(2310789,'1','141','764',322,'Retail Sale Id 1356882',3001.60,0.00,0.00,4.69,525.28,'2021-12-18 08:47:35','',''),(2310800,'1','141','764',322,'Retail Sale Id 1356892',3840.00,0.00,0.00,6.00,672.00,'2021-12-18 08:48:39','',''),(2310825,'1','141','764',322,'Retail Sale Id 1356918',8000.00,0.00,0.00,12.50,1400.00,'2021-12-18 08:50:40','',''),(2310839,'1','141','764',322,'Retail Sale Id 1356934',8320.00,0.00,0.00,13.00,1456.00,'2021-12-18 08:52:02','',''),(2310866,'1','141','764',322,'Retail Sale Id 1356960',7296.00,0.00,0.00,11.40,1276.80,'2021-12-18 08:53:51','',''),(2310880,'1','141','764',322,'Retail Sale Id 1356975',110635.00,0.00,0.00,203.00,3451.00,'2021-12-18 08:55:08','',''),(2310887,'1','141','764',322,'Retail Sale Id 1356980',640.00,0.00,0.00,1.00,112.00,'2021-12-18 08:55:39','',''),(2310910,'1','141','764',322,'Retail Sale Id 1356994',8000.00,0.00,0.00,12.50,1400.00,'2021-12-18 08:57:15','',''),(2310918,'1','141','764',322,'Retail Sale Id 1357003',3270.00,0.00,0.00,6.00,102.00,'2021-12-18 08:57:48','',''),(2310935,'1','141','764',322,'Retail Sale Id 1357012',1920.00,0.00,0.00,3.00,336.00,'2021-12-18 08:58:50','',''),(2310953,'1','141','764',322,'Retail Sale Id 1357037',2560.00,0.00,0.00,4.00,448.00,'2021-12-18 09:00:20','',''),(2310964,'1','141','764',322,'Retail Sale Id 1357046',640.00,0.00,0.00,1.00,112.00,'2021-12-18 09:01:36','',''),(2311005,'1','141','764',322,'Retail Sale Id 1357071',54500.00,0.00,0.00,100.00,1700.00,'2021-12-18 09:04:10','',''),(2311016,'1','141','764',322,'Retail Sale Id 1357083',640.00,0.00,0.00,1.00,112.00,'2021-12-18 09:05:44','',''),(2311029,'1','141','764',322,'Retail Sale Id 1357095',4800.00,0.00,0.00,7.50,840.00,'2021-12-18 09:07:01','',''),(2311036,'1','141','764',322,'Retail Sale Id 1357101',26160.00,0.00,0.00,48.00,816.00,'2021-12-18 09:07:43','',''),(2311046,'1','141','764',322,'Retail Sale Id 1357109',8000.00,0.00,0.00,12.50,1400.00,'2021-12-18 09:08:20','',''),(2311056,'1','141','764',322,'Retail Sale Id 1357121',4416.00,0.00,0.00,6.90,772.80,'2021-12-18 09:09:24','',''),(2311073,'1','141','764',322,'Retail Sale Id 1357129',129165.00,0.00,0.00,237.00,4029.00,'2021-12-18 09:10:03','',''),(2311081,'1','141','764',322,'Retail Sale Id 1357135',176307.50,0.00,0.00,323.50,5499.50,'2021-12-18 09:10:50','',''),(2311107,'1','141','764',322,'Retail Sale Id 1357155',7680.00,0.00,0.00,12.00,1344.00,'2021-12-18 09:11:52','',''),(2311111,'1','141','764',322,'Retail Sale Id 1357158',3840.00,0.00,0.00,6.00,672.00,'2021-12-18 09:12:25','',''),(2311139,'1','141','764',322,'Retail Sale Id 1357172',1497.60,0.00,0.00,2.34,262.08,'2021-12-18 09:13:39','',''),(2311163,'1','141','764',322,'Retail Sale Id 1357181',1280.00,0.00,0.00,2.00,224.00,'2021-12-18 09:14:55','',''),(2311181,'1','141','764',322,'Retail Sale Id 1357194',3840.00,0.00,0.00,6.00,672.00,'2021-12-18 09:16:14','',''),(2311224,'1','141','764',322,'Retail Sale Id 1357232',297570.00,0.00,0.00,546.00,9282.00,'2021-12-18 09:21:22','',''),(2311240,'1','141','764',322,'Retail Sale Id 1357248',998.40,0.00,0.00,1.56,174.72,'2021-12-18 09:23:22','',''),(2311261,'1','141','764',322,'Retail Sale Id 1357268',9600.00,0.00,0.00,15.00,1680.00,'2021-12-18 09:25:32','',''),(2311287,'1','141','764',322,'Retail Sale Id 1357299',2598.40,0.00,0.00,4.06,454.72,'2021-12-18 09:27:51','',''),(2311307,'1','141','764',322,'Retail Sale Id 1357321',163500.00,0.00,0.00,300.00,5100.00,'2021-12-18 09:29:52','',''),(2311324,'1','141','764',322,'Retail Sale Id 1357337',1280.00,0.00,0.00,2.00,224.00,'2021-12-18 09:31:42','',''),(2311335,'1','141','764',322,'Retail Sale Id 1357348',1702.40,0.00,0.00,2.66,297.92,'2021-12-18 09:32:47','',''),(2311351,'1','141','764',322,'Retail Sale Id 1357370',14987.50,0.00,0.00,27.50,467.50,'2021-12-18 09:34:22','',''),(2311372,'1','141','764',322,'Retail Sale Id 1357389',6400.00,0.00,0.00,10.00,1120.00,'2021-12-18 09:36:32','',''),(2311388,'1','141','764',322,'Retail Sale Id 1357405',38150.00,0.00,0.00,70.00,1190.00,'2021-12-18 09:38:08','',''),(2311421,'1','141','764',322,'Retail Sale Id 1357428',640.00,0.00,0.00,1.00,112.00,'2021-12-18 09:41:24','',''),(2311433,'1','141','764',322,'Retail Sale Id 1357447',8000.00,0.00,0.00,12.50,1400.00,'2021-12-18 09:42:33','',''),(2311447,'1','141','764',322,'Retail Sale Id 1357460',10627.50,0.00,0.00,19.50,331.50,'2021-12-18 09:44:02','',''),(2311501,'1','141','764',322,'Retail Sale Id 1357513',3200.00,0.00,0.00,5.00,560.00,'2021-12-18 09:49:00','',''),(2311525,'1','141','764',322,'Retail Sale Id 1357536',3200.00,0.00,0.00,5.00,560.00,'2021-12-18 09:51:03','',''),(2311544,'1','141','764',322,'Retail Sale Id 1357550',1920.00,0.00,0.00,3.00,336.00,'2021-12-18 09:52:37','',''),(2311569,'1','141','764',322,'Retail Sale Id 1357572',43600.00,0.00,0.00,80.00,1360.00,'2021-12-18 09:54:02','',''),(2311616,'1','141','764',322,'Retail Sale Id 1357590',1920.00,0.00,0.00,3.00,336.00,'2021-12-18 09:56:11','',''),(2311633,'1','141','764',322,'Retail Sale Id 1357603',640.00,0.00,0.00,1.00,112.00,'2021-12-18 09:57:30','',''),(2311654,'1','141','764',322,'Retail Sale Id 1357622',55045.00,0.00,0.00,101.00,1717.00,'2021-12-18 09:59:13','',''),(2311673,'1','141','764',322,'Retail Sale Id 1357640',2003.20,0.00,0.00,3.13,350.56,'2021-12-18 10:01:46','',''),(2311681,'1','141','764',322,'Retail Sale Id 1357649',1920.00,0.00,0.00,3.00,336.00,'2021-12-18 10:03:05','',''),(2311698,'1','141','764',322,'Retail Sale Id 1357660',3840.00,0.00,0.00,6.00,672.00,'2021-12-18 10:04:36','',''),(2311712,'1','141','764',322,'Retail Sale Id 1357678',109000.00,0.00,0.00,200.00,3400.00,'2021-12-18 10:06:28','',''),(2311724,'1','141','764',322,'Retail Sale Id 1357687',998.40,0.00,0.00,1.56,174.72,'2021-12-18 10:07:18','',''),(2311760,'1','141','764',322,'Retail Sale Id 1357718',7680.00,0.00,0.00,12.00,1344.00,'2021-12-18 10:10:19','',''),(2311779,'1','141','764',322,'Retail Sale Id 1357737',1798.40,0.00,0.00,2.81,314.72,'2021-12-18 10:12:55','',''),(2311827,'1','141','764',322,'Retail Sale Id 1357764',2560.00,0.00,0.00,4.00,448.00,'2021-12-18 10:16:52','',''),(2311884,'1','141','764',322,'Retail Sale Id 1357802',3200.00,0.00,0.00,5.00,560.00,'2021-12-18 10:20:39','',''),(2311970,'1','141','764',322,'Retail Sale Id 1357877',2003.20,0.00,0.00,3.13,350.56,'2021-12-18 10:26:53','',''),(2312061,'1','141','764',322,'Retail Sale Id 1357953',1280.00,0.00,0.00,2.00,224.00,'2021-12-18 10:34:22','',''),(2312084,'1','141','764',322,'Retail Sale Id 1357981',998.40,0.00,0.00,1.56,174.72,'2021-12-18 10:36:01','',''),(2312107,'1','141','764',322,'Retail Sale Id 1358004',54500.00,0.00,0.00,100.00,1700.00,'2021-12-18 10:37:20','',''),(2312131,'1','141','764',322,'Retail Sale Id 1358028',22617.50,0.00,0.00,41.50,705.50,'2021-12-18 10:39:40','',''),(2312156,'1','141','764',322,'Retail Sale Id 1358053',3840.00,0.00,0.00,6.00,672.00,'2021-12-18 10:41:39','',''),(2312176,'1','141','764',322,'Retail Sale Id 1358078',1920.00,0.00,0.00,3.00,336.00,'2021-12-18 10:43:29','',''),(2312195,'1','141','764',322,'Retail Sale Id 1358095',3200.00,0.00,0.00,5.00,560.00,'2021-12-18 10:45:15','',''),(2312212,'1','141','764',322,'Retail Sale Id 1358113',3001.60,0.00,0.00,4.69,525.28,'2021-12-18 10:47:06','',''),(2312241,'1','141','764',322,'Retail Sale Id 1358139',1497.60,0.00,0.00,2.34,262.08,'2021-12-18 10:49:43','',''),(2312264,'1','141','764',322,'Retail Sale Id 1358152',640.00,0.00,0.00,1.00,112.00,'2021-12-18 10:50:53','',''),(2312281,'1','141','764',322,'Retail Sale Id 1358168',8000.00,0.00,0.00,12.50,1400.00,'2021-12-18 10:52:23','',''),(2312305,'1','141','764',322,'Retail Sale Id 1358189',998.40,0.00,0.00,1.56,174.72,'2021-12-18 10:54:10','',''),(2312322,'1','141','764',322,'Retail Sale Id 1358204',1920.00,0.00,0.00,3.00,336.00,'2021-12-18 10:55:40','',''),(2312341,'1','141','764',322,'Retail Sale Id 1358227',3840.00,0.00,0.00,6.00,672.00,'2021-12-18 10:57:29','',''),(2312375,'1','141','764',322,'Retail Sale Id 1358251',1920.00,0.00,0.00,3.00,336.00,'2021-12-18 11:00:08','',''),(2312398,'1','141','764',322,'Retail Sale Id 1358271',101370.00,0.00,0.00,186.00,3162.00,'2021-12-18 11:01:58','',''),(2312425,'1','141','764',322,'Retail Sale Id 1358296',3200.00,0.00,0.00,5.00,560.00,'2021-12-18 11:04:26','',''),(2312489,'1','141','764',322,'Retail Sale Id 1358352',63220.00,0.00,0.00,116.00,1972.00,'2021-12-18 11:09:02','',''),(2312539,'1','141','764',322,'Retail Sale Id 1358394',1280.00,0.00,0.00,2.00,224.00,'2021-12-18 11:12:37','',''),(2312590,'1','141','764',322,'Retail Sale Id 1358418',2560.00,0.00,0.00,4.00,448.00,'2021-12-18 11:15:15','',''),(2312613,'1','141','764',322,'Retail Sale Id 1358434',1280.00,0.00,0.00,2.00,224.00,'2021-12-18 11:16:39','',''),(2312646,'1','141','764',322,'Retail Sale Id 1358458',3840.00,0.00,0.00,6.00,672.00,'2021-12-18 11:19:04','',''),(2312660,'1','141','764',322,'Retail Sale Id 1358475',7630.00,0.00,0.00,14.00,238.00,'2021-12-18 11:20:36','',''),(2312698,'1','141','764',322,'Retail Sale Id 1358512',1280.00,0.00,0.00,2.00,224.00,'2021-12-18 11:23:23','',''),(2312714,'1','141','764',322,'Retail Sale Id 1358528',1280.00,0.00,0.00,2.00,224.00,'2021-12-18 11:25:02','',''),(2312741,'1','141','764',322,'Retail Sale Id 1358553',7085.00,0.00,0.00,13.00,221.00,'2021-12-18 11:26:57','',''),(2312791,'1','141','764',322,'Retail Sale Id 1358602',1920.00,0.00,0.00,3.00,336.00,'2021-12-18 11:31:06','',''),(2312869,'1','141','764',322,'Retail Sale Id 1358678',8147.20,0.00,0.00,12.73,1425.76,'2021-12-18 11:37:37','',''),(2313975,'1','141','764',322,'Retail Sale Id 1359676',710680.00,0.00,0.00,1304.00,22168.00,'2021-12-18 13:25:47','',''),(2314082,'1','141','764',322,'Retail Sale Id 1359794',70400.00,0.00,0.00,110.00,12320.00,'2021-12-18 13:39:02','',''),(2314213,'1','141','764',322,'Retail Sale Id 1359888',429623.50,0.00,0.00,788.30,13401.10,'2021-12-18 13:48:10','',''),(2314353,'1','141','764',322,'Retail Sale Id 1359954',3840.00,0.00,0.00,6.00,672.00,'2021-12-18 13:54:07','',''),(2314397,'1','141','764',322,'Retail Sale Id 1359993',81750.00,0.00,0.00,150.00,2550.00,'2021-12-18 13:56:59','',''),(2314424,'1','141','764',322,'Retail Sale Id 1360020',73575.00,0.00,0.00,135.00,2295.00,'2021-12-18 13:59:52','',''),(2314461,'1','141','764',322,'Retail Sale Id 1360058',1280.00,0.00,0.00,2.00,224.00,'2021-12-18 14:03:38','',''),(2314483,'1','141','764',322,'Retail Sale Id 1360072',24525.00,0.00,0.00,45.00,765.00,'2021-12-18 14:04:55','',''),(2314524,'1','141','764',322,'Retail Sale Id 1360109',1920.00,0.00,0.00,3.00,336.00,'2021-12-18 14:07:47','',''),(2314536,'1','141','764',322,'Retail Sale Id 1360120',1497.60,0.00,0.00,2.34,262.08,'2021-12-18 14:08:44','',''),(2314548,'1','141','764',322,'Retail Sale Id 1360130',998.40,0.00,0.00,1.56,174.72,'2021-12-18 14:10:04','',''),(2314562,'1','141','764',322,'Retail Sale Id 1360142',4000.00,0.00,0.00,6.25,700.00,'2021-12-18 14:11:04','',''),(2314595,'1','141','764',322,'Retail Sale Id 1360165',1920.00,0.00,0.00,3.00,336.00,'2021-12-18 14:13:23','',''),(2314602,'1','141','764',322,'Retail Sale Id 1360172',1920.00,0.00,0.00,3.00,336.00,'2021-12-18 14:14:14','',''),(2314636,'1','141','764',322,'Retail Sale Id 1360204',3840.00,0.00,0.00,6.00,672.00,'2021-12-18 14:17:23','',''),(2314641,'1','141','764',322,'Retail Sale Id 1360213',3200.00,0.00,0.00,5.00,560.00,'2021-12-18 14:18:11','',''),(2314663,'1','141','764',322,'Retail Sale Id 1360220',2003.20,0.00,0.00,3.13,350.56,'2021-12-18 14:19:08','',''),(2314707,'1','141','764',322,'Retail Sale Id 1360262',6400.00,0.00,0.00,10.00,1120.00,'2021-12-18 14:23:32','',''),(2314723,'1','141','764',322,'Retail Sale Id 1360280',3840.00,0.00,0.00,6.00,672.00,'2021-12-18 14:25:04','',''),(2314777,'1','141','764',322,'Retail Sale Id 1360295',1920.00,0.00,0.00,3.00,336.00,'2021-12-18 14:29:01','',''),(2314916,'1','141','764',322,'Retail Sale Id 1360443',37877.50,0.00,0.00,69.50,1181.50,'2021-12-18 14:40:32','',''),(2315024,'1','141','764',322,'Retail Sale Id 1360487',3840.00,0.00,0.00,6.00,672.00,'2021-12-18 14:48:48','',''),(2315030,'1','141','764',322,'Retail Sale Id 1360525',10082.50,0.00,0.00,18.50,314.50,'2021-12-18 14:49:30','',''),(2315040,'1','141','764',322,'Return of Retail Sale Id 1360525',0.00,10082.50,18.50,0.00,-314.50,'2021-12-18 14:49:58','',''),(2315047,'1','141','764',322,'Retail Sale Id 1360539',11904.00,0.00,0.00,18.60,2083.20,'2021-12-18 14:50:27','',''),(2315094,'1','141','764',322,'Retail Sale Id 1360580',8000.00,0.00,0.00,12.50,1400.00,'2021-12-18 14:53:57','',''),(2315110,'1','141','764',322,'Retail Sale Id 1360588',43600.00,0.00,0.00,80.00,1360.00,'2021-12-18 14:54:56','',''),(2315119,'1','141','764',322,'Retail Sale Id 1360599',54500.00,0.00,0.00,100.00,1700.00,'2021-12-18 14:56:04','',''),(2315140,'1','141','764',322,'Retail Sale Id 1360620',998.40,0.00,0.00,1.56,174.72,'2021-12-18 14:57:43','',''),(2315189,'1','141','764',322,'Retail Sale Id 1360673',1497.60,0.00,0.00,2.34,262.08,'2021-12-18 15:03:23','',''),(2315217,'1','141','764',322,'Retail Sale Id 1360700',3001.60,0.00,0.00,4.69,525.28,'2021-12-18 15:05:46','',''),(2315287,'1','141','764',322,'Retail Sale Id 1360743',562985.00,0.00,0.00,1033.00,17561.00,'2021-12-18 15:11:03','',''),(2315350,'1','141','764',322,'Retail Sale Id 1360798',24896.00,0.00,0.00,38.90,4356.80,'2021-12-18 15:16:39','',''),(2315399,'1','141','764',322,'Retail Sale Id 1360844',2560.00,0.00,0.00,4.00,448.00,'2021-12-18 15:20:45','',''),(2315413,'1','141','764',322,'Retail Sale Id 1360857',1203.20,0.00,0.00,1.88,210.56,'2021-12-18 15:21:44','',''),(2315422,'1','141','764',322,'Retail Sale Id 1360866',2560.00,0.00,0.00,4.00,448.00,'2021-12-18 15:22:35','',''),(2315439,'1','141','764',322,'Retail Sale Id 1360883',1280.00,0.00,0.00,2.00,224.00,'2021-12-18 15:23:51','',''),(2315466,'1','141','764',322,'Retail Sale Id 1360900',1920.00,0.00,0.00,3.00,336.00,'2021-12-18 15:25:19','',''),(2315483,'1','141','764',322,'Retail Sale Id 1360915',1920.00,0.00,0.00,3.00,336.00,'2021-12-18 15:26:33','',''),(2315504,'1','141','764',322,'Retail Sale Id 1360937',640.00,0.00,0.00,1.00,112.00,'2021-12-18 15:28:56','',''),(2315518,'1','141','764',322,'Retail Sale Id 1360949',4905.00,0.00,0.00,9.00,153.00,'2021-12-18 15:29:56','',''),(2315538,'1','141','764',322,'Retail Sale Id 1360969',55590.00,0.00,0.00,102.00,1734.00,'2021-12-18 15:31:23','',''),(2315614,'1','141','764',322,'Retail Sale Id 1361041',22890.00,0.00,0.00,42.00,714.00,'2021-12-18 15:37:21','',''),(2315643,'1','141','764',322,'Retail Sale Id 1361073',998.40,0.00,0.00,1.56,174.72,'2021-12-18 15:39:32','',''),(2315653,'1','141','764',322,'Retail Sale Id 1361082',1280.00,0.00,0.00,2.00,224.00,'2021-12-18 15:40:27','',''),(2315699,'1','141','764',322,'Retail Sale Id 1361129',6540.00,0.00,0.00,12.00,204.00,'2021-12-18 15:44:26','',''),(2315774,'1','141','764',322,'Retail Sale Id 1361188',2003.20,0.00,0.00,3.13,350.56,'2021-12-18 15:48:55','',''),(2315840,'1','141','764',322,'Retail Sale Id 1361213',640.00,0.00,0.00,1.00,112.00,'2021-12-18 15:50:48','',''),(2315871,'1','141','764',322,'Retail Sale Id 1361234',640.00,0.00,0.00,1.00,112.00,'2021-12-18 15:52:34','',''),(2315889,'1','141','764',322,'Retail Sale Id 1361259',8000.00,0.00,0.00,12.50,1400.00,'2021-12-18 15:53:54','',''),(2315962,'1','141','764',322,'Retail Sale Id 1361305',998.40,0.00,0.00,1.56,174.72,'2021-12-18 15:57:25','',''),(2316189,'1','141','764',322,'Retail Sale Id 1361509',34335.00,0.00,0.00,63.00,1071.00,'2021-12-18 16:12:14','',''),(2316206,'1','141','764',322,'Retail Sale Id 1361525',8000.00,0.00,0.00,12.50,1400.00,'2021-12-18 16:13:43','',''),(2316312,'1','141','764',322,'Retail Sale Id 1361618',10496.00,0.00,0.00,16.40,1836.80,'2021-12-18 16:20:41','',''),(2316514,'1','141','764',322,'Retail Sale Id 1361815',21800.00,0.00,0.00,40.00,680.00,'2021-12-18 16:36:00','',''),(2320530,'1','141','764',322,'Retail Sale Id 1364853',1800.00,0.00,0.00,3.00,252.00,'2021-12-19 09:59:54','',''),(2320558,'1','141','764',322,'Retail Sale Id 1364880',3360.00,0.00,0.00,5.60,470.40,'2021-12-19 10:02:22','',''),(2320589,'1','141','764',322,'Retail Sale Id 1364910',8760.00,0.00,0.00,14.60,1226.40,'2021-12-19 10:05:02','',''),(2320607,'1','141','764',322,'Retail Sale Id 1364926',1800.00,0.00,0.00,3.00,252.00,'2021-12-19 10:06:07','',''),(2320624,'1','141','764',322,'Retail Sale Id 1364944',1200.00,0.00,0.00,2.00,168.00,'2021-12-19 10:07:21','',''),(2320652,'1','141','764',322,'Retail Sale Id 1364974',10380.00,0.00,0.00,17.30,1453.20,'2021-12-19 10:09:54','',''),(2320685,'1','141','764',322,'Retail Sale Id 1365001',7980.00,0.00,0.00,13.30,1117.20,'2021-12-19 10:11:45','',''),(2320722,'1','141','764',322,'Retail Sale Id 1365032',16500.00,0.00,0.00,27.50,2310.00,'2021-12-19 10:13:42','',''),(2320736,'1','141','764',322,'Retail Sale Id 1365042',1002.00,0.00,0.00,1.67,140.28,'2021-12-19 10:15:00','',''),(2320785,'1','141','764',322,'Retail Sale Id 1365100',7500.00,0.00,0.00,12.50,1050.00,'2021-12-19 10:19:31','',''),(2320808,'1','141','764',322,'Retail Sale Id 1365120',28355.00,0.00,0.00,53.00,1007.00,'2021-12-19 10:21:24','',''),(2320869,'1','141','764',322,'Retail Sale Id 1365178',29425.00,0.00,0.00,55.00,1045.00,'2021-12-19 10:26:03','',''),(2320930,'1','141','764',322,'Retail Sale Id 1365219',89880.00,0.00,0.00,168.00,3192.00,'2021-12-19 10:29:44','',''),(2321205,'1','141','764',322,'Retail Sale Id 1365460',10200.00,0.00,0.00,17.00,1428.00,'2021-12-19 10:55:59','',''),(2321228,'1','141','764',322,'Retail Sale Id 1365536',246100.00,0.00,0.00,460.00,8740.00,'2021-12-19 10:57:29','',''),(2321257,'1','141','764',322,'Retail Sale Id 1365554',3600.00,0.00,0.00,6.00,504.00,'2021-12-19 11:00:06','',''),(2321292,'1','141','764',322,'Retail Sale Id 1365604',385200.00,0.00,0.00,720.00,13680.00,'2021-12-19 11:02:39','',''),(2321325,'1','141','764',322,'Retail Sale Id 1365635',1800.00,0.00,0.00,3.00,252.00,'2021-12-19 11:05:46','',''),(2321432,'1','141','764',322,'Retail Sale Id 1365723',1200.00,0.00,0.00,2.00,168.00,'2021-12-19 11:12:43','',''),(2321466,'1','141','764',322,'Retail Sale Id 1365757',29960.00,0.00,0.00,56.00,1064.00,'2021-12-19 11:15:20','',''),(2321504,'1','141','764',322,'Retail Sale Id 1365793',26750.00,0.00,0.00,50.00,950.00,'2021-12-19 11:18:28','',''),(2321530,'1','141','764',322,'Retail Sale Id 1365821',1200.00,0.00,0.00,2.00,168.00,'2021-12-19 11:20:43','',''),(2321596,'1','141','764',322,'Retail Sale Id 1365878',7500.00,0.00,0.00,12.50,1050.00,'2021-12-19 11:26:00','',''),(2321615,'1','141','764',322,'Retail Sale Id 1365899',3600.00,0.00,0.00,6.00,504.00,'2021-12-19 11:27:13','',''),(2321630,'1','141','764',322,'Retail Sale Id 1365913',29425.00,0.00,0.00,55.00,1045.00,'2021-12-19 11:28:21','',''),(2321671,'1','141','764',322,'Retail Sale Id 1365952',9000.00,0.00,0.00,15.00,1260.00,'2021-12-19 11:32:02','',''),(2321691,'1','141','764',322,'Retail Sale Id 1365975',9897.50,0.00,0.00,18.50,351.50,'2021-12-19 11:34:17','',''),(2321749,'1','141','764',322,'Retail Sale Id 1366020',1200.00,0.00,0.00,2.00,168.00,'2021-12-19 11:39:16','',''),(2321772,'1','141','764',322,'Retail Sale Id 1366031',1200.00,0.00,0.00,2.00,168.00,'2021-12-19 11:40:56','',''),(2321786,'1','141','764',322,'Retail Sale Id 1366046',3000.00,0.00,0.00,5.00,420.00,'2021-12-19 11:42:23','',''),(2321805,'1','141','764',322,'Retail Sale Id 1366063',105930.00,0.00,0.00,198.00,3762.00,'2021-12-19 11:43:58','',''),(2321860,'1','141','764',322,'Retail Sale Id 1366115',3600.00,0.00,0.00,6.00,504.00,'2021-12-19 11:47:54','',''),(2321874,'1','141','764',322,'Retail Sale Id 1366130',1002.00,0.00,0.00,1.67,140.28,'2021-12-19 11:49:10','',''),(2321883,'1','141','764',322,'Retail Sale Id 1366138',1800.00,0.00,0.00,3.00,252.00,'2021-12-19 11:50:12','',''),(2321903,'1','141','764',322,'Retail Sale Id 1366166',35310.00,0.00,0.00,66.00,1254.00,'2021-12-19 11:51:55','',''),(2321972,'1','141','764',322,'Retail Sale Id 1366227',32100.00,0.00,0.00,60.00,1140.00,'2021-12-19 11:57:27','',''),(2322059,'1','141','764',322,'Retail Sale Id 1366318',1800.00,0.00,0.00,3.00,252.00,'2021-12-19 12:05:07','',''),(2322129,'1','141','764',322,'Retail Sale Id 1366376',149800.00,0.00,0.00,280.00,5320.00,'2021-12-19 12:11:32','',''),(2322150,'1','141','764',322,'Retail Sale Id 1366402',2502.00,0.00,0.00,4.17,350.28,'2021-12-19 12:13:30','',''),(2322192,'1','141','764',322,'Retail Sale Id 1366453',1800.00,0.00,0.00,3.00,252.00,'2021-12-19 12:17:05','',''),(2322258,'1','141','764',322,'Retail Sale Id 1366512',4200.00,0.00,0.00,7.00,588.00,'2021-12-19 12:22:57','',''),(2322272,'1','141','764',322,'Retail Sale Id 1366526',8460.00,0.00,0.00,14.10,1184.40,'2021-12-19 12:24:42','',''),(2322311,'1','141','764',322,'Retail Sale Id 1366567',1998.00,0.00,0.00,3.33,279.72,'2021-12-19 12:29:01','',''),(2322326,'1','141','764',322,'Retail Sale Id 1366581',1200.00,0.00,0.00,2.00,168.00,'2021-12-19 12:30:32','',''),(2322336,'1','141','764',322,'Retail Sale Id 1366593',3600.00,0.00,0.00,6.00,504.00,'2021-12-19 12:32:15','',''),(2322362,'1','141','764',322,'Retail Sale Id 1366617',53500.00,0.00,0.00,100.00,1900.00,'2021-12-19 12:34:43','',''),(2322560,'1','141','764',322,'Retail Sale Id 1366779',1800.00,0.00,0.00,3.00,252.00,'2021-12-19 12:50:47','',''),(2322574,'1','141','764',322,'Retail Sale Id 1366793',1200.00,0.00,0.00,2.00,168.00,'2021-12-19 12:52:11','',''),(2322621,'1','141','764',322,'Retail Sale Id 1366846',1200.00,0.00,0.00,2.00,168.00,'2021-12-19 12:56:25','',''),(2322634,'1','141','764',322,'Retail Sale Id 1366863',39055.00,0.00,0.00,73.00,1387.00,'2021-12-19 12:57:52','',''),(2322679,'1','141','764',322,'Retail Sale Id 1366897',77794.35,0.00,0.00,145.41,2762.79,'2021-12-19 13:01:20','',''),(2322685,'1','141','764',322,'Return of Retail Sale Id 1366897',0.00,77794.35,145.41,0.00,-2762.79,'2021-12-19 13:01:57','',''),(2322695,'1','141','764',322,'Retail Sale Id 1366914',152475.00,0.00,0.00,285.00,5415.00,'2021-12-19 13:02:49','',''),(2322718,'1','141','764',322,'Retail Sale Id 1366939',600.00,0.00,0.00,1.00,84.00,'2021-12-19 13:05:39','',''),(2322733,'1','141','764',322,'Retail Sale Id 1366954',53500.00,0.00,0.00,100.00,1900.00,'2021-12-19 13:07:19','',''),(2322775,'1','141','764',322,'Retail Sale Id 1366995',600.00,0.00,0.00,1.00,84.00,'2021-12-19 13:10:43','',''),(2322829,'1','141','764',322,'Retail Sale Id 1367044',7200.00,0.00,0.00,12.00,1008.00,'2021-12-19 13:16:08','',''),(2322855,'1','141','764',322,'Retail Sale Id 1367071',5400.00,0.00,0.00,9.00,756.00,'2021-12-19 13:18:29','',''),(2323057,'1','141','764',322,'Retail Sale Id 1367228',107000.00,0.00,0.00,200.00,3800.00,'2021-12-19 13:33:25','',''),(2323119,'1','141','764',322,'Retail Sale Id 1367277',53500.00,0.00,0.00,100.00,1900.00,'2021-12-19 13:38:05','',''),(2323199,'1','141','764',322,'Retail Sale Id 1367328',6687.50,0.00,0.00,12.50,237.50,'2021-12-19 13:43:14','',''),(2323221,'1','141','764',322,'Retail Sale Id 1367347',1200.00,0.00,0.00,2.00,168.00,'2021-12-19 13:44:53','',''),(2323236,'1','141','764',322,'Retail Sale Id 1367355',1200.00,0.00,0.00,2.00,168.00,'2021-12-19 13:45:57','',''),(2323267,'1','141','764',322,'Retail Sale Id 1367378',3600.00,0.00,0.00,6.00,504.00,'2021-12-19 13:49:34','',''),(2323315,'1','141','764',322,'Retail Sale Id 1367418',52430.00,0.00,0.00,98.00,1862.00,'2021-12-19 13:52:40','',''),(2323357,'1','141','764',322,'Retail Sale Id 1367461',2400.00,0.00,0.00,4.00,336.00,'2021-12-19 13:56:04','',''),(2323371,'1','141','764',322,'Retail Sale Id 1367474',600.00,0.00,0.00,1.00,84.00,'2021-12-19 13:57:13','',''),(2323408,'1','141','764',322,'Retail Sale Id 1367502',26750.00,0.00,0.00,50.00,950.00,'2021-12-19 13:59:20','',''),(2323492,'1','141','764',322,'Retail Sale Id 1367576',7500.00,0.00,0.00,12.50,1050.00,'2021-12-19 14:04:07','',''),(2323594,'1','141','764',322,'Retail Sale Id 1367651',93090.00,0.00,0.00,174.00,3306.00,'2021-12-19 14:10:22','',''),(2323669,'1','141','764',322,'Retail Sale Id 1367721',3600.00,0.00,0.00,6.00,504.00,'2021-12-19 14:16:24','',''),(2323689,'1','141','764',322,'Retail Sale Id 1367739',1398.00,0.00,0.00,2.33,195.72,'2021-12-19 14:18:17','',''),(2323728,'1','141','764',322,'Retail Sale Id 1367770',77040.00,0.00,0.00,144.00,2736.00,'2021-12-19 14:21:49','',''),(2323775,'1','141','764',322,'Retail Sale Id 1367812',160500.00,0.00,0.00,300.00,5700.00,'2021-12-19 14:26:36','',''),(2323801,'1','141','764',322,'Retail Sale Id 1367836',32100.00,0.00,0.00,60.00,1140.00,'2021-12-19 14:29:15','',''),(2323830,'1','141','764',322,'Retail Sale Id 1367854',3600.00,0.00,0.00,6.00,504.00,'2021-12-19 14:30:57','',''),(2323847,'1','141','764',322,'Retail Sale Id 1367870',4002.00,0.00,0.00,6.67,560.28,'2021-12-19 14:32:19','',''),(2323864,'1','141','764',322,'Retail Sale Id 1367884',32100.00,0.00,0.00,60.00,1140.00,'2021-12-19 14:33:47','',''),(2323880,'1','141','764',322,'Retail Sale Id 1367901',798.00,0.00,0.00,1.33,111.72,'2021-12-19 14:35:57','',''),(2323931,'1','141','764',322,'Retail Sale Id 1367942',13910.00,0.00,0.00,26.00,494.00,'2021-12-19 14:39:47','',''),(2323960,'1','141','764',322,'Retail Sale Id 1367972',7500.00,0.00,0.00,12.50,1050.00,'2021-12-19 14:43:02','',''),(2323979,'1','141','764',322,'Retail Sale Id 1367988',74900.00,0.00,0.00,140.00,2660.00,'2021-12-19 14:44:31','',''),(2324035,'1','141','764',322,'Retail Sale Id 1368043',32100.00,0.00,0.00,60.00,1140.00,'2021-12-19 14:49:48','',''),(2324050,'1','141','764',322,'Retail Sale Id 1368059',3600.00,0.00,0.00,6.00,504.00,'2021-12-19 14:51:09','',''),(2324074,'1','141','764',322,'Retail Sale Id 1368086',139100.00,0.00,0.00,260.00,4940.00,'2021-12-19 14:53:57','',''),(2324112,'1','141','764',322,'Retail Sale Id 1368122',10165.00,0.00,0.00,19.00,361.00,'2021-12-19 14:59:04','',''),(2324120,'1','141','764',322,'Retail Sale Id 1368129',3600.00,0.00,0.00,6.00,504.00,'2021-12-19 15:00:08','',''),(2324131,'1','141','764',322,'Retail Sale Id 1368142',3000.00,0.00,0.00,5.00,420.00,'2021-12-19 15:01:37','',''),(2324145,'1','141','764',322,'Retail Sale Id 1368154',3498.00,0.00,0.00,5.83,489.72,'2021-12-19 15:02:47','',''),(2324231,'1','141','764',322,'Retail Sale Id 1368241',91485.00,0.00,0.00,171.00,3249.00,'2021-12-19 15:12:40','',''),(2324272,'1','141','764',322,'Retail Sale Id 1368268',1200.00,0.00,0.00,2.00,168.00,'2021-12-19 15:16:12','',''),(2324746,'1','141','764',322,'Retail Sale Id 1368685',2760.00,0.00,0.00,4.60,386.40,'2021-12-19 15:59:57','',''),(2324794,'1','141','764',322,'Retail Sale Id 1368699',6955.00,0.00,0.00,13.00,247.00,'2021-12-19 16:03:55','',''),(2326509,'1','141','764',322,'Retail Sale Id 1369792',83460.00,0.00,0.00,156.00,2964.00,'2021-12-20 06:58:10','',''),(2326535,'1','141','764',322,'Retail Sale Id 1369817',7500.00,0.00,0.00,12.50,1050.00,'2021-12-20 07:02:20','',''),(2326541,'1','141','764',322,'Retail Sale Id 1369822',2400.00,0.00,0.00,4.00,336.00,'2021-12-20 07:03:31','',''),(2326561,'1','141','764',322,'Retail Sale Id 1369840',3000.00,0.00,0.00,5.00,420.00,'2021-12-20 07:05:30','',''),(2326572,'1','141','764',322,'Retail Sale Id 1369851',1500.00,0.00,0.00,2.50,210.00,'2021-12-20 07:07:19','',''),(2326583,'1','141','764',322,'Retail Sale Id 1369863',1800.00,0.00,0.00,3.00,252.00,'2021-12-20 07:08:28','',''),(2326663,'1','141','764',322,'Retail Sale Id 1369883',1200.00,0.00,0.00,2.00,168.00,'2021-12-20 07:17:48','',''),(2326695,'1','141','764',322,'Retail Sale Id 1369955',3600.00,0.00,0.00,6.00,504.00,'2021-12-20 07:20:53','',''),(2326767,'1','141','764',322,'Retail Sale Id 1370012',1800.00,0.00,0.00,3.00,252.00,'2021-12-20 07:30:38','',''),(2326798,'1','141','764',322,'Retail Sale Id 1370047',104325.00,0.00,0.00,195.00,3705.00,'2021-12-20 07:34:55','',''),(2326828,'1','141','764',322,'Retail Sale Id 1370074',81320.00,0.00,0.00,152.00,2888.00,'2021-12-20 07:39:04','',''),(2326955,'1','141','764',322,'Retail Sale Id 1370146',48150.00,0.00,0.00,90.00,1710.00,'2021-12-20 07:47:55','',''),(2326987,'1','141','764',322,'Retail Sale Id 1370162',2400.00,0.00,0.00,4.00,336.00,'2021-12-20 07:50:11','',''),(2326997,'1','141','764',322,'Retail Sale Id 1370175',3000.00,0.00,0.00,5.00,420.00,'2021-12-20 07:51:37','',''),(2327003,'1','141','764',322,'Retail Sale Id 1370180',3600.00,0.00,0.00,6.00,504.00,'2021-12-20 07:52:41','',''),(2327057,'1','141','764',322,'Retail Sale Id 1370198',107000.00,0.00,0.00,200.00,3800.00,'2021-12-20 07:56:56','',''),(2327106,'1','141','764',322,'Retail Sale Id 1370250',3600.00,0.00,0.00,6.00,504.00,'2021-12-20 08:02:18','',''),(2327119,'1','141','764',322,'Retail Sale Id 1370258',1800.00,0.00,0.00,3.00,252.00,'2021-12-20 08:04:19','',''),(2327137,'1','141','764',322,'Retail Sale Id 1370279',53500.00,0.00,0.00,100.00,1900.00,'2021-12-20 08:06:53','',''),(2327142,'1','141','764',322,'Retail Sale Id 1370284',7500.00,0.00,0.00,12.50,1050.00,'2021-12-20 08:07:49','',''),(2327148,'1','141','764',322,'Retail Sale Id 1370291',3498.00,0.00,0.00,5.83,489.72,'2021-12-20 08:08:48','',''),(2327164,'1','141','764',322,'Retail Sale Id 1370304',96300.00,0.00,0.00,180.00,3420.00,'2021-12-20 08:10:31','',''),(2327175,'1','141','764',322,'Retail Sale Id 1370315',3000.00,0.00,0.00,5.00,420.00,'2021-12-20 08:12:27','',''),(2327181,'1','141','764',322,'Retail Sale Id 1370325',59385.00,0.00,0.00,111.00,2109.00,'2021-12-20 08:13:37','',''),(2327225,'1','141','764',322,'Retail Sale Id 1370371',1200.00,0.00,0.00,2.00,168.00,'2021-12-20 08:20:19','',''),(2327235,'1','141','764',322,'Retail Sale Id 1370381',36380.00,0.00,0.00,68.00,1292.00,'2021-12-20 08:21:43','',''),(2327255,'1','141','764',322,'Retail Sale Id 1370396',147125.00,0.00,0.00,275.00,5225.00,'2021-12-20 08:24:56','',''),(2327276,'1','141','764',322,'Retail Sale Id 1370423',140437.50,0.00,0.00,262.50,4987.50,'2021-12-20 08:27:39','',''),(2327326,'1','141','764',322,'Retail Sale Id 1370469',7500.00,0.00,0.00,12.50,1050.00,'2021-12-20 08:32:20','',''),(2327377,'1','141','764',322,'Retail Sale Id 1370520',3600.00,0.00,0.00,6.00,504.00,'2021-12-20 08:39:06','',''),(2327407,'1','141','764',322,'Retail Sale Id 1370544',80250.00,0.00,0.00,150.00,2850.00,'2021-12-20 08:43:04','',''),(2327514,'1','141','764',322,'Retail Sale Id 1370638',1800.00,0.00,0.00,3.00,252.00,'2021-12-20 08:55:11','',''),(2327570,'1','141','764',322,'Retail Sale Id 1370672',3600.00,0.00,0.00,6.00,504.00,'2021-12-20 09:02:28','',''),(2327689,'1','141','764',322,'Retail Sale Id 1370778',1200.00,0.00,0.00,2.00,168.00,'2021-12-20 09:17:28','',''),(2327706,'1','141','764',322,'Retail Sale Id 1370795',2400.00,0.00,0.00,4.00,336.00,'2021-12-20 09:19:50','',''),(2327732,'1','141','764',322,'Retail Sale Id 1370816',2502.00,0.00,0.00,4.17,350.28,'2021-12-20 09:24:44','',''),(2327779,'1','141','764',322,'Retail Sale Id 1370840',68747.50,0.00,0.00,128.50,2441.50,'2021-12-20 09:28:28','',''),(2328076,'1','141','764',322,'Retail Sale Id 1371067',600.00,0.00,0.00,1.00,84.00,'2021-12-20 10:04:13','',''),(2328103,'1','141','764',322,'Retail Sale Id 1371083',1800.00,0.00,0.00,3.00,252.00,'2021-12-20 10:06:31','',''),(2328123,'1','141','764',322,'Retail Sale Id 1371102',1002.00,0.00,0.00,1.67,140.28,'2021-12-20 10:11:12','',''),(2328142,'1','141','764',322,'Retail Sale Id 1371112',53500.00,0.00,0.00,100.00,1900.00,'2021-12-20 10:13:37','',''),(2328165,'1','141','764',322,'Retail Sale Id 1371134',1998.00,0.00,0.00,3.33,279.72,'2021-12-20 10:16:29','',''),(2328181,'1','141','764',322,'Retail Sale Id 1371152',1002.00,0.00,0.00,1.67,140.28,'2021-12-20 10:18:50','',''),(2328219,'1','141','764',322,'Retail Sale Id 1371170',7500.00,0.00,0.00,12.50,1050.00,'2021-12-20 10:23:50','',''),(2328226,'1','141','764',322,'Retail Sale Id 1371200',600.00,0.00,0.00,1.00,84.00,'2021-12-20 10:24:27','',''),(2328257,'1','141','764',322,'Retail Sale Id 1371226',3000.00,0.00,0.00,5.00,420.00,'2021-12-20 10:28:14','',''),(2328383,'1','141','764',322,'Retail Sale Id 1371323',117700.00,0.00,0.00,220.00,4180.00,'2021-12-20 10:40:11','',''),(2328541,'1','141','764',322,'Retail Sale Id 1371482',1800.00,0.00,0.00,3.00,252.00,'2021-12-20 10:56:51','',''),(2328556,'1','141','764',322,'Retail Sale Id 1371493',1200.00,0.00,0.00,2.00,168.00,'2021-12-20 10:58:20','',''),(2328568,'1','141','764',322,'Retail Sale Id 1371517',600.00,0.00,0.00,1.00,84.00,'2021-12-20 10:59:25','',''),(2328714,'1','141','764',322,'Retail Sale Id 1371648',12000.00,0.00,0.00,20.00,1680.00,'2021-12-20 11:12:35','',''),(2328834,'1','141','764',322,'Retail Sale Id 1371756',147125.00,0.00,0.00,275.00,5225.00,'2021-12-20 11:25:45','',''),(2328886,'1','141','764',322,'Retail Sale Id 1371811',18725.00,0.00,0.00,35.00,665.00,'2021-12-20 11:32:13','',''),(2328906,'1','141','764',322,'Retail Sale Id 1371829',58850.00,0.00,0.00,110.00,2090.00,'2021-12-20 11:33:56','',''),(2328974,'1','141','764',322,'Retail Sale Id 1371903',3600.00,0.00,0.00,6.00,504.00,'2021-12-20 11:41:14','',''),(2329054,'1','141','764',322,'Retail Sale Id 1371968',26750.00,0.00,0.00,50.00,950.00,'2021-12-20 11:49:52','',''),(2329547,'1','141','764',322,'Retail Sale Id 1372396',1819000.00,0.00,0.00,3400.00,64600.00,'2021-12-20 12:41:07','',''),(2329575,'1','141','764',322,'Retail Sale Id 1372407',3600.00,0.00,0.00,6.00,504.00,'2021-12-20 12:42:02','',''),(2329683,'1','141','764',322,'Retail Sale Id 1372464',350639.00,0.00,0.00,655.40,12452.60,'2021-12-20 12:50:31','',''),(2329749,'1','141','764',322,'Retail Sale Id 1372514',163320.00,0.00,0.00,272.20,22864.80,'2021-12-20 12:56:56','',''),(2329783,'1','141','764',322,'Retail Sale Id 1372540',4680.00,0.00,0.00,7.80,655.20,'2021-12-20 13:00:21','',''),(2330128,'1','141','764',322,'Retail Sale Id 1372783',3210.00,0.00,0.00,6.00,114.00,'2021-12-20 13:31:41','',''),(2330212,'1','141','764',322,'Retail Sale Id 1372836',22260.00,0.00,0.00,37.10,3116.40,'2021-12-20 13:38:32','',''),(2330585,'1','141','764',322,'Retail Sale Id 1373081',160500.00,0.00,0.00,300.00,5700.00,'2021-12-20 14:09:45','',''),(2334336,'1','141','764',322,'Distributed to OPERATIONAL LOSS for sales id:341168',187173.84,0.00,0.00,362.74,0.00,'2021-12-21 08:02:28','',''),(2334488,'1','141',NULL,322,'Purchased from AA RANO NIGERIA LIMITED',0.00,12900000.00,25000.00,0.00,0.00,'2021-12-21 08:16:11','',''),(2334503,'1','141',NULL,322,'Reception corrector for bridging 128167',0.00,0.00,0.00,25000.00,0.00,'2021-12-21 08:18:53','',''),(2334504,'1','141','764',322,'Received from bridging 128167',0.00,0.00,25000.00,0.00,0.00,'2021-12-21 08:18:53','',''),(2337163,'1','141','764',322,'Retail Sale Id 1378100',7500.00,0.00,0.00,12.50,1050.00,'2021-12-21 13:16:40','',''),(2337343,'1','141','764',322,'Retail Sale Id 1378348',26750.00,0.00,0.00,50.00,950.00,'2021-12-21 13:37:14','',''),(2338007,'1','141','764',322,'Retail Sale Id 1378824',1800.00,0.00,0.00,3.00,252.00,'2021-12-21 14:28:28','',''),(2338021,'1','141','764',322,'Retail Sale Id 1378839',3600.00,0.00,0.00,6.00,504.00,'2021-12-21 14:29:06','',''),(2338036,'1','141','764',322,'Retail Sale Id 1378857',26750.00,0.00,0.00,50.00,950.00,'2021-12-21 14:30:32','',''),(2338078,'1','141','764',322,'Retail Sale Id 1378893',3498.00,0.00,0.00,5.83,489.72,'2021-12-21 14:34:22','',''),(2338099,'1','141','764',322,'Retail Sale Id 1378916',3600.00,0.00,0.00,6.00,504.00,'2021-12-21 14:36:10','',''),(2338129,'1','141','764',322,'Retail Sale Id 1378950',47615.00,0.00,0.00,89.00,1691.00,'2021-12-21 14:39:47','',''),(2338141,'1','141','764',322,'Retail Sale Id 1378963',26750.00,0.00,0.00,50.00,950.00,'2021-12-21 14:41:03','',''),(2338228,'1','141','764',322,'Retail Sale Id 1379049',600.00,0.00,0.00,1.00,84.00,'2021-12-21 14:48:55','',''),(2338240,'1','141','764',322,'Retail Sale Id 1379061',1200.00,0.00,0.00,2.00,168.00,'2021-12-21 14:49:45','',''),(2338297,'1','141','764',322,'Retail Sale Id 1379106',1800.00,0.00,0.00,3.00,252.00,'2021-12-21 14:53:28','',''),(2338371,'1','141','764',322,'Retail Sale Id 1379151',1998.00,0.00,0.00,3.33,279.72,'2021-12-21 14:58:05','',''),(2338403,'1','141','764',322,'Retail Sale Id 1379176',1200.00,0.00,0.00,2.00,168.00,'2021-12-21 15:00:36','',''),(2338413,'1','141','764',322,'Retail Sale Id 1379187',12840.00,0.00,0.00,24.00,456.00,'2021-12-21 15:02:06','',''),(2338674,'1','141','764',322,'Retail Sale Id 1379424',3600.00,0.00,0.00,6.00,504.00,'2021-12-21 15:25:42','',''),(2339004,'1','141','764',322,'Retail Sale Id 1379664',6420.00,0.00,0.00,12.00,228.00,'2021-12-21 15:45:19','',''),(2339047,'1','141','764',322,'Retail Sale Id 1379713',1800.00,0.00,0.00,3.00,252.00,'2021-12-21 15:48:37','',''),(2339058,'1','141','764',322,'Retail Sale Id 1379725',7500.00,0.00,0.00,12.50,1050.00,'2021-12-21 15:49:25','',''),(2339411,'1','141','764',322,'Retail Sale Id 1379958',1800.00,0.00,0.00,3.00,252.00,'2021-12-21 16:12:52','',''),(2339458,'1','141','764',322,'Retail Sale Id 1380029',1712000.00,0.00,0.00,3200.00,60800.00,'2021-12-21 16:16:28','',''),(2339526,'1','141','764',322,'Retail Sale Id 1380136',120000.00,0.00,0.00,200.00,16800.00,'2021-12-21 16:21:53','',''),(2339739,'1','141','764',322,'Retail Sale Id 1380334',1337500.00,0.00,0.00,2500.00,47500.00,'2021-12-21 16:39:34','',''),(2339764,'1','141','764',322,'Retail Sale Id 1380362',180000.00,0.00,0.00,300.00,25200.00,'2021-12-21 16:41:44','',''),(2339788,'1','141','764',322,'Retail Sale Id 1380389',79980.00,0.00,0.00,133.30,11197.20,'2021-12-21 16:44:03','',''),(2339812,'1','141','764',322,'Retail Sale Id 1380409',1214450.00,0.00,0.00,2270.00,43130.00,'2021-12-21 16:45:57','',''),(2339949,'1','141','764',322,'Retail Sale Id 1380534',60.00,0.00,0.00,0.10,8.40,'2021-12-21 16:57:41','',''),(2342204,'1','141','764',322,'Retail Sale Id 1381994',1200.00,0.00,0.00,2.00,168.00,'2021-12-22 07:46:07','',''),(2342236,'1','141','764',322,'Retail Sale Id 1382030',133750.00,0.00,0.00,250.00,4750.00,'2021-12-22 07:48:02','',''),(2342333,'1','141','764',322,'Retail Sale Id 1382103',107000.00,0.00,0.00,200.00,3800.00,'2021-12-22 07:53:32','',''),(2342436,'1','141','764',322,'Retail Sale Id 1382187',3600.00,0.00,0.00,6.00,504.00,'2021-12-22 08:00:29','',''),(2342485,'1','141','764',322,'Retail Sale Id 1382214',140437.50,0.00,0.00,262.50,4987.50,'2021-12-22 08:02:40','',''),(2342568,'1','141','764',322,'Retail Sale Id 1382281',53500.00,0.00,0.00,100.00,1900.00,'2021-12-22 08:07:10','',''),(2342643,'1','141','764',322,'Retail Sale Id 1382343',1800.00,0.00,0.00,3.00,252.00,'2021-12-22 08:12:19','',''),(2342656,'1','141','764',322,'Retail Sale Id 1382352',3600.00,0.00,0.00,6.00,504.00,'2021-12-22 08:13:23','',''),(2342685,'1','141','764',322,'Retail Sale Id 1382375',900.00,0.00,0.00,1.50,126.00,'2021-12-22 08:15:49','',''),(2342703,'1','141','764',322,'Retail Sale Id 1382399',29960.00,0.00,0.00,56.00,1064.00,'2021-12-22 08:17:22','',''),(2342745,'1','141','764',322,'Retail Sale Id 1382435',127330.00,0.00,0.00,238.00,4522.00,'2021-12-22 08:20:58','',''),(2342802,'1','141','764',322,'Retail Sale Id 1382488',6420.00,0.00,0.00,12.00,228.00,'2021-12-22 08:25:10','',''),(2342820,'1','141','764',322,'Retail Sale Id 1382507',1800.00,0.00,0.00,3.00,252.00,'2021-12-22 08:26:23','',''),(2342869,'1','141','764',322,'Retail Sale Id 1382528',1800.00,0.00,0.00,3.00,252.00,'2021-12-22 08:27:54','',''),(2342923,'1','141','764',322,'Retail Sale Id 1382553',9897.50,0.00,0.00,18.50,351.50,'2021-12-22 08:29:25','',''),(2342945,'1','141','764',322,'Retail Sale Id 1382575',32100.00,0.00,0.00,60.00,1140.00,'2021-12-22 08:31:15','',''),(2342964,'1','141','764',322,'Retail Sale Id 1382592',1800.00,0.00,0.00,3.00,252.00,'2021-12-22 08:32:52','',''),(2342989,'1','141','764',322,'Retail Sale Id 1382618',108337.50,0.00,0.00,202.50,3847.50,'2021-12-22 08:34:50','',''),(2343099,'1','141','764',322,'Retail Sale Id 1382671',3600.00,0.00,0.00,6.00,504.00,'2021-12-22 08:43:35','',''),(2343118,'1','141','764',322,'Retail Sale Id 1382731',35845.00,0.00,0.00,67.00,1273.00,'2021-12-22 08:46:01','',''),(2343149,'1','141','764',322,'Retail Sale Id 1382751',26750.00,0.00,0.00,50.00,950.00,'2021-12-22 08:49:37','',''),(2343185,'1','141','764',322,'Retail Sale Id 1382794',1200.00,0.00,0.00,2.00,168.00,'2021-12-22 08:53:20','',''),(2343200,'1','141','764',322,'Retail Sale Id 1382807',960.00,0.00,0.00,1.60,134.40,'2021-12-22 08:54:47','',''),(2343223,'1','141','764',322,'Retail Sale Id 1382827',118502.50,0.00,0.00,221.50,4208.50,'2021-12-22 08:57:02','',''),(2343249,'1','141','764',322,'Retail Sale Id 1382855',1980.00,0.00,0.00,3.30,277.20,'2021-12-22 08:59:30','',''),(2343291,'1','141','764',322,'Retail Sale Id 1382891',7500.00,0.00,0.00,12.50,1050.00,'2021-12-22 09:03:08','',''),(2343322,'1','141','764',322,'Retail Sale Id 1382921',419975.00,0.00,0.00,785.00,14915.00,'2021-12-22 09:06:06','',''),(2343375,'1','141','764',322,'Retail Sale Id 1383006',1200.00,0.00,0.00,2.00,168.00,'2021-12-22 09:10:52','',''),(2343398,'1','141','764',322,'Retail Sale Id 1383038',13375.00,0.00,0.00,25.00,475.00,'2021-12-22 09:12:19','',''),(2343437,'1','141','764',322,'Retail Sale Id 1383076',70620.00,0.00,0.00,132.00,2508.00,'2021-12-22 09:15:58','',''),(2343480,'1','141','764',322,'Retail Sale Id 1383111',17655.00,0.00,0.00,33.00,627.00,'2021-12-22 09:20:23','',''),(2343501,'1','141','764',322,'Retail Sale Id 1383136',25145.00,0.00,0.00,47.00,893.00,'2021-12-22 09:23:49','',''),(2343516,'1','141','764',322,'Retail Sale Id 1383150',1800.00,0.00,0.00,3.00,252.00,'2021-12-22 09:25:27','',''),(2343605,'1','141','764',322,'Retail Sale Id 1383221',3600.00,0.00,0.00,6.00,504.00,'2021-12-22 09:31:43','',''),(2343629,'1','141','764',322,'Retail Sale Id 1383238',3600.00,0.00,0.00,6.00,504.00,'2021-12-22 09:33:39','',''),(2343662,'1','141','764',322,'Retail Sale Id 1383262',3000.00,0.00,0.00,5.00,420.00,'2021-12-22 09:35:26','',''),(2343714,'1','141','764',322,'Retail Sale Id 1383289',5350.00,0.00,0.00,10.00,190.00,'2021-12-22 09:39:19','',''),(2343779,'1','141','764',322,'Retail Sale Id 1383355',416765.00,0.00,0.00,779.00,14801.00,'2021-12-22 09:46:02','',''),(2343816,'1','141','764',322,'Retail Sale Id 1383381',6955.00,0.00,0.00,13.00,247.00,'2021-12-22 09:50:01','',''),(2343838,'1','141','764',322,'Retail Sale Id 1383409',12037.50,0.00,0.00,22.50,427.50,'2021-12-22 09:51:38','',''),(2343893,'1','141','764',322,'Retail Sale Id 1383438',3000.00,0.00,0.00,5.00,420.00,'2021-12-22 09:54:58','',''),(2343909,'1','141','764',322,'Retail Sale Id 1383468',7500.00,0.00,0.00,12.50,1050.00,'2021-12-22 09:56:05','',''),(2343926,'1','141','764',322,'Retail Sale Id 1383477',1800.00,0.00,0.00,3.00,252.00,'2021-12-22 09:57:30','',''),(2343945,'1','141','764',322,'Retail Sale Id 1383505',2400.00,0.00,0.00,4.00,336.00,'2021-12-22 09:59:10','',''),(2343959,'1','141','764',322,'Retail Sale Id 1383518',1500.00,0.00,0.00,2.50,210.00,'2021-12-22 10:00:36','',''),(2343978,'1','141','764',322,'Retail Sale Id 1383540',26750.00,0.00,0.00,50.00,950.00,'2021-12-22 10:02:15','',''),(2344182,'1','141','764',322,'Retail Sale Id 1383729',7500.00,0.00,0.00,12.50,1050.00,'2021-12-22 10:23:06','',''),(2344262,'1','141','764',322,'Retail Sale Id 1383822',80250.00,0.00,0.00,150.00,2850.00,'2021-12-22 10:30:42','',''),(2344354,'1','141','764',322,'Retail Sale Id 1383915',5350.00,0.00,0.00,10.00,190.00,'2021-12-22 10:40:49','',''),(2344448,'1','141','764',322,'Retail Sale Id 1383970',22200.00,0.00,0.00,37.00,3108.00,'2021-12-22 10:50:13','',''),(2344458,'1','141','764',322,'Retail Sale Id 1384015',53500.00,0.00,0.00,100.00,1900.00,'2021-12-22 10:50:59','',''),(2344493,'1','141','764',322,'Retail Sale Id 1384044',3600.00,0.00,0.00,6.00,504.00,'2021-12-22 10:53:32','',''),(2344511,'1','141','764',322,'Retail Sale Id 1384069',1500.00,0.00,0.00,2.50,210.00,'2021-12-22 10:54:31','',''),(2344538,'1','141','764',322,'Retail Sale Id 1384090',28860.00,0.00,0.00,48.10,4040.40,'2021-12-22 10:57:30','',''),(2344559,'1','141','764',322,'Retail Sale Id 1384116',24180.00,0.00,0.00,40.30,3385.20,'2021-12-22 10:59:31','',''),(2344628,'1','141','764',322,'Retail Sale Id 1384178',31080.00,0.00,0.00,51.80,4351.20,'2021-12-22 11:06:15','',''),(2344639,'1','141','764',322,'Retail Sale Id 1384188',3000.00,0.00,0.00,5.00,420.00,'2021-12-22 11:07:22','',''),(2344666,'1','141','764',322,'Retail Sale Id 1384219',3000.00,0.00,0.00,5.00,420.00,'2021-12-22 11:10:34','',''),(2344680,'1','141','764',322,'Retail Sale Id 1384230',3000.00,0.00,0.00,5.00,420.00,'2021-12-22 11:11:46','',''),(2344787,'1','141','764',322,'Retail Sale Id 1384329',56710.00,0.00,0.00,106.00,2014.00,'2021-12-22 11:21:46','',''),(2344953,'1','141','764',322,'Retail Sale Id 1384483',34775.00,0.00,0.00,65.00,1235.00,'2021-12-22 11:37:11','',''),(2344982,'1','141','764',322,'Retail Sale Id 1384512',22500.00,0.00,0.00,37.50,3150.00,'2021-12-22 11:39:26','',''),(2344995,'1','141','764',322,'Retail Sale Id 1384526',2400.00,0.00,0.00,4.00,336.00,'2021-12-22 11:41:03','',''),(2345007,'1','141','764',322,'Retail Sale Id 1384534',2400.00,0.00,0.00,4.00,336.00,'2021-12-22 11:42:34','',''),(2345036,'1','141','764',322,'Retail Sale Id 1384566',88275.00,0.00,0.00,165.00,3135.00,'2021-12-22 11:45:17','',''),(2345064,'1','141','764',322,'Retail Sale Id 1384594',3498.00,0.00,0.00,5.83,489.72,'2021-12-22 11:48:32','',''),(2345081,'1','141','764',322,'Retail Sale Id 1384609',1800.00,0.00,0.00,3.00,252.00,'2021-12-22 11:49:58','',''),(2345102,'1','141','764',322,'Retail Sale Id 1384630',103522.50,0.00,0.00,193.50,3676.50,'2021-12-22 11:52:38','',''),(2345152,'1','141','764',322,'Retail Sale Id 1384685',1602.00,0.00,0.00,2.67,224.28,'2021-12-22 11:57:37','',''),(2345162,'1','141','764',322,'Retail Sale Id 1384696',11100.00,0.00,0.00,18.50,1554.00,'2021-12-22 11:59:03','',''),(2345201,'1','141','764',322,'Retail Sale Id 1384733',10800.00,0.00,0.00,18.00,1512.00,'2021-12-22 12:03:21','',''),(2345277,'1','141','764',322,'Retail Sale Id 1384805',3600.00,0.00,0.00,6.00,504.00,'2021-12-22 12:11:17','',''),(2345321,'1','141','764',322,'Retail Sale Id 1384845',2400.00,0.00,0.00,4.00,336.00,'2021-12-22 12:15:54','',''),(2345339,'1','141','764',322,'Retail Sale Id 1384864',59920.00,0.00,0.00,112.00,2128.00,'2021-12-22 12:18:20','',''),(2345420,'1','141','764',322,'Retail Sale Id 1384905',68212.50,0.00,0.00,127.50,2422.50,'2021-12-22 12:23:55','',''),(2345461,'1','141','764',322,'Retail Sale Id 1384944',2400.00,0.00,0.00,4.00,336.00,'2021-12-22 12:28:46','',''),(2345472,'1','141','764',322,'Retail Sale Id 1384956',3000.00,0.00,0.00,5.00,420.00,'2021-12-22 12:30:38','',''),(2345492,'1','141','764',322,'Retail Sale Id 1384982',3000.00,0.00,0.00,5.00,420.00,'2021-12-22 12:33:11','',''),(2346334,'1','141','764',322,'Retail Sale Id 1385640',2400.00,0.00,0.00,4.00,336.00,'2021-12-22 13:53:12','',''),(2346365,'1','141','764',322,'Retail Sale Id 1385359',1800.00,0.00,0.00,3.00,252.00,'2021-12-22 13:54:44','',''),(2346508,'1','141','764',322,'Retail Sale Id 1384981',3000.00,0.00,0.00,5.00,420.00,'2021-12-22 14:05:12','',''),(2346521,'1','141','764',322,'Retail Sale Id 1385733',1800.00,0.00,0.00,3.00,252.00,'2021-12-22 14:06:31','',''),(2346558,'1','141','764',322,'Retail Sale Id 1385754',3000.00,0.00,0.00,5.00,420.00,'2021-12-22 14:09:37','',''),(2346632,'1','141','764',322,'Retail Sale Id 1385816',1800.00,0.00,0.00,3.00,252.00,'2021-12-22 14:18:48','',''),(2346656,'1','141','764',322,'Retail Sale Id 1385851',600.00,0.00,0.00,1.00,84.00,'2021-12-22 14:21:06','',''),(2346666,'1','141','764',322,'Retail Sale Id 1385858',3600.00,0.00,0.00,6.00,504.00,'2021-12-22 14:22:06','',''),(2346688,'1','141','764',322,'Retail Sale Id 1385875',600.00,0.00,0.00,1.00,84.00,'2021-12-22 14:23:42','',''),(2346746,'1','141','764',322,'Retail Sale Id 1385927',3600.00,0.00,0.00,6.00,504.00,'2021-12-22 14:31:05','',''),(2346760,'1','141','764',322,'Retail Sale Id 1385937',3600.00,0.00,0.00,6.00,504.00,'2021-12-22 14:32:30','',''),(2346770,'1','141','764',322,'Retail Sale Id 1385947',3000.00,0.00,0.00,5.00,420.00,'2021-12-22 14:34:10','',''),(2346779,'1','141','764',322,'Retail Sale Id 1385957',600.00,0.00,0.00,1.00,84.00,'2021-12-22 14:35:08','',''),(2346798,'1','141','764',322,'Retail Sale Id 1385972',6420.00,0.00,0.00,12.00,228.00,'2021-12-22 14:36:58','',''),(2346821,'1','141','764',322,'Retail Sale Id 1385988',1500.00,0.00,0.00,2.50,210.00,'2021-12-22 14:38:50','',''),(2346847,'1','141','764',322,'Retail Sale Id 1385993',3000.00,0.00,0.00,5.00,420.00,'2021-12-22 14:39:49','',''),(2346909,'1','141','764',322,'Retail Sale Id 1386036',7500.00,0.00,0.00,12.50,1050.00,'2021-12-22 14:46:18','',''),(2346944,'1','141','764',322,'Retail Sale Id 1386074',2400.00,0.00,0.00,4.00,336.00,'2021-12-22 14:50:30','',''),(2346953,'1','141','764',322,'Retail Sale Id 1386082',3000.00,0.00,0.00,5.00,420.00,'2021-12-22 14:51:57','',''),(2346965,'1','141','764',322,'Retail Sale Id 1386093',7500.00,0.00,0.00,12.50,1050.00,'2021-12-22 14:53:33','',''),(2347046,'1','141','764',322,'Retail Sale Id 1386155',3000.00,0.00,0.00,5.00,420.00,'2021-12-22 15:00:50','',''),(2347130,'1','141','764',322,'Retail Sale Id 1386236',2400.00,0.00,0.00,4.00,336.00,'2021-12-22 15:09:24','',''),(2347143,'1','141','764',322,'Retail Sale Id 1386246',7500.00,0.00,0.00,12.50,1050.00,'2021-12-22 15:10:41','',''),(2347213,'1','141','764',322,'Retail Sale Id 1386300',26750.00,0.00,0.00,50.00,950.00,'2021-12-22 15:16:05','',''),(2347252,'1','141','764',322,'Retail Sale Id 1386333',3600.00,0.00,0.00,6.00,504.00,'2021-12-22 15:20:07','',''),(2347297,'1','141','764',322,'Retail Sale Id 1386355',1200.00,0.00,0.00,2.00,168.00,'2021-12-22 15:22:58','',''),(2347310,'1','141','764',322,'Retail Sale Id 1386369',4002.00,0.00,0.00,6.67,560.28,'2021-12-22 15:24:33','',''),(2347335,'1','141','764',322,'Retail Sale Id 1386385',600.00,0.00,0.00,1.00,84.00,'2021-12-22 15:25:57','',''),(2347364,'1','141','764',322,'Retail Sale Id 1386398',6955.00,0.00,0.00,13.00,247.00,'2021-12-22 15:27:18','',''),(2347399,'1','141','764',322,'Retail Sale Id 1386411',1200.00,0.00,0.00,2.00,168.00,'2021-12-22 15:29:16','',''),(2347422,'1','141','764',322,'Retail Sale Id 1386431',1998.00,0.00,0.00,3.33,279.72,'2021-12-22 15:30:47','',''),(2347463,'1','141','764',322,'Retail Sale Id 1386458',4200.00,0.00,0.00,7.00,588.00,'2021-12-22 15:33:41','',''),(2347481,'1','141','764',322,'Retail Sale Id 1386477',7500.00,0.00,0.00,12.50,1050.00,'2021-12-22 15:34:55','',''),(2347501,'1','141','764',322,'Retail Sale Id 1386495',1200.00,0.00,0.00,2.00,168.00,'2021-12-22 15:36:50','',''),(2347521,'1','141','764',322,'Retail Sale Id 1386514',7200.00,0.00,0.00,12.00,1008.00,'2021-12-22 15:38:22','',''),(2347558,'1','141','764',322,'Retail Sale Id 1386546',117700.00,0.00,0.00,220.00,4180.00,'2021-12-22 15:40:50','',''),(2347592,'1','141','764',322,'Retail Sale Id 1386581',3000.00,0.00,0.00,5.00,420.00,'2021-12-22 15:43:21','',''),(2347603,'1','141','764',322,'Retail Sale Id 1386593',3600.00,0.00,0.00,6.00,504.00,'2021-12-22 15:44:23','',''),(2347627,'1','141','764',322,'Retail Sale Id 1386611',3600.00,0.00,0.00,6.00,504.00,'2021-12-22 15:46:38','',''),(2347640,'1','141','764',322,'Retail Sale Id 1386634',1800.00,0.00,0.00,3.00,252.00,'2021-12-22 15:47:45','',''),(2347649,'1','141','764',322,'Retail Sale Id 1386642',1200.00,0.00,0.00,2.00,168.00,'2021-12-22 15:49:19','',''),(2347673,'1','141','764',322,'Retail Sale Id 1386658',1500.00,0.00,0.00,2.50,210.00,'2021-12-22 15:50:59','',''),(2347710,'1','141','764',322,'Retail Sale Id 1386680',53500.00,0.00,0.00,100.00,1900.00,'2021-12-22 15:54:07','',''),(2347735,'1','141','764',322,'Retail Sale Id 1386701',1002.00,0.00,0.00,1.67,140.28,'2021-12-22 15:55:53','',''),(2347797,'1','141','764',322,'Retail Sale Id 1386746',1800.00,0.00,0.00,3.00,252.00,'2021-12-22 16:01:51','',''),(2347844,'1','141','764',322,'Retail Sale Id 1386771',7500.00,0.00,0.00,12.50,1050.00,'2021-12-22 16:03:23','',''),(2348049,'1','141','764',322,'Retail Sale Id 1386942',820101.50,0.00,0.00,1532.90,29125.10,'2021-12-22 16:23:37','',''),(2348094,'1','141','764',322,'Retail Sale Id 1386989',151940.00,0.00,0.00,284.00,5396.00,'2021-12-22 16:29:19','',''),(2348123,'1','141','764',322,'Retail Sale Id 1387008',75180.00,0.00,0.00,125.30,10525.20,'2021-12-22 16:32:05','',''),(2350582,'1','141','764',322,'Retail Sale Id 1388563',3600.00,0.00,0.00,6.00,504.00,'2021-12-23 07:46:19','',''),(2350602,'1','141','764',322,'Retail Sale Id 1388581',3600.00,0.00,0.00,6.00,504.00,'2021-12-23 07:47:42','',''),(2350616,'1','141','764',322,'Retail Sale Id 1388595',3600.00,0.00,0.00,6.00,504.00,'2021-12-23 07:49:38','',''),(2350632,'1','141','764',322,'Retail Sale Id 1388609',3000.00,0.00,0.00,5.00,420.00,'2021-12-23 07:51:01','',''),(2350642,'1','141','764',322,'Retail Sale Id 1388621',6000.00,0.00,0.00,10.00,840.00,'2021-12-23 07:52:20','',''),(2350659,'1','141','764',322,'Retail Sale Id 1388629',8400.00,0.00,0.00,14.00,1176.00,'2021-12-23 07:54:30','',''),(2350738,'1','141','764',322,'Retail Sale Id 1388719',2400.00,0.00,0.00,4.00,336.00,'2021-12-23 08:03:38','',''),(2351047,'1','141','764',322,'Retail Sale Id 1388998',3000.00,0.00,0.00,5.00,420.00,'2021-12-23 08:32:51','',''),(2351075,'1','141','764',322,'Retail Sale Id 1389028',1200.00,0.00,0.00,2.00,168.00,'2021-12-23 08:35:54','',''),(2351130,'1','141','764',322,'Retail Sale Id 1389063',13500.00,0.00,0.00,22.50,1890.00,'2021-12-23 08:39:43','',''),(2351144,'1','141','764',322,'Retail Sale Id 1389080',12900.00,0.00,0.00,21.50,1806.00,'2021-12-23 08:41:04','',''),(2351176,'1','141','764',322,'Retail Sale Id 1389110',13080.00,0.00,0.00,21.80,1831.20,'2021-12-23 08:44:11','',''),(2351185,'1','141','764',322,'Retail Sale Id 1389122',18480.00,0.00,0.00,30.80,2587.20,'2021-12-23 08:45:36','',''),(2351194,'1','141','764',322,'Retail Sale Id 1389130',20100.00,0.00,0.00,33.50,2814.00,'2021-12-23 08:46:38','',''),(2351218,'1','141','764',322,'Retail Sale Id 1389142',41462.50,0.00,0.00,77.50,1472.50,'2021-12-23 08:47:49','',''),(2351242,'1','141','764',322,'Retail Sale Id 1389165',6000.00,0.00,0.00,10.00,840.00,'2021-12-23 08:50:21','',''),(2351261,'1','141','764',322,'Retail Sale Id 1389184',652967.50,0.00,0.00,1220.50,23189.50,'2021-12-23 08:52:15','',''),(2351274,'1','141','764',322,'Retail Sale Id 1389201',315650.00,0.00,0.00,590.00,11210.00,'2021-12-23 08:53:30','',''),(2351329,'1','141','764',322,'Retail Sale Id 1389251',87205.00,0.00,0.00,163.00,3097.00,'2021-12-23 08:58:56','',''),(2351348,'1','141','764',322,'Retail Sale Id 1389272',1200.00,0.00,0.00,2.00,168.00,'2021-12-23 09:00:55','',''),(2351363,'1','141','764',322,'Retail Sale Id 1389288',1980.00,0.00,0.00,3.30,277.20,'2021-12-23 09:02:34','',''),(2351373,'1','141','764',322,'Retail Sale Id 1389294',600.00,0.00,0.00,1.00,84.00,'2021-12-23 09:03:43','',''),(2351390,'1','141','764',322,'Retail Sale Id 1389307',2400.00,0.00,0.00,4.00,336.00,'2021-12-23 09:05:41','',''),(2351402,'1','141','764',322,'Retail Sale Id 1389327',1980.00,0.00,0.00,3.30,277.20,'2021-12-23 09:07:05','',''),(2351416,'1','141','764',322,'Retail Sale Id 1389339',1800.00,0.00,0.00,3.00,252.00,'2021-12-23 09:08:27','',''),(2351432,'1','141','764',322,'Retail Sale Id 1389351',12000.00,0.00,0.00,20.00,1680.00,'2021-12-23 09:09:43','',''),(2351444,'1','141','764',322,'Retail Sale Id 1389363',3600.00,0.00,0.00,6.00,504.00,'2021-12-23 09:11:01','',''),(2351458,'1','141','764',322,'Retail Sale Id 1389382',1800.00,0.00,0.00,3.00,252.00,'2021-12-23 09:12:40','',''),(2351567,'1','141','764',322,'Retail Sale Id 1389493',1698.00,0.00,0.00,2.83,237.72,'2021-12-23 09:24:49','',''),(2351589,'1','141','764',322,'Retail Sale Id 1389503',57780.00,0.00,0.00,108.00,2052.00,'2021-12-23 09:26:41','',''),(2351668,'1','141','764',322,'Retail Sale Id 1389560',60722.50,0.00,0.00,113.50,2156.50,'2021-12-23 09:31:33','',''),(2351692,'1','141','764',322,'Retail Sale Id 1389583',7200.00,0.00,0.00,12.00,1008.00,'2021-12-23 09:33:18','',''),(2351709,'1','141','764',322,'Retail Sale Id 1389603',2400.00,0.00,0.00,4.00,336.00,'2021-12-23 09:34:32','',''),(2351732,'1','141','764',322,'Retail Sale Id 1389629',3000.00,0.00,0.00,5.00,420.00,'2021-12-23 09:36:24','',''),(2351759,'1','141','764',322,'Retail Sale Id 1389644',3000.00,0.00,0.00,5.00,420.00,'2021-12-23 09:37:39','',''),(2351804,'1','141','764',322,'Retail Sale Id 1389674',1800.00,0.00,0.00,3.00,252.00,'2021-12-23 09:39:44','',''),(2351840,'1','141','764',322,'Retail Sale Id 1389709',128400.00,0.00,0.00,240.00,4560.00,'2021-12-23 09:42:19','',''),(2351903,'1','141','764',322,'Retail Sale Id 1389766',16050.00,0.00,0.00,30.00,570.00,'2021-12-23 09:47:19','',''),(2351941,'1','141','764',322,'Retail Sale Id 1389799',5700.00,0.00,0.00,9.50,798.00,'2021-12-23 09:49:45','',''),(2351980,'1','141','764',322,'Retail Sale Id 1389841',600.00,0.00,0.00,1.00,84.00,'2021-12-23 09:53:31','',''),(2352117,'1','141','764',322,'Retail Sale Id 1389907',119037.50,0.00,0.00,222.50,4227.50,'2021-12-23 09:59:25','',''),(2352177,'1','141','764',322,'Retail Sale Id 1389922',6420.00,0.00,0.00,12.00,228.00,'2021-12-23 10:01:19','',''),(2352216,'1','141','764',322,'Retail Sale Id 1389963',147125.00,0.00,0.00,275.00,5225.00,'2021-12-23 10:04:09','',''),(2352236,'1','141','764',322,'Retail Sale Id 1389985',66340.00,0.00,0.00,124.00,2356.00,'2021-12-23 10:06:24','',''),(2352257,'1','141','764',322,'Retail Sale Id 1390004',4200.00,0.00,0.00,7.00,588.00,'2021-12-23 10:08:59','',''),(2352268,'1','141','764',322,'Retail Sale Id 1390018',1800.00,0.00,0.00,3.00,252.00,'2021-12-23 10:10:15','',''),(2352279,'1','141','764',322,'Retail Sale Id 1390034',7500.00,0.00,0.00,12.50,1050.00,'2021-12-23 10:11:17','',''),(2352291,'1','141','764',322,'Retail Sale Id 1390047',3600.00,0.00,0.00,6.00,504.00,'2021-12-23 10:12:44','',''),(2352308,'1','141','764',322,'Retail Sale Id 1390056',38787.50,0.00,0.00,72.50,1377.50,'2021-12-23 10:14:19','',''),(2352322,'1','141','764',322,'Retail Sale Id 1390078',31030.00,0.00,0.00,58.00,1102.00,'2021-12-23 10:16:16','',''),(2352370,'1','141','764',322,'Retail Sale Id 1390110',900.00,0.00,0.00,1.50,126.00,'2021-12-23 10:19:25','',''),(2352397,'1','141','764',322,'Retail Sale Id 1390137',57780.00,0.00,0.00,108.00,2052.00,'2021-12-23 10:21:54','',''),(2352415,'1','141','764',322,'Retail Sale Id 1390160',33437.50,0.00,0.00,62.50,1187.50,'2021-12-23 10:23:39','',''),(2352441,'1','141','764',322,'Retail Sale Id 1390189',3600.00,0.00,0.00,6.00,504.00,'2021-12-23 10:26:29','',''),(2352451,'1','141','764',322,'Retail Sale Id 1390200',40125.00,0.00,0.00,75.00,1425.00,'2021-12-23 10:27:40','',''),(2352471,'1','141','764',322,'Retail Sale Id 1390219',3600.00,0.00,0.00,6.00,504.00,'2021-12-23 10:29:21','',''),(2352482,'1','141','764',322,'Retail Sale Id 1390233',3000.00,0.00,0.00,5.00,420.00,'2021-12-23 10:30:29','',''),(2352497,'1','141','764',322,'Retail Sale Id 1390245',10200.00,0.00,0.00,17.00,1428.00,'2021-12-23 10:31:56','',''),(2352507,'1','141','764',322,'Retail Sale Id 1390258',1800.00,0.00,0.00,3.00,252.00,'2021-12-23 10:33:18','',''),(2352529,'1','141','764',322,'Retail Sale Id 1390275',41195.00,0.00,0.00,77.00,1463.00,'2021-12-23 10:34:46','',''),(2352566,'1','141','764',322,'Retail Sale Id 1390326',128400.00,0.00,0.00,240.00,4560.00,'2021-12-23 10:38:13','',''),(2352605,'1','141','764',322,'Retail Sale Id 1390366',2502.00,0.00,0.00,4.17,350.28,'2021-12-23 10:41:27','',''),(2352622,'1','141','764',322,'Retail Sale Id 1390380',6687.50,0.00,0.00,12.50,237.50,'2021-12-23 10:42:52','',''),(2352657,'1','141','764',322,'Retail Sale Id 1390417',1200.00,0.00,0.00,2.00,168.00,'2021-12-23 10:45:46','',''),(2352670,'1','141','764',322,'Retail Sale Id 1390428',2400.00,0.00,0.00,4.00,336.00,'2021-12-23 10:46:57','',''),(2352682,'1','141','764',322,'Retail Sale Id 1390443',1500.00,0.00,0.00,2.50,210.00,'2021-12-23 10:48:11','',''),(2352695,'1','141','764',322,'Retail Sale Id 1390456',1980.00,0.00,0.00,3.30,277.20,'2021-12-23 10:49:13','',''),(2352711,'1','141','764',322,'Retail Sale Id 1390466',147125.00,0.00,0.00,275.00,5225.00,'2021-12-23 10:50:55','',''),(2352851,'1','141','764',322,'Retail Sale Id 1390602',26750.00,0.00,0.00,50.00,950.00,'2021-12-23 11:03:27','',''),(2352869,'1','141','764',322,'Retail Sale Id 1390623',1800.00,0.00,0.00,3.00,252.00,'2021-12-23 11:05:30','',''),(2352918,'1','141','764',322,'Retail Sale Id 1390673',157825.00,0.00,0.00,295.00,5605.00,'2021-12-23 11:10:05','',''),(2352961,'1','141','764',322,'Retail Sale Id 1390717',3600.00,0.00,0.00,6.00,504.00,'2021-12-23 11:14:05','',''),(2352985,'1','141','764',322,'Retail Sale Id 1390727',7200.00,0.00,0.00,12.00,1008.00,'2021-12-23 11:15:30','',''),(2353001,'1','141','764',322,'Retail Sale Id 1390742',2400.00,0.00,0.00,4.00,336.00,'2021-12-23 11:16:37','',''),(2353030,'1','141','764',322,'Retail Sale Id 1390775',101917.50,0.00,0.00,190.50,3619.50,'2021-12-23 11:19:46','',''),(2353076,'1','141','764',322,'Retail Sale Id 1390816',117700.00,0.00,0.00,220.00,4180.00,'2021-12-23 11:24:42','',''),(2353106,'1','141','764',322,'Retail Sale Id 1390845',600.00,0.00,0.00,1.00,84.00,'2021-12-23 11:28:27','',''),(2353131,'1','141','764',322,'Retail Sale Id 1390879',9630.00,0.00,0.00,18.00,342.00,'2021-12-23 11:30:42','',''),(2353150,'1','141','764',322,'Retail Sale Id 1390895',1902.00,0.00,0.00,3.17,266.28,'2021-12-23 11:32:16','',''),(2353161,'1','141','764',322,'Retail Sale Id 1390908',1980.00,0.00,0.00,3.30,277.20,'2021-12-23 11:33:27','',''),(2353185,'1','141','764',322,'Retail Sale Id 1390929',1002.00,0.00,0.00,1.67,140.28,'2021-12-23 11:36:00','',''),(2353202,'1','141','764',322,'Retail Sale Id 1390950',1800.00,0.00,0.00,3.00,252.00,'2021-12-23 11:37:56','',''),(2353217,'1','141','764',322,'Retail Sale Id 1390961',6000.00,0.00,0.00,10.00,840.00,'2021-12-23 11:39:16','',''),(2353235,'1','141','764',322,'Retail Sale Id 1390979',2400.00,0.00,0.00,4.00,336.00,'2021-12-23 11:41:02','',''),(2353248,'1','141','764',322,'Retail Sale Id 1390997',1200.00,0.00,0.00,2.00,168.00,'2021-12-23 11:42:20','',''),(2353261,'1','141','764',322,'Retail Sale Id 1391013',3600.00,0.00,0.00,6.00,504.00,'2021-12-23 11:43:39','',''),(2353278,'1','141','764',322,'Retail Sale Id 1391026',1800.00,0.00,0.00,3.00,252.00,'2021-12-23 11:45:00','',''),(2353291,'1','141','764',322,'Retail Sale Id 1391036',1860.00,0.00,0.00,3.10,260.40,'2021-12-23 11:46:29','',''),(2353308,'1','141','764',322,'Retail Sale Id 1391055',68480.00,0.00,0.00,128.00,2432.00,'2021-12-23 11:48:25','',''),(2353325,'1','141','764',322,'Retail Sale Id 1391066',1800.00,0.00,0.00,3.00,252.00,'2021-12-23 11:49:34','',''),(2353337,'1','141','764',322,'Retail Sale Id 1391081',3600.00,0.00,0.00,6.00,504.00,'2021-12-23 11:50:41','',''),(2353347,'1','141','764',322,'Retail Sale Id 1391091',46812.50,0.00,0.00,87.50,1662.50,'2021-12-23 11:52:13','',''),(2353381,'1','141','764',322,'Retail Sale Id 1391119',7200.00,0.00,0.00,12.00,1008.00,'2021-12-23 11:55:30','',''),(2353391,'1','141','764',322,'Retail Sale Id 1391131',3600.00,0.00,0.00,6.00,504.00,'2021-12-23 11:56:40','',''),(2353405,'1','141','764',322,'Retail Sale Id 1391145',1800.00,0.00,0.00,3.00,252.00,'2021-12-23 11:57:58','',''),(2353438,'1','141','764',322,'Retail Sale Id 1391172',7500.00,0.00,0.00,12.50,1050.00,'2021-12-23 12:00:41','',''),(2353526,'1','141','764',322,'Retail Sale Id 1391242',7500.00,0.00,0.00,12.50,1050.00,'2021-12-23 12:07:43','',''),(2353557,'1','141','764',322,'Retail Sale Id 1391276',31030.00,0.00,0.00,58.00,1102.00,'2021-12-23 12:11:03','',''),(2353652,'1','141','764',322,'Retail Sale Id 1391357',21600.00,0.00,0.00,36.00,3024.00,'2021-12-23 12:20:15','',''),(2354727,'1','141','764',322,'Retail Sale Id 1392321',92388.00,0.00,0.00,153.98,12934.32,'2021-12-23 13:51:07','',''),(2355327,'1','141','764',322,'Retail Sale Id 1392681',135355.00,0.00,0.00,253.00,4807.00,'2021-12-23 14:30:01','',''),(2355356,'1','141','764',322,'Retail Sale Id 1392690',188320.00,0.00,0.00,352.00,6688.00,'2021-12-23 14:31:15','',''),(2355452,'1','141','764',322,'Retail Sale Id 1392723',147125.00,0.00,0.00,275.00,5225.00,'2021-12-23 14:41:14','',''),(2355458,'1','141','764',322,'Retail Sale Id 1392795',324745.00,0.00,0.00,607.00,11533.00,'2021-12-23 14:42:20','',''),(2355489,'1','141','764',322,'Retail Sale Id 1392817',32100.00,0.00,0.00,60.00,1140.00,'2021-12-23 14:46:12','',''),(2355600,'1','141','764',322,'Retail Sale Id 1392930',62060.00,0.00,0.00,116.00,2204.00,'2021-12-23 14:56:52','',''),(2355631,'1','141','764',322,'Retail Sale Id 1392939',96300.00,0.00,0.00,180.00,3420.00,'2021-12-23 14:59:48','',''),(2355664,'1','141','764',322,'Retail Sale Id 1392996',109675.00,0.00,0.00,205.00,3895.00,'2021-12-23 15:03:13','',''),(2355894,'1','141','764',322,'Retail Sale Id 1393202',11770.00,0.00,0.00,22.00,418.00,'2021-12-23 15:22:30','',''),(2356484,'1','141','764',322,'Retail Sale Id 1393774',40740.00,0.00,0.00,67.90,5703.60,'2021-12-23 16:14:40','',''),(2356511,'1','141','764',322,'Retail Sale Id 1393801',11770.00,0.00,0.00,22.00,418.00,'2021-12-23 16:16:23','',''),(2358269,'1','141','764',322,'Distributed to OPERATIONAL LOSS for sales id:341916',190073.76,0.00,0.00,368.36,0.00,'2021-12-24 05:07:39','',''),(2360237,'1','141',NULL,322,'Purchased from AA RANO NIGERIA LIMITED',0.00,12879360.00,24960.00,0.00,0.00,'2021-12-24 08:52:02','',''),(2360288,'1','141',NULL,322,'Reception corrector for bridging 128588',0.00,0.00,0.00,24960.00,0.00,'2021-12-24 08:54:05','',''),(2360289,'1','141','764',322,'Received from bridging 128588',0.00,0.00,24960.00,0.00,0.00,'2021-12-24 08:54:05','',''),(2361997,'1','141','764',322,'Retail Sale Id 1398148',7500.00,0.00,0.00,12.50,1050.00,'2021-12-24 11:00:45','',''),(2363025,'1','141','764',322,'Retail Sale Id 1399117',12000.00,0.00,0.00,20.00,1680.00,'2021-12-24 12:40:51','',''),(2363074,'1','141','764',322,'Retail Sale Id 1399154',147125.00,0.00,0.00,275.00,5225.00,'2021-12-24 12:46:21','',''),(2363183,'1','141','764',322,'Retail Sale Id 1399306',107000.00,0.00,0.00,200.00,3800.00,'2021-12-24 12:58:44','',''),(2363198,'1','141','764',322,'Retail Sale Id 1399325',80250.00,0.00,0.00,150.00,2850.00,'2021-12-24 12:59:55','',''),(2364812,'1','141','764',322,'Retail Sale Id 1400554',30000.00,0.00,0.00,50.00,4200.00,'2021-12-24 14:56:59','',''),(2365003,'1','141','764',322,'Retail Sale Id 1400732',8400.00,0.00,0.00,14.00,1176.00,'2021-12-24 15:13:16','',''),(2366368,'1','141','764',322,'Retail Sale Id 1401904',2786280.00,0.00,0.00,5208.00,98952.00,'2021-12-24 16:51:42','',''),(2366381,'1','141','764',322,'Retail Sale Id 1401922',315115.00,0.00,0.00,589.00,11191.00,'2021-12-24 16:53:09','',''),(2366395,'1','141','764',322,'Retail Sale Id 1401937',30000.00,0.00,0.00,50.00,4200.00,'2021-12-24 16:54:13','',''),(2366421,'1','141','764',322,'Retail Sale Id 1401954',27000.00,0.00,0.00,45.00,3780.00,'2021-12-24 16:55:41','',''),(2366435,'1','141','764',322,'Retail Sale Id 1401963',15000.00,0.00,0.00,25.00,2100.00,'2021-12-24 16:56:37','',''),(2366446,'1','141','764',322,'Retail Sale Id 1401978',18000.00,0.00,0.00,30.00,2520.00,'2021-12-24 16:57:31','',''),(2366459,'1','141','764',322,'Retail Sale Id 1401993',147125.00,0.00,0.00,275.00,5225.00,'2021-12-24 16:58:10','',''),(2366474,'1','141','764',322,'Retail Sale Id 1402009',107000.00,0.00,0.00,200.00,3800.00,'2021-12-24 16:59:01','',''),(2366491,'1','141','764',322,'Retail Sale Id 1402023',104325.00,0.00,0.00,195.00,3705.00,'2021-12-24 16:59:53','',''),(2366499,'1','141','764',322,'Retail Sale Id 1402034',267500.00,0.00,0.00,500.00,9500.00,'2021-12-24 17:00:34','',''),(2366509,'1','141','764',322,'Retail Sale Id 1402045',9000.00,0.00,0.00,15.00,1260.00,'2021-12-24 17:01:32','',''),(2366523,'1','141','764',322,'Retail Sale Id 1402055',7500.00,0.00,0.00,12.50,1050.00,'2021-12-24 17:02:20','',''),(2366543,'1','141','764',322,'Retail Sale Id 1402077',6000.00,0.00,0.00,10.00,840.00,'2021-12-24 17:03:37','',''),(2366557,'1','141','764',322,'Retail Sale Id 1402086',9300.00,0.00,0.00,15.50,1302.00,'2021-12-24 17:04:31','',''),(2366572,'1','141','764',322,'Retail Sale Id 1402100',15000.00,0.00,0.00,25.00,2100.00,'2021-12-24 17:05:27','',''),(2366588,'1','141','764',322,'Retail Sale Id 1402113',6300.00,0.00,0.00,10.50,882.00,'2021-12-24 17:06:30','',''),(2366606,'1','141','764',322,'Retail Sale Id 1402129',24000.00,0.00,0.00,40.00,3360.00,'2021-12-24 17:07:32','',''),(2366623,'1','141','764',322,'Retail Sale Id 1402143',7500.00,0.00,0.00,12.50,1050.00,'2021-12-24 17:08:25','',''),(2366642,'1','141','764',322,'Retail Sale Id 1402162',5400.00,0.00,0.00,9.00,756.00,'2021-12-24 17:09:20','',''),(2366671,'1','141','764',322,'Retail Sale Id 1402192',160500.00,0.00,0.00,300.00,5700.00,'2021-12-24 17:11:45','',''),(2366680,'1','141','764',322,'Retail Sale Id 1402201',147125.00,0.00,0.00,275.00,5225.00,'2021-12-24 17:12:29','',''),(2366695,'1','141','764',322,'Retail Sale Id 1402212',267500.00,0.00,0.00,500.00,9500.00,'2021-12-24 17:13:33','',''),(2366784,'1','141','764',322,'Retail Sale Id 1402283',146700.00,0.00,0.00,244.50,20538.00,'2021-12-24 17:19:21','',''),(2366799,'1','141','764',322,'Retail Sale Id 1402296',1819000.00,0.00,0.00,3400.00,64600.00,'2021-12-24 17:20:23','',''),(2366826,'1','141','764',322,'Retail Sale Id 1402326',321000.00,0.00,0.00,600.00,11400.00,'2021-12-24 17:23:24','',''),(2366831,'1','141','764',322,'Retail Sale Id 1402331',147125.00,0.00,0.00,275.00,5225.00,'2021-12-24 17:23:54','',''),(2366836,'1','141','764',322,'Retail Sale Id 1402336',235400.00,0.00,0.00,440.00,8360.00,'2021-12-24 17:24:23','',''),(2366865,'1','141','764',322,'Return of Retail Sale Id 1402212',0.00,267500.00,500.00,0.00,-9500.00,'2021-12-24 17:27:16','',''),(2366869,'1','141','764',322,'Return of Retail Sale Id 1402331',0.00,147125.00,275.00,0.00,-5225.00,'2021-12-24 17:28:04','',''),(2366887,'1','141','764',322,'Retail Sale Id 1402383',102773.50,0.00,0.00,192.10,3649.90,'2021-12-24 17:30:08','',''),(2366902,'1','141','764',322,'Retail Sale Id 1402394',96780.00,0.00,0.00,161.30,13549.20,'2021-12-24 17:32:20','',''),(2366943,'1','141','764',322,'Retail Sale Id 1402421',26750.00,0.00,0.00,50.00,950.00,'2021-12-24 17:35:53','',''),(2371300,'1','141','764',322,'Retail Sale Id 1405948',136980.00,0.00,0.00,228.30,19177.20,'2021-12-25 11:11:45','',''),(2371404,'1','141','764',322,'Retail Sale Id 1406059',2854492.50,0.00,0.00,5335.50,101374.50,'2021-12-25 11:21:58','',''),(2373318,'1','141','764',322,'Retail Sale Id 1407591',2898630.00,0.00,0.00,5418.00,102942.00,'2021-12-25 14:41:50','',''),(2380524,'1','141','764',322,'Distributed to OPERATIONAL LOSS for sales id:342513',168628.80,0.00,0.00,326.80,0.00,'2021-12-27 06:16:43','',''),(2380537,'1','141',NULL,322,'Purchased from AA RANO NIGERIA LIMITED',0.00,12675000.00,25000.00,0.00,0.00,'2021-12-27 06:20:44','',''),(2380543,'1','141',NULL,322,'Reception corrector for bridging 128855',0.00,0.00,0.00,25000.00,0.00,'2021-12-27 06:22:19','',''),(2380544,'1','141','764',322,'Received from bridging 128855',0.00,0.00,25000.00,0.00,0.00,'2021-12-27 06:22:19','',''),(2384037,'1','141','764',322,'Retail Sale Id 1415657',7500.00,0.00,0.00,12.50,1162.50,'2021-12-27 12:46:20','',''),(2384042,'1','141','764',322,'Retail Sale Id 1415662',6000.00,0.00,0.00,10.00,930.00,'2021-12-27 12:46:50','',''),(2384043,'1','141','764',322,'Retail Sale Id 1415666',7500.00,0.00,0.00,12.50,1162.50,'2021-12-27 12:47:18','',''),(2384051,'1','141','764',322,'Retail Sale Id 1415673',104000.00,0.00,0.00,200.00,2600.00,'2021-12-27 12:47:48','',''),(2384070,'1','141','764',322,'Retail Sale Id 1415674',143000.00,0.00,0.00,275.00,3575.00,'2021-12-27 12:48:33','',''),(2384073,'1','141','764',322,'Retail Sale Id 1415679',78000.00,0.00,0.00,150.00,1950.00,'2021-12-27 12:49:05','',''),(2384086,'1','141','764',322,'Retail Sale Id 1415682',104000.00,0.00,0.00,200.00,2600.00,'2021-12-27 12:49:36','',''),(2384091,'1','141','764',322,'Retail Sale Id 1415685',52000.00,0.00,0.00,100.00,1300.00,'2021-12-27 12:50:12','',''),(2384098,'1','141','764',322,'Retail Sale Id 1415691',223600.00,0.00,0.00,430.00,5590.00,'2021-12-27 12:50:41','',''),(2384100,'1','141','764',322,'Retail Sale Id 1415693',104000.00,0.00,0.00,200.00,2600.00,'2021-12-27 12:51:16','',''),(2384104,'1','141','764',322,'Retail Sale Id 1415696',15000.00,0.00,0.00,25.00,2325.00,'2021-12-27 12:51:43','',''),(2384108,'1','141','764',322,'Retail Sale Id 1415700',6000.00,0.00,0.00,10.00,930.00,'2021-12-27 12:52:10','',''),(2384110,'1','141','764',322,'Retail Sale Id 1415703',312000.00,0.00,0.00,600.00,7800.00,'2021-12-27 12:52:40','',''),(2384122,'1','141','764',322,'Retail Sale Id 1415715',3900.00,0.00,0.00,6.50,604.50,'2021-12-27 12:54:09','',''),(2384127,'1','141','764',322,'Retail Sale Id 1415718',7200.00,0.00,0.00,12.00,1116.00,'2021-12-27 12:54:48','',''),(2384129,'1','141','764',322,'Retail Sale Id 1415721',6000.00,0.00,0.00,10.00,930.00,'2021-12-27 12:55:15','',''),(2384136,'1','141','764',322,'Retail Sale Id 1415731',900.00,0.00,0.00,1.50,139.50,'2021-12-27 12:56:31','',''),(2384138,'1','141','764',322,'Retail Sale Id 1415733',3600.00,0.00,0.00,6.00,558.00,'2021-12-27 12:56:59','',''),(2384143,'1','141','764',322,'Retail Sale Id 1415737',3600.00,0.00,0.00,6.00,558.00,'2021-12-27 12:57:25','',''),(2384146,'1','141','764',322,'Retail Sale Id 1415740',6600.00,0.00,0.00,11.00,1023.00,'2021-12-27 12:58:14','',''),(2384186,'1','141','764',322,'Retail Sale Id 1415749',6000.00,0.00,0.00,10.00,930.00,'2021-12-27 13:00:11','',''),(2384192,'1','141','764',322,'Retail Sale Id 1415756',31200.00,0.00,0.00,60.00,780.00,'2021-12-27 13:01:10','',''),(2384217,'1','141','764',322,'Retail Sale Id 1415775',600.00,0.00,0.00,1.00,93.00,'2021-12-27 13:04:24','',''),(2384230,'1','141','764',322,'Retail Sale Id 1415788',1800.00,0.00,0.00,3.00,279.00,'2021-12-27 13:07:07','',''),(2384238,'1','141','764',322,'Retail Sale Id 1415794',1800.00,0.00,0.00,3.00,279.00,'2021-12-27 13:08:33','',''),(2384250,'1','141','764',322,'Retail Sale Id 1415806',2400.00,0.00,0.00,4.00,372.00,'2021-12-27 13:10:29','',''),(2384316,'1','141','764',322,'Retail Sale Id 1415866',600.00,0.00,0.00,1.00,93.00,'2021-12-27 13:19:48','',''),(2384382,'1','141','764',322,'Retail Sale Id 1415902',78000.00,0.00,0.00,150.00,1950.00,'2021-12-27 13:25:57','',''),(2384385,'1','141','764',322,'Retail Sale Id 1415911',1200.00,0.00,0.00,2.00,186.00,'2021-12-27 13:26:39','',''),(2384393,'1','141','764',322,'Retail Sale Id 1415919',1800.00,0.00,0.00,3.00,279.00,'2021-12-27 13:27:13','',''),(2384409,'1','141','764',322,'Retail Sale Id 1415935',2400.00,0.00,0.00,4.00,372.00,'2021-12-27 13:30:11','',''),(2384414,'1','141','764',322,'Retail Sale Id 1415939',6600.00,0.00,0.00,11.00,1023.00,'2021-12-27 13:30:41','',''),(2384417,'1','141','764',322,'Retail Sale Id 1415943',23400.00,0.00,0.00,45.00,585.00,'2021-12-27 13:31:25','',''),(2384435,'1','141','764',322,'Retail Sale Id 1415954',1800.00,0.00,0.00,3.00,279.00,'2021-12-27 13:33:33','',''),(2384483,'1','141','764',322,'Retail Sale Id 1415985',7200.00,0.00,0.00,12.00,1116.00,'2021-12-27 13:38:10','',''),(2384533,'1','141','764',322,'Retail Sale Id 1416021',4800.00,0.00,0.00,8.00,744.00,'2021-12-27 13:45:01','',''),(2384555,'1','141','764',322,'Retail Sale Id 1416031',1040.00,0.00,0.00,2.00,26.00,'2021-12-27 13:48:17','',''),(2384905,'1','141','764',322,'Retail Sale Id 1416257',62400.00,0.00,0.00,120.00,1560.00,'2021-12-27 14:32:03','',''),(2384909,'1','141','764',322,'Retail Sale Id 1416259',7200.00,0.00,0.00,12.00,1116.00,'2021-12-27 14:32:33','',''),(2385093,'1','141','764',322,'Retail Sale Id 1416428',98800.00,0.00,0.00,190.00,2470.00,'2021-12-27 15:03:32','',''),(2385128,'1','141','764',322,'Retail Sale Id 1416465',33000.00,0.00,0.00,55.00,5115.00,'2021-12-27 15:10:36','',''),(2385273,'1','141','764',322,'Retail Sale Id 1416580',143000.00,0.00,0.00,275.00,3575.00,'2021-12-27 15:34:39','',''),(2385293,'1','141','764',322,'Retail Sale Id 1416587',296400.00,0.00,0.00,570.00,7410.00,'2021-12-27 15:35:33','',''),(2385297,'1','141','764',322,'Retail Sale Id 1416590',7500.00,0.00,0.00,12.50,1162.50,'2021-12-27 15:36:33','',''),(2385309,'1','141','764',322,'Retail Sale Id 1416599',312000.00,0.00,0.00,600.00,7800.00,'2021-12-27 15:37:19','',''),(2385313,'1','141','764',322,'Retail Sale Id 1416603',15000.00,0.00,0.00,25.00,2325.00,'2021-12-27 15:38:09','',''),(2385321,'1','141','764',322,'Retail Sale Id 1416611',208000.00,0.00,0.00,400.00,5200.00,'2021-12-27 15:39:05','',''),(2385340,'1','141','764',322,'Retail Sale Id 1416617',197600.00,0.00,0.00,380.00,4940.00,'2021-12-27 15:40:01','',''),(2385353,'1','141','764',322,'Retail Sale Id 1416624',3600.00,0.00,0.00,6.00,558.00,'2021-12-27 15:40:37','',''),(2385358,'1','141','764',322,'Retail Sale Id 1416628',9900.00,0.00,0.00,16.50,1534.50,'2021-12-27 15:41:30','',''),(2385363,'1','141','764',322,'Retail Sale Id 1416629',9000.00,0.00,0.00,15.00,1395.00,'2021-12-27 15:42:13','',''),(2385367,'1','141','764',322,'Retail Sale Id 1416635',3600.00,0.00,0.00,6.00,558.00,'2021-12-27 15:42:55','',''),(2385379,'1','141','764',322,'Retail Sale Id 1416642',390260.00,0.00,0.00,750.50,9756.50,'2021-12-27 15:43:45','',''),(2385383,'1','141','764',322,'Retail Sale Id 1416646',286000.00,0.00,0.00,550.00,7150.00,'2021-12-27 15:44:28','',''),(2385390,'1','141','764',322,'Retail Sale Id 1416651',395200.00,0.00,0.00,760.00,9880.00,'2021-12-27 15:45:33','',''),(2385393,'1','141','764',322,'Retail Sale Id 1416655',52000.00,0.00,0.00,100.00,1300.00,'2021-12-27 15:46:17','',''),(2385398,'1','141','764',322,'Retail Sale Id 1416662',5100.00,0.00,0.00,8.50,790.50,'2021-12-27 15:47:04','',''),(2385403,'1','141','764',322,'Retail Sale Id 1416665',1800.00,0.00,0.00,3.00,279.00,'2021-12-27 15:47:42','',''),(2385408,'1','141','764',322,'Retail Sale Id 1416671',7500.00,0.00,0.00,12.50,1162.50,'2021-12-27 15:48:28','',''),(2385412,'1','141','764',322,'Retail Sale Id 1416676',3000.00,0.00,0.00,5.00,465.00,'2021-12-27 15:49:02','',''),(2385418,'1','141','764',322,'Retail Sale Id 1416683',13800.00,0.00,0.00,23.00,2139.00,'2021-12-27 15:49:51','',''),(2385427,'1','141','764',322,'Retail Sale Id 1416689',1200.00,0.00,0.00,2.00,186.00,'2021-12-27 15:50:33','',''),(2385444,'1','141','764',322,'Retail Sale Id 1416700',4200.00,0.00,0.00,7.00,651.00,'2021-12-27 15:51:36','',''),(2385450,'1','141','764',322,'Retail Sale Id 1416709',2400.00,0.00,0.00,4.00,372.00,'2021-12-27 15:52:22','',''),(2385454,'1','141','764',322,'Retail Sale Id 1416713',104000.00,0.00,0.00,200.00,2600.00,'2021-12-27 15:53:04','',''),(2385460,'1','141','764',322,'Retail Sale Id 1416719',31200.00,0.00,0.00,60.00,780.00,'2021-12-27 15:53:51','',''),(2385490,'1','141','764',322,'Retail Sale Id 1416749',78000.00,0.00,0.00,150.00,1950.00,'2021-12-27 15:57:40','',''),(2385499,'1','141','764',322,'Retail Sale Id 1416758',3000.00,0.00,0.00,5.00,465.00,'2021-12-27 15:58:37','',''),(2385535,'1','141','764',322,'Retail Sale Id 1416799',30000.00,0.00,0.00,50.00,4650.00,'2021-12-27 16:03:58','',''),(2385546,'1','141','764',322,'Retail Sale Id 1416804',27000.00,0.00,0.00,45.00,4185.00,'2021-12-27 16:04:37','',''),(2385551,'1','141','764',322,'Retail Sale Id 1416807',364000.00,0.00,0.00,700.00,9100.00,'2021-12-27 16:05:25','',''),(2385557,'1','141','764',322,'Retail Sale Id 1416814',156000.00,0.00,0.00,300.00,3900.00,'2021-12-27 16:06:11','',''),(2385560,'1','141','764',322,'Retail Sale Id 1416817',208000.00,0.00,0.00,400.00,5200.00,'2021-12-27 16:07:04','',''),(2385567,'1','141','764',322,'Retail Sale Id 1416825',312000.00,0.00,0.00,600.00,7800.00,'2021-12-27 16:08:01','',''),(2385571,'1','141','764',322,'Retail Sale Id 1416828',156000.00,0.00,0.00,300.00,3900.00,'2021-12-27 16:08:52','',''),(2385573,'1','141','764',322,'Retail Sale Id 1416831',260000.00,0.00,0.00,500.00,6500.00,'2021-12-27 16:09:42','',''),(2385577,'1','141','764',322,'Retail Sale Id 1416836',104000.00,0.00,0.00,200.00,2600.00,'2021-12-27 16:10:29','',''),(2385606,'1','141','764',322,'Return of Retail Sale Id 1416804',0.00,27000.00,45.00,0.00,-4185.00,'2021-12-27 16:15:04','',''),(2385614,'1','141','764',322,'Return of Retail Sale Id 1416799',0.00,30000.00,50.00,0.00,-4650.00,'2021-12-27 16:16:34','',''),(2385623,'1','141','764',322,'Return of Retail Sale Id 1416683',0.00,13800.00,23.00,0.00,-2139.00,'2021-12-27 16:17:43','',''),(2385645,'1','141','764',322,'Return of Retail Sale Id 1416465',0.00,33000.00,55.00,0.00,-5115.00,'2021-12-27 16:21:30','',''),(2385653,'1','141','764',322,'Return of Retail Sale Id 1416603',0.00,15000.00,25.00,0.00,-2325.00,'2021-12-27 16:22:29','',''),(2385658,'1','141','764',322,'Return of Retail Sale Id 1416825',0.00,312000.00,600.00,0.00,-7800.00,'2021-12-27 16:23:20','',''),(2385664,'1','141','764',322,'Return of Retail Sale Id 1416719',0.00,31200.00,60.00,0.00,-780.00,'2021-12-27 16:24:01','',''),(2385677,'1','141','764',322,'Retail Sale Id 1416919',3380000.00,0.00,0.00,6500.00,84500.00,'2021-12-27 16:26:25','',''),(2385727,'1','141','764',322,'Retail Sale Id 1416958',74700.00,0.00,0.00,124.50,11578.50,'2021-12-27 16:33:32','',''),(2387112,'1','141','764',322,'Retail Sale Id 1417610',4200.00,0.00,0.00,7.00,651.00,'2021-12-28 07:46:10','',''),(2387116,'1','141','764',322,'Retail Sale Id 1417754',2460.00,0.00,0.00,4.10,381.30,'2021-12-28 07:46:57','',''),(2387148,'1','141','764',322,'Retail Sale Id 1417788',1800.00,0.00,0.00,3.00,279.00,'2021-12-28 07:50:20','',''),(2387158,'1','141','764',322,'Retail Sale Id 1417797',15000.00,0.00,0.00,25.00,2325.00,'2021-12-28 07:50:55','',''),(2387183,'1','141','764',322,'Retail Sale Id 1417809',1500.00,0.00,0.00,2.50,232.50,'2021-12-28 07:52:01','',''),(2387189,'1','141','764',322,'Retail Sale Id 1417817',1200.00,0.00,0.00,2.00,186.00,'2021-12-28 07:52:38','',''),(2387519,'1','141','764',322,'Retail Sale Id 1418058',104000.00,0.00,0.00,200.00,2600.00,'2021-12-28 08:17:08','',''),(2387677,'1','141','764',322,'Retail Sale Id 1418172',86840.00,0.00,0.00,167.00,2171.00,'2021-12-28 08:28:41','',''),(2387696,'1','141','764',322,'Retail Sale Id 1418191',131040.00,0.00,0.00,252.00,3276.00,'2021-12-28 08:31:06','',''),(2387812,'1','141','764',322,'Retail Sale Id 1418264',7380.00,0.00,0.00,12.30,1143.90,'2021-12-28 08:38:52','',''),(2387870,'1','141','764',322,'Retail Sale Id 1418302',8400.00,0.00,0.00,14.00,1302.00,'2021-12-28 08:43:22','',''),(2387876,'1','141','764',322,'Retail Sale Id 1418308',5160.00,0.00,0.00,8.60,799.80,'2021-12-28 08:44:15','',''),(2387881,'1','141','764',322,'Retail Sale Id 1418312',10080.00,0.00,0.00,16.80,1562.40,'2021-12-28 08:45:04','',''),(2387896,'1','141','764',322,'Retail Sale Id 1418328',11100.00,0.00,0.00,18.50,1720.50,'2021-12-28 08:47:16','',''),(2387933,'1','141','764',322,'Retail Sale Id 1418364',6480.00,0.00,0.00,10.80,1004.40,'2021-12-28 08:51:19','',''),(2387946,'1','141','764',322,'Retail Sale Id 1418379',3000.00,0.00,0.00,5.00,465.00,'2021-12-28 08:52:45','',''),(2387959,'1','141','764',322,'Retail Sale Id 1418391',9300.00,0.00,0.00,15.50,1441.50,'2021-12-28 08:53:39','',''),(2387987,'1','141','764',322,'Retail Sale Id 1418421',244920.00,0.00,0.00,471.00,6123.00,'2021-12-28 08:57:16','',''),(2388064,'1','141','764',322,'Retail Sale Id 1418500',127400.00,0.00,0.00,245.00,3185.00,'2021-12-28 09:08:23','',''),(2388073,'1','141','764',322,'Retail Sale Id 1418507',135200.00,0.00,0.00,260.00,3380.00,'2021-12-28 09:09:23','',''),(2388085,'1','141','764',322,'Retail Sale Id 1418518',143000.00,0.00,0.00,275.00,3575.00,'2021-12-28 09:11:29','',''),(2388097,'1','141','764',322,'Retail Sale Id 1418530',3300.00,0.00,0.00,5.50,511.50,'2021-12-28 09:12:36','',''),(2388979,'1','141','764',322,'Retail Sale Id 1419357',7260.00,0.00,0.00,12.10,1125.30,'2021-12-28 10:45:59','',''),(2388990,'1','141','764',322,'Retail Sale Id 1419367',9480.00,0.00,0.00,15.80,1469.40,'2021-12-28 10:47:13','',''),(2389102,'1','141','764',322,'Retail Sale Id 1419477',174460.00,0.00,0.00,335.50,4361.50,'2021-12-28 10:59:06','',''),(2389153,'1','141','764',322,'Retail Sale Id 1419515',143000.00,0.00,0.00,275.00,3575.00,'2021-12-28 11:04:26','',''),(2389172,'1','141','764',322,'Retail Sale Id 1419529',193700.00,0.00,0.00,372.50,4842.50,'2021-12-28 11:05:48','',''),(2389263,'1','141','764',322,'Retail Sale Id 1419615',136500.00,0.00,0.00,262.50,3412.50,'2021-12-28 11:16:16','',''),(2389772,'1','141','764',322,'Retail Sale Id 1420035',10500.00,0.00,0.00,17.50,1627.50,'2021-12-28 12:07:01','',''),(2389822,'1','141','764',322,'Retail Sale Id 1420076',31800.00,0.00,0.00,53.00,4929.00,'2021-12-28 12:09:29','',''),(2389854,'1','141','764',322,'Retail Sale Id 1420104',246376.00,0.00,0.00,473.80,6159.40,'2021-12-28 12:14:03','',''),(2389859,'1','141','764',322,'Retail Sale Id 1420108',3000.00,0.00,0.00,5.00,465.00,'2021-12-28 12:14:54','',''),(2389909,'1','141','764',322,'Retail Sale Id 1420153',9480.00,0.00,0.00,15.80,1469.40,'2021-12-28 12:20:26','',''),(2389933,'1','141','764',322,'Retail Sale Id 1420176',1368640.00,0.00,0.00,2632.00,34216.00,'2021-12-28 12:22:32','',''),(2390033,'1','141','764',322,'Retail Sale Id 1420246',28600.00,0.00,0.00,55.00,715.00,'2021-12-28 12:29:43','',''),(2390246,'1','141','764',322,'Retail Sale Id 1420405',69000.00,0.00,0.00,115.00,10695.00,'2021-12-28 12:50:27','',''),(2390255,'1','141','764',322,'Retail Sale Id 1420416',66560.00,0.00,0.00,128.00,1664.00,'2021-12-28 12:51:30','',''),(2390263,'1','141','764',322,'Retail Sale Id 1420424',58240.00,0.00,0.00,112.00,1456.00,'2021-12-28 12:52:23','',''),(2390279,'1','141','764',322,'Retail Sale Id 1420430',1800.00,0.00,0.00,3.00,279.00,'2021-12-28 12:53:09','',''),(2390284,'1','141','764',322,'Retail Sale Id 1420437',1998.00,0.00,0.00,3.33,309.69,'2021-12-28 12:53:43','',''),(2390299,'1','141','764',322,'Retail Sale Id 1420453',3600.00,0.00,0.00,6.00,558.00,'2021-12-28 12:55:25','',''),(2390303,'1','141','764',322,'Retail Sale Id 1420457',1200.00,0.00,0.00,2.00,186.00,'2021-12-28 12:55:50','',''),(2390310,'1','141','764',322,'Retail Sale Id 1420464',2400.00,0.00,0.00,4.00,372.00,'2021-12-28 12:56:20','',''),(2390324,'1','141','764',322,'Retail Sale Id 1420470',600.00,0.00,0.00,1.00,93.00,'2021-12-28 12:56:54','',''),(2390377,'1','141','764',322,'Retail Sale Id 1420516',143000.00,0.00,0.00,275.00,3575.00,'2021-12-28 13:02:29','',''),(2390404,'1','141','764',322,'Retail Sale Id 1420529',31200.00,0.00,0.00,60.00,780.00,'2021-12-28 13:03:45','',''),(2390737,'1','141','764',322,'Retail Sale Id 1420739',600.00,0.00,0.00,1.00,93.00,'2021-12-28 13:34:01','',''),(2391408,'1','141','764',322,'Retail Sale Id 1421258',4800.00,0.00,0.00,8.00,744.00,'2021-12-28 14:47:30','',''),(2391424,'1','141','764',322,'Retail Sale Id 1421273',52000.00,0.00,0.00,100.00,1300.00,'2021-12-28 14:50:00','',''),(2391464,'1','141','764',322,'Retail Sale Id 1421301',26000.00,0.00,0.00,50.00,650.00,'2021-12-28 14:56:12','',''),(2391503,'1','141','764',322,'Retail Sale Id 1421349',228228.00,0.00,0.00,438.90,5705.70,'2021-12-28 15:02:07','',''),(2391563,'1','141','764',322,'Return of Retail Sale Id 1421349',0.00,228228.00,438.90,0.00,-5705.70,'2021-12-28 15:06:56','',''),(2392051,'1','141','764',322,'Retail Sale Id 1421798',143000.00,0.00,0.00,275.00,3575.00,'2021-12-28 16:00:13','',''),(2392060,'1','141','764',322,'Retail Sale Id 1421802',78000.00,0.00,0.00,150.00,1950.00,'2021-12-28 16:00:51','',''),(2392388,'1','141','764',322,'Return of Retail Sale Id 1421273',0.00,52000.00,100.00,0.00,-1300.00,'2021-12-28 16:29:08','',''),(2392407,'1','141','764',322,'Retail Sale Id 1422009',7212.40,0.00,0.00,13.87,180.31,'2021-12-28 16:30:57','',''),(2392416,'1','141','764',322,'Retail Sale Id 1422017',24960.00,0.00,0.00,48.00,624.00,'2021-12-28 16:32:44','',''),(2392432,'1','141','764',322,'Return of Retail Sale Id 1422017',0.00,24960.00,48.00,0.00,-624.00,'2021-12-28 16:34:28','',''),(2392447,'1','141','764',322,'Retail Sale Id 1422039',24960.00,0.00,0.00,48.00,624.00,'2021-12-28 16:36:01','',''),(2393655,'1','141','764',322,'Distributed to OPERATIONAL LOSS for sales id:342768',168171.90,0.00,0.00,331.70,0.00,'2021-12-29 07:05:06','',''),(2393729,'1','141','764',322,'Distributed to OPERATIONAL LOSS for sales id:342770',41574.00,0.00,0.00,82.00,0.00,'2021-12-29 07:13:05','',''),(2393842,'1','141',NULL,322,'Purchased from AA RANO NIGERIA LIMITED',0.00,12629370.00,24910.00,0.00,0.00,'2021-12-29 07:23:10','',''),(2393875,'1','141',NULL,322,'Reception corrector for bridging 129055',0.00,0.00,0.00,24910.00,0.00,'2021-12-29 07:25:04','',''),(2393876,'1','141','764',322,'Received from bridging 129055',0.00,0.00,24910.00,0.00,0.00,'2021-12-29 07:25:04','',''),(2393982,'1','141','764',322,'Retail Sale Id 1422918',3000.00,0.00,0.00,5.00,465.00,'2021-12-29 07:38:15','',''),(2393989,'1','141','764',322,'Retail Sale Id 1422926',3000.00,0.00,0.00,5.00,465.00,'2021-12-29 07:38:57','',''),(2394006,'1','141','764',322,'Retail Sale Id 1422934',3060.00,0.00,0.00,5.10,474.30,'2021-12-29 07:40:09','',''),(2394011,'1','141','764',322,'Retail Sale Id 1422951',3000.00,0.00,0.00,5.00,465.00,'2021-12-29 07:41:04','',''),(2394271,'1','141','764',322,'Retail Sale Id 1423106',8460.00,0.00,0.00,14.10,1311.30,'2021-12-29 08:03:14','',''),(2394310,'1','141','764',322,'Retail Sale Id 1423152',7860.00,0.00,0.00,13.10,1218.30,'2021-12-29 08:07:30','',''),(2394497,'1','141','764',322,'Retail Sale Id 1423265',4800.00,0.00,0.00,8.00,744.00,'2021-12-29 08:28:00','',''),(2394514,'1','141','764',322,'Retail Sale Id 1423319',7500.00,0.00,0.00,12.50,1162.50,'2021-12-29 08:29:59','',''),(2394530,'1','141','764',322,'Retail Sale Id 1423334',13260.00,0.00,0.00,22.10,2055.30,'2021-12-29 08:31:38','',''),(2394545,'1','141','764',322,'Retail Sale Id 1423351',123760.00,0.00,0.00,238.00,3094.00,'2021-12-29 08:33:30','',''),(2394555,'1','141','764',322,'Retail Sale Id 1423362',217360.00,0.00,0.00,418.00,5434.00,'2021-12-29 08:34:40','',''),(2394568,'1','141','764',322,'Retail Sale Id 1423376',85020.00,0.00,0.00,163.50,2125.50,'2021-12-29 08:35:58','',''),(2394597,'1','141','764',322,'Retail Sale Id 1423406',621140.00,0.00,0.00,1194.50,15528.50,'2021-12-29 08:38:42','',''),(2394615,'1','141','764',322,'Retail Sale Id 1423426',87880.00,0.00,0.00,169.00,2197.00,'2021-12-29 08:40:22','',''),(2395861,'1','141','764',322,'Retail Sale Id 1424456',15600.00,0.00,0.00,26.00,2418.00,'2021-12-29 10:49:53','',''),(2395877,'1','141','764',322,'Retail Sale Id 1424467',24840.00,0.00,0.00,41.40,3850.20,'2021-12-29 10:51:17','',''),(2395897,'1','141','764',322,'Retail Sale Id 1424482',218400.00,0.00,0.00,420.00,5460.00,'2021-12-29 10:53:36','',''),(2395952,'1','141','764',322,'Retail Sale Id 1424500',248820.00,0.00,0.00,478.50,6220.50,'2021-12-29 10:58:13','',''),(2396013,'1','141','764',322,'Retail Sale Id 1424553',557180.00,0.00,0.00,1071.50,13929.50,'2021-12-29 11:03:56','',''),(2396080,'1','141','764',322,'Retail Sale Id 1424596',515840.00,0.00,0.00,992.00,12896.00,'2021-12-29 11:11:27','',''),(2396498,'1','141','764',322,'Retail Sale Id 1425003',147680.00,0.00,0.00,284.00,3692.00,'2021-12-29 11:58:40','',''),(2396525,'1','141','764',322,'Retail Sale Id 1425040',18720.00,0.00,0.00,31.20,2901.60,'2021-12-29 12:02:00','',''),(2396535,'1','141','764',322,'Retail Sale Id 1425050',21300.00,0.00,0.00,35.50,3301.50,'2021-12-29 12:03:26','',''),(2396541,'1','141','764',322,'Retail Sale Id 1425058',13200.00,0.00,0.00,22.00,2046.00,'2021-12-29 12:04:49','',''),(2396557,'1','141','764',322,'Retail Sale Id 1425073',16620.00,0.00,0.00,27.70,2576.10,'2021-12-29 12:07:09','',''),(2396648,'1','141','764',322,'Retail Sale Id 1425154',2160.00,0.00,0.00,3.60,334.80,'2021-12-29 12:22:58','',''),(2396655,'1','141','764',322,'Retail Sale Id 1425161',1800.00,0.00,0.00,3.00,279.00,'2021-12-29 12:23:54','',''),(2396999,'1','141','764',322,'Retail Sale Id 1425429',32400.00,0.00,0.00,54.00,5022.00,'2021-12-29 13:03:29','',''),(2397164,'1','141','764',322,'Retail Sale Id 1425555',20100.00,0.00,0.00,33.50,3115.50,'2021-12-29 13:23:53','',''),(2397863,'1','141','764',322,'Retail Sale Id 1426093',67600.00,0.00,0.00,130.00,1690.00,'2021-12-29 14:37:36','',''),(2397969,'1','141','764',322,'Retail Sale Id 1426167',96200.00,0.00,0.00,185.00,2405.00,'2021-12-29 14:45:48','',''),(2397988,'1','141','764',322,'Retail Sale Id 1426185',64480.00,0.00,0.00,124.00,1612.00,'2021-12-29 14:47:11','',''),(2398011,'1','141','764',322,'Retail Sale Id 1426193',78000.00,0.00,0.00,150.00,1950.00,'2021-12-29 14:50:02','',''),(2398205,'1','141','764',322,'Retail Sale Id 1426339',114400.00,0.00,0.00,220.00,2860.00,'2021-12-29 15:09:19','',''),(2398256,'1','141','764',322,'Retail Sale Id 1426348',7200.00,0.00,0.00,12.00,1116.00,'2021-12-29 15:11:21','',''),(2398298,'1','141','764',322,'Retail Sale Id 1426359',56160.00,0.00,0.00,108.00,1404.00,'2021-12-29 15:13:04','',''),(2398392,'1','141','764',322,'Retail Sale Id 1426437',36400.00,0.00,0.00,70.00,910.00,'2021-12-29 15:22:58','',''),(2398463,'1','141','764',322,'Retail Sale Id 1426449',87204.00,0.00,0.00,167.70,2180.10,'2021-12-29 15:27:54','',''),(2399014,'1','141','764',322,'Retail Sale Id 1426859',210340.00,0.00,0.00,404.50,5258.50,'2021-12-29 16:16:39','',''),(2399135,'1','141','764',322,'Retail Sale Id 1426979',133920.00,0.00,0.00,223.20,20757.60,'2021-12-29 16:30:19','',''),(2399269,'1','141','764',322,'Retail Sale Id 1427072',6240.00,0.00,0.00,12.00,156.00,'2021-12-29 16:44:32','',''),(2402060,'1','141','764',322,'Retail Sale Id 1428908',6960.00,0.00,0.00,11.60,1078.80,'2021-12-30 09:32:53','',''),(2402157,'1','141','764',322,'Retail Sale Id 1428988',24300.00,0.00,0.00,40.50,3766.50,'2021-12-30 09:41:25','',''),(2402255,'1','141','764',322,'Retail Sale Id 1429067',19500.00,0.00,0.00,32.50,3022.50,'2021-12-30 09:50:26','',''),(2402303,'1','141','764',322,'Retail Sale Id 1429111',36660.00,0.00,0.00,61.10,5682.30,'2021-12-30 09:55:11','',''),(2402314,'1','141','764',322,'Retail Sale Id 1429128',17280.00,0.00,0.00,28.80,2678.40,'2021-12-30 09:56:27','',''),(2402327,'1','141','764',322,'Retail Sale Id 1429138',301600.00,0.00,0.00,580.00,7540.00,'2021-12-30 09:57:32','',''),(2402354,'1','141','764',322,'Retail Sale Id 1429165',301340.00,0.00,0.00,579.50,7533.50,'2021-12-30 09:59:25','',''),(2402662,'1','141','764',322,'Retail Sale Id 1429458',167700.00,0.00,0.00,322.50,4192.50,'2021-12-30 10:31:41','',''),(2402703,'1','141','764',322,'Retail Sale Id 1429481',125060.00,0.00,0.00,240.50,3126.50,'2021-12-30 10:34:24','',''),(2402715,'1','141','764',322,'Retail Sale Id 1429517',2235480.00,0.00,0.00,4299.00,55887.00,'2021-12-30 10:35:48','',''),(2402763,'1','141','764',322,'Retail Sale Id 1429532',321360.00,0.00,0.00,618.00,8034.00,'2021-12-30 10:38:02','',''),(2402789,'1','141','764',322,'Retail Sale Id 1429559',9000.00,0.00,0.00,15.00,1395.00,'2021-12-30 10:41:31','',''),(2402833,'1','141','764',322,'Retail Sale Id 1429601',15720.00,0.00,0.00,26.20,2436.60,'2021-12-30 10:47:28','',''),(2402902,'1','141','764',322,'Retail Sale Id 1429646',7200.00,0.00,0.00,12.00,1116.00,'2021-12-30 10:51:43','',''),(2403012,'1','141','764',322,'Retail Sale Id 1429738',6600.00,0.00,0.00,11.00,1023.00,'2021-12-30 11:03:03','',''),(2403245,'1','141','764',322,'Retail Sale Id 1429964',364000.00,0.00,0.00,700.00,9100.00,'2021-12-30 11:33:01','',''),(2403705,'1','141','764',322,'Retail Sale Id 1430409',9540.00,0.00,0.00,15.90,1478.70,'2021-12-30 12:35:01','',''),(2405503,'1','141','764',322,'Retail Sale Id 1431860',122760.00,0.00,0.00,204.60,19027.80,'2021-12-30 15:41:13','',''),(2405559,'1','141','764',322,'Retail Sale Id 1431894',1111760.00,0.00,0.00,2138.00,27794.00,'2021-12-30 15:44:58','',''),(2405575,'1','141','764',322,'Retail Sale Id 1431909',624000.00,0.00,0.00,1200.00,15600.00,'2021-12-30 15:46:45','',''),(2405623,'1','141','764',322,'Retail Sale Id 1431934',742248.00,0.00,0.00,1427.40,18556.20,'2021-12-30 15:50:19','',''),(2405647,'1','141','764',322,'Retail Sale Id 1431968',48660.00,0.00,0.00,81.10,7542.30,'2021-12-30 15:53:15','',''),(2405740,'1','141','764',322,'Retail Sale Id 1432060',23400.00,0.00,0.00,45.00,585.00,'2021-12-30 16:02:00','',''),(2405952,'1','141','764',322,'Retail Sale Id 1432247',24420.00,0.00,0.00,40.70,3785.10,'2021-12-30 16:20:25','',''),(2405959,'1','141','764',322,'Retail Sale Id 1432271',116480.00,0.00,0.00,224.00,2912.00,'2021-12-30 16:21:26','',''),(2406153,'1','141','764',322,'Return of Retail Sale Id 1429128',0.00,17280.00,28.80,0.00,-2678.40,'2021-12-30 16:38:37','',''),(2406169,'1','141','764',322,'Retail Sale Id 1432461',5280.00,0.00,0.00,8.80,818.40,'2021-12-30 16:39:47','',''),(2406266,'1','141','764',322,'Retail Sale Id 1432558',21600.00,0.00,0.00,36.00,3348.00,'2021-12-30 16:52:38','',''),(2408476,'1','141','764',322,'Retail Sale Id 1433869',12000.00,0.00,0.00,20.00,1860.00,'2021-12-31 08:14:06','',''),(2408491,'1','141','764',322,'Retail Sale Id 1433881',12300.00,0.00,0.00,20.50,1906.50,'2021-12-31 08:15:24','',''),(2408503,'1','141','764',322,'Retail Sale Id 1433894',19500.00,0.00,0.00,32.50,3022.50,'2021-12-31 08:16:10','',''),(2408518,'1','141','764',322,'Retail Sale Id 1433906',13800.00,0.00,0.00,23.00,2139.00,'2021-12-31 08:17:18','',''),(2408556,'1','141','764',322,'Retail Sale Id 1433942',221000.00,0.00,0.00,425.00,5525.00,'2021-12-31 08:20:45','',''),(2408589,'1','141','764',322,'Retail Sale Id 1433957',138060.00,0.00,0.00,265.50,3451.50,'2021-12-31 08:22:20','',''),(2408900,'1','141','764',322,'Retail Sale Id 1434240',138060.00,0.00,0.00,265.50,3451.50,'2021-12-31 08:46:55','',''),(2409120,'1','141','764',322,'Retail Sale Id 1434441',9480.00,0.00,0.00,15.80,1469.40,'2021-12-31 09:05:45','',''),(2409744,'1','141','764',322,'Retail Sale Id 1435044',19200.00,0.00,0.00,32.00,2976.00,'2021-12-31 10:21:31','',''),(2409798,'1','141','764',322,'Retail Sale Id 1435080',20340.00,0.00,0.00,33.90,3152.70,'2021-12-31 10:25:50','',''),(2409826,'1','141','764',322,'Retail Sale Id 1435092',17760.00,0.00,0.00,29.60,2752.80,'2021-12-31 10:27:17','',''),(2409876,'1','141','764',322,'Retail Sale Id 1435108',21480.00,0.00,0.00,35.80,3329.40,'2021-12-31 10:29:13','',''),(2409929,'1','141','764',322,'Retail Sale Id 1435163',18900.00,0.00,0.00,31.50,2929.50,'2021-12-31 10:35:02','',''),(2410074,'1','141','764',322,'Retail Sale Id 1435270',316940.00,0.00,0.00,609.50,7923.50,'2021-12-31 10:46:51','',''),(2410098,'1','141','764',322,'Retail Sale Id 1435293',325000.00,0.00,0.00,625.00,8125.00,'2021-12-31 10:49:02','',''),(2413710,'1','141','764',322,'Retail Sale Id 1438492',31800.00,0.00,0.00,53.00,4929.00,'2021-12-31 16:57:58','',''),(2413719,'1','141','764',322,'Retail Sale Id 1438502',32580.00,0.00,0.00,54.30,5049.90,'2021-12-31 16:58:53','',''),(2413755,'1','141','764',322,'Retail Sale Id 1438623',758680.00,0.00,0.00,1459.00,18967.00,'2021-12-31 17:05:09','',''),(2415104,'1','141','764',322,'Distributed to OPERATIONAL LOSS for sales id:343557',154381.50,0.00,0.00,304.50,0.00,'2022-01-01 07:45:00','',''),(2415286,'1','141',NULL,322,'Purchased from AA RANO NIGERIA LIMITED',0.00,12664860.00,24980.00,0.00,0.00,'2022-01-01 07:56:17','',''),(2415320,'1','141',NULL,322,'Reception corrector for bridging 129396',0.00,0.00,0.00,24980.00,0.00,'2022-01-01 07:58:24','',''),(2415321,'1','141','764',322,'Received from bridging 129396',0.00,0.00,24980.00,0.00,0.00,'2022-01-01 07:58:24','',''),(2415381,'1','141','764',322,'Retail Sale Id 1439562',4998.00,0.00,0.00,8.33,774.69,'2022-01-01 08:05:05','',''),(2415406,'1','141','764',322,'Retail Sale Id 1439587',3600.00,0.00,0.00,6.00,558.00,'2022-01-01 08:07:05','',''),(2415428,'1','141','764',322,'Retail Sale Id 1439608',2400.00,0.00,0.00,4.00,372.00,'2022-01-01 08:09:08','',''),(2415442,'1','141','764',322,'Retail Sale Id 1439623',1980.00,0.00,0.00,3.30,306.90,'2022-01-01 08:10:18','',''),(2415470,'1','141','764',322,'Retail Sale Id 1439644',1980.00,0.00,0.00,3.30,306.90,'2022-01-01 08:12:05','',''),(2415478,'1','141','764',322,'Retail Sale Id 1439652',1800.00,0.00,0.00,3.00,279.00,'2022-01-01 08:12:38','',''),(2415489,'1','141','764',322,'Retail Sale Id 1439665',1200.00,0.00,0.00,2.00,186.00,'2022-01-01 08:13:43','',''),(2415496,'1','141','764',322,'Retail Sale Id 1439672',31200.00,0.00,0.00,60.00,780.00,'2022-01-01 08:14:23','',''),(2415522,'1','141','764',322,'Retail Sale Id 1439700',3000.00,0.00,0.00,5.00,465.00,'2022-01-01 08:17:16','',''),(2415528,'1','141','764',322,'Retail Sale Id 1439706',7500.00,0.00,0.00,12.50,1162.50,'2022-01-01 08:17:50','',''),(2415538,'1','141','764',322,'Retail Sale Id 1439718',6000.00,0.00,0.00,10.00,930.00,'2022-01-01 08:18:38','',''),(2415552,'1','141','764',322,'Retail Sale Id 1439732',7500.00,0.00,0.00,12.50,1162.50,'2022-01-01 08:20:21','',''),(2415572,'1','141','764',322,'Retail Sale Id 1439741',3960.00,0.00,0.00,6.60,613.80,'2022-01-01 08:21:29','',''),(2415579,'1','141','764',322,'Retail Sale Id 1439751',3000.00,0.00,0.00,5.00,465.00,'2022-01-01 08:22:09','',''),(2415585,'1','141','764',322,'Retail Sale Id 1439756',3000.00,0.00,0.00,5.00,465.00,'2022-01-01 08:22:47','',''),(2415593,'1','141','764',322,'Retail Sale Id 1439764',3600.00,0.00,0.00,6.00,558.00,'2022-01-01 08:23:22','',''),(2415602,'1','141','764',322,'Retail Sale Id 1439771',3000.00,0.00,0.00,5.00,465.00,'2022-01-01 08:24:46','',''),(2415609,'1','141','764',322,'Retail Sale Id 1439778',1200.00,0.00,0.00,2.00,186.00,'2022-01-01 08:25:36','',''),(2415617,'1','141','764',322,'Retail Sale Id 1439787',1980.00,0.00,0.00,3.30,306.90,'2022-01-01 08:26:19','',''),(2415635,'1','141','764',322,'Retail Sale Id 1439811',146900.00,0.00,0.00,282.50,3672.50,'2022-01-01 08:28:19','',''),(2415646,'1','141','764',322,'Retail Sale Id 1439823',2400.00,0.00,0.00,4.00,372.00,'2022-01-01 08:28:52','',''),(2415668,'1','141','764',322,'Retail Sale Id 1439847',110240.00,0.00,0.00,212.00,2756.00,'2022-01-01 08:31:24','',''),(2415682,'1','141','764',322,'Retail Sale Id 1439860',104260.00,0.00,0.00,200.50,2606.50,'2022-01-01 08:33:06','',''),(2415688,'1','141','764',322,'Retail Sale Id 1439866',3600.00,0.00,0.00,6.00,558.00,'2022-01-01 08:33:38','',''),(2415734,'1','141','764',322,'Retail Sale Id 1439892',64480.00,0.00,0.00,124.00,1612.00,'2022-01-01 08:35:32','',''),(2415789,'1','141','764',322,'Retail Sale Id 1439947',5202.00,0.00,0.00,8.67,806.31,'2022-01-01 08:40:35','',''),(2415801,'1','141','764',322,'Retail Sale Id 1439962',1800.00,0.00,0.00,3.00,279.00,'2022-01-01 08:41:41','',''),(2415837,'1','141','764',322,'Retail Sale Id 1439984',1800.00,0.00,0.00,3.00,279.00,'2022-01-01 08:43:43','',''),(2415878,'1','141','764',322,'Retail Sale Id 1440014',84760.00,0.00,0.00,163.00,2119.00,'2022-01-01 08:46:02','',''),(2415925,'1','141','764',322,'Retail Sale Id 1440060',95680.00,0.00,0.00,184.00,2392.00,'2022-01-01 08:51:02','',''),(2415940,'1','141','764',322,'Retail Sale Id 1440074',2502.00,0.00,0.00,4.17,387.81,'2022-01-01 08:52:43','',''),(2415969,'1','141','764',322,'Retail Sale Id 1440103',1998.00,0.00,0.00,3.33,309.69,'2022-01-01 08:56:08','',''),(2415989,'1','141','764',322,'Retail Sale Id 1440123',52000.00,0.00,0.00,100.00,1300.00,'2022-01-01 08:58:09','',''),(2416017,'1','141','764',322,'Retail Sale Id 1440142',54600.00,0.00,0.00,105.00,1365.00,'2022-01-01 09:01:12','',''),(2416099,'1','141','764',322,'Retail Sale Id 1440217',3000.00,0.00,0.00,5.00,465.00,'2022-01-01 09:10:11','',''),(2416109,'1','141','764',322,'Retail Sale Id 1440229',1800.00,0.00,0.00,3.00,279.00,'2022-01-01 09:11:17','',''),(2416145,'1','141','764',322,'Retail Sale Id 1440264',1800.00,0.00,0.00,3.00,279.00,'2022-01-01 09:15:57','',''),(2416157,'1','141','764',322,'Retail Sale Id 1440276',1398.00,0.00,0.00,2.33,216.69,'2022-01-01 09:17:05','',''),(2416172,'1','141','764',322,'Retail Sale Id 1440288',3600.00,0.00,0.00,6.00,558.00,'2022-01-01 09:18:48','',''),(2416233,'1','141','764',322,'Retail Sale Id 1440345',1800.00,0.00,0.00,3.00,279.00,'2022-01-01 09:24:28','',''),(2416281,'1','141','764',322,'Retail Sale Id 1440379',9000.00,0.00,0.00,15.00,1395.00,'2022-01-01 09:27:22','',''),(2416300,'1','141','764',322,'Retail Sale Id 1440397',3600.00,0.00,0.00,6.00,558.00,'2022-01-01 09:28:35','',''),(2416313,'1','141','764',322,'Retail Sale Id 1440406',2400.00,0.00,0.00,4.00,372.00,'2022-01-01 09:29:53','',''),(2416328,'1','141','764',322,'Retail Sale Id 1440424',2400.00,0.00,0.00,4.00,372.00,'2022-01-01 09:31:14','',''),(2416354,'1','141','764',322,'Retail Sale Id 1440451',1200.00,0.00,0.00,2.00,186.00,'2022-01-01 09:33:53','',''),(2416368,'1','141','764',322,'Retail Sale Id 1440465',104000.00,0.00,0.00,200.00,2600.00,'2022-01-01 09:35:05','',''),(2416414,'1','141','764',322,'Retail Sale Id 1440493',1698.00,0.00,0.00,2.83,263.19,'2022-01-01 09:38:52','',''),(2416420,'1','141','764',322,'Retail Sale Id 1440502',13000.00,0.00,0.00,25.00,325.00,'2022-01-01 09:40:02','',''),(2416433,'1','141','764',322,'Retail Sale Id 1440513',4998.00,0.00,0.00,8.33,774.69,'2022-01-01 09:42:14','',''),(2416442,'1','141','764',322,'Retail Sale Id 1440522',41600.00,0.00,0.00,80.00,1040.00,'2022-01-01 09:43:08','',''),(2416470,'1','141','764',322,'Retail Sale Id 1440546',26000.00,0.00,0.00,50.00,650.00,'2022-01-01 09:45:43','',''),(2416517,'1','141','764',322,'Retail Sale Id 1440588',1998.00,0.00,0.00,3.33,309.69,'2022-01-01 09:49:43','',''),(2416526,'1','141','764',322,'Retail Sale Id 1440598',31200.00,0.00,0.00,60.00,780.00,'2022-01-01 09:50:56','',''),(2416537,'1','141','764',322,'Retail Sale Id 1440610',3000.00,0.00,0.00,5.00,465.00,'2022-01-01 09:52:32','',''),(2416551,'1','141','764',322,'Retail Sale Id 1440619',6000.00,0.00,0.00,10.00,930.00,'2022-01-01 09:53:26','',''),(2416565,'1','141','764',322,'Retail Sale Id 1440632',143000.00,0.00,0.00,275.00,3575.00,'2022-01-01 09:54:43','',''),(2416571,'1','141','764',322,'Retail Sale Id 1440637',129480.00,0.00,0.00,249.00,3237.00,'2022-01-01 09:55:52','',''),(2416618,'1','141','764',322,'Retail Sale Id 1440671',2400.00,0.00,0.00,4.00,372.00,'2022-01-01 09:59:22','',''),(2416694,'1','141','764',322,'Retail Sale Id 1440729',104000.00,0.00,0.00,200.00,2600.00,'2022-01-01 10:07:46','',''),(2416728,'1','141','764',322,'Retail Sale Id 1440763',143000.00,0.00,0.00,275.00,3575.00,'2022-01-01 10:11:35','',''),(2416770,'1','141','764',322,'Retail Sale Id 1440806',29640.00,0.00,0.00,57.00,741.00,'2022-01-01 10:16:18','',''),(2416829,'1','141','764',322,'Retail Sale Id 1440862',82420.00,0.00,0.00,158.50,2060.50,'2022-01-01 10:21:31','',''),(2416867,'1','141','764',322,'Retail Sale Id 1440896',7500.00,0.00,0.00,12.50,1162.50,'2022-01-01 10:25:26','',''),(2416885,'1','141','764',322,'Retail Sale Id 1440915',86840.00,0.00,0.00,167.00,2171.00,'2022-01-01 10:27:41','',''),(2416918,'1','141','764',322,'Retail Sale Id 1440948',1002.00,0.00,0.00,1.67,155.31,'2022-01-01 10:31:29','',''),(2416963,'1','141','764',322,'Retail Sale Id 1440976',6000.00,0.00,0.00,10.00,930.00,'2022-01-01 10:36:03','',''),(2417021,'1','141','764',322,'Retail Sale Id 1441034',2400.00,0.00,0.00,4.00,372.00,'2022-01-01 10:42:59','',''),(2417032,'1','141','764',322,'Retail Sale Id 1441045',1200.00,0.00,0.00,2.00,186.00,'2022-01-01 10:44:12','',''),(2417060,'1','141','764',322,'Retail Sale Id 1441067',6000.00,0.00,0.00,10.00,930.00,'2022-01-01 10:46:38','',''),(2417186,'1','141','764',322,'Retail Sale Id 1441176',1500.00,0.00,0.00,2.50,232.50,'2022-01-01 10:59:53','',''),(2417218,'1','141','764',322,'Retail Sale Id 1441207',600.00,0.00,0.00,1.00,93.00,'2022-01-01 11:03:35','',''),(2417280,'1','141','764',322,'Retail Sale Id 1441254',1200.00,0.00,0.00,2.00,186.00,'2022-01-01 11:09:47','',''),(2417295,'1','141','764',322,'Retail Sale Id 1441271',5400.00,0.00,0.00,9.00,837.00,'2022-01-01 11:11:48','',''),(2417315,'1','141','764',322,'Retail Sale Id 1441290',3600.00,0.00,0.00,6.00,558.00,'2022-01-01 11:13:13','',''),(2417332,'1','141','764',322,'Retail Sale Id 1441310',3000.00,0.00,0.00,5.00,465.00,'2022-01-01 11:14:56','',''),(2417344,'1','141','764',322,'Retail Sale Id 1441321',7500.00,0.00,0.00,12.50,1162.50,'2022-01-01 11:16:05','',''),(2417353,'1','141','764',322,'Retail Sale Id 1441331',960.00,0.00,0.00,1.60,148.80,'2022-01-01 11:17:05','',''),(2417357,'1','141','764',322,'Retail Sale Id 1441336',3000.00,0.00,0.00,5.00,465.00,'2022-01-01 11:17:58','',''),(2417416,'1','141','764',322,'Retail Sale Id 1441392',7500.00,0.00,0.00,12.50,1162.50,'2022-01-01 11:26:06','',''),(2417532,'1','141','764',322,'Retail Sale Id 1441504',1200.00,0.00,0.00,2.00,186.00,'2022-01-01 11:37:18','',''),(2417661,'1','141','764',322,'Retail Sale Id 1441626',59800.00,0.00,0.00,115.00,1495.00,'2022-01-01 11:51:48','',''),(2417694,'1','141','764',322,'Retail Sale Id 1441662',1002.00,0.00,0.00,1.67,155.31,'2022-01-01 11:55:21','',''),(2417742,'1','141','764',322,'Retail Sale Id 1441714',63700.00,0.00,0.00,122.50,1592.50,'2022-01-01 12:01:36','',''),(2417910,'1','141','764',322,'Retail Sale Id 1441880',3000.00,0.00,0.00,5.00,465.00,'2022-01-01 12:22:06','',''),(2418005,'1','141','764',322,'Retail Sale Id 1441974',1998.00,0.00,0.00,3.33,309.69,'2022-01-01 12:31:19','',''),(2418057,'1','141','764',322,'Retail Sale Id 1442025',3000.00,0.00,0.00,5.00,465.00,'2022-01-01 12:37:06','',''),(2418069,'1','141','764',322,'Retail Sale Id 1442037',62400.00,0.00,0.00,120.00,1560.00,'2022-01-01 12:38:26','',''),(2418168,'1','141','764',322,'Retail Sale Id 1442117',54080.00,0.00,0.00,104.00,1352.00,'2022-01-01 12:48:58','',''),(2418186,'1','141','764',322,'Retail Sale Id 1442138',1800.00,0.00,0.00,3.00,279.00,'2022-01-01 12:52:27','',''),(2418199,'1','141','764',322,'Retail Sale Id 1442148',1998.00,0.00,0.00,3.33,309.69,'2022-01-01 12:54:16','',''),(2418326,'1','141','764',322,'Retail Sale Id 1442244',3600.00,0.00,0.00,6.00,558.00,'2022-01-01 13:09:04','',''),(2418340,'1','141','764',322,'Retail Sale Id 1442255',57200.00,0.00,0.00,110.00,1430.00,'2022-01-01 13:10:54','',''),(2418387,'1','141','764',322,'Retail Sale Id 1442301',79040.00,0.00,0.00,152.00,1976.00,'2022-01-01 13:17:35','',''),(2418519,'1','141','764',322,'Retail Sale Id 1442418',28600.00,0.00,0.00,55.00,715.00,'2022-01-01 13:36:38','',''),(2418528,'1','141','764',322,'Retail Sale Id 1442427',1800.00,0.00,0.00,3.00,279.00,'2022-01-01 13:38:00','',''),(2418545,'1','141','764',322,'Retail Sale Id 1442440',2400.00,0.00,0.00,4.00,372.00,'2022-01-01 13:39:17','',''),(2418555,'1','141','764',322,'Retail Sale Id 1442449',1800.00,0.00,0.00,3.00,279.00,'2022-01-01 13:40:29','',''),(2418633,'1','141','764',322,'Retail Sale Id 1442497',4200.00,0.00,0.00,7.00,651.00,'2022-01-01 13:47:02','',''),(2418647,'1','141','764',322,'Retail Sale Id 1442512',5400.00,0.00,0.00,9.00,837.00,'2022-01-01 13:49:07','',''),(2418674,'1','141','764',322,'Retail Sale Id 1442530',1200.00,0.00,0.00,2.00,186.00,'2022-01-01 13:53:54','',''),(2418725,'1','141','764',322,'Retail Sale Id 1442581',1800.00,0.00,0.00,3.00,279.00,'2022-01-01 14:02:47','',''),(2418736,'1','141','764',322,'Retail Sale Id 1442592',52000.00,0.00,0.00,100.00,1300.00,'2022-01-01 14:04:18','',''),(2418820,'1','141','764',322,'Retail Sale Id 1442656',79040.00,0.00,0.00,152.00,1976.00,'2022-01-01 14:17:09','',''),(2418952,'1','141','764',322,'Retail Sale Id 1442755',3000.00,0.00,0.00,5.00,465.00,'2022-01-01 14:36:27','',''),(2419102,'1','141','764',322,'Retail Sale Id 1442821',27560.00,0.00,0.00,53.00,689.00,'2022-01-01 14:49:11','',''),(2419141,'1','141','764',322,'Retail Sale Id 1442859',3120.00,0.00,0.00,6.00,78.00,'2022-01-01 14:57:20','',''),(2419166,'1','141','764',322,'Retail Sale Id 1442885',1800.00,0.00,0.00,3.00,279.00,'2022-01-01 15:01:49','',''),(2419184,'1','141','764',322,'Retail Sale Id 1442904',11400.00,0.00,0.00,19.00,1767.00,'2022-01-01 15:04:52','',''),(2419217,'1','141','764',322,'Return of Retail Sale Id 1441392',0.00,7500.00,12.50,0.00,-1162.50,'2022-01-01 15:11:45','',''),(2419226,'1','141','764',322,'Return of Retail Sale Id 1440610',0.00,3000.00,5.00,0.00,-465.00,'2022-01-01 15:13:37','',''),(2419234,'1','141','764',322,'Return of Retail Sale Id 1442885',0.00,1800.00,3.00,0.00,-279.00,'2022-01-01 15:14:38','',''),(2420657,'1','141','764',322,'Retail Sale Id 1443785',1001104.00,0.00,0.00,1925.20,25027.60,'2022-01-02 05:58:24','',''),(2421934,'1','141','764',322,'Retail Sale Id 1444827',1800.00,0.00,0.00,3.00,279.00,'2022-01-02 09:14:50','',''),(2421939,'1','141','764',322,'Retail Sale Id 1444842',600.00,0.00,0.00,1.00,93.00,'2022-01-02 09:16:00','',''),(2422362,'1','141','764',322,'Retail Sale Id 1445207',960.00,0.00,0.00,1.60,148.80,'2022-01-02 10:05:02','',''),(2422396,'1','141','764',322,'Retail Sale Id 1445233',1800.00,0.00,0.00,3.00,279.00,'2022-01-02 10:07:44','',''),(2422406,'1','141','764',322,'Retail Sale Id 1445245',3000.00,0.00,0.00,5.00,465.00,'2022-01-02 10:09:04','',''),(2422512,'1','141','764',322,'Retail Sale Id 1445326',1200.00,0.00,0.00,2.00,186.00,'2022-01-02 10:20:20','',''),(2422530,'1','141','764',322,'Retail Sale Id 1445343',3600.00,0.00,0.00,6.00,558.00,'2022-01-02 10:21:48','',''),(2422589,'1','141','764',322,'Retail Sale Id 1445400',600.00,0.00,0.00,1.00,93.00,'2022-01-02 10:29:04','',''),(2422684,'1','141','764',322,'Retail Sale Id 1445460',123760.00,0.00,0.00,238.00,3094.00,'2022-01-02 10:36:41','',''),(2422802,'1','141','764',322,'Retail Sale Id 1445591',3000.00,0.00,0.00,5.00,465.00,'2022-01-02 10:49:36','',''),(2422815,'1','141','764',322,'Retail Sale Id 1445605',1002.00,0.00,0.00,1.67,155.31,'2022-01-02 10:51:27','',''),(2422838,'1','141','764',322,'Retail Sale Id 1445614',1800.00,0.00,0.00,3.00,279.00,'2022-01-02 10:52:27','',''),(2422859,'1','141','764',322,'Retail Sale Id 1445638',11502.00,0.00,0.00,19.17,1782.81,'2022-01-02 10:54:41','',''),(2422904,'1','141','764',322,'Retail Sale Id 1445681',1800.00,0.00,0.00,3.00,279.00,'2022-01-02 11:00:18','',''),(2422949,'1','141','764',322,'Retail Sale Id 1445732',6498.00,0.00,0.00,10.83,1007.19,'2022-01-02 11:05:09','',''),(2422958,'1','141','764',322,'Retail Sale Id 1445740',1200.00,0.00,0.00,2.00,186.00,'2022-01-02 11:06:28','',''),(2422974,'1','141','764',322,'Retail Sale Id 1445751',65000.00,0.00,0.00,125.00,1625.00,'2022-01-02 11:07:45','',''),(2423124,'1','141','764',322,'Retail Sale Id 1445891',600.00,0.00,0.00,1.00,93.00,'2022-01-02 11:22:30','',''),(2423132,'1','141','764',322,'Retail Sale Id 1445904',1200.00,0.00,0.00,2.00,186.00,'2022-01-02 11:23:43','',''),(2423246,'1','141','764',322,'Retail Sale Id 1446023',1500.00,0.00,0.00,2.50,232.50,'2022-01-02 11:35:41','',''),(2423317,'1','141','764',322,'Retail Sale Id 1446093',57200.00,0.00,0.00,110.00,1430.00,'2022-01-02 11:43:46','',''),(2423331,'1','141','764',322,'Retail Sale Id 1446109',1500.00,0.00,0.00,2.50,232.50,'2022-01-02 11:45:48','',''),(2423344,'1','141','764',322,'Retail Sale Id 1446123',3000.00,0.00,0.00,5.00,465.00,'2022-01-02 11:47:21','',''),(2423361,'1','141','764',322,'Retail Sale Id 1446139',1998.00,0.00,0.00,3.33,309.69,'2022-01-02 11:49:42','',''),(2423390,'1','141','764',322,'Retail Sale Id 1446168',83720.00,0.00,0.00,161.00,2093.00,'2022-01-02 11:54:53','',''),(2423404,'1','141','764',322,'Retail Sale Id 1446184',1002.00,0.00,0.00,1.67,155.31,'2022-01-02 11:57:12','',''),(2423471,'1','141','764',322,'Retail Sale Id 1446235',5400.00,0.00,0.00,9.00,837.00,'2022-01-02 12:05:41','',''),(2423586,'1','141','764',322,'Retail Sale Id 1446364',6500.00,0.00,0.00,12.50,162.50,'2022-01-02 12:21:22','',''),(2423656,'1','141','764',322,'Retail Sale Id 1446427',3000.00,0.00,0.00,5.00,465.00,'2022-01-02 12:30:04','',''),(2423809,'1','141','764',322,'Retail Sale Id 1446596',900.00,0.00,0.00,1.50,139.50,'2022-01-02 12:47:12','',''),(2423817,'1','141','764',322,'Retail Sale Id 1446605',53404.00,0.00,0.00,102.70,1335.10,'2022-01-02 12:48:40','',''),(2423850,'1','141','764',322,'Retail Sale Id 1446638',3000.00,0.00,0.00,5.00,465.00,'2022-01-02 12:52:45','',''),(2423917,'1','141','764',322,'Retail Sale Id 1446714',1800.00,0.00,0.00,3.00,279.00,'2022-01-02 13:00:15','',''),(2423928,'1','141','764',322,'Retail Sale Id 1446726',600.00,0.00,0.00,1.00,93.00,'2022-01-02 13:01:44','',''),(2423965,'1','141','764',322,'Retail Sale Id 1446757',27560.00,0.00,0.00,53.00,689.00,'2022-01-02 13:07:11','',''),(2423982,'1','141','764',322,'Retail Sale Id 1446772',26000.00,0.00,0.00,50.00,650.00,'2022-01-02 13:08:56','',''),(2424009,'1','141','764',322,'Retail Sale Id 1446797',3600.00,0.00,0.00,6.00,558.00,'2022-01-02 13:13:15','',''),(2424019,'1','141','764',322,'Retail Sale Id 1446804',1200.00,0.00,0.00,2.00,186.00,'2022-01-02 13:14:56','',''),(2424035,'1','141','764',322,'Retail Sale Id 1446823',76700.00,0.00,0.00,147.50,1917.50,'2022-01-02 13:16:46','',''),(2424047,'1','141','764',322,'Retail Sale Id 1446834',33800.00,0.00,0.00,65.00,845.00,'2022-01-02 13:18:43','',''),(2424068,'1','141','764',322,'Retail Sale Id 1446856',1800.00,0.00,0.00,3.00,279.00,'2022-01-02 13:22:17','',''),(2424081,'1','141','764',322,'Retail Sale Id 1446869',3600.00,0.00,0.00,6.00,558.00,'2022-01-02 13:23:58','',''),(2424093,'1','141','764',322,'Retail Sale Id 1446883',1800.00,0.00,0.00,3.00,279.00,'2022-01-02 13:25:22','',''),(2424105,'1','141','764',322,'Retail Sale Id 1446893',91988.00,0.00,0.00,176.90,2299.70,'2022-01-02 13:26:52','',''),(2424141,'1','141','764',322,'Retail Sale Id 1446932',960.00,0.00,0.00,1.60,148.80,'2022-01-02 13:31:23','',''),(2424152,'1','141','764',322,'Retail Sale Id 1446942',12000.00,0.00,0.00,20.00,1860.00,'2022-01-02 13:32:42','',''),(2424175,'1','141','764',322,'Retail Sale Id 1446972',1800.00,0.00,0.00,3.00,279.00,'2022-01-02 13:37:15','',''),(2424184,'1','141','764',322,'Retail Sale Id 1446980',20100.00,0.00,0.00,33.50,3115.50,'2022-01-02 13:38:38','',''),(2424222,'1','141','764',322,'Retail Sale Id 1447021',52000.00,0.00,0.00,100.00,1300.00,'2022-01-02 13:43:55','',''),(2424244,'1','141','764',322,'Retail Sale Id 1447037',3600.00,0.00,0.00,6.00,558.00,'2022-01-02 13:46:11','',''),(2424329,'1','141','764',322,'Retail Sale Id 1447092',3600.00,0.00,0.00,6.00,558.00,'2022-01-02 13:56:30','',''),(2427301,'1','141','764',322,'Retail Sale Id 1449327',52000.00,0.00,0.00,100.00,1300.00,'2022-01-03 08:36:40','',''),(2427379,'1','141','764',322,'Retail Sale Id 1449409',1200.00,0.00,0.00,2.00,186.00,'2022-01-03 08:45:23','',''),(2427486,'1','141','764',322,'Retail Sale Id 1449507',1200.00,0.00,0.00,2.00,186.00,'2022-01-03 08:55:27','',''),(2427581,'1','141','764',322,'Retail Sale Id 1449553',3600.00,0.00,0.00,6.00,558.00,'2022-01-03 09:01:35','',''),(2427674,'1','141','764',322,'Retail Sale Id 1449662',7500.00,0.00,0.00,12.50,1162.50,'2022-01-03 09:12:34','',''),(2427681,'1','141','764',322,'Retail Sale Id 1449671',2400.00,0.00,0.00,4.00,372.00,'2022-01-03 09:13:48','',''),(2427697,'1','141','764',322,'Retail Sale Id 1449678',1200.00,0.00,0.00,2.00,186.00,'2022-01-03 09:15:10','',''),(2427707,'1','141','764',322,'Retail Sale Id 1449692',1800.00,0.00,0.00,3.00,279.00,'2022-01-03 09:16:45','',''),(2427725,'1','141','764',322,'Retail Sale Id 1449708',3960.00,0.00,0.00,6.60,613.80,'2022-01-03 09:18:17','',''),(2427740,'1','141','764',322,'Retail Sale Id 1449722',6180.00,0.00,0.00,10.30,957.90,'2022-01-03 09:19:55','',''),(2427754,'1','141','764',322,'Retail Sale Id 1449735',11100.00,0.00,0.00,18.50,1720.50,'2022-01-03 09:21:18','',''),(2427805,'1','141','764',322,'Retail Sale Id 1449790',6180.00,0.00,0.00,10.30,957.90,'2022-01-03 09:28:12','',''),(2427856,'1','141','764',322,'Retail Sale Id 1449837',1200.00,0.00,0.00,2.00,186.00,'2022-01-03 09:34:09','',''),(2427874,'1','141','764',322,'Retail Sale Id 1449853',7002.00,0.00,0.00,11.67,1085.31,'2022-01-03 09:35:52','',''),(2427972,'1','141','764',322,'Retail Sale Id 1449963',1800.00,0.00,0.00,3.00,279.00,'2022-01-03 09:49:12','',''),(2428035,'1','141','764',322,'Retail Sale Id 1450018',600.00,0.00,0.00,1.00,93.00,'2022-01-03 09:55:12','',''),(2429584,'1','141','764',322,'Retail Sale Id 1451447',1800.00,0.00,0.00,3.00,279.00,'2022-01-03 13:06:34','',''),(2429605,'1','141','764',322,'Retail Sale Id 1451473',600.00,0.00,0.00,1.00,93.00,'2022-01-03 13:08:29','',''),(2430689,'1','141','764',322,'Retail Sale Id 1452303',126660.00,0.00,0.00,211.10,19632.30,'2022-01-03 14:40:49','',''),(2430701,'1','141','764',322,'Retail Sale Id 1452314',10800.00,0.00,0.00,18.00,1674.00,'2022-01-03 14:41:51','',''),(2430733,'1','141','764',322,'Retail Sale Id 1452326',9540.00,0.00,0.00,15.90,1478.70,'2022-01-03 14:43:06','',''),(2430754,'1','141','764',322,'Retail Sale Id 1452335',1800.00,0.00,0.00,3.00,279.00,'2022-01-03 14:43:40','',''),(2430786,'1','141','764',322,'Retail Sale Id 1452348',3600.00,0.00,0.00,6.00,558.00,'2022-01-03 14:44:50','',''),(2430825,'1','141','764',322,'Retail Sale Id 1452361',21780.00,0.00,0.00,36.30,3375.90,'2022-01-03 14:47:32','',''),(2430845,'1','141','764',322,'Retail Sale Id 1452386',26000.00,0.00,0.00,50.00,650.00,'2022-01-03 14:49:15','',''),(2430877,'1','141','764',322,'Retail Sale Id 1452413',3900.00,0.00,0.00,6.50,604.50,'2022-01-03 14:53:13','',''),(2430965,'1','141','764',322,'Retail Sale Id 1452492',1959880.00,0.00,0.00,3769.00,48997.00,'2022-01-03 15:03:03','',''),(2430974,'1','141','764',322,'Retail Sale Id 1452503',270400.00,0.00,0.00,520.00,6760.00,'2022-01-03 15:04:08','',''),(2430981,'1','141','764',322,'Retail Sale Id 1452511',143000.00,0.00,0.00,275.00,3575.00,'2022-01-03 15:05:04','',''),(2430995,'1','141','764',322,'Retail Sale Id 1452527',334100.00,0.00,0.00,642.50,8352.50,'2022-01-03 15:06:28','',''),(2430999,'1','141','764',322,'Retail Sale Id 1452530',57200.00,0.00,0.00,110.00,1430.00,'2022-01-03 15:07:08','',''),(2431107,'1','141','764',322,'Retail Sale Id 1452608',195780.00,0.00,0.00,376.50,4894.50,'2022-01-03 15:17:49','',''),(2431120,'1','141','764',322,'Retail Sale Id 1452614',6240.00,0.00,0.00,12.00,156.00,'2022-01-03 15:18:23','',''),(2431316,'1','141','764',322,'Retail Sale Id 1452743',243620.00,0.00,0.00,468.50,6090.50,'2022-01-03 15:34:15','',''),(2431337,'1','141','764',322,'Retail Sale Id 1452762',269100.00,0.00,0.00,517.50,6727.50,'2022-01-03 15:35:58','',''),(2431368,'1','141','764',322,'Retail Sale Id 1452795',104000.00,0.00,0.00,200.00,2600.00,'2022-01-03 15:39:27','',''),(2431557,'1','141','764',322,'Retail Sale Id 1452982',322140.00,0.00,0.00,619.50,8053.50,'2022-01-03 15:56:16','',''),(2431579,'1','141','764',322,'Retail Sale Id 1453004',135200.00,0.00,0.00,260.00,3380.00,'2022-01-03 15:58:15','',''),(2431609,'1','141','764',322,'Retail Sale Id 1453034',349440.00,0.00,0.00,672.00,8736.00,'2022-01-03 16:00:54','',''),(2431652,'1','141','764',322,'Retail Sale Id 1453074',37700.00,0.00,0.00,72.50,942.50,'2022-01-03 16:04:40','',''),(2432028,'1','141','764',322,'Retail Sale Id 1453345',3960.00,0.00,0.00,6.60,613.80,'2022-01-03 16:39:52','',''),(2432042,'1','141','764',322,'Retail Sale Id 1453443',52000.00,0.00,0.00,100.00,1300.00,'2022-01-03 16:41:22','',''),(2433482,'1','141','764',322,'Retail Sale Id 1454173',1002.00,0.00,0.00,1.67,155.31,'2022-01-04 07:31:50','',''),(2433500,'1','141','764',322,'Retail Sale Id 1454190',900.00,0.00,0.00,1.50,139.50,'2022-01-04 07:33:36','',''),(2433512,'1','141','764',322,'Retail Sale Id 1454204',46800.00,0.00,0.00,90.00,1170.00,'2022-01-04 07:35:05','',''),(2433587,'1','141','764',322,'Retail Sale Id 1454283',31200.00,0.00,0.00,60.00,780.00,'2022-01-04 07:44:48','',''),(2433594,'1','141','764',322,'Retail Sale Id 1454291',273520.00,0.00,0.00,526.00,6838.00,'2022-01-04 07:45:53','',''),(2433622,'1','141','764',322,'Retail Sale Id 1454315',600.00,0.00,0.00,1.00,93.00,'2022-01-04 07:49:09','',''),(2433645,'1','141','764',322,'Retail Sale Id 1454340',41600.00,0.00,0.00,80.00,1040.00,'2022-01-04 07:51:29','',''),(2433744,'1','141','764',322,'Retail Sale Id 1454435',3000.00,0.00,0.00,5.00,465.00,'2022-01-04 08:01:50','',''),(2433840,'1','141','764',322,'Retail Sale Id 1454501',136500.00,0.00,0.00,262.50,3412.50,'2022-01-04 08:10:42','',''),(2433916,'1','141','764',322,'Retail Sale Id 1454572',3000.00,0.00,0.00,5.00,465.00,'2022-01-04 08:18:17','',''),(2433956,'1','141','764',322,'Retail Sale Id 1454612',93600.00,0.00,0.00,180.00,2340.00,'2022-01-04 08:21:45','',''),(2434085,'1','141','764',322,'Retail Sale Id 1454702',1002.00,0.00,0.00,1.67,155.31,'2022-01-04 08:30:06','',''),(2434185,'1','141','764',322,'Retail Sale Id 1454768',600.00,0.00,0.00,1.00,93.00,'2022-01-04 08:38:30','',''),(2434291,'1','141','764',322,'Retail Sale Id 1454855',90480.00,0.00,0.00,174.00,2262.00,'2022-01-04 08:47:10','',''),(2434590,'1','141','764',322,'Retail Sale Id 1455161',2400.00,0.00,0.00,4.00,372.00,'2022-01-04 09:19:35','',''),(2434640,'1','141','764',322,'Retail Sale Id 1455210',26000.00,0.00,0.00,50.00,650.00,'2022-01-04 09:25:54','',''),(2434654,'1','141','764',322,'Retail Sale Id 1455223',1800.00,0.00,0.00,3.00,279.00,'2022-01-04 09:27:27','',''),(2434681,'1','141','764',322,'Retail Sale Id 1455252',1200.00,0.00,0.00,2.00,186.00,'2022-01-04 09:30:05','',''),(2434733,'1','141','764',322,'Retail Sale Id 1455289',1800.00,0.00,0.00,3.00,279.00,'2022-01-04 09:33:14','',''),(2434804,'1','141','764',322,'Retail Sale Id 1455310',20800.00,0.00,0.00,40.00,520.00,'2022-01-04 09:35:18','',''),(2434841,'1','141','764',322,'Retail Sale Id 1455347',84760.00,0.00,0.00,163.00,2119.00,'2022-01-04 09:39:49','',''),(2434920,'1','141','764',322,'Retail Sale Id 1455423',52000.00,0.00,0.00,100.00,1300.00,'2022-01-04 09:47:33','',''),(2434938,'1','141','764',322,'Retail Sale Id 1455435',52000.00,0.00,0.00,100.00,1300.00,'2022-01-04 09:49:39','',''),(2434965,'1','141','764',322,'Retail Sale Id 1455467',36400.00,0.00,0.00,70.00,910.00,'2022-01-04 09:52:41','',''),(2435031,'1','141','764',322,'Retail Sale Id 1455515',113620.00,0.00,0.00,218.50,2840.50,'2022-01-04 09:57:33','',''),(2435077,'1','141','764',322,'Retail Sale Id 1455560',9620.00,0.00,0.00,18.50,240.50,'2022-01-04 10:03:12','',''),(2435088,'1','141','764',322,'Retail Sale Id 1455569',1500.00,0.00,0.00,2.50,232.50,'2022-01-04 10:05:04','',''),(2435102,'1','141','764',322,'Retail Sale Id 1455584',52000.00,0.00,0.00,100.00,1300.00,'2022-01-04 10:07:00','',''),(2435127,'1','141','764',322,'Retail Sale Id 1455610',3600.00,0.00,0.00,6.00,558.00,'2022-01-04 10:10:06','',''),(2435140,'1','141','764',322,'Retail Sale Id 1455623',6500.00,0.00,0.00,12.50,162.50,'2022-01-04 10:12:02','',''),(2435167,'1','141','764',322,'Retail Sale Id 1455636',7500.00,0.00,0.00,12.50,1162.50,'2022-01-04 10:13:21','',''),(2435187,'1','141','764',322,'Retail Sale Id 1455652',1002.00,0.00,0.00,1.67,155.31,'2022-01-04 10:14:39','',''),(2435213,'1','141','764',322,'Retail Sale Id 1455672',62400.00,0.00,0.00,120.00,1560.00,'2022-01-04 10:16:53','',''),(2435248,'1','141','764',322,'Retail Sale Id 1455698',33280.00,0.00,0.00,64.00,832.00,'2022-01-04 10:19:25','',''),(2435266,'1','141','764',322,'Retail Sale Id 1455712',156000.00,0.00,0.00,300.00,3900.00,'2022-01-04 10:21:41','',''),(2435279,'1','141','764',322,'Retail Sale Id 1455724',600.00,0.00,0.00,1.00,93.00,'2022-01-04 10:24:04','',''),(2435297,'1','141','764',322,'Retail Sale Id 1455737',1800.00,0.00,0.00,3.00,279.00,'2022-01-04 10:26:06','',''),(2435336,'1','141','764',322,'Retail Sale Id 1455759',80080.00,0.00,0.00,154.00,2002.00,'2022-01-04 10:28:51','',''),(2435393,'1','141','764',322,'Retail Sale Id 1455799',9620.00,0.00,0.00,18.50,240.50,'2022-01-04 10:32:16','',''),(2435420,'1','141','764',322,'Retail Sale Id 1455827',1200.00,0.00,0.00,2.00,186.00,'2022-01-04 10:35:13','',''),(2435428,'1','141','764',322,'Retail Sale Id 1455836',1200.00,0.00,0.00,2.00,186.00,'2022-01-04 10:36:08','',''),(2435441,'1','141','764',322,'Retail Sale Id 1455848',1500.00,0.00,0.00,2.50,232.50,'2022-01-04 10:37:17','',''),(2435464,'1','141','764',322,'Retail Sale Id 1455866',1200.00,0.00,0.00,2.00,186.00,'2022-01-04 10:38:24','',''),(2435477,'1','141','764',322,'Retail Sale Id 1455887',3600.00,0.00,0.00,6.00,558.00,'2022-01-04 10:39:49','',''),(2435493,'1','141','764',322,'Retail Sale Id 1455900',2400.00,0.00,0.00,4.00,372.00,'2022-01-04 10:40:53','',''),(2435506,'1','141','764',322,'Retail Sale Id 1455913',3000.00,0.00,0.00,5.00,465.00,'2022-01-04 10:42:08','',''),(2435520,'1','141','764',322,'Retail Sale Id 1455924',3600.00,0.00,0.00,6.00,558.00,'2022-01-04 10:43:27','',''),(2435642,'1','141','764',322,'Retail Sale Id 1456043',4800.00,0.00,0.00,8.00,744.00,'2022-01-04 10:55:16','',''),(2435694,'1','141','764',322,'Retail Sale Id 1456099',52000.00,0.00,0.00,100.00,1300.00,'2022-01-04 11:00:19','',''),(2435719,'1','141','764',322,'Retail Sale Id 1456119',1998.00,0.00,0.00,3.33,309.69,'2022-01-04 11:02:08','',''),(2435729,'1','141','764',322,'Retail Sale Id 1456130',1500.00,0.00,0.00,2.50,232.50,'2022-01-04 11:03:17','',''),(2435750,'1','141','764',322,'Retail Sale Id 1456149',1800.00,0.00,0.00,3.00,279.00,'2022-01-04 11:04:42','',''),(2435790,'1','141','764',322,'Retail Sale Id 1456196',3600.00,0.00,0.00,6.00,558.00,'2022-01-04 11:09:23','',''),(2435821,'1','141','764',322,'Retail Sale Id 1456212',1998.00,0.00,0.00,3.33,309.69,'2022-01-04 11:11:08','',''),(2435859,'1','141','764',322,'Retail Sale Id 1456249',1200.00,0.00,0.00,2.00,186.00,'2022-01-04 11:15:01','',''),(2435869,'1','141','764',322,'Retail Sale Id 1456262',1800.00,0.00,0.00,3.00,279.00,'2022-01-04 11:15:53','',''),(2435886,'1','141','764',322,'Retail Sale Id 1456280',115700.00,0.00,0.00,222.50,2892.50,'2022-01-04 11:17:32','',''),(2435943,'1','141','764',322,'Retail Sale Id 1456332',40560.00,0.00,0.00,78.00,1014.00,'2022-01-04 11:23:11','',''),(2436030,'1','141','764',322,'Retail Sale Id 1456400',1500.00,0.00,0.00,2.50,232.50,'2022-01-04 11:29:18','',''),(2436042,'1','141','764',322,'Retail Sale Id 1456411',4002.00,0.00,0.00,6.67,620.31,'2022-01-04 11:30:30','',''),(2436056,'1','141','764',322,'Retail Sale Id 1456425',1998.00,0.00,0.00,3.33,309.69,'2022-01-04 11:31:39','',''),(2436068,'1','141','764',322,'Retail Sale Id 1456438',115440.00,0.00,0.00,222.00,2886.00,'2022-01-04 11:33:03','',''),(2436111,'1','141','764',322,'Retail Sale Id 1456472',28080.00,0.00,0.00,54.00,702.00,'2022-01-04 11:37:34','',''),(2436141,'1','141','764',322,'Retail Sale Id 1456505',46800.00,0.00,0.00,90.00,1170.00,'2022-01-04 11:40:05','',''),(2436163,'1','141','764',322,'Retail Sale Id 1456524',3000.00,0.00,0.00,5.00,465.00,'2022-01-04 11:42:11','',''),(2436176,'1','141','764',322,'Retail Sale Id 1456535',1698.00,0.00,0.00,2.83,263.19,'2022-01-04 11:43:23','',''),(2436182,'1','141','764',322,'Retail Sale Id 1456541',2400.00,0.00,0.00,4.00,372.00,'2022-01-04 11:44:21','',''),(2436200,'1','141','764',322,'Retail Sale Id 1456556',1200.00,0.00,0.00,2.00,186.00,'2022-01-04 11:46:22','',''),(2436227,'1','141','764',322,'Retail Sale Id 1456586',191880.00,0.00,0.00,369.00,4797.00,'2022-01-04 11:49:33','',''),(2436265,'1','141','764',322,'Retail Sale Id 1456621',28600.00,0.00,0.00,55.00,715.00,'2022-01-04 11:52:32','',''),(2436284,'1','141','764',322,'Retail Sale Id 1456637',1800.00,0.00,0.00,3.00,279.00,'2022-01-04 11:54:43','',''),(2436293,'1','141','764',322,'Retail Sale Id 1456655',3900.00,0.00,0.00,6.50,604.50,'2022-01-04 11:55:58','',''),(2436304,'1','141','764',322,'Retail Sale Id 1456667',3600.00,0.00,0.00,6.00,558.00,'2022-01-04 11:57:03','',''),(2436320,'1','141','764',322,'Retail Sale Id 1456682',1200.00,0.00,0.00,2.00,186.00,'2022-01-04 11:58:24','',''),(2436332,'1','141','764',322,'Retail Sale Id 1456696',1002.00,0.00,0.00,1.67,155.31,'2022-01-04 12:00:08','',''),(2436340,'1','141','764',322,'Retail Sale Id 1456707',4200.00,0.00,0.00,7.00,651.00,'2022-01-04 12:01:02','',''),(2436351,'1','141','764',322,'Retail Sale Id 1456716',1800.00,0.00,0.00,3.00,279.00,'2022-01-04 12:02:21','',''),(2436361,'1','141','764',322,'Retail Sale Id 1456727',3600.00,0.00,0.00,6.00,558.00,'2022-01-04 12:03:24','',''),(2436370,'1','141','764',322,'Retail Sale Id 1456736',6500.00,0.00,0.00,12.50,162.50,'2022-01-04 12:04:28','',''),(2436462,'1','141','764',322,'Retail Sale Id 1456832',1800.00,0.00,0.00,3.00,279.00,'2022-01-04 12:15:15','',''),(2436474,'1','141','764',322,'Retail Sale Id 1456847',3000.00,0.00,0.00,5.00,465.00,'2022-01-04 12:16:47','',''),(2436507,'1','141','764',322,'Retail Sale Id 1456879',1800.00,0.00,0.00,3.00,279.00,'2022-01-04 12:20:56','',''),(2436515,'1','141','764',322,'Retail Sale Id 1456889',3600.00,0.00,0.00,6.00,558.00,'2022-01-04 12:22:22','',''),(2436737,'1','141','764',322,'Retail Sale Id 1457110',58500.00,0.00,0.00,112.50,1462.50,'2022-01-04 12:44:46','',''),(2436755,'1','141','764',322,'Retail Sale Id 1457129',14040.00,0.00,0.00,27.00,351.00,'2022-01-04 12:47:23','',''),(2436763,'1','141','764',322,'Retail Sale Id 1457138',3000.00,0.00,0.00,5.00,465.00,'2022-01-04 12:48:38','',''),(2436783,'1','141','764',322,'Retail Sale Id 1457151',114400.00,0.00,0.00,220.00,2860.00,'2022-01-04 12:50:29','',''),(2436799,'1','141','764',322,'Retail Sale Id 1457166',79560.00,0.00,0.00,153.00,1989.00,'2022-01-04 12:52:45','',''),(2436831,'1','141','764',322,'Retail Sale Id 1457198',1800.00,0.00,0.00,3.00,279.00,'2022-01-04 12:57:59','',''),(2436854,'1','141','764',322,'Retail Sale Id 1457218',4800.00,0.00,0.00,8.00,744.00,'2022-01-04 12:59:42','',''),(2436872,'1','141','764',322,'Retail Sale Id 1457236',31720.00,0.00,0.00,61.00,793.00,'2022-01-04 13:01:30','',''),(2436887,'1','141','764',322,'Retail Sale Id 1457251',33540.00,0.00,0.00,64.50,838.50,'2022-01-04 13:03:09','',''),(2436940,'1','141','764',322,'Retail Sale Id 1457301',600.00,0.00,0.00,1.00,93.00,'2022-01-04 13:07:42','',''),(2436956,'1','141','764',322,'Retail Sale Id 1457310',600.00,0.00,0.00,1.00,93.00,'2022-01-04 13:08:50','',''),(2436970,'1','141','764',322,'Retail Sale Id 1457322',1002.00,0.00,0.00,1.67,155.31,'2022-01-04 13:10:07','',''),(2436975,'1','141','764',322,'Retail Sale Id 1457327',26000.00,0.00,0.00,50.00,650.00,'2022-01-04 13:11:36','',''),(2436994,'1','141','764',322,'Retail Sale Id 1457336',57200.00,0.00,0.00,110.00,1430.00,'2022-01-04 13:13:15','',''),(2437016,'1','141','764',322,'Retail Sale Id 1457353',1200.00,0.00,0.00,2.00,186.00,'2022-01-04 13:16:05','',''),(2437025,'1','141','764',322,'Retail Sale Id 1457363',4800.00,0.00,0.00,8.00,744.00,'2022-01-04 13:17:35','',''),(2437055,'1','141','764',322,'Retail Sale Id 1457383',3000.00,0.00,0.00,5.00,465.00,'2022-01-04 13:20:28','',''),(2437074,'1','141','764',322,'Retail Sale Id 1457393',1200.00,0.00,0.00,2.00,186.00,'2022-01-04 13:21:59','',''),(2437102,'1','141','764',322,'Retail Sale Id 1457424',85280.00,0.00,0.00,164.00,2132.00,'2022-01-04 13:25:28','',''),(2437125,'1','141','764',322,'Retail Sale Id 1457448',7800.00,0.00,0.00,15.00,195.00,'2022-01-04 13:27:56','',''),(2437148,'1','141','764',322,'Retail Sale Id 1457550',52000.00,0.00,0.00,100.00,1300.00,'2022-01-04 13:31:05','',''),(2437168,'1','141','764',322,'Retail Sale Id 1457571',104000.00,0.00,0.00,200.00,2600.00,'2022-01-04 13:32:18','',''),(2437292,'1','141','764',322,'Retail Sale Id 1457652',104000.00,0.00,0.00,200.00,2600.00,'2022-01-04 13:39:12','',''),(2437419,'1','141','764',322,'Retail Sale Id 1457740',26000.00,0.00,0.00,50.00,650.00,'2022-01-04 13:49:57','',''),(2437446,'1','141','764',322,'Retail Sale Id 1457757',76180.00,0.00,0.00,146.50,1904.50,'2022-01-04 13:51:47','',''),(2437511,'1','141','764',322,'Retail Sale Id 1457814',41600.00,0.00,0.00,80.00,1040.00,'2022-01-04 13:56:50','',''),(2437639,'1','141','764',322,'Retail Sale Id 1457924',3640.00,0.00,0.00,7.00,91.00,'2022-01-04 14:08:54','',''),(2437818,'1','141','764',322,'Retail Sale Id 1458045',56160.00,0.00,0.00,108.00,1404.00,'2022-01-04 14:23:00','',''),(2437933,'1','141','764',322,'Retail Sale Id 1458122',78000.00,0.00,0.00,150.00,1950.00,'2022-01-04 14:32:55','',''),(2438027,'1','141','764',322,'Retail Sale Id 1458198',17992.00,0.00,0.00,34.60,449.80,'2022-01-04 14:41:02','',''),(2438059,'1','141','764',322,'Retail Sale Id 1458225',93600.00,0.00,0.00,180.00,2340.00,'2022-01-04 14:43:36','',''),(2438133,'1','141','764',322,'Retail Sale Id 1458260',4160.00,0.00,0.00,8.00,104.00,'2022-01-04 14:47:23','',''),(2438147,'1','141','764',322,'Retail Sale Id 1458274',35360.00,0.00,0.00,68.00,884.00,'2022-01-04 14:48:51','',''),(2438206,'1','141','764',322,'Retail Sale Id 1458331',70720.00,0.00,0.00,136.00,1768.00,'2022-01-04 14:55:08','',''),(2438294,'1','141','764',322,'Retail Sale Id 1458402',20800.00,0.00,0.00,40.00,520.00,'2022-01-04 15:01:32','',''),(2438378,'1','141','764',322,'Retail Sale Id 1458435',3120.00,0.00,0.00,6.00,78.00,'2022-01-04 15:04:57','',''),(2438424,'1','141','764',322,'Retail Sale Id 1458480',8320.00,0.00,0.00,16.00,208.00,'2022-01-04 15:09:20','',''),(2438544,'1','141','764',322,'Retail Sale Id 1458597',86840.00,0.00,0.00,167.00,2171.00,'2022-01-04 15:16:49','',''),(2438761,'1','141','764',322,'Retail Sale Id 1458802',14040.00,0.00,0.00,27.00,351.00,'2022-01-04 15:39:49','',''),(2438902,'1','141','764',322,'Retail Sale Id 1458921',156000.00,0.00,0.00,300.00,3900.00,'2022-01-04 15:50:09','',''),(2440074,'1','141','764',322,'Retail Sale Id 1457212',1200.00,0.00,0.00,2.00,186.00,'2022-01-04 20:10:23','',''),(2440082,'1','141','764',322,'Retail Sale Id 1459869',2148.00,0.00,0.00,3.58,332.94,'2022-01-04 20:12:58','',''),(2443821,'1','141','764',322,'Distributed to OPERATIONAL LOSS for sales id:344138',152414.34,0.00,0.00,300.62,0.00,'2022-01-05 12:47:42','',''),(2445061,'1','141',NULL,322,'Purchased from AA RANO NIGERIA LIMITED',0.00,12325000.00,25000.00,0.00,0.00,'2022-01-05 15:00:25','',''),(2445084,'1','141',NULL,322,'Reception corrector for bridging 129853',0.00,0.00,0.00,25000.00,0.00,'2022-01-05 15:02:38','',''),(2445085,'1','141','764',322,'Received from bridging 129853',0.00,0.00,25000.00,0.00,0.00,'2022-01-05 15:02:38','',''),(2445587,'1','141','764',322,'Retail Sale Id 1464100',225165.00,0.00,0.00,441.50,7505.50,'2022-01-05 15:39:51','',''),(2445596,'1','141','764',322,'Retail Sale Id 1464109',118320.00,0.00,0.00,232.00,3944.00,'2022-01-05 15:41:00','',''),(2445608,'1','141','764',322,'Retail Sale Id 1464118',131580.00,0.00,0.00,258.00,4386.00,'2022-01-05 15:42:13','',''),(2445616,'1','141','764',322,'Retail Sale Id 1464125',227460.00,0.00,0.00,446.00,7582.00,'2022-01-05 15:43:19','',''),(2445641,'1','141','764',322,'Retail Sale Id 1464152',476850.00,0.00,0.00,935.00,15895.00,'2022-01-05 15:45:46','',''),(2445777,'1','141','764',322,'Retail Sale Id 1464258',9280.00,0.00,0.00,16.00,1392.00,'2022-01-05 15:57:53','',''),(2445889,'1','141','764',322,'Retail Sale Id 1464354',11310.00,0.00,0.00,19.50,1696.50,'2022-01-05 16:09:02','',''),(2445947,'1','141','764',322,'Retail Sale Id 1464394',20880.00,0.00,0.00,36.00,3132.00,'2022-01-05 16:14:13','',''),(2446064,'1','141','764',322,'Retail Sale Id 1464486',20010.00,0.00,0.00,34.50,3001.50,'2022-01-05 16:25:34','',''),(2446069,'1','141','764',322,'Retail Sale Id 1464491',14500.00,0.00,0.00,25.00,2175.00,'2022-01-05 16:26:19','',''),(2446482,'1','141','764',322,'Retail Sale Id 1464849',98832.00,0.00,0.00,170.40,14824.80,'2022-01-05 17:01:42','',''),(2446836,'1','141','764',322,'Retail Sale Id 1465190',20184.00,0.00,0.00,34.80,3027.60,'2022-01-05 17:32:17','',''),(2446886,'1','141','764',322,'Retail Sale Id 1465245',450585.00,0.00,0.00,883.50,15019.50,'2022-01-05 17:36:27','',''),(2446941,'1','141','764',322,'Retail Sale Id 1465264',204510.00,0.00,0.00,401.00,6817.00,'2022-01-05 17:38:27','',''),(2446969,'1','141','764',322,'Retail Sale Id 1465281',8468.00,0.00,0.00,14.60,1270.20,'2022-01-05 17:39:49','',''),(2447008,'1','141','764',322,'Retail Sale Id 1465310',7250.00,0.00,0.00,12.50,1087.50,'2022-01-05 17:43:08','',''),(2447235,'1','141','764',322,'Retail Sale Id 1465519',88281.00,0.00,0.00,173.10,2942.70,'2022-01-05 18:11:11','',''),(2448929,'1','141','764',322,'Retail Sale Id 1466440',7250.00,0.00,0.00,12.50,1087.50,'2022-01-06 08:42:11','',''),(2448941,'1','141','764',322,'Retail Sale Id 1466449',928.00,0.00,0.00,1.60,139.20,'2022-01-06 08:43:44','',''),(2449069,'1','141','764',322,'Retail Sale Id 1466499',1740.00,0.00,0.00,3.00,261.00,'2022-01-06 08:51:48','',''),(2449101,'1','141','764',322,'Retail Sale Id 1466523',5220.00,0.00,0.00,9.00,783.00,'2022-01-06 08:54:54','',''),(2449122,'1','141','764',322,'Retail Sale Id 1466540',1450.00,0.00,0.00,2.50,217.50,'2022-01-06 08:57:32','',''),(2449143,'1','141','764',322,'Retail Sale Id 1466563',21170.00,0.00,0.00,36.50,3175.50,'2022-01-06 09:00:08','',''),(2449167,'1','141','764',322,'Retail Sale Id 1466588',413100.00,0.00,0.00,810.00,13770.00,'2022-01-06 09:02:30','',''),(2449174,'1','141','764',322,'Retail Sale Id 1466599',616845.00,0.00,0.00,1209.50,20561.50,'2022-01-06 09:03:43','',''),(2449188,'1','141','764',322,'Retail Sale Id 1466613',130560.00,0.00,0.00,256.00,4352.00,'2022-01-06 09:05:27','',''),(2449202,'1','141','764',322,'Retail Sale Id 1466627',1914.00,0.00,0.00,3.30,287.10,'2022-01-06 09:06:29','',''),(2449260,'1','141','764',322,'Retail Sale Id 1466680',8294.00,0.00,0.00,14.30,1244.10,'2022-01-06 09:10:31','',''),(2449278,'1','141','764',322,'Retail Sale Id 1466695',11716.00,0.00,0.00,20.20,1757.40,'2022-01-06 09:12:33','',''),(2449730,'1','141','764',322,'Retail Sale Id 1467102',15428.00,0.00,0.00,26.60,2314.20,'2022-01-06 09:51:34','',''),(2449771,'1','141','764',322,'Retail Sale Id 1467144',12586.00,0.00,0.00,21.70,1887.90,'2022-01-06 09:55:30','',''),(2450882,'1','141','764',322,'Retail Sale Id 1468170',263160.00,0.00,0.00,516.00,8772.00,'2022-01-06 11:42:00','',''),(2450900,'1','141','764',322,'Retail Sale Id 1468186',109650.00,0.00,0.00,215.00,3655.00,'2022-01-06 11:43:23','',''),(2450914,'1','141','764',322,'Retail Sale Id 1468202',6554.00,0.00,0.00,11.30,983.10,'2022-01-06 11:44:34','',''),(2450926,'1','141','764',322,'Retail Sale Id 1468215',12470.00,0.00,0.00,21.50,1870.50,'2022-01-06 11:45:42','',''),(2450951,'1','141','764',322,'Retail Sale Id 1468221',7134.00,0.00,0.00,12.30,1070.10,'2022-01-06 11:46:45','',''),(2450975,'1','141','764',322,'Retail Sale Id 1468232',18270.00,0.00,0.00,31.50,2740.50,'2022-01-06 11:47:55','',''),(2451024,'1','141','764',322,'Retail Sale Id 1468314',6728.00,0.00,0.00,11.60,1009.20,'2022-01-06 11:54:01','',''),(2451121,'1','141','764',322,'Retail Sale Id 1468442',13340.00,0.00,0.00,23.00,2001.00,'2022-01-06 12:04:52','',''),(2451137,'1','141','764',322,'Retail Sale Id 1468463',14210.00,0.00,0.00,24.50,2131.50,'2022-01-06 12:06:32','',''),(2451153,'1','141','764',322,'Retail Sale Id 1468480',5916.00,0.00,0.00,10.20,887.40,'2022-01-06 12:08:33','',''),(2451202,'1','141','764',322,'Retail Sale Id 1468523',5220.00,0.00,0.00,9.00,783.00,'2022-01-06 12:12:19','',''),(2451834,'1','141','764',322,'Retail Sale Id 1469133',326400.00,0.00,0.00,640.00,10880.00,'2022-01-06 13:25:19','',''),(2451848,'1','141','764',322,'Retail Sale Id 1469148',213435.00,0.00,0.00,418.50,7114.50,'2022-01-06 13:27:12','',''),(2452020,'1','141','764',322,'Retail Sale Id 1469347',424065.00,0.00,0.00,831.50,14135.50,'2022-01-06 13:50:17','',''),(2452099,'1','141','764',322,'Retail Sale Id 1469437',9435.00,0.00,0.00,18.50,314.50,'2022-01-06 14:00:56','',''),(2452654,'1','141','764',322,'Retail Sale Id 1469829',95472.00,0.00,0.00,187.20,3182.40,'2022-01-06 14:53:23','',''),(2452746,'1','141','764',322,'Retail Sale Id 1469862',62475.00,0.00,0.00,122.50,2082.50,'2022-01-06 14:56:47','',''),(2454260,'1','141','764',322,'Retail Sale Id 1471203',288915.00,0.00,0.00,566.50,9630.50,'2022-01-06 17:16:05','',''),(2454274,'1','141','764',322,'Retail Sale Id 1471218',176205.00,0.00,0.00,345.50,5873.50,'2022-01-06 17:17:45','',''),(2454512,'1','141','764',322,'Retail Sale Id 1471454',97614.00,0.00,0.00,168.30,14642.10,'2022-01-06 17:38:21','',''),(2454564,'1','141','764',322,'Return of Retail Sale Id 1468480',0.00,5916.00,10.20,0.00,-887.40,'2022-01-06 17:43:04','',''),(2456630,'1','141','764',322,'Retail Sale Id 1472735',1740.00,0.00,0.00,3.00,261.00,'2022-01-07 08:43:56','',''),(2456701,'1','141','764',322,'Retail Sale Id 1472805',1740.00,0.00,0.00,3.00,261.00,'2022-01-07 08:50:11','',''),(2456713,'1','141','764',322,'Retail Sale Id 1472829',1740.00,0.00,0.00,3.00,261.00,'2022-01-07 08:51:58','',''),(2456724,'1','141','764',322,'Retail Sale Id 1472838',4814.00,0.00,0.00,8.30,722.10,'2022-01-07 08:52:39','',''),(2456730,'1','141','764',322,'Retail Sale Id 1472844',1914.00,0.00,0.00,3.30,287.10,'2022-01-07 08:53:19','',''),(2456738,'1','141','764',322,'Retail Sale Id 1472856',1740.00,0.00,0.00,3.00,261.00,'2022-01-07 08:54:10','',''),(2456748,'1','141','764',322,'Retail Sale Id 1472866',3480.00,0.00,0.00,6.00,522.00,'2022-01-07 08:55:00','',''),(2457032,'1','141','764',322,'Retail Sale Id 1473078',59160.00,0.00,0.00,116.00,1972.00,'2022-01-07 09:14:12','',''),(2457051,'1','141','764',322,'Retail Sale Id 1473103',56100.00,0.00,0.00,110.00,1870.00,'2022-01-07 09:15:38','',''),(2457067,'1','141','764',322,'Retail Sale Id 1473119',15300.00,0.00,0.00,30.00,510.00,'2022-01-07 09:17:10','',''),(2457131,'1','141','764',322,'Retail Sale Id 1473185',35700.00,0.00,0.00,70.00,1190.00,'2022-01-07 09:24:02','',''),(2457321,'1','141','764',322,'Retail Sale Id 1473336',291210.00,0.00,0.00,571.00,9707.00,'2022-01-07 09:38:35','',''),(2457599,'1','141','764',322,'Retail Sale Id 1473580',3828.00,0.00,0.00,6.60,574.20,'2022-01-07 10:12:30','',''),(2457609,'1','141','764',322,'Retail Sale Id 1473589',4640.00,0.00,0.00,8.00,696.00,'2022-01-07 10:13:21','',''),(2457616,'1','141','764',322,'Retail Sale Id 1473598',7250.00,0.00,0.00,12.50,1087.50,'2022-01-07 10:14:09','',''),(2457623,'1','141','764',322,'Retail Sale Id 1473606',9280.00,0.00,0.00,16.00,1392.00,'2022-01-07 10:15:11','',''),(2457640,'1','141','764',322,'Retail Sale Id 1473614',38250.00,0.00,0.00,75.00,1275.00,'2022-01-07 10:16:30','',''),(2457928,'1','141','764',322,'Retail Sale Id 1473905',15138.00,0.00,0.00,26.10,2270.70,'2022-01-07 10:46:40','',''),(2458066,'1','141','764',322,'Retail Sale Id 1474048',2900.00,0.00,0.00,5.00,435.00,'2022-01-07 11:01:38','',''),(2458078,'1','141','764',322,'Retail Sale Id 1474057',3480.00,0.00,0.00,6.00,522.00,'2022-01-07 11:02:37','',''),(2458087,'1','141','764',322,'Retail Sale Id 1474067',5278.00,0.00,0.00,9.10,791.70,'2022-01-07 11:03:44','',''),(2458370,'1','141','764',322,'Retail Sale Id 1474268',7250.00,0.00,0.00,12.50,1087.50,'2022-01-07 11:24:26','',''),(2458384,'1','141','764',322,'Retail Sale Id 1474284',1740.00,0.00,0.00,3.00,261.00,'2022-01-07 11:25:58','',''),(2458438,'1','141','764',322,'Retail Sale Id 1474327',4060.00,0.00,0.00,7.00,609.00,'2022-01-07 11:30:37','',''),(2458694,'1','141','764',322,'Retail Sale Id 1474565',6960.00,0.00,0.00,12.00,1044.00,'2022-01-07 11:57:38','',''),(2459323,'1','141','764',322,'Retail Sale Id 1475194',17400.00,0.00,0.00,30.00,2610.00,'2022-01-07 13:17:32','',''),(2459369,'1','141','764',322,'Retail Sale Id 1475224',16588.00,0.00,0.00,28.60,2488.20,'2022-01-07 13:25:11','',''),(2460633,'1','141','764',322,'Retail Sale Id 1473075',59160.00,0.00,0.00,116.00,1972.00,'2022-01-07 15:39:04','',''),(2460758,'1','141','764',322,'Retail Sale Id 1476144',136935.00,0.00,0.00,268.50,4564.50,'2022-01-07 15:45:56','',''),(2460844,'1','141','764',322,'Retail Sale Id 1476143',136935.00,0.00,0.00,268.50,4564.50,'2022-01-07 15:53:07','',''),(2460957,'1','141','764',322,'Retail Sale Id 1476142',136935.00,0.00,0.00,268.50,4564.50,'2022-01-07 16:02:59','',''),(2461019,'1','141','764',322,'Retail Sale Id 1474033',61200.00,0.00,0.00,120.00,2040.00,'2022-01-07 16:12:10','',''),(2461072,'1','141','764',322,'Retail Sale Id 1473102',56100.00,0.00,0.00,110.00,1870.00,'2022-01-07 16:18:11','',''),(2461301,'1','141','764',322,'Retail Sale Id 1476803',29638.00,0.00,0.00,51.10,4445.70,'2022-01-07 16:38:02','',''),(2461314,'1','141','764',322,'Retail Sale Id 1476816',12644.00,0.00,0.00,21.80,1896.60,'2022-01-07 16:39:24','',''),(2461325,'1','141','764',322,'Retail Sale Id 1476827',15660.00,0.00,0.00,27.00,2349.00,'2022-01-07 16:40:33','',''),(2461341,'1','141','764',322,'Retail Sale Id 1476842',17168.00,0.00,0.00,29.60,2575.20,'2022-01-07 16:42:34','',''),(2461352,'1','141','764',322,'Retail Sale Id 1476851',255510.00,0.00,0.00,501.00,8517.00,'2022-01-07 16:44:00','',''),(2461372,'1','141','764',322,'Retail Sale Id 1476871',223125.00,0.00,0.00,437.50,7437.50,'2022-01-07 16:46:07','',''),(2461548,'1','141','764',322,'Return of Retail Sale Id 1476143',0.00,136935.00,268.50,0.00,-4564.50,'2022-01-07 17:03:46','',''),(2461614,'1','141','764',322,'Return of Retail Sale Id 1476142',0.00,136935.00,268.50,0.00,-4564.50,'2022-01-07 17:10:10','',''),(2461947,'1','141','764',322,'Return of Retail Sale Id 1473102',0.00,56100.00,110.00,0.00,-1870.00,'2022-01-07 17:36:09','',''),(2462574,'1','141','764',322,'Retail Sale Id 1477855',110721.00,0.00,0.00,217.10,3690.70,'2022-01-07 19:51:01','',''),(2464851,'1','141','764',322,'Retail Sale Id 1479543',134640.00,0.00,0.00,264.00,4488.00,'2022-01-08 10:12:29','',''),(2464899,'1','141','764',322,'Retail Sale Id 1479584',141270.00,0.00,0.00,277.00,4709.00,'2022-01-08 10:16:51','',''),(2465035,'1','141','764',322,'Retail Sale Id 1479680',151980.00,0.00,0.00,298.00,5066.00,'2022-01-08 10:27:30','',''),(2465121,'1','141','764',322,'Retail Sale Id 1479679',151980.00,0.00,0.00,298.00,5066.00,'2022-01-08 10:36:10','',''),(2465153,'1','141','764',322,'Retail Sale Id 1479797',177990.00,0.00,0.00,349.00,5933.00,'2022-01-08 10:38:35','',''),(2465205,'1','141','764',322,'Return of Retail Sale Id 1479679',0.00,151980.00,298.00,0.00,-5066.00,'2022-01-08 10:43:40','',''),(2465557,'1','141','764',322,'Retail Sale Id 1480164',27840.00,0.00,0.00,48.00,4176.00,'2022-01-08 11:11:14','',''),(2465602,'1','141','764',322,'Retail Sale Id 1480183',19488.00,0.00,0.00,33.60,2923.20,'2022-01-08 11:15:47','',''),(2465790,'1','141','764',322,'Retail Sale Id 1480353',16472.00,0.00,0.00,28.40,2470.80,'2022-01-08 11:28:56','',''),(2465881,'1','141','764',322,'Retail Sale Id 1480459',31378.00,0.00,0.00,54.10,4706.70,'2022-01-08 11:37:49','',''),(2466145,'1','141','764',322,'Retail Sale Id 1480698',19952.00,0.00,0.00,34.40,2992.80,'2022-01-08 12:00:37','',''),(2466276,'1','141','764',322,'Retail Sale Id 1480804',17110.00,0.00,0.00,29.50,2566.50,'2022-01-08 12:13:04','',''),(2466725,'1','141','764',322,'Retail Sale Id 1481216',162945.00,0.00,0.00,319.50,5431.50,'2022-01-08 12:58:20','',''),(2466754,'1','141','764',322,'Retail Sale Id 1481250',92004.00,0.00,0.00,180.40,3066.80,'2022-01-08 13:00:55','',''),(2466818,'1','141','764',322,'Retail Sale Id 1481267',99450.00,0.00,0.00,195.00,3315.00,'2022-01-08 13:07:24','',''),(2467428,'1','141','764',322,'Retail Sale Id 1481804',15080.00,0.00,0.00,26.00,2262.00,'2022-01-08 14:02:20','',''),(2467452,'1','141','764',322,'Retail Sale Id 1481820',31900.00,0.00,0.00,55.00,4785.00,'2022-01-08 14:04:49','',''),(2467872,'1','141','764',322,'Retail Sale Id 1482150',30740.00,0.00,0.00,53.00,4611.00,'2022-01-08 14:38:43','',''),(2467887,'1','141','764',322,'Retail Sale Id 1482158',10092.00,0.00,0.00,17.40,1513.80,'2022-01-08 14:40:04','',''),(2467922,'1','141','764',322,'Retail Sale Id 1482168',33988.00,0.00,0.00,58.60,5098.20,'2022-01-08 14:42:17','',''),(2467948,'1','141','764',322,'Retail Sale Id 1482202',204000.00,0.00,0.00,400.00,6800.00,'2022-01-08 14:44:49','',''),(2467964,'1','141','764',322,'Retail Sale Id 1482214',254235.00,0.00,0.00,498.50,8474.50,'2022-01-08 14:46:09','',''),(2468024,'1','141','764',322,'Retail Sale Id 1482269',22040.00,0.00,0.00,38.00,3306.00,'2022-01-08 14:51:10','',''),(2468686,'1','141','764',322,'Retail Sale Id 1482722',19488.00,0.00,0.00,33.60,2923.20,'2022-01-08 15:49:06','',''),(2469988,'1','141','764',322,'Retail Sale Id 1483937',21344.00,0.00,0.00,36.80,3201.60,'2022-01-08 17:20:22','',''),(2470009,'1','141','764',322,'Retail Sale Id 1483961',18444.00,0.00,0.00,31.80,2766.60,'2022-01-08 17:22:08','',''),(2470338,'1','141','764',322,'Retail Sale Id 1484284',358020.00,0.00,0.00,702.00,11934.00,'2022-01-08 17:49:25','',''),(2470362,'1','141','764',322,'Retail Sale Id 1484310',77279.20,0.00,0.00,133.24,11591.88,'2022-01-08 17:51:49','',''),(2472834,'1','141','764',322,'Retail Sale Id 1486497',3480.00,0.00,0.00,6.00,522.00,'2022-01-09 09:49:17','',''),(2472841,'1','141','764',322,'Retail Sale Id 1486505',1450.00,0.00,0.00,2.50,217.50,'2022-01-09 09:50:00','',''),(2472852,'1','141','764',322,'Retail Sale Id 1486516',5800.00,0.00,0.00,10.00,870.00,'2022-01-09 09:50:45','',''),(2472879,'1','141','764',322,'Retail Sale Id 1486538',3480.00,0.00,0.00,6.00,522.00,'2022-01-09 09:52:46','',''),(2472887,'1','141','764',322,'Retail Sale Id 1486547',5800.00,0.00,0.00,10.00,870.00,'2022-01-09 09:53:32','',''),(2472916,'1','141','764',322,'Retail Sale Id 1486579',2900.00,0.00,0.00,5.00,435.00,'2022-01-09 09:56:06','',''),(2472972,'1','141','764',322,'Retail Sale Id 1486629',2900.00,0.00,0.00,5.00,435.00,'2022-01-09 10:01:47','',''),(2473023,'1','141','764',322,'Retail Sale Id 1486693',89250.00,0.00,0.00,175.00,2975.00,'2022-01-09 10:07:11','',''),(2473160,'1','141','764',322,'Retail Sale Id 1486840',10614.00,0.00,0.00,18.30,1592.10,'2022-01-09 10:20:04','',''),(2473221,'1','141','764',322,'Retail Sale Id 1486885',580.00,0.00,0.00,1.00,87.00,'2022-01-09 10:24:54','',''),(2473238,'1','141','764',322,'Retail Sale Id 1486895',37740.00,0.00,0.00,74.00,1258.00,'2022-01-09 10:25:45','',''),(2473357,'1','141','764',322,'Retail Sale Id 1486968',76500.00,0.00,0.00,150.00,2550.00,'2022-01-09 10:32:53','',''),(2473543,'1','141','764',322,'Retail Sale Id 1487128',9338.00,0.00,0.00,16.10,1400.70,'2022-01-09 10:48:15','',''),(2474338,'1','141','764',322,'Retail Sale Id 1487847',7250.00,0.00,0.00,12.50,1087.50,'2022-01-09 11:49:03','',''),(2474344,'1','141','764',322,'Retail Sale Id 1487852',7540.00,0.00,0.00,13.00,1131.00,'2022-01-09 11:49:51','',''),(2474370,'1','141','764',322,'Retail Sale Id 1487865',2668.00,0.00,0.00,4.60,400.20,'2022-01-09 11:52:10','',''),(2476923,'1','141','764',322,'Retail Sale Id 1490247',66300.00,0.00,0.00,130.00,2210.00,'2022-01-09 15:35:35','',''),(2476934,'1','141','764',322,'Retail Sale Id 1490261',145350.00,0.00,0.00,285.00,4845.00,'2022-01-09 15:36:36','',''),(2476942,'1','141','764',322,'Retail Sale Id 1490268',82875.00,0.00,0.00,162.50,2762.50,'2022-01-09 15:37:25','',''),(2477024,'1','141','764',322,'Retail Sale Id 1490339',117402.00,0.00,0.00,230.20,3913.40,'2022-01-09 15:45:22','',''),(2477040,'1','141','764',322,'Retail Sale Id 1490349',126990.00,0.00,0.00,249.00,4233.00,'2022-01-09 15:46:13','',''),(2477053,'1','141','764',322,'Retail Sale Id 1490361',167025.00,0.00,0.00,327.50,5567.50,'2022-01-09 15:47:35','',''),(2477062,'1','141','764',322,'Retail Sale Id 1490372',104040.00,0.00,0.00,204.00,3468.00,'2022-01-09 15:48:20','',''),(2477218,'1','141','764',322,'Retail Sale Id 1490476',22678.00,0.00,0.00,39.10,3401.70,'2022-01-09 16:01:06','',''),(2477264,'1','141','764',322,'Retail Sale Id 1490508',17168.00,0.00,0.00,29.60,2575.20,'2022-01-09 16:04:50','',''),(2477273,'1','141','764',322,'Retail Sale Id 1490520',10266.00,0.00,0.00,17.70,1539.90,'2022-01-09 16:06:03','',''),(2477280,'1','141','764',322,'Retail Sale Id 1490527',11484.00,0.00,0.00,19.80,1722.60,'2022-01-09 16:07:19','',''),(2477318,'1','141','764',322,'Retail Sale Id 1490563',21228.00,0.00,0.00,36.60,3184.20,'2022-01-09 16:11:30','',''),(2477379,'1','141','764',322,'Retail Sale Id 1490612',17690.00,0.00,0.00,30.50,2653.50,'2022-01-09 16:16:55','',''),(2477411,'1','141','764',322,'Retail Sale Id 1490646',12296.00,0.00,0.00,21.20,1844.40,'2022-01-09 16:21:28','',''),(2477442,'1','141','764',322,'Retail Sale Id 1490659',227154.00,0.00,0.00,445.40,7571.80,'2022-01-09 16:23:25','',''),(2477525,'1','141','764',322,'Retail Sale Id 1490735',51000.00,0.00,0.00,100.00,1700.00,'2022-01-09 16:32:14','',''),(2477552,'1','141','764',322,'Retail Sale Id 1490762',5655.00,0.00,0.00,9.75,848.25,'2022-01-09 16:34:56','',''),(2477576,'1','141','764',322,'Return of Retail Sale Id 1486547',0.00,5800.00,10.00,0.00,-870.00,'2022-01-09 16:39:08','',''),(2480369,'1','141','764',322,'Retail Sale Id 1492939',5800.00,0.00,0.00,10.00,870.00,'2022-01-10 09:09:10','',''),(2480379,'1','141','764',322,'Retail Sale Id 1492950',7250.00,0.00,0.00,12.50,1087.50,'2022-01-10 09:10:17','',''),(2480998,'1','141','764',322,'Retail Sale Id 1492994',7308.00,0.00,0.00,12.60,1096.20,'2022-01-10 10:04:58','',''),(2481029,'1','141','764',322,'Retail Sale Id 1493427',22446.00,0.00,0.00,38.70,3366.90,'2022-01-10 10:06:45','',''),(2481069,'1','141','764',322,'Retail Sale Id 1493443',13166.00,0.00,0.00,22.70,1974.90,'2022-01-10 10:08:10','',''),(2481413,'1','141','764',322,'Retail Sale Id 1493477',21460.00,0.00,0.00,37.00,3219.00,'2022-01-10 10:50:26','',''),(2481426,'1','141','764',322,'Retail Sale Id 1493822',23258.00,0.00,0.00,40.10,3488.70,'2022-01-10 10:52:27','',''),(2481459,'1','141','764',322,'Retail Sale Id 1493855',182835.00,0.00,0.00,358.50,6094.50,'2022-01-10 10:55:58','',''),(2482074,'1','141','764',322,'Retail Sale Id 1494156',205020.00,0.00,0.00,402.00,6834.00,'2022-01-10 12:12:59','',''),(2482351,'1','141','764',322,'Retail Sale Id 1494618',278460.00,0.00,0.00,546.00,9282.00,'2022-01-10 12:32:12','',''),(2482382,'1','141','764',322,'Retail Sale Id 1494632',221340.00,0.00,0.00,434.00,7378.00,'2022-01-10 12:33:30','',''),(2482396,'1','141','764',322,'Retail Sale Id 1494644',143055.00,0.00,0.00,280.50,4768.50,'2022-01-10 12:34:54','',''),(2482803,'1','141','764',322,'Retail Sale Id 1495093',14848.00,0.00,0.00,25.60,2227.20,'2022-01-10 13:31:40','',''),(2482814,'1','141','764',322,'Retail Sale Id 1495102',143055.00,0.00,0.00,280.50,4768.50,'2022-01-10 13:33:17','',''),(2482819,'1','141','764',322,'Retail Sale Id 1495109',346800.00,0.00,0.00,680.00,11560.00,'2022-01-10 13:34:22','',''),(2482830,'1','141','764',322,'Retail Sale Id 1495120',253215.00,0.00,0.00,496.50,8440.50,'2022-01-10 13:36:31','',''),(2482853,'1','141','764',322,'Retail Sale Id 1495145',25500.00,0.00,0.00,50.00,850.00,'2022-01-10 13:39:43','',''),(2485308,'1','141','764',322,'Retail Sale Id 1497290',6960.00,0.00,0.00,12.00,1044.00,'2022-01-10 17:43:04','',''),(2485502,'1','141','764',322,'Retail Sale Id 1497482',9860.00,0.00,0.00,17.00,1479.00,'2022-01-10 18:01:36','',''),(2485553,'1','141','764',322,'Retail Sale Id 1497527',119141.10,0.00,0.00,233.61,3971.37,'2022-01-10 18:06:57','',''),(2486159,'1','141','764',322,'Retail Sale Id 1492948',7250.00,0.00,0.00,12.50,1087.50,'2022-01-10 21:48:42','',''),(2486160,'1','141','764',322,'Retail Sale Id 1498030',348.00,0.00,0.00,0.60,52.20,'2022-01-10 21:56:02','',''),(2486902,'1','141','764',322,'Distributed to OPERATIONAL LOSS for sales id:345348',126848.90,0.00,0.00,257.30,0.00,'2022-01-11 08:20:18','',''),(2486988,'1','141',NULL,322,'Purchased from AA RANO NIGERIA LIMITED',0.00,12200000.00,25000.00,0.00,0.00,'2022-01-11 08:30:09','',''),(2487002,'1','141',NULL,322,'Reception corrector for bridging 130416',0.00,0.00,0.00,25000.00,0.00,'2022-01-11 08:31:50','',''),(2487003,'1','141','764',322,'Received from bridging 130416',0.00,0.00,25000.00,0.00,0.00,'2022-01-11 08:31:50','',''),(2487261,'1','141','764',322,'Retail Sale Id 1498766',91910.00,0.00,0.00,182.00,3094.00,'2022-01-11 08:43:12','',''),(2487298,'1','141','764',322,'Retail Sale Id 1498801',25250.00,0.00,0.00,50.00,850.00,'2022-01-11 08:47:02','',''),(2487319,'1','141','764',322,'Retail Sale Id 1498821',30300.00,0.00,0.00,60.00,1020.00,'2022-01-11 08:49:54','',''),(2487343,'1','141','764',322,'Retail Sale Id 1498849',997.60,0.00,0.00,1.72,158.24,'2022-01-11 08:52:30','',''),(2487357,'1','141','764',322,'Retail Sale Id 1498864',580.00,0.00,0.00,1.00,92.00,'2022-01-11 08:53:57','',''),(2487372,'1','141','764',322,'Retail Sale Id 1498876',101000.00,0.00,0.00,200.00,3400.00,'2022-01-11 08:55:09','',''),(2487412,'1','141','764',322,'Retail Sale Id 1498911',135592.50,0.00,0.00,268.50,4564.50,'2022-01-11 08:59:53','',''),(2487458,'1','141','764',322,'Retail Sale Id 1498956',1160.00,0.00,0.00,2.00,184.00,'2022-01-11 09:05:19','',''),(2487469,'1','141','764',322,'Retail Sale Id 1498969',3497.40,0.00,0.00,6.03,554.76,'2022-01-11 09:06:24','',''),(2487477,'1','141','764',322,'Retail Sale Id 1498976',27775.00,0.00,0.00,55.00,935.00,'2022-01-11 09:07:25','',''),(2487487,'1','141','764',322,'Retail Sale Id 1498990',1502.20,0.00,0.00,2.59,238.28,'2022-01-11 09:08:37','',''),(2487494,'1','141','764',322,'Retail Sale Id 1498996',60600.00,0.00,0.00,120.00,2040.00,'2022-01-11 09:09:33','',''),(2487506,'1','141','764',322,'Retail Sale Id 1499010',7250.00,0.00,0.00,12.50,1150.00,'2022-01-11 09:11:04','',''),(2487529,'1','141','764',322,'Retail Sale Id 1499029',61105.00,0.00,0.00,121.00,2057.00,'2022-01-11 09:13:50','',''),(2487546,'1','141','764',322,'Retail Sale Id 1499046',77265.00,0.00,0.00,153.00,2601.00,'2022-01-11 09:15:59','',''),(2487554,'1','141','764',322,'Retail Sale Id 1499054',21715.00,0.00,0.00,43.00,731.00,'2022-01-11 09:17:39','',''),(2487586,'1','141','764',322,'Retail Sale Id 1499081',50500.00,0.00,0.00,100.00,1700.00,'2022-01-11 09:21:39','',''),(2487601,'1','141','764',322,'Retail Sale Id 1499094',2900.00,0.00,0.00,5.00,460.00,'2022-01-11 09:23:32','',''),(2487646,'1','141','764',322,'Retail Sale Id 1499110',9342.50,0.00,0.00,18.50,314.50,'2022-01-11 09:25:02','',''),(2487672,'1','141','764',322,'Retail Sale Id 1499128',32067.50,0.00,0.00,63.50,1079.50,'2022-01-11 09:27:24','',''),(2487695,'1','141','764',322,'Retail Sale Id 1499151',90900.00,0.00,0.00,180.00,3060.00,'2022-01-11 09:29:21','',''),(2487723,'1','141','764',322,'Retail Sale Id 1499175',50500.00,0.00,0.00,100.00,1700.00,'2022-01-11 09:32:25','',''),(2487796,'1','141','764',322,'Retail Sale Id 1499219',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 09:37:20','',''),(2487819,'1','141','764',322,'Retail Sale Id 1499242',55550.00,0.00,0.00,110.00,1870.00,'2022-01-11 09:39:55','',''),(2487982,'1','141','764',322,'Retail Sale Id 1499392',50500.00,0.00,0.00,100.00,1700.00,'2022-01-11 09:55:31','',''),(2488035,'1','141','764',322,'Retail Sale Id 1499445',75750.00,0.00,0.00,150.00,2550.00,'2022-01-11 10:02:05','',''),(2488064,'1','141','764',322,'Retail Sale Id 1499469',23987.50,0.00,0.00,47.50,807.50,'2022-01-11 10:05:13','',''),(2488131,'1','141','764',322,'Retail Sale Id 1499499',7250.00,0.00,0.00,12.50,1150.00,'2022-01-11 10:08:27','',''),(2488161,'1','141','764',322,'Retail Sale Id 1499522',7250.00,0.00,0.00,12.50,1150.00,'2022-01-11 10:10:45','',''),(2488180,'1','141','764',322,'Retail Sale Id 1499535',1160.00,0.00,0.00,2.00,184.00,'2022-01-11 10:11:57','',''),(2488214,'1','141','764',322,'Retail Sale Id 1499568',7250.00,0.00,0.00,12.50,1150.00,'2022-01-11 10:15:46','',''),(2488275,'1','141','764',322,'Retail Sale Id 1499612',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 10:21:35','',''),(2488289,'1','141','764',322,'Retail Sale Id 1499624',25250.00,0.00,0.00,50.00,850.00,'2022-01-11 10:22:47','',''),(2488546,'1','141','764',322,'Retail Sale Id 1499676',1502.20,0.00,0.00,2.59,238.28,'2022-01-11 10:50:06','',''),(2488564,'1','141','764',322,'Retail Sale Id 1499866',3480.00,0.00,0.00,6.00,552.00,'2022-01-11 10:52:11','',''),(2488584,'1','141','764',322,'Retail Sale Id 1499882',986.00,0.00,0.00,1.70,156.40,'2022-01-11 10:53:28','',''),(2488601,'1','141','764',322,'Retail Sale Id 1499899',49995.00,0.00,0.00,99.00,1683.00,'2022-01-11 10:54:48','',''),(2488710,'1','141','764',322,'Retail Sale Id 1500009',12625.00,0.00,0.00,25.00,425.00,'2022-01-11 11:06:33','',''),(2488733,'1','141','764',322,'Retail Sale Id 1500034',2320.00,0.00,0.00,4.00,368.00,'2022-01-11 11:09:28','',''),(2488747,'1','141','764',322,'Retail Sale Id 1500045',986.00,0.00,0.00,1.70,156.40,'2022-01-11 11:10:49','',''),(2488778,'1','141','764',322,'Retail Sale Id 1500079',97212.50,0.00,0.00,192.50,3272.50,'2022-01-11 11:13:35','',''),(2488816,'1','141','764',322,'Retail Sale Id 1500118',580.00,0.00,0.00,1.00,92.00,'2022-01-11 11:17:48','',''),(2488854,'1','141','764',322,'Retail Sale Id 1500157',1160.00,0.00,0.00,2.00,184.00,'2022-01-11 11:23:00','',''),(2488880,'1','141','764',322,'Retail Sale Id 1500181',20358.00,0.00,0.00,35.10,3229.20,'2022-01-11 11:25:48','',''),(2488888,'1','141','764',322,'Retail Sale Id 1500194',291890.00,0.00,0.00,578.00,9826.00,'2022-01-11 11:26:54','',''),(2488902,'1','141','764',322,'Retail Sale Id 1500206',277396.50,0.00,0.00,549.30,9338.10,'2022-01-11 11:28:17','',''),(2488937,'1','141','764',322,'Retail Sale Id 1500240',81557.50,0.00,0.00,161.50,2745.50,'2022-01-11 11:31:06','',''),(2488989,'1','141','764',322,'Retail Sale Id 1500290',580.00,0.00,0.00,1.00,92.00,'2022-01-11 11:36:24','',''),(2488997,'1','141','764',322,'Retail Sale Id 1500296',2900.00,0.00,0.00,5.00,460.00,'2022-01-11 11:37:41','',''),(2489031,'1','141','764',322,'Retail Sale Id 1500331',7250.00,0.00,0.00,12.50,1150.00,'2022-01-11 11:40:40','',''),(2489119,'1','141','764',322,'Retail Sale Id 1500347',50500.00,0.00,0.00,100.00,1700.00,'2022-01-11 11:43:33','',''),(2489127,'1','141','764',322,'Retail Sale Id 1500355',2001.00,0.00,0.00,3.45,317.40,'2022-01-11 11:45:11','',''),(2489136,'1','141','764',322,'Retail Sale Id 1500363',41410.00,0.00,0.00,82.00,1394.00,'2022-01-11 11:46:51','',''),(2489153,'1','141','764',322,'Retail Sale Id 1500381',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 11:49:11','',''),(2489162,'1','141','764',322,'Retail Sale Id 1500392',1160.00,0.00,0.00,2.00,184.00,'2022-01-11 11:50:49','',''),(2489182,'1','141','764',322,'Retail Sale Id 1500411',138875.00,0.00,0.00,275.00,4675.00,'2022-01-11 11:53:06','',''),(2489223,'1','141','764',322,'Retail Sale Id 1500441',92415.00,0.00,0.00,183.00,3111.00,'2022-01-11 11:58:08','',''),(2489254,'1','141','764',322,'Retail Sale Id 1500479',101000.00,0.00,0.00,200.00,3400.00,'2022-01-11 12:04:05','',''),(2489284,'1','141','764',322,'Retail Sale Id 1500509',3480.00,0.00,0.00,6.00,552.00,'2022-01-11 12:08:23','',''),(2489291,'1','141','764',322,'Retail Sale Id 1500521',3480.00,0.00,0.00,6.00,552.00,'2022-01-11 12:09:23','',''),(2489302,'1','141','764',322,'Retail Sale Id 1500535',580.00,0.00,0.00,1.00,92.00,'2022-01-11 12:11:02','',''),(2489335,'1','141','764',322,'Retail Sale Id 1500570',126250.00,0.00,0.00,250.00,4250.00,'2022-01-11 12:16:46','',''),(2489367,'1','141','764',322,'Retail Sale Id 1500626',6312.50,0.00,0.00,12.50,212.50,'2022-01-11 12:23:09','',''),(2489380,'1','141','764',322,'Retail Sale Id 1500644',1160.00,0.00,0.00,2.00,184.00,'2022-01-11 12:25:31','',''),(2489426,'1','141','764',322,'Retail Sale Id 1500684',60600.00,0.00,0.00,120.00,2040.00,'2022-01-11 12:31:43','',''),(2489471,'1','141','764',322,'Retail Sale Id 1500733',800.40,0.00,0.00,1.38,126.96,'2022-01-11 12:40:04','',''),(2489487,'1','141','764',322,'Retail Sale Id 1500747',580.00,0.00,0.00,1.00,92.00,'2022-01-11 12:41:53','',''),(2489649,'1','141','764',322,'Retail Sale Id 1500908',3497.40,0.00,0.00,6.03,554.76,'2022-01-11 13:06:45','',''),(2489663,'1','141','764',322,'Retail Sale Id 1500919',7250.00,0.00,0.00,12.50,1150.00,'2022-01-11 13:08:06','',''),(2489671,'1','141','764',322,'Retail Sale Id 1500931',3480.00,0.00,0.00,6.00,552.00,'2022-01-11 13:09:26','',''),(2489679,'1','141','764',322,'Retail Sale Id 1500941',138875.00,0.00,0.00,275.00,4675.00,'2022-01-11 13:10:28','',''),(2489691,'1','141','764',322,'Retail Sale Id 1500954',3480.00,0.00,0.00,6.00,552.00,'2022-01-11 13:13:00','',''),(2489700,'1','141','764',322,'Retail Sale Id 1500964',3480.00,0.00,0.00,6.00,552.00,'2022-01-11 13:14:09','',''),(2489707,'1','141','764',322,'Retail Sale Id 1500971',1160.00,0.00,0.00,2.00,184.00,'2022-01-11 13:15:14','',''),(2489717,'1','141','764',322,'Retail Sale Id 1500980',6312.50,0.00,0.00,12.50,212.50,'2022-01-11 13:16:43','',''),(2489769,'1','141','764',322,'Retail Sale Id 1501024',3480.00,0.00,0.00,6.00,552.00,'2022-01-11 13:22:06','',''),(2489780,'1','141','764',322,'Retail Sale Id 1501032',3480.00,0.00,0.00,6.00,552.00,'2022-01-11 13:23:06','',''),(2489806,'1','141','764',322,'Retail Sale Id 1501052',45955.00,0.00,0.00,91.00,1547.00,'2022-01-11 13:26:29','',''),(2489825,'1','141','764',322,'Retail Sale Id 1501072',3480.00,0.00,0.00,6.00,552.00,'2022-01-11 13:28:02','',''),(2489864,'1','141','764',322,'Retail Sale Id 1501110',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 13:33:08','',''),(2489904,'1','141','764',322,'Retail Sale Id 1501147',30300.00,0.00,0.00,60.00,1020.00,'2022-01-11 13:37:04','',''),(2489928,'1','141','764',322,'Retail Sale Id 1501166',580.00,0.00,0.00,1.00,92.00,'2022-01-11 13:39:29','',''),(2489947,'1','141','764',322,'Retail Sale Id 1501185',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 13:42:03','',''),(2489971,'1','141','764',322,'Retail Sale Id 1501211',580.00,0.00,0.00,1.00,92.00,'2022-01-11 13:46:42','',''),(2489989,'1','141','764',322,'Retail Sale Id 1501229',5220.00,0.00,0.00,9.00,828.00,'2022-01-11 13:48:46','',''),(2490005,'1','141','764',322,'Retail Sale Id 1501246',6817.50,0.00,0.00,13.50,229.50,'2022-01-11 13:50:54','',''),(2490184,'1','141','764',322,'Retail Sale Id 1501406',29795.00,0.00,0.00,59.00,1003.00,'2022-01-11 14:11:02','',''),(2490198,'1','141','764',322,'Retail Sale Id 1501419',2998.60,0.00,0.00,5.17,475.64,'2022-01-11 14:12:59','',''),(2490204,'1','141','764',322,'Retail Sale Id 1501425',1299.20,0.00,0.00,2.24,206.08,'2022-01-11 14:14:09','',''),(2490212,'1','141','764',322,'Retail Sale Id 1501432',3480.00,0.00,0.00,6.00,552.00,'2022-01-11 14:15:12','',''),(2490229,'1','141','764',322,'Retail Sale Id 1501449',12372.50,0.00,0.00,24.50,416.50,'2022-01-11 14:17:05','',''),(2490276,'1','141','764',322,'Retail Sale Id 1501476',580.00,0.00,0.00,1.00,92.00,'2022-01-11 14:20:15','',''),(2490308,'1','141','764',322,'Retail Sale Id 1501495',2525.00,0.00,0.00,5.00,85.00,'2022-01-11 14:22:47','',''),(2490334,'1','141','764',322,'Retail Sale Id 1501515',24240.00,0.00,0.00,48.00,816.00,'2022-01-11 14:25:32','',''),(2490342,'1','141','764',322,'Retail Sale Id 1501535',1450.00,0.00,0.00,2.50,230.00,'2022-01-11 14:26:43','',''),(2490363,'1','141','764',322,'Retail Sale Id 1501561',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 14:28:28','',''),(2490381,'1','141','764',322,'Retail Sale Id 1501579',4802.40,0.00,0.00,8.28,761.76,'2022-01-11 14:29:48','',''),(2490400,'1','141','764',322,'Retail Sale Id 1501588',138875.00,0.00,0.00,275.00,4675.00,'2022-01-11 14:30:49','',''),(2490421,'1','141','764',322,'Retail Sale Id 1501610',2320.00,0.00,0.00,4.00,368.00,'2022-01-11 14:32:37','',''),(2490484,'1','141','764',322,'Retail Sale Id 1501633',3480.00,0.00,0.00,6.00,552.00,'2022-01-11 14:34:51','',''),(2490540,'1','141','764',322,'Retail Sale Id 1501666',2320.00,0.00,0.00,4.00,368.00,'2022-01-11 14:39:12','',''),(2490623,'1','141','764',322,'Retail Sale Id 1501724',2900.00,0.00,0.00,5.00,460.00,'2022-01-11 14:47:34','',''),(2490634,'1','141','764',322,'Retail Sale Id 1501731',3480.00,0.00,0.00,6.00,552.00,'2022-01-11 14:49:06','',''),(2490645,'1','141','764',322,'Retail Sale Id 1501744',3480.00,0.00,0.00,6.00,552.00,'2022-01-11 14:50:38','',''),(2490663,'1','141','764',322,'Retail Sale Id 1501760',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 14:52:28','',''),(2490758,'1','141','764',322,'Retail Sale Id 1501806',88375.00,0.00,0.00,175.00,2975.00,'2022-01-11 14:58:00','',''),(2490807,'1','141','764',322,'Retail Sale Id 1501838',3770.00,0.00,0.00,6.50,598.00,'2022-01-11 15:02:15','',''),(2490820,'1','141','764',322,'Retail Sale Id 1501853',7250.00,0.00,0.00,12.50,1150.00,'2022-01-11 15:04:10','',''),(2490853,'1','141','764',322,'Retail Sale Id 1501867',2998.60,0.00,0.00,5.17,475.64,'2022-01-11 15:06:18','',''),(2490872,'1','141','764',322,'Retail Sale Id 1501879',580.00,0.00,0.00,1.00,92.00,'2022-01-11 15:07:42','',''),(2490965,'1','141','764',322,'Retail Sale Id 1501940',50500.00,0.00,0.00,100.00,1700.00,'2022-01-11 15:14:57','',''),(2491011,'1','141','764',322,'Retail Sale Id 1501974',2900.00,0.00,0.00,5.00,460.00,'2022-01-11 15:18:48','',''),(2491096,'1','141','764',322,'Retail Sale Id 1502016',7250.00,0.00,0.00,12.50,1150.00,'2022-01-11 15:23:39','',''),(2491105,'1','141','764',322,'Retail Sale Id 1502028',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 15:24:58','',''),(2491126,'1','141','764',322,'Retail Sale Id 1502048',2320.00,0.00,0.00,4.00,368.00,'2022-01-11 15:26:25','',''),(2491144,'1','141','764',322,'Retail Sale Id 1502063',7250.00,0.00,0.00,12.50,1150.00,'2022-01-11 15:28:07','',''),(2491160,'1','141','764',322,'Retail Sale Id 1502077',10605.00,0.00,0.00,21.00,357.00,'2022-01-11 15:29:38','',''),(2491177,'1','141','764',322,'Retail Sale Id 1502094',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 15:31:49','',''),(2491197,'1','141','764',322,'Retail Sale Id 1502106',11110.00,0.00,0.00,22.00,374.00,'2022-01-11 15:33:14','',''),(2491216,'1','141','764',322,'Retail Sale Id 1502125',32825.00,0.00,0.00,65.00,1105.00,'2022-01-11 15:35:18','',''),(2491245,'1','141','764',322,'Retail Sale Id 1502153',7250.00,0.00,0.00,12.50,1150.00,'2022-01-11 15:37:46','',''),(2491258,'1','141','764',322,'Retail Sale Id 1502165',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 15:39:27','',''),(2491277,'1','141','764',322,'Retail Sale Id 1502189',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 15:40:56','',''),(2491320,'1','141','764',322,'Retail Sale Id 1502211',2525.00,0.00,0.00,5.00,85.00,'2022-01-11 15:42:59','',''),(2491359,'1','141','764',322,'Retail Sale Id 1502244',5220.00,0.00,0.00,9.00,828.00,'2022-01-11 15:48:44','',''),(2491379,'1','141','764',322,'Retail Sale Id 1502269',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 15:50:57','',''),(2491396,'1','141','764',322,'Retail Sale Id 1502285',79285.00,0.00,0.00,157.00,2669.00,'2022-01-11 15:53:16','',''),(2491450,'1','141','764',322,'Retail Sale Id 1502350',5800.00,0.00,0.00,10.00,920.00,'2022-01-11 15:59:03','',''),(2491496,'1','141','764',322,'Retail Sale Id 1502399',49490.00,0.00,0.00,98.00,1666.00,'2022-01-11 16:05:36','',''),(2491510,'1','141','764',322,'Retail Sale Id 1502410',2900.00,0.00,0.00,5.00,460.00,'2022-01-11 16:07:10','',''),(2491535,'1','141','764',322,'Retail Sale Id 1502424',4999.60,0.00,0.00,8.62,793.04,'2022-01-11 16:08:48','',''),(2491561,'1','141','764',322,'Retail Sale Id 1502447',60600.00,0.00,0.00,120.00,2040.00,'2022-01-11 16:11:38','',''),(2491743,'1','141','764',322,'Retail Sale Id 1502635',2900.00,0.00,0.00,5.00,460.00,'2022-01-11 16:30:48','',''),(2491751,'1','141','764',322,'Retail Sale Id 1502643',701.80,0.00,0.00,1.21,111.32,'2022-01-11 16:31:53','',''),(2491764,'1','141','764',322,'Retail Sale Id 1502649',25250.00,0.00,0.00,50.00,850.00,'2022-01-11 16:33:10','',''),(2491795,'1','141','764',322,'Retail Sale Id 1502686',997.60,0.00,0.00,1.72,158.24,'2022-01-11 16:35:57','',''),(2491807,'1','141','764',322,'Retail Sale Id 1502701',27270.00,0.00,0.00,54.00,918.00,'2022-01-11 16:36:57','',''),(2491840,'1','141','764',322,'Retail Sale Id 1502739',4060.00,0.00,0.00,7.00,644.00,'2022-01-11 16:39:31','',''),(2491869,'1','141','764',322,'Retail Sale Id 1502768',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 16:41:56','',''),(2491884,'1','141','764',322,'Retail Sale Id 1502786',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 16:43:18','',''),(2491904,'1','141','764',322,'Retail Sale Id 1502798',1160.00,0.00,0.00,2.00,184.00,'2022-01-11 16:44:40','',''),(2491923,'1','141','764',322,'Retail Sale Id 1502821',7250.00,0.00,0.00,12.50,1150.00,'2022-01-11 16:46:16','',''),(2491941,'1','141','764',322,'Retail Sale Id 1502837',10150.00,0.00,0.00,17.50,1610.00,'2022-01-11 16:47:47','',''),(2491960,'1','141','764',322,'Retail Sale Id 1502855',2320.00,0.00,0.00,4.00,368.00,'2022-01-11 16:49:27','',''),(2491996,'1','141','764',322,'Retail Sale Id 1502885',1200.60,0.00,0.00,2.07,190.44,'2022-01-11 16:51:34','',''),(2492011,'1','141','764',322,'Retail Sale Id 1502900',2900.00,0.00,0.00,5.00,460.00,'2022-01-11 16:52:36','',''),(2492024,'1','141','764',322,'Retail Sale Id 1502914',7250.00,0.00,0.00,12.50,1150.00,'2022-01-11 16:53:48','',''),(2492041,'1','141','764',322,'Retail Sale Id 1502927',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 16:54:47','',''),(2492049,'1','141','764',322,'Retail Sale Id 1502936',580.00,0.00,0.00,1.00,92.00,'2022-01-11 16:55:55','',''),(2492079,'1','141','764',322,'Retail Sale Id 1502964',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 16:58:07','',''),(2492113,'1','141','764',322,'Retail Sale Id 1502981',11110.00,0.00,0.00,22.00,374.00,'2022-01-11 16:59:55','',''),(2492148,'1','141','764',322,'Retail Sale Id 1503001',1160.00,0.00,0.00,2.00,184.00,'2022-01-11 17:02:11','',''),(2492170,'1','141','764',322,'Retail Sale Id 1503018',2998.60,0.00,0.00,5.17,475.64,'2022-01-11 17:03:30','',''),(2492205,'1','141','764',322,'Retail Sale Id 1503052',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 17:05:48','',''),(2492226,'1','141','764',322,'Retail Sale Id 1503071',25250.00,0.00,0.00,50.00,850.00,'2022-01-11 17:07:16','',''),(2492257,'1','141','764',322,'Retail Sale Id 1503098',5800.00,0.00,0.00,10.00,920.00,'2022-01-11 17:09:29','',''),(2492284,'1','141','764',322,'Retail Sale Id 1503128',2610.00,0.00,0.00,4.50,414.00,'2022-01-11 17:11:13','',''),(2492314,'1','141','764',322,'Retail Sale Id 1503157',2900.00,0.00,0.00,5.00,460.00,'2022-01-11 17:13:21','',''),(2492351,'1','141','764',322,'Retail Sale Id 1503186',8502.80,0.00,0.00,14.66,1348.72,'2022-01-11 17:15:31','',''),(2492378,'1','141','764',322,'Retail Sale Id 1503215',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 17:17:59','',''),(2492387,'1','141','764',322,'Retail Sale Id 1503224',6312.50,0.00,0.00,12.50,212.50,'2022-01-11 17:19:08','',''),(2492402,'1','141','764',322,'Retail Sale Id 1503237',7250.00,0.00,0.00,12.50,1150.00,'2022-01-11 17:20:25','',''),(2492416,'1','141','764',322,'Retail Sale Id 1503253',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 17:21:22','',''),(2492432,'1','141','764',322,'Retail Sale Id 1503269',3480.00,0.00,0.00,6.00,552.00,'2022-01-11 17:22:37','',''),(2492449,'1','141','764',322,'Retail Sale Id 1503283',1740.00,0.00,0.00,3.00,276.00,'2022-01-11 17:23:52','',''),(2492469,'1','141','764',322,'Retail Sale Id 1503307',3480.00,0.00,0.00,6.00,552.00,'2022-01-11 17:25:25','',''),(2492818,'1','141','764',322,'Retail Sale Id 1503663',69185.00,0.00,0.00,137.00,2329.00,'2022-01-11 17:55:15','',''),(2493173,'1','141','764',322,'Retail Sale Id 1503956',306535.00,0.00,0.00,607.00,10319.00,'2022-01-11 18:37:33','',''),(2493199,'1','141','764',322,'Retail Sale Id 1503980',29542.50,0.00,0.00,58.50,994.50,'2022-01-11 18:41:52','',''),(2493234,'1','141','764',322,'Retail Sale Id 1504014',679073.50,0.00,0.00,1344.70,22859.90,'2022-01-11 18:50:05','',''),(2494514,'1','141','764',322,'Retail Sale Id 1504700',9106.00,0.00,0.00,15.70,1444.40,'2022-01-12 08:23:14','',''),(2494549,'1','141','764',322,'Retail Sale Id 1504743',25250.00,0.00,0.00,50.00,850.00,'2022-01-12 08:27:43','',''),(2494575,'1','141','764',322,'Retail Sale Id 1504770',1740.00,0.00,0.00,3.00,276.00,'2022-01-12 08:30:19','',''),(2494595,'1','141','764',322,'Retail Sale Id 1504791',2900.00,0.00,0.00,5.00,460.00,'2022-01-12 08:32:05','',''),(2494629,'1','141','764',322,'Retail Sale Id 1504812',7250.00,0.00,0.00,12.50,1150.00,'2022-01-12 08:33:31','',''),(2494666,'1','141','764',322,'Retail Sale Id 1504843',123725.00,0.00,0.00,245.00,4165.00,'2022-01-12 08:36:17','',''),(2494695,'1','141','764',322,'Retail Sale Id 1504860',151500.00,0.00,0.00,300.00,5100.00,'2022-01-12 08:38:31','',''),(2494781,'1','141','764',322,'Retail Sale Id 1504925',7250.00,0.00,0.00,12.50,1150.00,'2022-01-12 08:44:17','',''),(2494796,'1','141','764',322,'Retail Sale Id 1504939',27775.00,0.00,0.00,55.00,935.00,'2022-01-12 08:45:53','',''),(2494831,'1','141','764',322,'Retail Sale Id 1504967',12470.00,0.00,0.00,21.50,1978.00,'2022-01-12 08:49:21','',''),(2494862,'1','141','764',322,'Retail Sale Id 1505005',3480.00,0.00,0.00,6.00,552.00,'2022-01-12 08:52:19','',''),(2494927,'1','141','764',322,'Retail Sale Id 1505065',1160.00,0.00,0.00,2.00,184.00,'2022-01-12 08:57:45','',''),(2494949,'1','141','764',322,'Retail Sale Id 1505085',93425.00,0.00,0.00,185.00,3145.00,'2022-01-12 09:00:19','',''),(2495025,'1','141','764',322,'Retail Sale Id 1505140',50500.00,0.00,0.00,100.00,1700.00,'2022-01-12 09:05:16','',''),(2495061,'1','141','764',322,'Retail Sale Id 1505163',37875.00,0.00,0.00,75.00,1275.00,'2022-01-12 09:07:45','',''),(2495106,'1','141','764',322,'Retail Sale Id 1505180',7250.00,0.00,0.00,12.50,1150.00,'2022-01-12 09:10:40','',''),(2495120,'1','141','764',322,'Retail Sale Id 1505197',60600.00,0.00,0.00,120.00,2040.00,'2022-01-12 09:12:05','',''),(2495171,'1','141','764',322,'Retail Sale Id 1505234',3480.00,0.00,0.00,6.00,552.00,'2022-01-12 09:15:22','',''),(2495187,'1','141','764',322,'Retail Sale Id 1505254',1740.00,0.00,0.00,3.00,276.00,'2022-01-12 09:16:39','',''),(2495210,'1','141','764',322,'Retail Sale Id 1505275',507525.00,0.00,0.00,1005.00,17085.00,'2022-01-12 09:18:56','',''),(2495232,'1','141','764',322,'Retail Sale Id 1505297',1972.00,0.00,0.00,3.40,312.80,'2022-01-12 09:21:01','',''),(2495246,'1','141','764',322,'Retail Sale Id 1505308',1740.00,0.00,0.00,3.00,276.00,'2022-01-12 09:22:33','',''),(2495264,'1','141','764',322,'Retail Sale Id 1505320',25250.00,0.00,0.00,50.00,850.00,'2022-01-12 09:24:20','',''),(2495278,'1','141','764',322,'Retail Sale Id 1505337',74740.00,0.00,0.00,148.00,2516.00,'2022-01-12 09:26:31','',''),(2495305,'1','141','764',322,'Retail Sale Id 1505370',65650.00,0.00,0.00,130.00,2210.00,'2022-01-12 09:29:03','',''),(2495344,'1','141','764',322,'Retail Sale Id 1505419',7250.00,0.00,0.00,12.50,1150.00,'2022-01-12 09:32:48','',''),(2495379,'1','141','764',322,'Retail Sale Id 1505450',2900.00,0.00,0.00,5.00,460.00,'2022-01-12 09:35:22','',''),(2495395,'1','141','764',322,'Retail Sale Id 1505466',1972.00,0.00,0.00,3.40,312.80,'2022-01-12 09:36:47','',''),(2495429,'1','141','764',322,'Retail Sale Id 1505483',1972.00,0.00,0.00,3.40,312.80,'2022-01-12 09:38:15','',''),(2495450,'1','141','764',322,'Retail Sale Id 1505503',30300.00,0.00,0.00,60.00,1020.00,'2022-01-12 09:40:05','',''),(2495496,'1','141','764',322,'Retail Sale Id 1505544',1740.00,0.00,0.00,3.00,276.00,'2022-01-12 09:43:24','',''),(2495561,'1','141','764',322,'Retail Sale Id 1505597',1972.00,0.00,0.00,3.40,312.80,'2022-01-12 09:48:36','',''),(2495610,'1','141','764',322,'Retail Sale Id 1505626',1740.00,0.00,0.00,3.00,276.00,'2022-01-12 09:51:45','',''),(2495797,'1','141','764',322,'Retail Sale Id 1505765',35350.00,0.00,0.00,70.00,1190.00,'2022-01-12 10:04:55','',''),(2495832,'1','141','764',322,'Retail Sale Id 1505792',12625.00,0.00,0.00,25.00,425.00,'2022-01-12 10:07:15','',''),(2495869,'1','141','764',322,'Retail Sale Id 1505834',237350.00,0.00,0.00,470.00,7990.00,'2022-01-12 10:10:39','',''),(2495895,'1','141','764',322,'Retail Sale Id 1505867',88375.00,0.00,0.00,175.00,2975.00,'2022-01-12 10:13:26','',''),(2495947,'1','141','764',322,'Retail Sale Id 1505918',12372.50,0.00,0.00,24.50,416.50,'2022-01-12 10:17:29','',''),(2495971,'1','141','764',322,'Retail Sale Id 1505969',90900.00,0.00,0.00,180.00,3060.00,'2022-01-12 10:19:55','',''),(2495987,'1','141','764',322,'Retail Sale Id 1505985',1740.00,0.00,0.00,3.00,276.00,'2022-01-12 10:21:27','',''),(2496005,'1','141','764',322,'Retail Sale Id 1506010',11867.50,0.00,0.00,23.50,399.50,'2022-01-12 10:23:20','',''),(2496032,'1','141','764',322,'Retail Sale Id 1506039',3480.00,0.00,0.00,6.00,552.00,'2022-01-12 10:26:12','',''),(2496060,'1','141','764',322,'Retail Sale Id 1506061',22725.00,0.00,0.00,45.00,765.00,'2022-01-12 10:27:53','',''),(2496089,'1','141','764',322,'Retail Sale Id 1506089',2900.00,0.00,0.00,5.00,460.00,'2022-01-12 10:30:50','',''),(2496100,'1','141','764',322,'Retail Sale Id 1506101',25250.00,0.00,0.00,50.00,850.00,'2022-01-12 10:32:20','',''),(2496126,'1','141','764',322,'Retail Sale Id 1506132',1160.00,0.00,0.00,2.00,184.00,'2022-01-12 10:34:55','',''),(2496147,'1','141','764',322,'Retail Sale Id 1506162',1450.00,0.00,0.00,2.50,230.00,'2022-01-12 10:37:00','',''),(2496157,'1','141','764',322,'Retail Sale Id 1506178',1972.00,0.00,0.00,3.40,312.80,'2022-01-12 10:38:28','',''),(2496180,'1','141','764',322,'Retail Sale Id 1506202',2958.00,0.00,0.00,5.10,469.20,'2022-01-12 10:41:37','',''),(2496200,'1','141','764',322,'Retail Sale Id 1506223',90900.00,0.00,0.00,180.00,3060.00,'2022-01-12 10:43:47','',''),(2496218,'1','141','764',322,'Retail Sale Id 1506242',56560.00,0.00,0.00,112.00,1904.00,'2022-01-12 10:45:21','',''),(2496254,'1','141','764',322,'Retail Sale Id 1506290',21750.00,0.00,0.00,37.50,3450.00,'2022-01-12 10:48:38','',''),(2496269,'1','141','764',322,'Retail Sale Id 1506305',122715.00,0.00,0.00,243.00,4131.00,'2022-01-12 10:50:16','',''),(2496293,'1','141','764',322,'Retail Sale Id 1506332',100495.00,0.00,0.00,199.00,3383.00,'2022-01-12 10:53:14','',''),(2496317,'1','141','764',322,'Retail Sale Id 1506359',7250.00,0.00,0.00,12.50,1150.00,'2022-01-12 10:56:05','',''),(2496346,'1','141','764',322,'Retail Sale Id 1506374',1972.00,0.00,0.00,3.40,312.80,'2022-01-12 10:58:03','',''),(2496357,'1','141','764',322,'Retail Sale Id 1506397',40400.00,0.00,0.00,80.00,1360.00,'2022-01-12 10:59:27','',''),(2496408,'1','141','764',322,'Retail Sale Id 1506427',50500.00,0.00,0.00,100.00,1700.00,'2022-01-12 11:02:04','',''),(2496435,'1','141','764',322,'Retail Sale Id 1506456',4640.00,0.00,0.00,8.00,736.00,'2022-01-12 11:05:22','',''),(2496454,'1','141','764',322,'Retail Sale Id 1506498',2900.00,0.00,0.00,5.00,460.00,'2022-01-12 11:07:28','',''),(2496468,'1','141','764',322,'Retail Sale Id 1506526',1972.00,0.00,0.00,3.40,312.80,'2022-01-12 11:09:57','',''),(2496486,'1','141','764',322,'Retail Sale Id 1506541',7250.00,0.00,0.00,12.50,1150.00,'2022-01-12 11:11:20','',''),(2496497,'1','141','764',322,'Retail Sale Id 1506553',75750.00,0.00,0.00,150.00,2550.00,'2022-01-12 11:12:13','',''),(2496561,'1','141','764',322,'Retail Sale Id 1506620',1450.00,0.00,0.00,2.50,230.00,'2022-01-12 11:18:13','',''),(2496581,'1','141','764',322,'Retail Sale Id 1506643',1160.00,0.00,0.00,2.00,184.00,'2022-01-12 11:21:24','',''),(2496599,'1','141','764',322,'Retail Sale Id 1506663',30300.00,0.00,0.00,60.00,1020.00,'2022-01-12 11:23:26','',''),(2496615,'1','141','764',322,'Retail Sale Id 1506679',7250.00,0.00,0.00,12.50,1150.00,'2022-01-12 11:25:33','',''),(2496629,'1','141','764',322,'Retail Sale Id 1506690',1160.00,0.00,0.00,2.00,184.00,'2022-01-12 11:27:03','',''),(2496639,'1','141','764',322,'Retail Sale Id 1506701',7250.00,0.00,0.00,12.50,1150.00,'2022-01-12 11:28:41','',''),(2496694,'1','141','764',322,'Retail Sale Id 1506747',870.00,0.00,0.00,1.50,138.00,'2022-01-12 11:34:59','',''),(2496765,'1','141','764',322,'Retail Sale Id 1506788',3480.00,0.00,0.00,6.00,552.00,'2022-01-12 11:39:23','',''),(2496825,'1','141','764',322,'Retail Sale Id 1506803',1740.00,0.00,0.00,3.00,276.00,'2022-01-12 11:41:15','',''),(2496882,'1','141','764',322,'Retail Sale Id 1506836',3480.00,0.00,0.00,6.00,552.00,'2022-01-12 11:45:15','',''),(2496901,'1','141','764',322,'Retail Sale Id 1506855',111100.00,0.00,0.00,220.00,3740.00,'2022-01-12 11:47:05','',''),(2496930,'1','141','764',322,'Retail Sale Id 1506883',64892.50,0.00,0.00,128.50,2184.50,'2022-01-12 11:51:25','',''),(2496978,'1','141','764',322,'Retail Sale Id 1506942',2900.00,0.00,0.00,5.00,460.00,'2022-01-12 11:57:32','',''),(2496993,'1','141','764',322,'Retail Sale Id 1506956',1450.00,0.00,0.00,2.50,230.00,'2022-01-12 11:59:17','',''),(2497009,'1','141','764',322,'Retail Sale Id 1506970',63220.00,0.00,0.00,109.00,10028.00,'2022-01-12 12:00:42','',''),(2497015,'1','141','764',322,'Return of Retail Sale Id 1506970',0.00,63220.00,109.00,0.00,-10028.00,'2022-01-12 12:01:37','',''),(2497046,'1','141','764',322,'Retail Sale Id 1506993',55045.00,0.00,0.00,109.00,1853.00,'2022-01-12 12:05:27','',''),(2497059,'1','141','764',322,'Retail Sale Id 1507032',5220.00,0.00,0.00,9.00,828.00,'2022-01-12 12:06:39','',''),(2497090,'1','141','764',322,'Retail Sale Id 1507068',1740.00,0.00,0.00,3.00,276.00,'2022-01-12 12:11:05','',''),(2497132,'1','141','764',322,'Retail Sale Id 1507098',9090.00,0.00,0.00,18.00,306.00,'2022-01-12 12:15:28','',''),(2497157,'1','141','764',322,'Retail Sale Id 1507126',5974.00,0.00,0.00,10.30,947.60,'2022-01-12 12:17:39','',''),(2497192,'1','141','764',322,'Retail Sale Id 1507170',2900.00,0.00,0.00,5.00,460.00,'2022-01-12 12:21:30','',''),(2497350,'1','141','764',322,'Retail Sale Id 1507330',2900.00,0.00,0.00,5.00,460.00,'2022-01-12 12:41:49','',''),(2497366,'1','141','764',322,'Retail Sale Id 1507344',7250.00,0.00,0.00,12.50,1150.00,'2022-01-12 12:43:16','',''),(2497409,'1','141','764',322,'Retail Sale Id 1507398',580.00,0.00,0.00,1.00,92.00,'2022-01-12 12:48:52','',''),(2497432,'1','141','764',322,'Retail Sale Id 1507427',1160.00,0.00,0.00,2.00,184.00,'2022-01-12 12:51:05','',''),(2497451,'1','141','764',322,'Retail Sale Id 1507445',126250.00,0.00,0.00,250.00,4250.00,'2022-01-12 12:53:31','',''),(2497486,'1','141','764',322,'Retail Sale Id 1507480',1740.00,0.00,0.00,3.00,276.00,'2022-01-12 12:57:50','',''),(2497498,'1','141','764',322,'Retail Sale Id 1507492',28532.50,0.00,0.00,56.50,960.50,'2022-01-12 12:59:41','',''),(2497518,'1','141','764',322,'Retail Sale Id 1507504',1160.00,0.00,0.00,2.00,184.00,'2022-01-12 13:01:16','',''),(2497553,'1','141','764',322,'Retail Sale Id 1507532',37370.00,0.00,0.00,74.00,1258.00,'2022-01-12 13:05:30','',''),(2497556,'1','141','764',322,'Retail Sale Id 1507536',1160.00,0.00,0.00,2.00,184.00,'2022-01-12 13:06:27','',''),(2497590,'1','141','764',322,'Retail Sale Id 1507567',2320.00,0.00,0.00,4.00,368.00,'2022-01-12 13:10:32','',''),(2497604,'1','141','764',322,'Retail Sale Id 1507579',2320.00,0.00,0.00,4.00,368.00,'2022-01-12 13:12:16','',''),(2497617,'1','141','764',322,'Retail Sale Id 1507593',7250.00,0.00,0.00,12.50,1150.00,'2022-01-12 13:14:02','',''),(2497642,'1','141','764',322,'Retail Sale Id 1507621',3030.00,0.00,0.00,6.00,102.00,'2022-01-12 13:16:42','',''),(2497655,'1','141','764',322,'Retail Sale Id 1507634',25250.00,0.00,0.00,50.00,850.00,'2022-01-12 13:18:28','',''),(2497661,'1','141','764',322,'Retail Sale Id 1507640',25250.00,0.00,0.00,50.00,850.00,'2022-01-12 13:19:22','',''),(2497687,'1','141','764',322,'Retail Sale Id 1507663',35602.50,0.00,0.00,70.50,1198.50,'2022-01-12 13:22:31','',''),(2497713,'1','141','764',322,'Retail Sale Id 1507694',7250.00,0.00,0.00,12.50,1150.00,'2022-01-12 13:24:53','',''),(2497718,'1','141','764',322,'Retail Sale Id 1507697',580.00,0.00,0.00,1.00,92.00,'2022-01-12 13:25:45','',''),(2497736,'1','141','764',322,'Retail Sale Id 1507717',138875.00,0.00,0.00,275.00,4675.00,'2022-01-12 13:27:58','',''),(2497754,'1','141','764',322,'Retail Sale Id 1507733',986.00,0.00,0.00,1.70,156.40,'2022-01-12 13:29:42','',''),(2497773,'1','141','764',322,'Retail Sale Id 1507752',1160.00,0.00,0.00,2.00,184.00,'2022-01-12 13:31:54','',''),(2497795,'1','141','764',322,'Retail Sale Id 1507770',25250.00,0.00,0.00,50.00,850.00,'2022-01-12 13:34:42','',''),(2497835,'1','141','764',322,'Retail Sale Id 1507802',78022.50,0.00,0.00,154.50,2626.50,'2022-01-12 13:39:15','',''),(2497857,'1','141','764',322,'Retail Sale Id 1507830',2998.60,0.00,0.00,5.17,475.64,'2022-01-12 13:43:08','',''),(2497869,'1','141','764',322,'Retail Sale Id 1507841',1450.00,0.00,0.00,2.50,230.00,'2022-01-12 13:45:15','',''),(2497879,'1','141','764',322,'Retail Sale Id 1507852',1160.00,0.00,0.00,2.00,184.00,'2022-01-12 13:46:52','',''),(2497914,'1','141','764',322,'Retail Sale Id 1507881',1160.00,0.00,0.00,2.00,184.00,'2022-01-12 13:51:46','',''),(2497924,'1','141','764',322,'Retail Sale Id 1507890',3480.00,0.00,0.00,6.00,552.00,'2022-01-12 13:53:17','',''),(2497951,'1','141','764',322,'Retail Sale Id 1507920',57065.00,0.00,0.00,113.00,1921.00,'2022-01-12 13:56:39','',''),(2497979,'1','141','764',322,'Retail Sale Id 1507950',6960.00,0.00,0.00,12.00,1104.00,'2022-01-12 13:59:25','',''),(2497985,'1','141','764',322,'Retail Sale Id 1507959',701.80,0.00,0.00,1.21,111.32,'2022-01-12 14:00:36','',''),(2498008,'1','141','764',322,'Retail Sale Id 1507971',8700.00,0.00,0.00,15.00,1380.00,'2022-01-12 14:01:43','',''),(2498033,'1','141','764',322,'Retail Sale Id 1507993',35350.00,0.00,0.00,70.00,1190.00,'2022-01-12 14:03:45','',''),(2498059,'1','141','764',322,'Retail Sale Id 1508033',1160.00,0.00,0.00,2.00,184.00,'2022-01-12 14:05:54','',''),(2498194,'1','141','764',322,'Retail Sale Id 1508150',1740.00,0.00,0.00,3.00,276.00,'2022-01-12 14:18:27','',''),(2498202,'1','141','764',322,'Retail Sale Id 1508160',25250.00,0.00,0.00,50.00,850.00,'2022-01-12 14:19:39','',''),(2498221,'1','141','764',322,'Retail Sale Id 1508175',5800.00,0.00,0.00,10.00,920.00,'2022-01-12 14:21:58','',''),(2498240,'1','141','764',322,'Retail Sale Id 1508200',30300.00,0.00,0.00,60.00,1020.00,'2022-01-12 14:23:02','',''),(2498260,'1','141','764',322,'Retail Sale Id 1508221',1502.20,0.00,0.00,2.59,238.28,'2022-01-12 14:25:23','',''),(2498297,'1','141','764',322,'Retail Sale Id 1508239',1160.00,0.00,0.00,2.00,184.00,'2022-01-12 14:27:45','',''),(2498350,'1','141','764',322,'Retail Sale Id 1508294',3480.00,0.00,0.00,6.00,552.00,'2022-01-12 14:31:09','',''),(2498466,'1','141','764',322,'Retail Sale Id 1508406',5800.00,0.00,0.00,10.00,920.00,'2022-01-12 14:44:42','',''),(2498757,'1','141','764',322,'Retail Sale Id 1508631',2998.60,0.00,0.00,5.17,475.64,'2022-01-12 15:05:41','',''),(2498817,'1','141','764',322,'Retail Sale Id 1508660',75750.00,0.00,0.00,150.00,2550.00,'2022-01-12 15:07:31','',''),(2498857,'1','141','764',322,'Retail Sale Id 1508682',580.00,0.00,0.00,1.00,92.00,'2022-01-12 15:10:09','',''),(2498870,'1','141','764',322,'Retail Sale Id 1508701',6312.50,0.00,0.00,12.50,212.50,'2022-01-12 15:11:33','',''),(2498935,'1','141','764',322,'Retail Sale Id 1508761',62115.00,0.00,0.00,123.00,2091.00,'2022-01-12 15:17:39','',''),(2498985,'1','141','764',322,'Retail Sale Id 1508810',1200.60,0.00,0.00,2.07,190.44,'2022-01-12 15:22:53','',''),(2499035,'1','141','764',322,'Retail Sale Id 1508834',2320.00,0.00,0.00,4.00,368.00,'2022-01-12 15:25:35','',''),(2499127,'1','141','764',322,'Retail Sale Id 1508921',997.60,0.00,0.00,1.72,158.24,'2022-01-12 15:34:39','',''),(2499191,'1','141','764',322,'Retail Sale Id 1508972',2900.00,0.00,0.00,5.00,460.00,'2022-01-12 15:40:51','',''),(2499225,'1','141','764',322,'Retail Sale Id 1509006',11867.50,0.00,0.00,23.50,399.50,'2022-01-12 15:45:14','',''),(2499265,'1','141','764',322,'Retail Sale Id 1509048',133320.00,0.00,0.00,264.00,4488.00,'2022-01-12 15:49:18','',''),(2499293,'1','141','764',322,'Retail Sale Id 1509074',1740.00,0.00,0.00,3.00,276.00,'2022-01-12 15:51:32','',''),(2499323,'1','141','764',322,'Retail Sale Id 1509107',35350.00,0.00,0.00,70.00,1190.00,'2022-01-12 15:56:04','',''),(2499346,'1','141','764',322,'Retail Sale Id 1509132',7250.00,0.00,0.00,12.50,1150.00,'2022-01-12 15:59:41','',''),(2499368,'1','141','764',322,'Retail Sale Id 1509147',1740.00,0.00,0.00,3.00,276.00,'2022-01-12 16:02:02','',''),(2499375,'1','141','764',322,'Retail Sale Id 1509158',56812.50,0.00,0.00,112.50,1912.50,'2022-01-12 16:03:37','',''),(2499393,'1','141','764',322,'Retail Sale Id 1509176',24240.00,0.00,0.00,48.00,816.00,'2022-01-12 16:05:56','',''),(2499414,'1','141','764',322,'Retail Sale Id 1509199',7827.50,0.00,0.00,15.50,263.50,'2022-01-12 16:08:48','',''),(2499429,'1','141','764',322,'Retail Sale Id 1509216',6312.50,0.00,0.00,12.50,212.50,'2022-01-12 16:10:11','',''),(2499440,'1','141','764',322,'Retail Sale Id 1509227',4060.00,0.00,0.00,7.00,644.00,'2022-01-12 16:11:40','',''),(2499458,'1','141','764',322,'Retail Sale Id 1509245',75750.00,0.00,0.00,150.00,2550.00,'2022-01-12 16:13:36','',''),(2499468,'1','141','764',322,'Retail Sale Id 1509254',1740.00,0.00,0.00,3.00,276.00,'2022-01-12 16:15:03','',''),(2499478,'1','141','764',322,'Retail Sale Id 1509269',580.00,0.00,0.00,1.00,92.00,'2022-01-12 16:16:41','',''),(2499489,'1','141','764',322,'Retail Sale Id 1509279',2001.00,0.00,0.00,3.45,317.40,'2022-01-12 16:17:42','',''),(2499504,'1','141','764',322,'Retail Sale Id 1509297',2998.60,0.00,0.00,5.17,475.64,'2022-01-12 16:19:11','',''),(2499537,'1','141','764',322,'Retail Sale Id 1509315',36360.00,0.00,0.00,72.00,1224.00,'2022-01-12 16:21:05','',''),(2499555,'1','141','764',322,'Retail Sale Id 1509335',2499.80,0.00,0.00,4.31,396.52,'2022-01-12 16:23:01','',''),(2499566,'1','141','764',322,'Retail Sale Id 1509350',1160.00,0.00,0.00,2.00,184.00,'2022-01-12 16:23:54','',''),(2499581,'1','141','764',322,'Retail Sale Id 1509360',2900.00,0.00,0.00,5.00,460.00,'2022-01-12 16:25:05','',''),(2499600,'1','141','764',322,'Retail Sale Id 1509374',2998.60,0.00,0.00,5.17,475.64,'2022-01-12 16:25:54','',''),(2499611,'1','141','764',322,'Retail Sale Id 1509383',1160.00,0.00,0.00,2.00,184.00,'2022-01-12 16:26:45','',''),(2499662,'1','141','764',322,'Retail Sale Id 1509431',1160.00,0.00,0.00,2.00,184.00,'2022-01-12 16:31:52','',''),(2499674,'1','141','764',322,'Retail Sale Id 1509439',50500.00,0.00,0.00,100.00,1700.00,'2022-01-12 16:32:49','',''),(2499692,'1','141','764',322,'Retail Sale Id 1509456',1740.00,0.00,0.00,3.00,276.00,'2022-01-12 16:34:11','',''),(2499703,'1','141','764',322,'Retail Sale Id 1509475',1699.40,0.00,0.00,2.93,269.56,'2022-01-12 16:35:12','',''),(2499718,'1','141','764',322,'Retail Sale Id 1509480',25250.00,0.00,0.00,50.00,850.00,'2022-01-12 16:36:07','',''),(2499730,'1','141','764',322,'Retail Sale Id 1509492',1450.00,0.00,0.00,2.50,230.00,'2022-01-12 16:37:09','',''),(2499740,'1','141','764',322,'Retail Sale Id 1509502',2001.00,0.00,0.00,3.45,317.40,'2022-01-12 16:38:03','',''),(2499750,'1','141','764',322,'Retail Sale Id 1509512',2001.00,0.00,0.00,3.45,317.40,'2022-01-12 16:39:01','',''),(2499763,'1','141','764',322,'Retail Sale Id 1509528',2001.00,0.00,0.00,3.45,317.40,'2022-01-12 16:40:21','',''),(2499773,'1','141','764',322,'Retail Sale Id 1509538',5800.00,0.00,0.00,10.00,920.00,'2022-01-12 16:41:28','',''),(2499790,'1','141','764',322,'Retail Sale Id 1509551',2900.00,0.00,0.00,5.00,460.00,'2022-01-12 16:42:30','',''),(2499806,'1','141','764',322,'Retail Sale Id 1509563',4002.00,0.00,0.00,6.90,634.80,'2022-01-12 16:43:54','',''),(2499820,'1','141','764',322,'Retail Sale Id 1509583',2900.00,0.00,0.00,5.00,460.00,'2022-01-12 16:45:01','',''),(2499865,'1','141','764',322,'Retail Sale Id 1509616',2198.20,0.00,0.00,3.79,348.68,'2022-01-12 16:48:19','',''),(2499931,'1','141','764',322,'Retail Sale Id 1509664',101000.00,0.00,0.00,200.00,3400.00,'2022-01-12 16:51:51','',''),(2499971,'1','141','764',322,'Retail Sale Id 1509709',2998.60,0.00,0.00,5.17,475.64,'2022-01-12 16:55:40','',''),(2499992,'1','141','764',322,'Retail Sale Id 1509726',1160.00,0.00,0.00,2.00,184.00,'2022-01-12 16:57:10','',''),(2500009,'1','141','764',322,'Retail Sale Id 1509742',144935.00,0.00,0.00,287.00,4879.00,'2022-01-12 16:58:39','',''),(2500042,'1','141','764',322,'Retail Sale Id 1509773',1740.00,0.00,0.00,3.00,276.00,'2022-01-12 17:02:02','',''),(2500060,'1','141','764',322,'Retail Sale Id 1509791',1740.00,0.00,0.00,3.00,276.00,'2022-01-12 17:03:16','',''),(2500081,'1','141','764',322,'Retail Sale Id 1509807',1740.00,0.00,0.00,3.00,276.00,'2022-01-12 17:05:03','',''),(2500145,'1','141','764',322,'Retail Sale Id 1509880',2900.00,0.00,0.00,5.00,460.00,'2022-01-12 17:11:55','',''),(2500159,'1','141','764',322,'Retail Sale Id 1509897',1160.00,0.00,0.00,2.00,184.00,'2022-01-12 17:13:23','',''),(2500174,'1','141','764',322,'Retail Sale Id 1509910',1740.00,0.00,0.00,3.00,276.00,'2022-01-12 17:14:29','',''),(2500182,'1','141','764',322,'Retail Sale Id 1509917',1160.00,0.00,0.00,2.00,184.00,'2022-01-12 17:15:41','',''),(2500204,'1','141','764',322,'Retail Sale Id 1509929',2900.00,0.00,0.00,5.00,460.00,'2022-01-12 17:16:33','',''),(2500332,'1','141','764',322,'Retail Sale Id 1510050',24240.00,0.00,0.00,48.00,816.00,'2022-01-12 17:29:49','',''),(2500410,'1','141','764',322,'Retail Sale Id 1510114',3480.00,0.00,0.00,6.00,552.00,'2022-01-12 17:35:36','',''),(2500427,'1','141','764',322,'Retail Sale Id 1510129',2001.00,0.00,0.00,3.45,317.40,'2022-01-12 17:36:46','',''),(2500569,'1','141','764',322,'Retail Sale Id 1510272',328856.00,0.00,0.00,651.20,11070.40,'2022-01-12 17:50:35','',''),(2500603,'1','141','764',322,'Return of Retail Sale Id 1509538',0.00,5800.00,10.00,0.00,-920.00,'2022-01-12 17:53:49','',''),(2500624,'1','141','764',322,'Return of Retail Sale Id 1509132',0.00,7250.00,12.50,0.00,-1150.00,'2022-01-12 17:55:18','',''),(2500648,'1','141','764',322,'Return of Retail Sale Id 1505419',0.00,7250.00,12.50,0.00,-1150.00,'2022-01-12 17:57:36','',''),(2500676,'1','141','764',322,'Return of Retail Sale Id 1509929',0.00,2900.00,5.00,0.00,-460.00,'2022-01-12 18:00:16','',''),(2500687,'1','141','764',322,'Return of Retail Sale Id 1509917',0.00,1160.00,2.00,0.00,-184.00,'2022-01-12 18:00:54','',''),(2500920,'1','141','764',322,'Return of Retail Sale Id 1506553',0.00,75750.00,150.00,0.00,-2550.00,'2022-01-12 18:25:36','',''),(2500943,'1','141','764',322,'Return of Retail Sale Id 1505834',0.00,237350.00,470.00,0.00,-7990.00,'2022-01-12 18:29:30','',''),(2500965,'1','141','764',322,'Return of Retail Sale Id 1510114',0.00,3480.00,6.00,0.00,-552.00,'2022-01-12 18:33:12','',''),(2500971,'1','141','764',322,'Return of Retail Sale Id 1510129',0.00,2001.00,3.45,0.00,-317.40,'2022-01-12 18:34:14','',''),(2502699,'1','141','764',322,'Retail Sale Id 1511914',25250.00,0.00,0.00,50.00,850.00,'2022-01-13 09:09:20','',''),(2502727,'1','141','764',322,'Retail Sale Id 1511934',1160.00,0.00,0.00,2.00,184.00,'2022-01-13 09:11:12','',''),(2502838,'1','141','764',322,'Retail Sale Id 1511982',1160.00,0.00,0.00,2.00,184.00,'2022-01-13 09:16:58','',''),(2502897,'1','141','764',322,'Retail Sale Id 1512021',28280.00,0.00,0.00,56.00,952.00,'2022-01-13 09:21:13','',''),(2502936,'1','141','764',322,'Retail Sale Id 1512054',614837.50,0.00,0.00,1217.50,20697.50,'2022-01-13 09:25:24','',''),(2502979,'1','141','764',322,'Retail Sale Id 1512078',31310.00,0.00,0.00,62.00,1054.00,'2022-01-13 09:29:09','',''),(2503000,'1','141','764',322,'Retail Sale Id 1512096',39895.00,0.00,0.00,79.00,1343.00,'2022-01-13 09:31:22','',''),(2503033,'1','141','764',322,'Retail Sale Id 1512121',50500.00,0.00,0.00,100.00,1700.00,'2022-01-13 09:35:19','',''),(2503045,'1','141','764',322,'Retail Sale Id 1512133',30300.00,0.00,0.00,60.00,1020.00,'2022-01-13 09:37:04','',''),(2503054,'1','141','764',322,'Retail Sale Id 1512142',7250.00,0.00,0.00,12.50,1150.00,'2022-01-13 09:38:13','',''),(2503090,'1','141','764',322,'Retail Sale Id 1512171',7250.00,0.00,0.00,12.50,1150.00,'2022-01-13 09:41:51','',''),(2503111,'1','141','764',322,'Retail Sale Id 1512190',580.00,0.00,0.00,1.00,92.00,'2022-01-13 09:44:54','',''),(2503190,'1','141','764',322,'Retail Sale Id 1512266',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 09:55:12','',''),(2503200,'1','141','764',322,'Retail Sale Id 1512277',1160.00,0.00,0.00,2.00,184.00,'2022-01-13 09:56:16','',''),(2503224,'1','141','764',322,'Retail Sale Id 1512284',580.00,0.00,0.00,1.00,92.00,'2022-01-13 09:57:17','',''),(2503256,'1','141','764',322,'Retail Sale Id 1512297',64640.00,0.00,0.00,128.00,2176.00,'2022-01-13 09:59:43','',''),(2503274,'1','141','764',322,'Retail Sale Id 1512314',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 10:01:30','',''),(2503339,'1','141','764',322,'Retail Sale Id 1512347',104787.50,0.00,0.00,207.50,3527.50,'2022-01-13 10:06:08','',''),(2503359,'1','141','764',322,'Retail Sale Id 1512366',26765.00,0.00,0.00,53.00,901.00,'2022-01-13 10:08:38','',''),(2503485,'1','141','764',322,'Retail Sale Id 1512406',4999.60,0.00,0.00,8.62,793.04,'2022-01-13 10:14:39','',''),(2503495,'1','141','764',322,'Retail Sale Id 1512425',18937.50,0.00,0.00,37.50,637.50,'2022-01-13 10:15:38','',''),(2503528,'1','141','764',322,'Retail Sale Id 1512453',88122.50,0.00,0.00,174.50,2966.50,'2022-01-13 10:18:38','',''),(2503559,'1','141','764',322,'Retail Sale Id 1512488',2900.00,0.00,0.00,5.00,460.00,'2022-01-13 10:21:50','',''),(2503601,'1','141','764',322,'Retail Sale Id 1512529',1160.00,0.00,0.00,2.00,184.00,'2022-01-13 10:25:47','',''),(2503623,'1','141','764',322,'Retail Sale Id 1512547',1502.20,0.00,0.00,2.59,238.28,'2022-01-13 10:27:38','',''),(2503680,'1','141','764',322,'Retail Sale Id 1512593',2401.20,0.00,0.00,4.14,380.88,'2022-01-13 10:32:13','',''),(2503700,'1','141','764',322,'Retail Sale Id 1512613',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 10:33:52','',''),(2503723,'1','141','764',322,'Retail Sale Id 1512639',138875.00,0.00,0.00,275.00,4675.00,'2022-01-13 10:35:37','',''),(2503784,'1','141','764',322,'Retail Sale Id 1512703',40400.00,0.00,0.00,80.00,1360.00,'2022-01-13 10:40:26','',''),(2503819,'1','141','764',322,'Retail Sale Id 1512733',1160.00,0.00,0.00,2.00,184.00,'2022-01-13 10:42:28','',''),(2503831,'1','141','764',322,'Retail Sale Id 1512742',2001.00,0.00,0.00,3.45,317.40,'2022-01-13 10:43:44','',''),(2503861,'1','141','764',322,'Retail Sale Id 1512763',3480.00,0.00,0.00,6.00,552.00,'2022-01-13 10:44:54','',''),(2503896,'1','141','764',322,'Retail Sale Id 1512780',50500.00,0.00,0.00,100.00,1700.00,'2022-01-13 10:46:49','',''),(2503917,'1','141','764',322,'Retail Sale Id 1512813',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 10:48:56','',''),(2503931,'1','141','764',322,'Retail Sale Id 1512833',2001.00,0.00,0.00,3.45,317.40,'2022-01-13 10:50:06','',''),(2503950,'1','141','764',322,'Retail Sale Id 1512851',3480.00,0.00,0.00,6.00,552.00,'2022-01-13 10:51:31','',''),(2503961,'1','141','764',322,'Retail Sale Id 1512860',101000.00,0.00,0.00,200.00,3400.00,'2022-01-13 10:52:53','',''),(2503984,'1','141','764',322,'Retail Sale Id 1512888',2900.00,0.00,0.00,5.00,460.00,'2022-01-13 10:54:58','',''),(2503998,'1','141','764',322,'Retail Sale Id 1512900',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 10:55:51','',''),(2504019,'1','141','764',322,'Retail Sale Id 1512927',1160.00,0.00,0.00,2.00,184.00,'2022-01-13 10:57:56','',''),(2504033,'1','141','764',322,'Retail Sale Id 1512943',9090.00,0.00,0.00,18.00,306.00,'2022-01-13 10:59:44','',''),(2504059,'1','141','764',322,'Retail Sale Id 1512974',2998.60,0.00,0.00,5.17,475.64,'2022-01-13 11:03:13','',''),(2504089,'1','141','764',322,'Retail Sale Id 1513001',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 11:06:09','',''),(2504098,'1','141','764',322,'Retail Sale Id 1513010',580.00,0.00,0.00,1.00,92.00,'2022-01-13 11:07:44','',''),(2504117,'1','141','764',322,'Retail Sale Id 1513029',2900.00,0.00,0.00,5.00,460.00,'2022-01-13 11:09:48','',''),(2504132,'1','141','764',322,'Retail Sale Id 1513047',2900.00,0.00,0.00,5.00,460.00,'2022-01-13 11:11:58','',''),(2504143,'1','141','764',322,'Retail Sale Id 1513055',111100.00,0.00,0.00,220.00,3740.00,'2022-01-13 11:13:04','',''),(2504198,'1','141','764',322,'Retail Sale Id 1513115',50500.00,0.00,0.00,100.00,1700.00,'2022-01-13 11:18:49','',''),(2504212,'1','141','764',322,'Retail Sale Id 1513128',2320.00,0.00,0.00,4.00,368.00,'2022-01-13 11:20:24','',''),(2504225,'1','141','764',322,'Retail Sale Id 1513140',1160.00,0.00,0.00,2.00,184.00,'2022-01-13 11:22:17','',''),(2504252,'1','141','764',322,'Retail Sale Id 1513150',997.60,0.00,0.00,1.72,158.24,'2022-01-13 11:23:45','',''),(2504259,'1','141','764',322,'Retail Sale Id 1513164',119180.00,0.00,0.00,236.00,4012.00,'2022-01-13 11:25:09','',''),(2504429,'1','141','764',322,'Retail Sale Id 1513322',1160.00,0.00,0.00,2.00,184.00,'2022-01-13 11:42:18','',''),(2504474,'1','141','764',322,'Retail Sale Id 1513381',997.60,0.00,0.00,1.72,158.24,'2022-01-13 11:46:58','',''),(2504543,'1','141','764',322,'Retail Sale Id 1513432',25250.00,0.00,0.00,50.00,850.00,'2022-01-13 11:54:24','',''),(2504598,'1','141','764',322,'Retail Sale Id 1513495',126250.00,0.00,0.00,250.00,4250.00,'2022-01-13 12:00:13','',''),(2504659,'1','141','764',322,'Retail Sale Id 1513563',60600.00,0.00,0.00,120.00,2040.00,'2022-01-13 12:06:25','',''),(2504671,'1','141','764',322,'Retail Sale Id 1513574',7575.00,0.00,0.00,15.00,255.00,'2022-01-13 12:07:30','',''),(2504698,'1','141','764',322,'Retail Sale Id 1513608',2998.60,0.00,0.00,5.17,475.64,'2022-01-13 12:10:51','',''),(2504707,'1','141','764',322,'Retail Sale Id 1513614',2499.80,0.00,0.00,4.31,396.52,'2022-01-13 12:11:50','',''),(2504714,'1','141','764',322,'Retail Sale Id 1513623',997.60,0.00,0.00,1.72,158.24,'2022-01-13 12:12:42','',''),(2504724,'1','141','764',322,'Retail Sale Id 1513631',1160.00,0.00,0.00,2.00,184.00,'2022-01-13 12:13:40','',''),(2504737,'1','141','764',322,'Retail Sale Id 1513647',1160.00,0.00,0.00,2.00,184.00,'2022-01-13 12:15:14','',''),(2504751,'1','141','764',322,'Retail Sale Id 1513669',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 12:16:49','',''),(2504760,'1','141','764',322,'Retail Sale Id 1513680',80800.00,0.00,0.00,160.00,2720.00,'2022-01-13 12:17:51','',''),(2504786,'1','141','764',322,'Retail Sale Id 1513706',15150.00,0.00,0.00,30.00,510.00,'2022-01-13 12:21:04','',''),(2504809,'1','141','764',322,'Retail Sale Id 1513729',7250.00,0.00,0.00,12.50,1150.00,'2022-01-13 12:23:37','',''),(2504824,'1','141','764',322,'Retail Sale Id 1513744',997.60,0.00,0.00,1.72,158.24,'2022-01-13 12:25:53','',''),(2504850,'1','141','764',322,'Retail Sale Id 1513762',3300.20,0.00,0.00,5.69,523.48,'2022-01-13 12:27:53','',''),(2504870,'1','141','764',322,'Retail Sale Id 1513781',29290.00,0.00,0.00,58.00,986.00,'2022-01-13 12:30:47','',''),(2504890,'1','141','764',322,'Retail Sale Id 1513798',3480.00,0.00,0.00,6.00,552.00,'2022-01-13 12:32:54','',''),(2504904,'1','141','764',322,'Retail Sale Id 1513818',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 12:34:41','',''),(2504913,'1','141','764',322,'Retail Sale Id 1513827',3480.00,0.00,0.00,6.00,552.00,'2022-01-13 12:35:52','',''),(2504979,'1','141','764',322,'Retail Sale Id 1513892',28785.00,0.00,0.00,57.00,969.00,'2022-01-13 12:44:23','',''),(2504992,'1','141','764',322,'Retail Sale Id 1513909',1450.00,0.00,0.00,2.50,230.00,'2022-01-13 12:46:03','',''),(2504999,'1','141','764',322,'Retail Sale Id 1513915',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 12:47:07','',''),(2505015,'1','141','764',322,'Retail Sale Id 1513933',9090.00,0.00,0.00,18.00,306.00,'2022-01-13 12:49:05','',''),(2505032,'1','141','764',322,'Retail Sale Id 1513947',130500.00,0.00,0.00,225.00,20700.00,'2022-01-13 12:50:45','',''),(2505081,'1','141','764',322,'Return of Retail Sale Id 1513947',0.00,130500.00,225.00,0.00,-20700.00,'2022-01-13 12:55:53','',''),(2505087,'1','141','764',322,'Retail Sale Id 1513998',113625.00,0.00,0.00,225.00,3825.00,'2022-01-13 12:56:41','',''),(2505142,'1','141','764',322,'Retail Sale Id 1514023',4640.00,0.00,0.00,8.00,736.00,'2022-01-13 13:00:06','',''),(2505202,'1','141','764',322,'Retail Sale Id 1514039',580.00,0.00,0.00,1.00,92.00,'2022-01-13 13:02:08','',''),(2505210,'1','141','764',322,'Retail Sale Id 1514046',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 13:03:04','',''),(2505230,'1','141','764',322,'Retail Sale Id 1514064',12625.00,0.00,0.00,25.00,425.00,'2022-01-13 13:05:03','',''),(2505329,'1','141','764',322,'Retail Sale Id 1514169',997.60,0.00,0.00,1.72,158.24,'2022-01-13 13:16:43','',''),(2505340,'1','141','764',322,'Retail Sale Id 1514178',2998.60,0.00,0.00,5.17,475.64,'2022-01-13 13:18:23','',''),(2505346,'1','141','764',322,'Retail Sale Id 1514189',2320.00,0.00,0.00,4.00,368.00,'2022-01-13 13:19:29','',''),(2505360,'1','141','764',322,'Retail Sale Id 1514204',3480.00,0.00,0.00,6.00,552.00,'2022-01-13 13:21:00','',''),(2505381,'1','141','764',322,'Retail Sale Id 1514223',84840.00,0.00,0.00,168.00,2856.00,'2022-01-13 13:23:30','',''),(2505400,'1','141','764',322,'Retail Sale Id 1514242',2900.00,0.00,0.00,5.00,460.00,'2022-01-13 13:25:15','',''),(2505413,'1','141','764',322,'Retail Sale Id 1514259',6312.50,0.00,0.00,12.50,212.50,'2022-01-13 13:27:15','',''),(2505428,'1','141','764',322,'Retail Sale Id 1514277',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 13:29:14','',''),(2505486,'1','141','764',322,'Retail Sale Id 1514337',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 13:36:59','',''),(2505541,'1','141','764',322,'Retail Sale Id 1514372',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 13:43:09','',''),(2505612,'1','141','764',322,'Retail Sale Id 1514418',66660.00,0.00,0.00,132.00,2244.00,'2022-01-13 13:48:34','',''),(2505638,'1','141','764',322,'Retail Sale Id 1514428',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 13:52:47','',''),(2505662,'1','141','764',322,'Retail Sale Id 1514462',7575.00,0.00,0.00,15.00,255.00,'2022-01-13 13:55:15','',''),(2505671,'1','141','764',322,'Retail Sale Id 1514473',7250.00,0.00,0.00,12.50,1150.00,'2022-01-13 13:56:26','',''),(2505688,'1','141','764',322,'Retail Sale Id 1514484',3480.00,0.00,0.00,6.00,552.00,'2022-01-13 13:57:39','',''),(2505698,'1','141','764',322,'Retail Sale Id 1514495',17170.00,0.00,0.00,34.00,578.00,'2022-01-13 13:58:56','',''),(2505719,'1','141','764',322,'Retail Sale Id 1514515',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 14:01:08','',''),(2505738,'1','141','764',322,'Retail Sale Id 1514530',2030.00,0.00,0.00,3.50,322.00,'2022-01-13 14:02:43','',''),(2505750,'1','141','764',322,'Retail Sale Id 1514541',2998.60,0.00,0.00,5.17,475.64,'2022-01-13 14:04:20','',''),(2505813,'1','141','764',322,'Retail Sale Id 1514594',73730.00,0.00,0.00,146.00,2482.00,'2022-01-13 14:10:31','',''),(2505835,'1','141','764',322,'Retail Sale Id 1514604',2998.60,0.00,0.00,5.17,475.64,'2022-01-13 14:12:21','',''),(2505842,'1','141','764',322,'Retail Sale Id 1514612',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 14:13:11','',''),(2505850,'1','141','764',322,'Retail Sale Id 1514619',1502.20,0.00,0.00,2.59,238.28,'2022-01-13 14:15:12','',''),(2505865,'1','141','764',322,'Return of Retail Sale Id 1514619',0.00,1502.20,2.59,0.00,-238.28,'2022-01-13 14:17:46','',''),(2505874,'1','141','764',322,'Retail Sale Id 1514642',1502.20,0.00,0.00,2.59,238.28,'2022-01-13 14:18:56','',''),(2505884,'1','141','764',322,'Retail Sale Id 1514652',7250.00,0.00,0.00,12.50,1150.00,'2022-01-13 14:20:14','',''),(2505974,'1','141','764',322,'Retail Sale Id 1514732',2998.60,0.00,0.00,5.17,475.64,'2022-01-13 14:31:11','',''),(2506017,'1','141','764',322,'Retail Sale Id 1514749',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 14:34:55','',''),(2506036,'1','141','764',322,'Retail Sale Id 1514761',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 14:36:10','',''),(2506149,'1','141','764',322,'Retail Sale Id 1514833',4002.00,0.00,0.00,6.90,634.80,'2022-01-13 14:46:50','',''),(2506171,'1','141','764',322,'Retail Sale Id 1514855',4640.00,0.00,0.00,8.00,736.00,'2022-01-13 14:50:02','',''),(2506194,'1','141','764',322,'Retail Sale Id 1514884',997.60,0.00,0.00,1.72,158.24,'2022-01-13 14:52:50','',''),(2506265,'1','141','764',322,'Retail Sale Id 1514942',997.60,0.00,0.00,1.72,158.24,'2022-01-13 15:00:25','',''),(2506311,'1','141','764',322,'Retail Sale Id 1514982',3480.00,0.00,0.00,6.00,552.00,'2022-01-13 15:04:59','',''),(2506326,'1','141','764',322,'Retail Sale Id 1514994',3480.00,0.00,0.00,6.00,552.00,'2022-01-13 15:06:36','',''),(2506338,'1','141','764',322,'Retail Sale Id 1515008',1160.00,0.00,0.00,2.00,184.00,'2022-01-13 15:08:26','',''),(2506367,'1','141','764',322,'Retail Sale Id 1515036',21967.50,0.00,0.00,43.50,739.50,'2022-01-13 15:12:42','',''),(2506488,'1','141','764',322,'Retail Sale Id 1515085',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 15:19:38','',''),(2506595,'1','141','764',322,'Retail Sale Id 1515137',3480.00,0.00,0.00,6.00,552.00,'2022-01-13 15:26:03','',''),(2506639,'1','141','764',322,'Retail Sale Id 1515156',24240.00,0.00,0.00,48.00,816.00,'2022-01-13 15:29:29','',''),(2506678,'1','141','764',322,'Retail Sale Id 1515185',4640.00,0.00,0.00,8.00,736.00,'2022-01-13 15:32:01','',''),(2506758,'1','141','764',322,'Retail Sale Id 1515257',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 15:39:44','',''),(2506772,'1','141','764',322,'Retail Sale Id 1515286',60600.00,0.00,0.00,120.00,2040.00,'2022-01-13 15:42:29','',''),(2506818,'1','141','764',322,'Retail Sale Id 1515307',37622.50,0.00,0.00,74.50,1266.50,'2022-01-13 15:45:06','',''),(2506939,'1','141','764',322,'Retail Sale Id 1515379',2499.80,0.00,0.00,4.31,396.52,'2022-01-13 15:54:24','',''),(2506948,'1','141','764',322,'Retail Sale Id 1515389',56812.50,0.00,0.00,112.50,1912.50,'2022-01-13 15:55:28','',''),(2506970,'1','141','764',322,'Retail Sale Id 1515412',2320.00,0.00,0.00,4.00,368.00,'2022-01-13 15:57:34','',''),(2506982,'1','141','764',322,'Retail Sale Id 1515431',1740.00,0.00,0.00,3.00,276.00,'2022-01-13 15:59:10','',''),(2506996,'1','141','764',322,'Retail Sale Id 1515448',9595.00,0.00,0.00,19.00,323.00,'2022-01-13 16:01:08','',''),(2507010,'1','141','764',322,'Retail Sale Id 1515466',2001.00,0.00,0.00,3.45,317.40,'2022-01-13 16:02:54','',''),(2507024,'1','141','764',322,'Retail Sale Id 1515479',30300.00,0.00,0.00,60.00,1020.00,'2022-01-13 16:04:16','',''),(2507857,'1','141','764',322,'Retail Sale Id 1516383',38512.00,0.00,0.00,66.40,6108.80,'2022-01-13 17:28:35','',''),(2507928,'1','141','764',322,'Retail Sale Id 1516442',205131.00,0.00,0.00,406.20,6905.40,'2022-01-13 17:34:39','',''),(2508313,'1','141','764',322,'Return of Retail Sale Id 1514732',0.00,2998.60,5.17,0.00,-475.64,'2022-01-13 18:09:55','',''),(2509573,'1','141','764',322,'Distributed to OPERATIONAL LOSS for sales id:346131',139636.32,0.00,0.00,286.14,0.00,'2022-01-14 07:47:44','',''),(2509627,'1','141',NULL,322,'Purchased from AA RANO NIGERIA LIMITED',0.00,12170720.00,24940.00,0.00,0.00,'2022-01-14 07:53:19','',''),(2509650,'1','141',NULL,322,'Reception corrector for bridging 130815',0.00,0.00,0.00,24940.00,0.00,'2022-01-14 07:55:43','',''),(2509651,'1','141','764',322,'Received from bridging 130815',0.00,0.00,24940.00,0.00,0.00,'2022-01-14 07:55:43','',''),(2509837,'1','141','764',322,'Retail Sale Id 1517787',59590.00,0.00,0.00,118.00,2006.00,'2022-01-14 08:17:17','',''),(2509865,'1','141','764',322,'Retail Sale Id 1517810',3480.00,0.00,0.00,6.00,552.00,'2022-01-14 08:20:05','',''),(2509874,'1','141','764',322,'Retail Sale Id 1517820',1160.00,0.00,0.00,2.00,184.00,'2022-01-14 08:21:38','',''),(2509888,'1','141','764',322,'Retail Sale Id 1517836',997.60,0.00,0.00,1.72,158.24,'2022-01-14 08:23:26','',''),(2509921,'1','141','764',322,'Retail Sale Id 1517867',101000.00,0.00,0.00,200.00,3400.00,'2022-01-14 08:26:47','',''),(2509944,'1','141','764',322,'Retail Sale Id 1517889',10440.00,0.00,0.00,18.00,1656.00,'2022-01-14 08:28:46','',''),(2509956,'1','141','764',322,'Retail Sale Id 1517903',3480.00,0.00,0.00,6.00,552.00,'2022-01-14 08:29:58','',''),(2509969,'1','141','764',322,'Retail Sale Id 1517914',13130.00,0.00,0.00,26.00,442.00,'2022-01-14 08:31:27','',''),(2510019,'1','141','764',322,'Retail Sale Id 1517947',580.00,0.00,0.00,1.00,92.00,'2022-01-14 08:34:05','',''),(2510030,'1','141','764',322,'Retail Sale Id 1517959',997.60,0.00,0.00,1.72,158.24,'2022-01-14 08:35:08','',''),(2510058,'1','141','764',322,'Retail Sale Id 1517975',1450.00,0.00,0.00,2.50,230.00,'2022-01-14 08:36:20','',''),(2510081,'1','141','764',322,'Retail Sale Id 1517992',100495.00,0.00,0.00,199.00,3383.00,'2022-01-14 08:37:59','',''),(2510145,'1','141','764',322,'Retail Sale Id 1518037',6960.00,0.00,0.00,12.00,1104.00,'2022-01-14 08:43:30','',''),(2510165,'1','141','764',322,'Retail Sale Id 1518050',50500.00,0.00,0.00,100.00,1700.00,'2022-01-14 08:44:43','',''),(2510194,'1','141','764',322,'Retail Sale Id 1518076',2001.00,0.00,0.00,3.45,317.40,'2022-01-14 08:47:45','',''),(2510206,'1','141','764',322,'Retail Sale Id 1518088',25250.00,0.00,0.00,50.00,850.00,'2022-01-14 08:48:52','',''),(2510226,'1','141','764',322,'Retail Sale Id 1518101',60600.00,0.00,0.00,120.00,2040.00,'2022-01-14 08:50:20','',''),(2510253,'1','141','764',322,'Retail Sale Id 1518123',4640.00,0.00,0.00,8.00,736.00,'2022-01-14 08:53:16','',''),(2510304,'1','141','764',322,'Retail Sale Id 1518165',94687.50,0.00,0.00,187.50,3187.50,'2022-01-14 08:58:52','',''),(2510375,'1','141','764',322,'Retail Sale Id 1518234',62620.00,0.00,0.00,124.00,2108.00,'2022-01-14 09:05:01','',''),(2510392,'1','141','764',322,'Retail Sale Id 1518248',25250.00,0.00,0.00,50.00,850.00,'2022-01-14 09:06:30','',''),(2510413,'1','141','764',322,'Retail Sale Id 1518271',151500.00,0.00,0.00,300.00,5100.00,'2022-01-14 09:08:25','',''),(2510425,'1','141','764',322,'Retail Sale Id 1518299',2001.00,0.00,0.00,3.45,317.40,'2022-01-14 09:10:37','',''),(2510467,'1','141','764',322,'Retail Sale Id 1518330',1740.00,0.00,0.00,3.00,276.00,'2022-01-14 09:12:34','',''),(2510479,'1','141','764',322,'Retail Sale Id 1518353',1740.00,0.00,0.00,3.00,276.00,'2022-01-14 09:14:16','',''),(2510491,'1','141','764',322,'Retail Sale Id 1518374',1160.00,0.00,0.00,2.00,184.00,'2022-01-14 09:15:43','',''),(2510506,'1','141','764',322,'Retail Sale Id 1518388',2900.00,0.00,0.00,5.00,460.00,'2022-01-14 09:16:57','',''),(2510514,'1','141','764',322,'Retail Sale Id 1518396',7540.00,0.00,0.00,13.00,1196.00,'2022-01-14 09:18:06','',''),(2510532,'1','141','764',322,'Retail Sale Id 1518418',2900.00,0.00,0.00,5.00,460.00,'2022-01-14 09:20:02','',''),(2510548,'1','141','764',322,'Retail Sale Id 1518437',83325.00,0.00,0.00,165.00,2805.00,'2022-01-14 09:21:49','',''),(2510576,'1','141','764',322,'Retail Sale Id 1518478',3480.00,0.00,0.00,6.00,552.00,'2022-01-14 09:25:05','',''),(2510607,'1','141','764',322,'Retail Sale Id 1518499',1740.00,0.00,0.00,3.00,276.00,'2022-01-14 09:26:34','',''),(2510643,'1','141','764',322,'Retail Sale Id 1518522',50500.00,0.00,0.00,100.00,1700.00,'2022-01-14 09:28:38','',''),(2510664,'1','141','764',322,'Retail Sale Id 1518552',1160.00,0.00,0.00,2.00,184.00,'2022-01-14 09:30:43','',''),(2510697,'1','141','764',322,'Retail Sale Id 1518580',44945.00,0.00,0.00,89.00,1513.00,'2022-01-14 09:32:50','',''),(2510740,'1','141','764',322,'Retail Sale Id 1518617',40400.00,0.00,0.00,80.00,1360.00,'2022-01-14 09:35:37','',''),(2510773,'1','141','764',322,'Retail Sale Id 1518646',50500.00,0.00,0.00,100.00,1700.00,'2022-01-14 09:38:00','',''),(2510803,'1','141','764',322,'Retail Sale Id 1518679',2320.00,0.00,0.00,4.00,368.00,'2022-01-14 09:40:36','',''),(2510834,'1','141','764',322,'Retail Sale Id 1518696',4060.00,0.00,0.00,7.00,644.00,'2022-01-14 09:42:05','',''),(2510888,'1','141','764',322,'Retail Sale Id 1518718',1160.00,0.00,0.00,2.00,184.00,'2022-01-14 09:44:38','',''),(2510918,'1','141','764',322,'Retail Sale Id 1518736',2320.00,0.00,0.00,4.00,368.00,'2022-01-14 09:46:26','',''),(2510942,'1','141','764',322,'Retail Sale Id 1518755',6380.00,0.00,0.00,11.00,1012.00,'2022-01-14 09:48:30','',''),(2510983,'1','141','764',322,'Retail Sale Id 1518774',1600.80,0.00,0.00,2.76,253.92,'2022-01-14 09:50:14','',''),(2511003,'1','141','764',322,'Retail Sale Id 1518785',50500.00,0.00,0.00,100.00,1700.00,'2022-01-14 09:51:55','',''),(2511046,'1','141','764',322,'Retail Sale Id 1518810',26765.00,0.00,0.00,53.00,901.00,'2022-01-14 09:54:37','',''),(2511094,'1','141','764',322,'Retail Sale Id 1518854',7250.00,0.00,0.00,12.50,1150.00,'2022-01-14 09:58:06','',''),(2511121,'1','141','764',322,'Retail Sale Id 1518868',56812.50,0.00,0.00,112.50,1912.50,'2022-01-14 10:00:07','',''),(2511143,'1','141','764',322,'Retail Sale Id 1518899',1160.00,0.00,0.00,2.00,184.00,'2022-01-14 10:02:23','',''),(2511166,'1','141','764',322,'Retail Sale Id 1518929',101000.00,0.00,0.00,200.00,3400.00,'2022-01-14 10:04:12','',''),(2511222,'1','141','764',322,'Retail Sale Id 1519002',5050.00,0.00,0.00,10.00,170.00,'2022-01-14 10:10:07','',''),(2511236,'1','141','764',322,'Retail Sale Id 1519014',45450.00,0.00,0.00,90.00,1530.00,'2022-01-14 10:11:42','',''),(2511267,'1','141','764',322,'Retail Sale Id 1519041',2320.00,0.00,0.00,4.00,368.00,'2022-01-14 10:14:32','',''),(2511277,'1','141','764',322,'Retail Sale Id 1519070',2900.00,0.00,0.00,5.00,460.00,'2022-01-14 10:15:58','',''),(2511312,'1','141','764',322,'Retail Sale Id 1519100',1740.00,0.00,0.00,3.00,276.00,'2022-01-14 10:19:44','',''),(2511343,'1','141','764',322,'Retail Sale Id 1519139',117160.00,0.00,0.00,232.00,3944.00,'2022-01-14 10:23:00','',''),(2511359,'1','141','764',322,'Retail Sale Id 1519156',2001.00,0.00,0.00,3.45,317.40,'2022-01-14 10:25:05','',''),(2511401,'1','141','764',322,'Retail Sale Id 1519214',1740.00,0.00,0.00,3.00,276.00,'2022-01-14 10:29:59','',''),(2511413,'1','141','764',322,'Retail Sale Id 1519226',997.60,0.00,0.00,1.72,158.24,'2022-01-14 10:31:32','',''),(2511425,'1','141','764',322,'Retail Sale Id 1519242',6060.00,0.00,0.00,12.00,204.00,'2022-01-14 10:33:19','',''),(2511456,'1','141','764',322,'Retail Sale Id 1519264',2320.00,0.00,0.00,4.00,368.00,'2022-01-14 10:35:53','',''),(2511466,'1','141','764',322,'Retail Sale Id 1519291',701.80,0.00,0.00,1.21,111.32,'2022-01-14 10:37:29','',''),(2511490,'1','141','764',322,'Retail Sale Id 1519318',7250.00,0.00,0.00,12.50,1150.00,'2022-01-14 10:40:02','',''),(2511514,'1','141','764',322,'Retail Sale Id 1519348',1740.00,0.00,0.00,3.00,276.00,'2022-01-14 10:42:29','',''),(2511529,'1','141','764',322,'Retail Sale Id 1519373',28280.00,0.00,0.00,56.00,952.00,'2022-01-14 10:44:39','',''),(2511547,'1','141','764',322,'Retail Sale Id 1519397',25250.00,0.00,0.00,50.00,850.00,'2022-01-14 10:46:41','',''),(2511581,'1','141','764',322,'Retail Sale Id 1519432',87870.00,0.00,0.00,174.00,2958.00,'2022-01-14 10:51:28','',''),(2511617,'1','141','764',322,'Retail Sale Id 1519467',2801.40,0.00,0.00,4.83,444.36,'2022-01-14 10:57:09','',''),(2511630,'1','141','764',322,'Retail Sale Id 1519481',25755.00,0.00,0.00,51.00,867.00,'2022-01-14 10:58:46','',''),(2511663,'1','141','764',322,'Retail Sale Id 1519508',1740.00,0.00,0.00,3.00,276.00,'2022-01-14 11:02:26','',''),(2511699,'1','141','764',322,'Retail Sale Id 1519528',25250.00,0.00,0.00,50.00,850.00,'2022-01-14 11:04:15','',''),(2511776,'1','141','764',322,'Retail Sale Id 1519592',123220.00,0.00,0.00,244.00,4148.00,'2022-01-14 11:11:36','',''),(2511879,'1','141','764',322,'Retail Sale Id 1519641',122715.00,0.00,0.00,243.00,4131.00,'2022-01-14 11:16:21','',''),(2511897,'1','141','764',322,'Retail Sale Id 1519655',1160.00,0.00,0.00,2.00,184.00,'2022-01-14 11:18:15','',''),(2511924,'1','141','764',322,'Retail Sale Id 1519678',69690.00,0.00,0.00,138.00,2346.00,'2022-01-14 11:21:54','',''),(2511960,'1','141','764',322,'Retail Sale Id 1519729',1740.00,0.00,0.00,3.00,276.00,'2022-01-14 11:26:04','',''),(2511972,'1','141','764',322,'Retail Sale Id 1519741',83325.00,0.00,0.00,165.00,2805.00,'2022-01-14 11:27:18','',''),(2512002,'1','141','764',322,'Retail Sale Id 1519778',997.60,0.00,0.00,1.72,158.24,'2022-01-14 11:30:57','',''),(2512017,'1','141','764',322,'Retail Sale Id 1519795',7250.00,0.00,0.00,12.50,1150.00,'2022-01-14 11:32:54','',''),(2512065,'1','141','764',322,'Retail Sale Id 1519849',264115.00,0.00,0.00,523.00,8891.00,'2022-01-14 11:37:39','',''),(2512093,'1','141','764',322,'Retail Sale Id 1519880',1740.00,0.00,0.00,3.00,276.00,'2022-01-14 11:41:09','',''),(2512118,'1','141','764',322,'Retail Sale Id 1519905',88880.00,0.00,0.00,176.00,2992.00,'2022-01-14 11:44:25','',''),(2512174,'1','141','764',322,'Retail Sale Id 1519952',2499.80,0.00,0.00,4.31,396.52,'2022-01-14 11:51:29','',''),(2512185,'1','141','764',322,'Retail Sale Id 1519964',60600.00,0.00,0.00,120.00,2040.00,'2022-01-14 11:53:07','',''),(2512214,'1','141','764',322,'Retail Sale Id 1519980',58580.00,0.00,0.00,116.00,1972.00,'2022-01-14 11:57:35','',''),(2512228,'1','141','764',322,'Retail Sale Id 1520004',50500.00,0.00,0.00,100.00,1700.00,'2022-01-14 11:59:40','',''),(2512251,'1','141','764',322,'Retail Sale Id 1520024',24391.50,0.00,0.00,48.30,821.10,'2022-01-14 12:02:14','',''),(2512263,'1','141','764',322,'Retail Sale Id 1520036',15655.00,0.00,0.00,31.00,527.00,'2022-01-14 12:04:27','',''),(2512276,'1','141','764',322,'Retail Sale Id 1520051',870000.00,0.00,0.00,1500.00,138000.00,'2022-01-14 12:06:25','',''),(2512288,'1','141','764',322,'Retail Sale Id 1520061',1502.20,0.00,0.00,2.59,238.28,'2022-01-14 12:08:15','',''),(2512296,'1','141','764',322,'Retail Sale Id 1520071',2900.00,0.00,0.00,5.00,460.00,'2022-01-14 12:09:15','',''),(2512313,'1','141','764',322,'Return of Retail Sale Id 1520051',0.00,870000.00,1500.00,0.00,-138000.00,'2022-01-14 12:12:22','',''),(2512324,'1','141','764',322,'Retail Sale Id 1520097',1502.20,0.00,0.00,2.59,238.28,'2022-01-14 12:13:36','',''),(2512338,'1','141','764',322,'Retail Sale Id 1520111',1740.00,0.00,0.00,3.00,276.00,'2022-01-14 12:15:34','',''),(2512369,'1','141','764',322,'Retail Sale Id 1520135',3480.00,0.00,0.00,6.00,552.00,'2022-01-14 12:18:01','',''),(2512391,'1','141','764',322,'Retail Sale Id 1520152',7250.00,0.00,0.00,12.50,1150.00,'2022-01-14 12:19:41','',''),(2512405,'1','141','764',322,'Retail Sale Id 1520167',1740.00,0.00,0.00,3.00,276.00,'2022-01-14 12:21:14','',''),(2512420,'1','141','764',322,'Retail Sale Id 1520181',15150.00,0.00,0.00,30.00,510.00,'2022-01-14 12:23:22','',''),(2516456,'1','141','764',322,'Retail Sale Id 1523938',141288.00,0.00,0.00,243.60,22411.20,'2022-01-14 21:55:36','',''),(2516457,'1','141','764',322,'Retail Sale Id 1523939',2764521.50,0.00,0.00,5474.30,93063.10,'2022-01-14 21:56:54','',''),(2516458,'1','141','764',322,'Return of Retail Sale Id 1523938',0.00,141288.00,243.60,0.00,-22411.20,'2022-01-14 22:01:53','',''),(2516459,'1','141','764',322,'Retail Sale Id 1523940',127582.60,0.00,0.00,219.97,20237.24,'2022-01-14 22:03:34','',''),(2517644,'1','141','764',322,'Retail Sale Id 1524656',88375.00,0.00,0.00,175.00,2975.00,'2022-01-15 08:43:42','',''),(2517702,'1','141','764',322,'Retail Sale Id 1524712',2001.00,0.00,0.00,3.45,317.40,'2022-01-15 08:50:00','',''),(2517711,'1','141','764',322,'Retail Sale Id 1524722',1740.00,0.00,0.00,3.00,276.00,'2022-01-15 08:51:15','',''),(2517733,'1','141','764',322,'Retail Sale Id 1524743',2900.00,0.00,0.00,5.00,460.00,'2022-01-15 08:53:35','',''),(2517767,'1','141','764',322,'Retail Sale Id 1524778',7250.00,0.00,0.00,12.50,1150.00,'2022-01-15 08:56:20','',''),(2517789,'1','141','764',322,'Retail Sale Id 1524796',6501.80,0.00,0.00,11.21,1031.32,'2022-01-15 08:57:34','',''),(2517803,'1','141','764',322,'Retail Sale Id 1524810',56560.00,0.00,0.00,112.00,1904.00,'2022-01-15 08:59:19','',''),(2517814,'1','141','764',322,'Retail Sale Id 1524821',1160.00,0.00,0.00,2.00,184.00,'2022-01-15 09:00:30','',''),(2517871,'1','141','764',322,'Retail Sale Id 1524872',9280.00,0.00,0.00,16.00,1472.00,'2022-01-15 09:06:03','',''),(2517898,'1','141','764',322,'Retail Sale Id 1524897',2900.00,0.00,0.00,5.00,460.00,'2022-01-15 09:08:30','',''),(2517911,'1','141','764',322,'Retail Sale Id 1524907',1160.00,0.00,0.00,2.00,184.00,'2022-01-15 09:09:36','',''),(2517927,'1','141','764',322,'Retail Sale Id 1524921',2900.00,0.00,0.00,5.00,460.00,'2022-01-15 09:10:48','',''),(2517937,'1','141','764',322,'Retail Sale Id 1524935',7000.60,0.00,0.00,12.07,1110.44,'2022-01-15 09:12:00','',''),(2517978,'1','141','764',322,'Retail Sale Id 1524973',4002.00,0.00,0.00,6.90,634.80,'2022-01-15 09:14:51','',''),(2518051,'1','141','764',322,'Retail Sale Id 1525042',1740.00,0.00,0.00,3.00,276.00,'2022-01-15 09:20:38','',''),(2518300,'1','141','764',322,'Retail Sale Id 1525215',2001.00,0.00,0.00,3.45,317.40,'2022-01-15 09:33:22','',''),(2518367,'1','141','764',322,'Retail Sale Id 1525256',119685.00,0.00,0.00,237.00,4029.00,'2022-01-15 09:36:16','',''),(2518440,'1','141','764',322,'Retail Sale Id 1525331',3480.00,0.00,0.00,6.00,552.00,'2022-01-15 09:43:27','',''),(2518453,'1','141','764',322,'Retail Sale Id 1525346',7250.00,0.00,0.00,12.50,1150.00,'2022-01-15 09:45:12','',''),(2518471,'1','141','764',322,'Retail Sale Id 1525364',28785.00,0.00,0.00,57.00,969.00,'2022-01-15 09:46:51','',''),(2518494,'1','141','764',322,'Retail Sale Id 1525388',51762.50,0.00,0.00,102.50,1742.50,'2022-01-15 09:49:38','',''),(2518537,'1','141','764',322,'Retail Sale Id 1525428',75750.00,0.00,0.00,150.00,2550.00,'2022-01-15 09:53:21','',''),(2518576,'1','141','764',322,'Retail Sale Id 1525468',60600.00,0.00,0.00,120.00,2040.00,'2022-01-15 09:57:22','',''),(2518615,'1','141','764',322,'Retail Sale Id 1525511',33077.50,0.00,0.00,65.50,1113.50,'2022-01-15 10:00:39','',''),(2518664,'1','141','764',322,'Retail Sale Id 1525549',201747.50,0.00,0.00,399.50,6791.50,'2022-01-15 10:04:53','',''),(2518702,'1','141','764',322,'Retail Sale Id 1525603',27775.00,0.00,0.00,55.00,935.00,'2022-01-15 10:08:26','',''),(2518734,'1','141','764',322,'Retail Sale Id 1525641',37875.00,0.00,0.00,75.00,1275.00,'2022-01-15 10:10:50','',''),(2518782,'1','141','764',322,'Retail Sale Id 1525701',80800.00,0.00,0.00,160.00,2720.00,'2022-01-15 10:15:38','',''),(2518826,'1','141','764',322,'Retail Sale Id 1525746',2001.00,0.00,0.00,3.45,317.40,'2022-01-15 10:19:02','',''),(2518848,'1','141','764',322,'Retail Sale Id 1525779',3535.00,0.00,0.00,7.00,119.00,'2022-01-15 10:20:53','',''),(2518875,'1','141','764',322,'Retail Sale Id 1525811',56560.00,0.00,0.00,112.00,1904.00,'2022-01-15 10:23:20','',''),(2518909,'1','141','764',322,'Retail Sale Id 1525831',151500.00,0.00,0.00,300.00,5100.00,'2022-01-15 10:25:44','',''),(2519228,'1','141','764',322,'Retail Sale Id 1526092',87870.00,0.00,0.00,174.00,2958.00,'2022-01-15 10:47:12','',''),(2519365,'1','141','764',322,'Retail Sale Id 1526187',60347.50,0.00,0.00,119.50,2031.50,'2022-01-15 10:54:43','',''),(2519385,'1','141','764',322,'Retail Sale Id 1526206',138875.00,0.00,0.00,275.00,4675.00,'2022-01-15 10:56:25','',''),(2519424,'1','141','764',322,'Retail Sale Id 1526243',30300.00,0.00,0.00,60.00,1020.00,'2022-01-15 11:00:13','',''),(2519467,'1','141','764',322,'Retail Sale Id 1526283',1160.00,0.00,0.00,2.00,184.00,'2022-01-15 11:04:27','',''),(2519487,'1','141','764',322,'Retail Sale Id 1526295',29795.00,0.00,0.00,59.00,1003.00,'2022-01-15 11:05:47','',''),(2519515,'1','141','764',322,'Retail Sale Id 1526316',3480.00,0.00,0.00,6.00,552.00,'2022-01-15 11:08:10','',''),(2519527,'1','141','764',322,'Retail Sale Id 1526329',28280.00,0.00,0.00,56.00,952.00,'2022-01-15 11:09:27','',''),(2519556,'1','141','764',322,'Retail Sale Id 1526354',4646.00,0.00,0.00,9.20,156.40,'2022-01-15 11:11:59','',''),(2519576,'1','141','764',322,'Retail Sale Id 1526374',1502.20,0.00,0.00,2.59,238.28,'2022-01-15 11:13:53','',''),(2519605,'1','141','764',322,'Retail Sale Id 1526393',361075.00,0.00,0.00,715.00,12155.00,'2022-01-15 11:15:48','',''),(2519659,'1','141','764',322,'Retail Sale Id 1526442',1740.00,0.00,0.00,3.00,276.00,'2022-01-15 11:19:56','',''),(2519672,'1','141','764',322,'Retail Sale Id 1526457',1160.00,0.00,0.00,2.00,184.00,'2022-01-15 11:20:57','',''),(2519698,'1','141','764',322,'Retail Sale Id 1526488',1740.00,0.00,0.00,3.00,276.00,'2022-01-15 11:23:01','',''),(2519718,'1','141','764',322,'Retail Sale Id 1526510',2320.00,0.00,0.00,4.00,368.00,'2022-01-15 11:24:39','',''),(2519735,'1','141','764',322,'Retail Sale Id 1526525',1740.00,0.00,0.00,3.00,276.00,'2022-01-15 11:26:01','',''),(2519752,'1','141','764',322,'Retail Sale Id 1526542',59590.00,0.00,0.00,118.00,2006.00,'2022-01-15 11:27:27','',''),(2519775,'1','141','764',322,'Retail Sale Id 1526561',3480.00,0.00,0.00,6.00,552.00,'2022-01-15 11:28:54','',''),(2519794,'1','141','764',322,'Retail Sale Id 1526572',2998.60,0.00,0.00,5.17,475.64,'2022-01-15 11:30:01','',''),(2519814,'1','141','764',322,'Retail Sale Id 1526593',60600.00,0.00,0.00,120.00,2040.00,'2022-01-15 11:31:18','',''),(2519853,'1','141','764',322,'Retail Sale Id 1526613',2320.00,0.00,0.00,4.00,368.00,'2022-01-15 11:33:44','',''),(2519878,'1','141','764',322,'Retail Sale Id 1526638',8990.00,0.00,0.00,15.50,1426.00,'2022-01-15 11:36:31','',''),(2519895,'1','141','764',322,'Retail Sale Id 1526655',1102.00,0.00,0.00,1.90,174.80,'2022-01-15 11:38:12','',''),(2519913,'1','141','764',322,'Retail Sale Id 1526671',60600.00,0.00,0.00,120.00,2040.00,'2022-01-15 11:39:59','',''),(2519934,'1','141','764',322,'Retail Sale Id 1526687',2900.00,0.00,0.00,5.00,460.00,'2022-01-15 11:41:28','',''),(2519957,'1','141','764',322,'Retail Sale Id 1526709',129785.00,0.00,0.00,257.00,4369.00,'2022-01-15 11:43:32','',''),(2519994,'1','141','764',322,'Retail Sale Id 1526760',7250.00,0.00,0.00,12.50,1150.00,'2022-01-15 11:47:19','',''),(2520012,'1','141','764',322,'Retail Sale Id 1526774',1699.40,0.00,0.00,2.93,269.56,'2022-01-15 11:48:52','',''),(2520025,'1','141','764',322,'Retail Sale Id 1526788',2320.00,0.00,0.00,4.00,368.00,'2022-01-15 11:50:33','',''),(2520035,'1','141','764',322,'Retail Sale Id 1526802',580.00,0.00,0.00,1.00,92.00,'2022-01-15 11:51:36','',''),(2520057,'1','141','764',322,'Retail Sale Id 1526827',1740.00,0.00,0.00,3.00,276.00,'2022-01-15 11:53:48','',''),(2520077,'1','141','764',322,'Retail Sale Id 1526849',2900.00,0.00,0.00,5.00,460.00,'2022-01-15 11:55:26','',''),(2520086,'1','141','764',322,'Retail Sale Id 1526859',1160.00,0.00,0.00,2.00,184.00,'2022-01-15 11:56:25','',''),(2520140,'1','141','764',322,'Retail Sale Id 1526900',2320.00,0.00,0.00,4.00,368.00,'2022-01-15 12:01:29','',''),(2520176,'1','141','764',322,'Retail Sale Id 1526943',151500.00,0.00,0.00,300.00,5100.00,'2022-01-15 12:03:10','',''),(2520233,'1','141','764',322,'Retail Sale Id 1526989',5800.00,0.00,0.00,10.00,920.00,'2022-01-15 12:06:57','',''),(2520259,'1','141','764',322,'Retail Sale Id 1527025',7250.00,0.00,0.00,12.50,1150.00,'2022-01-15 12:09:02','',''),(2520285,'1','141','764',322,'Retail Sale Id 1527058',3480.00,0.00,0.00,6.00,552.00,'2022-01-15 12:11:42','',''),(2520315,'1','141','764',322,'Retail Sale Id 1527092',997.60,0.00,0.00,1.72,158.24,'2022-01-15 12:14:23','',''),(2520361,'1','141','764',322,'Retail Sale Id 1527137',2900.00,0.00,0.00,5.00,460.00,'2022-01-15 12:18:16','',''),(2520552,'1','141','764',322,'Retail Sale Id 1527336',6380.00,0.00,0.00,11.00,1012.00,'2022-01-15 12:35:59','',''),(2520566,'1','141','764',322,'Retail Sale Id 1527350',2900.00,0.00,0.00,5.00,460.00,'2022-01-15 12:37:31','',''),(2520606,'1','141','764',322,'Retail Sale Id 1527368',2998.60,0.00,0.00,5.17,475.64,'2022-01-15 12:38:50','',''),(2520619,'1','141','764',322,'Retail Sale Id 1527383',2499.80,0.00,0.00,4.31,396.52,'2022-01-15 12:40:15','',''),(2520637,'1','141','764',322,'Retail Sale Id 1527399',997.60,0.00,0.00,1.72,158.24,'2022-01-15 12:41:27','',''),(2520653,'1','141','764',322,'Retail Sale Id 1527414',138875.00,0.00,0.00,275.00,4675.00,'2022-01-15 12:43:10','',''),(2520715,'1','141','764',322,'Retail Sale Id 1527458',3480.00,0.00,0.00,6.00,552.00,'2022-01-15 12:47:53','',''),(2520751,'1','141','764',322,'Retail Sale Id 1527485',580.00,0.00,0.00,1.00,92.00,'2022-01-15 12:51:15','',''),(2520777,'1','141','764',322,'Retail Sale Id 1527512',24997.50,0.00,0.00,49.50,841.50,'2022-01-15 12:54:34','',''),(2520794,'1','141','764',322,'Retail Sale Id 1527531',25250.00,0.00,0.00,50.00,850.00,'2022-01-15 12:56:04','',''),(2520817,'1','141','764',322,'Retail Sale Id 1527554',83325.00,0.00,0.00,165.00,2805.00,'2022-01-15 12:58:44','',''),(2520861,'1','141','764',322,'Retail Sale Id 1527596',62115.00,0.00,0.00,123.00,2091.00,'2022-01-15 13:03:23','',''),(2520896,'1','141','764',322,'Retail Sale Id 1527629',2320.00,0.00,0.00,4.00,368.00,'2022-01-15 13:07:02','',''),(2520942,'1','141','764',322,'Retail Sale Id 1527650',997.60,0.00,0.00,1.72,158.24,'2022-01-15 13:09:24','',''),(2520956,'1','141','764',322,'Retail Sale Id 1527661',5800.00,0.00,0.00,10.00,920.00,'2022-01-15 13:10:36','',''),(2521062,'1','141','764',322,'Retail Sale Id 1527734',18937.50,0.00,0.00,37.50,637.50,'2022-01-15 13:16:56','',''),(2521126,'1','141','764',322,'Retail Sale Id 1527758',83325.00,0.00,0.00,165.00,2805.00,'2022-01-15 13:19:32','',''),(2521160,'1','141','764',322,'Retail Sale Id 1527784',7250.00,0.00,0.00,12.50,1150.00,'2022-01-15 13:22:31','',''),(2521190,'1','141','764',322,'Retail Sale Id 1527820',1102.00,0.00,0.00,1.90,174.80,'2022-01-15 13:24:57','',''),(2521202,'1','141','764',322,'Retail Sale Id 1527832',997.60,0.00,0.00,1.72,158.24,'2022-01-15 13:26:07','',''),(2521213,'1','141','764',322,'Retail Sale Id 1527840',580.00,0.00,0.00,1.00,92.00,'2022-01-15 13:27:14','',''),(2521235,'1','141','764',322,'Retail Sale Id 1527865',580.00,0.00,0.00,1.00,92.00,'2022-01-15 13:29:16','',''),(2521254,'1','141','764',322,'Retail Sale Id 1527875',580.00,0.00,0.00,1.00,92.00,'2022-01-15 13:30:33','',''),(2521279,'1','141','764',322,'Retail Sale Id 1527901',75750.00,0.00,0.00,150.00,2550.00,'2022-01-15 13:33:04','',''),(2521375,'1','141','764',322,'Retail Sale Id 1527996',309817.50,0.00,0.00,613.50,10429.50,'2022-01-15 13:43:27','',''),(2524299,'1','141','764',322,'Retail Sale Id 1530563',79285.00,0.00,0.00,157.00,2669.00,'2022-01-15 17:34:42','',''),(2524772,'1','141','764',322,'Retail Sale Id 1530992',152308.00,0.00,0.00,262.60,24159.20,'2022-01-15 18:10:43','',''),(2524810,'1','141','764',322,'Retail Sale Id 1531032',149732.50,0.00,0.00,296.50,5040.50,'2022-01-15 18:17:01','',''),(2524903,'1','141','764',322,'Retail Sale Id 1527725',189375.00,0.00,0.00,375.00,6375.00,'2022-01-15 18:29:11','',''),(2524909,'1','141','764',322,'Retail Sale Id 1527412',137360.00,0.00,0.00,272.00,4624.00,'2022-01-15 18:29:56','',''),(2524972,'1','141','764',322,'Retail Sale Id 1531181',1018231.50,0.00,0.00,2016.30,34277.10,'2022-01-15 18:38:13','',''),(2528177,'1','141','764',322,'Retail Sale Id 1533655',75750.00,0.00,0.00,150.00,2550.00,'2022-01-16 10:47:07','',''),(2528210,'1','141','764',322,'Retail Sale Id 1533690',2320.00,0.00,0.00,4.00,368.00,'2022-01-16 10:49:22','',''),(2528245,'1','141','764',322,'Retail Sale Id 1533727',3030.00,0.00,0.00,6.00,102.00,'2022-01-16 10:52:02','',''),(2528256,'1','141','764',322,'Retail Sale Id 1533741',1740.00,0.00,0.00,3.00,276.00,'2022-01-16 10:53:11','',''),(2528308,'1','141','764',322,'Retail Sale Id 1533801',90900.00,0.00,0.00,180.00,3060.00,'2022-01-16 10:58:55','',''),(2528370,'1','141','764',322,'Retail Sale Id 1533860',169680.00,0.00,0.00,336.00,5712.00,'2022-01-16 11:03:54','',''),(2528490,'1','141','764',322,'Retail Sale Id 1533966',45450.00,0.00,0.00,90.00,1530.00,'2022-01-16 11:12:19','',''),(2528521,'1','141','764',322,'Retail Sale Id 1534005',2998.60,0.00,0.00,5.17,475.64,'2022-01-16 11:14:43','',''),(2528559,'1','141','764',322,'Retail Sale Id 1534045',50500.00,0.00,0.00,100.00,1700.00,'2022-01-16 11:17:34','',''),(2528632,'1','141','764',322,'Retail Sale Id 1534112',37875.00,0.00,0.00,75.00,1275.00,'2022-01-16 11:23:14','',''),(2528741,'1','141','764',322,'Retail Sale Id 1534212',2900.00,0.00,0.00,5.00,460.00,'2022-01-16 11:31:47','',''),(2528769,'1','141','764',322,'Retail Sale Id 1534239',6960.00,0.00,0.00,12.00,1104.00,'2022-01-16 11:35:13','',''),(2528782,'1','141','764',322,'Retail Sale Id 1534256',2900.00,0.00,0.00,5.00,460.00,'2022-01-16 11:36:41','',''),(2528854,'1','141','764',322,'Retail Sale Id 1534342',5220.00,0.00,0.00,9.00,828.00,'2022-01-16 11:43:46','',''),(2528878,'1','141','764',322,'Retail Sale Id 1534382',35350.00,0.00,0.00,70.00,1190.00,'2022-01-16 11:45:19','',''),(2528953,'1','141','764',322,'Retail Sale Id 1534463',1740.00,0.00,0.00,3.00,276.00,'2022-01-16 11:53:26','',''),(2528977,'1','141','764',322,'Retail Sale Id 1534486',1740.00,0.00,0.00,3.00,276.00,'2022-01-16 11:55:10','',''),(2529040,'1','141','764',322,'Retail Sale Id 1534567',2001.00,0.00,0.00,3.45,317.40,'2022-01-16 12:01:57','',''),(2529055,'1','141','764',322,'Retail Sale Id 1534582',1740.00,0.00,0.00,3.00,276.00,'2022-01-16 12:03:39','',''),(2529078,'1','141','764',322,'Retail Sale Id 1534602',62620.00,0.00,0.00,124.00,2108.00,'2022-01-16 12:05:26','',''),(2529164,'1','141','764',322,'Retail Sale Id 1534685',6902.00,0.00,0.00,11.90,1094.80,'2022-01-16 12:12:34','',''),(2529181,'1','141','764',322,'Retail Sale Id 1534705',6960.00,0.00,0.00,12.00,1104.00,'2022-01-16 12:14:44','',''),(2529204,'1','141','764',322,'Retail Sale Id 1534728',2900.00,0.00,0.00,5.00,460.00,'2022-01-16 12:16:58','',''),(2529224,'1','141','764',322,'Retail Sale Id 1534749',1160.00,0.00,0.00,2.00,184.00,'2022-01-16 12:19:03','',''),(2529260,'1','141','764',322,'Retail Sale Id 1534790',255025.00,0.00,0.00,505.00,8585.00,'2022-01-16 12:22:17','',''),(2529304,'1','141','764',322,'Retail Sale Id 1534831',7250.00,0.00,0.00,12.50,1150.00,'2022-01-16 12:26:05','',''),(2529321,'1','141','764',322,'Retail Sale Id 1534851',50500.00,0.00,0.00,100.00,1700.00,'2022-01-16 12:27:54','',''),(2529347,'1','141','764',322,'Retail Sale Id 1534874',1160.00,0.00,0.00,2.00,184.00,'2022-01-16 12:30:10','',''),(2529362,'1','141','764',322,'Retail Sale Id 1534890',121200.00,0.00,0.00,240.00,4080.00,'2022-01-16 12:32:03','',''),(2529375,'1','141','764',322,'Retail Sale Id 1534907',2998.60,0.00,0.00,5.17,475.64,'2022-01-16 12:33:23','',''),(2529387,'1','141','764',322,'Retail Sale Id 1534918',3480.00,0.00,0.00,6.00,552.00,'2022-01-16 12:34:29','',''),(2529414,'1','141','764',322,'Retail Sale Id 1534937',12877.50,0.00,0.00,25.50,433.50,'2022-01-16 12:37:18','',''),(2529432,'1','141','764',322,'Retail Sale Id 1534955',1740.00,0.00,0.00,3.00,276.00,'2022-01-16 12:39:05','',''),(2529447,'1','141','764',322,'Retail Sale Id 1534975',1160.00,0.00,0.00,2.00,184.00,'2022-01-16 12:40:39','',''),(2529463,'1','141','764',322,'Retail Sale Id 1535003',2320.00,0.00,0.00,4.00,368.00,'2022-01-16 12:42:07','',''),(2529484,'1','141','764',322,'Retail Sale Id 1535023',88375.00,0.00,0.00,175.00,2975.00,'2022-01-16 12:43:50','',''),(2529547,'1','141','764',322,'Retail Sale Id 1535075',3480.00,0.00,0.00,6.00,552.00,'2022-01-16 12:49:15','',''),(2529562,'1','141','764',322,'Retail Sale Id 1535091',3480.00,0.00,0.00,6.00,552.00,'2022-01-16 12:50:27','',''),(2529576,'1','141','764',322,'Retail Sale Id 1535102',20200.00,0.00,0.00,40.00,680.00,'2022-01-16 12:51:50','',''),(2529595,'1','141','764',322,'Retail Sale Id 1535124',2001.00,0.00,0.00,3.45,317.40,'2022-01-16 12:53:44','',''),(2529610,'1','141','764',322,'Retail Sale Id 1535138',101000.00,0.00,0.00,200.00,3400.00,'2022-01-16 12:54:58','',''),(2529640,'1','141','764',322,'Retail Sale Id 1535169',75750.00,0.00,0.00,150.00,2550.00,'2022-01-16 12:58:21','',''),(2529664,'1','141','764',322,'Retail Sale Id 1535195',30300.00,0.00,0.00,60.00,1020.00,'2022-01-16 13:00:56','',''),(2529680,'1','141','764',322,'Retail Sale Id 1535210',25250.00,0.00,0.00,50.00,850.00,'2022-01-16 13:03:11','',''),(2529708,'1','141','764',322,'Retail Sale Id 1535243',997.60,0.00,0.00,1.72,158.24,'2022-01-16 13:06:05','',''),(2529755,'1','141','764',322,'Retail Sale Id 1535277',2998.60,0.00,0.00,5.17,475.64,'2022-01-16 13:09:26','',''),(2529774,'1','141','764',322,'Retail Sale Id 1535303',25250.00,0.00,0.00,50.00,850.00,'2022-01-16 13:11:21','',''),(2529797,'1','141','764',322,'Retail Sale Id 1535326',7250.00,0.00,0.00,12.50,1150.00,'2022-01-16 13:14:36','',''),(2529868,'1','141','764',322,'Retail Sale Id 1535399',30300.00,0.00,0.00,60.00,1020.00,'2022-01-16 13:20:44','',''),(2529914,'1','141','764',322,'Retail Sale Id 1535440',30300.00,0.00,0.00,60.00,1020.00,'2022-01-16 13:24:54','',''),(2529974,'1','141','764',322,'Retail Sale Id 1535487',7250.00,0.00,0.00,12.50,1150.00,'2022-01-16 13:28:49','',''),(2529988,'1','141','764',322,'Retail Sale Id 1535536',6565.00,0.00,0.00,13.00,221.00,'2022-01-16 13:32:27','',''),(2530021,'1','141','764',322,'Retail Sale Id 1535652',997.60,0.00,0.00,1.72,158.24,'2022-01-16 13:36:06','',''),(2530073,'1','141','764',322,'Retail Sale Id 1535723',239875.00,0.00,0.00,475.00,8075.00,'2022-01-16 13:42:15','',''),(2531525,'1','141','764',322,'Retail Sale Id 1536873',64670.00,0.00,0.00,111.50,10258.00,'2022-01-16 15:50:58','',''),(2531624,'1','141','764',322,'Return of Retail Sale Id 1536873',0.00,64670.00,111.50,0.00,-10258.00,'2022-01-16 16:04:02','',''),(2531634,'1','141','764',322,'Retail Sale Id 1536984',56307.50,0.00,0.00,111.50,1895.50,'2022-01-16 16:05:01','',''),(2531990,'1','141','764',322,'Retail Sale Id 1537280',52520.00,0.00,0.00,104.00,1768.00,'2022-01-16 16:35:48','',''),(2534122,'1','141','764',322,'Distributed to OPERATIONAL LOSS for sales id:346792',144779.84,0.00,0.00,296.68,0.00,'2022-01-17 07:07:53','',''),(2534441,'1','141',NULL,322,'Purchased from AA RANO NIGERIA LIMITED',0.00,12160960.00,24920.00,0.00,0.00,'2022-01-17 07:59:36','',''),(2534470,'1','141',NULL,322,'Reception corrector for bridging 131172',0.00,0.00,0.00,24920.00,0.00,'2022-01-17 08:02:58','',''),(2534471,'1','141','764',322,'Received from bridging 131172',0.00,0.00,24920.00,0.00,0.00,'2022-01-17 08:02:58','',''),(2535265,'1','141','764',322,'Retail Sale Id 1539863',63630.00,0.00,0.00,126.00,2142.00,'2022-01-17 09:29:51','',''),(2535295,'1','141','764',322,'Retail Sale Id 1539888',4999.60,0.00,0.00,8.62,793.04,'2022-01-17 09:32:57','',''),(2535320,'1','141','764',322,'Retail Sale Id 1539911',5050.00,0.00,0.00,10.00,170.00,'2022-01-17 09:35:27','',''),(2535334,'1','141','764',322,'Retail Sale Id 1539927',1798.00,0.00,0.00,3.10,285.20,'2022-01-17 09:36:44','',''),(2535341,'1','141','764',322,'Retail Sale Id 1539936',24240.00,0.00,0.00,48.00,816.00,'2022-01-17 09:37:43','',''),(2535361,'1','141','764',322,'Retail Sale Id 1539951',45702.50,0.00,0.00,90.50,1538.50,'2022-01-17 09:39:37','',''),(2535381,'1','141','764',322,'Retail Sale Id 1539972',4640.00,0.00,0.00,8.00,736.00,'2022-01-17 09:41:49','',''),(2535411,'1','141','764',322,'Retail Sale Id 1539995',50500.00,0.00,0.00,100.00,1700.00,'2022-01-17 09:44:20','',''),(2535419,'1','141','764',322,'Retail Sale Id 1540001',1160.00,0.00,0.00,2.00,184.00,'2022-01-17 09:45:25','',''),(2535434,'1','141','764',322,'Retail Sale Id 1540017',84587.50,0.00,0.00,167.50,2847.50,'2022-01-17 09:46:52','',''),(2535462,'1','141','764',322,'Retail Sale Id 1540043',50500.00,0.00,0.00,100.00,1700.00,'2022-01-17 09:50:21','',''),(2535470,'1','141','764',322,'Retail Sale Id 1540046',852.60,0.00,0.00,1.47,135.24,'2022-01-17 09:51:20','',''),(2535475,'1','141','764',322,'Retail Sale Id 1540053',1740.00,0.00,0.00,3.00,276.00,'2022-01-17 09:52:22','',''),(2535487,'1','141','764',322,'Retail Sale Id 1540065',3480.00,0.00,0.00,6.00,552.00,'2022-01-17 09:53:39','',''),(2535497,'1','141','764',322,'Retail Sale Id 1540076',2998.60,0.00,0.00,5.17,475.64,'2022-01-17 09:55:23','',''),(2535527,'1','141','764',322,'Retail Sale Id 1540103',58580.00,0.00,0.00,116.00,1972.00,'2022-01-17 09:59:20','',''),(2535565,'1','141','764',322,'Retail Sale Id 1540135',50500.00,0.00,0.00,100.00,1700.00,'2022-01-17 10:04:17','',''),(2538397,'1','141','764',322,'Retail Sale Id 1542545',2900.00,0.00,0.00,5.00,460.00,'2022-01-17 15:25:07','',''),(2538410,'1','141','764',322,'Retail Sale Id 1542562',1502.20,0.00,0.00,2.59,238.28,'2022-01-17 15:26:55','',''),(2538421,'1','141','764',322,'Retail Sale Id 1542572',75750.00,0.00,0.00,150.00,2550.00,'2022-01-17 15:28:03','',''),(2538467,'1','141','764',322,'Retail Sale Id 1542620',2001.00,0.00,0.00,3.45,317.40,'2022-01-17 15:32:50','',''),(2538477,'1','141','764',322,'Retail Sale Id 1542629',3480.00,0.00,0.00,6.00,552.00,'2022-01-17 15:33:51','',''),(2538492,'1','141','764',322,'Retail Sale Id 1542646',88375.00,0.00,0.00,175.00,2975.00,'2022-01-17 15:35:47','',''),(2538526,'1','141','764',322,'Retail Sale Id 1542676',2998.60,0.00,0.00,5.17,475.64,'2022-01-17 15:39:12','',''),(2538539,'1','141','764',322,'Retail Sale Id 1542689',12625.00,0.00,0.00,25.00,425.00,'2022-01-17 15:40:34','',''),(2538567,'1','141','764',322,'Retail Sale Id 1542707',7250.00,0.00,0.00,12.50,1150.00,'2022-01-17 15:42:43','',''),(2538586,'1','141','764',322,'Retail Sale Id 1542723',3480.00,0.00,0.00,6.00,552.00,'2022-01-17 15:44:19','',''),(2538635,'1','141','764',322,'Retail Sale Id 1542764',997.60,0.00,0.00,1.72,158.24,'2022-01-17 15:48:27','',''),(2538674,'1','141','764',322,'Retail Sale Id 1542786',15080.00,0.00,0.00,26.00,2392.00,'2022-01-17 15:51:35','',''),(2538710,'1','141','764',322,'Retail Sale Id 1542812',1740.00,0.00,0.00,3.00,276.00,'2022-01-17 15:53:59','',''),(2538723,'1','141','764',322,'Retail Sale Id 1542825',997.60,0.00,0.00,1.72,158.24,'2022-01-17 15:55:22','',''),(2538739,'1','141','764',322,'Retail Sale Id 1542839',25250.00,0.00,0.00,50.00,850.00,'2022-01-17 15:57:09','',''),(2538747,'1','141','764',322,'Retail Sale Id 1542847',3480.00,0.00,0.00,6.00,552.00,'2022-01-17 15:58:22','',''),(2538761,'1','141','764',322,'Retail Sale Id 1542861',7250.00,0.00,0.00,12.50,1150.00,'2022-01-17 16:00:31','',''),(2538803,'1','141','764',322,'Retail Sale Id 1542882',2001.00,0.00,0.00,3.45,317.40,'2022-01-17 16:03:01','',''),(2538815,'1','141','764',322,'Retail Sale Id 1542892',3030.00,0.00,0.00,6.00,102.00,'2022-01-17 16:04:44','',''),(2538846,'1','141','764',322,'Retail Sale Id 1542922',10730.00,0.00,0.00,18.50,1702.00,'2022-01-17 16:07:30','',''),(2538862,'1','141','764',322,'Retail Sale Id 1542934',1502.20,0.00,0.00,2.59,238.28,'2022-01-17 16:09:15','',''),(2538886,'1','141','764',322,'Retail Sale Id 1542957',34340.00,0.00,0.00,68.00,1156.00,'2022-01-17 16:11:06','',''),(2538902,'1','141','764',322,'Retail Sale Id 1542978',3480.00,0.00,0.00,6.00,552.00,'2022-01-17 16:12:49','',''),(2538917,'1','141','764',322,'Retail Sale Id 1542991',1798.00,0.00,0.00,3.10,285.20,'2022-01-17 16:14:07','',''),(2538929,'1','141','764',322,'Retail Sale Id 1543008',997.60,0.00,0.00,1.72,158.24,'2022-01-17 16:15:16','',''),(2538937,'1','141','764',322,'Retail Sale Id 1543015',2320.00,0.00,0.00,4.00,368.00,'2022-01-17 16:16:37','',''),(2538956,'1','141','764',322,'Retail Sale Id 1543035',7250.00,0.00,0.00,12.50,1150.00,'2022-01-17 16:18:33','',''),(2538964,'1','141','764',322,'Retail Sale Id 1543045',2499.80,0.00,0.00,4.31,396.52,'2022-01-17 16:20:04','',''),(2539042,'1','141','764',322,'Retail Sale Id 1543122',1740.00,0.00,0.00,3.00,276.00,'2022-01-17 16:29:48','',''),(2539049,'1','141','764',322,'Retail Sale Id 1543129',1740.00,0.00,0.00,3.00,276.00,'2022-01-17 16:30:59','',''),(2539062,'1','141','764',322,'Retail Sale Id 1543143',1740.00,0.00,0.00,3.00,276.00,'2022-01-17 16:32:11','',''),(2539074,'1','141','764',322,'Retail Sale Id 1543153',1160.00,0.00,0.00,2.00,184.00,'2022-01-17 16:33:28','',''),(2539097,'1','141','764',322,'Retail Sale Id 1543180',2816587.00,0.00,0.00,5577.40,94815.80,'2022-01-17 16:35:33','',''),(2539114,'1','141','764',322,'Retail Sale Id 1543201',3480.00,0.00,0.00,6.00,552.00,'2022-01-17 16:36:48','',''),(2539128,'1','141','764',322,'Retail Sale Id 1543214',2900.00,0.00,0.00,5.00,460.00,'2022-01-17 16:38:07','',''),(2539140,'1','141','764',322,'Retail Sale Id 1543227',1600.80,0.00,0.00,2.76,253.92,'2022-01-17 16:39:15','',''),(2539150,'1','141','764',322,'Retail Sale Id 1543237',3480.00,0.00,0.00,6.00,552.00,'2022-01-17 16:40:11','',''),(2539191,'1','141','764',322,'Retail Sale Id 1543277',55550.00,0.00,0.00,110.00,1870.00,'2022-01-17 16:43:25','',''),(2539210,'1','141','764',322,'Retail Sale Id 1543293',6960.00,0.00,0.00,12.00,1104.00,'2022-01-17 16:44:36','',''),(2539230,'1','141','764',322,'Retail Sale Id 1543315',800.40,0.00,0.00,1.38,126.96,'2022-01-17 16:46:12','',''),(2539242,'1','141','764',322,'Retail Sale Id 1543326',3030.00,0.00,0.00,6.00,102.00,'2022-01-17 16:47:13','',''),(2539263,'1','141','764',322,'Retail Sale Id 1543352',4060.00,0.00,0.00,7.00,644.00,'2022-01-17 16:49:00','',''),(2539281,'1','141','764',322,'Retail Sale Id 1543370',1160.00,0.00,0.00,2.00,184.00,'2022-01-17 16:50:11','',''),(2539298,'1','141','764',322,'Retail Sale Id 1543388',1160.00,0.00,0.00,2.00,184.00,'2022-01-17 16:51:37','',''),(2539319,'1','141','764',322,'Retail Sale Id 1543410',2900.00,0.00,0.00,5.00,460.00,'2022-01-17 16:52:49','',''),(2539401,'1','141','764',322,'Retail Sale Id 1543497',800.40,0.00,0.00,1.38,126.96,'2022-01-17 16:59:36','',''),(2539422,'1','141','764',322,'Retail Sale Id 1543515',30300.00,0.00,0.00,60.00,1020.00,'2022-01-17 17:01:18','',''),(2539464,'1','141','764',322,'Retail Sale Id 1543558',7250.00,0.00,0.00,12.50,1150.00,'2022-01-17 17:04:02','',''),(2539497,'1','141','764',322,'Retail Sale Id 1543587',997.60,0.00,0.00,1.72,158.24,'2022-01-17 17:05:53','',''),(2539525,'1','141','764',322,'Retail Sale Id 1543612',1299.20,0.00,0.00,2.24,206.08,'2022-01-17 17:07:39','',''),(2539618,'1','141','764',322,'Retail Sale Id 1543717',7099.20,0.00,0.00,12.24,1126.08,'2022-01-17 17:13:57','',''),(2539637,'1','141','764',322,'Retail Sale Id 1543738',75750.00,0.00,0.00,150.00,2550.00,'2022-01-17 17:15:25','',''),(2539706,'1','141','764',322,'Retail Sale Id 1543808',997.60,0.00,0.00,1.72,158.24,'2022-01-17 17:20:51','',''),(2539730,'1','141','764',322,'Retail Sale Id 1543830',18850.00,0.00,0.00,32.50,2990.00,'2022-01-17 17:22:27','',''),(2539756,'1','141','764',322,'Retail Sale Id 1543857',14500.00,0.00,0.00,25.00,2300.00,'2022-01-17 17:24:03','',''),(2539769,'1','141','764',322,'Retail Sale Id 1543869',10730.00,0.00,0.00,18.50,1702.00,'2022-01-17 17:25:07','',''),(2539797,'1','141','764',322,'Retail Sale Id 1543899',839916.00,0.00,0.00,1663.20,28274.40,'2022-01-17 17:27:21','',''),(2540250,'1','141','764',322,'Retail Sale Id 1544295',55550.00,0.00,0.00,110.00,1870.00,'2022-01-17 17:59:32','',''),(2540272,'1','141','764',322,'Retail Sale Id 1544311',22725.00,0.00,0.00,45.00,765.00,'2022-01-17 18:00:45','',''),(2540300,'1','141','764',322,'Retail Sale Id 1544331',94308.00,0.00,0.00,162.60,14959.20,'2022-01-17 18:03:03','',''),(2540327,'1','141','764',322,'Return of Retail Sale Id 1543293',0.00,6960.00,12.00,0.00,-1104.00,'2022-01-17 18:07:46','',''),(2540331,'1','141','764',322,'Return of Retail Sale Id 1543612',0.00,1299.20,2.24,0.00,-206.08,'2022-01-17 18:09:24','',''),(2541818,'1','141','764',322,'Retail Sale Id 1545589',1740.00,0.00,0.00,3.00,276.00,'2022-01-18 09:04:30','',''),(2542170,'1','141','764',322,'Retail Sale Id 1545805',110342.50,0.00,0.00,218.50,3714.50,'2022-01-18 09:36:23','',''),(2542191,'1','141','764',322,'Retail Sale Id 1545817',1160.00,0.00,0.00,2.00,184.00,'2022-01-18 09:38:39','',''),(2542196,'1','141','764',322,'Retail Sale Id 1545826',101000.00,0.00,0.00,200.00,3400.00,'2022-01-18 09:39:23','',''),(2542230,'1','141','764',322,'Retail Sale Id 1545853',3480.00,0.00,0.00,6.00,552.00,'2022-01-18 09:41:56','',''),(2542264,'1','141','764',322,'Retail Sale Id 1545866',41157.50,0.00,0.00,81.50,1385.50,'2022-01-18 09:43:46','',''),(2542285,'1','141','764',322,'Retail Sale Id 1545889',194425.00,0.00,0.00,385.00,6545.00,'2022-01-18 09:46:06','',''),(2542302,'1','141','764',322,'Retail Sale Id 1545904',75750.00,0.00,0.00,150.00,2550.00,'2022-01-18 09:48:04','',''),(2542335,'1','141','764',322,'Retail Sale Id 1545935',30300.00,0.00,0.00,60.00,1020.00,'2022-01-18 09:52:13','',''),(2542382,'1','141','764',322,'Retail Sale Id 1545972',107312.50,0.00,0.00,212.50,3612.50,'2022-01-18 09:57:45','',''),(2542448,'1','141','764',322,'Retail Sale Id 1546012',30300.00,0.00,0.00,60.00,1020.00,'2022-01-18 10:01:52','',''),(2542520,'1','141','764',322,'Retail Sale Id 1546051',3535.00,0.00,0.00,7.00,119.00,'2022-01-18 10:06:11','',''),(2542540,'1','141','764',322,'Retail Sale Id 1546076',5800.00,0.00,0.00,10.00,920.00,'2022-01-18 10:09:32','',''),(2542573,'1','141','764',322,'Retail Sale Id 1546103',32825.00,0.00,0.00,65.00,1105.00,'2022-01-18 10:13:11','',''),(2542582,'1','141','764',322,'Retail Sale Id 1546116',69185.00,0.00,0.00,137.00,2329.00,'2022-01-18 10:14:13','',''),(2542634,'1','141','764',322,'Retail Sale Id 1546141',2001.00,0.00,0.00,3.45,317.40,'2022-01-18 10:16:38','',''),(2542648,'1','141','764',322,'Retail Sale Id 1546157',24745.00,0.00,0.00,49.00,833.00,'2022-01-18 10:18:29','',''),(2542665,'1','141','764',322,'Retail Sale Id 1546174',131300.00,0.00,0.00,260.00,4420.00,'2022-01-18 10:19:47','',''),(2542727,'1','141','764',322,'Retail Sale Id 1546207',1160.00,0.00,0.00,2.00,184.00,'2022-01-18 10:23:26','',''),(2542735,'1','141','764',322,'Retail Sale Id 1546221',50500.00,0.00,0.00,100.00,1700.00,'2022-01-18 10:24:54','',''),(2542753,'1','141','764',322,'Retail Sale Id 1546236',136350.00,0.00,0.00,270.00,4590.00,'2022-01-18 10:27:08','',''),(2542806,'1','141','764',322,'Retail Sale Id 1546268',580.00,0.00,0.00,1.00,92.00,'2022-01-18 10:31:20','',''),(2542825,'1','141','764',322,'Retail Sale Id 1546282',60600.00,0.00,0.00,120.00,2040.00,'2022-01-18 10:33:21','',''),(2542850,'1','141','764',322,'Retail Sale Id 1546303',2900.00,0.00,0.00,5.00,460.00,'2022-01-18 10:36:03','',''),(2542872,'1','141','764',322,'Retail Sale Id 1546321',24240.00,0.00,0.00,48.00,816.00,'2022-01-18 10:38:35','',''),(2542922,'1','141','764',322,'Retail Sale Id 1546339',4999.60,0.00,0.00,8.62,793.04,'2022-01-18 10:40:57','',''),(2542929,'1','141','764',322,'Retail Sale Id 1546348',7540.00,0.00,0.00,13.00,1196.00,'2022-01-18 10:42:05','',''),(2542939,'1','141','764',322,'Retail Sale Id 1546359',7250.00,0.00,0.00,12.50,1150.00,'2022-01-18 10:43:26','',''),(2542957,'1','141','764',322,'Retail Sale Id 1546382',1160.00,0.00,0.00,2.00,184.00,'2022-01-18 10:44:34','',''),(2543006,'1','141','764',322,'Retail Sale Id 1546418',50500.00,0.00,0.00,100.00,1700.00,'2022-01-18 10:47:36','',''),(2543040,'1','141','764',322,'Retail Sale Id 1546450',2001.00,0.00,0.00,3.45,317.40,'2022-01-18 10:50:27','',''),(2543054,'1','141','764',322,'Retail Sale Id 1546467',25250.00,0.00,0.00,50.00,850.00,'2022-01-18 10:52:06','',''),(2543077,'1','141','764',322,'Retail Sale Id 1546482',31562.50,0.00,0.00,62.50,1062.50,'2022-01-18 10:54:27','',''),(2543088,'1','141','764',322,'Retail Sale Id 1546494',130037.50,0.00,0.00,257.50,4377.50,'2022-01-18 10:56:15','',''),(2543118,'1','141','764',322,'Retail Sale Id 1546525',102515.00,0.00,0.00,203.00,3451.00,'2022-01-18 11:00:09','',''),(2543178,'1','141','764',322,'Retail Sale Id 1546572',38380.00,0.00,0.00,76.00,1292.00,'2022-01-18 11:06:26','',''),(2543189,'1','141','764',322,'Retail Sale Id 1546581',15150.00,0.00,0.00,30.00,510.00,'2022-01-18 11:07:10','',''),(2543240,'1','141','764',322,'Retail Sale Id 1546635',69185.00,0.00,0.00,137.00,2329.00,'2022-01-18 11:13:11','',''),(2543272,'1','141','764',322,'Retail Sale Id 1546670',7575.00,0.00,0.00,15.00,255.00,'2022-01-18 11:17:07','',''),(2543291,'1','141','764',322,'Retail Sale Id 1546688',2499.80,0.00,0.00,4.31,396.52,'2022-01-18 11:19:22','',''),(2543302,'1','141','764',322,'Retail Sale Id 1546700',2320.00,0.00,0.00,4.00,368.00,'2022-01-18 11:20:21','',''),(2543316,'1','141','764',322,'Retail Sale Id 1546709',3480.00,0.00,0.00,6.00,552.00,'2022-01-18 11:21:51','',''),(2543327,'1','141','764',322,'Retail Sale Id 1546726',1600.80,0.00,0.00,2.76,253.92,'2022-01-18 11:23:27','',''),(2543412,'1','141','764',322,'Retail Sale Id 1546787',87870.00,0.00,0.00,174.00,2958.00,'2022-01-18 11:32:28','',''),(2543469,'1','141','764',322,'Retail Sale Id 1546834',7250.00,0.00,0.00,12.50,1150.00,'2022-01-18 11:39:08','',''),(2543487,'1','141','764',322,'Retail Sale Id 1546850',1160.00,0.00,0.00,2.00,184.00,'2022-01-18 11:40:34','',''),(2543498,'1','141','764',322,'Retail Sale Id 1546860',2320.00,0.00,0.00,4.00,368.00,'2022-01-18 11:41:38','',''),(2543504,'1','141','764',322,'Retail Sale Id 1546867',580.00,0.00,0.00,1.00,92.00,'2022-01-18 11:42:48','',''),(2543527,'1','141','764',322,'Retail Sale Id 1546885',2900.00,0.00,0.00,5.00,460.00,'2022-01-18 11:45:14','',''),(2543554,'1','141','764',322,'Retail Sale Id 1546903',1751.60,0.00,0.00,3.02,277.84,'2022-01-18 11:48:00','',''),(2543565,'1','141','764',322,'Retail Sale Id 1546915',85850.00,0.00,0.00,170.00,2890.00,'2022-01-18 11:50:04','',''),(2543647,'1','141','764',322,'Retail Sale Id 1547006',3480.00,0.00,0.00,6.00,552.00,'2022-01-18 12:02:39','',''),(2543653,'1','141','764',322,'Retail Sale Id 1547011',899.00,0.00,0.00,1.55,142.60,'2022-01-18 12:04:27','',''),(2543704,'1','141','764',322,'Retail Sale Id 1547064',748.20,0.00,0.00,1.29,118.68,'2022-01-18 12:10:06','',''),(2543719,'1','141','764',322,'Retail Sale Id 1547079',56812.50,0.00,0.00,112.50,1912.50,'2022-01-18 12:11:34','',''),(2543741,'1','141','764',322,'Retail Sale Id 1547102',138875.00,0.00,0.00,275.00,4675.00,'2022-01-18 12:14:40','',''),(2543781,'1','141','764',322,'Retail Sale Id 1547129',67417.50,0.00,0.00,133.50,2269.50,'2022-01-18 12:19:30','',''),(2543816,'1','141','764',322,'Retail Sale Id 1547169',5800.00,0.00,0.00,10.00,920.00,'2022-01-18 12:24:56','',''),(2543833,'1','141','764',322,'Retail Sale Id 1547183',3480.00,0.00,0.00,6.00,552.00,'2022-01-18 12:26:17','',''),(2543848,'1','141','764',322,'Retail Sale Id 1547198',5220.00,0.00,0.00,9.00,828.00,'2022-01-18 12:27:54','',''),(2543856,'1','141','764',322,'Retail Sale Id 1547210',4999.60,0.00,0.00,8.62,793.04,'2022-01-18 12:29:07','',''),(2543884,'1','141','764',322,'Retail Sale Id 1547233',1740.00,0.00,0.00,3.00,276.00,'2022-01-18 12:32:25','',''),(2543945,'1','141','764',322,'Retail Sale Id 1547298',6600.40,0.00,0.00,11.38,1046.96,'2022-01-18 12:38:28','',''),(2543981,'1','141','764',322,'Retail Sale Id 1547332',197455.00,0.00,0.00,391.00,6647.00,'2022-01-18 12:41:41','',''),(2544083,'1','141','764',322,'Retail Sale Id 1547437',5800.00,0.00,0.00,10.00,920.00,'2022-01-18 12:54:39','',''),(2544099,'1','141','764',322,'Retail Sale Id 1547451',36612.50,0.00,0.00,72.50,1232.50,'2022-01-18 12:56:47','',''),(2544110,'1','141','764',322,'Retail Sale Id 1547463',1502.20,0.00,0.00,2.59,238.28,'2022-01-18 12:58:33','',''),(2544130,'1','141','764',322,'Retail Sale Id 1547485',39390.00,0.00,0.00,78.00,1326.00,'2022-01-18 13:01:33','',''),(2544161,'1','141','764',322,'Retail Sale Id 1547518',2900.00,0.00,0.00,5.00,460.00,'2022-01-18 13:06:48','',''),(2544181,'1','141','764',322,'Retail Sale Id 1547537',1740.00,0.00,0.00,3.00,276.00,'2022-01-18 13:09:37','',''),(2544194,'1','141','764',322,'Retail Sale Id 1547556',6380.00,0.00,0.00,11.00,1012.00,'2022-01-18 13:11:49','',''),(2544276,'1','141','764',322,'Retail Sale Id 1547649',34340.00,0.00,0.00,68.00,1156.00,'2022-01-18 13:20:44','',''),(2544299,'1','141','764',322,'Retail Sale Id 1547672',2320.00,0.00,0.00,4.00,368.00,'2022-01-18 13:23:20','',''),(2544315,'1','141','764',322,'Retail Sale Id 1547684',151500.00,0.00,0.00,300.00,5100.00,'2022-01-18 13:25:30','',''),(2544321,'1','141','764',322,'Retail Sale Id 1547690',13635.00,0.00,0.00,27.00,459.00,'2022-01-18 13:26:25','',''),(2544334,'1','141','764',322,'Retail Sale Id 1547702',5050.00,0.00,0.00,10.00,170.00,'2022-01-18 13:28:17','',''),(2544371,'1','141','764',322,'Retail Sale Id 1547744',7250.00,0.00,0.00,12.50,1150.00,'2022-01-18 13:32:22','',''),(2544392,'1','141','764',322,'Retail Sale Id 1547767',82820.00,0.00,0.00,164.00,2788.00,'2022-01-18 13:34:23','',''),(2544412,'1','141','764',322,'Retail Sale Id 1547790',580.00,0.00,0.00,1.00,92.00,'2022-01-18 13:37:04','',''),(2544418,'1','141','764',322,'Retail Sale Id 1547798',1740.00,0.00,0.00,3.00,276.00,'2022-01-18 13:38:08','',''),(2544424,'1','141','764',322,'Retail Sale Id 1547803',66155.00,0.00,0.00,131.00,2227.00,'2022-01-18 13:39:10','',''),(2544446,'1','141','764',322,'Retail Sale Id 1547822',50500.00,0.00,0.00,100.00,1700.00,'2022-01-18 13:41:39','',''),(2544469,'1','141','764',322,'Retail Sale Id 1547847',90900.00,0.00,0.00,180.00,3060.00,'2022-01-18 13:44:04','',''),(2544490,'1','141','764',322,'Retail Sale Id 1547866',6312.50,0.00,0.00,12.50,212.50,'2022-01-18 13:46:10','',''),(2544504,'1','141','764',322,'Retail Sale Id 1547878',14210.00,0.00,0.00,24.50,2254.00,'2022-01-18 13:47:44','',''),(2544525,'1','141','764',322,'Retail Sale Id 1547897',2900.00,0.00,0.00,5.00,460.00,'2022-01-18 13:50:03','',''),(2544543,'1','141','764',322,'Retail Sale Id 1547912',101000.00,0.00,0.00,200.00,3400.00,'2022-01-18 13:52:36','',''),(2544691,'1','141','764',322,'Retail Sale Id 1548058',51005.00,0.00,0.00,101.00,1717.00,'2022-01-18 14:08:35','',''),(2544749,'1','141','764',322,'Retail Sale Id 1548105',17927.50,0.00,0.00,35.50,603.50,'2022-01-18 14:14:51','',''),(2544763,'1','141','764',322,'Retail Sale Id 1548119',580.00,0.00,0.00,1.00,92.00,'2022-01-18 14:16:24','',''),(2544776,'1','141','764',322,'Retail Sale Id 1548127',110595.00,0.00,0.00,219.00,3723.00,'2022-01-18 14:17:15','',''),(2544945,'1','141','764',322,'Retail Sale Id 1548275',839815.00,0.00,0.00,1663.00,28271.00,'2022-01-18 14:35:39','',''),(2544959,'1','141','764',322,'Retail Sale Id 1548288',12180.00,0.00,0.00,21.00,1932.00,'2022-01-18 14:36:26','',''),(2544970,'1','141','764',322,'Return of Retail Sale Id 1548288',0.00,12180.00,21.00,0.00,-1932.00,'2022-01-18 14:37:21','',''),(2544979,'1','141','764',322,'Retail Sale Id 1548304',11890.00,0.00,0.00,20.50,1886.00,'2022-01-18 14:38:17','',''),(2545258,'1','141','764',322,'Retail Sale Id 1548515',2900.00,0.00,0.00,5.00,460.00,'2022-01-18 15:00:28','',''),(2545270,'1','141','764',322,'Retail Sale Id 1548529',8700.00,0.00,0.00,15.00,1380.00,'2022-01-18 15:01:57','',''),(2545292,'1','141','764',322,'Retail Sale Id 1548539',2001.00,0.00,0.00,3.45,317.40,'2022-01-18 15:03:09','',''),(2545301,'1','141','764',322,'Retail Sale Id 1548548',1160.00,0.00,0.00,2.00,184.00,'2022-01-18 15:04:11','',''),(2545317,'1','141','764',322,'Retail Sale Id 1548564',49742.50,0.00,0.00,98.50,1674.50,'2022-01-18 15:05:35','',''),(2545349,'1','141','764',322,'Retail Sale Id 1548589',997.60,0.00,0.00,1.72,158.24,'2022-01-18 15:08:17','',''),(2545362,'1','141','764',322,'Retail Sale Id 1548598',1160.00,0.00,0.00,2.00,184.00,'2022-01-18 15:09:27','',''),(2545394,'1','141','764',322,'Retail Sale Id 1548628',33330.00,0.00,0.00,66.00,1122.00,'2022-01-18 15:12:34','',''),(2545421,'1','141','764',322,'Retail Sale Id 1548644',1740.00,0.00,0.00,3.00,276.00,'2022-01-18 15:14:34','',''),(2545445,'1','141','764',322,'Retail Sale Id 1548657',1160.00,0.00,0.00,2.00,184.00,'2022-01-18 15:16:24','',''),(2545468,'1','141','764',322,'Retail Sale Id 1548685',2499.80,0.00,0.00,4.31,396.52,'2022-01-18 15:20:00','',''),(2545477,'1','141','764',322,'Retail Sale Id 1548695',2900.00,0.00,0.00,5.00,460.00,'2022-01-18 15:21:20','',''),(2545493,'1','141','764',322,'Retail Sale Id 1548712',2900.00,0.00,0.00,5.00,460.00,'2022-01-18 15:22:44','',''),(2545510,'1','141','764',322,'Retail Sale Id 1548728',997.60,0.00,0.00,1.72,158.24,'2022-01-18 15:24:36','',''),(2545560,'1','141','764',322,'Retail Sale Id 1548734',1160.00,0.00,0.00,2.00,184.00,'2022-01-18 15:25:49','',''),(2545575,'1','141','764',322,'Retail Sale Id 1548751',64640.00,0.00,0.00,128.00,2176.00,'2022-01-18 15:27:40','',''),(2545611,'1','141','764',322,'Retail Sale Id 1548787',1160.00,0.00,0.00,2.00,184.00,'2022-01-18 15:31:39','',''),(2545626,'1','141','764',322,'Retail Sale Id 1548802',3480.00,0.00,0.00,6.00,552.00,'2022-01-18 15:33:16','',''),(2545658,'1','141','764',322,'Retail Sale Id 1548824',30300.00,0.00,0.00,60.00,1020.00,'2022-01-18 15:35:32','',''),(2545821,'1','141','764',322,'Retail Sale Id 1548966',2320.00,0.00,0.00,4.00,368.00,'2022-01-18 15:51:00','',''),(2545897,'1','141','764',322,'Retail Sale Id 1549021',2998.60,0.00,0.00,5.17,475.64,'2022-01-18 15:55:27','',''),(2545906,'1','141','764',322,'Retail Sale Id 1549034',25250.00,0.00,0.00,50.00,850.00,'2022-01-18 15:56:25','',''),(2545960,'1','141','764',322,'Retail Sale Id 1549068',39895.00,0.00,0.00,79.00,1343.00,'2022-01-18 16:01:19','',''),(2546023,'1','141','764',322,'Retail Sale Id 1549112',7575.00,0.00,0.00,15.00,255.00,'2022-01-18 16:07:10','',''),(2546033,'1','141','764',322,'Retail Sale Id 1549128',1740.00,0.00,0.00,3.00,276.00,'2022-01-18 16:08:24','',''),(2546049,'1','141','764',322,'Retail Sale Id 1549151',6670.00,0.00,0.00,11.50,1058.00,'2022-01-18 16:10:16','',''),(2546078,'1','141','764',322,'Retail Sale Id 1549182',1740.00,0.00,0.00,3.00,276.00,'2022-01-18 16:12:56','',''),(2546087,'1','141','764',322,'Retail Sale Id 1549194',1740.00,0.00,0.00,3.00,276.00,'2022-01-18 16:14:03','',''),(2546097,'1','141','764',322,'Retail Sale Id 1549205',580.00,0.00,0.00,1.00,92.00,'2022-01-18 16:15:13','',''),(2546122,'1','141','764',322,'Retail Sale Id 1549214',899.00,0.00,0.00,1.55,142.60,'2022-01-18 16:16:24','',''),(2546133,'1','141','764',322,'Retail Sale Id 1549225',1502.20,0.00,0.00,2.59,238.28,'2022-01-18 16:18:16','',''),(2546141,'1','141','764',322,'Retail Sale Id 1549235',2610.00,0.00,0.00,4.50,414.00,'2022-01-18 16:19:25','',''),(2546167,'1','141','764',322,'Retail Sale Id 1549266',88375.00,0.00,0.00,175.00,2975.00,'2022-01-18 16:22:14','',''),(2546182,'1','141','764',322,'Retail Sale Id 1549286',7250.00,0.00,0.00,12.50,1150.00,'2022-01-18 16:23:49','',''),(2546232,'1','141','764',322,'Retail Sale Id 1549336',26260.00,0.00,0.00,52.00,884.00,'2022-01-18 16:29:07','',''),(2546253,'1','141','764',322,'Retail Sale Id 1549359',1740.00,0.00,0.00,3.00,276.00,'2022-01-18 16:32:05','',''),(2547980,'1','141','764',322,'Retail Sale Id 1551042',7250.00,0.00,0.00,12.50,1150.00,'2022-01-18 20:15:44','',''),(2547981,'1','141','764',322,'Retail Sale Id 1551043',7250.00,0.00,0.00,12.50,1150.00,'2022-01-18 20:16:41','',''),(2547984,'1','141','764',322,'Retail Sale Id 1551044',7250.00,0.00,0.00,12.50,1150.00,'2022-01-18 20:17:53','',''),(2547985,'1','141','764',322,'Retail Sale Id 1551045',7250.00,0.00,0.00,12.50,1150.00,'2022-01-18 20:18:53','',''),(2547986,'1','141','764',322,'Retail Sale Id 1551047',8120.00,0.00,0.00,14.00,1288.00,'2022-01-18 20:20:53','',''),(2547987,'1','141','764',322,'Retail Sale Id 1551048',252500.00,0.00,0.00,500.00,8500.00,'2022-01-18 20:21:56','',''),(2547989,'1','141','764',322,'Retail Sale Id 1551049',252500.00,0.00,0.00,500.00,8500.00,'2022-01-18 20:23:23','',''),(2547990,'1','141','764',322,'Retail Sale Id 1551050',55550.00,0.00,0.00,110.00,1870.00,'2022-01-18 20:24:55','',''),(2548880,'1','141','764',322,'Retail Sale Id 1551439',7250.00,0.00,0.00,12.50,1150.00,'2022-01-19 08:09:23','',''),(2548890,'1','141','764',322,'Retail Sale Id 1551447',7250.00,0.00,0.00,12.50,1150.00,'2022-01-19 08:10:15','',''),(2548906,'1','141','764',322,'Retail Sale Id 1551463',7540.00,0.00,0.00,13.00,1196.00,'2022-01-19 08:12:01','',''),(2548927,'1','141','764',322,'Retail Sale Id 1551479',7250.00,0.00,0.00,12.50,1150.00,'2022-01-19 08:14:21','',''),(2548948,'1','141','764',322,'Retail Sale Id 1551507',45450.00,0.00,0.00,90.00,1530.00,'2022-01-19 08:16:04','',''),(2548956,'1','141','764',322,'Retail Sale Id 1551515',1740.00,0.00,0.00,3.00,276.00,'2022-01-19 08:17:18','',''),(2548978,'1','141','764',322,'Retail Sale Id 1551537',40400.00,0.00,0.00,80.00,1360.00,'2022-01-19 08:19:24','',''),(2548995,'1','141','764',322,'Retail Sale Id 1551555',3480.00,0.00,0.00,6.00,552.00,'2022-01-19 08:21:09','',''),(2549018,'1','141','764',322,'Retail Sale Id 1551577',388850.00,0.00,0.00,770.00,13090.00,'2022-01-19 08:23:56','',''),(2549032,'1','141','764',322,'Retail Sale Id 1551591',30805.00,0.00,0.00,61.00,1037.00,'2022-01-19 08:25:22','',''),(2549051,'1','141','764',322,'Retail Sale Id 1551614',2998.60,0.00,0.00,5.17,475.64,'2022-01-19 08:27:58','',''),(2549084,'1','141','764',322,'Retail Sale Id 1551644',7250.00,0.00,0.00,12.50,1150.00,'2022-01-19 08:31:09','',''),(2549146,'1','141','764',322,'Retail Sale Id 1551711',169932.50,0.00,0.00,336.50,5720.50,'2022-01-19 08:36:42','',''),(2549214,'1','141','764',322,'Retail Sale Id 1551762',50500.00,0.00,0.00,100.00,1700.00,'2022-01-19 08:41:24','',''),(2549333,'1','141','764',322,'Retail Sale Id 1551867',147965.00,0.00,0.00,293.00,4981.00,'2022-01-19 08:51:31','',''),(2549365,'1','141','764',322,'Retail Sale Id 1551899',42672.50,0.00,0.00,84.50,1436.50,'2022-01-19 08:53:56','',''),(2549414,'1','141','764',322,'Retail Sale Id 1551945',65650.00,0.00,0.00,130.00,2210.00,'2022-01-19 08:57:37','',''),(2549486,'1','141','764',322,'Retail Sale Id 1551995',1740.00,0.00,0.00,3.00,276.00,'2022-01-19 09:02:14','',''),(2549533,'1','141','764',322,'Retail Sale Id 1552036',2320.00,0.00,0.00,4.00,368.00,'2022-01-19 09:05:48','',''),(2549560,'1','141','764',322,'Retail Sale Id 1552054',580.00,0.00,0.00,1.00,92.00,'2022-01-19 09:07:06','',''),(2549569,'1','141','764',322,'Retail Sale Id 1552064',580.00,0.00,0.00,1.00,92.00,'2022-01-19 09:08:23','',''),(2549605,'1','141','764',322,'Retail Sale Id 1552103',29290.00,0.00,0.00,58.00,986.00,'2022-01-19 09:11:51','',''),(2549645,'1','141','764',322,'Retail Sale Id 1552145',61357.50,0.00,0.00,121.50,2065.50,'2022-01-19 09:15:24','',''),(2549698,'1','141','764',322,'Retail Sale Id 1552178',598930.00,0.00,0.00,1186.00,20162.00,'2022-01-19 09:18:30','',''),(2549739,'1','141','764',322,'Retail Sale Id 1552205',5800.00,0.00,0.00,10.00,920.00,'2022-01-19 09:22:11','',''),(2549795,'1','141','764',322,'Retail Sale Id 1552258',3480.00,0.00,0.00,6.00,552.00,'2022-01-19 09:26:35','',''),(2549817,'1','141','764',322,'Retail Sale Id 1552277',1740.00,0.00,0.00,3.00,276.00,'2022-01-19 09:28:35','',''),(2549871,'1','141','764',322,'Retail Sale Id 1552327',50500.00,0.00,0.00,100.00,1700.00,'2022-01-19 09:33:11','',''),(2549957,'1','141','764',322,'Retail Sale Id 1552414',269417.50,0.00,0.00,533.50,9069.50,'2022-01-19 09:40:34','',''),(2550016,'1','141','764',322,'Retail Sale Id 1552473',4002.00,0.00,0.00,6.90,634.80,'2022-01-19 09:46:17','',''),(2550048,'1','141','764',322,'Retail Sale Id 1552509',50500.00,0.00,0.00,100.00,1700.00,'2022-01-19 09:49:05','',''),(2550074,'1','141','764',322,'Retail Sale Id 1552530',73730.00,0.00,0.00,146.00,2482.00,'2022-01-19 09:51:59','',''),(2550102,'1','141','764',322,'Retail Sale Id 1552552',7250.00,0.00,0.00,12.50,1150.00,'2022-01-19 09:54:57','',''),(2550120,'1','141','764',322,'Retail Sale Id 1552574',6817.50,0.00,0.00,13.50,229.50,'2022-01-19 09:56:58','',''),(2550143,'1','141','764',322,'Retail Sale Id 1552600',141400.00,0.00,0.00,280.00,4760.00,'2022-01-19 09:59:20','',''),(2550190,'1','141','764',322,'Retail Sale Id 1552633',87870.00,0.00,0.00,174.00,2958.00,'2022-01-19 10:04:04','',''),(2550204,'1','141','764',322,'Retail Sale Id 1552654',138875.00,0.00,0.00,275.00,4675.00,'2022-01-19 10:06:02','',''),(2550272,'1','141','764',322,'Return of Retail Sale Id 1552414',0.00,269417.50,533.50,0.00,-9069.50,'2022-01-19 10:12:27','',''),(2552642,'1','141','764',322,'Retail Sale Id 1555016',23200.00,0.00,0.00,40.00,3680.00,'2022-01-19 14:34:31','',''),(2552671,'1','141','764',322,'Retail Sale Id 1555065',127916.50,0.00,0.00,253.30,4306.10,'2022-01-19 14:37:22','',''),(2556540,'1','141','764',322,'Distributed to OPERATIONAL LOSS for sales id:347577',140056.00,0.00,0.00,287.00,0.00,'2022-01-20 08:07:11','',''),(2556611,'1','141',NULL,322,'Purchased from AA RANO NIGERIA LIMITED',0.00,12214640.00,25030.00,0.00,0.00,'2022-01-20 08:13:07','',''),(2556641,'1','141',NULL,322,'Returned purchase #89946 to AA RANO NIGERIA LIMITED',12214640.00,0.00,0.00,25030.00,0.00,'2022-01-20 08:17:25','',''),(2556676,'1','141',NULL,322,'Purchased from AA RANO NIGERIA LIMITED',0.00,12200000.00,25000.00,0.00,0.00,'2022-01-20 08:20:56','',''),(2556695,'1','141',NULL,322,'Reception corrector for bridging 131445',0.00,0.00,0.00,25000.00,0.00,'2022-01-20 08:22:16','',''),(2556696,'1','141','764',322,'Received from bridging 131445',0.00,0.00,25000.00,0.00,0.00,'2022-01-20 08:22:16','',''),(2556703,'1','141','764',322,'Retail Sale Id 1558294',282042.50,0.00,0.00,558.50,9494.50,'2022-01-20 08:23:06','',''),(2556724,'1','141','764',322,'Retail Sale Id 1558363',70195.00,0.00,0.00,139.00,2363.00,'2022-01-20 08:25:39','',''),(2556747,'1','141','764',322,'Retail Sale Id 1558382',10100.00,0.00,0.00,20.00,340.00,'2022-01-20 08:28:54','',''),(2556758,'1','141','764',322,'Retail Sale Id 1558394',2900.00,0.00,0.00,5.00,460.00,'2022-01-20 08:30:10','',''),(2556775,'1','141','764',322,'Retail Sale Id 1558417',2401.20,0.00,0.00,4.14,380.88,'2022-01-20 08:32:00','',''),(2556782,'1','141','764',322,'Retail Sale Id 1558425',1160.00,0.00,0.00,2.00,184.00,'2022-01-20 08:32:48','',''),(2556795,'1','141','764',322,'Retail Sale Id 1558438',2001.00,0.00,0.00,3.45,317.40,'2022-01-20 08:34:02','',''),(2556840,'1','141','764',322,'Retail Sale Id 1558484',4999.60,0.00,0.00,8.62,793.04,'2022-01-20 08:38:23','',''),(2556864,'1','141','764',322,'Retail Sale Id 1558503',55045.00,0.00,0.00,109.00,1853.00,'2022-01-20 08:40:30','',''),(2556922,'1','141','764',322,'Retail Sale Id 1558528',76002.50,0.00,0.00,150.50,2558.50,'2022-01-20 08:45:09','',''),(2556959,'1','141','764',322,'Retail Sale Id 1558571',1740.00,0.00,0.00,3.00,276.00,'2022-01-20 08:48:22','',''),(2556971,'1','141','764',322,'Retail Sale Id 1558584',122210.00,0.00,0.00,242.00,4114.00,'2022-01-20 08:49:48','',''),(2557025,'1','141','764',322,'Retail Sale Id 1558623',1699.40,0.00,0.00,2.93,269.56,'2022-01-20 08:52:59','',''),(2557049,'1','141','764',322,'Retail Sale Id 1558635',5800.00,0.00,0.00,10.00,920.00,'2022-01-20 08:54:21','',''),(2557066,'1','141','764',322,'Retail Sale Id 1558652',1160.00,0.00,0.00,2.00,184.00,'2022-01-20 08:55:37','',''),(2557088,'1','141','764',322,'Retail Sale Id 1558676',3480.00,0.00,0.00,6.00,552.00,'2022-01-20 08:56:53','',''),(2557115,'1','141','764',322,'Retail Sale Id 1558691',1160.00,0.00,0.00,2.00,184.00,'2022-01-20 08:58:09','',''),(2557137,'1','141','764',322,'Retail Sale Id 1558706',10605.00,0.00,0.00,21.00,357.00,'2022-01-20 08:59:36','',''),(2557157,'1','141','764',322,'Retail Sale Id 1558723',75750.00,0.00,0.00,150.00,2550.00,'2022-01-20 09:01:12','',''),(2557191,'1','141','764',322,'Retail Sale Id 1558749',55550.00,0.00,0.00,110.00,1870.00,'2022-01-20 09:03:22','',''),(2557227,'1','141','764',322,'Retail Sale Id 1558782',1502.20,0.00,0.00,2.59,238.28,'2022-01-20 09:06:26','',''),(2557296,'1','141','764',322,'Retail Sale Id 1558802',86355.00,0.00,0.00,171.00,2907.00,'2022-01-20 09:08:45','',''),(2557321,'1','141','764',322,'Retail Sale Id 1558827',90900.00,0.00,0.00,180.00,3060.00,'2022-01-20 09:10:03','',''),(2557387,'1','141','764',322,'Retail Sale Id 1558881',7250.00,0.00,0.00,12.50,1150.00,'2022-01-20 09:15:28','',''),(2557412,'1','141','764',322,'Retail Sale Id 1558893',2320.00,0.00,0.00,4.00,368.00,'2022-01-20 09:16:43','',''),(2557417,'1','141','764',322,'Retail Sale Id 1558900',2900.00,0.00,0.00,5.00,460.00,'2022-01-20 09:17:46','',''),(2557439,'1','141','764',322,'Retail Sale Id 1558929',2900.00,0.00,0.00,5.00,460.00,'2022-01-20 09:19:15','',''),(2557461,'1','141','764',322,'Retail Sale Id 1558951',3480.00,0.00,0.00,6.00,552.00,'2022-01-20 09:21:47','',''),(2557510,'1','141','764',322,'Retail Sale Id 1559008',101252.50,0.00,0.00,200.50,3408.50,'2022-01-20 09:27:29','',''),(2557540,'1','141','764',322,'Retail Sale Id 1559030',89890.00,0.00,0.00,178.00,3026.00,'2022-01-20 09:30:02','',''),(2557557,'1','141','764',322,'Retail Sale Id 1559047',2900.00,0.00,0.00,5.00,460.00,'2022-01-20 09:31:11','',''),(2557582,'1','141','764',322,'Retail Sale Id 1559078',22725.00,0.00,0.00,45.00,765.00,'2022-01-20 09:33:36','',''),(2557608,'1','141','764',322,'Retail Sale Id 1559106',55550.00,0.00,0.00,110.00,1870.00,'2022-01-20 09:36:22','',''),(2557630,'1','141','764',322,'Retail Sale Id 1559136',3480.00,0.00,0.00,6.00,552.00,'2022-01-20 09:39:37','',''),(2557637,'1','141','764',322,'Retail Sale Id 1559141',1160.00,0.00,0.00,2.00,184.00,'2022-01-20 09:40:26','',''),(2557654,'1','141','764',322,'Retail Sale Id 1559158',1740.00,0.00,0.00,3.00,276.00,'2022-01-20 09:41:54','',''),(2557671,'1','141','764',322,'Retail Sale Id 1559180',5800.00,0.00,0.00,10.00,920.00,'2022-01-20 09:43:10','',''),(2557691,'1','141','764',322,'Retail Sale Id 1559199',51762.50,0.00,0.00,102.50,1742.50,'2022-01-20 09:44:41','',''),(2557740,'1','141','764',322,'Retail Sale Id 1559254',3480.00,0.00,0.00,6.00,552.00,'2022-01-20 09:49:40','',''),(2557754,'1','141','764',322,'Retail Sale Id 1559269',24745.00,0.00,0.00,49.00,833.00,'2022-01-20 09:51:28','',''),(2557789,'1','141','764',322,'Retail Sale Id 1559303',26512.50,0.00,0.00,52.50,892.50,'2022-01-20 09:54:45','',''),(2557835,'1','141','764',322,'Retail Sale Id 1559351',1160.00,0.00,0.00,2.00,184.00,'2022-01-20 09:58:43','',''),(2557868,'1','141','764',322,'Retail Sale Id 1559373',50500.00,0.00,0.00,100.00,1700.00,'2022-01-20 10:00:21','',''),(2557905,'1','141','764',322,'Retail Sale Id 1559411',20200.00,0.00,0.00,40.00,680.00,'2022-01-20 10:04:56','',''),(2557927,'1','141','764',322,'Retail Sale Id 1559433',1160.00,0.00,0.00,2.00,184.00,'2022-01-20 10:07:21','',''),(2557965,'1','141','764',322,'Retail Sale Id 1559457',58075.00,0.00,0.00,115.00,1955.00,'2022-01-20 10:09:10','',''),(2558021,'1','141','764',322,'Retail Sale Id 1559500',101000.00,0.00,0.00,200.00,3400.00,'2022-01-20 10:13:51','',''),(2558163,'1','141','764',322,'Retail Sale Id 1559621',74235.00,0.00,0.00,147.00,2499.00,'2022-01-20 10:24:20','',''),(2558196,'1','141','764',322,'Retail Sale Id 1559629',30300.00,0.00,0.00,60.00,1020.00,'2022-01-20 10:25:41','',''),(2558238,'1','141','764',322,'Retail Sale Id 1559689',7250.00,0.00,0.00,12.50,1150.00,'2022-01-20 10:29:40','',''),(2558258,'1','141','764',322,'Retail Sale Id 1559705',50500.00,0.00,0.00,100.00,1700.00,'2022-01-20 10:30:58','',''),(2558347,'1','141','764',322,'Retail Sale Id 1559741',55550.00,0.00,0.00,110.00,1870.00,'2022-01-20 10:33:56','',''),(2558425,'1','141','764',322,'Retail Sale Id 1559795',649.60,0.00,0.00,1.12,103.04,'2022-01-20 10:37:56','',''),(2558448,'1','141','764',322,'Retail Sale Id 1559812',3480.00,0.00,0.00,6.00,552.00,'2022-01-20 10:39:10','',''),(2558464,'1','141','764',322,'Retail Sale Id 1559828',7250.00,0.00,0.00,12.50,1150.00,'2022-01-20 10:40:24','',''),(2558478,'1','141','764',322,'Retail Sale Id 1559837',1740.00,0.00,0.00,3.00,276.00,'2022-01-20 10:41:28','',''),(2558489,'1','141','764',322,'Retail Sale Id 1559849',2320.00,0.00,0.00,4.00,368.00,'2022-01-20 10:42:34','',''),(2558504,'1','141','764',322,'Retail Sale Id 1559863',1740.00,0.00,0.00,3.00,276.00,'2022-01-20 10:43:49','',''),(2558527,'1','141','764',322,'Retail Sale Id 1559883',11110.00,0.00,0.00,22.00,374.00,'2022-01-20 10:45:44','',''),(2558551,'1','141','764',322,'Retail Sale Id 1559906',75750.00,0.00,0.00,150.00,2550.00,'2022-01-20 10:48:05','',''),(2558587,'1','141','764',322,'Retail Sale Id 1559942',5807.50,0.00,0.00,11.50,195.50,'2022-01-20 10:51:31','',''),(2558604,'1','141','764',322,'Retail Sale Id 1559959',2900.00,0.00,0.00,5.00,460.00,'2022-01-20 10:52:53','',''),(2558640,'1','141','764',322,'Retail Sale Id 1559999',128270.00,0.00,0.00,254.00,4318.00,'2022-01-20 10:55:15','',''),(2558718,'1','141','764',322,'Retail Sale Id 1560085',7250.00,0.00,0.00,12.50,1150.00,'2022-01-20 11:03:51','',''),(2558742,'1','141','764',322,'Retail Sale Id 1560131',3480.00,0.00,0.00,6.00,552.00,'2022-01-20 11:06:37','',''),(2558772,'1','141','764',322,'Retail Sale Id 1560157',997.60,0.00,0.00,1.72,158.24,'2022-01-20 11:10:29','',''),(2558792,'1','141','764',322,'Retail Sale Id 1560177',2320.00,0.00,0.00,4.00,368.00,'2022-01-20 11:12:14','',''),(2558814,'1','141','764',322,'Retail Sale Id 1560200',6565.00,0.00,0.00,13.00,221.00,'2022-01-20 11:14:04','',''),(2558834,'1','141','764',322,'Retail Sale Id 1560221',2900.00,0.00,0.00,5.00,460.00,'2022-01-20 11:15:55','',''),(2558843,'1','141','764',322,'Retail Sale Id 1560235',37875.00,0.00,0.00,75.00,1275.00,'2022-01-20 11:17:06','',''),(2558878,'1','141','764',322,'Retail Sale Id 1560271',1160.00,0.00,0.00,2.00,184.00,'2022-01-20 11:21:02','',''),(2558894,'1','141','764',322,'Retail Sale Id 1560291',800.40,0.00,0.00,1.38,126.96,'2022-01-20 11:23:01','',''),(2558909,'1','141','764',322,'Retail Sale Id 1560307',151500.00,0.00,0.00,300.00,5100.00,'2022-01-20 11:24:29','',''),(2558918,'1','141','764',322,'Retail Sale Id 1560316',1160.00,0.00,0.00,2.00,184.00,'2022-01-20 11:25:32','',''),(2558940,'1','141','764',322,'Retail Sale Id 1560343',50500.00,0.00,0.00,100.00,1700.00,'2022-01-20 11:27:54','',''),(2559069,'1','141','764',322,'Retail Sale Id 1560470',1160.00,0.00,0.00,2.00,184.00,'2022-01-20 11:39:16','',''),(2559108,'1','141','764',322,'Retail Sale Id 1560502',6380.00,0.00,0.00,11.00,1012.00,'2022-01-20 11:43:29','',''),(2559145,'1','141','764',322,'Retail Sale Id 1560543',6565.00,0.00,0.00,13.00,221.00,'2022-01-20 11:47:44','',''),(2559167,'1','141','764',322,'Retail Sale Id 1560567',26260.00,0.00,0.00,52.00,884.00,'2022-01-20 11:49:26','',''),(2559202,'1','141','764',322,'Retail Sale Id 1560600',2320.00,0.00,0.00,4.00,368.00,'2022-01-20 11:51:52','',''),(2559227,'1','141','764',322,'Retail Sale Id 1560625',2900.00,0.00,0.00,5.00,460.00,'2022-01-20 11:54:53','',''),(2559241,'1','141','764',322,'Retail Sale Id 1560644',1160.00,0.00,0.00,2.00,184.00,'2022-01-20 11:56:49','',''),(2559278,'1','141','764',322,'Retail Sale Id 1560684',1740.00,0.00,0.00,3.00,276.00,'2022-01-20 12:00:36','',''),(2559294,'1','141','764',322,'Retail Sale Id 1560707',2001.00,0.00,0.00,3.45,317.40,'2022-01-20 12:02:07','',''),(2559323,'1','141','764',322,'Retail Sale Id 1560737',33835.00,0.00,0.00,67.00,1139.00,'2022-01-20 12:04:38','',''),(2559352,'1','141','764',322,'Retail Sale Id 1560768',2900.00,0.00,0.00,5.00,460.00,'2022-01-20 12:07:46','',''),(2559378,'1','141','764',322,'Retail Sale Id 1560804',580.00,0.00,0.00,1.00,92.00,'2022-01-20 12:11:14','',''),(2559387,'1','141','764',322,'Retail Sale Id 1560808',1740.00,0.00,0.00,3.00,276.00,'2022-01-20 12:12:28','',''),(2559455,'1','141','764',322,'Retail Sale Id 1560890',1948.80,0.00,0.00,3.36,309.12,'2022-01-20 12:20:13','',''),(2559485,'1','141','764',322,'Retail Sale Id 1560917',1798.00,0.00,0.00,3.10,285.20,'2022-01-20 12:22:18','',''),(2559510,'1','141','764',322,'Retail Sale Id 1560946',29037.50,0.00,0.00,57.50,977.50,'2022-01-20 12:25:21','',''),(2559551,'1','141','764',322,'Retail Sale Id 1560995',1160.00,0.00,0.00,2.00,184.00,'2022-01-20 12:29:48','',''),(2559559,'1','141','764',322,'Retail Sale Id 1561004',46965.00,0.00,0.00,93.00,1581.00,'2022-01-20 12:30:51','',''),(2559649,'1','141','764',322,'Retail Sale Id 1561083',1160.00,0.00,0.00,2.00,184.00,'2022-01-20 12:39:04','',''),(2559681,'1','141','764',322,'Retail Sale Id 1561114',951.20,0.00,0.00,1.64,150.88,'2022-01-20 12:43:12','',''),(2559693,'1','141','764',322,'Retail Sale Id 1561121',1502.20,0.00,0.00,2.59,238.28,'2022-01-20 12:44:20','',''),(2559700,'1','141','764',322,'Retail Sale Id 1561129',3480.00,0.00,0.00,6.00,552.00,'2022-01-20 12:45:21','',''),(2559717,'1','141','764',322,'Retail Sale Id 1561142',2099.60,0.00,0.00,3.62,333.04,'2022-01-20 12:46:47','',''),(2559732,'1','141','764',322,'Retail Sale Id 1561158',126250.00,0.00,0.00,250.00,4250.00,'2022-01-20 12:48:13','',''),(2559782,'1','141','764',322,'Retail Sale Id 1561212',10150.00,0.00,0.00,17.50,1610.00,'2022-01-20 12:53:42','',''),(2559829,'1','141','764',322,'Retail Sale Id 1561271',138875.00,0.00,0.00,275.00,4675.00,'2022-01-20 12:59:10','',''),(2559850,'1','141','764',322,'Retail Sale Id 1561302',45450.00,0.00,0.00,90.00,1530.00,'2022-01-20 13:01:53','',''),(2559869,'1','141','7