-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_140
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_140`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_140` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_140`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3206 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2625,20013,'',0,'22','1','140','PURCHASES','','2020-08-10 22:41:46',5,0.00,0.00,'','479','2020-08-10 22:41:46','479',0,1),(2626,400098,'',0,'24','1','140','PURCHASES','','2020-08-10 22:42:03',5,0.00,0.00,'','479','2020-08-10 22:42:03','479',0,1),(2627,20021,'',0,'20','1','140','SALES','','2020-08-10 22:42:18',5,0.00,0.00,'','479','2020-08-10 22:42:18','479',0,1),(2628,40020,'',0,'6.1','1','140','CASH','','2020-08-10 22:42:34',5,0.00,0.00,'','479','2020-08-10 22:42:34','479',0,1),(2629,400099,'',0,'24','1','140','SALARIES & WAGES','','2020-08-10 22:42:55',5,0.00,0.00,'','479','2020-08-10 22:42:55','479',0,1),(2630,400231,'',0,'2','1','140','ZBN(POS):1015965368','','2020-08-10 22:43:20',5,0.00,0.00,'','479','2020-08-10 22:43:20','479',0,1),(2631,400232,'',0,'2','1','140','ZB(E-BILL)1015372548','','2020-08-10 22:43:44',5,0.00,0.00,'','479','2020-08-10 22:43:44','479',0,1),(2901,400318,'',0,'2','1','140','DANKANO-EBILLS(ZNB:1014717618)','','2020-10-29 13:34:02',5,0.00,0.00,'','489','2020-10-29 13:34:02','489',0,1),(3203,400482,'',0,'2','1','140','FID POS COLLECTION-5620141491','','2021-02-26 15:58:15',5,0.00,0.00,'','489','2021-02-26 15:58:15','489',0,1),(3204,400483,'',0,'2','1','140','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 15:34:36',5,0.00,0.00,'','792','2023-02-20 15:34:36','792',0,0),(3205,400484,'',0,'2','1','140','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:55:11',5,0.00,0.00,'2023-03-15','792','2023-03-17 14:14:07','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1824 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1656,'','1','140','ALL DEALERS','IBADAN CUSTOMER','07063283814','auwala28@gmail.com','IBADAN CITY','OYO STATE','IBADAN PLANT','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-09-03 14:55:48',5,'510','2022-02-21 12:36:02','510'),(1657,'','1','140','END USERS','IBADAN CUSTOMER','07063283814','auwala28@gmail.com','IBADAN CITY','OYO STATE','IBADAN PLANT','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-09-03 14:56:28',5,'510','2022-02-21 12:36:45','510'),(1749,'','1','140','OPERATIONAL LOSS','HAFIZ NURA','08069129774','hafiz@aaranonigeria.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2020-10-29 13:33:35',5,'489','2020-10-29 13:33:35','489'),(1750,'','1','140','OLA GAS','OLA DRIVER','00000000000','@ibadan','IBADAN CITY','OYO STATE','OYO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-21 12:38:33',5,'510','2022-02-21 12:38:33','510'),(1751,'','1','140','S.O GAS','MR S UNDAY ODUNAYO','00000000000','@ibadan','IBADAN CITY','OYO STATE','IBADAN ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-22 14:06:24',5,'510','2022-02-22 14:06:24','510'),(1752,'','1','140','SAMORAD GAS','MR SAMORAD OIL AND GAS','00000000000','@ibadan','IBADAN CITY','OYO STATE','IBADAN NIGERIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-22 14:08:09',5,'510','2022-02-22 14:08:09','510'),(1753,'','1','140','GLORIOUS GAS','MR GLORIOUS EKITI','00000000000','@ibadan','IBADAN CITY','OYO STATE','EKITI STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-22 14:14:39',5,'510','2022-02-22 14:14:39','510'),(1754,'','1','140','AKINSCO GAS','AKIN MOKWA','00000000000','@ibadan ','MOKWA','NIGER','MOKWA NIGER STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-23 08:55:48',5,'510','2022-02-23 08:55:48','510'),(1755,'','1','140','royal gas','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','gate','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-19 12:46:10',5,'510','2022-08-19 12:46:10','510'),(1756,'','1','140','MAXI GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','AIRPORT','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-19 12:47:05',5,'510','2022-08-19 12:47:05','510'),(1757,'','1','140','A & T GAS EKITI','07063283814','00000000000','akindelekolawole94@yahoo.com','EKITI','ekiti','ekiti','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-19 17:56:50',5,'510','2022-08-19 17:56:50','510'),(1758,'','1','140','damsak gas','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','ibadan','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-24 17:18:12',5,'510','2022-08-24 17:18:12','510'),(1759,'','1','140','Ahmed Gas Ekiti','07063283814','07063283814','ezekielkolawole04@gmail.com','Ikere','Ekiti','Ekiti','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-30 06:29:33',5,'510','2022-08-30 06:29:33','510'),(1760,'','1','140','Michael Gas','07063283814','07063283814','ezekielkolawole04@gmail.com','Ikere','Ekiti','Ikere ekiti','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-30 06:30:19',5,'510','2022-08-30 06:30:19','510'),(1761,'','1','140','Spk gas','07063283814','07063283814','ezekielkolawole04@gmail.com','Ikere','Ekiti','Ikere ekiti','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-30 06:30:54',5,'510','2022-08-30 06:30:54','510'),(1762,'','1','140','Al auwal Gas','07063283814','07063283814','ezekielkolawole04@gmail.com','Ibadan','Oyo','IBADAN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-30 06:32:20',5,'510','2022-08-30 06:32:20','510'),(1763,'','1','140','NOBLE OJE GAS','07038651558','00000000000','','ibadan','oyo','IBADAN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-03 15:30:04',5,'510','2023-01-20 10:17:34','510'),(1764,'','1','140','FAITH GLORIA GAS','07067291366','07067291366','akindelekolawole94@yahoo.com','ibadan','OYO','E9/70 GBENLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-04 16:51:44',5,'510','2022-09-04 16:51:44','510'),(1765,'','1','140','Azuak gas','07063283814','07063283814','ezekielkolawole04@gmail.com','Ibadan','Oyo','Ibadan','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-06 08:55:22',5,'510','2022-09-06 08:55:22','510'),(1766,'','1','140','DIVINE GAS','08032700174','08032700174','akindelekolawole94@yahoo.com','ibadan','oyo','IBADAN IWO ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-13 08:58:33',5,'510','2022-09-13 09:39:08','510'),(1767,'','1','140','Y0UNG OLA GAS','07067073610','07067073610','akindelekolawole94@yahoo.com','ibadan','oyo','07067073610','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-17 14:20:00',5,'510','2022-09-17 14:20:00','510'),(1768,'','1','140','SURAJUDDEN GAS','08065081057','08065081057','akindelekolawole94@yahoo.com','ibadan','oyo','08065081057','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-19 07:30:05',5,'510','2022-09-19 07:30:05','510'),(1769,'','1','140','USEE Gas','08153527627','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','08153527627','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-19 11:51:21',5,'510','2022-09-19 11:51:21','510'),(1770,'','1','140','KAMRJ GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-23 13:44:04',5,'510','2022-09-23 13:44:04','510'),(1771,'','1','140','DAN YA BUSKE','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-24 12:38:33',5,'510','2022-09-24 12:38:33','510'),(1772,'','1','140','FGB GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-24 12:53:59',5,'510','2022-09-24 12:53:59','510'),(1773,'','1','140','REWARD GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','OYO IBADAN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-26 11:38:21',5,'510','2022-11-06 08:37:10','510'),(1774,'','1','140','GLORIOU GAS','08038666707','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','08038666707','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-28 11:34:30',5,'510','2022-09-28 11:34:30','510'),(1775,'','1','140','BIG T GAS','07063283814','70630283814','akindelekolawole94@yahoo.com','ibadan','oyo','70630283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-01 10:33:44',5,'510','2022-10-01 10:33:44','510'),(1776,'','1','140','WAZO GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-01 12:32:52',5,'510','2022-10-01 12:32:52','510'),(1777,'','1','140','OROLUWAN GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-05 07:41:16',5,'510','2022-10-05 07:41:16','510'),(1778,'','1','140','WATER LAND GAS','08059486375','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-05 08:27:19',5,'510','2022-10-05 08:27:19','510'),(1779,'','1','140','ABEE GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-08 10:50:32',5,'510','2022-10-08 10:50:32','510'),(1780,'','1','140','ADEE GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-09 10:05:27',5,'510','2022-10-09 10:05:27','510'),(1781,'','1','140','TOPMOST GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-09 16:08:27',5,'510','2022-10-09 16:08:27','510'),(1782,'','1','140','MAZEE GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-10 07:37:42',5,'510','2022-10-10 07:37:42','510'),(1783,'','1','140','ALI GAS','08132096409','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','NIGER BIDA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-11 07:18:54',5,'510','2022-10-11 07:18:54','510'),(1784,'','1','140','TY GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-11 16:39:30',5,'510','2022-10-11 16:39:30','510'),(1785,'','1','140','OLA BAMIJI GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-13 09:20:39',5,'510','2022-10-13 09:20:39','510'),(1786,'','1','140','NOBLE GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-15 13:03:09',5,'510','2022-10-15 13:03:09','510'),(1787,'','1','140','SEMORAD','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-18 07:42:56',5,'510','2022-10-18 07:42:56','510'),(1788,'','1','140','AUWAL GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-22 15:30:23',5,'510','2022-10-22 15:30:23','510'),(1789,'','1','140','WARIS GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-23 17:44:44',5,'510','2022-10-23 17:44:44','510'),(1790,'','1','140','FGC GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-25 12:20:43',5,'510','2022-10-25 12:20:43','510'),(1791,'','1','140','BIG JOE GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-25 14:28:20',5,'510','2022-10-25 14:28:20','510'),(1792,'','1','140','SCO GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-30 16:34:52',5,'510','2022-10-30 16:34:52','510'),(1793,'','1','140','AZIZAT','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-30 17:01:33',5,'510','2022-10-30 17:01:33','510'),(1794,'','1','140','JJ GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 07:09:04',5,'510','2022-10-31 07:09:04','510'),(1795,'','1','140','ALFA GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 11:31:48',5,'510','2022-10-31 11:31:48','510'),(1796,'','1','140','AMOTOS GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 13:25:41',5,'510','2022-10-31 13:25:41','510'),(1797,'','1','140','ID GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-01 14:20:33',5,'510','2022-11-01 14:20:33','510'),(1798,'','1','140','TLO GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-01 17:33:38',5,'510','2022-11-01 17:33:38','510'),(1799,'','1','140','SETH GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-02 09:04:03',5,'510','2022-11-11 07:32:46','510'),(1800,'','1','140','EASY','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-05 09:33:09',5,'510','2022-11-05 09:33:09','510'),(1801,'','1','140','ACHIEVEMENT','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','07063283814','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-06 14:08:10',5,'510','2022-11-06 14:08:10','510'),(1802,'','1','140','CROWN GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','IWO ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-08 15:15:04',5,'510','2022-11-08 15:15:04','510'),(1803,'','1','140','MICHEAL GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','akindelekolawole94@yahoo.com','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 12:52:56',5,'510','2022-11-22 12:52:56','510'),(1804,'','1','140','MUBAARAK GAS','07063283814','07063283814','','ibadan','oyo','','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 13:30:18',5,'510','2023-01-20 10:19:26','510'),(1805,'','1','140','OBA GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','akindelekolawole94@yahoo.com','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-24 08:32:06',5,'510','2022-11-24 08:32:06','510'),(1806,'','1','140','SAMUEL GAS','07063283814','07063283814','indelekolawole94@yaakhoo.com','ibadan','OYO','indelekolawole94@yaakhoo.com','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-26 09:14:53',5,'510','2022-11-26 09:14:53','510'),(1807,'','1','140','ALFA APETE GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','akindelekolawole94@yahoo.com','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-27 12:56:36',5,'510','2022-11-27 12:56:36','510'),(1808,'','1','140','A.Y ADEBAYO GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','akindelekolawole94@yahoo.com','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-27 15:24:50',5,'510','2022-11-27 15:24:50','510'),(1809,'','1','140','NEW DAWN GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','akindelekolawole94@yahoo.com','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-28 07:17:23',5,'510','2022-11-28 07:17:23','510'),(1810,'','1','140','TESTED OK GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','akindelekolawole94@yahoo.com','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-29 10:02:42',5,'510','2022-11-29 10:02:42','510'),(1811,'','1','140','QUSERA GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','akindelekolawole94@yahoo.com','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-03 14:56:08',5,'510','2022-12-03 14:56:08','510'),(1812,'','1','140','HABBIB GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','akindelekolawole94@yahoo.com','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-07 15:37:59',5,'510','2022-12-07 15:37:59','510'),(1813,'','1','140','ADE WALE GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','akindelekolawole94@yahoo.com','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-13 14:54:13',5,'510','2022-12-13 14:54:13','510'),(1814,'','1','140','INSHA ALLAH','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','akindelekolawole94@yahoo.com','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-25 14:16:48',5,'510','2022-12-25 14:16:48','510'),(1815,'','1','140','CROWN BOAD GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','akindelekolawole94@yahoo.com','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-02 08:16:19',5,'510','2023-01-02 08:16:19','510'),(1816,'','1','140','ADEE 99 GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','akindelekolawole94@yahoo.com','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-02 09:08:56',5,'510','2023-01-02 09:08:56','510'),(1817,'','1','140','SAMUAL GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','akindelekolawole94@yahoo.com','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-10 07:33:47',5,'510','2023-01-10 07:33:47','510'),(1818,'','1','140','MORE BLESSING GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','akindelekolawole94@yahoo.com','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-10 11:32:01',5,'510','2023-01-10 11:32:01','510'),(1819,'','1','140','MUHAMMAD GAS','','','','ibadan','oyo','','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-15 09:20:26',5,'510','2023-01-20 10:12:32','510'),(1820,'','1','140','RANO  GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','akindelekolawole94@yahoo.com','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-17 14:23:33',5,'510','2023-01-17 14:23:33','510'),(1821,'','1','140','BLAMELESS GAS','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','OYO','IBADAN','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-02 16:53:58',5,'510','2023-02-02 16:53:58','510'),(1822,'','1','140','sylvester','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','	\r\nakindelekolawole94@yahoo.com\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-11 14:37:17',5,'510','2023-02-11 14:37:17','510'),(1823,'','1','140','AFFORDABLE','07063283814','07063283814','akindelekolawole94@yahoo.com','ibadan','oyo','akindelekolawole94@yahoo.com','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-28 08:36:24',5,'510','2023-02-28 08:36:24','510');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16728 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','140',16358,'773',0.29,24691.00,'2021-09-08','new dipping','2021-09-08 18:08:28','483','483',2021,'483','2021-09-08 18:08:28',5),('1','140',16726,'773',199949.90,810.00,'2021-10-04','NEW','2021-10-04 14:12:54','483','483',2021,'483','2021-10-04 14:12:54',5),('1','140',16727,'773',24960.00,1.00,'2021-10-04','NEW','2021-10-04 14:31:50','483','483',2021,'483','2021-10-04 14:31:50',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2188 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','140','773',2144,'5','LPG NOZZLE ',5538000.97,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','140','773',2187,'5','LPG NOZZLE 2',1888.15,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257880 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','140',150308,'DAILY SALES','2020-08-01','2020-08-01 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-03 15:16:31','510','2020-09-03 15:16:56',10,0),('1','140',150313,'DAILY SALES','2020-08-02','2020-08-02 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-03 15:34:54','510','2020-09-03 15:35:17',10,0),('1','140',150317,'DAILY SALES','2020-08-03','2020-08-03 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-03 15:45:10','510','2020-09-03 15:45:38',10,0),('1','140',150319,'DAILY SALES','2020-08-04','2020-08-04 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-03 15:52:23','510','2020-09-03 16:00:31',10,0),('1','140',150322,'DAILY SALES','2020-08-03','2020-08-03 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-03 16:09:02','510','2020-09-03 16:09:27',10,0),('1','140',150326,'DAILY SALES','2020-08-04','2020-08-04 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-03 16:16:38','510','2020-09-03 16:16:56',10,0),('1','140',150605,'DAILY SALES','2020-08-05','2020-08-05 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-05 10:36:36','510','2020-09-05 10:37:08',10,0),('1','140',150610,'DAILY SALES','2020-08-06','2020-08-06 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-05 10:43:47','510','2020-09-05 10:44:09',10,0),('1','140',150614,'DAILY SALES','2020-08-07','2020-08-07 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-05 10:54:44','510','2020-09-05 10:55:24',10,0),('1','140',150616,'DAILY SALES','2020-08-08','2020-08-08 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-05 11:07:21','510','2020-09-05 11:07:50',10,0),('1','140',150617,'DAILY SALES','2020-08-09','2020-08-09 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-05 11:13:53','510','2020-09-05 11:14:23',10,0),('1','140',150717,'DAILY SALES','2020-08-10','2020-08-10 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-05 21:25:34','510','2020-09-05 21:26:07',10,0),('1','140',152271,'DAILY SALES','2020-08-11','2020-08-11 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-16 14:17:38','510','2020-09-16 14:18:33',10,0),('1','140',152272,'DAILY SALES','2020-08-12','2020-08-12 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-16 14:26:31','510','2020-09-16 14:26:54',10,0),('1','140',152280,'DAILY SALES','2020-08-13','2020-08-13 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-16 14:57:04','510','2020-09-16 15:00:11',10,0),('1','140',152287,'DAILY SALES','2020-08-14','2020-08-14 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-16 15:44:09','510','2020-09-16 15:44:35',10,0),('1','140',152298,'DAILY SALES','2020-08-15','2020-08-15 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-16 15:54:31','510','2020-09-16 15:54:56',10,0),('1','140',152582,'DAILY SALES','2020-08-16','2020-08-16 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-18 16:12:44','510','2020-09-18 16:13:11',10,0),('1','140',152584,'DAILY SALES','2020-08-17','2020-08-17 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-18 16:19:24','510','2020-09-18 16:19:47',10,0),('1','140',152586,'DAILY SALES','2020-08-18','2020-08-18 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-18 16:32:02','510','2020-09-18 16:32:29',10,0),('1','140',154102,'DAILY SALE  SHIFT','2020-08-19','2020-08-19 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-28 10:10:02','510','2020-09-28 10:10:24',10,0),('1','140',154110,'DAILY SALE  SHIFT','2020-08-20','2020-08-20 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-28 10:46:28','510','2020-09-28 10:46:48',10,0),('1','140',154116,'DAILY SALE  SHIFT','2020-08-21','2020-08-21 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-29 12:55:56','510','2020-09-29 12:56:31',10,0),('1','140',154336,'DAILY SALE  SHIFT','2020-08-22','2020-08-22 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-29 13:22:59','510','2020-09-29 13:23:25',10,0),('1','140',154339,'DAILY SALE  SHIFT','2020-08-23','2020-08-23 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-29 13:35:55','510','2020-09-29 13:36:19',10,0),('1','140',154344,'DAILY SALE  SHIFT','2020-09-29','2020-09-29 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-29 13:54:50','510','2020-09-29 13:56:46',10,0),('1','140',154351,'DAILY SALE  SHIFT','2020-08-25','2020-08-25 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-29 14:11:40','510','2020-09-29 14:12:09',10,0),('1','140',154357,'DAILY SALE  SHIFT','2020-08-26','2020-08-26 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-29 14:28:22','510','2020-09-29 14:28:51',10,0),('1','140',154363,'DAILY SALE  SHIFT','2020-09-29','2020-09-29 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-29 14:44:12','510','2020-09-29 14:44:39',10,0),('1','140',154365,'DAILY SALE  SHIFT','2020-08-27','2020-08-27 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-29 15:07:52','510','2020-09-29 15:08:12',10,0),('1','140',154367,'DAILY SALE  SHIFT','2020-09-29','2020-09-29 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-29 15:09:43','510','2020-09-29 15:10:24',10,0),('1','140',154368,'DAILY SALE  SHIFT','2020-08-28','2020-08-28 00:00:00',NULL,'510',0.00,0.00,'510','2020-09-29 15:22:46','510','2020-09-29 15:23:31',10,0),('1','140',155714,'DAILY SALES','2020-08-29','2020-08-29 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-08 13:53:11','510','2020-10-08 13:53:39',10,0),('1','140',156182,'DAILY SALES','2020-10-11','2020-10-11 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-11 16:03:38','510','2020-10-11 16:04:06',10,0),('1','140',157075,'DAILY SALES','2020-08-30','2020-08-30 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-16 18:37:19','510','2020-10-16 18:37:37',10,0),('1','140',157076,'DAILY SALES','2020-08-31','2020-08-31 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-16 18:43:06','510','2020-10-16 18:43:34',10,0),('1','140',157077,'DAILY SALES','2020-10-01','2020-10-01 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-16 18:47:32','510','2020-10-16 18:48:43',10,0),('1','140',157078,'DAILY SALES','2020-09-01','2020-09-01 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-16 18:56:01','510','2020-10-16 18:56:22',10,0),('1','140',157080,'DAILY SALES','2020-09-01','2020-09-01 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-16 19:43:32','510','2020-10-16 19:43:58',10,0),('1','140',157085,'DAILY SALES','2020-09-01','2020-09-01 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-16 20:07:50','510','2020-10-16 20:08:10',10,0),('1','140',157164,'DAILY SALES','2020-09-02','2020-09-02 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-17 12:20:37','510','2020-10-17 12:20:58',10,0),('1','140',157165,'DAILY SALES','2020-09-03','2020-09-03 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-17 12:26:32','510','2020-10-17 12:26:50',10,0),('1','140',157169,'DAILY SALES','2020-09-04','2020-09-04 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-17 12:38:49','510','2020-10-17 12:39:09',10,0),('1','140',157174,'DAILY SALES','2020-09-05','2020-09-05 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-17 12:53:13','510','2020-10-17 12:53:40',10,0),('1','140',157175,'DAILY SALES','2020-09-06','2020-09-06 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-17 15:12:14','510','2020-10-17 15:12:33',10,0),('1','140',157224,'DAILY SALES','2020-09-07','2020-09-07 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-17 20:47:01','510','2020-10-17 20:47:24',10,0),('1','140',157277,'DAILY SALES','2020-09-08','2020-09-08 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-17 20:53:04','510','2020-10-17 20:53:28',10,0),('1','140',157297,'DAILY SALES','2020-09-08','2020-09-08 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-18 07:36:45','510','2020-10-18 07:37:10',10,0),('1','140',157298,'DAILY SALES','2020-09-09','2020-09-09 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-18 07:39:12','510','2020-10-18 07:39:29',10,0),('1','140',157300,'DAILY SALES','2020-09-10','2020-09-10 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-18 07:51:51','510','2020-10-18 07:52:08',10,0),('1','140',157303,'DAILY SALES','2020-09-11','2020-09-11 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-18 08:30:35','510','2020-10-18 08:31:01',10,0),('1','140',157311,'DAILY SALES','2020-09-12','2020-09-12 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-18 08:46:20','510','2020-10-18 08:46:40',10,0),('1','140',157313,'DAILY SALES','2020-09-13','2020-09-13 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-18 08:59:16','510','2020-10-18 09:00:04',10,0),('1','140',157314,'DAILY SALES','2020-09-14','2020-09-14 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-18 09:17:00','510','2020-10-18 09:17:45',10,0),('1','140',157319,'DAILY SALES','2020-09-15','2020-09-15 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-18 09:40:22','510','2020-10-18 09:41:11',10,0),('1','140',157324,'DAILY SALES','2020-09-16','2020-09-16 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-18 09:53:19','510','2020-10-18 09:54:31',10,0),('1','140',157336,'DAILY SALES','2020-09-16','2020-09-16 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-18 10:24:14','510','2020-10-18 10:25:03',10,0),('1','140',157346,'DAILY SALES','2020-09-17','2020-09-17 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-18 10:35:00','510','2020-10-18 10:35:40',10,0),('1','140',157353,'DAILY SALES','2020-09-18','2020-09-18 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-18 11:00:07','510','2020-10-18 11:00:31',10,0),('1','140',157358,'DAILY SALES','2020-09-19','2020-09-19 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-18 11:16:22','510','2020-10-18 11:16:45',10,0),('1','140',157363,'DAILY SALES','2020-09-20','2020-09-20 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-18 11:23:07','510','2020-10-18 11:23:32',10,0),('1','140',157366,'DAILY SALES','2020-09-21','2020-09-21 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-18 11:28:05','510','2020-10-18 11:28:26',10,0),('1','140',157455,'DAILY SALES','2020-09-22','2020-09-22 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-19 06:42:09','510','2020-10-19 06:42:29',10,0),('1','140',157458,'DAILY SALES','2020-09-23','2020-09-23 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-19 06:48:00','510','2020-10-19 06:48:22',10,0),('1','140',157462,'DAILY SALES','2020-09-23','2020-09-23 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-19 06:55:05','510','2020-10-19 06:55:24',10,0),('1','140',157466,'DAILY SALES','2020-09-23','2020-09-23 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-19 07:03:51','510','2020-10-19 07:04:13',10,0),('1','140',157467,'DAILY SALES','2020-09-24','2020-09-24 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-19 07:09:05','510','2020-10-19 07:09:27',10,0),('1','140',157470,'DAILY SALES','2020-09-25','2020-09-25 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-19 07:16:54','510','2020-10-19 07:17:20',10,0),('1','140',157471,'DAILY SALES','2020-09-26','2020-09-26 00:00:00',NULL,'510',0.00,0.00,'510','2020-10-19 07:25:58','510','2020-10-19 07:26:17',10,0),('1','140',157473,'DAILY SALES','2020-09-27','2020-09-27 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-10 17:30:52','510','2020-11-10 17:31:44',10,0),('1','140',161271,'DAILY  SHIFT ','2020-09-29','2020-09-29 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-10 19:45:23','510','2020-11-10 19:45:48',10,0),('1','140',161273,'DAILY  SHIFT','2020-09-29','2020-09-29 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-10 19:57:03','510','2020-11-10 19:57:18',10,0),('1','140',161275,'DAILY  SHIFT','2020-09-30','2020-09-30 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-10 20:02:42','510','2020-11-10 20:02:59',10,0),('1','140',161276,'DAILY  SHIFT','2020-09-30','2020-09-30 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-10 20:14:02','510','2020-11-10 20:14:19',10,0),('1','140',161277,'DAILY  SHIFT','2020-10-01','2020-10-01 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-10 20:24:28','510','2020-11-10 20:25:11',10,0),('1','140',161279,'DAILY  SHIFT','2020-10-02','2020-10-02 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-10 20:37:06','510','2020-11-10 20:37:35',10,0),('1','140',161280,'DAILY  SHIFT','2020-10-03','2020-10-03 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-10 20:44:53','510','2020-11-10 20:45:12',10,0),('1','140',161281,'DAILY  SHIFT','2020-10-04','2020-10-04 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-10 20:56:04','510','2020-11-10 20:56:25',10,0),('1','140',161282,'DAILY  SHIFT','2020-10-05','2020-10-05 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-10 21:02:41','510','2020-11-10 21:03:01',10,0),('1','140',161284,'DAILY  SHIFT','2020-10-06','2020-10-06 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-10 21:14:54','510','2020-11-10 21:15:16',10,0),('1','140',161288,'DAILY  SHIFT','2020-10-07','2020-10-07 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-10 21:25:38','510','2020-11-10 21:26:01',10,0),('1','140',161289,'DAILY  SHIFT','2020-10-08','2020-10-08 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-11 06:16:47','510','2020-11-11 06:17:11',10,0),('1','140',161293,'DAILY  SHIFT','2020-10-08','2020-10-08 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-11 06:23:12','510','2020-11-11 06:23:34',10,0),('1','140',161295,'DAILY  SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-11 06:30:52','510','2020-11-11 06:31:13',10,0),('1','140',161296,'DAILY  SHIFT','2020-10-09','2020-10-09 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-11 06:41:24','510','2020-11-11 06:41:44',10,0),('1','140',161298,'DAILY  SHIFT','2020-10-10','2020-10-10 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-11 06:46:47','510','2020-11-11 06:47:07',10,0),('1','140',161301,'DAILY  SHIFT','2020-10-11','2020-10-11 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-11 06:58:00','510','2020-11-11 06:58:25',10,0),('1','140',161302,'DAILY  SHIFT','2020-10-12','2020-10-12 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-11 07:04:19','510','2020-11-11 07:04:42',10,0),('1','140',161305,'DAILY  SHIFT','2020-10-13','2020-10-13 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-11 07:09:23','510','2020-11-11 07:09:40',10,0),('1','140',161351,'DAILY  SHIFT','2020-10-13','2020-10-13 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-11 10:24:23','510','2020-11-11 10:24:43',10,0),('1','140',161352,'DAILY  SHIFT','2020-10-14','2020-10-14 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-11 10:30:21','510','2020-11-11 10:30:40',10,0),('1','140',161466,'DAILY  SHIFT','2020-10-15','2020-10-15 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-11 19:07:49','510','2020-11-11 19:08:26',10,0),('1','140',161469,'DAILY  SHIFT','2020-10-16','2020-10-16 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-11 19:32:20','510','2020-11-11 19:33:14',10,0),('1','140',161470,'DAILY  SHIFT','2020-10-17','2020-10-17 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-11 19:41:58','510','2020-11-11 19:42:15',10,0),('1','140',161472,'DAILY  SHIFT','2020-10-17','2020-10-17 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-11 19:50:23','510','2020-11-11 19:50:44',10,0),('1','140',161477,'DAILY  SHIFT','2020-10-18','2020-10-18 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-11 20:09:58','510','2020-11-11 20:10:28',10,0),('1','140',161480,'DAILY  SHIFT','2020-10-19','2020-10-19 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-11 20:21:03','510','2020-11-11 20:21:24',10,0),('1','140',161482,'DAILY  SHIFT','2020-10-20','2020-10-20 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-11 20:35:34','510','2020-11-11 20:35:57',10,0),('1','140',161484,'DAILY  SHIFT','2020-10-21','2020-10-21 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-11 20:43:46','510','2020-11-11 20:44:03',10,0),('1','140',161485,'DAILY  SHIFT','2020-10-22','2020-10-22 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-11 21:05:25','510','2020-11-11 21:05:45',10,0),('1','140',161672,'DAILY  SHIFT','2020-10-23','2020-10-23 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-12 19:34:57','510','2020-11-12 19:35:14',10,0),('1','140',161674,'DAILY  SHIFT','2020-10-24','2020-10-24 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-12 19:47:13','510','2020-11-12 19:47:43',10,0),('1','140',161675,'DAILY  SHIFT','2020-10-25','2020-10-25 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-12 19:56:22','510','2020-11-12 19:56:42',10,0),('1','140',161676,'DAILY  SHIFT','2020-10-26','2020-10-26 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-12 20:01:29','510','2020-11-12 20:01:48',10,0),('1','140',161677,'DAILY  SHIFT','2020-10-27','2020-10-27 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-12 20:12:44','510','2020-11-12 20:13:01',10,0),('1','140',161678,'DAILY  SHIFT','2020-10-28','2020-10-28 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-12 20:26:35','510','2020-11-12 20:26:53',10,0),('1','140',161679,'DAILY  SHIFT','2020-10-29','2020-10-29 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-12 20:39:19','510','2020-11-12 20:39:45',10,0),('1','140',161680,'DAILY  SHIFT','2020-10-30','2020-10-30 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-12 20:51:45','510','2020-11-12 20:52:03',10,0),('1','140',161681,'DAILY  SHIFT','2020-10-31','2020-10-31 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-12 20:57:17','510','2020-11-12 20:57:36',10,0),('1','140',161682,'DAILY  SHIFT','2020-11-01','2020-11-01 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-12 21:09:29','510','2020-11-12 21:09:49',10,0),('1','140',161683,'DAILY  SHIFT','2020-11-02','2020-11-02 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-12 21:14:07','510','2020-11-12 21:14:27',10,0),('1','140',161684,'DAILY  SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-12 21:21:18','510','2020-11-12 21:22:19',10,0),('1','140',161685,'DAILY  SHIFT','2020-11-03','2020-11-03 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-12 21:26:01','510','2020-11-12 21:26:22',10,0),('1','140',161686,'DAILY  SHIFT','2020-11-04','2020-11-04 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-12 21:34:49','510','2020-11-12 21:35:08',10,0),('1','140',161689,'DAILY  SHIFT','2020-11-05','2020-11-05 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-12 21:38:39','510','2020-11-12 21:38:59',10,0),('1','140',162215,'DAILY SHIFT SALES','2020-11-06','2020-11-06 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-15 17:22:05','510','2020-11-15 17:22:34',10,0),('1','140',162217,'DAILY SHIFT SALES','2020-11-07','2020-11-07 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-15 17:32:06','510','2020-11-15 17:32:32',10,0),('1','140',162218,'DAILY SHIFT SALES','2020-11-08','2020-11-08 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-15 17:42:47','510','2020-11-15 17:43:14',10,0),('1','140',162222,'DAILY SHIFT SALES','2020-11-09','2020-11-09 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-15 18:07:09','510','2020-11-15 18:07:34',10,0),('1','140',162231,'DAILY SHIFT SALES','2020-11-10','2020-11-10 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-15 18:19:57','510','2020-11-15 18:20:19',10,0),('1','140',162311,'DAILY SHIFT SALES','2020-11-11','2020-11-11 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-16 10:35:28','510','2020-11-16 10:35:51',10,0),('1','140',162317,'DAILY SHIFT SALES','2020-11-12','2020-11-12 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-16 10:41:31','510','2020-11-16 10:42:45',10,0),('1','140',162548,'DAILY SHIFT SALES','2020-11-12','2020-11-12 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-17 11:49:38','510','2020-11-17 11:51:27',10,0),('1','140',162556,'DAILY SHIFT SALES','2020-11-12','2020-11-12 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-17 11:57:11','510','2020-11-17 11:57:28',10,0),('1','140',162559,'DAILY SHIFT SALES','2020-11-17','2020-11-17 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-17 11:59:25','510','2020-11-17 11:59:44',10,0),('1','140',162563,'DAILY SHIFT SALES','2020-11-17','2020-11-17 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-17 12:04:11','510','2020-11-17 12:05:13',10,0),('1','140',162565,'DAILY SHIFT SALES','2020-11-13','2020-11-13 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-17 12:10:02','510','2020-11-17 12:10:59',10,0),('1','140',162569,'DAILY SHIFT SALES','2020-11-14','2020-11-14 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-17 12:17:19','510','2020-11-17 12:17:39',10,0),('1','140',162572,'DAILY SHIFT SALES','2020-11-15','2020-11-15 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-17 12:32:48','510','2020-11-17 12:33:08',10,0),('1','140',162700,'DAILY SHIFT SALES','2020-11-16','2020-11-16 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-18 10:18:02','510','2020-11-18 10:18:43',10,0),('1','140',162779,'DAILY SHIFT SALES','2020-08-28','2020-08-28 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-18 15:47:29','510','2020-11-18 15:47:52',10,0),('1','140',163058,'DAILY SHIFT SALES','2020-11-17','2020-11-17 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-20 09:41:04','510','2020-11-20 09:41:23',10,0),('1','140',163060,'DAILY SHIFT SALES','2020-11-18','2020-11-18 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-20 09:56:11','510','2020-11-20 09:56:56',10,0),('1','140',163119,'DAILY SHIFT SALES','2020-11-19','2020-11-19 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-20 13:32:21','510','2020-11-20 13:32:56',10,0),('1','140',163705,'DAILY SHIFT SALES','2020-11-19','2020-11-19 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-23 15:41:31','510','2020-11-23 15:41:50',10,0),('1','140',163709,'DAILY SHIFT SALES','2020-11-20','2020-11-20 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-23 15:53:05','510','2020-11-23 15:53:44',10,0),('1','140',163783,'DAILY SHIFT SALES','2020-11-21','2020-11-21 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-24 09:57:56','510','2020-11-24 11:59:17',10,0),('1','140',163819,'DAILY SHIFT SALES','2020-11-21','2020-11-21 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-24 12:08:30','510','2020-11-24 12:12:58',10,0),('1','140',163823,'DAILY SHIFT SALES','2020-11-21','2020-11-21 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-24 12:40:41','510','2020-11-24 12:41:01',10,0),('1','140',163825,'DAILY SHIFT SALES','2020-11-22','2020-11-22 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-24 17:02:41','510','2020-11-24 17:03:13',10,0),('1','140',164050,'DAILY SHIFT SALES','2020-11-23','2020-11-23 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-25 15:58:45','510','2020-11-25 15:59:08',10,0),('1','140',164058,'DAILY SHIFT SALES','2020-11-24','2020-11-24 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-25 16:14:15','510','2020-11-25 16:14:32',10,0),('1','140',164235,'DAILY SHIFT SALES','2020-11-25','2020-11-25 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-26 16:56:54','510','2020-11-26 16:57:11',10,0),('1','140',164573,'DAILY SHIFT SALES','2020-11-26','2020-11-26 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-28 16:12:07','510','2020-11-28 16:12:55',10,0),('1','140',164577,'DAILY SHIFT SALES','2020-11-27','2020-11-27 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-28 16:41:05','510','2020-11-28 16:41:57',10,0),('1','140',164896,'DAILY SHIFT SALES','2020-11-28','2020-11-28 00:00:00',NULL,'510',0.00,0.00,'510','2020-11-30 15:01:16','510','2020-11-30 15:01:56',10,0),('1','140',164901,'DAILY SHIFT SALES','2020-11-29','2020-11-29 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-01 15:55:22','510','2020-12-01 15:55:48',10,0),('1','140',165097,'DAILY SHIFT SALES','2020-11-29','2020-11-29 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-01 16:25:25','510','2020-12-01 16:26:26',10,0),('1','140',165105,'DAILY SHIFT SALES','2020-11-30','2020-11-30 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-01 17:24:39','510','2020-12-01 17:25:08',10,0),('1','140',165289,'DAILY SHIFT SALES','2020-12-01','2020-12-01 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-02 17:59:10','510','2020-12-02 17:59:58',10,0),('1','140',165384,'DAILY SHIFT SALES','2020-12-02','2020-12-02 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-03 12:59:10','510','2020-12-03 13:01:43',10,0),('1','140',165529,'DAILY SHIFT SALES','2020-12-03','2020-12-03 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-04 11:46:23','510','2020-12-04 11:47:08',10,0),('1','140',165874,'DAILY SHIFT SALES','2020-12-05','2020-12-05 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-06 14:27:53','510','2020-12-06 14:28:13',10,0),('1','140',165887,'DAILY SHIFT SALES','2020-12-04','2020-12-04 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-06 15:01:07','510','2020-12-06 15:01:33',10,0),('1','140',166072,'DAILY SHIFT SALES','2020-12-05','2020-12-05 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-07 14:32:40','510','2020-12-07 14:33:18',10,0),('1','140',166089,'DAILY SHIFT SALES','2020-12-06','2020-12-06 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-07 15:03:19','510','2020-12-07 15:05:09',10,0),('1','140',166274,'DAILY SHIFT SALES','2020-12-07','2020-12-07 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-08 14:50:41','510','2020-12-08 14:52:27',10,0),('1','140',166422,'DAILY SHIFT SALES','2020-12-08','2020-12-08 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-09 14:51:30','510','2020-12-09 14:52:29',10,0),('1','140',166652,'DAILY SHIFT SALES','2020-12-09','2020-12-09 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-10 15:39:23','510','2020-12-10 15:39:51',10,0),('1','140',166668,'DAILY SHIFT SALES','2020-12-09','2020-12-09 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-10 16:37:05','510','2020-12-10 16:37:32',10,0),('1','140',166850,'DAILY SHIFT SALES','2020-12-10','2020-12-10 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-11 16:00:44','510','2020-12-11 16:01:07',10,0),('1','140',167313,'DAILY SHIFT SALES','2020-12-11','2020-12-11 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-14 14:43:06','510','2020-12-14 14:43:49',10,0),('1','140',167513,'DAILY SHIFT SALES','2020-12-12','2020-12-12 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-15 14:26:01','510','2020-12-15 14:26:31',10,0),('1','140',167522,'DAILY SHIFT SALES','2020-12-13','2020-12-13 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-15 15:02:23','510','2020-12-15 15:02:51',10,0),('1','140',167539,'DAILY SHIFT SALES','2020-12-14','2020-12-14 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-15 16:27:31','510','2020-12-15 16:29:36',10,0),('1','140',167676,'DAILY SHIFT SALES','2020-12-15','2020-12-15 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-16 14:55:41','510','2020-12-16 14:56:07',10,0),('1','140',167847,'DAILY SHIFT SALES','2020-12-16','2020-12-16 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-17 14:09:49','510','2020-12-17 14:10:14',10,0),('1','140',168069,'DAILY SHIFT SALES','2020-12-17','2020-12-17 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-18 16:24:18','510','2020-12-18 16:24:49',10,0),('1','140',168195,'DAILY SHIFT SALES','2020-12-18','2020-12-18 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-19 12:44:19','510','2020-12-19 12:44:51',10,0),('1','140',168557,'DAILY SHIFT SALES','2020-12-19','2020-12-19 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-21 14:52:23','510','2020-12-21 14:54:03',10,0),('1','140',168730,'DAILY SHIFT SALES','2020-12-20','2020-12-20 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-22 15:49:52','510','2020-12-22 15:51:35',10,0),('1','140',168738,'DAILY SHIFT SALES','2020-12-21','2020-12-21 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-22 16:34:32','510','2020-12-22 16:35:34',10,0),('1','140',168910,'DAILY SHIFT SALES','2020-12-22','2020-12-22 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-23 16:41:24','510','2020-12-23 16:41:54',10,0),('1','140',170081,'DAILY SHIFT SALES','2020-12-22','2020-12-22 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-30 15:49:48','510','2020-12-30 15:50:12',10,0),('1','140',170089,'DAILY SHIFT SALES','2020-12-23','2020-12-23 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-30 16:31:14','510','2020-12-30 16:32:21',10,0),('1','140',170094,'DAILY SHIFT SALES','2020-12-24','2020-12-24 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-30 16:42:17','510','2020-12-30 16:43:49',10,0),('1','140',170249,'DAILY SHIFT SALES','2020-12-24','2020-12-24 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-31 14:21:21','510','2020-12-31 14:21:51',10,0),('1','140',170268,'DAILY SHIFT SALES','2020-12-25','2020-12-25 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-31 15:30:31','510','2020-12-31 15:30:55',10,0),('1','140',170306,'DAILY SHIFT SALES','2020-12-26','2020-12-26 00:00:00',NULL,'510',0.00,0.00,'510','2020-12-31 16:34:03','510','2020-12-31 16:34:55',10,0),('1','140',170417,'DAILY SHIFT SALES','2020-12-27','2020-12-27 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-01 13:36:49','510','2021-01-01 13:37:16',10,0),('1','140',170428,'DAILY SHIFT SALES','2020-12-28','2020-12-28 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-01 13:58:08','510','2021-01-01 13:58:40',10,0),('1','140',170436,'DAILY SHIFT SALES','2020-12-29','2020-12-29 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-01 14:18:48','510','2021-01-01 14:19:09',10,0),('1','140',170439,'DAILY SHIFT SALES','2020-12-30','2020-12-30 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-04 17:39:43','510','2021-01-04 17:40:44',10,0),('1','140',170972,'DAILY SHIFT SALES','2020-12-31','2020-12-31 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-04 18:14:05','510','2021-01-04 18:14:34',10,0),('1','140',170978,'DAILY SHIFT SALES','2021-01-01','2021-01-01 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-04 18:36:24','510','2021-01-04 18:36:46',10,0),('1','140',170979,'DAILY SHIFT SALES','2021-01-02','2021-01-02 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-04 18:49:54','510','2021-01-04 18:51:54',10,0),('1','140',170987,'DAILY SHIFT SALES','2021-01-03','2021-01-03 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-04 19:11:26','510','2021-01-04 19:11:49',10,0),('1','140',171332,'DAILY SHIFT SALES','2021-01-04','2021-01-04 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-06 16:38:03','510','2021-01-06 16:38:31',10,0),('1','140',171346,'DAILY SHIFT SALES','2021-01-05','2021-01-05 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-06 17:11:52','510','2021-01-06 17:12:20',10,0),('1','140',171522,'DAILY SHIFT SALES','2021-01-06','2021-01-06 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-07 14:41:59','510','2021-01-07 14:42:29',10,0),('1','140',171736,'DAILY SHIFT SALES','2021-01-06','2021-01-06 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-08 17:01:06','510','2021-01-08 17:01:49',10,0),('1','140',171745,'DAILY SHIFT SALES','2021-01-07','2021-01-07 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-08 17:21:22','510','2021-01-08 17:21:47',10,0),('1','140',172348,'DAILY SHIFT SALES','2021-01-08','2021-01-08 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-12 11:10:48','510','2021-01-12 11:15:57',10,0),('1','140',172357,'DAILY SHIFT SALES','2021-01-09','2021-01-09 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-12 11:50:28','510','2021-01-12 11:50:57',10,0),('1','140',172364,'DAILY SHIFT SALES','2021-01-10','2021-01-10 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-12 12:05:20','510','2021-01-12 12:05:54',10,0),('1','140',172370,'DAILY SHIFT SALES','2021-01-11','2021-01-11 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-12 12:12:10','510','2021-01-12 12:12:35',10,0),('1','140',172412,'DAILY SHIFT SALES','2021-01-11','2021-01-11 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-12 14:56:45','510','2021-01-12 14:57:42',10,0),('1','140',172668,'DAILY SHIFT SALES','2021-01-12','2021-01-12 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-13 16:14:26','510','2021-01-13 16:15:03',10,0),('1','140',172811,'DAILY SHIFT SALES','2021-01-13','2021-01-13 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-14 14:30:01','510','2021-01-14 14:30:25',10,0),('1','140',172960,'DAILY SHIFT SALES','2021-01-14','2021-01-14 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-15 13:03:38','510','2021-01-15 13:03:59',10,0),('1','140',173534,'DAILY SHIFT SALES','2021-01-15','2021-01-15 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-18 15:07:30','510','2021-01-18 15:07:56',10,0),('1','140',173542,'DAILY SHIFT SALES','2021-01-16','2021-01-16 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-18 15:18:09','510','2021-01-18 15:20:03',10,0),('1','140',173546,'DAILY SHIFT SALES','2021-01-17','2021-01-17 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-18 15:50:11','510','2021-01-18 15:50:35',10,0),('1','140',173707,'DAILY SHIFT SALES','2021-01-18','2021-01-18 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-19 14:00:06','510','2021-01-19 14:01:48',10,0),('1','140',173876,'DAILY SHIFT SALES','2021-01-19','2021-01-19 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-20 14:22:27','510','2021-01-20 14:22:56',10,0),('1','140',174066,'DAILY SHIFT SALES','2021-01-20','2021-01-20 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-21 13:59:50','510','2021-01-21 14:00:16',10,0),('1','140',174259,'DAILY SHIFT SALES','2021-01-21','2021-01-21 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-22 15:11:57','510','2021-01-22 15:12:47',10,0),('1','140',174412,'DAILY SHIFT SALES','2021-01-22','2021-01-22 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-23 13:28:07','510','2021-01-23 13:30:55',10,0),('1','140',175133,'DAILY SHIFT SALES','2021-01-23','2021-01-23 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-27 11:47:46','510','2021-01-27 11:48:12',10,0),('1','140',175317,'DAILY SHIFT SALES','2021-01-24','2021-01-24 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-28 12:15:00','510','2021-01-28 12:15:39',10,0),('1','140',175320,'DAILY SHIFT SALES','2021-01-25','2021-01-25 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-28 12:35:07','510','2021-01-28 12:35:31',10,0),('1','140',175327,'DAILY SHIFT SALES','2021-01-25','2021-01-25 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-28 13:50:33','510','2021-01-28 13:51:00',10,0),('1','140',175407,'DAILY SHIFT SALES','2021-01-26','2021-01-26 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-28 19:32:21','510','2021-01-28 19:32:45',10,0),('1','140',175412,'DAILY SHIFT SALES','2021-01-27','2021-01-27 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-28 19:55:38','510','2021-01-28 19:56:35',10,0),('1','140',175583,'DAILY SHIFT SALES','2021-01-28','2021-01-28 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-30 15:46:44','510','2021-01-30 15:47:07',10,0),('1','140',175720,'DAILY SHIFT SALES','2021-01-29','2021-01-29 00:00:00',NULL,'510',0.00,0.00,'510','2021-01-30 16:10:21','510','2021-01-30 16:11:13',10,0),('1','140',176089,'DAILY SHIFT SALES','2021-01-30','2021-01-30 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-01 16:41:48','510','2021-02-01 16:42:19',10,0),('1','140',176111,'DAILY SHIFT SALES','2021-01-24','2021-01-24 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-01 16:44:03','510','2021-02-01 16:44:34',10,0),('1','140',176113,'DAILY SHIFT SALES','2021-01-31','2021-01-31 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-01 17:01:42','510','2021-02-01 17:02:46',10,0),('1','140',176463,'DAILY SHIFT SALES','2021-02-01','2021-02-01 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-03 14:40:38','510','2021-02-03 14:41:01',10,0),('1','140',176480,'DAILY SHIFT SALES','2021-02-02','2021-02-02 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-03 16:25:40','510','2021-02-03 16:26:02',10,0),('1','140',176662,'DAILY SHIFT SALES','2021-02-03','2021-02-03 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-04 15:37:55','510','2021-02-04 15:38:34',10,0),('1','140',177788,'DAILY SHIFT SALES','2021-02-04','2021-02-04 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-09 14:38:19','510','2021-02-09 14:38:43',10,0),('1','140',177793,'DAILY SHIFT SALES','2021-02-05','2021-02-05 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-09 15:04:48','510','2021-02-09 15:05:13',10,0),('1','140',177817,'DAILY SHIFT SALES','2021-02-06','2021-02-06 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-09 16:05:36','510','2021-02-09 16:07:28',10,0),('1','140',177822,'DAILY SHIFT SALES','2021-02-07','2021-02-07 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-09 16:15:12','510','2021-02-09 16:15:39',10,0),('1','140',177827,'DAILY SHIFT SALES','2021-02-08','2021-02-08 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-09 16:45:12','510','2021-02-09 16:45:34',10,0),('1','140',178004,'DAILY SHIFT SALES','2021-02-09','2021-02-09 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-10 15:38:01','510','2021-02-10 15:38:25',10,0),('1','140',178391,'DAILY SHIFT SALES','2021-02-10','2021-02-10 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-12 14:23:56','510','2021-02-12 14:24:43',10,0),('1','140',178403,'DAILY SHIFT SALES','2021-02-11','2021-02-11 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-12 14:42:05','510','2021-02-12 14:44:50',10,0),('1','140',178410,'DAILY SHIFT SALES','2021-02-11','2021-02-11 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-12 15:00:15','510','2021-02-12 15:00:51',10,0),('1','140',179081,'DAILY SHIFT SALES','2021-02-12','2021-02-12 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-15 17:05:56','510','2021-02-15 17:11:51',10,0),('1','140',179088,'DAILY SHIFT SALES','2021-02-13','2021-02-13 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-15 17:42:08','510','2021-02-15 17:42:39',10,0),('1','140',179099,'DAILY SHIFT SALES','2021-02-14','2021-02-14 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-16 16:20:40','510','2021-02-16 16:22:01',10,0),('1','140',179459,'DAILY SHIFT SALES','2021-02-15','2021-02-15 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-17 16:10:06','510','2021-02-17 16:10:34',10,0),('1','140',179520,'DAILY SHIFT SALES','2021-02-16','2021-02-16 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-18 15:03:57','510','2021-02-18 15:04:34',10,0),('1','140',179714,'DAILY SHIFT SALES','2021-02-17','2021-02-17 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-18 15:27:11','510','2021-02-18 15:27:40',10,0),('1','140',179941,'DAILY SHIFT SALES','2021-02-18','2021-02-18 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-19 15:59:19','510','2021-02-19 15:59:42',10,0),('1','140',179964,'DAILY SHIFT SALES','2021-02-19','2021-02-19 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-20 09:51:15','510','2021-02-20 09:51:42',10,0),('1','140',180028,'DAILY SHIFT SALES','2021-02-20','2021-02-20 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-20 18:51:00','510','2021-02-20 18:54:39',10,0),('1','140',180164,'DAILY SHIFT SALES','2021-02-21','2021-02-21 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-21 13:30:56','510','2021-02-21 13:31:36',10,0),('1','140',180258,'DAILY SHIFT SALES','2021-02-21','2021-02-21 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-21 16:55:40','510','2021-02-21 16:56:06',10,0),('1','140',180336,'DAILY SHIFT SALES','2021-02-22','2021-02-22 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-23 07:40:55','510','2021-02-23 07:41:27',10,0),('1','140',180559,'DAILY SHIFT SALES','2021-02-23','2021-02-23 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-24 06:32:16','510','2021-02-24 06:32:38',10,0),('1','140',180737,'DAILY SHIFT SALES','2021-02-24','2021-02-24 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-24 12:50:13','510','2021-02-24 12:50:48',10,0),('1','140',180854,'DAILY SHIFT SALES','2021-02-24','2021-02-24 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-25 06:24:26','510','2021-02-25 06:24:52',10,0),('1','140',180957,'DAILY SHIFT SALES','2021-02-25','2021-02-25 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-26 06:14:04','510','2021-02-26 06:15:37',10,0),('1','140',181128,'DAILY SHIFT SALES','2021-02-26','2021-02-26 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-26 14:37:15','510','2021-02-26 14:37:40',10,0),('1','140',181262,'DAILY SHIFT SALES','2021-02-26','2021-02-26 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-26 17:56:55','510','2021-02-26 17:57:19',10,0),('1','140',181345,'DAILY SHIFT SALES','2021-02-27','2021-02-27 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-27 19:33:31','510','2021-02-27 20:57:45',10,0),('1','140',181521,'DAILY SHIFT SALES','2021-02-28','2021-02-28 00:00:00',NULL,'510',0.00,0.00,'510','2021-02-28 17:59:10','510','2021-02-28 18:00:44',10,0),('1','140',181697,'DAILY SHIFT SALES','2021-03-01','2021-03-01 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-01 15:22:54','510','2021-03-01 15:24:41',10,0),('1','140',181819,'DAILY SHIFT SALES','2021-03-01','2021-03-01 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-02 09:35:22','510','2021-03-02 09:35:44',10,0),('1','140',181962,'DAILY SHIFT SALES','2021-03-02','2021-03-02 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-02 17:49:40','510','2021-03-02 17:50:43',10,0),('1','140',182104,'DAILY SHIFT SALES','2021-03-03','2021-03-03 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-03 13:12:40','510','2021-03-03 13:13:08',10,0),('1','140',182197,'DAILY SHIFT SALES','2021-03-03','2021-03-03 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-03 17:55:14','510','2021-03-03 17:55:55',10,0),('1','140',182311,'DAILY SHIFT SALES','2021-03-04','2021-03-04 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-05 06:29:13','510','2021-03-05 06:29:35',10,0),('1','140',182497,'DAILY SHIFT SALES','2021-03-05','2021-03-05 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-05 17:31:39','510','2021-03-05 17:33:45',10,0),('1','140',182685,'DAILY SHIFT SALE','2021-03-06','2021-03-06 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-06 11:36:56','510','2021-03-06 11:37:21',10,0),('1','140',182754,'DAILY SHIFT SALES','2021-03-06','2021-03-06 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-06 20:17:01','510','2021-03-06 20:17:37',10,0),('1','140',182831,'DAILY SHIFT SALES','2021-03-07','2021-03-07 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-08 06:47:49','510','2021-03-08 06:48:45',10,0),('1','140',182991,'DAILY SHIFT SALES','2021-03-08','2021-03-08 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-08 14:51:25','510','2021-03-08 14:53:12',10,0),('1','140',183131,'DAILY SHIFT SALES','2021-03-08','2021-03-08 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-09 07:01:09','510','2021-03-09 07:02:48',10,0),('1','140',183217,'DAILY SHIFT SALES','2021-03-09','2021-03-09 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-09 17:01:22','510','2021-03-09 17:01:42',10,0),('1','140',183428,'DAILY SHIFT SALES','2021-03-10','2021-03-10 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-10 17:10:50','510','2021-03-10 17:11:32',10,0),('1','140',183637,'DAILY SHIFT SALES','2021-03-11','2021-03-11 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-11 13:16:08','510','2021-03-11 13:16:30',10,0),('1','140',183795,'DAILY SHIFT SALES','2021-03-11','2021-03-11 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-11 17:06:19','510','2021-03-11 17:37:06',10,0),('1','140',183868,'DAILY SHIFT SALES','2021-03-12','2021-03-12 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-12 17:03:52','510','2021-03-12 17:04:18',10,0),('1','140',184070,'DAILY SHIFT SALES','2021-03-13','2021-03-13 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-13 17:56:16','510','2021-03-13 17:56:41',10,0),('1','140',184224,'DAILY SHIFT SALES','2021-03-13','2021-03-13 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-14 08:44:04','510','2021-03-14 08:44:27',10,0),('1','140',184304,'DAILY SHIFT SALES','2021-03-14','2021-03-14 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-14 14:25:44','510','2021-03-14 14:26:08',10,0),('1','140',184391,'DAILY SHIFT SALES','2021-03-14','2021-03-14 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-14 14:51:47','510','2021-03-14 14:54:37',10,0),('1','140',184455,'DAILY SHIFT SALES','2021-03-15','2021-03-15 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-15 17:34:46','510','2021-03-15 17:35:51',10,0),('1','140',184682,'DAILY SHIFT SALES','2021-03-16','2021-03-16 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-16 17:20:30','510','2021-03-16 17:21:02',10,0),('1','140',184882,'DAILY SHIFT SALES','2021-03-17','2021-03-17 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-17 11:34:54','510','2021-03-17 11:35:30',10,0),('1','140',184980,'DAILY SHIFT SALES','2021-03-17','2021-03-17 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-17 12:02:27','510','2021-03-17 12:03:12',10,0),('1','140',184990,'DAILY SHIFT SALES','2021-03-17','2021-03-17 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-17 17:14:20','510','2021-03-17 17:15:58',10,0),('1','140',185098,'DAILY SHIFT SALES','2021-03-18','2021-03-18 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-18 17:51:07','510','2021-03-18 17:51:37',10,0),('1','140',185256,'DAILY SHIFT SALES','2021-03-19','2021-03-19 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-19 14:08:51','510','2021-03-19 14:09:15',10,0),('1','140',185355,'DAILY SHIFT SALES','2021-03-19','2021-03-19 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-19 19:34:53','510','2021-03-19 19:35:15',10,0),('1','140',185459,'DAILY SHIFT SALES','2021-03-20','2021-03-20 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-20 18:57:11','510','2021-03-20 19:00:04',10,0),('1','140',185715,'DAILY SHIFT SALES','2021-03-21','2021-03-21 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-21 15:43:26','510','2021-03-21 15:44:00',10,0),('1','140',185866,'DAILY SHIFT SALES','2021-03-22','2021-03-22 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-22 17:07:24','510','2021-03-22 17:08:25',10,0),('1','140',186083,'DAILY SHIFT SALES','2021-03-23','2021-03-23 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-23 10:11:00','510','2021-03-23 10:11:32',10,0),('1','140',186153,'DAILY SHIFT SALES','2021-03-23','2021-03-23 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-23 17:18:29','510','2021-03-23 17:18:53',10,0),('1','140',186308,'DAILY SHIFT SALES','2021-03-24','2021-03-24 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-24 17:30:19','510','2021-03-24 17:32:41',10,0),('1','140',186523,'DAILY SHIFT SALES','2021-03-25','2021-03-25 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-25 15:17:17','510','2021-03-25 15:17:47',10,0),('1','140',186682,'DAILY SHIFT SALES','2021-03-25','2021-03-25 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-26 06:17:39','510','2021-03-26 06:19:50',10,0),('1','140',186752,'DAILY SHIFT SALES','2021-03-26','2021-03-26 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-26 19:11:34','510','2021-03-26 19:16:05',10,0),('1','140',186991,'DAILY SHIFT SALES','2021-03-27','2021-03-27 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-28 05:30:12','510','2021-03-28 05:31:31',10,0),('1','140',187152,'DAILY SHIFT SALES','2021-03-28','2021-03-28 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-29 06:53:50','510','2021-03-29 06:54:13',10,0),('1','140',187357,'DAILY SHIFT SALES','2021-03-29','2021-03-29 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-29 18:49:26','510','2021-03-29 18:50:30',10,0),('1','140',187573,'DAILY SHIFT SALES','2021-03-30','2021-03-30 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-30 09:27:02','510','2021-03-30 09:27:35',10,0),('1','140',187646,'DAILY SHIFT SALES','2021-03-30','2021-03-30 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-31 06:10:20','510','2021-03-31 06:10:41',10,0),('1','140',187792,'DAILY SHIFT SALES','2021-03-31','2021-03-31 00:00:00',NULL,'510',0.00,0.00,'510','2021-03-31 18:26:11','510','2021-03-31 18:27:59',10,0),('1','140',188010,'DAILY SHIFT SALES','2021-04-01','2021-04-01 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-01 17:15:51','510','2021-04-01 17:18:49',10,0),('1','140',188196,'DAILY SHIFT SALES','2021-04-02','2021-04-02 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-03 05:51:06','510','2021-04-03 05:51:24',10,0),('1','140',188416,'DAILY SHIFT SALES','2021-04-03','2021-04-03 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-03 20:02:43','510','2021-04-03 20:03:07',10,0),('1','140',188595,'DAILY SHIFT SALES','2021-04-04','2021-04-04 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-05 05:20:39','510','2021-04-05 05:21:04',10,0),('1','140',188796,'DAILY SHIFT SALES','2021-04-05','2021-04-05 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-05 22:05:02','510','2021-04-05 22:05:33',10,0),('1','140',189003,'DAILY SHIFT SALES','2021-04-06','2021-04-06 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-06 17:44:10','510','2021-04-06 17:44:36',10,0),('1','140',189193,'DAILY SHIFT SALES','2021-04-07','2021-04-07 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-07 09:08:08','510','2021-04-07 09:09:02',10,0),('1','140',189257,'DAILY SHIFT SALES','2021-04-07','2021-04-07 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-07 18:15:28','510','2021-04-07 18:15:56',10,0),('1','140',189411,'DAILY SHIFT SALES','2021-04-08','2021-04-08 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-08 17:20:11','510','2021-04-08 17:23:43',10,0),('1','140',189613,'DAILY SHIFT SALES','2021-04-09','2021-04-09 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-09 09:04:24','510','2021-04-09 09:04:46',10,0),('1','140',189722,'DAILY SHIFT SALES','2021-04-09','2021-04-09 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-10 05:31:00','510','2021-04-10 05:31:58',10,0),('1','140',189805,'DAILY SHIFT SALES','2021-04-10','2021-04-10 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-10 17:55:52','510','2021-04-10 17:56:15',10,0),('1','140',190063,'DAILY SHIFT SALES','2021-04-11','2021-04-11 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-12 05:27:53','510','2021-04-12 05:28:21',10,0),('1','140',190201,'DAILY SHIFT SALES','2021-04-12','2021-04-12 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-13 05:04:00','510','2021-04-13 05:04:25',10,0),('1','140',190422,'DAILY SHIFT SALES','2021-04-13','2021-04-13 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-13 20:42:06','510','2021-04-13 20:42:26',10,0),('1','140',190661,'DAILY SHIFT SALES','2021-04-14','2021-04-14 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-14 12:23:04','510','2021-04-14 12:23:27',10,0),('1','140',190773,'DAILY SHIFT SALES','2021-04-14','2021-04-14 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-14 20:23:04','510','2021-04-14 20:23:32',10,0),('1','140',190884,'DAILY SHIFT SALES','2021-04-15','2021-04-15 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-16 03:55:42','510','2021-04-16 03:56:23',10,0),('1','140',191060,'DAILY SHIFT SALES','2021-04-16','2021-04-16 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-16 15:25:57','510','2021-04-16 15:26:27',10,0),('1','140',191233,'DAILY SHIFT SALES','2021-04-16','2021-04-16 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-17 05:39:17','510','2021-04-17 05:39:41',10,0),('1','140',191281,'DAILY SHIFT SALES','2021-04-17','2021-04-17 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-17 19:17:35','510','2021-04-17 19:17:56',10,0),('1','140',191503,'DAILY SHIFT SALES','2021-04-18','2021-04-18 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-18 19:43:32','510','2021-04-18 19:43:56',10,0),('1','140',191690,'DAILY SHIFT SALES','2021-04-18','2021-04-18 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-18 22:52:49','510','2021-04-18 22:54:00',10,0),('1','140',191700,'DAILY SHIFT SALES','2021-04-19','2021-04-19 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-19 19:46:36','510','2021-04-19 19:46:57',10,0),('1','140',191929,'DAILY SHIFT SALES','2021-04-20','2021-04-20 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-20 21:01:50','510','2021-04-20 21:02:21',10,0),('1','140',192428,'DAILY SHIFT SALES','2021-04-22','2021-04-22 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-23 06:38:34','510','2021-04-23 06:38:55',10,0),('1','140',192571,'DAILY SHIFT SALES','2021-04-23','2021-04-23 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-24 01:26:12','510','2021-04-24 01:26:34',10,0),('1','140',193292,'DAILY SHIFT SALES','2021-04-26','2021-04-26 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-26 13:05:35','510','2021-04-26 13:05:57',10,0),('1','140',193293,'DAILY SHIFT SALES','2021-04-24','2021-04-24 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-26 13:19:56','510','2021-04-26 13:20:26',10,0),('1','140',193300,'DAILY SHIFT SALES','2021-04-24','2021-04-24 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-26 13:48:15','510','2021-04-26 13:48:42',10,0),('1','140',193318,'DAILY SHIFT SALES','2021-04-25','2021-04-25 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-26 14:08:18','510','2021-04-26 14:08:47',10,0),('1','140',193322,'DAILY SHIFT SALES','2021-04-26','2021-04-26 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-27 05:28:02','510','2021-04-27 05:28:20',10,0),('1','140',193396,'DAILY SHIFT SALES','2021-04-27','2021-04-27 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-27 13:26:22','510','2021-04-27 13:27:24',10,0),('1','140',193537,'DAILY SHIFT SALES','2021-04-27','2021-04-27 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-28 06:11:13','510','2021-04-28 06:11:49',10,0),('1','140',193620,'DAILY SHIFT SALES','2021-04-28','2021-04-28 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-29 05:28:29','510','2021-04-29 05:28:53',10,0),('1','140',193841,'DAILY SHIFT SALES','2021-04-29','2021-04-29 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-29 15:04:52','510','2021-04-29 15:05:56',10,0),('1','140',194018,'DAILY SHIFT SALES','2021-04-29','2021-04-29 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-30 06:35:28','510','2021-04-30 06:35:47',10,0),('1','140',194081,'DAILY SHIFT SALES','2021-04-30','2021-04-30 00:00:00',NULL,'510',0.00,0.00,'510','2021-04-30 20:19:22','510','2021-04-30 20:19:49',10,0),('1','140',194285,'DAILY SHIFT SALES','2021-05-01','2021-05-01 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-02 08:45:21','510','2021-05-02 08:45:40',10,0),('1','140',194523,'DAILY SHIFT SALES','2021-05-02','2021-05-02 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-02 15:20:02','510','2021-05-02 15:20:38',10,0),('1','140',194668,'DAILY SHIFT SALES','2021-05-03','2021-05-03 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-03 17:42:06','510','2021-05-03 17:42:32',10,0),('1','140',194939,'DAILY SHIFT SALES','2021-05-04','2021-05-04 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-04 17:04:52','510','2021-05-04 17:05:41',10,0),('1','140',195072,'DAILY SHIFT SALES','2021-05-05','2021-05-05 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-05 17:26:34','510','2021-05-05 17:27:26',10,0),('1','140',195297,'DAILY SHIFT SALES','2021-05-06','2021-05-06 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-06 16:55:47','510','2021-05-06 16:56:27',10,0),('1','140',195477,'DAILY SHIFT SALES','2021-05-06','2021-05-06 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-07 05:40:22','510','2021-05-07 05:40:53',10,0),('1','140',195513,'DAILY SHIFT SALES','2021-05-07','2021-05-07 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-07 17:55:18','510','2021-05-07 17:57:16',10,0),('1','140',195787,'DAILY SHIFT SALES','2021-05-08','2021-05-08 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-08 18:29:59','510','2021-05-08 18:30:26',10,0),('1','140',196164,'DAILY SHIFT SALES','2021-05-09','2021-05-09 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-09 16:53:47','510','2021-05-09 16:54:10',10,0),('1','140',196217,'DAILY SHIFT SALES','2021-05-10','2021-05-10 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-10 18:11:01','510','2021-05-10 18:11:44',10,0),('1','140',196410,'DAILY SHIFT SALES','2021-05-10','2021-05-10 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-11 05:48:50','510','2021-05-11 05:49:11',10,0),('1','140',196445,'DAILY SHIFT SALES','2021-05-11','2021-05-11 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-12 13:24:23','510','2021-05-12 13:27:04',10,0),('1','140',196778,'DAILY SHIFT SALES','2021-05-12','2021-05-12 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-13 13:34:57','510','2021-05-13 13:35:36',10,0),('1','140',196941,'DAILY SHIFT SALES','2021-05-13','2021-05-13 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-14 08:08:30','510','2021-05-14 08:09:01',10,0),('1','140',197066,'DAILY SHIFT SALES','2021-05-14','2021-05-14 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-17 09:50:33','510','2021-05-17 09:51:06',10,0),('1','140',197586,'DAILY SHIFT SALES','2021-05-15','2021-05-15 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-17 09:59:02','510','2021-05-17 09:59:56',10,0),('1','140',197588,'DAILY SHIFT SALES','2021-05-16','2021-05-16 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-17 10:14:32','510','2021-05-17 10:14:58',10,0),('1','140',197597,'DAILY SHIFT SALES','2021-05-17','2021-05-17 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-18 12:19:06','510','2021-05-18 12:19:48',10,0),('1','140',197997,'DAILY SHIFT SALES','2021-05-18','2021-05-18 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-19 10:16:23','510','2021-05-19 10:16:54',10,0),('1','140',198192,'DAILY SHIFT SALES','2021-05-19','2021-05-19 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-19 15:56:28','510','2021-05-19 15:57:00',10,0),('1','140',198292,'DAILY SHIFT SALES','2021-05-19','2021-05-19 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-19 16:38:20','510','2021-05-19 16:38:47',10,0),('1','140',198301,'DAILY SALES SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-20 09:42:27','510','2021-05-20 09:44:21',10,0),('1','140',198420,'DAILY SHIFT SALES','2021-05-19','2021-05-19 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-20 09:50:53','510','2021-05-20 09:51:28',10,0),('1','140',198422,'DAILY SHIFT SALES','2021-05-20','2021-05-20 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-20 17:35:48','510','2021-05-20 17:36:18',10,0),('1','140',198569,'DAILY SHIFT SALES','2021-05-21','2021-05-21 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-21 18:05:35','510','2021-05-21 18:05:56',10,0),('1','140',199166,'DAILY SHIFT SALES','2021-05-23','2021-05-23 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-23 20:00:57','510','2021-05-23 20:01:45',10,0),('1','140',199380,'DAILY SHIFT SALES','2021-05-24','2021-05-24 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-25 09:43:45','510','2021-05-25 09:44:36',10,0),('1','140',199743,'DAILY SHIFT SALES','2021-05-25','2021-05-25 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-26 09:44:31','510','2021-05-26 09:45:03',10,0),('1','140',199748,'DAILY SHIFT SALES','2021-05-26','2021-05-26 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-27 12:01:34','510','2021-05-27 12:01:59',10,0),('1','140',199992,'DAILY SHIFT SALES','2021-05-27','2021-05-27 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-28 09:18:17','510','2021-05-28 09:19:08',10,0),('1','140',200159,'DAILY SHIFT SALES','2021-05-28','2021-05-28 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-29 09:44:52','510','2021-05-29 09:45:17',10,0),('1','140',200339,'DAILY SHIFT SALES','2021-05-29','2021-05-29 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-30 15:15:33','510','2021-05-30 15:16:11',10,0),('1','140',200637,'DAILY SHIFT SALES','2021-05-30','2021-05-30 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-31 08:04:26','510','2021-05-31 08:04:57',10,0),('1','140',200732,'DAILY SHIFT SALES','2021-05-31','2021-05-31 00:00:00',NULL,'510',0.00,0.00,'510','2021-05-31 08:06:17','510','2021-05-31 08:06:52',10,0),('1','140',200733,'DAILY SHIFT SALES','2021-05-31','2021-05-31 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-01 07:31:22','510','2021-06-01 07:31:56',10,0),('1','140',200948,'DAILY SHIFT SALES','2021-06-01','2021-06-01 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-02 06:25:24','510','2021-06-02 06:25:49',10,0),('1','140',201119,'DAILY SHIFT SALES','2021-06-02','2021-06-02 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-02 17:45:57','510','2021-06-02 17:46:35',10,0),('1','140',201319,'DAILY SHIFT SALES','2021-06-03','2021-06-03 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-04 06:44:23','510','2021-06-04 06:44:54',10,0),('1','140',201508,'DAILY SHIFT SALES','2021-06-04','2021-06-04 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-05 12:35:08','510','2021-06-05 12:35:34',10,0),('1','140',201885,'DAILY SHIFT SALES','2021-06-05','2021-06-05 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-06 20:36:43','510','2021-06-06 20:37:11',10,0),('1','140',202186,'DAILY SHIFT SALES','2021-06-06','2021-06-06 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-07 09:29:21','510','2021-06-07 09:29:44',10,0),('1','140',202287,'DAILY SHIFT SALES','2021-06-04','2021-06-04 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-07 09:32:16','510','2021-06-07 09:32:41',10,0),('1','140',202290,'DAILY SHIFT SALES','2021-06-07','2021-06-07 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-07 21:13:45','510','2021-06-07 21:14:15',10,0),('1','140',202440,'DAILY SHIFT SALES','2021-06-08','2021-06-08 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-09 07:59:38','510','2021-06-09 08:01:04',10,0),('1','140',202680,'DAILY SHIFT SALES','2021-06-09','2021-06-09 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-10 09:12:34','510','2021-06-10 09:15:59',10,0),('1','140',202924,'DAILY SHIFT SALES','2021-06-10','2021-06-10 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-10 19:26:24','510','2021-06-10 19:27:26',10,0),('1','140',203187,'DAILY SHIFT SALES','2021-06-11','2021-06-11 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-12 11:12:42','510','2021-06-12 11:13:18',10,0),('1','140',203389,'DAILY SHIFT SALES','2021-06-12','2021-06-12 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-13 16:01:40','510','2021-06-13 16:02:48',10,0),('1','140',203668,'DAILY SHIFT SALES','2021-06-13','2021-06-13 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-14 08:22:18','510','2021-06-14 08:22:41',10,0),('1','140',203775,'DAILY SHIFT SALES','2021-06-14','2021-06-14 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-15 08:43:21','510','2021-06-15 08:43:43',10,0),('1','140',204016,'DAILY SHIFT SALES','2021-06-15','2021-06-15 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-15 17:03:02','510','2021-06-15 17:03:41',10,0),('1','140',204196,'OPERATIONAL LOSS','2021-06-16','2021-06-16 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-16 10:41:49','510','2021-06-16 10:42:55',10,0),('1','140',204281,'DAILY SHIFT SALES','2021-06-16','2021-06-16 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-17 10:17:03','510','2021-06-17 10:17:34',10,0),('1','140',204485,'DAILY SHIFT SALES','2021-06-17','2021-06-17 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-18 07:27:14','510','2021-06-18 07:27:41',10,0),('1','140',204647,'DAILY SHIFT SALES','2021-06-18','2021-06-18 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-18 16:27:52','510','2021-06-18 16:28:35',10,0),('1','140',204952,'DAILY SHIFT SALES','2021-06-19','2021-06-19 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-19 17:53:02','510','2021-06-19 17:53:26',10,0),('1','140',205208,'DAILY SHIFT SALES','2021-06-20','2021-06-20 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-21 09:25:36','510','2021-06-21 09:26:08',10,0),('1','140',205303,'DAILY SHIFT SALES','2021-06-21','2021-06-21 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-21 17:22:47','510','2021-06-21 17:23:12',10,0),('1','140',205615,'DAILY SHIFT SALES','2021-06-22','2021-06-22 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-22 19:42:01','510','2021-06-22 19:42:46',10,0),('1','140',205701,'DAILY SHIFT SALES','2021-06-22','2021-06-22 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-23 09:43:56','510','2021-06-23 09:45:23',10,0),('1','140',205799,'DAILY SHIFT SALES','2021-06-23','2021-06-23 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-23 21:32:12','510','2021-06-23 21:32:30',10,0),('1','140',206029,'DAILY SHIFT SALES','2021-06-24','2021-06-24 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-25 10:19:06','510','2021-06-25 10:19:32',10,0),('1','140',206238,'DAILY SHIFT SALES','2021-06-25','2021-06-25 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-26 14:31:55','510','2021-06-26 14:32:16',10,0),('1','140',206505,'DAILY SHIFT SALES','2021-06-26','2021-06-26 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-27 15:30:52','510','2021-06-27 15:32:22',10,0),('1','140',206723,'DAILY SALES SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-27 15:47:51','510','2021-06-27 15:48:18',10,0),('1','140',206728,'DAILY SALES SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-28 07:59:11','510','2021-06-28 07:59:43',10,0),('1','140',206847,'DAILY SHIFT SALES','2021-06-28','2021-06-28 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-29 09:13:18','510','2021-06-29 09:13:37',10,0),('1','140',207093,'DAILY SHIFT SALES','2021-06-29','2021-06-29 00:00:00',NULL,'510',0.00,0.00,'510','2021-06-30 10:18:27','510','2021-06-30 10:18:59',10,0),('1','140',207348,'DAILY SHIFT SALES','2021-06-30','2021-06-30 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-01 08:16:14','510','2021-07-01 08:16:54',10,0),('1','140',207514,'DAILY SHIFT SALES','2021-07-01','2021-07-01 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-02 12:56:42','510','2021-07-02 12:57:01',10,0),('1','140',207812,'DAILY SALES SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-02 15:48:28','510','2021-07-02 15:48:58',10,0),('1','140',208301,'DAILY SHIFT SALES','2021-07-04','2021-07-04 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-05 13:28:12','510','2021-07-05 13:28:36',10,0),('1','140',208466,'DAILY SHIFT SALES','2021-07-05','2021-07-05 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-05 17:51:40','510','2021-07-05 17:52:09',10,0),('1','140',208762,'DAILY SHIFT SALES','2021-07-07','2021-07-07 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-07 17:23:12','510','2021-07-07 17:23:36',10,0),('1','140',209017,'DAILY SHIFT SALES','2021-07-08','2021-07-08 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-09 09:13:54','510','2021-07-09 09:14:16',10,0),('1','140',209275,'DAILY SHIFT SALES','2021-07-09','2021-07-09 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-09 22:28:30','510','2021-07-09 22:28:56',10,0),('1','140',209512,'DAILY SHIFT SALES','2021-07-10','2021-07-10 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-11 11:22:20','510','2021-07-11 11:22:39',10,0),('1','140',209726,'DAILY SHIFT SALES','2021-07-11','2021-07-11 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-12 14:35:33','510','2021-07-12 14:35:51',10,0),('1','140',210021,'DAILY SHIFT SALES','2021-07-11','2021-07-11 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-12 14:58:12','510','2021-07-12 15:01:13',10,0),('1','140',210030,'DAILY SHIFT SALES','2021-07-12','2021-07-12 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-12 20:40:49','510','2021-07-12 20:41:10',10,0),('1','140',210246,'DAILY SHIFT SALES','2021-07-13','2021-07-13 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-13 17:30:31','510','2021-07-13 17:31:02',10,0),('1','140',210360,'DAILY SHIFT SALES','2021-07-14','2021-07-14 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-15 10:47:00','510','2021-07-15 10:47:32',10,0),('1','140',210602,'DAILY SHIFT SALES','2021-07-15','2021-07-15 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-15 22:29:56','510','2021-07-15 22:30:20',10,0),('1','140',210855,'DAILY SHIFT SALES','2021-07-16','2021-07-16 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-17 05:12:28','510','2021-07-17 05:13:40',10,0),('1','140',210938,'DAILY SHIFT SALES','2021-07-17','2021-07-17 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-18 20:25:09','510','2021-07-18 20:25:35',10,0),('1','140',211349,'DAILY SHIFT SALES','2021-07-18','2021-07-18 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-18 21:42:36','510','2021-07-18 21:42:59',10,0),('1','140',211368,'DAILY SHIFT SALES','2021-07-19','2021-07-19 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-20 13:43:25','510','2021-07-20 13:43:51',10,0),('1','140',212836,'DAILY SHIFT SALES','2021-07-25','2021-07-25 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-26 06:52:51','510','2021-07-26 06:53:12',10,0),('1','140',212880,'DAILY SHIFT SALES','2021-07-26','2021-07-26 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-26 19:54:52','510','2021-07-26 19:55:17',10,0),('1','140',213134,'DAILY SHIFT SALES','2021-07-27','2021-07-27 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-27 12:22:26','510','2021-07-27 12:23:09',10,0),('1','140',213277,'DAILY SHIFT SALES','2021-07-27','2021-07-27 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-28 06:26:55','510','2021-07-28 06:27:13',10,0),('1','140',213391,'DAILY SHIFT SALES','2021-07-28','2021-07-28 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-29 05:52:49','510','2021-07-29 05:53:40',10,0),('1','140',213624,'DAILY SHIFT SALES','2021-07-29','2021-07-29 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-29 18:51:47','510','2021-07-29 18:52:08',10,0),('1','140',213875,'DAILY SHIFT SALES','2021-07-30','2021-07-30 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-31 05:39:56','510','2021-07-31 05:40:23',10,0),('1','140',214085,'DAILY SHIFT SALES','2021-07-31','2021-07-31 00:00:00',NULL,'510',0.00,0.00,'510','2021-07-31 13:38:11','510','2021-07-31 13:38:56',10,0),('1','140',214220,'DAILY SHIFT SALES','2021-07-31','2021-07-31 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-01 08:49:33','510','2021-08-01 08:50:10',10,0),('1','140',214379,'DAILY SHIFT SALES','2021-08-01','2021-08-01 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-02 06:00:51','510','2021-08-02 06:01:13',10,0),('1','140',214523,'DAILY SHIFT SALES','2021-08-02','2021-08-02 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-03 05:58:37','510','2021-08-03 05:58:57',10,0),('1','140',214771,'DAILY SHIFT SALES','2021-08-03','2021-08-03 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-04 05:54:52','510','2021-08-04 05:55:17',10,0),('1','140',214993,'DAILY SHIFT SALES','2021-08-04','2021-08-04 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-05 06:14:15','510','2021-08-05 06:14:35',10,0),('1','140',215229,'DAILY SHIFT SALES','2021-08-05','2021-08-05 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-06 06:06:58','510','2021-08-06 06:07:16',10,0),('1','140',215441,'DAILY SHIFT SALES','2021-08-06','2021-08-06 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-07 17:14:00','510','2021-08-07 17:14:40',10,0),('1','140',215849,'DAILY SHIFT SALES','2021-08-07','2021-08-07 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-08 17:16:46','510','2021-08-08 17:17:20',10,0),('1','140',216053,'DAILY SHIFT SALES','2021-08-08','2021-08-08 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-08 17:27:28','510','2021-08-08 17:28:48',10,0),('1','140',216116,'DAILY SHIFT SALES','2021-08-09','2021-08-09 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-10 06:59:39','510','2021-08-10 06:59:59',10,0),('1','140',216339,'DAILY SHIFT SALES','2021-08-10','2021-08-10 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-10 14:54:29','510','2021-08-10 14:55:05',10,0),('1','140',216482,'DAILY SHIFT SALES','2021-08-10','2021-08-10 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-11 08:19:33','510','2021-08-11 08:20:01',10,0),('1','140',216597,'DAILY SHIFT SALES','2021-08-11','2021-08-11 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-12 10:49:18','510','2021-08-12 10:49:47',10,0),('1','140',216878,'DAILY SHIFT SALES','2021-08-12','2021-08-12 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-13 10:35:39','510','2021-08-13 10:36:10',10,0),('1','140',217111,'DAILY SHIFT SALES','2021-08-13','2021-08-13 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-14 10:06:57','510','2021-08-14 10:07:23',10,0),('1','140',217357,'DAILY SHIFT SALES','2021-08-14','2021-08-14 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-14 10:08:49','510','2021-08-14 10:09:11',10,0),('1','140',217358,'DAILY SHIFT SALES','2021-08-13','2021-08-13 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-14 10:16:36','510','2021-08-14 10:17:01',10,0),('1','140',217363,'DAILY SHIFT SALES','2021-08-14','2021-08-14 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-15 09:29:39','510','2021-08-15 09:29:58',10,0),('1','140',217542,'DAILY SHIFT SALES','2021-08-15','2021-08-15 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-16 08:51:31','510','2021-08-16 08:52:17',10,0),('1','140',217768,'DAILY SHIFT SALES','2021-08-16','2021-08-16 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-16 17:36:26','510','2021-08-16 17:36:53',10,0),('1','140',218058,'DAILY SHIFT SALES','2021-08-17','2021-08-17 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-18 11:25:31','510','2021-08-18 11:26:31',10,0),('1','140',218325,'DAILY SHIFT SALES','2021-08-18','2021-08-18 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-19 11:01:40','510','2021-08-19 11:02:16',10,0),('1','140',218547,'OPERATIONAL LOSS','2021-08-18','2021-08-18 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-19 11:18:57','510','2021-08-19 11:19:20',10,0),('1','140',218552,'DAILY SHIFT SALES','2021-08-18','2021-08-18 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-19 11:51:14','510','2021-08-19 11:51:33',10,0),('1','140',218556,'DAILY SHIFT SALES','2021-08-19','2021-08-19 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-20 10:12:33','510','2021-08-20 10:13:06',10,0),('1','140',218765,'DAILY SHIFT SALES','2021-08-20','2021-08-20 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-21 10:14:23','510','2021-08-21 10:14:50',10,0),('1','140',218961,'DAILY SHIFT SALES','2021-08-21','2021-08-21 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-22 09:15:27','510','2021-08-22 09:16:04',10,0),('1','140',219170,'DAILY SHIFT SALES','2021-08-22','2021-08-22 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-23 05:46:56','510','2021-08-23 05:47:15',10,0),('1','140',219324,'DAILY SHIFT SALES','2021-08-23','2021-08-23 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-24 06:04:50','510','2021-08-24 06:05:09',10,0),('1','140',219587,'DAILY SHIFT SALES','2021-08-24','2021-08-24 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-25 05:00:44','510','2021-08-25 05:01:07',10,0),('1','140',219792,'DAILY SHIFT SALES','2021-08-25','2021-08-25 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-26 05:15:51','510','2021-08-26 05:17:01',10,0),('1','140',220024,'DAILY SHIFT SALES','2021-08-26','2021-08-26 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-27 07:31:03','510','2021-08-27 07:32:26',10,0),('1','140',220274,'DAILY SHIFT SALES','2021-08-27','2021-08-27 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-28 13:54:18','510','2021-08-28 13:54:49',10,0),('1','140',220603,'DAILY SHIFT SALES','2021-08-28','2021-08-28 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-30 10:29:15','510','2021-08-30 10:29:39',10,0),('1','140',221013,'DAILY SHIFT SALES','2021-08-29','2021-08-29 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-30 10:33:52','510','2021-08-30 10:34:16',10,0),('1','140',221018,'DAILY SHIFT SALES','2021-08-30','2021-08-30 00:00:00',NULL,'510',0.00,0.00,'510','2021-08-31 07:20:44','510','2021-08-31 07:21:08',10,0),('1','140',221166,'DAILY SHIFT SALES','2021-08-31','2021-08-31 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-01 11:42:03','510','2021-09-01 11:42:31',10,0),('1','140',221548,'DAILY SHIFT SALES','2021-09-01','2021-09-01 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-02 05:55:29','510','2021-09-02 05:55:49',10,0),('1','140',221611,'DAILY SHIFT SALES','2021-09-02','2021-09-02 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-03 06:03:24','510','2021-09-03 06:03:45',10,0),('1','140',221826,'DAILY SHIFT SALES','2021-09-03','2021-09-03 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-03 20:37:12','510','2021-09-03 20:37:31',10,0),('1','140',222052,'DAILY SHIFT SALES','2021-09-04','2021-09-04 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-04 21:41:16','510','2021-09-04 21:42:04',10,0),('1','140',222303,'DAILY SHIFT SALES','2021-09-05','2021-09-05 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-06 08:27:09','510','2021-09-06 08:27:32',10,0),('1','140',222538,'DAILY SHIFT SALES','2021-09-06','2021-09-06 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-06 12:32:09','510','2021-09-06 12:33:13',10,0),('1','140',222614,'DAILY SHIFT SALES','2021-09-06','2021-09-06 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-08 09:38:22','510','2021-09-08 09:39:17',10,0),('1','140',223004,'DAILY SHIFT SALES','2021-09-07','2021-09-07 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-08 18:31:49','510','2021-09-08 18:42:38',10,0),('1','140',223146,'DAILY SHIFT SALES','2021-09-08','2021-09-08 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-09 10:20:42','510','2021-09-09 10:21:18',10,0),('1','140',223265,'DAILY SHIFT SALES','2021-09-09','2021-09-09 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-09 20:31:58','510','2021-09-09 20:32:23',10,0),('1','140',223473,'DAILY SHIFT SALES','2021-09-09','2021-09-09 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-10 10:20:46','510','2021-09-10 10:21:49',10,0),('1','140',223488,'DAILY SHIFT SALES','2021-09-10','2021-09-10 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-11 12:49:31','510','2021-09-11 12:50:07',10,0),('1','140',223775,'DAILY SHIFT SALES','2021-09-11','2021-09-11 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-11 19:03:14','510','2021-09-11 19:03:33',10,0),('1','140',223996,'DAILY SHIFT SALES','2021-09-12','2021-09-12 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-13 06:02:35','510','2021-09-13 06:02:58',10,0),('1','140',224076,'DAILY SHIFT SALES','2021-09-13','2021-09-13 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-14 08:51:19','510','2021-09-14 08:52:25',10,0),('1','140',224370,'DAILY SHIFT SALES','2021-09-14','2021-09-14 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-15 13:43:57','510','2021-09-15 13:44:38',10,0),('1','140',224690,'DAILY SHIFT SALES','2021-09-15','2021-09-15 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-16 06:03:23','510','2021-09-16 06:03:45',10,0),('1','140',224771,'DAILY SHIFT SALES','2021-09-16','2021-09-16 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-17 06:06:28','510','2021-09-17 06:06:58',10,0),('1','140',225012,'DAILY SHIFT SALES','2021-09-17','2021-09-17 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-18 05:51:55','510','2021-09-18 05:53:06',10,0),('1','140',225258,'DAILY SHIFT SALES','2021-09-18','2021-09-18 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-19 10:21:44','510','2021-09-19 10:22:40',10,0),('1','140',225548,'DAILY SHIFT SALES','2021-09-19','2021-09-19 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-20 11:04:10','510','2021-09-20 11:04:41',10,0),('1','140',225823,'DAILY SHIFT SALES','2021-09-20','2021-09-20 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-21 10:11:20','510','2021-09-21 10:11:45',10,0),('1','140',226067,'DAILY SHIFT SALES','2021-09-21','2021-09-21 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-22 10:40:44','510','2021-09-22 10:41:07',10,0),('1','140',226317,'DAILY SHIFT SALES','2021-09-22','2021-09-22 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-23 06:39:06','510','2021-09-23 06:39:32',10,0),('1','140',226479,'DAILY SHIFT SALES','2021-09-23','2021-09-23 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-24 08:00:54','510','2021-09-24 08:02:34',10,0),('1','140',226772,'DAILY SHIFT SALES','2021-09-24','2021-09-24 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-24 15:20:28','510','2021-09-24 15:22:35',10,0),('1','140',226898,'DAILY SHIFT SALES','2021-09-24','2021-09-24 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-25 08:07:34','510','2021-09-25 08:08:10',10,0),('1','140',226991,'DAILY SHIFT SALES','2021-09-25','2021-09-25 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-26 08:53:38','510','2021-09-26 08:54:09',10,0),('1','140',227221,'DAILY SHIFT SALES','2021-09-26','2021-09-26 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-27 06:04:20','510','2021-09-27 06:04:36',10,0),('1','140',227373,'DAILY SHIFT SALES','2021-09-27','2021-09-27 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-28 10:23:45','510','2021-09-28 10:25:02',10,0),('1','140',227685,'DAILY SHIFT SALES','2021-09-28','2021-09-28 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-29 07:54:15','510','2021-09-29 07:55:01',10,0),('1','140',227885,'DAILY SHIFT SALES','2021-09-29','2021-09-29 00:00:00',NULL,'510',0.00,0.00,'510','2021-09-30 08:12:19','510','2021-09-30 08:12:46',10,0),('1','140',228146,'DAILY SHIFT SALES','2021-09-30','2021-09-30 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-01 09:57:51','510','2021-10-01 09:58:23',10,0),('1','140',228409,'DAILY SHIFT SALES','2021-10-01','2021-10-01 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-02 06:49:07','510','2021-10-02 06:49:49',10,0),('1','140',228543,'DAILY SHIFT SALES','2021-10-02','2021-10-02 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-02 14:57:59','510','2021-10-02 14:58:31',10,0),('1','140',228657,'DAILY SHIFT SALES','2021-10-02','2021-10-02 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-03 11:50:59','510','2021-10-03 11:51:28',10,0),('1','140',228829,'DAILY SHIFT SALES','2021-10-03','2021-10-03 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-04 14:18:09','510','2021-10-04 14:18:30',10,0),('1','140',229072,'DAILY SHIFT SALES','2021-10-04','2021-10-04 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-05 06:23:52','510','2021-10-05 06:24:19',10,0),('1','140',229170,'DAILY SHIFT SALES','2021-10-05','2021-10-05 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-06 08:38:25','510','2021-10-06 08:38:56',10,0),('1','140',229454,'DAILY SHIFT SALES','2021-10-06','2021-10-06 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-07 06:35:31','510','2021-10-07 06:36:06',10,0),('1','140',229665,'DAILY SHIFT SALES','2021-10-07','2021-10-07 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-07 21:32:04','510','2021-10-07 21:32:23',10,0),('1','140',229874,'DAILY SHIFT SALES','2021-10-08','2021-10-08 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-08 19:44:02','510','2021-10-08 19:44:26',10,0),('1','140',230081,'DAILY SHIFT SALES','2021-10-09','2021-10-09 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-10 04:08:54','510','2021-10-10 04:09:53',10,0),('1','140',230272,'DAILY SHIFT SALES','2021-10-10','2021-10-10 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-10 23:45:54','510','2021-10-10 23:46:19',10,0),('1','140',230514,'DAILY SHIFT SALES','2021-10-11','2021-10-11 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-12 04:45:27','510','2021-10-12 04:46:00',10,0),('1','140',230769,'DAILY SHIFT SALES','2021-10-12','2021-10-12 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-13 04:06:44','510','2021-10-13 04:07:25',10,0),('1','140',231045,'DAILY SHIFT SALES','2021-10-13','2021-10-13 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-13 21:46:32','510','2021-10-13 21:46:50',10,0),('1','140',231398,'DAILY SHIFT SALES','2021-10-14','2021-10-14 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-15 05:52:44','510','2021-10-15 05:53:09',10,0),('1','140',231632,'DAILY SHIFT SALES','2021-10-15','2021-10-15 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-16 05:02:52','510','2021-10-16 05:03:16',10,0),('1','140',231876,'DAILY SHIFT SALES','2021-10-16','2021-10-16 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-16 21:08:02','510','2021-10-16 21:08:24',10,0),('1','140',232133,'DAILY SHIFT SALES','2021-10-17','2021-10-17 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-18 08:27:29','510','2021-10-18 08:28:15',10,0),('1','140',232378,'DAILY SHIFT SALES','2021-10-18','2021-10-18 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-19 07:37:41','510','2021-10-19 07:39:54',10,0),('1','140',232624,'DAILY SHIFT SALES','2021-10-19','2021-10-19 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-20 04:33:06','510','2021-10-20 04:33:39',10,0),('1','140',232825,'DAILY SHIFT SAKES','2021-10-20','2021-10-20 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-20 17:19:31','510','2021-10-20 21:52:49',10,0),('1','140',233116,'DAILY SHIFT SALES','2021-10-21','2021-10-21 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-22 08:24:02','510','2021-10-22 08:26:02',10,0),('1','140',233427,'DAILY SHIFT SALES','2021-10-22','2021-10-22 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-23 06:01:57','510','2021-10-23 06:02:54',10,0),('1','140',233608,'DAILY SHIFT SALES','2021-10-23','2021-10-23 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-23 17:29:25','510','2021-10-23 17:30:03',10,0),('1','140',233846,'DAILY SHIFT SALES','2021-10-24','2021-10-24 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-24 21:16:04','510','2021-10-24 21:16:44',10,0),('1','140',234040,'DAILY SHIFT SALES','2021-10-25','2021-10-25 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-25 19:46:26','510','2021-10-25 19:46:58',10,0),('1','140',234291,'DAILY SHIFT SALES','2021-10-26','2021-10-26 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-27 07:10:23','510','2021-10-27 07:10:46',10,0),('1','140',234598,'DAILY SHIFT SALES','2021-10-27','2021-10-27 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-28 03:55:03','510','2021-10-28 03:55:42',10,0),('1','140',234803,'DAILY SHIFT SALES','2021-10-28','2021-10-28 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-29 08:15:17','510','2021-10-29 08:18:34',10,0),('1','140',235133,'DAILY SHIFT SALES','2021-10-29','2021-10-29 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-30 00:45:20','510','2021-10-30 00:46:02',10,0),('1','140',235290,'DAILY SHIFT SALES','2021-10-30','2021-10-30 00:00:00',NULL,'510',0.00,0.00,'510','2021-10-31 08:21:48','510','2021-10-31 08:22:56',10,0),('1','140',235577,'DAILY SHIFT SALES','2021-10-31','2021-10-31 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-01 09:21:44','510','2021-11-01 09:22:26',10,0),('1','140',235845,'DAILY SHIFT SALES','2021-11-01','2021-11-01 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-02 06:03:31','510','2021-11-02 06:06:06',10,0),('1','140',236025,'DAILY SHIFT SALES','2021-11-02','2021-11-02 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-03 07:06:29','510','2021-11-03 07:06:59',10,0),('1','140',236259,'DAILY SHIFT SALES','2021-11-03','2021-11-03 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-04 06:39:57','510','2021-11-04 06:41:26',10,0),('1','140',236530,'DAILY SHIFT SALES','2021-11-04','2021-11-04 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-05 05:36:16','510','2021-11-05 05:36:49',10,0),('1','140',236733,'DAILY SHIFT SALES','2021-11-05','2021-11-05 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-05 15:19:38','510','2021-11-05 15:19:56',10,0),('1','140',236879,'DAILY SHIFT SALES','2021-11-05','2021-11-05 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-06 05:29:38','510','2021-11-06 05:29:59',10,0),('1','140',236952,'DAILY SHIFT SAKES','2021-11-06','2021-11-06 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-07 08:21:19','510','2021-11-07 08:21:39',10,0),('1','140',237226,'DAILY SHIFT SALES','2021-11-07','2021-11-07 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-08 04:51:37','510','2021-11-08 04:51:58',10,0),('1','140',237365,'DAILY SHIFT SALES','2021-11-08','2021-11-08 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-09 06:09:16','510','2021-11-09 06:09:35',10,0),('1','140',237617,'DAILY SHIFT SALES','2021-11-09','2021-11-09 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-09 20:48:20','510','2021-11-09 20:48:41',10,0),('1','140',237863,'DAILY SHIFT SALES','2021-11-10','2021-11-10 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-11 08:10:46','510','2021-11-11 08:11:14',10,0),('1','140',238180,'DAILY SHIFT SALES','2021-11-11','2021-11-11 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-12 04:03:40','510','2021-11-12 04:04:05',10,0),('1','140',238335,'DAILY SHIFT SALES','2021-11-12','2021-11-12 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-13 05:30:48','510','2021-11-13 05:31:13',10,0),('1','140',238597,'DAILY SHIFT SALES','2021-11-13','2021-11-13 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-14 13:18:20','510','2021-11-14 13:18:55',10,0),('1','140',238949,'DAILY SHIFT SALES','2021-11-14','2021-11-14 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-15 06:31:48','510','2021-11-15 06:32:08',10,0),('1','140',239349,'DAILY SHIFT SALES','2021-11-16','2021-11-16 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-17 08:20:16','510','2021-11-17 08:20:40',10,0),('1','140',239590,'DAILY SHIFT SALES','2021-11-17','2021-11-17 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-18 05:47:17','510','2021-11-18 05:47:38',10,0),('1','140',239770,'DAILY SHIFT SALES','2021-11-18','2021-11-18 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-18 20:01:39','510','2021-11-18 20:02:01',10,0),('1','140',239951,'DAILY SHIFT SALES','2021-11-18','2021-11-18 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-18 20:03:04','510','2021-11-18 20:03:20',10,0),('1','140',239995,'DAILY SHIFT SALES','2021-11-19','2021-11-19 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-19 17:40:04','510','2021-11-19 17:40:35',10,0),('1','140',240197,'DAILY SHIFT SALES','2021-11-20','2021-11-20 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-21 11:01:34','510','2021-11-21 11:03:12',10,0),('1','140',240532,'DAILY SHIFT SALES','2021-11-21','2021-11-21 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-22 07:55:45','510','2021-11-22 07:56:20',10,0),('1','140',240750,'DAILY SHIFT SALES','2021-11-22','2021-11-22 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-23 07:47:15','510','2021-11-23 07:48:06',10,0),('1','140',241017,'DAILY SHIFT SALES','2021-11-23','2021-11-23 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-24 07:34:02','510','2021-11-24 07:34:22',10,0),('1','140',241268,'DAILY SHIFT SALES','2021-11-24','2021-11-24 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-25 06:34:50','510','2021-11-25 06:35:03',10,0),('1','140',241505,'DAILY SHIFT SALES','2021-11-25','2021-11-25 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-26 11:36:39','510','2021-11-26 11:37:28',10,0),('1','140',241846,'DAILY SHIFT SALES','2021-11-26','2021-11-26 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-27 06:36:25','510','2021-11-27 06:37:29',10,0),('1','140',241989,'DAILY SHIFT SALES','2021-11-27','2021-11-27 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-28 08:10:17','510','2021-11-28 08:10:41',10,0),('1','140',242247,'DAILY SHIFT SALES','2021-11-28','2021-11-28 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-29 04:16:48','510','2021-11-29 04:17:12',10,0),('1','140',242410,'DAILY SHIFT SALES','2021-11-29','2021-11-29 00:00:00',NULL,'510',0.00,0.00,'510','2021-11-30 06:40:24','510','2021-11-30 06:41:49',10,0),('1','140',242693,'DAILY SHIFT SALES','2021-11-30','2021-11-30 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-01 06:04:51','510','2021-12-01 06:05:38',10,0),('1','140',242920,'DAILY SHIFT SALES','2021-12-01','2021-12-01 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-02 06:06:16','510','2021-12-02 06:06:37',10,0),('1','140',243141,'DAILY SHIFT SALES','2021-12-02','2021-12-02 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-03 06:04:06','510','2021-12-03 06:04:27',10,0),('1','140',243370,'OPERATIONAL LOSS','2021-12-03','2021-12-03 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-03 06:13:24','510','2021-12-03 06:13:44',10,0),('1','140',243377,'DAILY SHIFT SALES','2021-12-03','2021-12-03 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-04 05:40:34','510','2021-12-04 05:41:23',10,0),('1','140',243595,'DAILY SHIFT SALES','2021-12-04','2021-12-04 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-05 08:55:37','510','2021-12-05 08:56:45',10,0),('1','140',243893,'DAILY SHIFT SALES','2021-12-05','2021-12-05 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-06 05:56:58','510','2021-12-06 05:57:28',10,0),('1','140',244049,'DAILY SHIFT SALES','2021-12-06','2021-12-06 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-07 05:12:04','510','2021-12-07 05:12:24',10,0),('1','140',244274,'DAILY SHIFT SALES','2021-12-07','2021-12-07 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-08 07:02:46','510','2021-12-08 07:03:38',10,0),('1','140',244541,'DAILY SHIFT SALES','2021-12-08','2021-12-08 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-09 04:07:07','510','2021-12-09 04:07:34',10,0),('1','140',244721,'DAILY SHIFT SALES','2021-12-09','2021-12-09 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-10 07:01:22','510','2021-12-10 07:02:17',10,0),('1','140',245009,'DAILY SHIFT SALES','2021-12-10','2021-12-10 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-11 06:09:48','510','2021-12-11 06:10:15',10,0),('1','140',245220,'DAILY SHIFT SALES','2021-12-11','2021-12-11 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-12 07:46:11','510','2021-12-12 07:47:23',10,0),('1','140',245480,'DAILY SHIFT SALES','2021-12-12','2021-12-12 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-12 22:13:37','510','2021-12-12 22:14:09',10,0),('1','140',245669,'DAILY SHIFT SALES','2021-12-13','2021-12-13 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-13 20:55:51','510','2021-12-13 20:56:22',10,0),('1','140',245928,'DAILY SHIFT SALES','2021-12-14','2021-12-14 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-14 19:57:50','510','2021-12-14 19:58:11',10,0),('1','140',246185,'DAILY SHIFT SALES','2021-12-15','2021-12-15 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-15 20:34:39','510','2021-12-15 20:35:22',10,0),('1','140',246482,'DAILY SHIFT SALES','2021-12-16','2021-12-16 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-17 05:50:35','510','2021-12-17 05:50:56',10,0),('1','140',246697,'DAILY SHIFT SALES','2021-12-17','2021-12-17 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-17 20:30:38','510','2021-12-17 20:31:00',10,0),('1','140',246934,'DAILY SHIFT SALES','2021-12-18','2021-12-18 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-18 20:24:21','510','2021-12-18 20:25:16',10,0),('1','140',247196,'DAILY SHIFT SALES','2021-12-19','2021-12-19 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-20 04:35:50','510','2021-12-20 04:36:20',10,0),('1','140',247377,'DAILY SHIFT SALES','2021-12-20','2021-12-20 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-20 20:20:15','510','2021-12-20 20:20:40',10,0),('1','140',247668,'DAILY SHIFT SALES','2021-12-21','2021-12-21 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-22 04:10:39','510','2021-12-22 04:11:04',10,0),('1','140',247885,'DAILY SHIFT SALES','2021-12-22','2021-12-22 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-23 01:02:04','510','2021-12-23 01:02:33',10,0),('1','140',248154,'DAILY SHIFT SALES','2021-12-23','2021-12-23 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-24 05:01:46','510','2021-12-24 05:02:08',10,0),('1','140',248385,'DAILY SHIFT SALES','2021-12-24','2021-12-24 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-24 23:16:19','510','2021-12-24 23:17:00',10,0),('1','140',248653,'DAILY SHIFT SALES','2021-12-25','2021-12-25 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-25 22:25:04','510','2021-12-25 22:25:47',10,0),('1','140',248936,'DAILY SHIFT SALES','2021-12-26','2021-12-26 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-26 22:55:13','510','2021-12-26 22:55:45',10,0),('1','140',249105,'DAILY SHIFT SALES','2021-12-27','2021-12-27 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-27 22:23:28','510','2021-12-27 22:23:49',10,0),('1','140',249371,'DAILY SHIFT SALES','2021-12-28','2021-12-28 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-29 01:01:40','510','2021-12-29 01:02:07',10,0),('1','140',249606,'DAILY SHIFT SALES','2021-12-29','2021-12-29 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-29 21:30:21','510','2021-12-29 21:31:09',10,0),('1','140',249858,'DAILY SHIFT SALES','2021-12-30','2021-12-30 00:00:00',NULL,'510',0.00,0.00,'510','2021-12-30 22:20:05','510','2021-12-30 22:21:57',10,0),('1','140',250095,'DAILY SHIFT SALES','2021-12-31','2021-12-31 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-01 06:14:25','510','2022-01-01 06:15:09',10,0),('1','140',250337,'DAILY SHIFT SALES','2022-01-01','2022-01-01 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-01 08:24:28','510','2022-01-01 08:25:02',10,0),('1','140',250389,'DAILY SHIFT SALES','2022-01-01','2022-01-01 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-02 09:25:21','510','2022-01-02 09:25:47',10,0),('1','140',250627,'DAILY SHIFT SALES','2022-01-02','2022-01-02 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-03 05:35:12','510','2022-01-03 05:35:32',10,0),('1','140',250787,'DAILY SHIFT SALES','2022-01-03','2022-01-03 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-03 20:30:39','510','2022-01-03 20:31:03',10,0),('1','140',251022,'DAILY SHIFT SALES','2022-01-04','2022-01-04 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-04 22:42:54','510','2022-01-04 22:43:12',10,0),('1','140',251273,'DAILY SHIFT SALES','2022-01-05','2022-01-05 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-05 22:48:36','510','2022-01-05 22:49:04',10,0),('1','140',251523,'DAILY SHIFT SALES','2022-01-06','2022-01-06 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-07 07:15:44','510','2022-01-07 07:16:30',10,0),('1','140',251768,'DAILY SHIFT SALES','2022-01-07','2022-01-07 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-07 22:35:42','510','2022-01-07 22:36:20',10,0),('1','140',251988,'DAILY SHIFT SALES','2022-01-08','2022-01-08 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-08 21:51:09','510','2022-01-08 21:51:31',10,0),('1','140',252248,'DAILY SHIFT SALES','2022-01-09','2022-01-09 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-09 23:17:36','510','2022-01-09 23:18:11',10,0),('1','140',252475,'DAILY SHIFT SALES','2022-01-10','2022-01-10 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-10 22:52:28','510','2022-01-10 22:53:05',10,0),('1','140',252714,'DAILY SHIFT SALES','2022-01-11','2022-01-11 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-12 06:39:52','510','2022-01-12 06:40:25',10,0),('1','140',252961,'DAILY SHIFT SALES','2022-01-12','2022-01-12 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-13 00:12:57','510','2022-01-13 00:13:50',10,0),('1','140',253213,'DAILY SHIFT SALES','2022-01-13','2022-01-13 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-14 02:12:58','510','2022-01-14 02:13:31',10,0),('1','140',253455,'DAILY SHIFT SALES','2022-01-14','2022-01-14 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-14 19:56:21','510','2022-01-14 19:56:49',10,0),('1','140',253700,'DAILY SHIFT SALES','2022-01-15','2022-01-15 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-15 22:07:41','510','2022-01-15 22:08:18',10,0),('1','140',253952,'DAILY SHIFT SALES','2022-01-16','2022-01-16 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-16 23:46:30','510','2022-01-16 23:46:59',10,0),('1','140',254500,'DAILY SHIFT SALES','2022-01-18','2022-01-18 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-19 03:39:25','510','2022-01-19 03:39:53',10,0),('1','140',254680,'DAILY SHIFT SALES','2022-01-19','2022-01-19 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-19 08:05:51','510','2022-01-19 08:06:48',10,0),('1','140',254729,'OPERATIONAL LOSS','2022-01-19','2022-01-19 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-19 08:15:04','510','2022-01-19 08:16:39',10,0),('1','140',254738,'OPERATIONAL LOSS','2022-01-19','2022-01-19 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-19 08:22:28','510','2022-01-19 08:22:54',10,0),('1','140',254742,'OPERATIONAL LOSS','2022-01-01','2022-01-01 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-19 08:29:29','510','2022-01-19 08:29:53',10,0),('1','140',254745,'OPERATIONAL LOSS','2022-01-10','2022-01-10 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-19 08:37:42','510','2022-01-19 08:38:04',10,0),('1','140',254748,'OPERATIONAL LOSS','2022-01-15','2022-01-15 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-19 08:42:46','510','2022-01-19 08:43:45',10,0),('1','140',254750,'DAILY SHIFT SALES','2022-01-19','2022-01-19 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-19 08:51:36','510','2022-01-19 08:51:55',10,0),('1','140',254753,'DAILY SHIFT SALES','2022-01-19','2022-01-19 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-20 02:23:16','510','2022-01-20 02:23:50',10,0),('1','140',254935,'DAILY SHIFT SALES','2022-01-20','2022-01-20 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-21 01:51:24','510','2022-01-21 01:51:59',10,0),('1','140',255185,'DAILY SHIFT SALES','2022-01-21','2022-01-21 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-21 22:01:33','510','2022-01-21 22:01:56',10,0),('1','140',255459,'DAILY SHIFT SALES','2022-01-22','2022-01-22 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-23 09:09:44','510','2022-01-23 09:11:00',10,0),('1','140',255763,'DAILY SHIFT SALES','2022-01-23','2022-01-23 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-23 16:58:41','510','2022-01-23 17:00:06',10,0),('1','140',255871,'DAILY SHIFT SALES','2022-01-23','2022-01-23 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-23 22:11:08','510','2022-01-23 22:11:33',10,0),('1','140',255942,'DAILY SHIFT SALES','2022-01-24','2022-01-24 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-25 05:29:50','510','2022-01-25 05:30:50',10,0),('1','140',256200,'DAILY SHIFT SALES','2022-01-25','2022-01-25 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-26 07:04:37','510','2022-01-26 07:05:30',10,0),('1','140',256484,'DAILY SHIFT SALES','2022-01-26','2022-01-26 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-26 22:01:28','510','2022-01-26 22:02:27',10,0),('1','140',256726,'DAILY SHIFT SALES','2022-01-27','2022-01-27 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-27 21:38:45','510','2022-01-27 21:39:09',10,0),('1','140',256963,'DAILY SHIFT SALES','2022-01-28','2022-01-28 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-28 22:08:31','510','2022-01-28 22:09:30',10,0),('1','140',257228,'DAILY SHIFT SALES','2022-01-29','2022-01-29 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-29 23:32:19','510','2022-01-29 23:32:45',10,0),('1','140',257532,'DAILY SHIFT SALES','2022-01-30','2022-01-30 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-30 09:51:00','510','2022-01-30 09:51:26',10,0),('1','140',257541,'OPERATIONAL LOSS','2022-01-30','2022-01-30 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-30 09:59:32','510','2022-01-30 09:59:47',10,0),('1','140',257544,'DAILY SHIFT SALES','2022-01-30','2022-01-30 00:00:00',NULL,'510',0.00,0.00,'510','2022-01-31 09:14:03','510','2022-01-31 09:15:00',10,0),('1','140',257545,'DAILY SHIFT SALES','2022-01-31','2022-01-31 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-01 06:55:06','510','2022-02-01 06:55:25',10,0),('1','140',257546,'DAILY SHIFT SALES','2022-02-01','2022-02-01 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-01 23:09:42','510','2022-02-01 23:09:59',10,0),('1','140',257547,'DAILY SHIFT SALES','2022-02-02','2022-02-02 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-02 22:50:32','510','2022-02-02 22:50:50',10,0),('1','140',257548,'DAILY SHIFT SALES','2022-02-03','2022-02-03 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-03 19:52:59','510','2022-02-03 19:53:20',10,0),('1','140',257549,'DAILY SHIFT SALES','2022-02-04','2022-02-04 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-04 21:34:57','510','2022-02-04 21:35:17',10,0),('1','140',257550,'OPERATIONAL LOSS','2022-02-05','2022-02-05 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-05 06:19:27','510','2022-02-05 06:19:46',10,0),('1','140',257551,'DAILY SHIFT SALES','2022-02-05','2022-02-05 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-05 06:26:29','510','2022-02-05 06:26:48',10,0),('1','140',257552,'DAILY SHIFT SALES','2022-02-05','2022-02-05 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-06 09:28:27','510','2022-02-06 09:28:50',10,0),('1','140',257553,'DAILY SHIFT SALES','2022-02-06','2022-02-06 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-06 18:00:04','510','2022-02-06 18:00:27',10,0),('1','140',257554,'DAILY SHIFT SALES','2022-02-07','2022-02-07 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-07 19:02:08','510','2022-02-07 19:15:56',10,0),('1','140',257555,'DAILY SHIFT SALES','2022-02-08','2022-02-08 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-08 18:49:29','510','2022-02-08 18:57:33',10,0),('1','140',257556,'DAILY SALES SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-09 18:42:49','510','2022-02-09 18:44:14',10,0),('1','140',257557,'DAILY SALES SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-10 12:38:09','510','2022-02-10 12:39:17',10,0),('1','140',257558,'OPERATIONAL LOSS','2022-02-11','2022-02-11 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-12 09:23:33','510','2022-02-12 09:23:50',10,0),('1','140',257559,'OPERATIONAL LOSS','2022-02-12','2022-02-12 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-12 09:30:24','510','2022-02-12 09:30:39',10,0),('1','140',257560,'DAILY SHIFT SALES','2022-02-12','2022-02-12 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-12 18:53:43','510','2022-02-12 18:54:06',10,0),('1','140',257561,'DAILY SALES SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-13 19:02:20','510','2022-02-13 19:05:00',10,0),('1','140',257562,'DAILY SALES SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-14 19:49:22','510','2022-02-14 20:08:48',10,0),('1','140',257563,'DAILY SALES SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-15 18:34:11','510','2022-02-15 18:52:39',10,0),('1','140',257564,'DAILY SALES SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-16 18:24:28','510','2022-02-16 18:24:52',10,0),('1','140',257565,'DAILY SALES SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-17 09:49:15','510','2022-02-17 09:49:40',10,0),('1','140',257566,'DAILY SALES SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-17 11:54:18','510','2022-02-17 11:56:50',10,0),('1','140',257567,'DAILY SALES SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-18 18:22:49','510','2022-02-18 18:24:16',10,0),('1','140',257568,'DAILY SALES SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-19 18:13:18','510','2022-02-19 18:21:54',10,0),('1','140',257569,'DAILY SALES SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-20 16:16:42','510','2022-02-20 16:18:23',10,0),('1','140',257570,'DAILY SALES SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'510',0.00,0.00,'510','2022-02-21 18:22:35','510','2022-02-21 18:27:32',10,0),('1','140',257571,'DAILY SALES SHIFT','2022-02-22','2022-02-22 07:07:40','2022-02-23 07:07:40','510',0.00,0.00,'510','2022-02-22 18:39:45','510','2022-02-22 18:41:37',10,0),('1','140',257572,'DAILY SALES SHIFT','2022-02-23','2022-02-23 07:09:58','2022-02-24 07:09:58','510',0.00,0.00,'510','2022-02-23 18:37:02','510','2022-02-23 18:43:21',10,0),('1','140',257573,'DAILY SALES SHIFT','2022-02-24','2022-02-24 07:07:06','2022-02-25 07:07:06','510',0.00,0.00,'510','2022-02-24 18:24:26','510','2022-02-24 18:25:05',10,0),('1','140',257574,'OPERATIONAL LOSS','2022-02-25','2022-02-25 10:16:44','2022-02-26 10:16:44','510',0.00,0.00,'510','2022-02-25 13:53:18','510','2022-02-25 13:53:39',10,0),('1','140',257575,'DAILY SALES SHIFT','2022-02-25','2022-02-25 13:55:00','2022-02-26 13:55:00','510',0.00,0.00,'510','2022-02-25 18:52:30','510','2022-02-25 18:52:59',10,0),('1','140',257576,'DAILY SALES SHIFT','2022-02-26','2022-02-26 07:13:43','2022-02-27 07:13:43','510',0.00,0.00,'510','2022-02-26 18:10:34','510','2022-02-26 18:10:55',10,0),('1','140',257577,'DAILY SALES SHIFT','2022-02-27','2022-02-27 09:53:46','2022-02-28 09:53:46','510',0.00,0.00,'510','2022-02-27 16:36:05','510','2022-02-27 16:36:23',10,0),('1','140',257578,'DAILY SALES SHIFT','2022-02-28','2022-02-28 07:14:37','2022-03-01 07:14:37','510',0.00,0.00,'510','2022-02-28 18:49:47','510','2022-02-28 19:10:22',10,0),('1','140',257579,'DAILY SALES SHIFT','2022-03-01','2022-03-01 07:09:46','2022-03-02 07:09:46','510',0.00,0.00,'510','2022-03-01 19:00:23','510','2022-03-01 19:02:14',10,0),('1','140',257580,'DAILY SALES SHIFT','2022-03-02','2022-03-02 07:19:06','2022-03-03 07:19:06','510',0.00,0.00,'510','2022-03-02 18:12:01','510','2022-03-02 18:13:27',10,0),('1','140',257581,'DAILY SALES SHIFT','2022-03-03','2022-03-03 07:15:11','2022-03-04 07:15:11','510',0.00,0.00,'510','2022-03-03 19:01:53','510','2022-03-03 19:02:10',10,0),('1','140',257582,'DAILY SALES SHIFT','2022-03-04','2022-03-04 07:08:29','2022-03-05 07:08:29','510',0.00,0.00,'510','2022-03-04 18:19:54','510','2022-03-04 18:20:24',10,0),('1','140',257583,'DAILY SALES SHIFT','2022-03-05','2022-03-05 07:08:58','2022-03-06 07:08:58','510',0.00,0.00,'510','2022-03-05 18:24:53','510','2022-03-05 19:09:29',10,0),('1','140',257584,'DAILY SALES SHIFT','2022-03-06','2022-03-06 08:56:39','2022-03-07 08:56:39','510',0.00,0.00,'510','2022-03-06 17:55:19','510','2022-03-06 17:58:00',10,0),('1','140',257585,'OPERATIONAL LOSS','2022-03-10','2022-03-10 12:03:56','2022-03-11 12:03:56','510',0.00,0.00,'510','2022-03-10 12:10:04','510','2022-03-10 12:10:23',10,0),('1','140',257586,'DAILY SHIFT SALES','2022-03-10','2022-03-10 12:26:56','2022-03-11 12:26:56','510',0.00,0.00,'510','2022-03-10 21:45:06','510','2022-03-10 21:46:23',10,0),('1','140',257587,'DAILY SHIFT SALES','2022-03-11','2022-03-11 07:28:43','2022-03-12 07:28:43','510',0.00,0.00,'510','2022-03-11 18:44:57','510','2022-03-11 18:46:40',10,0),('1','140',257588,'DAILY SHIFT SALES','2022-03-12','2022-03-12 07:09:43','2022-03-13 07:09:43','510',0.00,0.00,'510','2022-03-12 18:14:33','510','2022-03-12 18:14:51',10,0),('1','140',257589,'DAILY SHIFT SALES','2022-03-13','2022-03-13 10:19:07','2022-03-14 10:19:07','510',0.00,0.00,'510','2022-03-13 18:39:58','510','2022-03-13 18:41:18',10,0),('1','140',257590,'DAILY SHIFT SALES','2022-03-14','2022-03-14 07:01:37','2022-03-15 07:01:37','510',0.00,0.00,'510','2022-03-14 18:11:52','510','2022-03-14 18:12:18',10,0),('1','140',257591,'DAILY SHIFT SALES','2022-03-15','2022-03-15 07:18:14','2022-03-16 07:18:14','510',0.00,0.00,'510','2022-03-15 18:14:06','510','2022-03-15 18:14:21',10,0),('1','140',257592,'DAILY SHIFT SALES','2022-03-16','2022-03-16 07:06:22','2022-03-17 07:06:22','510',0.00,0.00,'510','2022-03-16 18:09:15','510','2022-03-16 18:09:49',10,0),('1','140',257593,'DAILY SHIFT SALES','2022-03-17','2022-03-17 07:28:44','2022-03-18 07:28:44','510',0.00,0.00,'510','2022-03-17 18:01:18','510','2022-03-17 18:07:16',10,0),('1','140',257594,'DAILY SHIFT SALES','2022-03-18','2022-03-18 07:14:16','2022-03-19 07:14:16','510',0.00,0.00,'510','2022-03-18 18:08:14','510','2022-03-18 18:08:31',10,0),('1','140',257595,'DAILY SHIFT SALES','2022-03-19','2022-03-19 07:15:33','2022-03-20 07:15:33','510',0.00,0.00,'510','2022-03-19 18:06:40','510','2022-03-19 18:07:15',10,0),('1','140',257596,'DAILY SHIFT SALES88372','2022-03-20','2022-03-20 09:56:28','2022-03-21 09:56:28','510',0.00,0.00,'510','2022-03-20 16:16:14','510','2022-03-20 16:16:32',10,0),('1','140',257597,'DAILY SHIFT SALES','2022-03-21','2022-03-21 07:08:58','2022-03-22 07:08:58','510',0.00,0.00,'510','2022-03-21 18:15:44','510','2022-03-21 18:16:27',10,0),('1','140',257598,'DAILY SHIFT SALES','2022-03-22','2022-03-22 07:05:49','2022-03-23 07:05:49','510',0.00,0.00,'510','2022-03-22 18:19:48','510','2022-03-22 18:22:24',10,0),('1','140',257599,'DAILY SHIFT SALES','2022-03-23','2022-03-23 07:08:02','2022-03-24 07:08:02','510',0.00,0.00,'510','2022-03-23 18:18:52','510','2022-03-23 18:19:29',10,0),('1','140',257600,'DAILY SHIFT SALES','2022-03-24','2022-03-24 07:08:14','2022-03-25 07:08:14','510',0.00,0.00,'510','2022-03-24 18:15:24','510','2022-03-24 18:15:46',10,0),('1','140',257601,'DAILY SHIFT SALES','2022-03-25','2022-03-25 07:03:47','2022-03-26 07:03:47','510',0.00,0.00,'510','2022-03-25 18:12:10','510','2022-03-25 18:16:19',10,0),('1','140',257602,'DAILY SHIFT SALES','2022-03-26','2022-03-26 07:05:01','2022-03-27 07:05:01','510',0.00,0.00,'510','2022-03-26 18:11:22','510','2022-03-26 18:11:40',10,0),('1','140',257603,'DAILY SHIFT SALES','2022-03-27','2022-03-27 10:00:52','2022-03-28 10:00:52','510',0.00,0.00,'510','2022-03-27 16:24:28','510','2022-03-27 16:24:56',10,0),('1','140',257604,'DAILY SHIFT SALES','2022-03-28','2022-03-28 07:05:10','2022-03-29 07:05:10','510',0.00,0.00,'510','2022-03-28 18:11:27','510','2022-03-28 18:11:44',10,0),('1','140',257605,'DAILY SHIFT SALES','2022-03-29','2022-03-29 07:02:41','2022-03-30 07:02:41','510',0.00,0.00,'510','2022-03-29 18:08:40','510','2022-03-29 18:08:58',10,0),('1','140',257606,'DAILY SHIFT SALES','2022-03-30','2022-03-30 07:01:41','2022-03-31 07:01:41','510',0.00,0.00,'510','2022-03-30 18:05:23','510','2022-03-30 18:05:45',10,0),('1','140',257607,'DAILY SHIFT SALES','2022-03-31','2022-03-31 07:04:40','2022-04-01 07:04:40','510',0.00,0.00,'510','2022-03-31 18:16:20','510','2022-03-31 18:16:41',10,0),('1','140',257608,'DAILY SHIFT SALES','2022-04-01','2022-04-01 07:00:45','2022-04-02 07:00:45','510',0.00,0.00,'510','2022-04-01 18:37:19','510','2022-04-01 18:37:37',10,0),('1','140',257609,'OPERATIONAL LOSS','2022-04-01','2022-07-18 08:32:36','2022-07-19 08:32:36','510',0.00,0.00,'510','2022-07-18 09:12:31','510','2022-07-18 09:12:43',10,0),('1','140',257610,'DAILY SHIFT SALES','2022-07-18','2022-07-18 09:13:25','2022-07-19 09:13:25','510',0.00,0.00,'510','2022-07-18 18:15:46','510','2022-07-18 18:17:27',10,0),('1','140',257611,'DAILY SHIFT SALES','2022-07-19','2022-07-19 06:47:29','2022-07-20 06:47:29','510',0.00,0.00,'510','2022-07-19 18:41:38','510','2022-07-19 18:42:02',10,0),('1','140',257612,'DAILY SHIFT SALES','2022-07-20','2022-07-20 06:40:46','2022-07-21 06:40:46','510',0.00,0.00,'510','2022-07-21 05:55:11','510','2022-07-21 05:55:26',10,0),('1','140',257613,'DAILY SHIFT SALES','2022-07-21','2022-07-21 06:47:23','2022-07-22 06:47:23','510',0.00,0.00,'510','2022-07-21 18:13:09','510','2022-07-21 18:14:48',10,0),('1','140',257614,'DAILY SHIFT SALES','2022-07-22','2022-07-22 06:28:33','2022-07-23 06:28:33','510',0.00,0.00,'510','2022-07-22 21:09:27','510','2022-07-22 21:09:42',10,0),('1','140',257615,'DAILY SHIFT SALES','2022-07-23','2022-07-23 07:03:54','2022-07-24 07:03:54','510',0.00,0.00,'510','2022-07-23 19:24:36','510','2022-07-23 19:25:04',10,0),('1','140',257616,'DAILY SHIFT SALES','2022-07-24','2022-07-24 10:04:42','2022-07-25 10:04:42','510',0.00,0.00,'510','2022-07-24 16:16:27','510','2022-07-24 16:17:09',10,0),('1','140',257617,'DAILY SHIFT SALES','2022-07-25','2022-07-25 07:30:20','2022-07-26 07:30:20','510',0.00,0.00,'510','2022-07-25 18:28:11','510','2022-07-25 18:28:38',10,0),('1','140',257618,'DAILY SHIFT SALES','2022-07-26','2022-07-26 06:52:01','2022-07-27 06:52:01','510',0.00,0.00,'510','2022-07-26 18:34:07','510','2022-07-26 18:34:31',10,0),('1','140',257619,'DAILY SHIFT SALES','2022-07-27','2022-07-27 06:56:04','2022-07-28 06:56:04','510',0.00,0.00,'510','2022-07-27 18:13:14','510','2022-07-27 18:14:02',10,0),('1','140',257620,'DAILY SHIFT SALES','2022-07-28','2022-07-28 06:39:34','2022-07-29 06:39:34','510',0.00,0.00,'510','2022-07-28 18:44:25','510','2022-07-28 18:44:53',10,0),('1','140',257621,'DAILY SHIFT SALES','2022-07-29','2022-07-29 07:20:43','2022-07-30 07:20:43','510',0.00,0.00,'510','2022-07-29 18:41:24','510','2022-07-29 18:41:49',10,0),('1','140',257622,'DAILY SHIFT SALES','2022-07-30','2022-07-30 07:29:48','2022-07-31 07:29:48','510',0.00,0.00,'510','2022-07-30 20:39:24','510','2022-07-30 20:39:54',10,0),('1','140',257623,'DAILY SHIFT SALES','2022-07-31','2022-07-31 14:48:04','2022-08-01 14:48:04','510',0.00,0.00,'510','2022-07-31 14:49:43','510','2022-07-31 14:50:12',10,0),('1','140',257624,'OPERATIONAL LOSS','2022-07-31','2022-07-31 14:51:27','2022-08-01 14:51:27','510',0.00,0.00,'510','2022-07-31 15:01:06','510','2022-07-31 15:01:32',10,0),('1','140',257625,'DAILY SHIFT SALES','2022-07-31','2022-07-31 16:34:50','2022-08-01 16:34:50','510',0.00,0.00,'510','2022-07-31 18:49:36','510','2022-07-31 18:50:00',10,0),('1','140',257626,'DAILY SHIFT SALES','2022-08-01','2022-08-01 06:49:40','2022-08-02 06:49:40','510',0.00,0.00,'510','2022-08-01 18:38:01','510','2022-08-01 18:38:21',10,0),('1','140',257627,'DAILY SHIFT SALES','2022-08-02','2022-08-02 06:54:27','2022-08-03 06:54:27','510',0.00,0.00,'510','2022-08-02 18:42:41','510','2022-08-02 18:43:41',10,0),('1','140',257628,'DAILY SHIFT SALES','2022-08-03','2022-08-03 07:09:52','2022-08-04 07:09:52','510',0.00,0.00,'510','2022-08-03 18:12:02','510','2022-08-03 18:12:29',10,0),('1','140',257629,'DAILY SHIFT SALES','2022-08-04','2022-08-04 06:56:17','2022-08-05 06:56:17','510',0.00,0.00,'510','2022-08-04 18:15:56','510','2022-08-04 18:16:19',10,0),('1','140',257630,'DAILY SHIFT SALES','2022-08-08','2022-08-08 14:00:25','2022-08-09 14:00:25','510',0.00,0.00,'510','2022-08-08 21:08:41','510','2022-08-08 21:09:02',10,0),('1','140',257631,'DAILY SHIFT SALES','2022-08-09','2022-08-09 07:04:55','2022-08-10 07:04:55','510',0.00,0.00,'510','2022-08-09 13:43:00','510','2022-08-09 13:43:53',10,0),('1','140',257632,'OPERATIONAL LOSS','2022-08-09','2022-08-09 13:45:04','2022-08-10 13:45:04','510',0.00,0.00,'510','2022-08-09 13:53:02','510','2022-08-09 13:53:24',10,0),('1','140',257633,'DAILY SHIFT SALES','2022-08-09','2022-08-09 14:03:21','2022-08-10 14:03:21','510',0.00,0.00,'510','2022-08-09 18:23:13','510','2022-08-09 18:23:36',10,0),('1','140',257634,'DAILY SHIFT SALESFORCE','2022-08-10','2022-08-10 07:13:13','2022-08-11 07:13:13','510',0.00,0.00,'510','2022-08-10 20:09:16','510','2022-08-10 20:09:35',10,0),('1','140',257635,'DAILY SHIFT SALES','2022-08-11','2022-08-11 07:22:10','2022-08-12 07:22:10','510',0.00,0.00,'510','2022-08-11 21:28:26','510','2022-08-11 21:28:46',10,0),('1','140',257636,'DAILY SHIFT SALES','2022-08-12','2022-08-12 06:45:36','2022-08-13 06:45:36','510',0.00,0.00,'510','2022-08-13 05:59:45','510','2022-08-13 06:00:03',10,0),('1','140',257637,'DAILY SHIFT SALES','2022-08-13','2022-08-13 06:59:24','2022-08-14 06:59:24','510',0.00,0.00,'510','2022-08-13 18:14:34','510','2022-08-13 18:14:53',10,0),('1','140',257638,'DAILY SHIFT SALES','2022-08-14','2022-08-14 10:13:44','2022-08-15 10:13:44','510',0.00,0.00,'510','2022-08-14 16:40:24','510','2022-08-14 16:41:48',10,0),('1','140',257639,'DAILY SHIFT SALES','2022-08-15','2022-08-15 07:20:02','2022-08-16 07:20:02','510',0.00,0.00,'510','2022-08-15 18:10:42','510','2022-08-15 18:11:02',10,0),('1','140',257640,'DAILY SHIFT SALES','2022-08-16','2022-08-16 07:11:41','2022-08-17 07:11:41','510',0.00,0.00,'510','2022-08-16 18:13:17','510','2022-08-16 18:14:08',10,0),('1','140',257641,'DAILY SHIFT SALES','2022-08-17','2022-08-17 07:13:46','2022-08-18 07:13:46','510',0.00,0.00,'510','2022-08-17 18:33:40','510','2022-08-17 18:34:03',10,0),('1','140',257642,'DAILY SHIFT SALES','2022-08-18','2022-08-18 07:11:58','2022-08-19 07:11:58','510',0.00,0.00,'510','2022-08-18 18:36:38','510','2022-08-18 18:36:57',10,0),('1','140',257643,'DAILY SHIFT SALES','2022-08-19','2022-08-19 07:23:14','2022-08-20 07:23:14','510',0.00,0.00,'510','2022-08-19 18:11:59','510','2022-08-19 18:12:20',10,0),('1','140',257644,'DAILY SHIFT SALES','2022-08-20','2022-08-20 07:45:15','2022-08-21 07:45:15','510',0.00,0.00,'510','2022-08-20 15:10:15','510','2022-08-20 15:11:22',10,0),('1','140',257645,'OPERATIONAL LOSS','2022-08-20','2022-08-20 15:12:28','2022-08-21 15:12:28','510',0.00,0.00,'510','2022-08-20 15:18:45','510','2022-08-20 15:19:05',10,0),('1','140',257646,'DAILY SHIFT SALES','2022-08-20','2022-08-20 16:01:41','2022-08-21 16:01:41','510',0.00,0.00,'510','2022-08-20 22:55:34','510','2022-08-20 22:55:49',10,0),('1','140',257647,'DAILY SHIFT SALES','2022-08-21','2022-08-21 09:35:07','2022-08-22 09:35:07','510',0.00,0.00,'510','2022-08-21 20:28:03','510','2022-08-21 20:28:31',10,0),('1','140',257648,'DAILY SHIFT SALES','2022-08-22','2022-08-22 07:13:13','2022-08-23 07:13:13','510',0.00,0.00,'510','2022-08-22 18:04:29','510','2022-08-22 18:04:48',10,0),('1','140',257649,'DAILY SHIFT SALES','2022-08-23','2022-08-23 06:34:29','2022-08-24 06:34:29','510',0.00,0.00,'510','2022-08-23 18:08:10','510','2022-08-23 18:08:32',10,0),('1','140',257650,'DAILY SHIFT SALES','2022-08-24','2022-08-24 07:06:44','2022-08-25 07:06:44','510',0.00,0.00,'510','2022-08-24 18:14:20','510','2022-08-24 18:14:48',10,0),('1','140',257651,'DAILY SHIFT SALES','2022-08-25','2022-08-25 07:27:31','2022-08-26 07:27:31','510',0.00,0.00,'510','2022-08-25 18:14:46','510','2022-08-25 18:15:06',10,0),('1','140',257652,'DAILY SHIFT SALES','2022-08-26','2022-08-26 06:59:53','2022-08-27 06:59:53','510',0.00,0.00,'510','2022-08-26 18:16:44','510','2022-08-26 18:17:02',10,0),('1','140',257653,'DAILY SHIFT SALES','2022-08-27','2022-08-27 07:09:18','2022-08-28 07:09:18','510',0.00,0.00,'510','2022-08-27 19:51:06','510','2022-08-27 19:51:22',10,0),('1','140',257654,'DAILY SHIFT SALES','2022-08-28','2022-08-28 10:13:25','2022-08-29 10:13:25','510',0.00,0.00,'510','2022-08-28 18:13:29','510','2022-08-28 18:13:53',10,0),('1','140',257655,'DAILY SHIFT SALES','2022-08-29','2022-08-29 06:48:42','2022-08-30 06:48:42','510',0.00,0.00,'510','2022-08-29 20:04:16','510','2022-08-29 20:04:37',10,0),('1','140',257656,'DAILY SHIFT SALES','2022-08-30','2022-08-30 06:26:54','2022-08-31 06:26:54','510',0.00,0.00,'510','2022-08-30 18:17:36','510','2022-08-30 18:17:57',10,0),('1','140',257657,'DAILY SHIFT SALES','2022-08-31','2022-08-31 07:20:19','2022-09-01 07:20:19','510',0.00,0.00,'510','2022-08-31 19:23:19','510','2022-08-31 19:23:40',10,0),('1','140',257658,'OPERATIONAL LOSS','2022-08-31','2022-08-31 19:29:47','2022-09-01 19:29:47','510',0.00,0.00,'510','2022-08-31 19:37:02','510','2022-08-31 19:37:18',10,0),('1','140',257659,'DAILY SHIFT SALES','2022-09-01','2022-09-01 10:08:56','2022-09-02 10:08:56','510',0.00,0.00,'510','2022-09-01 18:03:41','510','2022-09-01 18:04:03',10,0),('1','140',257660,'DAILY SHIFT SALES','2022-09-02','2022-09-02 07:20:17','2022-09-03 07:20:17','510',0.00,0.00,'510','2022-09-02 18:07:36','510','2022-09-02 18:07:56',10,0),('1','140',257661,'DAILY SHIFT SALES','2022-09-03','2022-09-03 07:03:09','2022-09-04 07:03:09','510',0.00,0.00,'510','2022-09-03 18:08:29','510','2022-09-03 18:09:43',10,0),('1','140',257662,'DAILY SHIFT SALES','2022-09-04','2022-09-04 07:10:48','2022-09-05 07:10:48','510',0.00,0.00,'510','2022-09-04 20:39:23','510','2022-09-04 20:40:38',10,0),('1','140',257663,'DAILY SHIFT SALES','2022-09-05','2022-09-05 06:56:58','2022-09-06 06:56:58','510',0.00,0.00,'510','2022-09-05 18:39:57','510','2022-09-05 18:40:17',10,0),('1','140',257664,'DAILY SHIFT SALES','2022-09-06','2022-09-06 07:04:06','2022-09-07 07:04:06','510',0.00,0.00,'510','2022-09-06 18:35:20','510','2022-09-06 18:35:45',10,0),('1','140',257665,'DAILY SHIFT SALES','2022-09-07','2022-09-07 06:56:42','2022-09-08 06:56:42','510',0.00,0.00,'510','2022-09-07 18:40:15','510','2022-09-07 18:40:35',10,0),('1','140',257666,'DAILY SHIFT SALES','2022-09-08','2022-09-08 07:00:51','2022-09-09 07:00:51','510',0.00,0.00,'510','2022-09-08 21:16:20','510','2022-09-08 21:16:41',10,0),('1','140',257667,'DAILY SHIFT SALES','2022-09-09','2022-09-09 06:54:08','2022-09-10 06:54:08','510',0.00,0.00,'510','2022-09-09 18:41:52','510','2022-09-09 18:42:19',10,0),('1','140',257668,'OPERATIONAL LOSS','2022-09-10','2022-09-10 08:44:37','2022-09-11 08:44:37','510',0.00,0.00,'510','2022-09-10 08:52:33','510','2022-09-10 08:52:56',10,0),('1','140',257669,'DAILY SHIFT SALES','2022-09-10','2022-09-10 09:01:59','2022-09-11 09:01:59','510',0.00,0.00,'510','2022-09-10 18:31:08','510','2022-09-10 18:31:28',10,0),('1','140',257670,'DAILY SHIFT SALES','2022-09-11','2022-09-11 07:03:50','2022-09-12 07:03:50','510',0.00,0.00,'510','2022-09-11 20:23:35','510','2022-09-11 20:23:53',10,0),('1','140',257671,'DAILY SHIFT SALES','2022-09-12','2022-09-12 07:10:08','2022-09-13 07:10:08','510',0.00,0.00,'510','2022-09-12 18:39:26','510','2022-09-12 18:39:50',10,0),('1','140',257672,'DAILY SHIFT SALES','2022-09-13','2022-09-13 06:57:53','2022-09-14 06:57:53','510',0.00,0.00,'510','2022-09-13 18:38:23','510','2022-09-13 18:38:48',10,0),('1','140',257673,'DAILY SHIFT SALES','2022-09-14','2022-09-14 07:07:40','2022-09-15 07:07:40','510',0.00,0.00,'510','2022-09-14 18:41:01','510','2022-09-14 18:41:19',10,0),('1','140',257674,'DAILY SHIFT SALES','2022-09-15','2022-09-15 06:57:37','2022-09-16 06:57:37','510',0.00,0.00,'510','2022-09-15 18:38:25','510','2022-09-15 18:38:45',10,0),('1','140',257675,'DAILY SHIFT SALES','2022-09-16','2022-09-16 07:00:28','2022-09-17 07:00:28','510',0.00,0.00,'510','2022-09-16 18:31:55','510','2022-09-16 18:32:16',10,0),('1','140',257676,'DAILY SHIFT SALES','2022-09-17','2022-09-17 06:58:16','2022-09-18 06:58:16','510',0.00,0.00,'510','2022-09-17 20:11:28','510','2022-09-17 20:11:45',10,0),('1','140',257677,'DAILY SHIFT SALES','2022-09-18','2022-09-18 06:53:51','2022-09-19 06:53:51','510',0.00,0.00,'510','2022-09-18 18:03:08','510','2022-09-18 18:03:41',10,0),('1','140',257678,'DAILY SHIFT SALES','2022-09-19','2022-09-19 06:59:35','2022-09-20 06:59:35','510',0.00,0.00,'510','2022-09-19 17:58:01','510','2022-09-19 17:58:19',10,0),('1','140',257679,'OPERATIONAL LOSS','2022-09-20','2022-09-20 10:04:39','2022-09-21 10:04:39','510',0.00,0.00,'510','2022-09-20 10:13:09','510','2022-09-20 10:13:47',10,0),('1','140',257680,'DAILY SHIFT SALES','2022-09-20','2022-09-20 10:23:00','2022-09-21 10:23:00','510',0.00,0.00,'510','2022-09-20 18:46:19','510','2022-09-20 18:46:39',10,0),('1','140',257681,'DAILY SHIFT SALES','2022-09-21','2022-09-21 06:56:32','2022-09-22 06:56:32','510',0.00,0.00,'510','2022-09-21 18:32:08','510','2022-09-21 18:32:26',10,0),('1','140',257682,'DAILY SHIFT SALES','2022-09-22','2022-09-22 06:42:15','2022-09-23 06:42:15','510',0.00,0.00,'510','2022-09-22 18:37:41','510','2022-09-22 18:38:22',10,0),('1','140',257683,'DAILY SHIFT SALES','2022-09-23','2022-09-23 06:36:14','2022-09-24 06:36:14','510',0.00,0.00,'510','2022-09-23 19:03:56','510','2022-09-23 19:04:52',10,0),('1','140',257684,'DAILY SHIFT SALES','2022-09-24','2022-09-24 06:58:20','2022-09-25 06:58:20','510',0.00,0.00,'510','2022-09-24 18:31:16','510','2022-09-24 18:31:49',10,0),('1','140',257685,'DAILY SHIFT SALES','2022-09-25','2022-09-25 07:00:00','2022-09-26 07:00:00','510',0.00,0.00,'510','2022-09-25 18:42:54','510','2022-09-25 18:43:10',10,0),('1','140',257686,'DAILY SHIFT SALES','2022-09-26','2022-09-26 06:54:22','2022-09-27 06:54:22','510',0.00,0.00,'510','2022-09-26 19:38:32','510','2022-09-26 19:38:57',10,0),('1','140',257687,'DAILY SHIFT SALES','2022-09-27','2022-09-27 07:01:06','2022-09-28 07:01:06','510',0.00,0.00,'510','2022-09-27 18:31:51','510','2022-09-27 18:32:11',10,0),('1','140',257688,'DAILY SHIFT SALES','2022-09-28','2022-09-28 07:00:44','2022-09-29 07:00:44','510',0.00,0.00,'510','2022-09-28 18:32:10','510','2022-09-28 18:32:32',10,0),('1','140',257689,'DAILY SHIFT SALES','2022-09-29','2022-09-29 07:03:28','2022-09-30 07:03:28','510',0.00,0.00,'510','2022-09-29 21:49:33','510','2022-09-29 21:50:07',10,0),('1','140',257690,'OPERATIONAL LOSS','2022-09-30','2022-09-30 16:16:47','2022-10-01 16:16:47','510',0.00,0.00,'510','2022-09-30 16:21:34','510','2022-09-30 16:22:06',10,0),('1','140',257691,'DAILY SHIFT SALES','2022-09-30','2022-09-30 16:47:05','2022-10-01 16:47:05','510',0.00,0.00,'510','2022-09-30 18:48:50','510','2022-09-30 18:49:09',10,0),('1','140',257692,'DAILY SHIFT SALES','2022-10-01','2022-10-01 07:01:59','2022-10-02 07:01:59','510',0.00,0.00,'510','2022-10-01 18:45:21','510','2022-10-01 18:45:40',10,0),('1','140',257693,'DAILY SHIFT SALES','2022-10-02','2022-10-02 06:44:04','2022-10-03 06:44:04','510',0.00,0.00,'510','2022-10-02 18:13:07','510','2022-10-02 18:13:26',10,0),('1','140',257694,'DAILY SHIFT SALES','2022-10-03','2022-10-03 06:53:44','2022-10-04 06:53:44','510',0.00,0.00,'510','2022-10-03 20:30:20','510','2022-10-03 20:31:11',10,0),('1','140',257695,'DAILY SHIFT SALES','2022-10-04','2022-10-04 07:01:29','2022-10-05 07:01:29','510',0.00,0.00,'510','2022-10-04 18:43:23','510','2022-10-04 18:44:03',10,0),('1','140',257696,'DAILY SHIFT SALES','2022-10-05','2022-10-05 07:00:11','2022-10-06 07:00:11','510',0.00,0.00,'510','2022-10-05 18:36:47','510','2022-10-05 18:37:07',10,0),('1','140',257697,'DAILY SHIFT SALES','2022-10-06','2022-10-06 06:57:36','2022-10-07 06:57:36','510',0.00,0.00,'510','2022-10-06 12:05:13','510','2022-10-06 12:05:40',10,0),('1','140',257698,'OPERATIONAL LOSS','2022-10-07','2022-10-07 16:11:47','2022-10-08 16:11:47','510',0.00,0.00,'510','2022-10-07 16:27:13','510','2022-10-07 16:27:35',10,0),('1','140',257699,'DAILY SHIFT SALES','2022-10-07','2022-10-07 17:50:32','2022-10-08 17:50:32','510',0.00,0.00,'510','2022-10-07 18:38:13','510','2022-10-07 18:38:35',10,0),('1','140',257700,'DAILY SHIFT SALES','2022-10-08','2022-10-08 07:02:07','2022-10-09 07:02:07','510',0.00,0.00,'510','2022-10-08 18:41:14','510','2022-10-08 18:41:39',10,0),('1','140',257701,'DAILY SHIFT SALES','2022-10-09','2022-10-09 06:57:15','2022-10-10 06:57:15','510',0.00,0.00,'510','2022-10-09 18:17:41','510','2022-10-09 18:18:03',10,0),('1','140',257702,'DAILY SHIFT SALES','2022-10-10','2022-10-10 06:39:14','2022-10-11 06:39:14','510',0.00,0.00,'510','2022-10-10 18:33:25','510','2022-10-10 18:34:17',10,0),('1','140',257703,'DAILY SHIFT SALES','2022-10-11','2022-10-11 07:11:05','2022-10-12 07:11:05','510',0.00,0.00,'510','2022-10-11 18:36:54','510','2022-10-11 18:37:11',10,0),('1','140',257704,'DAILY SHIFT SALES','2022-10-12','2022-10-12 07:08:24','2022-10-13 07:08:24','510',0.00,0.00,'510','2022-10-12 18:44:32','510','2022-10-12 18:44:50',10,0),('1','140',257705,'DAILY SHIFT SALES','2022-10-13','2022-10-13 07:13:43','2022-10-14 07:13:43','510',0.00,0.00,'510','2022-10-13 17:02:27','510','2022-10-13 17:03:00',10,0),('1','140',257706,'OPERATIONAL LOSS','2022-10-14','2022-10-14 09:24:08','2022-10-15 09:24:08','510',0.00,0.00,'510','2022-10-14 09:29:15','510','2022-10-14 09:29:39',10,0),('1','140',257707,'DAILY SHIFT SALES','2022-10-14','2022-10-14 09:39:37','2022-10-15 09:39:37','510',0.00,0.00,'510','2022-10-14 18:42:17','510','2022-10-14 18:42:43',10,0),('1','140',257708,'DAILY SHIFT SALES','2022-10-15','2022-10-15 07:06:12','2022-10-16 07:06:12','510',0.00,0.00,'510','2022-10-15 18:41:54','510','2022-10-15 18:42:18',10,0),('1','140',257709,'DAILY SHIFT SALES','2022-10-16','2022-10-16 07:00:29','2022-10-17 07:00:29','510',0.00,0.00,'510','2022-10-17 00:08:46','510','2022-10-17 00:09:05',10,0),('1','140',257710,'DAILY SHIFT SALES','2022-10-17','2022-10-17 06:48:39','2022-10-18 06:48:39','510',0.00,0.00,'510','2022-10-17 18:42:49','510','2022-10-17 18:43:08',10,0),('1','140',257711,'DAILY SHIFT SALES','2022-10-18','2022-10-18 07:07:23','2022-10-19 07:07:23','510',0.00,0.00,'510','2022-10-18 17:57:51','510','2022-10-18 17:58:46',10,0),('1','140',257712,'OPERATIONAL LOSS','2022-10-19','2022-10-19 08:39:30','2022-10-20 08:39:30','510',0.00,0.00,'510','2022-10-19 09:32:27','510','2022-10-19 09:32:46',10,0),('1','140',257713,'DAILY SHIFT SALES','2022-10-19','2022-10-19 09:37:36','2022-10-20 09:37:36','510',0.00,0.00,'510','2022-10-19 19:16:30','510','2022-10-19 19:16:53',10,0),('1','140',257714,'DAILY SHIFT SALES','2022-10-20','2022-10-20 06:53:07','2022-10-21 06:53:07','510',0.00,0.00,'510','2022-10-20 18:44:20','510','2022-10-20 18:44:49',10,0),('1','140',257715,'DAILY SHIFT SALES','2022-10-21','2022-10-21 06:56:02','2022-10-22 06:56:02','510',0.00,0.00,'510','2022-10-21 20:07:21','510','2022-10-21 20:07:46',10,0),('1','140',257716,'DAILY SHIFT SALES','2022-10-22','2022-10-22 07:05:10','2022-10-23 07:05:10','510',0.00,0.00,'510','2022-10-22 21:11:51','510','2022-10-22 21:12:16',10,0),('1','140',257717,'DAILY SHIFT SALES','2022-10-23','2022-10-23 07:14:57','2022-10-24 07:14:57','510',0.00,0.00,'510','2022-10-23 13:02:39','510','2022-10-23 13:02:55',10,0),('1','140',257718,'OPERATIONAL LOSS','2022-10-23','2022-10-23 13:03:22','2022-10-24 13:03:22','510',0.00,0.00,'510','2022-10-23 13:12:00','510','2022-10-23 13:12:17',10,0),('1','140',257719,'DAILY SHIFT SALES','2022-10-23','2022-10-23 13:15:37','2022-10-24 13:15:37','510',0.00,0.00,'510','2022-10-23 18:28:44','510','2022-10-23 18:29:02',10,0),('1','140',257720,'DAILY SHIFT SALES','2022-10-24','2022-10-24 07:03:18','2022-10-25 07:03:18','510',0.00,0.00,'510','2022-10-25 06:57:30','510','2022-10-25 06:58:04',10,0),('1','140',257721,'DAILY SHIFT SALES','2022-10-25','2022-10-25 06:59:32','2022-10-26 06:59:32','510',0.00,0.00,'510','2022-10-25 17:03:03','510','2022-10-25 17:03:21',10,0),('1','140',257722,'OPERATIONAL LOSSu','2022-10-30','2022-10-30 09:33:27','2022-10-31 09:33:27','510',0.00,0.00,'510','2022-10-30 09:40:14','510','2022-10-30 09:40:33',10,0),('1','140',257723,'DAILY SHIFT SALES','2022-10-30','2022-10-30 09:40:59','2022-10-31 09:40:59','510',0.00,0.00,'510','2022-10-30 18:53:06','510','2022-10-30 18:53:26',10,0),('1','140',257724,'DAILY SHIFT SALES','2022-10-31','2022-10-31 06:54:26','2022-11-01 06:54:26','510',0.00,0.00,'510','2022-10-31 18:55:11','510','2022-10-31 18:55:32',10,0),('1','140',257725,'DAILY SHIFT SALES','2022-11-01','2022-11-01 07:19:22','2022-11-02 07:19:22','510',0.00,0.00,'510','2022-11-01 18:50:22','510','2022-11-01 18:50:42',10,0),('1','140',257726,'DAILY SHIFT SALES','2022-11-02','2022-11-02 07:09:46','2022-11-03 07:09:46','510',0.00,0.00,'510','2022-11-02 19:05:15','510','2022-11-02 19:05:52',10,0),('1','140',257727,'DAILY SHIFT SALES','2022-11-03','2022-11-03 21:50:58','2022-11-04 21:50:58','510',0.00,0.00,'510','2022-11-03 21:52:17','510','2022-11-03 21:52:40',10,0),('1','140',257728,'OPERATIONAL LOSS','2022-11-04','2022-11-04 10:21:15','2022-11-05 10:21:15','510',0.00,0.00,'510','2022-11-04 10:25:10','510','2022-11-04 10:25:23',10,0),('1','140',257729,'DAILY SHIFT SALES','2022-11-04','2022-11-04 10:25:48','2022-11-05 10:25:48','510',0.00,0.00,'510','2022-11-04 18:56:40','510','2022-11-04 18:57:01',10,0),('1','140',257730,'DAILY SHIFT SALES','2022-11-05','2022-11-05 08:21:50','2022-11-06 08:21:50','510',0.00,0.00,'510','2022-11-05 18:54:37','510','2022-11-05 18:56:41',10,0),('1','140',257731,'DAILY SHIFT SALES','2022-11-06','2022-11-06 07:48:48','2022-11-07 07:48:48','510',0.00,0.00,'510','2022-11-06 18:10:00','510','2022-11-06 18:11:21',10,0),('1','140',257732,'DAILY SHIFT SALES','2022-11-07','2022-11-07 07:09:00','2022-11-08 07:09:00','510',0.00,0.00,'510','2022-11-07 18:47:25','510','2022-11-07 18:47:59',10,0),('1','140',257733,'OPERATIONAL LOSS','2022-11-08','2022-11-08 08:55:34','2022-11-09 08:55:34','510',0.00,0.00,'510','2022-11-08 09:02:22','510','2022-11-08 09:02:38',10,0),('1','140',257734,'DAILY SHIFT SALES','2022-11-08','2022-11-08 09:49:41','2022-11-09 09:49:41','510',0.00,0.00,'510','2022-11-08 18:32:38','510','2022-11-08 18:32:58',10,0),('1','140',257735,'DAILY SHIFT SALES','2022-11-09','2022-11-09 07:02:53','2022-11-10 07:02:53','510',0.00,0.00,'510','2022-11-09 18:36:03','510','2022-11-09 18:36:25',10,0),('1','140',257736,'DAILY SHIFT SALES','2022-11-10','2022-11-10 06:58:09','2022-11-11 06:58:09','510',0.00,0.00,'510','2022-11-10 18:31:04','510','2022-11-10 18:31:45',10,0),('1','140',257737,'DAILY SHIFT SALES','2022-11-11','2022-11-11 06:47:15','2022-11-12 06:47:15','510',0.00,0.00,'510','2022-11-11 18:50:17','510','2022-11-11 18:50:40',10,0),('1','140',257738,'DAILY SHIFT SALES','2022-11-12','2022-11-12 07:09:31','2022-11-13 07:09:31','510',0.00,0.00,'510','2022-11-12 11:10:49','510','2022-11-12 11:11:24',10,0),('1','140',257739,'OPERATIONAL LOSS','2022-11-13','2022-11-13 09:05:55','2022-11-14 09:05:55','510',0.00,0.00,'510','2022-11-13 09:10:20','510','2022-11-13 09:10:37',10,0),('1','140',257740,'DAILY SHIFT SALES','2022-11-13','2022-11-13 10:50:43','2022-11-14 10:50:43','510',0.00,0.00,'510','2022-11-13 19:33:01','510','2022-11-13 19:33:22',10,0),('1','140',257741,'DAILY SHIFT SALES','2022-11-14','2022-11-14 07:15:01','2022-11-15 07:15:01','510',0.00,0.00,'510','2022-11-14 18:40:34','510','2022-11-14 18:40:57',10,0),('1','140',257742,'DAILY SHIFT SALES','2022-11-15','2022-11-15 06:57:20','2022-11-16 06:57:20','510',0.00,0.00,'510','2022-11-15 18:53:01','510','2022-11-15 18:53:29',10,0),('1','140',257743,'DAILY SHIFT SALES','2022-11-16','2022-11-16 07:07:22','2022-11-17 07:07:22','510',0.00,0.00,'510','2022-11-16 18:42:04','510','2022-11-16 18:42:27',10,0),('1','140',257744,'DAILY SHIFT SALES','2022-11-17','2022-11-17 07:06:35','2022-11-18 07:06:35','510',0.00,0.00,'510','2022-11-17 18:48:58','510','2022-11-17 18:49:27',10,0),('1','140',257745,'DAILY SHIFT SALES','2022-11-18','2022-11-18 07:10:31','2022-11-19 07:10:31','510',0.00,0.00,'510','2022-11-18 22:03:32','510','2022-11-18 22:03:49',10,0),('1','140',257746,'OPERATIONAL LOSS','2022-11-20','2022-11-20 14:53:58','2022-11-21 14:53:58','510',0.00,0.00,'510','2022-11-20 14:59:36','510','2022-11-20 14:59:56',10,0),('1','140',257747,'DAILY SHIFT SALES','2022-11-20','2022-11-20 15:01:20','2022-11-21 15:01:20','510',0.00,0.00,'510','2022-11-20 18:09:30','510','2022-11-20 18:09:58',10,0),('1','140',257748,'DAILY SHIFT SALES','2022-11-21','2022-11-21 07:13:41','2022-11-22 07:13:41','510',0.00,0.00,'510','2022-11-21 20:21:11','510','2022-11-21 20:21:28',10,0),('1','140',257749,'DAILY SHIFT SALES','2022-11-22','2022-11-22 07:02:57','2022-11-23 07:02:57','510',0.00,0.00,'510','2022-11-22 18:46:18','510','2022-11-22 18:46:39',10,0),('1','140',257750,'DAILY SHIFT SALES','2022-11-23','2022-11-23 06:59:42','2022-11-24 06:59:42','510',0.00,0.00,'510','2022-11-23 18:33:47','510','2022-11-23 18:34:09',10,0),('1','140',257751,'DAILY SHIFT SALES','2022-11-24','2022-11-24 07:02:45','2022-11-25 07:02:45','510',0.00,0.00,'510','2022-11-24 18:43:28','510','2022-11-24 18:43:46',10,0),('1','140',257752,'DAILY SHIFT SALES','2022-11-25','2022-11-25 06:58:35','2022-11-26 06:58:35','510',0.00,0.00,'510','2022-11-25 19:22:29','510','2022-11-25 19:22:58',10,0),('1','140',257753,'DAILY SHIFT SALES','2022-11-26','2022-11-26 06:59:19','2022-11-27 06:59:19','510',0.00,0.00,'510','2022-11-26 18:43:09','510','2022-11-26 18:43:31',10,0),('1','140',257754,'DAILY SHIFT SALES','2022-11-27','2022-11-27 07:02:51','2022-11-28 07:02:51','510',0.00,0.00,'510','2022-11-27 20:12:51','510','2022-11-27 20:13:07',10,0),('1','140',257755,'DAILY SHIFT SALES','2022-11-28','2022-11-28 06:55:06','2022-11-29 06:55:06','510',0.00,0.00,'510','2022-11-28 18:05:24','510','2022-11-28 18:05:42',10,0),('1','140',257756,'OPERATIONAL LOSS','2022-11-29','2022-11-29 06:38:34','2022-11-30 06:38:34','510',0.00,0.00,'510','2022-11-29 06:42:15','510','2022-11-29 06:42:40',10,0),('1','140',257757,'DAILY SHIFT SALES','2022-11-29','2022-11-29 08:10:19','2022-11-30 08:10:19','510',0.00,0.00,'510','2022-11-29 18:41:30','510','2022-11-29 18:42:42',10,0),('1','140',257758,'DAILY SHIFT SALES','2022-11-30','2022-11-30 07:03:23','2022-12-01 07:03:23','510',0.00,0.00,'510','2022-11-30 18:35:23','510','2022-11-30 18:36:28',10,0),('1','140',257759,'DAILY SHIFT SALES','2022-12-01','2022-12-01 06:47:53','2022-12-02 06:47:53','510',0.00,0.00,'510','2022-12-01 18:32:41','510','2022-12-01 18:33:04',10,0),('1','140',257760,'DAILY SHIFT SALES','2022-12-02','2022-12-02 06:53:58','2022-12-03 06:53:58','510',0.00,0.00,'510','2022-12-02 18:40:49','510','2022-12-02 18:41:13',10,0),('1','140',257761,'DAILY SHIFT SALES','2022-12-03','2022-12-03 06:54:11','2022-12-04 06:54:11','510',0.00,0.00,'510','2022-12-03 18:44:25','510','2022-12-03 18:45:00',10,0),('1','140',257762,'DAILY SHIFT SALES','2022-12-04','2022-12-04 06:58:31','2022-12-05 06:58:31','510',0.00,0.00,'510','2022-12-04 18:45:20','510','2022-12-04 18:45:44',10,0),('1','140',257763,'DAILY SHIFT SALES','2022-12-05','2022-12-05 06:57:38','2022-12-06 06:57:38','510',0.00,0.00,'510','2022-12-05 18:45:54','510','2022-12-05 18:46:14',10,0),('1','140',257764,'DAILY SHIFT SALES','2022-12-06','2022-12-06 09:25:07','2022-12-07 09:25:07','510',0.00,0.00,'510','2022-12-06 09:27:58','510','2022-12-06 09:28:19',10,0),('1','140',257765,'OPERATIONAL LOSS','2022-12-06','2022-12-06 09:37:20','2022-12-07 09:37:20','510',0.00,0.00,'510','2022-12-06 09:42:55','510','2022-12-06 09:43:12',10,0),('1','140',257766,'DAILY SHIFT SALES','2022-12-06','2022-12-06 10:47:57','2022-12-07 10:47:57','510',0.00,0.00,'510','2022-12-06 19:09:13','510','2022-12-06 19:09:35',10,0),('1','140',257767,'DAILY SHIFT SALES','2022-12-07','2022-12-07 06:51:54','2022-12-08 06:51:54','510',0.00,0.00,'510','2022-12-07 18:48:22','510','2022-12-07 18:49:17',10,0),('1','140',257768,'DAILY SHIFT SALES','2022-12-08','2022-12-08 06:58:03','2022-12-09 06:58:03','510',0.00,0.00,'510','2022-12-08 19:14:12','510','2022-12-08 19:14:39',10,0),('1','140',257769,'DAILY SHIFT SALES','2022-12-09','2022-12-09 07:03:30','2022-12-10 07:03:30','510',0.00,0.00,'510','2022-12-09 18:48:25','510','2022-12-09 18:48:48',10,0),('1','140',257770,'DAILY SHIFT SALES','2022-12-10','2022-12-10 07:20:24','2022-12-11 07:20:24','510',0.00,0.00,'510','2022-12-10 18:56:40','510','2022-12-10 18:57:05',10,0),('1','140',257771,'DAILY SHIFT SALES','2022-12-11','2022-12-11 06:47:37','2022-12-12 06:47:37','510',0.00,0.00,'510','2022-12-11 15:24:52','510','2022-12-11 15:25:10',10,0),('1','140',257772,'OPERATIONAL LOSS','2022-12-11','2022-12-11 15:44:21','2022-12-12 15:44:21','510',0.00,0.00,'510','2022-12-13 07:12:03','510','2022-12-13 07:12:19',10,0),('1','140',257773,'DAILY SHIFT SALES','2022-12-13','2022-12-13 07:12:43','2022-12-14 07:12:43','510',0.00,0.00,'510','2022-12-13 18:41:20','510','2022-12-13 18:41:45',10,0),('1','140',257774,'DAILY SHIFT SALES','2022-12-14','2022-12-14 06:56:21','2022-12-15 06:56:21','510',0.00,0.00,'510','2022-12-14 18:52:01','510','2022-12-14 18:52:19',10,0),('1','140',257775,'DAILY SHIFT SALES','2022-12-15','2022-12-15 06:55:51','2022-12-16 06:55:51','510',0.00,0.00,'510','2022-12-15 12:48:51','510','2022-12-15 12:49:23',10,0),('1','140',257776,'OPERATIONAL LOSS','2022-12-15','2022-12-15 12:53:16','2022-12-16 12:53:16','510',0.00,0.00,'510','2022-12-15 12:59:34','510','2022-12-15 12:59:52',10,0),('1','140',257777,'DAILY SHIFT SALES','2022-12-15','2022-12-15 14:27:46','2022-12-16 14:27:46','510',0.00,0.00,'510','2022-12-15 19:01:59','510','2022-12-15 19:02:16',10,0),('1','140',257778,'DAILY SHIFT SALES','2022-12-16','2022-12-16 07:02:02','2022-12-17 07:02:02','510',0.00,0.00,'510','2022-12-16 18:41:40','510','2022-12-16 18:42:37',10,0),('1','140',257779,'DAILY SHIFT SALES','2022-12-17','2022-12-17 06:59:07','2022-12-18 06:59:07','510',0.00,0.00,'510','2022-12-17 18:51:09','510','2022-12-17 18:51:31',10,0),('1','140',257780,'OPERATIONAL LOSS','2022-12-17','2022-12-17 19:01:04','2022-12-18 19:01:04','510',0.00,0.00,'510','2022-12-17 19:05:21','510','2022-12-17 19:05:39',10,0),('1','140',257781,'DAILY SHIFT SALES','2022-12-20','2022-12-20 11:04:53','2022-12-21 11:04:53','510',0.00,0.00,'510','2022-12-20 18:50:41','510','2022-12-20 18:51:07',10,0),('1','140',257782,'DAILY SHIFT SALES','2022-12-21','2022-12-21 06:59:39','2022-12-22 06:59:39','510',0.00,0.00,'510','2022-12-21 18:38:14','510','2022-12-21 18:38:39',10,0),('1','140',257783,'DAILY SHIFT SALES','2022-12-22','2022-12-22 06:43:10','2022-12-23 06:43:10','510',0.00,0.00,'510','2022-12-22 18:46:25','510','2022-12-22 18:46:56',10,0),('1','140',257784,'DAILY SHIFT SALES','2022-12-23','2022-12-23 07:27:03','2022-12-24 07:27:03','510',0.00,0.00,'510','2022-12-23 19:10:10','510','2022-12-23 19:10:32',10,0),('1','140',257785,'OPERATIONAL LOSS','2022-12-23','2022-12-23 19:20:18','2022-12-24 19:20:18','510',0.00,0.00,'510','2022-12-23 19:23:44','510','2022-12-23 19:24:06',10,0),('1','140',257786,'DAILY SHIFT SALES','2022-12-24','2022-12-24 07:24:11','2022-12-25 07:24:11','510',0.00,0.00,'510','2022-12-24 18:52:15','510','2022-12-24 18:52:43',10,0),('1','140',257787,'DAILY SHIFT SALES','2022-12-25','2022-12-25 07:00:03','2022-12-26 07:00:03','510',0.00,0.00,'510','2022-12-25 22:56:08','510','2022-12-25 22:56:51',10,0),('1','140',257788,'DAILY SHIFT SALES','2022-12-26','2022-12-26 06:56:25','2022-12-27 06:56:25','510',0.00,0.00,'510','2022-12-26 18:47:18','510','2022-12-26 18:47:44',10,0),('1','140',257789,'DAILY SHIFT SALES','2022-12-27','2022-12-27 06:53:26','2022-12-28 06:53:26','510',0.00,0.00,'510','2022-12-27 19:42:48','510','2022-12-27 19:43:16',10,0),('1','140',257790,'OPERATIONAL LOSS','2022-12-27','2022-12-27 19:51:51','2022-12-28 19:51:51','510',0.00,0.00,'510','2022-12-27 19:55:13','510','2022-12-27 19:55:29',10,0),('1','140',257791,'DAILY SHIFT SALES','2022-12-28','2022-12-28 07:09:28','2022-12-29 07:09:28','510',0.00,0.00,'510','2022-12-28 18:43:34','510','2022-12-28 18:44:01',10,0),('1','140',257792,'DAILY SHIFT SALES','2022-12-29','2022-12-29 07:00:07','2022-12-30 07:00:07','510',0.00,0.00,'510','2022-12-29 18:44:08','510','2022-12-29 18:44:34',10,0),('1','140',257793,'DAILY SHIFT SALES ','2022-12-30','2022-12-30 07:03:24','2022-12-31 07:03:24','510',0.00,0.00,'510','2022-12-30 18:54:23','510','2022-12-30 18:55:02',10,0),('1','140',257794,'DAILY SHIFT SALES ','2022-12-31','2022-12-31 07:05:31','2023-01-01 07:05:31','510',0.00,0.00,'510','2022-12-31 21:28:24','510','2022-12-31 21:37:48',10,0),('1','140',257795,'OPERATIONAL LOSS','2022-12-31','2022-12-31 21:38:49','2023-01-01 21:38:49','510',0.00,0.00,'510','2022-12-31 21:43:28','510','2022-12-31 21:43:46',10,0),('1','140',257796,'DAILY SHIFT SALES ','2023-01-01','2023-01-01 07:26:19','2023-01-02 07:26:19','510',0.00,0.00,'510','2023-01-01 20:38:30','510','2023-01-01 20:38:52',10,0),('1','140',257797,'DAILY SHIFT SALES ','2023-01-02','2023-01-02 07:04:38','2023-01-03 07:04:38','510',0.00,0.00,'510','2023-01-02 19:50:11','510','2023-01-02 19:51:03',10,0),('1','140',257798,'DAILY SHIFT SALES ','2023-01-03','2023-01-03 07:06:37','2023-01-04 07:06:37','510',0.00,0.00,'510','2023-01-03 17:06:27','510','2023-01-03 17:09:03',10,0),('1','140',257799,'OPERATIONAL LOSS','2023-01-03','2023-01-03 17:12:41','2023-01-04 17:12:41','510',0.00,0.00,'510','2023-01-03 17:16:41','510','2023-01-03 17:16:58',10,0),('1','140',257800,'DAILY SHIFT SALES ','2023-01-04','2023-01-04 07:02:15','2023-01-05 07:02:15','510',0.00,0.00,'510','2023-01-04 18:35:20','510','2023-01-04 18:35:59',10,0),('1','140',257801,'DAILY SHIFT SALES ','2023-01-05','2023-01-05 06:56:09','2023-01-06 06:56:09','510',0.00,0.00,'510','2023-01-05 18:46:22','510','2023-01-05 18:46:41',10,0),('1','140',257802,'DAILY SHIFT SALES ','2023-01-06','2023-01-06 07:11:35','2023-01-07 07:11:35','510',0.00,0.00,'510','2023-01-06 19:06:16','510','2023-01-06 19:06:41',10,0),('1','140',257803,'DAILY SHIFT SALES','2023-01-07','2023-01-07 07:11:14','2023-01-08 07:11:14','510',0.00,0.00,'510','2023-01-07 16:07:09','510','2023-01-07 16:07:29',10,0),('1','140',257804,'OPERATIONAL LOSS','2023-01-07','2023-01-07 16:20:41','2023-01-08 16:20:41','510',0.00,0.00,'510','2023-01-07 16:24:41','510','2023-01-07 16:24:59',10,0),('1','140',257805,'DAILY SHIFT SALES ','2023-01-09','2023-01-09 06:52:16','2023-01-10 06:52:16','510',0.00,0.00,'510','2023-01-09 18:45:08','510','2023-01-09 18:45:28',10,0),('1','140',257806,'DAILY SHIFT SALES ','2023-01-10','2023-01-10 07:08:06','2023-01-11 07:08:06','510',0.00,0.00,'510','2023-01-10 18:37:30','510','2023-01-10 18:37:49',10,0),('1','140',257807,'DAILY SHIFT SALES ','2023-01-11','2023-01-11 07:28:20','2023-01-12 07:28:20','510',0.00,0.00,'510','2023-01-11 18:34:50','510','2023-01-11 18:35:10',10,0),('1','140',257808,'DAILY SHIFT SALES','2023-01-12','2023-01-12 07:16:14','2023-01-13 07:16:14','510',0.00,0.00,'510','2023-01-12 18:37:00','510','2023-01-12 18:37:17',10,0),('1','140',257809,'DAILY SHIFT SALES ','2023-01-13','2023-01-13 06:51:09','2023-01-14 06:51:09','510',0.00,0.00,'510','2023-01-13 18:38:38','510','2023-01-13 18:38:57',10,0),('1','140',257810,'DAILY SHIFT SALES ','2023-01-14','2023-01-14 06:54:07','2023-01-15 06:54:07','510',0.00,0.00,'510','2023-01-14 18:27:50','510','2023-01-14 18:28:10',10,0),('1','140',257811,'OPERATIONAL LOSS','2023-01-14','2023-01-14 18:41:42','2023-01-15 18:41:42','510',0.00,0.00,'510','2023-01-14 18:48:38','510','2023-01-14 18:49:00',10,0),('1','140',257812,'DAILY SHIFT SALES ','2023-01-15','2023-01-15 08:17:56','2023-01-16 08:17:56','510',0.00,0.00,'510','2023-01-15 22:19:23','510','2023-01-15 22:19:40',10,0),('1','140',257813,'DAILY SHIFT SALES ','2023-01-16','2023-01-16 06:54:35','2023-01-17 06:54:35','510',0.00,0.00,'510','2023-01-16 18:36:30','510','2023-01-16 18:37:08',10,0),('1','140',257814,'DAILY SHIFT SALES ','2023-01-17','2023-01-17 07:17:39','2023-01-18 07:17:39','510',0.00,0.00,'510','2023-01-17 20:11:31','510','2023-01-17 20:11:56',10,0),('1','140',257815,'DAILY SHIFT SALES ','2023-01-18','2023-01-18 06:57:36','2023-01-19 06:57:36','510',0.00,0.00,'510','2023-01-18 18:42:58','510','2023-01-18 18:43:31',10,0),('1','140',257816,'DAILY SHIFT SALES ','2023-01-19','2023-01-19 07:02:30','2023-01-20 07:02:30','510',0.00,0.00,'510','2023-01-19 18:42:28','510','2023-01-19 18:42:50',10,0),('1','140',257817,'DAILY SHIFT SALES','2023-01-20','2023-01-20 07:13:27','2023-01-21 07:13:27','510',0.00,0.00,'510','2023-01-20 18:35:55','510','2023-01-20 18:36:21',10,0),('1','140',257818,'DAILY SHIFT SALES ','2023-01-21','2023-01-21 06:44:36','2023-01-22 06:44:36','510',0.00,0.00,'510','2023-01-21 10:56:13','510','2023-01-21 10:56:49',10,0),('1','140',257819,'OPERATIONAL LOSS','2023-01-21','2023-01-21 10:57:16','2023-01-22 10:57:16','510',0.00,0.00,'510','2023-01-21 11:01:33','510','2023-01-21 11:01:52',10,0),('1','140',257820,'DAILY SHIFT SALES','2023-01-21','2023-01-21 11:09:41','2023-01-22 11:09:41','510',0.00,0.00,'510','2023-01-21 18:36:41','510','2023-01-21 18:37:41',10,0),('1','140',257821,'DAILY SHIFT SALES','2023-01-22','2023-01-22 07:18:34','2023-01-23 07:18:34','510',0.00,0.00,'510','2023-01-22 19:29:00','510','2023-01-22 19:32:21',10,0),('1','140',257822,'DAILY SHIFT SALES ','2023-01-23','2023-01-23 07:01:00','2023-01-24 07:01:00','510',0.00,0.00,'510','2023-01-23 19:15:49','510','2023-01-23 19:16:10',10,0),('1','140',257823,'DAILY SHIFT SALES ','2023-01-24','2023-01-24 06:46:13','2023-01-25 06:46:13','510',0.00,0.00,'510','2023-01-24 19:00:31','510','2023-01-24 19:02:32',10,0),('1','140',257824,'DAILY SHIFT SALES ','2023-01-25','2023-01-25 06:57:17','2023-01-26 06:57:17','510',0.00,0.00,'510','2023-01-25 18:43:09','510','2023-01-25 18:43:34',10,0),('1','140',257825,'DAILY SHIFT SALES ','2023-01-26','2023-01-26 06:58:31','2023-01-27 06:58:31','510',0.00,0.00,'510','2023-01-26 19:25:40','510','2023-01-26 19:26:02',10,0),('1','140',257826,'OPERATIONAL LOSS','2023-01-26','2023-01-26 19:41:11','2023-01-27 19:41:11','510',0.00,0.00,'510','2023-01-26 19:44:14','510','2023-01-26 19:44:35',10,0),('1','140',257827,'DAILY SHIFT SALES ','2023-01-27','2023-01-27 12:21:52','2023-01-28 12:21:52','510',0.00,0.00,'510','2023-01-27 18:40:15','510','2023-01-27 18:41:15',10,0),('1','140',257828,'DAILY SHIFT SALES ','2023-01-28','2023-01-28 06:58:11','2023-01-29 06:58:11','510',0.00,0.00,'510','2023-01-28 18:55:46','510','2023-01-28 18:56:13',10,0),('1','140',257829,'DAILY SHIFT SALES ','2023-01-29','2023-01-29 07:05:23','2023-01-30 07:05:23','510',0.00,0.00,'510','2023-01-29 18:10:18','510','2023-01-29 18:10:41',10,0),('1','140',257830,'DAILY SHIFT SALES ','2023-01-30','2023-01-30 07:05:20','2023-01-31 07:05:20','510',0.00,0.00,'510','2023-01-30 19:06:40','510','2023-01-30 19:07:07',10,0),('1','140',257831,'DAILY SHIFT SALES ','2023-01-31','2023-01-31 07:10:42','2023-02-01 07:10:42','510',0.00,0.00,'510','2023-01-31 19:01:05','510','2023-01-31 19:02:07',10,0),('1','140',257832,'DAILY SHIFT SALES ','2023-02-01','2023-02-01 07:00:18','2023-02-02 07:00:18','510',0.00,0.00,'510','2023-02-01 10:15:50','510','2023-02-01 10:16:17',10,0),('1','140',257833,'OPERATIONAL LOSS','2023-02-01','2023-02-01 19:14:14','2023-02-02 19:14:14','510',0.00,0.00,'510','2023-02-02 10:03:21','510','2023-02-02 10:03:39',10,0),('1','140',257834,'DAILY SHIFT SALES','2023-02-02','2023-02-02 10:08:06','2023-02-03 10:08:06','510',0.00,0.00,'510','2023-02-02 19:51:36','510','2023-02-02 19:51:58',10,0),('1','140',257835,'DAILY SHIFT SALES ','2023-02-03','2023-02-03 07:03:48','2023-02-04 07:03:48','510',0.00,0.00,'510','2023-02-03 18:49:09','510','2023-02-03 18:49:28',10,0),('1','140',257836,'DAILY SHIFT SALES ','2023-02-04','2023-02-04 06:58:23','2023-02-05 06:58:23','510',0.00,0.00,'510','2023-02-04 18:45:15','510','2023-02-04 18:45:36',10,0),('1','140',257837,'DAILY SHIFT SALES ','2023-02-05','2023-02-05 07:00:40','2023-02-06 07:00:40','510',0.00,0.00,'510','2023-02-05 20:52:25','510','2023-02-05 20:53:18',10,0),('1','140',257838,'DAILY SHIFT SALES ','2023-02-06','2023-02-06 07:07:58','2023-02-07 07:07:58','510',0.00,0.00,'510','2023-02-06 18:38:14','510','2023-02-06 18:38:35',10,0),('1','140',257839,'DAILY SHIFT SALES ','2023-02-07','2023-02-07 06:57:37','2023-02-08 06:57:37','510',0.00,0.00,'510','2023-02-07 18:47:13','510','2023-02-07 18:47:34',10,0),('1','140',257840,'DAILY SHIFT SALES ','2023-02-08','2023-02-08 07:07:43','2023-02-09 07:07:43','510',0.00,0.00,'510','2023-02-08 18:11:16','510','2023-02-08 18:11:39',10,0),('1','140',257841,'OPERATIONAL LOSS','2023-02-08','2023-02-08 22:05:31','2023-02-09 22:05:31','510',0.00,0.00,'510','2023-02-08 22:11:23','510','2023-02-08 22:11:42',10,0),('1','140',257842,'DAILY SHIFT SALES ','2023-02-09','2023-02-09 06:54:12','2023-02-10 06:54:12','510',0.00,0.00,'510','2023-02-09 18:39:01','510','2023-02-09 18:39:26',10,0),('1','140',257843,'DAILY SHIFT SALES ','2023-02-10','2023-02-10 07:01:51','2023-02-11 07:01:51','510',0.00,0.00,'510','2023-02-10 19:02:58','510','2023-02-10 19:03:27',10,0),('1','140',257844,'DAILY SHIFT SALES','2023-02-11','2023-02-11 07:12:43','2023-02-12 07:12:43','510',0.00,0.00,'510','2023-02-11 21:06:31','510','2023-02-11 21:06:58',10,0),('1','140',257845,'DAILY SHIFT SALES ','2023-02-12','2023-02-12 07:02:36','2023-02-13 07:02:36','510',0.00,0.00,'510','2023-02-12 18:30:55','510','2023-02-12 18:31:16',10,0),('1','140',257846,'DAILY SHIFT SALES','2023-02-13','2023-02-13 07:14:29','2023-02-14 07:14:29','510',0.00,0.00,'510','2023-02-13 18:53:55','510','2023-02-13 18:54:23',10,0),('1','140',257847,'DAILY SHIFT SALES ','2023-02-14','2023-02-14 06:59:54','2023-02-15 06:59:54','510',0.00,0.00,'510','2023-02-14 13:07:35','510','2023-02-14 13:08:02',10,0),('1','140',257848,'OPERATIONAL LOSS','2023-02-14','2023-02-14 14:52:42','2023-02-15 14:52:42','510',0.00,0.00,'510','2023-02-14 14:56:54','510','2023-02-14 14:57:15',10,0),('1','140',257849,'DAILY SHIFT SALES ','2023-02-16','2023-02-16 09:51:58','2023-02-17 09:51:58','510',0.00,0.00,'510','2023-02-16 18:43:10','510','2023-02-16 18:43:41',10,0),('1','140',257850,'DAILY SHIFT SALES ','2023-02-17','2023-02-17 06:50:00','2023-02-18 06:50:00','510',0.00,0.00,'510','2023-02-17 18:36:11','510','2023-02-17 18:36:44',10,0),('1','140',257851,'DAILY SHIFT SALES','2023-02-18','2023-02-18 07:24:16','2023-02-19 07:24:16','510',0.00,0.00,'510','2023-02-18 18:37:29','510','2023-02-18 18:37:51',10,0),('1','140',257852,'DAILY SHIFT SALES','2023-02-19','2023-02-19 07:49:48','2023-02-20 07:49:48','510',0.00,0.00,'510','2023-02-19 18:47:12','510','2023-02-19 18:47:26',10,0),('1','140',257853,'DAILY SHIFT SALES','2023-02-20','2023-02-20 07:42:15','2023-02-21 07:42:15','510',0.00,0.00,'510','2023-02-20 18:48:18','510','2023-02-20 18:48:38',10,0),('1','140',257854,'DAILY SHIFT SALES ','2023-02-21','2023-02-21 07:02:20','2023-02-22 07:02:20','510',0.00,0.00,'510','2023-02-21 18:10:40','510','2023-02-21 18:11:44',10,0),('1','140',257855,'OPERATIONAL LOSS','2023-02-21','2023-02-21 18:43:52','2023-02-22 18:43:52','510',0.00,0.00,'510','2023-02-21 18:47:16','510','2023-02-21 18:47:36',10,0),('1','140',257856,'DAILY SHIFT SALES','2023-02-22','2023-02-22 10:34:44','2023-02-23 10:34:44','510',0.00,0.00,'510','2023-02-22 19:18:57','510','2023-02-22 19:19:18',10,0),('1','140',257857,'DAILY SHIFT SALES','2023-02-23','2023-02-23 07:29:26','2023-02-24 07:29:26','510',0.00,0.00,'510','2023-02-23 19:07:56','510','2023-02-23 19:09:19',10,0),('1','140',257858,'DAILY SHIFT SALES ','2023-02-24','2023-02-24 07:33:46','2023-02-25 07:33:46','510',0.00,0.00,'510','2023-02-24 17:38:37','510','2023-02-24 17:39:06',10,0),('1','140',257859,'DAILY SHIFT SALES ','2023-02-27','2023-02-27 08:45:56','2023-02-28 08:45:56','510',0.00,0.00,'510','2023-02-27 18:57:13','510','2023-02-27 18:57:35',10,0),('1','140',257860,'DAILY SHIFT SALES','2023-02-28','2023-02-28 07:34:35','2023-03-01 07:34:35','510',0.00,0.00,'510','2023-02-28 19:46:35','510','2023-02-28 19:46:57',10,0),('1','140',257861,'DAILY SHIFT SALES','2023-03-01','2023-03-01 07:39:56','2023-03-02 07:39:56','510',0.00,0.00,'510','2023-03-01 18:53:04','510','2023-03-01 18:53:22',10,0),('1','140',257862,'OPERATIONAL LOSS','2023-03-02','2023-03-02 09:34:18','2023-03-03 09:34:18','510',0.00,0.00,'510','2023-03-02 09:39:51','510','2023-03-02 09:40:12',10,0),('1','140',257863,'DAILY SHIFT SALES ','2023-03-02','2023-03-02 11:22:47','2023-03-03 11:22:47','510',0.00,0.00,'510','2023-03-02 20:55:34','510','2023-03-02 20:56:02',10,0),('1','140',257864,'DAILY SHIFT SALES ','2023-03-03','2023-03-03 07:18:51','2023-03-04 07:18:51','510',0.00,0.00,'510','2023-03-03 18:43:14','510','2023-03-03 18:44:12',10,0),('1','140',257865,'DAILY SHIFT SALES ','2023-03-04','2023-03-04 07:07:40','2023-03-05 07:07:40','510',0.00,0.00,'510','2023-03-04 19:26:10','510','2023-03-04 19:26:32',10,0),('1','140',257866,'DAILY SHIFT SALES ','2023-03-05','2023-03-05 07:03:54','2023-03-06 07:03:54','510',0.00,0.00,'510','2023-03-05 18:13:30','510','2023-03-05 18:14:01',10,0),('1','140',257867,'DAILY SHIFT SALES','2023-03-06','2023-03-06 07:42:31','2023-03-07 07:42:31','510',0.00,0.00,'510','2023-03-06 19:21:18','510','2023-03-06 19:21:39',10,0),('1','140',257868,'DAILY SHIFT SALES','2023-03-07','2023-03-07 07:31:38','2023-03-08 07:31:38','510',0.00,0.00,'510','2023-03-07 18:55:08','510','2023-03-07 18:55:31',10,0),('1','140',257869,'DAILY SHIFT SALES','2023-03-08','2023-03-08 07:35:37','2023-03-09 07:35:37','510',0.00,0.00,'510','2023-03-08 18:51:03','510','2023-03-08 18:51:30',10,0),('1','140',257870,'DAILY SHIFT SALES ','2023-03-09','2023-03-09 07:02:00','2023-03-10 07:02:00','510',0.00,0.00,'510','2023-03-09 18:44:33','510','2023-03-09 18:45:03',10,0),('1','140',257871,'DAILY SHIFT SALES ','2023-03-10','2023-03-10 07:34:55','2023-03-11 07:34:55','510',0.00,0.00,'510','2023-03-10 18:46:35','510','2023-03-10 18:47:04',10,0),('1','140',257872,'DAILY SHIFT SALES ','2023-03-11','2023-03-11 07:02:57','2023-03-12 07:02:57','510',0.00,0.00,'510','2023-03-11 18:20:39','510','2023-03-11 18:21:22',10,0),('1','140',257873,'OPERATIONAL LOSS','2023-03-12','2023-03-12 09:07:08','2023-03-13 09:07:08','510',0.00,0.00,'510','2023-03-12 09:19:22','510','2023-03-12 09:20:07',10,0),('1','140',257874,'DAILY SHIFT SALES it','2023-03-12','2023-03-12 09:21:27','2023-03-13 09:21:27','510',0.00,0.00,'510','2023-03-12 18:36:39','510','2023-03-12 18:56:42',10,0),('1','140',257875,'DAILY SHIFT SALES ','2023-03-13','2023-03-13 07:02:54','2023-03-14 07:02:54','510',0.00,0.00,'510','2023-03-13 19:43:48','510','2023-03-14 07:37:40',10,0),('1','140',257876,'DAILY SHIFT SALES ','2023-03-14','2023-03-14 07:38:09','2023-03-15 07:38:09','510',0.00,0.00,'510','2023-03-14 18:45:39','510','2023-03-14 18:46:10',10,0),('1','140',257877,'DAILY SHIFT SALES ','2023-03-15','2023-03-15 07:00:04','2023-03-16 07:00:04','510',0.00,0.00,'510','2023-03-15 18:49:13','510','2023-03-15 19:02:47',10,0),('1','140',257878,'DAILY SHIFT SALES ','2023-03-16','2023-03-16 06:54:18','2023-03-17 06:54:18','510',0.00,0.00,'510','2023-03-16 18:54:18','510','2023-03-16 18:55:02',10,0),('1','140',257879,'DAILY SHIFT SALES ','2023-03-17','2023-03-17 06:45:07','2023-03-18 06:45:07','510',0.00,0.00,'510','2023-03-17 17:06:23','510','2023-03-17 17:06:46',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4904882 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','140','773','150308',2997123,'2144','331',0.00,7652.50,0.00,0.00,7652.50,1540466.00,0.00,0.00,0.00),('1','140','773','150308',2997124,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','150313',2997216,'2144','331',7652.50,20633.00,0.00,0.00,12980.50,2611864.00,0.00,0.00,0.00),('1','140','773','150313',2997217,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','150317',2997251,'2144','331',20633.00,22801.00,0.00,0.00,2168.00,436244.00,0.00,0.00,0.00),('1','140','773','150317',2997252,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','150319',2997272,'2144','331',22801.00,22801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','150319',2997273,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','150322',2997313,'2144','331',22801.00,40505.00,0.00,0.00,17704.00,3555432.00,0.00,0.00,0.00),('1','140','773','150322',2997314,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','150326',2997381,'2144','331',40505.00,45519.00,0.00,0.00,5014.00,1006152.00,0.00,0.00,0.00),('1','140','773','150326',2997382,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','150605',3002961,'2144','331',45519.00,58331.20,0.00,0.00,12812.20,2572914.00,0.00,0.00,0.00),('1','140','773','150605',3002962,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','150610',3003068,'2144','331',58331.20,68229.10,0.00,0.00,9897.90,1988902.00,0.00,0.00,0.00),('1','140','773','150610',3003069,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','150614',3003136,'2144','331',68229.10,90935.20,0.00,0.00,22706.10,4565966.00,0.00,0.00,0.00),('1','140','773','150614',3003137,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','150616',3003156,'2144','331',90935.20,96454.20,0.00,0.00,5519.00,1110372.00,0.00,0.00,0.00),('1','140','773','150616',3003157,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','150617',3003158,'2144','331',96454.20,113629.50,0.00,0.00,17175.30,3449630.00,0.00,0.00,0.00),('1','140','773','150617',3003159,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','150717',3005254,'2144','331',113629.50,136565.60,0.00,0.00,22936.10,4611046.00,0.00,0.00,0.00),('1','140','773','150717',3005255,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','152271',3034232,'2144','331',136565.60,154475.70,0.00,0.00,17910.10,3598716.00,0.00,0.00,0.00),('1','140','773','152271',3034233,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','152272',3034234,'2144','331',154475.70,159161.60,0.00,0.00,4685.90,942438.00,0.00,0.00,0.00),('1','140','773','152272',3034235,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','152280',3034446,'2144','331',159161.60,181852.20,0.00,0.00,22690.60,4562484.00,0.00,0.00,0.00),('1','140','773','152280',3034447,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','152287',3034620,'2144','331',181852.20,204526.80,0.00,0.00,22674.60,4559446.00,0.00,0.00,0.00),('1','140','773','152287',3034621,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','152298',3034778,'2144','331',204526.80,213818.90,0.00,0.00,9292.10,1868456.00,0.00,0.00,0.00),('1','140','773','152298',3034779,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','152582',3039802,'2144','331',213818.90,219566.90,0.00,0.00,5748.00,1158464.00,0.00,0.00,0.00),('1','140','773','152582',3039803,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','152584',3039821,'2144','331',219566.90,227374.80,0.00,0.00,7807.90,1570824.00,0.00,0.00,0.00),('1','140','773','152584',3039822,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','152586',3039839,'2144','331',227374.80,250285.00,0.00,0.00,22910.20,4605496.00,0.00,0.00,0.00),('1','140','773','152586',3039840,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','154102',3066764,'2144','331',250285.00,261753.30,0.00,0.00,11468.30,2258082.00,0.00,0.00,0.00),('1','140','773','154102',3066765,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','154110',3066882,'2144','331',261753.30,273838.30,0.00,0.00,12085.00,2381876.00,0.00,0.00,0.00),('1','140','773','154110',3066883,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','154116',3066977,'2144','331',273838.30,287132.50,0.00,0.00,13294.20,2621844.00,0.00,0.00,0.00),('1','140','773','154116',3066978,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','154336',3071222,'2144','331',287132.50,295884.30,0.00,0.00,8751.80,1729062.00,0.00,0.00,0.00),('1','140','773','154336',3071223,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','154339',3071258,'2144','331',295884.30,306990.90,0.00,0.00,11106.60,2189516.00,0.00,0.00,0.00),('1','140','773','154339',3071259,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','154344',3071367,'2144','331',306990.90,318581.00,0.00,0.00,11590.10,2283414.00,0.00,0.00,0.00),('1','140','773','154344',3071368,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','154351',3071500,'2144','331',318581.00,337883.80,0.00,0.00,19302.80,3800497.60,0.00,0.00,0.00),('1','140','773','154351',3071501,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','154357',3071580,'2144','331',337883.80,341282.20,0.00,0.00,3398.40,675132.00,0.00,0.00,0.00),('1','140','773','154357',3071581,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','154363',3071692,'2144','331',341282.20,341282.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','154363',3071693,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','154365',3071716,'2144','331',341282.20,360774.10,0.00,0.00,19491.90,3836792.00,0.00,0.00,0.00),('1','140','773','154365',3071717,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','154367',3071741,'2144','331',360774.10,360774.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','154367',3071742,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','154368',3071743,'2144','331',360774.10,363988.60,0.00,0.00,3214.50,636720.00,0.00,0.00,0.00),('1','140','773','154368',3071744,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','155714',3096848,'2144','331',363988.60,373042.80,0.00,0.00,9054.20,1771693.00,0.00,0.00,0.00),('1','140','773','155714',3096849,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','156182',3105339,'2144','331',373042.80,373042.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','156182',3105340,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157075',3121693,'2144','331',373042.80,378380.80,0.00,0.00,5338.00,1013898.00,0.00,0.00,0.00),('1','140','773','157075',3121694,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157076',3121695,'2144','331',378380.80,386843.80,0.00,0.00,8463.00,1654812.00,0.00,0.00,0.00),('1','140','773','157076',3121696,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157077',3121697,'2144','331',386843.80,386843.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157077',3121698,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157078',3121699,'2144','331',386843.80,386843.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157078',3121700,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157080',3121703,'2144','331',386843.80,386843.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157080',3121704,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157085',3121767,'2144','331',386843.80,409534.86,0.00,0.00,22691.06,4433525.80,0.00,0.00,0.00),('1','140','773','157085',3121768,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157164',3123186,'2144','331',409534.86,423957.66,0.00,0.00,14422.80,2817996.00,0.00,0.00,0.00),('1','140','773','157164',3123187,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157165',3123188,'2144','331',423957.66,432250.16,0.00,0.00,8292.50,1619680.00,0.00,0.00,0.00),('1','140','773','157165',3123189,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157169',3123249,'2144','331',432250.16,451954.86,0.00,0.00,19704.70,3851612.00,0.00,0.00,0.00),('1','140','773','157169',3123250,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157174',3123356,'2144','331',451954.86,462426.06,0.00,0.00,10471.20,2047860.00,0.00,0.00,0.00),('1','140','773','157174',3123357,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157175',3123358,'2144','331',462426.06,471654.16,0.00,0.00,9228.10,1808066.00,0.00,0.00,0.00),('1','140','773','157175',3123359,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157224',3124250,'2144','331',471654.16,488516.50,0.00,0.00,16862.34,3291698.40,0.00,0.00,0.00),('1','140','773','157224',3124251,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157277',3125261,'2144','331',488516.50,495176.50,0.00,0.00,6660.00,1304076.00,0.00,0.00,0.00),('1','140','773','157277',3125262,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157297',3125534,'2144','331',495176.50,503944.50,0.00,0.00,8768.00,1714024.00,0.00,0.00,0.00),('1','140','773','157297',3125535,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157298',3125536,'2144','331',503944.50,503944.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157298',3125537,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157300',3125554,'2144','331',503944.50,519758.50,0.00,0.00,15814.00,3090560.00,0.00,0.00,0.00),('1','140','773','157300',3125555,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157303',3125584,'2144','331',519758.50,542439.30,0.00,0.00,22680.80,4427348.20,0.00,0.00,0.00),('1','140','773','157303',3125585,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157311',3125700,'2144','331',542439.30,548651.30,0.00,0.00,6212.00,1217584.00,0.00,0.00,0.00),('1','140','773','157311',3125701,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157313',3125703,'2144','331',548651.30,560122.40,0.00,0.00,11471.10,2242962.00,0.00,0.00,0.00),('1','140','773','157313',3125704,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157314',3125705,'2144','331',560122.40,565115.30,0.00,0.00,4992.90,975198.00,0.00,0.00,0.00),('1','140','773','157314',3125706,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157319',3125783,'2144','331',565115.30,584096.30,0.00,0.00,18981.00,3704730.00,0.00,0.00,0.00),('1','140','773','157319',3125784,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157324',3125849,'2144','331',584096.30,587763.30,0.00,0.00,3667.00,718358.00,0.00,0.00,0.00),('1','140','773','157324',3125850,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157336',3126066,'2144','331',587763.30,599684.30,0.00,0.00,11921.00,2323294.00,0.00,0.00,0.00),('1','140','773','157336',3126067,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157346',3126221,'2144','331',599684.30,610407.30,0.00,0.00,10723.00,2093276.00,0.00,0.00,0.00),('1','140','773','157346',3126222,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157353',3126364,'2144','331',610407.30,634011.60,0.00,0.00,23604.30,4610556.00,0.00,0.00,0.00),('1','140','773','157353',3126365,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157358',3126441,'2144','331',634011.60,641726.60,0.00,0.00,7715.00,1553220.00,0.00,0.00,0.00),('1','140','773','157358',3126442,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157363',3126496,'2144','331',641726.60,647593.60,0.00,0.00,5867.00,1183456.00,0.00,0.00,0.00),('1','140','773','157363',3126497,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157366',3126530,'2144','331',647593.60,657603.60,0.00,0.00,10010.00,2014156.00,0.00,0.00,0.00),('1','140','773','157366',3126531,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157455',3128104,'2144','331',657603.60,679275.10,0.00,0.00,21671.50,4349290.00,0.00,0.00,0.00),('1','140','773','157455',3128105,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157458',3128135,'2144','331',679275.10,681191.30,0.00,0.00,1916.20,387900.00,0.00,0.00,0.00),('1','140','773','157458',3128136,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157462',3128182,'2144','331',681191.30,681191.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157462',3128183,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157466',3128227,'2144','331',681191.30,696177.30,0.00,0.00,14986.00,3010052.00,0.00,0.00,0.00),('1','140','773','157466',3128228,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157467',3128229,'2144','331',696177.30,704837.30,0.00,0.00,8660.00,1744154.00,0.00,0.00,0.00),('1','140','773','157467',3128230,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157470',3128262,'2144','331',704837.30,723148.90,0.00,0.00,18311.60,3678330.00,0.00,0.00,0.00),('1','140','773','157470',3128263,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157471',3128264,'2144','331',723148.90,729345.90,0.00,0.00,6197.00,1248508.00,0.00,0.00,0.00),('1','140','773','157471',3128265,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','157473',3128282,'2144','331',729345.90,737952.90,0.00,0.00,8607.00,1815016.00,0.00,0.00,0.00),('1','140','773','157473',3128283,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161271',3196614,'2144','331',737952.90,745806.90,0.00,0.00,7854.00,1656128.00,0.00,0.00,0.00),('1','140','773','161271',3196615,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161273',3196630,'2144','331',745806.90,764717.90,0.00,0.00,18911.00,3983262.00,0.00,0.00,0.00),('1','140','773','161273',3196631,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161275',3196662,'2144','331',764717.90,768515.90,0.00,0.00,3798.00,799996.00,0.00,0.00,0.00),('1','140','773','161275',3196663,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161276',3196664,'2144','331',768515.90,783147.90,0.00,0.00,14632.00,3082004.00,0.00,0.00,0.00),('1','140','773','161276',3196665,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161277',3196666,'2144','331',783147.90,791209.90,0.00,0.00,8062.00,1699542.00,0.00,0.00,0.00),('1','140','773','161277',3196667,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161279',3196679,'2144','331',791209.90,803841.90,0.00,0.00,12632.00,2663368.00,0.00,0.00,0.00),('1','140','773','161279',3196680,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161280',3196681,'2144','331',803841.90,813928.90,0.00,0.00,10087.00,2127472.00,0.00,0.00,0.00),('1','140','773','161280',3196682,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161281',3196683,'2144','331',813928.90,826740.90,0.00,0.00,12812.00,2701148.00,0.00,0.00,0.00),('1','140','773','161281',3196684,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161282',3196685,'2144','331',826740.90,833684.90,0.00,0.00,6944.00,1465798.00,0.00,0.00,0.00),('1','140','773','161282',3196686,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161284',3196689,'2144','331',833684.90,843563.90,0.00,0.00,9879.00,2085764.00,0.00,0.00,0.00),('1','140','773','161284',3196690,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161288',3196728,'2144','331',843563.90,864009.90,0.00,0.00,20446.00,4301210.00,0.00,0.00,0.00),('1','140','773','161288',3196729,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161289',3196730,'2144','331',864009.90,866314.90,0.00,0.00,2305.00,487232.00,0.00,0.00,0.00),('1','140','773','161289',3196731,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161293',3196754,'2144','331',866314.90,874560.90,0.00,0.00,8246.00,1739698.00,0.00,0.00,0.00),('1','140','773','161293',3196755,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161295',3196758,'2144','331',874560.90,888933.90,0.00,0.00,14373.00,3029502.00,0.00,0.00,0.00),('1','140','773','161295',3196759,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161296',3196760,'2144','331',888933.90,895483.90,0.00,0.00,6550.00,1379854.00,0.00,0.00,0.00),('1','140','773','161296',3196761,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161298',3196778,'2144','331',895483.90,911672.90,0.00,0.00,16189.00,3413162.00,0.00,0.00,0.00),('1','140','773','161298',3196779,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161301',3196823,'2144','331',911672.90,917300.90,0.00,0.00,5628.00,1155534.00,0.00,0.00,0.00),('1','140','773','161301',3196824,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161302',3196825,'2144','331',917300.90,930909.90,0.00,0.00,13609.00,2868048.00,0.00,0.00,0.00),('1','140','773','161302',3196826,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161305',3196847,'2144','331',930909.90,932603.90,0.00,0.00,1694.00,357598.00,0.00,0.00,0.00),('1','140','773','161305',3196848,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161351',3197656,'2144','331',932603.90,941332.90,0.00,0.00,8729.00,1841344.00,0.00,0.00,0.00),('1','140','773','161351',3197657,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161352',3197658,'2144','331',941332.90,955060.70,0.00,0.00,13727.80,2811035.20,0.00,0.00,0.00),('1','140','773','161352',3197659,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161466',3199558,'2144','331',955060.70,967773.70,0.00,0.00,12713.00,2607288.00,0.00,0.00,0.00),('1','140','773','161466',3199559,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161469',3199604,'2144','331',967773.70,977761.70,0.00,0.00,9988.00,2049336.00,0.00,0.00,0.00),('1','140','773','161469',3199605,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161470',3199606,'2144','331',977761.70,977761.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161470',3199607,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161472',3199621,'2144','331',977761.70,1000331.50,0.00,0.00,22569.80,4627228.00,0.00,0.00,0.00),('1','140','773','161472',3199622,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161477',3199668,'2144','331',1000331.50,1005467.50,0.00,0.00,5136.00,1057532.00,0.00,0.00,0.00),('1','140','773','161477',3199669,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161480',3199714,'2144','331',1005467.50,1023040.50,0.00,0.00,17573.00,3604084.00,0.00,0.00,0.00),('1','140','773','161480',3199715,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161482',3199747,'2144','331',1023040.50,1033993.50,0.00,0.00,10953.00,2250164.00,0.00,0.00,0.00),('1','140','773','161482',3199748,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161484',3199751,'2144','331',1033993.50,1040635.50,0.00,0.00,6642.00,1363268.00,0.00,0.00,0.00),('1','140','773','161484',3199752,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161485',3199753,'2144','331',1040635.50,1041763.00,0.00,0.00,1127.50,231566.00,0.00,0.00,0.00),('1','140','773','161485',3199754,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161672',3203150,'2144','331',1041763.00,1045654.50,0.00,0.00,3891.50,798954.00,0.00,0.00,0.00),('1','140','773','161672',3203151,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161674',3203163,'2144','331',1045654.50,1068267.50,0.00,0.00,22613.00,4904026.00,0.00,0.00,0.00),('1','140','773','161674',3203164,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161675',3203165,'2144','331',1068267.50,1084547.50,0.00,0.00,16280.00,3531716.00,0.00,0.00,0.00),('1','140','773','161675',3203166,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161676',3203167,'2144','331',1084547.50,1091149.50,0.00,0.00,6602.00,1435140.00,0.00,0.00,0.00),('1','140','773','161676',3203168,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161677',3203169,'2144','331',1091149.50,1113811.50,0.00,0.00,22662.00,4917952.00,0.00,0.00,0.00),('1','140','773','161677',3203170,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161678',3203171,'2144','331',1113811.50,1136615.50,0.00,0.00,22804.00,4949116.00,0.00,0.00,0.00),('1','140','773','161678',3203172,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161679',3203173,'2144','331',1136615.50,1159473.50,0.00,0.00,22858.00,4960140.00,0.00,0.00,0.00),('1','140','773','161679',3203174,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161680',3203175,'2144','331',1159473.50,1170413.50,0.00,0.00,10940.00,2376352.00,0.00,0.00,0.00),('1','140','773','161680',3203176,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161681',3203177,'2144','331',1170413.50,1182329.60,0.00,0.00,11916.10,2586222.00,0.00,0.00,0.00),('1','140','773','161681',3203178,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161682',3203179,'2144','331',1182329.60,1194773.60,0.00,0.00,12444.00,2703436.00,0.00,0.00,0.00),('1','140','773','161682',3203180,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161683',3203181,'2144','331',1194773.60,1199617.60,0.00,0.00,4844.00,1052600.00,0.00,0.00,0.00),('1','140','773','161683',3203182,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161684',3203183,'2144','331',1199617.60,1211263.60,0.00,0.00,11646.00,2528184.00,0.00,0.00,0.00),('1','140','773','161684',3203184,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161685',3203185,'2144','331',1211263.60,1222238.60,0.00,0.00,10975.00,2377660.00,0.00,0.00,0.00),('1','140','773','161685',3203186,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161686',3203187,'2144','331',1222238.60,1232871.60,0.00,0.00,10633.00,2308736.00,0.00,0.00,0.00),('1','140','773','161686',3203188,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','161689',3203208,'2144','331',1232871.60,1244927.60,0.00,0.00,12056.00,2618424.00,0.00,0.00,0.00),('1','140','773','161689',3203209,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','162215',3212772,'2144','331',1244927.60,1250125.60,0.00,0.00,5198.00,1177834.00,0.00,0.00,0.00),('1','140','773','162215',3212773,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','162217',3212785,'2144','331',1250125.60,1260450.60,0.00,0.00,10325.00,2346386.00,0.00,0.00,0.00),('1','140','773','162217',3212786,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','162218',3212787,'2144','331',1260450.60,1267736.60,0.00,0.00,7286.00,1599412.00,0.00,0.00,0.00),('1','140','773','162218',3212788,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','162222',3212842,'2144','331',1267736.60,1290455.60,0.00,0.00,22719.00,5116848.00,0.00,0.00,0.00),('1','140','773','162222',3212843,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','162231',3212962,'2144','331',1290455.60,1300550.60,0.00,0.00,10095.00,2298820.00,0.00,0.00,0.00),('1','140','773','162231',3212963,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','162311',3214152,'2144','331',1300550.60,1309189.60,0.00,0.00,8639.00,1966912.00,0.00,0.00,0.00),('1','140','773','162311',3214153,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','162317',3214288,'2144','331',1309189.60,1313167.60,0.00,0.00,3978.00,907522.00,0.00,0.00,0.00),('1','140','773','162317',3214289,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','162548',3218083,'2144','331',1313167.60,1313167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','162548',3218084,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','162556',3218195,'2144','331',1313167.60,1319086.60,0.00,0.00,5919.00,1353206.00,0.00,0.00,0.00),('1','140','773','162556',3218196,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','162559',3218229,'2144','331',1319086.60,1319086.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','162559',3218230,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','162563',3218261,'2144','331',1319086.60,1319086.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','162563',3218262,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','162565',3218303,'2144','331',1319086.60,1323584.60,0.00,0.00,4498.00,1031630.00,0.00,0.00,0.00),('1','140','773','162565',3218304,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','162569',3218378,'2144','331',1323584.60,1335875.60,0.00,0.00,12291.00,2799980.00,0.00,0.00,0.00),('1','140','773','162569',3218379,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','162572',3218410,'2144','331',1335875.60,1344624.20,0.00,0.00,8748.60,1996084.00,0.00,0.00,0.00),('1','140','773','162572',3218411,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','162700',3220672,'2144','331',1344624.20,1358587.60,0.00,0.00,13963.40,3183422.00,0.00,0.00,0.00),('1','140','773','162700',3220673,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','162779',3222303,'2144','331',1358587.60,1381299.80,0.00,0.00,22712.20,4437668.00,0.00,0.00,0.00),('1','140','773','162779',3222304,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','163058',3226991,'2144','331',1381299.80,1388348.20,0.00,0.00,7048.40,1610733.60,0.00,0.00,0.00),('1','140','773','163058',3226992,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','163060',3227011,'2144','331',1388348.20,1400237.20,0.00,0.00,11889.00,2709724.00,0.00,0.00,0.00),('1','140','773','163060',3227012,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','163119',3228166,'2144','331',1400237.20,1403966.00,0.00,0.00,3728.80,848544.00,0.00,0.00,0.00),('1','140','773','163119',3228167,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','163705',3238861,'2144','331',1403966.00,1409178.00,0.00,0.00,5212.00,1191996.00,0.00,0.00,0.00),('1','140','773','163705',3238862,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','163709',3238940,'2144','331',1409178.00,1421735.00,0.00,0.00,12557.00,2862802.00,0.00,0.00,0.00),('1','140','773','163709',3238941,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','163783',3240125,'2144','331',1421735.00,1421820.00,0.00,0.00,85.00,25840.00,0.00,0.00,0.00),('1','140','773','163783',3240126,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','163819',3240721,'2144','331',1421820.00,1423836.00,0.00,0.00,2016.00,460524.00,0.00,0.00,0.00),('1','140','773','163819',3240722,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','163823',3240783,'2144','331',1423836.00,1427350.00,0.00,0.00,3514.00,806158.00,0.00,0.00,0.00),('1','140','773','163823',3240784,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','163825',3240801,'2144','331',1427350.00,1434438.50,0.00,0.00,7088.50,1617422.00,0.00,0.00,0.00),('1','140','773','163825',3240802,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','164050',3245107,'2144','331',1434438.50,1446554.00,0.00,0.00,12115.50,2752515.20,0.00,0.00,0.00),('1','140','773','164050',3245108,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','164058',3245205,'2144','331',1446554.00,1461200.00,0.00,0.00,14646.00,3331944.00,0.00,0.00,0.00),('1','140','773','164058',3245206,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','164235',3248403,'2144','331',1461200.00,1466360.00,0.00,0.00,5160.00,1173666.00,0.00,0.00,0.00),('1','140','773','164235',3248404,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','164573',3254596,'2144','331',1466360.00,1472286.20,0.00,0.00,5926.20,1421394.80,0.00,0.00,0.00),('1','140','773','164573',3254597,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','164577',3254662,'2144','331',1472286.20,1478677.10,0.00,0.00,6390.90,1532047.60,0.00,0.00,0.00),('1','140','773','164577',3254663,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','164896',3260275,'2144','331',1478677.10,1485136.00,0.00,0.00,6458.90,1545464.20,0.00,0.00,0.00),('1','140','773','164896',3260276,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','164901',3260369,'2144','331',1485136.00,1485136.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','164901',3260370,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','165097',3263956,'2144','331',1485136.00,1491142.00,0.00,0.00,6006.00,1440814.00,0.00,0.00,0.00),('1','140','773','165097',3263957,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','165105',3264059,'2144','331',1491142.00,1507551.00,0.00,0.00,16409.00,3909256.80,0.00,0.00,0.00),('1','140','773','165105',3264060,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','165289',3267228,'2144','331',1507551.00,1514088.00,0.00,0.00,6537.00,1700718.00,0.00,0.00,0.00),('1','140','773','165289',3267229,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','165384',3268830,'2144','331',1514088.00,1520369.00,0.00,0.00,6281.00,1636230.00,0.00,0.00,0.00),('1','140','773','165384',3268831,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','165529',3271244,'2144','331',1520369.00,1530234.20,0.00,0.00,9865.20,2560868.00,0.00,0.00,0.00),('1','140','773','165529',3271245,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','165874',3277871,'2144','331',1530234.20,1530234.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','165874',3277872,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','165887',3278098,'2144','331',1530234.20,1537491.20,0.00,0.00,7257.00,1889122.00,0.00,0.00,0.00),('1','140','773','165887',3278099,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','166072',3281170,'2144','331',1537491.20,1545956.20,0.00,0.00,8465.00,2201112.00,0.00,0.00,0.00),('1','140','773','166072',3281171,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','166089',3281567,'2144','331',1545956.20,1552960.20,0.00,0.00,7004.00,1822308.00,0.00,0.00,0.00),('1','140','773','166089',3281568,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','166274',3284752,'2144','331',1552960.20,1563843.20,0.00,0.00,10883.00,2829474.00,0.00,0.00,0.00),('1','140','773','166274',3284753,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','166422',3287555,'2144','331',1563843.20,1574262.20,0.00,0.00,10419.00,2709174.00,0.00,0.00,0.00),('1','140','773','166422',3287556,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','166652',3291630,'2144','331',1574262.20,1575572.20,0.00,0.00,1310.00,337980.00,0.00,0.00,0.00),('1','140','773','166652',3291631,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','166668',3291941,'2144','331',1575572.20,1581420.20,0.00,0.00,5848.00,1523900.00,0.00,0.00,0.00),('1','140','773','166668',3291942,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','166850',3295045,'2144','331',1581420.20,1593854.20,0.00,0.00,12434.00,3227764.00,0.00,0.00,0.00),('1','140','773','166850',3295046,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','167313',3303162,'2144','331',1593854.20,1598251.20,0.00,0.00,4397.00,1143476.00,0.00,0.00,0.00),('1','140','773','167313',3303163,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','167513',3306963,'2144','331',1598251.20,1606589.20,0.00,0.00,8338.00,2171040.00,0.00,0.00,0.00),('1','140','773','167513',3306964,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','167522',3307157,'2144','331',1606589.20,1612713.20,0.00,0.00,6124.00,1595492.00,0.00,0.00,0.00),('1','140','773','167522',3307158,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','167539',3307480,'2144','331',1612713.20,1620864.20,0.00,0.00,8151.00,2118172.00,0.00,0.00,0.00),('1','140','773','167539',3307481,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','167676',3309733,'2144','331',1620864.20,1628070.20,0.00,0.00,7206.00,1877302.00,0.00,0.00,0.00),('1','140','773','167676',3309734,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','167847',3312651,'2144','331',1628070.20,1636106.20,0.00,0.00,8036.00,2089380.00,0.00,0.00,0.00),('1','140','773','167847',3312652,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','168069',3316903,'2144','331',1636106.20,1643485.20,0.00,0.00,7379.00,1918708.00,0.00,0.00,0.00),('1','140','773','168069',3316904,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','168195',3319168,'2144','331',1643485.20,1658323.20,0.00,0.00,14838.00,3854100.00,0.00,0.00,0.00),('1','140','773','168195',3319169,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','168557',3325600,'2144','331',1658323.20,1666221.20,0.00,0.00,7898.00,2027602.00,0.00,0.00,0.00),('1','140','773','168557',3325601,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','168730',3328882,'2144','331',1666221.20,1672137.20,0.00,0.00,5916.00,1521354.00,0.00,0.00,0.00),('1','140','773','168730',3328883,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','168738',3329004,'2144','331',1672137.20,1688613.20,0.00,0.00,16476.00,4219968.00,0.00,0.00,0.00),('1','140','773','168738',3329005,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','168910',3332007,'2144','331',1688613.20,1690896.20,0.00,0.00,2283.00,588768.00,0.00,0.00,0.00),('1','140','773','168910',3332008,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','170081',3354071,'2144','331',1690896.20,1700382.20,0.00,0.00,9486.00,2508592.00,0.00,0.00,0.00),('1','140','773','170081',3354072,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','170089',3354208,'2144','331',1700382.20,1715092.20,0.00,0.00,14710.00,3882290.00,0.00,0.00,0.00),('1','140','773','170089',3354209,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','170094',3354265,'2144','331',1715092.20,1715704.20,0.00,0.00,612.00,160344.00,0.00,0.00,0.00),('1','140','773','170094',3354266,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','170249',3356797,'2144','331',1715704.20,1735385.20,0.00,0.00,19681.00,5217608.00,0.00,0.00,0.00),('1','140','773','170249',3356798,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','170268',3357163,'2144','331',1735385.20,1740516.20,0.00,0.00,5131.00,1361350.00,0.00,0.00,0.00),('1','140','773','170268',3357164,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','170306',3357779,'2144','331',1740516.20,1758985.20,0.00,0.00,18469.00,4896875.00,0.00,0.00,0.00),('1','140','773','170306',3357780,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','170417',3359701,'2144','331',1758985.20,1773747.90,0.00,0.00,14762.70,3967818.00,0.00,0.00,0.00),('1','140','773','170417',3359702,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','170428',3359835,'2144','331',1773747.90,1781493.90,0.00,0.00,7746.00,2112180.00,0.00,0.00,0.00),('1','140','773','170428',3359836,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','170436',3360007,'2144','331',1781493.90,1791683.90,0.00,0.00,10190.00,2776866.00,0.00,0.00,0.00),('1','140','773','170436',3360008,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','170439',3360043,'2144','331',1791683.90,1798336.90,0.00,0.00,6653.00,1812266.00,0.00,0.00,0.00),('1','140','773','170439',3360044,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','170972',3369541,'2144','331',1798336.90,1823122.90,0.00,0.00,24786.00,6752892.00,0.00,0.00,0.00),('1','140','773','170972',3369542,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','170978',3369617,'2144','331',1823122.90,1835827.90,0.00,0.00,12705.00,3455544.00,0.00,0.00,0.00),('1','140','773','170978',3369618,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','170979',3369619,'2144','331',1835827.90,1847823.90,0.00,0.00,11996.00,3269592.00,0.00,0.00,0.00),('1','140','773','170979',3369620,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','170987',3369743,'2144','331',1847823.90,1860980.90,0.00,0.00,13157.00,3635714.00,0.00,0.00,0.00),('1','140','773','170987',3369744,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','171332',3376380,'2144','331',1860980.90,1869413.90,0.00,0.00,8433.00,2334594.00,0.00,0.00,0.00),('1','140','773','171332',3376381,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','171346',3376608,'2144','331',1869413.90,1872609.90,0.00,0.00,3196.00,888864.00,0.00,0.00,0.00),('1','140','773','171346',3376609,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','171522',3379824,'2144','331',1872609.90,1872609.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','171522',3379825,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','171736',3383635,'2144','331',1872609.90,1882620.90,0.00,0.00,10011.00,2771374.00,0.00,0.00,0.00),('1','140','773','171736',3383636,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','171745',3383746,'2144','331',1882620.90,1894884.90,0.00,0.00,12264.00,3391540.00,0.00,0.00,0.00),('1','140','773','171745',3383747,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','172348',3394548,'2144','331',1894884.90,1897466.90,0.00,0.00,2582.00,708020.00,0.00,0.00,0.00),('1','140','773','172348',3394549,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','172357',3394674,'2144','331',1897466.90,1915218.90,0.00,0.00,17752.00,4901108.00,0.00,0.00,0.00),('1','140','773','172357',3394675,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','172364',3394809,'2144','331',1915218.90,1921749.90,0.00,0.00,6531.00,1812900.00,0.00,0.00,0.00),('1','140','773','172364',3394810,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','172370',3394872,'2144','331',1921749.90,1922278.90,0.00,0.00,529.00,144946.00,0.00,0.00,0.00),('1','140','773','172370',3394873,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','172412',3395702,'2144','331',1922278.90,1937472.90,0.00,0.00,15194.00,4200108.00,0.00,0.00,0.00),('1','140','773','172412',3395703,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','172668',3400462,'2144','331',1937472.90,1947165.00,0.00,0.00,9692.10,2684962.00,0.00,0.00,0.00),('1','140','773','172668',3400463,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','172811',3403067,'2144','331',1947165.00,1967551.00,0.00,0.00,20386.00,5629114.00,0.00,0.00,0.00),('1','140','773','172811',3403068,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','172960',3405789,'2144','331',1967551.00,1972069.00,0.00,0.00,4518.00,1254968.00,0.00,0.00,0.00),('1','140','773','172960',3405790,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','173534',3416713,'2144','331',1972069.00,1991575.00,0.00,0.00,19506.00,5376154.00,0.00,0.00,0.00),('1','140','773','173534',3416714,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','173542',3416908,'2144','331',1991575.00,1995313.00,0.00,0.00,3738.00,1037854.00,0.00,0.00,0.00),('1','140','773','173542',3416909,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','173546',3416965,'2144','331',1995313.00,2012870.00,0.00,0.00,17557.00,4856976.00,0.00,0.00,0.00),('1','140','773','173546',3416966,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','173707',3419730,'2144','331',2012870.00,2019984.00,0.00,0.00,7114.00,1970636.00,0.00,0.00,0.00),('1','140','773','173707',3419731,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','173876',3422964,'2144','331',2019984.00,2038865.00,0.00,0.00,18881.00,5222508.00,0.00,0.00,0.00),('1','140','773','173876',3422965,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','174066',3426211,'2144','331',2038865.00,2044645.00,0.00,0.00,5780.00,1598212.00,0.00,0.00,0.00),('1','140','773','174066',3426212,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','174259',3429799,'2144','331',2044645.00,2067744.00,0.00,0.00,23099.00,6372673.00,0.00,0.00,0.00),('1','140','773','174259',3429800,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','174412',3432272,'2144','331',2067744.00,2087595.60,0.00,0.00,19851.60,5484196.00,0.00,0.00,0.00),('1','140','773','174412',3432273,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','175133',3445507,'2144','331',2087595.60,2092368.60,0.00,0.00,4773.00,1320458.00,0.00,0.00,0.00),('1','140','773','175133',3445508,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','175317',3448974,'2144','331',2092368.60,2107034.60,0.00,0.00,14666.00,4062928.00,0.00,0.00,0.00),('1','140','773','175317',3448975,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','175320',3449018,'2144','331',2107034.60,2108935.60,0.00,0.00,1901.00,524160.00,0.00,0.00,0.00),('1','140','773','175320',3449019,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','175327',3449150,'2144','331',2108935.60,2133466.60,0.00,0.00,24531.00,6769626.00,0.00,0.00,0.00),('1','140','773','175327',3449151,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','175407',3450619,'2144','331',2133466.60,2139781.60,0.00,0.00,6315.00,1878628.00,0.00,0.00,0.00),('1','140','773','175407',3450620,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','175412',3450692,'2144','331',2139781.60,2146449.60,0.00,0.00,6668.00,1993616.00,0.00,0.00,0.00),('1','140','773','175412',3450693,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','175583',3453862,'2144','331',2146449.60,2157904.60,0.00,0.00,11455.00,3406864.00,0.00,0.00,0.00),('1','140','773','175583',3453863,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','175720',3456276,'2144','331',2157904.60,2163551.10,0.00,0.00,5646.50,1690792.00,0.00,0.00,0.00),('1','140','773','175720',3456277,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','176089',3462912,'2144','331',2163551.10,2166900.10,0.00,0.00,3349.00,1000760.00,0.00,0.00,0.00),('1','140','773','176089',3462913,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','176111',3463373,'2144','331',2166900.10,2166900.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','176111',3463374,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','176113',3463402,'2144','331',2166900.10,2173303.10,0.00,0.00,6403.00,1909680.00,0.00,0.00,0.00),('1','140','773','176113',3463403,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','176463',3469774,'2144','331',2173303.10,2182431.60,0.00,0.00,9128.50,2718770.00,0.00,0.00,0.00),('1','140','773','176463',3469775,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','176480',3470107,'2144','331',2182431.60,2188797.60,0.00,0.00,6366.00,1904580.00,0.00,0.00,0.00),('1','140','773','176480',3470108,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','176662',3473557,'2144','331',2188797.60,2196300.60,0.00,0.00,7503.00,2235388.00,0.00,0.00,0.00),('1','140','773','176662',3473558,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','177788',3495200,'2144','331',2196300.60,2207174.60,0.00,0.00,10874.00,3234132.00,0.00,0.00,0.00),('1','140','773','177788',3495201,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','177793',3495273,'2144','331',2207174.60,2216642.60,0.00,0.00,9468.00,2817264.00,0.00,0.00,0.00),('1','140','773','177793',3495274,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','177817',3495749,'2144','331',2216642.60,2221558.60,0.00,0.00,4916.00,1470952.00,0.00,0.00,0.00),('1','140','773','177817',3495750,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','177822',3495838,'2144','331',2221558.60,2232220.60,0.00,0.00,10662.00,3169112.00,0.00,0.00,0.00),('1','140','773','177822',3495839,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','177827',3495936,'2144','331',2232220.60,2236560.90,0.00,0.00,4340.30,1299778.80,0.00,0.00,0.00),('1','140','773','177827',3495937,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','178004',3499330,'2144','331',2236560.90,2249385.00,0.00,0.00,12824.10,3816353.60,0.00,0.00,0.00),('1','140','773','178004',3499331,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','178391',3506540,'2144','331',2249385.00,2255221.60,0.00,0.00,5836.60,1742952.00,0.00,0.00,0.00),('1','140','773','178391',3506541,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','178403',3506721,'2144','331',2255221.60,2257132.60,0.00,0.00,1911.00,566176.00,0.00,0.00,0.00),('1','140','773','178403',3506722,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','178410',3506854,'2144','331',2257132.60,2257132.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','178410',3506855,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','179081',3519129,'2144','331',2257132.60,2280056.80,0.00,0.00,22924.20,6819979.60,0.00,0.00,0.00),('1','140','773','179081',3519130,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','179088',3519297,'2144','331',2280056.80,2281913.80,0.00,0.00,1857.00,568690.00,0.00,0.00,0.00),('1','140','773','179088',3519298,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','179099',3519500,'2144','331',2281913.80,2290801.80,0.00,0.00,8888.00,2713126.00,0.00,0.00,0.00),('1','140','773','179099',3519501,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','179459',3526247,'2144','331',2290801.80,2301135.80,0.00,0.00,10334.00,3152852.00,0.00,0.00,0.00),('1','140','773','179459',3526248,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','179520',3527508,'2144','331',2301135.80,2311808.80,0.00,0.00,10673.00,3254476.00,0.00,0.00,0.00),('1','140','773','179520',3527509,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','179714',3531269,'2144','331',2311808.80,2318354.80,0.00,0.00,6546.00,1996612.00,0.00,0.00,0.00),('1','140','773','179714',3531270,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','179941',3535599,'2144','331',2318354.80,2325913.80,0.00,0.00,7559.00,2308344.00,0.00,0.00,0.00),('1','140','773','179941',3535600,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','179964',3535945,'2144','331',2325913.80,2336634.30,0.00,0.00,10720.50,3274067.00,0.00,0.00,0.00),('1','140','773','179964',3535946,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','180028',3536998,'2144','331',2336634.30,2348308.90,0.00,0.00,11674.60,3566266.60,0.00,0.00,0.00),('1','140','773','180028',3536999,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','180164',3539843,'2144','331',2348308.90,2350853.71,0.00,0.00,2544.81,777596.16,0.00,0.00,0.00),('1','140','773','180164',3539844,'2187','331',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','180258',3541356,'2144','331',2350853.71,2356197.38,0.00,0.00,5343.67,1627483.12,0.00,0.00,0.00),('1','140','773','180258',3541357,'2187','331',0.00,2.98,0.00,0.00,2.98,1001.28,0.00,0.00,0.00),('1','140','773','180336',3542774,'2144','331',2356197.38,2365136.33,0.00,0.00,8938.95,2734024.20,0.00,0.00,0.00),('1','140','773','180336',3542775,'2187','331',2.98,2.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','180559',3546740,'2144','331',2365136.33,2371781.40,0.00,0.00,6645.07,2035134.52,0.00,0.00,0.00),('1','140','773','180559',3546741,'2187','331',2.98,2.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','180737',3550062,'2144','331',2371781.40,2375839.38,0.00,0.00,4057.98,1175643.28,0.00,0.00,0.00),('1','140','773','180737',3550063,'2187','331',2.98,2.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','180854',3552080,'2144','331',2375839.38,2385524.27,0.00,0.00,9684.89,2950595.04,0.00,0.00,0.00),('1','140','773','180854',3552081,'2187','331',2.98,2.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','180957',3554391,'2144','331',2385524.27,2397959.79,0.00,0.00,12435.52,3795873.62,0.00,0.00,0.00),('1','140','773','180957',3554392,'2187','331',2.98,32.98,0.00,0.00,30.00,9180.00,0.00,0.00,0.00),('1','140','773','181128',3557645,'2144','331',2397959.79,2400504.27,0.00,0.00,2544.48,775452.28,0.00,0.00,0.00),('1','140','773','181128',3557646,'2187','331',32.98,32.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','181262',3560301,'2144','331',2400504.27,2411995.42,0.00,0.00,11491.15,3483582.40,0.00,0.00,0.00),('1','140','773','181262',3560302,'2187','331',32.98,32.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','181345',3561804,'2144','331',2411995.42,2420429.41,0.00,0.00,8433.99,2577176.64,0.00,0.00,0.00),('1','140','773','181345',3561805,'2187','331',32.98,144.98,0.00,0.00,112.00,34272.00,0.00,0.00,0.00),('1','140','773','181521',3565068,'2144','331',2420429.41,2423856.77,0.00,0.00,3427.36,1052322.96,0.00,0.00,0.00),('1','140','773','181521',3565069,'2187','331',144.98,144.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','181697',3568065,'2144','331',2423856.77,2424824.86,0.00,0.00,968.09,296890.74,0.00,0.00,0.00),('1','140','773','181697',3568066,'2187','331',144.98,144.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','181819',3570085,'2144','331',2424824.86,2433554.06,0.00,0.00,8729.20,2666985.10,0.00,0.00,0.00),('1','140','773','181819',3570086,'2187','331',144.98,144.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','181962',3572595,'2144','331',2433554.06,2444114.52,0.00,0.00,10560.46,3220694.56,0.00,0.00,0.00),('1','140','773','181962',3572596,'2187','331',144.98,168.98,0.00,0.00,24.00,7344.00,0.00,0.00,0.00),('1','140','773','182104',3575447,'2144','331',2444114.52,2449524.11,0.00,0.00,5409.59,1651940.24,0.00,0.00,0.00),('1','140','773','182104',3575448,'2187','331',168.98,168.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','182197',3576989,'2144','331',2449524.11,2457228.86,0.00,0.00,7704.75,2330728.00,0.00,0.00,0.00),('1','140','773','182197',3576990,'2187','331',168.98,168.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','182311',3578901,'2144','331',2457228.86,2466544.71,0.00,0.00,9315.85,2845237.70,0.00,0.00,0.00),('1','140','773','182311',3578902,'2187','331',168.98,168.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','182497',3582337,'2144','331',2466544.71,2470360.77,0.00,0.00,3816.06,1173977.16,0.00,0.00,0.00),('1','140','773','182497',3582338,'2187','331',168.98,348.98,0.00,0.00,180.00,55080.00,0.00,0.00,0.00),('1','140','773','182685',3585865,'2144','331',2470360.77,2474122.30,0.00,0.00,3761.53,1147986.08,0.00,0.00,0.00),('1','140','773','182685',3585866,'2187','331',348.98,348.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','182754',3587095,'2144','331',2474122.30,2479752.72,0.00,0.00,5630.42,1722196.12,0.00,0.00,0.00),('1','140','773','182754',3587096,'2187','331',348.98,348.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','182831',3588649,'2144','331',2479752.72,2489212.92,0.00,0.00,9460.20,2865421.20,0.00,0.00,0.00),('1','140','773','182831',3588650,'2187','331',348.98,348.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','182991',3591456,'2144','331',2489212.92,2494027.71,0.00,0.00,4814.79,1470707.44,0.00,0.00,0.00),('1','140','773','182991',3591457,'2187','331',348.98,348.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','183131',3593992,'2144','331',2494027.71,2496362.47,0.00,0.00,2334.76,713004.96,0.00,0.00,0.00),('1','140','773','183131',3593993,'2187','331',348.98,348.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','183217',3595636,'2144','331',2496362.47,2505581.19,0.00,0.00,9218.72,2816121.92,0.00,0.00,0.00),('1','140','773','183217',3595637,'2187','331',348.98,348.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','183428',3599409,'2144','331',2505581.19,2512801.47,0.00,0.00,7220.28,2209250.08,0.00,0.00,0.00),('1','140','773','183428',3599410,'2187','331',348.98,348.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','183637',3603243,'2144','331',2512801.47,2518794.72,0.00,0.00,5993.25,1829723.00,0.00,0.00,0.00),('1','140','773','183637',3603244,'2187','331',348.98,348.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','183795',3606053,'2144','331',2518794.72,2521104.19,0.00,0.00,2309.47,708621.92,0.00,0.00,0.00),('1','140','773','183795',3606054,'2187','331',348.98,348.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','183868',3607558,'2144','331',2521104.19,2528248.66,0.00,0.00,7144.47,2185600.92,0.00,0.00,0.00),('1','140','773','183868',3607559,'2187','331',348.98,348.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','184070',3611137,'2144','331',2528248.66,2530183.95,0.00,0.00,1935.29,592771.44,0.00,0.00,0.00),('1','140','773','184070',3611138,'2187','331',348.98,348.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','184224',3613912,'2144','331',2530183.95,2537266.25,0.00,0.00,7082.30,2166696.40,0.00,0.00,0.00),('1','140','773','184224',3613913,'2187','331',348.98,348.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','184304',3615065,'2144','331',2537266.25,2546026.96,0.00,0.00,8760.71,2654620.56,0.00,0.00,0.00),('1','140','773','184304',3615066,'2187','331',348.98,348.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','184391',3616669,'2144','331',2546026.96,2548128.30,0.00,0.00,2101.34,654050.24,0.00,0.00,0.00),('1','140','773','184391',3616670,'2187','331',348.98,348.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','184455',3617911,'2144','331',2548128.30,2553910.24,0.00,0.00,5781.94,1772480.94,0.00,0.00,0.00),('1','140','773','184455',3617912,'2187','331',348.98,348.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','184682',3622138,'2144','331',2553910.24,2565512.95,0.00,0.00,11602.71,3546983.56,0.00,0.00,0.00),('1','140','773','184682',3622139,'2187','331',348.98,355.23,0.00,0.00,6.25,2100.00,0.00,0.00,0.00),('1','140','773','184882',3625684,'2144','331',2565512.95,2570488.22,0.00,0.00,4975.27,1516822.72,0.00,0.00,0.00),('1','140','773','184882',3625685,'2187','331',355.23,355.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','184980',3627358,'2144','331',2570488.22,2570488.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','184980',3627359,'2187','331',355.23,355.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','184990',3627470,'2144','331',2570488.22,2576086.52,0.00,0.00,5598.30,1710770.80,0.00,0.00,0.00),('1','140','773','184990',3627471,'2187','331',355.23,355.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','185098',3629391,'2144','331',2576086.52,2585613.51,0.00,0.00,9526.99,2912998.34,0.00,0.00,0.00),('1','140','773','185098',3629392,'2187','331',355.23,355.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','185256',3631888,'2144','331',2585613.51,2595098.83,0.00,0.00,9485.32,2897739.52,0.00,0.00,0.00),('1','140','773','185256',3631889,'2187','331',355.23,355.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','185355',3633635,'2144','331',2595098.83,2606370.40,0.00,0.00,11271.57,3432283.52,0.00,0.00,0.00),('1','140','773','185355',3633636,'2187','331',355.23,355.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','185459',3635737,'2144','331',2606370.40,2619429.06,0.00,0.00,13058.66,3970385.46,0.00,0.00,0.00),('1','140','773','185459',3635738,'2187','331',355.23,365.65,0.00,0.00,10.42,3501.12,0.00,0.00,0.00),('1','140','773','185715',3640098,'2144','331',2619429.06,2628094.14,0.00,0.00,8665.08,2653984.88,0.00,0.00,0.00),('1','140','773','185715',3640099,'2187','331',365.65,365.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','185866',3643004,'2144','331',2628094.14,2642386.51,0.00,0.00,14292.37,4368737.32,0.00,0.00,0.00),('1','140','773','185866',3643005,'2187','331',365.65,365.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','186083',3646891,'2144','331',2642386.51,2644024.62,0.00,0.00,1638.11,499224.96,0.00,0.00,0.00),('1','140','773','186083',3646892,'2187','331',365.65,365.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','186153',3647941,'2144','331',2644024.62,2653264.44,0.00,0.00,9239.82,2821149.92,0.00,0.00,0.00),('1','140','773','186153',3647942,'2187','331',365.65,365.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','186308',3650621,'2144','331',2653264.44,2662026.74,0.00,0.00,8762.30,2678980.80,0.00,0.00,0.00),('1','140','773','186308',3650622,'2187','331',365.65,365.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','186523',3654294,'2144','331',2662026.74,2668294.68,0.00,0.00,6267.94,1915365.84,0.00,0.00,0.00),('1','140','773','186523',3654295,'2187','331',365.65,365.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','186682',3656982,'2144','331',2668294.68,2670377.60,0.00,0.00,2082.92,635131.12,0.00,0.00,0.00),('1','140','773','186682',3656983,'2187','331',365.65,365.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','186752',3658146,'2144','331',2670377.60,2685625.72,0.00,0.00,15248.12,4612212.72,0.00,0.00,0.00),('1','140','773','186752',3658147,'2187','331',365.65,365.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','186991',3662070,'2144','331',2685625.72,2691976.57,0.00,0.00,6350.85,1946557.60,0.00,0.00,0.00),('1','140','773','186991',3662071,'2187','331',365.65,365.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','187152',3664954,'2144','331',2691976.57,2697426.54,0.00,0.00,5449.97,1666339.92,0.00,0.00,0.00),('1','140','773','187152',3664955,'2187','331',365.65,365.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','187357',3668591,'2144','331',2697426.54,2709233.43,0.00,0.00,11806.89,3607465.04,0.00,0.00,0.00),('1','140','773','187357',3668592,'2187','331',365.65,365.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','187573',3672425,'2144','331',2709233.43,2711511.69,0.00,0.00,2278.26,694685.36,0.00,0.00,0.00),('1','140','773','187573',3672426,'2187','331',365.65,365.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','187646',3673622,'2144','331',2711511.69,2718758.45,0.00,0.00,7246.76,2214682.36,0.00,0.00,0.00),('1','140','773','187646',3673623,'2187','331',365.65,365.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','187792',3676348,'2144','331',2718758.45,2727437.00,0.00,0.00,8678.55,2652689.80,0.00,0.00,0.00),('1','140','773','187792',3676349,'2187','331',365.65,365.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','188010',3680184,'2144','331',2727437.00,2736056.06,0.00,0.00,8619.06,2620957.16,0.00,0.00,0.00),('1','140','773','188010',3680185,'2187','331',365.65,365.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','188196',3683438,'2144','331',2736056.06,2746182.04,0.00,0.00,10125.98,3095880.28,0.00,0.00,0.00),('1','140','773','188196',3683439,'2187','331',365.65,365.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','188416',3687115,'2144','331',2746182.04,2765015.87,0.00,0.00,18833.83,5733521.88,0.00,0.00,0.00),('1','140','773','188416',3687116,'2187','331',365.65,365.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','188595',3690304,'2144','331',2765015.87,2770784.77,0.00,0.00,5768.90,1761020.40,0.00,0.00,0.00),('1','140','773','188595',3690305,'2187','331',365.65,365.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','188796',3693891,'2144','331',2770784.77,2785315.50,0.00,0.00,14530.73,4441267.28,0.00,0.00,0.00),('1','140','773','188796',3693892,'2187','331',365.65,365.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','189003',3697570,'2144','331',2785315.50,2794273.22,0.00,0.00,8957.72,2739319.92,0.00,0.00,0.00),('1','140','773','189003',3697571,'2187','331',365.65,415.65,0.00,0.00,50.00,15300.00,0.00,0.00,0.00),('1','140','773','189193',3700939,'2144','331',2794273.22,2795428.47,0.00,0.00,1155.25,351564.00,0.00,0.00,0.00),('1','140','773','189193',3700940,'2187','331',415.65,415.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','189257',3701955,'2144','331',2795428.47,2802908.98,0.00,0.00,7480.51,2288256.36,0.00,0.00,0.00),('1','140','773','189257',3701956,'2187','331',415.65,415.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','189411',3704966,'2144','331',2802908.98,2810728.70,0.00,0.00,7819.72,2392815.92,0.00,0.00,0.00),('1','140','773','189411',3704967,'2187','331',415.65,415.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','189613',3708444,'2144','331',2810728.70,2815407.20,0.00,0.00,4678.50,1409094.00,0.00,0.00,0.00),('1','140','773','189613',3708445,'2187','331',415.65,415.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','189722',3710120,'2144','331',2815407.20,2824258.94,0.00,0.00,8851.74,2681274.64,0.00,0.00,0.00),('1','140','773','189722',3710121,'2187','331',415.65,415.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','189805',3711834,'2144','331',2824258.94,2834753.47,0.00,0.00,10494.53,3213815.08,0.00,0.00,0.00),('1','140','773','189805',3711835,'2187','331',415.65,415.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','190063',3716754,'2144','331',2834753.47,2839804.77,0.00,0.00,5051.30,1548151.80,0.00,0.00,0.00),('1','140','773','190063',3716755,'2187','331',415.65,415.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','190201',3719588,'2144','331',2839804.77,2850243.23,0.00,0.00,10438.46,3191722.76,0.00,0.00,0.00),('1','140','773','190201',3719589,'2187','331',415.65,471.60,0.00,0.00,55.95,17299.20,0.00,0.00,0.00),('1','140','773','190422',3723665,'2144','331',2850243.23,2859335.01,0.00,0.00,9091.78,2785032.08,0.00,0.00,0.00),('1','140','773','190422',3723666,'2187','331',471.60,471.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','190661',3728118,'2144','331',2859335.01,2864103.71,0.00,0.00,4768.70,1445218.20,0.00,0.00,0.00),('1','140','773','190661',3728119,'2187','331',471.60,471.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','190773',3730102,'2144','331',2864103.71,2871722.31,0.00,0.00,7618.60,2329171.60,0.00,0.00,0.00),('1','140','773','190773',3730103,'2187','331',471.60,471.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','190884',3732158,'2144','331',2871722.31,2881976.60,0.00,0.00,10254.29,3140420.04,0.00,0.00,0.00),('1','140','773','190884',3732159,'2187','331',471.60,471.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','191060',3735269,'2144','331',2881976.60,2888493.91,0.00,0.00,6517.31,1988806.16,0.00,0.00,0.00),('1','140','773','191060',3735270,'2187','331',471.60,471.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','191233',3738368,'2144','331',2888493.91,2892119.79,0.00,0.00,3625.88,1105947.68,0.00,0.00,0.00),('1','140','773','191233',3738369,'2187','331',471.60,521.60,0.00,0.00,50.00,15300.00,0.00,0.00,0.00),('1','140','773','191281',3739186,'2144','331',2892119.79,2911915.44,0.00,0.00,19795.65,5997257.40,0.00,0.00,0.00),('1','140','773','191281',3739187,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','191503',3743010,'2144','331',2911915.44,2913123.31,0.00,0.00,1207.87,368398.32,0.00,0.00,0.00),('1','140','773','191503',3743011,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','191690',3746927,'2144','331',2913123.31,2917520.71,0.00,0.00,4397.40,1339527.40,0.00,0.00,0.00),('1','140','773','191690',3746928,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','191700',3747094,'2144','331',2917520.71,2932060.91,0.00,0.00,14540.20,4432301.40,0.00,0.00,0.00),('1','140','773','191700',3747095,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','191929',3751495,'2144','331',2932060.91,2937627.68,0.00,0.00,5566.77,1687344.72,0.00,0.00,0.00),('1','140','773','191929',3751496,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','192428',3760128,'2144','331',2937627.68,2946733.77,0.00,0.00,9106.09,2784763.24,0.00,0.00,0.00),('1','140','773','192428',3760129,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','192571',3762888,'2144','331',2946733.77,2957919.07,0.00,0.00,11185.30,3399915.80,0.00,0.00,0.00),('1','140','773','192571',3762889,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','193292',3776278,'2144','331',2957919.07,2957919.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','193292',3776279,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','193293',3776280,'2144','331',2957919.07,2962184.37,0.00,0.00,4265.30,1282261.80,0.00,0.00,0.00),('1','140','773','193293',3776281,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','193300',3776370,'2144','331',2962184.37,2970235.77,0.00,0.00,8051.40,2458374.40,0.00,0.00,0.00),('1','140','773','193300',3776371,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','193318',3776828,'2144','331',2970235.77,2974629.37,0.00,0.00,4393.60,1345779.60,0.00,0.00,0.00),('1','140','773','193318',3776829,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','193322',3776902,'2144','331',2974629.37,2983123.13,0.00,0.00,8493.76,2582683.36,0.00,0.00,0.00),('1','140','773','193322',3776903,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','193396',3778743,'2144','331',2983123.13,2986765.65,0.00,0.00,3642.52,1113828.72,0.00,0.00,0.00),('1','140','773','193396',3778744,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','193537',3781148,'2144','331',2986765.65,2992496.53,0.00,0.00,5730.88,1729890.68,0.00,0.00,0.00),('1','140','773','193537',3781149,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','193620',3782827,'2144','331',2992496.53,3000097.13,0.00,0.00,7600.60,2295272.60,0.00,0.00,0.00),('1','140','773','193620',3782828,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','193841',3786815,'2144','331',3000097.13,3011948.93,0.00,0.00,11851.80,3587114.60,0.00,0.00,0.00),('1','140','773','193841',3786816,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','194018',3789845,'2144','331',3011948.93,3015825.66,0.00,0.00,3876.73,1181446.28,0.00,0.00,0.00),('1','140','773','194018',3789846,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','194081',3790919,'2144','331',3015825.66,3022029.76,0.00,0.00,6204.10,1899176.60,0.00,0.00,0.00),('1','140','773','194081',3790920,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','194285',3794819,'2144','331',3022029.76,3031519.17,0.00,0.00,9489.41,2879442.76,0.00,0.00,0.00),('1','140','773','194285',3794820,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','194523',3798843,'2144','331',3031519.17,3036084.81,0.00,0.00,4565.64,1386674.04,0.00,0.00,0.00),('1','140','773','194523',3798844,'2187','331',521.60,521.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','194668',3801586,'2144','331',3036084.81,3044293.69,0.00,0.00,8208.88,2507140.08,0.00,0.00,0.00),('1','140','773','194668',3801587,'2187','331',521.60,641.60,0.00,0.00,120.00,36720.00,0.00,0.00,0.00),('1','140','773','194939',3806977,'2144','331',3044293.69,3049643.30,0.00,0.00,5349.61,1624455.96,0.00,0.00,0.00),('1','140','773','194939',3806978,'2187','331',641.60,641.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','195072',3809292,'2144','331',3049643.30,3057161.03,0.00,0.00,7517.73,2279780.28,0.00,0.00,0.00),('1','140','773','195072',3809293,'2187','331',641.60,641.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','195297',3813257,'2144','331',3057161.03,3060585.69,0.00,0.00,3424.66,1048497.36,0.00,0.00,0.00),('1','140','773','195297',3813258,'2187','331',641.60,641.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','195477',3816387,'2144','331',3060585.69,3060978.01,0.00,0.00,392.32,121139.52,0.00,0.00,0.00),('1','140','773','195477',3816388,'2187','331',641.60,641.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','195513',3817098,'2144','331',3060978.01,3071669.93,0.00,0.00,10691.92,3244757.12,0.00,0.00,0.00),('1','140','773','195513',3817099,'2187','331',641.60,641.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','195787',3821529,'2144','331',3071669.93,3077856.57,0.00,0.00,6186.64,1869493.04,0.00,0.00,0.00),('1','140','773','195787',3821530,'2187','331',641.60,641.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','196164',3828687,'2144','331',3077856.57,3081150.60,0.00,0.00,3294.03,993505.68,0.00,0.00,0.00),('1','140','773','196164',3828688,'2187','331',641.60,641.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','196217',3829681,'2144','331',3081150.60,3085246.83,0.00,0.00,4096.23,1233243.28,0.00,0.00,0.00),('1','140','773','196217',3829682,'2187','331',641.60,691.60,0.00,0.00,50.00,15300.00,0.00,0.00,0.00),('1','140','773','196410',3833188,'2144','331',3085246.83,3090793.83,0.00,0.00,5547.00,1662576.00,0.00,0.00,0.00),('1','140','773','196410',3833189,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','196445',3833796,'2144','331',3090793.83,3093863.33,0.00,0.00,3069.50,921227.00,0.00,0.00,0.00),('1','140','773','196445',3833797,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','196778',3839616,'2144','331',3093863.33,3098925.13,0.00,0.00,5061.80,1520152.80,0.00,0.00,0.00),('1','140','773','196778',3839617,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','196941',3842484,'2144','331',3098925.13,3102073.03,0.00,0.00,3147.90,943798.40,0.00,0.00,0.00),('1','140','773','196941',3842485,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','197066',3844732,'2144','331',3102073.03,3109879.53,0.00,0.00,7806.50,2336477.20,0.00,0.00,0.00),('1','140','773','197066',3844733,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','197586',3853638,'2144','331',3109879.53,3115663.53,0.00,0.00,5784.00,1739026.00,0.00,0.00,0.00),('1','140','773','197586',3853639,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','197588',3853663,'2144','331',3115663.53,3120329.23,0.00,0.00,4665.70,1400959.20,0.00,0.00,0.00),('1','140','773','197588',3853664,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','197597',3853820,'2144','331',3120329.23,3124268.23,0.00,0.00,3939.00,1184936.00,0.00,0.00,0.00),('1','140','773','197597',3853821,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','197997',3861090,'2144','331',3124268.23,3133232.23,0.00,0.00,8964.00,2664640.00,0.00,0.00,0.00),('1','140','773','197997',3861091,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','198192',3864330,'2144','331',3133232.23,3134386.63,0.00,0.00,1154.40,352802.40,0.00,0.00,0.00),('1','140','773','198192',3864331,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','198292',3866135,'2144','331',3134386.63,3134386.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','198292',3866136,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','198301',3866347,'2144','331',3134386.63,3134386.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','198301',3866348,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','198420',3868240,'2144','331',3134386.63,3135747.43,0.00,0.00,1360.80,410130.00,0.00,0.00,0.00),('1','140','773','198420',3868241,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','198422',3868264,'2144','331',3135747.43,3142909.82,0.00,0.00,7162.39,2135298.32,0.00,0.00,0.00),('1','140','773','198422',3868265,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','198569',3870835,'2144','331',3142909.82,3154896.63,0.00,0.00,11986.81,3578036.16,0.00,0.00,0.00),('1','140','773','198569',3870836,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','199166',3881463,'2144','331',3154896.63,3159148.43,0.00,0.00,4251.80,1269688.80,0.00,0.00,0.00),('1','140','773','199166',3881464,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','199380',3884724,'2144','331',3159148.43,3165197.23,0.00,0.00,6048.80,1812404.80,0.00,0.00,0.00),('1','140','773','199380',3884725,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','199743',3890367,'2144','331',3165197.23,3172517.03,0.00,0.00,7319.80,2185726.80,0.00,0.00,0.00),('1','140','773','199743',3890368,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','199748',3890462,'2144','331',3172517.03,3175322.03,0.00,0.00,2805.00,848524.00,0.00,0.00,0.00),('1','140','773','199748',3890463,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','199992',3894840,'2144','331',3175322.03,3178524.64,0.00,0.00,3202.61,963106.96,0.00,0.00,0.00),('1','140','773','199992',3894841,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','200159',3897791,'2144','331',3178524.64,3183829.97,0.00,0.00,5305.33,1582456.88,0.00,0.00,0.00),('1','140','773','200159',3897792,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','200339',3900802,'2144','331',3183829.97,3186369.18,0.00,0.00,2539.21,763048.56,0.00,0.00,0.00),('1','140','773','200339',3900803,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','200637',3906514,'2144','331',3186369.18,3189237.08,0.00,0.00,2867.90,844962.40,0.00,0.00,0.00),('1','140','773','200637',3906515,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','200732',3908069,'2144','331',3189237.08,3189237.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','200732',3908070,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','200733',3908071,'2144','331',3189237.08,3194201.98,0.00,0.00,4964.90,1445174.80,0.00,0.00,0.00),('1','140','773','200733',3908072,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','200948',3911773,'2144','331',3194201.98,3199764.34,0.00,0.00,5562.36,1629026.96,0.00,0.00,0.00),('1','140','773','200948',3911774,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','201119',3914671,'2144','331',3199764.34,3206835.13,0.00,0.00,7070.79,2070741.56,0.00,0.00,0.00),('1','140','773','201119',3914672,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','201319',3918118,'2144','331',3206835.13,3211098.15,0.00,0.00,4263.02,1250716.72,0.00,0.00,0.00),('1','140','773','201319',3918119,'2187','331',691.60,691.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','201508',3921570,'2144','331',3211098.15,3218759.40,0.00,0.00,7661.25,2175902.00,0.00,0.00,0.00),('1','140','773','201508',3921571,'2187','331',691.60,715.60,0.00,0.00,24.00,7056.00,0.00,0.00,0.00),('1','140','773','201885',3928748,'2144','331',3218759.40,3225600.15,0.00,0.00,6840.75,2081441.00,0.00,0.00,0.00),('1','140','773','201885',3928749,'2187','331',715.60,715.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','202186',3934358,'2144','331',3225600.15,3229207.95,0.00,0.00,3607.80,1104955.80,0.00,0.00,0.00),('1','140','773','202186',3934359,'2187','331',715.60,715.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','202287',3935845,'2144','331',3229207.95,3229306.25,0.00,0.00,98.30,28900.20,0.00,0.00,0.00),('1','140','773','202287',3935846,'2187','331',715.60,715.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','202290',3935903,'2144','331',3229306.25,3235359.95,0.00,0.00,6053.70,1845465.20,0.00,0.00,0.00),('1','140','773','202290',3935904,'2187','331',715.60,715.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','202440',3938569,'2144','331',3235359.95,3238548.75,0.00,0.00,3188.80,972370.80,0.00,0.00,0.00),('1','140','773','202440',3938570,'2187','331',715.60,715.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','202680',3942629,'2144','331',3238548.75,3245933.75,0.00,0.00,7385.00,2246156.00,0.00,0.00,0.00),('1','140','773','202680',3942630,'2187','331',715.60,715.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','202924',3947119,'2144','331',3245933.75,3254281.09,0.00,0.00,8347.34,2537281.24,0.00,0.00,0.00),('1','140','773','202924',3947120,'2187','331',715.60,715.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','203187',3952144,'2144','331',3254281.09,3263338.45,0.00,0.00,9057.36,2759815.96,0.00,0.00,0.00),('1','140','773','203187',3952145,'2187','331',715.60,718.73,0.00,0.00,3.13,1051.68,0.00,0.00,0.00),('1','140','773','203389',3955864,'2144','331',3263338.45,3267311.45,0.00,0.00,3973.00,1209858.00,0.00,0.00,0.00),('1','140','773','203389',3955865,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','203668',3961017,'2144','331',3267311.45,3273412.45,0.00,0.00,6101.00,1861516.00,0.00,0.00,0.00),('1','140','773','203668',3961018,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','203775',3962679,'2144','331',3273412.45,3281338.36,0.00,0.00,7925.91,2414712.76,0.00,0.00,0.00),('1','140','773','203775',3962680,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','204016',3966887,'2144','331',3281338.36,3287960.07,0.00,0.00,6621.71,2012616.56,0.00,0.00,0.00),('1','140','773','204016',3966888,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','204196',3970390,'2144','331',3287960.07,3287960.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','204196',3970391,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','204281',3971882,'2144','331',3287960.07,3292484.66,0.00,0.00,4524.59,1376441.24,0.00,0.00,0.00),('1','140','773','204281',3971883,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','204485',3975507,'2144','331',3292484.66,3302835.60,0.00,0.00,10350.94,3141519.84,0.00,0.00,0.00),('1','140','773','204485',3975508,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','204647',3978354,'2144','331',3302835.60,3312526.31,0.00,0.00,9690.71,2945738.56,0.00,0.00,0.00),('1','140','773','204647',3978355,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','204952',3983479,'2144','331',3312526.31,3321149.81,0.00,0.00,8623.50,2621007.00,0.00,0.00,0.00),('1','140','773','204952',3983480,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','205208',3988415,'2144','331',3321149.81,3324021.61,0.00,0.00,2871.80,879954.80,0.00,0.00,0.00),('1','140','773','205208',3988416,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','205303',3989846,'2144','331',3324021.61,3329937.85,0.00,0.00,5916.24,1811571.64,0.00,0.00,0.00),('1','140','773','205303',3989847,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','205615',3995643,'2144','331',3329937.85,3337131.55,0.00,0.00,7193.70,2183313.20,0.00,0.00,0.00),('1','140','773','205615',3995644,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','205701',3997388,'2144','331',3337131.55,3342952.35,0.00,0.00,5820.80,1767408.80,0.00,0.00,0.00),('1','140','773','205701',3997389,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','205799',3998939,'2144','331',3342952.35,3347054.33,0.00,0.00,4101.98,1262809.28,0.00,0.00,0.00),('1','140','773','205799',3998940,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','206029',4002947,'2144','331',3347054.33,3355146.42,0.00,0.00,8092.09,2521724.24,0.00,0.00,0.00),('1','140','773','206029',4002948,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','206238',4006768,'2144','331',3355146.42,3360225.37,0.00,0.00,5078.95,1585229.20,0.00,0.00,0.00),('1','140','773','206238',4006769,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','206505',4011451,'2144','331',3360225.37,3361750.07,0.00,0.00,1524.70,474279.60,0.00,0.00,0.00),('1','140','773','206505',4011452,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','206723',4015222,'2144','331',3361750.07,3365129.07,0.00,0.00,3379.00,1057376.00,0.00,0.00,0.00),('1','140','773','206723',4015223,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','206728',4015305,'2144','331',3365129.07,3369106.37,0.00,0.00,3977.30,1242642.80,0.00,0.00,0.00),('1','140','773','206728',4015306,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','206847',4017242,'2144','331',3369106.37,3379675.59,0.00,0.00,10569.22,3288403.92,0.00,0.00,0.00),('1','140','773','206847',4017243,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','207093',4021753,'2144','331',3379675.59,3386458.39,0.00,0.00,6782.80,2112368.80,0.00,0.00,0.00),('1','140','773','207093',4021754,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','207348',4026263,'2144','331',3386458.39,3393244.49,0.00,0.00,6786.10,2117500.20,0.00,0.00,0.00),('1','140','773','207348',4026264,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','207514',4029355,'2144','331',3393244.49,3407623.49,0.00,0.00,14379.00,4472382.40,0.00,0.00,0.00),('1','140','773','207514',4029356,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','207812',4034396,'2144','331',3407623.49,3409162.49,0.00,0.00,1539.00,493824.00,0.00,0.00,0.00),('1','140','773','207812',4034397,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','208301',4043278,'2144','331',3409162.49,3422607.09,0.00,0.00,13444.60,4268141.60,0.00,0.00,0.00),('1','140','773','208301',4043279,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','208466',4045798,'2144','331',3422607.09,3433840.59,0.00,0.00,11233.50,3563628.00,0.00,0.00,0.00),('1','140','773','208466',4045799,'2187','331',718.73,718.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','208762',4051125,'2144','331',3433840.59,3445118.85,0.00,0.00,11278.26,3729215.56,0.00,0.00,0.00),('1','140','773','208762',4051126,'2187','331',718.73,721.76,0.00,0.00,3.03,1048.38,0.00,0.00,0.00),('1','140','773','209017',4055343,'2144','331',3445118.85,3449761.53,0.00,0.00,4642.68,1539389.20,0.00,0.00,0.00),('1','140','773','209017',4055344,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','209275',4059952,'2144','331',3449761.53,3464663.03,0.00,0.00,14901.50,4933680.76,0.00,0.00,0.00),('1','140','773','209275',4059953,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','209512',4064148,'2144','331',3464663.03,3471001.93,0.00,0.00,6338.90,2156449.00,0.00,0.00,0.00),('1','140','773','209512',4064149,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','209726',4068033,'2144','331',3471001.93,3474277.73,0.00,0.00,3275.80,1114388.20,0.00,0.00,0.00),('1','140','773','209726',4068034,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','210021',4073277,'2144','331',3474277.73,3476872.73,0.00,0.00,2595.00,879010.00,0.00,0.00,0.00),('1','140','773','210021',4073278,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','210030',4073462,'2144','331',3476872.73,3482168.13,0.00,0.00,5295.40,1910166.00,0.00,0.00,0.00),('1','140','773','210030',4073463,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','210246',4077177,'2144','331',3482168.13,3488966.43,0.00,0.00,6798.30,2437832.00,0.00,0.00,0.00),('1','140','773','210246',4077178,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','210360',4079146,'2144','331',3488966.43,3492146.68,0.00,0.00,3180.25,1143744.00,0.00,0.00,0.00),('1','140','773','210360',4079147,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','210602',4083662,'2144','331',3492146.68,3498721.18,0.00,0.00,6574.50,2308172.00,0.00,0.00,0.00),('1','140','773','210602',4083663,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','210855',4087984,'2144','331',3498721.18,3505716.38,0.00,0.00,6995.20,2464436.00,0.00,0.00,0.00),('1','140','773','210855',4087985,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','210938',4089550,'2144','331',3505716.38,3514196.88,0.00,0.00,8480.50,2996776.00,0.00,0.00,0.00),('1','140','773','210938',4089551,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','211349',4096943,'2144','331',3514196.88,3523325.38,0.00,0.00,9128.50,3201364.00,0.00,0.00,0.00),('1','140','773','211349',4096944,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','211368',4097264,'2144','331',3523325.38,3548035.88,0.00,0.00,24710.50,8765516.00,0.00,0.00,0.00),('1','140','773','211368',4097265,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','212836',4123120,'2144','331',3548035.88,3556078.88,0.00,0.00,8043.00,2931135.00,0.00,0.00,0.00),('1','140','773','212836',4123121,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','212880',4123739,'2144','331',3556078.88,3567289.38,0.00,0.00,11210.50,4066627.50,0.00,0.00,0.00),('1','140','773','212880',4123740,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','213134',4128165,'2144','331',3567289.38,3572563.38,0.00,0.00,5274.00,1913180.00,0.00,0.00,0.00),('1','140','773','213134',4128166,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','213277',4130440,'2144','331',3572563.38,3573261.88,0.00,0.00,698.50,260185.00,0.00,0.00,0.00),('1','140','773','213277',4130441,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','213391',4132378,'2144','331',3573261.88,3580041.86,0.00,0.00,6779.98,2467198.95,0.00,0.00,0.00),('1','140','773','213391',4132379,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','213624',4136364,'2144','331',3580041.86,3588299.87,0.00,0.00,8258.01,2993471.15,0.00,0.00,0.00),('1','140','773','213624',4136365,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','213875',4140497,'2144','331',3588299.87,3591165.37,0.00,0.00,2865.50,1051350.00,0.00,0.00,0.00),('1','140','773','213875',4140498,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','214085',4144047,'2144','331',3591165.37,3597189.87,0.00,0.00,6024.50,2178150.00,0.00,0.00,0.00),('1','140','773','214085',4144048,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','214220',4146220,'2144','331',3597189.87,3600160.17,0.00,0.00,2970.30,1083455.50,0.00,0.00,0.00),('1','140','773','214220',4146221,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','214379',4148956,'2144','331',3600160.17,3603588.22,0.00,0.00,3428.05,1253492.50,0.00,0.00,0.00),('1','140','773','214379',4148957,'2187','331',721.76,721.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','214523',4151538,'2144','331',3603588.22,3609866.54,0.00,0.00,6278.32,2284999.30,0.00,0.00,0.00),('1','140','773','214523',4151539,'2187','331',721.76,725.76,0.00,0.00,4.00,1600.00,0.00,0.00,0.00),('1','140','773','214771',4155837,'2144','331',3609866.54,3621437.96,0.00,0.00,11571.42,4202339.55,0.00,0.00,0.00),('1','140','773','214771',4155838,'2187','331',725.76,781.76,0.00,0.00,56.00,20650.00,0.00,0.00,0.00),('1','140','773','214993',4159505,'2144','331',3621437.96,3624140.76,0.00,0.00,2702.80,996700.00,0.00,0.00,0.00),('1','140','773','214993',4159506,'2187','331',781.76,781.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','215229',4163553,'2144','331',3624140.76,3633083.76,0.00,0.00,8943.00,3250992.50,0.00,0.00,0.00),('1','140','773','215229',4163554,'2187','331',781.76,781.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','215441',4167079,'2144','331',3633083.76,3645699.96,0.00,0.00,12616.20,4563669.25,0.00,0.00,0.00),('1','140','773','215441',4167080,'2187','331',781.76,989.76,0.00,0.00,208.00,75920.00,0.00,0.00,0.00),('1','140','773','215849',4174188,'2144','331',3645699.96,3655111.96,0.00,0.00,9412.00,3409670.00,0.00,0.00,0.00),('1','140','773','215849',4174189,'2187','331',989.76,989.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','216053',4177659,'2144','331',3655111.96,3658303.46,0.00,0.00,3191.50,1216994.00,0.00,0.00,0.00),('1','140','773','216053',4177660,'2187','331',989.76,989.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','216116',4178624,'2144','331',3658303.46,3663876.93,0.00,0.00,5573.47,2113601.40,0.00,0.00,0.00),('1','140','773','216116',4178625,'2187','331',989.76,1064.76,0.00,0.00,75.00,28500.00,0.00,0.00,0.00),('1','140','773','216339',4182440,'2144','331',3663876.93,3670329.09,0.00,0.00,6452.16,2441485.60,0.00,0.00,0.00),('1','140','773','216339',4182441,'2187','331',1064.76,1064.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','216482',4185095,'2144','331',3670329.09,3679386.68,0.00,0.00,9057.59,3428807.30,0.00,0.00,0.00),('1','140','773','216482',4185096,'2187','331',1064.76,1064.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','216597',4186818,'2144','331',3679386.68,3684592.39,0.00,0.00,5205.71,1998403.20,0.00,0.00,0.00),('1','140','773','216597',4186819,'2187','331',1064.76,1064.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','216878',4191915,'2144','331',3684592.39,3692778.67,0.00,0.00,8186.28,3131027.60,0.00,0.00,0.00),('1','140','773','216878',4191916,'2187','331',1064.76,1064.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','217111',4196015,'2144','331',3692778.67,3695099.67,0.00,0.00,2321.00,888420.00,0.00,0.00,0.00),('1','140','773','217111',4196016,'2187','331',1064.76,1064.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','217357',4200608,'2144','331',3695099.67,3695099.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','217357',4200609,'2187','331',1064.76,1064.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','217358',4200610,'2144','331',3695099.67,3696037.57,0.00,0.00,937.90,393503.50,0.00,0.00,0.00),('1','140','773','217358',4200611,'2187','331',1064.76,1064.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','217363',4200674,'2144','331',3696037.57,3699383.76,0.00,0.00,3346.19,1395752.40,0.00,0.00,0.00),('1','140','773','217363',4200675,'2187','331',1064.76,1064.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','217542',4203740,'2144','331',3699383.76,3703331.02,0.00,0.00,3947.26,1635499.60,0.00,0.00,0.00),('1','140','773','217542',4203741,'2187','331',1064.76,1064.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','217768',4207653,'2144','331',3703331.02,3707861.60,0.00,0.00,4530.58,1876299.30,0.00,0.00,0.00),('1','140','773','217768',4207654,'2187','331',1064.76,1064.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','218058',4212832,'2144','331',3707861.60,3718778.63,0.00,0.00,10917.03,4492898.80,0.00,0.00,0.00),('1','140','773','218058',4212833,'2187','331',1064.76,1064.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','218325',4217555,'2144','331',3718778.63,3719530.63,0.00,0.00,752.00,314157.50,0.00,0.00,0.00),('1','140','773','218325',4217556,'2187','331',1064.76,1064.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','218547',4221627,'2144','331',3719530.63,3719530.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','218547',4221628,'2187','331',1064.76,1064.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','218552',4221701,'2144','331',3719530.63,3721465.63,0.00,0.00,1935.00,803370.00,0.00,0.00,0.00),('1','140','773','218552',4221702,'2187','331',1064.76,1064.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','218556',4221779,'2144','331',3721465.63,3724979.04,0.00,0.00,3513.41,1459078.60,0.00,0.00,0.00),('1','140','773','218556',4221780,'2187','331',1064.76,1064.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','218765',4225345,'2144','331',3724979.04,3728027.35,0.00,0.00,3048.31,1265962.60,0.00,0.00,0.00),('1','140','773','218765',4225346,'2187','331',1064.76,1064.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','218961',4228745,'2144','331',3728027.35,3732461.32,0.00,0.00,4433.97,1842149.70,0.00,0.00,0.00),('1','140','773','218961',4228746,'2187','331',1064.76,1070.85,0.00,0.00,6.09,2801.40,0.00,0.00,0.00),('1','140','773','219170',4232229,'2144','331',3732461.32,3734825.09,0.00,0.00,2363.77,979614.20,0.00,0.00,0.00),('1','140','773','219170',4232230,'2187','331',1070.85,1070.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','219324',4235275,'2144','331',3734825.09,3744011.03,0.00,0.00,9185.94,3776979.90,0.00,0.00,0.00),('1','140','773','219324',4235276,'2187','331',1070.85,1125.85,0.00,0.00,55.00,22825.00,0.00,0.00,0.00),('1','140','773','219587',4239734,'2144','331',3744011.03,3749117.34,0.00,0.00,5106.31,2114657.60,0.00,0.00,0.00),('1','140','773','219587',4239735,'2187','331',1125.85,1125.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','219792',4243578,'2144','331',3749117.34,3755726.46,0.00,0.00,6609.12,2725157.70,0.00,0.00,0.00),('1','140','773','219792',4243579,'2187','331',1125.85,1125.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','220024',4247752,'2144','331',3755726.46,3758211.59,0.00,0.00,2485.13,1040437.30,0.00,0.00,0.00),('1','140','773','220024',4247753,'2187','331',1125.85,1245.85,0.00,0.00,120.00,49800.00,0.00,0.00,0.00),('1','140','773','220274',4251797,'2144','331',3758211.59,3768345.64,0.00,0.00,10134.05,4178465.50,0.00,0.00,0.00),('1','140','773','220274',4251798,'2187','331',1245.85,1245.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','220603',4257823,'2144','331',3768345.64,3773031.54,0.00,0.00,4685.90,1938876.50,0.00,0.00,0.00),('1','140','773','220603',4257824,'2187','331',1245.85,1245.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','221013',4265030,'2144','331',3773031.54,3774503.24,0.00,0.00,1471.70,617312.00,0.00,0.00,0.00),('1','140','773','221013',4265031,'2187','331',1245.85,1245.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','221018',4265100,'2144','331',3774503.24,3780479.81,0.00,0.00,5976.57,2469614.70,0.00,0.00,0.00),('1','140','773','221018',4265101,'2187','331',1245.85,1245.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','221166',4267627,'2144','331',3780479.81,3789872.04,0.00,0.00,9392.23,3862343.80,0.00,0.00,0.00),('1','140','773','221166',4267628,'2187','331',1245.85,1245.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','221548',4274783,'2144','331',3789872.04,3791796.15,0.00,0.00,1924.11,797620.60,0.00,0.00,0.00),('1','140','773','221548',4274784,'2187','331',1245.85,1245.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','221611',4276032,'2144','331',3791796.15,3798855.25,0.00,0.00,7059.10,2914901.00,0.00,0.00,0.00),('1','140','773','221611',4276033,'2187','331',1245.85,1304.85,0.00,0.00,59.00,24485.00,0.00,0.00,0.00),('1','140','773','221826',4279777,'2144','331',3798855.25,3801796.72,0.00,0.00,2941.47,1228661.20,0.00,0.00,0.00),('1','140','773','221826',4279778,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','222052',4283968,'2144','331',3801796.72,3806325.22,0.00,0.00,4528.50,1881129.50,0.00,0.00,0.00),('1','140','773','222052',4283969,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','222303',4287856,'2144','331',3806325.22,3810232.06,0.00,0.00,3906.84,1621073.90,0.00,0.00,0.00),('1','140','773','222303',4287857,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','222538',4291975,'2144','331',3810232.06,3814477.37,0.00,0.00,4245.31,1750712.60,0.00,0.00,0.00),('1','140','773','222538',4291976,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','222614',4293427,'2144','331',3814477.37,3815212.44,0.00,0.00,735.07,303327.20,0.00,0.00,0.00),('1','140','773','222614',4293428,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','223004',4300815,'2144','331',3815212.44,3820346.14,0.00,0.00,5133.70,2122727.00,0.00,0.00,0.00),('1','140','773','223004',4300816,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','223146',4303361,'2144','331',3820346.14,3834923.14,0.00,0.00,14577.00,6009892.50,0.00,0.00,0.00),('1','140','773','223146',4303362,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','223265',4304910,'2144','331',3834923.14,3839180.34,0.00,0.00,4257.20,1755542.00,0.00,0.00,0.00),('1','140','773','223265',4304911,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','223473',4308843,'2144','331',3839180.34,3845245.74,0.00,0.00,6065.40,2503924.00,0.00,0.00,0.00),('1','140','773','223473',4308844,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','223488',4309097,'2144','331',3845245.74,3854305.01,0.00,0.00,9059.27,3862253.20,0.00,0.00,0.00),('1','140','773','223488',4309098,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','223775',4314559,'2144','331',3854305.01,3863885.15,0.00,0.00,9580.14,4233070.40,0.00,0.00,0.00),('1','140','773','223775',4314560,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','223996',4318421,'2144','331',3863885.15,3867976.69,0.00,0.00,4091.54,1817173.20,0.00,0.00,0.00),('1','140','773','223996',4318422,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','224076',4319916,'2144','331',3867976.69,3882682.19,0.00,0.00,14705.50,6511000.24,0.00,0.00,0.00),('1','140','773','224076',4319917,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','224370',4324976,'2144','331',3882682.19,3888400.03,0.00,0.00,5717.84,2712829.40,0.00,0.00,0.00),('1','140','773','224370',4324977,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','224690',4330579,'2144','331',3888400.03,3890154.26,0.00,0.00,1754.23,838062.30,0.00,0.00,0.00),('1','140','773','224690',4330580,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','224771',4332211,'2144','331',3890154.26,3897155.70,0.00,0.00,7001.44,3319204.40,0.00,0.00,0.00),('1','140','773','224771',4332212,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','225012',4336507,'2144','331',3897155.70,3900896.73,0.00,0.00,3741.03,1778070.30,0.00,0.00,0.00),('1','140','773','225012',4336508,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','225258',4340984,'2144','331',3900896.73,3905791.16,0.00,0.00,4894.43,2255026.30,0.00,0.00,0.00),('1','140','773','225258',4340985,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','225548',4346167,'2144','331',3905791.16,3912846.96,0.00,0.00,7055.80,3183378.00,0.00,0.00,0.00),('1','140','773','225548',4346168,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','225823',4350843,'2144','331',3912846.96,3925438.85,0.00,0.00,12591.89,5723708.90,0.00,0.00,0.00),('1','140','773','225823',4350844,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','226067',4355019,'2144','331',3925438.85,3929596.34,0.00,0.00,4157.49,1969537.25,0.00,0.00,0.00),('1','140','773','226067',4355020,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','226317',4359709,'2144','331',3929596.34,3933550.58,0.00,0.00,3954.24,1853665.50,0.00,0.00,0.00),('1','140','773','226317',4359710,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','226479',4362576,'2144','331',3933550.58,3935495.93,0.00,0.00,1945.35,910998.50,0.00,0.00,0.00),('1','140','773','226479',4362577,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','226772',4367794,'2144','331',3935495.93,3937481.88,0.00,0.00,1985.95,924890.28,0.00,0.00,0.00),('1','140','773','226772',4367795,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','226898',4370308,'2144','331',3937481.88,3941079.04,0.00,0.00,3597.16,1666128.80,0.00,0.00,0.00),('1','140','773','226898',4370309,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','226991',4371692,'2144','331',3941079.04,3948155.86,0.00,0.00,7076.82,3284266.20,0.00,0.00,0.00),('1','140','773','226991',4371693,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','227221',4375647,'2144','331',3948155.86,3951011.74,0.00,0.00,2855.88,1328899.40,0.00,0.00,0.00),('1','140','773','227221',4375648,'2187','331',1304.85,1304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','227373',4378554,'2144','331',3951011.74,3962084.78,0.00,0.00,11073.04,5125617.40,0.00,0.00,0.00),('1','140','773','227373',4378555,'2187','331',1304.85,1310.93,0.00,0.00,6.08,3100.80,0.00,0.00,0.00),('1','140','773','227685',4383930,'2144','331',3962084.78,3967287.76,0.00,0.00,5202.98,2422182.30,0.00,0.00,0.00),('1','140','773','227685',4383931,'2187','331',1310.93,1310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','227885',4387450,'2144','331',3967287.76,3973534.50,0.00,0.00,6246.74,2952732.40,0.00,0.00,0.00),('1','140','773','227885',4387451,'2187','331',1310.93,1310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','228146',4392471,'2144','331',3973534.50,3981648.91,0.00,0.00,8114.41,3839114.10,0.00,0.00,0.00),('1','140','773','228146',4392472,'2187','331',1310.93,1310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','228409',4397559,'2144','331',3981648.91,3986000.37,0.00,0.00,4351.46,2107450.10,0.00,0.00,0.00),('1','140','773','228409',4397560,'2187','331',1310.93,1310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','228543',4399962,'2144','331',3986000.37,3986503.95,0.00,0.00,503.58,250047.40,0.00,0.00,0.00),('1','140','773','228543',4399963,'2187','331',1310.93,1310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','228657',4402245,'2144','331',3986503.95,3989006.86,0.00,0.00,2502.91,1239802.30,0.00,0.00,0.00),('1','140','773','228657',4402246,'2187','331',1310.93,1310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','228829',4405331,'2144','331',3989006.86,3990134.16,0.00,0.00,1127.30,563469.00,0.00,0.00,0.00),('1','140','773','228829',4405332,'2187','331',1310.93,1310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','229072',4410221,'2144','331',3990134.16,3994953.57,0.00,0.00,4819.41,2365606.10,0.00,0.00,0.00),('1','140','773','229072',4410222,'2187','331',1310.93,1310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','229170',4412009,'2144','331',3994953.57,4006917.18,0.00,0.00,11963.61,5858942.70,0.00,0.00,0.00),('1','140','773','229170',4412010,'2187','331',1310.93,1310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','229454',4416832,'2144','331',4006917.18,4011087.18,0.00,0.00,4170.00,2095613.50,0.00,0.00,0.00),('1','140','773','229454',4416833,'2187','331',1310.93,1310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','229665',4421208,'2144','331',4011087.18,4013198.94,0.00,0.00,2111.76,1091423.96,0.00,0.00,0.00),('1','140','773','229665',4421209,'2187','331',1310.93,1313.70,0.00,0.00,2.77,1551.20,0.00,0.00,0.00),('1','140','773','229874',4425550,'2144','331',4013198.94,4014787.92,0.00,0.00,1588.98,821944.80,0.00,0.00,0.00),('1','140','773','229874',4425551,'2187','331',1313.70,1313.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','230081',4429287,'2144','331',4014787.92,4019474.65,0.00,0.00,4686.73,2402315.62,0.00,0.00,0.00),('1','140','773','230081',4429288,'2187','331',1313.70,1313.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','230272',4432977,'2144','331',4019474.65,4022445.68,0.00,0.00,2971.03,1534738.27,0.00,0.00,0.00),('1','140','773','230272',4432978,'2187','331',1313.70,1313.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','230514',4437470,'2144','331',4022445.68,4028618.44,0.00,0.00,6172.76,3161759.60,0.00,0.00,0.00),('1','140','773','230514',4437471,'2187','331',1313.70,1313.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','230769',4442034,'2144','331',4028618.44,4031976.46,0.00,0.00,3358.02,1731730.17,0.00,0.00,0.00),('1','140','773','230769',4442035,'2187','331',1313.70,1313.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','231045',4446779,'2144','331',4031976.46,4035721.46,0.00,0.00,3745.00,1902460.00,0.00,0.00,0.00),('1','140','773','231045',4446780,'2187','331',1313.70,1313.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','231398',4452125,'2144','331',4035721.46,4038035.55,0.00,0.00,2314.09,1196690.40,0.00,0.00,0.00),('1','140','773','231398',4452126,'2187','331',1313.70,1313.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','231632',4456372,'2144','331',4038035.55,4041489.33,0.00,0.00,3453.78,1775056.40,0.00,0.00,0.00),('1','140','773','231632',4456373,'2187','331',1313.70,1313.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','231876',4460903,'2144','331',4041489.33,4046998.57,0.00,0.00,5509.24,2818828.90,0.00,0.00,0.00),('1','140','773','231876',4460904,'2187','331',1313.70,1313.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','232133',4465299,'2144','331',4046998.57,4056204.71,0.00,0.00,9206.14,4695058.60,0.00,0.00,0.00),('1','140','773','232133',4465300,'2187','331',1313.70,1363.70,0.00,0.00,50.00,25650.00,0.00,0.00,0.00),('1','140','773','232378',4469574,'2144','331',4056204.71,4064214.25,0.00,0.00,8009.54,4095522.40,0.00,0.00,0.00),('1','140','773','232378',4469575,'2187','331',1363.70,1363.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','232624',4474089,'2144','331',4064214.25,4071024.88,0.00,0.00,6810.63,3490009.51,0.00,0.00,0.00),('1','140','773','232624',4474090,'2187','331',1363.70,1366.74,0.00,0.00,3.04,1702.40,0.00,0.00,0.00),('1','140','773','232825',4478033,'2144','331',4071024.88,4080806.10,0.00,0.00,9781.22,4992937.30,0.00,0.00,0.00),('1','140','773','232825',4478034,'2187','331',1366.74,1366.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','233116',4483043,'2144','331',4080806.10,4089353.33,0.00,0.00,8547.23,4396869.00,0.00,0.00,0.00),('1','140','773','233116',4483044,'2187','331',1366.74,1366.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','233427',4488531,'2144','331',4089353.33,4091342.62,0.00,0.00,1989.29,1110863.00,0.00,0.00,0.00),('1','140','773','233427',4488532,'2187','331',1366.74,1368.41,0.00,0.00,1.67,1002.00,0.00,0.00,0.00),('1','140','773','233608',4492049,'2144','331',4091342.62,4094457.13,0.00,0.00,3114.51,1723861.00,0.00,0.00,0.00),('1','140','773','233608',4492050,'2187','331',1368.41,1368.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','233846',4496277,'2144','331',4094457.13,4095956.12,0.00,0.00,1498.99,832694.00,0.00,0.00,0.00),('1','140','773','233846',4496278,'2187','331',1368.41,1373.08,0.00,0.00,4.67,2802.00,0.00,0.00,0.00),('1','140','773','234040',4499762,'2144','331',4095956.12,4098536.18,0.00,0.00,2580.06,1425936.00,0.00,0.00,0.00),('1','140','773','234040',4499763,'2187','331',1373.08,1373.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','234291',4504505,'2144','331',4098536.18,4105093.01,0.00,0.00,6556.83,3591504.00,0.00,0.00,0.00),('1','140','773','234291',4504506,'2187','331',1373.08,1373.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','234598',4509699,'2144','331',4105093.01,4107016.28,0.00,0.00,1923.27,1068443.00,0.00,0.00,0.00),('1','140','773','234598',4509700,'2187','331',1373.08,1373.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','234803',4513607,'2144','331',4107016.28,4112428.78,0.00,0.00,5412.50,2974496.00,0.00,0.00,0.00),('1','140','773','234803',4513608,'2187','331',1373.08,1373.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','235133',4519266,'2144','331',4112428.78,4117979.76,0.00,0.00,5550.98,3052328.00,0.00,0.00,0.00),('1','140','773','235133',4519267,'2187','331',1373.08,1373.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','235290',4522005,'2144','331',4117979.76,4124516.59,0.00,0.00,6536.83,3596893.00,0.00,0.00,0.00),('1','140','773','235290',4522006,'2187','331',1373.08,1373.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','235577',4526901,'2144','331',4124516.59,4129545.76,0.00,0.00,5029.17,2751134.00,0.00,0.00,0.00),('1','140','773','235577',4526902,'2187','331',1373.08,1373.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','235845',4531797,'2144','331',4129545.76,4136767.53,0.00,0.00,7221.77,3964553.00,0.00,0.00,0.00),('1','140','773','235845',4531798,'2187','331',1373.08,1373.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','236025',4534751,'2144','331',4136767.53,4141369.54,0.00,0.00,4602.01,2554163.64,0.00,0.00,0.00),('1','140','773','236025',4534752,'2187','331',1373.08,1373.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','236259',4538910,'2144','331',4141369.54,4147740.98,0.00,0.00,6371.44,3538152.00,0.00,0.00,0.00),('1','140','773','236259',4538911,'2187','331',1373.08,1373.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','236530',4543725,'2144','331',4147740.98,4151788.92,0.00,0.00,4047.94,2279446.80,0.00,0.00,0.00),('1','140','773','236530',4543726,'2187','331',1373.08,1373.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','236733',4547156,'2144','331',4151788.92,4154181.92,0.00,0.00,2393.00,1354080.00,0.00,0.00,0.00),('1','140','773','236733',4547157,'2187','331',1373.08,1373.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','236879',4549820,'2144','331',4154181.92,4158350.52,0.00,0.00,4168.60,2383760.00,0.00,0.00,0.00),('1','140','773','236879',4549821,'2187','331',1373.08,1373.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','236952',4551114,'2144','331',4158350.52,4166146.83,0.00,0.00,7796.31,4507100.20,0.00,0.00,0.00),('1','140','773','236952',4551115,'2187','331',1373.08,1373.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','237226',4555837,'2144','331',4166146.83,4169406.19,0.00,0.00,3259.36,1897727.20,0.00,0.00,0.00),('1','140','773','237226',4555838,'2187','331',1373.08,1373.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','237365',4558646,'2144','331',4169406.19,4178915.93,0.00,0.00,9509.74,5501432.40,0.00,0.00,0.00),('1','140','773','237365',4558647,'2187','331',1373.08,1373.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','237617',4562924,'2144','331',4178915.93,4183141.25,0.00,0.00,4225.32,2460576.40,0.00,0.00,0.00),('1','140','773','237617',4562925,'2187','331',1373.08,1423.08,0.00,0.00,50.00,29100.00,0.00,0.00,0.00),('1','140','773','237863',4567056,'2144','331',4183141.25,4187623.62,0.00,0.00,4482.37,2602961.22,0.00,0.00,0.00),('1','140','773','237863',4567057,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','238180',4572121,'2144','331',4187623.62,4190494.21,0.00,0.00,2870.59,1676602.80,0.00,0.00,0.00),('1','140','773','238180',4572122,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','238335',4575122,'2144','331',4190494.21,4195600.16,0.00,0.00,5105.95,2965901.40,0.00,0.00,0.00),('1','140','773','238335',4575123,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','238597',4579328,'2144','331',4195600.16,4199819.42,0.00,0.00,4219.26,2451118.40,0.00,0.00,0.00),('1','140','773','238597',4579329,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','238949',4585583,'2144','331',4199819.42,4203474.62,0.00,0.00,3655.20,2112348.00,0.00,0.00,0.00),('1','140','773','238949',4585584,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','239349',4592438,'2144','331',4203474.62,4211094.21,0.00,0.00,7619.59,4460371.10,0.00,0.00,0.00),('1','140','773','239349',4592439,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','239590',4596605,'2144','331',4211094.21,4217145.31,0.00,0.00,6051.10,3565700.40,0.00,0.00,0.00),('1','140','773','239590',4596606,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','239770',4599709,'2144','331',4217145.31,4220075.94,0.00,0.00,2930.63,1730582.40,0.00,0.00,0.00),('1','140','773','239770',4599710,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','239951',4603051,'2144','331',4220075.94,4220075.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','239951',4603052,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','239995',4603593,'2144','331',4220075.94,4228114.08,0.00,0.00,8038.14,4721983.80,0.00,0.00,0.00),('1','140','773','239995',4603594,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','240197',4607175,'2144','331',4228114.08,4232925.70,0.00,0.00,4811.62,2840266.20,0.00,0.00,0.00),('1','140','773','240197',4607176,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','240532',4612653,'2144','331',4232925.70,4235211.06,0.00,0.00,2285.36,1351044.20,0.00,0.00,0.00),('1','140','773','240532',4612654,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','240750',4615895,'2144','331',4235211.06,4237931.32,0.00,0.00,2720.26,1610078.20,0.00,0.00,0.00),('1','140','773','240750',4615896,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','241017',4620682,'2144','331',4237931.32,4240905.02,0.00,0.00,2973.70,1754418.40,0.00,0.00,0.00),('1','140','773','241017',4620683,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','241268',4625147,'2144','331',4240905.02,4244252.39,0.00,0.00,3347.37,1972307.00,0.00,0.00,0.00),('1','140','773','241268',4625148,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','241505',4629191,'2144','331',4244252.39,4252014.39,0.00,0.00,7762.00,4552554.00,0.00,0.00,0.00),('1','140','773','241505',4629192,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','241846',4635041,'2144','331',4252014.39,4254467.49,0.00,0.00,2453.10,1452648.00,0.00,0.00,0.00),('1','140','773','241846',4635042,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','241989',4637601,'2144','331',4254467.49,4257367.44,0.00,0.00,2899.95,1712330.00,0.00,0.00,0.00),('1','140','773','241989',4637602,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','242247',4642139,'2144','331',4257367.44,4260517.15,0.00,0.00,3149.71,1856477.00,0.00,0.00,0.00),('1','140','773','242247',4642140,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','242410',4645288,'2144','331',4260517.15,4262158.21,0.00,0.00,1641.06,967339.20,0.00,0.00,0.00),('1','140','773','242410',4645289,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','242693',4650016,'2144','331',4262158.21,4265118.41,0.00,0.00,2960.20,1719780.00,0.00,0.00,0.00),('1','140','773','242693',4650017,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','242920',4653829,'2144','331',4265118.41,4268116.01,0.00,0.00,2997.60,1740004.00,0.00,0.00,0.00),('1','140','773','242920',4653830,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','243141',4657743,'2144','331',4268116.01,4276722.81,0.00,0.00,8606.80,4935755.60,0.00,0.00,0.00),('1','140','773','243141',4657744,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','243370',4661886,'2144','331',4276722.81,4276722.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','243370',4661887,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','243377',4661973,'2144','331',4276722.81,4280488.98,0.00,0.00,3766.17,2182807.40,0.00,0.00,0.00),('1','140','773','243377',4661974,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','243595',4665723,'2144','331',4280488.98,4283327.98,0.00,0.00,2839.00,1652040.96,0.00,0.00,0.00),('1','140','773','243595',4665724,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','243893',4670953,'2144','331',4283327.98,4285861.35,0.00,0.00,2533.37,1470105.40,0.00,0.00,0.00),('1','140','773','243893',4670954,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','244049',4673640,'2144','331',4285861.35,4291806.00,0.00,0.00,5944.65,3421671.00,0.00,0.00,0.00),('1','140','773','244049',4673641,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','244274',4677489,'2144','331',4291806.00,4294573.59,0.00,0.00,2767.59,1601603.80,0.00,0.00,0.00),('1','140','773','244274',4677490,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','244541',4682003,'2144','331',4294573.59,4301288.44,0.00,0.00,6714.85,3857583.00,0.00,0.00,0.00),('1','140','773','244541',4682004,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','244721',4685247,'2144','331',4301288.44,4303357.85,0.00,0.00,2069.41,1206860.20,0.00,0.00,0.00),('1','140','773','244721',4685248,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','245009',4689979,'2144','331',4303357.85,4306826.95,0.00,0.00,3469.10,1957002.00,0.00,0.00,0.00),('1','140','773','245009',4689980,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','245220',4693869,'2144','331',4306826.95,4313154.36,0.00,0.00,6327.41,3555602.20,0.00,0.00,0.00),('1','140','773','245220',4693870,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','245480',4698298,'2144','331',4313154.36,4315910.82,0.00,0.00,2756.46,1549497.20,0.00,0.00,0.00),('1','140','773','245480',4698299,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','245669',4701786,'2144','331',4315910.82,4319162.12,0.00,0.00,3251.30,1827572.00,0.00,0.00,0.00),('1','140','773','245669',4701787,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','245928',4705759,'2144','331',4319162.12,4325795.62,0.00,0.00,6633.50,3634472.00,0.00,0.00,0.00),('1','140','773','245928',4705760,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','246185',4710033,'2144','331',4325795.62,4331377.29,0.00,0.00,5581.67,3070600.00,0.00,0.00,0.00),('1','140','773','246185',4710034,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','246482',4714953,'2144','331',4331377.29,4334086.50,0.00,0.00,2709.21,1500751.00,0.00,0.00,0.00),('1','140','773','246482',4714954,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','246697',4718731,'2144','331',4334086.50,4336593.24,0.00,0.00,2506.74,1388807.00,0.00,0.00,0.00),('1','140','773','246697',4718732,'2187','331',1423.08,1423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','246934',4723029,'2144','331',4336593.24,4341190.64,0.00,0.00,4597.40,2534974.50,0.00,0.00,0.00),('1','140','773','246934',4723030,'2187','331',1423.08,1424.08,0.00,0.00,1.00,600.00,0.00,0.00,0.00),('1','140','773','247196',4727236,'2144','331',4341190.64,4343476.14,0.00,0.00,2285.50,1260807.00,0.00,0.00,0.00),('1','140','773','247196',4727237,'2187','331',1424.08,1424.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','247377',4730833,'2144','331',4343476.14,4350297.44,0.00,0.00,6821.30,3629286.00,0.00,0.00,0.00),('1','140','773','247377',4730834,'2187','331',1424.08,1424.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','247668',4735538,'2144','331',4350297.44,4353543.28,0.00,0.00,3245.84,1742161.00,0.00,0.00,0.00),('1','140','773','247668',4735539,'2187','331',1424.08,1424.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','247885',4739435,'2144','331',4353543.28,4358519.08,0.00,0.00,4975.80,2655238.80,0.00,0.00,0.00),('1','140','773','247885',4739436,'2187','331',1424.08,1424.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','248154',4743800,'2144','331',4358519.08,4362526.07,0.00,0.00,4006.99,2141536.00,0.00,0.00,0.00),('1','140','773','248154',4743801,'2187','331',1424.08,1424.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','248385',4747834,'2144','331',4362526.07,4369473.99,0.00,0.00,6947.92,3707321.60,0.00,0.00,0.00),('1','140','773','248385',4747835,'2187','331',1424.08,1426.08,0.00,0.00,2.00,1200.00,0.00,0.00,0.00),('1','140','773','248653',4752060,'2144','331',4369473.99,4374706.35,0.00,0.00,5232.36,2767597.40,0.00,0.00,0.00),('1','140','773','248653',4752061,'2187','331',1426.08,1426.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','248936',4756869,'2144','331',4374706.35,4377324.75,0.00,0.00,2618.40,1369680.00,0.00,0.00,0.00),('1','140','773','248936',4756870,'2187','331',1426.08,1426.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','249105',4759841,'2144','331',4377324.75,4379295.25,0.00,0.00,1970.50,1048980.00,0.00,0.00,0.00),('1','140','773','249105',4759842,'2187','331',1426.08,1426.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','249371',4764237,'2144','331',4379295.25,4382452.59,0.00,0.00,3157.34,1663212.00,0.00,0.00,0.00),('1','140','773','249371',4764238,'2187','331',1426.08,1427.08,0.00,0.00,1.00,600.00,0.00,0.00,0.00),('1','140','773','249606',4768250,'2144','331',4382452.59,4386539.60,0.00,0.00,4087.01,2134392.00,0.00,0.00,0.00),('1','140','773','249606',4768251,'2187','331',1427.08,1427.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','249858',4772541,'2144','331',4386539.60,4390299.33,0.00,0.00,3759.73,1973150.00,0.00,0.00,0.00),('1','140','773','249858',4772542,'2187','331',1427.08,1427.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','250095',4776529,'2144','331',4390299.33,4394647.83,0.00,0.00,4348.50,2273148.00,0.00,0.00,0.00),('1','140','773','250095',4776530,'2187','331',1427.08,1427.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','250337',4780670,'2144','331',4394647.83,4399189.23,0.00,0.00,4541.40,2322600.00,0.00,0.00,0.00),('1','140','773','250337',4780671,'2187','331',1427.08,1427.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','250389',4781331,'2144','331',4399189.23,4403488.32,0.00,0.00,4299.09,2191742.00,0.00,0.00,0.00),('1','140','773','250389',4781332,'2187','331',1427.08,1427.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','250627',4785298,'2144','331',4403488.32,4408109.59,0.00,0.00,4621.27,2339652.00,0.00,0.00,0.00),('1','140','773','250627',4785299,'2187','331',1427.08,1427.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','250787',4788350,'2144','331',4408109.59,4414574.76,0.00,0.00,6465.17,3277734.00,0.00,0.00,0.00),('1','140','773','250787',4788351,'2187','331',1427.08,1429.08,0.00,0.00,2.00,1200.00,0.00,0.00,0.00),('1','140','773','251022',4792506,'2144','331',4414574.76,4418588.60,0.00,0.00,4013.84,2044646.00,0.00,0.00,0.00),('1','140','773','251022',4792507,'2187','331',1429.08,1429.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','251273',4796812,'2144','331',4418588.60,4423242.73,0.00,0.00,4654.13,2349380.60,0.00,0.00,0.00),('1','140','773','251273',4796813,'2187','331',1429.08,1431.08,0.00,0.00,2.00,1200.00,0.00,0.00,0.00),('1','140','773','251523',4801013,'2144','331',4423242.73,4426366.25,0.00,0.00,3123.52,1601033.00,0.00,0.00,0.00),('1','140','773','251523',4801014,'2187','331',1431.08,1431.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','251768',4805409,'2144','331',4426366.25,4430948.59,0.00,0.00,4582.34,2333962.00,0.00,0.00,0.00),('1','140','773','251768',4805410,'2187','331',1431.08,1431.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','251988',4809322,'2144','331',4430948.59,4434315.42,0.00,0.00,3366.83,1737056.00,0.00,0.00,0.00),('1','140','773','251988',4809323,'2187','331',1431.08,1431.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','252248',4813667,'2144','331',4434315.42,4438648.59,0.00,0.00,4333.17,2206619.00,0.00,0.00,0.00),('1','140','773','252248',4813668,'2187','331',1431.08,1432.08,0.00,0.00,1.00,600.00,0.00,0.00,0.00),('1','140','773','252475',4817935,'2144','331',4438648.59,4447666.09,0.00,0.00,9017.50,4545418.00,0.00,0.00,0.00),('1','140','773','252475',4817936,'2187','331',1432.08,1432.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','252714',4822003,'2144','331',4447666.09,4450749.92,0.00,0.00,3083.83,1583565.00,0.00,0.00,0.00),('1','140','773','252714',4822004,'2187','331',1432.08,1492.08,0.00,0.00,60.00,30360.00,0.00,0.00,0.00),('1','140','773','252961',4826058,'2144','331',4450749.92,4453806.76,0.00,0.00,3056.84,1577398.00,0.00,0.00,0.00),('1','140','773','252961',4826059,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','253213',4830278,'2144','331',4453806.76,4455857.61,0.00,0.00,2050.85,1060168.00,0.00,0.00,0.00),('1','140','773','253213',4830279,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','253455',4834579,'2144','331',4455857.61,4460341.11,0.00,0.00,4483.50,2282486.00,0.00,0.00,0.00),('1','140','773','253455',4834580,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','253700',4838651,'2144','331',4460341.11,4470975.28,0.00,0.00,10634.17,5381294.00,0.00,0.00,0.00),('1','140','773','253700',4838652,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','253952',4843048,'2144','331',4470975.28,4471725.25,0.00,0.00,749.97,383774.74,0.00,0.00,0.00),('1','140','773','253952',4843049,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','254500',4852426,'2144','331',4471725.25,4475257.58,0.00,0.00,3532.33,1822358.00,0.00,0.00,0.00),('1','140','773','254500',4852427,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','254680',4855934,'2144','331',4475257.58,4475259.58,0.00,0.00,2.00,1200.00,0.00,0.00,0.00),('1','140','773','254680',4855935,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','254729',4856400,'2144','331',4475259.58,4475259.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','254729',4856401,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','254738',4856547,'2144','331',4475259.58,4475259.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','254738',4856548,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','254742',4856582,'2144','331',4475259.58,4475259.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','254742',4856583,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','254745',4856599,'2144','331',4475259.58,4475259.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','254745',4856600,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','254748',4856623,'2144','331',4475259.58,4475259.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','254748',4856624,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','254750',4856659,'2144','331',4475259.58,4475259.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','254750',4856660,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','254753',4856701,'2144','331',4475259.58,4478865.81,0.00,0.00,3606.23,1850085.38,0.00,0.00,0.00),('1','140','773','254753',4856702,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','254935',4860204,'2144','331',4478865.81,4483452.58,0.00,0.00,4586.77,2334966.00,0.00,0.00,0.00),('1','140','773','254935',4860205,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','255185',4864473,'2144','331',4483452.58,4492068.09,0.00,0.00,8615.51,4362654.00,0.00,0.00,0.00),('1','140','773','255185',4864474,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','255459',4869111,'2144','331',4492068.09,4495927.74,0.00,0.00,3859.65,1974619.80,0.00,0.00,0.00),('1','140','773','255459',4869112,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','255763',4873912,'2144','331',4495927.74,4495927.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','255763',4873913,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','255871',4875799,'2144','331',4495927.74,4497922.58,0.00,0.00,1994.84,1019897.00,0.00,0.00,0.00),('1','140','773','255871',4875800,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','255942',4876986,'2144','331',4497922.58,4501886.94,0.00,0.00,3964.36,2030701.20,0.00,0.00,0.00),('1','140','773','255942',4876987,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','256200',4881160,'2144','331',4501886.94,4507222.81,0.00,0.00,5335.87,2707318.00,0.00,0.00,0.00),('1','140','773','256200',4881161,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','256484',4885965,'2144','331',4507222.81,4510336.69,0.00,0.00,3113.88,1599614.00,0.00,0.00,0.00),('1','140','773','256484',4885966,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','256726',4889970,'2144','331',4510336.69,4513248.96,0.00,0.00,2912.27,1482457.00,0.00,0.00,0.00),('1','140','773','256726',4889971,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','256963',4894126,'2144','331',4513248.96,4515707.12,0.00,0.00,2458.16,1267018.00,0.00,0.00,0.00),('1','140','773','256963',4894127,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257228',4899015,'2144','331',4515707.12,4518165.02,0.00,0.00,2457.90,1257312.00,0.00,0.00,0.00),('1','140','773','257228',4899016,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257532',4904003,'2144','331',4518165.02,4520385.02,0.00,0.00,2220.00,1098790.00,0.00,0.00,0.00),('1','140','773','257532',4904004,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257541',4904181,'2144','331',4520385.02,4520385.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257541',4904182,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257544',4904210,'2144','331',4520385.02,4525026.82,0.00,0.00,4641.80,2286794.00,0.00,0.00,0.00),('1','140','773','257544',4904211,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257545',4904212,'2144','331',4525026.82,4527961.00,0.00,0.00,2934.18,1465108.00,0.00,0.00,0.00),('1','140','773','257545',4904213,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257546',4904214,'2144','331',4527961.00,4531771.00,0.00,0.00,3810.00,1886706.00,0.00,0.00,0.00),('1','140','773','257546',4904215,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257547',4904216,'2144','331',4531771.00,4534801.94,0.00,0.00,3030.94,1500369.00,0.00,0.00,0.00),('1','140','773','257547',4904217,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257548',4904218,'2144','331',4534801.94,4537775.96,0.00,0.00,2974.02,1468675.00,0.00,0.00,0.00),('1','140','773','257548',4904219,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257549',4904220,'2144','331',4537775.96,4544680.91,0.00,0.00,6904.95,3368260.50,0.00,0.00,0.00),('1','140','773','257549',4904221,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257550',4904222,'2144','331',4544680.91,4544680.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257550',4904223,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257551',4904224,'2144','331',4544680.91,4544951.97,0.00,0.00,271.06,147998.76,0.00,0.00,0.00),('1','140','773','257551',4904225,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257552',4904226,'2144','331',4544951.97,4551337.40,0.00,0.00,6385.43,3141526.50,0.00,0.00,0.00),('1','140','773','257552',4904227,'2187','331',1492.08,1492.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257553',4904228,'2144','331',4551337.40,4554801.84,0.00,0.00,3464.44,1704502.00,0.00,0.00,0.00),('1','140','773','257553',4904229,'2187','331',1492.08,1558.59,0.00,0.00,66.51,36580.50,0.00,0.00,0.00),('1','140','773','257554',4904230,'2144','331',4554801.84,4558982.25,0.00,0.00,4180.41,2059023.90,0.00,0.00,0.00),('1','140','773','257554',4904231,'2187','331',1558.59,1558.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257555',4904232,'2144','331',4558982.25,4561784.67,0.00,0.00,2802.42,1382431.00,0.00,0.00,0.00),('1','140','773','257555',4904233,'2187','331',1558.59,1558.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257556',4904234,'2144','331',4561784.67,4565782.27,0.00,0.00,3997.60,1968910.00,0.00,0.00,0.00),('1','140','773','257556',4904235,'2187','331',1558.59,1558.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257557',4904236,'2144','331',4565782.27,4569293.77,0.00,0.00,3511.50,1715397.00,0.00,0.00,0.00),('1','140','773','257557',4904237,'2187','331',1558.59,1558.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257558',4904238,'2144','331',4569293.77,4569293.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257558',4904239,'2187','331',1558.59,1558.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257559',4904240,'2144','331',4569293.77,4569293.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257559',4904241,'2187','331',1558.59,1558.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257560',4904242,'2144','331',4569293.77,4572542.47,0.00,0.00,3248.70,1602053.00,0.00,0.00,0.00),('1','140','773','257560',4904243,'2187','331',1558.59,1558.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257561',4904244,'2144','331',4572542.47,4576515.97,0.00,0.00,3973.50,1954065.00,0.00,0.00,0.00),('1','140','773','257561',4904245,'2187','331',1558.59,1558.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257562',4904246,'2144','331',4576515.97,4585332.52,0.00,0.00,8816.55,4323682.50,0.00,0.00,0.00),('1','140','773','257562',4904247,'2187','331',1558.59,1878.59,0.00,0.00,320.00,156800.00,0.00,0.00,0.00),('1','140','773','257563',4904248,'2144','331',4585332.52,4587454.82,0.00,0.00,2122.30,1058545.00,0.00,0.00,0.00),('1','140','773','257563',4904249,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257564',4904250,'2144','331',4587454.82,4593161.32,0.00,0.00,5706.50,2810135.00,0.00,0.00,0.00),('1','140','773','257564',4904251,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257565',4904252,'2144','331',4593161.32,4593417.43,0.00,0.00,256.11,127576.50,0.00,0.00,0.00),('1','140','773','257565',4904253,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257566',4904254,'2144','331',4593417.43,4593417.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257566',4904255,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257567',4904256,'2144','331',4593417.43,4596015.69,0.00,0.00,2598.26,1319793.00,0.00,0.00,0.00),('1','140','773','257567',4904257,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257568',4904258,'2144','331',4596015.69,4599358.86,0.00,0.00,3343.17,1686593.50,0.00,0.00,0.00),('1','140','773','257568',4904259,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257569',4904260,'2144','331',4599358.86,4601117.91,0.00,0.00,1759.05,887952.50,0.00,0.00,0.00),('1','140','773','257569',4904261,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257570',4904262,'2144','331',4601117.91,4604108.23,0.00,0.00,2990.32,1507926.00,0.00,0.00,0.00),('1','140','773','257570',4904263,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257571',4904264,'2144','331',4604108.23,4610347.41,0.00,0.00,6239.18,3120199.00,0.00,0.00,0.00),('1','140','773','257571',4904265,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257572',4904266,'2144','331',4610347.41,4615723.05,0.00,0.00,5375.64,2686114.00,0.00,0.00,0.00),('1','140','773','257572',4904267,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257573',4904268,'2144','331',4615723.05,4617723.14,0.00,0.00,2000.09,1006699.50,0.00,0.00,0.00),('1','140','773','257573',4904269,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257574',4904270,'2144','331',4617723.14,4617723.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257574',4904271,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257575',4904272,'2144','331',4617723.14,4618366.58,0.00,0.00,643.44,335976.00,0.00,0.00,0.00),('1','140','773','257575',4904273,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257576',4904274,'2144','331',4618366.58,4621199.40,0.00,0.00,2832.82,1457631.00,0.00,0.00,0.00),('1','140','773','257576',4904275,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257577',4904276,'2144','331',4621199.40,4622926.95,0.00,0.00,1727.55,889592.50,0.00,0.00,0.00),('1','140','773','257577',4904277,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257578',4904278,'2144','331',4622926.95,4625884.59,0.00,0.00,2957.64,1521062.00,0.00,0.00,0.00),('1','140','773','257578',4904279,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257579',4904280,'2144','331',4625884.59,4627555.68,0.00,0.00,1671.09,863659.50,0.00,0.00,0.00),('1','140','773','257579',4904281,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257580',4904282,'2144','331',4627555.68,4630419.27,0.00,0.00,2863.59,1465800.90,0.00,0.00,0.00),('1','140','773','257580',4904283,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257581',4904284,'2144','331',4630419.27,4634676.97,0.00,0.00,4257.70,2176123.00,0.00,0.00,0.00),('1','140','773','257581',4904285,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257582',4904286,'2144','331',4634676.97,4636012.47,0.00,0.00,1335.50,689505.00,0.00,0.00,0.00),('1','140','773','257582',4904287,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257583',4904288,'2144','331',4636012.47,4641054.35,0.00,0.00,5041.88,2591834.00,0.00,0.00,0.00),('1','140','773','257583',4904289,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257584',4904290,'2144','331',4641054.35,4641963.99,0.00,0.00,909.64,469142.00,0.00,0.00,0.00),('1','140','773','257584',4904291,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257585',4904292,'2144','331',4641963.99,4641963.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257585',4904293,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257586',4904294,'2144','331',4641963.99,4642713.18,0.00,0.00,749.19,439179.80,0.00,0.00,0.00),('1','140','773','257586',4904295,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257587',4904296,'2144','331',4642713.18,4643890.07,0.00,0.00,1176.89,695751.80,0.00,0.00,0.00),('1','140','773','257587',4904297,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257588',4904298,'2144','331',4643890.07,4644683.67,0.00,0.00,793.60,476792.00,0.00,0.00,0.00),('1','140','773','257588',4904299,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257589',4904300,'2144','331',4644683.67,4645172.81,0.00,0.00,489.14,288466.80,0.00,0.00,0.00),('1','140','773','257589',4904301,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257590',4904302,'2144','331',4645172.81,4645605.18,0.00,0.00,432.37,263029.40,0.00,0.00,0.00),('1','140','773','257590',4904303,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257591',4904304,'2144','331',4645605.18,4646176.37,0.00,0.00,571.19,341737.80,0.00,0.00,0.00),('1','140','773','257591',4904305,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257592',4904306,'2144','331',4646176.37,4646890.40,0.00,0.00,714.03,422148.60,0.00,0.00,0.00),('1','140','773','257592',4904307,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257593',4904308,'2144','331',4646890.40,4647931.39,0.00,0.00,1040.99,610038.80,0.00,0.00,0.00),('1','140','773','257593',4904309,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257594',4904310,'2144','331',4647931.39,4648716.87,0.00,0.00,785.48,462882.60,0.00,0.00,0.00),('1','140','773','257594',4904311,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257595',4904312,'2144','331',4648716.87,4649428.50,0.00,0.00,711.63,423760.60,0.00,0.00,0.00),('1','140','773','257595',4904313,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257596',4904314,'2144','331',4649428.50,4649785.70,0.00,0.00,357.20,212714.00,0.00,0.00,0.00),('1','140','773','257596',4904315,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257597',4904316,'2144','331',4649785.70,4650886.13,0.00,0.00,1100.43,641618.60,0.00,0.00,0.00),('1','140','773','257597',4904317,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257598',4904318,'2144','331',4650886.13,4652172.68,0.00,0.00,1286.55,745961.00,0.00,0.00,0.00),('1','140','773','257598',4904319,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257599',4904320,'2144','331',4652172.68,4652798.10,0.00,0.00,625.42,369660.40,0.00,0.00,0.00),('1','140','773','257599',4904321,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257600',4904322,'2144','331',4652798.10,4654207.98,0.00,0.00,1409.88,818718.10,0.00,0.00,0.00),('1','140','773','257600',4904323,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257601',4904324,'2144','331',4654207.98,4655943.50,0.00,0.00,1735.52,1000639.90,0.00,0.00,0.00),('1','140','773','257601',4904325,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257602',4904326,'2144','331',4655943.50,4658039.98,0.00,0.00,2096.48,1210137.60,0.00,0.00,0.00),('1','140','773','257602',4904327,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257603',4904328,'2144','331',4658039.98,4658715.67,0.00,0.00,675.69,391827.80,0.00,0.00,0.00),('1','140','773','257603',4904329,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257604',4904330,'2144','331',4658715.67,4660272.90,0.00,0.00,1557.23,903225.10,0.00,0.00,0.00),('1','140','773','257604',4904331,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257605',4904332,'2144','331',4660272.90,4661303.85,0.00,0.00,1030.95,602906.50,0.00,0.00,0.00),('1','140','773','257605',4904333,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257606',4904334,'2144','331',4661303.85,4662324.15,0.00,0.00,1020.30,595286.00,0.00,0.00,0.00),('1','140','773','257606',4904335,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257607',4904336,'2144','331',4662324.15,4664331.08,0.00,0.00,2006.93,1163021.60,0.00,0.00,0.00),('1','140','773','257607',4904337,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257608',4904338,'2144','331',4664331.08,4666487.11,0.00,0.00,2156.03,1240723.60,0.00,0.00,0.00),('1','140','773','257608',4904339,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257609',4904340,'2144','331',4666487.11,4666487.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257609',4904341,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257610',4904342,'2144','331',4666487.11,4667199.14,0.00,0.00,712.03,466090.40,0.00,0.00,0.00),('1','140','773','257610',4904343,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257611',4904344,'2144','331',4667199.14,4669326.46,0.00,0.00,2127.32,1391227.60,0.00,0.00,0.00),('1','140','773','257611',4904345,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257612',4904346,'2144','331',4669326.46,4671913.59,0.00,0.00,2587.13,1689528.40,0.00,0.00,0.00),('1','140','773','257612',4904347,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257613',4904348,'2144','331',4671913.59,4673040.93,0.00,0.00,1127.34,740521.20,0.00,0.00,0.00),('1','140','773','257613',4904349,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257614',4904350,'2144','331',4673040.93,4674622.95,0.00,0.00,1582.02,1036503.60,0.00,0.00,0.00),('1','140','773','257614',4904351,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257615',4904352,'2144','331',4674622.95,4675890.84,0.00,0.00,1267.89,832585.20,0.00,0.00,0.00),('1','140','773','257615',4904353,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257616',4904354,'2144','331',4675890.84,4676228.04,0.00,0.00,337.20,223716.00,0.00,0.00,0.00),('1','140','773','257616',4904355,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257617',4904356,'2144','331',4676228.04,4682380.83,0.00,0.00,6152.79,3946937.20,0.00,0.00,0.00),('1','140','773','257617',4904357,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257618',4904358,'2144','331',4682380.83,4683757.93,0.00,0.00,1377.10,889388.00,0.00,0.00,0.00),('1','140','773','257618',4904359,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257619',4904360,'2144','331',4683757.93,4685013.06,0.00,0.00,1255.13,815048.40,0.00,0.00,0.00),('1','140','773','257619',4904361,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257620',4904362,'2144','331',4685013.06,4687718.02,0.00,0.00,2704.96,1742532.80,0.00,0.00,0.00),('1','140','773','257620',4904363,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257621',4904364,'2144','331',4687718.02,4689875.70,0.00,0.00,2157.68,1395762.40,0.00,0.00,0.00),('1','140','773','257621',4904365,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257622',4904366,'2144','331',4689875.70,4690756.28,0.00,0.00,880.58,575618.00,0.00,0.00,0.00),('1','140','773','257622',4904367,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257623',4904368,'2144','331',4690756.28,4690796.48,0.00,0.00,40.20,25728.00,0.00,0.00,0.00),('1','140','773','257623',4904369,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257624',4904370,'2144','331',4690796.48,4690796.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257624',4904371,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257625',4904372,'2144','331',4690796.48,4692379.04,0.00,0.00,1582.56,1016672.80,0.00,0.00,0.00),('1','140','773','257625',4904373,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257626',4904374,'2144','331',4692379.04,4694619.07,0.00,0.00,2240.03,1450060.40,0.00,0.00,0.00),('1','140','773','257626',4904375,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257627',4904376,'2144','331',4694619.07,4697551.85,0.00,0.00,2932.78,1891570.40,0.00,0.00,0.00),('1','140','773','257627',4904377,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257628',4904378,'2144','331',4697551.85,4703974.59,0.00,0.00,6422.74,4122543.20,0.00,0.00,0.00),('1','140','773','257628',4904379,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257629',4904380,'2144','331',4703974.59,4706384.71,0.00,0.00,2410.12,1547141.60,0.00,0.00,0.00),('1','140','773','257629',4904381,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257630',4904382,'2144','331',4706384.71,4710495.36,0.00,0.00,4110.65,2685426.00,0.00,0.00,0.00),('1','140','773','257630',4904383,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257631',4904384,'2144','331',4710495.36,4715379.47,0.00,0.00,4884.11,3188432.80,0.00,0.00,0.00),('1','140','773','257631',4904385,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257632',4904386,'2144','331',4715379.47,4715379.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257632',4904387,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257633',4904388,'2144','331',4715379.47,4716685.83,0.00,0.00,1306.36,857804.80,0.00,0.00,0.00),('1','140','773','257633',4904389,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257634',4904390,'2144','331',4716685.83,4717949.11,0.00,0.00,1263.28,832626.40,0.00,0.00,0.00),('1','140','773','257634',4904391,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257635',4904392,'2144','331',4717949.11,4721069.61,0.00,0.00,3120.50,2043568.00,0.00,0.00,0.00),('1','140','773','257635',4904393,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257636',4904394,'2144','331',4721069.61,4722755.22,0.00,0.00,1685.61,1108218.80,0.00,0.00,0.00),('1','140','773','257636',4904395,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257637',4904396,'2144','331',4722755.22,4724662.30,0.00,0.00,1907.08,1255514.40,0.00,0.00,0.00),('1','140','773','257637',4904397,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257638',4904398,'2144','331',4724662.30,4725077.67,0.00,0.00,415.37,276487.60,0.00,0.00,0.00),('1','140','773','257638',4904399,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257639',4904400,'2144','331',4725077.67,4726447.82,0.00,0.00,1370.15,904318.00,0.00,0.00,0.00),('1','140','773','257639',4904401,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257640',4904402,'2144','331',4726447.82,4728943.15,0.00,0.00,2495.33,1639312.40,0.00,0.00,0.00),('1','140','773','257640',4904403,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257641',4904404,'2144','331',4728943.15,4731230.38,0.00,0.00,2287.23,1501612.40,0.00,0.00,0.00),('1','140','773','257641',4904405,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257642',4904406,'2144','331',4731230.38,4733081.62,0.00,0.00,1851.24,1214183.20,0.00,0.00,0.00),('1','140','773','257642',4904407,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257643',4904408,'2144','331',4733081.62,4739106.04,0.00,0.00,6024.42,3937985.60,0.00,0.00,0.00),('1','140','773','257643',4904409,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257644',4904410,'2144','331',4739106.04,4740028.72,0.00,0.00,922.68,607038.40,0.00,0.00,0.00),('1','140','773','257644',4904411,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257645',4904412,'2144','331',4740028.72,4740028.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257645',4904413,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257646',4904414,'2144','331',4740028.72,4740126.12,0.00,0.00,97.40,66232.00,0.00,0.00,0.00),('1','140','773','257646',4904415,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257647',4904416,'2144','331',4740126.12,4743070.08,0.00,0.00,2943.96,1925816.80,0.00,0.00,0.00),('1','140','773','257647',4904417,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257648',4904418,'2144','331',4743070.08,4744365.09,0.00,0.00,1295.01,855574.80,0.00,0.00,0.00),('1','140','773','257648',4904419,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257649',4904420,'2144','331',4744365.09,4746891.39,0.00,0.00,2526.30,1657964.00,0.00,0.00,0.00),('1','140','773','257649',4904421,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257650',4904422,'2144','331',4746891.39,4748376.60,0.00,0.00,1485.21,977630.80,0.00,0.00,0.00),('1','140','773','257650',4904423,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257651',4904424,'2144','331',4748376.60,4749645.51,0.00,0.00,1268.91,835642.80,0.00,0.00,0.00),('1','140','773','257651',4904425,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257652',4904426,'2144','331',4749645.51,4750972.38,0.00,0.00,1326.87,872283.60,0.00,0.00,0.00),('1','140','773','257652',4904427,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257653',4904428,'2144','331',4750972.38,4752737.49,0.00,0.00,1765.11,1166086.80,0.00,0.00,0.00),('1','140','773','257653',4904429,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257654',4904430,'2144','331',4752737.49,4754123.44,0.00,0.00,1385.95,911044.00,0.00,0.00,0.00),('1','140','773','257654',4904431,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257655',4904432,'2144','331',4754123.44,4756000.43,0.00,0.00,1876.99,1222977.20,0.00,0.00,0.00),('1','140','773','257655',4904433,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257656',4904434,'2144','331',4756000.43,4762728.07,0.00,0.00,6727.64,4325015.20,0.00,0.00,0.00),('1','140','773','257656',4904435,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257657',4904436,'2144','331',4762728.07,4764586.07,0.00,0.00,1858.00,1199828.00,0.00,0.00,0.00),('1','140','773','257657',4904437,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257658',4904438,'2144','331',4764586.07,4764586.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257658',4904439,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257659',4904440,'2144','331',4764586.07,4766064.73,0.00,0.00,1478.66,962940.80,0.00,0.00,0.00),('1','140','773','257659',4904441,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257660',4904442,'2144','331',4766064.73,4768493.23,0.00,0.00,2428.50,1567604.00,0.00,0.00,0.00),('1','140','773','257660',4904443,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257661',4904444,'2144','331',4768493.23,4770679.48,0.00,0.00,2186.25,1415766.00,0.00,0.00,0.00),('1','140','773','257661',4904445,'2187','331',1878.59,1878.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257662',4904446,'2144','331',4770679.48,4772347.62,0.00,0.00,1668.14,1077443.20,0.00,0.00,0.00),('1','140','773','257662',4904447,'2187','331',1878.59,1883.00,0.00,0.00,4.41,2998.80,0.00,0.00,0.00),('1','140','773','257663',4904448,'2144','331',4772347.62,4774906.74,0.00,0.00,2559.12,1647229.60,0.00,0.00,0.00),('1','140','773','257663',4904449,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257664',4904450,'2144','331',4774906.74,4776514.88,0.00,0.00,1608.14,1038161.20,0.00,0.00,0.00),('1','140','773','257664',4904451,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257665',4904452,'2144','331',4776514.88,4781626.38,0.00,0.00,5111.50,3270868.00,0.00,0.00,0.00),('1','140','773','257665',4904453,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257666',4904454,'2144','331',4781626.38,4785594.19,0.00,0.00,3967.81,2545980.80,0.00,0.00,0.00),('1','140','773','257666',4904455,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257667',4904456,'2144','331',4785594.19,4789142.89,0.00,0.00,3548.70,2275858.00,0.00,0.00,0.00),('1','140','773','257667',4904457,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257668',4904458,'2144','331',4789142.89,4789142.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257668',4904459,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257669',4904460,'2144','331',4789142.89,4791489.37,0.00,0.00,2346.48,1513062.40,0.00,0.00,0.00),('1','140','773','257669',4904461,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257670',4904462,'2144','331',4791489.37,4795224.25,0.00,0.00,3734.88,2383902.40,0.00,0.00,0.00),('1','140','773','257670',4904463,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257671',4904464,'2144','331',4795224.25,4797082.64,0.00,0.00,1858.39,1203733.20,0.00,0.00,0.00),('1','140','773','257671',4904465,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257672',4904466,'2144','331',4797082.64,4799007.34,0.00,0.00,1924.70,1243368.00,0.00,0.00,0.00),('1','140','773','257672',4904467,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257673',4904468,'2144','331',4799007.34,4801265.70,0.00,0.00,2258.36,1458336.80,0.00,0.00,0.00),('1','140','773','257673',4904469,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257674',4904470,'2144','331',4801265.70,4803717.81,0.00,0.00,2452.11,1574363.80,0.00,0.00,0.00),('1','140','773','257674',4904471,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257675',4904472,'2144','331',4803717.81,4806880.87,0.00,0.00,3163.06,2010355.80,0.00,0.00,0.00),('1','140','773','257675',4904473,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257676',4904474,'2144','331',4806880.87,4810198.98,0.00,0.00,3318.11,2104239.80,0.00,0.00,0.00),('1','140','773','257676',4904475,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257677',4904476,'2144','331',4810198.98,4811344.34,0.00,0.00,1145.36,732864.80,0.00,0.00,0.00),('1','140','773','257677',4904477,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257678',4904478,'2144','331',4811344.34,4813595.85,0.00,0.00,2251.51,1430706.80,0.00,0.00,0.00),('1','140','773','257678',4904479,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257679',4904480,'2144','331',4813595.85,4813595.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257679',4904481,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257680',4904482,'2144','331',4813595.85,4818614.04,0.00,0.00,5018.19,3158874.20,0.00,0.00,0.00),('1','140','773','257680',4904483,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257681',4904484,'2144','331',4818614.04,4822123.29,0.00,0.00,3509.25,2214140.00,0.00,0.00,0.00),('1','140','773','257681',4904485,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257682',4904486,'2144','331',4822123.29,4823193.58,0.00,0.00,1070.29,693587.20,0.00,0.00,0.00),('1','140','773','257682',4904487,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257683',4904488,'2144','331',4823193.58,4825497.58,0.00,0.00,2304.00,1465190.00,0.00,0.00,0.00),('1','140','773','257683',4904489,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257684',4904490,'2144','331',4825497.58,4828030.55,0.00,0.00,2532.97,1614619.60,0.00,0.00,0.00),('1','140','773','257684',4904491,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257685',4904492,'2144','331',4828030.55,4829890.09,0.00,0.00,1859.54,1181932.20,0.00,0.00,0.00),('1','140','773','257685',4904493,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257686',4904494,'2144','331',4829890.09,4831259.11,0.00,0.00,1369.02,883798.60,0.00,0.00,0.00),('1','140','773','257686',4904495,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257687',4904496,'2144','331',4831259.11,4833001.85,0.00,0.00,1742.74,1121648.20,0.00,0.00,0.00),('1','140','773','257687',4904497,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257688',4904498,'2144','331',4833001.85,4836252.87,0.00,0.00,3251.02,2056143.60,0.00,0.00,0.00),('1','140','773','257688',4904499,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257689',4904500,'2144','331',4836252.87,4837936.00,0.00,0.00,1683.13,1080123.40,0.00,0.00,0.00),('1','140','773','257689',4904501,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257690',4904502,'2144','331',4837936.00,4837936.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257690',4904503,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257691',4904504,'2144','331',4837936.00,4838108.72,0.00,0.00,172.72,115954.60,0.00,0.00,0.00),('1','140','773','257691',4904505,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257692',4904506,'2144','331',4838108.72,4841576.67,0.00,0.00,3467.95,2180918.50,0.00,0.00,0.00),('1','140','773','257692',4904507,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257693',4904508,'2144','331',4841576.67,4843212.64,0.00,0.00,1635.97,1035499.60,0.00,0.00,0.00),('1','140','773','257693',4904509,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257694',4904510,'2144','331',4843212.64,4845679.20,0.00,0.00,2466.56,1553045.80,0.00,0.00,0.00),('1','140','773','257694',4904511,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257695',4904512,'2144','331',4845679.20,4848370.11,0.00,0.00,2690.91,1682788.80,0.00,0.00,0.00),('1','140','773','257695',4904513,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257696',4904514,'2144','331',4848370.11,4851439.54,0.00,0.00,3069.43,1922404.90,0.00,0.00,0.00),('1','140','773','257696',4904515,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257697',4904516,'2144','331',4851439.54,4851686.91,0.00,0.00,247.37,152806.60,0.00,0.00,0.00),('1','140','773','257697',4904517,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257698',4904518,'2144','331',4851686.91,4851686.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257698',4904519,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257699',4904520,'2144','331',4851686.91,4852050.23,0.00,0.00,363.32,233082.60,0.00,0.00,0.00),('1','140','773','257699',4904521,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257700',4904522,'2144','331',4852050.23,4856408.58,0.00,0.00,4358.35,2724120.50,0.00,0.00,0.00),('1','140','773','257700',4904523,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257701',4904524,'2144','331',4856408.58,4860888.55,0.00,0.00,4479.97,2778449.60,0.00,0.00,0.00),('1','140','773','257701',4904525,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257702',4904526,'2144','331',4860888.55,4865101.27,0.00,0.00,4212.72,2621809.60,0.00,0.00,0.00),('1','140','773','257702',4904527,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257703',4904528,'2144','331',4865101.27,4871372.68,0.00,0.00,6271.41,3881286.30,0.00,0.00,0.00),('1','140','773','257703',4904529,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257704',4904530,'2144','331',4871372.68,4874245.62,0.00,0.00,2872.94,1799419.20,0.00,0.00,0.00),('1','140','773','257704',4904531,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257705',4904532,'2144','331',4874245.62,4876361.14,0.00,0.00,2115.52,1316061.10,0.00,0.00,0.00),('1','140','773','257705',4904533,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257706',4904534,'2144','331',4876361.14,4876361.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257706',4904535,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257707',4904536,'2144','331',4876361.14,4879457.86,0.00,0.00,3096.72,1938524.60,0.00,0.00,0.00),('1','140','773','257707',4904537,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257708',4904538,'2144','331',4879457.86,4883394.39,0.00,0.00,3936.53,2458635.40,0.00,0.00,0.00),('1','140','773','257708',4904539,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257709',4904540,'2144','331',4883394.39,4887655.73,0.00,0.00,4261.34,2644081.20,0.00,0.00,0.00),('1','140','773','257709',4904541,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257710',4904542,'2144','331',4887655.73,4893724.97,0.00,0.00,6069.24,3764025.70,0.00,0.00,0.00),('1','140','773','257710',4904543,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257711',4904544,'2144','331',4893724.97,4901042.23,0.00,0.00,7317.26,4527431.80,0.00,0.00,0.00),('1','140','773','257711',4904545,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257712',4904546,'2144','331',4901042.23,4901042.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257712',4904547,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257713',4904548,'2144','331',4901042.23,4905224.73,0.00,0.00,4182.50,2671232.50,0.00,0.00,0.00),('1','140','773','257713',4904549,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257714',4904550,'2144','331',4905224.73,4911676.36,0.00,0.00,6451.63,4117288.40,0.00,0.00,0.00),('1','140','773','257714',4904551,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257715',4904552,'2144','331',4911676.36,4917867.85,0.00,0.00,6191.49,3952228.20,0.00,0.00,0.00),('1','140','773','257715',4904553,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257716',4904554,'2144','331',4917867.85,4925438.43,0.00,0.00,7570.58,4827864.40,0.00,0.00,0.00),('1','140','773','257716',4904555,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257717',4904556,'2144','331',4925438.43,4925746.73,0.00,0.00,308.30,196684.00,0.00,0.00,0.00),('1','140','773','257717',4904557,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257718',4904558,'2144','331',4925746.73,4925746.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257718',4904559,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257719',4904560,'2144','331',4925746.73,4931014.94,0.00,0.00,5268.21,3361140.30,0.00,0.00,0.00),('1','140','773','257719',4904561,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257720',4904562,'2144','331',4931014.94,4940563.58,0.00,0.00,9548.64,6097300.20,0.00,0.00,0.00),('1','140','773','257720',4904563,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257721',4904564,'2144','331',4940563.58,4950467.16,0.00,0.00,9903.58,6301511.90,0.00,0.00,0.00),('1','140','773','257721',4904565,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257722',4904566,'2144','331',4950467.16,4950467.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257722',4904567,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257723',4904568,'2144','331',4950467.16,4956632.52,0.00,0.00,6165.36,3966124.80,0.00,0.00,0.00),('1','140','773','257723',4904569,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257724',4904570,'2144','331',4956632.52,4967263.93,0.00,0.00,10631.41,6827318.80,0.00,0.00,0.00),('1','140','773','257724',4904571,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257725',4904572,'2144','331',4967263.93,4972990.38,0.00,0.00,5726.45,3686106.00,0.00,0.00,0.00),('1','140','773','257725',4904573,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257726',4904574,'2144','331',4972990.38,4974627.34,0.00,0.00,1636.96,1051380.80,0.00,0.00,0.00),('1','140','773','257726',4904575,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257727',4904576,'2144','331',4974627.34,4974642.34,0.00,0.00,15.00,9600.00,0.00,0.00,0.00),('1','140','773','257727',4904577,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257728',4904578,'2144','331',4974642.34,4974642.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257728',4904579,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257729',4904580,'2144','331',4974642.34,4982285.04,0.00,0.00,7642.70,4913236.00,0.00,0.00,0.00),('1','140','773','257729',4904581,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257730',4904582,'2144','331',4982285.04,4990663.32,0.00,0.00,8378.28,5385670.40,0.00,0.00,0.00),('1','140','773','257730',4904583,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257731',4904584,'2144','331',4990663.32,4995927.09,0.00,0.00,5263.77,3383483.60,0.00,0.00,0.00),('1','140','773','257731',4904585,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257732',4904586,'2144','331',4995927.09,4999106.62,0.00,0.00,3179.53,2041620.40,0.00,0.00,0.00),('1','140','773','257732',4904587,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257733',4904588,'2144','331',4999106.62,4999106.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257733',4904589,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257734',4904590,'2144','331',4999106.62,5005063.22,0.00,0.00,5956.60,3826608.00,0.00,0.00,0.00),('1','140','773','257734',4904591,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257735',4904592,'2144','331',5005063.22,5011103.10,0.00,0.00,6039.88,3884218.40,0.00,0.00,0.00),('1','140','773','257735',4904593,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257736',4904594,'2144','331',5011103.10,5016341.56,0.00,0.00,5238.46,3372752.80,0.00,0.00,0.00),('1','140','773','257736',4904595,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257737',4904596,'2144','331',5016341.56,5022504.10,0.00,0.00,6162.54,3958127.20,0.00,0.00,0.00),('1','140','773','257737',4904597,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257738',4904598,'2144','331',5022504.10,5023831.66,0.00,0.00,1327.56,852960.80,0.00,0.00,0.00),('1','140','773','257738',4904599,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257739',4904600,'2144','331',5023831.66,5023831.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257739',4904601,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257740',4904602,'2144','331',5023831.66,5027606.24,0.00,0.00,3774.58,2471581.00,0.00,0.00,0.00),('1','140','773','257740',4904603,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257741',4904604,'2144','331',5027606.24,5033841.88,0.00,0.00,6235.64,4073998.00,0.00,0.00,0.00),('1','140','773','257741',4904605,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257742',4904606,'2144','331',5033841.88,5037512.45,0.00,0.00,3670.57,2409599.00,0.00,0.00,0.00),('1','140','773','257742',4904607,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257743',4904608,'2144','331',5037512.45,5040825.74,0.00,0.00,3313.29,2169228.00,0.00,0.00,0.00),('1','140','773','257743',4904609,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257744',4904610,'2144','331',5040825.74,5045828.84,0.00,0.00,5003.10,3279770.00,0.00,0.00,0.00),('1','140','773','257744',4904611,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257745',4904612,'2144','331',5045828.84,5048282.54,0.00,0.00,2453.70,1605598.50,0.00,0.00,0.00),('1','140','773','257745',4904613,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257746',4904614,'2144','331',5048282.54,5048282.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257746',4904615,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257747',4904616,'2144','331',5048282.54,5049754.49,0.00,0.00,1471.95,967715.00,0.00,0.00,0.00),('1','140','773','257747',4904617,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257748',4904618,'2144','331',5049754.49,5054538.52,0.00,0.00,4784.03,3122121.00,0.00,0.00,0.00),('1','140','773','257748',4904619,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257749',4904620,'2144','331',5054538.52,5057006.75,0.00,0.00,2468.23,1623061.00,0.00,0.00,0.00),('1','140','773','257749',4904621,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257750',4904622,'2144','331',5057006.75,5058839.96,0.00,0.00,1833.21,1208522.00,0.00,0.00,0.00),('1','140','773','257750',4904623,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257751',4904624,'2144','331',5058839.96,5061096.18,0.00,0.00,2256.22,1466004.00,0.00,0.00,0.00),('1','140','773','257751',4904625,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257752',4904626,'2144','331',5061096.18,5063931.02,0.00,0.00,2834.84,1833170.00,0.00,0.00,0.00),('1','140','773','257752',4904627,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257753',4904628,'2144','331',5063931.02,5066611.74,0.00,0.00,2680.72,1747792.00,0.00,0.00,0.00),('1','140','773','257753',4904629,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257754',4904630,'2144','331',5066611.74,5068907.26,0.00,0.00,2295.52,1481004.00,0.00,0.00,0.00),('1','140','773','257754',4904631,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257755',4904632,'2144','331',5068907.26,5072763.34,0.00,0.00,3856.08,2471964.00,0.00,0.00,0.00),('1','140','773','257755',4904633,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257756',4904634,'2144','331',5072763.34,5072763.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257756',4904635,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257757',4904636,'2144','331',5072763.34,5076462.14,0.00,0.00,3698.80,2386916.00,0.00,0.00,0.00),('1','140','773','257757',4904637,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257758',4904638,'2144','331',5076462.14,5080107.70,0.00,0.00,3645.56,2347478.00,0.00,0.00,0.00),('1','140','773','257758',4904639,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257759',4904640,'2144','331',5080107.70,5083082.79,0.00,0.00,2975.09,1931779.00,0.00,0.00,0.00),('1','140','773','257759',4904641,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257760',4904642,'2144','331',5083082.79,5087212.70,0.00,0.00,4129.91,2658933.00,0.00,0.00,0.00),('1','140','773','257760',4904643,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257761',4904644,'2144','331',5087212.70,5090056.06,0.00,0.00,2843.36,1849550.00,0.00,0.00,0.00),('1','140','773','257761',4904645,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257762',4904646,'2144','331',5090056.06,5093691.37,0.00,0.00,3635.31,2344085.00,0.00,0.00,0.00),('1','140','773','257762',4904647,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257763',4904648,'2144','331',5093691.37,5097182.77,0.00,0.00,3491.40,2248642.80,0.00,0.00,0.00),('1','140','773','257763',4904649,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257764',4904650,'2144','331',5097182.77,5097222.67,0.00,0.00,39.90,25456.20,0.00,0.00,0.00),('1','140','773','257764',4904651,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257765',4904652,'2144','331',5097222.67,5097222.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257765',4904653,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257766',4904654,'2144','331',5097222.67,5103449.02,0.00,0.00,6226.35,3992738.00,0.00,0.00,0.00),('1','140','773','257766',4904655,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257767',4904656,'2144','331',5103449.02,5108116.03,0.00,0.00,4667.01,3002787.00,0.00,0.00,0.00),('1','140','773','257767',4904657,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257768',4904658,'2144','331',5108116.03,5110950.39,0.00,0.00,2834.36,1833578.00,0.00,0.00,0.00),('1','140','773','257768',4904659,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257769',4904660,'2144','331',5110950.39,5114745.04,0.00,0.00,3794.65,2436899.00,0.00,0.00,0.00),('1','140','773','257769',4904661,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257770',4904662,'2144','331',5114745.04,5119380.86,0.00,0.00,4635.82,2991742.00,0.00,0.00,0.00),('1','140','773','257770',4904663,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257771',4904664,'2144','331',5119380.86,5121901.20,0.00,0.00,2520.34,1618389.20,0.00,0.00,0.00),('1','140','773','257771',4904665,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257772',4904666,'2144','331',5121901.20,5121901.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257772',4904667,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257773',4904668,'2144','331',5121901.20,5130091.22,0.00,0.00,8190.02,5255242.00,0.00,0.00,0.00),('1','140','773','257773',4904669,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257774',4904670,'2144','331',5130091.22,5140786.43,0.00,0.00,10695.21,6847529.30,0.00,0.00,0.00),('1','140','773','257774',4904671,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257775',4904672,'2144','331',5140786.43,5145895.08,0.00,0.00,5108.65,3272856.40,0.00,0.00,0.00),('1','140','773','257775',4904673,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257776',4904674,'2144','331',5145895.08,5145895.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257776',4904675,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257777',4904676,'2144','331',5145895.08,5148705.27,0.00,0.00,2810.19,1812411.00,0.00,0.00,0.00),('1','140','773','257777',4904677,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257778',4904678,'2144','331',5148705.27,5159446.85,0.00,0.00,10741.58,6897536.00,0.00,0.00,0.00),('1','140','773','257778',4904679,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257779',4904680,'2144','331',5159446.85,5170525.85,0.00,0.00,11079.00,7113330.00,0.00,0.00,0.00),('1','140','773','257779',4904681,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257780',4904682,'2144','331',5170525.85,5170525.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257780',4904683,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257781',4904684,'2144','331',5170525.85,5175557.22,0.00,0.00,5031.37,3252919.00,0.00,0.00,0.00),('1','140','773','257781',4904685,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257782',4904686,'2144','331',5175557.22,5182612.36,0.00,0.00,7055.14,4545538.00,0.00,0.00,0.00),('1','140','773','257782',4904687,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257783',4904688,'2144','331',5182612.36,5188319.07,0.00,0.00,5706.71,3681677.00,0.00,0.00,0.00),('1','140','773','257783',4904689,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257784',4904690,'2144','331',5188319.07,5195196.24,0.00,0.00,6877.17,4431399.00,0.00,0.00,0.00),('1','140','773','257784',4904691,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257785',4904692,'2144','331',5195196.24,5195196.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257785',4904693,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257786',4904694,'2144','331',5195196.24,5205937.88,0.00,0.00,10741.64,6934148.00,0.00,0.00,0.00),('1','140','773','257786',4904695,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257787',4904696,'2144','331',5205937.88,5213153.82,0.00,0.00,7215.94,4643668.00,0.00,0.00,0.00),('1','140','773','257787',4904697,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257788',4904698,'2144','331',5213153.82,5218832.42,0.00,0.00,5678.60,3649970.00,0.00,0.00,0.00),('1','140','773','257788',4904699,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257789',4904700,'2144','331',5218832.42,5219746.14,0.00,0.00,913.72,591184.00,0.00,0.00,0.00),('1','140','773','257789',4904701,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257790',4904702,'2144','331',5219746.14,5219746.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257790',4904703,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257791',4904704,'2144','331',5219746.14,5225253.35,0.00,0.00,5507.21,3554867.00,0.00,0.00,0.00),('1','140','773','257791',4904705,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257792',4904706,'2144','331',5225253.35,5229695.01,0.00,0.00,4441.66,2871412.00,0.00,0.00,0.00),('1','140','773','257792',4904707,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257793',4904708,'2144','331',5229695.01,5238708.65,0.00,0.00,9013.64,5796398.00,0.00,0.00,0.00),('1','140','773','257793',4904709,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257794',4904710,'2144','331',5238708.65,5244259.60,0.00,0.00,5550.95,3582665.00,0.00,0.00,0.00),('1','140','773','257794',4904711,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257795',4904712,'2144','331',5244259.60,5244259.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257795',4904713,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257796',4904714,'2144','331',5244259.60,5251592.11,0.00,0.00,7332.51,4714077.00,0.00,0.00,0.00),('1','140','773','257796',4904715,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257797',4904716,'2144','331',5251592.11,5262852.88,0.00,0.00,11260.77,7239159.00,0.00,0.00,0.00),('1','140','773','257797',4904717,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257798',4904718,'2144','331',5262852.88,5268756.83,0.00,0.00,5903.95,3788017.00,0.00,0.00,0.00),('1','140','773','257798',4904719,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257799',4904720,'2144','331',5268756.83,5268756.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257799',4904721,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257800',4904722,'2144','331',5268756.83,5274473.01,0.00,0.00,5716.18,3687286.00,0.00,0.00,0.00),('1','140','773','257800',4904723,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257801',4904724,'2144','331',5274473.01,5280371.11,0.00,0.00,5898.10,3800410.00,0.00,0.00,0.00),('1','140','773','257801',4904725,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257802',4904726,'2144','331',5280371.11,5289764.84,0.00,0.00,9393.73,6045421.00,0.00,0.00,0.00),('1','140','773','257802',4904727,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257803',4904728,'2144','331',5289764.84,5292903.06,0.00,0.00,3138.22,2026834.00,0.00,0.00,0.00),('1','140','773','257803',4904729,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257804',4904730,'2144','331',5292903.06,5292903.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257804',4904731,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257805',4904732,'2144','331',5292903.06,5298282.57,0.00,0.00,5379.51,3468297.00,0.00,0.00,0.00),('1','140','773','257805',4904733,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257806',4904734,'2144','331',5298282.57,5302090.23,0.00,0.00,3807.66,2456562.00,0.00,0.00,0.00),('1','140','773','257806',4904735,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257807',4904736,'2144','331',5302090.23,5306722.96,0.00,0.00,4632.73,2991691.00,0.00,0.00,0.00),('1','140','773','257807',4904737,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257808',4904738,'2144','331',5306722.96,5310436.26,0.00,0.00,3713.30,2400650.00,0.00,0.00,0.00),('1','140','773','257808',4904739,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257809',4904740,'2144','331',5310436.26,5316325.69,0.00,0.00,5889.43,3803701.00,0.00,0.00,0.00),('1','140','773','257809',4904741,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257810',4904742,'2144','331',5316325.69,5317383.39,0.00,0.00,1057.70,688910.00,0.00,0.00,0.00),('1','140','773','257810',4904743,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257811',4904744,'2144','331',5317383.39,5317383.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257811',4904745,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257812',4904746,'2144','331',5317383.39,5321226.96,0.00,0.00,3843.57,2483079.00,0.00,0.00,0.00),('1','140','773','257812',4904747,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257813',4904748,'2144','331',5321226.96,5324228.83,0.00,0.00,3001.87,1943149.00,0.00,0.00,0.00),('1','140','773','257813',4904749,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257814',4904750,'2144','331',5324228.83,5327227.77,0.00,0.00,2998.94,1939598.00,0.00,0.00,0.00),('1','140','773','257814',4904751,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257815',4904752,'2144','331',5327227.77,5331398.77,0.00,0.00,4171.00,2643568.00,0.00,0.00,0.00),('1','140','773','257815',4904753,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257816',4904754,'2144','331',5331398.77,5336792.60,0.00,0.00,5393.83,3406244.40,0.00,0.00,0.00),('1','140','773','257816',4904755,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257817',4904756,'2144','331',5336792.60,5341446.22,0.00,0.00,4653.62,2949545.60,0.00,0.00,0.00),('1','140','773','257817',4904757,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257818',4904758,'2144','331',5341446.22,5341685.81,0.00,0.00,239.59,151975.20,0.00,0.00,0.00),('1','140','773','257818',4904759,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257819',4904760,'2144','331',5341685.81,5341685.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257819',4904761,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257820',4904762,'2144','331',5341685.81,5344662.29,0.00,0.00,2976.48,1869926.40,0.00,0.00,0.00),('1','140','773','257820',4904763,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257821',4904764,'2144','331',5344662.29,5348549.39,0.00,0.00,3887.10,2429388.00,0.00,0.00,0.00),('1','140','773','257821',4904765,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257822',4904766,'2144','331',5348549.39,5355960.01,0.00,0.00,7410.62,4621681.60,0.00,0.00,0.00),('1','140','773','257822',4904767,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257823',4904768,'2144','331',5355960.01,5361758.19,0.00,0.00,5798.18,3622032.40,0.00,0.00,0.00),('1','140','773','257823',4904769,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257824',4904770,'2144','331',5361758.19,5365620.67,0.00,0.00,3862.48,2422426.40,0.00,0.00,0.00),('1','140','773','257824',4904771,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257825',4904772,'2144','331',5365620.67,5366277.75,0.00,0.00,657.08,411774.40,0.00,0.00,0.00),('1','140','773','257825',4904773,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257826',4904774,'2144','331',5366277.75,5366277.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257826',4904775,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257827',4904776,'2144','331',5366277.75,5369847.08,0.00,0.00,3569.33,2234604.40,0.00,0.00,0.00),('1','140','773','257827',4904777,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257828',4904778,'2144','331',5369847.08,5375934.35,0.00,0.00,6087.27,3823503.60,0.00,0.00,0.00),('1','140','773','257828',4904779,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257829',4904780,'2144','331',5375934.35,5381403.02,0.00,0.00,5468.67,3421515.60,0.00,0.00,0.00),('1','140','773','257829',4904781,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257830',4904782,'2144','331',5381403.02,5384329.40,0.00,0.00,2926.38,1839398.40,0.00,0.00,0.00),('1','140','773','257830',4904783,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257831',4904784,'2144','331',5384329.40,5390017.24,0.00,0.00,5687.84,3553331.20,0.00,0.00,0.00),('1','140','773','257831',4904785,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257832',4904786,'2144','331',5390017.24,5390844.88,0.00,0.00,827.64,515575.20,0.00,0.00,0.00),('1','140','773','257832',4904787,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257833',4904788,'2144','331',5390844.88,5390844.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257833',4904789,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257834',4904790,'2144','331',5390844.88,5395225.08,0.00,0.00,4380.20,2738502.40,0.00,0.00,0.00),('1','140','773','257834',4904791,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257835',4904792,'2144','331',5395225.08,5398264.03,0.00,0.00,3038.95,1908356.00,0.00,0.00,0.00),('1','140','773','257835',4904793,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257836',4904794,'2144','331',5398264.03,5402998.93,0.00,0.00,4734.90,2959752.00,0.00,0.00,0.00),('1','140','773','257836',4904795,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257837',4904796,'2144','331',5402998.93,5405906.01,0.00,0.00,2907.08,1828974.40,0.00,0.00,0.00),('1','140','773','257837',4904797,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257838',4904798,'2144','331',5405906.01,5409061.40,0.00,0.00,3155.39,1977845.20,0.00,0.00,0.00),('1','140','773','257838',4904799,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257839',4904800,'2144','331',5409061.40,5413370.93,0.00,0.00,4309.53,2691500.40,0.00,0.00,0.00),('1','140','773','257839',4904801,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257840',4904802,'2144','331',5413370.93,5415316.08,0.00,0.00,1945.15,1223072.00,0.00,0.00,0.00),('1','140','773','257840',4904803,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257841',4904804,'2144','331',5415316.08,5415316.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257841',4904805,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257842',4904806,'2144','331',5415316.08,5418703.08,0.00,0.00,3387.00,2132280.00,0.00,0.00,0.00),('1','140','773','257842',4904807,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257843',4904808,'2144','331',5418703.08,5422787.98,0.00,0.00,4084.90,2554052.00,0.00,0.00,0.00),('1','140','773','257843',4904809,'2187','331',1883.00,1883.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257844',4904810,'2144','331',5422787.98,5428126.23,0.00,0.00,5338.25,3338050.00,0.00,0.00,0.00),('1','140','773','257844',4904811,'2187','331',1883.00,1888.15,0.00,0.00,5.15,3502.00,0.00,0.00,0.00),('1','140','773','257845',4904812,'2144','331',5428126.23,5434375.55,0.00,0.00,6249.32,3895387.60,0.00,0.00,0.00),('1','140','773','257845',4904813,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257846',4904814,'2144','331',5434375.55,5439794.75,0.00,0.00,5419.20,3381426.00,0.00,0.00,0.00),('1','140','773','257846',4904815,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257847',4904816,'2144','331',5439794.75,5440024.91,0.00,0.00,230.16,147232.20,0.00,0.00,0.00),('1','140','773','257847',4904817,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257848',4904818,'2144','331',5440024.91,5440024.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257848',4904819,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257849',4904820,'2144','331',5440024.91,5445811.13,0.00,0.00,5786.22,3605169.60,0.00,0.00,0.00),('1','140','773','257849',4904821,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257850',4904822,'2144','331',5445811.13,5449227.38,0.00,0.00,3416.25,2139810.00,0.00,0.00,0.00),('1','140','773','257850',4904823,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257851',4904824,'2144','331',5449227.38,5454387.51,0.00,0.00,5160.13,3234028.40,0.00,0.00,0.00),('1','140','773','257851',4904825,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257852',4904826,'2144','331',5454387.51,5459071.46,0.00,0.00,4683.95,2924716.00,0.00,0.00,0.00),('1','140','773','257852',4904827,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257853',4904828,'2144','331',5459071.46,5464014.15,0.00,0.00,4942.69,3088629.20,0.00,0.00,0.00),('1','140','773','257853',4904829,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257854',4904830,'2144','331',5464014.15,5464584.31,0.00,0.00,570.16,357588.80,0.00,0.00,0.00),('1','140','773','257854',4904831,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257855',4904832,'2144','331',5464584.31,5464584.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257855',4904833,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257856',4904834,'2144','331',5464584.31,5469778.62,0.00,0.00,5194.31,3260660.80,0.00,0.00,0.00),('1','140','773','257856',4904835,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257857',4904836,'2144','331',5469778.62,5475051.24,0.00,0.00,5272.62,3307791.60,0.00,0.00,0.00),('1','140','773','257857',4904837,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257858',4904838,'2144','331',5475051.24,5479784.87,0.00,0.00,4733.63,2968728.40,0.00,0.00,0.00),('1','140','773','257858',4904839,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257859',4904840,'2144','331',5479784.87,5484043.97,0.00,0.00,4259.10,2671893.00,0.00,0.00,0.00),('1','140','773','257859',4904841,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257860',4904842,'2144','331',5484043.97,5487617.64,0.00,0.00,3573.67,2251115.60,0.00,0.00,0.00),('1','140','773','257860',4904843,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257861',4904844,'2144','331',5487617.64,5489215.62,0.00,0.00,1597.98,998426.40,0.00,0.00,0.00),('1','140','773','257861',4904845,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257862',4904846,'2144','331',5489215.62,5489215.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257862',4904847,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257863',4904848,'2144','331',5489215.62,5490438.08,0.00,0.00,1222.46,777152.80,0.00,0.00,0.00),('1','140','773','257863',4904849,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257864',4904850,'2144','331',5490438.08,5493259.79,0.00,0.00,2821.71,1777222.80,0.00,0.00,0.00),('1','140','773','257864',4904851,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257865',4904852,'2144','331',5493259.79,5496697.13,0.00,0.00,3437.34,2162197.20,0.00,0.00,0.00),('1','140','773','257865',4904853,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257866',4904854,'2144','331',5496697.13,5499230.01,0.00,0.00,2532.88,1591348.40,0.00,0.00,0.00),('1','140','773','257866',4904855,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257867',4904856,'2144','331',5499230.01,5501904.23,0.00,0.00,2674.22,1683529.60,0.00,0.00,0.00),('1','140','773','257867',4904857,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257868',4904858,'2144','331',5501904.23,5504220.54,0.00,0.00,2316.31,1462350.80,0.00,0.00,0.00),('1','140','773','257868',4904859,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257869',4904860,'2144','331',5504220.54,5505368.68,0.00,0.00,1148.14,739875.20,0.00,0.00,0.00),('1','140','773','257869',4904861,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257870',4904862,'2144','331',5505368.68,5509790.46,0.00,0.00,4421.78,2767170.40,0.00,0.00,0.00),('1','140','773','257870',4904863,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257871',4904864,'2144','331',5509790.46,5511321.58,0.00,0.00,1531.12,975161.60,0.00,0.00,0.00),('1','140','773','257871',4904865,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257872',4904866,'2144','331',5511321.58,5513489.51,0.00,0.00,2167.93,1358317.40,0.00,0.00,0.00),('1','140','773','257872',4904867,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257873',4904868,'2144','331',5513489.51,5513489.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257873',4904869,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257874',4904870,'2144','331',5513489.51,5516955.36,0.00,0.00,3465.85,2118027.50,0.00,0.00,0.00),('1','140','773','257874',4904871,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257875',4904872,'2144','331',5516955.36,5522259.85,0.00,0.00,5304.49,3236283.50,0.00,0.00,0.00),('1','140','773','257875',4904873,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257876',4904874,'2144','331',5522259.85,5526771.34,0.00,0.00,4511.49,2753458.50,0.00,0.00,0.00),('1','140','773','257876',4904875,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257877',4904876,'2144','331',5526771.34,5529873.12,0.00,0.00,3101.78,1891979.50,0.00,0.00,0.00),('1','140','773','257877',4904877,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257878',4904878,'2144','331',5529873.12,5534944.42,0.00,0.00,5071.30,3091100.00,0.00,0.00,0.00),('1','140','773','257878',4904879,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','140','773','257879',4904880,'2144','331',5534944.42,5538000.97,0.00,0.00,3056.55,1862085.00,0.00,0.00,0.00),('1','140','773','257879',4904881,'2187','331',1888.15,1888.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730080 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','140','150308','331',184.00,260.00,0.00,7652.50,1408060.00,1540466.00,132406.00,450154),('1','140','150313','331',184.00,260.00,0.00,12980.50,2388412.00,2611864.00,223452.00,450167),('1','140','150317','331',184.00,260.00,0.00,2168.00,398912.00,436244.00,37332.00,450175),('1','140','150319','331',184.00,260.00,0.00,0.00,0.00,0.00,0.00,450179),('1','140','150322','331',184.00,260.00,0.00,17704.00,3257536.00,3555432.00,297896.00,450186),('1','140','150326','331',184.00,260.00,0.00,5014.00,922576.00,1006152.00,83576.00,450196),('1','140','150605','331',184.00,260.00,0.00,12812.20,2357444.80,2572914.00,215469.20,450936),('1','140','150610','331',184.00,260.00,0.00,9897.90,1821213.60,1988902.00,167688.40,450947),('1','140','150614','331',181.00,260.00,0.00,22706.10,4109804.10,4565966.00,456161.90,450956),('1','140','150616','331',181.00,260.00,0.00,5519.00,998939.00,1110372.00,111433.00,450960),('1','140','150617','331',181.00,260.00,0.00,17175.30,3108729.30,3449630.00,340900.70,450961),('1','140','150717','331',181.00,260.00,0.00,22936.10,4151434.10,4611046.00,459611.90,451231),('1','140','152271','331',184.00,260.00,0.00,17910.10,3295458.40,3598716.00,303257.60,455411),('1','140','152272','331',184.00,260.00,0.00,4685.90,862205.60,942438.00,80232.40,455412),('1','140','152280','331',184.00,260.00,0.00,22690.60,4175070.40,4562484.00,387413.60,455434),('1','140','152287','331',184.00,260.00,0.00,22674.60,4172126.40,4559446.00,387319.60,455453),('1','140','152298','331',184.00,260.00,0.00,9292.10,1709746.40,1868456.00,158709.60,455480),('1','140','152582','331',184.00,260.00,0.00,5748.00,1057632.00,1158464.00,100832.00,456253),('1','140','152584','331',184.00,260.00,0.00,7807.90,1436653.60,1570824.00,134170.40,456257),('1','140','152586','331',184.00,260.00,0.00,22910.20,4215476.80,4605496.00,390019.20,456261),('1','140','154102','331',184.00,260.00,0.00,11468.30,2110167.20,2258082.00,147914.80,460309),('1','140','154110','331',184.00,260.00,0.00,12085.00,2223640.00,2381876.00,158236.00,460331),('1','140','154116','331',184.00,260.00,0.00,13294.20,2446132.80,2621844.00,175711.20,460347),('1','140','154336','331',184.00,260.00,0.00,8751.80,1610331.20,1729062.00,118730.80,460949),('1','140','154339','331',184.00,260.00,0.00,11106.60,2043614.40,2189516.00,145901.60,460956),('1','140','154344','331',184.00,260.00,0.00,11590.10,2132578.40,2283414.00,150835.60,460969),('1','140','154351','331',184.00,260.00,0.00,19302.80,3551715.20,3800497.60,248782.40,460988),('1','140','154357','331',184.00,260.00,0.00,3398.40,625305.60,675132.00,49826.40,461004),('1','140','154363','331',184.00,260.00,0.00,0.00,0.00,0.00,0.00,461018),('1','140','154365','331',184.00,260.00,0.00,19491.90,3586509.60,3836792.00,250282.40,461022),('1','140','154367','331',184.00,260.00,0.00,0.00,0.00,0.00,0.00,461026),('1','140','154368','331',184.00,260.00,0.00,3214.50,591468.00,636720.00,45252.00,461027),('1','140','155714','331',184.00,260.00,0.00,9054.20,1665972.80,1771693.00,105720.20,464687),('1','140','156182','331',184.00,260.00,0.00,0.00,0.00,0.00,0.00,465921),('1','140','157075','331',184.00,260.00,0.00,5338.00,982192.00,1013898.00,31706.00,468316),('1','140','157076','331',184.00,260.00,0.00,8463.00,1557192.00,1654812.00,97620.00,468317),('1','140','157077','331',184.00,260.00,0.00,0.00,0.00,0.00,0.00,468318),('1','140','157078','331',184.00,200.00,0.00,0.00,0.00,0.00,0.00,468319),('1','140','157080','331',184.00,260.00,0.00,0.00,0.00,0.00,0.00,468321),('1','140','157085','331',184.00,260.00,0.00,22691.06,4175155.04,4433525.80,258370.76,468332),('1','140','157164','331',184.00,260.00,0.00,14422.80,2653795.20,2817996.00,164200.80,468534),('1','140','157165','331',184.00,260.00,0.00,8292.50,1525820.00,1619680.00,93860.00,468535),('1','140','157169','331',184.00,260.00,0.00,19704.70,3625664.80,3851612.00,225947.20,468545),('1','140','157174','331',184.00,260.00,0.00,10471.20,1926700.80,2047860.00,121159.20,468559),('1','140','157175','331',184.00,260.00,0.00,9228.10,1697970.40,1808066.00,110095.60,468560),('1','140','157224','331',184.00,260.00,0.00,16862.34,3102670.56,3291698.40,189027.84,468697),('1','140','157277','331',184.00,260.00,0.00,6660.00,1225440.00,1304076.00,78636.00,468830),('1','140','157297','331',184.00,260.00,0.00,8768.00,1613312.00,1714024.00,100712.00,468884),('1','140','157298','331',184.00,260.00,0.00,0.00,0.00,0.00,0.00,468885),('1','140','157300','331',184.00,260.00,0.00,15814.00,2909776.00,3090560.00,180784.00,468889),('1','140','157303','331',184.00,260.00,0.00,22680.80,4173267.20,4427348.20,254081.00,468896),('1','140','157311','331',184.00,260.00,0.00,6212.00,1143008.00,1217584.00,74576.00,468918),('1','140','157313','331',184.00,260.00,0.00,11471.10,2110682.40,2242962.00,132279.60,468920),('1','140','157314','331',184.00,260.00,0.00,4992.90,918693.60,975198.00,56504.40,468921),('1','140','157319','331',184.00,260.00,0.00,18981.00,3492504.00,3704730.00,212226.00,468933),('1','140','157324','331',184.00,260.00,0.00,3667.00,674728.00,718358.00,43630.00,468945),('1','140','157336','331',184.00,260.00,0.00,11921.00,2193464.00,2323294.00,129830.00,468977),('1','140','157346','331',184.00,260.00,0.00,10723.00,1973032.00,2093276.00,120244.00,469002),('1','140','157353','331',184.00,260.00,0.00,23604.30,4343191.20,4610556.00,267364.80,469021),('1','140','157358','331',184.00,260.00,0.00,7715.00,1419560.00,1553220.00,133660.00,469034),('1','140','157363','331',184.00,260.00,0.00,5867.00,1079528.00,1183456.00,103928.00,469047),('1','140','157366','331',184.00,260.00,0.00,10010.00,1841840.00,2014156.00,172316.00,469054),('1','140','157455','331',184.00,260.00,0.00,21671.50,3987556.00,4349290.00,361734.00,469283),('1','140','157458','331',184.00,260.00,0.00,1916.20,352580.80,387900.00,35319.20,469290),('1','140','157462','331',184.00,200.00,0.00,0.00,0.00,0.00,0.00,469300),('1','140','157466','331',184.00,260.00,0.00,14986.00,2757424.00,3010052.00,252628.00,469310),('1','140','157467','331',184.00,260.00,0.00,8660.00,1593440.00,1744154.00,150714.00,469311),('1','140','157470','331',184.00,260.00,0.00,18311.60,3369334.40,3678330.00,308995.60,469318),('1','140','157471','331',184.00,260.00,0.00,6197.00,1140248.00,1248508.00,108260.00,469319),('1','140','157473','331',184.00,260.00,0.00,8607.00,1583688.00,1815016.00,231328.00,469323),('1','140','161271','331',184.00,260.00,0.00,7854.00,1445136.00,1656128.00,210992.00,479253),('1','140','161273','331',184.00,0.00,0.00,18911.00,3479624.00,3983262.00,503638.00,479257),('1','140','161275','331',184.00,260.00,0.00,3798.00,698832.00,799996.00,101164.00,479261),('1','140','161276','331',184.00,260.00,0.00,14632.00,2692288.00,3082004.00,389716.00,479262),('1','140','161277','331',184.00,260.00,0.00,8062.00,1483408.00,1699542.00,216134.00,479263),('1','140','161279','331',184.00,260.00,0.00,12632.00,2324288.00,2663368.00,339080.00,479267),('1','140','161280','331',184.00,260.00,0.00,10087.00,1856008.00,2127472.00,271464.00,479268),('1','140','161281','331',184.00,260.00,0.00,12812.00,2357408.00,2701148.00,343740.00,479269),('1','140','161282','331',184.00,260.00,0.00,6944.00,1277696.00,1465798.00,188102.00,479270),('1','140','161284','331',183.00,260.00,0.00,9879.00,1807857.00,2085764.00,277907.00,479272),('1','140','161288','331',183.00,260.00,0.00,20446.00,3741618.00,4301210.00,559592.00,479278),('1','140','161289','331',183.00,260.00,0.00,2305.00,421815.00,487232.00,65417.00,479279),('1','140','161293','331',183.00,260.00,0.00,8246.00,1509018.00,1739698.00,230680.00,479284),('1','140','161295','331',183.00,260.00,0.00,14373.00,2630259.00,3029502.00,399243.00,479286),('1','140','161296','331',183.00,260.00,0.00,6550.00,1198650.00,1379854.00,181204.00,479287),('1','140','161298','331',183.00,260.00,0.00,16189.00,2962587.00,3413162.00,450575.00,479291),('1','140','161301','331',183.00,260.00,0.00,5628.00,1029924.00,1155534.00,125610.00,479298),('1','140','161302','331',183.00,260.00,0.00,13609.00,2490447.00,2868048.00,377601.00,479299),('1','140','161305','331',183.00,260.00,0.00,1694.00,310002.00,357598.00,47596.00,479304),('1','140','161351','331',183.00,260.00,0.00,8729.00,1597407.00,1841344.00,243937.00,479431),('1','140','161352','331',183.00,260.00,0.00,13727.80,2512187.40,2811035.20,298847.80,479432),('1','140','161466','331',183.00,260.00,0.00,12713.00,2326479.00,2607288.00,280809.00,479728),('1','140','161469','331',183.00,260.00,0.00,9988.00,1827804.00,2049336.00,221532.00,479733),('1','140','161470','331',183.00,260.00,0.00,0.00,0.00,0.00,0.00,479734),('1','140','161472','331',183.00,260.00,0.00,22569.80,4130273.40,4627228.00,496954.60,479738),('1','140','161477','331',183.00,260.00,0.00,5136.00,939888.00,1057532.00,117644.00,479747),('1','140','161480','331',183.00,260.00,0.00,17573.00,3215859.00,3604084.00,388225.00,479753),('1','140','161482','331',183.00,260.00,0.00,10953.00,2004399.00,2250164.00,245765.00,479757),('1','140','161484','331',183.00,260.00,0.00,6642.00,1215486.00,1363268.00,147782.00,479759),('1','140','161485','331',183.00,260.00,0.00,1127.50,206332.50,231566.00,25233.50,479760),('1','140','161672','331',183.00,0.00,0.00,3891.50,712144.50,798954.00,86809.50,480265),('1','140','161674','331',183.00,260.00,0.00,22613.00,4138179.00,4904026.00,765847.00,480269),('1','140','161675','331',184.00,260.00,0.00,16280.00,2995520.00,3531716.00,536196.00,480270),('1','140','161676','331',184.00,260.00,0.00,6602.00,1214768.00,1435140.00,220372.00,480271),('1','140','161677','331',184.00,260.00,0.00,22662.00,4169808.00,4917952.00,748144.00,480272),('1','140','161678','331',184.00,260.00,0.00,22804.00,4195936.00,4949116.00,753180.00,480273),('1','140','161679','331',184.00,260.00,0.00,22858.00,4205872.00,4960140.00,754268.00,480274),('1','140','161680','331',184.00,260.00,0.00,10940.00,2012960.00,2376352.00,363392.00,480275),('1','140','161681','331',184.00,260.00,0.00,11916.10,2192562.40,2586222.00,393659.60,480276),('1','140','161682','331',184.00,260.00,0.00,12444.00,2289696.00,2703436.00,413740.00,480277),('1','140','161683','331',184.00,260.00,0.00,4844.00,891296.00,1052600.00,161304.00,480278),('1','140','161684','331',184.00,260.00,0.00,11646.00,2142864.00,2528184.00,385320.00,480279),('1','140','161685','331',184.00,260.00,0.00,10975.00,2019400.00,2377660.00,358260.00,480280),('1','140','161686','331',184.00,260.00,0.00,10633.00,1956472.00,2308736.00,352264.00,480281),('1','140','161689','331',184.00,260.00,0.00,12056.00,2218304.00,2618424.00,400120.00,480286),('1','140','162215','331',184.00,260.00,0.00,5198.00,956432.00,1177834.00,221402.00,481669),('1','140','162217','331',184.00,304.00,0.00,10325.00,1899800.00,2346386.00,446586.00,481673),('1','140','162218','331',184.00,304.00,0.00,7286.00,1340624.00,1599412.00,258788.00,481674),('1','140','162222','331',184.00,304.00,0.00,22719.00,4180296.00,5116848.00,936552.00,481682),('1','140','162231','331',184.00,304.00,0.00,10095.00,1857480.00,2298820.00,441340.00,481705),('1','140','162311','331',184.00,304.00,0.00,8639.00,1589576.00,1966912.00,377336.00,481905),('1','140','162317','331',184.00,304.00,0.00,3978.00,731952.00,907522.00,175570.00,481921),('1','140','162548','331',184.00,304.00,0.00,0.00,0.00,0.00,0.00,482500),('1','140','162556','331',202.00,304.00,0.00,5919.00,1195638.00,1353206.00,157568.00,482519),('1','140','162559','331',202.00,304.00,0.00,0.00,0.00,0.00,0.00,482524),('1','140','162563','331',202.00,304.00,0.00,0.00,0.00,0.00,0.00,482532),('1','140','162565','331',202.00,0.00,0.00,4498.00,908596.00,1031630.00,123034.00,482536),('1','140','162569','331',202.00,304.00,0.00,12291.00,2482782.00,2799980.00,317198.00,482545),('1','140','162572','331',202.00,304.00,0.00,8748.60,1767217.20,1996084.00,228866.80,482550),('1','140','162700','331',202.00,304.00,0.00,13963.40,2820606.80,3183422.00,362815.20,482888),('1','140','162779','331',183.00,260.00,0.00,22712.20,4156332.60,4437668.00,281335.40,483117),('1','140','163058','331',207.00,304.00,0.00,7048.40,1459018.80,1610733.60,151714.80,483829),('1','140','163060','331',207.00,304.00,0.00,11889.00,2461023.00,2709724.00,248701.00,483833),('1','140','163119','331',207.00,304.00,0.00,3728.80,771861.60,848544.00,76682.40,483990),('1','140','163705','331',207.00,304.00,0.00,5212.00,1078884.00,1191996.00,113112.00,485526),('1','140','163709','331',207.00,304.00,0.00,12557.00,2599299.00,2862802.00,263503.00,485536),('1','140','163783','331',207.00,0.00,0.00,85.00,17595.00,25840.00,8245.00,485714),('1','140','163819','331',207.00,304.00,0.00,2016.00,417312.00,460524.00,43212.00,485804),('1','140','163823','331',207.00,304.00,0.00,3514.00,727398.00,806158.00,78760.00,485814),('1','140','163825','331',207.00,304.00,0.00,7088.50,1467319.50,1617422.00,150102.50,485818),('1','140','164050','331',207.00,304.00,0.00,12115.50,2507908.50,2752515.20,244606.70,486431),('1','140','164058','331',207.00,304.00,0.00,14646.00,3031722.00,3331944.00,300222.00,486448),('1','140','164235','331',207.00,304.00,0.00,5160.00,1068120.00,1173666.00,105546.00,486917),('1','140','164573','331',207.00,304.00,0.00,5926.20,1226723.40,1421394.80,194671.40,487817),('1','140','164577','331',207.00,304.00,0.00,6390.90,1322916.30,1532047.60,209131.30,487827),('1','140','164896','331',207.00,304.00,0.00,6458.90,1336992.30,1545464.20,208471.90,488659),('1','140','164901','331',207.00,238.00,0.00,0.00,0.00,0.00,0.00,488672),('1','140','165097','331',207.00,304.00,0.00,6006.00,1243242.00,1440814.00,197572.00,489171),('1','140','165105','331',207.00,304.00,0.00,16409.00,3396663.00,3909256.80,512593.80,489195),('1','140','165289','331',222.00,320.00,0.00,6537.00,1451214.00,1700718.00,249504.00,489673),('1','140','165384','331',222.00,320.00,0.00,6281.00,1394382.00,1636230.00,241848.00,489913),('1','140','165529','331',222.00,320.00,0.00,9865.20,2190074.40,2560868.00,370793.60,490295),('1','140','165874','331',222.00,320.00,0.00,0.00,0.00,0.00,0.00,491229),('1','140','165887','331',222.00,320.00,0.00,7257.00,1611054.00,1889122.00,278068.00,491262),('1','140','166072','331',222.00,320.00,0.00,8465.00,1879230.00,2201112.00,321882.00,491751),('1','140','166089','331',222.00,320.00,0.00,7004.00,1554888.00,1822308.00,267420.00,491795),('1','140','166274','331',222.00,320.00,0.00,10883.00,2416026.00,2829474.00,413448.00,492277),('1','140','166422','331',222.00,320.00,0.00,10419.00,2313018.00,2709174.00,396156.00,492679),('1','140','166652','331',222.00,320.00,0.00,1310.00,290820.00,337980.00,47160.00,493298),('1','140','166668','331',222.00,320.00,0.00,5848.00,1298256.00,1523900.00,225644.00,493344),('1','140','166850','331',222.00,320.00,0.00,12434.00,2760348.00,3227764.00,467416.00,493840),('1','140','167313','331',222.00,320.00,0.00,4397.00,976134.00,1143476.00,167342.00,495072),('1','140','167513','331',246.00,320.00,0.00,8338.00,2051148.00,2171040.00,119892.00,495613),('1','140','167522','331',246.00,320.00,0.00,6124.00,1506504.00,1595492.00,88988.00,495638),('1','140','167539','331',246.00,320.00,0.00,8151.00,2005146.00,2118172.00,113026.00,495681),('1','140','167676','331',246.00,320.00,0.00,7206.00,1772676.00,1877302.00,104626.00,496031),('1','140','167847','331',246.00,320.00,0.00,8036.00,1976856.00,2089380.00,112524.00,496474),('1','140','168069','331',246.00,320.00,0.00,7379.00,1815234.00,1918708.00,103474.00,497077),('1','140','168195','331',246.00,320.00,0.00,14838.00,3650148.00,3854100.00,203952.00,497397),('1','140','168557','331',246.00,320.00,0.00,7898.00,1942908.00,2027602.00,84694.00,498372),('1','140','168730','331',246.00,320.00,0.00,5916.00,1455336.00,1521354.00,66018.00,498839),('1','140','168738','331',246.00,320.00,0.00,16476.00,4053096.00,4219968.00,166872.00,498855),('1','140','168910','331',246.00,320.00,0.00,2283.00,561618.00,588768.00,27150.00,499312),('1','140','170081','331',246.00,320.00,0.00,9486.00,2333556.00,2508592.00,175036.00,502362),('1','140','170089','331',246.00,320.00,0.00,14710.00,3618660.00,3882290.00,263630.00,502377),('1','140','170094','331',246.00,320.00,0.00,612.00,150552.00,160344.00,9792.00,502387),('1','140','170249','331',246.00,320.00,0.00,19681.00,4841526.00,5217608.00,376082.00,502782),('1','140','170268','331',246.00,320.00,0.00,5131.00,1262226.00,1361350.00,99124.00,502833),('1','140','170306','331',246.00,320.00,0.00,18469.00,4543374.00,4896875.00,353501.00,502937),('1','140','170417','331',246.00,320.00,0.00,14762.70,3631624.20,3967818.00,336193.80,503231),('1','140','170428','331',256.00,320.00,0.00,7746.00,1982976.00,2112180.00,129204.00,503262),('1','140','170436','331',256.00,320.00,0.00,10190.00,2608640.00,2776866.00,168226.00,503283),('1','140','170439','331',256.00,320.00,0.00,6653.00,1703168.00,1812266.00,109098.00,503290),('1','140','170972','331',256.00,320.00,0.00,24786.00,6345216.00,6752892.00,407676.00,504687),('1','140','170978','331',256.00,320.00,0.00,12705.00,3252480.00,3455544.00,203064.00,504699),('1','140','170979','331',256.00,320.00,0.00,11996.00,3070976.00,3269592.00,198616.00,504700),('1','140','170987','331',256.00,320.00,0.00,13157.00,3368192.00,3635714.00,267522.00,504717),('1','140','171332','331',256.00,320.00,0.00,8433.00,2158848.00,2334594.00,175746.00,505652),('1','140','171346','331',256.00,320.00,0.00,3196.00,818176.00,888864.00,70688.00,505688),('1','140','171522','331',256.00,320.00,0.00,0.00,0.00,0.00,0.00,506168),('1','140','171736','331',256.00,320.00,0.00,10011.00,2562816.00,2771374.00,208558.00,506735),('1','140','171745','331',256.00,320.00,0.00,12264.00,3139584.00,3391540.00,251956.00,506755),('1','140','172348','331',256.00,320.00,0.00,2582.00,660992.00,708020.00,47028.00,508344),('1','140','172357','331',256.00,320.00,0.00,17752.00,4544512.00,4901108.00,356596.00,508365),('1','140','172364','331',256.00,320.00,0.00,6531.00,1671936.00,1812900.00,140964.00,508384),('1','140','172370','331',256.00,320.00,0.00,529.00,135424.00,144946.00,9522.00,508398),('1','140','172412','331',256.00,320.00,0.00,15194.00,3889664.00,4200108.00,310444.00,508516),('1','140','172668','331',256.00,320.00,0.00,9692.10,2481177.60,2684962.00,203784.40,509193),('1','140','172811','331',256.00,320.00,0.00,20386.00,5218816.00,5629114.00,410298.00,509568),('1','140','172960','331',256.00,320.00,0.00,4518.00,1156608.00,1254968.00,98360.00,509956),('1','140','173534','331',264.00,320.00,0.00,19506.00,5149584.00,5376154.00,226570.00,511501),('1','140','173542','331',264.00,320.00,0.00,3738.00,986832.00,1037854.00,51022.00,511523),('1','140','173546','331',264.00,320.00,0.00,17557.00,4635048.00,4856976.00,221928.00,511531),('1','140','173707','331',264.00,320.00,0.00,7114.00,1878096.00,1970636.00,92540.00,511943),('1','140','173876','331',264.00,320.00,0.00,18881.00,4984584.00,5222508.00,237924.00,512396),('1','140','174066','331',264.00,320.00,0.00,5780.00,1525920.00,1598212.00,72292.00,512890),('1','140','174259','331',264.00,320.00,0.00,23099.00,6098136.00,6372673.00,274537.00,513399),('1','140','174412','331',264.00,320.00,0.00,19851.60,5240822.40,5484196.00,243373.60,513785),('1','140','175133','331',264.00,320.00,0.00,4773.00,1260072.00,1320458.00,60386.00,515682),('1','140','175317','331',264.00,320.00,0.00,14666.00,3871824.00,4062928.00,191104.00,516159),('1','140','175320','331',264.00,320.00,0.00,1901.00,501864.00,524160.00,22296.00,516166),('1','140','175327','331',276.00,320.00,0.00,24531.00,6770556.00,6769626.00,-930.00,516184),('1','140','175407','331',276.00,336.00,0.00,6315.00,1742940.00,1878628.00,135688.00,516393),('1','140','175412','331',276.00,336.00,0.00,6668.00,1840368.00,1993616.00,153248.00,516403),('1','140','175583','331',276.00,336.00,0.00,11455.00,3161580.00,3406864.00,245284.00,516858),('1','140','175720','331',276.00,336.00,0.00,5646.50,1558434.00,1690792.00,132358.00,517220),('1','140','176089','331',276.00,336.00,0.00,3349.00,924324.00,1000760.00,76436.00,518160),('1','140','176111','331',276.00,336.00,0.00,0.00,0.00,0.00,0.00,518223),('1','140','176113','331',276.00,336.00,0.00,6403.00,1767228.00,1909680.00,142452.00,518226),('1','140','176463','331',276.00,336.00,0.00,9128.50,2519466.00,2718770.00,199304.00,519140),('1','140','176480','331',276.00,336.00,0.00,6366.00,1827042.00,1904580.00,77538.00,519181),('1','140','176662','331',287.00,336.00,0.00,7503.00,2153361.00,2235388.00,82027.00,519656),('1','140','177788','331',287.00,336.00,0.00,10874.00,3120838.00,3234132.00,113294.00,522669),('1','140','177793','331',287.00,336.00,0.00,9468.00,2706372.00,2817264.00,110892.00,522680),('1','140','177817','331',281.00,336.00,0.00,4916.00,1381396.00,1470952.00,89556.00,522742),('1','140','177822','331',281.00,336.00,0.00,10662.00,2996022.00,3169112.00,173090.00,522753),('1','140','177827','331',281.00,336.00,0.00,4340.30,1219624.30,1299778.80,80154.50,522766),('1','140','178004','331',281.00,336.00,0.00,12824.10,3603572.10,3816353.60,212781.50,523227),('1','140','178391','331',281.00,336.00,0.00,5836.60,1640084.60,1742952.00,102867.40,524233),('1','140','178403','331',281.00,336.00,0.00,1911.00,536991.00,566176.00,29185.00,524263),('1','140','178410','331',281.00,336.00,0.00,0.00,0.00,0.00,0.00,524280),('1','140','179081','331',281.00,336.00,0.00,22924.20,6441700.20,6819979.60,378279.40,526028),('1','140','179088','331',281.00,336.00,0.00,1857.00,521817.00,568690.00,46873.00,526047),('1','140','179099','331',281.00,336.00,0.00,8888.00,2497528.00,2713126.00,215598.00,526075),('1','140','179459','331',281.00,336.00,0.00,10334.00,2903854.00,3152852.00,248998.00,527039),('1','140','179520','331',281.00,336.00,0.00,10673.00,2999113.00,3254476.00,255363.00,527207),('1','140','179714','331',281.00,336.00,0.00,6546.00,1839426.00,1996612.00,157186.00,527731),('1','140','179941','331',281.00,336.00,0.00,7559.00,2124079.00,2308344.00,184265.00,528332),('1','140','179964','331',281.00,336.00,0.00,10720.50,3012460.50,3274067.00,261606.50,528383),('1','140','180028','331',281.00,336.00,0.00,11674.60,3702495.10,3566266.60,-136228.50,528532),('1','140','180164','331',336.00,336.00,0.00,2544.81,855056.16,777596.16,-77460.00,528909),('1','140','180258','331',336.00,336.00,0.00,5346.65,1551552.25,1628484.40,76932.15,529140),('1','140','180336','331',281.00,336.00,0.00,8938.95,2511844.95,2734024.20,222179.25,529341),('1','140','180559','331',281.00,336.00,0.00,6645.07,1867264.67,2035134.52,167869.85,529921),('1','140','180737','331',281.00,336.00,0.00,4057.98,1140292.38,1175643.28,35350.90,530393),('1','140','180854','331',281.00,336.00,0.00,9684.89,2866727.44,2950595.04,83867.60,530708),('1','140','180957','331',296.00,336.00,0.00,12465.52,3689793.92,3805053.62,115259.70,530989),('1','140','181128','331',296.00,336.00,0.00,2544.48,753166.08,775452.28,22286.20,531439),('1','140','181262','331',296.00,336.00,0.00,11491.15,3401380.40,3483582.40,82202.00,531803),('1','140','181345','331',296.00,336.00,0.00,8545.99,2529613.04,2611448.64,81835.60,532015),('1','140','181521','331',296.00,336.00,0.00,3427.36,1014498.56,1052322.96,37824.40,532482),('1','140','181697','331',296.00,336.00,0.00,968.09,286554.64,296890.74,10336.10,532944),('1','140','181819','331',296.00,336.00,0.00,8729.20,2583843.20,2666985.10,83141.90,533267),('1','140','181962','331',296.00,336.00,0.00,10584.46,3133000.16,3228038.56,95038.40,533661),('1','140','182104','331',296.00,336.00,0.00,5409.59,1601238.64,1651940.24,50701.60,534038),('1','140','182197','331',296.00,336.00,0.00,7704.75,2280606.00,2330728.00,50122.00,534278),('1','140','182311','331',296.00,336.00,0.00,9315.85,2757491.60,2845237.70,87746.10,534562),('1','140','182497','331',296.00,336.00,0.00,3996.06,1182833.76,1229057.16,46223.40,535070),('1','140','182685','331',296.00,336.00,0.00,3761.53,1113412.88,1147986.08,34573.20,535564),('1','140','182754','331',296.00,336.00,0.00,5630.42,1666604.32,1722196.12,55591.80,535753),('1','140','182831','331',296.00,336.00,0.00,9460.20,2800219.20,2865421.20,65202.00,535965),('1','140','182991','331',296.00,336.00,0.00,4814.79,1425177.84,1470707.44,45529.60,536396),('1','140','183131','331',296.00,336.00,0.00,2334.76,691088.96,713004.96,21916.00,536756),('1','140','183217','331',296.00,336.00,0.00,9218.72,2728741.12,2816121.92,87380.80,536973),('1','140','183428','331',296.00,336.00,0.00,7220.28,2137202.88,2209250.08,72047.20,537519),('1','140','183637','331',296.00,336.00,0.00,5993.25,1774002.00,1829723.00,55721.00,538080),('1','140','183795','331',296.00,336.00,0.00,2309.47,679937.36,708621.92,28684.56,538504),('1','140','183868','331',294.00,336.00,0.00,7144.47,2100474.18,2185600.92,85126.74,538694),('1','140','184070','331',294.00,336.00,0.00,1935.29,568975.26,592771.44,23796.18,539232),('1','140','184224','331',294.00,336.00,0.00,7082.30,2082196.20,2166696.40,84500.20,539636),('1','140','184304','331',294.00,336.00,0.00,8760.71,2575648.74,2654620.56,78971.82,539842),('1','140','184391','331',294.00,336.00,0.00,2101.34,617793.96,654050.24,36256.28,540075),('1','140','184455','331',294.00,336.00,0.00,5781.94,1699890.36,1772480.94,72590.58,540231),('1','140','184682','331',294.00,336.00,0.00,11608.96,3413034.24,3549083.56,136049.32,540853),('1','140','184882','331',294.00,336.00,0.00,4975.27,1462729.38,1516822.72,54093.34,541385),('1','140','184980','331',294.00,336.00,0.00,0.00,0.00,0.00,0.00,541648),('1','140','184990','331',294.00,336.00,0.00,5598.30,1645900.20,1710770.80,64870.60,541672),('1','140','185098','331',294.00,336.00,0.00,9526.99,2800935.06,2912998.34,112063.28,541941),('1','140','185256','331',294.00,336.00,0.00,9485.32,2788684.08,2897739.52,109055.44,542333),('1','140','185355','331',294.00,336.00,0.00,11271.57,3313841.58,3432283.52,118441.94,542590),('1','140','185459','331',294.00,336.00,0.00,13069.08,3842309.52,3973886.58,131577.06,542873),('1','140','185715','331',294.00,336.00,0.00,8665.08,2547533.52,2653984.88,106451.36,543543),('1','140','185866','331',294.00,336.00,0.00,14292.37,4201956.78,4368737.32,166780.54,543960),('1','140','186083','331',294.00,336.00,0.00,1638.11,481604.34,499224.96,17620.62,544527),('1','140','186153','331',294.00,336.00,0.00,9239.82,2716507.08,2821149.92,104642.84,544708),('1','140','186308','331',294.00,336.00,0.00,8762.30,2576116.20,2678980.80,102864.60,545119),('1','140','186523','331',294.00,336.00,0.00,6267.94,1842774.36,1915365.84,72591.48,545692),('1','140','186682','331',294.00,336.00,0.00,2082.92,612378.48,635131.12,22752.64,546098),('1','140','186752','331',294.00,336.00,0.00,15248.12,4482947.28,4612212.72,129265.44,546274),('1','140','186991','331',294.00,336.00,0.00,6350.85,1867149.90,1946557.60,79407.70,546870),('1','140','187152','331',294.00,336.00,0.00,5449.97,1602291.18,1666339.92,64048.74,547316),('1','140','187357','331',294.00,336.00,0.00,11806.89,3471225.66,3607465.04,136239.38,547846),('1','140','187573','331',294.00,336.00,0.00,2278.26,669808.44,694685.36,24876.92,548418),('1','140','187646','331',294.00,336.00,0.00,7246.76,2130547.44,2214682.36,84134.92,548608),('1','140','187792','331',294.00,336.00,0.00,8678.55,2551493.70,2652689.80,101196.10,549001),('1','140','188010','331',294.00,336.00,0.00,8619.06,2534003.64,2620957.16,86953.52,549569),('1','140','188196','331',294.00,336.00,0.00,10125.98,2977038.12,3095880.28,118842.16,550061),('1','140','188416','331',294.00,336.00,0.00,18833.83,5537146.02,5733521.88,196375.86,550624),('1','140','188595','331',294.00,336.00,0.00,5768.90,1696056.60,1761020.40,64963.80,551077),('1','140','188796','331',294.00,336.00,0.00,14530.73,4272034.62,4441267.28,169232.66,551614),('1','140','189003','331',294.00,336.00,0.00,9007.72,2648269.68,2754619.92,106350.24,552153),('1','140','189193','331',294.00,336.00,0.00,1155.25,339643.50,351564.00,11920.50,552652),('1','140','189257','331',294.00,336.00,0.00,7480.51,2199269.94,2288256.36,88986.42,552810),('1','140','189411','331',294.00,336.00,0.00,7819.72,2298997.68,2392815.92,93818.24,553229),('1','140','189613','331',294.00,336.00,0.00,4678.50,1375479.00,1409094.00,33615.00,553746),('1','140','189722','331',294.00,336.00,0.00,8851.74,2602411.56,2681274.64,78863.08,554016),('1','140','189805','331',294.00,336.00,0.00,10494.53,3085391.82,3213815.08,128423.26,554240),('1','140','190063','331',294.00,336.00,0.00,5051.30,1485082.20,1548151.80,63069.60,554904),('1','140','190201','331',294.00,336.00,0.00,10494.41,3085356.54,3209021.96,123665.42,555278),('1','140','190422','331',294.00,336.00,0.00,9091.78,2672983.32,2785032.08,112048.76,555856),('1','140','190661','331',294.00,336.00,0.00,4768.70,1401997.80,1445218.20,43220.40,556496),('1','140','190773','331',294.00,336.00,0.00,7618.60,2239868.40,2329171.60,89303.20,556783),('1','140','190884','331',294.00,336.00,0.00,10254.29,3014761.26,3140420.04,125658.78,557072),('1','140','191060','331',294.00,336.00,0.00,6517.31,1916089.14,1988806.16,72717.02,557538),('1','140','191233','331',294.00,336.00,0.00,3675.88,1080708.72,1121247.68,40538.96,557997),('1','140','191281','331',294.00,336.00,0.00,19795.65,5819921.10,5997257.40,177336.30,558119),('1','140','191503','331',294.00,336.00,0.00,1207.87,355113.78,368398.32,13284.54,558692),('1','140','191690','331',294.00,336.00,0.00,4397.40,1292835.60,1339527.40,46691.80,559212),('1','140','191700','331',294.00,336.00,0.00,14540.20,4274818.80,4432301.40,157482.60,559231),('1','140','191929','331',294.00,336.00,0.00,5566.77,1636630.38,1687344.72,50714.34,559844),('1','140','192428','331',294.00,336.00,0.00,9106.09,2677190.46,2784763.24,107572.78,561141),('1','140','192571','331',294.00,336.00,0.00,11185.30,3288478.20,3399915.80,111437.60,561512),('1','140','193292','331',294.00,336.00,0.00,0.00,0.00,0.00,0.00,563421),('1','140','193293','331',294.00,336.00,0.00,4265.30,1253998.20,1282261.80,28263.60,563422),('1','140','193300','331',294.00,336.00,0.00,8051.40,2367111.60,2458374.40,91262.80,563440),('1','140','193318','331',294.00,336.00,0.00,4393.60,1291718.40,1345779.60,54061.20,563489),('1','140','193322','331',294.00,336.00,0.00,8493.76,2497165.44,2582683.36,85517.92,563499),('1','140','193396','331',294.00,336.00,0.00,3642.52,1070900.88,1113828.72,42927.84,563697),('1','140','193537','331',294.00,336.00,0.00,5730.88,1684878.72,1729890.68,45011.96,564053),('1','140','193620','331',294.00,336.00,0.00,7600.60,2234576.40,2295272.60,60696.20,564277),('1','140','193841','331',294.00,336.00,0.00,11851.80,3484429.20,3587114.60,102685.40,564831),('1','140','194018','331',294.00,336.00,0.00,3876.73,1139758.62,1181446.28,41687.66,565265),('1','140','194081','331',294.00,336.00,0.00,6204.10,1824005.40,1899176.60,75171.20,565422),('1','140','194285','331',294.00,336.00,0.00,9489.41,2789886.54,2879442.76,89556.22,565964),('1','140','194523','331',294.00,336.00,0.00,4565.64,1342298.16,1386674.04,44375.88,566543),('1','140','194668','331',294.00,336.00,0.00,8328.88,2448690.72,2543860.08,95169.36,566926),('1','140','194939','331',294.00,336.00,0.00,5349.61,1572785.34,1624455.96,51670.62,567643),('1','140','195072','331',294.00,336.00,0.00,7517.73,2210212.62,2279780.28,69567.66,567993),('1','140','195297','331',294.00,336.00,0.00,3424.66,1006850.04,1048497.36,41647.32,568572),('1','140','195477','331',294.00,336.00,0.00,392.32,115342.08,121139.52,5797.44,569034),('1','140','195513','331',294.00,336.00,0.00,10691.92,3143424.48,3244757.12,101332.64,569128),('1','140','195787','331',294.00,336.00,0.00,6186.64,1818872.16,1869493.04,50620.88,569802),('1','140','196164','331',294.00,336.00,0.00,3294.03,968444.82,993505.68,25060.86,570759),('1','140','196217','331',294.00,336.00,0.00,4146.23,1218991.62,1248543.28,29551.66,570889),('1','140','196410','331',294.00,336.00,0.00,5547.00,1630818.00,1662576.00,31758.00,571392),('1','140','196445','331',294.00,336.00,0.00,3069.50,886025.70,921227.00,35201.30,571484),('1','140','196778','331',287.00,336.00,0.00,5061.80,1452736.60,1520152.80,67416.20,572340),('1','140','196941','331',287.00,336.00,0.00,3147.90,903447.30,943798.40,40351.10,572760),('1','140','197066','331',287.00,336.00,0.00,7806.50,2240465.50,2336477.20,96011.70,573081),('1','140','197586','331',287.00,336.00,0.00,5784.00,1660008.00,1739026.00,79018.00,574347),('1','140','197588','331',287.00,336.00,0.00,4665.70,1339055.90,1400959.20,61903.30,574351),('1','140','197597','331',287.00,336.00,0.00,3939.00,1130493.00,1184936.00,54443.00,574376),('1','140','197997','331',287.00,336.00,0.00,8964.00,2572668.00,2664640.00,91972.00,575453),('1','140','198192','331',287.00,336.00,0.00,1154.40,331312.80,352802.40,21489.60,575942),('1','140','198292','331',287.00,336.00,0.00,0.00,0.00,0.00,0.00,576205),('1','140','198301','331',287.00,336.00,0.00,0.00,0.00,0.00,0.00,576230),('1','140','198420','331',288.00,336.00,0.00,1360.80,391910.40,410130.00,18219.60,576533),('1','140','198422','331',288.00,336.00,0.00,7162.39,2062768.32,2135298.32,72530.00,576537),('1','140','198569','331',288.00,336.00,0.00,11986.81,3452201.28,3578036.16,125834.88,576932),('1','140','199166','331',288.00,336.00,0.00,4251.80,1224518.40,1269688.80,45170.40,578462),('1','140','199380','331',288.00,336.00,0.00,6048.80,1745078.80,1812404.80,67326.00,578959),('1','140','199743','331',288.50,336.00,0.00,7319.80,2111762.30,2185726.80,73964.50,579840),('1','140','199748','331',288.50,336.00,0.00,2805.00,809242.50,848524.00,39281.50,579853),('1','140','199992','331',288.50,336.00,0.00,3202.61,923952.99,963106.96,39153.98,580494),('1','140','200159','331',288.50,336.00,0.00,5305.33,1530587.74,1582456.88,51869.21,580921),('1','140','200339','331',288.00,336.00,0.00,2539.21,731292.48,763048.56,31756.08,581381),('1','140','200637','331',288.00,336.00,0.00,2867.90,825955.20,844962.40,19007.20,582176),('1','140','200732','331',288.00,336.00,0.00,0.00,0.00,0.00,0.00,582409),('1','140','200733','331',288.00,336.00,0.00,4964.90,1429891.20,1445174.80,15283.60,582410),('1','140','200948','331',288.00,336.00,0.00,5562.36,1557460.80,1629026.96,71566.16,582946),('1','140','201119','331',280.00,336.00,0.00,7070.79,1979821.20,2070741.56,90920.36,583392),('1','140','201319','331',280.00,336.00,0.00,4263.02,1193645.60,1250716.72,57071.12,583914),('1','140','201508','331',280.00,336.00,0.00,7685.25,2151870.00,2182958.00,31088.00,584403),('1','140','201885','331',280.00,336.00,0.00,6840.75,1967761.20,2081441.00,113679.80,585403),('1','140','202186','331',290.00,336.00,0.00,3607.80,1046262.00,1104955.80,58693.80,586189),('1','140','202287','331',290.00,336.00,0.00,98.30,28507.00,28900.20,393.20,586443),('1','140','202290','331',290.00,336.00,0.00,6053.70,1755573.00,1845465.20,89892.20,586450),('1','140','202440','331',290.00,336.00,0.00,3188.80,924752.00,972370.80,47618.80,586838),('1','140','202680','331',290.00,336.00,0.00,7385.00,2141650.00,2246156.00,104506.00,587441),('1','140','202924','331',290.00,336.00,0.00,8347.34,2420728.60,2537281.24,116552.64,588076),('1','140','203187','331',290.00,336.00,0.00,9060.49,2627542.10,2760867.64,133325.54,588772),('1','140','203389','331',290.00,336.00,0.00,3973.00,1152170.00,1209858.00,57688.00,589297),('1','140','203668','331',290.00,336.00,0.00,6101.00,1769290.00,1861516.00,92226.00,590013),('1','140','203775','331',290.00,336.00,0.00,7925.91,2298513.90,2414712.76,116198.86,590279),('1','140','204016','331',290.00,336.00,0.00,6621.71,1920295.90,2012616.56,92320.66,590895),('1','140','204196','331',290.00,336.00,0.00,0.00,0.00,0.00,0.00,591378),('1','140','204281','331',290.00,336.00,0.00,4524.59,1312131.10,1376441.24,64310.14,591587),('1','140','204485','331',290.00,336.00,0.00,10350.94,3001772.60,3141519.84,139747.24,592125),('1','140','204647','331',290.00,336.00,0.00,9690.71,2810305.90,2945738.56,135432.66,592525),('1','140','204952','331',290.00,336.00,0.00,8623.50,2500815.00,2621007.00,120192.00,593283),('1','140','205208','331',290.00,336.00,0.00,2871.80,832822.00,879954.80,47132.80,593961),('1','140','205303','331',290.00,336.00,0.00,5916.24,1715709.60,1811571.64,95862.04,594192),('1','140','205615','331',290.00,336.00,0.00,7193.70,2086173.00,2183313.20,97140.20,595001),('1','140','205701','331',290.00,336.00,0.00,5820.80,1688032.00,1767408.80,79376.80,595232),('1','140','205799','331',290.00,336.00,0.00,4101.98,1189574.20,1262809.28,73235.08,595470),('1','140','206029','331',290.00,336.00,0.00,8092.09,2346706.10,2521724.24,175018.14,596068),('1','140','206238','331',290.00,336.00,0.00,5078.95,1472895.50,1585229.20,112333.70,596603),('1','140','206505','331',290.00,336.00,0.00,1524.70,442163.00,474279.60,32116.60,597284),('1','140','206723','331',290.00,336.00,0.00,3379.00,979910.00,1057376.00,77466.00,597847),('1','140','206728','331',290.00,336.00,0.00,3977.30,1153417.00,1242642.80,89225.80,597858),('1','140','206847','331',290.00,336.00,0.00,10569.22,3065073.80,3288403.92,223330.12,598152),('1','140','207093','331',290.00,336.00,0.00,6782.80,1967012.00,2112368.80,145356.80,598796),('1','140','207348','331',290.00,336.00,0.00,6786.10,1983057.50,2117500.20,134442.70,599453),('1','140','207514','331',305.00,336.00,0.00,14379.00,4385595.00,4472382.40,86787.40,599885),('1','140','207812','331',305.00,336.00,0.00,1539.00,469395.00,493824.00,24429.00,600639),('1','140','208301','331',305.00,336.00,0.00,13444.60,4100603.00,4268141.60,167538.60,601910),('1','140','208466','331',305.00,336.00,0.00,11233.50,3426217.50,3563628.00,137410.50,602317),('1','140','208762','331',305.00,336.00,0.00,11281.29,3440793.45,3730263.94,289470.49,603082),('1','140','209017','331',305.00,346.00,0.00,4642.68,1416017.40,1539389.20,123371.80,603713),('1','140','209275','331',305.00,360.00,0.00,14901.50,4544957.50,4933680.76,388723.26,604380),('1','140','209512','331',305.00,360.00,0.00,6338.90,1933364.50,2156449.00,223084.50,604985),('1','140','209726','331',305.00,360.00,0.00,3275.80,999119.00,1114388.20,115269.20,605536),('1','140','210021','331',305.00,360.00,0.00,2595.00,791475.00,879010.00,87535.00,606305),('1','140','210030','331',305.00,360.00,0.00,5295.40,1800436.00,1910166.00,109730.00,606331),('1','140','210246','331',340.00,400.00,0.00,6798.30,2311422.00,2437832.00,126410.00,606886),('1','140','210360','331',340.00,400.00,0.00,3180.25,1081285.00,1143744.00,62459.00,607169),('1','140','210602','331',340.00,400.00,0.00,6574.50,2235330.00,2308172.00,72842.00,607815),('1','140','210855','331',340.00,400.00,0.00,6995.20,2378368.00,2464436.00,86068.00,608469),('1','140','210938','331',340.00,400.00,0.00,8480.50,2883370.00,2996776.00,113406.00,608697),('1','140','211349','331',340.00,400.00,0.00,9128.50,3103690.00,3201364.00,97674.00,609761),('1','140','211368','331',340.00,400.00,0.00,24710.50,8401570.00,8765516.00,363946.00,609806),('1','140','212836','331',340.00,400.00,0.00,8043.00,2734620.00,2931135.00,196515.00,613636),('1','140','212880','331',340.00,400.00,0.00,11210.50,3811570.00,4066627.50,255057.50,613739),('1','140','213134','331',340.00,400.00,0.00,5274.00,1793160.00,1913180.00,120020.00,614405),('1','140','213277','331',340.00,400.00,0.00,698.50,237490.00,260185.00,22695.00,614772),('1','140','213391','331',340.00,400.00,0.00,6779.98,2305193.20,2467198.95,162005.75,615067),('1','140','213624','331',340.00,400.00,0.00,8258.01,2807723.40,2993471.15,185747.75,615696),('1','140','213875','331',340.00,400.00,0.00,2865.50,974270.00,1051350.00,77080.00,616353),('1','140','214085','331',340.00,400.00,0.00,6024.50,2048330.00,2178150.00,129820.00,616900),('1','140','214220','331',340.00,400.00,0.00,2970.30,1009902.00,1083455.50,73553.50,617238),('1','140','214379','331',340.00,400.00,0.00,3428.05,1165537.00,1253492.50,87955.50,617648),('1','140','214523','331',340.00,400.00,0.00,6282.32,2135988.80,2286599.30,150610.50,618028),('1','140','214771','331',340.00,400.00,0.00,11627.42,3953322.80,4222989.55,269666.75,618675),('1','140','214993','331',340.00,400.00,0.00,2702.80,918952.00,996700.00,77748.00,619258),('1','140','215229','331',340.00,400.00,0.00,8943.00,3040620.00,3250992.50,210372.50,619854),('1','140','215441','331',340.00,400.00,0.00,12824.20,4360228.00,4639589.25,279361.25,620402),('1','140','215849','331',340.00,400.00,0.00,9412.00,3218440.00,3409670.00,191230.00,621450),('1','140','216053','331',358.00,400.00,0.00,3191.50,1142557.00,1216994.00,74437.00,621984),('1','140','216116','331',358.00,420.00,0.00,5648.47,2022152.26,2142101.40,119949.14,622140),('1','140','216339','331',358.00,420.00,0.00,6452.16,2309873.28,2441485.60,131612.32,622715),('1','140','216482','331',358.00,420.00,0.00,9057.59,3242617.22,3428807.30,186190.08,623108),('1','140','216597','331',370.00,420.00,0.00,5205.71,1926112.70,1998403.20,72290.50,623399),('1','140','216878','331',370.00,420.00,0.00,8186.28,3028923.60,3131027.60,102104.00,624144),('1','140','217111','331',370.00,420.00,0.00,2321.00,858770.00,888420.00,29650.00,624752),('1','140','217357','331',370.00,420.00,0.00,0.00,0.00,0.00,0.00,625406),('1','140','217358','331',370.00,420.00,0.00,937.90,347023.00,393503.50,46480.50,625407),('1','140','217363','331',370.00,460.00,0.00,3346.19,1238090.30,1395752.40,157662.10,625418),('1','140','217542','331',370.00,460.00,0.00,3947.26,1531466.20,1635499.60,104033.40,625871),('1','140','217768','331',400.00,460.00,0.00,4530.58,1812232.00,1876299.30,64067.30,626466),('1','140','218058','331',400.00,460.00,0.00,10917.03,4366812.00,4492898.80,126086.80,627232),('1','140','218325','331',400.00,460.00,0.00,752.00,300800.00,314157.50,13357.50,627941),('1','140','218547','331',400.00,460.00,0.00,0.00,0.00,0.00,0.00,628518),('1','140','218552','331',400.00,460.00,0.00,1935.00,774000.00,803370.00,29370.00,628531),('1','140','218556','331',400.00,460.00,0.00,3513.41,1405364.00,1459078.60,53714.60,628540),('1','140','218765','331',400.00,460.00,0.00,3048.31,1219324.00,1265962.60,46638.60,629077),('1','140','218961','331',400.00,460.00,0.00,4440.06,1776024.00,1844951.10,68927.10,629596),('1','140','219170','331',400.00,460.00,0.00,2363.77,945508.00,979614.20,34106.20,630135),('1','140','219324','331',400.00,460.00,0.00,9240.94,3696376.00,3799804.90,103428.90,630556),('1','140','219587','331',400.00,460.00,0.00,5106.31,2042524.00,2114657.60,72133.60,631243),('1','140','219792','331',400.00,460.00,0.00,6609.12,2643648.00,2725157.70,81509.70,631791),('1','140','220024','331',400.00,460.00,0.00,2605.13,1042052.00,1090237.30,48185.30,632408),('1','140','220274','331',400.00,460.00,0.00,10134.05,4053620.00,4178465.50,124845.50,633040),('1','140','220603','331',400.00,460.00,0.00,4685.90,1874360.00,1938876.50,64516.50,633918),('1','140','221013','331',400.00,460.00,0.00,1471.70,588680.00,617312.00,28632.00,634982),('1','140','221018','331',400.00,460.00,0.00,5976.57,2390628.00,2469614.70,78986.70,634993),('1','140','221166','331',400.00,460.00,0.00,9392.23,3756892.00,3862343.80,105451.80,635362),('1','140','221548','331',400.00,460.00,0.00,1924.11,769644.00,797620.60,27976.60,636378),('1','140','221611','331',400.00,460.00,0.00,7118.10,2847240.00,2939386.00,92146.00,636543),('1','140','221826','331',400.00,460.00,0.00,2941.47,1176588.00,1228661.20,52073.20,637104),('1','140','222052','331',400.00,460.00,0.00,4528.50,1811400.00,1881129.50,69729.50,637697),('1','140','222303','331',400.00,460.00,0.00,3906.84,1562736.00,1621073.90,58337.90,638321),('1','140','222538','331',400.00,460.00,0.00,4245.31,1698124.00,1750712.60,52588.60,638922),('1','140','222614','331',400.00,460.00,0.00,735.07,294028.00,303327.20,9299.20,639138),('1','140','223004','331',400.00,460.00,0.00,5133.70,2053480.00,2122727.00,69247.00,640183),('1','140','223146','331',400.00,460.00,0.00,14577.00,5830800.00,6009892.50,179092.50,640560),('1','140','223265','331',400.00,460.00,0.00,4257.20,1702880.00,1755542.00,52662.00,640819),('1','140','223473','331',400.00,460.00,0.00,6065.40,2536070.00,2503924.00,-32146.00,641346),('1','140','223488','331',429.00,460.00,0.00,9059.27,3886426.83,3862253.20,-24173.63,641388),('1','140','223775','331',429.00,460.00,0.00,9580.14,4109880.06,4233070.40,123190.34,642131),('1','140','223996','331',429.00,460.00,0.00,4091.54,1755270.66,1817173.20,61902.54,642699),('1','140','224076','331',429.00,480.00,0.00,14705.50,6308659.50,6511000.24,202340.74,642910),('1','140','224370','331',429.00,480.00,0.00,5717.84,2452953.36,2712829.40,259876.04,643661),('1','140','224690','331',429.00,510.00,0.00,1754.23,752564.67,838062.30,85497.63,644514),('1','140','224771','331',429.00,510.00,0.00,7001.44,3003617.76,3319204.40,315586.64,644715),('1','140','225012','331',429.00,510.00,0.00,3741.03,1604901.87,1778070.30,173168.43,645329),('1','140','225258','331',429.00,510.00,0.00,4894.43,2099710.47,2255026.30,155315.83,645970),('1','140','225548','331',429.00,510.00,0.00,7055.80,3026938.20,3183378.00,156439.80,646713),('1','140','225823','331',429.00,510.00,0.00,12591.89,5401920.81,5723708.90,321788.09,647429),('1','140','226067','331',429.00,510.00,0.00,4157.49,1783563.21,1969537.25,185974.04,648063),('1','140','226317','331',429.00,510.00,0.00,3954.24,1696368.96,1853665.50,157296.54,648712),('1','140','226479','331',429.00,510.00,0.00,1945.35,834555.15,910998.50,76443.35,649120),('1','140','226772','331',429.00,510.00,0.00,1985.95,851972.55,924890.28,72917.73,649869),('1','140','226898','331',429.00,510.00,0.00,3597.16,1543181.64,1666128.80,122947.16,650223),('1','140','226991','331',429.00,510.00,0.00,7076.82,3255244.20,3284266.20,29022.00,650450),('1','140','227221','331',460.00,510.00,0.00,2855.88,1313704.80,1328899.40,15194.60,651044),('1','140','227373','331',460.00,510.00,0.00,11079.12,5096395.20,5128718.20,32323.00,651433),('1','140','227685','331',460.00,510.00,0.00,5202.98,2399751.20,2422182.30,22431.10,652238),('1','140','227885','331',465.00,510.00,0.00,6246.74,2904734.10,2952732.40,47998.30,652754),('1','140','228146','331',465.00,510.00,0.00,8114.41,3773200.65,3839114.10,65913.45,653448),('1','140','228409','331',465.00,510.00,0.00,4351.46,2023428.90,2107450.10,84021.20,654127),('1','140','228543','331',465.00,530.00,0.00,503.58,234164.70,250047.40,15882.70,654462),('1','140','228657','331',465.00,530.00,0.00,2502.91,1163853.15,1239802.30,75949.15,654766),('1','140','228829','331',465.00,530.00,0.00,1127.30,524194.50,563469.00,39274.50,655197),('1','140','229072','331',465.00,530.00,0.00,4819.41,2273100.93,2365606.10,92505.17,655832),('1','140','229170','331',473.00,530.00,0.00,11963.61,5658787.53,5858942.70,200155.17,656097),('1','140','229454','331',473.00,530.00,0.00,4170.00,1972410.00,2095613.50,123203.50,656814),('1','140','229665','331',473.00,560.00,0.00,2114.53,1000172.69,1092975.16,92802.47,657361),('1','140','229874','331',473.00,560.00,0.00,1588.98,751587.54,821944.80,70357.26,657908),('1','140','230081','331',473.00,560.00,0.00,4686.73,2299287.11,2402315.62,103028.51,658437),('1','140','230272','331',502.00,560.00,0.00,2971.03,1491457.06,1534738.27,43281.21,658935),('1','140','230514','331',502.00,560.00,0.00,6172.76,3098725.52,3161759.60,63034.08,659560),('1','140','230769','331',502.00,560.00,0.00,3358.02,1685726.04,1731730.17,46004.13,660227),('1','140','231045','331',502.00,560.00,0.00,3745.00,1879990.00,1902460.00,22470.00,660962),('1','140','231398','331',502.00,560.00,0.00,2314.09,1161673.18,1196690.40,35017.22,661878),('1','140','231632','331',502.00,560.00,0.00,3453.78,1733797.56,1775056.40,41258.84,662503),('1','140','231876','331',502.00,560.00,0.00,5509.24,2765638.48,2818828.90,53190.42,663172),('1','140','232133','331',502.00,560.00,0.00,9256.14,4646582.28,4720708.60,74126.32,663837),('1','140','232378','331',502.00,560.00,0.00,8009.54,4020789.08,4095522.40,74733.32,664463),('1','140','232624','331',502.00,560.00,0.00,6813.67,3420462.34,3491711.91,71249.57,665118),('1','140','232825','331',502.00,560.00,0.00,9781.22,4910172.44,4992937.30,82764.86,665676),('1','140','233116','331',502.00,560.00,0.00,8547.23,4305909.46,4396869.00,90959.54,666417),('1','140','233427','331',540.00,560.00,0.00,1990.96,1075118.40,1111865.00,36746.60,667227),('1','140','233608','331',540.00,600.00,0.00,3114.51,1681835.40,1723861.00,42025.60,667711),('1','140','233846','331',540.00,600.00,0.00,1503.66,811976.40,835496.00,23519.60,668334),('1','140','234040','331',540.00,600.00,0.00,2580.06,1393232.40,1425936.00,32703.60,668854),('1','140','234291','331',540.00,600.00,0.00,6556.83,3540688.20,3591504.00,50815.80,669524),('1','140','234598','331',540.00,600.00,0.00,1923.27,1038565.80,1068443.00,29877.20,670319),('1','140','234803','331',540.00,600.00,0.00,5412.50,2922750.00,2974496.00,51746.00,670883),('1','140','235133','331',540.00,600.00,0.00,5550.98,2997529.20,3052328.00,54798.80,671750),('1','140','235290','331',540.00,600.00,0.00,6536.83,3529888.20,3596893.00,67004.80,672164),('1','140','235577','331',540.00,600.00,0.00,5029.17,2715751.80,2751134.00,35382.20,672890),('1','140','235845','331',540.00,600.00,0.00,7221.77,3899755.80,3964553.00,64797.20,673590),('1','140','236025','331',540.00,600.00,0.00,4602.01,2485085.40,2554163.64,69078.24,674069),('1','140','236259','331',540.00,600.00,0.00,6371.44,3440577.60,3538152.00,97574.40,674678),('1','140','236530','331',540.00,600.00,0.00,4047.94,2185887.60,2279446.80,93559.20,675399),('1','140','236733','331',540.00,600.00,0.00,2393.00,1292220.00,1354080.00,61860.00,675928),('1','140','236879','331',540.00,600.00,0.00,4168.60,2251044.00,2383760.00,132716.00,676312),('1','140','236952','331',540.00,600.00,0.00,7796.31,4210007.40,4507100.20,297092.80,676497),('1','140','237226','331',540.00,620.00,0.00,3259.36,1760054.40,1897727.20,137672.80,677193),('1','140','237365','331',540.00,620.00,0.00,9509.74,5135259.60,5501432.40,366172.80,677566),('1','140','237617','331',540.00,620.00,0.00,4275.32,2308672.80,2489676.40,181003.60,678212),('1','140','237863','331',540.00,620.00,0.00,4482.37,2420479.80,2602961.22,182481.42,678860),('1','140','238180','331',565.00,620.00,0.00,2870.59,1621883.35,1676602.80,54719.45,679663),('1','140','238335','331',565.00,620.00,0.00,5105.95,2884861.75,2965901.40,81039.65,680080),('1','140','238597','331',565.00,620.00,0.00,4219.26,2383881.90,2451118.40,67236.50,680766),('1','140','238949','331',565.00,620.00,0.00,3655.20,2065188.00,2112348.00,47160.00,681663),('1','140','239349','331',565.00,620.00,0.00,7619.59,4305068.35,4460371.10,155302.75,682699),('1','140','239590','331',565.00,620.00,0.00,6051.10,3418871.50,3565700.40,146828.90,683331),('1','140','239770','331',565.00,620.00,0.00,2930.63,1655805.95,1730582.40,74776.45,683806),('1','140','239951','331',565.00,620.00,0.00,0.00,0.00,0.00,0.00,684286),('1','140','239995','331',565.00,620.00,0.00,8038.14,4541549.10,4721983.80,180434.70,684385),('1','140','240197','331',565.00,620.00,0.00,4811.62,2718565.30,2840266.20,121700.90,684912),('1','140','240532','331',565.00,620.00,0.00,2285.36,1291228.40,1351044.20,59815.80,685776),('1','140','240750','331',565.00,620.00,0.00,2720.26,1536946.90,1610078.20,73131.30,686295),('1','140','241017','331',565.00,620.00,0.00,2973.70,1680140.50,1754418.40,74277.90,687017),('1','140','241268','331',565.00,620.00,0.00,3347.37,1891264.05,1972307.00,81042.95,687668),('1','140','241505','331',565.00,620.00,0.00,7762.00,4385530.00,4552554.00,167024.00,688308),('1','140','241846','331',565.00,620.00,0.00,2453.10,1386001.50,1452648.00,66646.50,689206),('1','140','241989','331',565.00,620.00,0.00,2899.95,1638471.75,1712330.00,73858.25,689583),('1','140','242247','331',565.00,620.00,0.00,3149.71,1779586.15,1856477.00,76890.85,690245),('1','140','242410','331',565.00,620.00,0.00,1641.06,927198.90,967339.20,40140.30,690683),('1','140','242693','331',565.00,620.00,0.00,2960.20,1672513.00,1719780.00,47267.00,691397),('1','140','242920','331',565.00,620.00,0.00,2997.60,1693644.00,1740004.00,46360.00,691999),('1','140','243141','331',565.00,620.00,0.00,8606.80,4862842.00,4935755.60,72913.60,692577),('1','140','243370','331',565.00,620.00,0.00,0.00,0.00,0.00,0.00,693185),('1','140','243377','331',565.00,620.00,0.00,3766.17,2127886.05,2182807.40,54921.35,693198),('1','140','243595','331',565.00,620.00,0.00,2839.00,1604035.00,1652040.96,48005.96,693757),('1','140','243893','331',565.00,620.00,0.00,2533.37,1431354.05,1470105.40,38751.35,694529),('1','140','244049','331',565.00,620.00,0.00,5944.65,3358727.25,3421671.00,62943.75,694925),('1','140','244274','331',565.00,620.00,0.00,2767.59,1563688.35,1601603.80,37915.45,695525),('1','140','244541','331',565.00,620.00,0.00,6714.85,3793890.25,3857583.00,63692.75,696202),('1','140','244721','331',565.00,620.00,0.00,2069.41,1169216.65,1206860.20,37643.55,696697),('1','140','245009','331',565.00,620.00,0.00,3469.10,1960041.50,1957002.00,-3039.50,697416),('1','140','245220','331',565.00,620.00,0.00,6327.41,3574986.65,3555602.20,-19384.45,697968),('1','140','245480','331',565.00,620.00,0.00,2756.46,1557399.90,1549497.20,-7902.70,698633),('1','140','245669','331',565.00,620.00,0.00,3251.30,1836984.50,1827572.00,-9412.50,699136),('1','140','245928','331',540.00,600.00,0.00,6633.50,3582090.00,3634472.00,52382.00,699813),('1','140','246185','331',540.00,600.00,0.00,5581.67,2956413.72,3070600.00,114186.28,700467),('1','140','246482','331',528.00,600.00,0.00,2709.21,1430462.88,1500751.00,70288.12,701245),('1','140','246697','331',528.00,600.00,0.00,2506.74,1323558.72,1388807.00,65248.28,701823),('1','140','246934','331',528.00,600.00,0.00,4598.40,2427955.20,2535574.50,107619.30,702429),('1','140','247196','331',528.00,600.00,0.00,2285.50,1206744.00,1260807.00,54063.00,703093),('1','140','247377','331',528.00,600.00,0.00,6821.30,3601646.40,3629286.00,27639.60,703578),('1','140','247668','331',528.00,600.00,0.00,3245.84,1687673.39,1742161.00,54487.61,704327),('1','140','247885','331',515.00,600.00,0.00,4975.80,2562537.00,2655238.80,92701.80,704894),('1','140','248154','331',515.00,600.00,0.00,4006.99,2063599.85,2141536.00,77936.15,705580),('1','140','248385','331',515.00,600.00,0.00,6949.92,3579208.80,3708521.60,129312.80,706190),('1','140','248653','331',515.00,600.00,0.00,5232.36,2694665.40,2767597.40,72932.00,706850),('1','140','248936','331',515.00,600.00,0.00,2618.40,1348476.00,1369680.00,21204.00,707580),('1','140','249105','331',515.00,600.00,0.00,1970.50,1014807.50,1048980.00,34172.50,708028),('1','140','249371','331',515.00,600.00,0.00,3158.34,1626545.10,1663812.00,37266.90,708685),('1','140','249606','331',515.00,600.00,0.00,4087.01,2104810.15,2134392.00,29581.85,709296),('1','140','249858','331',515.00,600.00,0.00,3759.73,1936260.95,1973150.00,36889.05,709945),('1','140','250095','331',515.00,600.00,0.00,4348.50,2239477.50,2273148.00,33670.50,710557),('1','140','250337','331',515.00,600.00,0.00,4541.40,2338821.00,2322600.00,-16221.00,711173),('1','140','250389','331',515.00,600.00,0.00,4299.09,2214031.35,2191742.00,-22289.35,711288),('1','140','250627','331',515.00,600.00,0.00,4621.27,2379954.05,2339652.00,-40302.05,711897),('1','140','250787','331',515.00,600.00,0.00,6467.17,3330592.55,3278934.00,-51658.55,712341),('1','140','251022','331',515.00,600.00,0.00,4013.84,2067127.60,2044646.00,-22481.60,712935),('1','140','251273','331',515.00,600.00,0.00,4656.13,2397906.95,2350580.60,-47326.35,713591),('1','140','251523','331',515.00,600.00,0.00,3123.52,1608612.80,1601033.00,-7579.80,714243),('1','140','251768','331',515.00,600.00,0.00,4582.34,2248904.85,2333962.00,85057.15,714884),('1','140','251988','331',490.00,600.00,0.00,3366.83,1649746.70,1737056.00,87309.30,715474),('1','140','252248','331',490.00,600.00,0.00,4334.17,2123743.30,2207219.00,83475.70,716140),('1','140','252475','331',490.00,600.00,0.00,9017.50,4418575.00,4545418.00,126843.00,716733),('1','140','252714','331',490.00,600.00,0.00,3143.83,1540476.70,1613925.00,73448.30,717353),('1','140','252961','331',490.00,600.00,0.00,3056.84,1497851.60,1577398.00,79546.40,717999),('1','140','253213','331',490.00,600.00,0.00,2050.85,1004916.50,1060168.00,55251.50,718655),('1','140','253455','331',490.00,600.00,0.00,4483.50,2196915.00,2282486.00,85571.00,719293),('1','140','253700','331',490.00,600.00,0.00,10634.17,5210743.30,5381294.00,170550.70,719923),('1','140','253952','331',490.00,600.00,0.00,749.97,367485.30,383774.74,16289.44,720572),('1','140','254500','331',490.00,600.00,0.00,3532.33,1725822.55,1822358.00,96535.45,721971),('1','140','254680','331',485.00,600.00,0.00,2.00,970.00,1200.00,230.00,722454),('1','140','254729','331',485.00,600.00,0.00,0.00,0.00,0.00,0.00,722551),('1','140','254738','331',485.00,600.00,0.00,0.00,0.00,0.00,0.00,722572),('1','140','254742','331',485.00,600.00,0.00,0.00,0.00,0.00,0.00,722580),('1','140','254745','331',485.00,600.00,0.00,0.00,0.00,0.00,0.00,722585),('1','140','254748','331',485.00,600.00,0.00,0.00,0.00,0.00,0.00,722592),('1','140','254750','331',485.00,600.00,0.00,0.00,0.00,0.00,0.00,722596),('1','140','254753','331',485.00,600.00,0.00,3606.23,1749021.55,1850085.38,101063.83,722602),('1','140','254935','331',485.00,600.00,0.00,4586.77,2224583.45,2334966.00,110382.55,723098),('1','140','255185','331',485.00,600.00,0.00,8615.51,4178522.35,4362654.00,184131.65,723745),('1','140','255459','331',485.00,600.00,0.00,3859.65,1871930.25,1974619.80,102689.55,724420),('1','140','255763','331',485.00,600.00,0.00,0.00,0.00,0.00,0.00,725160),('1','140','255871','331',485.00,600.00,0.00,1994.84,967497.40,1019897.00,52399.60,725444),('1','140','255942','331',485.00,600.00,0.00,3964.36,1922714.60,2030701.20,107986.60,725631),('1','140','256200','331',485.00,600.00,0.00,5335.87,2587896.95,2707318.00,119421.05,726268),('1','140','256484','331',485.00,600.00,0.00,3113.88,1510231.80,1599614.00,89382.20,726999),('1','140','256726','331',485.00,600.00,0.00,2912.27,1412450.95,1482457.00,70006.05,727627),('1','140','256963','331',485.00,600.00,0.00,2458.16,1192207.60,1267018.00,74810.40,728251),('1','140','257228','331',485.00,600.00,0.00,2457.90,1192081.50,1257312.00,65230.50,728944),('1','140','257532','331',485.00,600.00,0.00,2220.00,1076700.00,1098790.00,22090.00,729718),('1','140','257541','331',485.00,600.00,0.00,0.00,0.00,0.00,0.00,729740),('1','140','257544','331',485.00,600.00,0.00,4641.80,2212855.00,2286794.00,73939.00,729744),('1','140','257545','331',475.00,600.00,0.00,2934.18,1393735.50,1465108.00,71372.50,729745),('1','140','257546','331',475.00,600.00,0.00,3810.00,1809750.00,1886706.00,76956.00,729746),('1','140','257547','331',475.00,600.00,0.00,3030.94,1439696.50,1500369.00,60672.50,729747),('1','140','257548','331',475.00,550.00,0.00,2974.02,1412659.50,1468675.00,56015.50,729748),('1','140','257549','331',475.00,550.00,0.00,6904.95,3279851.25,3368260.50,88409.25,729749),('1','140','257550','331',475.00,550.00,0.00,0.00,0.00,0.00,0.00,729750),('1','140','257551','331',475.00,550.00,0.00,271.06,128753.50,147998.76,19245.26,729751),('1','140','257552','331',475.00,550.00,0.00,6385.43,3033079.25,3141526.50,108447.25,729752),('1','140','257553','331',475.00,550.00,0.00,3530.95,1677201.25,1741082.50,63881.25,729753),('1','140','257554','331',475.00,550.00,0.00,4180.41,1985694.75,2059023.90,73329.15,729754),('1','140','257555','331',475.00,550.00,0.00,2802.42,1331149.50,1382431.00,51281.50,729755),('1','140','257556','331',475.00,550.00,0.00,3997.60,1898860.00,1968910.00,70050.00,729756),('1','140','257557','331',475.00,550.00,0.00,3511.50,1667962.50,1715397.00,47434.50,729757),('1','140','257558','331',475.00,550.00,0.00,0.00,0.00,0.00,0.00,729758),('1','140','257559','331',480.00,550.00,0.00,0.00,0.00,0.00,0.00,729759),('1','140','257560','331',480.00,550.00,0.00,3248.70,1559376.00,1602053.00,42677.00,729760),('1','140','257561','331',480.00,550.00,0.00,3973.50,1907280.00,1954065.00,46785.00,729761),('1','140','257562','331',480.00,550.00,0.00,9136.55,4385544.00,4480482.50,94938.50,729762),('1','140','257563','331',480.00,550.00,0.00,2122.30,1018704.00,1058545.00,39841.00,729763),('1','140','257564','331',480.00,550.00,0.00,5706.50,2739120.00,2810135.00,71015.00,729764),('1','140','257565','331',480.00,550.00,0.00,256.11,122932.80,127576.50,4643.70,729765),('1','140','257566','331',480.00,550.00,0.00,0.00,0.00,0.00,0.00,729766),('1','140','257567','331',485.00,550.00,0.00,2598.26,1260156.10,1319793.00,59636.90,729767),('1','140','257568','331',485.00,550.00,0.00,3343.17,1621437.45,1686593.50,65156.05,729768),('1','140','257569','331',485.00,550.00,0.00,1759.05,853139.25,887952.50,34813.25,729769),('1','140','257570','331',485.00,550.00,0.00,2990.32,1450305.20,1507926.00,57620.80,729770),('1','140','257571','331',485.00,550.00,0.00,6239.18,3026002.30,3120199.00,94196.70,729771),('1','140','257572','331',485.00,550.00,0.00,5375.64,2607185.40,2686114.00,78928.60,729772),('1','140','257573','331',485.00,550.00,0.00,2000.09,970043.65,1006699.50,36655.85,729773),('1','140','257574','331',485.00,550.00,0.00,0.00,0.00,0.00,0.00,729774),('1','140','257575','331',495.00,550.00,0.00,643.44,318502.80,335976.00,17473.20,729775),('1','140','257576','331',495.00,550.00,0.00,2832.82,1402245.90,1457631.00,55385.10,729776),('1','140','257577','331',495.00,550.00,0.00,1727.55,855137.25,889592.50,34455.25,729777),('1','140','257578','331',495.00,550.00,0.00,2957.64,1464031.80,1521062.00,57030.20,729778),('1','140','257579','331',495.00,550.00,0.00,1671.09,827189.55,863659.50,36469.95,729779),('1','140','257580','331',495.00,550.00,0.00,2863.59,1417477.05,1465800.90,48323.85,729780),('1','140','257581','331',495.00,550.00,0.00,4257.70,2107561.50,2176123.00,68561.50,729781),('1','140','257582','331',495.00,550.00,0.00,1335.50,661072.50,689505.00,28432.50,729782),('1','140','257583','331',495.00,550.00,0.00,5041.88,2495730.60,2591834.00,96103.40,729783),('1','140','257584','331',495.00,550.00,0.00,909.64,450271.80,469142.00,18870.20,729784),('1','140','257585','331',495.00,550.00,0.00,0.00,0.00,0.00,0.00,729785),('1','140','257586','331',560.00,550.00,0.00,749.19,419546.40,439179.80,19633.40,729786),('1','140','257587','331',560.00,620.00,0.00,1176.89,659058.40,695751.80,36693.40,729787),('1','140','257588','331',560.00,620.00,0.00,793.60,444416.00,476792.00,32376.00,729788),('1','140','257589','331',560.00,620.00,0.00,489.14,273918.40,288466.80,14548.40,729789),('1','140','257590','331',560.00,620.00,0.00,432.37,242127.20,263029.40,20902.20,729790),('1','140','257591','331',560.00,620.00,0.00,571.19,319866.40,341737.80,21871.40,729791),('1','140','257592','331',560.00,620.00,0.00,714.03,399856.80,422148.60,22291.80,729792),('1','140','257593','331',560.00,620.00,0.00,1040.99,582954.40,610038.80,27084.40,729793),('1','140','257594','331',560.00,620.00,0.00,785.48,439868.80,462882.60,23013.80,729794),('1','140','257595','331',560.00,620.00,0.00,711.63,398512.80,423760.60,25247.80,729795),('1','140','257596','331',560.00,620.00,0.00,357.20,200032.00,212714.00,12682.00,729796),('1','140','257597','331',560.00,620.00,0.00,1100.43,616240.80,641618.60,25377.80,729797),('1','140','257598','331',560.00,620.00,0.00,1286.55,720468.00,745961.00,25493.00,729798),('1','140','257599','331',560.00,620.00,0.00,625.42,350235.20,369660.40,19425.20,729799),('1','140','257600','331',560.00,620.00,0.00,1409.88,789532.80,818718.10,29185.30,729800),('1','140','257601','331',560.00,620.00,0.00,1735.52,971891.20,1000639.90,28748.70,729801),('1','140','257602','331',560.00,620.00,0.00,2096.48,1174028.80,1210137.60,36108.80,729802),('1','140','257603','331',560.00,620.00,0.00,675.69,378386.40,391827.80,13441.40,729803),('1','140','257604','331',560.00,620.00,0.00,1557.23,872048.80,903225.10,31176.30,729804),('1','140','257605','331',560.00,620.00,0.00,1030.95,577332.00,602906.50,25574.50,729805),('1','140','257606','331',560.00,620.00,0.00,1020.30,571368.00,595286.00,23918.00,729806),('1','140','257607','331',560.00,620.00,0.00,2006.93,1123880.80,1163021.60,39140.80,729807),('1','140','257608','331',560.00,620.00,0.00,2156.03,1207376.80,1240723.60,33346.80,729808),('1','140','257609','331',560.00,620.00,0.00,0.00,0.00,0.00,0.00,729809),('1','140','257610','331',624.00,680.00,0.00,712.03,444306.72,466090.40,21783.68,729810),('1','140','257611','331',624.00,680.00,0.00,2127.32,1327447.68,1391227.60,63779.92,729811),('1','140','257612','331',624.00,680.00,0.00,2587.13,1614369.12,1689528.40,75159.28,729812),('1','140','257613','331',624.00,680.00,0.00,1127.34,703460.16,740521.20,37061.04,729813),('1','140','257614','331',624.00,680.00,0.00,1582.02,987180.48,1036503.60,49323.12,729814),('1','140','257615','331',624.00,680.00,0.00,1267.89,791163.36,832585.20,41421.84,729815),('1','140','257616','331',624.00,680.00,0.00,337.20,210412.80,223716.00,13303.20,729816),('1','140','257617','331',624.00,680.00,0.00,6152.79,3839340.96,3946937.20,107596.24,729817),('1','140','257618','331',624.00,680.00,0.00,1377.10,859310.40,889388.00,30077.60,729818),('1','140','257619','331',624.00,680.00,0.00,1255.13,783201.12,815048.40,31847.28,729819),('1','140','257620','331',624.00,680.00,0.00,2704.96,1687895.04,1742532.80,54637.76,729820),('1','140','257621','331',624.00,680.00,0.00,2157.68,1346392.32,1395762.40,49370.08,729821),('1','140','257622','331',624.00,680.00,0.00,880.58,549481.92,575618.00,26136.08,729822),('1','140','257623','331',624.00,680.00,0.00,40.20,25084.80,25728.00,643.20,729823),('1','140','257624','331',624.00,680.00,0.00,0.00,0.00,0.00,0.00,729824),('1','140','257625','331',624.00,680.00,0.00,1582.56,987517.44,1016672.80,29155.36,729825),('1','140','257626','331',624.00,680.00,0.00,2240.03,1397778.72,1450060.40,52281.68,729826),('1','140','257627','331',624.00,680.00,0.00,2932.78,1830054.72,1891570.40,61515.68,729827),('1','140','257628','331',624.00,680.00,0.00,6422.74,4007789.76,4122543.20,114753.44,729828),('1','140','257629','331',624.00,680.00,0.00,2410.12,1503914.88,1547141.60,43226.72,729829),('1','140','257630','331',624.00,680.00,0.00,4110.65,2565045.60,2685426.00,120380.40,729830),('1','140','257631','331',624.00,680.00,0.00,4884.11,3047684.64,3188432.80,140748.16,729831),('1','140','257632','331',624.00,680.00,0.00,0.00,0.00,0.00,0.00,729832),('1','140','257633','331',635.00,680.00,0.00,1306.36,829538.60,857804.80,28266.20,729833),('1','140','257634','331',635.00,680.00,0.00,1263.28,802182.80,832626.40,30443.60,729834),('1','140','257635','331',635.00,680.00,0.00,3120.50,1981517.50,2043568.00,62050.50,729835),('1','140','257636','331',635.00,680.00,0.00,1685.61,1070362.35,1108218.80,37856.45,729836),('1','140','257637','331',635.00,680.00,0.00,1907.08,1210995.80,1255514.40,44518.60,729837),('1','140','257638','331',635.00,680.00,0.00,415.37,263759.95,276487.60,12727.65,729838),('1','140','257639','331',635.00,680.00,0.00,1370.15,870045.25,904318.00,34272.75,729839),('1','140','257640','331',635.00,680.00,0.00,2495.33,1584534.55,1639312.40,54777.85,729840),('1','140','257641','331',635.00,680.00,0.00,2287.23,1452391.05,1501612.40,49221.35,729841),('1','140','257642','331',635.00,680.00,0.00,1851.24,1175537.40,1214183.20,38645.80,729842),('1','140','257643','331',635.00,680.00,0.00,6024.42,3825506.70,3937985.60,112478.90,729843),('1','140','257644','331',635.00,680.00,0.00,922.68,585901.80,607038.40,21136.60,729844),('1','140','257645','331',635.00,680.00,0.00,0.00,0.00,0.00,0.00,729845),('1','140','257646','331',635.00,680.00,0.00,97.40,61849.00,66232.00,4383.00,729846),('1','140','257647','331',635.00,680.00,0.00,2943.96,1869414.60,1925816.80,56402.20,729847),('1','140','257648','331',635.00,680.00,0.00,1295.01,822331.35,855574.80,33243.45,729848),('1','140','257649','331',635.00,680.00,0.00,2526.30,1604200.50,1657964.00,53763.50,729849),('1','140','257650','331',635.00,680.00,0.00,1485.21,943108.35,977630.80,34522.45,729850),('1','140','257651','331',635.00,680.00,0.00,1268.91,805757.85,835642.80,29884.95,729851),('1','140','257652','331',635.00,680.00,0.00,1326.87,842562.45,872283.60,29721.15,729852),('1','140','257653','331',635.00,680.00,0.00,1765.11,1120844.85,1166086.80,45241.95,729853),('1','140','257654','331',635.00,680.00,0.00,1385.95,880078.25,911044.00,30965.75,729854),('1','140','257655','331',635.00,680.00,0.00,1876.99,1191888.65,1222977.20,31088.55,729855),('1','140','257656','331',635.00,680.00,0.00,6727.64,4272051.40,4325015.20,52963.80,729856),('1','140','257657','331',635.00,680.00,0.00,1858.00,1179830.00,1199828.00,19998.00,729857),('1','140','257658','331',635.00,680.00,0.00,0.00,0.00,0.00,0.00,729858),('1','140','257659','331',620.00,680.00,0.00,1478.66,916769.20,962940.80,46171.60,729859),('1','140','257660','331',620.00,680.00,0.00,2428.50,1505670.00,1567604.00,61934.00,729860),('1','140','257661','331',620.00,680.00,0.00,2186.25,1355475.00,1415766.00,60291.00,729861),('1','140','257662','331',620.00,680.00,0.00,1672.55,1036981.00,1080442.00,43461.00,729862),('1','140','257663','331',620.00,680.00,0.00,2559.12,1586654.40,1647229.60,60575.20,729863),('1','140','257664','331',620.00,680.00,0.00,1608.14,997046.80,1038161.20,41114.40,729864),('1','140','257665','331',620.00,680.00,0.00,5111.50,3169130.00,3270868.00,101738.00,729865),('1','140','257666','331',620.00,680.00,0.00,3967.81,2460042.20,2545980.80,85938.60,729866),('1','140','257667','331',620.00,680.00,0.00,3548.70,2200194.00,2275858.00,75664.00,729867),('1','140','257668','331',620.00,680.00,0.00,0.00,0.00,0.00,0.00,729868),('1','140','257669','331',620.00,680.00,0.00,2346.48,1454817.60,1513062.40,58244.80,729869),('1','140','257670','331',620.00,680.00,0.00,3734.88,2315625.60,2383902.40,68276.80,729870),('1','140','257671','331',620.00,680.00,0.00,1858.39,1152201.80,1203733.20,51531.40,729871),('1','140','257672','331',620.00,680.00,0.00,1924.70,1193314.00,1243368.00,50054.00,729872),('1','140','257673','331',620.00,680.00,0.00,2258.36,1400183.20,1458336.80,58153.60,729873),('1','140','257674','331',620.00,680.00,0.00,2452.11,1520308.20,1574363.80,54055.60,729874),('1','140','257675','331',620.00,680.00,0.00,3163.06,1961097.20,2010355.80,49258.60,729875),('1','140','257676','331',620.00,680.00,0.00,3318.11,2057228.20,2104239.80,47011.60,729876),('1','140','257677','331',620.00,680.00,0.00,1145.36,710123.20,732864.80,22741.60,729877),('1','140','257678','331',620.00,680.00,0.00,2251.51,1395936.20,1430706.80,34770.60,729878),('1','140','257679','331',620.00,680.00,0.00,0.00,0.00,0.00,0.00,729879),('1','140','257680','331',610.00,680.00,0.00,5018.19,3061095.90,3158874.20,97778.30,729880),('1','140','257681','331',610.00,680.00,0.00,3509.25,2140642.50,2214140.00,73497.50,729881),('1','140','257682','331',610.00,680.00,0.00,1070.29,652876.90,693587.20,40710.30,729882),('1','140','257683','331',610.00,680.00,0.00,2304.00,1405440.00,1465190.00,59750.00,729883),('1','140','257684','331',610.00,680.00,0.00,2532.97,1545111.70,1614619.60,69507.90,729884),('1','140','257685','331',610.00,680.00,0.00,1859.54,1134319.40,1181932.20,47612.80,729885),('1','140','257686','331',610.00,680.00,0.00,1369.02,835102.20,883798.60,48696.40,729886),('1','140','257687','331',610.00,680.00,0.00,1742.74,1063071.40,1121648.20,58576.80,729887),('1','140','257688','331',610.00,680.00,0.00,3251.02,1983122.20,2056143.60,73021.40,729888),('1','140','257689','331',610.00,680.00,0.00,1683.13,1026709.30,1080123.40,53414.10,729889),('1','140','257690','331',610.00,680.00,0.00,0.00,0.00,0.00,0.00,729890),('1','140','257691','331',604.00,680.00,0.00,172.72,104322.88,115954.60,11631.72,729891),('1','140','257692','331',604.00,680.00,0.00,3467.95,2094641.80,2180918.50,86276.70,729892),('1','140','257693','331',604.00,680.00,0.00,1635.97,988125.88,1035499.60,47373.72,729893),('1','140','257694','331',604.00,680.00,0.00,2466.56,1489802.24,1553045.80,63243.56,729894),('1','140','257695','331',604.00,680.00,0.00,2690.91,1625309.64,1682788.80,57479.16,729895),('1','140','257696','331',604.00,680.00,0.00,3069.43,1853935.72,1922404.90,68469.18,729896),('1','140','257697','331',604.00,680.00,0.00,247.37,149411.48,152806.60,3395.12,729897),('1','140','257698','331',604.00,680.00,0.00,0.00,0.00,0.00,0.00,729898),('1','140','257699','331',604.00,680.00,0.00,363.32,219445.28,233082.60,13637.32,729899),('1','140','257700','331',604.00,680.00,0.00,4358.35,2632443.40,2724120.50,91677.10,729900),('1','140','257701','331',604.00,680.00,0.00,4479.97,2705901.88,2778449.60,72547.72,729901),('1','140','257702','331',604.00,680.00,0.00,4212.72,2544482.88,2621809.60,77326.72,729902),('1','140','257703','331',604.00,680.00,0.00,6271.41,3787931.64,3881286.30,93354.66,729903),('1','140','257704','331',604.00,680.00,0.00,2872.94,1735255.76,1799419.20,64163.44,729904),('1','140','257705','331',604.00,680.00,0.00,2115.52,1277774.08,1316061.10,38287.02,729905),('1','140','257706','331',604.00,680.00,0.00,0.00,0.00,0.00,0.00,729906),('1','140','257707','331',604.00,680.00,0.00,3096.72,1870418.88,1938524.60,68105.72,729907),('1','140','257708','331',604.00,680.00,0.00,3936.53,2377664.12,2458635.40,80971.28,729908),('1','140','257709','331',604.00,680.00,0.00,4261.34,2573849.36,2644081.20,70231.84,729909),('1','140','257710','331',604.00,680.00,0.00,6069.24,3665820.96,3764025.70,98204.74,729910),('1','140','257711','331',604.00,680.00,0.00,7317.26,4419625.04,4527431.80,107806.76,729911),('1','140','257712','331',604.00,680.00,0.00,0.00,0.00,0.00,0.00,729912),('1','140','257713','331',604.00,680.00,0.00,4182.50,2526230.00,2671232.50,145002.50,729913),('1','140','257714','331',604.00,680.00,0.00,6451.63,3896784.52,4117288.40,220503.88,729914),('1','140','257715','331',604.00,680.00,0.00,6191.49,3739659.96,3952228.20,212568.24,729915),('1','140','257716','331',604.00,680.00,0.00,7570.58,4572630.32,4827864.40,255234.08,729916),('1','140','257717','331',604.00,680.00,0.00,308.30,186213.20,196684.00,10470.80,729917),('1','140','257718','331',604.00,680.00,0.00,0.00,0.00,0.00,0.00,729918),('1','140','257719','331',604.00,680.00,0.00,5268.21,3181998.84,3361140.30,179141.46,729919),('1','140','257720','331',604.00,680.00,0.00,9548.64,5767378.56,6097300.20,329921.64,729920),('1','140','257721','331',604.00,680.00,0.00,9903.58,5981762.32,6301511.90,319749.58,729921),('1','140','257722','331',604.00,680.00,0.00,0.00,0.00,0.00,0.00,729922),('1','140','257723','331',604.00,680.00,0.00,6165.36,3723877.44,3966124.80,242247.36,729923),('1','140','257724','331',604.00,680.00,0.00,10631.41,6421371.64,6827318.80,405947.16,729924),('1','140','257725','331',604.00,680.00,0.00,5726.45,3458775.80,3686106.00,227330.20,729925),('1','140','257726','331',604.00,680.00,0.00,1636.96,988723.84,1051380.80,62656.96,729926),('1','140','257727','331',604.00,680.00,0.00,15.00,9060.00,9600.00,540.00,729927),('1','140','257728','331',604.00,680.00,0.00,0.00,0.00,0.00,0.00,729928),('1','140','257729','331',604.00,680.00,0.00,7642.70,4616190.80,4913236.00,297045.20,729929),('1','140','257730','331',604.00,680.00,0.00,8378.28,5060481.12,5385670.40,325189.28,729930),('1','140','257731','331',604.00,680.00,0.00,5263.77,3179317.08,3383483.60,204166.52,729931),('1','140','257732','331',604.00,680.00,0.00,3179.53,1920436.12,2041620.40,121184.28,729932),('1','140','257733','331',604.00,680.00,0.00,0.00,0.00,0.00,0.00,729933),('1','140','257734','331',604.00,680.00,0.00,5956.60,3597786.40,3826608.00,228821.60,729934),('1','140','257735','331',604.00,680.00,0.00,6039.88,3648087.52,3884218.40,236130.88,729935),('1','140','257736','331',604.00,680.00,0.00,5238.46,3164029.84,3372752.80,208722.96,729936),('1','140','257737','331',604.00,680.00,0.00,6162.54,3722174.16,3958127.20,235953.04,729937),('1','140','257738','331',604.00,680.00,0.00,1327.56,801846.24,852960.80,51114.56,729938),('1','140','257739','331',604.00,680.00,0.00,0.00,0.00,0.00,0.00,729939),('1','140','257740','331',636.00,680.00,0.00,3774.58,2400632.88,2471581.00,70948.12,729940),('1','140','257741','331',636.00,700.00,0.00,6235.64,3965867.04,4073998.00,108130.96,729941),('1','140','257742','331',636.00,700.00,0.00,3670.57,2334482.52,2409599.00,75116.48,729942),('1','140','257743','331',636.00,700.00,0.00,3313.29,2107252.44,2169228.00,61975.56,729943),('1','140','257744','331',636.00,700.00,0.00,5003.10,3181971.60,3279770.00,97798.40,729944),('1','140','257745','331',636.00,700.00,0.00,2453.70,1560553.20,1605598.50,45045.30,729945),('1','140','257746','331',636.00,700.00,0.00,0.00,0.00,0.00,0.00,729946),('1','140','257747','331',636.00,700.00,0.00,1471.95,909917.55,967715.00,57797.45,729947),('1','140','257748','331',609.00,700.00,0.00,4784.03,2913474.27,3122121.00,208646.73,729948),('1','140','257749','331',609.00,700.00,0.00,2468.23,1503152.07,1623061.00,119908.93,729949),('1','140','257750','331',609.00,700.00,0.00,1833.21,1116424.89,1208522.00,92097.11,729950),('1','140','257751','331',609.00,700.00,0.00,2256.22,1374037.98,1466004.00,91966.02,729951),('1','140','257752','331',609.00,700.00,0.00,2834.84,1726417.56,1833170.00,106752.44,729952),('1','140','257753','331',609.00,700.00,0.00,2680.72,1632558.48,1747792.00,115233.52,729953),('1','140','257754','331',609.00,700.00,0.00,2295.52,1397971.68,1481004.00,83032.32,729954),('1','140','257755','331',609.00,700.00,0.00,3856.08,2348352.72,2471964.00,123611.28,729955),('1','140','257756','331',609.00,700.00,0.00,0.00,0.00,0.00,0.00,729956),('1','140','257757','331',609.00,700.00,0.00,3698.80,2252569.20,2386916.00,134346.80,729957),('1','140','257758','331',609.00,700.00,0.00,3645.56,2220146.04,2347478.00,127331.96,729958),('1','140','257759','331',609.00,700.00,0.00,2975.09,1811829.81,1931779.00,119949.19,729959),('1','140','257760','331',609.00,700.00,0.00,4129.91,2515115.19,2658933.00,143817.81,729960),('1','140','257761','331',609.00,700.00,0.00,2843.36,1731606.24,1849550.00,117943.76,729961),('1','140','257762','331',609.00,700.00,0.00,3635.31,2213903.79,2344085.00,130181.21,729962),('1','140','257763','331',609.00,700.00,0.00,3491.40,2126262.60,2248642.80,122380.20,729963),('1','140','257764','331',609.00,700.00,0.00,39.90,24299.10,25456.20,1157.10,729964),('1','140','257765','331',609.00,700.00,0.00,0.00,0.00,0.00,0.00,729965),('1','140','257766','331',614.00,700.00,0.00,6226.35,3822978.90,3992738.00,169759.10,729966),('1','140','257767','331',614.00,700.00,0.00,4667.01,2865544.14,3002787.00,137242.86,729967),('1','140','257768','331',614.00,700.00,0.00,2834.36,1740297.04,1833578.00,93280.96,729968),('1','140','257769','331',614.00,700.00,0.00,3794.65,2329915.10,2436899.00,106983.90,729969),('1','140','257770','331',614.00,700.00,0.00,4635.82,2846393.48,2991742.00,145348.52,729970),('1','140','257771','331',614.00,700.00,0.00,2520.34,1547488.76,1618389.20,70900.44,729971),('1','140','257772','331',614.00,700.00,0.00,0.00,0.00,0.00,0.00,729972),('1','140','257773','331',614.00,700.00,0.00,8190.02,5028672.28,5255242.00,226569.72,729973),('1','140','257774','331',614.00,700.00,0.00,10695.21,6566858.94,6847529.30,280670.36,729974),('1','140','257775','331',614.00,700.00,0.00,5108.65,3136711.10,3272856.40,136145.30,729975),('1','140','257776','331',614.00,700.00,0.00,0.00,0.00,0.00,0.00,729976),('1','140','257777','331',619.00,700.00,0.00,2810.19,1739507.61,1812411.00,72903.39,729977),('1','140','257778','331',619.00,700.00,0.00,10741.58,6649038.02,6897536.00,248497.98,729978),('1','140','257779','331',619.00,700.00,0.00,11079.00,6857901.00,7113330.00,255429.00,729979),('1','140','257780','331',619.00,700.00,0.00,0.00,0.00,0.00,0.00,729980),('1','140','257781','331',619.00,700.00,0.00,5031.37,3114418.03,3252919.00,138500.97,729981),('1','140','257782','331',619.00,700.00,0.00,7055.14,4367131.66,4545538.00,178406.34,729982),('1','140','257783','331',619.00,700.00,0.00,5706.71,3532453.49,3681677.00,149223.51,729983),('1','140','257784','331',619.00,700.00,0.00,6877.17,4256968.23,4431399.00,174430.77,729984),('1','140','257785','331',619.00,700.00,0.00,0.00,0.00,0.00,0.00,729985),('1','140','257786','331',619.00,700.00,0.00,10741.64,6649075.16,6934148.00,285072.84,729986),('1','140','257787','331',619.00,700.00,0.00,7215.94,4466666.86,4643668.00,177001.14,729987),('1','140','257788','331',619.00,700.00,0.00,5678.60,3515053.40,3649970.00,134916.60,729988),('1','140','257789','331',619.00,700.00,0.00,913.72,565592.68,591184.00,25591.32,729989),('1','140','257790','331',619.00,700.00,0.00,0.00,0.00,0.00,0.00,729990),('1','140','257791','331',619.00,700.00,0.00,5507.21,3408962.99,3554867.00,145904.01,729991),('1','140','257792','331',619.00,700.00,0.00,4441.66,2749387.54,2871412.00,122024.46,729992),('1','140','257793','331',619.00,700.00,0.00,9013.64,5579443.16,5796398.00,216954.84,729993),('1','140','257794','331',619.00,700.00,0.00,5550.95,3436038.05,3582665.00,146626.95,729994),('1','140','257795','331',619.00,700.00,0.00,0.00,0.00,0.00,0.00,729995),('1','140','257796','331',619.00,700.00,0.00,7332.51,4538823.69,4714077.00,175253.31,729996),('1','140','257797','331',619.00,700.00,0.00,11260.77,6970416.63,7239159.00,268742.37,729997),('1','140','257798','331',619.00,700.00,0.00,5903.95,3654545.05,3788017.00,133471.95,729998),('1','140','257799','331',619.00,700.00,0.00,0.00,0.00,0.00,0.00,729999),('1','140','257800','331',619.00,700.00,0.00,5716.18,3538315.42,3687286.00,148970.58,730000),('1','140','257801','331',619.00,700.00,0.00,5898.10,3650923.90,3800410.00,149486.10,730001),('1','140','257802','331',619.00,700.00,0.00,9393.73,5814718.87,6045421.00,230702.13,730002),('1','140','257803','331',619.00,700.00,0.00,3138.22,1942558.18,2026834.00,84275.82,730003),('1','140','257804','331',619.00,700.00,0.00,0.00,0.00,0.00,0.00,730004),('1','140','257805','331',619.00,700.00,0.00,5379.51,3329916.69,3468297.00,138380.31,730005),('1','140','257806','331',619.00,700.00,0.00,3807.66,2356941.54,2456562.00,99620.46,730006),('1','140','257807','331',619.00,700.00,0.00,4632.73,2867659.87,2991691.00,124031.13,730007),('1','140','257808','331',619.00,700.00,0.00,3713.30,2298532.70,2400650.00,102117.30,730008),('1','140','257809','331',619.00,700.00,0.00,5889.43,3645557.17,3803701.00,158143.83,730009),('1','140','257810','331',619.00,700.00,0.00,1057.70,654716.30,688910.00,34193.70,730010),('1','140','257811','331',619.00,700.00,0.00,0.00,0.00,0.00,0.00,730011),('1','140','257812','331',619.00,700.00,0.00,3843.57,2379169.83,2483079.00,103909.17,730012),('1','140','257813','331',619.00,700.00,0.00,3001.87,1858157.53,1943149.00,84991.47,730013),('1','140','257814','331',619.00,700.00,0.00,2998.94,1856343.86,1939598.00,83254.14,730014),('1','140','257815','331',619.00,680.00,0.00,4171.00,2581849.00,2643568.00,61719.00,730015),('1','140','257816','331',619.00,680.00,0.00,5393.83,3338780.77,3406244.40,67463.63,730016),('1','140','257817','331',619.00,680.00,0.00,4653.62,2880590.78,2949545.60,68954.82,730017),('1','140','257818','331',619.00,680.00,0.00,239.59,148306.21,151975.20,3668.99,730018),('1','140','257819','331',619.00,680.00,0.00,0.00,0.00,0.00,0.00,730019),('1','140','257820','331',597.00,680.00,0.00,2976.48,1776958.56,1869926.40,92967.84,730020),('1','140','257821','331',597.00,680.00,0.00,3887.10,2320598.70,2429388.00,108789.30,730021),('1','140','257822','331',597.00,680.00,0.00,7410.62,4424140.14,4621681.60,197541.46,730022),('1','140','257823','331',597.00,680.00,0.00,5798.18,3461513.46,3622032.40,160518.94,730023),('1','140','257824','331',597.00,680.00,0.00,3862.48,2305900.56,2422426.40,116525.84,730024),('1','140','257825','331',597.00,680.00,0.00,657.08,392276.76,411774.40,19497.64,730025),('1','140','257826','331',597.00,680.00,0.00,0.00,0.00,0.00,0.00,730026),('1','140','257827','331',597.00,680.00,0.00,3569.33,2130890.01,2234604.40,103714.39,730027),('1','140','257828','331',597.00,680.00,0.00,6087.27,3634100.19,3823503.60,189403.41,730028),('1','140','257829','331',597.00,680.00,0.00,5468.67,3264795.99,3421515.60,156719.61,730029),('1','140','257830','331',597.00,680.00,0.00,2926.38,1747048.86,1839398.40,92349.54,730030),('1','140','257831','331',597.00,680.00,0.00,5687.84,3395640.48,3553331.20,157690.72,730031),('1','140','257832','331',597.00,680.00,0.00,827.64,494101.08,515575.20,21474.12,730032),('1','140','257833','331',597.00,680.00,0.00,0.00,0.00,0.00,0.00,730033),('1','140','257834','331',597.00,680.00,0.00,4380.20,2614979.40,2738502.40,123523.00,730034),('1','140','257835','331',597.00,680.00,0.00,3038.95,1814253.15,1908356.00,94102.85,730035),('1','140','257836','331',597.00,680.00,0.00,4734.90,2826735.30,2959752.00,133016.70,730036),('1','140','257837','331',597.00,680.00,0.00,2907.08,1735526.76,1828974.40,93447.64,730037),('1','140','257838','331',597.00,680.00,0.00,3155.39,1883767.83,1977845.20,94077.37,730038),('1','140','257839','331',597.00,680.00,0.00,4309.53,2572789.41,2691500.40,118710.99,730039),('1','140','257840','331',597.00,680.00,0.00,1945.15,1161254.55,1223072.00,61817.45,730040),('1','140','257841','331',597.00,680.00,0.00,0.00,0.00,0.00,0.00,730041),('1','140','257842','331',597.00,680.00,0.00,3387.00,2022039.00,2132280.00,110241.00,730042),('1','140','257843','331',597.00,680.00,0.00,4084.90,2438685.30,2554052.00,115366.70,730043),('1','140','257844','331',597.00,680.00,0.00,5343.40,3190009.80,3341552.00,151542.20,730044),('1','140','257845','331',597.00,680.00,0.00,6249.32,3730844.04,3895387.60,164543.56,730045),('1','140','257846','331',597.00,680.00,0.00,5419.20,3235262.40,3381426.00,146163.60,730046),('1','140','257847','331',597.00,680.00,0.00,230.16,137405.52,147232.20,9826.68,730047),('1','140','257848','331',597.00,680.00,0.00,0.00,0.00,0.00,0.00,730048),('1','140','257849','331',597.00,680.00,0.00,5786.22,3454373.34,3605169.60,150796.26,730049),('1','140','257850','331',597.00,680.00,0.00,3416.25,2039501.25,2139810.00,100308.75,730050),('1','140','257851','331',597.00,680.00,0.00,5160.13,3080597.61,3234028.40,153430.79,730051),('1','140','257852','331',597.00,680.00,0.00,4683.95,2796318.15,2924716.00,128397.85,730052),('1','140','257853','331',597.00,680.00,0.00,4942.69,2950785.93,3088629.20,137843.27,730053),('1','140','257854','331',597.00,680.00,0.00,570.16,340385.52,357588.80,17203.28,730054),('1','140','257855','331',597.00,680.00,0.00,0.00,0.00,0.00,0.00,730055),('1','140','257856','331',597.00,680.00,0.00,5194.31,3101003.07,3260660.80,159657.73,730056),('1','140','257857','331',597.00,680.00,0.00,5272.62,3147754.14,3307791.60,160037.46,730057),('1','140','257858','331',597.00,680.00,0.00,4733.63,2825977.11,2968728.40,142751.29,730058),('1','140','257859','331',597.00,680.00,0.00,4259.10,2542682.70,2671893.00,129210.30,730059),('1','140','257860','331',597.00,680.00,0.00,3573.67,2133480.99,2251115.60,117634.61,730060),('1','140','257861','331',597.00,680.00,0.00,1597.98,953994.06,998426.40,44432.34,730061),('1','140','257862','331',597.00,680.00,0.00,0.00,0.00,0.00,0.00,730062),('1','140','257863','331',597.00,680.00,0.00,1222.46,729808.62,777152.80,47344.18,730063),('1','140','257864','331',597.00,680.00,0.00,2821.71,1684560.87,1777222.80,92661.93,730064),('1','140','257865','331',597.00,680.00,0.00,3437.34,2052091.98,2162197.20,110105.22,730065),('1','140','257866','331',597.00,680.00,0.00,2532.88,1512129.36,1591348.40,79219.04,730066),('1','140','257867','331',597.00,680.00,0.00,2674.22,1596509.34,1683529.60,87020.26,730067),('1','140','257868','331',597.00,680.00,0.00,2316.31,1382837.07,1462350.80,79513.73,730068),('1','140','257869','331',597.00,680.00,0.00,1148.14,685439.58,739875.20,54435.62,730069),('1','140','257870','331',597.00,680.00,0.00,4421.78,2639802.66,2767170.40,127367.74,730070),('1','140','257871','331',597.00,680.00,0.00,1531.12,914078.64,975161.60,61082.96,730071),('1','140','257872','331',597.00,680.00,0.00,2167.93,1294254.21,1358317.40,64063.19,730072),('1','140','257873','331',597.00,680.00,0.00,0.00,0.00,0.00,0.00,730073),('1','140','257874','331',597.00,680.00,0.00,3465.85,2017124.70,2118027.50,100902.80,730074),('1','140','257875','331',582.00,650.00,0.00,5304.49,3087213.18,3236283.50,149070.32,730075),('1','140','257876','331',582.00,650.00,0.00,4511.49,2625687.18,2753458.50,127771.32,730076),('1','140','257877','331',582.00,650.00,0.00,3101.78,1805235.96,1891979.50,86743.54,730077),('1','140','257878','331',582.00,650.00,0.00,5071.30,2951496.60,3091100.00,139603.40,730078),('1','140','257879','331',582.00,650.00,0.00,3056.55,1778912.10,1862085.00,83172.90,730079);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=309 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',308,'140','PRODUCT TANK','TANK CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=774 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','140','308',773,1,'331','LPG TANK',25000.00,1.00,1186.99,'TANK CONTAINING LPG','479','2020-08-10 22:40:16','2020-08-10 22:40:16','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','140',773,1069.17,'2023-03-17 13:24:02');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2682101 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2111222,'1','140','773',331,'Retail Sale Id 1255551',7750.00,0.00,0.00,0.00,687.50,'2021-12-01 09:13:37','',''),(2111223,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:13:37','',''),(2111232,'1','140','773',331,'Retail Sale Id 1255557',7750.00,0.00,0.00,0.00,687.50,'2021-12-01 09:14:08','',''),(2111233,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:14:08','',''),(2111240,'1','140','773',331,'Retail Sale Id 1255561',7750.00,0.00,0.00,0.00,687.50,'2021-12-01 09:14:36','',''),(2111241,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:14:36','',''),(2111256,'1','140','773',331,'Retail Sale Id 1255573',7750.00,0.00,0.00,0.00,687.50,'2021-12-01 09:15:36','',''),(2111257,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:15:36','',''),(2111324,'1','140','773',331,'Retail Sale Id 1255604',15500.00,0.00,0.00,0.00,1375.00,'2021-12-01 09:19:18','',''),(2111325,'1','140','773',331,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 09:19:18','',''),(2111478,'1','140','773',331,'Retail Sale Id 1255687',15500.00,0.00,0.00,0.00,1375.00,'2021-12-01 09:28:32','',''),(2111479,'1','140','773',331,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 09:28:32','',''),(2111506,'1','140','773',331,'Retail Sale Id 1255701',2480.00,0.00,0.00,0.00,220.00,'2021-12-01 09:30:13','',''),(2111507,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 09:30:13','',''),(2111514,'1','140','773',331,'Retail Sale Id 1255706',1860.00,0.00,0.00,0.00,165.00,'2021-12-01 09:31:11','',''),(2111515,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:31:11','',''),(2111599,'1','140','773',331,'Retail Sale Id 1255748',620.00,0.00,0.00,0.00,55.00,'2021-12-01 09:36:59','',''),(2111600,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 09:36:59','',''),(2111652,'1','140','773',331,'Retail Sale Id 1255783',1860.00,0.00,0.00,0.00,165.00,'2021-12-01 09:39:59','',''),(2111653,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:39:59','',''),(2112626,'1','140','773',331,'Retail Sale Id 1256259',3100.00,0.00,0.00,0.00,275.00,'2021-12-01 10:51:30','',''),(2112627,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 10:51:30','',''),(2112646,'1','140','773',331,'Retail Sale Id 1256273',1860.00,0.00,0.00,0.00,165.00,'2021-12-01 10:53:35','',''),(2112647,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 10:53:35','',''),(2112962,'1','140','773',331,'Retail Sale Id 1256425',1240.00,0.00,0.00,0.00,110.00,'2021-12-01 11:15:57','',''),(2112963,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 11:15:57','',''),(2113001,'1','140','773',331,'Retail Sale Id 1256442',11520.00,0.00,0.00,0.00,220.00,'2021-12-01 11:18:00','',''),(2113002,'1','140','773',331,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-01 11:18:00','',''),(2113018,'1','140','773',331,'Retail Sale Id 1256449',34560.00,0.00,0.00,0.00,660.00,'2021-12-01 11:18:45','',''),(2113019,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-01 11:18:45','',''),(2113040,'1','140','773',331,'Retail Sale Id 1256461',69120.00,0.00,0.00,0.00,1320.00,'2021-12-01 11:19:47','',''),(2113041,'1','140','773',331,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-01 11:19:47','',''),(2113156,'1','140','773',331,'Retail Sale Id 1256514',1860.00,0.00,0.00,0.00,165.00,'2021-12-01 11:26:36','',''),(2113157,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 11:26:36','',''),(2113208,'1','140','773',331,'Retail Sale Id 1256541',2480.00,0.00,0.00,0.00,220.00,'2021-12-01 11:30:32','',''),(2113209,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 11:30:32','',''),(2113236,'1','140','773',331,'Retail Sale Id 1256553',7502.00,0.00,0.00,0.00,665.50,'2021-12-01 11:33:09','',''),(2113237,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.10,0.00,'2021-12-01 11:33:09','',''),(2113351,'1','140','773',331,'Retail Sale Id 1256620',11520.00,0.00,0.00,0.00,220.00,'2021-12-01 11:41:37','',''),(2113352,'1','140','773',331,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-01 11:41:37','',''),(2113481,'1','140','773',331,'Retail Sale Id 1256686',1860.00,0.00,0.00,0.00,165.00,'2021-12-01 11:51:59','',''),(2113482,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 11:51:59','',''),(2113689,'1','140','773',331,'Retail Sale Id 1256798',4340.00,0.00,0.00,0.00,385.00,'2021-12-01 12:12:10','',''),(2113690,'1','140','773',331,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 12:12:10','',''),(2113885,'1','140','773',331,'Retail Sale Id 1256898',3720.00,0.00,0.00,0.00,330.00,'2021-12-01 12:23:43','',''),(2113886,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:23:43','',''),(2113997,'1','140','773',331,'Retail Sale Id 1256954',6200.00,0.00,0.00,0.00,550.00,'2021-12-01 12:33:36','',''),(2113998,'1','140','773',331,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 12:33:36','',''),(2114019,'1','140','773',331,'Retail Sale Id 1256965',34560.00,0.00,0.00,0.00,660.00,'2021-12-01 12:35:16','',''),(2114020,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-01 12:35:16','',''),(2114099,'1','140','773',331,'Retail Sale Id 1257006',3899.80,0.00,0.00,0.00,345.95,'2021-12-01 12:44:16','',''),(2114100,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.29,0.00,'2021-12-01 12:44:16','',''),(2114132,'1','140','773',331,'Retail Sale Id 1257019',1252.40,0.00,0.00,0.00,111.10,'2021-12-01 12:47:56','',''),(2114133,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.02,0.00,'2021-12-01 12:47:56','',''),(2114192,'1','140','773',331,'Retail Sale Id 1257053',1240.00,0.00,0.00,0.00,110.00,'2021-12-01 12:54:53','',''),(2114193,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 12:54:53','',''),(2114394,'1','140','773',331,'Retail Sale Id 1257185',1860.00,0.00,0.00,0.00,165.00,'2021-12-01 13:11:24','',''),(2114395,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 13:11:24','',''),(2114492,'1','140','773',331,'Retail Sale Id 1257237',1860.00,0.00,0.00,0.00,165.00,'2021-12-01 13:16:51','',''),(2114493,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 13:16:51','',''),(2114508,'1','140','773',331,'Retail Sale Id 1257244',13248.00,0.00,0.00,0.00,253.00,'2021-12-01 13:18:17','',''),(2114510,'1','140','773',331,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-01 13:18:17','',''),(2114534,'1','140','773',331,'Retail Sale Id 1257260',3100.00,0.00,0.00,0.00,275.00,'2021-12-01 13:20:24','',''),(2114535,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 13:20:24','',''),(2114550,'1','140','773',331,'Retail Sale Id 1257268',73152.00,0.00,0.00,0.00,1397.00,'2021-12-01 13:21:41','',''),(2114551,'1','140','773',331,'Retail sales',0.00,0.00,0.00,127.00,0.00,'2021-12-01 13:21:41','',''),(2114653,'1','140','773',331,'Retail Sale Id 1257318',54720.00,0.00,0.00,0.00,1045.00,'2021-12-01 13:30:12','',''),(2114654,'1','140','773',331,'Retail sales',0.00,0.00,0.00,95.00,0.00,'2021-12-01 13:30:12','',''),(2114689,'1','140','773',331,'Retail Sale Id 1257335',7750.00,0.00,0.00,0.00,687.50,'2021-12-01 13:33:24','',''),(2114690,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:33:24','',''),(2114845,'1','140','773',331,'Retail Sale Id 1257380',1240.00,0.00,0.00,0.00,110.00,'2021-12-01 13:41:23','',''),(2114846,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 13:41:23','',''),(2114864,'1','140','773',331,'Retail Sale Id 1257385',1240.00,0.00,0.00,0.00,110.00,'2021-12-01 13:41:55','',''),(2114865,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 13:41:55','',''),(2115138,'1','140','773',331,'Retail Sale Id 1257501',3720.00,0.00,0.00,0.00,330.00,'2021-12-01 13:57:44','',''),(2115139,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 13:57:44','',''),(2115168,'1','140','773',331,'Retail Sale Id 1257516',3503.00,0.00,0.00,0.00,310.75,'2021-12-01 13:59:02','',''),(2115169,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.65,0.00,'2021-12-01 13:59:02','',''),(2115293,'1','140','773',331,'Retail Sale Id 1257574',2480.00,0.00,0.00,0.00,220.00,'2021-12-01 14:05:35','',''),(2115294,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 14:05:35','',''),(2115325,'1','140','773',331,'Retail Sale Id 1257585',17280.00,0.00,0.00,0.00,330.00,'2021-12-01 14:07:43','',''),(2115326,'1','140','773',331,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-01 14:07:43','',''),(2115391,'1','140','773',331,'Retail Sale Id 1257633',63360.00,0.00,0.00,0.00,1210.00,'2021-12-01 14:12:26','',''),(2115392,'1','140','773',331,'Retail sales',0.00,0.00,0.00,110.00,0.00,'2021-12-01 14:12:26','',''),(2115479,'1','140','773',331,'Retail Sale Id 1257681',13248.00,0.00,0.00,0.00,253.00,'2021-12-01 14:18:47','',''),(2115480,'1','140','773',331,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-01 14:18:47','',''),(2115708,'1','140','773',331,'Retail Sale Id 1257796',23040.00,0.00,0.00,0.00,440.00,'2021-12-01 14:35:00','',''),(2115709,'1','140','773',331,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-01 14:35:00','',''),(2115782,'1','140','773',331,'Retail Sale Id 1257833',1860.00,0.00,0.00,0.00,165.00,'2021-12-01 14:40:12','',''),(2115783,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:40:12','',''),(2115887,'1','140','773',331,'Retail Sale Id 1257887',3720.00,0.00,0.00,0.00,330.00,'2021-12-01 14:49:16','',''),(2115888,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 14:49:16','',''),(2116203,'1','140','773',331,'Retail Sale Id 1258006',57600.00,0.00,0.00,0.00,1100.00,'2021-12-01 15:07:41','',''),(2116204,'1','140','773',331,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-01 15:07:41','',''),(2116223,'1','140','773',331,'Retail Sale Id 1258022',380160.00,0.00,0.00,0.00,7260.00,'2021-12-01 15:10:18','',''),(2116224,'1','140','773',331,'Retail sales',0.00,0.00,0.00,660.00,0.00,'2021-12-01 15:10:18','',''),(2116239,'1','140','773',331,'Retail Sale Id 1258032',461604.00,0.00,0.00,0.00,5649.00,'2021-12-01 15:11:20','',''),(2116240,'1','140','773',331,'Retail sales',0.00,0.00,0.00,807.00,0.00,'2021-12-01 15:11:20','',''),(2116259,'1','140','773',331,'Retail Sale Id 1258038',60480.00,0.00,0.00,0.00,1155.00,'2021-12-01 15:12:54','',''),(2116260,'1','140','773',331,'Retail sales',0.00,0.00,0.00,105.00,0.00,'2021-12-01 15:12:54','',''),(2116269,'1','140','773',331,'Retail Sale Id 1258047',10354.00,0.00,0.00,0.00,918.50,'2021-12-01 15:13:37','',''),(2116270,'1','140','773',331,'Retail sales',0.00,0.00,0.00,16.70,0.00,'2021-12-01 15:13:37','',''),(2116273,'1','140','773',331,'Retail Sale Id 1258054',1240.00,0.00,0.00,0.00,110.00,'2021-12-01 15:14:01','',''),(2116274,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 15:14:01','',''),(2116380,'1','140','773',331,'Retail Sale Id 1258091',1860.00,0.00,0.00,0.00,165.00,'2021-12-01 15:19:33','',''),(2116381,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:19:33','',''),(2116414,'1','140','773',331,'Retail Sale Id 1258114',1240.00,0.00,0.00,0.00,110.00,'2021-12-01 15:21:47','',''),(2116415,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 15:21:47','',''),(2116436,'1','140','773',331,'Retail Sale Id 1258124',37440.00,0.00,0.00,0.00,715.00,'2021-12-01 15:23:08','',''),(2116437,'1','140','773',331,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-01 15:23:08','',''),(2116525,'1','140','773',331,'Retail Sale Id 1258161',1860.00,0.00,0.00,0.00,165.00,'2021-12-01 15:28:26','',''),(2116526,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:28:26','',''),(2116591,'1','140','773',331,'Retail Sale Id 1258196',620.00,0.00,0.00,0.00,55.00,'2021-12-01 15:32:47','',''),(2116592,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 15:32:47','',''),(2116640,'1','140','773',331,'Retail Sale Id 1258224',3720.00,0.00,0.00,0.00,330.00,'2021-12-01 15:36:12','',''),(2116641,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:36:12','',''),(2116738,'1','140','773',331,'Retail Sale Id 1258269',1240.00,0.00,0.00,0.00,110.00,'2021-12-01 15:42:45','',''),(2116739,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 15:42:45','',''),(2116766,'1','140','773',331,'Retail Sale Id 1258282',1240.00,0.00,0.00,0.00,110.00,'2021-12-01 15:44:12','',''),(2116767,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 15:44:12','',''),(2116846,'1','140','773',331,'Retail Sale Id 1258316',1860.00,0.00,0.00,0.00,165.00,'2021-12-01 15:47:29','',''),(2116847,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:47:29','',''),(2117018,'1','140','773',331,'Retail Sale Id 1258401',7750.00,0.00,0.00,0.00,687.50,'2021-12-01 15:54:23','',''),(2117019,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:54:23','',''),(2117058,'1','140','773',331,'Retail Sale Id 1258417',7750.00,0.00,0.00,0.00,687.50,'2021-12-01 15:55:58','',''),(2117059,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:55:58','',''),(2117157,'1','140','773',331,'Retail Sale Id 1258470',3100.00,0.00,0.00,0.00,275.00,'2021-12-01 16:00:23','',''),(2117158,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:00:23','',''),(2117173,'1','140','773',331,'Retail Sale Id 1258477',1860.00,0.00,0.00,0.00,165.00,'2021-12-01 16:00:57','',''),(2117174,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:00:57','',''),(2117181,'1','140','773',331,'Retail Sale Id 1258480',1240.00,0.00,0.00,0.00,110.00,'2021-12-01 16:01:31','',''),(2117182,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 16:01:31','',''),(2117237,'1','140','773',331,'Retail Sale Id 1258505',1550.00,0.00,0.00,0.00,137.50,'2021-12-01 16:04:25','',''),(2117238,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-01 16:04:25','',''),(2117362,'1','140','773',331,'Retail Sale Id 1258548',620.00,0.00,0.00,0.00,55.00,'2021-12-01 16:08:33','',''),(2117363,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 16:08:33','',''),(2117444,'1','140','773',331,'Retail Sale Id 1258589',2480.00,0.00,0.00,0.00,220.00,'2021-12-01 16:12:15','',''),(2117445,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 16:12:16','',''),(2117605,'1','140','773',331,'Retail Sale Id 1258669',1860.00,0.00,0.00,0.00,165.00,'2021-12-01 16:18:38','',''),(2117606,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:18:38','',''),(2117684,'1','140','773',331,'Retail Sale Id 1258706',1240.00,0.00,0.00,0.00,110.00,'2021-12-01 16:21:44','',''),(2117685,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 16:21:44','',''),(2117696,'1','140','773',331,'Retail Sale Id 1258712',3720.00,0.00,0.00,0.00,330.00,'2021-12-01 16:22:16','',''),(2117697,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:22:16','',''),(2117840,'1','140','773',331,'Retail Sale Id 1258800',1240.00,0.00,0.00,0.00,110.00,'2021-12-01 16:29:03','',''),(2117841,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 16:29:03','',''),(2117910,'1','140','773',331,'Retail Sale Id 1258839',1240.00,0.00,0.00,0.00,110.00,'2021-12-01 16:32:05','',''),(2117911,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 16:32:05','',''),(2117984,'1','140','773',331,'Retail Sale Id 1258879',1240.00,0.00,0.00,0.00,110.00,'2021-12-01 16:36:28','',''),(2117985,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 16:36:28','',''),(2118034,'1','140','773',331,'Retail Sale Id 1258906',3100.00,0.00,0.00,0.00,275.00,'2021-12-01 16:38:32','',''),(2118035,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:38:32','',''),(2118086,'1','140','773',331,'Retail Sale Id 1258938',34560.00,0.00,0.00,0.00,660.00,'2021-12-01 16:41:06','',''),(2118087,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-01 16:41:06','',''),(2118260,'1','140','773',331,'Retail Sale Id 1259025',11520.00,0.00,0.00,0.00,220.00,'2021-12-01 16:50:15','',''),(2118261,'1','140','773',331,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-01 16:50:15','',''),(2118296,'1','140','773',331,'Retail Sale Id 1258998',23040.00,0.00,0.00,0.00,440.00,'2021-12-01 16:51:53','',''),(2118297,'1','140','773',331,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-01 16:51:53','',''),(2118322,'1','140','773',331,'Retail Sale Id 1259057',20160.00,0.00,0.00,0.00,385.00,'2021-12-01 16:53:01','',''),(2118323,'1','140','773',331,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-01 16:53:01','',''),(2118440,'1','140','773',331,'Retail Sale Id 1259111',7750.00,0.00,0.00,0.00,687.50,'2021-12-01 16:57:31','',''),(2118441,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:57:31','',''),(2118472,'1','140','773',331,'Retail Sale Id 1259127',1240.00,0.00,0.00,0.00,110.00,'2021-12-01 16:58:46','',''),(2118473,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 16:58:46','',''),(2118502,'1','140','773',331,'Retail Sale Id 1259144',1240.00,0.00,0.00,0.00,110.00,'2021-12-01 17:00:01','',''),(2118503,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 17:00:01','',''),(2118530,'1','140','773',331,'Retail Sale Id 1259157',7750.00,0.00,0.00,0.00,687.50,'2021-12-01 17:01:16','',''),(2118531,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:01:16','',''),(2118598,'1','140','773',331,'Retail Sale Id 1259191',620.00,0.00,0.00,0.00,55.00,'2021-12-01 17:04:26','',''),(2118599,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 17:04:26','',''),(2118652,'1','140','773',331,'Retail Sale Id 1259217',3720.00,0.00,0.00,0.00,330.00,'2021-12-01 17:07:16','',''),(2118653,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 17:07:16','',''),(2118666,'1','140','773',331,'Retail Sale Id 1259225',3000.80,0.00,0.00,0.00,266.20,'2021-12-01 17:08:03','',''),(2118667,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.84,0.00,'2021-12-01 17:08:03','',''),(2120411,'1','140','773',331,'Retail Sale Id 1259858',1860.00,0.00,0.00,0.00,165.00,'2021-12-02 06:05:31','',''),(2120412,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 06:05:31','',''),(2122956,'1','140','773',331,'Retail Sale Id 1261055',7750.00,0.00,0.00,0.00,687.50,'2021-12-02 08:20:24','',''),(2122957,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:20:24','',''),(2122974,'1','140','773',331,'Retail Sale Id 1261068',7750.00,0.00,0.00,0.00,687.50,'2021-12-02 08:21:26','',''),(2122975,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:21:26','',''),(2122984,'1','140','773',331,'Retail Sale Id 1261073',7750.00,0.00,0.00,0.00,687.50,'2021-12-02 08:22:01','',''),(2122985,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:22:01','',''),(2123115,'1','140','773',331,'Retail Sale Id 1261134',7750.00,0.00,0.00,0.00,687.50,'2021-12-02 08:28:23','',''),(2123116,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:28:23','',''),(2123371,'1','140','773',331,'Retail Sale Id 1261242',7750.00,0.00,0.00,0.00,687.50,'2021-12-02 08:40:29','',''),(2123372,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:40:29','',''),(2123411,'1','140','773',331,'Retail Sale Id 1261264',7750.00,0.00,0.00,0.00,687.50,'2021-12-02 08:42:36','',''),(2123412,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:42:36','',''),(2123431,'1','140','773',331,'Retail Sale Id 1261273',57600.00,0.00,0.00,0.00,1100.00,'2021-12-02 08:43:50','',''),(2123432,'1','140','773',331,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-02 08:43:50','',''),(2123453,'1','140','773',331,'Retail Sale Id 1261287',34560.00,0.00,0.00,0.00,660.00,'2021-12-02 08:44:34','',''),(2123454,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-02 08:44:34','',''),(2124493,'1','140','773',331,'Retail Sale Id 1261799',341484.00,0.00,0.00,0.00,4179.00,'2021-12-02 09:41:57','',''),(2124494,'1','140','773',331,'Retail sales',0.00,0.00,0.00,597.00,0.00,'2021-12-02 09:41:57','',''),(2124513,'1','140','773',331,'Retail Sale Id 1261252',7750.00,0.00,0.00,0.00,687.50,'2021-12-02 09:43:00','',''),(2124514,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:43:00','',''),(2124604,'1','140','773',331,'Retail Sale Id 1261850',3100.00,0.00,0.00,0.00,275.00,'2021-12-02 09:47:40','',''),(2124605,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:47:40','',''),(2124629,'1','140','773',331,'Retail Sale Id 1261864',1860.00,0.00,0.00,0.00,165.00,'2021-12-02 09:49:18','',''),(2124630,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:49:18','',''),(2124725,'1','140','773',331,'Retail Sale Id 1261922',1240.00,0.00,0.00,0.00,110.00,'2021-12-02 09:53:09','',''),(2124726,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 09:53:09','',''),(2124951,'1','140','773',331,'Retail Sale Id 1262034',4960.00,0.00,0.00,0.00,440.00,'2021-12-02 10:04:53','',''),(2124952,'1','140','773',331,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-02 10:04:53','',''),(2124965,'1','140','773',331,'Retail Sale Id 1262041',31680.00,0.00,0.00,0.00,605.00,'2021-12-02 10:05:37','',''),(2124966,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-02 10:05:37','',''),(2124999,'1','140','773',331,'Retail Sale Id 1262066',6200.00,0.00,0.00,0.00,550.00,'2021-12-02 10:08:43','',''),(2125000,'1','140','773',331,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 10:08:43','',''),(2125025,'1','140','773',331,'Retail Sale Id 1262079',7750.00,0.00,0.00,0.00,687.50,'2021-12-02 10:10:31','',''),(2125026,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:10:31','',''),(2125083,'1','140','773',331,'Retail Sale Id 1262101',103680.00,0.00,0.00,0.00,1980.00,'2021-12-02 10:13:09','',''),(2125084,'1','140','773',331,'Retail sales',0.00,0.00,0.00,180.00,0.00,'2021-12-02 10:13:09','',''),(2125239,'1','140','773',331,'Retail Sale Id 1262182',86400.00,0.00,0.00,0.00,1650.00,'2021-12-02 10:21:57','',''),(2125240,'1','140','773',331,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-02 10:21:57','',''),(2125261,'1','140','773',331,'Retail Sale Id 1262199',34560.00,0.00,0.00,0.00,660.00,'2021-12-02 10:23:22','',''),(2125262,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-02 10:23:22','',''),(2125354,'1','140','773',331,'Retail Sale Id 1262239',1860.00,0.00,0.00,0.00,165.00,'2021-12-02 10:27:44','',''),(2125355,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:27:44','',''),(2125364,'1','140','773',331,'Retail Sale Id 1262243',120960.00,0.00,0.00,0.00,2310.00,'2021-12-02 10:28:52','',''),(2125365,'1','140','773',331,'Retail sales',0.00,0.00,0.00,210.00,0.00,'2021-12-02 10:28:52','',''),(2125460,'1','140','773',331,'Retail Sale Id 1262294',620.00,0.00,0.00,0.00,55.00,'2021-12-02 10:35:03','',''),(2125461,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-02 10:35:03','',''),(2125494,'1','140','773',331,'Retail Sale Id 1262306',1240.00,0.00,0.00,0.00,110.00,'2021-12-02 10:36:47','',''),(2125495,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 10:36:47','',''),(2125572,'1','140','773',331,'Retail Sale Id 1262345',109440.00,0.00,0.00,0.00,2090.00,'2021-12-02 10:42:04','',''),(2125573,'1','140','773',331,'Retail sales',0.00,0.00,0.00,190.00,0.00,'2021-12-02 10:42:04','',''),(2125618,'1','140','773',331,'Retail Sale Id 1262366',7130.00,0.00,0.00,0.00,632.50,'2021-12-02 10:44:20','',''),(2125619,'1','140','773',331,'Retail sales',0.00,0.00,0.00,11.50,0.00,'2021-12-02 10:44:20','',''),(2125792,'1','140','773',331,'Retail Sale Id 1262447',80640.00,0.00,0.00,0.00,1540.00,'2021-12-02 10:56:07','',''),(2125793,'1','140','773',331,'Retail sales',0.00,0.00,0.00,140.00,0.00,'2021-12-02 10:56:07','',''),(2125974,'1','140','773',331,'Retail Sale Id 1262549',3456.00,0.00,0.00,0.00,66.00,'2021-12-02 11:07:42','',''),(2125975,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:07:42','',''),(2126110,'1','140','773',331,'Retail Sale Id 1262628',1240.00,0.00,0.00,0.00,110.00,'2021-12-02 11:15:58','',''),(2126111,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 11:15:58','',''),(2126138,'1','140','773',331,'Retail Sale Id 1262643',21600.00,0.00,0.00,0.00,412.50,'2021-12-02 11:17:12','',''),(2126139,'1','140','773',331,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-02 11:17:12','',''),(2126174,'1','140','773',331,'Retail Sale Id 1262664',2480.00,0.00,0.00,0.00,220.00,'2021-12-02 11:19:22','',''),(2126175,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 11:19:22','',''),(2126256,'1','140','773',331,'Retail Sale Id 1262706',1240.00,0.00,0.00,0.00,110.00,'2021-12-02 11:24:41','',''),(2126257,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 11:24:41','',''),(2126276,'1','140','773',331,'Retail Sale Id 1262714',429000.00,0.00,0.00,0.00,5250.00,'2021-12-02 11:25:46','',''),(2126277,'1','140','773',331,'Retail sales',0.00,0.00,0.00,750.00,0.00,'2021-12-02 11:25:46','',''),(2126328,'1','140','773',331,'Retail Sale Id 1262739',343200.00,0.00,0.00,0.00,4200.00,'2021-12-02 11:28:13','',''),(2126329,'1','140','773',331,'Retail sales',0.00,0.00,0.00,600.00,0.00,'2021-12-02 11:28:13','',''),(2126346,'1','140','773',331,'Retail Sale Id 1262746',1240.00,0.00,0.00,0.00,110.00,'2021-12-02 11:29:02','',''),(2126347,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 11:29:02','',''),(2126505,'1','140','773',331,'Retail Sale Id 1262810',1860.00,0.00,0.00,0.00,165.00,'2021-12-02 11:36:05','',''),(2126506,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:36:05','',''),(2127508,'1','140','773',331,'Retail Sale Id 1261294',23040.00,0.00,0.00,0.00,440.00,'2021-12-02 12:53:13','',''),(2127509,'1','140','773',331,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-02 12:53:13','',''),(2128073,'1','140','773',331,'Retail Sale Id 1263568',3014325.60,0.00,0.00,0.00,36888.60,'2021-12-02 13:31:38','',''),(2128074,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5269.80,0.00,'2021-12-02 13:31:38','',''),(2128075,'1','140','773',331,'Retail Sale Id 1263570',1860.00,0.00,0.00,0.00,165.00,'2021-12-02 13:32:02','',''),(2128076,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 13:32:02','',''),(2134000,'1','140','773',331,'Distributed to OPERATIONAL LOSS for sales id:336862',5424000.00,0.00,0.00,9600.00,0.00,'2021-12-03 06:12:23','',''),(2134055,'1','140',NULL,331,'Reception corrector for bridging 126023',0.00,0.00,0.00,260.00,0.00,'2021-12-03 06:15:20','',''),(2134056,'1','140','773',331,'Received from bridging 126023',0.00,0.00,260.00,0.00,0.00,'2021-12-03 06:15:20','',''),(2134101,'1','140','773',331,'Retail Sale Id 1266148',28800.00,0.00,0.00,0.00,550.00,'2021-12-03 06:22:15','',''),(2134102,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 06:22:15','',''),(2134107,'1','140','773',331,'Retail Sale Id 1266151',1860.00,0.00,0.00,0.00,165.00,'2021-12-03 06:22:53','',''),(2134108,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 06:22:53','',''),(2134216,'1','140','773',331,'Retail Sale Id 1266199',13824.00,0.00,0.00,0.00,264.00,'2021-12-03 06:31:44','',''),(2134217,'1','140','773',331,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-03 06:31:44','',''),(2134226,'1','140',NULL,331,'Purchased from AA RANO NIGERIA LIMITED',0.00,14108050.00,24970.00,0.00,0.00,'2021-12-03 06:33:11','',''),(2134273,'1','140',NULL,331,'Reception corrector for bridging 126024',0.00,0.00,0.00,24800.00,0.00,'2021-12-03 06:35:16','',''),(2134274,'1','140','773',331,'Received from bridging 126024',0.00,0.00,24800.00,0.00,0.00,'2021-12-03 06:35:16','',''),(2134388,'1','140','773',331,'Retail Sale Id 1266282',13824.00,0.00,0.00,0.00,264.00,'2021-12-03 06:42:08','',''),(2134389,'1','140','773',331,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-03 06:42:08','',''),(2134611,'1','140','773',331,'Retail Sale Id 1266391',3720.00,0.00,0.00,0.00,330.00,'2021-12-03 06:53:40','',''),(2134612,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 06:53:40','',''),(2134631,'1','140','773',331,'Retail Sale Id 1266403',40320.00,0.00,0.00,0.00,770.00,'2021-12-03 06:54:47','',''),(2134632,'1','140','773',331,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-03 06:54:47','',''),(2134651,'1','140','773',331,'Retail Sale Id 1266415',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 06:55:30','',''),(2134652,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 06:55:30','',''),(2135103,'1','140','773',331,'Retail Sale Id 1266630',43200.00,0.00,0.00,0.00,825.00,'2021-12-03 07:20:49','',''),(2135104,'1','140','773',331,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-03 07:20:49','',''),(2135153,'1','140','773',331,'Retail Sale Id 1266657',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 07:24:12','',''),(2135154,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 07:24:12','',''),(2135226,'1','140','773',331,'Retail Sale Id 1266693',1860.00,0.00,0.00,0.00,165.00,'2021-12-03 07:28:36','',''),(2135227,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 07:28:36','',''),(2135467,'1','140','773',331,'Retail Sale Id 1266808',1860.00,0.00,0.00,0.00,165.00,'2021-12-03 07:42:12','',''),(2135468,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 07:42:12','',''),(2135508,'1','140','773',331,'Retail Sale Id 1266827',1860.00,0.00,0.00,0.00,165.00,'2021-12-03 07:44:10','',''),(2135509,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 07:44:10','',''),(2135750,'1','140','773',331,'Retail Sale Id 1266938',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 07:57:07','',''),(2135751,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 07:57:07','',''),(2135893,'1','140','773',331,'Retail Sale Id 1266985',1860.00,0.00,0.00,0.00,165.00,'2021-12-03 08:02:29','',''),(2135894,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 08:02:29','',''),(2135986,'1','140','773',331,'Retail Sale Id 1267029',14400.00,0.00,0.00,0.00,275.00,'2021-12-03 08:06:08','',''),(2135987,'1','140','773',331,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 08:06:08','',''),(2136176,'1','140','773',331,'Retail Sale Id 1267126',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 08:15:43','',''),(2136177,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 08:15:43','',''),(2136190,'1','140','773',331,'Retail Sale Id 1267137',1860.00,0.00,0.00,0.00,165.00,'2021-12-03 08:16:41','',''),(2136191,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 08:16:41','',''),(2136208,'1','140','773',331,'Retail Sale Id 1267147',2480.00,0.00,0.00,0.00,220.00,'2021-12-03 08:17:22','',''),(2136209,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 08:17:22','',''),(2136232,'1','140','773',331,'Retail Sale Id 1267161',3100.00,0.00,0.00,0.00,275.00,'2021-12-03 08:18:34','',''),(2136233,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 08:18:34','',''),(2136265,'1','140','773',331,'Retail Sale Id 1267174',3503.00,0.00,0.00,0.00,310.75,'2021-12-03 08:20:29','',''),(2136266,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.65,0.00,'2021-12-03 08:20:29','',''),(2136279,'1','140','773',331,'Retail Sale Id 1267182',12672.00,0.00,0.00,0.00,242.00,'2021-12-03 08:21:28','',''),(2136280,'1','140','773',331,'Retail sales',0.00,0.00,0.00,22.00,0.00,'2021-12-03 08:21:28','',''),(2136428,'1','140','773',331,'Retail Sale Id 1267253',31680.00,0.00,0.00,0.00,605.00,'2021-12-03 08:31:09','',''),(2136429,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-03 08:31:09','',''),(2136449,'1','140','773',331,'Retail Sale Id 1267261',7502.00,0.00,0.00,0.00,665.50,'2021-12-03 08:32:54','',''),(2136450,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.10,0.00,'2021-12-03 08:32:54','',''),(2136748,'1','140','773',331,'Retail Sale Id 1267329',28800.00,0.00,0.00,0.00,550.00,'2021-12-03 08:42:02','',''),(2136749,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 08:42:02','',''),(2136768,'1','140','773',331,'Retail Sale Id 1267344',8928.00,0.00,0.00,0.00,170.50,'2021-12-03 08:43:05','',''),(2136769,'1','140','773',331,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-03 08:43:05','',''),(2136796,'1','140','773',331,'Retail Sale Id 1267354',13248.00,0.00,0.00,0.00,253.00,'2021-12-03 08:44:29','',''),(2136797,'1','140','773',331,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-03 08:44:29','',''),(2136800,'1','140','773',331,'Retail Sale Id 1267358',69120.00,0.00,0.00,0.00,1320.00,'2021-12-03 08:45:06','',''),(2136801,'1','140','773',331,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-03 08:45:06','',''),(2136862,'1','140','773',331,'Retail Sale Id 1267390',31680.00,0.00,0.00,0.00,605.00,'2021-12-03 08:49:23','',''),(2136863,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-03 08:49:23','',''),(2136894,'1','140','773',331,'Retail Sale Id 1267407',7750.00,0.00,0.00,0.00,687.50,'2021-12-03 08:51:05','',''),(2136895,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:51:05','',''),(2136930,'1','140','773',331,'Retail Sale Id 1267429',167616.00,0.00,0.00,0.00,3201.00,'2021-12-03 08:53:35','',''),(2136931,'1','140','773',331,'Retail sales',0.00,0.00,0.00,291.00,0.00,'2021-12-03 08:53:35','',''),(2136952,'1','140','773',331,'Retail Sale Id 1267437',3000.80,0.00,0.00,0.00,266.20,'2021-12-03 08:54:27','',''),(2136953,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.84,0.00,'2021-12-03 08:54:27','',''),(2137036,'1','140','773',331,'Retail Sale Id 1267481',51840.00,0.00,0.00,0.00,990.00,'2021-12-03 08:59:25','',''),(2137037,'1','140','773',331,'Retail sales',0.00,0.00,0.00,90.00,0.00,'2021-12-03 08:59:25','',''),(2137467,'1','140','773',331,'Retail Sale Id 1267726',7750.00,0.00,0.00,0.00,687.50,'2021-12-03 09:20:36','',''),(2137468,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:20:36','',''),(2137565,'1','140','773',331,'Retail Sale Id 1267780',28800.00,0.00,0.00,0.00,550.00,'2021-12-03 09:26:35','',''),(2137566,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 09:26:35','',''),(2137643,'1','140','773',331,'Retail Sale Id 1267827',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 09:31:36','',''),(2137644,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 09:31:36','',''),(2137723,'1','140','773',331,'Retail Sale Id 1267868',43200.00,0.00,0.00,0.00,825.00,'2021-12-03 09:36:51','',''),(2137724,'1','140','773',331,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-03 09:36:51','',''),(2137773,'1','140','773',331,'Retail Sale Id 1267898',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 09:39:44','',''),(2137774,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 09:39:44','',''),(2137819,'1','140','773',331,'Retail Sale Id 1267925',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 09:43:05','',''),(2137820,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 09:43:05','',''),(2137875,'1','140','773',331,'Retail Sale Id 1267951',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 09:46:01','',''),(2137876,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 09:46:01','',''),(2137889,'1','140','773',331,'Retail Sale Id 1267958',1860.00,0.00,0.00,0.00,165.00,'2021-12-03 09:46:43','',''),(2137890,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 09:46:43','',''),(2137914,'1','140','773',331,'Retail Sale Id 1267971',1500.40,0.00,0.00,0.00,133.10,'2021-12-03 09:48:07','',''),(2137915,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.42,0.00,'2021-12-03 09:48:07','',''),(2138106,'1','140','773',331,'Retail Sale Id 1268062',138240.00,0.00,0.00,0.00,2640.00,'2021-12-03 10:00:09','',''),(2138107,'1','140','773',331,'Retail sales',0.00,0.00,0.00,240.00,0.00,'2021-12-03 10:00:09','',''),(2138138,'1','140','773',331,'Retail Sale Id 1268082',7750.00,0.00,0.00,0.00,687.50,'2021-12-03 10:02:23','',''),(2138139,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:02:23','',''),(2138251,'1','140','773',331,'Retail Sale Id 1268138',31680.00,0.00,0.00,0.00,605.00,'2021-12-03 10:08:13','',''),(2138252,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-03 10:08:13','',''),(2138375,'1','140','773',331,'Retail Sale Id 1268200',34560.00,0.00,0.00,0.00,660.00,'2021-12-03 10:14:57','',''),(2138376,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-03 10:14:57','',''),(2138401,'1','140','773',331,'Retail Sale Id 1268214',45504.00,0.00,0.00,0.00,869.00,'2021-12-03 10:16:36','',''),(2138402,'1','140','773',331,'Retail sales',0.00,0.00,0.00,79.00,0.00,'2021-12-03 10:16:36','',''),(2138450,'1','140','773',331,'Retail Sale Id 1268233',7750.00,0.00,0.00,0.00,687.50,'2021-12-03 10:19:27','',''),(2138451,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:19:27','',''),(2138516,'1','140','773',331,'Retail Sale Id 1268268',7998.00,0.00,0.00,0.00,709.50,'2021-12-03 10:23:05','',''),(2138517,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.90,0.00,'2021-12-03 10:23:05','',''),(2138655,'1','140','773',331,'Retail Sale Id 1268337',2480.00,0.00,0.00,0.00,220.00,'2021-12-03 10:31:17','',''),(2138656,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 10:31:17','',''),(2138739,'1','140','773',331,'Retail Sale Id 1268372',31680.00,0.00,0.00,0.00,605.00,'2021-12-03 10:36:49','',''),(2138740,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-03 10:36:49','',''),(2138763,'1','140','773',331,'Retail Sale Id 1268383',17280.00,0.00,0.00,0.00,330.00,'2021-12-03 10:37:58','',''),(2138764,'1','140','773',331,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-03 10:37:58','',''),(2138833,'1','140','773',331,'Retail Sale Id 1268421',7750.00,0.00,0.00,0.00,687.50,'2021-12-03 10:42:43','',''),(2138834,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:42:43','',''),(2138865,'1','140','773',331,'Retail Sale Id 1268446',3100.00,0.00,0.00,0.00,275.00,'2021-12-03 10:45:10','',''),(2138866,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 10:45:10','',''),(2138897,'1','140','773',331,'Retail Sale Id 1268462',1860.00,0.00,0.00,0.00,165.00,'2021-12-03 10:48:34','',''),(2138898,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 10:48:34','',''),(2139064,'1','140','773',331,'Retail Sale Id 1268545',3100.00,0.00,0.00,0.00,275.00,'2021-12-03 11:01:37','',''),(2139065,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 11:01:37','',''),(2139080,'1','140','773',331,'Retail Sale Id 1268556',128448.00,0.00,0.00,0.00,2453.00,'2021-12-03 11:02:48','',''),(2139081,'1','140','773',331,'Retail sales',0.00,0.00,0.00,223.00,0.00,'2021-12-03 11:02:48','',''),(2139113,'1','140','773',331,'Retail Sale Id 1268568',11470.00,0.00,0.00,0.00,1017.50,'2021-12-03 11:04:32','',''),(2139114,'1','140','773',331,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-03 11:04:32','',''),(2139490,'1','140','773',331,'Retail Sale Id 1268770',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 11:34:05','',''),(2139491,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 11:34:05','',''),(2139644,'1','140','773',331,'Retail Sale Id 1268860',14976.00,0.00,0.00,0.00,286.00,'2021-12-03 11:46:38','',''),(2139645,'1','140','773',331,'Retail sales',0.00,0.00,0.00,26.00,0.00,'2021-12-03 11:46:38','',''),(2139802,'1','140','773',331,'Retail Sale Id 1268946',3000.80,0.00,0.00,0.00,266.20,'2021-12-03 11:58:16','',''),(2139803,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.84,0.00,'2021-12-03 11:58:16','',''),(2139968,'1','140','773',331,'Retail Sale Id 1269054',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 12:08:48','',''),(2139969,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 12:08:48','',''),(2140034,'1','140','773',331,'Retail Sale Id 1269085',620.00,0.00,0.00,0.00,55.00,'2021-12-03 12:15:51','',''),(2140035,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 12:15:51','',''),(2140080,'1','140','773',331,'Retail Sale Id 1269112',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 12:20:23','',''),(2140081,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 12:20:23','',''),(2140108,'1','140','773',331,'Retail Sale Id 1269129',20160.00,0.00,0.00,0.00,385.00,'2021-12-03 12:23:53','',''),(2140109,'1','140','773',331,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-03 12:23:53','',''),(2140443,'1','140','773',331,'Retail Sale Id 1269304',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 12:48:48','',''),(2140444,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 12:48:48','',''),(2140489,'1','140','773',331,'Retail Sale Id 1269324',3720.00,0.00,0.00,0.00,330.00,'2021-12-03 12:51:21','',''),(2140490,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 12:51:21','',''),(2140553,'1','140','773',331,'Retail Sale Id 1269354',620.00,0.00,0.00,0.00,55.00,'2021-12-03 12:55:32','',''),(2140554,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 12:55:32','',''),(2140608,'1','140','773',331,'Retail Sale Id 1269381',3100.00,0.00,0.00,0.00,275.00,'2021-12-03 13:00:34','',''),(2140609,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 13:00:34','',''),(2140622,'1','140','773',331,'Retail Sale Id 1269387',3100.00,0.00,0.00,0.00,275.00,'2021-12-03 13:01:32','',''),(2140623,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 13:01:32','',''),(2140855,'1','140','773',331,'Retail Sale Id 1269485',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 13:20:16','',''),(2140856,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 13:20:16','',''),(2140899,'1','140','773',331,'Retail Sale Id 1269508',620.00,0.00,0.00,0.00,55.00,'2021-12-03 13:24:30','',''),(2140900,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 13:24:30','',''),(2140982,'1','140','773',331,'Retail Sale Id 1269551',1860.00,0.00,0.00,0.00,165.00,'2021-12-03 13:30:14','',''),(2140983,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 13:30:14','',''),(2141126,'1','140','773',331,'Retail Sale Id 1269627',2480.00,0.00,0.00,0.00,220.00,'2021-12-03 13:39:45','',''),(2141127,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 13:39:45','',''),(2141232,'1','140','773',331,'Retail Sale Id 1269670',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 13:44:56','',''),(2141233,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 13:44:56','',''),(2141258,'1','140','773',331,'Retail Sale Id 1269683',620.00,0.00,0.00,0.00,55.00,'2021-12-03 13:46:14','',''),(2141259,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 13:46:14','',''),(2141443,'1','140','773',331,'Retail Sale Id 1269733',3999.00,0.00,0.00,0.00,354.75,'2021-12-03 13:51:53','',''),(2141444,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.45,0.00,'2021-12-03 13:51:53','',''),(2141485,'1','140','773',331,'Retail Sale Id 1269754',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 13:54:43','',''),(2141486,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 13:54:43','',''),(2141528,'1','140','773',331,'Retail Sale Id 1269774',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 13:57:39','',''),(2141529,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 13:57:39','',''),(2141564,'1','140','773',331,'Retail Sale Id 1269790',1500.40,0.00,0.00,0.00,133.10,'2021-12-03 14:00:15','',''),(2141565,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.42,0.00,'2021-12-03 14:00:15','',''),(2141608,'1','140','773',331,'Retail Sale Id 1269807',620.00,0.00,0.00,0.00,55.00,'2021-12-03 14:03:21','',''),(2141609,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 14:03:21','',''),(2141622,'1','140','773',331,'Retail Sale Id 1269816',34560.00,0.00,0.00,0.00,660.00,'2021-12-03 14:04:02','',''),(2141623,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-03 14:04:02','',''),(2141690,'1','140','773',331,'Retail Sale Id 1269839',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 14:07:15','',''),(2141691,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 14:07:15','',''),(2141790,'1','140','773',331,'Retail Sale Id 1269887',1860.00,0.00,0.00,0.00,165.00,'2021-12-03 14:14:07','',''),(2141791,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:14:07','',''),(2141812,'1','140','773',331,'Retail Sale Id 1269898',28800.00,0.00,0.00,0.00,550.00,'2021-12-03 14:16:04','',''),(2141813,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 14:16:04','',''),(2141894,'1','140','773',331,'Retail Sale Id 1269925',2480.00,0.00,0.00,0.00,220.00,'2021-12-03 14:20:32','',''),(2141895,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 14:20:32','',''),(2141949,'1','140','773',331,'Retail Sale Id 1269940',18432.00,0.00,0.00,0.00,352.00,'2021-12-03 14:23:15','',''),(2141950,'1','140','773',331,'Retail sales',0.00,0.00,0.00,32.00,0.00,'2021-12-03 14:23:15','',''),(2141985,'1','140','773',331,'Retail Sale Id 1269952',15500.00,0.00,0.00,0.00,1375.00,'2021-12-03 14:24:46','',''),(2141986,'1','140','773',331,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 14:24:46','',''),(2142130,'1','140','773',331,'Retail Sale Id 1270021',1860.00,0.00,0.00,0.00,165.00,'2021-12-03 14:34:35','',''),(2142131,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:34:35','',''),(2142191,'1','140','773',331,'Retail Sale Id 1270033',7750.00,0.00,0.00,0.00,687.50,'2021-12-03 14:37:05','',''),(2142192,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:37:05','',''),(2142399,'1','140','773',331,'Retail Sale Id 1270114',1860.00,0.00,0.00,0.00,165.00,'2021-12-03 14:45:32','',''),(2142400,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:45:32','',''),(2142419,'1','140','773',331,'Retail Sale Id 1270129',34560.00,0.00,0.00,0.00,660.00,'2021-12-03 14:46:42','',''),(2142420,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-03 14:46:42','',''),(2142531,'1','140','773',331,'Retail Sale Id 1270185',1860.00,0.00,0.00,0.00,165.00,'2021-12-03 14:51:42','',''),(2142532,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:51:42','',''),(2142581,'1','140','773',331,'Retail Sale Id 1270208',28800.00,0.00,0.00,0.00,550.00,'2021-12-03 14:53:44','',''),(2142582,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 14:53:44','',''),(2142591,'1','140','773',331,'Retail Sale Id 1270213',3720.00,0.00,0.00,0.00,330.00,'2021-12-03 14:54:28','',''),(2142592,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 14:54:28','',''),(2142612,'1','140','773',331,'Retail Sale Id 1270223',620.00,0.00,0.00,0.00,55.00,'2021-12-03 14:55:33','',''),(2142613,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 14:55:33','',''),(2142716,'1','140','773',331,'Retail Sale Id 1270265',3999.00,0.00,0.00,0.00,354.75,'2021-12-03 15:00:56','',''),(2142717,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.45,0.00,'2021-12-03 15:00:56','',''),(2142744,'1','140','773',331,'Retail Sale Id 1270279',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 15:02:29','',''),(2142745,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 15:02:29','',''),(2142930,'1','140','773',331,'Retail Sale Id 1270374',1860.00,0.00,0.00,0.00,165.00,'2021-12-03 15:13:18','',''),(2142931,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:13:18','',''),(2143047,'1','140','773',331,'Retail Sale Id 1270448',7750.00,0.00,0.00,0.00,687.50,'2021-12-03 15:18:56','',''),(2143048,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:18:56','',''),(2143183,'1','140','773',331,'Retail Sale Id 1270517',3720.00,0.00,0.00,0.00,330.00,'2021-12-03 15:26:15','',''),(2143184,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:26:15','',''),(2143782,'1','140','773',331,'Retail Sale Id 1270813',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 15:51:19','',''),(2143783,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 15:51:19','',''),(2143859,'1','140','773',331,'Retail Sale Id 1270851',620.00,0.00,0.00,0.00,55.00,'2021-12-03 15:54:54','',''),(2143860,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 15:54:54','',''),(2144047,'1','140','773',331,'Retail Sale Id 1270942',34560.00,0.00,0.00,0.00,660.00,'2021-12-03 16:03:41','',''),(2144048,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-03 16:03:41','',''),(2144077,'1','140','773',331,'Retail Sale Id 1270961',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 16:05:02','',''),(2144078,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 16:05:02','',''),(2144136,'1','140','773',331,'Retail Sale Id 1270984',17280.00,0.00,0.00,0.00,330.00,'2021-12-03 16:07:17','',''),(2144137,'1','140','773',331,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-03 16:07:17','',''),(2144212,'1','140','773',331,'Retail Sale Id 1271023',1860.00,0.00,0.00,0.00,165.00,'2021-12-03 16:10:20','',''),(2144213,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:10:20','',''),(2144232,'1','140','773',331,'Retail Sale Id 1271033',1860.00,0.00,0.00,0.00,165.00,'2021-12-03 16:11:24','',''),(2144233,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:11:24','',''),(2144320,'1','140','773',331,'Retail Sale Id 1271082',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 16:16:57','',''),(2144321,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 16:16:57','',''),(2144356,'1','140','773',331,'Retail Sale Id 1271097',2002.60,0.00,0.00,0.00,177.65,'2021-12-03 16:19:00','',''),(2144357,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.23,0.00,'2021-12-03 16:19:00','',''),(2144518,'1','140','773',331,'Retail Sale Id 1271181',3720.00,0.00,0.00,0.00,330.00,'2021-12-03 16:27:03','',''),(2144519,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 16:27:03','',''),(2144566,'1','140','773',331,'Retail Sale Id 1271205',620.00,0.00,0.00,0.00,55.00,'2021-12-03 16:30:06','',''),(2144567,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 16:30:06','',''),(2144622,'1','140','773',331,'Retail Sale Id 1271232',14799.40,0.00,0.00,0.00,1312.85,'2021-12-03 16:32:27','',''),(2144623,'1','140','773',331,'Retail sales',0.00,0.00,0.00,23.87,0.00,'2021-12-03 16:32:27','',''),(2144657,'1','140','773',331,'Retail Sale Id 1271246',1860.00,0.00,0.00,0.00,165.00,'2021-12-03 16:34:30','',''),(2144658,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:34:30','',''),(2144903,'1','140','773',331,'Retail Sale Id 1271375',7750.00,0.00,0.00,0.00,687.50,'2021-12-03 16:46:16','',''),(2144904,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:46:16','',''),(2144921,'1','140','773',331,'Retail Sale Id 1271386',629200.00,0.00,0.00,0.00,7700.00,'2021-12-03 16:47:23','',''),(2144922,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1100.00,0.00,'2021-12-03 16:47:23','',''),(2144983,'1','140','773',331,'Retail Sale Id 1271413',2480.00,0.00,0.00,0.00,220.00,'2021-12-03 16:51:02','',''),(2144984,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 16:51:02','',''),(2145111,'1','140','773',331,'Retail Sale Id 1271457',1240.00,0.00,0.00,0.00,110.00,'2021-12-03 16:55:50','',''),(2145112,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 16:55:50','',''),(2147038,'1','140','773',331,'Retail Sale Id 1272135',116928.00,0.00,0.00,0.00,2233.00,'2021-12-04 06:32:23','',''),(2147039,'1','140','773',331,'Retail sales',0.00,0.00,0.00,203.00,0.00,'2021-12-04 06:32:23','',''),(2147052,'1','140','773',331,'Retail Sale Id 1272142',3720.00,0.00,0.00,0.00,330.00,'2021-12-04 06:33:36','',''),(2147053,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 06:33:36','',''),(2147231,'1','140','773',331,'Retail Sale Id 1272220',13800.00,0.00,0.00,0.00,240.00,'2021-12-04 06:43:01','',''),(2147232,'1','140','773',331,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-04 06:43:01','',''),(2147338,'1','140','773',331,'Retail Sale Id 1272267',72000.00,0.00,0.00,0.00,1375.00,'2021-12-04 06:48:53','',''),(2147339,'1','140','773',331,'Retail sales',0.00,0.00,0.00,125.00,0.00,'2021-12-04 06:48:53','',''),(2147376,'1','140','773',331,'Retail Sale Id 1272280',13824.00,0.00,0.00,0.00,264.00,'2021-12-04 06:50:29','',''),(2147377,'1','140','773',331,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-04 06:50:29','',''),(2147637,'1','140','773',331,'Retail Sale Id 1272404',23040.00,0.00,0.00,0.00,440.00,'2021-12-04 07:04:16','',''),(2147638,'1','140','773',331,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-04 07:04:16','',''),(2147713,'1','140','773',331,'Retail Sale Id 1272444',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 07:08:16','',''),(2147714,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 07:08:16','',''),(2147746,'1','140','773',331,'Retail Sale Id 1272457',620.00,0.00,0.00,0.00,55.00,'2021-12-04 07:10:37','',''),(2147747,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-04 07:10:37','',''),(2147829,'1','140','773',331,'Retail Sale Id 1272502',64512.00,0.00,0.00,0.00,1232.00,'2021-12-04 07:15:05','',''),(2147830,'1','140','773',331,'Retail sales',0.00,0.00,0.00,112.00,0.00,'2021-12-04 07:15:05','',''),(2147898,'1','140','773',331,'Retail Sale Id 1272547',620.00,0.00,0.00,0.00,55.00,'2021-12-04 07:18:15','',''),(2147899,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-04 07:18:15','',''),(2147936,'1','140','773',331,'Retail Sale Id 1272567',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 07:20:14','',''),(2147937,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 07:20:14','',''),(2147964,'1','140','773',331,'Retail Sale Id 1272582',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 07:21:34','',''),(2147965,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 07:21:34','',''),(2148026,'1','140','773',331,'Retail Sale Id 1272618',1860.00,0.00,0.00,0.00,165.00,'2021-12-04 07:25:33','',''),(2148027,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:25:33','',''),(2148162,'1','140','773',331,'Retail Sale Id 1272683',24998.40,0.00,0.00,0.00,477.40,'2021-12-04 07:31:39','',''),(2148163,'1','140','773',331,'Retail sales',0.00,0.00,0.00,43.40,0.00,'2021-12-04 07:31:39','',''),(2148200,'1','140','773',331,'Retail Sale Id 1272705',998.20,0.00,0.00,0.00,88.55,'2021-12-04 07:33:40','',''),(2148201,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-04 07:33:40','',''),(2148222,'1','140','773',331,'Retail Sale Id 1272718',861.80,0.00,0.00,0.00,76.45,'2021-12-04 07:34:21','',''),(2148223,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.39,0.00,'2021-12-04 07:34:21','',''),(2148250,'1','140','773',331,'Retail Sale Id 1272737',7750.00,0.00,0.00,0.00,687.50,'2021-12-04 07:35:34','',''),(2148251,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:35:34','',''),(2148283,'1','140','773',331,'Retail Sale Id 1272756',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 07:37:15','',''),(2148284,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 07:37:15','',''),(2148339,'1','140','773',331,'Retail Sale Id 1272788',799.80,0.00,0.00,0.00,70.95,'2021-12-04 07:39:38','',''),(2148340,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.29,0.00,'2021-12-04 07:39:38','',''),(2148365,'1','140','773',331,'Retail Sale Id 1272801',1860.00,0.00,0.00,0.00,165.00,'2021-12-04 07:40:37','',''),(2148366,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:40:37','',''),(2148380,'1','140','773',331,'Retail Sale Id 1272811',799.80,0.00,0.00,0.00,70.95,'2021-12-04 07:41:41','',''),(2148381,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.29,0.00,'2021-12-04 07:41:41','',''),(2148470,'1','140','773',331,'Retail Sale Id 1272906',1860.00,0.00,0.00,0.00,165.00,'2021-12-04 07:47:20','',''),(2148471,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:47:20','',''),(2148488,'1','140','773',331,'Retail Sale Id 1272918',2480.00,0.00,0.00,0.00,220.00,'2021-12-04 07:48:30','',''),(2148489,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 07:48:30','',''),(2148564,'1','140','773',331,'Retail Sale Id 1272965',33984.00,0.00,0.00,0.00,649.00,'2021-12-04 07:53:08','',''),(2148565,'1','140','773',331,'Retail sales',0.00,0.00,0.00,59.00,0.00,'2021-12-04 07:53:08','',''),(2148805,'1','140','773',331,'Retail Sale Id 1273093',3720.00,0.00,0.00,0.00,330.00,'2021-12-04 08:04:45','',''),(2148806,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:04:45','',''),(2148920,'1','140','773',331,'Retail Sale Id 1273170',28800.00,0.00,0.00,0.00,550.00,'2021-12-04 08:10:01','',''),(2148921,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 08:10:01','',''),(2149049,'1','140','773',331,'Retail Sale Id 1273229',620.00,0.00,0.00,0.00,55.00,'2021-12-04 08:14:51','',''),(2149050,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-04 08:14:51','',''),(2149194,'1','140','773',331,'Retail Sale Id 1273298',81216.00,0.00,0.00,0.00,1551.00,'2021-12-04 08:21:02','',''),(2149195,'1','140','773',331,'Retail sales',0.00,0.00,0.00,141.00,0.00,'2021-12-04 08:21:02','',''),(2149208,'1','140','773',331,'Retail Sale Id 1273320',103680.00,0.00,0.00,0.00,1980.00,'2021-12-04 08:22:02','',''),(2149209,'1','140','773',331,'Retail sales',0.00,0.00,0.00,180.00,0.00,'2021-12-04 08:22:02','',''),(2149328,'1','140','773',331,'Retail Sale Id 1273423',1860.00,0.00,0.00,0.00,165.00,'2021-12-04 08:27:22','',''),(2149329,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:27:22','',''),(2149432,'1','140','773',331,'Retail Sale Id 1273508',1860.00,0.00,0.00,0.00,165.00,'2021-12-04 08:31:09','',''),(2149433,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:31:09','',''),(2149543,'1','140','773',331,'Retail Sale Id 1273550',3720.00,0.00,0.00,0.00,330.00,'2021-12-04 08:34:13','',''),(2149544,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:34:13','',''),(2149574,'1','140','773',331,'Retail Sale Id 1273568',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 08:35:42','',''),(2149575,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 08:35:42','',''),(2149592,'1','140','773',331,'Retail Sale Id 1273577',3720.00,0.00,0.00,0.00,330.00,'2021-12-04 08:36:47','',''),(2149593,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:36:47','',''),(2149706,'1','140','773',331,'Retail Sale Id 1273628',14260.00,0.00,0.00,0.00,1265.00,'2021-12-04 08:41:34','',''),(2149707,'1','140','773',331,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-04 08:41:34','',''),(2149964,'1','140','773',331,'Retail Sale Id 1273765',7502.00,0.00,0.00,0.00,665.50,'2021-12-04 08:52:26','',''),(2149965,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.10,0.00,'2021-12-04 08:52:26','',''),(2150006,'1','140','773',331,'Retail Sale Id 1273790',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 08:54:22','',''),(2150007,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 08:54:22','',''),(2150113,'1','140','773',331,'Retail Sale Id 1273840',7750.00,0.00,0.00,0.00,687.50,'2021-12-04 08:59:09','',''),(2150114,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:59:09','',''),(2150197,'1','140','773',331,'Retail Sale Id 1273890',1860.00,0.00,0.00,0.00,165.00,'2021-12-04 09:03:21','',''),(2150198,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 09:03:21','',''),(2150309,'1','140','773',331,'Retail Sale Id 1273952',7750.00,0.00,0.00,0.00,687.50,'2021-12-04 09:08:36','',''),(2150310,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:08:36','',''),(2150519,'1','140','773',331,'Retail Sale Id 1274059',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 09:19:20','',''),(2150520,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 09:19:20','',''),(2150617,'1','140','773',331,'Retail Sale Id 1274113',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 09:23:24','',''),(2150618,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 09:23:24','',''),(2150633,'1','140','773',331,'Retail Sale Id 1274122',3720.00,0.00,0.00,0.00,330.00,'2021-12-04 09:24:45','',''),(2150634,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 09:24:45','',''),(2150677,'1','140','773',331,'Retail Sale Id 1274140',2498.60,0.00,0.00,0.00,221.65,'2021-12-04 09:26:45','',''),(2150678,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-04 09:26:45','',''),(2150710,'1','140','773',331,'Retail Sale Id 1274157',105984.00,0.00,0.00,0.00,2024.00,'2021-12-04 09:28:37','',''),(2150711,'1','140','773',331,'Retail sales',0.00,0.00,0.00,184.00,0.00,'2021-12-04 09:28:37','',''),(2150744,'1','140','773',331,'Retail Sale Id 1274176',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 09:30:12','',''),(2150745,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 09:30:12','',''),(2150776,'1','140','773',331,'Retail Sale Id 1274198',34560.00,0.00,0.00,0.00,660.00,'2021-12-04 09:32:07','',''),(2150777,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-04 09:32:07','',''),(2152362,'1','140','773',331,'Retail Sale Id 1274369',620.00,0.00,0.00,0.00,55.00,'2021-12-04 10:27:00','',''),(2152363,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-04 10:27:00','',''),(2152383,'1','140','773',331,'Retail Sale Id 1274275',2480.00,0.00,0.00,0.00,220.00,'2021-12-04 10:28:15','',''),(2152384,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 10:28:15','',''),(2152448,'1','140','773',331,'Retail Sale Id 1274387',74880.00,0.00,0.00,0.00,1430.00,'2021-12-04 10:32:45','',''),(2152449,'1','140','773',331,'Retail sales',0.00,0.00,0.00,130.00,0.00,'2021-12-04 10:32:45','',''),(2152471,'1','140','773',331,'Return of Retail Sale Id 1274369',0.00,620.00,1.00,0.00,-55.00,'2021-12-04 10:34:16','',''),(2152486,'1','140','773',331,'Retail Sale Id 1274399',11160.00,0.00,0.00,0.00,990.00,'2021-12-04 10:34:55','',''),(2152487,'1','140','773',331,'Retail sales',0.00,0.00,0.00,18.00,0.00,'2021-12-04 10:34:55','',''),(2152504,'1','140','773',331,'Retail Sale Id 1274408',2046.00,0.00,0.00,0.00,181.50,'2021-12-04 10:36:43','',''),(2152505,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.30,0.00,'2021-12-04 10:36:43','',''),(2152511,'1','140','773',331,'Retail Sale Id 1274411',3100.00,0.00,0.00,0.00,275.00,'2021-12-04 10:37:23','',''),(2152512,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 10:37:23','',''),(2152519,'1','140','773',331,'Retail Sale Id 1274415',57600.00,0.00,0.00,0.00,1100.00,'2021-12-04 10:38:36','',''),(2152520,'1','140','773',331,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-04 10:38:36','',''),(2152535,'1','140','773',331,'Retail Sale Id 1274425',4960.00,0.00,0.00,0.00,440.00,'2021-12-04 10:40:26','',''),(2152536,'1','140','773',331,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 10:40:26','',''),(2152602,'1','140','773',331,'Retail Sale Id 1274443',34560.00,0.00,0.00,0.00,660.00,'2021-12-04 10:44:14','',''),(2152603,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-04 10:44:14','',''),(2152670,'1','140','773',331,'Retail Sale Id 1274469',2480.00,0.00,0.00,0.00,220.00,'2021-12-04 10:48:41','',''),(2152671,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 10:48:41','',''),(2152751,'1','140','773',331,'Retail Sale Id 1274505',1860.00,0.00,0.00,0.00,165.00,'2021-12-04 10:52:47','',''),(2152752,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 10:52:47','',''),(2152931,'1','140','773',331,'Retail Sale Id 1274585',11520.00,0.00,0.00,0.00,220.00,'2021-12-04 11:02:41','',''),(2152932,'1','140','773',331,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-04 11:02:41','',''),(2153091,'1','140','773',331,'Retail Sale Id 1274664',28800.00,0.00,0.00,0.00,550.00,'2021-12-04 11:10:43','',''),(2153092,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 11:10:43','',''),(2153165,'1','140','773',331,'Retail Sale Id 1274698',34560.00,0.00,0.00,0.00,660.00,'2021-12-04 11:14:07','',''),(2153166,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-04 11:14:07','',''),(2153195,'1','140','773',331,'Retail Sale Id 1274713',1202.80,0.00,0.00,0.00,106.70,'2021-12-04 11:15:38','',''),(2153196,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.94,0.00,'2021-12-04 11:15:38','',''),(2153223,'1','140','773',331,'Retail Sale Id 1274730',3720.00,0.00,0.00,0.00,330.00,'2021-12-04 11:16:46','',''),(2153224,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 11:16:46','',''),(2153315,'1','140','773',331,'Retail Sale Id 1274775',1860.00,0.00,0.00,0.00,165.00,'2021-12-04 11:21:11','',''),(2153316,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 11:21:11','',''),(2153394,'1','140','773',331,'Retail Sale Id 1274815',6912.00,0.00,0.00,0.00,132.00,'2021-12-04 11:26:03','',''),(2153395,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 11:26:03','',''),(2153445,'1','140','773',331,'Retail Sale Id 1274846',7440.00,0.00,0.00,0.00,660.00,'2021-12-04 11:29:35','',''),(2153446,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 11:29:35','',''),(2153481,'1','140','773',331,'Retail Sale Id 1274867',1860.00,0.00,0.00,0.00,165.00,'2021-12-04 11:31:27','',''),(2153482,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 11:31:27','',''),(2153525,'1','140','773',331,'Retail Sale Id 1274888',1860.00,0.00,0.00,0.00,165.00,'2021-12-04 11:33:03','',''),(2153526,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 11:33:03','',''),(2153570,'1','140','773',331,'Retail Sale Id 1274908',13248.00,0.00,0.00,0.00,253.00,'2021-12-04 11:35:20','',''),(2153571,'1','140','773',331,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-04 11:35:20','',''),(2153653,'1','140','773',331,'Retail Sale Id 1274941',3720.00,0.00,0.00,0.00,330.00,'2021-12-04 11:38:44','',''),(2153654,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 11:38:44','',''),(2153838,'1','140','773',331,'Retail Sale Id 1275022',63360.00,0.00,0.00,0.00,1210.00,'2021-12-04 11:50:01','',''),(2153839,'1','140','773',331,'Retail sales',0.00,0.00,0.00,110.00,0.00,'2021-12-04 11:50:01','',''),(2153850,'1','140','773',331,'Retail Sale Id 1275029',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 11:51:02','',''),(2153851,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 11:51:02','',''),(2153889,'1','140','773',331,'Retail Sale Id 1275041',9300.00,0.00,0.00,0.00,825.00,'2021-12-04 11:52:41','',''),(2153890,'1','140','773',331,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-04 11:52:41','',''),(2154250,'1','140','773',331,'Retail Sale Id 1275156',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 12:09:08','',''),(2154251,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 12:09:08','',''),(2154274,'1','140','773',331,'Retail Sale Id 1275168',3100.00,0.00,0.00,0.00,275.00,'2021-12-04 12:10:19','',''),(2154275,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 12:10:19','',''),(2154391,'1','140','773',331,'Retail Sale Id 1275229',69120.00,0.00,0.00,0.00,1320.00,'2021-12-04 12:18:05','',''),(2154392,'1','140','773',331,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-04 12:18:05','',''),(2154403,'1','140','773',331,'Retail Sale Id 1275236',20736.00,0.00,0.00,0.00,396.00,'2021-12-04 12:19:27','',''),(2154404,'1','140','773',331,'Retail sales',0.00,0.00,0.00,36.00,0.00,'2021-12-04 12:19:27','',''),(2154862,'1','140','773',331,'Retail Sale Id 1275462',3999.00,0.00,0.00,0.00,354.75,'2021-12-04 12:48:50','',''),(2154863,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.45,0.00,'2021-12-04 12:48:50','',''),(2154913,'1','140','773',331,'Retail Sale Id 1275479',34560.00,0.00,0.00,0.00,660.00,'2021-12-04 12:51:37','',''),(2154914,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-04 12:51:37','',''),(2154948,'1','140','773',331,'Retail Sale Id 1275495',7750.00,0.00,0.00,0.00,687.50,'2021-12-04 12:53:32','',''),(2154949,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:53:32','',''),(2155017,'1','140','773',331,'Retail Sale Id 1275737',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 13:05:10','',''),(2155018,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 13:05:10','',''),(2155059,'1','140','773',331,'Retail Sale Id 1275761',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 13:07:16','',''),(2155060,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 13:07:16','',''),(2155176,'1','140','773',331,'Retail Sale Id 1275819',24998.40,0.00,0.00,0.00,477.40,'2021-12-04 13:14:44','',''),(2155177,'1','140','773',331,'Retail sales',0.00,0.00,0.00,43.40,0.00,'2021-12-04 13:14:44','',''),(2155317,'1','140','773',331,'Retail Sale Id 1275873',2480.00,0.00,0.00,0.00,220.00,'2021-12-04 13:23:19','',''),(2155318,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 13:23:19','',''),(2155630,'1','140','773',331,'Retail Sale Id 1275997',7998.00,0.00,0.00,0.00,709.50,'2021-12-04 13:38:31','',''),(2155631,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.90,0.00,'2021-12-04 13:38:31','',''),(2155686,'1','140','773',331,'Retail Sale Id 1276026',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 13:41:44','',''),(2155687,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 13:41:44','',''),(2156409,'1','140','773',331,'Retail Sale Id 1276348',28800.00,0.00,0.00,0.00,550.00,'2021-12-04 14:14:07','',''),(2156411,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 14:14:07','',''),(2156486,'1','140','773',331,'Retail Sale Id 1276386',1860.00,0.00,0.00,0.00,165.00,'2021-12-04 14:17:44','',''),(2156487,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 14:17:44','',''),(2156592,'1','140','773',331,'Retail Sale Id 1276444',1500.40,0.00,0.00,0.00,133.10,'2021-12-04 14:23:12','',''),(2156593,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.42,0.00,'2021-12-04 14:23:12','',''),(2156628,'1','140','773',331,'Retail Sale Id 1276457',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 14:24:37','',''),(2156629,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 14:24:37','',''),(2156637,'1','140','773',331,'Retail Sale Id 1276462',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 14:25:57','',''),(2156638,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 14:25:57','',''),(2157083,'1','140','773',331,'Retail Sale Id 1276639',1860.00,0.00,0.00,0.00,165.00,'2021-12-04 14:48:39','',''),(2157084,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 14:48:39','',''),(2157126,'1','140','773',331,'Retail Sale Id 1276661',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 14:51:05','',''),(2157127,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 14:51:05','',''),(2157780,'1','140','773',331,'Retail Sale Id 1276940',34560.00,0.00,0.00,0.00,660.00,'2021-12-04 15:24:35','',''),(2157781,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-04 15:24:36','',''),(2157865,'1','140','773',331,'Retail Sale Id 1276977',620.00,0.00,0.00,0.00,55.00,'2021-12-04 15:27:42','',''),(2157866,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-04 15:27:42','',''),(2157897,'1','140','773',331,'Retail Sale Id 1276991',9999.36,0.00,0.00,0.00,190.96,'2021-12-04 15:28:49','',''),(2157898,'1','140','773',331,'Retail sales',0.00,0.00,0.00,17.36,0.00,'2021-12-04 15:28:49','',''),(2157911,'1','140','773',331,'Retail Sale Id 1276998',23040.00,0.00,0.00,0.00,440.00,'2021-12-04 15:29:38','',''),(2157912,'1','140','773',331,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-04 15:29:38','',''),(2157931,'1','140','773',331,'Retail Sale Id 1277008',2480.00,0.00,0.00,0.00,220.00,'2021-12-04 15:30:55','',''),(2157932,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 15:30:55','',''),(2157951,'1','140','773',331,'Retail Sale Id 1277019',620.00,0.00,0.00,0.00,55.00,'2021-12-04 15:32:01','',''),(2157952,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-04 15:32:01','',''),(2157987,'1','140','773',331,'Retail Sale Id 1277033',620.00,0.00,0.00,0.00,55.00,'2021-12-04 15:32:56','',''),(2157988,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-04 15:32:56','',''),(2158005,'1','140','773',331,'Retail Sale Id 1277043',998.20,0.00,0.00,0.00,88.55,'2021-12-04 15:33:56','',''),(2158006,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-04 15:33:56','',''),(2158342,'1','140','773',331,'Retail Sale Id 1277200',4997.20,0.00,0.00,0.00,443.30,'2021-12-04 15:50:25','',''),(2158343,'1','140','773',331,'Retail sales',0.00,0.00,0.00,8.06,0.00,'2021-12-04 15:50:25','',''),(2158390,'1','140','773',331,'Retail Sale Id 1277226',34560.00,0.00,0.00,0.00,660.00,'2021-12-04 15:52:53','',''),(2158391,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-04 15:52:53','',''),(2158408,'1','140','773',331,'Retail Sale Id 1277233',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 15:53:41','',''),(2158409,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 15:53:41','',''),(2158508,'1','140','773',331,'Retail Sale Id 1277300',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 15:58:39','',''),(2158509,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 15:58:39','',''),(2158535,'1','140','773',331,'Retail Sale Id 1277315',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 15:59:41','',''),(2158536,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 15:59:41','',''),(2158600,'1','140','773',331,'Retail Sale Id 1277335',2480.00,0.00,0.00,0.00,220.00,'2021-12-04 16:02:19','',''),(2158601,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 16:02:19','',''),(2158724,'1','140','773',331,'Retail Sale Id 1277409',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 16:09:15','',''),(2158725,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 16:09:15','',''),(2158773,'1','140','773',331,'Retail Sale Id 1277436',28800.00,0.00,0.00,0.00,550.00,'2021-12-04 16:11:12','',''),(2158774,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 16:11:12','',''),(2158803,'1','140','773',331,'Retail Sale Id 1277450',1147.00,0.00,0.00,0.00,101.75,'2021-12-04 16:12:38','',''),(2158804,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.85,0.00,'2021-12-04 16:12:38','',''),(2158921,'1','140','773',331,'Retail Sale Id 1277514',1302.00,0.00,0.00,0.00,115.50,'2021-12-04 16:18:11','',''),(2158922,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-04 16:18:11','',''),(2158977,'1','140','773',331,'Retail Sale Id 1277543',620.00,0.00,0.00,0.00,55.00,'2021-12-04 16:21:17','',''),(2158978,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-04 16:21:17','',''),(2159019,'1','140','773',331,'Retail Sale Id 1277562',1860.00,0.00,0.00,0.00,165.00,'2021-12-04 16:22:53','',''),(2159020,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:22:53','',''),(2159067,'1','140','773',331,'Retail Sale Id 1277593',28800.00,0.00,0.00,0.00,550.00,'2021-12-04 16:24:49','',''),(2159068,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 16:24:49','',''),(2159093,'1','140','773',331,'Retail Sale Id 1277608',1860.00,0.00,0.00,0.00,165.00,'2021-12-04 16:25:58','',''),(2159094,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:25:58','',''),(2159113,'1','140','773',331,'Retail Sale Id 1277618',1860.00,0.00,0.00,0.00,165.00,'2021-12-04 16:26:58','',''),(2159114,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:26:58','',''),(2159181,'1','140','773',331,'Retail Sale Id 1277653',1860.00,0.00,0.00,0.00,165.00,'2021-12-04 16:29:38','',''),(2159182,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:29:38','',''),(2159211,'1','140','773',331,'Retail Sale Id 1277667',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 16:31:00','',''),(2159212,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 16:31:00','',''),(2159259,'1','140','773',331,'Retail Sale Id 1277687',1240.00,0.00,0.00,0.00,110.00,'2021-12-04 16:33:36','',''),(2159260,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 16:33:36','',''),(2159299,'1','140','773',331,'Retail Sale Id 1277709',34500.00,0.00,0.00,0.00,600.00,'2021-12-04 16:36:10','',''),(2159300,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-04 16:36:10','',''),(2159341,'1','140','773',331,'Return of Retail Sale Id 1277709',0.00,34500.00,60.00,0.00,-600.00,'2021-12-04 16:38:05','',''),(2159381,'1','140','773',331,'Retail Sale Id 1277741',34560.00,0.00,0.00,0.00,660.00,'2021-12-04 16:38:51','',''),(2159382,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-04 16:38:51','',''),(2159483,'1','140','773',331,'Retail Sale Id 1277815',1860.00,0.00,0.00,0.00,165.00,'2021-12-04 16:44:11','',''),(2159484,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:44:11','',''),(2159564,'1','140','773',331,'Retail Sale Id 1277862',2480.00,0.00,0.00,0.00,220.00,'2021-12-04 16:47:36','',''),(2159565,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 16:47:36','',''),(2159660,'1','140','773',331,'Retail Sale Id 1277907',7750.00,0.00,0.00,0.00,687.50,'2021-12-04 16:51:42','',''),(2159661,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:51:42','',''),(2159958,'1','140','773',331,'Return of Retail Sale Id 1277815',0.00,1860.00,3.00,0.00,-165.00,'2021-12-04 17:09:04','',''),(2165150,'1','140','773',331,'Retail Sale Id 1280308',3720.00,0.00,0.00,0.00,330.00,'2021-12-05 09:10:51','',''),(2165151,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 09:10:51','',''),(2165164,'1','140','773',331,'Retail Sale Id 1280316',998.20,0.00,0.00,0.00,88.55,'2021-12-05 09:11:45','',''),(2165165,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-05 09:11:45','',''),(2165185,'1','140','773',331,'Retail Sale Id 1280326',5760.00,0.00,0.00,0.00,110.00,'2021-12-05 09:12:35','',''),(2165186,'1','140','773',331,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 09:12:35','',''),(2165215,'1','140','773',331,'Retail Sale Id 1280341',1240.00,0.00,0.00,0.00,110.00,'2021-12-05 09:13:57','',''),(2165216,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 09:13:57','',''),(2165236,'1','140','773',331,'Retail Sale Id 1280373',1860.00,0.00,0.00,0.00,165.00,'2021-12-05 09:17:04','',''),(2165237,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 09:17:04','',''),(2165260,'1','140','773',331,'Retail Sale Id 1280394',1860.00,0.00,0.00,0.00,165.00,'2021-12-05 09:17:55','',''),(2165261,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 09:17:55','',''),(2165288,'1','140','773',331,'Retail Sale Id 1280409',1860.00,0.00,0.00,0.00,165.00,'2021-12-05 09:19:18','',''),(2165289,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 09:19:18','',''),(2165342,'1','140','773',331,'Retail Sale Id 1280440',1240.00,0.00,0.00,0.00,110.00,'2021-12-05 09:23:04','',''),(2165343,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 09:23:04','',''),(2165423,'1','140','773',331,'Retail Sale Id 1280487',149184.00,0.00,0.00,0.00,2849.00,'2021-12-05 09:27:17','',''),(2165425,'1','140','773',331,'Retail sales',0.00,0.00,0.00,259.00,0.00,'2021-12-05 09:27:17','',''),(2165490,'1','140','773',331,'Retail Sale Id 1280520',3100.00,0.00,0.00,0.00,275.00,'2021-12-05 09:30:34','',''),(2165491,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 09:30:34','',''),(2165532,'1','140','773',331,'Retail Sale Id 1280550',3000.80,0.00,0.00,0.00,266.20,'2021-12-05 09:32:39','',''),(2165533,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.84,0.00,'2021-12-05 09:32:39','',''),(2165576,'1','140','773',331,'Retail Sale Id 1280573',31680.00,0.00,0.00,0.00,605.00,'2021-12-05 09:34:50','',''),(2165577,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-05 09:34:50','',''),(2165640,'1','140','773',331,'Retail Sale Id 1280606',700.60,0.00,0.00,0.00,62.15,'2021-12-05 09:38:34','',''),(2165641,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.13,0.00,'2021-12-05 09:38:34','',''),(2166207,'1','140','773',331,'Retail Sale Id 1280866',42048.00,0.00,0.00,0.00,803.00,'2021-12-05 10:06:50','',''),(2166208,'1','140','773',331,'Retail sales',0.00,0.00,0.00,73.00,0.00,'2021-12-05 10:06:50','',''),(2166227,'1','140','773',331,'Retail Sale Id 1280876',998.20,0.00,0.00,0.00,88.55,'2021-12-05 10:07:59','',''),(2166228,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-05 10:07:59','',''),(2166247,'1','140','773',331,'Retail Sale Id 1280887',1860.00,0.00,0.00,0.00,165.00,'2021-12-05 10:09:20','',''),(2166248,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:09:20','',''),(2166279,'1','140','773',331,'Retail Sale Id 1280900',7750.00,0.00,0.00,0.00,687.50,'2021-12-05 10:11:19','',''),(2166280,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:11:19','',''),(2166365,'1','140','773',331,'Retail Sale Id 1280947',6200.00,0.00,0.00,0.00,550.00,'2021-12-05 10:17:08','',''),(2166366,'1','140','773',331,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 10:17:08','',''),(2166450,'1','140','773',331,'Retail Sale Id 1280990',1240.00,0.00,0.00,0.00,110.00,'2021-12-05 10:22:31','',''),(2166452,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 10:22:31','',''),(2166475,'1','140','773',331,'Retail Sale Id 1281003',1860.00,0.00,0.00,0.00,165.00,'2021-12-05 10:24:27','',''),(2166476,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:24:27','',''),(2166520,'1','140','773',331,'Retail Sale Id 1281018',14400.00,0.00,0.00,0.00,275.00,'2021-12-05 10:27:14','',''),(2166521,'1','140','773',331,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 10:27:14','',''),(2166568,'1','140','773',331,'Retail Sale Id 1281049',17280.00,0.00,0.00,0.00,330.00,'2021-12-05 10:29:54','',''),(2166569,'1','140','773',331,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-05 10:29:54','',''),(2166616,'1','140','773',331,'Retail Sale Id 1281075',1860.00,0.00,0.00,0.00,165.00,'2021-12-05 10:32:59','',''),(2166617,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:32:59','',''),(2166636,'1','140','773',331,'Retail Sale Id 1281086',276480.00,0.00,0.00,0.00,5280.00,'2021-12-05 10:34:53','',''),(2166637,'1','140','773',331,'Retail sales',0.00,0.00,0.00,480.00,0.00,'2021-12-05 10:34:53','',''),(2166929,'1','140','773',331,'Retail Sale Id 1281234',7750.00,0.00,0.00,0.00,687.50,'2021-12-05 10:49:56','',''),(2166930,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:49:56','',''),(2166965,'1','140','773',331,'Retail Sale Id 1281258',6820.00,0.00,0.00,0.00,605.00,'2021-12-05 10:52:27','',''),(2166966,'1','140','773',331,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-05 10:52:27','',''),(2167005,'1','140','773',331,'Retail Sale Id 1281281',35712.00,0.00,0.00,0.00,682.00,'2021-12-05 10:55:16','',''),(2167006,'1','140','773',331,'Retail sales',0.00,0.00,0.00,62.00,0.00,'2021-12-05 10:55:16','',''),(2167021,'1','140','773',331,'Retail Sale Id 1281289',28800.00,0.00,0.00,0.00,550.00,'2021-12-05 10:56:12','',''),(2167022,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 10:56:12','',''),(2167063,'1','140','773',331,'Retail Sale Id 1281310',28800.00,0.00,0.00,0.00,550.00,'2021-12-05 10:58:12','',''),(2167064,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 10:58:12','',''),(2167104,'1','140','773',331,'Retail Sale Id 1281325',1860.00,0.00,0.00,0.00,165.00,'2021-12-05 11:00:14','',''),(2167105,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 11:00:14','',''),(2167188,'1','140','773',331,'Retail Sale Id 1281367',2002.60,0.00,0.00,0.00,177.65,'2021-12-05 11:06:01','',''),(2167189,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.23,0.00,'2021-12-05 11:06:01','',''),(2167226,'1','140','773',331,'Retail Sale Id 1281402',620.00,0.00,0.00,0.00,55.00,'2021-12-05 11:08:09','',''),(2167227,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-05 11:08:09','',''),(2167330,'1','140','773',331,'Retail Sale Id 1281460',3100.00,0.00,0.00,0.00,275.00,'2021-12-05 11:14:20','',''),(2167331,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:14:20','',''),(2167496,'1','140','773',331,'Retail Sale Id 1281532',1860.00,0.00,0.00,0.00,165.00,'2021-12-05 11:24:21','',''),(2167497,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 11:24:21','',''),(2167526,'1','140','773',331,'Retail Sale Id 1281549',1240.00,0.00,0.00,0.00,110.00,'2021-12-05 11:25:46','',''),(2167527,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 11:25:46','',''),(2167554,'1','140','773',331,'Retail Sale Id 1281563',3720.00,0.00,0.00,0.00,330.00,'2021-12-05 11:27:32','',''),(2167555,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:27:32','',''),(2167597,'1','140','773',331,'Retail Sale Id 1281582',3100.00,0.00,0.00,0.00,275.00,'2021-12-05 11:29:25','',''),(2167598,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:29:25','',''),(2167621,'1','140','773',331,'Retail Sale Id 1281596',1860.00,0.00,0.00,0.00,165.00,'2021-12-05 11:30:57','',''),(2167622,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 11:30:57','',''),(2167727,'1','140','773',331,'Retail Sale Id 1281643',4960.00,0.00,0.00,0.00,440.00,'2021-12-05 11:36:16','',''),(2167728,'1','140','773',331,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 11:36:16','',''),(2167759,'1','140','773',331,'Retail Sale Id 1281658',31680.00,0.00,0.00,0.00,605.00,'2021-12-05 11:38:19','',''),(2167760,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-05 11:38:19','',''),(2167818,'1','140','773',331,'Retail Sale Id 1281733',1860.00,0.00,0.00,0.00,165.00,'2021-12-05 11:42:32','',''),(2167819,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 11:42:32','',''),(2167945,'1','140','773',331,'Retail Sale Id 1281806',1860.00,0.00,0.00,0.00,165.00,'2021-12-05 11:50:11','',''),(2167946,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 11:50:11','',''),(2168138,'1','140','773',331,'Retail Sale Id 1281906',3100.00,0.00,0.00,0.00,275.00,'2021-12-05 12:00:47','',''),(2168139,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:00:47','',''),(2168162,'1','140','773',331,'Retail Sale Id 1281919',1860.00,0.00,0.00,0.00,165.00,'2021-12-05 12:02:02','',''),(2168163,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:02:02','',''),(2168277,'1','140','773',331,'Retail Sale Id 1281981',3100.00,0.00,0.00,0.00,275.00,'2021-12-05 12:08:17','',''),(2168278,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:08:17','',''),(2168838,'1','140','773',331,'Retail Sale Id 1282261',3720.00,0.00,0.00,0.00,330.00,'2021-12-05 12:32:34','',''),(2168839,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:32:34','',''),(2168898,'1','140','773',331,'Retail Sale Id 1282288',2002.60,0.00,0.00,0.00,177.65,'2021-12-05 12:35:43','',''),(2168899,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.23,0.00,'2021-12-05 12:35:43','',''),(2168943,'1','140','773',331,'Retail Sale Id 1282311',2002.60,0.00,0.00,0.00,177.65,'2021-12-05 12:38:07','',''),(2168944,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.23,0.00,'2021-12-05 12:38:07','',''),(2168991,'1','140','773',331,'Retail Sale Id 1282339',3720.00,0.00,0.00,0.00,330.00,'2021-12-05 12:40:42','',''),(2168992,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:40:42','',''),(2169007,'1','140','773',331,'Retail Sale Id 1282347',2002.60,0.00,0.00,0.00,177.65,'2021-12-05 12:41:39','',''),(2169008,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.23,0.00,'2021-12-05 12:41:39','',''),(2169051,'1','140','773',331,'Retail Sale Id 1282372',17280.00,0.00,0.00,0.00,330.00,'2021-12-05 12:43:51','',''),(2169052,'1','140','773',331,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-05 12:43:51','',''),(2169209,'1','140','773',331,'Retail Sale Id 1282469',1240.00,0.00,0.00,0.00,110.00,'2021-12-05 12:54:17','',''),(2169210,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 12:54:17','',''),(2169245,'1','140','773',331,'Retail Sale Id 1282489',1240.00,0.00,0.00,0.00,110.00,'2021-12-05 12:55:57','',''),(2169246,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 12:55:57','',''),(2169277,'1','140','773',331,'Retail Sale Id 1282503',2480.00,0.00,0.00,0.00,220.00,'2021-12-05 12:57:13','',''),(2169278,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 12:57:13','',''),(2169499,'1','140','773',331,'Retail Sale Id 1282635',1240.00,0.00,0.00,0.00,110.00,'2021-12-05 13:08:38','',''),(2169500,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 13:08:38','',''),(2169530,'1','140','773',331,'Retail Sale Id 1282648',2480.00,0.00,0.00,0.00,220.00,'2021-12-05 13:10:19','',''),(2169531,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 13:10:19','',''),(2169544,'1','140','773',331,'Retail Sale Id 1282657',1240.00,0.00,0.00,0.00,110.00,'2021-12-05 13:11:21','',''),(2169545,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 13:11:21','',''),(2169564,'1','140','773',331,'Retail Sale Id 1282667',1240.00,0.00,0.00,0.00,110.00,'2021-12-05 13:12:34','',''),(2169565,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 13:12:34','',''),(2169644,'1','140','773',331,'Retail Sale Id 1282702',1240.00,0.00,0.00,0.00,110.00,'2021-12-05 13:17:15','',''),(2169645,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 13:17:15','',''),(2169690,'1','140','773',331,'Retail Sale Id 1282727',7200.00,0.00,0.00,0.00,137.50,'2021-12-05 13:20:29','',''),(2169691,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:20:29','',''),(2169716,'1','140','773',331,'Retail Sale Id 1282743',31680.00,0.00,0.00,0.00,605.00,'2021-12-05 13:21:59','',''),(2169717,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-05 13:21:59','',''),(2169770,'1','140','773',331,'Retail Sale Id 1282774',42624.00,0.00,0.00,0.00,814.00,'2021-12-05 13:25:20','',''),(2169771,'1','140','773',331,'Retail sales',0.00,0.00,0.00,74.00,0.00,'2021-12-05 13:25:20','',''),(2169806,'1','140','773',331,'Retail Sale Id 1282795',13248.00,0.00,0.00,0.00,253.00,'2021-12-05 13:27:35','',''),(2169807,'1','140','773',331,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-05 13:27:35','',''),(2169965,'1','140','773',331,'Retail Sale Id 1282858',2480.00,0.00,0.00,0.00,220.00,'2021-12-05 13:34:59','',''),(2169966,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 13:34:59','',''),(2170094,'1','140','773',331,'Retail Sale Id 1282906',930.00,0.00,0.00,0.00,82.50,'2021-12-05 13:41:23','',''),(2170095,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.50,0.00,'2021-12-05 13:41:23','',''),(2170157,'1','140','773',331,'Retail Sale Id 1282922',1860.00,0.00,0.00,0.00,165.00,'2021-12-05 13:43:52','',''),(2170158,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 13:43:52','',''),(2170332,'1','140','773',331,'Retail Sale Id 1282998',1240.00,0.00,0.00,0.00,110.00,'2021-12-05 13:53:24','',''),(2170333,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 13:53:24','',''),(2170427,'1','140','773',331,'Retail Sale Id 1283036',69120.00,0.00,0.00,0.00,1320.00,'2021-12-05 13:57:57','',''),(2170428,'1','140','773',331,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-05 13:57:57','',''),(2170491,'1','140','773',331,'Retail Sale Id 1283066',23040.00,0.00,0.00,0.00,440.00,'2021-12-05 14:01:49','',''),(2170492,'1','140','773',331,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-05 14:01:49','',''),(2170595,'1','140','773',331,'Retail Sale Id 1283122',3100.00,0.00,0.00,0.00,275.00,'2021-12-05 14:09:19','',''),(2170596,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 14:09:19','',''),(2170622,'1','140','773',331,'Retail Sale Id 1283133',1860.00,0.00,0.00,0.00,165.00,'2021-12-05 14:10:32','',''),(2170623,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:10:32','',''),(2170663,'1','140','773',331,'Retail Sale Id 1283146',109440.00,0.00,0.00,0.00,2090.00,'2021-12-05 14:12:36','',''),(2170664,'1','140','773',331,'Retail sales',0.00,0.00,0.00,190.00,0.00,'2021-12-05 14:12:36','',''),(2170739,'1','140','773',331,'Retail Sale Id 1283177',1860.00,0.00,0.00,0.00,165.00,'2021-12-05 14:15:30','',''),(2170740,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:15:30','',''),(2170771,'1','140','773',331,'Retail Sale Id 1283185',1860.00,0.00,0.00,0.00,165.00,'2021-12-05 14:16:28','',''),(2170772,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:16:28','',''),(2170810,'1','140','773',331,'Retail Sale Id 1283196',17280.00,0.00,0.00,0.00,330.00,'2021-12-05 14:17:59','',''),(2170811,'1','140','773',331,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-05 14:17:59','',''),(2170855,'1','140','773',331,'Retail Sale Id 1283216',620.00,0.00,0.00,0.00,55.00,'2021-12-05 14:19:41','',''),(2170856,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-05 14:19:41','',''),(2170961,'1','140','773',331,'Retail Sale Id 1283269',11520.00,0.00,0.00,0.00,220.00,'2021-12-05 14:26:47','',''),(2170962,'1','140','773',331,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-05 14:26:47','',''),(2170985,'1','140','773',331,'Retail Sale Id 1283282',23040.00,0.00,0.00,0.00,440.00,'2021-12-05 14:28:44','',''),(2170986,'1','140','773',331,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-05 14:28:44','',''),(2171154,'1','140','773',331,'Retail Sale Id 1283330',3503.00,0.00,0.00,0.00,310.75,'2021-12-05 14:35:27','',''),(2171155,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.65,0.00,'2021-12-05 14:35:27','',''),(2171199,'1','140','773',331,'Retail Sale Id 1283340',1860.00,0.00,0.00,0.00,165.00,'2021-12-05 14:37:07','',''),(2171200,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:37:07','',''),(2171255,'1','140','773',331,'Retail Sale Id 1283371',998.20,0.00,0.00,0.00,88.55,'2021-12-05 14:41:45','',''),(2171256,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-05 14:41:45','',''),(2171310,'1','140','773',331,'Retail Sale Id 1283385',1860.00,0.00,0.00,0.00,165.00,'2021-12-05 14:43:55','',''),(2171311,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:43:55','',''),(2171349,'1','140','773',331,'Retail Sale Id 1283400',109440.00,0.00,0.00,0.00,2090.00,'2021-12-05 14:46:11','',''),(2171350,'1','140','773',331,'Retail sales',0.00,0.00,0.00,190.00,0.00,'2021-12-05 14:46:11','',''),(2171411,'1','140','773',331,'Retail Sale Id 1283430',1240.00,0.00,0.00,0.00,110.00,'2021-12-05 14:50:30','',''),(2171412,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 14:50:30','',''),(2171437,'1','140','773',331,'Retail Sale Id 1283443',1240.00,0.00,0.00,0.00,110.00,'2021-12-05 14:52:02','',''),(2171438,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 14:52:02','',''),(2171467,'1','140','773',331,'Retail Sale Id 1283461',93600.00,0.00,0.00,0.00,1787.50,'2021-12-05 14:54:01','',''),(2171468,'1','140','773',331,'Retail sales',0.00,0.00,0.00,162.50,0.00,'2021-12-05 14:54:01','',''),(2171529,'1','140','773',331,'Retail Sale Id 1283491',7750.00,0.00,0.00,0.00,687.50,'2021-12-05 14:59:04','',''),(2171530,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:59:04','',''),(2171693,'1','140','773',331,'Retail Sale Id 1283576',86400.00,0.00,0.00,0.00,1650.00,'2021-12-05 15:12:30','',''),(2171694,'1','140','773',331,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-05 15:12:30','',''),(2171723,'1','140','773',331,'Retail Sale Id 1283593',1240.00,0.00,0.00,0.00,110.00,'2021-12-05 15:14:39','',''),(2171724,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 15:14:39','',''),(2174821,'1','140','773',331,'Retail Sale Id 1284917',103680.00,0.00,0.00,0.00,1980.00,'2021-12-06 06:09:46','',''),(2174822,'1','140','773',331,'Retail sales',0.00,0.00,0.00,180.00,0.00,'2021-12-06 06:09:46','',''),(2174848,'1','140','773',331,'Retail Sale Id 1284928',11520.00,0.00,0.00,0.00,220.00,'2021-12-06 06:13:36','',''),(2174849,'1','140','773',331,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-06 06:13:36','',''),(2174862,'1','140','773',331,'Retail Sale Id 1284940',7750.00,0.00,0.00,0.00,687.50,'2021-12-06 06:17:20','',''),(2174863,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:17:20','',''),(2174937,'1','140','773',331,'Retail Sale Id 1284977',1240.00,0.00,0.00,0.00,110.00,'2021-12-06 06:28:03','',''),(2174938,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 06:28:03','',''),(2175153,'1','140','773',331,'Retail Sale Id 1285051',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 06:46:36','',''),(2175154,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 06:46:36','',''),(2175171,'1','140','773',331,'Retail Sale Id 1285062',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 06:47:51','',''),(2175172,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 06:47:51','',''),(2175473,'1','140','773',331,'Retail Sale Id 1285188',1240.00,0.00,0.00,0.00,110.00,'2021-12-06 07:05:42','',''),(2175474,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 07:05:42','',''),(2175497,'1','140','773',331,'Retail Sale Id 1285201',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 07:07:33','',''),(2175498,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 07:07:33','',''),(2175513,'1','140','773',331,'Retail Sale Id 1285209',3100.00,0.00,0.00,0.00,275.00,'2021-12-06 07:10:01','',''),(2175514,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:10:01','',''),(2175553,'1','140','773',331,'Retail Sale Id 1285227',1240.00,0.00,0.00,0.00,110.00,'2021-12-06 07:13:27','',''),(2175554,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 07:13:27','',''),(2175686,'1','140','773',331,'Retail Sale Id 1285303',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 07:21:17','',''),(2175687,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 07:21:17','',''),(2176070,'1','140','773',331,'Retail Sale Id 1285487',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 07:42:06','',''),(2176071,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 07:42:06','',''),(2176135,'1','140','773',331,'Retail Sale Id 1285526',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 07:45:18','',''),(2176136,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 07:45:18','',''),(2176519,'1','140','773',331,'Retail Sale Id 1285699',1240.00,0.00,0.00,0.00,110.00,'2021-12-06 08:02:39','',''),(2176520,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 08:02:39','',''),(2176539,'1','140','773',331,'Retail Sale Id 1285711',3100.00,0.00,0.00,0.00,275.00,'2021-12-06 08:03:45','',''),(2176540,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 08:03:45','',''),(2176776,'1','140','773',331,'Retail Sale Id 1285833',31680.00,0.00,0.00,0.00,605.00,'2021-12-06 08:18:55','',''),(2176777,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-06 08:18:55','',''),(2176804,'1','140','773',331,'Retail Sale Id 1285849',3720.00,0.00,0.00,0.00,330.00,'2021-12-06 08:20:59','',''),(2176805,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:20:59','',''),(2176889,'1','140','773',331,'Retail Sale Id 1285895',3100.00,0.00,0.00,0.00,275.00,'2021-12-06 08:30:03','',''),(2176890,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 08:30:03','',''),(2176907,'1','140','773',331,'Retail Sale Id 1285906',7750.00,0.00,0.00,0.00,687.50,'2021-12-06 08:31:33','',''),(2176908,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:31:33','',''),(2177155,'1','140','773',331,'Retail Sale Id 1285863',124416.00,0.00,0.00,0.00,2376.00,'2021-12-06 08:48:59','',''),(2177156,'1','140','773',331,'Retail sales',0.00,0.00,0.00,216.00,0.00,'2021-12-06 08:48:59','',''),(2177183,'1','140','773',331,'Retail Sale Id 1286034',11520.00,0.00,0.00,0.00,220.00,'2021-12-06 08:51:34','',''),(2177184,'1','140','773',331,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-06 08:51:34','',''),(2177207,'1','140','773',331,'Retail Sale Id 1286049',12672.00,0.00,0.00,0.00,242.00,'2021-12-06 08:53:44','',''),(2177208,'1','140','773',331,'Retail sales',0.00,0.00,0.00,22.00,0.00,'2021-12-06 08:53:44','',''),(2177280,'1','140','773',331,'Retail Sale Id 1286081',1240.00,0.00,0.00,0.00,110.00,'2021-12-06 08:58:30','',''),(2177281,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 08:58:30','',''),(2177303,'1','140','773',331,'Retail Sale Id 1286093',3720.00,0.00,0.00,0.00,330.00,'2021-12-06 09:00:08','',''),(2177304,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 09:00:08','',''),(2177327,'1','140','773',331,'Retail Sale Id 1286104',3100.00,0.00,0.00,0.00,275.00,'2021-12-06 09:01:58','',''),(2177328,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:01:58','',''),(2177520,'1','140','773',331,'Retail Sale Id 1286191',1240.00,0.00,0.00,0.00,110.00,'2021-12-06 09:15:22','',''),(2177521,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 09:15:22','',''),(2177534,'1','140','773',331,'Retail Sale Id 1286198',2480.00,0.00,0.00,0.00,220.00,'2021-12-06 09:16:17','',''),(2177535,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 09:16:17','',''),(2177544,'1','140','773',331,'Retail Sale Id 1286203',31680.00,0.00,0.00,0.00,605.00,'2021-12-06 09:17:21','',''),(2177545,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-06 09:17:21','',''),(2177604,'1','140','773',331,'Retail Sale Id 1286229',63360.00,0.00,0.00,0.00,1210.00,'2021-12-06 09:20:52','',''),(2177605,'1','140','773',331,'Retail sales',0.00,0.00,0.00,110.00,0.00,'2021-12-06 09:20:52','',''),(2177653,'1','140','773',331,'Retail Sale Id 1286254',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 09:24:22','',''),(2177654,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 09:24:22','',''),(2177760,'1','140','773',331,'Retail Sale Id 1286305',620.00,0.00,0.00,0.00,55.00,'2021-12-06 09:29:54','',''),(2177761,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-06 09:29:54','',''),(2177966,'1','140','773',331,'Retail Sale Id 1286377',1240.00,0.00,0.00,0.00,110.00,'2021-12-06 09:40:19','',''),(2177967,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 09:40:19','',''),(2178038,'1','140','773',331,'Retail Sale Id 1286409',3720.00,0.00,0.00,0.00,330.00,'2021-12-06 09:44:43','',''),(2178039,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 09:44:43','',''),(2178230,'1','140','773',331,'Retail Sale Id 1286514',3720.00,0.00,0.00,0.00,330.00,'2021-12-06 09:59:00','',''),(2178231,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 09:59:00','',''),(2178276,'1','140','773',331,'Retail Sale Id 1286535',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 10:01:52','',''),(2178277,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 10:01:52','',''),(2178299,'1','140','773',331,'Retail Sale Id 1286547',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 10:03:20','',''),(2178300,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 10:03:20','',''),(2178382,'1','140','773',331,'Retail Sale Id 1286580',39744.00,0.00,0.00,0.00,759.00,'2021-12-06 10:07:27','',''),(2178383,'1','140','773',331,'Retail sales',0.00,0.00,0.00,69.00,0.00,'2021-12-06 10:07:27','',''),(2178451,'1','140','773',331,'Retail Sale Id 1286603',28800.00,0.00,0.00,0.00,550.00,'2021-12-06 10:10:38','',''),(2178452,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 10:10:38','',''),(2178473,'1','140','773',331,'Retail Sale Id 1286624',43200.00,0.00,0.00,0.00,825.00,'2021-12-06 10:12:25','',''),(2178474,'1','140','773',331,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-06 10:12:25','',''),(2178541,'1','140','773',331,'Retail Sale Id 1286657',3720.00,0.00,0.00,0.00,330.00,'2021-12-06 10:16:06','',''),(2178542,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:16:06','',''),(2178583,'1','140','773',331,'Retail Sale Id 1286679',28800.00,0.00,0.00,0.00,550.00,'2021-12-06 10:19:41','',''),(2178584,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 10:19:41','',''),(2178651,'1','140','773',331,'Retail Sale Id 1286718',1240.00,0.00,0.00,0.00,110.00,'2021-12-06 10:25:34','',''),(2178652,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 10:25:34','',''),(2178757,'1','140','773',331,'Retail Sale Id 1286771',10368.00,0.00,0.00,0.00,198.00,'2021-12-06 10:31:58','',''),(2178758,'1','140','773',331,'Retail sales',0.00,0.00,0.00,18.00,0.00,'2021-12-06 10:31:58','',''),(2178890,'1','140','773',331,'Retail Sale Id 1286845',700.60,0.00,0.00,0.00,62.15,'2021-12-06 10:41:58','',''),(2178891,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.13,0.00,'2021-12-06 10:41:58','',''),(2179014,'1','140','773',331,'Retail Sale Id 1286909',34560.00,0.00,0.00,0.00,660.00,'2021-12-06 10:48:33','',''),(2179015,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-06 10:48:33','',''),(2179044,'1','140','773',331,'Retail Sale Id 1286932',620.00,0.00,0.00,0.00,55.00,'2021-12-06 10:50:14','',''),(2179045,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-06 10:50:14','',''),(2179291,'1','140','773',331,'Retail Sale Id 1287077',3100.00,0.00,0.00,0.00,275.00,'2021-12-06 11:05:35','',''),(2179292,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 11:05:35','',''),(2179315,'1','140','773',331,'Retail Sale Id 1287091',2498.60,0.00,0.00,0.00,221.65,'2021-12-06 11:06:54','',''),(2179316,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-06 11:06:54','',''),(2179373,'1','140','773',331,'Retail Sale Id 1287124',8680.00,0.00,0.00,0.00,770.00,'2021-12-06 11:10:33','',''),(2179374,'1','140','773',331,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-06 11:10:33','',''),(2179410,'1','140','773',331,'Retail Sale Id 1287143',1240.00,0.00,0.00,0.00,110.00,'2021-12-06 11:13:01','',''),(2179411,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 11:13:01','',''),(2179515,'1','140','773',331,'Retail Sale Id 1287200',7502.00,0.00,0.00,0.00,665.50,'2021-12-06 11:18:42','',''),(2179516,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.10,0.00,'2021-12-06 11:18:42','',''),(2179549,'1','140','773',331,'Retail Sale Id 1287217',3100.00,0.00,0.00,0.00,275.00,'2021-12-06 11:20:37','',''),(2179550,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 11:20:37','',''),(2179589,'1','140','773',331,'Retail Sale Id 1287238',11520.00,0.00,0.00,0.00,220.00,'2021-12-06 11:23:05','',''),(2179590,'1','140','773',331,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-06 11:23:05','',''),(2179845,'1','140','773',331,'Retail Sale Id 1287374',1240.00,0.00,0.00,0.00,110.00,'2021-12-06 11:43:23','',''),(2179846,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 11:43:23','',''),(2179932,'1','140','773',331,'Retail Sale Id 1287486',34560.00,0.00,0.00,0.00,660.00,'2021-12-06 11:49:45','',''),(2179933,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-06 11:49:45','',''),(2180136,'1','140','773',331,'Retail Sale Id 1287583',3720.00,0.00,0.00,0.00,330.00,'2021-12-06 12:03:22','',''),(2180137,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:03:22','',''),(2180212,'1','140','773',331,'Retail Sale Id 1287623',620.00,0.00,0.00,0.00,55.00,'2021-12-06 12:07:41','',''),(2180213,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-06 12:07:41','',''),(2180290,'1','140','773',331,'Retail Sale Id 1287673',63360.00,0.00,0.00,0.00,1210.00,'2021-12-06 12:12:42','',''),(2180291,'1','140','773',331,'Retail sales',0.00,0.00,0.00,110.00,0.00,'2021-12-06 12:12:42','',''),(2180366,'1','140','773',331,'Retail Sale Id 1287717',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 12:16:46','',''),(2180367,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:16:46','',''),(2180816,'1','140','773',331,'Retail Sale Id 1287953',17280.00,0.00,0.00,0.00,330.00,'2021-12-06 12:45:07','',''),(2180817,'1','140','773',331,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-06 12:45:07','',''),(2180884,'1','140','773',331,'Retail Sale Id 1287985',31680.00,0.00,0.00,0.00,605.00,'2021-12-06 12:48:53','',''),(2180885,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-06 12:48:53','',''),(2181346,'1','140','773',331,'Retail Sale Id 1288223',23040.00,0.00,0.00,0.00,440.00,'2021-12-06 13:14:47','',''),(2181347,'1','140','773',331,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-06 13:14:47','',''),(2181466,'1','140','773',331,'Retail Sale Id 1288265',343200.00,0.00,0.00,0.00,4200.00,'2021-12-06 13:20:04','',''),(2181467,'1','140','773',331,'Retail sales',0.00,0.00,0.00,600.00,0.00,'2021-12-06 13:20:04','',''),(2181682,'1','140','773',331,'Retail Sale Id 1288359',3100.00,0.00,0.00,0.00,275.00,'2021-12-06 13:35:06','',''),(2181683,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 13:35:06','',''),(2182143,'1','140','773',331,'Retail Sale Id 1288577',1500.40,0.00,0.00,0.00,133.10,'2021-12-06 13:57:37','',''),(2182144,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.42,0.00,'2021-12-06 13:57:37','',''),(2182169,'1','140','773',331,'Retail Sale Id 1288588',1500.40,0.00,0.00,0.00,133.10,'2021-12-06 13:58:41','',''),(2182170,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.42,0.00,'2021-12-06 13:58:41','',''),(2182295,'1','140','773',331,'Retail Sale Id 1288644',3100.00,0.00,0.00,0.00,275.00,'2021-12-06 14:04:07','',''),(2182296,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 14:04:07','',''),(2182353,'1','140','773',331,'Retail Sale Id 1288666',3720.00,0.00,0.00,0.00,330.00,'2021-12-06 14:06:48','',''),(2182354,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:06:48','',''),(2182418,'1','140','773',331,'Retail Sale Id 1288693',7750.00,0.00,0.00,0.00,687.50,'2021-12-06 14:09:52','',''),(2182419,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:09:52','',''),(2182482,'1','140','773',331,'Retail Sale Id 1288719',17280.00,0.00,0.00,0.00,330.00,'2021-12-06 14:12:01','',''),(2182483,'1','140','773',331,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-06 14:12:01','',''),(2182670,'1','140','773',331,'Retail Sale Id 1288808',34560.00,0.00,0.00,0.00,660.00,'2021-12-06 14:21:07','',''),(2182671,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-06 14:21:07','',''),(2182694,'1','140','773',331,'Retail Sale Id 1288817',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 14:22:25','',''),(2182695,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:22:25','',''),(2182754,'1','140','773',331,'Retail Sale Id 1288847',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 14:25:38','',''),(2182755,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:25:38','',''),(2183283,'1','140','773',331,'Retail Sale Id 1289080',2480.00,0.00,0.00,0.00,220.00,'2021-12-06 14:52:47','',''),(2183284,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 14:52:47','',''),(2183313,'1','140','773',331,'Retail Sale Id 1289094',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 14:54:06','',''),(2183314,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:54:06','',''),(2183335,'1','140','773',331,'Retail Sale Id 1289105',998.20,0.00,0.00,0.00,88.55,'2021-12-06 14:55:11','',''),(2183336,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-06 14:55:11','',''),(2183373,'1','140','773',331,'Retail Sale Id 1289126',620.00,0.00,0.00,0.00,55.00,'2021-12-06 14:57:13','',''),(2183374,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-06 14:57:13','',''),(2183471,'1','140','773',331,'Retail Sale Id 1289182',1240.00,0.00,0.00,0.00,110.00,'2021-12-06 15:02:53','',''),(2183472,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:02:53','',''),(2183491,'1','140','773',331,'Retail Sale Id 1289192',2480.00,0.00,0.00,0.00,220.00,'2021-12-06 15:03:53','',''),(2183492,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 15:03:53','',''),(2183874,'1','140','773',331,'Retail Sale Id 1289352',6200.00,0.00,0.00,0.00,550.00,'2021-12-06 15:23:00','',''),(2183875,'1','140','773',331,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 15:23:00','',''),(2183897,'1','140','773',331,'Retail Sale Id 1289368',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 15:24:02','',''),(2183898,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:24:02','',''),(2183929,'1','140','773',331,'Retail Sale Id 1289382',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 15:25:12','',''),(2183930,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:25:12','',''),(2183949,'1','140','773',331,'Retail Sale Id 1289391',620.00,0.00,0.00,0.00,55.00,'2021-12-06 15:26:13','',''),(2183950,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-06 15:26:13','',''),(2184009,'1','140','773',331,'Retail Sale Id 1289421',3720.00,0.00,0.00,0.00,330.00,'2021-12-06 15:29:28','',''),(2184010,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:29:28','',''),(2184154,'1','140','773',331,'Retail Sale Id 1289495',6200.00,0.00,0.00,0.00,550.00,'2021-12-06 15:37:26','',''),(2184155,'1','140','773',331,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 15:37:26','',''),(2184196,'1','140','773',331,'Retail Sale Id 1289513',1500.40,0.00,0.00,0.00,133.10,'2021-12-06 15:39:08','',''),(2184197,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.42,0.00,'2021-12-06 15:39:08','',''),(2184477,'1','140','773',331,'Retail Sale Id 1289600',2002.60,0.00,0.00,0.00,177.65,'2021-12-06 15:48:50','',''),(2184478,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.23,0.00,'2021-12-06 15:48:50','',''),(2184564,'1','140','773',331,'Retail Sale Id 1289645',1240.00,0.00,0.00,0.00,110.00,'2021-12-06 15:53:33','',''),(2184565,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:53:33','',''),(2184613,'1','140','773',331,'Retail Sale Id 1289666',4997.20,0.00,0.00,0.00,443.30,'2021-12-06 15:55:47','',''),(2184614,'1','140','773',331,'Retail sales',0.00,0.00,0.00,8.06,0.00,'2021-12-06 15:55:47','',''),(2184670,'1','140','773',331,'Retail Sale Id 1289690',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 15:58:33','',''),(2184671,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:58:33','',''),(2184693,'1','140','773',331,'Retail Sale Id 1289706',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 16:00:15','',''),(2184694,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:00:15','',''),(2184781,'1','140','773',331,'Retail Sale Id 1289745',2480.00,0.00,0.00,0.00,220.00,'2021-12-06 16:05:15','',''),(2184782,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 16:05:15','',''),(2184826,'1','140','773',331,'Retail Sale Id 1289764',13824.00,0.00,0.00,0.00,264.00,'2021-12-06 16:08:17','',''),(2184827,'1','140','773',331,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-06 16:08:17','',''),(2184876,'1','140','773',331,'Retail Sale Id 1289790',2002.60,0.00,0.00,0.00,177.65,'2021-12-06 16:11:56','',''),(2184878,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.23,0.00,'2021-12-06 16:11:56','',''),(2185126,'1','140','773',331,'Retail Sale Id 1289908',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 16:25:28','',''),(2185127,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:25:28','',''),(2185173,'1','140','773',331,'Retail Sale Id 1289930',1240.00,0.00,0.00,0.00,110.00,'2021-12-06 16:28:00','',''),(2185174,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 16:28:00','',''),(2185211,'1','140','773',331,'Retail Sale Id 1289951',2021162.00,0.00,0.00,0.00,24734.50,'2021-12-06 16:29:48','',''),(2185212,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3533.50,0.00,'2021-12-06 16:29:48','',''),(2185258,'1','140','773',331,'Retail Sale Id 1289974',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 16:32:08','',''),(2185259,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:32:08','',''),(2185306,'1','140','773',331,'Retail Sale Id 1289998',34560.00,0.00,0.00,0.00,660.00,'2021-12-06 16:34:26','',''),(2185307,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-06 16:34:26','',''),(2185367,'1','140','773',331,'Retail Sale Id 1290028',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 16:37:55','',''),(2185368,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:37:55','',''),(2185474,'1','140','773',331,'Retail Sale Id 1290076',1240.00,0.00,0.00,0.00,110.00,'2021-12-06 16:44:14','',''),(2185475,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 16:44:14','',''),(2185521,'1','140','773',331,'Retail Sale Id 1290099',1860.00,0.00,0.00,0.00,165.00,'2021-12-06 16:47:03','',''),(2185522,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:47:03','',''),(2185684,'1','140','773',331,'Retail Sale Id 1290178',620.00,0.00,0.00,0.00,55.00,'2021-12-06 16:54:57','',''),(2185685,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-06 16:54:57','',''),(2185712,'1','140','773',331,'Retail Sale Id 1290199',3720.00,0.00,0.00,0.00,330.00,'2021-12-06 16:56:44','',''),(2185713,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:56:44','',''),(2185770,'1','140','773',331,'Retail Sale Id 1290229',620.00,0.00,0.00,0.00,55.00,'2021-12-06 17:00:36','',''),(2185771,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-06 17:00:36','',''),(2185939,'1','140','773',331,'Retail Sale Id 1290321',1152.00,0.00,0.00,0.00,22.00,'2021-12-06 17:12:15','',''),(2185940,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 17:12:15','',''),(2187260,'1','140','773',331,'Retail Sale Id 1290717',25920.00,0.00,0.00,0.00,495.00,'2021-12-07 06:11:05','',''),(2187261,'1','140','773',331,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-07 06:11:05','',''),(2187398,'1','140','773',331,'Retail Sale Id 1290782',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 06:23:22','',''),(2187399,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 06:23:22','',''),(2187468,'1','140','773',331,'Retail Sale Id 1290817',33984.00,0.00,0.00,0.00,649.00,'2021-12-07 06:29:17','',''),(2187469,'1','140','773',331,'Retail sales',0.00,0.00,0.00,59.00,0.00,'2021-12-07 06:29:17','',''),(2187501,'1','140','773',331,'Retail Sale Id 1290834',620.00,0.00,0.00,0.00,55.00,'2021-12-07 06:32:27','',''),(2187502,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 06:32:27','',''),(2187515,'1','140','773',331,'Retail Sale Id 1290841',3100.00,0.00,0.00,0.00,275.00,'2021-12-07 06:33:50','',''),(2187516,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 06:33:50','',''),(2187581,'1','140','773',331,'Retail Sale Id 1290876',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 06:38:38','',''),(2187582,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 06:38:38','',''),(2187623,'1','140','773',331,'Retail Sale Id 1290899',52416.00,0.00,0.00,0.00,1001.00,'2021-12-07 06:40:44','',''),(2187624,'1','140','773',331,'Retail sales',0.00,0.00,0.00,91.00,0.00,'2021-12-07 06:40:44','',''),(2187928,'1','140','773',331,'Retail Sale Id 1291038',3720.00,0.00,0.00,0.00,330.00,'2021-12-07 06:59:58','',''),(2187929,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 06:59:58','',''),(2187950,'1','140','773',331,'Retail Sale Id 1291045',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 07:01:03','',''),(2187953,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:01:03','',''),(2188066,'1','140','773',331,'Retail Sale Id 1291108',7750.00,0.00,0.00,0.00,687.50,'2021-12-07 07:06:33','',''),(2188067,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:06:34','',''),(2188090,'1','140','773',331,'Retail Sale Id 1291118',34560.00,0.00,0.00,0.00,660.00,'2021-12-07 07:07:45','',''),(2188091,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-07 07:07:45','',''),(2188190,'1','140','773',331,'Retail Sale Id 1291171',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 07:12:50','',''),(2188191,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:12:50','',''),(2188320,'1','140','773',331,'Retail Sale Id 1291235',28800.00,0.00,0.00,0.00,550.00,'2021-12-07 07:18:38','',''),(2188321,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 07:18:38','',''),(2188534,'1','140','773',331,'Retail Sale Id 1291338',2480.00,0.00,0.00,0.00,220.00,'2021-12-07 07:28:39','',''),(2188535,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 07:28:39','',''),(2188587,'1','140','773',331,'Retail Sale Id 1291363',1240.00,0.00,0.00,0.00,110.00,'2021-12-07 07:30:55','',''),(2188588,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 07:30:55','',''),(2188720,'1','140','773',331,'Retail Sale Id 1291436',3720.00,0.00,0.00,0.00,330.00,'2021-12-07 07:37:30','',''),(2188721,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 07:37:30','',''),(2188840,'1','140','773',331,'Retail Sale Id 1291505',32832.00,0.00,0.00,0.00,627.00,'2021-12-07 07:43:28','',''),(2188841,'1','140','773',331,'Retail sales',0.00,0.00,0.00,57.00,0.00,'2021-12-07 07:43:28','',''),(2189043,'1','140','773',331,'Retail Sale Id 1291620',31680.00,0.00,0.00,0.00,605.00,'2021-12-07 07:54:41','',''),(2189044,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-07 07:54:41','',''),(2189097,'1','140','773',331,'Retail Sale Id 1291647',57600.00,0.00,0.00,0.00,1100.00,'2021-12-07 07:58:10','',''),(2189098,'1','140','773',331,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-07 07:58:10','',''),(2189141,'1','140','773',331,'Retail Sale Id 1291661',13248.00,0.00,0.00,0.00,253.00,'2021-12-07 07:59:45','',''),(2189142,'1','140','773',331,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-07 07:59:45','',''),(2189159,'1','140','773',331,'Retail Sale Id 1291672',3000.80,0.00,0.00,0.00,266.20,'2021-12-07 08:01:22','',''),(2189160,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.84,0.00,'2021-12-07 08:01:22','',''),(2189373,'1','140','773',331,'Retail Sale Id 1291774',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 08:13:38','',''),(2189374,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 08:13:38','',''),(2189551,'1','140','773',331,'Retail Sale Id 1291860',1550.00,0.00,0.00,0.00,137.50,'2021-12-07 08:23:05','',''),(2189552,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 08:23:05','',''),(2189691,'1','140','773',331,'Retail Sale Id 1291935',28800.00,0.00,0.00,0.00,550.00,'2021-12-07 08:33:32','',''),(2189692,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 08:33:32','',''),(2190090,'1','140','773',331,'Retail Sale Id 1292088',7750.00,0.00,0.00,0.00,687.50,'2021-12-07 08:50:47','',''),(2190091,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:50:47','',''),(2190273,'1','140','773',331,'Retail Sale Id 1292179',72000.00,0.00,0.00,0.00,1375.00,'2021-12-07 09:03:32','',''),(2190274,'1','140','773',331,'Retail sales',0.00,0.00,0.00,125.00,0.00,'2021-12-07 09:03:32','',''),(2190327,'1','140','773',331,'Retail Sale Id 1292202',1240.00,0.00,0.00,0.00,110.00,'2021-12-07 09:06:14','',''),(2190328,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 09:06:14','',''),(2190363,'1','140','773',331,'Retail Sale Id 1292218',13248.00,0.00,0.00,0.00,253.00,'2021-12-07 09:08:07','',''),(2190364,'1','140','773',331,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-07 09:08:07','',''),(2190475,'1','140','773',331,'Retail Sale Id 1292278',1240.00,0.00,0.00,0.00,110.00,'2021-12-07 09:14:16','',''),(2190476,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 09:14:16','',''),(2190569,'1','140','773',331,'Retail Sale Id 1292328',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 09:19:19','',''),(2190570,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:19:19','',''),(2190964,'1','140','773',331,'Retail Sale Id 1292512',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 09:38:58','',''),(2190965,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:38:58','',''),(2191028,'1','140','773',331,'Retail Sale Id 1292547',3720.00,0.00,0.00,0.00,330.00,'2021-12-07 09:42:15','',''),(2191029,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 09:42:15','',''),(2191368,'1','140','773',331,'Retail Sale Id 1292724',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 10:06:09','',''),(2191369,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:06:09','',''),(2191469,'1','140','773',331,'Retail Sale Id 1292781',1240.00,0.00,0.00,0.00,110.00,'2021-12-07 10:12:46','',''),(2191470,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 10:12:46','',''),(2191621,'1','140','773',331,'Retail Sale Id 1292859',2480.00,0.00,0.00,0.00,220.00,'2021-12-07 10:23:40','',''),(2191622,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 10:23:40','',''),(2191728,'1','140','773',331,'Retail Sale Id 1292911',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 10:32:50','',''),(2191729,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:32:50','',''),(2191945,'1','140','773',331,'Retail Sale Id 1293021',34560.00,0.00,0.00,0.00,660.00,'2021-12-07 10:46:13','',''),(2191946,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-07 10:46:13','',''),(2192104,'1','140','773',331,'Retail Sale Id 1293080',28800.00,0.00,0.00,0.00,550.00,'2021-12-07 10:53:19','',''),(2192105,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 10:53:19','',''),(2192211,'1','140','773',331,'Retail Sale Id 1293139',2480.00,0.00,0.00,0.00,220.00,'2021-12-07 10:59:26','',''),(2192212,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 10:59:26','',''),(2192292,'1','140','773',331,'Retail Sale Id 1293171',13824.00,0.00,0.00,0.00,264.00,'2021-12-07 11:02:56','',''),(2192293,'1','140','773',331,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-07 11:02:56','',''),(2192320,'1','140','773',331,'Retail Sale Id 1293184',1240.00,0.00,0.00,0.00,110.00,'2021-12-07 11:04:18','',''),(2192321,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 11:04:18','',''),(2192464,'1','140','773',331,'Retail Sale Id 1293260',31680.00,0.00,0.00,0.00,605.00,'2021-12-07 11:11:23','',''),(2192465,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-07 11:11:23','',''),(2192504,'1','140','773',331,'Retail Sale Id 1293283',34560.00,0.00,0.00,0.00,660.00,'2021-12-07 11:14:01','',''),(2192505,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-07 11:14:01','',''),(2192574,'1','140','773',331,'Retail Sale Id 1293328',1240.00,0.00,0.00,0.00,110.00,'2021-12-07 11:19:08','',''),(2192575,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 11:19:08','',''),(2192734,'1','140','773',331,'Retail Sale Id 1293433',1240.00,0.00,0.00,0.00,110.00,'2021-12-07 11:30:25','',''),(2192735,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 11:30:25','',''),(2192749,'1','140','773',331,'Retail Sale Id 1293436',3720.00,0.00,0.00,0.00,330.00,'2021-12-07 11:31:17','',''),(2192750,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 11:31:17','',''),(2192775,'1','140','773',331,'Retail Sale Id 1293449',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 11:33:52','',''),(2192776,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:33:52','',''),(2193287,'1','140','773',331,'Retail Sale Id 1293713',1500.40,0.00,0.00,0.00,133.10,'2021-12-07 12:15:01','',''),(2193288,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.42,0.00,'2021-12-07 12:15:01','',''),(2193395,'1','140','773',331,'Retail Sale Id 1293782',7750.00,0.00,0.00,0.00,687.50,'2021-12-07 12:27:11','',''),(2193396,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:27:11','',''),(2193451,'1','140','773',331,'Retail Sale Id 1293807',998.20,0.00,0.00,0.00,88.55,'2021-12-07 12:30:20','',''),(2193452,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-07 12:30:20','',''),(2193463,'1','140','773',331,'Retail Sale Id 1293812',998.20,0.00,0.00,0.00,88.55,'2021-12-07 12:31:21','',''),(2193464,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-07 12:31:21','',''),(2193841,'1','140','773',331,'Retail Sale Id 1294017',1240.00,0.00,0.00,0.00,110.00,'2021-12-07 12:58:56','',''),(2193842,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 12:58:56','',''),(2193966,'1','140','773',331,'Retail Sale Id 1294078',7750.00,0.00,0.00,0.00,687.50,'2021-12-07 13:06:30','',''),(2193967,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:06:30','',''),(2194493,'1','140','773',331,'Retail Sale Id 1294396',1240.00,0.00,0.00,0.00,110.00,'2021-12-07 13:36:45','',''),(2194494,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 13:36:45','',''),(2194609,'1','140','773',331,'Retail Sale Id 1294447',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 13:43:22','',''),(2194610,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 13:43:22','',''),(2194682,'1','140','773',331,'Retail Sale Id 1294486',2480.00,0.00,0.00,0.00,220.00,'2021-12-07 13:48:23','',''),(2194683,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 13:48:23','',''),(2194743,'1','140','773',331,'Retail Sale Id 1294503',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 13:51:38','',''),(2194744,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 13:51:38','',''),(2194931,'1','140','773',331,'Retail Sale Id 1294602',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 14:04:23','',''),(2194932,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 14:04:23','',''),(2194981,'1','140','773',331,'Retail Sale Id 1294630',1240.00,0.00,0.00,0.00,110.00,'2021-12-07 14:07:56','',''),(2194982,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 14:07:56','',''),(2195115,'1','140','773',331,'Retail Sale Id 1294682',620.00,0.00,0.00,0.00,55.00,'2021-12-07 14:14:05','',''),(2195116,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 14:14:05','',''),(2195262,'1','140','773',331,'Retail Sale Id 1294734',3100.00,0.00,0.00,0.00,275.00,'2021-12-07 14:22:13','',''),(2195263,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:22:13','',''),(2195286,'1','140','773',331,'Retail Sale Id 1294746',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 14:23:14','',''),(2195287,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 14:23:14','',''),(2195302,'1','140','773',331,'Retail Sale Id 1294756',1240.00,0.00,0.00,0.00,110.00,'2021-12-07 14:24:04','',''),(2195303,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 14:24:04','',''),(2195475,'1','140','773',331,'Retail Sale Id 1294831',620.00,0.00,0.00,0.00,55.00,'2021-12-07 14:33:32','',''),(2195476,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 14:33:32','',''),(2195537,'1','140','773',331,'Retail Sale Id 1294884',56448.00,0.00,0.00,0.00,1078.00,'2021-12-07 14:37:13','',''),(2195538,'1','140','773',331,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-07 14:37:13','',''),(2195643,'1','140','773',331,'Retail Sale Id 1294937',13824.00,0.00,0.00,0.00,264.00,'2021-12-07 14:43:08','',''),(2195644,'1','140','773',331,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-07 14:43:08','',''),(2195676,'1','140','773',331,'Retail Sale Id 1294946',1240.00,0.00,0.00,0.00,110.00,'2021-12-07 14:44:21','',''),(2195677,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 14:44:21','',''),(2195724,'1','140','773',331,'Retail Sale Id 1294975',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 14:47:15','',''),(2195725,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 14:47:15','',''),(2195780,'1','140','773',331,'Retail Sale Id 1295006',998.20,0.00,0.00,0.00,88.55,'2021-12-07 14:49:55','',''),(2195781,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-07 14:49:55','',''),(2195828,'1','140','773',331,'Retail Sale Id 1295030',11470.00,0.00,0.00,0.00,1017.50,'2021-12-07 14:51:49','',''),(2195829,'1','140','773',331,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-07 14:51:49','',''),(2195878,'1','140','773',331,'Retail Sale Id 1295060',1240.00,0.00,0.00,0.00,110.00,'2021-12-07 14:54:46','',''),(2195879,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 14:54:46','',''),(2195944,'1','140','773',331,'Retail Sale Id 1295095',39456.00,0.00,0.00,0.00,753.50,'2021-12-07 14:59:09','',''),(2195945,'1','140','773',331,'Retail sales',0.00,0.00,0.00,68.50,0.00,'2021-12-07 14:59:09','',''),(2196046,'1','140','773',331,'Retail Sale Id 1295128',28800.00,0.00,0.00,0.00,550.00,'2021-12-07 15:05:12','',''),(2196047,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 15:05:12','',''),(2196086,'1','140','773',331,'Retail Sale Id 1295154',411840.00,0.00,0.00,0.00,5040.00,'2021-12-07 15:07:30','',''),(2196087,'1','140','773',331,'Retail sales',0.00,0.00,0.00,720.00,0.00,'2021-12-07 15:07:30','',''),(2196114,'1','140','773',331,'Retail Sale Id 1295171',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 15:09:10','',''),(2196115,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:09:10','',''),(2196162,'1','140','773',331,'Retail Sale Id 1295189',620.00,0.00,0.00,0.00,55.00,'2021-12-07 15:11:17','',''),(2196163,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 15:11:17','',''),(2196280,'1','140','773',331,'Retail Sale Id 1295248',1240.00,0.00,0.00,0.00,110.00,'2021-12-07 15:17:10','',''),(2196281,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 15:17:10','',''),(2196526,'1','140','773',331,'Retail Sale Id 1295382',3720.00,0.00,0.00,0.00,330.00,'2021-12-07 15:30:15','',''),(2196527,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:30:15','',''),(2196598,'1','140','773',331,'Retail Sale Id 1295417',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 15:33:28','',''),(2196599,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:33:28','',''),(2196670,'1','140','773',331,'Retail Sale Id 1295451',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 15:37:27','',''),(2196671,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:37:27','',''),(2196707,'1','140','773',331,'Retail Sale Id 1295470',1240.00,0.00,0.00,0.00,110.00,'2021-12-07 15:38:36','',''),(2196708,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 15:38:36','',''),(2196759,'1','140','773',331,'Retail Sale Id 1295489',1240.00,0.00,0.00,0.00,110.00,'2021-12-07 15:40:24','',''),(2196760,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 15:40:24','',''),(2196883,'1','140','773',331,'Retail Sale Id 1295552',1240.00,0.00,0.00,0.00,110.00,'2021-12-07 15:46:22','',''),(2196884,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 15:46:22','',''),(2197044,'1','140','773',331,'Retail Sale Id 1295638',1240.00,0.00,0.00,0.00,110.00,'2021-12-07 15:54:01','',''),(2197045,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 15:54:01','',''),(2197078,'1','140','773',331,'Retail Sale Id 1295656',2480.00,0.00,0.00,0.00,220.00,'2021-12-07 15:55:57','',''),(2197079,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 15:55:57','',''),(2197159,'1','140','773',331,'Retail Sale Id 1295696',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 16:00:03','',''),(2197160,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:00:03','',''),(2197211,'1','140','773',331,'Retail Sale Id 1295727',5580.00,0.00,0.00,0.00,495.00,'2021-12-07 16:02:24','',''),(2197212,'1','140','773',331,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-07 16:02:24','',''),(2197332,'1','140','773',331,'Retail Sale Id 1295786',294580.00,0.00,0.00,0.00,3605.00,'2021-12-07 16:08:19','',''),(2197333,'1','140','773',331,'Retail sales',0.00,0.00,0.00,515.00,0.00,'2021-12-07 16:08:19','',''),(2197490,'1','140','773',331,'Retail Sale Id 1295862',620.00,0.00,0.00,0.00,55.00,'2021-12-07 16:15:42','',''),(2197491,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 16:15:42','',''),(2197525,'1','140','773',331,'Retail Sale Id 1295886',3720.00,0.00,0.00,0.00,330.00,'2021-12-07 16:17:18','',''),(2197526,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:17:18','',''),(2197697,'1','140','773',331,'Retail Sale Id 1295983',3720.00,0.00,0.00,0.00,330.00,'2021-12-07 16:25:18','',''),(2197698,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:25:18','',''),(2197743,'1','140','773',331,'Retail Sale Id 1296004',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 16:27:24','',''),(2197744,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:27:24','',''),(2197795,'1','140','773',331,'Retail Sale Id 1296032',620.00,0.00,0.00,0.00,55.00,'2021-12-07 16:29:44','',''),(2197796,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 16:29:44','',''),(2197837,'1','140','773',331,'Retail Sale Id 1296053',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 16:31:44','',''),(2197838,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:31:44','',''),(2197883,'1','140','773',331,'Retail Sale Id 1296078',13248.00,0.00,0.00,0.00,253.00,'2021-12-07 16:34:04','',''),(2197884,'1','140','773',331,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-07 16:34:04','',''),(2197952,'1','140','773',331,'Retail Sale Id 1296117',1860.00,0.00,0.00,0.00,165.00,'2021-12-07 16:38:24','',''),(2197953,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:38:24','',''),(2197998,'1','140','773',331,'Retail Sale Id 1296139',1240.00,0.00,0.00,0.00,110.00,'2021-12-07 16:41:23','',''),(2197999,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 16:41:23','',''),(2198016,'1','140','773',331,'Retail Sale Id 1296151',4340.00,0.00,0.00,0.00,385.00,'2021-12-07 16:42:57','',''),(2198017,'1','140','773',331,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 16:42:57','',''),(2198286,'1','140','773',331,'Retail Sale Id 1296285',620.00,0.00,0.00,0.00,55.00,'2021-12-07 16:57:14','',''),(2198287,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 16:57:14','',''),(2200523,'1','140','773',331,'Retail Sale Id 1297115',7502.00,0.00,0.00,0.00,665.50,'2021-12-08 07:05:26','',''),(2200524,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.10,0.00,'2021-12-08 07:05:26','',''),(2200595,'1','140','773',331,'Retail Sale Id 1297147',2002.60,0.00,0.00,0.00,177.65,'2021-12-08 07:10:35','',''),(2200596,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.23,0.00,'2021-12-08 07:10:35','',''),(2200605,'1','140','773',331,'Retail Sale Id 1297153',13824.00,0.00,0.00,0.00,264.00,'2021-12-08 07:11:44','',''),(2200606,'1','140','773',331,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-08 07:11:44','',''),(2200830,'1','140','773',331,'Retail Sale Id 1297260',1240.00,0.00,0.00,0.00,110.00,'2021-12-08 07:23:05','',''),(2200831,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 07:23:05','',''),(2201246,'1','140','773',331,'Retail Sale Id 1297449',34560.00,0.00,0.00,0.00,660.00,'2021-12-08 07:45:59','',''),(2201247,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-08 07:45:59','',''),(2201280,'1','140','773',331,'Retail Sale Id 1297461',1240.00,0.00,0.00,0.00,110.00,'2021-12-08 07:48:16','',''),(2201281,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 07:48:16','',''),(2201302,'1','140','773',331,'Retail Sale Id 1297480',1240.00,0.00,0.00,0.00,110.00,'2021-12-08 07:49:31','',''),(2201303,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 07:49:31','',''),(2201359,'1','140','773',331,'Retail Sale Id 1297504',1152.00,0.00,0.00,0.00,22.00,'2021-12-08 07:51:56','',''),(2201360,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 07:51:56','',''),(2201381,'1','140','773',331,'Retail Sale Id 1297516',13248.00,0.00,0.00,0.00,253.00,'2021-12-08 07:52:51','',''),(2201382,'1','140','773',331,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-08 07:52:51','',''),(2201448,'1','140','773',331,'Retail Sale Id 1297533',1240.00,0.00,0.00,0.00,110.00,'2021-12-08 07:54:53','',''),(2201449,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 07:54:53','',''),(2201535,'1','140','773',331,'Retail Sale Id 1297572',1860.00,0.00,0.00,0.00,165.00,'2021-12-08 07:59:06','',''),(2201536,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 07:59:06','',''),(2201561,'1','140','773',331,'Retail Sale Id 1297584',3720.00,0.00,0.00,0.00,330.00,'2021-12-08 08:00:44','',''),(2201562,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 08:00:44','',''),(2201585,'1','140','773',331,'Retail Sale Id 1297596',7750.00,0.00,0.00,0.00,687.50,'2021-12-08 08:02:11','',''),(2201586,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:02:11','',''),(2201689,'1','140','773',331,'Retail Sale Id 1297647',7750.00,0.00,0.00,0.00,687.50,'2021-12-08 08:07:28','',''),(2201690,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:07:28','',''),(2201701,'1','140','773',331,'Retail Sale Id 1297652',620.00,0.00,0.00,0.00,55.00,'2021-12-08 08:08:16','',''),(2201702,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 08:08:16','',''),(2201887,'1','140','773',331,'Retail Sale Id 1297749',31680.00,0.00,0.00,0.00,605.00,'2021-12-08 08:21:23','',''),(2201888,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-08 08:21:23','',''),(2201911,'1','140','773',331,'Retail Sale Id 1297768',1302.00,0.00,0.00,0.00,115.50,'2021-12-08 08:22:44','',''),(2201912,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-08 08:22:44','',''),(2201975,'1','140','773',331,'Retail Sale Id 1297798',240240.00,0.00,0.00,0.00,2940.00,'2021-12-08 08:26:58','',''),(2201976,'1','140','773',331,'Retail sales',0.00,0.00,0.00,420.00,0.00,'2021-12-08 08:26:58','',''),(2201989,'1','140','773',331,'Retail Sale Id 1297803',3100.00,0.00,0.00,0.00,275.00,'2021-12-08 08:27:37','',''),(2201990,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 08:27:37','',''),(2202088,'1','140','773',331,'Retail Sale Id 1297846',7130.00,0.00,0.00,0.00,632.50,'2021-12-08 08:34:18','',''),(2202089,'1','140','773',331,'Retail sales',0.00,0.00,0.00,11.50,0.00,'2021-12-08 08:34:18','',''),(2202214,'1','140','773',331,'Retail Sale Id 1297901',14400.00,0.00,0.00,0.00,275.00,'2021-12-08 08:41:02','',''),(2202215,'1','140','773',331,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 08:41:02','',''),(2202386,'1','140','773',331,'Retail Sale Id 1297952',1240.00,0.00,0.00,0.00,110.00,'2021-12-08 08:47:26','',''),(2202387,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 08:47:26','',''),(2202464,'1','140','773',331,'Retail Sale Id 1297975',7502.00,0.00,0.00,0.00,665.50,'2021-12-08 08:51:07','',''),(2202465,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.10,0.00,'2021-12-08 08:51:07','',''),(2202690,'1','140','773',331,'Retail Sale Id 1298078',28800.00,0.00,0.00,0.00,550.00,'2021-12-08 09:04:15','',''),(2202691,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 09:04:15','',''),(2202718,'1','140','773',331,'Retail Sale Id 1298091',17280.00,0.00,0.00,0.00,330.00,'2021-12-08 09:05:27','',''),(2202719,'1','140','773',331,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-08 09:05:27','',''),(2202744,'1','140','773',331,'Retail Sale Id 1298118',1860.00,0.00,0.00,0.00,165.00,'2021-12-08 09:07:02','',''),(2202745,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 09:07:02','',''),(2202924,'1','140','773',331,'Retail Sale Id 1298198',3100.00,0.00,0.00,0.00,275.00,'2021-12-08 09:17:05','',''),(2202925,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 09:17:05','',''),(2203129,'1','140','773',331,'Retail Sale Id 1298299',2480.00,0.00,0.00,0.00,220.00,'2021-12-08 09:34:23','',''),(2203130,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 09:34:23','',''),(2203217,'1','140','773',331,'Retail Sale Id 1298344',28800.00,0.00,0.00,0.00,550.00,'2021-12-08 09:40:53','',''),(2203218,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 09:40:53','',''),(2203352,'1','140','773',331,'Retail Sale Id 1298405',3720.00,0.00,0.00,0.00,330.00,'2021-12-08 09:50:06','',''),(2203353,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 09:50:06','',''),(2203408,'1','140','773',331,'Retail Sale Id 1298435',998.20,0.00,0.00,0.00,88.55,'2021-12-08 09:55:26','',''),(2203409,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-08 09:55:26','',''),(2203534,'1','140','773',331,'Retail Sale Id 1298487',23040.00,0.00,0.00,0.00,440.00,'2021-12-08 10:03:57','',''),(2203535,'1','140','773',331,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-08 10:03:57','',''),(2203573,'1','140','773',331,'Retail Sale Id 1298508',1500.40,0.00,0.00,0.00,133.10,'2021-12-08 10:07:09','',''),(2203574,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.42,0.00,'2021-12-08 10:07:09','',''),(2203833,'1','140','773',331,'Retail Sale Id 1298637',7750.00,0.00,0.00,0.00,687.50,'2021-12-08 10:23:25','',''),(2203834,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:23:25','',''),(2203913,'1','140','773',331,'Retail Sale Id 1298669',1860.00,0.00,0.00,0.00,165.00,'2021-12-08 10:27:32','',''),(2203914,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:27:32','',''),(2204005,'1','140','773',331,'Retail Sale Id 1298703',1860.00,0.00,0.00,0.00,165.00,'2021-12-08 10:33:15','',''),(2204006,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:33:15','',''),(2204135,'1','140','773',331,'Retail Sale Id 1298773',28800.00,0.00,0.00,0.00,550.00,'2021-12-08 10:43:30','',''),(2204136,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 10:43:30','',''),(2204160,'1','140','773',331,'Retail Sale Id 1298787',84096.00,0.00,0.00,0.00,1606.00,'2021-12-08 10:46:25','',''),(2204161,'1','140','773',331,'Retail sales',0.00,0.00,0.00,146.00,0.00,'2021-12-08 10:46:25','',''),(2204440,'1','140','773',331,'Retail Sale Id 1298924',3720.00,0.00,0.00,0.00,330.00,'2021-12-08 11:08:06','',''),(2204441,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:08:06','',''),(2204638,'1','140','773',331,'Retail Sale Id 1299029',16704.00,0.00,0.00,0.00,319.00,'2021-12-08 11:21:54','',''),(2204639,'1','140','773',331,'Retail sales',0.00,0.00,0.00,29.00,0.00,'2021-12-08 11:21:54','',''),(2204890,'1','140','773',331,'Retail Sale Id 1299162',2480.00,0.00,0.00,0.00,220.00,'2021-12-08 11:39:05','',''),(2204891,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 11:39:05','',''),(2204932,'1','140','773',331,'Retail Sale Id 1299184',1240.00,0.00,0.00,0.00,110.00,'2021-12-08 11:40:47','',''),(2204933,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 11:40:47','',''),(2204974,'1','140','773',331,'Retail Sale Id 1299203',1860.00,0.00,0.00,0.00,165.00,'2021-12-08 11:42:54','',''),(2204975,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:42:54','',''),(2205012,'1','140','773',331,'Retail Sale Id 1299222',1240.00,0.00,0.00,0.00,110.00,'2021-12-08 11:45:09','',''),(2205013,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 11:45:09','',''),(2205078,'1','140','773',331,'Retail Sale Id 1299253',3100.00,0.00,0.00,0.00,275.00,'2021-12-08 11:51:43','',''),(2205079,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 11:51:43','',''),(2205335,'1','140','773',331,'Retail Sale Id 1299366',7750.00,0.00,0.00,0.00,687.50,'2021-12-08 12:10:18','',''),(2205336,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:10:18','',''),(2205411,'1','140','773',331,'Retail Sale Id 1299403',7750.00,0.00,0.00,0.00,687.50,'2021-12-08 12:16:45','',''),(2205412,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:16:45','',''),(2205441,'1','140','773',331,'Retail Sale Id 1299415',7750.00,0.00,0.00,0.00,687.50,'2021-12-08 12:18:45','',''),(2205442,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:18:45','',''),(2205774,'1','140','773',331,'Retail Sale Id 1299576',620.00,0.00,0.00,0.00,55.00,'2021-12-08 12:43:51','',''),(2205775,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 12:43:51','',''),(2205868,'1','140','773',331,'Retail Sale Id 1299616',1240.00,0.00,0.00,0.00,110.00,'2021-12-08 12:49:00','',''),(2205869,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 12:49:00','',''),(2206393,'1','140','773',331,'Retail Sale Id 1299855',1860.00,0.00,0.00,0.00,165.00,'2021-12-08 13:25:10','',''),(2206394,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:25:10','',''),(2206916,'1','140','773',331,'Retail Sale Id 1300057',2480.00,0.00,0.00,0.00,220.00,'2021-12-08 13:53:20','',''),(2206917,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 13:53:20','',''),(2206967,'1','140','773',331,'Retail Sale Id 1300077',1860.00,0.00,0.00,0.00,165.00,'2021-12-08 13:55:59','',''),(2206968,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:55:59','',''),(2207049,'1','140','773',331,'Retail Sale Id 1300116',620.00,0.00,0.00,0.00,55.00,'2021-12-08 14:02:12','',''),(2207050,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 14:02:12','',''),(2207097,'1','140','773',331,'Retail Sale Id 1300136',13824.00,0.00,0.00,0.00,264.00,'2021-12-08 14:05:08','',''),(2207098,'1','140','773',331,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-08 14:05:08','',''),(2207127,'1','140','773',331,'Retail Sale Id 1300151',2480.00,0.00,0.00,0.00,220.00,'2021-12-08 14:07:36','',''),(2207128,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 14:07:36','',''),(2207148,'1','140','773',331,'Retail Sale Id 1300158',620.00,0.00,0.00,0.00,55.00,'2021-12-08 14:08:32','',''),(2207149,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 14:08:32','',''),(2207195,'1','140','773',331,'Retail Sale Id 1300174',13248.00,0.00,0.00,0.00,253.00,'2021-12-08 14:10:43','',''),(2207196,'1','140','773',331,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-08 14:10:43','',''),(2207216,'1','140','773',331,'Retail Sale Id 1300185',1240.00,0.00,0.00,0.00,110.00,'2021-12-08 14:12:36','',''),(2207217,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 14:12:36','',''),(2207333,'1','140','773',331,'Retail Sale Id 1300248',930.00,0.00,0.00,0.00,82.50,'2021-12-08 14:20:04','',''),(2207334,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.50,0.00,'2021-12-08 14:20:04','',''),(2207498,'1','140','773',331,'Retail Sale Id 1300329',7750.00,0.00,0.00,0.00,687.50,'2021-12-08 14:28:43','',''),(2207499,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:28:43','',''),(2207732,'1','140','773',331,'Retail Sale Id 1300430',1240.00,0.00,0.00,0.00,110.00,'2021-12-08 14:38:54','',''),(2207733,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 14:38:54','',''),(2207927,'1','140','773',331,'Retail Sale Id 1300541',1860.00,0.00,0.00,0.00,165.00,'2021-12-08 14:50:02','',''),(2207928,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:50:02','',''),(2207955,'1','140','773',331,'Retail Sale Id 1300556',1860.00,0.00,0.00,0.00,165.00,'2021-12-08 14:52:00','',''),(2207956,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:52:00','',''),(2207983,'1','140','773',331,'Retail Sale Id 1300568',2480.00,0.00,0.00,0.00,220.00,'2021-12-08 14:53:53','',''),(2207984,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 14:53:53','',''),(2208035,'1','140','773',331,'Retail Sale Id 1300589',34560.00,0.00,0.00,0.00,660.00,'2021-12-08 14:57:19','',''),(2208036,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-08 14:57:19','',''),(2208055,'1','140','773',331,'Retail Sale Id 1300600',3720.00,0.00,0.00,0.00,330.00,'2021-12-08 14:59:23','',''),(2208056,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:59:23','',''),(2208075,'1','140','773',331,'Retail Sale Id 1300608',1240.00,0.00,0.00,0.00,110.00,'2021-12-08 15:00:37','',''),(2208076,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 15:00:37','',''),(2208091,'1','140','773',331,'Retail Sale Id 1300617',1860.00,0.00,0.00,0.00,165.00,'2021-12-08 15:02:18','',''),(2208092,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 15:02:19','',''),(2208130,'1','140','773',331,'Retail Sale Id 1300632',14400.00,0.00,0.00,0.00,275.00,'2021-12-08 15:04:49','',''),(2208131,'1','140','773',331,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 15:04:49','',''),(2208273,'1','140','773',331,'Retail Sale Id 1300688',1860.00,0.00,0.00,0.00,165.00,'2021-12-08 15:12:36','',''),(2208274,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 15:12:36','',''),(2208576,'1','140','773',331,'Retail Sale Id 1300839',1240.00,0.00,0.00,0.00,110.00,'2021-12-08 15:28:35','',''),(2208577,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 15:28:35','',''),(2208759,'1','140','773',331,'Retail Sale Id 1300935',1240.00,0.00,0.00,0.00,110.00,'2021-12-08 15:37:37','',''),(2208760,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 15:37:37','',''),(2208789,'1','140','773',331,'Retail Sale Id 1300953',1860.00,0.00,0.00,0.00,165.00,'2021-12-08 15:39:04','',''),(2208790,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 15:39:04','',''),(2208835,'1','140','773',331,'Retail Sale Id 1300976',1240.00,0.00,0.00,0.00,110.00,'2021-12-08 15:41:33','',''),(2208836,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 15:41:33','',''),(2208857,'1','140','773',331,'Retail Sale Id 1300988',799.80,0.00,0.00,0.00,70.95,'2021-12-08 15:42:34','',''),(2208858,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.29,0.00,'2021-12-08 15:42:34','',''),(2208989,'1','140','773',331,'Retail Sale Id 1301055',1240.00,0.00,0.00,0.00,110.00,'2021-12-08 15:50:05','',''),(2208990,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 15:50:05','',''),(2209057,'1','140','773',331,'Retail Sale Id 1301076',5580.00,0.00,0.00,0.00,495.00,'2021-12-08 15:53:17','',''),(2209058,'1','140','773',331,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-08 15:53:17','',''),(2209081,'1','140','773',331,'Retail Sale Id 1301091',4340.00,0.00,0.00,0.00,385.00,'2021-12-08 15:55:04','',''),(2209082,'1','140','773',331,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 15:55:04','',''),(2209147,'1','140','773',331,'Retail Sale Id 1301123',1240.00,0.00,0.00,0.00,110.00,'2021-12-08 15:59:00','',''),(2209148,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 15:59:00','',''),(2209468,'1','140','773',331,'Retail Sale Id 1301281',34560.00,0.00,0.00,0.00,660.00,'2021-12-08 16:12:30','',''),(2209469,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-08 16:12:30','',''),(2210181,'1','140','773',331,'Retail Sale Id 1301742',389818.00,0.00,0.00,0.00,4770.50,'2021-12-08 16:46:42','',''),(2210182,'1','140','773',331,'Retail sales',0.00,0.00,0.00,681.50,0.00,'2021-12-08 16:46:42','',''),(2211673,'1','140','773',331,'Retail Sale Id 1302259',2600884.00,0.00,0.00,0.00,31829.00,'2021-12-09 04:04:03','',''),(2211674,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4547.00,0.00,'2021-12-09 04:04:03','',''),(2211675,'1','140','773',331,'Retail Sale Id 1302260',4608.00,0.00,0.00,0.00,88.00,'2021-12-09 04:06:13','',''),(2211676,'1','140','773',331,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-09 04:06:13','',''),(2212125,'1','140','773',331,'Retail Sale Id 1302426',62208.00,0.00,0.00,0.00,1188.00,'2021-12-09 06:20:00','',''),(2212126,'1','140','773',331,'Retail sales',0.00,0.00,0.00,108.00,0.00,'2021-12-09 06:20:00','',''),(2212143,'1','140','773',331,'Retail Sale Id 1302434',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 06:21:03','',''),(2212144,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 06:21:03','',''),(2212161,'1','140','773',331,'Retail Sale Id 1302438',1240.00,0.00,0.00,0.00,110.00,'2021-12-09 06:22:01','',''),(2212162,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 06:22:01','',''),(2212173,'1','140','773',331,'Retail Sale Id 1302445',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 06:22:48','',''),(2212174,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 06:22:48','',''),(2212232,'1','140','773',331,'Retail Sale Id 1302472',2480.00,0.00,0.00,0.00,220.00,'2021-12-09 06:26:08','',''),(2212233,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 06:26:08','',''),(2212506,'1','140','773',331,'Retail Sale Id 1302592',1240.00,0.00,0.00,0.00,110.00,'2021-12-09 06:42:10','',''),(2212507,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 06:42:10','',''),(2212544,'1','140','773',331,'Retail Sale Id 1302611',7502.00,0.00,0.00,0.00,665.50,'2021-12-09 06:44:18','',''),(2212545,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.10,0.00,'2021-12-09 06:44:18','',''),(2212565,'1','140','773',331,'Retail Sale Id 1302619',19008.00,0.00,0.00,0.00,363.00,'2021-12-09 06:45:17','',''),(2212566,'1','140','773',331,'Retail sales',0.00,0.00,0.00,33.00,0.00,'2021-12-09 06:45:17','',''),(2212585,'1','140','773',331,'Retail Sale Id 1302627',34560.00,0.00,0.00,0.00,660.00,'2021-12-09 06:46:20','',''),(2212586,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-09 06:46:20','',''),(2213312,'1','140','773',331,'Retail Sale Id 1302960',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 07:22:33','',''),(2213313,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 07:22:33','',''),(2213334,'1','140','773',331,'Retail Sale Id 1302971',1240.00,0.00,0.00,0.00,110.00,'2021-12-09 07:23:34','',''),(2213335,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 07:23:34','',''),(2213356,'1','140','773',331,'Retail Sale Id 1302983',28800.00,0.00,0.00,0.00,550.00,'2021-12-09 07:24:39','',''),(2213357,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 07:24:39','',''),(2213482,'1','140','773',331,'Retail Sale Id 1303048',3100.00,0.00,0.00,0.00,275.00,'2021-12-09 07:30:38','',''),(2213483,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:30:38','',''),(2213676,'1','140','773',331,'Retail Sale Id 1303136',6912.00,0.00,0.00,0.00,132.00,'2021-12-09 07:40:50','',''),(2213677,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-09 07:40:50','',''),(2213733,'1','140','773',331,'Retail Sale Id 1303169',1240.00,0.00,0.00,0.00,110.00,'2021-12-09 07:43:12','',''),(2213734,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 07:43:12','',''),(2214547,'1','140','773',331,'Retail Sale Id 1303541',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 08:25:12','',''),(2214548,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 08:25:12','',''),(2214602,'1','140','773',331,'Retail Sale Id 1303575',33120.00,0.00,0.00,0.00,632.50,'2021-12-09 08:27:06','',''),(2214603,'1','140','773',331,'Retail sales',0.00,0.00,0.00,57.50,0.00,'2021-12-09 08:27:06','',''),(2214679,'1','140','773',331,'Retail Sale Id 1303606',3720.00,0.00,0.00,0.00,330.00,'2021-12-09 08:30:29','',''),(2214680,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 08:30:29','',''),(2214716,'1','140','773',331,'Retail Sale Id 1303621',2480.00,0.00,0.00,0.00,220.00,'2021-12-09 08:32:07','',''),(2214717,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 08:32:07','',''),(2214869,'1','140','773',331,'Retail Sale Id 1303705',3720.00,0.00,0.00,0.00,330.00,'2021-12-09 08:39:54','',''),(2214870,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 08:39:54','',''),(2214901,'1','140','773',331,'Retail Sale Id 1303718',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 08:41:07','',''),(2214902,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 08:41:07','',''),(2215259,'1','140','773',331,'Retail Sale Id 1303892',1240.00,0.00,0.00,0.00,110.00,'2021-12-09 09:01:26','',''),(2215260,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 09:01:26','',''),(2215311,'1','140','773',331,'Retail Sale Id 1303920',1240.00,0.00,0.00,0.00,110.00,'2021-12-09 09:04:24','',''),(2215312,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 09:04:24','',''),(2215416,'1','140','773',331,'Retail Sale Id 1303975',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 09:11:18','',''),(2215417,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 09:11:18','',''),(2215450,'1','140','773',331,'Retail Sale Id 1303991',3720.00,0.00,0.00,0.00,330.00,'2021-12-09 09:13:36','',''),(2215451,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 09:13:36','',''),(2215472,'1','140','773',331,'Retail Sale Id 1304001',7750.00,0.00,0.00,0.00,687.50,'2021-12-09 09:15:04','',''),(2215473,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:15:04','',''),(2215555,'1','140','773',331,'Retail Sale Id 1304045',7750.00,0.00,0.00,0.00,687.50,'2021-12-09 09:19:56','',''),(2215556,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:19:56','',''),(2215563,'1','140','773',331,'Retail Sale Id 1304049',1240.00,0.00,0.00,0.00,110.00,'2021-12-09 09:20:34','',''),(2215564,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 09:20:34','',''),(2215650,'1','140','773',331,'Retail Sale Id 1304090',11520.00,0.00,0.00,0.00,220.00,'2021-12-09 09:24:14','',''),(2215651,'1','140','773',331,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-09 09:24:14','',''),(2215688,'1','140','773',331,'Retail Sale Id 1304109',3100.00,0.00,0.00,0.00,275.00,'2021-12-09 09:26:21','',''),(2215689,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 09:26:21','',''),(2215754,'1','140','773',331,'Retail Sale Id 1304146',1240.00,0.00,0.00,0.00,110.00,'2021-12-09 09:30:40','',''),(2215755,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 09:30:40','',''),(2216034,'1','140','773',331,'Retail Sale Id 1304257',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 09:43:06','',''),(2216035,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 09:43:06','',''),(2216378,'1','140','773',331,'Retail Sale Id 1304404',11520.00,0.00,0.00,0.00,220.00,'2021-12-09 09:59:25','',''),(2216379,'1','140','773',331,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-09 09:59:25','',''),(2216673,'1','140','773',331,'Retail Sale Id 1304555',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 10:17:53','',''),(2216674,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 10:17:53','',''),(2216751,'1','140','773',331,'Retail Sale Id 1304596',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 10:22:54','',''),(2216752,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 10:22:54','',''),(2216935,'1','140','773',331,'Retail Sale Id 1304692',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 10:34:43','',''),(2216936,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 10:34:43','',''),(2216951,'1','140','773',331,'Retail Sale Id 1304698',2480.00,0.00,0.00,0.00,220.00,'2021-12-09 10:35:44','',''),(2216952,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 10:35:44','',''),(2216972,'1','140','773',331,'Retail Sale Id 1304709',1240.00,0.00,0.00,0.00,110.00,'2021-12-09 10:37:18','',''),(2216973,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 10:37:18','',''),(2217078,'1','140','773',331,'Retail Sale Id 1304762',3720.00,0.00,0.00,0.00,330.00,'2021-12-09 10:44:08','',''),(2217079,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 10:44:08','',''),(2217274,'1','140',NULL,331,'Purchased from AA RANO NIGERIA LIMITED',0.00,14102400.00,24960.00,0.00,0.00,'2021-12-09 10:57:37','',''),(2217305,'1','140',NULL,331,'Reception corrector for bridging 126713',0.00,0.00,0.00,24960.00,0.00,'2021-12-09 10:59:36','',''),(2217306,'1','140','773',331,'Received from bridging 126713',0.00,0.00,24960.00,0.00,0.00,'2021-12-09 10:59:36','',''),(2217538,'1','140','773',331,'Retail Sale Id 1304995',620.00,0.00,0.00,0.00,55.00,'2021-12-09 11:16:30','',''),(2217539,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 11:16:30','',''),(2217716,'1','140','773',331,'Retail Sale Id 1305077',9792.00,0.00,0.00,0.00,187.00,'2021-12-09 11:25:30','',''),(2217717,'1','140','773',331,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-09 11:25:30','',''),(2217911,'1','140','773',331,'Retail Sale Id 1305173',7750.00,0.00,0.00,0.00,687.50,'2021-12-09 11:37:49','',''),(2217912,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:37:49','',''),(2217945,'1','140','773',331,'Retail Sale Id 1305187',23040.00,0.00,0.00,0.00,440.00,'2021-12-09 11:40:19','',''),(2217946,'1','140','773',331,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-09 11:40:19','',''),(2218024,'1','140','773',331,'Retail Sale Id 1305225',34560.00,0.00,0.00,0.00,660.00,'2021-12-09 11:45:36','',''),(2218025,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-09 11:45:36','',''),(2218040,'1','140','773',331,'Retail Sale Id 1305232',57600.00,0.00,0.00,0.00,1100.00,'2021-12-09 11:46:31','',''),(2218041,'1','140','773',331,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-09 11:46:31','',''),(2218166,'1','140','773',331,'Retail Sale Id 1305297',3000.80,0.00,0.00,0.00,266.20,'2021-12-09 11:53:28','',''),(2218167,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.84,0.00,'2021-12-09 11:53:28','',''),(2218216,'1','140','773',331,'Retail Sale Id 1305325',1240.00,0.00,0.00,0.00,110.00,'2021-12-09 11:57:03','',''),(2218217,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 11:57:03','',''),(2218250,'1','140','773',331,'Retail Sale Id 1305338',3720.00,0.00,0.00,0.00,330.00,'2021-12-09 11:59:30','',''),(2218251,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 11:59:30','',''),(2218453,'1','140','773',331,'Retail Sale Id 1305442',620.00,0.00,0.00,0.00,55.00,'2021-12-09 12:12:11','',''),(2218454,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 12:12:11','',''),(2218600,'1','140','773',331,'Retail Sale Id 1305518',4960.00,0.00,0.00,0.00,440.00,'2021-12-09 12:21:49','',''),(2218601,'1','140','773',331,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-09 12:21:49','',''),(2218630,'1','140','773',331,'Retail Sale Id 1305537',8047.60,0.00,0.00,0.00,713.90,'2021-12-09 12:24:09','',''),(2218631,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.98,0.00,'2021-12-09 12:24:09','',''),(2218724,'1','140','773',331,'Retail Sale Id 1305594',4960.00,0.00,0.00,0.00,440.00,'2021-12-09 12:30:07','',''),(2218725,'1','140','773',331,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-09 12:30:07','',''),(2218991,'1','140','773',331,'Retail Sale Id 1305729',7750.00,0.00,0.00,0.00,687.50,'2021-12-09 12:45:46','',''),(2218992,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 12:45:46','',''),(2219077,'1','140','773',331,'Retail Sale Id 1305769',3100.00,0.00,0.00,0.00,275.00,'2021-12-09 12:49:35','',''),(2219078,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 12:49:35','',''),(2219244,'1','140','773',331,'Retail Sale Id 1305846',3503.00,0.00,0.00,0.00,310.75,'2021-12-09 12:58:56','',''),(2219245,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.65,0.00,'2021-12-09 12:58:56','',''),(2219375,'1','140','773',331,'Retail Sale Id 1305929',620.00,0.00,0.00,0.00,55.00,'2021-12-09 13:09:02','',''),(2219376,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 13:09:02','',''),(2219409,'1','140','773',331,'Retail Sale Id 1305945',13824.00,0.00,0.00,0.00,264.00,'2021-12-09 13:10:50','',''),(2219410,'1','140','773',331,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-09 13:10:50','',''),(2219966,'1','140','773',331,'Retail Sale Id 1306139',17280.00,0.00,0.00,0.00,330.00,'2021-12-09 13:41:07','',''),(2219967,'1','140','773',331,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-09 13:41:07','',''),(2219998,'1','140','773',331,'Retail Sale Id 1306155',3100.00,0.00,0.00,0.00,275.00,'2021-12-09 13:43:02','',''),(2219999,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 13:43:02','',''),(2220020,'1','140','773',331,'Retail Sale Id 1306168',2480.00,0.00,0.00,0.00,220.00,'2021-12-09 13:44:37','',''),(2220021,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 13:44:37','',''),(2220270,'1','140','773',331,'Retail Sale Id 1306290',1240.00,0.00,0.00,0.00,110.00,'2021-12-09 14:02:35','',''),(2220271,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 14:02:35','',''),(2220833,'1','140','773',331,'Retail Sale Id 1306591',4997.20,0.00,0.00,0.00,443.30,'2021-12-09 14:33:23','',''),(2220834,'1','140','773',331,'Retail sales',0.00,0.00,0.00,8.06,0.00,'2021-12-09 14:33:23','',''),(2220990,'1','140','773',331,'Retail Sale Id 1306654',7750.00,0.00,0.00,0.00,687.50,'2021-12-09 14:39:01','',''),(2220991,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:39:01','',''),(2221030,'1','140','773',331,'Retail Sale Id 1306680',620.00,0.00,0.00,0.00,55.00,'2021-12-09 14:40:52','',''),(2221031,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 14:40:52','',''),(2221159,'1','140','773',331,'Retail Sale Id 1306732',620.00,0.00,0.00,0.00,55.00,'2021-12-09 14:46:18','',''),(2221160,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 14:46:18','',''),(2221349,'1','140','773',331,'Retail Sale Id 1306792',1240.00,0.00,0.00,0.00,110.00,'2021-12-09 14:52:57','',''),(2221350,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 14:52:57','',''),(2221412,'1','140','773',331,'Retail Sale Id 1306813',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 14:55:16','',''),(2221413,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 14:55:16','',''),(2221434,'1','140','773',331,'Retail Sale Id 1306822',1202.80,0.00,0.00,0.00,106.70,'2021-12-09 14:56:45','',''),(2221435,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.94,0.00,'2021-12-09 14:56:45','',''),(2221466,'1','140','773',331,'Retail Sale Id 1306834',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 14:58:14','',''),(2221467,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 14:58:14','',''),(2221713,'1','140','773',331,'Retail Sale Id 1306974',677820.00,0.00,0.00,0.00,8295.00,'2021-12-09 15:11:12','',''),(2221714,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1185.00,0.00,'2021-12-09 15:11:12','',''),(2221743,'1','140','773',331,'Retail Sale Id 1306983',3720.00,0.00,0.00,0.00,330.00,'2021-12-09 15:12:59','',''),(2221744,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 15:12:59','',''),(2221767,'1','140','773',331,'Retail Sale Id 1307001',137280.00,0.00,0.00,0.00,1680.00,'2021-12-09 15:14:06','',''),(2221768,'1','140','773',331,'Retail sales',0.00,0.00,0.00,240.00,0.00,'2021-12-09 15:14:06','',''),(2221779,'1','140','773',331,'Retail Sale Id 1307009',1240.00,0.00,0.00,0.00,110.00,'2021-12-09 15:15:01','',''),(2221780,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 15:15:01','',''),(2221811,'1','140','773',331,'Retail Sale Id 1307026',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 15:16:32','',''),(2221812,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:16:32','',''),(2221897,'1','140','773',331,'Retail Sale Id 1307065',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 15:20:30','',''),(2221898,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:20:30','',''),(2221929,'1','140','773',331,'Retail Sale Id 1307083',10850.00,0.00,0.00,0.00,962.50,'2021-12-09 15:22:08','',''),(2221930,'1','140','773',331,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-09 15:22:08','',''),(2222029,'1','140','773',331,'Retail Sale Id 1307137',34560.00,0.00,0.00,0.00,660.00,'2021-12-09 15:27:07','',''),(2222030,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-09 15:27:07','',''),(2222087,'1','140','773',331,'Retail Sale Id 1307166',86400.00,0.00,0.00,0.00,1650.00,'2021-12-09 15:29:56','',''),(2222088,'1','140','773',331,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-09 15:29:56','',''),(2222302,'1','140','773',331,'Retail Sale Id 1307267',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 15:40:34','',''),(2222303,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:40:34','',''),(2222386,'1','140','773',331,'Retail Sale Id 1307309',998.20,0.00,0.00,0.00,88.55,'2021-12-09 15:45:44','',''),(2222387,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-09 15:45:44','',''),(2222483,'1','140','773',331,'Retail Sale Id 1307359',13824.00,0.00,0.00,0.00,264.00,'2021-12-09 15:51:52','',''),(2222484,'1','140','773',331,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-09 15:51:52','',''),(2222525,'1','140','773',331,'Retail Sale Id 1307379',1240.00,0.00,0.00,0.00,110.00,'2021-12-09 15:54:04','',''),(2222526,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 15:54:04','',''),(2222569,'1','140','773',331,'Retail Sale Id 1307401',1240.00,0.00,0.00,0.00,110.00,'2021-12-09 15:55:45','',''),(2222570,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 15:55:45','',''),(2222638,'1','140','773',331,'Retail Sale Id 1307433',9792.00,0.00,0.00,0.00,187.00,'2021-12-09 15:59:42','',''),(2222639,'1','140','773',331,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-09 15:59:42','',''),(2222797,'1','140','773',331,'Retail Sale Id 1307513',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 16:08:14','',''),(2222798,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:08:14','',''),(2222829,'1','140','773',331,'Retail Sale Id 1307530',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 16:09:17','',''),(2222830,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:09:17','',''),(2222847,'1','140','773',331,'Retail Sale Id 1307541',7750.00,0.00,0.00,0.00,687.50,'2021-12-09 16:10:19','',''),(2222848,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:10:19','',''),(2222937,'1','140','773',331,'Retail Sale Id 1307583',3100.00,0.00,0.00,0.00,275.00,'2021-12-09 16:15:06','',''),(2222938,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 16:15:06','',''),(2222973,'1','140','773',331,'Retail Sale Id 1307602',1240.00,0.00,0.00,0.00,110.00,'2021-12-09 16:16:46','',''),(2222974,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 16:16:46','',''),(2223003,'1','140','773',331,'Retail Sale Id 1307620',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 16:18:42','',''),(2223004,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:18:42','',''),(2223055,'1','140','773',331,'Retail Sale Id 1307639',70848.00,0.00,0.00,0.00,1353.00,'2021-12-09 16:21:14','',''),(2223056,'1','140','773',331,'Retail sales',0.00,0.00,0.00,123.00,0.00,'2021-12-09 16:21:14','',''),(2223115,'1','140','773',331,'Retail Sale Id 1307672',3720.00,0.00,0.00,0.00,330.00,'2021-12-09 16:25:38','',''),(2223116,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 16:25:38','',''),(2223146,'1','140','773',331,'Retail Sale Id 1307678',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 16:26:30','',''),(2223147,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:26:30','',''),(2223186,'1','140','773',331,'Retail Sale Id 1307699',7750.00,0.00,0.00,0.00,687.50,'2021-12-09 16:28:19','',''),(2223187,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:28:19','',''),(2223260,'1','140','773',331,'Retail Sale Id 1307735',2480.00,0.00,0.00,0.00,220.00,'2021-12-09 16:32:39','',''),(2223261,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 16:32:39','',''),(2223338,'1','140','773',331,'Retail Sale Id 1307771',7750.00,0.00,0.00,0.00,687.50,'2021-12-09 16:36:49','',''),(2223339,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:36:49','',''),(2223348,'1','140','773',331,'Retail Sale Id 1307777',2002.60,0.00,0.00,0.00,177.65,'2021-12-09 16:37:35','',''),(2223349,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.23,0.00,'2021-12-09 16:37:35','',''),(2223384,'1','140','773',331,'Retail Sale Id 1307790',1240.00,0.00,0.00,0.00,110.00,'2021-12-09 16:39:31','',''),(2223385,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 16:39:31','',''),(2223400,'1','140','773',331,'Retail Sale Id 1307796',1240.00,0.00,0.00,0.00,110.00,'2021-12-09 16:40:15','',''),(2223401,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 16:40:15','',''),(2223437,'1','140','773',331,'Retail Sale Id 1307806',28800.00,0.00,0.00,0.00,550.00,'2021-12-09 16:41:31','',''),(2223438,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 16:41:31','',''),(2223451,'1','140','773',331,'Retail Sale Id 1307812',31680.00,0.00,0.00,0.00,605.00,'2021-12-09 16:42:21','',''),(2223452,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-09 16:42:21','',''),(2223520,'1','140','773',331,'Retail Sale Id 1307835',3720.00,0.00,0.00,0.00,330.00,'2021-12-09 16:45:31','',''),(2223521,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 16:45:31','',''),(2223534,'1','140','773',331,'Retail Sale Id 1307840',11520.00,0.00,0.00,0.00,220.00,'2021-12-09 16:46:30','',''),(2223535,'1','140','773',331,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-09 16:46:30','',''),(2223601,'1','140','773',331,'Retail Sale Id 1307875',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 16:50:45','',''),(2223602,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:50:45','',''),(2223727,'1','140','773',331,'Retail Sale Id 1307933',34560.00,0.00,0.00,0.00,660.00,'2021-12-09 16:58:22','',''),(2223728,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-09 16:58:22','',''),(2223814,'1','140','773',331,'Retail Sale Id 1307973',1860.00,0.00,0.00,0.00,165.00,'2021-12-09 17:03:11','',''),(2223815,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 17:03:11','',''),(2223849,'1','140','773',331,'Retail Sale Id 1307989',23040.00,0.00,0.00,0.00,440.00,'2021-12-09 17:04:52','',''),(2223850,'1','140','773',331,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-09 17:04:52','',''),(2223965,'1','140','773',331,'Retail Sale Id 1308051',125268.00,0.00,0.00,0.00,1533.00,'2021-12-09 17:14:53','',''),(2223966,'1','140','773',331,'Retail sales',0.00,0.00,0.00,219.00,0.00,'2021-12-09 17:14:53','',''),(2223989,'1','140','773',331,'Return of Retail Sale Id 1306732',0.00,620.00,1.00,0.00,-55.00,'2021-12-09 17:16:58','',''),(2224931,'1','140','773',331,'Return of Retail Sale Id 1306974',0.00,677820.00,1185.00,0.00,-8295.00,'2021-12-10 04:55:59','',''),(2227535,'1','140','773',331,'Retail Sale Id 1309477',2002.60,0.00,0.00,0.00,177.65,'2021-12-10 08:31:28','',''),(2227536,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.23,0.00,'2021-12-10 08:31:28','',''),(2227950,'1','140','773',331,'Retail Sale Id 1309669',7750.00,0.00,0.00,0.00,687.50,'2021-12-10 08:50:25','',''),(2227951,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:50:25','',''),(2228028,'1','140','773',331,'Retail Sale Id 1309704',7750.00,0.00,0.00,0.00,687.50,'2021-12-10 08:53:38','',''),(2228029,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:53:38','',''),(2228140,'1','140','773',331,'Retail Sale Id 1309767',620.00,0.00,0.00,0.00,55.00,'2021-12-10 08:59:29','',''),(2228141,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-10 08:59:29','',''),(2228451,'1','140','773',331,'Retail Sale Id 1309909',28000.00,0.00,0.00,0.00,-250.00,'2021-12-10 09:15:06','',''),(2228452,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 09:15:06','',''),(2228465,'1','140','773',331,'Retail Sale Id 1309916',56000.00,0.00,0.00,0.00,-500.00,'2021-12-10 09:15:46','',''),(2228466,'1','140','773',331,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 09:15:46','',''),(2228591,'1','140','773',331,'Retail Sale Id 1309975',3100.00,0.00,0.00,0.00,275.00,'2021-12-10 09:24:11','',''),(2228592,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 09:24:11','',''),(2228614,'1','140','773',331,'Retail Sale Id 1309989',6200.00,0.00,0.00,0.00,550.00,'2021-12-10 09:25:48','',''),(2228615,'1','140','773',331,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 09:25:48','',''),(2228646,'1','140','773',331,'Retail Sale Id 1310002',1240.00,0.00,0.00,0.00,110.00,'2021-12-10 09:28:00','',''),(2228647,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 09:28:00','',''),(2228712,'1','140','773',331,'Retail Sale Id 1310035',1860.00,0.00,0.00,0.00,165.00,'2021-12-10 09:32:25','',''),(2228713,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 09:32:25','',''),(2228827,'1','140','773',331,'Retail Sale Id 1310088',2480.00,0.00,0.00,0.00,220.00,'2021-12-10 09:37:46','',''),(2228828,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 09:37:46','',''),(2228853,'1','140','773',331,'Retail Sale Id 1310099',28000.00,0.00,0.00,0.00,-250.00,'2021-12-10 09:39:26','',''),(2228854,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 09:39:26','',''),(2228949,'1','140','773',331,'Retail Sale Id 1310147',3100.00,0.00,0.00,0.00,275.00,'2021-12-10 09:44:25','',''),(2228950,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 09:44:25','',''),(2228997,'1','140','773',331,'Retail Sale Id 1310179',1240.00,0.00,0.00,0.00,110.00,'2021-12-10 09:47:53','',''),(2228998,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 09:47:53','',''),(2229069,'1','140','773',331,'Retail Sale Id 1310209',3720.00,0.00,0.00,0.00,330.00,'2021-12-10 09:52:04','',''),(2229070,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 09:52:04','',''),(2229163,'1','140','773',331,'Retail Sale Id 1310260',2480.00,0.00,0.00,0.00,220.00,'2021-12-10 09:57:37','',''),(2229164,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 09:57:37','',''),(2229282,'1','140','773',331,'Retail Sale Id 1310305',3720.00,0.00,0.00,0.00,330.00,'2021-12-10 10:04:08','',''),(2229283,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:04:08','',''),(2229455,'1','140','773',331,'Retail Sale Id 1310392',3100.00,0.00,0.00,0.00,275.00,'2021-12-10 10:13:50','',''),(2229456,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 10:13:50','',''),(2229485,'1','140','773',331,'Retail Sale Id 1310403',4960.00,0.00,0.00,0.00,440.00,'2021-12-10 10:14:59','',''),(2229486,'1','140','773',331,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-10 10:14:59','',''),(2229731,'1','140','773',331,'Retail Sale Id 1310517',3720.00,0.00,0.00,0.00,330.00,'2021-12-10 10:28:08','',''),(2229732,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:28:08','',''),(2229771,'1','140','773',331,'Retail Sale Id 1310536',2002.60,0.00,0.00,0.00,177.65,'2021-12-10 10:30:41','',''),(2229772,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.23,0.00,'2021-12-10 10:30:41','',''),(2230011,'1','140','773',331,'Retail Sale Id 1310644',1302.00,0.00,0.00,0.00,115.50,'2021-12-10 10:45:34','',''),(2230012,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-10 10:45:34','',''),(2230120,'1','140','773',331,'Retail Sale Id 1310688',28000.00,0.00,0.00,0.00,-250.00,'2021-12-10 10:50:34','',''),(2230121,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 10:50:34','',''),(2230234,'1','140','773',331,'Retail Sale Id 1310734',3720.00,0.00,0.00,0.00,330.00,'2021-12-10 10:56:49','',''),(2230235,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:56:49','',''),(2230336,'1','140','773',331,'Retail Sale Id 1310795',3720.00,0.00,0.00,0.00,330.00,'2021-12-10 11:03:08','',''),(2230337,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 11:03:08','',''),(2230380,'1','140','773',331,'Retail Sale Id 1310806',7750.00,0.00,0.00,0.00,687.50,'2021-12-10 11:04:49','',''),(2230381,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 11:04:49','',''),(2230461,'1','140','773',331,'Retail Sale Id 1310833',1500.40,0.00,0.00,0.00,133.10,'2021-12-10 11:08:39','',''),(2230462,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.42,0.00,'2021-12-10 11:08:39','',''),(2230477,'1','140','773',331,'Retail Sale Id 1310839',620.00,0.00,0.00,0.00,55.00,'2021-12-10 11:09:37','',''),(2230478,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-10 11:09:37','',''),(2230747,'1','140','773',331,'Retail Sale Id 1310950',1860.00,0.00,0.00,0.00,165.00,'2021-12-10 11:26:06','',''),(2230748,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:26:06','',''),(2231610,'1','140','773',331,'Retail Sale Id 1311403',1860.00,0.00,0.00,0.00,165.00,'2021-12-10 12:34:27','',''),(2231611,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 12:34:27','',''),(2231666,'1','140','773',331,'Retail Sale Id 1311446',1860.00,0.00,0.00,0.00,165.00,'2021-12-10 12:40:01','',''),(2231667,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 12:40:01','',''),(2231814,'1','140','773',331,'Retail Sale Id 1311511',1860.00,0.00,0.00,0.00,165.00,'2021-12-10 12:50:58','',''),(2231815,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 12:50:58','',''),(2231842,'1','140','773',331,'Retail Sale Id 1311526',1240.00,0.00,0.00,0.00,110.00,'2021-12-10 12:52:01','',''),(2231843,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 12:52:01','',''),(2232064,'1','140','773',331,'Retail Sale Id 1311639',7750.00,0.00,0.00,0.00,687.50,'2021-12-10 13:08:16','',''),(2232065,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:08:16','',''),(2232515,'1','140','773',331,'Retail Sale Id 1311846',7750.00,0.00,0.00,0.00,687.50,'2021-12-10 13:35:02','',''),(2232516,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:35:02','',''),(2232845,'1','140','773',331,'Retail Sale Id 1311985',1860.00,0.00,0.00,0.00,165.00,'2021-12-10 13:50:13','',''),(2232846,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 13:50:13','',''),(2232869,'1','140','773',331,'Retail Sale Id 1311991',2498.60,0.00,0.00,0.00,221.65,'2021-12-10 13:51:06','',''),(2232870,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-10 13:51:06','',''),(2232993,'1','140','773',331,'Retail Sale Id 1312049',1202.80,0.00,0.00,0.00,106.70,'2021-12-10 13:57:29','',''),(2232994,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.94,0.00,'2021-12-10 13:57:29','',''),(2233023,'1','140','773',331,'Retail Sale Id 1312064',6001.60,0.00,0.00,0.00,532.40,'2021-12-10 13:58:43','',''),(2233024,'1','140','773',331,'Retail sales',0.00,0.00,0.00,9.68,0.00,'2021-12-10 13:58:43','',''),(2233041,'1','140','773',331,'Retail Sale Id 1312074',998.20,0.00,0.00,0.00,88.55,'2021-12-10 13:59:23','',''),(2233042,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-10 13:59:23','',''),(2233648,'1','140','773',331,'Retail Sale Id 1312306',7502.00,0.00,0.00,0.00,665.50,'2021-12-10 14:27:49','',''),(2233649,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.10,0.00,'2021-12-10 14:27:49','',''),(2233715,'1','140','773',331,'Retail Sale Id 1312348',1860.00,0.00,0.00,0.00,165.00,'2021-12-10 14:30:32','',''),(2233716,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 14:30:32','',''),(2233882,'1','140','773',331,'Retail Sale Id 1312419',32480.00,0.00,0.00,0.00,-290.00,'2021-12-10 14:37:32','',''),(2233883,'1','140','773',331,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-10 14:37:32','',''),(2233997,'1','140','773',331,'Retail Sale Id 1312465',1860.00,0.00,0.00,0.00,165.00,'2021-12-10 14:42:20','',''),(2234000,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 14:42:20','',''),(2234199,'1','140','773',331,'Retail Sale Id 1312558',620.00,0.00,0.00,0.00,55.00,'2021-12-10 14:49:54','',''),(2234200,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-10 14:49:54','',''),(2234318,'1','140','773',331,'Retail Sale Id 1312616',2480.00,0.00,0.00,0.00,220.00,'2021-12-10 14:55:48','',''),(2234319,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 14:55:48','',''),(2234442,'1','140','773',331,'Retail Sale Id 1312678',1240.00,0.00,0.00,0.00,110.00,'2021-12-10 15:03:42','',''),(2234443,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 15:03:42','',''),(2234562,'1','140','773',331,'Retail Sale Id 1312738',1860.00,0.00,0.00,0.00,165.00,'2021-12-10 15:09:49','',''),(2234563,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 15:09:49','',''),(2234809,'1','140','773',331,'Retail Sale Id 1312858',620.00,0.00,0.00,0.00,55.00,'2021-12-10 15:20:09','',''),(2234810,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-10 15:20:09','',''),(2234940,'1','140','773',331,'Retail Sale Id 1312932',2480.00,0.00,0.00,0.00,220.00,'2021-12-10 15:25:00','',''),(2234941,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 15:25:00','',''),(2235103,'1','140','773',331,'Retail Sale Id 1312993',2480.00,0.00,0.00,0.00,220.00,'2021-12-10 15:29:53','',''),(2235104,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 15:29:53','',''),(2235133,'1','140','773',331,'Retail Sale Id 1313007',1240.00,0.00,0.00,0.00,110.00,'2021-12-10 15:31:28','',''),(2235134,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 15:31:28','',''),(2235155,'1','140','773',331,'Retail Sale Id 1313018',1860.00,0.00,0.00,0.00,165.00,'2021-12-10 15:32:38','',''),(2235156,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 15:32:38','',''),(2235227,'1','140','773',331,'Retail Sale Id 1313053',620.00,0.00,0.00,0.00,55.00,'2021-12-10 15:35:54','',''),(2235228,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-10 15:35:54','',''),(2235251,'1','140','773',331,'Retail Sale Id 1313064',2480.00,0.00,0.00,0.00,220.00,'2021-12-10 15:36:43','',''),(2235252,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 15:36:43','',''),(2235306,'1','140','773',331,'Retail Sale Id 1313092',7502.00,0.00,0.00,0.00,665.50,'2021-12-10 15:39:15','',''),(2235308,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.10,0.00,'2021-12-10 15:39:15','',''),(2235411,'1','140','773',331,'Retail Sale Id 1313118',33600.00,0.00,0.00,0.00,-300.00,'2021-12-10 15:43:11','',''),(2235412,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-10 15:43:11','',''),(2235489,'1','140','773',331,'Retail Sale Id 1313190',1202.80,0.00,0.00,0.00,106.70,'2021-12-10 15:47:01','',''),(2235490,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.94,0.00,'2021-12-10 15:47:01','',''),(2235576,'1','140','773',331,'Retail Sale Id 1313243',1860.00,0.00,0.00,0.00,165.00,'2021-12-10 15:51:52','',''),(2235577,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 15:51:52','',''),(2235616,'1','140','773',331,'Retail Sale Id 1313262',1240.00,0.00,0.00,0.00,110.00,'2021-12-10 15:53:49','',''),(2235617,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 15:53:49','',''),(2235718,'1','140','773',331,'Retail Sale Id 1313313',15500.00,0.00,0.00,0.00,1375.00,'2021-12-10 15:58:26','',''),(2235719,'1','140','773',331,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 15:58:26','',''),(2235734,'1','140','773',331,'Retail Sale Id 1313322',7750.00,0.00,0.00,0.00,687.50,'2021-12-10 15:59:01','',''),(2235735,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:59:02','',''),(2235747,'1','140','773',331,'Retail Sale Id 1313329',7750.00,0.00,0.00,0.00,687.50,'2021-12-10 15:59:37','',''),(2235748,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:59:37','',''),(2235774,'1','140','773',331,'Retail Sale Id 1313342',1178.00,0.00,0.00,0.00,104.50,'2021-12-10 16:00:26','',''),(2235775,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-10 16:00:26','',''),(2235830,'1','140','773',331,'Retail Sale Id 1313371',620.00,0.00,0.00,0.00,55.00,'2021-12-10 16:03:41','',''),(2235831,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-10 16:03:41','',''),(2236083,'1','140','773',331,'Retail Sale Id 1313488',2498.60,0.00,0.00,0.00,221.65,'2021-12-10 16:14:36','',''),(2236084,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-10 16:14:36','',''),(2236225,'1','140','773',331,'Retail Sale Id 1313568',1240.00,0.00,0.00,0.00,110.00,'2021-12-10 16:21:02','',''),(2236226,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 16:21:02','',''),(2236338,'1','140','773',331,'Retail Sale Id 1313628',567120.00,0.00,0.00,0.00,-9180.00,'2021-12-10 16:26:07','',''),(2236339,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1020.00,0.00,'2021-12-10 16:26:07','',''),(2236431,'1','140','773',331,'Retail Sale Id 1313670',26320.00,0.00,0.00,0.00,-235.00,'2021-12-10 16:29:50','',''),(2236432,'1','140','773',331,'Retail sales',0.00,0.00,0.00,47.00,0.00,'2021-12-10 16:29:50','',''),(2236445,'1','140','773',331,'Retail Sale Id 1313676',28000.00,0.00,0.00,0.00,-250.00,'2021-12-10 16:30:41','',''),(2236446,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 16:30:41','',''),(2236459,'1','140','773',331,'Retail Sale Id 1313686',28000.00,0.00,0.00,0.00,-250.00,'2021-12-10 16:31:24','',''),(2236460,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 16:31:24','',''),(2236475,'1','140','773',331,'Retail Sale Id 1313692',33600.00,0.00,0.00,0.00,-300.00,'2021-12-10 16:31:59','',''),(2236476,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-10 16:31:59','',''),(2236559,'1','140','773',331,'Retail Sale Id 1313729',33600.00,0.00,0.00,0.00,-300.00,'2021-12-10 16:36:16','',''),(2236560,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-10 16:36:16','',''),(2236567,'1','140','773',331,'Retail Sale Id 1313731',33600.00,0.00,0.00,0.00,-300.00,'2021-12-10 16:36:47','',''),(2236568,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-10 16:36:47','',''),(2236583,'1','140','773',331,'Retail Sale Id 1313738',26320.00,0.00,0.00,0.00,-235.00,'2021-12-10 16:37:29','',''),(2236584,'1','140','773',331,'Retail sales',0.00,0.00,0.00,47.00,0.00,'2021-12-10 16:37:29','',''),(2236620,'1','140','773',331,'Retail Sale Id 1313753',61600.00,0.00,0.00,0.00,-550.00,'2021-12-10 16:39:09','',''),(2236621,'1','140','773',331,'Retail sales',0.00,0.00,0.00,110.00,0.00,'2021-12-10 16:39:09','',''),(2236651,'1','140','773',331,'Retail Sale Id 1313762',33600.00,0.00,0.00,0.00,-300.00,'2021-12-10 16:40:21','',''),(2236652,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-10 16:40:21','',''),(2236678,'1','140','773',331,'Retail Sale Id 1313769',1240.00,0.00,0.00,0.00,110.00,'2021-12-10 16:42:05','',''),(2236679,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 16:42:05','',''),(2236796,'1','140','773',331,'Retail Sale Id 1313839',1097.40,0.00,0.00,0.00,97.35,'2021-12-10 16:49:19','',''),(2236797,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.77,0.00,'2021-12-10 16:49:19','',''),(2236868,'1','140','773',331,'Retail Sale Id 1313875',1252.40,0.00,0.00,0.00,111.10,'2021-12-10 16:53:39','',''),(2236869,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.02,0.00,'2021-12-10 16:53:39','',''),(2236909,'1','140','773',331,'Retail Sale Id 1313890',1240.00,0.00,0.00,0.00,110.00,'2021-12-10 16:55:50','',''),(2236910,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 16:55:50','',''),(2236931,'1','140','773',331,'Retail Sale Id 1313901',7750.00,0.00,0.00,0.00,687.50,'2021-12-10 16:57:26','',''),(2236932,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:57:26','',''),(2236947,'1','140','773',331,'Retail Sale Id 1313910',6820.00,0.00,0.00,0.00,605.00,'2021-12-10 16:58:50','',''),(2236948,'1','140','773',331,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-10 16:58:50','',''),(2236996,'1','140','773',331,'Retail Sale Id 1313942',3100.00,0.00,0.00,0.00,275.00,'2021-12-10 17:00:58','',''),(2236997,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 17:00:58','',''),(2237174,'1','140','773',331,'Retail Sale Id 1314023',1680.00,0.00,0.00,0.00,-15.00,'2021-12-10 17:15:06','',''),(2237175,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 17:15:06','',''),(2237200,'1','140','773',331,'Retail Sale Id 1314041',355840.00,0.00,0.00,0.00,-5760.00,'2021-12-10 17:17:24','',''),(2237201,'1','140','773',331,'Retail sales',0.00,0.00,0.00,640.00,0.00,'2021-12-10 17:17:24','',''),(2237226,'1','140','773',331,'Retail Sale Id 1314053',67200.00,0.00,0.00,0.00,-600.00,'2021-12-10 17:19:50','',''),(2237227,'1','140','773',331,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-10 17:19:50','',''),(2237234,'1','140','773',331,'Retail Sale Id 1314056',100800.00,0.00,0.00,0.00,-900.00,'2021-12-10 17:20:29','',''),(2237235,'1','140','773',331,'Retail sales',0.00,0.00,0.00,180.00,0.00,'2021-12-10 17:20:29','',''),(2237238,'1','140','773',331,'Retail Sale Id 1314059',56000.00,0.00,0.00,0.00,-500.00,'2021-12-10 17:21:06','',''),(2237239,'1','140','773',331,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 17:21:06','',''),(2237248,'1','140','773',331,'Retail Sale Id 1314066',28000.00,0.00,0.00,0.00,-250.00,'2021-12-10 17:21:38','',''),(2237249,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 17:21:38','',''),(2237260,'1','140','773',331,'Retail Sale Id 1314070',53200.00,0.00,0.00,0.00,-475.00,'2021-12-10 17:22:25','',''),(2237261,'1','140','773',331,'Retail sales',0.00,0.00,0.00,95.00,0.00,'2021-12-10 17:22:25','',''),(2239380,'1','140','773',331,'Retail Sale Id 1314874',1860.00,0.00,0.00,0.00,165.00,'2021-12-11 07:09:45','',''),(2239381,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 07:09:45','',''),(2239386,'1','140','773',331,'Retail Sale Id 1314877',1240.00,0.00,0.00,0.00,110.00,'2021-12-11 07:10:17','',''),(2239387,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 07:10:17','',''),(2239412,'1','140','773',331,'Retail Sale Id 1314890',13440.00,0.00,0.00,0.00,-120.00,'2021-12-11 07:11:38','',''),(2239413,'1','140','773',331,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-11 07:11:38','',''),(2239428,'1','140','773',331,'Retail Sale Id 1314898',3720.00,0.00,0.00,0.00,330.00,'2021-12-11 07:13:41','',''),(2239429,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 07:13:41','',''),(2239479,'1','140','773',331,'Retail Sale Id 1314929',1240.00,0.00,0.00,0.00,110.00,'2021-12-11 07:16:29','',''),(2239480,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 07:16:29','',''),(2239505,'1','140','773',331,'Retail Sale Id 1314942',4997.20,0.00,0.00,0.00,443.30,'2021-12-11 07:17:55','',''),(2239506,'1','140','773',331,'Retail sales',0.00,0.00,0.00,8.06,0.00,'2021-12-11 07:17:55','',''),(2239537,'1','140','773',331,'Retail Sale Id 1314959',1240.00,0.00,0.00,0.00,110.00,'2021-12-11 07:20:26','',''),(2239538,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 07:20:26','',''),(2239604,'1','140','773',331,'Retail Sale Id 1314997',13440.00,0.00,0.00,0.00,-120.00,'2021-12-11 07:24:10','',''),(2239605,'1','140','773',331,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-11 07:24:10','',''),(2239620,'1','140','773',331,'Retail Sale Id 1315021',28000.00,0.00,0.00,0.00,-250.00,'2021-12-11 07:24:58','',''),(2239621,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 07:24:58','',''),(2239658,'1','140','773',331,'Retail Sale Id 1315039',32648.00,0.00,0.00,0.00,-291.50,'2021-12-11 07:26:49','',''),(2239659,'1','140','773',331,'Retail sales',0.00,0.00,0.00,58.30,0.00,'2021-12-11 07:26:49','',''),(2239704,'1','140','773',331,'Retail Sale Id 1315060',1240.00,0.00,0.00,0.00,110.00,'2021-12-11 07:29:00','',''),(2239705,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 07:29:00','',''),(2240775,'1','140','773',331,'Retail Sale Id 1315553',620.00,0.00,0.00,0.00,55.00,'2021-12-11 08:16:38','',''),(2240776,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-11 08:16:38','',''),(2240878,'1','140','773',331,'Retail Sale Id 1315615',11200.00,0.00,0.00,0.00,-100.00,'2021-12-11 08:21:48','',''),(2240879,'1','140','773',331,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-11 08:21:48','',''),(2241202,'1','140','773',331,'Retail Sale Id 1315771',3720.00,0.00,0.00,0.00,330.00,'2021-12-11 08:38:59','',''),(2241203,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 08:38:59','',''),(2241279,'1','140','773',331,'Retail Sale Id 1315797',7750.00,0.00,0.00,0.00,687.50,'2021-12-11 08:42:36','',''),(2241280,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 08:42:36','',''),(2241366,'1','140','773',331,'Retail Sale Id 1315837',6200.00,0.00,0.00,0.00,550.00,'2021-12-11 08:46:22','',''),(2241369,'1','140','773',331,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 08:46:22','',''),(2241519,'1','140','773',331,'Retail Sale Id 1315906',1240.00,0.00,0.00,0.00,110.00,'2021-12-11 08:53:55','',''),(2241520,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 08:53:55','',''),(2241548,'1','140','773',331,'Retail Sale Id 1315918',7750.00,0.00,0.00,0.00,687.50,'2021-12-11 08:55:25','',''),(2241549,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 08:55:25','',''),(2241591,'1','140','773',331,'Retail Sale Id 1315934',67200.00,0.00,0.00,0.00,-600.00,'2021-12-11 08:56:45','',''),(2241592,'1','140','773',331,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-11 08:56:45','',''),(2241650,'1','140','773',331,'Retail Sale Id 1315952',23520.00,0.00,0.00,0.00,-210.00,'2021-12-11 08:58:44','',''),(2241651,'1','140','773',331,'Retail sales',0.00,0.00,0.00,42.00,0.00,'2021-12-11 08:58:44','',''),(2241820,'1','140','773',331,'Retail Sale Id 1316041',7130.00,0.00,0.00,0.00,632.50,'2021-12-11 09:05:51','',''),(2241821,'1','140','773',331,'Retail sales',0.00,0.00,0.00,11.50,0.00,'2021-12-11 09:05:51','',''),(2241992,'1','140','773',331,'Retail Sale Id 1316120',1120.00,0.00,0.00,0.00,-10.00,'2021-12-11 09:12:50','',''),(2241993,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 09:12:50','',''),(2242012,'1','140','773',331,'Retail Sale Id 1316131',162960.00,0.00,0.00,0.00,-1455.00,'2021-12-11 09:13:54','',''),(2242013,'1','140','773',331,'Retail sales',0.00,0.00,0.00,291.00,0.00,'2021-12-11 09:13:54','',''),(2242156,'1','140','773',331,'Retail Sale Id 1316194',2480.00,0.00,0.00,0.00,220.00,'2021-12-11 09:20:28','',''),(2242157,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 09:20:28','',''),(2242333,'1','140','773',331,'Retail Sale Id 1316286',2480.00,0.00,0.00,0.00,220.00,'2021-12-11 09:30:42','',''),(2242334,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 09:30:42','',''),(2242510,'1','140','773',331,'Retail Sale Id 1316381',2802.40,0.00,0.00,0.00,248.60,'2021-12-11 09:38:45','',''),(2242511,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.52,0.00,'2021-12-11 09:38:45','',''),(2242554,'1','140','773',331,'Retail Sale Id 1316406',6200.00,0.00,0.00,0.00,550.00,'2021-12-11 09:40:28','',''),(2242555,'1','140','773',331,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 09:40:28','',''),(2242742,'1','140','773',331,'Retail Sale Id 1316497',33600.00,0.00,0.00,0.00,-300.00,'2021-12-11 09:49:09','',''),(2242743,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-11 09:49:09','',''),(2243041,'1','140','773',331,'Retail Sale Id 1316641',6200.00,0.00,0.00,0.00,550.00,'2021-12-11 10:04:49','',''),(2243042,'1','140','773',331,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 10:04:49','',''),(2243100,'1','140','773',331,'Retail Sale Id 1316667',33600.00,0.00,0.00,0.00,-300.00,'2021-12-11 10:07:49','',''),(2243101,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-11 10:07:49','',''),(2243186,'1','140','773',331,'Retail Sale Id 1316692',63840.00,0.00,0.00,0.00,-570.00,'2021-12-11 10:10:45','',''),(2243187,'1','140','773',331,'Retail sales',0.00,0.00,0.00,114.00,0.00,'2021-12-11 10:10:45','',''),(2243201,'1','140','773',331,'Retail Sale Id 1316697',620.00,0.00,0.00,0.00,55.00,'2021-12-11 10:11:34','',''),(2243202,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-11 10:11:34','',''),(2243241,'1','140','773',331,'Retail Sale Id 1316719',1860.00,0.00,0.00,0.00,165.00,'2021-12-11 10:13:36','',''),(2243242,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 10:13:36','',''),(2243340,'1','140','773',331,'Retail Sale Id 1316757',620.00,0.00,0.00,0.00,55.00,'2021-12-11 10:17:06','',''),(2243341,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-11 10:17:06','',''),(2243375,'1','140','773',331,'Retail Sale Id 1316770',1240.00,0.00,0.00,0.00,110.00,'2021-12-11 10:18:23','',''),(2243376,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 10:18:23','',''),(2243523,'1','140','773',331,'Retail Sale Id 1316844',11470.00,0.00,0.00,0.00,1017.50,'2021-12-11 10:26:41','',''),(2243524,'1','140','773',331,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-11 10:26:41','',''),(2243766,'1','140','773',331,'Retail Sale Id 1316962',59360.00,0.00,0.00,0.00,-530.00,'2021-12-11 10:40:19','',''),(2243767,'1','140','773',331,'Retail sales',0.00,0.00,0.00,106.00,0.00,'2021-12-11 10:40:19','',''),(2244215,'1','140','773',331,'Retail Sale Id 1317171',1860.00,0.00,0.00,0.00,165.00,'2021-12-11 11:03:03','',''),(2244216,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 11:03:03','',''),(2244271,'1','140','773',331,'Retail Sale Id 1317199',33600.00,0.00,0.00,0.00,-300.00,'2021-12-11 11:05:39','',''),(2244272,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-11 11:05:39','',''),(2244313,'1','140','773',331,'Retail Sale Id 1317215',1860.00,0.00,0.00,0.00,165.00,'2021-12-11 11:07:49','',''),(2244314,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 11:07:49','',''),(2244353,'1','140','773',331,'Retail Sale Id 1317240',3100.00,0.00,0.00,0.00,275.00,'2021-12-11 11:09:52','',''),(2244354,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 11:09:52','',''),(2244419,'1','140','773',331,'Retail Sale Id 1317272',44800.00,0.00,0.00,0.00,-400.00,'2021-12-11 11:13:35','',''),(2244420,'1','140','773',331,'Retail sales',0.00,0.00,0.00,80.00,0.00,'2021-12-11 11:13:35','',''),(2244577,'1','140','773',331,'Retail Sale Id 1317350',1860.00,0.00,0.00,0.00,165.00,'2021-12-11 11:21:37','',''),(2244578,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 11:21:37','',''),(2244658,'1','140','773',331,'Retail Sale Id 1317390',1860.00,0.00,0.00,0.00,165.00,'2021-12-11 11:25:13','',''),(2244659,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 11:25:13','',''),(2244746,'1','140','773',331,'Retail Sale Id 1317431',86240.00,0.00,0.00,0.00,-770.00,'2021-12-11 11:29:57','',''),(2244747,'1','140','773',331,'Retail sales',0.00,0.00,0.00,154.00,0.00,'2021-12-11 11:29:57','',''),(2244826,'1','140','773',331,'Retail Sale Id 1317471',3100.00,0.00,0.00,0.00,275.00,'2021-12-11 11:34:22','',''),(2244827,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 11:34:22','',''),(2244862,'1','140','773',331,'Retail Sale Id 1317492',9610.00,0.00,0.00,0.00,852.50,'2021-12-11 11:36:21','',''),(2244863,'1','140','773',331,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-11 11:36:21','',''),(2244912,'1','140','773',331,'Retail Sale Id 1317521',667200.00,0.00,0.00,0.00,-10800.00,'2021-12-11 11:39:38','',''),(2244913,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1200.00,0.00,'2021-12-11 11:39:38','',''),(2244927,'1','140','773',331,'Retail Sale Id 1317531',861800.00,0.00,0.00,0.00,-13950.00,'2021-12-11 11:40:35','',''),(2244928,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1550.00,0.00,'2021-12-11 11:40:35','',''),(2244955,'1','140','773',331,'Retail Sale Id 1317536',54880.00,0.00,0.00,0.00,-490.00,'2021-12-11 11:42:10','',''),(2244956,'1','140','773',331,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-11 11:42:10','',''),(2244985,'1','140','773',331,'Retail Sale Id 1317563',166800.00,0.00,0.00,0.00,-2700.00,'2021-12-11 11:43:50','',''),(2244986,'1','140','773',331,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-11 11:43:50','',''),(2244991,'1','140','773',331,'Retail Sale Id 1317568',2480.00,0.00,0.00,0.00,220.00,'2021-12-11 11:44:33','',''),(2244992,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 11:44:33','',''),(2245059,'1','140','773',331,'Retail Sale Id 1317604',7750.00,0.00,0.00,0.00,687.50,'2021-12-11 11:49:59','',''),(2245060,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:49:59','',''),(2245077,'1','140','773',331,'Retail Sale Id 1317608',7750.00,0.00,0.00,0.00,687.50,'2021-12-11 11:50:22','',''),(2245078,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:50:22','',''),(2245091,'1','140','773',331,'Retail Sale Id 1317619',7750.00,0.00,0.00,0.00,687.50,'2021-12-11 11:50:55','',''),(2245092,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:50:55','',''),(2245105,'1','140','773',331,'Retail Sale Id 1317622',7750.00,0.00,0.00,0.00,687.50,'2021-12-11 11:51:51','',''),(2245106,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:51:51','',''),(2245276,'1','140','773',331,'Retail Sale Id 1317710',33600.00,0.00,0.00,0.00,-300.00,'2021-12-11 12:02:02','',''),(2245277,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-11 12:02:02','',''),(2245603,'1','140','773',331,'Retail Sale Id 1317926',620.00,0.00,0.00,0.00,55.00,'2021-12-11 12:22:59','',''),(2245604,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-11 12:22:59','',''),(2245764,'1','140','773',331,'Retail Sale Id 1317994',3720.00,0.00,0.00,0.00,330.00,'2021-12-11 12:31:24','',''),(2245765,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 12:31:24','',''),(2245916,'1','140','773',331,'Retail Sale Id 1318077',1240.00,0.00,0.00,0.00,110.00,'2021-12-11 12:41:31','',''),(2245917,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 12:41:31','',''),(2245967,'1','140','773',331,'Retail Sale Id 1318101',40600.00,0.00,0.00,0.00,-362.50,'2021-12-11 12:44:44','',''),(2245968,'1','140','773',331,'Retail sales',0.00,0.00,0.00,72.50,0.00,'2021-12-11 12:44:44','',''),(2246144,'1','140','773',331,'Retail Sale Id 1318190',78400.00,0.00,0.00,0.00,-700.00,'2021-12-11 12:57:35','',''),(2246145,'1','140','773',331,'Retail sales',0.00,0.00,0.00,140.00,0.00,'2021-12-11 12:57:35','',''),(2246196,'1','140','773',331,'Retail Sale Id 1318223',1240.00,0.00,0.00,0.00,110.00,'2021-12-11 13:01:19','',''),(2246197,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 13:01:19','',''),(2246427,'1','140','773',331,'Retail Sale Id 1318342',30800.00,0.00,0.00,0.00,-275.00,'2021-12-11 13:20:07','',''),(2246428,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-11 13:20:07','',''),(2246484,'1','140','773',331,'Retail Sale Id 1318363',21280.00,0.00,0.00,0.00,-190.00,'2021-12-11 13:22:52','',''),(2246485,'1','140','773',331,'Retail sales',0.00,0.00,0.00,38.00,0.00,'2021-12-11 13:22:52','',''),(2246592,'1','140','773',331,'Retail Sale Id 1318414',3503.00,0.00,0.00,0.00,310.75,'2021-12-11 13:28:59','',''),(2246593,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.65,0.00,'2021-12-11 13:28:59','',''),(2246663,'1','140','773',331,'Retail Sale Id 1318438',154000.00,0.00,0.00,0.00,-1375.00,'2021-12-11 13:33:24','',''),(2246664,'1','140','773',331,'Retail sales',0.00,0.00,0.00,275.00,0.00,'2021-12-11 13:33:24','',''),(2246731,'1','140','773',331,'Retail Sale Id 1318461',1240.00,0.00,0.00,0.00,110.00,'2021-12-11 13:37:09','',''),(2246732,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 13:37:09','',''),(2246933,'1','140','773',331,'Retail Sale Id 1318550',3720.00,0.00,0.00,0.00,330.00,'2021-12-11 13:51:54','',''),(2246934,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 13:51:54','',''),(2246978,'1','140','773',331,'Retail Sale Id 1318571',1860.00,0.00,0.00,0.00,165.00,'2021-12-11 13:54:56','',''),(2246979,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 13:54:56','',''),(2247040,'1','140','773',331,'Retail Sale Id 1318611',30800.00,0.00,0.00,0.00,-275.00,'2021-12-11 13:58:25','',''),(2247041,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-11 13:58:25','',''),(2247101,'1','140','773',331,'Retail Sale Id 1318645',1698.80,0.00,0.00,0.00,150.70,'2021-12-11 14:02:52','',''),(2247102,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.74,0.00,'2021-12-11 14:02:52','',''),(2247268,'1','140','773',331,'Retail Sale Id 1318722',4340.00,0.00,0.00,0.00,385.00,'2021-12-11 14:11:56','',''),(2247269,'1','140','773',331,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-11 14:11:56','',''),(2247308,'1','140','773',331,'Retail Sale Id 1318742',1240.00,0.00,0.00,0.00,110.00,'2021-12-11 14:14:16','',''),(2247309,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 14:14:16','',''),(2247386,'1','140','773',331,'Retail Sale Id 1318781',134400.00,0.00,0.00,0.00,-1200.00,'2021-12-11 14:18:47','',''),(2247387,'1','140','773',331,'Retail sales',0.00,0.00,0.00,240.00,0.00,'2021-12-11 14:18:47','',''),(2247534,'1','140','773',331,'Retail Sale Id 1318841',620.00,0.00,0.00,0.00,55.00,'2021-12-11 14:30:15','',''),(2247535,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-11 14:30:15','',''),(2247586,'1','140','773',331,'Retail Sale Id 1318883',930.00,0.00,0.00,0.00,82.50,'2021-12-11 14:34:12','',''),(2247587,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.50,0.00,'2021-12-11 14:34:12','',''),(2247642,'1','140','773',331,'Retail Sale Id 1318918',998.20,0.00,0.00,0.00,88.55,'2021-12-11 14:37:26','',''),(2247643,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-11 14:37:26','',''),(2247672,'1','140','773',331,'Retail Sale Id 1318939',8680.00,0.00,0.00,0.00,770.00,'2021-12-11 14:38:55','',''),(2247673,'1','140','773',331,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-11 14:38:55','',''),(2247756,'1','140','773',331,'Retail Sale Id 1318979',1240.00,0.00,0.00,0.00,110.00,'2021-12-11 14:43:51','',''),(2247757,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 14:43:51','',''),(2247792,'1','140','773',331,'Retail Sale Id 1318998',1860.00,0.00,0.00,0.00,165.00,'2021-12-11 14:46:26','',''),(2247793,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:46:26','',''),(2247812,'1','140','773',331,'Retail Sale Id 1319007',1860.00,0.00,0.00,0.00,165.00,'2021-12-11 14:47:33','',''),(2247813,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:47:33','',''),(2247840,'1','140','773',331,'Retail Sale Id 1319023',1240.00,0.00,0.00,0.00,110.00,'2021-12-11 14:48:48','',''),(2247841,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 14:48:48','',''),(2247862,'1','140','773',331,'Retail Sale Id 1319032',1860.00,0.00,0.00,0.00,165.00,'2021-12-11 14:49:56','',''),(2247863,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:49:56','',''),(2247877,'1','140','773',331,'Retail Sale Id 1319041',1240.00,0.00,0.00,0.00,110.00,'2021-12-11 14:51:28','',''),(2247878,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 14:51:28','',''),(2248308,'1','140','773',331,'Retail Sale Id 1319224',28000.00,0.00,0.00,0.00,-250.00,'2021-12-11 15:12:17','',''),(2248309,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 15:12:17','',''),(2248390,'1','140','773',331,'Retail Sale Id 1319266',33600.00,0.00,0.00,0.00,-300.00,'2021-12-11 15:16:21','',''),(2248391,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-11 15:16:21','',''),(2248486,'1','140','773',331,'Retail Sale Id 1319315',1240.00,0.00,0.00,0.00,110.00,'2021-12-11 15:21:58','',''),(2248487,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 15:21:58','',''),(2248512,'1','140','773',331,'Retail Sale Id 1319331',3720.00,0.00,0.00,0.00,330.00,'2021-12-11 15:23:26','',''),(2248513,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 15:23:26','',''),(2248732,'1','140','773',331,'Retail Sale Id 1319453',998.20,0.00,0.00,0.00,88.55,'2021-12-11 15:35:07','',''),(2248733,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-11 15:35:07','',''),(2248753,'1','140','773',331,'Retail Sale Id 1319467',1860.00,0.00,0.00,0.00,165.00,'2021-12-11 15:36:18','',''),(2248754,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 15:36:18','',''),(2248788,'1','140','773',331,'Retail Sale Id 1319484',2002.60,0.00,0.00,0.00,177.65,'2021-12-11 15:38:06','',''),(2248789,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.23,0.00,'2021-12-11 15:38:06','',''),(2248824,'1','140','773',331,'Retail Sale Id 1319503',6720.00,0.00,0.00,0.00,-60.00,'2021-12-11 15:40:24','',''),(2248825,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-11 15:40:24','',''),(2248975,'1','140','773',331,'Retail Sale Id 1319571',1240.00,0.00,0.00,0.00,110.00,'2021-12-11 15:47:19','',''),(2248976,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 15:47:19','',''),(2249029,'1','140','773',331,'Retail Sale Id 1319592',4340.00,0.00,0.00,0.00,385.00,'2021-12-11 15:50:09','',''),(2249030,'1','140','773',331,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-11 15:50:09','',''),(2249102,'1','140','773',331,'Retail Sale Id 1319640',3720.00,0.00,0.00,0.00,330.00,'2021-12-11 15:53:19','',''),(2249103,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 15:53:19','',''),(2249204,'1','140','773',331,'Retail Sale Id 1319677',3100.00,0.00,0.00,0.00,275.00,'2021-12-11 15:56:15','',''),(2249205,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 15:56:15','',''),(2249282,'1','140','773',331,'Retail Sale Id 1319702',2002.60,0.00,0.00,0.00,177.65,'2021-12-11 15:59:09','',''),(2249283,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.23,0.00,'2021-12-11 15:59:09','',''),(2249319,'1','140','773',331,'Retail Sale Id 1319718',1240.00,0.00,0.00,0.00,110.00,'2021-12-11 16:00:43','',''),(2249320,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 16:00:43','',''),(2249353,'1','140','773',331,'Retail Sale Id 1319735',1240.00,0.00,0.00,0.00,110.00,'2021-12-11 16:01:58','',''),(2249354,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 16:01:58','',''),(2249383,'1','140','773',331,'Retail Sale Id 1319750',992.00,0.00,0.00,0.00,88.00,'2021-12-11 16:03:09','',''),(2249384,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 16:03:09','',''),(2249399,'1','140','773',331,'Retail Sale Id 1319759',992.00,0.00,0.00,0.00,88.00,'2021-12-11 16:03:51','',''),(2249400,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 16:03:51','',''),(2249470,'1','140','773',331,'Retail Sale Id 1319797',1860.00,0.00,0.00,0.00,165.00,'2021-12-11 16:07:32','',''),(2249471,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:07:32','',''),(2249526,'1','140','773',331,'Retail Sale Id 1319815',1860.00,0.00,0.00,0.00,165.00,'2021-12-11 16:09:32','',''),(2249527,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:09:32','',''),(2249561,'1','140','773',331,'Retail Sale Id 1319837',1500.40,0.00,0.00,0.00,133.10,'2021-12-11 16:11:21','',''),(2249562,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.42,0.00,'2021-12-11 16:11:21','',''),(2249604,'1','140','773',331,'Retail Sale Id 1319906',2498.60,0.00,0.00,0.00,221.65,'2021-12-11 16:14:02','',''),(2249605,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-11 16:14:02','',''),(2249643,'1','140','773',331,'Retail Sale Id 1319927',1240.00,0.00,0.00,0.00,110.00,'2021-12-11 16:16:12','',''),(2249644,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 16:16:12','',''),(2249689,'1','140','773',331,'Retail Sale Id 1319951',1240.00,0.00,0.00,0.00,110.00,'2021-12-11 16:19:29','',''),(2249690,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 16:19:29','',''),(2249721,'1','140','773',331,'Retail Sale Id 1319967',2480.00,0.00,0.00,0.00,220.00,'2021-12-11 16:21:29','',''),(2249722,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 16:21:29','',''),(2249792,'1','140','773',331,'Retail Sale Id 1320000',1302.00,0.00,0.00,0.00,115.50,'2021-12-11 16:24:55','',''),(2249793,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-11 16:24:55','',''),(2249843,'1','140','773',331,'Retail Sale Id 1320025',998.20,0.00,0.00,0.00,88.55,'2021-12-11 16:28:24','',''),(2249844,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-11 16:28:24','',''),(2250097,'1','140','773',331,'Retail Sale Id 1320116',3720.00,0.00,0.00,0.00,330.00,'2021-12-11 16:39:31','',''),(2250098,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:39:31','',''),(2250142,'1','140','773',331,'Retail Sale Id 1320136',192376.00,0.00,0.00,0.00,-3114.00,'2021-12-11 16:42:04','',''),(2250143,'1','140','773',331,'Retail sales',0.00,0.00,0.00,346.00,0.00,'2021-12-11 16:42:04','',''),(2250162,'1','140','773',331,'Retail Sale Id 1320144',33600.00,0.00,0.00,0.00,-300.00,'2021-12-11 16:43:06','',''),(2250163,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-11 16:43:06','',''),(2250168,'1','140','773',331,'Retail Sale Id 1320149',7750.00,0.00,0.00,0.00,687.50,'2021-12-11 16:43:54','',''),(2250169,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:43:54','',''),(2250202,'1','140','773',331,'Retail Sale Id 1320164',1302.00,0.00,0.00,0.00,115.50,'2021-12-11 16:46:34','',''),(2250203,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-11 16:46:34','',''),(2250343,'1','140','773',331,'Retail Sale Id 1320221',1798.00,0.00,0.00,0.00,159.50,'2021-12-11 16:53:44','',''),(2250344,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-11 16:53:44','',''),(2250443,'1','140','773',331,'Retail Sale Id 1320260',6200.00,0.00,0.00,0.00,550.00,'2021-12-11 17:00:01','',''),(2250444,'1','140','773',331,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 17:00:01','',''),(2250532,'1','140','773',331,'Retail Sale Id 1320302',2480.00,0.00,0.00,0.00,220.00,'2021-12-11 17:04:11','',''),(2250533,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 17:04:11','',''),(2250550,'1','140','773',331,'Retail Sale Id 1320314',620.00,0.00,0.00,0.00,55.00,'2021-12-11 17:05:25','',''),(2250551,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-11 17:05:25','',''),(2250632,'1','140','773',331,'Retail Sale Id 1320363',11842.00,0.00,0.00,0.00,1050.50,'2021-12-11 17:13:28','',''),(2250633,'1','140','773',331,'Retail sales',0.00,0.00,0.00,19.10,0.00,'2021-12-11 17:13:28','',''),(2250666,'1','140','773',331,'Retail Sale Id 1320383',11200.00,0.00,0.00,0.00,-100.00,'2021-12-11 17:16:51','',''),(2250667,'1','140','773',331,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-11 17:16:51','',''),(2254861,'1','140','773',331,'Retail Sale Id 1322190',7750.00,0.00,0.00,0.00,687.50,'2021-12-12 09:16:08','',''),(2254862,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:16:08','',''),(2254895,'1','140','773',331,'Retail Sale Id 1322207',13440.00,0.00,0.00,0.00,-120.00,'2021-12-12 09:17:59','',''),(2254896,'1','140','773',331,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-12 09:17:59','',''),(2254919,'1','140','773',331,'Retail Sale Id 1322219',7750.00,0.00,0.00,0.00,687.50,'2021-12-12 09:19:00','',''),(2254920,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:19:00','',''),(2256253,'1','140','773',331,'Retail Sale Id 1322875',26320.00,0.00,0.00,0.00,-235.00,'2021-12-12 10:30:31','',''),(2256254,'1','140','773',331,'Retail sales',0.00,0.00,0.00,47.00,0.00,'2021-12-12 10:30:31','',''),(2257092,'1','140','773',331,'Retail Sale Id 1323300',7750.00,0.00,0.00,0.00,687.50,'2021-12-12 11:08:23','',''),(2257093,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:08:23','',''),(2257110,'1','140','773',331,'Retail Sale Id 1323313',3720.00,0.00,0.00,0.00,330.00,'2021-12-12 11:08:53','',''),(2257111,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 11:08:53','',''),(2257133,'1','140','773',331,'Retail Sale Id 1323321',1860.00,0.00,0.00,0.00,165.00,'2021-12-12 11:09:36','',''),(2257134,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 11:09:36','',''),(2257309,'1','140','773',331,'Retail Sale Id 1323397',1860.00,0.00,0.00,0.00,165.00,'2021-12-12 11:16:43','',''),(2257310,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 11:16:43','',''),(2257568,'1','140','773',331,'Retail Sale Id 1323538',28000.00,0.00,0.00,0.00,-250.00,'2021-12-12 11:28:21','',''),(2257569,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 11:28:21','',''),(2258012,'1','140','773',331,'Retail Sale Id 1323761',1240.00,0.00,0.00,0.00,110.00,'2021-12-12 11:49:52','',''),(2258013,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 11:49:52','',''),(2258259,'1','140','773',331,'Retail Sale Id 1323879',27440.00,0.00,0.00,0.00,-245.00,'2021-12-12 12:01:23','',''),(2258260,'1','140','773',331,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-12 12:01:23','',''),(2258326,'1','140','773',331,'Retail Sale Id 1323912',1860.00,0.00,0.00,0.00,165.00,'2021-12-12 12:05:28','',''),(2258327,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:05:28','',''),(2258356,'1','140','773',331,'Retail Sale Id 1323927',7750.00,0.00,0.00,0.00,687.50,'2021-12-12 12:07:42','',''),(2258357,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:07:42','',''),(2258390,'1','140','773',331,'Retail Sale Id 1323945',1240.00,0.00,0.00,0.00,110.00,'2021-12-12 12:09:56','',''),(2258391,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 12:09:56','',''),(2258834,'1','140','773',331,'Retail Sale Id 1324149',28000.00,0.00,0.00,0.00,-250.00,'2021-12-12 12:30:07','',''),(2258835,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 12:30:07','',''),(2258879,'1','140','773',331,'Retail Sale Id 1324173',3100.00,0.00,0.00,0.00,275.00,'2021-12-12 12:31:58','',''),(2258880,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 12:31:58','',''),(2258942,'1','140','773',331,'Retail Sale Id 1324204',28000.00,0.00,0.00,0.00,-250.00,'2021-12-12 12:34:42','',''),(2258943,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 12:34:42','',''),(2259050,'1','140','773',331,'Retail Sale Id 1324257',73920.00,0.00,0.00,0.00,-660.00,'2021-12-12 12:39:01','',''),(2259051,'1','140','773',331,'Retail sales',0.00,0.00,0.00,132.00,0.00,'2021-12-12 12:39:01','',''),(2259085,'1','140','773',331,'Retail Sale Id 1324274',3720.00,0.00,0.00,0.00,330.00,'2021-12-12 12:40:48','',''),(2259086,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 12:40:48','',''),(2259222,'1','140','773',331,'Retail Sale Id 1324339',30800.00,0.00,0.00,0.00,-275.00,'2021-12-12 12:47:25','',''),(2259223,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-12 12:47:25','',''),(2259665,'1','140','773',331,'Retail Sale Id 1324565',28000.00,0.00,0.00,0.00,-250.00,'2021-12-12 13:11:33','',''),(2259666,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 13:11:33','',''),(2259721,'1','140','773',331,'Retail Sale Id 1324591',50400.00,0.00,0.00,0.00,-450.00,'2021-12-12 13:14:31','',''),(2259722,'1','140','773',331,'Retail sales',0.00,0.00,0.00,90.00,0.00,'2021-12-12 13:14:31','',''),(2259811,'1','140','773',331,'Retail Sale Id 1324631',1860.00,0.00,0.00,0.00,165.00,'2021-12-12 13:18:15','',''),(2259812,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 13:18:15','',''),(2259873,'1','140','773',331,'Retail Sale Id 1324655',3999.00,0.00,0.00,0.00,354.75,'2021-12-12 13:21:35','',''),(2259874,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.45,0.00,'2021-12-12 13:21:35','',''),(2259893,'1','140','773',331,'Retail Sale Id 1324666',30800.00,0.00,0.00,0.00,-275.00,'2021-12-12 13:22:42','',''),(2259894,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-12 13:22:42','',''),(2259938,'1','140','773',331,'Retail Sale Id 1324681',28000.00,0.00,0.00,0.00,-250.00,'2021-12-12 13:24:24','',''),(2259939,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 13:24:24','',''),(2259960,'1','140','773',331,'Retail Sale Id 1324690',1240.00,0.00,0.00,0.00,110.00,'2021-12-12 13:25:52','',''),(2259961,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 13:25:52','',''),(2259982,'1','140','773',331,'Retail Sale Id 1324702',1860.00,0.00,0.00,0.00,165.00,'2021-12-12 13:26:58','',''),(2259983,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 13:26:58','',''),(2260015,'1','140','773',331,'Retail Sale Id 1324714',28000.00,0.00,0.00,0.00,-250.00,'2021-12-12 13:27:51','',''),(2260016,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 13:27:51','',''),(2260149,'1','140','773',331,'Retail Sale Id 1324735',56000.00,0.00,0.00,0.00,-500.00,'2021-12-12 13:33:36','',''),(2260150,'1','140','773',331,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-12 13:33:36','',''),(2260175,'1','140','773',331,'Retail Sale Id 1324777',16800.00,0.00,0.00,0.00,-150.00,'2021-12-12 13:35:01','',''),(2260176,'1','140','773',331,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-12 13:35:01','',''),(2260258,'1','140','773',331,'Retail Sale Id 1324788',868.00,0.00,0.00,0.00,77.00,'2021-12-12 13:39:37','',''),(2260259,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.40,0.00,'2021-12-12 13:39:37','',''),(2260305,'1','140','773',331,'Retail Sale Id 1324828',1240.00,0.00,0.00,0.00,110.00,'2021-12-12 13:40:59','',''),(2260306,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 13:40:59','',''),(2260374,'1','140','773',331,'Retail Sale Id 1324864',7750.00,0.00,0.00,0.00,687.50,'2021-12-12 13:45:02','',''),(2260375,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 13:45:02','',''),(2260456,'1','140','773',331,'Retail Sale Id 1324909',1860.00,0.00,0.00,0.00,165.00,'2021-12-12 13:49:15','',''),(2260457,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 13:49:15','',''),(2260625,'1','140','773',331,'Retail Sale Id 1324979',1860.00,0.00,0.00,0.00,165.00,'2021-12-12 13:56:50','',''),(2260626,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 13:56:50','',''),(2260874,'1','140','773',331,'Retail Sale Id 1325065',998.20,0.00,0.00,0.00,88.55,'2021-12-12 14:06:59','',''),(2260875,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-12 14:06:59','',''),(2260924,'1','140','773',331,'Retail Sale Id 1325086',7750.00,0.00,0.00,0.00,687.50,'2021-12-12 14:09:37','',''),(2260925,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 14:09:37','',''),(2260985,'1','140','773',331,'Retail Sale Id 1325102',28000.00,0.00,0.00,0.00,-250.00,'2021-12-12 14:11:37','',''),(2260986,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 14:11:37','',''),(2261021,'1','140','773',331,'Retail Sale Id 1325126',2480.00,0.00,0.00,0.00,220.00,'2021-12-12 14:14:16','',''),(2261022,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 14:14:16','',''),(2261053,'1','140','773',331,'Retail Sale Id 1325144',1240.00,0.00,0.00,0.00,110.00,'2021-12-12 14:16:17','',''),(2261054,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 14:16:17','',''),(2261079,'1','140','773',331,'Retail Sale Id 1325156',1860.00,0.00,0.00,0.00,165.00,'2021-12-12 14:17:38','',''),(2261080,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 14:17:38','',''),(2261104,'1','140','773',331,'Retail Sale Id 1325163',620.00,0.00,0.00,0.00,55.00,'2021-12-12 14:18:35','',''),(2261105,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 14:18:35','',''),(2261293,'1','140','773',331,'Retail Sale Id 1325219',746152.00,0.00,0.00,0.00,-12078.00,'2021-12-12 14:26:45','',''),(2261294,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1342.00,0.00,'2021-12-12 14:26:45','',''),(2261322,'1','140','773',331,'Retail Sale Id 1325232',1240.00,0.00,0.00,0.00,110.00,'2021-12-12 14:27:51','',''),(2261323,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 14:27:51','',''),(2261410,'1','140','773',331,'Retail Sale Id 1325261',2480.00,0.00,0.00,0.00,220.00,'2021-12-12 14:31:11','',''),(2261411,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 14:31:11','',''),(2261427,'1','140','773',331,'Retail Sale Id 1325268',25200.00,0.00,0.00,0.00,-225.00,'2021-12-12 14:32:43','',''),(2261428,'1','140','773',331,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-12 14:32:43','',''),(2261449,'1','140','773',331,'Retail Sale Id 1325282',34160.00,0.00,0.00,0.00,-305.00,'2021-12-12 14:34:05','',''),(2261450,'1','140','773',331,'Retail sales',0.00,0.00,0.00,61.00,0.00,'2021-12-12 14:34:05','',''),(2261488,'1','140','773',331,'Retail Sale Id 1325293',8060.00,0.00,0.00,0.00,715.00,'2021-12-12 14:35:52','',''),(2261489,'1','140','773',331,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-12 14:35:52','',''),(2261630,'1','140','773',331,'Retail Sale Id 1325373',3720.00,0.00,0.00,0.00,330.00,'2021-12-12 14:45:49','',''),(2261631,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 14:45:49','',''),(2261839,'1','140','773',331,'Retail Sale Id 1325458',1860.00,0.00,0.00,0.00,165.00,'2021-12-12 14:55:42','',''),(2261840,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 14:55:42','',''),(2261859,'1','140','773',331,'Retail Sale Id 1325466',1860.00,0.00,0.00,0.00,165.00,'2021-12-12 14:56:54','',''),(2261860,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 14:56:54','',''),(2261897,'1','140','773',331,'Retail Sale Id 1325480',12880.00,0.00,0.00,0.00,-115.00,'2021-12-12 14:58:38','',''),(2261898,'1','140','773',331,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-12 14:58:38','',''),(2261949,'1','140','773',331,'Retail Sale Id 1325508',1860.00,0.00,0.00,0.00,165.00,'2021-12-12 15:01:08','',''),(2261950,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 15:01:08','',''),(2262040,'1','140','773',331,'Retail Sale Id 1325527',1240.00,0.00,0.00,0.00,110.00,'2021-12-12 15:05:23','',''),(2262041,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 15:05:23','',''),(2262098,'1','140','773',331,'Retail Sale Id 1325561',92960.00,0.00,0.00,0.00,-830.00,'2021-12-12 15:08:27','',''),(2262099,'1','140','773',331,'Retail sales',0.00,0.00,0.00,166.00,0.00,'2021-12-12 15:08:27','',''),(2262202,'1','140','773',331,'Retail Sale Id 1325610',16800.00,0.00,0.00,0.00,-150.00,'2021-12-12 15:15:05','',''),(2262203,'1','140','773',331,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-12 15:15:05','',''),(2262289,'1','140','773',331,'Retail Sale Id 1325649',1240.00,0.00,0.00,0.00,110.00,'2021-12-12 15:19:40','',''),(2262290,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 15:19:40','',''),(2262501,'1','140','773',331,'Return of Retail Sale Id 1325610',0.00,16800.00,30.00,0.00,150.00,'2021-12-12 15:32:02','',''),(2262780,'1','140','773',331,'Retail Sale Id 1325878',5580.00,0.00,0.00,0.00,495.00,'2021-12-12 15:47:00','',''),(2262781,'1','140','773',331,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-12 15:47:00','',''),(2266097,'1','140','773',331,'Retail Sale Id 1327179',1240.00,0.00,0.00,0.00,110.00,'2021-12-13 07:20:36','',''),(2266098,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 07:20:36','',''),(2266129,'1','140','773',331,'Retail Sale Id 1327200',1240.00,0.00,0.00,0.00,110.00,'2021-12-13 07:22:47','',''),(2266130,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 07:22:47','',''),(2266143,'1','140','773',331,'Retail Sale Id 1327207',620.00,0.00,0.00,0.00,55.00,'2021-12-13 07:23:57','',''),(2266144,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-13 07:23:57','',''),(2266187,'1','140','773',331,'Retail Sale Id 1327222',3720.00,0.00,0.00,0.00,330.00,'2021-12-13 07:27:09','',''),(2266188,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:27:09','',''),(2266273,'1','140','773',331,'Retail Sale Id 1327267',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 07:32:07','',''),(2266274,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 07:32:07','',''),(2267009,'1','140','773',331,'Retail Sale Id 1327587',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 08:10:53','',''),(2267010,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 08:10:53','',''),(2267064,'1','140','773',331,'Retail Sale Id 1327607',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 08:12:53','',''),(2267065,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 08:12:53','',''),(2267186,'1','140','773',331,'Retail Sale Id 1327630',9520.00,0.00,0.00,0.00,-85.00,'2021-12-13 08:15:50','',''),(2267187,'1','140','773',331,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-13 08:15:50','',''),(2267240,'1','140','773',331,'Retail Sale Id 1327656',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 08:20:02','',''),(2267241,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 08:20:02','',''),(2267332,'1','140','773',331,'Retail Sale Id 1327709',32480.00,0.00,0.00,0.00,-290.00,'2021-12-13 08:26:30','',''),(2267333,'1','140','773',331,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-13 08:26:30','',''),(2267412,'1','140','773',331,'Retail Sale Id 1327747',2480.00,0.00,0.00,0.00,220.00,'2021-12-13 08:30:45','',''),(2267413,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 08:30:45','',''),(2267466,'1','140','773',331,'Retail Sale Id 1327778',7000.00,0.00,0.00,0.00,-62.50,'2021-12-13 08:33:20','',''),(2267467,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 08:33:20','',''),(2267514,'1','140','773',331,'Retail Sale Id 1327803',2480.00,0.00,0.00,0.00,220.00,'2021-12-13 08:35:35','',''),(2267515,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 08:35:35','',''),(2267625,'1','140','773',331,'Retail Sale Id 1327851',30800.00,0.00,0.00,0.00,-275.00,'2021-12-13 08:39:55','',''),(2267626,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-13 08:39:55','',''),(2268025,'1','140','773',331,'Retail Sale Id 1327997',3999.00,0.00,0.00,0.00,354.75,'2021-12-13 09:01:38','',''),(2268026,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.45,0.00,'2021-12-13 09:01:38','',''),(2268310,'1','140','773',331,'Retail Sale Id 1328130',3720.00,0.00,0.00,0.00,330.00,'2021-12-13 09:17:21','',''),(2268311,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 09:17:21','',''),(2268600,'1','140','773',331,'Retail Sale Id 1328271',28000.00,0.00,0.00,0.00,-250.00,'2021-12-13 09:35:31','',''),(2268601,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 09:35:31','',''),(2268777,'1','140','773',331,'Retail Sale Id 1328369',3100.00,0.00,0.00,0.00,275.00,'2021-12-13 09:48:15','',''),(2268778,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 09:48:15','',''),(2269135,'1','140','773',331,'Retail Sale Id 1328553',1500.40,0.00,0.00,0.00,133.10,'2021-12-13 10:10:30','',''),(2269136,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.42,0.00,'2021-12-13 10:10:30','',''),(2269323,'1','140','773',331,'Retail Sale Id 1328655',1240.00,0.00,0.00,0.00,110.00,'2021-12-13 10:25:44','',''),(2269324,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 10:25:44','',''),(2269495,'1','140','773',331,'Retail Sale Id 1328731',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 10:35:41','',''),(2269496,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:35:41','',''),(2269529,'1','140','773',331,'Retail Sale Id 1328745',7750.00,0.00,0.00,0.00,687.50,'2021-12-13 10:37:43','',''),(2269530,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 10:37:43','',''),(2269592,'1','140','773',331,'Retail Sale Id 1328775',7750.00,0.00,0.00,0.00,687.50,'2021-12-13 10:41:13','',''),(2269593,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 10:41:13','',''),(2269614,'1','140','773',331,'Retail Sale Id 1328787',3720.00,0.00,0.00,0.00,330.00,'2021-12-13 10:42:39','',''),(2269615,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 10:42:39','',''),(2269670,'1','140','773',331,'Retail Sale Id 1328807',1500.40,0.00,0.00,0.00,133.10,'2021-12-13 10:45:51','',''),(2269671,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.42,0.00,'2021-12-13 10:45:51','',''),(2269854,'1','140','773',331,'Retail Sale Id 1328907',33600.00,0.00,0.00,0.00,-300.00,'2021-12-13 10:57:00','',''),(2269855,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-13 10:57:00','',''),(2270222,'1','140','773',331,'Retail Sale Id 1329082',998.20,0.00,0.00,0.00,88.55,'2021-12-13 11:21:37','',''),(2270223,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-13 11:21:37','',''),(2270236,'1','140','773',331,'Retail Sale Id 1329087',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 11:22:49','',''),(2270237,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 11:22:49','',''),(2270258,'1','140','773',331,'Retail Sale Id 1329098',30800.00,0.00,0.00,0.00,-275.00,'2021-12-13 11:25:29','',''),(2270259,'1','140','773',331,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-13 11:25:29','',''),(2270352,'1','140','773',331,'Retail Sale Id 1329139',2480.00,0.00,0.00,0.00,220.00,'2021-12-13 11:31:44','',''),(2270353,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 11:31:44','',''),(2270447,'1','140','773',331,'Retail Sale Id 1329182',1240.00,0.00,0.00,0.00,110.00,'2021-12-13 11:39:46','',''),(2270448,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 11:39:46','',''),(2270572,'1','140','773',331,'Retail Sale Id 1329250',20160.00,0.00,0.00,0.00,-180.00,'2021-12-13 11:51:03','',''),(2270573,'1','140','773',331,'Retail sales',0.00,0.00,0.00,36.00,0.00,'2021-12-13 11:51:03','',''),(2270793,'1','140','773',331,'Retail Sale Id 1329371',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 12:11:56','',''),(2270794,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 12:11:56','',''),(2270819,'1','140','773',331,'Retail Sale Id 1329383',3720.00,0.00,0.00,0.00,330.00,'2021-12-13 12:13:48','',''),(2270820,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 12:13:48','',''),(2270845,'1','140','773',331,'Retail Sale Id 1329394',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 12:15:32','',''),(2270846,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 12:15:32','',''),(2271221,'1','140','773',331,'Retail Sale Id 1329610',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 12:42:52','',''),(2271222,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 12:42:52','',''),(2271269,'1','140','773',331,'Retail Sale Id 1329637',2498.60,0.00,0.00,0.00,221.65,'2021-12-13 12:46:04','',''),(2271270,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-13 12:46:04','',''),(2271465,'1','140','773',331,'Retail Sale Id 1329733',12880.00,0.00,0.00,0.00,-115.00,'2021-12-13 12:58:15','',''),(2271466,'1','140','773',331,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-13 12:58:15','',''),(2271507,'1','140','773',331,'Retail Sale Id 1329754',1240.00,0.00,0.00,0.00,110.00,'2021-12-13 13:00:21','',''),(2271508,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 13:00:21','',''),(2271577,'1','140','773',331,'Retail Sale Id 1329781',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 13:03:28','',''),(2271578,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 13:03:28','',''),(2271812,'1','140','773',331,'Retail Sale Id 1329893',33600.00,0.00,0.00,0.00,-300.00,'2021-12-13 13:17:44','',''),(2271813,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-13 13:17:44','',''),(2271826,'1','140','773',331,'Retail Sale Id 1329900',2498.60,0.00,0.00,0.00,221.65,'2021-12-13 13:19:43','',''),(2271827,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-13 13:19:43','',''),(2271874,'1','140','773',331,'Retail Sale Id 1329919',2498.60,0.00,0.00,0.00,221.65,'2021-12-13 13:22:30','',''),(2271875,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.03,0.00,'2021-12-13 13:22:30','',''),(2272234,'1','140','773',331,'Retail Sale Id 1330053',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 13:41:47','',''),(2272235,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 13:41:47','',''),(2272680,'1','140','773',331,'Retail Sale Id 1330248',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 14:07:03','',''),(2272681,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:07:03','',''),(2272750,'1','140','773',331,'Retail Sale Id 1330281',16800.00,0.00,0.00,0.00,-150.00,'2021-12-13 14:11:36','',''),(2272751,'1','140','773',331,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-13 14:11:36','',''),(2272776,'1','140','773',331,'Retail Sale Id 1330296',1240.00,0.00,0.00,0.00,110.00,'2021-12-13 14:12:36','',''),(2272777,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 14:12:36','',''),(2272786,'1','140','773',331,'Retail Sale Id 1330318',998.20,0.00,0.00,0.00,88.55,'2021-12-13 14:14:26','',''),(2272787,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-13 14:14:26','',''),(2272824,'1','140','773',331,'Retail Sale Id 1330396',2002.60,0.00,0.00,0.00,177.65,'2021-12-13 14:15:25','',''),(2272825,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.23,0.00,'2021-12-13 14:15:25','',''),(2273022,'1','140','773',331,'Retail Sale Id 1330478',28000.00,0.00,0.00,0.00,-250.00,'2021-12-13 14:27:44','',''),(2273023,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 14:27:44','',''),(2273058,'1','140','773',331,'Retail Sale Id 1330499',33600.00,0.00,0.00,0.00,-300.00,'2021-12-13 14:29:22','',''),(2273059,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-13 14:29:22','',''),(2273233,'1','140','773',331,'Retail Sale Id 1330571',3720.00,0.00,0.00,0.00,330.00,'2021-12-13 14:38:08','',''),(2273234,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 14:38:08','',''),(2273395,'1','140','773',331,'Retail Sale Id 1330650',3100.00,0.00,0.00,0.00,275.00,'2021-12-13 14:48:52','',''),(2273396,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 14:48:52','',''),(2273515,'1','140','773',331,'Retail Sale Id 1330711',1240.00,0.00,0.00,0.00,110.00,'2021-12-13 14:57:36','',''),(2273516,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 14:57:36','',''),(2273589,'1','140','773',331,'Retail Sale Id 1330759',1302.00,0.00,0.00,0.00,115.50,'2021-12-13 15:03:22','',''),(2273590,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-13 15:03:22','',''),(2273641,'1','140','773',331,'Retail Sale Id 1330786',998.20,0.00,0.00,0.00,88.55,'2021-12-13 15:07:11','',''),(2273642,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-13 15:07:11','',''),(2273661,'1','140','773',331,'Retail Sale Id 1330797',620.00,0.00,0.00,0.00,55.00,'2021-12-13 15:08:10','',''),(2273662,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-13 15:08:10','',''),(2273691,'1','140','773',331,'Retail Sale Id 1330811',1240.00,0.00,0.00,0.00,110.00,'2021-12-13 15:09:36','',''),(2273692,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 15:09:36','',''),(2273718,'1','140','773',331,'Retail Sale Id 1330827',1240.00,0.00,0.00,0.00,110.00,'2021-12-13 15:11:07','',''),(2273719,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 15:11:07','',''),(2273886,'1','140','773',331,'Retail Sale Id 1330895',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 15:21:05','',''),(2273887,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 15:21:05','',''),(2274001,'1','140','773',331,'Retail Sale Id 1330947',3720.00,0.00,0.00,0.00,330.00,'2021-12-13 15:25:57','',''),(2274002,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 15:25:57','',''),(2274095,'1','140','773',331,'Retail Sale Id 1330978',2002.60,0.00,0.00,0.00,177.65,'2021-12-13 15:29:12','',''),(2274096,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.23,0.00,'2021-12-13 15:29:12','',''),(2274129,'1','140','773',331,'Retail Sale Id 1330997',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 15:30:53','',''),(2274130,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 15:30:53','',''),(2274220,'1','140','773',331,'Retail Sale Id 1331035',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 15:34:11','',''),(2274221,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 15:34:11','',''),(2274341,'1','140','773',331,'Retail Sale Id 1331088',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 15:39:16','',''),(2274342,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 15:39:16','',''),(2274525,'1','140','773',331,'Retail Sale Id 1331187',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 15:47:58','',''),(2274526,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 15:47:58','',''),(2274633,'1','140','773',331,'Retail Sale Id 1331246',25760.00,0.00,0.00,0.00,-230.00,'2021-12-13 15:54:23','',''),(2274634,'1','140','773',331,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-13 15:54:23','',''),(2274673,'1','140','773',331,'Retail Sale Id 1331260',1240.00,0.00,0.00,0.00,110.00,'2021-12-13 15:56:26','',''),(2274674,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 15:56:26','',''),(2274704,'1','140','773',331,'Retail Sale Id 1331282',27440.00,0.00,0.00,0.00,-245.00,'2021-12-13 15:57:53','',''),(2274705,'1','140','773',331,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-13 15:57:53','',''),(2274719,'1','140','773',331,'Retail Sale Id 1331292',3720.00,0.00,0.00,0.00,330.00,'2021-12-13 15:59:08','',''),(2274720,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 15:59:08','',''),(2274766,'1','140','773',331,'Retail Sale Id 1331317',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 16:01:53','',''),(2274767,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 16:01:53','',''),(2274807,'1','140','773',331,'Retail Sale Id 1331334',998.20,0.00,0.00,0.00,88.55,'2021-12-13 16:03:34','',''),(2274808,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.61,0.00,'2021-12-13 16:03:34','',''),(2274998,'1','140','773',331,'Retail Sale Id 1331434',459256.00,0.00,0.00,0.00,-7434.00,'2021-12-13 16:14:14','',''),(2274999,'1','140','773',331,'Retail sales',0.00,0.00,0.00,826.00,0.00,'2021-12-13 16:14:14','',''),(2275099,'1','140','773',331,'Retail Sale Id 1331479',7750.00,0.00,0.00,0.00,687.50,'2021-12-13 16:19:13','',''),(2275100,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:19:13','',''),(2275175,'1','140','773',331,'Retail Sale Id 1331516',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 16:22:40','',''),(2275176,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 16:22:40','',''),(2275208,'1','140','773',331,'Retail Sale Id 1331532',620.00,0.00,0.00,0.00,55.00,'2021-12-13 16:24:24','',''),(2275209,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-13 16:24:24','',''),(2275249,'1','140','773',331,'Retail Sale Id 1331554',3100.00,0.00,0.00,0.00,275.00,'2021-12-13 16:26:30','',''),(2275250,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 16:26:30','',''),(2275328,'1','140','773',331,'Retail Sale Id 1331596',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 16:31:05','',''),(2275329,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 16:31:05','',''),(2275405,'1','140','773',331,'Retail Sale Id 1331635',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 16:35:37','',''),(2275406,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 16:35:37','',''),(2275542,'1','140','773',331,'Retail Sale Id 1331710',1500.40,0.00,0.00,0.00,133.10,'2021-12-13 16:43:36','',''),(2275543,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.42,0.00,'2021-12-13 16:43:36','',''),(2275588,'1','140','773',331,'Retail Sale Id 1331734',1240.00,0.00,0.00,0.00,110.00,'2021-12-13 16:47:15','',''),(2275589,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 16:47:15','',''),(2275638,'1','140','773',331,'Retail Sale Id 1331755',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 16:51:28','',''),(2275639,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 16:51:28','',''),(2275695,'1','140','773',331,'Retail Sale Id 1331788',1860.00,0.00,0.00,0.00,165.00,'2021-12-13 16:54:44','',''),(2275696,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 16:54:44','',''),(2275787,'1','140','773',331,'Retail Sale Id 1331831',7750.00,0.00,0.00,0.00,687.50,'2021-12-13 17:01:29','',''),(2275788,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 17:01:29','',''),(2275807,'1','140','773',331,'Retail Sale Id 1331837',6200.00,0.00,0.00,0.00,550.00,'2021-12-13 17:02:24','',''),(2275808,'1','140','773',331,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 17:02:24','',''),(2275866,'1','140','773',331,'Retail Sale Id 1331861',3100.00,0.00,0.00,0.00,275.00,'2021-12-13 17:08:01','',''),(2275867,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 17:08:01','',''),(2275884,'1','140','773',331,'Retail Sale Id 1331871',831220.00,0.00,0.00,0.00,-13455.00,'2021-12-13 17:09:11','',''),(2275885,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1495.00,0.00,'2021-12-13 17:09:11','',''),(2278170,'1','140','773',331,'Retail Sale Id 1332674',20900.00,0.00,0.00,0.00,380.00,'2021-12-14 07:28:45','',''),(2278171,'1','140','773',331,'Retail sales',0.00,0.00,0.00,38.00,0.00,'2021-12-14 07:28:45','',''),(2278182,'1','140','773',331,'Retail Sale Id 1332680',33000.00,0.00,0.00,0.00,600.00,'2021-12-14 07:29:42','',''),(2278183,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-14 07:29:42','',''),(2278196,'1','140','773',331,'Retail Sale Id 1332687',6000.00,0.00,0.00,0.00,600.00,'2021-12-14 07:30:22','',''),(2278197,'1','140','773',331,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-14 07:30:22','',''),(2278216,'1','140','773',331,'Retail Sale Id 1332696',1200.00,0.00,0.00,0.00,120.00,'2021-12-14 07:31:22','',''),(2278217,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-14 07:31:22','',''),(2278229,'1','140','773',331,'Retail Sale Id 1332703',1800.00,0.00,0.00,0.00,180.00,'2021-12-14 07:32:13','',''),(2278230,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 07:32:13','',''),(2278257,'1','140','773',331,'Retail Sale Id 1332715',1200.00,0.00,0.00,0.00,120.00,'2021-12-14 07:34:02','',''),(2278258,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-14 07:34:02','',''),(2278273,'1','140','773',331,'Retail Sale Id 1332722',1800.00,0.00,0.00,0.00,180.00,'2021-12-14 07:34:59','',''),(2278274,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 07:34:59','',''),(2278289,'1','140','773',331,'Retail Sale Id 1332732',33000.00,0.00,0.00,0.00,600.00,'2021-12-14 07:35:56','',''),(2278290,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-14 07:35:56','',''),(2278299,'1','140','773',331,'Retail Sale Id 1332737',600.00,0.00,0.00,0.00,60.00,'2021-12-14 07:36:34','',''),(2278300,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-14 07:36:34','',''),(2278351,'1','140','773',331,'Retail Sale Id 1332766',47850.00,0.00,0.00,0.00,870.00,'2021-12-14 07:38:53','',''),(2278352,'1','140','773',331,'Retail sales',0.00,0.00,0.00,87.00,0.00,'2021-12-14 07:38:53','',''),(2278370,'1','140','773',331,'Retail Sale Id 1332776',900.00,0.00,0.00,0.00,90.00,'2021-12-14 07:39:43','',''),(2278371,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.50,0.00,'2021-12-14 07:39:43','',''),(2278374,'1','140','773',331,'Retail Sale Id 1332779',1800.00,0.00,0.00,0.00,180.00,'2021-12-14 07:40:24','',''),(2278375,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 07:40:24','',''),(2278404,'1','140','773',331,'Retail Sale Id 1332792',13750.00,0.00,0.00,0.00,250.00,'2021-12-14 07:41:27','',''),(2278405,'1','140','773',331,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-14 07:41:27','',''),(2278432,'1','140','773',331,'Retail Sale Id 1332807',3840.00,0.00,0.00,0.00,384.00,'2021-12-14 07:42:36','',''),(2278433,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.40,0.00,'2021-12-14 07:42:36','',''),(2278495,'1','140','773',331,'Retail Sale Id 1332952',92400.00,0.00,0.00,0.00,1680.00,'2021-12-14 07:48:41','',''),(2278497,'1','140','773',331,'Retail sales',0.00,0.00,0.00,168.00,0.00,'2021-12-14 07:48:41','',''),(2278526,'1','140','773',331,'Retail Sale Id 1332845',7500.00,0.00,0.00,0.00,750.00,'2021-12-14 07:50:35','',''),(2278527,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 07:50:35','',''),(2278548,'1','140','773',331,'Retail Sale Id 1332976',600.00,0.00,0.00,0.00,60.00,'2021-12-14 07:51:16','',''),(2278549,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-14 07:51:16','',''),(2278999,'1','140','773',331,'Retail Sale Id 1333189',27500.00,0.00,0.00,0.00,500.00,'2021-12-14 08:13:59','',''),(2279000,'1','140','773',331,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-14 08:13:59','',''),(2279015,'1','140','773',331,'Retail Sale Id 1333201',3600.00,0.00,0.00,0.00,360.00,'2021-12-14 08:14:52','',''),(2279016,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 08:14:52','',''),(2279319,'1','140','773',331,'Retail Sale Id 1333382',600.00,0.00,0.00,0.00,60.00,'2021-12-14 08:33:08','',''),(2279320,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-14 08:33:08','',''),(2279355,'1','140','773',331,'Retail Sale Id 1333400',12650.00,0.00,0.00,0.00,230.00,'2021-12-14 08:34:36','',''),(2279356,'1','140','773',331,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-14 08:34:36','',''),(2279381,'1','140','773',331,'Retail Sale Id 1333413',3000.00,0.00,0.00,0.00,300.00,'2021-12-14 08:36:05','',''),(2279382,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 08:36:05','',''),(2279534,'1','140','773',331,'Retail Sale Id 1333494',2400.00,0.00,0.00,0.00,240.00,'2021-12-14 08:43:33','',''),(2279535,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-14 08:43:33','',''),(2279552,'1','140','773',331,'Retail Sale Id 1333512',1800.00,0.00,0.00,0.00,180.00,'2021-12-14 08:44:37','',''),(2279553,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 08:44:37','',''),(2279810,'1','140','773',331,'Retail Sale Id 1333615',2400.00,0.00,0.00,0.00,240.00,'2021-12-14 08:57:19','',''),(2279811,'1','140','773',331,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-14 08:57:19','',''),(2279845,'1','140','773',331,'Retail Sale Id 1333622',960.00,0.00,0.00,0.00,96.00,'2021-12-14 08:58:59','',''),(2279846,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-14 08:58:59','',''),(2279865,'1','140','773',331,'Retail Sale Id 1333637',3000.00,0.00,0.00,0.00,300.00,'2021-12-14 08:59:44','',''),(2279866,'1','140','773',331,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 08:59:44','',''),(2280321,'1','140','773',331,'Retail Sale Id 1333831',33000.00,0.00,0.00,0.00,600.00,'2021-12-14 09:20:39','',''),(2280322,'1','140','773',331,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-14 09:20:39','',''),(2280341,'1','140','773',331,'Retail Sale Id 1333840',7500.00,0.00,0.00,0.00,750.00,'2021-12-14 09:21:29','',''),(2280342,'1','140','773',331,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 09:21:29','',''),(2280421,'1','140','773',331,'Retail Sale Id 1333863',3600.00,0.00,0.00,0.00,360.00,'2021-12-14 09:23:53','',''),(2280422,'1','140','773',331,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 09:23:53','',''),(2280446,'1','140','773',331,'Retail Sale Id 1333876',151250.00,0.00,0.00,0.00,2750.00,'2021-12-14 09:25:38','',''),(2280447,'1','140','773',331,'Retail sales',0.00,0.00,0.00,275.00,0.00,'2021-12-14 09:25:38','',''),(2280518,'1','140','773',331,'Retail Sale Id 1333915',1200.00,0.00,0.00,0.00,120.00,'2021-12-14 09:29:42','',''),(2280519,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-14 09:29:42','',''),(2280590,'1','140','773',331,'Retail Sale Id 1333955',1200.00,0.00,0.00,0.00,120.00,'2021-12-14 09:33:13','',''),(2280591,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-14 09:33:14','',''),(2280830,'1','140','773',331,'Retail Sale Id 1334069',1200.00,0.00,0.00,0.00,120.00,'2021-12-14 09:47:14','',''),(2280831,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-14 09:47:14','',''),(2280991,'1','140','773',331,'Retail Sale Id 1334162',1800.00,0.00,0.00,0.00,180.00,'2021-12-14 09:58:12','',''),(2280992,'1','140','773',331,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 09:58:12','',''),(2281007,'1','140','773',331,'Retail Sale Id 1334169',600.00,0.00,0.00,0.00,60.00,'2021-12-14 09:59:18','',''),(2281008,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-14 09:59:18','',''),(2281029,'1','140','773',331,'Retail Sale Id 1334181',1200.00,0.00,0.00,0.00,120.00,'2021-12-14 10:00:30','',''),(2281030,'1','140','773',331,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-14 10:00:30','',''),(2281053,'1','140','773',331,'Retail Sale Id 1334189',13200.00,0.00,0.00,0.00,240.00,'2021-12-14 10:01:23','',''),(2281054,'1','140','773',331,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-14 10:01:23','',''),(2281063,'1','140','773',331,'Retail Sale Id 1334196',600.00,0.00,0.00,0.00,60.00,'2021-12-14 10:02:05','',''),(2281064,'1','140','773',331,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-14 10:02:05','',''),(2282441,'1','140','773',331,'Retail Sale Id 1335318',7500.00,0.00,0.00,12.50,750.00,'2021-12-14 12:15:11','',''),(2282443,'1','140','773',331,'Retail Sale Id 1335320',7500.00,0.00,0.00,12.50,750.00,'2021-12-14 12:15:54','',''),(2282449,'1','140','773',331,'Retail Sale Id 1335327',275000.00,0.00,0.00,500.00,5000.00,'2021-12-14 12:18:27','',''),(2282452,'1','140','773',331,'Retail Sale Id 1335330',124488.00,0.00,0.00,228.00,1368.00,'2021-12-14 12:19:57','',''),(2285391,'1','140','773',331,'Retail Sale Id 1337612',2677584.00,0.00,0.00,4904.00,29424.00,'2021-12-14 19:47:13','',''),(2286435,'1','140','773',331,'Retail Sale Id 1338098',33000.00,0.00,0.00,60.00,600.00,'2021-12-15 07:13:42','',''),(2286467,'1','140','773',331,'Retail Sale Id 1338134',2400.00,0.00,0.00,4.00,240.00,'2021-12-15 07:18:08','',''),(2286567,'1','140','773',331,'Retail Sale Id 1338220',3000.00,0.00,0.00,5.00,300.00,'2021-12-15 07:29:41','',''),(2286581,'1','140','773',331,'Retail Sale Id 1338233',13200.00,0.00,0.00,24.00,240.00,'2021-12-15 07:31:24','',''),(2286600,'1','140','773',331,'Retail Sale Id 1338247',1200.00,0.00,0.00,2.00,120.00,'2021-12-15 07:33:03','',''),(2286717,'1','140','773',331,'Retail Sale Id 1338361',7500.00,0.00,0.00,12.50,750.00,'2021-12-15 07:45:25','',''),(2286749,'1','140','773',331,'Retail Sale Id 1338379',33000.00,0.00,0.00,60.00,600.00,'2021-12-15 07:48:22','',''),(2286786,'1','140','773',331,'Retail Sale Id 1338409',3600.00,0.00,0.00,6.00,360.00,'2021-12-15 07:51:06','',''),(2286853,'1','140','773',331,'Retail Sale Id 1338445',2400.00,0.00,0.00,4.00,240.00,'2021-12-15 07:57:24','',''),(2286891,'1','140','773',331,'Retail Sale Id 1338477',1200.00,0.00,0.00,2.00,120.00,'2021-12-15 08:00:39','',''),(2286944,'1','140','773',331,'Retail Sale Id 1338516',31900.00,0.00,0.00,58.00,580.00,'2021-12-15 08:04:59','',''),(2287023,'1','140','773',331,'Retail Sale Id 1338552',13200.00,0.00,0.00,24.00,240.00,'2021-12-15 08:10:03','',''),(2287054,'1','140','773',331,'Retail Sale Id 1338579',2400.00,0.00,0.00,4.00,240.00,'2021-12-15 08:13:03','',''),(2287068,'1','140','773',331,'Retail Sale Id 1338591',30250.00,0.00,0.00,55.00,550.00,'2021-12-15 08:14:13','',''),(2287095,'1','140','773',331,'Retail Sale Id 1338620',30250.00,0.00,0.00,55.00,550.00,'2021-12-15 08:17:37','',''),(2287146,'1','140','773',331,'Retail Sale Id 1338648',600.00,0.00,0.00,1.00,60.00,'2021-12-15 08:20:28','',''),(2287169,'1','140','773',331,'Retail Sale Id 1338675',1200.00,0.00,0.00,2.00,120.00,'2021-12-15 08:23:57','',''),(2287181,'1','140','773',331,'Retail Sale Id 1338687',1200.00,0.00,0.00,2.00,120.00,'2021-12-15 08:25:47','',''),(2287188,'1','140','773',331,'Retail Sale Id 1338701',12100.00,0.00,0.00,22.00,220.00,'2021-12-15 08:26:56','',''),(2287208,'1','140','773',331,'Retail Sale Id 1338725',4998.00,0.00,0.00,8.33,499.80,'2021-12-15 08:28:57','',''),(2287304,'1','140','773',331,'Retail Sale Id 1338791',3000.00,0.00,0.00,5.00,300.00,'2021-12-15 08:38:24','',''),(2287318,'1','140','773',331,'Retail Sale Id 1338806',3600.00,0.00,0.00,6.00,360.00,'2021-12-15 08:40:10','',''),(2287349,'1','140','773',331,'Retail Sale Id 1338830',7500.00,0.00,0.00,12.50,750.00,'2021-12-15 08:43:08','',''),(2287534,'1','140','773',331,'Retail Sale Id 1338992',1800.00,0.00,0.00,3.00,180.00,'2021-12-15 09:06:30','',''),(2287600,'1','140','773',331,'Retail Sale Id 1339024',4200.00,0.00,0.00,7.00,420.00,'2021-12-15 09:10:35','',''),(2287767,'1','140','773',331,'Retail Sale Id 1339181',5400.00,0.00,0.00,9.00,540.00,'2021-12-15 09:30:03','',''),(2287809,'1','140','773',331,'Retail Sale Id 1339216',2400.00,0.00,0.00,4.00,240.00,'2021-12-15 09:34:49','',''),(2288062,'1','140','773',331,'Retail Sale Id 1339427',1800.00,0.00,0.00,3.00,180.00,'2021-12-15 10:05:24','',''),(2288070,'1','140','773',331,'Retail Sale Id 1339434',7200.00,0.00,0.00,12.00,720.00,'2021-12-15 10:06:23','',''),(2288101,'1','140','773',331,'Retail Sale Id 1339454',1200.00,0.00,0.00,2.00,120.00,'2021-12-15 10:08:38','',''),(2288264,'1','140','773',331,'Retail Sale Id 1339601',2400.00,0.00,0.00,4.00,240.00,'2021-12-15 10:34:16','',''),(2288409,'1','140','773',331,'Retail Sale Id 1339715',7500.00,0.00,0.00,12.50,750.00,'2021-12-15 10:51:30','',''),(2288447,'1','140','773',331,'Retail Sale Id 1339749',1800.00,0.00,0.00,3.00,180.00,'2021-12-15 10:55:32','',''),(2288506,'1','140','773',331,'Retail Sale Id 1339801',1200.00,0.00,0.00,2.00,120.00,'2021-12-15 11:02:29','',''),(2288528,'1','140','773',331,'Retail Sale Id 1339823',3000.00,0.00,0.00,5.00,300.00,'2021-12-15 11:04:54','',''),(2288590,'1','140','773',331,'Retail Sale Id 1339884',3000.00,0.00,0.00,5.00,300.00,'2021-12-15 11:12:58','',''),(2288715,'1','140','773',331,'Retail Sale Id 1339980',1800.00,0.00,0.00,3.00,180.00,'2021-12-15 11:24:19','',''),(2288742,'1','140','773',331,'Retail Sale Id 1339998',16500.00,0.00,0.00,30.00,300.00,'2021-12-15 11:27:25','',''),(2288787,'1','140','773',331,'Retail Sale Id 1340038',2400.00,0.00,0.00,4.00,240.00,'2021-12-15 11:32:51','',''),(2288867,'1','140','773',331,'Retail Sale Id 1340123',3000.00,0.00,0.00,5.00,300.00,'2021-12-15 11:44:49','',''),(2288994,'1','140','773',331,'Retail Sale Id 1340255',100650.00,0.00,0.00,183.00,1830.00,'2021-12-15 12:00:38','',''),(2289058,'1','140','773',331,'Retail Sale Id 1340317',1200.00,0.00,0.00,2.00,120.00,'2021-12-15 12:10:42','',''),(2289248,'1','140','773',331,'Retail Sale Id 1340509',1200.00,0.00,0.00,2.00,120.00,'2021-12-15 12:38:16','',''),(2289255,'1','140','773',331,'Retail Sale Id 1340515',3000.00,0.00,0.00,5.00,300.00,'2021-12-15 12:39:09','',''),(2289277,'1','140','773',331,'Retail Sale Id 1340534',1998.00,0.00,0.00,3.33,199.80,'2021-12-15 12:41:27','',''),(2289282,'1','140','773',331,'Retail Sale Id 1340539',1500.00,0.00,0.00,2.50,150.00,'2021-12-15 12:42:23','',''),(2289409,'1','140','773',331,'Retail Sale Id 1340655',1002.00,0.00,0.00,1.67,100.20,'2021-12-15 13:03:30','',''),(2289531,'1','140','773',331,'Retail Sale Id 1340717',1200.00,0.00,0.00,2.00,120.00,'2021-12-15 13:15:41','',''),(2289642,'1','140','773',331,'Retail Sale Id 1340820',1200.00,0.00,0.00,2.00,120.00,'2021-12-15 13:28:33','',''),(2289656,'1','140','773',331,'Retail Sale Id 1340831',1800.00,0.00,0.00,3.00,180.00,'2021-12-15 13:30:07','',''),(2289679,'1','140','773',331,'Retail Sale Id 1340852',1800.00,0.00,0.00,3.00,180.00,'2021-12-15 13:33:50','',''),(2289859,'1','140','773',331,'Retail Sale Id 1340981',1800.00,0.00,0.00,3.00,180.00,'2021-12-15 13:52:08','',''),(2289897,'1','140','773',331,'Retail Sale Id 1341015',7800.00,0.00,0.00,13.00,780.00,'2021-12-15 13:56:16','',''),(2289901,'1','140','773',331,'Retail Sale Id 1341021',600.00,0.00,0.00,1.00,60.00,'2021-12-15 13:57:01','',''),(2289932,'1','140',NULL,331,'Purchased from AA RANO NIGERIA LIMITED',0.00,13200000.00,25000.00,0.00,0.00,'2021-12-15 13:59:26','',''),(2289945,'1','140',NULL,331,'Reception corrector for bridging 127495',0.00,0.00,0.00,24800.00,0.00,'2021-12-15 14:00:47','',''),(2289946,'1','140','773',331,'Received from bridging 127495',0.00,0.00,24800.00,0.00,0.00,'2021-12-15 14:00:47','',''),(2289947,'1','140','773',331,'Retail Sale Id 1341057',600.00,0.00,0.00,1.00,72.00,'2021-12-15 14:00:54','',''),(2290098,'1','140','773',331,'Retail Sale Id 1341111',3600.00,0.00,0.00,6.00,432.00,'2021-12-15 14:09:01','',''),(2290174,'1','140','773',331,'Retail Sale Id 1341147',12650.00,0.00,0.00,23.00,506.00,'2021-12-15 14:13:18','',''),(2290193,'1','140','773',331,'Retail Sale Id 1341171',67650.00,0.00,0.00,123.00,2706.00,'2021-12-15 14:15:51','',''),(2290276,'1','140','773',331,'Retail Sale Id 1341237',3300.00,0.00,0.00,6.00,132.00,'2021-12-15 14:24:04','',''),(2290292,'1','140','773',331,'Retail Sale Id 1341253',600.00,0.00,0.00,1.00,72.00,'2021-12-15 14:25:39','',''),(2290362,'1','140','773',331,'Retail Sale Id 1341319',3000.00,0.00,0.00,5.00,360.00,'2021-12-15 14:34:19','',''),(2290403,'1','140','773',331,'Retail Sale Id 1341354',1200.00,0.00,0.00,2.00,144.00,'2021-12-15 14:39:17','',''),(2290426,'1','140','773',331,'Retail Sale Id 1341374',1200.00,0.00,0.00,2.00,144.00,'2021-12-15 14:42:05','',''),(2290438,'1','140','773',331,'Retail Sale Id 1341386',1200.00,0.00,0.00,2.00,144.00,'2021-12-15 14:43:29','',''),(2290546,'1','140','773',331,'Retail Sale Id 1341459',1200.00,0.00,0.00,2.00,144.00,'2021-12-15 14:52:16','',''),(2290560,'1','140','773',331,'Retail Sale Id 1341473',1200.00,0.00,0.00,2.00,144.00,'2021-12-15 14:54:08','',''),(2290638,'1','140','773',331,'Retail Sale Id 1341528',33000.00,0.00,0.00,60.00,1320.00,'2021-12-15 14:59:55','',''),(2290676,'1','140','773',331,'Retail Sale Id 1341555',60500.00,0.00,0.00,110.00,2420.00,'2021-12-15 15:02:59','',''),(2290694,'1','140','773',331,'Retail Sale Id 1341571',600.00,0.00,0.00,1.00,72.00,'2021-12-15 15:04:26','',''),(2290751,'1','140','773',331,'Retail Sale Id 1341615',37950.00,0.00,0.00,69.00,1518.00,'2021-12-15 15:08:54','',''),(2290783,'1','140','773',331,'Retail Sale Id 1341646',2400.00,0.00,0.00,4.00,288.00,'2021-12-15 15:13:12','',''),(2290800,'1','140','773',331,'Retail Sale Id 1341662',1800.00,0.00,0.00,3.00,216.00,'2021-12-15 15:15:26','',''),(2290841,'1','140','773',331,'Retail Sale Id 1341678',1200.00,0.00,0.00,2.00,144.00,'2021-12-15 15:16:46','',''),(2290850,'1','140','773',331,'Retail Sale Id 1341687',687960.00,0.00,0.00,1260.00,22680.00,'2021-12-15 15:18:23','',''),(2290869,'1','140','773',331,'Retail Sale Id 1341697',7500.00,0.00,0.00,12.50,900.00,'2021-12-15 15:19:32','',''),(2290883,'1','140','773',331,'Retail Sale Id 1341708',1200.00,0.00,0.00,2.00,144.00,'2021-12-15 15:20:23','',''),(2290899,'1','140','773',331,'Retail Sale Id 1341725',1002.00,0.00,0.00,1.67,120.24,'2021-12-15 15:21:54','',''),(2290930,'1','140','773',331,'Retail Sale Id 1341744',1800.00,0.00,0.00,3.00,216.00,'2021-12-15 15:23:30','',''),(2291076,'1','140','773',331,'Retail Sale Id 1341815',9000.00,0.00,0.00,15.00,1080.00,'2021-12-15 15:32:02','',''),(2291174,'1','140','773',331,'Retail Sale Id 1341905',573300.00,0.00,0.00,1050.00,18900.00,'2021-12-15 15:40:50','',''),(2291191,'1','140','773',331,'Retail Sale Id 1341922',600.00,0.00,0.00,1.00,72.00,'2021-12-15 15:42:57','',''),(2291214,'1','140','773',331,'Retail Sale Id 1341944',1025388.00,0.00,0.00,1878.00,33804.00,'2021-12-15 15:45:37','',''),(2291240,'1','140','773',331,'Retail Sale Id 1341969',12600.00,0.00,0.00,21.00,1512.00,'2021-12-15 15:48:14','',''),(2291261,'1','140','773',331,'Retail Sale Id 1341991',3600.00,0.00,0.00,6.00,432.00,'2021-12-15 15:50:19','',''),(2291360,'1','140','773',331,'Retail Sale Id 1342067',1800.00,0.00,0.00,3.00,216.00,'2021-12-15 15:57:09','',''),(2291443,'1','140','773',331,'Retail Sale Id 1342136',1800.00,0.00,0.00,3.00,216.00,'2021-12-15 16:04:48','',''),(2291505,'1','140','773',331,'Retail Sale Id 1342205',1200.00,0.00,0.00,2.00,144.00,'2021-12-15 16:11:33','',''),(2291531,'1','140','773',331,'Retail Sale Id 1342226',6000.00,0.00,0.00,10.00,720.00,'2021-12-15 16:13:50','',''),(2291554,'1','140','773',331,'Retail Sale Id 1342240',33000.00,0.00,0.00,60.00,1320.00,'2021-12-15 16:15:24','',''),(2291572,'1','140','773',331,'Retail Sale Id 1342253',3000.00,0.00,0.00,5.00,360.00,'2021-12-15 16:17:14','',''),(2291605,'1','140','773',331,'Retail Sale Id 1342288',3600.00,0.00,0.00,6.00,432.00,'2021-12-15 16:19:37','',''),(2291627,'1','140','773',331,'Retail Sale Id 1342308',12650.00,0.00,0.00,23.00,506.00,'2021-12-15 16:21:37','',''),(2291653,'1','140','773',331,'Retail Sale Id 1342337',3000.00,0.00,0.00,5.00,360.00,'2021-12-15 16:24:14','',''),(2291710,'1','140','773',331,'Retail Sale Id 1342392',2502.00,0.00,0.00,4.17,300.24,'2021-12-15 16:29:57','',''),(2291801,'1','140','773',331,'Retail Sale Id 1342475',1200.00,0.00,0.00,2.00,144.00,'2021-12-15 16:38:06','',''),(2292057,'1','140','773',331,'Retail Sale Id 1342701',6000.00,0.00,0.00,10.00,720.00,'2021-12-15 17:01:18','',''),(2294146,'1','140','773',331,'Retail Sale Id 1344030',7500.00,0.00,0.00,12.50,900.00,'2021-12-16 07:48:00','',''),(2294173,'1','140','773',331,'Retail Sale Id 1344037',7500.00,0.00,0.00,12.50,900.00,'2021-12-16 07:48:59','',''),(2294298,'1','140','773',331,'Retail Sale Id 1344160',7500.00,0.00,0.00,12.50,900.00,'2021-12-16 08:03:48','',''),(2294432,'1','140','773',331,'Retail Sale Id 1344245',1200.00,0.00,0.00,2.00,144.00,'2021-12-16 08:11:48','',''),(2294449,'1','140','773',331,'Retail Sale Id 1344263',1200.00,0.00,0.00,2.00,144.00,'2021-12-16 08:13:03','',''),(2294613,'1','140','773',331,'Retail Sale Id 1344389',16500.00,0.00,0.00,30.00,660.00,'2021-12-16 08:24:13','',''),(2294890,'1','140','773',331,'Retail Sale Id 1344573',1998.00,0.00,0.00,3.33,239.76,'2021-12-16 08:43:53','',''),(2294906,'1','140','773',331,'Retail Sale Id 1344588',1800.00,0.00,0.00,3.00,216.00,'2021-12-16 08:45:10','',''),(2294929,'1','140','773',331,'Retail Sale Id 1344602',6000.00,0.00,0.00,10.00,720.00,'2021-12-16 08:47:06','',''),(2295116,'1','140','773',331,'Retail Sale Id 1344761',3000.00,0.00,0.00,5.00,360.00,'2021-12-16 09:04:36','',''),(2295146,'1','140','773',331,'Retail Sale Id 1344786',12650.00,0.00,0.00,23.00,506.00,'2021-12-16 09:06:54','',''),(2295243,'1','140','773',331,'Retail Sale Id 1344874',1200.00,0.00,0.00,2.00,144.00,'2021-12-16 09:15:30','',''),(2295326,'1','140','773',331,'Retail Sale Id 1344953',1002.00,0.00,0.00,1.67,120.24,'2021-12-16 09:23:43','',''),(2295571,'1','140','773',331,'Retail Sale Id 1345159',7500.00,0.00,0.00,12.50,900.00,'2021-12-16 09:46:36','',''),(2295610,'1','140','773',331,'Retail Sale Id 1345191',2100.00,0.00,0.00,3.50,252.00,'2021-12-16 09:50:40','',''),(2295707,'1','140','773',331,'Retail Sale Id 1345249',7500.00,0.00,0.00,12.50,900.00,'2021-12-16 09:58:07','',''),(2295775,'1','140','773',331,'Retail Sale Id 1345285',33000.00,0.00,0.00,60.00,1320.00,'2021-12-16 10:02:11','',''),(2295988,'1','140','773',331,'Retail Sale Id 1345465',30250.00,0.00,0.00,55.00,1210.00,'2021-12-16 10:22:50','',''),(2295997,'1','140','773',331,'Retail Sale Id 1345474',1200.00,0.00,0.00,2.00,144.00,'2021-12-16 10:23:48','',''),(2296110,'1','140','773',331,'Retail Sale Id 1345588',1200.00,0.00,0.00,2.00,144.00,'2021-12-16 10:38:02','',''),(2296120,'1','140','773',331,'Retail Sale Id 1345595',3600.00,0.00,0.00,6.00,432.00,'2021-12-16 10:39:06','',''),(2296187,'1','140','773',331,'Retail Sale Id 1345664',33000.00,0.00,0.00,60.00,1320.00,'2021-12-16 10:48:11','',''),(2296211,'1','140','773',331,'Retail Sale Id 1345688',1800.00,0.00,0.00,3.00,216.00,'2021-12-16 10:50:02','',''),(2296223,'1','140','773',331,'Retail Sale Id 1345699',4200.00,0.00,0.00,7.00,504.00,'2021-12-16 10:51:37','',''),(2296607,'1','140','773',331,'Retail Sale Id 1346050',1800.00,0.00,0.00,3.00,216.00,'2021-12-16 11:35:06','',''),(2296618,'1','140','773',331,'Retail Sale Id 1346060',2400.00,0.00,0.00,4.00,288.00,'2021-12-16 11:36:12','',''),(2296657,'1','140','773',331,'Retail Sale Id 1346100',82500.00,0.00,0.00,150.00,3300.00,'2021-12-16 11:40:58','',''),(2296682,'1','140','773',331,'Retail Sale Id 1346121',19250.00,0.00,0.00,35.00,770.00,'2021-12-16 11:43:40','',''),(2296710,'1','140','773',331,'Retail Sale Id 1346153',1800.00,0.00,0.00,3.00,216.00,'2021-12-16 11:47:17','',''),(2296719,'1','140','773',331,'Retail Sale Id 1346161',67100.00,0.00,0.00,122.00,2684.00,'2021-12-16 11:48:16','',''),(2296905,'1','140','773',331,'Retail Sale Id 1346317',33000.00,0.00,0.00,60.00,1320.00,'2021-12-16 12:09:46','',''),(2296957,'1','140','773',331,'Retail Sale Id 1346348',99000.00,0.00,0.00,180.00,3960.00,'2021-12-16 12:13:43','',''),(2296998,'1','140','773',331,'Retail Sale Id 1346388',1800.00,0.00,0.00,3.00,216.00,'2021-12-16 12:19:33','',''),(2297004,'1','140','773',331,'Retail Sale Id 1346393',900.00,0.00,0.00,1.50,108.00,'2021-12-16 12:20:33','',''),(2297054,'1','140','773',331,'Retail Sale Id 1346443',702.00,0.00,0.00,1.17,84.24,'2021-12-16 12:27:00','',''),(2297112,'1','140','773',331,'Retail Sale Id 1346495',600.00,0.00,0.00,1.00,72.00,'2021-12-16 12:34:37','',''),(2297195,'1','140','773',331,'Retail Sale Id 1346565',1302.00,0.00,0.00,2.17,156.24,'2021-12-16 12:43:24','',''),(2297730,'1','140','773',331,'Retail Sale Id 1347018',12650.00,0.00,0.00,23.00,506.00,'2021-12-16 13:39:15','',''),(2297736,'1','140','773',331,'Retail Sale Id 1347027',1998.00,0.00,0.00,3.33,239.76,'2021-12-16 13:40:05','',''),(2297752,'1','140','773',331,'Retail Sale Id 1347045',9900.00,0.00,0.00,18.00,396.00,'2021-12-16 13:41:32','',''),(2297774,'1','140','773',331,'Retail Sale Id 1347059',1800.00,0.00,0.00,3.00,216.00,'2021-12-16 13:43:35','',''),(2297950,'1','140','773',331,'Retail Sale Id 1347190',2400.00,0.00,0.00,4.00,288.00,'2021-12-16 13:58:33','',''),(2297972,'1','140','773',331,'Retail Sale Id 1347203',1800.00,0.00,0.00,3.00,216.00,'2021-12-16 14:00:41','',''),(2298192,'1','140','773',331,'Retail Sale Id 1347374',13750.00,0.00,0.00,25.00,550.00,'2021-12-16 14:20:49','',''),(2298254,'1','140','773',331,'Retail Sale Id 1347430',6000.00,0.00,0.00,10.00,720.00,'2021-12-16 14:27:05','',''),(2298287,'1','140','773',331,'Retail Sale Id 1347471',655200.00,0.00,0.00,1200.00,21600.00,'2021-12-16 14:30:57','',''),(2298404,'1','140','773',331,'Retail Sale Id 1347570',1200.00,0.00,0.00,2.00,144.00,'2021-12-16 14:43:39','',''),(2298536,'1','140','773',331,'Retail Sale Id 1347614',6875.00,0.00,0.00,12.50,275.00,'2021-12-16 14:48:11','',''),(2298608,'1','140','773',331,'Retail Sale Id 1347666',15000.00,0.00,0.00,25.00,1800.00,'2021-12-16 14:54:00','',''),(2298625,'1','140','773',331,'Retail Sale Id 1347678',3600.00,0.00,0.00,6.00,432.00,'2021-12-16 14:55:59','',''),(2298633,'1','140','773',331,'Retail Sale Id 1347690',6000.00,0.00,0.00,10.00,720.00,'2021-12-16 14:57:45','',''),(2298691,'1','140','773',331,'Retail Sale Id 1347746',1200.00,0.00,0.00,2.00,144.00,'2021-12-16 15:06:25','',''),(2298700,'1','140','773',331,'Retail Sale Id 1347756',1002.00,0.00,0.00,1.67,120.24,'2021-12-16 15:07:43','',''),(2298979,'1','140','773',331,'Retail Sale Id 1347936',7500.00,0.00,0.00,12.50,900.00,'2021-12-16 15:27:42','',''),(2298996,'1','140','773',331,'Retail Sale Id 1347953',27500.00,0.00,0.00,50.00,1100.00,'2021-12-16 15:29:29','',''),(2299024,'1','140','773',331,'Retail Sale Id 1347964',1200.00,0.00,0.00,2.00,144.00,'2021-12-16 15:30:20','',''),(2299084,'1','140','773',331,'Retail Sale Id 1348023',13650.00,0.00,0.00,25.00,450.00,'2021-12-16 15:35:40','',''),(2299092,'1','140','773',331,'Retail Sale Id 1348030',8220.00,0.00,0.00,13.70,986.40,'2021-12-16 15:36:32','',''),(2299104,'1','140','773',331,'Retail Sale Id 1348044',2502.00,0.00,0.00,4.17,300.24,'2021-12-16 15:37:23','',''),(2299274,'1','140','773',331,'Retail Sale Id 1348183',7500.00,0.00,0.00,12.50,900.00,'2021-12-16 15:50:30','',''),(2299293,'1','140','773',331,'Retail Sale Id 1348201',3000.00,0.00,0.00,5.00,360.00,'2021-12-16 15:51:53','',''),(2299435,'1','140','773',331,'Retail Sale Id 1348289',1800.00,0.00,0.00,3.00,216.00,'2021-12-16 16:00:12','',''),(2299455,'1','140','773',331,'Retail Sale Id 1348309',7500.00,0.00,0.00,12.50,900.00,'2021-12-16 16:01:36','',''),(2299482,'1','140','773',331,'Retail Sale Id 1348335',1200.00,0.00,0.00,2.00,144.00,'2021-12-16 16:03:46','',''),(2299511,'1','140','773',331,'Retail Sale Id 1348365',1200.00,0.00,0.00,2.00,144.00,'2021-12-16 16:06:21','',''),(2299528,'1','140','773',331,'Retail Sale Id 1348378',33000.00,0.00,0.00,60.00,1320.00,'2021-12-16 16:07:39','',''),(2299542,'1','140','773',331,'Retail Sale Id 1348387',33000.00,0.00,0.00,60.00,1320.00,'2021-12-16 16:08:29','',''),(2299570,'1','140','773',331,'Retail Sale Id 1348401',1800.00,0.00,0.00,3.00,216.00,'2021-12-16 16:09:42','',''),(2299644,'1','140','773',331,'Retail Sale Id 1348428',11000.00,0.00,0.00,20.00,440.00,'2021-12-16 16:12:09','',''),(2299689,'1','140','773',331,'Retail Sale Id 1348453',600.00,0.00,0.00,1.00,72.00,'2021-12-16 16:14:23','',''),(2299748,'1','140','773',331,'Retail Sale Id 1348511',7500.00,0.00,0.00,12.50,900.00,'2021-12-16 16:20:10','',''),(2299772,'1','140','773',331,'Retail Sale Id 1348533',27500.00,0.00,0.00,50.00,1100.00,'2021-12-16 16:21:46','',''),(2299807,'1','140','773',331,'Retail Sale Id 1348572',1200.00,0.00,0.00,2.00,144.00,'2021-12-16 16:25:31','',''),(2299820,'1','140','773',331,'Retail Sale Id 1348585',43450.00,0.00,0.00,79.00,1738.00,'2021-12-16 16:26:40','',''),(2299847,'1','140','773',331,'Retail Sale Id 1348601',3000.00,0.00,0.00,5.00,360.00,'2021-12-16 16:28:41','',''),(2299866,'1','140','773',331,'Retail Sale Id 1348620',1200.00,0.00,0.00,2.00,144.00,'2021-12-16 16:29:59','',''),(2299879,'1','140','773',331,'Retail Sale Id 1348638',1200.00,0.00,0.00,2.00,144.00,'2021-12-16 16:31:18','',''),(2299905,'1','140','773',331,'Retail Sale Id 1348658',1800.00,0.00,0.00,3.00,216.00,'2021-12-16 16:33:17','',''),(2299997,'1','140','773',331,'Retail Sale Id 1348748',1800.00,0.00,0.00,3.00,216.00,'2021-12-16 16:43:42','',''),(2300056,'1','140','773',331,'Retail Sale Id 1348811',3000.00,0.00,0.00,5.00,360.00,'2021-12-16 16:48:48','',''),(2300077,'1','140','773',331,'Retail Sale Id 1348832',5400.00,0.00,0.00,9.00,648.00,'2021-12-16 16:51:20','',''),(2300115,'1','140','773',331,'Return of Retail Sale Id 1348832',0.00,5400.00,9.00,0.00,-648.00,'2021-12-16 16:55:38','',''),(2301693,'1','140','773',331,'Retail Sale Id 1349715',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 06:58:56','',''),(2301736,'1','140','773',331,'Retail Sale Id 1349753',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 07:03:08','',''),(2301749,'1','140','773',331,'Retail Sale Id 1349760',1200.00,0.00,0.00,2.00,144.00,'2021-12-17 07:04:17','',''),(2301763,'1','140','773',331,'Retail Sale Id 1349780',13200.00,0.00,0.00,24.00,528.00,'2021-12-17 07:06:02','',''),(2301778,'1','140','773',331,'Retail Sale Id 1349796',7500.00,0.00,0.00,12.50,900.00,'2021-12-17 07:08:25','',''),(2301794,'1','140','773',331,'Retail Sale Id 1349815',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 07:10:56','',''),(2301833,'1','140','773',331,'Retail Sale Id 1349833',1200.00,0.00,0.00,2.00,144.00,'2021-12-17 07:13:21','',''),(2301861,'1','140','773',331,'Retail Sale Id 1349848',1200.00,0.00,0.00,2.00,144.00,'2021-12-17 07:14:38','',''),(2301972,'1','140','773',331,'Retail Sale Id 1349949',32450.00,0.00,0.00,59.00,1298.00,'2021-12-17 07:25:55','',''),(2302038,'1','140','773',331,'Retail Sale Id 1350011',11000.00,0.00,0.00,20.00,440.00,'2021-12-17 07:31:56','',''),(2302051,'1','140','773',331,'Retail Sale Id 1350023',30250.00,0.00,0.00,55.00,1210.00,'2021-12-17 07:33:27','',''),(2302200,'1','140','773',331,'Retail Sale Id 1350116',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 07:46:11','',''),(2302218,'1','140','773',331,'Retail Sale Id 1350136',12595.00,0.00,0.00,22.90,503.80,'2021-12-17 07:49:21','',''),(2302253,'1','140','773',331,'Retail Sale Id 1350167',33000.00,0.00,0.00,60.00,1320.00,'2021-12-17 07:52:48','',''),(2302263,'1','140','773',331,'Retail Sale Id 1350185',1200.00,0.00,0.00,2.00,144.00,'2021-12-17 07:53:51','',''),(2302276,'1','140','773',331,'Retail Sale Id 1350200',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 07:54:57','',''),(2302282,'1','140','773',331,'Retail Sale Id 1350206',1998.00,0.00,0.00,3.33,239.76,'2021-12-17 07:56:21','',''),(2302447,'1','140','773',331,'Retail Sale Id 1350343',2400.00,0.00,0.00,4.00,288.00,'2021-12-17 08:10:57','',''),(2302477,'1','140','773',331,'Retail Sale Id 1350368',3600.00,0.00,0.00,6.00,432.00,'2021-12-17 08:15:04','',''),(2302495,'1','140','773',331,'Retail Sale Id 1350392',1200.00,0.00,0.00,2.00,144.00,'2021-12-17 08:16:39','',''),(2302559,'1','140','773',331,'Retail Sale Id 1350457',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 08:21:48','',''),(2302716,'1','140','773',331,'Retail Sale Id 1350584',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 08:34:17','',''),(2302741,'1','140','773',331,'Retail Sale Id 1350610',7200.00,0.00,0.00,12.00,864.00,'2021-12-17 08:36:50','',''),(2302898,'1','140','773',331,'Retail Sale Id 1350713',3600.00,0.00,0.00,6.00,432.00,'2021-12-17 08:50:08','',''),(2302913,'1','140','773',331,'Retail Sale Id 1350724',3000.00,0.00,0.00,5.00,360.00,'2021-12-17 08:51:10','',''),(2302940,'1','140','773',331,'Retail Sale Id 1350736',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 08:52:24','',''),(2302948,'1','140','773',331,'Retail Sale Id 1350744',5500.00,0.00,0.00,10.00,220.00,'2021-12-17 08:53:12','',''),(2302981,'1','140','773',331,'Retail Sale Id 1350764',30250.00,0.00,0.00,55.00,1210.00,'2021-12-17 08:55:02','',''),(2303107,'1','140','773',331,'Retail Sale Id 1350862',2400.00,0.00,0.00,4.00,288.00,'2021-12-17 09:07:06','',''),(2303273,'1','140','773',331,'Retail Sale Id 1350954',3000.00,0.00,0.00,5.00,360.00,'2021-12-17 09:20:03','',''),(2303415,'1','140','773',331,'Retail Sale Id 1351063',55000.00,0.00,0.00,100.00,2200.00,'2021-12-17 09:32:33','',''),(2303469,'1','140','773',331,'Retail Sale Id 1351100',27500.00,0.00,0.00,50.00,1100.00,'2021-12-17 09:35:13','',''),(2303540,'1','140','773',331,'Retail Sale Id 1351150',1500.00,0.00,0.00,2.50,180.00,'2021-12-17 09:40:47','',''),(2303629,'1','140','773',331,'Retail Sale Id 1351225',1200.00,0.00,0.00,2.00,144.00,'2021-12-17 09:49:42','',''),(2304000,'1','140','773',331,'Retail Sale Id 1351592',1200.00,0.00,0.00,2.00,144.00,'2021-12-17 10:29:45','',''),(2304085,'1','140','773',331,'Retail Sale Id 1351666',1200.00,0.00,0.00,2.00,144.00,'2021-12-17 10:39:24','',''),(2304096,'1','140','773',331,'Retail Sale Id 1351674',600.00,0.00,0.00,1.00,72.00,'2021-12-17 10:40:29','',''),(2304105,'1','140','773',331,'Retail Sale Id 1351686',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 10:41:48','',''),(2304286,'1','140','773',331,'Retail Sale Id 1351863',8250.00,0.00,0.00,15.00,330.00,'2021-12-17 11:03:11','',''),(2304320,'1','140','773',331,'Retail Sale Id 1351892',600.00,0.00,0.00,1.00,72.00,'2021-12-17 11:05:54','',''),(2304361,'1','140','773',331,'Retail Sale Id 1351937',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 11:10:39','',''),(2304380,'1','140','773',331,'Retail Sale Id 1351954',3600.00,0.00,0.00,6.00,432.00,'2021-12-17 11:12:34','',''),(2304396,'1','140','773',331,'Retail Sale Id 1351970',600.00,0.00,0.00,1.00,72.00,'2021-12-17 11:14:11','',''),(2304446,'1','140','773',331,'Retail Sale Id 1352014',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 11:18:35','',''),(2304567,'1','140','773',331,'Retail Sale Id 1352108',7500.00,0.00,0.00,12.50,900.00,'2021-12-17 11:27:24','',''),(2304680,'1','140','773',331,'Retail Sale Id 1352220',3600.00,0.00,0.00,6.00,432.00,'2021-12-17 11:39:51','',''),(2304694,'1','140','773',331,'Retail Sale Id 1352235',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 11:41:55','',''),(2304718,'1','140','773',331,'Retail Sale Id 1352256',600.00,0.00,0.00,1.00,72.00,'2021-12-17 11:44:29','',''),(2305001,'1','140','773',331,'Retail Sale Id 1352525',600.00,0.00,0.00,1.00,72.00,'2021-12-17 12:21:43','',''),(2305012,'1','140','773',331,'Retail Sale Id 1352538',7500.00,0.00,0.00,12.50,900.00,'2021-12-17 12:23:52','',''),(2305056,'1','140','773',331,'Retail Sale Id 1352580',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 12:31:26','',''),(2305139,'1','140','773',331,'Retail Sale Id 1352635',681408.00,0.00,0.00,1248.00,22464.00,'2021-12-17 12:41:21','',''),(2305204,'1','140','773',331,'Retail Sale Id 1352708',16500.00,0.00,0.00,30.00,660.00,'2021-12-17 12:51:59','',''),(2305211,'1','140','773',331,'Retail Sale Id 1352715',2502.00,0.00,0.00,4.17,300.24,'2021-12-17 12:53:44','',''),(2305218,'1','140','773',331,'Retail Sale Id 1352734',11000.00,0.00,0.00,20.00,440.00,'2021-12-17 12:55:13','',''),(2305232,'1','140','773',331,'Retail Sale Id 1352746',13750.00,0.00,0.00,25.00,550.00,'2021-12-17 12:57:52','',''),(2305275,'1','140','773',331,'Retail Sale Id 1352780',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 13:02:49','',''),(2305282,'1','140','773',331,'Retail Sale Id 1352796',2400.00,0.00,0.00,4.00,288.00,'2021-12-17 13:04:27','',''),(2305413,'1','140','773',331,'Retail Sale Id 1352928',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 13:25:04','',''),(2305461,'1','140','773',331,'Retail Sale Id 1352978',22000.00,0.00,0.00,40.00,880.00,'2021-12-17 13:31:07','',''),(2305668,'1','140','773',331,'Retail Sale Id 1353138',3000.00,0.00,0.00,5.00,360.00,'2021-12-17 13:53:18','',''),(2305680,'1','140','773',331,'Retail Sale Id 1353150',7500.00,0.00,0.00,12.50,900.00,'2021-12-17 13:54:25','',''),(2305825,'1','140','773',331,'Retail Sale Id 1353235',30250.00,0.00,0.00,55.00,1210.00,'2021-12-17 14:05:16','',''),(2305903,'1','140','773',331,'Retail Sale Id 1353306',1200.00,0.00,0.00,2.00,144.00,'2021-12-17 14:13:09','',''),(2306056,'1','140','773',331,'Retail Sale Id 1353348',11000.00,0.00,0.00,20.00,440.00,'2021-12-17 14:32:52','',''),(2306060,'1','140','773',331,'Retail Sale Id 1353445',1200.00,0.00,0.00,2.00,144.00,'2021-12-17 14:33:21','',''),(2306076,'1','140','773',331,'Retail Sale Id 1353462',33000.00,0.00,0.00,60.00,1320.00,'2021-12-17 14:34:59','',''),(2306089,'1','140','773',331,'Retail Sale Id 1353475',7500.00,0.00,0.00,12.50,900.00,'2021-12-17 14:35:57','',''),(2306105,'1','140','773',331,'Retail Sale Id 1353485',23100.00,0.00,0.00,42.00,924.00,'2021-12-17 14:37:25','',''),(2306130,'1','140','773',331,'Retail Sale Id 1353505',1200.00,0.00,0.00,2.00,144.00,'2021-12-17 14:38:54','',''),(2306137,'1','140','773',331,'Retail Sale Id 1353517',1002.00,0.00,0.00,1.67,120.24,'2021-12-17 14:40:10','',''),(2306325,'1','140','773',331,'Retail Sale Id 1353639',1200.00,0.00,0.00,2.00,144.00,'2021-12-17 14:52:22','',''),(2306390,'1','140','773',331,'Retail Sale Id 1353662',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 14:55:46','',''),(2306397,'1','140','773',331,'Retail Sale Id 1353673',1200.00,0.00,0.00,2.00,144.00,'2021-12-17 14:56:35','',''),(2306411,'1','140','773',331,'Retail Sale Id 1353687',1200.00,0.00,0.00,2.00,144.00,'2021-12-17 14:58:22','',''),(2306421,'1','140','773',331,'Retail Sale Id 1353697',3000.00,0.00,0.00,5.00,360.00,'2021-12-17 15:00:02','',''),(2306428,'1','140','773',331,'Retail Sale Id 1353707',600.00,0.00,0.00,1.00,72.00,'2021-12-17 15:01:21','',''),(2306434,'1','140','773',331,'Retail Sale Id 1353715',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 15:02:13','',''),(2306498,'1','140','773',331,'Retail Sale Id 1353767',1200.00,0.00,0.00,2.00,144.00,'2021-12-17 15:08:29','',''),(2306559,'1','140','773',331,'Retail Sale Id 1353835',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 15:15:06','',''),(2306593,'1','140','773',331,'Retail Sale Id 1353860',60500.00,0.00,0.00,110.00,2420.00,'2021-12-17 15:18:06','',''),(2306613,'1','140','773',331,'Retail Sale Id 1353875',3600.00,0.00,0.00,6.00,432.00,'2021-12-17 15:19:23','',''),(2306671,'1','140','773',331,'Retail Sale Id 1353903',1200.00,0.00,0.00,2.00,144.00,'2021-12-17 15:22:10','',''),(2306679,'1','140','773',331,'Retail Sale Id 1353912',7500.00,0.00,0.00,12.50,900.00,'2021-12-17 15:23:30','',''),(2306707,'1','140','773',331,'Retail Sale Id 1353944',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 15:25:31','',''),(2306749,'1','140','773',331,'Retail Sale Id 1353972',600.00,0.00,0.00,1.00,72.00,'2021-12-17 15:28:22','',''),(2306776,'1','140','773',331,'Retail Sale Id 1353995',1200.00,0.00,0.00,2.00,144.00,'2021-12-17 15:30:42','',''),(2306837,'1','140','773',331,'Retail Sale Id 1354032',1500.00,0.00,0.00,2.50,180.00,'2021-12-17 15:34:09','',''),(2306880,'1','140','773',331,'Retail Sale Id 1354058',600.00,0.00,0.00,1.00,72.00,'2021-12-17 15:37:08','',''),(2306937,'1','140','773',331,'Retail Sale Id 1354106',3000.00,0.00,0.00,5.00,360.00,'2021-12-17 15:41:00','',''),(2306979,'1','140','773',331,'Retail Sale Id 1354129',33000.00,0.00,0.00,60.00,1320.00,'2021-12-17 15:43:15','',''),(2307002,'1','140','773',331,'Retail Sale Id 1354152',600.00,0.00,0.00,1.00,72.00,'2021-12-17 15:44:55','',''),(2307176,'1','140','773',331,'Retail Sale Id 1354328',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 15:59:23','',''),(2307199,'1','140','773',331,'Retail Sale Id 1354353',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 16:01:46','',''),(2307224,'1','140','773',331,'Retail Sale Id 1354370',13200.00,0.00,0.00,24.00,528.00,'2021-12-17 16:03:40','',''),(2307257,'1','140','773',331,'Retail Sale Id 1354409',600.00,0.00,0.00,1.00,72.00,'2021-12-17 16:06:21','',''),(2307390,'1','140','773',331,'Retail Sale Id 1354554',1200.00,0.00,0.00,2.00,144.00,'2021-12-17 16:18:36','',''),(2307400,'1','140','773',331,'Retail Sale Id 1354566',4002.00,0.00,0.00,6.67,480.24,'2021-12-17 16:19:39','',''),(2307427,'1','140','773',331,'Retail Sale Id 1354591',1800.00,0.00,0.00,3.00,216.00,'2021-12-17 16:21:43','',''),(2307550,'1','140','773',331,'Retail Sale Id 1354717',1200.00,0.00,0.00,2.00,144.00,'2021-12-17 16:33:26','',''),(2307556,'1','140','773',331,'Retail Sale Id 1354725',600.00,0.00,0.00,1.00,72.00,'2021-12-17 16:34:15','',''),(2307794,'1','140','773',331,'Retail Sale Id 1354928',7200.00,0.00,0.00,12.00,864.00,'2021-12-17 16:58:39','',''),(2310386,'1','140','773',331,'Retail Sale Id 1356529',7500.00,0.00,0.00,12.50,900.00,'2021-12-18 08:14:37','',''),(2310392,'1','140','773',331,'Retail Sale Id 1356536',7500.00,0.00,0.00,12.50,900.00,'2021-12-18 08:15:11','',''),(2310396,'1','140','773',331,'Retail Sale Id 1356540',7500.00,0.00,0.00,12.50,900.00,'2021-12-18 08:15:47','',''),(2310784,'1','140','773',331,'Retail Sale Id 1356876',7500.00,0.00,0.00,12.50,900.00,'2021-12-18 08:46:57','',''),(2311000,'1','140','773',331,'Retail Sale Id 1357062',7500.00,0.00,0.00,12.50,900.00,'2021-12-18 09:03:48','',''),(2311082,'1','140','773',331,'Retail Sale Id 1357136',7200.00,0.00,0.00,12.00,864.00,'2021-12-18 09:10:50','',''),(2311129,'1','140','773',331,'Retail Sale Id 1356541',7500.00,0.00,0.00,12.50,900.00,'2021-12-18 09:13:03','',''),(2311210,'1','140','773',331,'Retail Sale Id 1357217',600.00,0.00,0.00,1.00,72.00,'2021-12-18 09:19:41','',''),(2311300,'1','140','773',331,'Retail Sale Id 1357314',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 09:29:16','',''),(2311315,'1','140','773',331,'Retail Sale Id 1357327',1200.00,0.00,0.00,2.00,144.00,'2021-12-18 09:30:35','',''),(2311333,'1','140','773',331,'Retail Sale Id 1357347',1200.00,0.00,0.00,2.00,144.00,'2021-12-18 09:32:41','',''),(2311415,'1','140','773',331,'Retail Sale Id 1357427',1200.00,0.00,0.00,2.00,144.00,'2021-12-18 09:41:01','',''),(2311446,'1','140','773',331,'Retail Sale Id 1357459',702.00,0.00,0.00,1.17,84.24,'2021-12-18 09:43:55','',''),(2311485,'1','140','773',331,'Retail Sale Id 1357499',13200.00,0.00,0.00,24.00,528.00,'2021-12-18 09:47:09','',''),(2311566,'1','140','773',331,'Retail Sale Id 1357568',600.00,0.00,0.00,1.00,72.00,'2021-12-18 09:53:52','',''),(2311605,'1','140','773',331,'Retail Sale Id 1357587',600.00,0.00,0.00,1.00,72.00,'2021-12-18 09:55:19','',''),(2311628,'1','140','773',331,'Retail Sale Id 1357598',1200.00,0.00,0.00,2.00,144.00,'2021-12-18 09:57:05','',''),(2311657,'1','140','773',331,'Retail Sale Id 1357623',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 09:59:32','',''),(2311689,'1','140','773',331,'Retail Sale Id 1357643',66000.00,0.00,0.00,120.00,2640.00,'2021-12-18 10:03:37','',''),(2311720,'1','140','773',331,'Retail Sale Id 1357675',16500.00,0.00,0.00,30.00,660.00,'2021-12-18 10:07:05','',''),(2311757,'1','140','773',331,'Retail Sale Id 1357716',273000.00,0.00,0.00,500.00,9000.00,'2021-12-18 10:09:58','',''),(2311763,'1','140','773',331,'Retail Sale Id 1357721',655200.00,0.00,0.00,1200.00,21600.00,'2021-12-18 10:10:37','',''),(2311772,'1','140','773',331,'Retail Sale Id 1357729',27500.00,0.00,0.00,50.00,1100.00,'2021-12-18 10:11:52','',''),(2311796,'1','140','773',331,'Retail Sale Id 1357750',421512.00,0.00,0.00,772.00,13896.00,'2021-12-18 10:15:07','',''),(2311905,'1','140','773',331,'Retail Sale Id 1357819',3600.00,0.00,0.00,6.00,432.00,'2021-12-18 10:21:55','',''),(2311999,'1','140','773',331,'Retail Sale Id 1357907',8760.00,0.00,0.00,14.60,1051.20,'2021-12-18 10:30:10','',''),(2312009,'1','140','773',331,'Retail Sale Id 1357916',3000.00,0.00,0.00,5.00,360.00,'2021-12-18 10:30:47','',''),(2312076,'1','140','773',331,'Retail Sale Id 1357970',1200.00,0.00,0.00,2.00,144.00,'2021-12-18 10:35:23','',''),(2312158,'1','140','773',331,'Retail Sale Id 1358056',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 10:41:49','',''),(2312182,'1','140','773',331,'Retail Sale Id 1358084',2997.50,0.00,0.00,5.45,119.90,'2021-12-18 10:43:55','',''),(2312211,'1','140','773',331,'Retail Sale Id 1358108',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 10:47:00','',''),(2312323,'1','140','773',331,'Retail Sale Id 1358209',12650.00,0.00,0.00,23.00,506.00,'2021-12-18 10:55:42','',''),(2312374,'1','140','773',331,'Retail Sale Id 1358252',37950.00,0.00,0.00,69.00,1518.00,'2021-12-18 10:59:52','',''),(2312507,'1','140','773',331,'Retail Sale Id 1358370',2400.00,0.00,0.00,4.00,288.00,'2021-12-18 11:10:32','',''),(2312531,'1','140','773',331,'Retail Sale Id 1358385',600.00,0.00,0.00,1.00,72.00,'2021-12-18 11:11:46','',''),(2312676,'1','140','773',331,'Retail Sale Id 1358491',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 11:21:52','',''),(2312692,'1','140','773',331,'Retail Sale Id 1358506',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 11:23:18','',''),(2312734,'1','140','773',331,'Retail Sale Id 1358547',7500.00,0.00,0.00,12.50,900.00,'2021-12-18 11:26:30','',''),(2312789,'1','140','773',331,'Retail Sale Id 1358595',8400.00,0.00,0.00,14.00,1008.00,'2021-12-18 11:30:41','',''),(2312835,'1','140','773',331,'Retail Sale Id 1358646',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 11:34:51','',''),(2312857,'1','140','773',331,'Retail Sale Id 1358663',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 11:36:38','',''),(2312879,'1','140','773',331,'Retail Sale Id 1358690',3600.00,0.00,0.00,6.00,432.00,'2021-12-18 11:38:16','',''),(2312891,'1','140','773',331,'Retail Sale Id 1358703',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 11:39:33','',''),(2313005,'1','140','773',331,'Retail Sale Id 1358808',3000.00,0.00,0.00,5.00,360.00,'2021-12-18 11:52:24','',''),(2313032,'1','140','773',331,'Retail Sale Id 1358843',2200.00,0.00,0.00,4.00,88.00,'2021-12-18 11:55:46','',''),(2313330,'1','140','773',331,'Retail Sale Id 1359125',57750.00,0.00,0.00,105.00,2310.00,'2021-12-18 12:28:51','',''),(2313375,'1','140','773',331,'Retail Sale Id 1359169',2502.00,0.00,0.00,4.17,300.24,'2021-12-18 12:33:33','',''),(2313393,'1','140','773',331,'Retail Sale Id 1359186',1998.00,0.00,0.00,3.33,239.76,'2021-12-18 12:35:46','',''),(2313428,'1','140','773',331,'Retail Sale Id 1359209',409500.00,0.00,0.00,750.00,13500.00,'2021-12-18 12:38:17','',''),(2313440,'1','140','773',331,'Retail Sale Id 1359222',600.00,0.00,0.00,1.00,72.00,'2021-12-18 12:39:17','',''),(2313454,'1','140','773',331,'Retail Sale Id 1359226',1200.00,0.00,0.00,2.00,144.00,'2021-12-18 12:40:07','',''),(2313490,'1','140','773',331,'Retail Sale Id 1359258',1200.00,0.00,0.00,2.00,144.00,'2021-12-18 12:43:11','',''),(2313512,'1','140','773',331,'Retail Sale Id 1359283',600.00,0.00,0.00,1.00,72.00,'2021-12-18 12:45:03','',''),(2313554,'1','140','773',331,'Retail Sale Id 1359327',7500.00,0.00,0.00,12.50,900.00,'2021-12-18 12:49:05','',''),(2313585,'1','140','773',331,'Retail Sale Id 1359356',1500.00,0.00,0.00,2.50,180.00,'2021-12-18 12:52:13','',''),(2313682,'1','140','773',331,'Retail Sale Id 1359449',4200.00,0.00,0.00,7.00,504.00,'2021-12-18 13:00:17','',''),(2313705,'1','140','773',331,'Retail Sale Id 1359476',4002.00,0.00,0.00,6.67,480.24,'2021-12-18 13:02:48','',''),(2314169,'1','140','773',331,'Retail Sale Id 1359863',3000.00,0.00,0.00,5.00,360.00,'2021-12-18 13:45:34','',''),(2314331,'1','140','773',331,'Retail Sale Id 1359942',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 13:52:38','',''),(2314490,'1','140','773',331,'Retail Sale Id 1360079',3600.00,0.00,0.00,6.00,432.00,'2021-12-18 14:05:23','',''),(2314620,'1','140','773',331,'Retail Sale Id 1360187',3600.00,0.00,0.00,6.00,432.00,'2021-12-18 14:15:58','',''),(2314810,'1','140','773',331,'Retail Sale Id 1360354',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 14:32:04','',''),(2314896,'1','140','773',331,'Retail Sale Id 1360419',1200.00,0.00,0.00,2.00,144.00,'2021-12-18 14:38:25','',''),(2315028,'1','140','773',331,'Retail Sale Id 1360522',12650.00,0.00,0.00,23.00,506.00,'2021-12-18 14:49:01','',''),(2315096,'1','140','773',331,'Retail Sale Id 1360581',1200.00,0.00,0.00,2.00,144.00,'2021-12-18 14:54:02','',''),(2315166,'1','140','773',331,'Retail Sale Id 1360646',2400.00,0.00,0.00,4.00,288.00,'2021-12-18 15:01:11','',''),(2315185,'1','140','773',331,'Retail Sale Id 1360669',7500.00,0.00,0.00,12.50,900.00,'2021-12-18 15:03:02','',''),(2315297,'1','140','773',331,'Retail Sale Id 1360752',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 15:11:57','',''),(2315340,'1','140','773',331,'Retail Sale Id 1360789',1200.00,0.00,0.00,2.00,144.00,'2021-12-18 15:15:55','',''),(2315360,'1','140','773',331,'Retail Sale Id 1360811',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 15:17:33','',''),(2315372,'1','140','773',331,'Retail Sale Id 1360824',1500.00,0.00,0.00,2.50,180.00,'2021-12-18 15:18:58','',''),(2315527,'1','140','773',331,'Retail Sale Id 1360959',3000.00,0.00,0.00,5.00,360.00,'2021-12-18 15:30:36','',''),(2315542,'1','140','773',331,'Retail Sale Id 1360972',1002.00,0.00,0.00,1.67,120.24,'2021-12-18 15:32:00','',''),(2315562,'1','140','773',331,'Retail Sale Id 1360988',3000.00,0.00,0.00,5.00,360.00,'2021-12-18 15:33:25','',''),(2315574,'1','140','773',331,'Retail Sale Id 1361002',1200.00,0.00,0.00,2.00,144.00,'2021-12-18 15:34:34','',''),(2315597,'1','140','773',331,'Retail Sale Id 1361022',4002.00,0.00,0.00,6.67,480.24,'2021-12-18 15:36:13','',''),(2315623,'1','140','773',331,'Retail Sale Id 1361048',70400.00,0.00,0.00,128.00,2816.00,'2021-12-18 15:38:10','',''),(2315644,'1','140','773',331,'Retail Sale Id 1361072',8800.00,0.00,0.00,16.00,352.00,'2021-12-18 15:39:33','',''),(2315757,'1','140','773',331,'Retail Sale Id 1361169',1200.00,0.00,0.00,2.00,144.00,'2021-12-18 15:47:43','',''),(2315881,'1','140','773',331,'Retail Sale Id 1361244',1200.00,0.00,0.00,2.00,144.00,'2021-12-18 15:53:08','',''),(2315970,'1','140','773',331,'Retail Sale Id 1361314',1200.00,0.00,0.00,2.00,144.00,'2021-12-18 15:58:00','',''),(2316046,'1','140','773',331,'Retail Sale Id 1361368',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 16:01:48','',''),(2316063,'1','140','773',331,'Retail Sale Id 1361385',1200.00,0.00,0.00,2.00,144.00,'2021-12-18 16:03:10','',''),(2316079,'1','140','773',331,'Retail Sale Id 1361402',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 16:04:27','',''),(2316102,'1','140','773',331,'Retail Sale Id 1361424',66000.00,0.00,0.00,120.00,2640.00,'2021-12-18 16:06:01','',''),(2316110,'1','140','773',331,'Retail Sale Id 1361435',4200.00,0.00,0.00,7.00,504.00,'2021-12-18 16:06:54','',''),(2316156,'1','140','773',331,'Retail Sale Id 1361478',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 16:10:01','',''),(2316208,'1','140','773',331,'Retail Sale Id 1361528',3600.00,0.00,0.00,6.00,432.00,'2021-12-18 16:13:55','',''),(2316292,'1','140','773',331,'Retail Sale Id 1361596',7500.00,0.00,0.00,12.50,900.00,'2021-12-18 16:19:03','',''),(2316311,'1','140','773',331,'Retail Sale Id 1361617',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 16:20:40','',''),(2316341,'1','140','773',331,'Retail Sale Id 1361645',65520.00,0.00,0.00,120.00,2160.00,'2021-12-18 16:22:48','',''),(2316353,'1','140','773',331,'Retail Sale Id 1361659',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 16:23:44','',''),(2316382,'1','140','773',331,'Retail Sale Id 1361686',2400.00,0.00,0.00,4.00,288.00,'2021-12-18 16:25:43','',''),(2316449,'1','140','773',331,'Retail Sale Id 1361754',38500.00,0.00,0.00,70.00,1540.00,'2021-12-18 16:30:53','',''),(2316464,'1','140','773',331,'Retail Sale Id 1361767',1002.00,0.00,0.00,1.67,120.24,'2021-12-18 16:32:12','',''),(2316483,'1','140','773',331,'Retail Sale Id 1361785',3600.00,0.00,0.00,6.00,432.00,'2021-12-18 16:33:23','',''),(2316507,'1','140','773',331,'Retail Sale Id 1361809',33000.00,0.00,0.00,60.00,1320.00,'2021-12-18 16:35:08','',''),(2316548,'1','140','773',331,'Retail Sale Id 1361861',6875.00,0.00,0.00,12.50,275.00,'2021-12-18 16:38:54','',''),(2316559,'1','140','773',331,'Retail Sale Id 1361874',1500.00,0.00,0.00,2.50,180.00,'2021-12-18 16:40:08','',''),(2316766,'1','140','773',331,'Retail Sale Id 1362044',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 16:55:03','',''),(2316803,'1','140','773',331,'Retail Sale Id 1362084',3000.00,0.00,0.00,5.00,360.00,'2021-12-18 16:57:59','',''),(2316821,'1','140','773',331,'Retail Sale Id 1362103',1800.00,0.00,0.00,3.00,216.00,'2021-12-18 16:59:25','',''),(2316837,'1','140','773',331,'Retail Sale Id 1362120',6000.00,0.00,0.00,10.00,720.00,'2021-12-18 17:00:58','',''),(2319732,'1','140','773',331,'Retail Sale Id 1364259',1800.00,0.00,0.00,3.00,216.00,'2021-12-19 09:07:42','',''),(2320079,'1','140','773',331,'Retail Sale Id 1364439',6600.00,0.00,0.00,12.00,264.00,'2021-12-19 09:25:19','',''),(2320111,'1','140','773',331,'Retail Sale Id 1364461',600.00,0.00,0.00,1.00,72.00,'2021-12-19 09:26:45','',''),(2320221,'1','140','773',331,'Retail Sale Id 1364537',1800.00,0.00,0.00,3.00,216.00,'2021-12-19 09:33:07','',''),(2320246,'1','140','773',331,'Retail Sale Id 1364568',1800.00,0.00,0.00,3.00,216.00,'2021-12-19 09:35:16','',''),(2320263,'1','140','773',331,'Retail Sale Id 1364585',30250.00,0.00,0.00,55.00,1210.00,'2021-12-19 09:36:53','',''),(2320309,'1','140','773',331,'Retail Sale Id 1364632',3000.00,0.00,0.00,5.00,360.00,'2021-12-19 09:40:12','',''),(2320417,'1','140','773',331,'Retail Sale Id 1364740',1200.00,0.00,0.00,2.00,144.00,'2021-12-19 09:50:08','',''),(2320467,'1','140','773',331,'Retail Sale Id 1364787',85250.00,0.00,0.00,155.00,3410.00,'2021-12-19 09:54:49','',''),(2320483,'1','140','773',331,'Retail Sale Id 1364806',1200.00,0.00,0.00,2.00,144.00,'2021-12-19 09:55:59','',''),(2320540,'1','140','773',331,'Retail Sale Id 1364864',1500.00,0.00,0.00,2.50,180.00,'2021-12-19 10:00:50','',''),(2320601,'1','140','773',331,'Retail Sale Id 1364918',1800.00,0.00,0.00,3.00,216.00,'2021-12-19 10:05:37','',''),(2320655,'1','140','773',331,'Retail Sale Id 1364979',1800.00,0.00,0.00,3.00,216.00,'2021-12-19 10:10:00','',''),(2320687,'1','140','773',331,'Retail Sale Id 1365009',13200.00,0.00,0.00,24.00,528.00,'2021-12-19 10:12:06','',''),(2320793,'1','140','773',331,'Retail Sale Id 1365108',2400.00,0.00,0.00,4.00,288.00,'2021-12-19 10:20:10','',''),(2320859,'1','140','773',331,'Retail Sale Id 1365164',22000.00,0.00,0.00,40.00,880.00,'2021-12-19 10:25:12','',''),(2321069,'1','140','773',331,'Retail Sale Id 1365372',3600.00,0.00,0.00,6.00,432.00,'2021-12-19 10:43:18','',''),(2321223,'1','140','773',331,'Retail Sale Id 1365531',1200.00,0.00,0.00,2.00,144.00,'2021-12-19 10:57:06','',''),(2321269,'1','140','773',331,'Retail Sale Id 1365575',1200.00,0.00,0.00,2.00,144.00,'2021-12-19 11:00:55','',''),(2321288,'1','140','773',331,'Retail Sale Id 1365601',47300.00,0.00,0.00,86.00,1892.00,'2021-12-19 11:02:24','',''),(2321340,'1','140','773',331,'Retail Sale Id 1365648',1002.00,0.00,0.00,1.67,120.24,'2021-12-19 11:06:55','',''),(2321450,'1','140','773',331,'Retail Sale Id 1365743',33000.00,0.00,0.00,60.00,1320.00,'2021-12-19 11:14:09','',''),(2321588,'1','140','773',331,'Retail Sale Id 1365870',1200.00,0.00,0.00,2.00,144.00,'2021-12-19 11:25:21','',''),(2321649,'1','140','773',331,'Retail Sale Id 1365932',1200.00,0.00,0.00,2.00,144.00,'2021-12-19 11:30:04','',''),(2321664,'1','140','773',331,'Retail Sale Id 1365946',6000.00,0.00,0.00,10.00,720.00,'2021-12-19 11:31:36','',''),(2321719,'1','140','773',331,'Retail Sale Id 1365983',1200.00,0.00,0.00,2.00,144.00,'2021-12-19 11:36:54','',''),(2321804,'1','140','773',331,'Retail Sale Id 1366062',7200.00,0.00,0.00,12.00,864.00,'2021-12-19 11:43:50','',''),(2321848,'1','140','773',331,'Retail Sale Id 1366104',1200.00,0.00,0.00,2.00,144.00,'2021-12-19 11:46:52','',''),(2321906,'1','140','773',331,'Retail Sale Id 1366162',1200.00,0.00,0.00,2.00,144.00,'2021-12-19 11:52:04','',''),(2321986,'1','140','773',331,'Retail Sale Id 1366239',2400.00,0.00,0.00,4.00,288.00,'2021-12-19 11:58:51','',''),(2322012,'1','140','773',331,'Retail Sale Id 1366268',3000.00,0.00,0.00,5.00,360.00,'2021-12-19 12:01:05','',''),(2322227,'1','140','773',331,'Retail Sale Id 1366482',7500.00,0.00,0.00,12.50,900.00,'2021-12-19 12:20:06','',''),(2322328,'1','140','773',331,'Retail Sale Id 1366584',1200.00,0.00,0.00,2.00,144.00,'2021-12-19 12:31:04','',''),(2322616,'1','140','773',331,'Retail Sale Id 1366840',3702.00,0.00,0.00,6.17,444.24,'2021-12-19 12:56:02','',''),(2322859,'1','140','773',331,'Retail Sale Id 1367074',13200.00,0.00,0.00,24.00,528.00,'2021-12-19 13:18:41','',''),(2323102,'1','140','773',331,'Retail Sale Id 1367261',2400.00,0.00,0.00,4.00,288.00,'2021-12-19 13:36:22','',''),(2323122,'1','140','773',331,'Retail Sale Id 1367279',1200.00,0.00,0.00,2.00,144.00,'2021-12-19 13:38:27','',''),(2323148,'1','140','773',331,'Retail Sale Id 1367298',446082.00,0.00,0.00,817.00,14706.00,'2021-12-19 13:40:11','',''),(2323162,'1','140','773',331,'Retail Sale Id 1367310',382200.00,0.00,0.00,700.00,12600.00,'2021-12-19 13:41:02','',''),(2323184,'1','140','773',331,'Retail Sale Id 1367321',1002.00,0.00,0.00,1.67,120.24,'2021-12-19 13:42:14','',''),(2323201,'1','140','773',331,'Retail Sale Id 1367329',900.00,0.00,0.00,1.50,108.00,'2021-12-19 13:43:20','',''),(2323328,'1','140','773',331,'Retail Sale Id 1367429',1200.00,0.00,0.00,2.00,144.00,'2021-12-19 13:53:55','',''),(2323350,'1','140','773',331,'Retail Sale Id 1367454',1200.00,0.00,0.00,2.00,144.00,'2021-12-19 13:55:28','',''),(2323364,'1','140','773',331,'Retail Sale Id 1367469',2400.00,0.00,0.00,4.00,288.00,'2021-12-19 13:56:42','',''),(2323397,'1','140','773',331,'Retail Sale Id 1367493',600.00,0.00,0.00,1.00,72.00,'2021-12-19 13:58:36','',''),(2323439,'1','140','773',331,'Retail Sale Id 1367533',1998.00,0.00,0.00,3.33,239.76,'2021-12-19 14:00:34','',''),(2323469,'1','140','773',331,'Retail Sale Id 1367552',1998.00,0.00,0.00,3.33,239.76,'2021-12-19 14:02:04','',''),(2323645,'1','140','773',331,'Retail Sale Id 1367697',15900.00,0.00,0.00,26.50,1908.00,'2021-12-19 14:14:19','',''),(2323684,'1','140','773',331,'Retail Sale Id 1367730',3000.00,0.00,0.00,5.00,360.00,'2021-12-19 14:17:25','',''),(2323923,'1','140','773',331,'Retail Sale Id 1367935',7500.00,0.00,0.00,12.50,900.00,'2021-12-19 14:39:01','',''),(2323957,'1','140','773',331,'Retail Sale Id 1367966',1200.00,0.00,0.00,2.00,144.00,'2021-12-19 14:42:52','',''),(2323985,'1','140','773',331,'Retail Sale Id 1367993',1200.00,0.00,0.00,2.00,144.00,'2021-12-19 14:45:06','',''),(2324008,'1','140','773',331,'Retail Sale Id 1368016',2400.00,0.00,0.00,4.00,288.00,'2021-12-19 14:47:16','',''),(2324042,'1','140','773',331,'Retail Sale Id 1368046',27500.00,0.00,0.00,50.00,1100.00,'2021-12-19 14:50:20','',''),(2324097,'1','140','773',331,'Retail Sale Id 1368108',8525.00,0.00,0.00,15.50,341.00,'2021-12-19 14:57:13','',''),(2324139,'1','140','773',331,'Retail Sale Id 1368145',1998.00,0.00,0.00,3.33,239.76,'2021-12-19 15:02:25','',''),(2324159,'1','140','773',331,'Retail Sale Id 1368137',3600.00,0.00,0.00,6.00,432.00,'2021-12-19 15:04:12','',''),(2324186,'1','140','773',331,'Retail Sale Id 1368191',3600.00,0.00,0.00,6.00,432.00,'2021-12-19 15:07:09','',''),(2324426,'1','140','773',331,'Retail Sale Id 1368399',27500.00,0.00,0.00,50.00,1100.00,'2021-12-19 15:31:20','',''),(2326734,'1','140','773',331,'Retail Sale Id 1369982',1800.00,0.00,0.00,3.00,216.00,'2021-12-20 07:25:01','',''),(2326850,'1','140','773',331,'Retail Sale Id 1370084',33000.00,0.00,0.00,60.00,1320.00,'2021-12-20 07:39:54','',''),(2326947,'1','140','773',331,'Retail Sale Id 1370135',1800.00,0.00,0.00,3.00,216.00,'2021-12-20 07:47:01','',''),(2326990,'1','140','773',331,'Retail Sale Id 1370165',1800.00,0.00,0.00,3.00,216.00,'2021-12-20 07:50:28','',''),(2326996,'1','140','773',331,'Retail Sale Id 1370173',1800.00,0.00,0.00,3.00,216.00,'2021-12-20 07:51:37','',''),(2327067,'1','140','773',331,'Retail Sale Id 1370207',1800.00,0.00,0.00,3.00,216.00,'2021-12-20 07:57:13','',''),(2327107,'1','140','773',331,'Retail Sale Id 1370248',600.00,0.00,0.00,1.00,72.00,'2021-12-20 08:02:18','',''),(2330669,'1','140','773',331,'Retail Sale Id 1373166',27500.00,0.00,0.00,50.00,1100.00,'2021-12-20 14:20:24','',''),(2330715,'1','140','773',331,'Retail Sale Id 1373193',107250.00,0.00,0.00,195.00,4290.00,'2021-12-20 14:24:22','',''),(2330723,'1','140','773',331,'Retail Sale Id 1373199',13200.00,0.00,0.00,24.00,528.00,'2021-12-20 14:25:34','',''),(2330743,'1','140','773',331,'Retail Sale Id 1373211',46200.00,0.00,0.00,84.00,1848.00,'2021-12-20 14:26:48','',''),(2330782,'1','140','773',331,'Retail Sale Id 1373229',54780.00,0.00,0.00,99.60,2191.20,'2021-12-20 14:29:04','',''),(2330837,'1','140','773',331,'Retail Sale Id 1373255',3600.00,0.00,0.00,6.00,432.00,'2021-12-20 14:33:16','',''),(2330850,'1','140','773',331,'Retail Sale Id 1373256',1200.00,0.00,0.00,2.00,144.00,'2021-12-20 14:33:54','',''),(2330853,'1','140','773',331,'Retail Sale Id 1373259',7500.00,0.00,0.00,12.50,900.00,'2021-12-20 14:34:41','',''),(2330864,'1','140','773',331,'Retail Sale Id 1373267',3600.00,0.00,0.00,6.00,432.00,'2021-12-20 14:35:53','',''),(2330882,'1','140','773',331,'Retail Sale Id 1373281',1800.00,0.00,0.00,3.00,216.00,'2021-12-20 14:37:03','',''),(2330896,'1','140','773',331,'Retail Sale Id 1373289',3000.00,0.00,0.00,5.00,360.00,'2021-12-20 14:37:58','',''),(2331013,'1','140','773',331,'Retail Sale Id 1373363',26500.00,0.00,0.00,50.00,100.00,'2021-12-20 14:46:45','',''),(2331031,'1','140','773',331,'Retail Sale Id 1373380',135150.00,0.00,0.00,255.00,510.00,'2021-12-20 14:49:02','',''),(2331051,'1','140','773',331,'Retail Sale Id 1373396',151050.00,0.00,0.00,285.00,570.00,'2021-12-20 14:50:48','',''),(2331074,'1','140','773',331,'Retail Sale Id 1373410',95400.00,0.00,0.00,180.00,360.00,'2021-12-20 14:53:00','',''),(2331097,'1','140','773',331,'Retail Sale Id 1373438',344500.00,0.00,0.00,650.00,1300.00,'2021-12-20 14:54:34','',''),(2332095,'1','140','773',331,'Retail Sale Id 1374310',1800.00,0.00,0.00,3.00,216.00,'2021-12-20 16:34:00','',''),(2333100,'1','140','773',331,'Retail Sale Id 1374927',2559370.00,0.00,0.00,4829.00,9658.00,'2021-12-20 20:10:36','',''),(2333130,'1','140','773',331,'Retail Sale Id 1374928',3286.00,0.00,0.00,6.20,12.40,'2021-12-20 20:19:07','',''),(2333526,'1','140','773',331,'Retail Sale Id 1375137',1200.00,0.00,0.00,2.00,144.00,'2021-12-21 06:42:27','',''),(2333549,'1','140','773',331,'Retail Sale Id 1375160',3498.00,0.00,0.00,5.83,419.76,'2021-12-21 06:46:19','',''),(2333576,'1','140','773',331,'Retail Sale Id 1375187',63600.00,0.00,0.00,120.00,240.00,'2021-12-21 06:50:01','',''),(2333620,'1','140','773',331,'Retail Sale Id 1375233',1200.00,0.00,0.00,2.00,144.00,'2021-12-21 06:55:56','',''),(2333673,'1','140','773',331,'Retail Sale Id 1375283',3600.00,0.00,0.00,6.00,432.00,'2021-12-21 07:02:33','',''),(2333792,'1','140','773',331,'Retail Sale Id 1375330',12190.00,0.00,0.00,23.00,46.00,'2021-12-21 07:11:08','',''),(2333850,'1','140','773',331,'Retail Sale Id 1375377',1200.00,0.00,0.00,2.00,144.00,'2021-12-21 07:17:42','',''),(2333888,'1','140','773',331,'Retail Sale Id 1375410',1800.00,0.00,0.00,3.00,216.00,'2021-12-21 07:20:49','',''),(2333902,'1','140','773',331,'Retail Sale Id 1375422',1200.00,0.00,0.00,2.00,144.00,'2021-12-21 07:22:06','',''),(2333918,'1','140','773',331,'Retail Sale Id 1375440',2400.00,0.00,0.00,4.00,288.00,'2021-12-21 07:24:47','',''),(2333931,'1','140','773',331,'Retail Sale Id 1375455',1800.00,0.00,0.00,3.00,216.00,'2021-12-21 07:26:09','',''),(2333947,'1','140','773',331,'Retail Sale Id 1375469',1200.00,0.00,0.00,2.00,144.00,'2021-12-21 07:27:39','',''),(2333966,'1','140','773',331,'Retail Sale Id 1375479',3600.00,0.00,0.00,6.00,432.00,'2021-12-21 07:28:39','',''),(2333981,'1','140','773',331,'Retail Sale Id 1375493',31800.00,0.00,0.00,60.00,120.00,'2021-12-21 07:29:44','',''),(2333994,'1','140','773',331,'Retail Sale Id 1375507',12720.00,0.00,0.00,24.00,48.00,'2021-12-21 07:32:24','',''),(2334024,'1','140','773',331,'Retail Sale Id 1375530',1800.00,0.00,0.00,3.00,216.00,'2021-12-21 07:35:10','',''),(2334032,'1','140','773',331,'Retail Sale Id 1375539',26500.00,0.00,0.00,50.00,100.00,'2021-12-21 07:36:23','',''),(2334046,'1','140','773',331,'Retail Sale Id 1375548',29150.00,0.00,0.00,55.00,110.00,'2021-12-21 07:37:22','',''),(2334091,'1','140','773',331,'Retail Sale Id 1375586',11130.00,0.00,0.00,21.00,42.00,'2021-12-21 07:42:23','',''),(2334108,'1','140','773',331,'Retail Sale Id 1375608',600.00,0.00,0.00,1.00,72.00,'2021-12-21 07:45:24','',''),(2334125,'1','140','773',331,'Retail Sale Id 1375626',1800.00,0.00,0.00,3.00,216.00,'2021-12-21 07:46:35','',''),(2334134,'1','140','773',331,'Retail Sale Id 1375636',1200.00,0.00,0.00,2.00,144.00,'2021-12-21 07:47:25','',''),(2334146,'1','140','773',331,'Retail Sale Id 1375645',39220.00,0.00,0.00,74.00,148.00,'2021-12-21 07:49:01','',''),(2334169,'1','140','773',331,'Retail Sale Id 1375656',1200.00,0.00,0.00,2.00,144.00,'2021-12-21 07:50:24','',''),(2334208,'1','140','773',331,'Retail Sale Id 1375687',1200.00,0.00,0.00,2.00,144.00,'2021-12-21 07:52:33','',''),(2334231,'1','140','773',331,'Retail Sale Id 1375696',3000.00,0.00,0.00,5.00,360.00,'2021-12-21 07:53:48','',''),(2334253,'1','140','773',331,'Retail Sale Id 1375715',7500.00,0.00,0.00,12.50,900.00,'2021-12-21 07:55:39','',''),(2334274,'1','140','773',331,'Retail Sale Id 1375755',1200.00,0.00,0.00,2.00,144.00,'2021-12-21 07:57:01','',''),(2334301,'1','140','773',331,'Retail Sale Id 1375773',3000.00,0.00,0.00,5.00,360.00,'2021-12-21 07:58:38','',''),(2334334,'1','140','773',331,'Retail Sale Id 1375802',3600.00,0.00,0.00,6.00,432.00,'2021-12-21 08:02:18','',''),(2334345,'1','140','773',331,'Retail Sale Id 1375808',1800.00,0.00,0.00,3.00,216.00,'2021-12-21 08:03:43','',''),(2334356,'1','140','773',331,'Retail Sale Id 1375824',1200.00,0.00,0.00,2.00,144.00,'2021-12-21 08:04:53','',''),(2334413,'1','140','773',331,'Retail Sale Id 1375847',39220.00,0.00,0.00,74.00,148.00,'2021-12-21 08:07:11','',''),(2334469,'1','140','773',331,'Retail Sale Id 1375899',3600.00,0.00,0.00,6.00,432.00,'2021-12-21 08:13:36','',''),(2334483,'1','140','773',331,'Retail Sale Id 1375914',26500.00,0.00,0.00,50.00,100.00,'2021-12-21 08:15:14','',''),(2334500,'1','140','773',331,'Retail Sale Id 1375930',25440.00,0.00,0.00,48.00,96.00,'2021-12-21 08:18:27','',''),(2334516,'1','140','773',331,'Retail Sale Id 1375944',21200.00,0.00,0.00,40.00,80.00,'2021-12-21 08:21:09','',''),(2334535,'1','140','773',331,'Retail Sale Id 1375955',28090.00,0.00,0.00,53.00,106.00,'2021-12-21 08:23:11','',''),(2334552,'1','140','773',331,'Retail Sale Id 1375971',90100.00,0.00,0.00,170.00,340.00,'2021-12-21 08:26:36','',''),(2334559,'1','140','773',331,'Retail Sale Id 1375979',3000.00,0.00,0.00,5.00,360.00,'2021-12-21 08:27:24','',''),(2334658,'1','140','773',331,'Retail Sale Id 1376079',1800.00,0.00,0.00,3.00,216.00,'2021-12-21 08:43:45','',''),(2334665,'1','140','773',331,'Retail Sale Id 1376088',7500.00,0.00,0.00,12.50,900.00,'2021-12-21 08:45:09','',''),(2334672,'1','140','773',331,'Retail Sale Id 1376095',8480.00,0.00,0.00,16.00,32.00,'2021-12-21 08:46:11','',''),(2334694,'1','140','773',331,'Retail Sale Id 1376112',600.00,0.00,0.00,1.00,72.00,'2021-12-21 08:47:55','',''),(2334853,'1','140','773',331,'Retail Sale Id 1376230',87450.00,0.00,0.00,165.00,330.00,'2021-12-21 09:05:59','',''),(2334902,'1','140','773',331,'Retail Sale Id 1376280',1800.00,0.00,0.00,3.00,216.00,'2021-12-21 09:13:19','',''),(2334921,'1','140','773',331,'Retail Sale Id 1376294',600.00,0.00,0.00,1.00,72.00,'2021-12-21 09:15:02','',''),(2334973,'1','140','773',331,'Retail Sale Id 1376336',18550.00,0.00,0.00,35.00,70.00,'2021-12-21 09:20:23','',''),(2335073,'1','140','773',331,'Retail Sale Id 1376397',1800.00,0.00,0.00,3.00,216.00,'2021-12-21 09:27:55','',''),(2335083,'1','140','773',331,'Retail Sale Id 1376408',600.00,0.00,0.00,1.00,72.00,'2021-12-21 09:29:46','',''),(2335207,'1','140','773',331,'Retail Sale Id 1376500',1800.00,0.00,0.00,3.00,216.00,'2021-12-21 09:40:46','',''),(2335215,'1','140','773',331,'Retail Sale Id 1376507',3000.00,0.00,0.00,5.00,360.00,'2021-12-21 09:42:08','',''),(2335223,'1','140','773',331,'Retail Sale Id 1376517',1200.00,0.00,0.00,2.00,144.00,'2021-12-21 09:43:27','',''),(2335312,'1','140','773',331,'Retail Sale Id 1376597',3000.00,0.00,0.00,5.00,360.00,'2021-12-21 09:53:11','',''),(2335350,'1','140','773',331,'Retail Sale Id 1376656',1200.00,0.00,0.00,2.00,144.00,'2021-12-21 09:59:22','',''),(2335382,'1','140','773',331,'Retail Sale Id 1376683',1200.00,0.00,0.00,2.00,144.00,'2021-12-21 10:02:44','',''),(2335394,'1','140','773',331,'Retail Sale Id 1376692',1200.00,0.00,0.00,2.00,144.00,'2021-12-21 10:04:08','',''),(2335437,'1','140','773',331,'Retail Sale Id 1376733',6600.00,0.00,0.00,11.00,792.00,'2021-12-21 10:10:15','',''),(2335477,'1','140','773',331,'Retail Sale Id 1376772',1200.00,0.00,0.00,2.00,144.00,'2021-12-21 10:15:59','',''),(2335485,'1','140','773',331,'Retail Sale Id 1376782',1200.00,0.00,0.00,2.00,144.00,'2021-12-21 10:17:09','',''),(2335519,'1','140',NULL,331,'Purchased from AA RANO NIGERIA LIMITED',0.00,12849250.00,24950.00,0.00,0.00,'2021-12-21 10:22:16','',''),(2335531,'1','140',NULL,331,'Reception corrector for bridging 128190',0.00,0.00,0.00,24950.00,0.00,'2021-12-21 10:23:57','',''),(2335532,'1','140','773',331,'Received from bridging 128190',0.00,0.00,24950.00,0.00,0.00,'2021-12-21 10:23:57','',''),(2335547,'1','140','773',331,'Retail Sale Id 1376835',1800.00,0.00,0.00,3.00,255.00,'2021-12-21 10:24:43','',''),(2335597,'1','140','773',331,'Retail Sale Id 1376855',31800.00,0.00,0.00,60.00,900.00,'2021-12-21 10:28:07','',''),(2335932,'1','140','773',331,'Retail Sale Id 1377095',1200.00,0.00,0.00,2.00,170.00,'2021-12-21 10:59:43','',''),(2336008,'1','140','773',331,'Retail Sale Id 1377160',600.00,0.00,0.00,1.00,85.00,'2021-12-21 11:07:45','',''),(2336118,'1','140','773',331,'Retail Sale Id 1377254',3000.00,0.00,0.00,5.00,425.00,'2021-12-21 11:17:58','',''),(2336162,'1','140','773',331,'Retail Sale Id 1377298',13250.00,0.00,0.00,25.00,375.00,'2021-12-21 11:23:16','',''),(2336224,'1','140','773',331,'Retail Sale Id 1377344',1200.00,0.00,0.00,2.00,170.00,'2021-12-21 11:29:37','',''),(2336314,'1','140','773',331,'Retail Sale Id 1377426',1200.00,0.00,0.00,2.00,170.00,'2021-12-21 11:42:08','',''),(2336324,'1','140','773',331,'Retail Sale Id 1377435',29150.00,0.00,0.00,55.00,825.00,'2021-12-21 11:43:22','',''),(2336371,'1','140','773',331,'Retail Sale Id 1377478',4800.00,0.00,0.00,8.00,680.00,'2021-12-21 11:50:45','',''),(2336404,'1','140','773',331,'Retail Sale Id 1377502',600.00,0.00,0.00,1.00,85.00,'2021-12-21 11:54:26','',''),(2336466,'1','140','773',331,'Retail Sale Id 1377553',58300.00,0.00,0.00,110.00,1650.00,'2021-12-21 12:00:55','',''),(2336629,'1','140','773',331,'Retail Sale Id 1377701',53000.00,0.00,0.00,100.00,1500.00,'2021-12-21 12:21:04','',''),(2336745,'1','140','773',331,'Retail Sale Id 1377798',3600.00,0.00,0.00,6.00,510.00,'2021-12-21 12:34:53','',''),(2336888,'1','140','773',331,'Retail Sale Id 1377949',26500.00,0.00,0.00,50.00,750.00,'2021-12-21 12:51:34','',''),(2336897,'1','140','773',331,'Retail Sale Id 1377961',2400.00,0.00,0.00,4.00,340.00,'2021-12-21 12:52:39','',''),(2336920,'1','140','773',331,'Retail Sale Id 1377982',1200.00,0.00,0.00,2.00,170.00,'2021-12-21 12:55:12','',''),(2336946,'1','140','773',331,'Retail Sale Id 1377999',7500.00,0.00,0.00,12.50,1062.50,'2021-12-21 12:57:01','',''),(2337179,'1','140','773',331,'Retail Sale Id 1378186',1800.00,0.00,0.00,3.00,255.00,'2021-12-21 13:18:16','',''),(2337348,'1','140','773',331,'Retail Sale Id 1378353',1800.00,0.00,0.00,3.00,255.00,'2021-12-21 13:37:46','',''),(2337383,'1','140','773',331,'Retail Sale Id 1378362',6600.00,0.00,0.00,11.00,935.00,'2021-12-21 13:39:19','',''),(2337491,'1','140','773',331,'Retail Sale Id 1378399',3600.00,0.00,0.00,6.00,510.00,'2021-12-21 13:44:38','',''),(2337656,'1','140','773',331,'Retail Sale Id 1378542',1200.00,0.00,0.00,2.00,170.00,'2021-12-21 13:58:49','',''),(2337674,'1','140','773',331,'Retail Sale Id 1378561',1800.00,0.00,0.00,3.00,255.00,'2021-12-21 14:01:16','',''),(2337708,'1','140','773',331,'Retail Sale Id 1378595',1500.00,0.00,0.00,2.50,212.50,'2021-12-21 14:04:27','',''),(2337729,'1','140','773',331,'Retail Sale Id 1378612',1002.00,0.00,0.00,1.67,141.95,'2021-12-21 14:06:53','',''),(2337746,'1','140','773',331,'Retail Sale Id 1378627',1200.00,0.00,0.00,2.00,170.00,'2021-12-21 14:08:40','',''),(2337795,'1','140','773',331,'Retail Sale Id 1378680',1200.00,0.00,0.00,2.00,170.00,'2021-12-21 14:14:05','',''),(2338010,'1','140','773',331,'Retail Sale Id 1378828',600.00,0.00,0.00,1.00,85.00,'2021-12-21 14:28:48','',''),(2338079,'1','140','773',331,'Retail Sale Id 1378890',1200.00,0.00,0.00,2.00,170.00,'2021-12-21 14:34:35','',''),(2338108,'1','140','773',331,'Retail Sale Id 1378926',1800.00,0.00,0.00,3.00,255.00,'2021-12-21 14:37:02','',''),(2338160,'1','140','773',331,'Retail Sale Id 1378982',1002.00,0.00,0.00,1.67,141.95,'2021-12-21 14:42:48','',''),(2338180,'1','140','773',331,'Retail Sale Id 1379005',2400.00,0.00,0.00,4.00,340.00,'2021-12-21 14:44:37','',''),(2338239,'1','140','773',331,'Retail Sale Id 1379057',1800.00,0.00,0.00,3.00,255.00,'2021-12-21 14:49:43','',''),(2338253,'1','140','773',331,'Retail Sale Id 1379075',1200.00,0.00,0.00,2.00,170.00,'2021-12-21 14:51:21','',''),(2338455,'1','140','773',331,'Retail Sale Id 1379230',1200.00,0.00,0.00,2.00,170.00,'2021-12-21 15:05:49','',''),(2338598,'1','140','773',331,'Retail Sale Id 1379341',3600.00,0.00,0.00,6.00,510.00,'2021-12-21 15:16:54','',''),(2338652,'1','140','773',331,'Retail Sale Id 1379397',12190.00,0.00,0.00,23.00,345.00,'2021-12-21 15:23:06','',''),(2338694,'1','140','773',331,'Retail Sale Id 1379442',3600.00,0.00,0.00,6.00,510.00,'2021-12-21 15:27:41','',''),(2338744,'1','140','773',331,'Retail Sale Id 1379493',1800.00,0.00,0.00,3.00,255.00,'2021-12-21 15:31:46','',''),(2338774,'1','140','773',331,'Retail Sale Id 1379514',1200.00,0.00,0.00,2.00,170.00,'2021-12-21 15:34:14','',''),(2338790,'1','140','773',331,'Retail Sale Id 1379529',600.00,0.00,0.00,1.00,85.00,'2021-12-21 15:34:58','',''),(2338832,'1','140','773',331,'Retail Sale Id 1379557',17490.00,0.00,0.00,33.00,495.00,'2021-12-21 15:37:02','',''),(2338947,'1','140','773',331,'Retail Sale Id 1379615',1800.00,0.00,0.00,3.00,255.00,'2021-12-21 15:41:24','',''),(2339042,'1','140','773',331,'Retail Sale Id 1379709',13250.00,0.00,0.00,25.00,375.00,'2021-12-21 15:48:13','',''),(2339069,'1','140','773',331,'Retail Sale Id 1379734',600.00,0.00,0.00,1.00,85.00,'2021-12-21 15:50:11','',''),(2339090,'1','140','773',331,'Retail Sale Id 1379755',1200.00,0.00,0.00,2.00,170.00,'2021-12-21 15:52:04','',''),(2339117,'1','140','773',331,'Retail Sale Id 1379783',1800.00,0.00,0.00,3.00,255.00,'2021-12-21 15:53:52','',''),(2339145,'1','140','773',331,'Retail Sale Id 1379802',2502.00,0.00,0.00,4.17,354.45,'2021-12-21 15:55:42','',''),(2339191,'1','140','773',331,'Retail Sale Id 1379843',570447.00,0.00,0.00,1084.50,11929.50,'2021-12-21 15:58:41','',''),(2339221,'1','140','773',331,'Retail Sale Id 1379861',9600.00,0.00,0.00,16.00,1360.00,'2021-12-21 16:00:12','',''),(2339255,'1','140','773',331,'Retail Sale Id 1379887',1200.00,0.00,0.00,2.00,170.00,'2021-12-21 16:01:59','',''),(2339272,'1','140','773',331,'Retail Sale Id 1379905',1200.00,0.00,0.00,2.00,170.00,'2021-12-21 16:03:43','',''),(2339287,'1','140','773',331,'Retail Sale Id 1379924',1002.00,0.00,0.00,1.67,141.95,'2021-12-21 16:04:50','',''),(2339301,'1','140','773',331,'Retail Sale Id 1379939',1800.00,0.00,0.00,3.00,255.00,'2021-12-21 16:05:51','',''),(2339406,'1','140','773',331,'Retail Sale Id 1380022',26500.00,0.00,0.00,50.00,750.00,'2021-12-21 16:12:19','',''),(2339447,'1','140','773',331,'Retail Sale Id 1380063',3600.00,0.00,0.00,6.00,510.00,'2021-12-21 16:15:46','',''),(2339480,'1','140','773',331,'Retail Sale Id 1380096',31800.00,0.00,0.00,60.00,900.00,'2021-12-21 16:18:29','',''),(2339519,'1','140','773',331,'Retail Sale Id 1380138',12720.00,0.00,0.00,24.00,360.00,'2021-12-21 16:21:35','',''),(2339543,'1','140','773',331,'Retail Sale Id 1380159',1200.00,0.00,0.00,2.00,170.00,'2021-12-21 16:23:25','',''),(2339567,'1','140','773',331,'Retail Sale Id 1380183',26500.00,0.00,0.00,50.00,750.00,'2021-12-21 16:26:18','',''),(2339612,'1','140','773',331,'Retail Sale Id 1380221',3000.00,0.00,0.00,5.00,425.00,'2021-12-21 16:29:41','',''),(2339663,'1','140','773',331,'Retail Sale Id 1380259',3600.00,0.00,0.00,6.00,510.00,'2021-12-21 16:32:54','',''),(2339685,'1','140','773',331,'Retail Sale Id 1380285',3000.00,0.00,0.00,5.00,425.00,'2021-12-21 16:34:33','',''),(2339698,'1','140','773',331,'Retail Sale Id 1380297',9600.00,0.00,0.00,16.00,1360.00,'2021-12-21 16:35:57','',''),(2339713,'1','140','773',331,'Retail Sale Id 1380310',1998.00,0.00,0.00,3.33,283.05,'2021-12-21 16:37:22','',''),(2339730,'1','140','773',331,'Retail Sale Id 1380327',1800.00,0.00,0.00,3.00,255.00,'2021-12-21 16:39:08','',''),(2339805,'1','140','773',331,'Retail Sale Id 1380404',21200.00,0.00,0.00,40.00,600.00,'2021-12-21 16:45:18','',''),(2339895,'1','140','773',331,'Retail Sale Id 1380486',1800.00,0.00,0.00,3.00,255.00,'2021-12-21 16:53:18','',''),(2339920,'1','140','773',331,'Retail Sale Id 1380514',1800.00,0.00,0.00,3.00,255.00,'2021-12-21 16:55:21','',''),(2339970,'1','140','773',331,'Retail Sale Id 1380557',1200.00,0.00,0.00,2.00,170.00,'2021-12-21 16:59:57','',''),(2339995,'1','140','773',331,'Retail Sale Id 1380587',1800.00,0.00,0.00,3.00,255.00,'2021-12-21 17:02:23','',''),(2340182,'1','140','773',331,'Retail Sale Id 1380757',2120.00,0.00,0.00,4.00,60.00,'2021-12-21 17:23:23','',''),(2341365,'1','140','773',331,'Retail Sale Id 1381318',12720.00,0.00,0.00,24.00,360.00,'2021-12-22 06:36:57','',''),(2341372,'1','140','773',331,'Retail Sale Id 1381323',63600.00,0.00,0.00,120.00,1800.00,'2021-12-22 06:38:02','',''),(2341411,'1','140','773',331,'Retail Sale Id 1381334',169600.00,0.00,0.00,320.00,4800.00,'2021-12-22 06:42:08','',''),(2341429,'1','140','773',331,'Retail Sale Id 1381373',26500.00,0.00,0.00,50.00,750.00,'2021-12-22 06:43:44','',''),(2341442,'1','140','773',331,'Retail Sale Id 1381377',3600.00,0.00,0.00,6.00,510.00,'2021-12-22 06:44:27','',''),(2341476,'1','140','773',331,'Retail Sale Id 1381397',15900.00,0.00,0.00,30.00,450.00,'2021-12-22 06:46:44','',''),(2341499,'1','140','773',331,'Retail Sale Id 1381411',7200.00,0.00,0.00,12.00,1020.00,'2021-12-22 06:48:05','',''),(2341511,'1','140','773',331,'Retail Sale Id 1381421',3000.00,0.00,0.00,5.00,425.00,'2021-12-22 06:49:09','',''),(2341524,'1','140','773',331,'Retail Sale Id 1381431',31800.00,0.00,0.00,60.00,900.00,'2021-12-22 06:50:23','',''),(2341620,'1','140','773',331,'Retail Sale Id 1381511',7500.00,0.00,0.00,12.50,1062.50,'2021-12-22 06:58:25','',''),(2341630,'1','140','773',331,'Retail Sale Id 1381523',1200.00,0.00,0.00,2.00,170.00,'2021-12-22 06:59:26','',''),(2341718,'1','140','773',331,'Retail Sale Id 1381613',12720.00,0.00,0.00,24.00,360.00,'2021-12-22 07:08:17','',''),(2341797,'1','140','773',331,'Retail Sale Id 1381683',1200.00,0.00,0.00,2.00,170.00,'2021-12-22 07:13:44','',''),(2341818,'1','140','773',331,'Retail Sale Id 1381699',3000.00,0.00,0.00,5.00,425.00,'2021-12-22 07:15:17','',''),(2341863,'1','140','773',331,'Retail Sale Id 1381743',95400.00,0.00,0.00,180.00,2700.00,'2021-12-22 07:19:40','',''),(2341934,'1','140','773',331,'Retail Sale Id 1381791',7500.00,0.00,0.00,12.50,1062.50,'2021-12-22 07:24:01','',''),(2341981,'1','140','773',331,'Retail Sale Id 1381836',231080.00,0.00,0.00,436.00,6540.00,'2021-12-22 07:29:44','',''),(2342031,'1','140','773',331,'Retail Sale Id 1381874',1200.00,0.00,0.00,2.00,170.00,'2021-12-22 07:33:33','',''),(2342047,'1','140','773',331,'Retail Sale Id 1381888',12720.00,0.00,0.00,24.00,360.00,'2021-12-22 07:34:56','',''),(2342057,'1','140','773',331,'Retail Sale Id 1381896',3600.00,0.00,0.00,6.00,510.00,'2021-12-22 07:36:11','',''),(2342067,'1','140','773',331,'Retail Sale Id 1381907',1200.00,0.00,0.00,2.00,170.00,'2021-12-22 07:37:11','',''),(2342097,'1','140','773',331,'Retail Sale Id 1381923',1800.00,0.00,0.00,3.00,255.00,'2021-12-22 07:38:21','',''),(2342297,'1','140','773',331,'Retail Sale Id 1382068',3000.00,0.00,0.00,5.00,425.00,'2021-12-22 07:51:05','',''),(2342607,'1','140','773',331,'Retail Sale Id 1382321',1200.00,0.00,0.00,2.00,170.00,'2021-12-22 08:10:36','',''),(2342636,'1','140','773',331,'Retail Sale Id 1382335',12190.00,0.00,0.00,23.00,345.00,'2021-12-22 08:11:50','',''),(2342666,'1','140','773',331,'Retail Sale Id 1382362',600.00,0.00,0.00,1.00,85.00,'2021-12-22 08:14:08','',''),(2342680,'1','140','773',331,'Retail Sale Id 1382377',26500.00,0.00,0.00,50.00,750.00,'2021-12-22 08:15:13','',''),(2342755,'1','140','773',331,'Retail Sale Id 1382453',600.00,0.00,0.00,1.00,85.00,'2021-12-22 08:22:07','',''),(2342810,'1','140','773',331,'Retail Sale Id 1382497',1200.00,0.00,0.00,2.00,170.00,'2021-12-22 08:25:45','',''),(2342944,'1','140','773',331,'Retail Sale Id 1382577',3600.00,0.00,0.00,6.00,510.00,'2021-12-22 08:31:11','',''),(2342980,'1','140','773',331,'Retail Sale Id 1382608',64925.00,0.00,0.00,122.50,1837.50,'2021-12-22 08:33:54','',''),(2343170,'1','140','773',331,'Retail Sale Id 1382780',1800.00,0.00,0.00,3.00,255.00,'2021-12-22 08:51:52','',''),(2343213,'1','140','773',331,'Retail Sale Id 1382820',26500.00,0.00,0.00,50.00,750.00,'2021-12-22 08:55:40','',''),(2343248,'1','140','773',331,'Retail Sale Id 1382854',1302.00,0.00,0.00,2.17,184.45,'2021-12-22 08:59:23','',''),(2343268,'1','140','773',331,'Retail Sale Id 1382871',5400.00,0.00,0.00,9.00,765.00,'2021-12-22 09:01:10','',''),(2343298,'1','140','773',331,'Retail Sale Id 1382899',7500.00,0.00,0.00,12.50,1062.50,'2021-12-22 09:03:38','',''),(2343342,'1','140','773',331,'Retail Sale Id 1382934',19875.00,0.00,0.00,37.50,562.50,'2021-12-22 09:07:49','',''),(2343369,'1','140','773',331,'Retail Sale Id 1383012',3600.00,0.00,0.00,6.00,510.00,'2021-12-22 09:10:33','',''),(2343444,'1','140','773',331,'Retail Sale Id 1383082',3600.00,0.00,0.00,6.00,510.00,'2021-12-22 09:16:49','',''),(2343454,'1','140','773',331,'Retail Sale Id 1383093',3600.00,0.00,0.00,6.00,510.00,'2021-12-22 09:18:02','',''),(2343509,'1','140','773',331,'Retail Sale Id 1383143',1200.00,0.00,0.00,2.00,170.00,'2021-12-22 09:24:14','',''),(2343607,'1','140','773',331,'Retail Sale Id 1383214',3000.00,0.00,0.00,5.00,425.00,'2021-12-22 09:31:54','',''),(2343689,'1','140','773',331,'Retail Sale Id 1383279',6600.00,0.00,0.00,11.00,935.00,'2021-12-22 09:37:16','',''),(2343716,'1','140','773',331,'Retail Sale Id 1383301',1800.00,0.00,0.00,3.00,255.00,'2021-12-22 09:39:39','',''),(2343740,'1','140','773',331,'Retail Sale Id 1383321',1800.00,0.00,0.00,3.00,255.00,'2021-12-22 09:42:35','',''),(2343777,'1','140','773',331,'Retail Sale Id 1383351',3600.00,0.00,0.00,6.00,510.00,'2021-12-22 09:45:55','',''),(2343841,'1','140','773',331,'Retail Sale Id 1383408',1800.00,0.00,0.00,3.00,255.00,'2021-12-22 09:51:43','',''),(2343907,'1','140','773',331,'Retail Sale Id 1383454',3600.00,0.00,0.00,6.00,510.00,'2021-12-22 09:56:01','',''),(2344057,'1','140','773',331,'Retail Sale Id 1383621',31800.00,0.00,0.00,60.00,900.00,'2021-12-22 10:10:23','',''),(2344180,'1','140','773',331,'Retail Sale Id 1383740',13250.00,0.00,0.00,25.00,375.00,'2021-12-22 10:22:58','',''),(2344196,'1','140','773',331,'Retail Sale Id 1383756',3600.00,0.00,0.00,6.00,510.00,'2021-12-22 10:24:50','',''),(2344333,'1','140','773',331,'Retail Sale Id 1383891',1800.00,0.00,0.00,3.00,255.00,'2021-12-22 10:38:23','',''),(2344357,'1','140','773',331,'Retail Sale Id 1383917',1200.00,0.00,0.00,2.00,170.00,'2021-12-22 10:40:52','',''),(2344369,'1','140','773',331,'Retail Sale Id 1383928',7500.00,0.00,0.00,12.50,1062.50,'2021-12-22 10:42:21','',''),(2344424,'1','140','773',331,'Retail Sale Id 1383985',7500.00,0.00,0.00,12.50,1062.50,'2021-12-22 10:47:45','',''),(2344457,'1','140','773',331,'Retail Sale Id 1384010',13250.00,0.00,0.00,25.00,375.00,'2021-12-22 10:50:54','',''),(2344550,'1','140','773',331,'Retail Sale Id 1384108',31800.00,0.00,0.00,60.00,900.00,'2021-12-22 10:58:37','',''),(2344824,'1','140','773',331,'Retail Sale Id 1384370',1800.00,0.00,0.00,3.00,255.00,'2021-12-22 11:25:18','',''),(2344867,'1','140','773',331,'Retail Sale Id 1384408',1200.00,0.00,0.00,2.00,170.00,'2021-12-22 11:29:38','',''),(2344884,'1','140','773',331,'Retail Sale Id 1384428',9540.00,0.00,0.00,18.00,270.00,'2021-12-22 11:31:12','',''),(2344942,'1','140','773',331,'Retail Sale Id 1384478',1800.00,0.00,0.00,3.00,255.00,'2021-12-22 11:36:17','',''),(2344993,'1','140','773',331,'Retail Sale Id 1384520',1200.00,0.00,0.00,2.00,170.00,'2021-12-22 11:40:39','',''),(2345012,'1','140','773',331,'Retail Sale Id 1384540',12190.00,0.00,0.00,23.00,345.00,'2021-12-22 11:43:10','',''),(2345034,'1','140','773',331,'Retail Sale Id 1384559',12190.00,0.00,0.00,23.00,345.00,'2021-12-22 11:45:06','',''),(2345148,'1','140','773',331,'Retail Sale Id 1384680',2400.00,0.00,0.00,4.00,340.00,'2021-12-22 11:57:10','',''),(2345157,'1','140','773',331,'Retail Sale Id 1384689',3000.00,0.00,0.00,5.00,425.00,'2021-12-22 11:58:16','',''),(2345197,'1','140','773',331,'Retail Sale Id 1384728',1200.00,0.00,0.00,2.00,170.00,'2021-12-22 12:02:44','',''),(2345268,'1','140','773',331,'Retail Sale Id 1384794',3000.00,0.00,0.00,5.00,425.00,'2021-12-22 12:10:07','',''),(2345295,'1','140','773',331,'Retail Sale Id 1384824',3600.00,0.00,0.00,6.00,510.00,'2021-12-22 12:13:31','',''),(2345323,'1','140','773',331,'Retail Sale Id 1384847',1800.00,0.00,0.00,3.00,255.00,'2021-12-22 12:16:05','',''),(2345353,'1','140','773',331,'Retail Sale Id 1384877',1200.00,0.00,0.00,2.00,170.00,'2021-12-22 12:20:00','',''),(2345513,'1','140','773',331,'Retail Sale Id 1385003',13250.00,0.00,0.00,25.00,375.00,'2021-12-22 12:35:20','',''),(2345532,'1','140','773',331,'Retail Sale Id 1385017',3600.00,0.00,0.00,6.00,510.00,'2021-12-22 12:37:52','',''),(2345546,'1','140','773',331,'Retail Sale Id 1385028',1200.00,0.00,0.00,2.00,170.00,'2021-12-22 12:40:14','',''),(2345573,'1','140','773',331,'Retail Sale Id 1385054',1200.00,0.00,0.00,2.00,170.00,'2021-12-22 12:42:39','',''),(2345755,'1','140','773',331,'Retail Sale Id 1385199',1200.00,0.00,0.00,2.00,170.00,'2021-12-22 12:59:34','',''),(2345831,'1','140','773',331,'Retail Sale Id 1385277',1800.00,0.00,0.00,3.00,255.00,'2021-12-22 13:08:51','',''),(2345952,'1','140','773',331,'Retail Sale Id 1385390',600.00,0.00,0.00,1.00,85.00,'2021-12-22 13:22:46','',''),(2346027,'1','140','773',331,'Retail Sale Id 1385459',1200.00,0.00,0.00,2.00,170.00,'2021-12-22 13:30:42','',''),(2346042,'1','140','773',331,'Retail Sale Id 1385474',1800.00,0.00,0.00,3.00,255.00,'2021-12-22 13:32:12','',''),(2346065,'1','140','773',331,'Retail Sale Id 1385495',600.00,0.00,0.00,1.00,85.00,'2021-12-22 13:34:41','',''),(2346190,'1','140','773',331,'Retail Sale Id 1385547',1500.00,0.00,0.00,2.50,212.50,'2021-12-22 13:41:55','',''),(2346206,'1','140','773',331,'Retail Sale Id 1385557',1998.00,0.00,0.00,3.33,283.05,'2021-12-22 13:43:21','',''),(2346349,'1','140','773',331,'Retail Sale Id 1385641',1200.00,0.00,0.00,2.00,170.00,'2021-12-22 13:53:20','',''),(2346685,'1','140','773',331,'Retail Sale Id 1385869',1200.00,0.00,0.00,2.00,170.00,'2021-12-22 14:23:33','',''),(2346705,'1','140','773',331,'Retail Sale Id 1385892',1800.00,0.00,0.00,3.00,255.00,'2021-12-22 14:26:01','',''),(2346761,'1','140','773',331,'Retail Sale Id 1385938',6000.00,0.00,0.00,10.00,850.00,'2021-12-22 14:32:35','',''),(2346790,'1','140','773',331,'Retail Sale Id 1385965',3600.00,0.00,0.00,6.00,510.00,'2021-12-22 14:36:00','',''),(2346883,'1','140','773',331,'Retail Sale Id 1386014',1800.00,0.00,0.00,3.00,255.00,'2021-12-22 14:43:01','',''),(2346906,'1','140','773',331,'Retail Sale Id 1386032',1800.00,0.00,0.00,3.00,255.00,'2021-12-22 14:45:57','',''),(2347146,'1','140','773',331,'Retail Sale Id 1386252',600.00,0.00,0.00,1.00,85.00,'2021-12-22 15:10:51','',''),(2347330,'1','140','773',331,'Retail Sale Id 1386377',7500.00,0.00,0.00,12.50,1062.50,'2021-12-22 15:25:35','',''),(2347363,'1','140','773',331,'Retail Sale Id 1386395',7800.00,0.00,0.00,13.00,1105.00,'2021-12-22 15:27:10','',''),(2347420,'1','140','773',331,'Retail Sale Id 1386425',1800.00,0.00,0.00,3.00,255.00,'2021-12-22 15:30:42','',''),(2347536,'1','140','773',331,'Retail Sale Id 1386524',1500.00,0.00,0.00,2.50,212.50,'2021-12-22 15:39:00','',''),(2347561,'1','140','773',331,'Retail Sale Id 1386549',1800.00,0.00,0.00,3.00,255.00,'2021-12-22 15:41:05','',''),(2347602,'1','140','773',331,'Retail Sale Id 1386589',2400.00,0.00,0.00,4.00,340.00,'2021-12-22 15:44:19','',''),(2347767,'1','140','773',331,'Retail Sale Id 1386719',3600.00,0.00,0.00,6.00,510.00,'2021-12-22 15:58:34','',''),(2347783,'1','140','773',331,'Retail Sale Id 1386738',12190.00,0.00,0.00,23.00,345.00,'2021-12-22 16:00:39','',''),(2347858,'1','140','773',331,'Retail Sale Id 1386785',3600.00,0.00,0.00,6.00,510.00,'2021-12-22 16:04:59','',''),(2347870,'1','140','773',331,'Retail Sale Id 1386796',7500.00,0.00,0.00,12.50,1062.50,'2021-12-22 16:06:40','',''),(2347886,'1','140','773',331,'Retail Sale Id 1386817',600.00,0.00,0.00,1.00,85.00,'2021-12-22 16:07:50','',''),(2347933,'1','140','773',331,'Retail Sale Id 1386860',6000.00,0.00,0.00,10.00,850.00,'2021-12-22 16:12:28','',''),(2347951,'1','140','773',331,'Retail Sale Id 1386878',1800.00,0.00,0.00,3.00,255.00,'2021-12-22 16:15:19','',''),(2347976,'1','140','773',331,'Retail Sale Id 1386914',600.00,0.00,0.00,1.00,85.00,'2021-12-22 16:18:33','',''),(2348004,'1','140','773',331,'Retail Sale Id 1386930',1800.00,0.00,0.00,3.00,255.00,'2021-12-22 16:20:33','',''),(2348097,'1','140','773',331,'Retail Sale Id 1386994',3600.00,0.00,0.00,6.00,510.00,'2021-12-22 16:29:34','',''),(2348197,'1','140','773',331,'Retail Sale Id 1387088',1800.00,0.00,0.00,3.00,255.00,'2021-12-22 16:41:16','',''),(2348216,'1','140','773',331,'Retail Sale Id 1387108',3000.00,0.00,0.00,5.00,425.00,'2021-12-22 16:43:34','',''),(2348250,'1','140','773',331,'Retail Sale Id 1387135',2400.00,0.00,0.00,4.00,340.00,'2021-12-22 16:46:37','',''),(2348281,'1','140','773',331,'Retail Sale Id 1387171',1382748.80,0.00,0.00,2628.80,28916.80,'2021-12-22 16:50:14','',''),(2348323,'1','140','773',331,'Retail Sale Id 1387210',1200.00,0.00,0.00,2.00,170.00,'2021-12-22 16:53:57','',''),(2348365,'1','140','773',331,'Retail Sale Id 1387252',3600.00,0.00,0.00,6.00,510.00,'2021-12-22 16:58:06','',''),(2348388,'1','140','773',331,'Retail Sale Id 1387274',3600.00,0.00,0.00,6.00,510.00,'2021-12-22 17:00:06','',''),(2348512,'1','140','773',331,'Retail Sale Id 1387387',52600.00,0.00,0.00,100.00,1100.00,'2021-12-22 17:12:52','',''),(2349537,'1','140','773',331,'Retail Sale Id 1387839',12720.00,0.00,0.00,24.00,360.00,'2021-12-23 06:11:30','',''),(2349720,'1','140','773',331,'Retail Sale Id 1387974',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 06:40:14','',''),(2349727,'1','140','773',331,'Retail Sale Id 1387982',3600.00,0.00,0.00,6.00,510.00,'2021-12-23 06:41:31','',''),(2349747,'1','140','773',331,'Retail Sale Id 1387999',3600.00,0.00,0.00,6.00,510.00,'2021-12-23 06:44:07','',''),(2349761,'1','140','773',331,'Retail Sale Id 1388011',4800.00,0.00,0.00,8.00,680.00,'2021-12-23 06:45:57','',''),(2349891,'1','140','773',331,'Retail Sale Id 1388119',12720.00,0.00,0.00,24.00,360.00,'2021-12-23 07:02:11','',''),(2349915,'1','140','773',331,'Retail Sale Id 1388146',6000.00,0.00,0.00,10.00,850.00,'2021-12-23 07:04:43','',''),(2349952,'1','140','773',331,'Retail Sale Id 1388180',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 07:08:28','',''),(2349962,'1','140','773',331,'Retail Sale Id 1388190',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 07:09:55','',''),(2350038,'1','140','773',331,'Retail Sale Id 1388247',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 07:16:14','',''),(2350060,'1','140','773',331,'Retail Sale Id 1388256',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 07:17:01','',''),(2350223,'1','140','773',331,'Retail Sale Id 1388332',44520.00,0.00,0.00,84.00,1260.00,'2021-12-23 07:24:39','',''),(2350295,'1','140','773',331,'Retail Sale Id 1388394',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 07:30:01','',''),(2350411,'1','140','773',331,'Retail Sale Id 1388471',600.00,0.00,0.00,1.00,85.00,'2021-12-23 07:37:45','',''),(2350590,'1','140','773',331,'Retail Sale Id 1388573',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 07:46:52','',''),(2350603,'1','140','773',331,'Retail Sale Id 1388582',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 07:47:48','',''),(2350695,'1','140','773',331,'Retail Sale Id 1388680',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 07:58:13','',''),(2350702,'1','140','773',331,'Retail Sale Id 1388686',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 07:58:58','',''),(2350712,'1','140','773',331,'Retail Sale Id 1388697',31800.00,0.00,0.00,60.00,900.00,'2021-12-23 08:00:41','',''),(2350781,'1','140','773',331,'Retail Sale Id 1388763',1590.00,0.00,0.00,3.00,45.00,'2021-12-23 08:07:27','',''),(2350806,'1','140','773',331,'Retail Sale Id 1388795',31800.00,0.00,0.00,60.00,900.00,'2021-12-23 08:11:04','',''),(2350828,'1','140','773',331,'Retail Sale Id 1388816',4002.00,0.00,0.00,6.67,566.95,'2021-12-23 08:13:01','',''),(2350970,'1','140','773',331,'Retail Sale Id 1388924',7500.00,0.00,0.00,12.50,1062.50,'2021-12-23 08:24:42','',''),(2351257,'1','140','773',331,'Retail Sale Id 1389177',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 08:51:46','',''),(2351338,'1','140','773',331,'Retail Sale Id 1389260',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 08:59:53','',''),(2351358,'1','140','773',331,'Retail Sale Id 1389285',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 09:02:15','',''),(2351556,'1','140','773',331,'Retail Sale Id 1389481',3600.00,0.00,0.00,6.00,510.00,'2021-12-23 09:23:46','',''),(2351724,'1','140','773',331,'Retail Sale Id 1389618',3600.00,0.00,0.00,6.00,510.00,'2021-12-23 09:35:50','',''),(2351805,'1','140','773',331,'Retail Sale Id 1389677',2400.00,0.00,0.00,4.00,340.00,'2021-12-23 09:39:47','',''),(2351831,'1','140','773',331,'Retail Sale Id 1389704',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 09:41:50','',''),(2352513,'1','140','773',331,'Retail Sale Id 1390257',8400.00,0.00,0.00,14.00,1190.00,'2021-12-23 10:33:34','',''),(2352572,'1','140','773',331,'Retail Sale Id 1390332',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 10:38:37','',''),(2352630,'1','140','773',331,'Retail Sale Id 1390394',3600.00,0.00,0.00,6.00,510.00,'2021-12-23 10:43:52','',''),(2352647,'1','140','773',331,'Retail Sale Id 1390405',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 10:45:03','',''),(2352823,'1','140','773',331,'Retail Sale Id 1390567',2400.00,0.00,0.00,4.00,340.00,'2021-12-23 11:00:17','',''),(2352919,'1','140','773',331,'Retail Sale Id 1390674',3600.00,0.00,0.00,6.00,510.00,'2021-12-23 11:10:09','',''),(2352997,'1','140','773',331,'Retail Sale Id 1390739',1500.00,0.00,0.00,2.50,212.50,'2021-12-23 11:16:10','',''),(2353037,'1','140','773',331,'Retail Sale Id 1390780',38690.00,0.00,0.00,73.00,1095.00,'2021-12-23 11:20:16','',''),(2353273,'1','140','773',331,'Retail Sale Id 1391019',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 11:44:20','',''),(2353320,'1','140','773',331,'Retail Sale Id 1391062',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 11:49:04','',''),(2353412,'1','140','773',331,'Retail Sale Id 1391148',11100.00,0.00,0.00,18.50,1572.50,'2021-12-23 11:58:31','',''),(2353470,'1','140','773',331,'Retail Sale Id 1391203',31800.00,0.00,0.00,60.00,900.00,'2021-12-23 12:04:14','',''),(2353600,'1','140','773',331,'Retail Sale Id 1391309',3600.00,0.00,0.00,6.00,510.00,'2021-12-23 12:14:39','',''),(2353771,'1','140','773',331,'Retail Sale Id 1391450',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 12:29:02','',''),(2353811,'1','140','773',331,'Retail Sale Id 1391480',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 12:32:17','',''),(2353830,'1','140','773',331,'Retail Sale Id 1391502',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 12:34:16','',''),(2353867,'1','140','773',331,'Retail Sale Id 1391533',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 12:36:46','',''),(2354012,'1','140','773',331,'Retail Sale Id 1391653',3000.00,0.00,0.00,5.00,425.00,'2021-12-23 12:48:40','',''),(2354048,'1','140','773',331,'Retail Sale Id 1391685',600.00,0.00,0.00,1.00,85.00,'2021-12-23 12:51:41','',''),(2354099,'1','140','773',331,'Retail Sale Id 1391733',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 12:55:09','',''),(2354136,'1','140','773',331,'Retail Sale Id 1391772',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 12:59:15','',''),(2354227,'1','140','773',331,'Retail Sale Id 1391852',12720.00,0.00,0.00,24.00,360.00,'2021-12-23 13:08:55','',''),(2354284,'1','140','773',331,'Retail Sale Id 1391916',2400.00,0.00,0.00,4.00,340.00,'2021-12-23 13:15:28','',''),(2354332,'1','140','773',331,'Retail Sale Id 1391968',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 13:19:52','',''),(2354346,'1','140','773',331,'Retail Sale Id 1391985',2400.00,0.00,0.00,4.00,340.00,'2021-12-23 13:20:58','',''),(2354532,'1','140','773',331,'Retail Sale Id 1392138',26500.00,0.00,0.00,50.00,750.00,'2021-12-23 13:35:49','',''),(2354637,'1','140','773',331,'Retail Sale Id 1392248',3600.00,0.00,0.00,6.00,510.00,'2021-12-23 13:45:33','',''),(2354703,'1','140','773',331,'Retail Sale Id 1392306',2400.00,0.00,0.00,4.00,340.00,'2021-12-23 13:49:46','',''),(2354735,'1','140','773',331,'Retail Sale Id 1392328',1998.00,0.00,0.00,3.33,283.05,'2021-12-23 13:51:54','',''),(2355004,'1','140','773',331,'Retail Sale Id 1392510',7200.00,0.00,0.00,12.00,1020.00,'2021-12-23 14:10:24','',''),(2355198,'1','140','773',331,'Retail Sale Id 1392593',4200.00,0.00,0.00,7.00,595.00,'2021-12-23 14:19:41','',''),(2355257,'1','140','773',331,'Retail Sale Id 1392611',25800.00,0.00,0.00,43.00,3655.00,'2021-12-23 14:22:27','',''),(2355273,'1','140','773',331,'Retail Sale Id 1392626',2400.00,0.00,0.00,4.00,340.00,'2021-12-23 14:23:48','',''),(2355306,'1','140','773',331,'Return of Retail Sale Id 1392611',0.00,25800.00,43.00,0.00,-3655.00,'2021-12-23 14:27:59','',''),(2355308,'1','140','773',331,'Retail Sale Id 1392662',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 14:28:07','',''),(2355387,'1','140','773',331,'Retail Sale Id 1392726',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 14:34:42','',''),(2355531,'1','140','773',331,'Retail Sale Id 1392858',3600.00,0.00,0.00,6.00,510.00,'2021-12-23 14:48:40','',''),(2355547,'1','140','773',331,'Retail Sale Id 1392867',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 14:49:38','',''),(2355552,'1','140','773',331,'Retail Sale Id 1392874',3600.00,0.00,0.00,6.00,510.00,'2021-12-23 14:50:20','',''),(2355616,'1','140','773',331,'Retail Sale Id 1392947',4998.00,0.00,0.00,8.33,708.05,'2021-12-23 14:58:15','',''),(2355641,'1','140','773',331,'Retail Sale Id 1392965',31800.00,0.00,0.00,60.00,900.00,'2021-12-23 15:00:38','',''),(2355645,'1','140','773',331,'Retail Sale Id 1392975',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 15:01:24','',''),(2355663,'1','140','773',331,'Retail Sale Id 1392995',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 15:03:08','',''),(2355895,'1','140','773',331,'Retail Sale Id 1393210',31800.00,0.00,0.00,60.00,900.00,'2021-12-23 15:22:34','',''),(2355907,'1','140','773',331,'Retail Sale Id 1393221',3600.00,0.00,0.00,6.00,510.00,'2021-12-23 15:23:56','',''),(2355931,'1','140','773',331,'Retail Sale Id 1393242',2400.00,0.00,0.00,4.00,340.00,'2021-12-23 15:25:56','',''),(2355958,'1','140','773',331,'Retail Sale Id 1393268',3000.00,0.00,0.00,5.00,425.00,'2021-12-23 15:28:26','',''),(2355974,'1','140','773',331,'Retail Sale Id 1393284',29150.00,0.00,0.00,55.00,825.00,'2021-12-23 15:30:10','',''),(2355998,'1','140','773',331,'Retail Sale Id 1393306',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 15:32:12','',''),(2356013,'1','140','773',331,'Retail Sale Id 1393321',600.00,0.00,0.00,1.00,85.00,'2021-12-23 15:33:31','',''),(2356026,'1','140','773',331,'Retail Sale Id 1393332',3600.00,0.00,0.00,6.00,510.00,'2021-12-23 15:34:40','',''),(2356042,'1','140','773',331,'Retail Sale Id 1393346',1500.00,0.00,0.00,2.50,212.50,'2021-12-23 15:36:13','',''),(2356093,'1','140','773',331,'Retail Sale Id 1393387',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 15:39:59','',''),(2356110,'1','140','773',331,'Retail Sale Id 1393401',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 15:41:15','',''),(2356142,'1','140','773',331,'Retail Sale Id 1393435',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 15:45:10','',''),(2356170,'1','140','773',331,'Retail Sale Id 1393466',2400.00,0.00,0.00,4.00,340.00,'2021-12-23 15:47:34','',''),(2356198,'1','140','773',331,'Retail Sale Id 1393492',3000.00,0.00,0.00,5.00,425.00,'2021-12-23 15:49:49','',''),(2356229,'1','140','773',331,'Retail Sale Id 1393523',1698.00,0.00,0.00,2.83,240.55,'2021-12-23 15:52:35','',''),(2356261,'1','140','773',331,'Retail Sale Id 1393560',600.00,0.00,0.00,1.00,85.00,'2021-12-23 15:55:13','',''),(2356271,'1','140','773',331,'Retail Sale Id 1393571',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 15:56:30','',''),(2356302,'1','140','773',331,'Retail Sale Id 1393598',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 15:59:42','',''),(2356314,'1','140','773',331,'Retail Sale Id 1393611',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 16:00:28','',''),(2356327,'1','140','773',331,'Retail Sale Id 1393625',3600.00,0.00,0.00,6.00,510.00,'2021-12-23 16:01:27','',''),(2356342,'1','140','773',331,'Retail Sale Id 1393639',1500.00,0.00,0.00,2.50,212.50,'2021-12-23 16:02:42','',''),(2356354,'1','140','773',331,'Retail Sale Id 1393650',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 16:03:40','',''),(2356381,'1','140','773',331,'Retail Sale Id 1393668',1998.00,0.00,0.00,3.33,283.05,'2021-12-23 16:05:32','',''),(2356403,'1','140','773',331,'Retail Sale Id 1393692',26500.00,0.00,0.00,50.00,750.00,'2021-12-23 16:07:31','',''),(2356421,'1','140','773',331,'Retail Sale Id 1393713',29150.00,0.00,0.00,55.00,825.00,'2021-12-23 16:08:54','',''),(2356443,'1','140','773',331,'Retail Sale Id 1393736',4800.00,0.00,0.00,8.00,680.00,'2021-12-23 16:11:08','',''),(2356459,'1','140','773',331,'Retail Sale Id 1393747',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 16:12:15','',''),(2356565,'1','140','773',331,'Retail Sale Id 1393862',900.00,0.00,0.00,1.50,127.50,'2021-12-23 16:21:06','',''),(2356588,'1','140','773',331,'Retail Sale Id 1393889',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 16:23:48','',''),(2356611,'1','140','773',331,'Retail Sale Id 1393908',2400.00,0.00,0.00,4.00,340.00,'2021-12-23 16:25:17','',''),(2356642,'1','140','773',331,'Retail Sale Id 1393936',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 16:27:31','',''),(2356695,'1','140','773',331,'Retail Sale Id 1393982',9010.00,0.00,0.00,17.00,255.00,'2021-12-23 16:31:52','',''),(2356716,'1','140','773',331,'Retail Sale Id 1394006',14840.00,0.00,0.00,28.00,420.00,'2021-12-23 16:34:07','',''),(2356780,'1','140','773',331,'Retail Sale Id 1394074',26500.00,0.00,0.00,50.00,750.00,'2021-12-23 16:41:25','',''),(2356796,'1','140','773',331,'Retail Sale Id 1394090',23850.00,0.00,0.00,45.00,675.00,'2021-12-23 16:42:33','',''),(2356838,'1','140','773',331,'Retail Sale Id 1394128',7500.00,0.00,0.00,12.50,1062.50,'2021-12-23 16:46:26','',''),(2356867,'1','140','773',331,'Retail Sale Id 1394160',3000.00,0.00,0.00,5.00,425.00,'2021-12-23 16:49:36','',''),(2356876,'1','140','773',331,'Retail Sale Id 1394168',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 16:50:47','',''),(2356892,'1','140','773',331,'Retail Sale Id 1394181',3600.00,0.00,0.00,6.00,510.00,'2021-12-23 16:51:56','',''),(2356916,'1','140','773',331,'Retail Sale Id 1394206',18550.00,0.00,0.00,35.00,525.00,'2021-12-23 16:53:50','',''),(2357084,'1','140','773',331,'Retail Sale Id 1394362',9600.00,0.00,0.00,16.00,1360.00,'2021-12-23 17:10:10','',''),(2357097,'1','140','773',331,'Retail Sale Id 1394373',1421990.00,0.00,0.00,2683.00,40245.00,'2021-12-23 17:11:16','',''),(2357195,'1','140','773',331,'Retail Sale Id 1394432',1410732.00,0.00,0.00,2682.00,29502.00,'2021-12-23 17:18:16','',''),(2357216,'1','140','773',331,'Retail Sale Id 1394443',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 17:19:14','',''),(2357229,'1','140','773',331,'Retail Sale Id 1394449',1800.00,0.00,0.00,3.00,255.00,'2021-12-23 17:20:04','',''),(2357262,'1','140','773',331,'Retail Sale Id 1394476',1200.00,0.00,0.00,2.00,170.00,'2021-12-23 17:24:08','',''),(2357408,'1','140','773',331,'Return of Retail Sale Id 1394373',0.00,1421990.00,2683.00,0.00,-40245.00,'2021-12-23 17:45:53','',''),(2358431,'1','140','773',331,'Retail Sale Id 1394996',26500.00,0.00,0.00,50.00,750.00,'2021-12-24 06:06:00','',''),(2358435,'1','140','773',331,'Retail Sale Id 1395001',33920.00,0.00,0.00,64.00,960.00,'2021-12-24 06:07:39','',''),(2358443,'1','140','773',331,'Retail Sale Id 1395008',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 06:11:07','',''),(2358474,'1','140','773',331,'Retail Sale Id 1395030',31800.00,0.00,0.00,60.00,900.00,'2021-12-24 06:17:09','',''),(2358535,'1','140','773',331,'Retail Sale Id 1395088',26500.00,0.00,0.00,50.00,750.00,'2021-12-24 06:26:36','',''),(2358711,'1','140','773',331,'Retail Sale Id 1395224',4998.00,0.00,0.00,8.33,708.05,'2021-12-24 06:47:21','',''),(2358720,'1','140','773',331,'Retail Sale Id 1395234',3000.00,0.00,0.00,5.00,425.00,'2021-12-24 06:48:57','',''),(2358736,'1','140','773',331,'Retail Sale Id 1395250',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 06:50:53','',''),(2358755,'1','140','773',331,'Retail Sale Id 1395265',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 06:52:44','',''),(2358769,'1','140','773',331,'Retail Sale Id 1395278',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 06:54:21','',''),(2358785,'1','140','773',331,'Retail Sale Id 1395295',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 06:55:47','',''),(2358804,'1','140','773',331,'Retail Sale Id 1395309',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 06:57:08','',''),(2358816,'1','140','773',331,'Retail Sale Id 1395318',3000.00,0.00,0.00,5.00,425.00,'2021-12-24 06:58:08','',''),(2358832,'1','140','773',331,'Retail Sale Id 1395336',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 07:00:20','',''),(2358850,'1','140','773',331,'Retail Sale Id 1395351',6600.00,0.00,0.00,11.00,935.00,'2021-12-24 07:01:33','',''),(2358956,'1','140','773',331,'Retail Sale Id 1395448',31800.00,0.00,0.00,60.00,900.00,'2021-12-24 07:11:10','',''),(2358975,'1','140','773',331,'Retail Sale Id 1395467',14310.00,0.00,0.00,27.00,405.00,'2021-12-24 07:13:14','',''),(2358987,'1','140','773',331,'Retail Sale Id 1395477',29150.00,0.00,0.00,55.00,825.00,'2021-12-24 07:14:34','',''),(2359011,'1','140','773',331,'Retail Sale Id 1395501',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 07:16:52','',''),(2359027,'1','140','773',331,'Retail Sale Id 1395518',3000.00,0.00,0.00,5.00,425.00,'2021-12-24 07:18:12','',''),(2359063,'1','140','773',331,'Retail Sale Id 1395540',7500.00,0.00,0.00,12.50,1062.50,'2021-12-24 07:20:14','',''),(2359088,'1','140','773',331,'Retail Sale Id 1395552',600.00,0.00,0.00,1.00,85.00,'2021-12-24 07:21:46','',''),(2359103,'1','140','773',331,'Retail Sale Id 1395567',3600.00,0.00,0.00,6.00,510.00,'2021-12-24 07:22:58','',''),(2359115,'1','140','773',331,'Retail Sale Id 1395577',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 07:24:22','',''),(2359132,'1','140','773',331,'Retail Sale Id 1395596',7500.00,0.00,0.00,12.50,1062.50,'2021-12-24 07:25:36','',''),(2359142,'1','140','773',331,'Retail Sale Id 1395608',3000.00,0.00,0.00,5.00,425.00,'2021-12-24 07:26:48','',''),(2359156,'1','140','773',331,'Retail Sale Id 1395619',2400.00,0.00,0.00,4.00,340.00,'2021-12-24 07:28:09','',''),(2359213,'1','140','773',331,'Retail Sale Id 1395668',7500.00,0.00,0.00,12.50,1062.50,'2021-12-24 07:33:12','',''),(2359232,'1','140','773',331,'Retail Sale Id 1395689',7500.00,0.00,0.00,12.50,1062.50,'2021-12-24 07:34:55','',''),(2359254,'1','140','773',331,'Retail Sale Id 1395711',3000.00,0.00,0.00,5.00,425.00,'2021-12-24 07:36:28','',''),(2359323,'1','140','773',331,'Retail Sale Id 1395776',10600.00,0.00,0.00,20.00,300.00,'2021-12-24 07:43:39','',''),(2359380,'1','140','773',331,'Retail Sale Id 1395836',3600.00,0.00,0.00,6.00,510.00,'2021-12-24 07:48:49','',''),(2359405,'1','140','773',331,'Retail Sale Id 1395855',30740.00,0.00,0.00,58.00,870.00,'2021-12-24 07:50:07','',''),(2359416,'1','140','773',331,'Retail Sale Id 1395871',7500.00,0.00,0.00,12.50,1062.50,'2021-12-24 07:50:58','',''),(2359455,'1','140','773',331,'Retail Sale Id 1395904',26500.00,0.00,0.00,50.00,750.00,'2021-12-24 07:54:24','',''),(2359492,'1','140','773',331,'Retail Sale Id 1395925',12720.00,0.00,0.00,24.00,360.00,'2021-12-24 07:56:19','',''),(2359530,'1','140','773',331,'Retail Sale Id 1395965',29680.00,0.00,0.00,56.00,840.00,'2021-12-24 07:59:49','',''),(2359629,'1','140','773',331,'Retail Sale Id 1396050',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 08:07:02','',''),(2359655,'1','140','773',331,'Retail Sale Id 1396064',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 08:08:47','',''),(2359695,'1','140','773',331,'Retail Sale Id 1396097',3000.00,0.00,0.00,5.00,425.00,'2021-12-24 08:11:11','',''),(2359839,'1','140','773',331,'Retail Sale Id 1396193',600.00,0.00,0.00,1.00,85.00,'2021-12-24 08:21:22','',''),(2359859,'1','140','773',331,'Retail Sale Id 1396216',12720.00,0.00,0.00,24.00,360.00,'2021-12-24 08:23:34','',''),(2359901,'1','140','773',331,'Retail Sale Id 1396261',26500.00,0.00,0.00,50.00,750.00,'2021-12-24 08:27:20','',''),(2359945,'1','140','773',331,'Retail Sale Id 1396304',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 08:31:04','',''),(2360032,'1','140','773',331,'Retail Sale Id 1396365',45845.00,0.00,0.00,86.50,1297.50,'2021-12-24 08:36:11','',''),(2360089,'1','140','773',331,'Retail Sale Id 1396407',7500.00,0.00,0.00,12.50,1062.50,'2021-12-24 08:39:47','',''),(2360170,'1','140','773',331,'Retail Sale Id 1396496',7500.00,0.00,0.00,12.50,1062.50,'2021-12-24 08:46:45','',''),(2360188,'1','140','773',331,'Retail Sale Id 1396516',2400.00,0.00,0.00,4.00,340.00,'2021-12-24 08:47:53','',''),(2360229,'1','140','773',331,'Retail Sale Id 1396565',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 08:51:34','',''),(2360262,'1','140','773',331,'Retail Sale Id 1396593',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 08:53:23','',''),(2360324,'1','140','773',331,'Retail Sale Id 1396639',3600.00,0.00,0.00,6.00,510.00,'2021-12-24 08:56:30','',''),(2360342,'1','140','773',331,'Retail Sale Id 1396652',3000.00,0.00,0.00,5.00,425.00,'2021-12-24 08:57:45','',''),(2360375,'1','140','773',331,'Retail Sale Id 1396682',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 08:59:36','',''),(2360419,'1','140','773',331,'Retail Sale Id 1396718',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 09:02:16','',''),(2360440,'1','140','773',331,'Retail Sale Id 1396733',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 09:03:26','',''),(2360451,'1','140','773',331,'Retail Sale Id 1396744',3000.00,0.00,0.00,5.00,425.00,'2021-12-24 09:04:29','',''),(2360470,'1','140','773',331,'Retail Sale Id 1396762',3000.00,0.00,0.00,5.00,425.00,'2021-12-24 09:05:58','',''),(2360482,'1','140','773',331,'Retail Sale Id 1396773',3600.00,0.00,0.00,6.00,510.00,'2021-12-24 09:07:13','',''),(2360490,'1','140','773',331,'Retail Sale Id 1396782',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 09:08:20','',''),(2360586,'1','140','773',331,'Retail Sale Id 1396862',18550.00,0.00,0.00,35.00,525.00,'2021-12-24 09:16:35','',''),(2360710,'1','140','773',331,'Retail Sale Id 1396960',2400.00,0.00,0.00,4.00,340.00,'2021-12-24 09:25:23','',''),(2360733,'1','140','773',331,'Retail Sale Id 1396980',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 09:26:47','',''),(2360751,'1','140','773',331,'Retail Sale Id 1396997',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 09:28:20','',''),(2360776,'1','140','773',331,'Retail Sale Id 1397027',3600.00,0.00,0.00,6.00,510.00,'2021-12-24 09:30:22','',''),(2360820,'1','140','773',331,'Retail Sale Id 1397060',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 09:32:57','',''),(2360840,'1','140','773',331,'Retail Sale Id 1397079',6360.00,0.00,0.00,12.00,180.00,'2021-12-24 09:34:23','',''),(2360863,'1','140','773',331,'Retail Sale Id 1397106',600.00,0.00,0.00,1.00,85.00,'2021-12-24 09:35:51','',''),(2360877,'1','140','773',331,'Retail Sale Id 1397120',2400.00,0.00,0.00,4.00,340.00,'2021-12-24 09:36:55','',''),(2360915,'1','140','773',331,'Retail Sale Id 1397159',2400.00,0.00,0.00,4.00,340.00,'2021-12-24 09:39:16','',''),(2360929,'1','140','773',331,'Retail Sale Id 1397179',41340.00,0.00,0.00,78.00,1170.00,'2021-12-24 09:40:33','',''),(2360964,'1','140','773',331,'Retail Sale Id 1397192',31800.00,0.00,0.00,60.00,900.00,'2021-12-24 09:43:06','',''),(2361006,'1','140','773',331,'Retail Sale Id 1397228',50880.00,0.00,0.00,96.00,1440.00,'2021-12-24 09:45:15','',''),(2361140,'1','140','773',331,'Retail Sale Id 1397300',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 09:51:15','',''),(2361171,'1','140','773',331,'Retail Sale Id 1397325',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 09:53:02','',''),(2361208,'1','140','773',331,'Retail Sale Id 1397358',600.00,0.00,0.00,1.00,85.00,'2021-12-24 09:55:32','',''),(2361231,'1','140','773',331,'Retail Sale Id 1397385',3000.00,0.00,0.00,5.00,425.00,'2021-12-24 09:57:13','',''),(2361304,'1','140','773',331,'Retail Sale Id 1397448',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 10:01:26','',''),(2361371,'1','140','773',331,'Retail Sale Id 1397510',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 10:06:18','',''),(2361409,'1','140','773',331,'Retail Sale Id 1397547',3600.00,0.00,0.00,6.00,510.00,'2021-12-24 10:09:40','',''),(2361428,'1','140','773',331,'Retail Sale Id 1397572',3000.00,0.00,0.00,5.00,425.00,'2021-12-24 10:11:17','',''),(2361449,'1','140','773',331,'Retail Sale Id 1397589',26500.00,0.00,0.00,50.00,750.00,'2021-12-24 10:12:49','',''),(2361575,'1','140','773',331,'Retail Sale Id 1397707',3000.00,0.00,0.00,5.00,425.00,'2021-12-24 10:22:20','',''),(2361594,'1','140','773',331,'Retail Sale Id 1397726',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 10:23:48','',''),(2361671,'1','140','773',331,'Retail Sale Id 1397805',3600.00,0.00,0.00,6.00,510.00,'2021-12-24 10:30:03','',''),(2361712,'1','140','773',331,'Retail Sale Id 1397842',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 10:33:30','',''),(2361733,'1','140','773',331,'Retail Sale Id 1397865',6000.00,0.00,0.00,10.00,850.00,'2021-12-24 10:35:56','',''),(2361874,'1','140','773',331,'Retail Sale Id 1398024',1500.00,0.00,0.00,2.50,212.50,'2021-12-24 10:48:33','',''),(2361903,'1','140','773',331,'Retail Sale Id 1398040',1500.00,0.00,0.00,2.50,212.50,'2021-12-24 10:51:20','',''),(2361920,'1','140','773',331,'Retail Sale Id 1398070',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 10:53:05','',''),(2361935,'1','140','773',331,'Retail Sale Id 1398089',8480.00,0.00,0.00,16.00,240.00,'2021-12-24 10:54:48','',''),(2361945,'1','140','773',331,'Retail Sale Id 1398101',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 10:55:52','',''),(2361983,'1','140','773',331,'Retail Sale Id 1398128',6000.00,0.00,0.00,10.00,850.00,'2021-12-24 10:59:40','',''),(2362114,'1','140','773',331,'Retail Sale Id 1398275',43990.00,0.00,0.00,83.00,1245.00,'2021-12-24 11:12:52','',''),(2362899,'1','140','773',331,'Retail Sale Id 1399018',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 12:27:20','',''),(2362931,'1','140','773',331,'Retail Sale Id 1399052',7500.00,0.00,0.00,12.50,1062.50,'2021-12-24 12:31:21','',''),(2362943,'1','140','773',331,'Retail Sale Id 1399063',26500.00,0.00,0.00,50.00,750.00,'2021-12-24 12:32:37','',''),(2362974,'1','140','773',331,'Retail Sale Id 1399091',7500.00,0.00,0.00,12.50,1062.50,'2021-12-24 12:35:27','',''),(2362990,'1','140','773',331,'Retail Sale Id 1399111',3000.00,0.00,0.00,5.00,425.00,'2021-12-24 12:36:56','',''),(2363009,'1','140','773',331,'Retail Sale Id 1399122',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 12:38:52','',''),(2363034,'1','140','773',331,'Retail Sale Id 1399151',43460.00,0.00,0.00,82.00,1230.00,'2021-12-24 12:41:53','',''),(2363053,'1','140','773',331,'Retail Sale Id 1399172',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 12:44:14','',''),(2363081,'1','140','773',331,'Retail Sale Id 1399199',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 12:47:07','',''),(2363094,'1','140','773',331,'Retail Sale Id 1399212',31800.00,0.00,0.00,60.00,900.00,'2021-12-24 12:48:29','',''),(2363121,'1','140','773',331,'Retail Sale Id 1399243',1590.00,0.00,0.00,3.00,45.00,'2021-12-24 12:51:15','',''),(2363128,'1','140','773',331,'Retail Sale Id 1399248',3600.00,0.00,0.00,6.00,510.00,'2021-12-24 12:52:15','',''),(2363143,'1','140','773',331,'Retail Sale Id 1399262',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 12:54:21','',''),(2363165,'1','140','773',331,'Retail Sale Id 1399285',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 12:56:25','',''),(2363288,'1','140','773',331,'Retail Sale Id 1399397',7500.00,0.00,0.00,12.50,1062.50,'2021-12-24 13:08:24','',''),(2363309,'1','140','773',331,'Retail Sale Id 1399424',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 13:11:02','',''),(2363519,'1','140','773',331,'Retail Sale Id 1399612',3000.00,0.00,0.00,5.00,425.00,'2021-12-24 13:30:26','',''),(2363538,'1','140','773',331,'Retail Sale Id 1399628',3600.00,0.00,0.00,6.00,510.00,'2021-12-24 13:31:52','',''),(2363555,'1','140','773',331,'Retail Sale Id 1399642',600.00,0.00,0.00,1.00,85.00,'2021-12-24 13:33:03','',''),(2363579,'1','140','773',331,'Retail Sale Id 1399659',7500.00,0.00,0.00,12.50,1062.50,'2021-12-24 13:35:21','',''),(2363755,'1','140','773',331,'Retail Sale Id 1399778',3600.00,0.00,0.00,6.00,510.00,'2021-12-24 13:45:35','',''),(2363824,'1','140','773',331,'Retail Sale Id 1399817',7500.00,0.00,0.00,12.50,1062.50,'2021-12-24 13:49:35','',''),(2364011,'1','140','773',331,'Retail Sale Id 1399969',3000.00,0.00,0.00,5.00,425.00,'2021-12-24 14:02:27','',''),(2364081,'1','140','773',331,'Retail Sale Id 1400016',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 14:06:31','',''),(2364105,'1','140','773',331,'Retail Sale Id 1400041',4200.00,0.00,0.00,7.00,595.00,'2021-12-24 14:08:05','',''),(2364194,'1','140','773',331,'Retail Sale Id 1400119',5400.00,0.00,0.00,9.00,765.00,'2021-12-24 14:14:53','',''),(2364281,'1','140','773',331,'Retail Sale Id 1400177',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 14:20:26','',''),(2364306,'1','140','773',331,'Retail Sale Id 1400205',1998.00,0.00,0.00,3.33,283.05,'2021-12-24 14:22:17','',''),(2364329,'1','140','773',331,'Retail Sale Id 1400222',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 14:23:44','',''),(2364335,'1','140','773',331,'Retail Sale Id 1400234',1998.00,0.00,0.00,3.33,283.05,'2021-12-24 14:24:47','',''),(2364351,'1','140','773',331,'Retail Sale Id 1400245',2400.00,0.00,0.00,4.00,340.00,'2021-12-24 14:25:55','',''),(2364400,'1','140','773',331,'Retail Sale Id 1400298',2400.00,0.00,0.00,4.00,340.00,'2021-12-24 14:31:12','',''),(2364565,'1','140','773',331,'Retail Sale Id 1400419',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 14:44:09','',''),(2364666,'1','140','773',331,'Retail Sale Id 1400483',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 14:50:05','',''),(2364732,'1','140','773',331,'Retail Sale Id 1400515',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 14:53:07','',''),(2364906,'1','140','773',331,'Retail Sale Id 1400632',3600.00,0.00,0.00,6.00,510.00,'2021-12-24 15:03:36','',''),(2364932,'1','140','773',331,'Retail Sale Id 1400660',2400.00,0.00,0.00,4.00,340.00,'2021-12-24 15:05:53','',''),(2364950,'1','140','773',331,'Retail Sale Id 1400678',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 15:07:33','',''),(2364969,'1','140','773',331,'Retail Sale Id 1400698',3600.00,0.00,0.00,6.00,510.00,'2021-12-24 15:10:00','',''),(2364982,'1','140','773',331,'Retail Sale Id 1400712',3600.00,0.00,0.00,6.00,510.00,'2021-12-24 15:11:39','',''),(2365035,'1','140','773',331,'Retail Sale Id 1400750',26500.00,0.00,0.00,50.00,750.00,'2021-12-24 15:14:56','',''),(2365061,'1','140','773',331,'Retail Sale Id 1400764',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 15:16:19','',''),(2365101,'1','140','773',331,'Retail Sale Id 1400789',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 15:18:29','',''),(2365147,'1','140','773',331,'Retail Sale Id 1400825',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 15:21:23','',''),(2365191,'1','140','773',331,'Retail Sale Id 1400868',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 15:25:17','',''),(2365207,'1','140','773',331,'Retail Sale Id 1400887',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 15:26:52','',''),(2365217,'1','140','773',331,'Retail Sale Id 1400897',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 15:27:46','',''),(2365237,'1','140','773',331,'Retail Sale Id 1400918',3000.00,0.00,0.00,5.00,425.00,'2021-12-24 15:29:05','',''),(2365249,'1','140','773',331,'Retail Sale Id 1400928',31800.00,0.00,0.00,60.00,900.00,'2021-12-24 15:30:15','',''),(2365260,'1','140','773',331,'Retail Sale Id 1400941',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 15:31:43','',''),(2365279,'1','140','773',331,'Retail Sale Id 1400959',3000.00,0.00,0.00,5.00,425.00,'2021-12-24 15:33:14','',''),(2365305,'1','140','773',331,'Retail Sale Id 1400983',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 15:35:06','',''),(2365365,'1','140','773',331,'Retail Sale Id 1401048',31800.00,0.00,0.00,60.00,900.00,'2021-12-24 15:40:43','',''),(2365385,'1','140','773',331,'Retail Sale Id 1401079',600.00,0.00,0.00,1.00,85.00,'2021-12-24 15:42:18','',''),(2365477,'1','140','773',331,'Retail Sale Id 1401180',26500.00,0.00,0.00,50.00,750.00,'2021-12-24 15:50:33','',''),(2365519,'1','140','773',331,'Retail Sale Id 1401207',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 15:53:46','',''),(2365711,'1','140','773',331,'Retail Sale Id 1401344',3600.00,0.00,0.00,6.00,510.00,'2021-12-24 16:07:43','',''),(2365782,'1','140','773',331,'Retail Sale Id 1401373',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 16:09:43','',''),(2365798,'1','140','773',331,'Retail Sale Id 1401384',3600.00,0.00,0.00,6.00,510.00,'2021-12-24 16:10:57','',''),(2365888,'1','140','773',331,'Retail Sale Id 1401446',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 16:15:43','',''),(2365900,'1','140','773',331,'Retail Sale Id 1401462',23850.00,0.00,0.00,45.00,675.00,'2021-12-24 16:16:37','',''),(2365918,'1','140','773',331,'Retail Sale Id 1401480',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 16:18:17','',''),(2365932,'1','140','773',331,'Retail Sale Id 1401495',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 16:19:36','',''),(2365954,'1','140','773',331,'Retail Sale Id 1401516',3600.00,0.00,0.00,6.00,510.00,'2021-12-24 16:21:27','',''),(2366064,'1','140','773',331,'Retail Sale Id 1401628',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 16:30:34','',''),(2366101,'1','140','773',331,'Retail Sale Id 1401662',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 16:33:07','',''),(2366158,'1','140','773',331,'Retail Sale Id 1401712',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 16:36:51','',''),(2366230,'1','140','773',331,'Retail Sale Id 1401791',2400.00,0.00,0.00,4.00,340.00,'2021-12-24 16:42:23','',''),(2366264,'1','140','773',331,'Retail Sale Id 1401811',12190.00,0.00,0.00,23.00,345.00,'2021-12-24 16:44:47','',''),(2366314,'1','140','773',331,'Retail Sale Id 1401857',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 16:47:25','',''),(2366342,'1','140','773',331,'Retail Sale Id 1401883',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 16:49:30','',''),(2366372,'1','140','773',331,'Retail Sale Id 1401912',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 16:52:03','',''),(2366397,'1','140','773',331,'Retail Sale Id 1401936',1998.00,0.00,0.00,3.33,283.05,'2021-12-24 16:54:18','',''),(2366406,'1','140','773',331,'Retail Sale Id 1401946',600.00,0.00,0.00,1.00,85.00,'2021-12-24 16:55:05','',''),(2366452,'1','140','773',331,'Retail Sale Id 1401988',7500.00,0.00,0.00,12.50,1062.50,'2021-12-24 16:57:44','',''),(2366469,'1','140','773',331,'Retail Sale Id 1402005',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 16:58:47','',''),(2366486,'1','140','773',331,'Retail Sale Id 1402021',900.00,0.00,0.00,1.50,127.50,'2021-12-24 16:59:36','',''),(2366535,'1','140','773',331,'Retail Sale Id 1402062',1800.00,0.00,0.00,3.00,255.00,'2021-12-24 17:03:11','',''),(2366637,'1','140','773',331,'Retail Sale Id 1402156',1200.00,0.00,0.00,2.00,170.00,'2021-12-24 17:08:58','',''),(2366654,'1','140','773',331,'Retail Sale Id 1402171',3000.00,0.00,0.00,5.00,425.00,'2021-12-24 17:10:27','',''),(2366917,'1','140','773',331,'Retail Sale Id 1402408',2460154.60,0.00,0.00,4677.10,51448.10,'2021-12-24 17:33:24','',''),(2368269,'1','140','773',331,'Retail Sale Id 1403143',43460.00,0.00,0.00,82.00,1230.00,'2021-12-25 06:32:26','',''),(2368281,'1','140','773',331,'Retail Sale Id 1403154',5300.00,0.00,0.00,10.00,150.00,'2021-12-25 06:34:33','',''),(2368331,'1','140','773',331,'Retail Sale Id 1403209',1998.00,0.00,0.00,3.33,283.05,'2021-12-25 06:42:51','',''),(2368352,'1','140','773',331,'Retail Sale Id 1403237',1200.00,0.00,0.00,2.00,170.00,'2021-12-25 06:45:37','',''),(2368362,'1','140','773',331,'Retail Sale Id 1403248',26500.00,0.00,0.00,50.00,750.00,'2021-12-25 06:46:45','',''),(2368466,'1','140','773',331,'Retail Sale Id 1403356',600.00,0.00,0.00,1.00,85.00,'2021-12-25 07:00:50','',''),(2368489,'1','140','773',331,'Retail Sale Id 1403380',1002.00,0.00,0.00,1.67,141.95,'2021-12-25 07:04:21','',''),(2368499,'1','140','773',331,'Retail Sale Id 1403389',6625.00,0.00,0.00,12.50,187.50,'2021-12-25 07:06:05','',''),(2368516,'1','140','773',331,'Retail Sale Id 1403406',7500.00,0.00,0.00,12.50,1062.50,'2021-12-25 07:08:09','',''),(2368523,'1','140','773',331,'Retail Sale Id 1403411',1200.00,0.00,0.00,2.00,170.00,'2021-12-25 07:09:10','',''),(2368534,'1','140','773',331,'Retail Sale Id 1403424',1200.00,0.00,0.00,2.00,170.00,'2021-12-25 07:10:34','',''),(2368590,'1','140','773',331,'Retail Sale Id 1403483',702.00,0.00,0.00,1.17,99.45,'2021-12-25 07:16:33','',''),(2368616,'1','140','773',331,'Retail Sale Id 1403497',25440.00,0.00,0.00,48.00,720.00,'2021-12-25 07:17:42','',''),(2368628,'1','140','773',331,'Retail Sale Id 1403511',1800.00,0.00,0.00,3.00,255.00,'2021-12-25 07:18:58','',''),(2368727,'1','140','773',331,'Retail Sale Id 1403592',1800.00,0.00,0.00,3.00,255.00,'2021-12-25 07:25:51','',''),(2368846,'1','140','773',331,'Retail Sale Id 1403694',12190.00,0.00,0.00,23.00,345.00,'2021-12-25 07:36:08','',''),(2368880,'1','140','773',331,'Retail Sale Id 1403718',1800.00,0.00,0.00,3.00,255.00,'2021-12-25 07:38:36','',''),(2368938,'1','140','773',331,'Retail Sale Id 1403782',600.00,0.00,0.00,1.00,85.00,'2021-12-25 07:45:39','',''),(2368970,'1','140','773',331,'Retail Sale Id 1403812',12720.00,0.00,0.00,24.00,360.00,'2021-12-25 07:49:19','',''),(2369005,'1','140','773',331,'Retail Sale Id 1403850',1200.00,0.00,0.00,2.00,170.00,'2021-12-25 07:52:53','',''),(2369022,'1','140','773',331,'Retail Sale Id 1403868',30740.00,0.00,0.00,58.00,870.00,'2021-12-25 07:54:23','',''),(2369094,'1','140','773',331,'Retail Sale Id 1403938',1200.00,0.00,0.00,2.00,170.00,'2021-12-25 08:00:44','',''),(2369199,'1','140','773',331,'Retail Sale Id 1404032',1800.00,0.00,0.00,3.00,255.00,'2021-12-25 08:09:39','',''),(2369237,'1','140','773',331,'Retail Sale Id 1404073',2400.00,0.00,0.00,4.00,340.00,'2021-12-25 08:12:01','',''),(2369254,'1','140','773',331,'Retail Sale Id 1404096',2400.00,0.00,0.00,4.00,340.00,'2021-12-25 08:13:35','',''),(2369320,'1','140','773',331,'Retail Sale Id 1404160',1800.00,0.00,0.00,3.00,255.00,'2021-12-25 08:19:20','',''),(2369343,'1','140','773',331,'Retail Sale Id 1404179',1800.00,0.00,0.00,3.00,255.00,'2021-12-25 08:20:57','',''),(2369463,'1','140','773',331,'Retail Sale Id 1404261',600.00,0.00,0.00,1.00,85.00,'2021-12-25 08:27:34','',''),(2369516,'1','140','773',331,'Retail Sale Id 1404306',1200.00,0.00,0.00,2.00,170.00,'2021-12-25 08:31:19','',''),(2369534,'1','140','773',331,'Retail Sale Id 1404326',1800.00,0.00,0.00,3.00,255.00,'2021-12-25 08:32:33','',''),(2369549,'1','140','773',331,'Retail Sale Id 1404341',600.00,0.00,0.00,1.00,85.00,'2021-12-25 08:34:04','',''),(2369608,'1','140','773',331,'Retail Sale Id 1404406',1998.00,0.00,0.00,3.33,283.05,'2021-12-25 08:39:31','',''),(2369716,'1','140','773',331,'Retail Sale Id 1404475',3000.00,0.00,0.00,5.00,425.00,'2021-12-25 08:45:59','',''),(2369735,'1','140','773',331,'Retail Sale Id 1404501',1200.00,0.00,0.00,2.00,170.00,'2021-12-25 08:48:19','',''),(2369749,'1','140','773',331,'Retail Sale Id 1404516',7500.00,0.00,0.00,12.50,1062.50,'2021-12-25 08:49:27','',''),(2369770,'1','140','773',331,'Retail Sale Id 1404538',1200.00,0.00,0.00,2.00,170.00,'2021-12-25 08:51:52','',''),(2369781,'1','140','773',331,'Retail Sale Id 1404552',2400.00,0.00,0.00,4.00,340.00,'2021-12-25 08:52:42','',''),(2369798,'1','140','773',331,'Retail Sale Id 1404572',3600.00,0.00,0.00,6.00,510.00,'2021-12-25 08:53:58','',''),(2369830,'1','140','773',331,'Retail Sale Id 1404597',1800.00,0.00,0.00,3.00,255.00,'2021-12-25 08:55:54','',''),(2369842,'1','140','773',331,'Retail Sale Id 1404611',900.00,0.00,0.00,1.50,127.50,'2021-12-25 08:56:56','',''),(2369859,'1','140','773',331,'Retail Sale Id 1404629',1200.00,0.00,0.00,2.00,170.00,'2021-12-25 08:58:02','',''),(2369867,'1','140','773',331,'Retail Sale Id 1404638',1200.00,0.00,0.00,2.00,170.00,'2021-12-25 08:58:50','',''),(2370009,'1','140','773',331,'Retail Sale Id 1404775',1800.00,0.00,0.00,3.00,255.00,'2021-12-25 09:12:11','',''),(2370301,'1','140','773',331,'Retail Sale Id 1404993',2400.00,0.00,0.00,4.00,340.00,'2021-12-25 09:33:18','',''),(2370390,'1','140','773',331,'Retail Sale Id 1405087',1800.00,0.00,0.00,3.00,255.00,'2021-12-25 09:41:57','',''),(2370548,'1','140','773',331,'Retail Sale Id 1405235',7500.00,0.00,0.00,12.50,1062.50,'2021-12-25 09:57:29','',''),(2370711,'1','140','773',331,'Retail Sale Id 1405365',1800.00,0.00,0.00,3.00,255.00,'2021-12-25 10:11:31','',''),(2370735,'1','140','773',331,'Retail Sale Id 1405386',26500.00,0.00,0.00,50.00,750.00,'2021-12-25 10:14:06','',''),(2370826,'1','140','773',331,'Retail Sale Id 1405476',1800.00,0.00,0.00,3.00,255.00,'2021-12-25 10:24:57','',''),(2370890,'1','140','773',331,'Retail Sale Id 1405528',2999.80,0.00,0.00,5.66,84.90,'2021-12-25 10:31:25','',''),(2371148,'1','140','773',331,'Retail Sale Id 1405797',1800.00,0.00,0.00,3.00,255.00,'2021-12-25 10:59:02','',''),(2371200,'1','140','773',331,'Retail Sale Id 1405851',600.00,0.00,0.00,1.00,85.00,'2021-12-25 11:04:07','',''),(2371243,'1','140','773',331,'Retail Sale Id 1405889',2120.00,0.00,0.00,4.00,60.00,'2021-12-25 11:06:51','',''),(2371301,'1','140','773',331,'Retail Sale Id 1405949',6625.00,0.00,0.00,12.50,187.50,'2021-12-25 11:11:58','',''),(2371334,'1','140','773',331,'Retail Sale Id 1405983',12720.00,0.00,0.00,24.00,360.00,'2021-12-25 11:15:28','',''),(2371365,'1','140','773',331,'Retail Sale Id 1406019',3000.00,0.00,0.00,5.00,425.00,'2021-12-25 11:18:30','',''),(2371379,'1','140','773',331,'Retail Sale Id 1406033',6625.00,0.00,0.00,12.50,187.50,'2021-12-25 11:19:46','',''),(2371400,'1','140','773',331,'Retail Sale Id 1406053',3000.00,0.00,0.00,5.00,425.00,'2021-12-25 11:21:25','',''),(2371462,'1','140','773',331,'Retail Sale Id 1406197',1800.00,0.00,0.00,3.00,255.00,'2021-12-25 11:30:13','',''),(2371480,'1','140','773',331,'Retail Sale Id 1406212',30210.00,0.00,0.00,57.00,855.00,'2021-12-25 11:31:58','',''),(2371612,'1','140','773',331,'Retail Sale Id 1406331',16960.00,0.00,0.00,32.00,480.00,'2021-12-25 11:46:34','',''),(2371625,'1','140','773',331,'Retail Sale Id 1406343',3960.00,0.00,0.00,6.60,561.00,'2021-12-25 11:48:17','',''),(2371660,'1','140','773',331,'Retail Sale Id 1406378',212000.00,0.00,0.00,400.00,6000.00,'2021-12-25 11:52:16','',''),(2371670,'1','140','773',331,'Retail Sale Id 1406387',716938.00,0.00,0.00,1363.00,14993.00,'2021-12-25 11:53:24','',''),(2371861,'1','140','773',331,'Return of Retail Sale Id 1406378',0.00,212000.00,400.00,0.00,-6000.00,'2021-12-25 12:18:27','',''),(2371874,'1','140','773',331,'Retail Sale Id 1406581',180200.00,0.00,0.00,340.00,5100.00,'2021-12-25 12:19:22','',''),(2371895,'1','140','773',331,'Return of Retail Sale Id 1404993',0.00,2400.00,4.00,0.00,-340.00,'2021-12-25 12:21:45','',''),(2371958,'1','140','773',331,'Retail Sale Id 1406673',4200.00,0.00,0.00,7.00,595.00,'2021-12-25 12:29:06','',''),(2372785,'1','140','773',331,'Retail Sale Id 1407267',757440.00,0.00,0.00,1440.00,15840.00,'2021-12-25 13:47:36','',''),(2374076,'1','140','773',331,'Retail Sale Id 1408217',748024.60,0.00,0.00,1422.10,15643.10,'2021-12-25 16:45:22','',''),(2376846,'1','140','773',331,'Retail Sale Id 1410024',31200.00,0.00,0.00,60.00,300.00,'2021-12-26 10:26:42','',''),(2376854,'1','140','773',331,'Retail Sale Id 1410032',31200.00,0.00,0.00,60.00,300.00,'2021-12-26 10:27:32','',''),(2376861,'1','140','773',331,'Retail Sale Id 1410037',52000.00,0.00,0.00,100.00,500.00,'2021-12-26 10:28:12','',''),(2376871,'1','140','773',331,'Retail Sale Id 1410049',12480.00,0.00,0.00,24.00,120.00,'2021-12-26 10:29:04','',''),(2376888,'1','140','773',331,'Retail Sale Id 1410068',15600.00,0.00,0.00,30.00,150.00,'2021-12-26 10:30:49','',''),(2376895,'1','140','773',331,'Retail Sale Id 1410071',7500.00,0.00,0.00,12.50,1062.50,'2021-12-26 10:31:25','',''),(2376905,'1','140','773',331,'Retail Sale Id 1410083',7500.00,0.00,0.00,12.50,1062.50,'2021-12-26 10:32:41','',''),(2378523,'1','140','773',331,'Retail Sale Id 1411445',3600.00,0.00,0.00,6.00,510.00,'2021-12-26 13:58:15','',''),(2378526,'1','140','773',331,'Retail Sale Id 1411448',3600.00,0.00,0.00,6.00,510.00,'2021-12-26 13:58:49','',''),(2378536,'1','140','773',331,'Retail Sale Id 1411453',7500.00,0.00,0.00,12.50,1062.50,'2021-12-26 13:59:15','',''),(2378538,'1','140','773',331,'Retail Sale Id 1411455',1800.00,0.00,0.00,3.00,255.00,'2021-12-26 13:59:37','',''),(2378544,'1','140','773',331,'Retail Sale Id 1411457',1800.00,0.00,0.00,3.00,255.00,'2021-12-26 14:00:06','',''),(2378582,'1','140','773',331,'Retail Sale Id 1411466',6000.00,0.00,0.00,10.00,850.00,'2021-12-26 14:01:11','',''),(2378593,'1','140','773',331,'Retail Sale Id 1411475',3600.00,0.00,0.00,6.00,510.00,'2021-12-26 14:02:21','',''),(2378631,'1','140','773',331,'Retail Sale Id 1411489',93600.00,0.00,0.00,180.00,900.00,'2021-12-26 14:04:03','',''),(2378636,'1','140','773',331,'Retail Sale Id 1411495',31200.00,0.00,0.00,60.00,300.00,'2021-12-26 14:04:47','',''),(2378641,'1','140','773',331,'Retail Sale Id 1411500',26000.00,0.00,0.00,50.00,250.00,'2021-12-26 14:05:36','',''),(2378643,'1','140','773',331,'Retail Sale Id 1411502',41600.00,0.00,0.00,80.00,400.00,'2021-12-26 14:06:52','',''),(2378666,'1','140','773',331,'Retail Sale Id 1411512',85800.00,0.00,0.00,165.00,825.00,'2021-12-26 14:08:23','',''),(2378831,'1','140',NULL,331,'Reception corrector for bridging 128835',0.00,0.00,0.00,170.00,0.00,'2021-12-26 14:30:27','',''),(2378832,'1','140','773',331,'Received from bridging 128835',0.00,0.00,170.00,0.00,0.00,'2021-12-26 14:30:27','',''),(2378844,'1','140',NULL,331,'Reception corrector for bridging 128836',0.00,0.00,0.00,200.00,0.00,'2021-12-26 14:31:29','',''),(2378845,'1','140','773',331,'Received from bridging 128836',0.00,0.00,200.00,0.00,0.00,'2021-12-26 14:31:29','',''),(2378878,'1','140',NULL,331,'Purchased from AA RANO NIGERIA LIMITED',0.00,12844100.00,24940.00,0.00,0.00,'2021-12-26 14:34:48','',''),(2378906,'1','140',NULL,331,'Reception corrector for bridging 128837',0.00,0.00,0.00,23700.00,0.00,'2021-12-26 14:36:38','',''),(2378908,'1','140','773',331,'Received from bridging 128837',0.00,0.00,23700.00,0.00,0.00,'2021-12-26 14:36:38','',''),(2379061,'1','140','773',331,'Retail Sale Id 1411521',619200.00,0.00,0.00,1200.00,1200.00,'2021-12-26 14:54:19','',''),(2379201,'1','140','773',331,'Retail Sale Id 1411858',30000.00,0.00,0.00,50.00,4250.00,'2021-12-26 15:08:51','',''),(2379206,'1','140','773',331,'Retail Sale Id 1411863',6600.00,0.00,0.00,11.00,935.00,'2021-12-26 15:09:53','',''),(2379214,'1','140','773',331,'Retail Sale Id 1411867',13680.00,0.00,0.00,22.80,1938.00,'2021-12-26 15:10:45','',''),(2379222,'1','140','773',331,'Retail Sale Id 1411876',133120.00,0.00,0.00,256.00,1280.00,'2021-12-26 15:12:33','',''),(2379292,'1','140','773',331,'Retail Sale Id 1411940',54600.00,0.00,0.00,105.00,525.00,'2021-12-26 15:22:03','',''),(2379297,'1','140','773',331,'Retail Sale Id 1411947',3000.00,0.00,0.00,5.00,425.00,'2021-12-26 15:22:55','',''),(2379326,'1','140','773',331,'Return of Retail Sale Id 1411876',0.00,133120.00,256.00,0.00,-1280.00,'2021-12-26 15:28:21','',''),(2379371,'1','140','773',331,'Retail Sale Id 1411989',45760.00,0.00,0.00,88.00,440.00,'2021-12-26 15:31:53','',''),(2379409,'1','140','773',331,'Retail Sale Id 1411998',132600.00,0.00,0.00,255.00,1275.00,'2021-12-26 15:33:32','',''),(2379427,'1','140','773',331,'Retail Sale Id 1412006',660.00,0.00,0.00,1.10,93.50,'2021-12-26 15:34:50','',''),(2380593,'1','140','773',331,'Retail Sale Id 1412667',1200.00,0.00,0.00,2.00,170.00,'2021-12-27 06:39:15','',''),(2380615,'1','140','773',331,'Retail Sale Id 1412690',1200.00,0.00,0.00,2.00,170.00,'2021-12-27 06:44:14','',''),(2380664,'1','140','773',331,'Retail Sale Id 1412741',3498.00,0.00,0.00,5.83,495.55,'2021-12-27 06:59:16','',''),(2380702,'1','140','773',331,'Retail Sale Id 1412763',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 07:05:06','',''),(2380725,'1','140','773',331,'Retail Sale Id 1412786',1200.00,0.00,0.00,2.00,170.00,'2021-12-27 07:10:40','',''),(2380766,'1','140','773',331,'Retail Sale Id 1412820',12480.00,0.00,0.00,24.00,120.00,'2021-12-27 07:19:12','',''),(2380784,'1','140','773',331,'Retail Sale Id 1412838',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 07:23:13','',''),(2380833,'1','140','773',331,'Retail Sale Id 1412874',1200.00,0.00,0.00,2.00,170.00,'2021-12-27 07:26:45','',''),(2380909,'1','140','773',331,'Retail Sale Id 1412918',3600.00,0.00,0.00,6.00,510.00,'2021-12-27 07:33:01','',''),(2380997,'1','140','773',331,'Retail Sale Id 1412969',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 07:39:53','',''),(2381131,'1','140','773',331,'Retail Sale Id 1413027',7500.00,0.00,0.00,12.50,1062.50,'2021-12-27 07:47:17','',''),(2381148,'1','140','773',331,'Retail Sale Id 1413049',7500.00,0.00,0.00,12.50,1062.50,'2021-12-27 07:48:48','',''),(2381161,'1','140','773',331,'Retail Sale Id 1413058',1200.00,0.00,0.00,2.00,170.00,'2021-12-27 07:49:52','',''),(2381188,'1','140','773',331,'Retail Sale Id 1413075',124800.00,0.00,0.00,240.00,1200.00,'2021-12-27 07:51:51','',''),(2381206,'1','140','773',331,'Retail Sale Id 1413092',13000.00,0.00,0.00,25.00,125.00,'2021-12-27 07:54:02','',''),(2381217,'1','140','773',331,'Retail Sale Id 1413099',13000.00,0.00,0.00,25.00,125.00,'2021-12-27 07:55:09','',''),(2381301,'1','140','773',331,'Retail Sale Id 1413161',11440.00,0.00,0.00,22.00,110.00,'2021-12-27 08:01:56','',''),(2381355,'1','140','773',331,'Retail Sale Id 1413213',28600.00,0.00,0.00,55.00,275.00,'2021-12-27 08:08:07','',''),(2381389,'1','140','773',331,'Retail Sale Id 1413235',1200.00,0.00,0.00,2.00,170.00,'2021-12-27 08:10:54','',''),(2381582,'1','140','773',331,'Retail Sale Id 1413414',3600.00,0.00,0.00,6.00,510.00,'2021-12-27 08:30:02','',''),(2381603,'1','140','773',331,'Retail Sale Id 1413435',1200.00,0.00,0.00,2.00,170.00,'2021-12-27 08:32:50','',''),(2381661,'1','140','773',331,'Retail Sale Id 1413492',31200.00,0.00,0.00,60.00,300.00,'2021-12-27 08:38:22','',''),(2381713,'1','140','773',331,'Retail Sale Id 1413531',7500.00,0.00,0.00,12.50,1062.50,'2021-12-27 08:41:17','',''),(2381772,'1','140','773',331,'Retail Sale Id 1413578',78000.00,0.00,0.00,150.00,750.00,'2021-12-27 08:45:28','',''),(2381787,'1','140','773',331,'Retail Sale Id 1413587',55120.00,0.00,0.00,106.00,530.00,'2021-12-27 08:46:29','',''),(2381797,'1','140','773',331,'Retail Sale Id 1413596',28600.00,0.00,0.00,55.00,275.00,'2021-12-27 08:47:04','',''),(2381803,'1','140','773',331,'Retail Sale Id 1413603',26000.00,0.00,0.00,50.00,250.00,'2021-12-27 08:47:41','',''),(2381816,'1','140','773',331,'Retail Sale Id 1413620',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 08:48:38','',''),(2381846,'1','140','773',331,'Retail Sale Id 1413650',6000.00,0.00,0.00,10.00,850.00,'2021-12-27 08:51:48','',''),(2381861,'1','140','773',331,'Retail Sale Id 1413666',7500.00,0.00,0.00,12.50,1062.50,'2021-12-27 08:52:53','',''),(2381889,'1','140','773',331,'Retail Sale Id 1413694',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 08:56:02','',''),(2381915,'1','140','773',331,'Retail Sale Id 1413721',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 08:59:42','',''),(2381932,'1','140','773',331,'Retail Sale Id 1413736',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 09:00:53','',''),(2381968,'1','140','773',331,'Retail Sale Id 1413771',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 09:03:42','',''),(2382022,'1','140','773',331,'Retail Sale Id 1413831',3000.00,0.00,0.00,5.00,425.00,'2021-12-27 09:08:52','',''),(2382037,'1','140','773',331,'Retail Sale Id 1413843',7500.00,0.00,0.00,12.50,1062.50,'2021-12-27 09:10:19','',''),(2382065,'1','140','773',331,'Retail Sale Id 1413875',6500.00,0.00,0.00,12.50,62.50,'2021-12-27 09:13:38','',''),(2382108,'1','140','773',331,'Retail Sale Id 1413917',2400.00,0.00,0.00,4.00,340.00,'2021-12-27 09:18:07','',''),(2382275,'1','140','773',331,'Retail Sale Id 1414066',600.00,0.00,0.00,1.00,85.00,'2021-12-27 09:33:24','',''),(2382500,'1','140','773',331,'Retail Sale Id 1414285',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 09:58:36','',''),(2382632,'1','140','773',331,'Retail Sale Id 1414340',26000.00,0.00,0.00,50.00,250.00,'2021-12-27 10:06:00','',''),(2382678,'1','140','773',331,'Retail Sale Id 1414371',26000.00,0.00,0.00,50.00,250.00,'2021-12-27 10:09:20','',''),(2382712,'1','140','773',331,'Retail Sale Id 1414407',1002.00,0.00,0.00,1.67,141.95,'2021-12-27 10:12:27','',''),(2382855,'1','140','773',331,'Retail Sale Id 1414548',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 10:27:08','',''),(2382865,'1','140','773',331,'Retail Sale Id 1414569',3600.00,0.00,0.00,6.00,510.00,'2021-12-27 10:27:58','',''),(2382915,'1','140','773',331,'Retail Sale Id 1414619',3600.00,0.00,0.00,6.00,510.00,'2021-12-27 10:31:50','',''),(2382933,'1','140','773',331,'Retail Sale Id 1414638',4998.00,0.00,0.00,8.33,708.05,'2021-12-27 10:33:28','',''),(2383046,'1','140','773',331,'Retail Sale Id 1414750',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 10:43:37','',''),(2383106,'1','140','773',331,'Retail Sale Id 1414807',1200.00,0.00,0.00,2.00,170.00,'2021-12-27 10:50:48','',''),(2383129,'1','140','773',331,'Retail Sale Id 1414832',13000.00,0.00,0.00,25.00,125.00,'2021-12-27 10:52:44','',''),(2383140,'1','140','773',331,'Retail Sale Id 1414841',26000.00,0.00,0.00,50.00,250.00,'2021-12-27 10:54:03','',''),(2383157,'1','140','773',331,'Retail Sale Id 1414860',26000.00,0.00,0.00,50.00,250.00,'2021-12-27 10:56:09','',''),(2383166,'1','140','773',331,'Retail Sale Id 1414868',1200.00,0.00,0.00,2.00,170.00,'2021-12-27 10:56:58','',''),(2383183,'1','140','773',331,'Retail Sale Id 1414885',8840.00,0.00,0.00,17.00,85.00,'2021-12-27 10:58:25','',''),(2383202,'1','140','773',331,'Retail Sale Id 1414906',2400.00,0.00,0.00,4.00,340.00,'2021-12-27 11:00:52','',''),(2383218,'1','140','773',331,'Retail Sale Id 1414923',26000.00,0.00,0.00,50.00,250.00,'2021-12-27 11:02:38','',''),(2383359,'1','140','773',331,'Retail Sale Id 1415050',18200.00,0.00,0.00,35.00,175.00,'2021-12-27 11:15:45','',''),(2383465,'1','140','773',331,'Retail Sale Id 1415148',2802.00,0.00,0.00,4.67,396.95,'2021-12-27 11:27:50','',''),(2383477,'1','140','773',331,'Retail Sale Id 1415161',600.00,0.00,0.00,1.00,85.00,'2021-12-27 11:29:25','',''),(2383684,'1','140','773',331,'Retail Sale Id 1415349',1500.00,0.00,0.00,2.50,212.50,'2021-12-27 11:52:04','',''),(2383921,'1','140','773',331,'Retail Sale Id 1415541',7500.00,0.00,0.00,12.50,1062.50,'2021-12-27 12:26:33','',''),(2383928,'1','140','773',331,'Retail Sale Id 1415548',3000.00,0.00,0.00,5.00,425.00,'2021-12-27 12:27:57','',''),(2383970,'1','140','773',331,'Retail Sale Id 1415591',3600.00,0.00,0.00,6.00,510.00,'2021-12-27 12:34:31','',''),(2384047,'1','140','773',331,'Retail Sale Id 1415668',1200.00,0.00,0.00,2.00,170.00,'2021-12-27 12:47:36','',''),(2384074,'1','140','773',331,'Retail Sale Id 1415678',1200.00,0.00,0.00,2.00,170.00,'2021-12-27 12:49:05','',''),(2384106,'1','140','773',331,'Retail Sale Id 1415698',52000.00,0.00,0.00,100.00,500.00,'2021-12-27 12:51:57','',''),(2384124,'1','140','773',331,'Retail Sale Id 1415714',3600.00,0.00,0.00,6.00,510.00,'2021-12-27 12:54:16','',''),(2384466,'1','140','773',331,'Retail Sale Id 1415972',18460.00,0.00,0.00,35.50,177.50,'2021-12-27 13:36:26','',''),(2384471,'1','140','773',331,'Retail Sale Id 1415977',13520.00,0.00,0.00,26.00,130.00,'2021-12-27 13:37:16','',''),(2384489,'1','140','773',331,'Retail Sale Id 1415990',12480.00,0.00,0.00,24.00,120.00,'2021-12-27 13:38:37','',''),(2384546,'1','140','773',331,'Retail Sale Id 1416038',2400.00,0.00,0.00,4.00,340.00,'2021-12-27 13:46:24','',''),(2384552,'1','140','773',331,'Retail Sale Id 1416043',1200.00,0.00,0.00,2.00,170.00,'2021-12-27 13:47:36','',''),(2384558,'1','140','773',331,'Retail Sale Id 1416049',1200.00,0.00,0.00,2.00,170.00,'2021-12-27 13:48:39','',''),(2384565,'1','140','773',331,'Retail Sale Id 1416057',1200.00,0.00,0.00,2.00,170.00,'2021-12-27 13:50:00','',''),(2384667,'1','140','773',331,'Retail Sale Id 1416127',1998.00,0.00,0.00,3.33,283.05,'2021-12-27 14:04:11','',''),(2384676,'1','140','773',331,'Retail Sale Id 1416134',3600.00,0.00,0.00,6.00,510.00,'2021-12-27 14:05:26','',''),(2384706,'1','140','773',331,'Retail Sale Id 1416143',2400.00,0.00,0.00,4.00,340.00,'2021-12-27 14:07:43','',''),(2384714,'1','140','773',331,'Retail Sale Id 1416147',3000.00,0.00,0.00,5.00,425.00,'2021-12-27 14:08:46','',''),(2384768,'1','140','773',331,'Retail Sale Id 1416171',1002.00,0.00,0.00,1.67,141.95,'2021-12-27 14:14:08','',''),(2384944,'1','140','773',331,'Retail Sale Id 1416283',600.00,0.00,0.00,1.00,85.00,'2021-12-27 14:37:51','',''),(2384981,'1','140','773',331,'Retail Sale Id 1416310',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 14:44:02','',''),(2385022,'1','140','773',331,'Retail Sale Id 1416334',1200.00,0.00,0.00,2.00,170.00,'2021-12-27 14:49:24','',''),(2385030,'1','140','773',331,'Retail Sale Id 1416344',3000.00,0.00,0.00,5.00,425.00,'2021-12-27 14:50:47','',''),(2385063,'1','140','773',331,'Retail Sale Id 1416370',52000.00,0.00,0.00,100.00,500.00,'2021-12-27 14:56:53','',''),(2385072,'1','140','773',331,'Retail Sale Id 1416382',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 14:59:41','',''),(2385078,'1','140','773',331,'Retail Sale Id 1416417',26000.00,0.00,0.00,50.00,250.00,'2021-12-27 15:01:00','',''),(2385106,'1','140','773',331,'Retail Sale Id 1416439',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 15:06:03','',''),(2385126,'1','140','773',331,'Retail Sale Id 1416461',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 15:09:59','',''),(2385180,'1','140','773',331,'Retail Sale Id 1416517',3600.00,0.00,0.00,6.00,510.00,'2021-12-27 15:21:54','',''),(2385272,'1','140','773',331,'Retail Sale Id 1416582',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 15:34:37','',''),(2385355,'1','140','773',331,'Retail Sale Id 1416625',31200.00,0.00,0.00,60.00,300.00,'2021-12-27 15:40:39','',''),(2385365,'1','140','773',331,'Retail Sale Id 1416631',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 15:42:26','',''),(2385475,'1','140','773',331,'Retail Sale Id 1416735',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 15:56:17','',''),(2385512,'1','140','773',331,'Retail Sale Id 1416773',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 16:00:26','',''),(2385533,'1','140','773',331,'Retail Sale Id 1416797',1200.00,0.00,0.00,2.00,170.00,'2021-12-27 16:03:43','',''),(2385589,'1','140','773',331,'Retail Sale Id 1416846',4002.00,0.00,0.00,6.67,566.95,'2021-12-27 16:12:25','',''),(2385600,'1','140','773',331,'Retail Sale Id 1416856',25480.00,0.00,0.00,49.00,245.00,'2021-12-27 16:13:44','',''),(2385609,'1','140','773',331,'Retail Sale Id 1416864',1800.00,0.00,0.00,3.00,255.00,'2021-12-27 16:15:47','',''),(2385619,'1','140','773',331,'Retail Sale Id 1416874',1200.00,0.00,0.00,2.00,170.00,'2021-12-27 16:17:03','',''),(2385624,'1','140','773',331,'Retail Sale Id 1416878',1998.00,0.00,0.00,3.33,283.05,'2021-12-27 16:17:56','',''),(2385702,'1','140','773',331,'Retail Sale Id 1416938',26000.00,0.00,0.00,50.00,250.00,'2021-12-27 16:30:00','',''),(2385880,'1','140','773',331,'Retail Sale Id 1417099',10660.00,0.00,0.00,20.50,102.50,'2021-12-27 17:03:22','',''),(2386724,'1','140','773',331,'Retail Sale Id 1417428',26000.00,0.00,0.00,50.00,250.00,'2021-12-28 06:52:06','',''),(2386727,'1','140','773',331,'Retail Sale Id 1417433',30160.00,0.00,0.00,58.00,290.00,'2021-12-28 06:52:51','',''),(2386746,'1','140','773',331,'Retail Sale Id 1417451',3600.00,0.00,0.00,6.00,510.00,'2021-12-28 06:56:10','',''),(2386753,'1','140','773',331,'Retail Sale Id 1417457',2400.00,0.00,0.00,4.00,340.00,'2021-12-28 06:57:21','',''),(2386772,'1','140','773',331,'Retail Sale Id 1417471',1002.00,0.00,0.00,1.67,141.95,'2021-12-28 07:03:16','',''),(2386788,'1','140','773',331,'Retail Sale Id 1417485',31200.00,0.00,0.00,60.00,300.00,'2021-12-28 07:06:39','',''),(2386810,'1','140','773',331,'Retail Sale Id 1417506',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 07:12:29','',''),(2386832,'1','140','773',331,'Retail Sale Id 1417528',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 07:15:51','',''),(2386905,'1','140','773',331,'Retail Sale Id 1417598',1200.00,0.00,0.00,2.00,170.00,'2021-12-28 07:26:44','',''),(2386946,'1','140','773',331,'Retail Sale Id 1417632',1002.00,0.00,0.00,1.67,141.95,'2021-12-28 07:30:12','',''),(2387130,'1','140','773',331,'Retail Sale Id 1417770',4200.00,0.00,0.00,7.00,595.00,'2021-12-28 07:47:55','',''),(2387214,'1','140','773',331,'Retail Sale Id 1417840',1200.00,0.00,0.00,2.00,170.00,'2021-12-28 07:55:35','',''),(2387241,'1','140','773',331,'Retail Sale Id 1417857',600.00,0.00,0.00,1.00,85.00,'2021-12-28 07:57:05','',''),(2387255,'1','140','773',331,'Retail Sale Id 1417871',2400.00,0.00,0.00,4.00,340.00,'2021-12-28 07:58:31','',''),(2387399,'1','140','773',331,'Retail Sale Id 1417979',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 08:09:07','',''),(2387411,'1','140','773',331,'Retail Sale Id 1417992',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 08:10:07','',''),(2387456,'1','140','773',331,'Retail Sale Id 1418020',53560.00,0.00,0.00,103.00,515.00,'2021-12-28 08:12:55','',''),(2387529,'1','140','773',331,'Retail Sale Id 1418073',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 08:18:03','',''),(2387567,'1','140','773',331,'Retail Sale Id 1418096',1200.00,0.00,0.00,2.00,170.00,'2021-12-28 08:20:50','',''),(2387593,'1','140','773',331,'Retail Sale Id 1418115',3600.00,0.00,0.00,6.00,510.00,'2021-12-28 08:22:39','',''),(2387607,'1','140','773',331,'Retail Sale Id 1418131',7500.00,0.00,0.00,12.50,1062.50,'2021-12-28 08:24:05','',''),(2387780,'1','140','773',331,'Retail Sale Id 1418250',2400.00,0.00,0.00,4.00,340.00,'2021-12-28 08:37:23','',''),(2387866,'1','140','773',331,'Retail Sale Id 1418298',36400.00,0.00,0.00,70.00,350.00,'2021-12-28 08:42:47','',''),(2388015,'1','140','773',331,'Retail Sale Id 1418447',1200.00,0.00,0.00,2.00,170.00,'2021-12-28 09:00:07','',''),(2388049,'1','140','773',331,'Retail Sale Id 1418484',26000.00,0.00,0.00,50.00,250.00,'2021-12-28 09:06:46','',''),(2388058,'1','140','773',331,'Retail Sale Id 1418492',31200.00,0.00,0.00,60.00,300.00,'2021-12-28 09:07:59','',''),(2388133,'1','140','773',331,'Retail Sale Id 1418563',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 09:17:10','',''),(2388166,'1','140','773',331,'Retail Sale Id 1418601',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 09:21:09','',''),(2388263,'1','140','773',331,'Retail Sale Id 1418698',28600.00,0.00,0.00,55.00,275.00,'2021-12-28 09:32:59','',''),(2388314,'1','140','773',331,'Retail Sale Id 1418748',28600.00,0.00,0.00,55.00,275.00,'2021-12-28 09:38:47','',''),(2388327,'1','140','773',331,'Retail Sale Id 1418755',1200.00,0.00,0.00,2.00,170.00,'2021-12-28 09:40:40','',''),(2388428,'1','140','773',331,'Retail Sale Id 1418853',2400.00,0.00,0.00,4.00,340.00,'2021-12-28 09:51:30','',''),(2388447,'1','140','773',331,'Retail Sale Id 1418869',1500.00,0.00,0.00,2.50,212.50,'2021-12-28 09:53:09','',''),(2388564,'1','140','773',331,'Retail Sale Id 1418983',600.00,0.00,0.00,1.00,85.00,'2021-12-28 10:05:43','',''),(2388578,'1','140','773',331,'Retail Sale Id 1418997',3600.00,0.00,0.00,6.00,510.00,'2021-12-28 10:07:14','',''),(2388594,'1','140','773',331,'Retail Sale Id 1419014',1200.00,0.00,0.00,2.00,170.00,'2021-12-28 10:09:56','',''),(2388659,'1','140','773',331,'Retail Sale Id 1419079',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 10:16:46','',''),(2388672,'1','140','773',331,'Retail Sale Id 1419094',3000.00,0.00,0.00,5.00,425.00,'2021-12-28 10:18:21','',''),(2388721,'1','140','773',331,'Retail Sale Id 1419138',31200.00,0.00,0.00,60.00,300.00,'2021-12-28 10:23:08','',''),(2388904,'1','140','773',331,'Retail Sale Id 1419288',600.00,0.00,0.00,1.00,85.00,'2021-12-28 10:39:49','',''),(2388929,'1','140','773',331,'Retail Sale Id 1419309',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 10:41:47','',''),(2388965,'1','140','773',331,'Retail Sale Id 1419343',26000.00,0.00,0.00,50.00,250.00,'2021-12-28 10:44:55','',''),(2389098,'1','140','773',331,'Retail Sale Id 1419473',600.00,0.00,0.00,1.00,85.00,'2021-12-28 10:58:36','',''),(2389328,'1','140','773',331,'Retail Sale Id 1419677',3600.00,0.00,0.00,6.00,510.00,'2021-12-28 11:23:32','',''),(2389371,'1','140','773',331,'Retail Sale Id 1419717',7500.00,0.00,0.00,12.50,1062.50,'2021-12-28 11:29:20','',''),(2389448,'1','140','773',331,'Retail Sale Id 1419782',11960.00,0.00,0.00,23.00,115.00,'2021-12-28 11:37:36','',''),(2389458,'1','140','773',331,'Retail Sale Id 1419791',26000.00,0.00,0.00,50.00,250.00,'2021-12-28 11:38:34','',''),(2389467,'1','140','773',331,'Retail Sale Id 1419800',26000.00,0.00,0.00,50.00,250.00,'2021-12-28 11:39:25','',''),(2389499,'1','140','773',331,'Retail Sale Id 1419830',26000.00,0.00,0.00,50.00,250.00,'2021-12-28 11:43:29','',''),(2389512,'1','140','773',331,'Retail Sale Id 1419844',31200.00,0.00,0.00,60.00,300.00,'2021-12-28 11:44:44','',''),(2389545,'1','140','773',331,'Retail Sale Id 1419874',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 11:48:07','',''),(2389572,'1','140','773',331,'Retail Sale Id 1419895',28600.00,0.00,0.00,55.00,275.00,'2021-12-28 11:50:34','',''),(2389606,'1','140','773',331,'Retail Sale Id 1419924',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 11:53:26','',''),(2389628,'1','140','773',331,'Retail Sale Id 1419944',8840.00,0.00,0.00,17.00,85.00,'2021-12-28 11:56:26','',''),(2389680,'1','140','773',331,'Retail Sale Id 1419978',1002.00,0.00,0.00,1.67,141.95,'2021-12-28 12:00:23','',''),(2389695,'1','140','773',331,'Retail Sale Id 1419990',1200.00,0.00,0.00,2.00,170.00,'2021-12-28 12:02:06','',''),(2389760,'1','140','773',331,'Retail Sale Id 1420018',1998.00,0.00,0.00,3.33,283.05,'2021-12-28 12:05:44','',''),(2389771,'1','140','773',331,'Retail Sale Id 1420042',1200.00,0.00,0.00,2.00,170.00,'2021-12-28 12:07:01','',''),(2389806,'1','140','773',331,'Retail Sale Id 1420071',2400.00,0.00,0.00,4.00,340.00,'2021-12-28 12:08:42','',''),(2389882,'1','140','773',331,'Retail Sale Id 1420123',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 12:18:22','',''),(2389928,'1','140','773',331,'Retail Sale Id 1420169',7500.00,0.00,0.00,12.50,1062.50,'2021-12-28 12:21:52','',''),(2389939,'1','140','773',331,'Retail Sale Id 1420182',1200.00,0.00,0.00,2.00,170.00,'2021-12-28 12:22:53','',''),(2390160,'1','140','773',331,'Retail Sale Id 1420332',23400.00,0.00,0.00,45.00,225.00,'2021-12-28 12:40:25','',''),(2390223,'1','140','773',331,'Retail Sale Id 1420385',600.00,0.00,0.00,1.00,85.00,'2021-12-28 12:47:03','',''),(2390233,'1','140','773',331,'Retail Sale Id 1420394',600.00,0.00,0.00,1.00,85.00,'2021-12-28 12:47:57','',''),(2390500,'1','140','773',331,'Retail Sale Id 1420592',3000.00,0.00,0.00,5.00,425.00,'2021-12-28 13:13:02','',''),(2390509,'1','140','773',331,'Retail Sale Id 1420601',3000.00,0.00,0.00,5.00,425.00,'2021-12-28 13:14:38','',''),(2390740,'1','140','773',331,'Retail Sale Id 1420743',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 13:34:28','',''),(2390805,'1','140','773',331,'Retail Sale Id 1420791',6240.00,0.00,0.00,12.00,60.00,'2021-12-28 13:42:48','',''),(2390836,'1','140','773',331,'Retail Sale Id 1420814',3600.00,0.00,0.00,6.00,510.00,'2021-12-28 13:46:35','',''),(2390874,'1','140','773',331,'Retail Sale Id 1420845',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 13:50:16','',''),(2390956,'1','140','773',331,'Retail Sale Id 1420918',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 13:59:37','',''),(2390973,'1','140','773',331,'Retail Sale Id 1420926',1998.00,0.00,0.00,3.33,283.05,'2021-12-28 14:00:57','',''),(2390991,'1','140','773',331,'Retail Sale Id 1420946',1002.00,0.00,0.00,1.67,141.95,'2021-12-28 14:02:47','',''),(2391002,'1','140','773',331,'Retail Sale Id 1420957',3000.00,0.00,0.00,5.00,425.00,'2021-12-28 14:04:05','',''),(2391024,'1','140','773',331,'Retail Sale Id 1420967',1200.00,0.00,0.00,2.00,170.00,'2021-12-28 14:05:21','',''),(2391033,'1','140','773',331,'Retail Sale Id 1420976',1200.00,0.00,0.00,2.00,170.00,'2021-12-28 14:06:24','',''),(2391182,'1','140','773',331,'Retail Sale Id 1421059',57200.00,0.00,0.00,110.00,550.00,'2021-12-28 14:18:34','',''),(2391194,'1','140','773',331,'Retail Sale Id 1421068',7500.00,0.00,0.00,12.50,1062.50,'2021-12-28 14:20:04','',''),(2391221,'1','140','773',331,'Retail Sale Id 1421095',1200.00,0.00,0.00,2.00,170.00,'2021-12-28 14:23:41','',''),(2391241,'1','140','773',331,'Retail Sale Id 1421115',3600.00,0.00,0.00,6.00,510.00,'2021-12-28 14:25:51','',''),(2391292,'1','140','773',331,'Retail Sale Id 1421155',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 14:32:24','',''),(2391448,'1','140','773',331,'Retail Sale Id 1421299',1200.00,0.00,0.00,2.00,170.00,'2021-12-28 14:54:13','',''),(2391483,'1','140','773',331,'Retail Sale Id 1421333',1200.00,0.00,0.00,2.00,170.00,'2021-12-28 14:59:12','',''),(2391491,'1','140','773',331,'Retail Sale Id 1421343',1200.00,0.00,0.00,2.00,170.00,'2021-12-28 15:00:16','',''),(2391723,'1','140','773',331,'Retail Sale Id 1421525',7500.00,0.00,0.00,12.50,1062.50,'2021-12-28 15:28:19','',''),(2391732,'1','140','773',331,'Retail Sale Id 1421534',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 15:29:55','',''),(2391769,'1','140','773',331,'Retail Sale Id 1421574',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 15:34:28','',''),(2391855,'1','140','773',331,'Retail Sale Id 1421653',7500.00,0.00,0.00,12.50,1062.50,'2021-12-28 15:44:20','',''),(2391938,'1','140','773',331,'Retail Sale Id 1421715',6000.00,0.00,0.00,10.00,850.00,'2021-12-28 15:52:14','',''),(2392178,'1','140','773',331,'Retail Sale Id 1421869',3600.00,0.00,0.00,6.00,510.00,'2021-12-28 16:10:38','',''),(2392189,'1','140','773',331,'Retail Sale Id 1421882',3600.00,0.00,0.00,6.00,510.00,'2021-12-28 16:11:58','',''),(2392198,'1','140','773',331,'Retail Sale Id 1421889',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 16:13:10','',''),(2392214,'1','140','773',331,'Retail Sale Id 1421906',1200.00,0.00,0.00,2.00,170.00,'2021-12-28 16:15:08','',''),(2392243,'1','140','773',331,'Retail Sale Id 1421934',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 16:19:08','',''),(2392260,'1','140','773',331,'Retail Sale Id 1421949',11100.00,0.00,0.00,18.50,1572.50,'2021-12-28 16:21:18','',''),(2392408,'1','140','773',331,'Retail Sale Id 1422010',4800.00,0.00,0.00,8.00,680.00,'2021-12-28 16:31:05','',''),(2392467,'1','140','773',331,'Retail Sale Id 1422056',5400.00,0.00,0.00,9.00,765.00,'2021-12-28 16:38:23','',''),(2392471,'1','140','773',331,'Retail Sale Id 1422062',1200.00,0.00,0.00,2.00,170.00,'2021-12-28 16:39:31','',''),(2392515,'1','140','773',331,'Retail Sale Id 1422104',3600.00,0.00,0.00,6.00,510.00,'2021-12-28 16:45:46','',''),(2392521,'1','140','773',331,'Retail Sale Id 1422110',3000.00,0.00,0.00,5.00,425.00,'2021-12-28 16:47:06','',''),(2392554,'1','140','773',331,'Retail Sale Id 1422140',26000.00,0.00,0.00,50.00,250.00,'2021-12-28 16:51:38','',''),(2392564,'1','140','773',331,'Retail Sale Id 1422149',1200.00,0.00,0.00,2.00,170.00,'2021-12-28 16:53:19','',''),(2392607,'1','140','773',331,'Retail Sale Id 1422184',20800.00,0.00,0.00,40.00,200.00,'2021-12-28 16:59:31','',''),(2392637,'1','140','773',331,'Retail Sale Id 1422213',1800.00,0.00,0.00,3.00,255.00,'2021-12-28 17:02:41','',''),(2392687,'1','140','773',331,'Retail Sale Id 1422253',814248.00,0.00,0.00,1578.00,1578.00,'2021-12-28 17:11:53','',''),(2393515,'1','140','773',331,'Retail Sale Id 1422544',3600.00,0.00,0.00,6.00,510.00,'2021-12-29 06:44:42','',''),(2393522,'1','140','773',331,'Retail Sale Id 1422552',1200.00,0.00,0.00,2.00,170.00,'2021-12-29 06:45:38','',''),(2393539,'1','140','773',331,'Retail Sale Id 1422561',12480.00,0.00,0.00,24.00,120.00,'2021-12-29 06:46:51','',''),(2393548,'1','140','773',331,'Retail Sale Id 1422566',1200.00,0.00,0.00,2.00,170.00,'2021-12-29 06:48:40','',''),(2393557,'1','140','773',331,'Retail Sale Id 1422575',1200.00,0.00,0.00,2.00,170.00,'2021-12-29 06:50:54','',''),(2393609,'1','140','773',331,'Retail Sale Id 1422627',3600.00,0.00,0.00,6.00,510.00,'2021-12-29 06:59:38','',''),(2393639,'1','140','773',331,'Retail Sale Id 1422659',600.00,0.00,0.00,1.00,85.00,'2021-12-29 07:03:06','',''),(2393669,'1','140','773',331,'Retail Sale Id 1422681',3600.00,0.00,0.00,6.00,510.00,'2021-12-29 07:05:59','',''),(2393680,'1','140','773',331,'Retail Sale Id 1422691',1800.00,0.00,0.00,3.00,255.00,'2021-12-29 07:07:25','',''),(2393843,'1','140','773',331,'Retail Sale Id 1422815',2400.00,0.00,0.00,4.00,340.00,'2021-12-29 07:23:13','',''),(2393859,'1','140','773',331,'Retail Sale Id 1422820',12480.00,0.00,0.00,24.00,120.00,'2021-12-29 07:24:12','',''),(2393900,'1','140','773',331,'Retail Sale Id 1422844',2400.00,0.00,0.00,4.00,340.00,'2021-12-29 07:27:34','',''),(2393955,'1','140','773',331,'Retail Sale Id 1422897',1200.00,0.00,0.00,2.00,170.00,'2021-12-29 07:34:30','',''),(2393988,'1','140','773',331,'Retail Sale Id 1422923',1200.00,0.00,0.00,2.00,170.00,'2021-12-29 07:38:47','',''),(2394009,'1','140','773',331,'Retail Sale Id 1422947',28600.00,0.00,0.00,55.00,275.00,'2021-12-29 07:40:22','',''),(2394098,'1','140','773',331,'Retail Sale Id 1423011',3000.00,0.00,0.00,5.00,425.00,'2021-12-29 07:49:23','',''),(2394249,'1','140','773',331,'Retail Sale Id 1423097',28600.00,0.00,0.00,55.00,275.00,'2021-12-29 08:01:49','',''),(2394258,'1','140','773',331,'Retail Sale Id 1423107',26000.00,0.00,0.00,50.00,250.00,'2021-12-29 08:02:25','',''),(2394320,'1','140','773',331,'Retail Sale Id 1423159',3600.00,0.00,0.00,6.00,510.00,'2021-12-29 08:08:32','',''),(2394396,'1','140','773',331,'Retail Sale Id 1423214',600.00,0.00,0.00,1.00,85.00,'2021-12-29 08:16:37','',''),(2394491,'1','140','773',331,'Retail Sale Id 1423300',1800.00,0.00,0.00,3.00,255.00,'2021-12-29 08:27:07','',''),(2395018,'1','140','773',331,'Retail Sale Id 1423701',1200.00,0.00,0.00,2.00,170.00,'2021-12-29 09:17:54','',''),(2395161,'1','140','773',331,'Retail Sale Id 1423845',600.00,0.00,0.00,1.00,85.00,'2021-12-29 09:33:24','',''),(2395363,'1','140','773',331,'Retail Sale Id 1424022',1002.00,0.00,0.00,1.67,141.95,'2021-12-29 09:55:51','',''),(2395386,'1','140','773',331,'Retail Sale Id 1424046',1800.00,0.00,0.00,3.00,255.00,'2021-12-29 09:58:28','',''),(2395505,'1','140','773',331,'Retail Sale Id 1424135',11960.00,0.00,0.00,23.00,115.00,'2021-12-29 10:10:02','',''),(2395583,'1','140','773',331,'Retail Sale Id 1424208',600.00,0.00,0.00,1.00,85.00,'2021-12-29 10:18:33','',''),(2395593,'1','140','773',331,'Retail Sale Id 1424217',2400.00,0.00,0.00,4.00,340.00,'2021-12-29 10:19:27','',''),(2395616,'1','140','773',331,'Retail Sale Id 1424238',7500.00,0.00,0.00,12.50,1062.50,'2021-12-29 10:21:24','',''),(2395655,'1','140','773',331,'Retail Sale Id 1424271',3000.00,0.00,0.00,5.00,425.00,'2021-12-29 10:25:57','',''),(2395760,'1','140','773',331,'Retail Sale Id 1424378',2400.00,0.00,0.00,4.00,340.00,'2021-12-29 10:38:48','',''),(2395798,'1','140','773',331,'Retail Sale Id 1424403',7500.00,0.00,0.00,12.50,1062.50,'2021-12-29 10:43:05','',''),(2395965,'1','140','773',331,'Retail Sale Id 1424536',3600.00,0.00,0.00,6.00,510.00,'2021-12-29 10:59:28','',''),(2395977,'1','140','773',331,'Retail Sale Id 1424548',6000.00,0.00,0.00,10.00,850.00,'2021-12-29 11:00:36','',''),(2395989,'1','140','773',331,'Retail Sale Id 1424453',1200.00,0.00,0.00,2.00,170.00,'2021-12-29 11:01:43','',''),(2396076,'1','140','773',331,'Retail Sale Id 1424647',1200.00,0.00,0.00,2.00,170.00,'2021-12-29 11:11:05','',''),(2396194,'1','140','773',331,'Retail Sale Id 1424750',1800.00,0.00,0.00,3.00,255.00,'2021-12-29 11:24:44','',''),(2396238,'1','140','773',331,'Retail Sale Id 1424789',1800.00,0.00,0.00,3.00,255.00,'2021-12-29 11:30:09','',''),(2396257,'1','140','773',331,'Retail Sale Id 1424808',13000.00,0.00,0.00,25.00,125.00,'2021-12-29 11:32:13','',''),(2396357,'1','140','773',331,'Retail Sale Id 1424884',3600.00,0.00,0.00,6.00,510.00,'2021-12-29 11:41:12','',''),(2396485,'1','140','773',331,'Retail Sale Id 1425004',1800.00,0.00,0.00,3.00,255.00,'2021-12-29 11:57:21','',''),(2396500,'1','140','773',331,'Retail Sale Id 1425017',31200.00,0.00,0.00,60.00,300.00,'2021-12-29 11:58:54','',''),(2396657,'1','140','773',331,'Retail Sale Id 1425165',31200.00,0.00,0.00,60.00,300.00,'2021-12-29 12:24:14','',''),(2396683,'1','140','773',331,'Retail Sale Id 1425184',900.00,0.00,0.00,1.50,127.50,'2021-12-29 12:28:26','',''),(2396758,'1','140','773',331,'Retail Sale Id 1425241',2502.00,0.00,0.00,4.17,354.45,'2021-12-29 12:36:04','',''),(2396767,'1','140','773',331,'Retail Sale Id 1425251',1200.00,0.00,0.00,2.00,170.00,'2021-12-29 12:37:03','',''),(2396773,'1','140','773',331,'Retail Sale Id 1425260',20800.00,0.00,0.00,40.00,200.00,'2021-12-29 12:38:16','',''),(2396858,'1','140','773',331,'Retail Sale Id 1425332',1200.00,0.00,0.00,2.00,170.00,'2021-12-29 12:48:24','',''),(2396902,'1','140','773',331,'Retail Sale Id 1425371',3000.00,0.00,0.00,5.00,425.00,'2021-12-29 12:54:23','',''),(2397046,'1','140','773',331,'Retail Sale Id 1425465',26000.00,0.00,0.00,50.00,250.00,'2021-12-29 13:10:00','',''),(2397081,'1','140','773',331,'Retail Sale Id 1425501',1800.00,0.00,0.00,3.00,255.00,'2021-12-29 13:14:30','',''),(2397105,'1','140','773',331,'Retail Sale Id 1425529',7500.00,0.00,0.00,12.50,1062.50,'2021-12-29 13:17:59','',''),(2397119,'1','140','773',331,'Retail Sale Id 1425541',600.00,0.00,0.00,1.00,85.00,'2021-12-29 13:19:34','',''),(2397197,'1','140','773',331,'Retail Sale Id 1425600',31200.00,0.00,0.00,60.00,300.00,'2021-12-29 13:28:11','',''),(2397314,'1','140','773',331,'Retail Sale Id 1425688',3000.00,0.00,0.00,5.00,425.00,'2021-12-29 13:43:02','',''),(2397387,'1','140','773',331,'Retail Sale Id 1425742',3000.00,0.00,0.00,5.00,425.00,'2021-12-29 13:50:28','',''),(2397579,'1','140','773',331,'Retail Sale Id 1425906',3000.00,0.00,0.00,5.00,425.00,'2021-12-29 14:11:11','',''),(2397688,'1','140','773',331,'Retail Sale Id 1425994',1800.00,0.00,0.00,3.00,255.00,'2021-12-29 14:23:17','',''),(2397768,'1','140','773',331,'Retail Sale Id 1426052',1200.00,0.00,0.00,2.00,170.00,'2021-12-29 14:30:28','',''),(2397846,'1','140','773',331,'Retail Sale Id 1426103',1200.00,0.00,0.00,2.00,170.00,'2021-12-29 14:36:24','',''),(2397934,'1','140','773',331,'Retail Sale Id 1426158',1200.00,0.00,0.00,2.00,170.00,'2021-12-29 14:43:45','',''),(2398015,'1','140','773',331,'Retail Sale Id 1426218',1051350.00,0.00,0.00,2037.50,2037.50,'2021-12-29 14:50:34','',''),(2398051,'1','140','773',331,'Retail Sale Id 1426226',3600.00,0.00,0.00,6.00,510.00,'2021-12-29 14:52:00','',''),(2398130,'1','140','773',331,'Retail Sale Id 1426272',14400.00,0.00,0.00,24.00,2040.00,'2021-12-29 14:58:46','',''),(2398137,'1','140','773',331,'Retail Sale Id 1426286',2502.00,0.00,0.00,4.17,354.45,'2021-12-29 14:59:52','',''),(2398357,'1','140','773',331,'Retail Sale Id 1426401',7500.00,0.00,0.00,12.50,1062.50,'2021-12-29 15:18:50','',''),(2398365,'1','140','773',331,'Retail Sale Id 1426410',2400.00,0.00,0.00,4.00,340.00,'2021-12-29 15:20:14','',''),(2398393,'1','140','773',331,'Retail Sale Id 1426442',1500.00,0.00,0.00,2.50,212.50,'2021-12-29 15:23:00','',''),(2398457,'1','140','773',331,'Retail Sale Id 1426481',1288968.00,0.00,0.00,2498.00,2498.00,'2021-12-29 15:27:22','',''),(2398559,'1','140','773',331,'Retail Sale Id 1426547',26000.00,0.00,0.00,50.00,250.00,'2021-12-29 15:34:56','',''),(2398588,'1','140','773',331,'Retail Sale Id 1426568',1800.00,0.00,0.00,3.00,255.00,'2021-12-29 15:36:54','',''),(2398688,'1','140','773',331,'Retail Sale Id 1426621',1200.00,0.00,0.00,2.00,170.00,'2021-12-29 15:42:56','',''),(2398961,'1','140','773',331,'Retail Sale Id 1426807',3000.00,0.00,0.00,5.00,425.00,'2021-12-29 16:10:01','',''),(2398994,'1','140','773',331,'Retail Sale Id 1426840',26000.00,0.00,0.00,50.00,250.00,'2021-12-29 16:14:03','',''),(2399169,'1','140','773',331,'Retail Sale Id 1427014',600.00,0.00,0.00,1.00,85.00,'2021-12-29 16:35:09','',''),(2399271,'1','140','773',331,'Retail Sale Id 1427076',570696.00,0.00,0.00,1106.00,1106.00,'2021-12-29 16:44:56','',''),(2399295,'1','140','773',331,'Retail Sale Id 1427099',1500.00,0.00,0.00,2.50,212.50,'2021-12-29 16:47:37','',''),(2399320,'1','140','773',331,'Retail Sale Id 1427121',11960.00,0.00,0.00,23.00,115.00,'2021-12-29 16:51:07','',''),(2399344,'1','140','773',331,'Retail Sale Id 1427143',11960.00,0.00,0.00,23.00,115.00,'2021-12-29 16:55:03','',''),(2399369,'1','140','773',331,'Retail Sale Id 1427166',3600.00,0.00,0.00,6.00,510.00,'2021-12-29 16:57:28','',''),(2399403,'1','140','773',331,'Retail Sale Id 1427197',4200.00,0.00,0.00,7.00,595.00,'2021-12-29 17:02:31','',''),(2399439,'1','140','773',331,'Return of Retail Sale Id 1426481',0.00,1288968.00,2498.00,0.00,-2498.00,'2021-12-29 17:09:40','',''),(2400096,'1','140','773',331,'Retail Sale Id 1427510',1200.00,0.00,0.00,2.00,170.00,'2021-12-30 06:32:19','',''),(2400284,'1','140','773',331,'Retail Sale Id 1427552',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 06:45:47','',''),(2400304,'1','140','773',331,'Retail Sale Id 1427570',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 06:50:05','',''),(2400440,'1','140','773',331,'Retail Sale Id 1427652',1200.00,0.00,0.00,2.00,170.00,'2021-12-30 07:03:25','',''),(2400466,'1','140','773',331,'Retail Sale Id 1427680',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 07:08:09','',''),(2400469,'1','140','773',331,'Retail Sale Id 1427683',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 07:08:47','',''),(2400514,'1','140','773',331,'Retail Sale Id 1427726',3000.00,0.00,0.00,5.00,425.00,'2021-12-30 07:16:23','',''),(2400600,'1','140','773',331,'Retail Sale Id 1427797',75140.00,0.00,0.00,144.50,722.50,'2021-12-30 07:27:23','',''),(2400613,'1','140','773',331,'Retail Sale Id 1427809',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 07:29:20','',''),(2400640,'1','140','773',331,'Retail Sale Id 1427827',11960.00,0.00,0.00,23.00,115.00,'2021-12-30 07:31:46','',''),(2400775,'1','140','773',331,'Retail Sale Id 1427912',1200.00,0.00,0.00,2.00,170.00,'2021-12-30 07:42:17','',''),(2400789,'1','140','773',331,'Retail Sale Id 1427925',3000.00,0.00,0.00,5.00,425.00,'2021-12-30 07:43:55','',''),(2400796,'1','140','773',331,'Retail Sale Id 1427932',7500.00,0.00,0.00,12.50,1062.50,'2021-12-30 07:45:06','',''),(2400820,'1','140','773',331,'Retail Sale Id 1427953',3600.00,0.00,0.00,6.00,510.00,'2021-12-30 07:47:27','',''),(2401095,'1','140','773',331,'Retail Sale Id 1428184',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 08:16:03','',''),(2401400,'1','140','773',331,'Retail Sale Id 1428388',28600.00,0.00,0.00,55.00,275.00,'2021-12-30 08:40:10','',''),(2401634,'1','140','773',331,'Retail Sale Id 1428544',3000.00,0.00,0.00,5.00,425.00,'2021-12-30 08:54:26','',''),(2401652,'1','140','773',331,'Retail Sale Id 1428558',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 08:55:56','',''),(2401683,'1','140','773',331,'Retail Sale Id 1428580',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 08:57:56','',''),(2402108,'1','140','773',331,'Retail Sale Id 1428945',6600.00,0.00,0.00,11.00,935.00,'2021-12-30 09:36:37','',''),(2402118,'1','140','773',331,'Retail Sale Id 1428953',3000.00,0.00,0.00,5.00,425.00,'2021-12-30 09:37:27','',''),(2402140,'1','140','773',331,'Retail Sale Id 1428975',3600.00,0.00,0.00,6.00,510.00,'2021-12-30 09:39:40','',''),(2402377,'1','140','773',331,'Retail Sale Id 1429191',1200.00,0.00,0.00,2.00,170.00,'2021-12-30 10:02:00','',''),(2402578,'1','140','773',331,'Retail Sale Id 1429392',600.00,0.00,0.00,1.00,85.00,'2021-12-30 10:22:53','',''),(2402587,'1','140','773',331,'Retail Sale Id 1429402',1200.00,0.00,0.00,2.00,170.00,'2021-12-30 10:23:41','',''),(2402595,'1','140','773',331,'Retail Sale Id 1429409',1200.00,0.00,0.00,2.00,170.00,'2021-12-30 10:24:25','',''),(2402602,'1','140','773',331,'Retail Sale Id 1429417',1200.00,0.00,0.00,2.00,170.00,'2021-12-30 10:25:19','',''),(2402634,'1','140','773',331,'Retail Sale Id 1429446',3600.00,0.00,0.00,6.00,510.00,'2021-12-30 10:28:31','',''),(2402656,'1','140','773',331,'Retail Sale Id 1429468',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 10:31:00','',''),(2402938,'1','140','773',331,'Retail Sale Id 1429667',31200.00,0.00,0.00,60.00,300.00,'2021-12-30 10:54:04','',''),(2403015,'1','140','773',331,'Retail Sale Id 1429750',28600.00,0.00,0.00,55.00,275.00,'2021-12-30 11:03:31','',''),(2403029,'1','140','773',331,'Retail Sale Id 1429764',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 11:05:04','',''),(2403038,'1','140','773',331,'Retail Sale Id 1429773',1200.00,0.00,0.00,2.00,170.00,'2021-12-30 11:05:53','',''),(2403124,'1','140','773',331,'Retail Sale Id 1429848',1200.00,0.00,0.00,2.00,170.00,'2021-12-30 11:15:57','',''),(2403134,'1','140','773',331,'Retail Sale Id 1429858',7500.00,0.00,0.00,12.50,1062.50,'2021-12-30 11:17:01','',''),(2403142,'1','140','773',331,'Retail Sale Id 1429866',3000.00,0.00,0.00,5.00,425.00,'2021-12-30 11:17:42','',''),(2403163,'1','140','773',331,'Retail Sale Id 1429885',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 11:20:04','',''),(2403279,'1','140','773',331,'Retail Sale Id 1429998',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 11:37:42','',''),(2403340,'1','140','773',331,'Retail Sale Id 1430058',1500.00,0.00,0.00,2.50,212.50,'2021-12-30 11:44:35','',''),(2403488,'1','140','773',331,'Retail Sale Id 1430210',20800.00,0.00,0.00,40.00,200.00,'2021-12-30 12:06:03','',''),(2403644,'1','140','773',331,'Retail Sale Id 1430351',3000.00,0.00,0.00,5.00,425.00,'2021-12-30 12:27:32','',''),(2403659,'1','140','773',331,'Retail Sale Id 1430365',3000.00,0.00,0.00,5.00,425.00,'2021-12-30 12:29:20','',''),(2403692,'1','140','773',331,'Retail Sale Id 1430397',1200.00,0.00,0.00,2.00,170.00,'2021-12-30 12:33:05','',''),(2403702,'1','140','773',331,'Retail Sale Id 1430405',1200.00,0.00,0.00,2.00,170.00,'2021-12-30 12:34:07','',''),(2403711,'1','140','773',331,'Retail Sale Id 1430416',600.00,0.00,0.00,1.00,85.00,'2021-12-30 12:35:09','',''),(2403916,'1','140','773',331,'Retail Sale Id 1430589',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 13:01:22','',''),(2403980,'1','140','773',331,'Retail Sale Id 1430636',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 13:08:58','',''),(2404115,'1','140','773',331,'Retail Sale Id 1430721',9600.00,0.00,0.00,16.00,1360.00,'2021-12-30 13:21:19','',''),(2404783,'1','140','773',331,'Retail Sale Id 1431176',600.00,0.00,0.00,1.00,85.00,'2021-12-30 14:19:41','',''),(2404810,'1','140','773',331,'Retail Sale Id 1431201',6000.00,0.00,0.00,10.00,850.00,'2021-12-30 14:21:55','',''),(2404840,'1','140','773',331,'Retail Sale Id 1431230',600.00,0.00,0.00,1.00,85.00,'2021-12-30 14:24:35','',''),(2404912,'1','140','773',331,'Retail Sale Id 1431306',31200.00,0.00,0.00,60.00,300.00,'2021-12-30 14:34:40','',''),(2404929,'1','140','773',331,'Retail Sale Id 1431328',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 14:36:31','',''),(2404975,'1','140','773',331,'Retail Sale Id 1431357',1998.00,0.00,0.00,3.33,283.05,'2021-12-30 14:41:45','',''),(2404993,'1','140','773',331,'Retail Sale Id 1431394',7500.00,0.00,0.00,12.50,1062.50,'2021-12-30 14:43:15','',''),(2405003,'1','140','773',331,'Retail Sale Id 1431408',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 14:44:32','',''),(2405025,'1','140','773',331,'Retail Sale Id 1431429',1200.00,0.00,0.00,2.00,170.00,'2021-12-30 14:47:18','',''),(2405034,'1','140','773',331,'Retail Sale Id 1431438',1200.00,0.00,0.00,2.00,170.00,'2021-12-30 14:48:55','',''),(2405087,'1','140','773',331,'Retail Sale Id 1431490',6000.00,0.00,0.00,10.00,850.00,'2021-12-30 14:56:45','',''),(2405135,'1','140','773',331,'Retail Sale Id 1431538',11960.00,0.00,0.00,23.00,115.00,'2021-12-30 15:02:11','',''),(2405165,'1','140','773',331,'Retail Sale Id 1431565',1002.00,0.00,0.00,1.67,141.95,'2021-12-30 15:07:28','',''),(2405176,'1','140','773',331,'Retail Sale Id 1431579',3000.00,0.00,0.00,5.00,425.00,'2021-12-30 15:08:22','',''),(2405190,'1','140','773',331,'Retail Sale Id 1431590',2400.00,0.00,0.00,4.00,340.00,'2021-12-30 15:09:24','',''),(2405198,'1','140','773',331,'Retail Sale Id 1431599',9880.00,0.00,0.00,19.00,95.00,'2021-12-30 15:10:25','',''),(2405257,'1','140','773',331,'Retail Sale Id 1431652',3000.00,0.00,0.00,5.00,425.00,'2021-12-30 15:16:16','',''),(2405301,'1','140','773',331,'Retail Sale Id 1431689',7500.00,0.00,0.00,12.50,1062.50,'2021-12-30 15:19:57','',''),(2405313,'1','140','773',331,'Retail Sale Id 1431701',12480.00,0.00,0.00,24.00,120.00,'2021-12-30 15:21:29','',''),(2405362,'1','140','773',331,'Retail Sale Id 1431732',2400.00,0.00,0.00,4.00,340.00,'2021-12-30 15:25:44','',''),(2405428,'1','140','773',331,'Retail Sale Id 1431793',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 15:32:57','',''),(2405494,'1','140','773',331,'Retail Sale Id 1431850',8840.00,0.00,0.00,17.00,85.00,'2021-12-30 15:40:44','',''),(2405521,'1','140','773',331,'Retail Sale Id 1431870',31200.00,0.00,0.00,60.00,300.00,'2021-12-30 15:42:32','',''),(2405658,'1','140','773',331,'Retail Sale Id 1431980',1998.00,0.00,0.00,3.33,283.05,'2021-12-30 15:54:13','',''),(2405735,'1','140','773',331,'Retail Sale Id 1432055',1200.00,0.00,0.00,2.00,170.00,'2021-12-30 16:01:31','',''),(2405820,'1','140','773',331,'Retail Sale Id 1432133',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 16:09:15','',''),(2405899,'1','140','773',331,'Retail Sale Id 1432210',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 16:15:33','',''),(2405914,'1','140','773',331,'Retail Sale Id 1432228',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 16:17:07','',''),(2405967,'1','140','773',331,'Retail Sale Id 1432281',2400.00,0.00,0.00,4.00,340.00,'2021-12-30 16:22:43','',''),(2406042,'1','140','773',331,'Retail Sale Id 1432350',6500.00,0.00,0.00,12.50,62.50,'2021-12-30 16:29:37','',''),(2406053,'1','140','773',331,'Retail Sale Id 1432362',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 16:30:59','',''),(2406081,'1','140','773',331,'Retail Sale Id 1432381',3600.00,0.00,0.00,6.00,510.00,'2021-12-30 16:33:36','',''),(2406097,'1','140','773',331,'Retail Sale Id 1432405',1200.00,0.00,0.00,2.00,170.00,'2021-12-30 16:35:03','',''),(2406130,'1','140','773',331,'Retail Sale Id 1432433',1200.00,0.00,0.00,2.00,170.00,'2021-12-30 16:37:25','',''),(2406168,'1','140','773',331,'Retail Sale Id 1432457',1200.00,0.00,0.00,2.00,170.00,'2021-12-30 16:39:46','',''),(2406208,'1','140','773',331,'Retail Sale Id 1432505',15000.00,0.00,0.00,25.00,2125.00,'2021-12-30 16:44:23','',''),(2406215,'1','140','773',331,'Retail Sale Id 1432510',15000.00,0.00,0.00,25.00,2125.00,'2021-12-30 16:44:49','',''),(2406226,'1','140','773',331,'Retail Sale Id 1432517',4740.00,0.00,0.00,7.90,671.50,'2021-12-30 16:45:53','',''),(2406234,'1','140','773',331,'Retail Sale Id 1432531',1800.00,0.00,0.00,3.00,255.00,'2021-12-30 16:46:58','',''),(2406253,'1','140','773',331,'Retail Sale Id 1432544',619200.00,0.00,0.00,1200.00,1200.00,'2021-12-30 16:50:22','',''),(2406270,'1','140','773',331,'Retail Sale Id 1432563',707952.00,0.00,0.00,1372.00,1372.00,'2021-12-30 16:53:08','',''),(2406277,'1','140','773',331,'Retail Sale Id 1432571',218400.00,0.00,0.00,420.00,2100.00,'2021-12-30 16:53:53','',''),(2406300,'1','140','773',331,'Retail Sale Id 1432588',1200.00,0.00,0.00,2.00,170.00,'2021-12-30 16:55:38','',''),(2406319,'1','140','773',331,'Retail Sale Id 1432606',1200.00,0.00,0.00,2.00,170.00,'2021-12-30 16:58:01','',''),(2406391,'1','140','773',331,'Return of Retail Sale Id 1432571',0.00,218400.00,420.00,0.00,-2100.00,'2021-12-30 17:03:59','',''),(2406398,'1','140','773',331,'Retail Sale Id 1432653',124800.00,0.00,0.00,240.00,1200.00,'2021-12-30 17:04:51','',''),(2408408,'1','140','773',331,'Retail Sale Id 1433801',7500.00,0.00,0.00,12.50,1062.50,'2021-12-31 08:07:53','',''),(2408432,'1','140','773',331,'Retail Sale Id 1433826',7500.00,0.00,0.00,12.50,1062.50,'2021-12-31 08:10:26','',''),(2408437,'1','140','773',331,'Retail Sale Id 1433832',3000.00,0.00,0.00,5.00,425.00,'2021-12-31 08:10:51','',''),(2408447,'1','140','773',331,'Retail Sale Id 1433840',3600.00,0.00,0.00,6.00,510.00,'2021-12-31 08:11:23','',''),(2408457,'1','140','773',331,'Retail Sale Id 1433849',10800.00,0.00,0.00,18.00,1530.00,'2021-12-31 08:12:17','',''),(2408461,'1','140','773',331,'Retail Sale Id 1433854',387000.00,0.00,0.00,750.00,750.00,'2021-12-31 08:12:49','',''),(2408470,'1','140','773',331,'Retail Sale Id 1433863',26000.00,0.00,0.00,50.00,250.00,'2021-12-31 08:13:43','',''),(2408477,'1','140','773',331,'Retail Sale Id 1433870',31200.00,0.00,0.00,60.00,300.00,'2021-12-31 08:14:09','',''),(2408674,'1','140','773',331,'Retail Sale Id 1433993',600.00,0.00,0.00,1.00,85.00,'2021-12-31 08:30:13','',''),(2408895,'1','140','773',331,'Retail Sale Id 1434208',12220.00,0.00,0.00,23.50,117.50,'2021-12-31 08:46:33','',''),(2409988,'1','140','773',331,'Retail Sale Id 1435210',1800.00,0.00,0.00,3.00,255.00,'2021-12-31 10:39:48','',''),(2410011,'1','140','773',331,'Retail Sale Id 1435223',1200.00,0.00,0.00,2.00,170.00,'2021-12-31 10:41:03','',''),(2410022,'1','140','773',331,'Retail Sale Id 1435233',1800.00,0.00,0.00,3.00,255.00,'2021-12-31 10:42:11','',''),(2410034,'1','140','773',331,'Retail Sale Id 1435248',3600.00,0.00,0.00,6.00,510.00,'2021-12-31 10:43:41','',''),(2413616,'1','140','773',331,'Retail Sale Id 1438372',15000.00,0.00,0.00,25.00,2125.00,'2021-12-31 16:48:36','',''),(2413627,'1','140','773',331,'Retail Sale Id 1438379',7500.00,0.00,0.00,12.50,1062.50,'2021-12-31 16:49:44','',''),(2413636,'1','140','773',331,'Retail Sale Id 1438389',7500.00,0.00,0.00,12.50,1062.50,'2021-12-31 16:50:20','',''),(2413645,'1','140','773',331,'Retail Sale Id 1438395',7500.00,0.00,0.00,12.50,1062.50,'2021-12-31 16:51:22','',''),(2413661,'1','140','773',331,'Retail Sale Id 1438415',7500.00,0.00,0.00,12.50,1062.50,'2021-12-31 16:53:06','',''),(2413667,'1','140','773',331,'Retail Sale Id 1438423',7500.00,0.00,0.00,12.50,1062.50,'2021-12-31 16:53:47','',''),(2413679,'1','140','773',331,'Retail Sale Id 1438435',7500.00,0.00,0.00,12.50,1062.50,'2021-12-31 16:54:57','',''),(2413692,'1','140','773',331,'Retail Sale Id 1438442',8400.00,0.00,0.00,14.00,1190.00,'2021-12-31 16:55:42','',''),(2413707,'1','140','773',331,'Retail Sale Id 1438488',145600.00,0.00,0.00,280.00,1400.00,'2021-12-31 16:57:30','',''),(2413715,'1','140','773',331,'Retail Sale Id 1438497',93600.00,0.00,0.00,180.00,900.00,'2021-12-31 16:58:39','',''),(2413751,'1','140','773',331,'Retail Sale Id 1438619',62400.00,0.00,0.00,120.00,600.00,'2021-12-31 17:04:26','',''),(2413758,'1','140','773',331,'Retail Sale Id 1438626',39260.00,0.00,0.00,75.50,377.50,'2021-12-31 17:05:28','',''),(2413864,'1','140','773',331,'Retail Sale Id 1438722',1288968.00,0.00,0.00,2498.00,2498.00,'2021-12-31 17:25:25','',''),(2414450,'1','140','773',331,'Retail Sale Id 1438830',15000.00,0.00,0.00,25.00,2125.00,'2022-01-01 02:03:07','',''),(2414451,'1','140','773',331,'Retail Sale Id 1438831',11100.00,0.00,0.00,18.50,1572.50,'2022-01-01 02:04:14','',''),(2414452,'1','140','773',331,'Retail Sale Id 1438832',3600.00,0.00,0.00,6.00,510.00,'2022-01-01 02:05:09','',''),(2414453,'1','140','773',331,'Retail Sale Id 1438833',7200.00,0.00,0.00,12.00,1020.00,'2022-01-01 02:06:24','',''),(2414454,'1','140','773',331,'Retail Sale Id 1438834',22500.00,0.00,0.00,37.50,3187.50,'2022-01-01 02:07:44','',''),(2414455,'1','140','773',331,'Retail Sale Id 1438835',1800.00,0.00,0.00,3.00,255.00,'2022-01-01 02:08:38','',''),(2414456,'1','140','773',331,'Retail Sale Id 1438836',7500.00,0.00,0.00,12.50,1062.50,'2022-01-01 02:09:35','',''),(2414457,'1','140','773',331,'Retail Sale Id 1438837',3600.00,0.00,0.00,6.00,510.00,'2022-01-01 02:11:34','',''),(2414458,'1','140','773',331,'Retail Sale Id 1438838',4800.00,0.00,0.00,8.00,680.00,'2022-01-01 02:12:31','',''),(2414762,'1','140','773',331,'Retail Sale Id 1439093',7500.00,0.00,0.00,12.50,1062.50,'2022-01-01 07:08:05','',''),(2414764,'1','140','773',331,'Retail Sale Id 1439096',7500.00,0.00,0.00,12.50,1062.50,'2022-01-01 07:08:29','',''),(2414767,'1','140','773',331,'Retail Sale Id 1439099',15000.00,0.00,0.00,25.00,2125.00,'2022-01-01 07:08:54','',''),(2414776,'1','140','773',331,'Retail Sale Id 1439104',7500.00,0.00,0.00,12.50,1062.50,'2022-01-01 07:09:36','',''),(2414783,'1','140','773',331,'Retail Sale Id 1439110',6000.00,0.00,0.00,10.00,850.00,'2022-01-01 07:10:31','',''),(2414784,'1','140','773',331,'Retail Sale Id 1439113',40480.00,0.00,0.00,80.00,-720.00,'2022-01-01 07:10:36','',''),(2414802,'1','140','773',331,'Retail Sale Id 1439130',60720.00,0.00,0.00,120.00,-1080.00,'2022-01-01 07:13:02','',''),(2414805,'1','140','773',331,'Retail Sale Id 1439134',3600.00,0.00,0.00,6.00,510.00,'2022-01-01 07:13:23','',''),(2414818,'1','140','773',331,'Retail Sale Id 1439145',91080.00,0.00,0.00,180.00,-1620.00,'2022-01-01 07:15:25','',''),(2414824,'1','140','773',331,'Retail Sale Id 1439153',25300.00,0.00,0.00,50.00,-450.00,'2022-01-01 07:16:05','',''),(2414832,'1','140','773',331,'Retail Sale Id 1439161',30360.00,0.00,0.00,60.00,-540.00,'2022-01-01 07:17:05','',''),(2414840,'1','140','773',331,'Retail Sale Id 1439170',111320.00,0.00,0.00,220.00,-1980.00,'2022-01-01 07:17:42','',''),(2414847,'1','140','773',331,'Retail Sale Id 1439178',30360.00,0.00,0.00,60.00,-540.00,'2022-01-01 07:18:31','',''),(2414858,'1','140','773',331,'Retail Sale Id 1439188',20240.00,0.00,0.00,40.00,-360.00,'2022-01-01 07:19:45','',''),(2414890,'1','140','773',331,'Retail Sale Id 1439197',60720.00,0.00,0.00,120.00,-1080.00,'2022-01-01 07:20:45','',''),(2414896,'1','140','773',331,'Retail Sale Id 1439203',1800.00,0.00,0.00,3.00,255.00,'2022-01-01 07:21:07','',''),(2414918,'1','140','773',331,'Retail Sale Id 1439205',1800.00,0.00,0.00,3.00,255.00,'2022-01-01 07:23:46','',''),(2414919,'1','140','773',331,'Retail Sale Id 1439225',7500.00,0.00,0.00,12.50,1062.50,'2022-01-01 07:24:11','',''),(2414930,'1','140','773',331,'Retail Sale Id 1439229',6000.00,0.00,0.00,10.00,850.00,'2022-01-01 07:24:33','',''),(2414933,'1','140','773',331,'Retail Sale Id 1439233',1800.00,0.00,0.00,3.00,255.00,'2022-01-01 07:25:06','',''),(2414949,'1','140','773',331,'Retail Sale Id 1439240',2400.00,0.00,0.00,4.00,340.00,'2022-01-01 07:26:15','',''),(2414952,'1','140','773',331,'Retail Sale Id 1439243',14400.00,0.00,0.00,24.00,2040.00,'2022-01-01 07:26:46','',''),(2414958,'1','140','773',331,'Retail Sale Id 1439246',10800.00,0.00,0.00,18.00,1530.00,'2022-01-01 07:27:08','',''),(2414966,'1','140','773',331,'Retail Sale Id 1439252',3600.00,0.00,0.00,6.00,510.00,'2022-01-01 07:28:00','',''),(2414968,'1','140','773',331,'Retail Sale Id 1439256',7500.00,0.00,0.00,12.50,1062.50,'2022-01-01 07:28:35','',''),(2414975,'1','140','773',331,'Retail Sale Id 1439264',9600.00,0.00,0.00,16.00,1360.00,'2022-01-01 07:29:25','',''),(2414985,'1','140','773',331,'Retail Sale Id 1439270',161920.00,0.00,0.00,320.00,-2880.00,'2022-01-01 07:30:29','',''),(2414992,'1','140','773',331,'Retail Sale Id 1439277',7500.00,0.00,0.00,12.50,1062.50,'2022-01-01 07:31:11','',''),(2414995,'1','140','773',331,'Retail Sale Id 1439281',11100.00,0.00,0.00,18.50,1572.50,'2022-01-01 07:31:33','',''),(2415000,'1','140','773',331,'Retail Sale Id 1439282',1800.00,0.00,0.00,3.00,255.00,'2022-01-01 07:32:00','',''),(2415003,'1','140','773',331,'Retail Sale Id 1439290',3000.00,0.00,0.00,5.00,425.00,'2022-01-01 07:32:33','',''),(2415022,'1','140','773',331,'Retail Sale Id 1439300',14400.00,0.00,0.00,24.00,2040.00,'2022-01-01 07:35:50','',''),(2415030,'1','140','773',331,'Retail Sale Id 1439316',10800.00,0.00,0.00,18.00,1530.00,'2022-01-01 07:36:42','',''),(2415035,'1','140','773',331,'Retail Sale Id 1439320',7500.00,0.00,0.00,12.50,1062.50,'2022-01-01 07:37:10','',''),(2415044,'1','140','773',331,'Retail Sale Id 1439330',1800.00,0.00,0.00,3.00,255.00,'2022-01-01 07:38:15','',''),(2415047,'1','140','773',331,'Retail Sale Id 1439334',1800.00,0.00,0.00,3.00,255.00,'2022-01-01 07:38:40','',''),(2415052,'1','140','773',331,'Retail Sale Id 1439338',1800.00,0.00,0.00,3.00,255.00,'2022-01-01 07:39:05','',''),(2415059,'1','140','773',331,'Retail Sale Id 1439344',15000.00,0.00,0.00,25.00,2125.00,'2022-01-01 07:40:16','',''),(2415065,'1','140','773',331,'Retail Sale Id 1439350',3600.00,0.00,0.00,6.00,510.00,'2022-01-01 07:41:12','',''),(2415073,'1','140','773',331,'Retail Sale Id 1439357',1200.00,0.00,0.00,2.00,170.00,'2022-01-01 07:42:09','',''),(2415096,'1','140','773',331,'Retail Sale Id 1439374',7500.00,0.00,0.00,12.50,1062.50,'2022-01-01 07:44:00','',''),(2415100,'1','140','773',331,'Retail Sale Id 1439379',7500.00,0.00,0.00,12.50,1062.50,'2022-01-01 07:44:29','',''),(2415103,'1','140','773',331,'Retail Sale Id 1439382',7500.00,0.00,0.00,12.50,1062.50,'2022-01-01 07:44:56','',''),(2415115,'1','140','773',331,'Retail Sale Id 1439394',3000.00,0.00,0.00,5.00,425.00,'2022-01-01 07:46:00','',''),(2415122,'1','140','773',331,'Retail Sale Id 1439401',5940.00,0.00,0.00,9.90,841.50,'2022-01-01 07:46:42','',''),(2415150,'1','140','773',331,'Retail Sale Id 1439414',3000.00,0.00,0.00,5.00,425.00,'2022-01-01 07:47:36','',''),(2415230,'1','140','773',331,'Return of Retail Sale Id 1439357',0.00,1200.00,2.00,0.00,-170.00,'2022-01-01 07:51:30','',''),(2415273,'1','140','773',331,'Retail Sale Id 1439467',1405600.00,0.00,0.00,2800.00,-36400.00,'2022-01-01 07:55:03','',''),(2415404,'1','140','773',331,'Retail Sale Id 1439584',55660.00,0.00,0.00,110.00,-990.00,'2022-01-01 08:07:00','',''),(2415762,'1','140','773',331,'Retail Sale Id 1439918',7500.00,0.00,0.00,12.50,1062.50,'2022-01-01 08:37:56','',''),(2415781,'1','140','773',331,'Retail Sale Id 1439921',7500.00,0.00,0.00,12.50,1062.50,'2022-01-01 08:39:48','',''),(2415826,'1','140','773',331,'Retail Sale Id 1439973',3600.00,0.00,0.00,6.00,510.00,'2022-01-01 08:42:54','',''),(2415835,'1','140','773',331,'Retail Sale Id 1439982',1200.00,0.00,0.00,2.00,170.00,'2022-01-01 08:43:22','',''),(2416062,'1','140','773',331,'Retail Sale Id 1440180',30360.00,0.00,0.00,60.00,-540.00,'2022-01-01 09:05:03','',''),(2416067,'1','140','773',331,'Retail Sale Id 1440187',30360.00,0.00,0.00,60.00,-540.00,'2022-01-01 09:05:36','',''),(2416074,'1','140','773',331,'Retail Sale Id 1440193',30360.00,0.00,0.00,60.00,-540.00,'2022-01-01 09:06:33','',''),(2416094,'1','140','773',331,'Retail Sale Id 1440204',75900.00,0.00,0.00,150.00,-1350.00,'2022-01-01 09:09:47','',''),(2416126,'1','140','773',331,'Retail Sale Id 1440247',30360.00,0.00,0.00,60.00,-540.00,'2022-01-01 09:13:52','',''),(2416156,'1','140','773',331,'Retail Sale Id 1440275',7500.00,0.00,0.00,12.50,1062.50,'2022-01-01 09:16:48','',''),(2416181,'1','140','773',331,'Retail Sale Id 1440301',10800.00,0.00,0.00,18.00,1530.00,'2022-01-01 09:19:27','',''),(2416196,'1','140','773',331,'Retail Sale Id 1440314',14400.00,0.00,0.00,24.00,2040.00,'2022-01-01 09:20:54','',''),(2416202,'1','140','773',331,'Retail Sale Id 1440320',3600.00,0.00,0.00,6.00,510.00,'2022-01-01 09:21:21','',''),(2416206,'1','140','773',331,'Retail Sale Id 1440324',7500.00,0.00,0.00,12.50,1062.50,'2022-01-01 09:21:51','',''),(2416210,'1','140','773',331,'Retail Sale Id 1440326',7500.00,0.00,0.00,12.50,1062.50,'2022-01-01 09:22:20','',''),(2416277,'1','140','773',331,'Retail Sale Id 1440381',1800.00,0.00,0.00,3.00,255.00,'2022-01-01 09:27:17','',''),(2416421,'1','140','773',331,'Retail Sale Id 1440501',1200.00,0.00,0.00,2.00,170.00,'2022-01-01 09:40:03','',''),(2416514,'1','140','773',331,'Retail Sale Id 1440587',600.00,0.00,0.00,1.00,85.00,'2022-01-01 09:49:36','',''),(2416692,'1','140','773',331,'Retail Sale Id 1440727',1200.00,0.00,0.00,2.00,170.00,'2022-01-01 10:07:34','',''),(2416709,'1','140','773',331,'Retail Sale Id 1440737',1200.00,0.00,0.00,2.00,170.00,'2022-01-01 10:09:30','',''),(2416746,'1','140','773',331,'Retail Sale Id 1440777',1800.00,0.00,0.00,3.00,255.00,'2022-01-01 10:13:28','',''),(2416835,'1','140','773',331,'Retail Sale Id 1440868',1800.00,0.00,0.00,3.00,255.00,'2022-01-01 10:22:11','',''),(2416883,'1','140','773',331,'Retail Sale Id 1440913',3750.00,0.00,0.00,6.25,531.25,'2022-01-01 10:27:32','',''),(2416892,'1','140','773',331,'Retail Sale Id 1440921',1200.00,0.00,0.00,2.00,170.00,'2022-01-01 10:28:32','',''),(2416956,'1','140','773',331,'Retail Sale Id 1440971',60720.00,0.00,0.00,120.00,-1080.00,'2022-01-01 10:34:56','',''),(2416992,'1','140','773',331,'Retail Sale Id 1441002',87538.00,0.00,0.00,173.00,-1557.00,'2022-01-01 10:39:43','',''),(2417004,'1','140','773',331,'Retail Sale Id 1441016',30360.00,0.00,0.00,60.00,-540.00,'2022-01-01 10:41:06','',''),(2417028,'1','140','773',331,'Retail Sale Id 1441033',91080.00,0.00,0.00,180.00,-1620.00,'2022-01-01 10:43:33','',''),(2417140,'1','140','773',331,'Retail Sale Id 1441137',3000.00,0.00,0.00,5.00,425.00,'2022-01-01 10:54:58','',''),(2417158,'1','140','773',331,'Retail Sale Id 1441151',1800.00,0.00,0.00,3.00,255.00,'2022-01-01 10:56:43','',''),(2417202,'1','140','773',331,'Retail Sale Id 1441191',1800.00,0.00,0.00,3.00,255.00,'2022-01-01 11:01:33','',''),(2417421,'1','140','773',331,'Retail Sale Id 1441399',1200.00,0.00,0.00,2.00,170.00,'2022-01-01 11:26:52','',''),(2417429,'1','140','773',331,'Retail Sale Id 1441406',80960.00,0.00,0.00,160.00,-1440.00,'2022-01-01 11:27:49','',''),(2417442,'1','140','773',331,'Retail Sale Id 1441421',30360.00,0.00,0.00,60.00,-540.00,'2022-01-01 11:29:28','',''),(2417449,'1','140','773',331,'Retail Sale Id 1441430',25300.00,0.00,0.00,50.00,-450.00,'2022-01-01 11:30:00','',''),(2417491,'1','140','773',331,'Retail Sale Id 1441466',1002.00,0.00,0.00,1.67,141.95,'2022-01-01 11:33:46','',''),(2417503,'1','140','773',331,'Retail Sale Id 1441479',3600.00,0.00,0.00,6.00,510.00,'2022-01-01 11:34:56','',''),(2417510,'1','140','773',331,'Retail Sale Id 1441488',1002.00,0.00,0.00,1.67,141.95,'2022-01-01 11:35:41','',''),(2417534,'1','140','773',331,'Retail Sale Id 1441503',3000.00,0.00,0.00,5.00,425.00,'2022-01-01 11:37:27','',''),(2417563,'1','140','773',331,'Retail Sale Id 1441536',1800.00,0.00,0.00,3.00,255.00,'2022-01-01 11:40:49','',''),(2417783,'1','140',NULL,331,'Purchased from AA RANO NIGERIA LIMITED',0.00,12741100.00,24740.00,0.00,0.00,'2022-01-01 12:05:52','',''),(2417794,'1','140',NULL,331,'Reception corrector for bridging 129416',0.00,0.00,0.00,24740.00,0.00,'2022-01-01 12:07:45','',''),(2417795,'1','140','773',331,'Received from bridging 129416',0.00,0.00,24740.00,0.00,0.00,'2022-01-01 12:07:45','',''),(2417842,'1','140','773',331,'Retail Sale Id 1441730',7500.00,0.00,0.00,12.50,1062.50,'2022-01-01 12:13:49','',''),(2417856,'1','140','773',331,'Retail Sale Id 1441825',1200.00,0.00,0.00,2.00,170.00,'2022-01-01 12:15:43','',''),(2417869,'1','140','773',331,'Retail Sale Id 1441838',3000.00,0.00,0.00,5.00,425.00,'2022-01-01 12:17:55','',''),(2417879,'1','140','773',331,'Retail Sale Id 1441850',1800.00,0.00,0.00,3.00,255.00,'2022-01-01 12:19:14','',''),(2418161,'1','140','773',331,'Retail Sale Id 1442108',1200.00,0.00,0.00,2.00,170.00,'2022-01-01 12:47:43','',''),(2418240,'1','140','773',331,'Retail Sale Id 1442184',1200.00,0.00,0.00,2.00,170.00,'2022-01-01 12:58:55','',''),(2418253,'1','140','773',331,'Retail Sale Id 1442198',1800.00,0.00,0.00,3.00,255.00,'2022-01-01 13:00:47','',''),(2418487,'1','140','773',331,'Retail Sale Id 1442384',1200.00,0.00,0.00,2.00,170.00,'2022-01-01 13:31:49','',''),(2418522,'1','140','773',331,'Retail Sale Id 1442393',42504.00,0.00,0.00,84.00,-756.00,'2022-01-01 13:36:49','',''),(2418575,'1','140','773',331,'Retail Sale Id 1442425',50600.00,0.00,0.00,100.00,-900.00,'2022-01-01 13:42:06','',''),(2418587,'1','140','773',331,'Retail Sale Id 1442470',25300.00,0.00,0.00,50.00,-450.00,'2022-01-01 13:43:26','',''),(2418605,'1','140','773',331,'Retail Sale Id 1442476',3000.00,0.00,0.00,5.00,425.00,'2022-01-01 13:44:23','',''),(2418705,'1','140','773',331,'Retail Sale Id 1442557',1200.00,0.00,0.00,2.00,170.00,'2022-01-01 13:57:52','',''),(2418828,'1','140','773',331,'Retail Sale Id 1442666',3600.00,0.00,0.00,6.00,510.00,'2022-01-01 14:19:06','',''),(2419334,'1','140','773',331,'Retail Sale Id 1443030',1200.00,0.00,0.00,2.00,170.00,'2022-01-01 15:30:17','',''),(2419456,'1','140','773',331,'Retail Sale Id 1443135',3600.00,0.00,0.00,6.00,510.00,'2022-01-01 15:47:58','',''),(2419614,'1','140','773',331,'Retail Sale Id 1443273',161920.00,0.00,0.00,320.00,-2880.00,'2022-01-01 16:07:51','',''),(2419625,'1','140','773',331,'Retail Sale Id 1443283',3000.00,0.00,0.00,5.00,425.00,'2022-01-01 16:08:45','',''),(2419663,'1','140','773',331,'Retail Sale Id 1443322',903600.00,0.00,0.00,1800.00,-23400.00,'2022-01-01 16:14:00','',''),(2419932,'1','140','773',331,'Retail Sale Id 1443508',1200.00,0.00,0.00,2.00,170.00,'2022-01-01 16:47:00','',''),(2420106,'1','140','773',331,'Retail Sale Id 1443667',11100.00,0.00,0.00,18.50,1572.50,'2022-01-01 17:23:48','',''),(2420125,'1','140','773',331,'Retail Sale Id 1443686',161920.00,0.00,0.00,320.00,-2880.00,'2022-01-01 17:27:41','',''),(2420128,'1','140','773',331,'Retail Sale Id 1443689',91586.00,0.00,0.00,181.00,-1629.00,'2022-01-01 17:28:16','',''),(2422242,'1','140','773',331,'Retail Sale Id 1445092',1002.00,0.00,0.00,1.67,141.95,'2022-01-02 09:48:39','',''),(2422298,'1','140','773',331,'Retail Sale Id 1445140',7500.00,0.00,0.00,12.50,1062.50,'2022-01-02 09:55:29','',''),(2422302,'1','140','773',331,'Retail Sale Id 1445146',7500.00,0.00,0.00,12.50,1062.50,'2022-01-02 09:55:56','',''),(2422307,'1','140','773',331,'Retail Sale Id 1445149',1200.00,0.00,0.00,2.00,170.00,'2022-01-02 09:56:26','',''),(2422368,'1','140','773',331,'Retail Sale Id 1445210',1200.00,0.00,0.00,2.00,170.00,'2022-01-02 10:05:45','',''),(2422405,'1','140','773',331,'Retail Sale Id 1445244',27830.00,0.00,0.00,55.00,-495.00,'2022-01-02 10:08:58','',''),(2422691,'1','140','773',331,'Retail Sale Id 1445472',1800.00,0.00,0.00,3.00,255.00,'2022-01-02 10:37:11','',''),(2422814,'1','140','773',331,'Retail Sale Id 1445604',60720.00,0.00,0.00,120.00,-1080.00,'2022-01-02 10:51:12','',''),(2422841,'1','140','773',331,'Retail Sale Id 1445618',2400.00,0.00,0.00,4.00,340.00,'2022-01-02 10:53:06','',''),(2422930,'1','140','773',331,'Retail Sale Id 1445710',27830.00,0.00,0.00,55.00,-495.00,'2022-01-02 11:03:08','',''),(2422942,'1','140','773',331,'Retail Sale Id 1445724',83490.00,0.00,0.00,165.00,-1485.00,'2022-01-02 11:04:19','',''),(2422951,'1','140','773',331,'Retail Sale Id 1445734',1200.00,0.00,0.00,2.00,170.00,'2022-01-02 11:05:49','',''),(2422971,'1','140','773',331,'Retail Sale Id 1445750',1800.00,0.00,0.00,3.00,255.00,'2022-01-02 11:07:42','',''),(2422996,'1','140','773',331,'Retail Sale Id 1445772',600.00,0.00,0.00,1.00,85.00,'2022-01-02 11:09:50','',''),(2423115,'1','140','773',331,'Retail Sale Id 1445885',30360.00,0.00,0.00,60.00,-540.00,'2022-01-02 11:21:46','',''),(2423167,'1','140','773',331,'Retail Sale Id 1445942',50600.00,0.00,0.00,100.00,-900.00,'2022-01-02 11:26:57','',''),(2423177,'1','140','773',331,'Retail Sale Id 1445953',1800.00,0.00,0.00,3.00,255.00,'2022-01-02 11:27:48','',''),(2423197,'1','140','773',331,'Retail Sale Id 1445975',25300.00,0.00,0.00,50.00,-450.00,'2022-01-02 11:30:04','',''),(2423280,'1','140','773',331,'Retail Sale Id 1446058',70840.00,0.00,0.00,140.00,-1260.00,'2022-01-02 11:39:35','',''),(2423322,'1','140','773',331,'Retail Sale Id 1446098',1800.00,0.00,0.00,3.00,255.00,'2022-01-02 11:44:07','',''),(2423335,'1','140','773',331,'Retail Sale Id 1446113',12144.00,0.00,0.00,24.00,-216.00,'2022-01-02 11:46:24','',''),(2423355,'1','140','773',331,'Retail Sale Id 1446132',1200.00,0.00,0.00,2.00,170.00,'2022-01-02 11:48:59','',''),(2423371,'1','140','773',331,'Retail Sale Id 1446150',600.00,0.00,0.00,1.00,85.00,'2022-01-02 11:51:50','',''),(2423378,'1','140','773',331,'Retail Sale Id 1446156',30360.00,0.00,0.00,60.00,-540.00,'2022-01-02 11:53:19','',''),(2423413,'1','140','773',331,'Retail Sale Id 1446193',7500.00,0.00,0.00,12.50,1062.50,'2022-01-02 11:58:38','',''),(2423491,'1','140','773',331,'Retail Sale Id 1446255',15180.00,0.00,0.00,30.00,-270.00,'2022-01-02 12:07:32','',''),(2423497,'1','140','773',331,'Retail Sale Id 1446271',1800.00,0.00,0.00,3.00,255.00,'2022-01-02 12:08:55','',''),(2423537,'1','140','773',331,'Retail Sale Id 1446314',1800.00,0.00,0.00,3.00,255.00,'2022-01-02 12:15:14','',''),(2423590,'1','140','773',331,'Retail Sale Id 1446369',1200.00,0.00,0.00,2.00,170.00,'2022-01-02 12:22:03','',''),(2423604,'1','140','773',331,'Retail Sale Id 1446381',3600.00,0.00,0.00,6.00,510.00,'2022-01-02 12:23:57','',''),(2423625,'1','140','773',331,'Retail Sale Id 1446398',600.00,0.00,0.00,1.00,85.00,'2022-01-02 12:26:31','',''),(2423641,'1','140','773',331,'Retail Sale Id 1446418',7500.00,0.00,0.00,12.50,1062.50,'2022-01-02 12:28:59','',''),(2423665,'1','140','773',331,'Retail Sale Id 1446435',3600.00,0.00,0.00,6.00,510.00,'2022-01-02 12:31:18','',''),(2423688,'1','140','773',331,'Retail Sale Id 1446459',1800.00,0.00,0.00,3.00,255.00,'2022-01-02 12:34:24','',''),(2423797,'1','140','773',331,'Retail Sale Id 1446581',2400.00,0.00,0.00,4.00,340.00,'2022-01-02 12:45:45','',''),(2423884,'1','140','773',331,'Retail Sale Id 1446675',1800.00,0.00,0.00,3.00,255.00,'2022-01-02 12:56:09','',''),(2423973,'1','140','773',331,'Retail Sale Id 1446759',11132.00,0.00,0.00,22.00,-198.00,'2022-01-02 13:07:39','',''),(2424143,'1','140','773',331,'Retail Sale Id 1446930',1200.00,0.00,0.00,2.00,170.00,'2022-01-02 13:31:36','',''),(2424214,'1','140','773',331,'Retail Sale Id 1447011',600.00,0.00,0.00,1.00,85.00,'2022-01-02 13:42:32','',''),(2424223,'1','140','773',331,'Retail Sale Id 1447023',3600.00,0.00,0.00,6.00,510.00,'2022-01-02 13:44:04','',''),(2424291,'1','140','773',331,'Retail Sale Id 1447075',1500.00,0.00,0.00,2.50,212.50,'2022-01-02 13:52:36','',''),(2424378,'1','140','773',331,'Retail Sale Id 1447122',3600.00,0.00,0.00,6.00,510.00,'2022-01-02 14:00:49','',''),(2424394,'1','140','773',331,'Retail Sale Id 1447136',1800.00,0.00,0.00,3.00,255.00,'2022-01-02 14:02:30','',''),(2424525,'1','140','773',331,'Retail Sale Id 1447211',1800.00,0.00,0.00,3.00,255.00,'2022-01-02 14:11:39','',''),(2424546,'1','140','773',331,'Retail Sale Id 1447231',7500.00,0.00,0.00,12.50,1062.50,'2022-01-02 14:14:12','',''),(2424626,'1','140','773',331,'Retail Sale Id 1447279',2400.00,0.00,0.00,4.00,340.00,'2022-01-02 14:20:17','',''),(2424705,'1','140','773',331,'Retail Sale Id 1447334',247988.00,0.00,0.00,494.00,-6422.00,'2022-01-02 14:27:56','',''),(2424708,'1','140','773',331,'Return of Retail Sale Id 1447334',0.00,247988.00,494.00,0.00,6422.00,'2022-01-02 14:28:23','',''),(2424716,'1','140','773',331,'Retail Sale Id 1447345',450294.00,0.00,0.00,897.00,-11661.00,'2022-01-02 14:29:29','',''),(2424719,'1','140','773',331,'Retail Sale Id 1447348',13662.00,0.00,0.00,27.00,-243.00,'2022-01-02 14:30:12','',''),(2424796,'1','140','773',331,'Retail Sale Id 1447417',42504.00,0.00,0.00,84.00,-756.00,'2022-01-02 14:37:55','',''),(2424911,'1','140','773',331,'Retail Sale Id 1447523',12144.00,0.00,0.00,24.00,-216.00,'2022-01-02 14:55:49','',''),(2424999,'1','140','773',331,'Retail Sale Id 1447559',960.00,0.00,0.00,1.60,136.00,'2022-01-02 15:01:25','',''),(2425004,'1','140','773',331,'Retail Sale Id 1447569',3600.00,0.00,0.00,6.00,510.00,'2022-01-02 15:02:07','',''),(2425021,'1','140','773',331,'Retail Sale Id 1447589',1255000.00,0.00,0.00,2500.00,-32500.00,'2022-01-02 15:04:21','',''),(2425149,'1','140','773',331,'Retail Sale Id 1447721',25300.00,0.00,0.00,50.00,-450.00,'2022-01-02 15:28:40','',''),(2425156,'1','140','773',331,'Retail Sale Id 1447732',1200.00,0.00,0.00,2.00,170.00,'2022-01-02 15:29:13','',''),(2426359,'1','140','773',331,'Retail Sale Id 1448527',27830.00,0.00,0.00,55.00,-495.00,'2022-01-03 06:12:19','',''),(2426368,'1','140','773',331,'Retail Sale Id 1448529',11132.00,0.00,0.00,22.00,-198.00,'2022-01-03 06:14:15','',''),(2426488,'1','140','773',331,'Retail Sale Id 1448581',3000.00,0.00,0.00,5.00,425.00,'2022-01-03 06:42:21','',''),(2426542,'1','140','773',331,'Retail Sale Id 1448623',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 06:53:42','',''),(2426706,'1','140','773',331,'Retail Sale Id 1448765',1800.00,0.00,0.00,3.00,255.00,'2022-01-03 07:21:54','',''),(2426718,'1','140','773',331,'Retail Sale Id 1448821',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 07:23:34','',''),(2426724,'1','140','773',331,'Retail Sale Id 1448825',30360.00,0.00,0.00,60.00,-540.00,'2022-01-03 07:24:58','',''),(2426735,'1','140','773',331,'Retail Sale Id 1448837',1002.00,0.00,0.00,1.67,141.95,'2022-01-03 07:26:44','',''),(2426768,'1','140','773',331,'Retail Sale Id 1448868',1800.00,0.00,0.00,3.00,255.00,'2022-01-03 07:31:08','',''),(2426836,'1','140','773',331,'Retail Sale Id 1448946',1800.00,0.00,0.00,3.00,255.00,'2022-01-03 07:42:09','',''),(2426846,'1','140','773',331,'Retail Sale Id 1448956',9108.00,0.00,0.00,18.00,-162.00,'2022-01-03 07:43:31','',''),(2426883,'1','140','773',331,'Retail Sale Id 1448985',25300.00,0.00,0.00,50.00,-450.00,'2022-01-03 07:47:24','',''),(2426950,'1','140','773',331,'Retail Sale Id 1449021',30360.00,0.00,0.00,60.00,-540.00,'2022-01-03 07:52:32','',''),(2426982,'1','140','773',331,'Retail Sale Id 1449031',25300.00,0.00,0.00,50.00,-450.00,'2022-01-03 07:54:47','',''),(2426996,'1','140','773',331,'Retail Sale Id 1449049',11638.00,0.00,0.00,23.00,-207.00,'2022-01-03 07:56:04','',''),(2427086,'1','140','773',331,'Retail Sale Id 1449116',4200.00,0.00,0.00,7.00,595.00,'2022-01-03 08:07:29','',''),(2427112,'1','140','773',331,'Retail Sale Id 1449141',1800.00,0.00,0.00,3.00,255.00,'2022-01-03 08:11:14','',''),(2427125,'1','140','773',331,'Retail Sale Id 1449155',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 08:13:05','',''),(2427142,'1','140','773',331,'Retail Sale Id 1449172',3000.00,0.00,0.00,5.00,425.00,'2022-01-03 08:15:57','',''),(2427164,'1','140','773',331,'Retail Sale Id 1449192',7200.00,0.00,0.00,12.00,1020.00,'2022-01-03 08:18:50','',''),(2427299,'1','140','773',331,'Retail Sale Id 1449324',12650.00,0.00,0.00,25.00,-225.00,'2022-01-03 08:36:33','',''),(2427361,'1','140','773',331,'Retail Sale Id 1449391',39468.00,0.00,0.00,78.00,-702.00,'2022-01-03 08:43:53','',''),(2427412,'1','140','773',331,'Retail Sale Id 1449447',1500.00,0.00,0.00,2.50,212.50,'2022-01-03 08:49:10','',''),(2427442,'1','140','773',331,'Retail Sale Id 1449470',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 08:51:12','',''),(2427502,'1','140','773',331,'Retail Sale Id 1449526',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 08:57:13','',''),(2427561,'1','140','773',331,'Retail Sale Id 1449552',25300.00,0.00,0.00,50.00,-450.00,'2022-01-03 09:00:03','',''),(2427585,'1','140','773',331,'Retail Sale Id 1449578',12144.00,0.00,0.00,24.00,-216.00,'2022-01-03 09:02:01','',''),(2427705,'1','140','773',331,'Retail Sale Id 1449689',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 09:16:32','',''),(2427734,'1','140','773',331,'Retail Sale Id 1449721',41998.00,0.00,0.00,83.00,-747.00,'2022-01-03 09:19:19','',''),(2427748,'1','140','773',331,'Retail Sale Id 1449733',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 09:20:38','',''),(2427793,'1','140','773',331,'Retail Sale Id 1449776',3000.00,0.00,0.00,5.00,425.00,'2022-01-03 09:26:24','',''),(2427818,'1','140','773',331,'Retail Sale Id 1449800',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 09:29:42','',''),(2427890,'1','140','773',331,'Retail Sale Id 1449884',7500.00,0.00,0.00,12.50,1062.50,'2022-01-03 09:38:24','',''),(2428052,'1','140','773',331,'Retail Sale Id 1450042',25300.00,0.00,0.00,50.00,-450.00,'2022-01-03 09:58:02','',''),(2428240,'1','140','773',331,'Retail Sale Id 1450203',7500.00,0.00,0.00,12.50,1062.50,'2022-01-03 10:19:53','',''),(2428264,'1','140','773',331,'Retail Sale Id 1450229',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 10:22:58','',''),(2428290,'1','140','773',331,'Retail Sale Id 1450250',3600.00,0.00,0.00,6.00,510.00,'2022-01-03 10:26:10','',''),(2428345,'1','140','773',331,'Retail Sale Id 1450308',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 10:31:31','',''),(2428384,'1','140','773',331,'Retail Sale Id 1450342',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 10:35:44','',''),(2428403,'1','140','773',331,'Retail Sale Id 1450361',2400.00,0.00,0.00,4.00,340.00,'2022-01-03 10:37:28','',''),(2428423,'1','140','773',331,'Retail Sale Id 1450381',15180.00,0.00,0.00,30.00,-270.00,'2022-01-03 10:39:38','',''),(2428441,'1','140','773',331,'Retail Sale Id 1450399',15180.00,0.00,0.00,30.00,-270.00,'2022-01-03 10:41:43','',''),(2428476,'1','140','773',331,'Retail Sale Id 1450433',30360.00,0.00,0.00,60.00,-540.00,'2022-01-03 10:46:19','',''),(2428577,'1','140','773',331,'Retail Sale Id 1450533',2400.00,0.00,0.00,4.00,340.00,'2022-01-03 11:00:40','',''),(2428609,'1','140','773',331,'Retail Sale Id 1450565',3600.00,0.00,0.00,6.00,510.00,'2022-01-03 11:03:58','',''),(2428659,'1','140','773',331,'Retail Sale Id 1450613',24794.00,0.00,0.00,49.00,-441.00,'2022-01-03 11:10:18','',''),(2428672,'1','140','773',331,'Retail Sale Id 1450625',30000.00,0.00,0.00,50.00,4250.00,'2022-01-03 11:12:03','',''),(2428696,'1','140','773',331,'Retail Sale Id 1450651',600.00,0.00,0.00,1.00,85.00,'2022-01-03 11:14:46','',''),(2428765,'1','140','773',331,'Retail Sale Id 1450702',25300.00,0.00,0.00,50.00,-450.00,'2022-01-03 11:21:18','',''),(2428851,'1','140','773',331,'Retail Sale Id 1450779',30360.00,0.00,0.00,60.00,-540.00,'2022-01-03 11:31:20','',''),(2428911,'1','140','773',331,'Retail Sale Id 1450823',30360.00,0.00,0.00,60.00,-540.00,'2022-01-03 11:39:08','',''),(2428927,'1','140','773',331,'Retail Sale Id 1450838',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 11:41:20','',''),(2428934,'1','140','773',331,'Retail Sale Id 1450846',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 11:42:27','',''),(2428943,'1','140','773',331,'Retail Sale Id 1450854',1800.00,0.00,0.00,3.00,255.00,'2022-01-03 11:43:31','',''),(2428962,'1','140','773',331,'Retail Sale Id 1450869',1800.00,0.00,0.00,3.00,255.00,'2022-01-03 11:46:18','',''),(2428974,'1','140','773',331,'Retail Sale Id 1450884',1800.00,0.00,0.00,3.00,255.00,'2022-01-03 11:48:15','',''),(2429005,'1','140','773',331,'Retail Sale Id 1450911',7500.00,0.00,0.00,12.50,1062.50,'2022-01-03 11:51:54','',''),(2429052,'1','140','773',331,'Retail Sale Id 1450954',25300.00,0.00,0.00,50.00,-450.00,'2022-01-03 11:56:46','',''),(2429155,'1','140','773',331,'Retail Sale Id 1451058',1800.00,0.00,0.00,3.00,255.00,'2022-01-03 12:12:45','',''),(2429264,'1','140','773',331,'Retail Sale Id 1451173',3600.00,0.00,0.00,6.00,510.00,'2022-01-03 12:27:08','',''),(2429461,'1','140','773',331,'Retail Sale Id 1451333',32890.00,0.00,0.00,65.00,-585.00,'2022-01-03 12:50:13','',''),(2429479,'1','140','773',331,'Retail Sale Id 1451351',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 12:52:32','',''),(2429496,'1','140','773',331,'Retail Sale Id 1451367',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 12:54:48','',''),(2429575,'1','140','773',331,'Retail Sale Id 1451436',29854.00,0.00,0.00,59.00,-531.00,'2022-01-03 13:05:45','',''),(2429630,'1','140','773',331,'Retail Sale Id 1451500',12144.00,0.00,0.00,24.00,-216.00,'2022-01-03 13:10:22','',''),(2429669,'1','140','773',331,'Retail Sale Id 1451537',3600.00,0.00,0.00,6.00,510.00,'2022-01-03 13:13:53','',''),(2429754,'1','140','773',331,'Retail Sale Id 1451590',1800.00,0.00,0.00,3.00,255.00,'2022-01-03 13:19:56','',''),(2429760,'1','140','773',331,'Retail Sale Id 1451602',1244207.00,0.00,0.00,2478.50,-32220.50,'2022-01-03 13:21:19','',''),(2429832,'1','140','773',331,'Retail Sale Id 1451668',30360.00,0.00,0.00,60.00,-540.00,'2022-01-03 13:28:45','',''),(2429858,'1','140','773',331,'Retail Sale Id 1451693',30360.00,0.00,0.00,60.00,-540.00,'2022-01-03 13:31:03','',''),(2429893,'1','140','773',331,'Retail Sale Id 1451725',25300.00,0.00,0.00,50.00,-450.00,'2022-01-03 13:33:52','',''),(2429935,'1','140','773',331,'Retail Sale Id 1451762',34408.00,0.00,0.00,68.00,-612.00,'2022-01-03 13:37:14','',''),(2430032,'1','140','773',331,'Retail Sale Id 1451816',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 13:43:09','',''),(2430113,'1','140','773',331,'Retail Sale Id 1451863',900.00,0.00,0.00,1.50,127.50,'2022-01-03 13:48:20','',''),(2430228,'1','140','773',331,'Retail Sale Id 1451953',600.00,0.00,0.00,1.00,85.00,'2022-01-03 13:57:35','',''),(2430336,'1','140','773',331,'Retail Sale Id 1452033',1800.00,0.00,0.00,3.00,255.00,'2022-01-03 14:05:31','',''),(2430639,'1','140','773',331,'Retail Sale Id 1452253',1800.00,0.00,0.00,3.00,255.00,'2022-01-03 14:35:33','',''),(2430854,'1','140','773',331,'Retail Sale Id 1452390',30360.00,0.00,0.00,60.00,-540.00,'2022-01-03 14:50:25','',''),(2430907,'1','140','773',331,'Retail Sale Id 1452428',1800.00,0.00,0.00,3.00,255.00,'2022-01-03 14:55:31','',''),(2430929,'1','140','773',331,'Retail Sale Id 1452457',600.00,0.00,0.00,1.00,85.00,'2022-01-03 14:58:08','',''),(2430951,'1','140','773',331,'Retail Sale Id 1452482',7500.00,0.00,0.00,12.50,1062.50,'2022-01-03 15:01:42','',''),(2431023,'1','140','773',331,'Retail Sale Id 1452549',1800.00,0.00,0.00,3.00,255.00,'2022-01-03 15:09:29','',''),(2431063,'1','140','773',331,'Retail Sale Id 1452578',1800.00,0.00,0.00,3.00,255.00,'2022-01-03 15:12:59','',''),(2431130,'1','140','773',331,'Retail Sale Id 1452624',3000.00,0.00,0.00,5.00,425.00,'2022-01-03 15:19:16','',''),(2431313,'1','140','773',331,'Retail Sale Id 1452740',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 15:34:02','',''),(2431325,'1','140','773',331,'Retail Sale Id 1452754',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 15:35:04','',''),(2431473,'1','140','773',331,'Retail Sale Id 1452892',29348.00,0.00,0.00,58.00,-522.00,'2022-01-03 15:48:34','',''),(2431489,'1','140','773',331,'Retail Sale Id 1452919',25300.00,0.00,0.00,50.00,-450.00,'2022-01-03 15:50:19','',''),(2431504,'1','140','773',331,'Retail Sale Id 1452931',11638.00,0.00,0.00,23.00,-207.00,'2022-01-03 15:51:33','',''),(2431521,'1','140','773',331,'Retail Sale Id 1452947',21758.00,0.00,0.00,43.00,-387.00,'2022-01-03 15:53:05','',''),(2431568,'1','140','773',331,'Retail Sale Id 1452990',7500.00,0.00,0.00,12.50,1062.50,'2022-01-03 15:57:07','',''),(2431630,'1','140','773',331,'Retail Sale Id 1453052',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 16:02:18','',''),(2431638,'1','140','773',331,'Retail Sale Id 1453061',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 16:03:21','',''),(2431686,'1','140','773',331,'Retail Sale Id 1453109',25300.00,0.00,0.00,50.00,-450.00,'2022-01-03 16:07:49','',''),(2431708,'1','140','773',331,'Retail Sale Id 1453130',1800.00,0.00,0.00,3.00,255.00,'2022-01-03 16:10:22','',''),(2431835,'1','140','773',331,'Retail Sale Id 1453249',3600.00,0.00,0.00,6.00,510.00,'2022-01-03 16:22:01','',''),(2431940,'1','140','773',331,'Retail Sale Id 1453355',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 16:31:06','',''),(2431966,'1','140','773',331,'Retail Sale Id 1453380',1800.00,0.00,0.00,3.00,255.00,'2022-01-03 16:33:36','',''),(2432031,'1','140','773',331,'Retail Sale Id 1453431',23276.00,0.00,0.00,46.00,-414.00,'2022-01-03 16:39:57','',''),(2432114,'1','140','773',331,'Retail Sale Id 1453508',25300.00,0.00,0.00,50.00,-450.00,'2022-01-03 16:52:09','',''),(2432134,'1','140','773',331,'Retail Sale Id 1453524',1200.00,0.00,0.00,2.00,170.00,'2022-01-03 16:55:06','',''),(2432143,'1','140','773',331,'Retail Sale Id 1453535',1800.00,0.00,0.00,3.00,255.00,'2022-01-03 16:56:17','',''),(2432158,'1','140','773',331,'Retail Sale Id 1453543',1800.00,0.00,0.00,3.00,255.00,'2022-01-03 16:57:23','',''),(2432178,'1','140','773',331,'Retail Sale Id 1453557',3000.00,0.00,0.00,5.00,425.00,'2022-01-03 16:59:33','',''),(2432220,'1','140','773',331,'Retail Sale Id 1453594',968107.00,0.00,0.00,1928.50,-25070.50,'2022-01-03 17:05:12','',''),(2432243,'1','140','773',331,'Retail Sale Id 1453614',3600.00,0.00,0.00,6.00,510.00,'2022-01-03 17:11:03','',''),(2432595,'1','140','773',331,'Return of Retail Sale Id 1450625',0.00,30000.00,50.00,0.00,-4250.00,'2022-01-03 20:29:59','',''),(2433024,'1','140','773',331,'Retail Sale Id 1453793',1800.00,0.00,0.00,3.00,255.00,'2022-01-04 06:26:41','',''),(2433047,'1','140','773',331,'Retail Sale Id 1453807',42504.00,0.00,0.00,84.00,-756.00,'2022-01-04 06:30:27','',''),(2433127,'1','140','773',331,'Retail Sale Id 1453874',25300.00,0.00,0.00,50.00,-450.00,'2022-01-04 06:51:09','',''),(2433140,'1','140','773',331,'Retail Sale Id 1453885',1200.00,0.00,0.00,2.00,170.00,'2022-01-04 06:53:29','',''),(2433168,'1','140','773',331,'Retail Sale Id 1453903',24794.00,0.00,0.00,49.00,-441.00,'2022-01-04 06:56:15','',''),(2433231,'1','140','773',331,'Retail Sale Id 1453953',4200.00,0.00,0.00,7.00,595.00,'2022-01-04 07:02:43','',''),(2433302,'1','140','773',331,'Retail Sale Id 1453992',3000.00,0.00,0.00,5.00,425.00,'2022-01-04 07:10:06','',''),(2433324,'1','140','773',331,'Retail Sale Id 1454019',1200.00,0.00,0.00,2.00,170.00,'2022-01-04 07:12:32','',''),(2433423,'1','140','773',331,'Retail Sale Id 1454106',3600.00,0.00,0.00,6.00,510.00,'2022-01-04 07:24:33','',''),(2433444,'1','140','773',331,'Retail Sale Id 1454126',29348.00,0.00,0.00,58.00,-522.00,'2022-01-04 07:26:45','',''),(2433473,'1','140','773',331,'Retail Sale Id 1454161',37950.00,0.00,0.00,75.00,-675.00,'2022-01-04 07:30:50','',''),(2433477,'1','140','773',331,'Retail Sale Id 1454167',1800.00,0.00,0.00,3.00,255.00,'2022-01-04 07:31:33','',''),(2433508,'1','140','773',331,'Retail Sale Id 1454199',1200.00,0.00,0.00,2.00,170.00,'2022-01-04 07:34:47','',''),(2433542,'1','140','773',331,'Retail Sale Id 1454234',2100.00,0.00,0.00,3.50,297.50,'2022-01-04 07:38:49','',''),(2433592,'1','140','773',331,'Retail Sale Id 1454289',30360.00,0.00,0.00,60.00,-540.00,'2022-01-04 07:45:42','',''),(2433643,'1','140','773',331,'Retail Sale Id 1454337',1200.00,0.00,0.00,2.00,170.00,'2022-01-04 07:51:15','',''),(2433655,'1','140','773',331,'Retail Sale Id 1454346',27830.00,0.00,0.00,55.00,-495.00,'2022-01-04 07:52:38','',''),(2433665,'1','140','773',331,'Retail Sale Id 1454361',600.00,0.00,0.00,1.00,85.00,'2022-01-04 07:53:38','',''),(2433816,'1','140','773',331,'Retail Sale Id 1454476',2530.00,0.00,0.00,5.00,-45.00,'2022-01-04 08:07:32','',''),(2433827,'1','140','773',331,'Retail Sale Id 1454489',3000.00,0.00,0.00,5.00,425.00,'2022-01-04 08:09:37','',''),(2434153,'1','140','773',331,'Retail Sale Id 1454746',1002.00,0.00,0.00,1.67,141.95,'2022-01-04 08:36:19','',''),(2434176,'1','140','773',331,'Retail Sale Id 1454758',3600.00,0.00,0.00,6.00,510.00,'2022-01-04 08:37:49','',''),(2434193,'1','140','773',331,'Retail Sale Id 1454776',12650.00,0.00,0.00,25.00,-225.00,'2022-01-04 08:39:24','',''),(2434248,'1','140','773',331,'Retail Sale Id 1454813',11100.00,0.00,0.00,18.50,1572.50,'2022-01-04 08:42:50','',''),(2434263,'1','140','773',331,'Retail Sale Id 1454829',3000.00,0.00,0.00,5.00,425.00,'2022-01-04 08:44:39','',''),(2434307,'1','140','773',331,'Retail Sale Id 1454869',1800.00,0.00,0.00,3.00,255.00,'2022-01-04 08:48:42','',''),(2434344,'1','140','773',331,'Retail Sale Id 1454903',1800.00,0.00,0.00,3.00,255.00,'2022-01-04 08:53:25','',''),(2434368,'1','140','773',331,'Retail Sale Id 1454929',3600.00,0.00,0.00,6.00,510.00,'2022-01-04 08:55:28','',''),(2434587,'1','140','773',331,'Retail Sale Id 1455154',30360.00,0.00,0.00,60.00,-540.00,'2022-01-04 09:19:09','',''),(2434605,'1','140','773',331,'Retail Sale Id 1455174',29854.00,0.00,0.00,59.00,-531.00,'2022-01-04 09:21:29','',''),(2434621,'1','140','773',331,'Retail Sale Id 1455189',10120.00,0.00,0.00,20.00,-180.00,'2022-01-04 09:23:21','',''),(2434638,'1','140','773',331,'Retail Sale Id 1455207',600.00,0.00,0.00,1.00,85.00,'2022-01-04 09:25:31','',''),(2434651,'1','140','773',331,'Retail Sale Id 1455222',2400.00,0.00,0.00,4.00,340.00,'2022-01-04 09:27:14','',''),(2434662,'1','140','773',331,'Retail Sale Id 1455233',7500.00,0.00,0.00,12.50,1062.50,'2022-01-04 09:28:31','',''),(2434673,'1','140','773',331,'Retail Sale Id 1455244',1200.00,0.00,0.00,2.00,170.00,'2022-01-04 09:29:27','',''),(2434686,'1','140',